﻿USE sofia;
DROP TABLE IF EXISTS sofia.cebulb_vpl;
CREATE TABLE cebulb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cebulb_vpl WRITE;
INSERT INTO cebulb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sa sinugdan gibuhat sa Dios ang mga langit ug ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ang kalibotan wala pay porma ug wala pay sulod. Ang kangitngit anaa sa ibabaw sa kinahiladman. Ang Espiritu sa Dios naglihok ibabaw sa mga katubigan. ");
INSERT INTO cebulb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ang Dios miingon, “Motungha ang kahayag,” ug mitungha ang kahayag. ");
INSERT INTO cebulb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nakita sa Dios ang kahayag, nga kini maayo. Gibahin niya ang kahayag gikan sa kangitngit. ");
INSERT INTO cebulb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gitawag sa Dios ang kahayag ug “adlaw,” ug ang kangitngit gitawag niya ug “gabii.” Mao kini ang kagabhion ug kabuntagon, ang unang adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ang Dios miingon, “Motungha ang usa ka wanang taliwala sa mga katubigan, ug bahinon niini ang mga tubig gikan sa katubigan.” ");
INSERT INTO cebulb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Gibuhat sa Dios ang wanang ug gibahin ang mga tubig nga anaa sa ilalom sa wanang gikan sa katubigan nga anaa ibabaw sa wanang. Nahitabo kini. ");
INSERT INTO cebulb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Gitawag sa Dios ang wanang ug “kawanangan.” Mao kini ang kagabhion ug ang kabuntagon, ang ikaduhang adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ang Dios miingon, “Ang tubig nga anaa ilalom sa kawanangan matigom sa usa ka dapit ug motungha ang mala nga yuta.” Nahitabo kini. ");
INSERT INTO cebulb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gitawag sa Dios ang mala nga dapit nga “yuta,” ug ang natigom nga mga tubig gitawag niya ug “kadagatan.” Nakita niya nga kini maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ang Dios miingon, “Moturok sa yuta ang mga tanom: mga tanom nga adunay binhi ug mga kahoy nga nagapamunga nga ang liso anaa sa sulod sa bunga, ang matag usa sumala sa ilang kaugalingong matang.” Nahitabo kini. ");
INSERT INTO cebulb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ang yuta naghatag ug mga tanom, mga tanom nga adunay binhi sumala sa ilang matang, ug mga kahoy nga nagapamunga nga ang bunga adunay liso sa sulod niini, sumala sa ilang matang. Nakita sa Dios nga kini maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mao kini ang kagabhion ug ang kabuntagon, ang ikatulong adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Miingon ang Dios, “Motungha ang mga kahayag diha sa kawanangan aron magbahin sa adlaw gikan sa gabii. Ug tugoti nga sila mahimong mga ilhanan, alang sa mga tempo, alang sa mga adlaw ug sa mga katuigan. ");
INSERT INTO cebulb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Himoa sila nga mahimong kahayag sa kawanangan aron maghatag ug kahayag sa kalibotan.” Nahitabo kini. ");
INSERT INTO cebulb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gibuhat sa Dios ang duha ka dagko nga mga kahayag, ug ang labing dako nga kahayag mao ang magdumala sa adlaw, ug ang dili kaayo hayag mao ang magdumala sa kagabhion. Gibuhat usab niya ang mga bituon. ");
INSERT INTO cebulb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Gibutang sila sa Dios sa kawanangan aron maghatag ug kahayag sa kalibotan, ");
INSERT INTO cebulb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","aron sa pagdumala sa adlaw ug sa kagabhion, ug sa pagbahin sa kahayag gikan sa kangitngit. Nakita sa Dios nga kini maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Mao kini ang kagabhion ug ang kabuntagon, ang ika-upat nga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Miingon ang Dios, “Pun-a ang katubigan sa mga buhing binuhat, ug tugoti nga molupad ang mga langgam ibabaw sa kayutaan diha sa haw-ang sa kawanangan.” ");
INSERT INTO cebulb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gihimo sa Dios ang dagkong mga mananap sa dagat, lakip ang uban pang buhing binuhat sumala sa iyang matang, mga binuhat nga nagalihok ug naglukop sa katubigan, ug matag langgam nga adunay pako sumala sa ilang matang. Nakita sa Dios nga kini maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Gipanalanginan sila sa Dios, nga nag-ingon, “Pagmabungahon ug panaghan, ug pun-a ninyo ang katubigan sa kadagatan. Managhan ang mga langgam sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mao kini ang kagabhion ug ang kabuntagon, ang ikalimang adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ang Dios miingon, “Motungha sa yuta ang mga buhing binuhat, sumala sa matag matang niini, mga binuhing mga mananap, mga mananap nga nagakamang, ug mga mapintas nga mananap sa kalibotan, sumala sa matag matang niini.” Nahitabo kini. ");
INSERT INTO cebulb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gibuhat sa Dios ang mapintas nga mga mananap sa kalibotan sumala sa ilang matang, ang binuhing mga mananap sumala sa ilang matang, ug ang tanang nagakamang ibabaw sa yuta sumala sa matang niini. Nakita niya nga kini maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Miingon ang Dios, “Buhaton nato ang tawo sama sa atong hulagway, sunod kanato. Magdumala sila sa mga isda sa dagat, sa mga langgam sa kawanangan, sa mga binuhing mga mananap, sa tibuok kalibotan, ug sa matag mananap nga nagakamang sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Gibuhat sa Dios ang tawo sama sa iyang hulagway. Gibuhat niya siya sama sa iyang kaugalingong panagway. Gibuhat niya ang babaye ug ang lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Gipanalanginan sila sa Dios ug miingon kanila, “Pagmabungahon, ug pagpadaghan. Pun-a ang kalibotan, ug lukopa kini. Pagdumala ngadto sa tanang isda sa dagat, ngadto sa mga kalanggaman sa kawanangan, ug ngadto sa tanang buhing mananap nga nagalihok sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Miingon ang Dios, “Tan-awa, gihatag ko kaninyo ang tanang tanom nga nagahatag ug binhi nga anaa sa tibuok kalibotan, ug ang matag kahoy nga nagapamunga nga adunay liso. Mahimo ninyo kining pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Sa matag mapintas nga mananap sa kalibotan, sa matag langgam sa kalangitan, ug sa tanang mananap nga nagakamang sa kalibotan, ug sa matag binuhat nga adunay gininhawa sa kinabuhi gihatag ko ang lunhaw nga tanom aron makaon.” Nahitabo kini. ");
INSERT INTO cebulb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nakita sa Dios ang tanang butang nga iyang gibuhat. Tan-awa, kini maayo kaayo. Mao kini ang kagabhion ug ang kabuntagon, ang ikaunom nga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Unya ang mga langit ug ang yuta nahuman na, ug ang tanang buhing binuhat nga nipuno niini. ");
INSERT INTO cebulb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sa ikapito nga adlaw nahuman sa Dios ang iyang buluhaton, ug busa mipahulay siya sa ikapito nga adlaw gikan sa tanan nga iyang gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gipanalanginan sa Dios ang ikapito nga adlaw ug gibalaan kini, tungod kay mipahulay siya niini gikan sa tanan nga iyang gibuhat sa iyang mga binuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mao kini ang mga panghitabo mahitungod sa mga langit ug sa yuta, sa dihang gibuhat sila, sa adlaw nga gibuhat ni Yahweh nga Dios ang yuta ug ang kalangitan. ");
INSERT INTO cebulb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Wala pay sagbot sa uma nga anaa sa kayutaan, ug wala pay tanom nga miturok sa uma, tungod kay wala pa man gipaulanan ni Yahweh nga Dios ang kalibotan, ug wala pay tawo nga mag-uma sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Apan adunay yamog nga migawas gikan sa kalibotan ug nagpatubig sa tibuok kayutaan. ");
INSERT INTO cebulb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Gihimo ni Yahweh nga Dios ang tawo gikan sa abog sa yuta, ug gihuypan ang bangag sa iyang ilong sa gininhawa sa kinabuhi, ug ang tawo nahimong buhing binuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nagbutang si Yahweh nga Dios ug usa ka tanaman sa sidlakang bahin sa Eden, ug didto gibutang niya ang tawo nga iyang hinimo. ");
INSERT INTO cebulb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Gikan sa yuta gipatubo ni Yahweh nga Dios ang matag kahoy nga nindot tan-awon ug maayong kaonon. Lakip na niini ang kahoy sa kinabuhi nga anaa sa taliwala sa tanaman, ug ang kahoy sa kahibalo sa maayo ug sa daotan. ");
INSERT INTO cebulb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Usa ka suba ang midagayday gikan sa Eden aron patubigan ang tanaman. Gikan didto kini nabahin ug nahimong upat ka mga suba. ");
INSERT INTO cebulb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ang ngalan sa una nga suba mao ang Pishon. Mao kini ang midagayday sa tibuok yuta sa Habila, diin adunay bulawan. ");
INSERT INTO cebulb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ang bulawan nianang yutaa maayo. Didto adunay bedelyom usab ug bato nga onise. ");
INSERT INTO cebulb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ang ngalan sa ikaduhang suba mao ang Gihon. Kini midagayday paingon sa tibuok yuta sa Cus. ");
INSERT INTO cebulb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ang ngalan sa ikatulo nga suba mao ang Tigris, nga midagayday sa sidlakang bahin sa Asur. Ang ika-upat nga suba mao ang Eufrates. ");
INSERT INTO cebulb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Gikuha ni Yahweh nga Dios ang lalaki ug gibutang niya didto sa tanaman sa Eden aron magtrabaho niini ug aron mag-atiman niini. ");
INSERT INTO cebulb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Si Yahweh nga Dios nagmando sa lalaki, nga nag-ingon, “Gawasnon ka nga mokaon gikan sa matag kahoy sa tanaman. ");
INSERT INTO cebulb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Apan dili ka angay nga mokaon gikan sa kahoy sa kahibalo sa maayo ug sa daotan, kay sa adlawa nga mokaon ka gikan niini, sigurado gayod nga mamatay ka.” ");
INSERT INTO cebulb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Unya si Yahweh nga Dios miingon, “Dili maayo alang sa lalaki nga mag-inusara. Himoan ko siya ug katabang nga angay kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Gikan sa yuta giumol ni Yahweh nga Dios ang tanang hayop sa kaumahan ug mga langgam sa kawanangan. Unya gidala niya sila ngadto sa lalaki aron makita kung unsa ang iyang itawag sa ila. Kung unsay itawag sa lalaki sa mga buhing binuhat, kana mao ang ilang ngalan. ");
INSERT INTO cebulb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Gihatagan ug ngalan sa lalaki ang tanang kahayopan, ang tanang langgam sa kawanangan, ug ang tanang mapintas nga mananap sa kaumahan. Apan alang sa lalaki wala siyay nakita nga katabang nga angay kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gipakatulog ug maayo ni Yahweh nga Dios ang lalaki, busa nakatulog ang lalaki. Nikuha si Yahweh nga Dios ug usa ka gusok ug gisirado niya ang unod kung asa niya gikuha ang gusok. ");
INSERT INTO cebulb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gamit ang gusok nga gikuha ni Yahweh nga Dios gikan sa lalaki, gihimo niya kini ang babaye ug gidala siya ngadto sa lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ang lalaki miingon, “Karon, kini mao ang bukog sa akong bukog, ug unod sa akong unod. Pagatawgon siya nga 'babaye,' kay gikuha man siya gikan sa lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tungod niini ang lalaki mobiya sa iyang amahan ug sa iyang inahan, ug siya mahiusa sa iyang asawa, ug mahimo silang usa ka unod. ");
INSERT INTO cebulb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Hubo silang duha, ang lalaki ug ang iyang asawa, apan wala sila naulaw. ");
INSERT INTO cebulb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Karon ang serpente mas labing mautok kay sa ubang mapintas nga mananap sa tanaman nga binuhat ni Yahweh nga Dios. Siya miingon ngadto sa babaye, “Miingon ba gayod ang Dios nga, 'Kinahanglan nga dili kamo mokaon gikan sa bisan unsa nga kahoy sa tanaman'”? ");
INSERT INTO cebulb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ang babaye miingon sa serpente, “Makakaon kami sa tanang bunga sa kahoy sa tanaman, ");
INSERT INTO cebulb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","apan mahitungod sa bunga sa kahoy nga anaa taliwala sa tanaman, ang Dios miingon, 'Ayaw kamo pagkaon niini, o bisan paghikap niini, o kamo mamatay.'” ");
INSERT INTO cebulb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ang serpente miingon sa babaye, “Dili gayod kamo mamatay. ");
INSERT INTO cebulb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kay ang Dios nasayod nga sa panahon nga mokaon kamo niini maabli ang inyong mga mata, ug mahisama kamo sa Dios, nga nasayod sa maayo ug daotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sa dihang nakita sa babaye nga ang kahoy maayo nga kan-on, ug kini nindot sa mga mata, ug ang kahoy makadani nga makahimo sa tawo nga maalamon, mikuha siya sa bunga ug mikaon niini. Ug gihatagan niya ang iyang bana nga uban kaniya, ug mikaon siya niini. ");
INSERT INTO cebulb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ang ilang mga mata nangaabli, ug nakamatngon sila nga sila hubo. Mitahi sila ug mga dahon sa igera ug gihimo nga pangtabon sa ilang mga kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nadunggan nila ang kasikas ni Yahweh nga Dios nga nagalakaw sa tanaman sa kabugnaw sa adlaw, busa ang lalaki ug ang iyang asawa nanago gikan sa presensiya ni Yahweh nga Dios taliwala sa mga kahoy sa tanaman. ");
INSERT INTO cebulb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Gitawag ni Yahweh nga Dios ang lalaki ug miingon ngadto kaniya, “Hain ka man?” ");
INSERT INTO cebulb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ang lalaki miingon, “Nadungog ko ikaw sa tanaman, ug nahadlok ako, tungod kay hubo ako. Busa mitago ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ang Dios miingon, “Kinsa may nagsulti kanimo nga ikaw hubo? Mikaon ka ba sa kahoy nga akong gisugo kanimo nga dili nimo angay kan-on?” ");
INSERT INTO cebulb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ang lalaki miingon, “Ang babaye nga imong gihatag aron akong makauban, iya akong gihatagan sa bunga nga gikan sa kahoy, ug ako kining gikaon.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Miingon si Yahweh nga Dios sa babaye, “Unsa kining imong gibuhat?” Ang babaye miingon, “Ang serpente milingla kanako, ug mikaon ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Si Yahweh nga Dios miingon sa serpente, “Tungod kay imo kining gibuhat, tali sa tanang kahayopan ug sa tanang mga mapintas nga mananap sa kaumahan ikaw lamang ang tinunglo. Pinaagi sa imong tiyan ikaw magakamang, ug ikaw magakaon sa abog sa tanang adlaw sa imong kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Magbutang ako ug panag-away tali kanimo ug sa babaye, ug tali sa imong binhi ug sa iyang binhi. Samaran niya ang imong ulo, ug imong samaran ang iyang tikod.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Miingon siya ngadto sa babaye, “Pilopiloon ko gayod ang imong kasakit sa pagbaton ug mga anak; diha sa kasakit nga ikaw magbaton ug mga anak. Ang imong tinguha mao ang pagpangandoy sa imong bana, apan siya ang magdumala kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Miingon siya ngadto kang Adan, “Tungod kay naminaw ka sa tingog sa imong asawa, ug mikaon gikan sa kahoy, nga akong gisugo kanimo, nga naga-ingon, 'Dili ka magakaon gikan niini,' matinunglo ang yuta tungod kanimo; sa hilabihang kahago ikaw mokaon gikan niini sa tanang adlaw sa imong kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Magahatag kini ug mga tunok ug mga sampinit alang kanimo, ug mokaon ka sa mga tanom sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Pinaagi sa mga singot sa imong nawong ikaw makakaon ug tinapay, hangtod nga mobalik ka sa yuta, kay ikaw gihimo gikan niini. Kay ikaw abog man, ug ngadto sa abog ikaw mobalik.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ginganlan sa lalaki ug Eva ang iyang asawa tungod kay siya ang inahan sa tanang may kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nagbuhat si Yahweh nga Dios ug sapot gikan sa mga panit sa mananap alang kang Adan ug sa iyang asawa ug gibistihan sila. ");
INSERT INTO cebulb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Si Yahweh nga Dios miingon, “Karon ang tawo nahimong sama na kanato, nga nasayod sa maayo ug sa daotan. Busa karon kinahanglan dili na siya tugotan nga makakab-ot niini sa iyang kamot, ug makakuha gikan sa kahoy sa kinabuhi, makakaon niini, ug unya mabuhi sa kahangtoran.” ");
INSERT INTO cebulb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Busa gipagawas siya ni Yahweh nga Dios gikan sa tanaman sa Eden, aron sa pag-uma sa yuta diin siya naggikan. ");
INSERT INTO cebulb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Busa gipahawa sa Dios ang tawo sa tanaman, ug gibutangan niya ug kerubin ang sidlakang bahin sa tanaman sa Eden, ug nagadilaab nga espada nga nagtuyoktuyok sa palibot, aron sa pagbantay sa dalan paingon sa kahoy sa kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ang lalaki nidulog kang Eva nga iyang asawa. Nagmabdos siya ug nanganak kang Cain. Siya miingon, “Nakabaton ako ug anak nga lalaki sa tabang ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Unya nanganak siya kang Abel nga igsoong lalaki ni Cain. Karon si Abel nahimong magbalantay sa karnero, apan si Cain nag-uma sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Miabot ang panahon nga nagdala si Cain ug pipila sa abot sa yuta ingon nga halad kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ingon man si Abel, midala siya ug pipila sa kinamagulangan nga anak sa iyang panon ug pipila sa mga tambok. Gidawat ni Yahweh si Abel ug ang iyang halad, ");
INSERT INTO cebulb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","apan wala niya gidawat si Cain ug ang iyang halad. Mao nga si Cain nasuko pag-ayo, ug siya nagmug-ot. ");
INSERT INTO cebulb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Si Yahweh miingon kang Cain, “Nganong nasuko ug nganong nagmug-ot ka man? ");
INSERT INTO cebulb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kung imong gibuhat ang husto, dili ba diay ikaw pagadawaton? Apan kung wala nimo buhata ang husto, ang sala nagahulat sa pultahan ug nagtinguha sa pagdumala kanimo, apan kinahanglan nga ikaw ang magdumala niini.” ");
INSERT INTO cebulb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nakig-sulti si Cain sa iyang igsoon nga si Abel. Samtang anaa na sila didto sa kaumahan, si Cain mibarog batok kay Abel nga iyang igsoon ug gipatay siya. ");
INSERT INTO cebulb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Unya si Yahweh miingon kang Cain, “Asa man ang imong igsoon nga si Abel?” Siya miingon, “Wala ako masayod. Ako ba ang magbalantay sa akong igsoon?” ");
INSERT INTO cebulb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Si Yahweh miingon, “Unsa kining imong gibuhat? Ang dugo sa imong igsoon nagatawag kanako gikan sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Karon tinunglo ka nga gikan sa yuta, nga miabli sa iyang baba aron sa pagdawat sa dugo sa imong igsoon gikan sa imong kamot. ");
INSERT INTO cebulb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sa dihang imong umahon ang yuta, gikan karon dili na kini maghatag sa iyang kusog alang kanimo. Magtagotago ug maglatagaw ka sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Si Cain miingon kang Yahweh, “Ang akong silot mas dako kaysa sa akong makaya. ");
INSERT INTO cebulb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Sa pagkatinuod, imo akong ipapahawa karong adlawa niining yutaa, ug matago na ako gikan kanimo. Magtagotago ug maglatagaw ako sa kalibotan, ug si bisan kinsa ang makakita kanako mopatyon kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Si Yahweh miingon kaniya, “Si bisan kinsa nga mopatay kang Cain, ang panimalos moabot kaniya sa pitoan ka pilo.” Unya gibutangan ni Yahweh ug patik si Cain, aron nga kung kinsa man ang makakaplag kaniya, kanang tawhana dili moataki kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Busa mibiya si Cain sa presensiya ni Yahweh ug mipuyo sa yuta sa Nod, sa sidlakang bahin sa Eden. ");
INSERT INTO cebulb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nakigdulog si Cain sa iyang asawa ug nagmabdos siya. Nanganak siya kang Enoc. Nagtukod siya ug siyudad ug ginganlan niya kini sunod sa ngalan sa iyang anak nga si Enoc. ");
INSERT INTO cebulb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ngadto kang Enoc natawo si Irad. Si Irad nahimong amahan ni Mehujael. Si Mehujael nahimong amahan ni Methushael. Si Methushael nahimong amahan ni Lamec. ");
INSERT INTO cebulb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Si Lamec nagkuha ug duha ka mga asawa alang sa iyang kaugalingon: ang ngalan sa usa mao si Ada, ug ang ngalan sa lain pa mao si Zila. ");
INSERT INTO cebulb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Si Ada nanganak kang Jabal. Siya ang amahan niadtong nagpuyo sa tolda nga adunay mga kahayopan. ");
INSERT INTO cebulb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ang ngalan sa iyang igsoon nga lalaki mao si Jubal. Siya ang amahan niadtong nagatugtog ug alpa ug plawta. ");
INSERT INTO cebulb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ug si Zila nanganak kang Tubal Cain, ang nagahimo ug mga gamit nga gikan sa bronse ug puthaw. Ang igsoon nga babaye ni Tubal Cain mao si Naama. ");
INSERT INTO cebulb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Si Lamec miingon sa iyang mga asawa, “Ada ug Zila, paminawa ang akong tingog; kamo nga mga asawa ni Lamec, paminawa kung unsa ang akong isulti. Tungod kay nakapatay ako ug batan-on nga lalaki nga nagsamad kanako, usa ka batan-on nga lalaki nga nagbun-og kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kung adunay pito ka pilo nga balos alang kang Cain, unya adunay 77 ka pilo nga balos alang kang Lamec.” ");
INSERT INTO cebulb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nakigdulog na usab si Adan sa iyang asawa, ug nanganak siya ug laing anak nga lalaki. Iya kining ginganlan ug Set ug miingon, “Ang Dios naghatag kanako ug laing anak nga lalaki nga puli kang Abel, kay gipatay man siya ni Cain.” ");
INSERT INTO cebulb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Adunay anak nga lalaki nga natawo gikan kang Set ug iya siyang gitawag sa ngalan nga Enos. Nianang panahona ang mga tawo nagsugod na sa pagtawag sa ngalan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Mao kini ang listahan sa mga kaliwat ni Adan. Sa adlaw nga gibuhat sa Dios ang tawo, gibuhat niya sila nga sama kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gibuhat niya sila nga lalaki ug babaye. Gipanalanginan niya sila ug ginganlan sila ug tawo sa dihang sila gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sa dihang nagpangidaron na si Adan ug 130 ka tuig, nahimo siyang amahan sa anak nga lalaki nga sama kaniya, sunod sa iyang panagway ug ginganlan niya siya ug Set. ");
INSERT INTO cebulb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Human si Adan nahimong amahan ni Set, nagkinabuhi pa siya ug 800 ka tuig. Ug nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Si Adan nagkinabuhi ug 930 ka tuig, ug unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sa dihang nagpangidaron na si Set ug 105 ka tuig, nahimo siyang amahan ni Enos. ");
INSERT INTO cebulb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Human siya nahimong amahan ni Enos, nagkinabuhi pa siya ug 807 ka tuig ug nahimong amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nagkinabuhi si Set ug 912 ka tuig, ug unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sa dihang nagpangidaron na si Enos ug 90 ka tuig, nahimo siyang amahan ni Kenan. ");
INSERT INTO cebulb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Human siya nahimong amahan ni Kenan, nagkinabuhi pa si Enos ug 815 ka tuig. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Si Enos nagkinabuhi ug 905 ka tuig, ug unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sa dihang nagpangidaron na si Kenan ug 70 ka tuig, nahimo siyang amahan ni Mahalalel. ");
INSERT INTO cebulb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Human siya nahimong amahan ni Mahalalel, nagkinabuhi pa si Kenan sulod sa 840 ka tuig. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Si Kenan nagkinabuhi ug 910 ka tuig, ug unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sa dihang nagpangidaron na si Mahalalel ug 65 ka tuig, nahimo siyang amahan ni Jared. ");
INSERT INTO cebulb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Human siya nahimong amahan ni Jared, nagkinabuhi si Mahalalel sulod sa 830 ka tuig. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nagkinabuhi si Mahalalel ug 895 ka tuig, ug unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sa dihang nagpangidaron na si Jared ug 162 ka tuig, nahimo siyang amahan ni Enoc. ");
INSERT INTO cebulb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Human siya nahimong amahan ni Enoc, nagkinabuhi pa si Jared ug 800 ka tuig. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nagkinabuhi si Jared ug 962 ka tuig, ug unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Sa dihang nagpangidaron na si Enoc ug 65 ka tuig, nahimo siyang amahan ni Metusela. ");
INSERT INTO cebulb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Naglakaw si Enoc uban sa Dios sulod sa 300 ka tuig human siya nahimong amahan ni Metusela. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Nagkinabuhi si Enoc ug 365 ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Si Enoc naglakaw uban sa Dios, ug unya nawala siya, kay gikuha man siya sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Sa dihang nagpangidaron na si Metusela ug 187 ka tuig, nahimo siyang amahan ni Lamec. ");
INSERT INTO cebulb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Human siya nahimong amahan ni Lamec, si Metusela nagkinabuhi pa ug 782 ka tuig. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Si Metusela nagpangidaron ug 969 ka tuig. Unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Sa dihang nagpangidaron na si Lamec ug 182 ka tuig, nahimo siyang amahan sa usa ka anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ginganlan niya siya ug Noe, nga nag-ingon, “Siya maoy maghatag kanato ug kapahulayan gikan sa atong mga pagpaningkamot ug gikan sa kahago sa atong mga kamot, nga mao ang angay natong buhaton tungod sa yuta nga gitunglo ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nagkinabuhi si Lamec ug 595 ka tuig human siya nahimong amahan ni Noe. Nahimo siyang amahan sa daghan pang anak nga mga lalaki ug mga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Nagkinabuhi si Lamec ug 777 ka tuig. Unya siya namatay. ");
INSERT INTO cebulb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Human sa pagkinabuhi ni Noe ug 500 ka tuig, nahimo siyang amahan nila Sem, Ham, ug Jafet. ");
INSERT INTO cebulb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Miabot ang panahon nga ang katawhan midaghan sa kalibotan ug nanganak sila ug mga babaye, ");
INSERT INTO cebulb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","nakita sa mga anak sa Dios nga maanyag ang mga babayeng anak sa mga tawo. Ilaha kining gikuha ug gihimo nga mga asawa, bisan kinsa kanila nga ilang napili. ");
INSERT INTO cebulb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Si Yahweh miingon, “Ang akong espiritu dili magpabilin sa katawhan hangtod sa kahangtoran, tungod kay sila mga unod. Mabuhi sila sulod sa 120 ka tuig.” ");
INSERT INTO cebulb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Niadtong mga panahona adunay mga higante sa kalibotan, ug bisan sa sunod nga panahon. Nahitabo kini sa dihang giminyoan sa mga anak sa Dios ang mga anak nga babaye sa mga tawo, ug nakabaton sila ug mga anak kanila. Mao kini ang mga kusgan nga mga tawo kaniadto, mga tawong bantogan. ");
INSERT INTO cebulb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nakita ni Yahweh nga dako ang pagkadaotan sa tawo diha sa kalibotan, ug ang matag tinguha sa hunahuna sa ilang mga kasingkasing nagpadayon nga daotan. ");
INSERT INTO cebulb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nagbasol si Yahweh nga gibuhat niya ang tawo sa kalibotan, ug nakapasubo kini sa iyang kasingkasing. ");
INSERT INTO cebulb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Unya si Yahweh miingon, “Pagalaglagon ko ang katawhan nga akong gibuhat gikan sa ibabaw sa kalibotan; ang katawhan ug ang dagkong mga mananap, ang mga nagakamang nga mga mananap ug ang mga langgam sa kalangitan, kay nagbasol ako nga gibuhat ko sila.” ");
INSERT INTO cebulb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Apan si Noe nakakaplag ug pabor sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Mao kini ang mga panghitabo nga may kalabotan kang Noe. Si Noe usa ka matarong nga tawo, ug wala siya'y sala taliwala sa mga tawo sa iyang kapanahonan. Si Noe naglakaw uban sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Si Noe nahimong amahan sa tulo ka anak nga mga lalaki: si Sem, si Ham, ug si Jafet. ");
INSERT INTO cebulb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ang kalibotan hugaw na sa atubangan sa Dios, ug napuno kini sa pagkadaotan. ");
INSERT INTO cebulb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nakita sa Dios ang kalibotan; tan-awa, hugaw na kini, kay gihugawan sa tanang unod ang ilang paggawi sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ang Dios miingon kang Noe, “Akong nakita nga panahon na nga tapuson ang tanang unod, kay napuno sa pagkamapintas ang kalibotan pinaagi kanila. Tinuod gayod, laglagon ko sila uban ang kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Pagbuhat ug arka nga gikan sa kahoy nga cipros alang sa imong kaugalingon. Paghimo ug mga lawak sa arka, buliti kini ug alkitran sa sulod ug sa gawas. ");
INSERT INTO cebulb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ingon niini ang imong pagabuhaton: ang katas-on sa arka mokabat ug 300 ka kubiko, 50 ka kubiko ang gilapdon, ug 30 ka kubiko ang kahabugon. ");
INSERT INTO cebulb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Pagbuhat ug atop alang sa arka, ug humana kini sa usa ka kubiko gikan sa taas sa kilid niini. Pagbutang ug pultahan sa kilid sa arka ug buhati kini ug pinakaubos, ikaduha, ug ikatulo nga andana. ");
INSERT INTO cebulb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Paminaw, padad-an ko ug dakong lunop sa tubig ang kalibotan, aron laglagon ang tanang unod nga adunay gininhawa sa kinabuhi ilalom sa kalangitan. Mangamatay ang tanan nga anaa sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Apan pagabuhaton ko ang akong saad diha kanimo. Mosulod ka sa arka, ikaw, ug ang imong mga anak nga lalaki, ug ang imong asawa, ug ang mga asawa sa imong mga anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Sa matag buhing binuhat sa tanang unod, kinahanglan nga magdala ka ug tinagduha sa matag matang ngadto sa arka, aron mabuhi sila uban kanimo, laki ug baye. ");
INSERT INTO cebulb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sa mga langgam sumala sa ilang matang, ug ang matag matang sa dagko nga mga mananap, sa matag matang sa mananap nga nagakamang sa yuta, tinagduha sa nagkadaiyang matang ang mokuyog kanimo, aron mabuhi sila. ");
INSERT INTO cebulb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Pagtigom ug matag matang sa pagkaon ug tipigi kini, aron aduna kamoy makaon lakip na sila.” ");
INSERT INTO cebulb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Busa gibuhat kini ni Noe. Sumala sa tanan nga gimando kaniya sa Dios, iya kining gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Si Yahweh miingon kang Noe, “Dali, ikaw ug ang tibuok mong panimalay, sulod sa arka, kay nakita nako nga ikaw ra ang matarong sa akong atubangan niining kaliwatana. ");
INSERT INTO cebulb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sa matag hinlo nga mananap pagdala ug pito ka parisan nga laki ug baye. Ug sa mga mananap nga dili hinlo, pagdala ug duha, laki ug ang iyang pares. ");
INSERT INTO cebulb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ingon man ang mga langgam sa kawanangan, pagdala ug pito ka parisan sa laki ug baye, aron magpabilin ang ilang kaliwat ibabaw sa tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kay sa ikapito ka adlaw paulanon ko ang kalibotan sulod sa 40 ka adlaw ug 40 ka gabii. Pagalaglagon ko gikan sa yuta ang tanang buhi nga binuhat nga akong gihimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Gituman ni Noe ang tanan nga gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nagpangidaron si Noe ug 600 ka tuig sa dihang ang lunop miabot sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Misulod sa arka si Noe, ang iyang mga anak nga lalaki, ang iyang asawa, ug ang mga asawa sa iyang mga anak tungod sa tubig sa lunop. ");
INSERT INTO cebulb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ang mga mananap nga hinlo ug mga mananap nga dili hinlo, mga langgam, ug ang tanan nga nagakamang sa yuta, ");
INSERT INTO cebulb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sa tinagduha, laki ug baye, miduol kang Noe ug nanulod ngadto sa arka, sumala sa gisugo sa Dios kang Noe. ");
INSERT INTO cebulb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Unya human sa pito ka adlaw, ang tubig sa lunop miabot sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Sa ika-600 ka tuig sa kinabuhi ni Noe, sa ikaduhang bulan, sa ika-17 nga adlaw sa bulan, sa maong adlaw, mibuhagay ang tanang tubod sa kinahiladman, ug nangaabli ang mga tamboanan sa langit. ");
INSERT INTO cebulb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Misugod sa pagbundak ang ulan sa kalibotan sulod sa 40 ka adlaw ug 40 ka gabii. ");
INSERT INTO cebulb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nianang samang adlawa si Noe ug ang iyang mga anak nga lalaki, si Sem, si Ham, ug si Jafet, ug ang asawa ni Noe, ug ang tulo ka mga asawa sa iyang mga anak nga lalaki nga uban kanila, misulod ngadto sa arka. ");
INSERT INTO cebulb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nanulod sila uban ang matag ihalas nga mananap sumala sa ilang matang, ug matag binuhi nga mga mananap sumala sa ilang matang, ug ang mga nagakamang nga mananap ibabaw sa kalibotan sumala sa ilang matang, ug ang langgam sumala sa ilang matang, ug matag matang sa binuhat nga adunay pako. ");
INSERT INTO cebulb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Duha sa tanang unod nga adunay gininhawa sa kinabuhi misulod sa arka uban kang Noe. ");
INSERT INTO cebulb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ug ang mga mananap nga nanulod mao ang mga laki ug baye sa tanang binuhat; misulod sila sumala sa gisugo sa Dios kaniya. Unya pagkahuman gisirad-an ni Yahweh ang pultahan. ");
INSERT INTO cebulb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Unya miabot ang lunop sa kalibotan sa 40 ka adlaw, ug milawom pag-ayo ang tubig ug milutaw ang arka. Naglutaw kini ibabaw sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mihaganas ang tubig ug midako pa gayod ibabaw sa yuta, ug milutaw ang arka ibabaw sa tubig. ");
INSERT INTO cebulb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ug hilabihan gayod ang pagtaas sa tubig sa kalibotan. Hingpit nga gilapawan niini ang tanang tag-as nga bukid nga anaa sa ilalom sa tibuok kalangitan. ");
INSERT INTO cebulb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Milapaw pa gayod ang tubig ug 15 ka kubiko ibabaw sa kabukiran. ");
INSERT INTO cebulb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nangamatay ang tanang may kinabuhi nga nagalihok ibabaw sa kalibotan: ang mga langgam, mga binuhi nga mananap, mga ihalas nga mga mananap, ang tanang mga binuhat nga nagakamang sa yuta, ug ang tanang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ang tanang mga binuhat nga may gininhawa sa espiritu sa kinabuhi, ang tanang anaa sa mala nga yuta, nangamatay. ");
INSERT INTO cebulb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Busa nangahanaw ang tanang butang nga may kinabuhi ibabaw sa yuta, gikan sa mga tawo ngadto sa dagko nga mga mananap, sa nagakamang nga mga mananap, ug ngadto sa mga kalanggaman sa kawanangan. Nangalaglag silang tanan nga gikan sa yuta. Si Noe lamang ug kadtong kauban niya sa arka ang nahibilin. ");
INSERT INTO cebulb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Gilunopan sa tubig ang kalibotan sulod sa 150 ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Giisip sa Dios si Noe, ang tanang mga ihalas nga mananap, ug ang tanang binuhi nga mananap nga uban kaniya sa arka. Gipatayhop sa Dios ang hangin sa tibuok kalibotan, ug misugod paghubas ang tubig. ");
INSERT INTO cebulb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ang mga tubod sa kinahiladman ug ang mga tamboanan sa langit gisirad-an, ug miundang na sa pag-ulan. ");
INSERT INTO cebulb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nagpadayon sa paghubas ang tubig sa lunop diha sa kalibotan. Ug human sa 150 ka adlaw, mihubas na gayod ang tubig. ");
INSERT INTO cebulb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ug sa ikapito nga bulan, sa ika-17 nga adlaw sa bulan nakatungtong na ang arka ibabaw sa kabukiran sa Ararat. ");
INSERT INTO cebulb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nagpadayon sa paghubas ang tubig hangtod sa ikanapulo nga bulan. Sa unang adlaw sa bulan, nakita na ang mga tumoy sa kabukiran. ");
INSERT INTO cebulb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Miabot human sa 40 ka adlaw nga giablihan ni Noe ang tamboanan sa arka nga iyang gihimo. ");
INSERT INTO cebulb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Gisugo niya ang uwak ug naglupadlupad kini hangtod nga mihubas na ang tubig sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Unya nagpalupad siya ug salampati aron masuta kung mihubas na ang tubig sa yuta, ");
INSERT INTO cebulb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","apan walay nakaplagan nga katugpahan ang salampati aron iyang pahulayan, ug mibalik kini ngadto kaniya sa arka, kay natabonan pa gihapon ug tubig ang tibuok kalibotan. Gipagawas niya ang iyang kamot, ug gikuha ug gipasulod kini ngadto sa arka uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Mihulat pa siya ug dugang pito ka adlaw unya gipalupad niya pag-usab ang salampati gikan sa arka. ");
INSERT INTO cebulb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mibalik ang salampati ngadto kaniya sa pagkagabii. Tan-awa! Adunay bag-ong kinutlo nga dahon sa olibo sa iyang sungo. Busa nasayran ni Noe nga mihubas na ang tubig sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mihulat pa siya ug dugang pang pito ka adlaw, ug gipalupad niya pag-usab ang salampati. Ug wala na kini mibalik pag-usab kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nahitabo sa ika-601 ka tuig, sa unang bulan, sa unang adlaw sa bulan, nga nihubas na ang tubig sa kalibotan. Gikuha ni Noe ang tabon sa arka, ug mitan-aw sa gawas, ug nakita niya nga mala na ang ibabaw sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sa ikaduhang bulan, sa ika-27 nga adlaw sa bulan, namala na ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ang Dios miingon kang Noe, ");
INSERT INTO cebulb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gawas na sa arka, ikaw, ang imong asawa, ang imong mga anak nga lalaki, ug ang mga asawa sa imong mga anak nga lalaki nga uban kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pagawasa na uban kanimo ang tanang buhing binuhat nga adunay unod, lakip na ang mga langgam, ang binuhi nga mga mananap, ug ang tanang mananap nga nagakamang sa yuta, aron managsanay sila sa tibuok kalibotan, magmabungahon, ug managhan sa ibabaw sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Busa migawas si Noe uban ang iyang mga anak nga lalaki, iyang asawa, ug ang mga asawa sa iyang mga anak uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nanggawas sa arka ang tanang buhi nga binuhat, ang tanang nagakamang nga mananap, ug ang tanang langgam, ang tanan nga nagalihok ibabaw sa yuta, sumala sa ilang banay. ");
INSERT INTO cebulb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nagtukod si Noe ug usa ka halaran alang kang Yahweh. Mikuha siya ug pipila ka hinlo nga mga mananap ug pipila ka hinlo nga mga langgam, ug naghalad siya ug sinunog nga mga halad ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nasimhotan ni Yahweh ang mahumot nga aso ug miingon sa iyang kasingkasing, “Dili ko na tunglohon pag-usab ang kalibotan tungod sa mga katawhan, bisan pa ug daotan ang gitinguha sa ilang mga kasingkasing sukad pa sa ilang pagkabata. Dili ko na laglagon pag-usab ang tanang may kinabuhi, sama sa akong gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Samtang anaa pa ang kalibotan, ang tingtanom ug ting-ani, ang bugnaw ug ang init, ang ting-init ug ting-tugnaw, ug ang adlaw ug gabii dili mohunong.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Unya gipanalanginan sa Dios si Noe ug ang iyang mga anak nga lalaki, ug miingon ngadto kanila, “Pagmabungahon, pagpadaghan, ug pun-a ang kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mangahadlok ug malisang kaninyo ang matag buhing mananap sa kalibotan, ang tanang kalanggaman sa kawanangan, ang tanang nagakamang sa yuta, ug ang tanang isda sa kadagatan. Gihatag sila diha sa inyong kamot. ");
INSERT INTO cebulb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ang tanang molihok nga butang nga buhi mahimong pagkaon alang kaninyo. Sama nga gihatag ko kaninyo ang mga lunhaw nga mga tanom, karon ihatag ko kaninyo ang tanang butang. ");
INSERT INTO cebulb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Apan kinahanglan nga dili kamo mokaon sa karne nga adunay kinabuhi—nga adunay dugo—niini. ");
INSERT INTO cebulb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Apan alang sa inyong dugo, ang kinabuhi nga anaa sa inyong dugo, nagkinahanglan ako ug bayad. Gikan sa kamot sa matag mananap nagkinahanglan ako niini. Gikan sa kamot sa bisan kinsang tawo, gikan sa kamot sa tawo nga nagpatay sa iyang igsoon, nagkinahanglan ako ug bayad alang sa kinabuhi nianang tawhana. ");
INSERT INTO cebulb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Si bisan kinsa nga mag-ula sa dugo sa tawo, pinaagi sa tawo maula usab ang iyang dugo, kay pinaagi sa hulagway sa Dios gibuhat ang tawo. ");
INSERT INTO cebulb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Alang kaninyo, pagmabungahon ug pagpadaghan, lukopa ang tibuok kalibotan ug panaghan.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Unya ang Dios misulti kang Noe ug sa iyang mga anak nga lalaki nga uban kaniya, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Alang kanako, paminaw! Ako magahimo ug pakigsaad uban kaninyo ug sa inyong mga kaliwatan sunod kaninyo, ");
INSERT INTO cebulb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ug lakip ang tanang buhing binuhat nga uban kaninyo, lakip ang kalanggaman, ang mga binuhing mananap, ug ang tanang binuhat sa kalibotan nga uban kaninyo, gikan sa tanan nga miggawas sa arka, ngadto sa tanang buhing binuhat sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ug karon ako magahimo ug pakigsaad tali kaninyo, nga dili na pagalaglagon pag-usab ang tanang unod pinaagi sa lunop sa tubig. Wala na gayoy lunop nga molaglag sa kalibotan pag-usab.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Miingon ang Dios, “Kini ang timaan sa pakigsaad nga akong pagahimoon tali kanako ug kaninyo ug sa tanang buhing binuhat nga uban kaninyo, alang sa tanang umaabot nga kaliwatan: ");
INSERT INTO cebulb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","akong gibutang ang akong bangaw sa panganod, ug mao kini ang timaan sa pakigsaad tali kanako ug sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Moabot kini sa dihang dad-on ko ang panganod ibabaw sa kalibotan ug makita ang bangaw sa panganod, ");
INSERT INTO cebulb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","unya mahinumdoman ko ang akong pakigsaad, nga tali kanako ug kaninyo ug sa tanang buhing binuhat sa tanang unod. Dili na gayod mahimong lunop ang tubig nga maglaglag sa tanang unod. ");
INSERT INTO cebulb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ang bangaw maanaa sa kapanganoran ug makita ko kini, aron nga mahinumdoman ko ang walay kataposang pakigsaad tali sa Dios ug sa matag buhing binuhat sa tanang unod nga anaa sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Unya miingon ang Dios kang Noe, “Kini ang timaan sa pakigsaad nga akong gihimo tali kanako ug sa tanang unod nga anaa sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ang mga anak ni Noe nga lalaki nga migawas sa arka mao sila Sem, Ham, ug Jafet. Si Ham mao ang amahan ni Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Kining tulo mao ang mga anak ni Noe nga lalaki, ug gikan kanila nalukop ang tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nahimong mag-uuma si Noe, ug nagtanom siyag parasan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Nag-inom siya ug bino ug nahubog. Naghigda siya nga walay tabon didto sa iyang tolda. ");
INSERT INTO cebulb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Unya nakita ni Ham, nga amahan ni Canaan, ang hubo nga lawas sa iyang amahan ug iyang gisultihan ang iyang duha ka mga igsoon nga anaa sa gawas. ");
INSERT INTO cebulb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Busa mikuha ug panapton si Sem ug si Jafet ug gibutang nila kini ibabaw sa ilang mga abaga, ug milakaw nga patalikod ug gitabonan ang hubo nga lawas sa ilang amahan. Nilingi sila sa laing bahin, aron nga dili nila makita ang hubo nga lawas sa ilang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sa dihang nakamata na si Noe gikan sa iyang pagkahubog, nasayran niya kung unsa ang nahimo sa iyang kinamanghorang anak nga lalaki ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Busa miingon siya, “Tinunglo si Canaan. Mahimo siyang ulipon sa mga ulipon sa iyang mga igsoon.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Miingon usab siya, “Hinaot nga mapanalanginan si Yahweh, ang Dios ni Sem, ug hinaot nga si Canaan mahimo niyang sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hinaot nga padak-on sa Dios si Jafet, ug tugotan siya nga mobuhat sa iyang pinuy-anan didto sa mga tolda ni Sem. Hinaot nga mahimo niyang sulugoon si Canaan.” ");
INSERT INTO cebulb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Human sa lunop, nabuhi pa si Noe sulod sa 350 katuig. ");
INSERT INTO cebulb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Sa kinatibuk-an nabuhi si Noe ug 950 katuig, unya namatay siya. ");
INSERT INTO cebulb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Mao kini ang mga kaliwatan sa mga anak ni Noe nga lalaki, nga sila si, Sem, Ham, ug Jafet. Nakabaton sila ug mga anak nga lalaki human sa lunop. ");
INSERT INTO cebulb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ang mga anak ni Jafet nga lalaki mao sila Gomer, Magog, Madai, Jaban, Tubal, Mesec, ug Tiras. ");
INSERT INTO cebulb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ang mga anak ni Gomer nga lalaki mao sila Askenas, Rifat, ug Togarma. ");
INSERT INTO cebulb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ang mga anak ni Jaban nga lalaki mao sila Elisha, Tarsis, Kittim, ug Dodanim. ");
INSERT INTO cebulb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Gikan niini nagkabulag ang mga tawo sa baybayon ug nangadto sa ilang kayutaan, ang matag-usa sumala sa ilang kaugalingon nga pinulongan, sumala sa ilang mga banay, sumala sa ilang mga nasod. ");
INSERT INTO cebulb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ang mga anak ni Ham nga lalaki mao sila Cus, Mizraim, Put, ug Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ang mga anak ni Cus nga lalaki mao sila Seba, Habila, Sabata, Raama, ug Sabteca. Ang mga anak ni Raama nga lalaki mao sila Seba ug Dedan. ");
INSERT INTO cebulb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Si Cus nahimong amahan ni Nimrod, nga maoy unang nahimong mananaog sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Siya ang kusgang mangangayam sa atubangan ni Yahweh. Maong ginaingon kini, “Sama kang Nimrod, ang kusgang mangangayam sa atubangan ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ang unang mga sentro sa iyang gingharian mao ang Babel, Erec, Acad, ug Calne, didto sa yuta sa Sinar. ");
INSERT INTO cebulb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Gawas niadtong yutaa miadto siya sa Assyria ug gitukod ang Nineve, Rehobot Ir, Cala, ");
INSERT INTO cebulb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ug Resen, nga anaa taliwala sa Nineve ug Cala. Dako kato nga siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Mizraim nahimong amahan sa mga Luditihanon, sa mga Anamihanon, sa mga Lehabihanon, sa Naptuhanon, ");
INSERT INTO cebulb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","sa mga Patrusihanon, sa mga Casluhanon (nga mao ang gigikanan sa mga Filistihanon), ug sa mga Captorihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Si Canaan nahimong amahan ni Sidon, ang iyang kamagulangang anak, ug ni Het, ");
INSERT INTO cebulb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ug sa mga Jebusihanon, sa mga Amorihanon, sa mga Girgasihanon, ");
INSERT INTO cebulb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","sa mga Hebihanon, sa mga Arkihanon, sa mga Sinaihanon, ");
INSERT INTO cebulb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","sa mga Arvadihanon, sa mga Semarihanon ug sa mga Hamatihanon. Pagkahuman nikaylap ang mga banay sa mga Canaanhon. ");
INSERT INTO cebulb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ang utlanan sa mga Canaanhon gikan sa Sidon, padulong sa Gerar, hangtod sa Gasa, ug paingon sa Sodoma, Gomora, Adma, ug Zeboim, hangtod sa Lasa. ");
INSERT INTO cebulb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Mao kini ang mga anak ni Ham nga lalaki, sumala sa ilang banay, sumala sa ilang mga pinulongan, sa ilang kayutaan, ug sa ilang kanasoran. ");
INSERT INTO cebulb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Nakabaton usab ug mga anak nga lalaki si Sem ang magulang nga igsoon ni Jafet. Si Sem usab ang katigulangan sa tanang tawo sa Eber. ");
INSERT INTO cebulb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ang mga anak ni Sem nga lalaki mao sila si Elam, Asur, Arpacsad, Lud, ug Aram. ");
INSERT INTO cebulb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ang mga anak ni Aram nga lalaki mao sila si Uz, Hul, Geter, ug Mesec. ");
INSERT INTO cebulb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arpacsad nahimong amahan ni Sela, ug si Sela nahimong amahan ni Eber. ");
INSERT INTO cebulb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Si Eber adunay duha ka mga anak nga lalaki. Ang pangalan sa usa mao si Peleg, tungod kay sa iyang panahon nabahin man ang kalibotan. Ang pangalan sa iyang igsoon nga lalaki mao si Joktan. ");
INSERT INTO cebulb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joktan nahimong amahan nila ni Almodad, Selep, Hasarmabet, Jera, ");
INSERT INTO cebulb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO cebulb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO cebulb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Habila, ug Jobab. Silang tanan mga anak nga lalaki ni Joktan. ");
INSERT INTO cebulb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ang ilang teritoryo gikan sa Mesa, padulong sa Sefar, ang bukid sa sidlakan. ");
INSERT INTO cebulb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Mao kini ang mga anak nga lalaki ni Sem, sumala sa ilang mga banay ug sa ilang mga pinulongan, sa ilang kayutaan, ug sumala sa ilang kanasoran. ");
INSERT INTO cebulb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Mao kini ang mga banay sa mga anak ni Noe nga lalaki, sumala sa ilang mga gigikanan, sumala sa ilang kanasoran. Gikan niini nagkatibulaag ang mga nasod ug nagkatag sa kalibotan human sa lunop. ");
INSERT INTO cebulb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Karon ang tibuok kalibotan nagagamit ug usa lamang ka pinulongan ug adunay managsama nga mga pulong. ");
INSERT INTO cebulb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Samtang mipanaw sila paingon sa sidlakan, nakita nila ang kapatagan sa yuta sa Sinar ug mipuyo sila didto. ");
INSERT INTO cebulb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ug nagsultihanay sila sa usag-usa, “Umari kamo, magbuhat kita ug tisa ug lutoon nato kini pag-ayo.” Aduna silay tisa imbis nga bato ug alkitran ingon nga apog. ");
INSERT INTO cebulb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Miingon sila, “Umari kamo, magbuhat kita ug siyudad ug usa ka tore nga mosangko sa langit, ug maghimo kitag ngalan alang sa atong kaugalingon. Kung dili nato kini himoon, magkatibulaag kita sa tibuok kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Busa mikanaog si Yahweh aron sa pagtan-aw sa siyudad ug sa tore nga gibuhat sa mga kaliwat ni Adan. ");
INSERT INTO cebulb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Miingon si Yahweh, “Tan-awa, usa na sila ka katawhan nga managsama ang pinulongan, ug nagsugod na sila sa paghimo niini! Sa dili madugay wala na silay gusto nga himoon nga dili nila mahimo. ");
INSERT INTO cebulb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Umari kamo, manganaog kita ug libogon ang ilang pinulongan didto, aron nga dili na sila magkasinabot sa usag-usa.” ");
INSERT INTO cebulb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Busa gipatibulaag sila ni Yahweh gikan didto ug ngadto sa tibuok kalibotan ug mihunong sila sa pagbuhat sa siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Busa, ginganlan kini ug Babel, tungod kay didto man gilibog ni Yahweh ang pinulongan sa tibuok kalibotan ug gikan didto gipatibulaag sila ni Yahweh sa nagkalainlaing dapit sa tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Mao kini ang mga kaliwat ni Sem. Si Sem nag-edad na ug 100 ka tuig, ug nahimo siyang amahan ni Arpacsad duha ka tuig human ang lunop. ");
INSERT INTO cebulb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nabuhi si Sem sulod sa 500 ka tuig human siya nahimong amahan ni Arpacsad. Nahimo usab siya nga amahan sa uban niyang mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sa dihang nag-edad na si Arpacsad ug 35 ka tuig, nahimo siyang amahan ni Sela. ");
INSERT INTO cebulb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Si Arpacsad nabuhi sulod sa 403 katuig human siya nahimo nga amahan ni Sela. Nahimo usab siya nga amahan sa uban pa niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sa dihang nag-edad na si Sela ug 30 ka tuig, nahimo siya nga amahan ni Eber. ");
INSERT INTO cebulb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nabuhi si Sela sulod sa 403 ka tuig human siya nahimong amahan ni Eber. Nahimo usab siya nga amahan sa uban pa niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sa dihang nag-edad si Eber ug 34 ka tuig, nahimo siya nga amahan ni Peleg. ");
INSERT INTO cebulb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nabuhi si Eber sulod sa 430 katuig human siya nahimong amahan ni Peleg. Nahimo usab siya nga amahan sa uban pa niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Sa dihang nag-edad si Peleg ug 30 ka tuig, nahimo siya nga amahan ni Reu. ");
INSERT INTO cebulb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nabuhi si Peleg sulod sa 209 katuig human siya nahimo nga amahan ni Reu. Nahimo usab siya nga amahan sa uban pa niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Sa dihang nag-edad si Reu ug 32 ka tuig, nahimo siya nga amahan ni Serug. ");
INSERT INTO cebulb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nabuhi si Reu sulod sa 207 ka tuig human siya nahimo nga amahan ni Serug. Nahimo usab siya nga amahan sa uban pa niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sa dihang nag-edad si Serug ug 30 ka tuig, nahimo siya nga amahan ni Nahor. ");
INSERT INTO cebulb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nabuhi si Serug sulod sa 200 ka tuig human siya nahimo nga amahan ni Nahor. Nahimo usab siya nga amahan sa uban niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Sa dihang nag-edad si Nahor ug 29 ka tuig, nahimo siya nga amahan ni Tera. ");
INSERT INTO cebulb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nabuhi si Nahor sulod sa 119 ka tuig human siya mahimong amahan ni Tera. Nahimo usab siya nga amahan sa uban niya nga mga anak nga lalaki ug babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Sa nag-edad si Tera ug 70 ka tuig, nahimo siya nga amahan ni Abram, Nahor, ug Haran. ");
INSERT INTO cebulb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Karon mao kini ang mga kaliwat ni Tera. Si Tera mao ang amahan ni Abram, Nahor ug Haran. Ug si Haran mao ang amahan ni Lot. ");
INSERT INTO cebulb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Namatay si Haran sa atubangan sa iyang amahan nga si Tera sa yuta nga iyang natawhan, sa Ur sa mga Caldeahanon. ");
INSERT INTO cebulb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nangasawa si Abram ug si Nahor. Ang ngalan sa asawa ni Abram mao si Sarai ug ang ngalan sa asawa ni Nahor mao si Milca, anak nga babaye ni Haran, nga amahan ni Milca ug ni Isca. ");
INSERT INTO cebulb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Karon baog si Sarai; wala siyay anak. ");
INSERT INTO cebulb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Gikuha ni Tera ang iyang anak nga si Abram, ug si Lot nga anak sa iyang anak nga si Haran, ug si Sarai nga iyang umagad nga babaye, nga asawa ni Abram ug mibiya sila sa dapit sa Ur sa Caldehanon, aron moadto padulong sa yuta sa Canaan. Apan nahiabot sila sa Haran ug mipuyo sila didto. ");
INSERT INTO cebulb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nabuhi pa si Tera sulod sa 205 ka tuig ug unya namatay didto sa Haran. ");
INSERT INTO cebulb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Karon miingon si Yahweh kang Abram, “Lakaw ug biya sa imong nasod, gikan sa imong kaparyentihan, ug gikan sa panimalay sa imong amahan, ngadto sa yuta nga akong ipakita kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Himoon ko ikaw nga dakong nasod, panalanginan ko ikaw, himoon ko nga bantogan ang imong ngalan, ug mahimo kang panalangin. ");
INSERT INTO cebulb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Panalanginan ko kadtong magapanalangin kanimo, apan si bisan kinsa kadtong magpakaulaw kanimo akong pagatunglohon. Pinaagi kanimo mapanalanginan ang tanang pamilya sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Busa milakaw si Abram, sama sa giingon ni Yahweh nga iyang himoon, ug miuban kaniya si Lot. 75 ka tuig na ang edad ni Abraham sa dihang mibiya siya sa Haran. ");
INSERT INTO cebulb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Gidala ni Abram si Sarai, nga iyang asawa, ug si Lot nga anak sa iyang igsoon nga lalaki, lakip na ang tanan nilang mga kabtangan nga ilang natigom, ug ang katawhan nga ilang nakuha sa Haran. Unya mibiya sila aron moadto ngadto sa yuta sa Canaan, ug miabot sila sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Milabay si Abram niadtong yutaa hangtod nahiabot sa Shekem, ngadto sa tugas sa More. Nianang panahona ang mga Canaanhon ang nagpuyo didtong yutaa. ");
INSERT INTO cebulb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mipakita si Yahweh kang Abram, ug miingon, “Ihatag ko kining yutaa sa imong mga kaliwat.” Busa si Abram nagbuhat ug halaran alang kang Yahweh, nga nagpakita kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Gikan didto mibalhin siya sa kabungtoran sa sidlakan sa Betel, nga diin nagtukod siya ug barongbarong, diha ang Betel sa kasadpan ug ang Ai paingon sa Sidlakan. Didto nagtukod siyag halaran alang kang Yahweh ug gitawag ang ngalan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Unya si Abram mipadayon sa iyang panaw, padulong sa Negeb. ");
INSERT INTO cebulb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Adunay kagutom didto nga yuta, busa milugsong si Abram padulong sa Ehipto ug mipuyo didto, kay hilabihan ang kagutom nianang yutaa. ");
INSERT INTO cebulb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Sa dihang hapit na siya makasulod sa Ehipto, miingon siya kang Sarai nga iyang asawa, “Tan-awa ako, nasayod ako nga maanyag kaayo ka nga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sa dihang ang mga Ehiptohanon makakita kanimo moingon sila nga, 'Mao kini ang iyang asawa', ug ila akong patyon, apan buhion ka nila. ");
INSERT INTO cebulb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ingna sila nga igsoon ko ikaw, aron nga ayohon nila ako pagtagad tungod kanimo, ug aron nga luwason nila ang akong kinabuhi tungod kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Nahitabo kadto sa dihang misulod si Abram ngadto sa Ehipto, nakita sa mga Ehiptohanon si Sarai nga maanyag kaayo. ");
INSERT INTO cebulb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nakita siya sa mga prinsipe ni Paraon ug gidayeg nila siya ngadto kang Paraon, ug gidala siya ngadto sa panimalay ni Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Giatiman pag-ayo ni Paraon si Abram tungod kaniya, ug gihatagan siya ug karnero, baka, lalaki nga mga asno, mga sulugoon nga lalaki, mga sulugoon nga babaye, babaye nga mga asno, ug mga kamelyo. ");
INSERT INTO cebulb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Unya gipaantos ni Yahweh si Paraon ug ang iyang panimalay uban sa dako nga hampak tungod kang Sarai, nga asawa ni Abram. ");
INSERT INTO cebulb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Unya gipatawag ni Paraon si Abram, ug miingon; “Unsa ba kining gibuhat mo kanako? Nganong wala ka man nagsulti nga imo man diay siyang asawa? ");
INSERT INTO cebulb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nganong miingon ka man, 'Igsoon nako siya', aron ba kuhaon nako siya ug himoon nakong asawa? Busa karon, ania ang imong asawa. Dal-a siya, ug lakaw.” ");
INSERT INTO cebulb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Unya gimandoan ni Paraon ang iyang mga tawo mahitungod kaniya, ug gipalakaw nila siya, uban sa iyang asawa ug ang tanan nga anaa kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Busa mitungas si Abram gikan sa Ehipto ug mipadulong ngadto sa Negeb, siya, ang iyang asawa, ug ang tanan nga iyang gipanag-iyahan. Mikuyog usab si Lot kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Karon si Abram dato na kaayo sa mga mananap, plata, ug sa bulawan. ");
INSERT INTO cebulb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mipadayon siya sa iyang pagpanaw gikan sa Negeb paingon sa Betel, ngadto sa dapit nga iyang gitukoran kaniadto sa iyang barongbarong, taliwala sa Betel ug Ai. ");
INSERT INTO cebulb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Miadto siya sa dapit nga iyang gitukoran kaniadto sa iyang halaran. Dinhi gitawag niya ang ngalan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Karon si Lot, nga mikuyog sa pagpanaw ni Abram, aduna usab mga karnero, mga baka, ug mga barongbarong. ");
INSERT INTO cebulb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ang yuta dili na paigo alang kanila nga maghiusa sila pagpuyo, tungod kay daghan na kaayo ang ilang mga kabtangan, busa dili sila mahimong magkuyog ug puyo. ");
INSERT INTO cebulb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Usab, adunay panagbingkil tali sa mga magbalantay sa mga mananap ni Abram ug sa mga magbalantay sa mga mananap ni Lot. Niadtong panahona ang mga Canaanhon ug ang mga Perisihanon nanimuyo usab niadtong yutaa. ");
INSERT INTO cebulb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Busa miingon si Abram kang Lot, “Wala untay panagbingkil tali kanimo ug kanako, ug tali usab sa mga magbalantay sa imong mga mananap ug sa mga magbalantay sa akong mga mananap; kay pamilya man kita. ");
INSERT INTO cebulb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dili ba anaa man ang tibuok yuta sa imong atubangan? Lakaw ug biya gikan kanako. Kung moadto ka sa wala, moadto ako sa tuo. O kung moadto ka sa tuo, moadto ako sa wala.” ");
INSERT INTO cebulb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Busa gisud-ong ni Lot ang palibot, ug nakita niya ang tibuok patag sa Jordan nga daghan ug katubigan sa bisan asang dapit paingon sa Soar, sama sa tanaman ni Yahweh, sama sa yuta sa Ehipto. Sa wala pa gilaglag ni Yahweh ang Sodoma ug Gomora. ");
INSERT INTO cebulb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Busa gipili ni Lot alang sa iyang kaugalingon ang tibuok patag sa Jordan ug mipanaw paingon sa sidlakan, ug ang magparyente nagbulag-bulag sa usag-usa. ");
INSERT INTO cebulb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nagpuyo si Abram sa yuta sa Canaan, ug si Lot nagpuyo taliwala sa mga siyudad nga patag. Gitukod niya ang iyang barongbarong ingon ka layo sa Sodoma. ");
INSERT INTO cebulb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Karon ang mga tawo sa Sodoma hilabihan na kaayo ka daotan batok kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Miingon si Yahweh kang Abram human mibiya si Lot kaniya, “Lantawa ang dapit nga imong gitindogan ngadto sa amihanan, sa habagatan, sa sidlakan ug sa kasadpan. ");
INSERT INTO cebulb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ihatag ko kanimo ang tanang yuta nga imong nakita, ihatag ko kanimo ug sa imong mga kaliwat hangtod sa kahangtoran. ");
INSERT INTO cebulb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ug himoon ko ang imong mga kaliwat nga sama kadaghan sa abog sa yuta, kay kung adunay tawo nga makaihap sa abog sa kalibotan, unya maihap usab ang imong mga kaliwat. ");
INSERT INTO cebulb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tindog, lakaw sa gitas-on ug sa gilapdon sa yuta, kay ihatag ko kini kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Busa gidala ni Abram ang iyang barongbarong, ug miadto ug mipuyo sa katugasan ni Mamre, nga anaa sa Hebron, ug didto gitukod niya ang halaran alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nahitabo kini sa kapanahonan ni Amrafel nga hari sa Sinar, ni Ariok nga hari sa Elasar, ni Kedorlaomer nga hari sa Elam, ug ni Tidal nga hari sa Goiim, ");
INSERT INTO cebulb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nakiggubat sila batok kang Bera, ang hari sa Sodoma, kang Birsa ang hari sa Gomora, kang Sinab ang hari sa Adma, kang Semeber ang hari sa Seboiim ug ang hari sa Bela (nga gitawag usab ug Soar.) ");
INSERT INTO cebulb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kining lima ka mga hari nagkahiusa didto sa walog sa Sidim (nga gitawag usab ug Asin nga Dagat). ");
INSERT INTO cebulb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sa napulo ug duha ka tuig nag-alagad sila kang Kedorlaomer, apan sa ika napulo ug tulo ka tuig mibatok na sila. ");
INSERT INTO cebulb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Unya sa ika napulo ug upat ka tuig, si Kedorlaomer ug ang mga hari nga uban kaniya miabot ug gisulong ang Refaim diha sa Asterot Karnaim, ang Susihanon diha sa Ham, ang Emihanon diha sa Shabeh Kiriataim, ");
INSERT INTO cebulb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ang Horihanon diha sa ilang kabungtoran nga nasod sa Seir, ingon ka layo sa El Paran, nga diin duol sa kamingawan. ");
INSERT INTO cebulb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Unya mibalik sila ug miadto sa En Mispat (nga gitawag usab ug Kades), ug gipildi ang mga nasod sa mga Amalekanhon, ug usab ang Amorihanon nga nagpuyo sa Hasason Tamar. ");
INSERT INTO cebulb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Unya ang hari sa Sodoma, ang hari sa Gomora, ang hari sa Adma, ang hari sa Seboiim, ug ang hari sa Bela (nga gitawag usab nga Soar) migawas ug nangandam sa pagpakiggubat ");
INSERT INTO cebulb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","batok ni Kedorlaomer, ang hari sa Elam, si Tidal ang hari sa Goiim, si Amrafel ang hari sa Sinar, si Ariok ang hari sa Elasar; upat ka mga hari batok sa lima. ");
INSERT INTO cebulb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Karon ang walog sa Sidim napuno sa mga lungag sa alkitran, ug sa dihang miikyas na ang mga hari sa Sodoma ug Gomora, nangahulog sila didto. Kadtong nahibilin miikyas ngadto sa mga kabukiran. ");
INSERT INTO cebulb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Busa gikuha sa kaaway ang mga kabtangan sa Sodoma ug Gomora ug ang tanan nilang mga pagkaon ug mipadayon sa ilang dalan. ");
INSERT INTO cebulb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sa ilang paglakaw gidala usab nila si Lot, nga anak sa igsoong lalaki ni Abram, nga nagpuyo sa Sodoma, uban sa tanan niyang mga kabtangan. ");
INSERT INTO cebulb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ang usa nga nakaikyas miabot ug misugilon kang Abram nga usa ka Hebreohanon. Nagpuyo siya sa mga katugasan nga gipanag-iyahan ni Mamre nga Amorihanon, nga igsoon ni Escol ug Aner, nga mga kaabin ni Abram. ");
INSERT INTO cebulb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Karon sa dihang nadungog ni Abram nga gibihag sa mga kaaway ang iyang paryente, gipangulohan niya ang iyang 318 nga gibansay nga mga tawo, nga natawo sa iyang panimalay, ug gigukod ang mga kaaway ingon ka layo sa Dan. ");
INSERT INTO cebulb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Sa pagkagabii, gibahin niya ang iyang mga tawo ug gisulong sila, ug gigukod nila sila ingon ka layo sa Hoba, nga mao ang amihanan sa Damascus. ");
INSERT INTO cebulb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Unya gidala niya pagbalik ang tanang kabtangan, ug gidala usab niya pagbalik ang iyang paryente nga si Lot ug ang iyang mga katigayonan, lakip na usab ang mga babaye ug ang uban pa nga mga tawo. ");
INSERT INTO cebulb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Human sa pagbalik ni Abram gikan sa pagbuntog kang Kedorlaomer ug ang mga hari nga uban kaniya, ang hari sa Sodoma migawas aron himamaton siya didto sa walog sa Shabeh (nga gitawag usab ug Walog sa mga Hari). ");
INSERT INTO cebulb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Si Melquisedek, ang hari sa Salem, nagdala ug tinapay ug bino. Usa siya ka pari sa Labing Halangdon nga Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ug gipanalanginan niya siya nga nag-ingon, “Panalanginan ka Abram sa Labing Halangdon nga Dios, ang Magbubuhat sa langit ug sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dalaygon ang Dios nga Labing Halangdon, nga nagtugyan sa imong mga kaaway sa imong kamot.” Unya gihatagan siya ni Abram sa ika pulo sa tanang butang. ");
INSERT INTO cebulb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ang hari sa Sodoma miingon kang Abram, “Ihatag kanako ang katawhan, ug kuhaa ang mga pagkaon alang sa imong kaugalingon.” ");
INSERT INTO cebulb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Miingon si Abram sa hari sa Sodoma, “Gibayaw ko ang akong kamot kang Yahweh, ang Dios nga Labing Halangdon, ang Magbubuhat sa langit ug sa yuta, ");
INSERT INTO cebulb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nga dili ako mokuha ug tanod, higot sa sandalyas, o bisan pag unsa nga mga butang nga imoha, aron dili ka gayod makaingon, 'Ako ang nakapadato ni Abram.' ");
INSERT INTO cebulb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wala akoy kuhaon gawas sa gikaon sa akong mga tawo ug ang bahin sa mga tawo nga miuban kanako. Tugoti si Aner, Escol, ug Mamre nga magakuha sa ilang bahin.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pagkahuman niining mga butanga ang pulong ni Yahweh miabot ngadto kang Abram sa usa ka panan-awon, nga nag-ingon, “Ayaw kahadlok Abram! Ako ang imong taming ug dakong ganti.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Miingon si Abram, “Ginoo nga Yahweh, unsa ba ang imong mahatag kanako, nga nagapadayon man ako nga walay anak, ug ang makapanunod sa akong panimalay mao si Eliezer nga taga-Damascus?” ");
INSERT INTO cebulb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Miingon si Abram, “Sanglit wala mo man ako hatagi ug kaliwat, tan-awa, ang piniyalan sa akong balay maoy makapanunod.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Unya, tan-awa, ang pulong ni Yahweh miabot kaniya, nga nag-ingon, “Kining tawhana dili mao ang mamahimo nimong tigpanunod; apan ang gikan gayod sa kaugalingon nimong lawas mao ang imong tigpanunod.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Unya gidala niya siya sa gawas, ug miingon, “Hangad sa langit, ug ihapa ang kabituonan, kung maihap mo ba sila.” Unya miingon siya kaniya, “Ingon usab niana kadaghan ang mamahimo nimong mga kaliwat.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Mituo siya kang Yahweh, ug giisip siya niini nga matarong. ");
INSERT INTO cebulb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Miingon siya kaniya, “Ako si Yahweh, ang nagpagawas kanimo sa Ur sa mga taga-Caldea, aron sa paghatag kanimo niini nga yuta nga imong mapanunod.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Miingon siya, “Ginoo nga Yahweh, unsaon ko man pagkasayod nga ako kining mapanunod?” ");
INSERT INTO cebulb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Unya miingon siya kaniya, “Dad-i ako ug usa ka nating baka nga tulo ka tuig ang pangidaron, usa ka bayeng kanding nga tulo ka tuig ang pangidaron, usa ka torong karnero nga tulo ka tuig ang pangidaron, usa ka salampati ug usa ka piso nga tukmo.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Gidala niya kining tanan ngadto kaniya, ug gitunga niya kini sa duha, ug gibutang ang matag katunga sa atbang sa matag-usa niini, apan wala niya tungaa ang mga langgam. ");
INSERT INTO cebulb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sa dihang moadto ang mga langgam nga manunukob sa mga patay nga mananap, ginaabog kini ni Abram. ");
INSERT INTO cebulb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Unya sa pagsalop sa adlaw, nakahinanok pag-ayo sa pagtulog si Abram ug, tan-awa, ang lalom ug makalilisang nga kangitngit mitabon kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Unya miingon si Yahweh kang Abram, “Hibaloi gayod nga ang imong mga kaliwat mamahimong mga langyaw sa yuta nga dili ilaha, ug mahimo silang ulipon ug dinaog-daog sulod sa 400 ka mga katuigan. ");
INSERT INTO cebulb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Hukman ko ang maong nasod nga ilang alagaran, ug unya manggula sila inubanan sa daghan nga mga kabtangan. ");
INSERT INTO cebulb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Apan moadto ka sa imong mga amahan nga malinawon, ug ilubong ka sa sakto nga pangidaron. ");
INSERT INTO cebulb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Sa ika upat nga kaliwatan mobalik sila dinhi pag-usab, kay ang pagkadaotan sa mga Amorihanon wala pa misangko sa kinutoban niini.” ");
INSERT INTO cebulb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sa dihang misalop na ang adlaw ug mingitngit na, tan-awa, ang nag-aso ug nagkalayo nga kaang ug ang nagdilaab nga sulo miagi sa tunga sa mga hiniwa. ");
INSERT INTO cebulb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ug niadtong adlawa naghimo si Yahweh ug kasabotan ngadto kang Abram, nga nagaingon, “Ihatag ko sa imong mga kaliwat kining yutaa, gikan sa suba sa Ehipto ngadto sa dakong suba, ang Eufrates— ");
INSERT INTO cebulb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ang Kenihanon, ang Kenisihanon, ang Kadmonihanon, ");
INSERT INTO cebulb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ang Hitihanon, ang Perisihanon, ang Repaihanon, ");
INSERT INTO cebulb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ang Amorihanon, ang Canaanhon, ang Girgasihanon, ug ang Jebusihanon.” ");
INSERT INTO cebulb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Karon, si Sarai nga asawa ni Abram, wala nakahatag ug mga anak alang kaniya, apan aduna siyay usa ka sulugoong babaye, usa ka Ehiptohanon nga ginganlag Hagar. ");
INSERT INTO cebulb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Busa miingon si Sarai kang Abram, “Tan-awa, wala tugoti ni Yahweh nga makabaton ako ug mga anak. Lakaw ug pakigdulog sa akong sulugoon. Kay basin makabaton ako ug anak pinaagi kaniya.” Ug namati si Abram sa gisulti ni Sarai. ");
INSERT INTO cebulb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nahitabo kadto human sa napulo ka tuig gikan sa pagbiya nila sa Canaan nga si Sarai, ang asawa ni Abram, mihatag kang Hagar, nga iyang Ehiptohanong sulugoon, ngadto sa iyang bana aron nga mahimo niyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Busa nakabaton si Abram ug relasyon kang Hagar, ug nagmabdos siya. Sa dihang nakita niya nga nagmabdos siya, iyang gitan-aw ang iyang agalon nga babaye uban ang pagbiay-biay. ");
INSERT INTO cebulb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Busa miingon si Sarai kang Abram, “Kining sayop nga ania kanako tungod gayod kanimo. Gihatag ko ang akong sulugoong babaye sa imong paggakos, ug sa dihang nakita niya nga nagmabdos siya, mabiaybiayon na ang iyang pagtan-aw kanako. Tugoti nga si Yahweh ang maghukom tali kanimo ug kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Apan miingon si Abram kang Sarai, “Tan-awa ko, ang imong sulugoong babaye anaa ilalom sa imong gahom, buhata kaniya ang gihunahuna mong husto.” Busa gidaog-daog siya pag-ayo ni Sarai, ug milayas siya gikan kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nakaplagan siya sa anghel ni Yahweh didto sa tuboran sa tubig nga anaa sa kamingawan, ang tuboran nga anaa sa agianan paingon sa Shur. ");
INSERT INTO cebulb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Miingon siya, “Hagar, sulugoon ni Sarai, asa ka man gikan ug asa ka man moadto?” Ug miingon siya, “Milayas ako gikan sa akong agalong babaye nga si Sarai.” ");
INSERT INTO cebulb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ang anghel ni Yahweh miingon kaniya, “Balik ngadto sa imong agalon nga babaye ug pailalom sa iyang pagdumala.” ");
INSERT INTO cebulb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Unya ang anghel ni Yahweh nag-ingon kaniya, “Padaghanon ko pag-ayo ang imong mga kaliwat, aron mahimo silang hilabihan ka daghan ug dili maihap.” ");
INSERT INTO cebulb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ang anghel ni Yahweh miingon usab kaniya, “Tan-awa, nagmabdos ka, ug manganak ug batang lalaki, ug paganganlan mo siyag Ismael, tungod kay nadungog ni Yahweh ang imong mga pag-antos. ");
INSERT INTO cebulb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mahisama siya sa ihalas nga asno. Makigbangi siya batok sa tanang tawo, sama nga ang mga tawo makigbangi kaniya, maong magpuyo siya nga layo sa iyang mga igsoon.” ");
INSERT INTO cebulb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Busa ginganlan niya si Yahweh nga nakigsulti kaniya, “Ikaw ang Dios nga nakakita kanako,” kay miingon siya, “Magpadayon ba ako sa pagtan-aw, bisan ug nakakita na siya kanako?” ");
INSERT INTO cebulb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Busa ginganlan ang atabay ug Beerlahairoi; tan-awa, anaa kini sa taliwala sa Kades ug Bered. ");
INSERT INTO cebulb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Gipakatawo ni Hagar ang anak nga lalaki ni Abram, ginganlan ni Abram ug Ismael ang iyang anak nga lalaki, nga gipakatawo ni Hagar. ");
INSERT INTO cebulb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Si Abram nagpanuigon ug 86-anyos sa dihang gipanganak ni Hagar si Ismael alang kang Abram. ");
INSERT INTO cebulb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sa nag-edad na si Abram ug 99 ka tuig, mipakita si Yahweh kaniya ug miingon, “Ako ang Dios nga Labing Gamhanan. Pagsunod kanako, ug pagmatarong. ");
INSERT INTO cebulb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Unya pamatud-an ko ang akong kasabotan tali kanako ug kanimo, ug pasanayon ko ikaw pag-ayo.” ");
INSERT INTO cebulb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Mihapa si Abraham sa yuta, ug ang Dios nakigsulti kaniya, nga nagaingon, ");
INSERT INTO cebulb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Alang kanako, tan-awa, ang akong kasabotan anaa kanimo. Mahimo kang amahan sa daghang kanasoran. ");
INSERT INTO cebulb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Dili na Abram ang imong ngalan, kondili Abraham na—kay ako kang gipili nga mahimong amahan sa daghang kanasoran. ");
INSERT INTO cebulb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Himoon ko ikaw nga magmabungahon pag-ayo, ug himoon ko ang kanasoran gikan kanimo, ug ang mga hari magagikan kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Pagatukoron ko ang kasabotan tali kanako ug kanimo, ug ang imong mga kaliwat sunod kanimo, sa tibuok nilang mga kaliwatan alang sa walay kataposang kasabotan, mahimong Dios kanimo ug sa mosunod nimong mga kaliwat. ");
INSERT INTO cebulb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ihatag ko kanimo, ug sa mosunod nimong mga kaliwat, ang yuta diin ikaw nagpuyo, ang tanang kayutaan sa Canaan, alang sa walay kataposan nga kabtangan, ug mahimo nila ako nga Dios.” ");
INSERT INTO cebulb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Unya miingon ang Dios kang Abraham, “Alang kanimo, tipigi ang akong kasabotan, ikaw ug ang imong mga kaliwat sunod kanimo ngadto sa tibuok nilang mga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mao kini ang akong kasabotan, nga kinahanglan nimong tipigan, tali kanako ug kanimo ug sa imong mga kaliwatan sunod kanimo: Matag lalaki nga anaa kaninyo kinahanglan matuli. ");
INSERT INTO cebulb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kinahanglan ka nga matuli, ug mao kini ang timaan sa kasabotan tali kanako ug kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Matag lalaki nga anaa kaninyo nga nagpangidaron ug walo ka adlaw kinahanglan matuli, ngadto sa mga kaliwatan sa imong katawhan. Naglakip kini kaniya nga gipakatawo sa imong panimalay ug kaniya nga gipalit sa salapi gikan ni bisan kinsa nga langyaw nga dili lakip sa imong mga kaliwat. ");
INSERT INTO cebulb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Siya usab nga natawo sa imong panimalay ug siya nga imong gipalit sa salapi kinahanglan nga tulion. Kining akong kasabotan maanaa sa inyong unod alang sa walay kataposan nga kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Si bisan kinsa ang wala matuli nga lalaki nga dili tinuli sa unod sa iyang panit igasalikway gikan sa iyang katawhan. Giguba niya ang akong kasabotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ang Dios nag-ingon kang Abraham, “Alang kang Sarai nga imong asawa, ayaw na siya pagatawaga nga Sarai. Hinuon, ang iyang ngalan mahimo nang Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Panalanginan ko siya, ug pagahatagan ko ikaw ug anak nga lalaki pinaagi kaniya. Panalanginan ko siya, ug mahimo siyang inahan sa mga kanasoran. Ang mga hari sa katawhan magagikan kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Unya mihapa si Abraham sa yuta, ug mikatawa, ug miingon sa iyang kasingkasing, “Makabuhat pa ba ug bata ang usa ka tawo nga nagpanuigon na ug 100? Ug makaanak pa ba si Sara, nga 90 na ang panuigon?” ");
INSERT INTO cebulb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Miingon si Abraham sa Dios, “O hinaot unta nga mabuhi si Ismael sa imong atubangan!” ");
INSERT INTO cebulb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Miingon ang Dios, “Dili, apan si Sara nga imong asawa magmabdos ug lalaki nga anak, ug kinahanglan nga imong panganlan siya ug Isaac. Tukoron ko ang kasabotan kaniya ingon nga walay kataposang kasabotan uban sa iyang mga kaliwat sunod kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Alang kang Ismael, nadungog ko ikaw. Tan-awa, ania ako magpanalangin kaniya, ug himoon ko siya nga magmabungahon, ug pasanayon ko siya nga madagayaon gayod. Mahimo siya nga amahan sa dose ka mga pangulo sa mga tribo, ug pagahimoon ko siyang dako nga nasod. ");
INSERT INTO cebulb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Apan pagatukoron ko ang kasabotan uban kang Isaac, nga imabdos ni Sara kanimo sama niining taknaa sa sunod tuig.” ");
INSERT INTO cebulb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sa dihang nahuman na siya sa pakigsulti kaniya, ang Dios mibiya kang Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Unya gikuha ni Abraham si Ismael nga iyang anak nga lalaki, ug ang tanang natawo sa iyang panimalay, ug kadtong tanang gipalit sa iyang salapi, ang matag kalalakin-an sa panimalay ni Abraham, ug gituli niya sila sa unod sa panit nianang adlawa, sumala sa gisulti sa Dios kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Si Abraham nagpangidaron ug 99 na ka tuig sa dihang gituli ang unod sa iyang panit. ");
INSERT INTO cebulb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ug si Ismael nga iyang anak napulo ug tulo ka tuig ang edad sa dihang gituli ang panit sa iyang kinatawo. ");
INSERT INTO cebulb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Sa maong adlaw usab silang duha ni Abraham ug Ismael nga iyang anak gituli. ");
INSERT INTO cebulb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ang tanang mga lalaki nga anaa sa iyang panimalay gituli uban kaniya, lakip kadtong mga natawo sa panimalay ug kadtong gipalit sa salapi gikan sa mga langyaw. ");
INSERT INTO cebulb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nagpakita si Yahweh kang Abraham diha sa katugasan ni Mamre, samtang naglingkod siya sa pultahan sa iyang tolda sa kainiton sa adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mihangad siya ug, tan-awa, nakita niya ang tulo ka mga lalaki nga nagbarog sa iyang atubangan. Sa pagkakita niya kanila, midagan siya aron sa pagtagbo kanila gikan sa pultahan sa tolda ug miyukbo sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Miingon siya, “Ginoo, kung gikahimut-an mo ako, ayaw sayloi ug biyai ang imong sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tugoti nga dalhan kamo ug diyutay nga tubig, aron hugasan ang inyong mga tiil, ug pahulay kamo ilalom sa kahoy. ");
INSERT INTO cebulb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tugoti ako sa pagdala ug diyutay nga pagkaon, aron mahupay ang inyong kaugalingon. Pagkahuman makapadayon na kamo sa inyong panaw, sanglit mianhi man kamo sa inyong sulugoon.” Ug miingon sila, “Buhata kung unsa ang imong gisulti.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Unya nagdalidali ug adto si Abraham sa sulod sa barongbarong ngadto kang Sara, ug miingon, “Pagdali, pagkuha ug tulo ka takus sa pinakamaayong harina, masaha kini, ug paghimo ug tinapay.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Unya midagan si Abraham ngadto sa panon sa mga mananap, ug gikuha niya ang nating baka nga humok ug maayo, ug gihatag kini ngadto sa sulugoon, ug gidali niya kini pag-andam. ");
INSERT INTO cebulb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Gikuha niya ang mantikilya ug gatas, ug ang nating baka nga giandam, ug gibutang ang pagkaon sa ilang atubangan, ug nagbarog siya tapad kanila ilalom sa kahoy samtang nangaon sila. ");
INSERT INTO cebulb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Miingon sila kaniya, “Diin man si Sara ang imong asawa?” Mitubag siya, “Atua didto sa sulod sa barongbarong.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Miingon siya, “Mobalik gayod ako kanimo sa tingpamulak, ug tan-awa, ang imong asawa nga si Sara makabaton ug anak nga lalaki.” Naminaw si Sara didto sa pultahan sa tolda, nga anaa sa iyang luyo. ");
INSERT INTO cebulb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Karon si Abraham ug si Sara tigulang na, ug taas na ang pangidaron, ug si Sara wala na sa sakto nga pangidaron nga ang usa ka babaye makabaton pa ug anak. ");
INSERT INTO cebulb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Busa mikatawa si Sara sa iyang kaugalingon, nga nag-ingon, “Human nga nagmaluyahon na ako, aduna pa ba akoy kagana, nga ang akong agalon tigulang na man usab?” ");
INSERT INTO cebulb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Miingon si Yahweh kang Abraham, “Nganong mikatawa man si Sara ug miingon, 'Makabaton pa ba ako ug anak, nga tigulang na man ako?' ");
INSERT INTO cebulb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Aduna bay lisod kaayo kang Yahweh? Sa panahon nga akong gitagana, sa tingpamulak, mobalik ako kanimo. Sa samang higayon sa sunod tuig makabaton na ug anak nga lalaki si Sara.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Unya gilimod kini ni Sara ug miingon, “Wala man ako mikatawa,” tungod kay nahadlok siya. Mitubag siya, “Dili, mikatawa ka gayod.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Unya mitindog ang mga lalaki aron sa pagbiya ug midungaw paubos sa Sodoma. Miuban si Abraham kanila aron mahatod niya sila sa unahan. ");
INSERT INTO cebulb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Apan miingon si Yahweh, “Angay bang itago ko kang Abraham kung unsa ang akong pagahimuon, ");
INSERT INTO cebulb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","sanglit mahimo man gayong usa ka bantogan ug gamhanan nga nasod si Abraham, ug ang tanang nasod sa tibuok kalibotan mapanalanginan tungod kaniya? ");
INSERT INTO cebulb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kay gipili ko siya aron tudloan niya ang iyang mga anak ug ang iyang panimalay sa pagsunod sa paagi ni Yahweh kung wala na siya, sa pagbuhat ug matarong ug husto, aron buhaton ni Yahweh kang Abraham kung unsa ang iyang gisulti ngadto kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Unya miingon si Yahweh, “Tungod kay ang mga sumbong batok sa Sodoma ug Gomora hilabihan na gayod kadako, ug tungod kay ang ilang mga sala hilabihan na kaayo kadaotan, ");
INSERT INTO cebulb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","molugsong ako karon didto ug sutaon ang mga sumbong batok kaniya nga nahiabot kanako, kung tinuod ba gayod nga gibuhat nila kini. Kung wala man, masayran ko.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Busa ang mga lalaki mibiya gikan didto, ug miadto padulong sa Sodoma, apan si Abraham nagpabilin nga nagbarog sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Unya miduol si Abraham ug miingon, “Imo ba gayong laglagon ang matarong uban sa daotan? ");
INSERT INTO cebulb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Pananglitan adunay 50 ka matarong nga anaa sa siyudad. Imo ba kining laglagon ug dili luwason ang dapit alang sa 50 ka matarong nga atua didto? ");
INSERT INTO cebulb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Dili mo gayod mahimo kanang butanga, ang mopatay sa mga matarong uban sa daotan, aron nga ang matarong mahisama sa pagtagad sa mga daotan. Dili mo gayod kana mahimo! Dili ba himoon man sa manghuhukom sa tibuok kalibotan kung unsa ang makiangayon?” ");
INSERT INTO cebulb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Miingon si Yahweh, “Kung makakaplag ako ug 50 ka matarong sa siyudad sa Sodoma, dili ko pagalaglagon ang tibuok nga dapit alang kanila.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Mitubag si Abraham ug miingon, “Tan-awa, nakaako ako sa pagpakigsulti sa akong Ginoo, bisan tuod abog lamang ako ug mga abo! ");
INSERT INTO cebulb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pananglitan adunay 45 ka matarong? Imo bang laglagon ang tibuok nga siyudad tungod kay kulang ug lima?” Ug miingon siya, “Dili ko kini pagalaglagon, kung makakaplag ako didto ug 45.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Misulti na usab siya kaniya, ug miingon, “Pananglitan adunay 40 nga imong makaplagan didto?” Mitubag siya, “Dili ko kini buhaton alang niadtong 40.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Miingon siya, “Palihog ayaw kasuko, Ginoo, aron makahimo pa ako nga makasulti. Pananglitan adunay 30 nga makaplagan didto.” Mitubag siya, “Dili ko kini buhaton, kung makakaplag ako ug 30 didto.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Miingon siya, “Tan-awa, nakaako ako sa pagsulti sa akong Ginoo! Pananglitan adunay makaplagan nga 20 didto.” Mitubag siya, “Dili ko kini pagalaglagon alang niadtong 20.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Miingon siya, “Palihog ayaw kasuko, Ginoo, ug mosulti ako sa makausa pa sa kataposang higayon. Pananglitan makakaplag ka ug napulo didto.” Ug miingon siya, “Dili ko kini pagalaglagon alang niadtong napulo.” ");
INSERT INTO cebulb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mipadulong si Yahweh sa iyang dalan pagkahuman gayod sa iyang pagpakigsulti kang Abraham, ug mibalik si Abraham sa iyang panimalay. ");
INSERT INTO cebulb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nahiabot ang duha ka anghel didto sa Sodoma sa pagka-gabii, samtang si Lot naglingkod sa ganghaan sa Sodoma. Nakita sila ni Lot, mitindog siya sa pagtagbo kanila, ug mihapa sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Miingon siya, “Palihog mga agalon ko, hangyoon ko kamo nga mohapit sa balay sa inyong alagad, ug mopabilin sa tibuok nga gabii, ug makapanghimasa kamo sa inyong mga tiil. Ug makabangon kamo sa sayo sa kabuntagon, ug magpadayon sa inyong paglakaw.” Ug sila nag-ingon, “Dili, kay sa plasa sa lungsod lang kami mopahulay sa tibuok gabii.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Apan gihangyo niya sila pag-ayo, ug sila miuban kaniya, ug misulod sila sa iyang balay. Nag-andam siya ug pagkaon ug nagluto siya ug mga tinapay nga walay patubo, ug sila nangaon. ");
INSERT INTO cebulb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Apan sa wala pa sila mihigda nagpalibot sa balay ang mga lalaki sa siyudad, ang mga lalaki sa Sodoma, mga batan-on ug mga tigulang, tanang mga lalaki nga gikan sa bisan asang bahin sa siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Gitawag nila si Lot, ug miingon sila kaniya, “Hain na ang mga lalaki nga miabot kanimo karong gabhiona? Dad-a sila pagawas nganhi kanamo, aron kami makigdulog kanila.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Busa migawas si Lot sa pultahan ngadto kanila ug gisirad-an ang pultahan human siya makagawas. ");
INSERT INTO cebulb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ug siya miingon “Nagpakiluoy ako kaninyo, akong mga igsoon, ayaw kamo pagbuhat ug daotan. ");
INSERT INTO cebulb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tan-awa, aduna akoy duha ka mga anak nga babaye nga wala pa nakigdulog kang bisan kinsang lalaki. Naghangyo ako nga tugoti nga ihatag ko sila kaninyo, ug buhata kanila ang bisan unsa nga maayo sa inyong panan-aw. Ug ayaw lang hilabti kining mga tawhana, tungod kay sila mianhi ilalom sa landong sa akong atop.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nag-ingon sila, “Pahawa diha!” Ug Nag-ingon usab sila, “Kini siya mianhi ug mipuyo ingon nga langyaw, ug karon siya mahimo natong maghuhukom! Karon, ikaw among buhatan ug mas daotan labaw pa kanila.” Gituklod nila pag-ayo si Lot, ug midutdot aron sa pagguba sa pultahan. ");
INSERT INTO cebulb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Apan gibira sa duha ka lalaki si Lot pasulod sa balay uban kanila ug gisirad-an ang pultahan. ");
INSERT INTO cebulb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kadtong mga tawo nga anaa sa gawas sa pultahan sa balay, giataki ug gipangbutahan sila sa mga bisita ni Lot, mga batan-on ug mga tigulang, aron nga mangaluya sila sa pagpangita sa pultahan. ");
INSERT INTO cebulb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Unya ang duha ka lalaki nag-ingon kang Lot, “Aduna ka pa bay kauban dinhi? Bisan kinsa nga umagad nga lalaki, imong mga anak nga lalaki ug imong mga anak nga babaye, ug si bisan kinsa nga imong paryente sa siyudad, kuhaa sila pagawas niining dapita. ");
INSERT INTO cebulb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kay pagalaglagon namo kini nga dapit, tungod kay ang sumbong batok niini midangat sa atubangan ni Yahweh sa hilabihan gayod mao nga gipadala niya kami sa paglaglag niini.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Migawas si Lot ug nakigsulti sa iyang mga umagad nga lalaki, ang mga lalaki nga nagsaad nga makigminyo sa iyang mga anak nga babaye, “Pagdali, gawas niini nga dapit, tungod kay sa dili madugay pagalaglagon ni Yahweh kini nga siyudad.” Apan ang iyang mga umagad nga lalaki naghunahuna nga nagtiaw-tiaw siya. ");
INSERT INTO cebulb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sa sayo sa kabuntagon, ang mga anghel naghangyo kang Lot nga miingon, “Panglakaw na kamo, ug dad-a ang imong asawa ug ang imong duha ka mga anak nga babaye nga ania dinhi, aron dili kamo mahiapil sa pagsilot sa siyudad.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Apan siya naglanganlangan. Busa gibira sa duha lalaki ang iyang kamot, ug ang kamot sa iyang asawa, ug ang mga kamot sa iyang duha ka mga anak nga babaye, tungod kay si Yahweh nga Dios nagmaluluy-on kaniya. Gidala nila sila pagawas, ug gipahimutang sila sa gawas sa siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sa dihang gipagawas na nila sila, usa sa mga lalaki nag-ingon, “Dagan alang sa inyong kinabuhi! Ayaw paglingi o paghunong bisan asa sa kapatagan. Ikyas ngadto sa kabukiran aron dili kamo mahiapil pagkapapas.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Si Lot nag-ingon kanila, “Ayaw, palihog, mga agalon ko! ");
INSERT INTO cebulb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ang inyong alagad nakakaplag ug kaluoy sa inyong atubangan, ug gipakita ninyo kanako ang dako ninyong kaayo sa pagluwas sa akong kinabuhi, apan dili ako makahimo sa pag-ikyas ngadto sa mga bukid, tungod kay maapsan ako sa katalagman, ug ako mamatay. ");
INSERT INTO cebulb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tan-awa, kanang usa ka gamay nga siyudad nga haduol paigo na nga makadagan ako didto. Palihog, paikyasa ako didto (Dili ba gamay ra man kini?), ug ang akong kinabuhi maluwas.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mitubag siya kaniya, “Sige, gidawat ko usab kining imong gihangyo, ug dili ko pagalaglagon ang siyudad nga imong giingon. ");
INSERT INTO cebulb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pagdali! ug ikyas na didto, tungod kay dili ako makabuhat bisan unsa hangtod nga mahiabot ka didto.” Busa gitawag ang siyudad ug Zoar. ");
INSERT INTO cebulb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ang adlaw misidlak ibabaw sa kalibotan sa dihang nahiabot si Lot sa Zoar. ");
INSERT INTO cebulb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Unya gipaulanan ni Yahweh ug asupre ug kalayo ang Sodoma ug Gomora, migula kini gikan sa langit. ");
INSERT INTO cebulb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Gigun-ob niya kadtong mga siyudad, ug ang tanang kapatagan, ug ang tanang mga nagpuyo sa maong mga siyudad, ug ang mga tanom nga nagtubo sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Apan ang asawa ni Lot, nga nagsunod kaniya, milingi sa likod, ug siya nahimong haligi nga asin. ");
INSERT INTO cebulb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mibangon si Abraham sa sayo sa kabuntagon ug miadto sa dapit nga diin siya mibarog sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Milantaw siya paubos sa Sodoma ug Gomora ug paingon sa tibuok yuta sa kapatagan. Siya milantaw ug iyang nakita ang aso gikan sa yuta sama sa aso sa dakong hudno. ");
INSERT INTO cebulb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Busa sa dihang gigun-ob sa Dios ang mga siyudad sa kapatagan, nahinumduman sa Dios si Abraham. Gipagawas niya si Lot taliwala sa kadaot sa dihang iyang gigun-ob ang mga siyudad diin si Lot nagpuyo. ");
INSERT INTO cebulb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Apan mitungas si Lot gikan sa Zoar aron mopuyo sa kabukiran uban ang iyang duha ka mga anak nga babaye, tungod kay siya nahadlok nga mopuyo sa Zoar. Busa nagpuyo siya sa langub, siya ug ang iyang duha ka mga anak nga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ang kamaguwangan nga anak miingon ngadto sa manghod, “tiguwang na ang atong amahan, ug walay lalaki sa bisan asang dapit aron makigdulog kanato sumala sa pamaagi sa tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Dali, atong paimnon ug bino ang atong amahan, ug makigdulog kita kaniya, aron mamahimo natong mapadaghan ang banay sa atong amahan.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Busa gipainom nila ang ilang amahan ug bino niadtong gabhiona. Unya ang kinamaguwangang anak miadto sa sulod ug nakigdulog sa iyang amahan; wala nasayod si Lot sa dihang mihigda ang iyang kinamaguwangang anak, ni sa iyang pagbangon. ");
INSERT INTO cebulb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Sa pagkasunod nga adlaw ang kinamaguwangang anak miingon ngadto sa manghod, “Paminaw, nakigdulog ako sa atong amahan kagabii. Atong paimnon ug bino ang atong amahan pag-usab, ug kinahanglan nimo nga mosulod ug makigdulog uban kaniya, aron mamahimo natong mapadaghan ang banay sa atong amahan.” ");
INSERT INTO cebulb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Busa nahimo nila nga napainom ang ilang amahan ug bino niadtong gabhiona pag-usab, ug ang manghod niadto ug nakigdulog kaniya. Wala nasayod si Lot sa dihang mihigda ang iyang kinamanghorang anak, ni sa iyang pagbangon. ");
INSERT INTO cebulb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Busa ang duha ka mga anak nga babaye ni Lot nagmabdos pinaagi sa ilang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ang kinamaguwangang anak nanganak ug lalaki, ug ginganlan niya ug Moab. Nahimo siyang katigulangan sa katawhan sa mga Moabnon sa karong panahon. ");
INSERT INTO cebulb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Alang sa kinamanghorang anak, siya nanganak usab ug lalaki, ug ginganlan kini ug Ben Ami. Nahimo siyang katigulangan sa katawhan sa mga Amonihanon sa karong panahon. ");
INSERT INTO cebulb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Gikan didto mipanaw si Abraham ug nagpadulong sa yuta sa Negeb, ug nagpuyo siya sa tunga-tunga sa Kades ug Sur. Usa siya ka langyaw nga nagpuyo sa Gerar. ");
INSERT INTO cebulb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Si Abraham miingon mahitungod sa iyang asawa nga si Sara, “Siya mao ang akong igsoon nga babaye.” Unya ang hari sa Gerar nga mao si Abimelec nagpadala sa iyang mga tawo ug ilang gikuha si Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Apan ang Dios nagpakita kang Abimelec pinaagi sa damgo nianang gabhiona, ug siya miingon kaniya, “Tan-awa, mamatay ka tungod sa babaye nga imong gikuha, kay asawa siya sa usa ka tawo.” ");
INSERT INTO cebulb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Karon si Abimelec wala miduol kaniya ug siya nag-ingon, “Ginoo, pagapatyon mo ba bisan ang nasod nga matarong? ");
INSERT INTO cebulb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Dili ba diay siya mismo ang nag-ingon kanako, 'Siya akong igsoong babaye?' Ug bisan siya mismo ang nag-ingon, 'Siya akong igsoong lalaki.' Gihimo ko kini sa pakamatinud-anon sa akong kasing-kasing ug dili sad-an ang akong mga kamot.” ");
INSERT INTO cebulb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Unya ang Dios miingon kaniya pinaagi sa damgo, “Oo, nasayod usab ako nga nabuhat mo kini sa pagkamatinud-anon sa imong kasing-kasing, ug wala ko usab gitugot nga ikaw makasala batok kanako. Busa wala ko ikaw tugoti nga imo siyang hilabtan. ");
INSERT INTO cebulb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Busa, ibalik ang asawa sa tawo, tungod kay siya usa man ka propeta. Mag-ampo siya alang kanimo, ug ikaw mabuhi. Apan kung dili mo siya iuli, sayri nga ikaw ug ang tanang anaa kanimo mangamatay gayod.” ");
INSERT INTO cebulb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mibangon sa sayo sa kabuntangon si Abimelec ug iyang gipatawag ang tanan niyang mga sulugoon ngadto kaniya. Iyang gisugilon kining tanang mga butanga ngadto kanila, ug ang mga tawo nangahadlok pag-ayo. ");
INSERT INTO cebulb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Unya gipatawag ni Abimelec si Abraham ug nag-ingon kaniya, “Unsa man kining imong gibuhat kanamo? Giunsa ko man pagkasala kanimo, nga gidad-an mo ako ug ang akong gingharian ug dakong sala? Nakabuhat ka kanako sa dili unta angay buhaton.” ");
INSERT INTO cebulb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nag-ingon si Abimelec kang Abraham, “Unsa man ang nagtukmod kanimo aron buhaton kining mga butanga?” ");
INSERT INTO cebulb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nag-ingon si Abraham, “Tungod kay ako naghuna-huna, 'Wala gayo'y kahadlok sa Dios kini nga dapit, ug pagapatyon nila ako tungod sa akong asawa.' ");
INSERT INTO cebulb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Labot pa niana, tinuod gayod nga siya akong igsoong babaye, ang anak nga babaye sa akong amahan, apan dili siya anak nga babaye sa akong inahan; ug siya nahimong akong asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Sa dihang gipabiya ako sa Dios sa balay sa akong amahan ug mipanaw sa nagkalainlaing dapit, miingon ako kaniya, 'Kinahanglan ipakita mo kanako ang pagkamatinud-anon isip akong asawa: Sa bisan asang dapit kita moadto, ikaw moingon bahin kanako, “Siya ang akong igsoong lalaki.”” ");
INSERT INTO cebulb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Unya gikuha ni Abimelec ang karnero ug baka, ug mga lalaki ug babaye nga mga sulugoon, ug gihatag kang Abraham. Unya iyang gibalik si Sara, ang asawa ni Abraham, ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Miingon si Abimelec, “Tan-awa, anaa sa imong atubangan ang akong yuta. Pagpuyo sa bisan asa nimo gusto.” ");
INSERT INTO cebulb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Unya miingon siya kang Sara, “Tan-awa, naghatag ako ug isa ka libo ka plata sa imong igsoong lalaki. Kini alang sa pagtabon sa bisan unsang paglapas batok kanimo sa mga mata sa imong mga kauban, ug sa atubangan sa tanan, ikaw nahimong hingpit nga maayo.” ");
INSERT INTO cebulb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Unya nag-ampo si Abraham ngadto sa Dios, ug giayo sa Dios si Abimelec, ang iyang asawa, ang iyang mga sulugoon nga babaye aron sila makabaton ug mga anak. ");
INSERT INTO cebulb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kay gihimo man ni Yahweh nga ang mga babaye sa panimalay ni Abimelec nahimong mga baog sa hingpit, tungod kang Sara, nga asawa ni Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Gitagad ni Yahweh si Sara sumala sa iyang gisulti nga pagabuhaton, ug gibuhat ni Yahweh ang iyang gisaad kang Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nagmabdos si Sara ug nanganak ug usa ka batang lalaki alang kang Abraham sa natigulang na siya, sumala sa gitagal nga panahon nga gisulti sa Dios kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ginganlan ni Abraham ang iyang anak nga lalaki ug Isaac, siya nga gipakatawo kaniya, nga gipanganak ni Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Gituli ni Abraham ang iyang anak nga si Isaac sa dihang walo na kini ka adlaw, sumala sa gisugo kaniya sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nagpanuigon si Abraham ug 100 ka tuig sa pagkatawo ni Isaac alang kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Miingon si Sara, “Gipakatawa ako sa Dios; ang tanang makadungog mangatawa uban kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Miingon usab siya, “Kinsa ba ang makaingon kang Abraham nga si Sara makapasuso pa sa mga bata, ug ania ako nakapahimugso pa kaniya ug usa ka batang lalaki sa iyang katigulangon!” ");
INSERT INTO cebulb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Midako ang bata ug gilutas nila kini, ug nagpakombira si Abraham sa adlaw sa paglutas kang Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nakita ni Sara nga gibiaybiay sa anak ni Hagar nga Ehiptohanon si Isaac, nga gipakatawo ni Hagar alang kang Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Busa gisultihan niya si Abraham, “Papahawaa kining ulipong babaye ug ang iyang anak: kay ang anak niining sulugoong babaye dili mahimong manununod uban ang akong anak, nga si Isaac.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kining mga butanga nakapaguol pag-ayo kang Abraham tungod sa iyang anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Apan gisultihan sa Dios si Abraham, “Ayaw kaguol tungod sa bata, ug tungod sa imong ulipong babaye. Paminawa ang tanang mga pulong nga iyang gisulti kanimo mahitungod niining mga butanga, tungod kay pinaagi kang Isaac paganganlan ang imong kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Himoon ko usab nga dakong nasod ang anak nga lalaki sa ulipong babaye, tungod kay kaliwat mo man gihapon siya.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mibangon si Abraham sayo sa kabuntagon, ug mikuha ug tinapay ug panit nga panudlanan sa tubig, ug gihatag ngadto kang Hagar, gipapas-an niya kini. Gihatag niya ang bata kaniya ug gipalakaw. Mipahawa si Hagar ug naglatagaw didto sa kamingawan sa Beersheba. ");
INSERT INTO cebulb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sa nahurot na ang tubig sa panit nga panudlanan, gibiyaan niya ang bata ilalom sa usa ka kahoy. ");
INSERT INTO cebulb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Unya milakaw siya ug milingkod palayo dyutay sa bata, sama sa gilay-on sa pagbuhi sa pana, kay miingon siya, “Dili ako makaako sa pagtan-aw sa kamatayon sa bata.” Sa paglingkod niya atbang sa bata, missinggit siya ug mihilak. ");
INSERT INTO cebulb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nadungog sa Dios ang tingog sa bata, ug gitawag sa anghel sa Dios si Hagar gikan sa langit, ug miingon kaniya, “Unsa bay nakapahasol kanimo, Hagar? Ayaw kahadlok, kay nadungog sa Dios ang tingog sa bata sa nahimutangan niini. ");
INSERT INTO cebulb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tindog, sakwata ang bata, ug dasiga siya; kay himoon ko siyang dakong nasod.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Unya giablihan sa Dios ang iyang mga mata, ug nakita niya ang atabay nga may tubig. Miadto siya ug gipuno ug tubig ang panit nga panudlanan, ug gipainom ang bata. ");
INSERT INTO cebulb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ang Dios nag-uban sa bata, ug nagtubo siya. Mipuyo siya sa kamingawan ug nahimong usa ka magpapana. ");
INSERT INTO cebulb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mipuyo siya sa kamingawan sa Paran, ug ang iyang inahan mikuha ug usa ka asawa alang kaniya gikan sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Miabot ang panahon nga sila si Abimelec ug si Phicol ang kapitan sa iyang mga kasundalohan nakigsulti kang Abraham, ug miingon, “Ang Dios nag-uban kanimo sa tanan nimong gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Busa karon panumpa kanako dinhi pinaagi sa Dios nga dili mo gayod ako limbongan, ni bisan ang akong mga kaanakan, ni bisan ang akong mga kaliwatan. Ipakita kanako ug didto sa yuta nga imong gipuy-an ang sama gihapong kasabotan sa pagkamatinud-anon nga akong gipakita kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Si Abraham mitubag, “Ipanumpa ko.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mireklamo usab si Abraham kang Abimelec mahitungod sa atabay nga giilog sa mga sulugoon ni Abimelec gikan kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Si Abimelec miingon, “Wala ako masayod kinsa ang nagbuhat niining mga butanga. Wala ka man magsulti kanako kaniadto; wala ako makadungog niini kondili karon lamang.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Busa gikuha ni Abraham ang karnero ug ang baka ug gihatag kini kang Abimelec, ug naghimo silang duha ug usa ka kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Busa gilain ni Abraham alang kanila ang pito ka nating baye nga mga karnero gikan sa panon. ");
INSERT INTO cebulb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Si Abimelec miingon kang Abraham, “Unsa may buot ipasabot niining imong nilain nga pito ka nating baye nga mga karnero?” ");
INSERT INTO cebulb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Mitubag siya, “Kining pito ka nating baye nga mga karnero nga pagadawaton nimo gikan sa akong kamot, mahimo kining saksi alang kanako, nga gikalot ko gayod kini nga atabay.” ");
INSERT INTO cebulb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Busa gitawag niya ug Beersheba ang maong dapit, tungod kay didto man silang duha nanumpa, ");
INSERT INTO cebulb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Naghimo sila ug kasabotan didto sa Beersheba, ug unya si Abimelec ug si Phicol, ang kapitan sa iyang mga kasundalohan, mipauli ngadto sa yuta sa mga Filistihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Gitanom ni Abraham ang kahoy nga tamarisko sa Beersheba. Gisimba niya didto si Yahweh, ang walay kataposang Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nagpabiling langyaw si Abraham didto sa yuta sa mga Filistihanon sa daghang mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Miabot ang panahon human niining mga butanga nga gisulayan sa Dios si Abraham. Miingon siya kaniya, “Abraham!” Mitubag si Abraham, “Ania ako”. ");
INSERT INTO cebulb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Unya miingon ang Dios, “Dad-a ang imong anak, ang bugtong mong anak nga lalaki nga si Isaac nga imong hinigugma, ug adto sa yuta sa Moriah. Ihalad siya didto ingon nga halad sinunog sa usa sa mga kabukiran didto, nga akong isulti kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Busa mibangon si Abraham sa sayo sa kabuntagon, ug gikargahan niya ang asno, ug gidala niya uban kaniya ang duha ka batan-ong mga lalaki, kauban si Isaac nga iyang anak nga lalaki. Nangahoy siya alang sa halad sinunog, unya migikan na sa iyang panaw padulong sa dapit nga gisulti sa Dios kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sa ikatulo ka adlaw mihangad si Abraham ug nakita niya ang dapit sa halayo. ");
INSERT INTO cebulb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Unya miingon si Abraham sa iyang mga batan-ong lalaki, “Hulat dinhi uban sa asno, ug ako ug ang bata lamang moadto didto. Mosimba kami ug mobalik ra kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Unya gikuha ni Abraham ang sugnod alang sa halad sinunog ug gipapas-an kini kang Isaac nga iyang anak. Gidala niya sa iyang kamot ang kalayo ug ang punyal; ug nangadto na silang duha. ");
INSERT INTO cebulb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nakigsulti si Isaac sa iyang Amahan ug miingon, “Amahan ko.” ug mitubag siya, “Ania ako, akong anak.” Miingon siya, “Tan-awa, may kalayo ug pangsugnod dinhi, apan diin na man ang karnero alang sa halad sinunog?” ");
INSERT INTO cebulb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Miingon si Abraham, “Ang Dios sa iyang kaugalingon magapatagbo sa karnero alang sa halad sinunog, anak ko.” Busa mipadayon na silang duha. ");
INSERT INTO cebulb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sa nahiabot na sila sa dapit nga gisulti sa Dios kaniya, nagbuhat si Abraham ug halaran didto ug gibutang niya ang mga sugnod niini. Unya gigapos niya ni Isaac nga iyang anak ug gipahigda ibabaw sa halaran, sa ibabaw sa mga sugnod. ");
INSERT INTO cebulb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ug giisa ni Abraham ang iyang kamot ug gikuha ang punyal aron patyon ang iyang anak. ");
INSERT INTO cebulb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ug unya ang anghel ni Yahweh mitawag kaniya gikan sa langit ug miingon, “Abraham, Abraham!” ug miingon si Abraham, “Ania ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Miingon siya, “Ayaw pagbakyawa ang imong kamot batok sa bata, ni modagmal kaniya, kay nasayod na ako nga nahadlok ka sa Dios, sa pagpakita nga wala mo gihikaw ang imong anak nga lalaki, ang bugtong mong anak nga lalaki gikan kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Mihangad si Abraham ug ania karon, sa iyang likod adunay laking karnero nga nagapos ang sungay sa kasagbotan. Giadto ug gikuha ni Abraham ang laking karnero ug gihalad ingon nga halad sinunog puli sa iyang anak. ");
INSERT INTO cebulb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Busa gitawag ni Abraham kadtong dapita ug, “Si Yahweh ang magapatagbo,” ug gitawag kini niining panahona, “Sa bukid ni Yahweh ipatagbo kini.” ");
INSERT INTO cebulb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ang anghel ni Yahweh mitawag kang Abraham sa ikaduhang higayon gikan sa langit ");
INSERT INTO cebulb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ug miingon—mao kini ang mensahe ni Yahweh, “Pinaagi sa akong kaugalingon manumpa ako nga tungod sa imong pagbuhat niining butanga, ug wala mihikaw sa imong anak nga lalaki, nga imong bugtong anak, ");
INSERT INTO cebulb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","pagapanalanginan ko gayod ikaw ug padaghanon pag-ayo ang imong kaliwatan sama kadaghan sa mga bituon sa kalangitan, ug sama kadaghan sa mga balas sa baybayon; ug ang imong kaliwatan manag-iya sa mga ganghaan sa ilang mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pinaagi sa imong kaliwatan mapanalanginan ang tanang kanasoran sa kalibotan, tungod kay mituman ka man sa akong tingog.” ");
INSERT INTO cebulb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Busa gibalikan ni Abraham ang iyang mga batan-ong lalaki, ug mibiya sila ug nanglakaw padulong sa Beersheba, ug mipuyo siya sa Beersheba. ");
INSERT INTO cebulb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Miabot ang higayon human niining mga butanga nga gisuginlan si Abraham, “Si Milca nanganak ug mga anak, ingon man ang imong igsoong lalaki nga si Nahor.” ");
INSERT INTO cebulb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Sila mao si Uz ang kamagulangan, si Buz ang iyang igsoon nga lalaki, si Kemuel ang amahan ni Aram, ");
INSERT INTO cebulb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","si Chesed, si Hazo, si Pildash, si Jidlaph, ug si Betuel. ");
INSERT INTO cebulb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Si Betuel nahimong amahan ni Rebeca. Mao kini ang walo ka anak ni Milca nga gipanganak alang kang Nahor nga igsoong lalaki ni Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ang iyang kapuyopuyo, nga ginganlan ug Reuma, nanganak usab kang Teba, kang Gaham, kang Tahas, ug kang Maaca. ");
INSERT INTO cebulb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nabuhi si Sara sulod sa 127 ka tuig. Mao kini ang katuigan sa kinabuhi ni Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Namatay si Sara sa Kiriath Arba, nga mao na ang Hebron, sa yuta sa Canaan. Nagbangotan si Abraham ug naghilak alang kang Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Unya mitindog si Abraham ug mibiya gikan sa patayng lawas sa iyang asawa, ug nakigsulti sa mga anak nga lalaki ni Heth nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Usa ako ka langyaw diha kaninyo. Palihog papalita ako ug yuta diha kaninyo nga kalubngan, aron akong kalubngan sa akong minatay.” ");
INSERT INTO cebulb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Mitubag ang mga anak nga lalaki ni Heth kang Abraham, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Paminawa kami, akong agalon. Usa ikaw ka prinsipe sa Dios taliwala kanamo. Ilubong ang imong minatay sa labing maayo namong mga lubnganan. Walay usa kanamo ang mohikaw kanimo sa iyang lubnganan, aron nga imong malubong ang imong minatay. ");
INSERT INTO cebulb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Mitindog si Abraham ug miyukbo sa katawhan niadtong yutaa, sa mga anak nga lalaki ni Heth. ");
INSERT INTO cebulb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Gisultihan niya sila, nga nag-ingon, “Kung mitugot kamo nga ilubong ko ang akong minatay, nan paminawa ako ug hangyoa si Efron ang anak nga lalaki ni Zohar alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Hangyoa siya sa pagbaligya kanako sa langob sa Macpela, nga iyang gipanag-iya, nga atua sa kinatumyan sa iyang kaumahan. Sa igo nga kantidad ipabaligya kini kaniya nganhi kanako diha sa kadaghanan ingon nga gipanag-iyahan alang sa usa ka dapit nga lubnganan. ");
INSERT INTO cebulb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Karon naglingkod si Efron kauban sa mga anak nga lalaki ni Heth, ug gitubag ni Efron ang Hitihanon si Abraham nga madunggan sa mga anak nga lalaki ni Heth, ug sa tanang miadto sa ganghaan sa iyang siyudad, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Dili, paminawa ako akong agalon. Ihatag ko kanimo ang uma, ug ang langob nga anaa niini. Ihatag ko kini kanimo atubangan sa mga anak sa akong katawhan. Ihatag ko kini kanimo aron kalubngan sa imong minatay.” ");
INSERT INTO cebulb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Unya si Abraham sa iyang kaugalingon miyukbo atubangan sa katawhan niadtong yutaa. ");
INSERT INTO cebulb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Misulti siya kang Efron nga madungog sa katawhan niadtong yutaa, nga nag-ingon, “Apan kung itugot nimo, palihog paminawa ako. Bayaran ko ang kaumahan. Dawata ang salapi gikan kanako, ug ilubong ko ang akong minatay didto.” ");
INSERT INTO cebulb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Mitubag si Efron kang Abraham, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Palihog, agalon ko, paminaw kanako. Ang yuta nagkantidad ug 400 ka siklo sa plata, unsa ra man kana tali kanako ug kanimo? Ilubong ang imong minatay. ");
INSERT INTO cebulb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Miuyon si Abraham kang Efron ug gitimbang niya sa kantidad sa plata nga iyang gisulti nga madunggan sa mga anak nga lalaki ni Heth, 400 ka siklo nga plata, sumala sa sukaranan sa sukdanan sa mga tigpatigayon. ");
INSERT INTO cebulb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Busa ang uma ni Efron, nga anaa sa Macpela, nga duol sa Mamre, nga mao ang uma, ang langob nga anaa niini, ug ang tanang kakahoyan nga anaa sa uma ug sa mga utlanan nga naglibot niini, ");
INSERT INTO cebulb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","gihatag kang Abraham pinaagi sa pagpalit niini diha sa atubangan sa mga anak nga lalaki ni Heth, ug sa tanan usab nga miadto sa ganghaan sa iyang siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Human niini, gilubong ni Abraham si Sara nga iyang asawa sa langob nga anaa sa uma sa Macpela nga duol sa Mamre, nga mao ang Hebron, sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Busa ang uma ug ang langob niini napanag-iyahan ni Abraham ingon nga dapit nga lubngan nga gikan sa mga anak nga lalaki ni Heth. ");
INSERT INTO cebulb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Karon si Abraham tigulang na, anaa na sa katigulangon, ug gipanalanginan ni Yahweh si Abraham sa tanang mga butang. ");
INSERT INTO cebulb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Gisultihan ni Abraham ang iyang sulugoon, nga mao ang labing tigulang sa iyang panimalay ug ang piniyalan sa tanang anaa kaniya, “Ibutang ang imong kamot ilalom sa akong paa ");
INSERT INTO cebulb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ug papanumpaon ko ikaw pinaagi kang Yahweh, ang Dios sa langit ug ang Dios sa yuta, nga dili ka magpili ug asawa alang sa akong anak nga lalaki gikan sa mga anak nga babaye sa mga Canaanhon, diin ako maghimo sa akong pinuy-anan. ");
INSERT INTO cebulb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Apan moadto ka sa akong kaugalingong nasod, ug sa akong mga kabanay, ug pilia ang usa ka asawa alang sa akong anak nga lalaki nga si Isaac.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ang sulugoon miingon kaniya, “Unsaon man kung dili buot mokuyog kanako ang babaye niining yutaa? Dad-on ko ba ang imong anak nga lalaki balik sa dapit nga imong gigikanan?” ");
INSERT INTO cebulb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Miingon si Abraham kaniya, “Siguradoha nga dili mo gayod pagadad-on ang akong anak nga lalaki balik didto! ");
INSERT INTO cebulb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Si Yahweh, ang Dios sa langit, nga maoy nagkuha kanako gikan sa pinuy-anan sa akong amahan ug gikan sa yuta sa akong mga kabanay, ug ang nanumpa kanako sa maligdong nga panumpa, nga nag-ingon, 'Sa imong kaliwat ihatag ko kining yutaa,' ipadala niya ang iyang anghel una kanimo, ug makakita ka ug usa ka asawa alang sa akong anak nga lalaki gikan didto. ");
INSERT INTO cebulb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Apan kung ang babaye dili buot mokuyog kanimo, nan makalingkawas ka na gikan niining gipanumpa kanako. Ayaw lamang dad-a ang akong anak nga lalaki balik didto.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Busa gibutang sa sulugoon ang iyang kamot sa ilalom sa paa ni Abraham nga iyang agalon, ug nanumpa kaniya mahitungod niining butanga. ");
INSERT INTO cebulb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Gikuha sa sulugoon ang napulo ka mga kamelyo sa iyang agalon ug mibiya. Gidala usab niya ang tanang matang sa mga gasa gikan sa iyang agalon. Mibiya siya ug miadto sa rehiyon sa Aram Naharaim, sa siyudad sa Nahor. ");
INSERT INTO cebulb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Gipaluhod niya ang mga kamelyo sa kilid sa atabay nga may tubig nga anaa sa gawas sa siyudad. Gabii na kadto, ang takna sa pagpanggawas sa mga babaye aron sa pagkabo ug tubig. ");
INSERT INTO cebulb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Unya miingon siya, “Yahweh, Dios sa akong agalon nga si Abraham, hatagi ako ug kalamposan karong adlawa ug ipakita ang imong matinud-anong pakigsaad ngadto sa akong agalon nga si Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tan-awa, ania ako nagtindog kilid sa tuboran sa tubig, ug ang mga anak nga babaye sa mga tawo sa siyudad manggula aron sa pagkabo ug tubig. ");
INSERT INTO cebulb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tugoti nga mahitabo ang sama niini. Kung mosulti ako sa batan-ong babaye, 'Palihog ipaubos ang imong banga aron makainom ako,' ug mosulti siya kanako, 'Inom, ug paimnon ko usab ang imong mga kamelyo,' ug tugoti nga siya na ang imong pilion alang sa imong sulugoon nga si Isaac. Pinaagi niini masayran ko nga gipakita mo ang matinud-anong pakigsaad ngadto sa akong agalon.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Miabot ang higayon nga sa wala pa siya mahuman sa pagsulti, ania karon, miabot si Rebeca nga nagpas-an ug banga. Natawo si Rebeca kang Betuel nga anak nga lalaki ni Milca, ang asawa ni Nahor nga igsoong lalaki ni Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Maanyag kaayo ang dalaga ug usa ka ulay. Wala pay lalaki nga nakadulog kaniya. Milugsong siya sa tubod ug gipuno ang iyang banga, ug mitungas. ");
INSERT INTO cebulb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Unya midagan ang sulugoon aron sa pagsugat kaniya ug miingon, “Palihog hatagi ako ug gamay nga mainom gikan sa imong banga.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Miingon siya, “Inom, akong agalon,” ug gipaubos dayon niya ang banga sa iyang kamot, ug gipainom siya. ");
INSERT INTO cebulb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Sa pagkahuman na niya ug pagpainom kaniya, miingon siya, “Magkabo usab ako ug tubig alang sa imong mga kamelyo, hangtod matapos sila sa pag-inom.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Busa nagdali-dali siya ug gihurot niya pagbubo ang tubig sa banga ngadto sa pasungan sa paimnanan, unya midagan siya pagbalik sa atabay aron sa pagkabo ug tubig, ug mikabo ug tubig alang sa tanan niyang mga kamelyo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ang tawo nagtan-aw lamang kaniya sa hilom aron masuta kung gipalampos ba gayod ni Yahweh ang iyang panaw o wala. ");
INSERT INTO cebulb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sa pagkahuman na sa pag-inom sa mga kamelyo, gipagawas sa tawo ang bulawang ariyos alang sa ilong nga adunay gibug-aton nga katunga sa shekel, ang duha ka bulawang porselas alang sa iyang mga bukton nga adunay gibug-aton nga napulo ka shekels, ");
INSERT INTO cebulb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ug nangutana, “Kang kinsa ka bang anak? Palihog sultihi ako, aduna bay lawak sa balay sa imong amahan alang kanamo aron kami mamahulay sa kagabhion?” ");
INSERT INTO cebulb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Miingon siya kaniya, “Ako ang anak nga babaye ni Betuel nga anak nga lalaki ni Milca, nga gianak niya gikan kang Nahor. ");
INSERT INTO cebulb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Miingon usab siya kaniya, “Aduna kami daghang dagami ug kumpay, ug aduna usab kami lawak alang kaninyo aron kapahulayan sa kagabhion.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Unya miyukbo ang tawo ug misimba kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Miingon siya, “Bulahan si Yahweh, ang Dios sa akong agalon nga si Abraham, nga wala mobiya sa iyang matinud-anong pakigsaad ug takos siya nga kasaligan ngadto sa akong agalon. Ingon man kanako, gigiyahan ako ni Yahweh ngadto sa panimalay sa kabanay sa akong agalon.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Unya midagan ang dalaga ug gipahibalo niya ang panimalay sa iyang inahan mahitungod sa tanang mga nahitabo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Karon si Rebeca adunay igsoong lalaki, ug ang iyang ngalan mao si Laban. Midagan si Laban padulong sa tawo nga anaa pa sa dalan daplin sa tubod. ");
INSERT INTO cebulb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Sa pagkakita niya sa ariyos sa ilong ug sa mga porselas sa bukton sa iyang igsoong babaye, ug sa pagkadungog niya sa mga gipangsulti ni Rebeca nga iyang igsoong babaye, “Mao kini ang gisulti sa tawo kanako,” giadto niya ang maong tawo, ug tan-awa, nagtindog siya uban ang mga kamelyo didto sa tubod. ");
INSERT INTO cebulb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ug miingon si Laban, “Dayon, ikaw nga gipanalanginan ni Yahweh. Nganong nagtindog ka man diha sa gawas? Giandam ko na ang pinuy-anan, ug ang dapit alang sa mga kamelyo.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Busa midayon ang tawo sa pinuy-anan ug gihaw-as niya ang dala sa mga kamelyo. Gihatagan ang mga kamelyo sa dagami ug gipakaon, ug gihatagan siya ug tubig nga ikahugas sa iyang mga tiil ug sa mga tiil sa mga tawong kauban niya. ");
INSERT INTO cebulb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Giandaman nila siya ug pagkaon aron siya makakaon, apan miingon ang tawo, “Dili sa ako mokaon hangtod dili ko maisugilon kaninyo ang angay nakong isulti.” Si Laban miingon, “Sige sulti na.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Miingon siya, “Ako mao ang sulugoon ni Abraham, ");
INSERT INTO cebulb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Gipanalanginan pag-ayo ni Yahweh ang akong agalon ug nahimo siyang bantogan. Gihatagan niya siya ug panon sa mga karnero ug panon sa mga baka, salapi ug bulawan, mga lalaki ug babayeng sulugoon, ug mga kamelyo ug mga asno. ");
INSERT INTO cebulb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Si Sara, nga asawa sa akong agalon, nanganak ug usa ka lalaki alang sa akong agalon sa pagkatigulang na niya, ug gihatagan niya sa tanang butang nga iyang gipanag-iyahan. ");
INSERT INTO cebulb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Gipapanumpa ako sa akong agalon, nga nag-ingon, “Dili ka magpili ug usa ka asawa alang sa akong anak nga lalaki gikan sa mga anak nga babaye sa mga Canaanhon, kansang yuta nga akong gipuy-an. ");
INSERT INTO cebulb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Hinuon, moadto ka sa pamilya sa akong amahan ug sa akong mga kabanay, ug pangita ug asawa alang sa akong anak nga lalaki.' ");
INSERT INTO cebulb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Miingon ako sa akong agalon, 'Tingali dili mosunod ang babaye kanako.' ");
INSERT INTO cebulb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Apan miingon siya kanako, 'Si Yahweh, nga diha sa iyang atubangan naglakaw ako, magpadala sa iyang anghel uban kanimo ug palamposon niya ang imong panaw, aron nga makapangita ka ug usa ka asawa alang sa akong anak nga lalaki gikan sa akong mga kabanay ug gikan sa banay sa pamilya sa akong amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Apan makalingkawas ka lamang sa akong panumpa kung mahiabot ka na sa akong mga kabanay ug dili nila siya ihatag kanimo. Ug mahimo kanang gawasnon gikan sa akong panumpa.' ");
INSERT INTO cebulb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Busa karong adlawa miabot ako sa tuboran, ug miingon, “O Yahweh, Dios sa akong agalon nga si Abraham, palihog, kung himoon mo man gayod nga malamposon ang akong pagpanaw - ");
INSERT INTO cebulb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ania ako, nagtindog sa dapit sa tuboran sa tubig - tugoti nga ang mga dalaga nga mogawas aron sa pagkabo ug tubig, ang babaye nga akong sultihan, “Palihog, hatagi ako sa gamayng tubig gikan sa imong banga aron ako makainom,” ");
INSERT INTO cebulb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ang babaye nga moingon kanako, “Inom, ug mokabo usab ako ug tubig alang sa imong mga kamelyo” - hinaot nga siya na unta mao ang babaye nga gipili nimo Yahweh, alang sa anak nga lalaki sa akong agalon.' ");
INSERT INTO cebulb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Bisan sa wala pa ako matapos sa kinasingsing nga akong pagsulti, anaa, migawas si Rebeca nga nagpas-an ug banga ug milugsong siya ngadto sa tuboran aron sa pagkabo ug tubig. Busa giingnan ko siya, 'Palihog, paimna ako.' ");
INSERT INTO cebulb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Gipaubos dayon niya ang iyang gipas-an nga banga ug miingon, 'Inom, ug hatagan ko usab ug tubig ang imong mga kamelyo.' Busa miinom ako, ug gipainom usab niya ang mga kamelyo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Nangutana ako kaniya ug miingon, “Kang kinsa ka man nga anak?” Mitubag siya, “Anak nga babaye ni Betuel, nga anak ni Nahor nga gihimugso ni Milca gikan kaniya.” Ug unya gibutangan nako ug ariyos ang iyang ilong ug mga porselas sa iyang mga bukton.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ug unya miyukbo ako ug misimba kang Yahweh, ug gidayeg si Yahweh, ang Dios sa akong agalon nga si Abraham, nga maoy naggiya kanako sa husto nga dalan aron makaplagan ko ang anak nga babaye nga kabanay sa akong agalon alang sa iyang anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Busa karon, kung andam kamo sa pagtagad sa akong agalon uban sa pagkamatinud-anon ug pagkamatinumanon, sultihi ako. Apan kung dili, sultihi ako, aron makasimang ako ngadto sa too, o sa wala.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Unya mitubag ug miingon si Laban ug si Betuel, “Ang butang nagagikan kang Yahweh; dili kami makasulti kanimo kung daotan o maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Tan-awa, anaa si Rebeca sa imong atubangan. Dad-a siya ug lakaw, aron nga mamahimo siyang asawa sa anak nga lalaki sa imong agalon, sama sa gipamulong ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Sa pagkadungog sa sulugoon ni Abraham sa ilang gisulti, mihapa siya sa yuta alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Gipagawas sa sulugoon ang mga plata, ang mga bulawan, ug ang mga bisti, ug gihatag kini kang Rebeca. Gihatagan usab niya ug bililhong mga gasa ang iyang igsoong lalaki ug ang iyang inahan. ");
INSERT INTO cebulb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Unya siya ug ang mga tawong mikuyog kaniya, nangaon ug nanginom. Namahulay sila didto sa tibuok gabii, ug sa pagbangon nila sa kabuntagon, miingon siya, “Palakawa na ako ngadto sa akong agalon.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Miingon ang iyang igsoong lalaki ug iyang inahan, “Tugoti nga magpabilin una ang dalaga kanamo bisan sa pipila pa ka mga adlaw, o bisan napulo lamang. Human niana makalakaw na siya.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Apan mitubag siya kanila, “Ayaw na ako pagpugngi pa, sanglit gipalampos man ni Yahweh ang akong panaw. Palakawa na ako aron makapauli na ako sa akong agalon. ");
INSERT INTO cebulb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Miingon sila, “Tawgon nato ang dalaga ug pangutan-on siya.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Busa gitawag nila si Rebeca ug gipangutana, “Mokuyog ka ba niining tawhana?” Mitubag siya, “Mokuyog ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Busa gipakuyog nila ang ilang igsoong babaye nga si Rebeca, kauban ang iyang sulugoon nga babaye, sa iyang panaw kauban ang sulugoon ni Abraham ug sa iyang mga tawo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Gipanalanginan nila si Rebeca, ug miingon kaniya, “Among igsoong babaye, hinaot nga mahimo kang inahan sa liniboan ngadto sa napulo ka linibolibo, ug hinaot nga ang imong kaliwatan makapanag-iya sa ganghaan niadtong mga nagdumot kanila.” ");
INSERT INTO cebulb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Unya mitindog si Rebeca, ug misakay siya ug ang iyang mga sulugoong babaye sa mga kamelyo, ug misunod sa tawo. Sa ingon gidala sa sulugoon si Rebeca, ug milakaw. ");
INSERT INTO cebulb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Karon nagpuyo si Isaac sa Negev, ug mao pay pagbalik gikan sa Beerlahairoi. ");
INSERT INTO cebulb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Migawas si Isaac aron mamalandong sa uma niadtong gabhiona. Tan-awa, sa paghangad niya, nakita niya nga adunay nagpadulong nga mga kamelyo! ");
INSERT INTO cebulb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Mitan-aw si Rebeca, ug sa pagkakita niya kang Isaac, milukso siya gikan sa kamelyo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Miingon siya sa sulugoon, “Kinsa man kanang tawhana nga naglakaw diha sa uma aron sa pagsugat kanato?” Mitubag ang sulugoon, “Siya ang akong agalon.” Busa gikuha ni Rebeca ang iyang pandong, ug gitabonan ang iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Gisugilon pag-usab sa sulugoon kang Isaac ang tanan nga iyang nahimo. ");
INSERT INTO cebulb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Unya gidala siya ni Isaac sulod sa tolda sa iyang inahan nga si Sara ug gikuha niya si Rebeca, ug nahimo niya siyang asawa, ug gihigugma niya siya. Busa nahupay si Isaac human sa kamatayon sa iyang inahan. ");
INSERT INTO cebulb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nagminyo pag-usab si Abraham; ang iyang ngalan mao si Ketura. ");
INSERT INTO cebulb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Gipanganak niya sila si Simran, si Jocsan, si Medan, si Midian, si Isbac, ug si Sua. ");
INSERT INTO cebulb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Nahimong amahan si Jocsan kang Seba ug kang Dedan. Ang mga kaliwatan ni Dedan mao ang katawhan sa Asiria, ang katawhan sa Letus, ug katawhan sa Leum. ");
INSERT INTO cebulb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ang mga anak nga lalaki ni Midian mao sila si Epa, si Eper, si Hanoc, si Abida, ug si Eldaa. Mao kining tanan ang kaliwatan ni Ketura. ");
INSERT INTO cebulb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Gihatag ni Abraham kang Isaac ang tanan niyang gipanag-iyahan. ");
INSERT INTO cebulb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Apan, samtang buhi pa siya, gihatagan niya ug mga gasa ang mga anak nga lalaki sa iyang mga puyopuyo ug gipalakaw niya sila didto sa yuta sa sidlakan, halayo kang Isaac, nga iyang anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Mao kini ang mga adlaw sa katuigan sa kinabuhi ni Abraham, 175 ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Si Abraham miginhawa sa kataposang gininhawa ug namatay sa hilabihang katigulangon, usa ka tigulang nga tawo nga puno sa kinabuhi, ug gitipon siya sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ang iyang mga anak nga lalaki nga sila si Isaac ug si Ismael, maoy naglubong kaniya sa langob sa Macpela, didto sa kaumahan ni Efron nga anak ni Zohar nga usa ka Hitihanon, nga haduol sa Mamre. ");
INSERT INTO cebulb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Kini nga uma napalit ni Abraham gikan sa mga anak nga lalaki ni Heth. Gilubong si Abraham didto tapad kang Sara nga iyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Human sa kamatayon ni Abraham, gipanalanginan sa Dios si Isaac nga iyang anak nga lalaki, ug nagpuyo si Isaac duol sa Beerlahairoi. ");
INSERT INTO cebulb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Karon mao kini ang mga kaliwatan ni Ismael, nga anak nga lalaki ni Abraham, nga gianak ni Hagar gikan kang Abraham, ang Ehiptohanong ulipon ni Sara. ");
INSERT INTO cebulb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mao kini ang mga ngalan sa mga anak nga lalaki ni Ismael, sumala sa ilang adlawng natawhan: si Nebaiot ang panganay nga anak ni Ismael, si Kedar, si Adbeel, si Mibsam, ");
INSERT INTO cebulb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","si Misma, si Duma, si Masa, ");
INSERT INTO cebulb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","si Hadad, si Tema, si Jetur, si Nafis, ug si Kedema. ");
INSERT INTO cebulb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Mao kini ang mga anak nga lalaki ni Ismael, ug mao kini ang ilang mga ngalan, sumala sa ilang baryo, ug sumala sa ilang mga dapit; ang napulo ug duha ka mga prinsipe sumala sa ilang mga banay. ");
INSERT INTO cebulb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Mao kini ang katuigan sa kinabuhi ni Ismael, 137 ka tuig: miginhawa siya sa iyang kataposang gininhawa ug namatay, ug gitipon siya sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nagpuyo sila gikan sa Habila hangtod sa Sur, nga haduol sa Ehipto, nga padulong sa Asiria. Namuyo sila nga adunay panag-away sa usag-usa. ");
INSERT INTO cebulb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Mao kini ang mga panghitabo mahitungod kang Isaac; ang anak nga lalaki ni Abraham: si Abraham nahimong amahan ni Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ug 40 na ang panuigon ni Isaac sa pagpangasawa niya kang Rebeca, ang anak nga babaye ni Betuel ang Aramehanon sa Padan Aram, ang igsoong babaye ni Laban nga Aramehanon. ");
INSERT INTO cebulb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nag-ampo si Isaac kang Yahweh alang sa iyang asawa tungod kay wala pa siyay anak, ug gitubag ni Yahweh ang iyang pag-ampo, ug nagmabdos ang iyang asawa nga si Rebeca. ");
INSERT INTO cebulb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ang mga bata nanagbangi sa iyang sabakan, ug miingon siya, “Nganong nahitabo man kini kanako?” Miduol siya kang Yahweh aron mangutana mahitungod niini. ");
INSERT INTO cebulb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Giingnan siya ni Yahweh, “Duha ka nasod ang anaa sa imong sabakan, ug duha ka katawhan ang mabahin gikan kanimo. Ang usa ka nasod mahimong labing kusgan kaysa sa usa, ug ang kamagulangan moalagad sa manghod.” ");
INSERT INTO cebulb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sa pag-abot sa panahon nga manganak na siya, ania, adunay kaluha sa iyang sabakan. ");
INSERT INTO cebulb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ug ang una migawas nga bulagaw nga balhiboon ang iyang kinatibok-an sama sa balhiboon nga bisti. Ginganlan nila siya ug Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Human niana, migawas ang iyang igsoong lalaki. Ug ang iyang kamot naggunit sa tikod ni Esau. Gitawag siya ug Jacob. Si Isaac 60 na ang panuigon sa dihang gipanganak sila sa iyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Sa nanagko na ang mga batang lalaki, si Esau nahimong hanas nga mangangayam, ang tawo sa kaumahan; apan hilomon nga tawo si Jacob, nga nagpuyo lamang sa mga tolda. ");
INSERT INTO cebulb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Karon gihigugma ni Isaac si Esau tungod kay makakaon man siya sa mga mananap nga iyang gipangayam, apan gihigugma ni Rebeca si Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Naglata si Jacob ug pipila ka mga liso. Miabot si Esau gikan sa kaumahan, ug naluya siya gumikan sa kagutom. ");
INSERT INTO cebulb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Miingon si Esau kang Jacob, “Pakan-a ako nianang pula nga linat-an. Palihog, kay hilabihan ang akong kakapoy!” Mao kana ang hinungdan nga ang iyang ngalan gitawag ug Edom. ");
INSERT INTO cebulb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Miingon si Jacob, “Ibaligya una kanako ang imong katungod sa pagkamagulang.” ");
INSERT INTO cebulb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Mitubag si Esau, “Tan-awa, himalatyon na ako. Unsa pa may kaayohan sa katungod sa pagkamagulang dinhi kanako? ");
INSERT INTO cebulb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Miingon si Jacob, “Manumpa ka una kanako,” busa nanumpa si Esau ug nianang paagiha gibaligya niya ang iyang katungod sa pagkamagulang ngadto kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Gihatagan siya ni Jacob sa tinapay ug linat-an nga mga liso. Mikaon siya ug miinom, unya mitindog ug milakaw. Sa niini nga paagi gipakawalay bili ni Esau ang iyang katungod sa pagkamagulang. ");
INSERT INTO cebulb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Karon adunay kagutom nga nahitabo sa yuta, gawas pa sa kagutom sa mga adlaw ni Abraham. Miadto si Isaac kang Abimelec, ang hari sa mga Felistihanon sa Gerar. ");
INSERT INTO cebulb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Karon si Yahweh mipakita kaniya ug miingon, “Ayaw paglugsong didto sa Ehipto; puyo sa dapit nga isulti ko kanimo nga puy-an. ");
INSERT INTO cebulb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Pabilin dinhi niining yutaa, kay magauban ako kanimo ug magapanalangin kanimo; kay alang kanimo ug sa imong mga kaliwat, ihatag ko kining tanang kayutaan, ug pagatumanon ko ang akong gisaad kang Abraham nga imong amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Padaghanon ko ang imong kaliwatan sama sa mga kabituonan sa langit, ug ihatag ko kining tanang kayutaan sa imong mga kaliwatan. Pinaagi sa imong mga kaliwatan mapanalanginan ang tanang kanasoran. ");
INSERT INTO cebulb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Buhaton ko kini tungod kay nagmatinumanon man si Abraham sa akong tingog ug gitipigan ang akong mga gitudlo, ug ang akong mga kasugoan, ang akong mga pamatasan, ug ang akong mga balaod.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Busa mipuyo si Isaac sa Gerar. ");
INSERT INTO cebulb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Sa dihang mangutana kaniya ang mga tawo didtong dapita mahitungod sa iyang asawa, moingon siya, “Ako siyang igsoon nga babaye.” Nahadlok siya sa pagsulti nga, “Ako siyang asawa,” tungod kay naghunahuna man siya, “Patyon ako sa mga tawo niining dapita aron kuhaon si Rebeca, tungod kay siya maanyag kaayo.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Human makapuyo si Isaac didto sa pipila ka mga higayon, ug nahitabo nga milantaw sa iyang bintana si Abimelec, ang hari sa mga Felistihanon. Ania karon, nakita niya si Isaac naghagwa kang Rebeca nga iyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Gipatawag ni Abimelec si Isaac ngadto kaniya ug miingon, “Tan-awa, sigurado gayod nga asawa mo siya. Nganong miingon ka man nga, “Ako siyang igsoon?” Miingon si Isaac kaniya, “Tungod kay naghunahuna ako nga basin adunay mopatay kanako aron makuha siya.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Mitubag si Abimelec, “Unsa ba kining gibuhat mo kanamo? Sayon lang kaayo kang bisan kinsa ang modulog sa imong asawa, ug naghatag ka ug sala kanamo. ");
INSERT INTO cebulb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Busa gipahimangnoan ni Abimelec ang tanang mga tawo ug giingnan, “Si bisan kinsa ang motandog niining tawhana o sa iyang asawa pagapatyon.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nagtanom si Isaac niadtong yutaa ug miani sa gatosan ka pilo sa samang tuiga, tungod kay gipanalanginan man siya ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ang tawo naadunahan, ug nagmalambuon gayod hangtod nga nahimo siyang bantogan. ");
INSERT INTO cebulb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nakabaton siya ug daghang mga karnero ug mga baka, ug dakong panimalay. Ug nangasina kaniya ang mga Felistihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Karon ang tanang mga atabay nga gipangkalot sa mga sulugoon sa iyang amahan sa mga adlaw ni Abraham nga iyang amahan, gipanabonan sa mga Felistihanon pinaagi sa pagpuno niini ug yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Miingon si Abimelec kang Isaac, “Pahilayo na kanamo kay mas kusgan ka na kay kanamo. ");
INSERT INTO cebulb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Busa mibiya si Isaac didto ug nagbalong-balong sa walog sa Gerar, ug mipuyo didto. ");
INSERT INTO cebulb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Sa makausa pa gikalot ni Isaac pag-usab ang atabay nga may tubig, nga gipangkalot na nila sa mga adlaw ni Abraham nga iyang amahan. Gipangtabonan kini sa mga Felistihanon human sa kamatayon ni Abraham. Ginganlan ni Isaac ang mga atabay sa samang ngalan nga gipangalan sa iyang amahan kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Sa pagkalot sa mga sulugoon ni Isaac didto sa walog, nakakaplag sila didto ug usa ka atabay nga may nagtubod nga tubig. ");
INSERT INTO cebulb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nag-away ang mga magbalantay sa Gerar batok sa mga magbalantay ni Isaac, ug miingon, “Amoa kining tubiga.” Busa gitawag ni Isaac ang atabay ug “Esek,” tungod kay nakig-away man sila kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Unya nagkalot na usab sila ug lain nga atabay, ug nag-away na usab sila niadto, busa gitawag niya kini ug “Sitna.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mibiya siya didto ug mikalot ug lain na usab nga atabay, apan wala na sila nag-away niini. Busa gitawag niya kini nga Rehobot, ug miingon siya, “Karon si Yahweh naghatag ug dapit alang kanato, ug magmalambuon kita sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Unya mitungas si Isaac gikan didto padulong sa Beersheba. ");
INSERT INTO cebulb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mipakita kaniya si Yahweh nianang gabhiona ug miingon, “Ako ang Dios ni Abraham nga imong amahan. Ayaw kahadlok, kay ako magauban kanimo ug magpanalangin kanimo ug padaghanon ko ang imong kaliwatan, tungod ug alang sa akong sulugoon nga si Abraham.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nagbuhat si Isaac ug halaran didto ug misangpit sa ngalan ni Yahweh. Gitukod niya didto ang iyang tolda, ug ang iyang mga sulugoon nagkalot ug usa ka atabay. ");
INSERT INTO cebulb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Unya si Abimelec miadto kaniya gikan sa Gerar, uban ni Ahuzat, nga iyang higala, ug si Phicol, ang kapitan sa iyang kasundalohan. ");
INSERT INTO cebulb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Si Isaac miingon kanila, “Nganong mianhi man kamo kanako, sanglit gikasilagan na man ninyo ako ug gipapahawa gikan kaninyo?” ");
INSERT INTO cebulb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ug mitubag sila, “Nakita namo sa dayag nga si Yahweh nag-uban kanimo. Busa nakahukom kami nga kinahanglang aduna kitay panumpa tali kanato, oo, tali kanamo ug kanimo. Busa tugoti kaming makigsaad kanimo, ");
INSERT INTO cebulb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","nga dili mo kami hilabtan, sama ra nga wala ka namo hilabti, ingon nga gitagad namo kamo pag-ayo ug gipalakaw nga malinawon. Kay tinuod gayod, gipanalanginan ka ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Busa nagpakombira si Isaac alang kanila, nangaon sila ug nanginom. ");
INSERT INTO cebulb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mibangon sila sayo sa kabuntagon ug nanumpa sa usag-usa. Unya gipalakaw sila ni Isaac, ug mibiya silang malinawon. ");
INSERT INTO cebulb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Niadtong adlawa miabot ang mga sulugoon ni Isaac, ug gisuginlan nila siya mahitungod sa atabay nga ilang gikalot. Miingon sila, “Nakakaplag na kami ug tubig.” ");
INSERT INTO cebulb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Gitawag niya ang atabay ug Shiba, busa ang ngalan sa maong siyudad Beersheba hangtod karong mga panahona. ");
INSERT INTO cebulb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sa nagpanuigon na si Esau ug 40, gipangasawa niya si Judith ang anak ni Beeri nga Hitihanon, ug si Basemath ang anak ni Elon nga Hitihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nakapaguol sila ngadto kang Isaac ug kang Rebeca. ");
INSERT INTO cebulb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Sa pagkatigulang na ni Isaac ug mihalap na ang panan-aw sa iyang mga mata nga dili na siya makakita, gitawag niya si Esau, ang iyang kamagulangan nga anak, ug miingon kaniya, “Anak ko.” Mitubag siya kaniya, “Ania ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Miingon siya, “Tan-awa, tigulang na ako. Wala ako masayod sa adlaw sa akong kamatayon. ");
INSERT INTO cebulb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Busa kuhaa ang imong hinagiban, ang imong baslayan ug ang imong pana, ug lakaw sa kapatagan ug pangayam alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Lutoi ako ug lamian nga pagkaon, ang ampay nakong pagkaon, ug dad-a kini kanako aron nga makakaon ako niini ug mapanalanginan ko ikaw sa dili pa ako mamatay.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Karon nakadungog si Rebeca sa pagpakigsulti ni Isaac kang Esau nga iyang anak. Miadto si Esau sa kapatagan aron mangayam ug aron nga iyang madala pabalik. ");
INSERT INTO cebulb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Nakigsulti si Rebeca kang Jacob nga iyang anak ug miingon, “Tan-awa, nadungog ko ang imong amahan nga nakigsulti kang Esau nga imong igsoon. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Dad-an mo ako ug inayam ug lutoi ako ug lamiang pagkaon, aron makakaon ako niini ug mapanalanginan ko ikaw diha sa presensya ni Yahweh sa dili pa ako mamatay.' ");
INSERT INTO cebulb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Busa karon, akong anak nga lalaki, tumana ang akong tingog sumala sa akong isugo kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Adto sa mga kahayopan, ug dad-i ako ug duha ka maayong mga nating kanding; ug magluto ako ug lamiang pagkaon gikan niini alang sa imong amahan, ingon nga iyang ampay. ");
INSERT INTO cebulb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dad-on mo kini sa imong amahan, aron makakaon siya niini, aron nga sa ingon niana mapanalanginan ka niya sa dili pa siya mamatay.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Miingon si Jacob kang Rebeca nga iyang inahan, “Tan-awa, si Esau nga akong igsoon balhibuon man nga tawo, ug ako hamis nga tawo. ");
INSERT INTO cebulb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tingali hikapon ako sa akong amahan, ug mahibaloan ako ingon nga usa ka malimbungon. Modangat hinuon kanako ang tunglo ug dili ang panalangin.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ang iyang inahan miingon kaniya, “Akong anak, pasagdihi nga mahulog kanako ang bisan unsang tunglo. Tumana lamang ang akong tingog, lakaw, ug dad-a sila kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Busa milakaw si Jacob ug mikuha ug nating mga kanding ug gidala niya kini sa iyang inahan, ug nagluto ang iyang inahan ug lamian nga pagkaon, sama sa ampay sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Gikuha ni Rebeca ang labing maanindot nga bisti ni Esau, ang kinamagulangan niyang anak nga lalaki, nga anaa na sa iyang pinuy-anan, ug gipasul-ob kini kang Jacob, nga iyang kinamanghorang anak. ");
INSERT INTO cebulb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Gibutangan niya ug balhibo sa nating kanding ang iyang mga kamot ug sa hamis nga bahin sa iyang liog. ");
INSERT INTO cebulb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Gihatag niya ang lamian nga pagkaon ug ang tinapay nga iyang gihikay ngadto sa kamot ni Jacob nga iyang anak. ");
INSERT INTO cebulb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Miadto si Jacob sa iyang amahan ug miingon, “Akong amahan.” Mitubag siya, “Ania na ako; kinsa ka man, anak ko?” ");
INSERT INTO cebulb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Mitubag si Jacob sa iyang amahan, “Ako si Esau ang imong kamagulangang anak; gibuhat ko na ang imong gisulti kanako. Karon, bangon ug kaon sa akong inayaman, aron mapanalanginan mo na ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Miingon si Isaac sa iyang anak nga lalaki, “Giunsa mo man pagkakaplag niini nga dali ka ra man kaayo, akong anak?” Mitubag siya, “Tungod kay si Yahweh nga imong Dios nagdala niini kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Miingon si Isaac kang Jacob, “Paduol ngari kanako, aron hikapon ko ikaw, akong anak, ug aron akong mahibaloan kung ikaw ba gayod ang akong tinuod nga anak nga si Esau o dili.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Mipaduol si Jacob kang Isaac nga iyang amahan; ug gihikap siya ni Isaac ug miingon, “Ang tingog mao ang tingog ni Jacob, apan ang mga kamot mao ang mga kamot ni Esau.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wala na mailhi ni Isaac si Jacob, tungod kay ang iyang mga kamot balhiboon man, sama sa mga kamot sa iyang igsoon nga si Esau, busa gipanalanginan siya ni Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Miingon siya, “Ikaw ba gayod ang akong anak nga si Esau?” Ug mitubag siya, “Oo, ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Miingon si Isaac, “Ipaduol ang pagkaon dinhi kanako, ug kaonon ko na ang imong inayaman, aron mapanalanginan ko ikaw.” Gipaduol ni Jacob ang pagkaon ngadto kaniya. Mikaon si Isaac, ug gidad-an siya ni Jacob ug bino, ug miinom siya. ");
INSERT INTO cebulb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Unya ang iyang amahan nga si Isaac miingon kaniya, “Karon paduol kanako ug haloki ako, akong anak.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Miduol si Jacob ug mihalok kaniya, ug napanimahoan ni Isaac ang baho sa iyang mga bisti ug gipanalanginan siya. Miingon siya, “Tan-awa, ang baho sa akong anak sama sa baho sa uma nga gipanalanginan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hinaot nga pagahatagan ka sa Dios sa bahin sa yamog sa langit, ang bahin sa katambok sa yuta, ug ang daghang trigo ug ang bag-ong bino. ");
INSERT INTO cebulb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hinaot nga ang katawhan moalagad kanimo ug ang mga kanasoran moyukbo kanimo. Mahimo kang agalon sa imong mga igsoon, ug hinaot nga ang mga anak sa imong inahan moyukbo kanimo. Ug hinaot nga si bisan kinsa nga motunglo kanimo matinunglo usab; hinaot nga ang matag usa nga mopanalangin kanimo mapanalanginan usab.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Sa pagkahuman ni Isaac ug panalangin kang Jacob, mibiya dayon si Jacob sa atubangan sa iyang amahan nga si Isaac, kay miabot na ang iyang igsoon nga si Esau gikan sa iyang pagpangayam. ");
INSERT INTO cebulb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nagluto usab siya ug lamiang pagkaon ug gidala niya kini sa iyang amahan. Miingon siya sa iyang amahan, “Bangon na amahan ko ug kaon na sa inayaman sa imong anak, aron nga mapanalanginan mo na ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Miingon ang iyang amahan nga si Isaac kaniya, “Kinsa ka man?” Mitubag siya, “Ako ang imong kamagulangang anak nga si Esau.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nangurog si Isaac pag-ayo ug miingon, “Kinsa man kadtong nangayam niining inayaman ug midala niini kanako? Ako nang gikaon tanan sa wala pa ikaw moabot, ug gipanalanginan ko na siya. Sa pagkatinuod, napanalanginan gayod siya.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Sa pagkadungog ni Esau sa gipamulong sa iyang amahan, mitiyabaw siya sa makusog ug mihilak pag-ayo, ug miingon siya sa iyang amahan, “Panalangini usab ako, amahan ko.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Si Isaac miingon, “Ang imong igsoon malimbungong mianhi ug mikuha sa imong panalangin.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Miingon si Esau, “Dili ba nga insakto gayod nga ginganlan siya ug Jacob? Kay kaduha na niya ako malimbongi. Gikuha niya kanako ang katungod sa pagkamagulang, ug tan-awa, karon giilog niya ang akong panalangin.” Ug miingon siya, “Wala ka bay gigahin nga panalangin alang kanako?” ");
INSERT INTO cebulb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Mitubag si Isaac ug miingon kang Esau, “Paminaw, gihimo ko na siya nga imong agalon, ug gihatag ko na kaniya ang tanan niyang mga igsoon ingon nga iyang mga sulugoon. Ug gihatag ko na kaniya ang trigo ug ang bag-ong bino. Unsa pa man ang akong mabuhat kanimo, akong anak?” ");
INSERT INTO cebulb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Si Esau miingon sa iyang amahan, “Wala ka na ba diay bisan usa ka panalangin alang kanako, amahan ko? Panalangini ako, bisan ako usab, amahan ko.” Mihilak sa makusog si Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mitubag si Isaac nga iyang amahan ug miingon kaniya, “Tan-awa, ang yuta nga imong pagapuy-an halayo sa katambok sa yuta, halayo sa yamog sa kalangitan. ");
INSERT INTO cebulb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Pinaagi sa imong espada ikaw mabuhi, ug alagaran mo ang imong igsoon. Apan kung magmasinupakon ka, uyogon mo ang iyang yugo aron matangtang sa imong liog.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Gikasilagan ni Esau si Jacob tungod sa panalangin nga gihatag sa iyang amahan kaniya. Miingon si Esau sa iyang kasingkasing, “Ang mga adlaw sa pagbangotan alang sa akong amahan nagkaduol na; human niana pagapatyon ko ang akong igsoon nga si Jacob.” ");
INSERT INTO cebulb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ang mga gipamulong ni Esau nga iyang kamagulangang anak gisugilon ngadto kang Rebeca. Busa gipadala niya ug gipatawag si Jacob nga iyang kamanghorang anak ug miingon kaniya, “Tan-awa, ang imong igsoon nga si Esau naghupay sa iyang kaugalingon mahitungod kanimo pinaagi sa paglaraw sa pagpatay kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Busa karon, akong anak, tumana ako ug kalagiw didto sa akong igsoong lalaki nga si Laban, sa Haran. ");
INSERT INTO cebulb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pagpuyo uban kaniya sa makadiyot, hangtod nga mahupay ang kapungot sa imong igsoon, ");
INSERT INTO cebulb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","hangtod nga mawala ang kasuko sa imong igsoon kanimo, ug nga iyang makalimtan ang imong gibuhat kaniya. Unya pahibal-on ko ikaw ug pabalikon didto. Nganong kinahanglan mang mangawala kamong duha kanako sa usa ka adlaw? ");
INSERT INTO cebulb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Miingon si Rebeca kang Isaac, “Gikapoy na ako sa kinabuhi tungod sa mga anak nga babaye ni Heth. Kung mangasawa si Jacob gikan sa mga anak nga babaye ni Heth, sama niining mga babayhana, ug sa ubang mga anak sa maong yuta, unsa may kaayohan sa akong kinabuhi?” ");
INSERT INTO cebulb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Gitawag ni Isaac si Jacob, gipanalanginan, ug gimandoan siya, “Ayaw pangasawa gikan sa mga babaye sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tindog, ug pag-adto ngadto sa Paddan Aram, sa panimalay ni Betuel nga amahan sa imong inahan, ug pangasawa gikan didto, sa usa sa mga anak nga babaye ni Laban, nga igsoong lalaki sa imong inahan. ");
INSERT INTO cebulb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Hinaot nga ang Dios Makakagahom magpanalangin kanimo, maghimo kanimong mabungahon ug magpadaghan kanimo, aron mamahimo kang panon sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hinaot nga ihatag niya kanimo ang panalangin ni Abraham, alang kanimo, ug ngadto sa mosunod nimong mga kaliwatan, nga mapanunod mo ang yuta nga imong gipuy-an, nga gihatag sa Dios kang Abraham. ");
INSERT INTO cebulb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Busa gipalakaw ni Isaac si Jacob. Miadto si Jacob sa Paddan Aram, ngadto kang Laban nga anak nga lalaki ni Betuel nga Aramihanon, ang igsoong lalaki ni Rebeca, nga inahan ni Jacob ug Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Karon nakita ni Esau nga gipanalanginan ni Isaac si Jacob ug gipaadto siya sa Paddan Aram, aron mangasawa didto. Nakita usab niya nga gipanalanginan siya ni Isaac ug gisugo, nga nag-ingon, “Ayaw pagpangasawa gikan sa mga babaye sa Canaan.” ");
INSERT INTO cebulb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nakita usab ni Esau nga gituman ni Jacob ang iyang amahan ug inahan, ug miadto sa Paddan Aram. ");
INSERT INTO cebulb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Nakita ni Esau nga ang mga babaye sa Canaan wala makapahimuot sa iyang amahan nga si Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Busa miadto siya kang Ismael, ug nangasawa gawas sa iyang mga asawa, kang Mahalat ang anak nga babaye ni Ismael, nga anak nga lalaki ni Abraham, ang igsoong babaye ni Nebaioth, aron mamahimo niyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mibiya si Jacob sa Beersheba ug miadto padulong sa Haran. ");
INSERT INTO cebulb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Miabot siya sa usa ka dapit ug mipahulay didto sa tibuok gabii, tungod kay misalop na man ang adlaw. Mikuha siya ug usa sa mga bato niadtong dapita, ug giunlan kini sa iyang ulo, ug mihigda nianang dapita aron matulog. ");
INSERT INTO cebulb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nagdamgo siya ug nakita ang usa ka hagdanan nga nagbarog sa kalibotan. Ang tumoy niini miabot hangtod sa langit ug ang mga anghel sa Dios nagsaka kanaog niini. ");
INSERT INTO cebulb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tan-awa, nagbarog si Yahweh sa ibabaw niini ug miingon, “Ako si Yahweh, ang Dios ni Abraham nga imong amahan, ug ang Dios ni Isaac. Ang yuta nga imong gihigdaan, ihatag ko kanimo ug sa imong mga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ang imong kaliwatan mahisama sa abog sa kalibotan, ug mokaylap ka ngadto sa kasadpan, sa sidlakan, sa amihan ug sa habagatan. Diha kanimo ug sa imong kaliwatan mapanalanginan ang tanang panimalay sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tan-awa, magauban ako kanimo, ug bantayan ko ikaw bisan diin ka man moadto. Pagadad-on ko ikaw pagbalik niining yutaa; kay dili ko man ikaw biyaan. Pagabuhaton ko ang tanan nakong gisaad kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nakamata si Jacob gikan sa iyang paghikatulog, ug miingon siya, “Sa pagkatinuod ania si Yahweh niining dapita, ug wala ako masayod niini.” ");
INSERT INTO cebulb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nahadlok siya ug miingon, “Pagkamakalilisang niining dapita! Wala na kini lain kondili pinuy-anan sa Dios. Mao kini ang ganghaan sa langit.” ");
INSERT INTO cebulb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mibangon si Jacob sayo sa kabuntagon ug gikuha niya ang bato nga iyang giunlan sa iyang ulo. Gipatindog niya kini ingon nga usa ka haligi ug gibuboan niya ug lana ang ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ginganlan niya kadtong dapita ug Bethel, apan sa sinugdanan ang ngalan niadtong siyudara Luz. ");
INSERT INTO cebulb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nanumpa si Jacob nga nag-ingon, “Kung ang Dios mag-uban kanako ug magpanalipod kanako sa dalan nga akong pagalaktan, ug mohatag kanako ug tinapay aron makaon, ug mga bisti nga akong masul-ob, ");
INSERT INTO cebulb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","aron makabalik ako nga luwas sa balay sa akong amahan, unya si Yahweh mamahimo nakong Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Unya kining bato nga akong gipatindog ingon nga haligi handomanang bato. Ug sa tanang butang nga imong gihatag kanako, ihatag ko gayod pagbalik ang ikapulo kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Unya mipadayon si Jacob sa iyang panaw ug nahiabot siya sa kayutaan sa katawhan sa sidlakan. ");
INSERT INTO cebulb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Sa iyang pagtan-aw, nakakita siya ug atabay didto sa uma, ug ania, adunay tulo ka panon sa mga karnero nga naglubog niini. Kay gikan niana nga atabay magpainom sila sa mga panon sa kahayopan, ug adunay dako nga bato ibabaw sa baba sa atabay. ");
INSERT INTO cebulb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sa dihang matigom na didto ang tanang panon sa kahayopan, ang mga magbalantay maoy magligid sa bato gikan sa baba sa atabay ug magpainom sa mga karnero, ug unya ibutang ang bato ibabaw sa baba sa atabay balik sa nahimutangan niini. ");
INSERT INTO cebulb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Miingon si Jacob ngadto kanila, mga igsoon ko, asa man kamo gikan? Ug miingon sila, “Gikan kami sa Haran.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Miingon siya kanila, “Nakaila ba kamo kang Laban ang anak nga lalaki ni Nahor?” Mitubag sila, “Nakaila kami kaniya,” ");
INSERT INTO cebulb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Miingon siya kanila, “Maayo ba siya?” Sila mitubag, “Maayo man siya, ug tan-awa, nagpadulong dinhi ang iyang anak nga babaye nga si Raquel uban ang mga karnero.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Miingon si Jacob, “Tan-awa, hataas pa ang adlaw. Dili pa kini mao ang takna aron tigumon ang mga kahayopan. Kinahanglan paimnon una ninyo ang mga karnero ug unya lakaw ug pasabsaba sila.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Miingon sila, “Dili kami makapainom kanila hangtod nga matigom ang tanang kahayopan. Unya igaligid sa mga lakaki ang bato gikan sa baba sa atabay, ug makapainom na kami sa mga karnero.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Samtang nakigsulti pa si Jacob kanila, miabot si Raquel uban sa mga karnero sa iyang amahan, kay siya man ang nag-atiman kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Sa pagkakita ni Jacob kang Raquel, ang anak nga babaye ni Laban, nga igsoong lalaki sa iyang inahan, ug sa mga karnero ni Laban, nga igsoong lalaki sa iyang inahan, miduol si Jacob, ug giligid niya ang bato gikan sa baba sa atabay, ug gipainom ang kahayopan ni Laban, nga igsoon sa iyang inahan. ");
INSERT INTO cebulb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Gihalokan ni Jacob si Raquel ug mihilak siya sa makusog. ");
INSERT INTO cebulb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Gisultihan ni Jacob si Raquel nga siya mao ang paryente sa iyang amahan, ug nga siya ang anak ni Rebeca. Unya midagan siya ug gisuginlan ang iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Sa pagkadungog ni Laban sa balita mahitungod kang Jacob nga anak sa iyang igsoong babaye, midagan siya aron sa pagtagbo kaniya, gigakos niya siya ug gihalokan, ug gidala niya siya sa iyang panimalay. Gisugilon ni Jacob kang Laban kining tanang butang. ");
INSERT INTO cebulb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Miingon si Laban kaniya, “Ikaw gayod ang akong bukog ug ang akong unod.” Unya mipuyo si Jacob kaniya sa usa ka bulan. ");
INSERT INTO cebulb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Unya miingon si Laban kang Jacob, “Kinahanglan ba nga mag-alagad ka kanako nga walay bayad tungod kay ikaw akong paryente? Sultihi ako, unsa man ang ibayad kanimo?” ");
INSERT INTO cebulb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Karon si Laban adunay duha ka anak nga babaye. Ang ngalan sa kamagulangan mao si Lea, ug ang kinamanghoran mao si Raquel. ");
INSERT INTO cebulb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ang mga mata ni Lea malumo, apan si Raquel maanyag ang pamarog ug ang panagway. ");
INSERT INTO cebulb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Gihigugma ni Jacob si Raquel, busa miingon siya, “Mag-alagad ako kanimo sulod sa pito ka tuig alang kang Raquel, ang imong kamanghorang anak nga babaye.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Si Laban miingon, “Mas maayo pa nga ihatag ko siya kanimo kaysa ihatag ko siya sa ubang lalaki. Pagpuyo uban kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Busa nag-alagad si Jacob kang Laban sulod sa pito katuig alang kang Raquel; ug daw sama lamang kini sa pipila ka mga adlaw, tungod sa iyang gugma kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Unya miingon si Jacob kang Laban, “Ihatag na kanako ang akong asawa, kay nahingpit ko na ang mga adlaw—aron nga mapangasawa ko na siya!” ");
INSERT INTO cebulb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Busa gitigom ni Laban ang tanang tawo sa maong dapit ug nagpakombira siya. ");
INSERT INTO cebulb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pagkagabii niana, gikuha ni Laban ang iyang anak nga babaye nga si Lea ug gidala siya ngadto kang Jacob, nga nakigdulog kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ug gihatag ni Laban ang iyang babayeng sulugoon nga si Zilpa ngadto sa iyang anak nga si Lea, aron mahimo niyang sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sa pagkabuntag, tan-awa, si Lea diay kadto! Miingon si Jacob ngadto kang Laban, “Unsa man kining gibuhat mo kanako? Dili ba nag-alagad man ako kanimo alang kang Raquel? Nganong gilingla mo man ako?” ");
INSERT INTO cebulb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Mitubag si Laban, “Wala namo nabatasan ang paghatag una sa manghod kaysa magulang. ");
INSERT INTO cebulb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Taposa una ang simana sa kasal niining anak nga babaye, ug igahatag usab namo kanimo ang manghod ingon nga baylo sa imong pag-alagad pa kanako sa dugang pito katuig.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Busa gibuhat kana ni Jacob, ug gitapos ang simana ni Lea. Unya gihatag usab ni Laban kaniya si Raquel nga iyang anak nga babaye ingon nga iyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Gihatag usab ni Laban si Bilha ngadto sa iyang anak nga babaye nga si Raquel aron mahimo niyang sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Busa nakigdulog usab si Jacob kang Raquel, apan mas gihigugma pag-ayo niya si Raquel kaysa kang Lea. Busa nag-alagad pa si Jacob kang Laban sa dugang pito katuig. ");
INSERT INTO cebulb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nakita ni Yahweh nga wala gihigugma si Lea, busa giablihan niya ang iyang tagoangkan, apan si Raquel walay anak. ");
INSERT INTO cebulb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nagmabdos si Lea ug nanganak ug usa ka batang lalaki, ug ginganlan niya siya ug Ruben. Kay miingon siya, “Tungod kay nakita ni Yahweh ang akong kasakitan; higugmaon na gayod ako karon sa akong bana.” ");
INSERT INTO cebulb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Unya nagmabdos siya pag-usab ug nanganak ug usa ka batang lalaki. Miingon siya, “Tungod kay nadungog ni Yahweh nga wala ako higugmaa, gihatagan niya usab ako ug laing anak nga lalaki.” Ug ginganlan niya siya ug Simeon. ");
INSERT INTO cebulb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Unya nagmabdos na usab siya ug nanganak ug laing batang lalaki. Miingon siya, “Karon niining higayona mahigugma na kanako ang akong bana, tungod kay gipanganak ko alang kaniya ang tulo ka anak nga lalaki.” Busa ginganlan siya ug Levi. ");
INSERT INTO cebulb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nagmabdos siya pag-usab ug nanganak ug batang lalaki. Miingon siya, “Niining higayona pagadaygon ko si Yahweh.” Busa ginganlan siya ug Juda; unya mihunong na siya sa pagpanganak. ");
INSERT INTO cebulb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Sa pagkakita ni Raquel nga wala siya makabaton ug mga anak kang Jacob, nasina siya sa iyang igsoong babaye. Miingon siya kang Jacob, “Hatagi ako ug mga anak, o mamatay ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Hilabihan ang kasuko ni Jacob kang Raquel. Miingon siya, “Anaa ba ako sa dapit sa Dios, nga nagpugong kanimo sa pagbaton ug mga anak?” ");
INSERT INTO cebulb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Miingon siya, “Tan-awa, ania ang akong sulugoon nga si Bilha. Pakigdulog kaniya, aron makapanganak siya diha sa akong tuhod, ug makabaton ako ug mga anak pinaagi kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Busa gihatag niya ang iyang sulugoon nga si Bilha ingon nga asawa, ug si Jacob nakigdulog kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nagmabdos si Bilha ug nanganak ug batang lalaki alang kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Unya miingon si Raquel, “Midapig ang Dios kanako. Naminaw siya sa akong pag-ampo ug gihatagan ako ug usa ka anak nga lalaki.” Tungod niini ginganlan niya siya ug Dan. ");
INSERT INTO cebulb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nagmabdos usab ang sulugoon ni Raquel nga si Bilha, ug nanganak sa ikaduhang anak nga lalaki alang kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Si Raquel miingon, “Pinaagi sa pagpakiglayog nga hilabihan nakiglayog ako sa akong igsoong babaye ug nagmadaogon ako.” Ginganlan niya siya ug Neptali. ");
INSERT INTO cebulb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sa pagkakita ni Lea nga mihunong na siya sa pagpanganak, gikuha niya si Zilpa, nga iyang sulugoon, ug gihatag siya kang Jacob ingon nga asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ang sulugoon ni Lea nga si Zilpa, nanganak ug batang lalaki kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Miingon si Lea, “Palaran kini!” busa ginganlan niya siya ug Gad. ");
INSERT INTO cebulb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Unya si Zilpa, ang sulugoon ni Lea, nanganak sa ikaduhang batang lalaki alang kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Miingon si Lea, “Malipayon ako! Kay ang mga anak nga babaye magtawag kanako nga malipayon.” Busa ginganlan niya siya ug Aser. ");
INSERT INTO cebulb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Milakaw si Ruben sa mga adlaw nga ting-ani sa trigo ug nakakaplag siya ug mandragora sa uma. Gidala niya kini ngadto sa iyang inahan nga si Lea. Unya miingon si Raquel ngadto kang Lea, “Hatagi ako sa pipila ka mandragora sa imong anak nga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Miingon si Lea ngadto kaniya, “Diyutay lamang ba kini nga butang alang kanimo, nga gikuha mo usab ang akong bana? Unya gusto mo usab kuhaon ang mandragora sa akong anak nga lalaki?” Miingon si Raquel, “Kung ingon niana man, makadulog siya kanimo karong gabhiona, baylo sa mandragora sa imong anak nga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Miabot si Jacob gikan sa uma nianang gabhiona. Migawas si Lea aron sa pagsugat kaniya ug miingon, “Kinahanglang makigdulog ka kanako karong gabhiona, kay gisuholan ko ikaw pinaagi sa mandragora sa akong anak.” Busa nakigdulog si Jacob kang Lea nianang gabhiona. ");
INSERT INTO cebulb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Gidungog sa Dios si Lea, ug nagmabdos siya ug nanganak sa ikalimang anak nga lalaki alang kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Miingon si Lea, “Gihatag sa Dios kanako ang akong balos, tungod kay akong gihatag ang akong sulugoon nga babaye sa akong bana.” Ginganlan niya siya ug Isacar. ");
INSERT INTO cebulb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nagmabdos pag-usab si Lea ug nanganak sa ikaunom nga anak nga lalaki alang kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Miingon si Lea, “Naghatag ang Dios kanako ug usa ka maayong gasa. Karon pasidunggan na ako sa akong bana, tungod kay gianak ko man alang kaniya ang unom ka batang lalaki.” Ginganlan niya siya ug Zebulun. ");
INSERT INTO cebulb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pagkahuman niana nanganak siya ug batang babaye ug ginganlan siya ug Dina. ");
INSERT INTO cebulb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nahinumdom ang Dios kang Raquel ug naminaw kaniya. Gitugot sa Dios nga magmabdos siya. ");
INSERT INTO cebulb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nagmabdos siya ug nanganak sa usa ka batang lalaki. Miingon siya, “Gikuha sa Dios ang akong kaulaw.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ginganlan niya siya ug Jose, nga nag-ingon, “Si Yahweh nagdugang kanako ug usa ka anak nga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Human manganak si Raquel kang Jose, miingon si Jacob kang Laban, “Palakwa ako, aron nga makauli na ako sa akong kaugalingong panimalay ug sa akong nasod. ");
INSERT INTO cebulb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ihatag kanako ang akong mga asawa ug ang akong mga anak nga akong gialagaran kanimo, ug tugoti ako sa paglakaw, kay nasayod ka sa pag-alagad nga gialagad ko kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Miingon si Laban kaniya, “Kung makakaplag ako karon ug kalooy sa imong mga mata, hulat usa, tungod kay akong nasayran pinaagi sa panagna nga gipanalanginan ako ni Yahweh tungod kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Unya miingon siya, “Ibungat ang imong mga suhol, ug pagabayaran ko kini.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Si Jacob miingon kaniya, “Nasayod ka kung giunsa ko ikaw pag-alagad, ug kung giunsa ko ang kahimtang sa imong mga kahayopan. ");
INSERT INTO cebulb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kay diyutay lamang ang imo sa wala pa ako miabot, ug midaghan kini pag-ayo. Gipanalanginan ka ni Yahweh bisan asa ako ang magbuhat. Karon kanus-a pa man ako makahatag usab alang sa akong kaugalingong panimalay?” ");
INSERT INTO cebulb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Busa miingon si Laban, “Unsa man ang akong ibayad kanimo?” Mitubag si Jacob, “Dili ka na maghatag kanako ug bisan unsa. Kay kung buhaton mo kini alang kanako, pasibsibon ko pag-usab ang imong mga panon sa kahayopan ug atimanon kini. ");
INSERT INTO cebulb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Palakawa ako sa tanang panon sa imong kahayopan karong adlawa, magalain ako sa puntik-puntik ug sa kabang nga mga karnero, ug sa matag itom diha sa mga karnero, ug ang puntik-puntik ug ang kabang nga mga kanding. Mao kini ang akong suhol. ");
INSERT INTO cebulb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ang akong kadungganan magpamatuod kanako human sa pagsusi nimo sa akong mga suhol. Ang tanan nga dili puntik-puntik ug dili kabang diha sa mga kanding, ug ang tanan nga itom diha sa mga karnero, nga makaplagan mo kanako, pagaisipon mo kini nga kinawat.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Miingon si Laban. “Mouyon ako. Mahitabo unta kini sumala sa imong gipamulong.” ");
INSERT INTO cebulb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nianang adlawa gilain ni Laban ang mga lake nga kanding nga adunay badlis ug kabang, ug ang tanang baye nga mga kanding nga puntik-puntik ug kabang, ang matag usa nga adunay puti niini, ug ang tanang itom diha sa mga karnero, ug gihatag kini sa kamot sa iyang mga anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nagtakda usab si Laban ug tulo ka adlaw nga panaw tali kaniya ug kang Jacob. Busa nagpadayon si Jacob sa pagpasibsib sa tanang nahibilin nga kahayopan ni Laban. ");
INSERT INTO cebulb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mikuha si Jacob ug bag-ong putol nga mga sanga sa lunhaw nga poplar, ug sa alamo ug sa palano nga kahoy ug gipal-akan ang panit niini maputi, ug gihimo nga makita ang puti sa kahoy nga pinal-akan nga anaa sa mga sanga. ");
INSERT INTO cebulb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Unya gibutang niya ang sanga nga iyang pinanitan atubangan sa mga panon sa kahayopan, sa atubangan sa pasungan nga paimnanan kung asa sila manginom. Nagmabdos sila sa dihang mangadto sila aron moinom. ");
INSERT INTO cebulb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Nag-upahanay ang mga kahayopan atubangan sa mga sanga; ug ang panon sa kahayopan nanganak nga may mga badlis, mga puntik-puntik, ug mga kabang. ");
INSERT INTO cebulb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Gilain ni Jacob kining mga nating karnero, apan gipaatubang ang nahibilin kanila sa may mga badlis nga mga kahayopan ug ang tanang itom nga karnero sa panon sa kahayopan ni Laban. Unya gilain niya ang iyang panon sa kahayopan alang lamang sa iyang kaugalingon ug wala sila itipon uban sa panon sa kahayopan ni Laban. ");
INSERT INTO cebulb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ug nahitabo nga sa dihang mosanay ang kusgan nga karnero diha sa panon, didto ibutang ni Jacob ang mga sanga sa pasungan nga paimnanan sa atubangan sa mga mata sa panon sa kahayopan, aron manamkon sila taliwala sa mga sanga. ");
INSERT INTO cebulb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Apan kung moduol ang mga luyahon nga kahayopan sa panon, dili niya ibutang ang mga sanga sa atubangan nila. Busa ang mga luyahon nga kahayopan mao ang kang Laban, ug ang mga kusgan mao ang kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ang tawo nagmalambuon. Nakabaton siya ug dakong panon sa kahayopan, mga sulugoon nga babaye ug mga lalaki, ug mga kamelyo ug mga asno. ");
INSERT INTO cebulb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Karon nadunggan ni Jacob ang mga pulong sa mga anak nga lalaki ni Laban, nga sila miingon, “Gikuha ni Jacob ang tanan nga iya sa atong amahan, ug gikan sa gipanag-iyahan sa atong amahan ang tanan nga niyang katigayonan.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nakita ni Jacob ang panagway ni Laban. Nakita niya nga nausab ang tinagdan ni Laban ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Unya miingon si Yahweh kang Jacob, “Balik ngadto sa yuta sa imong katigulangan ug sa imong kaparyentihan, ug mag-uban ako kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gipatawag ni Jacob si Raquel ug si Lea didto sa sibsibanan sa panon sa iyang mananap ");
INSERT INTO cebulb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ug miingon kanila, “Namatikdan nako nga nausab ang tinagdan sa inyong amahan nganhi kanako, apan ang Dios sa akong amahan nakig-uban kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nasayod kamo nga sa tibuok nakong kusog nag-alagad ako sa inyong amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Gilimbongan ako sa inyong amahan ug giusab-usab niya ang akong suhol sa napulo ka higayon, apan ang Dios wala motugot kaniya sa pagpasakit kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sa dihang miingon siya, 'Ang mga puntik-puntikon nga mananap mao ang imong bayad,' nanganak ang tanang panon sa mananap ug puntik-puntikon. Ug sa dihang miingon siya, 'Ang adunay badlis-badlis mao ang imong bayad,' nanganak ang tibuok panon sa mananap ug adunay badlis-badlis. ");
INSERT INTO cebulb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ingon niini nga paagi gikuha sa Dios ang mga mananap sa imong amahan ug gihatag kini nganhi kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Usa ka higayon sa panahon sa tingsanay sa mga mananap, nakita ko sa damgo nga ang mga laki nga kanding nakig-upa sa panon sa kanding. Ang mga laki nga kanding nga adunay badlis-badlis, mga puntik-puntikon, ug mga kabang. ");
INSERT INTO cebulb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Miingon ang anghel sa Dios kanako diha sa damgo, 'Jacob.' Mitubag ako, 'Ania ako.' ");
INSERT INTO cebulb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Miingon siya, 'Itutok ang imong mata ug tan-awa ang tanang mga kanding nga laki nga ning-upa sa panon sa kanding nga adunay badlis-badlis, ug puntik-puntikon, ug kabang, tungod kay nakita ko ang tanan nga gibuhat ni Laban kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ako ang Dios didto sa Betel, diin gidihogan nimo ang haligi, diin naghimo ka ug panaad nganhi kanako. Karon bangon ug biyai kining yutaa ug balik sa yuta nga imong natawhan.”' ");
INSERT INTO cebulb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Mitubag si Raquel ug si Lea ug miingon kaniya, “Aduna pa ba kamiy bahin o mapanunod sa panimalay sa among amahan? ");
INSERT INTO cebulb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Dili ba iya man kaming giisip ingon nga mga langyaw? Tungod kay gibaligya kami niya ug gihurot usab niya ang among salapi. ");
INSERT INTO cebulb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tungod kay ang tanang katigayonan nga gikuha sa Dios gikan sa among amahan amoa ug sa among mga anak. Busa karon, buhata dayon ang bisan unsa nga giingon sa Dios kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Busa nangandam si Jacob ug gipasakay ang iyang mga anak nga lalaki ug ang iyang mga asawa ngadto sa mga kamelyo. ");
INSERT INTO cebulb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Gipalakaw niya ang iyang mga kahayopan una kaniya, uban sa tanan niyang kabtangan, lakip ang mga kahayopan nga iyang napanag-iya sa Padan Aram. Unya nangandam siya padulong sa iyang amahan nga si Isaac sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Sa dihang milakaw si Laban aron sa pagpanupi sa iyang karnero, gikawat ni Raquel ang diosdios sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Gilingla usab ni Jacob si Laban nga Arameanhon, tungod kay wala siya nananghid kaniya nga mobiya na. ");
INSERT INTO cebulb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Busa mikalagiw siya uban sa tanan nga iyang gipanag-iya ug dali nga mitabok sa Suba, ug mipadulong ngadto sa kabungtoran sa Gilead. ");
INSERT INTO cebulb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Sa ikatulo nga adlaw gisuginlan si Laban nga mikagiw na si Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Busa gidala niya ang iyang mga paryente kuyog kaniya ug migukod kaniya sulod sa pito ka adlaw nga pagpanaw. Naapsan niya siya didto sa bungtod sa Gilead. ");
INSERT INTO cebulb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Unya sa pagkagabii nagpakita ang Dios kang Laban nga Arameanhon diha sa usa ka damgo ug miingon kaniya, “Pag-amping sa imong isulti ngadto kang Jacob maayo man o daotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Naapsan ni Laban si Jacob samtang gitaod ang iyang tolda didto sa bungtod. Nagkampo usab si Laban kauban ang iyang mga paryente didto sa bungtod sa Gilead. ");
INSERT INTO cebulb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Miingon si Laban kang Jacob, “Unsa man kining imong gihimo, nga imoha man akong gilimbongan ug gidala ang akong mga anak sama sa mga bihag sa gubat? ");
INSERT INTO cebulb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nganong mikalagiw ka man sa tago ug gilingla ako nimo ug wala suginli. Palakwon ko unta kamo inubanan ang mga pagsaulog ug mga pag-awit, uban sa tamborin ug sa mga alpa. ");
INSERT INTO cebulb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wala man lang ko nimo tugoti sa paghalok sa akong mga apo nga lalaki ug sa akong mga anak nga babaye agig panamilit. Binuang kining imong gihimo. ");
INSERT INTO cebulb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aduna unta akoy gahom sa pagsakit kaninyo, apan ang Dios sa imong amahan misulti kanako kagabii ug miingon, 'Pag-amping sa imong isulti ngadto kang Jacob maayo man o daotan.' ");
INSERT INTO cebulb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ug karon, mipahawa ka tungod kay naghandom ka pag-ayo sa panimalay sa imong amahan. Apan nganong gikawat man nimo ang akong mga diosdios?” ");
INSERT INTO cebulb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Mitubag si Jacob ug miingon kang Laban, “Tungod kay nahadlok ako ug naghunahuna nga imong kuhaon pagpugos ang imong mga anak nga babaye gikan kanako mao nga mibiya ako sa tago. ");
INSERT INTO cebulb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Si bisan kinsa ang mikawat sa imong mga diosdios mamatay. Sa atubangan sa atong mga paryente, tan-awa kung unsa ang ania kanako nga imoha ug kuhaa kini.” Tungod kay wala man masayod si Jacob nga si Raquel mao ang nagkawat niini. ");
INSERT INTO cebulb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Misulod si Laban ngadto sa tolda ni Jacob, sa tolda ni Lea, ug ngadto sa tolda sa duha ka mga sulugoon nga babaye, apan wala gayod niya kini makita. Migawas siya sa tolda ni Lea ug misulod ngadto sa tolda ni Raquel. ");
INSERT INTO cebulb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Karon gikuha na ni Raquel ang mga diosdios, ug gibutang kini sa sakang sa kamelyo, ug gilingkoran niya kini. Nangita si Laban sa tibuok tolda, apan wala gayod niya kini nakita. ");
INSERT INTO cebulb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Miingon siya sa iyang amahan, “Ayaw kasuko akong agalon, nga dili ako makabarog sa imong atubangan, tungod kay giregla ako.” Busa nangita siya apan wala niya hikaplagi ang iyang mga diosdios. ");
INSERT INTO cebulb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nasuko si Jacob ug nakiglalis kang Laban. Miingon siya kaniya, “Unsa man ang akong sayop? Unsa man ang akong sala, nga mainiton ka man nga migukod kanako? ");
INSERT INTO cebulb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kay giutingkay mo na ang tanan kong mga kabtangan. Unya unsa may imong nakita nga butang nga imoha? Dad-a ngari sa atubangan sa atong mga paryente aron mohukom sila tali natong duha. ");
INSERT INTO cebulb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Sulod sa 20 ka tuig nga nakig-uban ako kanimo. Wala gayod nakuhai sa ilang pagburos ang imong mga baye nga karnero ug mga kanding, ni nagkaon ako sa bisan usa nga laking karnero nga gikan sa imong panon. ");
INSERT INTO cebulb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kadtong gikunis-kunis sa mga mananap wala nako dad-a kanimo. Hinuon, ako ang nahimong responsable sa mga nawala niini. Kanunay nimong gipabayran kanako ang matag nawala nga mananap, kung gikawat kini sa adlaw man o sa gabii. ");
INSERT INTO cebulb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Anaa ako; sa adlaw nga ang kainit mituhop kanako, ug ang katugnaw sa kagabhion; ug wala akoy tulog. ");
INSERT INTO cebulb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Anaa ako sa imong panimalay sa milabay nga 20 ka tuig. Nagtrabaho ako kanimo sulod sa napulog upat ka tuig alang sa imong duha ka anak nga babaye, ug unom ka tuig alang sa imong mga mananap. Giusab nimo ang akong suhol sa napulo ka higayon. ");
INSERT INTO cebulb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gawas kung ang Dios sa akong amahan, ang Dios ni Abraham, ug ang gikahadlokan ni Isaac, wala pa nag-uban kanako, papahawaon gayod nimo ako nga walay dala. Nakita sa Dios ang akong pag-antos ug kung unsa kalisod ang akong pagtrabaho, ug gibadlong ka niya kagabii.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Mitubag si Laban ug miingon kang Jacob, “Kanang mga babaye akoa nang mga anak, ang ilang mga anak ako nang mga apo, ug ang panon sa mga mananap ako nang mga mananap. Tanan nga imong nakita akoa. Apan unsa pa may mabuhat nako karon sa akong mga anak nga babaye, o sa mga anak nga ilang gipakatawo? ");
INSERT INTO cebulb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Busa karon, magbuhat kita ug kasabotan, ikaw ug ako, ug mamahimo kining usa ka saksi tali kanimo ug kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Busa nagkuha si Jacob ug usa ka dakong bato ug iya kining gibutang ingon nga usa ka haligi. ");
INSERT INTO cebulb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Miingon si Jacob sa iyang mga paryente, “Pagtapok ug mga bato.” Busa nagkuha sila ug mga bato ug gipatong-patong nila kini. Unya nangaon sila didto duol sa gipatong-patong nga mga bato. ");
INSERT INTO cebulb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Gitawag kini ni Laban ug Jegar Saha Duta, apan gitawag kini ni Jacob ug Galeed. ");
INSERT INTO cebulb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Miingon si Laban, “Kining gipatong-patong nga mga bato mao ang saksi tali kanako ug kanimo karong adlawa.” Busa ang ngalan niini gitawag ug Galeed. ");
INSERT INTO cebulb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Gitawag usab kini ug Mispa, tungod kay nag-ingon si Laban, “Magbantay unta si Yahweh tali kanimo ug kanako, kung dili man kita magkita. ");
INSERT INTO cebulb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kung imong pasipad-an ang akong mga anak, ug mangasawa ka ug lain gawas sa akong mga anak, bisan tuod wala kita nag-uban, tan-awa, saksi ang Dios tali kanimo ug kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Miingon si Laban kang Jacob, “Tan-awa kining gipatong-patong nga mga bato, ug tan-awa ang haligi, nga diin gihimo ko tali kanimo ug kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kining gipatong-patong nga mga bato, ug ang haligi mao ang saksi, nga dili ako molatas niining gipatong-patong nga mga bato paingon kanimo, ug dili usab ikaw molatas niining gipatong-patong nga mga bato ug haligi paingon kanako aron sa pagbuhat ug daotan. ");
INSERT INTO cebulb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ang Dios ni Abraham, ug ang Dios ni Nahor, ang Dios sa ilang amahan, maghukom unta tali kanato.” Nanumpa si Jacob sa Dios, nga mao ang gikahadlokan ni Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Naghalad ug usa ka sakripisyo si Jacob didto sa bukid ug gidapit niya ang iyang mga paryente aron mangaon. Nangaon sila ug nagpagabii sila didto sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Sayo sa kabuntagon mibangon si Laban ug gihagkan niya ang iyang mga apo nga lalaki ug ang iyang mga anak nga babaye ug gipanalanginan niya sila. Unya mibiya si Laban ug mibalik sa iyang panimalay. ");
INSERT INTO cebulb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mipadayon usab si Jacob sa iyang panaw, ug misugat ang mga anghel sa Dios kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Sa pagkakita ni Jacob kanila, miingon siya, “Kampo kini sa Dios,” busa gitawag niya ang dapit ug Mahanaim. ");
INSERT INTO cebulb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nagpadala si Jacob ug mga sulugoon nga mouna kaniya ngadto kang Esau, sa yuta sa Seir, sa rehiyon sa Edumea. ");
INSERT INTO cebulb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Gimandoan niya sila ug miingon, “Mao kini ang isulti ninyo sa akong agalon nga si Esau: Mao kini ang gisulti ni Jacob nga imong sulugoon: 'Mipuyo ako kang Laban, ug nagpabilin gihapon hangtod karon. ");
INSERT INTO cebulb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Aduna na akoy mga baka, mga asno ug mga panon sa mananap, mga sulugoong lalaki, ug mga sulugoong babaye. Gipadala ako sa pagsulti niini sa akong agalon, aron makakaplag unta ako ug pabor sa imong atubangan.''' ");
INSERT INTO cebulb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mibalik ang mga sulugoon ngadto kang Jacob ug miingon, “Gikan kami sa imong igsoon nga si Esau, Moanhi siya sa pagsugat kanimo, ug kuyog niya ang 400 ka mga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Unya nahadlok ug naguol pag-ayo si Jacob. Busa gibahin niya ang mga tawo nga iyang kuyog sa duha ka kampo, ug mao usab ang mga panon sa mananap, ug mga kamelyo. ");
INSERT INTO cebulb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Miingon siya, “Kung moabot si Esau ngadto sa usa ka kampo ug atakihon kini, ang kampo nga nahibilin mahimong makaikyas.” ");
INSERT INTO cebulb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nag-ampo si Jacob, “Dios sa akong amahan nga si Abraham, ug Dios sa akong amahan nga si Isaac, Yahweh, nag-ingon ka kanako, 'Balik ngadto sa imong nasod ug sa imong mga kaliwatan, ug pauswagon ko ikaw,' ");
INSERT INTO cebulb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","dili ako takos sa imong pagkamatinud-anon sa kasabotan ug sa tanan nga imong pagkamasaligon sa imong alagad. Tungod kay pinaagi lamang sa sungkod nga ako nakatabok niining Jordan, ug karon nahimo na akong duha ka mga kampo. ");
INSERT INTO cebulb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Luwasa intawon ako sa kamot sa akong igsoon nga si Esau, tungod kay nahadlok ako kaniya, nga basin moabot siya ug atakihon niya ako ug ang mga inahan uban sa mga bata. ");
INSERT INTO cebulb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Apan miingon ka, “Palamboon ko gayod ikaw. Himoon ko ang imong mga kaliwat nga sama kadaghan sa balas sa baybayon, nga dili maihap tungod sa ilang kadaghan.''' ");
INSERT INTO cebulb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nagpabilin didto si Jacob nianang gabhiona. Mikuha siya ug pipila ka mga mananap nga anaa kaniya isip gasa alang kang Esau, nga iyang igsoon: ");
INSERT INTO cebulb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 ka mga baye ug 20 ka mga laki nga kanding, 200 ka mga baye ug 20 ka mga laki nga karnero, ");
INSERT INTO cebulb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 ka gatasan nga mga kamelyo ug mga anak niini, 40 ka mga baka ug napulo ka mga turo, 20 ka mga baye ug napulo ka mga laki nga asno. ");
INSERT INTO cebulb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Gipiyal niya kini ngadto sa iyang mga sulugoon, ang matag panon sa mga mananap. Miingon siya sa iyang mga sulugoon, “Pag-una kamo kanako ug hatagig gilay-on ang matag panon.” ");
INSERT INTO cebulb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Gimandoan niya ang unang sulugoon nga nag ingon, “Kung imong matagboan si Esau nga akong igsoon ug mangutana kanimo nga moingon, 'Kang kinsa ka man nahisakop? Asa man kamo paingon? Ug kang kinsa man kining mga mananap nga anaa sa imong atubangan?' ");
INSERT INTO cebulb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Unya motubag ka, 'Iya kini ni Jacob nga imong sulugoon. Mga gasa kini nga gipadala alang kang Esau nga akong agalon. Ug tan-awa, padulong na usab siya sunod kanamo.''' ");
INSERT INTO cebulb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nagmando na usab si Jacob sa ikaduhang pundok, sa ikatulo, ug sa tanang mga lalaki nga nagsunod sa panon sa mga mananap. Siya miingon, “Isulti ninyo ang susamang butang ngadto kang Esau kung inyo siyang matagboan. ");
INSERT INTO cebulb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kinahanglan moingon usab kamo, 'Si Jacob nga imong sulugoon padulong na sunod kanamo.''' Tungod kay naghuna-huna siya, “Mahupay nako siya sa mga gasa nga gipadala ko una kanako. Aron unya, kung makita ko siya, basin nga iya akong dawaton.” ");
INSERT INTO cebulb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Busa gipadala niya una kaniya ang mga gasa. Ug siya nalang ang nagpabilin sa kampo niadtong gabhiona. ");
INSERT INTO cebulb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mibangon si Jacob sa kagabhion, ug gikuha niya ang iyang duha ka asawa, duha ka sulugoon nga babaye, ug ang iyang napulog usa ka mga anak nga lalaki. Ug iyang gipatabok sa tabokanan sa suba sa Jabok. ");
INSERT INTO cebulb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Niini nga paagi, gipalakaw niya sila tabok sa suba uban sa tanan niyang mga gipanag-iyahan. ");
INSERT INTO cebulb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nag-inusara nalang si Jacob, ug adunay usa ka tawo nga nakiglayog kaniya hangtod sa pagka-kaadlawon. ");
INSERT INTO cebulb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sa pagkakita sa tawo nga dili niya mapildi si Jacob, iyang gihapak ang dapidapi ni Jacob. Nalisa ang dapidapi ni Jacob sa dihang nakiglayog siya kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Miingon ang tawo, “Buhii na ako kay hapit na mabuntag.” Si Jacob miingon, dili ko ikaw buhian gawas king imo na akong panalanginan.” ");
INSERT INTO cebulb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nangutana ang tawo kaniya, “Unsa man ang imong ngalan?” Miingon siya “Jacob.” ");
INSERT INTO cebulb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ang tawo miingon, “Dili na Jacob ang imong ngalan, kung dili Israel na. Kay nakiglayog ka sa Dios ug sa mga tawo ug midaog.'' ");
INSERT INTO cebulb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nangutana si Jacob kaniya, “Palihog suginli ako sa imong ngalan.” Mitubag siya, “Nganong nangutana ka man sa akong ngalan?” Ug unya gipanalanginan niya siya didto. ");
INSERT INTO cebulb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Gitawag ni Jacob ang dapit ug Peniel kay miingon siya, “Nakita ko ang panagway sa Dios, ug naluwas ang akong kinabuhi.'' ");
INSERT INTO cebulb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Misubang na ang adlaw samtang mibiya si Jacob sa Peniel. Nagtakiang siya tungod sa iyang dapidapi. ");
INSERT INTO cebulb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Mao nga hangtod karong adlawa, ang mga Israelita dili na mokaon sa unod sa luta-lutahan sa may dapidapi, tungod kay mao kini ang gibikil sa tawo sa dihang iyang gikasa sa dapidapi ni Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Mihangad si Jacob ug, tan-awa, si Esau nagpadulong na, ug uban kaniya ang 400 ka mga kalalakin-an. Gibahin ni Jacob ang mga kabataan diha kang Lea, Raquel, ug ang duha ka babaye nga mga sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Unya gibutang niya ang mga babaye nga mga sulugoon ug ang ilang mga anak sa unahan, ug gisundan ni Lea ug sa iyang mga anak, ug gisundan kini ni Raquel ug Jose nga anaa sa pinakaulahian sa tanan. ");
INSERT INTO cebulb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nag-una si Jacob kanila. Miyukbo siya sa yuta sa makapito ka higayon, hangtod nahiduol siya sa iyang igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Midagan si Esau aron sa pagtagbo kaniya, migakos kaniya, migakos sa iyang liog, ug mihalok kaniya. Unya nanghilak sila. ");
INSERT INTO cebulb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Sa paghangad ni Esau, nakita niya ang mga kababayen-an ug ang mga kabataan. Miingon siya, “Kinsa man kining mga katawhan nga imong kauban?” Miingon si Jacob, “Ang mga bata ang madagayaon nga gihatag sa Dios sa imong alagad.” ");
INSERT INTO cebulb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Unya mipaduol ang mga sulugoong babaye uban sa ilang mga anak, ug miyukbo sila. ");
INSERT INTO cebulb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Misunod usab si Lea ug ang iyang mga anak nga mipaduol ug miyukbo. Sa kataposan mipaduol ug miyukbo si Jose ug Raquel. ");
INSERT INTO cebulb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Miingon si Esau, “Unsay buot nimong ipasabot niining tanang pundok nga akong nahimamat?” Miingon si Jacob, “Aron makakaplag og kaluoy sa panan-aw sa akong agalon.” ");
INSERT INTO cebulb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nag-ingon si Esau, “Igo na ang akong nabatonan, igsoon ko. Tipigi kung unsay anaa kanimo alang sa imong kaugalingon.” ");
INSERT INTO cebulb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Nag-ingon si Jacob, “Dili, palihog, kung nakakaplag ako og kaluoy sa imong panan-aw, dawata ang akong gasa gikan sa akong kamot, kay sa pagkatinuod, nakita ko ang imong panagway, ug kini daw sama nga nakita ko ang panagway sa Dios, ug gidawat mo na ako. ");
INSERT INTO cebulb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Palihog dawata ang akong gasa nga gidala kanimo, tungod kay ang Dios maluluy-ong nagpatigayon kanako, ug tungod kay igo na ang akong nabatonan.” Niini gipugos siya ni Jacob, ug gidawat kini ni Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Unya miingon si Esau, “Manglakaw na kita. Mag-una ako kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Miingon si Jacob kaniya, “Nasayod ang akong agalon nga ang kabataan mga huyang pa, ug ang mga karnero ug ang mga baka adunay mga nating gipasuso. Kung pugson sila sa pagpalakaw bisan sa usa lang ka adlaw, mangamatay ang tanang kahayopan. ");
INSERT INTO cebulb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Palihog tugoti nga ang akong agalon mag-una sa iyang alagad. Maglakaw ako sa mas hinay pa, uyon sa lakang sa kahayopan nga nag-una kanako, ug sa linaktan sa mga kabataan, hangtod nga ako mahiabot sa akong agalon sa Seir.” ");
INSERT INTO cebulb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Miingon si Esau, “Tugoti nga akong ibilin kanimo ang pipila sa akong mga tawo nga uban kanako.” Apan miingon si Jacob, “Nganong buhaton mo man kana? Paigo na ang kaluoy sa akong agalon kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Busa sugod nianang adlawa misugod si Esau sa iyang panaw pauli ngadto sa Seir. ");
INSERT INTO cebulb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ug mipanaw si Jacob padulong sa Sucot, nagtukod siya sa iyang balay, ug naghimo og silonganan alang sa iyang kahayopan. Busa ang ngalan niadtong dapita gitawag og Sucot. ");
INSERT INTO cebulb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Sa dihang nahiabot si Jacob gikan sa Padan Aram, nahiabot siya nga luwas sa kadaot sa siyudad sa Siquem, nga mao ang yuta sa Canaan. Nagkampo siya duol sa siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Unya nagpalit siya og usa ka bahin sa yuta kung diin siya nagtukod sa iyang tolda gikan sa mga anak nga lalaki ni Hamor, amahan ni Siquem, sa kantidad nga 100 ka plata. ");
INSERT INTO cebulb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Didto nagpabarog siya ug halaran ug gitawag kini ug El Elohe Israel. ");
INSERT INTO cebulb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Karon si Dina, nga anak ni Lea kang Jacob, migawas aron makigkita sa mga batan-ong babaye niadtong yutaa. ");
INSERT INTO cebulb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Si Siquem nga anak nga lalaki ni Hamor nga Hibitihanon, ang prinsipe sa maong dapit, nakakita kang Dina, gibira niya siya, gipanamastamasan ug gidulog niya. ");
INSERT INTO cebulb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Naibog siya kang Dina, ang anak nga babaye ni Jacob. Nahigugma siya sa batan-ong babaye ug malumo siya nga nakigsulti kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Nakigsulti si Siquem kang Hamor nga iyang amahan, nga nag-ingon, “Kuhaa kining batan-ong babaye alang kanako aron mamahimo ko siyang asawa.” ");
INSERT INTO cebulb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Karon nadungog ni Jacob nga gihugawan niya si Dina nga iyang anak nga babaye. Ang iyang mga anak nga lalaki atua pa sa uma uban sa mga kahayopan, busa si Jacob nagpabiling hilom hangtod nga miabot sila. ");
INSERT INTO cebulb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Miadto si Hamor nga amahan ni Siquem ngadto kang Jacob aron makigsulti kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Miabot ang mga anak nga lalaki ni Jacob gikan sa uma sa dihang nadungog nila ang panghitabo. Nasakitan ang mga tawo. Nasuko sila pag-ayo tungod kay iya mang gipakaulawan ang Israel pinaagi sa pagpugos niya sa iyang kaugalingon ngadto sa anak nga babaye ni Jacob, tungod kay kadto nga butang dili unta angay nga mahitabo. ");
INSERT INTO cebulb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nakigsulti si Hamor kanila nga nag-ingon, “Ang akong anak nga lalaki nga si Siquem nahigugma sa imong anak nga babaye. Palihog ihatag siya ngadto kaniya ingon nga iyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Pakigminyo kanamo, ihatag kanamo ang inyong mga anak nga babaye, ug kuhaa usab ninyo ang among mga anak nga babaye alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Makapuyo kamo uban kanamo, ug ang kayutaan abli alang kaninyo aron inyong kapuy-an ug makabaligya ug makapalit kamo, ug makapanag-iya ug mga kabtangan.” ");
INSERT INTO cebulb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Miingon si Siquem ngadto sa amahan ni Dina ug sa iyang mga igsoong lalaki, “Makakaplag unta ako ug pabor diha kaninyo, ug bisan unsa ang inyong pangayoon kanako akong ihatag. ");
INSERT INTO cebulb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Pangayo kanako ug dakong kantidad sa bugay ug ang buot ninyong gasa, ug ihatag ko ang bisan unsa nga inyong isulti kanako, apan ihatag kanako ang dalagang babaye ingon nga asawa.” ");
INSERT INTO cebulb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Malimbongong mitubag ang mga anak nga lalaki ni Jacob kang Siquem ug kang Hamor nga iyang amahan, tungod kay gihugawan man ni Siquem si Dina nga ilang igsoong babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Miingon sila kanila, “Dili namo mahimo kining butanga, nga ihatag ang among igsoong babaye sa mga dili tinuli; kay makauulaw kana kanamo. ");
INSERT INTO cebulb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mouyon lamang kami kaninyo sa usa ka kondisyon: kung magpatuli kamo sama kanamo, ug magpatuli usab ang matag lalaki diha kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Unya ihatag namo kaninyo ang among mga anak nga babaye, ug among kuhaon ang inyong mga anak nga babaye alang kanamo, ug mopuyo kami uban kaninyo ug mahimong usa ka katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Apan kung dili kamo maminaw kanamo ug magpatuli, nan kuhaon namo ang among igsoong babaye ug mobiya kami.” ");
INSERT INTO cebulb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ang ilang mga pulong nakapahimuot kang Hamor ug sa iyang anak nga lalaki nga si Siquem. ");
INSERT INTO cebulb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Wala langana sa batan-ong lalaki ang pagbuhat sa ilang giingon, tungod kay nakagusto man siya sa anak nga babaye ni Jacob, ug tungod kay siya ang pinakatinahod nga tawo sa tibuok panimalay sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Miadto si Hamor ug si Siquem nga iyang anak nga lalaki sa ganghaan sa ilang siyudad ug nakigsulti sa mga kalalakin-an sa siyudad, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Kalinaw ang gidala niining mga tawhana kanato, busa tugoti sila nga mopuyo sa yuta ug makabaligya ug makapamalit dinhi, tinuod, ang yuta dako ra alang kanila. Kuhaon nato ang ilang mga anak nga babaye ingon nga mga asawa, ug ihatag nato kanila ang atong mga anak nga babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Niini lamang nga kondisyon mouyon kining mga tawhana nga mopuyo uban kanato ug mamahimong usa ka katawhan: kung ang tanang lalaki kanato magpatuli, sama nga sila mga tinuli. ");
INSERT INTO cebulb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Dili ba maangkon man nato ang ilang kahayopan ug mga gipanag-iyang mga butang—ug ang tanan nilang kahayopan? Maong mouyon kita kanila, ug mopuyo sila uban kanato.” ");
INSERT INTO cebulb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ang tanang kalalakin-an sa siyudad naminaw kang Hamor ug Siquem, nga anak niyang lalaki. Ang tanang lalaki nagpatuli. ");
INSERT INTO cebulb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Sa ikatulo nga adlaw, samtang hubag pa ang ilang mga samad, ang duha ka mga anak nga lalaki ni Jacob, si Simeon ug Levi, nga mga igsoong lalaki ni Dina, ang kada usa kanila nagdala ug espada ug miadto sa maong siyudad, ug gipamatay ang tanang mga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Gipatay nila si Hamor ug Siquem, nga anak niyang lalaki, pinaagi sa sulab sa ilang espada. Gikuha nila si Dina gikan sa panimalay ni Siquem ug mibiya. ");
INSERT INTO cebulb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ang ubang mga anak nga lalaki ni Jacob miadto sa mga patayng lawas ug nangawat sa siyudad, tungod kay gihugawan man sa katawhan ang ilang igsoong babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Gikuha nila ang mga panon sa mga karnero, ang ilang mga baka, ug mga asno, ug ang tanang mga butang nga anaa sa siyudad, anaa sa mga uma ug lakip ");
INSERT INTO cebulb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ang tanan nilang mga kabtangan. Gipangdakop nila ang kabataan ug ang ilang mga asawa. Gipangkuha nila bisan ang tanang butang nga anaa sulod sa mga panimalay. ");
INSERT INTO cebulb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Miingon si Jacob kang Simeon ug Levi, “Gidad-an ninyo ako ug kasamok, aron manimaho ako sa mga lumulupyo niining yutaa, ang Canaanhon ug ang Perisihanon. Diyutay lamang ang akong gidaghanon. Kung magtigom sila batok kanako ug moataki, malaglag gayod ako, ako ug ang akong panimalay.” ");
INSERT INTO cebulb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Apan miingon si Simeon ug Levi, “Angay bang isipon ni Siquem nga ang among igsoong babaye daw sama sa babayeng bayaran?” ");
INSERT INTO cebulb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Miingon ang Dios kang Jacob, “Tindog, ug tungas ngadto sa Betel, ug pabilin didto. Pagbuhat didto ug usa ka altar alang sa Dios, nga nagpakita kanimo niadtong mikagiw ka gikan kang Esau nga imong igsoong lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Unya miingon si Jacob sa iyang panimalay ug sa tanan nga kuyog kaniya, “Isalikway ang mga diosdios nga anaa kaninyo, ug hinloi ang inyong kaugalingon, ug ilisi ang inyong mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Unya mogikan kita ug motungas ngadto sa Betel. Magbuhat ako didto ug altar alang sa Dios, nga nagtubag kanako sa adlaw sa akong kagul-anan, ug nag-uban kanako bisan asa ako nag-adto.” ");
INSERT INTO cebulb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Busa gihatag nila ngadto kang Jacob ang tanang mga diosdios nga anaa kanila, ug ang mga ariyos nga anaa sa ilang mga dalunggan. Gilubong kini ni Jacob ilalom sa kahoy nga tugas duol sa Siquem. ");
INSERT INTO cebulb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sa ilang pagpanaw, gihimo sa Dios nga mangahadlok ang mga siyudad nga nagpalibot kanila, busa kadtong mga tawhana wala na migukod sa mga anak nga lalaki ni Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Busa si Jacob miabot sa Luz (nga mao ang Betel), nga anaa sa yuta sa Canaan, siya ug ang tanang mga tawo nga uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nagbuhat siya didto ug usa ka altar ug gitawag ang maong dapit nga El Betel, tungod kay didto nagpakita ang Dios kaniya, sa panahon nga mikagiw siya gikan sa iyang igsoon nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Si Debora, nga nag-atiman kang Rebeca, namatay. Gilubong siya didto sa ubos gikan sa Betel ilalom sa tugas nga kahoy, busa gitawag kini nga Allon Bacut. ");
INSERT INTO cebulb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Sa dihang miabot na si Jacob gikan sa Padan Aram, nagpakita ang Dios kaniya pag-usab ug gipanalanginan siya. ");
INSERT INTO cebulb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Miingon ang Dios kaniya, “Ang imong pangalan mao si Jacob, apan ang imong ngalan dili na Jacob. Israel na ang imong ngalan.” Busa gitawag na siya sa Dios ug Israel. ");
INSERT INTO cebulb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Miingon ang Dios kaniya, “Ako ang makagagahom nga Dios. Pagmabungahon ug pagsanay. Ang nasod ug ang mga pundok sa kanasoran magagikan kanimo, ug ang mga hari magagikan sa imong mga kaliwatan.” ");
INSERT INTO cebulb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ang yuta nga akong gihatag kang Abraham ug Isaac, ihatag ko kanimo. Ngadto sa imong mga kaliwatan human kanimo igahatag ko usab ang yuta.” ");
INSERT INTO cebulb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mikayab ang Dios gikan kaniya sa dapit diin nakigsulti siya kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nag-ugbok ug haligi si Jacob didtong dapita nga diin nakigsulti ang Dios kaniya, usa ka haligi nga bato. Gibuboan niya kini ug hinalad nga bino ug lana. ");
INSERT INTO cebulb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ginganlan ni Jacob og Betel ang maong dapit diin nakigsulti ang Dios kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Mipanaw sila gikan sa Betel. Samtang duol na sila gikan sa Efrata, nagbati si Raquel. Naglisod siya sa pagpanganak. ");
INSERT INTO cebulb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Samtang naglisod na gayod siya sa pagpanganak, miingon ang mananabang kaniya, “Ayaw kahadlok, kay karon makabaton ka na usab ug laing anak nga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Sa dihang himalatyon na siya, ug sa kataposan niyang gininhawa ginganlan niya ang bata og Benoni, apan ginganlan siya sa iyang amahan og Benjamin. ");
INSERT INTO cebulb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Namatay si Raquel ug gilubong sa dalan padulong sa Efrata (gitawag nga Betlehem). ");
INSERT INTO cebulb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nagbuhat si Jacob og haligi ibabaw sa iyang lubnganan. Kini ang ilhanan sa lubnganan ni Raquel hangtod niining adlawa. ");
INSERT INTO cebulb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Padayon nga nagpanaw si Israel ug nagtukod ug tolda unahan sa Migdal Eder. ");
INSERT INTO cebulb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Samtang nagpuyo si Israel nianang dapita, nakigdulog si Ruben kang Bilha nga puyo-puyo sa iyang amahan, ug nadungog kini ni Jacob. Karon si Jacob adunay dose ka mga anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ang iyang mga anak nga lalaki kang Lea mao si Ruben, ang kinamagulangang anak ni Jacob, ug si Simeon, Levi, Juda, Isacar, ug Zebulon. ");
INSERT INTO cebulb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ang iyang anak nga mga lalaki kay Raquel mao si Jose ug Benjamin. ");
INSERT INTO cebulb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ang iyang mga anak nga lalaki kay Bilha, nga sulugoong babaye ni Raquel, mao si Dan ug Naftali. ");
INSERT INTO cebulb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ang mga anak nga lalaki ni Zilfa, nga sulugoong babaye ni Lea mao sila Gad ug Aser. Kini mao ang tanang anak nga lalaki ni Jacob nga natawo sa Padan Aram. ");
INSERT INTO cebulb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Miadto si Jacob kang Isaac nga iyang amahan sa Mamre sa Kiriat-Arba, (ingon nga Hebron) diin nagpuyo si Abraham ug Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Si Isaac nabuhi ug 180 ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Miginhawa si Isaac sa kataposan ug namatay, usa ka tawo nga tigulang na kaayo ug giipon siya didto sa iyang mga katigulangan. Gilubong siya sa iyang mga anak nga lalaki nga sila si Esau ug Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Mao kini ang mga kaliwat ni Esau (ginatawag usab nga Edom). ");
INSERT INTO cebulb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nangasawa si Esau sa taga-Canaan. Mao kini ang iyang mga asawa: Si Ada ang anak nga babaye ni Elon nga Hetihanon; Oholibama ang anak nga babaye ni Ana, nga apo ni Zibeon nga Hebihanon; ");
INSERT INTO cebulb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ug Basemat, ang anak nga babaye ni Ismael, nga igsoong babaye ni Nebaiot. ");
INSERT INTO cebulb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Nanganak si Ada nga asawa ni Esau kang Elifas, ug si Basemat nanganak kang Reuel. ");
INSERT INTO cebulb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Nanganak si Oholibama kang Jeus, Jalam, ug Kora. Mao kini ang mga anak nga lalaki ni Esau nga natawo sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Gidala ni Esau ang iyang mga asawa, ang iyang mga anak nga lalaki, ang iyang mga anak nga babaye, ug ang tanang miyembro sa iyang panimalay, iyang mga kahayopan—ang tanan niyang mga hayop, ug ang tanan niyang mga kabtangan, nga iyang natigom sa yuta sa Canaan, ug miadto sa yuta nga layo sa iyang igsoon nga si Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Gibuhat niya kini tungod kay ang ilang mga kabtangan hilabihan na kadaghan alang kanila nga magpabilin nga mag-uban ug puyo. Ang yuta nga ilang gipuy-an dili na igo kanila tungod sa ilang mga kahayopan. ");
INSERT INTO cebulb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Busa si Esau, nga nailhan usab nga Edom, mipuyo sa kabungtoran sa Seir. ");
INSERT INTO cebulb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Mao kini ang mga mosunod nga mga kaliwatan ni Esau, mga katigulangan sa mga Edomihanon sa kabungtoran sa Seir. ");
INSERT INTO cebulb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Mao kini ang mga ngalan sa mga anak nga lalaki ni Esau: si Elifas ang anak nga lalaki ni Ada, ang asawa ni Esau; si Reuel ang anak nga lalaki ni Basemat, ang asawa ni Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ang mga anak nga lalaki ni Elifas mao si Teman, Omar, Zefo, Gatam, ug Kenas. ");
INSERT INTO cebulb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Si Timna, nga puyo-puyo ni Elifas, anak nga lalaki ni Esau nanganak kang Amalek. Mao kini ang mga apo nga lalaki ni Ada, nga asawa ni Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Mao kini ang mga anak nga lalaki ni Reuel: si Nahat, Zera, Shama, ug Miza. Mao kini ang mga apo nga lalaki ni Basemat, nga asawa ni Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Mao kini ang mga anak nga lalaki ni Oholibama, nga asawa ni Esau, nga anak nga babaye ni Ana ug apo nga babaye ni Zibeon. Nanganak siya kang Jeus, Jalam, ug Kora. ");
INSERT INTO cebulb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mao kini ang mga banay sa mga kaliwat ni Esau: ang kaliwat ni Elifas, ang kinamagulangan ni Esau: si Teman, Omar, Zefo, Kenaz, ");
INSERT INTO cebulb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, ug Amalek. Mao kini ang mga banay nga kaliwat ni Elifas sa yuta sa Edom. Sila ang mga apo nga lalaki ni Ada. ");
INSERT INTO cebulb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Mao kini ang mga banay nga gikan kang Reuel, anak nga lalaki ni Esau: si Nahat, Zera, Shama, Miza. Mao kini ang mga banay nga kaliwat ni Reuel sa yuta sa Edom. Mao kini ang mga apo nga lalaki ni Basemat, nga asawa ni Esau. ");
INSERT INTO cebulb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Mao kini ang mga banay ni Oholibama, nga asawa ni Esau: si Jeus, Jalam, Kora. Mao kini ang mga banay nga gikan sa asawa ni Esau nga si Oholibama, anak nga babaye ni Ana. ");
INSERT INTO cebulb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Mao kini ang mga anak nga lalaki ni Esau, ug mao kini ang ilang mga banay. ");
INSERT INTO cebulb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Mao kini ang mga anak nga lalaki ni Seir nga Horitihanon, ang mga lumulupyo sa yuta: si Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO cebulb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, ug Dishan. Mao kini ang mga banay sa mga Horitihanon, ang mga lumulupyo sa Seir nga yuta sa taga-Edom. ");
INSERT INTO cebulb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ang mga anak nga lalaki ni Lotan mao si Hori ug Heman, ug si Timna mao ang igsoong babaye ni Lotan. ");
INSERT INTO cebulb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Mao kini ang mga anak nga lalaki ni Shobal: si Alvan, Manahat, Ebal, Shefo, ug Onam. ");
INSERT INTO cebulb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Mao kini ang mga anak nga lalaki ni Zibeon: si Aya ug Ana. Si Ana mao ang nakakita sa init nga tubod didto sa kamingawan, samtang nagpasabsab siya sa mga asno sa iyang amahan nga si Zibeon. ");
INSERT INTO cebulb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Mao kini ang mga anak ni Ana: si Dishon ug Oholibama, ang anak nga babaye ni Ana. ");
INSERT INTO cebulb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Mao kini ang mga anak nga lalaki ni Dishon: si Hemdan, Esban, Itran, ug Keran. ");
INSERT INTO cebulb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Mao kini ang mga anak nga lalaki ni Ezer: si Bilhan, Saavan, ug Akan. ");
INSERT INTO cebulb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Mao kini ang mga anak nga lalaki ni Dishan: si Uz ug Aran. ");
INSERT INTO cebulb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Mao kini ang mga banay sa mga Horitihanon: Lotan, Shobal, Zibeon ug Ana, ");
INSERT INTO cebulb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, Dishan: mao kini ang mga banay sa mga Horitihanon, sumala sa listahan sa ilang mga banay sa yuta sa Seir. ");
INSERT INTO cebulb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mao kini ang mga hari nga naghari sa yuta sa Edom sa wala pay hari ang mga Israelita: ");
INSERT INTO cebulb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Si Bela nga anak nga lalaki ni Beor, ang naghari sa Edom, ug ang ngalan sa iyang siyudad mao ang Dinhaba. ");
INSERT INTO cebulb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Sa dihang namatay na si Bela, si Jobab anak nga lalaki ni Zera kang Bozra, ang naghari puli kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Sa dihang namatay na si Jobab, si Husan nga taga-Teman ang naghari puli kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Sa dihang namatay na si Husan, si Hadad anak nga lalaki ni Bedad, nga nakapildi sa mga Midianhon sa yuta sa Moab, ang naghari puli kaniya. Ang ngalan sa iyang siyudad mao ang Abit. ");
INSERT INTO cebulb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Sa dihang namatay na si Hadad, si Samla nga taga-Masreka ang naghari puli kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sa dihang namatay na si Samla, si Shaul ang naghari puli kaniya nga taga-Rehobot nga duol sa suba. ");
INSERT INTO cebulb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sa namatay na si Shaul, si Baal Hanan anak nga lalaki ni Acbor ang naghari puli kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Sa dihang si Baal Hanan anak nga lalaki ni Acbor namatay na, si Hadar ang naghari puli kaniya. Ang ngalan sa iyang siyudad mao ang Pau. Ang ngalan sa iyang asawa mao si Mehetabel, ang anak nga babaye ni Matred, nga apo nga babaye ni Me Zahab. ");
INSERT INTO cebulb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mao kini ang mga ngalan sa mga pangulo sa mga banay gikan sa kaliwat ni Esau, sumala sa ilang mga banay ug sa ilang mga dapit, sumala sa ilang mga ngalan: Timna, Alva, Jetet, ");
INSERT INTO cebulb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO cebulb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO cebulb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, ug Iram. Mao kini ang mga pangulo sa banay sa Edom, sumala sa ilang pagpuyo sa yuta nga ilang napanag-iyahan. Mao kini si Esau, ang amahan sa mga Edomihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nagpuyo si Jacob sa dapit nga gipuy-an sa iyang amahan sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mao kini ang mga panghitabo mahitungod kang Jacob. Si Jose, usa ka batan-on nga nag-edad ug 17 anyos, nagabantay siya ug karnero uban sa iyang mga igsoon. Kuyog niya ang mga anak nga lalaki ni Bilha ug anak nga lalaki ni Zilpa, mga asawa sa iyang amahan. Ginasumbong ni Jose ngadto sa iyang amahan ang mga dili maayo nila nga binuhatan. ");
INSERT INTO cebulb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Karon gihigugma pag-ayo ni Israel si Jose labaw pa sa iyang mga anak nga lalaki tungod kay anak man siya sa iyang pagkatigulang. Tungod niini gibuhatan niya siya ug maanindot nga bisti. ");
INSERT INTO cebulb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nakita sa iyang mga igsoon nga ang ilang amahan nahigugma pag-ayo kaniya labaw pa sa tanan nilang managsuon. Busa nasuko sila kaniya ug dili maayo ang ilang pagtagad ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nagdamgo si Jose, ug gisuginlan niya ang iyang mga igsoon mahitungod niini. Nisamot ang ilang kasuko kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Miingon siya kanila, “Palihog paminawa kining akong nadamgohan. ");
INSERT INTO cebulb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tan-awa, nagbugkos kita ug mga trigo sa kaumahan, ug tan-awa, ang akong binugkos mitindog ug mipataas, ug tan-awa, ang inyong mga binugkos mipalibot ug miyukbo sa akong binugkos.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ang iyang mga igsoon miingon kaniya, “Maghari ka ba diay kanamo? Maghari ka ba gayod diay kanamo?” Misamot pa ang ilang kasuko kaniya tungod sa iyang damgo ug sa iyang mga gipamulong. ");
INSERT INTO cebulb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nagdamgo na usab siya ug lain nga damgo ug iya kining gisugilon sa iyang mga igsoon. Miingon siya, “Tan-awa, nagdamgo ako ug lain na usab nga damgo: Ang adlaw ug bulan ug ang napulog usa ka mga bituon miyukbo kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Gisugilon niya kini sa iyang amahan ingon man sa iyang mga igsoon, ug gibadlong siya sa iyang amahan. Miingon siya kaniya, “Unsa ba kining imong gidamgo? Moyukbo ba ako ug ang imong inahan, ingon man ang imong mga igsoon nganha kanimo?” ");
INSERT INTO cebulb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nasina ang iyang mga igsoon kaniya, apan gitipigan sa hunahuna sa iyang amahan kining mga butanga. ");
INSERT INTO cebulb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Miadto sa Shekem ang iyang mga igsoon aron pagbantay sa mga karnero sa ilang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Miingon si Israel kang Jose, “Dili ba nagbantay man sa mga karnero sa Shekem ang imong mga igsoon? Dali, ug ipadala ko ikaw ngadto kanila.” Miingon si Jose kaniya, “Andam ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Miingon siya kaniya, “Lakaw na karon, tan-awa kung maayo ba ang kahimtang sa imong mga igsoon ingon man ang mga karnero, ug suginli ako.” Busa gipaadto siya ni Jacob gawas sa walog sa Hebron ug miadto si Jose sa Shekem. ");
INSERT INTO cebulb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Adunay usa ka tawo nga nakakita kang Jose. Tan-awa, naglatagaw si Jose sa kaumahan. Miingon ang tawo kaniya, “Unsa man ang imong gipangita?” ");
INSERT INTO cebulb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Miingon si Jose, “Gipangita ko ang akong mga igsoon. Palihog sultihi ako, kung asa sila nagbantay sa mga karnero.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Miingon ang tawo, “Mibiya sila niini nga dapit, kay nadungog ko sila, nga nag-ingon, 'Moadto kita sa Dotan.'” Miapas si Jose sa iyang mga igsoong lalaki ug nakita niya sila didto sa Dotan. ");
INSERT INTO cebulb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nakita nila siya sa layo, ug sa wala pa siya maabot duol kanila, naglaraw sila nga patyon siya. ");
INSERT INTO cebulb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ang iyang mga igsoon miingon sa usag-usa, “Tan-awa, nagpaingon dinhi ang tigdamgo. ");
INSERT INTO cebulb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Busa, dali kamo, patyon ta siya ug ihulog siya sa isa sa mga atabay ug moingon kita, 'Gilamoy siya sa ihalas nga mananap.' Tan-awon ta kung unsa ang mahitabo sa iyang mga damgo.'” ");
INSERT INTO cebulb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nakadungog si Ruben niini ug giluwas niya siya sa ilang mga kamot. Miingon siya, “Dili nato kuhaon ang iyang kinabuhi.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Miingon si Ruben kanila, “Walay dugo nga angay moawas. Ihulog siya niining atabay nga anaa sa kamingawan, apan ayaw ninyo siya dapati”— aron luwason niya siya gikan sa ilang mga kamot ug dad-on siya pagbalik sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Sa dihang niabot na si Jose sa iyang mga igsoon, gigisi nila ang iyang maanindot nga bisti. ");
INSERT INTO cebulb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ila siyang gikuha ug gihulog siya sa atabay. Walay tubig kadto nga atabay. ");
INSERT INTO cebulb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nanglingkod sila aron mokaon ug tinapay. Sa dihang mihangad sila ug mitan-aw, tan-awa, ilang nakita ang panon sa mga Ismaelita nga gikan sa Gilead, uban sa ilang mga kamelyo nga nagkarga ug mga lamas ug balsamo ug mira. Nagpanaw sila aron ila kining dad-on paubos sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Miingon si Juda sa iyang mga igsoon, “Unsa man ang atong makuha kung patyon ta ang atong igsoon ug tabonan ang iyang dugo? ");
INSERT INTO cebulb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Dali kamo, ibaligya ta siya sa mga Ismaelita ug dili nato siya dapatan. Tungod kay ato siyang igsoon, atong unod.” Ang iyang mga igsoon naminaw kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Milabay ang Midianhon nga negosyanti. Gikuha sa iyang mga igsoon si Jose gawas sa atabay. Ug unya gibaligya nila si Jose ngadto sa mga Ismaelita sa 20 kabuok nga plata. Gidala si Jose sa mga Ismaelita ngadto sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mibalik si Ruben sa atabay, ug tan-awa, wala na didto si Jose sa atabay. Gigisi niya ang iyang bisti. ");
INSERT INTO cebulb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Mibalik siya sa iyang mga igsoon ug miingon, “Asa na ang bata? Ug ako, asa na man ako moadto?” ");
INSERT INTO cebulb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nagpatay sila ug kanding unya gikuha ang bisti ni Jose ug gituslob kini sa dugo. ");
INSERT INTO cebulb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Unya gidala nila kini sa ilang amahan ug miingon, “Nakita namo kini. Palihog tan-awa kung bisti ba kini sa imong anak o dili.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nailhan kini ni Jacob ug miingon, “Bisti kini sa akong anak. Gitukob siya sa ihalas nga mananap. Sigurado gayod nga gikunis-kunis niini si Jose.” ");
INSERT INTO cebulb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Gigisi ni Jacob ang iyang bisti ug nagsul-ob ug sako sa iyang hawak. Nagbangotan siya alang sa iyang anak sa daghang mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ang tanan niyang anak nga lalaki ug mga babaye miadto kaniya ug gihupay siya, apan wala siya mosugot nga ila siyang hupayon. Miingon siya, “Sa pagkatinuod, moadto ako sa seol ug magbangotan alang sa akong anak.” Mihilak ang iyang amahan alang kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Gibaligya siya sa mga Midianhon didto sa Ehipto ngadto kang Potifar, usa ka opisyal ni Paraon, ang kapitan sa mga guwardiya. ");
INSERT INTO cebulb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Niabot ang panahon nga si Juda mibiya sa iyang mga igsoon ug mipuyo didto sa usa ka taga-Adulam, nga ginganlan og Hira. ");
INSERT INTO cebulb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nakita niya didto ang anak nga babaye sa usa ka Canaanhon nga ginganlan og Sua. Giminyoan niya ang babaye ug nakigdulog kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nagmabdos siya ug nakabaton og anak nga lalaki. Ginganlan kini og Er. ");
INSERT INTO cebulb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nagmabdos siya pag-usab ug nakabaton og anak nga lalaki. Ginganlan niya kini og Onan. ");
INSERT INTO cebulb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nakabaton na usab siya og anak nga lalaki ug gitawag siya og Sela. Didto siya nanganak kang Sela sa Chezib. ");
INSERT INTO cebulb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nakakita si Juda og pangasaw-onon alang kang Er, ang kamagulangan niyang anak. Ang iyang ngalan, si Tamar. ");
INSERT INTO cebulb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Si Er nga kamagulangang anak ni Juda, daotan sa panan-aw ni Yahweh. Busa gipatay siya ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Si Juda miingon kang Onan, “Dulog sa asawa sa imong igsoong lalaki. Buhata ang bulohaton sa usa ka bayaw nga lalaki ngadto kaniya, ug pagbaton ug bata alang sa imong igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nasayod si Onan nga ang bata dili gayod maiya. Sa panahon nga modulog siya sa asawa sa iyang igsoon, ipagawas niya ang similya ngadto sa yuta aron dili siya makahatag ug bata alang sa iyang igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ang iyang gibuhat daotan sa panan-aw ni Yahweh. Mao nga gipatay usab siya ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Unya miingon si Juda kang Tamar, nga iyang umagad nga babaye, “Pabilin nga usa ka biyuda sa balay sa imong amahan hangtod nga maulitawo ang akong anak nga si Sela.” Tungod kay naghunahuna siya nga, “Basin mamatay usab siya sama sa iyang mga igsoon.” Busa mibiya si Tamar ug mipuyo sa balay sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Milabay ang taas nga panahon, namatay ang asawa ni Juda nga anak ni Sua. Pagkahuman sa pagbangotan ni Juda, miadto siya ug ang iyang higala nga si Hira nga taga-Adulam sa mga tigtupi sa balhibo sa iyang mga karnero didto sa Timna. ");
INSERT INTO cebulb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Gisultihan si Tamar, “Tan-awa, ang imong ugangang lalaki motungas sa Timna aron sa pagpatupi sa iyang mga karnero.” ");
INSERT INTO cebulb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Gihukas niya ang iyang bisti sa pagkabiyuda ug nagsul-ob ug bilo ug gitabonan ang iyang kaugalingon. Milingkod siya sa ganghaan sa Enaim, nga daplin sa dalan paingon sa Timna. Kay nakita niya nga ulitawo na si Sela apan wala siya gihatag kaniya ingon nga asawa niini. ");
INSERT INTO cebulb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Sa dihang nakita siya ni Juda nagtuo kini nga usa siya ka babayeng nagabaligya ug dungog tungod kay gitabonan man niya ang iyang nawong. ");
INSERT INTO cebulb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Miduol siya kaniya sa daplin sa dalan ug miingon, “Dali, kay buot kong makigdulog kanimo”—tungod kay wala kini masayod nga siya ang iyang umagad nga babaye—ug miingon ang babaye, “Unsa man ang imong ihatag kanako aron makadulog ka kanako?” ");
INSERT INTO cebulb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Miingon siya, “Padad-an ko ikaw ug nating kanding gikan sa panon.” Miingon siya, “Mohatag ka ba kanako ug saad hangtod nga ikaw makapadala niini?” ");
INSERT INTO cebulb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mitubag siya, “Unsa man nga saad ang akong ihatag kanimo?” Ug siya miingon, “Ang imong silyo ug higot, ug ang imong sungkod.” Gihatag niya kini ug nakigdulog kaniya. Ug nagmabdos siya pinaagi kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mibangon siya ug mibiya. Gihubo niya ang iyang bilo ug gisul-ob ang bisti sa pagkabiyuda. ");
INSERT INTO cebulb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Gipadala ni Juda ang nati nga kanding gikan sa panon sa iyang higala nga taga-Adulam aron kuhaon ang saad gikan sa kamot sa babaye, apan wala niya hikaplagi ang babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Unya ang taga-Adulam nangutana sa mga tawo sa maong dapit, “Asa na ang babaye nga nagabaligya ug dungog nga anaa sa Enaim daplin sa dalan?” Miingon sila, “Walay babaye nga nagabaligya ug dungog dinhi.” ");
INSERT INTO cebulb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mibalik siya ngadto kang Juda ug miingon, “Wala nako siya hikaplagi. Ang mga tawo sa maong dapit miingon usab, 'Walay babaye nga nagabaligya ug dungog dinhi.'” ");
INSERT INTO cebulb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Miingon si Juda, “Pasagdi nga maiya ang mga butang aron dili kita maulawan. Hinuon, gipadala ko na man kining nati nga kanding, apan wala mo siya hikaplagi.” ");
INSERT INTO cebulb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nahitabo kini pagkahuman sa mga tulo ka bulan nga gisulti kini ngadto kang Juda, “Si Tamar nga imong umagad nga babaye nahimong babayeng nagabaligya ug dungog, ug namabdos siya tungod niini.” Miingon si Juda, “Dad-a siya dinhi ug sunoga.” ");
INSERT INTO cebulb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Sa dihang gidala na siya sa gawas, nagpadala siya ug mensahe ngadto sa iyang ugangan nga lalaki. “Pinaagi sa tawo nga nanag-iya niini namabdos ako.” Siya miingon, “Ilha palihog kung kang kinsa kini, ang silyo ug higot ug ang sungkod.” ");
INSERT INTO cebulb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nailhan ni Juda ang mga butang ug miingon, “Siya ang mas labing husto kay kanako, sanglit wala ko man siya gihatag aron asawa ni Sela, nga akong anak nga lalaki.” Ug wala na siya midulog kaniya pag-usab. ");
INSERT INTO cebulb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Nahitabo kini sa panahon nga manganak na siya, tan-awa, adunay kaluha sulod sa iyang tagoangkan. ");
INSERT INTO cebulb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Nahitabo kini sa dihang manganak na siya nga ang usa mipagawas sa iyang kamot, ug ang mananabang mikuha ug pula nga tanod ug gihigtan ang kamot sa bata, ug miingon, “Kini ang unang migawas.” ");
INSERT INTO cebulb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nahitabo nga sa dihang gibira niya ang iyang kamot, tan-awa, ang iyang igsoong lalaki ang unang migawas. Miingon ang mananabang, “Giunsa nimo paggawas!” Ug ginganlan siya ug Perez. ");
INSERT INTO cebulb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Unya migawas ang iyang igsoon, ang adunay tanod nga pula sa iyang kamot, ug ginganlan siya ug Zera. ");
INSERT INTO cebulb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Gidala si Jose palugsong sa Ehipto. Si Potifar, nga usa ka opisyal sa Paraon nga kapitan sa mga guwardiya ug usa ka Ehiptohanon, nagpalit kaniya gikan sa mga Ismaelita, nga maoy nagdala kaniya didto. ");
INSERT INTO cebulb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Si Yahweh nag-uban kang Jose ug nagmalamboon siya nga tawo. Nagpuyo siya sa balay sa iyang agalon nga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nakita sa iyang agalon nga si Yahweh nag-uban kaniya ug gipanalanginan ni Yahweh ang tanan niyang gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nakakaplag si Jose ug pabor sa iyang panan-aw. Nag-alagad siya kang Potifar. Gihimo ni Potifar si Jose nga tigdumala sa iyang tibuok panimalay, ug ang tanan nga iyang gipanag-iyahan, iyang gibutang ilalom sa iyang pag-atiman. ");
INSERT INTO cebulb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nahitabo kini gikan sa panahon nga gihimo niyang tigdumala si Jose sa tibuok niyang panimalay ug sa tibuok niyang gipanag-iyahan, nga gipanalanginan ni Yahweh ang balay sa Ehiptohanon tungod kang Jose. Ang panalangin ni Yahweh anaa sa tanang butang nga anaa sa panimalay ni Potifar ug sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Gibutang ni Potifar ubos sa pagdumala ni Jose ang tanan nga anaa kaniya. Wala na siya maghunahuna sa bisan unsa gawas sa iyang pagkaon. Karon kining si Jose gwapo ug makadani. ");
INSERT INTO cebulb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nahitabo human niini nga ang asawa sa agalon ni Jose naibog kaniya. Miingon ang babaye, “Dulog kanako.” ");
INSERT INTO cebulb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Apan midumili si Jose ug miingon sa asawa sa iyang agalon, “Tan-awa, ang akong agalon wala na manghilabot kung unsa ang akong pagabuhaton sa balay, ug iyang gibutang ubos sa akong pagdumala ang tanang butang nga iyang gipanag-iyahan. ");
INSERT INTO cebulb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Walay usa nga mas labaw kay kanako niining panimalaya. Wala siyay gihikaw kanako gawas kanimo, tungod kay asawa ka man niya. Unsaon man nako pagbuhat niining hilabihang pagkadaotan ug sala batok sa Dios?” ");
INSERT INTO cebulb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gidani niya si Jose sa matag-adlaw, apan nagdumili kini sa pagpakigdulog o sa pagpakig-uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Miabot ang usa ka adlaw nga misulod siya sa balay aron pagbuhat sa iyang buluhaton. Walay mga tawo sa sulod sa panimalay. ");
INSERT INTO cebulb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Gibira niya ang bisti ni Jose ug miingon, “Dulog kanako.” Unya nahibilin ang iyang bisti sa kamot sa babaye sa dihang miikyas ug miadto siya sa gawas. ");
INSERT INTO cebulb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pagkahuman, sa dihang nakita niya nga nahibilin ang bisti ni Jose sa iyang kamot ug miikyas pagawas, ");
INSERT INTO cebulb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","gitawag niya ang mga tawo sa iyang balay ug giingnan sila, “Tan-awa, nagdala si Potifar ug usa ka Hebreohanon aron pakaulawan kita. Misulod siya aron makigdulog unta kanako, ug misinggit ako. ");
INSERT INTO cebulb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Sa dihang nadungog niya nga misinggit ako, miikyas siya ug nahibilin ang iyang bisti ngari kanako ug miadto sa gawas.” ");
INSERT INTO cebulb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Gibutang niya ang bisti ni Jose tapad kaniya hangtod nga miabot ang iyang agalon. ");
INSERT INTO cebulb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Gisugilon niya kini nga panghitabo ngadto kaniya, “Ang Hebreohanon nga ulipon nga imong gidala nganhi kanato, mianhi aron pakaulawan ako. ");
INSERT INTO cebulb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Sa dihang misinggit ako, iyang nabiyaan ang iyang bisti nganhi kanako ug miikyas pagawas.” ");
INSERT INTO cebulb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nahitabo kini sa dihang nadungog sa iyang agalon ang gisugilon sa asawa niini, “Mao kana ang gibuhat sa imong ulipon kanako,” ug nasuko siya pag-ayo. ");
INSERT INTO cebulb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Gidala sa iyang agalon si Jose ug gibilanggo siya, sa dapit kung asa nahimutang ang mga binilanggo sa hari. Anaa siya didto sa bilanggoan. ");
INSERT INTO cebulb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Apan si Yahweh nag-uban kang Jose ug nagpakita sa pagkamatinud-anon sa iyang saad ngadto kaniya. Gihatagan niya siya ug pabor sa panan-aw sa tigdumala sa bilanggoan. ");
INSERT INTO cebulb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Gitugyan sa tigdumala sa bilanggoan ngadto sa kamot ni Jose ang tanan nga anaa sa bilanggoan. Bisan unsa ang ilang pagabuhaton didto, si Jose mao ang nagdumala niini. ");
INSERT INTO cebulb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wala na naghunahuna pa ang tigdumala sa bilanggoan sa bisan unsa nga anaa sa iyang kamot, tungod kay nag-uban man kaniya si Yahweh. Bisan unsa ang iyang pagabuhaton, gipalambo ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nahitabo kadto human niining mga butanga, ang tigtagay ug bino ug ang tigbuhat ug tinapay sa hari sa Ehipto nakasala sa ilang agalon, ang hari sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Nasuko si Paraon sa iyang duha ka mga kadagkoan, ang pangulo sa tigtagay ug bino ug ang pangulo sa tigbuhat ug tinapay. ");
INSERT INTO cebulb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Gipabilanggo niya sila ilalom sa pagbantay sa kapitan sa mga guwardiya, sa samang bilanggoan kung asa nabilanggo si Jose. ");
INSERT INTO cebulb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ang kapitan sa guwardiya nagpiyal kang Jose nga mahimo nilang sulugoon. Nagpabilin silang binilanggo sa pipila ka mga panahon. ");
INSERT INTO cebulb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Silang duha nagdamgo ug mga damgo—ang pangulo sa tigtagay ug bino ug ang pangulo sa tigbuhat ug tinapay sa hari sa Ehipto nga nabilanggo. Matag-usa kanila adunay kaugalingong damgo sa samang kagabhion, ug matag damgo adunay kaugalingong kahulogan. ");
INSERT INTO cebulb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pagkabuntag niana miduol si Jose ngadto kanila ug nakita sila. Tan-awa, nagmasulob-on sila. ");
INSERT INTO cebulb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nangutana siya sa mga kadagkoan ni Paraon nga uban kaniya sa bilanggoan sa balay sa iyang agalon, nga nag-ingon, “Nganong nagmasulob-on man kamo karon?” ");
INSERT INTO cebulb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nag-ingon sila kaniya, “Kaming duha nagdamgo ug walay bisan usa nga makahubad niini.” Nag-ingon si Jose ngadto kanila, “Dili ba iya man sa Dios ang mga paghubad? Palihog, suginli ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ang pangulo sa tigtagay ug bino misugilon kang Jose sa iyang damgo. Siya misugilon kaniya, “Sa akong damgo, tan-awa, ang usa ka paras anaa sa akong atubangan. ");
INSERT INTO cebulb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ang paras adunay tulo ka mga sanga. Nangudlot kini, migula ang mga bulak ug ang mga pungpong sa ubas nangahinog. ");
INSERT INTO cebulb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ang kupa ni Paraon anaa sa akong kamot. Akong gikuha ang mga ubas ug gipuga kini ngadto sa kupa ni Paraon, ug gibutang ko ang kupa ngadto sa kamot ni Paraon.” ");
INSERT INTO cebulb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Si Jose nag-ingon kaniya, “Mao kini ang kahulogan niini. Ang tulo ka mga sanga mao ang tulo ka mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sulod sa tulo ka mga adlaw ituboy ka ni Paraon ug ibalik ka niya sa imong katungdanan. Ibutang nimo ang kupa ni Paraon ngadto sa iyang mga kamot, susama kaniadto nga ikaw iyang tigtagay ug bino.” ");
INSERT INTO cebulb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Apan hinumdomi ako sa dihang maayo na ang imong dangatan, ug palihog ipakita ang imong kaayo nganhi kanako. Hisgoti ako ngadto kang Paraon ug ipagawas ako niining bilanggoan. ");
INSERT INTO cebulb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kay sa pagkatinuod gidagit ako pagawas sa yuta sa mga Hebrohanon. Dinhi usab wala akoy nabuhat nga sayop nga angay nila akong ibutang niining bilanggoan.” ");
INSERT INTO cebulb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Sa pagkakita sa pangulo sa tigbuhat ug tinapay nga ang kahulogan maayo, siya nag-ingon kang Jose, “Nagdamgo usab ako, tan-awa, adunay tulo ka mga bukag nga tinapay nga anaa sa ibabaw sa akong ulo. ");
INSERT INTO cebulb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Sa ibabaw sa bukag anaa didto ang tanan nga nagkalain-laing linutong pagkaon alang kang Paraon, apan ang mga langgam mikaon niini pagawas sa bukag nga anaa sa akong ulo.” ");
INSERT INTO cebulb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Si Jose mitubag ug miingon, “Mao kini ang kahulogan. Ang tulo ka mga bukag, mao ang tulo ka mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sulod sa tulo ka adlaw putlan ka ni Paraon ug ulo ug pagabitayon ka didto sa kahoy. Ang kalanggaman magakaon sa imong unod.” ");
INSERT INTO cebulb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Niabot ang higayon sa ikatulo nga adlaw sa adlaw nga natawhan ni Paraon. Nagpakumbira siya alang sa tanan niyang mga sulugoon. Naghatag siya ug pinasahi nga pagtagad sa pangulo sa tigtagay ug bino ug sa pangulo sa tigbuhat ug tinapay labaw pa sa tanan niyang mga sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Iyang gipabalik ang pangulo sa tigtagay ug bino sa iyang katungdanan, ug gibutang niya pag-usab ang kupa ngadto sa kamot ni Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Apan iyang gipabitay ang pangulo sa tigbuhat ug tinapay, sumala sa gihubad ni Jose ngadto kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Apan ang pangulo sa tigtagay ug bino wala nahinumdom sa pagtabang kang Jose. Hinuon, gikalimtan niya siya. ");
INSERT INTO cebulb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Niabot ang higayon pagkahuman sa duha ka mga tuig ang Paraon nagdamgo. Tan-awa, nagbarog siya daplin sa Nilo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tan-awa, pito ka mga baka ang migula gikan sa Nilo, mga himsog ug tambok, ug misabsab sila sa kasagbotan. ");
INSERT INTO cebulb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tan-awa, adunay pito ka mga baka nga misunod paggula gikan sa Nilo, mga maot ug niwang. Nagbarog sila duol sa ubang mga baka nga anaa daplin sa suba. ");
INSERT INTO cebulb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Unya gilamoy sa maot ug niwang nga mga baka ang pito ka mga baka nga himsog ug tambok. Unya nakamata ang Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Unya natulog siya ug nagdamgo sa ikaduha nga higayon. Tan-awa, pito ka mga uhay sa trigo ang mitubo sa usa ka punoan, timgas ug maayo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tan-awa, miturok sunod kanila ang pito ka mga uhay sa trigo, mga niwang ug nasawot tungod sa hangin sa sidlakan. ");
INSERT INTO cebulb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Gilamoy sa pito ka niwang nga mga uhay sa trigo ang timgas ug bus-ok nga mga lugas. Unya nakamata ang Paraon, ug, tan-awa, damgo lamang kini. ");
INSERT INTO cebulb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Niabot ang higayon sa kabuntagon nga ang iyang espiritu nasamok. Gipadala ug gipatawag niya ang tanang mga salamangkero ug maalamon nga mga tawo sa Ehipto. Gisaysay sa Paraon kanila ang iyang mga damgo, apan wala gayoy nakahubad niini ngadto sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Unya ang pangulo sa tigdala ug kupa nag-ingon sa Paraon, “Karong adlawa naghunahuna ako sa akong mga sayop. ");
INSERT INTO cebulb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nasuko ang Paraon sa iyang mga sulugoon, ako ug ang pangulo sa tigbuhat ug tinapay gibutang sa bilanggoan sa balay sa kapitan sa guwardiya. ");
INSERT INTO cebulb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nagdamgo kami sa sama nga gabii, siya ug ako. Nagdamgo kami ug ang matag-usa kanamo managlahi ang kahulogan sa mga damgo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Aduna kami kauban didto nga usa ka batan-ong lalaki nga Hebrohanon, sulugoon sa kapitan sa mga guwardiya. Gisugilon namo kaniya ug gihubad niya alang kanamo ang among mga damgo. Iyang gihubad sa matag-usa kanamo sumala sa nagkadaiyang damgo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Niabot ang higayon nga nahitabo gayod ang iyang gihubad kanamo. Gipabalik ako sa Paraon sa akong katungdanan, apan ang laing usa iyang gipabitay.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Unya nagsugo ang Paraon ug gipatawag si Jose. Gikuha dayon nila si Jose pagawas gikan sa bilanggoan. Namalbas siya ug nagpaopaw, nag-ilis sa iyang bisti, ug miadto siya sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Miingon ang Paraon ngadto kang Jose, “Aduna akoy damgo, apan walay makahubad niini. Apan nadungog ko ang mahitungod kanimo, nga sa dihang madungog nimo ang damgo makahubad ka niini.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Mitubag si Jose sa Paraon, nga nag-ingon, “Dili kini gikan kanako. Motubag ang Dios sa Paraon nga adunay pabor.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Gisuginlan sa Paraon si Jose, “Tan-awa, sa akong damgo, nagbarog ako daplin sa suba sa Nilo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tan-awa, pito ka mga baka ang migula gikan sa Nilo, mga tambok ug himsog, ug nagsabsab sila sa kasagbotan. ");
INSERT INTO cebulb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tan-awa, adunay laing pito ka mga baka ang misunod paggula, mga luyahon, maot kaayo, ug niwang. Wala pa ako makakita sa tibuok yuta sa Ehipto nga sama nila ka maot. ");
INSERT INTO cebulb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Gikaon sa mga niwang ug maot nga mga baka ang nahaunang pito ka tambok nga mga baka. ");
INSERT INTO cebulb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sa dihang nakaon na nila sila, dili masayran nga ila nang nakaon sila, sanglit mga niwang gihapon sila sama kaniadto. Unya nakamata ako. ");
INSERT INTO cebulb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nakita ko sa akong damgo, ug, tan-awa, adunay pito ka mga uhay ang mitubo gikan sa usa ka punoan, bus-ok ug timgas. ");
INSERT INTO cebulb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tan-awa, adunay laing pito ka mga uhay ang mitubo sunod kanila, nga nalawos, niwang ug nasawot tungod sa hangin sa sidlakan. ");
INSERT INTO cebulb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Gilamoy sa pito ka niwang nga mga uhay ang pito ka timgas nga mga uhay. Gisaysay nako kining mga damgo ngadto sa mga salamangkero, apan walay usa nga nakapasabot kanako niini.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Miingon si Jose sa Paraon, “Ang mga damgo sa Paraon managsama lang. Kung unsa man ang pagabuhaton sa Dios, iyang gipadayag ngadto sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ang pito ka maayong mga baka mao ang pito ka mga katuigan, ug ang pito ka maayong mga uhay mao ang pito ka mga katuigan. Managsama lang ang mga damgo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ug ang laing pito ka niwang ug maot nga mga baka nga mitungha sunod kanila mao ang pito ka mga katuigan, ug ang pito usab ka niwang nga mga uhay nga nasawot sa hangin gikan sa sidlakan mao ang pito ka mga katuigan sa kagutom. ");
INSERT INTO cebulb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mao kanang mga butanga ang akong masaysay ngadto sa Paraon. Kung unsa man ang pagabuhaton sa Dios gipadayag niya kini ngadto sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tan-awa, pito ka mga katuigan sa kadagaya ang moabot sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pito usab ka mga katuigan sa kagutom ang moabot sunod niana, ug ang tanang kadagaya mahikalimtan sa yuta sa Ehipto, ug ang hulaw modaot sa tibuok yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ang kadagaya dili mahinumdoman sa yuta, tungod sa mosunod nga kagutom nga hilabihan kaayo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gibalik pag-usab ang damgo ngadto sa Paraon tungod kay kining mga butanga namugna na sa Dios, ug sa dili madugay buhaton kini sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Karon kinahanglan nga mangita ang Paraon ug tawong adunay pagsabot, ug maalamon, ug tugyanan siya sa tibuok kayutaan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tugoti nga buhaton kini sa Paraon: tugoti nga mopili siya ug tigdumala sa tibuok kayutaan. Tugoti sila nga kuhaon ang ikalima nga bahin sa abot sa Ehipto sulod sa pito ka mga katuigan sa kadagaya. ");
INSERT INTO cebulb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ipatigom kanila ang tanang pagkaon sa umaabot nga maayong mga katuigan. Tugoti sila nga tipigan ang trigo ilalom sa pagbuot sa Paraon alang sa pagkaon sa mga siyudad. Pabantayi kini kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ang pagkaon maoy mosangkap alang sa yuta sulod sa pito ka mga katuigan sa kagutom nga modangat sa yuta sa Ehipto. Niini nga paagi ang yuta dili madaot sa kagutom.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kini nga tambag maayo sa mga mata sa Paraon ug sa mga mata sa tanan niyang mga sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Miingon ang Paraon sa iyang mga sulugoon, “Makakaplag pa ba kita ug tawo nga sama niini, kansang adunay Espiritu sa Dios?” ");
INSERT INTO cebulb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Unya miingon ang Paraon ngadto kang Jose, “Tungod kay kining tanan gipakita man sa Dios kanimo, wala nay laing adunay pagsabot ug maalamon sama kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Himuon ko ikaw nga piniyalan sa akong panimalay, ug sumala sa imong pulong madumalahan nimo ang tanan nakong katawhan. Diha lamang sa trono ako ang mas labaw kaysa kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Miingon ang Paraon ngadto kang Jose, “Tan-awa, piyalan ko ikaw sa tibuok kayutaan sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Gikuha sa Paraon ang pangsilyo nga singsing sa iyang tudlo ug gibutang niya kini sa tudlo ni Jose. Gisul-oban niya siya ug bisti, hinimo sa nindot nga panapton nga lino, ug gibutangan niya siya ug bulawang kwentas. ");
INSERT INTO cebulb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Gipasakay niya siya sa ikaduha nga karwahe nga iyang gipanag-iya. Misinggit ang mga tawo nga nag-una kaniya, “Pangluhod kamo.” Gipiyalan siya sa Paraon sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Nag-ingon ang Paraon ngadto kang Jose, “Ako ang Paraon, ug gawas kanimo, wala nay lain pang tawo ang makataas sa iyang kamot o sa iyang tiil sa tibuok yuta sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ginganlan sa Paraon si Jose ug “Zaphenath Paneah.” Gihatag kaniya si Asenat ingon nga iyang asawa, ang anak nga babaye ni Potifera nga pari sa On. Ang katungod ni Jose lukop sa tibuok Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Nagpanuigon ug 30 si Jose sa dihang nag-alagad siya sa Paraon. Milakaw si Jose gikan sa presensya sa Paraon, ug miadto sa tanang yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sa pito ka madagayaon nga mga katuigan ang yuta mihatag sa madagayaon nga abot. ");
INSERT INTO cebulb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Gipatigom niya ang tanan nga mga pagkaon sulod sa pito ka mga katuigan nga anaa sa yuta sa Ehipto, ug gibutang ang mga pagkaon sa mga siyudad. Gibutang niya sa kada siyudad ang pagkaon gikan sa mga uma nga nakapalibot niini. ");
INSERT INTO cebulb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Gitipigan ni Jose ang mga trigo nga sama kadaghan sa balas sa dagat, nga mihunong na sila sa pag-ihap, tungod kay dili na nila kini maihap. ");
INSERT INTO cebulb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Adunay duha ka mga anak nga lalaki si Jose sa wala pa miabot ang mga tuig sa kagutom, kansang gimabnos ni Asenat, ang anak nga babaye ni Potifera nga pari sa On. ");
INSERT INTO cebulb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ginganlan ni Jose ug Manases, ang kamagulangan niyang anak, kay siya nag-ingon, “Gibuhat sa Dios nga ako makalimot sa tanan nakong mga kalisod ug sa tibuok pamilya sa akong amahan.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ginganlan niya ug Efraim ang ikaduha niyang anak nga lalaki, kay siya nag-ingon, “Gihimo akong magmabungahon sa yuta sa akong kasakitan.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nahuman ang pito ka mga katuigan sa kadagaya nga anaa sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ug nagsugod na ang pito ka mga katuigan sa kagutom, sumala sa gisaysay ni Jose. Adunay kagutom sa tanang kayutaan, apan adunay pagkaon sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sa dihang ang tanang yuta sa Ehipto nakasinati ug kagutom, ang katawhan nagtawag sa makusog sa Paraon alang sa pagkaon. Ang Paraon nag-ingon sa tanang Ehiptohanon, “Adto kamo kang Jose ug buhata ninyo ang iyang isulti.” ");
INSERT INTO cebulb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ang kagutom mikoyanap sa tibuok yuta. Gipaablihan ni Jose ang tanang balay tipiganan ug gibaligya ngadto sa mga Ehiptohanon. Ang kagutom hilabihan na kaayo sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ang tanan sa kalibotan miabot sa Ehipto aron sa pagpalit ug trigo gikan kang Jose, tungod kay ang kagutom hilabihan na man kaayo sa tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Karon nasayran ni Jacob nga adunay trigo sa Ehipto. Miingon siya sa iyang mga anak nga lalaki, “Nganong nagtinan-away lang man kamo sa usag-usa?” ");
INSERT INTO cebulb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Miingon siya, “Tan-awa dinhi, nakadungog ako nga adunay trigo sa Ehipto. Panglugsong kamo didto ug pamalit kamo ug pagkaon aron mabuhi kita ug dili mangamatay.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ang napulo ka mga igsoon ni Jose milugsong aron mopalit ug trigo sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Apan wala gipakuyog ni Jacob si Benjamin nga igsoon ni Jose, uban sa iyang mga igsoon, kay miingon siya, “Tingali adunay daotan nga mahitabo kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Miabot ang mga anak nga lalaki ni Israel aron sa pagpalit uban niadtong mga miabot, kay ang kagutom anaa na sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Karon si Jose mao ang gobernador sa tibuok kayutaan. Siya mao ang tigbaligya ngadto sa tanang katawhan sa yuta. Miabot ang mga igsoong lalaki ni Jose ug mihapa sila sa iyang atubangan. ");
INSERT INTO cebulb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nakita ni Jose ang iyang mga igsoong lalaki ug nailhan niya sila, apan nagpakaaron-ingnon siya sa iyang kaugalingon ngadto kanila ug masuk-anon nga nakigsulti kanila. Miingon siya kanila, “Asa man kamo gikan?” Miingon sila, “Gikan kami sa yuta sa Canaan aron mopalit ug pagkaon.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nailhan ni Jose ang iyang mga igsoon, apan wala sila makaila kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nahinumdoman ni Jose ang iyang mga damgo mahitungod kanila. Miingon siya ngadto kanila, “Mga espiya kamo. Mianhi kamo aron sa pagsusi sa huyang nga mga bahin sa yuta.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Miingon sila kaniya, “Dili, among agalon. Mianhi ang imong mga sulugoon aron sa pagpalit ug pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mga anak kaming tanan sa usa ka tawo. Matinud-anon kaming mga tawo. Ang imong mga sulugoon dili mga espiya.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Miingon siya ngadto kanila, “Dili, mianhi kamo aron sa pagsusi sa huyang nga mga bahin sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Miingon sila, “Ang imong mga sulugoon dose ka mga managsoon, mga anak nga lalaki sa usa lamang ka tawo sa yuta sa Canaan. Unya, ang among kinamanghoran atua didto karon sa among amahan, ug ang usa namo ka igsoon patay na.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Miingon si Jose kanila, “Mao kini ang giingon ko kaninyo; mga espiya kamo. ");
INSERT INTO cebulb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pagasulayan kamo pinaagi niini. Pinaagi sa ngalan sa Paraon, dili kamo makabiya dinhi, gawas kung dad-on ninyo dinhi ang inyong kinamanghorang igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Papaulia ang usa kaninyo ug ipakuha ang inyong igsoon. Magpabilin kamo sa bilanggoan, aron masulayan ang inyong gipamulong, kung aduna bay kamatuoran diha kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Busa gibutang niya silang tanan sa bilanggoan sulod sa tulo ka mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sa ikatulo ka-adlaw miingon si Jose kanila, “Buhata kini ug mabuhi kamo, tungod kay aduna akoy kahadlok sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kung tinuod nga kamo matinud-anon nga mga tawo, kinahanglan mabilanggo ang usa sa inyong igsoon, apan panlakaw kamo ug pagdala ug trigo alang sa kagutom sa inyong mga panimalay. ");
INSERT INTO cebulb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Dad-a ang inyong kinamanghorang igsoon nga lalaki nganhi kanako aron ang inyong mga pulong mapamatud-an ug dili kamo mamatay.” Busa gibuhat nila kini. ");
INSERT INTO cebulb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Miingon sila sa usag-usa, “Nakasala gayod kita sa atong igsoon kay niadtong nakita nato ang pagtuaw sa iyang kalag samtang siya nagahangyo kanato wala nato siya gipaminaw. Mao nga midangat kanato kining kalisod.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Mitubag si Ruben kanila, “Dili ba nag-ingon man ako kaninyo, 'Ayaw kamo pagpakasala batok sa bata,' apan wala kamo naminaw? Karon, tan-awa, gipaninglan kita sa iyang dugo.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wala sila masayod nga nakasabot si Jose kanila, tungod kay aduna may tighubad tali kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mitalikod siya gikan kanila ug mihilak. Mibalik siya ug nakigsulti ngadto kanila. Gikuha niya si Simeon gikan kanila ug gigapos siya samtang sila nagtan-aw. ");
INSERT INTO cebulb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Unya nagsugo si Jose sa iyang mga sulugoon sa pagpuno sa ilang mga sudlanan ug trigo, ug isulod pagbalik ang salapi sa ilang matag sako, ug hatagan sila ug pagkaon sa ilang pagpanaw. Gibuhat kini ngadto kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Gikargahan sa mga managsoon ang ilang mga asno sa mga trigo ug mibiya sila didto. ");
INSERT INTO cebulb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Samtang ang usa kanila miabli sa iyang sako aron sa pagkuha ug pagkaon alang sa iyang asno sa dapit nga pahulayanan, nakita niya ang iyang salapi. Tan-awa, anaa kini sa sulod sa iyang sako. ");
INSERT INTO cebulb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Miingon siya sa iyang mga igsoong lalaki, “Ang akong salapi nahibalik. Tan-awa kini; anaa kini sa akong sako.” Ug nahugno ang ilang mga kasingkasing ug nangurog sila sa usag-usa. Miingon sila, “Unsa ba kining gibuhat sa Dios kanato?” ");
INSERT INTO cebulb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Miadto sila kang Jacob, nga ilang amahan sa yuta sa Canaan, ug gisuginlan siya sa tanang mga nahitabo kanila. Miingon sila, ");
INSERT INTO cebulb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ang tawo, nga agalon sa yuta, maisugon nga nagsulti kanamo ug gidudahan kami nga mga espiya sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Miingon kami kaniya, 'Matinud-anon kami nga mga tawo. Dili kami mga espiya. ");
INSERT INTO cebulb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Dose kami ka managsoon, mga anak nga lalaki sa among amahan. Ang usa patay na, ug ang kinamanghoran atua karon sa among amahan sa yuta sa Canaan.' ");
INSERT INTO cebulb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ang tawo, nga agalon sa yuta, miingon kanamo, 'Pinaagi niini, masayran ko kung matinud-anon ba kamo nga mga tawo. Ibilin ang usa sa inyong igsoon kanako, pagdala kamo ug trigo alang sa kagutom sa inyong mga panimalay, ug panlakaw kamo. ");
INSERT INTO cebulb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Dad-a ang inyong kinamanghorang igsoon nga lalaki nganhi kanako. Unya masayran ko nga kamo dili mga espiya, ug kamo matinud-anon nga mga tawo. Unya pagawason ko ang inyong igsoon, makabaligya ug makapamalit na kamo dinhing yuta.'” ");
INSERT INTO cebulb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Miabot ang higayon nga sa dihang gihuwad nila ang ilang mga sako, ug, tan-awa, ang kada iya nga sudlanan nga puno sa plata anaa sa ilang matag sako. Sa dihang nakita nila ug sa ilang amahan ang ilang mga plata, nangahadlok sila. ");
INSERT INTO cebulb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ang ilang amahan nga si Jacob miingon kanila, “Gikuhaan ninyo ako ug mga anak. Patay na si Jose, si Simeon wala na, ug ipalayo pa gayod ninyo gikan kanako si Benjamin. Supak kanako kining tanang mga butanga.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Misulti si Ruben sa iyang amahan nga nag-ingon, “Mamahimo mong patyon ang duha ko ka mga anak nga lalaki kung dili ko madala pagbalik diha kanimo si Benjamin. Isalig siya sa akong mga kamot, ug dad-on ko siya pagbalik nganhi kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Miingon si Jacob, “Dili nako palugsongon uban kaninyo ang akong anak. Tungod kay patay na ang iyang igsoon ug siya na lamang ang nahibilin. Kung adunay mahitabo kaniya sa dalan nga inyong pagalakwan, nan kamoy makaingon sa pagdala sa ubanon kong buhok ngadto sa seol tungod sa kasub-anan.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Hilabihan na kaayo ang kagutom sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Niabot ang higayon sa dihang ila nang nahurot ug kaon ang mga trigo nga ilang gidala gikan sa Ehipto, miingon kanila ang ilang amahan, “Lakaw pag-usab; pagpalit ug pagkaon alang kanato.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Miingon si Juda kaniya, “Ang tawo nagpasidaan pag-ayo kanamo, 'Dili kamo makakita sa akong dagway gawas kung kauban ninyo ang inyong igsoong lalaki.' ");
INSERT INTO cebulb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kung imong ipauban ang among igsoong lalaki kanamo, molugsong kami ug palitan ka namo ug pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Apan kung dili mo siya ipauban, dili kami molugsong. Kay miingon kanamo ang tawo, 'Dili kamo makakita sa akong dagway gawas kung inyong kauban ang inyong igsoong lalaki.'” ");
INSERT INTO cebulb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Miingon si Israel, “Nganong dili man maayo ang inyong pagtagad kanako pinaagi sa pag-ingon sa tawo nga aduna pa kamoy usa pa ka igsoong lalaki?” ");
INSERT INTO cebulb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Miingon sila, “Nangutana pag-ayo ang tawo mahitungod kanamo ug sa atong pamilya. Miingon siya, 'Buhi pa ba ang inyong amahan? Aduna pa ba kamoy igsoong lalaki?' Gitubag namo siya sumala niini nga mga pangutana. Unsaon man namo pagkasayod nga moingon siya, 'Dad-a palugsong ang inyong igsoong lalaki?”' ");
INSERT INTO cebulb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Miingon si Juda kang Israel nga iyang amahan, “Ipadala uban kanako ang batang lalaki. Motindog kami ug molakaw aron mabuhi kita ug dili mangamatay, kami, ikaw, ug ang among mga kabataan usab. ");
INSERT INTO cebulb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Magpasalig ako alang kaniya. Manubag ako kanimo. Kung dili ko siya madala balik kanimo ug mapakita siya diha sa imong atubangan, unya ipapas-an kanako ang pagbasol hangtod sa hangtod. ");
INSERT INTO cebulb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kay kung wala kita maglangay, sa pagkatinuod lang nakabalik na unta kami karon dinhi sa ikaduhang higayon.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ang ilang amahan nga si Israel miingon kanila, “Kung mao kana, himoa kini karon. Pagkuha ug pipila ka pinakamaayong abot sa yuta ug ibutang sa inyong panudlanan. Pagdala palugsong ug gasa ngadto sa tawo: pipila nga lana ug dugos, mga lamas ug mira, mga pistasio nga mani ug mga almendras nga mani. ");
INSERT INTO cebulb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Pagdala ug doble nga salapi ug dad-a pag-usab ang salapi nga gibalik sa sulod sa inyong mga sako. Basin sayop lamang kini. ");
INSERT INTO cebulb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dad-a usab ang inyong igsoong lalaki. Tindog ug lakaw pag-usab ngadto sa tawo. ");
INSERT INTO cebulb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hinaot pa nga ang Dios nga Makagagahom maghatag kaninyo ug kaluoy sa atubangan sa tawo, aron iyang buhian ang usa pa ninyo ka igsoong lalaki ug si Benjamin. Kung ako mawad-an sa akong mga anak, mawad-an gayod ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Gikuha sa mga tawo kini nga mga gasa, ug gidoble nila ang kantidad sa salapi, ug gidala si Benjamin. Migikan sila ug milugsong paingon sa Ehipto ug mibarog atubangan kang Jose. ");
INSERT INTO cebulb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sa dihang nakita ni Jose si Benjamin uban kanila, miingon siya sa piniyalan sa iyang balay, “Dad-a ang mga tawo didto sa balay, pag-ihaw ug hayop ug andama kini, kay ang mga tawo mokaon uban kanako sa paniudto.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Gihimo sa piniyalan kung unsa ang gisulti ni Jose. Iyang gidala ang mga tawo didto sa balay ni Jose. ");
INSERT INTO cebulb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nangahadlok ang mga tawo tungod kay gidala man sila didto sa balay ni Jose. Miingon sila, “Tungod kini sa salapi nga gibalik sa atong mga sako sa unang higayon nga gidala kita dinhi, aron makakita siya ug higayon batok kanato. Basin ug iya kitang dakpon ug kuhaon kita aron mahimong ulipon, ug kuhaon ang atong mga asno.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Miduol sila sa piniyalan sa balay ni Jose, ug nakigsulti sila kaniya diha sa pultahan sa balay, ");
INSERT INTO cebulb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","nga naga-ingon, “Among agalon, milugsong kami dinhi sa unang higayon aron mopalit ug pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ug nahitabo kini, nga sa dihang nahiabot kami sa dapit nga among gipahulayan, nga among giablihan ang among mga sako, ug, tan-awa, ang matag salapi sa tawo anaa sa sulod sa iyang sako, ang among salapi anaa sa sakto nga kantidad. Gidala namo kini pagbalik. ");
INSERT INTO cebulb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nagdala na usab kami palugsong ug dugang nga salapi aron pagpalit ug pagkaon. Wala kami masayod kung si kinsa ang nagsulod sa among salapi sa among mga sako.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Miingon ang piniyalan, “Magmalinawon kamo, ayaw kamo kahadlok. Ang inyong Dios ug ang Dios sa inyong amahan mao ang nagsulod sa inyong salapi sa inyong mga sako.” Akong nadawat ang inyong salapi.” Unya gidala pagawas sa piniyalan si Simeon ngadto kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Gidala sa piniyalan ang mga tawo didto sa balay ni Jose. Gihatagan niya sila ug tubig, ug nanghugas sila sa ilang mga tiil. Gihatagan niya ug pagkaon ang ilang mga asno. ");
INSERT INTO cebulb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ug giandam nila ang mga gasa kay moabot si Jose sa pagka-udto, kay nadungog nila nga mokaon sila didto. ");
INSERT INTO cebulb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Sa dihang nahiabot si Jose sa iyang panimalay, gidala nila ang mga gasa nga anaa kanila didto sa balay, ug miyukbo sa iyang atubangan. ");
INSERT INTO cebulb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nangutana siya mahitungod sa ilang kahimtang ug miingon, “Maayo ba ang kahimtang sa inyong amahan, kadtong tigulang na nga lalaki nga inyong giingon? Buhi pa ba siya?” ");
INSERT INTO cebulb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Miingon sila, “Ang imong sulugoon nga among amahan anaa sa maayong kahimtang. Buhi pa siya.” Unya mihapa ug miyukbo. ");
INSERT INTO cebulb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Sa dihang giyahat niya ang iyang mga mata iyang nakita si Benjamin nga iyang igsoon, ang anak nga lalaki sa iyang inahan, ug siya miingon, “Mao ba kini ang inyong kinamanghorang igsoon nga inyong gisugilon kanako?” Ug unya miingon siya, “Hinaot nga ang Dios maluoy kanimo, akong anak.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nagdali si Jose nga migawas sa lawak, kay naluoy siya pag-ayo sa iyang igsoong lalaki. Nangita siya ug luna aron mohilak. Miadto siya sa iyang lawak ug mihilak didto. ");
INSERT INTO cebulb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nanghilam-os siya ug migawas. Gipugngan niya ang iyang kaugalingon, nga nag-ingon, “Idalit ang pagkaon.” ");
INSERT INTO cebulb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Gidalit sa mga sulugoon ang pagkaon nga alang lamang kang Jose ug alang usab sa iyang mga igsoong lalaki. Nangaon usab didto ang mga Ehiptohanon uban kang Jose tungod kay dili man sila makakaon ug tinapay kauban sa mga Hebreo, kay makauulaw kana alang sa mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Naglingkod ang mga managsoong lalaki sa iyang atubangan, sa pinaka- kamagulangan sumala sa iyang katungod sa pagkamagulang, ug sa pinaka-kamanghoran sumala sa ilang pagkabatan-on. Nahibulong ang mga tawo. ");
INSERT INTO cebulb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nagpadala si Jose kanila ug bahin sa mga pagkaon nga anaa sa iyang atubangan. Apan ang bahin ni Benjamin adunay kalimahon ang kadaghan kaysa sa iyang mga igsoong lalaki. Miinom sila ug nagmalipayon uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Gisugo ni Jose ang piniyalan sa iyang balay, nga nag-ingon, “Pun-a ang mga sako sa mga tawo ug pagkaon, kutob sa ilang madala, ug ibutang ang matag salapi sa tawo sa sulod sa iyang sako. ");
INSERT INTO cebulb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ibutang ang akong kupa, ang kupa nga plata, sa sulod sa sako sa kinamanghoran, ug ang iyang salapi alang sa trigo.” Gibuhat sa piniyalan ang gisulti kaniya ni Jose. ");
INSERT INTO cebulb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sa pagkabanag-banag sa kabuntagon, ug gipalakaw na ang mga tawo, sila ug ang ilang mga asno. ");
INSERT INTO cebulb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sa dihang nakagawas na sila sa siyudad apan dili pa halayo, miingon si Jose sa iyang piniyalan, “Tindog, gukda ang mga tawo, ug sa dihang imo silang maapsan, sultihi sila, 'Nganong inyo man nga gibalosan ug daotan ang maayo? ");
INSERT INTO cebulb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Dili ba mao man kini ang kupa nga gina-imnan sa akong agalon, ug ang kupa nga iyang ginagamit sa pagpanagna? Daotan kaayo kining inyong gibuhat.”' ");
INSERT INTO cebulb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Naapsan sila sa piniyalan ug giingon kining mga pulonga kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Miingon sila kaniya, “Nganong makasulti man ang among agalon ug pulong nga sama niini? Dili mahimo sa inyong mga sulugoon kanang mga butanga. ");
INSERT INTO cebulb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tan-awa, ang salapi nga among nakita sa sulod sa among mga sako, gidala namo pagbalik kanimo gikan sa yuta sa Canaan. Unsaon man namo pagkawat sa plata ni bulawan didto sa balay sa imong agalon? ");
INSERT INTO cebulb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kung makaplagan kini sa bisan kinsa sa imong mga sulugoon, mamahimo siyang patyon, ug mamahimo usab kaming mga ulipon sa among agalon.” ");
INSERT INTO cebulb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Miingon ang piniyalan, “Nan karon mahitabo kini sumala sa inyong mga gipamulong. Kaniya kansang nakaplagan ang kupa mamahimong akong ulipon, ug kamong uban dili pakasad-on.” ");
INSERT INTO cebulb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Unya ang matag-usa ka tawo nagdali-dali nga gipanaog ang iyang sako sa yuta, ug giablihan sa matag-usa ang iyang sako. ");
INSERT INTO cebulb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Misusi ang piniyalan. Iyang gisugdan sa kinamagulangan ug nahuman hangtod sa kinamanghoran, ug nakita ang kupa sa sako ni Benjamin. ");
INSERT INTO cebulb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Busa gigisi nila ang ilang mga bisti. Ug gibalik sa matag-usa ang karga sa asno ug mibalik sa siyudad. ");
INSERT INTO cebulb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mibalik si Juda ug ang iyang mga igsoong lalaki sa balay ni Jose. Anaa pa siya didto, ug miyukbo diha sa iyang atubangan. ");
INSERT INTO cebulb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Miingon si Jose ngadto kanila, “Unsa man kining inyong gibuhat? Wala ba kamo masayod nga ang tawo sama kanako makahimo sa pagpanagna?” ");
INSERT INTO cebulb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Miingon si Juda, “Unsa man ang among masulti sa akong agalon? Unsa man ang among ipamulong? Ni unsaon man namo pagpanalipod sa among kaugalingon? Nasayran sa Dios ang sala sa imong mga sulugoon. Tan-awa, kami mga ulipon sa akong agalon, kanamo ug kaniya usab kansang nakaplagan ang kupa.” ");
INSERT INTO cebulb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Miingon si Jose, “Dili ko kana mahimo. Mamahimong akong ulipon, ang tawo kansang nakaplagan ang kupa, apan alang sa uban kaninyo, lakaw pauli sa inyong amahan nga malinawon.” ");
INSERT INTO cebulb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Unya miduol si Juda kaniya ug miingon, “Akong agalon, palihog tugoti ang imong sulugoon nga mosulti ug pulong sa igdulongog sa akong agalon, ug ayaw itugot ang imong kasuko nga magkalayo batok sa imong sulugoon, kay ikaw nahisama man sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nangutana ang akong agalon sa iyang mga sulugoon, nga naga-ingon, 'Aduna pa ba kamoy amahan ug igsoong lalaki?' ");
INSERT INTO cebulb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ug miingon kami sa akong agalon, 'Anaa kami amahan, nga tigulang na, ug usa ka anak sa iyang pagkatigulang, nga gamay'ng bata. Ug ang iyang igsoong lalaki namatay na, ug siya na lamang ang nag-inusarang nahibilin nga anak sa iyang inahan, ug gihigugma siya sa iyang amahan.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ug ikaw miingon sa imong mga sulugoon, 'Dad-a ninyo siya palugsong aron ako siyang makita.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ug miingon kami sa akong agalon, 'Ang bata dili makabiya sa iyang amahan. Kay kung siya mobiya sa iyang amahan ang iyang amahan mamatay.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ug ikaw miingon sa imong mga sulugoon, 'Dili kamo makakita pag-usab sa akong dagway, gawas lang kung ang inyong kinamanghorang igsoon molugsong uban kaninyo.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ug miabot ang higayon sa dihang mitungas kami didto sa imong sulugoon nga akong amahan, among gisugilon kaniya ang mga pulong sa akong agalon. ");
INSERT INTO cebulb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ug ang among amahan miingon, 'Lakaw pag-usab, pagpalit ug pagkaon alang kanato.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ug miingon kami, 'Dili kami molugsong. Apan kung ang among kinamanghorang igsoon uban kanamo, nan molugsong kami, kay dili kami makakita sa panagway sa tawo gawas kung kauban namo ang among kinamanghorang igsoon.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ang imong sulugoon nga akong amahan nagsulti kanamo, 'Nasayod kamo nga ang akong asawa nakabaton kanako ug duha ka mga anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ug ang usa nawala gikan kanako ug ako miingon, “Gikunis-kunis gayod siya, ug sukad wala ko na siya hikit-i.” ");
INSERT INTO cebulb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ug kung inyong kuhaon usab kining usa gikan kanako ug adunay daotang mahitabo kaniya, kamoy magdala sa akong ubanong buhok paubos sa seol nga adunay kasub-anan.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Busa, karon, kung mopauli ako sa imong sulugoon nga akong amahan, ug ang bata dili namo kauban, sanglit ang iyang kinabuhi sumpay man sa kinabuhi sa batang lalaki, ");
INSERT INTO cebulb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","moabot gayod, nga kung iyang makita nga dili namo kauban ang bata mamatay siya. Ug ang imong mga sulugoon ang magdala sa ubanong buhok sa imong sulugoon nga among amahan paubos sa seol nga adunay kasub-anan. ");
INSERT INTO cebulb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kay ang imong sulugoon nagpasalig alang sa batang lalaki ngadto sa akong amahan ug miingon, 'Kung dili ko siya madala pagbalik nganha kanimo, basolon ako sa akong amahan hangtod sa kahangtoran.' ");
INSERT INTO cebulb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Busa karon, palihog tugoti ang imong sulugoon nga magpabilin puli sa batang lalaki aron mahimong sulugoon sa akong agalon, ug tugoti ang batang lalaki nga motungas kauban sa iyang mga igsoong lalaki. ");
INSERT INTO cebulb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kay unsaon man nako pag-adto sa akong amahan kung ang batang lalaki dili nako kauban? Mahadlok ako nga makita ang daotang mahitabo sa akong amahan.” ");
INSERT INTO cebulb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Wala na makapugong si Jose sa iyang kaugalingon atubangan sa tanan niyang mga sulogoon nga nagtindog duol kaniya. Misulti siya sa makusog, “Pahawa kamong tanan gikan kanako.” Walay mga sulogoon nga nagpabilin duol kaniya sa dihang gipaila niya ang iyang kaugalingon ngadto sa iyang mga igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Mihilak siya sa makusog, nakadungog niini ang mga Ehiptohanon, lakip ang panimalay sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Miingon si Jose sa iyang mga igsoon, “Ako si Jose. Buhi pa ba ang akong amahan?” Wala makatubag kaniya ang iyang mga igsoon, tungod kay nakuyawan sila sa iyang presensiya. ");
INSERT INTO cebulb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Unya si Jose miingon sa iyang mga igsoon, “Palihog, duol kamo kanako.” Miduol sila. Siya miingon, “Ako si Jose nga inyong igsoon, nga inyong gibaligya sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ug karon ayaw kamo kaguol o kasuko sa iyong mga kaugalingon nga inyo akong gibaligya dinhi, kay ang Dios nagpadala kanako una kaninyo aron pagtipig sa kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tungod kay adunay kagutom sa yuta niining duha ka tuig, ug aduna pay lima ka mga tuig nga dili makahimo sa pag-daro ni mag-ani. ");
INSERT INTO cebulb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gipadala ako sa Dios una kaninyo aron matipigan kamo ingon nga mga nabilin nga kaliwat sa kalibotan, aron magpabilin kamong mabuhi pinaagi sa dako nga kaluwasan. ");
INSERT INTO cebulb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Busa dili kamo ang nagpadala kanako apan ang Dios, ug gihimo niya ako nga amahan sa Paraon, agalon sa tibuok niyang panimalay, ug pangulo sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Pagdali ug tungas ngadto sa akong amahan ug ingna siya, 'Mao kini ang giingon sa imong anak nga si Jose, Gibuhat ako sa Dios nga agalon sa tibuok Ehipto. Anhi lugsong kanako, ug ayaw paglangan. ");
INSERT INTO cebulb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Magpuyo ka sa yuta sa Gosen, ug maduol kana kanako, ikaw ug ang imong mga anak ug mga anak sa imong mga anak, imong mga karnero ug ang imong mga baka, ug tanan nga anaa kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ako magapatagbo sa inyong panginahanglan didto, kay aduna pay lima ka mga tuig sa kagutom, aron dili kamo makabsan, ikaw, imong panimalay, ug ang tanan nga anaa kanimo. ");
INSERT INTO cebulb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tan-awa, sa inyong mga mata, ug ang mata sa akong igsoon nga si Benjamin, nga kini ang akong baba nagasulti kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Suginlan ninyo ang akong amahan mahitungod sa tibuok nakong gahom sa Ehipto, sa tanan nga inyong nakita. Pagdali kamo ug dad-a ang akong amahan lugsong ngari. ");
INSERT INTO cebulb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Gigakos niya ang iyang igsoon nga si Benjamin sa liog ug mihilak, ug mihilak usab si Benjamin sa iyang liog. ");
INSERT INTO cebulb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Gihalokan niya ang tanan niyang mga igsoon ug mihilak ngadto kanila. Human niana nakig-istorya kaniya ang iyang mga igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ang balita mahitungod sa maong butang gisugilon ngadto sa panimalay sa Paraon; “Miabot ang mga igsoon ni Jose” Nahimuot pag-ayo niini ang Paraon ug ang iyang mga sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Miingon ang Paraon kang Jose, “Ingna ang imong mga igsoon, 'Buhata kini; kargahi ang inyong mga hayop ug adto sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kuhaa ang inyong amahan ug tibuok panimalay ug anhi kanako. Ihatag ko kaninyo ang maayong yuta sa Ehipto, ug makakaon kamo sa tambok sa yuta.' ");
INSERT INTO cebulb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Karon gisugo kamo, 'Buhata kini, pagkuha ug mga karwahi sa yuta sa Ehipto alang sa inyong mga kabataan ug sa inyong mga asawa. Kuhaa ang inyong amahan ug anhi. ");
INSERT INTO cebulb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ayaw kamo kabalaka sa inyong mga kabtangan, tungod kay inyo man ang tanan nga maayo sa yuta sa Ehipto.'” ");
INSERT INTO cebulb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Gibuhat kini sa mga anak ni Israel. Gihatagan sila ni Jose ug mga karwahe sumala sa giingon sa Paraon, ug gihatagan usab sila ug pagkaon sa ilang panaw. ");
INSERT INTO cebulb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kanilang tanan naghatag siya sa matag-usa ug ilisan nga bisti, apan iyang gihatagan si Benjamin ug 300 ka plata ug lima ka ilisan nga bisti. ");
INSERT INTO cebulb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Alang sa iyang amahan gipadala niya kini: napulo ka mga asno nga puno sa mga maayong butang gikan sa Ehipto; ug napulo ka baye nga mga asno nga puno ug trigo, tinapay, ug uban pa nga mga panginahanglan alang sa pagpanaw sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Busa gipagikan niya ang iyang mga igsoon ug sila mibiya. Siya miingon kanila, “Ayaw kamo pag away sa inyong panaw”. ");
INSERT INTO cebulb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Milakaw sila pagawas sa Ehipto ug miabot sa yuta sa Canaan, ngadto kang Jacob nga ilang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Gisuginlan nila siya nga nag-ingon, “Buhi pa si Jose, ug siya ang nagdumala sa tibuok yuta sa Ehipto.” Ug nahibulong ang iyang kasing-kasing, tungod kay wala siya mituo kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Gisugilon nila kaniya ang tanan nga mga pulong nga gisulti ni Jose kanila. Sa pagkakita ni Jacob sa mga karwahe nga gipadala ni Jose aron magdala kaniya, nadasig ang espiritu sa iyang amahan nga si Jacob. ");
INSERT INTO cebulb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Si Israel miingon, “Husto na. Buhi pa si Jose nga akong anak. Muadto ako ug makig-kita kaniya sa dili pa ako mamatay.” ");
INSERT INTO cebulb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Mipanaw si Israel ngadto sa Berseba uban ang tanan nga anaa kaniya. Didto naghalad siya ug mga halad alang sa Dios sa iyang amahan nga si Isaac. ");
INSERT INTO cebulb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ang Dios nakigsulti kang Israel sa usa ka panan-awon niana nga gabii, nga nag-ingon, “Jacob, Jacob.” Siya miingon, “Ania ako.” ");
INSERT INTO cebulb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ang Dios nag-ingon, “Ako ang Dios, ang Dios sa imong amahan. Ayaw kahadlok nga molugsong ngadto sa Ehipto, kay didto himuon ko ikaw nga dakong nasod. ");
INSERT INTO cebulb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ako mag-uban kanimo ngadto sa Ehipto, ug dad-on ko gayod ikaw pag-usab balik dinhi. Ug itik-op ni Jose ang imong mga mata pinaagi sa iyang mga kamot.” ");
INSERT INTO cebulb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Milakaw si Jacob gikan sa Berseba. Gidala sa mga anak nga lalaki ni Israel si Jacob nga ilang amahan, ang ilang mga kabataan, ug ang ilang mga asawa, sakay sa mga karwahe nga gipadala sa Paraon aron iyang pagasakyan. ");
INSERT INTO cebulb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Gidala nila ang mga kahayopan ug ang ilang mga katigayonan nga ilang natigom sa yuta sa Canaan. Miabot sila sa Ehipto, si Jacob ug ang tanan niyang mga kaliwatan kuyog kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iyang gidala uban kaniya ngadto sa Ehipto ang iyang mga anak nga lalaki, ug ang mga anak nga lalaki niini, ang iyang mga anak nga babaye ug ang mga anak nga babaye sa iyang mga anak nga lalaki, ug tanan niyang mga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mao kini ang mga ngalan sa mga anak ni Israel nga miabot sa Ehipto, si Jacob ug ang iyang mga anak nga lalaki: Si Ruben, kamagulangang anak ni Jacob; ");
INSERT INTO cebulb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ang mga anak ni Ruben Hanoc ug si Palu ug si Hesron ug si Carmi; ");
INSERT INTO cebulb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ang mga anak nga lalaki ni Simeon, mao sila Jemuel, si Jamin, si Ohad, si Jakin, si Sohar, ug si Saul, ang anak nga lalaki sa babayeng taga-Canaan; ");
INSERT INTO cebulb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ang mga anak nga lalaki ni Levi sila mao si Gerson, si Cohat, ug si Merari; ");
INSERT INTO cebulb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ang mga anak nga lalaki ni Juda: mao sila Er, si Onan, si Sela, si Peres, ug si Sera, (apan si Er ug Onan namatay sa yuta sa Canaan). Ug ang mga anak nga lalaki ni Peres mao si Hesron ug Hamul. ");
INSERT INTO cebulb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ang mga anak nga lalaki ni Isacar mao sila Tola, si Pua, si Lob, ug si Simron; ");
INSERT INTO cebulb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ang mga anak nga lalaki ni Zabulon mao sila Sered, si Elon, ug si Jaleel. ");
INSERT INTO cebulb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Mao kini ang mga anak nga lalaki ni Lea nga iyang gipakatawo kang Jacob sa Paddan Aram, lakip si Dina nga anak niyang babaye. Mikabat ug 33 ang iyang mga anak nga lalaki ug ang mga anak niyang babaye. ");
INSERT INTO cebulb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ang mga anak nga lalaki ni Gad mao sila Sifeon, si Hagi, si Suni, si Esbon, si Eri, si Arod, ug si Areli. ");
INSERT INTO cebulb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ang mga anak nga lalaki ni Aser mao sila Imna, si Iska, si Isvi, ug si Beria. Ug si Sera mao ang ilang igsoong babaye. Ug mga anak nga lalaki ni Beria mao sila Eber ug si Malkiel. ");
INSERT INTO cebulb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Mao kini ang mga anak nga lalaki ni Zilfa, kansang gihatag ni Laban ngadto sa iyang anak nga babaye nga si Lea. Mao kini ang iyang mga gipakatawo kang Jacob-16 tanan. ");
INSERT INTO cebulb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ang mga anak nga lalaki sa asawa ni Jacob nga si Raquel mao sila Jose ug Benjamin. ");
INSERT INTO cebulb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Sa Ehipto si Manases ug Efraim natawo kang Jose pinaagi kang Asenat, ang anak nga babaye ni Potifera nga pari sa On. ");
INSERT INTO cebulb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ang mga anak nga lalaki ni Benjamin mao sila Bela, Betser, Asbel, Gera, Naaman, Ehi, Ros, Mufim, Hufim, ug si Ared. ");
INSERT INTO cebulb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Mao kini ang mga anak nga lalaki ni Jacob nga natawo ngadto kang Raquel-14 tanan. ");
INSERT INTO cebulb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ang anak nga lalaki ni Dan mao si Husim. ");
INSERT INTO cebulb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ang mga anak nga lalaki ni Neftali mao sila Jaseel, si Guni, si Jeser, ug si Selem. ");
INSERT INTO cebulb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Mao kini ang mga anak nga lalaki nga natawo kang Jacob pinaagi kang Bilha, kansang gihatag ni Laban ngadto kang Raquel nga anak niyang babaye - pito tanan. ");
INSERT INTO cebulb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ang tanang tawo nga miabot uban ni Jacob ngadto sa Ehipto, nga mao ang iyang mga kaliwat, wala pay labot ang mga asawa sa mga anak ni Jacob nga lalaki 66 tanan. ");
INSERT INTO cebulb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Apil sa duha ka mga anak nga lalaki ni Jose nga natawo kaniya sa Ehipto, 70 tanan ang mga sakop sa iyang panimalay ang miadto sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Gipadala ni Jacob si Juda una kanila ngadto kang Jose aron ipakita kaniya ang dalan paingon sa Gosen, ug nakaabot sila sa yuta sa Gosen. ");
INSERT INTO cebulb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Giandam ni Jose ang iyang karwahe ug mitungas sa Gosen aron sa pakigkita kang Israel nga iyang amahan. Nakita niya siya, migakos sa iyang liog, ug naghilak ug dugay. ");
INSERT INTO cebulb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Si Israel miingon kang Jose, “Karon tugoti ako nga mamatay na, sanglit nakita ko na ang imong panagway, nga ikaw buhi pa.” ");
INSERT INTO cebulb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Miingon si Jose sa iyang mga igsoong lalaki ug sa panimalay sa iyang amahan, “Moadto ako ug sultihan ko ang Paraon, nga mag-ingon, 'Ang akong mga igsoong lalaki ug ang panimalay sa akong amahan, nga anaa sa yuta sa Canaan, nahiabot kanako. ");
INSERT INTO cebulb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ang mga tawo mga magbalantay, tungod kay tig-atiman man sila sa mga kahayopan. Gidala nila ang ilang mga karnero, mga baka, ug ang tanan nga anaa kanila.” ");
INSERT INTO cebulb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Moabot ang higayon, sa dihang tawgon kamo sa Paraon ug pangutan-on, “Unsa man ang inyong trabaho?” ");
INSERT INTO cebulb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","kinahanglan kamong moingon nga, “Ang imong mga sulugoon mga tig-atiman ug mga kahayopan sukad pa sa pagkabatan-on ug hangtod karon, kami, ug ang among mga katigulangan.' Buhata kini aron makapuyo kamo sa yuta sa Gosen, kay ang mga magbalantay ginakasilagan man sa mga Ehiptohanon.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Unya miadto ug miingon si Jose sa Paraon, “Miabot gikan sa yuta sa Canaan ang akong amahan ug akong mga igsoon, ang ilang mga karnero, ilang mga kahayopan, ug ang tanan nga ilang gipanag-iyahan. Tan-awa, anaa sila sa yuta sa Gosen.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Gikuha niya ang lima niya ka mga igsoon ug gipaila-ila ngadto sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Miingon ang Paraon sa mga igsoon ni Jose “Unsa man ang inyong mga trabaho?” Miingon sila sa Paraon, “Magbalantay sa mga karnero ang imong mga sulugoon, sama sa among katigulangan.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Unya miingon sila sa Paraon, “Mianhi kami aron mopuyo sa yuta sa makadiyot lang. Walay kalan-on alang sa mga karnero sa imong sulugoon, tungod kay hilabihan man kaayo ang kagutom sa yuta sa Canaan. Busa karon, palihog tugoti nga mopuyo ang imong mga sulugoon sa yuta sa Gosen.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Unya nakig-istorya ang Paraon kay Jose, nga miingon, “Mianha kanimo ang imong amahan ug imong mga igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ang yuta sa Ehipto alang kanimo. Ipahiluna ang imong amahan ug ang imong mga igsoon sa labing maayong dapit, ang yuta sa Gosen. Kung may nailhan ka nga adunay katakos kanila, himoa silang tig-atiman sa akong kahayopan.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Unya gidala ni Jose si Jacob nga iyang amahan ug gipaila-ila sa Paraon. Gipanalanginan ni Jacob ang Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Miingon ang Paraon kay Jacob, “Pila na man imong edad?” ");
INSERT INTO cebulb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Mitubag si Jacob sa Paraon, “130 ka mga tuig ang akong paglakaw niining kalibotana. Hamubo lang ang mga tuig sa akong kinabuhi ug daghang kasakitan. Dili sama kataas sa kinabuhi sa akong mga katigulangan.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Unya gipanalanginan ni Jacob ang Paraon ug mibiya sa iyang atubangan. ");
INSERT INTO cebulb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Unya gipahimutang ni Jose ang iyang amahan ug ang iyang mga igsoon. Gihatagan niya sila ug luna sa yuta sa Ehipto, ang pinaka labing maayo nga yuta, mao ang yuta sa Ramases, sumala sa gisugo sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Naghatag si Jose ug pagkaon sa iyang amahan, sa iyang mga igsoon, ug sa tanang anaa sa panimalay sa iyang amahan, sumala sa gidaghanon sa ilang mga sakop. ");
INSERT INTO cebulb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Karon wala nay pagkaon sa tibuok yuta; tungod sa hilabihang kagutom. Nangaluya ang katawhan sa Ehipto ug ang katawhan sa Canaan tungod sa hilabihan nga kagutom. ");
INSERT INTO cebulb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Gitigom ni Jose ang tanan nga salapi nga anaa sa yuta sa Ehipto ug sa yuta sa Canaan, pinaagi sa pagbaligya ug trigo ngadto sa mga lumolupyo. Unya gidala ni Jose ang salapi ngadto sa palasyo sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sa diha nga nagasto ang tanang salapi sa yuta sa Ehipto ug sa Canaan, miadto ang tanang mga Ehiptohanon kang Jose ug miingon, “Hatagi kami ug pagkaon! Nganong kinahanglan nga kami mamatay sa imong atubangan tungod ba kay nahurot na ang among salapi?” ");
INSERT INTO cebulb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Miingon si Jose, “Kung nahurot na ang inyong salapi, dalaha ang inyong mga kahayopan nganhi ug hatagan ko kamo ug pagkaon baylo sa inyong mga hayop.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Busa gidala nila ang ilang mga hayop ngadto kang Jose. Gihatagan sila ni Jose ug pagkaon baylo sa ilang mga kabayo, sa mga karnero, sa mga baka, ug mga asno. Gipakaon niya sila ug tinapay agig baylo sa tanan nilang mga kahayopan niadtong tuiga. ");
INSERT INTO cebulb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Sa natapos kadtong tuiga, miadto sila kaniya sa sunod nga tuig ug miingon kaniya, “Dili namo itago sa among agalon nga ang among salapi nahurot na, ug ang panon sa mga baka nga ana sa akong agalon. Wala nay nahibilin sa atubangan sa among agalon, gawas sa among lawas ug among yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nganong kinahanglan man nga mamatay kami sa imong atubangan, ug madaot ang among yuta? Palita kami ug ang among yuta agig baylo sa pagkaon, ug kami ug ang among yuta mahimong ulipon sa Paraon. Hatagi kamig binhi aron kami mabuhi ug dili mamatay, ug aron dili mapasagdan ang yuta.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Busa gipalit ni Jose ang tanang yuta sa Ehipto alang kang Paraon. Sa matag Ehiptohanon gibaligya nila ang ilang uma, tungod kay ang kagutom hilabihan na gayod. Sa ingon-ani nga pamaagi, napanag-iya sa Paraon ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Alang sa mga tawo, gihimo niya silang ulipon gikan sa usa ka utlanan sa Ehipto ngadto sa pikas nga utlanan. ");
INSERT INTO cebulb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Apan wala gipalit ni Jose ang yuta sa mga pari tungod kay gitagbo man ang mga pagpanginahanglan sa mga pari. Sila mikaon gikan sa gahin nga gihatag sa Paraon kanila. Tungod niana wala nila gibaligya ang ilang yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Unya miingon si Jose sa mga katawhan, “Tan-awa, gipalit ko kamo ug inyong yuta alang sa Paraon. Karon ania ang binhi para kaninyo, ug tamni ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sa ting-ani, ihatag ninyo ang ika-limang bahin ngadto sa Paraon, ug ang ika-upat nga bahin alang sa inyong kaugalingon, sa binhi sa kaumahan ug alang sa pagkaon sa inyong panimalay ug sa inyong mga kabataan.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Sila miingon, “Giluwas nimo ang among kinabuhi. Makakaplag unta kami ug pabor sa imong panan-aw. Kami mamahimong ulipon sa Paraon.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Busa nagbuhat si Jose ug balaod ug gipatuman sa yuta sa Ehipto hangtod niining adlawa, nga ang ika-limang bahin iya sa Paraon. Ang yuta lamang sa pari ang wala napanag-iya sa Paraon. ");
INSERT INTO cebulb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Busa nagpuyo si Israel sa yuta sa Ehipto, sa yuta sa Gosen. Nakapanag-iya ang iyang mga katawhan ug kabtangan didto ug sila nagmabungahon ug nanaghan pag-ayo. ");
INSERT INTO cebulb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nagpuyo si Jacob sa yuta sa Ehipto sulod sa 17 ka mga tuig, busa ang katuigan sa kinabuhi ni Jacob nagpangidaron ug 147 ka mga tuig. ");
INSERT INTO cebulb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sa dihang hapit na mamatay si Israel, gitawag niya ang iyang anak nga si Jose ug miingon siya kaniya, “Kung makakaplag ako karon ug pabor sa imong atubangan, ibutang ang imong kamot ubos sa akong paa, ug ipakita kanako ang imong pagkamatinud-anon ug pagkamasaligan. Palihog ayaw ako ilubong sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sa dihang matulog na ako uban sa akong mga amahan, dad-a ako sa gawas sa Ehipto ug ilubong ako sa lubnganan sa akong mga katigulangan.” Miingon si Jose, “Buhaton ko ang giingon mo.” ");
INSERT INTO cebulb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Miingon si Israel, “Panumpa kanako,” ug nanumpa si Jose kaniya. Unya miduko si Israel sa ulohan sa iyang higdaanan. ");
INSERT INTO cebulb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nahiabot ang panahon human niining mga butanga, adunay usa ka tawo nga nag-ingon ngadto kang Jose, “Tan-awa, nagsakit ang imong amahan.” Busa, gidala uban kaniya ang iyang duha ka mga anak nga lalaki, sila Manases ug Efraim. ");
INSERT INTO cebulb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sa dihang nasuginlan si Jacob, “Lantawa, nahiabot ang imong anak nga si Jose aron makita ka.” Naningkamot sa pagbangon si Israel ug milingkod sa higdaanan. ");
INSERT INTO cebulb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Nag-ingon si Jacob kang Jose, “Nagpakita kanako ang Dios nga labing gamhanan sa Luz sa yuta sa Canaan. Gipanalanginan niya ako ");
INSERT INTO cebulb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ug nag-ingon kanako, 'Tan-awa, himuon ko ikaw nga magmabungahon ug modaghan. Himuon ko kanimo ang usa ka pundok sa mga nasod. Ihatag ko kanimo kining yuta sa imong mga kaliwatan ingon nga katigayonan sa dayon.' ");
INSERT INTO cebulb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ug karon ang imong duha ka mga anak nga lalaki, nga natawo kanimo sa yuta sa Ehipto sa wala pa ako nahiabot kanimo didto sa Ehipto, akoa sila. Maako si Efraim ug Manases, ingon nga sila Ruben ug Simeon akoa man. ");
INSERT INTO cebulb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ang imong mga kabataan nga mosunod kanila mamaimo; sila igasulat ilalom sa mga ngalan sa ilang mga igsoong lalaki sa ilang panulundon. ");
INSERT INTO cebulb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Apan alang kanako, niadtong nahiabot ako gikan sa Paddan, sa akong kasubo si Raquel namatay sa dalan sa yuta sa Canaan, samtang aduna pay pipila ka hilay-on paingon sa Efrata. Gilubong ko siya sa dalan paingon sa Efrata (kadto mao ang Betlehem).” ");
INSERT INTO cebulb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sa dihang nakita ni Israel ang mga anak nga lalaki ni Jose, siya nag-ingon, “Kinsa man kini sila?” ");
INSERT INTO cebulb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Nag-ingon si Jose sa iyang amahan, “Sila ang akong mga anak nga lalaki nga gihatag sa Dios kanako dinhi.” Miingon si Israel, “Dad-a sila kanako, aron sila akong mapanalanginan.” ");
INSERT INTO cebulb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Karon hanap na ang mga mata ni Israel tungod sa iyang pangidaron, busa dili na siya halos makakita. Ug gipaduol ni Jose sila kaniya, ug iya silang gihalokan ug gigakos. ");
INSERT INTO cebulb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nag-ingon si Israel kang Jose, “Wala ko kini damha nga makita ko pag-usab ang imong nawong, apan gitugutan pa gayod gani ako sa Dios nga makita lakip ang imong mga anak.” ");
INSERT INTO cebulb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ug gikuha silang duha ni Jose gikan sa tunga sa mga tuhod ni Israel, ug unya siya miduko sa iyang nawong ngadto sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Gikuha silang duha ni Jose, si Efraim sa iyang tuo nga kamot ngadto sa wala nga kamot ni Israel, ug si Manases sa iyang wala nga kamot ngadto sa tuo nga kamot ni Israel, ug gidala sila paduol kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Gipataas ni Israel ang iyang tuong kamot ug gipatong kini ibabaw sa ulo ni Efraim nga kamanghoran, ug ang iyang wala nga kamot gipatong sa ulo ni Manases. Iyang gisaylo ang iyang mga kamot, kay si Manases man ang kinamaguwangan. ");
INSERT INTO cebulb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nagpanalangin si Israel kang Jose nga nag-ingon, “Ang Dios kaniadto nga gialagaran sa akong mga amahan nga sila Abraham ug Isaac, ang Dios nga nag-atiman kanako hangtod niining adlawa, ");
INSERT INTO cebulb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ang anghel nga nagapanalipod kanako gikan sa tanang kadaot, hinaot magpanalangin siya niining mga bataa. Hinaot pa unta nga ang akong ngalan maingalan kanila, ug ang ngalan sa akong mga amahan nga sila Abraham ug Isaac. Hinaot sila mosanay ngadto sa panon sa kalibotan.” ");
INSERT INTO cebulb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Sa dihang nakita ni Jose ang tuong kamot sa iyang amahan nga gibutang sa ulo ni Efraim, wala kini nakapahimuot kaniya. Iyang gikuha ang kamot sa iyang amahan ug gibalhin kini gikan sa ulo ni Efraim ngadto sa ulo ni Manases. ");
INSERT INTO cebulb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nag-ingon si Jose ngadto sa iyang amahan, “Dili, akong amahan; kay kini ang kinamagulangan. Ibutang ang imong tuong kamot sa iyang ulo.” ");
INSERT INTO cebulb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ang iyang amahan nagbalibad ug nag-ingon, “Nasayod ako, akong anak, nasayod ako. Siya usab mahimong usa ka katawhan, ug mahimo usab siyang usa ka bantogan. Apan ang iyang manghod mas bantogan pa gayod kay kaniya, ug ang iyang kaliwatan mahimong bagang panon sa mga nasod.” ");
INSERT INTO cebulb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Gipanalanginan ni Israel sila niadtong adlawa niining mga pulonga, “Magalitok ang katawhan sa Israel ug mga panalangin pinaagi sa imong ngalan nga maga-ingon, 'Hinaot nga maghimo ang Dios kanimo sama kang Efraim ug sama kang Manases'.” Niini nga paagi, gibutang ni Israel si Efraim sa unahan ni Manases. ");
INSERT INTO cebulb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nag-ingon si Israel kang Jose, “Tan-awa, hapit na ako mamatay, apan magauban ang Dios kanimo, ug magadala kanimo pabalik sa yuta sa imong mga amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ngadto kanimo, ingon nga usa ka labaw kay sa imong mga igsoong lalaki, ihatag ko kanimo ang habog nga bukid nga akong gikuha gikan sa mga Amorihanon pinaagi sa akong espada ug sa akong pana.” ");
INSERT INTO cebulb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Unya gitawag ni Jacob ang iyang mga anak nga lalaki, ug miingon, “Pagtigom kamong tanan, aron akong masulti kaninyo kung unsa ang mahitabo kaninyo sa umaabot. ");
INSERT INTO cebulb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Pagtigom kamo ug paminaw, kamong mga anak nga lalaki ni Jacob. Paminaw kamo kang Israel, nga inyong amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ikaw ang akong kinamagulangan, ang akong kusog, ug ang sinugdanan sa akong kalig-on, dungganan sa dignidad, ug dungganan sa gahom. ");
INSERT INTO cebulb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Dili magpungan nga sama sa naghaganas nga tubig, wala na kanimo ang pagkamadungganon, tungod kay ikaw misaka sa higdaanan sa imong amahan. Unya imong gihugawan kini; misaka ka sa akong tuloganan. ");
INSERT INTO cebulb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Si Simeon ug Levi magkauban. Ang mga hinagiban sa pagpatay mao ang ilang mga espada. ");
INSERT INTO cebulb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O, akong kalag, ayaw pagduol sa ilang tigom; ayaw pag-apil sa ilang mga panagtigom, sanglit kay ang akong kasingkasing hilabihan ra kaayo kadungganon alang niana. Tungod kay sa ilang kasuko sila mipatay ug mga tawo. Ilang kalipay ang pagtigbas sa tikod sa mga baka. ");
INSERT INTO cebulb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Matinunglo ang ilang kasuko, tungod kay kini pintas- ug ang ilang kapungot, tungod kay kini bangis. Ako silang bahinon kang Jacob ug patibulaagon sila sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, ang imong mga igsoong lalaki magadayeg kanimo. Ang imong kamot maanaa sa liog sa imong mga kaaway. Ang mga anak nga lalaki sa imong amahan moyukbo sa imong atubangan. ");
INSERT INTO cebulb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Si Juda anak sa liyon. Akong anak, ikaw nahibalik gikan sa imong mga biktima. Mitikubo siya, mihapa siya sama sa liyon, sama sa bayeng liyon. Kinsa may mangahas nga mopukaw kaniya? ");
INSERT INTO cebulb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ang baton dili mahimulag gikan kang Juda, ni ang sungkod sa magmamando gikan sa taliwala sa iyang mga tiil, hangtod nga moabot ang Silo. Ang mga nasod motuman kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Igahigot ang iyang nating kabayo ngadto sa paras, ug ang nati sa iyang asno ngadto sa piniling paras, gilabhan niya ang iyang mga bisti ngadto sa bino, ug ang iyang kupo sa duga sa ubas. ");
INSERT INTO cebulb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ang iyang mga mata sama kaitom sa bino, ug ang iyang mga ngipon sama kaputi sa gatas. ");
INSERT INTO cebulb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Magpuyo si Zabulon sa baybayon sa kadagatan. Mamahimo siyang dunggoanan sa mga barko, ug ang iyang utlanan mosangko ngadto sa Sidon. ");
INSERT INTO cebulb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Si Isacar ang kusgang asno, nga nagahigda sa taliwala sa mga kulongan sa mga karnero. ");
INSERT INTO cebulb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Makakita siya ug maayong kapahulayan ug maanindot nga yuta. Iyang bawogon ang iyang abaga sa kabug-at ug mahimo siyang ulipon sa buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Magahukom si Dan sa iyang mga katawhan isip usa sa mga banay sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Si Dan mamahimong bitin sa daplin sa dalan, ang malalang bitin sa agianan nga mopaak sa tikod sa kabayo, aron mahulog ang nagsakay niini. ");
INSERT INTO cebulb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Maghulat ako sa imong kaluwasan, Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad- ang mga manggugubat mohasmag kaniya, apan atakihon niya sila diha sa ilang mga tikod. ");
INSERT INTO cebulb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ang pagkaon ni Aser mamahimong sama sa dato, ug siya magatagbo ug harianong mga pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Si Neftali ang bayeng binaw nga nakabuhi, ug siya makabaton ug maanyag nga mga anak. ");
INSERT INTO cebulb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Si Jose ang mabungahon nga dagkong sanga, ang mabungahon nga dagkong sanga haduol sa tuboran, kansang mga sanga mikatay saylo sa pader. ");
INSERT INTO cebulb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Moataki kaniya ang mga mamamana ug moigo ug mosamok kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Apan ang iyang pana magpabiling makanunayon, ug ang iyang mga kamot mahimong hanas tungod sa mga kamot sa Makagagahom ni Jacob, tungod sa ngalan sa Magbalantay, ang Bato sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tungod kay ang Dios sa imong amahan, nga motabang kanimo, ug tungod sa Halangdong Dios, nga magapanalangin kanimo sa mga panalangin gikan sa kahitas-an, mga panalangin sa kinahiladman, mga panalangin sa mga dughan ug tagoangkan. ");
INSERT INTO cebulb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ang mga panalangin sa imong amahan mas modako kaysa sa mga karaang kabukiran o sa mga ginatinguha nga mga butang sa malungtarong kabungtoran. Sila maanaa sa ulo ni Jose, ang mga panalangin nga gikurona kaniya nga prinsipe sa iyang mga igsoon. ");
INSERT INTO cebulb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Si Benjamin mao ang gigutom nga lobo. Sa kabuntagon siya motukob sa iyang tukbonon, ug sa kagabhion iyang bahinon ang iyang mga gipanglimbongan.” ");
INSERT INTO cebulb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Mao kini ang mga dose ka mga banay ni Israel. Mao kini ang gisulti sa ilang amahan ngadto kanila sa dihang iya silang gipanalanginan. Ang matag-usa iyang gipanalanginan ug haom nga panalangin. ");
INSERT INTO cebulb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Unya iya silang gitugonan ug siya miingon kanila, “Hapit na ako moadto sa akong mga katawhan. Ilubong ako uban sa akong mga katigulangan sa langob nga anaa sa uma ni Efron nga Hetihanon, ");
INSERT INTO cebulb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","sa langob nga anaa sa uma ni Macpela, kung asa haduol sa Mamre sa yuta sa Canaan, ang uma nga pinalit ni Abraham aron mamahimong dapit alang sa lubnganan gikan kang Efron nga Hetihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Gilubong nila didto si Abraham ug si Sara nga iyang asawa; Gilubong nila didto si Isaac ug si Rebecca nga iyang asawa; ug akong gilubong didto si Lea. ");
INSERT INTO cebulb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ang uma ug ang langob nga anaa niini nga napalit gikan sa katawhan sa Het.” ");
INSERT INTO cebulb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sa dihang nahuman si Jacob ug tugon niini ngadto sa iyang mga anak nga lalaki, iyang gi-alsa ang iyang mga tiil ngadto sa iyang higdaanan, miginhawa sa iyang kataposan, ug miadto sa iyang mga katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Unya nasubo pag-ayo si Jose nga nakoyapan siya atubangan sa iyang amahan, ug mihilak siya, ug gihagkan niya siya. ");
INSERT INTO cebulb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Gisugo ni Jose ang iyang mga sulugoon nga mga mananambal sa pagbalsamar sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Busa ang mga mananambal mibalsamar kang Israel. Naabtan sila ug 40 ka mga adlaw, kay mao kana ang kinatibuk-an nga panahon sa pagbalsamar. Ang mga Ehiptohanon naghilak alang kaniya sulod sa 70 ka mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sa dihang ang mga adlaw sa pagsubo natapos na, nakigsulti si Jose ngadto sa kinatas-ang hukmanan sa Paraon ug miingon, “Kung karon ako nakakaplag ug pabor sa imong mga mata, palihog pakig-istorya ngadto sa Paraon, nga mag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Gipasaad ako sa akong amahan, nga nag-ingon, “Tan-awa, hapit na ako mamatay. Ilubong mo ako sa lubnganan nga akong gikalot alang sa akong kaugalingon sa yuta sa Canaan. Diin didto mo ako ilubong.” Karon tugoti ako nga motungas ug molubong sa akong amahan, ug unya mobalik ako.”' ");
INSERT INTO cebulb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mitubag ang Paraon, “Lakaw ug ilubong ang imong amahan, ingon nga siya nagpasaad kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Mitungas si Jose aron sa paglubong sa iyang amahan. Kauban niya mitungas ang tanang kadagkoan sa Paraon, ang mga anaa sa hukmanan sa iyang panimalay, ug ang tanang labaw sa mga kadagkoan sa yuta sa Ehipto, ");
INSERT INTO cebulb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","uban ang tanang panimalay ni Jose ug ang iyang mga igsoon, ug ang panimalay sa iyang amahan. Apan ilang gibilin ang mga gagmayng kabataan, ilang mga karnero, ug ilang mga baka, sa yuta sa Gosen. ");
INSERT INTO cebulb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ang mga nagakarwahe ug ang manggugubat miuban kaniya. Daghan kaayo kini nga pundok sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Sa dihang miabot sila sa giokanan sa Atad sa ubang bahin tabok sa Jordan, nagbangotan sila pag-ayo ug nagsubo sa hilabihan gayod. Didto si Jose nagmugna ug kasubo sa pito ka adlaw alang sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Sa dihang ang mga lumolupyo sa yuta, ang mga Canaanhon, nakita ang pagbangotan sa giokanan sa Atad, sila miingon, “Subo kaayo kini nga higayon alang sa mga Ehiptohanon.” Busa kining dapita ginatawag nga Abel Misraim, nga diin kini unahan sa Jordan. ");
INSERT INTO cebulb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Busa gibuhat sa iyang mga anak alang kang Jacob sumala sa iyang gitugon kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Gidala siya sa iyang mga anak didto sa yuta sa Canaan ug gilubong siya sa langob sa uma sa Macpela, duol sa Mamre. Gipalit ni Abraham ang langob uban ang uma alang sa lugar sa paglubong. Iya kining gipalit gikan kang Efron ang Hetihanon. ");
INSERT INTO cebulb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Paghuman niya ug lubong sa iyang amahan, mibalik si Jose ngadto sa Ehipto, siya, uban ang iyang mga igsoon, ug ang tanang miuban kaniya sa paglubong sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Sa dihang ang mga igsoon ni Jose nakakita nga ang ilang amahan namatay na, sila miingon, “Unsa kaha kung si Jose nagdumot ug gusto niya nga magbayad kita kaniya sa kinatibuk-an sa tanang kadaotan nga atong nahimo kaniya?” ");
INSERT INTO cebulb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Busa ilang gipatawag si Jose ug miingon, “Naghatag ug tugon ang imong amahan sa wala pa siya namatay, miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Sultihi si Jose niini, “Palihog pasayloa ang kalapasan sa imong mga igsoon ug ang ilang sala sa dihang sila naghimo ug daotan kanimo.” Karon palihog pasayloa ang mga sulugoon sa Dios sa imong amahan.” Mihilak si Jose sa dihang nakigsulti sila kaniya. ");
INSERT INTO cebulb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ang iyang mga igsoon usab miadto ug mihapa sa yuta diha sa iyang atubangan. Miingon sila, “Tan-awa, kami imong mga sulugoon.” ");
INSERT INTO cebulb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Apan si Jose mitubag kanila, “Ayaw kamog kahadlok. Anaa ba ako sa dapit sa Dios? ");
INSERT INTO cebulb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kay alang kaninyo, gusto ninyo nga buhatan ako ug daotan, apan alang sa Dios aduna siyay maayo nga katuyoan, aron sa pagtipig sa kinabuhi sa daghang mga tawo, sama sa inyong nakita karon. ");
INSERT INTO cebulb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Busa karon ayaw kahadlok. Ako magapatagbo alang kaninyo ug sa inyong kabataan.” Gihupay niya sila sa niini nga paagi ug malumo nga nakigsulti kanila. ");
INSERT INTO cebulb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Mipuyo si Jose sa Ehipto, kauban sa pamilya sa iyang amahan. Siya nabuhi sulod sa 110 ka-tuig. ");
INSERT INTO cebulb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nakita ni Jose ang ika-tulo nga kaliwatan ni Efraim. Nakita pa gayud niya ang anak ni Makir nga anak ni Manases. Mga “natawo sila sa iyang mga tuhod.” ");
INSERT INTO cebulb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Miingon si Jose sa iyang mga igsoon, “Hapit na ako mamatay; apan ang Dios moadto kaninyo ug magdala kaninyo gawas niining yutaa ngadto sa yuta nga diin iyang gisaad nga ihatag ngadto kang Abraham, kang Isaac, ug kang Jacob.” ");
INSERT INTO cebulb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Unya gipapanumpa ni Jose ang mga tawo sa Israel ug panaad. Miingon siya, “Ang Dios gayod moanhi kaninyo. Niana nga panahon kinahanglan ninyong dad-on ang akong mga bukog gikan dinhi.” ");
INSERT INTO cebulb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Busa si Jose namatay, sa panuigon nga 110. Ila siyang gipabalsamar ug siya ilang gibutang sa lungon sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Mao kini ang mga ngalan sa mga anak nga lalaki ni Israel nga si Jacob nga miabot ngadto sa Ehipto, matag usa uban sa iyang panimalay: ");
INSERT INTO cebulb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Si Reuben, Simeon, Levi, ug si Juda, ");
INSERT INTO cebulb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","si Isacar, Zebulun, ug si Benjamin, ");
INSERT INTO cebulb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","si Dan, Neftali, Gad, ug si Asher. ");
INSERT INTO cebulb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Mikabat ug 70 ang gidaghanon sa tanang katawhan nga mga kaliwat ni Jacob. Atua na daan si Jose sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Unya namatay si Jose, ang tanan niyang igsoon nga mga lalaki, ug ang tanan niana nga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nagmabungahon ang mga Israelita, midaghan pag-ayo, ug nahimong hilabihan ka kusgan; nalukop nila ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Unya karon adunay bag-o nga hari ang mibarog sa Ehipto, siya nga wala makaila mahitungod kang Jose. ");
INSERT INTO cebulb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Miingon siya sa iyang katawhan, “Tan-awa, mas daghan pa ug mas kusgan ang mga Israelita kaysa kanato. ");
INSERT INTO cebulb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Umari kamo, magmanggialamon kita sa pagtagad kanila, kay kondili magpadayon sila ug kadaghan, ug kung moabot ang gubat, makig-uban sila sa atong mga kaaway, makig-away batok kanato, ug mobiya sa yuta.” ");
INSERT INTO cebulb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Busa gibutangan nila sila ug mga tinugyanan sa trabaho aron sa pagdaogdaog kanila pinaagi sa malisod nga trabaho. Nagtukod ang mga Israelita ug mga siyudad nga tipiganan alang sa Faraon: ang Pitom ug ang Rameses. ");
INSERT INTO cebulb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Apan sa dihang gidaogdaog sila pag-ayo sa mga Ehiptohanon, misamot hinuon ug kadaghan ug mikatag pag-ayo ang mga Israelita. Busa nagsugod na ug kalisang ang mga Ehiptohanon sa mga Israelita. ");
INSERT INTO cebulb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Gipatrabaho pag-ayo sa mga Ehiptohanon ang mga Israelita. ");
INSERT INTO cebulb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Gihimo nila nga mapait ang ilang pagkinabuhi tungod sa malisod nga pagpatrabaho pinaagi sa pagbuhat ug alkitran ug tisa, ug uban sa tanang matang sa buluhaton sa kaumahan. Malisod gayod ang tanan nilang kinahanglan nga trabahoon. ");
INSERT INTO cebulb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Unya nakigsulti ang hari sa Ehipto ngadto sa mga mananabang nga Hebreohanon; ang ngalan sa usa mao si Shefra, ug ang usa mao si Pua. ");
INSERT INTO cebulb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Miingon siya, “Sa dihang magpaanak kamo sa mga babaye nga Hebreohanon didto sa paanakan, bantayi sila sa dihang manganak na sila. Kung lalaki kini, nan kinahanglan nga patyon ninyo siya; apan kung babaye kini, nan mabuhi siya.” ");
INSERT INTO cebulb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Apan adunay kahadlok ang mga mananabang ngadto sa Dios ug wala gituman ang gisugo sa hari sa Ehipto kanila; hinuon, gipasagdan nila nga mabuhi ang mga batang lalaki. ");
INSERT INTO cebulb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Gipatawag sa hari sa Ehipto ang mga mananabang ug giingnan sila, “Nganong gibuhat man ninyo kini, ug gitugotan nga mabuhi ang mga bata nga lalaki?” ");
INSERT INTO cebulb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mitubag ang mga mananabang ngadto sa Faraon, “Ang mga babaye nga Hebreohanon dili sama sa mga babaye nga Ehiptohanon. Isog kaayo sila ug nakapanganak na sila sa wala pa moabot ang mananabang kanila.” ");
INSERT INTO cebulb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Gipanalipdan sa Dios kini nga mga mananabang. Nagkadaghan ug maayo ang katawhan ug nahimong hilabihan kakusgan. ");
INSERT INTO cebulb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Tungod kay ang mga mananabang may kahadlok man sa Dios, gihatagan niya sila ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Gimandoan sa Faraon ang tanan niyang katawhan, “Kinahanglan nga ilabay ninyo ngadto sa suba ang matag lalaki nga matawo, apan tugoti ninyo nga mabuhi ang matag bata nga babaye.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Karon giminyoan sa lalaki nga gikan sa tribo ni Levi ang babaye nga gikan usab sa kaliwat ni Levi. ");
INSERT INTO cebulb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Namabdos ang babaye ug nanganak ug usa ka batang lalaki. Sa dihang nakita niya nga himsog siya nga batang lalaki, gitagoan niya siya sulod sa tulo ka bulan. ");
INSERT INTO cebulb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Apan sa dihang dili na niya siya matago, mikuha siya ug basket nga papyrus ug gibulitan kini sa aspalto ug alkitran. Unya gisulod niya ang bata niini ug gipahiluna kini taliwala sa kabugangan didto sa tubig nga daplin sa suba. ");
INSERT INTO cebulb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nagbarog ang iyang igsoon nga babaye didto sa unahan aron makita kung unsa ang mahitabo kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Milugsong sa suba ang anak nga babaye sa Faraon aron maligo samtang naglakaw ang iyang mga katabang daplin sa suba. Nakita niya ang basket taliwala sa kabugangan ug gisugo niya ang iyang katabang nga kuhaon kini. ");
INSERT INTO cebulb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Sa pag-abli niya niini, nakita niya ang bata. Tan-awa, naghilak ang bata. Naluoy siya kaniya ug miingon, “Sigurado gayod nga usa kini sa mga anak sa mga Hebreohanon.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Unya miingon ang igsoon nga babaye sa bata ngadto sa anak nga babaye sa Faraon, “Kinahanglan ba nga molakaw ako ug mangita ug babaye nga Hebreohanon aron magpasuso sa bata alang kanimo?” ");
INSERT INTO cebulb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Miingon ang anak nga babaye sa Faraon ngadto kaniya, “Lakaw.” Busa milakaw ang batan-ong babaye ug gikuha ang inahan sa bata. ");
INSERT INTO cebulb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Miingon ang anak nga babaye sa Faraon sa inahan sa bata, “Dad-a kining bataa ug atimana siya alang kanako, ug suholan ko ikaw.” Busa gidala sa babaye ang bata ug giatiman siya. ");
INSERT INTO cebulb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Sa dihang midako na ang bata, gidala niya siya sa anak nga babaye sa Faraon, ug nahimo siya nga iyang anak nga lalaki. Ginganlan niya siya ug Moises ug miingon, “Tungod kay gikuha ko siya gikan sa tubig.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Sa dihang midako na si Moises, miadto siya sa iyang katawhan ug naniid sa ilang hilabihan nga pagtrabaho. Nakita niya ang usa ka Ehiptohanon nga gikulata ang usa ka Hebreohanon, usa sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Milingi-lingi siya, ug sa dihang nakita niya nga walay tawo didto, gipatay niya ang Ehiptohanon ug gitagoan ang lawas niini sa balas. ");
INSERT INTO cebulb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Miadto na usab siya pagkasunod adlaw, ug, tan-awa, nag-away ang duha ka Hebreohanon. Miingon siya sa tawo nga sad-an, “Nganong gisumbag man nimo ang imong kauban?” ");
INSERT INTO cebulb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Apan miingon ang lalaki, “Kinsa man ang naghimo kanimo nga pangulo ug maghukom nganhi kanamo? Naglaraw ka ba nga patyon ako sama sa imong pagpatay sa Ehiptohanon?” Unya nahadlok si Moises ug miingon, “Sigurado gayod nga nasayran na sa uban ang akong nabuhat.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Karon sa dihang nadunggan sa Faraon ang mahitungod niini, gisulayan niya sa pagpatay si Moises. Apan mikalagiw si Moises gikan sa Faraon ug mipuyo didto sa yuta sa Midian. Didto milingkod siya sa kilid sa atabay. ");
INSERT INTO cebulb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Karon ang pari sa Midian adunay pito ka mga anak nga babaye. Miabot sila, nagsag-ob ug tubig, ug gipuno ang imnanan ug tubig sa mga mananap aron paimnon ang panon sa mga karnero sa ilang amahan. ");
INSERT INTO cebulb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Miabot ang mga magbalantay sa karnero ug misulay sa pagpahawa kanila, apan miadto si Moises ug gitabangan sila. Unya gipainom niya ang panon sa ilang mga karnero. ");
INSERT INTO cebulb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Sa dihang miadto na ang mga babaye kang Reuel nga ilang amahan, miingon siya, “Nganong sayo man kamo nakauli karon?” ");
INSERT INTO cebulb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Miingon sila, “Giluwas kami sa usa ka Ehiptohanon gikan sa mga magbalantay sa karnero. Nagsag-ob usab siya ug tubig alang kanamo ug gipainom ang panon sa mga karnero.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Miingon siya sa iyang mga anak nga babaye, “Unya hain man siya? Nganong gibiyaan man ninyo ang lalaki? Tawga siya aron makakaon siya uban kanato.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Miuyon si Moises nga magpabilin uban sa tawo, nga naghatag usab sa iyang anak nga babaye nga si Zipora ngadto kaniya diha sa kaminyoon. ");
INSERT INTO cebulb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nanganak siya ug batang lalaki, ug ginganlan kini ni Moises ug Gershom; miingon siya, “Nahimo ako nga lumolupyo sa langyaw nga yuta.” ");
INSERT INTO cebulb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Milabay ang taas nga panahon, namatay ang Hari sa Ehipto. Nag-agulo ang mga Israelita tungod sa pagkaulipon sa pagtrabaho. Mituaw sila alang sa pagpakitabang, ug miabot sa Dios ang ilang mga pangamuyo tungod sa ilang pagkaginapos. ");
INSERT INTO cebulb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Sa dihang nadungog sa Dios ang ilang pag-agulo, nahinumdoman sa Dios ang iyang kasabotan tali kang Abraham, kang Isaac ug kang Jacob. ");
INSERT INTO cebulb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nakita sa Dios ang mga Israelita, ug nasabtan niya ang ilang kahimtang. ");
INSERT INTO cebulb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Karon nagbantay gihapon si Moises sa panon sa mga karnero ni Jetro nga iyang ugangan nga lalaki, nga pari sa Midian. Gidala ni Moises ang panon sa mga karnero ngadto sa layong bahin sa kamingawan ug miabot didto sa Horeb, ang bukid sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Didto mipakita ang anghel ni Yahweh kaniya diha sa nagkalayo nga sampinit. Mitan-aw si Moises, ug tan-awa, nagkalayo ang sampinit, apan wala kini masunog. ");
INSERT INTO cebulb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Miingon si Moises, “Moduol ako ug tan-awon kining kahibulongan nga butang, nganong wala man nasunog ang sampinit.” ");
INSERT INTO cebulb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Sa dihang nakita ni Yahweh nga mipaduol siya aron motan-aw, gitawag siya sa Dios gikan sa sampinit ug miingon, “Moises, Moises.” Miingon si Moises, “Ania ako.” ");
INSERT INTO cebulb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Miingon ang Dios, “Ayaw pagpaduol! Huboa ang imong mga sapatos, kay ang dapit nga imong gitindogan mao ang yuta nga gigahin alang kanako.” ");
INSERT INTO cebulb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Midugang pa siya, “Ako ang Dios sa imong amahan, ang Dios ni Abraham, ang Dios ni Isaac, ug ang Dios ni Jacob.” Unya gitabonan ni Moises ang iyang nawong, tungod kay nahadlok siya nga motan-aw sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Miingon si Yahweh, “Nakita ko gayod ang pag-antos sa akong katawhan nga atua sa Ehipto. Nadungog ko ang ilang mga singgit tungod sa ilang mga tinugyanan sa trabaho, kay nasayod ako sa ilang pag-antos. ");
INSERT INTO cebulb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mokanaog ako aron sa pagpalingkawas kanila gikan sa gahom sa mga Ehiptohanon ug aron dad-on sila gikan niana nga yuta paingon sa tabunok, luag nga yuta, didto sa yuta nga nagadagayday ang gatas ug dugos; ngadto sa rehiyon sa mga Canaanhon, mga Hitihanon, mga Amorihanon, mga Perizihanon, mga Hivitihanon, ug mga Jebusihanon. ");
INSERT INTO cebulb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Karon miabot kanako ang mga singgit sa katawhan sa Israel. Dugang pa niana, nakita ko ang pagdaogdaog nga gibuhat sa mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Unya karon, ipadala ko ikaw ngadto sa Faraon aron nga madala nimo ang akong katawhan, nga mga Israelita, pagawas sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Apan miingon si Moises sa Dios, “Kinsa ba ako, nga kinahanglan ako moadto sa Faraon ug ipagawas ang mga Israelita gikan sa Ehipto?” ");
INSERT INTO cebulb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mitubag ang Dios, “Sigurado gayod nga magauban ako kanimo. Mao kini ang timaan diha kanimo nga ako ang nagpadala kanimo. Sa dihang mapagawas mo na ang katawhan gikan sa Ehipto, pagasimbahon ninyo ako niining bukira.” ");
INSERT INTO cebulb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Miingon si Moises sa Dios, “Sa dihang moadto ako sa mga Israelita ug sultihan sila, 'Gipadala ako sa Dios sa inyong katigulangan diha kaninyo', ug sa dihang moingon sila kanako, 'Unsa man ang iyang ngalan?' unsa man ang angay nako nga isulti kanila?” ");
INSERT INTO cebulb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Miingon ang Dios kang Moises, “AKO MAO AKO.” Miingon ang Dios, “Kinahanglan nga sultihan nimo ang mga Israelita nga, 'AKO ang nagpadala kanimo.”' ");
INSERT INTO cebulb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Miingon usab ang Dios kang Moises, “Kinahanglan nga sultihan nimo ang mga Israelita nga, 'si Yahweh, ang Dios sa inyong mga katigulangan, ang Dios ni Abraham, ang Dios ni Isaac, ug ang Dios ni Jacob, ang nagpadala kanako diha kaninyo. Mao kini ang akong ngalan hangtod sa kahangtoran, ug mao kini ang pag-ila kanako hangtod sa tanang mga kaliwatan.' ");
INSERT INTO cebulb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Lakaw ug tigoma ang mga kadagkoan sa Israel. Ingna sila nga, 'Mipakita kanako si Yahweh, ang Dios sa inyong mga katigulangan, ang Dios ni Abraham, ni Isaac, ug ni Jacob, ug miingon, “Gipanid-an ko gayod kamo ug nakita ko ang gipangbuhat kaninyo diha sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nakasaad ako nga pagawson ko kamo gikan sa pagdaogdaog diha sa Ehipto ngadto sa yuta sa mga Canaanhon, mga Hitihanon, mga Amorihanon, mga Perizihanon, mga Hivitihanon, ug mga Jebusihanon, ang yuta nga nagadagayday ang gatas ug ang dugos.”' ");
INSERT INTO cebulb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Maminaw sila kanimo. Kinahanglan nga moadto ka ug ang mga kadagkoan sa Israel ngadto sa hari sa Ehipto, ug kinahanglan nga sultihan nimo siya, 'Nakighimamat kanamo, si Yahweh, nga Dios sa mga Hebreohanon. Busa tugoti kami sa pagpanaw sulod sa tulo ka adlaw ngadto sa kamingawan, aron nga makahalad kami kang Yahweh, nga among Dios.' ");
INSERT INTO cebulb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Apan nasayod ako nga dili kamo tugotan sa hari sa Ehipto nga molakaw, gawas kung mapugos ang iyang kamot. ");
INSERT INTO cebulb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Iisa ko ang akong kamot ug sulongon ang mga Ehiptohanon pinaagi sa tanang mga milagro nga akong himoon sa ilang taliwala. Human niana, tugotan na niya kamo sa paglakaw. ");
INSERT INTO cebulb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Dapigan ko kining katawhan gikan sa mga Ehiptohanon, aron nga kung mobiya kamo, dili kamo molakaw nga walay dala. ");
INSERT INTO cebulb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mangayo ang matag babaye ug mga alahas nga plata ug bulawan ug bisti nga gikan sa iyang mga silingan nga Ehiptohanon ug si bisan kinsa nga babaye nga nagpuyo sa mga balay sa ilang silingan. Isul-ob ninyo kini sa inyong mga anak nga lalaki ug mga babaye. Niini nga paagi kawatan ninyo ang mga Ehiptohanon.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mitubag si Moises, “Apan kung dili sila motuo kanako o maminaw kanako apan moingon hinuon nga, 'Wala mipakita si Yahweh kanimo'?” ");
INSERT INTO cebulb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Miingon si Yahweh kaniya, “Unsa man kanang anaa sa imong kamot?” Miingon si Moises, “Usa ka sungkod.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Miingon si Yahweh, “Iitsa kana sa yuta.” Giitsa kini ni Moises sa yuta, ug nahimo kining bitin. Milikay si Moises gikan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Miingon si Yahweh kang Moises, “Punita ug guniti kini pinaagi sa ikog.” Mao nga gipunit niya ug gigunitan ang bitin. Nahimo kining sungkod pagbalik diha sa iyang kamot. ");
INSERT INTO cebulb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Nahitabo kini aron nga motuo sila nga mipakita kanimo si Yahweh, ang Dios sa ilang mga katigulangan, ang Dios ni Abraham, ang Dios ni Isaac, ang Dios ni Jacob.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Miingon usab si Yahweh kaniya, “Karon isulod ang imong kamot sa imong kupo.” Busa gisulod ni Moises ang iyang kamot sa iyang kupo. Sa dihang gipagawas niya kini, tan-awa, gisangla na ang iyang kamot, sama kaputi sa niyebe. ");
INSERT INTO cebulb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Miingon si Yahweh, “Isulod pagbalik ang imong kamot sa imong kupo, ug sa pagpagawas niya niini, nakita niya nga naayo na kini pag-usab, sama sa uban niyang unod. ");
INSERT INTO cebulb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Miingon si Yahweh, “Kung dili sila motuo kanimo—kung dili sila motagad sa unang timaan sa akong gahom o motuo niini, nan motuo sila sa ikaduha nga timaan. ");
INSERT INTO cebulb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kung dili sila motuo bisan niining duha ka mga timaan sa akong gahom, o maminaw kanimo, nan pagkuha ug gamay nga tubig nga gikan sa suba ug ibubo kini sa mala nga yuta. Mahimong dugo ang tubig nga imong gikuha didto sa mala nga yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Unya miingon si Moises kang Yahweh, “Ginoo, dili ako maayo nga manulti, ni kaniadto o sa takna nga nakigsulti ka sa imong sulugoon. Hinay akong manulti ug yungit.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Miingon si Yahweh kaniya, “Kinsa man kini nga naghimo sa baba sa tawo? Kinsa man ang nagpaamang o nagpabungol sa tawo o nakapakita o nagpabuta? Dili ba ako man, si Yahweh? ");
INSERT INTO cebulb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Busa lakaw, ug ako ang mahimo nimong baba ug tudloan ko ikaw kung unsa ang isulti.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Apan miingon si Moises, “Ginoo, palihog pagpadala nalang ug laing tawo, si bisan kinsa nga imong gusto nga ipadala.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Unya nasuko si Yahweh kang Moises. Miingon siya, “Unsa man ang imong panghunahuna mahitungod kang Aaron, nga imong igsoon nga lalaki, nga Levita? Nasayod ako nga makasulti siya ug maayo. Dugang pa niana, moabot siya aron sa pagpakighimamat kanimo, ug sa dihang makita ka niya, magmaya gayod ang iyang kasingkasing. ");
INSERT INTO cebulb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Makigsulti ka kaniya ug ipahiluna ang mga pulong aron isulti niya kini. Mag-uban ako sa imong baba ug sa iyang baba, ug ipakita ko kaninyo kung unsa ang buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Makigsulti siya sa mga tawo alang kanimo. Siya ang mahimo nimong baba, ug mag-uban ka kaniya sama kanako, nga Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Dad-on nimo kini nga sungkod. Pinaagi niini maghimo ka ug mga timaan.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Busa mibalik si Moises sa iyang ugangan nga lalaki nga si Jetro ug miingon kaniya, “Tugoti ako nga molakaw aron makabalik ako sa akong kaparyentihan nga atua sa Ehipto ug tan-awon kung buhi pa ba gihapon sila.” Miingon si Jetro kang Moises, “Lakaw uban ang kalinaw.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Miingon si Yahweh kang Moises didto sa Midian, “Lakaw, balik sa Ehipto, kay patay na ang tanang kalalakin-an nga misulay sa pagpatay kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Gidala ni Moises ang iyang asawa ug ang iyang mga anak nga lalaki ug gipasakay sila sa asno. Mibalik siya sa yuta sa Ehipto, ug gidala niya ang sungkod sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Miingon si Yahweh kang Moises, “Sa dihang mobalik ka sa Ehipto, siguroha nga mabuhat mo sa atubangan sa Faraon ang tanang kahibulongang gahom nga gihatag ko diha kanimo. Apan patig-ahon ko ang iyang kasingkasing, ug dili niya tugotan nga molakaw ang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kinahanglan nga isulti nimo ngadto sa Faraon, 'Mao kini ang gisulti ni Yahweh; Si Israel mao ang akong anak nga lalaki, nga akong kamagulangan, ");
INSERT INTO cebulb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ug moingon ako kanimo, “Palakwa ang akong anak nga lalaki, aron makasimba siya kanako.” Apan sanglit nagdumili ka man sa pagpalakaw kaniya, pagapatyon ko gayod ang imong kamagulangang anak nga lalaki.”' ");
INSERT INTO cebulb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Karon sa pagkagabii, sa dihang mihunong sila didto sa dalan, gitagbo ni Yahweh si Moises ug misulay sa pagpatay kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Unya gikuha ni Zipora ang santik nga kutsilyo ug giputol niya ang tumoy nga panit sa kinatawo sa iyang anak nga lalaki, ug gipahid kini sa mga tiil ni Moises. Unya miingon siya, “Pinaagi sa dugo sigurado gayod nga ikaw ang akong bana.” ");
INSERT INTO cebulb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Busa gipasagdahan na lamang ni Yahweh si Moises. Miingon si Zipora, “Ikaw mao ang bana sa dugo” tungod sa pagtuli. ");
INSERT INTO cebulb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Miingon si Yahweh kang Aaron, “Lakaw ngadto sa kamingawan aron sa pagpakigkita kang Moises.” Milakaw si Aaron, misugat kaniya didto sa bukid sa Dios, ug mihalok kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Gisultihan ni Moises si Aaron sa tanang mga pulong ni Yahweh nga gipadala niya kaniya aron isulti ug mahitungod sa tanang mga timaan sa gahom ni Yahweh nga iyang gimando kaniya nga buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Unya milakaw si Moises ug Aaron ug gitigom ang tanang mga kadagkoan sa mga Israelita. ");
INSERT INTO cebulb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Gisulti ni Aaron ang tanang mga pulong ni Yahweh nga gisulti kang Moises. Gipakita usab niya ang mga timaan sa gahom ni Yahweh sa panan-aw sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Mituo ang mga tawo. Sa dihang nadungog nila nga naniid si Yahweh sa mga Israelita ug nga nakita niya ang ilang pag-antos, unya giduko nila ang ilang mga ulo ug misimba kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Human nahitabo kining mga butanga, miadto si Moises ug Aaron ngadto sa Faraon ug miingon, “Mao kini ang giingon ni Yahweh, ang Dios sa Israel: 'Palakwa ang akong katawhan, aron makahimo sila ug kasaulogan alang kanako didto sa kamingawan.”' ");
INSERT INTO cebulb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Miingon ang Faraon, “Kinsa man kana si Yahweh? Nganong kinahanglan man nakong paminawon ang iyang tingog ug tugotan nga molakaw ang Israel? Wala ako makaila kang Yahweh; dugang pa, dili ko gayod palakwon ang Israel.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Miingon sila, “Nagpakita kanamo ang Dios sa mga Hebreohanon. Palakwa kami sulod sa tulo ka adlaw nga panaw ngadto sa kamingawan ug maghalad kang Yahweh nga among Dios aron dili niya kami pamatyon pinaagi sa hampak o sa espada. ");
INSERT INTO cebulb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Apan miingon ang hari sa Ehipto kanila, “Moises ug Aaron, nganong gipahunong man ninyo ang mga tawo sa ilang pagtrabaho? Pamalik kamo sa inyong trabaho.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Miingon usab siya, “Aduna nay daghang mga tawo nga Hebreohanon karon sa among yuta, ug gipahunong ninyo sila sa ilang pagtrabaho.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Niadto usab nga adlaw, gimandoan sa Faraon ang mga tinugyanan sa trabaho ug ang mga tigdumala sa mga tawo. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Dili na sama kaniadto, dili na ninyo angay nga hatagan pa ug dagami ang mga tawo aron sa paghimo ug mga tisa. Pasagdahi sila nga moadto ug manguha ug dagami alang sa ilang mga kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Apan, kinahanglan nga mao gihapon ang gidaghanon sa mga tisa nga inyong pangayoon sama sa ilang gihimo kaniadto. Ayaw dawata ang diyutay lang, tungod kay tapolan sila. Mao nga misinggit sila ug nag-ingon, 'Tugoti kami nga molakaw ug maghalad sa among Dios.' ");
INSERT INTO cebulb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Dugangi ang trabahoon alang sa mga kalalakin-an aron magkapuliki sila niini ug dili na maminaw sa malimbongong mga pulong.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Busa milakaw ang mga tinugyanan sa trabaho sa mga tawo ug ang mga tigdumala ug gipahibalo ang mga tawo. Miingon sila, “Mao kini ang giingon sa Faraon: 'Dili ko na kamo hatagan pa ug dagami. ");
INSERT INTO cebulb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kamo na mismo ang kinahanglan moadto ug mokuha sa dagami bisan asa ninyo kini mahikaplagan, apan dili pakunhoran ang inyong trabahoon.'” ");
INSERT INTO cebulb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Busa gilukop sa mga tawo ang tibuok yuta sa Ehipto aron sa pagtigom ug mga uhay alang sa dagami. ");
INSERT INTO cebulb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ginapadali sila kanunay sa mga tinugyanan sa trabaho ug nag-ingon, “Humana ang inyong trabaho, sama kaniadto sa dihang gihatagan pa kamo ug dagami.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Gipanglatos sa mga tinugyanan sa trabaho sa Faraon ang mga tigdumala sa mga Israelita, kadtong mga kalalakin-an nga ilang sinaligan sa mga trabahante. Kanunay silang ginapangutana sa mga tinugyanan sa trabaho, “Nganong wala man ninyo mahimo ang gidaghanon sa tanang tisa nga gipangayo kaninyo, kagahapon ug karong adlawa, sama sa inyong ginahimo kaniadto?” ");
INSERT INTO cebulb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Busa nangadto ang mga tigdumala sa mga Israelita ngadto sa Faraon ug nagmulo kaniya. Miingon sila, “Nganong ingon man niini ang imong pagtagad sa imong mga sulugoon? ");
INSERT INTO cebulb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wala nay ginahatag nga dagami sa imong mga sulugoon, apan nagasulti gihapon sila kanamo nga, 'Paghimo kamo ug mga tisa!' Kami, nga inyong mga sulugoon, gipanglatos na man gani, apan sayop kini sa imong kaugalingon nga katawhan” ");
INSERT INTO cebulb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Apan miingon ang Faraon, “Mga tapolan kamo! Mga tapolan kamo! Miingon kamo, 'Tugoti nga maghalad kami kang Yahweh.' ");
INSERT INTO cebulb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Busa karon balik sa trabaho. Wala nay dagami nga igahatag pa kaninyo, apan kinahanglan maghimo gihapon kamo ug sama nga gidaghanon sa mga tisa.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nakita sa mga tinugyanan sa trabaho sa mga Israelita nga anaa sila sa malisod nga kahimtang sa dihang gisultihan sila nga, “Kinahanglan nga dili ninyo pakunhoran ang gidaghanon sa mga tisa matag adlaw.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Samtang mibiya sila sa Faraon, natagboan nila si Moises ug si Aaron, nga nagbarog sa gawas sa palasyo. ");
INSERT INTO cebulb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Miingon sila kang Moises ug kang Aaron, “Hinaot nga tan-awon kamo ug silotan kamo ni Yahweh, tungod kay gihimo ninyo kami nga dulomtanan sa panan-aw sa Faraon ug sa iyang mga sulugoon. Gibutangan ninyo ug espada ang ilang kamot aron sa pagpatay kanamo.” ");
INSERT INTO cebulb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mibalik si Moises ngadto kang Yahweh ug miingon, “Ginoo, nganong gilisodlisod mo man kini nga katawhan? Nganong gipadala mo pa man ako? ");
INSERT INTO cebulb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sukad nga miadto ako ngadto sa Faraon aron makigsulti kaniya pinaagi sa imong ngalan, gilisodlisod hinuon niya kining mga tawhana, ug wala gihapon nimo gipalingkawas ang imong katawhan.” ");
INSERT INTO cebulb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Unya miingon si Yahweh kang Moises, “Karon imong makita ang akong himoon ngadto sa Faraon. Makita mo kini, kay tugotan niya sila sa paglakaw tungod sa kusgan nako nga kamot. Tungod sa kusgan nako nga kamot, papahawon niya sila gikan sa iyang yuta.” ");
INSERT INTO cebulb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nakigsulti ang Dios kang Moises ug miingon kaniya, “Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagpakita ako kang Abraham, kang Isaac, ug kang Jacob ingon nga labing Gamhanang Dios; apan sa akong ngalan nga, Yahweh, wala nila ako mailhi. ");
INSERT INTO cebulb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Gihimo ko usab ang akong kasabotan diha kanila, aron nga ihatag ngadto kanila ang yuta sa Canaan, ang yuta diin nagpuyo sila ingon nga mga dili lumolupyo, ang yuta diin sila naglatagaw. ");
INSERT INTO cebulb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Dugang pa niana, nadungog ko ang pag-agulo sa mga Israelita nga giulipon sa mga Ehiptohanon, ug nahinumdoman ko ang akong kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Busa, sultihi ang mga Israelita, 'Ako si Yahweh. Ipalingkawas ko kamo gikan sa pagkaulipon ilalom sa mga Ehiptohanon, ug ipalingkawas ko kamo gikan sa ilang gahom. Luwason ko kamo pinaagi sa pagpakita sa akong gahom, ug pinaagi sa gamhanang mga buhat sa paghukom. ");
INSERT INTO cebulb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Dad-on ko kamo nganhi kanako ingon nga akong katawhan, ug ako ang inyong Dios. Mahibaloan ninyo nga ako si Yahweh nga inyong Dios, nga nagpalingkawas kaninyo gikan sa pagkaulipon ilalom sa mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Dad-on ko kamo ngadto sa yuta nga akong gisaad nga ihatag kang Abraham, kang Isaac, ug kang Jacob. Ihatag ko kini kaninyo ingon nga panag-iyahan. Ako si Yahweh.'” ");
INSERT INTO cebulb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Sa dihang gisulti kini ni Moises ngadto sa mga Israelita, wala sila naminaw ngadto kaniya tungod kay nawad-an na sila ug paglaom tungod sa kapait sa ilang pagkaulipon. ");
INSERT INTO cebulb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Busa nakigsulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lakaw ug sultihi ang Faraon, nga hari sa Ehipto, nga tugotan ang katawhan sa Israel nga palakwon gikan sa iyang yuta.” ");
INSERT INTO cebulb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Miingon si Moises kang Yahweh, “Kung wala naminaw kanako ang katawhan sa Israel, nganong maminaw man ang Faraon kanako, sanglit dili man ako maayong manulti?” ");
INSERT INTO cebulb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nakigsulti si Yahweh kang Moises ug kang Aaron. Mihatag siya ug mando kanila alang sa mga Israelita ug alang sa Faraon, nga hari sa Ehipto, nga dad-on ang mga Israelita pagawas sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Mao kini ang mga pangulo sa mga panimalay sa ilang mga amahan: ang mga anak nga lalaki ni Reuben, ang kamagulangang anak ni Israel, nga mao sila si Hanok, Palu, Hezron, ug Karmi. Mao kini ang mga katigulangan sa banay ni Reuben. ");
INSERT INTO cebulb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ang mga anak nga lalaki ni Simeon mao sila si Jamin, Ohad, Jakin, Zohar, ug Saul—ang anak nga lalaki sa Canaanhon nga babaye. Mao kini ang banay sa mga katigulangan ni Simeon. ");
INSERT INTO cebulb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Mao kini ang nalista nga mga ngalan sa mga anak nga lalaki ni Levi, uban sa ilang mga kaliwat. Mao sila si Gershon, Kohat, ug Merari. Nabuhi si Levi hangtod nga 137 na ang iyang pangidaron. ");
INSERT INTO cebulb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ang mga anak nga lalaki ni Gershon mao sila si Libni ug Shimi. ");
INSERT INTO cebulb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ang mga anak nga lalaki ni Kohat mao sila si Amram, Izhar, Hebron, ug Uziel. Nabuhi si Kohat hangtod nga 133 na ang iyang pangidaron. ");
INSERT INTO cebulb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ang mga anak nga lalaki ni Merari mao sila si Mali ug Mushi. Mao kini ang mga katigulangan nga nahimong banay sa mga Levita, kauban sa ilang mga kaliwat. ");
INSERT INTO cebulb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Giminyoan ni Amram si Jokebed, ang igsoong babaye sa iyang amahan. Nanganak siya kang Moises ug kang Aaron. Nabuhi si Amram ug 137 ka tuig ug unya namatay. ");
INSERT INTO cebulb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ang mga anak nga lalaki ni Izhar mao sila si Kora, Nefeg, ug Zicri. ");
INSERT INTO cebulb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ang mga anak nga lalaki ni Uziel mao sila si Mishael, Elzafan, ug Sitri. ");
INSERT INTO cebulb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Gminyoan ni Aaron si Elisheba, nga anak nga babaye ni Aminadab, ang igsoong babaye ni Nashon. Nanganak siya kang Nadab ug kang Abihu, Eleazar ug Ithamar. ");
INSERT INTO cebulb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ang mga anak nga lalaki ni Kora mao sila si Asir, Elkana, ug Abiasaf. Mao kini ang mga katigulangan sa banay sa mga Korahitihanon. ");
INSERT INTO cebulb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleazar, nga anak nga lalaki ni Aaron, nakigminyo sa anak nga babaye ni Putiel. Nanganak siya kang Finehas. Mao kini ang mga pangulo sa mga panimalay sa mga amahan taliwala sa mga Levita, kauban sa ilang mga kaliwat. ");
INSERT INTO cebulb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Kining duha ka lalaki mao sila si Aaron ug si Moises nga giingnan ni Yahweh, “Pagawsa ang mga Israelita gikan sa yuta sa Ehipto, pinaagi sa ilang mga pundok sa mga kalalakin-an nga manggugubat.” ");
INSERT INTO cebulb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Nakigsulti si Aaron ug si Moises sa Faraon, nga hari sa Ehipto, nga tugotan sila sa pagdala sa mga Israelita pagawas sa Ehipto. Mao gihapon kini nga Moises ug Aaron. ");
INSERT INTO cebulb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Sa dihang nakigsulti si Yahweh kang Moises ngadto sa yuta sa Ehipto, ");
INSERT INTO cebulb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","miingon siya kaniya, “Ako si Yahweh. Isulti ngadto sa Faraon, nga hari sa Ehipto, ang tanan nga isulti ko kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Apan miingon si Moises kang Yahweh, “Dili ako maayong manulti, busa nganong maminaw man ang Faraon kanako?” ");
INSERT INTO cebulb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Miingon si Yahweh kang Moises, “Tan-awa, gihimo ko ikaw nga sama sa dios ngadto sa Faraon. Si Aaron nga imong igsoon nga lalaki mao ang mahimo nimong propeta. ");
INSERT INTO cebulb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Isulti mo ang tanan nga gimando ko kanimo nga isulti. Si Aaron nga imong igsoon nga lalaki mao ang mosulti ngadto sa Faraon aron nga tugotan niya ang katawhan sa Israel nga molakaw gikan sa iyang yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Apan patig-ahon ko ang kasingkasing sa Faraon, ug ipakita ko ang daghang mga timaan sa akong gahom, daghang kahibulongan, ngadto sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Apan dili maminaw ang Faraon kanimo, busa ibutang ko ang akong kamot sa Ehipto ug pagawson ang mga pundok sa akong manggugubat nga kalalakin-an, akong katawhan, ang mga kaliwat sa Israel, gikan sa yuta sa Ehipto pinaagi sa hilabihan nga silot. ");
INSERT INTO cebulb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mahibaloan sa mga Ehiptohanon nga ako si Yahweh sa dihang iisa ko ang akong kamot ngadto sa Ehipto ug pagawson ang mga Israelita gikan sa ilang taliwala.” ");
INSERT INTO cebulb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Busa gibuhat kini ni Moises ug Aaron; gibuhat gayod nila ang gimando ni Yahweh kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Nagpanuigon na si Moises ug 80, ug nagpanuigon si Aaron ug 83 sa dihang nakigsulti sila sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Miingon si Yahweh kang Moises ug kang Aaron, ");
INSERT INTO cebulb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Sa dihang mosulti ang Faraon kaninyo, 'Paghimo ug milagro,' unya sultihan mo si Aaron, 'Kuhaa ang imong sungkod ug ilabay kini sa atubangan sa Faraon, aron nga mahimo kining bitin.”' ");
INSERT INTO cebulb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Unya miadto si Moises ug Aaron sa Faraon, ug gibuhat nila kung unsa ang gimando ni Yahweh. Gilabay ni Aaron ang iyang sungkod sa atubangan sa Faraon ug sa iyang mga sulugoon, ug nahimo kining bitin. ");
INSERT INTO cebulb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Unya gipatawag usab sa Faraon ang iyang maalamon nga mga tawo ug ang mga salamangkero. Gibuhat nila ang samang butang pinaagi sa ilang salamangka. ");
INSERT INTO cebulb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Gilabay sa matag tawo ang iyang sungkod, ug nahimong bitin ang mga sungkod. Apan gilamoy sa sungkod ni Aaron ang ilang mga bitin. ");
INSERT INTO cebulb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Nagmagahi ang kasingkasing sa Faraon, ug wala siya naminaw, sama sa gisulti ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Miingon si Yahweh kang Moises, “Gahi ang kasingkasing sa Faraon, ug nagdumili siya sa pagpalakaw sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Adtoa ang Faraon panahon sa kabuntagon sa dihang moadto siya sa suba. Barog ngadto sa daplin sa suba aron sa pagpakigkita kaniya, ug dad-a ang imong sungkod nga nahimong bitin. ");
INSERT INTO cebulb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Isulti kaniya, 'si Yahweh, ang Dios sa mga Hebreohanon, nga maoy nagpadala kanako aron nga isulti kanimo, “Palakwa ang akong katawhan, aron nga mosimba sila kanako ngadto sa kamingawan. Hangtod karon wala gihapon ka naminaw.” ");
INSERT INTO cebulb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Miingon si Yahweh niini: “Pinaagi niini imong mahibaloan nga ako si Yahweh. Bunalan ko ang tubig sa Suba nga Nilo pinaagi sa sungkod nga ania sa akong kamot, ug mamahimong dugo ang suba. ");
INSERT INTO cebulb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mangamatay ang mga isda nga anaa sa suba, ug manimaho ang suba. Dili na makahimo sa pag-inom ang mga Ehiptohanon sa maong tubig nga gikan sa suba.\"”' ");
INSERT INTO cebulb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Unya miingon si Yahweh kang Moises, “Isulti kang Aaron, 'Kuhaa ang imong sungkod ug iisa pinaagi sa imong kamot ngadto sa ibabaw sa katubigan sa Ehipto, ug ngadto sa ilang kasubaan, sa mga sapa, sa mga kaligoanan, ug sa tanan nilang mga linaw, aron nga mahimong dugo ang ilang tubig. Buhata kini aron nga adunay dugo sa tibuok kayutaan sa Ehipto, bisan sa mga sudlanan nga kahoy ug bato.”' ");
INSERT INTO cebulb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Gibuhat ni Moises ug ni Aaron ang gimando ni Yahweh. Giisa ni Aaron ang sungkod ug gibunalan ang tubig sa suba, sa panan-aw sa Faraon ug sa iyang mga sulugoon. Nahimong dugo ang tanang tubig nga anaa sa suba. ");
INSERT INTO cebulb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nangamatay ang mga isda sa suba, ug nagsugod ug panimaho ang suba. Dili na makainom ug tubig ang mga Ehiptohanon nga gikan sa suba, ug mikuyanap ang dugo sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Apan gibuhat usab sa mga salamangkero sa Ehipto ang samang butang pinaagi sa ilang salamangka. Busa nagmagahi ang kasingkasing sa Faraon, ug nagdumili siya sa pagpaminaw kang Moises ug kang Aaron, sama sa gisulti ni Yahweh nga mahitabo. ");
INSERT INTO cebulb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Unya mitalikod ang Faraon ug mibalik sa iyang balay. Wala gani siya manumbaling niini. ");
INSERT INTO cebulb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nagkalot ang tanang Ehiptohanon palibot sa suba alang sa tubig nga mainom, apan dili nila mainom ang tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pito ka adlaw ang milabay human sa paghampak ni Yahweh sa suba. ");
INSERT INTO cebulb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Unya nakigsulti si Yahweh kang Moises, “Adtoa ang Faraon ug sultihi siya, 'Nag-ingon si Yahweh niini: “Palakwa ang akong katawhan aron nga makasimba sila kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kung modumili ka sa pagpalakaw kanila, silotan ko ang tanan ninyong nasod pinaagi sa mga baki. ");
INSERT INTO cebulb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Malukop ug mga baki ang suba. Motungha kini ug moadto sa imong balay, sa imong lawak, ug sa imong higdaanan. Moadto kini sa mga balay sa imong mga sulugoon. Moadto kini ngadto sa imong katawhan, ngadto sa imong mga pugon, ug ngadto sa imong panaksan nga masahanan. ");
INSERT INTO cebulb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Modugok ang mga baki kanimo, sa imong katawhan, ug sa tanan nimo nga mga sulugoon.”” ");
INSERT INTO cebulb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Miingon si Yahweh kang Moises, “Isulti kini kang Aaron, 'Iisa ang imong kamot ug ang imong sungkod ngadto sa mga suba, sa mga sapa, ug sa mga kaligoanan, ug manungha ang mga baki sa tibuok yuta sa Ehipto.'” ");
INSERT INTO cebulb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Giisa ni Aaron ang iyang kamot ngadto sa katubigan sa Ehipto, ug migula ang mga baki ug nalukop ang yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Apan gibuhat sa mga salamangkero ang samang butang pinaagi sa ilang salamangka: gidala nila ang mga baki ngadto sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Unya gipatawag sa Faraon si Moises ug si Aaron ug miingon, “Pag-ampo ngadto kang Yawheh aron nga kuhaon niya ang mga baki dinhi kanako ug sa akong katawhan. Unya palakwon ko ang katawhan, aron nga mohalad sila kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Miingon si Moises sa Faraon, “Aduna kay kahigayonan sa pagsulti nganhi kanako kung kanus-a ako kinahanglan nga mag-ampo alang kanimo, sa imong mga sulugoon, ug sa imong katawhan, aron nga hawaon ang mga baki diha kaninyo ug sa inyong mga balay ug magpabilin lamang didto sa suba.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Miingon ang Faraon, “Ugma.” Miingon si Moises, “Matuman ang imong giingon, aron nga mahibaloan nimo nga walay sama kang Yahweh, nga among Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mobiya ang mga baki diha kanimo, sa inyong mga balay, sa imong mga sulugoon, ug sa imong mga katawhan. Mopuyo lamang kini sa suba.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mibiya si Moises ug si Aaron sa Faraon. Unya mituaw si Moises ngadto kang Yahweh mahitungod sa mga baki nga iyang gipadala ngadto sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Gibuhat ni Yahweh ang gihangyo ni Moises: nangamatay ang mga baki ngadto sa mga balay, sa mga hawanan, ug sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gitapok kini sa mga tawo, ug nanimaho ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Apan sa dihang nakita sa Faraon nga adunay kahupayan, gipatig-a niya ang iyang kasingkasing ug wala naminaw kang Moises ug kang Aaron, sama sa giingon ni Yahweh nga iyang buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Miingon si Yahweh kang Moises, “Isulti kang Aaron, 'Iisa ang imong sungkod ug bunali ang abog sa yuta, aron nga mahimo kining tagnok sa tibuok yuta sa Ehipto.'” ");
INSERT INTO cebulb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Gibuhat nila kini: Giisa ni Aaron ang iyang kamot ug ang iyang sungkod. Gibunalan niya ang abog sa yuta. Miabot ang mga tagnok ngadto sa mga tawo ug sa mga mananap. Nahimong tagnok ang tanang abog sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Misulay pagbuhat ug mga tagnok ang mga salamangkero pinaagi sa ilang salamangka, apan dili sila makahimo. Adunay mga tagnok ngadto sa tawo ug sa mananap. ");
INSERT INTO cebulb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Unya miingon ang mga salamangkero ngadto sa Faraon, “Mao kini ang tudlo sa Dios.” Apan nagmagahi ang kasingkasing sa Faraon, busa nagdumili siya sa pagpaminaw ngadto kanila. Mao kini ang giingon ni Yahweh nga himoon sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Miingon si Yahweh kang Moises, “Pagsayo ug mata sa kabuntagon ug pagbarog sa atubangan sa Faraon, samtang moadto siya sa suba. Sultihi siya nga, 'Si Yahweh ang miingon niini: “Palakwa ang akong katawhan aron nga mosimba sila kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Apan kung dili nimo palakwon ang akong katawhan, magpadala ako ug panon sa mga langaw diha kanimo, sa imong mga sulugoon, ug sa imong katawhan, ug ngadto sa inyong mga balay. Mapuno ug panon sa mga langaw ang mga balay sa mga Ehiptohanon, ug bisan ang yuta nga ilang gibarogan mapuno sa mga langaw. ");
INSERT INTO cebulb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Apan niana nga adlaw ilikay ko ang yuta sa Goshen, ang yuta diin nagpuyo ang akong katawhan, aron nga walay panon sa mga langaw ang maanaa didto. Mahitabo kini aron nga mahibaloan nimo nga ako si Yahweh nga anaa sa taliwala niining yutaa. ");
INSERT INTO cebulb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Maghimo ako ug kalainan taliwala sa akong katawhan ug sa imong katawhan. Mahitabo kini nga timaan sa akong gahom ugma.\"”' ");
INSERT INTO cebulb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Gibuhat gayod kini ni Yahweh, ug miabot ang baga nga panon sa mga langaw ngadto sa balay sa Faraon ug ngadto sa balay sa iyang mga sulugoon. Nadaot ang yuta sa tibuok Ehipto tungod sa panon sa mga langaw. ");
INSERT INTO cebulb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Gipatawag sa Faraon si Moises ug si Aaron ug miingon, “Lakaw, paghalad sa inyong Dios nganhi sa among kaugalingon nga yuta.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Miingon si Moises, “Dili maayo alang kanamo nga himoon kini, kay dulumtanan alang sa mga Ehiptohanon ang paghalad nga among himoon ngadto kang Yahweh nga among Dios. Kung maghimo kami ug mga paghalad sa atubangan sa ilang mga mata nga dulumtanan alang sa mga Ehiptohanon, dili ba nila kami pagabatohon? ");
INSERT INTO cebulb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Dili, kinahanglan nga himoon namo ang pagpanaw sulod sa tulo ka adlaw, aron nga makahalad kang Yahweh nga among Dios, sumala sa gimando niya nganhi kanamo.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Miingon ang Faraon, Tugotan ko kamo nga molakaw ug mohalad kang Yahweh nga inyong Dios ngadto sa kamingawan. Apan kinahanglan nga dili kamo magpalayo ug maayo. Pag-ampo alang kanako.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Miingon si Moises, “Ug samtang mobiya ako gikan kanimo, mag-ampo ako kang Yahweh nga mobiya ugma ang panon sa mga langaw diha kanimo, Faraon, ug sa imong mga sulugoon ug sa imong katawhan. Apan kinahanglan nga dili ka mamakak sa dili pagtugot sa among katawhan sa pagpalakaw aron nga mohalad ngadto kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mibiya si Moises sa Faraon, ug miampo kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Gibuhat ni Yahweh ang gihangyo ni Moises: gikuha niya ang panon sa mga langaw gikan kang Faraon, sa iyang mga sulugoon, ug sa iyang katawhan. Wala gayoy nahibilin. ");
INSERT INTO cebulb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Apan nagmagahi na usab ang kasingkasing sa Faraon niining higayona, ug wala niya palakwa ang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Unya miingon si Yahweh kang Moises, “Adtoa ang Faraon ug sultihi siya, 'Si Yahweh, nga Dios sa mga Hebreo, miingon niini: “Palakwa ang akong katawhan aron nga mosimba sila kanako.” ");
INSERT INTO cebulb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Apan kung modumili ka sa pagpalakaw kanila, kung ipabilin gihapon nimo sila, ");
INSERT INTO cebulb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nan maanaa ang kamot ni Yahweh sa imong mga baka sa kaumahan ug sa mga kabayo, mga asno, mga kamelyo, mga panon sa baka, ug panon sa mga karnero, ug mao kini ang hinungdan sa makalilisang nga sakit. ");
INSERT INTO cebulb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lahi ang pagtagad ni Yahweh sa mga baka sa mga Israelita kaysa mga baka sa Ehiptohanon: Wala gayoy mananap nga gipanag-iya sa mga Israelita nga mangamatay. ");
INSERT INTO cebulb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Naghatag si Yahweh ug tukma nga panahon; miingon siya, “Ugma buhaton ko kini nga mga butang sa yuta.\"”' ");
INSERT INTO cebulb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Gibuhat kini ni Yahweh pagkasunod adlaw: namatay ang tanang mga baka sa Ehiptohanon. Apan wala gayoy mga mananap sa Israelita nga namatay. ");
INSERT INTO cebulb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nagsusi ang Faraon, ug tan-awa, wala gayoy bisan usa nga namatay sa mananap sa mga Israelita. Apan nagmagahi ang iyang kasingkasing, mao nga wala niya palakwa ang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Unya miingon si Yahweh kang Moises ug kang Aaron, “Pagkumkom ug mga abo nga gikan sa hudno. Moises, kinahanglan nga isabwag nimo ang abo ngadto sa kahanginan samtang motan-aw ang Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mahimo kining pino nga abog sa tibuok yuta sa Ehipto. Mahubagan ug magsakit ang katawhan ug ang mga mananap sa tibuok yuta sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Busa gikuha ni Moises ug Aaron ang abo sa hudno ug mitindog atubangan sa Faraon. Unya gisabwag ni Moises ang abo ngadto sa kahanginan. Gihubaghubagan ug nagsakit ang katawhan ug ang mga mananap tungod sa abo. ");
INSERT INTO cebulb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Dili makasukol ang mga salamangkero kang Moises tungod sa mga hubaghubag, tungod kay gihubaghubagan sila ug ang tanang mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Gipatig-a ni Yahweh ang kasingkasing sa Faraon, busa wala naminaw ang Faraon kang Moises ug kang Aaron. Mao kini ang giingon ni Yahweh kang Moises nga buhaton sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Unya miingon si Yahweh kang Moises, “Pagmata ug sayo sa kabuntagon, barog sa atubangan sa Faraon, ug isulti kaniya, 'Si Yahweh, ang Dios sa mga Hebreohanon, miingon niini: “Palakwa ang akong katawhan aron nga mosimba sila kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Niining higayona ipadala ko ang tanan nakong mga hampak nganha kanimo, sa imong mga sulugoon ug sa imong katawhan. Buhaton ko kini aron nga imong mahibaloan nga wala gayoy sama kanako sa tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sa pagkakaron mamahimo kong iisa ang akong kamot ug silotan ka pinaagi sa balatian ug ang imong katawhan, ug mapuo ka gikan sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Apan tungod niini nga hinungdan tugotan ko ikaw nga makalahutay: aron nga ipakita ko kanimo ang akong gahom, aron nga mamantala ang akong ngalan sa tibuok kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nagmapahitas-on ka gihapon batok sa akong katawhan pinaagi sa dili pagpalakaw kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Paminaw! Ugma sa samang takna magpadala ako ug hilabihan ka kusog nga ulan nga ice, nga wala pa nahitabo sa Ehipto sukad pa kaniadto hangtod karon. ");
INSERT INTO cebulb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nan karon, pagpadala ug kalalakin-an ug tigoma ang imong mga baka ug ang tanan nga anaa sa imong kaumahan didto sa luwas nga dapit. Ang matag tawo ug mga mananap nga anaa sa kaumahan nga wala madala sa panimalay—maulanan sila ug mga ice, ug mangamatay sila.\"”' ");
INSERT INTO cebulb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Busa nagdali ang mga sulugoon sa Faraon nga mituo sa mensahe ni Yahweh sa pagdala sa ilang mga ulipon ug mga baka ngadto sa mga balay. ");
INSERT INTO cebulb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Apan kadtong wala gayod mituo sa mensahe ni Yahweh gibilin lamang ang ilang mga ulipon ug mga baka didto sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Unya miingon si Yahweh kang Moises, “Iisa ang imong kamot ngadto sa kawanangan aron maulanan ug ice ang tibuok yuta sa Ehipto, sa katawhan, sa mga mananap, ug sa tanan nga mga tanom sa kaumahan sa tibuok yuta sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Unya giisa ni Moises ang iyang sungkod ngadto sa kawanangan, ug nagpadala si Yahweh ug dalugdog, ulan nga ice, ug kilat sa kayutaan. Nagpaulan usab siya ug ice sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Busa nag-ulan ug ice ug kilat nga nasagolan ug ulan nga ice, nga hilabihan gayod, wala pa gayoy nahitabo nga sama niini sa tibuok yuta sa Ehipto sukad nga nahimo kini nga nasod. ");
INSERT INTO cebulb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Gidaot sa ulan nga ice ang tanan nga anaa sa kaumahan sa tibuok yuta sa Ehipto, lakip na ang katawhan ug ang mga mananap. Nangadaot ang matag tanom nga anaa sa kaumahan ug nangabali ang matag kahoy. ");
INSERT INTO cebulb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ang yuta lamang sa Goshen, diin namuyo ang mga Israelita ang wala naulanan ug ice. ");
INSERT INTO cebulb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Unya nagpadala ang Faraon ug kalalakin-an aron ipatawag si Moises ug si Aaron. Miingon siya kanila, “Nakasala ako niining higayona. Matarong si Yahweh, ug daotan ako ug ang akong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pag-ampo kang Yahweh, tungod kay hilabihan ka kusog ang dalugdog ug ang ulan nga ice. Palakwon ko na kamo, ug dili na gayod kamo magpuyo pa dinhi.” ");
INSERT INTO cebulb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Miingon si Moises kaniya, “Sa dihang mobiya ako sa siyudad, iisa ko ang akong mga kamot ngadto kang Yahweh. Mohunong ang dalugdog, ug moundang na gayod ang pag-ulan ug ice. Niini nga paagi imong mahibaloan nga si Yahweh ang nanag-iya sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Apan alang kanimo ug sa imong mga sulugoon, nasayod ako nga wala pa gayod kamo nagpasidungog kang Yahweh nga Dios.” ");
INSERT INTO cebulb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Karon nangadaot na ang lino ug ang sebada, kay hapit na mahinog ang sebada, ug namulak na ang lino. ");
INSERT INTO cebulb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Apan wala madaot ang trigo ug ang ubang matang sa trigo tungod kay ulahi man kining namunga. ");
INSERT INTO cebulb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Sa dihang mibiya si Moises sa Faraon ug sa siyudad, giisa ni Moises ang iyang mga kamot ngadto kang Yahweh; wala na gayod midalugdog ug mihunong na ang ulan nga ice, ug wala na miulan. ");
INSERT INTO cebulb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Sa dihang nakita sa Faraon nga miundang na ang ulan, ulan nga ice, ug ang dalugdog, nagpakasala na usab siya ug gipatig-a ang iyang kasingkasing, kauban sa iyang mga sulugoon. ");
INSERT INTO cebulb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Gipatig-a ang kasingkasing sa Faraon, busa wala niya palakwa ang katawhan sa Israel. Mao kini ang paagi nga gisulti ni Yahweh kang Moises nga buhaton sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Miingon si Yahweh kang Moises, “Adto sa Faraon, kay gipatig-a ko ang iyang kasingkasing ug ang mga kasingkasing sa iyang mga sulugoon. Gibuhat ko kini aron ipakita kining mga timaan sa akong gahom ngadto kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Gibuhat ko usab kini aron nga isulti ninyo sa inyong mga anak ug mga apo ang mga butang nga akong gibuhat, kung unsa kabangis ang akong pagtagad sa Ehipto, ug kung giunsa nako pagpakita sa nagkalainlaing mga timaan sa akong gahom ngadto kanila. Niini nga paagi masayran ninyo nga ako si Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Busa miadto si Moises ug si Aaron ngadto sa Faraon ug mingon kaniya, “Si Yahweh, nga Dios sa mga Hebreohanon, miingon niini: 'Hangtod kanus-a ka man magdumili sa pagpaubos sa imong kaugalingon nganhi kanako? Palakwa ang akong katawhan aron nga makasimba sila kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Apan kung modumili ka sa pagpalakaw sa akong katawhan, paminaw, ugma pagadad-an ko ug mga dulon ang imong yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Lukpon niini ang tibuok bahin sa yuta aron nga wala nay makakita niini. Kan-on niini ang tanang mga nahibilin nga wala madaot sa ulan nga ice. Pagakan-on usab niini ang matag kahoy nga mitubo alang kaninyo didto sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Pun-on niini ang inyong mga panimalay, sa tanan ninyong mga sulugoon, ug sa tanang mga Ehiptohanon—butang nga wala pa gayod makita sa inyong amahan ni sa inyong apohan, butang nga wala pa gayod makita sukad sa adlaw nga miabot sila sa kalibotan hangtod niining adlawa.” Unya mibiya si Moises gikan sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Miingon ang mga sulugoon sa Faraon kaniya, “Hangtod kanus-a man kita samokon niining tawhana? Palakwa na ang mga Israelita aron nga makasimba sila kang Yahweh nga ilang Dios. Wala ka pa ba makaamgo nga naguba na ang Ehipto?” ");
INSERT INTO cebulb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Gidala na usab si Moises ug si Aaron ngadto sa Faraon, nga miingon kanila, “Lakaw ug simbaha si Yahweh nga inyong Dios. Apan kinsa man nga katawhan ang molakaw?” ");
INSERT INTO cebulb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Miingon si Moises, “Manlakaw kami uban ang among mga kabataan ug katigulangan, uban sa among mga anak nga lalaki ug babaye. Molakaw kami uban sa mga panon sa among mga karnero ug baka, kay kinahanglan kami magpahigayon ug kasaulogan alang kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Miingon ang Faraon kanila, “Hinaot pa nga ubanan gayod kamo ni Yahweh, kung palakwon ko kamo uban sa inyong mga kabataan. Paminaw, aduna kamoy daotan nga panghunahuna. ");
INSERT INTO cebulb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Dili! Lakaw, kuyog lamang sa inyong mga kalalakin-an, ug simbaha si Yahweh, kay mao man kana ang inyong buot buhaton.” Unya gipapahawa si Moises ug si Aaron sa atubangan sa Faraon. ");
INSERT INTO cebulb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Unya miingon si Yahweh kang Moises, “Iisa ang imong kamot ibabaw sa yuta sa Ehipto ngadto sa mga dulon, aron nga modagsang sila sa yuta sa Ehipto ug kan-on ang matag tanom niini, tanan nga nahibilin nga wala madaot sa ulan nga ice.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Giisa ni Moises ang iyang sungkod ibabaw sa yuta sa Ehipto, ug gipadala ni Yahweh ang hangin nga gikan sa sidlakan diha sa yuta sa tibuok adlaw ug gabii. Pagkabuntag, nagdala ug mga dulon ang hangin nga gikan sa sidlakan. ");
INSERT INTO cebulb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Misulod ang mga dulon sa tibuok yuta sa Ehipto ug gilukop ang tanang bahin niini. Wala pa gayoy miabot sa yuta nga sama niini nga panon sa mga dulon, ug wala na gayoy sama niini nga moabot human niini. ");
INSERT INTO cebulb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Gilukop niini ang tibuok yuta busa mingitngit kini. Gikaon nila ang matag tanom sa yuta ug ang tanang mga bunga sa mga kahoy nga wala madaot sa ulan nga ice. Wala na gayoy lunhaw nga tanom ni kahoy o tanom sa mga kaumahan ang nahibilin sa tibuok yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Unya dalidali dayon nga gipatawag sa Faraon si Moises ug si Aaron ug miingon, “Nakasala ako batok kang Yahweh nga inyong Dios ug batok kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Busa karon, pasayloa ang akong sala, ug pag-ampo kang Yahweh nga inyong Dios nga iyang kuhaon kining kamatayon palayo kanako.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Busa mibiya si Moises sa Faraon ug miampo kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nagpadala ug hilabihan ka kusog nga hangin gikan sa kasadpan si Yahweh nga nagpahawa sa mga dulon ug nagpalid niini ngadto sa Dagat nga Kabugangan; walay bisan usa nga dulon ang nahibilin sa tibuok ginsakopan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Apan gipatig-a ni Yahweh ang kasingkasing sa Faraon, ug wala niya tugoti nga molakaw ang mga Israelita. ");
INSERT INTO cebulb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Unya miingon si Yahweh kang Moises, “Iisa ang imong kamot ngadto sa kawanangan, aron nga moabot ang kangitngit ibabaw sa yuta sa Ehipto, kangitngit nga mabati gayod.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Giisa ni Moises ang iyang kamot ngadto sa kawanangan, ug miabot ang baga nga kangitngit sa tibuok yuta sa Ehipto sulod sa tulo ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wala gayoy tawo nga makakita kang bisan kinsa; walay migawas sa iyang panimalay sulod sa tulo ka adlaw. Apan, adunay kahayag sa dapit nga gipuy-an sa mga Israelita. ");
INSERT INTO cebulb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Gipatawag sa Faraon si Moises ug miingon, “Lakaw ug simbaha si Yahweh. Makauban na kanimo bisan ang imong mga pamilya, apan kinahanglan ninyong ibilin ang mga panon sa inyong mga karnero ug mga baka.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Apan miingon si Moises, “Kinahanglan nga ihatag mo usab kanamo ang mga mananap alang sa mga paghalad ug mga halad nga sinunog aron nga mahalad namo kini ngadto kang Yahweh nga among Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kinahanglan nga mouban usab kanamo ang among mga baka; walay bisan tunob niini ang ibilin, tungod kay kinahanglan namo kining dad-on alang sa pagsimba kang Yahweh nga among Dios. Tungod kay wala man kami masayod kung unsa ang among gikinahanglan sa pagsimba kang Yahweh hangtod nga moabot na kami didto.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Apan gipatig-a ni Yahweh ang kasingkasing sa Faraon, ug dili niya sila palakwon. ");
INSERT INTO cebulb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Miingon ang Faraon kang Moises, “Palayo kanako! Pagbantay niining usa ka butang, nga dili ko na ikaw makita pag-usab, kay sa adlaw nga imong makita ang akong panagway, mamatay ka.” ");
INSERT INTO cebulb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Miingon si Moises, “Gipamulong mo na. Dili ko na makita pag-usab ang imong panagway.” ");
INSERT INTO cebulb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Unya miingon si Yahweh kang Moises, “Aduna pay usa ka hampak nga akong ipadala sa Faraon ug sa Ehipto. Human niana, tugotan na niya kamo sa pagbiya dinhi. Kung palakwon na gayod niya kamo, pahawaon niya kamo sa hingpit. ");
INSERT INTO cebulb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sultihi ang katawhan nga ang matag lalaki ug babaye kinahanglan mangayo ug mga alahas nga plata ug bulawan sa iyang silingan.” ");
INSERT INTO cebulb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Karon gihimo ni Yahweh nga magpahimuot ang mga Ehiptohanon sa mga Israelita. Dugang pa niana, nakapahimuot gayod ang tawo nga si Moises sa panan-aw sa mga sulugoon sa Faraon ug sa katawhan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Miingon si Moises, “Miingon si Yahweh niini: 'Inigka-tungang gabii moanha ako sa tibuok Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mangamatay ang tanang kamagulangan nga anak sa yuta sa Ehipto, gikan sa kamagulangan nga anak sa Faraon, nga naglingkod sa iyang trono, ngadto sa kamagulangan nga anak sa ulipong babaye nga anaa sa luyo sa galingan nga nagagaling, ug ngadto sa tanang unang anak sa mga baka. ");
INSERT INTO cebulb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Unya adunay hilabihan nga pagdangoyngoy sa tibuok yuta sa Ehipto, walay sama niini nga nahitabo kaniadto ni sa umaabot. ");
INSERT INTO cebulb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Apan bisan ang iro dili mousig batok sa katawhan sa Israel, batok sa tawo o mananap. Niini nga paagi masayran ninyo nga lahi ang akong tinagdan sa mga Ehiptohanon kaysa sa mga Israelita.' ");
INSERT INTO cebulb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Kining tanan nga imong mga sulugoon, Faraon, moduol ug moyukbo kanako. Moingon sila, 'Lakaw, ikaw ug ang tanang katawhan nga nagsunod kanimo!' Human niana molakaw ako.” Ug mibiya siya sa Faraon nga hilabihan ang kasuko. ");
INSERT INTO cebulb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Miingon si Yahweh kang Moises, “Dili maminaw ang Faraon kanimo. Mahitabo kini aron nga makabuhat ako ug daghang katingalahan nga mga butang sa yuta sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Gibuhat ni Moises ug ni Aaron kining tanan nga mga kahibulongan sa atubangan sa Faraon. Apan gipatig-a ni Yahweh ang kasingkasing sa Faraon, ug wala tugoti sa Faraon ang katawhan sa Israel nga mogawas sa iyang yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nakigsulti si Yahweh kang Moises ug kang Aaron sa yuta sa Ehipto. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Alang kaninyo, kini nga bulan ang sugod sa mga bulan, ang unang bulan sa tuig alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sultihi ang pundok sa Israel, 'Sa ikanapulo nga adlaw niini nga bulan kinahanglan nga magkuha sila ug mga nating karnero o nating kanding alang sa ilang mga kaugalingon, ang matag pamilya magabuhat niini, usa ka nating karnero alang sa matag panimalay. ");
INSERT INTO cebulb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kung sobra lamang alang sa panimalay ang usa ka nating karnero, mahimong moambit ang tawo ug ang iyang silingan sa karne sa nating karnero o nating kanding nga paigo sa gidaghanon sa mga tawo sa ilang panimalay. Kinahanglan nga paigo lamang kini nga pagkaon alang sa matag-usa, busa kinahanglan nga mokuha sila ug igong karne nga makaon nilang tanan. ");
INSERT INTO cebulb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kinahanglan nga walay tatsa ang inyong nating karnero ug nating kanding, laki nga usa pa katuig. Mahimo kamong mokuha ug usa sa mga karnero o mga kanding. ");
INSERT INTO cebulb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kinahanglan nga tipigan ninyo kini hangtod sa ika napulo ug upat nga adlaw niana nga bulan. Unya kinahanglan nga patyon sa tibuok pundok sa mga Israelita ang mga mananap inig kilumkilom na. ");
INSERT INTO cebulb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kinahanglan nga magkuha kamo ug dugo niini ug ibutang kini sa duha ka bahin sa mga haligi sa pultahan ug sa ibabaw nga bahin sa pultahan sa mga balay diin kamo magakaon sa karne. ");
INSERT INTO cebulb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Kinahanglan kaonon ninyo ang karne nianang gabhiona, human kini masugba. Kaona kini uban sa tinapay nga walay igpapatubo, uban sa mga pait nga tanom. ");
INSERT INTO cebulb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ayaw kini kaona nga hilaw o sinabawan. Hinuon, sugbaha kini, uban ang mga paa ug ang mga sulod nga bahin niini. ");
INSERT INTO cebulb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kinahanglan nga dili ka magsalin niini hangtod sa kabuntagon. Kinahanglan nimong sunogon ang mga salin pagkabuntag. ");
INSERT INTO cebulb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mao kini ang pamaagi nga inyo kining kaonon: kinahanglan nga nakabakos kamo, nakasapatos, ug ang sungkod anaa sa inyong kamot. Kinahanglan dalion ninyo kini ug kaon. Mao kini ang Pagsaylo ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Mao kini ang giingon ni Yahweh: moadto ako sa yuta sa Ehipto nianang gabhiona ug patyon ang tanang kamagulangan nga anak sa tawo ug mananap sa yuta sa Ehipto. Pagasilotan ko ang tanang mga dios sa Ehipto. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ang dugo ang mahimong timaan sa inyong mga balay sa akong pag-anha diha kaninyo. Sa dihang makita ko ang dugo, mosaylo ako kaninyo sa dihang sulongon ko ang yuta sa Ehipto. Kini nga hampak dili moabot kaninyo ug magalaglag kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Kini nga adlaw mahimong adlaw nga handomanan alang kaninyo, nga kinahanglan ninyong saulogon ingon nga kasaulogan alang kang Yahweh. Magpabilin kini nga balaod alang kaninyo, sa tanang kaliwatan sa inyong katawhan, nga kinahanglan ninyong saulogon karong adlawa. ");
INSERT INTO cebulb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Magakaon kamo ug tinapay nga walay igpapatubo sulod sa pito ka adlaw. Sa unang adlaw kinahanglan nga wagtangon ninyo ang mga igpapatubo sa inyong mga balay. Si bisan kinsa man nga mokaon ug tinapay nga adunay igpapatubo gikan sa unang adlaw hangtod sa ikapito nga adlaw, kinahanglan nga pahawaon kanang tawhana gikan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sa unang adlaw adunay panagtigom nga igahin alang kanako, ug sa ikapito nga adlaw aduna na usab panagtigom nga sama niini. Walay trabaho nga buhaton niini nga mga adlaw, gawas lamang sa pagluto aron kaonon sa tanan. Mao lamang kana nga trabaho ang mamahimo ninyong buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kinahanglan saulogon ninyo kini nga Kasaulogan sa Tinapay nga Walay Igpapatubo tungod kay mao kini ang adlaw nga gipagawas ko ang imong katawhan, ang matag pundok sa kasundalohan, pagawas sa yuta sa Ehipto. Busa kinahanglan nga saulogon ninyo kini nga adlaw sa tibuok kaliwatan sa inyong katawhan. Magpabilin kini nga balaod alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kinahanglan nga mokaon kamo sa tinapay nga walay igpapatubo gikan sa kilumkilom sa ikanapulo ug upat nga adlaw sa unang bulan sa tuig, hangtod sa kilumkilom sa ika 21 nga adlaw nianang bulana. ");
INSERT INTO cebulb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sulod niining pito ka adlaw, kinahanglan nga walay igpapatubo nga makita sa inyong mga balay. Si bisan kinsa nga mokaon ug tinapay nga adunay igpapatubo kinahanglan nga papahawaon gikan sa katilingban sa Israel, bisan ug langyaw kanang tawhana o tawo nga nahimugso sa inyong yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kinahanglan nga dili kamo mokaon ug bisan unsa nga adunay igpapatubo. Bisan asa kamo magpuyo, kinahanglan nga mokaon kamo ug tinapay nga walay igpapatubo.'” ");
INSERT INTO cebulb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Unya gipatawag ni Moises ang tanang mga kadagkoan sa Israel ug miingon kanila, “Lakaw ug pagpili ug mga nating karnero o mga nating kanding nga igong pagkaon sa inyong mga pamilya ug ihawa ang nating karnero sa Pagsaylo. ");
INSERT INTO cebulb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Unya pagkuha ug pungpung sa hisopo ug ituslob kini sa dugo nga anaa sa dako nga panaksan. Ipahid ang dugo nga anaa sa dako nga panaksan ngadto sa ibabaw nga bahin sa pultahan ug ngadto sa duha ka haligi niini. Walay bisan usa kaninyo nga mogawas sa pultahan sa iyang balay hangtod sa kabuntagon. ");
INSERT INTO cebulb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tungod kay molabay si Yahweh aron patyon ang mga Ehiptohanon. Sa dihang makita niya ang dugo sa ibabaw nga bahin sa inyong pultahan ug sa duha ka mga haligi niini, saylohan lamang niya ang inyong pultahan ug dili niya tugotan ang mamumuo sa pagsulod sa inyong mga balay aron sa pagpatay kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kinahanglan nga saulogon ninyo kini nga panghitabo. Magpabilin kini nga balaod alang kaninyo ug sa inyong mga kaliwat. ");
INSERT INTO cebulb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Sa dihang mosulod kamo sa yuta nga ihatag ni Yahweh kaninyo, sumala sa iyang gisaad nga buhaton, kinahanglan nga saulogon ninyo kini nga buhat sa pagsimba. ");
INSERT INTO cebulb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kung pangutan-on kamo sa inyong mga anak, 'Unsa man ang buot ipasabot niini nga pagsimba?' ");
INSERT INTO cebulb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","nan kinahanglan nga mosulti kamo, 'Mao kini ang halad sa Pagsaylo ni Yahweh, tungod kay gisaylohan man ni Yahweh ang balay sa mga Israelita didto sa Ehipto sa dihang gipamatay niya ang mga Ehiptohanon. Gipalingkawas niya ang atong mga panimalay.”' Unya nangyukbo ang katawhan ug misimba kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Nanglakaw ang mga Israelita ug gibuhat gayod ang gimando ni Yahweh ngadto kang Moises ug kang Aaron. ");
INSERT INTO cebulb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nahitabo kini sa tungatunga sa kagabhion nga gipamatay ni Yahweh ang tanang kamagulangang anak didto sa yuta sa Ehipto, gikan sa kamagulangang anak sa Faraon, nga naglingkod sa iyang trono, ngadto sa kamagulangan nga anak sa tawo nga anaa sa bilanggoan ug sa tanang unang anak sa mga baka. ");
INSERT INTO cebulb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mibangon ang Faraon pagkagabii—siya, ang tanan niyang nga sulugoon, ug ang tanang mga Ehiptohanon. Adunay hilabihan nga pagbangotan sa Ehipto, tungod kay wala gayoy balay nga walay tawong patay. ");
INSERT INTO cebulb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Gipatawag sa Faraon si Moises ug si Aaron nianang gabhiona ug miingon, “Bangon, panghawa kamo gikan sa akong katawhan, kamo ug ang mga Israelita. Lakaw, simbaha si Yahweh, sumala sa inyong giingon nga buot ninyong buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Dad-a ang tanang panon sa inyong mga karnero ug panon sa inyong mga baka, sama sa inyong giingon, ug lakaw, ug panalangini usab ako.” ");
INSERT INTO cebulb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Nagdalidali gayod ang mga Ehiptohanon sa pagpagawas kanila sa ilang yuta, kay miingon sila, “Mga patay na kaming tanan.” ");
INSERT INTO cebulb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Busa gikuha sa mga tawo ang ilang minasa nga harina nga wala gisagolan ug igpapatubo. Nakabalot na sa ilang mga bisti ug gibitay na sa ilang mga abaga ang ilang mga panaksan nga masahanan sa harina. ");
INSERT INTO cebulb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Karon gibuhat sa katawhan sa Israel ang gisulti ni Moises kanila. Nangayo sila ug mga alahas nga mga plata ug bulawan, ug mga bisti ngadto sa mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Gihimo ni Yahweh nga madasigong magpahimuot ang mga Ehiptohanon ngadto sa mga Israelita. Busa gihatag sa mga Ehiptohanon ang bisan unsa nga ilang gipangayo. Niini nga paagi, giilogan sa mga Israelita ang mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nagpanaw ang mga Israelita gikan sa Rameses padulong sa Sucot. Mikabat sa 600, 000 ka mga kalalakin-an ang nagbaktas, dugang pa ang mga kababayen-an ug mga kabataan. ");
INSERT INTO cebulb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nanguban usab kanila ang nagkasinagol nga pundok sa dili mga Israelita, uban sa mga panon sa karnero, ug dakong panon sa mga baka. ");
INSERT INTO cebulb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nagluto sila ug tinapay nga walay igpapatubo sa minasa nga harina nga gidala nila gikan sa Ehipto. Wala kini igpapatubo tungod kay gipagawas man sila sa Ehipto ug dili na angay maglangan sa pag-andam ug pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Namuyo ang mga Israelita sa Ehipto sulod sa 430 ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Human sa 430 katuig, niana gayod nga adlaw, mibiya sa yuta sa Ehipto ang tanang pundok sa kasundalohan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mao kini ang gabii sa pagtukaw, kay dad-on sila ni Yahweh pagawas sa yuta sa Ehipto. Mao kini ang gabii nga kinahanglan hinumdoman sa tanang mga Israelita alang kang Yahweh sa tibuok nilang mga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Miingon si Yahweh kang Moises ug Aaron, “Mao kini ang balaod alang sa Pagsaylo: walay langyaw ang makaambit sa pagkaon niini. ");
INSERT INTO cebulb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Apan mamahimong mokaon niini ang matag sulugoon sa mga Israelita, nga gipalit pinaagi sa salapi, human ninyo siya tulia. ");
INSERT INTO cebulb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Dili angay mokaon sa bisan unsa niini nga pagkaon ang mga langyaw ug ang mga sulugoon nga sinuholan. ");
INSERT INTO cebulb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Kinahanglan nga kaonon ang pagkaon sa usa lamang ka balay. Dili kamo angay nga magdala ug karne sa gawas sa balay, ug kinahanglan nga dili ninyo balion ang bisan usa ka bukog niini. ");
INSERT INTO cebulb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kinahanglan nga saulogon kini nga kasaulogan sa tibuok katilingban sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kung adunay langyaw nga nagpuyo uban kaninyo ug buot nga mosaulog sa Pagsaylo ni Yahweh, kinahanglan nga magpatuli ang tanan niyang paryente nga lalaki. Unya makahimo na siya sa pag-anha ug pagsaulog niini. Mahisama siya sa mga tawo nga gipanganak niini nga yuta. Apan, walay tawo nga dili tinuli ang makakaon sa bisan unsa nga pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Mao usab kini ang balaod alang sa mga natawo niining yutaa ug sa mga langyaw nga namuyo uban kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Busa gibuhat sa tanang mga Israelita ang gimando ni Yahweh kang Moises ug kang Aaron. ");
INSERT INTO cebulb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Nahitabo gayod nianang adlawa nga gipagawas ni Yahweh ang Israel gikan sa yuta sa Ehipto uban sa matag pundok sa ilang kasundalohan. ");
INSERT INTO cebulb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nakigsulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Igahin kanako ang tanang kamagulangang anak, ang matag kamagulangang anak nga lalaki sa mga Israelita, mga tawo man o mga mananap. Nahisakop kanako ang kamagulangan nga anak.” ");
INSERT INTO cebulb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Miingon si Moises ngadto sa katawhan, “Hinumdomi ninyo kining adlawa, ang adlaw nga nakagawas kamo sa Ehipto, gawas sa balay sa pagkaulipon, kay pinaagi sa gamhanang kamot ni Yahweh gidala niya kamo pagawas niini nga dapit. Walay tinapay nga adunay igpapatubo ang pagakan-on. ");
INSERT INTO cebulb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Mobiya kamo sa Ehipto karong adlawa, sa bulan sa Abib. ");
INSERT INTO cebulb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Sa dihang dad-on kamo ni Yahweh ngadto sa yuta sa mga Canaanhon, Hitihanon, Amorihanon, Hibitihanon, ug sa Jebusihanon, ang yuta nga iyang gisaad sa inyong mga katigulangan nga ihatag kaninyo, ang yuta nga nagadagayday sa gatas ug dugos—unya kinahanglan nga saulogon ninyo kini nga buhat sa pagsimba karong bulana. ");
INSERT INTO cebulb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sulod sa pito ka adlaw tinapay nga walay igpapatubo lamang ang angay ninyong kaonon; sa ikapito nga adlaw magpahigayon kamo ug kasaulogan aron sa pagpasidungog kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tinapay nga walay igpapatubo ang kinahanglan nga kaonon sulod sa pito ka adlaw; kinahanglan nga walay makita nga tinapay nga adunay igpapatubo diha kaninyo. Kinahanglan nga walay igpapatubo nga makaplagan diha kaninyo o bisan asa sa inyong mga utlanan. ");
INSERT INTO cebulb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Nianang adlawa kinahanglan sultihan ninyo ang inyong mga anak, 'Tungod kini sa gibuhat ni Yahweh kanako sa dihang migawas ako sa Ehipto.' ");
INSERT INTO cebulb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mahimo kining pahinumdom kaninyo sa inyong kamot, ug pahinumdom sa inyong agtang. Aron nga maanaa sa inyong baba ang balaod ni Yahweh, kay pinaagi sa gamhanang kamot, gipagawas kamo ni Yahweh gikan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Busa kinahanglan nga tumanon ninyo kini nga balaod sa gitakdang panahon niini sa matag tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Sa dihang dad-on kamo ni Yahweh ngadto sa yuta sa mga Canaanhon, sama sa iyang gisaad kaninyo ug sa inyong mga katigulangan nga pagabuhaton, ug sa dihang ihatag niya ang yuta diha kaninyo, ");
INSERT INTO cebulb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kinahanglan nga inyong igahin alang kaniya ang matag kamagulangan nga anak ug ang unang anak sa inyong mga mananap. Ang mga lalaki iya kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kinahanglan nga paliton ninyo ug balik ang matag unang anak sa asno pinaagi sa nating karnero. Kung dili ninyo kini paliton pagbalik, kinahanglan nga balion ninyo ang liog niini. Apan kinahanglan ninyo paliton pagbalik ang matag kamagulangan nga anak nga lalaki sa tanan nimong mga anak. ");
INSERT INTO cebulb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kung mangutana unya ang inyong anak nga lalaki, 'Unsa man ang buot ipasabot niini? nan kinahanglan sultihan ninyo siya, 'Pinaagi sa gamhanang kamot gipagawas kita ni Yahweh gikan sa Ehipto, gikan sa balay sa pagkaulipon. ");
INSERT INTO cebulb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Sa dihang nagdumili ang Faraon sa pagpalakaw kanato, gipatay ni Yahweh ang tanang mga kamagulangan nga anak sa yuta sa Ehipto, ang kamagulangan nga anak sa katawhan ug sa mga mananap. Maoy hinungdan nga akong gihalad kang Yahweh ang unang anak nga lalaki sa matag mananap, ug maong gipalit ko ug balik ang kamagulangan sa akong mga anak nga lalaki.' ");
INSERT INTO cebulb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mahimo kining usa ka pahinumdom sa imong mga kamot, ug pahinumdom sa imong agtang, kay pinaagi sa gamhanang kamot ni Yahweh gidala niya kita pagawas sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sa dihang gitugotan sa Faraon ang katawhan sa paglakaw, wala sila gigiyahan sa Dios sa dalan nga paingon sa yuta sa mga Filistihanon, bisan tuod ug duol lamang kadto nga yuta. Kay miingon ang Dios, “Basin ug mausab ang hunahuna sa katawhan kung makasinati sila sa gubat ug mamalik sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Busa gigiyahan sila sa Dios paingon sa kamingawan ngadto sa Dagat nga Kabugangan. Milakaw ang mga Israelita paggawas sa Ehipto nga sangkap sa hinagiban alang sa pagpakiggubat. ");
INSERT INTO cebulb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Gidala ni Moises ang mga bukog ni Jose uban kaniya, kay tinud-anay man nga gipasaad ni Jose ang mga Israelita ug miingon, “Pagaluwason gayod kamo sa Dios, ug kinahanglan nga dad-on ninyo ang akong mga bukog uban kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Mipanaw ang mga Israelita gikan sa Sucot ug nagkampo sa Etam sa tumoy sa kamingawan. ");
INSERT INTO cebulb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Panahon sa adlaw, nag-una si Yahweh kanila pinaagi sa daw haligi nga panganod aron sa paggiya kanila sa dalan. Panahon sa kagabhion nag-uban siya kanila pinaagi sa daw haligi nga kalayo aron maghatag kanila ug kahayag. Niini nga paagi makapanaw sila panahon sa adlaw ug panahon sa gabii. ");
INSERT INTO cebulb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Wala gikuha ni Yahweh diha sa katawhan ang daw haligi nga panganod panahon sa adlaw o ang daw haligi nga kalayo panahon sa kagabhion. ");
INSERT INTO cebulb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nakigsulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Sultihi ang mga Israelita nga kinahanglan nga mamalik sila ug magkampo duol sa Pi Hahirot, tungatunga sa Migdol ug sa dagat, duol sa Baal Zefon. Magkampo kamo didto daplin sa dagat likod sa Pi Hahirot. ");
INSERT INTO cebulb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Magsulti ang Faraon mahitungod sa mga Israelita, ''Maglatagaw sila sa yuta. Dili sila makagawas sa kamingawan.' ");
INSERT INTO cebulb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Patig-ahon ko ang kasingkasing sa Faraon, ug gukdon niya sila. Mapasidunggan ako tungod sa Faraon ug sa iyang mga kasundalohan. Masayod ang mga Ehiptohanon nga ako si Yahweh.” Busa nagkampo ang mga Israelita sumala sa gisugo kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sa dihang gisuginlan ang hari sa Ehipto nga mikalagiw na ang mga Israelita, nausab ang hunahuna sa Faraon ug sa iyang mga sulugoon batok sa katawhan. Miingon sila, “Unsa man ang atong gibuhat nga gitugotan man nato ang mga Israelita nga mahimong gawasnon gikan sa pagtrabaho alang kanato?” ");
INSERT INTO cebulb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Unya giandam sa Faraon nga iyang mga karwahe ug gidala ang iyang mga kasundalohan uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Gidala niya ug 600 ka pinili nga mga karwahe ug ang uban pang mga karwahe sa Ehipto, mga opisyal ang anaa sa tanan nga mga karwahe. ");
INSERT INTO cebulb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Gipatig-a ni Yahweh ang kasingkasing sa Faraon, nga hari sa Ehipto, ug gigukod sa hari ang mga Israelita. Karon namiya na ang mga Isrealita nga madaogon. ");
INSERT INTO cebulb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Apan gigukod sila sa mga Ehiptohanon, uban sa tanan niya nga mga kabayo ug mga karwahe, sa iyang mangabayoay nga mga kalalakin-an, ug sa iyang mga kasundalohan. Nakita nila ang mga Israelita nga nagkampo sa daplin sa dagat sa Pi Hahirot, duol sa Baal Zefon. ");
INSERT INTO cebulb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Sa dihang nagkaduol na ang Faraon, nakita kini sa mga Israelita ug natingala sila. Nagmartsa ang mga Ehiptohanon paingon kanila, ug nangalisang sila. Mituaw ang mga Israelita kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Miingon sila kang Moises, “Tungod ba kay wala nay lubnganan sa Ehipto, mao nga gidala mo kami aron mangamatay dinhi sa kamingawan? Nganong ingon man niini ang imong pagtagad kanamo, sa pagpagawas kanamo sa Ehipto? ");
INSERT INTO cebulb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Dili ba mao man kini ang gisulti namo kanimo didto sa Ehipto? Miingon kami kanimo, 'Pasagdi kami nga mag-inusara, aron nga makatrabaho kami alang sa mga Ehitophanon.' Mas maayo pa alang kanamo nga magtrabaho alang kanila kaysa mangamatay dinhi sa kamingawan.” ");
INSERT INTO cebulb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Miingon si Moises ngadto sa mga katawhan, “Ayaw kamo kahadlok. Barog kamo nga lig-on ug tan-awa ang pagluwas nga ihatag ni Yahweh alang kaninyo karong adlawa. Tungod kay dili na gayod ninyo makita pag-usab ang mga Ehiptohanon nga inyong nakita karon. ");
INSERT INTO cebulb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Si Yahweh ang makig-away alang kaninyo, ug kinahanglan nga mobarog kamo nga lig-on.” ");
INSERT INTO cebulb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Unya miingon si Yahweh kang Moises, “Nganong magsige ka man ug tawag kanako, Moises? Sultihi ang mga Israelita nga mopadayon sa unahan. ");
INSERT INTO cebulb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Iisa ang imong sungkod, ipataas ang imong kamot ngadto sa dagat ug matunga kini, aron makalatas ang katawhan sa Israel sa dagat nga mala ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Matngoni nga akong patig-ahon ang kasingkasing sa mga Ehiptohanon aron gukdon nila sila. Mapasidunggan ako tungod sa Faraon ug sa tanan niya nga mga kasundalohan, sa iyang mga karwahe, ug sa iyang mga mangabayoay nga kalalakin-an. ");
INSERT INTO cebulb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Unya masayran sa mga Ehiptohanon nga ako si Yahweh sa dihang pasidunggan ako tungod sa Faraon, sa iyang mga karwahe, ug sa iyang mga kalalakin-an nga mangabayoay.” ");
INSERT INTO cebulb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ang anghel sa Dios, nga miuna sa mga Israelita, mibalhin ug miadto sa ilang likod. Ang panganod nga daw haligi nga anaa sa ilang atubangan mibalhin ug miadto sa ilang luyo. ");
INSERT INTO cebulb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Anaa ang panganod sa tungatunga sa kampo sa Ehiptohanon ug sa kampo sa mga Israelita. Ngitngit kini nga panganod ngadto sa mga Ehiptohanon, apan nagpahayag kini sa kagabhion alang sa mga Israelita, mao nga ang usa ka bahin wala makaduol sa usa sa tibuok gabii. ");
INSERT INTO cebulb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Giisa ni Moises ang iyang kamot didto sa dagat. Gipasibog ni Yahweh ang dagat pabalik pinaagi sa kusog nga hangin sa sidlakan sa tibuok gabii ug gipamala niya ang dagat. Niini nga paagi natunga ang tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Milatas ang mga Israelita sa tungatunga sa dagat sa mala nga yuta. Daw nahimong paril ang tubig alang kanila gikan sa ilang tuo nga kamot ug ngadto sa ilang wala. ");
INSERT INTO cebulb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gigukod sila sa mga Ehiptohanon. Milatas sila sunod kanila paingon sa tungatunga sa dagat—ang tanang mga kabayo sa Faraon, mga karwahe, ug ang mga mangabayoay nga kalalakin-an. ");
INSERT INTO cebulb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Apan sa sayo nga takna sa buntag, midungaw si Yahweh ngadto sa mga Ehiptohanon nga kasundalohan pinaagi sa daw haligi nga kalayo ug panganod. Gilisang niya ang mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ming-ungot ang mga ligid sa ilang mga karwahe, ug naglisod sa pagsibog ang mga mangabayoay nga mga kalalakin-an. Busa miingon ang mga Ehiptohanon, “Mokalagiw kita gikan sa Israel, tungod kay si Yahweh ang nakig-away alang kanila batok kanato.” ");
INSERT INTO cebulb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Miingon si Yahweh kang Moises, “Iisa ang imong kamot ngadto sa dagat aron nga mobalik ang tubig ngadto sa mga Ehiptohanon, sa ilang mga karwahe, ug sa ilang mga mangabayoay nga kalalakin-an.” ");
INSERT INTO cebulb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Busa giisa ni Moises ang iyang kamot ngadto sa dagat, ug mibalik kini sa naandan nga porma sa pagkabuntag. Nangikyas ang mga Ehiptohanon sa dagat, ug gisibog ni Yahweh ang mga Ehiptohanon ngadto sa tungatunga niini. ");
INSERT INTO cebulb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mitabon ang tubig ug naunlod ang mga karwahe sa Faraon, ang mga mangabayoay nga kalalakin-an, ug ang tibuok niya nga mga kasundalohan nga nagsunod sa mga karwahe ngadto sa dagat. Walay bisan usa nga nabuhi. ");
INSERT INTO cebulb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Bisan pa niana, milakaw ang mga Israelita sa mala nga yuta didto sa tungatunga sa dagat. Nahimong paril ang tubig alang kanila gikan sa ilang tuo nga kamot ug ngadto sa ilang wala. ");
INSERT INTO cebulb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Busa giluwas ni Yahweh ang Israel nianang adlawa gikan sa kamot sa mga Ehiptohanon, ug nakita sa mga Israelita nga nangamatay na ang mga Ehiptohanon ngadto sa baybayon. ");
INSERT INTO cebulb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Sa dihang nakita sa Israel ang dakong gahom nga gigamit ni Yahweh batok sa mga Ehiptohanon, gipasidunggan sa katawhan si Yahweh, ug misalig sila kang Yahweh ug sa iyang sulugoon nga si Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Unya miawit si Moises ug ang katawhan sa Israel niini nga awit ngadto kang Yahweh. Miawit sila, “Awitan ko si Yahweh, tungod kay midaog siya nga mahimayaon; gitambog niya ngadto sa dagat ang mga kabayo ug ang mga nagkabayo niini. ");
INSERT INTO cebulb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Si Yahweh ang akong kusog ug ang awit, ug siya ang akong kaluwasan. Mao kini ang akong Dios, ug dayegon ko siya, ang Dios sa akong amahan, ug ituboy ko siya. ");
INSERT INTO cebulb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Manggugubat si Yahweh; Yahweh ang iyang ngalan. ");
INSERT INTO cebulb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gipangtambog niya ang mga karwahe sa Faraon ug ang mga kasundalohan ngadto sa dagat. Nangalumos ang mga piniling opisyal sa Faraon ngadto sa Dagat nga Kabugangan. ");
INSERT INTO cebulb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Natabonan sila sa kalalom niini; naunlod sila ngadto kinahiladman sama sa bato. ");
INSERT INTO cebulb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ang imong tuong kamot, Yahweh, mahimayaon diha sa gahom; ang imong tuong kamot, Yahweh, nagadugmok sa mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Sa hilabihan nga kahalangdon gipangtambog mo kadtong nakigbatok tali kanimo. Gipahamtang mo ang imong kapungot; milamoy kini kanila sama sa dagami. ");
INSERT INTO cebulb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pinaagi sa huyop sa buho sa imong ilong napundok ang mga tubig; mipundo ang nagdagayday nga tubig sa matag kilid; nabagtok ang lalom nga tubig diha sa kinahiladman sa dagat. ");
INSERT INTO cebulb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Miingon ang mga kaaway, 'Gukdon ko sila, apson ko sila, bahinbahinon ko ang mga inilog nga mga butang; matagbaw ang akong mga tinguha diha kanila; laniton ko ang akong espada; laglagon ko sila sa akong mga kamot.' ");
INSERT INTO cebulb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Apan mitayhop ka, ug mitabon kanila ang dagat; naunlod sila sama sa tingga ngadto sa kinahiladman sa katubigan. ");
INSERT INTO cebulb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kinsa man ang sama kanimo, Yahweh, taliwala sa mga dios? Kinsa man ang sama kanimo, nga nagbuhat ug mga milagro? nga halangdon sa pagkabalaan, gipasidunggan diha sa mga pagdayeg. ");
INSERT INTO cebulb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Giisa mo ang imong tuong kamot, ug gilamoy sila sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Diha sa imong matinud-anon nga kasabotan gigiyahan mo ang katawhan nga imong giluwas. Sa imong kusog gigiyahan mo sila ngadto sa balaang dapit nga imong gipuy-an. ");
INSERT INTO cebulb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Madunggan kini sa panon sa katawhan, ug mangurog sila; sakmiton sa hilabihan nga kalisang ang mga lumolupyo sa Filistia. ");
INSERT INTO cebulb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Unya mahadlok ang mga pangulo sa Edomea; matay-og ang mga kasundalohan sa Moab; mangatunaw ang tanang mga lumolupyo sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Mohugpa ang hilabihan nga kalisang ug kahadlok kanila. Tungod sa gahom sa imong bukton, magpabilin sila nga daw bato hangtod nga makalatas ang imong mga katawhan, Yahweh— hangtod nga makalatas ang katawhan nga imong linuwas. ");
INSERT INTO cebulb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dad-on mo sila ug itanom sila sa bukid nga imong panulondon, ang dapit, Yahweh, nga imong gibuhat aron puy-an, ang balaan nga dapit, among Ginoo, nga gitukod sa imong mga kamot. ");
INSERT INTO cebulb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Maghari si Yahweh hangtod sa kahangtoran.” ");
INSERT INTO cebulb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tungod kay miadto ang mga kabayo sa Faraon uban sa iyang mga karwahe ug mga mangabayoay nga mga kalalakin-an didto sa dagat. Gipabalik ni Yahweh ang katubigan sa dagat didto kanila. Apan nanglakaw ang mga Israelita sa mala nga yuta didto sa tungatunga sa dagat. ");
INSERT INTO cebulb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ang babaye nga propeta nga si Miriam, nga igsoong babaye ni Aaron, mikuha sa tamborin, ug migawas ang tanang mga kababayen-an dala ang ilang mga tamborin, nga nanagsayaw uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Giawitan sila ni Miriam: “Awiti si Yahweh, tungod kay midaog siya nga mahimayaon. Gipangtambog niya ngadto sa dagat ang kabayo ug ang mga nagkabayo niini.” ");
INSERT INTO cebulb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Unya gigiyahan ni Moises ang katawhan sa unahan gikan sa Dagat nga Kabugangan. Miadto sila sa kamingawan sa Shur. Nagpanaw sila sulod sa tulo ka adlaw paingon sa kamingawan ug walay nakaplagan nga tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Unya miabot sila sa Mara, apan dili nila mainom ang tubig didto tungod kay pait kini. Mao nga ginganlan nila ug Mara ang maong dapit. ");
INSERT INTO cebulb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mao nga nagbagulbol ang mga tawo ngadto kang Moises ug miingon, “Unsa man ang among imnon?” ");
INSERT INTO cebulb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mituaw si Moises ngadto kang Yahweh, ug gipakita ni Yahweh kaniya ang usa ka kahoy. Giitsa kini ni Moises ngadto sa tubig, ug nahimong tam-is nga imnon ang tubig. Didto naghatag si Yahweh kanila ug hugot nga balaod, ug didto usab niya sila gisulayan. ");
INSERT INTO cebulb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Miingon siya, “Kung patalinghogan ninyo pag-ayo ang tingog ni Yahweh nga inyong Dios, ug buhaton kung unsa ang husto sa iyang panan-aw, ug kung paminawon ninyo ang iyang mga mando ug tumanon ang tanan nga iyang mga balaod—dili ko kamo pahiagoman ug mga katalagman nga akong gipahamtang sa mga Ehiptohanon, tungod kay ako si Yahweh nga nag-ayo kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Unya miabot ang katawhan ngadto sa Elim, nga diin adunay napulog duha ka mga tuboran sa tubig didto ug 70 ka kahoy nga palmera. Nagkampo sila didto duol sa tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nipanaw ang katawhan gikan didto sa Elim, ug miabot ang tanang katilingban sa mga Israelita didto sa kamingawan sa Sin, nga anaa sa tungatunga sa Elim ug Sinai, sa ikanapulo ug lima nga adlaw sa ikaduha nga bulan human sa ilang pagbiya gikan sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nagbagulbol ang tibuok katilingban sa mga Israelita batok kang Moises ug kang Aaron didto sa kamingawan. ");
INSERT INTO cebulb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Miingon ang mga Israelita ngadto kanila, “Kung nangamatay lamang unta kami sa mga kamot ni Yahweh didto sa yuta sa Ehipto sa dihang milingkod kami duol sa mga kolon sa karne ug nangaon sa tinapay hangtod nga nangabusog. Apan gidala ninyo kami dinhi sa kamingawan aron nga mangamatay ang tibuok namo nga mga katilingban sa kagutom.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Unya miingon si Yahweh kang Moises, “Magpaulan ako ug tinapay gikan sa langit alang kaninyo. Manggawas ang mga tawo ug magtigom ug pagkaon alang lamang nianang adlawa matag adlaw aron masulayan ko sila kung manglakaw ba sila diha sa akong balaod o dili. ");
INSERT INTO cebulb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mahitabo kini sa ikaunom nga adlaw, nga magtigom sila ug makaduha pa kaysa ilang natigom sa miagi nga adlaw, ug lutoon nila ang ilang madala.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Unya miingon si Moises ug si Aaron ngadto sa katawhan sa Israel, “Karong gabhiona masayran ninyo nga si Yahweh mao ang nagpagawas kaninyo gikan sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Inigkabuntag makita ninyo ang himaya ni Yahweh, tungod kay nadungog niya ang inyong pagbagulbol batok kaniya. Kinsa man kami nga magbagulbol man kamo batok kanamo?” ");
INSERT INTO cebulb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Miingon usab si Moises, “Masayran ninyo kini sa dihang hatagan kamo ni Yahweh ug karne sa kagabhion ug tinapay sa kabuntagon hangtod nga mangabusog— tungod kay nadungog niya ang inyong pagbagulbol nga inyong gisulti batok kaniya. Kinsa man ako ug si Aaron? Ang inyong mga pagbagulbol dili batok kanamo; kondili batok kini kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Miingon si Moises kang Aaron, “Sultihi ang tanang katilingban sa Israel nga, 'Duol kamo sa atubangan ni Yahweh, tungod kay nadungog niya ang inyong mga pagbagulbol.'” ");
INSERT INTO cebulb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Nahitabo kini, samtang misulti si Aaron sa tibuok katilingban sa Israel, nga milantaw sila sa kamingawan, ug, tan-awa, mipakita ang himaya ni Yahweh diha sa panganod. ");
INSERT INTO cebulb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Unya misulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nadungog ko ang mga pagbagulbol sa katawhan sa Israel. Sultihi sila ug ingna, 'Karong gabii mokaon kamo ug karne, ug inig kabuntag mabusog kamo sa tinapay. Unya masayran ninyo nga ako si Yahweh nga inyong Dios.'” ");
INSERT INTO cebulb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Sa pagkagabii na miabot ang mga langgam nga buntog ug milukop sa kampo. Sa pagkabuntag nalukop sa yamog ang tibuok kampo. ");
INSERT INTO cebulb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Sa dihang nauga na ang yamog, didto sa hawanan sa kamingawan adunay butang nga nipis ug puti nga sama sa ice nga anaa sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Sa dihang nakita kini sa katawhan sa Israel, nag-ingnanay sila sa usag-usa, “Unsa man kini?” Wala sila masayod kung unsa kini. Miingon si Moises kanila, “Mao kini ang tinapay nga gihatag ni Yahweh kaninyo aron kan-on. ");
INSERT INTO cebulb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mao kini ang mga sugo nga gihatag kanila: 'Kinahanglan nga magtigom kamo, ang matag-usa kaninyo, sa gidaghanon nga kinahanglan ninyong kan-on, usa ka omer alang sa matag-usa ka tawo sa gidaghanon sa imong katawhan. Ingon niini ang pagtigom ninyo niini: Pagtigom ug makaon nga paigo sa matag usa ka tawo nga nagpuyo sa imong tolda.'” ");
INSERT INTO cebulb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Gibuhat kini sa katawhan sa Israel. Ang pipila nagtigom ug daghan, ang pipila nagtigom ug diyutay lamang. ");
INSERT INTO cebulb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Sa dihang gitakos nila kini sa omer nga taksanan, kadtong nagtigom ug daghan walay nahibilin nga salin, ug kadtong nagtigom ug diyutay wala makulangi. Nagtigom ang matag-usa ka tawo nga paigo lamang nga mahinagbo ang ilang panginahanglan. ");
INSERT INTO cebulb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Unya miingon si Moises kanila, “Kinahanglan nga walay magsalin ug bisan unsa niini hangtod sa buntag.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Apan, wala sila namati kang Moises. Ang pipila kanila nagsalin niini hangtod sa pagkabuntag, apan giulod kini ug napan-os. Unya nasuko si Moises kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nagtigom sila niini matag buntag. Nagtigom ang matag-usa ka tawo ug igo nga pagkaon niana nga adlaw. Sa dihang miinit na ang adlaw, natunaw kini. ");
INSERT INTO cebulb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Nahitabo kini sa ikaunom ka adlaw nga gidobli nila ang pagtigom sa gidaghanon sa tinapay, duha ka omer sa matag usa ka tawo. Miabot ang tanang mga pangulo sa katilingban ug gisugid kini ngadto kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Miingon siya kanila, “Mao kini ang giingon ni Yahweh, 'Ugma ang tiunay nga pagpahulay, ang balaang Adlaw nga Igpapahulay sa pagpasidungog kang Yahweh. Lutoa ang gusto ninyo nga lutoon, ug lagaa ang gusto ninyo nga lagaon. Ang tanan nga mahibilin, igahin kini alang sa inyong kaugalingon hangtod sa buntag.'” ");
INSERT INTO cebulb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Busa gilahi nila kini hangtod sa buntag, sumala sa gisugo ni Moises kanila. Wala kini napan-os, ni adunay mga ulod niini. ");
INSERT INTO cebulb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Miingon si Moises, “Kan-a kanang pagkaon karong adlawa, kay karon ang adlaw nga gitagana ingon nga Adlaw nga Igpapahulay aron sa pagpasidungog kang Yahweh. Karong adlawa dili na kamo makakaplag niini sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tigomon ninyo kini sulod sa unom ka adlaw, apan ang ikapito nga adlaw mao ang Adlaw nga Igpapahulay. Sa adlaw nga Igpapahulay walay na gayoy manna.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Nahitabo kini sa ikapito nga adlaw nga adunay pipila ka mga tawo nga miadto aron sa pagtigom ug manna, apan wala silay nakaplagan. ");
INSERT INTO cebulb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Unya miingon si Yahweh kang Moises, “Hangtod kanus-a man ninyo supakon ang akong mga sugo ug mga balaod? ");
INSERT INTO cebulb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tan-awa, gihatag ni Yahweh kaninyo ang Adlaw nga Igpapahulay. Mao nga sa ikaunom nga adlaw naghatag siya kaninyo ug tinapay nga alang sa duha ka adlaw. Kinahanglan nga ang matag usa kaninyo magpabilin sa iyang kaugalingong dapit; kinahanglan nga walay mogawas sa iyang dapit sa ikapito nga adlaw.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Busa nagpahulay ang katawhan sa ikapito nga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Gitawag sa mga katawhan sa Israel kini nga pagkaon ug “manna.” Puti kini sama sa liso sa culantro, ug ang lami niini sama sa nipis nga tinapay nga hinimo gikan sa dugos. ");
INSERT INTO cebulb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Miingon si Moises, “Mao kini ang gisugo ni Yahweh: 'Tugoti nga matipigan ang usa ka omer nga manna sa tibuok kaliwatan sa inyong katawhan aron makita sa inyong mga kaliwat ang tinapay nga akong gipakaon kaninyo sa kamingawan, human ko kamo gipagawas gikan sa yuta sa Ehipto.'” ");
INSERT INTO cebulb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Miingon si Moises kang Aaron, “Pagkuha ug usa ka kolon ug ibutang dinhi ang usa ka omer nga manna. Tipigi kini sa atubangan ni Yahweh aron nga matipigan hangtod sa mga kaliwatan sa katawhan.” ");
INSERT INTO cebulb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sumala sa gisugo ni Yahweh kang Moises, gibutang kini ni Aaron didto tapad sa kasugoan sa kasabotan sulod sa Sudlanan sa Kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mikaon ug manna ang katawhan sa Israel sulod sa 40 ka tuig hangtod nga miabot sila sa yuta nga ilang puy-an. Mikaon sila niini hangtod nga miabot sila sa utlanan sa yuta sa Canaan. ");
INSERT INTO cebulb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Karon ang usa ka omer mao ang ikanapulo ka bahin sa epha. ");
INSERT INTO cebulb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mipanaw ang tibuok katilingban nga mga Israelita gikan sa kamingawan sa Sin, nagsunod sa gisugo ni Yahweh. Nagkampo sila sa Rafidim, apan walay tubig nga mainom sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Busa gibasol sa katawhan si Moises tungod sa ilang kahimtang ug miingon, “Hatagi kami ug tubig aron imnon.” Miingon si Moises, “Nganong makiglalis man kamo kanako? Nganong sulayan man ninyo si Yahweh?” ");
INSERT INTO cebulb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Gipang-uhaw ug maayo ang katawhan, ug nagbagulbol sila batok kang Moises. Miingon sila, “Nganong gipagawas mo man kami gikan sa Ehipto? Aron ba nga mangamatay kami ug ang among mga anak ug ang among mga baka sa kauhaw?” ");
INSERT INTO cebulb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Unya mituaw si Moises kang Yahweh, “Unsa man ang angay nakong buhaton niining katawhan? Hapit na nila ako batoa.” ");
INSERT INTO cebulb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Miingon si Yahweh kang Moises, “Pag-una sa katawhan, ug paubana kanimo ang pipila sa mga kadagkoan sa Israel. Dad-a ang imong sungkod nga imong gibunal sa tubig, ug lakaw. ");
INSERT INTO cebulb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Motindog ako sa imong atubangan didto sa bato sa Horeb, ug bunalan nimo ang bato. Moawas ang tubig gikan niini aron nga mainom sa katawhan.” Unya gibuhat kini ni Moises sa panan-aw sa mga kadagkoan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Gitawag niya kana nga dapit nga Massa ug Meriba tungod kay nagbagulbol man ang mga Israelita, ug tungod kay gisulayan man nila ang Ginoo sa pag-ingon, “Uban ba gayod si Yahweh kanato o wala?” ");
INSERT INTO cebulb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Unya miabot ang mga kasundalohan sa Amalek nga katawhan ug gisulong ang Isarel didto sa Refidim. ");
INSERT INTO cebulb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Busa miingon si Moises ngadto kang Josue, “Pagpili ug pipila ka mga kalalakin-an ug gawas kamo. Pakig-away sa Amalek. Ugma motindog ako didto sa tumoy sa bungtod dala ang sungkod sa Dios.” ");
INSERT INTO cebulb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Busa nakig-away si Josue kang Amalek sumala sa gisugo ni Moises, samtang mitungas si Moises, si Aaron, ug si Hur paingon sa tumoy sa bungtod. ");
INSERT INTO cebulb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Samtang giisa ni Moises ang iyang mga kamot, modaog ang mga Israelita; sa dihang ipahulay niya ang iyang mga kamot, magsugod pagdaog ang Amalek. ");
INSERT INTO cebulb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Sa dihang bug-at na ang kamot ni Moises, nagkuha ug bato si Aaron ug si Hur ug gibutang kini ubos kaniya aron iyang lingkoran. Sa samang panahon, gipataas ni Aaron ug ni Hur ang iyang mga kamot, usa ka tawo sa iyang kilid ug ang lain usab sa pikas. Busa nagpabilin nga gipataas ang kamot ni Moises hangtod nga misalop ang adlaw. ");
INSERT INTO cebulb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Busa nabuntog ni Josue ang katawhan sa Amalek pinaagi sa espada. ");
INSERT INTO cebulb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Miingon si Yahweh kang Moises, “Isulat kini sa libro ug basaha kini sa igdulongog ni Josue, tungod kay papason ko sa hingpit ang handomanan ni Amalek gikan sa ilalom sa kalangitan.” ");
INSERT INTO cebulb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Unya nagtukod si Moises ug halaran ug gitawag niya kini ug, “Si Yahweh ang akong bandira.” ");
INSERT INTO cebulb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Miingon siya, “Kay giisa ang kamot ngadto sa trono ni Yahweh—kay si Yahweh ang makig-away kang Amalek gikan sa kaliwatan ngadto sa kaliwatan.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Nadungog ni Jetro, nga pari sa Midian, nga ugangang lalaki ni Moises, ang tanang nabuhat sa Dios kang Moises ug sa Israel nga iyang katawhan. Nadungog niya nga gipagawas ni Yahweh ang Israel gikan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Gidala ni Jetro, nga ugangang lalaki ni Moises, si Zipora, nga asawa ni Moises, human niya siya papaulia sa iyang panimalay, ");
INSERT INTO cebulb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ug ang iyang duha ka mga anak nga lalaki; ang ngalan sa usa ka anak nga lalaki mao si Gershom, kay miingon si Moises, “Dumoduong ako sa usa ka langyaw nga dapit.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ang ngalan sa lain mao si Eliezer, kay miingon si Moises, “Ang Dios sa akong katigulangan mao ang akong magtatabang. Giluwas niya ako gikan sa espada sa Faraon.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Si Jetro, nga ugangang lalaki ni Moises, miadto uban sa mga anak nga lalaki ni Moises ug sa iyang asawa ngadto kang Moises didto sa kamingawanan nga anaa sa bukid sa Dios diin nagkampo siya. ");
INSERT INTO cebulb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Miingon siya ngadto kang Moises, “Ako, nga imong ugangan nga si Jetro, moanha kanimo uban sa imong asawa ug sa imong duha ka mga anak nga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Migawas si Moises aron sa paghimamat sa iyang ugangan nga lalaki, miyukbo, ug mihalok kaniya. Nagkumostahay sila sa kahimtang sa matag-usa unya misulod ngadto sa tolda. ");
INSERT INTO cebulb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Gisultihan ni Moises ang iyang ugangan nga lalaki sa tanan nga gibuhat ni Yahweh ngadto sa Faraon ug sa mga Ehiptohanon alang sa Israel, mahitungod sa tanang kalisdanan nga miabot kanila sa ilang dalan, ug kung giunsa sila pagluwas ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nagmaya si Jetro sa tanang maayo nga gibuhat ni Yahweh alang sa Israel, niana giluwas niya sila gikan sa kamot sa mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Miingon si Jetro, “Pagadayegon si Yahweh, tungod kay giluwas niya kamo gikan sa kamot sa mga Ehiptohanon ug gikan sa kamot sa Faraon, ug gipalingkawas ang katawhan gikan sa kamot sa mga Ehiptohanon. ");
INSERT INTO cebulb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Karon akong nasayran nga mas labaw pa si Yahweh kaysa sa tanang mga dios, tungod kay sa dihang gidaogdaog ug maayo sa mga Ehiptohanon ang mga Israelita, giluwas sa Dios ang iyang katawhan.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nagdala ug halad nga sinunog ug mga halad alang sa Dios, si Jetro, nga ugangan nga lalaki ni Moises. Miadto si Aaron ug ang tanang mga kadagkoan sa Israel aron sa pagpangaon atubangan sa Dios uban sa ugangan nga lalaki ni Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pagkasunod nga adlaw milingkod si Moises aron sa paghusay sa katawhan. Mitindog palibot kaniya ang katawhan gikan sa buntag hangtod sa kagabhion. ");
INSERT INTO cebulb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Sa dihang nakita sa ugangan nga lalaki ni Moises ang tanang niyang gibuhat sa katawhan, miingon siya, “Unsa man kining imong ginabuhat sa katawhan? Nganong ikaw lang man ang naglingkod ug ang tanang katawhan nagtindog sa imong atubangan gikan sa buntag hangtod sa kagabhion? ");
INSERT INTO cebulb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Miingon si Moises sa iyang ugangan nga lalaki, “Moduol ang mga tawo kanako aron mangayo ug giya sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kung aduna silay panaglalis, moduol sila kanako. Ako ang mohusay sa usa ka tawo tali sa uban, ug tudloan ko sila sa kasugoan ug mga balaod sa Dios.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Miingon ang ugangan nga lalaki ni Moises ngadto kaniya, “Dili gayod maayo ang imong ginabuhat. ");
INSERT INTO cebulb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Sigurado gayod nga mahago ang imong kaugalingon, ikaw ug ang katawhan nga uban kanimo. Kini nga palas-anon hilabihan kabug-at alang kanimo. Dili ka makahimo niini kung ikaw lamang. ");
INSERT INTO cebulb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Paminaw kanako. Tambagan ko ikaw, ug mag-uban ang Dios kanimo, tungod kay ikaw man ang tigpataliwala sa katawhan ngadto sa Dios, ug dad-on mo ang ilang mga panaglalis ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kinahanglan nga tudloan nimo sila sa iyang mga kasugoan ug mga balaod. Kinahanglan ipakita mo kanila ang dalan nga angayng laktan ug bulohaton nga angayng buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Dugang pa, kinahanglan nga magpili ka ug angayan nga mga tawo gikan sa tanang katawhan, mga tawo nga nagtahod sa Dios, mga tawo nga matarong nga nagasalikway sa dili pagkamakiangayon. Kinahanglan ibutang mo sila sa pagdumala sa katawhan, aron mahimong mga pangulo sa pagdumala sa liboan, gatosan, tag-singkwenta, ug tag-napulo. ");
INSERT INTO cebulb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Maghusay sila sa katawhan sa tanang sayon lamang nga mga kaso, apan ang mga lisod nga mga kaso pagadad-on nila kanimo. Alang sa tanang sayon nga mga kaso, makahimo sila sa paghusay niana sa ilang kaugalingon. Niana nga paagi mas mosayon kini alang kanimo, ug yayongan nila ang palas-anon uban kanimo. ");
INSERT INTO cebulb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kung buhaton mo kini, ug kung nagmando ang Dios nga buhaton mo gayod kini, nan makalahutay ka, ug makapamauli ang tibuok katawhan sa ilang panimalay nga adunay katagbawan.” ");
INSERT INTO cebulb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Busa gipatalinghogan ni Moises ang mga pulong sa iyang ugangan nga lalaki ug gibuhat ang tanan nga iyang gisulti. ");
INSERT INTO cebulb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nagpili si Moises ug mga tawo nga makadumala gikan sa tibuok Israel ug gihimo silang mga pangulo alang sa katawhan, mga pangulo nga magdumala sa liboan, gatosan, tag-singkwenta, ug tag-napulo. ");
INSERT INTO cebulb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Naghusay sila sa kasagaran nga mga panaglalis sa mga tawo. Ginadala nila ngadto kang Moises ang lisod nga mga kaso, apan sila sa ilang mga kaugalingon ang mohusay sa tanang sayon nga mga kaso. ");
INSERT INTO cebulb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Unya gitugotan ni Moises sa paglakaw ang iyang ugangan nga lalaki, ug mibalik si Jetro sa iyang kaugalingon nga yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Sa ikatulo nga bulan human makagawas ang katawhan sa Israel gikan sa yuta sa Ehipto, sa sama nga adlaw, miadto sila sa kamingawan didto sa Sinai. ");
INSERT INTO cebulb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Human nila ug biya sa Refidim ug miabot sa kamingawan sa Sinai, nagkampo sila sa kamingawan atubangan sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mitungas si Moises ngadto sa Dios. Gitawag siya ni Yahweh didto sa bukid ug miingon, “Kinahanglan nga sultihan mo ang balay ni Jacob, ang katawhan sa Israel: ");
INSERT INTO cebulb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nakita ninyo ang akong gibuhat sa mga Ehiptohanon, kung giunsa ko kamo pagdala sa mga pako sa agila ug gidala kamo nganhi sa akong kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Unya karon, kung matinud-anon kamo nga maminaw sa akong tingog ug motuman sa akong kasabotan, nan mamahimo ko kamong pinasahi nga gipanag-iyahan taliwala sa tanang katawhan, tungod kay ang tibuok kalibotan akoa man. ");
INSERT INTO cebulb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mahimo kamong gingharian sa mga pari ug balaan nga nasod alang kanako. Mao kini nga mga pulong nga kinahanglan mong isulti ngadto sa katawhan sa Israel.” ");
INSERT INTO cebulb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Busa miadto si Moises ug gipatawag ang tanang mga kadagkoan sa katawhan. Gisulti niya kanila kining tanan nga mga pulong nga gimando ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mitubag ang tanang katawhan ug miingon, “Buhaton namo ang tanang butang nga gisulti ni Yahweh.” Unya miadto si Moises aron ibalita ang mga pulong sa katawhan ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Miingon si Yahweh kang Moises, “Moanha ako kaninyo pinaagi sa baga nga panganod aron nga madungog sa katawhan samtang makigsulti ako kaninyo ug motuo usab kanimo hangtod sa kahangtoran.” Unya gisulti ni Moises ang mga pulong sa katawhan ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Miingon si Yahweh kang Moises, “Adtoa ang katawhan. Kinahanglan nga ilain mo sila alang kanako karon ug ugma, ug ingna sila nga labhan ang ilang mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Pagpangandam alang sa ikatulong adlaw, kay mokanaog si Yahweh sa Bukid sa Sinai sa ikatulo nga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kinahanglan nga maghimo ka ug mga utlanan sa tibuok palibot sa bukid alang sa katawhan. Sultihi sila, 'Pagbantay nga dili kamo makatungas sa bukid o makahikap sa utlanan niini. Si bisan kinsa man nga makahikap sa bukid sigurado nga pagapatyon gayod.' ");
INSERT INTO cebulb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kinahanglan nga walay usa ka tawo nga mohikap nianang tawhana. Sa ingon niana, kinahanglan nga batohon siya o panaon. Tawo man kini o mananap, kinahanglan nga pagapatyon siya. Sa dihang molanog na ang budyong, makahimo na silang motungas sa tiilan sa bukid.” ");
INSERT INTO cebulb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Unya milugsong si Moises gikan sa bukid paingon sa katawhan. Gilain niya ang mga tawo alang kang Yahweh ug gilabhan nila ang ilang mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Miingon siya sa katawhan, “Pangandam kamo sa ikatulo nga adlaw; ayaw kamo paduol sa inyong mga asawa.” ");
INSERT INTO cebulb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Sa pagkabuntag, sa ikatulo nga adlaw, adunay dalugdog ug kilat ug baga nga panganod sa ibabaw sa bukid, ug gipalanog ug maayo ang budyong. Nangalisang ang tanang katawhan didto sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Gipagawas ni Moises ang mga tawo sa kampo aron sa pagpakighimamat sa Dios, ug mitindog sila sa tiilan sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nalukop ug maayo sa aso ang Bukid sa Sinai tungod kay mikanaog si Yahweh niini pinaagi sa kalayo ug aso. Miutbo ang aso sama sa aso sa usa ka hudno, ug natay-og ug maayo ang bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Samtang nag-anam ug kalanog ang tingog sa budyong, misulti si Moises, ug mitubag ang Dios kaniya sa usa ka tingog. ");
INSERT INTO cebulb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mihugpa si Yahweh didto sa tumoy sa Bukid sa Sinai, ug gitawag niya si Moises didto sa tumoy sa bukid. Busa mitungas si Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Miingon si Yahweh kang Moises, “Lugsong ug pahimangnoi ang katawhan nga dili sila molapas sa utlanan aron sa paglantaw kanako, o mahanaw ang kadaghanan kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Tugoti usab kadtong mga pari nga moduol kanako sa paglain sa ilang kaugalingon—ipaandam ang ilang kaugalingon alang sa akong pag-abot—aron nga dili ko sila patyon.” ");
INSERT INTO cebulb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Miingon si Moises kang Yahweh, “Dili makahimo sa pagtungas ang mga tawo sa bukid, kay gimandoan mo man kami: 'Paghimo ug mga utlanan palibot sa bukid ug igahin kini kang Yahweh.”' ");
INSERT INTO cebulb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Miingon si Yahweh kaniya, “Lakaw, lugsong gikan sa bukid, ug dad-a si Aaron uban kanimo, apan ayaw tugoti nga molapas sa mga atang ang mga pari ug ang katawhan nga moanhi kanako, o patyon ko sila.” ");
INSERT INTO cebulb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Busa milugsong si Moises paingon sa katawhan ug nakigsulti kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Gisulti sa Dios kining tanan nga mga pulong: ");
INSERT INTO cebulb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ako si Yahweh nga inyong Dios, nga nagpagawas kaninyo sa yuta sa Ehipto, pagawas sa balay sa pagkaulipon. ");
INSERT INTO cebulb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Kinahanglan nga wala kamoy lain nga mga dios gawas kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ayaw kamo paghimo sa inyong kaugalingon sa kinulit nga hulagway ni larawan sa bisan unsa nga mga butang nga anaa ibabaw sa langit, o nga anaa sa ilalom sa yuta, o anaa sa ilalom sa tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kinahanglan nga dili kamo moyukbo niini o mosimba niini, kay ako, si Yahweh nga inyong Dios, abughoan nga Dios. Pagasilotan ko ang pagkadaotan sa mga katigulangan pinaagi sa pagdala ug silot sa mga kaliwat, ngadto sa ikatulo ug ikaupat nga kaliwatan niadtong nasilag kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Apan ipakita ko ang matinud-anong kasabotan ngadto sa liboan nga nahigugma kanako ug nagtuman sa akong mga sugo. ");
INSERT INTO cebulb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Kinahanglan nga dili ninyo gamiton ang ngalan ni Yahweh nga inyong Dios, sa pagpasipala, tungod kay pakasad-on ko gayod siya nga nagpasipala sa akong ngalan. ");
INSERT INTO cebulb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Hinumdomi ang Adlaw nga Igpapahulay, nga igahin kini kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kinahanglan nga maghago kamo ug buhaton ang tanang bulohaton sulod sa unom ka mga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Apan ang ikapitong adlaw nga mao ang Igpapahulay alang kang Yahweh nga inyong Dios. Niining adlawa kinahanglan nga dili kamo magbuhat ug bisan unsa nga bulohaton, kamo, o ang inyong anak nga lalaki, o ang inyong anak nga babaye, o ang inyong sulugoon nga lalaki, o ang inyong sulugoon nga babaye, o ang inyong baka, ang langyaw nga anaa sa inyong mga ganghaan. ");
INSERT INTO cebulb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tungod kay sulod sa unom ka adlaw gibuhat ni Yahweh ang kalangitan ug ang yuta, ang dagat, ug ang tanan nga anaa niini, ug mipahulay sa ikapito nga adlaw. Busa gibalaan ni Yahweh ang Adlaw nga Igpapahulay ug gilain kini. ");
INSERT INTO cebulb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tahora ang inyong amahan ug ang inyong inahan, aron nga mabuhi kamo sa hataas nga panahon sa yuta nga igahatag ni Yahweh nga inyong Dios diha kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Kinahanglan nga dili kamo mopatay. ");
INSERT INTO cebulb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Kinahanglan nga dili kamo manapaw. ");
INSERT INTO cebulb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Kinahanglan nga dili kamo mangawat kang bisan kinsa. ");
INSERT INTO cebulb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Kinahanglan nga dili kamo magbutangbutang batok sa inyong silingan. ");
INSERT INTO cebulb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Kinahanglan nga dili kamo magtinguha sa balay sa inyong silingan; kinahanglan nga dili kamo magtinguha sa asawa sa inyong silingan, sa iyang sulugoon nga lalaki, sa iyang sulugoon nga babaye, sa iyang toro nga baka, sa iyang asno, o sa bisan unsa nga mga butang nga gipanag-iyahan sa inyong silingan.” ");
INSERT INTO cebulb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nakita sa tibuok katawhan ang pagdalugdog ug ang pagkilat, ug nadungog ang paglanog sa budyong, ug nakita nga nag-aso ang bukid. Sa pagkakita sa mga tawo niini, nangalisang sila ug nanagpanindog sa halayo. ");
INSERT INTO cebulb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Miingon sila kang Moises, “Sultihi kami, ug maminaw kami; apan ayaw tugoti nga ang Dios ang mosulti kanamo, kay tingali ug mangamatay kami.” ");
INSERT INTO cebulb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Miingon si Moises sa katawhan, “Ayaw kahadlok, kay mianhi ang Dios aron sa pagsulay kaninyo aron nga ang iyang kadungganan maanaa kaninyo, ug aron nga dili kamo makasala.” ");
INSERT INTO cebulb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Busa nanagpanindog ang mga tawo sa halayo, ug miduol si Moises sa baga nga naglagitom nga panganod diin anaa ang Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Miingon si Yahweh kang Moises, “Mao kini ang angay mong isulti sa mga Israelita: 'Nakita gayod ninyo nga nakigsulti ako kaninyo gikan sa langit. ");
INSERT INTO cebulb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ayaw kamo pagbuhat ug uban nga mga dios alang sa inyong kaugalingon gawas kanako, mga dios nga plata o mga dios nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kinahanglan nga magbuhat kamo ug halaran nga yuta alang kanako, ug kinahanglan nga maghalad kamo sa inyong mga halad sinunog sa ibabaw niini, mga halad sa pakigdait, karnero, ug mga torong baka. Sa matag dapit diin mapasidunggan ko ang akong ngalan, moanha ako kaninyo ug panalanginan kamo. ");
INSERT INTO cebulb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kung himoan ninyo ako ug bato nga halaran, kinahanglan nga dili ninyo kini himoon pinaagi sa tinabas nga mga bato, kay kung gamiton ninyo ang inyong mga kahimanan niini, mapasipad-an ninyo kini. ");
INSERT INTO cebulb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kinahanglan nga dili kamo moadto sa akong halaran pinaagi sa hagdanan; aron nga dili makita ang tinagoan nga bahin sa inyong lawas.”' ");
INSERT INTO cebulb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Karon mao kini ang mga balaod nga ipatuman mo kanila: ");
INSERT INTO cebulb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","'Kung mopalit kamo ug ulipon nga Hebreohanon, paalagara siya sulod sa unom ka tuig, ug sa ikapito nga tuig palakwa siya nga dili pabayron. ");
INSERT INTO cebulb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kung ulitawo siya nga miabot, palakwa siyang mag-inusara; kung minyo siya, nan palakwa uban kaniya ang iyang asawa. ");
INSERT INTO cebulb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kung ang iyang agalon mihatag kaniya ug asawa unya nanganak alang kaniya ang iyang asawa sa mga anak nga lalaki o mga babaye, ang asawa ug ang iyang mga anak mapanag-iya sa iyang agalon, ug molakaw siya nga mag-inusara. ");
INSERT INTO cebulb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Apan kung mosulti gayod ang ulipon, “Gihigugma ko ang akong agalon, ang akong asawa, ug ang akong mga anak; dili ako mopahawa,” ");
INSERT INTO cebulb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nan pagadad-on siya sa iyang agalon ngadto sa Dios. Kinahanglan dad-on siya sa iyang agalon ngadto sa pultahan o sa haligi sa pultahan ug kinahanglan bangagan sa iyang agalon ang dalunggan sa ulipon gamit ang galamiton sa pagbangag. Unya maulipon siya sa tibuok niyang kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kung ibaligya sa usa ka tawo ang iyang anak nga babaye ingon nga ulipon, dili siya buhian sama sa ginabuhat sa mga ulipong lalaki. ");
INSERT INTO cebulb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kung dili siya makapahimuot sa iyang agalon, nga nagpili kaniya aron maiya, nan ang agalon makabaligya kaniya pagbalik. Walay katungod ang agalon sa pagbaligya kaniya ngadto sa mga langyaw. Wala gayod siyay katungod niana, sanglit gitamod man niya siya nga malinglahon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kung ang iyang agalon magpili kaniya aron maasawa sa iyang anak nga lalaki, kinahanglan nga tagdon niya siya sama sa iyang anak nga babaye. ");
INSERT INTO cebulb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kung maminyo siya ug laing babaye, kinahanglan nga dili niya kuhaan ang pagkaon sa unang asawa, mga bisti, o ang iyang katungod sa pagkaasawa. ");
INSERT INTO cebulb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Apan kung dili niya mahatag kining tulo ka butang ngadto kaniya, nan gawasnon siyang makapahawa nga walay ibayad nga salapi. ");
INSERT INTO cebulb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Si bisan kinsa kadtong modagmal sa usa ka tawo aron siya mamatay, kanang tawhana kinahanglan patyon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kung ang tawo wala magplano niining daan, kondili wala kini tuyoa, nan mopili ako ug usa ka dapit nga iyang kadangpan. ");
INSERT INTO cebulb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kung tinuyoan sa tawo ang pagdagmal sa iyang isigkatawo ug mopatay kaniya sumala sa malimbungon nga plano, nan kuhaa ninyo siya, bisan pa kung anaa siya sa halaran sa Dios, aron patyon siya. ");
INSERT INTO cebulb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Si bisan kinsa kadtong magpasakit sa iyang amahan o inahan kinahanglan gayod patyon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Si bisan kinsa ang modagit sa usa ka tawo ug mobaligya kaniya, o ang tao makaplagan nga iyang gitagoan, kanang tawo nga nagdagit kinahanglan gayod patyon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Si bisan kinsa ang motunglo sa iyang amahan o sa iyang inahan kinahanglan gayod patyon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kung mag-away ang mga tawo ug dagmalan sa usa ang laing tawo gamit ang bato o sa iyang kinumo, ug wala mamatay kanang tawhana, apan naglubog siya sa iyang higdaanan; ");
INSERT INTO cebulb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","unya kung mamaayo na siya ug makalakaw na gamit ang iyang sungkod, ang tawo nga nagdagmal kaniya kinahanglan mobayad sa iyang oras nga nausik; kinahanglan mobayad usab siya hangtod mamaayo na gayod siya. Apan kanang tawhana dili sad-an sa pagpatay. ");
INSERT INTO cebulb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Kung bunalan sa usa ka tawo ang iyang ulipong lalaki o babaye gamit ang sungkod, ug kung mao kana ang hinungdan nga mamatay ang ulipon, nan angay gayong silotan kanang tawhana. ");
INSERT INTO cebulb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Apan, kung buhi pa ang ulipon sulod sa usa o duha ka adlaw, dili angay silotan ang agalon, tungod kay nag-antos man siya sa pagkawala sa iyang ulipon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Kung adunay mag-away nga mga tawo ug makaangin nga makuhaan ang usa ka babayeng mabdos, apan wala nay laing kadaot nga nahitabo kaniya, nan ang tawong sad-an kinahanglan magmulta sumala sa gipangayo kaniya sa bana sa babaye, ug magabayad siya sumala sa hukom sa maghuhukom. ");
INSERT INTO cebulb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Apan kung adunay kadaot nga mahitabo, nan kinahanglan ang kinabuhi bayrag kinabuhi, ");
INSERT INTO cebulb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ang usa ka mata bayrag mata, ang ngipon bayrag ngipon, ang kamot bayrag kamot, ang tiil bayrag tiil, ");
INSERT INTO cebulb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ang paso bayrag paso, ang samad bayrag samad, o ang labod bayrag labod. ");
INSERT INTO cebulb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kung maigo sa usa ka tawo ang mata sa iyang ulipong lalaki o sa iyang ulipong babaye ug mabuta kini, nan palakwon niya ang ulipon ingon nga bayad alang sa iyang mata. ");
INSERT INTO cebulb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kung mapangag niya ang ngipon sa iyang ulipong lalaki o babaye, angay niyang palakwon ang ulipon ingon nga bayad alang sa ngipon. ");
INSERT INTO cebulb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kung ang torong baka makasungag sa usa ka lalaki o babaye hangtod mamatay, kinahanglan gayod batohon ang baka, ug dili kan-on ang unod niini; apan ang tag-iya sa maong baka dili silotan. ");
INSERT INTO cebulb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Apan kung nabatasan na sa baka ang pagpanungag kaniadto, ug gipasidan-an na ang tag-iya apan wala niya kini bantayi, unya makapatay ang torong baka ug lalaki o babaye, batohon gayod kanang torong baka, ug patyon usab ang tag-iya niini. ");
INSERT INTO cebulb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kung gikinahanglan ang bayad alang sa paglukat sa iyang kinabuhi, pagabayran niya ang tibuok kantidad. ");
INSERT INTO cebulb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kung ang torong baka makapanungag sa anak nga lalaki o anak nga babaye sa usa ka tawo, kinahanglan nga buhaton sa tag-iya ang gisugo sa balaod nga angay niyang buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kung makapanungag ang torong baka sa usa ka ulipong lalaki o ulipong babaye, ang tag-iya sa maong torong baka kinahanglan magbayad ug 30 ka shekels nga plata, ug batohon ang maong baka. ");
INSERT INTO cebulb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kung ang usa ka tawo magkuha sa tabon sa usa ka lungag, o magbangag ug dili niya kini tabonan, ug mahulog niini ang usa ka torong baka o asno, ");
INSERT INTO cebulb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","kinahanglan bayran sa tag-iya ang nawala. Bayaran niyag salapi ang tag-iya sa namatay nga mananap, ug maiya na ang patay nga mananap. ");
INSERT INTO cebulb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kung ang baka sa usa ka tawo makapatay sa torong baka sa laing tawo, nan kinahanglan ibaligya nila ang buhi nga torong baka ug bahinon nila ang halin niini, ug bahinon usab nila ang namatay nga torong baka. ");
INSERT INTO cebulb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Apan kung ilado na nga gapanungag ang maong torong baka kaniadto, ug wala kini bantayi sa tag-iya, bayran gayod niya ang torong baka alang sa torong baka, ug maiya ang patay nga mananap. ");
INSERT INTO cebulb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kung ang usa ka tawo mangawat ug usa ka torong baka o karnero ug ihawon kini ug ibaligya, nan bayran niya ug lima ka torong baka alang sa usa ka torong baka, ug ang upat ka karnero alang niadtong usa ka karnero. ");
INSERT INTO cebulb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kung ang kawatan nasakpan nga nanglungkab sa balay aron makasulod, ug kung siya masamaran ug maoy hinungdan nga mamatay siya, niana nga kahimtang walay sala ang si bisan kinsa nga makapatay kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Apan kung misubang na ang adlaw ayha siya makasulod, sad-an ang tawo nga makapatay kaniya. Ug ang kawatan kinahanglan nga magbayad. Apan kung wala gayod siyay ikabayad, nan ibaligya siya tungod sa iyang gikawat. ");
INSERT INTO cebulb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Apan kung ang kinawat nga mananap mahikaplagan nga anaa sulod sa iyang gipanag-iyahan, bisan pa kung usa kini ka torong baka, asno, o karnero, bayran niya kini ug duha ka pilo. ");
INSERT INTO cebulb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kung ang usa ka tawo magpasibsib sa iyang kahayopan sa iyang uma o sa kaparasan, ug gibuhian ang iyang mga mananap, ug nanibsib kini sa uma sa ubang tawo, kinahanglan bayran niya kini gikan sa labing maayong abot sa iyang uma, ug sa labing maayo sa iyang kaparasan. ");
INSERT INTO cebulb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ug kung adunay sunog ug mikuyanap sa katunokan ug hinungdan nga mangasunog ang binugkos nga mga trigo, o nanindog nga trigo, o masunog ang uma, ang tawo nga nagpasiugda sa maong sunog magabayad gayod. ");
INSERT INTO cebulb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kung ipiyal sa usa ka tawo ang salapi o katigayonan ngadto sa iyang silingan aron tipigan, ug kung kawaton kini didto sa balay sa maong tawo, kung makaplagan ang kawatan, kanang kawatan magbayad ug duha ka pilo. ");
INSERT INTO cebulb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Apan kung ang kawatan dili makaplagan, kinahanglan moadto ang tag-iya sa maong balay sa mga maghuhukom ug makisayod kung nanghilabot ba siya ngadto sa katigayonan sa iyang silingan. ");
INSERT INTO cebulb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kay ang matag panaglalis mahitungod sa usa ka butang, bisan sa torong baka, sa asno, sa karnero, sa bisti, o sa bisan unsa nga nawalang butang nga gisulti sa tawo, “Akoa kini,” ang matag usa moadto sa mga maghuhukom. Ang tawo nga makaplagan sa maghuhukom nga sad-an kinahanglang mobayad ug duha ka pilo ngadto sa iyang silingan. ");
INSERT INTO cebulb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Kung ipiyal sa usa ka tawo ngadto sa iyang isigkatawo ang asno, torong baka, karnero, o bisan unsang mananap aron alimahan, ug kung mamatay kini o masamdan o pagaabogon kini nga walay makakita, ");
INSERT INTO cebulb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ang panumpa ngadto kang Yahweh magpataliwala kanilang duha, bisan paman o walay usa ka tawo nga nanghilabot ngadto sa bahandi sa iyang isigkatawo. Kinahanglan nga dawaton kini sa tag-iya, ug ang usa dili magbayad. ");
INSERT INTO cebulb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Apan kung gikawat kini gikan kaniya, kinahanglan mobayad siya sa tag-iya niini. ");
INSERT INTO cebulb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kung gikuniskunis ang mananap, ipadala kini kaniya ngadto sa tag-iya ingon nga pagpamatuod. Dili siya magabayad niadtong nakuniskunis na. ");
INSERT INTO cebulb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kung ang usa ka tawo manghulam sa bisan unsang mananap sa iyang isigkatawo ug nasamdan ang mananap o mamatay nga wala didto ang tag-iya, kinahanglan bayaran gayod sa tawo ang nahulam. ");
INSERT INTO cebulb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Apan kung ang tag-iya anaa didto, walay bayran ang maong tawo; kung ang mananap inabangan, bayran kini sa iyang suhol. ");
INSERT INTO cebulb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kung manintal ang usa ka lalaki sa usa ka ulay nga dili pa kinasal, ug kung makigdulog siya kaniya, kinahanglan nga minyoan gayod niya siya pinaagi sa pagbayad sa babaye ug bugay nga gikinahanglan alang niini. ");
INSERT INTO cebulb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ug kung ang iyang amahan magdumili gayod sa pagpaminyo kaniya ngadto sa lalaki, magbayad gayod siya ug salapi sumala sa bugay alang sa mga ulay. ");
INSERT INTO cebulb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ayaw gayod ninyo tugoti nga mabuhi ang babayeng diwatahan. ");
INSERT INTO cebulb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Si bisan kinsa nga makigdulog sa mananap pagapatyon gayod. ");
INSERT INTO cebulb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Si bisan kinsa nga mohalad ngadto sa laing dios gawas kang Yahweh pagalaglagon gayod. ");
INSERT INTO cebulb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ayaw ninyo limbongi o daogdaoga ang mga langyaw, kay mga langaw kamo sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ayaw ninyo daogdaoga ang mga balo o mga ilo. ");
INSERT INTO cebulb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kung sakiton ninyo sila sa bisan unsang paagi, ug kung makitabang sila kanako, paminawon ko gayod ang ilang pagpangaliyupo. ");
INSERT INTO cebulb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Magadilaab ang akong kasuko, ug patyon ko kamo pinaagi sa akong espada; ang inyong mga asawa mangabalo, ug ang inyong mga anak mangailo. ");
INSERT INTO cebulb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Kung magpautang kamo ug salapi sa akong katawhan diha kaninyo nga mga kabos, ayaw kamo sa patanto sama sa tigpautang o magpatubo ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kung kuhaon ninyo ang bisti sa inyong isigkatawo ingon nga panaad, ibalik mo kini sa dili pa mosalop ang adlaw, ");
INSERT INTO cebulb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kay mao lamang kini ang iyang pangtabon; mao kini ang iyang bisti alang sa iyang lawas. Unsa nalang man ang iyang katulgan? Kung motawag siya kanako, paminawon ko siya, kay ako maluluy-on man. ");
INSERT INTO cebulb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ayaw ako pasipad-i ang Dios, ni tunglohon ang magmamando sa inyong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ayaw ninyo ihikaw ang halad gikan sa inyong abot o sa pugaanan sa bino. Kinahanglan nga ihalad ninyo kanako ang kamagulangan ninyong anak nga mga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Buhaton usab ninyo kana sa inyong mga baka ug sa inyong mga karnero. Sulod sa pito ka adlaw magpabilin sila sa ilang mga inahan, apan sa ikawalo nga adlaw kinahanglan nga ihatag ninyo sila kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Mahimo kamong mga tawo nga gilain alang kanako. Busa dili kamo magakaon sa bisan unsang karne nga gikuniskunis sa mga mananap diha sa kapatagan. Hinuon, kinahanglan nga ilabay ninyo kini ngadto sa mga iro. ");
INSERT INTO cebulb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ayaw kamo pagbalita ug bakak mahitungod kang bisan kinsa. Ayaw pagtipon sa mga tawong daotan aron magsaksi ug bakak. ");
INSERT INTO cebulb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ayaw kamo pagpahiuyon sa panon sa katawhan nga nagabuhat ug daotan, ni magpamatuod kamo samtang tuison ang hustisya aron matuman ang panon sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ayaw dapigi ang tawong kabos kung husayon siya. ");
INSERT INTO cebulb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Kung makita ninyo ang torong baka o asno sa inyong kaaway nga nasaag, dad-a kini balik kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kung makita ninyo nga natumba ang asno sa usa ka tawo nga nagdumot kaninyo ug nadat-ugan sa iyang karga, ayaw biyai kanang tawhana. Kinahanglan tabangan ninyo siya uban ang iyang asno. ");
INSERT INTO cebulb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ayaw ninyo tuisa ang katarong kung kinahanglan unta maadto sa mga tawong kabos ang hukom sa husay. ");
INSERT INTO cebulb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ayaw pakig-ipon sa mga tawong nagabuhat ug bakak nga mga pasangil, ug ayaw patya ang walay sala o matarong, kay dili ko labanan ang daotan. ");
INSERT INTO cebulb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ayaw pagdawat ug suborno, kay ang suborno makabuta niadtong makakita, ug motuis sa matuod nga mga pulong sa mga tawo. ");
INSERT INTO cebulb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ayaw daogdaoga ang mga langyaw, sanglit nasayod man kamo sa kinabuhi sa langyaw, kay mga langyaw man kamo sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sulod sa unom ka tuig magapugas kamo sa inyong yuta ug magtigom sa abot niini. ");
INSERT INTO cebulb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Apan sa ikapito ka tuig biyai ninyo kini nga wala daroha ug wala atimana, aron nga ang mga kabos nga anaa uban sa inyong mga tawo makakaon. Sa ilang salin, makakaon usab ang ihalas nga mga mananap. Buhata usab ninyo kini sa inyong mga kaparasan ug kaolibohan. ");
INSERT INTO cebulb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sulod sa unom ka adlaw pagabuhaton ninyo ang inyong buluhaton, apan sa ikapito ka adlaw kinahanglan magpahulay kamo. Buhata kini aron nga makapahulay ang inyong torong baka ug asno, ug aron makapahulay ug mabaskog usab ang anak nga lalaki sa inyong ulipong babaye ug si bisan kinsa nga langyaw. ");
INSERT INTO cebulb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Pagmatngon sa tanan nga gisulti ko kaninyo. Ayaw isulti ang ngalan sa laing mga dios, ni madungog ang ilang mga ngalan gikan sa inyong baba. ");
INSERT INTO cebulb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Maglakaw kamo aron sa pagsaulog sa kasaulogan alang kanako makatulo sa matag tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Matngonan ninyo ang Kasaulogan sa Tinapay nga Walay Patubo. Ingon sa gimando ko kaninyo, magakaon kamo ug tinapay nga walay patubo sulod sa pito ka adlaw. Niadtong panahona, mag-atubang kamo kanako sa bulan sa Abib, nga gitakdo gayod niini nga katuyoan. Nga anaa niini nga bulan migawas kamo gikan sa Ehipto. Apan dili kamo moadto kanako nga walay dala. ");
INSERT INTO cebulb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Bantayan ninyo ang Kasaulogan sa Abot, ang unang bunga sa inyong mga paghago nga inyong gipugas sa inyong mga uma. Ug bantayan usab ninyo ang Kasaulogan sa Pagtapok sa kataposan sa tuig, sa dihang tigomon ninyo ang abot nga gikan sa inyong mga uma. ");
INSERT INTO cebulb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ang tanan ninyong mga lalaki mag-atubang kang Ginoong Yahweh makatulo sa matag tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ayaw gayod ninyo ihalad ang dugo gikan sa mga hinalad nga alang kanako uban ang tinapay nga adunay patubo. Ang tambok nga gikan sa mga halad diha sa akong kasaulogan kinahanglan dili ibilin nga mabuntagan. ");
INSERT INTO cebulb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Pagadad-on ninyo ang unang abot sa inyong yuta ngadto sa akong balay, sa balay ni Yahweh nga inyong Dios. Ayaw pagalat-i ang nating kanding gikan sa gatas sa inahan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Magpadala ako ug anghel diha sa inyong unahan aron sa pagbantay sa inyong dalan, ug aron sa pagdala kaninyo ngadto sa dapit nga akong giandam. ");
INSERT INTO cebulb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pamati kamo kaniya ug pagtuman kaniya. Ayaw siya hagita, kay dili kamo niya pasayloon sa inyong mga kalapasan. Ang akong ngalan anaa kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kung magtuman gayod kamo sa iyang tingog ug magbuhat sa tanan niyang isulti kaninyo, nan mamahimo akong kaaway sa inyong mga kaaway ug tigpanimalos sa mga nagapanimalos kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mag-una ang akong anghel kaninyo ug dad-on kamo ngadto sa mga Amonihanon, sa mga Hitihanon, sa mga Perisihanon, sa mga Canaanhon, sa mga Hibitihanon, ug sa mga Jebusihanon. Laglagon ko sila. ");
INSERT INTO cebulb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ayaw gayod kamo pagyukbo sa ilang mga dios, magsimba kanila, o magbuhat sa ilang gipangbuhat. Hinuon, laglagon ninyo sila sa hingpit ug dugmokon ang ilang mga haligi nga bato. ");
INSERT INTO cebulb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Magsimba kamo kang Yahweh nga inyong Dios, ug panalanginan niya ang inyong tinapay ug tubig. Ug pagawagtangon ko ang balatian diha kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Wala gayoy babaye nga dili makaanak o makuhaan sa inyong yuta. Lugwayan ko ang inyong kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ipadangat ko pag-una ang akong kahadlok ngadto sa kayutaan nga inyong adtoan. Patyon ko ang mga tawo nga inyong ikatagbo. Ipakalagiw ko ang inyong mga kaaway kaninyo tungod sa kahadlok. ");
INSERT INTO cebulb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Magpadala ako ug mga tambuboan sa inyong unahan nga maoy mopahawa sa mga Hibitihanon, mga Canaanhon, ug mga Hitihanon sa inyong atubangan. ");
INSERT INTO cebulb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Dili ko sila papahawaon sulod sa usa ka tuig, tungod kay mahimong biniyaan ang yuta, ug ang mga ihalas nga mga mananap managhan alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Hinuon, hinayhinay ko silang pagaabogon gikan sa inyong atubangan hangtod nga mamahimo kamong magmabungahon ug mapanunod ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Buhaton ko nga ang inyong utlanan moabot gikan sa Pulang Dagat ngadto sa Dagat sa mga Filistihanon, ug gikan sa kamingawan ngadto sa Suba sa Eufrates. Ihatag ko kaninyo ang kadaogan sa yuta nga pagapuy-an. Papahawaon ninyo sila diha sa inyong atubangan. ");
INSERT INTO cebulb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ayaw kamo pagpakigsaad kanila o sa ilang mga dios. ");
INSERT INTO cebulb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ayaw sila papuy-a sa inyong yuta, kay tingali makasala kamo batok kanako. Kung magsimba kamo sa ilang mga dios, mamahimo gayod kini nga inyong lit-ag.'” ");
INSERT INTO cebulb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Unya miingon si Yahweh kang Moises, “Tungas kamo nganhi kanako—ikaw, si Aaron, si Nadab, si Abihu, ug ang 70 ka mga kadagkoan sa Israel, ug simbaha ako samtang atua pa kamo sa halayo. ");
INSERT INTO cebulb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Si Moises lamang ang makaduol kanako. Kinahanglan nga dili magpaduol ang uban, o motungas ang katawhan uban kaniya.” ");
INSERT INTO cebulb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Giadto ni Moises ang katawhan ug gisuginlan sa tanang mga pulong ug sa mga kasugoan ni Yahweh. Nagdungan pagtubag ang tibuok katawhan ug miingon, “Tumanon namo ang tanan nga mga pulong nga giingon ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Unya gisulat ni Moises ang tanang mga pulong ni Yahweh. Sayo sa kabuntagon, gitukod ni Moises ang usa ka halaran didto sa tiilan sa bukid ug gihan-ay ang napulog duha ka dagkong bato nga daw haligi, aron nga ang mga bato magpaila sa napulog duha ka tribo sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Nagsugo siya ug pipila ka mga batan-ong lalaki nga Israelita aron mohalad sa mga halad sinunog ug mga halad sa pakigdait nga torong baka alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Gikuha ni Moises ang katunga sa dugo ug gibutang kini sa mga panaksan; unya gisablig niya ang laing katunga didto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Gikuha niya ang basahon sa Kasabotan ug gibasa kini sa makusog ngadto sa katawhan. Miingon sila, “Pagabuhaton namo ang tanan nga gisulti ni Yahweh. Magmatinumanon gayod kami.” ");
INSERT INTO cebulb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Unya gikuha ni Moises ang dugo ug gisablig kini ngadto sa katawhan. Miingon siya, “Mao kini ang dugo sa kasabotan nga gihimo ni Yahweh tali kaninyo pinaagi sa paghatag kaninyo niining panaad kauban niining tanang mga pulong.” ");
INSERT INTO cebulb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Unya mitungas sa bukid si Moises, si Aaron, si Nadab, si Abihu, ug ang 70 ka mga kadagkoan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Nakita nila ang Dios sa Israel. Sa iyang tiilan ang usa ka daw salog nga hinimo sa batong Safiro, sama ka hayag sa kalangitan. ");
INSERT INTO cebulb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ang Dios wala magbakyaw sa iyang kamot tungod sa kasuko batok sa mga kadagkoang mga Israelita. Nakita nila ang Dios, unya nangaon sila ug nanginom. ");
INSERT INTO cebulb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Miingon si Yahweh ngadto kang Moises, “Tungas nganhi kanako sa bukid ug pabilin didto. Ihatag ko kanimo ang mga papan nga bato nga akong gisulatan sa balaod ug sa mga kasugoan, aron matudloan mo sila.” ");
INSERT INTO cebulb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Busa mibiya si Moises uban ang iyang kaabag nga si Josue ug mitungas didto sa bukid sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Gisultihan nang daan ni Moises ang mga kadagkoan, “Pabilin dinhi ug paghulat hangtod nga makabalik kami dinhi kaninyo. Magpabilin uban kaninyo si Aaron ug si Hur. Kung adunay mga panagbingkil si bisan kinsa, paadtoa siya kanila.” ");
INSERT INTO cebulb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Busa mitungas si Moises sa bukid, ug natabonan kini sa panganod. ");
INSERT INTO cebulb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ang gamhanang himaya ni Yahweh mikunsad sa Bukid sa Sinai, ug mitabon ang panganod sa bukid sulod sa unom ka adlaw. Sa ikapitong adlaw gitawag niya si Moises gikan sa taliwala sa panganod. ");
INSERT INTO cebulb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ang dagway sa himaya ni Yahweh sama sa nagdilaab nga kalayo ibabaw sa bukid sa panan-aw sa mga Israelita. ");
INSERT INTO cebulb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Misulod si Moises sa panganod ug mitungas sa bukid. Nagpabilin siya didto sa bukid sulod sa 40 ka adlaw ug 40 ka gabii. ");
INSERT INTO cebulb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mingon si Yahweh kang Moises, ");
INSERT INTO cebulb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Sultihi ang mga Israelita nga magdala ug halad alang kanako gikan sa matag tawo nga manggihatagon. Kinahanglan kamo mao ang modawat niining mga halad alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Mao kini ang mga halad nga kinahanglan mong dawaton gikan kanila: bulawan, plata, bronse; ");
INSERT INTO cebulb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","asul, tapol, ug pula nga butang; pino nga lino; balahibo sa kanding; ");
INSERT INTO cebulb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","mga panit sa laking karnero nga tininaan ug pula ug panit sa mananap nga dugong; kahoy nga akasya; ");
INSERT INTO cebulb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ang lana alang sa mga lampara sa balay alampoanan; mga pahumot alang sa lanang igdidihog ug ang mahumot nga insenso; ");
INSERT INTO cebulb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mga bato nga onix ug ang ubang mahalon nga mga bato nga ibutang alang sa efod ug sa tabon sa dughan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Pabuhata sila ug usa ka balay alampoanan aron akong kapoy-an uban kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kinahanglan buhaton mo kini sumala sa mga plano nga akong ipakita kanimo alang sa tabernakulo ug alang sa tanang kasangkapan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Magahimo sila ug usa ka sudlanan gamit ang kahoy nga akasya. Ang gitas-on niini kinahanglan may 2 ug1/2 ka cubit; ang gilapdon niini may 1 ug 1/2 ka cubit; ug ang gihabugon 1 ug 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kinahanglan haklapan ninyo ug lunsayng bulawan ang sulod ug sa gawas niini, ug kinahanglan hal-opan ninyo ug bulawan ang kilid sa ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kinahanglan hulmahon ninyo ug upat ka liningin nga bulawan alang niini, ug ikabit kini sa upat ka tiil sa arka sa kasabotan, ang duha ka mga liningin sa pikas kilid, ug laing duha ka liningin sa pikas kilid usab. ");
INSERT INTO cebulb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kinahanglan buhaton ninyo ang dayonganan gamit ang kahoy nga akasya ug putoson ninyo kini ug bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Isuksok ninyo ang dayongan didto sa mga liningin nga nahimutang sa isigkakilid sa arka sa kasabotan, aron madayongan ang arka sa kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Kinahanglan ibilin ang mga dayonganan diha sa mga liningin sa arka sa kasabotan; dili nila kini tanggalon. ");
INSERT INTO cebulb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kinahanglan isulod ninyo sa arka sa kasabotan ang kasugoan nga akong ihatag kanimo. ");
INSERT INTO cebulb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kinahanglan himoon ninyo ang usa ka tabon gamit ang lunsay nga bulawan. Ang gitas-on niini kinahanglan 2 ug 1/2 ka cubit, ug ang gilapdon niini 1 ug 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kinahanglan hulmahon ninyo ang duha ka kerubim sa sinalsal nga bulawan alang sa isigkatumoy sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ibutang ang usa ka kerubim sa pikas tumoy sa tabon, ug ang laing kerubim sa laing tumoy. Kinahanglan himoon kini unay gayod sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kinahanglan ibukhad pataas sa kerubim ang ilang mga pako ug mapandungan nila ang tabon. Ang mga kerubim kinahanglan mag-atubang sa usag-usa ug modungaw sa tunga sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kinahanglan ibutang ninyo ang tabon ibabaw sa arka sa kasabotan, ug ibutang ninyo sa arka sa kasabotan ang kasugoan nga ihatag ko kanimo. ");
INSERT INTO cebulb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Makigkita ako kanimo didto sa arka sa kasabotan. Makigsulti ako kanimo gikan sa akong nahimutangan ibabaw sa tabon sa sudlanan. Makigsulti ako kanimo mahitungod sa tanang mga sugo nga ihatag ko kanimo alang sa mga Israelita diha sa taliwala sa duha ka kerubim nga nahimutang ibabaw sa arka sa kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kinahanglan himoon ninyo ang lamesa gamit ang kahoy nga akasya. Ang gitas-on niini kinahanglan duha ka cubit; ang gilapdon niini usa ka cubit, ug ang gihabugon usab niini 1 ug 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Putoson ninyo kini ug lunsay nga bulawan unya rebitihan ug bulawan ang palibot sa ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kinahanglan himoan ninyo kini ug rebiti nga may gilapdon nga usa ka dangaw, rebitihi ang palibot niini ug bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kinahanglan himoan ninyo kini ug upat ka liningin nga bulawan alang sa tabla ug ikabit ang upat ka mga liningin diha sa upat ka mga eskina, nga nahimutangan sa upat ka mga tiil sa lamesa. ");
INSERT INTO cebulb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ang mga liningin kinahanglan makabit sa rebiti aron kasuksokan sa mga dayongan, aron madayongan ang lamesa. ");
INSERT INTO cebulb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kinahanglan himoon ninyo ang mga dayongan gamit ang kahoy nga akasya ug putoson kini ug bulawan aron madayongan nila kini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Himoon ninyo ang mga plato, mga kutsara, mga tibod, ug mga panaksan nga gamiton pangbubo sa halad nga ilimnon. Kinahanglan himoon ninyo kini gamit ang lunsay nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kinahanglan ibutang ninyo kanunay ang tinapay diha sa lamesa nga anaa sa akong atubangan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Kinahanglan maghimo ka ug tungtonganan sa lampara nga sinalsal gikan sa lunsay nga bulawan. Pagahimoon ang tungtonganan sa lampara uban ang patunganan ug ang lawas niini. Ang mga kupa sa lampara, ang mga dahondahon niini, ug ang bulakbulak niini himoon ang tanan nga unay sa lawas niini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ang unom ka mga sanga kinahanglan maglabaw pataas gikan sa isigkakilid niini—ang tulo ka sanga molabaw gikan sa usa ka kilid niini, ug ang laing tulo ka sanga molabaw sa laing kilid niini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ang una nga sanga kinahanglan adunay hinimo nga tulo ka kupa nga daw sama sa mga bulak sa almendras, uban ang dahondahon nga tungtonganan ug ang bulakbulak, ug sa lain nga sanga himoa ang tulo ka kupa nga daw sama sa mga bulak sa almendras uban ang dahondahon ug mga bulakbulak. Kinahanglan mahisama ang tanang unom ka mga sanga nga naglabaw sa tungtonganan sa lampara. ");
INSERT INTO cebulb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ang maong tungtonganan sa lampara, ang lawas nga anaa sa tunga, kinahanglan adunay upat ka hinimong kupa nga daw sama sa mga bulak sa almendras, uban ang mga dahondahon sa ilalom sa lawas sa sanga ug ang mga bulakbulak. ");
INSERT INTO cebulb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kinahanglan adunay dahondahon sa ilalom sa unang pares sa mga sanga—nga unay paghimo niini, ug mga dahondahon sa ilalom sa ikaduhang pares sa sanga—nga unay gihapon sa paghimo niini. Sama gihapon niini ang ikatulong pares sa sanga, kinahanglan nga adunay mga dahondahon sa ilalom sa sanga nga unay gihapon sa paghimo niini. Kinahanglan managsama kining unom ka sanga nga gipasanga gikan sa tungtonganan sa lampara. ");
INSERT INTO cebulb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ang ilang mga dahondahon sa ilalom ug ang mga sanga kinahanglan unay paghimo sa sinalsal nga lunsay nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kinahanglan himoon ninyo ang tungtonganan sa lampara nga may pito ka mga lampara ug itaod ang mga lampara aron makahatag kini ug kahayag. ");
INSERT INTO cebulb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ang mga sipit ug ang mga butangan niini kinahanglan hinimo sa lunsay nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Gamita ang usa ka talent sa lunsay nga bulawan aron sa paghimo sa tungtonganan sa lampara ug sa mga dayandayan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Buhata gayod kini sumala sa sumbanan nga akong gipakita kanimo didto ibabaw sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Kinahanglan buhaton ninyo ang tabernakulo nga may napulo ka tabil nga hinimo sa pino nga lino ug linubid nga asul, tapul, ug pula nga bordahan sa dagway sa kerubim. Pagabuhaton kini sa hanas nga tigbuhat. ");
INSERT INTO cebulb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ang gitas-on sa matag tabil kinahanglan 28 ka cubit, ug ang gilapdon niini upat ka cubit. Kinahanglan ang tanan nga mga tabil managsama gayod ang sukod. ");
INSERT INTO cebulb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kinahanglan sumpaysumpayon sa pagtahi ang lima ka mga tabil, ug sama usab ang buhaton sa laing lima ka mga tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kinahanglan himoon ninyo ang mga liningin nga asul nga ibutang sa tumoy sa tabil sa matag hut-ong. Sa samang paagi, buhaton usab ninyo ang susamang han-ay sa liningin sa ikaduhang hut-ong sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Buhata ninyo ang 50 ka mga liningin sa unang tabil, ug buhata ang dugang 50 ka mga liningin sa tumoy sa ikaduhang hut-ong sa tabil. Buhata kini aron mag-atbangay ang mga liningin sa usag-usa. ");
INSERT INTO cebulb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kinahanglan buhaton ninyo ang 50 ka mga kaw-itanan nga bulawan ug isumpay ang mga tabil aron masumpay ang tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kinahanglan buhaton ninyo ang mga tabil gikan sa balahibo sa kanding alang sa atop sa tabernakulo. Kinahanglan himoon ninyo ang napulog usa nga mga tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ang gitas-on sa matag tabil kinahanglan nga 30 ka cubit, ug ang gilapdon sa tabil may upat ka cubit. Kinahanglan managsama ang sukod sa napulog duha nga mga tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kinahanglan sumpaysumpayon ninyo pagtahi ang lima ka mga tabil ug ilahi ang laing unom ka mga tabil. Kinahanglan piloon ninyo kaduha ang ikaunom nga tabil diha sa atubangan sa tolda. ");
INSERT INTO cebulb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kinahanglan nga buhaton ninyo ang 50 ka buok nga mga liningin sa tumoy sa daplin sa unang hut-ong sa tabil, ug ang dugang 50 ka mga liningin sa tumoy sa daplin sa tabil nga mosumpay sa ikaduhang hut-ong sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kinahanglan buhaton ninyo ang 50 ka mga kaw-itanan nga bronse ug ibutang ngadto sa mga liningin. Unya isumpay ang sidsid sa tolda aron mausa kini. ");
INSERT INTO cebulb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ang nabilin nga katunga sa tabil, nga maoy nagbitay nga nahibilin sa tabil sa tolda, kinahanglan ipabitay didto dapit sa likod sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kinahanglan adunay usa ka cubit sa pikas tabil, ug laing usa ka cubit sa tabil nga anaa sa pikas bahin—nga mao ang sobra sa gitas-on sa tabil sa tolda kinahanglan ipabitay lapas sa isigkakilid sa mga tabernakulo aron pagtabon niini ug ngadto sa laing bahin, aron matabonan kini. ");
INSERT INTO cebulb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kinahanglan buhaton ninyo ang atop alang sa tabernakulo gamit ang panit sa laking karnero nga gitina ug pula, ug ang laing maayong panit nga iatop ibabaw niana. ");
INSERT INTO cebulb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Kinahanglan maggabas kamo ug tul-id nga tabla gikan sa kahoy nga akasya alang sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ang gitas-on sa matag tabla kinahanglan nga napulo ka cubit, ug ang gilapdon niini 1 ug 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kinahanglan nga adunay duha ka ugsok sa matag tabla aron masumpay sa matag tabla. Kinahanglan buhaton ninyo ang tanang tabla sa tabernakulo sa sama niining paagiha. ");
INSERT INTO cebulb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Sa dihang buhaton ninyo ang mga tabla alang sa tabernakulo, kinahanglan nga maggabas kamo ug 20 ka mga tabla alang sa habagatang bahin. ");
INSERT INTO cebulb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kinahanglan buhaton ninyo ang 40 ka mga sukaranan nga plata nga ipailalom sa 20 ka mga tabla. Kinahanglan nga adunay duha ka sukaranan sa ilalom sa unang tabla aron mopugong, ug duha usab ka sukaranan ilalom sa ubang mga tabla aron mosangga sa duha ka haligi. ");
INSERT INTO cebulb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Alang sa ikaduhang bahin sa tabernakulo, didto sa amihanan, kinahanglan maggabas kamo ug 20 ka mga tabla ");
INSERT INTO cebulb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ug ang ilang 40 ka mga sukaranan nga plata. Kinahanglan may duha ka sukaranan sa unang tabla, duha ka sukaranan ilalom sa sunod nga tabla, ug sa uban pa. ");
INSERT INTO cebulb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Alang sa likod nga bahin sa tabernakulo didto sa kasadpan, kinahanglan maggabas kamo ug unom ka mga tabla. ");
INSERT INTO cebulb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kinahanglan magbuhat kamo ug duha ka mga tabla alang sa likod nga mga eskina sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kinahanglan nga mabulag kining mga tabla sa ubos, apan itakdo kini sa ibabaw sa samang liningin. Kinahanglan mao usab kini ang pamaagi sa luyo nga bahin sa mga eskina. ");
INSERT INTO cebulb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kinahanglan may walo ka mga tabla, uban sa ilang mga sukaranan nga plata. Kinahanglan nga adunay 16 tanan ka mga sukaranan, may duha ka sukaranan sa ilalom sa unang tabla, duha ka sukaranan sa ilalom sa sunod nga tabla, ug sa uban pa. ");
INSERT INTO cebulb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Kinahanglan buhaton ninyo ang mga pangbabag gamit ang kahoy nga akasya—lima alang sa mga tabla sa usa ka kilid sa tabernakulo, ");
INSERT INTO cebulb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lima ka pangbabag alang sa mga tabla sa laing kilid sa tabernakulo, ug ang lima ka mga pangbabag alang sa mga tabla sa luyo nga bahin sa tabernakulo didto sa kasadpan. ");
INSERT INTO cebulb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ang pangbabag nga anaa sa tunga sa mga tabla, nga naggikan sa tungatunga kinahanglan mosangko sa isigkatumoy. ");
INSERT INTO cebulb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kinahanglan putoson ninyo ug bulawan ang mga tabla. Buhata ninyo ang liningin nga bulawan, aron kasuksokan sa mga pangbabag, unya putosa ug bulawan ang mga dayongan. ");
INSERT INTO cebulb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Kinahanglan tukoran ninyo ang tabernakulo pinaagi sa pagsunod sa plano nga gipakita kanimo ibabaw sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Kinahanglan buhaton ninyo ang usa ka tabil sa linubid nga asul, tapol, ug pula, ug sa pino nga lino, nga binurdahan sa hulagway sa kerubim, nga hinimo sa hanas nga tigburda. ");
INSERT INTO cebulb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kinahanglan ipakabit ninyo kini sa upat ka haligi sa kahoy nga akasya nga hinaklapan ug bulawan. Kining mga haligi kinahanglan nga adunay mga kaw-itanan nga bulawan nga gitungtong ibabaw sa upat ka plata nga mga sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ipakabit ninyo ang tabil ilalom sa mga kaw-itanan, ug kinahanglan ipasulod ninyo ang arka sa kasabotan. Ang tabil mao ang mag-ulang sa balaang dapit ug sa labing balaang dapit. ");
INSERT INTO cebulb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Itabon ninyo ang tabon ibabaw sa arka sa kasabotan, nga atua sa labing balaang dapit. ");
INSERT INTO cebulb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ipahimutang ninyo ang lamesa gawas sa tabil. Kinahanglan ipahimutang ninyo ang tungtonganan sa lampara atbang sa lamesa sa habagatang bahin sa tabernakulo. Ang lamesa kinahanglan atua sa amihanang dapit. ");
INSERT INTO cebulb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Kinahanglan maghimo kamo ug tabil alang sa agianan sa tolda. Kinahanglan buhaton ninyo kini gikan sa mga linubid nga asul, sa tapul, ug pula ug linubid nga pinong lino, nga binuhat sa usa ka tigburda. ");
INSERT INTO cebulb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Alang sa mga tabil, kinahanglan maggabas kamo ug lima ka mga haligi nga akasya ug putoson kini ug bulawan. Ang mga kaw-itanan niini kinahanglan nga bulawan usab, ug hulmahon ninyo ang lima ka sukaranan nga bronse alang niini. ");
INSERT INTO cebulb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Paghimo kamo ug halaran nga akasya, nga lima ka cubit ang gitas-on ug lima ka cubit ang gilapdon. Ang halaran kinahanglan kwadrado ug tulo ka cubit ang gihabugon. ");
INSERT INTO cebulb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Butangi kini ug sungaysungay sa upat ka eskina nga sama sa sungay sa torong baka. Ang sungaysungay kinahanglan himoon unay gihapon sa halaran, ug haklapi kini ug bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Paghimo kamo ug mga kasangkapan alang sa halaran: ang sudlanan sa abo, ug ang mga pala, ang mga panaksan, ang mga tinidor alang sa karne, ug ang sudlanan sa baga. Himoa ninyo kining mga kasangkapan gamit ang bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Himoa ang rehas nga bronse alang sa halaran. Himoa ang mga liningin nga bronse alang sa upat ka eskina sa rehas. ");
INSERT INTO cebulb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kinahanglan ibutang ninyo ang rehas sulod sa halaran gikan sa tungatunga niini hangtod sa ubos. ");
INSERT INTO cebulb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Himoa ninyo ang mga dayonganan alang sa halaran, gamit ang kahoy nga akasya, ug kinahanglan haklapan ninyo kini ug bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Isuksok ang dayonganan sa mga liningin, ug ang dayonganan kinahanglan ipahimutang sa isigkakilid nga bahin sa halaran aron madayongan kini. ");
INSERT INTO cebulb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kinahanglan himoon nimo ang halaran nga may haw-ang, gamit ang mga tabla. Kinahanglan himoon mo kini sa pamaagi nga gipakita kanimo didto ibabaw sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Kinahanglan himoon ninyo ang hawanan alang sa tabernakulo. Kinahanglan adunay mga tabil sa habagatang bahin sa hawanan, mga tabil sa pinong lino nga linubid nga may gitas-on nga 100 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ang mga tabil kinahanglan adunay 20 ka haligi, uban sa 20 ka bronse nga sukaranan. Kinahanglan usab nga adunay mga kaw-itanan nga ibutang sa haligi, ug lakip na ang mga hikot nga plata. ");
INSERT INTO cebulb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Sama usab sa amihanang bahin, kinahanglan adunay tabil nga 100 ka cubit ang gitas-on uban sa 20 ka mga haligi, 20 ka mga bronse nga sukaranan, mga kaw-itanan nga gibutang sa haligi, ug ang mga hikot nga hinimo sa plata. ");
INSERT INTO cebulb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Diha sa hawanan sa kasadpang bahin kinahanglan adunay tabil nga 50 ka cubit ang gitas-on. Kinahanglan adunay napulo ka mga haligi ug napulo ka mga sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ang hawanan usab sa sidlakang bahin kinahanglan 50 ka cubit ang gitas-on. ");
INSERT INTO cebulb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ang mga tabil sa pikas kilid sa pultahan, kinahanglan may gitas-on nga 50 ka cubit. Kinahanglan adunay tulo ka haligi ug tulo ka sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Sa pikas kilid usab kinahanglan adunay mga tabil nga 15 ka cubit ang gitas-on. Kinahanglan aduna usab kini tulo ka haligi ug tulo ka sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Diha sa pultahan sa hawanan kinahanglan ang tabil may gitas-on nga 20 ka cubit. Ang tabil kinahanglan hinimo sa pinong lino nga panapton nga asul, tapul, ug pula nga hinimo sa tigburda. Kinahanglan adunay kini upat ka haligi uban sa upat ka sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ang tanan nga haligi sa hawanan kinahanglan adunay mga hikot nga plata, mga kaw-itanan nga palata, ug mga sukaran nga bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ang gitas-on sa hawanan kinahanglan 100 ka cubit, 50 ka cubit ang gilapdon, ug lima ka cubit ang gihabugon uban ang pinong linong panapton nga mga tabil, ug mga sukaranan nga bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ang tanan nga mga kasangkapan nga gamiton sa tabernakulo, ug ang tanang ugsok sa tolda alang sa tabernakulo ug sa hawanan kinahanglan hinimo sa bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Kinahanglan nga sugoon mo ang mga Israelita sa pagdala ug lunsayng lana sa olibo, ug gipuga, alang sa mga suga aron makasiga sa kanunay. ");
INSERT INTO cebulb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Diha sa tolda nga tagboanan, sa gawas sa tabil nga atua atubangan sa tabernakulo nga gisudlan sa arka sa kasabotan, si Aaron ug ang iyang mga anak kinahanglan magpasiga sa kanunay sa suga diha sa atubangan ni Yahweh, ssukad sa pagkagabii hangtod sa pagkabuntag. Kini nga kasugoan magpadayon hangtod sa mosunod pa nga kaliwatan sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ipatawag si Aaron nga imong igsoon ug ang iyang mga anak nga lalaki nga si Nadab, si Abihu, si Eleazar ug si Itamar gikan sa mga Israelita aron mag-alagad sila kanako ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kinahanglan himoan nimo si Aaron, nga imong igsoon, ug bisti nga gilain alang kanako. Kini nga mga bisti alang sa iyang dungog ug himaya. ");
INSERT INTO cebulb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kinahanglan makigsulti ka sa tanang tawo nga mga maalamon, kadtong akong gipuno sa espiritu sa kaalam, aron makatahi sila ug mga bisti alang kang Aaron aron ilain siya alang kanako sa pag-alagad kanako ingon nga akong pari. ");
INSERT INTO cebulb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ang himoon nila nga mga bisti mao ang tabon sa dughan, ang efod, ang kupo, ang pangsapaw nga binurdahan, ang purong ug ang bakos. Kinahanglan tahion nila kini nga mga bisti nga linain alang kanako. Alang kini sa imong igsoon nga si Aaron ug sa iyang mga anak nga lalaki aron moalagad sila kanako ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ang mga tigburda kinahanglan mogamit ug pinong lino nga dalag, asul, tapul, ug pula. ");
INSERT INTO cebulb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Kinahanglan himoon nila ang efod sa dalag, asul, tapul, ug pula ngalinubid, ug sa pinong lino nga linubid usab. Himoon gayod kini sa hanas nga tigburda. ");
INSERT INTO cebulb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kinahanglan aduna kini duha ka bahin sa abaga nga mosumpay sa duha ka tumoy niini. ");
INSERT INTO cebulb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ang maayong pagkalubid nga bakos kinahanglan sama sa bakos nga unay gihapon sa efod, nga hinimo sa linubid nga pinong lino nga dalag, asul, tapul, ug pula. ");
INSERT INTO cebulb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Pagkuha ug duha ka bato nga onix ug ikulit ang mga ngalan sa napulo ug duha ka mga anak ni Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Kinahanglan isulat ninyo ang unom ka ngalan sa usa ka bato ug ang laing unom ka ngalan isulat sa ikaduhang bato, subay sa ilang adlaw nga natawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Pinaagi sa paghimo sa tigkulit sa bato nga sama sa pagkulit sa usa ka singsing nga silyo, kinahanglan ikulit ninyo diha sa duha ka bato ang mga ngalan sa napulo ug duha ka mga anak nga lalaki ni Israel. Ipatapot kining mga batoha sa pilitanan nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kinahanglan ibutang ninyo ang duha ka bato diha sa abagahan sa efod, aron kini nga mga bato magpahinumdom kang Yahweh sa mga anak nga lalaki ni Israel. Dad-on ni Aaron diha sa iyang abaga ang ilang ngalan sa atubangan ni Yahweh ingon nga pagpahinumdom kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kinahanglan himoon ninyo ang pilitanan gamit ang bulawan ");
INSERT INTO cebulb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ug duha ka kadena nga lunsayng bulawan nga sama sa higot, ug ipakabit ang mga kadena sa pilitanan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Kinahanglan himoon ninyo ang tabon sa dughan alang sa pagpakisayod, ang trabaho sa hanas nga tigburda, nga gitahi sama sa efod. Himoa kini gamit ang linubid nga dalag, asul, tapul ug pula, ug pinong lino. ");
INSERT INTO cebulb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kinahanglan kwadrado kini ug piloa sa makaduha ang tabon sa dughan. Kinahanglan usa ka span ang gitas-on ug usa ka span ang gilapdon. ");
INSERT INTO cebulb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kinahanglan ibutang ninyo dinhi ang upat ka laray sa bililhong mga bato. Ang unang laray kinahanglan mao ang rubi, ang topas, ug ang garnet. ");
INSERT INTO cebulb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ang ikaduhang laray kinahanglan mao ang esmeralda, ang safiro, ug ang diamante. ");
INSERT INTO cebulb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ang ikatulo nga laray kinahanglan mao ang hasinto, ang agata, ug ang ametis. ");
INSERT INTO cebulb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ang ikaupat nga laray kinahanglan mao ang berilo, ang onix, ug ang haspe. Kinahanglan ipatapot kini sa pilitanan nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kinahanglan nakahan-ay ang mga bato sumala sa ngalan sa napulo ug duha ka mga anak nga lalaki ni Israel, ang matag usa niini nahan-ay sumala sa ngalan. Kinahanglan sama kini sa pagkulit sa pangsilyo, ang matag ngalan nagpasabot sa usa sa napulog duha ka mga tribo. ");
INSERT INTO cebulb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Kinahanglan maghimo kamo diha sa tabon sa dughan ug kadena nga sama sa hikot, sinalapid nga hinimo sa lunsayng bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kinahanglan himoon usab ninyo ang duha ka singsing nga bulawan alang sa tabon sa dughan ug ibutang kini sa duha sa isig ka tumoy sa tabon sa dughan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kinahanglan ikabit ninyo ang duha ka kadenang bulawan sa duha ka eskina sa tabon sa dughan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ikabit ninyo ang laing tumoy sa duha ka sinalapid nga kadena diha sa duha ka pilitanan. Unya kinahanglan ikabit usab ninyo sa abagahan sa efod sa dapit sa atubangan. ");
INSERT INTO cebulb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kinahanglan himoon ninyo ang dugang duha ka singsing nga bulawan, ug ibutang ninyo kini sa laing duha ka mga eskina sa tabon sa dughan, ubos sa kilid nga duol sa sulod nga sidsid. ");
INSERT INTO cebulb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kinahanglan himoon ninyo ang dugang duha ka singsing nga bulawan, ug ikabit kini sa ubos sa duha ka abagahan nga bahin sa atubangan sa efod, duol sa ibabaw nga dapit sa pinong linubid nga bakos sa efod. ");
INSERT INTO cebulb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kinahanglan ihikot nila ang mga singsing sa tabon sa dughan ngadto sa mga singsing sa efod gamit ang asul nga higot, aron masumpay kini ibabaw sa bakos sa efod. Gihimo kini aron nga dili matangtang ang tabon sa dughan gikan sa efod. ");
INSERT INTO cebulb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Sa dihang mosulod si Aaron sa balaang dapit, kinahanglan dad-on niya ang ngalan sa mga Israelita ibabaw sa iyang dughan aron sa pagpakisayod, ingon nga padayon sa pagpahinumdom kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ibutang ninyo ang Urim ug ang Tumim diha sa tabon sa dughan alang sa pagpakisayod, nga kinahanglan anaa sa ibabaw sa dughan ni Aaron sa dihang moadto siya sa atubangan ni Yahweh. Kanunay dad-on ni Aaron diha sa iyang dughan ang pamaagi sa paghukom alang sa katawhan sa Israel didto sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Kinahanglan tahion ninyo ang kupo sa efod sa lunlon tapul nga panapton. ");
INSERT INTO cebulb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kinahanglan aduna kini liab diha sa tunga alang sa ulo. Kinahanglan tahion ang palibot sa kilid sa liab niini aron dili kini magisi. Kinahanglan himoon kini sa tigtahi. ");
INSERT INTO cebulb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sa ubos nga sidsid, kinahanglan burdahan ninyo kini ug mga bunga sa granada sa linubid nga asul, tapul, ug pula. Kinahanglan ipataliwala usab ang kampanilyang bulawan sa palibot niini. ");
INSERT INTO cebulb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kinahanglan adunay usa ka kampanilyang bulawan ug usa ka bunga sa granada, ug usa na usab ka kampanilyang bulawan ug usa ka bunga sa granada ug padayonon kini nga pagkahan-ay palibot sa sidsid sa kupo. ");
INSERT INTO cebulb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Isul-ob ni Aaron ang kupo sa dihang mag-alagad siya, ug aron madungog ang tingog niini sa dihang mosulod siya sa balaang dapit sa atubangan ni Yahweh ug sa iyang paggawas. Himoon kini aron dili siya mamatay. ");
INSERT INTO cebulb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Kinahanglan himoon ninyo ang medalyon nga bulawan nga ibutang sa purong ug kuliti kini, sama sa nakakulit sa usa ka silyo, “Balaan alang kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kinahanglan ihikot ninyo kining medalyon gamit ang asul nga hikot sa atubangan sa purong. ");
INSERT INTO cebulb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Kinahanglan anaa kini sa agtang ni Aaron; dalaon niya kanunay ang bisan unsang sala nga madala ngadto sa halad sa balaang mga gasa nga gilain sa mga Israelita alang kang Yahweh. Isul-ob niya kanunay sa iyang agtang ang purong aron dawaton ni Yahweh ang ilang mga gasa. ");
INSERT INTO cebulb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Kinahanglan himoon ninyo ang pangsapaw ug ang purong gamit ang pinong lino. Burdahi usab ninyo ang bakos nga trabaho sa tigburda. ");
INSERT INTO cebulb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Himoa ninyo ang mga pangsapaw, mga bakos, ug mga purong sa mga anak nga lalaki ni Aaron alang sa ilang dungog ug himaya. ");
INSERT INTO cebulb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Sul-obi si Aaron nga imong igsoon, ug ang iyang mga anak nga lalaki uban kaniya. Kinahanglan dihogi sila, gahinon, ug balaana alang kanako, aron mag-alagad sila kanako ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Kinahanglan himoan ninyo sila ug linong pangbahag nga bisti nga pang-ilalom aron motabon sa ilang pagkahubo, nga magtabon kanila gikan sa hawak hangtod sa paa. ");
INSERT INTO cebulb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Kinahanglan isul-ob nila kini nga mga bahag sa dihang mosulod sila sa tolda nga tagboanan o moduol na sila halaran sa pag-alagad didto sa balaang dapit. Kinahanglan buhaton nila kini aron dili sila mahimong sad-an kay kung dili mamatay gayod sila. Mao kini ang balaod nga dili mausab alang kang Aaron ug sa mga kaliwatan nga mosunod kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Karon mao kini ang kinahanglan nga imong pagabuhaton sa paglain kanila alang kanako aron mag-alagad sila kanako ingon nga mga pari. Pagkuha ug laking nating baka ug duha ka laking karnero nga walay daot, ");
INSERT INTO cebulb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","tinapay ug torta nga walay igpapatubo, nga sinagulan ug lana. Pagkuha usab ug nipis nga tinapay nga walay igpapatubo nga gipahiran sa lana. Paghimo ug nipis nga tinapay gamit ang pinong harina sa trigo. ");
INSERT INTO cebulb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Kinahanglan ibutang ninyo kini sa usa ka bukag, dad-a kini nga sinulod sa bukag ug ihalad uban sa laking nating baka ug duha ka laking karnero. ");
INSERT INTO cebulb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kinahanglan dad-on mo si Aaron ug ang iyang mga anak nga lalaki ngadto sa pultahan sa tolda nga tagboanan ug kinahanglan hugasan mo sila ug tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kuhaon mo ang bisti ug ipasul-ob kang Aaron ang pangsapaw nga bisti, ang kupo sa efod, ug ang tabon sa dughan, ug ipabakos ang maayong pagkaburda nga bakos sa palibot sa iyang efod. ");
INSERT INTO cebulb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kinahanglan purongi siya ug ibutang ang balaang korona diha sa purong. ");
INSERT INTO cebulb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Unya kuhaa ang lana nga igdidihog ug ibubo sa iyang ulo, ug niini nga paagi dihogi siya. ");
INSERT INTO cebulb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Dad-a ang iyang mga anak nga lalaki ug ipasul-ob kanila ang mga pangsapaw nga bisti. ");
INSERT INTO cebulb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Bakosi si Aaron ug ang iyang mga anak nga lalaki ug sul-obi silag mga purong sa ulo. Maila ang buluhaton sa pagkapari pinaagi sa balaod nga dili mausab. Niining paagiha imong balaanon si Aaron ug ang iyang mga anak nga lalaki aron mag-alagad sila kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Kinahanglan dad-on mo ang tanang laking nating baka sa atubangan sa tolda nga tagboanan, ug itapion ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo niini. ");
INSERT INTO cebulb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Kinahanglan ihawon ninyo ang laking nating baka sa atubangan ni Yahweh sa pultahan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Pagkuha ug diyutay nga dugo sa laking nating baka ug ipahid sa sungaysungay sa halaran pinaagi sa imong tudlo, ug kinahanglan nga ibubo mo ang nahibiling dugo sa sukaranan sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kinahanglan kuhaon mo ang tanang tambok nga nagtabon sa mga tinai, ug kuhaa usab ang nagtabon sa atay ug sa duha ka kidni uban ang tambok nga uban usab niini. Sunoga kining tanan ibabaw sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Apan alang sa unod sa laking nating baka, lakip ang panit niini ug ang hugaw, kinahanglan sunogon nimo kini gawas sa kampo. Mao kini ang halad alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Kinahanglan kuhaon mo usab ang usa ka laking karnero ug itapion ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo niini. ");
INSERT INTO cebulb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kinahanglan ihawon mo ang laking karnero, ug salora ang dugo niini ug isablig kini sa tanang kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Hiwaa ang laking karnero ug hugasi ang mga tinai niini ug ang mga paa niini, ug kinahanglan ibutang mo ang mga tinai sa halaran, uban ang mga hiniwa niini lakip na ang ulo. ");
INSERT INTO cebulb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Unya sunoga ang tibuok laking karnero. Mao kini ang halad sinunog alang kang Yahweh, mahumot nga halad nga gisunog alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kuhaa usab ang laing laking karnero ug itapion usab ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo niini. ");
INSERT INTO cebulb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Unya ihawa ang laking karnero ug kuhaa ang ubang dugo niini. Ipahid kini sa tuong tumoy sa dalunggan ni Aaron ug sa iyang mga anak nga lalaki, ug sa ilang kumagko sa tuong kamot, ug sa kumagko sa ilang tuong tiil. Unya isablig ang dugo sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kinahanglan kuhaon mo ang dugo nga anaa sa halaran ug diyutay nga lanang igdidihog, ug iwisikwisik kining tanan kang Aaron ug sa iyang mga bisti, ug sa iyang mga anak nga lalaki ug sa ilang mga bisti usab. Unya ilain si Aaron alang kanako, maingon man ang iyang mga bisti, ug ang iyang mga anak nga lalaki ug ang ilang mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Kinahanglan kuhaon mo ang tambok sa laking karnero, ang tambok sa ikog, ang tambok nga nagputos sa mga tinai, ang tambok nga nagputos sa atay, ang tambok nga nagputos sa duha ka kidni, ug ang tambok sa tuong paa—kini nga laking karnero alang sa pagbalaan sa mga pari alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Pagkuha ug usa ka buok tinapay, usa ka torta nga tinapay nga gilanahan, ug usa ka nipis nga tinapay gikan sa bukag sa tinapay nga walay igpapatubo nga anaa sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kinahanglan ibutang mo kini sa mga kamot ni Aaron ug sa mga kamot sa iyang mga anak nga lalaki ug iwarawara kini nga halad alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Unya kuhaa ang pagkaon gikan sa ilang mga kamot ug sunoga kini diha sa halaran uban sa sinunog nga halad. Makahatag kini kanako ug kahumot; mahimo kining halad nga gisunog. ");
INSERT INTO cebulb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kinahanglan kuhaon mo ang dughan nga bahin sa gihalad nga laking karnero alang kang Aaron ug iwarawara kini ingon nga halad nga iwarawara alang kang Yahweh, ug mao kini ang imong bahin. ");
INSERT INTO cebulb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Kinahanglan ilain mo alang kanako ang dughan nga bahin sa halad nga giwarawara, ug ang paa nga mao ang bahin alang sa mga pari lakip na ang dughan nga bahin nga giwarawara ug ang paa nga gigahin alang kang Aaron ug sa iyang mga anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mao kini ang dili mausab nga balaod alang kang Aaron ug sa iyang mga anak nga lalaki. Mao usab kini ang ihatag sa mga Israelita ngadto kang Yahweh gikan sa ilang halad sa pakigdait. ");
INSERT INTO cebulb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Kinahanglan tipigan usab ang balaang mga bisti ni Aaron alang sa iyang mosunod pang mga anak nga lalaki. Pagadihogan ug ibalaan sila alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ang mopuli kaniya nga pari gikan sa iyang mga anak nga lalaki, nga mosulod sa tolda nga tagboanan aron moalagad kanako diha sa balaang dapit, mao ang mosul-ob usab niadtong mga bisti sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Kinahanglan kuhaon mo ang laking karnero alang sa paghalad sa mga pari alang kanako ug lat-i ang karne niini diha sa balaang dapit. ");
INSERT INTO cebulb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Si Aaron ug ang iyang mga anak nga lalaki kinahanglan mokaon sa unod sa laking karnero ug sa tinapay nga anaa sa bukag diha sa pultahan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kinahanglan kaonon nila ang karne ug ang tinapay nga gihatag alang sa kapasayloan sa ilang mga sala ug sa pagbalaan kanila, aron malain alang kanako. Walay laing makakaon sa maong pagkaon, tungod kay gibalaan kini alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kung adunay mabilin sa mga karne sa halad sa pagbalaan, o bisan ang tinapay hangtod pagkabuntag, nan kinahanglan sunogon mo kini. Kinahanglan dili kini kaonon tungod kay gilain kini alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Niining paagiha, pinaagi sa pagsunod ninyo sa tanan nga akong gimando nga inyong pagabuhaton, kinahanglan imong gahinan si Aaron ug ang iyang mga anak nga lalaki. Sulod sa pito ka adlaw kinahanglan andamon mo sila. ");
INSERT INTO cebulb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Matag adlaw kinahanglan maghalad kamo ug torong baka ingon nga halad alang sa kapasayloan sa sala. Hinloi ang halaran pinaagi sa pagbalaan niini, ug kinahanglan dihogan mo kini aron malain kini alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sulod sa pito ka adlaw putlion mo ang halaran ug ilain kini alang kang Yahweh. Unya ang halaran malain sa hingpit alang kanako. Ang bisan unsang makasaghid niini ilhon nga linain alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Kinahanglan ihalad mo ibabaw sa halaran matag adlaw sa tanang panahon ang duha ka nating karnero nga nagpanuigon ug usa ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kinahanglan maghalad ka ug usa ka nating karnero sa buntag, ug ang laing usa sa hapon. ");
INSERT INTO cebulb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Uban sa unang nating karnero, ihalad usab ang ikapulo sa usa ka epha sa labing pinong harina nga gisagol sa 1/4 nga bahin sa usa ka hin sa lana gikan sa pinuga nga olibo, ug ang 1/4 nga bahin sa usa ka hin sa bino ingon nga usa ka halad nga ilimnon. ");
INSERT INTO cebulb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kinahanglan ihalad mo ang ikaduhang nating karnero sa pagsalop sa adlaw. Ihalad mo usab ang samang trigo nga gihalad pagkabuntag ug ang halad nga ilimnon. Makahatag kini ug kahumot alang kanako; mao kini ang halad nga gisunog alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Kinahanglan mao kini kanunay ang halad sinunog hangtod sa tanan ninyong mga kaliwatan, diha sa pultahan sa tolda nga tagboanan sa atubangan ni Yahweh, kung asa ako makigtagbo ug makigsulti kanimo. ");
INSERT INTO cebulb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mao kana ang dapit nga makigtagbo ako sa mga Israelita; ibalaan ko ang tolda pinaagi sa akong himaya. ");
INSERT INTO cebulb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Lainon ko ang tolda nga tagboanan ug ang halaran nga alang lamang kanako. Lainon ko usab si Aaron ug ang iyang mga anak nga lalaki aron nga mag-alagad kanako ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mopuyo ako uban sa mga Israelita ug mahimong ilang Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Masayod sila nga ako si Yahweh, ang ilang Dios, nga nagpagawas kanila gikan sa yuta sa Ehipto aron makapuyo uban kanila. Ako mao si Yahweh, nga ilang Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Kinahanglan magbuhat kamo ug halaran nga sunoganan sa insenso. Buhata kini gamit ang kahoy nga akasya. ");
INSERT INTO cebulb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ang gitas-on niini kinahanglan usa ka cubit ug ang gilapdon niini usa ka cubit. Kuwadrado kini, ug ang gihabugon niini kinahanglan duha ka cubit. Ug ang mga sungaysungay niini kinahanglan buhaton unay sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kinahanglan haklapan ninyo ug lunsayng bulawan ang halaran nga insenso - ang ibabaw niini, ang mga isigkakilid, ug ang mga sungaysungay niini. Kinahanglan rebitihan ninyo ug bulawan ang palibot niini. ");
INSERT INTO cebulb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Buhatan ninyo ug duha ka mga liningin nga bulawan aron ipakabit kini ilalom sa duha ka nag-atbang nga mga kilid. Ang mga liningin kinahanglan mao ang kabitanan sa mga dayonganan aron dayongan ang halaran. ");
INSERT INTO cebulb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kinahanglan buhaton ninyo ang dayonganan gamit ang kahoy nga akasya, ug haklapi kini ug bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kinahanglan ipahimutang ninyo ang halaran nga insenso diha sa atubangan sa tabil nga anaa sa kilid sa arka sa kasabotan. Ipahimutang kini atubangan sa may tabon nga anaa ibabaw sa arka sa kasabotan, kung asa ako makigtagbo kanimo. ");
INSERT INTO cebulb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kinahanglan adlaw-adlaw sunogon ni Aaron ang mahumot nga insenso. Sunogon niya kini sa takna nga palungon na niya ang mga lampara, ");
INSERT INTO cebulb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ug pasigahon na usab ni Aaron ang mga lampara sa panahon sa kagabhion aron masunog sa kanunay ang insenso diha sa atubangan ni Yahweh, hangtod sa tibuok pa ninyong mga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Apan kinahanglan wala gayod kamoy laing insenso nga ihalad sa halaran sa insenso, ni ang bisan unsang halad nga sunogonon o ang mga pagkaon nga ihalad. Ayaw usab ninyo buboi sa halad ilimnon ang ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kinahanglan kausa matag tuig buhaton ni Aaron ang seremonyas sa pagtabon diha sa mga sungaysungay niini. Gamit ang dugo nga halad sa sala buhaton niya ang seremonyas sa pagtabon alang niini kausa matag tuig hangtod sa sunod pa ninyong mga kaliwatan. Linain gayod kini alang kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Gisultihan ni Yahweh si Moises, ");
INSERT INTO cebulb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Sa dihang sugdan mo na sa paglista ang mga Israelita, ang tagsatagsa ka tawo kinahanglang mobayad ug usa ka lukat sa iyang kinabuhi kang Yahweh. Buhaton mo kini human mo sila maihap, aron walay katalagman nga modangat kanila sa pag-ihap mo kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ang tanang tawo nga maihap diha sa listahan magbayad ug tunga sa shekel nga plata, sumala sa timbangan sa shekel nga atua sa balay alampoan (ang usa ka shekel sama ra sa 20 ka gerahs). Kining tunga nga shekel mao ang halad alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ang tanang tawo nga maihap nga nagpanuigon ug 20 ka tuig pataas, kinahanglan maghalad niini alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Sa dihang ang katawhan maghatag kanako sa halad alang sa kapasayloan sa sala sa ilang kinabuhi, ang dato kinahanglan dili magbayad ug sobra sa tunga ka shekel, ug ang kabos dili usab magbayad ug kulang. ");
INSERT INTO cebulb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kinahanglan dawaton mo gikan sa mga Israelita kining salapi sa kapasayloan sa sala ug gastoha kini sa buluhaton diha sa tolda nga tagboanan. Kinahanglan mahimo kining pahinumdom sa mga Israelita diha sa akong atubangan, aron mapasaylo ang sala sa inyong kinabuhi.” ");
INSERT INTO cebulb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Gisultihan usab ni Yahweh si Moises, ");
INSERT INTO cebulb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kinahanglan buhaton usab ninyo ang usa ka dakong panaksan nga bronse nga may tungtonganan nga bronse, usa ka dakong panaksan nga hugasanan. Ipahimutang ninyo kini tungatunga sa tolda nga tigomanan ug sa halaran, unya butangan ninyo kini ug tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Si Aaron ug ang iyang mga anak nga lalaki kinahanglan manghugas sa ilang mga kamot ug mga tiil sa tubig niini. ");
INSERT INTO cebulb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Sa higayon nga mosulod sila sa tolda nga tagboanan o mopaduol sa halaran aron moalagad kanako sa pagsunog sa mga halad, kinahanglan manghugas sila sa tubig aron dili sila mangamatay. ");
INSERT INTO cebulb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Kinahanglan hugasan nila ang ilang mga kamot ug mga tiil aron dili sila mangamatay. Mao kini ang tulumanon nga sundon gayod ni Aaron ug sa iyang mga kaliwatan hangtod sa mosunod pang kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Gisultihan ni Yahweh si Moises, ");
INSERT INTO cebulb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Pagkuhag labing maayong mga pahumot: 500 ka shekels sa nagtubod nga mira, 250 ka shekel sa humot nga sinamon, 250 ka shekel sa humot nga cane, ");
INSERT INTO cebulb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 ka shekel nga casia, nga gitimbang pinaagi sa sukdanan sa shekel nga atua sa balay alampoanan, ug usa ka hin nga lana sa olibo (ang hin sama ra sa 3. 7 ka litro nga lana sa olibo). ");
INSERT INTO cebulb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kinahanglan buhaton ninyo ang sagdradong lanang igdidihog gamit kining mga pansagol nga maoy buluhaton sa tigbuhat sa mga pahumot. Mao kini ang sagdradong lanang igdidihog nga gilain alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kinahanglan imong dihogan niining lanaha ang tolda nga tigomanan, lakip na ang arka sa kasabotan, ");
INSERT INTO cebulb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ang lamesa ug ang tanang mga kasangkapan niini, ang tungtonganan sa lampara ug ang mga galamiton niini, ang halaran nga insenso, ");
INSERT INTO cebulb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ang halaran alang sa halad nga sunogonon uban ang tanang galamiton niini, ug ang panaksan uban ang tungtonganan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ihalad kini aron mabalaan kini alang kanako. Ang bisan unsang mga butang nga makasaghid niini mabalaan usab. ");
INSERT INTO cebulb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Kinahanglan dihogan mo usab si Aaron ug ang iyang mga anak nga lalaki ug balaana sila aron mag-alagad kanako ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kinahanglan isulti mo kini sa mga Israelita, 'Mao kini ang lanang igdidihog nga gilain kang Yahweh ingon man sa umaabot pa nga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Dili kini angay ihaplas sa panit sa mga tawo, ni magbuhat kamo ug lana nga sama niini uban ang samang pagsagol, tungod kay gibalaan na kini alang kang Yahweh. Kinahanglan ilhon ninyo kini sa ingon niini nga pamaagi. ");
INSERT INTO cebulb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Busa si bisan kinsa ang magbuhat ug pahumot sama niini, o modihog niini kang bisan kinsa, kanang tawhana kinahanglan hinginlan gikan sa iyang katawhan.'” ");
INSERT INTO cebulb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Gisultihan ni Yahweh si Moises, “Pagkuhag mga pahumot nga may samang gidaghanon - estakte, onika, ug galbanum - mga mahumot nga pahumot uban ang lunsayng insenso. ");
INSERT INTO cebulb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Gamita kini sa pagbuhat sa insenso, nga gisagol sa usa ka tigbuhat sa mga pahumot, nga tinimplahan sa asin nga lunsay ug sagrado. ");
INSERT INTO cebulb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Galinga kini nga pino gayod. Ibutang ang uban niini atubangan sa arka sa kasabotan nga atua sulod sa tolda nga tigomanan, kung asa ako makigtagbo kanimo. Angay ninyo kining ilhon nga balaan gayod kaayo alang kanako, ");
INSERT INTO cebulb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Alang niining insenso nga inyong buhaton, ayaw kamo pagbuhat uban sa samang mga pansagol alang sa inyong kaugalingon. Kinahanglan ilhon ninyo kini nga balaan. ");
INSERT INTO cebulb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Si bisan kinsa ang magbuhat ug sama niini nga pahumot, kinahanglan hinginlan gikan sa iyang katawhan.” ");
INSERT INTO cebulb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Gisultihan ni Yahweh si Moises, ");
INSERT INTO cebulb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Tan-awa, gipili ko si Bezalel ang anak nga lalaki ni Uri nga anak ni Hur, gikan sa tribo ni Juda. ");
INSERT INTO cebulb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Gipuno ko si Bezalel sa akong Espiritu aron hatagan siya ug kaalam, kahibalo, ug hiyas alang sa tanang matang sa buhat, ");
INSERT INTO cebulb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","aron buhaton ang maanindot nga mga disinyo gamit ang bulawan, ang tumbaga, ug ang bronse; ");
INSERT INTO cebulb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ang pagputol usab ug pagpili sa mga bato ug mga kinulit nga kahoy - aron magbuhat sa tanang matang sa mga buhat. ");
INSERT INTO cebulb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Dugang kaniya, gipili ko usab si Oholiab ang anak nga lalaki ni Ahisamac, gikan sa tribo ni Dan. Gihatagan ko sa kahanas ang tanang kasingkasing niadtong mga maalamon aron nga buhaton nila ang tanan nga gisugo kong ipabuhat kanimo. Apil na niini ");
INSERT INTO cebulb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ang tolda nga tigomanan, ang arka sa kasabotan, ang tabon sa arka sa kasabotan, ug ang tanang kasangkapan sa tolda - ");
INSERT INTO cebulb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ang lamesa ug mga kasangkapan niini, ang lunsayng tungtonganan sa lampara uban ang mga galamiton niini, ang halaran nga insenso, ");
INSERT INTO cebulb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ang halaran alang sa mga halad nga sunogonon uban sa mga galamiton niini, ug ang dakong panaksan uban ang tungtonganan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Lakip na usab niini ang maayong pagkabuhat nga mga bisti - ang sagradong bisti alang sa pari nga si Aaron ug sa iyang mga anak nga lalaki, nga gilain alang kanako aron mag-alagad sila kanako ingon mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Lakip usab niini ang lanang igdidihog ug ang humot nga insenso alang sa balaang dapit. Kining mga tighimo kinahanglan mobuhat niining mga butanga subay gayod sa gisugo ko kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Gisultihan ni Yahweh si Moises, ");
INSERT INTO cebulb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Sultihi ang mga Israelita: 'Kinahanglan bantayan ninyo ang Adlawng Igpapahulay ni Yahweh, kay mao kini ang timaan tali kaniya ug kaninyo hangtod sa mosunod pa ninyong mga kaliwatan aron masayran ninyo nga siya mao gayod si Yahweh, nga nagpili kaninyo alang sa iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Busa kinahanglan ninyong bantayan ang Adlawng Igpapahulay, kay kinahanglan balaanon ninyo kini, nga gitagana alang kaniya. Ang tanang tawo nga mosupak niini kinahanglan gayod patyon. Si bisan kinsa nga magtrabaho sa Adlawng Igpapahulay, kanang tawhana pagahinginlan gayod gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ang mga buluhaton buhaton sulod sa unom ka adlaw, apan sa ikapitong adlaw mao ang Adlawng Igpapahulay, balaan, ug gitaga alang sa pagpasidungog kang Yahweh. Si bisan kinsa ang magtrabaho sa Adlawng Igpapahulay kinahanglan gayod patyon. ");
INSERT INTO cebulb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Busa ang mga Israelita kinahanglan magbantay gayod sa Adlawng Igpapahulay. Kinahanglan sundon nila kini hangtod sa mosunod pa nilang mga kaliwatan ingon nga balaod nga dili na gayod mausab. ");
INSERT INTO cebulb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ang Adlawng Igpapahulay mao kanunay ang timaan tali kang Yahweh ug sa mga Israelita, kay sulod sa unom ka adlaw gibuhat ni Yahweh ang langit ug ang yuta, ug sa ikapito nga adlaw mipahulay siya ug nabaskog.'” ");
INSERT INTO cebulb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sa natapos na si Yahweh sa pagpakigsulti kang Moises didto sa Bukid sa Sinai, gihatag niya kaniya ang duha ka papan sa kasabotan sa mga balaod nga hinimo sa mga bato, nga sinulat niya mismo. ");
INSERT INTO cebulb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sa pagkakita sa katawhan nga nadugay si Moises sa paglugsong gikan sa bukid, nangadto sila kang Aaron ug miingon, “Dali ngari, buhati kami ug usa ka diosdios nga maoy mangulo alang kanamo. Kay alang niining Moises, ang tawo nga nagpagawas kanamo sa Ehipto, wala na kami masayod sa nahitabo kaniya” ");
INSERT INTO cebulb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Busa miingon si Aaron kanila, “Panguhaa ang mga ariyos nga bulawan sa inyong mga asawa, sa inyong mga anak nga lalaki ug babaye, ug dad-a kini nganhi kanako.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Gipatangtang sa tibuok katawhan ang mga ariyos nga bulawan ug gidala kini kang Aaron. ");
INSERT INTO cebulb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gidawat niya ang bulawan gikan kanila, gitunaw kini diha sa hulmahan, ug gihulmang usa ka nating baka. Unya miingon ang katawhan, “O Israel, mao kini ang inyong dios nga nagpagawas kaninyo gikan sa yuta sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Sa pagkakita ni Aaron niini, gibuhat niya ang usa ka halaran atubangan sa nating baka ug nagpahibalo; miingon siya, “Ugma mao ang kasaulogan sa pagpasidungog kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nangmata ang katawhan sayo sa kabuntagon ug naghalad sa mga halad sinunog ug ang mga halad sa panaghiusa. Unya nanglingkod sila aron sa pagpangaon ug sa pag-inom, ug nanindog aron sa pagpatuyang sa hilabihan nga paglipaylipay. ");
INSERT INTO cebulb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Unya gisultihan ni Yahweh si Moises, “Pagdali, kay ang imong katawhan kansang gipagawas mo gikan sa yuta sa Ehipto nagpakahugaw sa ilang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Gitalikdan dayon nila ang paagi nga gisugo ko alang kanila. Gihulma nila ang usa ka nating baka alang sa ilang kaugalingon, unya gisimba kini ug naghalad alang niini. Miingon sila, 'O Israel, mao kini ang dios nga nagpagawas kaninyo gikan sa yuta sa Ehipto.'” ");
INSERT INTO cebulb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Unya gisultihan ni Yahweh si Moises, “Nasayran ko na kining katawhan. Tan-awa, mga gahi gayod ug ulo kining mga tawhana. ");
INSERT INTO cebulb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Busa karon, ayaw ako pakganga. Ang akong kasuko mosilaob batok kanila, busa laglagon ko gayod sila. Unya buhaton ko ang usa ka dakong nasod gikan kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Apan gisulayan ni Moises paghupay si Yahweh nga iyang Dios, Miingon siya, “O Yahweh, nganong misilaob man ang imong kasuko batok sa imong katawhan, nga gipagawas mo gikan sa yuta sa Ehipto uban ang dakong gahom ug ang kusgan nga kamot? ");
INSERT INTO cebulb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nganong kinahanglan man mosulti ang mga Ehiptohanon, 'Gipagawas niya sila nga may daotang tinguha, aron pamatyon sila sa kabungtoran ug aron laglagon sila sa kalibotan?' Ayaw na padayona ang pagpasilaob sa imong kasuko ug ayaw na pahamtangi ug silot ang imong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Hinumdomi si Abraham, si Isaac, ug si Israel nga imong mga sulugoon, nga imong gipanumpaan ug miingon kanila, 'Padaghanon ko ang inyong kaliwatan sama kadaghan sa kabituonan sa langit, ug ihatag ko sa inyong mga kaliwatan kining mga yuta nga akong gisulti. Mapanunod kini nila hangtod sa kahangtoran.'” ");
INSERT INTO cebulb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Unya wala na gipahamtang ni Yahweh ang silot nga iyang gisulti nga ipahamtang sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Unya mibiya si Moises ug milugsong sa bukid nga nagbitbit sa duha ka papan nga bato sa kasabotan sa mga balaod. Gisulatan ang isigkakilid sa duha ka papan nga bato, maingon man usab sa atubangan usab ug sa likod niini. ");
INSERT INTO cebulb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ang mga papan nga bato hinimo mismo sa Dios, ug ang mga sinulat gisulat usab sa Dios, nga kinulit diha sa mga papan nga bato. ");
INSERT INTO cebulb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Sa pagkadungog ni Josue sa kaguliyang sa katawhan sa ilang pagpaninggit, miingon siya kang Moises, “Adunay kagahob nga ingon sa gubat sulod sa kampo.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Apan miingon si Moises, “Dili kana kagahob sa kadaogan, ug dili kagahob sa napildi nga katawhan, kondili kagahob sa panag-awit ang akong nadungog.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Sa nagkaduol na si Moises sa kampo, nakita na niya ang nating baka ug ang panagsayaw sa katawhan. Hilabihan ang iyang kasuko. Gibusdak niya ang duha ka papan nga bato ug nabungkag kini diha sa tiilan sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Gikuha niya ang nating baka nga gihimo sa katawhan, gidaoban kini, gidugmok, ug gisagol sa tubig. Unya gipainom niya kini sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Unya miingon si Moises kang Aaron, “Unsa man ang gihimo niining katawhan kanimo, nga giangin mo man sila niining dakong sala?” ");
INSERT INTO cebulb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Miingon si Aaron, “Ayaw palabi sa imong kasuko, akong agalon. Nasayod ka bitaw niining mga tawhana, kung unsa gayod nila ka gusto ang pagbuhat ug daotan. ");
INSERT INTO cebulb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Miingon sila kanako, 'Buhati kami ug usa ka dios nga maoy mangulo alang kanamo. Kay alang niining Moises, ang tawo nga nagpagawas kanamo sa Ehipto, wala na kami masayod sa nahitabo kaniya.' ");
INSERT INTO cebulb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Busa miingon ako kanila, 'Si bisan kinsang tawo nga may mga bulawan, tangtanga kini.' Gihatag nila ang mga bulawan ug giitsa ko kini sa kalayo, ug mitungha kining nating baka.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nakita ni Moises nga dili na mapugngan ang katawhan (kay gipasagdan sila ni Aaron, nga maoy hinungdan nga gibugalbugalan sila sa ilang mga kaaway). ");
INSERT INTO cebulb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Unya mibarog si Moises sa agianan sa kampo ug miingon, “Kinsa katong dapig kang Yahweh, duol kanako.” Miduol kaniya ang tanang mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Miingon siya kanila, “Si Yahweh ang Dios sa Israel, nag-ingon niini: 'Ang tagsatagsa ka tawo kinahanglan magtakin sa ilang espada ug lukopon sa pagsuroy ang tibuok agianan sa tibuok kampo, ug pamatyon ang iyang igsoong lalaki, ang iyang kaubanan, ug ang iyang silingan.'” ");
INSERT INTO cebulb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Gituman sa mga Levita ang gisugo ni Moises. Niadto gayong adlawa 3, 000 ka mga tawo ang nangamatay. ");
INSERT INTO cebulb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Miingon si Moises sa mga Levita, “Karon gitugahan kamo nga moalagad kang Yahweh, kay ang tagsatagsa kaninyo nagpatay man batok sa iyang anak nga lalaki ug sa iyang igsoong lalaki, busa gipanalanginan kamo ni Yahweh karong adlawa.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Pagkasunod adlaw miingon si Moises sa katawhan, “Nakabuhat kamo ug usa ka dakong nga sala. Karon motungas ako ngadto kang Yahweh. Tingali mahimo ko pa ang pagtabon alang sa inyong sala.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mibalik si Moises kang Yahweh ug miingon, “O kining katawhan nakabuhat ug usa ka dakong sala ug gibuhat nila ang usa ka diosdios nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Apan karon, pasayloa intawon ang ilang mga sala; kung dili ka makapasaylo, papasa ako sa talaan nga imong gisulat.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Gisultihan ni Yahweh si Moises, “Si bisan kinsa ang nakasala batok kanako, kanang tawhana mao ang papason ko sa akong talaan. ");
INSERT INTO cebulb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Busa karon lakaw, pangulohi ang katawhan didto sa dapit nga gisulti ko kanimo. Ania, ang akong mga anghel magagiya kaninyo. Apan sa umaabot nga adlaw nga silotan ko sila, pagasilotan ko gayod sila tungod sa ilang mga sala.” ");
INSERT INTO cebulb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Unya gipadad-an ni Yahweh ug katalagman ang katawhan tungod kay gihimo nila ang nating baka, kadtong gibuhat ni Aaron. ");
INSERT INTO cebulb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nakigsulti si Yahweh kang Moises, “Biya gikan dinhi, ikaw ug ang katawhan nga imong gipagawas gikan sa yuta sa Ehipto. Lakaw ngadto sa yuta nga akong gisaad kang Abraham, kang Isaac, ug kang Jacob, sa dihang miingon ako, 'Ihatag ko kini sa imong mga kaliwatan.' ");
INSERT INTO cebulb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Magpadala ako ug anghel nga mag-una kaninyo, ug papahawaon ko ang mga Canaanhon, mga Amonihanon, mga Hitihanon, mga Perisihanon, mga Hivitihanon, ug mga Jebusihanon. ");
INSERT INTO cebulb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Adto niana nga yuta, diin nagadagayday ang gatas ug dugos apan dili ako mouban kaninyo, tungod kay mga gahi kamo ug ulo nga katawhan. Tingali ug malaglag ko kamo diha sa dalan.” ");
INSERT INTO cebulb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Sa dihang nadungog sa katawhan kining makahahadlok nga mga pulong, nagsubo sila, ug walay nagsul-ob kanila ug mga alahas. ");
INSERT INTO cebulb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Miingon si Yahweh kang Moises, “Sultihi ang mga Israelita, “Gahi gayod kamog ulo nga katawhan. Kung mouban ako kaniyo bisan sa usa lamang ka higayon, tingali ug malaglag ko gayod kamo. Busa karon, tangtanga ang inyong mga alahas aron nga makahukom ako kung unsa ang akong buhaton kaninyo.”' ");
INSERT INTO cebulb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Busa wala na gayod magsul-ob ug mga alahas ang mga Israelita gikan sa Bukid sa Horeb ug ngadto pa sa unahan. ");
INSERT INTO cebulb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Gidala ni Moises ang usa ka tolda ug gipatindog kini gawas sa kuta, nga layolayo gamay gikan sa kampo. Gitawag niya kini nga tolda nga tagboanan. Si bisan kinsa ang magpakisayod kang Yahweh alang sa bisan unsang butang mogawas ug moadto sa tolda nga tagboanan, didto sa gawas sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Sa panahon nga moadto si Moises sa maong tolda, motindong ang tanang katawhan sa gawas sa agianan sa ilang mga tolda ug motan-aw kang Moises hangtod nga makasulod siya. ");
INSERT INTO cebulb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Sa higayon nga makasulod na si Moises sa maong tolda, ang haligi sa panganod mokanaog ug mopahimutang sa agianan sa tolda, ug makigsulti si Yahweh ngadto kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Sa dihang makita sa tanang katawhan ang haligi sa panganod nga mopahimutang sa agianan sa tolda, manindog sila ug mosimba ang matag tawo didto sa ilang kaugalingong agianan sa tolda. ");
INSERT INTO cebulb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Makigsulti si Yahweh ngadto kang Moises sa nawong ug nawong, sama sa usa ka tawo nga nakigsulti sa iyang higala. Unya mobalik si Moises ngadto sa kampo, apan ang iyang sulugoong batan-on nga si Josue ang anak nga lalaki ni Nun, magpabilin sa tolda. ");
INSERT INTO cebulb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Miingon si Moises kang Yahweh, “Tan-awa, nagasulti ka kanako, 'Dad-a kining katawhan sa ilang pagpanaw,' apan wala mo ako pahibaloa kung kinsa ang imong paubanon kanako. Miingon ka, 'Nailhan ko ang imong ngalan, ug nakakaplag ka usab ug kalooy sa akong panan-aw.' ");
INSERT INTO cebulb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Karon kung nakakaplag ako ug kalooy sa imong panan-aw, ipakita kanako ang imong mga dalan aron maila ko ikaw ug magpadayon nga makakaplag ug kalooy sa imong panan-aw. Hinumdomi nga kini nga nasod imong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mitubag si Yahweh, “Ang akong presensya magauban kanimo, ug hatagan ko ikaw ug kapahulayan.” ");
INSERT INTO cebulb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Miingon si Moises kaniya, “Kung dili mag-uban kanamo ang imong presensya, ayaw kami palakwa gikan dinhi. ");
INSERT INTO cebulb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kay unsaon man pagkasayod nga nakakaplag ako ug kalooy sa imong panan-aw, ako ug ang imong katawhan? Dili lamang kini, kung mouban ka kanamo maipakita nga lahi kami, ako ug ang imong katawhan gikan sa ubang katawhan nga anaa sa ibabaw sa kalibotan?” ");
INSERT INTO cebulb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Miingon si Yahweh kang Moises, “Buhaton ko usab kining butang nga imong gihangyo, tungod kay nakakaplag ka man ug kalooy sa akong panan-aw, ug nailhan ko ang imong ngalan.” ");
INSERT INTO cebulb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Miingon si Moises, “Palihog pakit-a ako sa imong himaya. ");
INSERT INTO cebulb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Miingon si Yahweh, “Palabayon ko sa imong atubangan ang tanan ko nga pagkamaayo, ug isulti ko ang akong ngalan diha sa imong atubangan nga 'ako si Yahweh'. Magmahigugmaon ako ngadto sa akong higugmaon, ug magmaluluy-on ako niadtong akong kaloy-an. ");
INSERT INTO cebulb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Apan miingon si Yahweh, “Dili ka makakita sa akong dagway, tungod kay wala gayoy makakita kanako nga mabuhi. ");
INSERT INTO cebulb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Miingon si Yahweh, “Tan-awa, ania kining dapit nga duol kanako; motindog ka niini nga bato. ");
INSERT INTO cebulb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Samtang molabay ang akong himaya, ibutang ko ikaw sa lungag sa bato ug tabonan ko ikaw sa akong kamot hangtod nga makalabay na ako. ");
INSERT INTO cebulb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Unya kuhaon ko ang akong kamot, ug makita mo ang akong likod, apan dili makita ang akong dagway.” ");
INSERT INTO cebulb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Miingon si Yahweh ngadto kang Moises, “Pagputol ug duha ka papan nga bato sama sa nauna nga mga papan. Isulat ko niining mga papan ang mga pulong nga nahisulat sa unang papan, ang papan nga imong gibuak. ");
INSERT INTO cebulb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pangandam ugma sa buntag ug tungas didto sa Bukid sa Sinai, ug pagpakigkita kanako didto ibabaw sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Walay motungas uban kanimo. Ayaw tugoti si bisan kinsa nga motaak sa bisan asang bahin sa maong bukid. Walay mga karnero o mga baka nga manibsib bisan sa atubangan sa bukid. ");
INSERT INTO cebulb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Busa nagputol si Moises ug duha ka papan nga bato sama niadtong nahauna, ug unya mibangon siya sayo sa kabuntagon, ug mitungas sa Bukid sa Sinai, sumala sa gisugo ni Yahweh kaniya. Gibitbit ni Moises ang papan nga bato. ");
INSERT INTO cebulb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mikanaog si Yahweh sa panganod ug mibarog didto uban kang Moises, ug gilitok niya ang ngalan nga “Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Milabay si Yahweh sa atubangan ni Moises ug nagmantala sa iyang ngalan “Si Yahweh, si Yahweh, ang Dios nga maluluy-on ug mahigugmaon, dili daling masuko, ug puno sa matinud-anong kasabotan ug masaligan, ");
INSERT INTO cebulb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","nagatuman sa matinud-anong kasabotan alang sa liboan ka mga kaliwatan, mapasayloon sa mga kasaypanan, sa mga kalapasan, ug sa mga kasal-anan. Apan dili niya pasagdan ang sad-an. Kay tungod sa sala sa mga amahan silotan niya ang ilang mga kaanakan ug ngadto sa mga kaapohan, hangtod sa ikatulo ug ngadto pa sa ikaupat nga mga kaliwatan.” ");
INSERT INTO cebulb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mihapa dayon si Moises sa yuta ug misimba. ");
INSERT INTO cebulb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Unya miingon siya, “Kung nakakaplag ako karon ug kalooy sa imong panan-aw, O akong Ginoo, palihog uban kanamo, tungod kay kining katawhan mga gahi ug ulo. Pasayloa ang among kasaypanan ug ang among sala, ug angkona kami ingon nga imong panulondon.” ");
INSERT INTO cebulb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Miingon si Yahweh, “Tan-awa, pagahimoon ko na ang kasabotan. Sa atubangan sa tanan nimong katawhan, buhaton ko ang mga katingalahan nga wala pa nahimo sa tibuok kalibotan ni sa bisan asa nga nasod. Ang tanang katawhan nga uban kanimo makakita sa akong mga buhat, tungod kay makalilisang kining butang nga akong pagabuhaton diha kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tumana ang akong mga gimando kaninyo karong adlawa. Sa dili madugay papahawaon ko na sa inyong atubangan ang mga Amorihanon, mga Canaanhon, mga Hitihanon, mga Perisihanon, mga Hevitihanon, ug mga Jebusihanon. ");
INSERT INTO cebulb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Pag-amping nga dili kamo maghimo ug kasabotan tali sa mga lumolupyo sa yuta nga inyong pagaadtoan, kay mahimo silang lit-ag diha kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Hinuon, kinahanglan nga gun-obon ninyo ang ilang mga halaran, dugmoka ang ilang mga haligi nga bato, ug tumbaha ang ilang mga haligi nga Ashera. ");
INSERT INTO cebulb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tungod kay wala kamoy laing Dios nga simbahon, tungod kay si Yahweh, kansang ngalan nga abughoan, mao ang Dios nga abughoan. ");
INSERT INTO cebulb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Busa pag-amping nga dili kamo maghimo ug kasabotan tali sa mga lumolupyo sa maong yuta, tungod kay maghimo sila ug pakighilawas alang sa ilang mga dios, ug maghalad sila ngadto sa ilang dios. Unya ang usa kanila modapit kaninyo ug mokaon kamo sa pipila sa ilang mga halad, ");
INSERT INTO cebulb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ug unya ipaasawa pa gani ninyo ang pipila sa ilang mga anak nga babaye ngadto sa inyong mga anak nga lalaki, ug ang iyang mga anak nga babaye magahimo sa inyong mga anak nga lalaki nga makighilawas alang sa ilang mga dios. ");
INSERT INTO cebulb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ayaw paghimo ug dios alang sa inyong kaugalingon gikan sa tinunaw nga puthaw. ");
INSERT INTO cebulb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Kinahanglan nga inyong tumanon ang Kasaulogan sa Tinapay nga walay Patubo. Ingon nga ako nagmando kaninyo, kaon kamo sa tinapay nga walay patubo sulod sa pito ka adlaw sa insaktong panahon sa bulan sa Abid, tungod kay sa bulan sa Abid nakalingkawas kamo gikan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Akoa ang tanang kamagulangang anak, bisan pa man ang unang anak nga laki sa inyong mga baka, ang mga kanding ug mga karnero. ");
INSERT INTO cebulb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Kinahanglan nga lukaton ninyo ang panganay nga asno pinaagi sa pag-ilis ug nating karnero, apan kung dili ninyo kini lukaton, kinahanglan nga balion ninyo ang liog niini. Kinahanglan nga lukaton ninyo ang tanan ninyong kamagulangang mga anak nga lalaki. Walay tawo nga moanhi kanako nga walay dala. ");
INSERT INTO cebulb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Motrabaho kamo sulod sa unom ka adlaw, apan sa ikapito nga adlaw kinahanglan mopahulay kamo. Bisan pa sa adlaw sa tingdaro ug sa ting-ani, kinahanglan mopahulay kamo. ");
INSERT INTO cebulb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Kinahanglan bantayan ninyo ang Kasaulogan sa mga Simana uban ang unang abot sa inaning trigo, kinahanglan nga bantayan ninyo ang Kapistahan sa Pagpanigom sa kataposan sa tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tulo ka higayon sa usa ka tuig kinahanglan nga inyong ipakita ang tanang kalalakin-an sa atubangan ni Yahweh nga Ginoo, ang Dios sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Tungod kay papahawaon ko sa inyong atubangan ang kanasoran ug dugangan ko ang inyong mga utlanan. Walay mangandoy sa pag-angkon sa inyong yuta ingon nga ilang gipanag-iya sa dihang mopakita kamo sa atubangan ni Yahweh nga inyong Dios makatulo sa usa ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Kinahanglan nga dili ninyo ihalad ang dugo sa akong halad uban ang bisan unsa nga igpapatubo, ni mabuntagan ang bisan unsang karne nga masalin gikan sa halad sa Kasaulogan sa Pagsaylo. ");
INSERT INTO cebulb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Kinahanglan nga inyong dad-on ang labing maayo nga unang mga bunga gikan sa inyong kaumahan ngadto sa akong templo. Kinahanglan nga dili ninyo lat-an ang nating kanding gamit ang gatas sa iyang inahan.” ");
INSERT INTO cebulb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Miingon si Yahweh kang Moises, “Isulat kini nga mga pulong, tungod kay ipanaad ko kini nga mga pulong nga akong isulti, ug maghimo ug kasabotan tali kanimo ug sa Israel.” ");
INSERT INTO cebulb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Didto si Moises uban kang Yahweh sulod sa 40 ka mga adlaw ug mga gabii; wala siya mikaon ug bisan unsa nga pagkaon ni miinom ug tubig. Gisulat niya diha sa mga papan nga bato ang mga pulong sa kasabotan, ang napulo ka mga kasugoan. ");
INSERT INTO cebulb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sa mikanaog na si Moises gikan sa Bukid sa Sinai dala ang duha ka papan nga bato sa kasugoan nga anaa sa iyang mga kamot, wala siya masayod nga ang iyang dagway nahimong sulaw samtang nakigsulti sa Dios. ");
INSERT INTO cebulb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Sa pagkakita ni Aaron ug sa mga Israelita kang Moises, midan-ag ang iyang dagway, ug nangahadlok sila nga moduol kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Apan gipangtawag sila ni Moises, unya si Aaron ug ang tanang pangulo sa katawhan miduol kaniya. Unya nakigsulti si Moises ngadto kanila. ");
INSERT INTO cebulb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pagkahuman niini, miduol kang Moises ang tanang katawhan sa Israel, ug gisuginlan sila sa tanang mga sugo nga gihatag ni Yahweh kaniya didto sa Bukid sa Sinai. ");
INSERT INTO cebulb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Sa nahuman na si Moises sa pagpakigsulti kanila, gitabonan niya ang iyang dagway sa panapton nga nipis. ");
INSERT INTO cebulb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Sa matag higayon nga moadto si Moises ngadto kang Yahweh aron sa pagpakigsulti kaniya, tangtangon niya ang tabon, hangtod nga makagawas siya. Sa dihang makagawas na siya, sultihan niya ang mga Israelita kung unsa ang gimando kaniya nga isulti. ");
INSERT INTO cebulb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Sa dihang makita sa mga Israelita nga nagdan-ag ang panagway ni Moises, tabonan niya ang iyang dagway pag-usab hangtod nga makabalik siya sa pagpakigsulti kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Gitigom ni Moises ang tibuok katilingban sa Israel ug miingon kanila, “Mao kini ang mga butang nga gimando ni Yahweh nga inyong buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sulod sa unom ka mga adlaw magtrabaho kamo, apan alang kaninyo, ang ikapito nga adlaw kinahanglan balaanon, usa ka adlaw nga Igpapahulay, balaan kang Yahweh. Si bisan kinsa ang motrabaho nianang adlawa kinahanglan pagapatyon. ");
INSERT INTO cebulb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kinahanglan dili kamo maghaling sa bisan asa sa inyong panimalay sa Adlaw nga Igpapahulay.” ");
INSERT INTO cebulb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nakigsulti si Moises sa tibuok katilingban sa mga Israelita, “Mao kini ang mga butang nga gimando ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Paghalad alang kang Yahweh, kamong tanan nga adunay masinugtanong kasingkasing. Paghalad alang kang Yahweh—bulawan, plata, ug bronse, ");
INSERT INTO cebulb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","linubid nga asul, tapul, pula, ug pinong lino; balahibo sa kanding; ");
INSERT INTO cebulb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","mga panit sa laking karnero nga gitina ug pula ug panit sa mananap nga dugong; kahoy nga akasya; ");
INSERT INTO cebulb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lana alang sa mga lampara sa balay alampoanan, mga pahumot alang sa lanang igdidihog ug sa mahumot nga insenso, ");
INSERT INTO cebulb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onix ug ang uban pang bililhong mga bato nga ipatapot sa efod ug sa sapaw sa dughan. ");
INSERT INTO cebulb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Paanhia ang tanang hanas nga mga tawo diha kaninyo ug pahimoa sa tanang butang nga gimando ni Yahweh— ");
INSERT INTO cebulb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ang tabernakulo uban ang tolda niini, ang pangtabon niini, ang mga kaw-itanan, ang mga tabla, mga pangbabag, mga haligi, ug mga sukaranan; ");
INSERT INTO cebulb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","lakip na usab ang arka sa kasabotan uban ang mga dayongan niini, ang tabon sa arka sa kasabotan, ug ang tabil aron motago niini. ");
INSERT INTO cebulb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Gidala nila ang lamesa uban ang mga dayongan niini, ang tanan nga kasangkapan niini, ug ang tinapay sa presensya; ");
INSERT INTO cebulb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ang tungtonganan alang sa mga suga, uban ang dayandayan niini, ang mga lampara niini, ug ang lana alang sa mga lampara; ");
INSERT INTO cebulb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ang halaranan sa insenso uban ang dayongan niini, ang lanang igdidihog ug ang mahumot nga insenso; ang tabil alang sa ganghaan sa tabernakulo; ");
INSERT INTO cebulb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ang halaran alang sa mga halad sinunog uban ang rehas nga bronse ug ang dayongan niini ug ang mga kagamitan; ug ang dako nga panaksan uban ang tungtonganan niini. ");
INSERT INTO cebulb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Gidala nila ang mga tabil alang sa hawanan uban ang mga haligi ug ang mga sukaranan niini ug ang mga tabil sa agianan sa tolda; ");
INSERT INTO cebulb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ug ang mga ugsok sa tolda alang sa tabernakulo ug sa hawanan, uban ang mga hikot. ");
INSERT INTO cebulb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Gidala nila ang maayong mga tinahing bisti alang sa mag-alagad sa balaang dapit, ang balaang bisti alang sa pari nga si Aaron ug sa iyang mga anak nga lalaki, aron moalagad sila ingon nga mga pari.” ");
INSERT INTO cebulb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Unya mibiya ang tanang tribo sa Israel ug mipauli gikan sa atubangan ni Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ang tanang kasingkasing nga iyang natandog ug kadtong espiritu nga naandam mibalik ug nagdalag halad alang kang Yahweh alang sa pagtukod sa tabernakulo, alang sa tanang kagamitan sa pag-alagad niini, ug alang sa mga balaang bisti. ");
INSERT INTO cebulb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Nangabot sila, ang mga lalaki ug mga babaye, ang tanan nga adunay masinugtanong kasingkasing. Gidala nila ang mga dayandayan, mga ariyos, ug mga kwentas, ang tanang matang sa alahas nga bulawan. Gihalad nila ang tanang bulawan ingon nga hiniusang halad ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Gidala sa tanang tawo nga adunay balahiboong panapton nga asul, tapul, o pula, pinong lino, balahibo sa kanding, panit sa laking karnero nga gitina ug pula, o panit sa mananap nga dugong. ");
INSERT INTO cebulb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ang mga tawo nga naghalad ug plata o bronse alang kang Yahweh, ug ang mga tawo nga adunay kahoy nga akasya aron magamit sa bisan unsa nga buluhaton nagdala usab niini. ");
INSERT INTO cebulb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ang mga babaye nga hanas sa paghimog linubid, nagdala sa iyang nahimo—linubid nga asul, tapul, o pula, o pinong lino. ");
INSERT INTO cebulb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ang tanang kasingkasing sa mga babaye nga nadasig ug kadtong hanas sa paghimo ug linubid gamit ang balahibo sa kanding. ");
INSERT INTO cebulb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Gidala sa mga pangulo ang mga bato nga onix ug mga bililhong bato nga ibutang sa efod ug sa tabon sa dughan; ");
INSERT INTO cebulb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Gidala nila ang mga pahumot ug lana alang sa mga lampara, alang sa lanang igdidihog, ug alang sa mahumot nga insenso. ");
INSERT INTO cebulb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Gidala sa mga Israelita ang kinabubut-on ang halad alang kang Yahweh; gidala sa tanang lalaki ug babaye nga may kasingkasing nga masinugtanon ang mga kagamitan alang sa tanang buluhaton nga gimando ni Yahweh pinaagi kang Moises nga buhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Miingon si Moises sa mga Israelita, “Tan-awa, gitawag ni Yahweh si Bezalel ang anak nga lalaki ni Uri nga anak ni Hur, gikan sa tribo ni Juda. ");
INSERT INTO cebulb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Gipuno niya si Bezalel sa iyang Espiritu, aron hatagan siya ug kaalam, panabot, ug kahibalo, alang sa tanang matang sa buluhaton, ");
INSERT INTO cebulb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","sa paghimo sa mga maanindot nga disenyo ug sa paghimo gamit ang bulawan, plata, ug bronse; ");
INSERT INTO cebulb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","sa pagputol usab ug pagpahimutang sa mga bato ug sa pagkulit sa mga kahoy—sa pagbuhat sa tanang matang sa disenyo ug paggama. ");
INSERT INTO cebulb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Gihatagan niya sa katakos ang iyang kasingkasing sa pagtudlo, kaniya ug kang Oholiab ang anak nga lalaki ni Ahisamac, gikan sa tribo ni Dan. ");
INSERT INTO cebulb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Gihatagan sila ni Yahweh sa katakos sa pagbuhat sa tanang matang sa buluhaton, sa pagtrabaho ingon nga hanas ng tighimo, ingon nga tigkulit, ingon nga mga tigburda sa asul, tapul, ug sa pulang balahibo sa karnero ug sa pinong lino, ug ingon nga mga manghahabol. Silang tanan ang tighimo sa tanang matang sa buluhaton, ug mga hanas sila nga modisenyo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Busa si Bezalel ug si Oholiab ug ang matag usa ka tawo nga gihatagan ni Yahweh sa kahanas ug katakos nga masayran kung unsaon pagbuhat ang mga buluhaton sa pagtukod sa balaang dapit mao ang mobuhat sa buluhaton sumala sa tanang gisugo ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Gipatawag ni Moises si Bezalel, si Oholiab, ug ang matag usa ka hanas nga tawo kansang kaalam naggikan kang Yahweh, ug si bisan kinsa nga natandog ang kasingkasing nga motabang ug mobuhat sa buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Gihatag ni Moises kanila ang tanang mga halad nga gidala sa mga Israelita alang sa pagtukod sa balaang dapit. Nagpadayon gihapon sa pagdala ang mga tawo sa kinabubut-on nga mga halad matag buntag ngadto kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Busa nangabot ang tanang hanas nga mga tawo nga nagtrabaho didto sa balaang dapit. ");
INSERT INTO cebulb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Misulti ang mga trabahante kang Moises, “Ang katawhan nagdalag sobra kay sa gikinahanglan sa pagbuhat sa buluhaton nga gisugo kanato ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Busa nagsugo si Moises nga wala nay si bisan kinsa nga anaa sulod sa kampo ang magdala ug dugang nga mga halad alang sa pagtukod sa balaang dapit. Unya mihunong na ang katawhan sa pagdala niini nga mga gasa. ");
INSERT INTO cebulb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Paigo na ang anaa kanila nga mga kasangkapan alang sa tanang buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Busa ang tanang mga hanas nga tawo diha kanila mao ang nagtukod sa tabernakulo lakip ang napulo ka tabil nga hinimo sa pinong lino ug linubid nga asul, tapul, ug pula nga may hulagway sa kerubim. Gibuhat kini ni Bezalel, ang hanas kaayo nga tawo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ang gitas-on sa matag tabil 20 ka cubit, ang gilapdon niini upat ka cubit. Ang tanang tabil managsama lamang ang gidak-on. ");
INSERT INTO cebulb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Gisumpaysumpay sa pagtahi ni Bezalel ang lima ka tabil, ug mao usab ang iyang gibuhat sa laing lima ka tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Naghimo siya ug galong nga asul sa kilid sa tumoy sa unang hut-ong sa tabil, ug naghimo usab siya ug sama niini sa ikaduhang hut-ong sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Gibutangan niya ug 50 ka mga galong ang unang hut-ong sa tabil ug 50 usab ka mga galong sa kilid sa tumoy sa ikaduhang hut-ong sa tabil. Busa nagtugbang ang mga galong. ");
INSERT INTO cebulb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Naghimo siya ug 50 ka kaw-it nga bulawan ug gisumpay ang duha ka mga tabil aron maporma ang tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Naghimo si Bezalel ug napulo ug usa ka mga tabil gikan sa balahibo sa kanding aron iatop sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ang gitas-on sa matag tabil 30 ka cubit, ug may gilapdon nga upat ka cubit. Managsama ang gidak-on sa napulog usa ka tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Gisumpaysumpay niya sa pagtahi ang lima ka tabil ug ang laing unom ka tabil usab. ");
INSERT INTO cebulb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Naghimo siya ug 50 ka mga galong sa kilid sa tumoy sa unang hut-ong sa tabil, ug laing 50 ka mga galong diha sa kilid tumoy sa mga tabil aron masumpay ang ikaduhang hut-ong. ");
INSERT INTO cebulb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Naghimo si Bezalel ug 50 ka kaw-it nga bronse aron masumpay ang duha ka hut-ong sa tabil ug maporma kining tolda. ");
INSERT INTO cebulb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Naghimo siya ug atop sa tabernakulo gikan sa panit sa laking karnero nga tinina ug pula, adunay lain pang atop sa maayong panit nga ibutang sa ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Naggabas si Bezalel ug mga tabla gikan sa kahoy nga akasya alang sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ang gitas-on sa matag usa ka tabla napulo ka cubits, ug 1/2 ka cubits ang gilapdon niini. ");
INSERT INTO cebulb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ang matag usa ka tabla adunay duha ka kahoy nga ugsok aron masumpaysumpay kini. Gibuhat niya kini sa tanang tabla sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Sama niini ang pagbuhat niya sa mga tabla: 20 ka mga tabla alang sa habagatang bahin. ");
INSERT INTO cebulb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Nagbuhat si Bezalel ug 40 ka sukaranan nga plata alang sa mga tabla. Adunay duha ka sukaranan ang matag usa ka tabla aron pagsumpay niini. ");
INSERT INTO cebulb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Alang sa ikaduhang bahin sa tabernakulo, sa amihanang bahin, naggabas siya ug 20 ka mga tabla ");
INSERT INTO cebulb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ug 40 ka sukaranan nga plata niini. Ang matag usa ka tabla adunay duha ka sukaranan, sa sunod na usab nga tabla, hangtod sa uban pang mga tabla. ");
INSERT INTO cebulb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Alang sa luyo sa tabernakulo sa kasadpan, naggabas si Bezalel ug unom ka mga tabla. ");
INSERT INTO cebulb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Naggabas usab siya ug lain pang duha ka tabla alang sa mga eskina sa likod sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kini nga mga tabla nagbulagbulag sa ilalom, apan gisumpay sukad sa ubos hangtod taas nga sangko sa usa ka liningin. Gihimo niya ang sama niini sa duha ka mga eskina. ");
INSERT INTO cebulb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Adunay walo ka mga tabla, uban sa mga sukaranan nga plata niini. Adunay 16 tanan ka mga sukaranan, tagduha ka sukaranan sa matag usa ka tabla. ");
INSERT INTO cebulb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Naghimo usab si Bezalel ug pangbabag gikan sa kahoy nga akasya—lima alang sa mga tabla sa usa ka bahin sa tabernakulo, ");
INSERT INTO cebulb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lima alang sa mga tabla sa laing bahin sa tabernakulo, ug lima ka mga pangbabag alang sa luyo nga bahin sa tabernakulo didto sa kasadpan. ");
INSERT INTO cebulb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Gipalapas niya paghimo ang pangbabag sa tungatunga nga bahin sa mga tabla aron mosangko sa isig ka tumoy. ");
INSERT INTO cebulb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Gihaklapan niyag bulawan ang mga tabla. Gihimoan niya kini ug bulawan nga liningin aron kasal-opan sa mga pangbabag, ug gihaklapan niyag bulawan ang mga pangbabag. ");
INSERT INTO cebulb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Naghimo si Bezalel ug mga tabil sa linubid nga asul, tapul, ug pula, ug pino nga lino, nga binurdahan ug kerubim, gibuhat kini sa hanas nga tighimo. ");
INSERT INTO cebulb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Naghimo siya ug upat ka haligi sa kahoyng akasya aron kabitan sa mga tabil, ug gihaklapan niya kini ug bulawan. Naghimo usab siya ug mga kaw-it nga bulawan alang sa mga haligi, ug gibutangan niya kini ug upat ka sukaranan nga plata. ");
INSERT INTO cebulb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Naghimo siya ug tabil alang sa ganghaan sa tolda. Hinimo kini sa linubid nga asul, tapul, ug pula, gamit ang pino nga lino, gibuhat kini sa usa ka tigburda. ");
INSERT INTO cebulb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Naghimo usab siya ug lima ka mga haligi sa tabil nga may kaw-itanan. Gihaklapan niyag bulawan ang mga tumoy ug ang mga hikot niini. Ang lima ka sukaranan hinimo gamit ang bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Gihimo ni Bezalel ang arka sa kasabotan gamit ang kahoy nga akasya. Ang gitas-on niini 2 ug 1/2 ka cubit; 1. 5 ka cubit ang gilapdon niini; ug ang gihabugon niini 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ang gawas ug ang sulod niini gihaklapan niya ug lunsayng bulawan unya giribitihan ug bulawan ang palibot sa ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Gihulma niya ang upat ka dakong liningin nga bulawan alang sa upat ka tiil, ang duha niini gibitay sa pikas bahin, ug ang laing duha gibitay usab sa pikas bahin. ");
INSERT INTO cebulb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Gihimo niya ang mga dayongan gamit ang kahoy nga akasya ug gihaklapan kini ug bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Gisuksok niya ang mga dayongan sa mga dakong liningin nga bulawan sa isigkakilid sa arka sa kasabotan, aron madayongan kini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Gihimo niya ang tabon gamit ang lunsayng bulawan. Ang gitas-on niini 2 ug 1/2 ka cubit, ug ang gilapdon niini 1 ug 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Gihimo ni Bezalel ang duha ka kerubim nga hinulma sa bulawan alang sa isigkatumoy niini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ang matag usa ka kerubim ibutang sa isigkakilid sa tabon. Hinimo kini ingon nga nausa diha sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Gipabukhad ang mga pako sa kerubim ug napandongan niini ang tabon. Nag-atubangay ang kerubim sa usag-usa ug nagdungaw sa tungatunga sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Gihimo ni Bezalel ang lamesa gamit ang kahoy nga akasya. Ang gitas-on niini duha ka cubit, usa ka cubit ang gilapdon, ug may gihabugon nga 1 ug 1/2 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Gihaklapan niya kini ug lunsayng bulawan unya giribitihan ug lunsayng bulawan ang kilid sa ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Gisanipahan niya ang palibot niini nga may usa ka dangaw ang gilapdon, ug gihaklapan kini ug bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Gihulma niya ang upat ka dakong liningin nga bulawan ug gipasulod kini sa upat ka eskina, kung asa nahimutang ang upat ka tiil. ");
INSERT INTO cebulb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Gibutangan kining mga dakong liningin aron nga bulawan nga maoy suksokan sa mga dayongan sa lamesa, aron madayongan kini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Gihimo niya ang mga dayongan gamit ang kahoy nga akasya ug gihaklapan niya kini ug bulawan, aron madayongan ang lamesa. ");
INSERT INTO cebulb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Gihimo niya ang mga kasangkapan alang sa lamesa—ang mga plato, mga kutsara, mga panaksan, ug mga panudlanan nga pangbubo sa mga halad. Gihimo niya kini gikan sa lunsayng bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Gihimo niya ang tungtonganan sa lampara gikan sa linilok nga lunsayng bulawan. Gihimo ni Bezalel ang tungtonganan sa lampara nga adunay tungtonganan ug lawas. Ang mga tungtonganan sa lampara, ang mga dahondahon, ug ang mga bulakbulak gihimo unay gayod niini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Adunay unom ka sanga ang gipatugbaw gikan sa mga kilid niini—may tulo ka sanga ang gipatugbaw gikan sa isigkakilid niini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ang unang sanga adunay tulo ka gagmayng panaksan nga hinimo sama sa bulak sa almendras, may dahondahon ug bulakbulak, ug ingon usab niini ang pagbuhat sa pikas sanga. Gihimo ang unom ka mga sanga nga gipatugbaw diha sa tungtonganan sa lampara sama gayod sa nahiuna. ");
INSERT INTO cebulb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Sa tungtonganan sa lampara mismo, nga mao ang lawas, may upat ka kupa nga hinimo sama sa bulak sa almendras uban ang mga dahondahon ug mga bulakbulak. ");
INSERT INTO cebulb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","May mga bulakbulak sa ilalom nga giusa paghimo sa matag pares sa sanga, sa unang pares hangtod sa ikatulong pares. Managsama usab ang gihimo sa unom ka sanga nga gipatugbaw gikan sa tungtonganan sa lampara. ");
INSERT INTO cebulb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ang mga bulakbulak niini ug ang mga sanga unay tanan sa usa lamang ka paglilok gikan sa lunsayng bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Gihimo ni Bezalel ang tungtonganan sa lampara ug ang pito niini ka mga lampara, ang mga sipit ug ang mga sulo nga hinimo sa lunsayng bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Gihimo usab niya ang butanganan ug suga ug ang mga kasangkapan niini hinimo gikan sa usa ka talent nga lunsayng bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Gihimo ni Bezalel ang halaran sa insenso. Gihimo niya kini gamit ang kahoy nga akasya. Ang gitas-on niini usa ka cubit, ug ang gilapdon usab niini usa ka cubit. Kwadrado kini, ug duha ka cubits ang gihabugon. Ang mga sungaysungay niini hinimo unay sa kinatibuk-an niini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Gihaklapan niya ug lunsayng bulawan ang halaran sa insenso—ang ibabaw, ang mga kilid, ug ang mga sungaysungay niini. Gipalibotan niya ug bulawan ang mga eskina niiini. ");
INSERT INTO cebulb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Gihimo niya ang duha ka liningin nga bulawan nga gibitay ilalom sa eskina sa isig ka kilid niini sa halaran sa sunoganan sa insenso. Ang mga liningin nga bulawan nga suksokan sa mga dayongan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Gihimo niya ang mga dayongan gamit ang kahoy nga akasya ug gihaklapan niya kini ug bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Gihimo niya ang sagrado nga lana nga igdidihog ug walay sagol nga alimyon sa insenso, gibuhat kini sa usa ka tighimo ug pahumot. ");
INSERT INTO cebulb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Gihimo ni Bezalel ang halaran nga sunoganan sa mga halad gamit ang kahoy nga akasya. Kwadrado kini nga may lima ka cubit ang gitas-on ug lima usab ka cubit ang gilapdon ug tulo ka cubit ang gihabugon. ");
INSERT INTO cebulb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Gihimoan niya ang upat ka eskina niini ug mga sungaysungay nga sama sa sungay sa torong baka. Gihimo niya kini unay sa halaran, unya gihaklapan niya kini ug bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Gihimo niya ang tanang kasangkapan alang sa halaran—ang mga panaksan nga saloran sa abo, mga pangkandos, mga dagkong panaksan, mga pangtuhog sa karne, ug mga butanganan sa baga. Gihimo niya kining tanan nga mga kasangkapan gamit ang bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Gihimo niya ang rehas nga bronse alang sa halaran, nga gibutang ilalom sa sanipa gikan sa tungatunga paubos. ");
INSERT INTO cebulb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Gihulma usab niya ang upat ka liningin nga gitaod diha sa upat ka mga eskina sa rehas nga bronse, aron kasuksokan sa mga dayonganan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Gihimo ni Bezalel ang mga dayonganan gamit ang kahoy nga akasya ug gihaklapan kini ug bronse. ");
INSERT INTO cebulb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Gisuksok niya ang mga dayonganan agi sa mga liningin diha sa kilid sa halaran, aron madayongan kini. Gihimo niya ang halaran gamit ang tabla, nga hawan sa sulod. ");
INSERT INTO cebulb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Gihimo ni Bezalel ang dakong panaksan nga bronse uban ang tungtonganan niini nga bronse. Gihimo niya ang dakong panaksan gikan sa mga samin nga gipanag-iyahan sa mga babaye nga nag-alagad didto sa ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Gihimo usab ni Bezalel ang hawanan. Ang mga tabil nga gibitay sa habagatang bahin sa hawanan, hinimo gikan sa pinong lino, nga may gitas-on nga 100 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ang mga tabil adunay 20 ka mga haligi, uban sa 20 ka mga sukaranan nga bronse. Adunay mga kaw-itanan nga gibutang sa mga haligi, lakip ang mga panghikot nga plata. ");
INSERT INTO cebulb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ingon man ang amihanang bahin, adunay mga tabil nga 100 cubit ang gitas-on uban ang 20 ka mga haligi, 20 ka mga sukaranan nga bronse, mga kaw-itanan nga gibutang sa mga haligi, ug mga panghikot nga plata. ");
INSERT INTO cebulb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ang mga tabil sa kasadpang bahin may gitas-on nga 50 ka cubits, uban sa napulo ka mga haligi ug sukaranan. Ang mga kaw-itanan ug ang mga panghikot sa haligi hinimo sa plata. ");
INSERT INTO cebulb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ang hawanan usab sa sidlakang bahin may gitas-on nga 50 ka cubit. ");
INSERT INTO cebulb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Sa may kilid dapit sa ganghaan adunay mga tabil nga 50 ka cubit ang gitas-on. Aduna kini tulo ka mga haligi uban sa tulo ka mga sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Sa pikas bahin usab sa ganghaan sa hawanan adunay mga tabil nga 50 ka cubits ang gitas-on, uban ang tulo ka mga haligi ug tulo ka mga sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ang tanang mga tabil palibot sa hawanan hinimo sa pinong lino. ");
INSERT INTO cebulb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Hinimo sa bronse ang mga sukaranan sa haligi. Ang mga kaw-itanan ug mga panghikot hinimo gikan sa plata, ug gitabonag plata ang ibabaw sa mga haligi. Ang tanang haligi sa hawanan gihaplakan ug plata. ");
INSERT INTO cebulb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ang tabil sa ganghaan sa hawanan may gitas-on nga 20 ka cubit. Ang tabil hinimo sa linong asul, tapul, pula ug linubid nga pinong lino, nga may 20 ka cubit ang gitas-on. Aduna kini gitas-on nga 20 ka cubit ug lima ka cubit ang gihabugon, sama sa mga tabil sa hawanan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Aduna kini upat ka sukaran nga bronse ug kaw-itanan nga plata. Ang gitabon ibabaw sa mga haligi ug ang mga panghikot niini hinimo sa plata. ");
INSERT INTO cebulb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Hinimo sa bronse ang tanang ugsok sa tolda sa tabernakulo ug sa hawanan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mao kini ang talaan sa mga kasangkapan sa tabernakulo, ang tabernakulo sa kasabotan ug sa mga balaod, nga gituman sumala sa gitudlo ni Moises. Mao kini ang buluhaton sa mga Levita ilalom sa pagdumala ni Itamar ang anak nga lalaki sa pari nga si Aaron. ");
INSERT INTO cebulb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Si Bezalel ang anak nga lalaki ni Uri, ang anak nga lalaki ni Hur nga gikan sa tribo sa Juda, mao ang nagbuhat sa tanang butang nga gimando ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Si Oholiab ang anak nga lalaki ni Ahisamac, nga gikan sa tribo ni Dan, mao ang kauban ni Bezalel ingon nga tigkulit, hanas nga tighimo, ug tigburda sa linubid nga asul, tapul, ug pula, ug sa pino nga lino. ");
INSERT INTO cebulb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ang tanang bulawan nga gigamit sa buluhaton, tanang buhat nga may kalabotan sa balaang dapit—ang mga hinalad nga bulawan—29 ka talent (ang usa ka talent sama ra sa 34 ka kilo) ug 730 ka shekel, gitimbang pinaagi sa sukdanan sa shekel didto sa balay alampoan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ang plata nga gihatag sa katawhan may gibug-aton nga 100 ka talent ug 1, 775 shekel, sumala sa timabangan sa shekel sa balay alampoan, ");
INSERT INTO cebulb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","o usa ka beka kada tawo nga 1/2 ka shekel, sumala sa timbangan sa shekel sa balay alampoan. Kining maong kantidad natigom sumala sa matag usa ka tawo nga nalista sa listahan, may 603, 550 tanan ka mga lalaki nga nagpanuigon ug 20 ka tuig pataas. ");
INSERT INTO cebulb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","100 ka talent sa plata ang gigamit alang sa mga sukaranan sa balaang dapit ug sa mga sukaranan sa haligi sa tabil: may 100 ka sukaranan unya usa ka talent sa matag usa ka sukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Sa nahibilin nga 1, 775 ka shekel nga plata, gihimo ni Bezalel ang mga kaw-itanan nga gikaw-it sa mga haligi, gitabonan ang ibabaw sa mga haligi, ug gihimoan kini ug mga tukod. ");
INSERT INTO cebulb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ang mga hinalad nga bronse may gibug-aton nga 70 ka talent ug 2, 400 ka shekel. ");
INSERT INTO cebulb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Pinaagi niini gihimo niya ang mga sukaranan alang sa ganghaan sa tolda nga tagboanan, ang halaran nga bronse, angrehas nga bronse, ang tanang kasangkapan sa halaran, ");
INSERT INTO cebulb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ang mga sukaranan sa haligi sa hawanan, ang mga sukaranan sa mga halagi sa ganghaan sa hawanan, ang tanang mga ugsok sa tolda alang sa tabernakulo, ug ang tanang mga ugsok sa hawanan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Naghimo sila ug maayo nga mga bisti alang sa pag-alagad sa balaan nga dapit gamit ang asul, tapul, ug balahibo nga pula. Gihimoan nila ug mga bisti si Aaron alang sa balaan nga dapit, sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Naghimo si Bezalel ug bulawan nga efod, nga asul, tapul, balahibo nga pula, ug sa pinong linubid nga lino. ");
INSERT INTO cebulb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nagdukdok sila ug mga nipis nga bulawan ug gitabas kini ingon nga mga tanod aron sa pagtahi niini ngadto sa asul, sa tapul, ug sa balahibo nga pula, ug ngadto sa pino nga lino, nga binuhat sa usa ka hanas nga tighimo. ");
INSERT INTO cebulb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Gibuhatan nila ug mga hikot ang efod sa may abaga, nga nagsumpay sa duha ka sidsid sa ibabaw nga bahin niini. ");
INSERT INTO cebulb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Pino nga pagkatahi ang bakus niini sama sa efod; gisumpay kini aron mausa uban sa efod, hinimo kini sa pinong linubid nga lino nga bulawan, asul, ang tapul, ug ang dagtom pula, sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Nagkulit sila ug onix nga mga bato, nga gilibotan ug bulawan, gikulitan kini sama sa usa ka selyo, ug gikulitan sa mga ngalan sa napulo ug duha ka mga anak nga lalaki ni Israel. ");
INSERT INTO cebulb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Gibutang kini ni Bezael sa abagang bahin nga mga hikot sa efod, ingon nga mga bato aron sa pagpahinumdom kang Yahweh mahitungod sa napulo ug duha ka mga anak nga lalaki ni Israel, sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Naghimo siya ug tabon sa dughan, ang buhat sa usa ka hanas nga tighimo, gidesinyohan sama sa efod. Gibuhat niya kini gikan sa bulawan, sa asul, sa tapul, ug sa pula nga balahibo, ug sa pinong lino. ");
INSERT INTO cebulb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kwadrado kini. Gipilo nila sa makaduha ang tabon sa dughan. Usa ka dangaw ang gitas-on niini ug usa ka dangaw usab ang gilapdon. ");
INSERT INTO cebulb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Gilaray nila sa sulod niini ang mga mahalon nga mga bato sa upat ka laray. Ang unang laray adunay rubi, topas, ug garnet. ");
INSERT INTO cebulb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ang ikaduhang laray adunay esmeralda, safiro, ug diamante. ");
INSERT INTO cebulb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ang ikatulong laray adunay hasinto, agata, ug ametis. ");
INSERT INTO cebulb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ang ikaupat nga laray adunay berilo, onix, ug haspe. Gipalibotan kini nga mga bato sa engaste nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Gihan-ay ang mga bato sumala sa mga ngalan sa napulo ug duha ka mga anak nga lalaki ni Israel, gihan-ay sumala sa matag ngalan. Nahisama sila sa kinulit sa usa ka singsing, ang matag ngalan nagtimaan sa usa sa napulo ug duha ka mga tribo. ");
INSERT INTO cebulb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nagbuhat sila ug mga kadena nga sama sa mga pisi ngadto sa tabon sa dughan nga gisalapid gikan sa lunsay nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Nagbuhat sila ug duha ka sukaranan nga bulawan ug duha ka singsing nga bulawan, gipapilit nila ang duha ka singsing nga bulawan ngadto sa duha ka sidsid sa tabon sa dughan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Gibutang nila ang duha ka sinalapid nga kadena nga bulawan diha sa duha ka singsing nga anaa sa duha ka sidsid sa tabon sa dughan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Gibutang nila ang duha ka tumoy sa sinalapid ngadto sa duha ka sukaranan. Gipatapot nila kini sa hikot sa efod sa atubangang bahin niini. ");
INSERT INTO cebulb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Naghimo sila ug duha ka singsing nga bulawan ug gibutang kini diha sa duha ka sidsid sa tabon sa dughan, sa sidsid nga sunod sa sulod nga bahin niini. ");
INSERT INTO cebulb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Naghimo sila ug lain pang duha ka singsing nga bulawan ug gipatapot kini sa ubos sa duha ka hikot sa atubangan sa efod, duol ang utlanan niini ibabaw sa pino nga pagkatahi nga bakos sa efod. ");
INSERT INTO cebulb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Gihikot nila ang tabon sa dughan diha sa mga singsing niini ngadto sa mga singsing sa efod uban sa usa ka pisi nga asul, aron nga sumpay lamang kini ibabaw sa pino nga pagkatahi nga bakos sa efod. Aron dili mabulag ang tabon sa dughan gikan sa efod. Gihimo kini sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Naghimo ug kupo sa efod si Bezalel gikan sa tapul nga panapton, ang buhat sa usa ka magbuburda. ");
INSERT INTO cebulb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Aduna kini sul-obanan sa ulo sa tungang bahin niini. Gitahi ang sul-obanan sa ulo libot niini aron dili kini magisi. ");
INSERT INTO cebulb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Sa ubos nga sidsid niini, gidayandayanan nila kini ug mga pormang prutas nga granada nga asul, tapul, ug dagtom pula nga tanod ug pino nga lino. ");
INSERT INTO cebulb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Naghimo sila ug mga kiling-kiling gikan sa lunsay nga bulawan, ug gibutang nila ang mga kiling-kiling sa tunga sa mga pormang prutas nga granada sa tanang bahin sa ubos nga sidsid sa kupo— ");
INSERT INTO cebulb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ang usa ka kiling-kiling ug ang usa ka pormang prutas nga granada—ang anaa sa sidsid sa kupo alang sa pag-alagad ni Aaron. Sumala kini sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Naghimo sila ug mga tag-as nga bisti gikan sa pinong lino alang kang Aaron ug sa iyang mga anak nga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Naghimo sila gikan sa pinong lino ug purong, mga kalo, mga pang-ilalom nga bisti, ");
INSERT INTO cebulb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ug bakos nga asul, tapul, ug dagtom pula nga tanod, ang buhat sa usa ka magbuburda. Sumala kini sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Naghimo sila ug balaanong korona gikan sa lunsay nga bulawan; gikulitan nila kini, sama sa kinulit sa usa ka selyo, ''Balaan ngadto kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Gipatapot nila sa ibabaw nga bahin sa purong ang asul nga pisi. Sumala kini sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Busa nahuman ang bulohaton diha sa tabernakulo, ang tolda nga tagboanan. Gihimo kining tanan sa katawhan sa Israel. Gituman nila ang tanan nga mga sugo ni Yahweh nga gihatag kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Gidala nila ang tabernakulo ngadto kang Moises—ang tolda ug ang tanang galamiton niini, mga kaw-it, mga bungbong, mga pangbabag, mga haligi, ug ang mga pasukaranan niini; ");
INSERT INTO cebulb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ug ang mga tabon nga hinimo sa panit sa laking karnero nga gitinaan ug pula, ug ang tabon nga panit sa mananap sa dagat, ug ang tabil nga itabon ");
INSERT INTO cebulb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sa sudlanan sa pagpamatuod, ingon man ang mga dayongan ug ang halaran sa pagpasig-uli. ");
INSERT INTO cebulb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Gidala nila ang lamesa, ug ang tanang mga galamiton niini; ug ang tinapay nga nagpaila sa presensya sa Dios; ");
INSERT INTO cebulb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ang tungtonganan ug suga nga lunsay nga bulawan ug ang mga suga nga nalaray niini, uban sa mga galamiton niini ug ang lana alang sa mga suga; ");
INSERT INTO cebulb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ang bulawanong halaran, ang igdidihog nga lana ug ang mahumot nga insenso; ang babag alang sa ganghaan sa tabernakulo; ");
INSERT INTO cebulb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ang tumbaga nga halaran uban ang rehas nga tumbaga niini ug ang mga dayongan niini ug ang mga gamit niini ug ang dako nga panaksan uban sa iyang pasukaranan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Nagdala sila ug mga babag alang sa hawanan uban sa mga poste ug mga pasukaranan, ug ang tabil alang sa ganghaan; ang mga pisi niini ug ang mga ugsok sa tolda; ug ang tanang galamiton alang sa pag-alagad sa tabernakulo, ang tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Gidala nila ang pino nga pagkatahi nga mga bisti alang sa pag-alagad sa balaang dapit, ang balaang mga bisti alang kang Aaron nga pari ug sa iyang mga anak nga lalaki, aron makaalagad sila ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Busa gibuhat sa katawhan sa Israel ang tanan sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Gisuta ni Moises ang tanang buhat, ug, tan-awa, nahuman nila kini. Sumala sa gisugo ni Yahweh gibuhat kini nila sa ingon niana nga paagi. Unya gipanalanginan sila ni Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Unya nakigsulti si Yahweh kang Moises nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","''Sa unang adlaw sa unang bulan sa bag-ong tuig kinahanglan itukod mo ang tabernakulo, ang tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kinahanglan nga ibutang nimo ang sudlanan sa kasabotan niini, ug kinahanglan nga tabonan nimo ang sudlanan sa kasabotan ug tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kinahanglan nga dad-on nimo ang lamesa ug ipahimutang nga han-ay ang tanang mga gamit nga nahiapil niini. Unya kinahanglan dad-on nimo ang tungtonganan ug suga ug ipahimutang ang mga suga niini. ");
INSERT INTO cebulb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Kinahanglan nga ibutang nimo ang bulawanong halaran sa insenso atubang sa sudlanan sa pagpamatuod, ug kinahanglan tabilan nimo ang ganghaan sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kinahanglan ibutang nimo ang halaran alang sa mga halad sinunog sa atubangan sa ganghaan sa tabernakulo, ang tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kinahanglan ibutang nimo ang dako nga panaksan taliwala sa tolda nga tagboanan ug sa halaran ug kinahanglan imo kining butangan ug tubig. ");
INSERT INTO cebulb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kinahanglan ipahimutang nimo ang hawanan palibot niini, ug kinahanglan imong tabilan ang ganghaan sa hawanan. ");
INSERT INTO cebulb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Kinahanglan nga magdala ka ug igdidihog nga lana ug dihogi ang tabernakulo ug ang tanan nga anaa niini. Kinahanglan nga lainon nimo ug tanang mga kasangkapan alang kanako; ug mabalaan kini. ");
INSERT INTO cebulb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kinahanglan dihogan nimo ang halaran alang sa mga halad sinunog ug ang tanang mga galamiton niini. Kinahanglan lainon nimo ang halaran alang kanako ug mahimo gayod kining balaan alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kinahanglan dihogan nimo ang tumbaga nga panaksan ug ang pasukaranan niini ug laina kini alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Dad-a si Aaron ug ang iyang mga anak nga lalaki sa ganghaan sa tolda nga tagboanan ug kinahanglan nga hugasan nimo sila. ");
INSERT INTO cebulb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Bistihi si Aaron uban sa mga bisti nga gilain alang kanako, dihogi siya ug laina aron makaalagad siya ingon nga akong pari. ");
INSERT INTO cebulb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dad-a ang iyang mga anak nga lalaki ug bistihi sila ug tag-as nga mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Kinahanglan dihogan nimo sila ingon nga imong gidihogan ang ilang amahan aron makaalagad sila kanako ingon nga mga pari. Ang ilang pagkadinihogan maghimo kanilang magpabilin sa pagkapari hangtod sa ilang mga kaliwatan.'' ");
INSERT INTO cebulb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mao kini ang gihimo ni Moises; gituman niya ang tanan nga gisugo ni Yahweh kaniya. Gihimo niya kining tanan nga mga butang. ");
INSERT INTO cebulb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Busa natukod ang tabernakulo sa unang adlaw sa unang bulan sa ikaduha nga tuig. ");
INSERT INTO cebulb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Gitukod ni Moises ang tabernakulo, gibutang ang mga pasukaranan niini, ang mga babag niini, unya gitaod ang mga tabla niini, ug gipatindog ang mga haligi ug mga poste. ");
INSERT INTO cebulb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Gibuklad niya ang tabon sa tabernakulo ug nagtukod ug tolda ibabaw niini, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Gikuha niya ang mga kasugoan sa kasabotan ug gibutang kini sa sudlanan sa kasabotan. Gibutang usab niya ang mga dayongan sa sudlanan ug gibutang ang tabon sa pagpasig-uli ibabaw niini. ");
INSERT INTO cebulb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Gidala niya ang sudlanan sa kasabotan ngadto sa tabernakulo. Gibutang niya ang tabil aron sa pagsalipod sa sudlanan sa pagpamatuod, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Gibutang niya ang lamesa ngadto sa tolda nga tagboanan, sa amihanang bahin sa tabernakulo, gawas sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Gihan-ay niya pagbutang sa lamesa ang tinapay sa atubangan ni Yahweh, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Gibutang niya ang tungtonganan sa suga ngadto sa tolda nga tagboanan, atubang sa lamesa, sa habagatang bahin sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Gisindihan niya ang mga suga sa atubangan ni Yahweh, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Gibutang niya ang bulawanong halaran sa insenso ngadto sa tolda nga tagboanan atubang sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nagsunog siya ug humot nga insenso ibabaw niini, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Gitabilan niya ang ganghaan sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Gibutang niya ang halaran alang sa halad sinunog dapit sa ganghaan sa tabernakulo, ang tolda nga tagboanan. Naghalad siya ibabaw niini sa halad sinunog ug halad nga trigo, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Gibutang niya ang dako nga panaksan taliwala sa tolda nga tagboanan ug sa halaran, ug gibutangan niya kini ug tubig alang sa pagpanghugas. ");
INSERT INTO cebulb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Gihugasan ni Moises, ni Aaron, ug sa iyang mga anak nga lalaki ang ilang mga kamot ug mga tiil ngadto sa dako nga panaksan ");
INSERT INTO cebulb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","sa matag sulod nila sa tolda nga tagboanan ug sa matag saka nila sa halaran. Gihugasan nila ang ilang mga kaugalingon, sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Giandam ni Moises ang hawanan palibot sa tabernakulo ug sa halaran. Gitabilan niya ang ganghaan sa hawanan. Niining paagiha nahuman ni Moises ang bulohaton. ");
INSERT INTO cebulb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Unya mitabon ang panganod sa tolda nga tagboanan, ug napuno sa himaya ni Yahweh ang tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Wala nakasulod si Moises sa tolda nga tagboanan tungod sa panganod nga milukop niini, ug tungod sa himaya ni Yahweh nga mipuno sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Sa dihang mopataas na ang panganod gikan sa tabernakulo, mopadayon ang katawhan sa Israel sa ilang panaw. ");
INSERT INTO cebulb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Apan kung dili mopataas ang panganod gikan sa tabernakulo, dili makapadayon ang katawhan sa ilang panaw. Nagpabilin sila hangtod sa adlaw nga mopataas kini. ");
INSERT INTO cebulb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kay ang panganod ni Yahweh anaa ibabaw sa tabernakulo panahon sa adlaw, ug ang iyang kalayo anaa sa ibabaw niini panahon sa kagabhion, nga makita sa tanang katawhan sa Israel samtang nanglakaw sila. ");
INSERT INTO cebulb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Gitawag ni Yahweh si Moises ug nakigsulti kaniya gikan sa tolda nga tigomanan, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Pagpakigsulti ngadto sa katawhan sa Israel ug sultihi sila, 'Si bisan kinsa diha kaninyo nga magdala ug halad ngadto kang Yahweh, dad-a ingon nga halad ang usa sa inyong mga mananap, gikan sa panon sa baka o gikan sa panon sa mga karnero. ");
INSERT INTO cebulb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kung gikan sa panon sa baka ang iyang halad sinunog, kinahanglan nga ihalad niya ang laking baka nga walay tatsa. Ihalad niya kini ngadto sa pultahan sa tolda nga tigomanan, aron nga dawaton kini ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Itapion niya ang iyang kamot ngadto sa ulo sa halad sinunog, ug unya dawaton kini isip puli alang kaniya aron sa pagpasaylo sa iyang sala. ");
INSERT INTO cebulb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Unya kinahanglan nga ihawon niya ang torong baka sa atubangan ni Yahweh. Ihalad sa mga anak nga lalaki ni Aaron, nga mga pari ang dugo ug iwisikwisik kini ngadto sa halaran nga anaa sa pultahan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Unya kinahanglan nga panitan niya ang halad sinunog ug hiwahiwaon kini. ");
INSERT INTO cebulb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Unya ang mga anak nga lalaki ni Aaron nga pari mao ang maghaling ngadto sa halaran ug magbutang ug kahoy aron nga sugnoran kini. ");
INSERT INTO cebulb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ang mga anak nga lalaki ni Aaron, nga mga pari, ang magpahimutang sa mga gihiwahiwa, nga ulo ug sa tambok ngadto sa gisugnoran nga kalayo sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Apan kinahanglan nga hinloan niya ug tubig ang ginhawaang bahin ug ang mga tiil niini. Unya sunogon sa pari ang tanan diha sa halaran ingon nga halad sinunog. Makahatag kini ug humot nga makapahimuot alang kanako; Mahimo kining halad alang kanako pinaagi sa kalayo. ");
INSERT INTO cebulb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kung ang iyang halad alang sa halad sinunog gikan sa panon sa mga mananap, usa sa mga karnero o usa sa mga kanding, kinahanglan ihalad niya ang laki nga walay tatsa. ");
INSERT INTO cebulb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ihawon niya kini ngadto sa amihanang bahin sa halaran sa atubangan ni Yahweh. Iwisikwisik sa mga anak nga lalaki ni Aaron, nga mga pari, ang dugo niini sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Unya kinahanglan nga hiwahiwaon niya kini, ang ulo ug ang tambok, unya ipahimutang kini sa pari ngadto sa gisugnoran nga kalayo, nga anaa sa halaran, ");
INSERT INTO cebulb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","apan kinahanglan nga hinloan ug tubig ang ginhawaang bahin ug ang mga tiil niini. Unya ihalad sa pari ang tibuok nga halad, ug sunogon kini ngadto sa halaran. Mao kini ang halad sinunog, ug makahatag kini ug humot nga makapahimuot alang kang Yahweh; mahimo kining halad alang kaniya pinaagi sa kalayo. ");
INSERT INTO cebulb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kung ang iyang halad ngadto kang Yahweh mao ang halad sinunog nga mga langgam, nan kinahanglan nga magdala siya ug salampati o pispis nga tukmo ingon nga iyang halad. ");
INSERT INTO cebulb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kinahanglan nga dad-on kini sa pari ngadto sa halaran, lubagon ang ulo niini, ug sunogon kini ngadto sa halaran. Unya kinahanglan nga ipaagas ang dugo niini ngadto sa kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kinahanglan nga kuhaon niya ang ubol-ubol lakip na ang mga kinaon niini, ug iitsa kini ngadto sa kilid sa halaran sa sidlakang bahin, sa dapit diin gibutang ang abo. ");
INSERT INTO cebulb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kinahanglan nga pikason niya kini pinaagi sa pagbitad sa mga pako niini, apan kinahanglan nga dili niya kini tungaon sa duha ka bahin. Unya pagasunogon kini sa pari ngadto sa halaran, nga gisugnoran ug kahoy. Mahimo kining halad sinunog, ug makahatag kini ug humot nga makapahimuot alang kang Yahweh; mahimo kining halad alang kaniya pinaagi sa kalayo. ");
INSERT INTO cebulb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kung adunay magdala ug halad nga trigo ngadto kang Yahweh, kinahanglan nga labing maayo nga harina ang iyang ihalad, ug buboan niya kini ug lana ug butangan ug insenso. ");
INSERT INTO cebulb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Dad-on niya ang halad ngadto sa mga anak nga lalaki ni Aaron nga mga pari, ug didto magkuha ang pari ug usa ka kumkom sa labing maayong harina nga adunay lana ug insenso. Unya pagasunogon sa pari ang halad ngadto sa halaran ingon nga kinatibuk-ang halad. Makahatag kini ug humot nga makapahimuot alang kang Yahweh; mahimo kining halad alang kaniya pinaagi sa kalayo. ");
INSERT INTO cebulb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Mapanag-iya ni Aaron ug sa iyang mga anak nga lalaki ang bisan unsa nga mahibilin nga halad sa trigo. Balaan kaayo kini nga halad nga gisunog alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kung mohalad ka ug trigo nga walay igpapatubo nga giluto sa pugon, kinahanglan nga humok kini nga tinapay nga hinimo gikan sa labing maayong harina nga sinagolan ug lana, o gahi nga tinapay nga walay igpapatubo, nga pinahiran ug lana. ");
INSERT INTO cebulb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kung giluto ang imong halad nga trigo diha sa lapad nga karahay, kinahanglan nga hinimo kini sa labing maayong harina nga walay igpapatubo nga sinagolan ug lana. ");
INSERT INTO cebulb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Kinahanglan nga bahinbahinon ug buboan nimo kini ug lana. Mao kini ang halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kung giluto sa karahay ang imong halad nga trigo, kinahanglan nga hinimo kini sa labing maayong harina ug lana. ");
INSERT INTO cebulb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kinahanglan nga dad-on nimo ang halad nga trigo nga hinimo gikan niining mga butanga ngadto kang Yahweh, ug ihatag kini ngadto sa pari, nga maoy modala niini ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Unya magkuha ang pari ug gamayng bahin gikan sa halad nga trigo ingon nga kinatibuk-ang halad, ug pagasunogon niya kini ngadto sa halaran. Mahimo kining halad nga gisunog, ug makahatag kini ug humot nga makapahimuot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Mapanag-iya ni Aaron ug sa iyang mga anak nga lalaki ang bisan unsa nga mahibilin sa trigo nga halad. Balaan kaayo kini nga halad nga gisunog alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Walay halad nga trigo nga adunay igpapatubo ang inyong ihalad ngadto kang Yahweh, kay kinahanglan nga sunogon ninyo ang tinapay nga walay igpapatubo, ni bisan unsang matang sa dugos, ingon nga halad nga gisunog ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ihalad ninyo kini ngadto kang Yahweh ingon nga halad sa unang mga abot, apan dili kini magamit aron nga makahatag ug humot nga makapahimuot ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kinahanglan nga butangan ninyo ug asin ang matag halad nga trigo. Kinahanglan nga dili ninyo tugotan nga mawala gikan sa inyong halad nga trigo ang asin sa kasabotan sa inyong Dios. Kinahanglan nga magbutang kamo ug asin sa tanan ninyong mga halad. ");
INSERT INTO cebulb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Kung maghalad kamo sa unang mga abot sa trigo ngadto kang Yahweh, paghalad ug bag-ong ani nga trigo nga gisanlag ug gilubok aron kan-on. ");
INSERT INTO cebulb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Unya kinahanglan nga butangan ninyo kini ug lana ug insenso. Mao kini ang halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Unya pagasunogon sa pari ang ubang bahin sa linubok nga trigo ug lana ug insenso ingon nga kinatibuk-ang halad. Mao kini ang halad nga gisunog ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kung adunay maghalad ug mga mananap nga gikan sa panon sa baka ingon nga halad sa pakigdait, laki man o baye, kinahanglan nga maghalad siya ug mananap nga walay tatsa sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Itapion niya ang iyang kamot sa ulo sa iyang halad ug ihawon kini ngadto sa pultahan sa tolda nga tigomanan. Unya iwisikwisik sa mga anak nga lalaki ni Aaron nga mga pari ang dugo niini sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ihalad sa tawo ang halad sa pagpakigdait ngadto kang Yahweh pinaagi sa kalayo. Ang tambok nga miputos o sumpay sa ginhawaang mga bahin, ");
INSERT INTO cebulb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ug ang duha ka kidni ug ang tambok nga anaa niini sa mga dapidapi, ug ang tambok sa atay, ug ang mga kidni—pagakuhaon niya kining tanan. ");
INSERT INTO cebulb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Sunogon kini sa mga anak nga lalaki ni Aaron ngadto sa halaran uban sa halad sinunog, nga anaa sa ginasugnoran nga kalayo. Makahatag kini ug humot nga makapahimuot alang kang Yahweh; mahimo kining halad alang kaniya pinaagi sa kalayo. ");
INSERT INTO cebulb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kung ang halad sa usa ka tawo sa pagpakigdait ngadto kang Yahweh gikan sa panon sa karnero; laki man o baye, kinahanglan nga walay tatsa ang iyang ihalad. ");
INSERT INTO cebulb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kung maghalad siya ug karnero, nan kinahanglan nga ihalad niya kini sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Itapion niya ang iyang kamot ngadto sa ulo sa iyang halad ug ihawon kini ngadto sa atubangan sa tolda nga tigomanan. Unya iwisikwisik sa mga anak nga lalaki ni Aaron ang dugo niini sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Maghalad ang tawo alang sa pagpakigdait ingon nga halad nga gisunog ngadto kang Yahweh. Ang tambok, puokon pagputol ang tibuok tambok nga ikog, ug ang tambok nga miputos sa ginhawaang mga bahin ug ang tanang tambok nga anaa duol sa ginhawaang mga bahin, ");
INSERT INTO cebulb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ug ang duha ka kidni ug ang tambok nga uban niini, nga anaa sa dapidapi, ug ang tambok sa atay, uban sa mga kidni—pagakuhaon niya kining tanan. ");
INSERT INTO cebulb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Unya pagasunogon kining tanan sa pari ngadto sa halaran ingon nga halad sinunog nga pagkaon ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kung kanding ang halad sa usa ka tawo, nan ihalad niya kini ngadto sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Kinahanglan nga itapion niya ang iyang kamot ngadto sa ulo sa maong kanding ug ihawon kini ngadto sa atubangan sa tolda nga tigomanan. Unya iwisikwisik sa mga anak nga lalaki ni Aaron ang dugo niini sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Mohalad ang tawo ngadto kang Yahweh sa halad nga gisunog. Kuhaon niya ang tambok nga miputos sa ginhawaang bahin, ug ang tanang tambok nga duol sa ginhawaang mga bahin. ");
INSERT INTO cebulb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Kuhaon usab niya ang duha ka kidni ug ang tambok nga uban niini, nga anaa sa dapidapi, ug ang tambok sa atay uban sa duha ka kidni. ");
INSERT INTO cebulb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Pagasunogon kining tanan sa pari diha sa halaran ingon nga halad sinunog nga pagkaon, aron nga makahatag ug kahumot nga makapahimuot. Iya kang Yahweh ang tanang tambok. ");
INSERT INTO cebulb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Mahimo kining balaod hangtod sa kaliwatan sa inyong katawhan bisan asang dapita kamo mopuyo, nga dili kamo angay nga mokaon ug tambok o dugo.'” ");
INSERT INTO cebulb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Sultihi ang katawhan sa Israel, 'Kung makasala si bisan kinsa nga dili tinuyoan, nakabuhat niadtong mga butang nga gimando ni Yahweh nga dili buhaton, ug kung nakahimo siya sa butang nga ginadili, kinahanglan nga buhaton kining mosunod. ");
INSERT INTO cebulb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kung nakasala ang labawng pari nga makahimo usab sa katawhan nga sad-an, nan tugoti siya nga mohalad ngadto kang Yahweh ug nating baka nga walay tatsa ingon nga halad sa sala alang sa iyang nabuhat nga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Kinahanglan nga dad-on niya ang torong baka ngadto sa pultahan sa tolda nga tigomanan sa atubangan ni Yahweh, itapion ang iyang kamot sa ulo niini, ug ihawon ang torong baka ngadto sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Magkuha ug gamay nga dugo sa torong baka ang dinihogan nga pari ug dad-on kini ngadto sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ituslob sa pari ang iyang tudlo ngadto sa dugo ug iwisikwisik ang uban niini sa makapito ka higayon sa atubangan ni Yahweh, sa atubangan nga tabil sa labing balaan nga dapit. ");
INSERT INTO cebulb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Unya butangan sa pari ang mga sungaysungay sa halaran ug gamay nga dugo diin ginasunog ang humot nga insenso sa atubangan ni Yahweh, nga anaa sa tolda nga tigomanan, ug ibubo niya ang tanang nahibilin nga dugo sa torong baka ngadto sa kinaubosang bahin sa halaran alang sa mga halad sinunog, nga anaa sa pultahan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Laplapon niya ang tanang tambok sa torong baka nga halad sa sala; ang tambok nga miputos sa ginhawaang mga bahin, ang tanang tambok nga nakadikit sa ginhawaang mga bahin, ");
INSERT INTO cebulb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ang duha ka kidni ug ang tambok nga anaa niini, nga anaa sa dapidapi, ug ang tambok sa atay, uban sa mga kidni—laplapon niya kining tanan. ");
INSERT INTO cebulb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Laplapon niya kining tanan, sama nga iya kining gilaplap gikan sa torong baka nga halad alang sa pagpasig-uli. Unya pagasunogon sa pari ang tanang bahin niini ngadto sa halaran alang sa mga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ang panit sa torong baka ug ang nahibilin nga karne, uban sa ulo ug sa mga tiil ug sa ginhawaang bahin ug sa hugaw niini, ");
INSERT INTO cebulb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ang tanang mga bahin sa torong baka—dad-on niya kining tanan nga mga bahin gawas sa kampo ngadto sa dapit nga ilang gihinloan alang kanako, diin gibubo nila ang mga abo; pagasunogon nila kadtong mga bahin didto sa kahoy. Kinahanglan nga sunogon nila kadtong mga bahin diin gibubo nila ang mga abo. ");
INSERT INTO cebulb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kung nakasala nga dili tinuyoan ang tibuok pundok sa katawhan sa Israel, ug kung wala nakamatikod ang pundok sa katawhan nga nakasala sila ug nakabuhat sa mga butang nga gimando ni Yahweh nga dili buhaton, ug kung sad-an sila, ");
INSERT INTO cebulb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","unya, sa dihang nahibaw-an na ang nabuhat nila nga sala, nan kinahanglan nga maghalad ug nating baka ang pundok sa katawhan ingon nga halad alang sa sala ug dad-on kini ngadto sa atubangan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Itapion sa mga kadagkoan sa pundok sa katawhan ang ilang mga kamot ngadto sa ulo sa baka sa atubangan ni Yahweh, ug ihawon ang baka ngadto sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Dad-on sa dinihogan nga pari ang gamay nga dugo sa baka ngadto sa tolda nga tigomanan, ");
INSERT INTO cebulb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ug ituslob sa pari ang iyang tudlo sa maong dugo ug iwisikwisik kini sa makapito ka higayon sa atubangan ni Yahweh, sa atubangan sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Butangan niya ug gamay nga dugo ang mga sungaysungay sa halaran nga anaa sa atubangan ni Yahweh, nga anaa sa tolda nga tigomanan, ug ibubo niya ang tanang dugo sa kinaubosang bahin sa halaran alang sa halad sinunog, nga anaa sa pultahan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Laplapon niya ang tanang tambok gikan niini ug sunogon kini ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Mao kana ang kinahanglan niyang buhaton sa baka. Sama sa iyang gibuhat sa baka nga halad alang sa sala, busa mao usab ang iyang buhaton niini nga baka, ug ang pari mao ang maghimo ug pagpapas sa sala alang sa katawhan, ug mapasaylo sila. ");
INSERT INTO cebulb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Dad-on niya ang baka gawas sa kampo ug sunogon kini sama sa iyang pagsunog sa unang baka. Mao kini ang halad sa sala alang sa pundok sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Kung nakasala ang tigdumala nga dili tinuyoan, sa pagbuhat sa tanang mga butang nga gimando ni Yahweh nga iyang Dios nga dili buhaton, ug sad-an siya, ");
INSERT INTO cebulb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","unya nahibaw-an na niya ang sala nga iyang nabuhat, kinahanglan nga magdala siya ug laking kanding nga walay tatsa, ingon nga halad. ");
INSERT INTO cebulb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Itapion niya ang iyang kamot ngadto sa ulo sa maong kanding ug ihawon kini sa dapit diin ginaihaw nila ang halad sinunog sa atubangan ni Yahweh. Mao kini ang halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Magkuha ug dugo ang pari sa halad nga alang sa sala pinaagi sa iyang tudlo ug ibutang kini ngadto sa mga sungaysungay sa halaran alang sa mga halad sinunog, ug ibubo niya ang dugo niini kinaubosang bahin sa halaran sa halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sunogon niya ang tanang tambok ngadto sa halaran, sama sa tambok nga halad alang sa pagpasig-uli. Ang pari mao ang maghimo sa pagpapas sa sala alang sa tigdumala, ug mapasaylo ang tigdumala. ");
INSERT INTO cebulb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Kung makasala ang yanong mga tawo nga dili tinuyoan, sa pagbuhat sa mga butang nga gimando ni Yahweh kaniya nga dili buhaton, ug sa dihang naamgohan na niya ang iyang sala, ");
INSERT INTO cebulb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","unya sa dihang nahibaw-an na niya ang sala nga iyang nabuhat, nan magdala siya ug baye nga kanding nga walay tatsa alang sa iyang halad, alang sa sala nga iyang nabuhat. ");
INSERT INTO cebulb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Itapion niya ang iyang kamot ngadto sa ulo sa halad sa sala ug ihawon ang halad sa sala didto sa butanganan sa halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Magkuha ug gamay nga dugo ang pari pinaagi sa iyang tudlo ug ibutang kini ngadto sa mga sungaysungay sa halaran alang sa mga halad sinunog. Ibubo niya ang tanang nahibilin nga dugo sa kinaubosang bahin sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Laplapon niya ang tanang tambok, sama nga gilaplap ang tambok gikan sa mga halad sa pagpasig-uli. Sunogon kini sa pari ngadto sa halaran aron nga makahatag ug humot nga makapahimuot alang kang Yahweh. Ang pari mao ang maghimo sa pagpapas sa sala alang sa tawo, ug mapasaylo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kung magdala ang tawo ug karnero ingon nga halad sa sala, magdala siya ug baye nga karnero nga walay tatsa. ");
INSERT INTO cebulb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Itapion niya ang iyang kamot ngadto sa ulo sa halad sa sala ug ihawon kini ingon nga halad alang sa sala sa dapit diin ginaihaw nila ang halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Magkuha ug dugo ang pari sa halad sa sala pinaagi sa iyang tudlo ug ibutang kini ngadto sa mga sungaysungay sa halaran alang sa halad sinunog, ug ibubo niya ang tanang dugo niini sa kianubosang bahin sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Laplapon niya ang tanang tambok, sama nga gilaplap ang tambok sa karnero gikan sa halad sa pagpasig-uli, ug sunogon kini sa pari ngadto sa halaran ibabaw sa mga halad nga gisunog nga alang kang Yahweh. Ang pari mao ang maghimo sa pagpapas sa sala alang kaniya sa sala nga iyang nabuhat, ug mapasaylo ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kung makasala ang si bisan kinsa tungod kay wala siya nagpamatuod sa dihang nakasaksi siya sa usa ka butang nga gikinahanglan niya nga pamatud-an, nakita o nadunggan man niya ang mahitungod niini, manubag gayod siya. ");
INSERT INTO cebulb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","O kung nakahikap ang si bisan kinsa sa bisan unsa nga butang nga giila sa Dios ingon nga mahugaw, patayng lawas ba kini sa mahugaw nga ihalas nga mananap o patayng lawas sa bisan unsa nga mga binuhing mananap, o nagakamang nga mananap, bisan kung wala tuyoa sa tawo nga gunitan kini, mahimo siyang hugaw ug sad-an. ");
INSERT INTO cebulb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","O kung nakahikap siya sa makapahugaw sa usa ka tawo, bisan unsa pa man kini kahugaw, ug kung wala siyay kasayoran mahitungod niini, nan mahimo siyang sad-an kung masayran niya ang mahitungod niini. ");
INSERT INTO cebulb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","O kung makapanumpa dayon ang si bisan kinsa pinaagi sa iyang ngabil aron magbuhat ug daotan o maayo, bisan unsa pa man kini nga gidalidali sa pagpanumpa sa usa ka tawo diha sa pagsaad, bisan pa kung wala siya masayod niini, nan mahimo siyang sad-an, sa bisan asa niini nga mga butanga sa dihang masayran na niya ang mahitungod niini. ");
INSERT INTO cebulb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Sa dihang sad-an ang usa ka tawo sa bisan asa niining mga butanga, kinahanglan nga isugilon niya ang bisan unsang sala nga iyang nabuhat. ");
INSERT INTO cebulb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Unya kinahanglan nga dad-on niya ang halad alang sa sala ngadto kang Yahweh alang sa sala nga iyang nahimo, usa ka bayeng mananap nga gikan sa panon, nating karnero o kanding, alang sa halad sa sala, ug ang pari ang maghimo ug pagpapas sa sala alang kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kung dili siya makapalit ug nating karnero, makahimo siya sa pagdala ug duha ka salampati o duha ka pispis nga tukmo ingon nga halad sa dili tinuyoan nga sala ngadto kang Yahweh, usa alang sa halad sa sala ug ang lain pang usa alang sa halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Kinahanglan nga dad-on niya kini ngadto sa pari, nga maoy maghalad pag-una sa halad alang sa sala—lubagon niya ang ulo niini gikan sa liog apan dili kini ibulag gikan sa lawas. ");
INSERT INTO cebulb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Unya iwisikwisik niya ang ubang dugo sa halad alang sa sala ngadto sa kilid sa halaran, ug paagason niya ang nahibiling dugo ngadto sa kinaubsang bahin sa halaran. Mao kini ang halad alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Unya ihalad niya ang ikaduha nga langgam ingon nga halad sinunog, sumala sa gihulagway sa mga gitudlo, ug ang pari ang maghimo ug pagpapas sa sala alang kaniya, ug mapasaylo na ang tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Apan kung dili siya makapalit ug duha ka salampati o duha ka pispis nga tukmo, kinahanglan nga magdala siya ug ikanapulo nga bahin sa epha sa labing maayo nga harina ingon nga halad alang sa sala. Kinahanglan dili niya kini sagolan ug lana o bisan unsa nga insenso, tungod kay halad man kini alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kinahanglan nga dad-on niya kini ngadto sa pari, ug magkuha ug usa ka kumkom niini ang pari ingon nga timaan sa kinatibuk-an nga halad ug unya sunogon kini ngadto sa halaran, sa ibabaw sa mga halad sinunog alang kang Yahweh. Mao kini ang halad alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ang pari ang maghimo ug pagpapas sa sala alang kaniya, ug mapasaylo na ang tawo. Mapanag-iya sa pari ang mga nahibilin gikan sa halad, ingon man ang halad nga trigo.'” ");
INSERT INTO cebulb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Unya nakigsulti si Yahweh ngadto kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Kung mosupak si bisan kinsa niini nga sugo ug makasala batok sa mga butang nga gipanag-iya ni Yahweh, apan wala kini tuyoa, nan kinahanglan nga dad-on niya ang iyang halad sa dili tinuyoan nga sala ngadto kang Yahweh. Torong karnero nga walay tatsa nga gikan sa panon sa mga karnero ang kinahanglan nga ihalad; kinahanglan nga ang kantidad niini sama sa kantidad sa plata nga mga shekel— ang shekel sa balaang dapit—ingon nga halad sa dili tinuyoan nga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kinahanglan nga mopasig-uli siya kang Yahweh alang sa iyang nabuhat nga sayop uban sa balaan nga mga butang, ug kinahanglan nga dugangan pa niya kini ug 1/5 ug ihatag kini ngadto sa pari. Unya maghimo ang pari ug pagpapas sa sala alang kaniya uban sa toro nga baka alang sa halad sa dili tinuyoan nga sala, ug pasayloon kanang tawhana. ");
INSERT INTO cebulb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kung nakasala ang si bisan kinsa ug nagbuhat sa mga butang nga wala gipabuhat ni Yahweh, bisan ug wala siyay kasayoran niini, sad-an gihapon siya ug kinahanglan nga manubag siya sa iyang sala. ");
INSERT INTO cebulb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Kinahanglan nga magdala siya ug torong karnero nga walay tatsa nga gikan sa panon sa mga karnero, sumala sa insaktong kantidad, ingon nga halad alang sa dili tinuyoan nga sala ngadto sa pari. Unya maghimo ug pagpapas ang pari alang sa sala nga iyang nahimo, nga dili tinuyoan, ug pasayloon siya. ");
INSERT INTO cebulb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Mao kini ang halad alang sa dili tinuyoan nga sala, ug sad-an gayod siya sa atubangan ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Kung makasala ang si bisan kinsa ug mosupak sa sugo batok kang Yahweh, pinaagi sa pagpanglimbong sa iyang silingan sa usa ka butang nga gipiyal kaniya, o kung nanikas o nangawat siya kaniya, o nagdaugdaog sa iyang silingan, ");
INSERT INTO cebulb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o nakakaplag siya ug usa ka butang nga nawala nga iya sa iyang silingan ug namakak mahitungod niini, ug nanumpa pa gani niini sa bakak, o kung makasala ang tawo sa mga butang nga sama niini, ");
INSERT INTO cebulb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ug unya mahitabo kini, kung sad-an gayod siya, kinahanglang ibalik niya ang bisan unsa nga gikuha pinaagi sa pagpangawat sa pagpangdaugdaog o sa pagkuha kung unsa ang gipiyal kaniya o ang usa ka butang nga nawala nga iyang nakaplagan. ");
INSERT INTO cebulb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","O kung namakak siya mahitungod sa bisan unsang butang, kinahanglan nga ibalik niya kini nga wala gayoy kulang ug kinahanglan nga dugangan niya kini ug 1/5 aron ibayad sa nanag-iya niini, sa adlaw nga siya nakaplagan nga sad-an. ");
INSERT INTO cebulb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Unya kinahanglan nga magdala siya ug halad sa sala ngadto kang Yahweh: usa ka torong karnero nga walay tatsa nga gikan sa panon sa mga karnero nga subay sa insaktong kantidad, ingon nga halad sa sala ngadto sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Maghimo ang pari ug pagpapas sa sala alang kaniya sa atubangan ni Yahweh, ug pasayloon siya sa bisan unsang butang nga iyang nabuhat nga nakapahimo kaniya nga sad-an.” ");
INSERT INTO cebulb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Unya nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Mandoi si Aaron ug ang iyang mga anak nga lalaki, ug ingna, 'Mao kini ang balaod sa halad nga sinunog: Kinahanglan nga anaa ibabaw sa halaran ang halad sinunog sa tibuok gabii hangtod sa kabuntagon, ug padayon nga magsiga ang kalayo sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Isul-ob sa pari ang iyang mga bisti nga lino, ug isul-ob usab niya ang iyang pang-ilalaom nga sapot nga lino. Kuhaon niya ang mga abo nga nahibilin human lamoya sa kalayo ang halad sinunog ngadto sa halaran, ug ibutang niya ang mga abo sa kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hukason niya ang iyang mga bisti ug magsul-ob siya ug laing mga bisti aron pagdala sa mga abo pagawas sa kampo paingon sa hinlo nga dapit. ");
INSERT INTO cebulb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kanunay nga magsiga ang kalayo sa halaran. Kinahanglan nga dili kini mapalong, ug matag buntag sugnoran kini sa pari. Ibutang niya ang halad sinunog sumala sa insaktong han-ay niini, ug sunogon niya dinhi ang tambok nga bahin sa mga halad alang sa pagpasig-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kinahanglan nga kanunay nga magsiga ang kalayo sa halaran. Kinahanglan nga dili kini mapalong. ");
INSERT INTO cebulb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Mao kini ang balaod sa halad nga trigo. Ang maghalad niini mao ang mga anak nga lalaki ni Aaron sa atubangan ni Yahweh diha sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Magkuha ang pari ug usa ka kumkom sa labing maayo nga harina sa halad nga trigo ug sa lana ug sa insenso nga anaa sa halad nga trigo, ug sunogon niya kini ngadto sa halaran aron maghatag kini ug kahumot nga makapahimuot ingon nga kinatibuk-ang halad. ");
INSERT INTO cebulb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kan-on ni Aaron ug sa iyang mga anak nga lalaki ang bisan unsa nga nahibilin sa halad. Kinahanglan nga kan-on kini nga walay igpapatubo diha sa balaan nga dapit. Pagakan-on nila kini ngadto sa hawanan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Kinahanglan nga lutoon kini nga walay igpapatubo. Gihatag ko kini isip ilang bahin sa akong mga halad pinaagi sa kalayo. Labing balaan kini, sama sa halad alang sa sala ug sa halad sa sala nga dili tinuyoan sala. ");
INSERT INTO cebulb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Sa tanang panahon nga moabot sa tibuok kaliwat sa imong kaliwatan, makahimo sa pagkaon niini isip iyahang bahin ang si bisan kinsa nga kaliwat ni Aaron nga lalaki, nga gikan sa mga halad sinunog alang kang Yahweh. Mamahimong balaan ang si bisan kinsa nga makahikap niini.'” ");
INSERT INTO cebulb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Busa nakigsulti na usab si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Mao kini ang halad ni Aaron ug sa iyang mga anak nga lalaki, nga ilang ihalad ngadto kang Yahweh sa adlaw nga madihogan ang matag-anak niya nga lalaki: ang ikanapulo nga bahin sa epha sa labing maayo nga harina ingon nga naandang halad nga trigo, katunga niini sa buntag ug ang katunga niini sa gabii. ");
INSERT INTO cebulb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Lutoon kini didto sa karahay nga adunay lana. Sa dihang motuhop na kini, dad-on mo kini didto. Ihalad nimo ang halad nga trigo nga gipikaspikas aron nga mohatag kini ug kahumot nga makapahimuot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ang mohalad niini mao ang anak nga lalaki sa labawng pari nga mahimong bag-ong labawng pari gikan sa iyang mga anak nga lalaki. Ingon nga gimando kini hangtod sa kahangtoran, pagasunogon kining tanan ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Pagasunogon sa hingpit ang matag trigo nga ihalad sa pari. Ug kinahanglan nga dili kini kaonon.” ");
INSERT INTO cebulb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Nakigsulti na usab si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Pagpakigsulti kang Aaron ug sa iyang mga anak nga lalaki, ug ingna, 'Mao kini ang balaod sa halad alang sa sala: Kinahanglan nga ihawon ang halad alang sa sala ngadto sa dapit kung asa giihaw ang halad sinunog sa atubangan ni Yahweh. Labing balaan kini. ");
INSERT INTO cebulb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kan-on kini sa pari nga maoy naghalad niini alang sa sala. Kinahanglan nga kan-on lamang kini ngadto sa balaang dapit sa hawanan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Mahimong balaan ang bisan unsang masaghiran sa karne niini, ug kung mawisikan ug dugo ang bisan unsa nga panapton, kinahanglan nga labhan, ang bahin nga nawisikan, ngadto sa balaang dapit. ");
INSERT INTO cebulb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Apan kinahanglan nga buakon ang kolon nga gipabukalan niini. Kung gipabukalan kini diha sa tumbaga nga kolon, kinahanglan nga hinisan kini ug hugasan sa hinlo nga tubig. ");
INSERT INTO cebulb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Makahimo sa pagkaon ang si bisan kinsang lalaki diha sa mga pari tungod kay labing balaan man kini. ");
INSERT INTO cebulb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Apan kinahanglan nga dili ka-on ang bisan unsa nga halad sa sala nga diin ang dugo gidala ngadto sa tolda nga tigomanan aron sa paghimo ug pagpapas alang sa sala ngadto sa balaang dapit. Kinahanglan nga pagasunogon kini. ");
INSERT INTO cebulb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Mao kini ang balaod sa dili tinuyoan nga sala. Labing balaan kini. ");
INSERT INTO cebulb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kinahanglan nga ihawon nila ang halad sa dili tinuyoan nga sala ngadto sa dapit nga ihawanan niini, ug kinahanglan nga iwisikwisik nila ang dugo sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ihalad usab ang tanang tambok niini: ang tambok nga ikog, ang tambok nga nagaputos sa sulod sa ginhawaang mga bahin, ");
INSERT INTO cebulb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ang duha ka kidni ug ang tambok nga anaa niini, nga tapad sa mga dapidapi, ug ang nakaputos sa atay, ug sa mga kidni—kinahanglan nga kuhaon kining tanan. ");
INSERT INTO cebulb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kinahanglan nga sunogon sa pari kini nga mga bahin ngadto sa halaran isip halad sinunog alang kang Yahweh. Mao kini ang halad sa dili tinuyoan nga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Makahimo sa pagkaon ang tanang lalaki nga mga pari sa mga bahin niini nga halad. Kinahanglan nga pagakan-on kini ngadto sa balaang dapit tungod kay labing balaan man kini. ");
INSERT INTO cebulb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ang halad alang sa sala sama lamang sa halad sa dili tinuyoan nga sala. Managsama lamang ang balaod nga gipatuman alang niining duha. Gipanag-iya na kini sa pari nga naghimo niini nga pagpapas sa sala alang nila. ");
INSERT INTO cebulb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mapanag-iya sa pari nga naghalad sa halad sinunog ang panit niana nga halad. ");
INSERT INTO cebulb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ang matag trigo nga giluto didto sa pugon, ug ang halad nga giluto sa karahay o sa lutoanan nga kolon mapanag-iya sa pari nga maoy naghalad niini. ");
INSERT INTO cebulb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Mapanag-iya usab sa tanang kaliwatan ni Aaron, ang matag trigo nga halad, uga man kini o sinagolan ug lana. ");
INSERT INTO cebulb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Mao kini ang balaod sa halad nga alang sa pagpasig-uli nga ihalad sa mga tawo ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kung adunay maghalad niini aron sa pagpasalamat, kinahanglan nga maghalad siya ug mga keyk nga walay igpapatubo, apan sinagolan ug lana, ug mga keyk nga walay igpapatubo, apan gipahiran ug lana, ug keyk nga hinimo pinaagi sa labing maayo nga harina nga gisagolan ug lana. ");
INSERT INTO cebulb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ug alang usab sa katuyoan sa pagpasalamat, kinahanglan nga maghalad siya ug keyk nga adunay igpapatubo alang sa halad sa pagpasig-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Maghatag siya ug usa ka matang niini nga mga halad ingon nga halad ngadto kang Yahweh. Mapanag-iya kini sa pari nga nagwisikwisik sa dugo sa halad alang sa pagpasig-uli ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Kinahanglan nga kan-on sa tawo nga naghatag ug halad alang sa pasig-uli ang maong karne niana nga adlaw sa paghalad aron sa paghatag ug pagpasalamat. Kinahanglan nga wala siyay ibilin niini pagkabuntag. ");
INSERT INTO cebulb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Apan kung ang katuyoan sa iyang paghalad mao ang pagpakigsaad, o alang sa halad nga kaugalingon nga kabubut-on, kinahanglan nga ka-on ang maong karne sa adlaw nga naghalad siya, apan ang bisan unsa nga nahibilin niini mahimong kaonon sa pagkasunod adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Apan, kinahanglan nga sunogon ang bisan unsa nga karne nga halad nga mahibilin hangtod sa ikatulong adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kung kaonon ang bisan unsa nga karne nga halad gikan sa halad sa pagpasig-uli sa ikatulong adlaw, dili na kini pagadawaton, ni dili na kini paga-isipon nga iya sa naghalad niini. Mahimo kining dulumtanan nga butang, ug ang tawo nga mokaon niini maoy mahimong sad-an. ");
INSERT INTO cebulb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Dili na angay nga kaonon ang bisan unsa nga karne nga masaghid sa hugaw nga butang. Kinahanglang sunogon kini. Ug mahimong kaonon ang uban pa nga nahibilin nga karne ni bisan kinsa nga hinlo. ");
INSERT INTO cebulb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Bisan pa man niana, ang mahugaw nga tawo nga mikaon sa karne nga gikan sa gihalad nga halad alang sa pagpasig-uli nga iya ni Yahweh—kinahanglan papahawaon kanang tawhana gikan sa iyang katawhan ");
INSERT INTO cebulb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kung adunay tawo nga makahikap sa bisan unsang mahugaw nga butang—sa kahugaw sa tawo, o hugaw nga mananap, o sa pipila ka mahugaw o dulumtanan nga butang, ug kung mikaon siya sa uban nga karne sa halad alang sa papasig-uli nga iya ni Yahweh, kinahanglan nga papahawaon kanang tawhana gikan sa iyang katawhan.'” ");
INSERT INTO cebulb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Unya nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Pakigsultihi sa katawhan sa Israel ug ingna sila, 'Kinahanglan nga dili ninyo kaonon ang tambok sa torong baka o sa karnero o sa kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mahimong gamiton sa uban pang mga katuyoan ang tambok sa mananap nga namatay nga wala gihalad, o ang tambok sa mananap nga gikuniskunis sa ihalas nga mga mananap, apan dili gayod ninyo kini angay kaonon. ");
INSERT INTO cebulb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Kinahanglan nga papahawaon gikan sa iyang katawhan si bisan kinsa nga mokaon sa mga tambok sa mananap nga gihalad sa kalalakin-an ingon nga halad nga gisunog ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kinahanglan nga dili kamo mokaon sa bisan unsa nga dugo ngadto sa inyong mga panimalay, gikan man kini sa langgam o sa mananap. ");
INSERT INTO cebulb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Si bisan kinsa nga mokaon sa bisan unsang dugo, kinahanglan nga papahawaon gikan sa iyang katawhan.'” ");
INSERT INTO cebulb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Busa nakigsulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Pagpakigsulti sa katawhan sa Israel ug ingna sila, 'Ang tawo nga naghalad ug halad sa pagpasig-uli ngadto kang Yahweh kinahanglan nga magdala ug bahin sa iyang halad ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Kinahanglan nga siya mismo ang magdala sa halad nga pagasunogon alang kang Yahweh. Kinahanglan nga dad-on niya ang tambok uban sa dughan, aron nga ibayaw ang dughan ingon nga halad nga binayaw ngadto sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kinahanglan nga sunogon sa mga pari ang tambok ngadto sa halaran, apan maiya ni Aaron ug sa iyang mga kaliwat ang dughan. ");
INSERT INTO cebulb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kinahanglan nga ihatag ninyo ang tuong paa ngadto sa pari ingon nga halad gikan sa inyong mga halad alang sa pagpasig-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ang pari, nga usa sa mga kaliwat ni Aaron, nga naghalad sa dugo sa halad sa pagpasig-uli ug ang tambok—maoy angay nga makaangkon sa tuong paa ingon nga iyang bahin sa halad. ");
INSERT INTO cebulb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Tungod kay gikuha nako gikan sa katawhan sa Israel, ang dughan alang sa binayaw nga halad, ug ang paa nga ginahatag, ug gihatag kini ngadto kang Aaron nga pari ug sa iyang mga anak nga lalaki ingon sa naandan nila nga bahin. ");
INSERT INTO cebulb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Mao kini ang bahin ni Aaron uban sa iyang mga kaliwat nga gikan sa mga halad nga sinunog alang kang Yahweh, sa adlaw nga gihalad sila ni Moises nga mag-alagad kang Yahweh sa buluhaton sa pagkapari. ");
INSERT INTO cebulb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Mao kini ang bahin nga gimando ni Yahweh nga ihatag ngadto kanila gikan sa katawhan sa Israel, sa adlaw nga iyang gidihogan ang mga pari. Ila gayod kini nga bahin sa tibuok nilang kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Mao kini ang balaod sa halad sinunog, halad nga trigo, halad alang sa sala, halad sa dili tinuyoan nga sala, halad sa paggahin, ug sa mga halad alang sa pagpasig-uli, ");
INSERT INTO cebulb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","mahitungod kini sa mga mando nga gihatag ni Yahweh kang Moises sa Bukid sa Sinai sa adlaw nga gimandoan niya ang katawhan sa Israel nga maghalad sa ilang mga halad ngadto kang Yahweh didto sa kamingawan sa Sinai.'” ");
INSERT INTO cebulb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nakigsulti si Yahweh kang Moises, nga nag-ingon ");
INSERT INTO cebulb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kuhaa si Aaron ug ang iyang mga anak nga lalaki uban kaniya, ang mga bisti ug ang igdidihog nga lana, ang torong baka nga halad alang sa sala, ang duha ka torong karnero, ug ang bukag nga adunay tinapay nga walay igpapatubo. ");
INSERT INTO cebulb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Tigoma ang tanang pundok sa katawhan didto sa pultahan tolda nga tigomanan.” ");
INSERT INTO cebulb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Busa gibuhat ni Moises ang gisugo ni Yahweh kaniya, ug nagtigom ang pundok sa katawhan ngadto sa pultahan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Unya giingnan ni Moises ang pundok sa katawhan, “Mao kini ang gisugo ni Yahweh nga kinahanglang buhaton.” ");
INSERT INTO cebulb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Gidala ni Moises si Aaron ug ang mga anak nga lalaki niini ug giligoan sila. ");
INSERT INTO cebulb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Gisul-oban niya si Aaron ug taas nga bisti ug gibaksan siya ug bakos nga panapton, gibistihan siya ug kupo ug gisul-ob kaniya ang efod, ug unya gibaksan siya sa labing maayo nga pagkatahi nga bakos sa efod ug gihikot kini kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Gitaod niya kaniya ang sapaw sa dughan nga may bulsa-bulsa, ug gisulod niya ang Urim ug ang Tumim didto sa sapaw nga may bulsa-bulsa. ");
INSERT INTO cebulb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Gipurongan niya siya ug turban, ug sa atubangan sa turban, gibutang niya ang dayandayang bulawan, ang balaan nga korona, sumala sa gisugo ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Gikuha ni Moises ang igdidihog nga lana, gidihogan ang tabernakulo ug ang tanan nga anaa niini ug gigahin kini ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Giwisikwisikan niya ug lana ang halaran sa makapito ka higayon, ug gidihogan ang halaran ug ang tanang kagamitan niini, ug ang dakong panaksan ug ang tungtonganan niini, aron igahin kini ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Gibuboan niya ug gamayng igdidihog nga lana ang ulo ni Aaron ug gidihogan siya aron igahin siya. ");
INSERT INTO cebulb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Gidala ni Moises ang mga anak nga lalaki ni Aaron ug gibistihan sila ug kupo. Gibaksan niya sila ug gipurongan sila ug panapton nga lino, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Gidala ni Moises ang torong baka nga halad alang sa sala ug gitapion ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo sa torong baka nga ilang gidala nga halad alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Giihaw niya kini, ug gikuha ang dugo ug gipahid kini sa mga sungaysungay sa halaran pinaagi sa iyang tudlo, giputli ang halaran, gibubo ang dugo sa kinaubosang bahin sa halaran, ug gigahin kini alang sa Dios aron sa paghimo ug pagpapas alang niini. ");
INSERT INTO cebulb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Gikuha niya ang tanang tambok nga anaa sa ginhawaang mga bahin sa mananap, ang tambok nga nagputos sa atay, ug ang duha ka mga kidni ug ang tambok niini, ug gisunog kining tanan ni Moises ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Apan gisunog ang torong baka, ang panit niini, ang karne, ug ang hugaw niini sa gawas sa kampo, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Gidala ni Moises ang torong karnero alang sa halad sinunog, ug gitapion ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot ngadto sa ulo sa torong karnero. ");
INSERT INTO cebulb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Giihaw niya kini ug giwisikwisik ang dugo niini sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Gihiwahiwa niya ang torong karnero ug gisunog ang ulo ug ang mga hiniwa nga karne ug ang tambok. ");
INSERT INTO cebulb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Gihugasan niya ang ginhawaang mga bahin sa mananap ug ang mga tiil, ug gisunog niya ang tibuok torong karnero ngadto sa halaran. Usa kini ka halad sinunog nga naghatag ug kahumot nga makapahimuot, halad nga gisunog nga alang kang Yahweh sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Unya gidala ni Moises ang laing torong karnero, ang gigahin nga torong karnero, ug gitapion ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo sa torong karnero. ");
INSERT INTO cebulb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Giihaw kini ni Aaron, ug gikuha ni Moises ang ubang dugo niini ug gipahid kini sa tumoy sa tuong dalunggan ni Aaron, sa kumagko sa iyang tuong kamot, ug sa kumagko sa iyang tuong tiil. ");
INSERT INTO cebulb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Gidala niya ang mga anak nga lalaki ni Aaron, ug gipahiran niya ug gamayng dugo ang tumoy sa ilang dalunggan, ang kumagko sa ilang tuong kamot, ug ang kumagko sa ilang tuong tiil. Unya giwisikwisik ni Moises ang dugo niini sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Gikuha niya ang tambok, ang tambok sa ikog, ang tanang tambok nga anaa sa ginhawaang mga bahin sa mananap, ang tambok nga nagputos sa atay, ang duha ka mga kidni ug ang tambok niini, ug ang tuo nga paa. ");
INSERT INTO cebulb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Mikuha siya ug usa kabuok tinapay nga walay igpapatubo, gikan sa bukag sa tinapay nga walay igpapatubo nga gihalad kang Yahweh, ug usa kabuok tinapay nga adunay lana, ug usa ka tinapay nga nipis, ug gibutang kini sa tambok ug sa tuo nga paa. ");
INSERT INTO cebulb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Gibutang niya kining tanan sa mga kamot ni Aaron ug sa mga kamot sa iyang mga anak nga lalaki ug gibayaw kini sa atubangan ni Yahweh ingon nga binayaw nga halad. ");
INSERT INTO cebulb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Unya gikuha kini ni Moises gikan sa ilang mga kamot ug gisunog kini ngadto sa halaran alang sa halad sinunog. Halad kini nga gigahin ug naghatag ug humot nga makapahimuot. Halad kini nga gisunog alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Gikuha ni Moises ang dughan ug gibayaw kini ingon nga binayaw nga halad alang kang Yahweh. Mao kini ang bahin ni Moises sa torong karnero alang sa pagtugyan sa pagkapari, sumala sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mikuha si Moises ug gamayng igdidihog nga lana ug ang dugo nga atua sa halaran; giwisikwisik niya kini ngadto kang Aaron, sa iyang mga bisti, sa iyang mga anak nga lalaki, ug sa mga bisti sa iyang mga anak nga lalaki nga uban kaniya. Niini nga pamaagi gigahin niya si Aaron ug ang iyang mga bisti, ug ang iyang mga anak nga lalaki ug ang ilang mga bisti ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Busa giingnan ni Moises si Aaron ug ang iyang mga anak nga lalaki, “Lutoa ang karne ngadto sa pultahan sa tolda nga tigomanan, ug kaona kini didto ug ang gigahin nga tinapay nga anaa sa bukag, sumala sa akong gisugo, nga nag-ingon, 'Kaonon kini ni Aaron ug sa iyang mga anak nga lalaki.' ");
INSERT INTO cebulb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kinahanglan nga sunogon ninyo ang bisan unsa nga mabilin sa karne ug sa tinapay. ");
INSERT INTO cebulb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kinahanglan nga dili kamo mogawas sa pultahan sa tolda nga tigomanan sulod sa pito ka adlaw, hangtod sa adlaw nga mahuman na ang paggahin kaninyo. Kay balaanon kamo ni Yahweh sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kung unsa ang nabuhat niining adlawa— nagsugo si Yahweh nga pagabuhaton aron sa pagpapas sa sala alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Magpabilin kamo sa adlaw ug gabii sulod sa pito ka mga adlaw ngadto sa pultahan sa tolda nga tigomanan, ug tumanon ang sugo ni Yahweh, aron dili kamo mamatay, tungod kay mao kini ang gisugo kanako.” ");
INSERT INTO cebulb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Busa gibuhat ni Aaron ug sa iyang mga anak nga lalaki ang tanang mga butang nga gisugo ni Yahweh kanila pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sa ikawalo nga adlaw gipatawag ni Moises si Aaron ug ang iyang mga anak nga lalaki ug ang mga kadagkoan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Miingon siya kang Aaron, “Pagkuha ug nating baka gikan sa panon aron ihalad alang sa sala, ug torong karnero nga walay tatsa alang sa halad sinunog, ug ihalad kini sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kinahanglan nga makigsulti ka sa katawhan sa Israel ug ingna, 'Pagkuha ug laking kanding aron ihalad alang sa sala ug usa ka nating baka ug usa ka nating karnero, nga usa pa lamang katuig ang panuigon ug walay tatsa, alang sa halad sinunog; ");
INSERT INTO cebulb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","pagkuha usab ug torong baka ug torong karnero alang sa mga halad sa pagpasig-uli aron ihalad sa atubangan ni Yahweh, ug halad nga trigo nga sinagolan ug lana, tungod kay mopakita si Yahweh kaninyo karong adlawa.'” ");
INSERT INTO cebulb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Busa gidala nila ang tanang gisugo ni Moises ngadto sa tolda nga tigomanan, ug nangabot ang tanang pundok sa katawhan sa Israel ug mitindog sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Unya miingon si Moises, “Mao kini ang gisugo ni Yahweh kaninyo nga buhaton, aron nga mopakita ang iyang himaya diha kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Miingon si Moises kang Aaron, “Adto duol sa halaran ug ihalad ang imong halad alang sa sala ug ang halad sinunog, ug paghimo ug pagpapas sa sala alang sa imong kaugalingon ug alang sa katawhan, ug paghalad ug halad alang sa katawhan aron sa pagpapas sa sala alang kanila, sumala sa gisugo ni Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Busa mipaduol si Aaron ngadto sa halaran ug giihaw niya ang nating baka aron ihalad alang sa sala, nga alang sa iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Gidala sa mga anak nga lalaki ni Aaron ang dugo ngadto kaniya, ug gituslob niya ang iyang tudlo niini ug gipahid kini sa mga sungaysungay sa halaran; unya gibubo niya ang dugo sa kinaubosang bahin sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Apan, gisunog niya ang tambok, ang mga kidni, ug ang mga tambok nga nagputos sa atay ngadto sa halaran ingon nga halad alang sa sala, sumala sa gisugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Gisunog niya ang karne ug ang panit didto sa gawas sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Giihaw ni Aaron ang halad sinunog, ug gihatag kaniya sa iyang mga anak nga lalaki ang dugo, diin giwisikwisik niya sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Unya gihatag nila kaniya ang halad sinunog, sa tinagsa, uban sa ulo, ug gisunog niya kini ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Gihinloan niya ang ginhawaang mga bahin sa mananap ug ang mga tiil ug gisunog kini sa ibabaw sa halad sinunog ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Gidala ni Aaron ang kanding nga mao ang halad alang sa katawhan— unya gikuha kini ingon nga halad alang sa ilang sala ug giihaw kini; gihalad niya kini alang sa sala, sama sa iyang gibuhat sa unang kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Gidala niya ang halad sinunog ug gihalad kini sumala sa gisugo ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Gidala niya ang halad nga trigo; gipuno niya ang iyang kamot niini ug gisunog kini ngadto sa halaran, uban sa halad sinunog sa kabuntagon. ");
INSERT INTO cebulb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Giihaw usab niya ang torong baka ug torong karnero, ang halad nga alang sa pagpasig-uli, nga alang sa katawhan. Gihatag sa iyang mga anak nga lalaki ang dugo ngadto kaniya, nga diin giwisikwisik niya sa matag kilid sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Apan, gilaplap nila ang tambok sa torong baka ug sa torong karnero, ang tambok nga ikog, ang tambok nga nagputos sa ginhawaang mga bahin sa mananap, ang mga kidni, ug ang tambok nga nagputos sa atay. ");
INSERT INTO cebulb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Gikuha nila ang mga bahin nga nalaplap ug gibutang kini ngadto sa mga dughan sa mananap, ug unya gisunog ni Aaron ang tambok ngadto sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Gibayaw ni Aaron ang mga dughan sa mananap ug ang tuong paa ingon nga binayaw nga halad sa atubangan ni Yahweh, sumala sa gisugo ni Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Unya giisa ni Aaron ang iyang mga kamot ngadto sa katawhan ug gipanalanginan sila; unya mikanaog siya gikan didto sa gihalad nga halad alang sa sala, sa halad sinunog, ug sa halad nga alang sa pagpasig-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Miadto si Moises ug Aaron ngadto sa tolda nga tigomanan, unya migawas pag-usab ug gipanalanginan ang katawhan, ug mipakita ang himaya ni Yahweh sa tanang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Migula ang kalayo gikan kang Yahweh ug gilamoy ang halad sinunog ug ang tambok nga anaa sa halaran. Sa dihang nakita kini sa tanang katawhan, naninggit sila ug mihapa. ");
INSERT INTO cebulb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nagkuha sa ilang tagsatagsa ka butanganan sa insenso, si Nadab ug si Abihu, nga mga anak nga lalaki ni Aaron, gibutangan kini ug kalayo, ug unya ang insenso. Unya naghalad sila ug sinunog nga wala gitugotan sa atubangan ni Yahweh, nga wala niya gisugo kanila nga ihalad. ");
INSERT INTO cebulb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Busa migula ang kalayo nga gikan kang Yahweh ug gilamoy sila, ug nangamatay sila sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Unya miingon si Moises kang Aaron, “Mao kini ang gisulti ni Yahweh sa dihang miingon siya, 'Ipadayag ko ang akong kabalaan niadtong moduol kanako. Mahimaya ako sa atubangan sa tanang katawhan.”” Wala misulti si Aaron ug bisan unsa. ");
INSERT INTO cebulb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Gitawag ni Moises si Mishael ug Elzafan, nga mga anak nga lalaki ni Uziel nga uyoan ni Aaron, ug miingon kanila, “Dali kamo ug dad-a ang inyong mga igsoon pagawas sa kampo gikan sa atubangan sa tabernakulo.” ");
INSERT INTO cebulb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Busa mipaduol sila ug gidala sila, pagawas sa kampo, nga nagsuot pa gihapon sa ilang parianon nga mga bisti, sumala sa gisugo ni Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Unya miingon si Moises kang Aaron ug kang Eleazar ug kang Itamar, nga iyang mga anak nga lalaki, “Ayaw ipadunghay ang inyong mga buhok, ug ayaw gisia ang inyong mga bisti, aron nga dili kamo mangamatay, ug aron nga dili masuko si Yahweh sa tibuok pundok sa katawhan. Apan tugoti nga magbangotan ang inyong kaparyentihan, ang tibuok panimalay sa Israel, alang niadtong mga gisunog ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kinahanglan nga dili kamo mogawas gikan sa pultahan sa tolda nga tigomanan, o mamatay kamo, kay ang igdidihog nga lana ni Yahweh anaa diha kaninyo.” Busa nagbuhat sila sumala sa mga sugo ni Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nakigsulti si Yahweh kang Aaron, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Sa dihang moadto kamo ngadto sa tolda nga tigomanan, ayaw pag-inom ug bino ug isog nga ilimnon, ikaw, o ang imong mga anak nga lalaki nga nahibilin uban kanimo, aron nga dili kamo mangamatay. Mao kini ang balaod nga magpabilin hangtod sa tibuok nga mga kaliwatan sa inyong katawhan, ");
INSERT INTO cebulb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","aron sa pag-ila sa kalainan tali sa balaan ug sa dili balaan, ug tali sa hugaw ug sa hinlo, ");
INSERT INTO cebulb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","aron nga matudlo ninyo sa katawhan sa Israel ang tanang balaod nga gisugo ni Yahweh pinaagi kang Moises.” ");
INSERT INTO cebulb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Nakigsulti si Moises kang Aaron ug kang Eleazar ug kang Itamar, nga nahibilin niya nga mga anak nga lalaki, “Kuhaa ang halad nga trigo nga nahibilin sa mga halad sinunog nga alang kang Yahweh, ug kaona kini nga walay igpapatubo tapad sa halaran, tungod kay labing balaan man kini. ");
INSERT INTO cebulb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kinahanglan nga kaonon ninyo kini sa balaan nga dapit, tungod kay mao kini ang inyong bahin ug bahin sa inyong mga anak nga lalaki sa mga halad sinunog nga alang kang Yahweh, kay mao kini ang gisugo kanako nga isulti kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ang dughan nga gibayaw ug ang paa nga gihalad ngadto kang Yahweh, kinahanglan nga kaonon ninyo sa hinlo nga dapit nga makapahimuot sa Dios. Kinahanglan nga kaonon ninyo kadtong mga bahin, ikaw ug ang imong mga anak nga lalaki ug mga babaye nga uban kanimo, kay gihatag sila ingon nga imong bahin ug bahin sa imong mga anak nga lalaki gikan sa mga halad sa pakigdait nga mga halad sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kinahanglan nga dad-on nila ang paa nga gihalad ug ang dughan nga gibayaw, uban sa mga halad sinunog nga tambok, aron nga ibayaw sa atubangan ni Yahweh. Maimo kini ug sa imong mga anak nga lalaki nga uban kanimo ingon nga bahin hangtod sa kahangtoran, sumala sa gisugo ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Unya nangutana si Moises mahitungod sa kanding nga halad alang sa sala, ug nasayran niya nga nasunog na kini. Busa nasuko siya kang Eleazar ug kang Itamar, ang nabilin nga mga anak nga lalaki ni Aaron; miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nganong wala man ninyo kaona ang halad nga alang sa sala didto sa tabernakulo, nga balaan man unta kaayo kini, ug gihatag man unta kini ni Yahweh kaninyo aron magwagtang sa kasal-anan sa pundok sa katawhan, aron sa paghimo ug pagpapas sa ilang sala sa iyang atubangan? ");
INSERT INTO cebulb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tan-awa, wala gidala ang dugo niini ngadto sa sulod sa tabernakulo, busa gikaon unta ninyo kini didto sa tabernakulo, sumala sa akong gisugo.” ");
INSERT INTO cebulb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Unya mitubag si Aaron kang Moises, “Tan-awa, karong adlawa gihalad nila ang ilang halad alang sa sala ug ang halad sinunog sa atubangan ni Yahweh, ug nahitabo kining butanga kanako karong adlawa. Kung gikaon ko ang halad alang sa sala karong adlawa, makapahimuot ba kini sa panan-aw ni Yahweh?” ");
INSERT INTO cebulb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Sa pagkadungog ni Moises niana, miuyon siya. ");
INSERT INTO cebulb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Nakigsulti si Yahweh ngadto kang Moises ug kang Aaron, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Pagpakigsulti sa katawhan sa Israel, ug ingna sila, “Mao kini ang mga buhing binuhat nga mahimo ninyong kaonon taliwala sa tanang mga mananap nga anaa sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Makahimo kamo sa pagkaon sa bisan unsang mananap nga pikas ug kuko, ug nagausap ug balik sa pagkaon niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Apan, ayaw gayod kaona ang pipila sa mga mananap nga nagausap ug balik sa iyang pagkaon apan dili pikas ug kuko, mga mananap sama sa kamelyo, tungod kay nagausap kini pagbalik sa pagkaon niini apan dili pikas ug kuko. Busa hugaw ang kamelyo alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Hugaw usab alang kaninyo ang ilaga sa bato, tungod kay nagausap kini pagbalik sa pagkaon apan dili kini pikas ug kuko. ");
INSERT INTO cebulb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Hugaw alang kaninyo ang kuneho tungod kay bisan pa ug nagausap kini pagbalik sa iyang pagkaon, dili man pikas ang kuko niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Hugaw kini alang kaninyo ang baboy, tungod kay bisan pa ug pikas ang kuko niini, dili man kini nagausap pagbalik sa iyang kinaon. ");
INSERT INTO cebulb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kinahanglan nga dili kamo mokaon sa bisan unsa nga karne niini, ni mogunit sa mga patayng lawas niini. Hugaw kini alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ang mga mananap nga anaa sa tubig nga mahimo ninyong kaonon mao kadtong adunay mga silik ug mga himbis, maanaa man kini sa kadagatan o sa kasubaan. ");
INSERT INTO cebulb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Apan ang tanang buhing mga binuhat nga walay mga silik ug mga himbis nga anaa sa kadagatan o kasubaan, lakip na ang tanan nga naglihok sa tubig ug ang tanang mga buhing binuhat nga anaa sa tubig— kinahanglan nga dulumtanan kini alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Sanglit kinahanglan man kining dumtan, kinahanglan nga dili ninyo kaonon ang mga karne niini; kinahanglan nga mahimo usab nga dulumtanan ang mga patayng lawas niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Kinahanglan nga dulumtanan alang kaninyo ang bisan unsang mananap nga walay mga silik o mga himbis diha sa tubig. ");
INSERT INTO cebulb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Mao kini ang mga langgam nga kinahanglan dulumtanan alang kaninyo ug dili ninyo angayng kaonon: ang agila, ang buwitre, ");
INSERT INTO cebulb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ang esmerenhon, ang bisan unsang matang sa banog, ");
INSERT INTO cebulb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ang bisan unsang matang sa uwak, ");
INSERT INTO cebulb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ang asbestros, ang pungaw, ang laro, ug ang bisan unsang matang sa ananangkil. ");
INSERT INTO cebulb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Kinahanglan nga dulumtanan usab alang kaninyo ang gagmay ug dagko nga kuwago, ang gamaw, ");
INSERT INTO cebulb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ang lapay ug ang itik, ang pelikano, ");
INSERT INTO cebulb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ang kalamon, ang nagkalainlaing matang sa tabon, ang abobilya, ug ang kabog. ");
INSERT INTO cebulb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Dulumtanan alang kaninyo ang tanang gagmay ug adunay pako nga mga mananap nga nagalakaw pinaagi sa ilang upat ka tiil. ");
INSERT INTO cebulb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Apan mahimo ninyong kaonon ang bisan unsang nagalupad nga gagmayng mga mananap nga adunay upat ka tiil kung aduna kiniy lutahan sa tungatunga alang sa paglukso sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Mahimo usab ninyong kaonon ang bisan unsang matang sa mga dulon, timos, gangis, o apan-apan. ");
INSERT INTO cebulb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Apan kinahanglan nga dulumtanan alang kaninyo ang uban pang nagalupad nga gagmayng mga mananap nga adunay upat ka tiil. ");
INSERT INTO cebulb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Mahimo kamong hugaw hangtod sa kagabhion kung hikapon ninyo ang patayng lawas sa bisan usa niini nga mga mananap. ");
INSERT INTO cebulb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Si bisan kinsa nga mokuha sa patayng lawas niini kinahanglan nga labhan niya ang iyang mga bisti ug magpabilin siyang hugaw hangtod sa kagabhion. ");
INSERT INTO cebulb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Hugaw alang kaninyo ang matag mananap nga dili hingpit ang pagkapikas sa kuko o dili mousap pagbalik sa pagkaon niini. Mahugaw ang tanan nga mohikap niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ang bisan unsa nga molakaw pinaagi sa tiil niini taliwala sa tanang mga mananap nga adunay upat ka tiil, hugaw kini alang kaninyo. Mahugaw hangtod sa kagabhion ang si bisan kinsa nga mohikap sa patayng lawas niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Si bisan kinsa nga mokuha sa patayng lawas niini kinahanglan nga molaba sa iyang mga bisti ug magpabilin siyang hugaw hangtod sa kagabhion. Mahugaw kini nga mga mananap alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Diha sa mga mananap nga nagakamang sa yuta, mao kini ang mga mananap nga hugaw alang kaninyo: ang milo, ang ilaga, ang tanang matang sa halo, ");
INSERT INTO cebulb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ang tuko, ang buaya, ang butiki, ang ibid, ug ang kamelyon. ");
INSERT INTO cebulb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sa tanang mga mananap nga nagakamang, mao kini ang mga mananap nga hugaw alang kaninyo. Magpabilin nga hugaw hangtod sa kagabhion ang si bisan kinsa nga mohikap sa patay nga lawas niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kung adunay mamatay niini ug mahulog kini sa bisan unsa nga butang, mahimong hugaw kadtong butanga, hinimo man kini sa kahoy, sa panapton, panit sa mananap, o sako. Bisan unsa paman kini ug unsa man ang gamit niini, kinahanglan kining ibutang sa tubig; magpabilin kining hugaw hangtod sa kagabhion. Unya mahinlo na kini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kung mahulogan sa hugaw nga mananap ang bisan unsa nga banga, mahugaw usab ang bisan unsa nga sulod niini, ug kinahanglan nga buakon ninyo ang maong banga. ");
INSERT INTO cebulb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ang tanang mga pagkaon nga hinlo ug gitugot nga kaonon, apan nahulog sa tubig nga gikan sa hugaw nga banga, mahugaw kini. Mahugaw ang bisan unsa nga moinom gikan sa maong banga. ");
INSERT INTO cebulb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Mahugaw ang bisan unsang butang nga mahulogan sa bisan asa nga bahin sa patayng lawas sa hugaw nga mananap, pugon man kini o mga lutoanan. Kinahanglan kining dugmokon. Hugaw kini ug kinahanglan nga ilhon ninyo kini nga hugaw. ");
INSERT INTO cebulb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Magpabiling hinlo ang sapa o atabay diin ginakuha ang mainom nga tubig kung mahulogan kini sa maong mga mananap. Apan kung adunay mohikap sa patay nga lawas sa hugaw nga mananap didto sa tubig, mahimo siyang hugaw. ");
INSERT INTO cebulb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kung mahulog ang bisan unsa nga bahin sa patayng lawas sa mananap ngadto sa mga binhi nga igtatanom, hinlo gihapon kadto nga mga binhi. ");
INSERT INTO cebulb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Apan kung butangan ug tubig ang maong mga binhi, ug kung mahulogan kini sa bisan unsa nga bahin sa patayng lawas sa mananap, nan hugaw na kini alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kung mamatay ang mananap nga mahimo ninyong kaonon, nan mahugaw ang si bisan kinsa nga mohikap niini hangtod sa kagabhion. ");
INSERT INTO cebulb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Si bisan kinsa nga mokaon sa karne niini kinahanglan nga labhan niya ang iyang mga bisti ug magpabilin siyang hugaw hangtod sa kagabhion. Si bisan kinsa nga mopunit sa maong patayng lawas sa mananap kinahanglan nga molaba sa iyang bisti ug magpabiling hugaw hangtod sa kagabhion. ");
INSERT INTO cebulb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Dulumtanan ang matag mananap nga nagakamang sa yuta; dili kini angayng kaonon. ");
INSERT INTO cebulb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ang bisan unsa nga nagakamang gamit ang iyang tiyan, ug ang bisan unsa nga nagalakaw pinaagi sa upat ka tiil, o ang bisan unsa nga daghan ug tiil—ang tanang mga mananap nga nagkamang sa yuta, kinahanglan nga dili ninyo kini kaonon, tungod kay dulumtanan man kini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kinahanglan nga dili ninyo hugawan ang inyong mga kaugalingon pinaagi sa bisan unsang mga buhing binuhat nga nagakamang; kinahanglan dili ninyo hugawan ang inyong mga kaugalingon pinaagi niini. ");
INSERT INTO cebulb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Tungod kay ako si Yahweh ang inyong Dios. Busa, kinahanglan nga balaanon ninyo ang inyong mga kaugalingon, ug pagpakabalaan, tungod kay ako balaan man. Kinahanglan nga dili ninyo hugawan ang inyong mga kaugalingon pinaagi sa bisan unsang mananap nga naglihok sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Tungod kay ako si Yahweh, ang nagpagawas kaninyo sa yuta sa Ehipto, aron nga mahimo ninyong Dios. Busa kinahanglan nga magpakabalaan kamo, tungod kay ako balaan man. ");
INSERT INTO cebulb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Mao kini ang balaod mahitungod sa mga mananap, sa mga langgam, sa matag buhing binuhat nga nagalihok sa katubigan, ug sa matag binuhat nga nagakamang sa yuta, ");
INSERT INTO cebulb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","kung diin gihatag ang kalahian tali sa hugaw ug sa hinlo, ug tali sa buhing mga butang nga mahimong kaonon ug dili mahimong kaonon.”” ");
INSERT INTO cebulb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Miingon si Yahweh ngadto kang Moises, ");
INSERT INTO cebulb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Pagpakigsulti sa katawhan sa Israel, ingna sila, 'Kung manamkon ug manganak ang usa ka babaye ug bata nga lalaki, nan mahugaw siya sulod sa pito ka adlaw, sama nga hugaw siya panahon sa mga adlaw sa iyang binulan nga regla. ");
INSERT INTO cebulb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Kinahanglan nga tulion ang bata nga lalaki sa ikawalo nga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Unya magpadayon ang pagputli sa inahan gikan sa iyang pagdugo sulod sa 33 ka adlaw. Kinahanglan nga dili siya mogunit sa bisan unsang balaan nga butang o mosulod sa tabernakulo hangtod nga wala pa mahuman ang mga adlaw sa pagputli kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Apan kung manganak siya ug bata nga babaye, nan mahugaw siya sulod sa duha ka semana, sama nga hugaw siya panahon sa iyang regla. Unya magpadayon ang pagputli sa inahan sulod sa 66 ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Sa dihang natapos na ang mga adlaw sa pagputli kaniya, alang sa anak nga lalaki o babaye, kinahanglan nga magdala siya ug nating karnero nga usa pa ka tuig ingon nga halad sinunog, ug pispis nga tukmo o salampati ingon nga halad alang sa sala, ngadto sa pultahan sa tolda nga tigomanan, ngadto sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Unya ihalad kini sa pari sa atubangan ni Yahweh ug maghimo siya ug pagpapas sa sala alang sa babaye, ug mahinlo siya gikan sa pag-agas sa iyang dugo. Mao kini ang balaod mahitungod sa babaye nga manganak ug bata nga lalaki o babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kung wala siyay ikapalit ug nating karnero, nan kinahanglan nga magkuha siya ug duha ka salampati o duha ka pispis nga tukmo, ang usa niini ingon nga halad sinunog ug ang lain pa ingon nga halad alang sa sala, ug maghimo ug pagpapas sa sala ang pari alang sa babaye; unya mahinlo na siya.”” ");
INSERT INTO cebulb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Nakigsulti si Yahweh ngadto kang Moises ug kang Aaron, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Kung adunay hubag o kugang, o butoy sa iyang panit ang usa ka tawo ug nahimo kining sakit sa panit diha sa iyang lawas, nan kinahanglan dad-on siya ngadto kang Aaron nga labaw nga pari, o ngadto sa usa sa iyang mga anak nga lalaki nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Unya susihon sa pari ang sakit nga anaa sa panit sa lawas sa maong tawo. Kung nahimong puti ang balahibo sa panit nga adunay sakit, ug kung midulot sa unod ang maong sakit, nan makatakod kini nga sakit. Human siya masusi sa pari, kinahanglan nga iyang ipahayag nga hugaw ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kung puti ang butoy sa iyang panit, ug wala kini midulot sa unod, ug kung wala miputi ang balahibo sa bahin sa panit nga adunay sakit, nan kinahanglan nga ilain sa pari ang tawo nga adunay sakit sa panit sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sa ikapito nga adlaw kinahanglan nga susihon siya sa pari aron makita kung wala ba misamot ang sakit sa panit, ug kung wala ba kini mikatag sa panit. Kung wala, nan kinahanglan nga ilain sa pari ang maong tawo sa dugang pang pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Susihon na usab sa pari ang maong tawo sa ikapito nga adlaw aron makita kung miarang-arang na kini ug wala mikatag sa panit. Kung wala, nan ipahayag sa pari nga hinlo ang maong tawo. Katolkatol lamang kini. Kinahanglan nga labhan niya ang iyang mga bisti, ug hinlo na siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Apan kung mikatag ang katolkatol sa panit human niya mapasusi ang iyang kaugalingon ngadto sa pari alang sa iyang pagpahinlo, kinahanglan nga moadto siya pagbalik sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Susihon siya sa pari aron tan-awon kung mikatag na pag-ayo ang katolkatol sa iyang panit. Kung mikatag na kini, nan kinahanglan nga ipahayag sa pari nga hugaw siya. Usa kini ka makatakod nga sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Kung adunay makatakod nga sakit sa panit ang usa ka tawo, nan kinahanglan nga dad-on siya ngadto sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Susihon siya sa pari aron tan-awon kung adunay nagnana nga hubag sa iyang panit, kung nahimong puti ang iyang panit, o kung adunay migawas nga unod diha sa hubag. ");
INSERT INTO cebulb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Kung aduna, nan hilabihan na gayod kini nga sakit sa panit, ug kinahanglan nga ipahayag sa pari nga hugaw kining tawhana. Dili na siya ilain aron nga susihon sa pari, tungod kay hugaw naman gayod siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kung mikatag na ang sakit diha sa panit ug milukop na kini sa tibuok panit sa tawo nga adunay sakit gikan sa iyang ulo hangtod sa iyang mga tiil, ug nakita kini sa pari, ");
INSERT INTO cebulb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","nan kinahanglan siyang susihon sa pari aron makita kung nalukop na ba gayod sa sakit sa panit ang iyang tibuok nga lawas. Kung nalukop na gayod kini, nan kinahanglan nga ipahayag sa pari nga hinlo na ang maong tawo nga adunay sakit sa panit. Kung miputi na kini tanan, nan hinlo na siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Apan kung nanggawas ang iyang unod, ilhon siya nga hugaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kinahanglan nga tan-awon sa pari ang nanggawas nga unod ug ipahayag nga hugaw siya tungod kay hugaw man ang nanggawas nga unod. Makatakod kini nga sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Apan kung miputi na pagbalik ang nanggawas nga unod, nan kinahanglan nga moadto kadtong tawhana sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Susihon siya sa pari aron makita kung miputi na ang unod. Kung miputi na kini, nan ipahayag sa pari nga hinlo na ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kung gihubagan ang usa ka tawo diha sa panit ug naayo na kini, ");
INSERT INTO cebulb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ug didto sa panit nga adunay hubag mitungha ang laing hubag o butoy, nga pulapula ug putiputi, nan kinahanglan nga ipakita kini sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Susihon kini sa pari aron tan-awon kung midulot ba kini sa unod, ug kung niputi ang balahibo niini nga bahin. Kung mao kana, nan kinahanglan nga ipahayag sa pari nga hugaw ang maong tawo. Makatakod kini nga sakit, kung mitubo kini sa gihubagan nga panit kaniadto. ");
INSERT INTO cebulb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Apan kung nasusi na kini sa pari ug iyang nakita nga walay puti nga balahibo sa hubag, ug dili kini dulot sa unod apan mikugang na, nan kinahanglan nga ilain siya sa pari sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kung mikatag na kini sa tibuok panit, nan kinahanglan nga ipahayag siya sa pari ingon nga hugaw. Makatakod kini nga sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Apan kung nagpabilin ang butoy sa maong bahin sa panit ug wala kini mikatag, nan ulat lamang kini sa hubag, ug kinahanglan nga ipahayag sa pari nga hinlo ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kung adunay paso ang panit ug mipulapula ug miputiputi ang unod o nagbutoy kini, ");
INSERT INTO cebulb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","nan susihon kini sa pari aron tan-awon kung niputi ba ang balahibo nga anaa sa butoy, ug kung midulot ba kini sa unod. Kung aduna man, nan makatakod kini nga sakit. Mikatag kini sa paso, ug kinahanglan nga ipahayag sa pari nga hugaw ang maong tawo. Makatakod kini nga sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Apan kung gisusi kini sa pari ug iyang nakita nga walay puti nga balahibo sa butoy, ug wala kini midulot sa unod ug mikugang na kini, nan kinahanglan nga ilain siya sa pari sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Unya kinahanglan nga susihon siya sa pari sa ikapito nga adlaw. Kung mikatag na kini sa tibuok panit, nan kinahanglan ipahayag sa pari nga hugaw ang maong tawo. Makatakod kini nga sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kung nagpabilin ang butoy sa samang bahin sa panit ug wala kini mikatag sa panit unya mikugang kini, nan mihubag kini tungod sa pagkapaso, kinahanglan nga ipahayag sa pari nga hinlo ang maong tawo, tungod kay ulat na lamang kini gikan sa paso. ");
INSERT INTO cebulb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kung adunay makatakod nga sakit sa ulo o sa suwang ang usa ka lalaki ug babaye, ");
INSERT INTO cebulb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","nan kinahanglan nga susihon sa pari ang maong tawo kung aduna bay makatakod nga sakit aron makita kung midulot ba kini sa unod, ug kung adunay dalag, ug nipis nga balahibo niini. Kung aduna, nan kinahanglan nga ipahayag sa pari nga hugaw ang maong tawo. Nukanuka kini, usa ka makatakod nga sakit diha sa ulo o sa suwang. ");
INSERT INTO cebulb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kung nasusi sa pari ang nukanuka ug iyang nakita nga wala kini midulot sa unod, ug kung walay itom nga balahibo niini, nan ilain sa pari ang tawo nga adunay nukanuka sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sa ikapito nga adlaw susihon sa pari ang sakit aron tan-awon kung mikatag ba kini. Kung walay dalag nga balahibo, ug kung wala kini midulot sa unod, ");
INSERT INTO cebulb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","nan kinahanglan nga kagison ang iyang buhok, apan dili apilon ang bahin nga adunay sakit, ug kinahanglan nga ilain sa pari ang tawo nga adunay nukanuka sulod sa dugang pang pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sa ikapitong adlaw susihon sa pari ang sakit aron tan-awon kung wala naba kini mikatag sa panit. Kung wala kini midulot sa unod, nan kinahanglan nga ipahayag sa pari nga hinlo ang maong tawo. Kinahanglan nga labhan niining tawhana ang iyang mga bisti, ug unya mahinlo na siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Apan kung mikatag ang nukanuka sa tibuok panit human giingon sa pari nga hinlo na siya, ");
INSERT INTO cebulb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","nan kinahanglan nga susihon siya pag-usab sa pari. Kung mikatag ang sakit sa iyang panit, dili na kinahanglan mangita pa ug dalag nga balahibo ang pari. Hugaw ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Apan kung nakita sa pari nga wala na mikatag ang nuka ug gituboan na kini ug itom nga balahibo, nan naayo na ang sakit. Hinlo na siya, ug kinahanglan nga ipahayag sa pari nga hinlo na ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kung adunay mga butoybutoy sa panit ang usa ka lalaki o babaye, ");
INSERT INTO cebulb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","nan kinahanglan nga susihon sa pari ang maong tawo aron tan-awon kung uga ba ang mga butoybutoy, ug nagpaila nga katolkatol lamang kini nga mikatag sa panit. Hinlo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Kung nangalarot ang buhok sa ulo sa tawo, upaw siya, apan hinlo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kung nangalarot ang buhok sa atubangan nga bahin sa iyang ulo, ug kung upaw ang ibabaw nga bahin sa iyang agtang, hinlo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Apan kung adunay pulapula ug putiputi nga hubag sa iyang upaw nga ulo o sa ibabaw sa agtang, makatakod kini nga sakit nga mikatag. ");
INSERT INTO cebulb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Nan kinahanglan nga susihon siya sa pari aron nga makita kung pulapula ug putiputi ang hubag nga bahin sa iyang upaw nga ulo o sa ibabaw nga bahin sa iyang agtang, sama sa makatakod nga sakit sa panit. ");
INSERT INTO cebulb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Kung mao kana, nan aduna siyay makatakod nga sakit ug hugaw siya. Kinahanglan nga ipahayag gayod sa pari nga hugaw siya tungod sa sakit nga anaa sa iyang ulo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Kinahanglan nga magsul-ob ug dunot nga bisti ang mga tawo nga adunay makatakod nga sakit sa panit, kinahanglan nga idunghay niya ang iyang buhok, ug kinahanglan nga tabonan niya ang iyang dagway hangtod sa iyang ilong ug mosinggit, 'Hugaw ako, hugaw ako.' ");
INSERT INTO cebulb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Magpabilin siyang hugaw sa tanang mga adlaw nga aduna siyay makatakod nga sakit sa panit. Tungod kay hugaw man siya pinaagi sa makatakod nga sakit, kinahanglan nga magpuyo siya nga mag-inusara. Kinahanglan nga magpuyo siya gawas sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ang panapton nga nataptan ug agup-op, hinimo man kini sa balahibo sa mananap o sa lino nga panapton, ");
INSERT INTO cebulb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","o bisan unsa nga tinahi o ginansilyo nga balahibo sa mananap o lino, o panit sa mananap o bisan unsa nga hinimo gikan sa panit sa mananap— ");
INSERT INTO cebulb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kung adunay maypagkalunhaw o maypagkapula nga nitapot sa panapton, sa panit, sa tinahi o ginansilyo nga panapton, o bisan unsa nga hinimo gikan sa panit sa mananap, nan agup-op kini nga mokatag; kinahanglan nga ipakita kini sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kinahanglan nga susihon sa pari ang maong bisti kung aduna ba kini agup-op; kinahanglan nga ilain niya ang bisan unsa nga butang nga adunay agup-op sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Kinahanglan nga susihon niya pagbalik ang agup-op sa ikapito nga adlaw. Kung mikatag kini sa panapton o sa bisan unsa nga tinahi o ginansilyo gikan sa balahibo sa mananap o sa lino nga panapton, o sa panit o sa bisan unsang butang nga gigamitan ug panit sa mananap, nan agup-op kini nga makadala ug sakit, ug hugaw ang maong panapton. ");
INSERT INTO cebulb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kinahanglan nga sunogon niya ang maong panapton, o ang bisan unsa nga tinahi o ginansilyo gikan sa balahibo sa mananap o sa lino nga panapton, o ang panit sa mananap o ang bisan unsang hinimo sa panit sa mananap, o bisan unsang butang diin nakit-an ang agup-op nga makadala ug sakit, tungod kay makadala kini ug balatian. Kinahanglan nga sunogon sa hingpit ang maong panapton. ");
INSERT INTO cebulb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Kung nasusi na sa pari ang butang ug nakita niya nga wala mikatag ang agup-op sa panapton o sa butang nga tinahi o sa ginansilyo gikan sa balahibo sa mananap o sa panapton, o sa mga butang nga hinimo sa panit sa mananap, ");
INSERT INTO cebulb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","nan sugoon niya sila sa paglaba sa panapton diin nakita ang agup-op, ug kinahanglan nga ilain na usab kini sa dugang na usab nga pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Unya susihon sa pari ang butang nga adunay agup-op human kini nalabhan. Kung wala nabag-o ang kolor sa agup-op, bisan pa ug wala kini mikatag, hugaw kini. Kinahanglan ninyong sunogon ang maong butang, bisan ug asa pa mitapot ang agup-op. ");
INSERT INTO cebulb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kung nasusi sa pari ang panapton, ug kung nahanaw na ang agup-op human kini nalabhan, nan kinahanglan nga gision niya ang nataptan nga bahin gikan sa panapton o gikan sa panit sa mananap, o gikan sa tinahi o ginansilyo nga butang. ");
INSERT INTO cebulb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kung anaa lamang gihapon ang agup-op sa panapton, sa tinahi o sa ginansilyo man nga butang, o sa bisan unsang butang nga hinimo sa panit sa mananap, nagapadayon kini sa pagkatag. Kinahanglan ninyong sunogon ang bisan unsang butang nga adunay agup-op. ");
INSERT INTO cebulb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ang panapton o bisan unsang tinahi o ginansilyo nga gikan sa balahibo sa mananap o sa lino nga panapton, o sa panit sa mananap o sa bisan unsang butang nga hinimo sa panit sa mananap—kung gilabhan nimo ang butang ug nawala na ang agup-op, nan kinahanglan nga labhan kini sa ikaduhang higayon, ug mahinlo na kini. ");
INSERT INTO cebulb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Mao kini ang balaod mahitungod sa agup-op ug sa panapton nga hinimo gikan sa balahibo sa mananap o sa lino, o sa bisan unsang tinahi o ginansilyo nga balahibo sa mananap o lino, o sa panit sa mananap o sa bisan unsang butang nga hinimo sa panit sa mananap, aron nga mapahibalo nimo nga hinlo kini o hugaw.” ");
INSERT INTO cebulb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Mao kini ang balaod alang sa tawo nga adunay sakit sa panit sa adlaw sa paghinlo kaniya. Kinahanglan nga dad-on siya ngadto sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mogawas sa kampo ang pari aron susihon ang tawo kung naayo na ang makatakod nga sakit niini sa panit. ");
INSERT INTO cebulb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Unya magmando ang pari nga kinahanglan magdala ang tawo nga pagahinloan ug duha ka buhi nga hinlo nga mga langgam, kahoy nga sidro, pula nga pisi, ug hisopo. ");
INSERT INTO cebulb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Sugoon siya sa pari nga patyon ang usa sa mga langgam diha sa ibabaw sa hinlo nga tubig nga anaa sa banga. ");
INSERT INTO cebulb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ug dad-on sa pari ang buhi nga langgam ug ang kahoy nga sidro, ang pula nga pisi ug ang hisopo, ug ituslob niya kining tanan, lakip na ang buhi nga langgam, didto sa dugo sa gipatay nga langgam ibabaw sa hinlo nga tubig. ");
INSERT INTO cebulb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Unya iwisikwisik sa pari kini nga tubig sa makapito ka higayon ngadto sa tawo nga pagahinloan gikan sa iyang sakit sa panit, ug unya ipahayag sa pari nga hinlo na kining tawhana. Unya buhian sa pari ang langgam ngadto sa kapatagan. ");
INSERT INTO cebulb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Labhan sa nahinloan nga tawo ang iyang mga bisti, magkiskis sa tanan niya nga buhok, ug maligo, ug unya mahinlo siya. Human niana, kinahanglan nga moadto siya sa kampo, apan mopuyo siya sa gawas sa iyang tolda sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sa ikapito nga adlaw kinahanglan nga kiskisan niya ang tanan niyang buhok sa ulo, ug kinahanglan usab niya nga kiskisan ang iyang bangas ug mga kilay. Kinahanglan nga kiskisan niya ang tanan niyang buhok, ug kinahanglan usab niyang labhan ang iyang mga bisti ug maligo; ug unya mahinlo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sa ikawalo nga adlaw kinahanglan nga magdala siya ug duha ka laki nga mga nating karnero nga walay tatsa, ug usa ka tuig nga baye nga nating karnero nga walay tatsa, ug 3/10 nga epha sa labing maayo nga harina nga sinagolan ug lana ingon nga halad nga trigo ug usa ka log nga lana. ");
INSERT INTO cebulb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Dad-on sa pari ang tawo nga iyang gihinloan uban niadtong mga butanga, sa atubangan ni Yahweh diha sa pultahan sa tolda nga tigomanan. ");
INSERT INTO cebulb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Dad-on sa pari ang usa sa mga nating karnero nga laki ug ihalad ingon nga halad sa dili tinuyoan nga sala, uban ang usa ka log nga lana; ibayaw niya kini alang sa binayaw nga halad sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kinahanglan nga ihawon niya ang laki nga nating karnero sa dapit diin asa nila giihaw ang mga halad alang sa sala ug ang mga halad sinunog, sa dapit sa tabernakulo, alang sa halad sa sala nga panag-iyahan sa pari, ingon man ang halad sa dili tinuyoan nga sala, tungod kay labing balaan kini. ");
INSERT INTO cebulb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Magkuha ang pari ug gamayng dugo alang sa halad sa dili tinuyoan nga sala ug ipahid niya kini sa tumoy sa tuong dalunggan sa tawo nga pagahinloan, sa kumagko sa tuong kamot, ug sa kumagko sa tuong tiil sa maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Unya magkuha ang pari ug lana gikan sa log ug ibubo niya kini sa palad sa iyang wala nga kamot, ");
INSERT INTO cebulb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ug ituslob niya ang iyang tuo nga tudlo sa lana nga anaa sa iyang wala nga kamot, ug iwisikwisik niya sa makapito ka higayon ang gamayng lana pinaagi sa iyang tudlo sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ipahid sa pari ang nahibilin nga lana sa iyang kamot diha sa tumoy sa tuong dalunggan sa tawo nga pagahinloan, sa kumagko sa tuong kamot, ug sa kumagko sa tuong tiil niini. Kinahanglan nga ipahid niya ang lana ibabaw sa dugo gikan sa halad sa dili tinuyoan nga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Alang sa nahibilin nga lana nga anaa sa kamot sa pari, ipahid niya kini sa ulo sa tawo nga pagahinloan, ug maghimo ug pagpapas sa sala ang pari alang niining tawhana sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Unya ihalad sa pari ang halad alang sa sala ug maghimo ug pagpapas sa sala alang sa tawo nga pagahinloan tungod sa pagkahugaw niini, ug human niana ihawon niya ang halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Unya ihalad sa pari ang halad sinunog ug ang halad nga trigo didto sa halaran. Maghimo ug pagpapas sa sala ang pari alang niining tawhana, ug unya mahinlo ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Apan, kung kabos ang tawo ug walay ikapalit niini nga mga halad, nan makahimo siya sa pagdala ug usa ka laki nga nating karnero ingon nga halad nga ibayaw alang sa dili tinuyoan nga sala, aron makahimo ug pagpapas sa sala alang sa iyahang kaugalingon, ug 1/10 sa epha sa labing maayo nga harina nga sinagolan ug lana ingon nga halad nga trigo, ug ang usa ka log sa lana, ");
INSERT INTO cebulb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","uban ang duha ka mga salampati ug duha ka mga pispis nga tukmo, sumala sa iyang makuha; mahimong halad alang sa sala ang usa ka langgam ug ang lain pa mahimong halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Sa ikawalo nga adlaw kinahanglan nga dad-on niya kini aron sa paghinlo kaniya sa pari, ngadto sa pultahan sa tolda nga tigomanan, sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Dad-on sa pari ang nating karnero aron ihalad, ug dad-on usab niya uban niini ang usa ka log nga lana sa olibo, ug ibayaw niya kining tanan ingon nga mga gasa sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ihawon niya ang nating karnero alang sa halad sa dili tinuyoan nga sala, ug magkuha siya ug gamay nga dugo niini ug ipahid kini sa tumoy sa tuong dalunggan sa tawo nga pagahinloan, sa kumagko sa tuong kamot ug sa kumagko sa tuong tiil sa maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Unya buboan sa pari ug gamayng lana ang palad sa iyang walang kamot, ");
INSERT INTO cebulb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ug iwisikwisik niya sa makapito ka higayon pinaagi sa iyang tuo nga kamot ang lana nga anaa sa iyang wala nga kamot sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Unya ipahid sa pari ang gamay nga lana nga anaa sa iyang kamot diha sa tumoy sa tuong dalunggan sa tawo nga pagahinloan, sa kumagko sa tuong kamot, ug sa kumagko sa tuong tiil sa maong tawo, sa samang mga dapit diin gibutang niya ang dugo nga halad sa dili tinuyoan nga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ipahid niya ang nahibilin nga lana nga anaa sa iyang kamot ngadto sa ulo sa tawo nga pagahinloan, aron makahimo ug pagpapas ang pari alang sa sala sa maong tawo diha sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Kinahanglan nga ihalad niya ang usa sa mga salampati ug mga pispis nga tukmo, sumala sa nakuha sa tawo— ");
INSERT INTO cebulb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ang usa ingon nga halad alang sa sala ug ang lain pa ingon nga halad sinunog, uban sa halad nga trigo. Unya maghimo ug pagpapas sa sala ang pari alang sa tawo nga pagahinloan sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Mao kini ang balaod alang sa tawo nga adunay makatakod nga sakit sa panit, nga dili makapalit sa gikinahanglan nga halad aron sa paghinlo kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Nakigsulti si Yahweh kang Moises ug kang Aaron, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Sa dihang moabot kamo sa yuta sa Canaan nga gihatag ko kaninyo ingon nga panag-iyahan, ug kung magbutang ako ug agup-op nga mokatag sa balay diha sa yuta nga inyong gipanag-iyahan, ");
INSERT INTO cebulb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","nan kinahanglan nga adtoan ug sultihan sa tag-iya sa balay ang pari. Kinahanglan nga moingon siya, 'Daw may agup-op sa akong balay.' ");
INSERT INTO cebulb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Unya magmando ang pari nga kuhaon ang tanang butang sa balay sa dili pa siya mosulod aron makita ang agup-op, ug aron nga walay bisan unsa nga anaa sa balay ang mahimong hugaw. Human niana, kinahanglan nga mosulod ug tan-awon sa pari ang balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kinahanglan nga susihon niya ang agup-op aron makita kung naa ba kini sa mga bungbong, ug aron makita kung maypagkalunhaw o maypagkapula ba kini diha sa suoksuok sa mga bungbong. ");
INSERT INTO cebulb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Kung adunay agup-op ang balay, mogawas ang pari sa balay ug sirad-an ang pultahan niini sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Unya mobalik pag-usab ang pari sa ikapito nga adlaw ug susihon kini aron tan-awon kung mikatag ba ang agup-op sa mga bungbong sa maong balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Ug kung mikatag kini, magsugo dayon ang pari nga tanggalon nila ang mga bato diin nakaplagan ang agup-op ug ilabay kini sa mahugaw nga dapit gawas sa siyudad. ");
INSERT INTO cebulb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Magsugo siya nga pakiskisan ang tanang bungbong sulod sa balay, ug kinahanglan nga dad-on nila ang hugaw nga mga butang pagawas sa siyudad ug ilabay kini sa mahugaw nga dapit. ");
INSERT INTO cebulb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Kinahanglan nga magkuha sila ug laing mga bato ug ipuli kini sa dapit diin nila gitanggal ang mga gipang-agup-op nga mga bato, ug kinahanglan nga mogamit sila ug bag-o nga yutang kolonon aron itaklap sa balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Kung mobalik gihapon ang agup-op ug mokatag sa balay diin gipangkuha ang mga bato ug gipangkiskisan ug gipangtapakan ang mga bungbong, ");
INSERT INTO cebulb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","nan kinahanglan nga mosulod ang pari ug susihon ang balay aron nga makita kung mikatag ba ang agup-op sa balay. Kung mikatag kini, makadaot kini nga agup-op, ug hugaw kini nga balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Kinahanglan nga gubaon ang balay. Kinahanglan nga dad-on ngadto sa gawas sa siyudad sa mahugaw nga dapit ang mga bato, ginabas nga kahoy, ug ang tanang tapak sa balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Dugang pa niini, mahimong hugaw hangtod sa kagabhion ang si bisan kinsa nga mosulod sa balay sa panahon nga sirado kini. ");
INSERT INTO cebulb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Kinahanglan nga maglaba sa iyang mga bisti ang si bisan kinsa nga natulog ug nagkaon sulod sa maong balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kung mosulod ang pari sa balay aron susihon kini aron makita kung mikatag ba sa balay ang agup-op human natapakan, unya, kung nawagtang na ang agup-op, ipahayag niya nga hinlo na ang balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Unya kinahanglan nga dad-on sa pari ang duha ka mga langgam, ang kahoy nga sidro, ang pula nga pisi, ug ang hisopo aron sa paghinlo sa balay. ");
INSERT INTO cebulb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Patyon niya ang usa sa mga langgam ibabaw sa hinlo nga tubig sa banga. ");
INSERT INTO cebulb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kuhaon niya ang kahoy nga sidro, ug ang hisopo, ang pula nga pisi ug ang buhi nga langgam, ug ituslob kini sa dugo sa patay nga langgam, ngadto sa hinlo nga tubig, ug iwisikwisik sa balay sa makapito ka higayon. ");
INSERT INTO cebulb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Hinloan niya ang balay pinaagi sa dugo sa langgam ug sa hinlo nga tubig, sa buhi nga langgam, sa kahoy nga sidro, sa hisopo, ug sa pula nga pisi. ");
INSERT INTO cebulb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Apan buhian niya ang buhi nga langgam sa gawas sa siyudad ngadto sa kapatagan. Sa ingon niini nga pamaagi makahimo siya sa pagpapas sa sala alang sa maong balay, ug mahinlo kini. ");
INSERT INTO cebulb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Mao kini ang balaod alang sa tanang matang sa makatakod nga sakit sa panit ug ang mga butang nga maoy hinungdan sa mga balatian, sa katol, ");
INSERT INTO cebulb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ug sa agup-op sa bisti ug sa balay, ");
INSERT INTO cebulb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","sa hubag, sa katolkatol, ug sa butoy, ");
INSERT INTO cebulb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","aron mahibal-an kung hugaw o hinlo kining mga butanga. Mao kini ang balaod alang sa makatakod nga mga sakit sa panit ug sa agup-op.'' ");
INSERT INTO cebulb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Nakigsulti si Yahweh ngadto kang Moises ug kang Aaron, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Pakigsulti sa katawhan sa Israel, ug sultihi sila, 'Kung adunay mogawas sa kinatawo sa usa ka lalaki tungod sa sakit, hugaw siya. ");
INSERT INTO cebulb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ang iyang pagkahugaw tungod niining sakit nga nagagawas kaniya. Bisan paman adunay mogawas sa iyang kinatawo o mihunong na, hugaw gihapon siya. ");
INSERT INTO cebulb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Hugaw ang matag higdaanan nga iyang gihigdaan, ug ang tanan nga iyang malingkoran mahimong hugaw. ");
INSERT INTO cebulb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Si bisan kinsa nga mohikap sa iyang higdaanan kinahanglan manglaba sa iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Si bisan kinsa nga makalingkod sa gilingkoran sa lalaki nga adunay nagagawas gikan kaniya tungod sa sakit, kanang tawhana kinahanglan manglaba sa iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Si bisan kinsa nga makahikap sa lawas sa lalaki nga adunay nagagawas gikan kaniya tungod sa sakit kinahanglan manglaba sa iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kung ang tawong hinlo maluwaan sa lalaking adunay nagagawas gikan kaniya tungod sa sakit, nan kanang tawhana kinahanglan manglaba sa iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Hugaw ang bisan unsa nga hapin nga malingkoran sa lalaki nga adunay nagagawas gikan kaniya tungod sa sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Si bisan kinsa nga makahikap sa sa bisan unsa nga nalingkoran nianang tawhana hugaw siya hangtod sa pagkagabii, ug si bisan kinsa ang mokuha niadtong mga butanga kinahanglan manglaba sa iyang mga bisti ug maligo; hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Si bisan kinsa nga magunitan sa tawo nga adunay nagagawas gikan kaniya tungod sa sakit nga wala pa siya nakapanghugas sa iyang mga kamot, ang tawo nga iyang nagunitan kinahanglan nga manglaba sa iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ang bisan unsa nga tadyaw nga mahikapan sa tawo nga adunay nagagawas gikan kaniya tungod sa sakit kinahanglan buakon, ug ang matag baril nga kahoy kinahanglan hugasan. ");
INSERT INTO cebulb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Sa dihang mahinloan na ang lalaki nga adunay nagagawas gikan kaniya tungod sa sakit, kinahanglan moihap siya ug pito ka adlaw alang sa iyang pagkahinlo; unya kinahanglan nga manglaba siya sa iyang mga bisti ug maligo sa nagaawas nga tubig. Unya mahinlo na siya. ");
INSERT INTO cebulb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sa ikawalo nga adlaw kinahanglan magdala siya ug duha ka salampati o duha ka tukmo ug moduol sa atubangan ni Yahweh didto sa ganghaan sa toldang tagboanan; didto kinahanglan ihatag niya ang mga langgam sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kinahanglan ihalad kini sa pari, ang usa ingon nga halad sa sala ug ang usa ingon nga halad sinunog, ug kinahanglan magbuhat ang pari ug kapasayloan alang kaniya sa atubangan ni Yahweh alang sa iyang sakit. ");
INSERT INTO cebulb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kung adunay lalaki nga magawasan sa iyang similya, nan kinahanglan maligo siya; hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ang bisan unsang bisti o panapton nga nabutangan sa similya kinahanglan nga labhan; hugaw kini hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kung nakighilawas ang lalaki sa babaye ug adunay similya nga nakasulod sa babaye, kinahanglan maligo silang duha; hugaw sila hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Sa dihang dug-on ang babaye, ang iyang pagkahugaw mopadayon sulod sa pito ka adlaw, ug si bisan kinsa nga mogunit kaniya hugaw hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Hugaw ang tanang butang nga iyang nahigdaan sa dihang gidugo siya; hugaw usab ang tanan niyang nalingkoran. ");
INSERT INTO cebulb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Si bisan kinsa nga mohikap sa iyang higdaanan kinahanglan manglaba sa iyang mga bisti ug maligo; kanang tawhana hugaw hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Si bisan kinsa nga makahikap sa bisan unsa nga iyang nalingkoran kinahanglan manglaba sa iyang mga bisti ug maligo; kanang tawhana hugaw hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Bisan paman anaa kini sa higdaanan o anaa sa iyang gilingkoran, kung hikapon kini, kanang tawhana hugaw hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kung adunay lalaki nga makigdulog kaniya, ug kung ang pagkahugaw sa babaye iyang mahikapan, hugaw siya sulod sa pito ka adlaw. Hugaw ang tanan nga iyang gihigdaan. ");
INSERT INTO cebulb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kung ang babaye gidugo sulod sa daghang adlaw sa dili pa panahon sa iyang tingdugo, o kung dug-on siya nga lapas na sa panahon sa iyang tingdugo, sa panahon nga gidugo siya sa iyang pagkahugaw, hugaw siya sama sa panahon nga gidugo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ang matag higdaanan nga iyang gihigdaan sa dihang gidugo siya susama gihapon sa higdaanan nga iyang gihigdaan panahon sa iyang pagdugo, ug hugaw ang tanan nga iyang gilingkoran, sama sa pagkahugaw sa iyang pagdugo. ");
INSERT INTO cebulb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Hugaw ang si bisan kinsa nga mohikap niadtong tanang butanga; kinahanglan manglaba siya sa iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Apan kung hinlo na siya sa iyang pagdugo, nan moihap siya ug pito ka adlaw, ug human niana mamahinlo na siya. ");
INSERT INTO cebulb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sa ikawalo ka adlaw magdala siya ug duha ka salampati o duha ka tukmo ug dad-on niya kini ngadto sa pari nga anaa sa ganghaan sa toldang tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ihalad sa pari ang usa ka salampati ingon nga halad sa sala ug ang usa ingon nga halad sinunog, ug maghimo ang pari ug kapasayloan alang kaniya sa atubangan ni Yahweh alang sa iyang hugaw nga pagdugo. ");
INSERT INTO cebulb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kinahanglan sama niini ang inyong paglain sa mga tawo sa Israel gikan sa ilang pagkahugaw, aron dili sila mamatay tungod sa ilang pagkahugaw, pinaagi sa paghugaw sa akong tabernakulo, kung diin ako nagpuyo taliwala kanila. ");
INSERT INTO cebulb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Mao kini ang mga kasugoan alang ni bisan kinsa nga adunay nagagawas gikan kaniya tungod sa sakit, alang sa lalaki nga gigawasan sa iyang similya ug nakapahugaw kaniya, ");
INSERT INTO cebulb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","alang sa babaye nga gidugo, alang kang bisan kinsa nga adunay nagagawas gikan kaniya tungod sa sakit, babaye man o lalaki, ug sa lalaki nga makigdulog sa hugaw nga babaye.'” ");
INSERT INTO cebulb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Nakigsulti si Yahweh kang Moises—human kini sa kamatayon sa duha ka anak nga lalaki ni Aaron, sa dihang miduol sila kang Yahweh ug nangamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Miingon si Yahweh ngadto kang Moises, “Pakigsulti sa imong igsoon nga si Aaron ug sultihi siya nga dili sa tanang panahon mosulod siya didto sa labing balaang dapit sulod sa tabil, sa atubangan sa tabon nga anaa sa arka sa kasabotan. Kung buhaton niya kana, mamatay gayod siya, tungod kay motungha ako diha sa panganod ibabaw sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Busa ania kung unsaon pagsulod ni Aaron didto sa labing balaang dapit. Mosulod siya dala ang nating baka ingon nga halad sa sala, ug ang laking karnero ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kinahanglan isul-ob niya ang balaang lino nga kupo, ug isul-ob ang pang-ilalom nga linong mga bisti, ug ibakos niya ang linong bakos ug ikalo niya ang linong purong. Mao kini ang balaang mga bisti. Kinahanglan maligo siya ug unya isul-ob kini nga mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kinahanglan magdala siya ug duha ka torong kanding gikan sa panagtigom sa katawhan sa Israel ingon nga halad alang sa sala ug usa ka torong karnero ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Unya kinahanglan ipakita ni Aaron ang torong baka ingon nga halad sa sala, nga alang lamang sa iyang kaugalingon, alang sa iyang kapasayloan ug sa iyang pamilya. ");
INSERT INTO cebulb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Unya dad-on niya ang duha ka kanding ug ipahimutang kini sa atubangan ni Yahweh diha sa ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Unya kinahanglan magripa si Aaron alang sa duha ka kanding, ang usa nga ripa alang kang Yahweh, ug ang usa aron buhian ang kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Unya kinahanglan dad-on ni Aaron ang kanding nga naripa alang kang Yahweh, ug ihalad kana nga kanding ingon nga halad alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Apan ang kanding nga naripa nga buhian kinahanglan dad-on nga buhi sa atubangan ni Yahweh, alang sa kapasayloan sa sala pinaagi sa pagbuhi niini ingon nga binuhian nga kanding didto sa kamingawan. ");
INSERT INTO cebulb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Unya kinahanglan dad-on ni Aaron ang torong baka alang sa halad sa sala, nga alang sa iyang kaugalingon. Kinahanglan maghimo siya ug kapasayloan sa sala alang sa iyang kaugalingon ug alang sa iyang panimalay, busa kinahanglan ihawon niya ang torong baka ingon nga halad sa sala alang sa iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Kinahanglan magkuha si Aaron ug sudlanan nga puno sa mga baga gikan sa halaran sa atubangan ni Yahweh, mohakop siya ug mahumot nga insensong pinong pagkadugmok, ug dad-on kining mga butanga sulod sa tabil. ");
INSERT INTO cebulb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Didto ibutang niya ang insenso sa kalayo sa atubangan ni Yahweh aron nga malukop sa aso sa insenso ang tabon ibabaw sa kasugoan sa kasabotan. Buhaton gayod niya kini aron dili siya mamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Unya kinahanglan magkuha siya ug dugo sa torong baka ug iwisikwisik kini gamit ang iyang tudlo atubangan sa tabon. Kinahanglan iwisikwisik niya ang ubang dugo gamit ang iyang tudlo kapito ka higayon atubangan sa tabon. ");
INSERT INTO cebulb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Unya kinahanglan ihawon niya ang kanding alang sa halad sa sala sa mga tawo ug dad-on ang dugo niini sulod sa tabil. Didto kinahanglan buhaton usab niya ang pagwisikwisik sa dugo sama sa iyang gibuhat sa dugo sa torong baka: kinahanglan iwisikwisik niya kini didto sa tabon ug sa atubangan niini. ");
INSERT INTO cebulb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kinahanglan magbuhat siya ug paghinlo alang sa balaang dapit tungod sa mahugaw nga mga buhat sa katawhan sa Israel, ug tungod sa ilang paglapas ug sa tanan nilang mga sala. Buhaton usab niya kini alang sa tolda nga tagboanan, diin nagpuyo si Yahweh taliwala kanila, diha sa atubangan sa ilang hugaw nga binuhatan. ");
INSERT INTO cebulb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kinahanglan walay tawo nga anaa sulod sa tolda nga tagboanan sa dihang mosulod si Aaron aron sa pagbalaan sulod sa labing balaang dapit, ug hangtod nga mogawas na siya ug mahuman na sa pagbuhat sa kapasayloan alang sa iyang kaugalingon ug sa iyang panimalay, ug alang sa tibuok katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Kinahanglan mogawas siya sa halaran nga atua sa atubangan ni Yahweh ug buhaton ang pagbalaan alang niini, ug dad-on niya ang nahibiling dugo sa torong baka ug dugo sa kanding ug ipahid kini palibot sa mga sungaysungay sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Kinahanglan iwisikwisik niya ang ubang dugo niini gamit ang iyang tudlo kapito ka higayon aron sa paghinlo niini ug sa paglain niini alang kang Yahweh, pagpalayo sa mahugaw nga binuhatan sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Sa dihang mahuman na siya sa pagbalaan sa labing balaan nga dapit, sa tolda nga tagboanan, ug sa halaran, kinahanglan nga ihalad niya ang buhing kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Kinahanglan nga itapion ni Aaron ang iyang mga kamot ibabaw sa ulo sa buhing kanding ug isulti niya ngadto sa buhing kanding ang tanang pagkadaotan sa katawhan sa Israel, ang tanan nilang pagsupak, ug ang tanan nilang mga sala. Unya ibutang niya kadtong pagpakasala ibabaw sa ulo sa kanding ug ipadala kini ngadto sa kamingawan pinaagi sa tawo nga andam sa paggiya sa kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Pagadad-on sa kanding ang tanang pagkadaotan sa mga tawo ngadto sa awaaw nga dapit. Didto sa kamingawan, kinahanglan buhian sa tawo ang kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Unya kinahanglan nga mosulod pagbalik si Aaron didto sa tolda nga tagboanan ug huboon niya ang linong mga bisti nga iyang gisul-ob sa dili pa mosulod didto sa labing balaang dapit, ug didto ibilin niya kadtong mga bistiha. ");
INSERT INTO cebulb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kinahanglan nga maligo siya didto sa balaang dapit, ug isul-ob ang naandan niyang mga bisti; unya mogawas siya ug ihalad niya ang halad sinunog ug ang halad sinunog alang sa katawhan, ug niini nga paagi magbuhat siya ug kapasayloan alang sa iyang kaugalingon ug alang sa katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Kinahanglan sunogon niya ang tambok sa halad sa sala ibabaw sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ug ang tawo nga nagdala sa kanding aron buhian kinahanglan manglaba sa iyang mga bisti ug maligo; human niana, mosulod na siya pagbalik sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ang torong baka nga alang sa halad sa sala ug ang kanding nga halad alang sa sala, kansang dugo nga gidala sa sulod aron sa pagbalaan sa balaang dapit, pagadad-on pagawas sa kampo. Didto sunogon nila ang mga panit, unod, ug ang hugaw niini. ");
INSERT INTO cebulb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ang tawo nga magsunog niadto kinahanglan manglaba sa iyang mga bisti ug maligo; human niana, mosulod na siya pagbalik sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Mao kini ang mga kasugoan alang kaninyo nga sa ikapito ka bulan, sa ikapulo nga adlaw sa maong bulan, kinahanglan magpaubos kamo sa inyong mga kaugalingon ug dili motrabaho, bisan ang mga lumolupyo o mga langyaw nga anaa nagpuyo uban kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Tungod kay niana nga adlaw ang kapasayloan pagabuhaton alang kaninyo, aron sa paghinlo kaninyo gikan sa tanan ninyong mga sala aron nga hinlo kamo sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Mao kini ang Adlaw nga Igpapahulay aron mopahulay kamo. Mao kini ang dili mausab nga kasugoan alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ang labaw nga pari ang dihogan ug pilion aron mahimong labaw nga pari sa dapit sa iyang amahan, kinahanglan magbuhat niini nga pagbalaan ug mosul-ob sa lino nga mga bisti, nga mao ang balaang mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Kinahanglan nga ibalaan niya ang labing balaan nga dapit; kinahanglan nga ibalaan niya ang tolda nga tagboanan ug ang halaran, ug kinahanglan magbuhat siya ug kapasayloan alang sa mga pari ug alang sa tibuok katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Mao kini ang dili mausab nga kasugoan alang kaninyo, sa pagbuhat sa kapasayloan alang sa katawhan sa Israel tungod sa tanan nilang mga sala, makausa sa matag tuig.” Gibuhat kini ingon nga si Yahweh ang nagmando kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Sultihi si Aaron ug ang iyang mga anak nga lalaki, ug ang tibuok katawhan sa Israel. Isulti kanila kung unsa ang gimando ni Yahweh: ");
INSERT INTO cebulb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","'Si bisan kinsa nga tawo nga gikan sa Israel nga moihaw ug baka, karnero o kanding sulod sa kampo, o moihaw niini gawas sa kampo, aron ihalad kini— ");
INSERT INTO cebulb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kung dili niya kini dad-on sa ganghaan sa tolda nga tagboanan aron ihalad kini ingon nga halad ngadto kang Yahweh sa atubangan sa iyang tabernakulo, kanang tawhana sad-an sa pagpatay. Nakaula siya ug dugo, ug kanang tawhana kinahanglan papahawaon gikan sa iyang mga katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ang katuyoan niini nga sugo aron nga dad-on sa katawhan sa Israel ang ilang mga halad kang Yahweh didto sa ganghaan sa tolda nga tagboanan, ngadto sa pari aron ihalad ingon nga mga halad sa pakigdait ngadto kang Yahweh, kay sa paghalad sa mga halad didto sa kapatagan. ");
INSERT INTO cebulb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Iwisikwisik sa pari ang dugo ngadto sa halaran ni Yahweh nga atua sa ganghaan sa tolda nga tagboanan; sunogon niya ang tambok niini aron makahatag ug kahumot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kinahanglan nga dili gayod ihalad sa katawhan ang ilang mga halad ngadto sa mga diosdios nga kanding, kay mahisama sila sa mga nagbaligya ug dungog. Mao kini ang dili mausab nga kasugoan alang kanila hangtod pa sa ilang mga kaliwatan. ");
INSERT INTO cebulb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Kinahanglan sultihan mo sila, 'Si bisan kinsa nga tawo sa Israel, o si bisan kinsa nga langyaw nga nagpuyo uban kanila, nga maghalad ug halad sinunog o sakripisyo ");
INSERT INTO cebulb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ug wala kini dad-a sa ganghaan sa tolda nga tagboanan aron mahalad kini ngadto kang Yahweh, kanang tawhana kinahanglan hinginlan gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Kung adunay tawo sa panimalay sa Israel, o si bisan kinsa nga langyaw nga nagpuyo uban kanila nga mokaon ug dugo, atubangon ko kanang tawo nga nagkaon ug dugo ug papahawaon ko siya gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kay ang kinabuhi sa mga mananap anaa man sa dugo. Gihatag ko kining dugo kaninyo aron sa pagbalaan ibabaw sa halaran alang sa inyong mga kinabuhi, tungod kay mao kini ang dugo nga nagbuhat sa kapasayloan, kay mao kini ang dugo nga nagpasaylo alang sa kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Busa sultihan ko ang katawhan sa Israel nga kinahanglan wala gayod usa kaninyo ang mokaon ug dugo, bisan paman ang mga langyaw nga nagpuyo uban kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Si bisan kinsa sa katawhan sa Israel, o bisan kinsa nga mga langyaw nga nagpuyo uban kanila, nga mangayam ug moihaw ug mananap o langgam aron kaonon, kinahanglan paagason nianang tawhana ang dugo ug tabonan kini ug yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Kay ang kinabuhi sa matag binuhat anaa sa dugo. Mao kana nga moingon ako sa katawhan sa Israel, “Kinahanglan nga dili gayod kamo mokaon ug dugo sa bisan unsang binuhat, kay ang kinabuhi sa matag buhing binuhat anaa sa dugo. Si bisan kinsa nga mokaon niini kinahanglan papahawaon.” ");
INSERT INTO cebulb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ang matag tawo nga mokaon sa mananap nga namatay o gikuniskunis sa ihalas nga mga mananap, bisan paman kanang tawhana lumolupyo nianang dapita o langyaw nga nagpuyo uban kaninyo, kinahanglan labhan niya ang iyang mga bisti ug maligo, ug hugaw siya hangtod sa pagkagabii. Unya mamahinlo na usab siya. ");
INSERT INTO cebulb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Apan kung dili niya labhan ang iyang mga bisti o maligo, nan mag-antos siya sa iyang pagkasad-an.'” ");
INSERT INTO cebulb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Nakigsulti si Yahweh kang Moises nga miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Pagpakigsulti sa katawhan sa Israel ug sultihi sila, 'Ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kinahanglan nga dili ninyo buhaton ang mga butang nga ginabuhat sa katawhan sa Ehipto, nga gipuy-an ninyo kaniadto. Kinahanglan nga dili ninyo buhaton ang mga butang nga ginabuhat sa katawhan sa Canaan, sa yuta diin dad-on ko kamo. Ayaw pagsunod sa ilang mga naandan. ");
INSERT INTO cebulb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kinahanglan buhaton ninyo ang akong mga balaod, ug kinahanglan tumanon ninyo ang akong mga mando, aron magalakaw kamo niini, tungod kay ako si Yahweh nga inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Busa kinahanglan nga tumanon ninyo ang akong mga kasugoan ug ang akong mga balaod. Kung tumanon kini sa tawo, mabuhi siya tungod niini. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Kinahanglan nga walay si bisan kinsa ang makighilawas sa iyang paryente. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ayaw pakaulawi ang inyong amahan pinaagi sa pagpakighilawas sa inyong inahan. Siya ang inyong inahan! Kinahanglan dili ninyo siya pakaulawan. ");
INSERT INTO cebulb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ayaw pagpakighilawas sa bisan kinsa sa mga asawa sa inyong amahan; kinahanglan nga dili mo pakaulawan ang inyong amahan sa sama niana. ");
INSERT INTO cebulb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ayaw pagpakighilawas sa bisan kinsa sa inyong igsoong babaye, bisan pa kung anak siya nga babaye sa inyong amahan o anak nga babaye sa inyong inahan, bisan pa kung nagdako siya sa inyong panimalay o halayo man kaninyo. Kinahanglan nga dili kamo makighilawas sa inyong mga igsoong babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ayaw pagpakighilawas sa inyong apo nga babaye nga anak sa inyong anak nga lalaki o sa inyong apo nga babaye nga anak sa inyong anak nga babaye. Makauulaw kini alang kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ayaw pagpakighilawas sa anak nga babaye sa asawa sa inyong amahan, nga gipakatawo sa kaugalingon ninyong amahan. Igsoon ninyo siya nga babaye, ug kinahanglan nga dili kamo makighilawas kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ayaw pagpakighilawas sa inyong iyaan nga igsoon sa inyong amahan. Tungod kay duol siya nga kadugo sa inyong amahan. ");
INSERT INTO cebulb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ayaw pagpakighilawas sa imong iyaan nga igsoon sa inyong inahan, tungod kay duol siya nga kadugo sa inyong inahan. ");
INSERT INTO cebulb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ayaw pakaulawi ang inyong uyoan nga igsoon sa inyong amahan pinaagi sa pagpakighilawas sa iyang asawa. Ayaw pagpaduol kaniya alang niana nga katuyoan; iyaan ninyo siya. ");
INSERT INTO cebulb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ayaw pagpakighilawas sa inyong umagad nga babaye. Asawa siya sa inyong anak nga lalaki; ayaw pagpakighilawas kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ayaw pagpakighilawas sa asawa sa inyong igsoong lalaki; ayaw siya pakaulawi pinaagi niiini. ");
INSERT INTO cebulb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ayaw pagpakighilawas sa usa ka babaye ug sa iyang anak nga babaye, o sa iyang apo nga babaye nga anak sa iyang anak nga lalaki o sa iyang apo nga anak sa iyang anak nga babaye. Duol sila nga kadugo niya, ug ang pagpakighilawas kanila daotan. ");
INSERT INTO cebulb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ayaw pagpakigminyo sa igsoong babaye sa inyong asawa ingon nga ikaduhang asawa ug ayaw pagpakighilawas kaniya samtang buhi pa ang una ninyong asawa. ");
INSERT INTO cebulb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ayaw pagpakighilawas sa babaye nga gidugo. Hugaw siya nianang panahona. ");
INSERT INTO cebulb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ayaw pagpakighilawas sa asawa sa inyong silingan ug hugawan ang inyong kaugalingon uban kaniya niini nga paagi. ");
INSERT INTO cebulb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Kinahanglan nga dili ninyo itugyan ang bisan kinsa sa inyong mga anak aron nga sunogon sila, aron nga ihalad ninyo sila ngadto kang Molech, tungod kay kinahanglan nga dili gayod ninyo pasipalaan ang ngalan sa inyong Dios. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ayaw pagpakighilawas sa isigka-lalaki ug sa isigka-babaye. Daotan kini. ");
INSERT INTO cebulb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ayaw pagpakighilawas sa bisan unsa nga mananap ug hugawan ang inyong kaugalingon niini. Walay babaye nga gitugotan nga makighilawas sa bisan unsa nga mananap. Usa kini ka pagtuis. ");
INSERT INTO cebulb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ayaw hugawi ang inyong kaugalingon sa bisan unsa niini nga mga pamaagi, kay niining tanang pamaagi nahugawan ang kanasoran, ang kanasoran nga akong gipapahawa sa wala pa kamo. ");
INSERT INTO cebulb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Nahimong mahugaw ang yuta, busa silotan ko ang ilang sala, ug gisuka sa yuta ang mga lumolupyo niini. ");
INSERT INTO cebulb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Busa, Kamo, kinahanglan nga magtuman sa akong mga mando ug kasugoan, ug kinahanglan nga dili kamo magbuhat ug bisan unsa niining mahugaw nga mga butang, bisan pa man ang natawo sa pagka-Israelita ni ang langyaw nga mipuyo uban kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kay mao kini ang pagkadaotan nga gihimo sa katawhan nga nagpuyo sa yuta, kadtong nagpuyo dinhi sa wala pa kamo, ug karon nahugawan ang maong yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Busa pag-amping aron dili usab kamo isuka sa yuta human ninyo kini gihugawan, sama sa pagsuka niini sa katawhan nga nag-una kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Si bisan kinsa ang magabuhat niining mahugaw nga mga butang, papahawaon gikan sa ilang katawhan ang mga tawo nga nagabuhat sa maong butang. ");
INSERT INTO cebulb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Busa kinahanglan nga tipigan ninyo ang akong mando nga dili magbuhat sa bisan unsa niining mahugaw nga naandan nga ginabuhat dinhi sa wala pa kamo, aron nga dili ninyo mahugawan ang inyong kaugalingon pinaagi niini. Ako si Yahweh ang inyong Dios.”' ");
INSERT INTO cebulb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Nagkigsulti si Yahweh kang Moises, nga miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Pakigsulti sa tanang pundok sa katawhan sa Israel ug sultihi sila, 'Pagpakabalaan kamo, kay ako si Yahweh nga inyong Dios balaan man. ");
INSERT INTO cebulb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kinahanglan nga motahod ang matag usa sa iyang inahan ug sa iyang amahan, ug kinahanglan tipigan ninyo ang akong Adlaw nga Igpapahulay. Ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ayaw kamo pag-adto sa walay pulos nga mga diosdios, ni sa paghimo ug mga dios nga hinimo sa puthaw. Ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Sa dihang maghalad kamo ngadto kang Yahweh ug halad sa pakigdait, kinahanglan maghalad kamo niini aron nga madawat kamo. ");
INSERT INTO cebulb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kinahanglan nga kaonon kini sa samang adlaw nga gihalad kini, o sa pagkasunod adlaw. Kung adunay mahibilin niini hangtod sa ikatulo ka adlaw, kinahanglan nga sunogon kini. ");
INSERT INTO cebulb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kung gikaon kining tanan sa ikatulo nga adlaw, hugaw na kini. Kinahanglan dili na kini dawaton, ");
INSERT INTO cebulb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","apan ang tanan nga mikaon niini kinahanglan manubag sa iyang kaugalingong sala tungod kay wala niya tahora kung unsa ang balaan alang kang Yahweh. Kinahanglan papahawaon kanang tawhana gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Sa dihang mag-ani kamo sa abot sa inyong yuta, ayaw ninyo hutda pag-ani ang anaa sa mga kilid sa uma, ni tigomon ang tanang abot sa inyong naani. ");
INSERT INTO cebulb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kinahanglan nga dili ninyo hutdon pagtigom ang ubas gikan sa inyong parasan, ni ang pagpamunit sa mga ubas nga nangahulog sa yuta sa inyong parasan. Kinahanglan ibilin ninyo kini alang sa mga kabos ug alang sa mga langyaw. Ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ayaw pangawat. Ayaw pamakak. Ayaw panglimbong sa usag-usa. ");
INSERT INTO cebulb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ayaw panaad ug dili tinuod pinaagi sa akong ngalan ug pasipalaan ang ngalan sa inyong Dios. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ayaw daogdaoga ang inyong silingan o ayaw pangawat kaniya. Kinahanglan nga dili magpabilin diha kaninyo ang bayad sa inyong mga sinuholan sa tibuok gabii hangtod sa pagkabuntag. ");
INSERT INTO cebulb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ayaw tungloha ang bungol o pagbutang ug mapandolan sa buta. Hinuon, kinahanglan nga kahadlokan ninyo ang inyong Dios. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ayaw paghimo ug sayop nga paghukom. Kinahanglan nga dili kamo magpakita nga pinalabi ang usa ka tawo tungod kay siya kabos, ug kinahanglan nga dili kamo magpakita nga pinalabi ang usa ka tawo tungod kay mahinungdanon siya. Hinunoa, hukmi ang inyong silingan nga makatarunganon. ");
INSERT INTO cebulb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ayaw paglakawlakaw ug ipanabi ang dili tinuod diha sa inyong katawhan, apan tinguha ang pagpanalipod sa kinabuhi sa inyong silingan. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ayaw dumti ang inyong igsoon diha sa inyong kasingkasing. Kinahanglan badlongon ninyo nga matinud-anon ang inyong silingan aron dili ka makaambit sa iyang sala. ");
INSERT INTO cebulb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ayaw panimalos o pagkupot ug bisan unsang kaligutgot batok kang bisan kinsa sa inyong katawhan, apan higugmaa hinuon ang inyong silingan sama sa inyong kaugalingon. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Kinahanglan tipigan mo ang akong mga mando. Ayaw sulayi sa pagpahabal ang inyong mga hayop sa laing matang sa mga hayop. Ayaw sagola ang duha ka managlahi nga mga binhi sa dihang itanom kini sa inyong uma. Ayaw pagsul-ob ug bisti nga giusa sa paghimo gamit ang duha ka matang sa kasangkapan. ");
INSERT INTO cebulb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Si bisan kinsa ang nakighilawas sa ulipong babaye nga gisaad ngadto sa usa ka pamanhunon, apan wala siya gilukat o gihatagan ug kagawasan, kinahanglan nga silotan sila. Kinahanglan nga dili sila patyon tungod kay dili man gawasnon ang babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Kinahanglan dad-on sa lalaki ang iyang halad sa pagkasad-an ngadto kang Yahweh didto sa ganghaan sa toldang tagboanan- usa ka nating karnero ingon nga halad sa pagkasad-an. ");
INSERT INTO cebulb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Unya himoon sa pari ang kapasayloan alang kaniya pinaagi sa nating karnero alang sa halad sa pagkasad-an sa atubangan ni Yahweh, alang sa sala nga iyang nabuhat. Unya mapasaylo ang sala nga iyang gibuhat. ");
INSERT INTO cebulb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Sa dihang makaabot na kamo ngadto sa yuta ug magtanom sa tanang matang sa mga kahoy nga mamunga, kinahanglan nga pasagdan ninyo ang bunga niini ingon nga ginadili nga kan-on. Kinahanglan nga idili kaninyo ang bunga niini sulod sa tulo ka tuig. Kinahanglan nga dili kini kaonon. ");
INSERT INTO cebulb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Apan balaanon ang tanang bunga sa ikaupat nga tuig, usa kini ka halad sa pagdayeg kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Makahimo na kamo sa pagkaon sa bunga sa ikalima nga tuig, sa paghulat niini aron mamunga ug daghan ang mga kahoy. Ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ayaw pagkaon ug bisan unsa nga karne nga aduna pay dugo niini. Ayaw pagpakisayod sa mga espiritu mahitungod sa umaabot, ug ayaw pagbaton ug gahom-gahom aron sa pagdumala sa uban. ");
INSERT INTO cebulb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ayaw pagsunod sa mga gibuhat sa mga pagano sama sa pagkiskis sa buhok sa kilid sa inyong ulo o paggupit sa tumoy sa inyong bungot. ");
INSERT INTO cebulb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ayaw pagsamad-samad sa inyong lawas alang sa mga patay o pagpatato sa inyong lawas. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ayaw pakaulawi ang inyong anak nga babaye pinaagi sa paghimo kaniya nga tigbaligya ug dungog, o mahimong tigbaligya ug dungog ang tibuok nasod ug mapuno sa pagkadaotan ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kinahanglan nga tipigan ninyo ang akong Adlaw nga Igpapahulay ug tahoron ang akong tabernakulo. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ayaw pag-adto niadtong makihsulti sa mga patay o sa mga espiritu. Ayaw sila pangitaa, o mahugawan nila kamo. Ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Kinahanglan nga mobarog kamo atubangan sa mga tawong ubanon na ug tahora ang mga tigulang nga tawo. Kinahanglan mahadlok kamo sa inyong Dios. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kung nagpuyo uban kaninyo ang usa ka langyaw diha sa inyong yuta, kinahanglan nga dili ninyo siya pasakitan. ");
INSERT INTO cebulb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ang langyaw nga nagpuyo uban kaninyo kinahanglan nga parihason ninyo sa tawong Israelita nga nagpuyo uban kaninyo, ug kinahanglan nga higugmaon ninyo siya sama sa inyong kaugalingon, tungod kay nahimo kamong mga langyaw sa yuta sa Ehipto. Ako si Yahweh nga inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ayaw paggamit ug sayop nga sukdanan sa dihang magsukod kamo sa gitas-on, sa gibug-aton, o sa gidaghanon. ");
INSERT INTO cebulb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kinahanglan maggamit kamo ug hustong pangsukod, hustong timbangan, ug hustong Epha ug hustong hin. Ako si Yahweh ang inyong Dios, ang nagpagawas kaninyo sa yuta sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kinahanglan nga tumanon ninyo ang tanan kong kasugoan ug ang tanan kong mga balaod, ug buhata kini. Ako si Yahweh.”' ");
INSERT INTO cebulb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Nakigsulti si Yahweh kang Moises, nga miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Sultihi ang katawhan sa Israel, 'Si bisan kinsa sa katawhan sa Israel, o si bisan kinsa sa mga langyaw nga nagpuyo sa Israel nga nagtugyan sa iyang mga anak ngadto kang Molech, kinahanglan nga patyon gayod siya. Kinahanglan nga batoon siya sa katawhan sa maong dapit. ");
INSERT INTO cebulb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ipahilayo ko ang akong dagway batok nianang tawhana tungod kay gitugyan niya ang iyang anak ngadto kang Molech, tungod niini nahugawan ang akong balaang dapit ug gipasipalaan ang akong balaang ngalan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kung gipiyong sa katawhan niana nga yuta ang ilang mga mata sa dihang gitugyan niya ang bisan kinsa sa iyang anak ngadto kang Molech, kung dili nila siya patyon, ");
INSERT INTO cebulb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ako mismo ang magpahilayo sa akong panagway batok nianang tawhana ug sa iyang banay, ug wagtangon ko siya ug ang tanan nga nakighilawas sa tigbaligya ug dungog alang kang Molech. ");
INSERT INTO cebulb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ang nagpakisayod nga tawo ngadto sa mga makasulti sa mga patay o sa makasulti sa mga espiritu maingon nga nakighilawas sila ngadto kanila, atubangon ko kanang tawhana; wagtangon ko siya gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Busa paghinlo sa inyong kaugalingon ug pagbalaan, tungod kay ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kinahanglan nga tipigan ninyo ang akong mga mando ug tumana kini. Ako si Yahweh ang naglain kaninyo ingon nga balaan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Kinahanglan nga patyon gayod ang si bisan kinsa nga magtunglo sa iyang amahan o sa iyang inahan. Gitunglo niya ang iyang amahan o ang iyang inahan, busa sad-an siya ug angay nga mamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ang lalaki nga nanapaw sa asawa sa laing lalaki, si bisan kinsa ang nanapaw sa asawa sa iyang silingan—ang lalaki nga nanapaw ug ang babaye nga nanapaw kinahanglan nga patyon gayod sila. ");
INSERT INTO cebulb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ang lalaki nga mihigda uban sa asawa sa iyang amahan aron makighilawas kaniya nagpakaulaw sa iyang kaugalingong amahan. Patyon gayod ang anak nga lalaki ug ang asawa sa iyang amahan. Sad-an sila ug angay nga mamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kung ang usa ka lalaki nakighilawas sa iyang umagad nga babaye, silang duha kinahanglan nga patyon gayod. Dili gayod tiaw ang ilang pagpakasala. Sad-an sila ug angay nga mamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kung ang lalaki nakighilawas sa isigka-lalaki, maingon man ang isigka-babaye, nakabuhat sila sa butang nga mahugaw. Kinahanglan nga patyon gayod sila. Sad-an sila ug angay nga mamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kung ang lalaki nakigminyo sa usa ka babaye ug minyoan usab niya ang inahan niini, daotan kini. Kinahanglan nga sunogon sila, siya ug ang mga babaye, aron walay daotan diha kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kung ang usa ka lalaki nakighilawas sa mananap, kinahanglan nga patyon gayod siya, ug kinahanglan nga patyon ninyo ang mananap. ");
INSERT INTO cebulb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kung ang usa ka babaye nga nakighilawas sa bisan unsa nga mananap, kinahanglan nga patyon ninyo ang babaye ug ang mananap. Sad-an sila ug angay nga mamatay. ");
INSERT INTO cebulb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kung ang usa ka lalaki nakighilawas sa iyang igsoong babaye, bisan anak kini nga babaye sa iyang amahan o anak nga babaye sa iyang inahan—kung nakighilawas siya kaniya ug ang babaye kaniya, makauulaw kini nga butang. Pagawagtangon sila gikan sa presensya sa ilang katawhan, tungod kay nakighilawas siya sa iyang igsoong babaye. Manubag siya sa iyang sala. ");
INSERT INTO cebulb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kung ang usa ka lalaki nakighilawas sa usa ka babaye sa panahon nga gidugo siya, giablihan niya ang pag-agas sa iyang dugo, ang tinubdan sa iyang dugo. Pagawagtangon ang lalaki ug ang babaye gikan sa ilang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ayaw pakighilawas sa inyong iyaan nga igsoon sa inyong inahan, o sa inyong iyaan nga igsoon sa inyong amahan, tungod kay mapakaulawan ninyo ang inyong kadugo. Manubag kamo sa inyong kaugalingong sala. ");
INSERT INTO cebulb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kung ang usa ka lalaki nakighilawas sa iyang iyaan, wala niya tahora ang iyang uyoan. Sa dihang mamatay sila, pagasilotan ko sila, ug sa dihang mamatay sila, kuhaon ko ang bisan unsa nga mapanunod sa ilang mga anak nga ilang madawat gikan sa ilang mga ginikanan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Kung minyoan sa usa ka lalaki ang asawa sa iyang igsoon samtang buhi pa ang iyang igsoong lalaki, usa kana ka pagpakaulaw. Wala niya tahora ang iyang igsoong lalaki, ug pagakuhaon ko gikan sa ilang mga anak ang bisan unsa nga katigayonan nga ilang mapanunod gikan sa ilang mga ginikanan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Busa kinahanglan nga tipigan ninyo ang tanan nakong balaod ug kasugoan; kinahanglan nga tumanon ninyo kini aron dili kamo isuka sa yuta nga akong pagadad-an kaninyo nga inyong puy-an. ");
INSERT INTO cebulb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kinahanglan nga dili kamo maglakaw sa naandan sa mga nasod nga akong papahawaon sa inyong atubangan, kay gibuhat nila kining tanang mga butang, ug gikaligutgotan ko sila. ");
INSERT INTO cebulb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Nag-ingon ako kaninyo, “Mapanunod ninyo ang ilang yuta; ihatag ko kini kaninyo aron panag-iyahon, usa ka yuta nga nagdagayday sa gatas ug dugos. Ako si Yahweh ang inyong Dios, nga naglain kaninyo gikan sa ubang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Busa kinahanglan nga ilhon ninyo ang hinlo ug ang mahugaw nga mga mananap, ug mahugaw ug ang hinlo nga mga langgam. Kinahanglan nga dili ninyo hugawan ang inyong kaugalingon sa mahugaw nga mga mananap o sa mga langgam o sa bisan unsa nga mga mananap nga nagakamang sa yuta, nga akong gilain ingon nga mahugaw gikan kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kinahanglan nga magbalaan kamo, kay ako, si Yahweh, balaan man, ug ako ang naglain kaninyo gikan sa ubang katawhan, tungod kay nahisakop man kamo kanako. ");
INSERT INTO cebulb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ang usa ka lalaki o babaye nga nakigsulti sa mga patay o nakigsulti sa mga espiritu kinahanglan nga patyon gayod. Kinahanglan nga batoon sila. Sad-an sila ug angay nga mamatay.”' ");
INSERT INTO cebulb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Miingon si Yahweh kang Moises: “Pakigsulti sa mga pari, ang mga anak nga lalaki ni Aaron, ug sultihi sila, 'Walay bisan usa kaninyo nga maghugaw sa iyang kaugalingon sa paghikap niadtong namatay taliwala sa iyang katawhan, ");
INSERT INTO cebulb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","gawas sa iyang suod nga mga paryente—sa iyang inahan, sa iyang amahan, sa iyang anak nga lalaki, sa iyang anak nga babaye, sa iyang igsoon nga lalaki, ");
INSERT INTO cebulb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o sa iyang igsoong babaye nga ulay nga nagsalig pa kaniya, tungod kay wala pa siyay bana—kay alang kaniya mahimo niyang hugawan ang iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Apan kinahanglan nga dili niya hugawan ang iyang kaugalingon alang sa ubang mga paryente ug tungod niini mahugawan niya ang iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Kinahanglan dili opawan sa mga pari ang ilang mga ulo o kiskisan ang kilid sa ilang mga balbas, ni samadsamaran nila ang ilang lawas. ");
INSERT INTO cebulb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kinahanglan balaan sila sa atubangan sa ilang Dios ug dili pakaulawan ang iyang ngalan, tungod kay maghalad ang mga pari sa mga halad nga kalan-on alang kang Yahweh, ang tinapay sa ilang Dios. Busa kinahanglan nga balaan ang mga pari. ");
INSERT INTO cebulb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Kinahanglan nga dili sila mangasawa sa mga babaye nga nagabaligyag dungog ug mga mahugaw, ug dili sila angay mangasawa sa usa ka babaye nga gibulagan sa iyang bana, kay gilain sila alang sa ilang Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ilain ninyo siya, tungod kay siya man ang maghalad sa tinapay ngadto sa inyong Dios. Kinahanglan balaan siya alang kaninyo, tungod kay ako, si Yahweh ang nagbalaan kaninyo, tungod kay balaan man ako. ");
INSERT INTO cebulb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Si bisan kinsa nga anak sa pari nga babaye nga naghugaw sa iyang kaugalingon pinaagi sa pagbaligya sa iyang dungog nagpakaulaw sa iyang amahan. Kinahanglan nga sunogon siya. ");
INSERT INTO cebulb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ang usa ka labaw nga pari sa iyang mga igsoong lalaki, kansang ulo gidihogan sa lana nga igdidihog, ug gibalaan aron sa pagsul-ob sa pinasahi nga mga bisti sa labawng pari, kinahanglan nga dili kalkag ang iyang buhok o gision ang iyang mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kinahanglan dili siya moadto bisan asa nga adunay mga patay nga lawas ug maghugaw sa iyang kaugalingon, bisan pa sa iyang amahan o sa iyang inahan. ");
INSERT INTO cebulb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kinahanglan nga dili mobiya ang labawng pari sa balay nga alampoanan sa tabernakulo o magpasipala sa balay alampoanan sa iyang Dios, tungod kay gibalaan na siya ingon nga labawng pari pinaagi sa lana nga igdidihog sa iyang Dios. Kay ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Kinahanglan mangasawa ang labawng pari sa usa ka babayeng ulay. ");
INSERT INTO cebulb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Kinahanglan dili siya mangasawa ug usa ka balo, sa gibulagan ug bana, o sa babaye nga nagbaligya ug dungog. Dili siya mangasawa niining mga matanga sa mga babaye. Makapangasawa lamang siya sa usa ka ulay nga gikan sa iyang katawhan, ");
INSERT INTO cebulb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","aron nga dili niya mahugawan ang iyang mga anak taliwala sa iyang katawhan, kay ako si Yahweh, ang nagbalaan kaniya.”” ");
INSERT INTO cebulb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Nagsulti si Yahweh kang Moises, nga miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Pakigsulti kang Aaron ug sultihi siya, 'Si bisan kinsa sa imong kaliwatan hangtod pa sa ilang mosunod pang kaliwatan nga adunay ikasaway sa iyang lawas, kinahanglan dili siya moduol sa paghalad sa kalan-on ngadto sa iyang Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ang mga tawo ang adunay ikasaway sa lawas kinahanglan dili moduol kang Yahweh, sama sa tawong buta o tawong dili makalakaw, tawong piang o daot ang nawong, ");
INSERT INTO cebulb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","usa ka tawong pungkol o putol ang tiil, ");
INSERT INTO cebulb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","usa ka tawong buktot o payat o onano, o usa ka tawong daot ang mga mata, o adunay sakit, nukahon, kabahongon, kugangon o kadtong tawo nga kinapon. ");
INSERT INTO cebulb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Wala gayoy tawo diha sa kaliwatan ni Aaron ang pari nga adunay ikasaway sa lawas ang makaduol aron maghalad sa mga halad sinunog alang kang Yahweh. Kanang mga tawhana nga adunay ikasaway sa lawas; kinahanglan dili siya moduol aron maghalad sa tinapay sa iyang Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Makakaon siya sa pagkaon sa iyang Dios, bisan sa ubang labing balaan o sa ubang balaan. ");
INSERT INTO cebulb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Apan, dili siya makasulod sa tabil o makaduol sa halaran, tungod kay aduna may ikasaway sa iyang lawas, aron dili niya mahugawan ang akong balaang dapit, kay ako si Yahweh, ang nagbalaan kanila.”' ");
INSERT INTO cebulb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Busa gisulti ni Moises kini nga mga pulong ngadto kang Aaron, ngadto sa iyang mga anak nga lalaki, ug ngadto sa tibuok katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Gisultihan ni Yahweh si Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Pakigsulti kang Aaron ug sa iyang mga anak nga lalaki, ug sultihi sila nga magpalayo gikan sa balaang mga butang sa katawhan sa Israel, nga gilain alang kanako. Kinahanglan dili nila pasipad-an ang akong balaang ngalan. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Sultihi sila, 'Kung si bisan kinsa sa tibuok ninyong kaliwatan ang mopaduol sa balaang mga butang nga gihalad sa katawhan sa Israel alang kang Yahweh, samtang hugaw pa siya, kinahanglan kanang tawhana hinginlan sa akong atubangan: Kay ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Walay kaliwat ni Aaron nga adunay makatakod nga sakit sa panit, o adunay sakit nga nagaagas sa iyang pribadong bahin sa lawas, ang makakaon sa bisan unsa nga mga gihalad ngadto kang Yahweh hangtod nga mahinlo na siya. Si bisan kinsa ang makahikap sa mga mahugaw pinaagi sa paghikap sa mga minatay, o makahikap sa usa ka tawo nga gigawasan ug similya, ");
INSERT INTO cebulb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o makahikap sa bisan unsang nagakamang nga mananap o tawo nga makapahugaw kaniya— ");
INSERT INTO cebulb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","unya ang pari nga makahikap sa bisan unsang hugaw dili gayod mahinlo hangtod pagsalop sa adlaw. Kinahanglan dili siya mokaon sa bisan unsang balaan nga mga kalan-on, gawas lamang kung ligoan niya ang iyang lawas. ");
INSERT INTO cebulb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sa dihang mosalop na ang adlaw, mamahinlo na siya. Sa pagsalop na sa adlaw makakaon na siya sa mga butang nga balaan, tungod kay mao man kana ang iyang kalan-on. ");
INSERT INTO cebulb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kinahanglan dili siya mokaon sa bisan unsa nga nakaplagang patay o gitukob sa ihalas nga mga mananap, kay pinaagi niini mahugawan niya ang iyang kaugalingon. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ang mga pari kinahanglan motuman gayod sa akong mga gipanudlo, kondili mahimo silang sad-an sa sala ug mamatay sa pagpasipala kanako. Ako si Yahweh ang nagbalaan kanila. ");
INSERT INTO cebulb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ang dili sakop sa panimalay sa pari, lakip ang mga bisita sa pari o iyang sinuholan nga mga sulugoon, dili makakaon sa bisan unsa nga balaan. ");
INSERT INTO cebulb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Apan kung paliton sa pari gamit ang iyang kaugalingong salapi ang mga ulipon, kana nga ulipon makakaon sa mga butang nga gilain alang kang Yahweh. Ang mga sakop sa panimalay sa pari ug ang mga ulipon nga nahimugso sa iyang pinuy-anan, makakaon usab sila uban kaniya gikan niadtong mga pagkaon. ");
INSERT INTO cebulb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kung ang babayeng anak sa pari naminyo sa tawo nga dili pari, dili na siya makakaon pa sa sa balaang mga halad. ");
INSERT INTO cebulb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Apan kung nabalo na ang babayeng anak sa pari, o nagbulag na sila sa iyang bana, ug kung wala siyay anak, ug moipon na siya pagpuyo sa balay sa iyang amahan sama sa iyang pagkabatan-on, makakaon siya gikan sa pagkaon sa iyang amahan. Apan dili makakaon ang dili sakop sa panimalay sa pari sa parianong kalan-on niini. ");
INSERT INTO cebulb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Kung makakaon ang tawo sa pagkaon nga gihalad ug wala siya nasayod nga balaan kini, kinahanglan ulian niya ang pari alang niini; idugang usab niya ang ikalima nga bahin niini ug iuli kini sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kinahanglan dili pasipad-an sa katawhan sa Israel ang mga balaang butang nga ilang gibayaw ug gihalad ngadto kang Yahweh, ");
INSERT INTO cebulb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ug maoy hinungdan nga pas-anon nila ang sala nga maoy mohimo kanila nga sad-an sa pagkaon nga balaang kalan-on, kay ako si Yahweh ang nagbalaan kanila.”' ");
INSERT INTO cebulb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Gisultihan ni Yahweh si Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Sultihi si Aaron ug ang iyang mga anak nga lalaki, ug ang tibuok katawhan sa Israel. Sultihi sila, 'Bisan kinsa sa mga Israelita, o sa mga langyaw nga nagpuyo sa Israel, sa dihang maghalad sila — bisan alang kini sa pagtuman sa panaad, o kinabubut-on kini nga paghalad, o maghalad sila kang Yahweh sa halad sinunog, ");
INSERT INTO cebulb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kung ba dawaton kini, kinahanglan maghalad sila ug laking mananap nga walay ikasaway gikan sa mga baka, sa mga karnero, o sa mga kanding. ");
INSERT INTO cebulb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Apan kinahanglan nga dili kamo maghalad niadtong adunay ikasaway. Dili ko gayod kini dawaton gikan kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Bisan kinsa nga maghalad ug mga halad sa pakigdait gikan sa panon sa baka o panon sa karnero ngadto kang Yahweh aron sa pagtuman sa panaad, o kinasingkasing nga halad, kinahanglan nga walay ikasaway aron dawaton kini. Kinahanglan walay ikasaway sa mananap. ");
INSERT INTO cebulb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kinahanglan dili kamo maghalad ug mga mananap nga buta, piang, o pungkol, o kalunggohon, nukahon, o sanglahon. Kinahanglan dili ninyo kini ihalad ngadto kang Yahweh ingon nga usa ka halad sunogon ibabaw sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Makahalad kamo ingon nga kinasingkasing nga paghalad ug nating baka o nating karnero nga masakiton o ihid, apan ang sama niana nga halad dili pagadawaton alang sa panaad. ");
INSERT INTO cebulb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ayaw kamo paghalad ngadto kang Yahweh ug bisan unsa nga mananap nga nabun-og, nadugmok, gikuniskunis, o mga kinapon. Ayaw kini buhata sa inyong yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kinahanglan dili kamo maghalad ug tinapay sa inyong Dios nga gikan sa kamot sa usa ka langyaw. Kadtong mga mananap nga masakiton ug adunay ikasaway niini, dili kini pagadawaton gikan kaninyo.”' ");
INSERT INTO cebulb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Nagsulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Sa dihang ipanganak ang laking baka o ang karnero o ang kanding, kinahanglan magpabilin kini sa iyang inahan sulod sa pito ka mga adlaw. Unya gikan sa ikawalo ka adlaw, madawat na kini ingon nga halad alang sa usa ka halad nga gihimo nga halad sinunog alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ayaw ihawa ang baka o bayeng karnero uban ang nati niini, sa samang adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Sa dihang maghalad kamo ug halad sa pagpasalamat kang Yahweh, kinahanglan ihalad ninyo kini sa maayong pamaagi. ");
INSERT INTO cebulb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kinahanglan kan-on kini niana gayong adlawa. Kinahanglan dili magsalin niini hangtod sa pagkabuntag. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Busa kinahanglan tipigan ninyo ang akong mga kasugoan ug tumana kini. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kinahanglan dili ninyo pasipad-an ang akong balaang ngalan. Kinahanglan ilhon ako nga balaan sa katawhan sa Israel. Ako si Yahweh ang nagbalaan kaninyo, ");
INSERT INTO cebulb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ang nagpalingkawas kaninyo sa yuta sa Ehipto aron mahimo ninyong Dios: Ako si Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Gisultihan ni Yahweh si Moises: ");
INSERT INTO cebulb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Sultihi ang katawhan sa Israel, ug isulti kanila, “Mao kini ang gitakda nga mga kasaulogan alang kang Yahweh, nga kinahanglan inyong imantala ingon nga balaan nga mga panagtigom; mao kini ang mga kasaulogan nga himoon kanunay. ");
INSERT INTO cebulb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Makatrabaho kamo sa unom ka adlaw, apan sa ikapito nga adlaw mao ang hingpit nga Adlaw nga Igpapahulay, usa ka balaan nga panagtigom. Kinahanglan dili kamo magtrabaho tungod kay kini Adlaw nga Igpapahulay alang kang Yahweh sa tanang mga dapit kung asa kamo nagpuyo. ");
INSERT INTO cebulb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Mao kini ang gitakda nga mga kasaulogan ni Yahweh, ang balaang mga panagtigom nga kinahanglan imantala ninyo sa ilang gitakda nga mga panahon: ");
INSERT INTO cebulb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Sa unang bulan, sa ikanapulo ug upat ka adlaw sa bulan sa pagsalop sa adlaw, mao ang kasaulogan sa Pagsaylo ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Sa ikanapulo ug lima ka adlaw sa sama nga bulan mao ang Kasaulogan sa Tinapay nga walay patubo alang kang Yahweh. Sa pito ka mga adlaw makakaon kamo sa tinapay nga walay patubo. ");
INSERT INTO cebulb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Sa unang adlaw kinahanglan magbalaan kamo aron magkatigom; dili kamo magbuhat ug bisan unsa sa inyong naandan nga buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Maghalad kamo ug halad nga kalan-on alang kang Yahweh sulod sa pito ka adlaw. Ang ikapito nga adlaw mao ang gitakda ni Yahweh nga panagtigom, ug nianang adlawa kinahanglan nga dili kamo magtrabaho sa inyong naandan nga buluhaton.”' ");
INSERT INTO cebulb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Nagsulti si Yahweh kang Moises, nga miingon ");
INSERT INTO cebulb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Sultihi ang katawhan sa Israel ug isulti kanila, 'Sa dihang mosulod kamo sa yuta nga akong ihatag kaninyo, ug sa dihang moani kamo sa abot niini, nan kinahanglan dad-on ninyo ang usa ka bugkos sa unang abot ngadto sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ibayaw niya ang binugkos sa atubangan ni Yahweh ug ihalad kini kaniya, kay aron pagadawaton kini gikan kaninyo. Himoon kini pagkaugma human sa Adlawng Igpapahulay nga ibayaw sa pari ug ihalad kini kanako. ");
INSERT INTO cebulb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Sa adlaw sa dihang ibayaw ang binugkos nga uhay ug ihalad kini kanako, kinahanglan ihalad ninyo kanako ang usa ka tuig nga laking karnero ug walay ikasaway isip usa ka halad sinunog kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ang trigo nga ihalad kinahanglan 2/10 ka ephah sa harina nga gisagolan ug lana, ang halad nga sinunog alang kang Yahweh, aron makahatag sa kahumot, ug ang halad nga ilimnon, ang ikaupat nga bahin sa usa ka hin. ");
INSERT INTO cebulb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kinahanglan dili kamo mokaon sa tinapay, ni ang sinanlag o hilaw nga uhay, hangtod sa adlaw nga mahalad ninyo kini sa inyong Dios. Dili kini mausab nga balaod alang sa tibuok kaliwatan sa katawhan, sa matag dapit nga inyong puy-an. ");
INSERT INTO cebulb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Magsugod kini sukad sa adlaw human sa Adlawng Igpapahulay—mao kadto ang adlaw nga inyong gidala ang binugkos nga uhay nga halad nga gibayaw—nga nag-ihap hangtod sa pito ka semana. ");
INSERT INTO cebulb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Kinahanglan mag-ihap kamo ug 50 ka adlaw, nga magsulad human sa ikapito nga Adlawng Igpapahulay. Unya kinahanglan maghalad kamo ug mga bag-o nga trigo ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Pagdala kamo gikan sa inyong pinuy-anan ug duha ka tinapay nga hinimo sa 2/10 ka ephah. Kinahanglan hinimo kini sa maayo nga harina ug linuto nga adunay patubo; mahimo kini nga halad iwarawar sa unang mga abot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kinahanglan ihalad ninyo ang tinapay uban ang pito ka mga karnero nga nagpanuigon ug usa nga walay ikasaway, usa ka nating baka, ug duha ka laking karnero. Kinahanglan adunay kamoy halad sinunog ngadto kang Yahweh, uban sa ilang halad nga trigo ug ang ilang mga halad nga ilimnon, usa ka halad sinunog nga makahatag ug kahumot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kinahanglan maghalad kamo ug usa ka laking kanding alang sa sala, ug duha ka turong karnero aron ihalad, isip halad sa pakigdait. ");
INSERT INTO cebulb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ang pari magbayaw niini uban ang unang abot nga tinapay ngadto sa atubangan ni Yahweh, ug ihalad kini kaniya isip usa ka halad uban ang duha ka karnero. Balaan kini nga mga halad ngadto kang Yahweh alang sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Sa maong adlaw gayod kinahanglan imantala ninyo kini. Adunay balaang panagtigom, ug kinahanglan nga dili kamo magbuhat sa naandan nga buluhaton. Kini ang mapinadayonong balaod sa tibuok pa ninyong kaliwatan sa katawhan sa tanang dapit kung asa kamo nagpuyo. ");
INSERT INTO cebulb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Sa dihang moani kamo sa abot sa inyong yuta, kinahanglan dili ninyo hutdon ug ani ang anaa sa mga daplin sa inyong kaumahan, ug kinahanglan dili ninyo hagdawon ang nahibilin sa inyong ani. Kinahanglan ibilin ninyo kini alang sa kabos ug alang sa langyaw. Ako si Yahweh ang inyong Dios.”' ");
INSERT INTO cebulb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Nakigsulti si Yahweh kang Moises, nga miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Sultihi ang katawhan sa Israel, 'Sa ikapitong bulan, sa unang adlaw nianang bulana mao ang balaang pagpahulay alang kaninyo, usa ka handomanan uban ang pagpatingog sa mga trumpeta, ug ang balaang panagtigom. ");
INSERT INTO cebulb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kinahanglan dili kamo magbuhat sa naandan ninyong buluhaton, ug kinahanglan maghalad kamo ug halad sinunog ngadto kang Yahweh.”' ");
INSERT INTO cebulb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Unya nagsulti si Yahweh kang Moises, nga miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Karon ang ikapulo nga adlaw niining bulana mao ang Adlaw sa Pagtabon sa sala. Mao kini ang balaang panagtigom, ug kinahanglan magpaubos kamo sa inyong kaugalingon ug maghalad kang Yahweh ug usa ka halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Kinahanglan dili kamo magtrabaho niana nga adlaw tungod kay mao kana ang Adlaw sa Pagtabon sa sala, aron sa pagpasaylo sa inyong sala sa atubangan ni Yahweh nga inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Si bisan kinsa nga dili magpaubos sa iyang kaugalingon nianang adlawa papahawaon gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Si bisan kinsa kadtong nagtrabaho nianang adlawa, ako, si Yahweh, magalaglag kaniya gikan sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kinahanglan dili kamo magbuhat ug bisan unsa nga buluhaton nianang adlawa. Mao kini ang dili mausab nga balaod ngadto sa tibuok ninyong kaliwatan sa katawhan sa tanang dapit kung asa kamo nagpuyo. ");
INSERT INTO cebulb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kini nga adlaw usa gayod ka Adlawng Igpapahulay alang kaninyo sa balaan nga pagpahulay, ug iaubos gayod ninyo ang inyong kaugalingon sa ikasiyam nga adlaw sa bulan nianang gabhiona. Gikan sa hapon hangtod sa sunod hapon kinahanglang magbantay kamo sa inyong Adlawng Igpapahulay.” ");
INSERT INTO cebulb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Gisultihan ni Yahweh si Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Sultihi ang katawhan sa Israel, 'Sa ika-15 nga adlaw sa ikapito nga bulan mao ang Kasaulogan sa mga Balongbalong alang kang Yahweh. Mahuman kini sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Sa unang adlaw kinahanglan adunay balaang panagtigom. Dili kamo magbuhat sa naandan ninyong buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kay sulod sa pito ka adlaw kinahanglan maghalad kamo ug usa ka halad sinunog ngadto kang Yahweh. Sa ikawalo ka adlaw kinahanglan adunay balaang panagtigom, ug maghalad kamo ug halad sinunog kang Yahweh. Mao kini ang balaang panagtigom, ug dili gayod kamo angay magbuhat sa naandan nga buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Mao kini ang gitakda nga mga kasaulogan alang kang Yahweh, nga kinahanglan ninyong imantala ingon nga balaang mga panagtigom aron maghalad pinaagi sa pagsunog sa halad ngadto kang Yahweh, ang halad sinunog ug ang halad nga trigo, mga halad ug mga halad nga ilimnon, ang matag halad sa iyang kaugalingon nga adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Labot pa ang kasaulogan sa Adlawng Igpapahulay ni Yahweh ug ang inyong mga gasa, tanan ninyong mga panaad, ug tanan ninyong kinasingkasing nga mga halad nga inyong gihatag kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Bahin sa Kasaulogan sa mga Balongbalong, sa ika-15 ka adlaw sa ikapito nga bulan, sa dihang tigomon na ninyo ang mga abot sa inyong yuta, kinahanglan bantayan ninyo kining kasaulogan alang kang Yahweh sulod sa pito ka adlaw. Sa unang adlaw mao ang balaang pagpahulay, ug ang ikawalo nga adlaw usab ang balaang pagpahulay. ");
INSERT INTO cebulb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Sa unang adlaw kinahanglan magkuha kamo ug maayong bunga sa kahoy, mga palwa sa palmera, ug mga sanga sa kahoy nga daghang mga dahon, mga tanom daplin sa kasapaan, ug paglipay kamo atubangan ni Yahweh nga inyong Dios sulod sa pito ka adlaw. ");
INSERT INTO cebulb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kay sulod sa pito ka adlaw sa matag tuig, kinahanglan magsaulog kamo niining kasaulogan alang kang Yahweh. Mao kini ang dili mausab nga balaod sa tibuok ninyong kaliwatan sa tanang dapit kung asa kamo nagpuyo. Kinahanglan saulogon ninyo kining kasaulogan sa ikapito nga bulan. ");
INSERT INTO cebulb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Magpuyo kamo sa gamay nga balongbalong sulod sa pito ka adlaw. Tanang Israelita nga gipanganak sa Israel kinahanglang magpuyo sa gagamay nga balongbalong sulod sa pito ka adlaw, ");
INSERT INTO cebulb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","aron nga ang inyong kaliwatan, ug ang mosunod pa nga kaliwatan, makahibalo kung giunsa ko pagpalingkawas ang katawhan sa Israel sa yuta sa Ehipto. Ako si Yahweh nga inyong Dios.”' ");
INSERT INTO cebulb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Niining paagiha, gipahibalo ni Moises ang katawhan sa Israel sa gitakda nga mga kasaulogan alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Mandoi ang katawhan sa Israel nga magdala ug lunsay nga lana nga gipuga gikan sa olibo aron gamiton sa lampara, aron magpadayon ang pagsiga sa lampara. ");
INSERT INTO cebulb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Sa gawas sa tabil sa atubangan sa kasugoan sa tolda nga tagboanan, kinahanglan kanunay pasigaon ni Aaron ang lampara, gikan sa gabii hangtod sa pagkabuntag, sa atubangan ni Yahweh. Makanunayon kini nga kasugoan ngadto sa kaliwatan sa inyong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Kinahanglan kanunay pasigaon sa labaw nga pari ang lampara sa atubangan ni Yahweh, ang mga lampara nga anaa sa tungtonganan nga lunsayng bulawan. ");
INSERT INTO cebulb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Kinahanglan magkuha ka ug maayong harina ug pagluto ug dose ka tinapay gamit kini. Kinahanglan adunay 2/10 ka epha sa matag tinapay. ");
INSERT INTO cebulb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Unya kinahanglan nga ibutang mo kini sa duha ka laray, unom sa matag laray, diha sa lamisa nga lunsayng bulawan sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kinahanglan nga butangan mo ug lunsayng insenso ang matag laray sa mga tinapay ingon nga pagpaila sa halad. Pagasunogon kini nga insenso alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sa matag Adlaw nga Igpapahulay kinahanglan ilain kanunay sa labaw nga pari ang tinapay sa atubangan ni Yahweh nga gikan sa katawhan sa Israel, ingon nga timailhan sa walay kataposan nga kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Kini nga halad alang kang Aaron ug sa iyang mga anak nga lalaki, ug kaonon nila kini didto sa balaan nga dapit, kay kini nga bahin gikan sa mga halad nga sinunog ngadto kang Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Karon nahitabo nga ang anak nga lalaki sa babaye nga Israelita, nga ang amahan usa ka Ehiptohanon nga nagpuyo uban sa katawhan sa Israel. Kini nga anak nga lalaki sa babaye nga Israelita nakigbatok sa tawo nga Israelita diha sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Gipasipad-an sa anak nga lalaki sa babaye nga Israelita ang ngalan ni Yahweh ug gitunglo ang Dios, busa gidala siya sa katawhan ngadto kang Moises. Ang ngalan sa iyang inahan mao si Shelomit, ang anak nga babaye ni Dibri nga gikan sa tribo ni Dan. ");
INSERT INTO cebulb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Gibilanggo nila siya hangtod nga isulti ni Yahweh ang iyang kabubut-on ngadto kanila. ");
INSERT INTO cebulb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Unya nakigsulti si Yahweh kang Moises, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Dad-a ang tawo nga nagtunglo sa Dios ngadto sa gawas sa kampo. Ang tanang nakadungog kaniya kinahanglan motapion sa ilang mga kamot diha sa iyang ulo, ug unya kinahanglan nga batohon siya sa tanang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Kinahanglan nga ipasabot ug isulti nimo ngadto sa katawhan sa Israel, 'Si bisan kinsa nga magtunglo sa iyang Dios kinahanglan manubag sa iyang sala. ");
INSERT INTO cebulb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Siya nga magpasipala sa ngalan ni Yahweh kinahanglan nga pagapatyon gayod. Kinahanglan nga batohon siya sa tanang katawhan, bisan kon siya usa ka langyaw o taga-Israel. Kung adunay magpasipala sa ngalan ni Yahweh, kinahanglang patyon gayod siya. ");
INSERT INTO cebulb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Kung adunay makapatay ug laing tawo, kinahanglan nga patyon usab siya. ");
INSERT INTO cebulb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kung adunay tawo nga makapatay ug mananap sa laing tawo, kinahanglan bayaran niya kini, kinabuhi alang sa kinabuhi. ");
INSERT INTO cebulb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kung nakapasakit si bisan kinsa sa iyang isigkatawo, kinahanglan nga buhaton usab kini ngadto kaniya sama sa iyang gibuhat sa iyang isigkatawo: ");
INSERT INTO cebulb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ang nabalian alang sa nabalian, ang mata alang sa mata, ang ngipon alang sa ngipon. Kay siya ang hinungdan sa pagkabalda sa usa ka tawo, busa kinahanglan nga buhaton usab kini ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Si bisan kinsa nga makapatay ug mananap kinahanglan bayaran niya kini, ug si bisan kinsa nga makapatay ug tawo kinahanglan patyon gayod. ");
INSERT INTO cebulb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kinahanglan aduna kamoy managsamang balaod alang sa mga langyaw ug sa taga-Israel, kay ako si Yahweh ang inyong Dios.''' ");
INSERT INTO cebulb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Busa nakigsulti si Moises sa katawhan sa Israel, ug gidala sa katawhan sa gawas sa kampo ang tawo nga nagtunglo kang Yahweh. Gibato nila siya. Gituman sa katawhan sa Israel ang gimando ni Yahweh ngadto kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Nakigsulti si Yahweh kang Moises didto sa Bukid sa Sinai, nga nag-ingon, ");
INSERT INTO cebulb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Pakigsulti sa katawhan sa Israel ug ingna sila, 'Sa dihang didto na kamo sa yuta nga ihatag ko kaninyo, ang maong yuta kinahanglan nga matipigan sa Adlaw nga Igpapahulay alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kinahanglan magtanom kamo sa inyong uma sulod sa unom ka tuig, ug kinahanglan nga pul-ongan ninyo ang inyong kaparasan sulod sa unom ka tuig ug tigomon ang abot. ");
INSERT INTO cebulb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Apan sa ikapito nga tuig, kinahanglan nga papahulayon ang yuta, sa adlaw nga Igpapahulay alang kang Yahweh. Kinahanglan dili ninyo tamnan ang inyong uma o pul-ongan ang inyong kaparasan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kinahanglan dili ninyo anihon ang bisan unsa nga nanurok human sa pag-ani niini ug kinahanglan dili ninyo pupoon ang bisan unsa nga ubas nga mamunga diha sa wala mapul-ongan nga kaparasan. Mao kini ang tuig sa pagpahulay sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Bisan unsa nga moturok panahon sa tuig sa Adlaw nga Igpapahulay mahimong pagkaon alang kaninyo. Kamo, ang inyong mga sulugoon nga lalaki ug babaye, ang inyong sinuholan nga mga sulugoon ug ang mga langyaw nga nagpuyo uban kaninyo makatigom ug pagkaon, ");
INSERT INTO cebulb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ug ang inyong kahayopan ug ang ihalas nga mga mananap makakaon usab sa bisan unsa nga abot sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Kinahanglan mag-ihap kamo ug pito ka Adlaw nga Igpapahulay sa matag tuig, mao kana, ang pito ka pilo sa pito ka tuig, aron adunay pito ka Adlaw nga Igpapahulay, sulod sa 49 ka katuigan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Unya kinahanglan nga patingogon ninyo sa makusog ang trumpeta bisan asa sa ikanapulo nga adlaw sa ikapito nga bulan. Sa Adlaw sa Kapasayloan kinahanglan patingogon ninyo ang trumpeta sa tibuok ninyong kayutaan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kinahanglan ilain ninyo ang ika-50 nga tuig alang kang Yahweh ug imantala ang kagawasan sa tibuok kayutaan ngadto sa tanang lumolupyo niini. Mao kini ang Kagawasan ug Pag-uli alang kaninyo, diin ang kabtangan ug ang mga sulugoon kinahanglan mahibalik sa ilang mga panimalay. ");
INSERT INTO cebulb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mahimong Kagawasan ug pag-uli alang kaninyo ang ika-50 ka tuig. Kinahanglan dili kamo magtanom o mag-ani sa abot. Kaon sa bisan unsa nga moturok niini, ug tigoma ang mga ubas nga mamunga sa wala napul-ongan nga kaparasan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kay mao kini ang Kagawasan ug Pag-uli, diin balaan alang kaninyo. Kinahanglan mokaon kamo sa abot nga moturok niini diha sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Kinahanglan ibalik ninyo sa matag usa ang kabtangan nga iyang gipanag-iya niining tuig sa Kagawasan ug Pag-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kung mobaligya kamo ug yuta ngadto sa inyong isigkatawo o mopalit ug yuta gikan sa inyong isigkatawo, kinahanglan dili kamo manikas o manglimbong sa usag-usa. ");
INSERT INTO cebulb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kung magpalit kamo ug yuta sa inyong isigkatawo, timan-i ang mga katuigan ug ang mga tanom nga mahimong abot hangtod sa sunod nga Kagawasan ug Pag-uli. Kinahanglan nga motimaan usab ang inyong isigkatawo nga nagbaligya sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Taas ang kantidad sa yuta kung dugay pa ang tuig sa sunod nga Kagawasan ug Pag-uli, ug barato ang kantidad kung duol na ang tuig sa sunod nga Kagawasan ug Pag-uli, tungod kay ang panahon sa pag-ani sa yuta maghatag sa abot alang sa bag-ong tag-iya gipasikad sa panahon sa katuigan sa dili pa ang sunod nga Kagawasan ug Pag-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kinahanglan dili kamo manikas o manglimbong sa usag-usa; hinuon, kinahanglan nga pasidunggan ninyo ang inyong Dios, kay ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Busa kinahanglan nga tumanon ninyo ang akong mga kasugoan, tipigi ang akong mga balaod, ug tumana kini. Unya mopuyo kamo diha sa yuta nga malinawon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Magahatag ug abot ang yuta, ug mangabusog kamo sa pagkaon ug mopuyo nga malinawon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Moingon kamo, “Unsa man ang atong kaonon sa panahon sa ikapito nga tuig? Tan-awa, dili kita makatanom o makatigom sa atong abot.” ");
INSERT INTO cebulb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mandoan ko ang akong panalangin nga modangat kaninyo sulod sa unom ka tuig, ug magahatag kini ug igong abot alang sa tulo ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Makatanom kamo sa ikawalo nga tuig ug magpadayon sa pagkaon gikan sa abot sa nauna nga katuigan ug sa natigom nga pagkaon. Hangtod nga moabot ang pag-ani sa ikasiyam nga tuig, makakaon na kamo gikan sa panalangin nga natigom sa nilabay nga katuigan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Kinahanglan dili ibaligya ang yuta ngadto sa lain, tungod kay akoa ang yuta. Mga langyaw kamong tanan ug kasamtangang namuyo sa akong yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Kinahanglan nga mosubay kamo sa husto nga paglukat alang sa tanang yuta nga inyong naangkon; kinahanglan nga tugotan ninyo nga lukaton sa panimalay nga inyong gipalitan ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kung nahimong kabos ang inyong isigka-Israelita ug maoy hinungdan nga ibaligya niya ang pipila sa iyang kabtangan, unya ang labing duol niyang kadugo makahimo sa paglukat sa iyang kabtangan nga gibaligya kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kung walay paryente ang tawo nga makalukat sa iyang kabtangan, apan kung nagmauswagon na siya ug makahimo na sa paglukat niini, ");
INSERT INTO cebulb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","unya ihapon niya ang katuigan sukad nga nabaligya ang yuta ug bayaran niya ang kulang ngadto sa tawo nga iyang gibaligyaan niini. Unya iya kining mapanag-iya pagbalik. ");
INSERT INTO cebulb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Apan kung dili siya makahimo sa paglukat sa yuta alang kaniya, nan magpabilin ang pagpanag-iya sa yuta nga iyang gibaligya ngadto sa nakapalit niini hangtod nga moabot ang tuig sa Kagawasan ug Pag-uli. Sa tuig sa Kagawasan ug pag-uli, mahibalik ang yuta ngadto sa tawo nga nagbaligya niini, ug mahibalik ang kabtangan ngadto sa tinuod nga tag-iya. ");
INSERT INTO cebulb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kung mobaligya ang tawo sa balay nga anaa sa kinotaang siyudad, nan makahimo siya sa pagpalit niini pagbalik sulod sa usa ka tuig human kini mabaligya. Aduna siyay katungod sa paglukat niini sulod sa usa ka tuig. ");
INSERT INTO cebulb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kung dili malukat ang balay sulod sa usa ka tuig, nan ang balay nga anaa sa kinotaang siyudad mahimo nga mapanag-iya sa tawo nga nakapalit niini, hangtod sa mosunod niyang kaliwatan. Dili na mahibalik ang maong balay sa tuig sa Kagawasan ug Pag-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Apan ang mga balay diha sa mga baryo nga dili kinotaan isipon kini nga kaumahan sa maong dapit. Makahimo sila sa paglukat niini, ug kinahanglan ibalik kini panahon sa tuig sa Kagawasan ug Pag-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Bisan paman niana, ang mga Levita makahimo sa paglukat sa ilang gipanag-iya nga balay nga anaa sa ilang siyudad sa bisan kanus-a nga panahon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kung dili malukat sa usa ka Levita ang balay nga iyang gibaligya, nan ang balay nga gibaligya sa siyudad kung asa kini nahimutang kinahanglan ibalik sa tuig sa Kagawasan ug Pag-uli, kay sila ang nanag-iya sa mga balay sa mga siyudad sa mga Levita taliwala sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Apan ang kaumahan nga nakapalibot sa mga siyudad dili angay ibaligya tungod kay gipanag-iyahan kini sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Kung nahimong kabos ang inyong isigkatawo, busa dili na siya makabuhi sa iyang kaugalingon, busa kinahanglan tabangan ninyo siya sama nga nagtabang kamo sa langyaw o bisan kinsa nga nagpuyo uban kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ayaw pagpatubo o pagpaginansya gikan kaniya sa bisan unsang pamaagi, apan pasidunggi ang inyong Dios aron makapadayon sa pagkinabuhi ang inyong isigkatawo uban kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kinahanglan nga dili ninyo siya pahulamon ug salapi ug magpatubo ni baligyaan sa inyong pagkaon aron makaginansya. ");
INSERT INTO cebulb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ako si Yahweh ang inyong Dios, nga nagpagawas kaninyo gikan sa yuta sa Ehipto, aron nga mahatag ko kaninyo ang yuta sa Canaan, ug aron nga mahimo ninyo ako nga inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Kung nahimong kabos ang inyong isigkatawo ug ibaligya niya ang iyang kaugalingon nganha kaninyo, kinahanglan dili ninyo siya patrabahoon sama sa ulipon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Tagda siya ingon nga sinuholan nga sulugoon. Kinahanglan sama siya sa kasamtangang nagpuyo uban kaninyo. Moalagad siya kaninyo hangtod sa tuig sa Kagawasan ug Pag-uli. ");
INSERT INTO cebulb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Unya mohawa siya gikan kaninyo, uban ang iyang mga anak, ug mobalik siya sa iyang panimalay ug sa gipanag-iya sa iyang amahan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kay mga sulugoon ko sila nga gipagawas gikan sa yuta sa Ehipto. Dili sila ibaligya ingon nga mga ulipon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kinahanglan dili ninyo sila lisodlisoron, apan kinahanglan nga pasidunggan ninyo ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Alang sa inyong ulipon nga lalaki ug babaye, nga makuha ninyo gikan sa kanasoran nga nagpuyo libot kaninyo, makapalit kamo ug mga ulipon gikan kanila. ");
INSERT INTO cebulb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Makapalit usab kamo ug mga ulipon gikan sa mga langyaw nga nagpuyo uban kaninyo, nga gikan sa ilang mga pamilya nga uban kaninyo, ang mga anak nga natawo sa inyong yuta. Mahimo ninyo silang kabtangan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mahimo nga hatagan ninyo ang inyong mga anak ug mga ulipon ingon nga panulondon gikan kaninyo, nga maangkon ingon nga kabtangan. Makapalit kamo kanunay ug mga ulipon gikan kanila apan kinahanglan nga dili ninyo daogdaogon sa pagdumala ang inyong kaigsoonan taliwala sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kung nahimong dato ang usa ka langyaw o ang usa ka tawo nga kasamtangang nagpuyo uban kaninyo, ug kung nahimong kabos ang usa sa inyong isigka- Israelita ug ibaligya niya ang iyang kaugalingon ngadto sa maong langyaw, o ngadto sa panimalay sa langyaw, ");
INSERT INTO cebulb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","human nga mapalit ang inyong isigka-Israelita, mahimo siyang malukat. Makalukat kaniya si bisan kinsa diha sa iyang panimalay. ");
INSERT INTO cebulb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Mahimo nga ang iyang uyoan o ang anak nga lalaki sa iyang uyoan, ang molukat kaniya, o si bisan kinsa nga duol sa iyang banay nga gikan sa iyang panimalay. O, kung nagmauswagon na siya, makalukat siya sa iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Kinahanglan bayaran niya ang tawo nga nagpalit kaniya; kinahanglan ihapon nila ang katuigan gikan sa tuig nga nabaligya siya ngadto sa nagpalit hangtod sa tuig sa Kagawasan ug Pag-uli. Ang kantidad sa paglukat kaniya kinahanglan ipasikad sa pagbayad sa sinuholan nga sulugoon, alang sa gidaghanon sa katuigan mahimo nga mopadayon siya sa pagtrabaho ngadto sa nagpalit kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kung aduna pay daghan nga katuigan hangtod sa tuig sa Kagawasan ug Pag-uli, kinahanglan bayaran niya pagbalik ang samang kantidad sa paglukat ang kantidad sa salapi nga bahin niadtong mga katuigan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kung pipila na lamang ang katuigan ngadto sa tuig sa Kagawasan ug Pag-uli, nan kinahanglan nga bayaran niya ang nagpalit kaniya aron masayran ang nahibilin nga katuigan sa dili pa ang tuig sa Kagawasan ug Pag-uli, ug kinahanglan nga bayaran niya ang iyang paglukat sumala sa gidaghanon sa katuigan. ");
INSERT INTO cebulb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Pagatagdon siya sama sa sinuholan nga tawo matag tuig. Kinahanglan nga sigurohon ninyo nga dili siya daogdaogon. ");
INSERT INTO cebulb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kung dili siya malukat niining mga paagiha, nan kinahanglan nga moalagad siya hangtod sa tuig sa Kagawasan ug Pag-uli, siya ug ang iyang mga anak uban kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Alang kanako ang tanang katawhan sa Israel mga sulugoon. Mga sulugoon ko sila nga akong gipalingkawas sa yuta sa Ehipto. Ako si Yahweh ang inyong Dios.''' ");
INSERT INTO cebulb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Kinahanglan dili kamo maghimo ug diosdios, ni magkulit ug hulagway o sagrado nga haliging bato, ug kinahanglan dili kamo magbutang ug bisan unsa nga kinulit nga hulagway sa bato nga inyong pagaludhan diha sa inyong yuta, kay ako si Yahweh ang inyong Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kinahanglan tipigan ninyo ang akong Adlaw nga Igpapahulay ug pasidunggan ang akong balaang alampoanan. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Kung molakaw kamo sa akong mga balaod ug tipigan ang akong mga kasugoan ug tumanon kini, ");
INSERT INTO cebulb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","unya hatagan ko kamo ug ulan sa matag panahon; mohatag ug abot ang yuta, ug mamunga ug daghan ang mga kahoy sa kaumahan. ");
INSERT INTO cebulb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Magpadayon ang inyong paggiok hangtod sa panahon sa inyong pag-ani sa ubas, ug ang pag-ani sa ubas moabot pa kini hangtod sa panahon sa tingtanom. Makakaon kamo sa inyong tinapay hangtod nga mangabusog ug mopuyo nga malinawon kung asa kamo maghimo sa inyong pinuy-anan diha sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ihatag ko ang kalinaw diha sa yuta; mopahulay kamo nga walay kahadlok. Ipahilayo ko ang makuyaw nga mga mananap gikan sa yuta, ug ang espada dili moagi sa inyong yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Gukdon ninyo ang inyong mga kaaway, ug mapukan sila diha sa inyong atubangan pinaagi sa inyong mga espada. ");
INSERT INTO cebulb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Magagukod ang lima kaninyo ug gatosan, ug ang gatosan magagukod ug liboan; mapukan ang inyong mga kaaway sa inyong atubangan pinaagi sa espada. ");
INSERT INTO cebulb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Magatan-aw ako kaninyo uban sa kalooy ug himoon kamo nga mabungahon ug pasanayon kamo; ipahimutang ko ang akong kasabotan uban kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Magakaon kamo ug pagkaon nga gitipigan sulod sa taas nga panahon. Ipagawas ninyo ang natigom nga pagkaon tungod kay magkinahanglan kamo ug lawak alang sa bag-ong abot. ");
INSERT INTO cebulb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ibutang ko ang akong tabernakulo taliwala kaninyo, ug dili ko kamo pasagdan. ");
INSERT INTO cebulb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Molakaw ako taliwala kaninyo ug mahimong inyong Dios, ug mahimo kamong akong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ako si Yahweh ang inyong Dios, ang nagpalingkawas kaninyo gikan sa yuta sa Ehipto, aron dili na nila kamo mahimong mga ulipon. Gibungkag ko ang mga rehas sa inyong yugo ug gipalakaw kamo nga tul-id. ");
INSERT INTO cebulb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Apan kung dili kamo maminaw kanako, ug dili motuman sa tanan nga mga kasugoan, ");
INSERT INTO cebulb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ug kung isalikway ninyo ang akong mga kasugoan ug dili tagdon ang akong mga balaod, aron dili ninyo tumanon ang tanan kong mga kasugoan, apan mosupak sa akong kasabotan— ");
INSERT INTO cebulb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","—kung buhaton ninyo kining mga butanga, nan buhaton ko kini diha kaninyo: pagalisangon ko kamo, mga balatian ug hilanat nga modaot sa inyong mga mata ug mout-ot sa inyong kinabuhi. Magatanom kamo ug binhi sa walay kapuslanan, tungod kay pagakan-on sa inyong mga kaaway ang abot. ");
INSERT INTO cebulb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ipakita ko ang akong kasuko batok kaninyo, ug lupigon kamo sa inyong mga kaaway. Pagadumalahon kamo sa mga tawo nga nasilag kaninyo, ug managan kamo palayo, bisan pa ug walay naggukod kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Kung dili kamo maminaw sa akong mga kasugoan, nan silotan ko gayod kamo sa pito ka pilo tungod sa inyong mga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Gubaon ko ang inyong garbo sa inyong gahom. Himoon ko ang langit nga sama sa puthaw ug ang yuta sama sa bronse. ");
INSERT INTO cebulb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mahimong walay pulos ang inyong mga kusog, tungod kay dili na maghatag ug abot ang inyong yuta, ug dili na mamunga ang inyong mga kahoy diha sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kung maglakaw kamo batok kanako ug dili maminaw kanako, magpadala ako ug pito ka pilo nga silot nganha kaninyo, sumala sa inyong mga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Magpadala ako ug bangis nga mga mananap batok kaninyo, nga mokawat sa inyong mga anak, mokuniskunis sa inyong mga kahayopan, ug mahimong diyutay ang inyong gidaghanon. Busa mahimong awa-aw ang inyong mga kadalanan. ");
INSERT INTO cebulb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Bisan pa man niining mga butanga kung dili gihapon kamo modawat sa akong pagbadlong ug magpadayon sa pagkinabuhi batok kanako, ");
INSERT INTO cebulb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nan maglakaw usab ako batok kaninyo, ug silotan ko kamo sa pito ka pilo tungod sa inyong mga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Magpadala ako ug espada nganha kaninyo nga manimalos tungod sa pagsupak sa kasabotan. Magtigom kamong tanan sulod sa inyong mga siyudad, ug didto ipadala ko ang sakit taliwala kaninyo, unya mabihag kamo ngadto sa kamot sa inyong mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Sa dihang hunongon ko ang pagsangkap sa inyong pagkaon, magaluto ang napulo ka mga babaye sa inyong tinapay sa usa na lamang ka lutoanan, ug iapod-apod nila ang inyong tinapay pinaagi sa pagtimbang. Makakaon kamo apan dili mangabusog. ");
INSERT INTO cebulb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kung dili kamo maminaw kanako bisan pa niining mga butanga, apan magpadayon sa paglakaw batok kanako, ");
INSERT INTO cebulb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","unya maglakaw ako batok kaninyo diha sa kasuko, ug silotan ko kamo sa pito ka pilo sobra pa sa inyong mga sala. ");
INSERT INTO cebulb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kan-on ninyo ang unod sa inyong mga anak nga lalaki; kan-on ninyo ang unod sa inyong mga anak nga babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Gun-obon ko ang habog ninyo nga mga dapit, gubaon ko ang inyong mga halaran sa insenso, ug ilabay ang inyong patay nga lawas ngadto sa patay nga lawas sa inyong diosdios, ug isalikway ko kamo. ");
INSERT INTO cebulb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Gun-obon ko ang inyong mga siyudad ug gubaon ko ang inyong mga balaang alampoanan. Dili na ako mahimuot sa kahumot sa inyong mga halad. ");
INSERT INTO cebulb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Pagalaglagon ko ang yuta. Mahibulong ang inyong mga kaaway nga nagpuyo didto sa maong kalaglagan. ");
INSERT INTO cebulb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Pagakatagon ko kamo ngadto sa kanasoran, ug ipagawas ko ang akong espada ug pagasundan kamo. Mapasagdan ang inyong yuta, ug mangaguba ang inyong mga yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Unya magmalipayon ang yuta sa Adlaw nga Igpapahulay samtang gibiyaan kini ug anaa kamo sa kayutaan sa inyong mga kaaway. Nianang panahona, makapahulay ang yuta ug magmalipayon ang Adlaw nga Igpapahulay. ");
INSERT INTO cebulb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Samtang gibiyaan kini, makapahulay kini, pahulay nga wala mahitabo sa inyong Adlaw nga Igpapahulay, sa dihang nagpuyo pa kamo niini. ");
INSERT INTO cebulb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Alang niadtong nahibilin sa yuta sa inyong mga kaaway, magpadala ako ug kahadlok diha sa inyong kasingkasing aron bisan ang tingog sa dahon nga mapalid sa hangin makapakurat kaninyo, ug mokagiw kamo sama nga nagpalayo gikan sa espada. Mangatumba kamo, bisan walay naggukod kaninyo. ");
INSERT INTO cebulb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Magkadinasmagay kamo sa usag-usa ingon nga nanagan kamo palayo sa espada, bisan pa kung walay naggukod kaninyo. Wala na kamoy gahom nga moatubang sa inyong mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mangalaglag kamo taliwala sa mga kanasoran, ug lamyon kamo sa yuta sa inyong mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Kadtong nahibilin kaninyo mag-anam ug kapukan tungod sa ilang mga sala ngadto sa yuta sa inyong mga kaaway, ug tungod sa mga sala sa ilang mga amahan mangapukan usab sila. ");
INSERT INTO cebulb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Hinuon kung isugid nila ang ilang mga sala, ug ang sala sa ilang mga amahan, ug ang ilang pagbudhi pinaagi sa wala pagmatinud-anon kanako, ug naglakaw usab batok kanako— ");
INSERT INTO cebulb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","diin nahimong hinungdan nga mitalikod ako kanila ug gidala ko sila sa yuta sa ilang mga kaaway—kung magmapaubsanon ang gahi nilang kasingkasing, ug kung dawaton nila ang silot alang sa ilang mga sala, ");
INSERT INTO cebulb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nan hinumdoman ko ang akong kasabotan uban kang Jacob, ang akong kasabotan kang Isaac, ug ang akong kasabotan kang Abraham; hinumdoman ko usab ang yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mabiyaan nila ang yuta pinaagi niini, aron nga malipay kini sa Adlaw nga Igpapahulay samtang magpabilin kini nga biniyaan nga wala sila. Pagahukman sila sa ilang mga sala tungod kay gisalikway nila ang akong kasugoan ug wala tagda ang akong mga balaod. ");
INSERT INTO cebulb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Bisan pa niining tanan, sa dihang didto na sila sa yuta sa ilang mga kaaway, dili ko sila isalikway, ni dili ko sila kasilagan ingon nga laglagon sila sa hingpit ug dili ko ipalayo ang kasabotan diha kanila, kay ako si Yahweh nga ilang Dios. ");
INSERT INTO cebulb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Apan alang kanila hinumdoman ko ang akong kasabotan uban sa ilang katigulangan, nga akong gipalingkawas sa yuta sa Ehipto nga nasaksihan sa kanasoran, aron ako mahimong ilang Dios. Ako si Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Mao kini ang mga mando, mga kasugoan, ug mga balaod nga gihimo ni Yahweh taliwala sa iyang kaugalingon ug sa katawhan sa Israel didto sa Bukid sa Sinai pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Nakigsulti si Yahweh kang Moises ug miingon, ");
INSERT INTO cebulb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Pakigsulti sa katawhan sa Israel ug sultihi sila, 'Kung adunay usa ka tawo nga maghimo ug pinasahi nga pakigsaad ngadto kang Yahweh, ang mosunod ang gamiton nga mga kantidad sa angay ibugti. ");
INSERT INTO cebulb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ang kantidad nga inyong ibugti alang sa usa ka lalaki nga nagpangidaron ug 20 hangtod sa 60 anyos kinahanglan nga 50 ka shekel nga plata, sumala sa shekel sa balay alampoanan. ");
INSERT INTO cebulb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Alang sa usa ka babaye nga anaa sa samang pangidaron ang kantidad nga inyong ibugti kinahanglan 30 ka shekel. ");
INSERT INTO cebulb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Gikan sa lima ka tuig hangtod sa 20 ka tuig ang pangidaron ang kantidad nga angay ninyong ibugti alang sa usa ka lalaki 20 ka shekel, ug napulo ka shekel alang sa usa ka babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Gikan sa usa ka bulan hangtod sa lima ka tuig ang pangidaron kinahanglan lima ka shekel nga plata ang kantidad nga angay ninyong ibugti alang sa usa ka lalaki, ug tulo ka shekel nga plata alang sa usa ka babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Gikan sa nagpangidaron ug 60 ka tuig pataas kinahanglang 15 ka shekel ang kantidad nga angay ninyong ibugti alang sa usa ka lalaki, ug napulo ka shekel alang sa usa ka babaye. ");
INSERT INTO cebulb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Apan kung ang tawo nga naghimo sa pagpakigsaad dili makahimo sa pagbayad sa maong kantidad, nan ang maong tawo nga hingtungdan kinahanglan dad-on ngadto sa pari, ug ang pari maoy mokantidad nianang tawhana sumala sa kantidad nga makaya bayaran sa tawo nga naghimo sa pagpakigsaad. ");
INSERT INTO cebulb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Kung ang usa ka tawo buot mohalad ug usa ka mananap ngadto kang Yahweh, ug kung dawaton kini ni Yahweh, nan kana nga mananap igahin alang kaniya. ");
INSERT INTO cebulb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kinahanglan dili ilisdan o bayloan sa tawo ang maong mananap, ang maayo alang sa masakiton o ang masakiton alang sa maayo. Kung ilisdan gayod niya ang usa ka mananap sa lain, nan kining duha ka mananap mahimong balaan. ");
INSERT INTO cebulb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Bisan pa niana, kung ang gisaad sa tawo nga ihalad kang Yahweh maoy hugaw, mao nga dili kini dawaton ni Yahweh, nan kinahanglan nga dad-on sa maong tawo ang mananap ngadto sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ang pari mao ang mokantidad niini, sumala sa kantidad sa ginabaligya nga mananap sa merkado. Bisan pila ang ikantidad sa pari sa maong mananap, mao na kana ang kantidad niini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kung buot kining lukaton sa tag-iya, nan idugang ang ikalimang bahin sa kantidad sa paglukat niini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kung ang usa ka tawo mogahin sa iyang balay isip balaang gasa alang kang Yahweh, nan ang pari ang mohatag ug kantidad niini maayo man o dili. Bisan pila ang ikantidad sa pari niini, dili na kini mausab. ");
INSERT INTO cebulb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Apan kung buot kining lukaton sa tag-iya, kinahanglan idugang niya niini ang ikalimang bahin sa kantidad sa paglukat niini, ug mapanag-iya na niya kini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kung ang usa ka tawo mogahin sa pipila ka bahin sa iyang kaugalingong yuta, nan ang kantidad niini iangay sa gidaghanon sa binhi nga matanom niini—ang usa ka homer nga sebada nagkantidad ug 50 ka shekel nga plata. ");
INSERT INTO cebulb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kung igahin niya ang iyang uma atol sa tuig sa Kagawasan ug Pag-uli, magpabilin ang kantidad niini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Apan kung gigahin niya ang iyang uma human sa tuig sa Kagawasan ug Pag-uli, nan kinahanglan kwentahon sa pari ang kantidad sa uma sumala sa kadugayon hangtod sa sunod nga tuig sa Kagawasan ug Pag-uli, ug kinahanglan kunhoran ang kantidad niini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kung ang tawo nga migahin sa uma buot nga molukat niini, nan kinahanglan idugang niya ang ikalimang bahin sa kantidad sa paglukat niini, ug mapanag-iya na niya kini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kung dili na niya lukaton ang uma, o kung gibaligya na niya ang uma ngadto sa laing tawo, dili na gayod kini mahimong lukaton. ");
INSERT INTO cebulb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Hinuon, ang uma, kung mahatag na kini sa tuig sa Kagawasan ug Pag-uli, mahimo kining balaang gasa ngadto kang Yahweh, sama sa uma nga gihatag na sa hingpit kang Yahweh. Mapanag-iya na kini sa pari. ");
INSERT INTO cebulb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kung ang tawo mogahin sa usa ka uma nga iyang pinalit, apan ang maong uma dili kabahin sa kayutaan sa iyang kaliwat, ");
INSERT INTO cebulb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","nan ang pari maoy mohatag sa kantidad niini hangtod sa tuig sa Kagawasan ug Pag-uli, ug kinahanglan mobayad ang tawo sa maong kantidad nianang adlawa ingon nga usa ka balaan nga gasa ngadto kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Sa tuig sa Kagawasan ug Pag-uli, ang uma iuli ngadto sa tawo nga nagbaligya niini, sa tag-iya sa maong yuta. ");
INSERT INTO cebulb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ang tanang kantidad kinahanglan pinasikad sa timbangan sa shekel nga anaa sa balay alampoanan. Ang usa ka shekel kinahanglan katumbas sa 20 ka gerah. ");
INSERT INTO cebulb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Walay bisan usa nga mogahin sa panganay sa mga mananap, sanglit ang panganay iya man kang Yahweh; baka man o karnero, kay kang Yahweh kini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kung hugaw kini nga mananap, nan ang tag-iya sa mananap makahimo sa paglukat niini sa sumala sa gikantidan niini, ug kinahanglan idugang niini ang ikalimang bahin sa kantidad sa paglukat niini. Kung dili malukat ang mananap, nan ibaligya kini sumala sa gikantidad niini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Apan walay bisan unsa nga gihalad sa usa ka tawo kang Yahweh, gikan sa tanang anaa siya, mananap man o tawo, o ang yuta sa iyang kaliwat, ang mahimong ibaligya o lukaton. Ang tanan nga gihalad balaan kaayo alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Dili mahimo ang pagbayad aron paglukat sa usa ka tawo nga gitakda na nga malaglag. Kinahanglang patyon gayod ang maong tawo. ");
INSERT INTO cebulb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ang tanang ikapulo sa kayutaan, mga trigo man kini nga mitubo sa yuta o bunga gikan sa mga kahoy, iya na kini kang Yahweh. Balaan gayod kini alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kung lukaton sa tawo ang bisan unsa nga iyang ikapulo, kinahanglan idugang niya niini ang ikalimang bahin sa kantidad sa paglukat niini. ");
INSERT INTO cebulb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Samtang ang matag ikapulo sa panon sa mga baka o panon sa mga karnero, ang bisan unsa nga moagi sa ilalom sa sungkod sa magbalantay, ang matag ikapulo kinahanglan igahin alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ang magbalantay kinahanglan dili mosusi pa sa mas maayo o sa mas daot nga mga mananap, kinahanglan dili niya ilisdan ug lain. Kung ilisdan niya kini, nan ang duha ug ang giilis niini mahimong balaan. Dili na gayod kini malukat.”' ");
INSERT INTO cebulb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Mao kini ang mga kasugoan nga gihatag ni Yahweh ngadto kang Moises didto sa bukid sa Sinai alang sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Nakigsulti si Yahweh kang Moises didto sa tolda nga tagboanan sa kamingawan sa Sinai. Nahitabo kini sa unang adlaw sa ikaduhang bulan sa ikaduhang tuig human nakagawas ang katawhan sa Israel gikan sa yuta Ehipto. Miingon si Yahweh, ");
INSERT INTO cebulb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Paghimo ug talaan sa tanan nga mga kalalakin-an sa matag banay sa Israel, sa mga pamilya sa ilang katigulangan. Ihapa sila pinaagi sa ngalan. Ihapa ang matag-usa ka lalaki, ang matag tawo ");
INSERT INTO cebulb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","nga nagpanuigon ug 20 o pataas. Ihapa ang tanan nga makahimo sa pagpakig-away ingon nga mga sundalo alang sa Israel. Kinahanglan nga ikaw ug si Aaron maglista sa gidaghanon sa mga kalalakin-an sa ilang grupo sa kasundalohan. ");
INSERT INTO cebulb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ang tawo nga gikan sa matag tribo, ang ulo sa banay, kinahanglan moalagad kanimo ingon nga pangulo sa iyang tribo. Ang matag-usa ka pangulo kinahanglan mangulo sa mga kalalakin-an nga makig-away alang sa iyang tribo. ");
INSERT INTO cebulb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Mao kini ang mga ngalan sa mga pangulo nga kinahanglan makig-away uban kanimo: ");
INSERT INTO cebulb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","gikan sa tribo ni Ruben, Elizur ang anak nga lalaki ni Sedeur; gikan sa tribo ni Simeon, si Selumiel ang anak nga lalaki ni Zurisadai; ");
INSERT INTO cebulb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","gikan sa tribo ni Juda, si Nashon ang anak nga lalaki ni Aminadab; ");
INSERT INTO cebulb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","gikan sa tribo ni Isacar, si Nethanel ang anak nga lalaki ni Zuar; ");
INSERT INTO cebulb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","gikan sa tribo ni Zebulun, si Eliab ang anak nga lalaki ni Helon; ");
INSERT INTO cebulb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","gikan sa tribo ni Efraim ang anak nga lalaki ni Jose, si Elisama ang anak nga lalaki ni Amihud; gikan sa tribo ni Manases, si Gamaliel ang anak nga lalaki ni Pedazur; ");
INSERT INTO cebulb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","nga gikan sa tribo ni Benjamin ang anak nga lalaki ni Jose, si Abidan ang anak nga lalaki ni Gideoni; ");
INSERT INTO cebulb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","gikan sa tribo ni Dan, si Ahiezer ang anak nga lalaki ni Amisaddai; ");
INSERT INTO cebulb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","gikan sa tribo ni Asher, si Pagiel ang anak nga lalaki ni Ochran; ");
INSERT INTO cebulb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","gikan sa tribo ni Gad, si Eliasaf ang anak nga lalaki ni Deuel; ");
INSERT INTO cebulb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ug gikan sa tribo ni Naftali, si Ahira ang anak nga lalaki ni Enan.” ");
INSERT INTO cebulb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Mao kini ang mga kalalakin-an nga pinili gikan sa katawhan. Nangulo sila sa mga tribo sa ilang katigulangan. Sila mao ang mga pangulo sa mga banay sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Gidala ni Moises ug Aaron kining mga kalalakin-an, nga mga nalista pinaagi sa ngalan, ");
INSERT INTO cebulb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ug uban niining mga tawhana gitigom nila ang tanan nga mga kalalakin-an sa Israel sa unang adlaw sa ikaduhang bulan. Unya ang matag usa ka tawo nga nagpanuigon ug 20 ug pataas nagpahayag sa iyang kaliwat. Gipanganlan niya ang mga banay ug ang mga pamilya nga kagikan sa iyang mga katigulangan. ");
INSERT INTO cebulb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Unya gilista ni Moises ang ilang gidaghanon didto sa kamingawan sa Sinai, sumala sa gimando ni Yahweh kaniya nga iyang buhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Gikan sa mga kaliwat ni Ruben, ang kamagulangan ni Israel, giapil pag-ihap ang tanan nga mga ngalan sa matag-usa ug matag tawo nga nagpanuigon ug 20 o pataas nga makahimo sa pag-adto sa panggubatan, gikan sa listahan sa mga banay sa ilang mga katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Nakaihap sila ug 46, 500 ka mga kalalakin-an nga gikan sa tribo ni Ruben. ");
INSERT INTO cebulb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Gikan sa mga kaliwat ni Simeon giihap ang tanan nga ngalan sa matag-usa ug matag tawo nga nagpanuigon ug 20 o pataas nga makahimo sa pag-adto sa panggubatan, gikan sa listahan sa mga banay sa ilang mga katigulangan ug sa mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Nakaihap sila ug 59, 300 ka mga kalalakin-an nga gikan sa tribo ni Simeon. ");
INSERT INTO cebulb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gikan sa mga kaliwat ni Gad giihap ang tanan nga ngalan sa matag usa ug matag tawo nga nagpanuigon ug 20 o pataas nga makahimo sa pag-adto sa panggubatan, gikan sa listahan sa mga banay sa ilang katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Nakaihap sila ug 45, 650 ka kalalakin-an nga gikan sa tribo ni Gad. ");
INSERT INTO cebulb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Gikan sa mga kaliwat ni Juda giihap ang tanan nga mga ngalan sa matag usa ug sa matag tawo nga nagpanuigon ug 20 pataas nga makahimo sa pag-adto sa panggubatan, gikan sa listahan sa mga banay sa ilang katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Nakaihap sila ug 74, 600 ka mga kalalakin-an nga gikan sa tribo ni Juda. ");
INSERT INTO cebulb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Gikan sa mga kaliwat ni Isacar giihap ang tanan nga mga ngalan sa matag usa ug matag tawo nga nagpanuigon ug 20 o pataas nga makahimo sa pag-adto sa panggubatan, gikan sa listahan sa mga banay sa ilang katigulanga ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Nakaihap sila ug 54, 400 ka mga kalalakin-an nga gikan sa tribo ni Isacar. ");
INSERT INTO cebulb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Gikan sa mga kaliwat ni Zebulun naihap ang tanan nga mga ngalan sa matag usa ug ang matag tawo nga nagpangidaron ug 20 pataas nga makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang mga katigulangan ug pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Giihap nila ang 57, 400 ang mga kalalakin-an ang gikan sa tribo ni Zebulun. ");
INSERT INTO cebulb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Gikan sa mga kaliwat ni Efraim ang anak nga lalaki ni Jose naihap ang tanan nga mga ngalan sa matag usa ug sa matag tawo nga nagpangidaron ug 20 o pataas nga makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang mga katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Giihap nila ang 40, 500 ka mga kalalakin-an nga gikan sa tribo ni Efraim. ");
INSERT INTO cebulb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Gikan sa mga kaliwat ni Manases ang anak nga lalaki ni Jose naihap ang tanan nga mga ngalan sa matag usa ug sa matag tawo nga nagpangidaron ug 20 pataas ang makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang mga katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Giihap nila ang 32, 200 mga kalalakin-an nga gikan sa tribo ni Manases. ");
INSERT INTO cebulb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Gikan sa mga kaliwat ni Benjamin naihap ang tanan nga mga ngalan sa matag usa ug sa matag tawo nga nagpangidaron ug 20 pataas nga makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ilang giihap 35, 400 kalalakin-an ang gikan sa tribo ni Benjamin. ");
INSERT INTO cebulb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Gikan sa mga kaliwat ni Dan naihap ang tanan nga mga ngalan sa matag usa ug sa matag tawo nga nagpangidaron ug 20 pataas nga makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang mga katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ilang giihap 62, 700 ang gikan sa tribo ni Dan. ");
INSERT INTO cebulb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Gikan sa mga kaliwat ni Aser naihap ang tanan nga mga ngalan sa matag usa ug matag tawo nga nagpangidaron ug 20 pataas nga makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang mga katigulangan ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Giihap nila ang 41, 500 ang mga kalalakin-an ang gikan sa tribo ni Aser. ");
INSERT INTO cebulb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Gikan sa mga kaliwat ni Naftali naihap ang tanan nga mga ngalan sa matag usa ug matag tawo nga nagpangidaron ug 20 o pataas nga makahimo nga moadto sa gubat, gikan sa listahan sa banay sa ilang mga kaliwat ug mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Giihap nila ang 53, 400 ang gikan sa tribo ni Naftali. ");
INSERT INTO cebulb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Giihap ni Moises ug Aaron ang tanan nga mga kalalakin-an, apil ang napulog duha ka mga kalalakin-an nga mangulo sa napulog duha tribo sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Busa ang tanan nga mga kalalakin-an sa Israel nga gikan sa 20 pataas ang pangidaron, ang tanan nga makahimo sa pakig-away sa gubat, ang naihap sa ilang matag pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Giihap nila ang 603, 550 ka mga kalalakin-an. ");
INSERT INTO cebulb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Apan ang mga kalalakin-an nga gikan sa banay ni Levi wala giihap, ");
INSERT INTO cebulb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","tungod kay si Yahweh miingon kang Moises, ");
INSERT INTO cebulb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Kinahanglan nga dili nimo ihapon ang tribo ni Levi o iapil sa kinatibuk-ang kadaghanon nga katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Hinuon, gitahasan ang mga Levita sa pag-atiman sa kasabotan diha sa, ug sa pag-atiman sa tanan nga kasangkapan sa tabernakulo ug sa tanan nga butang nga anaa niini. Kinahanglan nga ang mga Levita maoy magdala sa tabernakulo, ug kinahanglan nga dad-on nila ang kasangkapan sa tabernakulo. Ug Kinahanglan nga atimanon nila ang tabernakulo ug magbuhat sila ug kampo palibot niini. ");
INSERT INTO cebulb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Sa dihang balhinon ang tabernakulo ngadto sa laing dapit, kinahanglan nga ang mga Levita maoy maghipos niini. Sa dihang ang tabernakulo pagatukoron, ang mga Levita maoy magtukod niini. Ug si bisan kinsa nga mga langyaw ang magpaduol sa tabernakulo kinahanglan nga pagapatyon. ");
INSERT INTO cebulb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Sa dihang ang katawhan sa Israel magtukod sa ilang mga tolda, kinahanglan nga ang matag tawo magbuhat duol sa bandira nga apil ngadto sa iyang kasundalohan. ");
INSERT INTO cebulb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Apan, ang mga Levita kinahanglan nga magtukod ug tolda palibot sa tabernakulo sa kasabotan aron nga akong kasuko dili moabot sa katawhan sa Israel. Kinahanglan nga ang mga Levita moatiman alang sa tabernakulo sa kasabotan.” ");
INSERT INTO cebulb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ang katawhan sa Israel magbuhat niining tanang mga butang. Gibuhat nila ang tanan nga gisugo ni Yahweh pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nakigsulti si Yahweh pag-usab kang Moises ug kang Aaron. Siya miingon, ");
INSERT INTO cebulb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ang matag usa ka Israelita kinahanglan nga magkampo palibot sa iyang sukod, uban sa bandira sa balay sa ilang mga amahan. Magkampo sila palibot sa tolda nga tagboanan sa matag pikas bahin. ");
INSERT INTO cebulb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kadtong nagkampo sa sidlakang bahin sa tolda nga tagboanan, kung asa mosubang ang adlaw, sila mao ang kampo ni Juda ug nagkampo sila ilalom sa ilang bandira. Si Nason ang anak nga lalaki ni Aminadab mao ang pangulo sa katawhan ni Juda. ");
INSERT INTO cebulb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ang gidaghanon sa katawhan ni Juda mga 74, 600. ");
INSERT INTO cebulb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ang tribo ni Isacar kinahanglan magkampo tapad kang Juda. Si Netanel ang anak nga lalaki ni Zuar kinahanglan mangulo sa kasundalohan ni Isacar. ");
INSERT INTO cebulb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ang gidaghanon sa iyang pundok mga 54, 400 ka mga kalalakin-an. ");
INSERT INTO cebulb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ang tribo ni Zebulun kinahanglan magkampo sunod kang Isacar. Si Eliab ang anak nga lalaki ni Helon kinahanglan mangulo sa sundalo ni Zebulun. ");
INSERT INTO cebulb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ang gidaghanon sa iyang kasundalohan 57, 400. ");
INSERT INTO cebulb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ang tanan nga gidaghanon sa kampo ni Juda 186, 400. Gipalakaw sila pag-una. ");
INSERT INTO cebulb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Sa habagatan nga bahin mao ang kampo ni Ruben ubos sa ilang sukod. Ang pangulo sa kampo ni Ruben mao si Elizur ang anak nga lalaki ni Shedeur. ");
INSERT INTO cebulb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ang gidaghanon sa iyang kasundalohan 46, 500. ");
INSERT INTO cebulb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Si Simeon nagkampo sunod kang Ruben. Ang pangulo sa katawhan ni Semeon mao si Shelumiel ang anak nga lalaki ni Zurishaddai. ");
INSERT INTO cebulb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Mao kadto ang gidaghanon sa iyang kasundalohan 59, 300. ");
INSERT INTO cebulb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Sunod ang tribo ni Gad. Ang pangulo sa katawhan sa Dios mao si Eliasaf ang anak nga lalaki ni Deuel. ");
INSERT INTO cebulb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ang gidaghanon sa iyang kasundalohan 45, 650. ");
INSERT INTO cebulb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Kadtong tanan nga ihap sa kampo ni Ruben, sumala sa panon sa ilang kasundalohan, 151, 450. Sila ang sunod nga molakaw. ");
INSERT INTO cebulb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sunod, ang tolda sa tagboanan kinahanglan nga igawas gikan sa kampo uban sa mga Levita sa tungatunga sa tanan nga kampo. Kinahanglan nga sila mogawas sa kampo sa sama nga paagi sa ilang pag-sulod sa kampo. Ang matag tawo kinahanglan anaa sa iyang dapit, sumala sa ilang bandira. ");
INSERT INTO cebulb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ang panon sa kasundalohan sa kampo ni Efraim ubos sa ilang pagmando. Ang pangulo sa katawhan ni Efraim mao si Elishama ang anak nga lalaki ni Amihud. ");
INSERT INTO cebulb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ang gidaghanon sa iyang kasundalohan 40, 500. ");
INSERT INTO cebulb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Sunod kanila mao ang tribo ni Manases. Ang pangulo ni ni Manases mao si Gamaliel ang anak nga lalaki ni Pedahzur. ");
INSERT INTO cebulb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ang gidaghanon sa iyang kasundalohan 32, 200. ");
INSERT INTO cebulb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Sunod mao ang tribo ni Benjamin. Ang pangulo ni Benjamin mao si Abidan ang anak nga lalaki ni Gideoni. ");
INSERT INTO cebulb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ang gidaghanon sa iyang kasundalohan 35, 400. ");
INSERT INTO cebulb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ang tanan nga ihap sa kampo ni Efraim 108100. Ikatulo nga molakaw. ");
INSERT INTO cebulb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Sa kasadpan mao ang panon sa kasundalohan ni Dan. Ang pangulo sa katawhan ni Dan mao sa Ahiezer ang anak nga lalaki ni Amishadai. ");
INSERT INTO cebulb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ang gidaghanon sa panon sa iyang kasundalohan 62, 700. ");
INSERT INTO cebulb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ang katawhan sa tribo ni Aser nagkampo sunod kang Dan. Ang pangulo ni Aser mao si Pagiel ang anak nga lalaki ni Ochran. ");
INSERT INTO cebulb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ang gidaghanon sa panon sa iyang kasundalohan 41, 500. ");
INSERT INTO cebulb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Sunod ang tribo ni Naftali. Ang pangulo ni Naftali mao si Ahira ang anak nga lalaki ni Enan. ");
INSERT INTO cebulb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ang gidaghanon sa panon sa iyang kasundalohan 53, 400. ");
INSERT INTO cebulb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Kadtong tanan nga gidaghanon sa kampo uban kang Dan 157, 600. Maulahi sila nga mogawas sa kampo, ubos sa ilang bandira.” ");
INSERT INTO cebulb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Mao kini ang gidaghanon sa mga Israelita, sumala sa ilang mga pamilya. Ang tanan nga apil sa ihap sa ilang kampo, pinaagi sa ilang panon sa ilang kasundalohan, mao kini 603, 550. ");
INSERT INTO cebulb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Apan wala giapil ni Moises ug Aaron ang mga Levita sa tanan nga katawhan sa Israel. Mao kini ang ang sugo ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ang katawhan sa Israel gibuhat ang tanan nga gisugo ni Yahweh kang Moises. Nagkampo sila sumala sa ilang mga bandira. Nanggawas sila gikan sa ilang mga kampo pinaagi sa ilang mga banay, sumala sa han-ay sa ilang katigulangan o mga pamilya. ");
INSERT INTO cebulb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Karon mao kini ang sugilanon sa mga kaliwat ni Aaron ug Moises sa dihang si Yahweh nakigsulti kang Moises didto sa Bukid sa Sinai. ");
INSERT INTO cebulb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ang mga ngalan sa mga anak ni Aaron mao si Nadab ang kamagulangan, si Abihu, si Eleazar ug si Itamar. ");
INSERT INTO cebulb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mao kini ang mga ngalan sa mga anak ni Aaron, ang mga pari nga gidihogan ug gipili aron mag-alagad ingon nga mga pari. ");
INSERT INTO cebulb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Apan si Nadab ug si Abihu natumba ug namatay sa atubangan ni Yahweh sa dihang naghalad sila kaniya ug wala niya kahimut-i nga kalayo didto sa kamingawan sa Sinai. Si Nadab ug si Abihu walay mga anak, busa si Eleazar ug si Itamar lamang ang nag-alagad ingon nga mga pari uban sa ilang amahan nga si Aaron. ");
INSERT INTO cebulb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Misulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Dad-a ang banay ni Levi ug ihatag sila ngadto kang Aaron nga pari aron motabang kaniya. ");
INSERT INTO cebulb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Kinahanglan nilang buhaton ang mga buluhaton alang kang Aaron ug sa tibuok nga katilingban didto sa tolda nga tagboanan. Kinahanglan mag-alagad sila sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Sila ang mag-atiman sa tanan nga mga kasangkapan sa tolda nga tagboanan, ug kinahanglan tabangan nila ang mga tribo sa Israel sa pagbuhat sa mga buluhaton sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Kinahanglang ihatag nimo ang mga Levita ngadto kang Aaron ug sa iyang mga anak. Tibuok silang gihatag aron motabang kaniya sa pag-alagad sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Pilia si Aaron ug ang iyang mga anak nga lalaki nga mamahimong mga pari, apan si bisan kinsang langyaw nga moduol kinahanglan nga pagapatyon.” ");
INSERT INTO cebulb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Misulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Tan-awa, gikuha ko ang mga Levita gikan sa katawhan sa Israel. Gihimo ko kini kaysa pagkuha sa mga kamagulangang lalaki nga nahimugso diha sa mga katawhan sa Israel. Akoa ang mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Akoa ang tanan nga mga kamagulangan. Sa adlaw nga giataki ko ang tanan nga kamagulangan sa yuta sa Ehipto, gigahin ko alang sa akong kaugalingon ang tanan nga kamagulangan sa Israel, mga tawo ug mga kahayopan. Akoa sila. Ako si Yahweh.” ");
INSERT INTO cebulb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Misulti si Yahweh kang Moises didto sa kamingawan sa Sinai. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Ihapa ang mga kaliwat ni Levi sa matag pamilya, sa mga panimalay sa ilang mga katigulangan. Ihapa ang matag lalaki nga nagpangidaron ug usa ka bulan ug pataas.” ");
INSERT INTO cebulb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Giihap sila ni Moises, subay sa pulong ni Yahweh, sumala sa gimando kaniya nga buhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ang mga ngalan sa mga anak nga lalaki ni Levi mao sila si Gerson, si Kohat ug si Merari. ");
INSERT INTO cebulb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ang mga banay nga naggikan sa mga anak nga lalaki ni Gerson mao sila Libni ug Simei. ");
INSERT INTO cebulb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ang banay nga naggikan sa mga anak nga lalaki ni Kohat mao sila si Amram, si Izar, si Hebron, ug si Uziel. ");
INSERT INTO cebulb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ang mga banay nga naggikan sa mga anak nga lalaki ni Merari mao si Mali ug si Musi. Mao kini ang mga banay sa mga Levita, nga nalista banay sa banay. ");
INSERT INTO cebulb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ang mga banay sa mga Libyanhon ug Simyanhon naggikan kang Gerson. Mao kini ang mga banay sa Gersohanon. ");
INSERT INTO cebulb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Giihap ang tanang mga lalaki nga gikan sa usa ka bulan ug pataas, miabot kini ug 7, 500. ");
INSERT INTO cebulb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ang mga banay sa Gersohanon kinahanglan nga magkampo sa kasadpang bahin sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Si Eliasaf nga anak nga lalaki ni Lael kinahanglang mangulo sa mga banay sa kaliwat sa Gersohanon. ");
INSERT INTO cebulb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ang pamilya ni Gerson mao ang mag-atiman sa tolda nga tagboanan lakip na sa tabernakulo. Kinahanglan atimanon nila ang tolda, ang tabon niini, ug ang tabil nga gigamit ingon nga ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Sila ang mag-atiman sa mga tabil sa hawanan, sa tabil sa ganghaan sa hawanan—ang hawanan nga nagpalibot sa dapit nga balaan ug sa halaran. Sila ang mag-atiman sa mga higot sa tolda nga tagboanan ug sa tanan nga anaa niini. ");
INSERT INTO cebulb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Mao kini ang mga banay nga naggikan kang Kohat: ang banay sa Amramihanon, ang banay sa Izarihanon, ang banay sa Hebronihanon, ug ang banay sa Uzielihanon. Kini nga mga banay sakop sa mga Kohatihanon. ");
INSERT INTO cebulb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","8, 600 ka mga lalaki ang naihap nga nagpangidaron ug usa ka bulan ug pataas aron mag-atiman sa mga butang nga iya kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ang mga pamilya sa mga kaliwat ni Kohat kinahanglan magkampo sa habagatang bahin sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Si Elisafan nga anak nga lalaki ni Uziel mao ang mangulo sa mga banay sa Kohatihanon. ");
INSERT INTO cebulb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Sila ang mag-atiman sa sudlanan sa kasabotan, sa lamisa, sa tungtonganan sa lampara, sa mga halaran, sa balaang mga butang nga galamiton sa ilang buluhaton, sa tabil, ug sa tanang buluhaton palibot niini. ");
INSERT INTO cebulb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Si Eleazar nga anak nga lalaki ni Aaron nga pari mao ang magdumala sa mga kalalakin-an nga nangulo sa mga Levita. Kinahanglang dumalahan niya ang mga kalalakin-an sa pag-atiman sa balaan nga dapit. ");
INSERT INTO cebulb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Duha ka banay ang naggikan kang Merari: ang banay sa Mahalihanon ug ang banay sa Musitihanon. Kini nga mga banay naggikan kang Merari. ");
INSERT INTO cebulb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","6, 200 ka mga lalaki ang naihap nga nagpangidaron ug usa ka bulan ug pataas. ");
INSERT INTO cebulb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Si Zuriel nga anak nga lalaki ni Abihail maoy mangulo sa mga banay ni Merari. Kinahanglan magkampo sila sa amihanang bahin sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ang mga kaliwat ni Merari mao ang mag-atiman sa gambalay sa tabernakulo, sa mga tukod, sa mga haligi, sa mga sukaranan ug sa tanang mga gamit niini, ug sa tanan nga may kalambigitan niini, lakip na ");
INSERT INTO cebulb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ang mga haligi ug patukoranan sa hawanan nga nakapalibot sa tabernakulo, lakip sa ilang mga ugsokanan, mga ugsok ug mga higot. ");
INSERT INTO cebulb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Si Moises ug si Aaron ug ang iyang mga anak nga lalaki kinahanglan magkampo sa sidlakang bahin sa tabernakulo, sa atubangan sa tolda nga tagboanan, nga nag-atubang sa sidlakan. Sila ang magdumala sa mga buluhaton sa dapit nga balaan ug sa mga buluhaton sa katawhan sa Israel. Si bisan kinsang langyaw nga moduol sa dapit nga balaan kinahanglan patyon. ");
INSERT INTO cebulb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Giihap ni Moises ug Aaron ang tanan nga mga kalalakin-an sa banay ni Levi nga nagpangidaron ug usa ka bulan ug pataas, ingon sa gisugo ni Yahweh. Nakaihap sila ug 22, 000 ka mga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Miingon si Yahweh kang Moises, “Ihapa ang tanan nga kamagulangang anak nga lalaki sa mga katawhan sa Israel nga nagpangidaron ug usa ka bulan ug pataas. Ilista ang ilang mga ngalan. ");
INSERT INTO cebulb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kinahanglan imong kuhaon ang mga Levita alang kanako kaysa sa tanan nga mga kamagulangang anak sa katawhan sa Israel. Ako si Yahweh. Ug kuhaa usab ang mga kahayopan sa mga Levita isip puli sa tanang unang mga anak sa kahayopan sa mga kaliwat sa Israel.” ");
INSERT INTO cebulb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Giihap ni Moises ang tanan nga kamagulangang tawo sa Israel sumala sa gisugo ni Yahweh nga iyang pagabuhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Giihap niya ang tanan nga mga kamagulangang lalaki sa ngalan, nga nagpangidaron ug usa ka bulan ug pataas. Nakaihap siya ug 22, 273 ka mga lalaki. ");
INSERT INTO cebulb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Misulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Kuhaa ang mga Levita imbis ang tanang kamagulangang anak sa katawhan sa Israel. Ug kuhaa ang mga kahayopan sa mga Levita imbis ang kahayopan sa katawhan. Akoa ang mga Levita. Ako si Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kinahanglan magkuha ka ug lima ka sekels alang sa paglukat sa 273 ka kamagulangan sa Israel nga misobra sa gidaghanon sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Gamita ang sekels sa dapit nga balaan ingon nga sumbanan sa kabug-aton. Ang sekels sama lang sa 20 ka geras. ");
INSERT INTO cebulb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Kinahanglan nga ihatag nimo ang kantidad sa lukat nga imong gibayad ngadto kang Aaron ug sa iyang mga anak nga lalaki.” ");
INSERT INTO cebulb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Busa gikuha ni Moises ang bayad sa lukat gikan niadtong mga misobra sa gidaghanon sa nalukat sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Gikuha ni Moises ang salapi gikan sa mga kamagulangan sa katawhan sa Israel. Mikabat kini ug 1, 365 ka sekels, gamit ang timbangan sa sekels sa dapit nga balaan. ");
INSERT INTO cebulb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Gihatag ni Moises ang salapi sa lukat ngadto kang Aaron ug sa iyang mga anak nga lalaki. Gibuhat ni Moises ang tanan nga giingon kaniya pinaagi sa pulong ni Yahweh, ingon sa gisugo ni Yahweh kaniya. ");
INSERT INTO cebulb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Nakigsulti si Yahweh kang Moises ug kang Aaron. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Pagbuhat ug talaan sa mga lalaki sa kaliwat ni Kohat gikan sa mga Levita, pinaagi sa ilang mga banay ug mga pamilya sa ilang mga katigulangan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ihapa ang tanan nga mga kalalakin-an nga anaa sa 30 hangtod sa 50 anyos ang pangidaron. Kini nga mga lalaki kinahanglan nga moapil sa pundok aron moalagad didto sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ang mga kaliwat ni Kohat mao ang mag-atiman sa labing balaang mga butang nga gigahin alang kanako didto sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Sa dihang ang kampo mangandam sa pagbalhin, si Aaron ug ang iyang mga anak nga lalaki kinahanglan mosulod sa tolda, mopaubos sa tabil nga nagbulag sa labing balaang dapit gikan sa balaang dapit ug itabon kini sa sudlanan sa kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Kinahanglan nga tabonan nila ang sudlanan sa kasabotan ug panit sa dugong. Maghapin sila ug asul nga panapton sa ibabaw niini. Kinahanglan nga ilang isuksok ang mga tukon aron sa pag-alsa niini. ");
INSERT INTO cebulb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Kinahanglan nga ihapin nila ang asul nga panapton ibabaw sa lamisa sa tinapay sa presensiya. Ibutang nila niini ang mga plato, mga kutsara, mga panaksan, ug mga tibod alang sa pagbubo. Ang tinapay kinahanglan anaa kanunay sa lamisa. ");
INSERT INTO cebulb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Kinahanglan nga tabonan nila kini sa pula nga panapton ug usab sa panit sa dugong. Kinahanglan ilang isuksok ang mga tukon aron sa pag-alsa sa lamisa. ");
INSERT INTO cebulb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Kinahanglan magkuha sila ug asul nga panapton ug tabonan ang tungtonganan sa lampara, uban sa mga lampara niini, mga kimpit, mga butanganan, ug tanang tibod sa lana alang sa mga lampara. ");
INSERT INTO cebulb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kinahanglan nga tabonan nila ang tungtonganan sa lampara ug ang tanang kasangkapan sa panit sa dugong, ug ila kining ibutang sa dayonganan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Maghapin sila ug panapton nga asul sa bulawan nga halaran. Tabonan nila kini ug panit sa dugong, ug unya isuksok ang dayonganan nga tukon. ");
INSERT INTO cebulb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Kuhaon nila ang tanan nga galamiton alang sa buluhaton sa balaang dapit ug putoson kini sa asul nga panapton. Tabonan nila kini ug panit sa dugong ug ibutang ang mga galamiton ngadto sa dayonganan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kinahanglan kuhaon nila ang abo gikan sa halaran ug hapinan nila ang halaran ug panapton nga tapol. ");
INSERT INTO cebulb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kinahanglan nga ibutang nila didto sa dayonganan ang tanan nga mga galamiton nga ilang gigamit sa buluhaton sa halaran. Kini nga mga butang mao ang mga kawa, mga tinidor, mga pala, mga panaksan, ug ang uban pang mga galamiton sa halaran. Kinahanglan tabonan nila ang halaran ug panit sa dugong ug unya isuksok ang mga tukon nga dayonganan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Sa dihang nahuman na ni Aaron ug sa iyang mga anak nga lalaki ang pagtabon sa balaang dapit ug sa tanang galamiton niini, ug sa dihang ang kampo ibalhin na, kinahanglan nga alsahon na sa mga kaliwat ni Kohat ang balaang dapit. Kung makahikap sila sa balaang mga gamit, mamatay gayod sila. Mao kini ang buluhaton sa mga kaliwat ni Kohat, ang pagdala sa mga kasangkapan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Si Eleazar nga anak nga lalaki ni Aaron ang pari maoy magbantay sa pag-atiman sa lana alang sa suga, sa mahumot nga insenso, sa halad nga trigo, ug sa lana nga pangdihog. Siya ang magbantay sa pag-atiman sa tibuok tabernakulo ug sa tanan nga anaa niini, sa balaang dapit ug sa mga galamiton niini.” ");
INSERT INTO cebulb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Nakigsulti si Yahweh kang Moises ug kang Aaron. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ayaw tugoti nga ang banay sa mga Kohatihanon mahibulag gikan sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Panalipdi sila, aron mabuhi sila ug dili mamatay, pinaagi sa pagbuhat niini. Kung moduol sila sa labing balaang mga butang ");
INSERT INTO cebulb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","kinahanglan dili sila mosulod aron motan-aw sa balaang dapit bisan sa makadiyot, o mamatay gayod sila. Si Aaron ug ang iyang mga anak nga lalaki lamang ang mosulod, ug unya kinahanglan tahasan ni Aaron ug sa iyang mga anak nga lalaki ang matag-usa ka mga Kohatihanon sa iyang buluhaton, ngadto sa iyang pinasahi nga buluhaton.” ");
INSERT INTO cebulb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Misulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Pagbuhat usab ug talaan alang sa mga kaliwat ni Gerson, sa pamilya sa ilang mga katigulangan, ug sa ilang mga banay. ");
INSERT INTO cebulb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ihapa kadtong anaa sa 30 hangtod sa 50 anyos ang pangidaron. Ihapa silang tanan nga moapil sa pundok aron moalagad sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Mao kini ang buluhaton sa mga banay sa Gersohanon, sa dihang mag-alagad sila ug kung unsa ang ilang dad-on. ");
INSERT INTO cebulb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Dad-on nila ang mga tabil sa tabernakulo, ang tolda nga tagboanan, ang tabon niini, ang tabon nga panit sa dugong nga anaa niini, ug ang mga tabil sa ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Kinahanglan dad-on nila ang mga tabil sa hawanan, ang tabil sa agianan sa ganghaan sa hawanan, nga anaa duol sa tabernakulo, ug duol sa halaran, ang ilang mga higot, ug ang tanang mga gamit alang sa ilang buluhaton. Bisan unsa ang gikinahanglan nga buhaton niini nga mga butang, kinahanglan nga ilang buhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Si Aaron ug ang iyang mga anak nga lalaki kinahanglan nga mangulo sa tanan nga buluhaton sa mga Gersohanon, sa bisan unsa nga ilang pagadad-on, ug sa tanan nilang buluhaton. Kinahanglan nga imo silang tahasan sa tanan nilang mga katungdanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Mao kini ang buluhaton sa mga banay sa mga kaliwat sa Gersohanon alang sa tolda nga tagboanan. Si Itamar nga anak nga lalaki ni Aaron ang pari mao ang mangulo kanila sa ilang buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ihapa ang mga kaliwat ni Merari diha sa ilang mga banay, ug ihan-ay sila sumala sa pamilya sa ilang mga katigulangan, ");
INSERT INTO cebulb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","gikan sa 30 anyos ug pataas hangtod sa 50 anyos ang pangidaron. Ihapa ang tanan nga moapil sa pundok ug moalagad didto sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Mao kini ang ilang katungdanan ug ang ilang buluhaton sa tanan nila nga pag-alagad sa tolda nga tagboanan. Sila ang mag-atiman sa gambalay sa tabernakulo, sa mga tukod, sa mga haligi, ug mga ugsokanan, ");
INSERT INTO cebulb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","uban sa mga haligi sa hawanan palibot sa tabernakulo, sa ilang mga ugsokanan, sa mga ugsok, ug sa ilang mga higot, uban sa tanan nilang mga butang. Ilista pinaagi sa ngalan ang kinahanglan nilang dad-on. ");
INSERT INTO cebulb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Mao kini ang buluhaton sa mga banay sa mga kaliwat ni Merari, kung unsa ang ilang pagabuhaton alang sa tolda nga tagboanan, ubos sa pagmando ni Itamar nga anak nga lalaki ni Aaron ang pari.” ");
INSERT INTO cebulb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Giihap ni Moises ug ni Aaron ug sa mga pangulo sa katilingban ang mga kaliwat sa mga Kohatihanon sumala sa mga banay sa mga pamilya sa ilang katigulangan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Giihap nila ang nagpangidaron ug gikan sa 30 anyos ug pataas hangtod sa 50 anyos. Giihap nila ang tanan nga moapil sa pundok aron moalagad sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Nakaihap sila ug 2, 750 ka mga kalalakin-an sumala sa ilang mga banay. ");
INSERT INTO cebulb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Giihap ni Moises ug ni Aaron ang tanan nga kalalakin-an sa mga banay ug sa mga pamilya sa Kohatihanon nga moalagad sa tolda nga tagboanan. Sa pagbuhat niini, gituman nila kung unsa ang gimando ni Yahweh nga ilang buhaton pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ang mga kaliwat ni Gerson giihap sumala sa ilang mga banay, sa mga pamilya sa ilang katigulangan, ");
INSERT INTO cebulb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","nga nagpangidaron ug gikan sa 30 hangtod sa 50 anyos, ang tanan nga moapil sa pundok aron moalagad sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Ang tanan nga mga kalalakin-an, giihap sumala sa ilang mga banay ug sa mga pamilya sa ilang katigulangan, ug mikabat kini ug 2, 630. ");
INSERT INTO cebulb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Giihap ni Moises ug ni Aaron ang mga kaliwat ni Gerson nga moalagad sa tolda nga tagboanan. Sa pagbuhat niini, gituman nila kung unsa ang gimando ni Yahweh nga ilang buhaton pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ang mga kaliwat ni Merari giihap sa ilang mga banay sumala sa mga pamilya sa ilang katigulangan, ");
INSERT INTO cebulb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","gikan sa 30 hangtod sa 50 anyos ang pangidaron, ang tanan nga moapil sa pundok aron moalagad sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Ang tanan nga mga kalalakin-an, giihap sumala sa ilang mga banay ug sa mga pamilya sa ilang katigulangan, ug mikabat ug 3, 200. ");
INSERT INTO cebulb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Giihap ni Moises ug ni Aaron kining tanan nga mga kalalakin-an, sa mga kaliwat ni Merari. Sa pagbuhat niini, gituman nila kung unsa ang gimando ni Yahweh nga ilang buhaton pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Busa giihap ni Moises ug ni Aaron ug sa tanan nga mga pangulo sa Israel ang tanan nga mga Levita sumala sa ilang mga banay sa mga pamilya sa ilang katigulangan ");
INSERT INTO cebulb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","gikan sa 30 hangtod sa 50 anyos ang pangidaron. Giihap nila ang tanan nga mobuhat sa mga buluhaton sa tabernakulo, ug ang modala ug moatiman sa mga butang sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Nakaihap sila ug 8, 580 ka mga kalalakin-an. ");
INSERT INTO cebulb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Sa mando ni Yahweh, giihap ni Moises ang matag tawo, giihap ang matag usa sumala sa matang sa buluhaton nga gitahas kaniya. Giihap niya ang matag tawo sumala sa matang sa katungdanan nga iyang pagabuhaton. Sa pagbuhat niini, gituman nila kung unsa ang gimando ni Yahweh kanila nga ilang buhaton pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nakigsulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Mandoi ang katawhan sa Israel nga ipagawas gikan sa kampo ang tanan nga adunay sakit sa panit nga makatakod, ug ang tanan nga adunay mga nagnana nga samad, ug si bisan kinsa nga nahugaw tungod sa paghikap sa patay nga lawas. ");
INSERT INTO cebulb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Lalaki man o babaye, kinahanglan nga pagawason ninyo sila sa kampo. Kinahanglan nga dili nila hugawan ang kampo, tungod kay nagpuyo ako dinhi.” ");
INSERT INTO cebulb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Gibuhat kini sa katawhan sa Israel. Gipagawas nila sila sa kampo, sumala sa gimando ni Yahweh kang Moises. Mituman kang Yahweh ang katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Misulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Sultihi ang katawhan sa Israel. Kung ang usa ka lalaki o babaye nakabuhat sa bisan unsang sala ingon sa ginabuhat sa mga tawo sa usag-usa, ug dili matinud-anon kanako, sad-an kanang tawhana. ");
INSERT INTO cebulb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Unya kinahanglan isugid niya ang sala nga iyang nabuhat. Kinahanglan gayod niyang bayaran ang kantidad sa iyang sala ug dugangan pa kini ug 20 porsiyento. Kinahanglan ihatag niya kini ngadto sa tawo nga iyang nasad-an. ");
INSERT INTO cebulb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Apan kung ang tawo nga nasad-an walay suod nga paryente nga modawat sa bayad, kinahanglan bayran niya ang kantidad sa iyang sala nganhi kanako pinaagi sa pari, uban sa laking karnero aron sa kapasayloan sa iyang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ang matag halad sa katawhan sa Israel, ang mga butang nga gigahin ug gidala sa katawhan sa Israel ngadto sa pari, mamaiya na. ");
INSERT INTO cebulb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ang mga halad sa matag tawo mamaiya sa pari; kung adunay mohatag ug bisan unsa ngadto sa pari, mamaiya na kini.” ");
INSERT INTO cebulb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Misulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Sultihi ang katawhan sa Israel. Ingna sila, 'Pananglitan ang asawa sa usa ka lalaki mobiya ug magpakasala batok sa iyang bana. ");
INSERT INTO cebulb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Unya pananglitan adunay laing lalaki nga makigdulog kaniya. Sa ingon niana, hugaw na siya. Bisan kung ang iyang bana wala makakita o makahibalo niini, ug bisan kung walay nakasakop kaniya sa akto ug walay makapamatuod batok kaniya, ");
INSERT INTO cebulb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","bisan pa niana, ang espiritu sa pagpangabugho magpahibalo gihapon sa bana nga ang iyang asawa hugaw na. Apan, ang espiritu sa pagpangabugho moabot sa usa ka lalaki bisan ang iyang asawa wala nagmahugaw. ");
INSERT INTO cebulb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Sa ingon niana, kinahanglan dad-on sa lalaki ang iyang asawa ngadto sa pari. Kinahanglan magdala ang bana ug mainom nga halad alang kaniya. Kinahanglan magdala siya ug ikanapulo nga bahin sa ephah sa sebada nga harina. Kinahanglan dili niya kini buboan ug lana o insenso tungod kay usa kini ka halad nga trigo sa pagpangabugho, usa ka halad nga trigo nga mahimong makapamatuod sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kinahanglan ipaduol sa pari ang babaye ug ibutang siya sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kinahanglan nga magkuha ang pari ug tibod sa balaang tubig ug magkuha ug abog gikan sa salog sa tabernakulo. Kinahanglan ibutang niya ang abog ngadto sa tubig. ");
INSERT INTO cebulb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ipahiluna sa pari ang babaye sa atubangan ni Yahweh ug iyang tangtangon ang tali sa buhok sa babaye. Ibutang niya sa mga kamot sa babaye ang halad nga trigo sa paghandom, nga mao ang halad nga trigo sa pangabugho. Gunitan sa pari ang pait nga tubig nga magdala ug tunglo. ");
INSERT INTO cebulb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Papanumpaon sa pari ang babaye ug moingon kaniya, “Kung walay laing lalaki nga nakighilawas kanimo, ug kung wala ka nahisalaag ug nagbuhat sa kahugawan, mamahimo kang gawasnon niining pait nga tubig nga magdala ug tunglo. ");
INSERT INTO cebulb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Apan kung ikaw, usa ka babaye nga anaa ubos sa iyang bana, nahisalaag, kung nagpakahugaw ka, ug kung ang laing lalaki nakigdulog kanimo, ");
INSERT INTO cebulb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","unya, (papanumpaon sa pari ang babaye sa panumpa nga magdala ug tunglo ngadto kaniya, ug unya kinahanglan magpadayon siya sa pakigsulti sa babaye) 'Si Yahweh motunglo kanimo aron nga maipakita gayod sa imong katawhan. Mahitabo gayod kini kung himoon ni Yahweh nga mawad-an ug kapuslanan ang imong paa ug mohubag ang imong pus-on. ");
INSERT INTO cebulb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Kini nga tubig nga magdala ug tunglo mosulod sa imong tiyan ug mohubag ang imong pus-on ug mawad-an ug kapuslanan ang imong mga paa.' Ang babaye motubag, 'Oo, mahitabo kana kung sad-an ako.' ");
INSERT INTO cebulb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Kinahanglan nga isulat sa pari kini nga mga tunglo sa linukot nga basahon, ug unya hugasan niya ang sinulat nga mga tunglo sa pait nga tubig. ");
INSERT INTO cebulb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Kinahanglan nga paimnon sa pari ang babaye sa pait nga tubig nga nagdala ug tunglo. Ang tubig nga nagdala ug tunglo mosulod sa babaye ug mahimong pait. ");
INSERT INTO cebulb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kinahanglan kuhaon sa pari ang halad nga trigo sa pangabugho gikan sa kamot sa babaye. Kinahanglan ipataas niya ang halad nga trigo sa atubangan ni Yahweh ug dad-on kini sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kinahanglan magkuha ang pari ug usa ka kumkom sa halad nga trigo ingon nga usa ka halad handomanan, ug sunugon kini sa halaran. Unya ihatag niya sa babaye ang pait nga tubig aron imnon. ");
INSERT INTO cebulb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Sa dihang ihatag na niya sa babaye ang tubig aron imnon, kung ang babaye hugaw tungod kay nakabuhat siya ug sala batok sa iyang bana, unya ang tubig nga magdala ug tunglo mosulod kaniya ug mahimong pait. Mohubag ang pus-on sa babaye ug dili na mapuslan ang iyang paa. Matinunglo ang babaye taliwala sa iyang katawhan. ");
INSERT INTO cebulb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Apan kung ang babaye dili hugaw ug kung siya hinlo, kinahanglan mahimo siyang gawasnon. Makabaton pa siya ug mga anak. ");
INSERT INTO cebulb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Mao kini ang balaod sa pagpangabugho. Balaod kini alang sa usa ka babaye nga mibiya sa iyang bana ug nagmahugaw. ");
INSERT INTO cebulb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Mao kini ang balaod alang sa usa ka lalaki nga adunay espiritu sa pagpangabugho kung mangabugho siya sa iyang asawa. Kinahanglan dad-on niya ang babaye sa atubangan ni Yahweh, ug kinahanglan buhaton sa pari diha kaniya ang tanan nga gihulagway niining balaod sa pagpangabugho. ");
INSERT INTO cebulb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ang lalaki mamahimong gawasnon gikan sa sala tungod sa pagdala sa iyang asawa ngadto sa pari. Kinahanglan antoson sa babaye ang bisan unsang sala nga iyang nabuhat.” ");
INSERT INTO cebulb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nakigsulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Sultihi ang katawhan sa Israel. Isulti kanila, 'Sa dihang igahin sa lalaki ug babaye ang iyang kaugalingon ngadto kang Yahweh uban sa pinasahi nga panumpa sa Nasareo, ");
INSERT INTO cebulb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kinahanglan nga ilikay niya ang iyang kaugalingon gikan sa bino ug sa isog nga ilimnon. Dili siya moinom sa suka nga hinimo gikan sa bino o gikan sa isog nga ilimnon. Kinahanglan nga dili siya moinom sa bisan unsang duga sa ubas o mokaon sa ubas o sa mga pasas. ");
INSERT INTO cebulb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Sa tanang mga adlaw nga gipahilayo siya alang kanako, kinahanglan nga wala siyay kaonon nga hinimo gikan sa mga ubas, lakip ang tanan nga hinimo gikan sa mga liso ug mga panit niini. ");
INSERT INTO cebulb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Sulod sa tibuok panahon sa iyang panumpa sa pagkahilayo, walay labaha nga gamiton sa iyang ulo hangtod sa mga adlaw nga ang iyang pagkahilayo alang kang Yahweh natuman. Kinahanglan nga igahin siya kang Yahweh. Kinahanglan nga pasagdan niya nga motaas ang buhok sa iyang ulo. ");
INSERT INTO cebulb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Sa tibuok panahon nga iyang ipahilayo ang iyang kaugalingon alang kang Yahweh, kinahanglan nga dili siya moduol sa patay nga lawas. ");
INSERT INTO cebulb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Kinahanglan dili niya hugawan ang iyang kaugalingon bisan alang sa iyang amahan, inahan, igsoong lalaki, o igsoong babaye, kung sila mamatay. Kini tungod kay gipahilayo man siya alang sa Dios, sumala sa makita sa tanan pinaagi sa iyang taas nga buhok. ");
INSERT INTO cebulb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Sa tibuok panahon sa iyang pagkahilayo balaan siya, gigahin alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kung adunay tawo nga mamatay ug kalit sa iyang tapad ug maghugaw sa iyang ulo nga gibalaan, unya kinahanglan niyang kiskisan ang iyang ulo sa adlaw sa iyang pagputli—sa ikapito nga adlaw kinahanglan nga kiskisan niya kini. ");
INSERT INTO cebulb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sa ikawalo nga adlaw kinahanglan magdala siya ug duha ka salampati o duha ka pispis nga mga goryon ngadto sa pari sa ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kinahanglan maghalad ang pari ug usa ka langgam ingon nga halad tungod sa sala ug ang uban ingon nga halad sinunog. Tungod niini mapasaylo siya tungod kay nakasala siya pinaagi sa pagduol sa patay nga lawas. Kinahanglan nga iyang balaanon pag-usab ang iyang ulo nianang adlawa. ");
INSERT INTO cebulb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Kinahanglan igahin niya ang iyang kaugalingon ngadto kang Yahweh alang sa mga adlaw sa iyang pagbalaan. Kinahanglan magdala siya ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sa sala. Dili niya ilakip ang mga adlaw sa wala pa niya mahugawan ang iyang kaugalingon, tungod kay ang iyang pagbalaan nahugawan na man. ");
INSERT INTO cebulb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Mao kini ang balaod mahitungod sa Nasareo sa dihang mahingpit na ang takna sa iyang pagkahilayo. Kinahanglan dad-on siya ngadto sa ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Kinahanglan itugyan niya ang iyang halad ngadto kang Yahweh. Kinahanglan ihalad niya ingon nga halad sinunog ang usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ug walay tatsa. Kinahanglan magdala siya ug bayeng karnero nga nati nga usa ka tuig ang kagulangon ug walay tatsa ingon nga halad sa sala. Kinahanglan magdala siya ug torong karnero nga walay tatsa ingon nga halad sa pakigdait. ");
INSERT INTO cebulb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Kinahanglan nga magdala usab siya ug usa ka basket sa tinapay nga walay igpapatubo, tinapay nga hinimo gikan sa lunlon nga harina nga gisagolan ug lana, ostiyas nga walay igpapatubo nga gipahiran ug lana, lakip ang ilang halad nga trigo ug mga halad nga ilimnon. ");
INSERT INTO cebulb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kinahanglan itugyan kini sa pari sa atubangan ni Yahweh. Kinahanglan ihalad niya ang iyang halad sa sala ug ang halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Uban ang basket sa tinapay nga walay igpapatubo, itugyan niya ang torong karnero ingon nga sakripisyo, ang halad sa pakigdait alang kang Yahweh. Kinahanglan itugyan usab sa pari ang halad nga trigo ug ang halad nga ilimnon. ");
INSERT INTO cebulb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Kinahanglan kiskisan sa Nasareo ang iyang ulo timailhan sa iyang pagkahilayo alang sa Dios diha sa ganghaan sa tolda nga tagboanan. Kinahanglan kuhaon niya ang buhok gikan sa iyang ulo ug ibutang kini sa kalayo nga anaa ilalom sa sakripisyo nga halad sa pakigdait. ");
INSERT INTO cebulb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Kinahanglan kuhaon sa pari ang nalutong abaga sa torong karnero, usa ka tinapay nga walay igpapatubo gikan sa basket, ug usa ka ostiyas nga walay igpapatubo. Ibutang niya kini ngadto sa mga kamot sa Nasareo human niya makiskisan ang iyang ulo nga timailhan sa pagkahilayo. ");
INSERT INTO cebulb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kinahanglan nga ibayaw kini sa pari ingon nga halad ngadto kang Yahweh, ang balaang bahin alang sa pari, lakip ang dughan nga gibayaw ug ang paa nga gihatag alang sa pari. Human niana, makainom na ug bino ang Nasareo. ");
INSERT INTO cebulb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Mao kini ang balaod alang sa Nasareo nga nanumpa sa iyang halad ngadto kang Yahweh alang sa iyang pagkahilayo. Bisan unsa pa man ang iyang maihatag, kinahanglan niyang tumanon ang mga katungdanan sa panumpa nga iyang gihimo, aron sa pagtuman sa saad nga gipakita sa balaod alang sa pagka-Nasareo.'” ");
INSERT INTO cebulb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nagsulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Sultihi si Aaron ug ang iyang mga anak nga lalaki. Isulti nga, “Kinahanglan panalanginan ninyo ang katawhan sa Israel sa ingon niini nga pamaagi. Kinahanglan isulti ninyo kanila, ");
INSERT INTO cebulb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Hinaot nga panalanginan ka ni Yahweh ug motipig kanimo. ");
INSERT INTO cebulb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Hinaot nga ang panagway ni Yahweh modan-ag kanimo ug magmaluluy-on kanimo. ");
INSERT INTO cebulb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Hinaot nga si Yahweh magtan-aw kanimo uban ang kaluoy ug maghatag kanimo ug kalinaw.” ");
INSERT INTO cebulb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Sa ingon niini nga pamaagi kinahanglan nga ihatag nila ang akong ngalan ngadto sa katawhan sa Israel. Unya ako silang panalanginan.” ");
INSERT INTO cebulb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Sa adlaw nga nahuman ni Moises ang tabernakulo, gidihogan niya kini ug iya kining gigahin alang kang Yahweh, lakip ang tanan nga mga kasangkapan niini. Gibuhat usab niya ang sama niini alang sa halaran ug sa mga gamit niini. Gidihogan niya kini ug gigahin alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Nianang adlawa, ang mga pangulo sa Israel, ang mga ulo sa pamilya sa ilang mga katigulangan, naghalad ug mga sakripisyo. Kining mga tawhana mao ang nangulo sa mga tribo. Sila ang nagdumala sa pag-ihap sa mga kalalakin-an. ");
INSERT INTO cebulb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Sila ang nagdala sa ilang mga halad sa atubangan ni Yahweh. Nagdala sila ug unom ka karwahe nga adunay tabon ug napulo ug duha ka mga laking baka. Nagdala sila ug usa ka karwahe alang sa duha ka pangulo, ug ang matag pangulo nagdala ug usa ka laking baka. Gibutang nila kining mga butanga sa atubangan sa tabernakulo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Unya nakigsulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Dawata ang ilang mga halad ug gamita ang mga halad alang sa buluhaton sa tolda nga tagboanan. Ihatag ang mga halad ngadto sa mga Levita, ngadto sa matag usa sumala sa iyang gikinahanglan sa ilang buluhaton.” ");
INSERT INTO cebulb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Gikuha ni Moises ang mga karwahe ug ang mga laking baka, ug gihatag niya kini ngadto sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gihatag niya ang duha ka mga karwahe ug upat ka mga laking baka ngadto sa mga kaliwat ni Gerson, tungod sa gikinahanglan sa ilang buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Gihatag niya ang upat ka karwahe ug walo ka laking mga baka ngadto sa mga kaliwat ni Merari, ubos sa pag-atiman ni Itamar ang anak nga lalaki ni Aaron ang pari. Gibuhat niya kini tungod sa gikinahanglan sa ilang buluhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Apan wala niya gihatagan ug bisan usa niadtong mga butanga ang mga kaliwat ni Kohat, tungod kay ila man ang buluhaton nga may kalambigitan sa mga butang nga gipanag-iyahan ni Yahweh nga kinahanglan nilang pas-anon. ");
INSERT INTO cebulb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Gitugyan sa mga pangulo ang maayo nilang mga butang alang sa paghalad sa halaran sa adlaw nga gidihogan ni Moises ang halaran. Gihalad sa mga pangulo ang ilang mga sakripisyo atubangan sa halaran. ");
INSERT INTO cebulb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Miingon si Yahweh ngadto kang Moises, “Ang matag pangulo kinahanglan maghalad sa iyang sakripisyo sa iyang kaugalingong adlaw alang sa paghalad sa halaran.” ");
INSERT INTO cebulb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Sa unang adlaw, si Nason ang anak nga lalaki ni Aminadab, sa banay ni Juda, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Naghalad siya ingon nga iyang sakripisyo ug usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Naghatag siya ug usa ka bulawan nga plato nga adunay gibug-aton nga napulo ka sekels nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Naghatag siya ug usa ka nati nga laking baka ingon nga halad sinunog, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon. ");
INSERT INTO cebulb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang mga sakripisyo ni Nason ang anak nga lalaki ni Aminadab. ");
INSERT INTO cebulb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Sa ikaduhang adlaw, si Netanel ang anak nga lalaki ni Zuar, pangulo sa mga kaliwat ni Isacar, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Naghalad siya ingon nga iyang sakripisyo ug usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Naghatag usab siya ug usa ka bulawang plato nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Naghatag siya ug usa ka nati nga laking baka ingon nga halad sinunog, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon. ");
INSERT INTO cebulb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Naghatag siya ug duha ka mga laking baka, lima ka mga torong karnero, lima ka mga laking kanding, ug lima ka mga laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Netanel ang anak nga lalaki ni Zuar. ");
INSERT INTO cebulb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Sa ikatulong adlaw, si Eliab ang anak nga lalaki ni Helon, pangulo sa mga kaliwat ni Zebulun, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Naghatag siya ug usa ka nati nga laking baka ingon nga halad sinunog, usa ka torong karnero ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon. ");
INSERT INTO cebulb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Naghatag siya ug duha ka mga laking baka, lima ka mga torong karnero, lima ka mga laking kanding, ug lima ka mga laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Eliab ang anak nga lalaki ni Helon. ");
INSERT INTO cebulb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Sa ika-upat nga adlaw, si Elizur ang anak nga lalaki ni Sedeur, pangulo sa kaliwat ni Reuben, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels, ug ang usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Naghatag siya ug usa ka nati nga laking baka ingon nga halad sinunog, usa ka torong karnero, ug laking karnero nga nati nga usa ka tuig ang kagulangon. ");
INSERT INTO cebulb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Elizur ang anak nga lalaki ni Sedeur. ");
INSERT INTO cebulb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Sa ikalimang adlaw, si Selumiel ang anak nga lalaki ni Zurisadai, pangulo sa mga kaliwat ni Simeon, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ang iyang sakripisyo mao ang usa ka plata nga bandihado nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Naghatag usab siya ug usa ka plato nga bulawan nga adunay napulo ka sekels ang gibug-aton, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Selumiel ang anak nga lalaki ni Zurisadai. ");
INSERT INTO cebulb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Sa ika-unom nga adlaw, si Eliasaf ang anak nga lalaki ni Deuel, pangulo sa kaliwat ni Gad, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Eliasaf ang anak nga lalaki ni Deuel. ");
INSERT INTO cebulb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Sa ikapitong adlaw, si Elisama ang anak nga lalaki ni Amihud, pangulo sa mga kaliwat ni Efraim, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Elisama ang anak nga lalaki ni Amihud. ");
INSERT INTO cebulb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Sa ikawalo nga adlaw, si Gamaliel ang anak nga lalaki ni Pedazur, pangulo sa kaliwat ni Manases, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Gamaliel ang anak nga lalaki ni Pedazur. ");
INSERT INTO cebulb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Sa ikasiyam nga adlaw, si Abidan ang anak nga lalaki ni Gideoni, pangulo sa kaliwat ni Benjamin, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Abidan ang anak nga lalaki ni Gideoni. ");
INSERT INTO cebulb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Sa ikanapulo nga adlaw, si Ahiezer ang anak nga lalaki ni Amisadai, pangulo sa mga kaliwat ni Dan, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Ahiezer ang anak nga lalaki ni Amisadai. ");
INSERT INTO cebulb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Sa ikanapulo ug usa nga adlaw, si Pagiel ang anak nga lalaki ni Ocran, pangulo sa kaliwat ni Aser, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka mga butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Pagiel ang anak nga lalaki ni Ocran. ");
INSERT INTO cebulb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Sa ikanapulo ug duha nga adlaw, si Ahira ang anak nga lalaki ni Enan, pangulo sa kaliwat ni Naftali, naghalad sa iyang sakripisyo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ang iyang sakripisyo mao ang usa ka bandihado nga plata nga adunay gibug-aton nga 130 ka sekels ug usa ka panaksan nga plata nga adunay gibug-aton nga 70 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. Kining duha ka butang puno sa lunlon nga harina nga gisagolan ug lana alang sa halad nga trigo. ");
INSERT INTO cebulb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Naghatag usab siya ug usa ka plato nga bulawan nga adunay gibug-aton nga napulo ka sekels, nga puno sa insenso. ");
INSERT INTO cebulb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Naghatag siya ug usa ka nati nga laking baka, usa ka torong karnero, ug usa ka laking karnero nga nati nga usa ka tuig ang kagulangon ingon nga halad sinunog. ");
INSERT INTO cebulb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Naghatag siya ug usa ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Naghatag siya ug duha ka laking baka, lima ka torong karnero, lima ka laking kanding, ug lima ka laking karnero nga nati nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Mao kini ang sakripisyo ni Ahira ang anak nga lalaki ni Enan. ");
INSERT INTO cebulb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Gigahin kining tanan sa mga pangulo sa Israel sa adlaw nga gidihogan ni Moises ang halaran. Gigahin nila ang napulo ug duha ka bandihado nga plata, napulo ug duha ka mga panaksan nga plata, ug napulo ug duha ka plato nga bulawan. ");
INSERT INTO cebulb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ang matag bandihado nga plata adunay gibug-aton nga 130 ka sekels ug ang matag panaksan adunay gibug-aton nga 70 ka sekels. Ang tanang sudlanan nga plata adunay gibug-aton nga 2, 400 ka sekels, pinaagi sa timbangan ug sekel sa dapit nga balaan. ");
INSERT INTO cebulb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ang matag usa sa napulo ug duha ka plato nga bulawan, puno sa insenso, nga adunay napulo ka sekels ang gibug-aton. Ang tanang plato nga bulawan adunay gibug-aton nga 120 ka sekels. ");
INSERT INTO cebulb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Gigahin niya ang tanan nga mga mananap alang sa halad sinunog, napulo ug duha ka mga laking baka, napulo ug duha ka mga torong karnero, ug napulo ug duha ka mga nating karnero nga laki nga usa ka tuig ang kagulangon. Gihatag nila ang ilang halad nga trigo. Naghatag sila ug napulo ug duha ka laking kanding ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Gikan sa tanan nilang kabakahan, mihatag sila ug 24 ka torong baka, 60 ka mga torong karnero, 60 ka mga laking kanding, ug 60 ka mga nating karnero nga laki nga usa ka tuig ang kagulangon, ingon nga sakripisyo alang sa halad sa pakigdait. Alang kini sa paghalad sa halaran human kini nadihogan. ");
INSERT INTO cebulb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Sa dihang misulod si Moises sa tolda nga tagboanan aron makigsulti kang Yahweh, nadungog niya ang tingog ni Yahweh nga nakigsulti kaniya. Nakigsulti si Yahweh kaniya gikan sa ibabaw sa tabon sa sudlanan sa kasabotan, gikan sa taliwala sa duha ka kerubin. Nagsulti siya ngadto kaniya. ");
INSERT INTO cebulb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nakigsulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Sultihi si Aaron. Ingna siya, 'Ang pito ka lampara kinahanglan maghatag ug kahayag sa atubangan sa tungtonganan ug lampara sa dihang pasigahon nimo kini.''' ");
INSERT INTO cebulb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Gibuhat kini ni Aaron. Gisindihan niya ang mga lampara diha sa tungtonganan sa lampara aron magdan-ag sa atubangan niini, sumala sa gimando ni Yahweh kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ang tungtonganan sa lampara gibuhat sa ingon niini nga paagi ug gipakita ni Yahweh kang Moises ang sumbanan niini. Kinahanglan hinimo kini sa bulawan gikan sa sukaranan niini hangtod sa taas, nga adunay hinulma nga kupa nga daw nagapamukad. ");
INSERT INTO cebulb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Misulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Kuhaa ang mga Levita gikan sa katawhan sa Israel ug hinloi sila. ");
INSERT INTO cebulb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Buhata kini kanila aron sa paghinlo kanila: Pisikpisiki sila ug tubig sa paghinlo kanila. Pakiskisi kanila ang tibuok nilang lawas, palabha sa ilang mga bisti, ug sa ingon niini nga paagi mahinloan ang ilang kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Unya pakuhaa sila ug nating baka ug halad nga trigo nga lunlon harina nga gisagolan ug lana. Pakuhaa sila pag-usab ug lain pang nating baka ingon nga halad sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Dad-a ang mga Levita sa atubangan sa tolda nga tagboanan, ug tigoma ang tibuok katilingban sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Dad-a ang mga Levita sa akong atubangan, O Yahweh. Kinahanglan nga ang katawhan sa Israel mopandong sa ilang mga kamot ngadto sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Kinahanglan nga ihalad ni Aaron ang mga Levita sa atubangan ni Yahweh, ingon nga halad nga binayaw gikan sa katawhan sa Israel. Kinahanglan buhaton niya kini aron nga ang mga Levita mag-alagad kanako. ");
INSERT INTO cebulb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Kinahanglan ipandong sa mga Levita ang ilang mga kamot sa ulo sa mga baka. Kinahanglan maghalad kamo ug usa ka baka ingon nga halad sa sala ug laing baka ingon nga halad sinunog alang kanako, aron sa paghinlo sa mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Dad-a ang mga Levita sa atubangan ni Aaron ug sa iyang mga anak nga lalaki, ug ipataas sila ingon nga halad nga binayaw alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Sa ingon niini nga paagi kinahanglan ilain nimo ang mga Levita gikan sa katawhan sa Israel. Akoa ang mga Levita. ");
INSERT INTO cebulb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Human niana, kinahanglan nga mosulod ang mga Levita aron mag-alagad didto sa tolda nga tagboanan. Kinahanglan hinloan nimo sila. Kinahanglan ihalad nimo sila ingon nga halad nga binayaw. ");
INSERT INTO cebulb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Buhata kini, tungod kay silang tanan akoa gikan sa katawhan sa Israel. Pulihan nila ang matag batang lalaki nga moabli sa tagoangkan, ang kamagulangang anak sa tanang kaliwat sa Israel. Gikuha ko ang mga Levita alang sa akong kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Akoa ang tanan nga mga kamagulangang anak gikan sa katawhan sa Israel, sa mga tawo ug sa mga mananap. Sa adlaw nga gikuha ko ang kinabuhi sa tanang kamagulangang anak didto sa yuta sa Ehipto, gilain ko sila alang sa akong kaugalingon. ");
INSERT INTO cebulb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Gikuha ko ang mga Levita gikan sa katawhan sa Israel imbis nga ang tanang kamagulangang anak. ");
INSERT INTO cebulb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Gitagana ko ang mga Levita ingon nga gasa alang kang Aaron ug sa iyang mga anak nga lalaki. Gikuha ko sila gikan sa katawhan sa Israel aron sa pagbuhat sa buluhaton sa katawhan sa Israel didto sa tolda nga tagboanan. Gitagana ko sila alang sa kapasayloan sa katawhan sa Israel aron nga walay balatian nga mohampak sa katawhan kung moduol sila sa balaang dapit.” ");
INSERT INTO cebulb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Si Moises, si Aaron ug ang tibuok katilingban sa katawhan sa Israel nagbuhat niini uban sa mga Levita. Gibuhat nila ang tanan nga gimando ni Yahweh kang Moises mahitungod sa mga Levita. Gibuhat kini sa katawhan sa Israel uban kanila. ");
INSERT INTO cebulb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Gihinloan sa mga Levita ang ilang mga kaugalingon ug gilabhan ang ilang mga bisti, ug gidala sila ni Aaron ingon nga halad nga binayaw alang kang Yahweh ug naghimo siya ug kapasayloan alang kanila aron mahinloan sila. ");
INSERT INTO cebulb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Human niana, nanulod ang mga Levita sa tolda nga tagboanan aron sa pagbuhat sa ilang buluhaton sa atubangan ni Aaron ug sa mga anak nga lalaki ni Aaron. Sumala kini sa gimando ni Yahweh kang Moises mahitungod sa mga Levita. Gitagad nila ang tanang Levita sa ingon niini nga paagi. ");
INSERT INTO cebulb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Nakigsulti pag-usab si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Kining tanan alang sa mga Levita nga nagpanuigon ug 25 ka tuig ug pataas. Kinahanglan moapil sila sa pundok nga moalagad sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Kinahanglan moundang sila sa pag-alagad sa ingon niini nga paagi sa pangidaron nga 50 ka tuig. Sa ingon niana nga pangidaron kinahanglan nga dili na gayod sila mag-alagad. ");
INSERT INTO cebulb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mahimo sila nga motabang sa ilang mga igsoong lalaki nga nagbuhat sa buluhaton sa tolda nga tagboanan, apan kinahanglan nga dili na gayod sila mag-alagad pa. Kinahanglan dumalahan nimo ang mga Levita niining tanang mga butanga.” ");
INSERT INTO cebulb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nakigsulti si Yahweh kang Moises didto sa kamingawan sa Sinai, sa unang bulan sa ikaduhang tuig gikan sa paggawas nila sa kayutaan sa Ehipto. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Tugoti ang katawhan sa Israel nga isaulog ang Pagsaylo sa tukmang panahon sa tuig. ");
INSERT INTO cebulb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Sa ikanapulo ug upat nga adlaw niining bulana, sa pagkagabii, kinahanglang isaulog ang Pagsaylo sa tukmang panahon sa tuig. Kinahanglan nga tumanon nimo kini, sunda ang tanang sulundon, ug tumana ang tanang balaod nga may kalabotan niini.” ");
INSERT INTO cebulb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Busa, gisultihan ni Moises ang katawhan sa Israel nga kinahanglan nilang isaulog ang Kapistahan sa Pagsaylo. ");
INSERT INTO cebulb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Busa gisaulog nila ang Pagsaylo sa unang bulan, sa ikanapulo ug upat nga adlaw sa bulan, sa pagkagabii, didto sa kamingawan sa Sinai. Ang katawhan sa Israel mituman sa tanan nga gimando ni Yahweh kang Moises nga buhaton. ");
INSERT INTO cebulb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Adunay pipila ka mga lalaki nga nahugaw tungod sa patay nga lawas sa tawo. Dili sila makahimo sa pagsaulog sa Pagsaylo nianang adlawa. Miduol sila kang Moises ug kang Aaron nianang maong adlawa. ");
INSERT INTO cebulb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Kadto nga mga tawo miingon kang Moises, “Hugaw kami tungod sa patay nga lawas sa tawo. Nganong inyo kaming pugngan nga mohalad ug sakripisyo kang Yahweh sa tukmang panahon sa tuig uban sa katawhan sa Israel?” ");
INSERT INTO cebulb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Miingon si Moises kanila, “Hulat kanako kay akong paminawon kung unsay ikasulti ni Yahweh mahitungod kaninyo.” ");
INSERT INTO cebulb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nakigsulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Sultihi ang katawhan sa Israel. Ingna, 'Kung bisan kinsa kaninyo o sa inyong kaliwatan ang nahugaw tungod sa patay nga lawas, o kung anaa sa taas nga panaw, magsaulog gihapon siya sa Pagsaylo alang kang Yahweh.' ");
INSERT INTO cebulb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Kinahanglan nilang isaulog ang Pagsaylo sa ikaduhang bulan sa gabii sa ikanapulo ug upat nga adlaw. Kinahanglan kaonon nila kini uban sa tinapay nga walay igpapatubo ug sa pait nga mga herbal. ");
INSERT INTO cebulb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kinahanglan nga walay mabilin niini hangtod sa pagkabuntag, o balion bisan ang bukog niini. Kinahanglan nilang subayon ang tanang sulundon alang sa Pagsaylo. ");
INSERT INTO cebulb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Apan kung si bisan kinsa nga hinlo ug wala nagpanaw, apan napakyas sa pagsaulog sa Pagsaylo, kanang tawhana kinahanglan ipahilayo sa iyang katawhan tungod kay wala siya naghalad ug sakripisyo nga gikinahanglan ni Yahweh sa tukmang panahon sa tuig. Kinahanglan pas-anon nianang tawhana ang iyang sala. ");
INSERT INTO cebulb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kung adunay langyaw nga nagpuyo diha kaninyo ug buot magsaulog sa Pagsaylo aron sa pagpasidungog kang Yahweh, kinahanglan niyang subayon ang mga kamandoan sa Pagsaylo, ug tumanon ang mga balaod niini. Kinahanglan nga aduna kamoy samang balaod alang sa mga langyaw ug alang sa tanang nahimugso sa yuta.” ");
INSERT INTO cebulb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Sa adlaw nga natukod na ang tabernakulo, ang panganod mitabon sa tabernakulo, ang tolda sa kasabotan. Sa pagkagabii ang panganod anaa ibabaw sa tabernakulo. Sama kini sa kalayo hangtod sa pagkabuntag. ");
INSERT INTO cebulb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Nagpadayon kini nga ingon niana. Ang panganod mitabon sa tabernakulo ug nahisama sa kalayo sa pagkagabii. ");
INSERT INTO cebulb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Sa dihang mopataas ang panganod ibabaw sa tolda, ang katawhan sa Israel mangandam sa ilang pagpanglakaw. Kung ang panganod mohunong, ang mga tawo magkampo. ");
INSERT INTO cebulb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Sa mando ni Yahweh, manglakaw ang katawhan sa Israel, ug sa iyang pagmando, magkampo sila. Samtang ang panganod mohunong ibabaw sa tabernakulo, magpabilin sila sa ilang kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kung ang panganod magpabilin ibabaw sa tabernakulo sa daghang mga adlaw, ang katawhan sa Israel motuman sa mga pagmando ni Yahweh ug dili molakaw. ");
INSERT INTO cebulb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Usahay ang panganod magpabilin sa tabernakulo sa pipila ka mga adlaw. Sa ingon niana, motuman sila sa mando ni Yahweh—magbuhat sila ug kampo ug unya molakaw sa iyang mando. ");
INSERT INTO cebulb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Usahay ang panganod anaa sa kampo gikan sa kagabhion hangtod sa kabuntagon. Kung ang panganod mopataas sa panahon sa kabuntagon, manglakaw sila. Kung magpadayon kini sa usa ka adlaw ug sa usa ka gabii, molakaw lamang sila kung ang panganod mopataas. ");
INSERT INTO cebulb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kung ang panganod magpabilin sa tabernakulo sa duha ka adlaw, sa usa ka bulan, o usa ka tuig, hangtod nga magpabilin kini didto, ang katawhan sa Israel magpabilin sa ilang kampo ug dili molakaw. Apan kung ang panganod mopataas, manglakaw sila. ");
INSERT INTO cebulb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Magkampo sila ubos sa mando ni Yahweh, ug molakaw sa iyang pagmando. Gituman nila ang mando nga gihatag ni Yahweh pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Misulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Pagbuhat ug duha ka trumpeta nga plata. Masoha ang plata aron paghimo niini. Kinahanglan nga gamiton nimo ang mga trumpeta aron sa pagtigom sa katilingban ug aron sa pagpahibalo sa katilingban nga ibalhin ang ilang mga kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kinahanglan ipatingog sa mga pari ang mga trumpeta aron pagtigom sa katilingban diha sa imong atubangan sa ganghaan sa tolda nga tagboanan. ");
INSERT INTO cebulb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kung usa lamang ka trumpeta ang patingogon sa mga pari, unya ang mga pangulo, ang nangulo sa matag banay sa Israel, kinahanglang magtigom diha kanimo. ");
INSERT INTO cebulb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kung magpatingog kamo sa makusog nga pagpasidaan, ang mga kampo nga anaa sa sidlakang bahin magsugod sa ilang lakaw. ");
INSERT INTO cebulb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kung magpatingog kamo sa makusog nga pagpasidaan sa ikaduhang higayon, ang mga kampo sa habagatang bahin kinahanglan magsugod sa ilang lakaw. Kinahanglan magpatingog sila sa makusog nga pagpasidaan alang sa ilang pagpanglakaw. ");
INSERT INTO cebulb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kung magtigom ang tibuok katilingban, patingoga ang mga trumpeta, apan dili lamang kusog. ");
INSERT INTO cebulb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ang mga anak ni Aaron, nga mga pari, kinahanglan maoy magpatingog sa mga trumpeta. Mao kini kanunay ang sulundon alang kanimo sa tibuok henerasyon sa imong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kung makiggubat ka batok sa mga kaaway nga nagdaogdaog kanimo diha sa inyong yuta, kinahanglan nimong ipatingog ang tingog sa pagpasidaan gamit ang mga trumpeta. Ako, si Yahweh nga imong Dios, maghinumdom kanimo ug molawas kanimo gikan sa imong mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Sa panahon usab sa pagsaulog sa inyong naandang mga kapistahan ug sa mga pagsugod sa bulan, kinahanglan nimong patingogon ang mga trumpeta aron sa pagpasidungog sa inyong halad sinunog ug ngadto sa mga halad sakripisyo alang sa inyong pakigdait. Kini maoy magpahinumdom kaninyo mahitungod kanako, nga inyong Dios. Ako si Yahweh nga inyong Dios.” ");
INSERT INTO cebulb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Sa ikaduhang tuig, sa ikaduhang bulan, sa ika-20 nga adlaw sa bulan, ang panganod mipataas sa tabernakulo sa kasabotan. ");
INSERT INTO cebulb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ang katawhan sa Israel nagpadayon sa ilang lakaw gikan sa kamingawan sa Sinai. Ang panganod mihunong sa kamingawan sa Paran. ");
INSERT INTO cebulb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mao kadto ang ilang unang pagpanglakaw, subay sa mando ni Yahweh nga gihatag pinaagi kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ang kampo ilalom sa bandira sa mga kaliwatan ni Juda maoy nag-una, nanglakaw uban sa ilang kaugalingon kasundalohan. Si Nason ang anak nga lalaki ni Aminadab maoy naggiya sa mga sundalo ni Juda. ");
INSERT INTO cebulb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Si Netanel ang anak nga lalaki ni Zuar maoy naggiya sa mga sundalo sa tribo sa mga kaliwatan ni Isacar. ");
INSERT INTO cebulb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Si Eliab ang anak nga lalaki ni Helon maoy naggiya sa mga sundalo sa tribo sa mga kaliwatan ni Zebulun. ");
INSERT INTO cebulb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ang mga kaliwat ni Gerson ug Merari, maoy nag-amping sa tabernakulo, naghipos sa tabernakulo ug unya nagsugod sa ilang lakaw. ");
INSERT INTO cebulb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Sunod nga nanglakaw mao ang mga sundalo ilalom sa bandira sa kampo ni Reuben. Si Elizur ang anak nga lalaki ni Sedeur maoy naggiya sa mga sundalo ni Reuben. ");
INSERT INTO cebulb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Si Selumiel ang anak nga lalaki ni Zurisadai maoy naggiya sa tribo sa mga kaliwat ni Simeon. ");
INSERT INTO cebulb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Si Elisaf ang anak nga lalaki ni Deuel maoy naggiya sa mga sundalo sa tribo sa mga kaliwat ni Gad. ");
INSERT INTO cebulb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ang mga Kohatihanon nanglakaw. Sila ang nagdala sa mga balaang gamit sa dapit nga balaan. Ang uban maoy magtukod sa tabernakulo sa dili pa moabot ang mga Kohatihanon sa sunod nga kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ang mga sundalo ilalom sa bandira sa mga kaliwat ni Efraim maoy sunod nga nanglakaw. Si Elisama ang anak nga lalaki ni Amihud maoy naggiya sa mga sundalo ni Efraim. ");
INSERT INTO cebulb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Si Gamaliel ang anak nga lalaki ni Pedazur maoy naggiya sa mga sundalo sa tribo sa mga kaliwat ni Manases. ");
INSERT INTO cebulb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Si Abidan ang anak nga lalaki ni Gideoni maoy naggiya sa mga sundalo sa tribo sa mga kaliwat ni Benjamin. ");
INSERT INTO cebulb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ang mga sundalo nga nagkampo ilalom sa bandira sa mga kaliwat ni Dan maoy ulahing nanglakaw. Si Ahiezer ang anak nga lalaki ni Amisadai maoy naggiya sa mga sundalo ni Dan. ");
INSERT INTO cebulb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Si Pagiel ang anak nga lalaki ni Ocran maoy naggiya sa mga sundalo sa tribo sa kaliwat ni Aser. ");
INSERT INTO cebulb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Si Ahira ang anak nga lalaki ni Enan maoy naggiya sa mga sundalo sa tribo sa mga kaliwat ni Naftali. ");
INSERT INTO cebulb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mao kini ang paagi sa pagpanglakaw sa mga kasundalohan sa katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Nakigsulti si Moises kang Hobab nga anak nga lalaki ni Reuel nga usa ka Midianhon. Si Reuel mao ang amahan sa asawa ni Moises. Nakigsulti si Moises kang Hobab ug miingon, “Moadto kami sa dapit nga gihulagway ni Yahweh kanamo. Si Yahweh miingon, 'Ihatag ko kini kaninyo.' Kuyog kanamo ug buhaton namo kanimo ang maayo. Gisaad ni Yahweh nga mobuhat ug maayo alang sa Israel.” ");
INSERT INTO cebulb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Apan miingon si Hobab kang Moises, “Dili ako mokuyog kaninyo. Moadto ako sa akong kaugalingong yuta ug sa akong kaugalingong katawhan.” ");
INSERT INTO cebulb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Unya si Moises mitubag, “Palihog ayaw kami biyai. Nasayod ka kung unsaon pagkampo sa kamingawan. Kinahanglan nga bantayan mo kami. ");
INSERT INTO cebulb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kung mokuyog ka kanamo, buhaton namo kanimo ang maayo sama sa gibuhat ni Yahweh kanamo.” ");
INSERT INTO cebulb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Gikan sa bukid ni Yahweh naglakaw sila sulod sa tulo ka adlaw. Ang sudlanan sa kasabotan ni Yahweh nag-una kanila sulod nianang tulo ka adlaw aron sa pagpangita ug dapit nga ilang kapahulayan. ");
INSERT INTO cebulb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ang panganod ni Yahweh anaa sa ilang ibabaw sa panahon sa adlaw samtang naglakaw sila. ");
INSERT INTO cebulb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sa dihang maglakaw ang sudlanan sa kasabotan, moingon si Moises, “Bangon, O Yahweh. Patibulaaga ang imong mga kaaway. Himoa nga kadtong nagdumot kanimo mokalagiw palayo kanimo.” ");
INSERT INTO cebulb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sa dihang ang sudlanan sa kasabotan mohunong, si Moises moingon, “O Yahweh, balik ngadto sa napulo ka liboan ka mga Israel.” ");
INSERT INTO cebulb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Karon nagbagulbol ang mga tawo mahitungod sa ilang mga kalisdanan samtang naminaw si Yahweh. Nadungog ni Yahweh ang mga tawo ug nasuko. Ang kalayo nga gikan kang Yahweh misunog kanila ug milamoy sa pipila ka mga kampo nga anaa sa tumoy. ");
INSERT INTO cebulb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Unya mitawag ang mga tawo kang Moises, busa nag-ampo si Moises kang Yahweh, ug ang kalayo napalong. ");
INSERT INTO cebulb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Kadto nga dapit ginganlan ug Tabera, tungod kay ang kalayo ni Yahweh misilaob man sa ilang taliwala. ");
INSERT INTO cebulb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Pipila ka mga langyaw ang nagsugod sa pagkampo uban sa kaliwatan sa Israel. Nagtinguha sila ug maayong kalan-on aron kaonon. Unya ang katawhan sa Israel nanagpanghilak ug miingon, “Kinsay makahatag kanamo ug karne aron kaonon? ");
INSERT INTO cebulb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nahinumdoman namo ang isda nga gawasnon namong ginakaon didto sa Ehipto, ang mga pipino, mga melon, mga sibuyas, ang mga bombay, ug ang mga ahos. ");
INSERT INTO cebulb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Karon nawala na ang among gana sa pagkaon, tungod kay kining mana na lamang ang kanunay namong makita.” ");
INSERT INTO cebulb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ang mana sama sa koriander nga liso. Sama kini sa bdelio. ");
INSERT INTO cebulb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Manglakaw ang mga tawo ug mangtigom niini. Galingon nila kini, lubokon sa lusong, lutoon kini sa mga kolon ug himoon kining tinapay. Ang lasa niini sama sa preskong lana sa olibo. ");
INSERT INTO cebulb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Sa dihang ang yamog mangatagak sa kampo sa kagabhion, mangahulog usab ang mana. ");
INSERT INTO cebulb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Nadungog ni Moises ang pagdangoyngoy sa mga tawo diha sa ilang mga pamilya, ug ang mga kalalakin-an anaa sa ganghaan sa iyang tolda. Nasuko pag-ayo si Yahweh, ug sa panan-aw ni Moises sayop ang ilang pagbagulbol. ");
INSERT INTO cebulb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Miingon si Moises kang Yahweh, “Nganong dili man maayo ang imong pagtagad sa imong sulugoon? Nganong wala ka mahimuot kanako? Gipapas-an mo kanako ang mga kabug-aton niining tanang katawhan? ");
INSERT INTO cebulb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ako ba diay ang nanamkon niining tanang katawhan? Gianak ko ba sila nga kinahanglan kang moingon kanako, 'Dad-a sila duol sa imong dughan sama sa amahan nga nagkugos sa iyang gamay nga bata?' Kinahanglan ko ba silang dad-on paingon sa yuta nga imong gipanumpa sa ilang mga katigulangan nga ihatag kanila? ");
INSERT INTO cebulb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Diin man ako makakita ug karne aron ihatag niining tanang katawhan? Nanagpanghilak sila sa akong atubangan ug miingon, 'Hatagi kami ug karne aron among kan-on.' ");
INSERT INTO cebulb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Dili nako kaya nga pas-anon kining tanang katawhan nga mag-inusara. Sobra ra sila alang kanako. ");
INSERT INTO cebulb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Sanglit gitagad mo ako sa ingon niining paagiha, patya na lamang ako karon, kung maluoy ka kanako, ug kuhaa ang akong mga kalisdanan.” ");
INSERT INTO cebulb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Miingon si Yahweh kang Moises, “Dad-a nganhi kanako ang 70 ka mga kadagkoan sa Israel. Siguroha nga sila mga kadagkoan ug mga pangulo sa katawhan. Dad-a sila ngadto sa tolda nga tagboanan aron motindog didto uban kanimo. ");
INSERT INTO cebulb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mokanaog ako ug magkigsulti ako kanimo didto. Kuhaon ko ang pipila ka mga Espiritu nga anaa kanimo ug ibutang kini ngadto kanila. Pagapas-anon nila ang kabug-aton sa mga tawo uban kanimo. Dili mo na kini pas-anon nga mag-inusara. ");
INSERT INTO cebulb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ingna ang katawhan, 'Andama ang inyong mga kaugalingon alang ugma ug makakaon gayod kamo ug karne, tungod kay mihilak kamo ug nadungog kamo ni Yahweh. Miingon kamo, “Kinsa ang makahatag kanamo ug karne aron among kan-on? Maayo pa alang kanamo nga didto kami sa Ehipto.” Busa hatagan kamo ni Yahweh ug karne ug kaonon ninyo kini. ");
INSERT INTO cebulb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Dili lamang kamo mokaon ug karne sulod sa usa ka adlaw, sa duha ka adlaw, sa lima ka adlaw, sa napulo ka adlaw o sa 20 ka adlaw, ");
INSERT INTO cebulb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","apan mokaon kamo ug karne sulod sa tibuok bulan hangtod nga manggawas na kini sa inyong mga ilong. Lud-on kamo niini tungod kay gisalikway man ninyo si Yahweh, nga anaa kaninyo. Nanaghilak kamo sa iyang atubangan. Miingon kamo, “Nganong mibiya kita sa Ehipto?”'” ");
INSERT INTO cebulb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Unya miingon si Moises, “Uban kanako ang 600, 000 ka mga tawo, ug miingon ka, 'Hatagan ko sila ug karne aron ilang kaonon sulod sa tibuok bulan.' ");
INSERT INTO cebulb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Mangayam ba kami ug panon sa kahayopan aron matagbaw sila? Pamukoton ba namo ang tanang isda sa dagat aron matagbaw sila?” ");
INSERT INTO cebulb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Miingon si Yahweh kang Moises, “Mubo ba ang akong kamot? Karon makita mo kung tinuod ba o dili ang akong pulong.” ");
INSERT INTO cebulb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Migawas si Moises ug giingnan ang mga tawo sa mga pulong ni Yahweh. Gitigom niya ang 70 ka mga kadagkoan ug gipahimutang sila palibot sa tolda. ");
INSERT INTO cebulb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mikanaog si Yahweh sa panganod ug misulti kang Moises. Gikuha ni Yahweh ang pipila ka mga Espiritu nga anaa kang Moises ug gibutang kini sa 70 ka mga kadagkoan. Sa dihang ang Espiritu napahiluna kanila, nanagna sila, apan niadto lamang nga higayon ug wala na mausab. ");
INSERT INTO cebulb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Duha ka tawo ang nagpabilin sa kampo, nga ginganlan ug Eldad ug Medad. Ang Espiritu anaa usab kanila. Ang ilang mga ngalan nahisulat sa listahan, apan wala sila migawas sa tolda. Hinuon, nanagna sila sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Usa ka batan-ong lalaki ang midagan paingon kang Moises ug miingon, “Si Eldab ug Medad nanagna didto sa kampo.” ");
INSERT INTO cebulb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Si Josue ang anak nga lalaki ni Nun, ang alalay ni Moises, usa sa iyang pinili nga tawo, miingon kang Moises, “Akong agalong Moises, pahunonga sila.” ");
INSERT INTO cebulb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Miingon si Moises kaniya, “Nangabugho ka ba alang kanako? Gitinguha ko nga ang tanang katawhan ni Yahweh mga propeta ug aron ibutang niya ang iyang Espiritu sa ilang tanan!” ");
INSERT INTO cebulb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Unya si Moises ug ang mga kadagkoan sa Israel mibalik sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Unya miabot ang hangin nga gikan kang Yahweh ug nagdala ug buntog gikan sa dagat. Nangahulog kini duol sa kampo, mga usa ka adlaw nga pagpanaw sa usa ka bahin ug usa ka adlaw nga pagpanaw sa laing bahin. Ang buntog nakapalibot sa kampo nga mga duha ka kyubits ang kahabogon gikan sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Nagkapuliki ang mga tawo sa pagpanguha sa buntog tibuok adlaw, tibuok gabii, ug pagkasunod adlaw. Walay nagkuha ug minus napulo ka homers sa buntog. Gipangbahinbahin nila ang buntog sa tibuok kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Samtang ang karne anaa pa sa ilang baba, samtang giusap pa nila kini, nasuko si Yahweh kanila. Giatake niya ang katawhan sa hilabihan ka dakong balatian. ");
INSERT INTO cebulb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kadto nga dapit ginganlan ug Kibrot Hataava, tungod kay didto nila gilubong ang mga tawo nga nagtinguha ug karne. ");
INSERT INTO cebulb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Gikan sa Kibrot Hataava ang katawhan nanglakaw padulong sa Hazerot, diin didto sila nagpabilin. ");
INSERT INTO cebulb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Unya si Miriam ug si Aaron misulti batok kang Moises tungod sa Cuhitihanon nga babaye nga iyang giminyoan. ");
INSERT INTO cebulb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Miingon sila, “Nakigsulti lang ba si Yahweh kang Moises? Wala ba usab siya nakigsulti kanato?” Karon nadungog ni Yahweh ang ilang giingon. ");
INSERT INTO cebulb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Karon ang tawo nga si Moises usa ka mapainubsanon, mapainubsanon kay kang bisan kinsa nga anaa sa kalibotan. ");
INSERT INTO cebulb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Dihadiha misulti si Yahweh kang Moises, kang Aaron, ug kang Miriam: “Gawas, kamong tulo, ngadto sa tolda nga tagboanan.” Busa ang tulo migawas. ");
INSERT INTO cebulb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Unya mikanaog si Yahweh diha sa haligi nga panganod. Mitindog siya sa ganghaan sa tolda ug gitawag si Aaron ug si Miriam. Silang duha mipaduol. ");
INSERT INTO cebulb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Miingon si Yahweh, “Karon paminawa ang akong mga pulong. Sa dihang ang akong propeta uban kaninyo, ipakita ko ang akong kaugalingon kaniya diha sa mga panan-awon ug mosulti kaniya diha sa mga damgo. ");
INSERT INTO cebulb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ang akong sulugoon nga si Moises dili sama niana. Matinud-anon siya sa tibuok nakong panimalay. ");
INSERT INTO cebulb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ako mismo nagkigsulti kang Moises, dili sa mga panan-awon o mga tigmo. Nakita niya ang akong hulagway. Busa nganong wala kamo mahadlok sa pagsulti ug batok sa akong sulugoon, batok kang Moises?” ");
INSERT INTO cebulb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ang kasuko ni Yahweh misilaob batok kanila, ug unya mibiya siya kanila. ");
INSERT INTO cebulb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ang panganod mipataas sa tolda, ug si Miriam sa kalit gitakboyan ug sangla—niputi siya sama sa nyibe. Sa dihang milingi si Aaron kang Miriam, nakita niya nga kini nahimong sanglahon. ");
INSERT INTO cebulb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Si Aaron miingon kang Moises, “O akong agalon, palihog ayaw kupti kining sala batok kanamo. Nagsulti kami ug buangbuang, ug nakasala kami. ");
INSERT INTO cebulb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Palihog ayaw itugot nga mamahimo siyang sama sa patay nga bag-ong anak nga ang unod halos gilamoy sa dihang migula kini gikan sa tagoangkan sa inahan.” ");
INSERT INTO cebulb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Busa nagpakitabang si Moises kang Yahweh. Miingon siya, “Palihog ayoha siya, O Dios, palihog.” ");
INSERT INTO cebulb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Miingon si Yahweh kang Moises, “Kung giluwaan sa iyang amahan ang iyang nawong, maulawan siya sulod sa pito ka adlaw. Ipagawas siya sa kampo sulod sa pito ka adlaw. Human niana dad-a siya sa sulod pag-usab.” ");
INSERT INTO cebulb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Busa gibutang si Miriam gawas sa kampo sulod sa pito ka adlaw. Ang katawhan wala nanglakaw hangtod nga nakabalik siya sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Human niana, ang katawhan nanglakaw gikan sa Hazerot ug mikampo sa kamingawan sa Paran. ");
INSERT INTO cebulb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Unya nakigsulti si Yahweh kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ipadala ang pipila ka mga kalalakin-an aron sa pagsusi sa yuta sa Canaan, diin akong gihatag sa katawhan sa Israel. Pagpadala ug tawo sa matag tribo sa ilang katigulangan. Ang matag usa ka tawo kinahanglan mangulo taliwala kanila.” ");
INSERT INTO cebulb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Gipadala sila ni Moises gikan sa kamingawan sa Paran, aron nga motuman sila sa sugo ni Yahweh. Silang tanan mga pangulo sa mga katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mao kini ang ilang mga ngalan: gikan sa tribo ni Ruben, Shammua ang anak nga lalaki ni Zaccur; ");
INSERT INTO cebulb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","gikan sa tribo ni Simeon, Shafat ang anak nga lalaki ni Hori; ");
INSERT INTO cebulb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","gikan sa tribo ni Juda, si Caleb ang anak nga lalaki ni Jefunneh; ");
INSERT INTO cebulb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","gikan sa tribo ni Isacar, si Igal ang anak nga lalaki ni Jose; ");
INSERT INTO cebulb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","gikan sa tribo ni Efraim si Hosea ang anak nga lalaki ni Nun; ");
INSERT INTO cebulb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","gikan sa tribo ni Benjamin, si Palti ang anak nga lalaki ni Rafu; ");
INSERT INTO cebulb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","gikan sa tribo ni Zebulun, si Gaddiel ang anak nga lalaki ni Sodi; ");
INSERT INTO cebulb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","gikan sa tribo ni Jose (mao kana ang pagkasulti, gikan sa tribo ni Manases), si Gaddi ang anak nga lalaki ni Susi; ");
INSERT INTO cebulb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","gikan sa tribo ni Dan, si Ammiel ang anak nga lalaki ni Gemalli; ");
INSERT INTO cebulb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","gikan sa tribo ni Aser, si Sethur ang anak nga lalaki ni Michael; ");
INSERT INTO cebulb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","gikan sa tribo ni Naftali, mao si Nahbi ang anak nga lalaki ni Vofsi; ");
INSERT INTO cebulb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","gikan sa tribo ni Gad, si Geuel ang anak nga lalaki ni Machi. ");
INSERT INTO cebulb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mao kini ang mga ngalan sa mga kalalakin-an kansang gipadala ni Moises sa pagsusi sa yuta. Gipatawag ni Moises si Hosea ang anak nga lalaki ni Nun pinaagi sa ngalan ni Josue. ");
INSERT INTO cebulb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Gipadala sila ni Moises aron sa pagsusi sa yuta sa canaan. Siya miingon ngadto kanila, “Paduol kamo sa Negev ug saka kamo ngadto sa mga bukid. ");
INSERT INTO cebulb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Susiha ang yuta aron makita kung unsa ang sama niini. Panid-i ang mga tawo nga nanimuyo didto, kung sila ba mga kusgan o mga huyang, kung sila gamay ba o daghan. ");
INSERT INTO cebulb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Tan-awa kung unsa sama ang yuta kung asa sila nanimuyo. Kini ba maayo o dili maayo? Unsa ang mga siyudad nga anaa didto? Kung sama ba sila sa kampo, o lig-on ba nga mga siyudad? ");
INSERT INTO cebulb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tan-awa kung sama sa unsa ang yuta kung maayo ba kini nga katuboan ug pananom o dili, ug kung aduna bay kahoy didto o wala. Pagmaisugon ug pagdala balik ug panag-ingnan sa yuta.” Karon ang panahon sa unang pagpamupo sa mga hinog nga ubas. ");
INSERT INTO cebulb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Busa ang mga kalalakin-an nanungas ngadto sa yuta gikan sa kamingawan sa Sin ngadto sa Rehob, duol sa Lebo sa Hamat. ");
INSERT INTO cebulb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nagsaka sila sa Negev ug nakaabot sa Hebron. Si Ahiman, Sheshai, ug Talmai, kaliwat gikan sa banay ni Anak, anaa didto. Karon natukod ang Hebron mitukod sa pito ka tuig sa wala pa ang Zoan sa Ehipto. ");
INSERT INTO cebulb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Sa dihang nakaabot na sila sa walog sa Escol, Nagputol sila ug sanga lakip ang usa ka pungpong sa ubas. Gidala nila kini gibutangan nila ug kahoy sa taliwala sa duha sa ilang grupo. Nagdala usab sila ug granada ug mga igos. ");
INSERT INTO cebulb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Kana nga dapit ginganlan ug walog sa Eschol, tungod sa pungpong sa ubas nga giputol sa katawhan sa Israel didto. ");
INSERT INTO cebulb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Human sa 40 ka adlaw, mibalik sila gikan sa pagsusi sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Miabot sila balik kang Moises, Aaron, ug ngadto sa tanan nga lumulopyo nga katawhan sa Israel didto sa kamingawan sa Paran, didto sa Kadesh. Nagdala sila pagbalik ug mga sugilanon ngadto kanila ug ngadto sa tanan nga lumulopyo, ug gipakita kanila ang mga abot gikan sa yuta. ");
INSERT INTO cebulb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Misulti sila kang Moises, “Nakaabot kami sa yuta nga imong gipaadtoan kanamo. Labihan ang pag-agas sa gatas ug dugos. Kini ang pipila ka mga abot gikan niini. ");
INSERT INTO cebulb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Apan, mga kusgan ang mga tawo nga naghimo sa ilang pinuy-anan didto. Kinural ang mga siyudad ug labihan kaluag. Nakita usab namo didto ang mga kaliwat ni Anak. ");
INSERT INTO cebulb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ang Amolikanhon nanimuyo didto sa Negev. Ang Hitihanon, Jebusihanon, ug ang mga Amonihanon adunay mga pinuy-anan didto sa kabungtoran nga bahin. Ang mga Canaanhon nanimuyo sa dagat ug kilid sa tubig sa Jordan.” ");
INSERT INTO cebulb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Unya gipahilom ni Caleb ang katawhan nga anaa sa atubangan ni Moises ug misulti, “Manaka kita ug angkonon ang yuta, tungod kay makahimo gayod kita sa pag-ilog niini.” ");
INSERT INTO cebulb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Apan ang lain nga mga kalalakin-an nga mikuyog kaniya nag-ingon “Dili kita makahimo sa pagsulong sa katawhan tungod kay mga gusgan sila kaysa kanato.” ");
INSERT INTO cebulb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Busa nagpakaylap sila sa mga balita nga makapaluya sa katawhan sa Israel mahitungod sa yuta nga ilang gisusi. Sila miingon, “Ang yuta nga among gitan-aw mao ang yuta nga molamoy sa mga lumulopyo niini. Ang tanan nga mga tawo didto mga tag-as kaayo. ");
INSERT INTO cebulb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Didto nakakita kami ug mga higanti, ang mga kaliwat ni Anak, ang mga tawo nga naggikan sa mga higanti. Sa among pagtan-aw sama lang kami sa mga apan-apan kung itandi kanila, ug mao usab kini kung unsa kita sa ilang panan-aw.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nianang gabhiona nanghilak sa makusog ang tibuok katilingban. ");
INSERT INTO cebulb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Gitamay sa tanang katawhan sa Israel si Moises ug si Aaron. Miingon kanila ang tibuok katilingban, “Maayo pag nangamatay nalang kami didto sa yuta sa Ehipto, o dinhi sa kamingawan! ");
INSERT INTO cebulb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nganong gidala man kami ni Yahweh niining yutaa aron mamatay pinaagi sa espada? Ang among mga asawa ug among gagmay nga mga bata mahimong binihag. Dili ba mas maayo pa man alang kanato ang pagbalik sa Ehipto?” ");
INSERT INTO cebulb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Nag-ingnanay sila sa usag-usa, “Magpili kita ug laing pangulo, ug mamalik kita sa Ehipto.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Unya si Moises ug si Aaron mihapa sa atubangan sa tanang katawhan sa Israel nga nagkatigom. ");
INSERT INTO cebulb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Si Josue ang anak nga lalaki ni Nun ug si Caleb ang anak nga lalaki ni Jefune, nga pipila niadtong gipadala aron mosusi sa yuta, migisi sa ilang mga bisti. ");
INSERT INTO cebulb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Misulti sila sa tibuok katilingban sa katawhan sa Israel. Miingon sila, “Ang yuta nga among giadto ug gisusi maayo kaayo nga yuta. ");
INSERT INTO cebulb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kung mahimuot si Yahweh kanato, dad-on niya kita niining yutaa ug ihatag kini kanato. Ang yuta nga midagayday sa gatas ug dugos. ");
INSERT INTO cebulb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Apan ayaw pagsupil batok kang Yahweh, ug ayaw kahadloki ang mga tawo sa yuta. Pagalamyon nato sila sama kasayon sa pagkaon. Ang ilang panalipod mangatangtang gikan kanila, tungod kay ubanan kita ni Yahweh. Ayaw sila kahadloki.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Apan ang tanang katawhan mibahad sa pagbato kanila aron patyon. Unya mitungha ang himaya ni Yahweh sa tolda nga tagboanan alang sa tanang katawhan sa Israel. ");
INSERT INTO cebulb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Miingon si Yahweh kang Moises, “Hangtod kanus-a ba kining mga tawhana mosalikyaw kanako? Hangtod kanus-a man sila mopakyas sa pagsalig kanako, luyo sa tanang timailhan sa akong gahom nga akong nahimo taliwala kanila? ");
INSERT INTO cebulb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Atakihon ko sila uban sa hampak, isalikway ko sila, ug maghimo ako gikan sa imong kaugalingong banay ug usa ka nasod nga mas bantogan ug mas kusgan pa kay kanila.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Miingon si Moises kang Yahweh, “Kung buhaton nimo kini, makadungog unya ang mga Ehiptohanon mahitungod niini, tungod kay giluwas mo kining mga tawhana gikan kanila pinaagi sa imong gahom. ");
INSERT INTO cebulb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Isulti nila kini sa mga lumulupyo niining yutaa. Nakadungog sila nga ikaw, O Yahweh, nag-uban niining mga tawhana, tungod kay nakita ka nawong sa nawong. Mibarog ang imong panganod ibabaw sa imong katawhan. Nag-una ka kanila ingon nga haligi nga panganod sa pagkaadlaw ug usa ka haligi nga kalayo sa kagabhion. ");
INSERT INTO cebulb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Kung patyon nimo karon kining mga tawhana ingon nga usa lang ka tawo, ang kanasoran unya nga nakadungog sa imong kabantogan mosulti ug moingon, ");
INSERT INTO cebulb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Tungod kay dili madala ni Yahweh kining mga katawhan paingon sa yuta nga iyang gisaad kanila, gipamatay nalang niya sila sa kamingawan.' ");
INSERT INTO cebulb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Karon, gihangyo ko ikaw, gamita ang imong dakong gahom. Kay nag-ingon ka, ");
INSERT INTO cebulb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'Si Yahweh dili daling masuko ug madagayaon sa pagkamatinud-anon sa kasabotan. Pasayloon niya ang mga kalapasan ug ang kasal-anan. Silotan niya ang sad-an sa dihang mosilot siya sa sala sa mga kaliwatan sa ilang mga katigulangan, hangtod sa ikatulo ug ikaupat nga kaliwatan.' ");
INSERT INTO cebulb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Naghangyo ako kanimo, pasayloa ang sala niining mga katawhan tungod sa pagkadako sa imong pagkamatinud-anon sa kasabotan, sama sa kanunay nimong pagpasaylo niining mga tawhana gikan pa sa panahon nga anaa pa sila sa Ehipto hangtod karon.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Miingon si Yahweh, “Pasayloon ko sila sumala sa imong gihangyo, ");
INSERT INTO cebulb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","apan sa tinuod, samtang ako nagpuyo, ug samtang napuno ang tibuok kalibotan sa akong himaya, ");
INSERT INTO cebulb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","kadtong tanang mga tawo nga nakakita sa akong himaya ug mga timailhan sa gahom nga akong gibuhat didto sa Ehipto ug sa kamingawan—gisulayan gihapon nila ako sa napulo ka higayon ug wala sila namati sa akong tingog. ");
INSERT INTO cebulb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Busa mosulti ako nga dili gayod sila makakita sa yuta nga akong gisaad sa ilang mga katigulangan. Walay bisan usa kanila nga nagsalikway kanako ang makakita niini, ");
INSERT INTO cebulb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","gawas sa akong alagad nga si Caleb, tungod kay aduna siyay lahi nga espiritu. Hugot ang iyang pagtuman kanako; dad-on ko siya ngadto sa yuta nga iyang giadto ug gisusi. Makapanag-iya ang iyang kaliwatan niini. ");
INSERT INTO cebulb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Karon ang mga Amalekanhon ug mga Canaanhon nagpuyo didto sa walog.) Ugma balik ug lakaw ngadto sa kamingawan pinaagi sa dalan sa Pulang Dagat.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nakigsulti si Yahweh kang Moises ug kang Aaron. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Hangtod kanus-a ako magpailob niining daotang katilingban nga nagtamay kanako? Nadungog ko ang pagbagulbol sa katawhan sa Israel batok kanako. ");
INSERT INTO cebulb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ingna sila, 'Samtang nagpuyo ako, miingon si Yahweh, 'Sumala sa inyong gisulti nga akong nadungog, buhaton ko kini kaninyo: ");
INSERT INTO cebulb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mangatumba ang inyong patay nga mga lawas dinhi sa kamingawan, kamong tanan nga nagbagulbol batok kanako, kamo nga naapil sa pag-ihap, ang tanang ihap sa katawhan nga nagpanuigon gikan sa 20 ka tuig ug pataas. ");
INSERT INTO cebulb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Dili gayod kamo makaadto sa yuta nga akong gisaad aron mahimo ninyong puluy-anan, gawas lamang kang Caleb ang anak nga lalaki ni Jefune ug kang Josue ang anak nga lalaki ni Nun. ");
INSERT INTO cebulb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Apan ang mga gagmay nga bata nga inyong giingon nga mahimong mga bihag, dad-on ko sila didto sa yuta. Masinatian nila ang yuta nga inyong gisalikway! ");
INSERT INTO cebulb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Alang kaninyo, mangatumba ang inyong mga patay nga lawas dinhi sa kamingawan. ");
INSERT INTO cebulb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Mahimong mga magbalantay ang inyong mga anak dinhi sa kamingawan sulod sa 40 ka tuig. Mag-antos sila sa silot sa inyong pagkamasupilon hangtod sa kataposan sa inyong patay nga mga lawas sa kamingawan. ");
INSERT INTO cebulb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Sama sa gidugayon sa mga adlaw sa pagsusi ninyo sa yuta—40 ka adlaw, pagaantoson usab ninyo ang silot sa inyong mga sala sulod sa 40 ka tuig—usa ka tuig alang sa matag adlaw, ug unya inyong masayran kung unsa ako ingon nga inyong kaaway. ");
INSERT INTO cebulb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ako, si Yahweh, ang nagsulti. Buhaton ko gayod kining tanan alang niining daotang katilingban nga nagkatigom batok kanako. Mangapuo gayod sila, ug dinhi sila mangamatay.''' ");
INSERT INTO cebulb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Busa ang mga lalaki nga gipadala ni Moises aron sa pagtan-aw sa yuta nangamatay pinaagi sa hampak sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Mao kini ang mga lalaki nga mibalik ug midala sa dili maayo nga balita mahitungod sa yuta. Gihimo niini ang mga tawo nga magbagulbol batok kang Moises. ");
INSERT INTO cebulb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Niadtong mga lalaki nga milakaw sa pagsusi sa yuta, si Josue lamang nga anak ni Nun ug si Caleb nga anak ni Jefune ang nabiling buhi. ");
INSERT INTO cebulb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Sa dihang gibalita ni Moises kini nga mga pulong ngadto sa tanang katawhan sa Israel, nagbangotan sila pag-ayo. ");
INSERT INTO cebulb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mibangon sila sa sayo sa buntag ug miadto sa tumoy sa bukid ug miingon, “Tan-awa, ania kita dinhi, ug moadto kita sa dapit nga gisaad ni Yahweh, tungod kay nakasala kita.” ");
INSERT INTO cebulb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Apan miingon si Moises, “Nganong supakon man ninyo karon ang mando ni Yahweh? ");
INSERT INTO cebulb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Dili kamo magmalamposon. Ayaw kamo paglakaw, tungod kay si Yahweh dili mag-uban kaninyo aron ilikay kamo gikan sa pagkapildi batok sa inyong mga kaaway. ");
INSERT INTO cebulb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ang mga Amalekanhon ug mga Canaanhon anaa didto, ug mamatay kamo pinaagi sa espada tungod kay mitalikod kamo gikan sa pagsunod kang Yahweh. Busa dili siya mouban kaninyo.'' ");
INSERT INTO cebulb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Apan nangahas gihapon sila sa pagtungas sa bungtod; apan, bisan si Moises ni ang sudlanan sa kasabotan ni Yahweh wala mibiya sa kampo. ");
INSERT INTO cebulb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Unya milugsong ang mga Amalekanhon, ug ang mga Canaanhon usab nga nagpuyo niadtong mga bungtora. Gisulong nila ang mga Israelita ug napildi sila hangtod sa Horma. ");
INSERT INTO cebulb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Unya nakigsulti si Yahweh ngadto kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Sultihi ang katawhan sa Israel ug ingna sila, 'Sa pag-adto ninyo didto sa yuta nga inyong pagapuy-an, nga ihatag ni Yahweh kaninyo, ");
INSERT INTO cebulb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mag-amdam kamo ug halad pinaagi sa kalayo ngadto kang Yahweh, halad nga sinunog man o halad aron sa pagtuman sa panaad o kabubut-on nga halad, o halad sa inyong kasaulogan, aron makahatag ug makapahimuot nga humot alang kang Yahweh gikan sa panon sa mga mananap o pundok sa mga mananap. ");
INSERT INTO cebulb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Kinahanglan nga maghalad kamo ug halad nga sinunog ngadto kang Yahweh lakip usab ang halad nga trigo nga ikanapulo nga bahin sa epa sa labing maayo nga harina nga sagolan ug lana nga ika 1/4 nga bahin sa usa ka hin. ");
INSERT INTO cebulb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Kinahanglan maghalad usab kamo uban ang halad nga sinunog, o alang sa pagsakripisyo, ika 1/4 nga bahin sa usa ka hin nga bino alang sa halad nga ilimnon alang sa matag nating karnero. ");
INSERT INTO cebulb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kung maghalad kamo ug toro nga karnero, kinahanglan mag-andam usab kamo alang sa halad nga trigo ika 2/10 nga bahin sa usa ka epa sa labing maayo nga harina nga sagolan ug lana nga ikatulo nga bahin sa usa ka hin. ");
INSERT INTO cebulb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Alang sa halad nga ilimnon, kinahanglan maghalad kamo ug bino nga ikatulo nga bahin sa usa ka hin. Maghatag kini ug kahumot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kung mag-andam kamo ug torong baka ingon nga halad sinunog o ingon nga halad aron sa pagtuman sa panaad, o ingon nga halad sa pagpakigdait ngadto kang Yahweh, ");
INSERT INTO cebulb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","unya kinahanglan maghalad kamo ug toro nga baka uban sa halad nga trigo nga ika 3/10 nga bahin sa usa ka epa sa labing maayo nga harina nga gisagolan ug lana nga tunga nga bahin sa usa ka hin. ");
INSERT INTO cebulb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Kinahanglan nga maghalad kamo alang sa halad nga ilimnon nga bino nga tunga sa bahin sa usa ka hin, ingon nga halad nga nahimo pinaagi sa kalayo, aron makahatag ug kahumot alang kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Kinahanglan nga buhaton sa ingon niini nga paagi alang sa matag toro nga baka, sa matag toro nga karnero, ug alang sa matag laki nga mga nating karnero o nating mga kanding. ");
INSERT INTO cebulb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ang matag sakripisyo ug mga halad nga inyong giandam kinahanglan nga buhaton sumala sa gihulagway dinhi. ");
INSERT INTO cebulb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Ang tanan nga mga natawong lumad nga mga Israelita kinahanglan nga magbuhat niini nga mga butang sa ingon niini nga paagi, sa dihang magdala kamo ug halad nga sinunog, aron makahatag ug humot nga makapahimuot kang Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kung ang langyaw magpuyo uban kaninyo, o si bisan kinsa nga magpuyo uban sa tibuok ninyo nga kaliwatan sa katawhan, kinahanglan nga maghalad siya ug sinunog, aron makahatag ug kahumot alang kang Yahweh. Kinahanglan nga magbuhat siya sama sa inyong ginabuhat. ");
INSERT INTO cebulb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kinahanglan adunay sama lamang nga balaod alang sa katilingban ug sa mga langyaw nga nagpuyo uban kaninyo, balaod nga walay kataposan sa tibuok kaliwatan sa inyong katawhan. Sama kaninyo, busa mao usab ang magpapanaw nga nagpuyo uban kaninyo. Kinahanglan nga magbuhat siya sama sa inyong gibuhat sa atubangan ni Yahweh. ");
INSERT INTO cebulb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sama lamang nga balaod ug sugo ang kinahanglan ninyo nga tumanon ug ngadto sa langyaw nga nagpuyo uban kaninyo.'” ");
INSERT INTO cebulb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Misulti na usab si Yahweh ngadto kang Moises. Miingon siya, ");
INSERT INTO cebulb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Sultihi ang katawhan sa Israel ug ingna sila, 'Sa pag-abot ninyo sa yuta nga akong pagadad-an kaninyo, ");
INSERT INTO cebulb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","sa dihang mokaon kamo sa mga pagkaon nga abot niadtong yutaa, kinahanglan nga maghalad kamo ug halad ug ihalad kini kanako. ");
INSERT INTO cebulb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Gikan sa pinakauna ninyong minasa kinahanglan nga maghalad kamo ug tinapay aron nga ibayaw kini ingon nga binayaw nga halad gikan sa giokanan. Kinahanglan nga ibayaw ninyo kini sa ingon niini nga paagi. ");
INSERT INTO cebulb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Kinahanglan nga ihatag ninyo kanako ang binayaw nga halad sa tibuok nga kaliwatan sa inyong katawhan gikan sa pinakauna ninyo nga minasa. ");
INSERT INTO cebulb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Usahay makasala kamo nga wala tuyoa, sa dihang dili ninyo tumanon kining tanan nga mga sugo nga gisulti ko kang Moises— ");
INSERT INTO cebulb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ang tanang mga butang nga akong gisugo kaninyo pinaagi kang Moises gikan niadtong unang adlaw nga gihatag ko kaninyo ang mga sugo ug sa umaabot sa tibuok nga mga kaliwatan sa inyong katawhan. ");
INSERT INTO cebulb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Bahin sa dili tinuyoan nga sala nga wala mahibaloan sa mga katilingban, unya kinahanglan nga ang tanang katilingban maghalad ug usa ka laki nga nating baka ingon nga halad sinunog aron makahatag ug kahumot alang kang Yahweh. Uban niini kinahanglan nga maghimo ug halad nga trigo ug halad nga ilimnon, ingon nga mando sa kasugoan, ug usa ka laki nga kanding ingon nga halad alang sa sala. ");
INSERT INTO cebulb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kinahanglan nga maghimo ug pagpapas sa sala ang pari alang sa tanang katilingban nga katawhan sa Israel. Mapasaylo sila tungod kay ang sala usa lamang ka sayop. Nagdala sila sa ilang mga halad, halad nga sinunog alang kanako. Gidala nila ang ilang halad sa sala sa akong atubangan alang sa ilang kasaypanan. ");
INSERT INTO cebulb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Unya mapasaylo ang tanang katilingban nga katawhan sa Israel, ug lakip na usab ang mga langyaw nga nagpuyo uban kanila, tungod kay ang tanang katawhan nakasala man nga dili tinuyoan. ");
INSERT INTO cebulb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kung makasala ang usa ka tawo nga dili tinuyoan, nan 