﻿USE sofia;
DROP TABLE IF EXISTS sofia.cebocb_vpl;
CREATE TABLE cebocb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cebocb_vpl WRITE;
INSERT INTO cebocb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sa sinugdan gimugna sa Dios ang kalangitan ug ang kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ang kalibotan kaniadto walay porma ug hawan pa. Nalukop kini sa tubig ug gitabonan sa kangitngit. Ug ang Espiritu sa Dios naglihok-lihok diha ibabaw sa katubigan. ");
INSERT INTO cebocb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Unya miingon ang Dios, “Mohayag!” Ug dayon mihayag. ");
INSERT INTO cebocb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nakita sa Dios nga maayo ang kahayag. Unya gibulag niya ang kahayag ug ang kangitngit. ");
INSERT INTO cebocb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gitawag niyag “adlaw” ang kahayag ug ang kangitngit gitawag niyag “gabii.” Milabay ang kagabhion, ug unya miabot ang kabuntagon. Mao kadto ang unang adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Unya miingon ang Dios, “Maanaa ang wanang aron nga mabahin ang tubig.” ");
INSERT INTO cebocb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ug gihimo sa Dios ang wanang nga nagbulag sa tubig sa ibabaw ug sa tubig sa ubos. ");
INSERT INTO cebocb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kini nga wanang gitawag sa Dios nga “kawanangan.” Milabay ang kagabhion, ug unya miabot ang kabuntagon. Mao kadto ang ikaduhang adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Unya miingon ang Dios, “Matingob sa usa ka dapit ang tubig ubos sa kawanangan aron motungha ang mamalang dapit.” Ug natuman kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gitawag niyag “yuta” ang malang dapit ug “mga dagat” ang nangatingob nga tubig. Ug nakita sa Dios nga maayo kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Unya miingon ang Dios, “Manurok sa yuta ang nagkalain-laing mga tanom: mga tanom nga adunay mga liso ug mga kahoy nga mamunga ug prutas nga adunay liso sumala sa ilang matang.” Ug nahitabo kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nanubo sa yuta ang nagkalain-laing matang sa tanom, mga tanom nga adunay liso ug mga kahoy nga mamunga ug prutas nga adunay liso sumala sa ilang matang. Ug nakita sa Dios nga maayo kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Milabay ang kagabhion, ug unya miabot ang kabuntagon. Mao kadto ang ikatulong adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Unya miingon ang Dios, “Motungha sa kalangitan ang kahayag aron sa pagbulag sa adlaw ug sa gabii, ug mahimong ilhanan sa pagsugod sa mga panahon, mga adlaw, ug mga tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Modan-ag sila sa kalangitan sa paghatag ug kahayag sa kalibotan.” Ug natuman kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gihimo sa Dios ang duha ka dagkong suga: ang mas dako nga suga nga mohatag ug kahayag kon adlaw, ug ang gamay nga mohatag ug kahayag kon gabii. Nahimo usab ang mga bitoon. ");
INSERT INTO cebocb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Gipahimutang sa Dios kini nga mga butang sa kalangitan aron sa paghatag ug kahayag sa kalibotan kon adlaw ug gabii, ug aron sa pagbulag sa kahayag ug sa kangitngit. Ug nakita sa Dios nga maayo kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Milabay ang kagabhion, ug unya miabot ang kabuntagon. Mao kadto ang ikaupat nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Unya miingon ang Dios, “Mapuno sa nagkalain-laing mga mananap ang katubigan, ug manglupad sa kahanginan ang nagkalain-laing mga mananap.” ");
INSERT INTO cebocb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Busa gihimo sa Dios ang dagkong mga mananap sa tubig, ug ang tanang matang sa mga mananap nga nagpuyo sa tubig, apil ang tanang matang sa mga mananap nga galupad. Ug nakita sa Dios nga maayo kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Unya gipanalanginan niya kining tanan nga nag-ingon, “Sanay kamo ug pagdaghan, kamong mga mananap sa tubig ug mga mananap nga galupad.” ");
INSERT INTO cebocb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Milabay ang kagabhion, ug unya miabot ang kabuntagon. Mao kadto ang ikalimang adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Unya miingon ang Dios, “Motungha ang nagkalain-laing mga mananap diha sa yuta: ang mga hayop nga buhionon ug mga hayop nga ihalas, ug mga hayop nga nagkamang.” Ug natuman kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gibuhat sa Dios kining tanan nga mga mananap sumala sa ilang matang, ug nakita niya nga maayo kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Unya miingon ang Dios, “Buhaton nato ang tawo sama sa atong dagway. Magmando sila sa mga isda sa dagat, mga langgam sa kalangitan, mga mananap sa tibuok kalibotan nga buhionon man ug ihalas man, ug ang tanang nagkamang sa yuta.” ");
INSERT INTO cebocb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Busa gimugna sa Dios ang tawo, lalaki ug babaye, nga sama sa iyang dagway. ");
INSERT INTO cebocb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ug gipanalanginan niya sila nga nag-ingon, “Sanay kamo ug pagdaghan aron malukop sa inyong kaliwatan ang kalibotan. Dumalaha ninyo kini ug kamo ang magmando sa tanang matang sa mananap sa tubig, sa kalangitan ug sa yuta man.” ");
INSERT INTO cebocb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Unya miingon ang Dios, “Gihatag ko kaninyo ang tanang mga tanom nga adunay liso ug tanang bunga sa mga kahoy ingon nga inyong pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ug gihatag ko usab sa tanang mga mananap sa yuta ug sa kalangitan ang lunhawng tanom ingon nga ilang pagkaon.” Ug natuman kini. ");
INSERT INTO cebocb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gitan-aw sa Dios ang tanan niyang gibuhat ug nakita niya nga maayo gayod kini. Milabay ang kagabhion, ug unya miabot ang kabuntagon. Mao kadto ang ikaunom nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nahuman sa Dios ang kalangitan, ang kalibotan, ug ang tanan nga anaa niini. ");
INSERT INTO cebocb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nahuman niya kini sulod sa unom ka adlaw, ug mipahulay siya sa ikapito nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gipanalanginan niya ang ikapito nga adlaw ug iya kining gibalaan nga adlaw, tungod kay niining adlawa mipahulay siya human niya gimugna ang tanan. ");
INSERT INTO cebocb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mao kini ang sugilanon mahitungod sa pagmugna sa kalangitan ug sa kalibotan. Sa dihang gimugna sa Ginoong Dios ang kalibotan ug ang kalangitan, ");
INSERT INTO cebocb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wala pa ang tanan nga klasi sa tanom nga nagturok sa yuta, kay ang Ginoong Dios wala pa man nagpaulan niini ug wala pay tawo nga moatiman niini. ");
INSERT INTO cebocb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Apan bisan walay ulan, adunay mga tubod nga nagpabasa sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Unya gibuhat sa Ginoong Dios ang tawo gikan sa yuta. Gihuypan niya ang ilong sa tawo sa gininhawa nga naghatag ug kinabuhi, ug ang tawo nahimo nga buhing binuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Unya nagbuhat ang Ginoong Dios ug tanaman sa Eden, sa sidlakan, ug gipapuyo niya didto ang tawo nga iyang gibuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Gipatubo sa Ginoong Dios ang tanang matang sa mga kahoy nga nindot tan-awon ug ang ilang mga bunga maayong kan-on. Sa taliwala sa tanaman adunay kahoy nga naghatag ug kinabuhi ug kahoy nga naghatag sa kahibalo kon unsa ang maayo ug daotan. ");
INSERT INTO cebocb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Adunay nagdagayday nga suba didto sa Eden nga naghatag ug tubig sa tanaman. Kini nga suba nagsanga sa upat ka bahin. ");
INSERT INTO cebocb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ang ngalan sa unang suba mao ang Pishon. Nagdagayday kini sa tibuok nga yuta sa Havila diin adunay bulawan. ");
INSERT INTO cebocb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Maayong klasi ang bulawan niadtong dapita ug adunay usa ka pahumot nga bediliyum ug mahalon nga bato. ");
INSERT INTO cebocb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ang ngalan sa ikaduhang suba mao ang Gihon. Nagdagayday kini sa tibuok nga yuta sa Cush. ");
INSERT INTO cebocb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ang ngalan sa ikatulong suba mao ang Tigris. Nagdagayday kini sa sidlakang bahin sa Asiria. Ug ang ikaupat nga suba mao ang Eufrates. ");
INSERT INTO cebocb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Gipapuyo sa Ginoong Dios sa tanaman sa Eden ang tawo nga iyang gibuhat aron mag-ugmad ug mag-atiman niini. ");
INSERT INTO cebocb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Unya gimandoan sa Ginoong Dios ang tawo, “Mahimo mong kaonon ang bunga sa bisan unsa nga kahoy sa tanaman, ");
INSERT INTO cebocb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","gawas lang sa bunga sa kahoy nga naghatag ug kahibalo kon unsay maayo ug daotan. Kay sa higayon nga kan-on mo kini, sigurado gayod nga mamatay ka.” ");
INSERT INTO cebocb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Unya miingon ang Ginoong Dios, “Dili maayo nga mag-inusara ang tawo. Buhatan ko siya ug katabang nga angay kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Gibuhat sa Ginoong Dios gikan sa yuta ang tanang matang sa mga mananap nga nagpuyo sa yuta ug ang tanang matang sa mga mananap nga galupad. Unya gidala niya sila ngadto sa tawo aron panganlan kini. Kon unsay gipangalan sa tawo kanila mao nay tawag kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Busa ginganlan sa tawo ang tanang mananap nga nagpuyo sa yuta apil ang mga mananap nga galupad. Apan walay usa niining mga mananap nga angay mahimong kaabag ni Adan. ");
INSERT INTO cebocb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Busa gipakatulog sa Ginoong Dios ang tawo. Ug samtang nahinanok siya, gikuha sa Ginoong Dios ang usa sa iyang mga gusok, ug unya gibalik ug kipot ang bahin nga gikuhaan niini. ");
INSERT INTO cebocb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ang gusok nga gikuha gikan sa lalaki gibuhat sa Ginoong Dios nga usa ka babaye, ug gidala niya kini sa lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Unya miingon ang lalaki, “Ania na gayod! Bukog nga gikuha sa akong bukog, ug unod nga gikuha sa akong unod. Tawgon siya nga babaye, kay gikuha siya gikan sa lalaki.” ");
INSERT INTO cebocb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Busa mao kini ang hinungdan nga mobiya ang lalaki gikan sa iyang amahan ug inahan ug makighiusa sa iyang asawa, ug silang duha mahimong usa. ");
INSERT INTO cebocb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ug hubo ang lalaki ug ang iyang asawa, apan wala sila maulaw. ");
INSERT INTO cebocb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sa tanang mga mananap nga gibuhat sa Ginoong Dios, ang bitin mao ang labing limbongan. Usa niadto ka higayon, gipangutana sa bitin ang babaye, “Tinuod ba gayod nga gidid-an kamo sa Dios nga mokaon sa bunga sa bisan unsa nga kahoy sa tanaman?” ");
INSERT INTO cebocb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mitubag ang babaye, “Makakaon kami sa mga bunga sa kahoy dinhi sa tanaman, ");
INSERT INTO cebocb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","gawas lang sa bunga sa kahoy nga anaa sa taliwala niini. Kay miingon ang Dios, ‘Dili gayod kamo mokaon sa bunga niana nga kahoy o bisan mohikap man lang. Kon himuon ninyo kana, mamatay kamo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Apan miingon ang bitin, “Dili tinuod nga mamatay kamo! ");
INSERT INTO cebocb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Miingon ang Dios niana tungod kay nahibalo siya nga kon mokaon kamo niini, maabli ang inyong salabotan ug mahimo kamong sama kaniya nga nahibalo kon unsa ang maayo ug daotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sa dihang nakita sa babaye nga ang bunga sa kahoy nindot tan-awon ug maayo kan-on, ug tungod kay tinguha niya nga mahimong maalamon, mikuha siya ug bunga ug mikaon. Gihatagan usab niya ang iyang bana nga uban kaniya, ug mikaon usab kini. ");
INSERT INTO cebocb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pagkahuman gayod nilag kaon, naabli ang ilang salabotan ug nasayran nila nga hubo diay sila. Busa naghimo silag tapis gikan sa mga dahon sa kahoy nga igos alang sa ilang lawas. ");
INSERT INTO cebocb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sa dihang bugnaw na ang hangin sa kahaponon, nadungog nila nga galakaw ang Ginoong Dios sa tanaman. Busa nanago sila sa kakahoyan. ");
INSERT INTO cebocb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Apan gitawag sa Ginoong Dios ang lalaki ug gipangutana, “Hain ka?” ");
INSERT INTO cebocb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mitubag ang lalaki, “Nadungog ko ikaw nga galakaw sa tanaman, ug nahadlok ko kay ako hubo, busa mitago ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nangutana ang Ginoong Dios, “Kinsay nag-ingon kanimo nga hubo ka? Mikaon ka ba sa bunga sa kahoy nga giingon ko nga dili mo kan-on?” ");
INSERT INTO cebocb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mitubag ang lalaki, “Ang babaye nga gipauban mo kanako maoy naghatag sa bunga niadtong kahoy ug mikaon ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Gipangutana sa Ginoong Dios ang babaye, “Unsa man kining imong gibuhat?” Mitubag ang babaye, “Giilad ako sa bitin, busa mikaon ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Busa miingon ang Ginoong Dios ngadto sa bitin, “Tungod kay gibuhat mo kini, “Tinunglo ka labaw sa tanang mga mananap. Ikaw lang gayod ang mahiagom niini nga tunglo: sa tibuok mong kinabuhi, magkamang ka pinaagi sa imong tiyan ug magkaon kag abog. ");
INSERT INTO cebocb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ikaw ug ang babaye mahimong magkaaway; ug ang imong kaliwat ug ang iyang kaliwat magkaaway usab. Dugmokon niya ang imong ulo ug paakon mo ang iyang tikod.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Miingon usab siya sa babaye, “Tungod sa imong gibuhat, dugangan ko ang kalisod sa imong pagpanamkon ug ang kasakit sa pagpanganak. Ug bisan pa niana, mangandoy ka gihapon sa imong bana, ug siya ang mogahom kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Miingon usab siya kang Adan, “Tungod kay naminaw ka sa imong asawa ug mikaon sa bunga sa kahoy nga gidili ko kanimo: “Tunglohon ko ang yuta tungod kanimo. Sa tibuok mong kinabuhi, maghago ka ug maayo aron ka makakaon. ");
INSERT INTO cebocb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Moturok sa yuta ang mga sagbot ug mga sampinit, ug mokaon ka ug mga tanom gikan sa kaumahan. ");
INSERT INTO cebocb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kinahanglan nga maghago ka ug maayo sa dugay nga panahon una ka makakaon, hangtod nga mobalik ka sa yuta nga mao ang imong gigikanan. Kay sa abog ka gikan, sa abog ka usab mobalik.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ginganlan sa lalaki ang iyang asawa ug “Eba” tungod kay siya ang mahimong inahan sa tanang mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Unya gihimoan sa Ginoong Dios ug bisti nga gikan sa panit sa mananap alang kang Adan ug sa iyang asawa. ");
INSERT INTO cebocb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Unya miingon ang Ginoong Dios, “Karon, ang tawo sama na kanato nga nahibalo kon unsa ang maayo ug ang daotan. Kinahanglan nga dili gayod siya tugotan nga makakaon sa bunga sa kahoy nga naghatag ug kinabuhi, kay kon mokaon siya, magpabilin siyang buhi hangtod sa kahangtoran.” ");
INSERT INTO cebocb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Busa gipapahawa sa Ginoong Dios gikan sa tanaman sa Eden ang tawo aron sa pagpanguma sa yuta nga mao ang iyang gigikanan. ");
INSERT INTO cebocb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Sa dihang napapahawa na niya ang tawo, nagbutang ang Ginoong Dios ug mga kerubin sa sidlakang bahin sa tanaman sa Eden. Nagbutang usab siya ug espada nga nagdilaab ug nagtuyok-tuyok aron walay makaduol sa kahoy nga naghatag ug kinabuhi. ");
INSERT INTO cebocb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Pagkahuman niadto, nakigdulog ang lalaki sa iyang asawa nga si Eba ug namabdos kini. Sa dihang nakapanganak na si Eba, miingon siya, “Nakaangkon ako ug anak nga lalaki pinaagi sa tabang sa Ginoo, busa nganlan ko siya ug Cain.” ");
INSERT INTO cebocb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nanganak pag-usab si Eba ug lalaki ug ginganlan niya kini ug Abel. Sa dihang nanagko na sila, si Abel nahimong magbalantay sa mga karnero ug mga kanding, ug si Cain nahimong mag-uuma. ");
INSERT INTO cebocb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Usa niadto ka adlaw, nagdala si Cain ug halad ngadto sa Ginoo gikan sa abot sa iyang uma. ");
INSERT INTO cebocb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Nagkuha usab si Abel ug pipila sa unang anak sa iyang mga kahayopan. Giihaw niya kini, ug gihalad ang pinakamaayo nga bahin ngadto sa Dios. Nalipay ang Ginoo kang Abel ug sa iyang halad, ");
INSERT INTO cebocb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","apan wala siya malipay kang Cain ug sa iyang halad. Ug tungod niini, nasuko pag-ayo si Cain ug nagmug-ot. ");
INSERT INTO cebocb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Busa gipangutana siya sa Ginoo, “Nganong nasuko ka ug nagmug-ot? ");
INSERT INTO cebocb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kon maayo lang ang imong gibuhat, magmalipayon ka unta. Apan pagbantay! Kay kon dili maayo ang imong ginabuhat, ang sala mogahom kanimo. Kay ang sala daw sama sa mabangis nga mananap nga nag-atang kanimo aron tukbon ka. Busa kinahanglan duminahon mo kini.” ");
INSERT INTO cebocb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Usa niana ka adlaw, miingon si Cain kang Abel, “Dali, mangadto ta sa uma.” Ug sa dihang didto na sila, gipatay ni Cain si Abel nga iyang igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Unya nangutana ang Ginoo kang Cain, “Hain ang imong igsoon nga si Abel?” Mitubag si Cain, “Ambot, wala ako masayod kon hain siya. Ngano, ako bay magbalantay kaniya?” ");
INSERT INTO cebocb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Unya miingon ang Ginoo kang Cain, “Unsay imong gibuhat? Ang dugo sa imong igsoon diha sa yuta daw sa tingog nga nagpakiluoy kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tungod sa imong gibuhat, tunglohon ka nako. Sukad karon dili mo na maugmad ang yuta nga nagsuyop sa dugo sa imong igsoon nga imong gipatay. ");
INSERT INTO cebocb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bisan magtanom ka pa, ang yuta dili na mohatag kanimo ug maayong abot. Ug wala kanay permanente nga puloy-anan, busa maglatagaw ka na lang.” ");
INSERT INTO cebocb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Miingon si Cain sa Ginoo, “Bug-at ra kaayo kana nga silot. ");
INSERT INTO cebocb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Giabog mo ako karon gikan niini nga yuta ug sa imong presensya. Wala na akoy permanente nga puloy-anan, busa maglatagaw na lang ako. Ug kon adunay makakita kanako sigurado nga patyon niya ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Apan miingon ang Ginoo kang Cain, “Dili kana mahitabo! Kay si bisan kinsa nga mopatay kanimo, balosan ko ug pito ka pilo.” Busa gibutangan sa Ginoo ug ilhanan si Cain aron dili siya patyon ni bisan kinsa nga makakita kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Unya nagpahilayo si Cain gikan sa Ginoo ug didto mipuyo sa yuta sa Nod, sa sidlakang bahin sa Eden. ");
INSERT INTO cebocb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Unya, nakighilawas si Cain sa iyang asawa. Namabdos ang iyang asawa ug nanganak ug lalaki ug ginganlan nila kinig Enoc. Nagtukod si Cain ug usa ka lungsod ug ginganlan niya kinig Enoc sama sa ngalan sa iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Unya nakabaton si Enoc ug anak nga lalaki ug ang iyang ngalan si Irad. Kini si Irad amahan ni Mehujael; si Mehujael amahan ni Metushael; ug si Metushael amahan ni Lamec. ");
INSERT INTO cebocb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Si Lamec adunay duha ka asawa nga mao sila si Ada ug Zila. ");
INSERT INTO cebocb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Si Ada nanganak kang Jabal nga mao ang katigulangan niadtong mga tawo nga nagpuyo sa mga tolda ug nag-atiman ug mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Adunay igsoon si Jabal nga lalaki nga ang ngalan si Jubal, nga mao ang katigulangan sa tanan nga nagtukar sa harpa ug plawta. ");
INSERT INTO cebocb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Zila nanganak usab ug lalaki nga ang ngalan si Tubal Cain. Kini si Tubal Cain tigbuhat sa tanang matang sa galamiton nga puthaw ug bronsi. Aduna siyay igsoon nga babaye nga si Naama. ");
INSERT INTO cebocb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Usa niadto ka adlaw, miingon si Lamec sa iyang duha ka asawa, “Ada ug Zila, nga akong mga asawa, pamati kamo kanako. Gipatay ko ang usa ka batan-ong lalaki tungod sa iyang pagdagmal kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kon pito ka pilo ang balos alang sa tawo nga mopatay kang Cain, setentay syete ka pilo ang balos alang sa tawo nga mopatay kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nakighilawas si Adan kang Eba, ug nanganak si Eba ug lalaki. Miingon siya, “Gihatagan ako pag-usab sa Dios ug anak nga lalaki puli kang Abel nga gipatay ni Cain, busa nganlan ko siya ug Set.” ");
INSERT INTO cebocb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Si Set nakabaton usab ug anak nga iyang ginganlan ug Enos. Sa panahon nga natawo si Enos, nagsugod ang mga tawo ug tawag sa ngalan sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Mao kini ang gisulat nga istorya mahitungod sa mga kaliwat ni Adan. Sa paghimo sa Dios sa tawo, gihimo niya kining sama kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gihimo niya ang lalaki ug babaye, ug gipanalanginan niya sila ug gitawag nga “tawo.” ");
INSERT INTO cebocb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sa dihang nag-edad na si Adan ug 130 ka tuig, natawo ang iyang anak nga liwat gayod kaniya. Ginganlan niya kinig Set. ");
INSERT INTO cebocb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Human matawo si Set, nabuhi pa si Adan ug 800 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Namatay siya sa edad nga 930. ");
INSERT INTO cebocb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sa dihang nag-edad na si Set ug 105 ka tuig, natawo ang iyang anak nga lalaki nga si Enos. ");
INSERT INTO cebocb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Human matawo si Enos, nabuhi pa si Set ug 807 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Namatay siya sa edad nga 912. ");
INSERT INTO cebocb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sa dihang nag-edad na si Enos ug 90 ka tuig, natawo ang iyang anak nga lalaki nga si Kenan. ");
INSERT INTO cebocb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Human matawo si Kenan, nabuhi pa si Enos ug 815 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Namatay siya sa edad nga 905. ");
INSERT INTO cebocb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sa dihang nag-edad na si Kenan ug 70 ka tuig, natawo ang iyang anak nga lalaki nga si Mahalalel. ");
INSERT INTO cebocb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Human matawo si Mahalalel, nabuhi pa si Kenan ug 840 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Namatay siya sa edad nga 910. ");
INSERT INTO cebocb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sa dihang nag-edad na si Mahalalel ug 65 ka tuig, natawo ang iyang anak nga lalaki nga si Jared. ");
INSERT INTO cebocb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Human matawo si Jared, nabuhi pa si Mahalalel ug 830 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Namatay siya sa edad nga 895. ");
INSERT INTO cebocb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sa dihang nag-edad na si Jared ug 162 ka tuig, natawo ang iyang anak nga lalaki nga si Enoc. ");
INSERT INTO cebocb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Human matawo si Enoc, nabuhi pa si Jared ug 800 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Namatay siya sa edad nga 962. ");
INSERT INTO cebocb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Sa dihang nag-edad na si Enoc ug 65 ka tuig, natawo ang iyang anak nga lalaki nga si Metusela. ");
INSERT INTO cebocb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Human matawo si Metusela, nagkinabuhi pa si Enoc ug 300 ka tuig ug nadugangan pa ang iyang mga anak. Nabuhi si Enoc nga adunay suod nga relasyon sa Dios, ug sa nag-edad na siya ug 365 ka tuig nahanaw siya, kay gikuha siya sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Sa dihang nag-edad na si Metusela ug 187 ka tuig, natawo ang iyang anak nga lalaki nga si Lamec. ");
INSERT INTO cebocb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Human matawo si Lamec, nabuhi pa si Metusela ug 782 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Namatay siya sa edad nga 969. ");
INSERT INTO cebocb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Sa dihang nag-edad na si Lamec ug 182 ka tuig, natawo ang usa niya ka anak nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Miingon siya, “Kining bataa makatabang kanato gikan sa atong labihan nga kahago tungod sa pagtunglo sa Ginoo sa yuta, busa nganlan ko siya ug Noe.” ");
INSERT INTO cebocb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Human matawo si Noe, nabuhi pa si Lamec ug 595 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Namatay siya sa edad nga 777. ");
INSERT INTO cebocb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Sa nakaabot na si Noe ug 500 ka tuig, natawo ang iyang mga anak nga lalaki nga sila si Sem, Ham, ug Jafet. ");
INSERT INTO cebocb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Unya, midaghan ang mga tawo sa kalibotan, ug daghan silag mga anak nga babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Nakita sa mga anak sa Dios nga maanyag ang mga babaye. Busa gipangasawa nila si bisan kinsa nga ilang nagustohan. ");
INSERT INTO cebocb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Unya miingon ang Ginoo, “Dili ko tugotan nga mabuhi ang tawo hangtod sa kahangtoran tungod kay tawo lang sila. Busa sukad karon magkinabuhi na lang sila ug dili mosobra sa 120 ka tuig.” ");
INSERT INTO cebocb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Niadtong panahona, ug bisan sa misunod pa nga mga panahon, adunay mga Nefilim sa kalibotan. Mga kaliwat sila sa mga anak sa Dios nga nakighilawas sa maanyag nga mga babaye. Gamhanan ug bantogan sila. ");
INSERT INTO cebocb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nakita sa Ginoo nga labihan kadaotan ang mga tawo sa kalibotan, ug kangil-ad ang anaa kanunay sa ilang mga huna-huna. ");
INSERT INTO cebocb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Naguol ang Ginoo nga gibuhat niya ang tawo ug nasubo siya pag-ayo. ");
INSERT INTO cebocb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Busa miingon ang Ginoo, “Laglagon ko ang tanang mga tawo nga akong gibuhat, apil ang tanang mga mananap sa yuta ug ang mga mananap nga galupad, kay naguol ako nga gibuhat ko sila.” ");
INSERT INTO cebocb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Apan adunay usa ka tawo nga nakapahimuot sa Ginoo, siya mao si Noe. ");
INSERT INTO cebocb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Mao kini ang sugilanon mahitungod sa pamilya ni Noe. Si Noe diosnon nga tawo. Siya lang ang nagkinabuhi nga matarong ug walay sala sa iyang henerasyon, ug suod ang iyang relasyon sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Aduna siyay tulo ka anak nga lalaki nga sila si Sem, Ham, ug Jafet. ");
INSERT INTO cebocb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Sa panan-aw sa Dios, daotan gayod ang mga tawo ug nalukop ang kalibotan sa ilang kadaotan. ");
INSERT INTO cebocb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nakita sa Dios nga daotan na gayod ang mga tawo sa kalibotan tungod kay labihan na gayod kangil-ad ang tanan nilang mga binuhatan. ");
INSERT INTO cebocb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Busa miingon siya kang Noe, “Laglagon ko ang tanang mga tawo. Kay tungod kanila, napuno sa kadaotan ang kalibotan. Laglagon ko sila uban niining kalibotana. ");
INSERT INTO cebocb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Busa Noe, pagbuhat ug arka gamit ang maayong klasi sa kahoy, ug buhati kini ug mga kuwarto. Unya pahiri ug alkitran ang sulod ug gawas sa arka. ");
INSERT INTO cebocb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Buhata ang arka nga adunay gitas-on nga 450 ka piye, ang iyang gilapdon 75 ka piye, ug ang iyang gihabugon 45 ka piye. ");
INSERT INTO cebocb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atopi ang arka, ug inigbutang mo sa dingding, pagbilin ug 18 ka pulgada nga gintang gikan sa atop. Himoang tulo ka andana ang arka, ug butangi ug pultahan sa kilid. ");
INSERT INTO cebocb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Palunopan ko ang kalibotan aron malaglag ang tanan nga adunay kinabuhi. Mamatay ang tanan nga anaa sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Apan magbuhat ako ug kasabotan kanimo. Mosulod ka sa arka uban ang imong asawa ug ang imong mga anak uban sa ilang mga asawa. ");
INSERT INTO cebocb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Pagpasulod usab ug tag-usa ka pares, lalaki ug babaye, sa matag matang sa mga mananap aron mabuhi sila uban kanimo. Moduol kanimo ang duha sa matag matang sa tanang mga mananap nga galupad, naglakaw, ug nagkamang. ");
INSERT INTO cebocb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Pagdala usab sa tanang matang sa pagkaon alang kaninyo ug alang usab sa mga mananap.” ");
INSERT INTO cebocb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ug gituman ni Noe ang tanan nga gisugo sa Dios kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Miingon ang Ginoo kang Noe, “Sulod na sa arka uban sa imong tibuok nga pamilya, tungod kay sa tanang mga tawo niining henerasyon, ikaw ra ang nakita ko nga matarong. ");
INSERT INTO cebocb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pagdala ug pito ka pares sa matag matang sa hinlo nga mananap, apan usa lang ka pares sa matag matang sa dili hinlo nga mananap. ");
INSERT INTO cebocb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pagdala usab ug pito ka pares sa matag matang sa mananap nga galupad aron dili mawala kining matang sa mga mananap sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kay pito ka adlaw gikan karon, paulanan ko ang tibuok kalibotan sulod sa 40 ka adlaw ug 40 ka gabii, aron papason gikan sa kalibotan ang tanan kong gibuhat nga adunay kinabuhi.” ");
INSERT INTO cebocb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Gituman ni Noe ang tanan nga gisugo sa Ginoo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nag-edad si Noe ug 600 ka tuig sa dihang miabot ang lunop sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Misulod siya sa arka uban ang iyang asawa ug mga anak uban ang ilang mga asawa aron dili sila mangamatay sa lunop. ");
INSERT INTO cebocb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Sumala sa gisugo sa Dios, gipasulod ni Noe sa arka ang matag pares sa tanang matang sa mananap nga hinlo ug dili hinlo nga miduol kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ug paglabay sa pito ka adlaw, gilunopan ang kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nag-edad niadto si Noe ug 600 ka tuig. Ug sa ika-17 nga adlaw sa ikaduha nga bulan, mibunok ang labihan gayod kakusog nga ulan ug miapaw ang tubig sa tanang tuboran. ");
INSERT INTO cebocb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nag-ulan sa kalibotan sulod sa 40 ka adlaw ug 40 ka gabii. ");
INSERT INTO cebocb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Sa adlaw mismo nga nagsugod ang ulan, misulod sa arka si Noe ug ang iyang asawa uban sa tulo nila ka mga anak nga sila si Sem, Ham, ug Jafet, ug ang ilang mga asawa. ");
INSERT INTO cebocb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Kauban usab nila ang tanang matang sa mananap: ang naglakaw, nagkamang, ug galupad. ");
INSERT INTO cebocb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Sumala sa gisugo sa Dios kang Noe, gipasulod niya sa arka ang matag pares sa tanang matang sa mananap nga miduol kaniya. Pagkahuman, gisirad-an sa Ginoo ang arka. ");
INSERT INTO cebocb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Nagpadayon pag-ulan sa kalibotan sulod sa 40 ka adlaw. Milawom ang tubig hangtod nga milutaw ang arka. ");
INSERT INTO cebocb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Milawom pa gayod ang tubig hangtod nga nalapawan ang tanang tag-as nga mga bukid, ");
INSERT INTO cebocb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ug milapaw pa gayod ang tubig ug mga 20 ka piye gikan sa tumoy sa kinatas-ang bukid. ");
INSERT INTO cebocb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Busa nangamatay ang tanan nga adunay kinabuhi: mananap nga tigpanon sa ibabaw sa yuta, mga langgam, mga mananap, ug ang nagkamang sa yuta, ug ang tanang mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nangamatay ang tanang adunay gininhawa. ");
INSERT INTO cebocb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gilaglag sa Dios ang tanang mga tawo ug ang tanang mga mananap sa kalibotan. Si Noe lang ug ang iyang mga kauban sa sulod sa arka ang nahibiling buhi. ");
INSERT INTO cebocb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Gilunopan ang kalibotan sulod sa 150 ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Wala kalimti sa Dios si Noe ug ang tanan nga mga mananap nga kauban niya sulod sa arka. Busa gipahuyop niya ang hangin ibabaw sa kalibotan ug naghinay-hinay ug hubas ang tubig. ");
INSERT INTO cebocb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Gisampongan niya ang mga tuboran ug gipaundang ang ulan. ");
INSERT INTO cebocb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Padayon nga mihubas ang tubig sulod sa 150 ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ug sa ika-17 nga adlaw sa ikapito nga bulan, nahitungtong ang arka sa Bukid sa Ararat. ");
INSERT INTO cebocb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Padayon nga mihubas ang tubig. Ug sa unang adlaw sa ika-10 nga bulan, nakita na ang tumoy sa mga bukid. ");
INSERT INTO cebocb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Paglabay sa 40 pa gayod ka adlaw, giablihan ni Noe ang bintana sa arka ");
INSERT INTO cebocb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ug gibuhian ang usa ka uwak. Mibalik-balik ra ug lupad ang uwak hangtod nga mihubas ang tubig. ");
INSERT INTO cebocb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Unya gibuhian ni Noe ang usa ka salampati aron mahibaloan niya kon mihubas na ang tubig, ");
INSERT INTO cebocb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","apan walay matugdonan ang salampati tungod kay nalukop pa sa tubig ang tibuok kalibotan. Busa mibalik ang salampati kang Noe ngadto sa arka. Gipatugdon ni Noe ang salampati sa iyang kamot ug gisulod kini pagbalik sa arka. ");
INSERT INTO cebocb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Gipalabay pa ni Noe ang pito ka adlaw ug unya gibuhian niya pag-usab ang salampati. ");
INSERT INTO cebocb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pagkakilom-kilom, mibalik ang salampati nga gatangag ug lunhawng dahon sa olibo. Busa nahibaloan ni Noe nga mihubas na ang tubig. ");
INSERT INTO cebocb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Gipalabay pa ni Noe ang laing pito ka adlaw ug gibuhian niya pag-usab ang salampati, apan wala na kini mobalik. ");
INSERT INTO cebocb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Sa unang adlaw sa unang bulan, mihubas na gayod ang tubig. Nag-edad na si Noe ug 601 ka tuig. Giablihan ni Noe ang tabon sa arka ug nakita niya nga mala na ang yuta. ");
INSERT INTO cebocb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sa ika-27 nga adlaw sa ikaduha nga bulan mala na gayod ang yuta sa tibuok kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Unya miingon ang Dios kang Noe, ");
INSERT INTO cebocb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gawas na kamong tanan sa arka. ");
INSERT INTO cebocb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ug pagawasa usab ang tanang mga mananap aron mosanay sila ug malukop nila ang tibuok kalibotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Busa migawas si Noe uban sa iyang asawa, mga anak nga lalaki ug mga umagad. ");
INSERT INTO cebocb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Migawas usab ang tanang mga mananap: ang naglakaw, naglupad, ug nagkamang. Nanggawas sila sumala sa ilang matang. ");
INSERT INTO cebocb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nagbuhat si Noe ug halaran alang sa Ginoo. Unya mikuha siya ug usa sa matag matang sa hinlo nga mananap apil usab sa matag matang sa langgam nga hinlo ug gisunog niya kini sa halaran ingon nga halad sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Sa dihang napanimahoan sa Ginoo ang kahumot niini, miingon siya sa iyang kaugalingon, “Dili ko na gayod tunglohon pag-usab ang yuta tungod sa binuhatan sa tawo. Bisan pa ug daotan siya sukad pa sa iyang pagkabata, dili ko na gayod laglagon pag-usab ang tanang adunay kinabuhi sama sa akong gibuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Samtang anaa pa ang kalibotan, aduna kanunay panahon sa tingtanom ug ting-ani, adunay tingtugnaw ug ting-init, adunay tinghulaw ug ting-ulan, ug adunay adlaw ug gabii.” ");
INSERT INTO cebocb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Unya, gipanalanginan sa Dios si Noe ug ang iyang mga anak ug giingnan, “Panganak kamo aron mosanay ug malukop ang kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mahadlok kaninyo ang tanang mga mananap: ang naglakaw, ang naglupad, ang nagkamang, ug ang nagpuyo sa tubig. Gitugyan ko sila kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gihatag ko kaninyo ang mga mananap ingon nga inyong pagkaon, maingon nga gihatag ko kaninyo ang lunhawng mga tanom ingon nga pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Apan ayaw gayod ninyo kan-a ang karne sa mananap nga wala nakagawas ang dugo, tungod kay ang dugo simbolo sa kinabuhi. ");
INSERT INTO cebocb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Paninglan ko gayod si bisan kinsa nga mopatay kaninyo, tawo man o mananap. Paninglan ko si bisan kinsa nga mopatay sa iyang isigka-tawo. ");
INSERT INTO cebocb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Si bisan kinsa nga mopatay sa iyang isigka-tawo kinahanglan patyon usab sa iyang isigka-tawo. Kay ang tawo gibuhat sa Dios nga sama kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Panganak kamo aron mosanay ug malukop ninyo ang kalibotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Miingon pa gayod ang Dios kang Noe ug sa iyang mga anak, ");
INSERT INTO cebocb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","11","“Mao kini ang akong kasabotan kaninyo ug sa inyong mga kaliwat, ingon man sa tanang mga mananap nga migawas uban kaninyo gikan sa arka: Dili ko na gayod laglagon pag-usab ang tanang mga buhing binuhat pinaagi sa lunop. Ug wala na gayoy lunop nga mahitabo aron sa paglaglag sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","“Ug ingon nga ilhanan sa akong kasabotan kaninyo ug sa tanang matang sa mga mananap, ug sa tanan ninyong umaabot nga mga kaliwat, ibutang ko ang akong bangaw sa mga panganod. ");
INSERT INTO cebocb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kon padag-omon ko ug magpakita ang bangaw diha sa kalangitan, ");
INSERT INTO cebocb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","hinumdoman ko dayon ang akong kasabotan kaninyo ug sa tanang matang sa mga mananap, nga dili na gayod mahitabo pag-usab ang lunop nga molaglag sa tanang buhing binuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kon magpakita ang bangaw diha sa mga panganod, hinumdoman ko dayon ang akong walay kataposan nga kasabotan sa tanan nga adunay kinabuhi sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","“Ang bangaw mao ang ilhanan sa akong kasabotan sa tanan nga nagkinabuhi sa kalibotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Mao kini ang mga anak ni Noe nga kauban niya sa arka: si Sem, si Ham, ug si Jafet. (Si Ham mao ang amahan ni Canaan.) ");
INSERT INTO cebocb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Kanila naggikan ang tanang mga tawo sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Si Noe usa ka mag-uuma ug siya mao ang una nga nagtanom ug ubas. ");
INSERT INTO cebocb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Usa ka higayon niana, miinom siya ug bino, nahubog, ug natulog nga hubo sulod sa iyang tolda. ");
INSERT INTO cebocb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Unya, si Ham nga amahan ni Canaan misulod sa tolda, ug nakita niya nga hubo ang iyang amahan. Busa migawas siya ug gisuginlan niya ang duha niya ka igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Mikuha si Sem ug si Jafet ug panapton ug gibutang nila kini sa ilang abaga, unya milakaw sila nga paatras pasulod sa tolda ug gitabonan nila ang ilang amahan. Wala sila milingi ug wala nila makita ang pagkahubo sa ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sa dihang nahuwasan na si Noe sa iyang kahubog, ug sa pagkahibalo niya sa gibuhat sa iyang kamanghoran nga anak, ");
INSERT INTO cebocb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","miingon siya, “Tinunglo ka Canaan! Mahimo kang labing ubos nga ulipon sa imong mga igsoon.” ");
INSERT INTO cebocb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ug miingon usab siya, “Dalaygon ang Ginoo, ang Dios ni Sem. Hinaut pa nga mahimong ulipon ni Sem si Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hinaut nga padaghanon sa Dios ang kayutaan ni Jafet, ug mahimong maayo ang panag-uban sa iyang mga kaliwat ug sa mga kaliwat ni Sem. Hinaut nga mahimo usab niyang ulipon si Canaan.” ");
INSERT INTO cebocb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nabuhi pa ug laing 350 ka tuig si Noe human sa lunop. ");
INSERT INTO cebocb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Namatay siya sa edad nga 950. ");
INSERT INTO cebocb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Mao kini ang sugilanon mahitungod sa mga pamilya sa mga anak ni Noe nga sila si Sem, Ham, ug Jafet. Nangatawo ang ilang mga anak pagkahuman sa lunop. ");
INSERT INTO cebocb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ang mga anak nga lalaki ni Jafet sila si Gomer, Magog, Madai, Javan, Tubal, Meshec, ug Tiras. ");
INSERT INTO cebocb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Si Gomer adunay mga anak nga sila si Askenaz, Rifat, ug Togarma. ");
INSERT INTO cebocb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ang mga anak ni Javan sila si Elisha, Tarshish, Kitim, ug Dodanim. ");
INSERT INTO cebocb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Mao kini sila ang mga kaliwat ni Jafet. Sila mao ang gigikanan sa mga tawo nga nagpuyo sa mga baybayon ug mga isla. Ang matag pamilya nila nagpuyo sa ilang kaugalingong dapit nga sakop sa ilang nasod, ug aduna silay kaugalingon nga pinulongan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ang mga anak ni Ham sila si Cush, Mizraim, Put, ug Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Si Cush adunay mga anak sila si Seba, Havila, Sabta, Raama, ug Sabteca. Ang mga anak ni Raama sila si Sheba ug si Dedan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Adunay usa pa ka anak si Cush nga ginganlan ug Nimrod. Kini si Nimrod nahimong bantogan nga tawo sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Bantogan siya nga mangangayam atubangan sa Ginoo, busa adunay panultihon nga nag-ingon, “Sama ikaw kang Nimrod nga bantogan nga mangangayam atubangan sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ang una nga gingharian nga gidumalahan ni Nimrod mao ang Babilonia, Erek, Acad, ug Calne. Kini silang tanan anaa sa yuta sa Shinar. ");
INSERT INTO cebocb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Gikan niadto nga mga dapit miadto siya sa Asiria ug gitukod niya ang Nineve, Rehobot Ir, Cala, ");
INSERT INTO cebocb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ug Resen nga anaa sa tunga-tunga sa Nineve ug sa bantogan nga lungsod sa Cala. ");
INSERT INTO cebocb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Mizraim mao ang katigulangan sa mga: Ludhanon, Anamnon, Lehabnon, Naftunon, ");
INSERT INTO cebocb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusnon, Caslunon, ug sa mga Caftornon nga mao ang kagikan sa mga Filistihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Si Canaan mao ang amahan ni Sidon ug ni Het. Si Sidon mao ang kamagulangan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Canaan mao pud ang kagikan sa mga Jebusihanon, Amorihanon, Gergasihanon, ");
INSERT INTO cebocb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hibihanon, Arkanhon, Sinhanon, ");
INSERT INTO cebocb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadnon, Zemarnon, ug sa mga Hamatnon. Unya, nagkatag ang mga Canaanhon. ");
INSERT INTO cebocb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ang utlanan sa ilang kayutaan naggikan sa Sidon paingon sa Gerar hangtod sa Gaza, ug paingon sa Sodoma, Gomora, Adma, Zeboyim hangtod sa Lasha. ");
INSERT INTO cebocb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Mao kini sila ang mga kaliwat ni Ham. Ang matag pamilya nila nagpuyo sa ilang kaugalingong dapit nga sakop sa ilang nasod, ug aduna silay kaugalingon nga pinulongan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Sem nga magulang ni Jafet mao ang kagikan sa tanang kaliwat ni Eber. ");
INSERT INTO cebocb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ang mga anak ni Sem sila si Elam, Ashur, Arfaxad, Lud, ug Aram. ");
INSERT INTO cebocb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ang mga anak ni Aram sila si Uz, Hul, Geter, ug Mas. ");
INSERT INTO cebocb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arfaxad amahan ni Shela, ug si Shela amahan ni Eber. ");
INSERT INTO cebocb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Adunay duha ka anak nga lalaki si Eber: Ang usa ginganlag Peleg, tungod kay sa iyang panahon ang mga tawo sa kalibotan nabahin-bahin; ang ngalan sa iyang igsoon mao si Joktan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joktan mao ang amahan nila ni Almodad, Shelef, Hazarmavet, Jera, ");
INSERT INTO cebocb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO cebocb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO cebocb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, ug Jobab. Silang tanan mga anak ni Joktan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ang kayutaan nga ilang gipuy-an naggikan sa Mesha paingon sa Sefar, sa kabungtoran sa sidlakan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Mao kadto sila ang mga kaliwat ni Sem. Ang matag pamilya nila nagpuyo sa ilang kaugalingong dapit nga sakop sa ilang nasod, ug aduna silay kaugalingon nga pinulongan. ");
INSERT INTO cebocb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Mao kadto ang mga kaliwat sa mga anak ni Noe, nga anaa sa nagkalain-laing mga nasod. Pinaagi kanila natukod ang mga nasod sa tibuok kalibotan pagkahuman sa lunop. ");
INSERT INTO cebocb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kaniadto, usa lang ang pinulongan sa tanang mga tawo sa tibuok kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sa ilang pagbalhin-balhin gikan sa sidlakan, nakaabot sila sa usa ka patag nga dapit sa Shinar, ug didto sila namuyo. ");
INSERT INTO cebocb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Unya, miingon ang mga tawo, “Magtukod kita ug usa ka siyudad nga adunay tore nga sangko sa langit, aron mahimo kitang bantogan ug aron dili kita magkatibulaag sa tibuok kalibotan.” Busa nagbuhat sila ug mga tisa, ug gibaga nila kini ug maayo aron mogahi gayod. Tisa ang ilang gigamit imbis bato. Ug aspalto ang ilang gigamit ingon nga semento. ");
INSERT INTO cebocb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Unya, gitan-aw sa Ginoo ang pagtukod sa siyudad ug sa tore sa mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Miingon ang Ginoo, “Kini nga mga katawhan nagkahiusa ug usa ra ang ilang pinulongan. Ug kining ilang gibuhat sinugdanan pa lang sa ilang pagabuhaton. Sa dili madugay, mahimo na nila ang tanan nga gusto nilang buhaton. ");
INSERT INTO cebocb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Busa dali, manaog kita ug libogon nato sila pinaagi sa paghatag kanilag lain-lain nga pinulongan aron dili sila magkasinabtanay.” ");
INSERT INTO cebocb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Busa gipatibulaag sila sa Ginoo sa tibuok kalibotan ug naundang ang ilang pagtukod sa siyudad. ");
INSERT INTO cebocb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Busa gitawag kining maong siyudad ug Babel kay didto gilibog sa Ginoo ang sinultihan sa mga tawo, ug gikan didto gipatibulaag niya sila sa tibuok kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Mao kini ang sugilanon mahitungod sa pamilya ni Sem. Duha ka tuig human sa lunop, sa dihang nag-edad na si Sem ug 100 ka tuig, natawo ang iyang anak nga lalaki nga si Arfaxad. ");
INSERT INTO cebocb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Human matawo si Arfaxad, nabuhi pa gayod si Sem ug 500 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sa dihang nag-edad si Arfaxad ug 35 ka tuig, natawo ang iyang anak nga lalaki nga si Shela. ");
INSERT INTO cebocb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Human matawo si Shela, nabuhi pa gayod si Arfaxad ug 403 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sa dihang nag-edad si Shela ug 30 ka tuig, natawo ang iyang anak nga lalaki nga si Eber. ");
INSERT INTO cebocb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Human matawo si Eber, nabuhi pa si Shela ug 403 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sa dihang nag-edad si Eber ug 34 ka tuig, natawo ang iyang anak nga lalaki nga si Peleg. ");
INSERT INTO cebocb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Human matawo si Peleg, nabuhi pa si Eber ug 430 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Sa dihang nag-edad na si Peleg ug 30 ka tuig, natawo ang iyang anak nga lalaki nga si Reu. ");
INSERT INTO cebocb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Human matawo si Reu, nabuhi pa si Peleg ug 209 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Sa dihang nag-edad na si Reu ug 32 ka tuig, natawo ang iyang anak nga lalaki nga si Serug. ");
INSERT INTO cebocb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Human matawo si Serug, nabuhi pa si Reu ug 207 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sa dihang nag-edad si Serug ug 30 ka tuig, natawo ang iyang anak nga lalaki nga si Nahor. ");
INSERT INTO cebocb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Human matawo si Nahor, nabuhi pa si Serug ug 200 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Sa dihang nag-edad si Nahor ug 29 ka tuig, natawo ang iyang anak nga lalaki nga si Tera. ");
INSERT INTO cebocb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Human matawo si Tera, nabuhi pa si Nahor ug 119 ka tuig ug nadugangan pa ang iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Sa nakaabot na si Tera sa edad nga 70, natawo ang iyang mga anak nga lalaki nga sila ni Abram, Nahor, ug Haran. ");
INSERT INTO cebocb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Mao kini ang sugilanon mahitungod sa pamilya ni Tera. Si Tera amahan nila ni Abram, Nahor, ug Haran. Si Haran mao ang amahan ni Lot. ");
INSERT INTO cebocb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Namatay si Haran didto sa Ur nga sakop sa pagdumala sa mga Kaldeanhon, sa dapit mismo nga iyang natawhan. Namatay siya samtang buhi pa ang iyang amahan nga si Tera. ");
INSERT INTO cebocb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nangasawa si Abram kang Sarai, ug si Nahor nangasawa kang Milca. Si Milca ug ang iyang igsoon nga si Isca mga anak ni Haran. ");
INSERT INTO cebocb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Si Sarai walay anak kay baog siya. ");
INSERT INTO cebocb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Mibiya si Tera sa Ur nga sakop sa pagdumala sa mga Kaldeanhon. Kauban niya ang iyang anak nga si Abram, ang iyang umagad nga si Sarai, ug ang iyang apo nga si Lot nga anak ni Haran. Paingon unta sila sa Canaan, apan pag-abot nila sa Haran namuyo na sila didto. ");
INSERT INTO cebocb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ug didto namatay si Tera sa edad nga 205. ");
INSERT INTO cebocb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Unya, miingon ang Ginoo kang Abram, “Biyai ang imong nasod, ang imong mga kaparyentehan, ug ang panimalay sa imong amahan, ug adto sa dapit nga ipakita ko kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Himuon ko ang imong mga kaliwat nga usa ka bantogan nga nasod. Panalanginan ka nako ug mahimong bantogan ang imong ngalan. Pinaagi kanimo, daghan ang makadawat sa panalangin. ");
INSERT INTO cebocb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Panalanginan ko ang nagpanalangin kanimo. Apan tunglohon ko ang gatunglo kanimo. Pinaagi kanimo, mapanalanginan ang tanang katawhan sa kalibotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Busa mibiya si Abram sa Haran ug miadto sa Canaan, sumala sa giingon sa Ginoo kaniya. Nag-edad niadto si Abram ug 75 ka tuig. Miuban kaniya ang iyang pag-umangkon nga si Lot. Gidala usab niya ang iyang asawa nga si Sarai ug ang tanan nilang mga kabtangan ug mga sulugoon nga natigom nila sa Haran. ");
INSERT INTO cebocb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Pag-abot nila sa Canaan, mipadayon sila hangtod nga nakaabot sila sa kahoy nga tugas sa More didto sa Sekem. (Niadtong panahona didto pa nagpuyo ang mga Canaanhon.) ");
INSERT INTO cebocb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Unya nagpakita ang Ginoo kang Abram ug miingon kaniya, “Ihatag ko sa imong mga kaliwat kining yutaa.” Busa nagbuhat si Abram ug halaran alang sa Ginoo nga mipakita kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Gikan didto, mibalhin sila sa kabungtoran sa sidlakang bahin sa Betel, ug didto nagpatindog sila ug tolda, ang Betel anaa sa kasadpan ug ang Ai sa sidlakan. Nagbuhat usab didto si Abram ug halaran alang sa Ginooug misimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Wala madugay namalhin na usab sila. Nagpadayon sila sa paglakaw paingon sa Negev. ");
INSERT INTO cebocb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Unya, miabot ang dakong kagutom sa Canaan, busa miadto si Abram sa Ehipto aron didto lang una mopuyo. ");
INSERT INTO cebocb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Sa nagkaduol na sila sa Ehipto, miingon si Abram sa iyang asawa, “Sarai, maanyag ka nga babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kon makita ka sa mga Ehiptohanon moingon sila, ‘Iya kining asawa.’ Unya, patyon nila ako ug ikaw dili. ");
INSERT INTO cebocb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Busa ingna sila nga managsoon kita aron dili nila ako patyon ug hatagan nila akog maayong pagtagad tungod kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Busa pag-abot nila sa Ehipto, nakita tuod sa mga Ehiptohanon nga labihan gayod kaanyag ni Sarai. ");
INSERT INTO cebocb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ug sa dihang nakita siya sa mga opisyal sa Paraon, gisuginlan nila ang hari kon unsa siya katahom. Busa gidala si Sarai didto sa palasyo. ");
INSERT INTO cebocb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tungod kang Sarai, maayo gayod ang pagtagad sa hari kang Abram ug gihatagan pa siya ug mga karnero, kanding, baka, laki ug bayeng asno, kamelyo, ug mga sulugoon nga lalaki ug babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Apan gihatagan sa Ginoo ug makalilisang nga sakit ang Paraon ug ang iyang mga sakop sa palasyo tungod kang Sarai. ");
INSERT INTO cebocb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Sa dihang nasayran sa Paraon ang hinungdan, gipatawag niya si Abram ug gipangutana, “Unsa kining gibuhat mo kanako? Nganong wala ka magsulti nga asawa mo diay siya? ");
INSERT INTO cebocb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nganong miingon ka nga managsoon kamo? Gikuha ko hinuon siya aron mahimong asawa. Ania ang imong asawa, kuhaa siya ug panglakaw na kamo!” ");
INSERT INTO cebocb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Unya gimandoan sa Paraon ang iyang mga tawo nga papahawaon sila. Busa gipabiya nila si Abram niadtong dapita uban sa iyang asawa, dala ang tanan niyang kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Gikan sa Ehipto, miadto si Abram sa Negev uban sa iyang asawa dala ang tanan niyang kabtangan, ug uban gihapon si Lot. ");
INSERT INTO cebocb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Adunahan na kaayo si Abram; daghan siyag mga hayop, pilak, ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Gikan sa Negev, nagbalhin-balhin sila hangtod nga nakabalik sila sa dapit tunga-tunga sa Betel ug Ai diin nagpatindog sila sa ilang tolda kaniadto, ug diin usab sila una nga nagbuhat ug halaran. Ug gisimba pag-usab ni Abram ang Ginoo didto. ");
INSERT INTO cebocb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Si Lot nga mikuyog paglakaw kang Abram aduna usab siyay mga kahayopan ug tolda. ");
INSERT INTO cebocb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ug tungod kay daghan na ang ilang mga kahayopan ug uban pang mga kabtangan, dili sila mahimo nga mag-usa sa pagpuyo sa usa ka dapit. Ang sabsabanan dili paigo kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tungod niini, nagkaaway ang mga magbalantay sa ilang mga hayop. (Niadtong panahona ang mga Canaanhon ug mga Perisihanon nagpuyo pa usab niadtong dapita.) ");
INSERT INTO cebocb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Busa miingon si Abram kang Lot, “Kita ug ang atong mga tawo dili angay nga mag-away kay paryente kita. ");
INSERT INTO cebocb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ang maayo niini, magbulag na lang kita tungod kay daghan pa man ang dapit nga mahimong balhinan. Pagpili kon asa nga bahin sa yuta ang imong gusto. Kon sa wala ka nga bahin, sa tuo ako; kon sa tuo ka nga bahin, sa wala ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Mitan-aw si Lot sa palibot ug nakita niya nga abunda sa tubig ang Walog sa Jordan hangtod sa Zoar, sama sa tanaman sa Ginoo ug sa yuta sa Ehipto. (Sa panahon kini nga wala pa gilaglag sa Ginoo ang Sodoma ug Gomora.) ");
INSERT INTO cebocb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Busa gipili ni Lot ang tibuok nga Walog sa Jordan sa sidlakan. Sa mao nga paagi nagbulag sila ni Abram. ");
INSERT INTO cebocb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Si Abram nagpabilin sa Canaan samtang si Lot didto mipuyo sa mga lungsod sa kapatagan. Nagpatindog si Lot sa iyang tolda duol sa Sodoma. ");
INSERT INTO cebocb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ang mga tawo sa Sodoma labihan gayod kadaotan ug makasasala atubangan sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sa dihang nakabiya na si Lot, miingon ang Ginoo kang Abram, “Gikan diha sa imong gitindogan tan-awa pag-ayo ang imong palibot. ");
INSERT INTO cebocb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ang tanan nga yuta nga maabot sa imong panan-aw ihatag ko kanimo ug sa imong mga kaliwat, ug mainyo kana hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Himuon ko ang imong mga kaliwat nga sama kadaghan sa abog. Ang abog dili maihap, busa ang imong mga kaliwat dili usab maihap. ");
INSERT INTO cebocb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lakaw ug libota ang tibuok kayutaan kay ihatag ko kanang tanan kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Busa gibalhin ni Abram ang iyang tolda, ug didto siya mipuyo duol sa kahoy nga tugas ni Mamre didto sa Hebron, ug nagbuhat siya didto ug halaran alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Niadtong panahona, si Amrafel nga hari sa Shinar, si Arioc nga hari sa Elasar, si Kedorlaomer nga hari sa Elam, ug si Tidal nga hari sa Goyim ");
INSERT INTO cebocb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nakig-gira batok kang Bera nga hari sa Sodoma, kang Birsha nga hari sa Gomora, kang Shinab nga hari sa Adma, kang Shemeber nga hari sa Zeboyim, ug sa hari sa Bela nga gitawag usab ug Zoar. ");
INSERT INTO cebocb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nagkahiusa kining lima ka mga hari uban ang ilang mga sundalo didto sa Walog sa Sidim nga gitawag karon ug Patay nga Dagat. ");
INSERT INTO cebocb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kini nga mga hari gisakop ni Kedorlaomer sulod sa 12 ka tuig, apan sa ika-13 nga tuig nagrebelde sila kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ug sa ika-14 nga tuig, gipildi ni Kedorlaomer ug sa iyang mga kauban nga hari ang mga Refaimnon sa Ashtarot Karnaim, ang mga Zuzimnon sa Ham, ang mga Emhanon sa kapatagan sa Kiriataim, ");
INSERT INTO cebocb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ug ang mga Horihanon sa kabungtoran sa Seir hangtod sa El Paran nga duol sa kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Gikan didto, mibalik sila ug nakaabot sa En Mishpat nga gitawag karon nga Kadesh. Ug giilog nila ang tanan nga kayutaan sa mga Amalekanhon ug sa mga Amorihanon nga nagpuyo sa Hazazon Tamar. ");
INSERT INTO cebocb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Unya, gitigom sa mga hari sa Sodoma, Gomora, Adma, Zeboyim, ug hari sa Bela nga si Zoar, ang ilang mga sundalo didto sa Walog sa Sidim ");
INSERT INTO cebocb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ug nakig-gira sila batok kang Kedorlaomer nga hari sa Elam, kang Tidal nga hari sa Goyim, kang Amrafel nga hari sa Shinar, ug kang Arioc nga hari sa Elasar. Silang upat ka hari batok sa lima ka hari. ");
INSERT INTO cebocb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ang Walog sa Sidim adunay daghang mga bangag nga kuhaanan ug alkitran. Ug sa dihang nangikyas ang mga hari sa Sodoma ug sa Gomora uban sa ilang mga sundalo, nangahulog ang uban kanila sa mga bangag, ug ang uban nangikyas ngadto sa mga bukid. ");
INSERT INTO cebocb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Ang tanang kabtangan sa Sodoma ug Gomora apil ang ilang mga pagkaon gikuha sa ilang mga kaaway. Gibihag usab nila si Lot nga pag-umangkon ni Abram ug gikuha ang iyang mga kabtangan, kay didto man siya nagpuyo sa Sodoma niadtong panahona. Ug unya mibiya sila. ");
INSERT INTO cebocb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Adunay usa ka tawo nga nakaikyas ug misugilon kang Abram nga Hebreo bahin sa nahitabo. Si Abram didto niadtong panahona nagpuyo duol sa kahoy nga tugas ni Mamre nga Amorihanon. Kini si Mamre ug ang iyang mga igsoon nga si Eshcol ug si Aner mga kadapig ni Abram. ");
INSERT INTO cebocb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pagkadungog ni Abram nga gibihag ang iyang pag-umangkon, gitigom dayon niya ang iyang 318 ka sinaligan nga mga tawo (nga natawo diha sa iyang panimalay), ug gigukod nila ang upat ka mga hari hangtod sa Dan. ");
INSERT INTO cebocb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pagkagabii, gibahin ni Abram sa nagkalain-laing grupo ang iyang mga tawo. Gisulong nila ang ilang mga kaaway, ug napildi nila kini. Ang uban nga nakaikyas gigukod nila hangtod sa Hoba, sa amihan nga bahin sa Damasco. ");
INSERT INTO cebocb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nabawi nila ang tanang mga kabtangan nga giilog sa mga kaaway. Nabawi usab nila si Lot ug ang iyang mga kabtangan apil ang mga babaye ug ang uban pa nga mga katawhan. ");
INSERT INTO cebocb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sa pagpauli na ni Abram, human nila mapildi si Kedorlaomer ug ang iyang mga kauban nga hari, gitagbo siya sa hari sa Sodoma sa Walog sa Shaveh (nga gitawag usab ug Walog sa Hari). ");
INSERT INTO cebocb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Gitagbo usab siya ni Melquisedek nga hari sa Salem ug pari sa Labing Halangdong Dios. Nagdala si Melquisedek ug pagkaon ug ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Gipanalanginan niya si Abram nga nag-ingon: “Hinaut pa nga panalanginan ka, Abram, sa Labing Halangdong Dios nga nagbuhat sa langit ug sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dalaygon ang Labing Halangdong Dios nga naghatag kanimo ug kadaogan batok sa imong mga kaaway!” Unya gihatagan ni Abram si Melquisedek sa ikapulo nga bahin sa tanan nga iyang nakuha sa gubat. ");
INSERT INTO cebocb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Unya, miingon ang hari sa Sodoma kang Abram, “Imo na ang tanang kabtangan nga nabawi mo, apan iuli lang kanako ang tanan kong mga tawo.” ");
INSERT INTO cebocb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Apan mitubag si Abram, “Nanumpa ako atubangan sa Ginoo, ang Labing Halangdong Dios nga mao ang nagbuhat sa langit ug sa yuta, ");
INSERT INTO cebocb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nga dili gayod ako mokuha ug bisan unsa nga imong gipanag-iya, bisan tanod o higot sa sandalyas, aron dili ka makaingon nga ikaw ang nagpadato kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wala akoy kuhaon alang sa akong kaugalingon. Ang nakaon lang sa akong mga tawo ang isipon ko nga akong bahin. Apan pakuhaa sa ilang bahin sila si Aner, Eshcol, ug Mamre nga miuban kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Human niadto, nakigsulti ang Ginoo kang Abram pinaagi sa usa ka panan-awon. Miingon siya, “Abram, ayaw kahadlok tungod kay panalipdan ka nako ug hatagan ug dako nga ganti.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Apan miingon si Abram, “O Ginoong Dios, unsay pulos sa imong iganti kanako kon hangtod karon wala pa akoy anak, ug ang mahimo kong manunod mao si Eliezer nga taga-Damasco? ");
INSERT INTO cebocb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tungod kay wala mo ako hatagi ug anak, si Eliezer nga usa sa akong mga sulugoon mao ang manunod sa akong mga kabtangan.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Miingon ang Ginoo kaniya, “Dili si Eliezer ang manunod sa imong mga kabtangan kondili ang imo gayong kaugalingong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Unya gidala siya sa Ginoo sa gawas ug giingnan, “Tan-awa ang mga bitoon sa langit; ihapa kon maihap mo. Sama usab niana kadaghan ang mahimo mong mga kaliwat.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Mituo si Abram sa Ginoo, ug tungod sa iyang pagtuo giisip siya nga matarong. ");
INSERT INTO cebocb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Miingon pa gayod ang Ginoo kang Abram, “Ako ang Ginoo nga nagsugo kanimo sa pagbiya sa Ur nga sakop sa pagdumala sa mga Kaldeanhon aron ihatag kanimo kining yutaa ug imong mapanag-iya.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Apan miingon si Abram, “O Ginoong Dios, unsaon ko pagkahibalo nga maangkon ko kini?” ");
INSERT INTO cebocb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mitubag ang Ginoo, “Dad-i ako dinhi ug usa ka dumalagang baka, usa ka bayeng kanding, ug usa ka hamtong nga laking karnero, nga ang matag-usa tulo ka tuig ang kagulangon. Pagdala usab ug usa ka tukmo ug usa ka salampati.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Busa gidala kining tanan ni Abram ngadto sa Ginoo. Unya gipangtunga niya kini ug giplastar nga nag-atubangay ang isigka-pikas niini. Apan ang tukmo ug ang salampati wala niya tungaa. ");
INSERT INTO cebocb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mitugpa sa pinikas nga mga mananap ang mga langgam nga nagpangdagit, apan giabog sila ni Abram. ");
INSERT INTO cebocb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Sa dihang gasalop na ang adlaw, nahinanok pag-ayo si Abram ug adunay makalilisang nga kangitngit nga mitabon kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Unya miingon ang Ginoo kang Abram, “Sa pagkatinuod, ang imong mga kaliwat mahimong mga dumuduong sa laing nasod. Mahimo silang mga ulipon didto ug daog-daogon sulod sa 400 ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Apan silotan ko ang nasod nga moulipon kanila. Ug unya mobiya ang imong mga kaliwat gikan didto dala ang daghang kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Apan ikaw Abram, hatagan ko ug taas nga kinabuhi; mamatay ka sa katigulangon nga adunay kalinaw. ");
INSERT INTO cebocb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Molabay una ang upat ka henerasyon ayha pa makabalik ang imong mga kaliwat dinhi, tungod kay dili pa igo ang pagpakasala sa mga Amorihanon aron silotan sila ug papahawaon niini nga yuta.” ");
INSERT INTO cebocb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sa dihang nakasalop na ang adlaw ug ngitngit na, kalit lang nga nakita ni Abram ang usa ka kolon nga gaaso ug sulo nga gasiga nga miagi taliwala sa pinikas nga mga mananap. ");
INSERT INTO cebocb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Niana gayod nga adlaw, nagbuhat ang Ginoo ug kasabotan kang Abram. Miingon siya, “Ihatag ko sa imong mga kaliwat kining yutaa, gikan sa suba sa utlanan sa Ehipto paingon sa dako nga suba nga mao ang Eufrates. ");
INSERT INTO cebocb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kini nga yuta mao karon ang gipuy-an sa mga Kenihanon, Kenisihanon, Kadmonhon, ");
INSERT INTO cebocb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","21","Hitihanon, Perisihanon, Refaimnon, Amorihanon, Canaanhon, Gergasihanon, ug mga Jebusihanon.” ");
INSERT INTO cebocb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Si Sarai nga asawa ni Abram dili makaanak. Aduna siyay sulugoon nga babayeng Ehiptohanon nga ginganlag Hagar. ");
INSERT INTO cebocb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Miingon si Sarai kang Abram, “Wala man motugot ang Ginoo nga makaanak ako, maayo pa tingali nga makighilawas ka sa akong sulugoon nga babaye kay basin pa ug makabaton ako ug anak pinaagi kaniya.” Misugot si Abram sa giingon sa iyang asawa. ");
INSERT INTO cebocb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Busa gihatag ni Sarai si Hagar nga Ehiptohanon, kang Abram aron mahimong iyang asawa. (Nahitabo kini human nakapuyo si Abram sa Canaan ug napulo ka tuig.) ");
INSERT INTO cebocb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Wala madugay namabdos si Hagar. Pagkahibalo ni Hagar nga mabdos siya, gibiay-biay niya si Sarai. ");
INSERT INTO cebocb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tungod niini, miingon si Sarai kang Abram, “Gihatag ko si Hagar kanimo apan karon nga mabdos na siya, gibiay-biay na niya ako. Ikaw ang angay basolon niini! Ang Ginoo na ang maghukom kon kinsa kanato ang sad-an.” ");
INSERT INTO cebocb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mitubag si Abram, “Imo siyang sulugoon, busa buhata ang gusto mong buhaton kaniya.” Gikan niadto gilisod-lisod na ni Sarai si Hagar, busa milayas kini. ");
INSERT INTO cebocb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nakita sa anghel sa Ginoo si Hagar didto sa adunay tuboran sa kamingawan. Kini nga tuboran duol sa dalan paingon sa Shur. ");
INSERT INTO cebocb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Nangutana ang anghel kaniya, “Hagar, sulugoon ni Sarai, diin ka gikan ug asa ka paingon?” Mitubag siya, “Milayas ako sa akong agalon nga si Sarai.” ");
INSERT INTO cebocb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Miingon ang anghel sa Ginoo kaniya, “Balik sa imong agalon ug pagpaubos kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Unya miingon pa gayod ang anghel, “Padaghanon ko pag-ayo ang imong kaliwat, nga ang ilang gidaghanon dili maihap.” ");
INSERT INTO cebocb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ug miingon pag-usab ang anghel sa Ginoo: “Mabdos ka ug sa dili madugay manganak ka ug usa ka batang lalaki. Nganli siya ug Ishmael, kay gidungog sa Ginoo ang imong pagpakitabang tungod sa imong pag-antos. ");
INSERT INTO cebocb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Apan ang imong anak magkinabuhi nga sama sa usa ka ihalas nga asno. Kontrahon niya ang tanan, ug ang tanan mokontra kaniya. Magpuyo siya nga walay kalinaw ug mopahilayo siya sa iyang mga paryente.” ");
INSERT INTO cebocb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Gitawag ni Hagar ang Ginoo nga nakigsulti kaniya ug “Dios nga Nakakita,” kay miingon siya, “Nakita ko ba gayod ang Dios nga nakakita kanako?” ");
INSERT INTO cebocb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Mao kana nga ang tuboran nga anaa sa tunga-tunga sa Kadesh ug Bered gitawag ug Beer Lahai Roi. ");
INSERT INTO cebocb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Mibalik si Hagar kang Sarai ug nanganak siya ug batang lalaki. Ginganlan ni Abram ang bata ug Ishmael. ");
INSERT INTO cebocb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Nag-edad si Abram ug 86 ka tuig sa dihang gipanganak ni Hagar si Ishmael. ");
INSERT INTO cebocb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sa dihang nag-edad si Abram ug 99 ka tuig, nagpakita ang Ginoo kaniya ug miingon, “Ako ang Dios nga Makagagahom. Pagmatinumanon kanunay kanako ug pagkinabuhi nga matarong. ");
INSERT INTO cebocb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tumanon ko ang akong kasabotan kanimo: padaghanon ko gayod ang imong mga kaliwat.” ");
INSERT INTO cebocb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Pagkadungog niadto ni Abram, mihapa siya. Miingon ang Dios kaniya, ");
INSERT INTO cebocb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Mao kini ang akong kasabotan kanimo: Mahimo kang amahan sa daghang mga nasod. ");
INSERT INTO cebocb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sukad karon dili na Abram ang ingalan kanimo kondili Abraham na, tungod kay himuon ka nako nga amahan sa daghang mga nasod. ");
INSERT INTO cebocb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Padaghanon ko pag-ayo ang imong mga kaliwat ug maggikan kanila ang mga nasod, ug ang uban kanila mahimong mga hari. ");
INSERT INTO cebocb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Tumanon ko ang akong kasabotan kanimo ug sa imong mga kaliwat sa umaabot nga mga henerasyon, nga padayon ako nga mahimong inyong Dios. Kini nga kasabotan magpadayon hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mga langyaw pa kamo karon sa yuta sa Canaan. Apan ihatag ko kining tibuok nga yuta kanimo ug sa imong mga kaliwat. Mainyo na kini hangtod sa kahangtoran, ug ako padayon nga mahimong inyong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Midugang pag-ingon ang Dios kang Abraham, “Ug ikaw, kinahanglan tumanon nimo ug sa imong mga kaliwat ang akong kasabotan kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ug bahin nianang kasabotan: Kinahanglan tulion ninyo ang tanan ninyong mga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kini ang mahimong ilhanan sa akong kasabotan kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Sukad karon hangtod sa umaabot nga henerasyon, kinahanglan tulion ninyo ang matag batang lalaki nga nag-edad ug walo ka adlaw. Tulion usab ninyo ang mga ulipong lalaki nga natawo sa inyong panimalay apil ang mga ulipon nga inyong gipalit gikan sa mga langyaw. Kana nga ilhanan sa inyong lawas magpamatuod nga ang akong kasabotan kaninyo magpadayon hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Si bisan kinsa nga wala matuli kinahanglan nga dili na ninyo isipon nga usa sa inyong katawhan, tungod kay gipakawalay-bili niya ang akong kasabotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Miingon pa gayod ang Dios kang Abraham, “Bahin sa imong asawa nga si Sarai, ayaw na siya tawaga ug Sarai, kay sukad karon Sara na ang iyang ngalan. ");
INSERT INTO cebocb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Panalanginan ko siya ug hatagan ka nako ug anak pinaagi kaniya. Mahimo siyang inahan sa daghang mga nasod, ug ang uban niya nga mga kaliwat mahimong hari.” ");
INSERT INTO cebocb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Mihapa si Abraham, apan mikatawa siya sa iyang nadungog. Miingon siya sa iyang kaugalingon, “Makaanak pa kaha ako nga 100 na man ang akong edad? Ug si Sara, makaanak pa kaha sa edad nga 90 ka tuig?” ");
INSERT INTO cebocb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Unya miingon siya sa Dios, “Hinaut nga ang akong anak nga si Ishmael ang hatagan mo sa panalangin.” ");
INSERT INTO cebocb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mitubag ang Dios, “Dili. Ang imong asawa nga si Sara manganak ug lalaki ug nganlan mo siya ug Isaac. Padayonon ko diha kaniya ang akong kasabotan kanimo, ug magpadayon kini nga kasabotan ngadto sa iyang mga kaliwat hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nadungog ko ang imong hangyo bahin kang Ishmael. Panalanginan ko siya ug hatagan ug daghang mga kaliwat. Mahimo siyang amahan sa 12 ka mga pangulo, ug ang iyang mga kaliwat mahimong bantogan nga katawhan. ");
INSERT INTO cebocb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Apan kang Isaac ko lang tumanon ang akong kasabotan kanimo. Manganak si Sara kang Isaac sa sama usab niini nga panahon sa sunod nga tuig.” ");
INSERT INTO cebocb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mibiya ang Dios pagkahuman siya makigsulti kang Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Niadto gayong adlawa, gituman ni Abraham ang gisugo kaniya sa Dios. Gituli niya ang iyang anak nga si Ishmael ug ang tanang mga lalaki sa iyang panimalay: ang mga ulipon nga natawo sa iyang panimalay ug ang mga ulipon nga iyang gipalit. ");
INSERT INTO cebocb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Nag-edad si Abraham ug 99 ka tuig sa dihang gituli siya, ");
INSERT INTO cebocb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ug si Ishmael nag-edad usab ug 13 ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Niadto gayod mismo nga adlaw nga nagsugo ang Dios nga ang tanang mga lalaki kinahanglan matuli, nagpatuli si Abraham ug si Ishmael, apil ang tanang mga ulipon ni Abraham nga natawo sa iyang panimalay ug ang mga ulipon nga iyang gipalit gikan sa mga langyaw. ");
INSERT INTO cebocb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nagpakita ang Ginoo kang Abraham sa dihang didto pa siya nagpuyo duol sa kahoy nga tugas ni Mamre. Init kadto nga adlaw, ug si Abraham naglingkod-lingkod didto sa pultahan sa iyang tolda. ");
INSERT INTO cebocb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Samtang naglantaw-lantaw siya, aduna siyay nakitang tulo ka lalaki nga nagtindog sa unahan. Midagan dayon siya sa pagtagbo kanila. Miyukbo siya agig pagtahod kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ug miingon, “Ginoo, kon mahimo, hapit una sa amo. ");
INSERT INTO cebocb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Magpakuha ako ug tubig aron makapanghugas kamo sa inyong mga tiil ug unya makapahulay ilalom niining kahoy. ");
INSERT INTO cebocb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mokuha usab ako ug pagkaon alang kaninyo aron adunay kusog kamo sa inyong paglakaw. Ikalipay ko ang pag-alagad kaninyo samtang ania kamo uban kanamo.” Ug mitubag sila, “Sige, buhata ang imong gisulti.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Busa nagdali-dali si Abraham ug sulod sa tolda ug miingon kang Sara, “Pagdali, pagkuha ug usa ka sako sa maayong klasi sa harina ug pagluto ug pan.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Midagan usab si Abraham ngadto sa iyang mga baka ug nagpili ug tambok nga nati. Gipadali niya kinig paihaw ug paluto sa iyang sulugoon. ");
INSERT INTO cebocb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Unya gidala niya kini ngadto sa iyang mga bisita, uban sa keso ug gatas. Ug samtang nangaon ang iyang mga bisita ilalom sa kahoy, didto usab si Abraham sa ilang duol nga andam sa pag-alagad kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Unya, nangutana ang mga bisita kang Abraham, “Hain si Sara nga imong asawa?” Mitubag siya, “Tua sa sulod sa tolda.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ang usa sa mga bisita miingon, “Ipaniguro ko nga mobalik ako dinhi sa sunod nga tuig, sa sama gihapon nga panahon, ug ang imong asawa nga si Sara aduna nay anak nga lalaki.” Naminaw diay si Sara didto sa entrada sa tolda sa likod ni Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","(Tigulang na silang duha ni Abraham ug miundang na gani ang binulan ni Sara.) ");
INSERT INTO cebocb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Mikatawa si Sara sa iyang kaugalingon nga nag-ingon, “Sa akong katigulangon ganahan pa ba kaha ako makigdulog sa akong bana nga tigulang na usab aron makaanak kami?” ");
INSERT INTO cebocb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Unya nangutana ang Ginoo kang Abraham, “Nganong mikatawa si Sara ug miingon, ‘Makaanak pa ba ako nga tigulang na man ako?’ ");
INSERT INTO cebocb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Aduna bay butang nga dili mahimo sa Ginoo? Sumala sa giingon ko, mobalik ako dinhi sa sunod nga tuig sa sama gihapon nga panahon, ug si Sara aduna nay anak nga lalaki.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nahadlok si Sara, busa namakak siya. Miingon siya, “Wala ko mokatawa!” Apan miingon ang Ginoo, “Mikatawa ka gayod.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pagkahuman, milakaw ang tulo ka lalaki. Gihatod sila ni Abraham hangtod sa usa ka dapit diin makita nila sa ubos ang lungsod sa Sodoma. ");
INSERT INTO cebocb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Miingon ang Ginoo, “Dili ko itago kang Abraham ang akong pagabuhaton. ");
INSERT INTO cebocb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Sigurado gayod nga ang iyang mga kaliwat mahimong dako ug gamhanan nga nasod sa umaabot, ug pinaagi kaniya, mapanalanginan ang tanang mga nasod sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Gipili ko siya aron iyang mandoan ang iyang mga kaanakan ug mga kaliwat nga motuman sa akong mga sugo pinaagi sa pagbuhat sa husto ug matarong. Ug pinaagi niana, matuman ang akong gisaad kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Unya miingon ang Ginoo kang Abraham, “Daghan na ang mga reklamo bahin sa Sodoma ug Gomora, kay labihan na gayod kadaotan ang maong mga dapit. ");
INSERT INTO cebocb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Busa moadto ako didto aron pagsusi kon tinuod ba o dili kini nga mga reklamo.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Milakaw ang duha ka lalaki paingon sa Sodoma, apan nagpabilin ang Ginoo uban kang Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Miduol si Abraham sa Ginoo ug nangutana, “Laglagon mo ba ang mga matarong uban sa mga daotan? ");
INSERT INTO cebocb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kon pananglit adunay 50 ka tawong matarong niana nga lungsod, laglagon mo ba ang tibuok nga lungsod? Dili mo ba kaluy-an ang lungsod tungod ug alang sa 50 ka mga tawong matarong? ");
INSERT INTO cebocb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Imposible nga laglagon mo ang mga matarong uban sa mga daotan. Dili mahimo nga managsama ra ang pagtagad mo kanila. Ikaw ang naghukom sa tibuok kalibotan, dili ba nga angay lang nga buhaton mo kon unsa ang husto?” ");
INSERT INTO cebocb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mitubag ang Ginoo, “Kon aduna akoy makitang 50 ka tawong matarong sa Sodoma, dili ko laglagon ang tibuok nga lungsod tungod ug alang kanila.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Miingon pag-usab si Abraham, “O Ginoo, pasayloa ako nga mangahas sa pagpakigsulti kanimo. Tawo lang ako, ug wala akoy katungod sa pagsulti niini kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kon pananglit adunay 45 ka tawong matarong, laglagon mo ba ang tibuok nga lungsod tungod kay kulang kini ug lima?” Mitubag ang Ginoo, “Kon aduna akoy makitang 45 ka tawong matarong, dili ko laglagon ang lungsod.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Midugang pag-ingon si Abraham, “Kon pananglit 40 lang ang matarong?” Mitubag ang Ginoo, “Dili ko laglagon ang lungsod tungod ug alang sa 40 ka tawong matarong.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Miingon pag-usab si Abraham, “Ayaw kasuko kanako, Ginoo, kay mangutana pa ako. Kon pananglit adunay 30 lang ka tawong matarong?” Mitubag ang Ginoo, “Dili ko gihapon laglagon ang lungsod kon aduna akoy makitang 30 ka tawong matarong.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Miingon pa gayod si Abraham, “Ginoo, pasayloa ako sa akong pagpangahas sa pagpadayon nga makigsulti kanimo. Kon pananglit adunay 20 lang ka tawong matarong?” Mitubag ang Ginoo, “Dili ko gihapon laglagon ang lungsod tungod ug alang sa 20 ka tawong matarong.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Miingon pa gayod pag-usab si Abraham, “Ginoo, ayaw kasuko; kataposan ko na lang gayod kini nga pangutana. Kon pananglit 10 lang ang imong makita nga matarong?” Mitubag ang Ginoo, “Dili ko gihapon laglagon ang lungsod tungod ug alang sa 10 ka tawong matarong.” ");
INSERT INTO cebocb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pagkahuman niyag pakigsulti kang Abraham, mibiya ang Ginoo ug si Abraham mipauli sa ila. ");
INSERT INTO cebocb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kilom-kilom na sa dihang miabot kadtong duha ka anghel sa Sodoma. Naglingkod niadto si Lot sa pultahan sa lungsod. Pagkakita ni Lot kanila, mitindog siya sa pagtagbo kanila. Unya miyukbo siya agig pagtahod kanila ug miingon, ");
INSERT INTO cebocb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Kon mahimo, hapit una kamo sa akong balay. Makapanghimasa kamo didto ug adto kamo matulog karong gabii. Ug ugma sayo kamo nga makapadayon sa inyong paglakaw.” Apan mitubag sila, “Ayaw na lang, adto na lang kami matulog sa plasa karong gabii.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Apan gipugos gayod sila ni Lot, busa miuban na lang sila sa iyang balay. Gaandam si Lot ug daghang pagkaon ug ilimnon. Nagpaluto usab siya ug pan nga walay patubo, ug nangaon sila. ");
INSERT INTO cebocb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sa nangandam na sila sa pagpanghigda, nangabot ang mga batan-on ug tigulang nga mga lalaki sa Sodoma gikan sa tanang dapit sa lungsod, ug gilibotan nila ang balay ni Lot. ");
INSERT INTO cebocb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Misinggit sila ngadto kang Lot, “Hain na ang imong mga bisitang lalaki nga miabot karong gabii? Pagawasa sila dinhi kay gusto kaming makighilawas kanila.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Migawas si Lot aron atubangon sila, ug gisirhan niya ang pultahan human siya makagawas. ");
INSERT INTO cebocb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Miingon siya kanila, “Mga higala, naghangyo ako nga dili ninyo buhaton kanang gihuna-huna ninyo nga daotan. ");
INSERT INTO cebocb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aduna akoy duha ka anak nga dalaga. Ihatag ko sila kaninyo ug buhata ang gusto ninyong buhaton ngadto kanila. Apan ayaw lang ninyo hilabti kining duha ka tawo, kay mga bisita ko sila ug angay ko silang panalipdan.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Apan miingon ang mga tawo, “Dumuduong ka lang dinhi! Si kinsa ka nga motudlo kanamo sa angay namong buhaton? Pahawa diha! Basin mas labaw pa kadaotan ang among buhaton diha kanimo kay kanila.” Unya gituklod nila si Lot. Moduol unta sila sa pultahan aron sa pagguba niini, ");
INSERT INTO cebocb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","apan giablihan kini sa duha ka anghel nga didto sa sulod ug gibira si Lot, ug gisira ang pultahan. ");
INSERT INTO cebocb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Unya gibutahan nila ang mga tawo sa gawas aron dili na sila makatultol sa pultahan. ");
INSERT INTO cebocb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Miingon ang duha ka anghel kang Lot, “Kon aduna ka pay mga anak o mga umagad nga lalaki o mga kaparyentehan dinhi sa lungsod, ipahilayo silang tanan niining dapita, ");
INSERT INTO cebocb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kay laglagon namo kining lungsora. Nadungog sa Ginoo ang daghang mga reklamo batok sa labihan kadaotan nga mga tawo niining dapita. Busa gipadala niya kami aron sa paglaglag niini.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Unya giadtoan ni Lot ang iyang mga umagaron nga lalaki ug giingnan, “Pagdali, biya kamo dinhi kay laglagon sa Ginoo kining lungsora.” Apan wala sila motuo kay abi nila ug nagtiaw-tiaw lang si Lot. ");
INSERT INTO cebocb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sa dihang mibanag-banag na, gipadali-dali sa mga anghel si Lot sa pagbiya sa lungsod. Miingon sila, “Pagdali! Dad-a ang imong asawa ug duha ka anak nga babaye nga ania dinhi ug biya kamo dayon, kay basig maapil kamo sa paglaglag niining lungsod.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Apan naglangay-langay pa si Lot. Busa tungod kay naluoy ang Ginoo kanila, gikuptan sa mga anghel ang ilang mga kamot ug gidala sila gawas sa lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sa dihang didto na sila sa gawas, miingon ang usa kanila, “Panagan kamo! Ayaw gayod kamo paglingi o paghunong sa bisan asa nga bahin niining kapatagan. Panagan kamo sa bukid aron dili kamo mamatay.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Apan mitubag si Lot, “Ginoo, ayaw na ako padagana sa bukid. ");
INSERT INTO cebocb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Gikaloy-an mo ako ug gipakita mo ang imong kaayo kanako pinaagi sa pagluwas sa akong kinabuhi. Apan layo kaayo kadtong bukid; basig maapsan ako sa katalagman ug mamatay ako sa dili pa makaabot didto. ");
INSERT INTO cebocb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Anaay gamay nga lungsod sa unahan. Duol ra kana; mahimo ba akong modagan diha aron makaikyas ug maluwas ang akong kinabuhi?” ");
INSERT INTO cebocb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mitubag ang anghel kaniya, “Mosugot ako sa imong hangyo; dili ko laglagon kanang lungsora. ");
INSERT INTO cebocb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sige, panagan na kamo didto, kay dili ko mahimo ang angay kong buhaton hangtod nga dili pa kamo makaabot didto.” (Gitawag ang maong lungsod nga Zoar.) ");
INSERT INTO cebocb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Hayag na sa dihang nakaabot sila si Lot sa Zoar. ");
INSERT INTO cebocb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Unya gipaulanan sa Ginoo ug nagdilaab nga asupre ang Sodoma ug Gomora. ");
INSERT INTO cebocb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Gilaglag sa Ginoo ang duha ka lungsod ug ang tibuok kapatagan. Nangamatay ang tanang nagpuyo didto apil ang tanang tanom. ");
INSERT INTO cebocb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Milingi ang asawa ni Lot, ug nahimo siyang haligi nga asin. ");
INSERT INTO cebocb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Sayo pa kaayo nianang pagkasunod adlaw, miadto si Abraham sa dapit diin nakigsulti siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Milantaw siya sa Sodoma ug Gomora ug sa tibuok nga kapatagan. Nakita niya ang aso nga miulbo gikan sa yuta, sama sa aso nga naggikan sa usa ka dako nga hurnohan. ");
INSERT INTO cebocb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Gihinumdoman sa Dios si Abraham, kay sa dihang gilaglag niya ang mga lungsod sa kapatagan diin nagpuyo si Lot, gipaikyas una niya kini aron dili maapil. ");
INSERT INTO cebocb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nahadlok si Lot nga mopuyo sa Zoar, busa mibalhin siya sa bukid uban sa iyang duha ka anak nga dalaga ug didto nagpuyo sa langub. ");
INSERT INTO cebocb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Usa niana ka adlaw, miingon ang magulang nga anak ngadto sa iyang manghod, “Tigulang na ang atong amahan ug wala gayoy lalaki dinhi nga mangasawa kanato aron makabaton kitag anak sama sa ginahimo bisan diin. ");
INSERT INTO cebocb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Maayo pag paimnon nato ang atong amahan ug bino hangtod nga mahubog, unya makighilawas kita kaniya aron nga makabaton kitag anak pinaagi kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Busa niadtong gabhiona, gihubog nila ang ilang amahan. Unya nakighilawas ang magulang nga anak sa iyang amahan. Tungod sa sobra nga kahubog ni Lot wala gayod siya makahibalo kon unsa ang nahitabo. ");
INSERT INTO cebocb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pagkasunod nga adlaw, miingon ang magulang sa iyang manghod, “Nakighilawas ako sa atong amahan kagabii. Karong gabii, paimnon na usab nato siya ug bino hangtod nga mahubog siya, ug ikaw na usab ang makighilawas kaniya aron makabaton kitang duha ug anak pinaagi kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Busa gihubog na usab nila ang ilang amahan nianang pagkagabii, ug ang manghod na usab ang nakighilawas kaniya. Sa labihan niya nga kahubog wala gihapon makahibalo si Lot kon unsa ang nahitabo. ");
INSERT INTO cebocb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Niining paagiha, namabdos ang duha ka anak ni Lot pinaagi mismo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nanganak ang magulang ug lalaki ug ginganlan niya kinig Moab. Siya ang kagikan sa katawhan nga mga Moabihanon karon. ");
INSERT INTO cebocb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nanganak usab ug lalaki ang manghod ug ginganlan niya kinig Ben Ami. Siya ang kagikan sa katawhan nga mga Amonihanon karon. ");
INSERT INTO cebocb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Mibiya sila si Abraham sa Mamre ug miadto sa Negev. Mipuyo sila sa tunga-tunga sa Kadesh ug Shur ug unya mibalhin sila sa Gerar. ");
INSERT INTO cebocb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Samtang didto sila, gipaila ni Abraham si Sara sa mga tawo ingon nga iyang igsoon. Busa gipakuha ni Abimelec nga hari sa Gerar si Sara. ");
INSERT INTO cebocb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Usa ka gabii, nagpakita ang Dios kang Abimelec pinaagi sa usa ka damgo. Miingon siya, “Mamatay ka, kay ang babaye nga imong gikuha adunay bana.” ");
INSERT INTO cebocb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Apan tungod kay wala pa mahilabti ni Abimelec si Sara, miingon siya, “Ginoo, patyon mo ba diay ang mga tawong inosente? Wala akoy sala. ");
INSERT INTO cebocb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Miingon si Abraham nga igsoon niya si Sara ug si Sara miingon usab nga igsoon niya si Abraham. Inosente gayod ako niining mga butanga, busa nagtuo ako nga dili daotan ang akong gibuhat.” ");
INSERT INTO cebocb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mitubag ang Dios, “Oo, nasayod ako nga wala kay daotang tinguha, busa wala ako motugot nga mahilabtan mo siya aron dili ka makasala kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Apan kinahanglan ibalik mo siya sa iyang bana tungod kay ang iyang bana usa ka propeta, ug ampoan ka niya aron dili ka mamatay. Apan kon dili mo siya ibalik, pasidan-an ka nako nga daan nga mamatay ka gayod apil ang tanan mong mga katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Sayo pa kaayo pagkasunod adlaw, gipatawag ni Abimelec ang tanan niyang mga opisyal ug gisuginlan mahitungod sa iyang damgo. Nahadlok sila pag-ayo. ");
INSERT INTO cebocb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Unya gipatawag ni Abimelec si Abraham ug gipangutana, “Unsa kining gibuhat mo kanamo? Unsay akong sala kanimo nga gibutang mo man kanako ug sa tibuok kong gingharian kining labihan kadako nga sala? Dili maayo ang imong gibuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nganong gibuhat mo man kini?” ");
INSERT INTO cebocb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Mitubag si Abraham, “Abi ko ug wala na gayoy nagtahod sa Dios niining dapita, ug nakahuna-huna ako nga basin ug patyon ninyo ako aron makuha ninyo ang akong asawa. ");
INSERT INTO cebocb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tinuod man pud nga managsoon kami, apan sa amahan lang ug dili sa inahan, ug gipangasawa ko siya. ");
INSERT INTO cebocb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Sa dihang giingnan ako sa Dios nga mobiya sa panimalay sa akong amahan, gisultihan ko si Sara nga ipaila ako nga iyang igsoon bisan asa kami paingon. Niining paagiha mapakita niya ang iyang paghigugma kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Gibalik ni Abimelec si Sara kang Abraham, ug gihatagan pa niya si Abraham ug mga karnero, baka, ug mga ulipon nga babaye ug lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Unya miingon siya kang Abraham, “Tan-awa! Ania ang akong yuta. Pagpili kamo ug dapit nga gusto ninyong puy-an.” ");
INSERT INTO cebocb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Miingon usab siya kang Sara, “Hatagan ko ang imong igsoon ug 1,000 pirasong pilak aron pagmatuod sa tanan ninyong kauban nga wala ka nako mahilabti ug nga wala ka nakahimo ug daotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Tungod sa pagkuha ni Abimelec kang Sara, gihimo sa Ginoo nga baog ang tanang mga babaye sa panimalay ni Abimelec. Busa nag-ampo si Abraham sa Dios, ug giayo sa Dios ang asawa ni Abimelec ug ang iyang mga ulipon nga babaye aron makaanak sila. Giayo usab sa Dios si Abimelec sa samang balatian. ");
INSERT INTO cebocb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Unya, gihinumdoman sa Ginoo si Sara sumala sa iyang gisaad. ");
INSERT INTO cebocb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Namabdos si Sara ug nanganak ug lalaki bisan tigulang na si Abraham. Natawo ang bata sa panahon gayod nga gitakda sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ginganlan ni Abraham ang bata nga gipanganak ni Sara, ug Isaac. ");
INSERT INTO cebocb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sa dihang walo na ka adlaw ang bata, gituli siya ni Abraham sumala sa gisugo sa Dios kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nag-edad si Abraham ug 100 ka tuig sa dihang natawo si Isaac. ");
INSERT INTO cebocb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Miingon si Sara, “Gipakatawa ako sa Dios sa kalipay, ug si bisan kinsa nga makadungog mahitungod niining nahitabo kanako mokatawa usab sama kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kinsay makasulti kang Abraham nga makapasuso pa ako ug bata? Apan nakaanak pa ako bisan tigulang na siya.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Midako si Isaac, ug sa adlaw nga gilutas siya nagpahigayon si Abraham ug usa ka dako nga kombira. ");
INSERT INTO cebocb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ug nakita ni Sara nga gisungog si Isaac sa anak ni Abraham kang Hagar nga Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Busa miingon si Sara kang Abraham, “Palayasa kining babayeng sulugoon ug ang iyang anak, kay dili makapanunod ang iyang anak sa katigayonan uban kang Isaac nga akong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nakapaguol gayod kini kang Abraham tungod kay anak usab niya si Ishmael. ");
INSERT INTO cebocb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Apan miingon ang Dios kaniya, “Ayaw kabalaka kang Ishmael ug kang Hagar. Tumana ang gusto ni Sara, kay maggikan kang Isaac ang mga kaliwat nga akong gisaad. ");
INSERT INTO cebocb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ug kon bahin kang Ishmael, hatagan ko usab siya ug daghang mga kaliwat ug mahimo usab silang usa ka nasod, tungod kay anak mo usab siya.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Pagkaugma, sayo kaayong mikuha si Abraham ug pagkaon ug tubig nga nasulod sa panit nga sudlanan, ug gibutang niya kini sa abaga ni Hagar. Unya gipalakaw niya si Hagar uban sa bata. Nagbaklay sila sa kamingawan sa Beersheba nga wala masayod kon asa sila paingon. ");
INSERT INTO cebocb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sa dihang nahurot na ang ilang tubig, gibilin niya ang iyang anak ilalom sa usa ka tanom ");
INSERT INTO cebocb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ug milakaw siya sa unahan, nga mga 100 ka metro ang gilay-on gikan sa bata. Milingkod siya didto ug midangoyngoy ug hilak ug miingon, “Dili ako makaantos nga motan-aw sa akong anak nga mamatay.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Unya, nadungog sa Dios ang paghilak sa bata. Ug gikan sa langit miingon ang anghel sa Dios kang Hagar, “Unsay imong gihilakan Hagar? Ayaw kahadlok; nadungog sa Dios ang hilak sa imong anak. ");
INSERT INTO cebocb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tindog ug bangona ang imong anak, kay himuon kong dako nga nasod ang iyang mga kaliwat.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Unya gipakita sa Dios kaniya ang usa ka atabay. Giadto niya kini ug gipuno niya ug tubig ang iyang sudlanan. Unya gipainom niya ang iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Wala pasagdi sa Dios si Ishmael hangtod nga midako siya. Mipuyo siya didto sa kamingawan sa Paran ug nahimo siyang usa ka mamamana. Unya, gipaminyo siya sa iyang inahan ngadto sa usa ka Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Niadtong panahona, miadto si Abimelec kang Abraham uban sa pangulo sa iyang mga sundalo nga si Picol. Miingon si Abimelec kang Abraham, “Gitabangan ka gayod sa Dios sa tanan mo nga gibuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Busa, panumpa dinhi sa ngalan sa Dios nga dili mo gayod ako budhian ingon man ang akong mga anak ug mga kaliwat. Ipakita ang imong kaayo kanako ug niini nga dapit diin ka nagpuyo ingon nga usa ka dumuduong, sama sa pagpakita ko sa akong kaayo kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Mitubag si Abraham, “Sige, gipanumpa ko.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Apan mireklamo si Abraham kang Abimelec mahitungod sa atabay nga giilog sa mga sulugoon ni Abimelec. ");
INSERT INTO cebocb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Miingon si Abimelec, “Wala ako makahibalo kon kinsa ang nagbuhat niini. Wala mo ako sultihi, ug karon lang ako nakadungog bahin niini.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Busa mikuha si Abraham ug mga karnero ug mga baka ug gihatag niya kini kang Abimelec, unya naghimo silang duha ug kasabotan. ");
INSERT INTO cebocb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Mikuha pa gayod si Abraham ug pito ka bayeng karnero ug iya kining gilain. ");
INSERT INTO cebocb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nangutana si Abimelec, “Unsay buot ipasabot nianang pito ka bayeng karnero nga imong gilain?” ");
INSERT INTO cebocb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Mitubag si Abraham, “Dawata kining pito ka bayeng karnero isip pagpamatuod nga ako ang nagkalot niini nga atabay.” ");
INSERT INTO cebocb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Gitawag nila kadtong dapita ug Beersheba tungod kay nanumpa silang duha didto. ");
INSERT INTO cebocb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Human sila makahimo sa ilang kasabotan didto sa Beersheba, mibalik si Abimelec ug si Picol sa yuta sa mga Filistihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nagtanom si Abraham ug usa ka kahoy nga tamarisko didto sa Beersheba ug misimba siya sa Ginoo, ang Dios nga walay kataposan. ");
INSERT INTO cebocb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Mipuyo si Abraham sa yuta sa mga Filistihanon sa hataas nga panahon. ");
INSERT INTO cebocb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Unya, gisulayan sa Dios si Abraham. Gitawag niya si Abraham, ug mitubag kini, “Ania ko!” ");
INSERT INTO cebocb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Unya, miingon ang Dios, “Dad-a ang imong bugtong ug pinalanggang anak nga si Isaac ug pangadto kamo sa yuta sa Moria. Tungas sa bukid nga akong itudlo kanimo ug ihalad mo siya kanako ingon nga halad nga sinunog.” ");
INSERT INTO cebocb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Pagkaugma, sayo pa kaayong mibangon si Abraham. Nagbugha siya ug pangsugnod alang sa halad, ug gikarga niya kini sa asno. Unya migikan siya kauban ni Isaac ug sa duha niya ka sulugoon nga lalaki paingon sa dapit nga giingon sa Dios kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sa ikatulo nga adlaw sa ilang lakaw, nakita ni Abraham sa unahan ang dapit nga giingon sa Dios kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Busa miingon si Abraham sa duha niya ka sulugoon, “Dinhi lang una kamo ug bantayi ninyo ang asno, kay motungas kami didto sa unahan ug mosimba sa Dios. Mobalik ra kami dayon.” ");
INSERT INTO cebocb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Gipapas-an ni Abraham kang Isaac ang mga sugnod, ug siya ang midala sa kutsilyo ug panghaling. ");
INSERT INTO cebocb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Samtang nanglakaw sila, miingon si Isaac, “Amahan ko!” Mitubag si Abraham, “Unsa, anak?” Nangutana si Isaac, “Adunay dala kitang panghaling ug sugnod apan hain ang karnero nga ighahalad?” ");
INSERT INTO cebocb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Mitubag si Abraham, “Anak, nagtagana ang Dios alang kanato ug karnero nga ighahalad.” Ug nagpadayon sila sa paglakaw. ");
INSERT INTO cebocb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sa pag-abot nila sa dapit nga giingon sa Dios, nagbuhat si Abraham ug halaran, ug gipahimutang niya ang mga sugnod ibabaw niini. Unya gigapos niya si Isaac ug gipahiluna ibabaw sa mga sugnod didto sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Pagkahuman, mikuha siya ug kutsilyo. Ug sa dihang patyon na unta niya si Isaac, ");
INSERT INTO cebocb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","gitawag siya sa anghel sa Ginoo gikan sa langit, “Abraham! Abraham!” Mitubag si Abraham, “Ania ko.” ");
INSERT INTO cebocb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Unya miingon ang anghel, “Ayaw pasipad-i ang bata! Karon napamatud-an ko na gayod nga aduna kay kahadlok sa Dios tungod kay wala mo ihikaw ang imong bugtong nga anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Paglingi ni Abraham, aduna siyay nakitang usa ka laking karnero nga ang sungay nasangit sa sampinit. Gikuha niya kini ug gihalad ingon nga halad nga sinunog puli sa iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ginganlan ni Abraham kadtong dapita ug “Magtagana ang Ginoo.” Busa hangtod karon adunay panultihon nga nag-ingon, “Sa Bukid sa Ginoo aduna siyay gitagana.” ");
INSERT INTO cebocb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Sa ikaduhang higayon, mitawag kang Abraham ang anghel sa Ginoo gikan sa langit. ");
INSERT INTO cebocb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","Miingon siya, “Mao kini ang giingon sa Ginoo: Nanumpa ako sa akong kaugalingon nga panalanginan ka nako tungod kay wala mo ihikaw ang imong bugtong nga anak kanako. Padaghanon ko ang imong mga kaliwat nga daw sama kadaghan sa mga bitoon sa langit ug sa balas sa baybayon. Sakopon nila ang mga lungsod sa ilang mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pinaagi sa imong mga kaliwat, panalanginan ko ang tanang mga nasod sa kalibotan, tungod kay mituman ka kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Human niadto, mibalik si Abraham ngadto sa mga sulugoon. Unya miadto sila sa Beersheba ug didto na mipuyo. ");
INSERT INTO cebocb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Wala madugay, nabalitaan ni Abraham nga si Nahor nga iyang igsoon aduna nay mga anak kang Milca nga iyang asawa: ");
INSERT INTO cebocb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","si Uz ang magulang, sunod si Buz, ug sunod si Kemuel (nga amahan ni Aram), ");
INSERT INTO cebocb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","si Kesed, si Hazo, si Pildash, si Jidlaf, ug si Betuel. ");
INSERT INTO cebocb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Si Betuel mao ang amahan ni Rebeka.) ");
INSERT INTO cebocb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Aduna usab mga anak si Nahor sa usa pa niya ka asawa nga si Reuma, ug kini mao sila si Teba, Gaham, Tahash, ug Maaca. ");
INSERT INTO cebocb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nagkinabuhi si Sara ug 127 ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Namatay siya didto sa Kiriat Arba (nga mao ang Hebron) sa yuta sa Canaan. Nagbangotan pag-ayo si Abraham sa pagkamatay ni Sara. ");
INSERT INTO cebocb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Unya, mibiya una si Abraham sa haya sa iyang asawa ug nakigkita sa mga Hitihanon. Miingon siya kanila, ");
INSERT INTO cebocb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nagpuyo ako dinhi sa inyong dapit ingon nga usa ka dumuduong, busa tugoti ninyo ako nga makaangkon ug yuta nga kalubngan ko sa akong asawa.” ");
INSERT INTO cebocb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Mitubag ang mga Hitihanon kang Abraham, ");
INSERT INTO cebocb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, pamati una kanamo. Giila ka namo nga usa ka dungganon nga tawo, busa mahimo mong ilubong ang imong asawa sa among labing maayong lubnganan. Walay usa kanamo nga modumili sa paghatag kanimo ug dapit nga kalubngan mo sa imong asawa.” ");
INSERT INTO cebocb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Diha-diha miyukbo si Abraham atubangan sa mga Hitihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Unya miingon siya, “Kon uyon kamo nga ilubong ko dinhi ang akong asawa, tabangi ninyo ako sa paghangyo kang Efron nga anak ni Zohar ");
INSERT INTO cebocb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nga ibaligya niya kanako ang iyang langub nga anaa sa daplin sa iyang yuta sa Macpela. Sultihi ninyo siya nga bayran ko siya sa husto nga kantidad dinhi mismo sa inyong atubangan aron mapanag-iya ko na ang langub aron himuon ko nga lubnganan.” ");
INSERT INTO cebocb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Naa diay didto si Efron nga naglingkod uban sa iyang mga katagilungsod nga Hitihanon. Busa mitubag siya kang Abraham nga nadunggan sa tanang mga Hitihanon nga nagtigom didto sa may ganghaan sa lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Miingon siya, “Paminawa ko sir. Sa atubangan niining akong mga katagilungsod ihatag ko kanimo ang tibuok nga yuta apil na ang langub. Busa ilubong na ang imong asawa.” ");
INSERT INTO cebocb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Miyukbo pag-usab si Abraham atubangan sa mga Hitihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Unya miingon siya kang Efron nga nadunggan sa tanan, “Paminawa ako. Paliton ko ang yuta. Dawata ang akong bayad aron malubong ko na ang akong asawa didto.” ");
INSERT INTO cebocb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Mitubag si Efron kang Abraham, ");
INSERT INTO cebocb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, ang yuta nagkantidad ug 400 kabuok nga pilak. Apan dili kana mahinungdanon. Sige, ilubong na didto ang imong asawa.” ");
INSERT INTO cebocb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Miuyon si Abraham sa kantidad nga giingon ni Efron, busa nagbayad siya ug 400 kabuok nga pilak sa atubangan sa mga Hitihanon. Ang mga pilak gibasi sumala sa timbangan sa mga negosyante niadtong panahona. ");
INSERT INTO cebocb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Busa napanag-iya ni Abraham ang yuta ni Efron sa Macpela, sa sidlakang bahin sa Mamre, apil na ang langub ug ang mga kahoy libot sa uma. Saksi ang tanang mga Hitihanon nga nagtigom didto sa may ganghaan sa lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Unya gilubong ni Abraham si Sara didto sa langub sa uma sa Macpela nga duol sa Mamre nga mao ang Hebron, nga sakop sa yuta sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Busa ang uma apil ang langub, nga kaniadto gipanag-iya sa mga Hitihanon, napanag-iya na ni Abraham ug gibuhat niya kini nga lubnganan. ");
INSERT INTO cebocb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tigulang na kaayo si Abraham ug gipanalanginan siya sa Ginoo sa tanang butang. ");
INSERT INTO cebocb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Usa niana ka adlaw, giingnan niya ang iyang tigdumala nga sulugoon nga nag-atiman sa tanan niyang mga kabtangan, “Itapion ang imong kamot taliwala sa duha ko ka paa, ");
INSERT INTO cebocb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ug panumpa kanako sa ngalan sa Ginoo, nga Dios sa langit ug sa yuta, nga dili ka magpili ug pangasaw-onon alang sa akong anak nga si Isaac gikan sa mga Canaanhon nga kauban nato nga nagpuyo dinhi. ");
INSERT INTO cebocb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Adto sa dapit nga akong gigikanan, ug didto sa akong kaparyentehan pagpili ug babaye nga ipaasawa sa akong anak nga si Isaac.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Apan nangutana ang sulugoon, “Kon pananglit dili mouban ang babaye dinhi, dad-on ko ba si Isaac didto?” ");
INSERT INTO cebocb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Mitubag si Abraham, “Ayaw gayod dad-a si Isaac didto! ");
INSERT INTO cebocb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ang Ginoo, nga Dios sa langit, ang nagdala kanako dinhi gikan sa panimalay sa akong amahan, ug sa dapit diin ako natawo. Ug nanumpa siya nga ihatag niya kining yuta sa Canaan sa akong mga kaliwat. Busa lakaw kay ipadala sa Ginoo ang iyang anghel nga mag-uban kanimo aron makakita ka didto ug pangasaw-onon alang sa akong anak. ");
INSERT INTO cebocb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kon dili mouban ang babaye kanimo, wala kay tulubagon niining panumpa mo kanako. Apan ayaw lang dad-a didto ang akong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Busa gitapion sa sulugoon ang iyang kamot taliwala sa duha ka paa ni Abraham nga iyang agalon, ug nanumpa siya nga tumanon niya ang gisugo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pagkahuman, mikuha ang sulugoon ug napulo ka kamelyo ug mga mahalong butang nga iyang dad-on ingon nga gasa gikan sa iyang agalon nga si Abraham. Unya miadto siya sa Aram Naharaim, ang lungsod nga gipuy-an ni Nahor. ");
INSERT INTO cebocb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pag-abot sa sulugoon didto, gipalubog niya ang mga kamelyo duol sa atabay sa gawas sa lungsod. Kilom-kilom na ug mao usab kini ang tingsag-ob sa mga babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nag-ampo ang sulugoon, “Ginoo, Dios sa akong agalon nga si Abraham, hinaut nga hatagan mo ug kalamposan ang akong tuyo dinhi, ug ipakita mo ang imong kaayo sa akong agalon. ");
INSERT INTO cebocb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ania, nagtindog ako dinhi sa daplin sa atabay ug manganhi ang mga babaye niini nga lungsod sa pagsag-ob. ");
INSERT INTO cebocb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kon mohangyo ako sa usa ka dalaga nga paimnon ako gikan sa iyang tibod, ug mosugot siya ug moingon nga paimnon usab niya ang akong mga kamelyo, hinaut nga siya na ang babaye nga imong gipili nga mahimong asawa sa imong sulugoon nga si Isaac. Niining paagiha mahibaloan ko nga gipakita mo ang imong kaayo sa akong agalon nga si Abraham.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Wala pa siya makahuman ug ampo, miabot si Rebeka nga adunay gipas-an nga tibod. Si Rebeka anak ni Betuel, ug si Betuel anak ni Nahor ug ni Milca. Si Nahor igsoon ni Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Hilabihan gayod katahom ni Rebeka ug putli pa. Nanaog siya ngadto sa atabay ug gisudlan niya ug tubig ang iyang tibod. Unya misaka siya. ");
INSERT INTO cebocb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Midagan ang sulugoon aron pagsugat kaniya ug miingon, “Palihog paimna ako gikan sa imong tibod bisan gamay lang.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mitubag si Rebeka, “Sige sir, inom lang.” Unya gipaubos niya ang tibod ug gikuptan samtang miinom ang sulugoon. ");
INSERT INTO cebocb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Pagkahuman niya ug painom sa sulugoon, miingon siya, “Magsag-ob usab ako alang sa imong mga kamelyo hangtod nga makainom silang tanan.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Dali-dali niyang gibubo ang tubig sa imnanan sa mga mananap ug mibalik siya sa atabay sa pagsag-ob ug usab. Nagsige siya ug sag-ob hangtod nga nakainom ang tanang mga kamelyo. ");
INSERT INTO cebocb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Naniid lang ang sulugoon ug naghuna-huna kon gipalampos na ba sa Ginoo ang iyang tuyo sa pag-adto niadto nga dapit. ");
INSERT INTO cebocb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pagkahuman ug inom sa mga kamelyo, gipagawas sa sulugoon ang dala niyang singsing nga bulawan nga adunay gibug-aton nga mga unom ka gramo, ug ang duha ka pulseras nga bulawan nga adunay gibug-aton nga mga 115 ka gramo. Gihatag niya kini kang Rebeka, ");
INSERT INTO cebocb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ug nangutana siya, “Kang kinsa kang anak? Aduna ba kami makatulgan sa inyo karong gabii?” ");
INSERT INTO cebocb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mitubag si Rebeka, “Anak ako ni Betuel nga anak nga lalaki ni Nahor ug ni Milca. ");
INSERT INTO cebocb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Aduna kamoy makatulgan didto sa amo, ug aduna usab daghan nga mga dagami ug kumpay alang sa inyong mga kamelyo.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Unya miyukbo ang sulugoon ug misimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Miingon siya, “Dalaygon ang Ginoo, nga Dios sa akong agalon nga si Abraham. Iya gayod nga gipakita ang iyang padayon nga kaayo sa akong agalon. Gigiyahan niya ako ngadto sa panimalay sa mga paryente sa akong agalon.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Midagan si Rebeka pauli sa balay sa iyang inahan ug gisugilon niya kanila ang tanan nga nahitabo. ");
INSERT INTO cebocb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Adunay igsoon si Rebeka nga ginganlag Laban. Nakadungog kini sa iyang gisugilon mahitungod sa gipanulti sa tawo kaniya, ug nakita usab niini ang singsing ug pulseras nga iyang gisul-ob. Busa midagan si Laban paingon sa atabay ug miadto sa tawo nga giingon ni Rebeka. Nakita niya kini nga nagtindog duol sa atabay, uban sa mga kamelyo. ");
INSERT INTO cebocb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Miingon si Laban kaniya, “Ikaw diay ang tawo nga gipanalanginan sa Ginoo. Nganong nagtindog ka ra man dinhi? Tana sa balay, giandam ko na ang kuwarto alang kaninyo ug ang dapit alang sa mga kamelyo.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Miuban ang sulugoon kang Laban. Pag-abot nila sa balay, gihaw-asan ni Laban ug mga karga ang mga kamelyo ug unya gihatagan niyag dagami ug kumpay. Gidad-an usab niyag tubig ang sulugoon ug ang iyang mga kauban, aron makapanghimasa sila. ");
INSERT INTO cebocb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Sa dihang gisukaran na sila ug pagkaon, miingon ang sulugoon, “Dili ako mokaon hangtod nga dili ko masulti ang akong tuyo sa pag-anhi dinhi.” Mitubag si Laban, “Sige, suginli kami.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Miingon siya, “Sulugoon ako ni Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Gipanalanginan sa Ginoo ang akong agalon ug adunahan na kaayo siya karon. Gihatagan siya sa Ginoo ug daghang mga karnero, kanding, baka, kamelyo, asno, pilak, bulawan, ug mga sulugoon nga lalaki ug babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ug nanganak pa si Sara nga asawa sa akong agalon bisan ug tigulang na kaayo siya. Ug kining anak nila nga lalaki mao ang manunod sa tanan niyang mga kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Gipapanumpa ako sa akong agalon nga tumanon ang iyang sugo. Miingon siya, ‘Ayaw pagpili ug pangasaw-onon alang sa akong anak gikan sa mga babaye dinhi sa Canaan kansang yuta akong gipuy-an karon. ");
INSERT INTO cebocb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Lakaw sa panimalay sa akong amahan, ug didto sa akong mga kaparyentehan pagpili ug babaye nga ipaasawa sa akong anak.’ ");
INSERT INTO cebocb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Apan nangutana ako kaniya, ‘Unsa may akong buhaton kon dili mouban ang babaye kanako?’ ");
INSERT INTO cebocb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Mitubag siya, ‘Ang Ginoo nga akong gituman kanunay mopadala sa iyang anghel sa pag-uban kanimo aron molampos ka sa imong tuyo didto. Makakita ka ug pangasaw-onon sa akong anak gikan sa akong mga paryente, sa panimalay sa akong amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kon moadto ka sa akong kaparyentehan, ug dili nila pakuyogon ang babaye kanimo, gawasnon ka na sa imong panumpa.’ ");
INSERT INTO cebocb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Busa pag-abot ko ganina sa atabay, nag-ampo ako. Matod ko, ‘Ginoo, Dios sa akong agalon nga si Abraham, hinaut nga hatagan mo ug kalamposan ang akong tuyo sa pag-anhi dinhi. ");
INSERT INTO cebocb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ania, nagtindog ako dinhi sa daplin sa atabay. Kon adunay moabot nga dalaga aron pagsag-ob, mohangyo ako nga paimnon bisan ug gamay lang nga tubig gikan sa iyang tibod. ");
INSERT INTO cebocb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kon paimnon niya ako ug moingon siya nga sag-oban usab niya ang akong mga kamelyo, hinaut nga siya na ang babaye nga gipili mo nga mahimong asawa sa anak sa akong agalon.’ ");
INSERT INTO cebocb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Wala pa gani ako makahuman sa akong hilom nga pag-ampo, miabot na si Rebeka nga adunay gipas-an nga tibod. Mikanaog siya ngadto sa atabay ug nagsag-ob. Miingon ako kaniya, ‘Palihog paimna ako.’ ");
INSERT INTO cebocb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Unya gipaubos niya ang iyang gipas-an nga tibod, ug miingon, ‘Sige, inom lang, ug paimnon ko usab ang imong mga kamelyo.’ Busa miinom ako, ug unya gipainom usab niya ang mga kamelyo. ");
INSERT INTO cebocb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Pagkahuman niadto, gipangutana ko siya kon kang kinsa siyang anak. Mitubag siya, ‘Kang Betuel nga anak nga lalaki ni Nahor ug ni Milca.’ “Unya gitaoran ko ug singsing ang iyang ilong ug gisul-oban ug mga pulseras ang iyang bukton. ");
INSERT INTO cebocb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Unya miyukbo ako ug misimba sa Ginoo. Gidayeg ko ang Ginoo, nga Dios sa akong agalon nga si Abraham. Siya ang nagtultol kanako sa husto nga dapit, aron makita ko ang anak sa paryente sa akong agalon nga mahimong asawa sa iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Karon, gusto kong mahibaloan kon ipaasawa ba ninyo si Rebeka kang Isaac, ingon nga pagpakita sa inyong tinuod nga kaayo sa akong agalon. Sultihi ninyo ako aron mahibaloan ko usab kon unsa ang akong buhaton.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Mitubag si Laban ug si Betuel, “Tungod kay kabubut-on kini sa Ginoo, wala na kamiy ikasulti. ");
INSERT INTO cebocb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ania si Rebeka, dad-a siya sa imong pagpauli aron mahimo siyang asawa sa anak sa imong agalon, sumala sa giingon sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pagkadungog niadto sa sulugoon, miyukbo siya ug misimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Unya gipagawas niya ang dala niyang mga alahas nga hinimo gikan sa pilak ug bulawan, ug ang mga bisti, ug gihatag kang Rebeka. Gihatagan usab niya ug mahalon nga mga gasa ang igsoong lalaki ug ang inahan ni Rebeka. ");
INSERT INTO cebocb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Unya nangaon ang sulugoon ug ang iyang mga kauban, ug didto sila nangatulog niadtong gabhiona. Pagmata nila pagkabuntag, miingon ang sulugoon, “Mopauli na ako sa akong agalon.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Apan miingon ang igsoong lalaki ug ang inahan ni Rebeka, “Tugoti lang una si Rebeka nga magpabilin dinhi uban kanamo bisan ug napulo lang ka adlaw, pagkahuman niana, makalakaw na kamo.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Apan miingon ang sulugoon, “Ayaw na ninyo akog langana. Gipalampos sa Ginoo ang akong tuyo sa pag-anhi dinhi, busa tugoti na ninyo ako sa pagbalik ngadto sa akong agalon.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Mitubag sila, “Tawgon una nato si Rebeka ug pangutan-on kon unsay iyang ikasulti.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Busa gitawag nila si Rebeka ug gipangutana, “Mouban ka ba niining tawhana?” Mitubag si Rebeka, “Oo, mouban ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Busa, gipagikan nila si Rebeka, ang iyang tig-atiman, ug ang sulugoon ni Abraham ug ang iyang mga kauban. ");
INSERT INTO cebocb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Gipanalanginan nila si Rebeka sa iyang paglakaw. Miingon sila, “Igsoon namo, hinaut pa nga maggikan kanimo ang daghan kaayo nga mga kaliwat. Hinaut pa nga pildihon sa imong mga kaliwat ang mga lungsod sa ilang mga kaaway.” ");
INSERT INTO cebocb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Sa dihang naandam na ang tanan, misakay si Rebeka ug ang iyang mga sulugoong babaye sa mga kamelyo, ug misunod sa sulugoon ni Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Unya, si Isaac nga tua nagpuyo sa Negev bag-o lang miabot gikan sa Beer Lahai Roi. ");
INSERT INTO cebocb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Sa dihang kilom-kilom na, migawas si Isaac aron sa paglakaw-lakaw didto sa kaumahan. Nakita niya nga adunay mga kamelyo nga nagpadulong. ");
INSERT INTO cebocb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Sa dihang nakita ni Rebeka si Isaac, nanaog siya sa iyang kamelyo ");
INSERT INTO cebocb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ug nangutana sa sulugoon ni Abraham, “Kinsa kanang tawong galakaw sa uma sa pagtagbo kanato?” Mitubag ang sulugoon, “Siya ang akong agalon nga si Isaac.” Busa gitabonan ni Rebeka ug belo ang iyang nawong. ");
INSERT INTO cebocb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Gisugilon sa sulugoon kang Isaac ang tanan niyang gibuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Pagkahuman, gidala ni Isaac si Rebeka didto sa tolda nga gipuy-an kaniadto sa iyang inahan nga si Sara. Nahimo niyang asawa si Rebeka. Gimahal gayod niya kini, ug nawala ang iyang kasubo sa pagkamatay sa iyang inahan. ");
INSERT INTO cebocb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nagminyo pag-usab si Abraham, ug Ketura ang ngalan sa iyang asawa. ");
INSERT INTO cebocb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ang ilang mga anak mao sila si Zimran, Jokshan, Medan, Midian, Ishbak, ug Shua. ");
INSERT INTO cebocb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jokshan mao ang amahan ni Sheba ug ni Dedan, ug ang mga kaliwat ni Dedan mao ang mga Ashurnon, Letushnon, ug Leumnon. ");
INSERT INTO cebocb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ang mga anak ni Midian mao sila si Efa, Efer, Hanoc, Abida, ug Eldaa. Silang tanan ang mga kaliwat ni Ketura. ");
INSERT INTO cebocb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Gipapanunod ni Abraham ang tanan niyang mga kabtangan kang Isaac. Apan sa wala pa siya mamatay, gihatagan niya ug mga gasa ang iyang mga anak sa uban niyang mga asawa, ug gipapuyo niya sila sa mga kayutaan sa sidlakan, halayo sa iyang anak nga si Isaac. ");
INSERT INTO cebocb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Nagkinabuhi si Abraham ug 175 ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Namatay siya nga tigulang na kaayo, ug giipon siya sa iyang mga paryente nga nangamatay na. ");
INSERT INTO cebocb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Gilubong siya sa iyang mga anak nga si Isaac ug si Ishmael didto sa langub sa Macpela, sa sidlakang bahin sa Mamre, sa uma nga gipanag-iya kaniadto ni Efron nga anak ni Zohar nga Hitihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ang maong uma gipalit ni Abraham sa mga Hitihanon. Didto gilubong si Abraham ug ang iyang asawa nga si Sara. ");
INSERT INTO cebocb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Human mamatay si Abraham, gipanalanginan sa Dios si Isaac ug didto siya nagpuyo sa Beer Lahai Roi. ");
INSERT INTO cebocb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Mao kini ang sugilanon mahitungod sa pamilya ni Ishmael nga anak ni Abraham kang Hagar nga Ehiptohanon, nga sulugoon ni Sara. ");
INSERT INTO cebocb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mao kini ang mga ngalan sa mga anak ni Ishmael gikan sa kamagulangan hangtod sa kamanghoran: Nebayot, Kedar, Adbeel, Mibsam, ");
INSERT INTO cebocb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO cebocb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafish, ug Kedema. ");
INSERT INTO cebocb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sila ang mga anak ni Ishmael. Ang ilang mga ngalan mao ang gingalan sa nagkalain-laing mga dapit nga ilang gipuy-an. Sila ang nangulo sa 12 ka mga tribo sa mga kaliwat ni Ishmael. ");
INSERT INTO cebocb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Nagkinabuhi si Ishmael ug 137 ka tuig. Namatay siya ug giipon sa iyang mga paryente nga nangamatay na. ");
INSERT INTO cebocb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nagpuyo ang iyang mga kaliwat sa mga dapit gikan sa Havila hangtod sa Shur, sa sidlakang bahin sa Ehipto paingon sa Asiria. Ug mipuyo didto nga kontra sa tanan nilang kaparyentehan. ");
INSERT INTO cebocb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Mao kini ang sugilanon mahitungod sa pamilya ni Isaac nga anak ni Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Nag-edad si Isaac ug 40 ka tuig sa dihang nangasawa siya kang Rebeka nga anak ni Betuel nga Aramehanon, nga taga-Padan Aram. Si Rebeka igsoon ni Laban nga Aramehanon usab. ");
INSERT INTO cebocb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tungod kay baog si Rebeka, nag-ampo si Isaac sa Ginoo nga makaanak siya. Gitubag sa Ginoo ang iyang pag-ampo, busa namabdos si Rebeka. ");
INSERT INTO cebocb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nabati ni Rebeka nga nagdinuotay ang mga bata sa sulod sa iyang tiyan. Miingon si Rebeka, “Unsa kining nahitabo kanako?” Busa nangutana siya sa Ginoo mahitungod niini. ");
INSERT INTO cebocb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Miingon ang Ginoo kaniya, “Duha ka nasod ang maggikan sa duha ka bata nga anaa sa imong sabakan; duha ka pundok sa mga katawhan nga magkontrahanay. Ang usa mahimong gamhanan kay sa usa. Ang magulang moalagad sa manghod.” ");
INSERT INTO cebocb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sa dihang nanganak na si Rebeka, kaluha ang iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ang una nga migawas pulahon ug pamanit ug balhiboon, busa ginganlan nila siya ug Esau. ");
INSERT INTO cebocb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sa paggawas sa ikaduha, nagkupot kini sa tikod ni Esau, busa ginganlan nila siya ug Jacob. Nag-edad si Isaac ug 60 ka tuig sa dihang nanganak si Rebeka ug kaluha. ");
INSERT INTO cebocb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Sa dihang nanagko na sila, nahimong hanas nga mangangayam si Esau ug kanunay siyang atua sa uma, samtang si Jacob hilomon ug gustong anaa ra sa mga tolda. ");
INSERT INTO cebocb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Gipangga ni Isaac si Esau tungod kay ganahan siyang mokaon sa mga gipangayam niini, apan si Jacob gipangga ni Rebeka. ");
INSERT INTO cebocb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Usa niana ka adlaw, samtang nagluto si Jacob ug sabaw, miabot si Esau gikan sa pagpangayam nga naluya sa kagutom. ");
INSERT INTO cebocb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Miingon siya kang Jacob, “Pakan-a ra ako nianang imong giluto nga pulang sabaw kay labihan ako kagutom.” (Mao kana nga gitawag si Esau ug Edom.) ");
INSERT INTO cebocb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Apan mitubag si Jacob, “Hatagan ka nako niini kon ihatag mo kanako ang imong katungod ingon nga magulang.” ");
INSERT INTO cebocb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Miingon si Esau, “Mamatay na ako sa kagutom, unsay pulos niining akong katungod sa pagkamagulang!” ");
INSERT INTO cebocb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mitubag si Jacob, “Kon mao kana, panumpa una kanako.” Busa nanumpa si Esau nga kang Jacob na ang katungod sa pagkamagulang. ");
INSERT INTO cebocb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Gihatagan dayon siya ni Jacob ug pan ug sabaw. Human niyag kaon ug inom, milakaw ra pud siya dayon. Sa gibuhat ni Esau, gipakawalay-bili niya ang iyang katungod sa pagkamagulang. ");
INSERT INTO cebocb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Adunay kagutom nga miabot sa dapit nga gipuy-an ni Isaac, gawas niadtong kagutom nga miabot sa panahon pa ni Abraham. Busa miadto si Isaac kang Abimelec nga hari sa mga Filistihanon sa Gerar. ");
INSERT INTO cebocb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nagpakita ang Ginoo kaniya ug miingon, “Ayaw pag-adto sa Ehipto; didto puyo sa dapit nga itudlo ko kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Puyo lang una dinhi kay ubanan ka nako ug panalanginan. Ihatag ko kanimo ug sa imong mga kaliwat kining tibuok yuta. Tumanon ko ang akong gisaad sa imong amahan nga si Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Padaghanon ko ang imong mga kaliwat nga daw sama kadaghan sa mga bitoon sa langit, ug ihatag ko kanila kining tibuok yuta. Ug pinaagi kanila, panalanginan ko ang tanang mga katawhan sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Himuon ko kini tungod kay mituman si Abraham kanako. Mituman siya sa tanan kong mga sugo ug mga balaod.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Busa mipuyo si Isaac sa Gerar. ");
INSERT INTO cebocb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Matahom si Rebeka, busa kon mangutana ang mga taga-Gerar kang Isaac bahin sa iyang asawa motubag siya nga igsoon niya kini. Nahadlok siyang moingon nga asawa niya si Rebeka kay basin ug patyon nila siya aron makuha kini. ");
INSERT INTO cebocb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sa dugay-dugay na nga nagpuyo sila si Isaac didto sa Gerar, nahitabo nga namintana si Abimelec nga hari sa mga Filistihanon ug nakita niya nga nagparayganay sila si Isaac ug si Rebeka. ");
INSERT INTO cebocb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Busa gipatawag niya si Isaac ug giingnan, “Asawa mo diay siya! Nganong miingon ka man nga igsoon mo siya?” Mitubag si Isaac, “Tungod kay nahadlok ako nga mamatay tungod kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Miingon si Abimelec, “Dili maayo ang gibuhat mo kanamo. Kon nahitabo pa nga nakighilawas kaniya ang usa sa akong mga tawo, nakasala unta kami tungod kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Unya gipahimangnoan ni Abimelec ang tanang mga tawo. Miingon siya, “Si bisan kinsa nga mobuhat ug daotan niini nga lalaki o sa iyang asawa patyon gayod.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nananom si Isaac niadtong dapita ug nakaani siya ug 100 ka pilo niadtong tuiga, tungod kay gipanalanginan siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nagpadayon ang iyang pag-uswag hangtod nga naadunahan na siya pag-ayo. ");
INSERT INTO cebocb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nasina kaniya ang mga Filistihanon tungod kay daghan na ang iyang mga karnero, kanding, baka, ug mga sulugoon. ");
INSERT INTO cebocb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Busa gitabonan nila ug yuta ang mga atabay nga gipakalot kaniadto sa mga sulugoon sa iyang amahan nga si Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Unya, miingon si Abimelec kang Isaac, “Biya na dinhi, kay daghan na kaayo kamo kay kanamo.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Busa mibiya si Isaac. Nagpatindog siya sa iyang tolda didto sa walog sa Gerar, ug didto na mipuyo. ");
INSERT INTO cebocb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Gipakalot niya pag-usab ang mga atabay nga gikalot sa mga tawo sa panahon sa iyang amahan nga si Abraham. Gipangtabonan kini sa mga Filistihanon human namatay si Abraham. Ginganlan ni Isaac ang mga atabay sa mao gihapon nga ngalan nga gihatag kaniadto ni Abraham. ");
INSERT INTO cebocb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Didto sa walog, nagkalot ug bag-ong atabay ang mga sulugoon ni Isaac ug nakakaplag sila ug tubod. ");
INSERT INTO cebocb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Apan nakiglalis ang mga bakero nga taga-Gerar sa mga bakero ni Isaac kay ila kuno kadtong atabay. Busa ginganlan ni Isaac ang atabay ug Esek, kay nakiglalis man ang mga taga-Gerar kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nagkalot pag-usab ang mga sulugoon ni Isaac ug lain nga atabay, apan gilalisan gihapon kini nila ug sa mga taga-Gerar. Busa ginganlan ni Isaac ang atabay ug Sitna. ");
INSERT INTO cebocb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mibiya sila si Isaac didto ug nagkalot pag-usab ug lain pa gayod nga atabay. Wala na nila kini lalisi, busa ginganlan kini ni Isaac ug Rehobot, kay miingon siya, “Karon gihatagan kita sa Ginoo ug halapad nga dapit ug modaghan pa gayod kita dinhi.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Unya, mibiya si Isaac niadto nga lugar ug mibalhin sa Beersheba. ");
INSERT INTO cebocb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ug nianang gabii sa iyang pag-abot, nagpakita ang Ginoo kaniya ug miingon, “Ako ang Dios sa imong amahan nga si Abraham. Ayaw kahadlok kay kauban mo ako. Panalanginan ka nako ug hatagan ug daghang mga kaliwat tungod kang Abraham nga akong alagad.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Busa naghimo si Isaac ug halaran ug misimba sa Ginoo. Nagpatindog siya ug tolda niadtong dapita ug nagkalot ang iyang mga sulugoon ug atabay. ");
INSERT INTO cebocb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Unya miadto si Abimelec kang Isaac. Kauban niya si Ahuzat nga iyang magtatambag ug si Picol nga komander sa iyang mga sundalo. Gikan pa sila sa Gerar. ");
INSERT INTO cebocb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nangutana si Isaac kanila, “Nganong mianhi man kamo? Dili ba nga naglagot man kamo kanako, ug gipapahawa pa gani ninyo ako sa inyong dapit?” ");
INSERT INTO cebocb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Mitubag sila, “Nakita namo nga ang Ginoo nag-uban kanimo, busa nakahuna-huna kami nga maghimo kita ug kasabotan nga atong panumpaan. Isaad kanamo ");
INSERT INTO cebocb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","nga dili ka mohimo ug daotan kanamo sama nga wala kami manghilabot kanimo sa didto ka pa sa among dapit. Giayo ka namo pagtagad ug gipapahawa sa maayong kabubut-on. Ug karon, gipanalanginan ka pa gayod sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Busa nagpakombira si Isaac alang kanila ug nangaon sila ug nag-inom. ");
INSERT INTO cebocb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Sayo pa kaayo sa sunod nga adlaw, nanumpa sila sa usag usa. Unya gipagikan sila ni Isaac uban sa maayong kabubut-on. ");
INSERT INTO cebocb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Niadto usab nga adlaw, miabot ang mga sulugoon ni Isaac ug misugilon kaniya nga adunay tubig ang atabay nga ilang gikalot. ");
INSERT INTO cebocb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ginganlan ni Isaac kadto nga atabay ug Sheba. Busa hangtod karon kadto nga dapit gitawag nga Beersheba. ");
INSERT INTO cebocb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sa nag-edad na si Esau ug 40 ka tuig, nangasawa siya kang Judit nga anak ni Beeri nga Hitihanon. Gipangasawa usab niya si Basemat nga anak ni Elon nga usa usab ka Hitihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Kining duha ka babaye nakapaguol kaayo kang Isaac ug kang Rebeka. ");
INSERT INTO cebocb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Sa natigulang na si Isaac ug halos dili na makakita, gitawag niya ang kamagulangan niyang anak nga si Esau. Miingon siya, “Anak.” Mitubag si Esau, “Ania ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Miingon si Isaac, “Tigulang na ako ug wala kita masayod kon kanus-a ako mamatay. ");
INSERT INTO cebocb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Busa kuhaa ang imong pana ug pangayam alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Unya, lutoi ako sa lamiang pagkaon nga akong paborito ug dad-a kini kanako aron akong kan-on ug pagkahuman, panalanginan ka nako sa dili pa ako mamatay.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Namati diay si Rebeka samtang nakigsulti si Isaac kang Esau. Busa sa dihang nakalakaw na si Esau aron sa pagpangayam, ");
INSERT INTO cebocb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","giingnan ni Rebeka ang iyang anak nga si Jacob, “Nadunggan ko nga giingnan sa imong amahan si Esau nga ");
INSERT INTO cebocb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","mangayam ug unya lutoan siya sa lamiang pagkaon aron nga sa dili pa kuno siya mamatay, panalanginan niya si Esau sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Busa anak, tumana ang akong isugo kanimo: ");
INSERT INTO cebocb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Lakaw didto sa panon sa atong mga mananap ug pagkuha ug duha ka batan-on ug tambok nga kanding, kay lutoan ko ang imong amahan sa lamiang pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Unya dad-on mo kini kaniya aron panalanginan ka niya sa dili pa siya mamatay.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Apan miingon si Jacob sa iyang inahan nga si Rebeka, “Balhiboon si Esau ug ako dili. ");
INSERT INTO cebocb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Basin ug hikapon ako sa akong amahan ug makaingon siya nga gilimbongan ko siya ug tunglohon hinuon niya ako imbis nga panalanginan.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mitubag si Rebeka, “Anak, akoy manubag kon tunglohon ka. Buhata lang ang akong gisugo kanimo. Lakaw na ug kuha-i ako didto ug duha ka kanding.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Busa mikuha si Jacob ug duha ka kanding ug gidala niya sa iyang inahan. Unya nagluto si Rebeka sa lamiang pagkaon nga paborito ni Isaac. ");
INSERT INTO cebocb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Gikuha ni Rebeka ang labing maayo nga bisti ni Esau nga didto sa ilang balay ug gipasul-ob kini kang Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Gibutangan niya ug panit sa kanding ang bukton ni Jacob apil na ang iyang liog. ");
INSERT INTO cebocb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Unya gihatag niya kang Jacob ang lamiang pagkaon ug ang pan nga iyang giluto. ");
INSERT INTO cebocb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Gidala kadto ni Jacob sa iyang amahan ug miingon, “Amahan ko!” Miingon si Isaac, “Kinsa ka, anak ko?” ");
INSERT INTO cebocb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Mitubag si Jacob, “Ako si Esau, ang kamagulangan mong anak. Nabuhat ko na ang imong gisugo kanako. Bangon una ug kaon sa akong pinangayaman aron mapanalanginan mo ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Miingon si Isaac, “Anak, pagkadali ra nimong nakakuha!” Mitubag si Jacob, “Gitabangan ako sa Ginoo nga imong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Miingon si Isaac, “Paduol kanako anak aron mahikap ka nako ug masiguro ko kon ikaw ba gayod si Esau o dili.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Busa nagpaduol si Jacob, ug gihikap siya sa iyang amahan nga miingon, “Ang tingog murag kang Jacob apan ang bukton kang Esau.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wala mailhi ni Isaac si Jacob, kay balhiboon man ang bukton niini sama sa kang Esau. Sa wala pa niya panalangini si Jacob, ");
INSERT INTO cebocb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nangutana siya pag-usab, “Ikaw ba gayod si Esau?” Mitubag si Jacob, “Oo, ako gayod.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Miingon si Isaac, “Dad-a dinhi ang imong giluto aron makakaon ako sa imong pinangayaman, ug pagkahuman panalanginan ka nako.” Busa gihatagan siya ni Jacob sa pagkaon ug ilimnon, ug mikaon siya ug miinom. ");
INSERT INTO cebocb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Unya miingon si Isaac kang Jacob, “Paduol kanako, anak, ug hagki ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Mipaduol si Jacob kaniya ug mihalok. Sa dihang nasimhotan ni Isaac ang iyang bisti, gipanalanginan niya si Jacob nga nag-ingon, “Kining baho sa akong anak sama sa baho sa uma nga gipanalanginan sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hinaut pa nga hatagan ka sa Dios ug tambok nga yuta, yamog gikan sa langit, ug abunda nga pagkaon ug ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hinaut nga moyukbo ug moalagad kanimo ang daghang mga katawhan. Hinaut nga magmando ka sa imong mga kaparyentehan ug magpasakop sila kanimo. Tunglohon ang gatunglo kanimo, ug ang nagpanalangin kanimo panalanginan usab.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Bag-o pa lang gayong nakabiya si Jacob human siya panalangini ni Isaac sa dihang miabot si Esau gikan sa pagpangayam. ");
INSERT INTO cebocb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nagluto usab siya ug lamiang pagkaon ug iya kining gidala sa iyang amahan. Miingon siya, “Amahan ko, bangon ug kaon niining akong pinangayaman aron mapanalanginan mo ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nangutana si Isaac kaniya, “Kinsa ka?” Mitubag siya, “Ako si Esau, ang kamagulangan mong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Pagkadungog niadto ni Isaac, nangurog ang tibuok niyang lawas ug miingon, “Kinsa diay kadtong nangayam ug nagdala dinhi kanako ug pagkaon? Mao pa lang gayoy akong pagkahuman ug kaon sa dihang miabot ka. Gihatag ko na kaniya ang akong panalangin ug dili ko na gayod kadto mabakwi.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Sa pagkadungog niini ni Esau, midangoyngoy siya. Miingon siya, “Amahan ko, panalangini usab ako!” ");
INSERT INTO cebocb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Apan mitubag si Isaac, “Gilimbongan ako sa imong manghod ug nakuha na niya ang panalangin nga alang unta kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Miingon si Esau, “Ikaduha na kini nga higayon nga iya akong gilimbongan. Angayan gayod kaniya ang iyang ngalan nga Jacob. Giilog na niya ang akong katungod ingon nga magulang ug karon giilog pa gayod niya ang panalangin nga alang kanako.” Unya nangutana siya, “Tay, wala ka na ba gayoy panalangin nga gitagana alang kanako?” ");
INSERT INTO cebocb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Mitubag si Isaac, “Gihimo ko na siya nga imong agalon ug gihimo ko usab ang tanan niyang mga kaparyentehan nga iyang mga sulugoon. Gipasaligan ko na siya sa abunda nga pagkaon ug ilimnon. Busa aduna pa bay akong mahimo alang kanimo, anak ko?” ");
INSERT INTO cebocb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nagpakiluoy si Esau sa iyang amahan, “Amahan ko, usa lang ba gayoy imong panalangin? Panalangini usab ako!” Ug mihilak siya ug kusog. ");
INSERT INTO cebocb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Miingon si Isaac kaniya, “Ang yuta nga imong puy-an dili tambok ug walay yamog nga madawat gikan sa langit. ");
INSERT INTO cebocb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mabuhi ka pinaagi sa imong espada, ug moalagad ka sa imong manghod. Apan kon mosukol ka kaniya, makalingkawas ka sa iyang gahom.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Gidumtan ni Esau si Jacob tungod sa panalangin nga gihatag sa iyang amahan ngadto kang Jacob. Miingon si Esau sa iyang kaugalingon, “Hapit na mamatay ang akong amahan, ug inigkahuman sa mga adlaw sa pagbangotan alang kaniya, patyon ko si Jacob.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Apan nabalitaan ni Rebeka ang plano ni Esau, busa gipatawag niya si Jacob ug gisultihan, “Ang imong magulang nga si Esau nagplano sa pagpatay kanimo aron mahupay ang iyang kasuko kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Busa pamati sa akong isulti: Lakaw, ikyas ngadto sa Haran, didto sa akong igsoon nga si Laban. ");
INSERT INTO cebocb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Didto ka lang una hangtod nga mahupay ang kasuko sa imong magulang, ");
INSERT INTO cebocb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ug malimtan na niya ang imong gibuhat kaniya. Ipakuha ko lang unya ikaw kon wala na siyay kasuko kanimo. Dili ako makaantos nga dungan kamong mawala kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Unya, miingon si Rebeka kang Isaac, “Gipul-an na ako sa akong kinabuhi tungod niining mga asawa ni Esau nga mga Hitihanon. Kon mangasawa usab si Jacob ug babayeng Hitihanon nga taga-dinhi, maayo pag mamatay na lang ako!” ");
INSERT INTO cebocb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Busa gipatawag ni Isaac si Jacob. Gipanalanginan niya kini ug gimandoan, “Ayaw gayod pangasawa ug Canaanhon. ");
INSERT INTO cebocb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Adto sa Padan Aram, didto sa panimalay ni Betuel nga amahan sa imong inahan, ug pangasaw-a ang usa sa mga anak nga dalaga ni Laban nga igsoon sa imong inahan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Hinaut nga panalanginan ka sa Makagagahom nga Dios ug hatagan ug daghang mga kaliwat aron mahimo kamong usa ka dakong pundok sa mga katawhan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hinaut nga ihatag usab niya kanimo ug sa imong mga kaliwat ang panalangin nga gihatag niya kang Abraham, aron mapanag-iya mo kining yuta nga imong gipuy-an karon ingon nga dumuduong. Kini nga yuta gihatag sa Dios kang Abraham.” ");
INSERT INTO cebocb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Unya gipalakaw ni Isaac si Jacob sa Padan Aram, sa dapit ni Laban nga anak ni Betuel nga Aramehanon. Si Laban igsoon ni Rebeka nga inahan ni Jacob ug ni Esau. ");
INSERT INTO cebocb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Nahibaloan ni Esau nga gipanalanginan ni Isaac si Jacob ug gipaadto sa Padan Aram aron didto mangita ug pangasaw-onon. Nahibalo usab siya nga sa dihang gipanalanginan ni Isaac si Jacob, gimandoan niya kini nga dili mangasawa ug taga-Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ug nahibaloan usab niya nga mituman si Jacob sa ilang ginikanan ug miadto sa Padan Aram. ");
INSERT INTO cebocb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Busa nakita ni Esau nga dili diay gusto sa iyang amahan ang mga babaye nga taga-Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Busa miadto siya sa iyang uyoan nga si Ishmael nga anak ni Abraham kang Hagar. Ug gawas sa iyang duha ka asawa, gipangasawa pa gayod niya si Mahalat nga anak ni Ishmael ug igsoon ni Nebayot. ");
INSERT INTO cebocb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mibiya si Jacob sa Beersheba ug milakaw paingon sa Haran. ");
INSERT INTO cebocb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sa dihang misalop na ang adlaw, nakaabot siya sa usa ka dapit ug didto siya nagpabilin niadtong gabhiona. Mikuha siya ug usa ka bato ug iya kining giunlanan sa iyang pagkatulog. ");
INSERT INTO cebocb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Unya, nagdamgo siya nga adunay usa ka hagdan nga nagbarog sa yuta ug misangko sa langit. Nakita niya ang mga anghel sa Dios nga nagsaka-kanaog sa hagdan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nakita usab niya ang Ginoo nga nagtindog sa ibabaw sa hagdan ug miingon kaniya, “Ako mao ang Ginoo, nga Dios ni Abraham ug ni Isaac. Ihatag ko kanimo ug sa imong mga kaliwat kining yuta nga imong gihigdaan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ang imong mga kaliwat mahimong sama kadaghan sa abog sa yuta. Magkatag kamo sa nagkalain-laing bahin niining yutaa. Pinaagi kanimo ug sa imong mga kaliwat, panalanginan ko ang tanang mga katawhan sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Hinumdomi gayod kanunay nga kauban mo ako ug bantayan ka nako bisan asa ka paingon. Dad-on ka nako pagbalik niining yutaa ug dili ka nako biyaan hangtod nga matuman ko ang akong saad kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Unya nakamata si Jacob ug miingon sa iyang kaugalingon, “Wala ako makahibalo nga ania diay ang Ginoo niining dapita.” ");
INSERT INTO cebocb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Gikulbaan siya ug miingon, “Katingalahan kining dapita! Puloy-anan kini sa Dios ug kini ang pultahan paingon sa langit.” ");
INSERT INTO cebocb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Pagkabuntag, sayo kaayong mibangon si Jacob. Gikuha niya ang bato nga iyang giunlanan ug gipatindog ingon nga usa ka handomanan. Unya gibuboan niya kini ug lana aron idedikar ngadto sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ginganlan ni Jacob kadtong dapita ug Betel. Apan kaniadto Luz ang ngalan niadto nga dapit. ");
INSERT INTO cebocb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Unya nanumpa si Jacob nga nag-ingon, “O Dios, kon ubanan mo ako ug bantayan niining akong lakaw ug hatagan ug pagkaon ug bisti, ");
INSERT INTO cebocb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ug kon makabalik ako sa balay sa akong amahan nga walay daotang mahitabo kanako, ilhon ka nako Ginoo nga akong Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kining bato nga akong gipatindog isip usa ka handomanan magpamatuod sa imong presensya niini nga dapit. Ug ihatag ko kanimo ang ikapulo sa tanan nga ihatag mo kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nagpadayon si Jacob sa iyang lakaw hangtod nga nakaabot siya sa yuta sa mga taga-sidlakan. ");
INSERT INTO cebocb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ug didto sa hawanan aduna siyay nakitang usa ka atabay. Sa tapad niini adunay naglubog nga tulo ka panon sa mga karnero, kay didto ang kuhaanan sa mga tawo ug tubig nga ipainom sa mga karnero. Gitabonan kini nga atabay ug dakong bato. ");
INSERT INTO cebocb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hulaton una sa mga magbalantay sa karnero nga matigom ang tanang mga karnero ayha nila ligiron ang gitabon nga bato. Pagkahuman nila ug painom sa mga karnero, ibalik na usab nila pagtabon ang bato. ");
INSERT INTO cebocb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Unya, nangutana si Jacob sa mga magbalantay sa karnero, “Mga higala, taga-asa kamo?” Mitubag sila, “Taga-Haran.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nangutana si Jacob, “Nakaila ba kamo kang Laban nga apo ni Nahor?” Mitubag sila, “Oo, nakaila kami kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nagpadayon sa pagpangutana si Jacob, “Kumusta siya?” Mitubag sila, “Maayo man. Tan-awa, anaa ang iyang anak nga si Raquel, nagpadulong dinhi uban sa mga karnero.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Miingon si Jacob kanila, “Tungod kay sayo pa man ug dili pa panahon sa pagtigom sa mga karnero, maayo tingali nga paimnon ninyo sila ug pasab-sabon pag-usab.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mitubag sila, “Dili namo kana mahimo kon dili matigom ang tanang mga karnero. Kon ania na ang tanan, ligiron na namo ang tabon nga bato ug paimnon sila.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nakigsulti pa si Jacob kanila sa dihang miabot si Raquel uban sa mga karnero sa iyang amahan, kay siya man ang nagbantay niini. ");
INSERT INTO cebocb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Pagkakita ni Jacob kang Raquel uban sa mga karnero sa iyang uyoan nga si Laban, miadto siya sa atabay, ug giligid niya ang bato ug gipainom ang mga karnero. ");
INSERT INTO cebocb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Pagkahuman, gihagkan ni Jacob si Raquel ug mihilak siya sa kalipay. ");
INSERT INTO cebocb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Miingon siya kang Raquel nga paryente siya sa iyang amahan ug anak ni Rebeka. Mao nga midagan si Raquel pauli ug gisuginlan niya ang iyang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pagkadungog ni Laban sa balita bahin kang Jacob nga iyang pag-umangkon kang Rebeka, midagan siya sa pagtagbo kaniya. Gigakos niya si Jacob ug gihagkan, ug gidala sa ilang balay. Ug didto gisugilon ni Jacob kang Laban ang tanan nga nahitabo. ");
INSERT INTO cebocb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Miingon si Laban kaniya, “Tinuod gayod nga kadugo ka nako.” Paglabay sa usa ka bulan nga pagpuyo ni Jacob uban kanila ni Laban, ");
INSERT INTO cebocb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","miingon si Laban kaniya, “Dili maayo nga magtrabaho ka alang kanako nga walay suhol tungod lang kay pag-umangkon ka nako. Sultihi ako kon unsa ang gusto mo nga isuhol ko kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Adunay duha ka anak si Laban nga dalaga. Si Lea ang magulang ug si Raquel ang manghod. ");
INSERT INTO cebocb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Nindot ug mata si Lea, apan matahom ug nindot ug lawas si Raquel. ");
INSERT INTO cebocb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tungod kay nahigugma si Jacob kang Raquel, miingon siya kang Laban, “Moalagad ako kanimo ug pito ka tuig kon ipaminyo mo kanako si Raquel.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Mitubag si Laban, “Mas maayo pa nga ipaminyo ko siya kanimo kay sa lain nga lalaki. Pabilin dinhi uban kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Busa mialagad si Jacob kang Laban ug pito ka tuig aron mapangasawa niya si Raquel. Tungod sa iyang paghigugma kang Raquel murag pila lang ka adlaw alang kaniya ang pito ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Paglabay sa pito ka tuig, miingon si Jacob kang Laban, “Nahuman na ang panahon sa akong pag-alagad kanimo, busa ihatag na kanako si Raquel aron mag-ipon na kami.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ug misugot si Laban, busa nagpakombira si Laban ug giimbitar niya ang tanang mga tawo niadtong dapita. ");
INSERT INTO cebocb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Apan pagkagabii, si Lea ang gidala ni Laban ngadto kang Jacob ug dili si Raquel. Ug nakigdulog si Jacob kang Lea. ");
INSERT INTO cebocb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Gihatag ni Laban kang Lea ang iyang sulugoon nga babaye nga si Zilpa aron mahimong sulugoon ni Lea.) ");
INSERT INTO cebocb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pagkabuntag, nahibaloan ni Jacob nga si Lea diay ang iyang gikadulog. Busa giadtoan niya si Laban ug giingnan, “Nganong gibuhat mo kini kanako? Nangalagad ako kanimo aron mapangasawa ko si Raquel. Nganong gilimbongan mo man ako?” ");
INSERT INTO cebocb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Mitubag si Laban, “Wala mabatasan dinhi sa among dapit nga mouna ug minyo ang manghod sa magulang. ");
INSERT INTO cebocb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hulata lang nga mahuman ang usa ka semana nga pagsaulog niining kasal kay ipaminyo ko usab kanimo si Raquel, kana kon moalagad ka kanako pag-usab ug laing pito ka tuig.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Misugot si Jacob sa giingon ni Laban. Pagkahuman sa usa ka semana nga pagsaulog sa ilang kasal ni Lea, gipaminyo ni Laban si Raquel kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Gihatag ni Laban kang Raquel ang iyang sulugoon nga babaye nga si Bilha aron mahimong sulugoon ni Raquel.) ");
INSERT INTO cebocb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Busa nakigdulog usab si Jacob kang Raquel. Mas gimahal niya si Raquel kay kang Lea. Unya nangalagad si Jacob kang Laban ug laing pito ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nakita sa Ginoo nga wala higugmaa ni Jacob si Lea, busa gihatagan niya ug anak si Lea, apan si Raquel walay anak. ");
INSERT INTO cebocb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Namabdos si Lea ug nanganak ug lalaki ug ginganlan niya kini ug Ruben, kay miingon siya, “Nakita sa Ginoo ang akong pag-antos, ug sigurado nga higugmaon na ako sa akong bana karon.” ");
INSERT INTO cebocb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Namabdos siya pag-usab ug nanganak ug usa ka lalaki. Miingon siya, “Gihatagan ako pag-usab sa Ginoo ug usa ka anak nga lalaki kay nakadungog siya nga wala ako higugmaa sa akong bana.” Busa ginganlan niya ang bata ug Simeon. ");
INSERT INTO cebocb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Namabdos pag-usab si Lea ug nanganak ug usa pa gayod ka lalaki. Miingon siya, “Karon higugmaon na gayod ako sa akong bana kay tulo na ang among anak nga lalaki.” Busa ginganlan niya ang bata ug Levi. ");
INSERT INTO cebocb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Namabdos pa gayod pag-usab si Lea ug nanganak ug usa na usab ka lalaki. Miingon siya, “Karon dayegon ko ang Ginoo.” Busa ginganlan niya ang bata ug Juda. Human niadto, miundang siya pagpanganak. ");
INSERT INTO cebocb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Wala gihapon mamabdos si Raquel, busa nasina siya kang Lea. Miingon siya kang Jacob, “Hatagi akog anak kay kon dili mamatay gayod ako!” ");
INSERT INTO cebocb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nasuko si Jacob ug miingon kaniya, “Ngano, Dios ba ako? Siya ang nagbuot nga dili ka makaanak.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Miingon si Raquel, “Kon mao kana pakigdulog kang Bilha nga akong sulugoon aron pinaagi kaniya makaangkon usab ako ug anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Busa gihatag niya si Bilha kang Jacob ingon nga asawa, ug nakigdulog si Jacob kang Bilha. ");
INSERT INTO cebocb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Namabdos si Bilha ug nanganak ug lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Miingon si Raquel, “Gikuha na sa Dios ang akong kaulawan. Gitubag niya ang akong pag-ampo ug gihatagan niya ako ug usa ka anak nga lalaki.” Busa ginganlan niya ang bata ug Dan. ");
INSERT INTO cebocb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Namabdos pag-usab si Bilha nga sulugoon ni Raquel ug nanganak siya sa ikaduha nila nga anak nga lalaki ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Miingon si Raquel, “Nakigbisog ako pag-ayo sa akong igsoon, ug nakadaog ako.” Busa ginganlan niya ang bata ug Neftali. ");
INSERT INTO cebocb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sa dihang miundang na sa pagpanganak si Lea, gihatag niya kang Jacob ang iyang sulugoon nga si Zilpa. ");
INSERT INTO cebocb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Namabdos si Zilpa ug nanganak ug lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Miingon si Lea, “Palaran ako.” Busa ginganlan niya ang bata ug Gad. ");
INSERT INTO cebocb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nanganak si Zilpa ug lalaki nga mao ang ikaduha nila nga anak ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Miingon si Lea, “Malipayon ako kaayo! Karon tawgon ako sa mga kababayen-an ug malipayon.” Busa ginganlan niya ang bata ug Aser. ");
INSERT INTO cebocb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Usa niadto ka higayon, sa panahon sa ting-ani ug trigo, miadto si Ruben sa uma. Nakakita siya ug mga tanom nga mandragora ug gidala niya kini sa iyang inahan nga si Lea. Pagkakita niadto ni Raquel miingon siya kang Lea, “Palihog, hatagi ako nianang mga mandragora nga gidala sa imong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Apan mitubag si Lea, “Dili pa ba igo nga giilog mo ang akong bana? Ug karon kuhaon mo pa apil ang mga mandragora sa akong anak?” Miingon si Raquel, “O sige, padulgon ko si Jacob kanimo karong gabii baylo sa mga mandragora sa imong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Pag-abot ni Jacob gikan sa uma nianang pagkagabii, gitagbo siya ni Lea ug giingnan, “Kinahanglan nga makigdulog ka kanako karong gabii, tungod kay gibayran ko na ikaw kang Raquel sa mga mandragora nga gidala sa akong anak.” Busa nakigdulog si Jacob kang Lea niadtong gabhiona. ");
INSERT INTO cebocb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Gitubag sa Dios ang pag-ampo ni Lea ug namabdos siya. Nanganak siya sa ikalima nga anak nga lalaki nila ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Miingon si Lea, “Gigantihan ako sa Dios kay gihatag ko ang akong sulugoon sa akong bana.” Busa ginganlan niya ang bata ug Isacar. ");
INSERT INTO cebocb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Namabdos pag-usab si Lea ug nanganak siya sa ikaunom nila nga anak nga lalaki ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Miingon siya, “Gihatagan ako sa Dios ug maayo gayod nga gasa. Pasidunggan na ako niini karon sa akong bana kay nahatagan ko na siya ug unom ka mga anak nga pulos lalaki.” Busa ginganlan niya ang bata ug Zabulon. ");
INSERT INTO cebocb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pagkahuman, nanganak si Lea ug babaye ug ginganlan niya kini ug Dina. ");
INSERT INTO cebocb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Gihinumdoman sa Dios si Raquel. Gitubag niya ang pag-ampo niini ug gitugotan nga makaanak. ");
INSERT INTO cebocb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Namabdos si Raquel ug nanganak ug lalaki. Miingon siya, “Gikuha sa Dios ang akong kaulawan.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Busa ginganlan niya ang bata ug Jose, kay miingon siya, “Hinaut pa nga hatagan ako sa Ginoo ug usa pa ka anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Human manganak si Raquel kang Jose, miingon si Jacob kang Laban, “Tugoti na ako nga makapauli sa among dapit. ");
INSERT INTO cebocb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ihatag kanako ang akong mga asawa ug mga anak nga gitrabahoan ko kanimo, kay mopauli na ako. Nasayod ka kon giunsa ko pagpangalagad kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Mitubag si Laban, “Kon mahimo, pabilin lang una dinhi. Pinaagi sa panagna, nahibaloan ko nga gipanalanginan ako sa Ginoo tungod kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Isulti kon pila ang suhol nga gusto mo kay bayran ka nako.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Miingon si Jacob, “Nasayod ka kon giunsa ko pagpangalagad kanimo ug kon giunsa pagdaghan sa imong kahayopan tungod sa akong pag-atiman. ");
INSERT INTO cebocb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sa pag-abot ko dinhi gamay ra ang imong kahayopan, apan karon daghan na kaayo, kay gipanalanginan ka sa Ginoo tungod kanako. Karon angay na tingali akong maninguha alang sa akong kaugalingong panimalay.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Nangutana si Laban, “Unsa may gusto mo nga suhol ko kanimo?” Mitubag si Jacob, “Ayaw na lang ako suholi. Padayonon ko ang pag-atiman sa imong kahayopan kon mosugot ka niini nga kondisyon: ");
INSERT INTO cebocb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tugoti ako nga motan-aw sa imong mga kahayopan karon, ug kuhaon ko ang itom nga mga karnero ug kabang nga mga kanding. Mao na kana ang mahimo kong suhol. ");
INSERT INTO cebocb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Sa umaabot, mahibaloan mo kon kasaligan ako o dili pinaagi sa pagsusi sa mga kahayopan nga isuhol mo kanako. Kon adunay makita kang kanding nga dili kabang o karnero nga dili itom, isipa nga kana kinawat ko.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Mitubag si Laban, “Kon mao kana ang imong gusto, mosugot ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Apan niadtong adlawa, gilain ni Laban ang kabang nga mga kanding nga lalaki ug babaye, apil ang mga karnero nga itom. Gipaatiman niya kini sa iyang mga anak nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Gipahilayo niya kini kang Jacob ngadto sa usa ka dapit nga baklayon pa ug tulo ka adlaw. Ang nahibilin nga mga mananap mao ang gibantayan ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Unya, namutol si Jacob ug mga sanga sa kahoy nga poplar, almond, ug armon ug iya kining gipanit-panitan aron mogawas ang puti nga bahin niini. ");
INSERT INTO cebocb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Unya gibutang niya ang maong mga sanga sa imnanan sa mga hayop aron makita nila kini kon moinom sila. Sa panahon sa ilang pagpanguwag, ug inigpanginom nila, maghabalay ang mga hayop atubangan niadtong mga sanga. Unya, manganak sila ug kabang. ");
INSERT INTO cebocb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Apan lahi ang gihimo ni Jacob sa mga karnero: Inigtinghabal nila, ipaatubang niya kini sa kabang ug itom nga mga kanding ni Laban. Niining paagiha nakatigom si Jacob ug mga kahayopan ug wala niya kini iipon sa mga hayop ni Laban. ");
INSERT INTO cebocb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kon maghabalay na ang mga himsog nga hayop didto sa imnanan, ibutang dayon ni Jacob ang mga sanga sa ilang atubangan. ");
INSERT INTO cebocb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Apan kon ang mga mananap nga luya ang maghabalay, dili niya ibutang ang mga sanga. Busa ang mga hayop nga luya iya ni Laban ug ang mga himsog iya ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Niining paagiha, naadunahan pag-ayo si Jacob. Midaghan ang iyang mga kahayopan apil na ang mga kamelyo ug mga asno. Midaghan usab ang iyang mga sulugoon nga lalaki ug babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nakadungog si Jacob nga miingon ang mga anak nga lalaki ni Laban, “Gikuha ni Jacob ang tanang kabtangan sa atong amahan, ug gikan niini nahimo siyang adunahan.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nakamatikod usab si Jacob nga lahi na kaysa kaniadto ang pagtagad ni Laban kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Miingon ang Ginoo kang Jacob, “Pauli na sa dapit sa imong katigulangan, didto sa imong mga paryente, ug mag-uban ako kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Busa gipatawag ni Jacob ang iyang mga asawa nga sila si Raquel ug si Lea didto sa sabsabanan sa iyang mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Miingon siya kanila, “Nakamatikod ako nga lahi na ang pagtagad sa inyong amahan kanako. Apan wala ako pasagdi sa Dios sa akong amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nakahibalo usab kamo nga nag-alagad ako sa inyong amahan kutob sa akong mahimo, ");
INSERT INTO cebocb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","apan gitunto niya ako. Napulo ka higayon nga giusab-usab niya ang akong suhol. Apan wala motugot ang Dios nga makahimo siyag kadaot kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kon moingon si Laban nga ang kabang nga mga kanding mao ang akong suhol, kabang usab ang tanang anak sa mga kanding. ");
INSERT INTO cebocb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Gikuha sa Dios ang mga kahayopan sa inyong amahan ug gihatag kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Midugang pag-ingon si Jacob, “Sa panahon sa tingpanguwag sa mga hayop, nagdamgo ako. Nakita ko nga ang mga laking kanding nga mihabal sa mga bayeng kanding mga kabang. ");
INSERT INTO cebocb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sa akong damgo gitawag ako sa anghel sa Dios. Miingon siya, ‘Jacob!’ Mitubag ako, ‘Ania ako.’ ");
INSERT INTO cebocb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ug unya miingon siya, ‘Tan-awa, ang tanang mga laking kanding nga naghabal sa mga bayeng kanding mga kabang. Gibuhat ko kini tungod kay nakita ko ang tanan nga gibuhat kanimo ni Laban. ");
INSERT INTO cebocb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ako ang Dios nga nagpakita kanimo didto sa Betel, sa dapit diin gibuboan mo ug lana ang bato nga gipatindog mo ingon nga handomanan, ug diin nanumpa ka kanako. Karon, biya niining dapita ug pauli sa dapit diin ka natawo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Mitubag si Raquel ug si Lea kang Jacob, “Wala na kamiy mapanunod gikan sa among amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Laing tawo na ang iyang pagtan-aw kanamo. Gibaligya niya kami ug nahurot na niya ug gasto ang bili namo. ");
INSERT INTO cebocb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ang tanang bahandi nga gikuha sa Dios gikan kaniya isipon na namo nga among panulondon ug sa among mga anak. Busa tumana ang giingon sa Dios kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Nangandam si Jacob sa pagpauli sa Canaan, sa dapit sa iyang amahan nga si Isaac. Gipasakay niya ang iyang mga anak ug mga asawa sa mga kamelyo. Gidala niya ang iyang mga kahayopan ug ang tanang kabtangan nga iyang natigom sa Padan Aram. ");
INSERT INTO cebocb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Naatol kadto nga milakaw si Laban sa pagpanupi sa iyang mga karnero, ug samtang wala siya gikuha ni Raquel ang iyang mga dios-dios. ");
INSERT INTO cebocb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nalingla ni Jacob si Laban nga Aramehanon tungod kay wala siya mosugilon niini nga mobiya na siya. ");
INSERT INTO cebocb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Dala ni Jacob sa iyang paglakaw ang tanan niyang kabtangan. Mitabok siya sa Suba sa Eufrates paingon sa bukid sa Gilead. ");
INSERT INTO cebocb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tulo na ka adlaw ang milabay sa dihang nahibaloan ni Laban nga milayas sila si Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Busa giuban niya ang iyang mga paryente ug gigukod nila si Jacob sulod sa pito ka adlaw. Naapsan nila sila si Jacob didto sa bukid sa Gilead. ");
INSERT INTO cebocb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Niadtong gabhiona, nagpakita ang Dios kang Laban nga Aramehanon pinaagi sa damgo. Miingon ang Dios kaniya, “Ayaw hilabti si Jacob.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Nagpatindog na si Jacob sa iyang tolda sa bukid sa Gilead sa dihang naapsan siya ni Laban. Ug didto na usab nagpatindog si Laban ug ang iyang mga paryente sa ilang mga tolda. ");
INSERT INTO cebocb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Miingon si Laban kang Jacob, “Nganong gibuhat mo kini kanako? Nganong gilingla mo ako? Imo pang gidala ang akong mga anak nga murag mga bihag sa gira. ");
INSERT INTO cebocb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nganong gilingla mo ako ug milakaw nga wala mananghid kanako? Kon nag-ingon pa kamo, ako unta kamong gipalakaw nga adunay kasadya sa sonata sa tamborin ug harpa. ");
INSERT INTO cebocb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wala mo gani ako pahaloka sa akong mga apo ug mga anak. Binuang kining imong gibuhat. ");
INSERT INTO cebocb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aduna gayod unta akoy katungod nga mobuhat ug daotan kanimo, apan gipahimangnoan ako kagabii sa Dios sa imong amahan nga dili ka hilabtan. ");
INSERT INTO cebocb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nahibalo ako nga gimingaw ka na pag-ayo sa inyo, busa gusto ka na nga mopauli. Apan nganong gikawat mo man ang akong mga dios?” ");
INSERT INTO cebocb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Mitubag si Jacob kaniya, “Wala ako mananghid kanimo kay nahadlok ako nga basin ug pugson mo pagkuha gikan kanako ang imong mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Apan bahin sa imong mga dios nga nawala, si bisan kinsa nga nagkuha niini, mamatay. Sa atubangan sa atong mga paryente, tan-awa kon adunay kabtangan ka ba dinhi kanamo ug kon aduna, kuhaa.” Wala makahibalo si Jacob nga si Raquel diay ang nagkuha sa mga dios-dios ni Laban. ");
INSERT INTO cebocb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Busa gipangita ni Laban ang iyang mga dios-dios sa tolda ni Jacob, sa tolda ni Lea, ug sa tolda sa duha ka sulugoon nga babaye, apan wala gayod niya kini makita. Migawas siya sa tolda ni Lea, ug misulod sa tolda ni Raquel. ");
INSERT INTO cebocb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Apan gitagoan na ni Raquel ang mga dios-dios ilalom sa muntora sa kamelyo, ug iya kining gilingkoran. Nangita si Laban didto sa tibuok tolda ni Raquel apan wala gayod siyay nakita. ");
INSERT INTO cebocb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Miingon si Raquel kaniya, “Amahan ko, ayaw lang kasuko kon dili ako makatindog kay naa man gud ang akong binulan.” Padayon nga nangita si Laban apan wala gayod niya makita ang mga dios-dios. ");
INSERT INTO cebocb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Wala na mapugngi ni Jacob ang iyang kasuko, busa miingon siya kang Laban, “Unsa may nahimo ko batok kanimo? Unsa may akong sala nga gigukod mo man gayod ako? ");
INSERT INTO cebocb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Karon nga nasusi mo na ang tanan kong mga kabtangan, aduna ka bay nakita nga imo? Kon anaa, ibutang kini dinhi sa atubangan sa akong mga paryente ug sa imong mga paryente, ug sila ang mohukom kanato. ");
INSERT INTO cebocb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Sa 20 ka tuig nga didto ako sa inyo, bisan kausa wala gayod makuha-i sa ilang pagburos ang imong mga bayeng karnero ug kanding. Ug wala gayod ako makakaon sa imong mga laking karnero. ");
INSERT INTO cebocb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wala ko na dad-a kanimo ang mga hayop nga gipatay sa ihalas nga mga mananap; giilisan ko kini dayon. Gipabayran mo usab kanako ang mga hayop nga gikawat panahon man sa adlaw o sa gabii. ");
INSERT INTO cebocb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nag-antos ako sa kainit sa adlaw, ug sa katugnaw sa kagabhion, ug kulang ako kanunay sa tulog. ");
INSERT INTO cebocb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sa 20 ka tuig nga pagpuyo ko sa inyo, 14 ka tuig akong nag-alagad kanimo alang sa imong duha ka anak nga babaye, ug unom ka tuig sa pagbantay sa imong mga kahayopan. Ug sulod usab nianang mga tuiga, kanapulo mo usab-usaba ang akong suhol. ");
INSERT INTO cebocb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kon wala pa ako ubani sa Dios nga gitahod sa akong amahan nga si Isaac, nga mao usab ang Dios ni Abraham, gipalayas mo na tingali ako nga wala gayoy dala. Apan nakita sa Dios ang akong kalisod ug paghago, busa gibadlong ka niya kagabii.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Mitubag si Laban, “Kanang mga babaye akong mga anak, ug ang ilang mga anak akong mga apo. Ug kanang mga kahayopan ako usab. Tanan nga makita mo ako. Apan, unsa pa may akong mahimo sa akong mga anak ug mga apo karon? ");
INSERT INTO cebocb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Sige, maghimo kita ug kasabotan ug pamatud-an ta kini.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Busa mikuha si Jacob ug dako nga bato ug iya kining gipatindog isip handomanan. ");
INSERT INTO cebocb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Unya gisugo niya ang iyang mga paryente nga magtapok ug mga bato diha daplin niini. Pagkahuman, nangaon sila duol sa tinapok nga mga bato. ");
INSERT INTO cebocb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ginganlan ni Laban ang tinapok nga mga bato ug Jegar Sahaduta. Apan ginganlan kini ni Jacob nga Galeed. ");
INSERT INTO cebocb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Miingon si Laban, “Kining tinapok nga mga bato magpamatuod sa kasabotan natong duha.” Mao kana ang hinungdan kon nganong ginganlan kadtong maong tinapok ug Galeed. ");
INSERT INTO cebocb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Gitawag usab kini ug Mizpa, tungod kay miingon si Laban, “Hinaut pa nga bantayan kita sa Ginoo sa atong panagbulag. ");
INSERT INTO cebocb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ug kon dili mo ayohon pagtratar ang akong mga anak, o maminyo ka pa ug lain, hinumdomi nga bisan dili ako masayod, anaa ang Dios nga saksi sa atong kasabotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Miingon pa gayod si Laban kang Jacob, “Ania ang tinapok nga mga bato ug ang bato nga handomanan nga magpamatuod sa atong kasabotan. ");
INSERT INTO cebocb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kining tinapok nga mga bato ug ang bato nga handomanan mao ang magpamatuod sa atong kasabotan nga dili ako molapas niining tinapok nga mga bato aron paghimo ug daotan kanimo, ug dili ka usab molapas niining tinapok nga mga bato ug bato nga handomanan aron paghimo ug daotan kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hinaut pa nga ang Dios sa imong apohan nga si Abraham ug ang Dios sa akong amahan nga si Nahor, nga mao usab ang mga Dios sa ilang amahan nga si Tera, mao ang mohukom kanatong duha.” Nanumpa usab si Jacob sa ngalan sa Dios nga gitahod sa iyang amahan nga si Isaac. ");
INSERT INTO cebocb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Naghalad si Jacob didto sa bukid, ug unya gitawag niya ang iyang mga paryente ug nangaon sila. Nagpabilin sila didto sa bukid nianang gabhiona. ");
INSERT INTO cebocb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Sayo kaayo nianang pagkabuntag, gihalokan ni Laban ug gipanalanginan ang iyang mga anak ug mga apo, ug milakaw siya balik sa iyang dapit. ");
INSERT INTO cebocb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mipadayon usab sila si Jacob sa ilang lakaw, ug gitagbo siya sa mga anghel sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pagkakita ni Jacob kanila, miingon siya, “Mga sundalo kini sa Dios.” Busa ginganlan niya kadto nga dapit ug Mahanaim. ");
INSERT INTO cebocb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nagsugo si Jacob ug mga tawo nga mouna kaniya ngadto sa iyang igsoon nga si Esau didto sa yuta sa Seir, ang dapit nga gitawag usab ug Edom. ");
INSERT INTO cebocb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Gimandoan niya sila sa pag-ingon, “Ingna ninyo akong agalon nga si Esau nga mao kini ang akong gisulti: Nangumusta gikan sa imong alagad nga si Jacob. Mipuyo ako uban kang Laban sulod sa dugayng panahon ug karon pa ako makapauli, ");
INSERT INTO cebocb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","aduna akoy mga torong baka, asno, karnero, kanding, ug mga sulugoon nga lalaki ug babaye. Gipadala ko kining mga tawo sa pagpahibalo ug paghangyo sa akong agalon nga unta pakitaan mo ako sa imong kaayo.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Pagbalik sa mga tawo nga gisugo ni Jacob, miingon sila, “Didto kami sa imong igsoon nga si Esau, ug nagpadulong na siya dinhi sa pagsugat kanimo. Adunay kauban siya nga 400 ka mga lalaki.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Gikulbaan pag-ayo si Jacob ug wala siya mahimutang, busa gibahin niya sa duha ka grupo ang iyang kauban nga mga tawo, apil ang iyang mga karnero, baka, kanding, ug kamelyo. ");
INSERT INTO cebocb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Naghuna-huna siya nga kon pananglit moabot si Esau ug sulongon ang usa ka grupo, makaikyas pa ang usa ka grupo. ");
INSERT INTO cebocb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Unya nag-ampo si Jacob, “Dios sa akong apohan nga si Abraham ug Dios sa akong amahan nga si Isaac, ikaw ang Ginoo nga nag-ingon kanako nga mobalik ako sa akong mga paryente, didto sa yuta diin ako natawo, ug panalanginan mo ako. ");
INSERT INTO cebocb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Dili ako takos nga modawat sa tanan nga kaayo ug pagkamatinumanon nga imo nang gipakita kanako nga imong alagad. Kay sa pagtabok ko kaniadto sa Jordan baston ra ang akong dala, apan karon adunay duha na ako ka grupo. ");
INSERT INTO cebocb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nanghangyo ako kanimo nga luwason mo ako gikan sa kamot sa akong igsoon nga si Esau. Nahadlok ako nga tingalig moanhi siya ug pamatyon kaming tanan, apil ang mga inahan ug ang ilang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Apan misaad ka kanako nga panalanginan mo ako ug padaghanon mo ang akong mga kaliwat sama sa balas sa baybayon nga dili maihap.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Gipalabay nila ni Jacob ang gabii didto sa maong dapit. Pagkabuntag, nagpili si Jacob ug mga hayop nga igasa kang Esau: ");
INSERT INTO cebocb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 ka bayeng kanding ug 20 ka laking kanding, 200 ka bayeng karnero ug 20 ka hamtong nga laking karnero, ");
INSERT INTO cebocb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 ka gatasan nga kamelyo uban sa ilang mga nati, 40 ka bayeng baka ug 10 ka torong baka, 20 ka bayeng asno ug 10 ka laking asno. ");
INSERT INTO cebocb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Unya gibahin-bahin ni Jacob ang mga hayop, ug ang matag panon adunay mga sulugoon nga nagbantay. Giingnan niya ang iyang mga sulugoon, “Pag-una kamo kanako. Sa inyong paglakaw, pagbutang kamog distansya gikan sa usa ka panon ngadto sa laing panon.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Giingnan niya ang mga sulugoon nga nagbantay sa unang panon, “Kon magtagbo kamo sa akong igsoon nga si Esau ug mangutana siya kon kang kinsa kamong sulugoon ug asa kamo paingon, ug kon kang kinsa kanang mga hayop nga inyong dala, ");
INSERT INTO cebocb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tubaga ang imong agalon nga si Esau nga akoa kining mga hayop ug gasa ko kini kaniya. Ingna usab ninyo siya nga nagsunod ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Mao usab ang iyang gisulti sa ikaduha, sa ikatulo, ug sa tanang mga sulugoon nga nagsunod sa mga panon sa mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ug gipahinumdoman niya sila nga dili kalimtan ang pag-ingon kang Esau nga anaa siya nagsunod. Kay matod ni Jacob sa iyang kaugalingon, “Pakalmahon ko si Esau pinaagi sa mga gasa nga akong ipadala pag-una. Basin pa ug inigkita namo pasayloon na niya ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Busa gipauna niya ang iyang mga gasa, apan nagpabilin siya niadtong gabhiona didto sa dapit nga ilang gipundohan. ");
INSERT INTO cebocb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Unya mibangon si Jacob niadtong gabhiona. Gidala niya ang iyang duha ka asawa, ang iyang duha ka sulugoon nga babaye ug ang iyang 11 ka anak, ug mitabok sila sa tabokanan sa Jabok. ");
INSERT INTO cebocb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pagkahuman, gitabok usab ni Jacob ang tanan niyang mga kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sa dihang nag-inusara na siya, adunay usa ka lalaki nga nakiglayog kaniya. Naglayog sila hangtod sa buntag. ");
INSERT INTO cebocb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sa dihang nakita sa tawo nga dili niya mapildi si Jacob, gilubag niya ang bat-ang ni Jacob ug nalisa kini. ");
INSERT INTO cebocb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Unya miingon ang tawo, “Buhii na ako kay buntag na.” Apan mitubag si Jacob, “Dili ka nako buhian kon dili mo ako panalanginan.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nangutana ang tawo kaniya, “Unsay imong ngalan?” Mitubag siya, “Si Jacob.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Unya miingon ang tawo, “Sukad karon dili na Jacob ang imong ngalan kondili Israel na tungod kay nakigbisog ka sa Dios ug sa tawo, ug midaog ka.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nangutana usab si Jacob kaniya, “Palihog, sultihi usab ako sa imong ngalan.” Apan mitubag ang tawo, “Nganong mangutana ka man sa akong ngalan?” Unya gipanalanginan niya si Jacob didto. ");
INSERT INTO cebocb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ginganlan ni Jacob kadtong dapita ug Peniel, kay miingon siya, “Nakita ko ang nawong sa Dios apan buhi pa gihapon ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Misidlak na ang adlaw sa pagbiya ni Jacob sa Penuel. Nagkiang-kiang siya tungod sa nalisa niya nga bat-ang. ");
INSERT INTO cebocb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Mao kini ang hinungdan kon nganong hangtod karon ang mga Israelinhon dili mokaon sa labit-labit nga anaa sa bat-ang sa hayop. Kay dinha nianang bahina sa lawas piangi sa Dios si Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Unya, pagtan-aw ni Jacob, nakita niya si Esau nga nagpadulong uban sa 400 ka mga lalaki. Busa gipauban niya ang iyang mga anak sa ilang tagsa-tagsa ka inahan. ");
INSERT INTO cebocb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ug paglakaw nila, gipauna niya ang duha ka sulugoon nga babaye ug ang ilang mga anak, sunod si Lea ug ang iyang mga anak, ug unya si Raquel ug ang iyang anak nga si Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Gauna si Jacob kanilang tanan ug pito ka higayon nga miyukbo siya samtang nagpaduol sa iyang igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Apan midagan si Esau sa pagtagbo kaniya. Gigakos siya ni Esau ug gihalokan, ug mihilak silang duha. ");
INSERT INTO cebocb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Sa dihang nakita ni Esau ang mga babaye ug ang mga kabataan gipangutana niya si Jacob, “Kinsa kanang mga kauban mo?” Mitubag si Jacob, “Sila ang mga anak nga gihatag sa Dios kanako tungod sa iyang kaayo.” ");
INSERT INTO cebocb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Unya mipaduol kang Esau ang duha ka sulugoon nga babaye ug ang ilang mga anak, ug miyukbo sila sa pagtahod kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Misunod usab si Lea ug ang iyang mga anak sa pagyukbo. Ug pagkahuman, mipaduol si Jose ug ang iyang inahan nga si Raquel ug miyukbo. ");
INSERT INTO cebocb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Nangutana si Esau kang Jacob, “Unsay imong buot ipasabot niadtong mga panon sa kahayopan nga akong natagboan?” Miingon si Jacob, “Gasa ko kadto kanimo aron dawaton mo ako, akong agalon.” ");
INSERT INTO cebocb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Apan mitubag si Esau, “Daghan na akog kabtangan, igsoon ko, busa tipigi na lang kadto alang sa imong kaugalingon.” ");
INSERT INTO cebocb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Apan namugos gayod si Jacob, “Palihog dawata na kadto. Kon tinuod nga gidawat mo na ako, dawata ang gasa ko kanimo. Kay sa pagkakita ko sa imong nawong daw sa nakita ko usab ang nawong sa Dios. Karon nga gidawat mo na ako, ");
INSERT INTO cebocb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","palihog, dawata ang gihatag ko kanimo tungod kay maayo ang Dios kanako ug gihatag niya kanako ang tanan kong mga kinahanglanon.” Nagsige gayod ug pamugos si Jacob kang Esau, busa gidawat na lang ni Esau ang iyang gasa. ");
INSERT INTO cebocb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Unya miingon si Esau, “Dali na, mag-uban na lang ta ug panglakaw.” ");
INSERT INTO cebocb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Apan mitubag si Jacob, “Nasayod ka, akong agalon, nga hinay molakaw ang mga bata, ug kinahanglan ko usab nga atimanon ang mga hayop nga nagpasuso. Kon pugson ta ang mga hayop sa paglakaw bisan usa na lang ka adlaw, tingalig mangamatay sila. ");
INSERT INTO cebocb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mas maayo tingali kon mouna ka na lang kanamo, akong agalon. Mohinay-hinay lang kami ug sunod kanimo sumala sa gikusgon sa linaktan sa mga bata ug sa mga hayop nga gauna kanamo. Magkita na lang kita didto sa Seir.” ");
INSERT INTO cebocb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Miingon si Esau, “Kon mao kana, ibilin ko na lang ang uban ko nga mga tawo kanimo.” Mitubag si Jacob, “Dili na kinahanglan. Ang mahinungdanon mao nga gidawat mo na ako, akong agalon.” ");
INSERT INTO cebocb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Busa milakaw si Esau balik sa Seir niadtong adlawa. ");
INSERT INTO cebocb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Apan sila si Jacob didto namaingon sa Sucot. Pag-abot nila didto, naghimo si Jacob ug puloy-anan ug gibuhatan usab niya ug silonganan ang iyang mga hayop. Busa kadto nga dapit gitawag nga Sucot. ");
INSERT INTO cebocb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Gikan sa ilang pagbiya sa Padan Aram, nakaabot ra gayod sila si Jacob sa lungsod sa Sekem nga sakop sa Canaan, nga walay daotang nahitabo kanila. Gipahimutang nila ang ilang mga tolda duol sa lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Unya gipalit ni Jacob gikan sa mga anak ni Hamor nga amahan ni Sekem ang bahin sa uma nga nahimutangan sa ilang mga tolda sa kantidad nga 100 pirasong pilak. ");
INSERT INTO cebocb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ug didto, nagbuhat si Jacob ug halaran nga ginganlan niya ug El Elohe Israel. ");
INSERT INTO cebocb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Usa niadto ka adlaw, milakaw si Dina, ang dalagang anak ni Jacob ug ni Lea aron makigkita sa mga dalaga nga taga-Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nakita siya ni Sekem nga anak ni Hamor nga Hibihanon, ang pangulo niadtong dapita. Gidagit ni Sekem si Dina ug gilugos. ");
INSERT INTO cebocb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nahulog ang iyang pagbati kang Dina ug nagustohan niya kini, busa gialam-alaman niya ang dalaga. ");
INSERT INTO cebocb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Unya, miingon si Sekem sa iyang amahan nga si Hamor, “Pangitai ug paagi nga maasawa ko kanang dalagaha.” ");
INSERT INTO cebocb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Pagkahibalo ni Jacob nga gipanamastamasan ni Sekem ang pagkababaye ni Dina, wala una siyay gihimo kay didto pa man sa uma ang iyang mga anak nga lalaki nga nagbantay sa iyang kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Miadto si Hamor ug ang iyang anak nga si Sekem kang Jacob aron makigsulti kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Pagkadungog sa mga anak nga lalaki ni Jacob sa nahitabo, mipauli dayon sila gikan sa uma. Misurok ang ilang dugo ug napungot sila pag-ayo kang Sekem tungod kay gihimo niini ang dili gayod angay himuon, nga naghatag ug kaulawan sa pamilya ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Apan miingon si Hamor kanila, “Nakagusto gayod ang akong anak nga si Sekem sa inyong dalaga, busa palihog, ipaasawa na lang ninyo siya kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ug maayo usab tingali nga ipaasawa ninyo ang inyong mga dalaga sa among mga ulitawo ug ipaasawa usab namo ang among mga dalaga sa inyong mga ulitawo. ");
INSERT INTO cebocb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mahimo kamong mopuyo uban kanamo bisan asa ninyo gusto. Mahimo usab kamong magnegosyo dinhi ug manag-iya ug yuta.” ");
INSERT INTO cebocb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Unya miingon si Sekem sa amahan ug sa mga igsoon ni Dina, “Kon mahimo ipaasawa na lang ninyo si Dina kanako. Ihatag ko kaninyo bisan unsay inyong pangayoon. ");
INSERT INTO cebocb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kamoy akong pabut-on kon pilay inyong pangayoon ug kon unsay akong igasa. Bayran ko kamo bisag pila basta ipaasawa lang ninyo kanako si Dina.” ");
INSERT INTO cebocb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Apan tungod kay gipanamastamasan ni Sekem ang pagkababaye ni Dina, gilimbongan sa mga anak ni Jacob si Sekem ug ang iyang amahan nga si Hamor. ");
INSERT INTO cebocb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Miingon sila, “Dili mahimo nga ipaasawa namo si Dina sa tawo nga wala matuli, kay makauulaw kana alang kanamo. ");
INSERT INTO cebocb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mosugot lang kami kon ang tanang mga lalaki nga taga-dinhi magpatuli sama kanamo. ");
INSERT INTO cebocb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kon magpatuli kamo, mahimo namong ipaasawa ang among mga dalaga kaninyo ug kami usab mangasawa sa inyong mga dalaga. Mopuyo kami uban kaninyo ug mahimo kitang usa ka katawhan. ");
INSERT INTO cebocb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Apan kon dili kamo mosugot nga magpatuli, kuhaon namo si Dina ug mobiya kami.” ");
INSERT INTO cebocb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nakita ni Hamor ug ni Sekem nga daw maayo ang kondisyon nga gihatag sa mga anak ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Busa tungod kay nakagusto gayod si Sekem kang Dina, wala na siya mag-usik pa ug panahon sa pagtuman sa giingon sa mga anak ni Jacob. Si Sekem tinahod gayod sa panimalay sa iyang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Busa miadto dayon si Hamor ug si Sekem nga iyang anak sa ganghaan sa lungsod ug nakigsulti sa mga lalaki sa ilang lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Miingon sila, “Mahigalaon kini nga mga tawo, busa tugotan lang nato sila nga mopuyo dinhi ug magnegosyo bisan asa. Total, dako man kining atong dapit. Makapangasawa kita sa ilang mga dalaga ug sila makapangasawa usab sa atong mga dalaga. ");
INSERT INTO cebocb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Apan mosugot lang sila nga mopuyo uban kanato ingon nga usa ka katawhan kon mosugot usab ang tanan nato nga mga kalalakin-an nga magpatuli sama kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kon mosugot kita nga dinhi na sila mopuyo, di ba maato na usab ang tanan nilang mga kahayopan ug mga kabtangan? Busa mouyon na lang kita sa ilang kondisyon aron mopuyo sila uban kanato.” ");
INSERT INTO cebocb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Misugot ang tanang mga lalaki sa lungsod sa gisulti ni Hamor ug sa iyang anak nga si Sekem. Busa nagpatuli ang tanang mga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Paglabay sa tulo ka adlaw, samtang nag-antos pa sa kasakit ang mga lalaki, misulod sa lungsod ang duha ka anak ni Jacob nga si Simeon ug si Levi, nga mga igsoon ni Dina. Wala makabantay ang mga tawo didto nga daotan diay ang ilang tuyo. Aduna silay dalang espada ug gipamatay nila ang tanang mga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Gipatay usab nila si Hamor ug ang iyang anak nga si Sekem. Unya gikuha nila si Dina sa balay ni Sekem ug milakaw. ");
INSERT INTO cebocb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Pagkahuman, gisulod usab sa uban pa nga mga anak ni Jacob ang lungsod ug gipanguha ang mga kabtangan. Gibuhat nila kini tungod kay gipanamastamasan ang pagkababaye sa ilang igsoon nga si Dina. ");
INSERT INTO cebocb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Gipanguha nila ang mga karnero, mga baka, mga asno, ug ang tanang atua sa lungsod ug sa uma. ");
INSERT INTO cebocb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Gipanguha nila ang tanang bahandi sa lungsod, apil na ang mga kabtangan sa sulod sa kabalayan. Ug gibihag nila ang tanang mga babaye ug mga kabataan. ");
INSERT INTO cebocb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Unya, miingon si Jacob kang Simeon ug kang Levi, “Gihatagan ninyo ako ug dakong problema. Dumtan na kita karon sa mga Canaanhon ug mga Perisihanon niining dapita. Gamay ra kita kaayo. Mamatay gayod kitang tanan kon maghiusa sila sa pagsulong kanato.” ");
INSERT INTO cebocb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Apan mitubag ang duha, “Pasagdan lang ba namo nga trataron ang among igsoon nga murag usa ka babayeng nagbaligya sa iyang dungog?” ");
INSERT INTO cebocb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Unya, miingon ang Dios kang Jacob, “Pangandam, lakaw sa Betel ug puyo didto. Unya pagbuhat didto ug halaran alang kanako, ang Dios nga nagpakita kanimo sa dihang miikyas ka kaniadto gikan sa imong igsoon nga si Esau.” ");
INSERT INTO cebocb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Busa miingon si Jacob sa iyang panimalay ug sa tanan niyang mga kauban, “Ipanglabay ninyo ang inyong mga dios. Panghinlo kamo sa inyong kaugalingon ug pag-ilis kamo sa inyong bisti. ");
INSERT INTO cebocb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Motungas kita ngadto sa Betel, ug magbuhat ako didto ug halaran ngadto sa Dios nga mitabang kanako sa diha pa ako sa kalisod, ug nag-uban kanako bisan asa ako paingon.” ");
INSERT INTO cebocb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Busa gihatag nila kang Jacob ang ilang mga dios ug ang mga ariyos nga diha sa ilang mga dalunggan. Gilubong kining tanan ni Jacob ilalom sa kahoyng terebinto duol sa Sekem. ");
INSERT INTO cebocb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sa paggikan nila ni Jacob, giabot ug kahadlok sa Dios ang mga tawo sa palibot nga mga lungsod, busa wala nila gukda sila si Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nakaabot si Jacob ug ang iyang mga kauban sa Luz (nga gitawag usab ug Betel) nga sakop sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nagbuhat siya didto ug halaran. Ginganlan niya kadto nga dapit ug El Betel kay nagpakita ang Dios kaniya didto sa dihang miikyas siya sa iyang igsoon nga si Esau. ");
INSERT INTO cebocb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Unya, namatay si Debora nga tig-atiman ni Rebeka. Busa gilubong siya ilalom sa kahoyng terebinto didto ubos sa Betel. Gitawag ni Jacob kadto nga kahoy ug Alon Bacut. ");
INSERT INTO cebocb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Sa dihang mipauli si Jacob gikan sa Padan Aram, nagpakita pag-usab ang Dios kaniya ug gipanalanginan siya. ");
INSERT INTO cebocb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Miingon ang Dios kaniya, “Jacob ang imong ngalan, apan gikan karon dili ka na tawgon ug Jacob kondili Israel na.” Busa nahimong Israel ang ngalan ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Miingon pa gayod ang Dios kaniya, “Ako ang Dios nga Makagagahom. Manganak kag daghan. Maggikan kanimo ang usa ka nasod ug ang daghan pa nga mga nasod, ug mahimong hari ang uban mong mga kaliwat. ");
INSERT INTO cebocb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ang yuta nga gihatag ko kang Abraham ug kang Isaac ihatag ko usab kanimo ug sa imong mga kaliwat.” ");
INSERT INTO cebocb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Unya mibiya ang Dios niadtong dapita diin nakigsulti siya kang Jacob. Nagpatindog si Jacob didto ug bato nga handomanan, ug gibuboan niya kinig bino ug lana aron idedikar sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ginganlan niya kadto nga dapit ug Betel. ");
INSERT INTO cebocb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Unya, mibiya si Jacob ug ang iyang panimalay sa Betel. Layo-layo pa sila sa lungsod sa Efrata sa dihang nagbati na si Raquel. ");
INSERT INTO cebocb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Naglisod siya sa iyang pagpanganak, ug sa dihang nakaanak na siya, miingon ang mananabang kaniya, “Ayaw kahadlok Raquel, lalaki na usab ang imong anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Natawo ang bata apan himalatyon na si Raquel, ug una siya mabugtoi sa gininhawa, ginganlan niya ang bata ug Ben Oni. Apan ginganlan ni Jacob ang bata ug Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Namatay si Raquel ug gilubong siya sa daplin sa dalan nga paingon sa Efrata (nga gitawag karon ug Betlehem). ");
INSERT INTO cebocb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Gibutangan ni Jacob ug bato nga ilhanan ang lubnganan ni Raquel, ug anaa pa kini hangtod karon. ");
INSERT INTO cebocb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nagpadayon sila Jacob sa ilang pagpanglakaw, ug nagpatindog sila sa ilang mga tolda unahan sa tore sa Migdal Eder. ");
INSERT INTO cebocb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Samtang didto pa nagpuyo si Jacob, nakigdulog si Ruben kang Bilha nga usa sa mga asawa sa iyang amahan. Sa dihang nahibaloan kadto ni Jacob nasuko siya pag-ayo. ");
INSERT INTO cebocb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ang iyang mga anak kang Lea mao sila si Ruben, ang kamagulangan, unya si Simeon, si Levi, si Juda, si Isacar, ug si Zabulon. ");
INSERT INTO cebocb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ang iyang mga anak kang Raquel mao si Jose ug si Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ang iyang mga anak kang Bilha nga sulugoon ni Raquel mao si Dan ug si Neftali. ");
INSERT INTO cebocb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ang iyang mga anak kang Zilpa nga sulugoon ni Lea mao si Gad ug si Aser. ");
INSERT INTO cebocb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Miadto si Jacob sa iyang amahan nga si Isaac didto sa Mamre, haduol sa Kiriat Arba (nga gitawag usab ug Hebron). Kining dapita mao ang gipuy-an ni Isaac ug ni Abraham kaniadto. ");
INSERT INTO cebocb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nagkinabuhi si Isaac ug 180 ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Namatay siya nga tigulang na kaayo, ug giipon siya sa iyang mga paryente nga nangamatay na. Gilubong siya sa iyang mga anak nga si Esau ug si Jacob. ");
INSERT INTO cebocb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Mao kini ang sugilanon bahin sa pamilya ni Esau (nga gitawag usab ug Edom). ");
INSERT INTO cebocb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Naminyo si Esau sa mga babaye nga taga-Canaan. Sila mao si Ada nga anak ni Elon nga Hitihanon, si Oholibama nga anak ni Ana ug apo ni Zibeon nga Hibihanon, ");
INSERT INTO cebocb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ug si Basemat nga anak ni Ishmael ug igsoon ni Nebayot. ");
INSERT INTO cebocb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ang anak ni Esau kang Ada mao si Elifaz. Ang iyang anak kang Basemat mao si Reuel. ");
INSERT INTO cebocb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ug ang iyang mga anak kang Oholibama mao sila si Jeush, Jalam, ug Kora. Sila ang mga anak ni Esau nga natawo sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Gidala ni Esau ang iyang mga asawa, mga anak, ug ang tanang sakop sa iyang panimalay, apil ang mga kabtangan ug kahayopan nga natigom niya sa Canaan, ug mibalhin siya sa usa ka dapit, layo kang Jacob nga iyang igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kay dili sila mahimong mag-uban sa usa ka dapit tungod sa kadaghan sa ilang kabtangan; ug ang mga sabsabanan sa dapit nga ilang gipuy-an dili paigo sa daghan nila nga mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Busa didto nagpuyo si Esau (nga gitawag usab ug Edom) sa kabungtoran sa Seir. ");
INSERT INTO cebocb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Mao kini ang sugilanon mahitungod sa pamilya ni Esau nga amahan sa mga Edomihanon nga nagpuyo sa kabungtoran sa Seir. ");
INSERT INTO cebocb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ang anak ni Esau kang Basemat mao si Reuel, ug ang anak niya kang Ada mao si Elifaz. ");
INSERT INTO cebocb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ang mga anak ni Elifaz mao sila si Teman, Omar, Zefo, Gatam, ug Kenaz. ");
INSERT INTO cebocb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Anak usab niya si Amalek sa usa pa niya ka asawa nga si Timna. Sila ang mga apo ni Esau sa iyang asawa nga si Ada. ");
INSERT INTO cebocb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ang mga anak ni Reuel mao sila si Nahat, Zera, Shama, ug Miza. Sila ang mga apo ni Esau sa iyang asawa nga si Basemat. ");
INSERT INTO cebocb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ang mga anak ni Esau kang Oholibama mao sila si Jeush, Jalam, ug Kora. (Si Oholibama anak ni Ana ug apo ni Zibeon.) ");
INSERT INTO cebocb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mao kini ang mga kaliwat ni Esau nga nahimong mga pangulo: Si Teman, Omar, Zefo, Kenaz, ");
INSERT INTO cebocb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, ug Amalek. Mga anak kini sila ni Elifaz ug mga apo ni Esau sa iyang asawa nga si Ada. Nangulo sila sa Edom. ");
INSERT INTO cebocb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nahimo usab nga mga pangulo sa Edom ang mga anak ni Reuel nga sila si Nahat, Zera, Shama, ug Miza. Sila ang mga apo ni Esau sa iyang asawa nga si Basemat. ");
INSERT INTO cebocb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nahimo usab nga mga pangulo ang mga anak ni Esau kang Oholibama nga anak ni Ana. Sila mao si Jeush, Jalam, ug Kora. ");
INSERT INTO cebocb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Silang tanan ang mga kaliwat ni Esau nga mga pangulo sa Edom. ");
INSERT INTO cebocb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Mao kini ang mga anak ni Seir nga Horihanon nga nagpuyo sa Edom: si Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO cebocb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, ug Dishan. Nahimo silang pangulo sa mga Horihanon nga kaliwat ni Seir, nga nagpuyo sa Edom. ");
INSERT INTO cebocb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ang mga anak ni Lotan mao sila si Hori ug si Hemam. Managsoon si Lotan ug si Timna nga usa sa asawa ni Elifaz. ");
INSERT INTO cebocb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ang mga anak ni Shobal mao sila si Alvan, Manahat, Ebal, Shefo, ug Onam. ");
INSERT INTO cebocb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ang mga anak ni Zibeon mao sila si Aya ug si Ana. (Si Ana mao ang nakakaplag sa tuboran didto sa kamingawan sa dihang nagbantay siya sa mga asno sa iyang amahan nga si Zibeon.) ");
INSERT INTO cebocb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ang mga anak ni Ana mao si Dishon ug si Oholibama. ");
INSERT INTO cebocb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ang mga anak ni Dishon mao sila si Hemdan, Eshban, Itran, ug Keran. ");
INSERT INTO cebocb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ang mga anak ni Ezer mao sila si Bilhan, Zaavan, ug Acan. ");
INSERT INTO cebocb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ang mga anak ni Dishan mao si Uz ug si Aran. ");
INSERT INTO cebocb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Mao kini sila ang mga pangulo sa mga Horihanon nga midumala sa mga dapit sa Seir: si Lotan, Shobal, Zibeon, Ana, Dishon, Ezer, ug Dishan. ");
INSERT INTO cebocb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mao kini sila ang mga hari sa Edom sa panahon nga wala pay mga hari ang mga Israelinhon: ");
INSERT INTO cebocb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Si Bela nga anak ni Beor nahimong hari sa Edom. Dinhaba ang ngalan sa iyang ulohang lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pagkamatay niya, gipulihan siya ni Jobab nga anak ni Zera nga taga-Bozra. ");
INSERT INTO cebocb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pagkamatay ni Jobab, gipulihan siya ni Husham nga taga-Teman. ");
INSERT INTO cebocb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pagkamatay ni Husham, gipulihan siya ni Hadad nga anak ni Bedad. Si Hadad maoy mipildi sa mga Midianhon didto sa Moab. Avit ang ngalan sa iyang ulohang lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pagkamatay ni Hadad, gipulihan siya ni Samla nga taga-Masreka. ");
INSERT INTO cebocb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pagkamatay ni Samla, gipulihan siya ni Saulo nga taga-Rehobot nga duol sa Suba. ");
INSERT INTO cebocb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Pagkamatay ni Saulo, gipulihan siya ni Baal Hanan nga anak ni Acbor. ");
INSERT INTO cebocb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pagkamatay ni Baal Hanan, gipulihan siya ni Hadar. Pau ang ngalan sa iyang ulohang lungsod. Ang iyang asawa mao si Mehetabel nga anak ni Matred ug apo ni Mezahab. ");
INSERT INTO cebocb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Si Esau (o Edom) mao ang katigulangan sa mga Edomihanon. Mao kini sila ang nahimong pangulo sa mga kaliwat ni Esau nga ang ilang mga tribo ug dapit ginganlan usab sa ilang mga ngalan: Timna, Alva, Jetet, Oholibama, Elah, Pinon, Kenaz, Teman, Mibzar, Magdiel, ug Iram. ");
INSERT INTO cebocb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nagpabilin pagpuyo si Jacob sa Canaan, ang dapit nga gipuy-an usab kaniadto sa iyang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mao kini ang sugilanon bahin sa pamilya ni Jacob. Sa dihang nag-edad na si Jose ug 17 ka tuig, nagbantay siya sa mga kahayopan uban sa iyang mga igsoon nga anak sa mga asawa sa iyang amahan nga sila si Bilha ug si Zilpa. Gisugilon ni Jose sa iyang amahan ang daotang mga buhat sa iyang mga igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Mas gipangga ni Jacob si Jose kaysa uban niyang mga anak, tungod kay tigulang na siya sa dihang natawo kini. Busa gihimoan niya si Jose ug nindot ug taas nga bisti. ");
INSERT INTO cebocb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Apan nakita sa mga igsoon ni Jose nga mas gipangga siya sa ilang amahan kay kanila. Nasuko sila kang Jose ug kanunay nila siyang gisultihan ug sakit nga mga pulong. ");
INSERT INTO cebocb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Unya, nagdamgo si Jose. Ug sa dihang gisugilon niya kini sa iyang mga igsoon, misamot ang ilang kasuko kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Mao kini ang iyang gisugilon, “Nagdamgo ako ");
INSERT INTO cebocb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","nga samtang didto kita sa uma ug namugkos sa mga uhay, kalit lang nga mitindog ang akong binugkos ug gialirongan kini ug giyukboan sa inyong mga binugkos.” ");
INSERT INTO cebocb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Miingon ang iyang mga igsoon, “Unsa? Maghari ka ba kanamo? Dumalahan mo gayod kami?” Ug misamot ang ilang kasuko kang Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nagdamgo pag-usab si Jose ug gisugilon na usab niya kini sa iyang mga igsoon. Miingon siya, “Nagdamgo na usab ako nga nakita ko ang adlaw, ang bulan, ug ang 11 ka bitoon nga miyukbo kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Gisugilon usab ni Jose ang iyang damgo sa iyang amahan apan gibadlong siya niini. Matod sa iyang amahan, “Unsay buot mong ipasabot? Nga kami sa imong inahan ug mga igsoon moyukbo kanimo?” ");
INSERT INTO cebocb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nasina ang mga igsoon ni Jose kaniya, apan gihinuktokan sa iyang amahan kining mga butanga. ");
INSERT INTO cebocb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Usa niadto ka adlaw, miadto ang mga igsoon ni Jose sa Sekem aron pagbantay sa mga kahayopan sa ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Unya, miingon si Jacob kang Jose, “Atua ang imong mga igsoon sa Sekem. Nagpasabsab sila sa mga kahayopan didto. Lakaw ug susiha kon unsa ang kahimtang sa imong mga igsoon ug sa mga hayop. Balik dayon ug sultihi ako.” Mitubag si Jose, “Oo, Tay.” Busa gikan sa Walog sa Hebron, miadto si Jose sa Sekem. ");
INSERT INTO cebocb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sa didto na siya nga naglibot-libot sa hawanan, adunay tawo nga nangutana kaniya kon unsa ang iyang gipangita. ");
INSERT INTO cebocb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Mitubag siya, “Nangita ako sa akong mga igsoon. Nasayod ka ba kon asa sila nagpasabsab?” ");
INSERT INTO cebocb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Miingon ang tawo, “Wala na sila dinhi. Nadunggan ko nga miingon sila nga moadto sila sa Dotan.” Busa miapas si Jose ug nakita niya sila didto. ");
INSERT INTO cebocb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Layo pa si Jose nakita na siya sa iyang mga igsoon. Ug sa wala pa siya makaabot, nagplano na sila sa pagpatay kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Miingon sila sa usag-usa, “Ania na ang paladamgo. ");
INSERT INTO cebocb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Dali, patyon nato siya ug unya ihulog sa usa sa mga bangag nga pundohanan ug tubig. Ingnon lang nato nga gipatay siya sa bangis nga mananap. Tan-awon ta kon matuman pa ba ang iyang mga damgo.” ");
INSERT INTO cebocb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Apan pagkadungog ni Ruben sa ilang plano, naningkamot siya nga maluwas si Jose. Miingon siya, “Dili lang nato siya patyon. ");
INSERT INTO cebocb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ihulog lang ninyo siya sa bangag nga pundohanan ug tubig dinhi sa kamingawan, apan ayaw ninyo siya pasipad-i.” Gisulti kadto ni Ruben tungod kay nagplano siya nga luwason si Jose ug ibalik ngadto sa ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Busa pag-abot ni Jose, gihuboan nila siya niadtong iyang bisti nga taas ug nindot, ");
INSERT INTO cebocb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ug gihulog sa bangag nga pundohanan ug tubig. Apan walay tubig ang mao nga bangag. ");
INSERT INTO cebocb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Samtang nangaon sila, aduna silay nalantawan nga mga negosyanteng Ishmaelinhon nga gikan sa Gilead. Ang mga kamelyo niini adunay kargang mga lamas, tambal, ug pahumot nga dad-on ngadto sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Miingon si Juda sa iyang mga igsoon, “Unsa may atong makuha kon patyon nato ang atong igsoon ug itago ang iyang kamatayon? ");
INSERT INTO cebocb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Maayo pa tingali kon ibaligya na lang nato siya nianang mga Ishmaelinhon. Dili na lang nato siya patyon kay igsoon nato siya.” Miuyon kang Juda ang iyang mga igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Busa sa dihang miagi ang mga negosyanteng Ishmaelinhon, nga ang ilang tribo Midianhon, gikuha nila si Jose gikan sa bangag nga pundohanan ug tubig ug gibaligya sa kantidad nga 20 kabuok nga salapi. Ug gidala si Jose sa mga Ishmaelinhon didto sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Sa pagbalik ni Ruben didto sa bangag wala na didto si Jose, busa gigisi niya ang iyang bisti sa tumang kaguol. ");
INSERT INTO cebocb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Unya mibalik siya sa iyang mga igsoon ug miingon, “Wala na didto ang atong manghod. Unsay akong buhaton?” ");
INSERT INTO cebocb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nagpatay sila ug kanding ug gituslob nila sa dugo ang bisti ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pagkahuman, gidala nila ang bisti ni Jose ngadto sa ilang amahan ug miingon, “Nakita namo kini. Tan-awa kuno palihog kon kang Jose ba kini o dili.” ");
INSERT INTO cebocb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nailhan dayon ni Jacob ang maong bisti. Miingon siya, “Iya kana! Gikaon siyag bangis nga mananap! Sigurado gayod nga gikunis-kunis siya niini.” ");
INSERT INTO cebocb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Unya gigisi ni Jacob ang iyang bisti ug nagsul-ob siya ug sako sa pagpakita sa iyang pagsubo. Dugay-dugay siyang nagbangotan sa pagkamatay sa iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Miadto ang tanan niyang mga anak sa paghupay kaniya apan nagpadayon siya sa pagbangotan. Miingon siya, “Pasagdi lang ninyo ako! Mamatay ako nga nagbangotan tungod sa pagkamatay sa akong anak.” Ug mihilak siya tungod kang Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Unya didto sa Ehipto, gibaligya sa mga Midianhon si Jose kang Potifar nga usa sa mga opisyal sa hari sa Ehipto. Kapitan siya sa mga tigbalantay sa palasyo. ");
INSERT INTO cebocb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Niadto usab nga panahon, mibulag si Juda sa iyang mga igsoon ug didto siya mipuyo uban kang Hira nga taga-Adulam. ");
INSERT INTO cebocb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nakita ni Juda didto ang anak ni Shua nga Canaanhon ug gipangasawa niya kini. ");
INSERT INTO cebocb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Namabdos ang asawa ni Juda, ug nanganak kini ug lalaki nga ginganlan ni Juda ug Er. ");
INSERT INTO cebocb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Namabdos siya pag-usab ug nanganak ug lalaki ug ginganlan niya kini ug Onan. ");
INSERT INTO cebocb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Namabdos siya sa ikatulong higayon ug lalaki gihapon ang iyang anak ug ginganlan niya kini ug Shela. Natawo si Shela didto sa Kezib. ");
INSERT INTO cebocb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Gipaasawa ni Juda kang Er, nga iyang kamagulangang anak, ang usa ka babaye nga ginganlan ug Tamar. ");
INSERT INTO cebocb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Apan si Er daotan atubangan sa Ginoo, busa gipatay siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Unya miingon si Juda kang Onan, “Pangasaw-a ang imong bayaw kay katungdanan mo kana isip igsoon sa iyang bana nga namatay, aron pinaagi kanimo makabaton usab ug mga anak ang imong igsoon.” ");
INSERT INTO cebocb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Apan nasayod si Onan nga dili isipon nga iya ang mahimong anak nila ni Tamar, busa sa matag higayon nga magdulog sila ni Tamar, dili niya ipasulod ang iyang semilya aron dili siya makaanak alang sa iyang igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Daotan ang gibuhat ni Onan atubangan sa Ginoo, busa gipatay usab siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Unya miingon si Juda kang Tamar nga iyang umagad, “Pauli una sa imong amahan, ug ayaw pamana hangtod nga maulitawo na si Shela.” Giingon kadto ni Juda kay nahadlok siya nga mamatay usab si Shela sama sa iyang mga igsoon. Busa mipauli si Tamar sa iyang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Miabot ang panahon, namatay ang anak ni Shua nga asawa ni Juda. Pagkahuman sa iyang pagbangotan, miadto siya sa mga tigtupi sa iyang mga karnero didto sa Timnah. Kauban niya sa pag-adto ang iyang amigo nga si Hira nga taga-Adulam. ");
INSERT INTO cebocb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Adunay misulti kang Tamar nga miadto sa Timnah ang iyang ugangan aron pagpanupi sa iyang mga karnero. ");
INSERT INTO cebocb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Pagkadungog niadto ni Tamar, giilisan niya ang iyang gisul-ob nga bisti nga alang sa balo, ug gitabonan niya ug belo ang iyang nawong. Unya milingkod siya dapit sa pultahan sa lungsod sa Enaim, sa daplin sa dalan nga paingon sa Timnah. (Gihimo niya kini tungod kay nakita niya nga ulitawo na si Shela apan wala gihapon siya ipaasawa kaniya.) ");
INSERT INTO cebocb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Sa pagkakita ni Juda kang Tamar sa daplin sa dalan, gipakaingon niya ug usa kini ka babayeng nagbaligya sa iyang dungog, kay aduna may tabon ang nawong niini. Busa miduol siya kang Tamar (nga wala niya mailhi nga iya diayng umagad) ug miingon, “Dali, magdulog kita.” Mitubag si Tamar, “Unsa may imong ibayad kanako sa pagpakigdulog ko kanimo?” ");
INSERT INTO cebocb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Miingon si Juda, “Hatagan ka nako ug kanding gikan sa akong kahayopan.” Mitubag si Tamar, “Mosugot ako kon aduna kay ihatag kanako nga garantiya hangtod nga ikapadala mo na ang kanding.” ");
INSERT INTO cebocb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Nangutana si Juda, “Unsay gusto nimo nga akong igarantiya?” Mitubag si Tamar, “Ihatag kanako ang imong silyo apil ang higot niini, ug ang imong baston.” Busa gihatag kadto ni Juda ug nakigdulog siya kang Tamar. Human niadto mipauli si Tamar. Gikuha niya ang tabon sa iyang nawong ug gisul-ob pag-usab ang bisti nga alang sa balo. Wala madugay namabdos siya. ");
INSERT INTO cebocb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Gipahatod ni Juda sa iyang amigo, nga si Hira nga taga-Adulam, ang kanding aron makuha gikan sa babaye ang mga butang nga iyang gihatag ingon nga garantiya, apan wala kini makita ni Hira. ");
INSERT INTO cebocb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nangutana si Hira sa mga taga-Enaim kon hain na ang babayeng nagbaligya sa iyang dungog, nga didto maglingkod sa daplin sa dalan. Apan mitubag ang mga tawo, “Wala may babaye dinhi nga nagbaligya sa iyang dungog.” ");
INSERT INTO cebocb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Busa mibalik si Hira kang Juda ug miingon, “Wala ko siya makita. Ug matod pa sa mga tawo wala man kunoy babaye didto nga nagbaligya sa iyang dungog.” ");
INSERT INTO cebocb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Miingon si Juda, “Pasagdi na! Iya na lang kadtong mga butang nga atua kaniya, kay basin ug mahimo kitang kataw-anan kon sige pa tag pangita sa wala. Gipahatdan ko na bitaw siya niining kanding, apan wala mo man kaha siya makita didto!” ");
INSERT INTO cebocb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Paglabay sa tulo ka bulan, gisultihan si Juda nga ang iyang umagad nga si Tamar nagbaligya sa iyang dungog ug mabdos na gani. Busa miingon si Juda, “Dad-a ninyo siya sa gawas sa lungsod aron sunogon.” ");
INSERT INTO cebocb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Apan sa dihang gidala na si Tamar, aduna siyay gisugo aron pagsulti kang Juda niini, “Ania ang pangtimbre, apil ang higot niini, ug ang baston. Ang tag-iya niini mao ang amahan sa akong gimabdos. Palihog, susiha kon kang kinsa kini.” ");
INSERT INTO cebocb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nailhan ni Juda nga iya kadtong mga butang busa miingon siya, “Wala siyay sala. Ako ang nakasala kay wala ko siya ipaasawa sa akong anak nga si Shela.” Ug wala na mousab ug pakigdulog si Juda kang Tamar. ");
INSERT INTO cebocb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sa dihang hapit na manganak si Tamar, nadiskobrehan niya nga kaluha ang iyang gimabdos. ");
INSERT INTO cebocb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Sa dihang nagbati na siya, migawas ang kamot sa usa ka bata. Gihiktan kini sa mananabang ug higot nga pula aron mahibaloan nga siya ang una nga natawo. ");
INSERT INTO cebocb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Apan gisulod pagbalik sa bata ang iyang kamot ug ang iyang kaluha mao ang una nga migawas. Miingon ang mananabang, “Nagdali ka gayod sa paggawas.” Busa ginganlan ang bata ug Perez. ");
INSERT INTO cebocb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Unya migawas usab ang iyang kaluha nga adunay higot nga pula sa iyang kamot. Ginganlan siya ug Zera. ");
INSERT INTO cebocb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Gidala sa mga Ishmaelinhon si Jose ngadto sa Ehipto, ug gipalit siya ni Potifar nga usa sa mga opisyal sa hari sa Ehipto. (Si Potifar kapitan sa mga tigbalantay sa palasyo.) ");
INSERT INTO cebocb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Giubanan gayod sa Ginoo si Jose, busa nagmauswagon siya. Didto siya mipuyo sa balay sa iyang agalon nga Ehiptohanon nga si Potifar. ");
INSERT INTO cebocb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nakita ni Potifar nga nag-uban gayod ang Ginoo kang Jose ug gipalampos sa tanan niyang gihimo, ");
INSERT INTO cebocb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","busa gikahimut-an ni Potifar si Jose. Gihimo niya kini nga iyang personal nga katabang ug tigdumala sa iyang panimalay ug sa tanan niyang kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sukad niadto, gipanalanginan sa Ginoo ang panimalay sa Ehiptohanon nga si Potifar ug ang tanan niyang kabtangan sulod sa balay ug didto sa iyang uma. Gihimo kini sa Ginoo tungod kang Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Gitugyan ni Potifar ang tanan kang Jose ug wala na siyay gikabalak-an pa gawas sa paghuna-huna kon unsay iyang kaonon. Guwapo si Jose ug maayog barog. ");
INSERT INTO cebocb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Unya, naibog kaniya ang asawa sa iyang agalon. Gihagad niya si Jose nga makigdulog kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Apan mibalibad si Jose. Miingon siya sa asawa sa iyang agalon, “Gitugyan kanako sa akong agalon ang tanan niyang kabtangan ug wala na siyay gikabalak-an dinhi sa iyang panimalay. ");
INSERT INTO cebocb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Gihatagan niya ako sa labawng katungod dinhi niini nga panimalay, ug gitugyan niya kanako ang tanan gawas lang kanimo tungod kay ikaw iyang asawa. Busa dili ko mahimong budhian ang akong agalon ug magpakasala sa Dios.” ");
INSERT INTO cebocb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bisan ug adlaw-adlaw gidani sa babaye si Jose aron nga makigdulog kaniya, wala gayod kini mosugot. ");
INSERT INTO cebocb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Usa ka adlaw, misulod si Jose sa balay aron motrabaho, ug naatol nga wala gayoy bisan usa ka sulugoon didto sa sulod sa balay. ");
INSERT INTO cebocb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kalit nga gihawiran ang iyang bisti sa asawa sa iyang agalon ug miingon kini kaniya, “Pakigdulog kanako.” Apan midagan si Jose ngadto sa gawas sa balay, ug nahibilin ang iyang kupo nga nabira sa babaye. ");
INSERT INTO cebocb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sa pagkakita sa babaye nga midagan sa gawas si Jose ug nahibilin diha kaniya ang kupo niini, ");
INSERT INTO cebocb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","gitawag niya ang iyang mga sulugoon ug miingon, “Tan-awa ninyo kini! Gidad-an kita dinhi sa akong bana ug Hebreo aron pakaulawan kita. Misulod siya sa akong kuwarto aron paglugos kanako, apan misinggit ako. ");
INSERT INTO cebocb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Busa midagan siya pagawas, ug nabiyaan niya ang iyang bisti.” ");
INSERT INTO cebocb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Gitipigan sa babaye ang bisti ni Jose hangtod sa pagpauli sa iyang bana. ");
INSERT INTO cebocb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Unya gisugilon niya sa iyang bana ang nahitabo. Miingon siya, “Ang Hebreo nga sulugoon nga gidala mo dinhi, buot akong pakaulawan. Misulod siya sa akong kuwarto aron lugoson ako. ");
INSERT INTO cebocb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Apan sa dihang misinggit ako midagan siya ngadto sa gawas, ug nabiyaan niya ang iyang kupo.” ");
INSERT INTO cebocb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sa pagkadungog ni Potifar sa gisulti sa iyang asawa mahitungod sa gibuhat ni Jose, nasuko siya pag-ayo. ");
INSERT INTO cebocb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Busa gidala niya si Jose ug gisulod sa prisohan nga alang sa mga piniriso sa hari. Apan bisan didto sa prisohan, ");
INSERT INTO cebocb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","nag-uban gihapon ang Ginoo kang Jose. Ug tungod sa kaayo sa Ginoo, gikahimut-an sa tigdumala sa prisohan si Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Gitugyan niya kang Jose ang pagdumala sa tanang mga piniriso ug ang tanang mga buluhaton didto. ");
INSERT INTO cebocb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wala na maghuna-huna pa ang tigdumala sa prisohan bahin sa mga butang nga gitugyan niya kang Jose, tungod kay uban ang Ginoo kang Jose ug gihatagan siya sa Ginoo ug kalamposan sa tanan niyang gihimo. ");
INSERT INTO cebocb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Nahitabo usab nga ang pangulo sa mga tigsilbi ug bino ngadto sa hari sa Ehipto ug ang pangulo sa iyang mga panadero nakasala batok kaniya. Nasuko pag-ayo ang hari niining duha niya ka opisyal. ");
INSERT INTO cebocb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Busa gipapriso niya sa bilanggoan diin napriso si Jose, sa lugar nga binantayan sa kapitan sa mga tigbalantay. ");
INSERT INTO cebocb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Si Jose ang gisaligan sa kapitan sa mga tigbalantay nga moatiman kanila, ug dugay-dugay silang napriso didto. ");
INSERT INTO cebocb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Usa niana ka gabii, nagdamgo ang tigsilbi ug bino ug ang panadero nga didto sa prisohan. Managlahi ang ilang damgo ug managlahi usab ang kahulogan niini. ");
INSERT INTO cebocb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pagkabuntag, sa pag-adto ni Jose kanila, namatikdan niya nga nagmagul-anon sila. ");
INSERT INTO cebocb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Busa gipangutana niya sila, “Nganong magul-anon man kamo?” ");
INSERT INTO cebocb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Mitubag sila, “Nagdamgo man gud kami apan walay makasaysay sa kahulogan niini.” Miingon si Jose, “Ang Dios lang ang makahatag ug kaalam sa pagsaysay sa kahulogan sa mga damgo. Sultihi ninyo ako, palihog, kon unsa ang inyong mga damgo.” ");
INSERT INTO cebocb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Busa gisulti sa pangulo sa mga tigsilbi ug bino kang Jose ang iyang damgo. Miingon siya, “Sa akong damgo naay usa ka punoan sa ubas diha sa akong atubangan ");
INSERT INTO cebocb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ug aduna kini tulo ka sanga. Nanalingsing kini, namulak, ug nahinog ang mga bunga. ");
INSERT INTO cebocb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nagkupot ako sa kopa sa hari sa Ehipto, ug nagkuha ako ug ubas ug unya gipuga ko kini diha sa kopa. Human niini, gihatag ko ang kopa ngadto sa hari.” ");
INSERT INTO cebocb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Miingon si Jose, “Mao kini ang kahulogan sa imong damgo: Ang tulo ka sanga nagkahulogan ug tulo ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sa dili pa mahuman ang tulo ka adlaw, pagawason ka sa hari gikan sa prisohan ug pabalikon sa imong naandang trabaho ingon nga tigsilbi kaniya ug bino. ");
INSERT INTO cebocb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hinumdomi unya ako kon anaa ka na sa maayo nga kahimtang. Ug isip timaan sa imong kaayo, palihog, sultihi ang hari bahin kanako aron matabangan mo ako nga makagawas dinhi sa prisohan. ");
INSERT INTO cebocb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kay ang tinuod, pinugos ang pagdala kanako dinhi sa Ehipto gikan sa dapit sa mga Hebreo, ug bisan dinhi wala gayod akoy gibuhat nga mahimong hinungdan nga prisohon nila ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pagkadungog sa pangulo sa mga panadero nga maayo ang kahulogan sa damgo sa iyang kauban, gisulti usab niya ang iyang damgo ngadto kang Jose. Miingon siya, “Nagdamgo ako nga aduna akoy gilukdo nga tulo ka basket nga anaay mga pan. ");
INSERT INTO cebocb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ang kinaibabwan gisudlan sa nagkalain-laing klasi sa pan alang sa hari sa Ehipto, apan gipangtuhak kini sa mga langgam.” ");
INSERT INTO cebocb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Miingon si Jose, “Mao kini ang kahulogan sa imong damgo: Ang tulo ka basket nagkahulogan ug tulo ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sa dili pa mahuman ang tulo ka adlaw, pagawason ka sa hari gikan sa prisohan apan ipapatay ka niya ug tuhogon sa kahoy ang imong patayng lawas, ug tuhakon kini sa mga langgam.” ");
INSERT INTO cebocb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tulo ka adlaw gikan niini, gisaulog sa hari sa Ehipto ang iyang adlawng natawhan. Busa nagpakombira siya alang sa tanan niyang mga opisyal. Gipagawas niya gikan sa prisohan ang pangulo sa iyang mga tigsilbi ug bino ug ang pangulo sa iyang mga panadero ug gipaatubang sa iyang mga opisyal. ");
INSERT INTO cebocb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Gipabalik niya ang pangulo sa mga tigsilbi ug bino sa iyang naandang trabaho, ");
INSERT INTO cebocb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","apan gipapatay niya ang pangulo sa mga panadero, ug gituhog sa kahoy ang iyang patayng lawas sumala sa gisulti ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Apan wala gayod mahinumdomi sa pangulo sa mga tigsilbi ug bino si Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Paglabay sa duha ka tuig, nagdamgo ang hari sa Ehipto nga nagtindog siya sa daplin sa Suba sa Nilo, ");
INSERT INTO cebocb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ug sa kalit lang mitungha gikan sa suba ang pito ka himsog ug tambok nga mga baka, ug nanabsab kini sa kasagbotan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Wala madugay, mitunga usab ang pito ka daot ug niwang nga mga baka, ug miduol sa pito ka himsog ug tambok nga mga baka. ");
INSERT INTO cebocb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Giduol sa pito ka daot ug niwang nga baka ang pito ka himsog ug tambok nga baka ug gipangaon sila. Ug unya nakamata ang hari. ");
INSERT INTO cebocb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nakatulog ug balik ang hari ug nagdamgo na usab siya. Sa iyang damgo nakita niya ang pito ka himsog ug bus-ok nga mga uhay nga misibol diha sa usa lang ka punoan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ug sa mao gihapong punoan, misubol ang laing pito ka mga uhay nga niwang ug nanguyos tungod sa kainit sa hangin gikan sa sidlakan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Unya gilamoy sa niwang nga mga uhay ang pito ka himsog nga mga uhay. Unya nakamata ang hari. Abi niyag tinuod apan damgo lang diay kadto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nianang pagkabuntag, nahasol ang huna-huna sa hari tungod sa iyang mga damgo, busa gipatawag niya ang tanang mga madyikero ug maalamon nga mga tawo sa Ehipto. Gisugilon niya kanila ang iyang mga damgo, apan wala gayoy usa kanila nga nakasaysay sa kahulogan niadto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Unya miduol sa hari ang pangulo sa iyang mga tigsilbi ug bino ug miingon, “Nahinumdom na ako karon sa akong mga sala. ");
INSERT INTO cebocb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Dili ba nasuko ka man kaniadto kanako ug sa pangulo sa mga panadero, ug gipapriso mo man gani kami didto sa bilanggoan, sa lugar nga binantayan sa kapitan sa mga tigbalantay? ");
INSERT INTO cebocb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Usa niadto ka gabii, nagdamgo kaming duha, ug lain-lain ang kahulogan sa among mga damgo. ");
INSERT INTO cebocb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Aduna kamiy kauban didto nga batan-ong Hebreo, nga sulugoon sa kapitan sa mga tigbalantay sa palasyo. Gisugilon namo kaniya ang among damgo ug gisaysay niya kanamo ang kahulogan niini. ");
INSERT INTO cebocb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nahitabo gayod ang iyang giingon kanamo: Gipabalik mo ako sa akong naandang trabaho ug gipatuhog sa kahoy ang pangulo sa mga panadero.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Busa gipatawag sa hari si Jose, ug diha-diha gipagawas siya sa prisohan. Human siya nakapatupi ug nakapamalbas, nag-ilis siya sa iyang bisti ug miadto sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Miingon ang hari kaniya, “Nagdamgo ako apan wala gayoy nakasaysay kon unsa ang kahulogan niadto. Adunay nagsulti kanako nga makahibalo kang mosaysay sa kahulogan sa mga damgo.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Mitubag si Jose, “Dili ako, Mahal nga Hari, kondili ang Dios ang maghatag sa kahulogan sa imong mga damgo alang sa imong kaayohan.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Unya gisulti sa hari ang iyang damgo kang Jose. Miingon siya, “Nagdamgo ako nga nagtindog ako sa daplin sa Suba sa Nilo. ");
INSERT INTO cebocb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nakita ko nga mitunga gikan sa suba ang pito ka himsog ug tambok nga mga baka, ug nanabsab kini sa kasagbotan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Wala madugay mitunga usab ang laing pito ka daot ug niwang nga mga baka. Wala gayod akoy nakitang baka sa tibuok Ehipto nga sama kanila ka daot. ");
INSERT INTO cebocb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Unya gikaon niadtong daot ug niwang nga mga baka ang pito ka tambok nga mga baka. ");
INSERT INTO cebocb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Apan pagkahuman nila ug kaon, murag wala lang gihapon sila makakaon kay niwang man gihapon sila. Unya nakamata ako. ");
INSERT INTO cebocb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Apan nakatulog ako pagbalik ug nagdamgo pag-usab. Nakita ko sa akong damgo ang pito ka himsog ug bus-ok nga uhay nga misubol sa usa lang ka punoan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ug niadto usab nga punoan, misalingsing ang laing pito ka uhay nga niwang ug nanguyos tungod sa kainit sa hangin gikan sa sidlakan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Unya gilamoy sa niwang nga mga uhay ang pito ka himsog nga mga uhay. Gisulti ko na kini sa mga madyikero, apan wala gayoy usa kanila nga nakasaysay kanako kon unsa ang kahulogan.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Miingon si Jose sa hari, “Mahal nga Hari, usa ray kahulogan sa duha mo ka damgo. Gipadayag kanimo sa Dios kon unsa ang iyang buhaton. ");
INSERT INTO cebocb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ang pito ka tambok nga mga baka ug ang pito ka himsog nga mga uhay managsama nga nagkahulogan ug pito ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ang pito ka niwang ug daot nga mga baka ug ang pito ka niwang nga mga uhay nga nanguyos tungod sa kainit sa hangin gikan sa sidlakan nagkahulogan ug pito ka tuig nga kagutom. ");
INSERT INTO cebocb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Sumala sa giingon ko na kanimo, Mahal nga Hari, gipadayag kanimo sa Dios kon unsa ang iyang pagabuhaton. ");
INSERT INTO cebocb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Moabot ang pito ka tuig nga labihan gayod kaabunda sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ug mosunod dayon ang pito ka tuig nga kagutom, ug malimtan sa mga tawo ang nasinati nila nga kaabunda sa Ehipto. Ang kagutom mohimo ug dakong kadaot sa yuta sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Tungod sa makalilisang nga kagutom nga moabot, walay makita nga timailhan sa milabay nga panahon sa kaabunda sa yuta sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nagdamgo ka sa duha gayod ka higayon, Mahal nga Hari, aron nga mahibaloan mo nga pagbuot kini sa Dios nga mahitabo ug mahitabo gayod kini sa dili madugay. ");
INSERT INTO cebocb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Busa karon, Mahal nga Hari, pagpili ug usa ka tawong maalamon nga padumalahon mo sa yuta sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pagbutang usab ug mga opisyal sa tibuok yuta sa Ehipto aron mangolekta sa ikalima nga bahin sa abot sa kaumahan sulod sa pito ka tuig nga abunda ang abot. ");
INSERT INTO cebocb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sulod nianang mga tuiga, ipatigom kanila ang tanan nga bahin nga makolekta ninyo gikan sa mga abot. Ug ilalom sa imong pagdumala, patipigi kanila ang mga abot diha sa mga bodega sa mga lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kini nga mga pagkaon itagana alang sa moabot nga pito ka tuig nga kagutom sa Ehipto, aron dili magutman ang katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nakauyon ang hari ug ang iyang mga opisyal sa plano ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Miingon siya sa iyang mga opisyal, “Aduna pa ba kitay makita nga sama kang Jose nga gigiyahan sa Espiritu sa Dios?” ");
INSERT INTO cebocb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Busa miingon ang hari kang Jose, “Tungod kay gipadayag sa Dios kining mga butanga kanimo, wala nay laing tawo nga adunay kaalam ug salabotan nga sama kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","41","Himuon ka nako karon nga tigdumala sa akong palasyo ug gobernador sa tibuok Ehipto, ug motuman kanimo ang tanan kong katawhan. Ako ray labaw kanimo kay hari man ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Unya gihuslo sa hari ang iyang singsing nga pangtimbre ug gisul-ob kini sa tudlo ni Jose. Gipasul-oban niya si Jose ug pinasahi nga bisti nga lino ug gipakuwintas ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Gipasakay niya si Jose sa iyang ikaduhang karwahi, ug adunay mga tigpahibalo nga gauna kaniya ug nagsinggit, “Yukbo-i ninyo ang gobernador!” Busa sukad niadto nahimong gobernador si Jose sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Unya miingon ang hari kang Jose, “Ako ang hari dinhi sa Ehipto, apan walay bisan kinsa nga makahimo ug bisan unsa dinhi sa Ehipto gawas kon adunay pagtugot gikan kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Unya ginganlan niya si Jose ug Zafenat Panea. Gipaasawa usab niya kang Jose si Asenat nga anak ni Potifera nga pari sa lungsod sa On. Ingon nga gobernador, si Jose na ang nagdumala sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Nag-edad si Jose ug 30 ka tuig sa dihang nagsugod siya sa pag-alagad sa hari sa Ehipto. Ug mibiya si Jose sa palasyo ug milibot sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sulod sa pito ka tuig nga kaabunda, dako kaayo ang abot sa kaumahan. ");
INSERT INTO cebocb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ug niadtong mga tuiga, gipatigom ni Jose ang tanang mga bahin nga nakolekta gikan sa mga abot. Gipatipigan niya sa matag lungsod ang mga bahin sa abot nga nakolekta gikan sa mga uma sa palibot niini. ");
INSERT INTO cebocb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Labihan gayod kadaghan sa trigo nga natigom ni Jose; daw sama kini kadaghan sa balas sa baybayon. Tungod sa kadaghan niini giundangan na niya ang pagtakos. ");
INSERT INTO cebocb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sa wala pa moabot ang tinggutom, natawo ang duha ka anak ni Jose kang Asenat, nga anak ni Potifera nga pari sa On. ");
INSERT INTO cebocb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ginganlan ni Jose ang kamagulangan ug Manases kay miingon siya, “Tungod sa tabang sa Dios, nalimtan ko ang akong mga pag-antos ug ang kamingaw ko sa panimalay sa akong amahan.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ginganlan niya ang ikaduha niyang anak ug Efraim kay miingon siya, “Tungod sa tabang sa Dios, gihatagan ako ug kaliwat sa dapit diin nahiagom ako sa mga kasakit.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nahuman ang pito ka tuig sa kaabunda sa Ehipto, ");
INSERT INTO cebocb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ug nagsugod ang pito ka tuig nga kagutom sumala sa giingon ni Jose. Adunay kagutom sa uban nga mga dapit apan ang tibuok Ehipto adunay pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wala madugay, nakasinati na usab sa kagutom ang mga taga-Ehipto, busa nangayo sila ug pagkaon gikan sa hari. Miingon ang hari kanila, “Adto kamo kang Jose ug buhata ninyo kon unsay iyang isulti.” ");
INSERT INTO cebocb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mikuyanap ang kagutom sa tibuok kayutaan. Ug tungod sa labihan nga kagutom sa tibuok Ehipto, gipaablihan ni Jose ang tanang mga bodega ug gibaligyaan ug pagkaon ang mga taga-Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Nangadto usab sa Ehipto ang katawhan sa ubang mga nasod aron pagpalit ug pagkaon kang Jose tungod kay labihan na gayod ang kagutom sa tibuok kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Pagkahibalo ni Jacob nga adunay gibaligya nga pagkaon didto sa Ehipto, giingnan niya ang iyang mga anak nga lalaki, “Nganong gatinan-awanay lang kamo? ");
INSERT INTO cebocb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nakadungog ako nga adunay gibaligya nga pagkaon didto sa Ehipto, busa lakaw kamo didto ug pagpalit ug pagkaon aron dili kita mangamatay sa kagutom.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Busa milakaw ang napulo ka igsoon ni Jose ngadto sa Ehipto aron pagpalit ug pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Apan wala paubana ni Jacob si Benjamin nga manghod ni Jose kay nahadlok siya nga basin ug adunay daotan nga mahitabo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Miadto ang mga anak ni Jacob sa Ehipto kuyog sa ubang mga tawo aron pagpalit ug pagkaon, kay miabot na man usab ang kagutom sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ingon nga gobernador sa Ehipto, si Jose ang namaligya ug pagkaon ngadto sa mga tawo. Busa pag-abot sa iyang mga igsoon, miyukbo sila kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","9","Pagkakita ni Jose kanila, nailhan dayon niya sila apan nagpakaaron-ingnon siya nga wala makaila kanila. Pinasingka siya nga nakigsulti kanila. Nangutana siya, “Taga-asa kamo?” Mitubag sila, “Taga-Canaan kami, ug mianhi kami dinhi aron mopalit ug pagkaon.” Wala makaila kaniya ang iyang mga igsoon. Nahinumdoman dayon ni Jose ang iyang damgo mahitungod kanila. Miingon siya, “Mga espiya kamo! Mianhi kamo dinhi aron pagsusi kon asa nga bahin sa among nasod ang huyang ug depensa.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Mitubag sila, “Dili, sir! Mianhi kami dinhi aron mopalit ug pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Managsoon kaming tanan, usa ray among amahan, ug nagsulti kami sa tinuod. Dili kami mga espiya.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Apan miingon si Jose, “Dili ako motuo! Mianhi kamo dinhi aron pagsusi kon asa nga bahin sa among nasod ang huyang ug depensa.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Mitubag sila, “12 kaming managsoon, usa ray among amahan ug atua siya sa Canaan. Atua uban kaniya karon ang among kamanghoran, ug wala na ang usa namo ka igsoon.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Miingon si Jose, “Sama sa akong giingon kaninyo, mga espiya kamo. ");
INSERT INTO cebocb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ug masayran ko kon tinuod kanang inyong gisulti pinaagi niini: Ipanumpa ko sa ngalan sa hari sa Ehipto nga dili gayod kamo makabiya dinhi hangtod nga dili moanhi ang inyong kamanghoran. ");
INSERT INTO cebocb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Papaulia ang usa kaninyo aron pagkuha sa inyong igsoon. Prisohon kamong mahibilin hangtod nga mapamatud-an nga tinuod ang inyong giingon, apan kon dili, sa ngalan sa hari tinuod gayod nga mga espiya kamo.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Busa gipapriso niya sila sulod sa tulo ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sa ikatulo ka adlaw, miingon si Jose kanila, “Nagtahod ako sa Dios, busa hatagan ko pa kamo ug higayon nga mabuhi kon tumanon lang ninyo ang akong isugo kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kon nagsulti gayod kamo sa tinuod, ibilin sa prisohan ang usa kaninyo ug pamauli kamo ug pagdalag pagkaon alang sa gigutom ninyo nga mga pamilya. ");
INSERT INTO cebocb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Unya, dad-a ninyo dinhi kanako ang inyong manghod aron mapamatud-an nga tinuod ang inyong gisulti kanako ug aron dili ko kamo ipapatay.” Ug gibuhat nila kini. ");
INSERT INTO cebocb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Unya, miingon sila sa usag-usa, “Nakasala gayod kita sa gibuhat nato sa atong igsoon. Nakita nato ang iyang pag-antos sa dihang nagpakiluoy siya kanato, apan wala gayod nato siya kaloy-i, busa miabot kini nga kalisod kanato.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Miingon si Ruben, “Dili ba giingnan ko man kamo kaniadto nga dili ninyo pasipad-an ang bata? Apan wala gayod kamo namati kanako. Busa gipaninglan na kita karon sa iyang kamatayon.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wala sila masayod nga nakasabot si Jose sa ilang gipanulti tungod kay aduna man siyay tighubad kon makigsulti siya kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mibiya si Jose kanila ug mihilak. Unya mibalik siya ug nakigsulti kanila. Pagkahuman, gikuha niya si Simeon gikan kanila ug gipagapos diha sa ilang atubangan. ");
INSERT INTO cebocb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nagmando si Jose nga pun-on ug pagkaon ang mga sako sa iyang mga igsoon ug isulod sa ilang mga sako ang kuwarta nga ilang gibayad, ug pabalonan sila sa ilang paglakaw. Natuman ang tanang gimando ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Gikarga sa mga managsoon ang ilang mga sako didto sa ilang mga asno ug mibiya. ");
INSERT INTO cebocb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Sa dihang nagpalabay sila sa kagabhion sa usa ka dapit, usa kanila ang miabli sa iyang sako aron pakan-on ang iyang asno, ug nakita niya diha sa sako ang kuwarta nga iyang gibayad. ");
INSERT INTO cebocb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Misinggit siya sa iyang mga igsoon, “Giuli ang akong gibayad! Ania dinhi sa akong sako.” Nangaluya silang tanan ug nagkurog nga nag-ingnanay, “Unsa kining gibuhat sa Dios kanato?” ");
INSERT INTO cebocb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pag-abot nila sa Canaan, gisulti nila sa ilang amahan nga si Jacob ang tanan nga nahitabo kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Miingon sila kang Jacob, “Gisingkahan kami sa gobernador sa Ehipto ug gipasanginlan nga gapang-espiya kuno kami. ");
INSERT INTO cebocb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Apan gitubag namo siya nga dili kami mga espiya ug nagsulti kami sa tinuod. ");
INSERT INTO cebocb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","12 kami ka managsoon ug usa ray among amahan. Ang usa namo ka igsoon patay na ug ang among kamanghoran ania uban kanimo dinhi sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Apan mao kini ang iyang giingon kanamo, ‘Masayran ko kon tinuod ang inyong gipanulti pinaagi niini: Ibilin dinhi kanako ang usa kaninyo ug pamauli kamo nga magdala ug pagkaon alang sa inyong mga pamilya nga gigutom. ");
INSERT INTO cebocb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Unya dad-a ninyo dinhi kanako ang inyong manghod aron mahibaloan ko nga nagsulti kamo sa tinuod ug dili kamo mga espiya. Pagkahuman, ibalik ko kaninyo ang inyong igsoon, ug tugotan ko kamo nga magbalik-balik dinhi sa Ehipto.’ ” ");
INSERT INTO cebocb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sa dihang gibubo na nila ang sulod sa ilang mga sako, nakita nila didto ang kuwarta nga ilang gibayad. Pagkakita nila ug sa ilang amahan niini, gibati silang tanan ug kahadlok. ");
INSERT INTO cebocb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Miingon si Jacob kanila, “Gusto ba ninyo nga mawad-an akog mga anak? Wala na si Jose, wala na si Simeon, ug karon gusto na usab ninyo nga kuhaon si Benjamin. Puro na lang kasakit ang miabot kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Miingon si Ruben sa iyang amahan, “Isalig kanako si Benjamin. Patya ang duha ko ka anak nga lalaki kon dili ko siya madala pagbalik kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Apan mitubag si Jacob, “Dili ko paubanon kaninyo ang akong anak. Patay na ang iyang igsoon ug siya na lang ang nahibilin kanako. Kon adunay daotan nga mahitabo kaniya sa inyong paglakaw, kamo unya ang mahimong hinungdan nga niining akong katigulangon, mamatay ako sa kasubo.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Misamot pa gayod ang kagutom sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Nahurot na sa pamilya ni Jacob ang pagkaon nga nadala nila gikan sa Ehipto. Busa miingon si Jacob sa iyang mga anak, “Balik kamo didto sa Ehipto ug pagpalit kamog bisan gamay lang nga pagkaon.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Apan miingon si Juda kaniya, “Gipasidan-an kami sa gobernador nga dili magpakita kaniya kon dili namo kauban ang among igsoon nga si Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kon paubanon mo siya kanamo mobalik kami didto aron magpalit ug pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Apan kon dili, dili usab kami mobalik didto kay miingon ang gobernador nga dili magpakita kaniya kon dili namo kauban ang among igsoon.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Miingon si Jacob, “Nganong gihatagan man ninyo ako ug dakong problema? Nganong gisultihan pa man ninyo ang gobernador nga aduna pa kamoy usa ka igsoon?” ");
INSERT INTO cebocb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Mitubag sila, “Unsaon nga nagsige man siya ug pangutana bahin sa atong pamilya. Nangutana siya kon buhi pa ba ang among amahan ug aduna pa ba kami lain nga igsoon. Busa gitubag namo siya. Kinsa goy maghuna-huna nga ingnon niya kami nga dad-on namo ngadto kaniya ang among igsoon?” ");
INSERT INTO cebocb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Busa miingon si Juda sa ilang amahan, “Paubana na lang kanamo si Benjamin aron makalakaw na dayon kami aron dili kitang tanan mangamatay sa kagutom. ");
INSERT INTO cebocb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Igarantiya ko ang akong kinabuhi alang kang Benjamin. Ako ang manubag kon unsa unya ang mahitabo kaniya. Kon dili ko siya madala pagbalik kanimo nga buhi, akoy basola sa tibuok kong kinabuhi. ");
INSERT INTO cebocb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kon wala pa unta kita maglangay-langay, kaduha na unta tingali kami makabalik didto.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Miingon ang ilang amahan, “Kon mao kana ang maayo, sudli sa labing maayo nga mga produkto gikan dinhi sa atong dapit ang inyong mga sudlanan aron igasa sa gobernador sa Ehipto: mga tambal, dugos, lamas, pahumot, ug mga bunga sa pistasyo ug almond. ");
INSERT INTO cebocb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dobleha ninyo ang kantidad sa inyong dala nga kuwarta kay kinahanglan ninyong iuli ang kuwarta nga gibutang pagbalik sa inyong mga sako. Basig nasayop lang sila niadto. ");
INSERT INTO cebocb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dad-a ninyo ang inyong igsoon nga si Benjamin ug balik dayon kamo ngadto sa gobernador sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hinaut pa nga tandogon sa Makagagahom nga Dios ang kasing-kasing sa gobernador aron maluoy siya ug ibalik niya kaninyo si Simeon ug si Benjamin. Apan kon dili sila makabalik, dawaton ko na lang kini sa kinasing-kasing.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Busa gidala sa managsoon ang mga gasa ug gidoble usab nila ang ilang kuwarta. Unya milakaw sila ngadto sa Ehipto kauban si Benjamin, ug miatubang kang Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sa pagkakita ni Jose nga kauban nila si Benjamin, gisugo niya ang iyang sinaligan, “Dad-a kining mga tawhana sa balay. Pag-ihaw ug paghikay, kay maniudto sila uban kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Gituman sa sinaligan ang gisugo kaniya, ug gidala niya ang managsoon sa balay ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nahadlok ang managsoon sa dihang gidala sila sa balay ni Jose. Miingon sila, “Basin gidala kita dinhi tungod sa kuwarta nga gibalik sa atong mga sako sa una natong pag-anhi. Basig dakpon nila kita, ug kuhaon ang atong mga asno ug himuon kitang mga ulipon.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Busa giduolan nila ang sinaligan ug nakigsulti sila niini didto sa pultahan sa balay. ");
INSERT INTO cebocb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Miingon sila, “Kadyot una, sir, aduna kami isulti kanimo. Mianhi kami sa una aron sa pagpalit ug pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Sa among pagpauli, nagpalabay kami sa kagabhion sa usa ka dapit. Ug didto giablihan namo ang among mga sako ug nakita namo sa sulod ang mao kantidad nga gibayad namo. Gani ania, among gidala pagbalik aron iuli. ");
INSERT INTO cebocb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wala kami masayod kon kinsa ang nagbutang niini sa among mga sako. Nagdala pa kami ug dugang nga kuwarta aron ipalit ug pagkaon.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mitubag ang sinaligan, “Wala kadtoy kaso, ug ayaw kamo kahadlok. Ang inyong Dios, nga Dios usab sa inyong amahan, mao tingali ang nagbutang niadtong kuwartaha sa inyong mga sako. Nadawat ko ang inyong gibayad.” Unya gidala niya si Simeon ngadto kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Gipasulod sa sinaligan ang managsoon sa balay ni Jose ug gihatagan ug tubig aron makapanghugas sila sa ilang mga tiil. Gihatagan usab niya ug pagkaon ang ilang mga asno. ");
INSERT INTO cebocb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Giandam sa managsoon ang ilang mga gasa kang Jose samtang gihulat nila siya nga mopauli nianang pagkaudto, kay giingnan man sila nga adto maniudto sa balay ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Pag-abot ni Jose, miyukbo sila sa iyang atubangan ug gihatag nila ang ilang mga gasa. ");
INSERT INTO cebocb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nangutana si Jose kanila kon kumusta na sila. Unya nangutana usab siya, “Kumusta na man ang inyong tigulang na nga amahan, sumala sa inyong gisulti kanako? Buhi pa ba siya?” ");
INSERT INTO cebocb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Mitubag sila, “Buhi pa ang among amahan ug maayo usab ang iyang kahimtang.” Unya miyukbo sila pag-usab kaniya agig pagtahod. ");
INSERT INTO cebocb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Sa pagkakita ni Jose kang Benjamin nga iyang igsoon sa inahan, miingon siya, “Mao ba kini ang inyong kamanghorang igsoon nga giingon ninyo kanako?” Unya giingnan niya si Benjamin, “Hinaut pa nga panalanginan ka sa Dios, anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Unya midali-dali ug gawas si Jose kay kahilakon na gayod siya tungod sa iyang kamingaw sa iyang manghod. Misulod siya sa iyang kuwarto ug didto mihilak. ");
INSERT INTO cebocb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pagkahuman, nanghilam-os siya ug mibalik didto kanila nga nagpugong sa iyang pagbati. Unya nagmando siya nga maghukad na ug pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Lahi ang gikan-an ni Jose, lahi ang sa iyang mga igsoon, ug lahi usab ang iya sa mga Ehiptohanon nga didto naniudto. Kay dili mokaon ang mga Ehiptohanon uban sa mga Hebreo, kay mangil-ad kini alang kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Diha sa atubangan ni Jose ang gikan-an sa iyang mga igsoon. Nagtinan-away ang iyang mga igsoon kay natingala sila nga gipasunod gikan sa kamagulangan hangtod sa kamanghoran ang pagpalingkod kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Gisilbihan sila ug pagkaon gikan sa atubangan ni Jose apan ang pagkaon nga gihatag kang Benjamin lima gayod ka pilo ang gidaghanon kay sa gihatag sa uban. Nangaon sila ug nag-inom uban ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Unya, gimandoan ni Jose ang sinaligan sa iyang balay, “Pun-a ug pagkaon ang mga sako sa managsoon kutob sa ilang madala, ug isulod sa ilang mga sako ang kuwarta nga ilang gibayad. ");
INSERT INTO cebocb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Unya isulod ang akong kopa nga plata sa sako sa kamanghoran uban sa kuwarta nga iyang gibayad sa pagkaon.” Gibuhat sa sinaligan ang giingon ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sayo sa sunod nga adlaw, gipagikan ang managsoon uban sa ilang mga asno. ");
INSERT INTO cebocb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Apan wala pa sila makapalayo sa lungsod sa dihang miingon si Jose sa iyang sinaligan, “Dali, apasa kadtong mga tawhana! Ug kon maabtan mo sila, ingna sila, ‘Nganong gibalosan man ninyog daotan ang kaayo nga gibuhat namo kaninyo? ");
INSERT INTO cebocb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nganong gikuha man ninyo ang kopa nga imnanan sa akong agalon ug gamitonon usab niya sa pagpanagna? Dili maayo kining inyong gihimo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Sa dihang naapsan sa sinaligan ang managsoon, gisulti niya kadto kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Miingon sila, “Sir, nganong nakasulti ka man niana? Dili kami makahimo niana. ");
INSERT INTO cebocb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nasayod ka nga gikan sa Canaan gidala namo ug balik kanimo ang kuwarta nga nakita namo sulod sa among mga sako. Unya mangawat na hinuon kami ug pilak o bulawan gikan sa balay sa imong agalon? ");
INSERT INTO cebocb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kon makita mo ang kopa sa usa kanamo, patya siya ug kami mahimo ninyong ulipon.” ");
INSERT INTO cebocb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Miingon ang sinaligan, “Sige, kon makit-an ang kopa diha sa usa kaninyo himuon ko siyang ulipon, ug ang uban kaninyo wala nay tulubagon.” ");
INSERT INTO cebocb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Busa nagdali-dali ang matag-usa sa pagpakanaog sa ilang mga sako ug giablihan nila kini. ");
INSERT INTO cebocb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Unya nagsugod pagsusi ang sinaligan gikan sa sako sa kamagulangan hangtod sa kamanghoran, ug ang kopa nakita didto sa sako ni Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Sa pagkakita niini sa managsoon, gigisi nila ang ilang mga bisti tungod sa kasubo. Unya gikarga nila pag-usab sa asno ang ilang mga sako ug namalik sila sa lungsod. ");
INSERT INTO cebocb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Sa pag-abot ni Juda ug sa iyang mga igsoon sa Ehipto, didto pa si Jose sa iyang balay. Misulod sila sa balay ug miyukbo sa atubangan ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Miingon si Jose kanila, “Unsa kining inyong gihimo? Wala ba kamo masayod nga ang tawong sama kanako mahibalong managna?” ");
INSERT INTO cebocb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Miingon si Juda, “Sir, unsa pa may among ikasulti? Wala na kami ikapangatarungan pa kanimo. Ang Dios mao ang nagpadayag sa among sala. Karon, kaming tanan imo nang mga ulipon, kami ug kadtong usa diin didto kaniya nakit-an ang kopa.” ");
INSERT INTO cebocb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Apan miingon si Jose, “Dili kana mahimo. Siya lang nga nasakpan nga nagdala sa kopa mao ang akong himuong ulipon. Ug kamo makapauli na nga walay kakulian ngadto sa inyong amahan.” ");
INSERT INTO cebocb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Miduol si Juda kang Jose ug miingon, “Naghangyo ako kanimo, sir, kon mahimo pamatia ako. Hinaut nga dili ka masuko kanako, bisan tuod ug sama ka na sa hari sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nangutana ka kanamo kon aduna pa ba kami amahan ug igsoon, ");
INSERT INTO cebocb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ug miingon kami kanimo nga aduna pa kami amahan nga tigulang na ug adunay manghod nga natawo sa dihang tigulang na ang among amahan. Namatay na ang iyang igsoon ug siya na lang ang nahibilin nga anak sa iyang inahan, busa gimahal siya pag-ayo sa among amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Unya miingon ka kanamo nga dad-on siya kanimo aron makita mo siya. ");
INSERT INTO cebocb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Miingon kami kanimo nga dili mahimo nga biyaan sa among manghod ang among amahan kay ikamatay niya kini. ");
INSERT INTO cebocb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Apan miingon ka nga dili ka na moatubang pag-usab kanamo kon dili namo kauban ang among kamanghoran. ");
INSERT INTO cebocb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kining tanan gisugilon namo sa among amahan sa among pagpauli. ");
INSERT INTO cebocb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Unya miingon ang among amahan nga mobalik kami dinhi kay mopalit pag-usab ug pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Apan miingon kami kaniya nga molakaw lang kami kon kauban namo ang among kamanghoran, tungod kay dili kami mahimong mopakita kanimo kon dili namo siya kauban. ");
INSERT INTO cebocb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Mao kini ang iyang gitubag kanamo, ‘Nasayod kamo nga gihatagan akog duha ka anak nga lalaki sa akong asawa nga si Raquel. ");
INSERT INTO cebocb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ang usa wala na; gikunis-kunis tingali siya sa bangis nga mananap. Ug hangtod karon, wala ko na gayod siya makita. ");
INSERT INTO cebocb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kon kuhaon pa gayod ninyo kining usa gikan kanako, ug kon adunay mahitabo kaniya, niining akong katigulangon mamatay ako sa kaguol.’ ");
INSERT INTO cebocb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Busa, ang kinabuhi sa among amahan nabugkos sa kinabuhi sa among kamanghoran. Kon mopauli kami nga dili namo siya kauban, ");
INSERT INTO cebocb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sigurado gayod nga mamatay sa kaguol ang among tigulang na nga amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gigarantiya ko ang akong kinabuhi alang sa among kamanghoran. Giingnan ko ang akong amahan nga kon dili ko madala pagbalik kaniya ang iyang anak, ako ang iyang basolon sa tibuok kong kinabuhi. ");
INSERT INTO cebocb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Busa, sir, ako na lang ang magpabilin dinhi isip imong ulipon puli sa among kamanghoran, ug tugoti na lang siya nga makapauli uban sa iyang mga igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Dili ako mopauli kon dili ko kauban ang among kamanghoran. Dili ako makaako sa pagsud-ong sa daotan unya nga mahitabo sa among amahan tungod niini.” ");
INSERT INTO cebocb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Wala na gayod mapugngi ni Jose ang iyang gibati, busa gipagawas niya ang iyang mga sulugoon. Ug sa dihang sila na lang sa iyang mga igsoon ang nahibilin, nagpaila siya. ");
INSERT INTO cebocb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Mihilak ug kusog si Jose, busa nadunggan kini sa mga Ehiptohanon, ug gibalita kini didto sa palasyo sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Miingon si Jose sa iyang mga igsoon, “Ako si Jose! Tinuod ba gayod nga buhi pa ang atong amahan?” Apan wala makatubag ang iyang mga igsoon kaniya kay nahadlok sila. ");
INSERT INTO cebocb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Busa miingon si Jose, “Duol kamo kanako.” Ug miduol sila. Unya miingon siya, “Ako si Jose nga inyong igsoon, nga inyong gibaligya ug gidala ako dinhi sa Ehipto sa nagpalit kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ayaw na kamo kabalaka ug ayaw ninyo basola ang inyong kaugalingon sa pagbaligya ninyo kanako dinhi, tungod kay ang Dios mao ang nagpadala kanako dinhi una kaninyo aron luwason ang inyong kinabuhi. ");
INSERT INTO cebocb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ikaduha pa lang kini nga tuig sa kagutom, ug mosunod pa ang lima ka tuig nga walay abot. ");
INSERT INTO cebocb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Apan gipauna ako sa Dios dinhi aron maluwas ko kamo ug adunay mahabilin sa inyong kaliwatan dinhi sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Busa, dili kamo ang nagpadala kanako dinhi kondili ang Dios. Gihimo niya ako nga magtatambag sa hari, ug tigdumala sa iyang palasyo ug sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Karon, pagdali ug balik kamo didto sa akong amahan ug suginli siya nga ang iyang anak nga si Jose gihimo sa Dios nga tigdumala sa tibuok Ehipto. Ug ingna siya nga moanhi dinhi sa labing madali. ");
INSERT INTO cebocb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mahimo siyang mopuyo sa yuta sa Goshen aron mahiduol siya kanako uban sa iyang mga anak ug mga apo. Ug dad-on usab niya ang iyang kahayopan, ug ang tanan niyang kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Atimanon ko siya didto sa Goshen tungod kay aduna pay lima ka tuig nga kagutom. Dili ko gusto nga magutman siya ug ang iyang panimalay, apil ang iyang kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nagpadayon si Jose sa pag-ingon, “Karon nakita ninyo mismo, ug sa akong igsoon nga si Benjamin, nga ako si Jose kining nakigsulti kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Sultihi ninyo ang akong amahan mahitungod sa kadungganan nga naangkon ko dinhi sa Ehipto ug sa tanan nga inyong nakita. Ug dad-a dayon ninyo siya dinhi kanako.” ");
INSERT INTO cebocb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Unya migakos si Jose sa iyang igsoon nga si Benjamin ug mihilak, ug mihilak usab si Benjamin samtang naggakos kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Padayon siyang mihilak samtang gitagsa-tagsa niya paghalok ang tanan niyang mga igsoon. Ayha pa dayon nakahimo pagpakigsulti ang iyang mga igsoon kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sa dihang nabalita didto sa palasyo sa hari sa Ehipto nga miabot ang mga igsoon ni Jose, nalipay ang hari ug ang iyang mga opisyal. ");
INSERT INTO cebocb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Miingon ang hari kang Jose, “Ingna ang imong mga igsoon nga kargahan nila ug pagkaon ang ilang mga hayop ug mobalik sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Unya dad-on nila dinhi ang inyong amahan ug ang ilang mga pamilya, kay ihatag ko kanila ang maayo nga yuta sa Ehipto ug makakaon sila sa labing maayo nga mga produkto niini. ");
INSERT INTO cebocb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ingna usab sila nga magdala ug mga karwahi gikan dinhi sa Ehipto aron masakyan sa ilang mga asawa ug mga anak sa ilang pag-anhi. Ug dad-on gayod nila ang ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Dili sila kinahanglang manganugon sa ilang mga kabtangan nga mahibilin didto tungod kay ang maayo nga mga butang sa tibuok Ehipto mahimong ila.” ");
INSERT INTO cebocb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Gituman kini sa mga anak ni Jacob. Ug sumala sa sugo sa hari sa Ehipto, gihatagan ni Jose ang iyang mga igsoon sa mga karwahi ug gipabalonan sa ilang pagbiyahe. ");
INSERT INTO cebocb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Gihatagan usab niya ang matag-usa kanila ug bisti, apan ang gihatag niya kang Benjamin lima ka bisti ug 300 kapirasong pilak. ");
INSERT INTO cebocb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Gipadad-an usab niya ang iyang amahan ug 10 ka asno nga gikargahan sa labing maayo nga mga produkto sa Ehipto, ug laing 10 ka bayeng asno nga gikargahan ug trigo, pan, ug uban pang mabalon sa iyang amahan sa pagbiyahe. ");
INSERT INTO cebocb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Gipagikan niya ang iyang mga igsoon ug giingnan nga dili sila mag-away sa ilang paglakaw. ");
INSERT INTO cebocb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Busa migikan sila sa Ehipto ug miadto sa ilang amahan sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Sa ilang pag-abot, gisultihan nila ang ilang amahan nga buhi si Jose, ug siya ang tigdumala sa tibuok Ehipto. Nakalitan si Jacob; wala siya makatuo kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Apan sa dihang gisultihan nila siya sa tanan nga giingon ni Jose, ug sa dihang nakita niya ang mga karwahi nga gipadala ni Jose sa pagdala kaniya sa Ehipto, nadasig siya. ");
INSERT INTO cebocb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Miingon si Jacob, “Motuo na ako! Buhi pa diay ang akong anak nga si Jose. Adtoon ko siya sa dili pa ako mamatay.” ");
INSERT INTO cebocb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Miadto si Jacob sa Ehipto uban sa iyang panimalay, dala ang tanan niyang kabtangan. Sa pag-abot niya sa Beersheba, naghalad siya ngadto sa Dios sa iyang amahan nga si Isaac. ");
INSERT INTO cebocb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nianang pagkagabii, nakigsulti ang Dios kaniya pinaagi sa usa ka panan-awon. Gitawag sa Dios si Jacob, ug mitubag siya. ");
INSERT INTO cebocb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Unya miingon ang Dios, “Ako ang Dios, nga mao ang Dios sa imong amahan. Ayaw kahadlok nga moadto sa Ehipto, kay himuon ko kamo didto nga usa ka dako nga nasod. ");
INSERT INTO cebocb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mouban ako mismo kanimo sa pag-adto sa Ehipto ug dad-on ko usab ikaw pagbalik sa Canaan. Ug mamatay ka nga anaa si Jose sa imong kiliran.” ");
INSERT INTO cebocb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Gipasakay si Jacob sa iyang mga anak sa karwahi nga gihatag sa hari sa Ehipto para ilang sakyan. Gipasakay usab nila ang ilang mga asawa ug mga anak, ug migikan sila sa Beersheba. ");
INSERT INTO cebocb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Gidala nila ang mga kahayopan ug kabtangan nga natigom nila didto sa Canaan. Gidala usab ni Jacob sa Ehipto ang tanan niyang kaliwatan: ang iyang mga anak ug mga apo. ");
INSERT INTO cebocb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mao kini ang mga ngalan sa mga kaliwat nga lalaki ni Israel (nga mao usab si Jacob) nga miadto sa Ehipto: Si Ruben nga kamagulangang anak ni Jacob, ");
INSERT INTO cebocb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ug ang mga anak ni Ruben sila si Hanoc, Palu, Hezron, ug Carmi. ");
INSERT INTO cebocb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Si Simeon ug ang iyang mga anak nga sila si Jemuel, Jamin, Ohad, Jakin, Zohar, ug si Saulo nga iyang anak sa babaye nga Canaanhon. ");
INSERT INTO cebocb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Si Levi ug ang iyang mga anak nga sila si Gershon, Kohat, ug Merari. ");
INSERT INTO cebocb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Si Juda ug ang iyang mga anak nga sila si Er, Onan, Shela, Perez, ug Zera (apan si Er ug si Onan namatay didto sa Canaan). Ug ang mga anak ni Perez nga sila si Hezron ug si Hamul. ");
INSERT INTO cebocb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Si Isacar ug ang iyang mga anak nga sila si Tola, Pua, Jashub, ug Shimron; ");
INSERT INTO cebocb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","si Zabulon ug ang iyang mga anak nga sila si Sered, Elon, ug Jalel. ");
INSERT INTO cebocb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Mao kini sila ang 33 ka mga anak ug mga apo ni Jacob kang Lea nga natawo sa Padan Aram, apil ang iyang anak nga babaye nga si Dina. ");
INSERT INTO cebocb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Si Gad ug ang iyang mga anak nga sila si Zefion, Hagi, Shuni, Ezbon, Eri, Arodi, ug Areli. ");
INSERT INTO cebocb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Si Aser ug ang iyang mga anak nga sila si Imna, Ishva, Ishvi, Beria. Ang igsoon nila nga babaye nga si Sera. Ang mga anak ni Beria nga sila si Eber ug si Malkiel. ");
INSERT INTO cebocb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Mao kini sila ang 16 ka mga anak ug mga apo ni Jacob kang Zilpa, ang sulugoon nga gihatag ni Laban kang Lea. ");
INSERT INTO cebocb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ang mga anak ni Jacob kang Raquel mao: si Jose ug si Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ang mga anak ni Jose kang Asenat nga natawo sa Ehipto mao si Manases ug si Efraim. (Si Asenat anak nga babaye ni Potifera nga pari sa lungsod sa On.) ");
INSERT INTO cebocb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Si Benjamin ug ang iyang mga anak nga sila si Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim, ug Ard. ");
INSERT INTO cebocb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Mao kini sila ang 14 ka mga anak ug mga apo ni Jacob kang Raquel. ");
INSERT INTO cebocb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Si Dan ug ang iyang anak nga si Hushim; ");
INSERT INTO cebocb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","si Neftali ug ang iyang mga anak nga sila si Jazeel, Guni, Jezer, ug Shilem. ");
INSERT INTO cebocb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Mao kini sila ang 7 ka mga anak ug mga apo ni Jacob kang Bilha, ang sulugoon nga gihatag ni Laban kang Raquel. ");
INSERT INTO cebocb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ang mga anak ug mga apo ni Jacob nga miadto sa Ehipto 66 tanan, ug wala pay labot ang mga asawa sa iyang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Lakip ang mga anak ni Jose nga natawo sa Ehipto, 70 ang tanan nga miyembro sa panimalay ni Jacob nga natigom sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Gipauna ni Jacob si Juda ngadto kang Jose aron magiyahan sila ngadto sa Goshen. Sa nagkaduol na sila si Jacob sa Goshen, ");
INSERT INTO cebocb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","misakay si Jose sa iyang karwahi ug miadto aron sa pagsugat sa iyang amahan. Sa ilang pagkita, gigakos ni Jose ang iyang amahan ug nagsige kinig hilak. ");
INSERT INTO cebocb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Miingon si Jacob kang Jose, “Karon andam na ako nga mamatay tungod kay nakita ko na ikaw nga buhi.” ");
INSERT INTO cebocb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Unya miingon si Jose sa iyang mga igsoon ug sa tibuok nga panimalay sa iyang amahan, “Molakaw ako ug sultihan ko ang hari sa Ehipto nga ania na ang akong mga igsoon ug ang tibuok nga panimalay sa akong amahan nga gikan sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ingnon ko siya nga kamo mga magbalantay sa mga kahayopan, ug gidala pa gani ninyo ang inyong mga kahayopan ug ang tanan ninyong kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Busa kon ipatawag niya kamo ug pangutan-on kon unsa ang inyong trabaho, ");
INSERT INTO cebocb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ingna siya nga sama sa inyong mga ginikanan, magbalantay usab kamo sa kahayopan sukad pa niadtong gagmay pa kamo, aron sa ingon papuy-on niya kamo sa Goshen. Kay ubos ang pagtan-aw sa mga taga-Ehipto sa mga magbalantay ug kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Unya milakaw si Jose ug miadto sa hari sa Ehipto. Miingon si Jose sa hari, “Miabot na ang akong amahan ug mga igsoon gikan sa Canaan, ug dala nila ang ilang kahayopan ug ang tanan nilang kabtangan. Tua sila karon sa Goshen.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Unya gipaila-ila niya sa hari ang lima niya ka igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Gipangutana sila sa hari, “Unsa ang inyong trabaho?” Mitubag sila, “Mga magbalantay kamig kahayopan, sama sa among mga ginikanan. ");
INSERT INTO cebocb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mianhi kami aron dinhi una magpuyo tungod kay labihan gayod ang kagutom sa Canaan, ug wala nay masabsab ang among kahayopan. Naghangyo kami nga kon mahimo, tugotan mo kami nga mopuyo sa Goshen.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Miingon ang hari kang Jose, “Karon nga ania na ang imong amahan ug mga igsoon, ");
INSERT INTO cebocb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","andam ang Ehipto pagdawat sa imong panimalay. Papuy-a sila sa Goshen, nga usa ka maayong yuta sa Ehipto. Kon aduna kay mahibaloan nga kasaligan diha kanila, himoa silang tigdumala sa mga magbalantay sa akong kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Gidala ni Jose ang iyang amahan ngadto sa hari ug gipaila-ila. Gipanalanginan ni Jacob ang hari, ");
INSERT INTO cebocb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ug gipangutana siya niini, “Pila na ang imong edad?” ");
INSERT INTO cebocb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Mitubag siya, “130 ka tuig na ako. Mubo ug lisod ang akong kinabuhi. Dili kini sama kataas sa kinabuhi sa akong mga katigulangan.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pagkahuman gipanalanginan na usab ni Jacob ang hari, ug unya mihawa siya sa presensya sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Sumala sa sugo sa hari, gipahimutang ni Jose ang iyang amahan ug mga igsoon sa Ehipto; gihatag niya kanila ang lugar sa Rameses, nga usa ka maayong yuta sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Gisustentohan ni Jose ug pagkaon ang iyang amahan ug mga igsoon, ug ang tibuok nga panimalay sa iyang amahan, basi sa gidaghanon sa ilang mga anak. ");
INSERT INTO cebocb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Unya, misamot pa gayod ang kagutom sa Ehipto ug sa Canaan, ug ang mga tawo wala nay pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Gitigom ni Jose ang tanang kuwarta nga gibayad sa mga taga-Ehipto ug taga-Canaan sa pagkaon nga ilang gipalit, ug gidala niya kini sa palasyo sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Pagkahurot sa kuwarta sa mga taga-Ehipto ug taga-Canaan, miadto ang mga taga-Ehipto kang Jose ug miingon, “Wala na kami kuwarta. Hatagi kami ug pagkaon kay mamatay na kami sa kagutom.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Miingon si Jose, “Kon wala na kamoy kuwarta, dad-a ninyo dinhi ang inyong kahayopan ug bayloan ko ug pagkaon.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Busa gidala nila kang Jose ang ilang mga kabayo, karnero, baka, ug asno, ug gibayloan kini ug pagkaon. Nianang tibuok tuig, gihatagan sila ni Jose ug pagkaon baylo sa ilang kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pagkahuman sa usa ka tuig, miadto na usab ang mga tawo kang Jose ug miingon, “Dili malimod kanimo nga wala na kamiy kuwarta ug ang among kahayopan anaa na kanimo. Wala na gayoy nahibilin kanamo, gawas sa among kaugalingon ug sa among mga yuta. ");
INSERT INTO cebocb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pasagdan mo lang ba kami nga mamatay ug mapasagdan ang among mga yuta? Palita kami ug ang among yuta. Mosugot kami nga mahimong ulipon sa hari ug maiya na ang among kayutaan aron lang makakaon kami. Hatagi kami ug mga binhi nga among ikatanom aron dili kami mamatay ug aron dili namo mapasagdan ang among kayutaan.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Busa gibaligya sa tanan nga taga-Ehipto ang ilang mga yuta ngadto kang Jose tungod kay labihan na gayod ang kagutom. Gipalit ni Jose kining tanan alang sa hari, ug ang tanang kayutaan napanag-iya sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Gihimo ni Jose nga ulipon sa hari ang katawhan sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ang mga yuta lang sa mga pari ang wala mapalit ni Jose. Wala ibaligya sa mga pari ang ilang kayutaan tungod kay gisustentohan sila sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Miingon si Jose sa mga tawo, “Karon nga napalit ko na kamo ug ang inyong kayutaan alang sa hari, ania ang binhi aron itanom ninyo. ");
INSERT INTO cebocb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Inig-ani ninyo, ihatag ngadto sa hari ang ikalima nga bahin sa inyong abot. Ug ang mahibilin inyo na, aron nga aduna kamoy itanom ug adunay pagkaon ang inyong tibuok nga panimalay.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Miingon ang mga tawo, “Sir, maayo ka kaayo kanamo; giluwas mo ang among kinabuhi. Mosugot kami nga mahimong ulipon sa hari.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Busa gihimo ni Jose nga balaod sa yuta sa Ehipto nga ang ikalima nga bahin sa abot alang sa hari. Kini nga balaod nagpadayon pa hangtod karon. Ang mga yuta lang gayod sa mga pari ang wala mapanag-iya sa hari. ");
INSERT INTO cebocb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Didto na namuyo ang mga Israelinhon sa Goshen nga sakop sa Ehipto. Nakaangkon sila didto ug yuta ug midaghan ang ilang kaliwat. ");
INSERT INTO cebocb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Mipuyo si Jacob sa Ehipto sulod sa 17 ka tuig; nagkinabuhi siya hangtod sa edad nga 147 ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sa dihang hapit na siya mamatay, gipatawag niya si Jose ug giingnan, “Kon mahimo itapion ang imong kamot taliwala sa duha ko ka paa ug panumpa nga ipadayon mo ang imong kaayo kanako. Ayaw ako ilubong dinhi sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kon mamatay na ako, dad-a ang akong patay nga lawas gawas sa Ehipto ug ilubong ako didto sa lubnganan sa akong mga katigulangan.” Mitubag si Jose, “Tumanon ko ang imong giingon.” ");
INSERT INTO cebocb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Unya miingon si Jacob, “Panumpa kanako nga tumanon mo gayod kini.” Busa nanumpa si Jose kaniya. Unya miluhod si Jacob sa ulohan sa iyang higdaanan aron pasalamatan ang Dios. ");
INSERT INTO cebocb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Wala madugay adunay misulti kang Jose nga nagsakit ang iyang amahan nga si Jacob. Busa gidala niya ang iyang duha ka anak nga si Manases ug si Efraim ug miadto kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sa dihang gisultihan si Jacob nga miabot ang iyang anak nga si Jose, naningkamot siya nga makalingkod sa iyang gihigdaan. ");
INSERT INTO cebocb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Miingon si Jacob kang Jose, “Sa didto pa ako sa Luz, sa yuta sa Canaan, nagpakita kanako ang Makagagahom nga Dios ug gipanalanginan niya ako. ");
INSERT INTO cebocb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Miingon siya, ‘Hatagan ka nako ug daghang mga kaliwat aron mahimo kang amahan sa daghang mga katawhan. Ug ihatag ko kining yuta sa Canaan sa imong mga kaliwat ug mapanag-iya nila kini hangtod sa kahangtoran.’ ");
INSERT INTO cebocb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ang duha mo ka anak nga si Efraim ug si Manases, nga natawo dinhi sa Ehipto sa wala pa ako moabot, ilhon ko nga akong mga anak, nga sama kanila ni Ruben ug Simeon. ");
INSERT INTO cebocb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Apan ang umaabot mo nga mga anak magpabilin nga imo, ug makadawat sila ug panulondon gikan kang Efraim ug kang Manases. ");
INSERT INTO cebocb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nahinumdom ako sa pagkamatay ni Raquel. Gikan kami niadto sa Padan sa among paglakaw paingon sa yuta sa Canaan. Duol na kami sa Efrata nga sakop sa Canaan sa dihang namatay siya, busa gilubong ko na lang siya sa daplin sa dalan nga paingon sa Efrata.” (Ang Efrata gitawag karon nga Betlehem.) ");
INSERT INTO cebocb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sa dihang nakita ni Israel ang mga anak ni Jose, nangutana siya, “Kinsa sila?” ");
INSERT INTO cebocb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Mitubag si Jose, “Sila ang akong mga anak nga gihatag kanako sa Dios dinhi sa Ehipto.” Unya miingon si Israel, “Dad-a sila palihog dinhi kanako aron mapanalanginan ko sila.” ");
INSERT INTO cebocb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Halap na si Israel tungod sa iyang katigulangon, busa gipaduol ni Jose ang iyang mga anak kang Israel. Gigakos sila ni Israel ug gihagkan. ");
INSERT INTO cebocb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Miingon si Israel kang Jose, “Wala na gayod ako magdahom nga makita ko pa ikaw, apan karon gitugot sa Dios nga dili lang ikaw ang akong makita kondili lakip usab ang imong mga anak.” ");
INSERT INTO cebocb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Gikuha ni Jose ang iyang mga anak sa sabakan ni Israel ug miluhod siya agig pagtahod sa iyang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Unya gipaatubang niya ang iyang mga anak kang Israel aron mapanalanginan sila. Gipahimutang ni Jose si Efraim diha sa iyang tuo, tunong sa wala nga kamot ni Israel; ug si Manases iyang gipahimutang sa iyang wala, tunong sa tuong kamot ni Israel. ");
INSERT INTO cebocb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Apan gisaylo ni Israel ang iyang tuong kamot ug didto kini gitapion sa ulo ni Efraim nga mao ang manghod, ug ang iyang walang kamot didto sa ulo ni Manases nga mao ang magulang. ");
INSERT INTO cebocb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Unya gipanalanginan niya sila nga nag-ingon, “Hinaut nga panalanginan kining mga bataa sa Dios nga gialagaran sa akong katigulangan nga si Abraham ug si Isaac, nga mao usab ang Dios nga nagbantay kanako sukad pa sa akong pagkatawo hangtod karon. ");
INSERT INTO cebocb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ug hinaut nga panalanginan usab sila sa Anghel nga nagluwas kanako gikan sa tanan nga katalagman. Hinaut nga mahinumdoman ako ug ang akong katigulangan nga si Abraham ug si Isaac pinaagi kanila. Ug hinaut nga mosanay sila sa kalibotan.” ");
INSERT INTO cebocb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Sa pagkakita ni Jose nga gitungtong sa iyang amahan ang iyang tuong kamot sa ulo ni Efraim, gipakaingon niyag nasayop kini. Busa gikuptan niya ang kamot sa iyang amahan aron ibalhin ngadto sa ulo ni Manases. ");
INSERT INTO cebocb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Miingon siya, “Amahan ko, dili kana mao. Ania ang magulang; itapion ang imong tuong kamot sa iyang ulo.” ");
INSERT INTO cebocb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Apan midumili ang iyang amahan, “Nasayod ako anak. Ang mga kaliwat ni Manases mahimo usab nga usa ka nasod, ug mahimo usab siyang bantogan. Apan mahimong mas bantogan ang mga kaliwat ni Efraim ug maggikan kanila ang labihan kadaghang mga nasod.” ");
INSERT INTO cebocb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Niadtong adlawa, gipanalanginan niya sila nga nag-ingon, “Gamiton sa mga Israelinhon ang inyong mga ngalan sa paghatag nila ug panalangin. Moingon sila, ‘Hinaut nga panalanginan ka sa Dios sama kang Efraim ug kang Manases.’ ” Niining paagiha gihimo niya si Efraim nga labaw kang Manases. ");
INSERT INTO cebocb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Unya miingon si Israel kang Jose, “Hapit na akong mamatay, apan ubanan kamo sa Dios ug pabalikon sa yuta sa inyong katigulangan. ");
INSERT INTO cebocb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ug ikaw Jose ang manunod sa Sekem ug dili ang imong mga igsoon. Kanang dapita naangkon ko pinaagi sa akong pagpakig-gira sa mga Amorihanon.” ");
INSERT INTO cebocb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Unya gipatawag ni Jacob ang iyang mga anak ug giingnan: “Pagtigom kamo kay suginlan ko kamo kon unsa ang mahitabo kaninyo sa umaabot nga panahon. ");
INSERT INTO cebocb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Dali kamo, mga anak ni Jacob, pamati kamo kang Israel nga inyong amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ikaw Ruben, ang akong kamagulangan nga anak, ikaw ang unang bunga sa akong pagkalalaki. Nag-una ka sa imong mga igsoon sa pagkadungganon ug pagkagamhanan. ");
INSERT INTO cebocb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Apan sama ka sa nagbukal nga tubig, kay dili ka makapugong sa imong kaibog. Ug tungod kay nakigdulog ka sa akong asawa nga sulugoon ug gihugawan mo ang akong kaminyoon, dili ka na molabaw sa uban. ");
INSERT INTO cebocb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Kamo Simeon ug Levi nga kanunayng magkasinabot, gigamit ninyo ang inyong hinagiban sa pagpamatay. ");
INSERT INTO cebocb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ayaw ako patambonga sa inyong panagtigom kay sa inyong kasuko mopatay kamo ug tawo, ug piangan ninyo ang torong baka sa walay igong hinungdan. ");
INSERT INTO cebocb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Panghimaraoton kamo tungod sa inyong mapintas nga kasuko. Patibulaagon ko ang inyong mga kaliwat sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Ikaw Juda, dayegon ka ug tahoron sa imong mga igsoon. Pildihon mo ang imong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Sama ka Juda sa batan-ong liyon nga human pagpangita sa iyang tukbonon, mobalik sa iyang tago-anan ug molubog. Ug wala gayoy mangahas sa pagsamok kaniya. ");
INSERT INTO cebocb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Magmando ka sa dayon, Juda. Maggikan sa imong kaliwatan ang mga tigdumala. Busa mohatag ang mga nasod ug buhis ug motuman sila kanimo. ");
INSERT INTO cebocb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Tabunok ang imong yuta ug modaghan ang tanom nga ubas; gani bisag ihigot mo ang imong asno diha sa pinakamaayong punoan sa ubas, dili kini mahurot ug sabsab. Manglaba siya sa iyang bisti ug ang duga sa ubas ang iyang gamiton. ");
INSERT INTO cebocb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Busa tungod sa kadaghan sa mainom nga duga sa ubas mopula ang imong mga mata ug tungod sa kadaghan sa mainom nga gatas moputi ang imong mga ngipon. ");
INSERT INTO cebocb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Ikaw Zabulon, magpuyo ka daplin sa baybay. Ang imong dapit mahimong dunggoanan sa mga sakayan. Ang imong yuta mosangko sa Sidon. ");
INSERT INTO cebocb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Ikaw Isacar, sama ka sa kusgan nga asno nga naglubog sa puloy-anan sa mga karnero. ");
INSERT INTO cebocb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kon makita mo nga ang yuta nindot ug maayong pahulayan, mosugot ka nga magpaulipon; bisan magpas-an ka pa ug bug-at ug pugson sa pagtrabaho. ");
INSERT INTO cebocb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ikaw Dan, pangulohan mo ug maayo ang imong katawhan ingon nga usa sa mga tribo sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Mahisama ka Dan sa malala nga bitin sa daplin sa dalan nga mopaak sa tiil sa kabayo, busa mahulog ang sakay niini. ");
INSERT INTO cebocb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“O Ginoo, naghulat ako sa imong pagluwas kanako. ");
INSERT INTO cebocb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ikaw Gad, sulongon ka sa pundok sa mga tulisan, apan balosan mo sila samtang nag-ikyas sila. ");
INSERT INTO cebocb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ikaw Aser, modagaya ang lamiang mga pagkaon diha kanimo. Mohatag ka ug mga pagkaon nga angay sa mga hari. ");
INSERT INTO cebocb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ikaw Neftali, sama ka sa binuhian nga usa nga adunay maanindot nga mga nati. ");
INSERT INTO cebocb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Ikaw Jose, sama ka sa maidlas nga asno nga anaa daplin sa tuboran o sa bakilid. ");
INSERT INTO cebocb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Giataki ka sa bangis nga mga mamamana. Gipana ka nila ug gidumtan. ");
INSERT INTO cebocb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Apan gipana mo usab sila kanunay. Ug nagpabiling lig-on ang imong mga bukton, tungod sa gahom sa Makagagahom nga Dios ni Jacob, ang Magbalantay ug ang salipdanan nga Bato sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Siya ang Makagagahom nga Dios sa imong katigulangan. Siya ang nagtabang ug nagpanalangin kanimo. Hatagan ka niya ug ulan ug tubig sa tuboran. Hatagan ka usab niya ug daghang kabataan ug kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ang mga panalangin nga gihatag kanako sa akong mga katigulangan labaw pa kaysa kadagaya sa mga panalangin nga naggikan sa karaang mga bungtod. Hinaut pa nga madawat mo kini nga mga panalangin, Jose, ikaw nga nahimong pangulo sa imong mga igsoon. ");
INSERT INTO cebocb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ikaw Benjamin, sama ka sa bangis nga iro nga sa adlaw mopatay ug mokaon sa iyang biktima ug sa gabii bahin-bahinon niya ang nahibilin niini.” ");
INSERT INTO cebocb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Mao kini sila ang 12 ka anak ni Jacob nga kagikan sa mga tribo sa Israel. Ug mao kadto ang gisulti ni Jacob sa matag-usa kanila sa dihang gipanalanginan niya sila. Gipanalanginan niya sila sa panalangin nga angay kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Unya miingon si Jacob sa iyang mga anak, “Hapit na akong makig-uban sa akong kaparyentehan nga nangamatay na. Ilubong unya ninyo ako didto sa lubnganan sa akong mga katigulangan didto sa langub nga atua sa uma ni Efron nga Hitihanon. ");
INSERT INTO cebocb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ang maong uma atua nahimutang sa Macpela, sa sidlakang bahin sa Mamre, nga sakop sa Canaan. Gipalit sa akong lolo nga si Abraham kadtong maong uma kang Efron nga Hitihanon aron himuon nga lubnganan. ");
INSERT INTO cebocb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Didto siya gilubong, apil ang akong lola nga si Sara ug ang akong mga ginikanan nga si Isaac ug si Rebeka, ug didto ko usab gilubong si Lea. ");
INSERT INTO cebocb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kini nga uma ug ang langub nga anaa niini gipalit gikan sa mga Hitihanon.” ");
INSERT INTO cebocb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Human makigsulti si Jacob sa iyang mga anak, mihigda siya ug namatay. Ug nakig-uban siya sa iyang kaparyentehan nga nangamatay na. ");
INSERT INTO cebocb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Naghilak nga migakos ug mihalok si Jose sa iyang amahan. ");
INSERT INTO cebocb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Unya gisugo niya ang iyang mga embalsamador nga balsamaron ang iyang amahan, ug gituman nila kini. ");
INSERT INTO cebocb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Milungtad ug 40 ka adlaw ang pag-embalsamar, sumala sa naandang buhaton sa mga taga-Ehipto. Nagbangotan ang mga Ehiptohanon alang kang Jacob sulod sa 70 ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sa nahuman na ang mga adlaw sa ilang pagbangotan, miingon si Jose sa mga opisyal sa hari sa Ehipto, “Kon mahimo sultihi ninyo ang hari ");
INSERT INTO cebocb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","nga tugotan niya ako nga didto ko ilubong sa Canaan ang akong amahan. Kay sa wala pa siya mamatay, gipapanumpa niya ako nga ilubong ko siya sa lubnganan nga iyang gipahimo alang sa iyang kaugalingon didto sa Canaan. Human sa lubong, mobalik ako.” ");
INSERT INTO cebocb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Misugot ang hari sa hangyo ni Jose, “Lakaw ug ilubong ang imong amahan sumala sa imong gisaad kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Busa milakaw si Jose sa paglubong sa iyang amahan. Miuban kaniya ang daghang mga opisyal sa hari: ang mga kadagkoan sa palasyo ug ang tanang kadagkoan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Miuban usab ang panimalay ni Jose ug ang panimalay sa iyang mga igsoon, ang tibuok panimalay ni Jacob. Ang ilang gagmayng kabataan ug mga kahayopan lang ang nahibilin sa Goshen. ");
INSERT INTO cebocb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Miuban usab kanila ang mga tawong nagkarwahi ug nagkabayo. Dako gayod kaayo kadto nga panon. ");
INSERT INTO cebocb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pag-abot nila sa giokanan sa Atad, tabok sa Suba sa Jordan, nagbangotan sila didto alang amahan in Jose ug nagminatay sila sa paghilak. Nagsubo si Jose alang sa iyang amahan sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Pagkakita sa mga Canaanhon sa ilang pagbangotan sa giokanan sa Atad, miingon sila, “Labihan gayod ang pagsubo sa mga Ehiptohanon.” Busa kadtong lugara nga duol sa Suba sa Jordan gitawag ug Abel Mizraim. ");
INSERT INTO cebocb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Gituman sa mga anak ni Jacob ang iyang gitugon kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kay gidala nila ang iyang patayng lawas ngadto sa Canaan ug gilubong sa langub nga atua sa uma sa Macpela, sa sidlakang bahin sa Mamre. Kining maong uma gipalit ni Abraham gikan kang Efron nga Hitihanon aron himuon nga lubnganan. ");
INSERT INTO cebocb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Human sa lubong, mibalik si Jose didto sa Ehipto uban sa iyang mga igsoon ug sa tanan nga miuban kanila sa paglubong. ");
INSERT INTO cebocb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Sa wala na ang ilang amahan, miingon ang mga igsoon ni Jose, “Tingali baya, kon nagdumot si Jose kanato, panimaslan gayod niya kita sa tanan natong gibuhat kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Busa nagpadala sila ug mensahe ngadto kang Jose nga nag-ingon, “Nagtugon ang atong amahan sa wala pa siya mamatay ");
INSERT INTO cebocb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","nga sultihan ka nga naghangyo siya nga pasayloon mo kami sa among daotang gibuhat kanimo. Busa karon, hinaut nga pasayloon mo kami kay sama kanimo, nagtuman usab kami sa Dios sa atong amahan.” Mihilak si Jose sa dihang nadungog niya ang ilang mensahe. ");
INSERT INTO cebocb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Unya, nangadto mismo ang iyang mga igsoon kaniya. Pag-abot nila, miyukbo sila sa iyang atubangan agig pagtahod kaniya ug miingon, “Imo kaming mga ulipon.” ");
INSERT INTO cebocb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Apan mitubag si Jose kanila, “Ayaw kamo kahadlok. Ngano, Dios ba ako? ");
INSERT INTO cebocb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tinuod nga nagtinguha kamo ug daotan batok kanako, apan giplano sa Dios nga mosangpot kadto sa kaayohan aron maluwas ang daghang mga tawo gikan sa kagutom, sama sa nahitabo karon. ");
INSERT INTO cebocb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Busa ayaw kamo kahadlok. Sustentohan ko kamo ug ang inyong mga anak.” Niining paagiha, gihupay ni Jose ang ilang kabalaka ug nakahatag kini ug kalipay kanila. ");
INSERT INTO cebocb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nagpabilin pagpuyo si Jose sa Ehipto uban ang tibuok nga panimalay sa iyang amahan. Nagkinabuhi siya ug 110 ka tuig, ");
INSERT INTO cebocb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ug iya pang nakita ang iyang mga apo sa tuhod sa iyang anak nga si Efraim ug sa iyang apo nga si Makir nga anak ni Manases. Giila niya nga iyang kaugalingong anak ang mga anak ni Makir. ");
INSERT INTO cebocb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Unya, miingon si Jose sa iyang mga igsoon, “Hapit na ako mamatay, apan dili gayod kamo pasagdan sa Dios. Kuhaon niya kamo gikan niini nga yuta ug dad-on sa dapit nga iyang gisaad kang Abraham, Isaac, ug Jacob.” ");
INSERT INTO cebocb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Unya gipapanumpa ni Jose ang mga Israelinhon. Miingon siya, “Isaad ninyo nga kon pabiyaon na kamo sa Dios dinhi, dad-on ninyo ang akong mga bukog gikan dinhi.” ");
INSERT INTO cebocb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Namatay si Jose didto sa Ehipto sa edad nga 110 ka tuig. Gibalsamar siya ug gisulod sa lungon.");
INSERT INTO cebocb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Mao kini ang mga anak nga lalaki ni Jacob nga miuban kaniya sa Ehipto, uban ang ilang mga pamilya: ");
INSERT INTO cebocb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Si Ruben, Simeon, Levi, Juda, ");
INSERT INTO cebocb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulon, Benjamin, ");
INSERT INTO cebocb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftali, Gad, ug Aser. ");
INSERT INTO cebocb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Si Jose didto nang daan sa Ehipto. Ang kaliwat ni Jacob sa dihang miadto siya sa Ehipto 70 tanan. ");
INSERT INTO cebocb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Sa paglabay sa panahon, namatay si Jose ug ang tanan niyang mga igsoon. Milabay ang ilang henerasyon, ");
INSERT INTO cebocb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","apan paspas kaayo nga midaghan ang kaliwat sa mga Israelinhon. Busa nalukop ang Ehipto sa ilang kadaghan. ");
INSERT INTO cebocb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Unya adunay bag-ong hari ang Ehipto nga walay nasayran bahin kang Jose. ");
INSERT INTO cebocb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Miingon siya sa iyang katawhan, “Tan-awa ninyo! Ang mga Israelinhon daghan na kaayo kay kanato. ");
INSERT INTO cebocb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mangita kitag maayong paagi nga dili na sila modaghan pa. Kay basin unya sa panahon sa gira modapig sila sa atong mga kaaway ug makigkontra kanato, ug unya mobiya sila gikan sa atong nasod.” ");
INSERT INTO cebocb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Busa gipadumalahan nila ang mga Israelinhon sa mga tawo nga molisod-lisod ug mopugos kanila sa pagtrabaho ug bug-at. Gipatrabaho kanila ang mga lungsod sa Pitom ug Rameses aron mahimong bodega sa pagkaon sa hari sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Apan bisan gilutos sila pag-ayo, misamot hinuon sila kadaghan, ug mikatag pag-ayo sa Ehipto. Busa nahadlok na ang mga Ehiptohanon kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Tungod niini, gidugangan pa gayod nila ang ilang kabangis ngadto sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wala gayod silay kaluoy sa mga Israelinhon. Gilisod-lisod gayod nila sila pinaagi sa pagpahimo kanila ug mga tisa ug pangpilit niini. Gipatrabaho pa gayod nila sila ug grabe sa uma. ");
INSERT INTO cebocb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Unya miingon ang hari sa Ehipto ngadto kanila ni Shefra ug Pua nga mga Hebreohanong mananabang, ");
INSERT INTO cebocb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Kon magpaanak kamo sa mga babayeng Hebreohanon, patya ninyo kon ang bata lalaki apan kon babaye, pasagdi lang ninyo nga mabuhi.” ");
INSERT INTO cebocb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Apan nahadlok sa Dios ang mga mananabang, busa wala nila tumana ang giingon sa hari sa Ehipto. Gipasagdan nila nga mabuhi ang mga batang lalaki. ");
INSERT INTO cebocb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Busa gipatawag sa hari sa Ehipto ang mga mananabang ug gipangutana, “Nganong gihimo ninyo kini? Nganong gipasagdan ninyo nga mabuhi ang mga batang lalaki?” ");
INSERT INTO cebocb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mitubag ang mga mananabang, “Ang mga Hebreohanon nga babaye dili pareho sa mga Ehiptohanon nga babaye; dali ra silang manganak bisan dili pa makaabot ang mananabang.” ");
INSERT INTO cebocb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Busa gipanalanginan sa Dios ang mga mananabang, ug midaghan pa gayod ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ug tungod kay mitahod sa Dios ang mga mananabang, gihatagan sila sa Dios ug ilang kaugalingong pamilya. ");
INSERT INTO cebocb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Unya nagmando ang hari sa Ehipto sa tanan niyang katawhan, “Ilabay ninyo sa Suba sa Nilo ang tanang batang lalaki sa mga Israelinhon nga bag-ong natawo, apan pasagdi lang nga mabuhi ang mga batang babaye.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Adunay usa ka tawo nga kaliwat ni Levi nga nakapangasawa ug usa ka babaye nga kaliwat ra usab ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Namabdos ang maong babaye ug nanganak ug batang lalaki. Sa dihang nakita niya nga maayog panglawas ang bata, gitagoan niya kini sulod sa tulo ka bulan. ");
INSERT INTO cebocb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Apan sa dihang dili na niya matago ang bata, nagkuha siyag basket nga hinimo sa tanom nga pafiros ug gibulitan niya kinig alkitran aron dili masudlan ug tubig. Unya gisulod niya ang bata sa basket ug gibutang kini sa may kasagbotan sa daplin sa Suba sa Nilo. ");
INSERT INTO cebocb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ang igsoong babaye sa bata mitindog sa unahan aron sa pagtan-aw kon unsay mahitabo sa bata. ");
INSERT INTO cebocb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Niadtong higayona, miadto sa Suba sa Nilo ang anak nga babaye sa hari sa Ehipto aron maligo. Ug samtang naligo siya, ang iyang mga sulugoong babaye naglakaw-lakaw sa daplin sa suba. Unya, nakita niya ang basket diha sa kasagbotan. Gipakuha niya kini sa usa sa iyang mga sulugoon. ");
INSERT INTO cebocb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Sa pag-abli niya sa basket, nakita niya ang bata nga gahilak. Naluoy kaayo siya sa bata ug miingon, “Usa kini sa mga batang Hebreohanon.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Unya miduol ang igsoong babaye sa bata ngadto sa prinsesa ug nangutana, “Gusto ka ba nga kuhaan ka nako ug usa ka Hebreohanon nga babaye nga mopasuso ug moatiman sa bata alang kanimo?” ");
INSERT INTO cebocb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mitubag ang prinsesa, “Sige.” Busa milakaw ang igsoon sa bata ug giadtoan niya ang ilang inahan ug gikuyogan ngadto sa prinsesa. ");
INSERT INTO cebocb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Miingon ang prinsesa sa inahan sa bata, “Dad-a kining bata, ug pasusoha alang kanako. Atimana siya kay suholan ka nako.” Busa gikuha niya ang bata ug giatiman. ");
INSERT INTO cebocb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Sa dihang nalutas na ang bata, gidala kini sa iyang inahan ngadto sa prinsesa, ug giisip kini sa prinsesa nga iyang anak. Ginganlan sa prinsesa ang bata ug Moises, kay miingon siya, “Gikuha ko siya gikan sa tubig.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Usa ka adlaw, sa dihang dako na si Moises, miadto siya sa iyang mga kadugo ug nakita niya ang ilang grabe nga paghago. Nakita niya nga ginakulata sa usa ka Ehiptohanon ang usa ka Hebreohanon nga iyang kadugo. ");
INSERT INTO cebocb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Milingi-lingi si Moises sa palibot kon aduna bay nagtan-aw; ug sa dihang wala siyay nakita, gipatay niya ang Ehiptohanon ug gilubong kini sa balas. ");
INSERT INTO cebocb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Pagkasunod adlaw, misuroy na usab siya ug nakita niya nga adunay duha ka Hebreohanon nga nag-away. Gipangutana niya ang usa nga maoy sad-an, “Nganong ginakulata mo man ang imong isigka-Hebreohanon?” ");
INSERT INTO cebocb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mitubag ang tawo, “Kinsay naghimo kanimong pangulo ug maghuhukom kanamo? Patyon mo ba usab ako sama sa gihimo mo sa Ehiptohanon?” Nahadlok si Moises ug miingon sa iyang kaugalingon, “Nasayod diay ang mga tawo sa akong gihimo.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pagkahibalo sa hari sa Ehipto sa gihimo ni Moises, gipapangita niya si Moises aron patyon. Apan miikyas si Moises ngadto sa Midian aron didto mopuyo. Pag-abot niya sa Midian, milingkod siya duol sa atabay. ");
INSERT INTO cebocb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Naatol nga ang pito ka mga anak nga babaye sa pari sa Midian nagsag-ob aron paimnon ang kahayopan sa ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Adunay miabot usab didto nga mga magbalantay sa kahayopan ug gipapahawa ang mga babaye ug ang ilang kahayopan. Apan gitabangan ni Moises ang mga babaye ug gipainom niya ang ilang kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pag-uli sa mga babaye didto sa ilang amahan nga si Reuel, gipangutana niya sila, “Nganong sayo man kamo nakauli?” ");
INSERT INTO cebocb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Mitubag sila, “Adunay usa ka Ehiptohanon nga nanalipod kanamo batok sa mga magbalantay sa kahayopan. Gisag-oban pa gani niya kami, ug gipainom ang kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Nangutana ang ilang amahan, “Hain na man siya? Nganong gibiyaan man ninyo? Tawga siya aron makakaon.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Misugot si Moises nga didto mopuyo sa ila ni Reuel, ug unya, gipaasawa ni Reuel kaniya ang iyang anak nga si Zipora. ");
INSERT INTO cebocb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Namabdos si Zipora ug nanganak ug lalaki. Ginganlan kini ni Moises ug Gershom, kay ingon niya, “Usa ako ka langyaw niining dapita.” ");
INSERT INTO cebocb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Human sa daghang katuigan, namatay ang hari sa Ehipto. Apan nagpadayon pa gihapon ang pag-antos sa mga Israelinhon sa ilang pagkaulipon. Nangayo sila ug tabang, ug miabot kini sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nadungog sa Dios ang ilang mga pag-agulo, ug gihinumdoman niya ang iyang kasabotan kang Abraham, Isaac, ug kang Jacob. ");
INSERT INTO cebocb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nakita sa Dios ang ilang kahimtang ug naluoy gayod siya kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Usa ka adlaw, nagbantay si Moises sa kahayopan sa iyang ugangan nga si Jetro nga pari sa Midian. Gidala ni Moises ang kahayopan unahan sa kamingawan ug nakaabot siya sa Horeb, ang bukid sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nagpakita kaniya didto ang anghel sa Ginoo sa dagway sa nagdilaab nga kalayo diha sa sampinit. Nakita ni Moises nga nagdilaab ang sampinit apan wala kini masunog. ");
INSERT INTO cebocb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Miingon siya, “Katingalahan! Nganong wala man masunog kana nga sampinit? Ako ra gud duolon ug susihon.” ");
INSERT INTO cebocb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Pagkakita sa Ginoo nga miduol si Moises aron sa pagtan-aw, miingon Dios gikan sa taliwala sa tanom, “Moises, Moises!” Mitubag si Moises, “Unsa man.” ");
INSERT INTO cebocb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Miingon ang Dios, “Ayaw na pagduol pa. Huboa ang imong sandalyas, kay balaan ang dapit nga imong gitindogan. ");
INSERT INTO cebocb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ako ang Dios sa imong mga katigulangan, ang Dios ni Abraham, ang Dios ni Isaac, ug ang Dios ni Jacob.” Sa pagkadungog niini ni Moises, gitabonan niya ang iyang nawong, kay nahadlok siya nga motan-aw sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Unya miingon ang Ginoo, “Nakita ko gayod ang pag-antos sa akong katawhan didto sa Ehipto. Nadungog ko ang ilang pagpakitabang tungod sa mga tawo nga nagpugos kanila sa pagtrabaho ug bug-at, ug naluoy gayod ako kanila tungod sa ilang mga pag-antos. ");
INSERT INTO cebocb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Busa minaog ako sa pagluwas kanila gikan sa kamot sa mga Ehiptohanon, ug sa pagdala kanila ngadto sa maayo, lapad, ug mabungahon nga yuta, nga ginapuy-an karon sa mga Canaanhon, Hitihanon, Amorihanon, Perisihanon, Hibihanon, ug mga Jebusihanon. ");
INSERT INTO cebocb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nadungog ko ang pagpakitabang sa mga Israelinhon ug nakita ko kon giunsa sila paglutos sa mga Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Busa ipadala ka nako sa hari sa Ehipto sa pagpagawas sa akong katawhan nga mga Israelinhon gikan sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Apan miingon si Moises sa Dios, “Si kinsa man ko nga moadto sa hari ug mopagawas sa mga Israelinhon gikan sa Ehipto?” ");
INSERT INTO cebocb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Miingon ang Dios, “Mag-uban ako kanimo, ug mao kini ang mahimong timailhan nga ako ang nagpadala kanimo: Kon mapagawas mo na ang mga Israelinhon gikan sa Ehipto, magsimba kamo kanako dinhi niining bukira.” ");
INSERT INTO cebocb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Miingon si Moises sa Dios, “Pananglit moadto ako sa mga Israelinhon ug ingnon ko sila nga ang Dios sa ilang mga katigulangan nagpadala kanako sa pagluwas kanila, unya mangutana sila kanako, ‘Kinsay iyang ngalan?’ Unsa may akong itubag kanila?” ");
INSERT INTO cebocb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mitubag ang Dios kang Moises, “Ako ang Dios nga mao sa gihapon. Mao kini ang imong itubag kanila: ‘Ang Dios nga mao sa gihapon mao ang nagpadala kanako nganhi kaninyo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Miingon pa gayod ang Dios kang Moises, “Isulti kini sa mga Israelinhon: ‘Ang Ginoo, ang Dios sa inyong mga katigulangan nga si Abraham, Isaac, ug Jacob mao ang nagpadala kanako nganhi kaninyo.’ “Ginoo ang akong ngalan ug pagailhon ako sa mao nga ngalan hangtod sa hangtod. ");
INSERT INTO cebocb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Lakaw ug tigoma ang mga tigdumala sa Israel ug sultihi sila, ‘Ang Ginoo, nga Dios sa inyong mga katigulangan nga si Abraham, Isaac, ug Jacob nagpakita kanako, ug miingon: Gibantayan ko gayod kamo, ug nakita ko ang ginahimo sa mga Ehiptohanon kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nagsaad ako nga pagawason ko kamo gikan sa Ehipto diin nag-antos kamo, ug dalhon ngadto sa yuta nga maayo ug mabungahon, ang yuta nga gipuy-an sa mga Canaanhon, Hitihanon, Amorihanon, Perisihanon, Hibihanon, ug mga Jebusihanon.’ ");
INSERT INTO cebocb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Maminaw kanimo ang mga tigdumala sa Israel. Ug unya, ikaw ug ang mga tigdumala moadto sa hari sa Ehipto ug moingon kaniya, ‘Nagpakita kanamo ang Ginoo, nga Dios sa mga Hebreohanon. Busa kon mahimo tugoti kami sa paglakaw ug tulo ka adlaw ngadto sa kamingawan sa paghalad ngadto sa Ginoo nga among Dios.’ ");
INSERT INTO cebocb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Apan nasayod ako nga dili kamo tugotan sa hari sa Ehipto gawas lang kon adunay magpugos kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Busa silotan ko ang mga Ehiptohanon pinaagi sa mga milagro nga akong himuon taliwala kanila. Pagkahuman, tugotan na niya kamo sa paglakaw. ");
INSERT INTO cebocb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ug himuon ko nga maayo kaninyo ang mga Ehiptohanon, aron iniglakaw na ninyo pabalonan pa nila kamo. ");
INSERT INTO cebocb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ang matag babaye nga Israelinhon mangayo ug mga alahas nga plata ug bulawan ug mga bisti sa ilang silingan nga mga Ehiptohanon ug sa mga dumuduong didto sa Ehipto, ug ipasul-ob ninyo kini sa inyong mga anak. Niining paagiha, makuhaan ninyo ug mga kabtangan ang mga Ehiptohanon.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mitubag si Moises, “Apan basig dili motuo ang mga Israelinhon o maminaw sa akong isulti ug moingon sila nga, ‘Ang Ginoo wala magpakita kanimo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Miingon ang Ginoo kaniya, “Unsa kanang imong gigunitan?” Mitubag si Moises, “Baston.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Miingon ang Ginoo, “Iitsa kana sa yuta.” Busa giitsa ni Moises ang baston ug nahimo kining halas ug miatras si Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Miingon ang Ginoo kaniya, “Guniti ang halas sa ikog.” Busa gigunitan kini ni Moises ug nahimo na usab kini nga baston. ");
INSERT INTO cebocb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Miingon ang Ginoo, “Himoa kini nga milagro aron motuo sila nga ako, ang Ginoo, nga Dios sa ilang mga katigulangan nga si Abraham, Isaac, ug Jacob, nagpakita kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Unya miingon pag-usab ang Ginoo, “Ibutang ang imong kamot sa ilalom sa imong kupo.” Gituman kini ni Moises, ug sa dihang gipagawas niya ang iyang kamot, puti na kini kaayo kay gituboan kini ug ngilngig nga sakit sa panit. ");
INSERT INTO cebocb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Miingon ang Ginoo, “Ibutang pag-usab ang imong kamot ilalom sa imong kupo.” Gituman kini ni Moises, ug sa dihang gipagawas niya ang iyang kamot, naulian na kini ug sama na sa ubang bahin sa iyang lawas. ");
INSERT INTO cebocb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Unya miingon ang Ginoo, “Kon dili sila motuo sa unang milagro, motuo na sila sa ikaduha. ");
INSERT INTO cebocb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Apan kon dili pa gayod sila motuo kanimo human niining duha ka milagro, pagkuha ug tubig sa Suba sa Nilo ug ibubo kini sa malang yuta, ug mahimo kining dugo.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Miingon si Moises sa Ginoo, “Ginoo, dili ako maayong manulti sukad pa kaniadto, ug bisan karon nga nakigsulti ka kanako nga imong sulugoon. Hinay gayod ako sa panulti.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Miingon ang Ginoo kaniya, “Kinsay naghimo sa baba sa tawo? Kinsay naghimo kaniyang bungol o amang? Kinsay nagbuot nga makakita siya o mabuta? Dili ba ako, ang Ginoo? ");
INSERT INTO cebocb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Busa lakaw, kay tabangan ka nako sa pagsulti ug tudloan ka nako kon unsay imong isulti.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Apan miingon si Moises, “O Ginoo, kon mahimo lain na lay ipadala.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Nasuko ang Ginoo kang Moises, ug miingon siya, “Si Aaron na lang nga imong igsoon, nga usa usab ka Levita. Nasayod ako nga maayo siya manulti. Nagpaingon na siya dinhi sa pagpakigkita kanimo. Malipay gayod siya kon makita ka niya. ");
INSERT INTO cebocb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Pakigsultihi siya, ug tudloi kon unsay iyang isulti. Tabangan ko kamong duha sa pagsulti, ug tudloan ko usab kamo sa inyong himuon. ");
INSERT INTO cebocb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Si Aaron ang mosulti sa mga tawo alang kanimo. Tudloan mo siya kon unsay iyang isulti, nga daw ikaw ang Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ug dad-a ang imong baston aron makahimo ka ug mga milagro pinaagi niana.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mibalik si Moises kang Jetro nga iyang ugangan ug miingon kaniya, “Tugoti ako nga mobalik sa akong mga kadugo didto sa Ehipto sa pagtan-aw kon buhi pa ba sila.” Miingon si Jetro, “Sige, ug maayong paglakaw.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Sa wala pa mogikan si Moises sa Midian miingon ang Ginoo kaniya, “Sige, balik na sa Ehipto kay nangamatay na ang tanang gustong mopatay kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Busa gikuha ni Moises ang iyang asawa ug mga anak nga lalaki ug gipasakay sa asno ug mibalik sa Ehipto. Gidala usab niya ang baston nga gisugo sa Dios nga iyang dal-on. ");
INSERT INTO cebocb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Miingon ang Ginoo kang Moises, “Pag-abot mo sa Ehipto, buhata gayod atubangan sa hari sa Ehipto ang tanang milagro nga gipakita ko kanimo. Gihatagan ka nako ug gahom sa paghimo niana. Apan pagahion ko ang kasing-kasing sa hari aron dili niya tugotan nga mobiya ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Unya ingnon mo siya, ‘Mao kini ang giingon sa Ginoo: Giisip ko ang Israel nga akong kamagulangang anak nga lalaki, ");
INSERT INTO cebocb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","busa gimandoan ka nako nga palakwon mo siya aron makasimba siya kanako, apan wala ka mosugot. Busa patyon ko ang kamagulangan mong anak nga lalaki!’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Sa pagpanglakaw nilang Moises ug sa iyang pamilya, namahulay sila sa usa ka pahulayanan. Giadtoan sa Ginoo si Moises didto aron unta patyon. ");
INSERT INTO cebocb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Apan nagkuha si Zipora ug hait nga bato ug gituli niya ang iyang anak, ug ang panit sa kinatawo nga iyang nakuha gitapion niya sa kinatawo ni Moises. Unya miingon si Zipora, “Ikaw usa ka nagkadugo nga bana kanako.” (Ang gipamulong ni Zipora adunay kalabotan sa pagtuli.) Busa wala patya sa Ginoo si Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Unya, miingon ang Ginoo kang Aaron, “Lakaw ug tagboa si Moises sa kamingawan.” Busa gitagbo niya si Moises sa Bukid sa Dios ug gihagkan agig paghangop. ");
INSERT INTO cebocb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Gisultihan dayon ni Moises si Aaron sa tanan nga gisugo sa Ginoo nga isulti niya ug sa tanang milagro nga gisugo sa Ginoo nga himuon niya. ");
INSERT INTO cebocb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Busa milakaw silang duha, ug gitigom nila ang tanang mga tigdumala sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Gisultihan sila ni Aaron sa tanan nga giingon sa Ginoo kang Moises. Ug gihimo ni Moises ang mga milagro atubangan sa mga tawo, ");
INSERT INTO cebocb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ug mituo sila. Ug sa dihang nahibaloan nila nga nahangawa ang Ginoo kanila ug nga nakita niya ang ilang pag-antos, mihapa sila ug misimba kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Unya, miadto si Moises ug si Aaron sa hari sa Ehipto ug miingon, “Mao kini ang giingon sa Ginoo, ang Dios sa Israel: ‘Palakwa ang akong katawhan aron makasaulog sila ug pista alang kanako didto sa kamingawan.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Miingon ang hari, “Kinsa ba nang Ginoo nga motuo man ako kaniya ug motugot ako nga palakwon ang mga Israelinhon? Wala ako makaila niana nga Ginoo ug dili ko usab tugotan ang mga Israelinhon sa paglakaw.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mitubag si Moises ug Aaron, “Nagpakita kanamo ang Dios sa mga Israelinhon. Busa kon mahimo tugoti kami sa paglakaw ug tulo ka adlaw didto sa kamingawan aron makahalad kami ug mga halad sa Ginoo nga among Dios, kay kon dili, pamatyon niya kami pinaagi sa balatian o sa gira.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Apan mitubag ang hari sa Ehipto, “Nganong paundangon man ninyo ang mga tawo sa ilang pagtrabaho? Balik na kamo sa inyong mga trabaho! ");
INSERT INTO cebocb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tan-awa ra gud kon unsa kadaghan sa mga tawo nga pahunongon ninyo sa pagtrabaho.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Niana gihapong adlawa, gimandoan sa hari ang mga nagpugos sa mga Israelinhon sa pagtrabaho ug bug-at ug ang mga porman: ");
INSERT INTO cebocb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ayaw na ninyo hatagi ang mga trabahante ug mga dagami nga gamiton nila sa paghimog tisa. Sila na mismo ang pakuhaa niini. ");
INSERT INTO cebocb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Apan kinahanglan mao lang gihapon kadaghan nga tisa ang ilang himuon. Mga tapolan sila, mao kana nga naghangyo sila nga tugotan ko nga molakaw aron maghalad sa ilang Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Patrabahoa sila pag-ayo aron magkapuliki sila ug dili na magpunay ug pamati sa mga bakak nga istorya.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Busa nangadto sila sa mga Israelinhon ug miingon, “Nagsugo ang hari nga dili na namo kamo hatagag dagami. ");
INSERT INTO cebocb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kamo na ang mangita niini bisan asa, apan mao ra gihapon kadaghan ang tisa nga inyong himuon.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Busa nagkadiin-diin na lang ang mga Israelinhon sa tibuok Ehipto sa pagpanguha ug dagami. ");
INSERT INTO cebocb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Giapora sila sa mga nagpugos kanila nga nag-ingon, “Himoa ninyo ang mao gihapong gidaghanon sa tisa matag adlaw sama niadtong gihatagan pa kamo ug dagami.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Unya gikastigo nila ang mga porman nga Israelinhon ug gipangutana, “Nganong wala man ninyo mahimo gahapon ug karon ang gidaghanon sa tisa nga kinahanglan inyong himuon, sama sa gidaghanon kaniadto?” ");
INSERT INTO cebocb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Busa miadto dayon sa hari ang mga porman nga Israelinhon ug mireklamo, “Nganong ingon man niini ang imong pagtratar kanamo nga imong mga sulugoon? ");
INSERT INTO cebocb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wala na kami hatagi ug dagami, apan ginapugos kami nga maghimo sa mao ra gihapong gidaghanon sa tisa, ug gikastigo pa kami. Sala kini sa imong mga tawo!” ");
INSERT INTO cebocb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Miingon ang hari, “Labihan kamo katapolan! Mao nga naghangyo kamo nga tugotan ko kamo nga molakaw aron maghalad sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Balik kamo sa inyong mga trabaho! Dili kamo hatagan ug dagami, apan mao ra gihapon ang gidaghanon sa tisa nga inyong himuon.” ");
INSERT INTO cebocb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Tungod kay miinsister man ang hari nga himuon gayod nila ang gidaghanon sa tisa nga gipahimo kanila kada adlaw, nakita sa mga porman nga Israelinhon nga maglisod gayod sila. ");
INSERT INTO cebocb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Sa dihang nakabiya na sila sa hari, nakita nila si Moises ug si Aaron nga naghulat kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Miingon sila kang Moises ug kang Aaron, “Hinaut unta nga silotan kamo sa Ginoo, kay tungod kaninyo nasuko kanamo ang hari ug ang iyang mga opisyal. Tungod sa inyong gihimo nakakita silag hinungdan sa pagpatay kanamo!” ");
INSERT INTO cebocb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Midangop pag-usab si Moises sa Ginoo ug miingon, “O Ginoo, nganong gipaantos mo man ang imong katawhan? Nganong gipadala mo pa ako kanila? ");
INSERT INTO cebocb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sukad sa pagsulti ko sa hari sa imong mensahe, mas gipaantos pa gayod niya ang imong katawhan, ug wala mo gayod sila luwasa!” ");
INSERT INTO cebocb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Miingon ang Ginoo kang Moises, “Karon makita mo kon unsa ang himuon ko sa hari sa Ehipto. Pinaagi sa akong gahom, tugotan niya nga mobiya kamo sa iyang nasod. Mapugos siya sa pagpapahawa kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Miingon pa gayod ang Dios kang Moises, “Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagpakita ako kang Abraham, kang Isaac, ug kang Jacob ingon nga Makagagahom nga Dios, apan wala ko ipadayag ngadto kanila ang akong ngalan nga Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Naghimo ako ug kasabotan uban kanila, nga ihatag ko kanila ang yuta sa Canaan diin sila nagpuyo ingon nga mga dumuduong. ");
INSERT INTO cebocb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nadungog ko ang pag-agulo sa mga Israelinhon nga giulipon sa mga Ehiptohanon, ug gihinumdoman ko ang akong kasabotan kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Busa ingna ang mga Israelinhon: ‘Ako mao ang Ginoo. Haw-ason ko kamo sa pagkaulipon sa Ehipto. Pinaagi sa akong gahom, ipahamtang ko sa mga Ehiptohanon ang labihan nga silot, ug luwason ko kamo. ");
INSERT INTO cebocb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Isipon ko kamo nga akong katawhan ug ako mahimong inyong Dios. Unya mahibaloan ninyo nga ako mao ang Ginoo nga inyong Dios nga naghaw-as kaninyo gikan sa pagkaulipon sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Dad-on ko kamo sa yuta nga akong gisaad nga ihatag kang Abraham, Isaac, ug Jacob. Ihatag ko kini kaninyo ug inyo kining panag-iyahon. Ako mao ang Ginoo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Gisulti kini ni Moises sa mga Israelinhon, apan wala sila motuo kaniya kay nawad-an na silag paglaom tungod sa hilabihan nilang pag-antos ingon nga mga ulipon. ");
INSERT INTO cebocb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Unya miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lakaw, ug ingna ang Paraon nga hari sa Ehipto nga pabiyaon na niya ang mga Israelinhon sa iyang nasod.” ");
INSERT INTO cebocb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Apan miingon si Moises sa Ginoo, “Kon ang mga Israelinhon wala gani maminaw kanako, ang hari pa kaha? Labi na kay dili ako maayong manulti!” ");
INSERT INTO cebocb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Apan miingon ang Ginoo kang Moises ug kang Aaron nga sultihan ang mga Israelinhon ug ang Paraon nga hari sa Ehipto nga gisugo ko kamo sa pagpagawas sa mga Israelinhon gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Mao kini ang mga katigulangan nga lalaki sa mga panimalay nga kagikan sa mga tribo sa Israel: Ang mga anak sa kamagulangang anak ni Israel nga si Ruben mao sila si Hanoc, Palu, Hezron, ug Carmi. ");
INSERT INTO cebocb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ang mga anak ni Simeon mao sila si Jemuel, Jamin, Ohad, Jakin, Zohar, ug Saulo. (Kini si Saulo anak ni Simeon sa Canaanhon nga babaye.) ");
INSERT INTO cebocb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ang mga anak ni Levi sumala sa listahan sa iyang mga kaliwat mao sila si Gershon, Kohat, ug Merari. (Nagkinabuhi si Levi ug 137 ka tuig.) ");
INSERT INTO cebocb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ang mga anak ni Gershon mao si Libni ug si Shimei. ");
INSERT INTO cebocb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ang mga anak ni Kohat mao sila si Amram, Izhar, Hebron, ug Uziel. (Nagkinabuhi si Kohat ug 133 ka tuig.) ");
INSERT INTO cebocb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ang mga anak ni Merari mao sila si Mali ug si Mushi. ");
INSERT INTO cebocb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Gipangasawa ni Amram si Jokebed nga igsoon sa iyang amahan. Ug ang ilang mga anak nga lalaki mao si Aaron ug si Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ang mga anak ni Izhar mao sila si Kora, Nefeg, ug Zicri. ");
INSERT INTO cebocb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ang mga anak ni Uziel mao sila si Mishael, Elzafan, ug Sitri. ");
INSERT INTO cebocb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Gipangasawa ni Aaron si Elisheba, nga anak ni Aminadab ug igsoon ni Nashon. Ang ilang mga anak mao sila si Nadab, Abihu, Eleazar, ug Itamar. ");
INSERT INTO cebocb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ang mga anak ni Kora mao sila si Asir, Elkana, ug Abiasaf. ");
INSERT INTO cebocb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleazar nga anak ni Aaron naminyo sa usa sa mga anak ni Putiel. Ang ilang anak nga lalaki mao si Pinehas. ");
INSERT INTO cebocb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ang Aaron ug Moises nga gihisgotan dinhi mao gihapon kadtong gisugo sa Ginoo sa pagpagawas sa mga tribo sa Israel gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Sila ang nakigsulti sa Paraon nga hari sa Ehipto bahin sa pagpagawas sa mga Israelinhon gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Sa dihang nakigsulti ang Ginoo kang Moises kaniadto sa Ehipto, ");
INSERT INTO cebocb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","miingon siya, “Ako mao ang Ginoo. Sultihi ang Paraon nga hari sa Ehipto sa tanan nga giingon ko kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Apan miingon si Moises sa Ginoo, “Dili ako maayong manulti, busa dili maminaw ang hari kanako.” ");
INSERT INTO cebocb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Miingon ang Ginoo kang Moises, “Paminaw! Himuon ka nako nga daw usa ka dios ngadto sa hari sa Ehipto. Makigsulti ka kaniya pinaagi kang Aaron nga imong igsoon. ");
INSERT INTO cebocb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Sultihi si Aaron sa tanan nga isulti ko kanimo, ug ipasulti kini kaniya ngadto sa hari. Ingnon niya ang hari nga pagawason ang mga Israelinhon sa iyang nasod. ");
INSERT INTO cebocb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Apan pagahion ko ang kasing-kasing sa hari, ug bisan pag maghimo akog daghang mga milagro ug kahibulongang mga butang sa Ehipto, ");
INSERT INTO cebocb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","dili siya maminaw kaninyo. Unya ipahamtang ko ang labihan nga silot ngadto sa Ehipto ug pagawason ko ang mga tribo sa Israel nga akong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kon masilotan ko na ang Ehipto ug mapagawas ang mga Israelinhon gikan sa ilang nasod, mahibaloan sa mga Ehiptohanon nga ako mao ang Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Gituman ni Moises ug Aaron ang gisugo sa Ginoo kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Nag-edad si Moises ug 80 ka tuig ug si Aaron 83 sa dihang nakigsulti sila sa hari sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kon moingon ang hari nga pamatud-i ninyo pinaagi sa paghimo ug milagro, ikaw Moises moingon kang Aaron, ‘Iitsa ang imong baston atubangan sa hari! Ug mahimo kini nga halas.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Busa miadto si Moises ug si Aaron sa hari ug gihimo nila ang giingon sa Ginoo. Giitsa ni Aaron ang iyang baston atubangan sa hari ug sa iyang mga opisyal, ug nahimo kining halas. ");
INSERT INTO cebocb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Gipatawag dayon sa hari ang iyang maalam nga mga tawo ug mga madyikero ug pinaagi sa ilang mga madyik, nahimo usab nila ang sama niadto nga milagro. ");
INSERT INTO cebocb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ang kada usa kanila miitsa sa ilang baston ug nahimo usab kini nga mga halas. Apan gitukob sa halas ni Aaron ang ilang mga halas. ");
INSERT INTO cebocb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Apan gahi gihapon ang kasing-kasing sa hari, ug wala maminaw kang Moises ug kang Aaron, sumala sa giingon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Miingon ang Ginoo kang Moises, “Gahi kaayo ug kasing-kasing ang hari; dili niya palakwon ang katawhan sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Busa adtoa ang hari ugma sa buntag inig-adto niya sa Suba sa Nilo. Dad-a ang imong baston nga nahimong halas ug paghulat kaniya sa daplin sa suba. ");
INSERT INTO cebocb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ingna siya, ‘Ang Ginoo, nga Dios sa mga Hebreo, nagsugo kanako sa pag-ingon niini kanimo: Palakwa ang akong katawhan aron makasimba sila kanako didto sa kamingawan. Apan hangtod karon wala ka gayod motuman. ");
INSERT INTO cebocb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Mao kini ang giingon sa Ginoo: Pinaagi sa akong himoon mahibaloan mo nga ako mao ang Ginoo.’ Busa tan-awa! Pinaagi niining baston hapakon ko ang tubig sa Nilo ug mahimong dugo ang tubig. ");
INSERT INTO cebocb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mangamatay ang mga isda ug mabaho ang suba, ug dili na makainom ang mga Ehiptohanon sa tubig niini.” ");
INSERT INTO cebocb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Miingon pa gayod ang Ginoo kang Moises, “Ingna si Aaron nga kuhaon ang iyang baston ug ipunting ngadto sa mga katubigan sa Ehipto: sa mga suba, sapa, kanal, ug sa tanang pundohanan ug tubig, ug mahimo kining tanan nga dugo. Mao kini ang mahitabo sa tibuok Ehipto. Apil ang tubig sa mga sudlanan nga kahoy ug bato mahimo usab nga dugo.” ");
INSERT INTO cebocb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Gituman ni Moises ug ni Aaron ang gisugo sa Ginoo. Samtang nagtan-aw ang hari ug ang iyang mga opisyal, gibayaw ni Aaron ang iyang baston ug gihapak sa Suba sa Nilo, ug ang tubig niini nahimong dugo. ");
INSERT INTO cebocb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nangamatay ang mga isda ug nanimaho pag-ayo ang suba, busa dili na makainom ang mga Ehiptohanon. Bisan asa sa Ehipto adunay dugo. ");
INSERT INTO cebocb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kini nga milagro gihimo usab sa mga madyikero nga Ehiptohanon pinaagi sa ilang madyik. Busa nagmagahi gihapon ang hari, ug wala siya naminaw kang Moises ug kang Aaron, sumala sa giingon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mibalik ang hari sa iyang palasyo, ug wala lang niya kadto tagda. ");
INSERT INTO cebocb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nagbangag ang mga Ehiptohanon libot sa Suba sa Nilo aron makakuhag ilimnong tubig, kay dili na nila mainom ang tubig sa suba. ");
INSERT INTO cebocb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Milabay ang pito ka adlaw human hapaka sa Ginoo ang Suba sa Nilo. ");
INSERT INTO cebocb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Unya miingon ang Ginoo kang Moises, “Adtoa ang hari sa Ehipto ug ingna siya, ‘Mao kini ang giingon sa Ginoo: Palakwa ang akong katawhan aron makasimba sila kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kon dili mo gani sila palakwon, padagsangon ko ang mga baki sa tibuok mo nga nasod. ");
INSERT INTO cebocb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapuno ug baki ang Suba sa Nilo ug manulod kini sa imong palasyo, sa imong kuwarto, ug diha mismo sa imong higdaanan. Manulod usab sila sa mga balay sa imong mga opisyal ug sa imong katawhan, ug ngadto sa mga abuhan ug sa masahanan sa harina. ");
INSERT INTO cebocb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Manglukso ang mga baki diha kanimo, sa imong katawhan, ug sa tanan mong opisyal.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Miingon pa gayod ang Ginoo kang Moises, “Ingna si Aaron nga ipunting niya ang iyang baston ngadto sa mga suba, sapa, kanal, ug sa mga pundohanan ug tubig, ug manungha ang mga baki sa tibuok Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Busa gipunting ni Aaron ang iyang baston ngadto sa mga katubigan sa Ehipto, ug nanungha ang mga baki ug milukop kini sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Apan gihimo usab kining maong milagro sa mga madyikero pinaagi sa ilang mga madyik. Napatungha usab nila ang mga baki sa yuta sa Ehipto gikan sa mga katubigan. ");
INSERT INTO cebocb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Gipatawag sa hari si Moises ug si Aaron ug giingnan, “Pag-ampo kamo sa Ginoo nga kuhaon niya ang mga baki kanako ug sa akong katawhan, ug palakwon ko ang inyong katagilungsod sa paghalad ngadto sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Miingon si Moises sa hari, “Ingna lang ako kon kanus-a ako mag-ampo alang kanimo, sa imong mga opisyal, ug sa imong mga katawhan, aron mahanaw kanang mga baki kaninyo ug sa inyong mga balay. Ang anaa sa Suba sa Nilo mao lang ang mahibilin.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mitubag ang hari, “Ugma, pag-ampo alang kanako.” Miingon si Moises, “Matuman kana sumala sa imong giingon, aron mahibaloan mo nga walay sama sa Ginoo nga among Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mahanaw ang tanang baki diha kaninyo; ang anaa sa Suba sa Nilo mao lang ang mahibilin.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Human makabiya si Moises ug si Aaron gikan sa hari, nag-ampo si Moises sa Ginoo nga kuhaon ang mga baki nga iyang gipadala. ");
INSERT INTO cebocb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Gituman sa Ginoo ang gihangyo ni Moises. Nangamatay ang mga baki nga anaa sa mga kabalayan, sa mga tugkaran, ug sa mga kaumahan. ");
INSERT INTO cebocb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gitigom kini sa mga Ehiptohanon; nagbungtod ang ilang mga tinapok ug nanimaho ang tibuok yuta sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Apan pagkakita sa hari nga wala na ang mga baki, nagmagahi na usab siya ug wala siya maminaw kang Moises ug kang Aaron, sumala sa giingon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Miingon ang Ginoo kang Moises, “Ingna si Aaron nga ihapak niya ang iyang baston sa yuta, ug mahimong mga lamok ang abog sa tibuok yuta sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Gituman nila kini, ug sa dihang gihapak ni Aaron sa iyang baston ang yuta, nahimong mga lamok ang abog sa tibuok yuta sa Ehipto. Ug midagsang ang mga lamok ngadto sa mga tawo ug sa mga mananap. ");
INSERT INTO cebocb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Misulay ang mga madyikero sa paghimo ug sama niini pinaagi sa ilang mga madyik, apan wala nila kini mahimo. Padayon nga midagsang ang mga lamok sa mga tawo ug sa mga mananap. ");
INSERT INTO cebocb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Miingon ang mga madyikero sa hari, “Buhat kini sa Dios!” Apan gahi gihapon ug kasing-kasing ang hari, ug wala gayod siya maminaw kang Moises ug kang Aaron, sumala sa giingon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Miingon ang Ginoo kang Moises, “Sayo ug bangon ugma ug adtoa ang hari samtang nagpaingon siya sa suba. Ingna siya nga mao kini ang akong giingon: ‘Palakwa ang akong katawhan aron makasimba sila kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kon dili mo gani sila palakwon, magpadala ako ug daghang mga langaw nganha kanimo, sa imong mga alagad ug sa imong katawhan ug mga balay. Mapuno sa mga langaw ang inyong mga balay ug ang yuta malukop niini. ");
INSERT INTO cebocb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Apan dili ingon niana ang mahitabo sa yuta sa Goshen diin nagpuyo ang akong katawhan; dili makita didto ang daghang langaw, aron mahibaloan ninyo nga ako, ang Ginoo, anaa sa maong dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ipakita ko ang kalainan sa akong pagtagad sa akong katawhan ug sa imong katawhan. Kini nga milagro himuon ko ugma.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Gihimo kini sa Ginoo. Midagsang ang daghang mga langaw ngadto sa palasyo sa hari ug sa mga balay sa iyang mga opisyal. Ug ang tibuok yuta sa Ehipto nadaot tungod niini. ");
INSERT INTO cebocb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Busa gipatawag dayon sa hari si Moises ug si Aaron ug giingnan, “Sige, paghalad kamo sa inyong Dios, apan diri lang sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mitubag si Moises, “Dili mahimo nga dinhi kami maghalad sa Ehipto, kay ngil-ad alang sa mga Ehiptohanon ang among mga halad sa Ginoo nga among Dios. Ug kon maghalad kamig mga halad nga ngil-ad alang kanila, sigurado nga batohon nila kami. ");
INSERT INTO cebocb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kinahanglan molakaw kami ug tulo ka adlaw ngadto sa kamingawan sa paghalad ug mga halad sa Ginoo nga among Dios, sumala sa gisugo niya kanamo.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Miingon ang hari, “Tugotan ko kamo nga maghalad ug mga halad ngadto sa Ginoo nga inyong Dios didto sa kamingawan, apan ayaw lang kamo pagpalayo. Karon pag-ampo na kamo alang kanako.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mitubag si Moises, “Sige, inigbiya ko gayod dinhi, mag-ampo dayon ako sa Ginoo. Ugma mawala na ang mga langaw gikan kaninyo. Apan siguroha baya nga dili mo na kami limbongan pag-usab pinaagi sa dili mo pagpabiya kanamo aron sa paghalad ug mga halad ngadto sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Unya mibiya si Moises, ug nag-ampo sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Gituman sa Ginoo ang gihangyo ni Moises, ug nahanaw ang mga langaw gikan sa tanang mga Ehiptohanon. Wala gayoy nahibilin bisan usa niini. ");
INSERT INTO cebocb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Apan nagmagahi gihapon ang hari ug wala niya palakwa ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Miingon ang Ginoo kang Moises, “Adtoa ang hari sa Ehipto ug ingna siya, ‘Mao kini ang giingon sa Ginoo, nga Dios sa mga Hebreo: “Palakwa ang akong mga katawhan aron makasimba sila kanako.” ");
INSERT INTO cebocb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kon dili mo pa gani sila palakwon, ");
INSERT INTO cebocb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","padad-an sa Ginoo ug makamatay nga sakit ang imong kahayopan sa kaumahan, sama sa mga kabayo, mga asno, mga kamelyo, mga baka, mga karnero, ug mga kanding. ");
INSERT INTO cebocb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Apan ipakita ko ang kalainan sa akong pagtagad sa kahayopan sa mga Israelinhon ug sa kahayopan sa mga Ehiptohanon; walay mangamatay sa mga kahayopan sa mga Israelinhon.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Gipahibalo sa Ginoo nga himuon niya kini pagkasunod adlaw. ");
INSERT INTO cebocb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Tuod man gihimo gayod kini sa Ginoo. Nangamatay ang tanang mga kahayopan sa mga Ehiptohanon, apan wala gayoy namatay sa mga kahayopan sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nagpadala ang hari ug mga tawo sa pagsusi kon tinuod nga walay namatay sa mga kahayopan sa mga Israelinhon. Apan bisan nahibaloan niya nga tinuod kini, gahi gihapon siyag kasing-kasing ug wala niya palakwa ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Unya miingon ang Ginoo kang Moises ug kang Aaron, “Pagkuha kamo ug tagsa ka kumkom nga abo gikan sa hurnohan ug ipasabwag kini kang Moises sa kahanginan atubangan sa hari. ");
INSERT INTO cebocb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Magkatag kini nga abog sa tibuok Ehipto, ug tungod niini tuboan ug mga hubag-hubag ang mga tawo ug mga kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Busa mikuha si Moises ug si Aaron ug abo sa hurnohan ug mitindog atubangan sa hari. Gisabwag kini ni Moises sa kahanginan, ug gituboan ug mga hubag-hubag ang mga tawo ug mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bisan ang mga madyikero dili makaatubang kang Moises, kay hasta sila gituboan usab ug mga hubag-hubag sama sa tanang Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Apan gipagahi pa gayod sa Ginoo ang kasing-kasing sa hari ug wala siya maminaw kang Moises ug kang Aaron, sumala sa giingon sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Unya miingon ang Ginoo kang Moises, “Sayo ug bangon ugma ug adtoa ang hari ug ingna, ‘Mao kini ang giingon sa Ginoo, nga Dios sa mga Hebreo: Palakwa ang akong katawhan aron makasimba sila kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kay kon dili, ipadala ko ang hilabihan kagrabe nga katalagman diha kanimo, sa imong mga opisyal, ug sa imong katawhan aron mahibaloan mo nga walay sama kanako sa tibuok kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Niining higayona, gihapak ko na unta ikaw ug ang imong katawhan sa usa ka dakong katalagman, ug wala ka na unta karon sa kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Apan gitugotan ka nako nga mabuhi aron makita mo ang akong gahom ug aron mabantog ang akong ngalan sa tibuok kalibotan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Apan nagpasigarbo ka gihapon ug wala mo tugoti ang akong katawhan nga molakaw. ");
INSERT INTO cebocb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Busa ugma, sa ingon niini nga oras, paulanan ko kamo ug labihan ka dagkong yelo nga wala pa gayod ninyo sukad masinati gikan sa pagkatukod sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Busa karon dayon, pagmando nga ipasilong ang tanan mong kahayopan ug ang tanang ulipon nga anaa sa kaumahan, kay ang bisan unsa nga anaa sa gawas, tawo man o kahayopan, mangamatay kon mahulogan sa ulan nga yelo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ang uban nga mga opisyal sa hari nahadlok sa giingon sa Ginoo, busa dali-dali nila nga gipasilong ang ilang mga ulipon ug kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Apan ang uban wala magtagad sa giingon sa Ginoo; gipasagdan nila sa gawas ang ilang mga ulipon ug kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Unya miingon ang Ginoo kang Moises, “Ibayaw ang imong baston sa langit aron moulan ug yelo sa tibuok Ehipto ngadto sa mga tawo, sa mga kahayopan, ug sa tanang tanom.” ");
INSERT INTO cebocb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Busa sa dihang gibayaw ni Moises ang iyang baston sa langit, gipadalogdog sa Ginoo ug gipakilat, ug gipaulan ug yelo. Wala pa gayod sukad mahitabo ang sama niini kakusog nga ulan nga yelo sa tibuok Ehipto sukad nga nahimo kining nasod. Samtang nag-ulan ug yelo, sige usab ug pangilat. ");
INSERT INTO cebocb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ang tanang mga tawo ug mga kahayopan nga didto sa gawas nangamatay, lakip ang tanang mga tanom ug mga kahoy. ");
INSERT INTO cebocb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ang wala lang paulani ug yelo mao ang Goshen diin nagpuyo ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Gipatawag dayon sa hari si Moises ug si Aaron. Miingon siya kanila, “Niining higayona giangkon ko nga ako nakasala. Husto ang Ginoo; ako ug ang akong katawhan mao ang sayop. ");
INSERT INTO cebocb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hangyoa ang Ginoo nga hunongon na niya kining hilabihan kakusog nga dalogdog ug ulan nga yelo. Palakwon ko na kamo. Dili na kinahanglan nga magpabilin pa kamo dinhi.” ");
INSERT INTO cebocb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mitubag si Moises, “Iniggawas ko sa siyudad, ibayaw ko ang akong kamot sa pag-ampo sa Ginoo. Mohunong ang dalogdog ug dili na mag-ulan ug yelo, aron mahibaloan mo nga ang kalibotan iya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Apan nasayod ako nga ikaw ug ang imong mga opisyal wala gihapon mahadlok sa Ginoong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Nangadaot ang mga tanom nga flax ug barley kay anihonon na kaniadto ang mga barley ug namulak na ang mga flax. ");
INSERT INTO cebocb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Apan wala nangadaot ang mga trigo ug espelta kay dili pa kini anihonon.) ");
INSERT INTO cebocb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mibiya si Moises sa hari ug migawas sa siyudad. Gibayaw niya ang iyang mga kamot sa pag-ampo ngadto sa Ginoo, ug mihunong ang pagdalogdog, ang pagpangahulog sa yelo, ug ang pag-ulan. ");
INSERT INTO cebocb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pagkakita sa hari nga mihunong na ang ulan, ang yelo, ug ang dalogdog, nagpakasala siya pag-usab. Nagmagahi na usab ang iyang kasing-kasing ug sa iyang mga opisyal. ");
INSERT INTO cebocb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Nagmagahi ang hari ug wala niya palakwa ang mga Israelinhon, sumala sa giingon sa Ginoo pinaagi kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Unya miingon ang Ginoo kang Moises, “Adtoa ang hari sa Ehipto, kay gipagahi ko ang kasing-kasing niya ug sa iyang mga opisyal aron padayon ko nga ikapakita kanila kining akong mga milagro, ");
INSERT INTO cebocb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ug aron ikasulti ninyo sa inyong mga anak ug mga apo kon giunsa ko pagsilot ang mga Ehiptohanon, ug kon unsa ang mga milagro nga gihimo ko taliwala kanila. Niining paagiha mahibaloan ninyo nga ako mao ang Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Busa miadto si Moises ug si Aaron sa hari ug miingon, “Mao kini ang giingon sa Ginoo, nga Dios sa mga Hebreo: ‘Hangtod kanus-a ka magdumili sa pagpaubos sa imong kaugalingon kanako? Palakwa ang akong katawhan aron makasimba sila kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kon dili mo gani sila palakwon, ugma padad-an ko ug mga dulon ang imong nasod. ");
INSERT INTO cebocb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tungod sa ilang kadaghan, dili na makita ang yuta. Kan-on nila ang nahibiling mga tanom nga wala madaot sa ulan nga yelo, lakip ang tanan ninyong mga kahoy. ");
INSERT INTO cebocb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mapuno sa mga dulon ang imong palasyo ug ang mga balay sa imong mga opisyal ug mga katawhan. Ang inyong mga katigulangan wala gayod nakakitag sama niini sa yuta sa Ehipto sukad sa ilang pag-abot dinhi.’ ” Unya mitalikod sila ni Moises ug milakaw. ");
INSERT INTO cebocb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Miingon ang mga opisyal sa hari kaniya, “Hangtod kanus-a mo pasagdan kining tawhana nga nagdaot kanato? Palakwa na ang mga Israelinhon, aron makasimba sila sa Ginoo nga ilang Dios. Wala mo ba makita nga dako na ang kadaot sa Ehipto?” ");
INSERT INTO cebocb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Busa gipabalik pag-usab si Moises ug si Aaron sa hari. Miingon ang hari kanila, “Sige, makalakaw na kamo sa pagsimba sa Ginoo nga inyong Dios. Apan sultihi ako ninyo kon kinsa ang manglakaw.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mitubag si Moises, “Manglakaw kaming tanan, bata ug tigulang. Dad-on namo ang among mga anak ug kahayopan, kay magsaulog kami ug pista alang sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Mabiay-biayon nga miingon ang hari, “Hinaut nga ubanan kamo sa Ginoo kon palakwon ko kamo ug ang inyong pamilya! Klaro nga daotan gayod ang inyong tuyo! ");
INSERT INTO cebocb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Dili ko mosugot! Ang mga lalaki lang ang molakaw aron mosimba sa Ginoo, kay mao man gayod kaha kana ang inyong gusto.” Gipapahawa dayon si Moises ug si Aaron sa atubangan sa hari. ");
INSERT INTO cebocb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Unya miingon ang Ginoo kang Moises, “Ipunting ang imong baston sa yuta sa Ehipto aron motungha ang mga dulon, ug kan-on nila ang nahibiling mga tanom nga wala madaot sa ulan nga yelo.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Busa gipunting ni Moises ang iyang baston, ug nagpadala ang Ginoo ug hangin nga gikan sa sidlakan tibuok adlaw ug gabii. Pagkabuntag nagdala ang hangin ug mga dulon ");
INSERT INTO cebocb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","nga daghan kaayo, ug midagsa kini sa tibuok Ehipto. Wala pa gayoy sama niadto nga pagdagsang sa dulon sukad masukad ug bisan pa human niadto. ");
INSERT INTO cebocb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mitabon ang dulon sa tibuok yuta sa Ehipto hangtod nga daw miitom ang yuta. Gipangaon nila ang nangahibiling mga tanom nga wala madaot sa ulan nga yelo, lakip ang tanang mga bunga sa kahoy. Wala gayoy nahibilin nga tanom sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Dali-dali nga gipatawag sa hari si Moises ug si Aaron, ug giingnan, “Nakasala ako sa Ginoo nga inyong Dios ug kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Busa pasayloa ninyo ako niining higayona, ug pag-ampo kamo sa Ginoo nga inyong Dios nga kuhaon niya kining makamatay nga katalagman gikan kanako.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Unya mibiya si Moises sa hari ug nag-ampo sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Mitubag ang Ginoo pinaagi sa pagpadala ug kusog nga hangin gikan sa kasadpan ug gipalid niini ang mga dulon ngadto sa Pulang Dagat. Wala na gayoy nahibilin nga dulon sa tibuok Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Apan gipagahi gihapon sa Ginoo ang kasing-kasing sa hari, ug wala niya palakwa ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Unya miingon ang Ginoo kang Moises, “Ibayaw ang imong kamot ngadto sa langit aron matabonan sa hilabihan nga kangitngit ang tibuok Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Busa gibayaw ni Moises ang iyang kamot sa langit, ug mingitngit pag-ayo ang tibuok Ehipto sulod sa tulo ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Walay migawas nga mga Ehiptohanon sa ilang balay niadtong mga adlawa, kay wala man silay makita. Apan adunay kahayag sa dapit nga gipuy-an sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Gipatawag dayon sa hari si Moises ug giingnan, “Sige, simba na kamo sa Ginoo. Dad-a ang inyong mga pamilya, apan ibilin ang inyong kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Apan mitubag si Moises, “Kinahanglan dad-on namo ang among kahayopan aron makahalad kami ug mga halad nga sinunog alang sa Ginoo nga among Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Dad-on namo ang tanan namong kahayopan. Wala gayoy ibilin bisan usa kanila, kay wala kami kahibalo kon unsa nga hayop ang ipahalad sa Ginoo kanamo. Mahibaloan lang namo kini kon atua na kami didto.” ");
INSERT INTO cebocb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Apan gipagahi gihapon sa Ginoo ang kasing-kasing sa hari, ug wala niya sila palakwa. ");
INSERT INTO cebocb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Miingon ang hari kang Moises, “Pahawa sa akong atubangan! Ayaw na pakita kanako pag-usab, kay kon makita ko pa gani ikaw, ipapatay ka nako!” ");
INSERT INTO cebocb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mitubag si Moises, “Kon mao kana ang imong gusto, dili na ako magpakita kanimo pag-usab.” ");
INSERT INTO cebocb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Miingon ang Ginoo kang Moises, “Padad-an ko ug usa pa ka katalagman ang hari ug ang Ehipto. Human niana, palakwon na niya kamo. Abugon pa gani niya kamo tungod kay gusto na gayod niya nga mopahawa kamo. ");
INSERT INTO cebocb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ingna ang mga Israelinhon, lalaki ug babaye, nga mangayo sila sa ilang mga silingan nga Ehiptohanon ug mga alahas nga plata ug bulawan.” ");
INSERT INTO cebocb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Gitugotan sa Ginoo nga mahimong maayo ang mga Ehiptohanon ngadto sa mga Israelinhon. Ug gitahod pag-ayo si Moises sa mga opisyal sa hari ug sa mga lumulupyo sa Ehipto.) ");
INSERT INTO cebocb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Busa miingon si Moises sa hari, “Mao kini ang giingon sa Ginoo: ‘Molabay ako sa tibuok Ehipto sa tungang gabii ");
INSERT INTO cebocb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ug mangamatay ang tanang kamagulangang anak nga lalaki sa Ehipto, gikan sa kamagulangan sa hari, nga mao ang mopuli sa iyang trono, hangtod ngadto sa kamagulangang sa pinakaubos nga ulipong babaye. Lakip ang tanang unang laki nga anak sa kahayopan mangamatay usab. ");
INSERT INTO cebocb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Madunggan ang pagminatay ug hilak sa tibuok Ehipto nga wala pa gayod sukad mahitabo, ug dili na gayod mahitabo pa pag-usab. ");
INSERT INTO cebocb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Apan sa nahimutangan sa mga Israelinhon adunay kalinaw; bisan usig sa iro walay madunggan.’ Niining paagiha mahibaloan ninyo nga lahi ang pagtagad sa Ginoo sa mga Israelinhon kay sa mga Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ug ang tanan mo nga opisyal moduol kanako nga nagyukbo ug nag-ingon, ‘Lakaw na kamo uban sa mga tawo nga nagsunod kanimo!’ Ug pagkahuman niana, molakaw ako.” Unya masuk-anon kaayo nga mibiya si Moises sa hari. ");
INSERT INTO cebocb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Miingon ang Ginoo kang Moises, “Dili maminaw ang hari kanimo aron mas daghan pa nga mga milagro ang mahimo ko diha sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Kini nga mga milagro gihimo ni Moises ug ni Aaron atubangan sa hari, apan gipagahi sa Ginoo ang kasing-kasing sa hari, ug wala tugoti sa hari nga mobiya ang mga Israelinhon sa iyang nasod. ");
INSERT INTO cebocb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Unya miingon ang Ginoo kang Moises ug kang Aaron didto sa Ehipto, ");
INSERT INTO cebocb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Gikan karon, kini nga bulan mao na ang unang bulan sa tuig alang kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ipahibalo ninyo sa tibuok katilingban sa Israel nga sa ikanapulo nga adlaw niining bulana, ang matag pamilya mag-andam ug usa ka nating karnero o nating kanding. ");
INSERT INTO cebocb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kon ang usa ka pamilya gamay ra ug dili makahurot ug usa ka karnero, bahinon nila kini sa ilang silingan sumala sa gidaghanon sa matag pamilya ug sumala sa makaon sa matag tawo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kinahanglan nga ang kanding o karnero nga inyong pilion laki nga usa pa ka tuig ug walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Atimanon ninyo kini hangtod sa kilom-kilom sa ika-14 nga adlaw sa bulan diin ihawon sa tibuok katilingban sa Israel kining mga mananapa. ");
INSERT INTO cebocb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Unya magkuha kamo ug dugo niini ug ipahid ninyo sa ibabaw ug sa isigka-kilid sa pultahan sa mga balay nga kan-an ninyo sa mga karnero. ");
INSERT INTO cebocb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Nianang gabhiona, magkaon kamo ug sinugba nga karnero, pait nga mga tanom, ug pan nga walay patubo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ayaw ninyo kan-a nga hilaw o sinabwan ang karne sa karnero; isugba ninyo kini nga tibuok uban ang ulo, tiil, ug ang mga bahin nga anaa sa sulod sa ginhawaan. ");
INSERT INTO cebocb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Hutda ninyo kinig kaon, ug ayaw ninyog pabuntagi. Kon aduna man gayod mahibilin sa buntag, sunoga ninyo kini. ");
INSERT INTO cebocb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sa pagkaon ninyo niini, kinahanglan nga nagsul-ob na kamo sa inyong bisting panglakaw ug sa inyong mga sandalyas, ug naggunit sa inyong baston. Dalia ninyo kini pagkaon. Mao kini ang Pista sa Paglabay sa Anghel sa Ginoo nga saulogon ninyo sa pagpasidungog kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Niana gayong gabhiona molabay ako sa Ehipto ug pamatyon ko ang tanang kamagulangang anak nga mga lalaki sa mga Ehiptohanon, lakip ang tanang unang laki nga anak sa ilang mga kahayopan. Silotan ko ang tanang dios sa Ehipto. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ang dugo nga gipahid ninyo sa isigka-kilid sa inyong mga pultahan mao ang akong ilhanan kon asa nga mga balay ang inyong ginapuy-an. Kon makita ko ang dugo, labyan ko lang kamo, ug dili kamo maunsa inigsilot ko sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Kinahanglan hinumdoman ninyo kana nga adlaw sa tanang panahon. Sauloga ninyo kana kada tuig ingon nga pista sa pagpasidungog alang sa Ginoo hangtod sa umaabot nga mga henerasyon. Himoon kini nga tulomanon hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sulod sa pito ka adlaw kinahanglan pan nga walay patubo ang inyong kan-on. Sa una gayod nga adlaw, kuhaa ninyo ang tanang patubo diha sa inyong mga balay, kay si bisan kinsa nga mokaon ug pan nga adunay patubo gikan sa unang adlaw hangtod sa ikapitong adlaw, dili isipon nga sakop sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sa unang adlaw ug sa ikapitong adlaw, pagtigom kamo sa pagsimba kanako. Ayaw kamo pagtrabaho nianang adlawa gawas lang sa pag-andam sa inyong kan-on. Mao lang kana ang mahimo ninyong buhaton. ");
INSERT INTO cebocb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Sauloga ninyo ang Pista sa Pan nga Walay Patubo, kay magpahinumdom kini kaninyo sa adlaw nga gipagawas ko ang inyong mga tribo gikan sa Ehipto. Sauloga ninyo kini hangtod sa kahangtoran isip tulomanon bisan sa umaabot ninyo nga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Magsugod kamo sa pagsaulog niini gikan sa kilom-kilom sa ika-14 nga adlaw sa unang bulan hangtod sa gabii sa ika-21 nga adlaw, ug kinahanglan nga pan nga walay patubo ang inyong kan-on. ");
INSERT INTO cebocb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sulod sa pito ka adlaw, kinahanglan walay patubo nga makita diha sa inyong mga balay. Si bisan kinsa nga mokaon ug pan nga adunay patubo, Israelinhon man o langyaw, dili isipon nga sakop sa katilingban sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ayaw gayod kamo pagkaon ug bisan unsa nga adunay patubo sa panahon nianang pista, bisan asa pa kamo magpuyo.” ");
INSERT INTO cebocb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Unya gipatawag ni Moises ang tanang tigdumala sa Israel ug giingnan, “Ingna ang tanan ninyong mga pamilya, nga magkuha sila ug karnero o kanding ug ihawon nila sa pagsaulog sa Pista sa Paglabay sa Anghel. ");
INSERT INTO cebocb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Unya pagkuha kamo ug pungpong sa isopo ug ituslob kini sa dugo nga anaa sa palanggana ug ipahid sa ibabaw ug sa isigka-kilid sa inyong mga pultahan. Walay mogawas sa inyong balay hangtod magbuntag ");
INSERT INTO cebocb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","kay molabay ang Ginoo sa Ehipto sa pagpamatay sa mga kamagulangang anak nga lalaki sa mga Ehiptohanon. Apan kon makita sa Ginoo ang dugo sa ibabaw ug sa isigka-kilid sa inyong mga pultahan, molabay lang siya sa inyong mga balay ug dili niya tugotan ang Tiglaglag nga mosulod sa inyong mga balay aron sa pagpamatay. ");
INSERT INTO cebocb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Kini nga tulomanon kinahanglan tumanon ninyo ug sa inyong mga kaliwat hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Padayona ninyo ang paghimo niini nga seremonya kon mosulod na kamo sa yuta nga gisaad sa Ginoo nga ihatag kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ug kon mangutana ang inyong mga anak kon unsa ang buot ipasabot niini nga seremonya, ");
INSERT INTO cebocb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mao kini ang inyong itubag: ‘Pista kini sa Paglabay sa Anghel nga ginasaulog sa pagpasidungog sa Ginoo, kay milabay lang siya sa mga balay sa mga Israelinhon didto sa Ehipto sa dihang gipamatay niya ang kamagulangang anak nga lalaki sa mga Ehiptohanon.’ ” Unya miluhod ang mga Israelinhon ug misimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ug gihimo nila ang gisugo sa Ginoo kang Moises ug kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Sa pagkatungang gabii, gipamatay sa Ginoo ang tanang mga kamagulangang anak nga lalaki sa Ehipto, gikan sa kamagulangan sa hari, nga mao ang mopuli sa trono, hangtod sa kamagulangan sa mga piniriso. Ug gipamatay usab niya ang tanang unang laki nga anak sa mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Niadtong gabhiona nakamata ang hari ug ang tanan niyang opisyal ug ang tanang Ehiptohanon. Ug madunggan ang hilabihang pagminatay ug hilak sa Ehipto, kay wala gayoy balay nga walay patay. ");
INSERT INTO cebocb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Niadtong gabhiona, gipatawag sa hari si Moises ug si Aaron ug giingnan, “Sige, panglakaw na kamo! Biyai na ninyo ang akong nasod. Lakaw na kamo uban sa mga Israelinhon ug pagsimba sa Ginoo, sumala sa inyong gihangyo. ");
INSERT INTO cebocb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Dad-a ninyo ang inyong kahayopan, sumala sa inyong gihangyo, ug lakaw na kamo. Apan pag-ampo usab nga kaloy-an ako!” ");
INSERT INTO cebocb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Gipadali ug pahawa sa mga Ehiptohanon gikan sa ilang nasod ang mga Israelinhon, kay ingon nila, “Kon dili kamo mohawa, mangamatay kaming tanan!” ");
INSERT INTO cebocb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Busa gidala sa mga Israelinhon ang ilang mga minasa nga harina nga wala pay patubo nga nasulod sa sudlanan. Giputos nila kini sa ilang mga bisti ug gipas-an. ");
INSERT INTO cebocb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Gihimo sa mga Israelinhon ang giingon kanila ni Moises nga mangayo sa mga Ehiptohanon ug mga alahas nga plata ug bulawan, ug mga bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Gibut-an sa Ginoo nga mahimong maayo ang mga Ehiptohanon ngadto sa mga Israelinhon, busa gihatag sa mga Ehiptohanon ang ilang gipangayo. Niining paagiha, gikuhaan nila ug mga kabtangan ang mga Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Milakaw ang mga Israelinhon gikan sa Rameses paingon sa Sucot. Mga 600,000 tanan ka lalaki, walay labot sa mga babaye ug mga bata. ");
INSERT INTO cebocb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Daghan usab nga mga langyaw ang nanguban kanila, ug daghan usab nga kahayopan ang ilang gidala. ");
INSERT INTO cebocb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Giluto nila ang minasang harina nga walay patubo nga ilang dala gikan sa Ehipto. Wala nila kini mabutangi ug patubo kay gipadali-dali sila ug pahawa sa mga Ehiptohanon ug wala na silay panahon sa pag-andam sa ilang pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Mikabat ug 430 ka tuig ang gidugayon sa pagpuyo sa mga Israelinhon didto sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Sa kataposang gayod nga adlaw sa ika-430 ka tuig mibiya ang tanan nga tribo sa katawhan sa Ginoo gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Niadtong gabii nga mibiya gikan sa Ehipto ang mga Israelinhon, nagtukaw ang Ginoo sa pagbantay kanila. Busa sa gabii usab sa samang adlaw sa matag tuig, magtukaw usab ang mga Israelinhon sa pagpasidungog sa Ginoo, ug himoon nila kini bisan sa umaabot nga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Miingon ang Ginoo kang Moises ug kang Aaron, “Mao kini ang mga tulomanon bahin sa Pista sa Paglabay sa Anghel: “Ang mga langyaw kinahanglan dili moapil ug kaon sa pagkaon nga giandam alang niini nga pista. ");
INSERT INTO cebocb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Makakaon sa pagkaon ang tanang ulipon nga pinalit kon natuli na sila, ");
INSERT INTO cebocb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","apan dili makakaon ang mga sinuholan nga trabahante ug ang mga dumuduong. ");
INSERT INTO cebocb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Kinahanglan kan-on kini sulod sa balay diin kini giandam. Ayaw gayod dad-a ang karne gawas sa balay, ug ayaw balia ang bukog niini. ");
INSERT INTO cebocb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kinahanglan saulogon kini sa tibuok katilingban sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Kon adunay langyaw nga nagpuyo uban kaninyo nga gustong magsaulog sa Pista sa Paglabay sa Anghel sa pagpasidungog sa Ginoo, kinahanglan tulion una ang tanang mga lalaki nga anaa sa iyang panimalay. Unya makaapil siya sa pagsaulog nga daw usa ka Israelinhon. Dili gayod mahimong makaapil ang tawo nga wala matuli. ");
INSERT INTO cebocb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kini nga tulomanon alang sa tanan nga mga Israelinhon ug sa mga langyaw nga nagpuyo uban kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Gihimo sa tanang Israelinhon ang gisugo sa Ginoo kang Moises ug kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ug niadto gayong adlawa gipagawas sa Ginoo ang tibuok katawhan sa Israel gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ihalad kanako ang tanang kamagulangang anak nga lalaki sa mga Israelinhon ug ang tanang unang laki nga anak sa mga kahayopan. Akoa sila.” ");
INSERT INTO cebocb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Unya miingon si Moises sa mga tawo, “Hinumdomi ninyo kining adlawa, nga mao ang adlaw nga gipagawas kamo gikan sa pagkaulipon sa Ehipto. Kay gipagawas kamo sa Ginoo pinaagi sa iyang gahom. Ayaw kamo pagkaon ug pan nga adunay patubo. ");
INSERT INTO cebocb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hinumdomi ninyo kini nga adlaw sa bulan sa Abib nga mao ang adlaw nga gipagawas kamo. ");
INSERT INTO cebocb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Kinahanglan saulogon ninyo kini kon dad-on na kamo sa Ginoo ngadto sa yuta sa mga Canaanhon, Hitihanon, Amorihanon, Hibihanon, ug mga Jebusihanon. Mao kini ang yuta nga gisaad sa Ginoo sa inyong mga katigulangan nga ihatag kaninyo. Kini nga yuta maayo ug mabungahon. ");
INSERT INTO cebocb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sa panahon sa inyong pagsaulog, pan nga walay patubo ang inyong kan-on sulod sa pito ka adlaw, ug sa ikapito nga adlaw magsaulog kamo sa pista alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Pan nga walay patubo lang ang inyong kan-on sulod nianang pito ka adlaw, ug kinahanglan nga wala gayoy patubo nga makita diha sa inyo sa bisan asa sa inyong dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Sa panahon sa inyong pagsaulog, ipasabot ninyo sa inyong mga anak nga gihimo ninyo kini aron sa paghinumdom sa gihimo sa Ginoo sa dihang migawas kamo gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Kini nga pista mahisama sa usa ka timaan diha sa inyong mga kamot o sa inyong mga agtang nga mopahinumdom kaninyo nga kinahanglan ninyong isulti ang mga katudloan sa Ginoo, kay gipagawas niya kamo gikan sa Ehipto pinaagi sa iyang gahom. ");
INSERT INTO cebocb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Busa sauloga ninyo kini nga pista sa gitakda nga panahon matag tuig. ");
INSERT INTO cebocb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Kon dad-on na kamo sa Ginoo ngadto sa yuta sa mga Canaanhon nga iyang gisaad nga ihatag sa inyong mga katigulangan ug kaninyo, ");
INSERT INTO cebocb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ihalad ninyo sa Ginoo ang inyong kamagulangang mga anak nga lalaki ug lakip usab ang unang laki nga anak sa inyong kahayopan, kay sila iya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mahimong lukaton gikan sa Ginoo ang kamagulangan sa inyong mga asno pinaagi sa pagbaylo niini ug karnero. Apan kon dili ninyo kini lukaton, kinahanglan nga patyon ang asno pinaagi sa pagbali sa iyang liog. Mahimo usab ninyong lukaton ang inyong mga kamagulangang anak nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Kon sa umaabot nga panahon mangutana ang inyong mga anak kon unsay kahulogan niini, ingna sila nga, ‘Pinaagi sa gahom sa Ginoo gipagawas niya kami gikan sa Ehipto diin kami naulipon. ");
INSERT INTO cebocb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tungod kay sa dihang wala kami tugoti sa hari nga molakaw, gipamatay sa Ginoo ang tanang kamagulangang anak nga lalaki sa Ehipto, tawo man o kahayopan. Mao kana nga ginahalad namo sa Ginoo ang tanang unang laki nga anak sa among kahayopan ug ginatubos namo ang among mga kamagulangang anak nga lalaki.’ ");
INSERT INTO cebocb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kini nga seremonya mahisama sa usa ka timaan diha sa inyong mga kamot o sa inyong mga agtang nga mopahinumdom kaninyo nga gipagawas kamo sa Ginoo gikan sa Ehipto pinaagi sa iyang gahom.” ");
INSERT INTO cebocb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sa dihang gipalakaw na sa hari ang mga Israelinhon, wala sila giyahi sa Dios ngadto sa dalan nga molatas sa yuta sa mga Filistihanon bisag mao unta kadto ang mas duol nga agianan. Kay miingon ang Dios, “Basig mausab unya ang ilang huna-huna ug mobalik sa Ehipto kon makasinati silag gira.” ");
INSERT INTO cebocb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Busa gipalibot sila sa Dios sa kamingawan paingon sa Pulang Dagat. Armado ang mga Israelinhon alang sa gira paghawa nila sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Gidala ni Moises ang mga bukog ni Jose, sumala sa gipapanumpa kaniadto ni Jose sa mga Israelinhon. Miingon kaniadto si Jose, “Sigurado nga pagawason kamo sa Dios. Kon mahitabo na kana, dad-a ninyo ang akong mga bukog inigbiya ninyo niining lugara.” ");
INSERT INTO cebocb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Unya mibiya sila sa Sucot ug nagkampo sa Etam, sa utlanan sa kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kon adlaw, ginagiyahan sila sa Ginoo pinaagi sa panganod nga daw haligi, ug kon gabii, ginagiyahan sila pinaagi sa panganod nga daw kalayo nga naghatag kanila ug kahayag, aron makapadayon sila sa ilang lakaw, adlaw man o gabii. ");
INSERT INTO cebocb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gauna kanila kanunay ang panganod nga daw haligi kon adlaw ug ang panganod nga daw kalayo kon gabii. ");
INSERT INTO cebocb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Unya miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ingna ang mga Israelinhon nga mobalik sila ug magkampo duol sa Pi Hahirot, sa tunga-tunga sa Migdol ug sa Pulang Dagat, ug magkampo sila sa daplin sa dagat, atbang sa Baal Zefon. ");
INSERT INTO cebocb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Maghuna-huna ang hari nga nahisalaag kamo ug dili na makagawas sa kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ug pagahion ko ang iyang kasing-kasing ug gukdon niya kamo. Apan laglagon ko siya ug ang iyang mga sundalo. Niining paagiha mapasidunggan ako, ug mahibaloan sa mga Ehiptohanon nga ako mao ang Ginoo.” Busa gihimo kini sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sa dihang nabalitaan sa hari sa Ehipto nga miikyas ang mga Israelinhon, nausab ang iyang huna-huna ug sa iyang mga opisyal bahin sa mga Israelinhon. Miingon sila, “Unsa kining atong gibuhat? Nganong gipalakaw man nato ang mga Israelinhon? Karon wala na kitay mga ulipon!” ");
INSERT INTO cebocb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Busa gipaandam sa hari ang iyang karwahi ug ang iyang mga sundalo. ");
INSERT INTO cebocb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Gidala niya ang 600 sa pinakamaayong karwahi sa Ehipto ug ang uban pang karwahi. Gidumalahan kining tanan sa iyang mga opisyal. ");
INSERT INTO cebocb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Gipagahi sa Ginoo ang kasing-kasing sa Paraon nga hari sa Ehipto, busa gigukod niya ang mga Israelinhon nga maisogong mibiya. ");
INSERT INTO cebocb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ang mga Ehiptohanon nga miuban sa paggukod mao ang mga sundalo sa hari uban sa iyang mga tigkabayo nga nagsakay sa mga kabayo ug mga karwahi. Naapsan nila ang mga Israelinhon sa ilang ginakampohan daplin sa Pulang Dagat duol sa Pi Hahirot, atbang sa Baal Zefon. ");
INSERT INTO cebocb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Sa nagpadulong ang hari ug ang iyang mga sundalo, nakita sila sa mga Israelinhon. Busa nangahadlok sila pag-ayo ug nagpakitabang sila sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Miingon sila kang Moises, “Nganong gidala mo pa kami dinhi sa kamingawan aron mamatay? Wala bay lubnganan didto sa Ehipto? Nganong gipagawas mo pa man kami gikan sa Ehipto? ");
INSERT INTO cebocb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Di ba nag-ingon man kami kanimo didto sa Ehipto nga pasagdan mo na lang kami nga magpaulipon sa mga Ehiptohanon? Mas maayo pa nga nagpaulipon na lang kami sa mga Ehiptohanon kaysa mamatay kami dinhi sa kamingawan!” ");
INSERT INTO cebocb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mitubag si Moises sa mga tawo, “Ayaw kamo kahadlok. Pagmalig-on kamo ug tan-awa ninyo ang pagluwas kaninyo sa Ginoo karong adlawa. Kanang mga Ehiptohanon nga nakita ninyo karon dili na gayod ninyo makita pag-usab. ");
INSERT INTO cebocb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Pagmalinawon lang kamo. Ang Ginoo ang makig-gira alang kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Unya miingon ang Ginoo kang Moises, “Nganong nagpakitabang ka man kanako? Ingna ang mga Israelinhon nga magpadayon sila sa paglakaw. ");
INSERT INTO cebocb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Unya ipunting ang imong baston sa dagat aron matunga ang tubig ug makatabok ang mga Israelinhon sa malang yuta taliwala sa dagat. ");
INSERT INTO cebocb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Pagahion ko ang kasing-kasing sa mga Ehiptohanon aron gukdon nila kamo. Apan laglagon ko ang hari ug ang tanan niyang mga sundalo, mga tigkabayo, ug mga karwahi. Niining paagiha mapasidunggan ako. ");
INSERT INTO cebocb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ug kon malaglag ko na sila, mahibaloan sa mga Ehiptohanon nga ako mao ang Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Unya ang anghel sa Dios nga gauna sa katawhan sa Israel mibalhin sa luyo, ug ang panganod nga daw haligi mibalhin usab sa luyo. ");
INSERT INTO cebocb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Mipundo ang panganod sa tunga-tunga sa mga Israelinhon ug sa mga Ehiptohanon. Tibuok gabii naghatag ang panganod ug kahayag sa mga Israelinhon ug naghatag ug kangitngit sa mga Ehiptohanon. Busa milabay ang gabii nga wala makaduol ang mga Ehiptohanon sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Unya giisa ni Moises ang iyang kamot ibabaw sa dagat, ug natunga ang dagat pinaagi sa makusog nga hangin nga gipadala sa Ginoo gikan sa sidlakan. Tibuok gabii nga kusog ang hangin hangtod nga mimala ang yuta taliwala sa dagat. ");
INSERT INTO cebocb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Unya nangagi niining malang yuta ang mga Israelinhon, ug ang tubig nahimong murag paril sa ilang isigka-kilid. ");
INSERT INTO cebocb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gigukod sila sa mga Ehiptohanon. Ang tanang mga kabayo sa hari, mga karwahi ug ang tanang tigkabayo misunod kanila sa taliwala sa dagat. ");
INSERT INTO cebocb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Apan nianang pagkakadlawon, mitan-aw ang Ginoo gikan sa panganod nga daw kalayo ug daw haligi ngadto sa mga sundalo sa Ehipto, ug gipataranta niya sila. ");
INSERT INTO cebocb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Gipaungot niya ang mga ligid sa ilang mga karwahi aron maglisod sila sa pagpadagan niini. Miingon ang mga Ehiptohanon, “Moatras na lang kita gikan sa mga Israelinhon, kay ang Ginoo mao ang nakig-gira kanato alang kanila.” ");
INSERT INTO cebocb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Sa dihang nakatabok na ang mga Israelinhon, miingon ang Ginoo kang Moises, “Iisa pag-usab ang imong kamot sa dagat aron mobalik ang tubig ug matabonan ang mga Ehiptohanon ug ang ilang mga karwahi ug mga tigkabayo.” ");
INSERT INTO cebocb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Busa gipunting ni Moises ang iyang kamot sa dagat, ug sa pagsubang sa adlaw, mibalik ang tubig sa daang nahimutangan niini. Misulay ang mga Ehiptohanon sa pag-ikyas apan gilumsan sila sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Natabonan sa tubig ang tanang kasundalohan sa hari sa Ehipto nga migukod sa mga Israelinhon lakip ang ilang mga tigkabayo ug mga karwahi. Wala gayoy usa kanila nga nakalingkawas. ");
INSERT INTO cebocb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Apan ang mga Israelinhon naglakaw sa malang yuta taliwala sa dagat, diin ang mga tubig nahimong murag paril sa ilang isigka-kilid. ");
INSERT INTO cebocb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Nianang adlawa, giluwas sa Ginoo ang mga Israelinhon gikan sa kamot sa mga Ehiptohanon. Ug nakita sa mga Israelinhon ang mga patayng lawas sa mga Ehiptohanon nga nagbuy-od sa baybayon. ");
INSERT INTO cebocb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Nakita sa mga Israelinhon ang katingalahang gahom sa Ginoo nga iyang gigamit batok sa mga Ehiptohanon. Tungod niini, mitahod ug misalig sila sa Ginoo ug sa iyang alagad nga si Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Unya miawit si Moises ug ang mga Israelinhon niini nga awit ngadto sa Ginoo: “Awitan ko ang Ginoo tungod kay nagmadaogon gayod siya. Gitambog niya sa dagat ang mga kabayo ug ang mga nagsakay niini. ");
INSERT INTO cebocb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Ang Ginoo mao ang naghatag kanako ug kusog, ug siya ang akong awit. Siya ang nagluwas kanako. Siya ang akong Dios, ug dayegon ko siya. Siya ang Dios sa akong amahan, ug pasidunggan ko siya. ");
INSERT INTO cebocb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ginoo ang iyang ngalan, ug usa siya ka manggugubat. ");
INSERT INTO cebocb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gitambog niya sa dagat ang mga karwahi ug mga sundalo sa hari sa Ehipto. Nangalumos sa Pulang Dagat ang pinakamaayong mga opisyal sa hari. ");
INSERT INTO cebocb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nangalumos sila sa lawom nga tubig; naunlod sila sa kinahiladman nga daw bato. ");
INSERT INTO cebocb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Labihan gayod ang imong gahom, O Ginoo; pinaagi niini gidugmok mo ang mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Sa imong pagkagamhanan, gilaglag mo ang mga mikontra kanimo. Gipatagamtam mo kanila ang imong kasuko nga mipuo kanila nga daw mga dagami nga gisunog. ");
INSERT INTO cebocb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Sa usa mo lang ka paghuyop napundok ang tubig. Natigom ang dakong bul-og sa tubig ug mibarog nga daw paril; nimala ang yuta taliwala sa dagat. ");
INSERT INTO cebocb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Nagpasigarbo ang kaaway nga nagkanayon, ‘Gukdon ko sila ug dakpon; bahinon ko ang ilang mga kabtangan ug tagbawon ko ang akong kaugalingon niini. Hulboton ko ang akong espada ug laglagon ko sila.’ ");
INSERT INTO cebocb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Apan sa usa mo lang ka paghuyop nalumos sila sa dagat. Naunlod sila sa kinahiladman nga daw tingga. ");
INSERT INTO cebocb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O Ginoo, kinsa sa mga dios ang sama kanimo? Walay sama kanimo sa pagkabalaan ug pagkagamhanan. Ikaw lang ang Dios nga naghimo ug katingalahang mga butang! ");
INSERT INTO cebocb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Pinaagi sa imong gahom gilamoy sa yuta ang among mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Sa imong mapinadayonon nga gugma tultolan mo ang mga tawo nga imong giluwas. Sa imong kusog, tultolan mo sila sa imong balaan nga puloy-anan. ");
INSERT INTO cebocb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Madunggan kini sa mga nasod ug magkurog sila sa kahadlok. Makulbaan gayod ang mga Filistihanon. ");
INSERT INTO cebocb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ang mga pangulo sa Edom ug Moab magkurog sa kahadlok, ug ang mga pangulo sa Canaan daw malipong sa kahadlok. ");
INSERT INTO cebocb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Mangalisang gayod sila. Pinaagi sa imong pagkagamhanan dili sila makalihok sama sa bato, hangtod makalabay ang imong katawhan nga imong giluwas, O Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dad-on mo ang imong katawhan sa imong yuta, ug ipahimutang mo sila sa bukid nga imong gipanag-iyahan, ang dapit nga gihimo mo nga imong pinuy-anan, O Ginoo, ang balaang puloy-anan nga ikaw mismo ang naghimo. ");
INSERT INTO cebocb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Maghari ka, O Ginoo, sa walay kataposan.” ");
INSERT INTO cebocb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ang mga Israelinhon naglakaw sa malang yuta taliwala sa dagat. Apan sa dihang milatas sa dagat ang mga kabayo sa hari ug ang iyang mga karwahi ug mga tigkabayo, gibalik sa Ginoo ang tubig ug natabonan sila. ");
INSERT INTO cebocb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Unya si Miriam nga propeta ug igsoon ni Aaron mikuhag tamborin ug gipangunahan ang mga babaye sa pagtamborin ug sa pagsayaw. ");
INSERT INTO cebocb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ug mao kini ang iyang awit kanila: “Pag-awit kamo sa Ginoo tungod kay nagmadaogon gayod siya. Gitambog niya sa dagat ang mga kabayo ug ang mga nagsakay niini.” ");
INSERT INTO cebocb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Gikan sa Pulang Dagat, gidala ni Moises ang mga Israelinhon sa kamingawan sa Shur. Tulo ka adlaw silang nagbaktas sa kamingawan ug wala gayod silay nakita nga tubig. ");
INSERT INTO cebocb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Sa dihang nakaabot sila sa Mara, nakakita sila ug tubig, apan dili sila makainom kay pait ang tubig. (Mao kana nga ginganlan kining lugara nga Mara.) ");
INSERT INTO cebocb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tungod niini, mireklamo ang mga Israelinhon kang Moises, “Unsa na lay atong imnon niini?” ");
INSERT INTO cebocb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Busa nagpakitabang si Moises sa Ginoo, ug gipakita sa Ginoo kaniya ang usa ka sanga sa kahoy. Gilabay kini ni Moises sa tubig ug nawala ang kapait sa tubig. Didto naghatag ang Ginoo niini nga tulomanon ug sugo sa pagsulay kanila: ");
INSERT INTO cebocb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Kon mosunod kamo pag-ayo kanako, ang Ginoo nga inyong Dios, ug maghimo ug maayo sa akong atubangan ug motuman sa akong mga sugo ug mga tulomanon, dili ko ipadala kaninyo ang mga sakit nga gipadala ko sa mga Ehiptohanon, kondili kanunay ko kamo ayohon.” ");
INSERT INTO cebocb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Mibiya sila sa Mara, ug miabot sila sa Elim, diin adunay 12 ka tuboran ug 70 ka palma, ug nagkampo sila didto duol sa tubig. ");
INSERT INTO cebocb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gikan sa Elim, mipadayon sa paglakaw ang tibuok katilingban sa Israel hangtod nga nakaabot sila sa kamingawan sa Sin, nga anaa tunga-tunga sa Elim ug Sinai. Nakaabot sila didto sa ika-15 nga adlaw sa ikaduhang bulan gikan sa paggawas nila sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Didto sa kamingawan mireklamo ang tibuok katilingban ngadto kang Moises ug kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Miingon sila, “Maayo pag gipatay na lang kami sa Ginoo didto sa Ehipto. Didto makapagusto pa kamig kaon. Apan gidala ninyo kami dinhi niining kamingawan aron mangamatay kaming tanan sa kagutom.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Unya miingon ang Ginoo kang Moises, “Paminaw! Magpaulan ako ug pan gikan sa langit alang kaninyo. Kada adlaw magkuha ang mga Israelinhon ug pan nga igo lang alang nianang adlawa. Niining paagiha sulayan ko sila ug tan-awon ko kon tumanon ba nila ang akong mga sugo. ");
INSERT INTO cebocb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ingna sila nga doblehon nila ang gidaghanon sa pan nga ilang kuhaon sa ikaunom nga adlaw sa kada semana.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Busa miingon si Moises ug si Aaron sa tanang mga Israelinhon, “Karong gabhiona, mapamatud-an ninyo nga ang Ginoo mao ang nagpagawas kaninyo gikan sa Ehipto, ");
INSERT INTO cebocb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ug sa buntag makita ninyo ang gamhanang presensya sa Ginoo. Kay nadungog niya ang inyong mga pagbagulbol. Si kinsa ba gud kami nga diri man kamo kanamo magbagulbol? Ang tinuod, ang Ginoo ang inyong gibagulbolan.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Miingon pa gayod si Moises, “Hatagan kamo sa Ginoo ug karne nga inyong kan-on sa gabii ug magpagusto kamog kaon ug pan sa buntag, kay nadungog niya ang inyong mga pagbagulbol ngadto kaniya. Dili kami ang inyong gibagulbolan kondili ang Ginoo. Kinsa ba gud kami nga diri man kamo magbagulbol kanamo?” ");
INSERT INTO cebocb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Miingon dayon si Moises kang Aaron, “Ingna ang tibuok katilingban sa Israel nga moduol sila sa presensya sa Ginoo kay nadungog niya ang ilang mga pagbagulbol.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Samtang nagsulti si Aaron sa tibuok katilingban sa Israel, mitan-aw sila sa kamingawan ug sa kalit lang nakita nila ang gamhanang presensya sa Ginoo diha sa panganod. ");
INSERT INTO cebocb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nadungog ko ang mga pagbagulbol sa mga Israelinhon. Ingna sila nga sa gabii mokaon sila ug karne ug sa buntag makapagusto silag kaon ug pan. Unya mahibaloan ninyo nga ako mao ang Ginoo nga inyong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nianang pagkakilom-kilom na, mitungha ang daghang buntog nga milukop sa ilang kampo. Pagkabuntag, ang yuta palibot sa ilang kampo basa sa yamog. ");
INSERT INTO cebocb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Sa dihang nawala na ang yamog, aduna silay nakita sa yuta nga nipis nga mga butang nga labihan kaputi. ");
INSERT INTO cebocb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Wala sila kahibalo kon unsa kadto, busa nagpangutan-anay sila, “Unsa kini?” Miingon si Moises kanila, “Mao kana ang pagkaon nga gihatag sa Ginoo kaninyo aron inyong kan-on. ");
INSERT INTO cebocb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Miingon ang Ginoo nga ang kada usa kaninyo magkuha niini sumala sa inyong gikinahanglan: usa ka gantang alang sa kada tawo diha sa inyong panimalay.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Busa nanguha ang mga Israelinhon niini nga pagkaon; ang uban daghan ang gikuha ug ang uban gamay lang. ");
INSERT INTO cebocb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Apan sa dihang gitakos na nila kini, usa ka gantang ra gayod ang nakuha sa matag-usa. Ang nagkuha ug daghan wala manobra, ug ang nagkuha ug gamay wala makulangi. Igo ra gayod sa iyang gikinahanglan ang nakuha sa kada usa. ");
INSERT INTO cebocb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Miingon si Moises kanila, “Walay magbilin niini alang sa sunod nga adlaw.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Apan ang uban kanila wala magpatuo kang Moises, nagbilin gayod sila alang sa sunod nga adlaw. Apan giulod kini ug nabaho. Busa nasuko si Moises kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kada buntag magkuha ang kada usa sumala sa iyang gikinahanglan. Ug kon motaas na ang adlaw, mangatunaw ra usab kini. ");
INSERT INTO cebocb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Sa ikaunom nga adlaw, doblehon nila ang ilang gikuha nga duha ka gantang kada tawo. Busa miadto ang mga pangulo sa katilingban ngadto kang Moises ug nangutana kon nganong doblehon. ");
INSERT INTO cebocb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Miingon si Moises kanila, “Nagsugo ang Ginoo nga mopahulay kamo ugma kay Adlaw nga Igpapahulay, usa ka balaan nga adlaw alang sa Ginoo. Busa lutoa ninyo ang gusto ninyong lutuon, ug lung-aga ang gusto ninyong lung-agon. Hiposa ang mahibilin alang sa sunod nga adlaw.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Busa gitipigan nila ang nahibilin alang sa pagkasunod nga adlaw sumala sa gisugo kanila ni Moises. Ug wala kini ulora ni mabaho. ");
INSERT INTO cebocb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Miingon si Moises kanila, “Kan-a ninyo kana karong adlawa, kay Adlaw karon nga Igpapahulay alang sa Ginoo. Wala kamoy makita niana karon sa palibot. ");
INSERT INTO cebocb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Manguha kamo niana nga pagkaon sulod sa unom ka adlaw, apan sa ikapito nga adlaw mopahulay kamo. Nianang adlawa wala kamoy makuha nga pagkaon.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Sa ikapito nga adlaw, adunay mga tawo gihapon nga miadto aron sa pagpanguha niini nga pagkaon, apan wala silay nakita. ");
INSERT INTO cebocb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Unya miingon ang Ginoo kang Moises, “Hangtod kanus-a ba kining mga tawhana magsupak-supak sa akong mga sugo ug mga balaod? ");
INSERT INTO cebocb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Hinumdomi ninyo nga gihatagan ko kamo ug Adlaw nga Igpapahulay, mao kana nga kada ikaunom nga adlaw naghatag ako sa inyong pagkaon alang sa duha ka adlaw. Kinahanglan nga ang kada usa magpabilin diha sa iyang gipuy-an sa ikapito nga adlaw. Walay mogawas sa pagpanguha ug pagkaon.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Busa mipahulay ang mga tawo sa ikapito nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Gitawag sa mga Israelinhon ang maong pagkaon ug manna. Daw liso kini nga gagmay ug puti, ug tam-is kini sama sa nipis nga pan nga adunay dugos. ");
INSERT INTO cebocb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Miingon si Moises kanila, “Mao kini ang gisugo sa Ginoo: ‘Pagtipig kamo ug usa ka gantang nga manna alang sa umaabot nga henerasyon, aron makita nila ang pagkaon nga gihatag ko kaninyo sa kamingawan sa dihang gipagawas ko kamo gikan sa Ehipto.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Miingon si Moises kang Aaron, “Pagkuhag sudlanan ug sudli kinig usa ka gantang nga manna. Unya ibutang kini diha sa presensya sa Ginoo alang sa umaabot nga henerasyon.” ");
INSERT INTO cebocb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Gituman kini ni Aaron sumala sa gisugo sa Ginoo kang Moises. Gibutang ni Aaron ang manna sa Sudlanan sa Kasabotan aron matipigan kini. ");
INSERT INTO cebocb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mikaon ang mga Israelinhon ug manna sulod sa 40 ka tuig, hangtod nakaabot sila sa yuta sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Kada adlaw nagtigom ang kada usa kanila ug usa ka omer nga manna, nga mga usa ka gantang.) ");
INSERT INTO cebocb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Sumala sa sugo sa Ginoo, mibiya sa kamingawan sa Sin ang tibuok katilingban sa Israel ug nagpadayon sa paglakaw. Nagbalhin-balhin sila ug dapit hangtod nga nakaabot sila sa Refidim ug nagkampo didto. Apan walay tubig nga mainom didto. ");
INSERT INTO cebocb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Busa nakiglalis ang mga tawo kang Moises ug miingon, “Hatagi kamig tubig nga mainom.” Mitubag si Moises, “Nganong nakiglalis man kamo kanako? Nganong ginasulayan ninyo ang Ginoo?” ");
INSERT INTO cebocb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Apan gipang-uhaw pag-ayo ang mga tawo didto, busa nagsige silag bagulbol kang Moises. Miingon sila, “Nganong gipagawas mo pa kami gikan sa Ehipto kon mangamatay man lang kami dinhi sa kauhaw lakip ang among mga anak ug kahayopan?” ");
INSERT INTO cebocb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Busa nagpakitabang si Moises sa Ginoo, “Unsa may akong himuon niining mga tawhana? Halos batohon na nila ako sa ilang kasuko!” ");
INSERT INTO cebocb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mitubag ang Ginoo kang Moises, “Kuhaa kadtong imong baston nga gihapak mo sa Suba sa Nilo, ug pag-una sa mga tawo uban sa pipila ka mga tigdumala sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Maghulat ako kanimo didto sa bato sa Horeb. Bunali ang bato, ug mogawas ang tubig aron makainom ang mga tawo.” Busa gihimo kini ni Moises atubangan sa mga tigdumala sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ginganlan ni Moises kadtong lugara nga Masa ug Meriba, tungod kay nakiglalis ang mga Israelinhon kaniya didto ug gisulayan nila ang Ginoo pinaagi sa pag-ingon, “Nag-uban ba ang Ginoo kanato o wala?” ");
INSERT INTO cebocb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sa didto pa ang mga Israelinhon sa Refidim, gisulong sila sa mga Amalekanhon. ");
INSERT INTO cebocb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Miingon si Moises kang Josue, “Pagpili ug mga tawo nga makig-gira sa mga Amalekanhon. Mobarog ako ugma ibabaw sa bungtod nga dala kadtong baston nga gisugo sa Dios nga kanunay kong dal-on.” ");
INSERT INTO cebocb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Busa nakig-away sila si Josue sa mga Amalekanhon sumala sa gisugo ni Moises samtang si Moises, Aaron, ug Hur mitungas sa bungtod. ");
INSERT INTO cebocb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kon ibayaw ni Moises ang iyang kamot, modaog ang mga Israelinhon. Apan kon ipaubos niya ang iyang kamot, modaog ang mga Amalekanhon. ");
INSERT INTO cebocb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Apan sa kadugayan, nanghawoy na ang mga kamot ni Moises. Busa mikuhag bato si Aaron ug Hur ug gipalingkoran kini kang Moises. Unya gibayaw ni Aaron ang usa ka kamot ni Moises ug mao usab ang gihimo ni Hur sa pikas kamot aron padayon kini nga nakabayaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Busa napildi nila ni Josue ang mga Amalekanhon. ");
INSERT INTO cebocb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Unya miingon ang Ginoo kang Moises, “Isulat kini sa libro aron dili malimtan ug ipahibalo kini kang Josue: Puohon ko gayod sa hingpit ang mga Amalekanhon.” ");
INSERT INTO cebocb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Naghimo si Moises ug halaran ug gitawag kini nga, “Ang Ginoo mao ang akong Bandera sa Pagdaog.” ");
INSERT INTO cebocb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Miingon siya, “Tungod kay gikumoan sa mga Amalekanhon ang trono sa Ginoo, padayon nga makig-gira ang Ginoo batok kanila hangtod sa hangtod.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Si Jetro nga pari sa Midian ug ugangan ni Moises nakabalita sa tanang gihimo sa Dios kang Moises ug sa iyang katawhan nga mga Israelinhon. Nadunggan niya kon giunsa pagpagawas sa Ginoo ang mga Israelinhon gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Sa wala pa kini mahitabo, gipapauli una ni Moises si Zipora nga iyang asawa ug ang duha nila ka anak nga lalaki didto kang Jetro nga iyang ugangan. Ang ngalan sa usa niya ka anak mao si Gershom, kay sa dihang natawo kini miingon si Moises, “Dumuduong ako sa ubang dapit.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ang ngalan sa usa mao si Eliezer, kay sa dihang natawo kini miingon si Moises, “Ang Dios sa akong amahan mao ang akong magtatabang. Giluwas niya ako gikan sa espada sa hari.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Unya, miadto si Jetro uban ang asawa ug duha ka anak ni Moises didto sa gikampohan nila ni Moises sa kamingawan, duol sa bukid sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Nagpahibalo nang daan si Jetro kang Moises nga moabot siya uban si Zipora ug ang duha niya ka anak. ");
INSERT INTO cebocb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Busa gitagbo ni Moises ang iyang ugangan, ug miyukbo siya ug mihalok agig pagtahod kaniya. Nagkinumustahanay sila ug unya nanulod sa tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Gisulti ni Moises kang Jetro ang tanang gihimo sa Ginoo ngadto sa hari sa Ehipto ug sa mga Ehiptohanon alang sa mga Israelinhon. Gisulti usab niya ang tanang kalisod nga ilang naagian sa ilang paglakaw, ug kon giunsa sila pagluwas sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nalipay pag-ayo si Jetro sa tanang kaayo nga gihimo sa Ginoo sa mga Israelinhon sa iyang pagluwas kanila gikan sa kamot sa mga Ehiptohanon. ");
INSERT INTO cebocb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Miingon si Jetro, “Dalaygon ang Ginoo nga nagluwas kaninyo gikan sa kamot sa mga Ehiptohanon ug sa ilang hari. ");
INSERT INTO cebocb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Karon nahibaloan ko na nga ang Ginoo mas labaw sa tanang mga dios, kay giluwas niya ang mga Israelinhon sa mga Ehiptohanon nga midaog-daog kanila.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Unya naghalad si Jetro ug mga halad nga sinunog ug uban pa nga mga halad ngadto sa Dios. Ug samtang ginahimo niya kini, miabot si Aaron ug ang tanang tigdumala sa Israel. Nakig-uban sila kang Jetro sa pagpangaon diha sa presensya sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pagkasunod adlaw, milingkod si Moises ingon nga maghuhukom aron sa paghusay sa mga kaso sa mga tawo. Naglinya ang mga tawo sa iyang atubangan gikan sa buntag hangtod sa gabii. ");
INSERT INTO cebocb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Sa pagkakita niini ni Jetro, miingon siya kang Moises, “Nganong ginahimo mo kini alang sa mga tawo? Nganong ikaw lang ang naghimo niini? Naglinya ang mga tawo sa imong atubangan gikan pa sa buntag hangtod sa gabii.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mitubag si Moises, “Ginahimo ko kini tungod kay nagduol ang mga tawo kanako sa pagpakisayod sa kabubut-on sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kon adunay ginalalisan ang mga tawo, ginadala nila kini kanako, ug ako ang naghukom kon kinsay husto kanila. Ug ginatudloan ko sila sa mga tulomanon ug mga kasugoan sa Dios.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Miingon si Jetro, “Dili husto ang imong pamaagi sa paghimo niini. ");
INSERT INTO cebocb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Gilisod-lisod mo lang pag-ayo ang imong kaugalingon ug kining mga tawo. Bug-at ra kaayo kini alang kanimo; dili mo kini mahimo nga mag-inusara lang. ");
INSERT INTO cebocb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Paminaw kanako kay tambagan ka nako, ug hinaut pa nga ubanan ka sa Dios. Padayona ang imong ginahimo nga pagduol sa Dios alang sa mga tawo. Dad-a ang ilang mga kaso kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Padayona usab ang imong pagtudlo kanila sa mga tulomanon ug mga kasugoan sa Dios. Tudloi sila kon unsaon pagkinabuhi ug kon unsay angay nilang himuon. ");
INSERT INTO cebocb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Apan pagpili ug mga tawo nga motabang kanimo. Kinahanglan aduna silay katakos sa paghukom, adunay kahadlok sa Dios, kasaligan, ug dili modawat ug suborno. Himoa sila nga mga pangulo sa grupo sa mga tawo nga tagsa ka libo, tag-gatos, tag-singkwenta, ug tag-napulo. ");
INSERT INTO cebocb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mag-alagad sila ingon nga maghuhukom sa tanang panahon. Sila ang mohusay sa simple nga mga kaso, apan ang lisod nga mga kaso dad-on nila kanimo. Niining paagiha, magaan-gaanan ang imong trabaho ug makatabang sila kanimo. ");
INSERT INTO cebocb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nasayod ako nga mao kini ang gusto sa Dios nga imong himuon, ug kon tumanon mo kini dili ka malisdan. Ug kining mga tawhana makapauli nga malinawon.” ");
INSERT INTO cebocb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Gituman ni Moises ang gitambag kaniya sa iyang ugangan. ");
INSERT INTO cebocb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nagpili siya gikan sa mga Israelinhon ug mga tawo nga adunay katakos nga magdumala, ug gihimo niya sila nga mga maghuhukom sa grupo sa mga tawo nga 1,000, 100, 50, ug 10. ");
INSERT INTO cebocb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nag-alagad sila sa mga tawo ingon nga mga maghuhukom sa tanang panahon. Sila ang naghusay sa simple nga mga kaso, apan ang lisod nga mga kaso ginadala nila kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Unya, gipabalik ni Moises ang iyang ugangan ngadto sa iyang kaugalingong nasod. ");
INSERT INTO cebocb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Mibiya ang mga Israelinhon sa Refidim ug miadto sa kamingawan sa Sinai. Didto sila nagkampo atubangan sa bukid. Ikatulo kadto nga bulan sukad sa pagbiya nila sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mitungas si Moises sa bukid aron makigkita sa Dios. Mitawag ang Ginoo kaniya gikan sa bukid ug miingon, “Mao kini ang imong isulti sa mga Israelinhon nga kaliwat ni Jacob: ");
INSERT INTO cebocb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nakita ninyo mismo ang gihimo ko sa mga Ehiptohanon ug kon giunsa ko kamo pagdala dinhi kanako, sama sa pagdala sa usa ka agila sa iyang mga piso diha sa iyang mga pako. ");
INSERT INTO cebocb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kon tumanon ninyo ako sa hingpit ug mosunod sa akong kasabotan, mahimo kamong akong katawhan nga pinili gikan sa tanang mga nasod. Akoy tag-iya sa tibuok kalibotan, ");
INSERT INTO cebocb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ug kamo mahimong usa ka gingharian sa mga pari ug usa ka nasod nga gilain alang kanako. Mao kini ang isulti ngadto sa mga Israelinhon.” ");
INSERT INTO cebocb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Busa milugsong si Moises sa bukid ug gipatawag niya ang mga tigdumala sa mga Israelinhon ug gisultihan niya sila sa giingon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Unya nagdungan silang tanan sa pagtubag, “Tumanon namo ang tanang gisugo sa Ginoo.” Ug gisulti ni Moises sa Ginoo ang tubag sa mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Miingon ang Ginoo kang Moises, “Moanha ako kanimo pinaagi sa bagang panganod aron makadungog ang mga tawo samtang makigsulti ako kanimo. Ug unya kanunay silang motuo kanimo.” Gisulti ni Moises sa Ginoo ang tubag sa mga tawo, ");
INSERT INTO cebocb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ug miingon ang Ginoo kaniya, “Adtoa ang mga tawo ug ingna sila nga manghinlo sila sa ilang kaugalingon karon ug ugma. Kinahanglan labhan nila ang ilang mga bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Siguroha nga andam sila sa ikatulong adlaw, kay nianang adlawa, ako, ang Ginoo, mokunsad sa Bukid sa Sinai ug makita ako sa tanang mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pagbutang ug mga utlanan libot sa bukid alang sa mga tawo. Ingna sila nga dili gayod sila motungas sa bukid o moduol sa tiilan niini. Si bisan kinsa nga mopaduol sa bukid patyon gayod, ");
INSERT INTO cebocb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","tawo man o hayop. Kinahanglan patyon gayod siya pinaagi sa pagbato o pagpana, ug dili hikapon. Kon patingogon na ug dugay ang budyong, mahimo nang motungas sa bukid ang mga tawo.” ");
INSERT INTO cebocb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Milugsong si Moises sa bukid ug gisugo niya ang mga tawo nga manghinlo sa ilang kaugalingon. Ug gilabhan sa mga tawo ang ilang mga bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Miingon si Moises kanila, “Pangandam kamo sa inyong kaugalingon alang sa ikatulong adlaw; ayaw una kamo pagpakighilawas sa inyong asawa.” ");
INSERT INTO cebocb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Pagkabuntag sa ikatulong adlaw, nagdalogdog ug nagpangilat, ug adunay bagang panganod nga mitabon sa bukid, ug madungog ang makusog kaayo nga tingog sa budyong. Nangurog sa kahadlok ang tanang mga tawo nga didto sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Unya gidala ni Moises ang mga tawo ngadto sa gawas sa kampo sa pagpakigkita sa Dios, ug nanindog sila sa tiilan sa bukid. ");
INSERT INTO cebocb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Naputos sa aso ang tibuok Bukid sa Sinai kay mikunsad didto ang Ginoo sa dagway sa kalayo. Miulbo ang aso nga daw sa gaulbo nga aso gikan sa hurnohan ug natay-og pag-ayo ang bukid, ");
INSERT INTO cebocb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ug nagkakusog pa gayod ang tingog sa budyong. Unya misulti si Moises ug mitubag ang Dios kaniya pinaagi sa dalogdog. ");
INSERT INTO cebocb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mikunsad ang Ginoo ibabaw sa Bukid sa Sinai, ug gisultihan niya si Moises nga motungas ngadto sa ibabaw sa Bukid. Busa mitungas si Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ug miingon ang Ginoo kaniya, “Lugsong pagbalik ug pasidan-i ang mga tawo nga dili sila molapas sa mga utlanan libot sa bukid sa pagtan-aw kanako. Kay kon himuon nila kana, daghan kanila ang mangamatay. ");
INSERT INTO cebocb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Bisan ang mga pari nga nagduol kanunay sa akong presensya kinahanglan nga manghinlo sa ilang kaugalingon, kay kon dili, silotan ko usab sila.” ");
INSERT INTO cebocb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Miingon si Moises sa Ginoo, “Dili makatungas sa Bukid sa Sinai ang mga tawo, kay gipasidan-an mo na kami, ‘Pagbutang ug utlanan palibot sa bukid ug isipa kini nga balaan.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Miingon ang Ginoo kaniya, “Lugsong ug dad-a si Aaron dinhi. Apan ang mga pari ug ang mga tawo kinahanglan dili moanhi dinhi kanako. Kay kon moanhi sila dinhi, silotan ko gayod sila.” ");
INSERT INTO cebocb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Busa milugsong si Moises ug giingnan ang mga tawo sa giingon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Unya miingon ang Dios: ");
INSERT INTO cebocb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ako ang Ginoo nga inyong Dios nga nagpagawas kaninyo gikan sa Ehipto diin kamo giulipon. ");
INSERT INTO cebocb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ayaw kamo pagsimba ug laing dios gawas kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ayaw kamo paghimo ug mga dios-dios sa dagway sa bisan unsa nga anaa sa langit, o sa yuta, o sa tubig. ");
INSERT INTO cebocb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ayaw gayod ninyo kini alagari o simbaha, kay ako, ang Ginoo nga inyong Dios, abughoan. Dili ako gusto nga aduna kamoy lain nga simbahon. Silotan ko ang mga nakasala kanako apil ang ilang mga kaliwat hangtod sa ikatulo ug ikaupat nga henerasyon nga nagsalikway kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Apan gipakita ko ang akong paghigugma ngadto sa daghan kaayong henerasyon nga naghigugma kanako ug nagtuman sa akong mga sugo. ");
INSERT INTO cebocb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ayaw ninyo gamita ang akong ngalan sa walay kapuslanan kay ako ang Ginoo nga inyong Dios, magsilot kang bisan kinsa nga mogamit sa akong ngalan sa walay kapuslanan. ");
INSERT INTO cebocb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Hinumdomi ninyo ang Adlaw nga Igpapahulay, ug himoa ninyo kini nga pinasahi nga adlaw alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Magtrabaho kamo sulod sa unom ka adlaw, ");
INSERT INTO cebocb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","apan ang ikapito nga adlaw, ang Adlaw nga Igpapahulay, inyong igahin alang kanako, ang Ginoo nga inyong Dios. Ayaw kamo pagtrabaho niining adlawa apil ang inyong mga anak, mga ulipon, kahayopan, o ang mga langyaw nga nagpuyo sa inyong mga lungsod. ");
INSERT INTO cebocb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kay sulod sa unom ka adlaw gimugna sa Ginoo ang langit, ang yuta, ang dagat, ug ang tanang anaa niini, apan mipahulay siya sa ikapitong adlaw. Busa gipanalanginan sa Ginoo ang Adlaw nga Igpapahulay ug gihimo kini nga pinasahi nga adlaw alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tahora ninyo ang inyong amahan ug inahan aron magkinabuhi kamo ug dugay diha sa yuta nga gihatag sa Ginoo nga inyong Dios kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ayaw kamo pagpatay. ");
INSERT INTO cebocb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ayaw kamo panapaw. ");
INSERT INTO cebocb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ayaw kamo pangawat. ");
INSERT INTO cebocb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ayaw kamo pagsaksi ug bakak batok sa inyong isigka-tawo. ");
INSERT INTO cebocb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ayaw kamo kaibog sa balay sa inyong isigka-tawo, o sa iyang asawa, mga ulipon, mga baka o asno, o sa bisan unsa nga anaa kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Sa dihang nadungog sa mga tawo ang dalogdog ug ang tingog sa budyong, ug sa dihang nakita nila ang kilat ug ang bukid nga gaaso, nangurog sila sa kahadlok. Mitindog sila sa layo-layo ");
INSERT INTO cebocb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ug miingon kang Moises, “Ikaw na lay makigsulti kanamo kay maminaw kami, dili lang ang Dios kay basin mamatay kami.” ");
INSERT INTO cebocb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Busa miingon si Moises sa mga tawo, “Ayaw kamo kahadlok, kay mianhi dinhi ang Dios sa pagpakita sa iyang gahom kaninyo aron magbaton kamo ug kahadlok kaniya ug dili magpakasala.” ");
INSERT INTO cebocb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Sa gihapon nagpabilin ang mga tawo sa pagtindog sa layo-layo samtang si Moises miduol sa bagang panganod diin atua ang Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Unya miingon ang Ginoo kang Moises, “Isulti kini sa mga Israelinhon: Nakita ninyo nga nakigsulti ako kaninyo gikan sa langit. ");
INSERT INTO cebocb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Busa ayaw kamo paghimog mga dios nga plata o bulawan aron simbahon uban kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Paghimo kamog halaran nga yuta alang kanako ug diha ninyo ihalad ang inyong mga karnero, mga kanding, ug mga baka ingon nga halad nga sinunog ug halad alang sa maayong relasyon. Himoa ninyo kini sa dapit nga akong pilion diin ako pagasimbahon, ug didto adtoan ko kamo ug panalanginan. ");
INSERT INTO cebocb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kon maghimo kamog halaran nga bato alang kanako ayaw ninyo kinig sapsapi, kay kon gamitan ninyo kinig gamit nga pangsapsap, dili na kini takos nga gamiton sa paghalad kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ug ayaw usab kamo paghimog halaran nga adunay hagdanan kay basin malili-an kamo inigsaka ninyo niini.” ");
INSERT INTO cebocb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Mao kini ang mga lagda nga ipatuman mo sa mga Israelinhon: ");
INSERT INTO cebocb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Kon magpalit kamog ulipon nga Hebreohanon, mag-alagad siya kaninyo sulod sa unom ka tuig. Apan sa ikapitong tuig aduna na siyay kagawasan ug wala siyay bayronon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kon sa inyong pagpalit kaniya ulitawo pa siya, ulitawo gihapon siya nga mogawas. Apan kon aduna na siyay asawa sa panahon sa pagpalit ninyo kaniya, ang iyang asawa mahimong gawasnon usab uban kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kon gipaminyo siya sa iyang agalon ug nakaanak sila sa iyang asawa, gawasnon siya sa ikapitong tuig, apan ang iyang asawa ug mga anak magpabilin sa iyang agalon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Apan kon moingon gayod ang ulipon nga gihigugma niya ang iyang agalon, ang iyang asawa ug mga anak, ug dili niya gusto nga mahimong gawasnon, ");
INSERT INTO cebocb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","dad-on siya sa iyang agalon sa presensya sa Dios. Ug didto sa pultahan tusokan sa iyang agalon ang iyang dalunggan nga nakapaod sa pultahan, ug mahimo na siyang ulipon sa iyang agalon hangtod sa hangtod. ");
INSERT INTO cebocb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kon ibaligya sa usa ka tawo ang iyang anak nga babaye isip usa ka ulipon, dili kini mahimong mahatagan ug kagawasan sa ikapito nga tuig sama sa mga lalaking ulipon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kon wala siya maangayi sa agalon nga nagpalit kaniya, mahimo siyang lukaton. Apan dili siya mahimong ibaligya sa iyang agalon ngadto sa mga langyaw, tungod kay wala man motuman ang agalon sa iyang responsibilidad. ");
INSERT INTO cebocb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kon ipaminyo sa agalon kini nga ulipon sa iyang anak, kinahanglang isipon niya kini nga iyang anak nga babaye. ");
INSERT INTO cebocb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kon pangasaw-on niya kini nga ulipon, apan mangasawa pa gayod siya ug lain, kinahanglan padayonon niya ang iyang paghatag niini ug pagkaon, bisti, ug ang pagdulog kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kon dili niya mahatag kining tulo ka butang, mahimong mohawa kana nga babaye nga walay bayronon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Si bisan kinsa nga mangulata ug tawo hinungdan nga mamatay kini, kinahanglang patyon usab. ");
INSERT INTO cebocb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Apan kon wala niya tuyoa ug gitugot ko kini nga mahitabo, maggahin ako ug dapit nga iyang katagoan. ");
INSERT INTO cebocb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Apan kon giplano niya ug gituyo ang pagpatay, bisan pag nagpaduol siya sa akong halaran kuhaa siya ug patya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Si bisan kinsa nga mangulata sa iyang amahan o inahan kinahanglang patyon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Si bisan kinsa nga mangdagit ug tawo kinahanglang patyon, bisan kon gibaligya na niya kini o makit-an kini uban kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Si bisan kinsa nga manunglo sa iyang amahan o inahan kinahanglang patyon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Pananglit, nag-away ang duha ka tawo, unya gisumbag sa usa o gibunalan ug bato ang iyang kontra ug dili na kini makabangon apan wala ra mamatay, ");
INSERT INTO cebocb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ang tawo nga nakapasakit dili silotan kon ang tawo nga nasamdan nakabangon ra pag-usab ug nakalakaw-lakaw bisan pag nagsungkod na kini. Apan kinahanglang bayran sa nakasala ang panahon niini nga nausik tungod sa iyang pagluya, ug atimanon niya kini hangtod nga maayo sa hingpit. ");
INSERT INTO cebocb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kon gibunalan sa usa ka tawo ang iyang ulipon, lalaki man o babaye, hinungdan sa pagkamatay niini, kinahanglan silotan siya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Apan kon wala mamatay ang ulipon ug maulian ra kini paglabay sa usa o duha ka adlaw, dili siya silotan kay siya man ang tag-iya sa ulipon. ");
INSERT INTO cebocb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kon adunay mag-away ug unya naigo nila ang usa ka babayeng mabdos, ug nakaanak kinig ahat, apan wala ray daotang nahitabo kaniya, ang nakaigo pabayron sumala sa kantidad nga pangayoon sa bana basi sa gitugot sa mga maghuhukom. ");
INSERT INTO cebocb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Apan kon grabe ang kadaot nga nahiagoman sa babaye, silotan ang nakaigo basi usab sa nahitabo sa babaye. Kon namatay ang babaye, patyon usab siya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Kon nabuta, butahan usab siya. Kon napangag, pangagan usab siya. Kon nabali ang kamot o tiil, balian usab siya sa iyang kamot o tiil. ");
INSERT INTO cebocb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Kon napaso, pasoan usab siya. Kon nasamad, samaran usab siya. Ug kon nabun-og, bun-ogon usab siya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kon gisumbag sa agalon ang mata sa iyang ulipon, lalaki man o babaye, unya nabuta kini, hatagan niya ug kagawasan ang ulipon ingon nga bayad sa iyang pagkabuta. ");
INSERT INTO cebocb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kon natangtang ang ngipon sa iyang ulipon, lalaki man o babaye, hatagan usab niya ug kagawasan ang ulipon ingon nga bayad sa ngipon nga natangtang. ");
INSERT INTO cebocb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kon adunay torong baka nga makasungay ug tawo, lalaki man o babaye, unya namatay kini, kinahanglan nga batohon ang baka hangtod mamatay, ug dili kan-on ang unod niini, apan ang tag-iya sa baka walay tulubagon niini. ");
INSERT INTO cebocb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Apan kon ang baka daan na nga gapanungag ug tawo ug gipasidan-an na ang tag-iya bahin niini, apan gipasagdan lang niya ang baka, ug nakapatay kini ug tawo, kinahanglan nga batohon kini hangtod mamatay ug ang tag-iya niini patyon usab. ");
INSERT INTO cebocb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Apan kon pabayron na lang ang tag-iya aron dili siya patyon, kinahanglan nga mobayad siya sa kantidad nga pangayoon gikan kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mao gihapon kini ang lagda nga sundon kon makasungay ang baka ug bata, lalaki man o babaye. ");
INSERT INTO cebocb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kon makasungay ang baka ug ulipon, lalaki man o babaye, kinahanglang magbayad ang tag-iya niini ug 30 kabuok nga pilak sa agalon sa ulipon, ug kinahanglan nga batohon ang baka hangtod mamatay. ");
INSERT INTO cebocb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Pananglit, adunay tawo nga nagkuha sa tabon sa atabay o naghimog atabay ug wala niya kini taboni, ug adunay nahulog nga baka o asno sa maong atabay, ");
INSERT INTO cebocb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","bayran sa tag-iya sa atabay ang tag-iya sa mananap, ug maiya na ang patay nga mananap. ");
INSERT INTO cebocb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kon ang baka sa usa ka tawo nakapatay ug baka sa laing tawo, ibaligya nila ang buhing baka ug tungaon nila ang halin niini. Bahinon usab nila ang karne sa namatay nga baka. ");
INSERT INTO cebocb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Apan kon ang baka nga nakapatay daan na nga gapanungag ug gipasagdan lang kini sa tag-iya, kinahanglang magbayad ang tag-iya niini ug usa ka baka ilis sa namatay, ug iyahon na ang patay nga baka. ");
INSERT INTO cebocb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kon ang usa ka tawo nasakpan nga nangawat ug baka o karnero, unya giihaw niya kini o gibaligya, kinahanglan nga magbayad siya. Sa usa ka baka nga iyang gikawat, magbayad siyag lima ka baka. Ug sa usa ka karnero nga iyang gikawat, magbayad siyag upat ka karnero. ");
INSERT INTO cebocb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Kon sa gabii siya nangawat ug nadakpan siya sa akto, unya gipatay siya, ang nakapatay kaniya walay tulubagon. ");
INSERT INTO cebocb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Apan kon nahitabo kini sa adlaw, ang nakapatay sa kawatan adunay tulubagon. “Ang kawatan nga madakpan kinahanglan magbayad sa iyang gikawat. Apan kon wala siyay ikabayad, ibaligya siya ingon nga ulipon ug ang iyang bili ibayad sa iyang gikawat. ");
INSERT INTO cebocb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kon ang iyang gikawat nga baka, o asno, o karnero makaplagan nga buhi diha kaniya, bayran niya kinig doble. ");
INSERT INTO cebocb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kon ang mananap sa usa ka tawo iyang gipasabsab o gibuhian sa uma o sa ubasan sa ubang tawo, kinahanglang bayran niya ang nasabsab nga tanom sa pinakamaayong klasi sa abot sa iyang uma o ubasan. ");
INSERT INTO cebocb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kon adunay tawo nga magdaob, unya ang kalayo mikuyanap sa mga sagbot ug ngadto sa mga tanom sa uma sa ubang tawo, kinahanglang bayran sa nagdaob ang mga tanom nga nangadaot. ");
INSERT INTO cebocb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Pananglit gipatipigan sa usa ka tawo ang iyang kuwarta o ang bisan unsa nga butang didto sa balay sa iyang silingan ug unya gikawat kini, kon madakpan ang kawatan, kinahanglan magbayad siyag doble. ");
INSERT INTO cebocb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Apan kon dili madakpan ang kawatan, ang gibilinan dad-on sa presensya sa Dios, aron mahibaloan kon siya ba ang nagkuha niini o dili. ");
INSERT INTO cebocb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Pananglit, adunay duha ka tawo nga maglalis kon kinsa kanila ang tag-iya sa usa ka butang sama sa baka, asno, karnero, bisti, o bisan unsa nga butang, kinahanglan dad-on nila ang ilang kaso atubangan sa Dios. Ang tawo nga hukman sa Dios nga sad-an, magbayad ug doble sa tinuod nga tag-iya niini. ");
INSERT INTO cebocb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Pananglit, gipaalimahan sa usa ka tawo ang iyang asno, baka, karnero, o bisan unsang mananap ngadto sa iyang silingan, unya namatay kini, o nasamdan, o nawala, o gikuha nga walay nakakita sa panghitabo, ");
INSERT INTO cebocb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ang nag-alima kinahanglan moadto sa presensya sa Ginoo ug manumpa nga wala siyay sala sa nahitabo. Kinahanglan tuohan kini sa tag-iya, ug dili niya kini pabayron. ");
INSERT INTO cebocb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Apan kon gikawat ang mananap, kinahanglan mobayad ang nag-alima ngadto sa tag-iya. ");
INSERT INTO cebocb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kon ang mananap gipatay sa mabangis nga mananap, kinahanglang dad-on niya ang nahibilin nga bahin sa mananap ingon nga ebidensya, ug dili niya kini kinahanglang bayran. ");
INSERT INTO cebocb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Kon manghulam ang usa ka tawo ug mananap sa iyang isigka-tawo unya nasamad kini o namatay ug wala diha ang tag-iya sa pagkahitabo niini, ang nanghulam kinahanglan mobayad niini. ");
INSERT INTO cebocb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Apan kon anaa ang tag-iya sa pagkahitabo, ang nanghulam dili na mobayad. Kon giabangan ang mananap, ang kuwarta nga gibayad sa pag-abang mao na ang bayad sa nasamad o namatay nga mananap. ");
INSERT INTO cebocb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Kon tintalon sa usa ka lalaki ang usa ka dalaga nga dili pa kaslonon, unya makighilawas siya kaniya, kinahanglan mobayad ang lalaki sa pamilya sa babaye sa kantidad nga ilang pangayoon, ug pakaslan niya ang babaye. ");
INSERT INTO cebocb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kon dili gayod mosugot ang amahan sa babaye nga ipakasal ang iyang anak sa maong lalaki, mobayad gihapon ang lalaki sa kantidad nga ilang pangayoon. ");
INSERT INTO cebocb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Patya ninyo ang mga mamamarang. ");
INSERT INTO cebocb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Si bisan kinsa nga makighilawas sa mananap kinahanglang patyon. ");
INSERT INTO cebocb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Si bisan kinsa nga maghalad ngadto sa ubang mga dios gawas kanako laglagon sa hingpit. ");
INSERT INTO cebocb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ayaw ninyo daog-daoga ang mga dumuduong kay mga dumuduong usab kamo kaniadto sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Ayaw ninyo daog-daoga ang mga biyuda ug ang mga ilo. ");
INSERT INTO cebocb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kon himuon ninyo kini ug unya magpakitabang sila kanako, sigurado gayod nga tabangan ko sila. ");
INSERT INTO cebocb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Masuko gayod ako kaninyo ug pamatyon ko kamo sa gira. Mabalo ang inyong mga asawa ug mailo ang inyong mga anak. ");
INSERT INTO cebocb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kon magpahulam kamog kuwarta kang bisan kinsa sa akong katawhan nga kabos nga nagpuyo uban kaninyo, ayaw ninyo kini patuboi sama sa ginahimo sa mga tigpahulam ug kuwarta. ");
INSERT INTO cebocb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kon kuhaon ninyo ang kupo sa inyong isigka-tawo ingon nga garantiya sa iyang utang kanimo, iuli kini kaniya sa dili pa mosalop ang adlaw, ");
INSERT INTO cebocb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kay mao lang kana ang iyang itabon sa iyang lawas kon matulog siya inigkagabii. Kon dili ninyo kini iuli, ug unya magpakitabang siya kanako, tabangan ko siya kay maluloy-on man ako. ");
INSERT INTO cebocb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ayaw ninyo pasipalahi ang Dios ug ayaw ninyo panghimaraota ang inyong pangulo. ");
INSERT INTO cebocb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ayaw ninyo kalimti ang paghatag ug mga halad kanako gikan sa inyong mga abot, mga bino, ug mga lana. “Ihalad ninyo kanako ang inyong kamagulangang anak nga lalaki, ");
INSERT INTO cebocb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ug ang unang anak nga laki sa inyong mga baka ug mga karnero. Ang bag-ong natawo nga baka o karnero kinahanglan magpabilin sa iyang inahan sulod sa pito ka adlaw. Apan sa ikawalo ka adlaw, mahimo na kining ihalad kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Kamo ang akong piniling katawhan, busa ayaw kamo pagkaon ug karne sa bisan unsang mananap nga gipatay sa mabangis nga mananap. Ipakaon ninyo kini sa mga iro. ");
INSERT INTO cebocb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ayaw kamo pagbalita ug bakak. Ayaw kamo pagtabang sa daotang tawo pinaagi sa pagsaksi ug bakak. ");
INSERT INTO cebocb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Ayaw ninyo sunda ang kadaghanan nga naghimo ug daotan. Kon magsaksi kamo sa korte, ayaw ninyo tuisa ang hustisya aron lang masunod ang kadaghanan. ");
INSERT INTO cebocb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ayaw ninyo pabori ang kabos sa iyang kaso tungod lang sa iyang kakabos. ");
INSERT INTO cebocb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kon makita ninyo nga nakabuhi ang baka o asno sa inyong kaaway, kinahanglang iuli ninyo kini kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kon makita ninyo nga natumba ang asno sa inyong kaaway tungod sa kabug-at sa karga niini, ayaw ninyo kini pasagdi; tabangi ninyo kini nga makatindog. ");
INSERT INTO cebocb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Siguradoha nga matagaag hustisya ang mga kabos sa ilang kaso. ");
INSERT INTO cebocb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ayaw kamo pagpang-akusar ug bakak. Ayaw ninyo patya ang usa ka tawong matarong o inosente, kay silotan ko si bisan kinsa nga mohimo niini. ");
INSERT INTO cebocb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ayaw kamo pagdawat ug suborno, kay ang suborno makapabuta sa usa ka tawo ngadto sa kamatuoran ug makapatuis sa hustisya nga alang sa mga inosente. ");
INSERT INTO cebocb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Ayaw ninyo daog-daoga ang mga dumuduong, kay kamo mismo nasayod kon unsa ang bation sa usa ka dumuduong, kay mga dumuduong usab kamo kaniadto sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Sulod sa unom ka tuig makatanom kamo diha sa inyong yuta ug makaani sa abot niini. ");
INSERT INTO cebocb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Apan sa ikapitong tuig ayaw ninyo kinig tamni. Kon adunay motubo nga tanom, pasagdi ninyo ang mga kabos nga manguha sa ilang pagkaon gikan niini, ug ang mahibilin ipakaon sa mga ihalas nga mananap. Mao usab kini ang inyong himuon sa inyong mga ubasan ug mga olibo. ");
INSERT INTO cebocb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Pagtrabaho kamo sulod sa unom ka adlaw, apan sa ikapitong adlaw mopahulay kamo, aron makapahulay usab ang inyong mga baka ug mga asno, lakip ang inyong mga ulipon ug ang mga langyaw nga nagpuyo uban kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Tumana ninyo pag-ayo kining tanan nga akong giingon kaninyo. Ayaw kamo pag-ampo sa ubang mga dios ni mohisgot o molitok sa ilang ngalan. ");
INSERT INTO cebocb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Magsaulog kamog tulo ka pista matag tuig alang sa pagpasidungog kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Sauloga ninyo ang Pista sa Pan nga Walay Patubo. Sumala sa gisugo ko na kaninyo, mokaon kamo ug pan nga walay patubo sulod sa pito ka adlaw. Himoa ninyo kini sa gitakda nga panahon sa bulan sa Abib, kay mao kanang bulana nga mibiya kamo sa Ehipto. Ang kada usa kinahanglan magdala kanakog halad nianang panahona. ");
INSERT INTO cebocb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Sauloga usab ninyo ang Pista sa Ting-ani pinaagi sa pagdala kanako sa unang abot sa inyong mga uma. Sauloga usab ninyo ang Pista sa Kataposang Ani sa kataposan sa tuig, inigtigom ninyo sa mga abot sa inyong mga uma. ");
INSERT INTO cebocb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ang tanan ninyong mga lalaki kinahanglang motambong niini nga mga pista kada tuig aron sa pagsimba kanako, ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Ayaw ninyo ihalad kanako ang dugo uban sa pan nga adunay patubo. Ayaw ninyo paabtig buntag ang tambok sa mananap nga inyong gihalad kanako sa pista. ");
INSERT INTO cebocb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Dad-a ninyo sa balay sa Ginoo nga inyong Dios ang labing maayong bahin sa inyong unang abot. “Ayaw ninyo lutoa ang nating kanding sa gatas sa iyang inahan. ");
INSERT INTO cebocb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Karon, magpadala ako ug anghel sa pagbantay kaninyo ug sa paggiya kaninyo ngadto sa dapit nga giandam ko. ");
INSERT INTO cebocb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pamati kamo kaniya ug tumana ang iyang isulti. Ayaw kamo pagsupak kaniya. Kay ang tanan niyang himuon, himuon niya sa akong ngalan ug dili niya baliwalaon ang inyong mga sala. ");
INSERT INTO cebocb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kon mamati kamo pag-ayo sa iyang isulti ug buhaton ninyo ang tanan kong gisulti, makig-gira ako sa inyong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mag-una kaninyo ang akong anghel ug dad-on niya kamo ngadto sa yuta sa mga Amorihanon, Hitihanon, Perisihanon, Canaanhon, Hibihanon, ug Jebusihanon, ug laglagon ko sila. ");
INSERT INTO cebocb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ayaw kamo pagsimba o pag-alagad sa ilang mga dios, o pagsunod sa ilang mga ginahimo. Laglaga ninyo sa hingpit ang ilang mga dios, ug lumpaga ang ilang mga handomanan nga bato. ");
INSERT INTO cebocb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Simbaha ninyo ako, ang Ginoo nga inyong Dios, ug hatagan ko kamo ug abundansyang pagkaon ug tubig. Walay sakit nga motakboy kaninyo, ");
INSERT INTO cebocb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ug walay babaye nga makuhaan sa iyang gimabdos o mahimong baog diha sa inyong yuta, ug hatagan ko kamog taas nga kinabuhi. ");
INSERT INTO cebocb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Hadlokon ko ug patarantahon ang inyong mga kaaway nga inyong ikaatubang ug mangikyas sila gikan kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Magpadala akog mga tamboboan nga mag-una kaninyo, ug abugon nila ang mga Hibihanon, Canaanhon, ug mga Hitihanon. ");
INSERT INTO cebocb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Apan dili ko sila abugon sulod lang sa usa ka tuig aron dili mahimong awaaw ang maong yuta ug aron dili modaghan ang ihalas nga mananap didto. ");
INSERT INTO cebocb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Abugon ko sila sa hinay-hinay hangtod nga modaghan kamo ug mahimo na nga makapanag-iya sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Siguradohon ko nga ang utlanan sa inyong mga yuta maggikan sa Pulang Dagat hangtod sa Dagat sa Mediteraneo, ug gikan sa disyerto sa habagatan hangtod sa Suba sa Eufrates. Itugyan ko kaninyo ang mga tawo nga namuyo sa maong yuta ug abugon ninyo sila. ");
INSERT INTO cebocb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ayaw kamo paghimog kasabotan kanila o sa ilang mga dios. ");
INSERT INTO cebocb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ayaw ninyo sila tugoti nga mopuyo sa inyong yuta kay basin sila pa ang motukmod kaninyo sa pagpakasala batok kanako. Kay kon mosimba kamo sa ilang mga dios, sigurado nga mahimo kining laang alang kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Unya miingon ang Ginoo kang Moises, “Tungas dinhi kanako, ug ubana si Aaron, Nadab, Abihu, ug ang 70 sa mga tigdumala sa Israel. Magsimba sila kanako didto sa layo-layo. ");
INSERT INTO cebocb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ikaw lang Moises ang makaduol kanako, ang uban dili makaduol. Ug ang mga tawo dili gayod mahimong motungas dinhi uban kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Sa dihang gisultihan ni Moises ang mga tawo sa tanang gitudlo ug gisugo sa Ginoo, nagdungan sila sa pagtubag, “Tumanon namo ang tanang giingon sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Unya gisulat ni Moises ang tanan nga giingon sa Ginoo. Sayo pa kaayo pagkasunod adlaw, mibangon si Moises ug nagtukod ug halaran sa tiilan sa bukid ug nagbutang siyag 12 ka handomanan nga bato nga nagrepresentar sa 12 ka tribo sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Unya nagsugo siyag mga batan-ong lalaki nga maghalad sa Ginoo ug mga halad nga sinunog ug mga torong baka isip halad alang sa maayong relasyon. ");
INSERT INTO cebocb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Gikuha ni Moises ang katunga sa dugo ug gibutang kini sa mga palanggana, ug ang katunga gisablig niya sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Unya gikuha niya ang Libro sa Kasabotan ug gibasa kini ngadto sa mga tawo. Ug mitubag ang mga tawo, “Tumanon namo ang tanang giingon sa Ginoo. Sundon namo siya.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Unya gikuha ni Moises ang dugo nga anaa sa mga palanggana ug gisablig kini ngadto sa mga tawo ug miingon, “Mao kini ang dugo nga nagpalig-on sa kasabotan nga gihimo sa Ginoo uban kaninyo sa paghatag niya niining tanang mga sugo.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mitungas sa bukid si Moises, Aaron, Nadab, Abihu, ug ang 70 sa mga tigdumala sa Israel, ");
INSERT INTO cebocb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ug unya nakita nila ang Dios sa Israel. Sa iyang tiilan adunay daw dalan nga hinimo sa bato nga sapiro nga sama katin-aw sa langit. ");
INSERT INTO cebocb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Bisan nakita niining mga tigdumala ang Dios, wala sila patya sa Dios. Mikaon pa gani sila ug nanginom didto sa presensya sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Unya miingon ang Ginoo kang Moises, “Tungas dinhi kanako ibabaw sa bukid ug paghulat, kay ihatag ko kanimo ang lagpad nga mga bato nga akong gisulatan sa akong mga sugo ug mga balaod alang sa mga tawo.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Busa nanglakaw si Moises ug ang iyang personal nga katabang nga si Josue ug mitungas si Moises sa bukid sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Sa wala pa siya mitungas, miingon si Moises sa mga tigdumala sa Israel, “Hulat kamo dinhi hangtod makabalik kami. Mahibilin dinhi uban kaninyo si Aaron ug si Hur, ug kon aduna kamoy problema, dangop lang kamo kanila.” ");
INSERT INTO cebocb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Pag-abot ni Moises sa ibabaw nga bahin sa bukid, gitabonan sa panganod ang bukid. ");
INSERT INTO cebocb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Unya ang gamhanang presensya sa Ginoo mikunsad sa Bukid sa Sinai. Ug sulod sa unom ka adlaw natabonan sa panganod ang bukid. Sa ikapitong adlaw, gikan sa panganod, gitawag sa Ginoo si Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","18","Busa misulod si Moises sa panganod ug mitungas pa gayod siya ibabaw sa bukid. Nagpabilin siya didto sulod sa 40 ka adlaw ug 40 ka gabii. Sa panan-aw sa mga Israelinhon nga atua sa ubos, ang gamhanang presensya sa Ginoo ibabaw sa bukid daw sa nagdilaab nga kalayo. ");
INSERT INTO cebocb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ingna ang mga Israelinhon nga maghalad sila kanako. Ikaw mao ang modawat sa mga halad nga kinasing-kasing nilang ihalad kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Mao kini ang mga halad nga imong dawaton gikan kanila: “bulawan, plata, bronsi, ");
INSERT INTO cebocb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","hilo nga kolor ube, asul ug pula, lino, panapton nga hinimo gikan sa balhibo sa kanding, ");
INSERT INTO cebocb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","panit sa laking karnero nga gitina ug pula, maayong klasi sa panit, kahoyng akasya, ");
INSERT INTO cebocb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lana sa olibo alang sa suga, mga lamas alang sa lana nga pangdihog ug alang sa humot nga insenso, ");
INSERT INTO cebocb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ug bato nga onix ug uban pang mahalong mga bato nga gamiton sa efod ug sa mga bulsa-bulsa sa sapaw sa dughan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ug pahimoa ang katawhan sa Israel ug balaang puloy-anan alang kanako, diin ako magpuyo uban kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ipahimo kini nga Tolda nga Pagsimbahan ug ang tanang kagamitan niini basi sa sumbanan nga ipakita ko kanimo. ");
INSERT INTO cebocb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Pagpahimo ug Sudlanan nga hinimo sa akasya nga 45 ka pulgada ang gitas-on, 27 ka pulgada ang gilapdon, ug 27 ka pulgada ang gihabugon. ");
INSERT INTO cebocb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Pahaklapi kinig purong bulawan sa sulod ug sa gawas, ug paribetihi ug bulawan ang mga kilid niini. ");
INSERT INTO cebocb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Pagpahimo ug upat ka bulawan nga singsing ug itaod kini sa iyang upat ka haligi. ");
INSERT INTO cebocb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Unya pagpahimo ug mga pangdayong nga akasya ug pahaklapi ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Isuot kini sa mga singsing sa kada kilid sa Sudlanan aron madayongan ang Sudlanan pinaagi niini. ");
INSERT INTO cebocb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Dili gayod kuhaon ang mga pangdayong diha sa mga singsing sa Sudlanan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Unya isulod diha sa Sudlanan ang lagpad nga mga bato, diin nasulat ang Kasugoan nga ihatag ko kanimo. ");
INSERT INTO cebocb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Pahimoi ang Sudlanan ug taklob nga purong bulawan nga 45 ka pulgada ang gitas-on ug 27 ka pulgada ang gilapdon. ");
INSERT INTO cebocb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Unya pagpahimo ug duha ka kerubin nga bulawan, ug ibutang kini sa isigka-tumoy sa tabon sa Sudlanan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kinahanglan nga ang mga pako sa kerubin nagbukhad ibabaw sa tabon aron malandongan nila kini, ug mag-atbang silang duha nga nagtan-aw ngadto sa tabon. ");
INSERT INTO cebocb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Isulod diha sa Sudlanan ang lagpad nga mga bato, diin nasulat ang Kasugoan nga ihatag ko kanimo, ug unya taboni ang Sudlanan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Makigkita ako kanimo didto taliwala sa duha ka kerubin nga anaa ibabaw sa Sudlanan sa Kasugoan, ug ihatag ko kanimo ang tanan kong mga sugo alang sa katawhan sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Pagpahimo usab ug lamisa nga akasya nga 36 ka pulgada ang gitas-on, 18 ka pulgada ang gilapdon, ug 27 ka pulgada ang gihabugon. ");
INSERT INTO cebocb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Pahaklapi kinig purong bulawan ug paribetihi ug bulawan ang mga kilid niini. ");
INSERT INTO cebocb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Pabutangi kinig sanipa sa kada kilid, nga upat ka pulgada ang gilapdon, ug paribetihi ug bulawan ang sanipa. ");
INSERT INTO cebocb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Unya pagpahimo ug upat ka bulawan nga singsing ug itaod kini sa upat ka eskina sa may tiil sa lamisa, ");
INSERT INTO cebocb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","duol sa sanipa. Dinhi ninyo isuot ang mga pangdayong sa lamisa. ");
INSERT INTO cebocb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kinahanglan nga kining mga pangdayong hinimo gikan sa akasya ug hinaklapan ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","“Pagpahimo usab ug bulawan nga mga plato, mga tasa, mga tibod, ug mga yahong nga gamiton alang sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ug kini nga lamisa kinahanglang butangan kanunay ug pan nga ginahalad sa akong presensya. ");
INSERT INTO cebocb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Pagpahimo usab ug butanganan sa suga nga purong bulawan ang tiil ug lawas niini, ug gidekorasyonan kinig mga bulak nga ang uban piyoos pa ug ang uban namukhad na. Unay sa butanganan sa suga ang mga dekorasyon niini. ");
INSERT INTO cebocb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ang butanganan sa suga kinahanglang adunay unom ka mga sanga, tag-tulo sa kada kilid. ");
INSERT INTO cebocb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ang kada sanga adunay tulo ka dekorasyon nga mga bulak nga ang korte murag almond, nga ang uban piyoos pa ug ang uban namukhad na. ");
INSERT INTO cebocb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ang lawas sa butanganan sa suga adunay upat ka dekorasyon nga mga bulak nga ang korte murag almond, nga ang uban piyoos pa ug ang uban namukhad na. ");
INSERT INTO cebocb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Adunay usa ka bulak sa ubos sa matag bahin diin magtagbo ang mga sanga. ");
INSERT INTO cebocb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ang mga dekorasyon ug ang mga sanga unay sa lawas sa butanganan sa suga sa paghimo niini gikan sa bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Unya pagpahimo ug pito ka suga alang niining maong butanganan ug ipahimutang kini sa paagi nga ang kahayag niini modan-ag sa atubangan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ang mga kimpit ug mga pangsalod sa naupos nga pabilo sa suga kinahanglan purong bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Mga 35 ka kilo nga purong bulawan ang kinahanglanon mo sa pagpahimo sa butanganan sa suga ug sa tanang kagamitan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Siguroha nga ipahimo mo kining tanan sumala gayod sa plano nga gipakita ko kanimo dinhi sa bukid. ");
INSERT INTO cebocb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Pagpahimo usab ug Tolda nga Pagsimbahan. Ang gamiton sa paghimo niini napulo ka panid nga lino nga gibordahan ug hilo nga kolor ube, asul, ug pula. Ug pabordahi kini ug kerubin sa hanas nga moborda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kinahanglan ang kada panapton adunay gitas-on nga 42 ka piye ug adunay gilapdon nga unom ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Sumpayon kini sa tinag-lima; bali duha ka tag-lima. ");
INSERT INTO cebocb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Unya pahimoi ug mga singsing nga panapton nga asul ang kilid sa matag panid sa panapton nga gisumpay; ");
INSERT INTO cebocb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","tag-50 ka mga singsing ang ibutang sa kada kilid ug kinahanglan nga magkatakdo kini. ");
INSERT INTO cebocb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Unya pagpahimo ug 50 ka kaw-it nga bulawan aron masumpay ang mga singsing sa duha ka hut-ong sa sinumpay nga mga panapton. Niining paagiha mahimo ang Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Unya pahimoi ug tabon kini nga Tolda. Ang gamiton sa paghimo niini 11 kabuok panapton nga hinimo gikan sa balhibo sa kanding. ");
INSERT INTO cebocb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kinahanglan managsama gayod ang gidak-on niining mga panapton. Ang kada usa kinahanglan adunay gitas-on nga 45 ka piye ug adunay gilapdon nga unom ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Sumpay-sumpayon ang unang lima ka panapton, ug lainon usab pagsumpay ang nabilin nga unom. Ang gisumpay nga ikaunom nga panapton, pil-on atubangan sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Pabutangi usab ug 50 ka mga singsing ang kilid sa kataposang panapton sa duha ka hut-ong sa sinumpay nga mga panapton. ");
INSERT INTO cebocb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ug pagpahimog 50 ka kaw-it nga bronsi ug ibutang sa mga singsing aron mausa ang sinumpay nga mga panapton sa tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ipabitay sa likod sa Tolda ang katunga sa sobra sa panapton, ");
INSERT INTO cebocb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ug ipabitay usab sa isigka-kilid sa Tolda ang usa ug tunga ka piye nga panapton nga sobra sa pagtabon sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ang ibabaw sa tabon sa Tolda sapawi ug panit sa laking karnero nga gitina ug pula, ug taboni pa gayod ug maayong klasi sa panit. ");
INSERT INTO cebocb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ang mga dingding sa Tolda kinahanglan tabla nga akasya. ");
INSERT INTO cebocb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ang gitas-on sa kada tabla 15 ka piye ug ang gilapdon duha ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ang kada tabla butangan ug duha ka dila-dila aron masumpay kini sa laing tabla. Kinahanglan ingon niini ang himuon sa tanang tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ang 20 niini nga mga tabla gamiton diha sa habagatang bahin sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kini nga mga tabla ipahaom diha sa 40 ka tungtonganan nga plata nga duha ka tungtonganan kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ang sa amihan nga bahin sa Tolda gamitan ug 20 ka tabla ");
INSERT INTO cebocb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ug ipahaom usab kini sa 40 ka tungtonganan nga plata nga duha ka tungtonganan sa kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ang sa kasadpan nga bahin sa Tolda gamitan ug unom ka tabla, ");
INSERT INTO cebocb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ug duha ka tabla sa mga eskina niini. ");
INSERT INTO cebocb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kining mga tablaha sa mga eskina nasumpay pag-ayo gikan sa ubos hangtod sa ibabaw pinaagi sa usa ka singsing. Kinahanglan sama gayod niini ang himuon sa duha ka tabla sa mga eskina. ");
INSERT INTO cebocb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Busa adunay walo ka tabla sa maong bahin sa Tolda, ug nahaom kini sa 16 ka tungtonganan nga plata nga duha ka tungtonganan sa kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Pagpahimo usab ug mga babag nga akasya alang sa dingding nga lima alang sa amihan nga bahin sa Tolda, ");
INSERT INTO cebocb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lima usab alang sa habagatang bahin, ug lima alang sa kasadpang bahin, luyo sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ang babag nga ibutang sa tunga-tungang bahin sa dingding kinahanglan molapos sa isigka-tumoy sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Pahaklapig bulawan ang mga tabla ug pabutangi kinig mga singsing nga bulawan nga maoy suotanan sa mga babag. Pahaklapi usab ug bulawan ang mga babag. ");
INSERT INTO cebocb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Kinahanglan nga ipatukod mo ang Tolda nga Pagsimbahan basi gayod sa plano nga gipakita ko kanimo dinhi sa bukid. ");
INSERT INTO cebocb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Pagpahimo usab ug kurtina nga hinimo gikan sa lino ug mga hilo nga kolor ube, asul, ug pula, ug pabordahi kinig kerubin sa mga hanas nga tigborda. ");
INSERT INTO cebocb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Isab-it kini sa mga kaw-it nga bulawan nga gipahimutang sa upat ka haligi nga akasya nga hinaklapan ug bulawan. Kining upat ka haligi gipahaom sa upat ka tungtonganan nga plata. ");
INSERT INTO cebocb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kon masab-it na ang kurtina diha sa mga kaw-itanan, ibutang sa luyo niini ang Sudlanan sa Kasugoan. Ang kurtina maoy mag-ulang sa Balaang Dapit gikan sa Labing Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ang Sudlanan sa Kasugoan kinahanglan didto ibutang sa Labing Balaang Dapit ug kinahanglang ibutang usab ang tabon niini. ");
INSERT INTO cebocb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ibutang ang lamisa sa gawas sa kurtina sa amihan nga bahin sa Tolda nga Pagsimbahan, ug ibutang atbang niini ang butanganan sa suga sa habagatang bahin. ");
INSERT INTO cebocb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Pagpahimo usab ug usa pa ka kurtina alang sa entrada sa Tolda nga Pagsimbahan. Ang gamiton sa paghimo niini lino ug mga hilo nga kolor ube, asul, ug pula, ug pabordahi kini. ");
INSERT INTO cebocb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Unya isab-it kini sa mga kaw-itanan nga bulawan nga gipahimutang sa lima ka haligi nga akasya nga hinaklapan ug bulawan. Kining lima ka haligi gipahaom sa lima ka tungtonganan nga bronsi.” ");
INSERT INTO cebocb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Pagpahimo ug kuwadradong halaran nga akasya nga adunay gitas-on ug gilapdon nga pito ug tunga ka piye, ug gihabugon nga upat ug tunga ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Pabutangi kinig mga sungay-sungay nga unay diha sa upat ka eskina niini. Ug pahaklapi kini ug bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ang tanang kagamitan sa halaran kinahanglan hinimo usab ug bronsi, ang saloranan sa abo, mga pala, mga yahong, mga dagkong tinidor alang sa karne, ug mga butanganan ug baga. ");
INSERT INTO cebocb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Pagpahimo usab ug sugbahanan nga bronsi alang sa halaran, ug pabutangi kinig mga singsing nga bronsi sa kada eskina. ");
INSERT INTO cebocb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Unya ibutang kini sa tungtonganan niini nga anaa sa tunga-tunga nga bahin sa sulod sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Unya pagpahimo ug mga pangdayong sa halaran. Kinahanglan hinimo kini gikan sa kahoy nga akasya, ug hinaklapan ug bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Isuot kini sa mga singsing nga anaa sa kada kilid sa halaran aron madayongan ang halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ang halaran nga ipahimo mo kinahanglan tabla nga haw-ang sa tunga. Ipahimo kini basi sa plano nga gipakita ko kanimo dinhi sa bukid. ");
INSERT INTO cebocb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Pabutangi ug hawanan ang Tolda nga Pagsimbahan, ug paliboti kinig mga kurtina nga hinimo gikan sa lino. Ang gitas-on sa mga kurtina dapit sa habagatan 150 ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Itaod kini nga mga kurtina sa mga kaw-it nga plata nga unay sa kabilya nga plata diha sa 20 ka haligi nga bronsi nga gipahaom usab sa 20 ka tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ang kurtina sa amihan nga bahin 150 usab ka piye ang gitas-on. Isab-it kini sa mga kaw-it nga plata nga anaa sa mga kabilya nga plata sa 20 ka mga haliging bronsi nga gipahaom usab sa mga tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Ang gilapdon sa kasadpang bahin sa hawanan 75 ka piye ug aduna usab kini mga kurtina ug napulo ka haligi nga gipahaom sa napulo ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ang gilapdon sa sidlakang bahin sa hawanan 75 usab ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ang pultahan sa hawanan nga nahimutang sa sidlakan butangan usab ug mga kurtina sa isigka-kilid. Ang kurtina sa tuo 22 ug tunga ka piye ang gitas-on, ug itaod kini diha sa tulo ka haligi nga gipahaom sa tulo usab ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ang kurtina sa wala 22 ug tunga usab ka piye ang gitas-on, ug itaod kini diha sa tulo ka haligi nga gipahaom usab sa tulo ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Ang pultahan mismo sa hawanan pabutangig kurtina nga 30 ka piye ang gitas-on. Kinahanglan hinimo sa lino ang kurtina. Bordahan kini ug hilo nga kolor ube, asul, ug pula. Kinahanglan nga maayo gayod ang pagkaborda niini. Unya itaod ang kurtina diha sa upat ka haligi nga gipahaom sa upat ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kinahanglan ang tanang haligi libot sa hawanan adunay mga kaw-it ug mga kabilya nga plata, ug adunay mga tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ang tibuok hawanan 150 ka piye ang gitas-on ug 75 ka piye ang gilapdon. Libotan kinig kurtina nga lino, nga ang gitas-on pito ka piye ug tunga. Itaod kini nga kurtina sa mga haligi nga gipahaom sa mga tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kinahanglan nga pulos bronsi ang tanang kagamitan sa Tolda nga Pagsimbahan, lakip ang tanang mga ugsok nga pangbanting sa tolda ug sa mga kurtina sa hawanan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Sugoa ang mga Israelinhon sa pagdala kanimo ug purong lana gikan sa dinukdok nga olibo alang sa mga suga sa Tolda, aron magsiga kini sa kanunay. ");
INSERT INTO cebocb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ang butanganan sa suga ibutang sa gawas sa kurtina nga anaa sa atubangan sa Sudlanan sa Kasugoan. Si Aaron ug ang iyang mga anak nga lalaki mao ang mag-atiman sa mga suga sa Tolda nga Tagboanan. Magsiga kini diha sa akong presensya gikan sa gabii hangtod sa buntag. Kini nga tulomanon kinahanglan tumanon sa mga Israelinhon ug sa ilang mga kaliwat hangtod sa umaabot nga henerasyon.” ");
INSERT INTO cebocb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ilain gikan sa mga tawo si Aaron nga imong igsoon ug ang iyang mga anak nga lalaki nga sila si Nadab, Abihu, Eleazar, ug Itamar, aron mag-alagad sila kanako ingon nga mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pagpatahi ug sagrado nga mga bisti alang kang Aaron aron mapasidunggan siya. ");
INSERT INTO cebocb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ingna ang tanang maayong mga mananahi, nga gihatagan ko ug abilidad sa pagpanahi, nga tahian nilag mga bisti si Aaron sa pagdedikar kaniya aron mag-alagad kanako ingon nga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Mao kini ang mga bisti nga ilang tahion: ang sapaw sa dughan nga adunay mga bulsa-bulsa, ang efod, ang panggawas nga bisti, ang pang-ilalom nga bisti nga binordahan, ang turban, ug ang bakos. Tahion nila kini alang kang Aaron, apil usab sa iyang mga anak nga lalaki, aron makaalagad sila kanako ingon nga mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kinahanglan ang panapton nga ilang gamiton lino nga binordahan ug tanod nga bulawan ug hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ang efod kinahanglan hinimo sa lino nga binordahan ug tanod nga bulawan ug hilo nga kolor ube, asul, ug pula. Kinahanglan nga maayo gayod ang pagkaborda niini. ");
INSERT INTO cebocb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Aduna kini duha ka bahin, luyo ug atubangan, ug nasumpay kini sa duha ka strap sa may abaga. ");
INSERT INTO cebocb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ang bakos niini lino usab nga binordahan ug tanod nga bulawan ug hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Unya pagkuha ug duha ka bato nga onix ug pakuliti kini sa mga ngalan sa mga anak nga lalaki ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Kinahanglan pasunod ang pagkakulit sa mga ngalan gikan sa kamagulangan hangtod sa kamanghoran. Unom ka ngalan ang ikulit sa kada bato. ");
INSERT INTO cebocb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kinahanglan nga ang pagkulit niini sama sa paagi sa pagkulit sa platero sa silyo. Unya ibutang ang mga bato sa mga bayanan nga bulawan ");
INSERT INTO cebocb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ug itaod kini sa strap sa efod ingon nga handomanan nga mga bato alang sa mga tribo sa Israel. Niining paagiha madala kanunay ni Aaron ang ilang mga ngalan sa akong presensya, ug hinumdoman ko sila. ");
INSERT INTO cebocb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ang mga bayanan nga bulawan ");
INSERT INTO cebocb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","pabutangig duha ka kadena nga purong bulawan aron mataod sa strap sa bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Pagpahimo ug sapaw sa dughan nga adunay mga bulsa-bulsa, nga gamiton sa pagpakisayod sa akong kabubut-on. Kinahanglan nga mga hanas gihapon ang mohimo niini, ug ang panapton niini sama sa efod: lino nga binordahan ug tanod nga bulawan ug hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kining sapaw sa dughan kinahanglan gidoble pagpilo ug kuwadrado nga siyam ka pulgada ang gitas-on ug siyam ka pulgada ang gilapdon. ");
INSERT INTO cebocb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pabutangi kinig upat ka laray sa mahalong mga bato. Sa unang laray, rubi, topas, ug beril; ");
INSERT INTO cebocb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","sa ikaduhang laray, emerald, sapiro ug diamante; ");
INSERT INTO cebocb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","sa ikatulong laray, hasinto, agate, ug ametis; ");
INSERT INTO cebocb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ug sa ikaupat nga laray, krisolito, onix, ug jasper. Ibutang kini nga mga bato diha sa mga bayanan nga bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ang kada bato kinahanglan adunay ngalan sa mga anak ni Jacob sa pagrepresentar sa 12 ka tribo sa Israel. Ang pagkakulit sa mga ngalan kinahanglan sama sa pagkulit ug silyo. ");
INSERT INTO cebocb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Pabutangi usab ug kadena nga purong bulawan ang sapaw sa dughan nga adunay mga bulsa-bulsa. ");
INSERT INTO cebocb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Unya pagpahimo ug duha ka mga singsing nga bulawan ug ikabit kini sa ibabaw nga mga eskina sa sapaw sa dughan. ");
INSERT INTO cebocb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ikabit ang duha ka kadena nga bulawan diha sa duha ka singsing sa sapaw sa dughan, ");
INSERT INTO cebocb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ug ang duha ka tumoy sa kadena ikabit sa duha ka bayanan nga bulawan nga anaa sa strap sa efod. ");
INSERT INTO cebocb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Pagpahimo pa ug duha ka singsing nga bulawan, ug itaod kini sa ubos nga mga eskina sa sapaw sa dughan, nga gisapaw sa efod. ");
INSERT INTO cebocb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Pagpahimo pa gayod ug duha pa ka singsing nga bulawan ug itaod kini sa efod dapit sa bakos. ");
INSERT INTO cebocb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Unya ihikot ninyo pinaagi sa hikot nga asul ang mga singsing sa ubos nga bahin sa sapaw sa dughan ngadto sa mga singsing sa kilid sa efod. Niining paagiha maplastar pag-ayo ang sapaw sa dughan ibabaw sa bakos ug dili mabulag gikan sa efod. ");
INSERT INTO cebocb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Kon mosulod si Aaron sa Balaang Dapit kinahanglan isul-ob niya kining sapaw sa dughan nga adunay mga bulsa-bulsa diin nasulat ang mga ngalan sa mga tribo sa Israel aron hinumdoman ko sila kanunay. ");
INSERT INTO cebocb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Isulod ang Urim ug Tumim sa sapaw sa dughan aron anaa kini sa dughan ni Aaron kon moadto siya sa akong presensya. Niining paagiha dala-dalahon kanunay ni Aaron kining duha ka butang kon moadto siya sa akong presensya aron mahibaloan niya ang akong kabubut-on alang sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ang panggawas nga bisti nga paibabwan sa efod kinahanglan purong asul ");
INSERT INTO cebocb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ug adunay liab sa tunga para lusotan sa ulo. Ug kinahanglang sigsagan ang liab aron dili kini magisi. ");
INSERT INTO cebocb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Pabutangi ang sidsid niini ug mga dayandayan nga pormag prutas nga pomegranata, nga hinimo gikan sa hilo nga kolor ube, asul, ug pula. Pasal-angi kini nga mga dayandayan ug mga gagmayng kampanilya nga bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Kinahanglang isul-ob kini ni Aaron kon mosulod siya sa Balaang Dapit sa pag-alagad diha sa akong presensya, aron madunggan ang tiling-tiling sa mga kampanilya kon mosulod ug mogawas si Aaron sa Balaang Dapit. Kon himuon niya kini, dili siya mamatay. ");
INSERT INTO cebocb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Pagpahimo ug medalyon nga purong bulawan, ug ikulit sama sa paghimog silyo, kini nga mga pulong: Gilain alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Itaod kini sa atubangan sa turban ni Aaron pinaagi sa asul nga higot, ");
INSERT INTO cebocb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","aron makita kini diha sa iyang agtang. Magpakita kini nga dad-on ni Aaron ang bisan unsang sala nga nahimo sa mga Israelinhon sa ilang paghalad sa Ginoo. Itaod kini kanunay ni Aaron diha sa iyang agtang aron malipay ang Ginoo kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ang pang-ilalom nga bisti ni Aaron kinahanglan panapton nga lino ug mao usab ang iyang turban ug ang bakos nga binordahan. ");
INSERT INTO cebocb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pagpatahi usab ug mga pang-ilalom nga bisti, mga bakos, ug mga turban alang sa mga anak ni Aaron sa pagpasidungog kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“Ipasul-ob kini nga mga bisti sa imong igsoong si Aaron ug sa iyang mga anak nga lalaki, ug unya dihogi sila ug lana ug ordinahi. Idedikar sila kanako aron makaalagad sila kanako ingon nga mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Patahii usab sila ug mga pang-ilalom nga bisti sa pagtabon sa ilang kahubo. Gikan sa hawak paingon sa paa ang gitas-on niini. ");
INSERT INTO cebocb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Kinahanglan nga isul-ob nila kini inigsulod nila sa Tolda nga Tagboanan, o inigduol nila sa halaran sa Balaang Dapit sa pag-alagad ingon nga mga pari, aron dili sila makasala ug mamatay. “Kini nga tulomanon kinahanglan nga tumanon ni Aaron ug sa iyang mga kaliwat hangtod sa hangtod.” ");
INSERT INTO cebocb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Mao kini ang imong himuon sa pagdedikar kang Aaron ug sa iyang mga anak nga lalaki aron makaalagad sila kanako ingon nga mga pari. Pagkuha ug nating torong baka ug duha ka hamtong nga laking karnero nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Pagkuha usab ug maayong klasi sa harina ug pagluto ug pan nga walay patubo. Ang imong lutuon, pan nga walay sagol ug mantika, pan nga baga nga sinagolan ug mantika, ug pan nga nipis nga pinahiran ug mantika. ");
INSERT INTO cebocb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Isulod kining tanan sa basket ug dad-a kanako uban ang nating torong baka ug ang duha ka laking karnero. ");
INSERT INTO cebocb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Dad-a si Aaron ug ang iyang mga anak nga lalaki didto dapit sa pultahan sa Tolda nga Tagboanan, ug ipakaligo sila. ");
INSERT INTO cebocb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Unya ipasul-ob kang Aaron ang iyang pang-ilalom nga bisti, ang panggawas nga bisti, ang efod, ug ang sapaw sa dughan nga adunay mga bulsa-bulsa. Baksi ang iyang hawak sa maayong pagkahimo nga bakos sa efod. ");
INSERT INTO cebocb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ipasul-ob sa iyang ulo ang turban, ug ipataod sa atubangan sa turban ang medalyon nga bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Unya kuhaa ang lana ug ibubo sa ulo ni Aaron sa pagdihog kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Idedikar usab ang iyang mga anak nga lalaki. Ipasul-ob usab kanila ang pang-ilalom nga bisti, ");
INSERT INTO cebocb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","turban, ug bakos. Sila ug ang ilang mga kaliwat mao ang mahimong pari hangtod sa kahangtoran. “Ordinahan mo niining paagiha si Aaron ug ang iyang mga anak nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Dad-a ang nating torong baka atubangan sa Tolda nga Tagboanan, ug ipapatong ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot ngadto sa ulo sa baka. ");
INSERT INTO cebocb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Unya ihawa ang baka diha sa presensya sa Ginoo, sa may pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Pagkuha ug dugo sa baka ug ipahid kini sa mga sungay-sungay sa mga eskina sa halaran pinaagi sa imong tudlo, ug ang mahibiling dugo iyabo diha sa kinaubosang bahin sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Unya kuhaa ang tanang tambok sa sulod sa ginhawaan sa baka, ang gamay nga bahin sa atay, ug ang mga bato-bato apil ang mga tambok niini, ug sunoga kini diha sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Apan ang iyang unod, panit, ug tinai sunogon mo sa gawas sa kampo. Halad kini aron mahimo silang hinlo. ");
INSERT INTO cebocb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Unya kuhaa ang usa sa laking karnero ug ipapatong ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot ngadto sa ulo sa karnero. ");
INSERT INTO cebocb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Unya ihawa kini ug isablig ang dugo niini libot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Hiwa-hiwaa ang karnero ug hugasi ang mga bahin sa sulod sa ginhawaan ug ang mga tiil, ug usaha kini uban sa ulo. ");
INSERT INTO cebocb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Unya sunoga kining tanan diha sa halaran isip halad nga sinunog alang kanako. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Unya kuhaa ang usa pa ka laking karnero, ug ipapatong ang mga kamot ni Aaron ug sa iyang mga anak nga lalaki sa ulo sa karnero. ");
INSERT INTO cebocb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Unya ihawa kini, ug kuhaa ang ubang dugo niini ug ipahid sa ubos nga bahin sa tuong dalunggan ni Aaron ug sa iyang mga anak nga lalaki, ug sa mga kumagko sa ilang tuong kamot ug tuong tiil. Unya isablig ang dugo libot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kuhaa ang ubang dugo sa halaran ug isagol kini sa lana nga pangdihog, ug unya iwisik kang Aaron ug sa iyang mga anak nga lalaki ug sa ilang mga bisti. Niining paagiha madedikar si Aaron ug ang iyang mga anak, lakip ang ilang mga bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Unya kuhaa ang mga tambok sa karnero, ang tambok nga ikog, ang tanang tambok sa sulod sa ginhawaan, ang gamay nga bahin sa atay, ang mga bato-bato apil ang mga tambok niini, ug ang tuo nga paa. Mao kini ang karnero nga halad alang sa ordinasyon sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Pagkuha gikan sa basket ug tag-usa ka klasi sa mga pan nga walay patubo nga gihalad kanako: pan nga walay sagol nga mantika, pan nga baga nga sinagolan ug mantika, ug pan nga nipis. ");
INSERT INTO cebocb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Paguniti kining tanan kang Aaron ug sa iyang mga anak ug ibayaw nila kini isip halad nga binayaw alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Unya kuhaa kini kanila ug sunoga diha sa halaran uban sa halad nga sinunog. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Unya kuhaa ang dughan sa karnero nga halad alang sa pag-ordina kang Aaron ug ibayaw kini isip halad nga binayaw alang kanako. Pagkahuman, kuhaa kini isip imong bahin. ");
INSERT INTO cebocb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Idedikar kanako ang mga bahin sa karnero nga halad alang sa pag-ordina kang Aaron ug sa iyang mga anak nga lalaki, lakip na niini ang dughan ug paa nga gibayaw kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Sa kada halad sa mga Israelinhon sa mga halad alang sa maayong relasyon kanako, mao gayod kini kanunay ang mga bahin sa mananap nga mahimong bahin nila ni Aaron ug sa iyang mga anak nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Kon mamatay na si Aaron, ang iyang sagrado nga mga bisti ihatag ngadto sa usa niya ka kaliwat nga mopuli kaniya isip pangulong pari, aron ila kining sul-obon kon ordinahan sila pinaagi sa pagdihog kanila sa lana. ");
INSERT INTO cebocb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ang kaliwat ni Aaron nga mopuli kaniya isip pangulong pari mosul-ob niining mga bistiha sulod sa pito ka adlaw inigsulod niya sa Tolda nga Tagboanan sa pag-alagad diha sa Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Kuhaa ang karnero nga gihalad sa pag-ordina ug lutoa ang karne niini diha sa usa ka balaang dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kaonon kini ni Aaron ug sa iyang mga anak nga lalaki, apil ang mga pan sa basket, diha sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Sila lang ang mahimong mokaon niini nga karne ug pan nga gihalad aron mahinloan sila gikan sa ilang sala sa dihang giordinahan sila. Walay laing makakaon niini uban kanila kay kini nga mga pagkaon sagrado. ");
INSERT INTO cebocb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kon adunay mabilin nga pagkaon pagkabuntag, kinahanglan sunogon kini. Dili gayod kini kan-on, kay kini sagrado. ");
INSERT INTO cebocb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Sunda kining gisugo ko kanimo bahin kang Aaron ug sa iyang mga anak nga lalaki. Himoa ang pag-ordina kanila sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kada adlaw maghalad ka ug usa ka baka isip halad sa paghinlo aron mahimong hinlo ang halaran, ug unya dihogi kinig lana agig paghalad niini. ");
INSERT INTO cebocb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Himoa kini sulod sa pito ka adlaw ug unya mahimo gayod nga labing balaan ang halaran, ug kinahanglan nga balaan usab ang naggunit niini. ");
INSERT INTO cebocb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ang imong ihalad sa halaran matag adlaw duha ka karnero nga nag-edad ug tagsa pa ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Usa sa buntag ug usa usab sa hapon. ");
INSERT INTO cebocb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Uban sa paghalad mo ug karnero sa buntag, paghalad usab ug duha ka kilo nga maayong klasi sa harina nga sinagolan ug usa ka litrong mantika nga gikan sa dinukdok nga olibo, ug usa ka litro nga duga sa ubas isip halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Sa imong paghalad sa karnero inigkahapon, kinahanglan nga ihalad mo kini sama sa imong gibuhat sa buntag, lakipi sa samang mga halad nga harina ug ilimnon. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","43","Kini nga halad nga sinunog kinahanglan kanunay nga ihalad bisan sa umaabot ninyong henerasyon. Ihalad ninyo kini sa akong presensya, didto sa pultahan sa Tolda nga Tagboanan diin makigsulti ako kanimo ug makigkita usab sa mga Israelinhon. Kini nga Tolda mabalaan tungod sa akong gamhanang presensya. ");
INSERT INTO cebocb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Himuon kong balaan ang Tolda nga Tagboanan ug ang halaran, ug ilain ko si Aaron ug ang iyang mga anak nga lalaki alang sa pag-alagad kanako ingon nga mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mopuyo ako uban sa mga Israelinhon ug ako mahimong ilang Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Mahibaloan nila nga ako mao ang Ginoo nga ilang Dios nga nagpagawas kanila gikan sa Ehipto aron mopuyo ako uban kanila. Ako mao ang Ginoo nga ilang Dios. ");
INSERT INTO cebocb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Pagpahimog halaran nga akasya nga sunoganan sa insenso. ");
INSERT INTO cebocb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kinahanglan nga kuwadrado kini, nga 18 ka pulgada ang gitas-on ug ang gilapdon, ug tulo ka piye ang gihabugon. Adunay mga sungay-sungay sa mga eskina niini nga unay sa lawas sa paghimo niining halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Pahaklapig purong bulawan ang ibabaw niini, ang upat ka kilid, ug ang mga sungay-sungay sa kada eskina. Ug paribetihi ug bulawan sa palibot. ");
INSERT INTO cebocb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pabutangi ug duha ka mga singsing nga bulawan ubos sa ribeti sa isigka-kilid sa halaran, aron suksokan sa mga pangdayong niini. ");
INSERT INTO cebocb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kinahanglan ang pangdayong kahoy nga akasya, ug haklapan kini ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ibutang kini nga halaran atubangan sa kurtina nga nagtabon sa Sudlanan sa Kasugoan diin adto ako makigkita kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Kada buntag, inig-atiman ni Aaron sa mga suga, magsunog siya ug humot nga insenso diha sa maong halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ug sa hapon, kon pasigahon na niya ang mga suga, magsunog na usab siya. Kinahanglan himuon kini sa kanunay diha sa akong presensya bisan sa umaabot ninyo nga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ayaw kamo paghalad niining maong halaran ug laing insenso o bisan unsang halad nga sinunog, o halad sa pagpasidungog, o halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kausa matag tuig, kinahanglan hinloan ni Aaron ang halaran pinaagi sa pagpahid ug dugo diha sa mga sungay-sungay sa mga eskina niini. Ang dugo nga ipahid maggikan sa halad sa paghinlo. Kinahanglan himuon kini matag tuig bisan sa umaabot ninyo nga henerasyon kay kini nga halaran balaan kaayo alang kanako.” ");
INSERT INTO cebocb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Inig-ihap mo sa katawhan sa Israel, ang tagsa-tagsa nga maapil sa pag-ihap mobayad kanako alang sa iyang kinabuhi, aron walay katalagman nga moabot kanila samtang ginaihap sila. ");
INSERT INTO cebocb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ang ibayad sa matag-usa nga maapil sa pag-ihap unom ka gramo nga pilak basi sa kilohan sa salapi nga ginagamit sa mga pari. Ihatag nila kini ingon nga halad kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ang tanang nagpanuigon ug 20 ka tuig pataas mao ang mohatag niini kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","16","Ang sapian dili mobayad ug sobra, ug ang pobre dili mobayad ug kulang. Gamita kini nga kuwarta alang sa buluhaton sa Tolda nga Tagboanan. Bayad kini sa mga Israelinhon alang sa ilang kinabuhi, ug pinaagi niini hinumdoman ko sila.” ");
INSERT INTO cebocb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Unya miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Paghimo ug bronsi nga palanggana ug tungtonganan niini nga bronsi. Ibutang kini sa tunga-tunga sa Tolda nga Tagboanan ug sa halaran, ug sudli kinig tubig. ");
INSERT INTO cebocb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Mao kini ang gamiton ni Aaron ug sa iyang mga anak nga lalaki sa paghugas sa ilang mga kamot ug tiil, ");
INSERT INTO cebocb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","sa dili pa sila mosulod sa Tolda nga Tagboanan, ug sa dili pa sila moduol sa halaran sa paghalad kanako ug halad pinaagi sa kalayo. Kinahanglan nga hugasan gayod nila ang ilang mga kamot ug tiil aron dili sila mamatay. Kini nga tulomanon kinahanglan tumanon ni Aaron ug sa iyang mga kaliwat bisan sa umaabot nga henerasyon.” ");
INSERT INTO cebocb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Pagkuha niining labing maayong mga lamas: unom ka kilo nga mira, tulo ka kilo nga humot nga cinamon, tulo ka kilo nga humot nga calamus, ");
INSERT INTO cebocb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","unom ka kilo nga casia (kinahanglan ang mga gibug-aton niini basi sa timbangan nga ginagamit sa mga pari), ug usa ka galon nga lana sa olibo. ");
INSERT INTO cebocb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Gamita kini sa paghimo ug balaang lana nga pangdihog nga humot kaayo. ");
INSERT INTO cebocb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Pahiri niining lana ang Tolda nga Tagboanan, ang Sudlanan sa Kasugoan, ang lamisa ug ang tanang kagamitan niini, ang butanganan sa suga ug ang tanang kagamitan niini, ang halaran nga sunoganan sa insenso, ang halaran nga sunoganan sa halad nga sinunog ug ang tanang kagamitan niini, ug ang palanggana ug tungtonganan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ihalad kining mga butanga aron mahimo gayod kining sagrado; ug kinahanglan nga balaan usab ang naggunit niini. ");
INSERT INTO cebocb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Dihogi usab ug lana si Aaron ug ang iyang mga anak nga lalaki isip pagdedikar kanila, aron makaalagad sila kanako isip mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ingna ang mga Israelinhon nga mao kini ang akong sagrado nga lana nga pangdihog hangtod sa hangtod. ");
INSERT INTO cebocb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ayaw ninyo kinig ihaplas sa mga lawas sa ordinaryong mga tawo, ug ayaw usab kamo paghimo ug sama niini alang sa inyong kaugalingon. Balaan kini, busa balaana ninyo kini. ");
INSERT INTO cebocb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Si bisan kinsa nga maghimog sama niini o mogamit niini kang bisan kinsa nga dili pari, dili na ninyo isipon nga usa sa inyong katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Miingon ang Ginoo kang Moises, “Pagkuha ug pareho kadaghanon niining humot nga mga lamas: estakte, onix, galbanom, ug purong kamangyan. ");
INSERT INTO cebocb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Gamita kini sa paghimo ug humot kaayo nga insenso. Unya asini kini aron mahimo kining lunsay ug sagrado. ");
INSERT INTO cebocb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Dukdoka ug pino ang uban niini ug ibutang atubangan sa Sudlanan sa Kasugoan diin ako makigkita kanimo didto sa Tolda nga Tagboanan. Kinahanglan nga isipon mo gayod kini nga balaan. ");
INSERT INTO cebocb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ayaw kamo paghimo niini nga insenso alang sa inyong kaugalingon. Isipa kini nga balaan alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Si bisan kinsa nga maghimo niini ingon nga iyang kaugalingong pahumot dili na ninyo isipon nga usa sa inyong katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Unya miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Gipili ko si Bezalel nga anak ni Uri ug apo ni Hur nga gikan sa tribo ni Juda. ");
INSERT INTO cebocb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Gigamhan ko siya sa akong Espiritu ug gihatagag kaalam ug abilidad sa pagbuhat ug bisan unsang buluhaton, ");
INSERT INTO cebocb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","sa paghimog matahom nga mga butang nga hinimo gikan sa bulawan, plata, ug bronsi, ");
INSERT INTO cebocb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","sa pagkorti sa mahalong mga bato aron himuong bato sa mga alahas, sa pagkulit sa kahoy, ug sa tanang inantigo nga mga buluhaton. ");
INSERT INTO cebocb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Gipili ko usab si Oholiab nga anak ni Ahisamac, nga gikan sa tribo ni Dan, sa pagtabang kang Bezalel. ");
INSERT INTO cebocb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“ang Tolda nga Tagboanan, ang Sudlanan sa Kasugoan ug ang tabon niini, ug ang tanang kagamitan sa Tolda, ");
INSERT INTO cebocb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ang lamisa ug ang mga kagamitan niini, ang butanganan ug suga nga purong bulawan ug ang tanan usab nga kagamitan niini, ang halaran nga sunoganan sa insenso, ");
INSERT INTO cebocb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ang halaran nga sunoganan sa halad nga sinunog ug ang tanang kagamitan niini, ang palanggana ug ang tungtonganan niini, ");
INSERT INTO cebocb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ang matahom ug sagrado nga mga bisti nga sul-obon ni Aaron ug sa iyang mga anak nga lalaki kon mag-alagad sila ingon nga mga pari, ");
INSERT INTO cebocb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ang lana nga pangdihog, ug ang humot nga insenso alang sa Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Unya miingon ang Ginoo kang Moises ");
INSERT INTO cebocb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","nga isulti kini ngadto sa mga Israelinhon, “Kinahanglan tumanon gayod ninyo ang akong mga gipahimo kaninyo mahitungod sa Adlaw nga Igpapahulay, kay timailhan kini sa atong kasabotan hangtod sa umaabot nga mga henerasyon. Niining paagiha mahibaloan ninyo nga ako mao ang Ginoo nga nagpili kaninyo nga mahimong akong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Tumana ninyo ang akong mga gipahimo kaninyo sa Adlaw nga Igpapahulay, kay balaan kini nga adlaw alang kaninyo. Si bisan kinsa nga dili mosunod sa akong mga gipahimo nianang adlawa kinahanglan gayod nga patyon. Si bisan kinsa nga magtrabaho nianang adlawa dili na ninyo isipon nga usa sa inyong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Buhata ninyo ang inyong buluhaton sulod sa unom ka adlaw, apan sa ikapitong adlaw magpahulay gayod kamo. Tungod kay kining adlawa balaan alang kanako; si bisan kinsa nga magtrabaho nianang adlawa kinahanglang patyon. ");
INSERT INTO cebocb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","17","Busa kamong mga Israelinhon, kinahanglang tumanon ninyo ug sa inyong umaabot nga mga henerasyon ang akong mga gipahimo kaninyo sa Adlaw nga Igpapahulay. Mao kini ang permanenteng ilhanan sa atong walay kataposang kasabotan. Kay sulod sa unom ka adlaw gimugna ko ang langit ug ang kalibotan, ug sa ikapitong adlaw mipahulay ako.” ");
INSERT INTO cebocb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Human makigsulti ang Ginoo kang Moises didto sa Bukid sa Sinai, gihatag niya kang Moises ang duha ka lagpad nga bato nga gisulatan niya mismo sa Kasugoan. ");
INSERT INTO cebocb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sa dihang namatikdan sa mga tawo nga dugayng nakalugsong si Moises gikan sa bukid, miduol sila kang Aaron ug miingon, “Dali, himoi kami ug dios nga mangulo kanamo, kay wala na kita masayod kon unsa nay nahitabo niadtong Moises nga nagpagawas kanato gikan sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Mitubag si Aaron kanila, “Panguhaa ninyo ang mga ariyos nga bulawan sa inyong mga asawa ug mga anak, ug dad-a ninyo dinhi kanako.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Busa gipanguha nilang tanan ang ilang mga ariyos nga bulawan ug gidala kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gitigom kini ni Aaron ug gitunaw ug giporma nga baka. Unya miingon dayon ang mga Israelinhon, “Mao kini ang atong dios nga nagpagawas kanato gikan sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Pagkakita ni Aaron nga nalipay pag-ayo ang mga tawo niini, nagpahimo siyag halaran diha atubangan sa baka ug nagpahibalo, “Ugma magsaulog kitag pista alang sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Busa pagkabuntag, sayong mibangon ang mga tawo ug naghalad ug mga halad nga sinunog ug halad alang sa maayong relasyon. Unya nangaon sila ug nag-inom ug nagpatuyang sa paghudyaka. ");
INSERT INTO cebocb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Miingon ang Ginoo kang Moises, “Pagdalig lugsong kay ang imong katawhan nga gipagawas mo gikan sa Ehipto naghimog kadaotan. ");
INSERT INTO cebocb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Dali ra kaayo silang milapas sa akong gimando kanila. Naghimo silag ilang dios-dios nga baka ug gisimba kini. Gihalaran nila kini ug miingon, ‘Mao kini ang atong dios nga nagpagawas kanato gikan sa Ehipto.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Miingon pa gayod ang Ginoo kang Moises, “Nakita ko kon unsa kagahig ulo kining mga tawhana. ");
INSERT INTO cebocb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Busa pasagdi ako nga molaglag kanila sa hilabihan kong kasuko. Ug ikaw ug ang imong mga kaliwat ang himuon kong bantogan nga nasod.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Apan nagpakiluoy si Moises sa Ginoo nga iyang Dios, “O Ginoo, nganong ipatagamtam mo man ang imong kasuko sa imong katawhan nga gipagawas mo gikan sa Ehipto pinaagi sa imong kahibulongang gahom? ");
INSERT INTO cebocb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Unsa na lay ikasulti sa mga Ehiptohanon? Nga gikuha mo ang imong katawhan sa Ehipto aron lang patyon sa kabukiran ug mawala sa kalibotan? O Ginoo, ayaw na ipadayon ang imong hilabihang kasuko kanila, ug ayaw sila laglaga. ");
INSERT INTO cebocb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Hinumdomi ang imong gipanumpa ngadto sa imong mga alagad nga si Abraham, Isaac, ug Jacob, nga padaghanon mo ang ilang mga kaliwat sama sa mga bitoon sa langit, ug ihatag mo sa ilang mga kaliwat ang tanang yuta nga imong gisaad kanila, ug mahimo kining ilang panulondon hangtod sa hangtod.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Busa wala na padayona sa Ginoo ang iyang plano nga paglaglag sa iyang katawhan. ");
INSERT INTO cebocb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Unya milugsong si Moises gikan sa bukid dala ang duha ka lagpad nga bato nga gisulatan sa Kasugoan sa likod ug sa atubangan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ang Dios mismo ang naghimo sa duha ka lagpad nga mga bato ug sa mga gikulit nga mga pulong niini. ");
INSERT INTO cebocb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Sa dihang nadungog ni Josue ang kasaba sa mga tawo, miingon siya kang Moises, “Morag adunay kasaba sa gira didto sa kampo.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mitubag si Moises, “Dili kasaba sa kadaogan o kapildihan ang akong nadungog, kondili kasaba sa pagkinantahay.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Sa nagkaduol na si Moises sa kampo, nakita niya ang dios-dios nga baka ug ang mga tawo nga nagsayaw-sayaw, busa nasuko siya pag-ayo. Gilabay niya didto sa tiilan sa bukid ang lagpad nga mga bato nga iyang dala, ug nangabuak kini. ");
INSERT INTO cebocb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Unya gikuha niya ang dios-dios nga baka nga ilang gihimo ug gisunog kini. Unya gidugmok niya kinig pino ug gisagol sa tubig ug gipainom sa katawhan sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Miingon si Moises kang Aaron, “Unsa bay gihimo niining mga tawhana kanimo nga gitugotan mo man sila sa pagpakasala sa hilabihan?” ");
INSERT INTO cebocb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Mitubag si Aaron, “Ayaw kasuko kanako, sir. Nasayod ka bitaw nga dali ra sila madala sa kadaotan. ");
INSERT INTO cebocb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Miingon sila kanako, ‘Himoi kamig dios nga mangulo kanamo, kay wala na kita masayod kon unsa nay nahitabo niadtong Moises nga nagpagawas kanato gikan sa Ehipto.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Busa miingon ako kanila nga dad-on nila dinhi kanako ang ilang mga alahas nga bulawan. Sa dihang nadala na kini kanako, gilabay ko kini sa kalayo ug mitungha kining baka. ");
INSERT INTO cebocb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nakita ni Moises nga nagpatuyang sa paghudyaka ang mga tawo ug gipasagdan lang sila ni Aaron. Tungod niini nahimo silang kataw-anan sa ilang mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Busa mitindog si Moises sa pultahan sa kampo ug misinggit, “Kadtong dapig sa Ginoo duol kanako!” Ug ang tanang mga kaliwat ni Levi miduol kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Miingon si Moises kanila, “Mao kini ang giingon sa Ginoo, nga Dios sa Israel, ‘Ang kada usa kaninyo magtak-in sa iyang espada ug maglibot-libot sa kampo, ug pamatyon ninyo tanan, bisan pag inyong igsoon, amigo, o silingan.’ ” ");
INSERT INTO cebocb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Gituman sa mga kaliwat ni Levi ang gisugo kanila ni Moises, ug nianang adlawa mga 3,000 ka mga tawo ang namatay. ");
INSERT INTO cebocb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Miingon si Moises sa mga kaliwat ni Levi, “Gilain kamo karong adlawa alang sa Ginoo, kay gipamatay ninyo bisan ang inyong mga anak ug mga igsoon. Busa panalanginan niya kamo karong adlawa.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Pagkasunod adlaw, miingon si Moises sa mga tawo, “Nakahimo kamog dakong sala. Apan motungas ako karon sa bukid, didto sa Ginoo; basin pag matabangan ko kamo nga mahinloan sa inyong sala.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Busa mibalik si Moises sa Ginoo ug miingon, “Ginoo, dako kaayong sala ang nahimo niining mga tawhana. Naghimo silag dios nga bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Apan karon, pasayloa sila sa ilang sala. Kon dili mo sila mapasaylo papasa na lang ang akong ngalan sa libro nga gisulatan mo sa mga ngalan sa imong katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mitubag ang Ginoo kang Moises, “Kon kinsa ang nakasala kanako, siya ang akong papason sa akong libro. ");
INSERT INTO cebocb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Lakaw, ug pangulohi ang mga tawo paingon sa dapit nga giingon ko kanimo, ug mag-una kaninyo ang akong anghel. Apan moabot ang panahon nga silotan ko sila tungod sa ilang sala.” ");
INSERT INTO cebocb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ug gipadad-an sa Ginoo ug katalagman ang mga Israelinhon tungod kay gisimba nila ang dios-dios nga baka nga gihimo ni Aaron. ");
INSERT INTO cebocb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Unya miingon ang Ginoo kang Moises, “Biyai kining lugara uban sa mga tawo nga gipagawas mo gikan sa Ehipto ug pangadto kamo sa yuta nga gisaad ko kang Abraham, Isaac, ug Jacob. Miingon ako kanila, ‘Ihatag ko kini nga yuta sa inyong mga kaliwat.’ ");
INSERT INTO cebocb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Paunahon ko kaninyo ang anghel, ug abugon ko ang mga Canaanhon, mga Amorihanon, mga Hitihanon, mga Perisihanon, mga Hibihanon, ug mga Jebusihanon ");
INSERT INTO cebocb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","gikan nianang yuta nga maayo ug mabungahon. Apan dili ako mouban kaninyo kay mga gahi kamog ulo, basin unyag pamatyon ko pa kamo sa dalan.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Sa pagkadungog sa mga tawo niining sakit nga mga pulong, nagsubo gayod sila ug wala nila sul-oba ang ilang mga alahas. ");
INSERT INTO cebocb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kay gisugo sa Ginoo si Moises nga isulti kini ngadto sa mga Israelinhon, “Mga gahi kamog ulo. Kon ubanan ko kamo bisan sa makadiyot lamang, basin mapatay ko pa kamo. Karon, tangtanga ninyo ang inyong mga alahas hangtod makadesisyon ako kon unsa ang akong himuon kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Busa gitangtang sa mga Israelinhon ang ilang mga alahas didto sa Bukid sa Horeb. ");
INSERT INTO cebocb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Naandan na ni Moises nga magpatindog ug Tolda nga layo sa kampo. Kini nga Tolda gitawag niya nga “Tolda nga Tagboanan.” Si bisan kinsa nga gustong magpakisayod sa kabubut-on sa Ginoo moadto sa maong Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kon mosulod si Moises sa Tolda, manindog ang mga tawo sa pultahan sa ilang mga tolda. Tan-awon nila si Moises hangtod nga makasulod siya sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ug samtang atua didto si Moises sa sulod, mopaubos ang panganod nga daw haligi diha sa pultahan sa Tolda samtang makigsulti ang Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ug kon makita sa mga tawo ang panganod nga daw haligi diha sa pultahan sa Tolda, manindog sila ug mosimba sa Ginoo diha sa pultahan sa ilang mga tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kon makigsulti ang Ginoo kang Moises, mag-atubangay gayod sila sama sa managhigala nga nagsultihanay. Pagkahuman niini mobalik si Moises sa kampo, apan ang iyang personal nga katabang nga batan-on nga si Josue, nga anak ni Nun, magpabilin sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Miingon si Moises sa Ginoo, “Kanunay mo akong gisultihan nga pangulohan ko kini nga katawhan, apan wala mo pa ako pahibaloa kon kinsay imong paubanon kanako. Miingon pa ikaw nga nakaila ka gayod kanako ug nalipay ka kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kon tinuod nga nalipay ka kanako, tudloi ako sa imong mga pamaagi aron makaila ako kanimo ug aron malipay pa gayod ikaw kanako. Hinumdomi nga kining nasora imong katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mitubag ang Ginoo, “Ako mismo ang mag-uban kanimo, ug hatagan ka nako ug kapahulayan.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Miingon si Moises kaniya, “Kon dili ka mouban kanamo, ayaw kami pabiyaa niining dapita. ");
INSERT INTO cebocb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kay unsaon man pagkasayod sa uban nga nalipay ka kanako ug sa imong katawhan kon dili mo kami ubanan? Ug unsaon nila pagkasayod nga pinasahi kami nga katawhan kaysa ubang katawhan sa kalibotan?” ");
INSERT INTO cebocb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mitubag ang Ginoo kang Moises, “Himuon ko ang imong gihangyo kay nalipay ako kanimo, ug nakaila gayod ako kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Unya miingon si Moises, “Palihog, ipakita kanako ang imong gamhanang presensya.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mitubag ang Ginoo, “Ipakita ko kanimo ang tanan kong kaayo, ug litukon ko kanimo ang akong ngalan, ang Ginoo. Kaloy-an ko ang gusto kong kaloy-an. ");
INSERT INTO cebocb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Apan dili mo makita ang akong nawong kay walay tawo nga makakita kanako nga magpabiling buhi.” ");
INSERT INTO cebocb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Unya miingon ang Ginoo, “Tindog dinhi sa dakong bato duol kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ug samtang molabay ang akong gamhanang presensya, isulod ka nako sa bangag sa bato ug tabonan ka nako sa akong kamot hangtod nga makalabay ako. ");
INSERT INTO cebocb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Unya kuhaon ko ang akong kamot ug makita mo ang akong likod apan dili ang akong nawong.” ");
INSERT INTO cebocb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Miingon ang Ginoo kang Moises, “Pagkorti ug duha ka lagpad nga bato sama niadtong unang gihatag ko kanimo, kay sulatan ko kini sa mga pulong nga nasulat sa unang bato nga gibuak mo. ");
INSERT INTO cebocb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pangandam ugma sa buntag, ug tungas sa Bukid sa Sinai. Pakigkita kanako ibabaw sa bukid. ");
INSERT INTO cebocb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kinahanglan walay mouban kanimo, ug wala usay bisan usa ka tawo nga makita sa tibuok bukid. Bisan ang mga karnero o ang mga baka dili pasab-sabon duol sa bukid.” ");
INSERT INTO cebocb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Busa nagkorte si Moises ug duha ka lagpad nga bato sama niadtong una. Ug sayo pagkasunod buntag, mitungas siya sa Bukid sa Sinai sumala sa gimando kaniya sa Ginoo dala ang duha ka lagpad nga bato. ");
INSERT INTO cebocb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Unya mikunsad ang Ginoo diha sa panganod ug gilitok niya ang iyang ngalan nga Ginoo samtang nagtindog si Moises diha sa iyang presensya. ");
INSERT INTO cebocb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Milabay ang Ginoo atubangan ni Moises ug miingon, “Ako ang Ginoo, ang adunay kahangawa ug maluloy-on nga Dios. Mahigugmaon ug matinumanon gayod ako, ug dili daling masuko. ");
INSERT INTO cebocb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ginapakita ko ang akong paghigugma sa daghang mga tawo, ug ginapasaylo ko ang ilang kadaotan, kalapasan, ug kasal-anan. Apan ginasilotan ko ang mga makasasala, lakip ang ilang mga kaliwat hangtod sa ikatulo ug ikaupat nga henerasyon.” ");
INSERT INTO cebocb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Miluhod dayon si Moises sa yuta ug misimba. ");
INSERT INTO cebocb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Miingon siya, “O Ginoo, kon nalipay ka kanako, naghangyo ako nga ubanan mo kami. Bisan ug gahig ulo kining mga tawhana, pasayloa kami sa among kadaotan ug sa among mga sala. Dawata kami ingon nga imong katawhan.” ");
INSERT INTO cebocb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Miingon ang Ginoo, “Karon, maghimo akog kasabotan uban kaninyo. Atubangan sa tanan mong katagilungsod, maghimo akog kahibulongang mga butang nga wala ko pa gayod mahimo sa bisan asa nga nasod sa tibuok kalibotan. Ang mga katawhan sa inyong palibot makakita niining mga butanga nga akong himuon alang kanimo. ");
INSERT INTO cebocb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tumana ang akong ginasugo kanimo karong adlawa. Abugon ko ang mga Amorihanon, Canaanhon, Hitihanon, Perisihanon, Hibihanon, ug mga Jebusihanon. ");
INSERT INTO cebocb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Pagbantay nga dili ka gayod maghimog kasabotan uban sa mga lumulupyo sa mga yuta nga inyong adtoan, kay mahimo kining laang alang kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Gub-a hinuon ninyo ang ilang mga halaran, dugmoka ang ilang handomanan nga mga bato, ug pamutla ang ilang mga poste nga simbolo sa ilang diosa nga si Ashera. ");
INSERT INTO cebocb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ayaw gayod kamo pagsimba ug laing dios kay ako, ang Ginoo, dili gusto nga adunay kamoy gisimba nga lain. ");
INSERT INTO cebocb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Ayaw gayod kamo paghimog kasabotan uban sa mga tawo nga nagpuyo sa yuta nga inyong adtoan, kay basin matintal kamo pagkaon sa ilang mga halad kon agdahon nila kamo sa ilang paghalad ug pagsimba sa ilang mga dios. ");
INSERT INTO cebocb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ug basin unya ang inyong mga anak mangasawa sa ilang mga anak, nga mao unya ang motukmod kanila sa pagsimba sa ubang mga dios. ");
INSERT INTO cebocb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Ayaw kamo paghimog mga dios. ");
INSERT INTO cebocb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Sauloga ninyo ang Pista sa Pan nga Walay Patubo. Sumala sa gisugo ko kaninyo, magkaon kamo ug pan nga walay patubo sulod sa pito ka adlaw. Himoa ninyo kini sa gitakda nga panahon sa bulan sa Abib, kay mao kana ang bulan nga mibiya kamo gikan sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Akoa ang tanang kamagulangang anak nga lalaki, lakip ang tanang unang anak nga laki sa inyong kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mahimong lukaton ang unang anak nga laki sa inyong mga asno pinaagi sa pag-ilis niini ug karnero. Apan kon dili ninyo kini lukaton, kinahanglan nga patyon ang asno pinaagi sa pagbali sa liog niini. Mahimo usab nga lukaton ang inyong kamagulangang anak nga lalaki. “Walay moduol kanako nga walay dala nga halad. ");
INSERT INTO cebocb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Magtrabaho kamo sulod sa unom ka adlaw, apan sa ikapitong adlaw magpahulay kamo, bisan pag panahon sa tingdaro ug ting-ani. ");
INSERT INTO cebocb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Sauloga ninyo ang Pista sa Ting-ani pinaagi sa pagdala kanako sa unang abot sa inyong trigo. Sauloga usab ninyo ang Pista sa Kataposang Ani sa kataposan sa tuig. ");
INSERT INTO cebocb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Ang inyong mga lalaki kinahanglan motambong niining tulo ka mga kapistahan kada tuig sa pagsimba sa Ginoo nga inyong Agalon, ang Dios sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Abugon ko ang mga katawhan gikan sa yuta nga ihatag ko kaninyo, ug palapdon ko ang inyong teritoryo. Walay manulong o mangilog sa inyong nasod sa panahon nga moatubang kamo kanako, ang Ginoo nga inyong Dios, nianang tulo ka higayon matag tuig. ");
INSERT INTO cebocb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ayaw ninyo ihalad kanako ang dugo uban sa pan nga adunay patubo. Ug ayaw ninyo pabuntagi ang karne nga gihalad ninyo panahon sa Pista sa Paglabay sa Anghel. ");
INSERT INTO cebocb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Dad-a ninyo sa balay sa Ginoo nga inyong Dios ang labing maayong bahin sa inyong unang abot. “Ayaw ninyo lutoa ang nating kanding sa gatas sa iyang inahan.” ");
INSERT INTO cebocb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Miingon ang Ginoo kang Moises, “Isulat kining akong gisulti, kay mao kini ang mga tulomanon sa akong kasabotan uban kanimo ug sa Israel.” ");
INSERT INTO cebocb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Didto si Moises uban sa Ginoo sulod sa 40 ka adlaw ug 40 ka gabii ug wala siya mokaon o moinom. Gisulat sa Ginoo sa lagpad nga mga bato ang mga tulomanon sa kasabotan nga mao ang Napulo ka Sugo. ");
INSERT INTO cebocb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sa paglugsong ni Moises sa Bukid sa Sinai, dala niya ang duha ka lagpad nga mga bato nga gisulatan sa Kasugoan. Wala siya masayod nga nagdan-ag diay ang iyang nawong tungod sa iyang pagpakigsulti sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Sa pagkakita ni Aaron ug sa tanang mga Israelinhon sa nagdan-ag nga nawong ni Moises, nahadlok silang moduol kaniya. ");
INSERT INTO cebocb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Apan gitawag sila ni Moises, busa miduol si Aaron ug ang mga pangulo sa katilingban sa Israel, ug nakigsulti si Moises kanila. ");
INSERT INTO cebocb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Unya miduol ang tanang mga Israelinhon kaniya, ug gisulti niya kanila ang tanang sugo nga gihatag kaniya sa Ginoo didto sa Bukid sa Sinai. ");
INSERT INTO cebocb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Human makigsulti si Moises kanila, gitabonan niya ug belo ang iyang nawong. ");
INSERT INTO cebocb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Apan kon mosulod siya sa Tolda nga Tagboanan aron makigsulti sa Ginoo, ginakuha niya ang tabon hangtod nga makagawas siya sa Tolda. Iniggawas niya, gisulti niya sa mga Israelinhon ang tanang gisugo sa Ginoo kaniya, ");
INSERT INTO cebocb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ug makita sa mga Israelinhon nga nagdan-ag ang iyang nawong. Unya tabonan na usab niya ang iyang nawong hangtod nga mobalik siya sa Tolda sa pagpakigsulti sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Gitigom ni Moises ang tibuok katilingban sa Israel ug giingnan, “Mao kini ang gisugo sa Ginoo nga inyong himuon: ");
INSERT INTO cebocb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sulod sa unom ka adlaw, himoa ninyo ang inyong mga buluhaton, apan sa ikapitong adlaw pahulay kamo, kay kini nga adlaw balaan ug alang kini sa Ginoo. Si bisan kinsa nga motrabaho nianang adlawa patyon. ");
INSERT INTO cebocb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Busa ayaw gayod kamo pagtrabaho bisan na lang sa paghaling ug kalayo diha sa inyong mga puloy-anan nianang adlawa.” ");
INSERT INTO cebocb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Miingon si Moises sa tibuok katilingban sa Israel, “Mao kini ang gisugo sa Ginoo nga inyong himuon: ");
INSERT INTO cebocb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Maghalad kamo sa Ginoo ug mga butang gikan sa inyong kabtangan. Mahimo kamong maghalad ug bulawan, plata, bronsi, ");
INSERT INTO cebocb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","hilo nga kolor ube, asul, ug pula, panapton nga lino, panapton nga hinimo gikan sa balhibo sa kanding, ");
INSERT INTO cebocb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","panit sa laking karnero nga gitina ug pula, maayong klasi sa panit, kahoyng akasya; ");
INSERT INTO cebocb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lana sa olibo alang sa mga suga, mga lamas alang sa lana nga pangdihog ug sa humot nga insenso, ");
INSERT INTO cebocb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ug bato nga onix ug uban pang mahalong mga bato nga gamiton alang sa efod ug sa mga bulsa-bulsa sa sapaw sa dughan sa pangulong pari. ");
INSERT INTO cebocb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Ang tanan kaninyo nga adunay abilidad sa pagtrabaho kinahanglan moanhi aron sa paghimo sa tanang butang nga gisugo sa Ginoo nga himuon: ");
INSERT INTO cebocb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“ang Tolda nga Pagsimbahan ug ang mga tabon niini, mga kaw-it, mga dingding nga tabla, mga babag, mga haligi, ug mga tungtonganan; ");
INSERT INTO cebocb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ang Sudlanan sa Kasabotan ug ang mga pangdayong niini, tabon, ug kurtina; ");
INSERT INTO cebocb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ang lamisa ug mga pangdayong niini ug ang tanang kagamitan niini; ang pan nga ginahalad diha sa presensya sa Dios; ");
INSERT INTO cebocb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ang butanganan sa suga ug ang mga kagamitan niini; ang mga suga ug ang lana alang sa mga suga; ");
INSERT INTO cebocb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ang halaran nga sunoganan sa insenso ug ang mga pangdayong niini; ang lana nga pangdihog; ang humot nga insenso; ang kurtina sa pultahan sa Tolda nga Pagsimbahan; ");
INSERT INTO cebocb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ang halaran nga sunoganan sa halad nga sinunog ug ang sugbahanan nga bronsi, ang mga pangdayong niini, ug ang tanan nga kagamitan niini; ang bronsi nga palanggana ug ang tungtonganan niini; ");
INSERT INTO cebocb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ang mga kurtina sa palibot sa hawanan ug ang ilang mga haligi ug mga tungtonganan; ang kurtina sa pultahan sa hawanan; ");
INSERT INTO cebocb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ang mga ugsok ug mga higot nga pangbanting sa Tolda nga Pagsimbahan ug sa hawanan niini; ");
INSERT INTO cebocb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ug ang matahom ug sagrado nga mga bisti sa pari nga sul-obon ni Aaron ug sa iyang mga anak nga lalaki, kon moalagad sila diha sa Balaang Dapit.” ");
INSERT INTO cebocb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Unya mibiya ang tibuok katilingban sa Israel sa atubangan ni Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ang tanang gusto nga maghalad sa Ginoo nagdalag mga materyales nga gamiton sa paghimo sa Tolda nga Tagboanan ug sa tanang mga kagamitan niini, ug sa paghimog sagrado nga mga bisti sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ang tanan nga gustong mohalad, lalaki man ug babaye, nagdalag mahalong mga barpin, mga ariyos, mga pulseras, ug mga nagkalain-laing klasi sa mga alahas nga bulawan. Gidala nila kining mga bulawan nga halad ingon nga ginabayaw nga halad ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Adunay naghalad usab ug hilo nga kolor ube, asul ug pula, lino, panapton nga hinimo gikan sa balhibo sa kanding, panit sa laking karnero nga gitina ug pula, ug maayong klasi sa panit. ");
INSERT INTO cebocb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ang uban nagdalag plata, bronsi, ug mga tabla nga akasya ingon nga halad ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ang mga babaye nga adunay abilidad sa paghimog mga panapton nagdalag hilo nga kolor ube, asul ug pula, ug lino. ");
INSERT INTO cebocb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ug ang mga babaye nga kahibalong mohimo ug tanod nga gikan sa balhibo sa kanding, kinabubut-ong naghimo niini. ");
INSERT INTO cebocb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ang mga pangulo nagdala ug mga bato nga onix ug uban pang mahalong mga bato nga gamiton alang sa efod sa pangulong pari ug alang sa bulsa-bulsa nga ibutang sa dughan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nagdala usab silag mga lamas ug lana sa olibo alang sa mga suga, alang sa lana nga pangdihog, ug alang sa humot nga insenso. ");
INSERT INTO cebocb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ang tanang mga Israelinhon, lalaki ug babaye, nga gustong motabang sa tanan nga buluhaton nga gisugo sa Ginoo pinaagi kang Moises, nagdala sa ilang kinabubut-ong mga halad ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Miingon si Moises sa mga Israelinhon, “Paminaw! Gipili sa Ginoo si Bezalel, nga anak ni Uri ug apo ni Hur, nga gikan sa tribo ni Juda. ");
INSERT INTO cebocb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Gigamhan niya kini sa iyang Espiritu ug gihatagag kaalam ug abilidad sa pagbuhat ug bisan unsang buluhaton sama ");
INSERT INTO cebocb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","sa paghimog matahom nga mga butang nga hinimo gikan sa bulawan, plata, ug bronsi; ");
INSERT INTO cebocb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","sa pagkorti sa mahalong mga bato aron himuong bato sa mga alahas; sa pagkulit sa mga kahoy; ug sa tanang inantigo nga mga buluhaton. ");
INSERT INTO cebocb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Gihatagan usab sa Ginoo si Bezalel, ug si Oholiab nga anak ni Ahisamac nga gikan sa tribo ni Dan, sa abilidad sa pagtudlo sa uban sa ilang nahibaloan. ");
INSERT INTO cebocb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Gihatagan sila sa Ginoo ug kahanas sa paghimo sa tanang klasi sa buluhaton: sa pagdesenyo, sa paghabol ug panapton, ug sa pagborda sa lino ug hilo nga kolor ube, asul, ug pula. Makahimo sila sa paghimo sa bisan unsang klasi sa buluhaton, ug hanas gayod sila niini. ");
INSERT INTO cebocb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Si Bezalel, si Oholiab, ug ang uban pang gihatagan sa Ginoo ug kaalam ug abilidad sa nagkalain-laing buluhaton mao ang motrabaho sa Tolda sumala sa sugo sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Busa gipatawag ni Moises si Bezalel, si Oholiab, ug ang uban pang gihatagan sa Ginoo ug kaalam ug abilidad sa nagkalain-laing buluhaton, ug buot gayod nga motabang sa pagtrabaho. ");
INSERT INTO cebocb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Gihatag ni Moises kanila ang tanang gihalad sa mga Israelinhon alang sa pagpatindog sa Tolda. Ug padayon nga nagdala ang mga tawo sa ilang kinabubut-ong mga halad kada buntag. ");
INSERT INTO cebocb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Busa gibiyaan una sa mga trabahante sa Tolda ang ilang trabaho ug miadto kang Moises ug miingon, ");
INSERT INTO cebocb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Nanobra na sa gikinahanglan ang gipangdala sa mga tawo alang sa buluhaton nga gisugo sa Ginoo nga himuon.” ");
INSERT INTO cebocb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Busa nagpadala si Moises niining maong sugo ngadto sa tibuok kampo, “Wala nay maghalad alang sa pagpatindog sa Tolda.” Busa mihunong na ang mga tawo sa pagdala sa ilang mga halad, ");
INSERT INTO cebocb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","tungod kay nanobra na ang ilang gipanghatag alang sa tanang buluhaton. ");
INSERT INTO cebocb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ang tanang labing maayong motrabaho mao ang naghimo sa Tolda nga Pagsimbahan. Gihimo ang tolda gamit ang napulo ka panapton nga lino ug mga hilo nga kolor ube, asul, ug pula. Ug gibordahan kini ug kerubin sa mga hanas moborda. ");
INSERT INTO cebocb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ang kada panapton adunay gitas-on nga 42 ka piye ug adunay gilapdon nga unom ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Gisumpay nila kini sa tinag-lima; bali duha ka tag-lima. ");
INSERT INTO cebocb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Unya gibutangan nilag mga singsing nga hinimo sa panapton nga asul ang kilid sa matag hut-ong sa sinumpay nga mga panapton; ");
INSERT INTO cebocb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","tag-50 ka mga singsing ang ilang gibutang sa kada kilid. ");
INSERT INTO cebocb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Naghimo usab silag 50 ka kaw-it nga bulawan aron masumpay ang mga singsing sa duha ka hut-ong sa sinumpay nga mga panapton. Niining paagiha nahimo ang Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Unya naghimo silag tabon alang sa Tolda. Ang ilang ginamit 11 kabuok panapton nga hinimo gikan sa balhibo sa kanding. ");
INSERT INTO cebocb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ang kada panapton adunay gitas-on nga 45 ka piye ug adunay gilapdon nga unom ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Gisumpay nila ang lima ka panapton, ug mao usab ang nahibiling unom. ");
INSERT INTO cebocb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Gibutangan nilag 50 ka mga singsing ang kilid sa kataposang panapton sa duha ka hut-ong sa sinumpay nga mga panapton, ");
INSERT INTO cebocb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ug gisumpay nila kini ginamit ang 50 ka kaw-it nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ang ibabaw niining tabon gihaklapan nilag panit sa laking karnero nga gitina ug pula, ug gisapawan pa gayod nilag maayong klasi sa panit. ");
INSERT INTO cebocb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Unya naghimo silag dingding sa Tolda ginamit ang tabla nga akasya. ");
INSERT INTO cebocb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ang gitas-on sa kada tabla 15 ka piye ug ang gilapdon duha ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ang kada tabla gibutangan nilag duha ka dila-dila aron masumpay kini sa laing tabla. Sama niini ang gihimo nila sa kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ang 20 niini nga mga tabla gigamit nila sa habagatang bahin sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Kini nga mga tabla gipahaom nila sa 40 ka tungtonganan nga plata nga duha ka tungtonganan sa kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ang amihan nga bahin sa Tolda gigamitan usab nilag 20 ka tabla, ");
INSERT INTO cebocb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ug gipahaom usab sa 40 ka tungtonganan nga plata nga duha ka tungtonganan sa kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ang kasadpang bahin sa Tolda gigamitan nilag unom ka tabla, ");
INSERT INTO cebocb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ug duha ka tabla sa mga eskina niini. ");
INSERT INTO cebocb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kining mga tablaha sa mga eskina nasumpay pag-ayo sa ubos hangtod sa ibabaw. Sama usab niini ang ilang gihimo sa laing duha pa ka tabla sa mga eskina. ");
INSERT INTO cebocb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Busa adunay walo ka tabla sa maong bahin sa Tolda, ug nahaom kini sa 16 ka tungtonganan nga plata nga duha ka tungtonganan sa kada tabla. ");
INSERT INTO cebocb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Naghimo usab silag mga pangbabag nga akasya sa dingding nga lima alang sa amihan nga bahin sa Tolda, ");
INSERT INTO cebocb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lima usab alang sa habagatang bahin, ug lima alang sa kasadpang bahin, luyo sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ang babag sa tunga-tungang bahin sa dingding nga ilang gibutang naggikan sa usa ka tumoy sa Tolda ug gipalapos kini sa pikas tumoy. ");
INSERT INTO cebocb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Gihaklapan nilag bulawan ang mga tabla ug gibutangan ug mga singsing nga bulawan nga maoy tuhogan sa mga pangbabag sa dingding nga hinaklapan usab ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Naghimo usab silag kurtina gikan sa lino ug hilo nga kolor ube, asul ug pula, ug binordahan kini ug kerubin. ");
INSERT INTO cebocb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Naghimo usab silag upat ka haligi nga akasya nga gihaklapan nila ug bulawan. Unya gihimoan nila kinig mga kaw-it nga bulawan ug upat ka tungtonganan nga plata. ");
INSERT INTO cebocb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Naghimo sila ug usa pa ka kurtina alang sa Tolda nga Pagsimbahan. Ang gigamit nila lino nga adunay hilo nga kolor ube, asul, ug pula. Ug maayo gayod ang pagkaborda niini. ");
INSERT INTO cebocb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Naghimo silag lima ka haligi nga adunay mga kaw-itanan alang niini. Kini nga mga haligi hinaklapan ug bulawan lakip ang mga ulo-ulo niini ug mga singsing, ug gipahaom kini sa lima ka tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Unya gihimo ni Bezalel ang Sudlanan sa Kasabotan. Ang gigamit niya kahoy nga akasya. Ang gitas-on sa Sudlanan 45 ka pulgada, ang gilapdon 27 ka pulgada, ug ang gihabugon 27 ka pulgada. ");
INSERT INTO cebocb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Gihaklapan niya kinig purong bulawan sa sulod ug gawas, ug giribetihan ug bulawan ang mga kilid niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Gihimoan usab niya kinig upat ka mga singsing nga bulawan ug gitaod sa upat ka mga haligi niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Unya naghimo siyag mga pangdayong nga akasya ug gihaklapan niya kinig bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Gisuot niya ang mga pangdayong sa mga singsing sa kada kilid sa Sudlanan aron madayongan ang Sudlanan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Gihimoan usab niya ang Sudlanan ug taklob nga purong bulawan, nga 45 ka pulgada ang gitas-on ug 27 ka pulgada ang gilapdon. ");
INSERT INTO cebocb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Naghimo usab siya ug duha ka kerubin gamit ang dinukdok nga bulawan, ug gibutang niya kini sa isigka-tumoy sa taklub. ");
INSERT INTO cebocb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Iyang gibutang ang usa ka kerubin sa usa ka tumoy ug ang usa usab sa pikas; gihimo niya ang mga kerubin ug ang taklub nga isa lang kabuok. ");
INSERT INTO cebocb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nag-atbang kini sila nga nagtan-aw sa tabon, ug ang ilang mga pako nagbukhad sa pagpandong niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Naghimo usab siyag lamisa nga akasya nga 36 ka pulgada ang gitas-on, 18 ka pulgada ang gilapdon, ug 27 ka pulgada ang gihabugon. ");
INSERT INTO cebocb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Gihaklapan niya kinig purong bulawan ug giribetihan ug bulawan ang mga kilid niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Gibutangan usab niya kinig sanipa sa kada kilid, nga upat ka pulgada ang gilapdon, ug giribetihan ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Unya naghimo siyag upat ka mga singsing nga bulawan, ug gitaod kini sa upat ka eskina sa adunay tiil sa lamisa ");
INSERT INTO cebocb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","duol sa sanipa. Dinhi niya gisuot ang mga pangdayong sa lamisa. ");
INSERT INTO cebocb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Kini nga mga pangdayong hinimo gikan sa akasya ug hinaklapan ug bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Naghimo usab siyag mga kagamitan nga purong bulawan alang sa lamisa: mga plato, mga tasa, mga yahong, ug mga tibod nga gamiton alang sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Naghimo usab siyag butanganan sa suga nga purong bulawan ang tiil ug lawas niini, ug gidekorasyonan kinig mga bulak nga ang uban piyoos pa ug ang uban namukhad na. Unay sa butanganan sa suga ang mga dekorasyon niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ang butanganan sa suga kinahanglang adunay unom ka mga sanga, tag-tulo sa kada kilid. ");
INSERT INTO cebocb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ang kada sanga adunay tulo ka dekorasyon nga mga bulak nga ang korte murag almond, nga ang uban piyoos pa ug ang uban namukhad na. ");
INSERT INTO cebocb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ang lawas sa butanganan sa suga adunay upat ka dekorasyon nga mga bulak nga ang korte murag almond, nga ang uban piyoos pa ug ang uban namukhad na. ");
INSERT INTO cebocb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Adunay usa ka bulak sa ubos sa matag bahin diin magtagbo ang mga sanga. ");
INSERT INTO cebocb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ang mga dekorasyon ug ang mga sanga unay sa lawas sa butanganan sa suga sa paghimo niini gikan sa bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Naghimo usab siyag pito ka suga, mga kimpit niini, ug mga pangsalod sa upos sa pabilo sa suga. Kining tanan purong bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Mga 35 ka kilo nga purong bulawan ang nagamit sa paghimo sa butanganan sa suga ug sa tanang kagamitan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Naghimo usab siyag halaran nga sunoganan sa insenso nga hinimo gikan sa akasya. Kuwadrado kini, nga 18 ka pulgada ang gitas-on ug gilapdon, ug tulo ka piye ang gihabugon. Adunay mga sungay-sungay sa mga eskina niini nga unay sa lawas sa paghimo niining halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Gihaklapan niya ug purong bulawan ang ibabaw niini, ang upat ka kilid, ug ang mga sungay-sungay sa kada eskina, ug giribetihan ug bulawan sa palibot. ");
INSERT INTO cebocb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Gibutangan niyag duha ka mga singsing nga bulawan ubos sa ribeti sa isigka-kilid sa halaran, aron suotan sa mga pangdayong niini. ");
INSERT INTO cebocb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Naghimo siya ug pangdayong gikan sa kahoy nga akasya ug gihaklapan niya kinig bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Naghimo usab siyag balaang lana nga pangdihog ug purong insenso nga humot kaayo. ");
INSERT INTO cebocb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Naghimo usab siyag kuwadradong halaran nga sunoganan sa halad nga sinunog. Kahoy nga akasya ang gigamit niini. Ang gitas-on ug gilapdon pito ug tunga ka piye, ug ang gihabugon upat ug tunga ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Gibutangan niya kinig sungay-sungay nga unay sa upat ka eskina niini. Gihaklapan niyag bronsi ang halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ang tanang kagamitan sa halaran hinimo usab gikan sa bronsi, ang mga butanganan sa abo, mga pala, mga yahong, mga dagkong tinidor alang sa karne, ug mga butanganan sa baga. ");
INSERT INTO cebocb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Naghimo usab siyag sugbahanan nga bronsi alang sa halaran, ug gibutang kini sa tungtonganan niini nga anaa sa sulod sa halaran, sa tunga-tunga nga bahin gikan sa ibabaw. ");
INSERT INTO cebocb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Naghimo usab siyag upat ka mga singsing nga bronsi ug gitaod kini diha sa upat ka eskina sa sugbahanan nga bronsi. Kining mga singsing mao ang tuhogan sa mga pangdayong sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ang mga pangdayong hinimo gikan sa kahoy nga akasya ug gihaklapan ug bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Gituhog niya ang mga pangdayong sa mga singsing sa kada kilid sa halaran aron madayongan ang halaran. Tabla ang gihimo nila nga halaran ug adunay hawan ang sulod niini. ");
INSERT INTO cebocb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Unya naghimo siyag palanggana ug tungtonganan niini gikan sa bronsi nga salamin sa mga babaye nga nag-alagad diha sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Gihimoan niyag hawanan ang Tolda nga Tagboanan ug gilibotan kinig mga kurtina nga hinimo gikan sa lino. Ang gitas-on sa mga kurtina dapit sa habagatan 150 ka piye. ");
INSERT INTO cebocb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Gitaod nila kini nga mga kurtina sa mga kaw-it nga plata nga unay sa kabilya nga plata diha sa 20 ka haligi nga bronsi nga gipahaom usab sa 20 ka tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ang kurtina sa amihan nga bahin 150 usab ka piye ang gitas-on, ug gisab-it usab kini sa mga kaw-it nga plata nga nasumpay sa mga kabilya nga plata diha sa 20 ka mga haligi nga bronsi nga gipahaom sa 20 usab ka tungtonganan nga bronsi. ");
INSERT INTO cebocb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ang kurtina sa kasadpang bahin 75 ka piye ang gitas-on, ug gisab-it kini sa mga kaw-it nga plata nga unay sa mga kabilya nga plata diha sa napulo ka haligi nga gipahaom sa napulo usab ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ang mga kurtina sa sidlakang bahin 75 usab ka piye ang gitas-on. ");
INSERT INTO cebocb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ang pultahan sa hawanan nga anaa sa sidlakan aduna usab kini mga kurtina sa kilid. Ang kurtina sa tuo 22 ka piye ang gitas-on, ug gisab-it kini diha sa tulo ka haligi nga gipahaom sa tulo usab ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ang kurtina sa wala 22 ug tunga usab ka piye ang gitas-on, ug gitaod usab kini diha sa tulo ka haligi nga gipahaom usab sa tulo ka tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ang tanang kurtina sa palibot sa hawanan lino. ");
INSERT INTO cebocb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ang mga tungtonganan sa mga haligi bronsi, ug ang mga kaw-it ug mga kabilya niini hinimo sa plata. Ang mga ulo-ulo sa mga haligi gihaklapan ug plata. Ang tanang haligi sa palibot sa hawanan adunay mga kabilya nga plata. ");
INSERT INTO cebocb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ang kurtina sa pultahan sa hawanan lino nga adunay hilo nga kolor ube, asul, ug pula. Ug maayo kaayo ang pagkaborda niini. Ang gitas-on niini 30 ka piye ug ang gihabugon pito ug tunga ka piye, sama sa gihabugon sa mga kurtina sa palibot sa hawanan. ");
INSERT INTO cebocb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kini nga mga kurtina nataod diha sa upat ka haligi nga gipahaom sa upat usab ka tungtonganan. Ang mga kaw-it ug mga kabilya sa mga haligi plata, ug ang ilang mga ulo-ulo gihaklapan ug plata. ");
INSERT INTO cebocb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Purong bronsi ang tanang ugsok sa Tolda nga Pagsimbahan ug sa mga kurtina sa palibot niini. ");
INSERT INTO cebocb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mao kini ang mga materyales nga gigamit sa pagpatindog sa Tolda nga Pagsimbahan, diin gibutang ang Kasugoan. Kini nga mga materyales gilista sa mga kaliwat ni Levi sumala sa sugo ni Moises. Kini nga buluhaton gidumalahan ni Itamar nga anak sa pari nga si Aaron. ");
INSERT INTO cebocb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ang nagdumala sa pagpatindog sa Tolda nga Pagsimbahan mao si Bezalel nga anak ni Uri ug apo ni Hur, nga gikan sa tribo ni Juda. Gihimo niya ang tanang gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ang iyang katabang mao si Oholiab nga anak ni Ahisamac, nga gikan sa tribo ni Dan. Maayo kaayo siyang motrabaho ug modesenyo, ug moborda sa lino ug sa hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ang gibug-aton sa tanang bulawan nga gihalad aron gamiton sa pagtrabaho sa Tolda nga Simbahanan 1,000 ka kilo basi sa timbangan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Ang gibug-aton sa tanang pilak nga natigom 3,520 ka kilo basi sa timbangan nga ginagamit sa mga pari. Gikan kini sa mga tawo nga nalista sa pag-ihap. Ang kada usa kanila naghatag ug unom ka gramo nga pilak basi sa timbangan nga ginagamit sa mga pari. Adunay 603,550 ka mga tawo nga nag-edad ug 20 ka tuig pataas nga nalista sa pag-ihap. ");
INSERT INTO cebocb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ang 3,500 ka kilo nga pilak gigamit sa paghimo sa 100 ka mga tungtonganan sa Tolda ug sa mga haligi sa kurtina. Balig 35 ka kilo kada tungtonganan. ");
INSERT INTO cebocb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ang nahibiling 20 ka kilo nga salapi gihimo nga mga kaw-it ug mga kabilya, ug gihaklap sa mga ulo-ulo sa mga haligi. ");
INSERT INTO cebocb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ang gibug-aton sa bronsi nga gihalad ngadto sa Ginoo 2,500 ka kilo. ");
INSERT INTO cebocb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Gigamit kini sa paghimo sa mga tungtonganan sa mga haligi sa pultahan sa Tolda nga Tagboanan. Ang uban niini gigamit sa paghimo sa halaran nga bronsi ug sa sugbahanan niini, ug sa tanan nga kagamitan sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Gigamit usab ang mga bronsi sa paghimo ug mga tungtonganan sa mga haligi sa palibot sa hawanan ug sa mga pultahan niini, ug sa paghimo sa tanan nga ugsok sa mga banting sa Tolda nga Pagsimbahan ug sa mga kurtina sa palibot niini. ");
INSERT INTO cebocb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nagtahi usab sila si Bezalel ug sagrado nga mga bisti alang sa mga pari sumala sa gisugo sa Ginoo kang Moises. Ang panapton nga ilang gigamit hilo nga kolor ube, asul, ug pula. Mao usab kini nga panapton ang gigamit nila sa pagtahi sa bisti alang kang Aaron samtang mag-alagad siya sa Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nagtahi usab silag efod gamit ang lino nga gibordahan ug hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Naghimo silag tanod nga bulawan pinaagi sa pagpipi ug bulawan ug sa paghiwa-hiwa niini ug nipis. Unya giborda nila kini sa lino nga binordahan usab ug hilo nga kolor ube, asul, ug pula. Maayo kaayo ang pagkaborda niini. ");
INSERT INTO cebocb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Adunay duha ka bahin kining efod, luyo ug atubangan, ug nasumpay kining duha pinaagi sa strap sa abaga. ");
INSERT INTO cebocb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ang bakos niini lino usab nga binordahan ug tanod nga bulawan ug hilo nga kolor ube, asul, ug pula. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Gitaod nila ang mga bato nga onix sa bayanan nga bulawan. Gikulitan nila kinig mga ngalan sa mga anak nga lalaki ni Jacob sama sa pagkulit ug silyo. ");
INSERT INTO cebocb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Unya gitaod nila kini diha sa mga strap sa efod ingon nga handomanan nga mga bato alang sa mga tribo sa Israel. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Naghimo usab silag sapaw sa dughan nga adunay mga bulsa-bulsa, ug maayo kaayo ang pagkahimo niini. Ang panapton niini sama sa panapton sa efod: lino nga gibordahan ug tanod nga bulawan ug tanod nga hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kining sapaw sa dughan kinahanglan gidoble pagpilo ug kuwadrado nga siyam ka pulgada ang gitas-on ug siyam ka pulgada ang gilapdon. ");
INSERT INTO cebocb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Gibutangan nila kinig upat ka laray sa mahalong mga bato: sa unang laray, rubi, topas, ug beril; ");
INSERT INTO cebocb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","sa ikaduhang laray, emerald, sapiro, ug diamante; ");
INSERT INTO cebocb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","sa ikatulong laray, hasinto, agate, ug ametis; ");
INSERT INTO cebocb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ug sa ikaupat nga laray, krisolito, onix, ug jasper. Gibutang nila kini sa mga bayanan nga bulawan. ");
INSERT INTO cebocb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ang kada bato adunay ngalan sa usa sa mga anak ni Jacob sa pagrepresentar sa 12 ka tribo sa Israel. Ang pagkakulit sa mga ngalan sama sa pagkulit ug silyo. ");
INSERT INTO cebocb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Gibutangan usab nilag kadena nga purong bulawan ang sapaw sa dughan nga adunay mga bulsa-bulsa. ");
INSERT INTO cebocb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Naghimo usab silag duha ka bayanan nga bulawan ug duha ka singsing nga bulawan, ug gikabit nila ang duha ka singsing sa ibabaw nga mga eskina sa sapaw sa dughan. ");
INSERT INTO cebocb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Gikabit nila ang duha ka kadena nga bulawan diha sa duha ka singsing sa sapaw sa dughan, ");
INSERT INTO cebocb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ug ang duha ka tumoy sa kadena gikabit nila sa duha ka bayanan nga bulawan nga anaa sa strap sa efod. ");
INSERT INTO cebocb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Naghimo usab silag duha pa ka singsing nga bulawan ug gitaod nila kini sa ubos nga mga eskina sa sapaw sa dughan, nga gisapaw sa efod. ");
INSERT INTO cebocb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Naghimo pa gayod silag duha pa ka singsing nga bulawan ug gihigot nila kini sa efod dapit sa bakos. ");
INSERT INTO cebocb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Unya gihigtan nila ug asul nga higot ang ubos nga mga singsing sa sapaw sa dughan ug ang mga singsing nga diha sa efod. Niining paagiha naplastar pag-ayo ang sapaw sa dughan ibabaw sa bakos ug dili mabulag gikan sa efod. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Naghimo usab silag panggawas nga bisti, kining bistiha sapawan sa efod. Ang panapton nga ilang gigamit sa paghimo niini purong asul. ");
INSERT INTO cebocb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kini nga bisti adunay liab nga gisigsagan aron dili kini magisi. ");
INSERT INTO cebocb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Gibitayan nila ang palibot sa sidsid sa bisti ug mga dayandayan nga pormag prutas nga pomegranata, nga hinimo gikan sa lino ug hilo nga kolor ube, asul, ug pula. ");
INSERT INTO cebocb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","Gisal-angan nila kini nga mga dayandayan ug mga gagmayng kampanilya nga purong bulawan. Kini nga bisti sul-obon ni Aaron kon mag-alagad siya sa Ginoo. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Naghimo usab silag pang-ilalom nga mga bisti alang kang Aaron ug sa iyang mga anak nga lalaki. Ang panapton nga ilang gigamit lino. ");
INSERT INTO cebocb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Mao usab nga panapton ang ilang gigamit sa paghimo sa mga turban, mga kalo ug mga pang-ilalom nga bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ang mga bakos lino usab nga adunay hilo nga kolor ube, asul, ug pula. Ug maayo gayod ang pagkaborda niini. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Naghimo usab silag medalyon nga purong bulawan ug sama sa pagkulit sa silyo gipakulitan kini sa mga pulong: Gilain alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Gitaod nila kini sa atubangan sa turban pinaagi sa asul nga higot. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nahuman ang tanang buluhaton sa Tolda nga Pagsimbahan, nga gitawag usab ug Tolda nga Tagboanan. Gihimo sa mga Israelinhon ang tanang gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Gipakita nila kang Moises ang Tolda nga Pagsimbahan ug ang tanang kagamitan niini: ang mga kaw-it, mga dingding, mga pangbabag, mga haligi, mga tungtonganan, ");
INSERT INTO cebocb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ang tabon nga hinimo gikan sa mga panit sa laking karnero nga gitina ug pula, ang tabon nga hinimo gikan sa maayong klasi sa panit, ang mga kurtina, ");
INSERT INTO cebocb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ang Sudlanan sa Kasugoan ug ang iyang tabon ug mga pangdayong, ");
INSERT INTO cebocb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ang lamisa ug ang tanang kagamitan niini, ang pan nga ginahalad sa presensya sa Ginoo, ");
INSERT INTO cebocb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ang butanganan sa suga nga purong bulawan ug ang naglaray nga mga suga ug ang kagamitan niini, ang lana alang sa mga suga, ");
INSERT INTO cebocb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ang halaran nga bulawan, ang lana nga pangdihog, ang humot nga insenso, ang kurtina sa pultahan sa Tolda, ");
INSERT INTO cebocb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ang halaran nga bronsi ug ang sugbahanan niini nga bronsi, ang iyang mga pangdayong, ug ang tanang kagamitan niini, ang palanggana ug ang tungtonganan niini, ");
INSERT INTO cebocb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ang mga kurtina sa palibot sa hawanan ug ang ilang mga haligi ug mga tungtonganan, ang kurtina sa pultahan sa hawanan, ang mga higot ug mga ugsok alang sa kurtina sa hawanan, ang tanan nga kagamitan sa Tolda nga Pagsimbahan, nga gitawag usab ug Tolda nga Tagboanan, ");
INSERT INTO cebocb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ug ang matahom ug sagrado nga mga bisti sa pari nga sul-obon ni Aaron ug sa iyang mga anak nga lalaki, kon moalagad sila diha sa Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Gihimo sa mga Israelinhon ang tanang buluhaton sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Gitan-aw ni Moises ang ilang trabaho, ug nakita niya nga gihimo nila kining tanan sumala sa gisugo sa Ginoo. Busa gipanalanginan sila ni Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Unya miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ipahimutang ninyo ang Tolda nga Pagsimbahan, sa unang adlaw sa unang bulan. ");
INSERT INTO cebocb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Isulod niini ang Sudlanan sa Kasugoan, ug salipdi kini sa kurtina. ");
INSERT INTO cebocb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Isulod usab ang lamisa ug iplastar ang mga kagamitan niini. Isulod usab ang butanganan sa suga ug ipahimutang ang mga suga niini. ");
INSERT INTO cebocb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ibutang ang bulawan nga halaran nga sunoganan sa insenso sa atbang sa Sudlanan sa Kasugoan, ug itaod ang kurtina diha sa pultahan sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ibutang ang halaran nga sunoganan sa halad nga sinunog diha sa atubangan sa pultahan sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ibutang ang palanggana sa tunga-tunga sa Tolda ug sa halaran, ug butangi kinig tubig. ");
INSERT INTO cebocb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ipangtaod ang mga kurtina sa hawanan, nga naglibot sa Tolda, lakip ang kurtina sa pultahan niini. ");
INSERT INTO cebocb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Unya kuhaa ang lana ug dihogi ang Tolda ug ang tanang kagamitan niini sa pagdedikar niini kanako, ug mahimo kining sagrado. ");
INSERT INTO cebocb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Dihogi usab ang halaran nga sunoganan sa halad nga sinunog ug ang tanang kagamitan niini sa pagdedikar niini kanako, ug mahimo kining labing sagrado. ");
INSERT INTO cebocb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Dihogi usab ang palanggana ug ang iyang tungtonganan sa pagdedikar niini kanako. ");
INSERT INTO cebocb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Dad-a si Aaron ug ang iyang mga anak nga lalaki didto sa pultahan sa Tolda nga Tagboanan ug ipakaligo sila didto. ");
INSERT INTO cebocb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Unya ipasul-ob kang Aaron ang sagradong mga bisti ug idedikar siya kanako pinaagi sa pagdihog kaniya sa lana aron makaalagad siya kanako ingon nga pari. ");
INSERT INTO cebocb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dad-a usab ang iyang mga anak nga lalaki ug ipasul-ob kanila ang ilang pangsulod nga bisti. ");
INSERT INTO cebocb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Dihogi usab sila sa lana sama sa gihimo mo sa ilang amahan, aron makaalagad usab sila kanako ingon nga mga pari hangtod sa umaabot nga henerasyon.” ");
INSERT INTO cebocb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Gihimo ni Moises ang tanang gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Busa gipatindog ang Tolda nga Pagsimbahan sa unang adlaw sa unang bulan. Ikaduha kadto nga tuig gikan sa paggawas nila sa Ehipto. ");
INSERT INTO cebocb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ingon niini pagpatindog ni Moises ang Tolda: Gipahimutang niya ang mga tungtonganan, ang mga dingding, ang mga pangbabag, ug ang mga haligi. ");
INSERT INTO cebocb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Unya gibukhad niya ang Tolda, ug gisapaw ang tabon alang niini. Gihimo niya kining tanan sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Unya gisulod niya sa Sudlanan ang lagpad nga mga bato nga gisulatan sa Kasugoan, ug gisuot niya sa mga singsing sa Sudlanan ang mga pangdayong, ug gitabonan kini. ");
INSERT INTO cebocb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Unya gisulod niya ang Sudlanan sa Tolda nga Pagsimbahan, ug gitaod niya ang kurtina aron masalipdan ang Sudlanan sa Kasugoan. Gihimo niya kining tanan sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Gibutang niya ang lamisa sa sulod sa Tolda, sa adunay amihan nga bahin, gawas sa kurtina. ");
INSERT INTO cebocb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Unya gibutang niya sa lamisa ang pan nga ginahalad sa presensya sa Ginoo. Gihimo niya kining tanan sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Gibutang usab niya ang butanganan sa suga didto sa sulod sa Tolda, atbang sa lamisa, sa may habagatang bahin. ");
INSERT INTO cebocb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ug gibutang niya ang mga suga niini diha sa presensya sa Ginoo. Gihimo niya kining tanan sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Gibutang usab niya ang bulawan nga halaran sa sulod sa Tolda, atubangan sa kurtina, ");
INSERT INTO cebocb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ug nagsunog siyag humot nga insenso diha niini. Gihimo niya kining tanan sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Gitaod usab niya ang kurtina sa entrada sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ug gibutang niya didto duol sa pultahan ang halaran nga sunoganan sa halad nga sinunog. Unya naghalad siya sa maong halaran ug mga halad nga sinunog ug mga halad sa pagpasidungog sa Ginoo. Gihimo niya kining tanan sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Gibutang usab niya ang palanggana sa tunga-tunga sa Tolda ug sa halaran, ug gisudlan niyag tubig nga panghugas. ");
INSERT INTO cebocb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Didto nanghugas si Moises, si Aaron, ug ang iyang mga anak nga lalaki sa ilang mga kamot ug tiil. ");
INSERT INTO cebocb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Manghugas sila kon mosulod sila sa Tolda o kon moduol sila sa halaran. Gihimo nila kining tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Unya gibutang ni Moises ang mga kurtina sa hawanan nga naglibot sa Tolda ug sa halaran, ug ang kurtina sa pultahan sa hawanan. Ug nahuman gayod ni Moises ang tanang buluhaton. ");
INSERT INTO cebocb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Pagkahuman niining tanan, ang gamhanang presensya sa Ginoo milukop sa Tolda nga Tagboanan, sa dagway sa panganod. ");
INSERT INTO cebocb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Dili makasulod si Moises sa Tolda tungod kay nalukop kini sa gamhanang presensya sa Ginoo pinaagi sa dagway sa panganod. ");
INSERT INTO cebocb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kon mopaibabaw gani ang panganod sa Tolda ug mosibog, manglakaw usab ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Apan kon dili gani mosibog ang panganod, dili usab sila mopadayon sa ilang lakaw hangtod nga mopaibabaw na usab kini ug mosibog. ");
INSERT INTO cebocb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kay ang panganod nga nagsimbolo sa presensya sa Ginoo ibabaw sa Tolda kon adlaw, ug kon gabii adunay kalayo diha sa panganod aron makita kini sa tanang Israelinhon sa tibuok nila nga lakaw.");
INSERT INTO cebocb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Gitawag sa Ginoo si Moises didto sa Tolda nga Tagboanan miingon kaniya, ");
INSERT INTO cebocb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Sultihi ang mga Israelinhon: ‘Kon aduna kaninyoy maghalad ug mananap ngadto sa Ginoo, maghalad siya ug baka, karnero, o kanding. ");
INSERT INTO cebocb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kon baka ang iyang ihalad isip halad nga sinunog, kinahanglan nga laki kini ug walay depekto, ug ihalad niya kini duol sa entrada sa Tolda nga Tagboanan, aron dawaton siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Itungtong niya ang iyang kamot sa ulo sa baka nga iyang gihalad, ug dawaton kini sa Ginoo aron mahinloan siya gikan sa iyang mga sala. ");
INSERT INTO cebocb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Unya ihawon niya kini nga mananap diha sa presensya sa Ginoo. Ug ang dugo niini isablig sa mga pari nga kaliwat ni Aaron palibot sa halaran, nga anaa sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Unya panitan sa maghahalad ang mananap ug hiwa-hiwaon. ");
INSERT INTO cebocb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Pagkahuman, ang mga pari nga kaliwat ni Aaron maghaling sa halaran ug sugnoran nila kini ug mga kahoy nga giayo ug plastar. ");
INSERT INTO cebocb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Unya ipahimutang nila sa kalayo ang hiniwa nga mga bahin sa mananap, apil ang ulo ug ang mga tambok. ");
INSERT INTO cebocb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Apan hugasan sa maghahalad ang mga sulod sa ginhawaan ug ang mga tiil sa mananap. Pagkahuman, ang pari mao na ang mosunog niining tanan diha sa halaran ingon nga halad nga sinunog. Ang kahumot niining halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Kon karnero o kanding ang ihalad sa tawo ingon nga halad nga sinunog, kinahanglan nga laki kini ug walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ihawon niya kini diha sa presensya sa Ginoo didto sa amihan nga dapit sa halaran. Ug ang dugo niini isablig sa mga pari nga kaliwat ni Aaron palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Human kini mahiwa-hiwa sa maghahalad, ipahimutang kini sa pari ngadto sa kalayo, apil ang ulo ug ang mga tambok. ");
INSERT INTO cebocb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Unya hugasan sa maghahalad ang mga bahin nga anaa sa sulod sa ginhawaan ug ang mga tiil niini. Pagkahuman, ang pari mao na ang mosunog niining tanan sa halaran ingon nga halad nga sinunog. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Kon langgam ang ihalad sa tawo isip halad nga sinunog sa Ginoo, kinahanglan nga salampati kini o tukmo. ");
INSERT INTO cebocb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Dad-on kini sa pari didto sa halaran. Lubagon niya ang liog hangtod nga maputol ug ipatulo niya ang dugo ngadto sa kilid sa halaran, ug unya sunogon niya ang ulo. ");
INSERT INTO cebocb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Pagkahuman, kuhaon niya ang balon-balonan ug ang mga balhibo niini, ug unya ilabay niya sa sidlakang bahin sa halaran diin gibutang ang abo. ");
INSERT INTO cebocb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Pikason niya ang langgam pinaagi sa pagbira sa mga pako niini apan dili niya kini tungaon. Unya sunogon niya ang langgam diha sa halaran ingon nga halad nga sinunog. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Kon adunay maghalad ug halad sa pagpasidungog sa Ginoo, gamiton niya ang pinakamaayo nga klasi sa harina, ug butangan niya kinig mantika ug insenso. ");
INSERT INTO cebocb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Dad-on niya kini didto sa mga pari nga kaliwat ni Aaron. Unya kuhaan sa pari ug usa ka kumkom ang harina nga sinagolan ug mantika, ug sunogon niya kini diha sa halaran. Sunogon niya kini isip paghinumdom sa Ginoo. Ang kahumot niini nga halad makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ang nasobra sa harina nga gihalad iya na sa mga pari nga kaliwat ni Aaron, ug balaan kaayo kini tungod kay kabahin kini sa halad nga alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Kon pan nga linuto sa pugon ang ihalad sa pagpasidungog sa Ginoo, kinahanglan nga hinimo kini gikan sa maayong klasi sa harina ug walay patubo. Mahimong ihalad ang baga nga pan nga sinagolan ug mantika o ang nipis nga pan nga pinahiran ug mantika. ");
INSERT INTO cebocb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kon ang pan nga ihalad linuto sa lapad nga kalaha, kinahanglan nga gikan kini sa maayong klasi sa harina ug gisagolan ug mantika, ug walay patubo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Pikas-pikason kini ug buboan ug mantika. Halad kini sa pagpasidungog sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kon ang pan nga ihalad linuto sa lawom nga kalaha, kinahanglan nga hinimo kini gikan sa maayong klasi sa harina ug gisagolan usab ug mantika. ");
INSERT INTO cebocb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Dad-a ngadto sa pari kini nga halad aron iyang ihalad ngadto sa Ginoo didto sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kuhaan kini sa pari, ug ang iyang gikuha sunogon niya diha sa halaran isip paghinumdom sa Ginoo. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ang nasobra sa gihalad iya na sa mga pari nga kaliwat ni Aaron, ug balaan kaayo kini tungod kay kabahin kini sa halad nga alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Ang tanang halad sa pagpasidungog nga ginahalad sa Ginoo kinahanglan nga walay patubo, kay dili kamo mahimong magsunog ug patubo o dugos sa inyong paghalad sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mahimo ninyong ihalad ang patubo o dugos isip halad gikan sa inyong unang abot, apan dili kini angay sunogon diha sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Asini ang tanan ninyong halad sa pagpasidungog sa Ginoo, kay ang asin simbolo sa inyong walay kataposan nga kasabotan sa Dios. Asini ninyo ang tanang mga halad. ");
INSERT INTO cebocb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Kon maghalad kamo sa inyong unang abot ingon nga halad sa pagpasidungog sa Ginoo, paghalad kamog ginaling o sinanlag nga mga trigo. ");
INSERT INTO cebocb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Butangan ninyo kini ug mantika ug insenso. Halad kini sa pagpasidungog. ");
INSERT INTO cebocb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sunogon sa pari ang ubang ginaling nga mga trigo nga adunay mantika ug ang tanang insenso nga gibutang niini aron sa paghinumdom sa Ginoo. Halad kini pinaagi sa kalayo alang sa Ginoo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Kon adunay maghalad ug baka ingon nga halad alang sa pakigda-it, kinahanglan nga ang iyang ihalad sa presensya sa Ginoo walay depekto, laki man o baye. ");
INSERT INTO cebocb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ipatong niya ang iyang kamot diha sa ulo sa baka, ug ihawon niya kini duol sa pultahan sa Tolda nga Tagboanan. Ang dugo niini isablig sa mga pari nga kaliwat ni Aaron palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Magkuha ang pari ug mga bahin niini nga sunogon isip halad alang sa Ginoo: ang tanang tambok sulod sa ginhawaan sa baka, ");
INSERT INTO cebocb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ang mga bato-bato apil ang tambok niini, ug ang gamay nga bahin sa atay. ");
INSERT INTO cebocb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Unya sunogon kini sa mga pari nga kaliwat ni Aaron didto sa halaran uban sa halad nga sinunog. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Kon karnero o kanding ang iyang ihalad ingon nga halad alang sa pakigda-it ngadto sa Ginoo, kinahanglan nga wala kini depekto, laki man o baye. ");
INSERT INTO cebocb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kon karnero ang iyang ihalad sa Ginoo, ");
INSERT INTO cebocb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ipatong niya ang iyang kamot diha sa ulo sa karnero ug ihawon niya kini didto sa atubangan sa Tolda nga Tagboanan. Ug ang dugo niini isablig sa mga pari nga kaliwat ni Aaron palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Unya mokuha ang pari ug bahin gikan niining halad nga iyang sunogon alang sa Ginoo. Kuhaon niya ang mga tambok, ang tibuok tambok nga ikog nga pinapuok pagkaputol, ang tanan nga tambok sa sulod sa ginhawaan, ");
INSERT INTO cebocb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ang mga rinyon apil ang tambok niini, ug ang gamay nga bahin sa atay. ");
INSERT INTO cebocb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sunogon sa pari kining tanan didto sa halaran isip halad nga pagkaon para sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Kon kanding ang iyang ihalad sa presensya sa Ginoo, ");
INSERT INTO cebocb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ipatong niya ang iyang kamot sa ulo sa kanding ug ihawon niya kini didto sa atubangan sa Tolda nga Tagboanan. Ug ang dugo niini isablig sa mga pari nga kaliwat ni Aaron palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Unya, gikan niining halad magkuha ang pari ug bahin nga iyang sunogon alang sa Ginoo. Kuhaon niya ang tanang tambok sulod sa ginhawaan sa kanding, ");
INSERT INTO cebocb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ang mga bato-bato apil ang tambok niini, ug ang gamay nga bahin sa atay. ");
INSERT INTO cebocb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sunogon sa pari kining tanan didto sa halaran isip halad nga pagkaon. Ang kahumot niini makapalipay kaniya. Ang tanang tambok iya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Ayaw kamo pagkaon ug tambok o dugo. Kini nga mga tulomanon kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon, bisan asa kamo magpuyo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Sultihi ang mga Israelinhon: ‘Si bisan kinsa nga nakalapas sa sugo sa Ginoo apan wala tuyoa, mao kini ang angay niyang buhaton: ");
INSERT INTO cebocb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Kon ang pangulong pari makasala nga wala niya tuyoa, ug tungod niini maangin ang mga tawo, maghalad siya sa Ginoo ug nating torong baka nga walay depekto isip halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dad-on niya ang baka didto sa pultahan sa Tolda nga Tagboanan. Ipatong niya ang iyang kamot sa ulo sa baka ug ihawon niya kini sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Unya magkuha ang pangulong pari ug dugo niadto nga baka ug dad-on niya sa sulod sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ituslob niya ang iyang tudlo sa dugo ug iwisik-wisik niya kini makapito sa atubangan sa kurtina nga gitabil sa Labing Balaang Dapit diin anaa ang presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Unya pahiran niya sa dugo ang mga sungay-sungay sa mga eskina sa halaran nga sunoganan sa insenso didto sa sulod sa Tolda diin anaa ang presensya sa Ginoo. Ang nahibilin nga dugo sa baka ibubo niya sa kinaubosang bahin sa halaran nga sunoganan sa halad nga sinunog. Kini nga halaran anaa duol sa pultahan sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Unya kuhaon niya ang tanan nga tambok sa sulod sa ginhawaan sa baka, ");
INSERT INTO cebocb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ang mga bato-bato apil ang tambok niini, ug ang gamay nga bahin sa atay. ");
INSERT INTO cebocb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(Mao usab kini ang buhaton sa ihalad nga mananap nga alang sa maayo nga relasyon.) Sunogon sa pari kining tanan didto sa halaran nga sunoganan sa halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Apan ang nahibilin nga bahin sa gihalad nga mananap sama sa panit, unod, ulo, mga tiil, ug ang mga sulod sa tiyan lakip na ang sulod sa tinai niini, dad-on niya didto sa gawas sa kampo ug sunogon sa sunoganan, didto sa dapit nga giisip nga hinlo, ang dapit nga labayanan sa abo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Kon ang tibuok katilingban sa Israel nakalapas sa sugo sa Ginoo, apan wala nila tuyoa, nakasala gihapon sila bisan pa kon ang kadaghanan kanila wala masayod mahitungod niini. ");
INSERT INTO cebocb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Kon mahibaloan na nila nga nakasala diay sila, ang katilingban maghalad ug nating torong baka isip halad sa paghinlo. Dad-on nila kining baka didto sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Unya ipatong sa mga tigdumala sa mga Israelinhon ang ilang mga kamot diha sa ulo sa baka ug unya ihawon nila kini sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Unya magkuha ang pangulong pari ug dugo niadtong baka ug dad-on niya sa sulod sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ituslob niya sa dugo ang iyang tudlo ug iwisik-wisik niya kini makapito atubangan sa kurtina nga gitabil, sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Unya pahiran niya sa dugo ang mga sungay-sungay sa mga eskina sa halaran didto sa sulod sa Tolda diin anaa ang presensya sa Ginoo. Ang nahibilin nga dugo ibubo niya sa kinaubosang bahin sa halaran nga sunoganan sa halad nga sinunog. Kini nga halaran anaa duol sa pultahan sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","21","Ug iya usab nga himuon niini nga baka ang sama sa iyang gihimo sa paghalad sa halad sa paghinlo. Kuhaon niya ang tanang tambok sa baka ug sunogon sa halaran, ug unya sunogon niya ang baka didto sa gawas sa kampo. Pinaagi sa pagbuhat niini sa pangulo nga pari, mahinloan ang mga Israelinhon gikan sa ilang sala ug pasayloon sila sa Ginoo. Mao kini ang halad sa paghinlo alang sa katilingban sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Kon ang usa ka pangulo nakalapas sa sugo sa Ginoo nga iyang Dios, apan wala niya tuyoa, nakasala gihapon siya. ");
INSERT INTO cebocb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Kon mahibaloan na niya nga nakasala diay siya, maghalad siya ug laking kanding nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Halad kini alang sa paghinlo. Ipatong niya ang iyang kamot sa ulo sa kanding, ug ihawon niya kini didto sa presensya sa Ginoo sa dapit nga ihawanan sa mga mananap nga isip halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Unya ituslob sa pari ang iyang tudlo sa dugo sa kanding ug ipahid niya sa mga sungay-sungay sa mga eskina sa halaran nga sunoganan sa halad nga sinunog. Ang nahibilin nga dugo ibubo niya sa kinaobsang bahin sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sunogon niya ang tanang tambok didto sa halaran sama sa ginahimo sa tambok sa mananap nga halad alang sa pakigda-it. Pinaagi sa pagbuhat niini sa pari, mahinloan ang maong pangulo gikan sa iyang sala ug pasayloon siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Kon ang usa kaninyo nakalapas sa sugo sa Ginoo, apan wala niya tuyoa, nakasala gihapon siya. ");
INSERT INTO cebocb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Kon mahibaloan na niya nga nakasala diay siya, maghalad siya ug bayeng kanding nga walay depekto alang sa sala nga iyang nahimo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ipatong niya ang iyang kamot sa ulo niining halad sa paghinlo, ug ihawon niya kini didto sa dapit nga ihawanan usab sa mga mananap nga isip halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Unya ituslob sa pari ang iyang tudlo sa dugo sa kanding ug ipahid niya sa mga sungay-sungay sa mga eskina sa halaran nga sunoganan sa halad nga sinunog. Ang nahibilin nga dugo ibubo niya sa kinaubosang bahin sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Unya kuhaon niya ang tanan nga tambok sa kanding sama sa ginahimo sa halad nga mananap alang sa maayo nga relasyon. Pagkahuman, sunogon niya ang tambok diha sa halaran isip mahumot nga halad nga makapalipay sa Ginoo. Pinaagi niining buhaton sa pari, mahinloan ang tawo gikan sa iyang sala ug pasayloon siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Kon karnero ang ihalad sa tawo alang sa halad sa paghinlo, kinahanglan nga baye kini ug walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ipatong niya ang iyang kamot sa ulo sa karnero, ug ihawon niya kini didto sa dapit nga ihawanan usab sa mga mananap nga isip halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Unya ituslob sa pari ang iyang kamot sa dugo sa karnero ug ipahid niya kini sa mga sungay-sungay sa mga eskina sa halaran nga sunoganan sa halad nga sinunog. Ang nahibilin nga dugo ibubo niya sa kinaubosang bahin sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Unya kuhaon niya ang tanang tambok sa karnero sama sa ginahimo sa karnero nga halad alang sa pakigda-it. Pagkahuman, sunogon niya ang tambok diha sa halaran kauban sa uban pa nga mga halad alang sa Ginoo. Pinaagi niining buhaton sa pari, mahinloan ang tawo gikan sa iyang sala ug pasayloon siya sa Ginoo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Kon ang usa ka tawo nakasala tungod kay midumili siya sa pagtestigo ngadto sa korte bahin sa mga butang nga iyang nakita o nahibaloan, aduna siyay tulubagon. ");
INSERT INTO cebocb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Kon adunay makahikap sa bisan unsa nga butang nga giisip nga hugaw (sama sa patayng lawas sa hugaw nga mga mananap, ihalas man o binuhi o bisan unsang giisip nga hugaw nga binuhat nga nagkamang), makasala siya ug makapahugaw kini kaniya, bisan wala niya mahibaloi nga nakahikap siya. ");
INSERT INTO cebocb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kon nakahikap siya sa hugaw nga mga butang sa tawo nga tungod niini nakapahimo kaniyang hugaw, bisan kung wala niya mahibaloi, nakasala siya sa higayon nga mahibaloan na niya kini. ");
INSERT INTO cebocb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Kon manumpa ang usa ka tawo diha-diha sa walay paghuna-huna kon maayo o daotan ang iyang gipanumpaang buhaton, nakasala siya kon maamgohan na niya ang iyang gihimo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Kon nahibaloan sa tawo nga nakasala siya sa bisan asa niini, kinahanglan nga isulti niya kini. ");
INSERT INTO cebocb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ug isip bayad sa sala nga iyang nahimo, maghalad siya sa Ginoo ug usa ka bayeng karnero o kanding isip halad sa paghinlo. Ang pari ang mohalad niini ug mahinloan siya gikan sa iyang sala. ");
INSERT INTO cebocb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Apan kon dili siya makahimo paghalad ug karnero o kanding, maghalad na lang siya ug duha ka salampati o duha ka tukmo sa Ginoo isip bayad sa iyang sala: ang usa halad sa paghinlo ug ang usa halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Dad-on niya kini ngadto sa pari ug unahon paghalad sa pari ang halad sa paghinlo. Lubagon sa pari ang liog niini, apan dili niya putlon. ");
INSERT INTO cebocb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ug isablig niya ang uban nga dugo niini sa kilid sa halaran, ug ang nahibilin nga dugo ipatulo niya sa kinaubosang bahin sa halaran. Halad kini sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ihalad usab dayon sa pari ang usa pa ka halad nga sinunog, sumala sa pamaagi sa paghalad niini. Pinaagi sa paghimo sa pari niini, mahinloan ang tawo gikan sa iyang sala ug pasayloon siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Apan kon dili pa gayod siya makahimo paghalad ug duha ka salampati o duha ka tukmo, maghalad na lang siya ug usa ka kilo nga maayong klasi sa harina. Kinahanglan nga dili niya kini butangan ug mantika ug insenso kay halad kini sa paghinlo, ug dili halad sa pagpasidungog sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Dad-on niya kini ngadto sa pari ug kuhaan kini sa pari ug usa ka kumkom isip paghinumdom sa Ginoo. Ug ang iyang kinuha sunogon niya sa halaran kauban sa uban pa nga mga halad nga alang sa Ginoo pinaagi sa kalayo. Halad kini sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Pinaagi sa paghimo niini sa pari, mahinloan ang tawo sa bisan asa niadto nga mga sala nga iyang nahimo ug pasayloon siya sa Ginoo. Ang nahibilin nga halad nga harina iya na sa pari, sama usab sa gihimo sa halad sa pagpasidungog sa Ginoo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Gisugo pa gayod kini sa Ginoo kang Moises: ");
INSERT INTO cebocb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Kon ang usa ka tawo makalapas sa sugo sa Ginoo tungod kay wala niya mahatag ang butang nga alang unta sa Ginoo, bisan wala niya tuyoa, kinahanglan nga maghalad siya ug laking karnero nga walay depekto isip bayad sa iyang sala. O bayran niya ug salapi ang kantidad sa karnero basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. Kini nga karnero halad isip bayad sa sala. ");
INSERT INTO cebocb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kinahanglan nga bayran niya ang wala niya mahatag sa Ginoo, ug dugangan pa niya kini ug 20 porsyento sa kantidad niini. Unya ihatag niya kining tanan sa pari nga mao ang maghalad ug usa ka laking karnero aron mahinloan ang tawo gikan sa iyang sala ug pasayloon siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kon ang usa ka tawo nakalapas sa sugo sa Ginoo bisan wala niya mahibaloi, nakasala siya ug aduna siyay tulubagon sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","19","Kinahanglan nga magdala siya ngadto sa pari ug laking karnero nga walay depekto, nga ihalad niya isip bayad sa iyang sala. O bayran niya ug salapi ang kantidad sa karnero basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. Pinaagi sa paghimo niini sa pari, mahinloan ang tawo gikan sa iyang sala nga wala tuyoa ug pasayloon siya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mao kini ang giingon sa Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Kung adunay usa ka tawo nga makasala sa Ginoo pinaagi sa paglimbong sa iyang isigka-tawo bahin sa butang nga gipatipigan o gibilin kaniya, o pagkawat niining butanga, o pagpanglimbong, ");
INSERT INTO cebocb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o pagpamakak bahin sa butang nga nawala nga wala kuno niya makita, o pagpanumpa ug bakak nga wala niya mahimo ang bisan asa niini nga mga sala. ");
INSERT INTO cebocb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Kon mapamatud-an nga tinuod nga nakasala siya, kinahanglan nga iuli niya ang iyang kinawat, o ang iyang nakuha pinaagi sa pagpanglimbong, o ang mga butang nga gibilin o gipatipigan kaniya, o ang mga butang nga nawala nga iyang nakit-an, ");
INSERT INTO cebocb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","o ang bisan unsang mga butang nga sumala sa iyang pagpanumpa wala kaniya, apan ang tinuod anaa diay. Kinahanglan nga iuli niya kini sa tag-iya nga wala gayoy kulang, ug dugangan pa niya ug 20 porsyento sa kantidad niini. Ihatag niya kini sa tag-iya sa adlaw nga maghalad siya sa halad isip bayad sa iyang sala. ");
INSERT INTO cebocb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Magdala siya ngadto sa pari ug usa ka laking karnero nga walay depekto, ug ihalad niya kini sa Ginoo isip bayad sa iyang sala. O bayran niya ug salapi ang kantidad sa karnero basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Pinaagi sa paghalad sa pari diha sa presensya sa Ginoo, mahinloan ang tawo gikan sa iyang sala, ug pasayloon siya sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Ihatag kang Aaron ug sa iyang mga anak nga lalaki kini nga mga patakaran mahitungod sa halad nga sinunog: ‘Kini nga halad kinahanglan nga ibilin hangtod mobuntag, ug kinahanglan nga walay undang ang kalayo sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Isul-ob sa pari ang iyang pangsapaw nga bisting lino, ug ang pang-ilalom nga bisti nga nagtabon sa iyang kinatawo, ug kuhaon niya ang abo niining halad ug ibutang sa kilid sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Pagkahuman, mag-ilis siya sa iyang bisti ug dad-on niya ang abo didto sa gawas sa kampo, sa usa ka dapit nga giisip nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kinahanglan nga walay undang ang kalayo sa halaran; dili kini palungon. Kada buntag sugnoran kini sa pari, ug ayohon niya pagbutang sa kalayo ang halad nga sinunog. I-apil usab niya pagsunog ang mga tambok sa mananap nga gihalad alang sa pakigda-it. ");
INSERT INTO cebocb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kinahanglan nga walay undang ang kalayo sa halaran; dili kini palungon. ");
INSERT INTO cebocb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Mao kini ang mga patakaran mahitungod sa halad sa pagpasidungog sa Ginoo: Ang mga pari nga kaliwat ni Aaron mao ang modala niini ngadto sa presensya sa Ginoo didto atubangan sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kuhaan sa pari ug usa ka kumkom kining halad nga harina nga adunay mantika, ug iyang sunogon diha sa halaran apil ang tanang insenso nga gibutang sa harina. Sunogon niya kini isip paghinumdom sa Ginoo. Ang kahumot niini nga halad makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Ang nahibilin nga harina lutuon ug kan-on sa mga pari nga kaliwat ni Aaron. Apan lutuon nila kini nga walay patubo, ug kaonon nila didto sa hawanan sa Tolda nga Tagboanan, nga usa ka balaang dapit. Gihatag kini sa Ginoo kanila isip ilang bahin sa mga halad nga alang kaniya. Ang halad sa pagpasidungog sa Ginoo balaan gayod sama sa halad sa paghinlo ug sa halad isip bayad sa sala. ");
INSERT INTO cebocb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ang tanang mga lalaki nga kaliwat ni Aaron, apil ang ulahi nga mga henerasyon, makakaon niini nga bahin sa halad, tungod kay mao kini ang ilang bahin sa halad alang sa Ginoo pinaagi sa kalayo. Ang mga naggunit niini nga mga halad kinahanglan balaan.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Miingon na usab ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Mao kini ang ihalad ni Aaron ug sa iyang mga anak alang kanako sa adlaw sa iyang ordinasyon ingon nga pari, ug mao usab ang himuon sa iyang kaliwat nga mopuli kaniya. Maghalad siya ug duha ka kilo nga maayong klasi sa harina. Halad kini sa pagpasidungog Ginoo nga kinahanglan buhaton hangtod sa kahangtoran. Ang katunga niini iyang ihalad sa buntag ug ang katunga sa hapon. ");
INSERT INTO cebocb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Kini nga harina sagolan ug mantika ug lutuon sa kolon. Inigkaluto, pikas-pikason kini ug ihalad sa pagpasidungog sa Ginoo. Ang kahumot niini nga halad makapalipay kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kinahanglan sunogon ang halad sa hingpit, kay halad kini alang sa Ginoo. Kinahanglan himuon kini sa matag kaliwat ni Aaron nga mopuli kaniya isip pangulong pari. ");
INSERT INTO cebocb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ang tanang mga halad sa pari sa pagpasidungog sa Ginoo kinahanglan nga sunogon, ug dili gayod kini kaonon.” ");
INSERT INTO cebocb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Miingon na usab ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Sultihi si Aaron ug ang iyang mga anak nga lalaki niini nga mga patakaran: ‘Ang halad sa paghinlo kinahanglan nga ihawon diha sa presensya sa Ginoo didto sa dapit nga ihawanan sa halad nga sinunog. Ang halad sa paghinlo balaan gayod nga halad. ");
INSERT INTO cebocb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ang pari nga mohalad niini kinahanglan nga mokaon niini didto sa hawanan sa Tolda nga Tagboanan, sa usa ka balaang dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ang naggunit niini nga halad kinahanglan balaan. Ug ang bisti nga malagsikan ug dugo niini nga halad kinahanglan nga labhan didto sa balaang dapit sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Kinahanglan nga buakon ang kolon nga gilutoan sa maong halad. Apan kon giluto kini diha sa kaldero, kinahanglan kiskisan kining maong kaldero ug hugasan sa tubig. ");
INSERT INTO cebocb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Makakaon niini nga halad ang tanan nga lalaki sa pamilya sa mga pari. Balaan kaayo kini nga halad. ");
INSERT INTO cebocb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Apan kon ang dugo niini nga halad gidala ngadto sa Balaang Dapit diha sulod sa Tolda, aron mapasaylo ang sala sa usa ka tawo, sunogon gayod kini ug dili kan-on.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Mao kini ang mga patakaran mahitungod sa halad isip bayad sa sala. Balaan kaayo kini nga halad: ");
INSERT INTO cebocb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ang halad isip bayad sa sala ihawon didto sa ihawanan sa halad nga sinunog. Ug ang dugo niini isablig palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ang tanan nga tambok niini ihalad: ang tambok nga ikog, ang mga tambok sulod sa ginhawaan, ");
INSERT INTO cebocb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ang mga bato-bato apil ang mga tambok niini, ug ang gamay nga bahin sa atay. ");
INSERT INTO cebocb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Sunogon kini sa pari diha sa halaran isip halad pinaagi sa kalayo alang sa Ginoo. Halad kini isip bayad sa sala. ");
INSERT INTO cebocb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Makakaon sa nahibiling mga bahin niini nga halad ang tanang mga lalaki sa pamilya sa mga pari, apan kinahanglan nga ka-onon nila kini sa usa ka balaang dapit, kay kini nga dapit alang ra gayod sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Pareho ra ang patakaran sa halad sa paghinlo ug sa halad isip bayad sa sala: ang karne niini nga mga halad iya na sa pari nga naghalad niini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ang panit sa mananap nga ihalad isip halad nga sinunog iya usab sa pari nga naghalad niini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Sama usab sa tanang halad sa pagpasidungog sa Ginoo, nga giluto sa pugon o giluto sa kaldero o sa kalaha, iya na usab kini sa pari nga naghalad niini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ang tanan nga halad sa pagpasidungog sa Ginoo, nga sinagolan ug mantika o wala, iya na sa mga pari nga kaliwat ni Aaron ug angayon kini nila pagbahin-bahin. ");
INSERT INTO cebocb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Mao kini ang mga patakaran mahitungod sa halad alang sa pakigda-it nga ihalad sa Ginoo: ");
INSERT INTO cebocb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kon ang mananap nga halad alang sa pakigda-it mao ang ihalad sa tawo isip pagpasalamat, apilan niya kini ug pan. Magdala siyag mga pan nga walay patubo: pan nga baga nga sinagolan ug mantika, pan nga nipis nga pinahiran ug mantika, ug pan nga hinimo sa pinakamaayong klasi sa harina nga sinagolan ug mantika. ");
INSERT INTO cebocb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ug dugang pa niini, magdala usab siya ug pan nga adunay patubo. ");
INSERT INTO cebocb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Maghalad siya ug usa sa matag klasi niini nga mga pan isip gasa sa Ginoo. Iya na kini sa pari nga nagsablig sa dugo sa halad alang sa pakigda-it. ");
INSERT INTO cebocb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ang karne sa mananap nga halad isip pagpasalamat kinahanglan nga kan-on gayod niana nga adlaw nga kini gihalad; kinahanglang wala gayoy mabilin niini pagkaugma. ");
INSERT INTO cebocb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Kon ang halad alang sa pakigda-it ihalad niya isip halad sa pagtuman sa usa ka panaad o halad nga kinabubut-on, ang karne niini kan-on niana gayong adlawa nga kini gihalad, apan kon adunay mabilin mahimo kini nga kan-on sa sunod nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kon adunay mabilin pa gayod nga karne hangtod sa ikatulo ka adlaw, kinahanglan nga sunogon na kini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kon adunay mokaon sa karne sa ikatulo ka adlaw, kadto nga halad dili dawaton sa Ginoo ug walay kapuslanan ang iyang paghalad. Isipon kini nga hugaw ug adunay tulubagon si bisan kinsa nga mokaon niini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kon masaghid ang karne sa bisan unsa nga butang nga giisip nga hugaw, kinahanglan nga dili na kini kan-on kondili sunogon. Bahin sa ubang mga halad nga karne nga mahimong kaonon, si bisan kinsa nga giisip nga hinlo mahimong makakaon niini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Apan si bisan kinsa nga giisip nga hugaw nga mokaon niini nga karne nga alang sa Ginoo, kanang tawhana dili na ninyo isipon nga usa sa inyong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kon adunay makahikap sa butang nga giisip nga hugaw sama sa mahugaw nga butang sa tawo, o mahugaw nga mananap, o bisan unsa nga giisip nga hugaw nga butang, ug unya mokaon siya sa karne niini nga halad nga alang sa Ginoo, kanang tawhana dili na ninyo isipon nga usa sa inyong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Sultihi ang mga Israelinhon: ‘Ayaw kamo pagkaon sa tambok sa baka, karnero, o kanding. ");
INSERT INTO cebocb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ang tambok sa mananap nga namatay lang o napatay sa laing mananap mahimo ninyong gamiton alang sa bisan unsa nga paggamit, apan dili gayod ninyo kini kaonon. ");
INSERT INTO cebocb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Si bisan kinsa nga mokaon sa tambok nga mahimong ihalad ngadto sa Ginoo, dili na ninyo isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ug bisan asa kamo mopuyo, ayaw gayod kamo pagkaon sa dugo sa mananap ug lakip na ang dugo sa langgam. ");
INSERT INTO cebocb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Si bisan kinsa nga mokaon ug dugo, dili na ninyo isipon nga inyong sakop.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Miingon pag-usab ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Isulti kini ngadto sa mga Israelinhon: ‘Si bisan kinsa nga maghalad ug halad alang sa pakigda-it, kinahanglan maghatag ug bahin sa maong halad alang sa Ginoo nga mahimong iya sa pari. ");
INSERT INTO cebocb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ug kini nga bahin nga alang sa Ginoo dad-on mismo sa maghahalad. Dad-on niya ang tambok ug ang dughan sa mananap, ug ibayaw niya ang dughan diha sa presensya sa Ginoo isip halad nga binayaw. ");
INSERT INTO cebocb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Sunogon sa pari diha sa halaran ang tambok, apan ang dughan iya na ni Aaron ug sa iyang kaliwat. ");
INSERT INTO cebocb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","Ihatag ang tuo nga paa sa halad ngadto sa pari isip gasa. Ang tuo nga paa sa mananap ihatag gayod ngadto sa pari nga naghalad sa dugo ug sa tambok niini. ");
INSERT INTO cebocb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ang dughan ug ang paa sa inyong halad ihatag ngadto sa mga pari nga si Aaron ug sa iyang mga kaliwat. Mao kini ang bahin nga ilang dawaton gikan kaninyo hangtod sa kahangtoran.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Mao kadto ang bahin sa mga halad pinaagi sa kalayo alang sa Ginoo nga gihatag ngadto kang Aaron ug sa iyang mga kaliwat sa adlaw nga gidedikar sila nga moalagad sa Ginoo isip mga pari. ");
INSERT INTO cebocb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Sa adlaw nga giordinahan ang mga pari, nagsugo ang Ginoo sa mga Israelinhon nga ihatag gayod nila kadto nga bahin nga alang sa mga pari, ug tumanon nila kini ug sa ilang mga kaliwat bisan sa umaabot nilang henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Mao kadto ang mga patakaran mahitungod sa halad nga sinunog, halad sa pagpasidungog sa Ginoo, halad sa paghinlo, halad isip bayad sa sala, halad nga alang sa ordinasyon, ug halad alang sa pakigda-it. ");
INSERT INTO cebocb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Kini nga mga patakaran gihatag sa Ginoo kang Moises didto sa kamingawan sa Bukid sa Sinai, niadtong panahon nga nagsugo siya sa mga Israelinhon sa paghalad ngadto kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","“Paadtoa si Aaron ug ang iyang mga anak nga lalaki didto sa pultahan sa Tolda nga Tagboanan, ug tigoma ang tibuok katilingban didto. Ipadala ang mga bisti nga alang sa mga pari, ang lana nga pangdihog, ang torong baka nga halad sa paghinlo, ang duha ka hamtong nga laking karnero, ug ang bukag nga gisudlan sa mga pan nga walay patubo.” ");
INSERT INTO cebocb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Gituman ni Moises ang gisugo kaniya sa Ginoo, ug nagtigom ang katilingban didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Unya, gisultihan sila ni Moises nga kining iyang himuon mao ang gisugo sa Ginoo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Gipaduol ni Moises si Aaron ug ang mga anak nga lalaki niini ug gipakaligo sila. ");
INSERT INTO cebocb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Unya gipasul-ob niya kang Aaron ang bisti nga alang sa pangulong pari: ang pang-ilalom nga bisti, ang bakos, ang panggawas nga bisti, ug ang efod nga gihigtan ug bugkos sa hawak nga maayong pagkahimo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Gitaod usab ni Moises sa dughan ni Aaron ang sapaw nga adunay mga bulsa-bulsa ug gisulod niya didto ang Urim ug Tumim. ");
INSERT INTO cebocb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Unya gipasul-ob niya sa ulo ni Aaron ang turban, ug gitaod niya diha sa atubangan sa turban ang bulawan nga simbolo nga gipili si Aaron alang sa Ginoo. Gihimo kining tanan ni Moises sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Unya gikuha ni Moises ang lana nga pangdihog ug giwisik-wisikan ang Tolda nga Pagsimbahan ug ang tanan nga anaa sa sulod niini. Niining paagiha gilain kining mga butang ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Giwisikan niya sa makapito ug lana ang halaran ug ang tanang kagamitan niini, apil ang palanggana ug ang tungtonganan niini. Gihimo niya kini aron idedikar kini nga mga butang ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Unya gibuboan niya ug lana nga pangdihog ang ulo ni Aaron sa pagdedikar kaniya ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Unya gidala niya sa taliwala ang mga anak nga lalaki ni Aaron ug gisul-oban sa bisti nga alang sa pari ug gibaksan kini. Gisul-oban usab niya sila ug mga turban. Gihimo kini ni Moises sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Pagkahuman, gipakuha ni Moises ang torong baka isip halad sa paghinlo. Ug gipatong ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo sa baka. ");
INSERT INTO cebocb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Giihaw ni Moises ang baka ug mikuha siyag dugo niini. Gituslob niya ang iyang tudlo sa dugo ug gipahiran niya ang mga sungay-sungay sa mga eskina sa halaran sa paghinlo niini. Unya gibubo niya ang nahibilin nga dugo sa kinaubosang bahin sa halaran. Niining paagiha gidedikar niya ang halaran alang sa Ginoo aron mahimong takos kini nga halaran sa paghinlo gikan sa sala. ");
INSERT INTO cebocb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Gikuha usab ni Moises ang tanan nga tambok sulod sa ginhawaan sa mananap, ang gamay nga bahin sa atay, ang mga bato-bato apil ang mga tambok niini, ug gisunog niya kini sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ang mga nahibilin nga bahin sa baka sama sa unod, panit, ug mga tinai, gisunog niya sa gawas sa kampo. Gihimo kini ni Moises sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Pagkahuman niini, gipakuha ni Moises ang hamtong nga laking karnero isip halad nga sinunog, ug gipatong ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo sa karnero. ");
INSERT INTO cebocb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Giihaw ni Moises ang karnero ug gisablig ang dugo niini sa palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Gihiwa-hiwa niya ang mananap ug gihugasan ang mga bahin nga anaa sa sulod sa ginhawaan ug ang mga tiil niini. Unya gisunog niya didto sa halaran ang tanang bahin sa mananap apil ang ulo ug ang mga tambok niini isip halad nga sinunog. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. Gihimo kini ni Moises sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Gipakuha usab dayon ni Moises ang ikaduhang hamtong nga laking karnero. Kini nga karnero halad alang sa ordinasyon. Gipatong ni Aaron ug sa iyang mga anak nga lalaki ang ilang mga kamot sa ulo sa karnero. ");
INSERT INTO cebocb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Unya giihaw ni Moises ang karnero ug mikuha siyag dugo ug gipahid sa ubos nga bahin sa tuong dalunggan ni Aaron, ug sa kumagko sa iyang tuong kamot ug tiil. ");
INSERT INTO cebocb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Gidala usab ni Moises sa taliwala ang mga anak nga lalaki ni Aaron ug gipahiran usab niya ug dugo ang ubos nga bahin sa ilang tuong dalunggan, ug ang kumagko sa ilang tuong mga kamot ug tiil. Unya gisablig niya ang dugo palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Gikuha niya ang mga tambok, ang tambok nga ikog, ang tanan nga tambok sulod sa ginhawaan, ang gamay nga bahin sa atay, ang mga bato-bato apil ang tambok niini, ug ang tuo nga paa. ");
INSERT INTO cebocb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","27","Unya mikuha si Moises ug usa sa matag klasi sa mga pan nga walay patubo sulod sa bukag nga gihalad ngadto sa Ginoo. Ang iyang gikuha: pan nga baga nga walay patubo, pan nga sinagolan ug mantika, ug pan nga nipis. Gipamutang niya kini sa kamot ni Aaron ug sa mga anak niini apil ang tanang mga tambok ug ang tuo nga paa sa karnero, ug gibayaw nila kini ngadto sa Ginoo isip halad nga binayaw. ");
INSERT INTO cebocb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Pagkahuman gikuha kini ni Moises gikan kanila ug gisunog diha sa halaran uban sa halad nga sinunog. Halad kini alang sa ilang ordinasyon. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Gikuha usab ni Moises ang dughan sa karnero ug gibayaw kini ngadto sa Ginoo isip halad nga binayaw. Mao kini ang iyang bahin sa karnero nga halad alang sa ordinasyon. Kining tanan gihimo ni Moises sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Unya mikuha si Moises ug lana nga pangdihog ug dugo nga anaa sa halaran ug giwisikan niya si Aaron ug mga anak nga lalaki niini ug ang ilang mga bisti. Niining paagiha gidedikar niya sila ug ang ilang mga bisti alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Unya miingon si Moises kang Aaron ug sa mga anak niini, “Lutoa ninyo ang karne diha sa pultahan sa Tolda nga Tagboanan. Ug sumala sa gisugo ko kaninyo, kaona ninyo kini diha uban sa pan nga halad alang sa ordinasyon nga gisulod sa bukag. ");
INSERT INTO cebocb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Dayon sunoga ninyo ang mahibilin nga karne ug pan. ");
INSERT INTO cebocb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ayaw kamo paghawa dinhi sulod sa pito ka adlaw hangtod dili mahuman ang inyong ordinasyon. ");
INSERT INTO cebocb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ang Ginoo ang nagsugo kanato sa paghimo niining gihimo nato karong adlawa, aron mahinloan kamo gikan sa inyong mga sala. ");
INSERT INTO cebocb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kinahanglan nga magpabilin kamo dinhi adlaw ug gabii sulod sa pito ka adlaw, ug himuon gayod ninyo ang gipahimo sa Ginoo aron dili kamo mamatay, kay mao kini ang gisugo sa Ginoo kanako nga himuon ninyo.” ");
INSERT INTO cebocb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Busa gituman ni Aaron ug sa iyang mga anak nga lalaki ang tanan nga gisugo sa Ginoo pinaagi kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sa ikawalo nga adlaw, pagkahuman sa ordinasyon, gipatawag ni Moises si Aaron ug ang iyang mga anak nga lalaki, ug ang mga tigdumala sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Miingon si Moises kang Aaron, “Pagkuha ug usa ka nating torong baka ug usa ka hamtong nga laking karnero nga parehong walay depekto, ug ihalad kini sa Ginoo. Ang baka halad sa paghinlo, ug ang karnero halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Unya sultihi ang mga Israelinhon nga magkuha silag laking kanding isip ilang halad sa paghinlo. Ug magkuha usab silag baka ug karnero nga parehong tag-usa pa ka tuig ug walay depekto isip ilang halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Magkuha usab silag baka ug hamtong nga laking karnero isip halad alang sa pakigda-it. Ihalad nila kini uban sa halad sa pagpasidungog nga sinagolan ug mantika, kay karong adlawa magpadayag ang Ginoo sa iyang presensya diha kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Busa gidala sa tibuok katilingban atubangan sa Tolda nga Tagboanan ang tanang gisugo ni Moises kanila. Nagtigom silang tanan didto sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Miingon si Moises, “Gisugo kamo sa Ginoo nga himuon ninyo kining paghalad aron mapadayag niya ang iyang gahom diha kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Unya miingon siya kang Aaron, “Duol ngadto sa halaran ug ihalad ang imong halad sa paghinlo ug ang halad nga sinunog aron mahinloan ka ug ang imong panimalay gikan sa inyong mga sala. Ug sumala sa gisugo sa Ginoo, ihalad usab ang halad sa mga tawo aron mahinloan sila gikan sa ilang mga sala.” ");
INSERT INTO cebocb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Busa mipaduol sa halaran si Aaron ug giihaw niya ang nating torong baka isip halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ang dugo niini gidala sa iyang mga anak kaniya, ug gituslob niya ang iyang tudlo sa dugo ug gipahid kini sa mga sungay-sungay sa halaran. Ang nahibilin nga dugo gibubo niya sa kinaubosang bahin sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Gisunog niya sa halaran ang mga tambok, ang mga bato-bato, ug ang gamay nga bahin sa atay, sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ang karne ug ang panit niini gisunog niya sa gawas sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Unya giihaw usab ni Aaron ang mananap isip halad nga sinunog. Ang dugo niini gidala sa iyang mga anak nga lalaki kaniya, ug gisablig niya kini palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Gidala usab nila kaniya ang mga hiniwa-hiwa nga bahin sa mananap lakip ang ulo niini, ug gisunog niya kini sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Gihugasan niya ang mga bahin sa sulod sa ginhawaan ug ang mga tiil, ug gisunog niya kini sa halaran kauban sa uban pang mga bahin sa mananap. ");
INSERT INTO cebocb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Pagkahuman niini, gidala niya sa atubangan ang mga halad sa mga tawo. Giihaw niya ang kanding isip halad sa paghinlo sa mga tawo sama sa una niyang gihimo sa halad. ");
INSERT INTO cebocb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Unya gidala usab niya sa atubangan ang halad nga sinunog, ug gihalad niya kini sumala sa pamaagi sa paghalad niini. ");
INSERT INTO cebocb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Gidala usab niya sa atubangan ang halad sa pagpasidungog sa Ginoo. Mikuha siya ug usa ka hakop ug gisunog kini sa halaran uban sa halad nga sinunog, nga sunogon kada buntag. ");
INSERT INTO cebocb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Giihaw usab ni Aaron ang baka ug ang hamtong nga laking karnero isip halad alang sa pakigda-it. Ang dugo niini gidala sa iyang mga anak nga lalaki kaniya, ug gisablig niya kini palibot sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ang mga tambok niining mga mananap, ang tambok nga mga ikog, ang mga tambok sulod sa ginhawaan, apil ang mga rinyon ug ang gamay nga bahin sa atay ");
INSERT INTO cebocb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","gitungtong sa mga anak nga lalaki ni Aaron sa mga dughan sa mga mananap. Ug gisunog ni Aaron ang mga tambok didto sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Sumala sa gisugo ni Moises, gibayaw ni Aaron ang mga dughan ug ang tuo nga paa sa mananap isip halad nga binayaw ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Pagkahuman ug halad ni Aaron niining tanan, gibayaw niya ang iyang mga kamot ug gibendisyonan ang mga tawo, ug unya nanaog siya gikan sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","24","Unya misulod si Moises ug si Aaron sa Tolda nga Tagboanan. Sa paggawas nila, gibendisyonan nila ang mga tawo. Ug unya gipadayag sa Ginoo ang iyang gahom sa mga tawo pinaagi sa pagpadalag kalayo nga mihurot ug sunog sa mga halad sa halaran. Sa dihang nakita kini sa mga tawo naninggit sila sa kalipay ug miluhod sila sa pagsimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Unya si Nadab ug si Abihu nga mga anak ni Aaron nagkuha sa ilang tagsa-tagsa ka butanganan sa insenso. Gibutangan nila kinig baga ug insenso ug gihalad sa Ginoo. Niining paagiha, wala sila mosubay sa gisugo sa Ginoo kay dili mao ang kalayo nga ilang gigamit. ");
INSERT INTO cebocb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Busa nagpadala ang Ginoo ug kalayo nga misunog kanila hangtod nga namatay sila diha sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Unya miingon si Moises kang Aaron, “Mao kini ang buot ipasabot sa Ginoo sa dihang miingon siya: “ ‘Kinahanglan ilhon sa mga pari ang akong pagkabalaan, ug kinahanglan pasidunggan ako sa tanang katawhan.’ ” Wala makatubag si Aaron. ");
INSERT INTO cebocb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Unya gipatawag ni Moises si Mishael ug si Elzafan, nga mga anak nga lalaki ni Uziel nga uyoan ni Aaron, ug giingnan sila, “Dali, kuhaa ninyo sa Tolda ang mga patayng lawas sa inyong mga paryente ug dad-a ninyo sa gawas sa kampo.” ");
INSERT INTO cebocb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Busa gikuha nila ang mga patayng lawas, apan bisti ang ilang gigamit sa pagkupot, ug gidala nila sa gawas sa kampo sumala sa gisugo ni Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Unya miingon si Moises kang Aaron ug sa iyang mga anak nga si Eleazar ug si Itamar, “Ayaw ninyo kalkaga ang inyong buhok o gisia ang inyong mga bisti sa pagpaila nga nagsubo kamo. Kon himuon ninyo kini, mamatay kamo ug masuko ang Ginoo sa tibuok katilingban sa Israel. Ang tanan nga katawhan sa Israel nga inyong paryente mao ang magsubo alang kanilang duha nga gisunog sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ayaw una kamo paghawa sa pultahan sa Tolda. Kon himuon ninyo kini mamatay kamo, kay gipili kamo sa Ginoo nga mahimong mga pari pinaagi sa pagdihog kaninyo sa lana.” Ug gituman nila ang giingon ni Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Miingon ang Ginoo kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ikaw ug ang imong mga anak nga lalaki dili angayng mosulod sa Tolda nga nakainom ug bino o sa bisan unsa nga ilimnon nga makahubog. Kon himuon ninyo kini mamatay kamo. Kini nga mga patakaran kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Angay ninyong mahibaloan kon unsa ang alang sa Ginoo ug ang alang sa tanan, ang hinlo ug ang hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ug kinahanglan nga tudloan ninyo ang mga Israelinhon sa tanan nga patakaran nga gihatag ko kaninyo pinaagi kang Moises.” ");
INSERT INTO cebocb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Miingon si Moises kang Aaron ug sa iyang duha ka anak nga nahibilin nga sila si Eleazar ug Itamar, “Kuhaa ninyo ang halad sa pagpasidungog sa Ginoo gikan sa nahibiling mga halad pinaagi sa kalayo. Lutoa ninyo kini nga walay patubo ug kaona ninyo diha sa tapad sa halaran, kay balaan kaayo kini nga halad. ");
INSERT INTO cebocb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kaona ninyo kini diha lang sa balaang dapit, kay mao kini ang inyong bahin gikan sa mga halad pinaagi sa kalayo. Mao kini ang gisugo sa Ginoo kanako. ");
INSERT INTO cebocb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Kaonon ninyo ug sa tibuok nimong pamilya ang dughan ug ang paa sa mananap nga gibayaw ug gihalad ngadto sa Ginoo. Kaonon ninyo kini bisan asang dapit nga giisip nga hinlo. Gihatag kini kaninyo isip inyong bahin gikan sa mga halad sa mga Israelinhon alang sa maayo nga relasyon. ");
INSERT INTO cebocb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kon maghalad ang mga Israelinhon, ihalad nila ang dughan ug ang paa sa mananap uban ang mga tambok nga ihalad nila ingon nga halad pinaagi sa kalayo. Ang dughan ug ang paa ibayaw nila ngadto sa presensya sa Ginoo isip halad nga binayaw. Mao kini ang bahin ninyo ug sa imong mga kaliwat hangtod sa kahangtoran, sumala sa gisugo sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Sa dihang gisusi pag-ayo ni Moises ang bahin sa kanding nga halad sa paghinlo, nakita niya nga nasunog na kining tanan. Busa nasuko siya pag-ayo kang Eleazar ug kang Itamar, ug gisukmatan niya sila. ");
INSERT INTO cebocb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Miingon siya, “Nganong wala man ninyo kaona ang halad didto sa balaang dapit? Kini nga halad balaan kaayo ug gihatag kini sa Ginoo kaninyo aron mahinloan ang katilingban sa Israel sa ilang mga sala sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tungod kay ang dugo niini wala madala sulod sa Balaang Dapit, gikaon unta ninyo kini didto sa hawanan sa Tolda, sumala sa akong gisugo kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Mitubag si Aaron kang Moises, “Ganina naghalad ang akong mga anak nga lalaki sa ilang halad sa paghinlo ug sa ilang halad nga sinunog, apan namatay silang duha. Sa ingon niini nga panghitabo malipay kaha ang Ginoo kon gikaon namo ang halad sa paghinlo karong adlawa?” ");
INSERT INTO cebocb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Miuyon si Moises sa tubag ni Aaron. ");
INSERT INTO cebocb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Miingon ang Ginoo kang Moises ug Aaron, ");
INSERT INTO cebocb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Isulti kini ngadto sa mga Israelinhon: ‘Sa tanang mga mananap nga anaa sa yuta, mao kini ang mamahimo ninyong kaonon. ");
INSERT INTO cebocb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mahimo ninyong kaonon ang bisan unsa nga mananap nga pikas ug kuko ug nag-usap pag-usab sa ilang kinaon. ");
INSERT INTO cebocb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","8","Apan ayaw ninyo kan-a ang mga mananap nga mousap pag-usab sa ilang kinaon apan dili pikas ug kuko, sama sa kamelyo, yangungo, ug koneho. Dili usab ninyo kaonon ang baboy, kay bisan tuod ug pikas ang iyang kuko, dili kini mousap pag-usab sa iyang kinaon. Isipa ninyo nga hugaw kini nga mga mananap. Ayaw gayod kamo pagkaon sa ilang mga karne o bisan paghikap sa ilang patayng lawas. ");
INSERT INTO cebocb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Mahimo ninyong kaonon ang bisan unsa nga mananap sa tubig nga adunay mga silik ug mga himbis. ");
INSERT INTO cebocb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Apan ayaw gayod ninyo kan-a ang tanang mga mananap sa dagat o sa mga sapa nga walay silik ug himbis. Hugaw kini alang kaninyo. Lakip niini ang gagmay nga mananap nga nagpuyo sa mabaw nga tubig ug tanang mananap nga nagpuyo sa lalom nga bahin sa tubig. ");
INSERT INTO cebocb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Hugaw kini alang kaninyo busa ayaw gayod kamo kaon niini ni mohikap sa ilang mga patayng lawas. ");
INSERT INTO cebocb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Hugaw alang kaninyo ang bisan unsang mananap nga anaa sa tubig nga walay silik o himbis. ");
INSERT INTO cebocb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","“ ‘Ayaw gayod ninyo kan-a ang mga mananap nga naglupad nga sama sa mga agila, buwitre, uwak, mga langgam nga mokaon ug patayng lawas sa tawo o mananap, mga banog, mga ngiwngiw, mga ostrich, mga langgam nga nagpangdagit ug mga isda, talabon, dugwak, ug kabog. Isipa ninyo nga mangil-ad kining mga mananapa. ");
INSERT INTO cebocb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","23","“ ‘Mahimo ninyong kaonon ang mga insekto nga naglupad ug nagkamang nga adunay mga tiil nga panglukso, sama sa mga dulon, timos, ug apan-apan. Apan dili gayod ninyo kaonon ang uban pang mga insekto nga naglupad ug nagkamang. Isipa ninyo nga mangil-ad kini nga mga insekto. ");
INSERT INTO cebocb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","“ ‘Ayaw kamo paghikap sa patayng lawas sa mga mananap nga dili pikas ug kuko ug dili mousap pag-usab sa ilang kinaon. Ayaw usab kamo paghikap sa patayng lawas sa mga mananap nga upat ug tiil nga adunay kukong pangkamras. Isipa ninyo nga mangil-ad kini nga mga mananapa. Si bisan kinsa nga makahikap sa ilang patayng lawas, kinahanglan manglaba sa bisti nga iyang gisul-ob, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","31","“ ‘Isipa ninyo nga hugaw ang mga mananap nga nagkamang sama sa mga ilaga, tuko, tiki, halo, buaya, ibid, ug mga kameleyon. Si bisan kinsa nga makahikap sa ilang patayng lawas isipon nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ang bisan unsa nga mahulogan sa ilang patayng lawas mahimong hugaw, butang man kini nga hinimo ug kahoy, tela, panit, o sako, ug bisan unsay gamitan niini. Kinahanglan nga hugasan kini ug tubig, apan isipon pa gihapon kini nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kon ang banga mahulogan sa ilang patayng lawas, ang tanan nga anaa sulod niini mahimong hugaw, ug kinahanglan nga buakon kini. ");
INSERT INTO cebocb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ang bisan unsang pagkaon nga mabutangan sa tubig nga gikan niadtong banga mahimong hugaw. Ug mahimong hugaw usab ang tanang matang sa ilimnon nga anaa sulod sa banga. ");
INSERT INTO cebocb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ang bisan unsa nga mahulogan sa ilang patayng lawas mahimong hugaw. Kon ang mahulogan pugon o kolon, isipon ninyo kini nga hugaw ug kinahanglan nga buakon. ");
INSERT INTO cebocb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ang tuboran o ang bangag nga pundohanan ug tubig nga mahulogan sa ilang patayng lawas magpabilin nga hinlo, apan ang mohikap niadtong patayng mananap mahimong hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Magpabilin usab nga hinlo ang bisan unsa nga binhi nga itanomay nga mahulogan niadto nga patayng lawas, ");
INSERT INTO cebocb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","apan kon mahulogan ang binhi nga nahulom sa tubig, kini nga binhi mahimong hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Kon namatay ang usa ka mananap nga mahimong kaonon, si bisan kinsa nga mohikap niini isipon nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Si bisan kinsa nga mokuha o mokaon sa lawas niini, kinahanglan manglaba sa bisti nga iyang gisul-ob, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","“ ‘Ayaw ninyo kan-a ang bisan unsa nga mananap nga nagkamang kay hugaw kini: ang bisan unsa nga nagkamang pinaagi sa iyang tiyan o upat ka tiil o daghang mga tiil. ");
INSERT INTO cebocb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","44","Ayaw ninyo hugawi ang inyong kaugalingon pinaagi sa pagkaon sa bisan asa niining mga mananapa, kay ako, ang Ginoo, mao ang inyong Dios. Busa ilain ninyo ang inyong kaugalingon alang kanako ug magkinabuhi kamo nga balaan tungod kay ako balaan. ");
INSERT INTO cebocb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ako ang Ginoo nga nagpagawas kaninyo gikan sa Ehipto aron mahimong inyong Dios. Busa pagkinabuhi kamo nga balaan kay ako balaan. ");
INSERT INTO cebocb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Mao kini ang mga patakaran mahitungod sa tanang mga mananap, mga langgam, tanang mananap nga naglihok diha sa tubig ug sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kinahanglan mahibaloan ninyo kon unsa ang hinlo ug ang hugaw, kung asa niini nga mga mananap ang mahimong kaonon ug dili mahimong kaonon.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Isulti kini ngadto sa mga Israelinhon: ‘Kon ang usa ka babaye manganak ug batang lalaki, isipa siya nga hugaw sulod sa pito ka adlaw, maingon nga hugaw siya kon dug-on. ");
INSERT INTO cebocb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sa ikawalo nga adlaw tulion ang iyang anak. ");
INSERT INTO cebocb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Kinahanglan mohulat ang babaye ug 33 ka adlaw ayha siya isipon nga hinlo. Dili siya mahimong mohikap sa bisan unsang butang nga alang sa Ginoo ug dili siya mahimong moadto sa balaang puloy-anan hangtod nga mahuman ang mga adlaw sa iyang paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kon babaye ang iyang anak, isipa siya nga hugaw sulod sa 14 ka adlaw, maingon nga hugaw siya kon dug-on. Kinahanglan mohulat pa siya ug 66 ka adlaw ayha siya maisip nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Kon human na ang mga adlaw sa iyang paghinlo, malalaki man o mababaye ang iyang gianak, magdala dayon siya ngadto sa pari ug karnero nga usa ka tuig isip halad nga sinunog ug usa ka tukmo o salampati isip halad sa paghinlo, didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","Ihalad kini sa pari didto sa presensya sa Ginoo aron makuha ang pagkahugaw sa babaye tungod sa pagdugo, ug mahimo na siyang hinlo. Kon dili siya makahimo paghatag ug karnero magdala na lang siya ug duha ka salampati o duha ka tukmo; ang usa halad nga sinunog ug ang usa halad sa paghinlo. Pinaagi niining himuon sa pari, makuha ang pagkahugaw sa babaye ug mahimo na siyang hinlo. Mao kini ang mga patakaran mahitungod sa babaye nga nanganak.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Naghatag ang Ginoo niini nga mga patakaran kang Moises ug kang Aaron: ");
INSERT INTO cebocb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Kon ang panit sa usa ka tawo mohubag o mobutoy o moputi-puti, nga posibleng mahimong ngilngig nga sakit sa panit, dad-on kining tawhana ngadto kang Aaron nga pari o ngadto sa usa sa mga pari nga kaliwat ni Aaron. ");
INSERT INTO cebocb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Tan-awon sa pari ang apektado nga bahin sa iyang panit. Kon nagkabahong na kini ug ang mga balhibo niini nagputi na, tinuod nga aduna siyay ngilngig nga sakit sa panit. Ug ipahibalo dayon sa pari nga hugaw siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Apan kon ang nagputi-puti sa iyang panit wala nagkabahong ug ang balhibo wala nagputi, ilain siya sa pari gikan sa mga tawo sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sa ikapito nga adlaw, tan-awon pag-usab sa pari ang iyang panit. Ug kon ang makita mao lang gihapon ug wala kini mikuyanap, ilain siya pag-usab sa pari gikan sa mga tawo sulod sa laing pito pa ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sa ikapito na usab nga adlaw, tan-awon siya pag-usab sa pari. Ug kon nagpali na kini ug wala mikuyanap, ipahibalo sa pari nga hinlo siya kay butoy-butoy lang kini. Pagkahuman niini, labhan sa tawo ang iyang bisti, ug isipon na siya nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Apan kon mikuyanap ang butoy-butoy sa iyang panit human nga nakapatan-aw na siya sa pari ug gipahibalo na sa pari nga hinlo na siya, kinahanglan nga magpatan-aw siya pag-usab sa pari. ");
INSERT INTO cebocb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ug kon tinuod nga mikuyanap ang butoy-butoy, ipahibalo sa pari nga hugaw siya kay aduna siyay ngilngig nga sakit sa panit. ");
INSERT INTO cebocb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Si bisan kinsa nga adunay timailhan sa ngilngig nga sakit sa panit kinahanglan nga dad-on ngadto sa pari. ");
INSERT INTO cebocb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kon sa pagtan-aw sa pari nagputi-puti ang hubag nga mao ang hinungdan sa pagputi sa mga balhibo, ug ang unod makita na, ");
INSERT INTO cebocb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","usa kini ka ngilngig nga sakit sa panit nga mobalik-balik. Ug ipahibalo sa pari nga siya hugaw. Dili na kinahanglan nga ilain pa siya aron obserbahan kay dayag na nga siya hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kon sa pagtan-aw sa pari nga mikuyanap na ang sakit sa tibuok nga lawas sa tawo, ");
INSERT INTO cebocb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kinahanglan nga tan-awon siya pag-usab ug maayo sa pari. Ug kon tinuod nga mikuyanap na ang sakit sa tibuok niyang lawas ug tungod niini miputi ang tanan niyang panit, ipahibalo sa pari nga hinlo siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","15","Apan kon sa pagtan-aw sa pari nga nanggawas ang unod, ipahibalo niya nga hugaw ang tawo kay adunay ngilngig siya nga sakit sa panit. Kining migawas nga unod isipon nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Apan kon nagkugang ang unod niini ug nagputi ang pinalian, magpatan-aw siya pag-usab sa pari. ");
INSERT INTO cebocb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ug kon tinuod nga mipali na kini, ipahibalo sa pari nga hinlo na siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kon ang usa ka tawo adunay hubag nga naayo na, ");
INSERT INTO cebocb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","apan adunay mibutoy sa hubag nga naayo nga medyo puti-puti o pula-pula, kinahanglan nga ipatan-aw niya kini sa pari. ");
INSERT INTO cebocb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ug kon nagkabahong kini ug ang mga balhibo niini miputi, ipahibalo sa pari nga hugaw kining tawhana, kay aduna man siyay ngilngig nga sakit sa panit nga nagsugod sa hubag. ");
INSERT INTO cebocb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Apan kon sa pagtan-aw sa pari wala nagkabahong ug wala usab nagputi ang balhibo niini, ug medyo pali na, ilain siya sa pari gikan sa mga tawo sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kon mikuyanap kini sa ubang bahin sa panit, ipahibalo sa pari nga hugaw siya, kay timailhan kini sa ngilngig kini nga sakit. ");
INSERT INTO cebocb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Apan kon wala kini mikuyanap, pali lang kini sa hubag, ug ipahibalo sa pari nga hinlo siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kon ang usa ka tawo adunay paso nga naimpeksyon ug nagputi-puti kini o nagpula-pula, ");
INSERT INTO cebocb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kinahanglan nga ipatan-aw kini sa pari. Ug kon nagkabahong kini ug ang mga balhibo niini nagputi, ngilngig kini nga sakit sa panit nga nagsugod sa paso. Ug ipahibalo sa pari nga hugaw siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Apan kon sa pagtan-aw sa pari wala kini nagkabahong ug wala usab nagputi ang balhibo niini, ug medyo napali na, ilain siya sa pari gikan sa mga tawo sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sa ikapito nga adlaw, tan-awon siya pag-usab sa pari. Ug kon mikuyanap kini sa uban nga bahin sa iyang panit, ipahibalo sa pari nga hugaw siya, kay timailhan kini sa ngilngig nga sakit sa panit. ");
INSERT INTO cebocb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Apan kon wala kini mikuyanap ug napali na, usa lang kini ka hubag nga nagsugod sa paso. Ug ipahibalo sa pari nga hinlo siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kon ang usa ka tawo adunay hubag-hubag sa iyang ulo o suwang, ");
INSERT INTO cebocb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kinahanglan nga ipatan-aw niya kini sa pari. Kon nagkabahong kini ug ang mga buhok o bangas niini nagdalag ug nagnipis, ipahibalo sa pari nga hugaw kining tawhana, kay aduna man siyay ngilngig nga nuka nga mitubo sa iyang ulo o sa suwang. ");
INSERT INTO cebocb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kon sa pagtan-aw sa pari wala nagkabahong apan walay itom nga buhok o bangas niini, ilain siya sa pari gikan sa mga tawo sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sa ikapito ka adlaw, tan-awon pag-usab sa pari ang nuka. Ug kon wala kini mokaylap ug wala kini nagkabahong, ug wala usab nagdalag ang buhok o bangas niini, ");
INSERT INTO cebocb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kinahanglan kagisan niya ang iyang ulo o mamarbas apan dili niya i-apil ang bahin nga adunay nuka. Unya ilain siya pag-usab sa pari sulod sa laing pito pa ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sa ikapito ka adlaw, tan-awon pag-usab sa pari ang nuka. Ug kon wala kini mikuyanap ug wala kini nagkabahong, ipahibalo sa pari nga hinlo siya. Unya labhan sa tawo ang iyang bisti, ug isipon siya nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Apan kon mikuyanap ang nuka sa iyang panit human gipahibalo sa pari nga hinlo siya, ");
INSERT INTO cebocb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","tan-awon siya pag-usab sa pari. Ug kon tinuod nga mikuyanap ang nuka sa iyang panit, dili na kinahanglan nga tan-awon pa sa pari kon adunay buhok o bangas nga nagdalag kay dayag na nga hugaw siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Apan kon sa pagtan-aw sa pari wala kini mikuyanap ug aduna nay itom nga buhok o bangas nga nagtubo, maayo na kini. Ug ipahibalo sa pari nga hinlo siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kon adunay nagputi-puti sa panit sa usa ka tawo, ");
INSERT INTO cebocb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kinahanglan nga ipatan-aw kini sa pari. Ug kon ang mga nagputi-puti hanap ra, katol-katol lang kini nga nanggawas sa panit. Kining tawhana isipon nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Kon ang usa ka tawo naupaw sa may ibabaw nga bahin sa iyang agtang o sa ibabaw nga bahin sa iyang ulo, hinlo siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","44","Apan kon adunay nagpula-pula nga hubag diha sa iyang upaw, kinahanglan nga ipatan-aw niya kini sa pari. Ug kon ang pula-pula nga hubag susama sa ngilngig nga sakit sa panit nga makita sa lawas, ipahibalo sa pari nga hugaw siya. ");
INSERT INTO cebocb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ang tawo nga adunay ngilngig nga sangla kinahanglan nga magsul-ob ug gisi nga bisti, kalkagon niya ang iyang buhok, ug tabonan niya ang ubos nga bahin sa iyang nawong. Unya mosinggit siya, “Hugaw ako! Hugaw ako!” ");
INSERT INTO cebocb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Isipon siya nga hugaw samtang anaa pa kaniya ang sakit. Ug kinahanglan nga magpuyo siya sa gawas sa kampo nga mag-inusara. ");
INSERT INTO cebocb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","50","Kon gitalumtom ang panapton nga delana o lino o ang bisan unsa nga butang nga hinimo gikan sa panit, o kon adunay makita nga nagpula-pula o nagberde niini nga mga gamit, kinahanglan nga ipatan-aw kini sa pari. Human kini matan-aw sa pari, ilain niya kini sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","Sa ikapito nga adlaw, tan-awon kini pag-usab sa pari. Ug kon mikuyanap ang talumtom, isipon kini nga hugaw, ug kinahanglan kining sunogon tungod kay mosamot ang talumtom niini. ");
INSERT INTO cebocb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","54","Apan kon sa pagtan-aw sa pari wala mikuyanap ang talumtom, magsugo siya nga labhan ang panapton o ang panit, ug ilain niya kini sulod sa laing pito pa ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Pagkahuman niini, tan-awon kini pag-usab sa pari. Ug kon wala mokuspaw ang talumtom, isipon kini nga hugaw bisan kon wala pa mikuyanap ang talumtom. Busa kinahanglan nga sunogon kini bisan anaa ra sa atubangan o likod sa panapton ang talumtom. ");
INSERT INTO cebocb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Apan kon sa pagtan-aw sa pari mikuspaw ang talumtom, kuhaon niya ang bahin sa panapton o panit nga gitalumtom. ");
INSERT INTO cebocb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Apan kon mobalik ug mokaylap ang talumtom sa panapton o panit, kinahanglan nga sunogon na kini. ");
INSERT INTO cebocb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Kon nawala ang talumtom human labhi ang panapton o panit, labhan kini pag-usab ug mahimo na kining hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Mao kini ang mga patakaran sa paghibalo kon hinlo o hugaw ang panapton nga delana o lino o ang bisan unsa nga butang nga hinimo gikan sa panit nga gitalumtom. ");
INSERT INTO cebocb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","2","Mao kini ang mga patakaran nga giingon sa Ginoo kang Moises mahitungod sa paghinlo sa tawong adunay ngilngig nga sakit sa panit: Human pahibaloon ang pari mahitungod sa kahimtang sa sakit sa usa ka tawo, ");
INSERT INTO cebocb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","mogawas ang pari sa kampo ug tan-awon niya ang lawas niadtong tawo. Kon naayo na ang iyang ngilngig nga sakit sa panit, ");
INSERT INTO cebocb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","magpakuha ang pari ug duha ka langgam nga buhi nga giisip nga hinlo, usa ka putol sa kahoyng sedro, pula nga higot, ug usa ka pungpong nga isopo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Unya ipaihaw sa pari ang usa ka langgam diha ibabaw sa kolon nga gisudlan ug tubig gikan sa tuboran. ");
INSERT INTO cebocb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Unya kuhaon sa pari ang buhi nga langgam ug ituslob niya kini uban sa kahoyng sedro, pula nga higot, ug isopo, didto sa dugo sa langgam nga giihaw ibabaw sa kolon nga adunay tubig. ");
INSERT INTO cebocb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Dayon wisik-wisikan niyag makapito ang tawong naayo sa iyang ngilngig nga sakit sa panit. Pagkahuman ipahibalo niya nga hinlo na ang maong tawo, ug buhian niya ang langgam. ");
INSERT INTO cebocb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Apan sa dili pa ipahibalo nga hinlo na siya, labhan una sa tawo ang iyang bisti, kagisan ang tanan niyang buhok ug balhibo, ug maligo. Mahimo na siyang mosulod sa kampo apan dili siya mopuyo sa iyang tolda sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sa ikapito ka adlaw, kagisan niya pag-usab ang tanan niyang buhok ug balhibo, labhan niya ang iyang bisti, ug maligo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sa ikawalo nga adlaw, kinahanglan nga magdala siya ug duha ka laking karnero ug usa ka bayeng karnero nga usa ka tuig, ug walay depekto. Magdala usab siya ug unom ka kilo nga maayong klasi sa harina nga sinagolan ug mantika isip halad sa pagpasidungog sa Ginoo. Ug magdala pa gayod siyag usa ka basong mantika. ");
INSERT INTO cebocb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Unya dad-on siya sa pari nga mopahibalo nga hinlo na siya, ngadto sa presensya sa Ginoo didto sa pultahan sa Tolda nga Tagboanan, uban sa iyang mga halad. ");
INSERT INTO cebocb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Dayon kuhaon sa pari ang usa sa laking karnero ug ang usa ka basong lana, ug ihalad niya kini isip halad nga bayad sa sala. Unya ibayaw niya kini sa presensya sa Ginoo isip halad nga binayaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ihawon niya ang karnero didto sa balaang dapit, sa ihawanan sa halad sa paghinlo ug sa halad nga sinunog. Kining halad nga karnero balaan kaayo, ug iya na kini sa pari sama usab sa halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Unya magkuha ang pari ug dugo sa karnerong gihalad ug ipahid niya kini sa ubos nga bahin sa tuong dalunggan sa tawo nga ginahinloan, ug sa kumagko sa tuong kamot ug tiil niini. ");
INSERT INTO cebocb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Magbutang usab ang pari ug lana diha sa iyang wala nga palad, ");
INSERT INTO cebocb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ug ituslob niya sa lana ang iyang tudlo sa tuong kamot ug iwisik-wisik kini makapito didto sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ang ubang lana sa iyang palad ipahid niya sa ubos nga bahin sa tuong dalunggan ug sa kumagko sa tuong kamot ug tiil niadtong tawo nga ginahinloan. ");
INSERT INTO cebocb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ang nahibilin pang lana sa palad sa pari ipahid niya sa ulo sa tawo nga gihinloan ug mao kini ang mahimong bayad sa sala niadtong tawhana atubangan sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Pagkahuman niini, kinahanglan maghalad ang pari ug halad alang sa sala aron mahimong hinlo kadtong tawhana ug dayon ihawon sa pari ang halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ihalad niya kini sa halaran lakip ang halad nga uhay. Ingon niini ang buhaton sa pari sa presensya sa Ginoo aron makuha ang pagkahugaw sa tawo ug mahimo na siyang hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Apan kon ang maong tawo kabos ug dili makahimo sa paghalad niini nga mga halad, magdala na lang siya ug usa ka karnero nga laki nga ihalad niya isip bayad sa sala. Ibayaw niya kini nga halad aron makuha ang iyang mga sala ug mahimo na siyang hinlo. Magdala usab siya ug duha ka kilo nga maayong klasi sa harina nga sinagolan ug mantika isip halad sa pagpasidungog sa Ginoo. Ug magdala pa gayod siyag usa ka basong mantika. ");
INSERT INTO cebocb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ug sumala lang sa iyang makaya, magdala siyag duha ka salampati o duha ka tukmo; ang usa halad sa paghinlo ug ang usa halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Sa ikawalo nga adlaw, dad-on niya kining tanan nga halad ngadto sa pari didto sa pultahan sa Tolda nga Tagboanan, sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kuhaon sa pari ang karnero nga halad isip bayad sa sala ug ang usa ka basong lana, ug ibayaw niya kini sa presensya sa Ginoo isip halad nga binayaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Unya ihawon niya ang karnero ug magkuha siyag dugo niini ug ipahid niya sa ubos nga bahin sa tuong dalunggan sa tawo nga ginahinloan, ug sa kumagko sa tuong kamot ug tiil niini. ");
INSERT INTO cebocb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Unya magbutang ang pari ug lana sa iyang wala nga palad, ");
INSERT INTO cebocb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ug pinaagi sa iyang tudlo sa tuong kamot, iwisik-wisik niya ang lana makapito didto sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ang ubang lana sa iyang palad ipahid gihapon niya sa ubos nga bahin sa tuong dalunggan ug sa kumagko sa tuong kamot ug tiil niadtong tawo nga ginahinloan. ");
INSERT INTO cebocb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","31","Ang nahibilin pa nga lana sa palad sa pari ipahid niya sa ulo sa tawo. Unya ihalad sa pari ang duha ka salampati o ang duha ka tukmo; ang usa halad sa paghinlo ug ang usa halad nga sinunog. Ihalad usab niya ang halad sa pagpasidungog sa Ginoo. Pinaagi niining himuon sa pari diha sa presensya sa Ginoo mahinloan ang tawo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Mao kini ang mga patakaran mahitungod sa paghinlo sa tawong adunay ngilngig nga sakit sa panit kon dili siya makakaya sa halad nga ihalad alang sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mao kini ang giingon sa Ginoo kang Moises ug kang Aaron ");
INSERT INTO cebocb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","mahitungod sa ilang buhaton kon patuboan sa Ginoo ug agup-op ang ilang mga balay kon atua na sila sa Canaan, ang dapit nga ihatag sa Ginoo kanila nga ilang panag-iyahon: ");
INSERT INTO cebocb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Kon ang tag-iya sa usa ka balay makamatikod nga adunay murag agup-op sa iyang balay, kinahanglan nga sultihan niya ang pari. ");
INSERT INTO cebocb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sa dili pa mosulod ang pari niadto nga balay aron susihon ang agup-op, magsugo una siya nga ipagawas ang tanang mga butang sa sulod, aron dili kini maapil ug maisip nga hugaw. Pagkahuman mosulod ang pari sa balay ");
INSERT INTO cebocb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ug susihon niya ang agup-op nga anaa sa bongbong. Ug kon makita niya nga adunay pagkaberde o pagkapula-pula ang naglupyak sa bongbong, ");
INSERT INTO cebocb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","mogawas siya sa maong balay ug pasirad-an niya kini sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sa ikapito nga adlaw, susihon niya kini pag-usab. Ug kon ang agup-op mikuyanap sa ubang bahin sa bongbong, ");
INSERT INTO cebocb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ipakuha niya ang mga bahin sa bongbong nga adunay agup-op ug ipalabay kini didto sa gawas sa lungsod, sa dapit nga labayanan sa mga butang nga giisip nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Pakiskisan niya ang tanang bahin sa bongbong sulod sa balay ug ang tanang kiniskis ipalabay niya sa gawas sa lungsod, sa dapit nga labayanan sa mga butang nga giisip nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Unya pailisan niya ang tanang bahin sa bongbong nga nakiskisan. ");
INSERT INTO cebocb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Apan kon human niadto agup-opon pa gihapon ang balay, ");
INSERT INTO cebocb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","adtoon kini pag-usab sa pari ug susihon. Kon mikuyanap gani ang agup-op, isipon na kadtong balaya nga hugaw kay kini nga matang sa agup-op gabalik-balik. ");
INSERT INTO cebocb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Busa ipaguba niya ang balay ug ang mga materyales niini ipalabay sa gawas sa lungsod, sa dapit nga labayanan sa mga butang nga giisip nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Si bisan kinsa nga mosulod niini nga balay sa dihang gisirad-an kini isipon nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ug si bisan kinsa nga matulog o mokaon sulod niining balaya kinahanglan niyang labhan ang iyang bisti. ");
INSERT INTO cebocb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Apan kon sa pagsusi sa pari wala na agup-opa ang balay human mailisi ang bahin sa bongbong nga giagup-opan, ipahibalo sa pari nga hinlo na ang maong balay. ");
INSERT INTO cebocb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ug aron nga isipon nga hinlo na gayod ang balay, magkuha ang pari ug duha ka langgam, kahoyng sedro, pulang higot, ug isopo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ihawon niya ang usa ka langgam diha ibabaw sa kolon nga gibutangan ug tubig nga gikan sa tuboran. ");
INSERT INTO cebocb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Unya kuhaon niya ang kahoyng sedro, ang pulang higot, ang isopo, ug ang buhi nga langgam, ug ituslob niya kining tanan sa tubig nga adunay dugo sa langgam nga giihaw. Ug wisik-wisikan niya makapito ang balay. ");
INSERT INTO cebocb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Busa pinaagi sa dugo sa langgam, sa tubig nga gikan sa tuboran, sa buhi nga langgam, sa kahoyng sedro, sa isopo, ug sa pulang higot, mahinloan sa pari ang balay. ");
INSERT INTO cebocb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Unya buhian niya ang langgam nga buhi didto sa gawas sa lungsod. Pinaagi niining himuon sa pari, makuha ang kahugaw sa balay ug mahimo na kining hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","57","Mao kadto ang mga patakaran mahitungod sa mga ngilngig nga sakit sa panit nga nuka, hubag-hubag, butoy-butoy, o katol-katol, ug mahitungod sa talumtom sa mga bisti ug agup-op sa balay. Pinaagi niini nga mga patakaran, masayran ninyo kon unsa ang hinlo ug ang hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Gisugo sa Ginoo si Moises ug si Aaron ");
INSERT INTO cebocb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","nga isulti nila kini sa mga Israelinhon: “Kon adunay manggawas sa kinatawo sa usa ka lalaki tungod sa sakit, kanang manggawas isipon nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ug bisan nagpadayon kini sa pagtulo o wala, makahugaw gihapon kini kaniya. Sa bisan asa niini nga kahimtang, hugaw kanang tawhana. ");
INSERT INTO cebocb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ang bisan unsa nga iyang mahigdaan o malingkoran mahimong hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","7","Ug si bisan kinsa nga makahikap kaniya o sa iyang gihigdaan o gilingkoran, kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Si bisan kinsa nga maluwaan niining tawhana, kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","10","Ang bisan unsa nga malingkoran niining tawhana kon magsakay siya, mahimong hugaw. Ang makahikap o makaalsa niini kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Kon kining tawhana wala makapanghunaw, si bisan kinsa nga iyang mahikapan kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ang kolon nga mahikapan niining tawhana kinahanglan nga buk-on, ug ang bisan unsa nga butang nga hinimo sa kahoy nga iyang mahikapan kinahanglan nga hugasan. ");
INSERT INTO cebocb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","15","“Kon mamaayo na kining tawhana sa iyang sakit, palabyon una niya ang pito ka adlaw. Unya labhan niya ang iyang bisti ug maligo sa tubig nga gikan sa tuboran ug mahinloan na siya. Sa ikawalo nga adlaw, kinahanglan nga magdala siyag duha ka salampati o duha ka tukmo sa presensya sa Ginoo didto sa pultahan sa Tolda nga Tagboanan. Unya ihatag niya kini sa pari nga mao ang mohalad niini. Ang usa halad sa paghinlo ug ang usa halad nga sinunog. Pinaagi niining himuon sa pari diha sa presensya sa Ginoo, makuha ang pagkahugaw nianang tawhana tungod sa nanggawas sa iyang kinatawo, ug mahimo na siyang hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Kon ang usa ka lalaki gawasan ug semilya, kinahanglan nga maligo siya, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ang bisan unsa nga panapton o butang nga hinimo sa panit nga matuloan sa iyang semilya kinahanglan nga labhan, apan isipon pa gihapon kini nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kon makighilawas ang lalaki ug babaye, kinahanglan nga maligo silang duha; apan isipon pa gihapon sila nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Kon reglahon ang usa ka babaye, isipon siya nga hugaw sulod sa pito ka adlaw, ug si bisan kinsa nga mohikap kaniya isipon usab nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ang bisan unsa nga iyang mahigdaan o malingkoran, mahimong hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Si bisan kinsa nga makahikap sa iyang gihigdaan o gilingkoran kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Kon makighilawas ang lalaki sa babaye nga giregla, isipon ang lalaki nga hugaw sulod sa pito ka adlaw, ug ang bisan unsa nga iyang mahigdaan mahimong hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Kon ang regla sa babaye molapas pa ug pipila ka adlaw o kon dili niya tingregla apan gidugo siya, isipon gihapon siyang hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ang bisan unsa nga iyang mahigdaan o malingkoran samtang gidugo siya mahimong hugaw sama usab sa panahon sa iyang tingregla. ");
INSERT INTO cebocb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ug si bisan kinsa nga makahikap niini mahimong hugaw. Kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","30","“Kon mohunong na ang pagdugo sa babaye, palabyon una niya ang pito ka adlaw. Human niana mahimo na siyang hinlo. Sa ikawalo nga adlaw, kinahanglan nga magdala siya ug duha ka salampati o duha ka tukmo ngadto sa pari didto sa pultahan sa Tolda nga Tagboanan. Ihalad sa pari ang usa niini isip halad sa paghinlo ug ang usa isip halad nga sinunog. Pinaagi niining himuon sa pari diha sa presensya sa Ginoo, makuha ang pagkahugaw sa babaye ug mahimo na siyang hinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Gisultihan sa Ginoo si Moises ug si Aaron nga pahimangnoan gayod nila ang mga Israelinhon mahitungod sa mga butang nga makahugaw kanila, aron dili sila mamatay kon mosulod sila sa Tolda sa Ginoo nga anaa taliwala sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","“Mao kadto ang mga patakaran mahitungod sa lalaki nga gawasan ug semilya o kon adunay manggawas sa iyang kinatawo tungod sa iyang sakit, ug mahitungod sa babaye nga reglahon o dug-on nga molapas ug pila pa ka adlaw o kon dili pa niya tingregla, ug mahitungod sa lalaki nga makigdulog sa babayeng giisip nga hugaw.” ");
INSERT INTO cebocb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","2","Human namatay ang duha ka anak nga lalaki ni Aaron sa dihang naghalad sila ngadto sa Ginoo, miingon ang Ginoo kang Moises, “Sultihi ang imong igsoon nga si Aaron nga dili siya mosulod sa Labing Balaang Dapit, nga anaa luyo sa kurtina, sa bisan unsang orasa nga buot niya. Mamatay siya kon himuon niya kini. Kay ipadayag ko ang akong presensya pinaagi sa usa ka panganod diha ibabaw sa tabon sa Sudlanan sa Kasabotan.” ");
INSERT INTO cebocb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Mao kini ang himuon ni Aaron sa adlaw nga mosulod siya sa Labing Balaang Dapit: Magdala si Aaron ug nating torong baka isip halad sa paghinlo ug hamtong nga laking karnero isip halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kinahanglan nga maligo siya ug unya isul-ob ang bisti alang sa pangulong pari nga puro lino: ang pang-ilalom nga panapton nga nagtabon sa iyang kinatawo, ang panggawas nga bisti, ang bakos, ug ang turban. ");
INSERT INTO cebocb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Mohatag kaniya ang katilingban sa Israel ug duha ka laking kanding isip halad sa paghinlo ug usa ka hamtong nga laking karnero isip halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ihalad ni Aaron ang nating torong baka aron mahimo siyang hinlo ug ang iyang panimalay. ");
INSERT INTO cebocb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Unya kuhaon niya ang duha ka kanding ug dad-on usab niya sa presensya sa Ginoo, didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Iagi niyag hulbotan kon asa sa duha ka kanding ang alang sa Ginoo ug ang alang kang Azazel. ");
INSERT INTO cebocb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ang kanding nga nahulbotan alang sa Ginoo ihalad niya isip halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Apan ang kanding nga nahulbotan alang kang Azazel ihalad niya nga buhi ngadto sa Ginoo ug buhian niya sa kamingawan, aron mahinloan ang mga tawo gikan sa ilang mga sala. ");
INSERT INTO cebocb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ihawon ni Aaron ang nating torong baka isip halad sa paghinlo alang sa iyang kaugalingon ug sa iyang panimalay. ");
INSERT INTO cebocb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Unya magkuha siyag butanganan sa insenso ug pun-on niya kini ug baga nga gikan sa halaran nga anaa sa presensya sa Ginoo. Ug magkuha usab siya ug duha ka kumkom sa humot ug pino nga insenso, ug dad-on niya kini sa Labing Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ibutang niya ang insenso diha sa kalayo didto sa presensya sa Ginoo, ug ang aso niini molukop sa tabon sa Sudlanan sa Kasugoan, aron dili siya mamatay. ");
INSERT INTO cebocb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Unya mokuha siya ug dugo sa baka ug motindog atubangan sa Sudlanan nga nag-atubang sa sidlakan. Ug pinaagi sa iyang tudlo wisikan niya sa makapito ang tabon niini. ");
INSERT INTO cebocb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ihawon usab niya ang kanding isip halad sa paghinlo alang sa katawhan. Dad-on niya ang dugo niini sa Labing Balaang Dapit ug iwisik sa tabon sa Sudlanan sa Kasabotan, sama sa gihimo niya sa dugo sa nating torong baka. ");
INSERT INTO cebocb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Pinaagi niining himuon ni Aaron, mahinloan ang Labing Balaang Dapit gikan sa kapakyasan sa mga Israelinhon sa pagbuhat ug husto ug sa tanan nilang mga sala ug mga kalapasan. Himuon usab niya kini sa ubang parte sa Tolda nga anaa taliwala sa mahugaw nga katawhan. ");
INSERT INTO cebocb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kinahanglan nga walay tawong magpabilin didto sa Tolda sa oras nga mosulod si Aaron sa Labing Balaang Dapit hangtod nga mogawas siya. Human niya mahimo ang seremonya aron mahinloan siya ug ang iyang panimalay ug ang tibuok katilingban sa Israel, ");
INSERT INTO cebocb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","mogawas siya ug moadto sa halaran sa presensya sa Ginoo. Unya mokuha siya ug dugo sa baka ug sa kanding ug ipahid niya kini sa mga sungay-sungay sa mga eskina sa halaran sa paghinlo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Pinaagi sa iyang tudlo iwisik-wisik niya sa makapito ang ubang dugo didto sa halaran sa paghalad niini ngadto sa Ginoo ug sa paghinlo niini tungod sa pagkahugaw sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Human mahimo ni Aaron ang paghinlo sa Labing Balaang Dapit ug sa uban pa nga mga parte sa Tolda apil na ang halaran, dad-on niya sa atubangan ang buhi nga kanding. ");
INSERT INTO cebocb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ipatong niya ang iyang duha ka kamot sa ulo sa kanding ug isulti niya ang tanang sala ug kalapasan sa mga Israelinhon. Niining paagiha mabalhin ang ilang mga sala ngadto sa ulo sa kanding. Unya pabuhian ni Aaron ang kanding ngadto sa kamingawan sa tawo nga gitugyanan sa paghimo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Busa dad-on sa kanding ang tanang sala sa mga Israelinhon didto sa kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Unya mosulod si Aaron sa Tolda ug huboon niya ang iyang bisti nga alang sa pangulong pari nga iyang gisul-ob sa wala pa siya mosulod sa Labing Balaang Dapit, ug ibilin niya kini didto. ");
INSERT INTO cebocb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Maligo siya didto sa usa ka balaang dapit sa Tolda ug pagkahuman isul-ob niya ang iyang ordinaryong bisti. Unya mogawas siya ug ihalad niya ang halad nga sinunog alang sa iyang kaugalingon ug halad nga sinunog alang sa mga Israelinhon aron mahinloan sila gikan sa ilang mga sala. ");
INSERT INTO cebocb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Sunogon usab niya didto sa halaran ang mga tambok sa mananap nga halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ang tawo nga gitugyanan nga buhian ang kanding alang kang Azazel kinahanglan labhan niya ang iyang bisti ug maligo sa dili pa mobalik ngadto sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kinahanglan nga dad-on ngadto sa gawas sa kampo ug sunogon ang nahibilin nga bahin niadtong baka ug kanding nga gikuhaan sa dugo nga gidala didto sa Labing Balaang Dapit sa paghinlo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ang tawo nga mosunog niini kinahanglan labhan niya ang iyang bisti ug maligo sa dili pa mobalik ngadto sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","31","Mao kini ang mga patakaran nga himuon sa mga Israelinhon ug sa mga langyaw nga nagpuyo uban kanila. Tumanon nila kini hangtod sa kahangtoran. Sa ikanapulo nga adlaw sa ikapito nga bulan, kinahanglan nga magpuasa sila ug dili motrabaho, sama sa Adlaw nga Igpapahulay. Kay mao kana ang adlaw nga himuon ang seremonya sa paghinlo kanila gikan sa ilang mga sala aron mahimo silang hinlo atubangan sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ang pari nga gipili ug giordinahan nga maoy mopuli sa iyang amahan isip pangulong pari mao ang mohimo sa seremonya. Isul-ob niya ang bisti nga alang sa pangulong pari, ");
INSERT INTO cebocb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ug himuon niya ang seremonya sa paghinlo sa Labing Balaang Dapit, sa uban pa nga mga parte sa Tolda apil na sa halaran, sa mga pari, ug sa tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Himuon nila kini nga patakaran kausa matag tuig. Kinahanglan tumanon nila kini hangtod sa kahangtoran. Ug natuman kini sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","nga isulti kini kang Aaron ug sa iyang mga anak nga lalaki ug sa tanang mga Israelinhon: ");
INSERT INTO cebocb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Si bisan kinsa kaninyo nga mohalad ug baka, karnero, o kanding sa laing dapit, ");
INSERT INTO cebocb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","5","ug dili didto sa Tolda nga Tagboanan, sama rang nakapatay siya ug tawo. Busa ayaw na ninyo siya isipa nga inyong sakop. Gihimo kini nga patakaran aron himuon ninyo ang paghalad didto sa pultahan sa Tolda ug dili sa laing dapit. Ang inyong halad alang sa pakigda-it ihatag ninyo sa pari nga mao ang mohalad niini ngadto sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Isablig sa pari ang dugo sa mananap didto sa halaran sa Ginoo, nga anaa dapit sa pultahan sa Tolda. Unya sunogon niya ang mga tambok sa mananap; ang kahumot niini nga halad makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kinahanglan dili na kamo mohalad ngadto sa mga demonyo nga daw kanding, kay kana makapahilayo kaninyo sa Ginoo. Kinahanglan nga tumanon ninyo kini hangtod sa umaabot nga mga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Timan-i gayod ninyo kini, kamong mga Israelinhon ug ang mga langyaw nga nagpuyo uban kaninyo: Si bisan kinsa kaninyo nga mohalad ug bisan unsa nga halad didto sa laing dapit ");
INSERT INTO cebocb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ug dili didto sa pultahan sa Tolda, ayaw na ninyo siya isipa nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Kapungtan sa Ginoo ang si bisan kinsa nga mokaon ug dugo, Israelinhon man o langyaw ug dili ko na siya isipon nga kabahin sa inyong katilingban. ");
INSERT INTO cebocb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kay ang kinabuhi sa matag binuhat anaa sa dugo, ug gisugo kamo sa Ginoo nga gamiton ninyo kini diha sa halaran aron mahinloan kamo gikan sa inyong mga sala. Kay ang dugo nga mao ang naghatag ug kinabuhi, mao ang makahinlo sa tawo gikan sa iyang mga sala. ");
INSERT INTO cebocb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Mao nga miingon ang Ginoo sa mga Israelinhon, “Dili kamo angay mokaon ug dugo, lakip ang mga langyaw nga anaa diha kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Si bisan kinsa kaninyo o sa mga langyaw nga nagpuyo uban kaninyo nga mangdakop ug mananap o langgam nga mahimong kaonon, kinahanglan nga paagason niya ang dugo niini ug tabonan ug yuta, ");
INSERT INTO cebocb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","tungod kay ang kinabuhi sa matag binuhat anaa sa iyang dugo. Mao kana nga gisultihan kamo sa Ginoo nga dili kamo mokaon ug dugo sa bisan unsa nga binuhat. Ug si bisan kinsa nga mokaon, ayaw na ninyo siya isipa nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Si bisan kinsa kaninyo o sa mga langyaw nga mokaon sa mananap nga namatay lang o gipatay sa lain nga mananap, kinahanglan labhan niya ang iyang bisti ug maligo, apan isipon pa gihapon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kon dili niya labhan ang iyang bisti ug dili siya maligo, aduna siyay tulubagon. ");
INSERT INTO cebocb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Isulti kini ngadto sa mga Israelinhon: ‘Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ayaw ninyo sunda ang mga binuhatan sa mga tawo sa Ehipto diin kamo nagpuyo kaniadto. Ayaw usab ninyo sunda ang mga binuhatan sa mga tawo sa Canaan diin dad-on ko kamo. ");
INSERT INTO cebocb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","Kinahanglan nga tumanon ninyo ang akong mga sugo ug mga patakaran, kay ang tawo nga nagtuman niini magkinabuhi. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Walay bisan kinsa kaninyo nga makighilawas sa iyang duol nga paryente. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","8","“ ‘Ayaw pakaulawi ang imong amahan pinaagi sa pagpakighilawas sa imong inahan o sa uban pa niyang asawa. ");
INSERT INTO cebocb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Ayaw pakighilawas sa imong igsoon nga babaye, bisan igsoon mo lang siya sa imong amahan o sa imong inahan, ug bisan nagdako man siya uban kaninyo o wala. ");
INSERT INTO cebocb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Ayaw pakighilawas sa imong apo nga babaye, kay makahatag kini ug kaulawan kanimo. ");
INSERT INTO cebocb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Ayaw pakighilawas sa anak nga babaye sa imong amahan sa uban nga asawa, kay igsoon mo usab siya. ");
INSERT INTO cebocb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","“ ‘Ayaw pakighilawas sa imong iyaan, kay igsoon siya sa imong amahan o inahan. ");
INSERT INTO cebocb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Ayaw pakaulawi ang igsoong lalaki sa imong amahan pinaagi sa pagpakighilawas sa iyang asawa, kay iyaan mo usab siya. ");
INSERT INTO cebocb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Ayaw pakighilawas sa imong umagad nga babaye kay asawa siya sa imong anak. ");
INSERT INTO cebocb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Ayaw pakighilawas sa asawa sa imong igsoon kay makahatag kini ug kaulawan sa imong igsoon. ");
INSERT INTO cebocb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Ayaw pakighilawas sa anak o apo nga babaye sa babaye nga imong gikadulog, kay tingalig anak o apo mo siya, ug daotan kana nga buhat. ");
INSERT INTO cebocb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Ayaw pangasaw-a ang igsoon nga babaye sa imong asawa samtang buhi pa ang imong asawa. ");
INSERT INTO cebocb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Ayaw pakighilawas sa babaye nga giregla kay giisip siya nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Ayaw pakighilawas sa asawa sa uban, kay kon buhaton mo kini isipon ka nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Ayaw ihatag ang bisan kinsa sa imong mga anak aron ihalad ngadto sa dios nga si Molec, kay makahatag kana ug kaulawan sa pangalan sa imong Dios. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Ayaw pakighilawas sa sama kanimo nga lalaki, kay mangil-ad kana. ");
INSERT INTO cebocb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Ayaw pakighilawas, malalaki man o mababaye o ngadto sa mananap, kay daotan ug hugaw kaayo kana nga buhat. ");
INSERT INTO cebocb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Ayaw ninyo hugawi ang inyong kaugalingon pinaagi sa paghimo sa bisan asa niining mga butanga, kay mao kini ang nakapahugaw sa mga tawong papahawaon ko sa yuta nga alang kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","28","Bisan gani kanang yutaa nahugawan tungod nianang ilang gihimo, busa gipadad-an ko ug mga kalamidad kanang yutaa aron sa ingon niana nga paagi mamahawa sila diha. Apan kamong mga Israelinhon ug ang mga langyaw nga nagpuyo uban kaninyo, ayaw gayod ninyo himoa kanang mangil-ad nga mga butang kondili tumana gayod ninyo ang akong mga patakaran ug mga sugo. Kay kon hugawan ninyo ang yuta pinaagi sa pagbuhat nianang mga butanga, papahawaon ko kamo gikan nianang yutaa sama sa mga unang lumulupyo didto. ");
INSERT INTO cebocb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Si bisan kinsa nga mohimo niining mangil-ad nga mga butang dili na ninyo isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Busa tumana ninyo ang gipatuman ko kaninyo ug ayaw gayod ninyo sunda ang mangil-ad nga mga gihimo sama sa mga unang lumulupyo didto, aron dili ninyo mahugawan ang inyong kaugalingon tungod niini. Ako mao ang Ginoo nga inyong Dios.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Gisugo sa Ginoo si Moises ");
INSERT INTO cebocb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Isulti kini sa tibuok katilingban sa Israel: ‘Magkinabuhi kamo nga balaan kay ako, ang Ginoo nga inyong Dios, balaan. ");
INSERT INTO cebocb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Tahora ninyo ang inyong inahan ug amahan, ug tumana ninyo ang akong mga gipahimo kaninyo sa Adlaw nga Igpapahulay. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Ayaw kamo pagsimba sa mga dios-dios ni maghimo ug mga puthaw nga rebulto. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Kon maghalad kamo ug halad alang sa pakigda-it kanako, ihalad kini sa paagi nga dawaton ko alang kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kan-on ninyo ang karne niini sa adlaw sa inyong paghalad o sa pagkasunod nga adlaw. Apan kon adunay mahibilin nga karne hangtod sa ikatulo nga adlaw, kinahanglan nga sunogon na ninyo kini. ");
INSERT INTO cebocb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kon kan-on ninyo kini sa ikatulo nga adlaw, isipon kini nga hugaw ug dili ko kini dawaton. ");
INSERT INTO cebocb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Si bisan kinsa nga mokaon niini adunay tulubagon tungod kay gipakawalay-bili niya ang butang nga alang kanako; busa kanang tawhana ayaw na ninyo isipa nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Kon mag-ani kamo, ayaw ninyo hutda ug ani ang anaa sa daplin sa inyong tamnanan, ug ayaw na kamo panghagdaw. ");
INSERT INTO cebocb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mao usab sa ubasan, ayaw na ninyo baliki ang mga nangahulog. Ibilin na lang ninyo kini alang sa mga kabos ug sa mga langyaw. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Ayaw kamo pangawat, pamakak, o panglimbong sa inyong isigka-tawo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Ayaw kamo panumpa ug bakak ginamit ang akong ngalan, kay kon himuon ninyo kana panamastamasan ninyo ang akong ngalan. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Ayaw ninyo limbongi o kawati ang inyong isigka-tawo. Ayaw ninyo paugmai ang paghatag sa sweldo sa tawo nga gipatrabaho ninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Ayaw ninyo bugal-bugali ang bungol, ug ayaw kamo pagbutang ug ali sa agianan sa buta. Himoa ninyo kini sa pagpakita nga nagtahod kamo kanako nga inyong Dios. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Kinahanglan nga makatarunganon ug husto ang inyong paghukom sa korte; ayaw kamo pagpabor-pabor sa mga adunahan man o kabos. ");
INSERT INTO cebocb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Ayaw kamo panglibak sa inyong isigka-tawo. Ayaw kamo paghimo ug bisan unsa nga makadaot sa iyang kinabuhi. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Ayaw ninyo dumti ang inyong isigka-tawo. Badlonga ninyo siya kon nakasala siya aron wala kamoy tulubagon. ");
INSERT INTO cebocb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Ayaw kamo pagpanimalos o pagdumot sa inyong isigka-tawo, kondili higugmaa ninyo siya sama sa inyong paghigugma sa inyong kaugalingon. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Tumana ninyo ang akong mga patakaran. Ayaw ninyo pahabali ang usa ka mananap sa lain nga klasi sa mananap. Ayaw kamo pagtanom ug duha ka klasi nga binhi sa usa ka tamnanan. Ayaw kamo pagsul-ob ug bisti nga hinimo sa duha ka klasi nga panapton. ");
INSERT INTO cebocb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Kon ang usa ka lalaki makighilawas sa usa ka sulugoon nga babaye nga kaslonon na sa laing lalaki, apan kining babaye wala pa maluwas o mahatagi ug kagawasan, kinahanglang silotan sila. Apan dili lang sila patyon kay dili pa man gawasnon ang maong babaye. ");
INSERT INTO cebocb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","22","Kinahanglang magdala ang lalaki ug hamtong nga laking karnero didto sa pultahan sa Tolda nga Tagboanan isip bayad sa iyang sala. Pinaagi sa paghalad sa pari ug karnero diha sa akong presensya, mahinloan ang lalaki gikan sa iyang sala ug pasayloon ko siya. ");
INSERT INTO cebocb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Kon moabot na kamo sa yuta nga ihatag ko kaninyo, ayaw ninyo kan-a ang mga bunga sa mga kahoy nga inyong gitanom sa unang tulo ka tuig. Isipon ninyo kini nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Sa ikaupat nga tuig, ang tanang bunga ihalad ninyo isip pagdayeg kanako. ");
INSERT INTO cebocb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Apan sa ikalima nga tuig makakaon na kamo sa mga bunga. Ug kon tumanon ninyo kini nga mga patakaran, moabunda ang mga bunga sa inyong mga kahoy. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Ayaw kamo pagkaon sa karne nga aduna pay dugo. “ ‘Ayaw ninyo himoa ang ginahimo sa mga manalagna o mamamarang. ");
INSERT INTO cebocb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Kon magsubo kamo alang sa patay, ayaw ninyo putli ang inyong buhok sa isigka-kilid sa inyong ulo o ang inyong bangas. ");
INSERT INTO cebocb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ayaw usab ninyo samari ang inyong lawas. Ayaw usab kamo pagpapatik. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Ayaw ninyo panamastamasi ang inyong mga anak nga babaye pinaagi sa pag-aghat kanila sa pagbaligya sa ilang dungog, kay mokaylap ang kahilayan ug mapuno sa kadaotan ang inyong dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Tumana ninyo ang akong mga gipahimo kaninyo sa Adlaw nga Igpapahulay, ug tahora ninyo ang dapit diin kamo nagsimba kanako. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Ayaw kamo pagdangop sa mga espiritista ug niadtong mga nakigsulti sa kalag sa patay, kay kon himuon ninyo kini isipon kamo nga hugaw. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Tahora ninyo ang mga tigulang, ug tahora usab ninyo ako nga inyong Dios. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Ayaw ninyo daog-daoga ang mga langyaw nga nagpuyo uban kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Tagda ninyo sila sama sa inyong pagtagad sa mga sama kaninyo, ug higugmaa ninyo sila sama sa inyong paghigugma sa inyong kaugalingon, kay mga dumuduong usab kamo kaniadto didto sa Ehipto. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Ayaw kamo panglimbong sa inyong pagtimbang, pagtakos, o pagsukod. ");
INSERT INTO cebocb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","37","Gamita ninyo ang husto nga timbangan, taksanan, o sukdanan. “ ‘Ako mao ang Ginoo nga inyong Dios nga nagpagawas kaninyo gikan sa Ehipto. Tumana ninyo ang tanan kong mga patakaran ug mga sugo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Sultihi ang mga Israelihon, ‘Si bisan kinsa kaninyo o sa mga langyaw nga nagpuyo uban kaninyo nga mohalad sa iyang anak ngadto sa dios-dios nga si Molec, kinahanglan nga batohon sa mga tawo sa katilingban hangtod nga mamatay gayod. ");
INSERT INTO cebocb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Kapungtan ko kanang tawhana ug ayaw na ninyo siya isipa nga inyong sakop. Kay sa iyang paghalad sa iyang anak ngadto kang Molec, gihugawan niya ang akong balaang puloy-anan ug gipasipalahan niya ang akong balaan nga ngalan. ");
INSERT INTO cebocb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kon pasagdan ninyo ang mga tawo nga naghalad sa ilang anak kang Molec ug nagdumili sa paghukom kaniya, ");
INSERT INTO cebocb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","kapungtan ko siya ug ang iyang panimalay ug ang tanan nga nagsunod kaniya sa iyang paghalad ngadto kang Molec. Dili ko sila isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Kapungtan ko usab ang tawo nga modangop ug mosunod sa mga espiritista ug moduyog sa ilang salawayon nga buhat ug kadtong mga nakigsulti sa kalag sa patay. Dili ko sila isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Ilain ninyo ang inyong kaugalingon alang kanako ug pagkinabuhi kamo nga balaan, tungod kay ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Tipigi ninyo ang akong mga patakaran ug tumana kini. Ako mao ang Ginoo nga naglain kaninyo alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Si bisan kinsa nga motunglo sa iyang amahan o inahan kinahanglan nga patyon. Siya ra ang sad-an sa bisan unsang mahitabo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Kon ang usa ka lalaki makighilawas sa asawa sa uban, siya ug ang babaye kinahanglan nga patyon. ");
INSERT INTO cebocb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Kon ang usa ka lalaki makighilawas sa usa sa mga asawa sa iyang amahan, gipakaulawan niya ang iyang amahan. Ug silang duha sa babaye kinahanglan nga patyon. Sila ra ang responsable sa ilang kamatayon. ");
INSERT INTO cebocb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Kon ang amahan makighilawas sa iyang umagad nga babaye, silang duha kinahanglan nga patyon kay daotan ang ilang gihimo. Sila ra ang responsable sa ilang kamatayon. ");
INSERT INTO cebocb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Kon ang usa ka lalaki makighilawas sa sama niyang lalaki, silang duha kinahanglan nga patyon kay mangil-ad ang ilang gihimo. Sila ra ang responsable sa ilang kamatayon. ");
INSERT INTO cebocb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Kon adunay lalaking maminyo sa inahan ug anak, kinahanglan nga sunogon silang tulo, kay daotan ang ilang gihimo. Dili angay nga magpabilin kini nga kadaotan diha kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","16","“ ‘Kon ang usa ka lalaki o babaye makighilawas sa usa ka mananap, kinahanglan nga patyon siya ug ang mananap. Sila ang responsable sa ilang kamatayon. ");
INSERT INTO cebocb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Kon ang usa ka lalaki mangasawa ug makighilawas sa iyang igsoong babaye, bisan kon igsoon lang niya kini sa amahan o sa inahan, gipakaulawan niya ang iyang igsoon ug aduna siyay tulubagon. Ug tungod kay makauulaw ang gihimo nilang duha, dili na ninyo sila isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Kon ang usa ka lalaki makighilawas sa babaye nga giregla, ug mosugot ang babaye, dili na ninyo sila isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Kon ang usa ka lalaki makighilawas sa iyang iyaan, gipakaulawan niya ang iyang iyaan. Silang duha aduna may tulubagon sa ilang gihimo. ");
INSERT INTO cebocb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Kon ang usa ka lalaki makighilawas sa asawa sa iyang uyoan, gipakaulawan niya ang iyang uyoan. Silang duha aduna nay tulubagon, ug mamatay na lang sila nga walay anak. ");
INSERT INTO cebocb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Kon ang usa ka lalaki makigrelasyon sa asawa sa iyang igsoon, gipakaulawan niya ang iyang igsoon. Ug tungod kay giisip nga hugaw ang ilang gihimo, mamatay na lang sila nga walay anak. ");
INSERT INTO cebocb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Tumana ninyo ang tanan kong mga patakaran ug mga sugo aron dili ko kamo papahawaon sa yuta nga dad-an ko kaninyo diin kamo mopuyo. ");
INSERT INTO cebocb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ang katawhan nga papahawaon ko niadtong yutaa naghimo niana nga mga kadaotan. Ug tungod niini gikapungtan ko sila pag-ayo. Busa ayaw ninyo sunda ang ilang gihimo. ");
INSERT INTO cebocb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Sumala sa giingon ko kaninyo, mainyo ang ilang yuta. Ihatag ko kaninyo kining maayo ug mabungahon nga yuta aron inyong panag-iyahon. Ako ang Ginoo nga inyong Dios nga naglain kaninyo gikan sa ubang mga katawhan. ");
INSERT INTO cebocb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Kinahanglan mahibaloan ninyo kon unsa ang hinlo ug ang hugaw nga mga mananap apil na ang mga langgam. Dili ninyo hugawan ang inyong kaugalingon pinaagi sa pagkaon sa hugaw nga mga mananap. Sumala sa giingon ko kaninyo, isipon ninyo kini nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Magkinabuhi kamo nga balaan kay ako, ang Ginoo, balaan. Gilain ko kamo gikan sa ubang mga nasod aron mahimong ako. ");
INSERT INTO cebocb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Kon aduna kaninyoy espiritista o nakigsulti sa kalag sa patay, kinahanglan nga batohon siya hangtod nga mamatay. Siya ang responsable sa iyang kamatayon.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Miingon ang Ginoo kang Moises, “Isulti kini ngadto sa mga pari nga kaliwat ni Aaron: ‘Ayaw ninyo hugawi ang inyong kaugalingon pinaagi sa pagtambong sa lubong sa inyong isigka-Israelinhon, ");
INSERT INTO cebocb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","gawas lang kon ang namatay duol ninyong paryente sama sa inyong inahan, amahan, anak, igsoon nga lalaki, ");
INSERT INTO cebocb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o igsoon nga babaye nga wala pay bana apan kamoy nagbuhi. ");
INSERT INTO cebocb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ayaw usab ninyo hugawi ang inyong kaugalingon pinaagi sa pagtambong sa lubong sa paryente sa inyong asawa. ");
INSERT INTO cebocb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Ayaw ninyo kagisi ang bisan asa nga parte sa inyong ulo o balbasi ang inyong bangas, o samari ang inyong lawas. ");
INSERT INTO cebocb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kinahanglan nga ilain ninyo ang inyong kaugalingon alang kanako nga inyong Dios, ug ayaw ninyo pasipalahi ang akong ngalan. Himoa ninyo kini kay kamo ang gahalad sa mga halad pinaagi sa kalayo, nga mao ang akong pagkaon. ");
INSERT INTO cebocb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Kinahanglan nga dili kamo mangasawa sa babaye nga hugaw tungod kay nagbaligya siya sa iyang dungog, o sa babaye nga gibulagan sa iyang bana, tungod kay gilain kamo alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kinahanglan nga isipon kamo sa inyong isigka-Israelinhon nga balaan kay kamo ang gahalad sa mga halad, nga mao ang akong pagkaon. Kinahanglan gayod nga isipon nila kamo nga balaan kay ako, ang Ginoo, balaan, ug ginahimo ko ang akong katawhan nga balaan. ");
INSERT INTO cebocb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Kon aduna kamoy anak nga babaye nga nagpakaulaw kaninyo tungod kay nagbaligya siya sa iyang dungog, ug tungod niini giisip siya nga mahugaw, kinahanglan nga sunogon siya. ");
INSERT INTO cebocb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Kon ang pangulong pari magsubo alang sa patay, kinahanglan nga dili niya kalkagon ang iyang buhok ug dili niya gision ang iyang bisti. ");
INSERT INTO cebocb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kinahanglan nga likayan niya ang pagduol sa patay, bisan pa kon iya kining amahan o inahan. ");
INSERT INTO cebocb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ug tungod kay gihalad siya kanako isip pangulong pari pinaagi sa pagdihog kaniya ug lana, dili siya angay nga mobiya sa balaang puloy-anan aron motambong sa lubong, kay kon himuon niya kini mahugawan ang Tolda. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","14","“ ‘Ang pangasaw-on sa pangulong pari kinahanglan nga putli ug sama kaniya nga Israelinhon. Dili siya mangasawa ug balo, o sa babaye nga gibulagan ug bana, o sa babaye nga hugaw tungod nga nagbaligya sa iyang dungog. ");
INSERT INTO cebocb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Niining paagiha dili isipon nga hugaw ang iyang mga anak. Ako, ang Ginoo, ang naglain kaniya nga mahimong pangulong pari.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Isulti kini kang Aaron: ‘Walay bisan kinsa sa imong mga kaliwat hangtod sa umaabot nga mga henerasyon ang makahalad sa mga halad, nga mao ang akong pagkaon, kon adunay depekto sa iyang lawas. ");
INSERT INTO cebocb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Dili mahimo nga ang buta, bakol, ang adunay depekto sa iyang nawong, dili normal ang usa ka bahin sa lawas, ");
INSERT INTO cebocb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","adunay bali ang tiil o kamot, ");
INSERT INTO cebocb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","buktot, unano, adunay sakit sa mata o sa panit, o dili makaanak. ");
INSERT INTO cebocb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","23","Busa kon ang usa ka kaliwat ni Aaron adunay depekto, dili siya mahimo nga mohalad sa mga halad pinaagi sa kalayo, nga mao ang akong pagkaon. Dili usab siya mahimong mosulod sa Balaang Dapit ug moduol sa halaran kay mahugawan ang akong Tolda. Apan mahimo siyang mokaon sa mga pagkaon nga bahin nilang mga pari sa balaan nga halad ug sa labing balaan nga halad. Ako, ang Ginoo, ang naglain kaninyo nga mahimong mga pari.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Busa gisulti kining tanan ni Moises kang Aaron ug sa iyang mga anak nga lalaki, ug sa tanang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Sultihi si Aaron ug ang iyang mga anak nga lalaki nga tahoron nila ang mga halad nga gihalad sa mga Israelinhon aron dili nila pasipalaan ang akong balaan nga ngalan. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Sultihi sila, ‘Kon aduna kaninyo karon o sa inyong mga kaliwat sa umaabot nga mga henerasyon nga giisip nga hugaw nga mohikap sa halad nga alang kanako, dili na gayod siya makaalagad isip pari. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","7","“ ‘Walay bisan kinsa kaninyo nga makakaon sa halad kon aduna siyay ngilngig nga sakit sa panit, o adunay nanggawas sa iyang kinatawo tungod sa sakit, o nakahikap sa mga butang nga nahimong hugaw tungod kay nasaghid kini sa patay, o gigawasan ug semilya, o nakahikap sa mananap nga giisip nga hugaw o sa tawong giisip nga hugaw. Makakaon lang siya sa mga halad kon makaligo na siya, apan mohulat una siya hangtod hapon sa pagsalop sa adlaw ayha siya makakaon sa mga halad nga mao ang iyang kalan-on isip pari. ");
INSERT INTO cebocb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kinahanglan nga dili kamo mokaon sa bisan unsa nga karne sa mananap nga namatay lang o gipatay sa uban nga mananap, kay kon himuon ninyo kini isipon kamo nga hugaw. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Kinahanglan nga tumanon gayod ninyo ang gipatuman ko kaninyo aron dili kamo manubag ug mangamatay. Ako ang Ginoo nga naglain kaninyo alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Kamo lang nga mga pari ug ang inyong panimalay ang makakaon sa bahin sa mga halad nga alang sa mga pari. Dili mahimong mokaon niini ang inyong bisita o ang inyong sinuholan nga trabahante. ");
INSERT INTO cebocb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Apan mahimong mokaon ang sulugoon nga gipalit ninyo o natawo diha sa inyong panimalay. ");
INSERT INTO cebocb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Dili usab makakaon niini ang anak sa pari nga nakapamana ug dili pari. ");
INSERT INTO cebocb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Apan kon nabalo siya o nagkabulag sila sa iyang bana ug wala silay anak, ug mibalik siyag puyo uban sa iyang amahan, makakaon siya sa pagkaon nga gidawat sa iyang amahan isip pari. Hinumdomi gayod ninyo nga kamo lang nga mga pari ug ang inyong panimalay ang makakaon sa bahin sa mga halad nga alang kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Apan kon ang usa ka tawo nga dili miyembro sa inyong panimalay nakakaon niini nga wala niya tuyoa, kinahanglan nga ulian niya kini sa inyo ug dugangan pa gayod niya ug 20 porsyento sa presyo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kamong mga pari, ayaw ninyo pasipalahi ang mga halad sa mga Israelinhon alang kanako, ");
INSERT INTO cebocb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","aron nga sa pagkaon ninyo niini dili kamo makasala ug wala kamoy tulubagon. Ako ang Ginoo nga naglain kaninyo alang kanako.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Isulti kini kang Aaron ug sa iyang mga anak nga lalaki, sa tanan nga sama nilang mga Israelinhon, ug apil na usab sa mga langyaw nga nagpuyo uban kanila: ‘Kon ang halad nga sinunog mao ang inyong ihalad isip halad sa pagtuman sa usa ka panaad o halad nga kinabubut-on, ");
INSERT INTO cebocb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kinahanglan nga laki kini nga baka, karnero, o kanding nga walay depekto, aron ako kining dawaton. ");
INSERT INTO cebocb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ayaw kamo paghalad ug adunay depekto kay dili ko gayod kini dawaton. ");
INSERT INTO cebocb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kon ang halad alang sa pakigda-it ngadto sa Ginoo ang inyong ihalad isip halad sa pagtuman sa usa ka panaad o halad nga kinabubut-on, kinahanglan nga baka o karnero o kanding kini nga walay depekto aron dawaton ko kini. ");
INSERT INTO cebocb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ayaw kamo paghalad kanako ug mananap nga buta, nabalian, nasamaran, o adunay sakit sa panit. ");
INSERT INTO cebocb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Mahimo ninyong ihalad isip halad nga kinabubut-on ang baka o karnero o kanding nga adunay depekto, apan dili kini mahimong ihalad isip halad sa pagtuman sa usa ka panaad. ");
INSERT INTO cebocb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ayaw kamo paghalad kanako ug mananap nga nasamaran sa itlog, o gikapon. Ayaw gayod ninyo kini buhata sa inyong dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ug ayaw usab kamo pagpalit nianang matanga sa mga mananap gikan sa mga langyaw aron ihalad kanako, kay dili ko kana dawaton.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Misulti ang Ginoo kang Moises, Ang bag-ong gipanganak nga baka, karnero, o kanding kinahanglan magpabilin uban sa iyang inahan sulod sa pito ka adlaw. Apan paglapas sa pito ka adlaw mahimo na kining ihalad kanako. ");
INSERT INTO cebocb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ayaw ninyo ihalad ug dungan sa baka o karnero o kanding ang mga nati niini sulod sa usa lang ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kon maghalad kamo ug halad sa pagpasalamat kanako, sunda ninyo ang husto nga pamaagi sa paghalad niini aron dawaton ko kini. ");
INSERT INTO cebocb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ug kinahanglan nga kaonon ninyo kini niana mismong adlaw sa paghalad niini ug ayaw gayod ninyo binli hangtod pagkaugma. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Tumana ninyo ang akong mga sugo. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ayaw ninyo pasipalahi ang akong balaan nga ngalan, ug ilha ninyo ako nga balaan. Ako mao ang Ginoo nga naglain kaninyo alang kanako, ");
INSERT INTO cebocb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ug nagpagawas kaninyo gikan sa Ehipto aron mahimong inyong Dios. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Gisugo sa Ginoo si Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Isulti kini ngadto sa mga Israelinhon: ‘Kini ang mga patakaran mahitungod sa pinasahi nga mga higayon nga magtigom sila sa pagsimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Adunay unom kamo ka adlaw sa pagtrabaho, apan sa ikapito nga adlaw mopahulay kamo kay mao kana ang Adlaw nga Igpapahulay. Ayaw kamo pagtrabaho nianang adlawa, kondili pagtigom kamo aron sa pagsimba, kay adlaw kana nga pasidunggan ninyo ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Mao kini ang mga pinasahi nga kasaulogan sa Ginoo, ang mga sagrado nga panagtigom nga inyong imantala sa pinasahi usab nga mga higayon. ");
INSERT INTO cebocb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ang Pista sa Paglabay sa Anghel himuon sa gabii sa ika-14 nga adlaw sa nahaunang bulan. ");
INSERT INTO cebocb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ug sa ika-15 nga adlaw sa mao gihapon nga bulan, magsugod usab ang Pista sa Pan nga Walay Patubo sa Ginoo. Pito ka adlaw kini nga pista, ug nianang mga adlawa kinahanglan nga pan nga walay patubo ang inyong kaonon. ");
INSERT INTO cebocb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Sa nahaunang adlaw niining pista, ayaw kamo pagtrabaho kondili pagtigom kamo aron sa pagsimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sulod sa pito ka adlaw, paghalad kamo ngadto sa Ginoo. Ug sa ikapito nga adlaw ayaw na usab kamo pagtrabaho kondili pagtigom kamo aron sa pagsimba sa Ginoo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","11","Ug miingon ang Ginoo kang Moises, “Ihatag kining panugon sa mga Israelinhon, Kon atua na kamo sa yuta nga ihatag sa Ginoo kaninyo, ihalad ninyo kaniya ang unang bugkos sa mga uhay sa matag ani ninyo. Dad-a ninyo kini ngadto sa pari. Pagkasunod nga adlaw human sa Adlaw nga Igpapahulay, ibayaw kini sa pari ngadto sa presensya sa Ginoo aron dawaton kamo sa Ginoo pinaagi niini.” ");
INSERT INTO cebocb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Niana usab nga adlaw, paghalad usab kamo sa Ginoo ug karnero nga nag-edad ug usa ka tuig ug walay depekto isip halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Lakipi ninyo kini ug upat ka kilo nga maayong klasi sa harina nga gisagolan ug mantika isip halad sa pagpasidungog sa Ginoo, ug usa ka litro nga bino isip halad nga ilimnon. Mga halad kini pinaagi sa kalayo, ug ang kahumot niini makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kon wala pa kini ninyo ikahalad, ayaw gayod kamo pagkaon sa bisan unsa nga matang sa pagkaon gikan sa inyong bag-ong giani, hilaw man kini o sinanlag o giluto nga pan. Kini nga mga patakaran kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon, bisan asa pa kamo magpuyo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","17","“Paglabay sa pito ka semana gikan sa adlaw nga naghalad kamo niadtong binugkos nga uhay, pagtigom kamo ug paghalad ug halad sa pagpasidungog sa Ginoo gikan niadtong mga uhay nga bag-o lang ninyong giani. Bali ika-50 kini nga adlaw nga mao ang adlaw human sa ikapito nga Adlaw nga Igpapahulay. Paghalad kamo ug duha ka pan nga ang matag-usa hinimo sa upat ka kilo nga maayong klasi sa harina, ug adunay patubo. Ihalad ninyo kini isip halad nga binayaw gikan sa nahauna ninyong ani. ");
INSERT INTO cebocb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Lakipi ninyo kini ug pito ka laking karnero nga tag-usa ka tuig ang edad, usa ka nating torong baka, ug duha ka hamtong nga laking karnero, nga walay mga depekto. Ihalad ninyo kini isip halad nga sinunog uban sa halad sa pagpasidungog sa Ginoo apil ang halad nga ilimnon. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Unya paghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, ug duha ka karnero nga tag-usa ka tuig ang edad isip halad alang sa pakigda-it. ");
INSERT INTO cebocb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Unya ibayaw sa pari diha sa presensya sa Ginoo ang duha ka karnero ug ang halad nga gikan sa nahaunang ani. Balaan kini nga mga halad alang sa Ginoo, ug bahin kini sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Sa mao usab nga adlaw ayaw kamo pagtrabaho kondili pagtigom kamo aron sa pagsimba sa Ginoo. Kini nga mga patakaran kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon, bisan asa pa kamo magpuyo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Kon mag-ani kamo, ayaw ninyo hutda ug ani ang anaa sa daplin sa inyong tamnanan, ug ayaw na kamo panghagdaw. Ibilin na lang ninyo kana alang sa mga kabos ug sa mga langyaw. Ako mao ang Ginoo nga inyong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Gisugo sa Ginoo si Moises nga isulti kini ngadto sa mga Israelinhon, “Sa nahaunang adlaw sa ikapito nga bulan, mopahulay kamo sa paghinumdom sa Ginoo. Kon madunggan ninyo ang pagpatingog sa mga budyong, pagtigom kamo aron sa pagsimba kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ayaw kamo pagtrabaho nianang adlawa kondili paghalad kamo ngadto sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","28","Ug miingon ang Ginoo kang Moises, “Ang ikanapulo nga adlaw niining ikapito nga bulan mao ang Adlaw sa Pagluwas sa mga Tawo gikan sa Ilang mga Sala. Ayaw kamo pagtrabaho nianang adlawa kondili pagtigom kamo sa pagsimba sa Ginoo. Pagpuasa ug paghalad kamo ug halad nga sinunog alang kaniya. Kay nianang adlawa himuon ang seremonya sa paghinlo kaninyo sa inyong mga sala diha sa presensya sa Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ang dili magpuasa nianang adlawa dili na ninyo isipon nga inyong sakop. ");
INSERT INTO cebocb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Patyon sa Ginoo si bisan kinsa nga magtrabaho nianang adlawa. ");
INSERT INTO cebocb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","32","Busa pahulay kamo ug pagpuasa sugod sa pagsalop sa adlaw sa ikasiyam nga adlaw nianang bulana hangtod sa pagkasunod nga pagsalop sa adlaw. Kini nga mga patakaran kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon, bisan asa pa kamo magpuyo.” ");
INSERT INTO cebocb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Sultihi ang mga Israelinhon, ‘Sa ika-15 nga adlaw sa ikapitong bulan magsugod ang Pista sa Pagpatindog sa mga Payag sa Ginoo, ug sauloga ninyo kini sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Sa nahaunang adlaw ayaw kamo pagtrabaho kondili pagtigom kamo aron sa pagsimba sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sulod sa pito ka adlaw paghalad kamo ug halad nga sinunog alang sa Ginoo. Ug sa ikawalo nga adlaw ayaw na usab kamo pagtrabaho kondili pagtigom na usab kamo aron sa pagsimba sa Ginoo, ug paghalad ug halad pinaagi sa kalayo alang kaniya. Kataposan kini nga adlaw sa inyong panagtigom. ");
INSERT INTO cebocb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Mao kini ang mga pinasahi nga higayon nga magtigom kamo aron sa pagsimba sa Ginoo ug sa paghalad sa mga halad pinaagi sa kalayo: mga halad nga sinunog, halad sa pagpasidungog sa Ginoo, halad nga mga uhay ug mga halad nga ilimnon, nga kinahanglan nga ihalad ninyo sa mga higayon nga ihalad kini. ");
INSERT INTO cebocb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ug ihalad ninyo kini nga mga halad dugang sa inyong mga gasa, sa inyong mga halad sa pagtuman sa mga panaad, ug sa mga halad nga kinabubut-on ngadto sa Ginoo. Sauloga ninyo kini nga mga pinasahi nga higayon dugang sa Adlaw nga Igpapahulay nga ginahimo ninyo kada semana. ");
INSERT INTO cebocb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Kon mahitungod sa Pista sa Pagpatindog sa mga Payag, sauloga ninyo kini sa pagpasidungog sa Ginoo gikan sa ika-15 nga adlaw sa ikapito nga bulan, pagkahuman sa ting-ani. Sauloga ninyo kini sulod sa pito ka adlaw; ayaw kamo pagtrabaho sa nahaunang adlaw ug sa ikawalo nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Sa nahaunang adlaw, pagkuha kamo ug mga labing maayong mga bunga sa mga kahoy, mga palwa sa palma, ug mga sanga sa labong nga mga kahoy sa walog, ug paglipay kamo sa presensya sa Ginoo nga inyong Dios sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","43","Kini nga pista sauloga ninyo sa ikapito nga bulan matag tuig sa pagpasidungog sa Ginoo. Sulod sa pito ka adlaw, pagpuyo kamo sa mga payag aron nga mahibaloan sa inyong mga kaliwat nga gipapuyo sa Ginoo nga inyong Dios ang inyong mga katigulangan sa mga payag sa dihang gipagawas niya sila gikan sa Ehipto. Kini nga mga patakaran kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mao kadto ang mga pinasahi nga higayon sa pagsimba sa Ginoo nga gipahibalo ni Moises sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","4","Gisugo sa Ginoo si Moises nga ipatuman niya kini sa mga Israelinhon: “Dad-an ninyo ug purong lana gikan sa dinukdok nga olibo ang mga suga nga anaa gawas sa kuwarto diin nahimutang ang Sudlanan sa Kasugoan didto sa Tolda nga Tagboanan, aron walay undang ang pagsiga niini sa presensya sa Ginoo. Kon mongitngit na, dagkotan kini ni Aaron ug pasigahon hangtod mobuntag. Sigurohon gayod niya nga kanunayng magsiga ang mga suga sa butanganan niini nga purong bulawan. Kini nga mga patakaran kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Paghimo kamo ug 12 kabuok pan, nga ang matag-usa hinimo sa upat ka kilo nga maayong klasi sa harina. ");
INSERT INTO cebocb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ibutang ninyo kini sa lamisa nga purong bulawan sa presensya sa Ginoo. Ipatong-patong ninyo kini sa duha ka tapok nga ang matag tapok adunay unom ka pan. ");
INSERT INTO cebocb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Unya butangi ninyog purong insenso sa tapad sa kada tapok. Ang insenso mao ang magsilbing halad sa paghinumdom sa Ginoo. Sunogon kini ingon nga halad pinaagi sa kalayo baylo sa mga pan. ");
INSERT INTO cebocb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kinahanglan nga magbutang gayod kanunay niining mga pan sa presensya sa Ginoo sa matag Adlaw nga Igpapahulay. Katungdanan ninyo kini nga mga Israelinhon hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Kini nga mga pan alang sa mga pari nga kaliwat ni Aaron. Kan-on nila kini didto sa balaang dapit sa Tolda, tungod kay balaan kaayo kini nga bahin sa mga halad alang sa Ginoo, ug alang gayod kini kanila hangtod sa kahangtoran.” ");
INSERT INTO cebocb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Adunay usa ka tawo nga ang iyang amahan Ehiptohanon ug ang iyang inahan Israelinhon. (Ang ngalan sa iyang inahan mao si Shelomit, nga anak ni Debri nga gikan sa tribo ni Dan.) Nakig-away kining tawhana sa usa ka Israelinhon didto sa kampo, ug gipasipalahan niya ang ngalan sa Ginoo. Busa gidala nila siya kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ug gibilanggo nila siya hangtod nga ilang mahibaloan kon unsa ang kabubut-on sa Ginoo alang sa maong tawo. ");
INSERT INTO cebocb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Unya, miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Dad-a didto sa gawas sa kampo kadtong tawo nga nagpasipala kanako. Ang tanan nga nakadungog sa iyang pagpasipala mopatong sa ilang kamot sa iyang ulo, ug pagkahuman batohon siya sa tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","16","Ug sultihi ang mga Israelinhon nga si bisan kinsa kanila ug sa mga langyaw nga nagpuyo uban kanila nga mopasipala kanako o sa akong ngalan adunay tulubagon. Kinahanglan nga batohon siya sa tibuok katilingban hangtod nga mamatay gayod. ");
INSERT INTO cebocb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Si bisan kinsa nga makapatay ug tawo, kinahanglan nga patyon usab. ");
INSERT INTO cebocb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kon ang usa ka tawo makapatay sa mananap sa uban kinahanglan nga ilisan niya kini ug laing buhi nga mananap. ");
INSERT INTO cebocb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","20","Kon nakahimo ug daotan ang usa ka tawo ngadto sa iyang isigka-tawo, kinahanglan nga himuon usab kaniya ang sama sa iyang gihimo. Kon gibali niya ang bukog sa uban, balian usab siya sa iyang bukog. Kon gilugit niya ang mata sa uban, lugitan usab siya sa iyang mata. Ug kon gipangagan niya ang uban, pangagan usab siya. ");
INSERT INTO cebocb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Si bisan kinsa nga makapatay ug mananap kinahanglan nga ilisan niya kini, apan ang nakapatay ug tawo kinahanglan nga patyon usab. ");
INSERT INTO cebocb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kini nga balaod alang kaninyong tanan, mga Israelinhon man o mga langyaw. Ako mao ang Ginoo nga inyong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Human kini masulti ni Moises ngadto sa mga Israelinhon, gidala nila didto sa gawas sa kampo ang tawo nga nagpasipala sa Dios. Ug gibato nila siya sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Sa dihang didto si Moises sa Bukid sa Sinai, miingon ang Ginoo kaniya, ");
INSERT INTO cebocb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Sultihi ang mga Israelinhon: ‘Kon moabot na kamo sa yuta nga ihatag ko kaninyo, ayaw ninyo tamni ang yuta sa matag ikapito nga tuig aron mapasidunggan ninyo ako. ");
INSERT INTO cebocb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sulod sa unom ka tuig makatanom kamo ug makaani. Ug sulod usab sa maong mga tuig makapamul-ong kamo sa inyong mga ubas ug makapamupo sa mga bunga niini. ");
INSERT INTO cebocb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Apan sa ikapito nga tuig kinahanglan nga papahulayon ninyo ang yuta. Ayaw ninyo tamni ang inyong mga uma ug ayaw usab ninyo pul-ongi ang inyong mga ubas. ");
INSERT INTO cebocb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ayaw ninyo aniha ang mga tanom nga nanurok human sa inyong pag-ani, ug ayaw usab ninyo pupua ang mga bunga sa inyong mga ubas nga wala pul-ongi. Kinahanglan makapahulay sa hingpit ang yuta sulod sa usa ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Apan niana nga tuig, ang bisan unsa nga inyong maani niana nga yuta mahimo ninyong kan-on. Alang kini sa inyong kaugalingon, sa inyong mga sulugoon, sa inyong mga trabahante, sa mga langyaw nga nagpuyo uban kaninyo, ");
INSERT INTO cebocb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","sa inyong mga kahayopan, ug sa mga ihalas nga mananap diha sa inyong yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Dugang pa niini, pag-ihap kamo ug pito ka tuig nga igpapahulay, pito ka pilo sa matag pito ka tuig ug 49 ka tuig tanan. ");
INSERT INTO cebocb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Sa ikanapulo nga adlaw sa ikapitong bulan nga mao ang Adlaw sa Pagluwas sa mga Tawo gikan sa Ilang mga Sala, patingoga ninyo ang mga budyong sa tibuok nga dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Isipa ninyo nga pinasahi ang ika-50 nga tuig, kay panahon kini sa pag-uli ngadto sa tag-iya ang kanhing mga butang nga gibaligya, ug paghatag ug kagawasan sa mga ulipon aron makabalik na sila sa ilang pamilya. ");
INSERT INTO cebocb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","12","Niining Tuig sa Paghatag ug Kagawasan ug Pag-uli, ayaw kamo pagtanom, ug ayaw usab kamo pag-ani o pamupo aron pagtigom sa mga bunga sa mga tanom nga nanurok lang, apan panguha lang kamo sa inyong kaonon. Balaan kining tuiga alang kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Niining tuiga, ang tanang kabtangan nga gibaligya kaninyo ibalik ninyo ngadto sa nagbaligya niini. ");
INSERT INTO cebocb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Busa kon magbaligya kamo o magpalit ug yuta sa inyong katagilungsod, ayaw kamo paglinimbongay. ");
INSERT INTO cebocb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kinahanglan nga ang presyo sa yuta ibasi sa nahibiling mga tuig nga makaani pa gikan niini sa dili pa moabot ang sunod nga Tuig sa Paghatag ug Kagawasan ug Pag-uli. ");
INSERT INTO cebocb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kon daghan pa ang katuigan nga nahibilin ayha ang Tuig sa Paghatag ug Kagawasan ug Pag-uli, patas-i ninyo ang presyo sa yuta, apan kon gamay na lang, pamub-i ninyo ang presyo niini. Kay ang tinuod, ang gipalit dili ang yuta mismo kondili ang gidaghanon sa maani gikan sa maong yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ayaw kamo paglinimbongay kondili tahora ninyo ako, ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","19","“ ‘Tumana gayod ninyo ang akong mga patakaran ug mga sugo aron magkinabuhi kamo nga malinawon diha sa yuta nga inyong puy-an ug dili kamo kawad-an ug pagkaon tungod sa kaabunda sa mga ani gikan sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ayaw kamo kabalaka kon unsa ang inyong kaonon sa ikapito nga tuig nga dili kamo makatanom o makaani. ");
INSERT INTO cebocb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Kay panalanginan ko ang inyong yuta sa ikaunom nga tuig aron mag-ani kini ug daghan nga paigo sa tulo ka tuig. ");
INSERT INTO cebocb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Busa samtang nagtanom pa kamo sa ikawalo nga tuig, ang inyong kaonon mao pa ang inyong giani sa ikaunom nga tuig, ug daghan pa ang inyong pagkaon hangtod sa ting-ani sa ikasiyam nga tuig. ");
INSERT INTO cebocb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Ayaw ninyo ibaligya ang yuta sa paagi nga dili na kini mabawi pa, kay kining yutaa ako; gipapuy-an ug gipasaopan ko lang kini kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Busa tugoti ninyo nga mabawi pa sa tag-iya ang iyang yuta gikan kaninyo. Himuon ninyo kini sa tanan nga yuta nga inyong gipalit. ");
INSERT INTO cebocb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Kon napobre ang inyong isigka-Israelinhon, ug tungod niini nabaligya niya ang iyang yuta, ang iyang labing duol nga paryente mao ang mopalit ug balik niini. ");
INSERT INTO cebocb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Apan kon wala siyay paryente nga mopalit ug balik niini alang kaniya, mahimo gihapon niya kining mabawi kon makaya na niya kining paliton ug balik. ");
INSERT INTO cebocb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Kon mahitabo kini, bayran niya ang nakapalit sa iyang yuta sa presyo basi sa maani gikan sa yuta hangtod sa pag-abot sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. Unya mahimo na niyang mabawi ang iyang yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Apan kon dili paigo ang iyang ibayad, magpabilin kini sa nagpalit hangtod sa pag-abot sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. Nianang tuiga, mabawi na niya ang iyang yuta nga walay bayad. ");
INSERT INTO cebocb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Kon ang usa ka tawo mobaligya sa iyang balay nga anaa sa lungsod nga gilibotan ug paril, mapalit pa niya kini ug balik sulod sa usa ka tuig gikan sa iyang pagbaligya. ");
INSERT INTO cebocb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Apan kon dili niya kini mapalit ug balik sulod sa usa ka tuig, ang maong balay mahimong iya na sa nakapalit ug sa iyang mga kaliwat hangtod sa kahangtoran. Dili na kini mabawi sa tag-iya sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. ");
INSERT INTO cebocb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Apan ang mga balay nga anaa sa mga baryo nga walay paril sama sa mga uma, mahimong mapalit ug balik ug mabawi sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. ");
INSERT INTO cebocb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Mahimong mapalit ug balik bisan kanus-a sa mga kaliwat ni Levi ang ilang mga balay nga anaa sa mga lungsod nga ilang gipanag-iyahan. ");
INSERT INTO cebocb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kon dili nila kini mapalit ug balik, iuli kini kanila sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. Kay ang mga balay diha sa ilang mga lungsod ilang bahin gikan sa ilang isigka-Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Apan ang mga sabsabanan nga anaa dapit sa ilang mga lungsod kinahanglan nga dili ibaligya, kay ila kanang kabtangan hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Kon napobre ang inyong isigka-Israelinhon ug dili na siya makahimo sa pagsuporta sa iyang kaugalingon, tabangi ninyo siya sama sa pagtabang ninyo sa mga langyaw nga permanente nga nagpuyo uban kaninyo o temporaryo lang, aron makapadayon siya pagpuyo uban kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Pahulama ninyo siyag kuwarta ug ayaw patuboi, ug baligyai ninyo siyag pagkaon ug ayaw paginansiyahi, aron makapadayon siya pagpuyo uban kaninyo. Himoa ninyo kana sa pagpaila nga nagtahod kamo kanako nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ako mao ang Ginoo nga inyong Dios nga nagpagawas kaninyo gikan sa Ehipto aron ihatag kaninyo ang yuta sa Canaan ug aron ako mahimong inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Kon napobre ang inyong isigka-Israelinhon, ug tungod niini nabaligya niya kaninyo ang iyang kaugalingon isip ulipon, ayaw ninyo siya patrabahoa sama sa usa ka ulipon. ");
INSERT INTO cebocb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Isipa ninyo siya nga usa ka sinuholan nga trabahante o usa ka bisita nga nagpuyo uban kaninyo. Magtrabaho siya diha sa inyo hangtod sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. ");
INSERT INTO cebocb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Nianang tuiga, gawasnon na siya ug ang iyang mga anak, ug makabalik na sila sa ilang mga kaparyentehan ug maangkon pag-usab ang mga kabtangan sa ilang mga katigulangan. ");
INSERT INTO cebocb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Mga ulipon ko kamo, kamong mga Israelinhon nga gipagawas ko gikan sa Ehipto. Busa ayaw ninyo ibaligya ang inyong kaugalingon aron mahimong ulipon. ");
INSERT INTO cebocb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ayaw ninyo daog-daoga ang inyong isigka-Israelinhon nga nagpaulipon kaninyo. Himoa ninyo kana sa pagpaila nga nagtahod kamo sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Kon gusto ninyo nga aduna kamoy mga ulipon, pagpalit kamo sa mga nasod sa inyong palibot. ");
INSERT INTO cebocb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mahimo usab kamong mopalit sa mga langyaw nga nagpuyo uban kaninyo o sa mga sakop sa ilang panimalay nga natawo diha sa inyong dapit. Ang mga ulipon nga napalit ninyo gikan kanila mahimo na ninyong kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mahimo ninyo silang kabilin sa inyong mga anak ug mag-alagad sila kanila sa tibuok nilang kinabuhi. Apan ayaw gayod ninyo daog-daoga ang inyong isigka-Israelinhon nga nahimo ninyong ulipon. ");
INSERT INTO cebocb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Kon ang usa ka kabos nga Israelinhon nagbaligya sa iyang kaugalingon isip ulipon ngadto sa usa ka adunahan nga langyaw nga nagpuyo uban kaninyo o sa paryente niini, ");
INSERT INTO cebocb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","mamahimo gihapon silang lukaton bisan kung napalit na sila. Mahimo siyang lukaton sa iyang igsoon, ");
INSERT INTO cebocb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","uyoan, ig-agaw, o si bisan kinsa nga duol niyang paryente. Mahimo usab nga siya mismo ang molukat sa iyang kaugalingon kon makakaya na siya. ");
INSERT INTO cebocb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","52","Ang iyang himuon, sumahon niya ug sa nagpalit kaniya kon pila ka tuig ang iyang pag-alagad isip ulipon ug kon pila ka tuig ang nahibilin ayha moabot ang Tuig sa Paghatag ug Kagawasan ug Pag-uli. Basi sa gidugayon sa nahibilin nga tuig, sumahon kon pila ang kantidad kon bayran siya, sama sa sinuholan nga trabahante. Ang sumada sa sweldo mao ang bayad alang sa iyang kagawasan. ");
INSERT INTO cebocb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kinahanglan isipon siya sa langyaw nga nagpalit kaniya nga usa ka tinuig nga sinuholan. Ayaw ninyo tugoti nga daog-daogon siya sa langyaw. ");
INSERT INTO cebocb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Kon dili siya malukat sa ingon niini nga mga paagi, mahimo gihapon siyang gawasnon ug ang iyang mga anak sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. ");
INSERT INTO cebocb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Busa walay magpabilin kaninyo nga mga ulipon hangtod sa kahangtoran, kay mga ulipon ko kamo, kamo nga gipagawas ko gikan sa Ehipto. Ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Ayaw kamo paghimog mga dios-dios sama sa mga rebulto, bato nga handomanan, o kinulit gipatindog nga dagkong bato aron inyong simbahon, kay ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Tumana ninyo ang akong mga gipahimo kaninyo sa Adlaw nga Igpapahulay ug tahora ninyo ang akong balaang puloy-anan. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Kon tumanon ninyo ang akong mga patakaran ug mga sugo, ");
INSERT INTO cebocb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","padad-an ko kamo ug ulan sa husto nga panahon aron nga ang yuta mohatag ug abot ug ang mga kahoy makapamunga. ");
INSERT INTO cebocb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ang inyong paggiok sa mga uhay moabot pa hangtod sa tingpamupo sa mga ubas, ug ang inyong pagpamupo sa ubas moabot pa hangtod sa inyong pagpugas. Busa makapatuyang kamo sa inyong pagkaon ug magkinabuhi kamo nga malinawon diha sa inyong dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Palungtaron ko ang kalinaw sa inyong dapit, busa makatulog kamo nga walay gikahadlokan. Abugon ko ang mabangis nga mga mananap, ug walay mga kaaway nga makasulong kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kamo ang mosulong sa inyong mga kaaway ug pamatyon ninyo sila. ");
INSERT INTO cebocb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ang lima kaninyo makapildi ug usa ka gatos, ug ang usa ka gatos kaninyo makapildi ug napulo ka libo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Atimanon ko kamo ug hatagan ug daghang mga kaliwat aron matuman ko ang akong kasabotan kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Dili ninyo mahurot ug kaon ang inyong nangaging abot. Panghabwaon na lang ninyo kini sa inyong gibutangan ug ilisan sa bag-ong abot. ");
INSERT INTO cebocb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Magpuyo ako uban kaninyo ug dili ko kamo isalikway. ");
INSERT INTO cebocb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mag-uban ako kaninyo ug ako ang mahimo ninyong Dios ug kamo padayon nga mahimong akong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ako mao ang Ginoo nga inyong Dios nga nagpagawas kaninyo gikan sa Ehipto aron nga dili na kamo mahimong mga ulipon sa mga Ehiptohanon. Gihatagan ko na kamo ug kagawasan, busa wala na kamoy angayng ikaulaw. ");
INSERT INTO cebocb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","15","“ ‘Apan kon dili gani kamo mamati kanako ug isalikway ninyo ang tanan kong mga sugo, mga patakaran, mga lagda, ug lapason ninyo ang akong kasabotan kaninyo, ");
INSERT INTO cebocb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","mao kini ang akong himuon kaninyo: Mataranta kamo tungod kay padad-an ko kamo ug makamatay nga sakit ug hilanat nga makadaot sa inyong mga mata ug lawas. Magtanom kamo, apan dili ninyo kini mapuslan kay sulongon kamo sa inyong mga kaaway ug kaonon nila ang inyong mga abot. ");
INSERT INTO cebocb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kapungtan ko kamo aron nga mapildi kamo sa inyong mga kaaway ug sila na ang modumala kaninyo. Tungod sa inyong kataranta moikyas kamo bisan ug walay naggukod kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Ug kon dili gihapon kamo mamati kanako, silotan ko kamo sa makapito ka pilo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Sumpoon ko ang gipasigarbo ninyo nga gahom. Dili ako magpadala ug ulan, busa mobantok pag-ayo ang inyong mga yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mahimong walay kapuslanan ang inyong mga paghago, kay ang inyong mga yuta dili mohatag ug abot ug ang inyong mga kahoy dili mamunga. ");
INSERT INTO cebocb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Kon magpadayon pa gihapon kamo sa pagsupak kanako ug dili kamo mamati kanako, dugangan ko pa gayod ug pito ka pilo ang inyong silot. ");
INSERT INTO cebocb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Padad-an ko kamo ug mabangis nga mga mananap ug pamatyon nila ang inyong mga kabataan ug mga binuhing kahayopan, ug tungod niini gamay na lang ang mahibilin kaninyo ug maawaaw ang inyong mga kadalanan. ");
INSERT INTO cebocb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Kon dili pa gihapon kamo mamati kanako ug padayon hinuon kamo sa pagsupak kanako, ");
INSERT INTO cebocb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ako gayod mismo ang mokontra kaninyo ug silotan ko kamo sa makapito ka pilo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ipasulong ko kamo sa inyong mga kaaway agig pagsilot kaninyo tungod sa inyong paglapas sa akong kasabotan. Bisan motago pa kamo sa inyong mga lungsod padad-an ko gihapon kamo ug mga katalagman, ug mapugos kamo nga magpailalom sa inyong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kulangon ang inyong pagkaon, busa usa lang ka pugon ang gamiton sa napulo ka babaye sa pagluto ug pan, ug bahin-bahinon pa nila kini alang kaninyo. Tinuod nga makakaon kamo apan dili kamo mabusog. ");
INSERT INTO cebocb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Kon dili pa gihapon kamo mamati kanako ug padayon pa hinuon kamo sa pagsupak kanako, ");
INSERT INTO cebocb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","sa akong kasuko kontrahon ko kamo ug silotan sa makapito ka pilo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mapugos kamo sa pagkaon sa inyong kaugalingong mga anak tungod sa kagutom. ");
INSERT INTO cebocb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Gub-on ko ang inyong mga simbahanan diha sa habog nga mga dapit, lakip ang mga halaran nga sunoganan sa insenso. Ug ilabay ko ang inyong mga patayng lawas ibabaw sa inyong mga patayng dios-dios, ug isalikway ko kamo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Gub-on ko ang inyong mga lungsod ug mga dapit nga simbahanan, ug dili ko ikalipay ang kahumot sa inyong mga halad. ");
INSERT INTO cebocb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Gub-on ko ang inyong dapit ug matingala na lang ang inyong mga kaaway nga mosakop sa maong dapit. ");
INSERT INTO cebocb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Padad-an ko kamo ug gira nga moguba sa inyong dapit apil na ang mga lungsod niini. Ug ipatibulaag ko kamo ngadto sa laing mga nasod. ");
INSERT INTO cebocb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Samtang mga bihag kamo sa dapit sa inyong mga kaaway ug guba ang inyong dapit, makapahulay ang inyong yuta. Kay sa dihang nagpuyo pa kamo sa inyong yuta wala gayod ninyo kini papahulaya bisan sa tuig nga tingpahulay sa yuta. Apan karon makapahulay na gayod kini samtang guba pa. ");
INSERT INTO cebocb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","“ ‘Kamo nga mga nahibilin sa gira, nga gidala sa inyong mga kaaway ngadto sa ilang mga dapit, patarantahon ko gayod kamo. Bisan sa kinasikas lang sa mga dahon nga huypon sa hangin, mangikyas na kamo nga daw adunay naggukod sa pagpatay kaninyo. Magbinanggaanay kamo ug mangatumba, busa dili gayod kamo makasukol sa inyong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mangamatay kamo didto sa dapit sa inyong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ug ang mahibilin kaninyo inanay nga mangamatay tungod sa inyong mga sala ug sa mga sala sa inyong mga katigulangan. ");
INSERT INTO cebocb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“ ‘Tungod sa inyong pagluib ug pagsupak kanako, kontrahon ko kamo ug ipabihag sa lugar sa inyong mga kaaway. Apan kon maghinulsol kamo sa inyong mga sala ug sa sala sa inyong mga katigulangan ug undangon na ninyo ang pagpagahi sa inyong ulo, ug dawaton ninyo ang silot tungod sa inyong mga sala, ");
INSERT INTO cebocb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","tumanon ko ang akong kasabotan sa inyong mga katigulangan nga si Abraham, Isaac, ug Jacob ug ibalik ko kamo sa inyong yuta. ");
INSERT INTO cebocb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Apan kinahanglan nga papahawaon ko una kamo gikan sa inyong yuta isip bayad ninyo sa inyong mga sala, tungod sa inyong pagsalikway sa akong mga lagda ug mga patakaran. Ug makapahulay ang yuta samtang wala kamo. ");
INSERT INTO cebocb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Apan bisan kon silotan ko kamo, dili ko kamo isalikway sa dapit sa inyong mga kaaway; dili ko kamo laglagon sa hingpit. Ug dili mahimo nga walaon ko ang akong kasabotan kaninyo, tungod kay ako mao ang Ginoo nga inyong Dios. ");
INSERT INTO cebocb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Tumanon ko diha kaninyo ang akong kasabotan sa inyong mga katigulangan nga gipagawas ko gikan sa Ehipto sa pagpakita sa akong gahom sa mga nasod aron mahimong ilang Dios. Ako mao ang Ginoo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Mao kadto ang nagkalain-lain nga mga patakaran, mga lagda, ug mga kasugoan alang sa mga Israelinhon nga gihatag sa Ginoo didto sa Bukid sa Sinai pinaagi kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Gisugo sa Ginoo si Moises, ");
INSERT INTO cebocb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Isulti kini ngadto sa mga Israelinhon: ‘Kon ang usa ka tawo gihalad ngadto sa Ginoo isip pagtuman sa usa ka panaad, kanang tawhana malibre niana nga panaad pinaagi sa pagbayad ");
INSERT INTO cebocb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","mao kini ang sukdanan sa bili nga gamiton. Ang usa ka lalaki nga nagpanuigon ug 20 ka tuig hangtod 60 ka tuig, 50 kabuok nga salapi. ");
INSERT INTO cebocb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ang babaye sa samang pangidaron, 30 kabuok salapi. ");
INSERT INTO cebocb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ang lalaki nga nagpanuigon ug 5 ka tuig hangtod 20 ka tuig, 20 kabuok nga salapi. Ang babaye sa samang pangidaron, 10 kabuok nga salapi. ");
INSERT INTO cebocb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ang batang lalaki nga nagpangidaron ug 5 ka bulan hangtod 5 ka tuig, 5 kabuok nga salapi. Ang babaye sa samang pangidaron, 3 kabuok nga salapi. ");
INSERT INTO cebocb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ang lalaki nga nagpanuigon ug sobra 60 ka tuig pataas, 15 kabuok salapi ug ang babaye sa sama usab nga pangidaron, 10 kabuok salapi. ");
INSERT INTO cebocb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kon kabos ang nakapanaad ug dili siya makahimo pagbayad sa mao nga kantidad, dad-on niya ngadto sa pari ang tawo nga gipanaad niya nga ihalad sa Ginoo, ug ang pari mao ang mobungat sa presyo basi sa makaya nga ibayad sa tawo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Kon ang iyang gipanaad mananap nga mahimong ihalad sa Ginoo, kana nga mananap mahimong iya na sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kinahanglan nga dili na niya kini bayloan pa ug laing mananap, bisan pa kon mas maayo kini. Kon himuon niya kini, ang mananap nga iyang gipanaad ug ang mananap nga iyang ibaylo mahimong iya na sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kon ang iyang gipanaad giisip nga hugaw nga mananap, nga dili mahimong ihalad sa Ginoo, dad-on niya ang mananap ngadto sa pari. ");
INSERT INTO cebocb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Susihon kini sa pari kon maayo ba o dili, ug unya presyohan niya kini sa presyo nga dili na mausab pa. ");
INSERT INTO cebocb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kon bawion sa tag-iya ang mananap, kinahanglan nga bayran niya ang presyo sa mananap ug dugangan pa gayod niya ug 20 porsyento sa presyo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Kon gihalad sa tawo ang iyang balay ngadto sa Ginoo, susihon sa pari ang maong balay kon maayo pa ba kini o dili, ug unya presyohan niya kini ug presyo nga dili na mausab pa. ");
INSERT INTO cebocb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kon bawion sa tag-iya ang iyang balay, kinahanglan nga bayran niya ang presyo sa balay ug dugangan pa gayod niya ug 20 porsyento sa presyo niini. Ug ang balay ibalik kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Kon gihalad sa tawo ngadto sa Ginoo ang bahin sa iyang yuta nga napanunod niya gikan sa iyang katigulangan, presyohan kini sa pari sa presyo nga basi sa gidaghanon sa binhi nga mapugas niining yutaa: sa matag sako nga binhi, ang presyo 20 kabuok nga pilak. ");
INSERT INTO cebocb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kon ihalad niya ang iyang uma pagkahuman lang gayod sa Tuig sa Paghatag ug Kagawasan ug Pag-uli, magpabilin ang tukmang presyo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Apan kon dugay na nga milabay ang maong tuig una pa niya gihalad ang iyang uma, presyohan kini sa pari ug presyo nga mas mubo, basi sa gidaghanon sa katuigan nga nahibilin hangtod sa sunod na usab nga Tuig sa Paghatag ug Kagawasan ug Pag-uli. ");
INSERT INTO cebocb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kon bawion sa tag-iya ang iyang uma, kinahanglan nga bayran niya ang presyo sa uma ug dugangan pa gayod niya ug 20 porsyento sa presyo niini. Ug ibalik kaniya ang iyang uma. ");
INSERT INTO cebocb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Apan kon wala pa niya napalit ug balik ang iyang uma ug gibaligya kini sa lain, dili na gayod niya kini mabawi pa. ");
INSERT INTO cebocb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ug sa pag-abot sa Tuig sa Paghatag ug Kagawasan ug Pag-uli, iya na kini sa Ginoo ug dili na gayod kini mabawi; mahimo na kining kabtangan sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Kon gihalad sa tawo ang uma nga iyang gipalit sa Ginoo ug kini dili kabahin sa iyang napanunod, ");
INSERT INTO cebocb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","presyohan kini sa pari sa presyo basi sa gidaghanon sa katuigan nga nahibilin hangtod sa Tuig sa Paghatag ug Kagawasan ug Pag-uli. Kinahanglan nga paliton dayon kini ug balik sa tawo. Ang iyang ibayad sa pagpalit ug balik niini iya na sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Sa Tuig sa Paghatag ug Kagawasan ug Pag-uli ang mao nga uma iuli ngadto sa tag-iya nga nagbaligya niini. ");
INSERT INTO cebocb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ang tanang presyo niining mga gihalad ngadto sa Ginoo kinahanglan nga basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Ang unang anak sa mananap iya sa Ginoo, busa dili na kini ihalad kaniya. ");
INSERT INTO cebocb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kon kining mananapa giisip nga hugaw, mahimo kining paliton ug balik sa tag-iya. Bayran niya ang presyo sa mananap ug dugangan pa gayod niya ug 20 porsyento sa presyo niini. Apan kon dili niya paliton ug balik, ibaligya kini sa mga pari sumala sa gipresyo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Walay bisan unsa nga butang nga gihalad sa hingpit ngadto sa Ginoo ang mahimong ibaligya o paliton ug balik, tawo man o mananap o yuta nga napanunod. Iya na gayod kini sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Ang tawo nga gihalad sa hingpit ngadto sa Ginoo dili mahimong lukaton. Kinahanglan nga patyon gayod siya. ");
INSERT INTO cebocb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Ang ikanapulo nga bahin sa tanang mga abot iya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kon paliton ug balik sa tawo ang ikapulo sa iyang abot, kinahanglan nga bayran niya ang presyo niini ug dugangan pa gayod niya ug 20 porsyento sa presyo niini. ");
INSERT INTO cebocb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kon mag-ihap kamo sa inyong mga baka, karnero, o kanding, ang ikapulo sa matag napulo nga inyong naihap ihatag ninyo sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ug kinahanglan nga dili ninyo kini pilion o ilisan. Kon ilisan ninyo kini, ang maong mananap ug ang mananap nga giilis ninyo mahimong iya na sa Ginoo ug dili na mahimong paliton ug balik.’ ” ");
INSERT INTO cebocb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Mao kini ang mga sugo nga gihatag sa Ginoo kang Moises didto sa Bukid sa Sinai alang sa mga Israelinhon.");
INSERT INTO cebocb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Sa unang adlaw, sa ikaduhang bulan, sa ikaduhang tuig human mibiya ang mga Israelinhon gikan sa Ehipto, nakigsulti ang Ginoo kang Moises didto sa Tolda nga Tagboanan sa kamingawan sa Sinai. Miingon siya, ");
INSERT INTO cebocb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Esensus ninyo ang tibuok katilingban sa Israel sumala sa ilang mga tribo ug pamilya. Ilista ang mga ngalan sa tanang mga lalaki ");
INSERT INTO cebocb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira. Kamo ni Aaron ang mangunay sa pag-ihap sa matag tribo. ");
INSERT INTO cebocb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Motabang kaninyo ang matag pangulo sa matag tribo. ");
INSERT INTO cebocb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Mao kini ang mga pangulo sa matag tribo nga motabang kaninyo: “gikan kang Ruben si Elizur nga anak ni Shedeur; ");
INSERT INTO cebocb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","gikan kang Simeon si Shelumiel nga anak ni Zurishadai; ");
INSERT INTO cebocb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","gikan kang Juda si Nashon nga anak ni Aminadab; ");
INSERT INTO cebocb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","gikan kang Isacar si Netanel nga anak ni Zuar; ");
INSERT INTO cebocb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","gikan kang Zabulon si Eliab nga anak ni Helon; ");
INSERT INTO cebocb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","gikan kang Efraim nga anak ni Jose si Elishama nga anak ni Amihud; gikan kang Manases nga anak ni Jose si Gamaliel nga anak ni Pedazur; ");
INSERT INTO cebocb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","gikan kang Benjamin si Abidan nga anak ni Gideoni; ");
INSERT INTO cebocb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","gikan kang Dan si Ahiezer nga anak ni Amishadai; ");
INSERT INTO cebocb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","gikan kang Aser si Pagiel nga anak ni Ocran; ");
INSERT INTO cebocb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","gikan kang Gad si Eliasaf nga anak ni Deuel; ");
INSERT INTO cebocb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","gikan kang Neftali si Ahira nga anak ni Enan.” ");
INSERT INTO cebocb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Mao kini sila ang mga pangulo sa matag tribo nga napili gikan sa katilingban sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Gipatigom ni Moises ug ni Aaron kauban niining mga pangulo ang tibuok katilingban niana mismong adlawa. Gipanglista nila ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, sumala sa ilang mga tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Gihimo ni Moises kining pagpanglista didto sa kamingawan sa Sinai, sumala sa gisugo sa Ginoo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Gikan sa mga kaliwat ni Ruben, ang kamagulangang anak ni Jacob. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ang gidaghanon gikan sa tribo ni Ruben kay 46,500. ");
INSERT INTO cebocb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Gikan sa mga kaliwat ni Simeon. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ang gidaghanon gikan sa tribo ni Simeon kay 59,300. ");
INSERT INTO cebocb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gikan sa mga kaliwat ni Gad. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ang gidaghanon gikan sa tribo ni Gad kay 45,650. ");
INSERT INTO cebocb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Gikan sa mga kaliwat ni Judah. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ang gidaghanon gikan sa tribo ni Judah kay 74,600. ");
INSERT INTO cebocb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Gikan sa mga kaliwat ni Isacar. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ang gidaghanon gikan sa tribo ni Isacar kay 54,400. ");
INSERT INTO cebocb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Gikan sa mga kaliwat ni Zabulon. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ang gidaghanon gikan sa tribo ni Zabulon kay 57,400. ");
INSERT INTO cebocb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Gikan mga kaliwat ni Efraim nga anak ni Jose. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ang gidaghanon gikan sa tribo ni Efraim kay 40,500. ");
INSERT INTO cebocb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Gikan sa mga kaliwat ni Manases nga anak ni Jose. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ang gidaghanon gikan sa tribo ni Manases kay 32,200. ");
INSERT INTO cebocb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Gikan sa mga kaliwat ni Benjamin. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ang gidaghanon gikan sa tribo ni Benjamin kay 35,400. ");
INSERT INTO cebocb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Gikan sa mga kaliwat ni Dan. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ang gidaghanon gikan sa tribo ni Dan kay 62,700. ");
INSERT INTO cebocb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Gikan sa mga kaliwat ni Aser. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ang gidaghanon gikan sa tribo ni Aser kay 41,500. ");
INSERT INTO cebocb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Gikan sa mga kaliwat ni Neftali. Ang tanang mga lalaki nga nag-edad ug 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira, nga nalista sumala sa tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ang gidaghanon gikan sa tribo ni Neftali kay 53,400. ");
INSERT INTO cebocb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Mao kini ang gidaghanon sa mga lalaki nga naihap ni Moises ug ni Aaron ug sa 12 ka mga pangulo sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ang kada usa kanila nalista sumala sa ilang pamilya. Nag-edad silag 20 ka tuig pataas, nga adunay katakos sa pagpakig-gira. ");
INSERT INTO cebocb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Sa kinatibuk-an, mikabat ug 603,550 ang ilang gidaghanon. ");
INSERT INTO cebocb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Wala i-apil niini ang mga kaliwat ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kay miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ayaw i-apil ang tribo ni Levi sa pag-ihap uban sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ihatag kanila ang responsibilidad sa pag-atiman sa Tolda nga Pagsimbahan diin nahimutang ang Kasugoan ug ang tanang mga kagamitan niini. Sila ang modala sa Tolda ug sa tanang kagamitan niini. Kinahanglang atimanon nila ang Tolda ug magkampo sila libot niini. ");
INSERT INTO cebocb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kon ibalhin ang Tolda, sila ang mohipos niini ug mopatindog pagbalik. Si bisan kinsa nga dili kaliwat ni Levi nga moduol sa Tolda, pagapatyon. ");
INSERT INTO cebocb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Magkampo ang matag tribo sa Israel sa dapit nga gitagana kanila ug magbutang ug ilang bandera. ");
INSERT INTO cebocb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Apan ang mga kaliwat ni Levi kinahanglan magkampo libot sa Tolda diin nahimutang ang Kasugoan, aron dili ako masuko sa tibuok katilingban sa Israel. Ang mga kaliwat ni Levi mao ang responsable sa pag-atiman sa Tolda.” ");
INSERT INTO cebocb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Gihimo sa mga Israelinhon ang tanan sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Pakampoha ang matag tribo sa Israel ubos sa bandera sa ilang tagsa-tagsa ka tribo, nga mag-atubang sa Tolda nga Tagboanan.” ");
INSERT INTO cebocb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ang grupo magkampo dapit sa sidlakan: Ang dibisyon sa kampo ni Juda ilalom sa bandera sa ilang tribo. Gipangulohan ni Nashon nga anak ni Aminadab. ");
INSERT INTO cebocb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Adunay 74,600 ang gidaghanon sa ilang mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ang tribo ni Isacar magkampo sa tupad nila. Gipangulohan ni Netanel nga anak ni Zuar. ");
INSERT INTO cebocb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Adunay 54,400 ang ilang gidaghanon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ang tribo ni Zabulon magkampo sa tupad nila. Gipangulohan ni Eliab nga anak ni Helon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Adunay 57,400 ang sakop sa iyang dibisyon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Mikabat ug 186,400 ang kinatibuk-ang gidaghanon niining grupo nga gipangulohan ni Juda. Sila mao ang mag-una kon manglakaw ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ang grupo nga magkampo dapit sa habagatan: ang dibisyon sa kampo ni Ruben ilalom sa bandera sa ilang tribo. Gipangulohan ni Elizur nga anak ni Shedeur. ");
INSERT INTO cebocb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Adunay 46,500 ang gidaghanon sa iyang dibisyon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ang tribo ni Simeon magkampo sa tupad nila. Gipangulohan ni Shelumiel nga anak ni Zurishadai. ");
INSERT INTO cebocb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ang iyang dibisyon adunay 59,300 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ang tribo ni Gad maoy sunod. Ang pangulo sa katawhan ni Gad si Eliasaf nga anak ni Deuel. ");
INSERT INTO cebocb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ang iyang dibisyon adunay 45,650 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Mikabat ug 151,450 ang kinatibuk-ang gidaghanon niining grupo nga gipangulohan ni Ruben. Sila mao ang ikaduha nga grupo kon manglakaw ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Unya, mosunod ang tribo ni Levi nga magdala sa Tolda nga Tagboanan. Diha sila sa taliwala sa ubang mga grupo sa ilang paglakaw. Ang gitakda nga han-ay alang sa pagkampo sa mga tribo mao gihapon ang ilang sundon sa ilang pagbiya. Ang matag tribo kinahanglang diha gayod sa gitakda nga dapit alang kanila uban sa ilang mga bandera. ");
INSERT INTO cebocb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Sa kasadpan mao: ang mga dibisyon sa kampo ni Efraim ilalom sa bandera sa ilang tribo. Gipangulohan kini ni Elishama nga anak ni Amihud. ");
INSERT INTO cebocb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ang iyang dibisyon adunay 40,500 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ang tribo ni Manases sunod kanila. Gipangulohan ni Gamaliel nga anak ni Pedazur. ");
INSERT INTO cebocb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ang iyang dibisyon adunay 32,200 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ang tribo ni Benjamin maoy sunod. Gipangulohan ni Abidan nga anak ni Gideoni. ");
INSERT INTO cebocb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ang iyang dibisyon adunay 35,400 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Mikabat ug 108,000 ang kinatibuk-ang gidaghanon niining grupo nga gipangulohan ni Efraim. Sila mao ang nagsunod sa tribo ni Levi kon manglakaw ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ang magkampo dapit sa amihan mao ang: ang mga dibisyon sa kampo ni Dan ubos sa bandera sa ilang tribo. Gipangulohan kini ni Ahiezer nga anak ni Amishadai. ");
INSERT INTO cebocb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ang iyang dibisyon adunay 62,700 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ang tribo ni Aser ang sunod kanila. Gipangulohan ni Pagiel nga anak ni Ocran. ");
INSERT INTO cebocb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ang iyang dibisyon adunay 41,500 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ang tribo ni Neftali ang sunod kanila. Gipangulohan ni Ahira nga anak ni Enan. ");
INSERT INTO cebocb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ang iyang dibisyon adunay 53,400 ka mga sakop. ");
INSERT INTO cebocb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Mikabat ug 157,600 ang kinatibuk-ang gidaghanon niining grupo nga gipangulohan ni Dan. Sila ang kinaulahian kon manglakaw ang mga Israelinhon ubos sa ilang tagsa-tagsa ka bandera. ");
INSERT INTO cebocb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ang kinatibuk-ang gidaghanon sa mga Israelinhon nga nalista mikabat ug 603,550. ");
INSERT INTO cebocb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Apan walay labot sa pag-ihap ang mga kaliwat ni Levi, sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Busa gisunod sa mga Israelinhon ang tanang gisugo sa Ginoo kang Moises. Ang matag tribo nagkampo ug nanglakaw ubos sa ilang tagsa-tagsa ka bandera sumala sa ilang tagsa-tagsa ka tribo ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Mao kini ang sugilanon mahitungod sa mga kaliwat ni Aaron ug ni Moises sa panahon nga nakigsulti ang Ginoo kang Moises didto sa Bukid sa Sinai. ");
INSERT INTO cebocb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","3","Ang mga anak ni Aaron mao sila si Nadab (ang kamagulangan), Abihu, Eleazar, ug Itamar. Gidihogan ug giordinahan sila nga mag-alagad ingon nga mga pari. ");
INSERT INTO cebocb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Apan si Nadab ug si Abihu namatay diha sa presensya sa Ginoo sa dihang migamit sila ug kalayo nga sukwahi sa ginagamit sa paghalad ngadto sa Ginoo didto sa kamingawan sa Sinai. Namatay sila nga walay mga anak, busa si Eleazar lang ug si Itamar ang nag-alagad ingon nga mga pari sa panahon ni Aaron nga ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ipatawag ang tribo ni Levi ug dad-a sila kang Aaron nga pari aron sa pagtabang kaniya. ");
INSERT INTO cebocb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Mag-alagad sila kang Aaron ug sa katawhan sa Israel pinaagi sa pag-atiman sa mga buluhaton sa Tolda nga Pagsimbahan, nga gitawag usab ug Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Sila usab ang mag-atiman sa tanang kagamitan sa Tolda, ug mag-alagad diha sa Tolda alang sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Itugyan ngadto kang Aaron ug sa iyang mga anak ang mga kaliwat ni Levi ingon nga ilang mga katabang. ");
INSERT INTO cebocb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Itugyan kang Aaron ug sa iyang mga anak ang katungdanan sa pagkapari. Si bisan kinsa nga dili kaliwat ni Levi nga maghimo sa buluhaton sa pari diha sa Tolda nga Pagsimbahan, pagapatyon.” ");
INSERT INTO cebocb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Miingon pa gayod ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Gipili ko ang mga kaliwat ni Levi puli sa mga kamagulangan nga lalaki sa Israel. Ang matag kaliwat ni Levi akoa, ");
INSERT INTO cebocb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kay ang tanang kamagulangan nga lalaki sa Israel akoa. Sa dihang gipamatay ko ang tanang kamagulangan nga lalaki sa Ehipto, gilain ko na alang kanako ang tanang kamagulangan nga lalaki sa Israel, tawo man o mananap. Busa akoa sila. Ako mao ang Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Miingon ang Ginoo kang Moises didto sa kamingawan sa Sinai, ");
INSERT INTO cebocb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Ihapa ang mga kaliwat ni Levi nga nagpangidaron ug usa ka bulan pataas sumala sa ilang pamilya.” ");
INSERT INTO cebocb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Busa giihap sila ni Moises sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Mao kini ang mga anak ni Levi mao si Gershon, si Kohat, ug si Merari. ");
INSERT INTO cebocb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ang mga anak ni Gershon mao si Libni ug si Shimei. ");
INSERT INTO cebocb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ang mga anak ni Kohat mao sila si Amram, Izhar, Hebron, ug Uziel. ");
INSERT INTO cebocb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ang mga anak ni Merari mao si Mali ug si Mushi. ");
INSERT INTO cebocb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ang mga kaliwat ni Gershon mao ang mga pamilya nga naggikan kang Libni ug kang Shimei. ");
INSERT INTO cebocb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ang gidaghanon sa ilang mga lalaki nga nagpangidaron ug usa ka bulan pataas mikabat ug 7,500. ");
INSERT INTO cebocb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Magkampo sila sa likod sa Tolda nga Pagsimbahan, dapit sa kasadpan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ang ilang pangulo mao si Eliasaf nga anak ni Lael. ");
INSERT INTO cebocb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Sila ang gitugyanan sa pag-atiman sa mga kagamitan sa Tolda nga Pagsimbahan, nga gitawag usab ug Tolda nga Tagboanan: ang mga tabon, ang kurtina sa entrada sa Tolda, ");
INSERT INTO cebocb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ang mga kurtina sa hawanan libot sa Tolda ug sa halaran, lakip ang kurtina sa pultahan sa hawanan ug ang mga higot niini. Sila ang responsable sa tanang buluhaton nga adunay kalabotan niini nga mga kagamitan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ang mga kaliwat ni Kohat mao ang mga pamilya nga naggikan kanila ni Amram, Izhar, Hebron, ug Uziel. ");
INSERT INTO cebocb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ang gidaghanon sa ilang mga lalaki nga nagpangidaron ug usa ka bulan pataas mikabat ug 8,600. Gitugyan usab kanila ang pag-atiman sa mga kagamitan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Magkampo sila dapit sa habagatan sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ug ang ilang pangulo mao si Elizafan nga anak ni Uziel. ");
INSERT INTO cebocb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Sila ang gitugyanan sa pag-atiman sa Sudlanan sa Kasabotan, sa lamisa, sa butanganan sa suga, sa mga halaran, sa mga kagamitan nga ginagamit sa mga pari sa pag-alagad, ug sa kurtina. Sila ang responsable sa tanang buluhaton nga adunay kalabotan niini nga mga kagamitan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ang labawng pangulo sa mga kaliwat ni Levi mao si Eleazar nga anak sa pari nga si Aaron. Siya ang gipili nga modumala sa gipangtugyanan sa pag-atiman niining Balaang Dapit. ");
INSERT INTO cebocb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ang mga kaliwat ni Merari mao ang mga pamilya nga naggikan kanila ni Mali ug kang Mushi. ");
INSERT INTO cebocb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ang gidaghanon sa ilang mga lalaki nga nagpangidaron ug usa ka bulan pataas mikabat ug 6,200. ");
INSERT INTO cebocb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ang ilang pangulo mao si Zuriel nga anak ni Abihail. Magkampo sila dapit sa amihan sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Sila ang gitugyanan sa pag-atiman sa mga tabla nga bongbong sa Tolda, sa mga babag, sa mga haligi, ug sa mga sukaranan niini. Sila ang responsable sa tanang mga buluhaton nga adunay kalabotan niini nga mga kagamitan. ");
INSERT INTO cebocb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Sila usab ang gitugyanan sa pag-atiman sa mga haligi sa palibot sa hawanan ug sa mga sukaranan niini, sa mga ugsok, ug sa mga higot. ");
INSERT INTO cebocb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Si Moises ug si Aaron uban sa iyang mga anak maoy magkampo atubangan sa Tolda nga Pagsimbahan, nga gitawag usab ug Tolda nga Tagboanan, dapit sa sidlakan. Sila ang gitugyanan sa pagdumala sa mga buluhaton sa Tolda alang sa mga Israelinhon. Si bisan kinsa nga mohimo sa buluhaton sa pari diha sa balaang puloy-anan nga dili kaliwat ni Levi, pagapatyon. ");
INSERT INTO cebocb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ang gidaghanon sa mga lalaki nga kaliwat ni Levi nga nag-edad ug usa ka bulan pataas mikabat ug 22,000, sumala sa ilang kagikan ug pamilya. Si Moises ug si Aaron ang nag-ihap kanila, sumala sa gisugo sa Ginoo kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Miingon ang Ginoo kang Moises, “Ihapa ug ilista ang mga ngalan sa tanang kamagulangan nga lalaki sa mga Israelinhon nga nag-edad ug usa ka bulan pataas. ");
INSERT INTO cebocb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Igahin ang mga kaliwat ni Levi alang kanako puli sa tanang kamagulangan nga lalaki sa mga Israelinhon. Igahin usab alang kanako ang mga kahayopan sa mga kaliwat ni Levi puli sa tanang kamagulangan nga kahayopan sa mga Israelinhon. Ako mao ang Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","43","Busa giihap ni Moises ang tanang kamagulangan nga lalaki sa mga Israelinhon nga nagpanuigon ug usa ka bulan pataas, sumala sa gisugo sa Ginoo kaniya. Ang ilang gidaghanon mikabat ug 22,273. ");
INSERT INTO cebocb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Miingon pa gayod ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Igahin ang mga kaliwat ni Levi alang kanako puli sa tanang kamagulangan nga lalaki sa mga Israelinhon. Igahin usab alang kanako ang mga kahayopan sa mga kaliwat ni Levi puli sa kamagulangan nga mga kahayopan sa mga Israelinhon. Ang mga kaliwat ni Levi akoa. Ako mao ang Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Tungod kay misobra ug 273 ang gidaghanon sa mga kamagulangan nga lalaki sa mga Israelinhon kaysa sa mga kaliwat ni Levi, kinahanglan silang lukaton. ");
INSERT INTO cebocb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Kolektahi ang kada usa kanila ug lima nga pilak basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ihatag kang Aaron ug sa iyang mga anak nga lalaki ang pilak nga gilukat sa nanobra nga mga kamagulangan.” ");
INSERT INTO cebocb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Busa gikolekta ni Moises ang salapi nga gilukat sa mga kamagulangan sa mga Israelinhon nga misobra sa gidaghanon sa mga kaliwat ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ang iyang nakolekta 1,365 ka pilak, basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Gihatag niya kini kang Aaron ug sa mga anak nga lalaki niini sumala sa gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ihapa ninyo ang mga kaliwat ni Kohat nga sakop sa tribo ni Levi sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ihapa ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ang buluhaton sa mga kaliwat ni Kohat diha sa Tolda nga Tagboanan mao ang pag-atiman sa labing balaan nga mga butang. ");
INSERT INTO cebocb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Sa higayon nga mobiya na kamo sa inyong gikampohan, mosulod si Aaron ug ang iyang mga anak sa Tolda ug kuhaon nila ang kurtina sa sulod ug itabon kini sa Sudlanan sa Kasugoan. ");
INSERT INTO cebocb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Pagkahuman tabonan pa gayod nila kini ug maayong klasi sa panit ug panapton nga asul, ug dayon itaod nila ang mga pangdayong. ");
INSERT INTO cebocb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Tabonan usab nilag panapton nga asul ang lamisa nga butanganan sa pan nga ginahalad sa presensya sa Dios, ug ibutang nila didto ang mga plato, mga sudlanan sa insenso, mga yahong, mga tibod nga sudlanan sa mga halad nga ilimnon, ug ang pan nga anaa kanunay sa lamisa. ");
INSERT INTO cebocb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pagkahuman, tabonan nila kinig panapton nga pula, unya tabonan pa gayod nila kini ug maayong klasi sa panit, ug itaod dayon ang mga pangdayong. ");
INSERT INTO cebocb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ang lamparahan tabonan nila ug panapton nga asul, apil ang mga suga niini, ang mga kimpit, ang mga saloranan sa agiw, ug ang mga tibod nga sudlanan sa lana. ");
INSERT INTO cebocb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Puston nila kining tanan ug maayong klasi sa panit ug itaod sa pangdayong. ");
INSERT INTO cebocb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Tabonan usab nilag panapton nga asul ang halaran nga bulawan ug sapawan pa gayod kini ug maayong klasi sa panit, ug itaod dayon ang mga pangdayong. ");
INSERT INTO cebocb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Ang uban pang kagamitan nga ginagamit sa pag-alagad diha sa Balaang Dapit puston ug panapton nga asul ug maayong klasi sa panit ug itaod sa pangdayong. ");
INSERT INTO cebocb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Kinahanglan nga kuhaon nila ang abo gikan sa halaran, ug unya tabonan ang halaran ug panapton nga kolor ube. ");
INSERT INTO cebocb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Unya ibutang dayon nila diha sa halaran ang tanang kagamitan niini: ang mga butanganan sa baga, ang mga dagkong tinidor, ang mga pala, ug ang mga yahong. Tabonan kini nila ug maayong klasi sa panit, ug itaod nila ang mga pangdayong niini. ");
INSERT INTO cebocb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Human mataboni ni Aaron ug sa iyang mga anak nga lalaki ang Tolda nga Tagboanan ug ang tanang mga kagamitan niini, kuhaon ug dayongan kini sa mga kaliwat ni Kohat sa higayon nga mobiya na sila sa ilang gikampohan. Apan kinahanglang dili gayod nila tandogon kining balaan nga mga butang aron dili sila mamatay. Mao kadto ang mga kagamitan sa Tolda nga Tagboanan nga dad-on sa mga kaliwat ni Kohat. ");
INSERT INTO cebocb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Si Eleazar nga anak sa pari nga si Aaron mao ang responsable sa lana alang sa lamparahan, sa insenso, sa inadlaw-adlaw nga halad sa pagpasidungog kanako, ug sa lana nga pangdihog. Siya ang magdumala sa kinatibuk-an sa Tolda ug sa mga kagamitan niini.” ");
INSERT INTO cebocb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ayaw ninyo pasagdi nga mahanaw ang mga kaliwat ni Kohat gikan sa tribo ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Mao kini ang inyong himuon aron dili sila mangamatay kon moduol sila sa labing balaan nga mga butang: kinahanglan ubanan sila ni Aaron ug sa iyang mga anak nga lalaki inigsulod nila sa Tolda ug sultihan sila kon unsay angay nilang buhaton ug kon unsay ilang dad-on. ");
INSERT INTO cebocb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Kay kon dili ubanan, dili gayod sila mosulod aron sa pagtan-aw sa mga butang nga gigahin alang sa Ginoo bisan sa makadiyot lang, aron dili sila mangamatay.” ");
INSERT INTO cebocb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Ihapa usab ang mga kaliwat ni Gershon sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ihapa ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ang mga buluhaton sa mga kaliwat ni Gershon mao ang pagdala sa mga mosunod: ");
INSERT INTO cebocb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ang mga kurtina sa Tolda nga Pagsimbahan (nga gitawag usab ug Tolda nga Tagboanan), ang tanan nga pangtabon niini, ug ang lain pang tabon nga gisapaw niini nga maayong klasi sa panit, ang kurtina sa pultahan niini, ");
INSERT INTO cebocb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ang mga kurtina sa hawanan libot sa Tolda ug halaran, ang kurtina sa agianan sa hawanan, ang mga higot, ug ang tanang kagamitan nga ginagamit sa pag-alagad sa Tolda. Sila ang mohimo sa tanang buluhaton nga adunay kalabotan niini nga mga kagamitan. ");
INSERT INTO cebocb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Si Aaron ug ang iyang mga anak nga lalaki maoy modumala sa mga buluhaton sa mga kaliwat ni Gershon, mahitungod man kini sa pagpangarga o sa uban pa nilang mga buluhaton. ");
INSERT INTO cebocb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Mao kini ang mga buluhaton sa mga kaliwat ni Gershon diha sa Tolda nga Tagboanan. Ilalom sila sa pagdumala ni Itamar nga anak sa pari nga si Aaron. ");
INSERT INTO cebocb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Ihapa usab ang mga kaliwat ni Merari sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ihapa ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“Mao kini ang ilang buluhaton alang sa Tolda nga Tagboanan: sila ang modala sa mga tabla nga dingding sa Tolda, sa mga babag niini, sa mga haligi, ug sa mga sukaranan. ");
INSERT INTO cebocb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Sila usab ang modala sa mga haligi nga taoran sa mga kurtina sa hawanan libot sa Tolda. Ug sila usab ang modala sa mga sukaranan niini, sa mga ugsok, ug sa mga higot. Sila ang mohimo sa tanang buluhaton nga adunay kalabotan niini nga mga kagamitan. Kamo ni Aaron ang mosulti sa kada usa kanila kon unsay ilang dad-on. ");
INSERT INTO cebocb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Mao kini ang buluhaton sa mga kaliwat ni Merari alang sa Tolda nga Tagboanan. Ilalom sila sa pagdumala ni Itamar nga anak sa pari nga si Aaron.” ");
INSERT INTO cebocb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Giihap nila ni Moises, Aaron, ug sa mga pangulo sa katilingban sa Israel ang mga kaliwat ni Kohat sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad diha sa Tolda nga Tagboanan, ");
INSERT INTO cebocb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","giihap sumala sa ilang kagikan ug miabot sila ug 2,750. ");
INSERT INTO cebocb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Mao kini ang gidaghanon sa kagikan ni Kohat nga nag-alagad sa Tolda sa Tagboanan. Giihap sila ni Moises ug Aaron sumala sa sugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Giihap ang mga kaliwat ni Gershon sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad diha sa Tolda nga Tagboanan, ");
INSERT INTO cebocb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","giihap sumala sa ilang kagikan ug pamilya ug miabot sila ug 2,630. ");
INSERT INTO cebocb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Mao kini ang gidaghanon sa kagikan ni Gershon nga nag-alagad sa Tolda sa Tagboanan. Giihap sila ni Moises ug Aaron sumala sa sugo sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Giihap ang mga kaliwat ni Merari sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad diha sa Tolda nga Tagboanan, ");
INSERT INTO cebocb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","giihap sumala sa ilang kagikan ug miabot sila ug 3,200. ");
INSERT INTO cebocb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Mao kini ang gidaghanon sa kagikan ni Merari. Giihap sila ni Moises ug Aaron sumala sa sugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Busa giihap nila Moises, Aaron ug sa mga pangulo sa Israel ang mga kaliwat ni Levi sumala sa ilang kagikan ug pamilya. ");
INSERT INTO cebocb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ang tanang mga lalaki nga nagpangidaron ug 30 ngadto sa 50 ka tuig, nga makahimo sa pag-alagad diha sa Tolda nga Tagboanan, ");
INSERT INTO cebocb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","mikabat ug 8,580. ");
INSERT INTO cebocb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Busa sumala sa gisugo sa Ginoo kang Moises, giihap ang kada usa kanila ug gihatagan sa iyang buluhaton ug gisultihan kon unsa ang iyang tagsa-tagsa ka dad-onon. ");
INSERT INTO cebocb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Mandoi ang mga Israelinhon nga pagawason sa kampo si bisan kinsa nga adunay makatakod nga ngilngig nga sakit sa panit, o kadtong adunay naggawas sa iyang kinatawo, o kadtong nahimong hugaw tungod kay nakahikap ug patay. ");
INSERT INTO cebocb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Malalaki man o mababaye, pagawasa ninyo sila, aron dili nila mahugawan ang kampo diin ako nagpuyo uban kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Busa gipagawas sa mga Israelinhon kadtong mga tawhana gikan sa kampo sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Ingna ang mga Israelinhon nga kon ang usa ka lalaki o babaye nakalapas sa kabubut-on sa Ginoo pinaagi sa paghimo ug daotan ngadto sa iyang isigka-tawo, kana nga tawo nakasala. ");
INSERT INTO cebocb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Kinahanglan nga isulti niya ang iyang sala nga nahimo, ug ulian niya o bayran sa ensaktong kantidad ang tawo nga iyang nabuhatan ug daotan, ug dugangan niya kini ug 20 porsyento sa kantidad. ");
INSERT INTO cebocb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Apan kon ang nabuhatan ug daotan patay na ug walay duol nga paryente nga modawat niini nga bayad, ang bayad iya na sa Ginoo ug kinahanglan ihatag kini ngadto sa pari, uban sa karnero nga ihalad sa pari aron mahinloan sa sala ang maong tawo. ");
INSERT INTO cebocb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ang tanang balaan nga gasa nga ginadala sa mga Israelinhon ngadto sa pari iya na sa pari. ");
INSERT INTO cebocb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kon unsay gihatag ngadto sa pari iya na sa pari.” ");
INSERT INTO cebocb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Midugang pa ang Ginoo sa pag-ingon kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","13","“Isulti kini ngadto sa mga Israelinhon. “Kon ang usa ka bana adunay pagduda nga nanapaw ang iyang asawa, apan dili niya kini mapamatud-an tungod kay walay nakakita niini sa akto, ");
INSERT INTO cebocb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","15","kinahanglan dad-on siya sa iyang bana ngadto sa pari, bisan ug dili tinuod nga gihugawan niya ang iyang kaugalingon pinaagi sa pakighilawas sa laing lalaki. Ug kinahanglan nga magdala ang bana ug halad alang sa iyang asawa nga usa ka kilong harina nga barley. Kinahanglan dili niya kini butangan ug lana o insenso kay halad kini nga kalan-on nga gihalad sa pagsusi kon tinuod ba ang pagduda sa iyang bana. ");
INSERT INTO cebocb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Dad-on sa pari ang babaye sa akong presensya, ");
INSERT INTO cebocb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ug unya magbutang ang pari diha sa banga ug tubig, ug butangan niya kini ug abog nga gikan sa salog sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Pabarogon sa pari ang babaye sa akong presensya ug kalkagon niya ang buhok sa babaye ug ibutang sa kamot niini ang halad sa pagpasidungog sa pagsusi kon tinuod ba ang pagduda sa iyang bana. Unya kuptan sa pari ang banga nga adunay pait nga tubig nga nagdala ug mga tunglo. ");
INSERT INTO cebocb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Dayon papanumpaon niya ang babaye ug ingnan, ‘Kon wala mo hugawi ang imong kaugalingon pinaagi sa pagpakighilawas sa ubang lalaki samtang anaa ikaw sa poder sa imong bana dili ka madutlan sa mga tunglo nga ginadala niining pait nga tubig. ");
INSERT INTO cebocb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Apan kon gihugawan mo ang imong kaugalingon pinaagi sa pagpakighilawas sa lalaki nga dili mo bana.’ ");
INSERT INTO cebocb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Niining higayona, papanumpaon sa pari ang babaye nga nag-ingon, matinunglo ka ug mahimo kang daotang panig-ingnan sa mga tawo sa tunglo sa Ginoo ug dili ka na makaanak. ");
INSERT INTO cebocb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Hinaut nga kining tubig nga nagdala ug mga tunglo mosulod sa imong lawas aron dili ka na makaanak. “Motubag dayon ang babaye, ‘Hinaut pa nga mahitabo kini.’ ");
INSERT INTO cebocb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Pagkahuman, isulat sa pari kining mga tunglo sa usa ka sulatanan unya panason niya kini didto sa tubig nga pait. ");
INSERT INTO cebocb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","(Kon ipainom na sa babaye ang pait nga tubig nga nagdala ug mga tunglo, mahimong hinungdan kini sa iyang labihan nga pag-antos kon sad-an siya.) ");
INSERT INTO cebocb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“Unya kuhaon dayon sa pari gikan sa kamot sa babaye ang halad sa pagpasidungog nga gihalad sa pagsusi kon tinuod ba ang pagduda sa iyang bana, ug ibayaw kini sa pari sa presensya sa Ginoo ug dad-on ngadto sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Magkuha ang pari ug usa ka kumkom niining halad isip halad sa paghinumdom ug sunogon kini diha sa halaran. Pagkahuman ayha niya ipainom sa babaye ang tubig. ");
INSERT INTO cebocb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kon tinuod nga gihugawan niya ang iyang kaugalingon pinaagi sa iyang pagluib sa iyang bana, ang tubig nga nagdala ug tunglo nga iyang giinom magpaantos kaniya sa hilabihan gayod. Dili na siya makaanak ug mahimo siyang panig-ingnan sa pagkatinunglo taliwala sa mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Apan kon wala niya hugawi ang iyang kaugalingon, dili siya madutlan sa tunglo ug makaanak pa siya. ");
INSERT INTO cebocb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Mao kini ang kasugoan bahin sa bana nga nagduda sa iyang asawa. Kon gihugawan sa asawa ang iyang kaugalingon pinaagi sa pagluib sa iyang bana, ");
INSERT INTO cebocb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","o kon ang bana nagduda sa iyang asawa nga nanglaki kini, kinahanglang pabarogon sa pari ang maong asawa sa akong presensya ug buhaton diha kaniya kini nga kasugoan. ");
INSERT INTO cebocb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ang bana walay tulubagon, apan ang asawa adunay tulubagon kon nakasala siya, ug mag-antos siya sa iyang sala.” ");
INSERT INTO cebocb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Sultihi ang mga Israelinhon nga kon ang usa ka babaye o lalaki maghimo ug usa ka pinasahi nga panaad nga idedikar niya ang iyang kaugalingon sa pag-alagad kanako isip Nazareo, ");
INSERT INTO cebocb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kinahanglan dili siya moinom ug bino ug uban pang makahubog nga ilimnon. Dili usab siya mogamit ug suka nga gikan sa ubas ug suka nga gikan sa uban pang makahubog nga mga ilimnon. Dili usab siya moinom ug duga sa ubas, ni mokaon ug ubas o kaha pasas. ");
INSERT INTO cebocb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Samtang usa siya ka Nazareo, kinahanglang dili gayod siya mokaon sa bisan unsa nga naggikan sa ubas, bisan ang liso o kaha panit niini. ");
INSERT INTO cebocb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Dili usab niya paputlan ang iyang buhok samtang wala pa niya mahuman ang iyang panaad sa pag-alagad sa Ginoo. Kinahanglan nga ilain siya alang sa Ginoo hangtod nga mahuman niya ang iyang panaad. Busa pasagdan lang niya nga motaas ang iyang buhok. ");
INSERT INTO cebocb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“Ug samtang wala pa niya mahuman ang iyang panaad nga mag-alagad sa Ginoo, kinahanglang dili siya moduol ug patay, ");
INSERT INTO cebocb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","bisan iya pa kining amahan, inahan, o igsoon. Dili gayod niya hugawan ang iyang kaugalingon tungod lang kanila, kay ang iyang buhok simbolo sa iyang pagdedikar sa iyang kinabuhi ngadto sa Dios. ");
INSERT INTO cebocb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Busa sa tibuok panahon sa iyang pagdedikar sa iyang kinabuhi, gilain siya alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Kon adunay kalit nga mamatay sa iyang tapad, ug hinungdan kini nga nahugawan ang iyang buhok nga simbolo sa iyang pagdedikar sa Ginoo, kinahanglan magpa-upaw siya sa adlaw sa iyang pagpanghinlo, sa ikapito nga adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Dayon sa ikawalo nga adlaw, kinahanglan nga magdala siya ug duha ka salampati o tukmo ngadto sa pari didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ang usa sa langgam ihalad sa pari ingon nga halad sa paghinlo ug ang usa ihalad ingon nga halad nga sinunog. Niining paagiha mapasaylo siya sa sala nga iyang naangkon tungod sa minatay. Niana mismo nga adlaw, idedikar niya pag-usab ang iyang kaugalingon ug pataason niya pag-usab ang iyang buhok. ");
INSERT INTO cebocb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ang nahaunang mga adlaw sa iyang pag-alagad sa Ginoo dili na iphon nga bahin sa iyang pagtuman sa iyang panaad, kay nahugawan man siya tungod sa minatay. Kinahanglan nga idedikar niya pag-usab ang iyang kaugalingon ug magsugod pag-usab hangtod mahuman niya ang iyang panaad. Kinahanglan usab nga magdala siya ug usa ka laking karnero nga usa ka tuig ang edad isip halad nga bayad sa iyang sala. ");
INSERT INTO cebocb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Mao kini ang himuon kaniya kon mahuman na niya ang iyang panaad isip Nazareo: Kinahanglan nga dad-on siya didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Didto maghalad siya sa Ginoo niining mosunod nga mga mananap nga wala gayoy depekto: usa ka laking karnero nga nag-edad ug usa ka tuig ingon nga halad nga sinunog, usa ka bayeng karnero nga nag-edad usab ug usa ka tuig ingon nga halad sa paghinlo, ug usa ka hamtong nga laking karnero ingon nga halad alang sa maayong relasyon. ");
INSERT INTO cebocb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Dugang pa niini, maghalad usab siya ug mga halad sa pagpasidungog sa Ginoo, mga halad nga ilimnon, ug usa ka basket nga pan nga walay patubo nga hinimo gikan sa maayong klasi sa harina. Ang uban nga pan baga nga sinagolan ug mantika, ug ang uban nipis nga pinahiran ug mantika. ");
INSERT INTO cebocb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ang pari mao ang maghalad niini ngadto sa Ginoo. Ihalad niya ang halad sa paghinlo ug ang halad nga sinunog. ");
INSERT INTO cebocb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Unya ihalad usab niya ang hamtong nga laking karnero nga halad alang sa maayong relasyon ngadto sa Ginoo uban sa usa ka basket nga pan nga walay patubo. Unya ihalad usab niya ang mga halad sa pagpasidungog sa Ginoo ug ang mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Pagkahuman, magpa-upaw ang Nazareo didto sa pultahan sa Tolda nga Tagboanan. Unya kuhaon niya ang iyang buhok nga simbolo sa iyang pagdedikar sa iyang kaugalingon ngadto sa Ginoo ug ibutang sa kalayo nga gisunogan sa halad alang sa maayong relasyon. ");
INSERT INTO cebocb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Unya ibutang sa pari diha sa kamot sa Nazareo ang abagang bahin sa karnero nga gipabukalan ug ang nipis ug baga nga mga pan nga walay patubo nga gikan sa basket. ");
INSERT INTO cebocb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kuhaon dayon kini sa pari ug unya ibayaw ngadto sa presensya sa Ginoo isip halad nga binayaw. Balaan kini nga bahin sa halad, ug iya na kini sa pari, apil ang dughan ug paa sa karnero nga gibayaw usab sa Ginoo. Human niini mahimo nang moinom ug bino ang Nazareo. ");
INSERT INTO cebocb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Mao kini ang tulomanon alang sa usa ka tawo nga mosaad sa Ginoo nga mahimong Nazareo. Apan kon aduna pa siyay gidugang niini kinahanglan tumanon gayod niya kini.” ");
INSERT INTO cebocb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ingna si Aaron ug ang iyang mga anak nga lalaki nga mao kini ang ilang isulti kon ilang bendisyonan ang mga Israelinhon: ");
INSERT INTO cebocb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Hinaut nga panalanginan kamo sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Hinaut nga ipakita sa Ginoo ang iyang kaayo ug kaluoy kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Hinaut nga magpakamaayo kaninyo ang Ginoo ug hatagan kamo niya ug maayo nga kahimtang.’ ");
INSERT INTO cebocb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Niining paagiha mapadayag nila ngadto sa mga Israelinhon kon kinsa ako, ug panalanginan ko sila.” ");
INSERT INTO cebocb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Human mapahimutang ni Moises ang Tolda nga Pagsimbahan, gidihogan niya kini pinaagi sa pagwisik ug lana, ug gigahin lakip ang tanang mga kagamitan niini. Mao usab ang iyang gihimo sa halaran ug sa tanang kagamitan niini. ");
INSERT INTO cebocb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Unya ang mga pangulo sa Israel nga nagdumala niadtong mga tawo nga gipang-ihap, nagdala ngadto sa Ginoo ug mga halad. ");
INSERT INTO cebocb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Nagdala sila ngadto sa presensya sa Ginoo ug unom ka karomata ug 12 ka baka, usa ka karomata sa kada duha ka pangulo ug usa ka baka kada usa kanila. Gidala nila kini sa atubangan sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Dawata ang ilang halad aron magamit alang sa mga buluhaton diha sa Tolda nga Tagboanan. Ihatag kini sa mga kaliwat ni Levi sumala sa gikinahanglan sa tagsa-tagsa nila ka buluhaton.” ");
INSERT INTO cebocb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Busa gidawat ni Moises ang mga karomata ug mga baka ug gihatag ngadto sa mga kaliwat ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gihatag niya ang duha ka karomata ug upat ka baka sa mga kaliwat ni Gershon alang sa ilang buluhaton. ");
INSERT INTO cebocb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Gihatag niya ang upat ka karomata ug walo ka baka sa mga kaliwat ni Merari alang sa ilang buluhaton. Gipangulohan kini silang tanan ni Itamar nga anak sa pari nga si Aaron. ");
INSERT INTO cebocb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Apan wala hatagi ni Moises ug karomata o baka ang mga kaliwat ni Kohat kay kinahanglang pas-anon lang gayod nila ang balaan nga mga butang sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ang mga pangulo nagdala usab sa ilang mga halad alang sa pagdedikar sa halaran sa panahon nga kini gidedikar. ");
INSERT INTO cebocb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Miingon ang Ginoo kang Moises, “Kinahanglan nga sa matag adlaw adunay usa ka pangulo nga magdala sa iyang halad alang sa pagdedikar sa halaran.” ");
INSERT INTO cebocb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Sa unang adlaw, nagdala sa iyang mga halad si Nashon nga anak ni Aminadab nga gikan sa tribo ni Juda. ");
INSERT INTO cebocb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Nashon nga anak ni Aminadab. ");
INSERT INTO cebocb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Sa ikaduha nga adlaw, nagdala sa iyang mga halad si Netanel nga anak ni Zuar nga pangulo sa tribo ni Isacar. ");
INSERT INTO cebocb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Netanel nga anak ni Zuar. ");
INSERT INTO cebocb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Sa ikatulo nga adlaw, nagdala sa iyang mga halad si Eliab nga anak ni Helon nga pangulo sa tribo ni Zabulon. ");
INSERT INTO cebocb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Eliab nga anak ni Helon. ");
INSERT INTO cebocb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Sa ikaupat nga adlaw, nagdala sa iyang mga halad si Elizur nga anak ni Shedeur nga pangulo sa tribo ni Ruben. ");
INSERT INTO cebocb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Elizur nga anak ni Shedeur. ");
INSERT INTO cebocb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Sa ikalima nga adlaw, nagdala sa iyang mga halad si Shelumiel nga anak ni Zurishadai nga pangulo sa tribo ni Simeon. ");
INSERT INTO cebocb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Shelumiel nga anak ni Zurishadai. ");
INSERT INTO cebocb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Sa ikaunom nga adlaw, nagdala sa iyang mga halad si Eliasaf nga anak ni Deuel nga pangulo sa tribo ni Gad. ");
INSERT INTO cebocb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Eliasaf nga anak ni Deuel. ");
INSERT INTO cebocb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Sa ikapito nga adlaw, nagdala sa iyang mga halad si Elishama nga anak ni Amihud nga pangulo sa tribo ni Efraim. ");
INSERT INTO cebocb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Elishama nga anak ni Amihud. ");
INSERT INTO cebocb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Sa ikawalo nga adlaw, nagdala sa iyang mga halad si Gamaliel nga anak ni Pedazur nga pangulo sa tribo ni Manases. ");
INSERT INTO cebocb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Gamaliel nga anak ni Pedazur. ");
INSERT INTO cebocb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Sa ikasiyam nga adlaw, nagdala sa iyang mga halad si Abidan nga anak ni Gideoni nga pangulo sa tribo ni Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Abidan nga anak ni Gideoni. ");
INSERT INTO cebocb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Sa ikanapulo nga adlaw, nagdala sa iyang mga halad si Ahiezer nga anak ni Amishadai nga pangulo sa tribo ni Dan. ");
INSERT INTO cebocb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Ahiezer nga anak ni Amishadai. ");
INSERT INTO cebocb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Sa ika-11 nga adlaw, nagdala sa iyang mga halad si Pagiel nga anak ni Ocran nga pangulo sa tribo ni Aser. ");
INSERT INTO cebocb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Pagiel nga anak ni Ocran. ");
INSERT INTO cebocb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Sa ika-12 nga adlaw, nagdala sa iyang mga halad si Ahira nga anak ni Enan nga pangulo sa tribo ni Neftali. ");
INSERT INTO cebocb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Mao kini ang iyang gidala: usa ka pilak nga bandehado nga adunay gibug-aton nga usa ka kilo ug tunga, ug usa ka pilak nga yahong nga adunay gibug-aton nga 800 ka gramo basi sa timbangan nga ginagamit sa mga pari, ang kada usa niini puno sa maayong klasi sa harina nga sinagolan ug mantika isip halad alang sa pagpasidungog sa Ginoo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","usa ka bulawan nga plato nga adunay gibug-aton nga 120 ka gramo nga puno ug insenso; ");
INSERT INTO cebocb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","usa ka nating torong baka, usa ka hamtong nga laking karnero, ug usa ka laking karnero nga tagsa ka tuig ang edad isip halad nga sinunog; ");
INSERT INTO cebocb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","usa ka laking kanding isip halad sa paghinlo; ");
INSERT INTO cebocb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ug duha ka baka, lima ka hamtong nga laking karnero, lima ka laking kanding, ug lima ka laking karnero nga tagsa ka tuig ang edad isip halad alang sa maayong relasyon. Mao kini ang mga halad si Ahira nga anak ni Enan. ");
INSERT INTO cebocb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Mao kini tanan ang mga halad sa 12 ka mga pangulo sa mga Israelinhon alang sa pagdedikar sa halaran: 12 ka pilak nga bandehado, 12 ka pilak nga yahong, ug 12 ka bulawan nga plato. ");
INSERT INTO cebocb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ang kada usa sa pilak nga bandehado adunay gibug-aton nga usa ka kilo ug tunga, ug ang kada usa sa salapi nga yahong adunay gibug-aton nga 800 ka gramo. Ang gibug-aton niining tanan mikabat ug 28 ka kilo basi sa timbangan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ang 12 ka bulawan nga plato nga puno ug insenso adunay gibug-aton nga 120 ka gramo kada usa basi sa timbangan nga ginagamit sa mga pari. Ang gibug-aton niining tanan mikabat ug 1,440 ka gramo. ");
INSERT INTO cebocb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ang gidaghanon sa mananap alang sa halad nga sinunog mao kini: 12 ka nating torong baka, 12 ka hamtong nga laking karnero, ug 12 ka laking karnero nga tagsa ka tuig ang edad, lakip ang mga halad isip halad sa pagpasidungog sa Ginoo. Ang halad sa paghinlo: 12 ka laking kanding. ");
INSERT INTO cebocb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ang gidaghanon sa mananap alang sa halad sa maayong relasyon mao kini: 24 ka torong baka, 60 ka hamtong nga laking karnero, 60 ka laking kanding, ug 60 ka laking karnero nga tagsa ka tuig ang edad. Mao kini tanan ang mga halad sa pagdedikar sa halaran. ");
INSERT INTO cebocb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kon mosulod si Moises sa Tolda nga Tagboanan sa pagpakigsulti sa Ginoo, madungog niya ang tingog nga nagsulti kaniya gikan sa taliwala sa duha ka kerubin, nga anaa ibabaw sa tabon sa Sudlanan sa Kasugoan. Didto makigsulti ang Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ingna si Aaron nga kon ibutang na niya ang pito ka suga, kinahanglan nga ipahimutang niya kini sa paagi diin ang kahayag modan-ag sa atubangan sa butanganan niini.” ");
INSERT INTO cebocb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Busa gihimo kini ni Aaron; gipahimutang niya ang mga suga sa paagi diin ang kahayag nagdan-ag sa atubangan sa butanganan niini, sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ang butanganan sa suga, gikan sa ubos hangtod sa ibabaw, hinimo sa bulawan sumala sa sumbanan nga gipadayag sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ilain ang mga kaliwat ni Levi gikan sa ubang mga Israelinhon, ug hinloi sila. ");
INSERT INTO cebocb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Mao kini ang himuon mo sa paghinlo kanila: Wisiki sila sa tubig nga ginagamit sa paghinlo, ug pakiskisi ang tibuok nilang kalawasan ug palabhi ang ilang mga bisti. Human niana maisip na sila nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Unya, padad-a sila ug nating torong baka ug halad alang sa pagpasidungog sa Ginoo nga hinimo gikan sa maayong klasi sa harina nga sinagolan ug mantika. Padad-a usab sila ug laing usa pa ka nating torong baka isip halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","“Pagkahuman tigoma ang tibuok katilingban sa Israel ug idedikar ang mga kaliwat ni Levi didto sa atubangan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Dad-a ang mga kaliwat ni Levi sa akong presensya ug papandongi ang ilang mga ulo sa mga kamot sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Si Aaron ang modedikar kanila sa akong presensya isip pinasahi nga halad gikan sa mga Israelinhon, aron makaalagad sila kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Unya ipatong sa mga kaliwat ni Levi ang ilang mga kamot ngadto sa ulo sa duha ka nating torong baka ug ihalad kini kanako. Ang usa halad sa paghinlo ug ang usa halad nga sinunog, aron mahinloan sila gikan sa ilang mga sala. ");
INSERT INTO cebocb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Pabaroga sila atubangan ni Aaron ug sa iyang mga anak nga lalaki ug idedikar sila isip pinasahi nga halad alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Niining paagiha malain mo ang mga kaliwat ni Levi gikan sa ubang mga Israelinhon, ug maako na sila. ");
INSERT INTO cebocb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Human mo mahinlo-i ang mga kaliwat ni Levi ug madedikar kanako ingon nga pinasahi nga halad, makaalagad na sila sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Sila ang mga Israelinhon nga gigahin alang lang gayod kanako puli sa tanang mga kamagulangang anak nga lalaki sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kay ang tanang kamagulangan sa Israel akoa, tawo man o mananap. Sa dihang gipamatay ko ang tanang kamagulangang anak nga lalaki sa mga Ehiptohanon, gigahin ko na alang kanako ang tanang kamagulangang anak nga lalaki sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ug gikuha ko ang mga kaliwat ni Levi puli sa tanang kamagulangang anak nga lalaki sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Sa tanang mga Israelinhon, ang mga kaliwat ni Levi ang gigahin ko nga magtabang kang Aaron ug sa iyang mga anak. Mag-alagad sila sa Tolda nga Tagboanan alang sa mga Israelinhon, ug sila ang maghimo sa mga seremonya aron mahinloan ang mga Israelinhon gikan sa ilang mga sala, aron walay katalagman nga mahitabo kanila kon moduol sila sa Tolda nga Tagboanan.” ");
INSERT INTO cebocb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Busa gihimo nila ni Moises, Aaron, ug sa tibuok katilingban sa Israel ang gisugo sa Ginoo kang Moises nga himuon alang sa mga kaliwat ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Nanghinlo ang mga kaliwat ni Levi ug gilabhan nila ang ilang mga bisti. Unya gidedikar sila ni Aaron sa presensya sa Ginoo ingon nga pinasahi nga halad, ug naghimo si Aaron ug seremonya aron mahinloan sila gikan sa ilang mga sala, ug aron maisip na sila nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Human niadto, nangalagad na ang mga kaliwat ni Levi sa Tolda nga Tagboanan ubos sa pagdumala ni Aaron ug sa iyang mga anak nga lalaki. Gibuhat gayod nila ngadto sa mga kaliwat ni Levi ang gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Mao kini ang tulomanon alang sa mga kaliwat ni Levi. Magsugod ang mga kaliwat ni Levi sa pagpangalagad sa edad nga 25 ka tuig diha sa Tolda nga Tagboanan, ");
INSERT INTO cebocb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ug moundang sila sa pagpangalagad sa edad nga 50 ka tuig. Niining edara, ");
INSERT INTO cebocb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","mahimo pa silang motabang sa ilang kauban nga mga Levita pinaagi sa pag-alagad isip tigbantay sa Tolda, apan dili gayod sila mohimo sa mga buluhaton diha sa Tolda. Ingon niini ang paghatag mo sa mga katungdanan sa mga Levita.” ");
INSERT INTO cebocb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Sa unang bulan sa ikaduhang tuig gikan sa paggawas sa mga Israelinhon sa Ehipto, miingon ang Ginoo kang Moises didto sa kamingawan sa Sinai, ");
INSERT INTO cebocb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ipasaulog gayod sa mga Israelinhon ang Pista sa Paglabay sa Anghel sa gitakda nga panahon, ");
INSERT INTO cebocb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","sugod sa pagsalop sa adlaw sa ika-14 nga adlaw sa unang bulan. Kinahanglan sundon gayod ninyo ang tanang tulomanon mahitungod niini nga pista.” ");
INSERT INTO cebocb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Busa giingnan ni Moises ang mga Israelinhon sa pagsaulog sa Pista sa Paglabay sa Anghel. ");
INSERT INTO cebocb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ug gihimo nila ang pagsaulog sa pista didto sa kamingawan sa Sinai sa pagsalop sa adlaw sa ika-14 nga adlaw sa unang bulan. Gihimo kini sa tanang mga Israelinhon sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Apan adunay uban nga wala makaapil sa pagsaulog sa pista tungod kay nianang adlawa nahimo silang hugaw kay nakahikap sila ug patay. Busa niadto mismong adlawa miadto sila kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ug miingon kang Moises, “Nahimo kaming hugaw kay nakahikap kami ug patay, apan nganong did-an man kami sa paghalad sa mga halad ngadto sa Ginoo uban sa mga Israelinhon sa gitakda nga panahon?” ");
INSERT INTO cebocb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mitubag si Moises kanila, “Paghulat lang una kamo hangtod masayran ko kon unsay imando sa Ginoo kanako bahin kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ingna ang mga Israelinhon nga si bisan kinsa kanila o sa umaabot nilang mga kaliwat nga nahimong hugaw kay nakahikap ug patay o tungod kay nagbiyahe sa layo, makahimo gihapon sa pagsaulog sa Pista sa Paglabay sa Anghel sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Saulogon nila kini paglabay sa usa ka bulan, sugod sa pagsalop sa adlaw sa ika-14 nga adlaw sa ikaduha nga bulan. Kan-on nila ang karnero uban sa pan nga walay patubo ug pait nga mga utanon. ");
INSERT INTO cebocb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kinahanglan nga wala gayoy mahibilin niini pagkabuntag, ug dili usab nila balion ang mga bukog sa karnero. Kon magsaulog sila sa Pista sa Paglabay sa Anghel kinahanglan nga sundon gayod nila ang mga tulomanon mahitungod niini. ");
INSERT INTO cebocb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Apan ang tawo nga hinlo ug wala magbiyahe sa layo nga wala magsaulog sa Pista sa Paglabay sa Anghel, kinahanglan nga dili na isipon nga sakop ninyo, tungod kay wala siya maghalad sa halad nga alang sa Ginoo sa gitakda nga panahon. Kana nga tawo mag-antos tungod sa iyang sala. ");
INSERT INTO cebocb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Kon ang usa ka langyaw nga nagpuyo uban kaninyo gustong magsaulog sa Pista sa Paglabay sa Anghel sa Ginoo, kinahanglan nga saulogon niya kini sumala sa tanang mga tulomanon bahin niini. Ang mga tulomanon alang sa mga langyaw sama ra sa mga Israelinhon.” ");
INSERT INTO cebocb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Sa adlaw nga gipatindog ang Tolda nga Pagsimbahan, nga gitawag usab ug Tolda nga Tagboanan, gipalibotan kini sa panganod. Gikan sa gabii hangtod sa buntag, kini nga panganod daw sa kalayo nga nagsiga. ");
INSERT INTO cebocb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Mao kini ang kanunay nga mahitabo: Kon adlaw ginapalibotan niini ang Tolda ug kon gabii nagsiga kini nga daw kalayo. ");
INSERT INTO cebocb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kon mopaibabaw ang panganod tungod sa Tolda ug mohawa, manglakaw ang mga Israelinhon, ug kon asa mopundo ang panganod, didto usab sila magkampo. ");
INSERT INTO cebocb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Busa naglakaw ug nagkampo ang mga Israelinhon sumala sa mando sa Ginoo. Magpabilin sila sa kampo samtang anaa pa ang panganod ibabaw sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bisan magpabilin ug dugay ang panganod diha tungod sa Tolda, dili sila mobiya ug naghulat lang sila sa mando sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Usahay magpabilin lang ug pipila ka adlaw ang panganod diha tungod sa Tolda, busa ang mga tawo magpabilin usab ug mga pipila lang ka adlaw didto. Unya manglakaw na usab sila sumala sa mando sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Usahay magpabilin kini ug usa lang ka gabii ug pagkasunod adlaw mopaibabaw na kini, ug manglakaw na usab dayon ang mga Israelinhon. Adlaw man o gabii, basta mopaibabaw na ang panganod manglakaw usab ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kon magpabilin gani ang panganod diha tungod sa Tolda ug duha ka adlaw o mga usa ka bulan, o kon mga usa ka tuig, magpabilin usab ang mga Israelinhon sa ilang kampo. Apan kon mopaibabaw na ang panganod, manglakaw usab sila dayon. ");
INSERT INTO cebocb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Busa magkampo ug manglakaw ang mga Israelinhon sumala sa mando sa Ginoo. Ug gituman nila ang sugo sa Ginoo pinaagi kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Pagpahimo ug duha ka trumpeta nga pilak ug gamita kini sa pagtigom sa mga tawo ug sa pagpaandam kanila sa pagpanglakaw. ");
INSERT INTO cebocb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kon patingogon ug dungan kining duha ka trumpeta, magtigom ang tibuok katilingban diha sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kon usa lang ang patingogon, ang mga pangulo lang sa kada tribo ang magtigom diha sa imong atubangan. ");
INSERT INTO cebocb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kon patingogon na ang trumpeta sa pagpaandam sa mga tawo sa pagpanglakaw, ang mga tribo sa sidlakan dapit sa Tolda mao ang una nga manglakaw. ");
INSERT INTO cebocb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kon patingogon ang trumpeta sa ikaduha nga higayon, ang tribo na pud sa habagatan dapit sa Tolda ang manglakaw. Ang pagpatingog niini mao ang timailhan sa ilang pagpanglakaw. ");
INSERT INTO cebocb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Apan lahi ang pagpatingog sa trumpeta kon tigomon mo ang mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ang mga kaliwat lang ni Aaron nga mga pari ang mopatingog sa mga trumpeta. Kini nga tulomanon kinahanglan tumanon ninyo ug sa inyong mga kaliwat hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Kon atua na kamo sa inyong yuta, unya makig-away kamo batok sa kaaway nga mopaantos kaninyo, patingoga ninyo ang mga trumpeta aron ako, ang Ginoo nga inyong Dios, mahinumdom kaninyo ug moluwas kaninyo gikan sa inyong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ug sa panahon sa inyong pagmaya, sa inyong pagsaulog sa mga pista, lakip na ang Pista sa Pagsugod sa Bulan, patingogon usab ninyo ang mga trumpeta kon maghalad kamo sa mga halad nga sinunog ug halad alang sa maayong relasyon. Kini nga mga trumpeta ang magpahinumdom kanako nga inyong Dios sa akong kasabotan uban kaninyo. Ako mao ang Ginoo nga inyong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Sa ika-20 nga adlaw sa ikaduhang bulan, sa ikaduhang tuig gikan sa paggawas sa mga Israelinhon sa Ehipto, mipaibabaw ang panganod sa Tolda nga Pagsimbahan. ");
INSERT INTO cebocb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Unya nanglakaw ang mga Israelinhon gikan sa kamingawan sa Sinai hangtod mipundo ang panganod didto sa kamingawan sa Paran. ");
INSERT INTO cebocb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mao kini ang unang higayon nga nanglakaw sila sumala sa sugo sa Ginoo pinaagi kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ang gauna sa pagpanglakaw, dala ang ilang bandera, mao ang grupo nga gipangulohan sa tribo ni Juda. Ang ilang pangulo mao si Nashon nga anak ni Aminadab. ");
INSERT INTO cebocb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ang tribo ni Isacar gipangulohan ni Netanel nga anak ni Zuar, ");
INSERT INTO cebocb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ug ang tribo ni Zabulon gipangulohan ni Eliab nga anak ni Helon. ");
INSERT INTO cebocb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Human nahipos ang Tolda nga Pagsimbahan, gipas-an kini sa mga kaliwat ni Gershon ug sa mga kaliwat ni Merari, ug misunod sila sa pagpanglakaw. ");
INSERT INTO cebocb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ang sunod nga nanglakaw, dala ang ilang bandera, mao ang grupo nga gipangulohan sa tribo ni Ruben. Ang ilang pangulo mao si Elizur nga anak ni Shedeur. ");
INSERT INTO cebocb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ang tribo ni Simeon gipangulohan ni Shelumiel nga anak ni Zurishadai, ");
INSERT INTO cebocb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ug ang tribo ni Gad gipangulohan ni Eliasaf nga anak ni Deuel. ");
INSERT INTO cebocb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ang sunod nga nanglakaw mao ang mga kaliwat ni Kohat nga nagdala sa balaan nga mga kagamitan sa Tolda nga Pagsimbahan. Kinahanglang naplastar na ang Tolda sa wala pa sila moabot sa sunod nga lugar. ");
INSERT INTO cebocb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ang sunod nga nanglakaw, dala ang ilang bandera, mao ang grupo nga gipangulohan sa tribo ni Efraim. Ang ilang pangulo mao si Elishama nga anak ni Amihud. ");
INSERT INTO cebocb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ang tribo ni Manases gipangulohan ni Gamaliel nga anak ni Pedazur, ");
INSERT INTO cebocb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ug ang tribo ni Benjamin gipangulohan ni Abidan nga anak ni Gideoni. ");
INSERT INTO cebocb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ang kataposan nga nanglakaw, dala ang ilang bandera, mao ang grupo nga gipangunahan sa tribo ni Dan. Sila ang nahimong tigbalantay sa luyo alang sa tanang mga grupo. Ang ilang pangulo mao si Ahiezer nga anak ni Amishadai. ");
INSERT INTO cebocb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ang tribo ni Aser gipangulohan ni Pagiel nga anak ni Ocran, ");
INSERT INTO cebocb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ug ang tribo ni Neftali gipangulohan ni Ahira nga anak ni Enan. ");
INSERT INTO cebocb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mao kini ang pagkahan-ay sa mga grupo sa mga tribo sa Israel sa ilang pagpanglakaw. ");
INSERT INTO cebocb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Unya, miingon si Moises kang Hobab nga iyang bayaw nga anak ni Reuel nga Midianhon, “Moadto na kami sa dapit nga giingon sa Ginoo nga ihatag niya kanamo. Busa uban kanamo ug dili ka namo pasagdan, kay misaad ang Ginoo nga panalanginan niya ang Israel.” ");
INSERT INTO cebocb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Apan mitubag si Hobab, “Dili ko. Mobalik ako sa dapit sa akong mga katagilungsod.” ");
INSERT INTO cebocb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Miingon si Moises, “Kon mahimo ayaw kami biyai. Ikaw ang among giya. Ikaw ang nakahibalo kon asa ang maayo nga dapit sa kamingawan nga angay namong kampohan. ");
INSERT INTO cebocb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kon mouban ka kanamo bahinan ka namo sa tanang kaayohan nga ihatag sa Ginoo kanamo.” ");
INSERT INTO cebocb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Busa namiya sila sa bukid sa Ginoo ug nanglakaw ug tulo ka adlaw. Gauna kanunay kanila ang Sudlanan sa Kasabotan sa pagpangita ug dapit nga ilang kapahulayan. ");
INSERT INTO cebocb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kon adlaw, ang panganod sa Ginoo anaa sa ilang tungod kon manglakaw sila. ");
INSERT INTO cebocb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Matag higayon nga dalhon na ang Sudlanan sa Kasabotan moingon si Moises, “Sige na, Ginoo, ipatibulaag na ang imong mga kaaway. Hinaut nga mangikyas sila.” ");
INSERT INTO cebocb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sa matag higayon nga ibutang ang Sudlanan sa Kasabotan, moingon si Moises, “Balik, Ginoo, sa liboan ka mga katawhan sa Israel.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Unya, mireklamo ang mga Israelinhon bahin sa ilang kalisod. Pagkabati niini sa Ginoo, nasuko siya ug nagpadala ug kalayo nga misunog sa pipila ka bahin sa palibot sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tungod niini, nangayo ug tabang ang mga Israelinhon kang Moises, ug nag-ampo si Moises sa Ginoo, ug unya napalong ang kalayo. ");
INSERT INTO cebocb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Busa ang maong dapit ginganlan ug Tabera, kay nagpadala ang Ginoo ug kalayo kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ang panon sa mga langyaw nga miuban sa mga Israelinhon gihidlaw sa ubang mga pagkaon, ug ang mga Israelinhon mireklamo usab nga nag-ingon, “Unta makakaon kita ug karne! ");
INSERT INTO cebocb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sa didto pa kita sa Ehipto, makakaon kita ug libreng isda, mga pipino, mga melon, mga sibuyas, ug mga ahos. ");
INSERT INTO cebocb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Apan dinhi nawala ang atong gana sa pagkaon, kay pulos na lang manna ang atong ginakaon.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Kining manna daw mga liso nga gagmay ug puti. ");
INSERT INTO cebocb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Mouban kini sa pagpanghugpa sa yamog diha sa kampo sa panahon sa kagabhion. Pamuniton kini sa mga Israelinhon sa yuta kada buntag, unya galingon nila o lubokon. Pagkahuman, lutuon nila kini sa kolon o himuong nipis nga pan. Ang lami niini sama sa pan nga giluto sa mantika. ");
INSERT INTO cebocb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Nadunggan ni Moises nga nanghilak ang matag pamilya diha sa pultahan sa ilang mga tolda. Hilabihan gayod ang kasuko sa Ginoo kanila, ug nasubo usab pag-ayo si Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nangutana siya sa Ginoo, “Nganong gihatagan man nimo ako nga imong alagad ug dakong problema? Unsa may gihimo ko nga wala makapalipay kanimo nga gihatag mo man kanako ang problema niining mga tawo? ");
INSERT INTO cebocb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ako bay nagsabak kanila? Ako bay nanganak kanila? Nganong moingon ka man nga atimanon ko sila sama sa usa ka yaya nga nagkugos ug masuso nga bata, ug dad-on sila sa yuta nga gisaad mo sa ilang mga katigulangan? ");
INSERT INTO cebocb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Asa ako manguha ug karne alang niining mga tawhana? Nagsige silag reklamo nga hatagan ko sila ug karne nga ilang makaon. ");
INSERT INTO cebocb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Dili nako makaya ang pag-atiman kanila. Hilabihan kini kabug-at alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kon mao man lang kini ang imong pagtratar kanako, patya na lang ako karon dayon. Kon nalipay ka kanako, ayaw ako pasagdi nga mag-antos.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Busa miingon ang Ginoo kang Moises, “Tigoma ang 70 ka mga tigdumala sa Israel nga nailhan mo nga mga pangulo sa katawhan. Dad-a sila sa Tolda nga Tagboanan ug pabaroga sila didto uban kanimo. ");
INSERT INTO cebocb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Moadto ako ug makigsulti kanimo didto, ug ihatag ko kanila ang uban nga gahom nga gihatag ko kanimo aron makatabang sila sa pagdumala sa mga tawo, aron dili ka mag-inusara sa pagdumala kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Unya ingna ang mga tawo nga magpakahinlo sila, kay ugma mangaon sila ug karne. Isulti kini kanila: ‘Nadungog kamo sa Ginoo nga nagreklamo nga gusto ninyong mokaon ug karne. Ug miingon pa kamo nga mas maayo pa ang inyong kahimtang didto sa Ehipto. Busa ugma hatagan kamo sa Ginoo ug karne ug kan-on ninyo kini. ");
INSERT INTO cebocb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Dili lang kamo mokaon niini sulod sa usa, o duha, o lima, o napulo, o baynte ka adlaw, ");
INSERT INTO cebocb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","kondili sulod sa usa ka bulan, hangtod nga isuka ninyo kini ug masumhan kamo niini. Kay gisalikway ninyo ang Ginoo nga nag-uban kaninyo, ug mihilak kamo kaniya nga unta wala na lang kamo mobiya sa Ehipto.’ ” ");
INSERT INTO cebocb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Apan miingon si Moises, “600,000 tanan ang mga tawo nga akong kauban, ug karon moingon ka nga hatagan mo sila ug karne nga ilang kan-on sulod sa usa ka bulan? ");
INSERT INTO cebocb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bisan ihawon pa namo ang tanang mga karnero ug baka o kaha dakpon ang tanang mga isda sa dagat dili kini paigo kanila.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Miingon ang Ginoo kang Moises, “Limitado ba ang akong gahom? Makita mo karon kon mahitabo ang giingon ko kanimo o dili.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Busa milakaw si Moises ug giingnan niya ang mga tawo sa giingon sa Ginoo. Gitigom niya ang 70 ka mga tigdumala ug gipabarog libot sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Unya mikunsad ang Ginoo diha sa panganod ug nakigsulti kang Moises. Gikuha niya ang ubang gahom ni Moises ug gihatag sa 70 ka tigdumala. Ug sa dihang nadawat na nila ang gahom, misugilon sila sa mensahe sa Dios, apan wala na kadto mahitabo pag-usab. ");
INSERT INTO cebocb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Adunay duha niadtong 70 ka mga tigdumala nga nagpabilin sa kampo ug wala moadto sa Tolda: sila mao si Eldad ug Medad. Apan naangkon gihapon nila ang gahom ug nagsugilon usab sila sa mensahe sa Dios didto sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ug adunay usa ka batan-ong lalaki nga midagan paingon kang Moises ug miingon nga nagsugilon si Eldad ug Medad sa mensahe sa Dios didto sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Si Josue nga anak ni Nun, nga nahimong personal nga katabang ni Moises gikan sa batan-on pa siya, miingon kang Moises, “Sir, pahunonga sila.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Apan mitubag si Moises, “Nabalaka ka ba kon unsay mahimong resulta niini sa akong pagkapangulo? Kon ako lay pabut-on, gusto ko nga ang tanang katawhan sa Ginoo hatagan niya ug gahom aron makasugilon silang tanan sa iyang mensahe.” ");
INSERT INTO cebocb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Pagkahuman, mibalik sa kampo si Moises ug ang mga tigdumala sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Unya, nagpadala ang Ginoo ug hangin nga nagdala ug mga buntog gikan sa dagat. Mitugdon kini libot sa kampo ug milukop sa distansya nga mga usa ka adlaw nga pagbaklay gikan sa kampo ngadto sa matag kilid. Nagkatag ang mga buntog sa gibag-on nga tulo ka piye. ");
INSERT INTO cebocb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Busa niadtong adlawa nanakop ang mga tawo ug mga buntog hangtod sa gabii, ug hangtod pa gayod nianang pagkasunod nga adlaw. Wala gayoy nakatigom ug ubos sa 30 ka sako, ug gipangbulad nila kini sa palibot sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Apan wala pa gani nila mahurot ug usap ang karne, nasuko pag-ayo ang Ginoo kanila, ug gipadad-an niya sila ug katalagman. ");
INSERT INTO cebocb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Busa gitawag ang maong dapit ug Kibrot Hataava tungod kay didto gipanglubong ang mga tawo nga hangol ug karne. ");
INSERT INTO cebocb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Gikan didto, nanglakaw ang mga Israelinhon paingon sa Hazerot ug didto nagkampo. ");
INSERT INTO cebocb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Sa didto na sila sa Hazerot, gisaway ni Miriam ug ni Aaron si Moises tungod kay nangasawa siya ug usa ka taga-Etiopia. ");
INSERT INTO cebocb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Miingon sila, “Pinaagi lang ba kang Moises makigsulti ang Ginoo? Dili ba nakigsulti man usab siya pinaagi kanato?” Apan nadunggan kini sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Si Moises mapainubsanon kaayo labaw kaysa tanang mga tawo sa kalibotan.) ");
INSERT INTO cebocb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Busa nakigsulti dayon ang Ginoo kang Moises, Aaron, ug Miriam. Miingon siya kanila, “Pangadto kamong tulo sa Tolda nga Tagboanan.” Busa nanggawas sila ug nangadto sa Tolda. ");
INSERT INTO cebocb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Unya mikunsad ang Ginoo pinaagi sa panganod nga daw haligi ug mitindog sa pultahan sa Tolda nga Tagboanan ug gitawag si Aaron ug si Miriam. Pagduol sa duha, ");
INSERT INTO cebocb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","miingon ang Ginoo, “Pamati kamo! Kon aduna akoy propeta diha kaninyo, makigsulti ako kaniya pinaagi sa panan-awon ug damgo. ");
INSERT INTO cebocb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Apan dili sa ingon niana nga paagi ako makigsulti sa akong alagad nga si Moises, nga gisaligan ko sa akong katawhan. ");
INSERT INTO cebocb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Makigsulti ako kaniya nga mag-atubangay, klaro, ug dili pinaagi sa mga sambingay. Daw sama lang nga nakita niya ako. Apan nganong wala gayod kamo nahadlok mosulti ug daotan batok sa akong alagad nga si Moises?” ");
INSERT INTO cebocb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nasuko pag-ayo ang Ginoo kanila, ug mibiya siya. ");
INSERT INTO cebocb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Sa dihang mibiya na ang panganod ibabaw sa Tolda, gitakboyan dayon si Miriam ug ngilngig nga sakit sa panit, ug nagputi gayod ang iyang panit. Pagkakita ni Aaron niini, ");
INSERT INTO cebocb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","miingon siya kang Moises, “Sir, ayaw kami paantosa tungod sa kabuang nga sala nga among nahimo. ");
INSERT INTO cebocb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ayaw itugot nga mahisama si Miriam sa usa ka patayng bata nga gihimugso diin ang katunga sa lawas niini nadugta na.” ");
INSERT INTO cebocb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Busa nagpakiluoy si Moises sa Ginoo, “Dios ko, naghangyo ako kanimo nga ayohon mo si Miriam!” ");
INSERT INTO cebocb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mitubag ang Ginoo kang Moises, “Kon luwaan siya sa iyang amahan sa dagway, dili ba antoson niya ang kaulaw sulod sa pito ka adlaw? Busa pagawasa siya sa kampo sulod sa pito ka adlaw, ug pagkahuman mahimo na siyang mobalik.” ");
INSERT INTO cebocb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Busa gipagawas si Miriam sa kampo sulod sa pito ka adlaw. Ug ang mga tawo wala mopadayon sa ilang paglakaw hangtod nga wala pa si Miriam mahibalik sa kampo. ");
INSERT INTO cebocb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Human niadto, mibiya sila sa Hazerot ug nagkampo sa kamingawan sa Paran. ");
INSERT INTO cebocb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Pagpadala ug mga tawo sa pagpangispiya sa Canaan, ang yuta nga ihatag ko kaninyong mga Israelinhon. Ang imong ipadala mga pangulo gikan sa kada tribo sa Israel.” ");
INSERT INTO cebocb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Gituman ni Moises ang gisugo kaniya sa Ginoo. Gipaadto niya sa Canaan ang mga pangulo sa mga Israelinhon gikan sa kamingawan sa Paran. ");
INSERT INTO cebocb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mao kini ang mga ngalan sa mga pangulo ug ang tribo nga ilang kagikan: gikan sa tribo ni Ruben, Shamua anak ni Zacur; ");
INSERT INTO cebocb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","gikan sa tribo ni Simeon, Shafat anak ni Hori; ");
INSERT INTO cebocb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","gikan sa tribo ni Juda, Caleb anak ni Jefune; ");
INSERT INTO cebocb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","gikan sa tribo ni Isacar, Igal anak ni Jose; ");
INSERT INTO cebocb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","gikan sa tribo ni Efraim, Oseas anak ni Nun; ");
INSERT INTO cebocb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","gikan sa tribo ni Benjamin, Palti anak ni Rafu; ");
INSERT INTO cebocb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","gikan sa tribo ni Zabulon Gadiel anak ni Sodi; ");
INSERT INTO cebocb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","gikan sa tribo ni Manases nga anak ni Jose, Gadi anak ni Susi; ");
INSERT INTO cebocb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","gikan sa tribo ni Dan, Amiel anak ni Gemali; ");
INSERT INTO cebocb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","gikan sa tribo ni Aser, Setur anak ni Micael; ");
INSERT INTO cebocb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","gikan sa tribo ni Neftali, Nabi anak ni Vofsi; ");
INSERT INTO cebocb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","gikan sa tribo ni Gad, Geuel anak ni Maki. ");
INSERT INTO cebocb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Sila ang mga tawo nga gipadala ni Moises sa pagpangispiya sa Canaan. (Giilisan ni Moises ang ngalan ni Oseas nga anak ni Nun ug Josue.) ");
INSERT INTO cebocb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Gipadala sila ni Moises aron sa pagpangispiya sa Canaan uban sa pag-ingon kanila, “Panglakaw kamo paamihan ug adto sa Negev, ngadto sa kabukiran. ");
INSERT INTO cebocb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Susiha ninyo kon unsang matanga kini sa yuta, ug kon ang mga tawo didto kusgan ba o luya, o daghan ba sila o gamay ra. ");
INSERT INTO cebocb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Tan-awa ninyo kon unsang matanga sa yuta ang ilang ginapuy-an, maayo ba o dili. Tan-awa ninyo kon ang ilang mga lungsod napalibotan ba ug paril o wala. ");
INSERT INTO cebocb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tan-awa ninyo kon tambok ba ang ilang yuta o dili, ug kon aduna bay kakahoyan o wala. Ug paningkamoti gayod ninyo nga makadala ug mga prutas sa inyong pagbalik.” (Panahon kadto sa tinghinog sa unang bunga sa ubas.) ");
INSERT INTO cebocb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Busa nanglakaw sila ug gisusi nila ang yuta gikan sa kamingawan sa Zin hangtod sa Rehob duol sa Lebo Hamat. ");
INSERT INTO cebocb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nagsugod sila sa Negev hangtod nga nakaabot sila sa Hebron, diin nagpuyo sila si Ahiman, Sheshai, ug Talmai, nga mga kaliwat ni Anak. (Kining Hebron gitukod pito ka tuig una pa matukod ang Zoan sa Ehipto.) ");
INSERT INTO cebocb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Pag-abot nila sa Walog sa Eshcol, nagputol silag usa ka pungpong sa ubas ug gidayongan kini ug duha ka tawo tungod sa kabug-at niini. Nagdala usab silag mga prutas nga pomegranata ug igos. ");
INSERT INTO cebocb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Kadto nga dapit gitawag nga Walog sa Eshcol tungod sa pungpong sa ubas nga giputol sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Human sa 40 ka adlaw nga pagpangispiya sa yuta, mibalik sila ");
INSERT INTO cebocb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","kang Moises, Aaron, ug sa tibuok katilingban sa Israel didto sa Kadesh, sa kamingawan sa Paran. Gisulti nila sa tibuok katilingban ang ilang nakita, ug gipakita nila ang ilang dala nga mga prutas. ");
INSERT INTO cebocb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Miingon sila kang Moises, “Nangadto kami sa dapit nga gipaadtoan mo kanamo, ug maayo kini ug mabungahon nga yuta. Ania ang mga prutas. ");
INSERT INTO cebocb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Apan gamhanan ang mga tawo nga nagpuyo didto, ug labihan kadagko ang ilang mga lungsod ug napalibotan kini ug mga paril. Nakita pa gani namo ang mga kaliwat ni Anak. ");
INSERT INTO cebocb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ang mga Amalekanhon nagpuyo sa Negev; ang mga Hitihanon, mga Jebusihanon, ug ang mga Amorihanon nagpuyo sa bukid; ug ang mga Canaanhon nagpuyo duol sa dagat ug sa daplin sa Walog sa Jordan.” ");
INSERT INTO cebocb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Gipahilom ni Caleb ang mga tawo atubangan ni Moises, ug miingon siya, “Manglakaw kita karon dayon ug ilogon nato ang yuta, kay sigurado gayod nga mailog nato kini.” ");
INSERT INTO cebocb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Apan miingon ang mga tawo nga kauban ni Caleb sa pagpangispiya, “Dili nato makaya ang pagsulong kanila kay mas kusgan sila kay kanato.” ");
INSERT INTO cebocb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ug mihatag sila ngadto sa mga Israelinhon ug dili maayo nga balita bahin sa yuta nga ilang gisusi. Mao kini ang ilang gisulti, “Ang yuta nga among gisusi dili maayo, gani nangamatay ang mga nagpuyo didto, ug dugang pa niana, ang mga tawo nga nakita namo didto hilabihan katag-as. ");
INSERT INTO cebocb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Adunay nakita pa gani kaming mga higante, nga mga kaliwat ni Anak. Daw mga apan-apan lang ang among panan-aw sa among kaugalingon kon ikompara kanila, ug mao usab kana ang ilang panan-aw kanamo.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Niadtong gabhiona naninggit ug naniyabaw ang tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Nagbagulbol sila ngadto kang Moises ug kang Aaron. Miingon sila, “Maayo pag nangamatay na lang kita didto sa Ehipto o kaha dinhi sa kamingawan! ");
INSERT INTO cebocb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nganong dad-on pa man kita sa Ginoo niana nga yuta, aron lang ba mangamatay kita sa gira ug pangbihagon ang atong mga asawa ug mga anak? Maayo pa sigurog mamalik na lang kita sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ug nag-ingnanay sila sa usag usa, “Maayo pag magpili kitag pangulo ug mamalik sa Ehipto.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Unya si Moises ug Aaron miyukbo atubangan sa tibuok katilingban sa Israel nga nagtigom didto. ");
INSERT INTO cebocb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ug gigisi ni Josue nga anak ni Nun ug ni Caleb nga anak ni Jefune ang ilang mga bisti tungod sa kasubo. Kini silang duha miuban sa pagpangispiya sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Miingon sila sa tibuok katilingban, “Maayo kaayo ang yuta nga among giadtoan. ");
INSERT INTO cebocb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kon nalipay ang Ginoo kanato, dad-on niya kita niana nga yuta, ang maayo ug mabungahon nga yuta, ug ihatag niya kini kanato. ");
INSERT INTO cebocb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ayaw lang kamo pagsupak sa Ginoo. Ug ayaw kamo kahadlok sa mga tawo didto kay mapildi gayod nato sila. Walay motabang kanila, apan anaa ang Ginoo nga motabang kanato. Busa ayaw kamo kahadlok kanila.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Batohon na unta sila sa tibuok katilingban, apan kalit lang nga nagpakita ang gamhanang presensya sa Ginoo ibabaw sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Miingon ang Ginoo kang Moises, “Hangtod kanus-a ba ako isalikway niining mga tawhana? Hangtod kanus-a sila magdumili sa pagtuo kanako luyo sa tanang mga milagro nga gihimo ko taliwala kanila? ");
INSERT INTO cebocb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Padad-an ko silag katalagman ug laglagon ko sila. Apan ikaw himuon kong usa ka nasod nga mas gamhanan ug lig-on kaysa kanila.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Miingon si Moises sa Ginoo, “Unsa na lay ikasulti sa mga Ehiptohanon kon mabalitaan nila kini? Dili ba nahibaloan man nila nga gikuha mo ang mga Israelinhon kanila pinaagi sa imong gahom. ");
INSERT INTO cebocb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Kon laglagon mo ang imong katawhan, isugilon nila kini sa mga lumulupyo sa Canaan. Kini nga mga Canaanhon nakadungog na nga ikaw, Ginoo, nag-uban sa mga Israelinhon ug nagpakita kanila pinaagi sa panganod nga gagiya kanila. Gipangunahan mo sila kon adlaw pinaagi sa panganod nga daw haligi, ug kon gabii pinaagi sa kalayo nga daw haligi. ");
INSERT INTO cebocb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Karon, kon hutdon mo ug pamatay kini nga katawhan, ang mga nasod nga nakadungog sa imong kabantog moingon, ");
INSERT INTO cebocb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Wala makahimo ang Ginoo sa pagdala sa mga Israelinhon ngadto sa yuta nga iyang gisaad kanila, busa gipamatay na lang niya sila didto sa kamingawan.’ ");
INSERT INTO cebocb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Busa karon, nag-ampo ako kanimo, Ginoo, hinaut unta nga ipakita mo ang imong gahom sumala sa imong giingon, ");
INSERT INTO cebocb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ang Ginoo mahigugmaon ug dili daling masuko, ug mapinasayloon sa mga sala sa tawo. Apan ginasilotan niya ang mga nakasala, hangtod sa ikatulo ug ikaupat nga henerasyon.’ ");
INSERT INTO cebocb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Sumala sa imong dakong gugma, naghangyo ako nga pasayloon mo ang sala niini nga katawhan, sama sa pagpasaylo mo kanila gikan sa paggawas nila sa Ehipto hangtod karon.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mitubag ang Ginoo, “Gipasaylo ko sila sumala sa imong gihangyo. ");
INSERT INTO cebocb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Apan nagsaad ako, ang buhing Ginoo, nga samtang napuno ang tibuok kalibotan sa akong gamhanan nga presensya, ");
INSERT INTO cebocb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","walay bisan usa kanila nga makasulod sa yuta nga gisaad ko sa ilang mga katigulangan. Kay bisan nakita nila ang akong gamhanang presensya ug ang mga milagro nga gipangbuhat ko sa Ehipto ug sa kamingawan, kanunay gihapon nila akong ginasulayan ug wala sila nagtuman kanako. Busa ang mga nagsalikway kanako dili gayod makasulod niana nga yuta. ");
INSERT INTO cebocb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Apan tungod kay si Caleb nga akong alagad lahig panglantaw ug kinasing-kasing nga nagtuman kanako, pasudlon ko siya sa yuta nga iyang giadtoan, ug ang iyang mga kaliwat makapuyo usab niana nga yuta. ");
INSERT INTO cebocb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Tungod kay anaa ang mga Canaanhon ug mga Amalekanhon magpuyo taliwala sa mga bukid, pamalik kamo ugma sa kamingawan, ngadto sa dalan paingon sa Pulang Dagat.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Hangtod kanus-a ba ang pagbagulbol niining daotang katawhan batok kanako? Nadungog ko ang mga bagulbol niining mga bagulbolan nga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Busa isulti kini kanila: ‘Nagsaad ako, ang buhi nga Ginoo, nga himuon ko diha kaninyo ang inyong gipangayo. ");
INSERT INTO cebocb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","30","Mangamatay kamo dinhi sa kamingawan, tungod kay nagbagulbol kamo kanako. Walay bisan usa kaninyong mga nag-edad ug 20 ka tuig pataas nga naapil sa pag-ihap nga makasulod sa yuta nga gipanumpa ko nga ihatag kaninyo, gawas lang kang Caleb nga anak ni Jefune ug kang Josue nga anak ni Nun. ");
INSERT INTO cebocb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Bahin sa inyong mga kabataan nga giingon ninyong bihagon, dad-on ko sila sa yuta nga inyong gisalikway ug sila ang makapahimulos niini. ");
INSERT INTO cebocb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Apan kamo mangamatay dinhi sa kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ang inyong mga kabataan mahisama sa mga tigbantay ug karnero nga magtuyok-tuyok dinhi sa kamingawan sulod sa 40 ka tuig ug mag-antos sila tungod sa inyong pagluib kanako, hangtod nga mangamatay kamong tanan dinhi sa kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ang mga tawong nangispiya sa yuta nagpabilin didto sulod sa 40 ka adlaw, busa sulod sa 40 ka tuig, ka tuig sa matag adlaw nga nagpabilin sila didto, mag-antos kamo tungod sa inyong mga sala, aron masayran ninyo kon unsa ako masuko kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ako, ang Ginoo, ang nag-ingon niini ug buhaton ko gayod kining mga butanga diha niining daotang katilingban nga naghiusa sa pagsupak kanako. Mangamatay silang tanan dinhi sa kamingawan!’ ” ");
INSERT INTO cebocb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Ang mga tawo nga gisugo ni Moises sa pagpangispiya nga mihatag ug dili maayo nga balita bahin sa yuta nga maoy hinungdan sa pagbagulbol sa mga Israelinhon, nangamatay sa sakit diha sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Sa 12 nga nangispiya, si Josue nga anak ni Nun ug si Caleb nga anak ni Jefune lang ang wala mamatay. ");
INSERT INTO cebocb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Sa dihang gisulti kini ni Moises sa tanang Israelinhon, nasubo gayod sila. ");
INSERT INTO cebocb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ug pagkasunod nga adlaw, sayo silang namangon aron pagtungas sa kabukiran. Miingon sila, “Nakaamgo kami nga nakasala kami, ug karon andam na kami sa pag-adto sa dapit nga gisaad sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Apan miingon si Moises, “Nganong gilapas ninyo ang mando sa Ginoo? Dili gayod kamo magmalampuson! ");
INSERT INTO cebocb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ayaw kamo paglakaw kay ang Ginoo wala mag-uban kaninyo. Mapildi lang kamo sa inyong mga kaaway. ");
INSERT INTO cebocb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Sa higayon nga makig-gira kamo sa mga Canaanhon ug sa mga Amalekanhon, mangamatay kamo. Dili mouban kaninyo ang Ginoo tungod sa pagsalikway ninyo kaniya.” ");
INSERT INTO cebocb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Apan nangadto gihapon sila sa kabukiran sa Canaan bisan wala mouban kanila si Moises ug ang Sudlanan sa Kasabotan sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Unya gisulong sila sa mga Amalekanhon ug sa mga Canaanhon nga nagpuyo niadtong kabukiran, ug napildi sila, ug gigukod pa sila kutob sa Horma. ");
INSERT INTO cebocb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Gisugo sa Ginoo si Moises ");
INSERT INTO cebocb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","nga isulti kini ngadto sa mga Israelinhon, “Kon atua na kamo sa yuta nga ihatag ko kaninyo nga inyong pagapuy-an, ");
INSERT INTO cebocb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","paghalad kamo kanako ug mga halad gikan sa inyong mga kahayopan. Paghalad kamo ug mga halad nga sinunog, mga halad sa pagtuman sa usa ka panaad, mga halad nga kinabubut-on, o mga halad sa panahon sa mga pista. Ang kahumot niini nga mga halad pinaagi sa kalayo makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Ang maghalad ug batan-ong karnero ingon nga halad nga sinunog alang kanako maghalad usab ug halad sa pagpasidungog. Kini nga halad sa pagpasidungog kinahanglan duha ka kilo nga maayong klasi sa harina nga sinagolan ug usa ka litrong mantika. Ug paubanan kini ug halad nga ilimnon nga usa ka litrong bino. ");
INSERT INTO cebocb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Kon hamtong nga laking karnero ang ihalad, paubanan kini ug halad sa pagpasidungog kanako nga upat ka kilo nga maayong klasi sa harina nga sinagolan ug usa ug tunga sa litrong mantika. ");
INSERT INTO cebocb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ug paubanan kini ug halad nga ilimnon nga usa ug tunga sa litrong bino. Ang kahumot niini nga halad makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Kon maghalad kamo ug nating torong baka isip halad nga sinunog o halad sa pagtuman sa usa ka panaad, o halad alang sa maayong relasyon sa Ginoo, ");
INSERT INTO cebocb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","kinahanglan maghalad usab ug halad sa pagpasidungog kanako: unom ka kilo nga maayong klasi sa harina nga sinagolan ug duha ka litrong mantika. ");
INSERT INTO cebocb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Paubanan pa gayod kini ug halad nga ilimnon nga duha ka litrong bino. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Mao kini ang inyong himuon kon maghalad kamo ug usa ka nating torong baka o hamtong nga laking karnero o batan-ong karnero o kanding. ");
INSERT INTO cebocb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Buhata kini alang sa matag-usa ka mananap bisag pila pa kabuok ang inyong ihalad. ");
INSERT INTO cebocb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Ang tanang mga Israelinhon nga maghalad ug mga halad pinaagi sa kalayo ingon nga humot nga halad nga makapalipay kanako kinahanglan mosunod nianang mga tulomanon. ");
INSERT INTO cebocb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kon ang mga langyaw nga nagpuyo uban kaninyo, permanente man o dili, gustong mohalad ug halad pinaagi sa kalayo ingon nga humot nga halad nga makapalipay kanako, kinahanglan mosunod usab nianang mga tulomanon. ");
INSERT INTO cebocb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kamong mga Israelinhon ug ang mga langyaw nga nagpuyo uban kaninyo managsama ra atubangan sa Ginoo ug parehas ra nga kasugoan ang tumanon ninyo. Kini nga mga tulomanon kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Parehas ra nga mga kasugoan ug mga tulomanon ang tumanon ninyo ug sa mga langyaw nga nagpuyo uban kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Gisugo pa gayod sa Ginoo si Moises ");
INSERT INTO cebocb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","nga isulti kini ngadto sa mga Israelinhon, “Kon atua na kamo sa yuta nga ihatag ko kaninyo, ");
INSERT INTO cebocb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ug sa dihang makakaon na kamo sa abot niini, kinahanglan maggahin kamo gikan niini aron ihalad kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Paghalad kamo ug pan gikan sa una ninyong minasa nga harina, ug ihatag kini ingon nga inyong halad gikan sa giokanan. ");
INSERT INTO cebocb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Maghatag kamo kanako niining maong halad hangtod sa umaabot nga mga henerasyon. ");
INSERT INTO cebocb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","“Apan pananglit wala tuyoa nga nakalapas kamo niining mga sugo nga gihatag ko kang Moises, ug wala usab tuyoa nga nakalapas ang inyong umaabot nga mga kaliwat, ");
INSERT INTO cebocb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ug wala masayod niini ang katilingban, ang tibuok katilingban maghalad ug usa ka nating torong baka isip halad nga sinunog. Halad kini nga ang kahumot makapalipay kanako. Paubani usab ninyo kini sa mga gikinahanglang halad nga sama sa halad sa pagpasidungog, halad nga ilimnon, ug usa ka laking kanding isip halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Unya mag-ampo ang pari aron mahinloan ang tibuok katilingban gikan sa ilang sala. Ug pasayloon ko sila kay dili man kadto tinuyo, ug nagdala usab sila ug halad nga sinunog ug halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Pasayloon ko ang tibuok katilingban sa Israel, apil ang mga langyaw nga nagpuyo uban kanila, kay ang tanan nadalahig sa maong sala nga dili tinuyo. ");
INSERT INTO cebocb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Apan kon usa lang ka tawo ang nakasala nga wala tuyoa, magdala siya ug usa ka bayeng kanding nga usa ka tuig ang edad alang sa halad sa paghinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ug mag-ampo ang pari sa akong presensya aron mahinloan siya gikan sa iyang sala nga dili tinuyo, ug unya pasayloon ko siya. ");
INSERT INTO cebocb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Usa lang ang tulomanon alang niadtong nakasala nga wala tuyoa, Israelinhon man siya o langyaw nga nagpuyo uban kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Apan si bisan kinsa nga nagpakasala nga tinuyo, Israelinhon man siya o dili, nagpasipala kanako. Kinahanglang dili na siya isipon nga inyong sakop, ");
INSERT INTO cebocb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","tungod kay gisalikway niya ang akong pulong ug gilapas niya ang akong sugo. Ayaw gayod ninyo siya ilha nga inyong sakop. Manubag siya sa iyang sala.” ");
INSERT INTO cebocb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Samtang didto sa kamingawan ang mga Israelinhon, aduna silay nakitang tawo nga nangahoy sa Adlaw nga Igpapahulay. ");
INSERT INTO cebocb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Gidala sa mga nakakita ang maong tawo ngadto kang Moises ug kang Aaron ug sa tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Gipriso nila siya, kay wala pa sila makasiguro kon unsay angay nilang himuon kaniya. ");
INSERT INTO cebocb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Unya miingon ang Ginoo kang Moises, “Kinahanglan nga patyon ang maong tawo! Batohon siya sa tibuok katilingban didto sa gawas sa kampo.” ");
INSERT INTO cebocb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Busa gidala siya sa mga tawo sa gawas sa kampo ug gibato hangtod nga namatay, sumala sa gisugo sa Ginoo kang Moises. ");
INSERT INTO cebocb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Gisugo sa Ginoo si Moises ");
INSERT INTO cebocb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","nga isulti kini ngadto sa mga Israelinhon, “Taori ninyo ug mga gaway-gaway ang sidsid sa inyong mga bisti ug butangi ninyo kini ug higot nga asul. Kinahanglan nga sundon ninyo kini hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Kini nga mga gaway-gaway mopahinumdom kaninyo sa tanan kong mga kasugoan aron tumanon ninyo kini ug dili ang inyo lang gusto ang inyong himuon. ");
INSERT INTO cebocb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Pinaagi niining mga gaway-gaway hinumdoman ninyo ang pagtuman sa akong kasugoan, ug igahin ninyo ang inyong kaugalingon alang kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ako ang Ginoo nga inyong Dios nga nagpagawas kaninyo gikan sa Ehipto aron mahimong inyong Dios. Ako ang Ginoo nga inyong Dios.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Karon, nagrebelde kang Moises si Kora nga anak ni Izhar, nga kaliwat ni Kohat, nga anak ni Levi. Kauban niya sa pagrebelde si Datan ug si Abiram nga mga anak ni Eliab, ug si On nga anak ni Pelet nga pulos gikan sa tribo ni Ruben. Adunay kauban pa silang 250 ka inila ug pinili nga lalaking mga pangulo sa katilingban sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Naghiusa sila sa pagsupak kang Moises ug kang Aaron, ug miingon, “Sobra na kining inyong gibuhat kanamo! Nganong ipalabaw man ninyo ang inyong kaugalingon nga ang tibuok katilingban man sa Israel ang gipili ug giubanan sa Ginoo?” ");
INSERT INTO cebocb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Pagkadungog niini ni Moises mihapa siya. ");
INSERT INTO cebocb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","6","Unya miingon siya kang Kora ug sa tanang sumusunod niini, “Ugma sa buntag ipadayag sa Ginoo kon kinsa ang tinuod nga iya, ug kinsa ang iyang gipili nga mag-alagad kaniya isip pari. Paduolon niya sa iyang presensya ang iyang gipili. Busa mao kini ang inyong buhaton ugma: Pagkuha kamo ug mga sudlanan sa insenso. ");
INSERT INTO cebocb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Butangi ninyo kinig baga ug insenso, ug dad-a sa presensya sa Ginoo. Unya makita nato kon kinsa gayod ang pilion sa Ginoo nga mag-alagad kaniya. Kamong mga Levita mao ang nag-abusar!” ");
INSERT INTO cebocb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Miingon pa gayod si Moises kang Kora, “Paminaw kamo, mga Levita! ");
INSERT INTO cebocb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Dili pa ba igo alang kaninyo nga sa tanang mga Israelinhon kamo ang gipili sa Dios sa Israel aron makaduol sa iyang presensya sa pag-alagad diha sa Tolda sa Ginoo ug sa pag-alagad alang sa katilingban? ");
INSERT INTO cebocb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Gipili niya kamo nga mag-alagad kaniya, unya karon gusto pa ninyo nga mahimong pari? ");
INSERT INTO cebocb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Si kinsa man si Aaron nga magbagulbol man kamo batok kaniya? Ang tinuod, ikaw ug ang tanan nimong mga sumusunod naghiusa batok sa Ginoo ug dili kang Aaron.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Pagkahuman, gipatawag ni Moises si Datan ug si Abiram, nga mga anak ni Eliab. Apan miingon sila, “Dili kami moanha! ");
INSERT INTO cebocb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Dili pa ba igo nga gikuha mo kami gikan sa Ehipto diin ang yuta maayo ug mabungahon aron patyon lang dinhi sa kamingawan? Unya karon gusto ka pang magpahari-hari kanamo? ");
INSERT INTO cebocb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Gawas pa niana, wala mo kami dad-a sa yuta nga maayo ug mabungahon, o hatagig mga uma o ubasan nga among panag-iyahon. Karon, gusto mo pa gayod kaming tontohon? Dili kami moanha kanimo!” ");
INSERT INTO cebocb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Nasuko pag-ayo si Moises ug miingon siya sa Ginoo, “Ayaw dawata ang ilang mga halad. Wala ako makasala kang bisan kinsa kanila; wala akoy gikuha kanila nga bisan usa ka asno.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Miingon si Moises kang Kora, “Ugma, ikaw ug tanan nimong mga sumusunod, pangadto kamo sa presensya sa Ginoo didto sa Tolda nga Tagboanan, ug si Aaron moadto usab didto. ");
INSERT INTO cebocb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ang kada usa sa imong 250 ka mga sumusunod padad-a ug sudlanan sa insenso. Pabutangi kini ug insenso ug ihalad sa Ginoo. Kamo ni Aaron magdala usab ug tagsa ka sudlanan sa insenso.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Busa ang matag-usa nagdala ug sudlanan sa insenso ug gibutangan kinig insenso ug baga, ug mibarog sila uban kang Moises ug kang Aaron didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ang tibuok katilingban nga gikombinsi ni Kora nga magrebelde kang Moises ug Aaron nagtigom usab didto sa pultahan sa Tolda nga Tagboanan. Unya ang gamhanang presensya sa Ginoo nagpakita sa tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Palayo kamo gikan niining mga tawhana kay pamatyon ko sila dayon.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Apan mihapa si Moises ug si Aaron ug miingon, “O Dios nga tinubdan sa kinabuhi sa tanang katawhan, masuko ka ba diay sa tibuok katilingban nga usa man lang ka tawo ang nakasala?” ");
INSERT INTO cebocb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ingna ang katilingban nga magpalayo sila sa mga tolda nila ni Kora, Datan, ug Abiram.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Giadtoan ni Moises si Datan ug si Abiram, ug nagsunod kaniya ang mga tigdumala sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Dayon giingnan niya ang katilingban, “Palayo kamo sa mga tolda niining daotang mga tawo! Ayaw kamo paghikap sa bisan unsa nga ilang gipanag-iyahan, kay kon himuon ninyo kini laglagon kamo uban kanila tungod sa tanan nilang sala.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Busa nagpalayo gikan sa mga tolda nila ni Kora, Datan, ug Abiram ang mga tawo. Nanggawas si Datan ug si Abiram ug nanindog sa pultahan sa ilang mga tolda uban sa ilang mga asawa ug mga kabataan. ");
INSERT INTO cebocb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Miingon si Moises sa mga tawo, “Pinaagi niini mahibaloan ninyo nga ang Ginoo mao ang nagpadala kanako sa paghimo niining mga butanga ug dili kini akong kagustohan! ");
INSERT INTO cebocb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kon mamatay sa natural nga kamatayon kining mga tawhana, nagpasabot kini nga wala ako ipadala sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Apan kon maghimo ang Ginoo ug kahibulongang butang, ug mapikas ang yuta ug lamyon sila nga buhi uban sa tanan nilang kabtangan ngadto sa kalibotan sa mga patay, mahibaloan ninyo nga kining mga tawhana nagsalikway sa Ginoo.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Human ug sulti ni Moises, napikas ang yuta nga gibarogan ni Datan ug ni Abiram, ");
INSERT INTO cebocb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ug gilamoy sila ug ang ilang mga pamilya, uban ang tanang mga sumusunod ni Kora ug ang tanan nilang kabtangan. ");
INSERT INTO cebocb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Gilamoy silang tanan nga buhi lakip ang tanan nilang kabtangan. Unya mibalik ug tak-om ang yuta ug nahanaw sila sa katilingban. ");
INSERT INTO cebocb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Sa dihang nabati ang ilang pagpaniyagit, mipahilayo ang tanang mga Israelinhon nga nagpalibot ug miingon, “Basig lamyon usab kita sa yuta!” ");
INSERT INTO cebocb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Unya nagpadala ug kalayo ang Ginoo, ug gilamoy sa kalayo ang 250 ka mga sumusunod ni Kora nga naghalad ug insenso. ");
INSERT INTO cebocb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ingna si Eleazar nga pari, nga anak ni Aaron, nga kuhaon niya ang mga sudlanan sa insenso gikan sa kalayo, kay balaan kini nga sudlanan. Ingna usab siya nga ikatag sa layo ang mga baga. ");
INSERT INTO cebocb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Bahin sa mga sudlanan nga gikan niining mga tawo nga nangamatay tungod sa ilang mga sala, ipapipi kini hangtod pwede na itaklap sa halaran, kay gihalad kini ngadto sa Ginoo ug nahimo kining balaan. Kini nga taklap sa halaran mahimong usa ka pasidaan alang sa mga Israelinhon.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","40","Busa sumala sa gisugo sa Ginoo pinaagi kang Moises, gipanguha ni Eleazar ang bronsi nga mga sudlanan sa insenso nga gipangdala niadtong mga nangasunog, ug gipapipi niya kini aron ihaklap sa halaran. Usa kini ka pasidaan alang sa mga Israelinhon, nga walay bisan usa kanila nga makaduol sa halaran aron sa pagsunog ug insenso sa presensya sa Ginoo gawas lang sa mga kaliwat ni Aaron, aron dili mahitabo kanila ang nahitabo kang Kora ug sa mga sumusunod niini. ");
INSERT INTO cebocb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Apan pagkasunod adlaw, nagbagulbol na usab ang tibuok katilingban kang Moises ug kang Aaron. Miingon sila, “Gipamatay ninyo ang katawhan sa Ginoo!” ");
INSERT INTO cebocb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Samtang nagtigom sila aron sa pagdala sa ilang reklamo ngadto kang Moises ug kang Aaron, miatubang sila sa Tolda nga Tagboanan ug nakita nila nga natabonan kini sa panganod ug nagpakita ang gamhanang presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Unya, si Moises ug si Aaron miadto sa atubangan sa Tolda ");
INSERT INTO cebocb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ug miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Palayo kamo nianang mga tawhana kay laglagon ko sila karon dayon.” Mihapa dayon silang duha. ");
INSERT INTO cebocb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Unya miingon si Moises kang Aaron, “Kuhaa ang imong sudlanan sa insenso ug butangi kinig insenso ug baga gikan sa halaran. Ug adto dayon sa katilingban ug paghalad sa Ginoo aron maluwas sila sa ilang mga sala, kay nasuko na ang Ginoo ug nagsugod na ang katalagman.” ");
INSERT INTO cebocb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Busa gituman ni Aaron ang gisugo ni Moises, ug midagan siya ngadto sa taliwala sa katilingban. Nagsugod na ang katalagman diha sa mga tawo, apan gihalad gihapon ni Aaron ang insenso aron mapasaylo ang mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Mibarog siya sa tunga-tunga sa mga tawong nangamatay ug sa mga buhi, dayon miundang ang katalagman. ");
INSERT INTO cebocb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Apan 14,700 ang nangamatay tungod sa katalagman walay labot niadtong namatay tungod kang Kora. ");
INSERT INTO cebocb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Unya mibalik si Aaron kang Moises didto sa pultahan sa Tolda nga Tagboanan, tungod kay miundang na man ang katalagman. ");
INSERT INTO cebocb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ingna ang mga Israelinhon nga mohatag kanimo ug 12 ka baston, usa sa matag pangulo sa matag tribo, ug pabutangi kini sa ilang tagsa-tagsa ka ngalan. ");
INSERT INTO cebocb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Diha sa baston sa tribo ni Levi, isulat ang ngalan ni Aaron kay kinahanglang adunay usa ka baston sa kada pangulo sa tribo. ");
INSERT INTO cebocb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ibutang kining tanan diha sa Tolda nga Tagboanan, atubangan sa Sudlanan sa Kasugoan diin ako nakigkita kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Unya manalingsing ang baston sa tawong akong pilion nga mag-alagad kanako isip pari. Niining paagiha mahunong na ang pagbagulbol sa mga Israelinhon batok kaninyo ni Aaron.” ");
INSERT INTO cebocb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Busa gisultihan ni Moises ang mga Israelinhon, ug ang kada pangulo mihatag kaniya ug baston. Ang mga baston 12 tanan, ug ang usa niini kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Gibutang ni Moises ang mga baston sa presensya sa Ginoo didto sa Tolda, nga nahimutangan sa Sudlanan sa Kasugoan. ");
INSERT INTO cebocb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Pagkaugma misulod si Moises sa Tolda nga gibutangan sa Sudlanan sa Kasabotan ug nakita niya nga ang baston ni Aaron, nga nagrepresentar sa tribo ni Levi, wala lang nanalingsing kondili namotot pa, namulak, ug namunga ug almond. ");
INSERT INTO cebocb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Unya gipagawas ni Moises ang tanang baston gikan sa presensya sa Ginoo ug gipakita sa tanang mga Israelinhon. Gitan-aw nila kini, ug gikuha sa kada pangulo sa tribo ang iyang baston. ");
INSERT INTO cebocb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Unya miingon ang Ginoo kang Moises, “Ibalik ang baston ni Aaron sa atubangan sa Sudlanan sa Kasugoan aron mahimo kining pasidaan sa mga masinupakon nga mangamatay sila kon dili sila moundang sa pagbagulbol batok kanako.” ");
INSERT INTO cebocb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Gituman ni Moises ang gisugo kaniya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Miingon ang mga Israelinhon kang Moises, “Kon mao kana mangamatay gayod kaming tanan! ");
INSERT INTO cebocb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Kay bisan kinsa nga mopaduol lang sa Tolda sa Ginoo mamatay man! Mangamatay gayod diay kaming tanan?” ");
INSERT INTO cebocb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Miingon ang Ginoo kang Aaron, “Ikaw ug ang imong mga anak nga lalaki ug ang imong mga paryente nga Levita mao ang responsable sa sala nga inyong mabuhat sa inyong pag-alagad diha sa balaang puloy-anan. Apan ikaw lang ug ang imong mga anak nga lalaki ang responsable sa sala nga inyong mabuhat nga adunay kalabotan sa inyong pagkapari. ");
INSERT INTO cebocb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kon ang imong mga anak ug ikaw mag-alagad sa Tolda diin nahimutang ang Kasugoan, patabanga ninyo ang inyong mga paryente nga gikan sa tribo ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Magtrabaho sila ubos sa imong pagmando ug himuon nila ang tanan nilang buluhaton diha sa Tolda, apan kinahanglan dili sila manghilabot sa balaan nga mga kagamitan sa Balaang Dapit o sa halaran, kay kon buhaton nila kana mangamatay sila ug apil kamo. ");
INSERT INTO cebocb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Motabang sila kanimo, ug responsibilidad nila ang pag-atiman sa Tolda nga Tagboanan ug ang paghimo sa tanang buluhaton niini. Kinahanglan nga walay lain nga motabang kaninyo gawas sa kaliwat ni Levi. ");
INSERT INTO cebocb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Ikaw ang responsable sa pag-atiman sa Balaang Dapit ug sa halaran, aron dili ako masuko pag-usab sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ako mismo ang nagpili sa kaigsoonan nimo nga mga kaliwat ni Levi gikan sa mga Israelinhon aron mahimong imong katabang. Gidedikar sila kanako sa pag-alagad diha sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Apan ikaw lang ug ang imong mga anak nga lalaki ang makaalagad isip mga pari. Kamo lang ang makahimo sa mga buluhaton nga adunay kalabotan sa halaran ug sa Labing Balaang Dapit. Gawas kaninyo, si bisan kinsa nga mohimo niini, pagapatyon. Gasa ko kaninyo ang inyong pagkapari.” ");
INSERT INTO cebocb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Unya miingon ang Ginoo kang Aaron, “Ako mismo ang nagpili kanimo nga magdumala sa balaan nga mga halad nga ginahalad sa mga Israelinhon kanako. Gihatag ko kini kanimo ug sa imong mga anak nga lalaki ingon nga inyong bahin, karon ug hangtod sa kahangtoran. ");
INSERT INTO cebocb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Adunay bahin kamo sa mga balaan nga halad nga wala sunoga nga ginahalad sa mga tawo kanako ingon nga balaan nga mga halad. Lakip na niini ang halad isip pagpasidungog, halad aron mahimong hinlo ang tawo, ug halad isip bayad sa sala. Mao kini ang imong bahin ug sa imong mga anak nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kan-a ninyo kini diha sa balaan kaayo nga dapit. Tanang lalaki makahimo sa pagkaon niini, ug isipa ninyo kini nga balaan. ");
INSERT INTO cebocb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Inyo usab ang mga binayaw nga halad sa mga Israelinhon. Gihatag ko kini kanimo ug sa imong kaliwat isip inyong bahin hangtod sa kahangtoran. Makakaon niini si bisan kinsa sa imong pamilya nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Gihatag ko usab kaninyo ang mga maayong produkto nga ginahalad sa mga Israelinhon gikan sa ilang unang abot: lana, bino, ug trigo. ");
INSERT INTO cebocb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mainyo ang tanang unang abot sa yuta nga ilang ginahalad kanako. Makakaon niini si bisan kinsa sa imong pamilya nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Ang tanang butang sa Israel nga gihalad kanako sa hingpit mainyo. ");
INSERT INTO cebocb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ang tanang kamagulangang anak nga lalaki, tawo man o mananap, nga ginahalad kanako inyo usab. Apan kinahanglang lukaton gayod ninyo ang mga kamagulangang anak nga lalaki ug ang mga kamagulangang mananap nga ginaisip nga hugaw. ");
INSERT INTO cebocb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Lukata ninyo kini pag-edad niini ug usa ka bulan sa kantidad nga lima kabuok nga pilak, basi sa gibug-aton sa pilak diha sa kilohan nga ginagamit sa mga pari. ");
INSERT INTO cebocb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Apan ayaw ninyo lukata ang kamagulangan nga baka, karnero o kanding, kay akoa na kini. Ihawa ninyo kini ug iwisik sa halaran ang dugo niini ug sunoga ang mga tambok isip halad nga pinaagi sa kalayo. Ang kahumot niini nga halad makapalipay kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Inyo ang mga karne niini, ingon man ang dughan ug ang tuo nga paa sa halad nga binayaw. ");
INSERT INTO cebocb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Oo, gihatag ko kaninyo kining tanang mga balaang halad nga binayaw sa mga Israelinhon kanako. Alang kini kanimo ug sa imong mga kaliwat ingon nga inyong bahin hangtod sa kahangtoran. Kini ang kasabotan ko kanimo ug sa imong mga kaliwat ug dili kini mausab bisan kanus-a.” ");
INSERT INTO cebocb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Miingon pa gayod ang Ginoo kang Aaron, “Kamong mga pari walay mapanunod nga yuta sa Israel, kay ako mismo ang motagbo sa inyong mga panginahanglanon. ");
INSERT INTO cebocb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Bahin sa mga Levita, bayran ko sila sa ilang serbisyo sa Tolda. Ihatag ko kanila ang tanang ikapulo nga ihatag sa mga Israelinhon ingon nga ilang panulondon. ");
INSERT INTO cebocb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Gikan karon, wala nay mga Israelinhon nga makaduol sa Tolda nga Tagboanan gawas lang sa mga pari ug sa mga Levita, kay kon moduol sila, manubag sila sa ilang sala ug mamatay. ");
INSERT INTO cebocb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ang mga Levita mao ang mangunay sa paghimo sa mga buluhaton diha sa Tolda nga Tagboanan, ug manubag sila sa mahimo nilang kalapasan niini. Kini nga tulomanon kinahanglan nga tumanon ninyo hangtod sa umaabot nga mga henerasyon. Ang mga Levita walay mapanunod nga yuta sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Hinuon, ihatag ko kanila ingon nga ilang bahin ang mga ikapulo nga ihatag sa mga Israelinhon isip halad kanako. Mao kana nga miingon ako nga ang mga Levita walay mapanunod nga yuta sa Israel.” ");
INSERT INTO cebocb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Miingon ang Ginoo kang Moises ");
INSERT INTO cebocb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","nga isulti kini ngadto sa mga Levita, “Kon madawat ninyo gikan sa mga Israelinhon ang ikapulo nga ihatag kaninyo ingon nga inyong bahin, kinahanglan nga maghatag usab kamo sa inyong ikapulo gikan sa maong ikapulo ingon nga halad kanako. ");
INSERT INTO cebocb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Isipon ko kini ingon nga inyong halad gikan sa mga abot sa giokan o bino gikan sa pug-anan sa ubas. ");
INSERT INTO cebocb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Niining paagiha makahatag usab kamo ug halad kanako gikan sa tanang ikapulo nga inyong madawat gikan sa mga Israelinhon. Ug ang akong bahin, nga mao ang ikapulo niini, ihatag ninyo kang Aaron nga pari. ");
INSERT INTO cebocb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kinahanglan nga ang akong bahin mao ang labing maayong bahin sa tanang ihatag kaninyo. ");
INSERT INTO cebocb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Sultihi ang mga Levita, ‘Kon mahalad na ninyo ang labing maayong bahin, isipon ko kini ingon nga inyong halad gikan sa giokan o pug-anan sa ubas. ");
INSERT INTO cebocb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Mahimong kan-on ninyo ug sa inyong pamilya ang inyong bahin sa bisan asa nga dapit, kay inyo kanang sweldo sa inyong pag-alagad sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Dili kamo makasala sa inyong pagkaon niini kon nahalad na ninyo ang labing maayo nga bahin niini ngadto sa Ginoo. Apan siguroha ninyo nga dili ninyo mapasipalahan ang balaan nga mga halad sa mga Israelinhon, aron dili kamo mamatay.’ ” ");
INSERT INTO cebocb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ania pay usa ka tulomanon nga buot kong inyong tumanon: Ingna ang mga Israelinhon nga dad-an kamo ug usa ka pula nga bayeng baka nga walay depekto ug wala pa sukad magamit sa pagdaro. ");
INSERT INTO cebocb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ihatag ninyo kini kang Eleazar nga pari, ug unya dad-on kini ngadto sa gawas sa kampo ug ihawon diha sa iyang atubangan. ");
INSERT INTO cebocb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Unya magkuha si Eleazar ug dugo pinaagi sa iyang tudlo ug iwisik niya kini sa makapito ngadto sa atubangan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ug samtang nagtan-aw si Eleazar, sunogon ang baka, ang panit, unod, dugo, ug ang tinai. ");
INSERT INTO cebocb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Unya magkuha si Eleazar ug kahoyng sedro, usa ka sanga sa tanom nga isopo, ug pula nga higot, ug iitsa kining tanan ngadto sa ginasunog nga baka. ");
INSERT INTO cebocb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Pagkahuman niana kinahanglan nga labhan ni Eleazar ang iyang bisti ug maligo siya. Human niini makasulod na si Eleazar sa kampo, apan isipon siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ang tawo nga nagsunog sa baka kinahanglan nga manglaba usab sa iyang bisti ug maligo ug isipon usab siya nga hugaw hangtod sa pagsalop sa adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ang tawo nga ginaisip nga hinlo maoy magkuha sa abo sa baka, ug ibutang niya kini didto sa usa ka dapit nga ginaisip nga hinlo, sa gawas sa kampo. Tipigan kini didto aron gamiton sa katilingban sa Israel nga pangsagol sa tubig nga ginagamit sa pagpanghinlo. Buhaton kini nga seremonya aron sa pagwagtang sa sala. ");
INSERT INTO cebocb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ang tawo nga nagkuha sa abo sa baka kinahanglan usab nga manglaba sa iyang bisti, ug isipon usab siya nga hugaw hangtod sa pagsalop sa adlaw. Kini nga tulomanon kinahanglan tumanon hangtod sa kahangtoran sa mga Israelinhon ug sa mga langyaw nga nagpuyo uban kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Si bisan kinsa nga makahikap ug patay isipon nga hugaw sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Kinahanglan nga sa ikatulo ug ikapito ka adlaw, hinloan niya ang iyang kaugalingon sa tubig nga ginagamit sa pagpanghinlo, unya maisip na siyang hinlo. Apan kon dili siya manghinlo sa ikatulo ug ikapito ka adlaw, dili siya isipon nga hinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Si bisan kinsa nga makahikap ug patay ug dili manghinlo, nagpasipala sa Tolda sa Ginoo. Kinahanglan nga kanang tawhana dili isipon nga sakop ninyo. Ug tungod kay wala siya mawisiki sa tubig nga ginagamit sa pagpanghinlo, magpabilin siyang hugaw. ");
INSERT INTO cebocb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Mao kini ang patakaran nga sundon kon adunay tawo nga mamatay sulod sa usa ka tolda: Si bisan kinsa nga mosulod sa tolda nga adunay namatay o kaha anaa nang daan sulod sa tolda panahon sa pagkamatay, isipon nga hugaw sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Isipon usab nga hugaw ang bisan unsang sudlanan nga walay taklob nga anaa sulod sa tolda. ");
INSERT INTO cebocb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Isipon usab nga hugaw sulod sa pito ka adlaw si bisan kinsa nga atua sa gawas sa kampo nga nakahikap ug tawo nga namatay pinaagi sa espada o kaha namatay sa natural nga kamatayon. Mao usab ang tawo nga nakahikap ug bukog sa patayng tawo o sa usa ka lubnganan. ");
INSERT INTO cebocb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Aron makuha ang pagkahugaw, kinahanglan magkuha sila niadtong abo sa baka nga gihalad alang sa paghinlo. Isulod nila kini sa usa ka sudlanan ug butangan ug tubig. ");
INSERT INTO cebocb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Unya ang usa ka tawo nga ginaisip nga hinlo magkuha ug usa ka sanga sa tanom nga isopo ug ituslob niya kini niadtong tubig ug iwisik ngadto sa tolda ug sa tanang kagamitan niini, ug sa mga tawo nga atua sa tolda. Wisikan usab ang tawo nga nakahikap ug bukog sa patayng tawo, lubnganan, o kaha tawo nga namatay pinaagi sa espada o sa natural lang nga kamatayon. ");
INSERT INTO cebocb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Sa ikatulo ug ikapito ka adlaw, wisikan sa tawong giisip nga hinlo ang tawong giisip nga hugaw. Ug sa ikapito ka adlaw, ang tawo nga gihinloan kinahanglang labhan niya ang iyang bisti ug maligo, ug nianang gabhiona isipon na siyang hinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Apan kon ang tawo nga hugaw dili manghinlo, kinahanglan dili siya isipon nga inyong sakop kay gipasipalahan niya ang Tolda sa Ginoo. Ug tungod kay wala siya mawisiki sa tubig nga ginagamit sa pagpanghinlo, hugaw pa gihapon siya. ");
INSERT INTO cebocb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kini nga tulomanon kinahanglan tumanon nila hangtod sa kahangtoran. “Ang tawo nga nagwisik sa tubig nga ginagamit sa pagpanghinlo kinahanglan usab nga manglaba sa iyang bisti. Isipon nga hugaw hangtod sa pagsalop sa adlaw ang si bisan kinsa nga nakahikap sa tubig nga ginagamit sa pagpanghinlo. ");
INSERT INTO cebocb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ang bisan unsa nga mahikapan sa tawong hugaw mahimong hugaw, ug ang si bisan kinsa nga makahikap niini mahimong hugaw usab hangtod sa pagsalop sa adlaw.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Sa unang bulan, miabot ang tibuok katilingban sa Israel didto sa kamingawan sa Zin, ug nagkampo sila sa Kadesh. Didto namatay si Miriam ug didto usab siya gilubong. ");
INSERT INTO cebocb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Walay tubig niadtong lugara, busa naghiusa ang mga tawo batok kang Moises ug kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Gibasol nila si Moises ug miingon, “Maayo pag namatay na lang kami uban sa among mga katagilungsod nga nangamatay niadto sa presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nganong gidala mo man kami nga katilingban sa Ginoo dinhi sa kamingawan? Aron lang ba mangamatay uban sa among mga mananap? ");
INSERT INTO cebocb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nganong gipagawas mo kami gikan sa Ehipto ug gidala niining walay pulos nga dapit diin walay trigo, igos, ubas o pomegranata; ug wala pa gayoy tubig nga mainom?” ");
INSERT INTO cebocb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mibiya si Moises ug si Aaron gikan sa katilingban, ug miadto sa pultahan sa Tolda nga Tagboanan ug mihapa sa pag-ampo. Unya nagpakita kanila ang gamhanang presensya sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kuhaa ang baston ug tigoma ninyo ni Aaron nga imong igsoon ang tibuok nga katilingban. Ug samtang nagtan-aw sila, sultihi ang bato nga mohatag ug tubig, ug motubod kini aron mahatagan ninyog tubig ang katawhan aron makainom sila ug ang ilang kahayopan.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Busa gikuha ni Moises ang baston gikan sa presensya sa Ginoo, sumala sa gisugo sa Ginoo kaniya. ");
INSERT INTO cebocb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Unya gitigom nila ni Aaron ang tibuok nga katilingban atubangan sa bato, ug miingon si Moises kanila, “Pamati kamong mga masinupakon! Kinahanglan ba gayod nga hatagan namo kamo ug tubig gikan niining bato aron lang motuo kamo?” ");
INSERT INTO cebocb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Unya gibayaw ni Moises ang iyang baston ug gihapak sa makaduha ang bato, ug mibuswak ang makusog nga tubig. Ug nanginom ang katilingban ug ang ilang mga kahayopan. ");
INSERT INTO cebocb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Apan miingon ang Ginoo kang Moises ug kang Aaron, “Tungod kay wala kamo mosalig kanako aron sa pagpakita sa akong pagkabalaan atubangan sa mga Israelinhon, dili kamo ang mangulo sa pagdala niining katilingban ngadto sa yuta nga ihatag ko kanila.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Kini nga dapit gitawag ug Meriba, kay nakiglalis ang mga Israelinhon sa Ginoo dinhi niini nga dapit; ug dinhi usab gipakita sa Ginoo kanila ang iyang pagkabalaan. ");
INSERT INTO cebocb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Sa didto pa ang mga Israelinhon sa Kadesh, nagpadala si Moises ug mga mensahero ngadto sa hari sa Edom uban sa mensahe nga nag-ingon: “Kini nga mensahe gikan sa imong mga paryente, ang katawhan sa Israel: Nahibalo ka sa tanang pag-antos nga among naagian. ");
INSERT INTO cebocb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ang among mga katigulangan nangadto sa Ehipto, ug dugay kaming nagpuyo didto. Gipaantos kami ug ang among mga katigulangan sa mga Ehiptohanon, ");
INSERT INTO cebocb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","apan nangayo kami ug tabang sa Ginoo ug gipatalinghogan niya kami. Gipadad-an niya kami ug anghel nga maoy nagpagawas kanamo gikan sa Ehipto. “Karon, ania kami dinhi sa Kadesh, ang lungsod nga duol sa imong teritoryo. ");
INSERT INTO cebocb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Kon mahimo, tugoti kami sa pag-agi sa imong yuta. Dili kami molatas sa kaumahan o sa ubasan, ni moinom gikan sa atabay. Mosubay lang kami sa dakong dalan ug dili kami motipas hangtod nga makagawas kami sa imong teritoryo.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Apan mao kini ang tubag sa hari sa Edom: “Dili kamo mahimong moagi dinhi. Kon moagi kamo, atakihon namo kamo ug pamatyon.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Mitubag ang mga Israelinhon: “Mosubay lang kami sa dakong dalan. Kon makainom man sa inyong tubig ang among kahayopan ug kami, bayran namo kini. Tugoti lang kami nga moagi diha sa imong yuta, ug wala nay lain pa.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mitubag pag-usab ang hari sa Edom: “Ayaw kamo pag-agi dinhi.” Unya gitigom sa hari sa Edom ang iyang lig-ong puwersa sa kasundalohan aron makig-gira sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Tungod kay dili man magpaagi sa ilang teritoryo ang mga taga-Edom, milikay na lang ang mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Mibiya ang tibuok katilingban sa Israel gikan sa Kadesh ug nangadto sa Bukid sa Hor. ");
INSERT INTO cebocb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Didto sa Bukid sa Hor, duol sa utlanan sa Edom, miingon ang Ginoo kang Moises ug kang Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Naabot na ang panahon nga iipon ka na Aaron ngadto sa imong mga paryente nga nangamatay na. Dili ka na makasulod sa yuta nga ihatag ko sa mga Israelinhon tungod kay misupak kamong duha ni Moises sa akong sugo didto sa tubig sa Meriba. ");
INSERT INTO cebocb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Karon Moises, dad-a si Aaron ug ang iyang anak nga si Eleazar sa Bukid sa Hor. ");
INSERT INTO cebocb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Unya huboi si Aaron sa iyang bisti sa pagkapari ug ipasul-ob kini sa iyang anak nga si Eleazar, kay mamatay na si Aaron didto sa bukid.” ");
INSERT INTO cebocb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Gituman ni Moises ang gisugo kaniya sa Ginoo. Mitungas sila sa Bukid sa Hor samtang nagtan-aw ang tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Unya gihubo ni Moises ang bisti ni Aaron ug gipasul-ob niya kini kang Eleazar. Ug namatay si Aaron didto sa ibabaw sa bukid. Unya milugsong si Moises ug si Eleazar. ");
INSERT INTO cebocb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Sa dihang nasayran sa tibuok katilingban nga patay na si Aaron, nagsubo ang tanang mga Israelinhon alang kang Aaron sulod sa 30 ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ang Canaanhon nga hari sa Arad nga nagpuyo sa Negev nakadungog nga nagpadulong ang mga Israelinhon agi sa dalan sa Atarim. Busa giataki niya sila ug gibihag ang uban kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Unya nanumpa ang mga Israelinhon ngadto sa Ginoo, “Kon itugyan nimo sa among mga kamot kining mga tawhana, laglagon namo sa hingpit ang ilang mga lungsod ingon nga halad kanimo.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Gipatalinghogan sa Ginoo ang pag-ampo sa mga Israelinhon ug gitugyan niya kanila ang mga Canaanhon. Gilaglag sila sa hingpit sa mga Israelinhon lakip ang ilang mga lungsod, busa gitawag kadto nga lungsod ug Horma. ");
INSERT INTO cebocb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Gikan sa Bukid sa Hor, milakaw ang mga Israelinhon agi sa dalan paingon sa Pulang Dagat, libot sa yuta sa Edom. Apan gipul-an ang mga tawo sa ilang lakaw, ");
INSERT INTO cebocb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","busa mireklamo sila sa Dios ug kang Moises. Miingon sila, “Nganong gipagawas mo pa kami gikan sa Ehipto aron mangamatay lang dinhi sa kamingawan? Walay pagkaon ug tubig dinhi! Ug giluod na kami niining walay lami nga manna.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Busa, gipadad-an sila sa Ginoo ug mga bitin nga malala ug gipamaak sila, ug daghan ang nangamatay kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ug nangadto ang mga tawo kang Moises ug miingon, “Nakasala kami kay nagsulti kami batok sa Ginoo ug kanimo. I-ampo sa Ginoo nga ipahilayo niya kining mga bitin gikan kanamo.” Busa nag-ampo si Moises alang sa mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Miingon ang Ginoo kang Moises, “Paghimo ug bronsi nga bitin ug ibutang kini sa tumoy sa usa ka poste. Si bisan kinsa nga mapaakan ug bitin dili mamatay kon motan-aw lang niining bronsi nga bitin.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Busa naghimo si Moises ug bronsi nga bitin ug gibutang kini sa tumoy sa usa ka poste. Ug si bisan kinsa nga napaakan ug bitin motan-aw lang niining bronsi nga bitin ug dili kini mamatay. ");
INSERT INTO cebocb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mipadayon sa paglakaw ang mga Israelinhon, ug nagkampo sila sa Obot. ");
INSERT INTO cebocb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Gikan sa Obot, milakaw sila ug nagkampo sa Iye Abarim, sa kamingawan sa sidlakan atbang sa Moab. ");
INSERT INTO cebocb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Gikan didto milakaw sila ug nagkampo sa Walog sa Zered. ");
INSERT INTO cebocb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Gikan sa Zered milakaw na usab sila ug nagkampo sa tabok sa Walog sa Arnon, nga anaa sa kamingawan nga duol sa teritoryo sa mga Amorihanon. Ang Arnon maoy utlanan nga anaa sa yuta sa mga Moabihanon ug sa yuta sa mga Amorihanon. ");
INSERT INTO cebocb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Mao kana ang hinungdan kon nganong nasulat sa Libro sa Pagpakig-away sa Ginoo: “ang lungsod sa Waheb nga sakop sa Sufa, ang mga walog apil na ang Arnon, ");
INSERT INTO cebocb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ug ang ubos nga bahin sa mga walog nga nagsumpay sa lungsod sa Ar nga anaa sa utlanan sa Moab.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Gikan didto sa Arnon, ang mga Israelinhon nangadto sa Beer, ang atabay diin miingon ang Ginoo kang Moises, “Tigoma ang mga tawo kay hatagan ko sila ug tubig.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ug didto nanganta ang mga Israelinhon niini nga awit: “Padayon pagtubod, O atabay! Mag-awit kita mahitungod niini ");
INSERT INTO cebocb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","nga atabay nga gipakalot sa mga pangulo ug mga dungganong mga tawo pinaagi sa ilang awtoridad.” Gikan sa kamingawan nangadto sila sa Matana; ");
INSERT INTO cebocb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","gikan sa Matana nangadto sila sa Nahaliel; gikan sa Nahaliel nangadto sila sa Bamot; ");
INSERT INTO cebocb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ug gikan sa Bamot nangadto sila sa walog sa Moab, diin malantaw gikan sa kinatumyan sa Bukid sa Pisga ang kamingawan. ");
INSERT INTO cebocb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Unya, nagpadala ang Israel ug mga mensahero ngadto kang Sihon nga hari sa mga Amorihanon. Mao kini ang ilang mensahe: ");
INSERT INTO cebocb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Kon mahimo, tugoti kami sa pag-agi sa inyong yuta. Dili kami molatas sa kaumahan o sa ubasan, ni moinom gikan sa inyong atabay. Mosubay lang kami sa dakong dalan hangtod nga makagawas kami sa inyong teritoryo.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Apan wala mosugot si Sihon nga moagi ang mga Israelinhon sa iyang teritoryo. Gitigom hinuon niya ang iyang tibuok kasundalohan ug nangadto sila sa kamingawan ug giataki ang mga Israelinhon. Pag-abot nila sa Jahaz, nakig-gira sila sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Apan gipamatay sila sa mga Israelinhon ug giilog ang ilang yuta gikan sa Arnon paingon sa Suba sa Jabok. Apan kutob lang ang mga Israelinhon sa utlanan sa yuta sa mga Amonihanon, tungod kay lig-on ang mga paril sa ilang utlanan. ");
INSERT INTO cebocb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Busa nailog sa mga Israelinhon ang tanang mga lungsod sa mga Amorihanon ug gipuy-an nila kini, lakip ang Hesbon ug ang tanang mga baryo nga sakop niini. ");
INSERT INTO cebocb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Kining Hesbon kaniadto maoy nag-unang lungsod ni Sihon, ang hari sa mga Amorihanon. Gipildi niya kaniadto ang usa ka hari sa Moab ug giilog niya ang tanang kayutaan niini kutob sa Arnon. ");
INSERT INTO cebocb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Mao kana nga ang mga magbabalak nag-ingon: “Dali kamo sa Hesbon, ang lungsod ni Sihon! Tukora ninyo kini pag-usab. ");
INSERT INTO cebocb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Kaniadto ang mga sundalo sa Hesbon misulong nga daw nagdilaab nga kalayo nga milamoy sa lungsod sa Ar nga sakop sa Moab ug milaglag sa mga habog nga dapit sa Arnon. ");
INSERT INTO cebocb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Makaluluoy kamong mga taga-Moab! Alaot kamong mga nagsimba sa dios-dios nga si Kemosh! Kamong iyang mga anak gipasagdan niya nga mabihag ni Sihon nga hari sa mga Amorihanon. ");
INSERT INTO cebocb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Apan karon nalaglag na ang mga Amorihanon. Napukan na ang lungsod sa Hesbon, lakip ang Dibon, Nopa, ug Medeba.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Busa mipuyo ang mga Israelinhon sa yuta sa mga Amorihanon. ");
INSERT INTO cebocb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Unya nagpadala si Moises ug mga espiya sa Jazer, ug giilog usab nila kini ug ang mga baryo nga sakop niini. Gipapahawa nila ang mga Amorihanon nga namuyo didto. ");
INSERT INTO cebocb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Pagkahuman, nangadto na usab sila sa Basan. Apan gisulong sila ni Og nga hari sa Basan ug sa iyang tibuok kasundalohan didto sa Edrei. ");
INSERT INTO cebocb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Miingon ang Ginoo kang Moises, “Ayaw kahadlok kaniya, kay itugyan ko siya kanimo, lakip ang tibuok niyang katawhan ug kayutaan. Buhata kaniya ang gibuhat mo kang Sihon nga hari sa mga Amorihanon, nga naghari sa Hesbon.” ");
INSERT INTO cebocb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Busa gipatay sa mga Israelinhon si Og, lakip ang iyang mga anak ug ang tanan niyang katawhan, ug wala gayoy nahibilin kanila. Pagkahuman, gipanag-iya dayon sa mga Israelinhon ang yuta nga sakop ni Og. ");
INSERT INTO cebocb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nagpadayon sa paglakaw ang mga Israelinhon hangtod nga nakaabot sila sa kapatagan sa Moab. Nagkampo sila sa sidlakang bahin sa Jordan, atbang sa Jerico. ");
INSERT INTO cebocb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Unya nahibaloan ni Haring Balak sa Moab, nga anak ni Zipor, ang tanang gibuhat sa mga Israelinhon ngadto sa mga Amorihanon. ");
INSERT INTO cebocb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Nalisang gayod siya ug ang mga Moabihanon tungod sa kadaghan sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Miingon ang mga Moabihanon ngadto sa mga tigdumala sa Midian, “Hutdon gayod niining mga tawhana ang tanan nga anaa sa atong palibot, sama sa baka nga mohurot ug sabsab sa mga sagbot sa kaumahan.” Busa si Balak nga anak ni Zipor, nga maoy hari sa Moab niadtong panahona, ");
INSERT INTO cebocb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","nagpadala ug mga mensahero sa pagpatawag kang Balaam nga anak ni Beor nga nagpuyo sa Petor nga iyang yutang natawhan, duol sa Suba sa Eufrates. Mao kini ang mensahe ni Balak: “Adunay mga tawong naggikan sa Ehipto ug hilabihan sila kadaghan ug nagpuyo duol kanamo. ");
INSERT INTO cebocb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Busa anhi dayon dinhi ug panghimaraota kining mga tawhana kay mas gamhanan sila kay kanamo. Basin pag mapildi ko sila ug maabog gikan sa akong yuta. Kay nasayod ako nga si bisan kinsa nga panalanginan mo mapanalanginan, ug ang panghimaraoton mo mahimaraot.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Busa milakaw ang mga tigdumala sa Moab ug Midian nga dala ang bayad alang kang Balaam. Gisultihan nila kini sa giingon ni Balak. ");
INSERT INTO cebocb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Unya miingon si Balaam kanila, “Dinhi lang kamo pangatulog karong gabii, aron isulti ko kaninyo ugma kon unsay isulti sa Ginoo kanako.” Busa didto nangatulog ang mga pangulo sa Moab. ");
INSERT INTO cebocb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Unya, nangutana ang Dios kang Balaam, “Kinsa kining kauban mo nga mga tawo?” ");
INSERT INTO cebocb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Mitubag si Balaam sa Dios, “Sila ang mga mensahero nga gipadala ni Balak nga hari sa Moab, nga anak ni Zipor. Mao kini ang iyang mensahe: ");
INSERT INTO cebocb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Adunay mga tawo nga naggikan sa Ehipto ug labihan sila kadaghan. Busa anhi dayon dinhi ug panghimaraota sila, kay basin pa diay ug mapildi ko sila ug maabog palayo.’ ” ");
INSERT INTO cebocb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Apan miingon ang Dios kang Balaam, “Ayaw pag-uban kanila. Ug ayaw panghimaraota kadtong mga tawo nga giingon nila, kay gipanalanginan ko sila.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Pagbangon ni Balaam pagkabuntag, giingnan niya ang mga pangulo ni Balak, “Pauli na lang kamo sa inyong nasod kay dili mosugot ang Ginoo nga mouban ako kaninyo.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Busa namalik ang mga pangulo sa Moab ngadto kang Balak ug miingon, “Nagdumili si Balaam sa pag-uban kanamo.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Busa nagpadala pag-usab si Balak ug mas daghang mga pangulo ug mas dungganon kaysa una niyang gipadala. ");
INSERT INTO cebocb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nangadto sila kang Balaam ug miingon: “Mao kini ang gipasulti ni Balak nga anak ni Zipor: ‘Ayaw pagtugot nga adunay makababag kanimo sa pag-anhi dinhi. ");
INSERT INTO cebocb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Suholan ko gayod ikaw ug buhaton ko bisan unsay imong isulti. Palihog, anhi dinhi ug panghimaraota kining mga tawhana alang kanako.’ ” ");
INSERT INTO cebocb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Apan mitubag si Balaam kanila, “Bisan pag ihatag ni Balak kanako ang iyang palasyo nga puno sa pilak ug bulawan, dili ko mahimong lapason ang sugo sa Ginoo nga akong Dios, bisan sa dako o sa gamay lang nga butang. ");
INSERT INTO cebocb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Apan dinhi lang una kamo pangatulog karong gabii sama sa gihimo sa uban ninyong kauban, kay basin kon duna pay ubang isulti ang Ginoo kanako.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Niadtong gabhiona miingon ang Dios kang Balaam, “Tungod kay mianhi na man kining mga tawhana aron sa pag-uban kanimo, uban na lang kanila, apan ang ako lang isulti maoy imong buhaton.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Pagkabuntag, giandam ni Balaam ang iyang asno ug miuban sa mga pangulo sa Moab, ");
INSERT INTO cebocb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","uban sa iyang duha ka sulugoon. Apan samtang naglakaw si Balaam sakay sa iyang asno, nasuko pag-ayo ang Dios, busa gibabagan siya sa anghel sa Ginoo diha sa dalan. ");
INSERT INTO cebocb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Pagkakita sa asno nga nagtindog ang anghel sa Ginoo nga naggunit ug espada diha sa dalan, mitipas kini ug mipaingon sa uma. Busa gibunalan kini ni Balaam aron mobalik sa dalan. ");
INSERT INTO cebocb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Unya mibarog ang anghel sa Ginoo sa sigpit nga dalan taliwala sa paril sa duha ka ubasan. ");
INSERT INTO cebocb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Sa dihang nakita sa asno ang anghel sa Ginoo, midip-ig ang asno sa paril ug naipit ang tiil ni Balaam. Busa gibunalan kini pag-usab ni Balaam. ");
INSERT INTO cebocb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Unya milakaw sa unahan ang anghel sa Ginoo ug mibarog sa usa ka sigpit nga dapit nga wala gayoy matipasan, sa tuo man o sa wala. ");
INSERT INTO cebocb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Sa dihang nakita sa asno ang anghel sa Ginoo milubog na lang kini. Nasuko pag-ayo si Balaam, ug gibunalan niya ang asno sa iyang baston. ");
INSERT INTO cebocb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Unya gipasulti sa Ginoo ang asno, ug miingon kini kang Balaam, “Unsa bay nabuhat ko kanimo nga gibunalan mo man ako sa makatulo ka higayon?” ");
INSERT INTO cebocb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Mitubag si Balaam sa asno, “Gihimo mo akong daw sa buang-buang! Kon aduna lang akoy espada patyon ko gayod ikaw.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Miingon ang asno kang Balaam, “Dili ba ako man ang imong asno nga kanunay mong ginasakyan? Nag-iningon ba gud ako niini kanimo kaniadto?” Mitubag si Balaam, “Wala.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Unya gipakita sa Ginoo kang Balaam ang iyang anghel nga nagtindog sa dalan nga naggunit ug espada. Busa mihapa si Balaam sa yuta. ");
INSERT INTO cebocb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nangutana kaniya ang anghel sa Ginoo, “Nganong gibunalan mo ang imong asno sa makatulo gayod? Mianhi ako dinhi sa pagbabag kanimo kay daotan ang imong binuhatan sa akong tan-aw. ");
INSERT INTO cebocb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Nakakita kanako ang imong asno ug milikay kini kanako sa makatulo. Kon wala pa siya milikay, gipatay ko na unta ikaw, ug ang imong asno pasagdan ko nga mabuhi.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Miingon si Balaam sa anghel sa Ginoo, “Nakasala ako! Wala gayod ako nahibalo nga nagtindog ka diay diha sa pagbabag kanako! Kon daotan alang kanimo ang akong gihimo, mopauli na lang ako.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Miingon ang anghel sa Ginoo kang Balaam, “Uban nianang mga tawhana, apan isulti lang ang isulti ko kanimo.” Busa miuban si Balaam sa mga pangulo ni Balak. ");
INSERT INTO cebocb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Pagkahibalo ni Balak nga nagpadulong na si Balaam, misugat siya didto sa usa ka lungsod sa Moab duol sa Arnon, sa utlanan sa iyang teritoryo. ");
INSERT INTO cebocb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Miingon si Balak kang Balaam, “Nganong wala ka dayon mianhi sa unang higayon nga gipatawag ka nako? Naghuna-huna ka ba nga dili ka nako gantihan?” ");
INSERT INTO cebocb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Mitubag si Balaam, “Ania na ako. Apan wala akoy ikasulti kanimo gawas sa ipasulti sa Dios kanako.” ");
INSERT INTO cebocb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Unya miuban si Balaam kang Balak sa Kiriat Huzot. ");
INSERT INTO cebocb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ug didto naghalad si Balak ug baka ug karnero. Gihatag niya ang ubang karne kang Balaam ug sa mga pangulo nga kauban niya. ");
INSERT INTO cebocb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Pagkaugma, gidala ni Balak si Balaam ibabaw sa Bamot Baal, ug didto nakita niya sa ubos ang katawhan sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Miingon si Balaam kang Balak, “Himoi ako dinhi ug pito ka halaran, ug andami ako ug pito ka torong baka ug pito ka hamtong nga laking karnero.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Gituman ni Balak ang giingon ni Balaam, ug naghalad silang duha ug torong baka ug hamtong nga laking karnero sa kada halaran. ");
INSERT INTO cebocb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Unya miingon si Balaam kang Balak, “Tindog tapad sa imong halad nga sinunog. Molakaw sa ako, kay basin makigkita ang Ginoo kanako. Sultihan ko lang ikaw kon unsay iyang isulti kanako.” Unya mitungas siya sa taas nga dapit. ");
INSERT INTO cebocb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nakigkita ang Dios kaniya, ug miingon si Balaam, “Gaandam ako ug pito ka halaran, ug naghalad ako diha sa kada halaran ug usa ka torong baka ug usa ka hamtong nga laking karnero.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Gihatagan sa Ginoo si Balaam ug mensahe ug miingon, “Balik ngadto kang Balak ug isulti kaniya kini nga mensahe.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Busa mibalik si Balaam kang Balak, ug nakita niya kining nagtindog sa tapad sa iyang halad, uban sa tanang pangulo sa Moab. ");
INSERT INTO cebocb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Unya miingon si Balaam: “Gikan sa Aram sa kabukiran sa sidlakan, gipakuha ako ni Balak nga hari sa Moab. Miingon siya kanako, ‘Dali, ug panghimaraota ang mga kaliwat ni Jacob alang kanako. Tungloha sila nga katawhan sa Israel.’ ");
INSERT INTO cebocb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Unsaon ko pagpanghimaraot ang mga tawo nga wala panghimaraota sa Ginoo? ");
INSERT INTO cebocb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Gikan sa ibabaw sa mga bungtod, nakita ko sila. Nagkinabuhi silag ila, nga nabulag sa ubang mga nasod. ");
INSERT INTO cebocb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kinsay makaihap sa gidaghanon sa kaliwat ni Jacob? nga sama sa abog? Hinaut nga sama sa kamatayon sa mga katawhan sa Dios nga matarong ang akong kamatayon.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Miingon si Balak kang Balaam, “Unsa kining gihimo mo kanako? Gipakuha ka nako aron sa pagpanghimaraot sa akong mga kaaway apan imo hinuon silang gipanalanginan!” ");
INSERT INTO cebocb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Mitubag si Balaam, “Kinahanglan nga isulti ko ang gipasulti sa Ginoo kanako.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Unya miingon si Balak kaniya, “Uban kanako sa usa pa ka dapit diin imong makita ang usa ka bahin sa katawhan sa Israel, apan dili ang tanan. Ug panghimaraota sila.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Busa gidala ni Balak si Balaam sa usa ka uma sa Zofim ibabaw sa Bukid sa Pisga, ug didto naghimo siyag pito ka halaran ug naghalad ug pito ka torong baka ug pito ka hamtong nga laking karnero, tagsa sa kada halaran. ");
INSERT INTO cebocb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Miingon si Balaam kang Balak, “Tindog diri tapad sa imong halad nga sinunog samtang makigkita ako sa Ginoo diha sa unahan.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Nakigkita ang Ginoo kang Balaam ug gihatagan niya kini ug mensahe. Ug unya miingon siya, “Balik kang Balak ug isulti kaniya kini nga mensahe.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Busa mibalik si Balaam kang Balak, ug nakita niya kini nga nagtindog tapad sa iyang halad nga sinunog, uban sa mga pangulo sa Moab. Nangutana si Balak kang Balaam, “Unsay gisulti sa Ginoo kanimo?” ");
INSERT INTO cebocb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Miingon si Balaam, “Dali, Balak nga anak ni Zipor, ug paminawa ako pag-ayo. ");
INSERT INTO cebocb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dili tawo ang Dios nga mamakak o mausab ang huna-huna. Adunay gisulti ba siya nga wala niya buhata? Adunay gisaad ba siya nga wala niya tumana? ");
INSERT INTO cebocb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Gisugo niya ako nga mohatag sa panalangin, ug kon makapanalangin na siya, dili ko na kini mabakwi pa. ");
INSERT INTO cebocb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Wala akoy nakitang katalagman o kasamok nga moabot sa Israel. Kauban nila ang Ginoo nga ilang Dios; ginaila nila siya nga ilang hari. ");
INSERT INTO cebocb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gipagawas sila sa Dios gikan sa Ehipto; sama siya sa usa ka kusgan nga baka alang kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Wala gayoy lamat o barang nga modulot kanila. Busa miingon ang mga tawo bahin sa Israel, ‘Dakong kahibulongan ang gibuhat sa Dios ngadto sa Israel!’ ");
INSERT INTO cebocb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Kini nga katawhan sama sa liyon nga andam sa pagdasmag ug dili mopahulay hangtod nga dili niya malamoy ang iyang biktima ug mainom ang dugo niini.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Unya miingon si Balak kang Balaam, “Kon dili mo gayod sila panghimaraoton, ayaw sila panalangini!” ");
INSERT INTO cebocb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Mitubag si Balaam, “Dili ba nga giingnan ko na ikaw nga kinahanglan nga himuon ko ang gisulti sa Ginoo kanako?” ");
INSERT INTO cebocb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Miingon pag-usab si Balak kang Balaam, “Dali, dad-on ka nako sa lain na usab nga dapit. Basin pag didto mosugot na ang Dios nga panghimaraoton mo ang Israel alang kanako.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Busa gidala ni Balak si Balaam sa ibabaw sa Bukid sa Peor, diin malantaw ang kamingawan sa ubos. ");
INSERT INTO cebocb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Miingon si Balaam kang Balak, “Buhati ako dinhi ug pito ka halaran, ug andami ako ug pito ka torong baka ug pito ka laking karnero.” ");
INSERT INTO cebocb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Busa gihimo ni Balak ang giingon ni Balaam, ug naghalad siya ug usa ka torong baka ug usa ka hamtong nga laking karnero sa kada halaran. ");
INSERT INTO cebocb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Sa dihang nakita ni Balaam nga gusto sa Ginoo nga panalanginan ang Israel, wala na siya managna sama sa iyang gihimo kaniadto, kondili miatubang hinuon siya sa kamingawan ");
INSERT INTO cebocb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","diin nakita niya ang mga Israelinhon nga nagkampo sumala sa ilang tagsa-tagsa ka tribo. Unya gigamhan siya sa Espiritu sa Dios, ");
INSERT INTO cebocb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ug unya miingon siya, “Ako si Balaam nga anak ni Beor, ug aduna akoy maayong panabot. ");
INSERT INTO cebocb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Nadungog ko ang pulong sa Dios, ug nakakita ako ug panan-awon nga gikan sa Makagagahom nga Dios. Nagpaubos ako kaniya, ug gipasabot niya ako. Mao kini ang akong mensahe: ");
INSERT INTO cebocb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Pagkatahom sa mga tolda nga ginapuy-an sa katawhan sa Israel nga mga kaliwat ni Jacob. ");
INSERT INTO cebocb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Sama kini sa naglinya nga mga palma, ug sa mga hardin sa daplin sa suba. Sama usab kini sa kahoyng aloe nga gitanom sa Ginoo, ug sa mga kahoyng sedro sa daplin sa katubigan. ");
INSERT INTO cebocb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mag-awas ang tubig sa ilang mga sudlanan, ug magtanom silag liso diha sa mga yuta nga abunda ug tubig. Ang ilang hari mahimong mas gamhanan kaysa kang Agag nga hari sa mga Amalekanhon. Ug ang ilang gingharian mabantog. ");
INSERT INTO cebocb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gipagawas sila sa Dios gikan sa Ehipto; sama siya sa usa ka torong baka nga kusgan alang kanila. Panaon ug laglagon nila ang ilang mga kaaway; nga daw sa ginalamoy lang nila, ug daw sa ginadugmok nila ang ilang mga bukog. ");
INSERT INTO cebocb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Sama sila sa mga liyon nga kon nakatulog na walay mangahas sa pagpukaw kanila. Panalanginan ang nagpanalangin kanila ug panghimaraoton ang mga nagpanghimaraot kanila.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tungod niini, labihang sukoa ni Balak kang Balaam. Gisumbag ni Balak ang iyang kaugalingong palad ug giingnan si Balaam, “Gipatawag ka nako aron sa pagpanghimaraot sa akong mga kaaway, apan gipanalanginan mo hinuon sila sa tulo ka higayon. ");
INSERT INTO cebocb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Karon, pauli dayon! Miingon ako nga suholan ko gayod ikaw, apan dili motugot ang Ginoo nga maangkon mo ang suhol.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Mitubag si Balaam kang Balak, “Dili ba giingnan ko man ang imong mga mensahero, ");
INSERT INTO cebocb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","nga bisag ihatag mo pa kanako ang imong palasyo nga puno sa pilak ug bulawan, dili ako makahimo sa pagbuhat sa akong kaugalingong kabubut-on, maayo man o daotan? Ang giingon sa Ginoo kanako nga akong isulti, mao lay akong isulti. ");
INSERT INTO cebocb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Karon dayon mopauli ako ngadto sa akong mga katagilungsod. Apan pasidan-an ka nakong daan kon unsay buhaton niining mga tawhana sa imong katawhan sa ulahing mga adlaw.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Unya gisulti ni Balaam kini nga mensahe: “Ako si Balaam nga anak ni Beor, ug aduna akoy maayong panabot. ");
INSERT INTO cebocb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Nadungog ko ang pulong sa Labing Halangdong Dios ug gihatagan niya ako ug panabot. Nakakita ako ug panan-awon gikan sa Makagagahom Dios. Nagpaubos ako kaniya, ug gipasabot niya ako. “Mao kini ang akong mensahe: ");
INSERT INTO cebocb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Adunay nakita ako sa akong panan-awon nga wala pa nahitabo. Sa umaabot adunay maghari sa Israel nga gikan sa kaliwat ni Jacob. Laglagon niya ang mga Moabihanon ug ang tanang kaliwat ni Set. ");
INSERT INTO cebocb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Sakopon niya ang Edom nga iyang kaaway, nga gitawag usab ug Seir, samtang ang Israel molig-on. ");
INSERT INTO cebocb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Magdumala ang usa ka pangulo sa Israel ug laglagon niya ang mga nahibiling buhi sa lungsod sa Moab.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Unya nakita ni Balaam sa iyang panan-awon ang katawhan ni Amalek ug miingon siya, “Kaniadto ang Amalek mao ang gauna sa mga nasod, apan malaglag kini.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Unya nakita usab ni Balaam sa iyang panan-awon ang mga Kenihanon ug miingon siya, “Lig-on ang inyong puloy-anan, kay nahimutang kini sa batoon nga bukid. ");
INSERT INTO cebocb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Apan malaglag kamo kon bihagon na kamo sa Asiria.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ug misulti pa gayod si Balaam niini nga mensahe, “Kinsay magpabiling buhi kon buhaton na kini sa Dios? ");
INSERT INTO cebocb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mangabot ang mga barko nga gikan sa Kitim, ug sakopon nila ang mga katawhan sa Asiria ug Eber, apan ang Kitim malaglag usab.” ");
INSERT INTO cebocb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Unya mipauli si Balaam ingon man si Balak. ");
INSERT INTO cebocb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Samtang nagkampo ang mga Israelinhon sa Shitim, ang mga lalaki nagsugod sa pagpakighilawas sa mga babayeng Moabihanon. ");
INSERT INTO cebocb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Kining mga babayhana midapit kanila sa pag-apil paghalad ngadto sa ilang mga dios, ug mikaon sila sa mga halad ug misimba niini nga mga dios. ");
INSERT INTO cebocb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Busa ang mga Israelinhon miapil sa pagsimba kang Baal sa Peor. Ug labihan gayod ang kasuko sa Ginoo kanila. ");
INSERT INTO cebocb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Miingon ang Ginoo kang Moises, “Kuhaa ang tanang mga pangulo niini nga mga tawo. Pamatya sila sa akong presensya ug sa atubangan sa mga tawo, aron mahupay kining labihan ko nga kasuko sa Israel.” ");
INSERT INTO cebocb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Busa miingon si Moises sa mga maghuhukom sa Israel, “Kinahanglang patyon ninyo ang mga tawo nga miapil sa pagsimba kang Baal sa Peor.” ");
INSERT INTO cebocb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Unya adunay usa ka Israelinhon nga nagdala ug usa ka Midianhong babaye sa iyang pamilya. Nakita kini ni Moises ug sa tibuok katilingban sa Israel samtang nagtiyabaw sila didto sa pultahan sa Tolda nga Tagboanan. ");
INSERT INTO cebocb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Pagkakita niini ni Pinehas nga anak ni Eleazar ug apo ni Aaron nga pari, mibiya siya sa katilingban ug nagkuha ug bangkaw. ");
INSERT INTO cebocb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Gisunod niya ang tawo sa sulod sa tolda ug iyang gibangkaw kini ug ang babaye, ug natuhog silang duha. Human niini, naundang ang katalagman sa Israel, ");
INSERT INTO cebocb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","apan 24,000 ang nangamatay tungod sa katalagman. ");
INSERT INTO cebocb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Gikuha ni Pinehas nga anak ni Eleazar ug apo ni Aaron nga pari ang akong kasuko sa mga Israelinhon. Pinaagi sa iyang gihimo, gipakita niya ang iyang tinguha sa pagpanalipod sa akong dungog taliwala kanila. Busa wala ko sila hutda sa pagpamatay. ");
INSERT INTO cebocb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Busa ingna siya nga mohimo ako ug kasabotan kaniya nga panalanginan ko siya. ");
INSERT INTO cebocb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ug niini nga kasabotan, siya ug ang iyang mga kaliwat magpabilin nga pari hangtod sa kahangtoran, kay gipakita niya ang iyang tinguha sa pagtahod kanako ug gihinloan niya ang mga Israelinhon gikan sa ilang mga sala.” ");
INSERT INTO cebocb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ang Israelinhon nga namatay uban niadtong babayeng Midianhon mao si Zimri nga anak ni Salu, nga pangulo sa usa ka pamilya sa kaliwat ni Simeon. ");
INSERT INTO cebocb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ug ang Midianhong babaye mao si Cozbi nga anak sa pangulo sa usa ka pamilya nga Midianhon nga si Zur. ");
INSERT INTO cebocb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Isipa ninyong kaaway ang mga Midianhon. Pamatya ninyo sila, ");
INSERT INTO cebocb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kay giisip usab nila kamong mga kaaway sa dihang gilingla nila kamo didto sa Peor, ug tungod usab kang Cozbi nga anak sa usa ka Midianhon nga pangulo. Kining babayhana namatay niadtong panahon nga miabot ang katalagman sa Peor.” ");
INSERT INTO cebocb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Human sa katalagman, miingon ang Ginoo kang Moises ug kang Eleazar nga anak sa pari nga si Aaron, ");
INSERT INTO cebocb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Esensus ninyo ang tibuok katilingban sa Israel basi sa ilang pamilya, tanan nga nagpangidaron ug 20 ka tuig pataas nga makahimo sa pagserbisyo isip sundalo sa Israel.” ");
INSERT INTO cebocb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Busa nakigsulti si Eleazar nga pari ug si Moises sa mga Israelinhon didto sa kapatagan sa Moab sa daplin sa Suba sa Jordan atbang sa Jerico. ");
INSERT INTO cebocb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Miingon sila, “Sensosa ang mga tawo nga nag-edad ug 20 ka tuig pataas, sumala sa gisugo sa Ginoo kang Moises.” ");
INSERT INTO cebocb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ang mga kaliwat ni Ruben, nga kamagulangang anak ni Jacob, mao ang pamilya ni Hanoc, Palu, ");
INSERT INTO cebocb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, ug Carmi. ");
INSERT INTO cebocb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Mikabat ug 43,730 ang mga kaliwat ni Ruben. ");
INSERT INTO cebocb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ang anak ni Palu mao si Eliab, ");
INSERT INTO cebocb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ug ang mga anak ni Eliab mao sila si Nemuel, Datan, ug Abiram. Kini si Datan ug si Abiram mao ang mga pangulo sa katilingban nga nakigkunsabo kang Kora sa pagrebelde batok sa Ginoo pinaagi sa pagsupak kang Moises ug kang Aaron. ");
INSERT INTO cebocb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Apan gilamoy sila sa yuta uban kang Kora, kansang 250 ka mga sumusunod nangamatay pinaagi sa kalayo. Kining maong panghitabo nahimong pasidaan ngadto sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Apan ang mga anak ni Kora wala maapil ug kamatay niining hitaboa. ");
INSERT INTO cebocb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ang mga kaliwat ni Simeon mao ang mga pamilya ni Nemuel, Jamin, Jakin, ");
INSERT INTO cebocb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, ug Saulo. ");
INSERT INTO cebocb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Mikabat ug 22,200 ang mga kaliwat ni Simeon. ");
INSERT INTO cebocb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ang mga kaliwat ni Gad mao ang mga pamilya nila ni Zefon, Hagi, Shuni, ");
INSERT INTO cebocb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, Eri, ");
INSERT INTO cebocb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, ug Areli. ");
INSERT INTO cebocb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Mikabat ug 40,500 ang mga kaliwat ni Gad. ");
INSERT INTO cebocb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Si Juda adunay duha ka anak nga si Er ug Onan, nga namatay sa yuta sa Canaan. ");
INSERT INTO cebocb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Apan aduna gihapon mga kaliwat si Juda nga mao ang mga pamilya nila ni Shela, Perez, ug Zera. ");
INSERT INTO cebocb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ang mga kaliwat ni Perez mao ang mga pamilya nga naggikan kanila ni Hezron ug ni Hamul. ");
INSERT INTO cebocb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Mikabat ug 76,500 ang mga kaliwat ni Juda. ");
INSERT INTO cebocb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ang mga kaliwat ni Isacar mao ang mga pamilya nila ni Tola, Pua, ");
INSERT INTO cebocb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub, ug Shimron. ");
INSERT INTO cebocb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Mikabat ug 64,300 ang mga kaliwat ni Isacar. ");
INSERT INTO cebocb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ang mga kaliwat ni Zabulon mao ang mga pamilya nila ni Sered, Elon, ug Jalel. ");
INSERT INTO cebocb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Mikabat ug 60,500 ang mga kaliwat ni Zabulon. ");
INSERT INTO cebocb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ang mga kaliwat ni Jose naggikan sa duha niya ka anak nga si Manases ug Efraim. ");
INSERT INTO cebocb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ang mga kaliwat ni Manases mao ang mga pamilya nga naggikan kang Makir ug sa anak niining si Gilead. ");
INSERT INTO cebocb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ang mga anak ni Gilead mao sila si Iezer, ");
INSERT INTO cebocb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, Helek, Sekem, ");
INSERT INTO cebocb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida, ug Hefer. ");
INSERT INTO cebocb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ang anak ni Hefer nga si Zelofehad walay anak nga lalaki, apan aduna siyay mga anak nga babaye nga ang mga ngalan mao sila si Mala, Noa, Hogla, Milca, ug Tirza. ");
INSERT INTO cebocb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Mikabat ug 52,700 ang mga kaliwat ni Manases. ");
INSERT INTO cebocb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ang mga kaliwat ni Efraim mao ang mga pamilya nila ni Shutela, Beker, Tahan, ");
INSERT INTO cebocb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ug sa anak ni Shutela nga si Eran. ");
INSERT INTO cebocb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Mikabat ug 32,500 ang mga kaliwat ni Efraim. ");
INSERT INTO cebocb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ang mga kaliwat ni Benjamin mao ang mga pamilya nila ni Bela, Ashbel, Ahiram, ");
INSERT INTO cebocb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shufam, ug Hufam. ");
INSERT INTO cebocb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ang mga kaliwat ni Bela mao ang mga pamilya nila ni Ard ug Naaman. ");
INSERT INTO cebocb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Mikabat ug 45,600 ang mga kaliwat ni Benjamin. ");
INSERT INTO cebocb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ang mga kaliwat ni Dan mao ang mga pamilya ni Shuham. ");
INSERT INTO cebocb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Mikabat ug 64,400 ang mga kaliwat ni Dan. ");
INSERT INTO cebocb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ang mga kaliwat ni Aser mao ang mga pamilya nila ni Imna, Ishvi, ug Beria. ");
INSERT INTO cebocb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ang mga kaliwat ni Beria mao ang mga pamilya nila ni Eber ug Malkiel. ");
INSERT INTO cebocb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Adunay anak nga babaye si Aser nga si Sera.) ");
INSERT INTO cebocb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Mikabat ug 53,400 ang mga kaliwat ni Aser. ");
INSERT INTO cebocb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ang mga kaliwat ni Neftali mao ang mga pamilya nila ni Jazeel, Guni ");
INSERT INTO cebocb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, ug Shilem. ");
INSERT INTO cebocb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Mikabat ug 45,400 ang mga kaliwat ni Neftali. ");
INSERT INTO cebocb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ang gidaghanon sa tanang mga lalaki nga Israelinhon nga giihap mikabat ug 601,730. ");
INSERT INTO cebocb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Unya miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Bahina ang yuta ingon nga ilang panulondon basi sa gidaghanon sa kada tribo. ");
INSERT INTO cebocb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ang tribo nga daghan, bahini ug dako ug ang tribo nga gamay ra bahini ug gamay. ");
INSERT INTO cebocb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Kinahanglan pinaagi sa hulbot-hulbot ang pagbahin sa yuta subay sa tribo diin sila nasakop. ");
INSERT INTO cebocb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ang bahin nila mag-agad sa gidak-on sa ilang pamilya.” ");
INSERT INTO cebocb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ang mga kaliwat ni Levi mao ang mga pamilya nila ni Gershon, Kohat, ug Merari. ");
INSERT INTO cebocb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ug kanila naggikan ang mga pamilya nila ni Libni, Hebron, Mali, Mushi, ug Kora. Si Kohat mao ang amahan ni Amram. ");
INSERT INTO cebocb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ug ang asawa ni Amram mao si Jokebed nga kaliwat usab ni Levi. Natawo si Jokebed sa Ehipto. Si Amram ug Jokebed mao ang mga ginikanan nila ni Aaron, Moises, ug Miriam. ");
INSERT INTO cebocb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Si Aaron mao ang amahan nila ni Nadab, Abihu, Eleazar, ug Itamar. ");
INSERT INTO cebocb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Apan namatay si Nadab ug si Abihu sa dihang migamit silag kalayo nga dili maoy ginagamit sa ilang paghalad sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ang gidaghanon sa mga lalaking kaliwat ni Levi nga nag-edad ug usa ka bulan pataas mikabat ug 23,000. Wala sila i-apil sa kinatibuk-an nga ihap sa gidaghanon sa mga Israelinhon kay wala man silay bahin sa yuta nga gipanunod sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Mao kini ang mga Israelinhon nga naihap ni Moises ug ni Eleazar nga pari didto sa kapatagan sa Moab sa daplin sa Jordan atbang sa Jerico. ");
INSERT INTO cebocb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Wala nay naapil gikan sa nahaunang pag-ihap nga gihimo ni Moises ug ni Aaron nga pari sa kamingawan sa Sinai, ");
INSERT INTO cebocb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","kay miingon ang Ginoo kanila kaniadto nga sigurado gayong mangamatay sila sa kamingawan. Ug walay usa nga nahibilin gawas kang Caleb nga anak ni Jefune, ug kang Josue nga anak ni Nun. ");
INSERT INTO cebocb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Si Zelofehad adunay mga anak nga babaye nga sila si Mala, Noa, Hogla, Milca, ug Tirza. Kini si Zelofehad anak ni Hefer ug apo ni Gilead. Si Gilead anak ni Makir ug apo ni Manases. Si Manases anak ni Jose. ");
INSERT INTO cebocb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Kini nga mga babaye miadto sa pultahan sa Tolda nga Tagboanan ug mibarog sa atubangan ni Moises, ni Eleazar, sa mga pangulo, ug sa tibuok katilingban sa Israel, ug miingon, ");
INSERT INTO cebocb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Namatay didto sa kamingawan ang among amahan nga walay anak nga lalaki. Namatay siya dili tungod kay sumusunod siya ni Kora nga nagrebelde sa Ginoo, kondili tungod sa iyang kaugalingon nga sala. ");
INSERT INTO cebocb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Unsa man, wad-on na lang ba ang iyang ngalan sa panimalay sa Israel tungod kay wala siyay anak nga lalaki? Hatagi usab kami ug bahin sama sa nadawat sa among mga paryente.” ");
INSERT INTO cebocb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Busa gisulti ni Moises sa Ginoo ang ilang gipangayo. ");
INSERT INTO cebocb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ug nag-ingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Husto ang gisulti sa mga anak nga babaye ni Zelofehad. Kinahanglan nga hatagan mo sila ug yuta uban sa mga paryente sa ilang amahan. Ihatag kanila ang alang unta sa ilang amahan. ");
INSERT INTO cebocb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Ug ingna ang mga Israelinhon nga kon mamatay ang usa ka tawo nga walay anak nga lalaki, kinahanglan nga ihatag sa iyang anak nga babaye ang iyang panulondon. ");
INSERT INTO cebocb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kon wala siyay anak nga babaye, ihatag sa mga igsoon niya nga lalaki. ");
INSERT INTO cebocb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kon wala pa gayod siyay igsoong lalaki, ihatag ang iyang panulondon sa iyang mga uyoan sa amahan. ");
INSERT INTO cebocb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kon ang iyang amahan walay mga igsoong lalaki, ihatag ang iyang panulondon sa iyang pinakaduol nga paryente, ug ang maong paryente maoy makapanag-iya niini. Kinahanglang tumanon kini sa mga Israelinhon ingon nga usa ka lagda o tulomanon, sumala sa gisugo ko kanimo, Moises.” ");
INSERT INTO cebocb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Unya nag-ingon ang Ginoo kang Moises, “Tungas sa bukid sa Abarim ug lantawa gikan didto ang yuta nga ihatag ko sa mga Israelinhon. ");
INSERT INTO cebocb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Human mo kini makita, mamatay ka na sama sa imong igsoon nga si Aaron. ");
INSERT INTO cebocb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Kay sa dihang nagrebelde ang katilingban sa Israel kanako didto sa tuboran sa kamingawan sa Zin, gilapas ninyo ni Aaron ang akong sugo sa dihang gipakita ninyo ang akong pagkabalaan ngadto sa katawhan.” (Kini nga tuboran mao ang Meriba Kadesh, sa kamingawan sa Zin.) ");
INSERT INTO cebocb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Miingon si Moises sa Ginoo, ");
INSERT INTO cebocb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ginoo, Dios nga tinubdan sa kinabuhi sa tanang mga tawo, hinaut nga magpili ka ug usa ka tawong mangulo niining katawhan ");
INSERT INTO cebocb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","sa pagpakig-gira, aron ang imong katilingban dili mahisama sa mga karnero nga walay magbalantay.” ");
INSERT INTO cebocb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Busa miingon ang Ginoo kang Moises, “Ipatawag si Josue nga anak ni Nun, ang tawo nga gigamhan sa Espiritu, ug ipandong ang imong kamot sa iyang ulo. ");
INSERT INTO cebocb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Pabaroga siya atubangan ni Eleazar nga pari ug sa tibuok katilingban, ug ipahibalo kanila nga gipili mo siya nga imong kapuli. ");
INSERT INTO cebocb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Hatagi siya sa imong awtoridad aron motuman kaniya ang tibuok katilingban sa Israel. ");
INSERT INTO cebocb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Mobarog siya sa atubangan ni Eleazar nga pari nga maoy magpakisayod sa Ginoo alang kaniya pinaagi sa Urim kon unsa ang iyang hukom. Niining paagiha, magiyahan ni Eleazar si Josue ug ang tibuok katilingban sa Israel sa ilang pagabuhaton.” ");
INSERT INTO cebocb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Busa gibuhat ni Moises ang gisugo kaniya sa Ginoo. Gipatawag niya si Josue ug gipabarog atubangan ni Eleazar nga pari ug sa tibuok katilingban. ");
INSERT INTO cebocb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ug sumala sa gisugo sa Ginoo, gipandong ni Moises kang Josue ang iyang mga kamot ug gitugyanan si Josue sa buluhaton sa pagpangulo sa mga tawo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Miingon ang Ginoo kang Moises, ");
INSERT INTO cebocb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ingna ang mga Israelinhon nga kinahanglan nga maghalad sila kanako ug mga halad pinaagi sa kalayo sa gitakda nga panahon. Kini nga mga halad maoy akong pagkaon, ug ang kahumot niini makapalipay kanako. Busa isulti kini ngadto sa mga Israelinhon: ");
INSERT INTO cebocb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Mao kini ang mga halad pinaagi sa kalayo nga inyong ihalad sa Ginoo adlaw-adlaw: duha ka karnero nga nag-edad ug tagsa pa ka tuig ug walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ang usa ka karnero ihalad sa buntag ug ang laing usa ihalad sa hapon. ");
INSERT INTO cebocb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Lakipi kini ug halad sa pagpasidungog nga duha ka kilo nga maayong klasi sa harina nga sinagolan ug usa ka litrong mantika nga gikan sa dinukdok nga olibo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Mao kini ang inadlaw-adlaw nga halad nga inyong sunogon, nga gisugo kaniadto kaninyo sa Ginoo didto sa Bukid sa Sinai. Ang kahumot niini nga halad pinaagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ang halad nga ilimnon nga i-apil sa kada karnero, usa ka litrong bino, ug ibubo kini didto sa balaang dapit alang sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Mao gihapon ang inyong buhaton sa ikaduhang karnero nga inyong ihalad sa hapon. Lakipi gihapon ninyo kini ug halad isip pagpasidungog sa Ginoo ug halad nga ilimnon. Halad kini pinaagi sa kalayo, ug ang kahumot niini makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Sa Adlaw nga Igpapahulay, maghalad kamo ug duha ka karnero nga nag-edad ug tagsa ka tuig ug walay depekto. Lakipi kini ug halad nga ilimnon ug ang halad isip pagpasidungog nga upat ka kilo nga maayong klasi sa harina nga sinagolan ug mantika. ");
INSERT INTO cebocb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Mao kini ang halad nga sinunog sa matag Adlaw nga Igpapahulay, dugang sa inadlaw-adlaw nga halad nga sinunog apil ang halad nga ilimnon niini. ");
INSERT INTO cebocb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Sa matag unang adlaw sa bulan, maghalad kamo ug halad nga sinunog alang sa Ginoo: duha ka nating torong baka, usa ka hamtong nga laking karnero, ug pito ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","13","Apilan ninyo kini ug halad sa pagpasidungog nga maayong klasi sa harina nga sinagolan ug mantika, unom ka kilo sa kada nating torong baka, upat ka kilo sa hamtong nga laking karnero, ug duha ka kilo sa matag batan-ong karnero. Mga halad kini nga sinunog, ug ang kahumot niini makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ang kada nating torong baka lakipan ug halad nga ilimnon nga duha ka litrong bino. Ang hamtong nga laking karnero lakipan ug usa ug tunga ka litrong bino. Ug ang matag batan-ong karnero lakipan ug usa ka litrong bino. Mao kini ang binulan nga halad nga sinunog nga inyong pagahimuon sa matag sugod sa bulan sa tibuok tuig. ");
INSERT INTO cebocb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Maghalad pa gayod kamo sa Ginoo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog apil ang halad nga ilimnon niini. ");
INSERT INTO cebocb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Sauloga ninyo ang Pista sa Paglabay sa Anghel sa ika-14 nga adlaw sa unang bulan. ");
INSERT INTO cebocb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Pagkasunod nga adlaw magsugod ang pista. Ug sulod sa pito ka adlaw dili kamo mokaon ug pan nga adunay patubo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Sa unang adlaw sa pista magtigom kamo aron sa pagsimba sa Ginoo, ug ayaw kamo pagtrabaho nianang adlawa. ");
INSERT INTO cebocb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Maghalad kamo sa Ginoo ug halad nga sinunog nga duha ka nating torong baka, usa ka hamtong nga laking karnero, ug pito ka laking karnero nga tagsa ka tuig ang edad. Kining tanan kinahanglan walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Apilan ninyo kini ug halad sa pagpasidungog nga maayong klasi sa harina nga sinagolan ug mantika, unom ka kilo sa matag nating torong baka, upat ka kilo sa hamtong nga laking karnero ");
INSERT INTO cebocb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ug duha ka kilo sa matag batan-ong karnero. ");
INSERT INTO cebocb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo aron maluwas kamo sa inyong mga sala. ");
INSERT INTO cebocb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ihalad ninyo kini dugang sa halad nga sinunog matag buntag. ");
INSERT INTO cebocb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Sa mao gihapon nga mga paagi ihalad ninyo kini nga mga halad pinaagi sa kalayo ingon nga pagkaon sa Ginoo. Himuon ninyo kini kada adlaw sulod sa pito ka adlaw. Ang kahumot niini nga mga halad makapalipay sa Ginoo. Ihalad ninyo kini dugang sa inadlaw-adlaw nga halad nga sinunog ug sa halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Sa ikapito nga adlaw, magtigom na usab kamo sa pagsimba sa Ginoo. Ug ayaw kamo pagtrabaho nianang adlawa. ");
INSERT INTO cebocb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Sa unang adlaw sa Pista sa Ting-ani, sa panahon nga maghalad kamo sa Ginoo ug bag-ong inani nga trigo, magtigom kamo aron sa pagsimba sa Ginoo ug ayaw kamo pagtrabaho nianang adlawa. ");
INSERT INTO cebocb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Paghalad kamo ug halad nga sinunog: duha ka nating torong baka, usa ka hamtong nga laking karnero ug pito ka laking karnero nga tagsa ka tuig ang edad. Ang kahumot niini nga mga halad makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Apilan ninyo kini ug halad sa pagpasidungog nga maayong klasi sa harina nga sinagolan ug mantika, unom ka kilo sa matag nating torong baka, upat ka kilo sa hamtong nga laking karnero, ");
INSERT INTO cebocb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ug duha ka kilo sa matag batan-ong karnero. ");
INSERT INTO cebocb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Maghalad usab kamo ug usa ka laking kanding aron mahinloan kamo gikan sa inyong mga sala. ");
INSERT INTO cebocb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ihalad ninyo kini inubanan sa mga halad nga ilimnon, dugang sa inadlaw-adlaw nga halad nga sinunog ug sa halad sa pagpasidungog. Kinahanglan nga ang mga mananap walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Sa unang adlaw sa ikapitong bulan, magtigom kamo aron sa pagsimba sa Ginoo ug ayaw kamo pagtrabaho. Nianang adlawa patingogon ninyo ang mga trumpeta. ");
INSERT INTO cebocb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Unya paghalad kamo ug halad nga sinunog diin ang kahumot niini makapalipay sa Ginoo: usa ka nating torong baka, usa ka hamtong nga laking karnero, ug pito ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Lakipan kini sa halad sa pagpasidungog nga maayong klasi sa harina nga sinagolan ug mantika, unom ka kilo sa matag nating torong baka, upat ka kilo sa hamtong nga laking karnero, ");
INSERT INTO cebocb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ug duha ka kilo sa matag batan-ong karnero. ");
INSERT INTO cebocb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo aron mahinloan kamo gikan sa inyong mga sala. ");
INSERT INTO cebocb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Ihalad ninyo kini dugang sa binulan ug inadlaw-adlaw nga mga halad nga sinunog uban sa mga halad sa pagpasidungog ug sa mga halad nga ilimnon. Mga halad kini pinaagi sa kalayo, ug ang kahumot niini makapalipay sa Ginoo. ");
INSERT INTO cebocb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Sa ikanapulo nga adlaw niining ikapitong bulan, magtigom kamo aron sa pagsimba sa Ginoo. Kinahanglan nga magpuasa kamo ug dili gayod magtrabaho. ");
INSERT INTO cebocb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Unya maghalad kamo ug mga halad nga sinunog diin ang kahumot niini makapalipay sa Ginoo: usa ka nating torong baka, usa ka hamtong nga laking karnero, ug pito ka laking karnero nga tagsa ka tuig ang edad. Kining tanan kinahanglan walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Lakipan kini sa halad sa pagpasidungog nga maayong klasi sa harina nga sinagolan ug mantika, unom ka kilo sa matag nating torong baka, upat ka kilo sa hamtong nga laking karnero, ");
INSERT INTO cebocb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ug duha ka kilo sa matag batan-ong karnero. ");
INSERT INTO cebocb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa naandang halad sa paghinlo aron maluwas kamo sa inyong mga sala ug sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Sa ika-15 nga adlaw sa mao gihapong bulan, magtigom na usab kamo aron sa pagsimba sa Ginoo ug ayaw gayod kamo pagtrabaho nianang adlawa. Saulogon ninyo kini nga pista alang sa Ginoo sulod sa pito ka adlaw. ");
INSERT INTO cebocb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Sa nahaunang adlaw sa pista, paghalad kamo ug mga halad nga sinunog diin ang kahumot niini makapalipay sa Ginoo. Naglangkob kini: 13 ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad. Kining tanan kinahanglan walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Lakipan kini sa halad sa pagpasidungog nga maayong klasi sa harina nga sinagolan ug mantika, unom ka kilo sa matag nating torong baka, upat ka kilo sa matag hamtong nga laking karnero, ");
INSERT INTO cebocb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ug duha ka kilo sa matag batan-ong karnero. ");
INSERT INTO cebocb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Sa ikaduhang adlaw, mao kini ang inyong ihalad: 12 ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Sa ikatulong adlaw, mao kini ang inyong ihalad: 11 ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Sa ikaupat nga adlaw, mao kini ang inyong ihalad: napulo ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Sa ikalimang adlaw, mao kini ang inyong ihalad: 9 ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Sa ikaunom nga adlaw, mao kini ang inyong ihalad: 8 ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Sa ikapito nga adlaw mao kini ang inyong ihalad: 7 ka nating torong baka, 2 ka hamtong nga laking karnero, ug 14 ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Maghalad usab kamo ug usa ka laking kanding isip halad sa paghinlo, dugang sa inadlaw-adlaw nga halad nga sinunog uban sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Sa ikawalong adlaw, magtigom kamo aron sa pagsimba sa Ginoo ug ayaw gayod kamo pagtrabaho nianang adlawa. ");
INSERT INTO cebocb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Paghalad kamo ug halad nga sinunog diin ang kahumot niini makapalipay sa Ginoo: usa ka nating torong baka, usa ka hamtong nga laking karnero, ug pito ka laking karnero nga tagsa ka tuig ang edad, nga walay depekto. ");
INSERT INTO cebocb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ang matag-usa niini, lakipan ninyo sa ensakto nga gidaghanon sa halad sa pagpasidungog ug sa mga halad nga ilimnon. ");
INSERT INTO cebocb_vpl VALUES ("NU29_38","005_29_38","NUM",