﻿USE sofia;
DROP TABLE IF EXISTS sofia.cdz_vpl;
CREATE TABLE cdz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cdz_vpl WRITE;
INSERT INTO cdz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","যীশু খ্রিস্ট রাঃআ বুগিন বার্তা রাঃআ এহব; ইনিদ ঈশ্বর রাঃআ হন। ");
INSERT INTO cdz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","জিসায় ভাবিজাগারিচ রাঃআ গ্রন্থরে চিল্কা অল মেনাঃআ, নেলেম, ইঞ ইঞাঃআ সরগ নাগাকে আমাঃআ মাড়াং মাড়াংতে কুলিয়াঞ; ইনি আমাঃআ হরাঃআ বানা দহয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ডাহিরে (বৈহাড়রে) মিহুড় রাঃআ আড়াঙ আয়ুম্অ তানা, ইনি ঢানরাঃআয়ৎ আয়, আপে প্রভু রাঃআ হরাঃআ বানায় পে আয়াঃআ যত হরাঃআ সরলেপে, ");
INSERT INTO cdz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","এঙ্কা লেকাতে ডুবানিচ যোহন হাজিরেনায়, হেৎদ ডাহিদররে ডুবান য়েত কুয়ায়্য় য়, হেৎদ কাই (কাই) আবুং গিডি নাতিঞাং মনপাল্টা রাঃআ বুগিন বার্তা গাম রে তাহিনায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ইনাতে জিহুদিয়া দিসুম রিঙ্কূ হেৎদ যিরুশালেম রিঙ্কূ যত হড় উডুং হিচ্ কাতে ইনি রাঃআ হান্ডে সেনঃকু এহব কেৎআ; হেৎদ আপান আপিন কাই মানা কাতে জর্ডন গাডা রে ইনি লিয়া ডুবান তানা কু। ");
INSERT INTO cdz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ইনি ডুবানিচ যোহন দ উট উপ রাঃআ কিচিঃ ভাগয়াঃ কেনায়, মায়াঙরে সুন্নু চুটিরাঃআ মায়াঙ কব্জা তাহিন্কেনা, হেৎদ ইনি বির স্নসরেৎ হেৎদ বিরমধু জম নুৎ কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ইনিদ গাম পাস্নাৎ কেনায়, অকয়দ ইঞ হাতেৎ গাদা দাড়িয়ান, ইনিদ ইঞাঃআ তায়্মতে হি তানায়; আয়াঃআ খড়ম বায়র ইক্ড়ুম কাতে হতর রাঃআ আইদারি ইঞাঃআ বায়াঃনা। ");
INSERT INTO cdz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ইঞ আপেকে দাঃআ তেঞ ডুবানেৎ পেয়া মেন্খান ইনিদ রিলামালা আত্মা তে ডুবান পেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ইন্তং যীশু দ গালিলি রাঃআ নসরত সরগ নাগার হাতে হিচ্ কাতে ডুবানিচ যহন হ্তেৎ তে ডুবান নেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","হেৎদ ইন্তংগে দাঃআ হাতেৎ রাঃআকাপ বেত্রাঃআং ঞেল কেৎ যায় রিমিল ফাড়কায়না, হেৎদ রিলামালা আত্মা পেরয়া চিন্তে আয়াঃআ চেতানরে আড়গু হিজুতানায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","হেৎদ স্বরগ হাতেৎ নিয়া জাগার হিচ্ এনা, আম্গে ইঞাঃআ আপান হন, আমাঃআ হ্তেত্তেগে ইঞ প্রীত। ");
INSERT INTO cdz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","হেৎদ ইন্তং গে আত্মা ইনিকে ডাহিদর /পিড়িদর কুল কিয়ায়, ");
INSERT INTO cdz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ইনা পিড়িদররে পুলি মাহা তাহি কাতেৎ বঙ্গা রাঃআ বিডারে নুরেনায়; হেৎদ বির জানয়ার কু লঃঅ তাহিলেনায় (মেনাঃইয়া), হেৎদ স্বরগ সরগ নাগা কু আয়াঃআ নেল আতেনরে তাহীন কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","হেৎদ চিন্তং জিহাল রে ভরাঃআ লেন খানে যীশু গালিলেতে হিচ্ কাতেৎ ঈশ্বর রাঃআ বুগিন বার্তা গাম পাসনা কেৎআয়, ");
INSERT INTO cdz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'অক্ত পুরাঃআএনা, ঈশ্বর রাঃআ রাঃআজ ঠাঁইঞতে সেটেরেনা; আপে মন রুয়াড়েপে, হেৎদ বুগিন জাগাররে পাতিয়াঃপে' ");
INSERT INTO cdz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ইনাতায়ম গালীল গাডা রাঃআ পাড়তে সেশেন সেশেন্তে ঞেল কেৎ কিনায়, শিমন হেৎদ আয়াঃআ হাগা আন্দ্রিয় গাডা রে জাল কিন গিডিই তানা, চিয়া চি ইঞ কিন দ হাকু সাসাপ হড় কিন তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","যীশু ইঙ্কিন কে গামাৎ কিনায়, ইঞাঃআ তায়্মতে হিজুবেন, আবেনকে ইঞ মান্মি সাসাব হড়ঞ বানাবেনা। ");
INSERT INTO cdz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","হেৎদ ইন্তংগে আকিনাঃআ জাল দুহাড় গিডি কাতেৎ ইনি কে কিন পাঞ্জা কিয়াঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ইনা তায়্ম হুঁডাঙ মাড়াং দর সেএন খান সিব্দিয়া রাঃআ হন যাকোব হেৎদ আয়াঃআ হাগা যহন কে নেল নাম কেৎ কিনায়; ইঙ্কিন হঃঅ ডঙ্গারে কিন তাহীন কেনা; জাল কিন সারিয়াৎ কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ইনি ইন্তংগে ইঙ্কিন কে রাঃআ কেৎ কিনায় ইনাতে অকিনাঃআ অপু সিব্দিয়াকে মুনিস কু লঃঅ ডঙগা রেগে বাগি তুকা কাতেৎ আয়াঃআ তায়্ম তায়্মতে পাঞ্জা ইদিকিয়াঃকিন। ");
INSERT INTO cdz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ইনা তায়্ম ক্প্র্নাহুম সরগ নাগার তে কু বলয়না হেৎদ ইন্তংগে ইনিদ ঝিরাঃআঃমাহা রে জাহের থানতে ব্ল্কাতে চেচেদা এ চেদেদ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ইনাতে হড় আয়াঃআ সারি চেচেদ আয়ুম তে হাহাড়ায় নাকু। চিয়াঃ চি ইনিদ দাড়িয়ান জ্ঞানী হড় লেকা ইঙ্কূ কে চেদেৎ কুকেনায় ধরম চেচেদ্কু লেকাদ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ইন্তং ইঙ্কূঃআ জাহের থানরে মিত হড় তাহিলেনায়, ইনিকে বঙ্গাআত্মা নামলিঃআ;ইনিদ কিকিচ কাতে গাম কেৎ আয়, ");
INSERT INTO cdz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","এ নাসরতিয় যীশু, আমলঅ ইঞাঃ কিনাঃ সাগাই ? আবেন দ কি আলেকে নাশ নাতিনাং হিচা কানাম ? ইঞ সারিয়াঙ, আমদ অকয় তানাম; ঈশ্বর রাঃআ ইনি রিলা মালা হড়। ");
INSERT INTO cdz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ইন্তং যীশু ধমকাঃআ কাতেৎ গামাঃইয়া, থিরম, হিঁইরাঃআ হাঁন্ডে হাতেৎ উঁডুংঅম। ");
INSERT INTO cdz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","এন্খান্গে ইনি বঙ্গা আত্মা ইনিকে মচড়া কিচতে গাদাজোর তে কিকিচ কাতে ইনি রাঃআ ভিতির হতেন উডুং গিডিনায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","এন্খান্গে যত হড় হাহাড়ায় নাকু, এমন কি ইঙ্কূ আকু আকু গে বিতর্ক কাতে কু গাম কেৎ আ আহা! নিয়া কিনাঃআ? নিয়া চিল্কান উপমা ? ইনি দাড়িয়ান লঅঃ বঙ্গা আত্মা কুকে হুকুমা কুতানায়, হেৎদ ইঙ্কূ আয়াঃআ হুকুম কু আয়ুমেৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ইন্তং ইনি রাঃআ বার্ত্তা তক্ষনি গোটা গালিল সরগ নাগার রাঃআ যত দর পসরাঃআএনা। ");
INSERT INTO cdz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ইনা তায়্ম যাহের থান হাতেৎ উডুং কাতেৎ যীশু তক্ষনি ইঙ্কূ যাকোব হেৎদ যহন লঃঅ শিমন হেৎদ আন্দ্রিয় তিকিনাঃআ অড়াঃআ রে বলয় নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ইন্তং সিমন রাঃআ হানার তেত রুয়ারে নুরলেনায়; হেৎদ ইঙ্কূ চেলা তক্ষনি ইনি রাঃআ রুয়া তানায় মেন্তে যীশু কেকু গামাইআ; আয়ুম কাতেৎ ইনি ঠাইঞতে সেন কাতে ইনি রাঃআ তিহি সাব কাতে বিরিৎ কিইয়া। ");
INSERT INTO cdz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","যীশু ঠাইঞতে সেন কাতে ইনি রাঃআ তিহি সাব কাতে বিরিৎ কিইয়া। ইন্তং ইনি রাঃআ রুয়া ছাডায় না, হেৎদ সিমন রাঃআ হানার তেত ইঙ্কূকে নেখামান কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ইনা তায়্ম তার্সীং, বেলা ডুঁবুজ এন্খান হড়কু যত রুয়া হড় কু কে হেৎদ বঙ্গা ভর হড় কুকে আয়াঃ হান্ডে আগুকেৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","হেৎদ সরগ নাগার রেনকু গাদা হড় দুয়াররে হুঁডিনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ইনাতে ইনি নানান হুনার রোগ-আজার হড় কুকে বুগিকেৎ কুয়ায়্য় য়, হেৎদ বঙ্গা ভর গাদা হড় কুকে বঙ্গা ছাড়াঃকেৎ কুয়া, হেৎদ ইঙ্কূ বঙ্গাকে জাহান জাগার কায় গাম তুকালাৎ কুয়া, চিয়া চি ইঙ্কূ দ ইনি কেকু চিন্হাইয়া। ");
INSERT INTO cdz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ইনা তায়্ম পায়াং পুয়ুংরে, নিদা আঁগঅ গাদা মড়াংতে, বিরিৎ কাতে বাহার দর সেঃএনায়, হেৎদ নিঝুম জায়গারে সেন্কাতে বিন্তি কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","আটঃ হঃঅ শিমন হেৎদ আয়াঃআ লঅঃই কু আয়াঃআ তায়্ম তায়্ম তেকু পাঞ্জাঃ সেএঃনা, ");
INSERT INTO cdz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","হেৎদ আঃচকে নাম কাতে কু কুলি কিয়াঃআ, যত হড় আম্কেকু পাঞ্জাঃমা। ");
INSERT INTO cdz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","যীশু ইঙ্কূ কে গাম রুয়াড়েৎ কুয়া, দেলা, আবু এটাঃ এটাঃ দরবু সেনা, কাতা কাতা কুরাঃআ যত হাতু তেবু সেনা, ইঞ ইনা ঠাঁও কুরেঞ জাগরিঞ উচ্ছানেয়াঞ, চিয়াঃ চি ইনা নাতিঞ উডুঙ্গ কানাঞ। ");
INSERT INTO cdz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ইনা তায়্ম ইনি দ গটা গলিল দিসুম রেঙ্কূ মান্মি কুরাঃআ ঝাহের স্থান কুরে সেন্কাতে চেচেদাঃআ এমাকুতানায় হেৎদ বঙ্গা কুকে কুদা গিডিৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","মিৎ হূলং মিয়াৎ টুন্টা বেরাঃআম হড় আয়াঃআ সামাংরে হিচ্ কাতে বিন্তি কেৎআয় হেৎদ ইকড়ুম কাতে গাম্কেৎআয়, যদি আমাঃআ ইচ্ছা হ্যুয়া, ইঞকে সুচি দাড়িয়াঞাম। ");
INSERT INTO cdz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ইনিদ অন্তর দায়াতে তিহি ভাড়া কাতেৎ ইনি কে জুটেত কিঃআয়, গাম্কেৎআ য়, ইঞাঃআ ইচ্ছা আম সুচি হ্যুহম। ");
INSERT INTO cdz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ইন্তংগে টুন্টা বেরাঃআম ইনিকে বগি কাতে সেএঃনায়, ইনি দ সুচিসুব্র নায়। ");
INSERT INTO cdz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ইন্তং ইনিকে হুকুম এম কাতে কুল কিইঃইয়া, ");
INSERT INTO cdz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","যীশু গামা কিঃয়ায়, ঞেলেম মটে মটে যাহায়কে যাহানাঃআ আলম গামা কুয়া; মেন্খান বামড়ে রাঃআ হান্ডে সেন কাতে নিজেকে উদু গঅম, হেৎদ হড়কু রঃআ হান্ডে লুকুন্দ এম নাতিনাং হেৎদ আম বেসা কানাম মেন্তে মুসা রাঃআ আরিচালি লেকাতে সির্পা সামাংএম। ");
INSERT INTO cdz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","মেন্খান ইনি দ এঁডে হাতেৎ উডুং কাতে নিনতীৎ বেশী গটা গাম ডাঁঁডররাঃআ কেৎ য়ায় যে, যীশু আলগাতে যাহা সরগ নাগার কুরে কায় বলঃঅ দাড়িলেনা, মেন্খান বাহার রে নিঝুম ঠাঁওরে তাহিয়েনা;হেৎদ হড় কুদ যত দর হাতেৎ আয়াঃআ হান্ডে হিজুকু লাগায়না। ");
INSERT INTO cdz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","কথক মাহা তায়্ম ইনি অটঃহঅ গে কুপুর নাহুম নাগ্রাঃআতে রুয়াড় হিচা কানায় মেন্তে আয়ুমেনা যে ইনি দ অড়াঃরে মেনাইয়া। ");
INSERT INTO cdz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","হেৎদ আয়াঃআ হান্ডে নিন্তিত হড় কু হিচ্ হুন্ডি এনা যে, দুয়ার বুটারে হঃঅ তিঁগু রাঃআ ঠাঁও বায়াঃ না। হেৎদ ইনি ইঙ্কূ য়া হান্ডে বচন উচ্ছান এম এ লাগায়্নায়। ");
INSERT INTO cdz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ইন্তং হড়কু দ উপুন হড় লিয়া মিয়াৎ হড়ম অবস হড় কে বহা আগুচ কেনাকু ইনি রাঃআ হান্ডে। ");
INSERT INTO cdz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","মেন্খান ভিড় নাতিনাং ইনি রাঃআ হান্ডে কাকু আগু দাড়িলিচ খান, ইনি কদেররে তাহিলেনায়, ইনা সজেরাঃআ সাড়মি ফঁংকা কাতেৎ আয়াঃআ সামাং রেকু পারকম লঅ আড়গু কিয়াঃকু অকা পারকমরে গিতিচ তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ইঙ্কূ য়াঃ পাতিয়া ঞেলকাতেৎ যীশু ইনি হড়ম অবস হড় কে গামাইঃআ, এ হন, আমাঃআ যত কাই ইকা এনা। ");
INSERT INTO cdz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","মেন্খান এন্ডে কথক কটাল কু দুপ তাহিলেনা; ইঙ্কূ দ মনে মনেতে নেকা বাকঝোড়ি তানা, ");
INSERT INTO cdz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","হিঁঃই হড় দ নেকান জাগার চিয়াঃ এ গামে তানা ? হাঁইঃমা ঈশ্বর নিন্দায় তানাদ; ইনি মিয়ুড় গে, অর্থাৎ ঈশ্বর, ইনি বিনা অকয় কাই ইকা দাড়িঃআ? ");
INSERT INTO cdz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ইঙ্কূ এনে এঙ্কা মনে মনে তেকু ভাবিত তেৎ আ, যীশু ইন্তং গে রিলামালা আত্মা আটকার ঞাম কেৎ তে ইঙ্কূকে গামাৎ কুয়া, আপে মনে মনে তে নেকা চিয়াঃ পে ভাবিতেৎআ ? ");
INSERT INTO cdz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","হিঁইঃ হড়ম অবস হড় কে অকাঃটা গাম আলগা, আমাঃআ কাই ইকায় না গাম, চি বিরিৎ মে পারকম সাপ এম হেৎদ অড়াঃআ সেনম ? ");
INSERT INTO cdz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","মেন্খান, যাতে আপে সারি ঞামেপে ধার্তি পুরিরে মান্মি হন রাঃআ কাই ইকা রাঃআ আইদারি মেনাঃআ, নিয়া খাতির ইনিদ হানি হড়ম অবস হড় কে গামা কিঃআয়, ");
INSERT INTO cdz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","আমকে গামাম তানাঞ, বিরিৎ মে, আমাঃআ পারকম সাপ গুটিয়া কাতেত ওড়াঃ সেনম দু। ");
INSERT INTO cdz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","এন্খান্গে ইনি বিরিৎ এনায়, হেৎদ ইন্তংগে পারকম সাব গুছিয়া কাতেৎ জ্ত্চ রাঃআ সামাং হর কাতে তাড়ম উঁডুং এনায়, এন্খান জ্ত্চ গাদাকু হাহাড়ায়না, হেৎদ ঈশ্বর রাঃআ গুন জহার কাতেৎ গাম কেৎ আ কু, নাকা দ যাহা হুলাং কা ঞেলা কানা। ");
INSERT INTO cdz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ইনা তায়্ম অটঃহঅ বাহারতে উডুং কাতে গাডা পাড়তে সেএনায়, হেৎদ যত হড় আয়াঃ হান্ডে হিচ্ এনাকু, হেৎদ ইনি ইঙ্কূকে চেচেত এমাতঃ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ইনা তায়্ম সেনঃ সেনঃ তে ঞেল কেৎয়ায়, অলফেরাঃআ রাঃআ হন লিবি বুটি হাতা হড়ডু রে দুপাকানায়; ইনিদ হানিকে রাঃআ কিঃআয়, দেলা হিজুম ইঞাঃ তায়্ম তে; এন্খান গে হানিদ বিরিৎ ইন্তে ইনি রাঃআ তায়্ম তায়্মতে পাঁজা কিইঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ইনা তায়্ম ইনিদ লেবি রাঃআ অড়াঃরে জমে দুপএনায়, হেৎদ গাদালেকা বুটিআসি হড়, কাইয়ান হড় হেৎদ যীশু আয়াঃআ চেলা কু লঃঅ দুপএনায়; চিয়া চি গাদাহড় কু হাজির তাহিলেনা, হেৎদ ইঙ্কূ আয়াঃআ তায়্ম তায়্ম তেকু সেন লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","মেন্খান ইনি কাইয়ান হড় কু হেৎদ বুটিআসি হড় কু লঃঅ জমে দুপা খানায় ঞেল কাতেৎ ফরাঃআসী কুরাঃআ কটাল কু আয়াঃআ চেলা কু কে কু কুলি কেৎ কুয়া ইনিদ বুটিআসি হড় কু লঃঅ হেৎদ কাইয়ান হড় কু লঃঅ জমে দুপআয়? ");
INSERT INTO cdz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","যীশু ইনা জাগার আয়ুম কাতে গাম কেৎযায়, বেশ হড় কু নাতিনাংদ ডাক্তার কাকু লাগাঃআ, মেন্খান রুয়া হাসু হড় কু রাঃআ নাতিনাং গে লাগাঃআকু, ইঞ দ ধার্মিক হড় নাতিনাং দ ল্হয়, মেন্খান কাইয়ান হড় কু কে রাঃআরাঃআঞ হিচা কানা। ");
INSERT INTO cdz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","হেৎদ যহন রাঃআ চেলাকু হেৎদ ফরাঃআসী কু দ বারেৎ কেনাকু। হেৎদ ইঙ্কূ যীশু রাঃআ হান্ডে হিচ্ কাতে কু কুলি কিঃআ, যহন রাঃআ চেলা কু হেৎদ ফরাঃআসী রাঃআ চেলা কু বারেয়া, মেন্খান আমাঃআ চেলাকু কাকু বারেয়া, চিয়া ? ");
INSERT INTO cdz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","যীশু দ ইঙ্কূ কে গামাৎ কুয়া বর লঃঅ তাহিন্তে কি বর অড়াঃরে পাহিকু রেঁগেচতে কু তাহি দাড়িঃআ? চিমিন ঘাড়ি বরে তাহিনায় ইমিন ঘাড়ি উন্কুদ রেঁগেচ তে কাকু তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","মেন্খান ইনকান ঘাড়ি হিজুআ, ইন্তং বরকে আকুঃআ হান্ডে হাতেৎ কু আত্কিরিয়া; ইনা হুলাং ইঙ্কূ দকু বারেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","মারি কিচিঃ চেতান রে যাহায় নামা কিচিঃতে তালি কাকু মরাঃআয়া; মারাঃআ লেখান নামা কিচিঃ রাঃআ তালি তে মারি কিচিঃ অটঃ হঅগে অড়েঃচআ, হেৎদ অটঃহঅ গাদা ফঁংকা চাবাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","অটঃ মারি হরতা থলীরে টাটকা দ্রাঃআক্ষা রসি কাকু দহয়া, দহ লেখান দ্রাঃআক্ষা রসি তে হরতা থলী চিরাঃআ ;এন্খান দ্রাঃআক্ষা রসি হিরিচ চাবাঃআ, চেলাং কু হঃঅ পুসিচ চাবাঃআ; মেন্খান টাটকা দ্রাঃআক্ষা রসি নামা চেলাংরে দহ হয়ুআ। ");
INSERT INTO cdz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","অটঃহঅ ইনি ঝিরাঃআ মাহা রে হড়ু বাইদ কাতা কাতাতে সেনঃ কেনায়; হেৎদ আয়াঃআ চেলা কু দ সেশেন সেশেন্তে গেলেকু টুঁগা ধরাঃআত কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ইন্খান্গে ফরিসী কুদ ইনি কে গামা কিয়াকু, ঞেলেম, অকাঃআ করাঃআলেখানা ল্হয়, এঙ্কানাঃআ ঝিরাঃআঃ মাহারে চিয়াঃ গেলেকু টুঁংগাঃৎআ ? ");
INSERT INTO cdz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ইনি ইঙ্কূ কে গামাত কুয়া; দাউদ হেৎদ আয়াঃআ লহীন (সাথী)কু জমাঃ অভাবতে রেঙ্গেচ লেত কুয়া ইন্তং ইনি কিনাঃআ চিকা লাঃআ, ইনা কি আপে যাহা হুলাং কাপে পড়া কানা ? ");
INSERT INTO cdz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","দাউদ মা তো অবিয়াথার মারাঃআং দিহীরী রাঃআ আমলরে ঈশ্বর রাঃআ অড়াঃরে বলঃঅ কাতে, অকা ভেট পিঠা দিহীরী বিনা যাহায় জম রাঃআ রেয়াজ বায়ানা, ইনা পিঠা জম লাত্যায় হেৎদ আয়াঃআ লহীন (সাথী)কে কু জম তুকা তাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","যীশু উন্কুকে অটঃহঅ গামাৎ কুয়া \"ঝিরাঃআঃ মাহাদ মান্মি নাতিনাং গে হ্যুয়া কানা, মান্মি দ ঝিরাঃআঃ মাহা নাতিনাং দ ল্হয়' ");
INSERT INTO cdz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","এন্খান মান্মি হন দ ঝিরাঃআঃ মাহা কুরাঃআ হঃঅ মালিক। ");
INSERT INTO cdz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","যীশু অটঃ হঅগে জাহের থান তে বলঃঅ আদেরেনায়; মিয়াৎ হড় এন্ডে তাহি লেনায়, ইনি রাঃআ মিয়াৎ তিহি রহড় লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ইন্তং, এটা ঝিরাঃআ মাহারে ইনিকে বেসিয়া চি ল্হয় নেল নাতিনাং যীশু কে কু প্র্ক্ষি তানা, যাতে আয়াঃ চেতান রে খুট কু লাৎ দাড়িয়া কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ইন্তং যীশু রহড় তিহি হড় কে গামা কিঃআ 'তালা মালা রে হিচ্ কাতে তিগুন মে' ");
INSERT INTO cdz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ইনা তায়্ম ইঙ্কূ কে গামাত কুয়া 'ঝিরাঃআঃ মাহারে চিকান কামী জারুড়? বেশ কামী চি খারাঃআপ কামী ? জীউ বানচা চি জীউ নাশ ' ");
INSERT INTO cdz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","মেন্খান ইঙ্কূ দ থীর থারেনাকু। ইন্তং ইনি ইঙ্কূ আ খঠিন অন্তর নেলতে খুবে কাঁহিসেনায় রাঃআগ্তে হানতে নাতে ইঙ্কূকে কয়ঃ কাতে ইনি হড় কে গামা কিঃআয় 'তিহি তামা ইঞাঃ নেতে বাড়াম' ইনি দ বাড়া কেৎ আয় হেৎদ ইনি রাঃআ মাড়াংতে তিহি চিল্কা তাহীন কেনা, এঙ্কাগে হুই রুয়াড়েনা। ");
INSERT INTO cdz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ইনা তায়্ম ফরাআসিকুদ উডুংএন তেকু হেরদ রাঃআজা কুলঃঅ আয়াঃআ বিরুত্তে চক্রাঃআন্ত কু লাগায়না, চিল্কাতে ইনিকে নাশ হড়আ। ");
INSERT INTO cdz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ইন্তং যীশু আয়াঃআ চেলা কু লঃঅ গাডা কাতাতে উডুং সেএঃ নাকু; এন্খান গে গালিল হাতেৎ মিত্ গাদা হড় আয়াঃআ তায়্ম তায়্মতে পাঁজা ইদি কিয়াঃ কু। গালিলি, জিহুদীয়া, জেরুসালেম, ইদম, যার্দ্দ্ন, গাডা কাতা কুরাঃআ দিসুম অটঃঅ সোর্ হেৎদ সিদ্ন রাঃআ চারু ধার হাতেৎ গাদা হড়, ");
INSERT INTO cdz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ইনি অকাকু হাহাড়া হাহাড়া কামী করাঃআৎ কেনায়, ইনাকু আয়ুম কাতে আয়ায়্য় হান্ডে কু হিচ্ এনা। ");
INSERT INTO cdz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ইন্তং আয়ায়্য় চেলা কুকে গামাৎ কুয়া, ভিড় খাতিরাঃআং আয়ায়্য় নাতিনাং মিয়াৎ ডঙ্গা সাপড়া তাহীন কাঃআ পাছে হড় কু ইনি রাঃআ চেতানরে কু নুরুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","চিয়া চি ইনি দ গাদা হড় কু কে বুগিলাত কুয়াআ, ইনাতে আজার বেয়াদ হড় কু আচ্কে জুটেৎ নাতিনাং আয়ায়্য় চেতানরে কু নুর কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","চিন্তং বঙ্গা আত্মা কু ইনিকে নেল লেখান্গে আয়ায়্য় সামাংরে নুর কাতেৎ কিকিচ কাতে কু গামেত কেনা, আবেনদ ঈশ্বর রাঃআ হন, ");
INSERT INTO cdz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","মেন্খান ইনি ইঙ্কূ কে মানাত কুকে নায় যাতে ইঙ্কূ আয়ায়্য় উপরুম আলকু এমে কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ইনা তায়্ম যীশু বুরুতে দেয়েন্তে, আচগে অকয় অকয় কে হদিস কেৎ কুয়া ইঙ্কূ কে ঠাইন্তে রাঃআ কেৎকুয়া; ইনাতে ইঙ্কূ আয়ায়্য় হান্ডে কু হিচ্এনা। ");
INSERT INTO cdz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","হেৎদ ইনি গেলে বার হড় কুকে বহাল কেৎকুয়া অকয় কুকে ইনি কুলিচ মেন্তে নতুম এমাৎকুয়ায়্য় য়, যাতে ইঙ্কূ ইনি রাঃআ কাতারে কু তাহীন কাঃআ, হেৎদ যাতে ইনি ইঙ্কূ কে উচ্ছান নাতিনাং কুল দাড়িয়া কুকাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","হেৎদ যাতে ইঙ্কূ বঙ্গা কুকে কুদা গিডি রাঃআ দাড়ি নামেকাঃআ কু। ");
INSERT INTO cdz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ইঙ্কূ গেলে বার চেলা কু কে বহাল লাৎ কুয়ায়্য় য় ইঙ্কূযায় নুতুম দ হুহ তানা ইনি সিমনকে, পিতর নুতুম এমাঃইআ, ");
INSERT INTO cdz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","সিবদিয়া রাঃআ হন যাকোব হেৎদ হানি যাকোব রাঃআ হাগা যহন, নিকিন বার হড় কে বোনেরগশ, অরথাৎ রিঁবিলসাডি হন, নিয়া নুতুম এমাত কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","হেৎদ আন্দ্রিয়, ফিলিপ, বর্থলময়, মথি, আলফের রাঃআ হন যাকোব, থদ্দেয়, অটঃহঅ কানানি শিমন, ");
INSERT INTO cdz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","হেৎদ ঈস্করিয় যুডাস অকয় দ তায়্মতে যীশু কে বাইরি রাঃআ তিহিরে সম্পা লিঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ইনা তায়্ম ইনি মিয়াৎ অড়াঃরে বলএনায়, হেৎদ অটঃ হঅগে নিনতীতঃ হড় কু হিচ্ হুঁডি ইনাকু, জম নু হঃঅ কাকু দাড়ি লাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","নিয়া আয়ুম কাতেৎ ইনি রাঃআ আত্মীয় আচ্কে সাব্ ইদি নাতিনাং হিচেনাকু, চিয়া চি ইঙ্কূ গামেৎ কেনাকু ইনি রাঃআ বহঃঅ দ খারাঃআপা কানা। ");
INSERT INTO cdz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","অটঃহঅ অকয় কটালকু হিচ্ লেনা যীরুশালেম হাতেৎ ইঙ্কূ হঃঅ গামেৎ আকু 'ইনিকে দ বেল্সুবুবে ভর তিঃআয়, মারাঃআংবঙ্গা আত্মা তে গে বঙ্গায় কুদাৎ কুয়ায়্য় য়' ");
INSERT INTO cdz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ইন্তং ইঙ্কূ কে ঠাইঞতে রাঃআ কাতেৎ উপমা লেকা তে গামৎ কুয়ায়্য় য় 'বঙ্গা চিল্কাতে ইটাঃআ বঙ্গাকে কুদাইআ' ");
INSERT INTO cdz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","অকা পরগনা যদি আয়ায়্য় নিজ বিরুদতে তাড়মেয়ায় ইনা পরগনা দ তিঁগু কেটেচ কায় তাহি দাড়িঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","অকা ঘারঞ্জ আয়ায়্য় বিরুদতে তাড়মেয়ায় ইনা ঘারঞ্জ হঃঅ তিঁগু কেটেচ কায় তাহি দাড়িঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","অটঃহঅ শয়তান যদি আয়ায়্য় বিরুদতে তিঁগু নায়, হেৎদ বেগারঃআয়, ইন্খান ইনিহঃঅ কায় তিঁগু কেটেচ দাড়িআয় মেন্খান ইনি রাঃআ মুচাত হযুঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","অটঃহঅ ইনি দাড়িযান হড়কে মাড়াং তে কাকু তল লেখান ইনি রাঃআ অড়াঃআ তে বলঃঅ কাতেৎ জিনিষ কাকু কুমড়ু দাড়িয়াঃআ, মেন্খান ইনিকে তল রেন্গ্ত অড়াতে বলঃঅ কাতেৎ কুমড়ু দাড়িয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","আপেকে সার্তি গেঞ গামাপে তানাঞ, মান্মিকু অকা যত কাই কামিকু হেৎদ ঈশ্বর নিন্দাঃআপে, ইনা যতআঃ রাঃআ ক্ষেমা হ্যুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","মেন্খান অকয় হড়কু রিলামালা আত্মা রাঃআ নিন্দাঃয়া, উন্কুয়াঃ অনন্তকাল রেহঃঅ ইকা কাকু ঞামেয়া, ইনি বরংচ জায়যুগ (অনন্ত) কাই রিনিচ দায়ী হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ইনিকে বঙ্গা আত্মা নামতিঃআ, ইঙ্কূ আঃ এনে এনকান জাগার নাতিনাং নেকা জাগার লাতআয়। ");
INSERT INTO cdz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","অটঃহঅ ইনি রাঃআ মাই হেৎদ আয়াঃআ হাগাকু হিচ্এনা, হেৎদ রাঃআচারে তিন্গু কাতে আচকে রাঃআরাঃআঃ কুল কিয়াঃআকু। ");
INSERT INTO cdz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ইন্তং চারুদর হড় কু দুপ তাহিলেনা; ইন্তং ইনিকে গামা ইয়াঃকু, মানতান, মাই তামাঃআ হেৎদ বকম তিকু আমাঃআ নাতিনাং রাঃআচা রেকু তাঙ্গী তাৎমেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ইনি ইঙ্কূ কে গাম রুয়াড়েৎ কুয়ায়্য় য়, অকয় ইঁঁঞাঃ মাই ? বকঞ তুকু বা অকয়? ");
INSERT INTO cdz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ইনা তায়্ম অক্য়্কু আয়াঃআ উপুন দর রেকু দুপ হুন্ডি লেনাকু, ইঙ্কূআ হানতে আরিৎ কাতে গাম কেৎ আয়, নুকু ঞেল কূপে, ইঞাঃআ মাই তিঞাঃ হেৎদ ইঞাঃআ হাগাং তুকু; ");
INSERT INTO cdz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","চিয়াৎ চি যাহায় গে ঈশ্বর রাঃআ দিশা হদিস মান্য়া য়ায়্য়, ইনিগে ইঞাঃআ হাগা হেৎদ মিসি, হেৎদ হাগা হেৎদ মাই। ");
INSERT INTO cdz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ইনা তায়ম অটঃ হঅগে ইনি গাডা কাতা রে চেচেদ এম লাগায়না; ইনাতে আয়ায়্য় এন্ডে নিন্তিত হড় কু হুঁডিনা যে, ইনিদ মিয়াৎ ডংগারে দেচ কাতে গাডা দাঃআরে ভাষায় নায়, হেৎদ হিইচা কানাকু যত হড়দ গাডা পাড়রে তিঁগুই নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ইন্তং ইনি কহিনী লেকাতে ইঙ্কূ কে গাদালেকা হীত জাগরে গামাৎ কুয়ায়্য় য, চেদাঃ জাগার লেকাতে ইনি ইঙ্কূ কে গামাৎ কুয়া, ");
INSERT INTO cdz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","'নেলেপে, হিতাজাঙ্গ হেরিচ জাঙ্গ হেরঃ সেঃএনায়; ");
INSERT INTO cdz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","হেরঃঅ বেত্রাঃআং ক্থ্ক জাঙ্গ হরাঃআ কাতারে নুরেনা, অড়েকু হিচ্ কাতে ঠটকা চাবা কেৎআকু। ");
INSERT INTO cdz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ক্থ্ক জাঙ্গ ধিরি চেতাংরে নুরেনা, ঢের হাসা বায়াঃনা; এন্খান ঢের হাসা বাঃআন্তে ঘিড়মেন্তাং জাঙ্গ গজায়না, ");
INSERT INTO cdz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","মেন্খান বেলা রাঃআকাপ্ এনখান সিতুমতে ঝাঁঞ্জ রঙ্গয়না, হেৎদ জিলিঙ পাটা বাঃআন্তে রহড়েনা। ");
INSERT INTO cdz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","অটঃহঅ ক্থ্ক জাঙ্গ জানুম ঝাপ ভিতিররে নুরেনা, এন্খান্গে জানুম ঝাপ হারাঃআ ইমাহা খান ইনা চেতান রে তেঁঙড়ায়না, জ কা হ্যুই লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","হেৎদ ক্থ্ক জাঙ্গ কুদ বেশ হাসারে নুরেনা, ইনা হিতা জাঙ্গ হাতেৎ গজা উডুং এনা, হারাঃআ রাঃআকাপ এন্তে জ সাপ এনা; ক্থ্ক ৩০ বুনুম (গুন), ক্থ্ক ৬০ বুনুম (গুন) অটঃহঃঅ ১০০ বুনুম (গুন) জ এম্কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ইনা তায়্ম ইনি গাম্ কেৎআয়্য়, অকয় রাঃআ আয়ুম নাতিনাং লুতুর মেনাঃআ ইনি আয়ুমে কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","চিন্তং ইনি নিরি বিলিরে তাহি লেনায়, আয়ায়্য় লইসকু (সঙ্গী) ইঙ্কূ ১২ হড় চেলা কু আচ্কেকু কুলি কিঃআ উপমা রাঃআ বাব্ত্তে। ");
INSERT INTO cdz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","যীশু ইঙ্কূ কে গাম ড়ুয়াড়েৎ কুয়া, ঈশ্বর রাঃআ পারহড় রাঃআ গাবে সারি তত্ত্ব আপেকে এম হ্যুয়া কানা; মেন্খান ইঙ্কূ এটাঃআ হড় কুরাঃআ হান্ডে উপমা এম কাতে গামহ্যুয়া, ");
INSERT INTO cdz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","চিল্কা ইঙ্কূ উদ্দুঃ কাতে ঞেলেকাঃআকু, মেন্খান আলকু আটকার ঞামেকাঃআ, হেৎদ আয়ুমেয়া কু, মেন্খান আলকু সারি ঞামেকাঃআ পাছে ইঙ্কূ রুয়াড় হিচ আ, হেৎদ ইঙ্কূ কে ইকা হ্যুয়ঃ কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ইনা তায়্ম যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় য় \"নিয়া উপমা কাপে সারি ঞাম তঃৎআ চি ? তবে খান চিল্কাতে যত লেকানাঃআ উপমা সারি নামেয়াপে? ");
INSERT INTO cdz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ইনি হিতা জাঙ্গ হেরিচ দ ঈশ্বর রাঃআ জাগার জাঙ্গ হেরেয়্য়া। ");
INSERT INTO cdz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","অকয় কুদ হরাঃআ কাতা রেন্কু, ইঙ্কূ দ এনে এঙ্কান হড়কু, অকয় কুকে জাগার জাঙ্গ হের হ্যয়া; হেৎদ আয়্যু মেয়াকু, ইন্তং গে বঙ্গা হিচ্ কাতে, ইঙ্কূ কে অকা জাঙ্গ হের হয়ই লেনা, ইনা জাগার আত্কির ইদিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","হেৎদ এঙ্কাগে অকয় কুদ ধিরি চেতাংরে নুরাঃআকানা, ইঙ্কূ এনে এনকান হড়কু, ইঙ্কূ জাগার আয়ুম থরাঃআ ল্লাৎ তে আতাং এয়্যায়; ");
INSERT INTO cdz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","হেৎদ ইঙ্কূ আ আত্মারে জিলিং পাটা বাঃআয়না, মেন্খান ইঙ্কূ দ হুডাঙ মাহারেগে জিউৎ তাহিনাকু, তায়্মতে ইনা ঈশ্বর রাঃআ জাগার নাতিনাং দুখঃ হেৎদ সাঁতা হিচ্ লেন্খান ইনতঙগে পিছুয়াকু কু। ");
INSERT INTO cdz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","হেৎদ এটাঃ অকয় কুদ জানুম লাটারে নুর লেনা, ইঙ্কূ এনে এনকান হড় কু, অকয় জাগার কু আয়ুম তাৎআ, ");
INSERT INTO cdz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","মেন্খান ঘাঁরঞ্জ রাঃআ চিন্তা, সম্পদ মহ হেৎদ নানান্হুনার বিলাসিতা ভিতিরে বলঃঅ কাতে ইনা জাগার কে দাপাল দহ্যাই, এন্খান্গে ইনি জ কায় এম দাড়িঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","অটঃহঅ অকয় কু বুগিন হাসরে কু নুরাঃআকানা, ইঙ্কূ দ এনে এনকান হড় কু, অক্য়্দ ইনা জাগার আয়ুম কাতেত হাতায়ায়্য়, হেৎদ অকয় কুদ ৩০ বুনুম, অকয় কুদ ৬০ বুনুম, হেৎদ ক্থ্ক কুদ ১০০ বুনুম জ কু এমেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","যীশু দ ইঙ্কূ কে অটঃহঅ গামাৎ কুয়া 'কাঠা লাতাররে চি পার্কম লাতাররে দহ নাতিনাং যাহায় দচি জুল সুল্তা দহয়ায়? চি আপেদ দানি চেতাঙরে দহ য়াপে ? ");
INSERT INTO cdz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","চিয়াঃচি এনে এন্কেনাঃ যাহানাআ উকু বায়্য়ায়্য়না, অকাঃআ কা সদর সামাঙঅঃআ, এনে এঙ্কানাআ যাহানা উকু বায়ায়্য় না, অকাঃআ কা সদরঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","অকয় কু রাঃআ আয়ুম নাতিনাং লুতুর মেন্নাঃআ আয়ুমে কাঃআকু। ");
INSERT INTO cdz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","অটঃহঅ ইঙ্কূ কে যীশু গামাৎ কুয়ায়্য় য় , আপে নেলেপে, আয়ুমেপে; আপে অকা সের্তে সঙআ কু তানাপে, এনে এঙ্কাগে ইনা সমান আপেকে কু সঙআ পেয়া ; হেৎদ আপেকে অটঃহঅগে ঢের নঃঅ এম হযুঃআ । ");
INSERT INTO cdz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","চিয়াঃ চি অকয় রাঃআ হান্ডে মেনাঃআ, ইনি কে অটঃ ঢের নঃঅ এম হযুঃআ; অকয় রাঃআ হান্ডে বায়াঃনা, অকাঃআ মেনাঃআ ইনা হঃঅ আয়াঃআ হান্ডে হাতেৎ রেচ হযুঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","যীশু অটঃহঅগে গাম কেৎআয়, ঈশ্বর রাঃআ পারহড় দ নিয়া লেকানা। ");
INSERT INTO cdz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","যাহায় হড় হাসারে হিতা জাঙ্গ হেরেয়ায়;ইনা তায়্ম নিদা সিঙ্গি গিতিচ বিরিৎআয়, ইনা জাঙ্গ চিন্তঙ রে গজা কাতেত চিল্কা তে হারাঃআ ইদিঃআ ইনি দ যাহানা কায় সারি নামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","হাসা আচ আচতে জ এমেয়ায়; মাড়াংতে গজাঃ ইনা তায়্ম গেলে, ইনা তায়্ম গেলে পেরেচ জাঙ্গ। ");
INSERT INTO cdz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","মেন্খান জ বিলি লেন্খান ইনি ইন্তং গে দাত্রম তে ইরেয়া, চিয়াঃচি ইরঃ মাহা সেটেরাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","অটঃহঅ যীশু গাম কেৎআয়, আবু অকয় লঃঅ ঈশ্বর রাঃআ পারহড় তুলা যখা য়াবু ? অকা উপমা লিয়া চি ইনা গামঃআ ? ");
INSERT INTO cdz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ইনা দ মিয়াৎ বাটনা জাঙ্গ রাঃআ লেকা; ইনা জাঙ্গ হাসারে হেরঃঅ বেত্রাঃআঙ হাসারাঃআ যত জাঙ্গ কু হাতেৎ গাদা পন্ঃচ, ");
INSERT INTO cdz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","মেন্খান হের্লেন খান ইনা হাতেৎ গজা উঁডুঙ কাতেত যত আড়াঃআ হাতেৎ বির রাঃআ হেৎদ মারাঙ মারাঙ ডাইর উডুংঙআ; এন্খান্গে রাহালা রিঙ্কূ অড়ে হিচ্ কাতে দারু উম্বুলরে তাহি দাড়িয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","হেঁঃএ নেন্কা গাদালেকা উপমা লেকাতে ইনি উঙ্কুঃআ আয়ুম দহ লেকানাঃআ দাড়ি লেকাতে জাগার উচ্চানেত কেনায়; ");
INSERT INTO cdz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","হেৎদ উপমা বেগর যাহানাঃআ কায় গামাকুকেনায়; তায়্মতে একলারে আয়ায়্য় চেলা কুকে যতঃআ সারি ঞামতুকা কেকুনায়। ");
INSERT INTO cdz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ইনা হুলাঙ আয়ুপ এন্খান ইনি উন্কুকে গামাৎ কুয়ায়্য় , দেলা, আবু হানা কাতাবু সেনঃআ দ। ");
INSERT INTO cdz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ইনতঙ হড় কুকে কুলগিডি কাতে, ইনি চিল্কা ডঁঙ্গা রে তাহি লেনায়, এঙ্কাগে ইনিকে লঃঅ ইদি কিঃআকু; হেৎদ অটঃহঅ গে ডঁঙ্গা আকু লঃঅ তাহি লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","তায়্মতে আচ্কাগে বিরঝড় হুয়েনা, হেৎদ ডঁঙ্গারে দাঃআ ঢেওউ নেন্কা ঝাপ্টাঃআ তানা, ডঁঙ্গারে দাঃআ বলঃঅ পেরেচ ইদি তানা। ");
INSERT INTO cdz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ইনতঙ ইনি ডঁঙ্গা রাঃআ তায়্ম দররে আটড়িরে বহঃঅ দহ কাতেত গিতিচ লেনায়; হেৎদ চেলাকু ইনিকে রাঃআ বিরিৎ কাতেত গামাই তানাকু, এ গুরু, আমাঃআ ভাবনা কা হযু তানা, আলে গচঃ তানালেদ ? ");
INSERT INTO cdz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ইন্তং ইনি চির্গাল বিরিৎ এন্তে হ-য়্য় কে ধ্ম্কা কিঃআয়, হেৎদ দরেয়া কে গামাঃইয়ায় থিরঃঅম, হাপেনঃঅম, ইন্খান্গে হ-য়্য় থিরেনায়, হেৎদ দরেয়া হাপেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","তায়্মতে যীশু চেলা কুকে গামাৎ কুয়া আপে নেন্কা চিয়াঃ বরয়াপে? নিয়া দ চিল্কা, আপেয়াআ পাতিয়া বায়াঃআয় না? ");
INSERT INTO cdz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ইন্তং ইঙ্কূ খুব্কু বরয় না আকু আকু কুক্লি তানা কু, ইনি দ তবে অকয় তানায়, হ-য়্য় হেৎদ দরেয়া আয়াঃ জাগার আয়ুমেয়া ? ");
INSERT INTO cdz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","তায়্মতে যীশু হেৎদ চেলা কুদ দরেয়া রাঃআ হানা কাতা রে গেরাঃআসেনি কুরাঃআ দিসুমতে সেটেরেনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","যীশু দ লাউকা হাতেৎ উডুং হিচেন্খান ইন্তং গে কবর দাঙ্গা হাতেৎ মিত হড় আয়া সমান রে উডুং হিচ্ এনায়, অকয় কে বঙ্গা আত্মা নাম লিয়াআয়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ইনিদ কবর ডাঙ্গা রে তাহিনায়, হেৎদ ইনিকে অকয় হঅ ঝিঁঝরিতে কাকু তল দহ দাড়ি ইচ কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","চিয়াঃচি হড় কু ঘনে ঘনে খাড়ুয়া হেৎদ ঝিঁঝরি তেকু ত্লিচ কেনা,মেন্খান ইনি দ ঝিঁঝরি টটা গিডিট কেনায়, হেৎদ খাড়ুয়া খন্ডচ খুন্ডিচ পেটেজেত কেনায়; যাহায় ইনিকে কাকু বাগত দাড়িয়ায় কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","হেৎদ ইনি মিত সিঙ্গি-নিন্দা সারাঃআ ঘড়ি কবর ডাঙ্গা রে হেৎদ বুরু চেতান রে তাহি কাতে কিকিচ এত কেনায়, হেৎদ ধিরিতে হড়মরে আচ আচতে রগড়া গেদ কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ইনি দ সাঙ্গীং হাতেৎ যীশু কে নেল কাতেত নির আড়গু এন্তে, ইনিকে গড় জহার কিআয়, ");
INSERT INTO cdz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","হেৎদ কিকিচ কাতে কুলি কিআয়, এ যীশু দাড়িয়ান ঈশ্বর রাঃআ হন, আম লঅ ইঞাঃ আ সাগাই কিনা আ ? ইঞ আমকে ঈশ্বর রাঃআ দিব্বি ইমাম তানা, ইঞ কে আলম সাতাঞা। ");
INSERT INTO cdz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","চিয়া চি যীশু আনিকে গামা লিআয়, এ বঙ্গা আত্মা, হিঁই হড় রাঃআ হাঁন্ডে হাতেৎ উদু গদম। ");
INSERT INTO cdz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","যীশু আনিকে কুলি কিঃআয়, আমাঃআ নুতুম কিনা আ? আনি তেলা কেৎআয়, ইঞাআ নুতুম বাহিনী, চিয়া চি আলে গাদা লেকাঃলে। ");
INSERT INTO cdz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","তায়্মতে আনি কঠিন কাকুতি কেৎআয়, যাতে যীশু আনিকে ইনা টলা হাতেৎ আলয় কুদা গিডিই কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ইনা বুরু কাতারে গাদা মারাঃআং সুকরি গট আতিঞ্চ কেনা কু। ");
INSERT INTO cdz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","হেৎদ ইঙ্কূ কাকুতি কেৎ আ কু, ইঙ্কূ সুকরি কুরাঃআ হান্ডে বলঃঅ নাতিনাং আলেকে কুল্লেম। ");
INSERT INTO cdz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ইনি ইঙ্কূ কে সায় এমাৎ কুয়ায়্য় য় ইন্তং ইঙ্কূ বঙ্গ আত্মা কু উডুং কাতেৎ সুকরি রাঃআ হান্ডে কু বলএনা, ইনাতে ইঙ্কূ সুকরি পাল, হান্তে নাতেতে বার জুলু সুকরি, খুব রাঃআগ্তে বুরু রাঃআ ঢালু হরকাতে নির খাজুই নাকু দরেয়া দা আ রে, হেৎদ দরেয়া দাঃআ রে ডুবুজ গজ চাবায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ইন্তং বাগাল ইঙ্কূকে গুপিৎ কুকেনা, ইঙ্কূ নিরেন্তেকু সরগ নাগার রে হেৎদ ডিহি ডিহি তে সেন কাতেৎ খবর কু এম্কেৎ আ। ইন্তং কিনা আ হ্যুয়া কানা, নেনেল নাতিনাং হড় কু হিচ্ এনা; ");
INSERT INTO cdz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","হাতু হড় যীশু রাঃআ হান্ডে হিচ্ কাতে নেল কেৎআয় ইনি বঙ্গা আত্মাভেট হড়, অক্য়্কে বাহিনী বঙ্গা ভেট লিয়ায়, ইনি দ কিচিঃ সিনিপ ভাগয়া কাতেৎ খুশিতে দুপা কানায়; ");
INSERT INTO cdz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","এন্খান গে ইঙ্কূ বর কেৎআকু হেৎদ হানি বঙ্গা আত্মা হড় রাঃআ হেৎদ সুকুরি গট রাঃআ কান্ড অকয় কু নেল লাঃআ, ইঙ্কূ হান্কু কে যত বৃতান্ত কু গামাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ইন্খান গে ইঙ্কূ ইনি কে আকুয়াআ সীমানা হাতেৎ সেনঅ নাতিনাং তিহি-কাটা স্যাপ কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ইনা তায়্ম যীশু ডঁঙ্গা রে দেচঃতান খানে, ইন্তং ইনি বঙ্গা ভেট আত্মা হড়, এনি ইনিকে বিন্তি কিঃআয়, আয়ঃ লঃঅ যাতে তাহি দাড়ি কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","মেন্খান ইনি হানিকে সায় কায় এম দাড়ি লিঃআয়, গামাকিঃআ, আয়াঃআ আত্মীয় কু লঃঅ আমাঃআ অড়াঃতে সেনম দু, হেৎদ প্রভু আমাঃ নাতিনাং অকা হাহাড়া কামিকু কামী তাঃআয়, হেৎদ আমকে অকা কৃপা এমাতাৎ মেয়া, ইনা কু জ্ত্চ কে সারিঞাম তুকা কুম। ");
INSERT INTO cdz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ইন্তং ইনি উডুঁং এন্তে, যীশু আয়াঃআ নাতিনাং অকা অকা হাহাড়া কামি লাতঃআয় ইনাকু দিকাপলি এলাকারে গাম উচ্ছানেৎ আয়, অকয় কু আয়ুম লাআ, এন্খান গে যত হড় খুব কু হাহাড়ায়না। ");
INSERT INTO cdz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ইনা তায়্ম যীশু ডঁঙ্গাতে অটঃ হঅগে পারম হিচেন খান আয়াঃ হান্ডে মিত্গাদা হড় কু হুঁডিএনা; ইন্তং ইনিদ দরেয়া কাতারে তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","হেৎদ জিহুদী জাহের থান রেনিচ কটাল কুরাঃআ তালা হাতেৎ যায়ীর নুতুমান মিৎ হড় হিচ্ কাতেৎ, ইনিকে নেল কাতে আয়া আ কাটারে নুরেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","হেৎদ গাদা বিন্তি কাতেৎ গামা কিয়ায় ইঞাঃআ হনেরাঃআ গ্চা কানায়, আবেন হিচ্ কাতে হানি রাঃআ চেতানরে তিহি বাড়ায় বেন, যাতে হানি দ বেশ কাতে বাঞ্চা কা আয়। ");
INSERT INTO cdz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ইন্তং ইনি হানি লঃঅ সেঃএনায়; হেৎদ গাদা হড় আয়াঃআ তায়্ম তায়্মতে সেএ নাকু, হেৎদ আয়াঃ চেতানরে ধাপা ধাপি কাতেৎ কু নুরুঃ এনা। ");
INSERT INTO cdz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","অটঃ হঅগে মিয়াৎ এরাঃআ হন ১২ সির্মাং উকু আজার (গুপ্ত রোগ) তাহিলেনা, ");
INSERT INTO cdz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","গাদা সায়্পু (ডাক্তার) লিয়া গাদা হার্কেৎ নাম তাৎ আয় হেৎদ সর্ব্বস বেয়্য় কাতে রহঃঅ যাহানা আ উপশম কা হুয়া কানা, বরংচ অটঃ হঅগে বেরাঃআম ভাড়াঃ কানা। ");
INSERT INTO cdz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ইনি দ যীশু রাঃআ বাব্ত্তে আয়ুম কাতেৎ ভিড় রাঃআ তলাতে হিচ্ কাতে তায়্ম হরতে যীশু রাঃআ কিচি জুটেৎ লাত আয়। ");
INSERT INTO cdz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","চিয়াঃ চি ইনি গাম লাত আয়, ইঞ যদি যীশু রাঃআ কিচিঃ জুটেৎ দাড়িয়াঞ, এন্খান ইঞ দ বেশ গেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","হেৎদ ইন্তং গে ইনি রাঃআ মায়ম লিঙ্গী থাম্বানা; হেৎদ আচ তেগে বেরাঃআম বেসেনা হড়ম রে আটকার ঞাম কেৎআয়। হাসু য়ান বেরাঃআম হাতেৎ ইনি দ বেসেনায় ইন্তং ইনি হানি লঃঅ সেঃএনায়। ");
INSERT INTO cdz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","যীশু ইন্তং গে অন্তর্তে আটকার নাম কেৎআয় চি আয়ায়্য় হান্ডে হাতেৎ দাড়ি উডুঙ্গা কানা, এন্খান ভিড় রাঃআ তালা হাতেৎ মচা গুরাঃআ কাতেৎ কুলি কেৎ কুয়া, অকয় ইঞাআ কিচিপে জুটেৎ কেৎ আ ? ");
INSERT INTO cdz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ইনি রাঃআ চেলাকু গাম রুয়াড় কেৎ আ, কাম ঞেনেল তানা চিল্কা হড়কু আমাঃ আ চেতান রে গড়া গড়ি তানা, তবু রঃঅম কুক্লি তানাম, অকয় ইঞকে জুটেৎ কিঃইঃঞা? ");
INSERT INTO cdz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","মেন্খান অকয় নিয়া কামী তাত্যায়, হানিকে ঞেল নাতিনাং ইনিদ হান্তে নান্তে কয়ঃ গুরাঃআ কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","এন্খান্গে ইনি এরাঃআ হন বরতে থার থারাঃআ কাতেৎ, আচ লঅ কিনা আ হ্যুয়া কানা, গাম নাতিনাং আয়ায়্য় সামাংরে হিচ্ কাতেৎ উকড়ু মেনায়, হেৎদ সার্তিয়া কু যত গাম কেৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ইন্তং যীশু হানিকে গামাকিঃয়ায়্য় এ কুড়ি হন, আমাঃ আ পাতিয়া আমকে বেশ তাৎ মায়, সুলুকতে দু সেনম, হেৎদ আমাঃ আ হান্ডে হাতেৎ বেরাঃআম সাঙ্গীঞরে তাহিকা আ। ");
INSERT INTO cdz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ইনি নিয়া থুতি জাগার তানায়, ইন্তং গে জাহের থান রেনিচ হড় কটাল রাঃআ অড়াঃ হাতেৎ হিচ্ কাতে গামাঃকিয়ায়্য়, আমাঃ আ হনেরাঃআ গচঃআ কানায়, গুরু কে চিয়াঃ কষ্ট এমাই তানাম ? ");
INSERT INTO cdz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","মেন্খান যীশু ইনা থুতি আয়ুম কেৎখান জাহের থান রেনিচ কটাল কে গামাঃয়ায়্য়, আলম বরয়া, সুদু পাতিয়া দহম। ");
INSERT INTO cdz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","হেৎদ যীশু দ পিতর, যাকোব, হেৎদ যাকোব রাঃআ হাগা যোহন, নুকু অপি হড়কে বিনা এটাঃ জাহায়কে আচ ল অ সেনঃ নাতিনাং কায় সতুঃ লাত্কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ইনা তায়্ম ইঙ্কূ জাহের থান রেনিচ রাঃআ কটাল অড়াঃতে হিচেনা কু, হেৎদ ইনি ঞেল কেৎআয়ায়্য়, এন্ডে খুব হই চই হয়ু তানা, হড় কু খুব ইয়াম হেৎদ হমরেৎ তানাকু। ");
INSERT INTO cdz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","যীশু ভিতির তে বলঃঅ কাতেৎ ইঙ্কূ কে কামাৎ কুয়ায়্য় আপে দ কিকিইচ কাতে ইয়াম-হমর তানা পে চিয়াৎ ? হনেরাঃআ দ কায় গ্চাকানায়, গিতিচা কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ইন্খান্গে যীশু কে উপ্হাস কিয়াঃকু; মেন্খান ইনি জ্ত্চ কে বাহার্তে উডুং কেৎ কুতে, কুড়ি হন রাঃআ এঁগা -অপুকে হেৎদ আয়ায়্য় চেলা কু লঅ ভিতির তে বলয় নাকু, ক্দেরে কুড়ি হন গিতিচা কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ইনা তায়ম ইনি কুড়ি হন রাঃআ তিহি স্যাপ কাতে ইনিকে গামা কিঃআয়, ট্লিথা কুমী, তলাজোখা লেখান নেকা তিগুনা, কুড়ি হন, আমকে গামাম তানাইঞ, বিরিৎ মে, ");
INSERT INTO cdz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","এন্খান্গে ইন্তং গে বিরিৎ কাতে দাড়াভাড়া কেৎ আয়্য়, চিয়া চি হানি রাঃআ উমুর দ ১২ সির্মাং তাহীন কেনা, ইনাতে ইঙ্কূ যত হড় খুব কু চমকা হেৎদ হাহাড়ায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ইনা তায়্ম যীশু হড় কু কে কডরাঃআ জাগার এমাৎ কুয়া, যাতে যাহায় আলকু সারিনামে কা আ, হেৎদ হনেরাঃআ কে যাহানা আ গে জম নাতিনাং জাগার এমাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ইনা তায়্ম যীশু কাপারনাহুম হাতেৎ উডুং কাতেৎ আয়ায়্য় হাতু নাজারেথ তে হিচ্ এনায়, হেৎদ আয়ায়্য় চেলা কু হঅ আয়ায়্য় তায়্ম তায়্মতে হিচেনা কু। ");
INSERT INTO cdz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ঝিরাঃআ মাহা সেটে রেন্খান যীশু দ জাহের থান রে চেচেদ উচ্চানেৎ আয়; এন্খান্গে গাদা হড় আয়ায়্য় উচ্চান আয়ুম কাতেৎ হাহাড়ায় এন্তেকু গাম কেৎ আয়্য়, হিঁঃরাঃআ নেন্কান জ্ঞান কদের হাতেৎ হিচা কানা? হিঁঃকে ঈশ্বর রাঃআ জ্ঞান এমা কানা ? হিঃই রাঃআ তিহি তে নেন্কান পরাঃআক্রম কামী যত পুরাঃআ ইদিতানা, নিয়া দ কিনা আ ? ");
INSERT INTO cdz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ইনিদ কিনাআ ইনি কাঠুয়া (ছুতার মিস্ত্রি)কারি গারি, মরিয়াম রাঃআ ইনি হন হেৎদ যাকোব, যোসি, যীহুদা হেৎদ শিমন কুরাঃআ হাগা চি ল্হয় ? হেৎদ ইনি রাঃআ মিসি চি আবু লঅ বানু কুয়া? নিয়া লেকাতে ইঙ্কূ যীশু নাতিনাং বিগ্ন ঞামে তানাকু। ");
INSERT INTO cdz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ইন্তং যীশু ইঙ্কূ কে গামাৎ কুয়া, আমাঃ নিজ দিসুম, আত্মীয় স্বজন হেৎদ আমাআ নিজ অড়াঃ ছাড়া ইটা জাহাদরে ভাবি জাগারিচ ম্যানখাট কায় হ্যুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ইন্তং যীশু ইনা ঠাওরে যাহানা হাহাড়া কামী কায় দাড়ি তাআয়, কটা রুয়া আজার হড়কু রাঃআ বহ রে তিহি এম কাতে বেশ তাৎকুয়া ইঙ্কূ কে। ");
INSERT INTO cdz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","হেৎদ ইনি ইঙ্কূয়া কা পাতিয়া খাতির হাহাড়ায় নায়। ইনা তায়ম ইনি গটা হাতু হাতু গুরাঃআ বাড়া কাতেৎ জাগার উচহান কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","হেৎদ যীশু ইঙ্কূ ১২ হড় কে রাঃআ কাতেৎ বাবার হড় কাতেৎ ইঙ্কূ কে কুলে এতব কেৎআয়ায়্য়; ইঙ্কূ কে বঙ্গা আত্মা রাঃআ চেতান রে ক্ষমতা এমাৎ কুয়ায়্য় য় ; হেৎদ হুকুম এমাৎ কুয়ায়্য় ; ");
INSERT INTO cdz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","আপে হরাঃআ সেশেন নাতিনাং, হড় পিছু মিয়াৎ কাতে হাপা বেগর যাহানা আ আলপে দহ্যায়্য়, পিঠা হঅ ল্হয়, ঝলা হঅ ল্হয়, জেন্গিয়া রাঃআ কাউডি আনা হঅ ল্হয়, ");
INSERT INTO cdz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","মেন্খান কাটারে খরম তুসিনঅ পে, হেৎদ বাড়িয়া সনঅ আলপে তুসিং আ, ");
INSERT INTO cdz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","যীশু চেলাকু কে অটঃ হ অঃগে গামাৎ কুয়ায়্য় য় আপে জাহাদরে যাহায় রাঃআ অড়াঃ পে বলনা, ইনা হাতু হাতেৎ কা উডুং অব্দি ইনা অড়াঃ রেপে তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","অটঃহঅ অকা হাতুরেন্কু হড় কাকু আতাং পেয়া ইঙ্কূ আপেয়ায়্য় থুতি কাকু আয়ুমেয়া এন্ডে হাতেৎ উডুং বেত্রাঃআং আকুকে পাহাম নাতিনাং হেৎদ লুকুন্দী নাতিনাং কাটা ধুড়ি কটা ধরাঃআয়পে। ");
INSERT INTO cdz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ইনা তায়্ম এন্ডে হাতেৎ উডুং কাতে নেকা কু উছান কেৎআ যে, হড় কু মনে কু ঘুরআ কা আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","হেৎদ ইঙ্কূ গাদা বঙ্গা আত্মা কুকে কু কুদা কেৎ কুয়া, হেৎদ গাদা রুয়া হড় কুকে সুনুম অজঃ কাতেৎ বুগি কেৎকুয়া কু। ");
INSERT INTO cdz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","অটঃহঅ হেরদ রাঃআজা যীশু রাঃআ থুতি আয়ুম নাম কেৎ আয়্য়, চিয়াদ চি যীশু রাঃআ নুতুম গটা পাসনা লেনা। ইন্তং ইনি গাম কেৎআয়্য়, ডুবুলিচ যোহন গজকু হাতেৎ জিউৎ বিরিৎআ কানায়, ইনা খাতিরাঃআং হাহাড়া কামী যত পুরাঃআ ইদিই তানা, ");
INSERT INTO cdz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","মেন্খান অকয় অকয় কুদ কু গাম কেৎআ, ইনিদ ইলিয় তানায়, অটঃহঅ অকয় অকয় কুদ কু গাম্কেৎআ ইনি দ মিৎ হড় হাপেন জাগারিচ, ভাবিজাগারিচ কু রিনিচ মিৎ হড়। ");
INSERT INTO cdz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","মেন্খান হেরোদ ইনি রাঃআ থুতি আয়ুম কাতেৎ গাম কেৎ আয়, ইঞ অকয় যহন রাঃআ বহঃ মাঃআ টটাঃ লাত আঞ, ইনিগেয় জিউৎ বিরিৎআ কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","চিয়াঃ চি হেরোদ আয়া আ হাগা রাঃআ বাহু এরাঃআ হেরদিয়া রাঃআ খাতির আয়ায়্য় হড় কে কুল কাতে যহন কে সাপ আগু কাতে জিহাল রে খাঁজু লিয়ায়্য়, চিয়াঃ চি ইনি দ হানি কে দুতাম লিতায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","যহন হেরদ কে গামালিয়ায়, বকম রাঃআ বাহু কে দহ রাঃআ আমাঃ আ ব্যবস্থা ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ইনাতে হেরদিয়া ইনিকে রাঃআগ তে গজ নাতিনাং কুরু মুটুৎ কেনায়, মেন্খান কায় দাড়িয় কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","চিয়াঃ চি হেরদ দ যহন কে ধর্মিক হেৎদ নিরাঃআলা মান্মি মেন্তে বরআই কেনায় হেৎদ হানিকে বাঞ্চা ইদিই কেনা। হেৎদ ইনি রাঃআ থুতি আয়ুম নাতিনাং খুব উকসুক কেনায়, হেৎদ ইনি রাঃআ থুতি আয়ুম খুব বেশ এ আটকারেৎ কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ইনা তায়্ম মিৎ মাহা অক্ত হিচেনা, অকা হুলাং হেরদ রাঃআ জনম মাহা সেটেরেন খান আয়ায়্য় মানতান হড় কুকে, সেনা লাউড়িয়া কুকে হেৎদ গালীল রিঙ্কূ বহ বহ হড় কুরাঃআ মিয়াৎ আয়ুপ রাঃআ ভোজ মাডি সাপড়া লাৎআয়; ");
INSERT INTO cdz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","হেৎদ হেরদিয়া রাঃআ হনেরাঃআ হিচ্ কাতেৎ এনেছ তে হেরদ কে হেৎদ হিচ্ হুন্ডি লেনাকু ইঙ্কূ জ্ত্চ রাঃআ মন অন্তর খুশিতে ভিদা কেৎখান। রাঃআজা হনেরাঃআকে গামা য়ায়্য়, আমাঃ আ কিনা ইচ্ছা, আসীঞমে, আমকে ইনাগে এমা মেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","হেৎদ হেরদ রাঃআজা স্পত কাতে গাম কেৎআয়্য়, তারাঃআকেচাঃ পরগনা পর্যন্ত হযুকাঃআ, ইঞা হান্ডে অকা গেম আসিয়া, ইনা গেঞ এমামেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ইন্খান গে ইনি উডুং এন্তে, মাই তেৎ কে কুলি কি আয়, কিনা আঞ আসিয়া? ইনি গাম রুয়াড় কেৎআ য়, ডুবানিচ যহন রাঃআ বহ অ। ");
INSERT INTO cdz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ইনি ইন্তং গে রাঃআজা রাঃআ হান্ডে হিচ্ কাতে ইনাগে আসি কেৎ আয়্য়, গাম কেৎ আয়, ইঞআ আসি নিয়া তানা, নাহাঃ গে যোহন ডুবানিচ রাঃআ বহঅ থাড়ি রে আগুয়াঞমে। ");
INSERT INTO cdz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ইন্তং রাঃআজা দ কুঠিনে দুখালীন রেহঅ আয়ায়্য় মানত নাতিনাং হেৎদ অকয় কু যজম হিচ্ লেনা, ইঙ্কূয়া বরতে ইনিকে যাহানাআ কায় গাম রুয়াড় দাড়ি লিঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","রাঃআজা ইন্তংগে মিয়াৎ সেনা কে কুল কাতে যোহন ডুবানিচ রাঃআ হটঅ মাআ টটাঃ কাতে বহঅ আগু নাতিনাং হুকুম কেৎ আয়; হানি জিহালতে সেন কাতে যোহন ডুবানিচরাঃআ হটঅ মাআ টটা কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ইনা তায়্ম থাড়ি রে বহ অ আগু কেৎতে ইনি কুড়ি হনকে এমা কিঃআয়, হেৎদ ইনি কুড়ি হন মাই তেৎ কে এমা কিঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","নিয়া খবর আয়ুম কাতে আয়া আ চেলা কু হিচ্ কাতে হড়ম কু ইদি কাতে খানারে কু তপা কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ইনা তায়্ম কুলিচ কু যীশু রাঃআ হান্ডে হিচ্ কাতে হুন্ডিনাকু; হেৎদ ইঙ্কূ কিনা কিনা আ কামী কু করাঃআ লাৎ আ, হেৎদ অকা চেচেদ দা আ কু চেদ্লেদ কুয়ায়্য় , ইনা জ্ত্যায় ইনিকেকু গামাকিয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","যীশু ইঙ্কূকে গামাৎ কুয়া, আপে নিরিবিলি মিয়াৎ ঠাওরে হুন্ডি কাতে হুডাং ঝিরাঃআ পে। চিয়াঃ চি গাদা হড় হিজু সেন তানা কু,ইনাতে ইঙ্কূয়া জমা নুয়া রাঃআ জাহান অক্ত বায়ানা। ");
INSERT INTO cdz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ইনা তায়্ম লাউকা রে দেচ কাতে নিরিবিলি তেকু সেএনা, ");
INSERT INTO cdz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","মেন্খান হড় কু ইঙ্কূ কে সেন নেল্তা কুয়া কু, হেৎদ গাদা হড় ইঙ্কূকে কু চিন্হা নামতা কুয়া, ইনাতে গটা সরগ নাগার হাতেৎ নির নিরতে আকুয়াআ আ মাড়াং তে সেটেরেনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ইন্তং যীশু উডুং কাতে নেলকেৎ কুয়ায়্য় য় কুঠিন দায়া আটকার কেৎআয়। চিয়া চি ইঙ্কূ দ আতিনিচ বিনা ভিডি কু লেকা মেনা আ কুয়া; ইন্তং ইনি ইঙ্কূকে গাদা বাব্দতে চেচেদ এমাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ইনা তায়্ম সিঙ্গি চাবা হিজু তান খান, আয়ায়্য় চেলা হিচ্ কাতে কু গামা কি আয়্য় নিয়া দ নিচল ঠাও, হেৎদ বেলা হঅ ডুবুজ ইদি তানা ; ");
INSERT INTO cdz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ইঙ্কূকে কয়্তুকা এমাকুম, ইঙ্কূ যাতে হাতু হাতু তে সেন কাতে জমা নুয়ায়্য় কিরিং দাড়ি কা আ কু, ");
INSERT INTO cdz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","মেন্খান ইনি ইঙ্কূকে গাম রুয়াড় এত কুয়া, আপেগে ইঙ্কূকে হুডাঙ জমা এমাকুপে। ইঙ্কূ গাম কেৎআ কু, আলে ২০০ সিকি রাঃআ পিঠা কিরিং আগু কাতেত জম তুকা কুয়ালে চি ? ");
INSERT INTO cdz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","যীশু ইঙ্কূকে কুলি কেৎ কুয়া, আপেয়া হান্ডে চিন্তিত লেকা পিঠা মেনা আ ? নেলেপে দু। ইঙ্কূ নেল কাতেত কু গাম কেৎ আ, মড়েয়া পিঠা হেৎদ বারিয়া হাকু মেনা আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ইন্তং যীশু জ্ত্চ কে ঘাসাড় চেতান রে থার থার দুপ নাতি নাং বাত্লাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ইঙ্কূ ১০০, হেৎদ ৫০, হড় কাতেত থার থার কু দুপেনা। ");
INSERT INTO cdz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ইনা তায়্ম ইনি মড়েয়া পিঠা হেৎদ বারিয়া হাকু সাপ কাতে স্বরগ দর কয়ঃ কাতে সারাঃআও কেৎ আয় হেৎদ ইনা পিঠা কেচা কুচু কাতেত হড়কুকে জমা নাতিনাং চেলা কুকে এমঅ গামাত কুয়া; অটঃ হঅ ইঙ্কিন বারিয়া হাকু কে হ অ জ্ত্চ কে হাটিং এত কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ইন্খান্গে জম কাতেত যত হড় তৃপ্তি কু নাম কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","হেৎদ জম তায়্ম সাকড়ী গুন্ডা কু ১২ ঝুড়িয়া হেৎদ হাকু গুন্ডা হ অ হাউর পেরাঃআচ কেৎআ কু। ");
INSERT INTO cdz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","যজম অকয় কু দুপ লেনা, ইঙ্কূ দ মড়ে জুলু কড়া হড় কু তাহিলেনা। ");
INSERT INTO cdz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ইনা তায়্ম ইন্তং গে কাজাগ তে আয়ায়্য় চেলা কুকে গামাত কুয়া, যাতে লাউকা রে দেচ কাতে আয়ায়্য় মাড়াংতে হানা কাতা বেত সোডার দর কু সেন কা আ। হেৎদ ইন্তং গে হড় কুকে কয়্তুকা এমাত কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","হড় কুকে কয়্তুকা এম কাতেত যীশু দ বিন্তি নাতিনাং বুরু চেতাং তে দেচ এনায়। ");
INSERT INTO cdz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","আয়ুপ এন খান, ইন্তং লাউকা দরেয়া রাঃআ তালা মালারে তাহি লেনা, হেৎদ ইনি দ একলা গে বুরু রাঃআ মিৎ কাতা রে তাহি লেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ইনা তায়্ম যীশু নেলনাম কেৎআয় সামাং দর হাতে হ্যয়্য় হিজু নাতিনাং লাউকা সামাং দর ইমতিনাং চেলা গাদা কু কষ্ট তানা নেল কাতেত, ইনি নিদা উপুন পহর কুতে দরেয়া চেতাং তে তাড়ম কাতে আকুয়াআ এন্তে হিচ্ এনায়, হেৎদ ইঙ্কূ কে পারম কাতেত সমাং দর সেন নাতিনাং মহড়া হাতা কেৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","মেন্খান দরেয়া চেতাং তে তাড়ম কু নেল কিচ খান মনে কেৎ আকু, বঙ্গা উবুল তানা, হেৎদ কিকিচ কেৎ আ কু; ");
INSERT INTO cdz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","চিয়াঃ চি যত হড় ইনি কে কু নেল লিচআ হেৎদ বর চাবা লেনাকু। মেন্খান যীশু ইন্তং গে ইঙ্কূ লঅ থুথি এনায়, ইঙ্কূ কে গামাত কুয়া, সাহস দহয় পে, ইঞ গে, আল্পে বরয়া। ");
INSERT INTO cdz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ইনা তায়্ম আকুয়াআ হান্ডে লাউকা রে দেচ এনায়, হেৎদ হ্যয়্য় থিরেনা, এন্খান গে ইঙ্কূ হাহাড়ায় না কু। ");
INSERT INTO cdz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","চিয়াঃ চি পিঠা রাঃআ বাব্ত্তে আন্থিত টা কাকু সারি নামতা আ, ইঙ্কূ আ অন্তর গেয়ান লুম্বা আ লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ইনা তায়্ম ইঙ্কূ পাড় কাতা তেকু হিচেনা, গিনেষরৎ প্রদেশ তে হিচ্ কাতে লাউকাকু ভিড়া কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","হেৎদ লাউকা হাতে যত হড় আড়গু হিচ্এন খান কু যীশুকে চিন্হা নাম্কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ইনা টলা রাঃআ চুতুর দর নির ভাড়াকেৎ আ কু, হেৎদ রুয়া আশু হড় কুকে পারকমতে গঅ আগুত কেনাকু কদেররে তাহীন কেনায় মেন্তে কু আয়ুম লাআ এন্ডে আগু কু এতব কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","অটহঅ হাতু রে, চি সরগ নাগার রে, চি টলা রে অকা ঠাও কুরে সেন কেনায়, ইনা ঠাও কুরে ইঙ্কূ রুয়া আশু হড় কুকে আয়া আ সমাং রে কু হাটেৎ কুকেনা, হেৎদ আচ কে বিন্তি কিয়া কু, যাতে ইঙ্কূ যীশু রাঃআ কিচি কু জুটেৎ নামদাড়ি কা আ, হেৎদ চিমিন হড় যীশু কে জুটেৎ লিয়াকু যত হড় কু বেশ চাবা লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","অটহঅ মিৎ হুলাং ফরাঃআসী কু হেৎদ গটা কয়েক কটাল যীরুশালেম হেতে হিচ্ কাতে আয়ায়্য় হান্ডে হিচ্ হুন্ডি নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","উঙকু নেল কেৎআ কু, উঙকু গটা কথক চেলা বিন সাপা তিহিতে মানে তিহি কা আবুন কাতে কু জমেত কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ফরাঃআসিকু হেৎদ জিহুদিকু যত মুরুব্বি কু ব্যবস্থা রেয়াজ মান্য় কাতে বেশ লেকা তিহি কা আবুন কাতে কাকু জমেত কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","অটহঅ গে বাজার হাতে হিচ্ কাতে কা উম ভুর কাকু জ্মেয়া; অটহঅ উঙকু গাদা বাব্ত্তে মান্য়্য় গন্য নাতিনাং ভহালকু তাহিন কেনা, নেকা, ঘুটি, বাটি, হেৎদ পিতল রাঃআ নানান্হুনার থারি বাটি গাসার। ");
INSERT INTO cdz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ইনা তায়্ম ফরিসীকু হেৎদ কটাল কু ইনিকে কুলিকিয়া আ কু, আমাঃ আ চেলা কু মুরুব্বি কুরাঃআ ব্যবস্থা রেয়াজ তে কাকু সেসেনা, মেন্খান বিন আবুন তিহিতে কু জ্মেয়া চিয়া আ ? ");
INSERT INTO cdz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","যীশু উঙকু কে গাম রুয়াড় এত কুয়া,ক্পটিয়া কু, জিসায় আপেয়া আ বাব্ত্তে তে বিলক্ষন ভাবিজাগার লাত আয়, চিল্কা অল মেনা আ, নুকু হড় কু দ মচাতে ইঞকে কু মানতিঞা, মেন্খান অন্তরআত্মা দ ইঞা হান্ডে হাতে গাদা সঙ্গীরে মেনা আ; ");
INSERT INTO cdz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","নুকু দ অনর্থক ইঞা কু রদনেয়া কু, মান্মি রাঃআ তেয়ারাঃআ গে ধর্ম সূত্র মেন্তে চেদেৎ কুয়া কু । ");
INSERT INTO cdz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","আপে দ ঈশ্বর রাঃআ হুকুম বাগি কাতে মান্মি রাঃআ মারি ব্যবস্থা রেয়াজ সাপ দহ তাৎ গেয়াপে, ");
INSERT INTO cdz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","যীশু উঙকু কে অটহঅ গামাৎ কুয়া, আপে মারি ব্যবস্থা রেয়াজ মানাও নাতিনাং আপে ঈশ্বর রাঃআ হুকুম বিলক্ষণ অমান্য় তাৎ আপে। ");
INSERT INTO cdz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","চিয়া চি মুশা গাম লাত আয়' আম আমাঃ আ আপু কে হেৎদ মাই কে মানা গুনা কিনমে, অটহঅ গে ' অকয় গে অপু রাঃআ চি মাই রাঃআ নিন্দা য়ায়, ইনি রাঃআ জীউ নাশ কাঃআ' ");
INSERT INTO cdz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","মেন্খান আপে গাম ভাড়ায়াপে, মান্মি জ্দিপি অপুকে বাখান মাইকে গামায়ায়, ইঞা আ হান্ডে হাতে অকা আমাআ উপ্কার হুই খাতির আমকে এম নাতিনাং তাহি লেনা, ইনা দ ঈশ্বর বা কে সম্পা হ্যুয়া কানা' ");
INSERT INTO cdz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","এনে ইঙ্কা লেকা আপে উঙকু কে অপু রাঃআ চি মাই রাঃআ নাতি নাং যাহানা আ কাপে করাঃআ তুকা কু তানা। ");
INSERT INTO cdz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","নেকা লেকাতে আপেয়া স্ম্পায়ান মারি ব্যবস্থা রেয়াজ লিয়া আপে ঈশ্বর রাঃআ জাগার বরাঃআ তাৎ আপে; নেন্কা কাতে গাদা কামী কূপে করাঃআ গুতাৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ইনা তায়্ম যীশু হড় কু কে অটঃ অ গে আয়ায়্য় কাতাতে রাঃআ হুন্ডি কাতে গামাৎ কুয়া, আপে যত হড় ইঞা জাগার আয়ুমেপে হেৎদ আটকারেপে ");
INSERT INTO cdz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","মান্মি রাঃআ বাহার রে এনে এঙ্কানা আ যাহানা বায়না অকা আ ভিরিতে সেন কাতে ইনিকে বাড়িছ দাড়িয়াইয়া; মেন্খান অকাঃআ কু মান্মি রাঃআ ভিতির হাতে উডুং হিজু আ ইনা কুতে গে মান্মি কেকু বাড়িছ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","অকয় রাঃআ আয়ুম নাতিনাং লুতুর মেনাআ ইনি আয়ুমে কাঃআয়; ");
INSERT INTO cdz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ইনা তায়্ম হড়কু রাঃআ হান্ডে হাতেৎ হিচ্ কাতে অড়া তে কু বলঃঅ আদেরেন খান আয়া আ চেলা কু যীশু কে ইনা উপমা রাঃআ ভেদ কু কুলি কি আ। ");
INSERT INTO cdz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","যীশু উঙকু কে গামাত কুয়া, আপে হ অ চি আন্তীতগে লেলাহা ? আপে দ চি কাপে আটকার নামে তানা, অকা আ কু বাহার হাতেৎ মান্মি রাঃআ ভিতির তে বলনা, ইনাকু তে দ ইনি কে কায় বাড়িছ দারিয়ায়্য় ? ইনা মাত আয়া আ অন্তরআত্মা তেমা কা বলন তানা, ");
INSERT INTO cdz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","মেন্খান লাহিচ্ রে বলন তানা, হেৎদ লাহিচ্ থুলিরে ন্রুয়া, নেকান থুতিতে ইনি দ যত জমা আ বেসা মেন্তে গাম কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ইনি অটহঅ গে গাম কেৎআ য়, মান্মি রাঃআ হান্ডে হাতেৎ অকা উডুং হিজু য়া, ইনা কুতে গে মান্মি কে ছুতিয়া য়া। ");
INSERT INTO cdz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","চিয়াঃ চি ভিতির হাতেৎ, মান্মি রাঃআ অন্তরআত্মা হাতেৎ, কুচিন্তা উডুং হিজু য়া, রেন্ডিবাজ, কুম্ড়ু, মান্মিগচ ");
INSERT INTO cdz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","হড়মালটম, কাঙলা,চর্পট, চালাকি, লম্পট, বদনজর, ঈশ্বরনিন্দা, ঠেঁটকরলা, হেৎদ লেলাহা। ");
INSERT INTO cdz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","নিয়া যত বাড়িছ জিনিষ ভিতির হাতে উঠুং হিজু য়া, হেৎদ মান্মি কে ছুতিয়া য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ইনা তায়্ম বিরিৎ কাতে ইনা ঠাও হাতে সোর্ হেৎদ সিদন টলা দরে তাড়ম কেৎআয়। হেৎদ যীশু মিয়াৎ অড়া আ রে বলয় এনায়, ভাবালাত আয় যাতে যাহায় আলকু সারি নামে কা আ, মেন্খান উকুরে কায় তাহি দাড়িলাৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ইন্তং গে মিয়াৎ এরাঃআ হন, অকয় রাঃআ মিয়াৎ হনেরাঃআ তাহিলেনায়, হেৎদ ইনিকে বঙ্গা আত্মা নাম লিআ, যীশু নেডে মেনাইয়া সারি নাম কেৎতে, হিচ্ কাতে ইনিদ যীশু রাঃআ কাটারে নুরেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","এরাঃআহন দ গ্রীকতানায়, যাইত তেদ সুর ফৌনিকি। ইনি দ যীশু কে বিন্তিতে গামাই তানা, যাতে যীশু আয়ায়্য় হনেরাঃআ রাঃআ হান্ডে হাতেৎ বঙ্গা ছাডাই কা আয় ");
INSERT INTO cdz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","যীশু হানিকে গামা কি আয়্য়, নিজেরাঃআ হন হপন মাড়াং কু ত্রপ্তি কা আ, চিয়াঃ চি হন হপন রাঃআ জমা আ সেতা রাঃআ সামাং রে গিডিদ বেশ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","মেন্খান এরাঃআ হন দ ইনিকে গাম রুয়াড় কেৎআয়, হে, প্রভু, সেতাকু হ অ মাচিত লাতারে হন কুরাঃআ নুর সাকড়ী জ্মেগেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ইন্তং যীশু হানি কে গামাকিয়ায়,আম বেস্গেম গামতাৎআ, সেনম দু, হনেরাঃআ তামা রাঃআ হান্ডে হাতেৎ বঙ্গা ছাড়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ইনা তায়্ম হানি অড়াতে সেন কাতে নেল কি য়ায়্য়, হনেরাঃআ তায়া আ পারকমরে গিতিচা কানায়, হেৎদ বঙ্গা উডুং গিডিয়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ইনা তায়্ম যীশু সোর্ সরগ নাগার হাতে উডুং এনায় হেৎদ সিদন হরলেকাতে দিকাবলি টলা তালা হরকাতে গালীল দরেয়া কাতাতে হিচেনা য়। ");
INSERT INTO cdz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ইন্তং হড়কু মিয়াৎ কালা ততড়া হড় কে আয়া আ হান্ডে আগু কাতে বিন্তি য়ায়কু, ইনি রাঃআ বহ রে তিহি এম নাতিনাং, ");
INSERT INTO cdz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","যীশুদ হানি কে হড় রাঃআ ভিড় হাতে উডুং কাতে একলা গে নিরিবিলি দরে আগু কি তে আয়া আ কাটুঃ হানি রাঃআ লুতুর রে সাম্বা কেৎআয়, বেইচ কেৎআয়, হেৎদ হানি রাঃআ আলাংরে মাখা কেৎ আয়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","হেৎদ ইনি চেতাং সরগ দর কয় অ কাতে জিলিং নিশ্বাস হাতা কাতে গাম কেৎ আয়্য়, ইপ্ফাতা, মানে নিজকা আ। ");
INSERT INTO cdz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","এন্খান গে হানি রাঃআ কালা লুতুর নিজএনা, লাঠা আলাং বেসেনা, হেৎদ হানি টিকঠাক থুতি কেৎআয়, ");
INSERT INTO cdz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ইনাতে হড়কুকে গামাৎ কুয়া, নিয়া ঘটনা যাহায় কে আল্পে গামা কুয়া; মেন্খান যীশু চীনতীৎ মানাৎ কুয়ায়্য় , ইন্তিৎ গে উঙকু গাম পাসরাঃআয় তানা কু। ");
INSERT INTO cdz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","হেৎদ গাদাকু হাহাড়ায় না, গামকেৎআ কু, যীশুদ যতআগে বুগিন লেকানা আ কামী তাত আয়, যীশুদ কালা কুকে আয়ুম নাতিনাং দাড়ি, হেৎদ ববা কুকে থুথি দাড়ি রাঃআ দাড়ি দানাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ইনা অক্ত অটহঅগে হড়কু হিচ্ হুন্ডিনা হেৎদ উঙকুয়া হান্ডে জমা রাঃআ যাহানা কা তাহি লেনা, এন্খান যীশু চেলা কুকে আয়ায়্য় হান্ডে রাঃআ হুন্ডি কেৎ কুতে কুলি কেৎকুয়ায়্য় , ");
INSERT INTO cdz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","নুকু হড়কু নাতিনাং ইঞয়ায়্য় দায়া হযুতানা; চিয়াঃ চি নুকু হড়কু তিহিং অপি মাহা রেঙ্গেচ তে আবু লঅ মেনা কুয়া, আকুয়াআ হান্ডে জমা রাঃআ যাহানা বায়া না। ");
INSERT INTO cdz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","হেৎদ ইঞ পালেৎ নিকুকে জমা কা এম কাতে রেঙ্গতে অড়াঞ কুলকুয়া, তবে খান হরাঃআরে উঙকু ফিটয়াকু, অটহঅ গে অকয় দ গাদা সান্গিং হাতে কু হিচা কানা। ");
INSERT INTO cdz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","যীশু রাঃআ চেলাকু গাম রুয়াড় কেৎ আ, নিয়া তালা পিড়িরে অকয় কদের হাতে পিঠা আগু কাতে জম তুকা কাতে যত হড় কে তিপ্তি এমাকুয়ায়্য় য় ? ");
INSERT INTO cdz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","যীশু ইঙ্কূ কে কুলি কেৎ কুয়া, আপেয়া হান্ডে চিমিন টা পিঠা মেনা আ ? ইঙ্কূ কু গাম কেৎআ ৭ ইয়া। ");
INSERT INTO cdz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ইনা তায়্ম ইনি হড় কুকে হাসা চেতাং রে দুপএ গামাৎ কুয়া হেৎদ ইনা ৭ ইয়া পিঠা সাপ কাতে সারাঃআও এম্ কেৎতে কেচ্চা কুচ্ছু কাতে ইঙ্কূ য়া সমাং রে আগু কাতে এমাৎ কুয়া ");
INSERT INTO cdz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","আকুয়াআ হান্ডে হুন্ডাঙ হাকু কু হঅ তাহিলেনা, ইনি হাকু কে হ অ সারাঃআও বিন্তি কাতে আকুয়াআ সমাংরে এমাৎ কাতে গামাৎ কুয়ায়্য়। নেকালেকা হড়কু জম বি কাতে তিৃপ্তি নাকু; ");
INSERT INTO cdz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ইনা তায়্ম ইঙ্কূ গুন্ডা গুন্ডি ৭ ঝুড়ীয়া হাউর গুটিয়া কেৎআ কু। ");
INSERT INTO cdz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","উপুন জুলু হড় কু কম বেশী তাহিলেনা; ইনা তায়্ম ইঙ্কূ কে কুলরুয়াড় কেৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","হেৎদ ইন্তং গে ইনি চেলা কু লঅ লাউকারে দেচকাতে দলমনুথা এলাকাতে সেএনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ইনা তায়্ম ফরাঃআসীকু বাহার তে হিচ্ কাতে ইনি লঅ তেংগাড়া তেংগরি মচাত আকু, নিরাঃআলা হাতে মিয়াৎ চিন্হা নেল নাতি নাং বিডা লেকাতে আয়ায়্য় হান্ডে কুক্লি কু দহ কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ইন্তং ইনিদ রিলামালা আত্মা জিলিং নিঃস্বাস আড়া কেৎতে গামাৎ কুয়া, নিয়া কালরেন্কু মান্মি চিয়া চিন্হা পাঞ্জাৎ আকু? ইঞ আপেকে সার্তি সার্তি গেঞ গামাপে তানা, নুকু মান্মি কে জাহান চিন্হা উদু কা হ্য়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ইনা তায়্ম যীশু ইঙ্কূ কে বগি কাতে অটহঅ গে লাউকা রে দেচেন্তে এটা দরে সে এনায়। ");
INSERT INTO cdz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","হেৎদ চেলা কুদ পিঠা সাপ ধরাঃআ কু লিড়িং লাতআ, মিয়াৎ পিঠা ছাড়া লাউকারে আকুয়াআ হান্ডে যাহানা আ কা তাহু কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ইনা তায়্ম যীশু ইঙ্কূ কে গামাৎ কুয়া, হুসিয়ার, ফরাঃআসী কুরাঃআ হেৎদ হেরোদ কুরাঃআ কলাঙ (তাড়ী) বাব্তে হুসিয়ার পে তাহিনা ");
INSERT INTO cdz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ইন্খান্গে ইঙ্কূ আকু আকু গে বাগজুড়ী আতে গামেৎ আকু, আবুয়া হান্ডে মা পিঠা বায়ায়্য় না মেন্তে ইনি নিয়া জাগার এৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ইনা আটকার নাম কাতে যীশু ইঙ্কূ কে গামৎ কুয়া, আপেয়া হান্ডে পিঠা বায়ান্তে চিয়াঃ বাগজুড়ী তানাপে? কাপে আটকার নামে তানা? আপেয়া অন্তরআত্মা চি কাঠুয়া কানা ? ");
INSERT INTO cdz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","আপেয়া মেৎ তাহিন্তে কাপে নেনেল তানা চিকিনা ? লুতুর তাহিন্তে কাপে আয়ুম তানা চিকিনা? কাপে পাহাম নামে তানা চিকিনা ? ");
INSERT INTO cdz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ইঞ চিন্তং মড়ে জুলু হড় কুকে মড়েয়া পিঠা কেচ্চা কুচ্চু কাতে এমাৎ কুকে নাঞ, ইন্তং আপে গুন্ডা গুন্ডি সাকড়ী চিমিন ঝুড়িয়া পে হাউর পেরেচ লা আ? ইঙ্কূ কু গাম রুয়াড় কেৎআ ১২ ঝুড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","হেৎদ চিন্তং উপুন জুলু হড় কু তালারে সাত টা পিঠা কেচ্চা কাতে এমাৎ কুকেনাঞ, ইন্তং আপে গুন্ডা গুন্ডি সাকড়ী চিমিন ঝুড়িয়া পে হাউর পেরেচ লা আ ? ইঙ্কূ কু গাম রুয়াড় কেৎআ ৭ ঝুড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় , আপে দ নাহা হঅ কাপে আটকার নামেতানা চিকিনা ? ");
INSERT INTO cdz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ইনা তায়্ম বৈৎসৈদা সরগ নাগারতে হিচেনা য়; এন্ডে রেন্কু হড় কুদ মিয়াৎ কাঁড়া হড় কেকু আয়ায়্য় হান্ডে আগু কাতেৎ কু বিন্তি কেৎআয়, যাতে ইনি হানিকে জুটেৎ ইকা আ। ");
INSERT INTO cdz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ইনি কাঁড়া রাঃআ তিহি সাপ কাতে সরগ নাগার বাহার দর ইদি কি য়ায়্য়; ইনা তায়্ম হানি রাঃআ মেৎরে বেচ কি য়ায়্য় হেৎদ মেৎ চেতাং রে তিহি এম কেৎতে কুলিকিয়ায়্য়, চেলে যাহানা নেল নামে তানাম? ");
INSERT INTO cdz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","হানি দ হান্তে নাতে মেৎ আরিৎ কেৎতে গাম কেৎআ য়, হড় কুকে নেল নামেৎ কুয়াঞ, দারু লেহা কু নেল তানা, দাড়ান তানা কু। ");
INSERT INTO cdz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","এন্খান যীশুদ অটহঅ গে হানি রাঃআ মেৎ চেতাং রে তিহি এম রুয়াড় কেৎআ য়। এন্খান্গে হানি কয়অ থীর কেৎআ য়, হেৎদ বেশে নায়, পুষ্ট কাতে যতআ গে নেল নাম কেৎ য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ইনা তায়্ম যীশু হানি কে আয়ায়্য় অড়া তে কুল কিয়ায়, গামা কিয়ায়, নিয়া সরগ নাগার হর কাতে আলম সেনা। ");
INSERT INTO cdz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ইনা তায়্ম যীশু হেৎদ আয়ায়্য় চেলা কু এন্ডে হাতেৎ কু উডুং ইন্তে কসরিয়া ফিলিপী টলা রাঃআ হাতু হাতু তেকু সেএনা, হেৎদ তালা হরাঃআরে আয়ায়্য় চেলা কুকে কুলি কেৎ কুয়া, ইঞ অকয় তানাঞচ?নিয়া বাব্তে হড় কিনা আ কু গামেতানা? ");
INSERT INTO cdz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ইঙ্কূ কু গাম রুয়াড় কেৎআ, গাদা হড় কু গামেয়া আবেন দ যহন ডুবানইচ, অটহঅ, অকয় অকয় কুদকু গামেয়া, আবেন দ ইলিয়; অটহঅ অকয় অকয় কুদ্কু গামেয়া ভাবিজাগারিচ কু রিঙ্কূ মিয়ুড়। ");
INSERT INTO cdz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","যীশু ইঙ্কূ কে কুলিকেৎ কুয়ায়্য় , মেন্খান আপে কিনা আ পে গামে তানা? ইঞ অকয় তানাইঞ মেন্তে? পিতর ইনি কে গাম রুয়াড় কি আয়, আবেনদ ইনি খ্রীস্ট। ");
INSERT INTO cdz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ইন্তং ইনি রাঃআ ইনা জাগার যাহায় কে কা গাম নাতিনাং কাজাগ তে মানা কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ইনা তায়্ম যীশু ইঙ্কূ কে নিয়া চেচেদা আ ছেদ এ এতহব কেৎআ য়, মান্মি হনকে গাদা দু খ ভোগ সাহা তুকা হযুয়ায়, মুরুবি কু, মারাঃআং বামড়েকু হেৎদ কটাল কুদ মানা গুনান কাকু এমায়া, গচঅ হযুয়ায়, হেৎদ আপি মাহা তায়্ম অটহঅ গচ হাতেৎ বিরিৎরুয়াড় হযুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","নিয়া জাগার যীশু সাপা সাপি গাম কেৎআয়। ইনাতে পিতর ইনিকে মিৎ কাতাতে ইদি কাতে বিন্তি য়াকি আয়। ");
INSERT INTO cdz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","মেন্খান ইনি মচা গুরাঃআ কাতে চেলা কুরাঃআ হানতে কয় কেৎআ য়, পিতর কে ধমকাঃআ কি ইয়া হেৎদ গামাকি ইয়া, ইঞআ সামাং হাতেৎ নিরমে, শয়তান; চিয়া চি অকা ঈশ্বরাঃআ, ইনাদ ল্হয়, মেন্খান অকা মান্মি রাঃআ, ইনাগে আমেম মনেৎ আম। ");
INSERT INTO cdz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ইনা তায়্ম নিজ চেলাকু লঅ মান্মি কুকে রাঃআ কাতে গামাৎ কুয়া, যাহায় ইনাআ তায়্মতে হিজু য়া পে, ইনিদ আচ নিজ কেগে লিড়িঞচ কাঃআ, নিজে রাঃআ ক্রাঃআস লাৎ জমে কায়ায়্য়, হেৎদ ইঞ লঅ সুতুঃ হিজু কা আয়। ");
INSERT INTO cdz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","চিয়া চি অকয় গে আয়ায়্য় নিজ জীউ বাঞ্চা রাঃআ ইচ্ছা য়ায়্য়, হানিদ ইনায় আতেয়ায়্য়; মেন্খান জাহায়্গে ইঞয়ায়্য় হেৎদ বুগিন বার্তা নাতিনাং নিজ জীউ আতেয়ায়্য়, হানিদ বাঞ্চা য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","মান্মি যদি সারাঃআ দিসুম অর্জ্ন কাতে নিজে রাঃআ জীউ আতেয়ায়্য়, এন্খান ইনি রাঃআ কিনা আ লাভ হুয়েনা? ");
INSERT INTO cdz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","বাংখান মান্মি নিজ জীউ রাঃআ বদলতে কিনা আ য়এম দাড়িয়ায়্য়্? ");
INSERT INTO cdz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","জাহায়্গে নিয়া যুগ রেঙকু হড়মালাটাম হেৎদ কাই ত্মা মান্মি কু দ ইঞকে হেৎদ ইঞাআ জাগার কু দ গিয়ু গেকু আটকারেয়া, ইন্তং ইনি লিরাঃআমালা সরগ নাগা কু লঅ নিজ আপু রাঃআ দাড়িয়ান্তে হিজু য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","অটহঅ গে যীশু ইঙ্কূ কে গামৎ কুয়া, ইঞ আপে কে সার্তি গেঞ গামাপে তানা, অকয় কু নেডেপে তিন্গুয়া কানা, আপে ক্থ্ক হড় মেনা পেয়া, অকয় কু দ গজ রাঃআ যাহানা আ আস্বাদ কাপে নামেয়া। অকা পর্যন্ত ঈশ্বর রাঃআ পরগনা পরাঃআক্রম লঅ হিজু কায় নেল নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","তুরুই মাহা তায়্ম যীশু দ পিতর, যাকোব, হেৎদ যহনকে সাতরে দহ কাতে নিরিবিলি মিয়াৎ সাল্গী বুরু চেতাং তে ইদি কেৎ কুয়ায়্য় , হেৎদ ইনি দ উঙকু আ সমাংরে রূপে পাল্টা কেৎআয়্য় ");
INSERT INTO cdz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","হেৎদ আয়া আ কিচি ই জুল লেকা সাফা, হেৎদ কুঠিন ধপ ধ্পেনা, ধারতি রিঙ্কূ যাহায় কিচি সাফাকু নেকা কাকু গালাং দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ইলিয় হেৎদ মুশি ইনি ল অ কিন নাপামেনা; হাঁকিন যীশু লঅ থুতি জাগার তানা। ");
INSERT INTO cdz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ইন্তং পিতর যীশু কে গাম কুলি কিআয়, প্রভু, নেডে আবুয়া আ তাহীন বেসা; আলে আপিয়া কুম্বা বানায়ালে, মিয়াৎ আবেনা নাতিনাং, মিয়াৎ মুশি রাঃআ নাতিনাং, অটঃ মিয়াৎ ইলিয় রাঃআ নাতিনাং। ");
INSERT INTO cdz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","চিয়া চি কিনা গাম হযুয়া পিতরদ যাহানা আ কায় আটকার নাম লাত্যায়। চিয়া চেলা কু দ খুব্গেযকু বর লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ইনা তায়্ম মিয়াৎ রিবিল হিচেন্তে ইঙ্কূ কে উবুল দানাং কেৎ কুয়া; হেৎদ ইনা রিবিল হাতে মিয়াৎ জাগার হিচেনা, ইনিদ ইঞাআ দুলাড়িয়া হন, ইনি রাঃআ থুতি আয়ুমেপে। ");
INSERT INTO cdz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ইনা তায়্ম আচ্কাগে ইঙ্কূ হান্তে নাতে কয়অ ভাড়া কেৎআ কু জাহায়কে কাকু নেল নাম লাৎ কুয়া, একলাগে যীশুদ চেলাকু লঅ তিন্গুয়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","বুরু চেতান হাতে আড়গু আড়গু তে যীশুদ কাজাগতে মানা কেৎ কুয়া, আপে অকা কুপে নেল কেৎআ যাহায় কে আল্পে গামা কুয়া, ইন্তং অব্দি গচ কু রাঃআ তালা হাতে মান্মি হন গচ হাতেৎ কায় জিউৎ বিরিৎ রুয়াড়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ইন্তং গচ কু রাঃআ তালা হাতে বিরিৎ রুয়াড় কিনাআ তানা, ইঙ্কূ নিয়া বাব্ত্তে আকু আকু কু কুলি ভাড়ান্তে আকুয়াআ তালারেগে কু দহ কেৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ইনা তায়্ম চেলাকুদ যীশু কেকু কুলি কিয়া, শাস্ত্র কটালকু মাকু গামেয়া, মাড়াং তে ইলিয়কে হিজু হয়ুয়া? ");
INSERT INTO cdz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","যীশু ইঙ্কূ কে গামাৎ কুয়া, হে সর্তিগে, ইলিয় মাড়াংতে হিজু আয় হেৎদ যাবতীয় বেপার কু বেস্গটা তে পুনস্থাপন নে গেয়ায়্ হেৎদ মান্মি হন রাঃআ বাব্ত্তে চিল্কা গে অল মেনা আ, ইনি কে গাদা হারকেৎ নামেয়ায় হেৎদ ঘেন্না নাম হ্যুযায়। ");
INSERT INTO cdz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","মেন্খান ইঞ আপেকে গামাপে তানা, ইলিয় রাঃআ বাব্ত্তে শাস্ত্ররে চিল্কা অল মেনা আ, এনে এঙ্কাগে ইনি দ হিচ্ লেনায়, হেৎদ মান্মি ইনি রাঃআ চেতাং রে যা খুশি ইনাগে কু করাঃআ তাৎঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ইনা তায়্ম যীশু ইঙ্কু আপিয়া চেলা কু লঅ এটা চেলা কুরাঃআ হান্ডে হিচ্ কাতেকু নেল কেৎ আ ইঙ্কূ আ গটা কাতা গাদা হড়, হেৎদ কটাল কু ইঙ্কূ লঅ বাক ঝুড়ি তানা কু। ");
INSERT INTO cdz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ইনিকে নেল থরাঃআ যত হড় কুব্গে কু হাহাড়ায় না, হেৎদ ইনি রাঃআ হান্ডে নির হিচ্ কাতে জহার কিয়া কু। ");
INSERT INTO cdz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","যীশু দ ইঙ্কূ কে কুলি কেৎ কুয়ায়্য় য়, নুকু লঅ আপে কিনা আ বাব্ত্তে বাক ঝুড়ি তানা পে ? ");
INSERT INTO cdz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","এন্খান্গে উন্কুয়া তালা হাতেৎ মিয়ুড় গাম রুয়াড় কেৎআ য়, এ প্রভু, ইঞআ হন কে আমাঃ হান্ডে আগু লিয়াঞ ইনিকে ববা আত্মা নাম তিআ; ইনিদ কায় থুতি ডাড়ি টানায়; ");
INSERT INTO cdz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","চিন্তং ববা কে ক্দেরেগে যুগ্নিদেব্তা নামিয়ায় এন্ডে গে তাওয়া য়াই, হেৎদ ইনি রাঃআ মচা হরতে ফত উডুং আ হেৎদ ডাটা কড় মড় ইয়ায়, অটহঅ কাট চাবাআয়; ইঞ আমাঃ আ চেলা কুকে গামৎ কুকেনায়ঞ ছাড়া নাতি নাং, মেন্খান ইঙ্কূ কাকু দাড়ি লাৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","যীশু আয়ায়া চেলা কুকে গাম রুয়াড় কেৎকুয়া, হে কা পাতিয়ান জাতি, ইঞ দ চিমিন কাল উৎরাঃআং আপে লঅঞ তাহিনা? চিমিন কাল উৎরাঃআং আপেয়াআ হাম্বল গয়াআ পেয়াঞ ? ইনিকে ইঞাআ হান্ডে আগুই পে। ");
INSERT INTO cdz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","চেলা কু দ ইনিকে যীশু রাঃআ হান্ডে আগু কিয়া কু; যীশু কে নেল থরাঃআ বঙ্গা আত্মাদ হানিকে খুব আটতে মচড়া কাতে হাসারে তাওয়া কাতে ফত উডুং লঅ গে গাড়া গড়ি নায়। ");
INSERT INTO cdz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ইন্তং যীশু হানি রাঃআ অপু তেৎ কে কুলি কি আয়, নিই রাঃআ চিলং হাতেৎ নেকা হযু তানা ? হানি গাম রুয়াড় কেৎআয় হুডিঙ হন হাতেৎ গে; ");
INSERT INTO cdz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","হেৎদ হানি বঙ্গা আত্মা হিই কে বিনাশ নাতিনাং গাদাসা সিঙ্গেল রে অটহঅ গাদাসা দাআরে চাডু লিআয়; মেন্খান আবেন চি যাহানাআ করাঃআ দাড়িয়া বেন, তবে খান আলে কে দায়া কাতে উপকার লেবেন। ");
INSERT INTO cdz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","যীশু গাম রুয়াড় কেৎআয়, চি দাড়িয়া বেন! অকয় পাতিয়া আয় ইনি রাঃআ পক্ষে যত গে সম্বব। ");
INSERT INTO cdz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ইন্তং ইনি হন রাঃআ বা তেৎ কিকিচ কাতে মেৎ দাআ জর কাতে গাম কেৎআ য়, পাতিয়া তানাঞ, ইঞআ কাপাতিয়া রাঃআ প্রতিকারেম। ");
INSERT INTO cdz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ইনা তায়্ম মিসাতে যত হড় যীশু রাঃআ কাতা নির হুন্ডিতানাকু নেল কাতে যীশু ইনি বঙ্গা আত্মাকে দমকা কাতে গামা কি আয় এই ববা কংকা আত্মা, ইঞ আমকে হুকুমাম তানাঞ, নিই রাঃআ হান্ডে হাতে উডুং গদম, হেৎদ যাহা হুনাং নিই রাঃআ হান্ডে আলম রুয়াড় হিজু আ। ");
INSERT INTO cdz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ইন্তং ইনি কিকিচ কাতে হানিকে কুঠিন জোরতে মচড়া কাতে উডুং সেএঃনায়; ইনাতে হনটা গ্জিচ লেকা গিতিচ গিডিয় নায়, এন্খান্গে গাদা হড়কু গাম কেৎআ, ইনিদ গ্চে নায় পেরে। ");
INSERT INTO cdz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","মেন্খান যীশুদ ইনি রাঃআ তিহি সাপ কাতে ইনি কে বিরিৎ কিচ খানে বিরিৎ নায়। ");
INSERT INTO cdz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ইনা তায়্ম যীশুদ অড়াঃতে হিচেন খান ইনি রাঃআ চেলা কুদ একলারে কুলি কিয়াঃআ কু, আলে চিয়া হানি ববা কংকা আত্মা হন কে কালে ছাড়া দাড়িয়া লিঃআ? ");
INSERT INTO cdz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ইনি গাম রুয়াড় কেৎআ য়, বিন্তি বিনা এঙ্কাতেদ নুকু যাইত কাকু উদু নিরাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ইনা ডিপা হাতে চেলা কু লঅ যীশু উদুইমাহা তে গালিলি রাঃআ তালা হরকাতে তাড়ম ইদি কেৎআ কু, হেৎদ ইনি রাঃআ ইচ্ছা কা তাহি লেনা, যাহায় কু সারি ঞামে কাঃআ কু মেন্তে। ");
INSERT INTO cdz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","চিয়া চি যীশু আয়াঃআ চেলা কুকে উপমা এম কাতে গামাৎ কুয়া, মান্মি হন কে বাইরি কুরাঃআ তিহিরে স্ম্পা তুকাঃআয়; ইঙ্কূ ইনিকে গ্চিয়াকু; গচতুকা লেনখানে আপিমাহা হুলাং রে অটহঅ গে বিরিৎ রুয়াড়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","মেন্খান ইঙ্কূ ইনা জাগার কাকু আটকার ঞামলাঃআ, হেৎদ যীশু কে কুকলিতে বর কেৎআ কু। ");
INSERT INTO cdz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ইনা তায়্ম ইঙ্কূ দ কফরনাহামে তেকু হিচেনা ; হেৎদ অড়াতে কু বলঃঅ আদেরেন খান ইনি ইঙ্কূ কে কুলি কেৎকুয়া, হরাঃআ তালারে কিনাঃআ বাব্ত্তেপে বাখঝৈড়ী কেনাঃআ? ");
INSERT INTO cdz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","চেলাকু দ থীর থারাঃআ কানাকু, চিয়াৎ চি অকয় মানতান আয়, নিয়া বাব্ত্তে হরাঃআরে আকুআকু গে বাকঝৈড়ী কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ইন্তং ইনি ১২ চেলা কুলঃঅ দুপ হুঁডি কাতে গামাৎ কুয়ায়্য় য়, যাহায় যদি মাড়াং অং সানাম তানা, ইন্খান জ্ত্চ রাঃআ তায়্মরে তাহীন মে হেৎদ জ্ত্চ রাঃআ ঞেল আতেন রে তাহিনমে। ");
INSERT INTO cdz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ইনা তায়্ম মিয়াৎ হুঁডিং হন কে হাতা কাতেৎ আকুয়াআ তালারে তিঙগু কিইয়ায়্য় হেৎদ ইনিকে কয়ঙ কাতে ইঙ্কূ কে গামাৎ কুয়া, ");
INSERT INTO cdz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","অকয় গে ইঞাঃআ ঞতুমতে হিঁঃই লেকা হুঁডিং হন কে আতাং ইয়াপে, ইনি দ ইঞ কেগে আতাংইঞাপে; হেৎদ অকয় ইঞ কে আতাংইঞায়, ইনি দ ইঞ কে দ ল্হয়, মেন্খান অকয় ইঞ কে কুলতিঃ ইঞায়, আপুঞ কেগে আতাং তিঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","যহন ইনিকে কুলি কিঃআয় এ গুরু, আলে মিয়াৎ হড়কে আমাঃ ঞতুম তে বঙ্গা কে কুদা গিডি লে নেল লিঃআ, হেৎদ আলে ইনিকে লে মানা লিঃআ, চিয়াঃ চি ইনি দ আবুয়াঃআ সুতুঃ হড় ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","মেন্খান যীশু গাম রুয়াড় কেৎ ৎ আয়, হানিকে আলপে মানা ইয়া, চিয়াঃ চি এনেএনকান যাহায় বানুঃ কুয়া, অকয় ইঞাঃআ ঞতুম তে দাড়িয়ান কামী করাঃআ কাতে আল্গা তেগে ইঞাঃআ নিন্দা দাড়িঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","চিয়াঃআ চি অকয় আবুয়াঃআ বিপক্ষ লহয়, ইনি দ আবুয়াঃআ পক্ষ। ");
INSERT INTO cdz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","বাস্তবরে যাহায় আপেকে খ্রীস্ট রাঃআ হড় মেন্তে মিৎ টাটিয়া দাঃআ নু তে কু এমা পেয়া, ইঞ আপেকে সার্তি গেঞ গামাপে তানা, ইনিদ যাহা লেকাতে আয়াঃআ সির্পা হাতে কায় হাটিং ভেগারঃআয়। ");
INSERT INTO cdz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","হেৎদ নুকু হুডাং লেকা হড় পাতিয়া নাকু, ইঙ্কূ য়া তালা হাতে যাহায় কে পাছে যাহায় ব্যাট কাটাইয়ায় কাই নাতিনাং, বরং হানি রাঃআ হটঃরে গাদা মারাঃআং যাঁতা তল কাতে হানিকে দরেয়া দাঃআ রে বুহাল গিডি লেন্খান আয়ায়্য় পক্ষে বেশ হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","অটহঅ গে আমাঃআ তিহি পাছে আমকে ব্যাটকাটা মায় কাই নাতিনাং, তবেখান ইনাদ মাঃআ গিডিম; ");
INSERT INTO cdz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","বারিয়া তিহি তাহি কাতে নরক তে, হানে ইনা ধাউ ধাউ জুলঃ সেঙ্গেল তে, সেন হাতে, বরংচ মিয়াৎ তিহিতে জীবন তে বলআদেরঃ আমাঃ বেশ হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","অটহঅ আমাঃআ কাটা পাছে ব্যাটকাটা মায় কাই নাতিনাং, তবেখান ইনাদ মাঃআ গিডিম; বারাঃআন কাটা তাহী কাতেত নরক তে চাডুঃ/খাঞ্জ হাতে বরংচ খড়দা কাতে জীবন তে বলআদেরঃ আমাঃ বেশ হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","অটহঅ আমাঃআ মেৎ পাছে ব্যাটকাটা মায় কাই নাতিনাং, তবেখান ইনাদ হটর উঁডুঙ কাতে দুহাড় গিডিম; ");
INSERT INTO cdz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","বারিয়া মেৎ তাহী কাতে নরক তে খাঞ্জঃ হাতে বরংচ কাঁড়া কাতে মিয়াৎ মেৎ তে ঈশ্বর রাঃআ পরগনা তে বলআদেরঃ আমাঃ বেশ হয়ুয়া; ");
INSERT INTO cdz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","নরখরেমা হড় রাঃআ তিজু কাকু গচঃআ, হেৎদ সিঙ্গেল হঃঅ কা চাব্বাঃআ । ");
INSERT INTO cdz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","বস্তুতঃ জ্তচ্ হড়কুকে সেঙ্গেল লেকা বুলুংতে বুলুংগদঃ হয়ুঃগেয়া, হেৎদ জ্তচ্ বলি কুকে বুলুংতে বুলুংগদঃ হয়ুঃআ, ");
INSERT INTO cdz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","বুলুং দ বেশ গেয়া, মেন্খান বুলুং রাঃআ বুলুং রাঃআহাম পাছে আদঃআ, তবেখান আমাঃআ কিনাঃরে ইনা স্বাদেম এমেয়া ? আপে আপান আপিন রাঃআ অন্তরে বুলুং দহয় পে, হেৎদ আপান আপিন সুলুক তে তাহীন পে। ");
INSERT INTO cdz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ইনা ঠাঁও (কাপারনাহুম) হাতে বিরিৎ এন্তে যীশু দ যিহুদিয় রাঃআ টলাতে হেৎদ যর্দ্দন রাঃআ হানা কাতাতে হিচেনা য়; এঙ্কান্গে ইনি রাঃআ হান্ডে অটহঅগে হড় কু হিচ্ হুন্ডি এনা, হেৎদ ইনি আয়ায়্য় ব্যবস্থা লেকা অটহঅ ইঙ্কূ কে উপমা এমাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ইন্তং ফরাঃআসী কুদ ঠাঁইঞ তে হিচ্ কাতে বিডাউ লেকাতে যীশু কে কুলি কিঃয়ায়্য়, তিরী/বাহু কে বাগী নাতিনাং চি হেরেল রাঃআ রেয়াজ ? ");
INSERT INTO cdz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ইনি ইঙ্কূ কে গাম রুয়াড়াৎ কুয়া, মুশি আপেকে কিনাঃআ হুকুম এমালাৎ পেয়া? ");
INSERT INTO cdz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ইঙ্কূ কু গাম রুয়াড় কেৎআ, হেরেলদ বাপাগ গীরা অল কাতে আয়ায়্য় এরাঃআ কে বাগী গিডি রাঃআ হুকুম মোসি এ এমাৎকু কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","যীশু ইঙ্কূ কে গাম রুয়াড়েৎ কুয়ায়্য় , আপেয়াআ অন্তর আত্মা কাঠুয়া গেয়া মেন্তে মোসি দ এনেঙ্কা ব্যবস্থা রেয়াজ অল লাঃআয়; ");
INSERT INTO cdz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","মেন্খান সৃষ্টি রাঃআ আদি হাতেৎ ঈশ্বর তিরী পুরুষ কাতে ইঙ্কিন কে বানালাৎ কিনায়, ");
INSERT INTO cdz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","' ইনা খাতির মান্মি(হেরেল) আয়ায়্য় মাই বা কে বাগী কাতে আয়ায়্য় নিজ এরাঃআ লঃঅ আস্ক্যত হ্যুয়ায়, ");
INSERT INTO cdz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","হেৎদ ইঙ্কিন বারহড় দ মিৎ মন হড়ম কিন হয়ুয়া' এন্খান্দ ইঙ্কিন দ বার হড় ল্হয়, মেন্খান মিৎ হড়ম। ");
INSERT INTO cdz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","এন্খান ঈশ্বর অকা জড়া তাৎআয়, মান্মি ইনা আলকু টটায় কঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ইনা তায়্ম চেলা কু অড়াঃ রে অটঃ হঅগে ইনা বাব্ত্তে যীশুকে কুলি রুয়াড় কিঃইয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ইনি ইঙ্কূ কে গামাতৎ কুয়ায়্য় , যাহায় গে আয়ায়্য় এরাঃআকে বাপাগ কাতে এঠাঃগিচ্কে দুতাময়ায়, ইনিদ হড়মালটম কেৎআয় ; ");
INSERT INTO cdz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","অটঃহঅ এরাঃআ হঅ আয়ায়্য় হেরেল কে বাপাগ কাতে এটা হড় ল্অ গঙঅয়াএ তবে খান ইনি হঃঅ হড়মালটম কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","(হনকুরাঃআঃ বাব্ত্তে চেচেদাঃআ) ইনা তায়্ম মাই বা তুকু কথকলেকা হুঁডিং হন কুকে যীশু রাঃআয়াঃ হান্ডে আগু কেৎকুয়া, যাতে ইনি ইঙ্কূ কে জুটেৎ কুকায়; ইন্খান্গে চেলা কুদ ইঙ্কূ কে হারগিডিৎ কুকেনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","মেন্খান যীশু ইনা নেল কাতে দুকেনায়, হেৎদ ইঙ্কূকে গামাৎ কুয়ায়্য় , হুঁন্ডিং হনকুকে ইঞাঃ হান্ডে হিচ্ তুকাকূপে, আল্পে মানা কুয়া; চিয়াঃ চি ঈশ্বর রাঃআ পারগনা দ নিকু লেকাগে। ");
INSERT INTO cdz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ইঞ আপেকে সার্তি গেঞ গামাপে তানা, অকয় হড় হনলেকা কা হই কাতে ঈশ্বর রাঃআ পারগনা কায় বলহিচ্ দাড়ি য়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ইনা তায়্ম হন কুকে কয়ঙ কেৎ কুয়ায়্য় , হেৎ দ ইঙ্কূ আ বহরে তিহি চাপু কাতে ভর আশিস এমাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ইনা তায়্ম যীশু উডুং কাতে হরাঃআ হরাঃআতে তাড়ম ইদি কেৎআ য়, ইন্তং মিয়াৎ হড় নির হিচ্ কাতে আয়াঃআ সামাং রে উক্ড়ুম কাতে কুলি কিঃআয়, এ সৎ গুরু যায়যুগ জীউ ঞামনাতি নাং ইঞ কিনাঃআ চিকায়া? ");
INSERT INTO cdz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","যীশু ইনি কে গামা কিঃয়ায়্য়, ইঞকে সৎ চিয়াঃ গামাঞ তানা? ইনি দ ঈশ্বর ছাড়া সৎ যাহায় বানুঃ কুয়া, ");
INSERT INTO cdz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","আম যত হুকুম সারিয়াম' হড় আলম গচ কুয়া, আলম লটপটেয়া, আলম কুম্বুড়ুয়া, বেদা লুকুন্দী আলম এমেয়া, আলম বেদা কুয়া, আমাঃ মাই বা তিকিনকে গুনমানও কিন্মে । ");
INSERT INTO cdz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","হানি হড় যীশু কে গামা কিঃয়ায়, এ গুরু, নাবালক হাতেৎ নিয়া কু মানা আগু তাৎআঞ। ");
INSERT INTO cdz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","যীশু ইনি রাঃআ এন্তে আরিৎ কাতে হানি কে কুসিয়া কিঃআয়, হেৎদ গামা কিঃআয়, মিয়াৎ বাব্ত্তে কুম্তি মেনাঃআ, দু সেন্ম, আমাঃআ যাবতীয় জাহানাঃআ গে মেনাঃআ, আক্ষরিঞেম, হেৎদ রেঁগেচ হড় কুকে দানাকুম, এন্খান্গে সরগ রে সির্পাম ঞামেয়া, হেৎদ হিজু মে , ইঞ লঅ সুতুঃ গঅম। ");
INSERT INTO cdz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","নিয়া জাগার তে মনে কস্ট এনা, দুকালিএন্তে নিরে নায়, চিয়াঃ চি ইনি রাঃআ মিৎগাদা সম্পতি তাহি লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ইন্তং যীশু হান্তে নান্তে কয়ঃ কাতে আয়ায়্য় চেলা কু কে গামাৎ কুয়ায়্য় , অকয় কুরাঃআঃ সম্পতি মেনাঃআ উঙকুয়া ঈশ্বর রাঃআ পারহড় সেনঃ চিন্তিত মুস্কিল গেয়া! ");
INSERT INTO cdz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","যীশু রাঃআ থুতি আয়ুমতে গাদাকু হাহাড়ায়না;মেন্খান যীশু অটঃহঅগে ইঙ্কূ কে গামাৎ কুয়ায়্য় , হনকু, অকয়কু দৌলতরে নির্ভরেয়াকু, ঈশ্বর রাঃআ পা রগনাতে বলআদেরঅ ইঙ্কূ য়া চিন্তিৎ মুস্কিল গেয়া! ");
INSERT INTO cdz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","কিসাড় হড় কু রাঃআ বেত্রাঃআং ঈশ্বর রাঃআ পারগনাতে সেনতে বরং চুঁচ রাঃআ ফঁংকা হর কাতে উঁট রাঃআ সেন পারমঅ আল্গাগেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ইন্তং চেলে কু গাদাকু হাহাড়ায়না, গাম্কেৎ আকু, তবেখান অকয় কুরাঃআ বাঞ্চা হুই দাড়িয়া ? ");
INSERT INTO cdz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","যীশু ইঙ্কূ য়া হান্তে আরিৎ কাতে গামা রুয়াড়ৎ কুয়ায়্য় , নিয়া দ মান্মি কুরাঃআ অসাদ্য় তানা, মেন্খান ঈশ্বর রাঃআ জাহানাঃআ অসাদ্য় বায়াঃনা, চিয়াঃ চি ঈশ্বর রাঃআ দ যতঃআ গে আল্গাগেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ইন্তং পিতর যীশু কে গামাকিঃয়াই, ঞেলেম আলে যতঃআ বাগী কাতে আমাঃআ সুতুঃলে হাতা তাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","যীশু গাম রুয়াড় কেৎ আয়, ইঞ আপেকে সর্তিগেং গামাপে তানা, এনে এনকান যাহায় বানুকুয়া, যে ইঞাঃআ নাতিনাং হেৎদ বুগিন খবর নাতিনাং অড়াঢিপা চি হাগাকুকে চি মিসিকুকে চি মাইকে চি বাকে চি হন হ্প্ন্কুকে চি হাসাবাইদ কু বাগী তাঃআ, মেন্খান নাহাঃ নিয়াকালরে ইনি রাঃআ শত বুনুমা কায় নামেয়ায়; ");
INSERT INTO cdz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ইনিদ অড়াঢিপা, হাগাকুকে, মিসিকুকে, মাইকে, বাকে, হন হ্প্ন্কুকে, হেৎদ হাসাবাইদ কু তাড়না লঃঅ নিয়া যতচ নামেয়াম, হেৎদ যায়যুগ জিউ নামেয়াম হিখড়ম না যুগরে, ");
INSERT INTO cdz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","মেন্খান অক্য়্কু মাড়াগা কানা, এনেঙ্কাগে গাদা হড়কু তায়্ম রেকু তাহিনা, অটঃহঅ অকয়কু মুঢু রেকুয়া, ইঙ্কূ দ মাড়াগাকু ");
INSERT INTO cdz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","মিসা ইঙ্কূ জেরুজালেম হরাঃআ তেকু তাড়ম সেন কেনা, হেৎদ যীশু ইঙ্কূআ মাড়াং তে তাড়মেৎ কেনায়, ইন্তং চেলা কু হাহাড়ায় নাকু, অককু দ তায়্ম তায়্ম তেকু তাড়মেৎ কেনা, ইঙ্কূ দ বর কেঃআকু। ইনা তায়ম অটঃহঅ গে ইঙ্কূ ১২ চেলাকু লিয়া আয়ায়্য় জিউরে কিনাঃ কিনাঃ দশা হয়ুয়া, ইনা ইঙ্কূ কে গাগামে লাগায়না। ");
INSERT INTO cdz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","যীশু গাম কেৎআয়, নেলেপে, আবু যিরূশালেম তেবু সেন তানা, মান্মি হনকে ইহুদি শাস্ত্র চেচেদ কু, মারাঃআং বামড়ে হেৎদ কটাল কু রাঃআ তিহিরে সম্পা তুকাঃআয়;হেৎদ ইঙ্কূ ইনি রাঃআ জিউ হাতা নাতিনাং চক্র কু তলেয়া, অটঃহঅ বি জাতি কুরাঃআ তিহিরে সম্পাইয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","হেতৎদ ইঙ্কূ ইনিকে টিটকারীয়াকু, ইঙ্কূ মচারেকু বেচঃইআ, ইনিকেকু চাপ্কাইয়া, হেৎদ গচঃই আকু; হেৎদ ইনি অপি মহারে অটঃহঅগে বিড়িতৎ রুয়াড়ায়, ");
INSERT INTO cdz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ইনা তায়্ম সিবদিয় রাঃআ বারাঃআণ হন, যাকোব হেৎদ যহন, যীশু রাঃআ হান্ডে হিচ্ কাতে কিন গাম কেৎআ, এ গুরু, আলিঞাঃআ গামাঃআ দ নিয়া, আলিঞ আমাঃআ হান্ডে অকাঃলিঞ আসিয়া, ইনা আলিঞাঃআ নাতিনাং করাঃআম। ");
INSERT INTO cdz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","যীশু ইঙ্কিন কে গামাৎ কিনা, আবেনাঃআ আসি রাঃআ কিনাঃআ মেনাঃআ? আবেনাঃআ নাতিনাং কিনাঃআঞ চিকায়া? ");
INSERT INTO cdz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ইঙ্কিন গাম রুয়াড় কেৎআ কিন আলিঙ কে নিয়া বরদাড়ি এমালিংমে, আম মহিমা পুরাঃআ হুই লেন্খান আলিঞ মিহুড় আমাঃআ ম্যাডি তিহি দররে, হেৎদ অটঃ মিহুড় লেঙ্গা তিহি দররে দুপ দাড়ি কাঃআ লিঞ। ");
INSERT INTO cdz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","যীশু ইঙ্কিন কে গামাৎ কিনায়, আবেন কিনাঃআ বেন আসি তানা, ইনা কাবেন আটকার ঞাম তাঃআ। ইঞ অকা ঘুটি তেঞ নুয়া, আবেন চি ইনা ঘুটিতে নু দাড়িয়া বেন, হেৎদ ইঞ অকা ডুবান তেঞ ডুবানয়াঞ ইনাতে আবেন চি ডুবানয়াঞ দাড়িয়া বেন? ");
INSERT INTO cdz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","গাম রুয়াড় কেঃআ কিন হে লিঞ দাড়িয়া। যীশু ইঙ্কিন কে গামাৎ কিনায়, ইঞ অকা ঘুটি তেঞ নুয়া, আবেন ইনা ঘুতিতে নু দাড়িয়া বেন, হেৎদ ইঞ অকা ডুবান তেঞ ডুবান য়াঞ ইনাতে আবেন হঅ ডুবান তেঞ ডুবান য়াঞ দাড়িয়া বেন; ");
INSERT INTO cdz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","মেন্খান অকয় কুরাঃআ নাতিনাং ঠাঁওসাপড়া হ্যুয়া কানা। ইঙ্কূ য়া বেগর অটঃ জাহায়কে ইঞাঃ ম্যাডি তিহি দররে চি লেঙ্গা তিহি দররে দুপ তুকারাঃআ ইঞাঃ আইদারি বায়াঃনা। ");
INSERT INTO cdz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","নিয়া জাগার আয়ুম কাতে ইটাঃ ১০ চেলাকু যাকোব হেৎদ যোহন রাঃআ চেতানরে খুব্কু রাঃআগে না। ");
INSERT INTO cdz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","মেন্খান যীশু ইঙ্কূ কে কাতাতে রাঃআ হুন্ডি কাতে গামাত্ কুয়া, আপে সারিয়াপে বিজাতি কুরাঃআ চেতাং রে অকয়কু শাসনকর্তা মেন্তে বহালা কানাকু, ইঙ্কূ হাঙকুয়া চেতান রে প্রভুত্ব ইয়াকু, হেৎদ ইঙ্কূ য়া তালা হাতেৎ অক্য়্কু মহান গেয়া, ইঙ্কূ হঅ হাঙকুয়া চেতান রে কর্ত্ত্ত্ব ইয়াকু, ");
INSERT INTO cdz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","আপেদ এনেঙ্কা দ ল্হয়;মেন্খান আপেকু তালারে অকয় মারাঃআঙঅ বুঝাঃআৎ পেয়া, ইনি দ আপেয়া সেবক হয়ুঃ কাঃআয়; ");
INSERT INTO cdz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","হেৎদ আপেকু তালারে অকয় বহগঃঅ বুঝাঃআতাৎ পেয়া, ইনি দ আপেয়া মুনিস হ্যুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","চিয়াঃ চি মান্মি হন সেবা নাম নাতিনাং কায় হিচা কানায়, মেন্খান সেবা এমঃঅ হেৎদ মান্মি কুরাঃআ রাঃআ জিউ বদল হেৎদ আয়ায়্য় জিউতে বাঞ্চা নাতিনাং মূল্য এম হিচা কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ইনাতায়্ম যীশু হেত্স চেলাকু যিরিহো সরগ নাগার দরকু হিচেনা। হেৎদ যীশু চিন্তং আয়ায়্য় চেলা কু লঅ হেৎদ গাদা হড়কু লঅ যিরীহো হাতেৎ উডুং কাতেকু সেনকেনা, ইন্তং থিময় রাঃআ হন বর্থিময় নুতুমান মিয়াৎ জনম কাঁড়া ক্য়কয় হরাঃআ কাতারে দুপ তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","বার্থিময় চিন্তং আয়ুম ঞাম কেৎআয়, ইনি দ নাসরতীয় যীশু, ইন্তং কিকিঃচ কাতে গাম কেৎআয়, এ যীশু, দাউদ হন, ইঞকে দয়াঞমে। ");
INSERT INTO cdz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ইন্তং গাদা হড় ইনকে থিরম থিরম মেন্তে ধমকাঃআ কিঃআকু; মেন্খান ইনি অটঃহঅগে খুব জোর জোর্ তে কিকিঃচ কাতে গাম কেৎআয়, এ যীশু, দাউদ হন, ইঞকে দয়াঞমে। ");
INSERT INTO cdz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ইন্তং যীশু তিঙ্গু কাতে গামাৎ কুয়া, হানিকে রাঃআ ই পে; ইন্খান্গে হড়কু ইনি কাঁড়া হড় কে রাঃআ কিঃয়াকু, একা, সাহ্সেম, বিরিৎ মে, যীশু আমকে রাঃআগেৎ মেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ইন্তং হানি আয়ায়্য় কিচিঃই হুরলা গিডিকাতে যেহেৎ কাতে বিরিৎ এন্তে যীশু রাঃআ হান্ডে হিচেনা য়। ");
INSERT INTO cdz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","যীশু ইনিকে গামাঃইআ, আম কিনঃআ আসি তানাম? ইঞ আমাঃআ নাতিনাং কিনাঃঞ চিকায়াঞ? কাঁড়া হড় গাম কেৎআয় এ গুরু নেল নামেকাঃঞ। ");
INSERT INTO cdz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","যীশু হানি কে গামাঃইয়ায়, দু সেন্ম, আমাঃআ পাতিয়া আমকে বেশ কেৎ মায়, ইন্তং হানি নেল নাম্কেৎ আয়, হেৎদ হরা হরাতে আচ্লঃঅ সুতুঃনায়। ");
INSERT INTO cdz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ইনা তায়্ম চিন্তং যীশু হেৎদ চেলাকু যিরূশালেম রাঃআ কাতা হরকতে জৈতন বুরু রাঃআ বৈৎফগী হেৎদ বৈথ্নিয়া সরগ নাগার (হাতু) তেকু হিচেনা, ইন্তং যীশু আয়ায়্য় চেলাকু হাতে বার হড়কে কুল কেৎ কিনায়, ");
INSERT INTO cdz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","যীশু ইঙ্কিন কে গামাৎ, কিনায় আবেন নাঃআ হানে ইনা হাতুতে সেনঃবেন দু; এন্ডে সেটের থরাঃআ ঞেলনামিয়া বেন মিয়াৎ গাধা বাছুর তল মেনাঃইআ, অক্য়য় রাঃআ দয়ারে যাহায় মান্মি নাহাঃহঅ আউরি কু দুপঃআ, হানিকে রাঃআড়া আগুইবেন দু। ");
INSERT INTO cdz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","যাহায় কু কুলিবেন খান, হিঁঃই কে চিয়াৎ বেন রাঃআড়াই তানা? তবেখান গামাকুবেন প্রভু রাঃআ লাক্তি মেনাঃআ; এন্খানগে হানি ইন্তঙ্গে হানিকে নেডে কুলিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ইন্তং ইঙ্কিন সেন্কাতে কু নেল নামকিঃআ, মিয়াৎ গাধা বাছুর দুয়ার কাতারে, রাঃআচারে তল্ মেনাঃইআ, হেৎদ হানিকে রাঃআড়াইচ কেনায়, ");
INSERT INTO cdz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","এন্ডে অক্য়য় কু তিন্গু লেনা, ইঙ্কূ য়া তালা হাতে কথক হড় কু গাম কেৎআয়, গাধা বাছুরকে চিয়া বেন লাড়াতানা ? ");
INSERT INTO cdz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ইন্খান গে জিসু চিল্কা গাম লাত্যায়, ইঙ্কূ হাঁঙকু কে এঙ্কা গেকু গামাৎ কুয়া, হেৎদ ইঙ্কূ ইনিটা কে এগু তুকা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ইনা তায়্ম ইঙ্কূ হানি গাধা বাছুর টা কে যীশু রাঃআ কাতাতে আগু কাতে আকুয়াআ আ কিচিই বাছুর রাঃআ দয়া রে বিছা কেৎ আকু, হেৎদ যীশু ইনি রাঃআ দয়া রে দুপেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ইন্তং গাদা হড় আকুয়াআ কিচি সিনিব হরা হরা তেকু আটেৎ ইদি কেৎআ অটহঅ অকয় কুদ বাইদ ডাঙ্গা হাতে দারু ডাইর মাআ কাতে হরা হরাতেকু আটেৎ ইদি কেৎ আকু। ");
INSERT INTO cdz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","হেৎদ অকয় হড় কু সামাং সামাং তে হেৎদ তায়্ম তায়্ম তেকু তাড়ম তাৎআ, ইঙ্কূ কিকিচ কাতে কু গাম্কেৎআ, হোশান্না ! ধনয়্য় ইনি, অক্য়য় প্রভু নুতুমতে হিজু তানায়। ");
INSERT INTO cdz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ধনয়্য় অকা সরগ পারহড় হিজু তানা, আলেয়াআ হাপড়াম দাউদ রাঃআ পারহড় সরগপুরিরে হোশান্না। ");
INSERT INTO cdz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ইনা তায়ম যীশু যীরুশালেম তে বলঃঅ আদেরে নতে থানতে রাকাপে নায়, হেৎদ গটা কয়অ গুরাঃআ কেৎআয় বেলা ডুবুজ তান খানে ইঙ্কূ ১২ চেলা লঅ উডুং কাতে বথ্নিয়া দর কু তাড়ম কেৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ইনা তায়্ম হুলাং যীশু হেৎদ চেলা কু বথ্নিয়া হাতে উডুং হিচেন খান যীশু কে রেঙ্গেচ কিইয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","হেৎদ সাঙ্গীঙ হাতে সেকাম পেরেচ লয়া দারু নেলনাম কেৎআ, জ হুডাঙ নাম নাতিনাং, সেএ নায় কাতাতে; মেন্খান কাতাতে সেন কাতে নেলেয়ায় সেকাম ছাড়া জাহান জ বায়ায় না, চিয়াআ চি নিন্তং দ লয়া দারু রাঃআ জ বাহা রাঃআ সময় কা তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","যীশু দারু টাকে গামাইআ, নাহাআ অব্দি যাহায় জাহাহুলাং আমাআ জ আলকু জমে কাঃআ, নিয়া জাগার আয়ায়্য় চেলা কু আয়ুম নাম লাআ। ");
INSERT INTO cdz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ইনা তায়্ম যীশু হেৎদ চেলাকু যীরুশালেম তেকু হিচেনা, হেৎদ যীশু ধরম থান ভীতির তে বলঃঅ কাতে, অকয় কু ধর্ম থান ভীতির রে কিরিং আখরীঙ এৎ কেনাকু, হাঁঙকুকে উডুং গিডিৎ কু কেনায়, হেৎদ কাউডি ভাহড় কুরাঃআ সাল্গী হড় ডু হুরল্লা গিডি কেৎআয়, অটহঅ অকয় কু পেরয়া আখরীঙ কুকেনাকু, ইঙ্কূ য়া আসন যত উল্টা গিডি কেৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","হেৎদ ধরমথান ভীতির হরকাতে যাহায় কে জাহান জিনিষ কায় ইদি তুকা লাত কুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","হেৎদ যীশু চেলা কুকে চেদকেৎ কুয়ায়্য় , হেৎদ গামাৎ কুয়া, নেকা দ চি অল কা তাহি লেনা ' ইঞা অড়া যত জাতি কুরাঃআ বিন্তি অড়া আ গাময়া? মেন্খান আপে নিয়া 'কুমড়ু কুরাঃআ অড়া' পে বাই তাৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","নিয়া জাগার আয়ুম কাতে মারাঃআং বামড়ে হেৎদ কটাল কু, যীশু কে চিল্কাতে কু বিনাসিয়া, ইনারাঃআ গে কুরুমুটু কু লাগায় না; চিয়া চি ইঙ্কূ ইনিকে বরয়াইয়াকু, কারন আয়া আ উপমাতে যত হড় কু খুশি কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","হেৎদ আয়ুপ লেন খান যীশু হেৎদ চেলাকু সরগ নাগার রাঃআ বাহার তেকু সেন কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","সেতাআ বেত্রাঃআং সেন সেন তে চেলা কু নেল কেৎ আকু, হানা লোয়া দারু টা পাটা হাতেৎ রহড়া কানা। ");
INSERT INTO cdz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ইন্তং পিতর মাড়াং হূলাঙ রাঃআ জাগার পাহামা কিইতে গাম কেৎআ, প্রভু, নেলেম, আবেন অকা লোয়া দারু কেবেন স্যাপআ লিয়াম, ইনাটা রহড়া কানা। ");
INSERT INTO cdz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","যীশু গাম রুয়াড় কাতে ইঙ্কূ কে গামাৎ কুয়া ঈস্বর রাঃআ হান্ডে পাতিয়া দহয় পে। ");
INSERT INTO cdz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ইঞ আপেকে সার্তি গেঞ গামাপে তানা, যাহায় গে ইনা বুরু কে গামাই য়ায়, তুত সরাঃআ ম, হেৎদ দরেয়ারে নুরঅম, হেৎদ মনে মনে আলম সন্ধেহ আ, মেন্খান অক্য়য়য়ে পাতিয়ায়্য়, অকাএ গামেয়ায় ইনাগে হয়ুয়া, ইন্খান ইনি রাঃআ নাতিনাং ইনা গে হযুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","নিয়া খ্যাতির ইঞ আপেকে গামাপেয়া, অকা কু নাতিনাং বিন্তি হেতৎদ আসিজম য়াপে, পাতিয়াপে নাম তৎআপে মেন্তে, আপেয়া নাতিনাং ইনাগে হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","অটহঅ আপে চিন্তং বিন্তি নাতি নং পে তিঙ্গুনা, যাহায় রাঃআ বিরুৎতে চি জাহান থুতি মেনাআ, হানিকেৎ ঈকা এমায়ম; এনেইঙ্গআ গে সরগ রেনিচ আপু আপেয়া যত অপরাঃআধ ঈকা য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","যদি আপে এটা কুরাঃআ কাই কাপে ঈকায়ায়্য়, এন্খান অক্য়য় সরগরে দাড়িয়ান ঈশ্বর বা মেনাইয়া ইনি যাহা হুলাং আপেয়া কাই কায় ইকায়া। ");
INSERT INTO cdz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ইনা তায়্ম অটঃহঅগে যীশু হেৎদ চেলাকু যীরুশালেম তেকু হিচেনা ; হেৎদ যীশু ধরম থান রাঃআ ভিতররে ঘুরাঃআ ভাড়া কেনায়, ইন্তং মারাঃআং বামড়ে কু, কটাল কু হেৎদ মুরুব্বিকু আয়ায়্য় হান্ডে হিচ্ কাতে কুলি কিআকু, ");
INSERT INTO cdz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","আবেন চিকান দাড়িতে নিয়া কু যত করাঃআয় তানায়বেন ? নিয়া যত কামি নাতিনাং অক্য়য় দাড়ি এমাতাৎ বেনায় ? ");
INSERT INTO cdz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","যীশু ইঙ্কূ কে গাম রুয়ার কেৎ কুয়ায়্য় , ইঞ হঅ আপেকে মিয়াৎ কুক্লি য়া কুলি পেয়াঞ, কুলি রাঃআ তেলা এমাঞ পে, এন্খান্গে গামাপেয়াঞ আপেকে, অকা দাড়িতে নিয়া কু যত কামী তানাঞ, ");
INSERT INTO cdz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","যোহন রাঃআ ডুবান সরগ হাতেৎ হুই লেনা চি মান্মি হাতেৎ হুই লেনা? তেলা এমাঞ পে দা। ");
INSERT INTO cdz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ইন্তং ইঙ্কূ আকু আকু ধরবার কাতে কু ভাবা কেৎআ, যদি সরগ হাতে বু গামেয়া, এন্খান গামা বুয়ায় হাঁঃআ, ইন্খান আচ্কে কাপে পাতিয়া লিআ চিয়ায়্য়? ");
INSERT INTO cdz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","অটহঅ যদি গামেয়াবু, মান্মি হাতে হিচা কানায় গামেয়াবু? ইঙ্কূ দ হড় কুকে ব্র্ য়াকুয়াকু, চিয়াচি যত হড় যোহন কে ভাবি জাগারিচ মেন্তে কুপাতিয়া কেনা, ");
INSERT INTO cdz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ইন্খান্গে যীশু কে কু গাম রুয়াড়া ইয়াকু কালে সারিয়া। ইন্তং যীশু ইঙ্কূ কে গাম রুয়াড় কেৎকুয়ায়্য় য়, ইঞ হঅ কাঞ গামা পেয়া অকয় রাঃআ দাড়ি তে নিয়া যত কামিঞ কামী তানা। ");
INSERT INTO cdz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ইনা তায়্ম যীশু দ দৃস্টান্ত উডু কাতে ইঙ্কূ য়া হান্ডে থুতি জাগারেৎ আয়, মিয়াৎ হড় দ্রাঃআক্ষাবাইদ রাঃআ গটা কাতা বাড়গি এসেৎ কেৎআয়, দ্রাঃআক্ষা রস পিশা নাতিনাং খানা মিয়াৎ উর কেৎআয়, হেৎদ মিয়াৎ গাদা সাল্গী অড়াঃআ বাই কেৎআয়; হেৎদ চাষী কুরাঃআ তিহিরে সম্পা কাতে এটাআ দিসুমেতে সেএনায়। ");
INSERT INTO cdz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ইনা তায়্ম চাষী কুরাঃআ হান্ডে হাতেৎ দ্রাঃআক্ষা বাইদ রাঃআ দ্রাঃআক্ষা জ আয়ায়্য় ভাগ নাম নাতিনাং দ্রাঃআক্ষা ইর সময় আয়ায়্য় মিয়াৎ মুনিসকে কুলকিআয়। ");
INSERT INTO cdz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","চাষীকুদ হানিকে বেষলেকা পাহারাঃআ কাতে এখেন তিহিতে কু কুল গিডি কিয়ায়্য়্, ");
INSERT INTO cdz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","অটহঅ গে মালিকদ চাষী কুরাঃআ হান্ডে অটঃ মিয়াৎ মুনিস কেয় কুল কিয়ায়্য়্য়। ইঙ্কূ দ ইনি রাঃআ বহ দাল পাড়া কেৎআ কু, হেৎদ মান হানি কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ইনা তায়্ম অটহঅ অটঃ মিয়াৎ মুনিস কেয় কুল কিয়ায়, চাষী কুদ ইনিকে গচ কিয়াকু; হেৎদ অটহঅ হ্যাংকুয়ায়্য় ভীতির হাতে অকয় কেৎ দাল তল, অকয় কুকে দ গচ কেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","মালিক রাঃআ অটঅ মিহুড় গেয় তাহি লেনায়, ইনি দ আয়ায়্য় দুলাড়ি হন; ইঙ্কুয়া হান্ডে কুল নাতিনাং যাহায় বানুকুয়া, এন্খান গে মুচাৎ রে ইনি চাষী কুরাঃআ হান্ডে নিজ হন তেৎ কেগে কুল কিচ্যায়, গাম কেৎআয়, ইঙ্কূ ইঞা হনকে মানা বাতায়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","মেন্খান চাষী কু দ আকু আকু কু থুতি জাগারেনা, হিঁই গে মা উত্তরাঃআ ধিকারী দেলা হিজু পে আবু হিঁই কে গ্চিয়াবু, ইন্খান্গে নিয়া কুরাঃআ আইদারি আবুয়াগে হযুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ইনা তায়্ম ইনিকে স্যাপ কাতে কু গচ কিয়ায়্য়, হেৎদ দ্রাঃআক্ষা বাইদ রাঃআ বাহার তে কু লেব্দা গিডি কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ইনা দ্রাঃআক্ষা বাইদ রেনিচ মালিক কিনা আ চিকায়ায়্য় ? মালিক হিচ্ কাতে ইঙ্কূ চাষী কুকে বিনষ্ট কুয়ায়্য় , হেৎদ বাইদ এটা হড়কুকে এমা কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","আপে দ চি নিয়া রিলামালা সাস্ত্রীয় বচন কাপে পড়াকানা, 'অকা ধিরি ধিরিগাথ্নিকু বাগী তুকা লাআ, ইনাটা গে কচা রাঃআ মারাঃআং ধিরি মেন্তে হযুএনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","নিয়াদ প্রভু হতেৎ হয়েনা, নিয়া দ আবুয়া দৃষ্টি হাতেৎ অদ্ভৎ ? সংগীত (দুরাঃআং মালা) 118:23 ");
INSERT INTO cdz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","নিয়া উপমা গাম নাতিনাং ইঙ্কূ যীশু কে সাব রাঃআ কুরুমুটু কেৎআকু, মেন্খান হড় কুকে বরয়াত কুয়াকু, চিয়া চি ইঙ্কূ কু সারি নাম লাআ যীশুদ ইঙ্কূ য়া বাব্ত্তে ইনা দৃষ্টান্ত গাম লাত্যায়, ইনা তায়্ম যীশু কে বাগী কাতে কু নিরেনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ইনা তায়্ম জিহুদী লাউড়িয়া কথক হড় ফরিসী হেৎদ হেরদিয়কে যীশু রাঃআ হান্ডে কুল কিইয়ায়, যাতে ইঙ্কূ যীশু কে থুতি রাঃআ জল রেকু ঝালি কাতে সাব দাড়িয়াকা আ। ");
INSERT INTO cdz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ইঙ্কূ হিচ্ কাতে যীশু কেকু কুলি কিয়ায়্য়, গুরু আলে সারিয়ালে আম দ সৎ হেৎদ যাহায় রাঃআ বর তে হঃঅ বানু মেয়া; চিয়া চি আবেন দ মান্মি রাঃআ ব্যবস্থা লেকা কাবেন করাঃআৎআ, মেন্খান সার্তি লেকা তেগে ঈস্বর রাঃআ হরাঃআ বাব্ত্তে চেদেৎ কুয়াবেন, আচ্ছা গামেম মহিন কৈসরকে বুটি এম লাক্তি চি ল্হয় ? ");
INSERT INTO cdz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","আলে বুটি এমেয়ালে চি কালে এমেয়া ? যীশু ইঙ্কূ য়া ক্প্টিয়া মন আটকার নাম কাতে গামাৎ কুয়া, চিয়া আ ইঞ কেপে বিডাঞ তানা ? মিয়াৎ সিকি আনা আগু য়াঞপে, কাউডি নেলেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ইঙ্কূ কাউডি কু আগু কেৎআ; যীশু ইঙ্কূ কে কুলি কেৎ কুয়ায়্য় , নিয়া ছাপ হেৎদ নিয়া নুতুম অকয় রাঃআ ? ইঙ্কূ কু গাম রুয়াড় কেৎআ, কৈসর রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","যীশু ইঙ্কূ কে গামঅৎ কুয়ায়্য় , অকাকু কৈসর রাঃআ, ইনা কুদ কৈসর কেগে এমাই পে, হেৎদ অকাকু ঈশ্বর রাঃআ ইনাকুদ ঈশ্বর কে এমাইপে। ইন্তং ইঙ্কূ ইনি রাঃআ বাব্ত্তে খুঠিন্কু হাহাড়ায় না ");
INSERT INTO cdz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ইনা তায়্ম স্দ্দুকি কু যীশু রাঃআ হান্ডে হিচেনা কু, হেৎদ যীশু কে কু কুলি কিইয়া, মান্মি কু গামেয়া গচ হাতে বিরিৎ রুয়াড় বায়ানা, ");
INSERT INTO cdz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ইঙ্কু যীশু রাঃআ হান্ডে হিচ্ কাতে কু কুলি কিয়ায়, গুরু মুশি দ আলেয়া নাতিনাং অল লায়ায়্য়,যাহায় রাঃআ হাগা ইরাঃআকে বাগী কাতে গচ ভেগার য়ায়্য়, হেৎদ আয়ায়্য় হন হপন বানুকুয়া, ইন্খান হানি রাঃআ হাগা হানি রাঃআ এরাঃআ কে তুতাম কাতে হাগা নাতিনাং পিড়ি সাব দ্যায় য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","খুব বেশ, ৭ হাগাকু তাহি লেনা; মারাঃআং হাগা মিয়াৎ কুড়ি হন কে দুতাম কিয়ায়্য়, হেৎদ হন হপন কাকু য়ুই কাতেগে গ্চেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ইনাতায়্ম এটা হাগা হানিকে দুতাম কিয়ায়্য়, হানি হঅ হন হপন কাকু য়ুই কাতেগে গ্চেনায়, ইনা তায়্ম রেনিচ হঅ এনে এঙ্কাগে হুইয়ে না। ");
INSERT INTO cdz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","এনে এংকা লেকাতেগে ৭ হাগা হন হপন কাকু য়ুই কাতেগে গ্চেনাকু যত হাগা। জৎচ রাঃআ তায়্ম তে হানি বাহু হঅ গ্চেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","বিরিৎ রুয়াড় মাহারে, জত হড় কু বিরিৎ রুয়াড় লেন্খান, হানি এরাঃআ অকয় রাঃআ বাহু হ্যুয়ায়্য় ? ইঙ্কূ কুমাত ৭ হড় গেকু দুতাম লিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","যীশু ইঙ্কূ কে গাম রুয়াড়াৎ কুয়ায়্য় , ইন্যাদ চি আপেয়া লুব্বা কারন ল্হয়, আপেদ চি কিনা আ শাস্ত্র পে সারিয়া, চি কিনাআ ঈশ্বর রাঃআ পরাঃআক্রম পে সারিয়া? ");
INSERT INTO cdz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","গচ কু হাতে বিরিৎ রুয়াড় তায়্ম হড়কুমা কাকু দুতাম-গংঙআ, সরগ রিঙ্কূ সরগ নাগা লেকাকু তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","গচ কুরাঃআ হাতেৎ বিরিৎ রুয়াড় বাব্ত্তে গামাৎ কুয়ায়্য় য়, নিয়া বাব্ত্তে মুশি রাঃআ অল লেকা ঝোপ রাঃআ বৃত্তান্তে কাপে পড়া কানা? ঈশ্বর হানিকে চিল্কা গামালিচায়, ইনি গামালিয়ায়্য় 'ইঞদ আব্রাঃআহাম রাঃআ ঈশ্বর, ইসহাক রাঃআ ঈশ্বর হেৎদ যাকোব রাঃআ ঈশ্বর। ");
INSERT INTO cdz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ঈশ্বরদ গচহড় কু রাঃআ ঈশ্বর ল্হয়, মেন্খান জিউৎ হড় কুরাঃআ। আপে কঠিন হরবর রেপে নুরেনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","হেৎদ কটাল কুরাঃআ ভীতির হাতেৎ মিৎ হড় ঠাইঞ তে হিচ্ কাতে হানিকে থুতি তেংড়া তিংড়ী আয়ুমেৎ কেনায়, হেৎদ যীশু হানিকে যথা যথ তেলা এম রুয়াড়া তিয়ায়্য় সারি কাতে, ইনিকে কুলি কিইয়ায়্য়, যত হুকুম হাতেৎ অকাটা মারাঃআংজ্ঞা ? ");
INSERT INTO cdz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","যীশু গাম রুয়াড় কেৎআ য়, মারাঃআং ঙআ দ নিয়া, এ খেরয়াল, আয়ুমেপে; আবুয়া ঈশ্বর প্রভু মিয়াৎ প্রভু; ");
INSERT INTO cdz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","হেৎদ আম আমাঃ আ যত মনঅন্তর তে, আমাঃ আ পেরেচ জিউ তে, আমাঃ আ যত মন হেতৎদ আমাঃ আ যত দাড়ি তে আমাঃ আ ঈশ্বর প্রভুকে কুসিয়ায়েম । ");
INSERT INTO cdz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","দ্সারাঃআ দ নিয়া তানা 'আমাঃ আ হাতু হড় কুকে নিজ লেকা কুসিয়াকুম\" নিয়া বারিয়া হুকুম হাতেৎ মারাঃআং জাহান আ বায়ানা। ");
INSERT INTO cdz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","কটালকুদ ইনিকে কুলি কিয়ায়্য়, বুগিনগুর, আবেন সার্তিগেবেন গাম তাৎআ চিয়া চি ইনিদ মিয়াৎ গেয়ায়্য়, ইনি ছাড়া এটা যাহায় বানুকুয়া ");
INSERT INTO cdz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","হেৎদ আম আমাঃআ যত মনঅন্তর তে, যত বুদ্ধি হেৎদ দাড়িতে আমাঃআ ঈশ্বর প্রভুকে দুলাড়িম হেৎদ হাতু হড় কুকে নিজ লেকা কুসিয়াকুদ যত হোম বলিদান হাতেৎ হঅ সরেস গেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ইন্তং হানি আক্কেলবান লেকা তেলা এম্তাৎআয় যীশু আয়ুম কাতেৎ গামা কিইয়ায়, ঈশ্বর রাঃআ পরগনা হাতেৎ আম দ সাঙ্গীরে বানুমেয়া। ইনাতায়ম ইনিকে জাহান কুক্লি রাঃআ যাহায় রাঃআ সাহস কা য়ুই লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","হেৎদ ধরম থানরে উপমা এম বেতরাঃআং যীশু প্রসঙ্গ কাতে গাম কেৎআয়, কটাল কু চিল্কা কাতেৎ গামেয়া কু, খ্রিস্ট দাউদ রাঃআ হন তানায় মেন্তে? ");
INSERT INTO cdz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","চিয়া চি দাউদ আচ নিজে গেত রিলামালা আত্মা রাঃআ ভরতে নিয়া জাগার লাঃআয়, 'প্রভুপরমেশ্বর ইঞআ প্রভুকে গামাকিয়ায়্য়, আমদ ইঞআ ম্যাডি তিহি দররে দুপ্মে, যাবৎ আমাঃ আ বাইরি আমাঃ আ কাটা বুটাতে কাঞ আগু কুয়া। ইনাব্দি আম ইঞাঃআ মাডি তিহি কাতারে দুপ তাহিনাম। ");
INSERT INTO cdz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","দাউদ নিজে গে হানিকে প্রভুপরমেশ্বর গামাইয়ায়, তবে খান ইনি চিল্কাতে হানি রাঃআ হন হ্যুয়ানায় ? হেৎদ সাধারন হড় কু খুসিতে আয়ায়্য় জাগারকু আয়ুমেতৎ কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","হেৎদ যীশু আয়ায়্য় উপমা রাঃআ লেকাতে ইঙ্কূ কে গামাৎ কুয়ায়্য় য়, কটাল কু রাঃআ হান্ডে হাতে হুসিয়ার, ইঙ্কূ হরেক জিলিং জিলিং কিচি তুসিং কাতে দাড়ান কু সেন আ, ");
INSERT INTO cdz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","হেৎদ হাট বাজার কুরে হড় কুকে মঙ্গল বাদ, জাহের থানরে মারাঃআং ডুবাআ হেৎদ ভোজরে বহ বহ জায়গা কুসিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","নিকু হড়কু রাঃআন্ডি কু রাঃআ অড়া যত কু দ্খ্লেয়া, অটহঅ হড় দেখানি গাদা ঘাড়ি কু বিন্তিয়া, নিকুদ ধরবার মাহা রে গাদা কুড়াই কু নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","হেৎদ যীশু দান ভান্ডার সামাং রে দুপ কাতে, চিল্কা হড়কু ভান্ডাররে কাউডি কু সম্বাৎ কেনা, ইনাকুই নেলেৎ কেনায়। ইন্তং গাদা কিসাড় কিসাড় হড় কু গাদা গাদা কাউডি কু এমেৎ কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ইনা তায়্ম মিয়াৎ রেঙ্গেচ রাঃআন্ডি বুডি হিচ্ কাতে বারিয়া খুব হুডিঙ কাউদী ইনারে সম্বাকেৎআয়, অকারাঃআ মূল্য মিৎ সিকি আনা। ");
INSERT INTO cdz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ইন্তং যীশু আয়ায়্য় চেলা কু কে কাতারে রাঃআ হুন্ডি কাতে গামাৎ কুয়ায়্য় , ইঞ আপেকে সার্তি গেঞ গামা পে তানা, দান ভান্ডারে অকয় কু কাউদী কু সম্বাতাৎআ, ইঙ্কূ য়া জ্ত্চ রাঃআ হাতেৎ হিঁই রেঙ্গেচ রাঃআন্ডি বুডি জ্ত্চ হাতেৎ গাদা ডের এম্ তাআয়্য; ");
INSERT INTO cdz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","চিয়া চি এটা যত হড় আকুয়াআ বাড়তি সম্পদ হাতেৎ ইতিচ ইতিচ সম্পদ কু দহ তাৎআকু, মেন্খান হিঁই আয়ায়া অনটন তাহি কাতে রহ, বঞ্চা তাহি নাতিনাং অকাগে আয়ায়্য় তাহিলেনা, জ্ত্যাগে এম চাবা কেৎআয়্য় ");
INSERT INTO cdz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ইনা তায়ম যীশু ধরম থান হাতে বাহারতে উডুং হিজু বেত্রাঃআং আয়ায়্য় চেলাকু হাতেৎ মিৎ হড় কুলি কিয়ায়্য়, এ গুরু, চিল্কান ধিরি হেৎদ চিল্কান গাথ্নি! ");
INSERT INTO cdz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","যীশু ইনিকে গামা কিয়ায়্য়, আম চি নিয়া মারাঃআং গাথ্নি নিলে তানাম ? নিয়া ধিরি কু মিয়াৎ ধিরি চেতাং রে অটঅ মিয়াৎ ৎ ধিরি কা তাহিনা, জ্ত্যাআ গে ভূমি স্যাত হ্যুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ইনা তায়্ম যীশু দ জৈতান বুরুতে ধরম থান রাঃআ সামাং রে দুপেন খান পিতর, যাকোব, যহন হেৎদ আন্দ্রিয় একলারে যীশু কে কুলি কিয়াকিন, ");
INSERT INTO cdz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","আলেকে গামালেম সিন, নিয়া যত ঘটনা চিলং হ্যুয়ায়্য় ? হেৎদ নিয়া কু হ্যুই চিল্কা তেলে সারি নামেয়া নিয়া রাঃআ চিহ্না কিনা ? ");
INSERT INTO cdz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","যীশু ইঙ্কূ কে গামা রুয়াড় কু তানায়, হুসিয়ার পে, যাহায় যাতে আলকু পটা পেকাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","গাদা হড় ইঞাঃ নুতুম তেকু হিজু য়া, গামেয়াকু, ইঞগে খ্রীস্ট তানাঞ, হেৎদ গাদা হড়কুকে পটাকুয়া কু। ");
INSERT INTO cdz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","মেন্খান আপে চিন্তং জাহাদররে লাড়াই রাঃআ হড় রাঃআ গুজব কিকিচ আয়ুমেয়াপে, ইন্তং আলপে বেকুল আ; নিয়া যত হয়ুয়া গেয়ায়্য় মেন্খান ইন্তং হঅ মুচাৎ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","চিয়া চি জাতি রাঃআ বিরুত্তে জাতি, হেৎদ পরগনা রাঃআ বিরুত্তে পরগনা, হান্ডে নান্ডে ভূমি কম্পন হ্যুয়ায়্য়; দূরভিক্ষ হ্যুয়ায়্য়; নিয়া কু যত দুঃখ কস্ট কু রাঃআ এথব মাত্র। ");
INSERT INTO cdz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","আপে আপেয়া হড় বাব্ত্তে হুসিয়ারপে তাহিনা। মান্মি আপেকে ধরবার সভা রে সম্পআ পেয়াকু, হেৎদ আপে কে জাহের থান রে দাল্পেয়া কু; হেৎদ ইঞআ নাতিনাং আপে দিসুম মাঝি হেৎদ রাঃআপাজ রাঃআ হান্ডে লুকুন্দী এম নাতিনাং ইঙ্কূ য়া সামাং রেপে তিঙগুনা। ");
INSERT INTO cdz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","মেন্খান যত জাতি কুরাঃআ হান্ডে যত হাতে মাড়াং তে বুগিন খবর পাসনা হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","মেন্খান হড়কু আপেকে সম্পা নাতিনাং দরবারে ইদিপেয়া কু, ইন্তং কিনা পে গামেয়া ইনা নাতিনাং মাড়াং তে আল্পে ভাবায়্য়; ইনা অক্ত রে অকা জাগার আপেকে গাম হ্যুয়ায়্য়, ইনাগে গামেপে; চিয়া চি আপেদ অকা জাগার পে জাগারেয়া ইনাদ ল্হয়, মেন্খান রিলামালা আত্মা গামেয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ইন্তং হাগা হাগাকে আপু হনকে গজ নাতিনাং সম্পা কুয়াকু; হেৎদ হন কু আকুয়াআ আপান আপিন মাই বা রাঃআ বিরুদ রেকু হাতিয়ার স্যাপইয়াকু হেৎদ গচ কুয়া কু। ");
INSERT INTO cdz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","হেৎদ ইঞাঃ নুতুম নাতিনাং যতচ আপেকেকু ঘেন্না পেয়া; মেন্খান অক্য়্গে মুচাৎ উতার স্থীর তাহিনায়, ইনি পরিত্রাঃআন নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","এঙ্কা লেকাগে চিন্তং নেলেয়াপে, যত ধংস রাঃআ হানা ঘীন্না লেকা নাআ বুস্তু কদের রে তাহি রাঃআ ল্হয়, এন্ডেগে মেনা আ অকয় পড়ায়ায়্য়, ইনি আটকারে কা আয় -ইন্তং জাহায়্কু জিহুদিয়ারেকু তাহিনা, ইঙ্কূ বুরু দিসুমতে নিরাঃআ কাঃআকু; ");
INSERT INTO cdz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","জাহায়্গে ছাদ চেতাংরে কু তাহিনা, ইনিদ চেতান হাতেৎ আল আড়গুন কাঃআয় হেৎদ জাহান জিনিষ আগু নাতিনাং ভিতরী তে আল্য়য় বলন কাঃআ; ");
INSERT INTO cdz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","হেৎদ জাহায় গে বাইদ রেকু তাহিনা ইনি আয়ায়্য় কিচিই সিনিব হাতা নাতিনাং তায়্ম দর আলয় রুয়াড় কায়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","হায়, ইন্তং পয়াতি হেৎদ মাইকুদ হন রাঃআ নাতিনাং তয়া সাঙ্গা কুয়া ইঙ্কু এরাঃআ হন কু আকুল ইয়ামেয়া! ");
INSERT INTO cdz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","বিন্তিই পে, যাতে ইনাকুদ রাঃআবাঙ কলরে আল হযু কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","চিয়া চি ইনা কলরে নেন্কান দুখ হাজির য়ায়্য়, চিল্কান দুখ ঈশ্বর রাঃআ কৃত সির্জ্ন রাঃআ মাড়াং হাতেৎ নাহা আ অব্দি যাহা হুলাং আউরি হ্যুয়ায়, যাহা হুলাং হঅ কা হ্যুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","হেৎদ প্রভু যদি ইনা মাহা কুরাঃআ সংখা কায় কম কিইয়ায়্য়্য়, এন্খান জাহান জীবজিয়াল কাকু রক্ষা ক্যায়্য়; মেন্খান ঈশ্বর ইঙ্কূ বাছায়ান হড় কু নাতিনাং ঈশ্বরদ ইনা মহা রাঃআ সংখা কমা তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","হেৎদ ইন্তং যদি যাহায় আপেকে কু গামাপেয়া, নেলেপে, হানি খ্রিস্ট নেডেইয়া, বাংখান নেলেপে, হ্যান্ডইয়া, আপে আল্পে পাতিয়াআ। ");
INSERT INTO cdz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","চিয়া চি ভন্ড খ্রিষ্টিয়ানকু হেৎদ নকল ভাবিজাগারিচ কু রাঃআকাপ হিজু য়ায়্য়, অটহঅ নানান হানার চিহ্না হেৎদ উদভূত লক্ষন উডুইয়াকু, যেন ইঙ্কু ঈশ্বর রাঃআ বাছায়ান হড় কুকে হঅ ঠেকা হুইদাড়িয়া কুয়াকু, ");
INSERT INTO cdz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","মেন্খান আপেদ হ্সিয়ার পে তাহিনা। নেলেপে, ইঞ মাড়াং হাতেৎ আপেকেঞ যতচয়্য় গামাৎ পেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","আন্তং রাঃআ, হানে ইনা দুকরাঃআ তায়্ম, বেলা লুবাজ্ঞায়, চাঁডু ত্রেতেচ মার্শাল কায় এমেয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","নিরাঃআলা (আকাশ) হাতেৎ ইপিলকু নুরুয়ায়, চাঁডু, বেলা, ইপিল হেৎদ নিরাঃআলা রাঃআ যত দাড়িযান কামীকু হিড়াঙ সাড়াঙ চাবাআ। ");
INSERT INTO cdz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ইনা হুলাং হড় কু মান্মি হনকে মহা দাড়িয়ান দাড়িতে হেৎদ ক্ষমতা লঅ রিবিল গডিতে আড়গু হিজু কু নেল নামেয়া, ");
INSERT INTO cdz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ইন্তং যীশু সরগ নাগাকুকে কুল কাতে ভূমি রাঃআ আঁটা হাতেৎ নিরাঃআলা রাঃআ আঁটা অব্দি উপুন দর হাতেৎ ঈশ্বর রাঃআ বাছা আকান হড় কু কে হুঁডি কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","হেৎদ লয়া দারু হাতেৎ দৃষ্টান্ত চেদম। চিন্তং আয়ায়্য় ডাইর হাতেৎ বালেচ সেকাম উডুং হিজু য়া, ইন্তং আপে সারি নামেপে ললমাহা সেটের হিচা কানা; ");
INSERT INTO cdz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","এনে ইঞ কাগে আপে ইনা যত ঘটনা কু নেল্লে খান গেপে সারি নামেয়াপে, যীশুদ ঠাইঞ নতে হিচ্ উত্তারাঃআ কানায়, চি, দুয়ার বুটারেগে হাজিরাঃআ কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ইঞ আপে কে সার্তি গেঞ গামাপে তানা, অকা অব্দি নিয়া যত কা পুরাঃআ ইনা অব্দি নিয়া যুগ রিঙ্কূ মান্মিরাঃআ লুপ কা হ্যুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","নিরাঃআলা রাঃআ হেৎদ ভূমি রাঃআ যতচ লুপ হ্যুয়ায়্য়। মেন্খান ইঞাঃ জাগারাঃআ কানা জাহাহুলাং জাহান জাগার কা লুপআ। ");
INSERT INTO cdz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","মেন্খান ইনা হুলাং রাঃআ চি হানা কুড়াই রাঃআ তত্ব জাহায়্গে কাকু সারিয়া, সরগ নাগাকু হঅ কাকু সারিয়া, হন হঅ কায় সারিয়া, একালতে আপুগে সারিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","হুসিয়ার তাহিন্মে, চির্গাল তাহিন্মে, বিন্তিরে তাহিন্মে চিয়া চি ইনা কাল চিলং হিজু য়া ইনাদ কাম সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","মান্মি হন হিজু মাহা রে ইনা উপ্মালেকা, মিয়াৎ হড় আয়া আ অড়া আ বাগী কাতে বাহার দিসুম রে বাসাকানায়; হেৎদ আয়ায়্য় মুনিসকে ক্ষমতা এমা তিয়ায়্য়, যত কামী কু হাটিং ঙআতাৎ কুয়ায়্য় , হেৎদ আঙখ হরইকে চির্গাল তাহি নাতিনাং আদেশ এমাতিয়ায়্য়। এনে এঙ্কাগে ইনা মাহা হিজু য়া। ");
INSERT INTO cdz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","এন্খানগে চির্গাল তাহিন্পে, চিয়া চি অড়া কর্তা চিন্তং হিজু য়ায়্য়, তারসিং বেত্রাঃআং চি তালা নিন্দা, চি সানডি রাঃআরাঃআ অক্ত, চি ভোরতে, আপে ইনা জাহানা আ কাপে সারিয়া; ");
INSERT INTO cdz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ইনিদ আচ্কাগে হিচ্ কাতে গিতিচশ্চ আলয় নেল পেকা আয়্য় ");
INSERT INTO cdz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","হেৎদ ইঞ আপেকে অকা কুঙ গামা তাৎ পেয়া, অটহঅ গে যতচ কে গামা পে তানাঞ, চির্গাল তাহীন পে। ");
INSERT INTO cdz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","সাকরাঃআত পরব হেৎদ বিনা তাড়ি পিঠা পরব্ব রাঃআ বার সিঙ মাড়াং; ইন্তং মারাঃআং বামড়ে কু হেৎদ কটাল কু চিল্কা কাতে যীশুকে কৌশলতে স্যাপ কাতে গচ ইয়াকু, ইনাগেকু কুরুমুটু ভাড়াৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","চিয়া চি ইঙ্কূ গামেতানা, সাকরাঃআতপর্ব্ব রেদ ল্হয়, পাছে মান্মিকু তালারে রেটেপেটে হ্যুই দাড়িয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","যীশু চিন্তং বৈথনিয়ারে কুষ্ঠি সিমন রাঃআ অড়া রে তাহিলেনায়, ইন্তং ইনি জ্জ্মে দুপা কানায় মিয়াৎ কুড়ি হন পুন্ডি ধিরি রাঃআ বাটিরে গাদা মাশুল আসল জটা জিলু রাঃআ সুনুম আগু কাতে হিচা নায়; ইনা বাটিটা ফহা আ কাতে ইনি রাঃআ বহঅ রে সুনুম দুল কেৎআ য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","মেন্খান এন্ডে অক্য়্কু তাহিলেনা বিরক্ত কাতে আকু আকু কু গাম কেৎআ, নিয়া সুনুম রাঃআ নেকা অপ্চয় হ্যুয়ানা চিয়ায়্য় ? ");
INSERT INTO cdz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","নিয়া সুনুম মা আখরিং লেখান আ পিসো সিকি হাতেৎ হঅ গাদা ডের নামকঅয়া, হেৎদ এন্ডে হাতে রেঁগেচ হড় কুকে কিছু ত এম হড় কআ, হেৎদ ইঙ্কূ ইনি কুড়ি হন কে এগের ভাড়াকিয়া আ কু। ");
INSERT INTO cdz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ইন্তং যীশু গাম রুয়াড় কেৎআ য় 'রহ, হিঁই কে তাহি তুকায় পে, চিয়ায়্য় দুখালীই তানাই পে ? হিঁই দ ইঞাঃ আ নাতিনাং সৎ কামিগে কামী তাত্যায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","চিয়্য় চি রেঙ্গেচ হড় কু মা আপে লঅ সারাঃআ খন মেনা কুয়া; আপে চিন্তং গে পে মনেযা ইন্তং গে পে ইঙ্কূয়া উপ্কার দাড়িয়াপে, মেন্খান সারাঃআ ঘড়ি ইঞকে কাপে নামীঞা। ");
INSERT INTO cdz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","হিঁই অকা আ দাড়ি তাৎআয় ইনাগে করাঃআ তাৎআয়; মাড়াং তে হিচ্ কাতে ইঞাঃআ কবর কে দিশা কাতে ইঞাঃআ হড়ম রে মহক সুনুমে দুল কেৎআ য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","হেৎদ ইঞ আপেকে সার্তি গেঞ গামাপে তানা, গটা ধার্তি রাঃআ জাহাদর রেগে বুগিন খবর পাস্নায়ায়, ইনা জায়গারে হিঁই রাঃআ সন্মান নাতিনাং নিয়া কামী রাঃআ কথা গাম গেয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ইনাতায়্ম ইস্করিয়াথি যীহুদা, ইঙ্কূ ১২ হড় কুরাঃআ ভীতির হাতে মিয়ুড়, মারাঃআং বামড়ে কুরাঃআ হান্ডে সেএনায়, যাতে ইঙ্কূ য়া তিহিরে যীশু কে স্প্মা তুকা দাড়িয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ইঙ্কূ আয়ুম কাতে খুশিএনাকু, হেৎদ হানিকে কাউডি এম্কু রাঃআজি এনা; ইন্তং হানি অকা অক্তরে হানিকে সম্পা ইয়ায়্য়, ইনাগে কুরুমুটু রে তাহিনায়। ");
INSERT INTO cdz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","তাড়ি বিনা পিঠা পর্ব্ব রাঃআ মিকিড় (প্রথম)মাহা, অকা হুলাং মকর পর্ব্ব রেনিচ ভিডি হন বুলিসামাং (বলিদান) কেনায়, ইনা হুলাং হানি রাঃআ চেলাকু ইনিকেকু গামা কিইয়ায়্য়, আবু কদের রে সেন কাতে আমাঃ আ নাতিনাং মকর পর্ব্ব বু মানায়ায়? আমাঃ আ কিনা আ ইচ্ছা ? ");
INSERT INTO cdz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ইন্তং যীশু আয়ায়্য় চেলাকু তালারে বার হড়কে কুল কেৎ কিনায়, গামাৎ কিনায়, আবেন সরগ নাগারতে সেনবেন দু, এমন মিয়াৎ হড় আবেনা আ সামাং রে হিজু য়ায়্য়, অক্য়য় মিৎ ঠিলি দাআ আগুকাতে হিজু তানায়; ইনি রাঃআ তায়্ম তায়্মতে সেনবেন; ");
INSERT INTO cdz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ইনি অকা অড়াতে ব্ল্নায়, ইনা অড়া রেনিচ কর্তা কে গামাইম, গুরু গামকুল তৎয়ায়্য়, অকা অড়া রেঞ ইঞাঃআ চেলা কু লঅ সাকরাঃআত পর্ব্ব পিঠা লে জ্মেয়া ইনা অড়া কঠিটাদ অকা আ? ");
INSERT INTO cdz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","এন্খান্গে ইনি হড় আবেন কে চেতান রে সাজায়াকান ছাদরে মারাঃআং কুঠি উডুয়া বেনায়, এন্ডে আবুয়া নাতিনাং স্যাপড়ায় পে। ");
INSERT INTO cdz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ইনাতায়ম চেলাকু উডুং হিচ্ কাতে সরগ নাগারতে কু হিচেনা, হেৎদ যীশু চিল্কা গামাৎ কুকেনায়, এঙ্কাগেকু নেল নাম কেৎআ; ইনাতায়ম ইঙ্কূ সাকরাঃআত পর্ব্ব রাঃআ ভোজ স্যাপড়া কিইয়ায়্য়্য় কু। ");
INSERT INTO cdz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","আয়ুপ এন্খান যীশু ইঙ্কূ ১২ হড় চেলা লঅ হাজিরাঃআনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ইঙ্কূ জ্তচ দুপ কাতে জম নুৎ কেনাকু, ইন্তং যীশু গাম কেৎআ \"ইঞ আপেকে সার্তি গেঞ গামাপে তানা, আপে হাতেৎ মিৎ হড় ইঞকে স্যাপ তুকা ঞআয়, হানি ইঞ লঅ জম নু আয়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ইন্তং ইঙ্কূ দুখালেনাকু, হেৎদ মিহুড় মিহুড় তে ইনিকে কুকলিই তানা, ইনি দ চি ইঞ ? ");
INSERT INTO cdz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","যীশু ইঙ্কূকে গামাৎ কুয়ায়্য় , আপে ১২ চেলা কু ভীতির রে, অকয় ইঞ লঅ জমা আ বাটিরে তিহি স্যাম্ভাৎ আয়্য়, ইনিগে। ");
INSERT INTO cdz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","চিয়া চি মান্মি হন রাঃআ বাব্ত্তে চিল্কা মাড়াং হাতে অল মেনা আ, এঙ্কাগে ইনি সেসেন তানায়;মেন্খান ছে ইনি মান্মিকে, অকয় খাতির মান্মি হন সম্পা তুকা আ তানায়। ইনি মান্মি রাঃআ জানাম কা হই লেন্খান আয়ায়্য় বেশ হই কঅআ। ");
INSERT INTO cdz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ইঙ্কূ জমে নাকু, ইন্তং যীশু পিঠা যত কাতে আশিস এম্কাতে কেচা কেৎআ য় হেৎদ চেলা কু কে এমাৎ কুয়ায়্য় , হেৎদ গামাৎ কুয়ায়্য় \"নে হাতায় পে, নিয়াদ ইঞাঃআ হড়ম তানা। ");
INSERT INTO cdz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","অটহঅ যীশু নু বাটি হাতাকেৎ তে আশিস এম্কাতে চেলা কু কে এমৎ কুয়া, হেৎদ ইঙ্কূ যত হড় এন্ডে হাতেৎ নু কেৎআ কু। ");
INSERT INTO cdz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","যীশু ইঙ্কূ কে গামাৎ কুয়া, নিয়াদ ইঞাঃআ মায়ম, নামা আরি চলি রাঃআ মায়ম, অকাঃআ গাদা হড় কুরাঃআ নাতিনাং লিঙ্গী তানা, নিয়া তাগে মান্মি হেৎদ ঈশ্বর লঅ নামা আরি চলি প্রতিষ্টিত হুইয়া। ");
INSERT INTO cdz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ইঞ আপে কে সার্তি গেঞ গামাপে তানা \"ইঞ অটদ দ্রাঃআক্ষা জ রাঃআ রস কাঞ নু য়ায়ঙ, অকা হুলাং উতার ইঞ ঈশ্বর রাঃআ পরগনা রে কাঞ বলনা হেৎদ নিয়া নামা আরিচালি লেকাতে দ্রাঃআক্ষা জ রাঃআ রস কাঞ নুয়া\" ");
INSERT INTO cdz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ইনা তায়্ম ইঙ্কূ দুরাঃআং কাতে উডুং এন তেকু যৈতন বুরুতেকু সেএনা। ");
INSERT INTO cdz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ইন্তং যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় য়, আপে যত হড় ইঞ কে বাগী কাতে পে নিরাঃআ; চিয়া চি শাস্ত্র অল মেনা আ ' ইঞ বাগাল কে আঘাতিয়াঞ, এন্খান্গে ভিডিকু ছিং ছাতুর চাবাআকু ' ");
INSERT INTO cdz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","মেন্খান গচ কু হাতেদ বিরিৎ রুয়াড় লেন খান ইঞ আপেয়া আ মাড়াং তে গালিলিতে সেনাইঞ হেৎদ এন্ডে আপে লঅ নাপামাঞ, ");
INSERT INTO cdz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","পিতর খুব আগ্রহতে যীশু কে গামাকিয়ায়্য়, যত হড় ভিড়কা রহকু ইঞদ কাঞ ভিড়কা আ। ");
INSERT INTO cdz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","যীশু হানিকে গামাইয়ায়, ইঞ আমকে সার্তি গেঞ গামাম তানা, তিহিং আয়ুপ আম ইঞ কে, সানডি বারসা রাঃআরাঃআ রাঃআ মাড়াং তে, আপি আপিসা ক্যাম পাতিয়াঞা। ");
INSERT INTO cdz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","মেন্খান পিতর গাদা বেশি আগ্রহ উদু কাতে গাম রুয়ার কেৎআ য়, আম লঅ গজ হয়ু খান, জাহালেকা কাতে রহ আমকে কাঞ অপতিয়ায়। এটা যত চেলা হঅ এনকাগে কু গাম রুয়ার কেৎআ। ");
INSERT INTO cdz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ইনাতায়ম যীশুদ চেলা কু লঅ গিদ্সিমানি নুতুমান মিয়াৎ ঠাওরে হিচেনা কু; হেৎদ ইনি আয়ায়্য় চেলা কুকে গামাৎ কুয়ায়্য় , ইঞ চিমিন ঘড়ি বিন্তিয়াঞ, আপে নেডে দুপ তাহিন্পে। ");
INSERT INTO cdz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","তায়্মতে যীশু পিতর, যাকোব হেৎদ যহনকে আচ লঅ ইদিকেৎ কুয়ায়্য় য়, হেৎদ অতি কাঁহিস হেৎদ দুখাল থাকা হই জাবায়্নায়। ");
INSERT INTO cdz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","যীশু ইঙ্কূকে গামাৎ কুয়া ইঞাঃআ জিউ গজ লেকা দুখার্ত হয়ুয়া তানা; আপে নেডে তাহিন্পে, হেৎদ ইঞ চিরগাল তাহিন্পে। ");
INSERT INTO cdz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ইনা তায়্ম ইনি হুডাং সামাং দর সেন কাতে ভূমি রে ইকড়ুমে নায়, হেৎদ নিয়া বিন্তি কেৎআয়, হুই দাড়ি খান, এন্খান নিয়া অক্ত হানি রাঃআ কাতা হাতে সেনকায়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","যীশু গাম্কেৎআয়, এ আব্বা, আপুঞ, জ্ত্যা আগে আমাঃ আ সাদ্য; ইঞাঃআ হান্ডে হাতে নিয়া দুঃখ রাঃআ নুবাটি সাঙ্গীঙ গিডিম; ইঞাঃআ গাম্লেকা তেদ ল্হয়, আমাঃ ইচ্ছা লেকাতে হযু কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ইনাতায়ম যীশু হিচ্ কাতে নেলকেৎ কুয়ায়্য় য়, ইঙ্কূ গিতিচা কানাকু, হেৎদ যীশু পিতরকে গামাইয়ায়, সিমন, আম দ চি গিতিচা কানাম ? মিৎ ঘড়ি হঅ চির্গাল ক্যাম তাহি দাড়িয়া লাআ? ");
INSERT INTO cdz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","চিরগাল তাহিন্পে বিন্তিরে তাহিন্পে, যাতে বিডাউ রে আল্পে নুরুয়া;আত্মা ইছুক, মেন্খান হড়ম জিলু নিজুরি। ");
INSERT INTO cdz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","হেৎদ অটহঅগে যীশু সেন কাতে বিন্তি কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ইনা তায়ম অটহঅগে যীশু হিচ্ কাতে নেল কুয়ায়্য় , ইঙ্কূ জ্তচ গিতিচশ্চা কানাকু; চিয়া চি ইঙ্কূ য়া মেৎরে খুব দুন্দ্রাঃআ লেনাকু, হেৎদ যীশু কে কিনা আ তেলাকু এমায়ায়, ইনা ইঙ্কূ জাহানা কাকু আটকার নামলাআ, ");
INSERT INTO cdz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ইনা তায়্ম আপিসারে যীশু হিচ্ কাতে গামাৎ কুয়ায়্য় য়, নাহা আ গিতিচ সেন্পে ডু, ঝিরাঃআ পে; গাদা হয়ুয়া কানা; অক্ত সেটেরেনা, নেলেপে, মান্মি হন দ বৈরী কুরাঃআ তিহিরে সম্পা তুকাতানায়। ");
INSERT INTO cdz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","বিরিৎপে, আবু সেনাবু দ; হিঁই নিলিপে অক্য়য় হড় ইঞকে স্প্মাঞ তানা ইনি ঠাংতে হিচ্ সেটেরাঃআ কানায়। ");
INSERT INTO cdz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","হেৎদ যীশু চিন্তং থুতি কেনায়, ইন্ত্ঙ গে যীহুদা, হানিদ ১২ চেলা কুরাঃআ মিৎ হড় হিচেনা য় হেৎদ আচ লঅ গাদা হড় কু হাপা ঠেঙ্গা ছরাঃআ গু ধরাঃআ তাৎআ মারাঃআং বামড়ে কু, কটাল কু হেৎদ মুরুব্বি কুরাঃআ হান্ডে হাতেৎ কু হিচা কানা। ");
INSERT INTO cdz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","অক্য়য় ইনিকে সম্পাই কেনায়, মাড়াংতে ইনি ইঙ্কূকে সঙ্কেৎ গাম দহলাৎ কুয়ায়্য় য়, ইঞ অক্য়য় কে চঅ ইয়াঞ, ইনিগে ইনি হড়, আপে ইনিকে স্যাপ কাতে বেশ গটা তে ইদিইপে। ");
INSERT INTO cdz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ইনি চেলা হিচ্ কাতে ইন্তং গে যীশু রাঃআ সামাং রে হিচ্ কাতে গাম্কেৎ আয়, প্রভু; হেৎদ ইনিকে আগ্রহ উডু কাতে চঅ কিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ইন্তংইঙ্কূ যীশু রাঃআ চেতাং রে তিহি এম কাতে স্যাপ তল কিয়ায়্কু। ");
INSERT INTO cdz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","মেন্খান অক্য়্কু যীশু রাঃআ কাতারেকু তিঙগু লেনা হান্কুয়া ভীতির হাতেৎ মিহুড় ছরাঃআ উডুং কাতে মারাঃআং বামড়ে রাঃআ মুনিস কে ঠেলা কিয়ায়্য় হানি রাঃআ লুতুর মাআ কেচ্ছা কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ইন্তং যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় য়, চিল্কা দুশ্সু শাসাব কু সেন্য়ায়, এনে এঙকা চি চরাঃআ, হাপা ঠেঙ্গা আগু কাতে পে হিচা কানা ? ");
INSERT INTO cdz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ইঞ মা মাহা গে ঈশ্বর রাঃআ ধরম আখড়া রে উপমা এম তাত্যায়ঞ, ইন্তং মা ইঞ কে কাপে সাব লিইজ্ঞা; মেন্খান শাস্ত্র রাঃআ বচন কু পূর্ণ জরুর গেয়া\" ");
INSERT INTO cdz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ইন্তং যত চেলা কু আচ কে বাগী কাতে নির চাবায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","হেৎদ, মিয়াৎ জুয়ান বিন কিচি সিনিপ হড়ম তে মিয়াৎ চাদর তে উযু কাতে যীশু রাঃআ তায়্ম তায়্ম তে তাড়ম কেৎআয়; ইঙ্কূ ইনিকে সাব কিয়া কু, ");
INSERT INTO cdz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","মেন্খান ইনি ইনা চাদর হুরলা গিডি কাতে লেংটা তেগে নিরেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ইনা তায়্ম ইঙ্কূ যীশু কে মারাঃআং দিহীরী রাঃআ হান্ডে ইদিকিয়াকু; হানি লঅ মারাঃআং বামড়ে কু, মুরুব্বিকু হেৎদ কটাল কু যত কুগে হিচ্ হুন্ডি নাকু। ");
INSERT INTO cdz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","হেৎদ পিতর সাঙ্গীং হাতেৎ আয়ায়া তায়্ম তায়্ম হিচেনা য়,মারাঃআং বামড়ে রাঃআ পিন্ডগী ভীতির উতার সে এনায়, হেৎদ হরকু লঅ দুপ কাতে সেঙ্গেলতে যুরূপ কেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ইন্তং মারাঃআং বামড়ে কু হেৎদ যত মারাঃআং দিহীরীকু যত যীশু কে গচ নাতিনাং হানি রাঃআ বিরূদ সাখি কু উডু কেৎকুআ, মেন্খান সাখি কাকু এম লাআ। ");
INSERT INTO cdz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","চিয়া চি গাদা হড় হানি রাঃআ বিরুদতে বেদা জাগার কু গাম্কেৎআ মেন্খান হান্কুয়া লুকুন্দী কা মিলালেনা। ");
INSERT INTO cdz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ইনাতায়ম মিৎ হড় তিন্গু কাতে আয়া আ বিরুতে বেদা থুতি গাম কেৎআ কু, ");
INSERT INTO cdz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","আলে ইনিকে নিয়া থুতি গাম লে আয়ুম তিয়ায়্য়, ইঞ নিয়া তিহিতে বানা কানা বিন্তি মুন্দির পেটেচ নুরেয়াঙ হেৎদ আপিমাহা ভিতিরে তিহিতেদ লহয় অটঃ মিয়াৎ বিন্তি মুন্দির বানা রুয়ারেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ইনাতে হঅ ইঙ্কূয়া লুকুন্দী কাকু নাম লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ইন্তং মারাঃআং বামড়ে তালা মালারে তিন্গু কাতে যীশু কে কুলি কিয়ায়্য়, আম দ চিযায় কুক্লি রাঃআ জাহান তেলা কাম এমেয়ায় ? নিকু আমাআ বিরুদ্দে কিনাআ কু গামেতানা ");
INSERT INTO cdz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","মেন্খান ইনিদ থির থার গে তাহিনায়, জাহান তেলা কায় এম লা আয়। অটহঅ গে মারাঃআং বামড়ে কুলি কিয়ায়্য়, আমদ চি ইনি খ্রীস্ট পরম ধন্য রাঃআ হন তানাম ? ");
INSERT INTO cdz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","যীশু গাম রুয়ার কেৎআ য়, ইঞ গে ইনি; হেৎদ আপে মান্মি হনকে পরাঃআক্রমশালী ঈশ্বর রাঃআ মাডি তিহি দররে দুপ্পে নেলিয়া হেৎদ নিরাঃআলারে রিবিল গাডিতে হিজু পে নেলিয়া। ");
INSERT INTO cdz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ইন্তং মারাঃআং বামড়ে আয়ায়া কিচিই অড়েচ কাতে গাম কেৎআয়, লুকুন্দী অটঃ কিনা আ জরুর? ");
INSERT INTO cdz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","অপেমাত ঈশ্বর নিন্দা আয়ুম কেৎআপে; আপেয়া কিনা আ বিবেচনাৎ আপে ? ইঙ্কূ যত হড় যীশু কে ধোষী কাতে গাম কেৎআ কু, হিঁই দ গজ নাতিনাং যোগ্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ইন্তং কথক হড় কুদ আয়া আ হড়ম রে বেইচই তানা কু, হেৎদ ইনি রাঃআ মেৎ মুহাড় দাপাল কাতে ইনিকে ভুকড়া তানাই কু; হেৎদ গাগাম তানাকু, ভাবিজাগারিচ গামেম সিন? ইনা তায়্ম হর হড়কু দাল দলতে যীশু কেকু ইদি কি য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","পিতর চিন্তং লতার পিন্ডগিরে তাহীন কেনায়, ইন্তং মারাঃআং বামড়ে রাঃআ মিয়াৎ মুনিস কুড়ি হন হিচেনা য়; ");
INSERT INTO cdz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","হানিদ পিতরকে যুরুপে নেল কিচখান ইনকে উডু কাতে গাম্কেৎআয়,আম হঅমা নাজরতিয়, ইনি যীশু লঅ তাহীন কেনাম। ");
INSERT INTO cdz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","মেন্খান পিতরদ কায় পাতিয়ালেনায় গাম্কেৎআয়, কিনাবেন গামে তানা, জাহানা আ কাঞ সারি নামেৎ আঞ, কাঞ আটকার নামেয়ায়। ইনা তায়্ম উদু কাতে সদর দুয়ার দরে সেএনায়্য়, ইন্তংগে স্যান্ডি রাঃআ গত কেৎআ য়। ");
INSERT INTO cdz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","মেন্খান মুনিস কুড়ি হন ইনিকে নেল কাতে, অক্য়্কু কাতারে তিন্গু লেনাকু, ইঙ্কূকে হঅ গামাকুতানায়, হিঁই হড় দ চি ইঙ্কূয়া কুরাঃআ মিতহড়। ");
INSERT INTO cdz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","পিতর অটঃহঅগে কায় পতিয়ায়নায়। হুডাং তায়্মতে, অকয় কু কাতারে তিন্গু তাহিলেনাকু, অটহঅগে পিতর কেকু গামাকিযেয়, সার্তি গে আম ইঙ্কূ য়া মিত হড়, চিয়া চি আম মা গালিলিরেনিচ হড়। ");
INSERT INTO cdz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","মেন্খান পিতরদ সায়্য়প লঅ স্পত কাতে গামকেৎআয়, আপে অকয় হড় রাঃআ কথা পে গামেয়ায়্য়, ইঞ হানিকে কাঞ চিন্হায়ায। ");
INSERT INTO cdz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ইন্তং গে দশার সা স্যান্ডি রাঃআ গত্ কেৎআয়;এন্খান যীশু অকা কথা গাম লাত্যায়্য়' স্যান্ডী বারসা রাঃআ মারাঃআঙ তে আম অপিসা ইঞ কে কাপাতিয়া ঞাম, ইনা জাগার পিতর রাঃআ মনে হিচেনা ; হেৎদ পিতর ইনা পাহাম কাতে হামরাঃআতে ইয়াম কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","হেৎদ সেতাআ রে গে মুরুব্বিকু হেৎদ কটালকু লঅ মারাঃআং বামড়ে কু হেৎদ যত মহাসভা শড়যন্ত্র কাতেৎ যীশু কে ত্ল্ ইদি কাতে পিলাত রাঃআ তিহিরে সম্পা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ইন্তং পিলাত ইনি কে কুলিকি য়ায়্য়্য়, আম দ চি জিহুদিরেনিচ রাঃআজা ? ইনি হানিকে গাম রুয়াড় ইয়ায়্য়, আম গে গাম কেৎআয়ম। ");
INSERT INTO cdz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ইনা তায়্ম মারাঃআং বামড়ে কু যীশু রাঃআ বিরূদ গাদা দ্সারপ কু গাম ইদিকেৎআকু। ");
INSERT INTO cdz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","পিলাত যীশু কে অটহঅগে কুলি রুয়াড় কিইয়ায়্য়, আম দ চিয়া জাহানাআ তেলা কাম এমেয়া? নেলেম, ইঙ্কূ আমাঃ আ চেতান রে চিন্তিত্ত দ্সারোপ করাঃআৎ আকু, ");
INSERT INTO cdz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","মেন্খান যীশু জাহান তেলা কায় এমলাৎআয় এন্খান্গে পিলাত খুব হাহাড়ায় নায়। ");
INSERT INTO cdz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","পরব মাহারে পিলাত দ হড়কু নাতিনাং মিৎ হড় কয়দি কে আড়া য়াইয়া, অক্য়য় কে হাঙকু কু নানামা। ");
INSERT INTO cdz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","বিরধী, হড় গ্জিচ, অপ্তা জকম রাঃআ অপরাঃআধ নাতিনাং অক্যয় অপরাঃআধী কু জিহালরে কাঞ্জু তাহি লেনা ইঙ্কু লঅ বারাঃআব্বা নুতুমান মিয়াৎ বরবট হড় তাহি লেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ইন্তং পিলাত হড় কুরাঃআ সামাঙ রে সেন কাতে চিল্কায় কামিৎ কেনায় এনেঙ্কা গে করাঃআ কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","পিলাত গাম রুয়াড় কেৎকুয়ায়্য় য়, ইঞ আপে নাতিনাং যিহুদিকু রাঃআ রাঃআজা কে আড়া ইয়াঞ, নিয়া গে চি আপেয়া ইচ্ছা ? ");
INSERT INTO cdz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","চিয়া চি মারাঃআং বামড়ে কু হিংসা কাতে যীশু কে স্প্মা তিয়াকু ইনা পিলাতদ সারিনাম তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","মেন্খান মারাঃআং বামড়ে কু হড় কুকে উস্কা কাতে বরং আকুয়াআ নাতিনাং বারাঃআব্বাকে আড়াই কাঃআ মেন্তে কু গামেকাঃআ। ");
INSERT INTO cdz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ইনাতায়ম পিলাত অটহঅ গে গাম রুয়াড় কাতে গামাৎ কুয়ায়্য় , তবেখান আপে অক্য়কে যিহুদিকু রাঃআ রাঃআজাপে গামাইয়া, ইনিকে কিনা আঞ চিকাইয়া? ");
INSERT INTO cdz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","হাঙকু অটহঅগে কিকিচ কাতে কু গাম কেৎআ, ইনিকে ক্রূশ রে ঝুলাইম। ");
INSERT INTO cdz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","পিলাত হান্কুকে গামাৎ কুয়া, চিয়া ? হিঁই কিনা আ দ্সিতায়ায়? মেন্খান হাঙকু খুবরাঃআগ্তে কিকিচ কাতে কু গাম কেৎআ। ইনিকে ক্রূশ রে ঝুলাইম। ");
INSERT INTO cdz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ইন্তং পিলাত হড় কুকে সান্ত তুকা নাতিনাং হাঙকুয়া নাতিনাং বারাঃআব্বাকে আড়া গিডি কিইয়ায়, হেৎদ যীশু কে দাল কাতে ক্রূশ রে ঝুলা নাতিনাং রমান সেনা কু রাঃআ হান্ডে স্প্মা কিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ইনা তায়ম রমান সৈন্যকু রাঃআজ দরবার রাঃআ তালা রাঃআচারে, যীশু কে ইদিকাতে যত সৈন্যকু কে রাঃআ হুন্ডি কেৎকুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ইনা তায়্ম বেগুনিয়া কিচিই তুসিং কিয়াকু, হেৎদ জানুম ধাহাড়ী গালাং কাতে যীশু রাঃআ বহ রেকু লাৎয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","হেৎদ যীশু কে টিটকারী লেকাতে গড় জহার কিয়াকু হেৎদ গামাইয়া কু যিহুদী রাঃআজ, জহার! ");
INSERT INTO cdz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","হেৎদ যীশু রাঃআ বহরে চ্ঙ্গা তে কুটাম কিয়াকু, ইনি রাঃআ হড়ম রে বেচ কিয়া কু, হেৎদ উকড়ুম কাতে ইনিকে টিটকারী জহার কিয়াকু, ");
INSERT INTO cdz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","যীশু কে টিটকারী করাঃআ রাঃআ তায়্ম হাঙকু ইনা বিগিনিয়া কিচিই হতর কাতে আয়ায়া কিচিইকু তুসিং কিয়া। ইনাতায়ম হাঙকু ক্রূশ রে ঝুলা নাতিনাং ইনিকে বাহার তেকু উডুং কিয়া ");
INSERT INTO cdz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","হেৎদ সিমন নুতুমান মিয়াৎ কুরিনিয়া রেনিচ হড় হাতে হাতেৎ ইনা হরতেয় হিজু কেনায়, হানিদ আলেকজান্ডার হেৎদ রুফ্রাঃআ রাঃআ আপু তাকিনায় ইনিকে ইঙ্কূ ক্রূশ গঅ নাতিনাং পাকড়াও কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ইনাতায়ম হাঙকু ইনিকে গ্ল্গ্থা নুতুমান ঠাওরে কু ইদিকিয়া; নিয়া নুতুম রাঃআ অর্থ দ ' বহ খুলি রাঃআ ঠাও। ");
INSERT INTO cdz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","হেৎদ ইঙ্কূ যীশু কে শয়ান রসতে মেশা কানা 'দ্রাঃআক্ষা রস এম বুঝা কেৎ কুয়া মেন্খান যীশু দ কায় নু লাআয়। ");
INSERT INTO cdz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ইনা তায়ম হাঙকু যীশু কে ক্রূশ রে ঝুলা কিয়াকু হেৎদ ইনি রাঃআ কিচিই সিনিব হতর কাতে হাতাকেৎআকু; অকয় অকাকু হাতায়া, গটা ঠাক নাতিনাং গুলিবাট কিইয়ায়্য়্য় কু । ");
INSERT INTO cdz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","সেতাআ নয় টাড়াঙ রে হাঙকু যীশু কে ক্রূশ রেকু ঝুলা কিয়া। ");
INSERT INTO cdz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","হেৎদ ক্রূশ রাঃআ চেতান মুডুরে ধোষীলিপি নেকাকু অল কেৎআ, যিহুদিকু রাঃআ রাঃআজা। ");
INSERT INTO cdz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","হেৎদ হাঙকু যীশু রাঃআ বার দররে বারিয়া দুস্স্য় কে ক্রূশ রে ঝুলা কেৎকিনাকু, মিয়ুড় কে আয়ায়্য় ম্যাডি তিহি দররে অটঃ মিয়ুড় কে আয়ায়্য় লেঙ্গা তিহি দররে। ");
INSERT INTO cdz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","হেৎদ অকয় হড় কু যত ইনা হরাঃআ কাতাতে সেন্কেনা, হাঙকু বহঅ হিলা হিলা কাতে টিটকারী জাগার গাম্কেৎয়াকু, ");
INSERT INTO cdz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ওই, আম মা চি মুন্দির পঃহআ গিডিয়াম, হেৎদ অপিমাহা ভীতিররে অটহঅ গাঁথা রুয়াড়েয়াম! ");
INSERT INTO cdz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","আমকেগে বাঁন্চাম, যদি ঈশ্বর রাঃআ হন তানাম তবে ক্রূশ হাতে আড়গুন্মে। ");
INSERT INTO cdz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","অটহঅ এনেঙ্কা গে মারাঃআং বামড়ে কু হঅ কটাল কু লঅ আকু আকু গে টিটকারী কাতে কু গাম কেৎআ, হিঁঃই হড় চি এটা এটা হড় কুকে বাঞ্চা লাৎকুয়ায়্য় য়, আচ্ নিজকে কায় বাঁনচা দাড়ি তানায়; ");
INSERT INTO cdz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","খ্রীস্ট, ইসরাঃআইলকুরাঃআ রাঃআজা, নাহাআ ক্রূশ হাতেৎ আড়গুনমে, আলে নেল কাতে পাতিয়ায়লে। হেৎদ অকয় আচ লঅ ক্রূশরে কিন টাঙ্গা লেনা, ইঙ্কিন হঅ আচ্কে টিটকারী তানায়্য় কিন। ");
INSERT INTO cdz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ইনা তায়্ম তিকিন 12 টাড়াঙ হাতেৎ তারসিং আপি টাড়াঙ উতার সারাঃআ ধার্তি লুব্বা তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","হেৎদ তারসিং আপি টাড়াঙ রে যীশু কুঠিন জোর তে কিকিচ কাতে গাম কেঃআয়, এলি এলি, লামা সাবাথ থানি; অর্থ দ নিয়া তানা' ঈশ্বর ইঞাঃআ, ঈশ্বর ইঞাঃআ, আম চিয়াৎএম বাগীইয়াং তানা? ");
INSERT INTO cdz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","এন্খান্গে অকয় কু কাতারে কু তিঙ্গু লেনা, হান্কুয়া ভিতিরে অকয় অকয় ইনা জাগার আয়ুম কাতেকু গাম কেৎআ, নেলিপে, যীশুদ এলিও কে রাঃআ ই তানা। ");
INSERT INTO cdz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","হেৎদ, মিয়াৎ হড় নির হিচ্ কাতে মিয়াৎ স্পঞ্জরে সিরকা আগু কেৎতে ইনিকে নু তুকাকিচতে গামকেৎআ, তাহিন কাঃআ, ঞেল লিঞ, এলিও হিঁইকে আড়গু হিজু য়ায় চি ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ইনা তায়্ম যীশু জিলিং সাঁহেৎ কেৎতে গ্চেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ইন্তং ঈশ্বর রাঃআ মুন্দির রাঃআ তিরস্ক্র্নি পর্দা চেতাং হাতেৎ লতার উতার বার ফাঁক চিরাঃআয়না। ");
INSERT INTO cdz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","হেৎদ অকয় লাউড়িয়া পাল্টন আয়ায়্য় সামাং রে তিন্গু লেনায়, ইনি চিন্তং নেল কেৎআয়, যীশু নেকা লেকাতে জিউ নাসাকেৎআয়, ইন্তং গাম্কেৎআয়, সর্তিগে ইনিদ ঈশ্বর রাঃআ হনে তাহি লেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","কথক কুড়ি হনকু সাঙ্গীং রে তিন্গু কাতে নেলেৎ কেনা; হ্যাংকুয়া তালা হাতে ম্গ্দালিনি মরিয়ম, হুডিঙ যাকোব রাঃআ মাই হেৎদ যোসি রাঃআ মাই মরিয়ম হেৎদ সালমি তাহীন কেনাকু; ");
INSERT INTO cdz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","চিন্তং ইনি গালিলিরে তাহীন কেনায়, ইন্তং হাঙকু ইনি রাঃআ তায়্ম তায়্মতে সেসেন কেনাকু হেৎদ আয়ায়্য় সেবা দেবাৎ কেনাকু। অটহঅ গাদা কুড়ি হন কু তাহি লেনা, অকয় কুদ আচলঅ যিরুশালেম তেকু হিচ্ লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ইনা ত্য্ম আয়ুপেনা, ইনা হুলাং কামীমাহা অর্থাৎ ঝিরাঃআ মাহা রাঃআ মাড়াং মাহা মেন্তে, ");
INSERT INTO cdz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","অরিমাথিয়া যোসেপ নুতুমান মিৎ গুনমান হড় হিচেনা য়, ইনি হঅ ঈশ্বর রাঃআ পরগনা নাতিনাং তাঙ্গিরে তাহিলেনায়; ইনি সাহস কাতে পিলাত রাঃআ হান্ডে সেন কাতে যীশু রাঃআ হড়ম আসি কিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","মেন্খান যীশু দ নান্তীত ঘিড় মেন্তাং জগঃআ কানায়, এন্খান্গে পিলাত কুঠিনে হাহাড়ায় নায়, হেৎদ হানি লাউড়িয়া পাল্টন কে রাঃআ কাতে, ইনি নিন্তং গে গ্চাকানায় চি ল্হয়, কুলিকিয়ায়; ");
INSERT INTO cdz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ইনা তায়্ম পাল্টন রাঃআ হান্ডে হাতেৎ সারি কাতে যোসেপকে হড়ম এমগিডি য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","যোসেপ মিয়াৎ চাদর কিরিং কেৎতে ইনিকে আড়গু কাতে ইনা চাদর রে পটম কিয়ায়, হেৎদ ধিরি রাঃআ বানা তাহি লেনা কবর রে গিতিচ দহ কিয়ায়্য; ইনা তায়্ম মিয়াৎ ধিরি গাঢা রাঃআ দুয়ার রে হান্ডেৎ কেৎআ য়। ");
INSERT INTO cdz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ইনিকে কদের রে দহ হুয়েনা, এন্ডে ম্গ্দালিনি মরিয়ম হেৎদ যোসির রাঃআ মাইতেৎ মরিয়ম নেল নাম্ কেৎআ কিন। ");
INSERT INTO cdz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ঝিরাঃআ মহা চাবান খান ম্গ্দালিনি মরিয়ম, যাকোব রাঃআ মাই মরিয়ম হেৎদ সাল্মি বুগি শয়ান সুনুম কিরিং কেৎআয়, সেন্কাতে অজঅ দাড়িয়া কাঃআই মেন্তে। ");
INSERT INTO cdz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","হাপ্তা রাঃআ মাড়াং মাহা হাঙকু গাদা ভোরতে, বেলা রাঃআকাপ লেন খান, গাঢা রাঃআ কাতা তেকু হিচেনা। ");
INSERT INTO cdz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","হাঙকু আকু আকু কু থুতি জাগার কেনা, গাঢা দুয়ার হাতেৎ অকয় আবুকে গাঢা দুয়ার রাঃআ ধিরি সরাঃআ বুয়ায়্য়? ");
INSERT INTO cdz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ইন্তং ইঙ্কূ কয়অ নাম কেৎ য়াকু, ধিরিটা সরাঃআকানা; চিয়া চি ইনাদ গাদা মারাঃআং ধিরি তাহিলেনা। ");
INSERT INTO cdz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","চিন্তং ইঙ্কূ গাঢা রাঃআ ভীতির রে সেন কাতেকু নেল কেৎআ, ম্যাডি তিহি দর পুন্ডি কিচিই তুসিং কাতেৎ মিয়ুড় কড়া হন দুপা কানায়; এন্ খান্গে হাঙকু কুঠিন চমকা এনাকু। ");
INSERT INTO cdz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","সরগ নাগা ইঙ্কূ কে গামাৎ কুয়ায়্য় , আলপে চমকা আ, আপে নাসারিথিয় যীশু কেপে পাঞ্জা ইতানা, অকয়দ ক্রূশ রে গচ লেনায়; ইনিদ বিরিৎআ কানায়, নেডেদ বানুইয়া; নেলেপে, হেঁএ নেডে ইনি রাঃআ হড়ম দহ হুই লেনায়; ");
INSERT INTO cdz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","মেন্খান আপে সেন্পে ডু, আয়া আ চেলা কু কে হেৎদ পিতর কে গামাকূপে, ইনিদ আপেয়া মাড়াং মাড়াংতে গালিলিতে সেন তানায়; চিল্কা আপেকে গামালাৎ পেয়া, হান্ডে আপে ইনিকে পে নেল নামিয়া। ");
INSERT INTO cdz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ইন্তং ইঙ্কূ গাঢা হাতেৎ উডুং কাতে নিরে নাকু, চিয়া চি হাঁঙ্কূ বরতে থার থারাঃআ হেৎদ হাহাড়া লেনাকু; হেৎদ হাঙকু যাহায় কে জাহানা আ কাকু গামা লাত কুয়া; চিয়া চি ইঙ্কূ দ বর লেনা কু। ");
INSERT INTO cdz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","হাপ্তা রাঃআ মাড়াং হুলাং যীশু ভোরতে বিরিৎ লেন খানদ যত হাতে মাড়াং তে ম্গ্দালিনি মরিয়ম কে দেখা এমা লিয়ায়্য়, অকয় রাঃআ হান্ডে হাতে সাতটা বঙ্গা ছাডা লিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ইনি সেন কাতে, অক্য়য়্ চেলা কু যীশু লঅ কু তাহীন কেনা হান্কুকে খবর রে এমাৎ কুয়ায়্য় , ইন্তং ইঙ্কূ শোক হেৎদ কু ইয়াম কেনা। ");
INSERT INTO cdz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","চিন্তং আয়ুম কেৎআকু যে, ইনিদ জিউৎ গেয়ায়্য়, হেৎদ হানিকে ভেট এমাতিয়ায়্য়, ইন্তং কাকু পাতিয়া লেনা। ");
INSERT INTO cdz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ইনা তায়্ম বারিয়া চেলা হাতু তেকিন সেন কেনা, ইন্তং ইনি অটঅ এটাঃ আকার তে ইঙ্কূ আ হান্ডে স্দরেনায়। ");
INSERT INTO cdz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ইঙ্কূ সেন্কাতে এটা যত হড়কু কে নিয়া সারি তুকা কেৎ কুয়ায়্য় , মেন্খান ইঙ্কূ য়া জাগার্তে হাঙকু কাকু পাতিয়ালেনা। ");
INSERT INTO cdz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ইনা তায়্ম ইঙ্কূ ১১ চেলা যজম কু দুপ লেন খান যীশু ইঙ্কূ য়া হান্ডে স্দরেনায়, হেৎদ ইঙ্কূ য়া কা পাতিয়া হেৎদ মনে রাঃআ কঠিনতা খাতির ইঙ্কূ কে এগের কেৎ কুয়ায়্য় ; চিয়া চি ইনি বিরিৎ রুয়ারেন খান অকয় কু ইনি কে নেল লিয়া কু, ইঙ্কূ য়া জাগার তে কাকু পাতিয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","হেৎদ যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় , আপে গটা দিসুম তে সেন পে দু, গটা ধার্তি মান্মি কু রাঃআ হান্ডে বুগিন খবর পাস্নায়্পে। ");
INSERT INTO cdz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","অক্য়য় কু পাতিয়ায়্য় হেৎদ ডুবান নআকু, ইনি দ পরিত্রাঃআন নামেয়ায়; মেন্খান অকয় আয়ুম কাতে রহঅ কায় পাতিয়া আয় হানি বেসলেকা কুড়াই নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","হেৎদ অকয় কু পাতিয়ায়্য়, নিয়া হাহাড়া চিন্হা আকু কু করাঃআ দাড়িয়া; ইঙ্কূ ইঞাঃআ নুতুমতে বঙ্গা কু কুদাকুয়া, ইঙ্কূ নামা নামা ভাষা তে থুতিয়াকু, ");
INSERT INTO cdz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ইঙ্কূ দ বিইঞ কেকু স্যাপ কুয়া হেৎদ জিউ নাসা জাহানাআ কু নুই রেহঅ ইঞ কুয়া জাহালেকা কাতে জাহানাআ ক্ষতি কা হয়ুয়া; ইঞ কুদ রুয়া হাসু কুরাঃআ হড়ম চেতান রে তিহি কু এম লেখান বেস্যআকু। ");
INSERT INTO cdz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","যীশু চেলা কু লঅ জাগার তায়্ম প্রভু যীশু চেতান দর, সরগ তে সেএ নায়্য, হেৎদ ঈশ্বর রাঃআ ম্যাডি তিহি দর রে দুপে নায়। ");
INSERT INTO cdz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","হেৎদ চেলা কু উডুংকাতে যত জায়গারে পাস্নাকু লাগায় না; হেৎদ প্রভু লঅ হাহাড়া কামী পুরাঃআ রাঃআ চিন্হ লঅ ইনা বচন প্রমান কেৎআয়্য় আমেন। আমেন।");
INSERT INTO cdz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","গুনবান থীওফিল মাড়াং হাতেন অকয়কুদ আকু আকুয়াআ মেৎতে নেল আউতাঃআকু হেৎদ জাগার সেবা করাঃআ আউতাঃআকু ইঙ্কূ দঅ আলেকে চিল্কা সম্পা তাৎলেয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","এঙ্কা গে গাদালেকা আলেয়া ভিতির হাতেন পুরাঃআ-গোটা বাব্ত্তে কু অল দঃহ নাতিনাং ছুটায় নাকু ");
INSERT INTO cdz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ইনা নাতিনাং ইঞ হঅ মাড়াং হাতেন যত বাব্ত্তে গটা ঠাক পাঞ্জা তাৎআঞ মেন্তে হে বাপধন থিওফিল আমকে ইনা ঘটনা বেশ লেকা অল নাতিনাং গটা নেকা আটকার কেৎ আঞ ");
INSERT INTO cdz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","যাতে আম অকা যত বাব্ত চেৎআ কানাম ইনা যত বাব্ত্তে নিশ্চিত তাহিনমে ");
INSERT INTO cdz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","জিহুদিয়া রিনিজ রাপাজ হেরোদ রাঃআ আমলরে অবিয় বামড়ে দল রেনিচ সখরীয় নুতুমান মিয়াৎ বামড়ে তাহীন কেনায় ইনি রাঃআ এরাঃআ বামড়ে হারোণ কুল রিনিজ ইনি রাঃআ নুতুমদ ইলিশাবেৎ ");
INSERT INTO cdz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ইঙ্কিন বানার হড় সখরীয় হেৎদ ইলিশাবেৎ ঈশ্বর লিয়া ধার্মিক তাহিন কেনাকিন প্রভু রাঃআ যত হুকুম হেৎদ আরি-চালি মানা বাতা লেকাতে ফার্চা মনেতে সেসেন কেনা কিন ");
INSERT INTO cdz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","হানকিনাঃআ হন কাকু তাহীন কেনা চিয়াঃচি ইলিসাবেৎ দ আটকুড়া তাহীন কেনায় হেৎদ বারহড় গে ঢেরগে বয়সকিন তাহীন কেনা ");
INSERT INTO cdz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","মিৎ মাহা হুলাং সখরীয় আয়া পালা সেটের লেকাতে ঈশ্বর রাঃআ সামাংরে বামড়েরাঃআ কামী য়েত/করাঃআ কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ইন্তং বামড়ে রাঃআ কামিকুরাঃআ রি-চালি মানালেকাতে গুলিবাঁট লেকাতে ইনিকে প্রভু রাঃআ জাহের স্থান তে বলকাতে ধুপ ধরাঃআ নাতিনাং বাছা হুয়েনা। ");
INSERT INTO cdz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ইনা ধুপধরাঃআ অক্ত যতচ হড় বাহাররে তাহি কাতেন বিন্তি আসি কেনাকু ");
INSERT INTO cdz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ইন্তং প্রভু রাঃআ মিয়াত সরগ নাগা /সেরমা-সরগ নাগা (সরগ নাগা ধুপবেদীরাঃআ দক্ষিন দররে তিনগুতাহিনকেনায় হেৎদ প্রভূরাঃআ সরগ নাগা /সেরমা-সরগ নাগা (সরগ নাগা হিচ:কাতেন আয়চকে নেল তকাকিৎআয় ");
INSERT INTO cdz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","নেল কাতেন সখরীয় আত্রাঃআস এ নায় হেৎদ বরঃ বলনতে দালপ দহকিয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","মেন্খান সরগ নাগা আয়কে গাম্কিয়ায় সখরীয় আলম বরঃআ চিয়াঃচি আমাঃ কয় আর্জি আয়ুম হুয়াকানা আমাঃ এরাঃআ ইলিশাবেদ আমাঃ নাতিনাং কড়াহন জনমিয়ায় হেৎদ আম ইনি রাঃআ নুতুম যোহন দহয়আম ");
INSERT INTO cdz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","হেৎদ আম রাঃআসকাম হেৎদ কুশিয়াম অটঃ ইনি রাঃআ জনমরে ঢেরলেকা হড় খুসিয়া কু ");
INSERT INTO cdz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","চিয়াঃচি ইনি প্রভু রাঃআ সামাংরে মারাং হুয়ুয়ায় হেৎদ ইনিদ দ্রাঃআক্ষারস অটঃ আরখি-কলাং যাহানা কায় নুইআয় ইনি এঙ্গাতেদ রাঃআ লাহিচ হাতেন রিলামালাতে আত্মা পেরেজয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","হেৎদ ইস্রাঃআয়েল হড় কুয়া ভীতির হাতেন ঢের লেকাকে প্রভু আকুয়াআ ঈশ্বর রাঃআ হান্ডে রুয়াড় আগুকুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ইনি প্রভু রাঃআ সামাংতে এলিয় রাঃআ আত্মা হেৎদ দাড়িতে সেসেনায় যাতে আপুকুরাঃআ মন হন্হপনকু রাঃআ হান্ডে ঘুরাঃআ রুয়াড় হেৎদ হুকুম বেরাঃআহী/কা-মানা হড়কু দ ধরম হড়কু আকিলতে রুয়াড় আউ/আগু কুয়ায়্য় য় প্রভু রাঃআ নাতিনাং মিয়াৎ নেক/কাবিল প্রজামন্ডলী তেয়ারাঃআকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ইন্তং সখরীয় নাঙ্গা কে গামকিয়ায় 'চিলকাতে ইঞ আটকার সারিনামিং ? চিয়াঃচি ইঞ হাড়ামা কানাঞ অটঃ ইঞ ঞ এরাঃআ রাঃআ হঅ গাদা উমুর হুয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","সরগ নাগা ইনিকে গাম রুয়াড় কিয়ায় ইঞ গ্যাব্রিয়েল ঈশ্বর রাঃআ সামাংরে তিনগুতাহিনাই আমলো থুতি নাতিনাং হেৎদ আমকে নিয়া বুগিন সংবাদ এম নাতিনাং কুল হুয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","হেৎদ নেলেম নিয়া যত অকা হুলাং হুইওয়া ইনা হুলাং যাকিৎ আম আউড়াগে তাহিনাম থুতি জাগার কাম দাড়িয়া চিয়াঃচি ইঞাঃ নিয়া যত জাগার গটা সময় পুরাঃআঃ ইনাকুতে আম কাম পাতিয়া ");
INSERT INTO cdz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","হেৎদ হড়কু যতচ পিন্ডগী রে সখরীয়রাঃআ তান্গিরে তাহীন কেনাকু হেৎদ জাহের স্থান রে আয়া ইন্তি ঘাড়ি দেরি নাতিনাং ইঙ্কূ হায়কাটেনাকু ");
INSERT INTO cdz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","হেৎদ আয় বাহারতে উডুং কাতেন আকুলঃঅ থুতি কা দাড়িলাঃআ য় এন্খান্গে আঙকু আটকার নাম কেৎয়াকু যাহের স্থান ভিতাররে ইনি যাহানা ভেট নামতাঃআয় মেন্খান ইনি ইঙ্কূকে একেনে নাআহানা উদু কেৎ কুয়ায়্য় য় হেৎদ ব্বা কাতে তাহিনায় ");
INSERT INTO cdz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","আয়া যাহের স্থান রাঃআ সেবা-কামি মুচাৎ এন খান ইনি আয়া অড়া সেঃএনায় ");
INSERT INTO cdz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ইনা তায়মত আয়া এরাঃআ ইলিশাবেত লা হিচ হাম্বালেনায় হেৎদ মড়ে বঙ্গা জকিৎ আয় আয়কে দানাং দঃহকিয়ায় গামকিইয়ায়্য় ");
INSERT INTO cdz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ইনা হুলাং ইঞ কে দায়া মেৎতে নেলকিঞয়াং মান্মি তালারে ইঞা গিউ অচগিডি নাতিনাং প্রভু ইঞলো নেকা বেবহার কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","চিন্তং ইলীশাবেৎ তুরুই বঙ্গা হর্ম হাম্বাল তাহীন কেনায় ইন্তং গ্যাব্রিয়েল সরগ নাগা কে ঈশ্বর গালিল দিসুমরাঃআ নাসরত নুতুমান শেহার তে মিয়াৎ ডান্গুয়া কুড়িহন রাঃআ হান্ডে কুল কিয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","অকয় দ দাউদ কূল রিনিজ জোসেফ নুতুমিজ হড়লো হরচিন হুয়াকানা ইনি ডান্গুয়া কুড়িহনরাঃআ নুতুম মরিয়ম ");
INSERT INTO cdz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","সরগ নাগা আয়া কাতাতে হিচ কাতে গামকিয়ায় এ দায়াতে পেরেজাকানিজ কুড়ি হন আমাঃ বুগিনা হুইওকা ধার্তি আপু আমলো মেনাইয়া ");
INSERT INTO cdz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","মেন্খান্দ ইনি ইনা জাগার আয়ুম কাতে কুঠিন গে বরঃ কিইয়ায়্য় অটঃ হুশরে দঃহ কিইয়ায়্য় নিয়া দ চিলকালেকা জোহার তানা ");
INSERT INTO cdz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","সরগ নাগা ইনিকে গামকিয়ায় মরিয়ম আলম বরয়া চিয়াঃচি আম ঈশ্বর রাঃআ হান্ডে হাতেন দায়া নামতাম ");
INSERT INTO cdz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","আর নেলেম আমাঃ লা হিচ হাম্বালোআ হেৎদ মিয়াৎ কড়া হনকে জনমিয়ায় হেৎদ ইনি রাঃআ নুতুম যীশু দঃহয়াম। ");
INSERT INTO cdz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ইনিদ মারাঃআং হড় হুইয়ায় অটঃ আয়কে আশু মাড়াং-মাপরাঃআং রাঃআ হন গামিয়াকু প্রভু ঈশ্বর আয়া আপু দাউদরাঃআ কূলান্ডূ আয়কে এমিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ইনি যাকোব কূল রাঃআ চেতানরে যুগ যুগ রাঃআজ ইয়ায় অটঃ আয়া রাঃআজ কা মুচাৎ দঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ইন্তং মরিয়ম সরগ নাগা কে গামকিয়ায় 'নিয়া চিলকালেকাতে হুইয়া ? চিয়া চি ইঞ মাত দাঁগুয়া কুড়ি হন ");
INSERT INTO cdz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","সরগ নাগা গাম রুয়াড় কিয়তে কুলি কিয়ায় রিলামালা আত্মা আয়া হান্ডে হিজু য়া হেৎদ আশু মাড়াং-মাপরাঃআং দাড়িতে উম্বুলমেয়ায় নিয়া খাতিরাঃআং অকয় রিলামালা তে জনমআয় ইনিকেগে ঈশ্বর রাঃআ রিলামালা হন মেতেন গামআয় ");
INSERT INTO cdz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","আর নেলেম আমাঃ গেয়াতি ইলিসাবেত ইনিহ বুঢিদিলাংরে কড়াহন হর্ম রে দঃহ লিয়ায় হড় ইনিকে আটকুড়া গামিকেনাকু নিয়া আয়া তুরুই বঙ্গা হর্ম হাম্বল মেনাইয়া ");
INSERT INTO cdz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","চিয়াঃচি ঈশ্বর রাঃআ হান্ডে কা হুই দাড়িয়া মেন্তে যাহানা বায়ায় না। ");
INSERT INTO cdz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ইন্তং মরিয়ম গাম্কিইয়ায়্য় নেলেপে ইঞ প্রভু রাঃআ দাসি/কার্মি তানাইঞ আমাঃ জাগার লেকাতেগে ইঞ ল নেকা হুইওকা হেৎদ সরগ নাগা আয়া হান্ডে হাতেন নিরেনায় ");
INSERT INTO cdz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ইনা হুলাং মরিয়ম উডুং বিরিৎ লেনায় হেৎদ যীহুদা মুলুক রাঃআ বুরু কাতা রে মেনা মিয়াৎ সরগ নাগার তে চিদগি সেএনায় ");
INSERT INTO cdz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","হেৎদ সখরীয়রাঃআ অড়া বলঃঅ কাতে এলিশাবেতকে জোহার কিয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","হেৎদ নেকাগে হুয়েনা চিনতং এলিশাবেত মরিয়মকে জোহার আয়ুম কিইয়ায়্য় ইন্তং আয়া কুথিরে/লা হিচ রে হনটা জেহেদ কিইয়ায়্য় হেৎদ এলিশাবেত রিলামাল রিলামালা আত্মা পেরেজেনায় ");
INSERT INTO cdz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","হেৎদ জোরতে কিকিচ কিইয়তে গামকিয়ায় কুড়িহনকুরাঃআ তালা হাতেন আম্গে ধন্য অটঃ ধন্য আমাঃ কুথিরাঃআ/লা হিচ রাঃআ জঃ ");
INSERT INTO cdz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ইঞ প্রভু রাঃআ মাইতেদ ইঞ আ হান্ডে হিজু আয় ইঞ আ নেকান ভাগ্যদ কদের হাতেন হুয়েনা ");
INSERT INTO cdz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","এতে নেলেম আমাঃ জোহার রাঃআ সাডি ইঞ আ লুতুররে বলঃঅ থরাঃআ হনটা ইঞ য়া কুথিরে কুশিতে জেহেদ কিইয়ায়্য় ");
INSERT INTO cdz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ধন্য গেয়ায় ইনি অকয়দ পাতিয়াওনায় চিয়াঃচি প্রভু রাঃআ হাতেন অকাগে ইনিকে গাম-সদর লিয়ায় ইনা যত পুরাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ইন্তং মরিয়ম গামকিইয়ায়্য় ইঞ আ আত্মাদ প্রভুকেইঞ মারাঃআঙয়ী তানা ");
INSERT INTO cdz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ইঞ আ জীউৎ ইঞ আ বানচাওউই ঈশ্বররেইঞ রাঃআসকা তানা। ");
INSERT INTO cdz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","চিয়াঃচি ইনি আয়া দাসীরাঃআ রেগেঞ্জ দশা নেলকিইয়ায়্য় আর নেলেম নিন তং যুগ যুগ ধাবিজ পিড়ি যতচ ইঞ কে ধন্য/ভরাঃআনিচকো গামিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","চিয়া চি ইনি সানাম দাড়িয়ান ইনি ইঞ নাতিনাং কামী কেৎ য়ায় হেতাত দ ইনি রাঃআ নুতুম রিলামালা ");
INSERT INTO cdz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","আর ইনি রাঃআ দায়া পিড়হি চেতান পিড়হি চেতান তাহিনায় অকয় আয়কে বরইআকু। ");
INSERT INTO cdz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ইনি দ আয়া তিহি তে দাড়িয়ান কামী কিইয়ায়্য় আর ইনিকে ছিতির-বিতির ছিন ছাতুর কেৎ কুয়ায়্য় য় অকা আকুয়াআ অন্তর ভীতির ভাবনাকুয়ে বাড়াই/অহং কার গরব তাহীনকেনা। ");
INSERT INTO cdz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ইনিদ আকুয়াই রাঃআজাকে কূলান্ডূ হাতেন নুর লাতার আড়গু তিয়ায় আর নিহাইত রাঃআকাব কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ইনিদ রেঙগেজ কুকে বুগিন বুগিন জিনিস/kateye বি তকাকুয়ায়্য় য়, আর কিসাড়কুকে দ একেন তিহি কুল-রুয়াড় কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ইনিদ আয়া গুতি/ দাস ইস্রাঃআয়েল ডেঙ্গা কেৎ কুয়ায়্য় য়, আর আবুয়াই হাপড়ামকু গম/গটাত লেকাতে। ");
INSERT INTO cdz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","আব্রহাম হেৎদ ইনি রাঃআ কুল নাতিনাং আয়া যায়-যুগ দায়াদুলাড় তে দিশাও কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","মরিয়ম দ ইলিসাবেদ লো অপি বঙ্গ হড়/খানে তাহি নায়, হেৎদ আয়া অড়াতে রুয়াড় সেঃএনায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","এলিশাবেত রাঃআ মাহা বঙ্গা সেটেররে না হেৎদ ইনি কড়াহন জনম কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ইন্তং আয়া ঠাইঞ রুঙকুকে হেৎদ পাহি কু আয়ুম নাম কেৎয়াকু যে, প্রভু আয়কে মারাঃআং দায়া এম তিয়ায়, হেৎদ ইঙ্কূ আয়লো রাঃআসকা য়েনা/ তাহিনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ইরিলিয়া মাহা হুলাং ইঙ্কূ দ হনটারাঃআ ত্বকছেদ মেতেয় হিচে নাকু, হেৎদ আয়া আপুতেত রাঃআ নুতুম তে আয়া নুতুম সখরিয় দঃহ নামেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","মেন্খান আয়া এঙ্গাতেত গাম রুয়াড় কিয়ায়, ইনা দ লহয়, ইনি রাঃআ নুতুম জোহন দঃহ হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ইন্তং ইঙ্কূ আয়কে কুলিকিয়াকু, আমাঃ গেয়াতি রে নিয়া নুতুম মা যাহায় রাঃআ বায়ায় না। ");
INSERT INTO cdz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","পরে ইঙ্কূ আয়া আপুকে ইশারাঃআ কাতেন কুলিকিয়া, আমকে নিইরাঃআ কিনা নুতুম দঃহ সানা তানামা। ");
INSERT INTO cdz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ইনি অল নাতিনাং মিয়াত পাটা/তক্তা আসি কেৎ কুয়ায়্য় য়, নিই রাঃআ নুতুম জোহন তানা, ইনাতে যতোই হড়কু হায়কাট চায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ইন্তং /তখুনি গে আয়া মচা হেৎদ আয়া আলাং লাড়ায় না, হেৎদ আয় থুতি দারিকিইয়ায়্য়, ঈশ্বর রাঃআ সারহা কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ইনাতে আসেপাসে রুঙকু যতচ হড় বরয় নাকু, হেৎদ যিহুদিয়া রাঃআ গটা বুরু দিসুমরে যতোয় মানমি নিয়া থুতিকু গামঃতানাকু। ");
INSERT INTO cdz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","হেৎদ চিনতি হড় আয়ুম কেৎয়াকু, যতোয় গে ইনাকু মনেরে (অন্তররে) জায়গা এম কাতেন গাম লাগায় নাকু' নিঃই হনটাদ চিল্কা হুয়ুয়ায় ? সারথি গে প্রভু রাঃআ তিহি দ ইনিলো মেনা। ");
INSERT INTO cdz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ইন্তং আয়া আপু সখরীয় রিলামাল রিলামালা আত্মা পেরেজ নায়, হেৎদ ভাবি -জাগার/ আয়ার-জাগার কিইয়ায়্য়, ইনি গাম কিইয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","প্রভু, ইস্রাঃআয়েল রিনিজ ঈশ্বরকেই সারহাও তানায়, ইনাতে ইনি আয়া হড়কুকে আরিজ/নেল তলাশ তাকুয়া, হেৎদ কিরিং ছাডা তাকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","হেৎদ আবুয়া নাতিনাং আয়া দাস/গুতি দাউদ রাঃআ কুলরে মিয়াত দাড়িয়ান বাবাঞ্চাও উডুং সদর রিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","এনে চিলকা ইনি মুসিং হাতেন আয়া রিলামাল আয়ার/ ভাবি-জাগারিই কুয়া মচাতে গাম আউ তায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","আবুয়া বাইরি কুয়া হাতেন অটঃ যাহায় আবুকে ঘিন/ ঘিনা বুয়াকু ইঙ্কূ যতচ কুয়া তিহি হাতেন বাঁনচাও বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","নেকাগে আবুয়া হাপড়াম কুকে দায়া একরাঃআর উদু তকাতা কুয়ায়্য় য়, হেৎদ আয়া রিলামাল একরাঃআরনামা/চুক্তি পাহাম দহ তায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","নিয়া ইনা এক্ড়ার কিইয়া, ইনা ইনি আবুয়া হাপড়াম আব্রাঃআহাম কুল রাঃআ হান্ডে শপথ লাআয়। ");
INSERT INTO cdz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","আবুকে নিয়া বর এম নাতিনাং, আর আবু দ বাইরি কুয়া তিহি হাতেন ছাডা বুয়ায়, কা বর কাতে আয়ায়্য় বু সেবা য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","রিলামাল তে অটঃ ধরমতে আয়া সেবায় আবু। আয়া সামাং রে আবু জিউত জীবন যাকিৎ সেবা য়া। ");
INSERT INTO cdz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","আর আম, এই হন, আম দ মারাঃআং-মাপরাঃআং রিনিজ ভাবি-জাগারিজ মেতে গাম ঘুরাঃআ মাকু, এনতে আম প্রভু রাঃআ সামাং রে মাড়াং তে সেনঃআম, ইনি রাঃআ নাতিনাং হরাঃআম তায়ার/ সাপড়াও আম। ");
INSERT INTO cdz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","হেৎদ ইনি আয়া হড়কুকে/প্রজাকুকে আকুয়াআ পাপ/কাই রাঃআ ক্ষমা/ইকা নাতিনাং বাঁনচাও আকেল নামে কাকু। ");
INSERT INTO cdz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ইনি আবুয়া ঈশ্বর দায়া অটঃ মায়াতে, ইনি দ চেতাং হাতেন বেলা রাঃআকাব মার্শাল তে ঝালকা/হিজু র বুয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","আর ইঙ্কূ যতচ কে মার্শাল কুয়ায়্য় য়, অকয় দ নুবারে হেৎদ গজঃ রাঃআ উম্বুল রেকু দুবা কানাকু, আবুয়া কাটা সুলুক রাঃআ হরাঃআতে সেনঃকায়। ");
INSERT INTO cdz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","হনটা হারাঃআ য়েনা হেৎদ রিলামালা আত্মা দাড়িয়েনা, হেৎদ চিমিন মাহা ইস্রাঃআয়েল রাঃআ হান্ডে আয় কা সদর নেনায়, ইমিন মাহা ধাবিজ খালি-পিড়িরে তাহিনেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ইনা অক্ত রোমীয় মারাং রাপাজ আগস্ত কৈসর রাঃআ হান্ডে হাতেন নিয়া হুকুম উডুনঙ্গেনা, গোটা ধারতি রেঙ্কূ মানমি নুতুম অলেকাঃআকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","সুরিয়া মুলুক রিনিজ পারহড় কুরিনীয় রাঃআ সময় মাড়াং নিয়া নুতুম অল হুয়েনা। ");
INSERT INTO cdz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","জতয়্গে নুতুম অল নাতিনাং আকুয়াআ আপান আপিন সরগ নাগারতে সেঃএনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","হেৎদ জোসেফ হঃঅ গালিলরাঃআ নাসরত সরগ নাগার হাতেন যিহুদিয়ারাঃআ বৈথলেহেম নুতুমান দাউদ রাঃআ সরগ নাগারতে সেঃএনায়, চিয়াচি ইনি দাউদরাঃআ কূল হেৎদ গুষ্টি জাইত তাহিকেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ইনি আয়া নেল দহ এরা মরিয়ম লঅ নুতুম অল নাতিনাং সেঃএনাকিন, ইন্তং ইনিদ পয়াতি তাহিন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ইঙ্কিন বেত্লেহেমরে সেটে রেন খান কিন ইনা যায়গারে,মরিয়ম রাঃআ লাহিচ হাসু এহ্তব এনা। ");
INSERT INTO cdz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","হেৎদ ইনি আয়া পুড়ুহা কড়াহনকে জনম কিয়ায়, হেৎদ ইনিকে কিচিতে পটম কাতেন তাড় ধামারে গিতিজ দহ কিয়ায়, চিয়াচি আকিনা নাতিনাং তাহীনরাঃআ জাহানা জায়গা কা তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ইনা টলা রে বাগালকু মাঠরে তাহীনকেনা, হেৎদ আয়ুব বাতিরাঃআং আকুয়াআ আকুয়াআ পাল হরঃ কেনাকুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","হেৎদ আচ্কাগে প্রভু রাঃআ মিয়াৎ সরগ নাগা আকুয়াআ কাতাতে হিচ সেটের কাতেন তিনগুইনায়, হেৎদ প্রভু রাঃআ তারাস আকুয়াআ চারুধার ঝালকায় নায়, ইনাতে আকু কুঠিনগেকু বরঃ কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ইন্তং সরগ নাগা ইঙ্কূ কে কুলিকেৎ কুয়ায়্য় য়, আলপে বরঃআ, চিয়াচি নেলেপে, ইঞ আপেকে আসু রাঃআসকারাঃআ বুগিন জাগার সারিতকা তানাপিং, ইনা রাঃআসকা যতচ মান্মি কুরাঃআ নাতিনাং হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","চিয়াঃচি তিহিং গে দাউদরাঃআ শেহার রাঃআ বেত্লেহেম রে বাঞ্চাও নি জনমাঃ কানায়, ইনিদ খ্রিষ্ট প্রভু। ");
INSERT INTO cdz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","হেৎদ আপেয়া নাতিনাং ইনাগে চিন্হা, আপে নেল নামেয়াপে, মিয়াৎ বালেজ হন কিচিতে পটম অটঃ তাড়-ধামারে গিতিজ মেনায়া। ");
INSERT INTO cdz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","হেৎদ আচ্কাগে ইনি সরগ নাগা লো গাদেল গাদেল সেরমা বাহিনী ঈশ্বর রাঃআ সারহা- দুরাঃআং তানাকু হেৎদ গামেতানাকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","চেতানরে ঈশ্বর রাঃআ মহিমা হুয়ুকা, অতে-দিশুমরে আয়া কুশিয়াতান হড়কুয়া হান্ডে সুলুক-রিয়া তাহীন কা। ");
INSERT INTO cdz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","সরগ নাগা কু আকুয়াআ হান্ডে হাতেন সেরমা-দিশুমতে সেনঃ কাতেন হেৎদ ভিডি গুপিকু নাআই হানীকে কুকলিতানাকু, চল আবু মিসা বেথলেহেম ধাবিজ সেন্লোকায়াবু, হেৎদ নিয়া ব্যাপার প্রভু আবুকে সারি তকাকেৎ বুয়ায়, ইনা সেনকাতেন নেললেয়াবু। ");
INSERT INTO cdz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","হেৎদ আকু তাড়াসতে তাড়মকাতেন মরিয়ম অটঃ জোসেফ হেৎদ ইনা যাবপাত্ররে গিতিজাকানায় বালেজ হনকে নেল নাম্কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","নেল কাতেন হনরাঃআ বেপারতে অকা থুনিয়া তি ইঙ্কূ কে গম হুইলেনা, ইনা গম সদর কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ইনাতে যাহানতি হড় ভিডি গুপিকুয়া মচা হাটেন নিয়া থুতি আয়ুম কেৎয়াকু, জতয়্গে নিয়া যত বাব্ত্তে তে হায়কাট চাকানাকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","মেন্খান্দ মরিয়ম ইনা যত থুতি অন্তর ভিতার আটকার কাতেন মনেরে রেবেত দহ কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","হেৎদ ভিডি গুপিকুকে চিল্কা গাম হুইলেনা, হন্কু এঙ্কাগে যতচ ই নেল-আয়ুম কাতেন ঈশ্বর রাঃআ সারহা হেৎদ দুরাঃআং-দুরাঃআংতে রুয়াড় হিচে নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","হেৎদ চিললং হনটারাঃআ নাতিনাং আঠ মাহা পুরাঃআয়নায়, ইন্তং ইনি রাঃআ যীশু নুতুম দহ হুয়েনায়, নিয়া নুতুম আয়া লালিজরে হাইরাঃআ মাড়াংতে সরগ নাগা দ্বারাঃআয়তে দঃহ হুইনেনা। ");
INSERT INTO cdz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","হেৎদ চিললং মোশিরাঃআ বেবস্থালেকাতে ইনিকে নারতা অড়া চাবায় না, ইন্তং ইঙ্কূ ইনিকে যীরুশালেমতে ইদি কাতেন, সেএনাকু, যাতে ইনিকে প্রভু রাঃআ কাতারে আগুইকায়। ");
INSERT INTO cdz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","চিল্কা প্রভু রাঃআ বেবস্থারে অল মেনা, যতচ পুড়ুহা কড়াহন জন্মকানাকু প্রভু নাতিনাং রিলামালা/রিলামাল নুতুমমেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","চিলকা প্রভু রাঃআ রি-চালিরে মেনা মিত জোড়া পুতাম হেৎদ মিত জোড়া পেরোয়া হন ");
INSERT INTO cdz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","হেৎদ নেলেম, সিমিয়ন নুতুমতে মিয়াত হড় যীরুশালেমরে তাহিন কেনায়, ইনি ধার্মিক/ ঈশ্বর বরঃ হেৎদ ভক্ত, ইস্রাঃআয়েল রাঃআ জিউ রাঃআরেজ নাতিনাং তাংগি তাহীন কেনায়, হেৎদ রিলামালা আত্মা ইনি রাঃআ চেতাংরে তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","আর রিলামাল আত্মা দ্বারাঃআয় তে আয় সদররে নায়, ইনি প্রভু মাসি/ খ্রিষ্ট কে আউরি নেল ধাবিজ কা গজ নেল আয়। ");
INSERT INTO cdz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ইনি ইনা রিলামালা আত্মা দ্বারাঃআয় জাহের স্থান তে হিচে নায়, হেৎদ হন যীশু রাঃআ মাই-বা ইন্তং আয়া আরি-চালি পুরাঃআও নাতিনাং আয়কে ভীতির তে হাম্বুদ আদের কিয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ইন্তং আয় ইনিকে কয়ংরে হাতাকিয়ায়, হেৎদ ঈশ্বরকে সারহা কিয়ায়, হেৎদ গামকিইয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","এ প্রভু নাহা দ আমাঃ জাগার লেকাতে আমাঃ মুনীস তাম শান্তিতে দিসুম হাতেৎ রাকাপ ইদিংমে। ");
INSERT INTO cdz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","চিয়াচি ইনআ মেত্কিন আমাঃ বাঞ্চাও নেল কেয়াকিন, ");
INSERT INTO cdz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","অকা আম যতোই হড়কু নাতিনাং তেয়ার দহ তাম, ");
INSERT INTO cdz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","এটা জাতই সদর আ নাতিনাং মিয়াত মার্শাল, আর আমাঃ হড়/ প্রজা ইস্রাঃআয়েলরাঃআ মহিমা গে হুয়ুকা। ");
INSERT INTO cdz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","হেৎদ ইনি রাঃআ মাইতেত অটঃ বাঃতেত হায়কাটা কানাকিং নিয়া নাতিনাং কিনা ইনি রাঃআ বাব্ত্তে তে গাম কেয়া কিন। ");
INSERT INTO cdz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","আর সিমিওন ইনকিন কে ভরাঃআয়েত কিনায়, হেৎদ ইনি রাঃআ মাইতেত মরিয়ম কে গামকিয়ায়, নেলেম, ইনি ইস্রাঃআয়েল রাঃআ ঢের লেকা হড়কুকে ভিংড়া অটঃ বিরিৎ রাঃআকাব কুয়ায়্য় য়, হেৎদ ইনিদ মিয়াত চিন্হা হুয়ুয়া অকয় বিরূধ রেকু গামেয়া। জিসাই 8:14 -15 ");
INSERT INTO cdz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","আর খড়গ/তারওয়ারী আমাঃ অন্তররে যত তাব তাম ইনাতে গাদালেকা কুরাঃআ অন্তর রাঃআ হুদিস সদর কা ");
INSERT INTO cdz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","আসের কূল রিনিজ পনুয়েলেরাঃআ হনরাঃআতেত হান্না নুতুমতে মিহুড় ভাবি-জাগারিজ কুড়ি হন তাহিলেনায় ইনি রাঃআ গাদা বয়স হুয়লেনা (বুডিয়া কানায় গঙঅ রাঃআ তায়ম একেন এয়াই সির্মাং হাড়াম তেত/জামাইতেত তাহীন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ইনিদ উপুন ইসি উপুন সির্মাং -ধাবিজ রাঃআন্ডিতে কাতেন তাহিনা কানায় আর জাহের স্থান হাতেন কা অচ গিডি কাতেন /লেনায় সিঙ্গি-নিদা উপোশ/বার কয় জং/আরাঃআজ কাতে সেবা য়েতকেনায় ");
INSERT INTO cdz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ইনিদ ইনা ঘাড়িগে হিজু কানায় আর প্রভুকে সারহা কিয়ায়/তানাই অটঃ যীরুশালেম রে ছাডাও নেল হরতানায় যত হড় কে যীশুরাঃআ থুতি গামলাগায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","প্রভু রাঃআ চালি লেকাতে যত কামী পুরাঃআও চাবানতে ইঙ্কূ গালিলরে আকুয়াআ শেহার নাসরততে রুয়াড় ইমাহা াকু ");
INSERT INTO cdz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","পরে বালক যীশু হারাঃআ বুরুইনায় আর দাড়িতে পেরেজে নায় আর আকিলতে পেরেজ তাহিনায় অটঃ ঈশ্বর রাঃআ দায়া আয়া চেতান তাহি মেনা ");
INSERT INTO cdz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","আয়া এঙ্গা আপুতেত তিকিন হার সির্মাং সেনঃ পারম/সাক্রাত পরবরে যীরুশালেম সেনে নাকিন। ");
INSERT INTO cdz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ইনারাঃআ গেল বার সির্মাং হুইলেখান ইঙ্কিন পরবরাঃআ চালি লেকা যীরুশালেমতে সেএ নাকিন ");
INSERT INTO cdz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","পরব চাবান তে অড়া রুয়াড় কেনা/কেন কিন এন্খান হন যীশু যীরুশালেমরে তাহিনায় মেন্খান আয়া মাই-বা তেত তিকিন কাকিন সারিয়া ");
INSERT INTO cdz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ইনিদ আকুয়াআ যাত্রীকুয়া মিসাতে/সঙ্গেতে মেনায়া হেৎদ মিত মাহা হরাঃআকিন সেনে নাকিন পর গেয়াতি/পাহি অটঃ চিনা হড়কুয়া তালারে ইনি পানতি তে কাকিন নাম্কিয়া আর ইঙ্কিন দ যীরুশালেমতে রুয়াড় সেএ নাকিন। ");
INSERT INTO cdz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","হেদ তে আয়কে কা পানতি নামতে পাঞ্জা নাতিনাং যীরুশালেম সেএ নাকিন ");
INSERT INTO cdz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","আপি মাহা তাড়ম হরা তায়্ম ইঙ্কিন আয়কে জাহের স্থান রে নামকিয়াকিন ইনিদ শাশতর পন্ডিতকুয়া তালারে দুপ কাতেন ইঙ্কূ য়া থুতি আয়ুমে কেনায় হেৎদ ইঙ্কূ কে কুকলি কুলি কেনা কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","আর যাহায় আয়া থুতি আয়ুমে কেনাকু যতচ ইঙ্কূ আয়া আকিল অটঃ গাম রুয়াড় এতে ঠাক হায়কাট এ চায়নাকু ");
INSERT INTO cdz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ইনিকে নেল কাতে আকুগে হাহাড়ায়েনাকু হেৎদ আয়া মাইতেত ইনিকে গামকিয়ায় এ বাবু আম আলিং ল নেকান চিয়া বেবহার কেয়াম ? নেলেম আমাঃ বা তামা অটঃ ইঞ ভাবনাতেলিং পানতি কেনা মিয়ালিং ");
INSERT INTO cdz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ইন্তং আকিনকে গম রুয়াড় কেৎ কিনায় চিয়াঃ আবিন ইঞ কে পাঞ্জা তানা বেন আবেন চি কবেন সারিয়া ইঞ কে আপুং রা আ অরারে তাহিহুয়য়া নিয়া চি কাবেন সারিয়া ");
INSERT INTO cdz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ইনি আকিনকে অকা থুতি গাম কেৎ কিনায় ইনা একিন কাকিন আটকার দাড়িলায় ");
INSERT INTO cdz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","হেত তে আকিনলো আড়গু কাতেন নাসরত সরগ নাগার তে অটঃ সেএ নাকিন/নাকু অটঃ আকিনা হাতলারে তাহিনায় আয়া মাইতেত যত থুতি আয়া অন্তররে দহঃ কিইয়ায়্য় ");
INSERT INTO cdz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","পরে যীশু আকিলতে আর হড়মো তে হারাঃআ ইমাহা ায় আর ঈশ্বর হেৎদ মানমি কুরাঃআ কাতারে দায়াতে রাঃআকাব ইমাহা ায় ");
INSERT INTO cdz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","শাসক তিবরিয় কৈসর রাঃআ রাঃআজ বিদাল রাঃআ মড়ে সির্মাং রে রোম পন্তীয় পিলাত যিহুদিয়া দিসুম রিনিজ কোটাল তাহীনকেনায় হেরোদ এন্তিপাস দ গালিলীয় রে কোটাল ইনি রাঃআ বকঃতেত ফিলিপ যিতুরিয়া হেৎদ ত্রাঃআখোনীতিয়া ডিহি রিনিজ কোটাল লুসানীয় দ অবিলিনিয় রে কোটাল তাহিনকেনায় ");
INSERT INTO cdz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ইন্তং হানন হেৎদ কায়াফার মারাঃআং বামড়েকিন তাহী কালীন হাহানকাররে/প্রাঃআন্তর প্রভু রাঃআই জাগার সখরিয়রাঃআ হন জোহন রাঃআ হান্ডে হিচে না ");
INSERT INTO cdz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ইনাতে ইনি যর্দন রাঃআ গোটা ডিহিরে দাড়ান কাতে ছেমা নাতিনাং মন রুয়াড় নাতিনাং ডুবুল বাবদতে ঢানঢারাঃআ লাগায়নায় ");
INSERT INTO cdz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","চিল্কা যিশাইয় ভাবি-জাগারিজরাঃআ পুথিরে অলমেনা ঢাহিরে মিহুড় হড় রাঃআ সাডি/আড়াঙ ইনি রাঃআ তান কুয়ায়্য় য় আপে দ প্রভু রাঃআ নাতিনাং হরা বাইয়ে পে ইনি রাঃআ রাঃআজ হরাঃআকু সজেহে পে ");
INSERT INTO cdz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","যত বুরু নালা দ ভরাঃআ চা/দাবদাবাও আর যত বুরু-ডাহি/ধাসনা দ চপদঃ কা অকা অকা বেংকো/তেড়হা ইনা যত সঝে/সজে হুইয়া ");
INSERT INTO cdz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","আর যত মানমি জাইত রেঙ্কূ দ ঈশ্বর রাঃআ বাবানচাও কো/বানচাওকো নেলেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","হেৎদ চিনতি হড় যোহন রাঃআ হান্ডে ডুবুল নাতিনাং বাহারতে উডুংএ-নাকু ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় হে বিষ বিং রেঙ্কূ কূল হিজু তান পরমেশ্বর রাঃআ রাঃআগ হাতেন নিরজমদ অকয় চেত এমকেৎ মেয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","এন্খান মন পাল্টারুয়াড় রাঃআ হক কামিকু কামিপে হেৎদ মনে রে নিয়া দ আলপে গামেয়া আব্রাঃআহাম দ আবুয়া আপু তানায় মেন্তে চিয়াচি ইঞ আপেকে গামাপে তানা ইঞ ঈশ্বর নিয়া দিরহি হাতেন আব্রাঃআহাম নাতিনাং হন কু জানাম হ দাড়িয়াকুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","নিনতং যত দারু বুটারে হাকে দ লাগা/চটা দঃহ আকানা অকা দারুরে জ কা সাবআ ইনাদ মাঃআ খানডিচ কাতেন সেঙ্গেলরে তিঞেইয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ইন্তং হড়কু ডুবাল এমিচ যাহান কে কুলিকিয়াকু 'এন্খান নাহা আবুকে কিনা চিকাহুইয়া? ");
INSERT INTO cdz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ইনি ইঙ্কূকে তেলা রুয়াড় কেৎ কুয়ায়্য় য় যাহায় রাঃআ বারিয়া সনঃঅ মেনা ইনি যাহায় রাঃআ বায়ায় না ইনিকে মিয়াত এমিকায় হেৎদ যাহায় রাঃআ হান্ডে জম-মা মেনাতেয়া ইনি-হ এনকাগে করাঃআয় কায় ");
INSERT INTO cdz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","খাজনা উসুল হড়-কুহ ডুবুল-লো নাতিনাং হিচে নাকু হেৎদ গাম কিয়াকু গমকে আলেদ কিনা চিকায়ালে ");
INSERT INTO cdz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় আপেয়া নাতিনাং চিন্তিৎ খাজনা গটা/আদায়রাঃআ আদেশ/হুকুম হুইয়াকানা বাড়তি আলপে উসুল লেয়া/আদায়এয়া ");
INSERT INTO cdz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","অটঃ পালটন কুহ ইনিকে কুলিকিয়াকু আলেকে অটঃ কিনা চিকাহুয়ুয়া? ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় যাহায় রাঃআ হান্ডে হাতেৎ জোর-জবরদস্তি কাতেন কাউদী আলপে হাতায়া অটঃ আউরি তে যাহায় কে আলপে বিন দোষতে দোশি কুয়া আর আপেয়া মজুরিতে খুশি তাহিনপে ");
INSERT INTO cdz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","হড়কু দ নেল হরঃরে তাহীনকেনাকু আর যতচ গে আকু আকুয়াআ মনেরে যোহন রাঃআ বাব্ত্তে তে কুকলি তানাকু অকয় সারিয়ায় নিঃই কি ইনি মাসি লহয় তানায় ");
INSERT INTO cdz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ইন্তং যোহন যতচ কে গাম রুয়াড় কেৎ কুয়ায়্য় য় ইঞ আপেকে দাঃ রে ডুবুল তানাপিং হে মেন্খান এনকান মিহুড় হিজুতানায় ইনিদ ইঞ হাতেন দাড়িয়ান গেয়া ইঞ ইনি রাঃআ মুনিস যোগ নাই তানা ইনি রাঃআ খড়ম-বায়র লাড়া রাঃআ লেক হঅ লহয় তানায় ইনি আপেকে রিলামালা আত্মা হেৎদ সেঙ্গেল তে ডুবুল পেয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ইনিরাআ হাটা আয়িজ তিহিরে মেনা ইনি আয়া খামার বেশ ঠিকার সাপায়ে আয় হেৎদ গহম আয়া গোলা/খামার অড়া রে দঃহ আরজা আয়ায়্য় মেন্খান পেটেজ দ বিন ইরিজঅ সেঙ্গেলরে রাঃআপা গিডি আয় ");
INSERT INTO cdz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","অটঃ গাদালেকা শিখাও/উপদেশ এম কেৎ কুয়ায়্য় য় যোহন হড় কুরাঃআ হান্ডে বুগিন সংবাদ গাম সারি য়েত কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","মেন্খান হেরদ রাঃআজা কে যোহন ডুবানিজ এগের/নিন্দা কিৎআয়্য় চিয়াচি ইনি আয়া দাতেৎ রাঃআ এরাঃআ/বাহু হেরদিয়া কে দহলিয়ায় অটঃ আয় এটা ঢের বারিজ কু কামী লাৎআয়্য় ");
INSERT INTO cdz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ইনাতে ইনি যোহন কে কায়দ অড়ারে খড়া-হান্ডেত দহকিৎআয়্য়কু ");
INSERT INTO cdz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","হেৎদ নেকা হুয়েনা যতচ ডুবুল কাতে তাহিনাকু ইন্তং যীশু হ ডুবুল-এনায় আর কয়-জংএ কেনায় ইন্তং গে সেরমা নিজঃএনা ");
INSERT INTO cdz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","আর রিলামাল আত্মা হড়মোরাঃআ রূপতে পেরোয়ারাঃআ লেকা আয়া চেতান আড়গু হিচে নায় আর নিয়া আড়াঙ/সাডি সেরমা হাতেন আয়ুমেনা আম দম ইঞা দুলাড়িয়া/কুশিয়াইত হন তানাম ইঞ দ আমকেগে কুশিয়াকানাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","চিন্তং ইনি কামি এহব কেৎআয়্য় ইন্তং যীশু আপি গেল সির্মাং /ত্রিশ বছর বয়স হড় লেকা তাহীন কেনায় ইনি দ হড়কুয়া বুঝানলেকা তে জোসেফ রাঃআ হন তানায় জোসেফ দ হেলি রাঃআ হেলি দ মত্ততে রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","মত্ততে দ লেবি রাঃআ লেবি দ মল্কি রাঃআ মল্কি দ যান্না রাঃআ যান্না দ জোসেফ রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","জোসেফ দ মত্তথিয় রাঃআ মত্তথিয় দ আমোস রাঃআ আমোস দ নহিম রাঃআ নহিম দ ইষলি রাঃআ ইষলি দ নগি রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","নগি দ মাট রাঃআ মাট দ মত্তথিয় রাঃআ মত্তথীয় দ শিমিয়ীর রাঃআ শিমিয়ীর দ জোসেফ রাঃআ জোসেফ দ যুদা রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","যুদা দ যোহন রাঃআ যোহন দ রিসা রাঃআ রিশা দ সরুব্বাবিলের রাঃআ সরুব্বাবিল দ শল্টিয় রাঃআ শল্টিয় দ নেরি রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","নেরি দ মল্কি রাঃআ মল্কি দ অদ্দি রাঃআ অদ্দি দ কোশম রাঃআ কোশম দ ইলমাদম রাঃআ ইলমাদম দ এর রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","এর দ যীশু রাঃআ যীশু দ এলিয়েষর রাঃআ এলিয়েষর দ যোরিম রাঃআ যোরিম দ মত্ততে রাঃআমত্ততে দ লেবি রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","লেবি দ সিমীয়ন রাঃআ সিমীয়ন দ যুদা রাঃআ যুদা দ জোসেফ রাঃআ জোসেফ দ যোনম রাঃআ যোনম দ ইলিয়াকিম রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ইলিয়াকিম দ মিন্না রাঃআ মিন্না দ মত্তথর রাঃআ মত্তথর দ নাথন রাঃআ নাথন দ দায়ূদ রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","দায়ূদ দ যিশয় রাঃআ যিশয় ওবেদ রাঃsআ ওবেদ দ বোয়স রাঃআ বোয়স দ সলমন রাঃআ, সলমন দ নহসন রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","নহসন দ আম্মিনাদব রাঃআ, আম্মিনাদব দ অদমান রাঃআ, অদমান দ অর্নি রাঃআ, অর্নি দ হেস্রণ রাঃআ, হেস্রণ দ পেরেস রাঃআ, পেরেস দ যীহুদা রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","যীহুদা দ যাকোব রাঃআ, যাকোব দ ইসহাক রাঃআ, ইসহাক দ অব্রাঃআহাম রাঃআ, অব্রাঃআহাম দ তেরূহ রাঃআ, তেরূহ দ নাহোর রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","নাহোর দ সরূগ রাঃআ, সরূগ দ পেলগে রাঃআ, পেলগে দ এবর রাঃআ, এবর দ সেলহ রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","সেলহ দ কৈনন রাঃআ, কৈনন দ অর্ফকষদ রাঃআ, অর্ফকষদ দ শেম রাঃআ, শেম দ নোহ রাঃআ, নোহ দ লেমক রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","লেমক দ মথুশেলহ রাঃআ, মথুশেলহ দ হনোক রাঃআ, হনোক দ যেরদ রাঃআ, যেরদ দ মহললেল রাঃআ, মহললেল দ কৈনন রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","কৈনন ইনোশ রাঃআ, ইনোশ দ শেথ রাঃআ, শেথ দ আদম রাঃআ, আদম দ ঈশ্বর রাঃআ হন তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","যীশু রিলামালা আত্মাতে ভর কাতে যর্দন হাতেন রুয়াড়য়েনায়, হেৎদ পুলি মাহা ধাবিজ ইনি রিলামালা আত্মা ভর কাতে ঢাহী কুরে ঘুরাঃআ ইদি নায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","আর শয়তান রাঃআ হান্ডে বিডাও নায়। ইন্তি পুলি মাহা ইনি যাহানা কা জম কিইয়ায়্য় হেৎদ ইনা পুলি মাহাকু চাবান তে, যীশু কে রেঙ্গেজ কিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ইন্তং শয়তান যীশু কে গাম কিয়ায়, আম দ ঈশ্বর রাঃআ হন খান, তবেদ নিয়া ধীরি কে গামাইমে, যাহাতে ইনা পিঠা হুয়ুকা। ");
INSERT INTO cdz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","যীশু ইনিকে গাম রুয়াড় কিয়ায়, শাস্ত্র রে অল মেনা, মান্মি একেন পিঠা জম কাতে দ জীউৎ কাকু তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ইনা তায়্ম শয়তানদ যীশু লঃঅ সাল্গী থানতে রাঃআকাব ইদি নাকিন হেৎদ মিৎ মেৎ রিপিৎ তে ইনি ধারতি রাঃআ যত রাঃআজ্য উদুকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","শয়তান ইনিকে গামকিয়ায়, ইন আমকে নিয়াকু যত কুরাঃআ ইদারি হেৎদ পরতাপ/সাবাসিঙ এমামাইঞ নিয়া দ এতে ইঞ আ হান্ডে আরাঃআজ জিমাও দঃহ হাকানা, আর ইঞ যাহায় কেইঞ কুশিয়াআ, ইনিকেগে এমাআইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ইনা ইয়াতে যুদি আম ইঞ এ অম্বা কাতে বঙ্গা-ই আম, নিয়া যত দ আমাগে হুযুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","মেন্খান যীশু দ গাম রুয়াড় কিইয়ায়্য়, শাস্ত্ররে অলা কানা, প্রভু আমাঃ ঈশ্বর বঙ্গা-ই মে আর একেন/এসকারগে ইনিকেগে সেবাই মে। ");
INSERT INTO cdz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ইনা তায়ম শয়তান ইনিকে যীরুশালেম তে ইদি কিইয়ায়্য়, আর জাহের স্থান রাঃআ বুরু টুই রে তিনগু কিইয়ায়্য় হেৎদ গামা কিইয়ায়্য়, যুদি আম ঈশ্বর রাঃআ হন তানাম তবেখান নেডে হাতেন মা জেহেদ গৎদেম। ");
INSERT INTO cdz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","চিয়াচি নেকা শাস্ত্র রে অলাকানা, ইনি দ আয়াঃআ সরগ নাগাকুকে আম বাবদতে হুকুমা কুয়ায়্য় য়, চিল্কা ইঙ্কূ দ আমকে রুখিয়ামাকু, ");
INSERT INTO cdz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","যাতে আমাঃ কাটা ধীরি রে আল টঅ নাতিনাং, ইঙ্কূ দ আমকে তিহিতে শিপিং দহ মেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","মেন্খান যীশু দ ইনিকে গাম রুয়াড় কিইয়ায়্য়, শাস্ত্র রে অল দহ হুইয়াকানা, প্রভু আমাঃ ঈশ্বরকে আলম বিডাইয়া। ");
INSERT INTO cdz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","হেৎদ যত লেকানা আ বিডাও চাবা এন খান বঙ্গা সুযোগ রাঃআ তাঁড়াঃরে তাহিইন্তে ইনিকে ইনা ঘাড়ি বাগি তুকা কাতেন নির জমে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ইন্তং যীশু রিলামালা আত্মা দাড়িয়ানতে গালিলরে রুয়াড় এনায়, হেৎদ ইনি রাঃআ নুতুম গোটা দিশুমরে পাসরাঃআয় না। ");
INSERT INTO cdz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ইনি ইঙ্কূ য়া সমাজ আখড়া কুরে গাম চেঠাও শিখাঃন এমকেৎ কুকেনায় হেৎদ আর ইনি দ যতচ হড়কুয়া হাতেন সাবাসি নামেত কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","আর ইনি আয়া আসুল হারাঃআলেনায় নাসরত রে হিচে নায় হেৎদ আয়া আরি-চালি লেকা, আঠআর/ঝিরাঃআ মাহা হুলাং পাড়হা/সমাজ-অড়া বলঃ কাতেন, পড়হা লাগায় নায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ইন্তং যিশাইয় ভাবি-জাগারিজ কুড়াপুথি আয়া তিহিরে দঃহ কেৎয়াকু, হেৎদ ইনি কুড়াপুথি অটা কেৎ খানয়, কদেরে নিয়া অলাকান তাহিয়াকানা, ইনা নাম কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"প্রভু রাঃআ ত্মা দ ইঞ আ হান্ডে মেনা, ইঞ কে অজঃ তিঙয়াকু, ইনি ইঞ কে কুল কিয়াঞ, রেঙ্গেজ হরকুকে দ বুগিন সংবাদ জাহিরাঃআকুম/আগু সেটের তকাকুম, কায়দী কুকে দ ছাডা নাতিনাং গাম সাডিকুম, আর কাড়া কুকে দ নামা মেত নেঃ নেল নাতিনাং, আকাংকয়াং কুকে দ রাঃআরাঃআন/আড়াকুম। ");
INSERT INTO cdz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","হেৎদ প্রভু রাঃআ কুশিয়া তান/কান সির্মাং গাম সাডিকুম। ");
INSERT INTO cdz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ইনাকুতে ইনি কুড়া পুথি গুটিয়া কিইয়ায়্য় হেৎদ চালাইচ রাঃআ তিহিরে দঃহ কাতে দুবেনায়, ইনাতে সমাজ-অড়া রে তাহিন কানা যতচ হড়কু রাঃআ মেত ইনি রাঃআ চেতান অরিত দহ কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","হেৎদ ইনি ইঙ্কূ কে গাম এতেঃ কেৎ কুয়ায়্য় য়, তিহিং নিয়া শাস্তর জাগার দ আপেপে আয়ুম কাতে গে পুরাঃআয় না। ");
INSERT INTO cdz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","হেৎদ যতচ হড়কু ইনিকে বেস গাম কিয়াকু, হেৎদ ইনি রাঃআ মচা হাতেন উদুঙ সিবিল জাগার তেকু হায়কাট নাকু \"কিনা নি দ জোসেফ রাঃআ হন লহয় তানা? ");
INSERT INTO cdz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","মেন্খান ইনি ইঙ্কূ কে গাম রুয়াড় কেৎ কুয়ায়্য় য়, ইঞ সারিআইঞ আপে ইঞ কে নিয়া আরাঃআ-উরু থুতি গামিয়াপে, রাঃআনুনি, আম আম্তেগে বেশ বুগি মে, কফরনাহুম রে অকা অকা করাঃআ হুইলেনা আয়ুমতাম, নেন্ডে আমাঃ দিশুম নাজারেত রে ইনা কু করাঃআম। ");
INSERT INTO cdz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ইনি অটঃ হ গাম ইদিকিইয়ায়্য়, ইঞ আপেকে সার্তি গাম তানাপিঞ, যাহানি/অকয় ভাবি-জাগারিজ আয়া দিশুম রে দ কাকু তেলাও কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","হেৎদ ইঞ আপেকে সারতি গাম তানাপিং, এলীয় রাঃআ সময়/বিদাল রে আপি সির্মাং তুরুই বঙ্গা ধাবিজ সেরমা হারুব/হান্ডেত তাহীনকেনা হেৎদ গোটা দিশুমরে মারাঃআং আকাল পারমসেন লেনা, ইন্তং ইস্রাঃআয়েল রে ঢের উতার রাঃআন্ডি কু তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","মেন্খান এলীয় জিহাদী মুলুক ল্হয় সীদোন দিশুম রাঃআ সারিফ তে মিয়াত রাঃআন্ডি কুড়িহন রাঃআ হান্ডে ছাডা/বেগর অটঃ যাহায় রাঃআ হান্ডে কা সেন লেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","হেৎদ ইলিশায় ভাবি-জাগারিজ রাঃআ সময়/বিদাল রে, ইস্রাঃআয়েল রে ঢের লেকা সুদ/বেরেল সুদ/কুষ্ঠি হড়কু তাহিলেনা, মেখান সুরীয় দিশুমরে নামান ছাডা/বেগর ইঙ্কূ অকয় হ সাপা কাকু তাহিলেনা। ");
INSERT INTO cdz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","নিয়া থুতি কুএ আয়ুম কাতে সমাজ-অড়া রে তাহিন কানিজ হড়কু যতচ রাঃআগে না। ");
INSERT INTO cdz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","হেৎদ বিরিৎ কাতে, ইঙ্কূ দ ইনিকে নাগর বাহারতেকু গহাড় উডুং কিয়াকু হেৎদ বুরু দাড়ান কু ইদিকিয়া, ইনা চেতান রেদ আকুয়াআ নাগর বেনা দঃহ লাকু, হেৎদ ইনিকে এন্ডে হাতেন ঠেলা নুর কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","মেন্খান ইনি দ ইঙ্কূয়া তালা মাগা হাতেন ভুরুক পারমেনায় আর আয়া হরাঃআতে সেন ইমাহা ায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ইনি দ গালিল রাঃআ কফরনাহুম সরগ নাগার লাতার তে আড়গু হিচে নায়, হেৎদ ঝিরাঃআ আঠওয়ার মাহারে চেদ কেন কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ইনি রাঃআ চেচেতকাতে হড়কু দ কুঠিন গেকু হায়কাট এনা, চিয়াটতচি ইনি রাঃআ জাগার রে ঢের পরতাপ তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ইন্তং ইনা সমাজ-অড়া রে মিহুড় হড় তাহীন কেনায়, ইনিকে বে সাপা বঙ্গা রাঃআ ত্মা নামলিয়ায়। ইনি কুঠিন জোর তে কিকিচ কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","এহে! আলে লো আমাঃ দ কিনা, এ নাসরত রিনিজ যীশু? চিয়া আলেকে নষ্ট/ লন্ড-ভন্ড নাতিনাং হিজু কানাম? ইঞ দইঞ সারিয়া, আম দম অকয় তানা, ঈশ্বর রাঃআ রিলামাল হড় তানাম। ");
INSERT INTO cdz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","মেন্খান ইনিদ হকরা কিয়ায় হেৎদ গামকিয়ায়, থির র মে আর ইনি রাঃআ হান্ডে হাতেন উডুং -অ মে! বঙ্গা দ যতোয় রাঃআ সামাং রে ইনি হড় অতেরে তাবা ভিনদাড় কিয়ায় আর জাহানা কা চিকাকাতে ইনি রাঃআ হান্ডে হাতেন উদুঙ-এ নায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","যত হড়কু চমকায় নাকু হেৎদ আকু আকু গে/ নাআই-আনীকে কুকলি তানা কু, নাআ/নিয়া চিল্কান থুতি! নিই দ বে-সাফা বঙ্গা আইদাড়ি অটঃ পরতাপ তে হুকুম মা তানা কুয়ায়্য় য় হেৎদ ইঙ্কূ দুকু উদুঙ অ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","আর বাহার/বিউর গোটা জায়গা কুরে ইনি রাঃআ নিতির দ/নুতুম দ দাবদাবাও না। ");
INSERT INTO cdz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","তায়্ম হুলাং সমাজ-অড়া হাতেন উডুং কাতেন ইনিদ শিমোন তুকুয়া অড়ারে বলয়ে নায়। শিমোন হানারতেত দ কুঠিন রুআ তে যারাঃআয় তাহেন কেনায়, হেৎদ ইনি রাঃআ নাতিনাং জাহানাগে চিকায় কা নাতিনাং আরজি কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ইন্তং ইনি/যীশু ইনি রাঃআ রেনঢেত/কাতারে/হেদেরে তিঙ্গুইনায়, রুআ কে ধমকাঃআ কিয়ায় আর ইনাতে ইনি রাঃআ রুআ ছাডায়/চাবায় না, হেৎদ ইনি চিদগি বিরিজ কাতে ইঙ্কূ সেবা/তলাশ খাতির এহব/এটেঃজ নায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","বেড়া হাসুর অক্ত/সময়, নাআ-হানা রোগতে কাহিল কানাকু হড়কু, যতচ ইনি রাঃআ হান্ডে কু আগু তকা/কেৎ কেনায় কু, হেৎদ ইনি দ মিহুড়-মিহুড়/মিমেত-মিমেত চাপুকেৎ কুয়ায়্য় য় আর বুগি কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","বঙ্গা কু হ ঢেরলেকা হড় কুয়া হান্ডে হাতেন উডুং য়ে নাকু আর জোর তে কিকিচ কাতেন, আম দম ঈশ্বর রাঃআ হন তানাম। মেন্খান ইনিদ ধমকাঃআ কেৎ কুয়ায়্য় য় আর কা গাম/থুতি তকা কেৎ /লেত কুয়ায়্য় য়, চিয়াচি ইঙ্কূ দ সারিয়া কু, নিই দ ইনি মাসিহ তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","সেতাঃয় এন্খান যীশু দ অড়া হাতেন উডুং এ নায় আর নিঝুম জায়গা তে সেনে নায়, গাদালেকা হড় ইনিকে পানতি পানতি তে সেন তিউ কিয়াকু আর আকুয়াআ ঠাইন হাতেন আল সেন কায় নাতিনাং কয়-আরজি কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","মেন্খান ইনি দ গামাৎ কুয়ায়্য় , ইঞ দ ঈশ্বর রাঃআ রাঃআজ রাঃআ বুগিন সংবাদএটা সরগ নাগার কুরে হঅ পরচার হুয়ু তিনআ, ইনাতে ইঞ দ নিয়া নাতিনাং কুল হুয়ুআকানা। ");
INSERT INTO cdz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","হেৎদ ইনি দ যিহুদিয়া রাঃআ সমাজ-অড়া কুরে পরচার ইদি কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","মিত মাহা হুলাং হড় কু আয়ায়্য় কাতা কাতাতে গাদা ঘেসা ঘেসি কাতে ঈশ্বর রাঃআ জাগার কু আয়ুমেৎ কেনা, ইন্তং ইনিদ গিনেষরত ঝিল্লি রাঃআ পাড় রে তিঙ্গু তাহিলেনায়, ");
INSERT INTO cdz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","হেৎদ ইনি ঝিল্লি রাঃআ কাতা রে বারিয়া ড ঙ্গা তিঙ্গুয়াকানা নেল নাম কেৎআয়্য়, মেন্খান হাকু সাসাব হড়/জালিয়া কুঙ্গা হাতেন আড়গু কাতেন জালকু চাপিই কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ইনাতে ইনি ইনা বারিয়া লাউকা রাঃআ মিয়াত রে দেচ কাতে, ইনাটা দ শিমোন রাঃআ তাহীনকেনা, ইনা দ আড়ি হাতেন হুডাং ফারাঃআক নহ সেনঃ নাতিনাং গামকিয়া হেৎদ ইনিদ লাউকা রে দুব কাতে, গাদালেকা হড়কুকে উপমা গাম চেঠাও কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ইনি দ থুতি-জাগার মুচাৎ কাতে, শিমোন কে গাম কিয়ায়, লাউকা দ গাহির দাঃআ দর ইদি কাতে হাকু সাব নাতিরাঃআঙ জাল হুল্লায় পে। ");
INSERT INTO cdz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","শিমোন গাম রুয়াড় কিইয়ায়্য়, এ গ্সায়, গোটা নিদালে খাটাও নালে মেন্খান জাহানা হঅ কালে সাব নাম দাড়ি তাত কুয়া। নাহাহঅ অটঃ আম গামতে/কথাতে ইঞ জাল গিডিয়া আইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","হেৎদ ইঙ্কূ এনকা কেয়া কু খানঃ ইন্তি লেকা/যুকুর হাকুকু ঝালি কেৎ কেৎয়াকু, এতে/এন্তে জাল দ অরেজ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ইনাতে এটা লাউকা রেন্কু তাহীনকানা গাতি হড় কুকে ইশারাঃআ/হিচ্রাঃআ কেৎ কেৎয়াকু, যাহাতে হিচ কাতে দেংগা কেকা কু। ইঙ্কূ কু হিচে না আর বানার লাউকারে ইন্তি লেকা দহ পেরেজ কেৎয়াকু, ইনা লাউকা কিন হঅ ডুবুইজ লাগায় নায়। ");
INSERT INTO cdz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","শিমোন পিতর নিয়া নেল কাতে, যীশু রাঃআ কাটা সাব কাতেন গামকিয়ায়, এ প্রভু, ইঞ আ হান্ডে হাতেন অচগেমে, চিয়াচি ইঞ দ পাপী হড় তানাই। ");
INSERT INTO cdz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ইনাতে ইনি আর ইনি রাঃআ গাতি হড়কুদ নিন্তি/নিন ঢের লেকা হাকু সাব লাআ কুতে/কুয়াকু হায়কাট এ নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","এঙ্কাগে সিবদিয় রাঃআ হন যাকোব অটঃ জোহন তিকিন হঅ হায়কাট এ নাকিন, আর যাহায় দ শিমোন রাঃআ হাকদার কো তাহীন কেনা, ইনাতে যীশু দ শিমোন কে গামকিয়ায়, আলম বর আয়, তিহিং হাতেন আম দ হড়ম সাব কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","হেৎদ ইঙ্কূ দ বানার লাউকা আরি তেকু আগু রুয়াড় কেয়া হেৎদ যতচ কে বাগীকাতেন যীশু রাঃআ তায়ম-তায়ম তেকু সেএ না। ");
INSERT INTO cdz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","মিত মাহা যীশু দ মিয়াত নাগর রে মেনাআইয়া, মিহুড় হড় রাঃআ গোটা হড়মো কুষ্ট রোগ তে পেরেজ আকানায় ইনি উডুং এখান যীশু কে নেল কাতে তাবের রেনায় আর নেহর কাতে গাম কিয়ায়, এ প্রভু আমাঃ সানাং খান সাপা দাড়িআম। ");
INSERT INTO cdz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ইন্তং যীশু আয়া তিহি তিয়ার কাতে যুটিজ কিয়ায় হেৎদ গামকিয়ায়, ইঞ আ সানাং, মা সাপা মে। আর ইনা ঘাড়িগে/ ইন্তং গে কুষ্ট রোগ দ চাবায় না। ");
INSERT INTO cdz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","হেৎদ ইনিকে হুকুম কিয়ায় নিয়া থুতি যাহায় কে আলম গাম কুয়া। ইনি গাম কিয়ায়, মেন্খান আম দ সেন কাতে বামরে কে উদুইমে, হড়রাঃআ হান্ডে লুকুন্দ এম নাতিনাং, মোশি রাঃআ রি-চালি লেকাতে দান/দানরে সামভাও মে। ");
INSERT INTO cdz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","মেন্খান ইনি বাবত তে থুতিকু দ দাবদাবাও ইদিইনা, আর ঢের লেকা হড় থুতি আয়ুম নাতিনাং আর আকুয়াআ রোগ হাতেন বুগি নাতিনাং হিচ হুডি/জুটায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","মেন্খান ইনি দ জাহদরে নিঝুম জাগারে সেন কাতেন কয় জং কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","যীশু অটঅ মিত মাহা হুলাং চেতাও কেন কুয়ায়্য় য়, আর ইনি রাঃআ কাতারে ফরিশি অটঃ গ্সায় কু তাহীন কেনা, অকয় দ গালিল অটঃ যিহুদিয়া হাতু হাতেন হিচ কাতেন ডুব তাহিন কেনাকু আর প্রভু রাঃআ দাড়ি দ ইনি রাঃআ হান্ডে তাহীন কেনা, যাহাতে ইনি বুগি কুকায়। ");
INSERT INTO cdz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","নেলেম/মেন্খান, চিমিনটা হড়, মিয়াত তিহি-কাটা নুর হড় (পক্ষাঘাতি) কানিজ হড় কে পারকম তে গআ আগু তিয়া কু, ভীতির তে আদের ইদি কাতে আয়া সামাং রে দঃহ নামেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","মেন্খান গাদা লেকা হড় ইয়াতে, ইনিকে আদের নাতিনাং হরাঃআ কাকু নাম লেত তে, সাড়মি/সাতি চেতান টঙ তে দেজেনাকু, আর খাপরাঃআ অচ কাতে, পারখম সুধা/সমেত, তালারে যীশু সামাংরে ইনিকে লাতার আড়গু কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ইঙ্কূ য়া পাতিয়াও নেলকাতে যীশু দ গামকিইয়ায়্য়, এ পাহি, আমাঃ কাই/পাপ দ ছেমা/ছামা য়েন তামা। ");
INSERT INTO cdz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ইন্তং পণ্ডিত হেৎদ ফরিশি কু নিয়া কুকলি এটে/এটেজ তানাকু, নিই দ ভালে অকয় তানায়, ঈশ্বরকে হেনস্তা/নিন্দা থুতি তানায়? ঈশ্বর বেগর/ছাডা অকয় ছেমা দাড়িকুয়ায়্য় য় ? ");
INSERT INTO cdz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","যীশু ইঙ্কূ য়া কিনা কুকলি সানা লাআকুয়া আটকার নাম কাতে গম রুয়াড় কেৎ কুয়ায়্য় য়, আপেয়া মনেরে কিনাকু কুকলি-জাগার মেননা আটকার নাম কেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","অকাটা সহজ/আসন গেয়া, আমাঃ কাই ছেমা য়েন তামা, চি, বিরিৎ কাতে তাড়ম মেম? ");
INSERT INTO cdz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","মেন্খান, মানমি হন দ ধারতি রে কাই ছেমা রাঃআ দাড়ি মেনাতেয়া মেতেন। ইনি দ মিয়াত তিহি-কাটা নুর (পক্ষাঘাতি) কে গাম কিয়ায়, ইইঞ আমকে গাম তানামাই, মা বিরিৎ মে আর আমাঃ পারখম তুল/সাব কাতেন আড়া সেনম। ");
INSERT INTO cdz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","আর ইনি দ ইনা ঘাড়িগে ইঙ্কূ য়া মেত সামাং রে বিরিৎ তে নায়, আর ঈশ্বরকে সারহাও কাতে আয়া অড়াতে সেএ নায়। ");
INSERT INTO cdz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","যত হড়কু হায়কাট/মাহিল চায়নাকু, আর ঈশ্বরকে সারহাও কিয়াকু, হেৎদ বর রাঃআকাব বেন তে গাম কিইয়ায়্য়, তিহীঙ দ আবু হাহারাঃআ-আক নেল কেয়াবু। ");
INSERT INTO cdz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","নিয়াকু তায়ম তে যীশু উদুঙ এনায়, ইনিদ দ লেবি নুতুম তে মাসুল উঠায় কেনায়, মাসুল অড়ারে দুবেনায় হেৎদ গাম কিইয়ায়্য়, দেলা, ইঞ আ তায়ম তে। ");
INSERT INTO cdz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ইনাতে ইনি দ যতআ বাগি-গিডি কাতেন আনিরাঃআ তায়ম তে সেএ নায়। ");
INSERT INTO cdz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","হেৎদ লেবি আয়া অড়ারে ইনি রাঃআ খাতিরাঃআং মিয়াত মাড়াং ভোজ দঃহ কিইয়ায়্য়, হেৎদ ইঙ্কূ লো ঢের-লেকা মাসুল উঠাও হড়কু অটঃ এটা হড়কু জজম কু দুবে না। ");
INSERT INTO cdz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ইন্তং ফরিশি হেৎদ ইঙ্কূ য়া গ্সায় কু দ ইনি রাঃআ চেলা কুরাঃআ হান্ডে লালিশ কেয়া। ইঙ্কূ কু গাম কেৎয়াকু, আপে চিয়া মাসুল উঠাও/রাঃআ কাব অটঃ কাই হড়কু লো জম নুয় তানাপে। ");
INSERT INTO cdz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","যীশু দ ইঙ্কূ কে গাম রুয়াড় কেৎ কুয়ায়্য় য়, বুগিন হড় কুরাঃআ দ লহয়, রুয়াতে কাহিল হড় কুরাঃআ গে বাইদ/কুবরাঃআজ রাঃআ দ জরুর/জরুরি তানা। ");
INSERT INTO cdz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ইঞ দ ধরম হড় কুকেৎ লহয়, মেন্খান কাই হড় কুকেগে রাঃআ নাতিনাং ইঞ হিচ া কানাইঞ যাহাতে ইঙ্কূ মন রুয়াড়-এ কাঃআকু। ");
INSERT INTO cdz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ইনা তায়্ম ইঙ্কূ দ যীশুকে গামকিয়াকু, যোহন রাঃআ চেলা কু দ ঘাড়ি-ঘাড়ি বার হেৎদ কয় জং তানাকু, আর ফরিশি কুরাঃআ চেলা কুহ এনকা কেৎয়াকু, মেন্খান আমাঃ চেলা কুদ জম নুই রেগে তাহিনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","যীশু গাম রুয়াড় কিইয়ায়্য়, চিয়া বর আকুলঃঅ তাহিন ভুর, বারিয়াত কুকে উপাস/একেন তে দহ দাড়ি কুয়া পে ? ");
INSERT INTO cdz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","মেন্খান সময়/অক্ত সেটের অ তানা, ইন্তং বর দ ইঙ্কূ য়া হান্ডে হাতেন রেজ কুয়া কো, ইনা হুলাং ইঙ্কূ দক উপাস এয়া। ");
INSERT INTO cdz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","অটঃ হ ইনি আকুকে নিয়া উপ্মা এমা কেৎ কুয়ায়্য় য়, যাহায় হ নামা কিচি হাতেন মিত টুকরাঃআ/ফাড় কিচি চিরাঃআ কাতে, মারি কিচি রেদ কাকু রঃঅ জালাৎ দেআ, বাঙখান নামা হ অরেজআ আর ইনা হাতেন ছাডা টুকরাঃআ দ মারিয়া লঅ কাকিন জুড়িয়া কিন। ");
INSERT INTO cdz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","আর অকয় হ নামা আরখি দ মারি হারতা রাঃআ থলি কুরে দ কাকু দহ আ, আর বাংখান নামা আরখি তে থলি কু অড়েজ চা, আর আরখি দ হিরিজ চা, থলি কুদ বেকার চাবা। ");
INSERT INTO cdz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","মেন্খান টাটকাআরখিদ নামা হারতা রাঃআ থলি রেগে দঃহ হুইয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","হেৎদ মারি আরখি নু তায়ম নামা দ অকয় হঅ কাকু নানামা, ইঙ্কূ গামেয়াকু, মারিআ গে বেসা। ");
INSERT INTO cdz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","মিয়াত ঝিরাঃআও মাহা হুলাং যীশু আয়া চেলা কু লঃঅ বাইত রাঃআ তালা হরকাতে পারম সেন কেনায়, ইন্তং আয়া চেলা কু গেলে টয়/গদ কাতে তিহিতে লেটেজ কাতে জমেত কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ইনাতে কথক-লেকা ফরীশিকু জাগার কেয়া, ঝিরাঃআও মাহা হুলাং অকা কা হড়য়া ইনাকু চিয়া দপে কামী আ? ");
INSERT INTO cdz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","যীশু ইঙ্কূকে গামরুয়াড় কেৎ কুয়ায়্য় য়, চিনতং দাউদ হেৎদ আয়া গাতিকু রেঙ্গেজ নেনা, ইনি কিনা চিকালায়, ইনাকু শাস্ত্র কি আপে কাপে পড়হা কানা? ");
INSERT INTO cdz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ইনি মা ঈশ্বর রাঃআ অড়া বলঃঅ কাতে সামাংআ পিঠা সুন্নু চুটি ও কাতে আয় হেৎদ আয়া গাতিকু জম নাতিনাং এম কেৎ কুয়ায়্য় য়, অকাকুদ একেন বামরে রাঃআগে জজম হড় তাহীকেনা। ");
INSERT INTO cdz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","হেৎদ ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় , মানমি হন দ ঝিরাঃআও মাহা রাঃআ হ কর্তা তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","অটঃ মিয়াত ঝিরাঃআও মাহা হুলাং যীশু পাড়হা/সমাজ-অড়া/থান রে বলন কাতে, গাম-চেদ কেৎ কুয়ায়্য় য়, এন্ডে দ মিত হড় তাহীন কেনায়, অকয় রাঃআ জজম তিহি দ রহড়-গসচা নেনা। ");
INSERT INTO cdz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","কথক শাস্ত্র গ্সায় কু হেৎদ ফরীশিকু, ইনি ঝিরাঃআও মাহা রে বুগি কুয়ায়্য় য় চি লহয়, ইনা নেল নাতিনাং যীশুকে লড দহ কিয়াকু, যাতে আয়কে দোষ নাতিনাং আনদেন নামেকাকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","মেন্খান ইনি ইঙ্কূয়া উদিস/চিন্তা আটকার নাম কিইয়ায়্য়, হেৎদ ইনি তিহি রহড়-গস হড় কে গাম কিয়ায়, মা বিরিৎ মে হেৎদ তালারে তিঙ্গুন মে। ইনাতে ইনিদ বিরিৎ এনায় হেৎদ তিঙ্গুই নায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","হেৎদ যীশু ইনিকে কুলি কিয়ায়, আপেকে কুলি তানাপিং, ঝিরাঃআও মাহারে অকা কামী দাড়ি হড়য়া? বুগিন কামী চি বারিজ কামী? জিউ বাঞ্চাও চি গতঃ/নষ্ট। ");
INSERT INTO cdz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","এন্তে ইনি ইঙ্কূ যতচ হেতা বাড়া কাতে আরিজ রাঃআকাব কেৎ কুয়ায়্য় য়, হেৎদ ইনি হড় টাকে গামকিয়ায়, আমাঃ তিহি তেলাও মে। ইনিদ এনকা কিইয়ায়্য়, হেৎদ আয়া তিহি বুগি রুয়াড় এনা। ");
INSERT INTO cdz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","মেন্খান ইঙ্কূ দ সেঙ্গেরে নাকু, যীশু কে চিকাই আবু, ইনাগে আকু-আকুগে কুকলি তানা কু। ");
INSERT INTO cdz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ইনা তায়ম ইনি মিত মাহা হুলাং কয় জং নাতিনাং বুরু দর উডুং সেএঃনায়, হেৎদ ইনিদ গোটা নিদা ঈশ্বর রাঃআ হান্ডে কয় ভাড়া কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","সেতায়না খান/সিঙ্গি মার্শাল-এ খান, আয়া চেলা কুকে রাঃআ কেৎ কুয়ায়্য় য়, হেৎদ আকুয়াআ হান্ডে হাতেন গেল-বার হড়কুকে বাছা কেৎ কুয়ায়্য় য়, হেৎদ ইঙ্কূকে কুলিচ নুতুম কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","শিমোন, অকয় কেৎ ইনি পিতর নুতুম কিয়ায়, হেৎদ আয়িজ হাগা/বকঃতেত আন্দ্রিয়, হেৎদ যাকোব হেৎদ জোহন, হেৎদ ফিলিপ হেৎদ বর্থলময়। ");
INSERT INTO cdz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","হেৎদ মথি, হেৎদ থোমা, হেৎদ আলফেয় রাঃআ (হনতেত) যাকোব হেৎদ ঝুকি গামিয়া কু শিমোন। ");
INSERT INTO cdz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","যাকোব হনতেত যীহুদা, হেৎদ যীহুদা ইস্করিয়তীর (যুদাস) ইনি অকয় দ যীশুকে তায়্মতে বাইরি কুয়া তিহিরে সাব তকা লিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","হেৎদ ইনি ইঙ্কূলঃঅ বুরু হাতেন আড়গু হিচ কাতে মিয়াত সমান জায়গারে তিঙ্গুইনায়, হেৎদ আয়া গাদা লেকা চেলা অটঃ গোটা যিহুদিয়া মুলুক হেৎদ যিরুশালেম সরগ নাগার হেৎদ সোর হেৎদ সিদোন দরেয়া হেদে রাঃআ টলা হাতেন, ঢের লেকা হড় হিচ সেটের এনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ইঙ্কূ দ আয়া জাগার আয়ুম নাতিনাং হেৎদ আকুয়াআ রোগ হাতেন বুগি-বেশঃ নাতিনাং আয়া হান্ডে হিচে নাকু। অটঃ অকয় বিন-শাপা/বিন-বুগিন আত্মাকুতে ডামাডল/সাতাও তাহীনকেনাকু, ইঙ্কূ হ বুগি চাবায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","হেৎদ যতচ হড়কু ইনিকে জুটিজ নামেনাকু, চিয়াঃচি ইনি রাঃআ হান্ডে হাতেন দাড়ি উডুং কাতেন যতচ কে বুগি চাবা কেৎ কেন কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","হেৎদ ইনি আয়া চেলাকুকে আরিত রাঃআকাব কাতে গামাৎ কুয়ায়্য় , এ আপে রেঙ্গেজ-হড়কু, ধন্য আপেকে, ঈশ্বর রাঃআ রাঃআজ্য দ আপেয়া গে। ");
INSERT INTO cdz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","আপে নাহা রেঙ্গেজ তাৎপেয়া, ধন্য আপে দ, এন্তে/চিয়াচি আপে দপে বিঃ চাআপে। অকয় আপে নাহা ইয়াম তানাপে ধন্য আপে দ, এন্তে আপে দপে লান্দা জমেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","মানমি হন রাঃআ খাতিরাঃআং আপেকে ঘিন/ঘিনা/ছি-ছি পেয়াকু হেৎদ এটা/ভিনা গিডিপেয়াকু, নিন্দা/নিহাইত লাতার পেয়াকু আর আপেয়া নুতুম বাড়িজ গামকাতে সাগিন/এটা রে দহপেয়া কু, ধন্য আপে দ। ");
INSERT INTO cdz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ইনা হুলাং রাঃআ সকাপে হেৎদ ফুর্তি পে, চিয়াঃচি নেলেপে, সেরমা রে আপেয়া নাতিনাং মাড়াং সির্পা দহ মেনা, ইঙ্কূয়া হাপড়ামকু দ ভাবি-জাগারিজ কুকে হ এনকা লেতকেন কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","মেন্খান আপে কিসাড়-কুদ হায় হায়, চিয়াঃচি আপেয়া সান্ত্বনা/জিউ রাঃআড়েজ দ নাহাগে নামেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","আপে নাহা বিঃয়াকানকু দ হায় হায়, চিয়াঃচি আপেকেৎ রেঙ্গেজ-পেয়া, আপে নাহা লান্দা-জমে তানাপে, হায় হায়, চিয়াঃচি আপে দপে দুঃখওয়াপে হেৎদ ইয়ামাপে। ");
INSERT INTO cdz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","হড়কু আপেকে সারহাও এৎপে খান আপেদ হায় হায়! চিয়াঃচি ইঙ্কূ য়া কুল হাপড়াম কুদ লাব্বাক ভাবি-জাগারিজ কুকে এনকা লেতকেনকুয়াকু/এনকা লাৎ কেনকুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","মেন্খান আপে অকয় আয়ুমেতানাপে আপেকে গাম তানাপিং, আপেয়া শত্রু/বাইরি কুকে দুলাড় কূপে, অকয় আপেকে ঘিন/ঘিনা পে তানাকু, ইঙ্কূ য়া বুগিন কামীপে। ");
INSERT INTO cdz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","অকয় আপেকে শাপ এমপেয়াকু, ইঙ্কূকে আশিসকূপে হেৎদ আপেলো অকয় বারিজ/খারাপ এয়াকু ইঙ্কূয়া খাতিরাঃআং কয় জং পে। ");
INSERT INTO cdz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","অকয় আপেকে মিয়াত জোহারে তাপরি/থাপা পেয়াকু, ইনিদ আয়া অটঃ মিয়াত জোহা হানিরা হান্তে আটেত দহয়কায়, অকয় আমাঃ উয়ুনা কু জোরকাতে রেজ ইদিয়াকানাকু দ আমাঃ আঙঙ্গাহঅ/অন্তর্বাসহঅ ইদিয়ান কুকে আলম মানাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","যাহায়গে আমাঃ হান্ডে যাহানা আসিয়াকু, ইনিকে ইনাটা এমাইম, হেৎদ অকয় আমাঃ জিনিস জোরকাতে কুমড়ু ইদি আকু/আতকির ইদিয়াকু ইনাদ ইনিরা হান্ডে আলম আসিইয়া। ");
INSERT INTO cdz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","হেৎদ এটা হড় কুয়া হান্ডে হাতেন চিলকা-লেকা খাতির আসি/নাম তানাপে, এনকাগে আপে হ ইঙ্কূ কে খাতির কূপে। ");
INSERT INTO cdz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","হেৎদ অকয় আপেকে দুলাড় পেয়াকু, ইঙ্কূকেগে দুলাড় লেংখান ধন্যবাদরাঃআ কিনা মেনা? চিয়াঃচি পাপীহড়কুহ মা, অকয় ইঙ্কূকে দুলাড় কেৎয়াকু, ইঙ্কূহঅ ইঙ্কূকে দুলাড় কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","হেৎদ অকয় আপেয়া বেশ/বুগিন নানামকু, যদি ইঙ্কূয়া আপে বেশ/বুগিন নানামপে, মেন্খান আপে চিলকান ধন্যবাদপে নামেয়া। কাই/পাপী হড় কুহ মা এনকান গেয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","হেৎদ অকয় কুরাঃআ হান্ডে নাম রুয়াড় পে আশা তানা/আসি নাম তানা, ইঙ্কূ গে উধার এমাকুয়াপে খান, এন্খান আপে চিলকান ধন্যবাদপে/ভরপে নামেয়া, পাপীকু/কাইয়ানকু যদি পাপীকুকে/কাইয়ানকুকেউধার এমাকুয়াকু/এমাকুয়াকু, যেন ইন্তি যুকুরাংগে/লেকাগে নাম রুয়াড় একায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","মেন্খান, আপে আপেয়া বাইরি কুকে দুলাড় কূপে, ইঙ্কূ য়া বেশ নামঃপে, আর একেন নাম রুয়াড় আশাতে আলপে উধার এমকুপে, এনকা লেংখান আপে দ মারাঃআ কুড়াই/পুরষ্কার পে নামেয়া, আশু মাড়াং-মাপরাঃআং রিনিজ হনপে হুযুয়া, অকয় ইনি নিমখারাম/অকৃতজ্ঞ ও বাড়িচ /খারাপ হড় কুকে হ দায়া কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","আপেয়া সরগ বাঃ তাপেয়া চিল্কা দায়া গেয়ায়, আপে হঅ এনকা দায়াইজ হুয়ুপে। ");
INSERT INTO cdz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","আলপে ধরবার কুয়া আর আপেকে হ কাকু ধরবার পেয়া, আলপে দোষী কুয়া আর আপেহ কাপে দূষি আ, ক্ষমা কূপে আর আপেকেহঅ ক্ষমাপেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","এমকূপে আর আপে কেহ এম পেয়াকু, বুগিন সংতে, অটা-অটা তে, রুকু-রুকু তে, হেৎদ উপচিয়া/রুবু-রুবু আপেয়া কয়ং রেকু আরজা দঃহ আকু, আপে অকা সংআক তে আপেপে সং এআ, ইনাতেগে আপেকে হ সং রুয়াড় পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","যীশু দ ইঙ্কূকে অটঃ মিয়াত জনকা/দৃষ্টান্ত গামকেৎ কুয়ায়্য় য়, কিনা মিয়াত কাঁড়া হড় অটঃ মিয়াত কাঁড়াকে হরাঃআ উদু দাড়িযায়? কিনা ইঙ্কিন দ বানার হড় গাঢা রে কাকিন নুরুয়া? ");
INSERT INTO cdz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","চেলা দ গুরু হাতেন কা মারাঃআওয়াং। মেন্খান কাবিল/যোগ্য় মেহাওয়ায়/হুইওয়ায়, ইনি আয়া গুরু লেকা হুযুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","আমাঃ বকম রাঃআ মেদরে অকা জন্দ্রাঃআ/জবরাঃআ মেনা, একেন ইনা নেলেতানাম, মেন্খান আমাঃ মেদ রে অকা মুধাট মেনা ইনা দ কাম নেলে তানা চিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","আমাঃ মেদ রে অকা মুঢাত মেনা, ইনা কাম নেল নামেতানা, চিকাতে আম আমাঃ বকম কে গাম দাড়িয়াম, রহ বকইঞ, ইঙ আমাঃ মেদ হাতেন জবরাঃআ/জন্দ্রাঃআ উডুং গিডিলেয়াইঞ। এ ভন্ডকু/ধাপাবাজ কু, মাড়াং আপেয়া মেদ হাতেন মুধাট অচ গিডিপে, হেদতে আপেয়া বকম কুরাঃআ হান্ডে হাতেন জবরাঃআ/জন্দ্রাঃআ উডুং গিডি লেংখান ফার্চা নেল নামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","চিয়াচি এনকান বুগিন দারু বায়ায় না, কদেরে খারাপ/বাড়িচ জ জআ, অটঃ এনকান খারাপ/বাড়িচ দারু বায়ায় না কদেরে বুগিন জ জআ। ");
INSERT INTO cdz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","মিমিৎ দারু দ ইনা রাঃআ জ তেগে চীনহা নামোয়া, জানুম দারু হাতেন দ লোয়া জ দ কাকু গদেআ, আর কুরিচ/কুরিক হাতেন দ মাৎকম কাকু গেত জারোয়ায়া। ");
INSERT INTO cdz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","বুগিন হড় দ আয়া অন্তর রে জারোয়া দহখানে/লেখান বুগিনা হান্ডে হাতেন বুগিনা উডুং আ আর খারাপ হড় হাতেন খারাপ গে উডুং আ, চিয়াচি ইনিরা অন্তররে কিনা তাহিনা ইনি মচাতেহঅ ইনা গামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","আপে দ চিয়া ইঞ কে হে প্রভু হে প্রভু মেন্তে রাঃআ ইঞ আ তানা আর ইঞ অকা অকা গাম তাআপিং ইনা দ কাপে আয়ুম/লুতুর এ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ইঞ আ/ইঞা হান্ডে অকয় গে হিজু আয় হেৎদ ইঞ আ থুতি কুহ আয়ুম কাতে সেসেন আয় ইনি দ অকয় লেকানিজ মেন্তে গাম সদরাঃআয় ইঞ আপেকে সারিতকাতানাপিং। ");
INSERT INTO cdz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","নিঃই দ মিয়াত অড়া বানঃহা লেকানিজ, ইনি অকয়দ লা উর কিইয়ায়্য়, গাঢা কিইয়ায়্য়, দিরি চেতানরে ভিত রেনঢেত বাইসা কিইয়ায়্য় খান বন্যা দা আড়গু হিচে না, হেৎদ ইনা অড়ারে টঅয়/বাজায় না মেন্খান ইনা দ কায় হিলা দাড়ি লিয়ায়, চিয়াঃচি ইনা দ বুগিনগটা ার বানা দহ হুইলেনা। ");
INSERT INTO cdz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","মেন্খান অকয় ইনা থুতি আয়ুম কাতেন হঅ ইনা লেকা কাকু সেসেন লেনা, ইনি দ এনকান মিয়াত হড় লেকানিজ, ইনি অকয় দ আয়া অড়া একেন হাসা চেতানরে, বেগর ভিত রেনঢেত রে বানা কিইয়ায়্য়। চিললং বন্যা রাঃআ দা আড়গু হিচে না হেৎদ ইনা অড়া রে টঅয় না, হেৎদ ইনা দ ইন্তং গে লানদুড়এনা, আর ইনা অড়া পেটেজ ধাসুড় কাতে বহাল ইমাহা া। ");
INSERT INTO cdz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","আয়া যত থুতি হড়কুকে গাম চাবাকেৎকুয়ায়্য় খান, যীশু দ মুলুক কফরনাহুম তে বলয়নায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","এন্ডে মিহুড় শতপতি রাঃআ বারমাসিয়া মুনিস তাহিনকেনায়, ইনি অকয় কেৎ কুঠিন তেয় গে কুশিয়াই কেনায়, রুয়া-হাসুতে কাহিলা কানতে নেএ গজয়ায়/মরমর অবস্থা এনকা তাহিলেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ইনি রোমীয়দ যীশুরাঃআ বাবদ তে আয়ুম কেৎ খানয় কথক যিহুদি মুরুব্বি কুকে ইনি রাঃআ হান্ডে কুলকেৎ কুয়ায়্য় য়, যাতে ইনি হিচ কাতে আয়া দাসী কে বুগিকায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ইঙ্কূ যীশুরাঃআ হান্ডে সেন কাতে, গাদা কশামুদিকিয়তেকু আপিল/অনুরোধ কাতে গাম কিয়াকু, আম যেন ইনি রাঃআ নাতিনাং নিয়া কামীয়াম, ইনি দ নিয়ারাঃআ লেকতানায়/আইদারীনায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ইনি আবুয়া জাইত ইহুদি রিঙ্কূ কে দুলাড়লা তকুয়ায়্য় য় অটহঅ ইনিগে আবুয়া সমাজ-অড়া বানা লাৎ বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","যীশু ইঙ্কূলঅ সেএনায়, আর অড়া হাতেন হুডাং সাংগিন রে তাহীনঃ রেগে, শতপতি দ, নিয়া গাম নাতিনাং আয়া দাসীকুকে কুল কেৎ কুয়ায়্য় য়, প্রভু, আলম কষ্ট এমলেয়া, চিয়াঃচি ইঞ এনকান লেক হড় দ লহয় তানায় যে, আম ইঞয়া ছাদ লাতাররে মেনামা। ");
INSERT INTO cdz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ইনাতে/ইনা নাতিনাং, ইঞ আহঅ আমাঃ হান্ডে সেন লেক কাইঞ আটকার লাআ, মেন্খান আম দ একেন মিয়াত থুতি মচাতে গাম গদেম, ইনাতেগে ইঞ আ দাস বুগি গদয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ইনাতে ইঞ হ এটা হড়রাঃআ একতিয়াররাঃআ/ক্ষমতারাঃআ বাগতরে ঠাররাঃআও কানিজ হড় তানাইঞ, আর ইঞয়া বাগতরে/লাতাররে পাল্টন/লাড়হাইনঙ্কূ মেনা কুতিংআ, মিত হড়কে গামিং খানয় সেনমে, সেনআয় আর এটাগিজকে হিজু / হিজু গাম লেংখান হিজু আয়, আর ইঞ রিংকু দাসী/আচুইনি কুকে গামলেংখান নিয়াটা কামীমে, ইনি ইনা কামীআয়। ");
INSERT INTO cdz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","যীশু দ নিয়াকু আয়ুম কেৎ খানয়, ইনি রাঃআ বাব্ত্তে তে হায়কাট এনায়, হেৎদ অকা হড়কু আয়া তায়ম তায়ম তে হিজু কেনাকু, ইনি ইঙ্কূ ঢের হড় কুয়া হানতে কয়অ রুয়াড় কাতে গামকেৎ কুয়ায়্য় য়, ইঞ আপেকে গাম তানাপিং, ইস্রাঃআয়েল রাঃআ তালামাঙ্গা রেঃ নিন্তি/নিন মারাঃআং পাতিয়াও দ কা নেলনামা কানা। ");
INSERT INTO cdz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","অকয় কুকে কুল হুইলেনা, ইঙ্কূ দ অড়া কু রুয়াড় য়েন খানঃ, রুয়াতে কাহিলকানায় দাসী কেৎ বেশ/বুগিন কু নেলনাম কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","হুডাং হুলাং/মাহা তায়ম তে যীশু দ নায়িন নুতুমাআ সরগ নাগারতে সেএ নায়। ইনি রাঃআ চেলা কু হেৎদ গাদালেকা হড়কু হ আয়লঅ/ইনিলঅ সেএ নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","হেৎদ সরগ নাগাররাঃআ/শেহার রাঃআ বলোঃ নঃ রাঃআ দুয়ার কাতা/রেনঢেত তেকু সেটেরএনাকু খানঃ, হড়কু মিয়াৎ গয় হড়কে গঅতিততুকু বাহারতে তপা নাতিনাং ইদি তানা, ইনিদ আয়া এঙ্গাতেদ/মাইতেদ রাঃআ একেন/একলা মিহুড় হন তাহিলেনায়, আর এঙ্গা/মাই তেত দ রাঃআন্ডিগে তাহিনঃ কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","প্রভু দ ইনিকে নেল কাতেন মোহ/দায়া হিচে না হেৎদ ইনিকে গাম কিয়ায়, আলম ইয়ামা। ");
INSERT INTO cdz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","হেৎদ ঠাইন রে সেন কাতে পারখম এ জুটিত কিইয়ায়্য়, আর গগিজকু (অকয় গঅ ইদিকেনাকু) তিঙ্গুইনাকু। হেৎদ ইনি গামকিইয়ায়্য়, এ বাবু/জুয়ান, ইঞ গাম তানামা এ জুয়ান, বিরিৎ মে। ");
INSERT INTO cdz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ইনাতে ইনি গচ হড় দ বিরিৎ দুব কাতে থুতি গাম এহবেনায়/সাপড়ায়নায়, যীশু দ ইনিকে এঙ্গা/মাই তেত রাঃআ হান্ডে জিমা/এম রুয়াড়কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ইন্তং যতচ গেকু বরঃ কেয়া আর নিয়া কু গাম কাতে ঈশ্বর রেকু সারহাও কিয়া, আবুয়া তালা রে মারাং ভাবি-জাগারিজ রাঃআকাবা কানায়, আর ঈশ্বর দ আয়া হড়কুকে দেঙ্গা তাৎকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ইনি বাবদতে নিয়া থুতি দ গোটা যিহুদিয়া দিসুম রে হেৎদ ঠাইঞ রাঃআ গোটা দিশুমরে/টলারে পাসরাঃআয় না। ");
INSERT INTO cdz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","যোহন রাঃআ চেলা কুদ ইনিকে নিয়া যতচ ারাঃআ খবরকু গাম কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","হেৎদ যোহন দ আয়া বার হড় চেলা কিনকে রাঃআ কেৎ কিনায়, আর প্রভু রাঃআ হান্ডে নিয়া কুকলি কুলিএ কুলকেৎকিনায়, হিজু তানিই মসীহ দ আম গে তানাম চি এটাগিজকেলে নেল তাংগিআ/হরইআ? ");
INSERT INTO cdz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","হেৎদ ইনকিন যীশু রাঃআ হান্ডে হিচ কাতে গামকিয়াকিন, যোহন বাপ্তাইজ দ আমাঃ হান্ডে নিয়া কুকলি কুলিএ কুলা তাত লিয়াইআয়। হিজু ই তানিই দ আম গে তানাম চি এটাগিজকে লে নেল তাংগিআ/হরইআ? ");
INSERT INTO cdz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","গটা ইনা ঘাড়ি গে, ইনি দ গাদা লেকা হড়কুকে রোগ, হাসু আর বাড়িজ/বাড়িচ আত্মাকুরা হাতেন বুগি কেৎ কুয়ায়্য় য়, হেৎদ ঢের উতার কাড়া হড় নেল দাড়িরাঃআ মেতদিশা এমাত্কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ইনাতে ইনি দ কুল হড় কিনকে কুলি রুয়াড় কেৎ কিনায়, দু, রুয়াড় সেন কাতে অকা নেল তাবেন হেৎদ আয়ুম তাবেন যোহন কে গামিবেন, কাড়াকু নেনেল তানা, ল্যাংড়াকু তাড়মেতানা, কুষ্ঠকু/সুদকু শাপায় নাকু, কালাকু আয়ুমমে তানা, গয় কু জিউত রুয়াড় এনাকু, আর রেঙ্গেজ কুরাঃআ হান্ডে বুগিন বার্তা হাজিরাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ধন্য ইনি হড়দ, অকয় ইঞ আ দোষ/গুনাহা সাব্তে কায় নামেআয়। ");
INSERT INTO cdz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","যোহন রাঃআ সরগ নাগা /সরগ নাগা সেএ নাকিন খানঃ; ইনি দ গাদা হড়কুকে যোহনরাঃআ বাবদতে গাম লাগায় নাকু, আপে দ হাহানকারেদ কিনা নেল পে সেনলেনা? হয়ও তে লাড়া/হিলা তানা এনকান মিয়াৎ নল/খাগড়া? ");
INSERT INTO cdz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","এন্খান কিনাপে নেল সেন লেনা? লেবেজ কিচি সিনিব তুসিং হড়কে? নেলেপে অক্য়য় কু দামান কিচি তুসিংকাতে হেৎদ সুখতে যজম কুদ হেৎদ মান্তান লেকা রাঃআজ-রাঃআজাকুরাঃআ দলান কুরে মেনাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","এন্খান কিনা নেলপে সেন লেনা? মিহুড় ভাবি-জাগারিজ? হে, ইঞ আপেকে গাম তানাপিং, ইঞ দ ভাবি-জাগারিজ কুরা হাতেন হঅ মারাঃআংগেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","নিই দ ইনি হড়তানা, অকয়রাঃআ বাব্ত্তে তে শাস্ত্ররে অলমেনা, নেলেপে ইঞ আমাঃ মাড়াং-মাড়াং তে ইঞ আ সরগ নাগা কেইঞ কুলিয়াইঞ, ইনি দ আমা মাড়াং-মাড়াং তে আমাঃ হরাঃআয়ে তেয়ারএমায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ইঞ গাম তানাপিং, কুড়িহন কুরা হাতেন জানামা কানাকু তালারে, যোহন হাতেন মারাঙ দ অকয় হঅ বানু কুয়া, তুবুই রহ ঈশ্বর রাঃআ রাঃআজ্য রে হুডিং উতারিজ দ ইনি হাতেন হঅ মারাঃআং গেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","যত হড়কু হেৎদ মাসুল/কর আদায়হড়কু হঅ যোহন রাঃআ ডুবুল তে ডুবুল কানাকু/ডুবুল হাতায়িজ নিয়া থুতি আয়ুমকাতে ইঙ্কূ, ঈশ্বরকে ধার্মিক মেন্তে স্বীকারকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","মেন্খান ফারিশী কু হেৎদ পান্ডিত কু দ ইনি রাঃআ তিহিতে ডুবুল কা হাতায়িজ কু দ আকুয়াআ ঈশ্বর রাঃআ মতলব বাগি গিডি কেয়া/কাকু তেলাওলা। ");
INSERT INTO cdz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","গাম রে তাহি নায় ইঞ নিয়া পিড়হি রিঙ্কূ হড় কুকে দ অকয় লঅ যখা কুয়াইঞ, ইঙ্কূ দ ভালে অকয় লেকানকু। ");
INSERT INTO cdz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ইঙ্কূ দ হাট-বাজার রে দুবাকানা হনকু লেকান, অকয় দ আকু-আকু গে রাঃঅগ তানাকু, আলে দ আপেকে দুবাং রুতু রু অরংয়াদ পেয়ালে, আর আপে দ কাপে এনেজ লেনা, আলে দলে দুক হায়-হায় কেয়ালে আর আপে দ কাপে রডন লা। ");
INSERT INTO cdz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","চিয়াচি পিঠা কায় জমেয়ায় আর আরখি হঅ কায় নুই আয় যোহন ডুবুল হিচ াকানায়, আর আপে দপে গামে তানা, ইনি দ বঙ্গা লাঠাকানায়/বঙ্গা উম্বুল তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","মান্মি হন হিজু কাতে জম-নুই আয় আর আপে গামেয়া পে, এনে নেলেপে, পিটুক/জজমিজ/জুমড়ি/ছছরা আর নু-বুল হড়, বুটি আদায়কু আর পাপী হড় কুরা গাতি তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","মেন্খান প্রজ্ঞা/আকিল দ আয়া যত হন্কুরাঃআ দ্বারাঃআয় তে সার্তি মেনতে প্রমাণতানা। ");
INSERT INTO cdz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ফারিশী কুয়া তালা-মাঙ্গা হাতেন মিয়াত হড় যীশুকে আয়লঅ জম নাতিনাং নেওতা এমাকিয়ায়, হেৎদ ইনি ফারিশীরাঃআ অড়াতে বলয়েনতে জম দুবেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","হেৎদ ইনি রাঃআ হান্ডে মিয়াত বাহুকুড়ি হিচে নায় অকয় দ শেহার রে খারাপ নুতুম তে তাহি কান তায়। ইনি দ ফারিশী রাঃআ অড়ারে যীশু জম দুবা কানায় মেনতে সারি থরাঃআ, মিয়াত পুন্ডি দিরি রাঃআ চুকারে শয়ান সুনুম আগুকিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","আর তায়ম দর ইনি রাঃআ কাটা রেনঢেত রে তিনগুকাতে ইয়াম-ইয়াম তে আয়া মেত দা তে ইনি রাঃআ কাটা লহত কেৎ তেয়ায়, আর আয়া উপতে যদ কিইয়ায়্য়। হেৎদ ইনি রাঃআ কাটা চ-চঅ তে, ইনি শ/শয়ান সুনুম অজঃ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ইনাকু নেল কাতে ফারিশী অকয় কে নেওতা লিয়ায়, ইনি মনে মনে তে গামেনায়, নিই দ ভাবি-জাগারিজ হুইআয়/তাহীন কানায়, এন্খান সারি নাম কেয়াম, নি কে অকয় জুটিজিয় তানিজ দয় অকয় আর চিকা লেকানিজ বাহুকুড়ি তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ইন্তং যীশু ইনিকে গাম রুয়াড় কিয়ায়, এ শিমোন, ইঞ আমকে মিত-বার কথা/থুতি গাম রাঃআ মেনা তিঞাআ। ইনি গাম কিইয়ায়্য়, এ গুরু মা গামেম। ");
INSERT INTO cdz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","মিয়াত মহাজন রাঃআ বারহড় কারযা কিন তাহিলেনা, মিহুড় দ মড় মড়ে সায় কাউডি অটঃ মিহুড় য়িত/ইত দ পঞ্চাস কাউডি ধারুয়া লেত তায় কিনা। ");
INSERT INTO cdz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ইঙ্কিন দ কাকিন হালা রুয়াড় দাড়িঃলা খান, ইনি দ ইঙ্কিন বার হড় কে ইকা/ছামা য়েত কিনায়, ইঙ্কিন মুদরে অকয়টা ইনি ঢের দুলাড়/কুশি আয়? ");
INSERT INTO cdz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","শিমোন গাম রুয়াড় কিইয়ায়্য়, ইঞ আ মনে হুয়ুআ, অকয় রাঃআ ঢের ঋণ ইকা হুয়াকান তানিজ গে। হেৎদ যীশু গাম রুয়াড় কিয়ায়, গটা গেম ধরবার কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","হেৎদ ইনি বাহুকুড়ি রাঃআ দর/হানতে কয়অ কাতেন শিমোন কে গাম কিয়ায়, নিই বাহুকুড়ি কে নেলি তানাম? ইঞ আমাঃ অড়া বলয় নাই, আম ইনকে কাটা আবুং রাঃআ দা কাম এম লিংআ, মেন্খান নিই বাহুকুড়ি দ আয়া মেত দা তে কাটা লহত কিয়াং, হেৎদ আয়া উপ তে যত কিয়াং। ");
INSERT INTO cdz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","আম ইনকে কাম আতাং দারম চ লিংআ, মেন্খান ইনি দ ইঞ বলয়েন খান, ইঞ আ কাটা চঅ কিইয়ায়্য়, কায় থিরাঃআ কানায়/থমকায়না। ");
INSERT INTO cdz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","আম ইঞ আ বহ উপ রে সুনুম এম কাতে কাম মাইন্ গস লিংআ, মেন্খান ইনি শয়ান সুনুম তে ইঞ আ কাটা গস কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","নিয়া নাতিনাং, আমকে গাম তানা মাইঞ, নিই রাঃআ গাদা/ঢের লেকা কাই ইকা/ছামা হুয়াকানা, চিয়াঃচি নিই ঢেরগে/কুঠিনগে দুলাড় উদু কিয়ায়, আর অকয় কে দ হুডাং ইকা/ছামা কিয়ায়, ইনি দ হুডাং গে দুলাড় এ উদু আয়। ");
INSERT INTO cdz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","হেৎদ ইনি বাহু কুড়ি হন কে গাম কিয়ায়, আমাঃ যত কাই ইকা/ছামায়ান তামা। ");
INSERT INTO cdz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ইন্তং ইনি লো অকয়কু জম দুবাকান তাহি লেনাকু, ইঙ্কূ মনে মনেতে মেমেন/গাম লাগায় নাকু, নিই দ অকয় তানিজ কাই হ ইকা/ছামা আয। ");
INSERT INTO cdz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","মেন্খান ইনি দ বাহুকুড়ি কে গাম কিয়ায়, আমাঃ পাতিয়াও গে আমকে বানচাও কেৎ মেয়ায়, ডু সুলুক তে সেন জমম মে। ");
INSERT INTO cdz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ইনা তায়ম তে যীশু দ শেহার হেৎদ হাতুকুরে দাড়া-দাড়া তে গাম পাসনা হেৎদ ঈশ্বর রাঃআজ রাঃআ বুগিন সংবাদ-এ হাজির/সেটের তকায় কেনায়। ইনিলঅ গেলবার চেলা কু তাহিলেনা, ");
INSERT INTO cdz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","আর চিনতি/চিমিন হড় /লেকা কুড়ি হন কু তাহীন কেনা, অকয় কে কুদ বারিজ/এটকান আত্মা কু আর রোগ-বিঘিন হাতেন বুগি চাবা য়েত কাতে তাহিকেনা/তাহিলেনা। মগদলিনি হাতু রানিচ এরা হন মারিয়াম মেন্তে কু গামাইয়া, ইনি অকয় রাঃআ হান্ডে হাটেন এয়াই বঙ্গা উডুং অচয় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","হেরদরাজ রাঃআ দেওয়, অকয় দ কুষ রাঃআ এরাঃআ তেত, হেৎদ শোশন্না অটঃ এটা-এটা কুড়ি হন কু তাহিন কেনা। নুকু দ ইঙ্কূ আকুয়াআ সম্পত হাতেন এম-সাপড়া কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ঢের উতার হড় কু হিচ হুন্ডি নাকু, আর এটা এটা/মিমিত মিমিত শেহার রিঙ্কূ যীশু রাঃআ হান্ডে হিচ সাপড়ায়/লাগায় নাকু, ইনি নিয়া জনকা/দৃষ্টান্ত গামাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","মিয়াত হেরয়িজ হিতা হের নাতিনাং উডুং ইমাহা য়, হের জোকা/জখেন হুডাং লেকা হিত দ হরাঃআ কাতারে নুরে না ইনাতে তিকা-রচত/ঘাসমানডা ইদি কেৎয়াকু, চেতাং/চট রিঙ্কূ অরে হালাং জমকেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","হেৎদ চিনতি লেকা দিরি চাঠান চেতান রে নুরে না, গজায় না মেন্খান ইনা দ হল বাআন/বানুআন তে গসঃ গজে না। ");
INSERT INTO cdz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","চিনতি লেকা দ জানুম লাটারাঃআ তালারে নুরে না আর জানুম কু ইনা রেনঢেত হারাঃআয় না আর তেন/দাপাল/হারুব দহ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","আর চিনতি লেকা হিত দ বুগিন হাসারে/অতে রে নুরেনা, ইনাতে ইনা হারাঃআ কাতে শায় ডবর জ-পায় আকানা/আকানায়। নিয়া গাম কাতে ইনি দ জোর কিকিচ কিইয়ায়্য়, যাহায় রাঃআ আয়ুম নাতিনাং লুতুর মেনাতেয়া, ইনি দ আয়ুমে কায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ইনা তায়ম তে ইনি রাঃআ চেলা কু নিয়া ফেন/জনকা রাঃআ মানে/ভাব কিনা? কুলিকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","যীশু গাম কিইয়ায়্য়, ঈশ্বর রাঃআ রাঃআজ্য/রাঃআজসতি রাঃআ টঘাট যত আপে কে সারি/গাম সদর তকা তানা, মেন্খান এটাকুয়া হান্ডে দ একেন ফেনে/জনকা গাম তেগে, যাতে নেল কাতে হ আলকু নেমা আর আয়ুম কাতেন হ আলকু বুঝা। ");
INSERT INTO cdz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","দৃষ্টান্ত/জনকা দ নিয়াগে, হিত দ ঈশ্বর রাঃআ জাগার তানা। ");
INSERT INTO cdz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ইঙ্কূ গে হরাঃআ কাতা রিঙ্কূ হড়, অকয় আয়ুম কেৎয়াকু, হেৎদ খান শায়তান হিচ কাতে, ইঙ্কূ য়া অন্তর হাতেন জাগার আতির ইদি কিইয়ায়্য়, যাতে ইঙ্কূ পাতিয়াও কাতে আলকু বানচাও আ। ");
INSERT INTO cdz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","চাঠান/দিরি চেতানরে দুকু ইঙ্কূ তানা, অকয় আয়ুম কাতে রাঃআসকা তেকু আতাং গত কেৎয়াকু, মেনখান পাটা/চের বানুয়ান তে, ইঙ্কূ একেন মিত ঘাড়ি গে পাতিয়াও নাকু, হেৎদ বিডাও জকা/জখেন দুকু পাতিয়া হাতেন অচ গিডিইনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","হেৎদ জানুম লাটা কু তালারে নুরলেনা হিতা কুদ এনকান হড়তানা/ইঙ্কূতানা, অকয় আয়ুম দুকু আয়ুমকেয়া, মেখান সেন সেনতে নিয়া পুরি রাঃআ ডানদ, ধন-দৌলত হেৎদ সুখ রাঃআসকা তেকু তেনঃতানা, হেৎদ কাকু জ জ-তকায় তানা। ");
INSERT INTO cdz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","আর অকা বুগিন হাসারে নুড় লেনা, হিতাকু দক ইঙ্কূ তানা, অকয় জাগার আয়ুম কাতে, ইমানদার আর বুগিন-সাপা মনেতে ইঙ্কূ সাব দঃহয়েত আর জ জ-পায়আন ধাবিজ জিউ সাআ-তিং। ");
INSERT INTO cdz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","অকয় হ প্রদীপ/দিমি/দামরাঃআ ধরাঃআ কাতেইনা দ ভাজানতে কাকু হারুবা আর কাগে পারখম লাতাররেকু দঃহয়া, মেনখান ইনা দ দিমিডানদি চেতানরে কু দঃহয় আ। যাতে বলন হড় মার্শালকু নেলা/নেলেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","চিয়াচি এঙ্কান যাহানা হ উকু দহঃ বায়ায়/বানে না, অকা কা লেল-সদর আ আর কাগে এনকান যাহানা দানাং মেনা, অকা কা সারি নামোয়া আর মার্শাল সামাংতে কা আগুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ইনাতে হুশিয়ার আপে, চিল্কা লেকাপে আয়ুম মেয়া মেনতে, চিয়াচি অকয় রাঃআ মেনা, ইনিকে অটহঅ গে এম হুইআ, আর অকয় রাঃআ বায়ায় না, ইনি রাঃআ অকাটা মেনাতেয়া হুদিসতানা, ইনা হ রেজ হুয়ুআ। ");
INSERT INTO cdz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","যীশু রাঃআ মাই তেত হেৎদ বকঃ তেত তুকু আয়া হান্ডে হিচে নাকু, মেন্খান গাদেল হড় কুয়া ভিড়তে ইনিলো ইঙ্কূ দ কাকু নাপাম দাড়িলা/দাড়িকেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ইনা তায়্ম মিয়ুর যীশু কে গাম হুয়ে না, আমাঃ মাই আর বকম তামা তুকু দ বাহার রেকু তিঙ্গুয়াকানা আর আম লো নাপাম নাতিনাং (সানাংনাকু/আনগাওনাকু)। ");
INSERT INTO cdz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","মেন্খান যীশু গাম রুয়াড় কেৎ কুয়ায়্য় য়, অকয় ঈশ্বর রাঃআ জাগার আয়ুম মেয়ায়, হেৎদ ইনাকুতে তে সেন আয়, ইঙ্কূ গে ইঞ আ মাই আর বকৈং তুকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","মিত মাহা ইনি আয়াইজ চেলাকু লো মিয়াত লাউকা রেকু দেজে না আর গামকেৎ কুয়ায়্য় য়, দেলা আবু দ দরেয়া পারম কাতে ইনা সায় সেন লোকায়া বু, ইনাতে/হেৎদ লাউকা লাড়া কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","মেন্খান ইঞ কু চিন্তং লাউকা তেকু সেন কেনা, ইনি দ গিতিজ শ্চ লেনায়, হেৎদ দরেয়া রে হয়অ হিচে না আর লাউকা দ দাঃআ তে পেরেজ লাগায় না আর ইঙ্কূ দ মুস্কিল রেকু নুরেনা। ");
INSERT INTO cdz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ইনাতে ইঙ্কূ বিরিৎ নাতিনাং ইনি রাঃআ হান্ডে সেনে নাকু আর রাঃআ কিয়াকু, এ গ্সায় ! এ গ্সায় ! ডুম-বুইজ গ্জেনালে ! ইনি দ বিরিৎ কাতে হয়কে আর ছালকা কে ধমকাঃআ কিইয়ায়্য়, ইনাতে হয় আর দা থির-থারে নাকু আর নিঝুম এনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","হেৎদ ইনি ইঙ্কূকে কুলি কেৎ কুয়ায়্য় য়, আপেয়া পাতিয়াও দ কদেরে? তা পে আপেয়া পাতিয়াও দ? ইঙ্কূ দ বর ঠাকে না আর আকু-আকু গে গামে নাকু, ইন দ ভেলে অকয় তানায়, ইনি অকয় দ হয় আর দা কে হুকুমমা কিত্ কিন খানয় আর ইঙ্কিন দ ইনি রাঃআ হুমুকে মানা/আয়ুম কেয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ইনা তায়্ম যীশু হেতাৎ চেলা দ গেরাঃআসেনি দিশুম তেকু হিচ সেটের এনা, ইন অকা দ গালিল ঝিল্লি রাঃআ হানা সায় রে মেনা। ");
INSERT INTO cdz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ইনি আড়া/ঢিপি রে আড়গু থরাঃআ, বংগা-লাঠা কানায় নাগর রিনিজ মিয়াত হড় ইনি রাঃআ হান্ডে হিচে নায়। নি দ গাদা মাহা হুলাং হাতেন কিচি কায় অয়র র কেনায়, অটঃ হ অড়া রেগে কা তাহীন কেনায়। মেন্খান তপা-তাইয়াদ কুরেগে তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","যীশু কে নেল নাম থরাঃআ ইনি কিকিচ কিইয়ায়্য়, হেৎদ যীশু সামাং রে তাবের রেন তে গাম কিইয়ায়্য়, ইঞ লো দ আমাঃ কিনা সম্পর্ক/আপুস কানতামা/কানতানা? এ যীশু চট-উতারিচ ঈশ্বর রাঃআ হন। নেহর রাঃআ কান তানা মাই আলম সাতাও ইঞ আ। ");
INSERT INTO cdz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","যীশু কা/বিন-সাপা আত্মা কে ইনি হড় রাঃআ হাতেন বাহার উডুং অ নাতিনাং হুকুমা কিয়ায়, চিয়াঃচি ইনিলো গাদা মাহা হাতেন লাঠা দঃহ লেনায়, ইনাতে শিকরি/ঝিনঝিরি আর বেড়ি/বিড়ি তে তলা/তল কাতেয় কু হর দঃহ কেয়ান/কেনাকু রহ/হ, ইনি দ তল লা কু যত টটা খানডিজ-খুনডুইজ কাতে বঙ্গা রাঃআ হান্ডে হাতেন হাহানকার তেয়ে সেএনায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","যীশু ইনিকে কুলিকিয়ায়, আমাঃ নুতুম কিনা? ইনি গামকিইয়ায়্য়, বাহিনী/ফোউদ, চিয়াঃচি গাদা লেকা বঙ্গা লাঠা লেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","বঙ্গ কুদ যীশু কে ঘনে ঘনে নেহর রাঃআ কিয়াকু, যাতে ইনি ইঙ্কূ কে আথান কুন্দ তে সেন আলোয় হুকুম মা কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","এন্ডে বুরু রে আতিং তানা/তান ঢের উতার মিয়াত সুকরি রাঃআ পাল কু তাহীন কেনা। বঙ্গা কুদ ইনিকে নেহর রাঃআ কিয়াকু, যাতে আকুকে ইঙ্কূ সুকরি কুরাঃআ হান্ডে বলঃঅ নাতিনাং আড়া কুকায়, হেত তে ইনি আড়া কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","এন্খান গে বংগা কু ইনি হড় রাঃআ হান্ডে হাতেন উডুং-হিচ কাতে সুকরি কুরাঃআ হান্ডে বলয় নাকু। হেৎদ সুকরি কুদ ধাড়কান হাতেন ঝিল/তালাও রে লাৎ -লাৎ কু নুরে না আর ডুমবুইজ গজে নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","সুকরি গুপি কুকু নেলকেয়া, কিনা কিনা হুয়ে না মেতেন, হেততে ইঙ্কূ দুকু নির কাতে সেএ নাকু আর শেহার রে আর দিশুম-দিশুম/হাতু হাতু/টলা-টলা থুতি কু গাম পাসরাঃআ কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ইন্তং কিনা হুইলেনা, নেল নাতিনাং হড়কু বাহার উডুং এনা, হেৎদ যীশু রাঃআ হান্ডে হিচ সেটের/হিচে নাকু খান কাতে নেল কেৎয়াকু, যে ইনি হড় অকয় রাঃআ হান্ডে হাতেন বঙ্গা উডুং য়েন দয়, অয়রাঃআ কানায় আর ধীর মনেতে যীশু রাঃআ কাটা হেদে রে দুবা কানায় নাম কিয়াকু, আর বর কেৎয়াকু /বরয় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","আর অকয় কু নেল লাআকু। আর ইঙ্কূ নেল লেত কুদ বঙ্গা লাঠা হড় চিল্কা লেকাতে বুগি য়ে নায় হড় কু গাময়েত কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","গেরাঃআসেনি এন্ডে রেঙ্কূ যতচ হড়কুদ বরয় নাকু, আর যীশু কে নেহর রাঃআ কিয়াকু, যাতে আকুয়াআ ঠাইন হাতেন নির জম কায়, ইনাতে লাউকা রে দেচ কাতে ইনি রুয়াড় সেএ/হিচে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","অকয় রাঃআ হান্ডে হাতেন বঙ্গা উডুং লেনায়, ইনি হড় দ হানিলো তাহীন নাতিনাং আরজ এনায়। মেন্খান ইনি কে কয়্তুকা কাতে গাম কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","অড়া রুয়াড় সেনমে, আর ঈশ্বর আম নাতিনাং চিনতি মাড়াং আ কামি তায়ায়, মেনতে গাম সাডি মে। হেৎদ ইনি দয় রুয়াড় সেন এনায়, আর আয় নাতিনাং যীশু চিনতি মারাঃআং আ কামী তায়ায় মেনতে গোটা শেহার রে গাম পাসরাঃআ কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","নাহা নিনতং যীশু রুয়াড় য়েন খান গাদা লেকা হড় ইনিকে আতাং দারাঃআম কিয়াকু, হেততে যত হড় এন্ডেগে ইনি কে নেল নাতিনাং তাংগি রেকু তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","হুডাং মাড়াং তে যায়ী নুতুম মিইজ মিয়াত হড় হিচে নায়, ইনি অকয় দ সমাজ/পাড়হা অড়া রিনিজ মিহুড় মুখিয়া তাহীন কেনায়। নিই দ যীশুরাঃআ কাটারে তাবের গিডি নায়, আর আয়া অড়া তে সেন নাতিনাং নেহরাঃআ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","এন্তে গেল বার সির্মাং রিনিজ মিয়াত তেত সাধের/এসকার হনরাঃআতেত তাহীন কেন তেয়ায় ইনি দ নেএ গজআয় নাতিনাং তাহীন কেনায়। হেৎদ যীশু চিনতং সেন কেনায়, ঢের/গাদা হড়ক দুকু লিম্বুদ/তিকা-রেনঢেত ইদিয়ে য়েত কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","অটঃ মিয়াত এরাঃআহন, অকয় গেল বার সির্মাং হাতেন প্রধল রোগ তেয়/মায়ম সেনঃতান ভুগা কেনায়। ইনি রাঃআরাঃআন কো/রাঃআনুনি রাঃআ হান্ডে আয়া যত ভাঙ্গা/খরচা চাবা কিইয়ায়্য় অকা আয়া হান্ডে তাহীন কেনা। মেন্খান যাহায় হ কাকু বুগি দাড়ি লিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","নিই দ তায়ম দর হাতেন হিচ কাতে, ইনি রাঃআ কিচি রাঃআ চাল রে জুটিজ কেৎ তেয়া আর ইনা ঘাড়ি গে ইনি রাঃআ মায়ম সেনঃ মুচাৎ এ না। ");
INSERT INTO cdz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ইন্তং যীশু হান্তে নাতে কয় কাতে কুলি কেৎ কুয়ায়্য় য়, ইঞ কে দ অকয় জুটিজ কিয়া কু? যতচ গে অহগে/কাগে গামকেৎয়াকু খান, পিতর আর ইনি রাঃআ গাতিকু গাম কেৎয়াকু, গমকে/এ গুরু, হান্তে নাতে হাতে গাদা হড় কু গে মা তিড়সা আর তিকা ইদি কেয়া মাকু। ");
INSERT INTO cdz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","মেন্খান যীশু গাম কেয় কুয়ায়্য় য়, যাহায় গে জুটিজা তিং গেয়ায়, ইনাতে ইঞ আ হাতেন দাড়ি উডুং য়েন তান আটকার কেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ইনি এরাঃআ হন নেল কিইয়ায়্য়, যাহানা উকু বায়ায় না আয় দয় সারি নাম কিইয়ায়্য় মেনতে ইনাতে থার-থারও কাতেন হিচ -মাড়াং এনায়, ইনি রাঃআ সামাং রে উকুড়ুম এনায়, যত হড় কুরাঃআ সামাং রে গাম সদর কিইয়ায়্য়, যে চিয়া জুটিজ লিয়ায় আর চিল্কাতে ইনা ঘাড়ি তেয়েগে বুগি নায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","যীশু গামকিয়ায়, এ বুড়ি, আমকে দ আমাঃ পাতীয়াও গে বুগি কেৎ মেয়ায়। দু সুলুক তে সেন জম মে। ");
INSERT INTO cdz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","যীশু থুতি তায়ম, পাড়হা/সমাজ অড়া রিনিজ মুরুব্বি রাঃআ অড়া হাতেন মিয়াত হড় হিচে নায়, আর ইনি গামকিইয়ায়্য়, হনারাঃআতামা দ গজা কানায়, নাহা আমাঃ গুরু আর অটঃ আলম সাতাও ইয়আ। ");
INSERT INTO cdz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","যীশু ইনা আয়ুম কাতেন, সমাজ অড়া রেনিচ মুরুব্বি জাইরাস কে গাম রুয়াড় কিয়ায়, আলম বর আ, একেন পাতিয়াও মে আর ইনি বানচাও মায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ইনা অড়া রে সেটেরেন খানয়, পিতর, যোহন হেৎদ যাকোব অটঃ কুড়িহন রাঃআ এঙ্গা-আপু তেত তুকু ছাড়া, আয়লো অকয় হঅ কাকু বলঃঅ তকা লা কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ইন্তং যতচ ইনি রাঃআ নাতিনাং ইয়াম এনাকু/কেৎয়াকু হেৎদ হমরেত তাহি কেনা, ইনি গাম তানা কুয়ায়্য় য়, আলপে ইয়ামা, ইনি কা গজা কানায়, একেন গীতিজা কানায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ইঙ্কূ দ ইনিকে লান্দাই কিয়াকু, ইঙ্কূ সারিয়া কু ইনি দ গয় জা কানায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","মেন্খান ইনি রাঃআ তিহি সাব কাতে রাঃআ কিয়ায়, বুড়ি বিরিৎ মে। ");
INSERT INTO cdz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ইনাতে ইনি রাঃআ জিউ দ রুয়াড় য়েন তায়া, আর চিদগি বিরিৎ এনায়। হেৎদ ইনিকে জমা এম নাতিনাং গামকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ইনি রাঃআ মাইতেত বাঃতেত তিকিন হায়কাট এ নাকিন, মেন্খান ইনি ইনকিন কে হুকুম মাত কিনায়, চিল্কা হুই আকানা, অকয়কে হ আলোকিন গাম কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","হেৎদ যীশু ইঙ্কূ গেল বার চেলা কে মিসাতে রাঃআ হুন্ডি কেৎ কুয়ায়্য় য়, যত বঙ্গা চেতানরে আর রোগ বুগি রাঃআ নাতিনাং দাড়িয়ান এম কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","আর ঈশ্বর রাঃআ রাঃআজ্য গাম ঘুরাঃআ হেৎদ রুগী বুগি নাতিনাং কুল কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","অটঃ হ যীশু ইঙ্কূ কে গাম সাডি কেৎ কুয়ায়্য় য়, হরাঃআ রাঃআ নাতিনাং জাহানা হ আলোপে ইদি ধরাঃআ য়া, ঠেঙ্গা হ লোহয়, ঝোলা হ লহয়, পিঠা হ লহয়, টাকা-পয়সা হ লহয়, আর অকয় হ বারিয়া আনগাও আলপে ইদি ধরাঃআ য়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","যাহা অড়া রেগে বলঃঅ না, এন্ডে গে তাহীন পে আর এন্ডে হাতেন গে কয়্তুকা ও পে। ");
INSERT INTO cdz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","বাত্লাৎ কেৎকুয়া, আর অকা হড় কু কাকু, আতাং-দারাঃআম পেয়া, ইঙ্কূ য়া শেহার হাতেন উদুঙ অ- হিজু বেড়ারে, ইঙ্কূ নাতিনাং সাক্ষ মেনতে, আপেয়া কাটারাঃআ ধুড়ি কটা গিডি তকায় পে। ");
INSERT INTO cdz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","হেৎদ ইঙ্কূ চেলা দ কয়্তুকা হাতা কাতে, নাতে-হানতে রাঃআ হাতু-হাতু দাড়া কাতে, যত জায়গারে বুগিন-সংবাদ পরচার কেৎয়াকু। আর হড় কুকে বুগি-ভাড়া কেৎ কুয়ায়্য় কু। ");
INSERT INTO cdz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","গালিলি রেনিজ রাপাজ হেরদ পন্তিয় দ যতগে আয়ুম কিইয়ায়্য়, অকা-অকা হুইয় নেনা, আর হালবাল চায় নায়, চিয়াচি অকনি/জেতান/জেতানি হড় কু গামে কেনাকু, গয়ঃ কু হাতেন যোহন বিরিৎ রুয়াড় আকানায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","এটাকু দ গাম লাগায় নাকু, এলিয় হিচ রুয়াড় কানায়, আর এটাকু দ গামে তানাকু, মুসিং রিঙ্কূ ভাবি-জাগারিজ কুরাঃআ হাতেন মিহুড় জিউত বিরিজা কানায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","হেৎদ হেরদ পন্তিয় গাম কিইয়ায়্য়, যোহন রাঃআ মা ইঞ গে বহঃ মা-আ খানডিত তাইঞ, মেন্খান ইনি অকয় তানায়, অকয় রাঃআ বাব্ত্তে নেন্কা আয়ুম মে তানাই, আর ইনি আনিকে (যীশুকে) নেল এড়েম উডুং এনায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","কুলিচকু কু হিচ রুয়াড় য়েন খানয়, আকুকু কামীকেৎ যতচ া বাবদ যীশু কে গাম কিয়াকু, ইনি দ ইঙ্কূ কে ইদি ধরাঃআ কেৎ কুয়ায়্য় য়, বৈতসদা নুতুম মান মিয়াত শেহার /নাগর তে সেএ নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","মেন্খান হড়কু সারি নাম কাতে আয়া তায়ম তে হিচে নাকু, ইনি হেৎদ ইঙ্কূ কে আতাং দারাঃআম কেৎ কুয়ায়্য় য়, ঈশ্বর রাঃআ রাঃআজ্য রাঃআ বাব্ত্তে তে গামাৎ কুয়ায়্য়। বুগি য়া চাবা রাঃআ জরুর তাহীন কানা হড় কুদ বুগি কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","বেলা হাসুড় এনায় খান, ইঙ্কূ গেলবার চেলা হিচ কাতে ইনিকে গাম কিয়াকু, আম নিকু হড়কুকে কয়্তুকা এমকুম, যাতে ইঙ্কূ হাতু আর ধারে-পাশে টোলা কুরে সেন কাতে কু ডেরাঃআয় আর জমাকু নাম জম/নেল জমে কাকু, নেন্ডে দ নিঝুম/সুনসান জায়গারে মেনা বুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","হেৎদ যীশু গামাৎ কুয়ায়্য় , আপেগে ইঙ্কূ কেগে জমা এমাকূপে, মেন্খান ইঙ্কূ কু গাম কেয়া, মরেয়া পিঠা আর বাড়িয়া হাকু ছাড়া অটঃ জাহানা বায়ায় তালেয়া, কিনা তবে গামে তানা পে, আলো তেগে সেন কাতে নিকু যত হড় কুয়া নাতিনাং জমা লে কিরিং আউ লেয়ালে। ");
INSERT INTO cdz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","এন্তে মরে জুলু কড়া হন। ইনি দ আয়া চেলা কুকে গামাৎ কুয়ায়্য় , হড় কুকে মরে গেল কাতে, ভাগ-ভাগ দুব কেৎ কূপে। ");
INSERT INTO cdz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","হেৎদ ইঙ্কূ চেলা এনকা কেৎ গেয়ায়, আর যতচ কে দুব কেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","পরে ইনি ইনা মরেয়া পিঠা আর বারিয়া হাকু হাতা কাতে সিরমা দর আরিচ রাঃআকাব কাতে ইশ্বর কে আশিষ কাতে কেচা কিইয়ায়্য় আর হড় কুকে হাটিং আকুয়াআ কু নাতিনাং চেলা কুকে এমাতু কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ইনাতে যত হড় কু জম বি নাকু, হেৎদ ইঙ্কূ অকা তাহি-রুয়াড় না, ইনা যত খান্দিজ-খুন্দুইজ কু হাউর হুন্ডি কিইয়ায়্য় খান গেলবার ঝুড়িয়া হুইয়ে না। ");
INSERT INTO cdz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","মিৎ হুলাং যীশু আয় একলা কছাড় রে কয়-জং কেনায়, এখেন চেলা কু তেয়া দ আয় লো গে তাহি কেনা, হেৎদ যীশু ইঙ্কূ চেলা কে কুলি কেৎ কুয়ায়্য় য়, হড়কু ইঞ অকয় তানা মেন তেকু গামেয়া। ইঞ অকয় নিয়া মেনতে হড় কু কিনা গামে তানাকু। ");
INSERT INTO cdz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ইঙ্কূ গাম রুয়াড় কেৎয়াকু, যোহন বাপ্তাইজ, মেন্খান এটা এটা কুদ এলীয়, অকনি/জেতান/জেতানি হড় কু গামে কেনাকু, মুসিং রিঙ্কূ ভাবি-জাগারিজ কুরাঃআ হাতেন মিহুড় জিউত বিরিজা কানায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ইন্তং যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় , এন্খান আপে কিনা গামে তানা পে/গামেয়া পে, ইঞ অকয়? পিতর গাম রুয়াড় কিইয়ায়্য়, আম দম ঈশ্বর রাঃআ খ্রিষ্ট তানাম। ");
INSERT INTO cdz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ইন্তং যীশু ইঙ্কূ চেলা কু কে হুকুম মাত কুয়ায়্য় য়, ইঞ অক্য়য় তানাং মেন্তে, নিয়া থুতি যাহায় কে হ আলকু গাম ভাড়া কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","যীশু গামাৎ কুয়ায়্য় , মানমি হন দ আশু দুখ সাহা হুয়ুয়া তায়া, মুরুব্বি, মারাঃআং বামড়ে, আর সাস্তর গ্সায় কু কাকু ছুতাং ইয়া, গজ হুইয়আ/গজ আয় আর আপি মাহা হুলাং রে জিউত রুয়াড় আয়। ");
INSERT INTO cdz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","হেৎদ যীশু যত হড় কে গামাৎ কুয়ায়্য় , যাহায় হড় ইঞ আ তায়ম তে হিজু সানাং তেত কু খান, ইনি দ আয় তেত কে রিনতি/দাদদ/অস্বীকার অ কায় আর মাহা হুলাং আয়া ক্র্রুশ গঅয় কায় আর ইঞ কে পিছাইঞ কায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","চিয়াচি অকয় গে আয়া জিউ বাঞ্চাও সানাং ইয়া, ইনি দ ইনা আদে আয়, মেন্খান অকয় গে ইঞ আ নাতিনাং আয়া জিউ আদে আয়, ইনি দ ইনা বাঞ্চাও আয়। ");
INSERT INTO cdz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","এন্ডে খান মানমি গোটা ধারতি লাভ কাতে হঅ আয়্তেত গে আদ আয় বাংখান নষ্ট আয়। তবে কিনা ফায়দা হুইয়া তেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","চিয়াঃচি যাহায় গে ইঞ অটঃ ইঞ আ জাগার কুতে গিউ গুয়াকু, মানমি হন হ গিউ গয়ায়, চিনলং ইনি আয় হেৎদ আয়া আপুতেত অটঃ রিলামাল সরগ নাগা কুয়া আদাল তে হিজু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","মেন্খান ইঞ আপেকে সার্তিগে গামতানাপিং, যাহায় নেন্ডে তিঙ্গুয়াকানাকু, ইঙ্কূ য়া তালারে এনকান হড় হ মেনাকুয়া, অকয় চিমিনভুর ধাবিজ ঈশ্বর রাঃআ রাঃআজ্য কাকু নেলেয়া, ইমিনভুর ধাবিজ গয়ঃজ কাকু চাখা নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","নিয়া যত থুতি গাম চাবা কাতে, ইরিল/ইরিলিয়া মাহা হুলাং তায়ম, যীশু দ পিতর, যোহন হেৎদ যাকোব কে আয়লো ইদি ধরাঃআ কাতে, কয় জং নাতিনাং বুরু চেতান দেজেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","চিনতং যীশু কয় জং এ কেনায়, ইন্তং ইনি রাঃআ মেদ-মুহাড়/মুখান মুরুত দ্ পাল্টায় না। আর ইনি রাঃআ কিচি দ পুন্ডি ধপ-ধপ/পিরিত-পিরিত হেদতে ঝালকায় না। ");
INSERT INTO cdz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","আচকা গে বার হড় ইনিলো থুতি তানাকিন, ইঙ্কিন দ মহিমা/প্রতাপ তে সদরাঃআ কানাকিন মোশি আর এলীয়, তিকিন কিন থুতি কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","আর ইনি রাঃআ সামাং সামিং থুতি কেনা কিন, আয়ায়্য় গজ নাতিনাং, ইনা অকা যীরুশালেম রে পুরাঃআ নাতিনাং তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ইন্তং পিতর হেৎদ পিতর রাঃআ গাতি কু ঝপ-ঝপ দুদ্রুম মে কেনাকু, মেন্খান চিরগাল -বিরিৎ কেৎ কুয়ায়্য় য় খান ইঙ্কূ ইনি রাঃআ প্রতাপ/মহিমা আর ইঙ্কিন বার হড় কে কিন নেল কেৎ কিনায়, অকয় দ ইনিলো তিনগু তাহীন কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","হেৎদ ইঙ্কূ দ ইনি রাঃআ হান্ডে হাতেন বাই তকা কাতে সেন কেনায়, ইন্তং গে পিতর যীশু কে গাম কিয়ায়, এ গুরু, এলে দ নেন্ডে লে তাহি লেখান বেশ কুয়া হুনাং, আলে দ আপিয়া কুম্বা অড়া লে বানাআ, মিয়াত দ আমাঃ নাতিনাং, মিয়াত দ মোশি রাঃআ নাতিনাং আর অটঃ মিয়াত দ এলিয় রাঃআ নাতিনাং, মেন্খান ইনি কিনা গাম কিইয়ায়্য়, ইনা আটকার কাকু দাড়ি লা। ");
INSERT INTO cdz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","হেৎদ নিয়া তানায়, ইন্তং গে মিয়াত রিমিল হিচ কাতে ইঙ্কূ কে উম্বুল কেৎ কুয়ায়্য় য়। ইনাতে ইঙ্কূ ইনা রিমিল রেকু বলয়েন খান বর কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","আর ইনা রিম্বিল হাতেন নিয়া আড়াঙ আয়ুমে নামেনা, নিই গে ইঞ আ হন তিংআ, ইঞ আ বাছায়িত। নিঃ রাঃআ থুতি আয়ুম মে পে। ");
INSERT INTO cdz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","নিয়া আড়াঙ আয়ুম নাম থর একলা যীশুকে নেল নামেনায়। হেৎদ ইঙ্কূ থির তাহীনাকু, অকা অকা নেল লা আকু, ইনারাঃআ যাহানা ইন্তং যাহায় কেহ কাকু গাম ভাড়া লা কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","দশার হুলাং বুরু হাতেন আড়গুন খানয় গাদা লেকা হড় আয়লো নাপাম এ নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","আচাকাগে লাৎ -লাৎ হড়কুয়া তালা হাতেন মিয়াত হড় জোর তে কিকিচ গদ কিইয়ায়্য়, এ গুরু নেহর রাঃআ তানামাই, ইঞ আ হন তিংআ রাঃআ দর কয়অম, চিয়াচি নিই/ইনি গে ইঞ আ হনতিংআ। ");
INSERT INTO cdz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","আচকা গে মিয়াত আত্মা লাঠা এয়া কানা আচকা গে কিকিচ কিইয়ায়্য়, হেৎদ ইনি হানিকে মচড়া সাব কিয়ায়, ইনাতে ইনি রাঃআ মচা হাতেন ফেনা উডুং এনা, আর ইনিকে তাবা কিয়ারাঃআ তায়ম বাই/বাগিয়া কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ইঞ আমাঃ চেলাকুকে নেহর রাঃআ লা কুইঞ, যাতে ইঙ্কূ নিইকে/ইনিকে উডুং গিডিই কাঃআকু, মেন্খান ইঙ্কূ কাকু দাড়ি লা। ");
INSERT INTO cdz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ইন্তং যীশু গাম রুয়ার কেৎ কুয়ায়্য় য়, এ বিন-পাতিয়াও হেৎদ পেরতা কুল রিঙ্কূ, তিমিন ধাবিজ ইঞ আপে লো তাহি নাই, চিমিন ধাবিজ ইঞ দ সাহাওতা পেয়াইঞ। আমাঃ হনতামা কে নেন্ডে আগুইম। ");
INSERT INTO cdz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","হন রাঃআ আপু তেৎকে যীশু গামা কিয়ায়্য়, হন কে এগুইম, ইনি হিখড়ম না য়, ইন্তং গে ইনি বংগা ইনিকে অতেরে তাবা কিয়ায়, আর মচড়া-মুচড়ি কিয়ায়। মেন্খান যীশু বিন বুগিন আত্মাকে ধমকাঃআ কিয়ায়। হন টাকে বুগি কিয়ায়। হেৎদ আয়া আপুতেত রাঃআ হান্ডে জিমা-রুয়াড় কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ইন্তং যত হড় ঈশ্বর রাঃআ মাড়াং দাড়ি ইয়াতে হায়কাট এনাকু। হেৎদ যত হড় ইনি রাঃআ কামী যত য়া কুতে কুঠিনগে মাহিল/চমকায় নাকু খান ইনি আয়া চেলা কুকে গামাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","নিয়া থুতি কু আপেয়া লুতুর রে রেবেদ দহয় পে। মানমি হন দ বাইরি হড় কুয়া তিহিরে সাব-তকাই আকু ঘির মেন্তাং গে হাআ। ");
INSERT INTO cdz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","মেন্খান ইঙ্কূ নিয়া থুতি কু কাকু আটকার দাড়ি লা। ইনা ইঙ্কূ য়া হান্ডে উকুরে গে তাহিনা। যাতে ইঙ্কূ আলো কু আটকার নাম দাড়িকাঃআ। হেৎদ ইঙ্কূ ইনিকে নিয়া থুতিকু গাম তে বর কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","হেৎদ চেলা কুয়া তালারে মিয়াত টকরাঃআর/নিয়া-নিপাইয়া/লেথা রাঃআকাব/জানাম এনা, এন্তে আকুয়াআ তালা রে অকয় মারাঃআং গেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","মেন্খান যীশু ইঙ্কূ য়া মনে ভীতির রাঃআ টঘাট আটকার নাম কাতে মিয়াত হুডিঙ হন সাব আগুকিয়ায় হেৎদ আয়া হেদে/কাতারে তিঙগু কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","হেৎদ ইঙ্কূ কে যীশু গামাৎ কুয়ায়্য় , যাহায় নিঃই হুডিং হন কে ইঞ নুতুম তে দারম মিয়াকু, ইনি দ ইঞ কে গে দারম ইদি আয়ঞ, আর যাহায় ইঞ কে দারম ইদিং কিং খানয় ইনি, কে গে দারম ইয়াঞ অকয় ইঞ কে কুল তিয়াঞ। এন্তে আপে যতকু তালা হাতে অকয়্য় হুডিং উতারিচ গে মারাঃআং ওয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","যোহন গাম গদ গেয়ায়, এ গুরু আলে মিয়াত হড়কে আমাঃ নুতুম তে বঙ্গা ছাড়া নেল লিয়ালে, ইনি কে মানা লিয়ালে, চিয়াঃ চি ইনি দ আবুকে কায় পিছা কেনা বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","মেন্খান যীশু ইনিকে গাম কিয়ায়, আলপে মানা/বারণ ইয়া, চিয়াঃ্চি অকয় আপেয়া বিরূধ রিনিজ লহয়, ইনি আপেয়া দর রিনিজ গে। ");
INSERT INTO cdz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","চিনতং আয়া সেরমা তে রাঃআকাব সেন রাঃআ মাহা সেটের হিচে না, ইন্তং গে ইনি যীরুশালেম তে সেন আয় মনে রে মুরুক/মুরুদ/ঠারাঃআও এনায়/দঃহ কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","আর আয় মাড়াং তে আয়া ইদি-আগু/আগুয়াদার কুকে কুল কেৎ কুয়ায়্য় য়। ইঙ্কূ দ সমরীয় রাঃআ মিয়াত হাতু তেকু বলয় না। যাতে ইনি রাঃআ নাতিনাং তেয়ার হাতাড়া। ");
INSERT INTO cdz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","মেন্খান হড় কু কাকু তেলাও/পুছা/আতান লিয়া, এন্তে ইনি দ যীরুশালেম তে সেন আয় নাতিনাং মনে ঠারাঃআও এনায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ইনা নেল কাতে আয়া চেলা যাকোব হেৎদ যোহন কুলি কেয়াকিন, এ গুরু, আম কি নানাম-তানাম/নানা-মাম এলিয় চিলকা লেকা লাআয়, এনকা আবু গামেয়া বু, চেতান হাতেন সেঙ্গেল আড়গু হিচ কাতে ইঙ্কূ কে রাঃআপা-রঙ্গ চা কুয়ায়্য় য় ? ");
INSERT INTO cdz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","মেন্খান ইনি বিউর/মচা ঘুরাঃআ কাতেন ধমকাঃআ কেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","হেততে ইঙ্কূ দ এটা হাতু তেকু সেএ না। ");
INSERT INTO cdz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","যীশু হেৎদ ছেলা হরাঃআ-হরাঃআতে সেন কেনাকু, মিয়াত হড় যীশুকে গামা কিয়ায়, আম যাহাদর গেম সেনয়া, ইঞ দ আমাঃ তায়ম তে সেন আইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","যীশু ইনিকে গাম কিয়ায়, তুয়ু কুরাঃআ ভূউ মেনা তাকুয়া, আর চেতান রিঙ্কূ য়া অড়ে রাঃআ ডাইররে তুকা মেনা তাকুয়া, মেন্খান মানমি হন রাঃআ দ বহ দহ রাঃআ জায়গা বায়ায় না। ");
INSERT INTO cdz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","অটঃ মিহুড় কে যীশু গাম কিয়ায়, ইঞ আ তায়ম তে হিজু ম, মেন্খান ইনি গাম কিইয়ায়্য়, প্রভু, মাড়াং ইঞ আ আপুইঞ কে তপা নাতিনাং সেন তকাইঞ লিং মে। ");
INSERT INTO cdz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","যীশু ইনিকে গামকিয়ায়, গয়চ কু গেদ আকুয়াআ আত্মিক তে গয়চ কানাকু লিয়া তপা তুকা কুম। আম দ সেন কাতে ঈশ্বর রাঃআ রাঃআজ্য গাম পাসরাঃআয় মে। ");
INSERT INTO cdz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","অটঃ মিহুড় গাম কিইয়ায়্য়, প্রভ, ইঞ আমাঃ তায়ম তে সেনাইঞ, মেন্খান, মাড়াং ইঞ আ অড়া সেনকাতে অড়া হড় কুরাঃআ হান্ডে হাতেন কয়্তুকাহাত নাতিনাংসেন তকা লিং মে। ");
INSERT INTO cdz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","যীশু ইনিকে গাম কিয়ায়, অকয় হড় নাহাল রে তিহি এম কাতে তায়ম দর দ কায় আরিদ-রুয়াড় ইয়ায়। ইনিগে ঈশ্বর রাঃআজ্য রাঃআ লেক তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","নিয়া তায়মতে প্রভু এ ইয়াই হিসি/সত্তর জন এটা চেলাকুকে ঠারাঃআও/বাহাল কাতে আয়া মাড়াংতে যত শেহার হেৎদ জায়গা/থানতে বার হড়কাতেন কুলকেৎ কুয়ায়্য় য় কদের আয়কে সেন সানা/সানাং লিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ইনি ইঙ্কূকে গামকেৎ কুয়ায়্য় য়, ইরঃদ গাদালেকা মেন্খান মুনিস/কামিয়ানকু দ হুডাং লেকাকু/গেয়াকু, ইনাতে/ইনামেন্তে আপে, ইনি আয়া ইরঃ বাইততে মুনিস/কামিয়ান কুকে কুলকুকায় মেন্তে ইরঃ মালিককে/গিরিহাকে বিন্তিপে। ");
INSERT INTO cdz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","মার সেনঃপে, নেলেপে, চিল্কা হুন্ডারকুয়া তালারে ভিডি ইঙ্কূলেকাগে আপেকে কুলতাআপিং। ");
INSERT INTO cdz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","আপে থাইলি, ঝোলা, কারপা আল্পে ইদিয়া অটঃ হরাঃআকুরে যাহায় কেহ আল্পে জোহারকুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","যাহা অড়ারেপে বলঃনা, মাড়াং রে গামেপে নিয়া অড়া রেদ সুলুক হুইঃঅকা! ");
INSERT INTO cdz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","সুলুক নাম লেকানইজ হড় এন্ডে মেনাইখান আপেয়া সুলুক/শান্তি দ ইনিরে তাহিনয়া, বাংখান দ ইনা আপেতে রুয়াড় আ। ");
INSERT INTO cdz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","হেৎদ ইনা অড়ারেগে তাহীনঃপে হেৎদ ইঙ্কূ অকা এমাপেয়াকু জম নুই পে, নলানি/হাকদার দ আয়া নলা/হাক নামেআয়/নাম লেক তানায়। অড়া অড়াঃ আলপে অচ-উচাড় ভাড়া আ। ");
INSERT INTO cdz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","যাহা শেহার রেপে বলরেদ, হড়কু দারম পেয়া খান, জমেপে অকা আপেয়া সামাং রে এমা আকানা। ");
INSERT INTO cdz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","এন্ডে রুয়া-হাসুতানকু বুগিকুপে, হেৎদ ঈশ্বর রাঃআ রাঃআজ্য আপেয়া কাতাতে/ঠাইঙতে হিচ সেটেরাঃআ কানা গামকূপে। ");
INSERT INTO cdz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","মেন্খান যাহা শেহার রেপে বলরে হড়কু কাকু দারম পেয়া খান, ইনারাঃআ কুলহি কুরে উডুঙ কাতে গামেপে। ");
INSERT INTO cdz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","আলেয়া কাটারে লাঠাকানা আপেয়া শেহার রাঃআ ধুড়ি লে কটা গিডি এতানা। ইনা তেরেহ/মেন্খান নিয়া হ সারি দহয় পে, ঈশ্বর রাঃআ রাঃআজ্য আপেয়া কাতাতে/ঠাইঙতে হিচ সেটেরাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ইঞ গাম তানাপিং, ইনা হুলাং ইনা শেহার রাঃআ দুখঃ হেতেন সদোম রাঃআ ঢের দুখঃ সাহা-আ-তাইঞ লেকাওআ। ");
INSERT INTO cdz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","আমহঅঃ হায় হায় এ কোরাঃআসিন দিসুম, আমঅঃ হায় হায় এ বৈথসইদা দিসুম আবেনরে হুয়াকানা পেড়েঃআন/দাড়িয়ান কামী দ সোর দিসুম হেৎদ সিদোন দিসুম রেঙ্কূয়া তালারে হুই লেন খানঃ, এন্খান দ মাড়াং রেগে ইঙ্কূ বয়র/বরাঃআ কিচি অয়রকাতে হেৎদ তরেজ রে দুবকাতে, মন ঘুরাঃআ রুয়াড় কেৎয়াকু হুনাং। ");
INSERT INTO cdz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","মেন্দ/মেন্খান ধরবার হুলাং রে আবেন হাতেন/হেতেন সোর হেৎদ সিদোন রাঃআ দুখঃ সাহা-আ-তাইঞ লেকাওআ। ");
INSERT INTO cdz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","হেৎদ আম, এ কফরনাহূম, কিনা আম সেরমা ধাবিজ রাঃআকাবোঃআম? বানোঃগে আম পাতাল পুরিতেম আড়গুঃআম। ");
INSERT INTO cdz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","অকয় গে আপেকে মানাপেয়াকু/আয়ুমপেয়াকু, ইঙ্কূ দ ইঞ কেগে মানাইঞাকু/আয়ুম মিয়াকু, অকয় আপেকে হীনসাতি পেয়াকু/কাকু গ্রহণ পেয়াকু, ইঙ্কূ গে ইঞ কে হীনসাতি এ আকু/কাকু গ্রহণ নিয়া কু। অকয় গে ইঞ কে হীনসাতি এ আকু/কাকু গ্রহণ নিয়া, ইঙ্কূ গে কুকুলিনিঃএ হীনসাতি এ আকু/কাকু গ্রহণ নিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","হেৎদ ইঙ্কূ আপি হিসি গেল/সত্তর জন দ রাঃআসকাতে রুয়াড় কাতেন, গামেতানাকু, এ প্রভু আমাঃ নুতুম তে এট্কান বংগাকুহ আলেয়া বাগতরে তাহিনাকু/বশরে তাহিনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ইনি ইঙ্কূকে গামকেৎ কুয়ায়্য় য়, শয়তান হিচির লেকা সেরমা হাতেন আড়গুঃতানাইঞ নেলকিয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","নেলেপে ইঞ বিংকু হেৎদ মারমার কু তিকাসেরেদ কূপে হেৎদ বাইরি গোটা পেড়ে/একতিয়ারইঞ এমেদপেয়া হেৎদ যাহানাতে কাপে দুকুওঃআ/ক্ষতিয়াআ। ");
INSERT INTO cdz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","নিয়া তেরেঃহ/তুবুই রহ বংগাআত্মা কু আলেকুকে মানাতিংলেতানা/মনতিংলেতানা মেন্তে আলপে রাঃআসকাওআ, মেন্খান আপে হঃ নুতুম সেরমা রে অলআকানা নিয়াতে রাঃআসকাওপে। ");
INSERT INTO cdz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ইঞ তং গে/ইনা ঘাড়িগে যীশু রিলামালা আত্মা রাঃআসকায় নায় হেৎদ গামকিইয়ায়্য়, এ বাঃআ, সেরমা হেৎদ অতে/ধার্তি রিনিজ প্রভু, ইঞ আমা প্রশংসায় তানাইঞ, চিয়াচি আম সেড়ানকুরা/জ্ঞানিকুরা হেৎদ বুদ্ধিমানকুরা হাতেন নিয়া বাব্ত্তে কু/থুতিকু উকু-দানাং দঃহঅ কাতেন বালেজ হনকুরা হান্ডে সদরতাৎ আম। ");
INSERT INTO cdz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","আপুইঞ যতচ াএ এমতকাতিংআয় হেৎদ আপু বাগিকাতে হন অকয় তানিই নিয়া যত কাকু সারিয়া হেৎদ হন বাগিকাতে হেৎদ হন উদু সনাজঃঅই হড় বাগিকাতে আপু অকয় তানিই নিয়া যত কাকু সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","হেৎদ আয়হ চেলা কু ঘুরাঃআরুয়াড় কাতে, আপে নেলজদতেঅ নেলেতান মেদ শুকুতানগেয়া/বুগিনতানগেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","চিয়াচি ইঞ আপেকে গাম তানাপিং \"আপে কিনা কিনা নেলেতানাআপে, ইনাকু যত গাদা ভাবি জাগারিজকুকে/নবীকে হেৎদ রাপাজ কে নেল সানা লাৎ কুরেহঅ কাকু নেলনামলাআ হেৎদ আপে কিনা কিনা আয়ুমেতানাপে, ইনা ইঙ্কূ আয়ুম সানালাৎ কুরেহঅ কাকু আয়ুমনামলাআ। ");
INSERT INTO cdz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","হেৎদ নেলেপে, মিয়াত উকিল/আইন ইতুনি/পণ্ডিত দ বিরিৎ এন্তে ইনি বিড়াই/বিড়াও নাতিনাং/নাতিনাং কুলিকিঃয় তে এ গুরু কিনা চিকা লেখান যুগ যুগ রে/রাঃআঃ জিদান/জিয়ন ইঞ হাটিংগ ইগ নামেয়া গামিংমে। ");
INSERT INTO cdz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","যীশু ইনিকে গামকিয়ায়, শাস্ত্র রীতি রেদ কিনা/চিকানা অলআকানা? আম চিলকাম পড়হা আতানাম। ");
INSERT INTO cdz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ইনি কড়া হন গাম রুয়াড় কিয়ায়, আম আমাঃ গোটা অন্তরতে হেৎদ আমাঃ গোটা জিউতে, আমাঃ গোটা দাড়িতে হেৎদ আমাঃ গোটা মনতে দুলাড়িই/কুশিয়াই মে, হেৎদ আমাঃ পড়শি/হপর-জপর রেনিঃই কে আমলেকা দুলাড়/কুশিয়া কুম। ");
INSERT INTO cdz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","হেৎদ ইনিকে গাম কিয়ায়, আম দ গটা গে/বুগিনাগে গামরুয়াড় কেয়াম, আম নেকা লেখান জীউৎ /বাঞ্চাও তাহীনো আম। ");
INSERT INTO cdz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","মেন্খান ইনি আয়কে ধরমআন উদু সানা কিয়া হেৎদ জিসুকে কুলি কিয়ায়, ইঞ আ হাতু-পড়শি/হপর-জপঃরেনিঃতেংগ দ অকয় তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","যীশু দ ইনিকে গাম রুয়াড় কিয়ায়, মিয়াত হড় যীরুশালেম দিসুম হাতে যিরিহোতে সেন কেনায় হেৎদ রেরে/ডাকু কুরাঃআ তিহিরে নুরেনায়/পড়ায়নায়, ইঙ্কূ ইনিকে/ইনি রাঃআ যতচ া কু রেচচাবা কিয়াকু, হেৎদ দাল জখম কিৎতেকু, গজঃলেকাকো বাগিতকা কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","তায়মতে/সানযোগতে মিয়াত বামড়ে ইনা হরাঃআ তেগে সেন কেনায়, ইনি নেল কিত তে ইনি রাঃআ কাতা হরকাতে পারম মেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","হেৎদ নেকাগে/এনকাগে মিয়াত লেবীয় হঅ ইনা টায়াদ/জায়গা রে সেটের নায়, ইনি হঅ নেল কিত তে ইনি রাঃআ কাতা হরকাতে পারম মেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","মেন্খান মিয়াত শমরিয় ইনা হরাঃআ তে সেনতানলোঃ ইনি রাঃআ কাতাতে হিচ -সেটের নায় খানঃ ইনিকে নেলকিঃৎতে বিল্কায়নায়/দরদ হিচে না/দে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","হেৎদ কাতাতে/ঠাইঞ তে হিচ কাতে সুনুম হেৎদ দ্রাঃআক্ষারস দুলকিইয়ায়্য় হেৎদ ঘাও কু তলকেৎ তায়ায়। ইনাতে ইনি আয়া জানোয়ার রে দেঃজকিঃততে সরাইখানারে/ডেরাঃআ অড়ারে ইদিকিয়ায় হেৎদ ইনিঃএ যোগাও-যতন কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","হেৎদ দশার হুলাং মুজুরী উডুঙ কেৎ তে সরাইখানা/ডেরাঃআ মালিক কে/এমকাতে গাম্কিয়ায়, নিই যোগোও-যতন নিমঃইমে, অটঃ বেশি/বাড়তি গে খরচা খান/রেদ ইঞ হিচ রুয়াড় লেখান এম-মেটা তকা মাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","আমাঃ কিনা মনে হুয়ুয়া, নিকু আপি হড়কোএতে অকয় ইনি ডাকু কুরাঃআ তিহিরে নুরিজ রাঃআ/পড়াও রিনিজ রাঃআ পড়শি/হপর-জপঃরেনিঃ হুয়ুয়ায়/হুয়েনায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ইনিয়এ গামকিইয়ায়্য়, ইনি বিল্কায়নাইজ গে/দরদ হিচে নাইয় গে। এন্তে যীশু ইনিকে গাম রুয়াড় কিয়ায়, দু সেনকাতে, আম হঅ এনকায় মে। ");
INSERT INTO cdz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","হেৎদ চিন্তং ইঙ্কূ যীশু হেৎদ চেলা সেনতানাকু, ইনি মিয়াত হাতুতে বলয়ে নায় হেৎদ মার্থা নুতুম তে মিয়াত হনেরা আয়া অড়ারে ইনিকে/ইনিএ দারম/কুপুল কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","মরিয়ম নুতুমতে ইনি রাঃআ মিয়াত মিসিএ/বকতেত কুড়ি তাহীন কেনায়, ইনি যীশু রাঃআ কাটা কাতারে দুবেনতে যীশুরাঃআ থুতি আয়ুমতানএ তাইকেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","মেন্খান মার্থা নাআ হানা কামিরে/সুনুসাররে পুরাঃআ ব্যস্ত/বিতলৌ আকানায়, হেৎদ ইনি ঠাইন তে হিচ কাতে গামকিয়ায়, এ প্রভু, আম কি যাহানা কাম মলাউড়িয়ানা/চিন্তায়তানা যে, ইঞা মিসিংগ/বকম কুড়ি যত কামিরা জিমেদার/বঝা একলা ইঞা চেতাংরে আড়া গিডিতাৎআয় ? এন্তে ইনিকে গামিম, যেন ইঞা দেঙ্গাইঞকায়। ");
INSERT INTO cdz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","মেন্খান যীশু গাম ইনিকে রুয়াড়কিয়ায়, এ মার্থা, এ মার্থা, আম গাদা-ঢের বেপারতে চিন্তারে মেনামা। ");
INSERT INTO cdz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","মেন্খান হুডাং মিৎ -বার বাব্ত্তে, বরঞ্চ মিয়াৎ গে বাব্ত্তে জরুরতানা, সার্তি মরিয়ম ইনা বুগিন বাব্ত্তে টা/হাটিংয়াটা বাছাতাৎআয়, অকা ইনি রাঃআ হান্ডে হাতেন কা হাতা হড় ওয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","যীশু মিৎ মাহা হুলাং কথাং জায়গারে বিন্তি তান তাহিকেনা, হেৎদ মুচাৎ কেৎ খানয়, ইনি রাঃআ/আয়াইয় চেলাকুএতে মিহুড় যীশুকে গামকিয়ায়, এ প্রভু আলেকে হঅ বিন্তি/কয় জং চেদ লেমে, চিল্কা যোহন আয়া চেলাকুকে চেদলাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","হেত্তে ইনি ইঙ্কূকে গামকেৎ কুয়ায়্য় য়, আপে বিন্তিরাঃআ/কয় জংরাঃআ সময় এংকা গামে পে, এ বাআঃ/আব্বা, আমাঃ নুতুম রিলামালা কা/রিলামাল কা, আমাঃ রাঃআজ্য হিজু কা। ");
INSERT INTO cdz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","আলেয়া মাহা হুলাং রাঃআ জমা আলেকে এমা আলেমে। ");
INSERT INTO cdz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","হেৎদ আলেয়া পাপকু/কাই কু ছেমায়মে/ছেমায় আলেমে, চিয়াঃচি আলেহো আলেয়া যত পাপিয়ানকুকে/আপরাধিকুকে লেঅ ক্ষমা/ছেমাকেৎ কুয়াআলে। হেৎদ অটঃ আলেকে বিড়াব/বিড়াও রে আলম আগুলেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","যীশু চেলা কুকে গামাৎ কুয়ায়্য় য়, আপেকুএতে যাহায় রাঃআ মিয়াত গাতি মেনাই আ, তালা নিদা হিচ কাতে ইনিকে গামিআয়, এ গাতি, আপিয়া পিঠা উধার এম তালাইঞ মে/এমাইঞ মে। ");
INSERT INTO cdz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","চিয়াঃচি ইঞ আ মিয়াত গাতি দ হরাঃআতে সেন সেন তে ইঞ আ হান্ডে হিচ সেটেরাঃআ কানায়, ইনি রাঃআ সামাংরে সুন্নু চুটি /এম দঃহ নাতিনাং ইঞ আ হান্ডে জাহানা বায়ায় না। ");
INSERT INTO cdz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ইনি দ ভীতির হাতেন গে গাম রুয়াড় ইয়ায়, আলম সাতাওইঞা/হুজাতিঞা/কষ্ট এমিইঞা, নাহা দ দুয়ার হান্ডেদাকানা/হুড়কা কানা, ইঞ আ হনকোতিংআ ইঞ লো গিতিজা কানা, ইঞ বিরিৎ কাতে কাইঞ এমদাড়িমেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","সার্তিগে ইঞ আপেকে গামতানা পিং \"ইনি যদিহঅ গাতি তেয়া মেন্তে বিরিৎ কাতে ইনিকে যাহানা কায় এমিইঃরেহঅ, মেন্খান ইনি রাঃআ হান্ডে একশায় আসি নাতিনাং ইনি রাঃআ চিন্তি জরুর, ইনা হাতেন বাড়তি এমিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ইঞ আপেকে গামতানাপিং, আসিপে, আপেকে এমোয়া, পানতি/পাঞ্জায় পে নামোয়া, দুয়াররে টোঃটোঃএ পে আপে নাতিনাং নিজঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","চিয়াঃচি ইশ্বর বা রাঃআ হান্ডে যাহানিজ গে আসিতানিঃদোয় তেলাজোমায়, হেৎদ পানতি ভারাঃআইজ/পাঞ্জা ভারাঃআইজ দ নামেআয়, আর দুয়াররে টোঃটোঃএ তানিজ নাতিনাং দ দুয়ার নিজঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","আপে আপুকোএতে/আপু কুয়া তালারে অকয় এনকানিজ যে হনতেয়া কে পিঠা আসিআয় হেৎদ ইনি দ দিরি এমিআয়? হাকু আসি লেংখান হাকু বদলতে ইনি বিং এমিআয়। ");
INSERT INTO cdz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","বাংখান বিলি আসি লেংখান ইনিকে কিরিং কাটকম এ এমাইআয়। ");
INSERT INTO cdz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","এন্তে আপে এটকাকানকো/খারাঃআপ কানকো রেহ চিনতি আপেয়া হনকুকে বুগিনা আমান এমপে সারিয়া, এনকাগে আপেয়া সেরমা রিনিজ আপু আয় আসিতান কুকে হঅ অটঃ ইন্তি যুকুরাঃআং রিলামালা আত্মা এমকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","মিৎ হুলাং যীশু দ মিয়াত বংগা ছাডাইকান তাই কেনায়, ইনি বোবা গে তায় কেনায়, বংগা উডুং এন খানয় ইনি বোবা থুতি দাড়ি কিইয়ায়্য়, হেততে গাদা হড় কু হায়কাট এনা। ");
INSERT INTO cdz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","মেন্খান ইঙ্কূ য়া তালা হাতেন মিত বার হড় কু গামকেয়া, নিঃ হড় দ বঙ্গা কুরাঃআ সরদার বেলযত ল রাঃআ হরাঃআতে/দ্বারাঃআয়তে বংগাকুকে ছাডা কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","এটাকুদ ইনি বিরাঃআও/বিডাও নাতিনাং ইনি রাঃআ হান্ডে হাতেন সেরমাআ হাতেন মিয়াত চিহ্না কো আসিকিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","মেন্খান ইনি ইঙ্কূ য়া আবভাব/হুদিস আটকার কেৎ তে, গামকেৎ কুয়ায়্য় য়, আপনার/আয়রে বিরুধতে মিত-মিয়াত রাঃআজ্য উজাড়ওয়া/ধ্বংসওয়া, আপনার বিরুধতে ভিনা-ভিনিজ অড়াঅ উয়ুগোআ/পেটেজওয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","শয়তান হঅ এঙ্কাগে, ইনি আয়রে বিরুধতে ভিনা-ভিনিজ আয়খান, ইনি রাঃআ রাঃআজ্য দ চিলকা তে তিনগু তাহি থারোয়া। এন্তে আপে গামেতানাপে ইঞ দ বেলযত ল রাঃআ হরাঃআতে/দ্বারাঃআয়তে বংগাকুকে ছাডা তান কুআইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ইঞ দ বেলযত রাঃআ হরাঃআতে/দ্বারাঃআয়তে ছাডাকু তানাই খান, এনখান আপেয়া হন তাপেয়া টুকু দ অকয় রাঃআ হরাঃআতে/দ্বারাঃআয়তে ইঙ্কূকো ছাডা তান কুয়াকু। ইঙ্কূগে আপেয়া ধরবার কো হুয়ুআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","মেন্খান ইঞ ঈশ্বর রাঃআ কাটুতে বঙ্গা ছাডা কুইঞ, এন্খান ঈশ্বর রাঃআ রাঃআজ্য আপেয়া হান্ডে হিচ সেটেরাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ইনি দাড়িয়ান হড়, হাতিয়ার তিহি রে সাবকাতেন আয়া অড়া হর ভুর, আয়া ধন-দৌলত রুখিয়া গে তাহীনা তেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","মেন্খান ইনি হাতেন অটঃ দাড়িয়ান হিচ কাতে অপ্তা-গপয়জ লেখান ইনি অকা হাতিয়ার কুরাঃআ চেতানরে ভরসা লাআয়, ইনা যতএয়ে রেজআয় হেৎদ লুটা কাতে হাটিং এয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","অকয় ইঞ লো বানুই আ, ইনি দ ইঞ আ বিরুধ রে মেনাই আ। আর অকয় ইঞ লো কায় হালাং/হাউর সামটা আয় ইনি দ হুরাঃআং/ছিটা গিডি আয়। ");
INSERT INTO cdz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","বংগা আত্মা হড়রাঃআ হাতেন উডুং লেন খানয়, ঝিরাঃআ নাতিনাং রহড় টায়াদ পাঞ্জা নাতিনাং দাড়া ভাড়া আয়, হেৎদ ঝিরাঃআ কায় নাম লেখা নে গাম রুয়াড় এয়ায়, অট হঅ গে ইঞ আ অড়াতে রুয়াড় সেন আইঞ, কদের হাতেন উডুং হিচ লেনাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","মেন্খান রুয়াড় লেন্তে, ইনা অড়া দ জক-জো আকানা হেৎদ সাজা কাতে নামেআয়। ");
INSERT INTO cdz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","এন্তে ইনি সেএন তে অটঃ এয়াই আত্মা আগু ধরাঃআ কেৎ কুয়ায়্য় য় হেৎদ বলঃঅ কাতে এন্ডে কু বাসা কেয়া, ইনাতে ইনি হড় রাঃআ তায়ম তেরাঃআ হাল দ মারাঃআং হাতেন খারাঃআপ গে/এটকা গে হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","যীশু নিয়া কু গামাকুতানায়, গাদেল হড় কোরেন মিয়াত বাহুকুড়ি জোর তে কিকিচ কাতে গাম কিয়ায় মান সারাও ইনি মাই, অকয়্য় আমকে দঃহলেত মেয়ায় হড়ম রে হেৎদ আমকে কুড়াম তয়া চেপেচ তুকা লাত মেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ইনি গামকিইয়ায়্য়, হে গে/সার্তিগে, মেন্খান ঈশ্বর রাঃআ জাগার আয়ুমতান কু মানা-বাতা কাতেন সেনোয়া কু দ শুকুতান গেয়া/বুগিনা তানগেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","গাদা লেকা/গাদেল হড়কু ইনি রাঃআ হান্ডে হিচ হুন্ডি নাকু খান ইনি গাম কিইয়ায়্য়, নিয়া পিড়ি রেঙ্কূ/নেতরাঃআং রেঙ্কূ হড় কুদ এটকাগেয়া/গিনটি গেয়া, ইঙ্কূ চীনহা কু নামতানা, মেন্খান জোনা রাঃআ চিহ্না বাগীকাতে এটা চীনহা কাবু এমা/উদু কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","এন্তে চিল্কা জোনা দ নিনবি সরগ নাগার রেঙ্কূয়া নাতিনাং চীনহা হুইলেনায়, এনকাগে মান্মি হন নিয়া পিড়ি রেঙ্কূয়া/নেতরাঃআং রেঙ্কূ হড় কুরাঃআ চীনহা হুই অ আইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ধরবার হুলাং রে দক্ষিন দিশুম রিনিজ রাঃআনী নিয়া পিড়ি রেঙ্কূ/নেতরাঃআং রেঙ্কূ হড় কুলঃঅ বিরিৎ ায় হেৎদ ইঙ্কূ য়ে ধরবার দোষী কুয়ায়্য় য়, চিয়াচি ইনি দ শলোমন রাঃআ আকিল/জ্ঞান আয়ুম নাতিনাং ধার্তি মুচাৎ হাতেন হিচ লেনায়, হেৎদ নেলেপে, শলোমন হাতেন হ মারাঃআং ইজ নেনডিয়াআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ধরবার হুলাং রে হড় কুদ নিয়া পিড়ি রেঙ্কূ/নেতরাঃআং রেঙ্কূ হড় কুলঃঅ তিংগুনা, হেৎদ ধরবার দোষী কুয়াকু, চিয়াদচি ইঙ্কূ দ জনা রাঃআ পরচার আয়ুমকেৎ তুকু মন কু পাল্টা/ঘুরাঃআ কেয়া, হেৎদ নেলেপে, নেন্ডে দ যোনা হাতেন হ মারাঃআং ইজ মেনাই আ। ");
INSERT INTO cdz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","যাহায় হড় দিমি ধরাঃআ/জুনডিত কাতে দানাংরে চায় ঝুড়িয়া লাতার রে কায় হারুবে আয়, মেন্খান অড়া বলতানকু মার্শাল কু নেলে কা মেন্তে দিমিডানদি/টিকারেগেয় দহয় কায়। ");
INSERT INTO cdz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","আমাঃ মেদদো আমাঃ হড়মো রাঃআ প্রদীপতানা/দিমিতানা, এন্তে আমাঃ মেদ নিরাঃআলারেদ গোটা হড়মো তামা মার্শালো কা, মেন্খান ইনা খারাপাকানরে/এটকাকানরে গোটা হড়মো তামা নুবাগোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ইনামেন্তে আমরেয়া মার্শাল আল নুম্বাগো কা মেন্তে চির্গালাকানামে। ");
INSERT INTO cdz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","সার্তি গে, ইনা মেন্তে আমাঃ গোটা হড়মো মার্শালো কাআ, হেৎদ ইনা রাঃআ জাহানা হানটিংগ কা নুম্বাগোআ ইনা দ ডিগ ডিগ জুলঃতানা দিমি লেকা মার্শাল মেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","যীশু দ থুতি মুচাৎ কেৎ তায়ম, মিয়াত ফরিশি ইনি আয়া হান্ডে জম নাতিনাং নেওতা/বিন্তি কিয়ায়। হেৎদ ইনি ভীতির বলঃঅ কাতে জম দুবে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ফরিশি নেল কাতে হায়কাটে নাকু, জম মাড়াং তে ইনি কায় আবুং আকানায়। ");
INSERT INTO cdz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","মেন্খান প্রভু ইনিকে গাম কিয়ায়, আপে ফরিশি কুমাআ বাটি-ভাজান চেতান চেতানতেদপে/বাহার তেতপে গাসার সাপায়া আপে, মেন্খান আপেয়া মন ভীতির দ লালচ হেৎদ বাড়িচ তে পেপেরেয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","এ লেলাহা কু, অকয় বাহার রাঃআ অংশ বানহা তাৎআয়, ইনি দ চি কিনা ভীতার রাঃআ অংশ হঅ কায় বানহা তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","বরঞ্চ ভীতির রে জাহানা মেনাকান দ দানে পে, এন্তে আপেয়া নাতিনাং যতচয়াগে ফার্চা ওআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","মেন্খান আপে কেৎ দ হায় হায় এ ফরিশিকু, চিয়াচি আপে দ পোদিনা, আরুদ (লেপে আড়া) হেৎদ নাআহানা আড়া কুরাঃআ দশমাংশ/গেল হাটিংপে দান ভাড়ায়াপে মেনখান হক বিচার হেৎদ ঈশ্বর রাঃআ দুলাড় দপে হিলাং-ঢিলাং এ তানা। মেন্খান ইনাকু যত আপেকে মানা-বাতা হুয়ুয়া হেৎদ কাঃআ বাগি তুকা হুয়ুয়া আপেয়া লাক্তি তানা। ");
INSERT INTO cdz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","আপে কেৎ দ হায় হায় এ ফরিশিকু, চিয়াচি সমাজ-অড়া কুরে মারাং দুবারে হেৎদ হাট বাজার রে জহার পে কুশিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","আপে কেৎ দ হায় হায় চিয়াচি এনকান গে আপে হ উকুয়াকান/দাপালাকান তপা গাঢালেকাপে/কবরলেকাপে, অকা চেতান হরকাতে হড়কু কাকু সারিকাতে সেনঃয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ইন্তং আরিচালি রিঙ্কূ গুরু/পণ্ডিত কুরাঃআ হাতেন মিহুড় গাম রুয়াড় কিইয়ায়্য়, এ গুরু, নিয়া থুতি কুতে আলেকে আলম অপমান লেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ইনি গাম কিইয়ায়্য়, এ আরিচালি রিঙ্কূ গুরু/পণ্ডিত কু আপেকে দ হায় হায়, আপে আশু হাম্বাল বাহারম/বঝা হড় কুকে লাৎ দিয়াকুতানাপে, মেন্খান আপে দ আপেয়া কাটু তে হঅ ইনাকু তুল দেঙ্গাতে কাপে জুটিজেয়াআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","হায় হায় আপে কেৎ দ, আপেয়া হাড়াম হড় কুদ/মুরুব্বি কুদ ভাবি জাগারিজ কুকে গয়চ কাতে তপা-গাঢা/কবর পে তলে তানাআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","নাহা আপে আপেয়া হাড়াম কুরাঃআ কামীরাঃআ লুকুন্দী পে তানা হেৎদ ইনাতেপে রাঃআজিতানা, ইঙ্কূ দুকু গয়চ কেৎ কুয়াকু হেৎদ আপে দ ইঙ্কূয়া তপা-গাঢা/কবর পে তলেতানাআ/বানায়েতানাআ। ");
INSERT INTO cdz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ইনা মেন্তে ঈশ্বর রাঃআ আকিল/জ্ঞান হ গামেআআয়, ইঞ ইঙ্কূ য়া তালারে ভাবি জাগারিজ কুকে হেৎদ কুলিচ কুকে কুল কুআইঞ, ইঙ্কূকে যাহায় যাহায় কুকে গয়চ কুয়াকু হেৎদ কুদা-গিডি/সাতা কুয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ইনাতে অতে দিশুম রে/ধারতি রে চিন্তি ভাবি জাগারিজ কুরাঃআ মায়ম জর/লিঙ্গী য়া কানা, ইনা দ নিয়া পিড়ি রেঙ্কূয়া/নেতরাঃআং রেঙ্কূ হড় কুরাঃআ হাতেন গে হাতা হুইয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","হেবল রাঃআ মায়ম হাতেন ইনি সখরিয় রাঃআ মায়ম জাকিদ অকয় দ বিদি হেৎদ জাহের স্থান রাঃআ রিলামালা ঠাও রে গয়চ এনায়। হে ইঞ গামতানা পিঞ, ইনা রাঃআ হিসাব দ নিয়া পিড়ি রেঙ্কূয়া/নেতরাঃআং রেঙ্কূ হড় কুকে এম হুইয়া তাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","আপে আআরিচালি চেচেদিজ/পণ্ডিত কু হায় হায়, এন্তে আপে দ ঈশ্বর আকিল রাঃআ ঝাড়ানি রেজ ইদিতাৎআপে, আপে মা কাপে বলঃঅ লেনা হেৎদ অটঃ হড় কু অকয় বলঃঅ সানা লাৎ কুয়া ইঙ্কূ কেহ কাপে বলঃঅ তকা লাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ইন্তং যীশু এন্ডে হাতেন উডুং নায় খানয়, আরিচালি চেচেদিজ হেৎদ ফরিশি কু ইনিকে পুরাঃআকু হায়রান কিৎআকু হেৎদ ইঙ্কূ দ নাআহানা কুকলিকু কুলি কিৎআকু। ");
INSERT INTO cdz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ইঙ্কূ দ ইনিয়া মচারাঃআ থুতি সাব নাতিনাং হেৎদ ইনিকে নেল হর কাতে বিচাররেকু দোষী দাড়িকাকু। ");
INSERT INTO cdz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ইন্তং গে জুলু হড় কু হিচ হুন্ডি/বুরু নাকু, ইন্তি লেকা যে আকু আকু গে তিকা-রেনঢেত তান তাহি কেনা। এন্তে যীশু মারাঃআংরে আয়া চেলা কুকে গাম সদর কেৎ কুয়ায়্য় য়, আপে ফরিশি কুরাঃআ রাঃআনু/তাডি হাতেন চিরাঃআগালপে ইনা দ চাকাদ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","দাপালা কান যতচ া নেল নামোয়া, উকুয়াকানা/দানাং আকান যতচ া সারি নামোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ইনাতে আপে নুম্বা রেপে জাহানা গামতা পে, ইনা মার্শাল রে আয়ুমো আ। আপে অকয় খুনদুরি ভীতির হাতেন লুতুর রে ফাসার ফুসুর/হায়াম হায়াম গাম তাপে, ইনা দ ছাদ চেতাং হাতেন পরচারো আ/ঢানঢারাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","আপে ইঞ আ গাতি কু, ইঞ আপেকে গাম তানা পিং, ইঙ্কূ কেৎ আলপে বর কুয়া, অকয় হড় মো গগয়কু, মেনখান ইনা তায়ম তে অটঃ জাহানা কাকু দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","মেন্খান অকয় কে বর কুয়াপে, ইনা গাম লেপিং, গয় লেয়কু তায়ম তে নরকরে হুরাঃআং গিডি রাঃআ দাড়ি মেনা তেয়া, হে গে ইনি ইশ্বর কেগে বরই পে। ");
INSERT INTO cdz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","কিনা, মড়এয়া গেরোয়ান কু বার নয়া তে কাকু আকরিংওআ? এন রহ ঈশ্বর সামাংরে ইঙ্কূয়তে মিয়াত হঅ কায় হিড়িং আয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","হে গে ইশ্বর বা দ আপেয়া বহরাঃআ যত উব হঅ লেখা তা পেয়ায়। আলপে বর আয়, আশু গেরোয়ান কুরাঃআ হাতেন আপে দ ঢের গেপে গণঙ না/দামি কা। ");
INSERT INTO cdz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","হেৎদ ইঞ আপে কে গাম তানা পিং, যাহায়গে হড় কুরাঃআ সামাং রে ইঞ কে সারিয়ায়/মানা/স্বীকার আয় গামেয়ায় মান্মি হন হ ঈশ্বর রাঃআ সেরমা রিঙ্কূ দাসীকুরাঃআ সামাং রে ইনিকে সারিয়ায়/মানা/স্বীকার আয় গামেআয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","মেন্খান অকয় হড় কুরাঃআ সামাংরে ইঞ কে কায় সারিয়ায় গামে আয় ইনি দ ঈশ্বর রাঃআ সেরমা রেঙ্কূ দাসীকুরাঃআ সামাং রে হ কায় সারিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","যাহায় গে মান্মি হন রাঃআ বিরুধ রে থুতি আয়, ইনি ছেমা কায় নামে আয়, মেন্খান যাহায় গে রিলামালা আত্মা রাঃআ হিলা/নিন্দা জাগার-জাগারিজ দ কায় ছেমাআয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ইন্তং হড় আপেকে সমাজ-অড়ারে, হাকিম হেৎদ একতিয়ারি য়ান কুরাঃআ সামাংরেকু ইদি পেয়া, হেততে আপে কিনা গাম রুয়াড় অটঃ গামেয়া এআপে, আলপে উড়ুঃআ/দানঃধাআ। ");
INSERT INTO cdz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","চিয়াচি ইন্তং অকা অকা/কিনা কিনা গাম হুয়ুয়া, রিলামালা আত্মা গেয় চেদ/ইতু পেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","হেৎদ গাদা হড় কুরাঃআ তালা মাঙ্গা হাতেন মিহুড় গাম কিয়ায়, এ প্রভু ইঞ আ বকৈং কে গামিম, আপু তিংয়া রাঃআ ধন-সম্পদ ইঞ লো হাটিং একায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","মেন্খান ইনি গাম রুয়াড় কিয়ায়, এ হড়/মান্মি, আবেনা ধরবারিচ চি হাটিংইজ দ অকয় ঠারাঃআও/বাহাল তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","হেৎদ যীশু হড় কুকে গামাৎ কুয়ায়্য় , মা সামবাড়া/সতর পে, যত লেকানা লোভ-লালচ হাতেন আপেতেত কুকে হেপাজত/চকাড রে তাহিনো পে, চিয়াচি পেরেজ কাতে নুর লেঃহ ইনাতে মান্মি জীয়ন/জিদান কায় নামেআয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","হেৎদ ইনি ইঙ্কূকে মিয়াত জোনোকা গামাৎ কুয়ায়্য় , মিয়াত কিসাড় হড় রাঃআ ক্ষেত/বাইত রে ঢের উতার জো জো-লেনা। ");
INSERT INTO cdz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ইনাতে ইনি মনে মনেতে পাহামে তানায়, কিনা চিকা আইঞ, ইঞ আ জোকু দঃহ রাঃআ টায়াদ বায়ায় না। ");
INSERT INTO cdz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","হেততে গাম কিইয়ায়্য়, নেকা আইঞ, ইঞ আ যত পটম/গোলা অড়া পেটেজ/উতুড় কাতে মাপরাঃআং/নাপরাঃআং আ পটম/গোলা অড়া এইঞ বানায়া, হেততে এন্ডে ইঞ আ যতচ া জোঃকু হেৎদ জিনিস/ধন-সম্পদ কু জারোয়া দঃহ তাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","আর ইঞ আ জিউ/জিদান এ ইঞ গামিয়া, এ জিউতিন/জিদগা গাদা সির্মাং নাতিনাং ধন-সম্পদ জারোয়া দঃহা কানা, মা ঝিরাঃআও মে, জম-নুই মে, রিঝৌও জম মে। ");
INSERT INTO cdz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","মেন্খান ঈশ্বর ইনিকে গাম কিয়ায়, এ দুনঃধাআ/লেল্হা/ডনড, তিহিং নিদা গে আমাঃ জিউ আমাঃ হান্ডে হাতেন হাতাঃআ/ইদিয়া/ইদিওআ, হেততে নিয়া যত জারোয়াঃকাদাকু দ অকয় রাঃআ হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","যাহায়/অকয় গে আয়া নাতিনাং ধন-সম্পদ জারোয়া দঃহ আয়/দঃহা কানায়, রেহ/মেন্খান ঈশ্বর রাঃআ সামাং রেদ কায় কিসাড় অআয়, ইনি দ এনকানিইগে। ");
INSERT INTO cdz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","হেততে ইনি আয়া চেলা কুকে কুলি কেৎ কুয়ায়্য় য়, নিয়া খাতিরাঃআং ইঞ আপেকে গাম তানা পিং, কিনা জমেয়া লে/চিকিনাবু জমেয়া, মেন্তে আপেয়া জিউ নাতিনাং হেৎদ কিনা তুসিং ওআ/চিকিনাবু তুসিং ওআ লে মেন্তে আপেয়া হড়মো নাতিনাং আলোপে, উড়ুঃআ/দানঃধাআ। ");
INSERT INTO cdz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","চিয়াচি জমা হাতেন জিউ হেৎদ কিচি/কিচরী হাতেন হড়মো মারাঃআং আ। ");
INSERT INTO cdz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","কাঃআহু কুকে নেলকূপে, ইঙ্কূ হেরে দা/হের হ কাকু হেরে আ আর ইর হ কাকু ইরে আ, ইনকয়া গুদাম/ভান্ডার হঅ বায়ায় না, পটম/গোলা অড়া হঅ বায়ায় না, মেন্খান ঈশ্বর ইঙ্কূ কে আসুলতান/আসুল লেত কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","আপে অরে কুরাঃআ হাতেন হ চীনতি মারাঃআংআপে, আপেয়া তালা মাঙ্গা হাতেন অকয় আয়া চিন্তাকাতে/দানঃধাআকাতে আয়া জিউ দ মিৎ ঘাড়ি আরহা-উরহু আয়/আরদা পসাআয়/পসড়াআয় (মিৎ মুকাএ পসা/পসড়া দাড়ি আয়)। ");
INSERT INTO cdz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","এন্তে আপে নিন্তি হুডিং উতার কাপে কামি দাড়িরেদ/দাড়ি কানখান, এন্খান চিয়া/চিকানা মেন্তে আপে নাআ হানা/নাআ আমান (ঝিরাঃআও নাতিনাং) থুতি রাঃআ নাতিনাং দানঃধাআ তানা পে? ");
INSERT INTO cdz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","চুকুড়ু/কানুড় বাহা আরিদ-বানধি পে/নেলেপে, ইনা চিল্কা হারাঃআগদয়া/হারাঃআতানা, ইনা কায় কামীতানায়/খাটায়, কায় তাকুই/তাকুই আয়/তানায় মেন্খান শলোমন হঅ আয়া যত ঐশ্বর্য্য/জুনুল/আদাল ইনা মিয়াতলেকা তে সিঙ্গারাঃআ/সাজায় কান কায় তাহিকেনায়, ইঞ নিয়াগেইঞ গামাতানা পিং। ");
INSERT INTO cdz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","বুগিন গে, বাইত/অতে রে অকা ঘাসাড় তিহিং মেনা গাপা চুলারে তিং/সাংজু/হাড়াবো আ, এন্তে ঈশ্বর ইনাকু নেংকা উয়ু/তুসিং/পরাঃআ/সাজা কাত কুয়ায়্য় য়, এন্খান এ হুডিং পাতিয়াও তানকু/হড়কু, আপেকে অটঃ চিনতি ঢের জগা/উয়ু/তুসিং পেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","হেৎদ, কিনা জমেয়া লে, কিনা নুইয়া লে, মেন্তে আলপে নামভাড়া, হেৎদ আলপে আড়াউড়া/চিন্তায়া। ");
INSERT INTO cdz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","চিয়াচি, নিয়া পুরি রিঙ্কূ হড়কুদ নিয়া যতোয়া কু আপাবাডিয়া তানা চিয়াচি ইশ্বর কে কাকু সারিয়া ইনাতে, আপে হ নিয়া যতোয়া লাগা তিংগা নিয়া আপেয়া সেরমা রিনজ আপুয় ইশ্বর বা সারিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","মেন্খান ঈশ্বর রাঃআ রাঃআজ্য চিন্তায়পে/তাঁড়াপে এন্তে/এন্খান নিয়া যতচ া এমোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","এ হুডিং গোট/পাল, আলোপে বর আ, চিয়াচি আপেয়া আপুদ আপেকে ইনা রাঃআজ্য এমা পেয়ায় কুশিয়া ");
INSERT INTO cdz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","আপেয়া অকা মেনা, আখরিং কাতে দানে পে। আপেয়া নাতিনাং এনকান বাগুলি/তোরাঃআ/থাইলি বাইয়ে পে, অকা দ কায় অরেঃজআ, সেরমা কা চাবাআ/নষ্টয়া ধন/খুর্জি আরজা/জারোয়া দঃহয় পে, এন্ডে আপেয়া কুম্বড়ু কায় সেটের দাড়ি আয়, ");
INSERT INTO cdz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","হেৎদ তিজু হঅ কায় জোমেয়ায়, ইনাতে কদেরে আপেয়া ধন, এন্ডেগে আপেয়া মন হঅ তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","আপেয়া মায়াং পাঠে দঃহ পে, সুল্তা জুল দহয় পে। ");
INSERT INTO cdz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","আপে এনকান হড়কু লেকা হুয়ুপে, অকয় আকুয়াআ গমকে রাঃআ তাংগি হর কিয়াকু, ইনি চিনতং দুতামোঃ ভোজ হাতেন রুয়াড় হিজু আয়, ইনি হিচ কাতে দুয়ার রে টোও টোও লেংখান ইঙ্কূ ইনি রাঃআ নাতিনাং কবাট নিজ দাড়ি কাকু। ");
INSERT INTO cdz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","বুগিনতানগেয়াকু, ইঙ্কূ দাসী কুদ, অকয় কুকে গমকে চিরগালগে হিচ নামকুয়ায়্য় য়। ইঞ আপেকে সার্তিগে গামতানাপিং, ইনি মায়াং পাঠে কাতে ইঙ্কূলঃঅ জোজম দুব আয়, হেৎদ হিচ কাতে ইঙ্কূ আয় সুসুরাঃআয়/সুনুসার/হাটিং ইদি কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ইনি তালা নিদা চায় সিম্কু রাঃআ য় হিজু রেহ ইনি এনকা গে হিচ নাম কুয়ায়্য় য় খান, ইঙ্কূ দাসী কুদ বুগিনতানগেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","মেন্খান নিয়া সারি দঃহ পে, অড়া মালিক সারি লেংখান, অকা ঘাড়ি কুম্বুড়ুএ হিজু য়া কু, চির্গাল তাহিন কোয়ায় হুনাং, আয়া অড়া রে কায় ভূঃউ তকা কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","আপে হ সাপড়াআকান তাহীন পে, এতে কাপে সারিয়া সময়/ঘাড়ি রেগে মান্মি হঅন দ হিজু আয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ইন্তং পিতর গাম কিইয়ায়্য়, এ প্রভু, চিয়া আম আলে চায় যত কুকে নিয়া দৃষ্টান্ত/জোনোকা গামতানা কুয়াম। ");
INSERT INTO cdz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","প্রভু গাম কিইয়ায়্য়, আয়া গমকে আয়া অড়ারেন কুকে নেন্ডা জোমা এম নাতিনাং বাহাললে/বাহালআকান এনকানিজ/এনকান পাতিয়ান হেৎদ সেড়ান দেওয়ান অকয় তানিজ। ");
INSERT INTO cdz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","বুগিনতানগেয়ায়, ইনি দাসী দ, ইনি অকয় আয়া মালিকতেত নেঙকা কামিতানায় হিচ নামী আয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ইঞ আপেকে সার্তিগে গাম তানা পিং, ইনি দ আয়া যত ধন চেতান রে গুসিয়া/অধিকারি দঃহই আয়/বাহাল লিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","মেন্খান ইনি দাস মনেমনে গামে আয়, ইঞ আ প্রভু হিজু রে হেরাঃআ/দেরি আয় মেন্তে দাস হেৎদ কাড়মি কু দাদাল হেৎদ জম-নু হেৎদ বুল আয়/আকু। ");
INSERT INTO cdz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","এন্ডে খান আয় কায় নেল হর হুলাং হেৎদ কায় সারি ঘাড়ি রেগে, মালিকে এ হিজু কা হেৎদ ইনি দ দুকুইআ/সাজা এইয়ায় হেৎদ কা/বিন পাতিয়ান কুলঅ হাটিং এমোআয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","হেৎদ ইনি দাসী অকয় আয়া মালিক কিনা নানাম তানায় সারি কেৎ তে/কাতেহ, কায় লাড়া/তাইআর লেনায় হেৎদ ইনি রাঃআ নানামো/মনে লেকা কায় কামীলেয়ায় খান, ইনি দ কুঠিনগে/ঢের গে/বে ঢের দালিয়া কু/দানাল জমেআয়। ");
INSERT INTO cdz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","মেন্খান অকয় কা সারি কাতে দানাল জম রাঃআ লেকা/লেক কামী যাহানাতাৎ খান, ইনি দ কমগে/হুডাংগে দালিয়া কু/দানাল জমেআয়। এন্তে ঢের এমাকানায়ইজ হড় দ ঢের গে আসিআয়/আদায় এআয়, হেৎদ ঢের জিমাওদহ কানায়ইজ হড় কেৎ ঢের উতারগে আসি হুইআ। ");
INSERT INTO cdz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ইঞ দ ধার্তি রে সেঙ্গেল জুন্ডিইঞ /ধরাইঞ নাতিং হিচ াকানাইঞ, ইনা নাহা জুল আকান/তাহি রেদ, এন্খান কিনা সানাংআই। ");
INSERT INTO cdz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","মেন্খান ইঞ কে মিয়াত দুক নাতিনাং তে ডুবুলো হুয়ুআ, ইনা আউরি চাবা ভুর সিগিদ/সাতাও/হুজাত/দান্ধাপান্ধা আকানায়াই। ");
INSERT INTO cdz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","কিনা আপে দপে আটকারে তানা, ইঞ ধার্তি রে সুলুক/শান্তি আগু নাতিনাং হিচ াকানায়ইঞ ? আপেকে গাম তানাপিং, কাগে, ইঞ গাম তানা পিং, বরঞ্চ/বচ্ছম বিপিনাগ/ভিনা-ভিনিগে। ");
INSERT INTO cdz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","নাহা হাতেন মিয়াৎ অড়ারে মড়ে হড় কু ভিনা-ভিনিগেয়াআ, আপি হড় দ বার হড়রাঃআ বিরূধরে। ");
INSERT INTO cdz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","আপু দ হন রাঃআ বিরুধরে, হন দ আপু রাঃআ বিরুধরে, মাইতেদ লঅ হনরাতেদ হেৎদ হনরাতেদ লঅ মাইতেদ, হানারতেদ লঅ কিমিনতেত হেৎদ কিমিনতেদ লঅ হানারতেদ রাঃআ বিচ্ছেদ/ভিনা-ভিনিং সির্জা নাতিনাং হিচ াকানা। ");
INSERT INTO cdz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","যীশু দ গাদেল হড়কুকে অটহঅ গামাৎ কুয়ায়্য় য়, আপে বেলা হাসুড়দর/পছিম দর রিম্বিল রাঃআকাবা তান নেল লেখান পে গাম গদেয়া, দাঃআ হিজু তানা, এনকাগে হুইয়া। ");
INSERT INTO cdz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","হেৎদ দখিন দররাঃআ হয়-অ লক্ষকাতেপে গামেয়া, কুঠিন সিতু মেয়ায়, হেততে এনকা গে ঘটাআ/হুইআ। ");
INSERT INTO cdz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","এ হসসড়/বেদা হড় কু! আপে অতে হেৎদ সেরমা রাঃআ কিনা/চিকিনা পে/কু পাছনা দাড়িয়া/নেল উরুম দাড়িয়া পে খান হেৎদ চিকাতে ভালা/ভেলে নিয়া দিপলি/ঘাড়িরে আবভাব-কু/উরু-কু কাপে পাছনা দাড়িয়া/নেল উরুমদাড়িয়া তানা? ");
INSERT INTO cdz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","হেৎদ অকা টা গটা /গটা া/সার্তিয়া মেন্তে চিয়া আপেতেত গে কাপে ধরবার রে দা/ধরবার রে আ/ধরবার রে তানা? ");
INSERT INTO cdz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","চিন্তং /চিনতং আম মুদাইলঅ/বিপক্ষলঅ ধরবারিজরাঃআ/হাকিমরাঃআ হান্ডে সেনঃহরাঃআ রেগে ইনি লঅ মিটমাটেবেন, বাংখান দ যদি ইনি আমকে ঘহাড় ইদিমেয়ায়, হেৎদ ধরবারিজ/ধরবারাঃআনি আমকে পাল্টন কুরাঃআ তিহি রে জিমামেয়ায়/সম্পামেয়ায় হেৎদ পাল্টন কু আমকে হাজত/হেপাজত/জিহাল রে সানজুমেয়ায়/সামভামেয়ায়/খড়ামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ইঞ আপেকে গাম তানা পিং \"চিমিন ভুর আম/আউরি মুচাৎ পয়সাটা কাম হালায়াআ, ইমিন ভুর আম যাহা লেকাতেগে এন্ডে হাতেন কাম উডুং দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ইন ঘাড়িগে/ ইন্তং গে কথক হড় যীশু কে ইঙ্কূ গালিল রিঙ্কূ য়া বাব্ত্তে তে গামকিয়াকু,অকয়কুরা হুন্দাং মায়ম রোম রাপাজ পিলাত দ আকুয়াআ বলিঃ লঅ মেশালাৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","হেৎদ ইনি ইঙ্কূকে কুলি রুয়াড় কেৎ কুয়ায়্য় য়, আপে কিনা আটকারে তানা পে, কিনা নিকু গালিল রিঙ্কূ এটা যত গালিল রিঙ্কূ রা হাতেন কুঠিনতেত গে পাপীকু তাহি কেনতে/তাহি লেনতে নিয়া সাতাওকু/দুখঃকু সাহায় তানা। ");
INSERT INTO cdz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ইঞ আপেকে গামতানাপিং, ইনা দ লহয়/লহয়, মেন্খান মন কাপে ঘুরাঃআ/পাল্টা/হিয়াতিগে রেদ, আপে যতকু এনকা গে জিওনোয়া/নষ্ট। ");
INSERT INTO cdz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","চি ইঙ্কূ গেলে আঠি হড়, অকয় শিলোহ রে গাড়/অট্টালিকা উয়ুয়েন তে তেনগয়চ কেৎকুয়ায়্য়, চিয়া ইঙ্কূ যত যিরুশালেম রেঙ্কূতে এটা ঢের পাপী/দোশি কু তাহীন কেনা মেন্তে চিপে আটকারে তানা। ");
INSERT INTO cdz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ইঞ আপেকে গামতানা পিং, লহয়/ইনা দ লহয়, মেন্খান আপে হ মন কাপে ঘুরাঃআ/পাল্টা রেদ, আপে যতকু এনকা লেকাগে জিওনোয়া/নষ্টওয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","হেৎদ মিৎহুলাং যীশু নিয়া দৃষ্টান্ত/জোনোকা গামেদ কুয়ায়্য় য়, যাহায় মিহুড় হড়রাঃআ, দ্রাক্ষাঃআ/দ্রাঃআক্ষা বাড়গি/বাহড় রে মিয়াত লোয়া দারু রহাকান তাহিন কান তেয়া/তাহীনো কেনা, হেৎদ ইনি জো নাম নাতিনাং হিচ লেনায় মেন্খান কায় নাম লায়। ");
INSERT INTO cdz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ইনাতে ইনি দ্রাক্ষাঃআ/দ্রাঃআক্ষা বাকরি/বাহড় মালিএ/মালিকে গামকিইয়ায়্য়, নেলেম/নেলেমে, তিহিং আপি সির্মাং ধাবিজ নিয়া লোয়া দারুতে হিজু তানাইঞ জো নাম নাতিনাং, মেন্খান জাহানা কাইঞ নামে দা/তানা। নিয়া মাআয় মে, মাআ গিডিয় মে, ইনা/নিয়া বেকার অতে এসেদে তানায়/দখল লে তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ইনি গাম রুয়াড় কিত্ কিয়ায়, এ কর্তা, নিয়া সির্মাং হ ইনাটা তাহি তকাম, ইমিন রে/ইমিন ভুর ইঞ ইনা চারুধার উর কাতে সারিং হেরেয়া/এমেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","হেততে হিজু সির্মাং জো লেন্খান, বেশ, বানখান তায়মতে মাআ গিডি আয়িং। ");
INSERT INTO cdz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","বিশেষ মিয়াত ঝিরাঃআও মাহারে যীশু মিয়াত সমাজ-অড়ারে/মন্ডলী রে চেদ/ইতু কেৎ কেন কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","নেলেপে মিয়াত বাহুকুড়ি/এরাঃআহন অকয় কেৎ গেল ইরাঃআল সির্মাং মিয়াত নারাঃআদুরাঃআইচিতান বঙ্গাতে এসেরাঃআ কানায়, ইনি কুয়ী আকান্তে, একালগে/যাহালেকাতে হ কায় সজেহে দাড়ি তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ইনিকে নেল কিত্ খানয় যীশু রাঃআ কিয়ায়, হেৎদ গামকিয়ায়, এ বুড়ি, আম আমাঃ নারাঃআদুরাঃআ/নিজুরি /কাহিলাকান দুখ হাতেন/হাতেম ছাডায়নাম, হেৎদ আয়া চেতানরে তিহি দঃহ কিইয়ায়্য়/চাপু কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ইনাতে ইনি দ ইন্তং গে/সঙ্গে সাথ সজেহে নায়/সজেহে গদে নায়। হেৎদ ঈশ্বরএ মারাঃআং কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","মেন্খান যীশু সমাজ-অড়ারে/মন্ডলী রিনিজ মুখিয়া/চালোনিয়া দ রাঃআগে/এসেদ এনায় চিয়াচি যীশু দ ইনিকে ঝিরাঃআও মাহা রে বুগি লিয়ায়, ইনাতে গাদালেকা/গাদেল হড়কুকে গামাৎ কুয়ায়্য় , তুরুই মাহা মেনা, ইনা মাহা/হুলাং কুরে দ কামী পে/কামী লাগতিংয়া। বুগি নাতিনাং ইনা মাহা/হুলাং কুরেগে হিজু পে, ঝিরাঃআও মহা হুলাং দ লহয়। ");
INSERT INTO cdz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","মেন্খান প্রভু ইনিকে গামরুয়াড় কিয়ায়, এ বেদা হড়কু, আপে মিমিত হড় দ আপেয়া উরিঃজ চাএ/চায় গাধা ঝিরাঃআও মাহারে গড়া হাতেন লাড়াকাতে, দা নু দ কাপে ইদি কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","এন্খান নিই বাহুকুড়ি/এরাঃআহনরাঃআ দ, আব্রাঃআহাম রাঃআ কুড়িহন/হনরাঃআ তানায়, নেলেপে অকয় কেৎ শয়তান গেল ইরাঃআল সির্মাং ধাবিজ তল দঃহ তিয়ায়, কিনা/চিয়া ঝিরাঃআও মাহারে ইনি রাঃআ তল/তনলেতে রাঃআড়া/লাড়া কা লাগতিংয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","নিয়া গাম কেৎ খানয়, ইনি রাঃআ যত মুদাইকু গিউয়েন তে হেৎদ যত গাদেল হড়কু ইনি দ্বারাঃআয় তে যত আকাদান্দা কামিতেকু রাঃআসকায় না। ");
INSERT INTO cdz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ইন্তং ইনি গাম কিইয়ায়্য়, ঈশ্বর রাঃআ রাঃআজ্য দ চিকানা/কিনা লেকা? ইঞ ইনা কিনালঅ তুলনাআইঞ /জুড়িআয়ইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ইনা দ মিয়াত বাটনা জাং লেকা, ইনা মিয়াত/মিহুড় হড় ইদিকাতে আয়া বাড়গি রে/বাহড় রে হের কিইয়ায়্য়, হেৎদ ইনা দ হারাঃআয় না, হেৎদ মারাঃআং গে দারুয়েনা হেৎদ সেরমা/চেতান রিঙ্কূ অড়েকু হিজু কাতে দারু ডাইর রে তুকা কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","অটঃ হ ইনি গাম কিইয়ায়্য়, ইঞ কিনা লো ঈশ্বর রাঃআ রাঃআজ্য তুলনাআইঞ /জুড়িআয়ইঞ ? ");
INSERT INTO cdz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ইনা এনকান রাঃআনু লেকা, অকা দ মিয়াত বাহুকুড়িহন হাতাকাতে আপি সের হলং রে ইনা আউরি রাঃআনু চাবা ধাবিজ শুইদ মেসা কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","যীশু শেহার রে হেৎদ হাতু হাতুরে দাড়া কাতে চেদকু তানলঅ যিরুশালেম দর সেনঃকেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","মিত হড় দ ইনিকে কুলিকিয়ায়, এ প্রভু, কিনা, বানচাও কুদ হুডাং গেকু হুয়ুয়া? ");
INSERT INTO cdz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ইনি ইঙ্কূ কে গামাৎ কুয়ায়্য় , রেসেদ হুদিং নানহা দুয়ার তে বলঃঅ নাতিনাং গাদা লেকা হড় বলকু সানাংআ/নানামা মেন্খান কাকু বলঃঅ দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","অড়া মালিক বিরিৎ এন্তে দুয়ার হানঢেত কেৎ তায়মতে আপে বাহার/রাঃআচা রেপে তিংগুনা হেৎদ দুয়ার পে টোটোয়আ হেৎদ গামেয়া পে, এ প্রভু, হলেজ/নিজআ লেপে, এন্তে ইনি গাম রুয়াড় পেয়ায়, ইঞ আপেকে কাইঞ সারিয়া। আপে দ কদের রিঙ্কূ। ");
INSERT INTO cdz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ইন্তং আপে গাম লাগা পে, আলে আমলো জম-নু লালে, হেৎদ আম আলেয়া হরাঃআকুরে ইতু কেনলেআপে/চেদ কেনলেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","মেন্খান ইনি গামকিইয়ায়্য়, ইঞ আপেকে গামতানাপিং/গামকেয়াপিং, ইঞ কাইঞ সারিং, আপে কদের রিঙ্কূ হড়। এ যত এটকান কামীকেনকুদ, ইঞ আ হান্ডে হাতেন অচঃগ/নির জম পে। ");
INSERT INTO cdz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","নাহা আপে দ আব্রাঃআহাম, ইসহাক, যাকোব হেৎদ যত ভাবি-জাগারিজ কু ঈশ্বর রাঃআ রাঃআজ্যরে দুবা কানা/মেনাপেয়া হেৎদ আপেকেগে রাঃআচারে/বাহার রে উডুং গিডিয়াকান পে, নেলেনরে/ ইন্তং আপে ইয়ামাপে, হেৎদ ডাটা তগজ জেয়া পে। ");
INSERT INTO cdz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","পূব হাতেন পছিম উতার হেৎদ উতর হাতেন দখিন ধাবিজ হড় হিচ কাতে ঈশ্বর রাঃআ রাঃআজ্য রে ভোজ কু জমেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","হেৎদ নেলেপে অকয় নাহা তায়ম গেয়ায় ইন্তং ইঙ্কূ দুকু মাড়াং ওআ হেৎদ অকয় নাহা মাড়াং রেকুয়া ইন্তং ইঙ্কূ দুকু তায়ম মোআ। ");
INSERT INTO cdz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","গটা /এনে ইন্তং গে মিৎ বার ফারিশি কু হিচে ন তে গামকিয়া, দু সেনমে হেৎদ নেন্ডে হাতেন অচগো মে, চিয়াচি হেরদ আমকে গয় নাম তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ইনি ইঙ্কূ কে গামাৎ কুয়ায়্য় য়, আপে সেন কাতে তুয়ু হেরোদ কে গামিপে, তিহিং হেৎদ গাপা বঙ্গা কুইঞ /কেকুইঞ উডুং /ছাডাত কুআইঞ /ছাডা তান কু আইঞ হেৎদ বুগিতানকুআইঞ। তিসার/আপি মাহা হুলাং তেয়ার রোআইঞ /ইঞ আ কামী পুরাঃআ/চাবা আইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","মেন্খান তিহিং, গাপা হেৎদ মেয়াং হুলাং দ সেন/হনর হুইয়া, চিয়াচি মিয়াত ভাবি-জাগারিজ যীরুশালেম বাহাররে গয়ঃজ আয়, নিয়া দ কা হুই দাড়িআ। ");
INSERT INTO cdz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","এ যীরুশালেম, এ যীরুশালেম, আম ভাবি-জাগারিজ কুকে গয়চতাকুয়াম/ভাবি-জাগারিজ কুরাঃআ গয়ঃজিয় হেৎদ আমাঃ হান্ডে কুলিচ /কুলহড় কুকে দিরি তে তেন/ঠকনা গয়তাকুয়াম, এঙ্গা সিম আয়া হন কুকে পাখনারাঃআ/ডানারাঃআ লাতার রে দাপালকুতান লেকা/গুনগুটেতকুতান লেকা চিমিনসা ইঞ আমাঃ হনকু হাউড় সামটা/হুন্ডি সানাকিংআ, মেন্খান আপে কাপে রাজি লেনা। ");
INSERT INTO cdz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","নেলেপে, আপেয়া অড়া দ আপেয়া নাতিনাং খালিগে/আজুড়িগে বাগি গিডি তাহিনা। হেৎদ ইঞ গাম তানা পিং আপে দ ইঞকে কাপে নেলনামিয়া, ইনা মাহা সেটের যাকিৎ, ইনা চীললং গামলা পে, প্রভু নুতুম তে হিখড়ম না য়ইজ দয় বুগিনগেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","মিয়াত ঝিরাঃআও মাহারে, ফারিশী কুরাঃআ/কয়তে মিহুড় মুখিয়া রাঃআ অড়া রে যীশু জম নাতিনাং সেনে এনায়, হেৎদ ইঙ্কূ ইনিকে ক্যয়্য়দহ তানকু তাহি না। ");
INSERT INTO cdz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","হেৎদ নেলেপে, মিয়াত উদরী আকান হড় ইনি রাঃআ/ইনিয়া সামাং রে তাই কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","আইন ইতুনিকু/পণ্ডিতকু কে হেৎদ ফারিসী কুকে, যীশু কুলি রুয়াড় কেৎ কুয়ায়্য় য়, ঝিরাঃআও মাহারে হড় বুগি হড় য়া চি লহয়? মেন্খান ইঙ্কূ হাপে/থির-থার/থিরে এ নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ইন্তং যীশু ইনিকে সাবকিয় তে বুগি কিয়ায় তে কুল কিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","হেৎদ যীশু ইঙ্কূ কে কুলি কেৎ কুয়ায়্য় য়, আপে কুয় তে যাহায় রাঃআ গাধহা চাএ/তায় উরি কুঁয়া রে নুরাঃআ কানায়/উয়ুয়া কানায়/উয়ুগো রেদ কিনা ইনি ইন্তং গে ঝিরাঃআও মাহা হুলাং রেগে ইনি দ আপে কাপে রাঃআকাব বিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ইঙ্কূ নিয়া থুতি/জাগার রাঃআ কাকু গামরুয়াড় দাড়ি লাআ। ");
INSERT INTO cdz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ইনাতে রাঃআকান পাহি কু চিল্কা মাড়াং রেগে দুবা আকান বাছাউয়ান কুকে নেলকুত তে মিয়াত জনকা গামাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় , যাহায় দুতাম ভোজ রে জম নেহরাঃআ/কেড়া মেয়াকু/রেদ, মাড়াং টায়াদ/থাং রেদ আলাম দুবা, পাছেন আমাঃ হাতেন বাপধন/মাইনান হড়কু খবর/নেহরাঃআ/কেড়া কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","আম হেৎদ ইনি এ নেহরাঃআ/কেড়া কেৎ রিনিজ দ হিচ কাতে/ হিজু লেন্তে গামমায়, থান/টায়াদ দ নিই য়ে আড়াই মে হেৎদ আম দ গিউ য়েন্তে যত হাতেন লাতার/তায়ম উতার দুবা/টায়াদ/থাং রে দুবে হুইয়ে না। ");
INSERT INTO cdz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","মেন্খান আমেম নেহর হুই লেন রে আম দ যত হাতেন লাতার/তায়ম টায়াদ/থাং রে দুব মে এন্খান আম নেহর/খবর রাঃআ কেৎ মেনিঃইজ দ হিচ কাতে গাম মেয়ায়, এ গাতি দেলা মাড়াং/চেতাং থাং রে হিজু মে। ইন্তং আম যত পাহিকুরাঃআ সামাং রে মাইনোআম/ধনঃনো আম। ");
INSERT INTO cdz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","চিয়াচি মারাঃআঙগইজ দয় হুডিংওআয় হেৎদ যাহায় হুডিংইজ দয় মারাঃআংওআয় (উসুললিজ দয় নিন্ধান নোআয় হেৎদ নিন্ধানিইজ দয় উসুল লোআয়)। ");
INSERT INTO cdz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ইনি দ আয় নেহরাঃআ/খবর রাঃআ কানিজকে/তানিজকে গামিয়ায়, আম সিঙ্গি রে চায় আয়ুবরে জমা তেয়ার/বাই রেদ/লেনখান আমাঃ গাতি কু চায় বকম কু চায় পাহি-পেড়া কু চায় হাতু-পড়শি কুরাঃআ কিসাড়কু দ আলাম খবরাকুয়া/নেহরাঃআ কুয়া, পাছে ইঙ্কূ হ আমকে নেহরাঃআ মেয়া হেৎদ হালা রুয়াড় মায়। ");
INSERT INTO cdz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","মেন্খান আম মাড়াং জমা তেয়ার/বাই এম/রেদ, রেঙ্গেজ, থুন্টা, লেংড়া হেৎদ কাঁড়া কুকে নেহরাঃআ কুম। ");
INSERT INTO cdz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ইনাতে ইঙ্কূ দ হালা-রুয়াড় নাতিনাং জাহানা হ বানু আন তে, আম দ বুগিন গেয়া, চিয়াচি আম দ ধরম হড়কুরাঃআ বিরিৎ -রুয়াড় রেদ আশিস য়াম, মাইণ সির্পা নামেয়াম। ");
INSERT INTO cdz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","নিয়া থুতি কু আয়ুম কাতে, যীশু লো জম দুব আকানকুরা তালা হাতেন মিয়াত হড় নিয়া গাম কিইয়ায়্য়, বুগিয়ানগেয়ায় ইনি দ, অকয় ঈশ্বর রাঃআ রাঃআজ্য রে ভোজ জমে আয়। ");
INSERT INTO cdz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","যীশু ইনিকে কহিনী গাম কিয়ায়, মিত হড় মারাঃআং ভোজ তেয়ার ককিইয়ায়্য় হেৎদ গাদা লেকা হড় কে রাঃআ কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ভোজ জম সময়/ঘাড়ি হুই য়েন খান, ইনি দ আয়া দাসি কে কুল কিয়ায়, নেহরাঃআ/খবর আকানা কুকে গামকুম, মার/দেলা হিজু পে, নাহা দ যতচ তেয়ার হুইয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ইন্তং ইঙ্কূ রায়ান যতচ হড় মিত মন য়েন্তে ছেমা আসি কু এটে কেয়া। সিদানিঃ দ গাম কিইয়ায়্য়, মিয়াত বাইত/অতে এইঞ কিরিং কেয়া, ইনা নেল আগু সেন হুয়ু তিংআ, বিন্তিয়া মেতানাই, ইঞ কে ছেমা কাইঞ মে। ");
INSERT INTO cdz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","এটাগিজ দ গাম কিইয়ায়্য়, ইঞ মড়-এ জমকা/আরাঃআড়া/আরাঃআর হালিয়াইঞ কিরিং কিরিং তাকুইঞ /কিরিংয়াকাদকোইঞ হেৎদ ইঙ্কূ নেল-আটকার নাতিনাং সেন হুইয়া, বিন্তিয়া মেতানাই, ইঞ কে ছেমা কাইঞ মে। ");
INSERT INTO cdz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","অটঃ এটাগিজ গামকিয়ায়, ইঞ দ নেয়ে/নেএ গে দুতুমা কানাইঞ, ইনাতে কাইঞ সেন দাড়ি তানা। ");
INSERT INTO cdz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ইনি দাসি রুয়াড় হিচ কাতে, আয়া কিসাড়/মালিক/গমকে কে গাম কিয়ায়, এন্তে অড়া গমকে রাঃআগ/এসেদ য়েন্তে, আয়া দাসি কে গামকিয়ায়, দু, উসারাঃআ গে, শেহার রাঃআ কুলহি কুরে হেৎদ সেসেদ হরাঃআ কুতে সেন গদ মে হেৎদ রেঙ্গেজ, থুন্টা, লেংড়া হেৎদ কাঁড়া কুকে নেন্ডে আগু কুম। ");
INSERT INTO cdz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ইনি মুনিস হিচ কাতে গামাকিয়ায়, এ গমকে, আম অকা আনচু লিংয়া, এনকা গে হুইয়া কানা, নাহা হ থাং মেনা গেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ইন্তং প্রভু/গমকে গাম কিয়ায়, দু, সড়প হরাঃআতে হেৎদ সীমা হরকাতে সেনকাতে, হড় হিজু নাতিনাং জর কাতেন/আকু টেগে/আয় তেকে গু হিজু কা, যাতে ইঞ আ অড়া পেরেজ ও কা। ");
INSERT INTO cdz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","চিয়াচি ইঞ আপেকে গাম তানা পিং, ইঙ্কূ নেহরাঃআ/খবরাঃআলা কুইঞ, হড় কুয়তে মিহুড় হঅ ইঞ আ ভোজ কাকু চাখায়া। ");
INSERT INTO cdz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","গাদেল হড় যীশু লো সেন কেনা কু, ইনি কয়অ রুয়াড় কেৎ তে, গামাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","যাহায় ইনা হান্ডে হিজু য়া কু হেৎদ আয়া আপু, এংগা, এরাঃআ হন-হপনকু (বকঃ-বায়া)বকইঞ /হাগাইঞ হেৎদ মিসি/মিসিরাঃআ কু হেগে/অটঃ গে আয়া জিউ হ কায় হিলায় রেদ/খান ইনি ইঞ আ চেলা কায় হুই দাড়িআয়। ");
INSERT INTO cdz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","অকয় আয়া কুরুশ কায় গঅ দাড়িয়ায় হেৎদ ইঞ আ তায়ম তে কায় হিজু আয়, ইনি দ ইঞ আ চেলা কায় হুই দাড়ি আয়। ");
INSERT INTO cdz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ভালা/ভালে/সার্তিগে, আপে কয় তে যাহায় মিহুড় বাখুল বানা/বানহা সানালিয়া, কিনা ইনি দুব কাতে খরচ কায় হিসাব মাড়াংআয়, এনকাতে ইনা পুরাঃআও নাতিনাং টাকা কুলিয়া তেয়া/তায়া চি লহয়? ");
INSERT INTO cdz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","বাংখান পাছে রেনঢেত বাইসা কাতে কায় চাবা দাড়িয়ায় খান, যত নেনেল কুকু লান্দায়া হেৎদ গামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","নিই হড় বাই/বানহা এহবকিইয়ায়্য়, চাবা/মুচাৎ /মুকাম মা কায় চাবা/মুচাৎ /মুকাম দাড়িলাআয় (নিই হড় বাই মা বাই কিইয়ায়্য়)। ");
INSERT INTO cdz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","যাহায় রাঃআজা ভালা, এটা রাঃআজালো মাপা-তুপুইঞ /লাড়হাই ও সেন খানয় মাড়াং রে দুব কাতে কায় পাহামেআয়, যে বিশ জুলু পাল্টন ইদিকাতে লাড়হাই হিখড়ম না য় ইনি রাঃআ বিরুধরে কি দশ জুলু পাল্টন ইদিকাতে ইনি রাঃআ সামাংরে সেন দাড়িয়াইঞ ? ");
INSERT INTO cdz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","যদি কায় দারাঃআম দাড়িয়ায় খান, ইনি রাঃআ হাতেন সাংগিন রে তাহীন রেগে আয়া কুকলি-সেরেদতান কুকে কুল কেৎ কুতে, ইনিলো সুলুক-দঃহ/সুলুক-নামভাড়ায়আয়। ");
INSERT INTO cdz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","নিয়া লেকাগে, আপেকোয়তে যাহায় আয়া যতচ া মেনাতেয়া ইনাকু কায় বাগিরেদ ইঞ আ চেলা কায় হুই দাড়িয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","বুলুং মা বুগিনা মেন্খান বুলুংরাঃআ স্বাদ নষ্টয়া, এন্খান ইনা অটঅ চিল্কাতে রাঃআহাম/উসুর হড় োয়া। ");
INSERT INTO cdz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ইনা দ চি অতেরাঃআ/হাসারাঃআ, চি সাররাঃআ ঢিপিরাঃআ উপযুক্ততানা/আইদারীনা, হড় কুদ ইনা বাহার রেকু গিডিয়াকু। আয়ুমরাঃআ লুতুর মেনাতেয়া ইনিদ আয়ুমেকায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","মাসুল রাঃআকাব/উঠাও কু হেৎদ কাইয়ান হড় কু যীশু রাঃআ চেচেদ জাগার আয়ুম নাতিনাং ইনি রাঃআ হান্ডে হিচ হুন্ডি নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ইনাতে ফারিশী কু হেৎদ আইন ইতুনি কু/সাস্তর পণ্ডিত কু কুরুম ড়ুরুম য়েনা হেৎদ নিদ পাপী হড়কুকে আতাংয়েত কুয়ায়্য় য়, হেৎদ ইঙ্কূ লো জমে তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ইন্তং ইনি ইঙ্কূ কে নিয়া উপমা গামাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","আপেকোয় তে যাহায় রাঃআ মিত-শ ভিডি কু মেনাকুয়া হেৎদ ইঙ্কূ য়তে মিয়াত ভিডি আদে নায় কিনা ইনি ইন/ইঙ্কূ গ্রাহ গেলে গ্রাহ বিররে কায় বাগি তকা কাতে, হেৎদ ইঙ্কূ আদাকানিয় আউরি নাম ভুর কায় পাঞ্জাভাড়া আয়। ");
INSERT INTO cdz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","হেৎদ ইনি নাম লেন খান/লেখান, ইনি রাঃআসকা তে আয়া তারাঃআন রে লাৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","হেৎদ অড়া তে হিচ কাতে গাতি কু হেৎদ হাতু/পাড়া পড়শি কুকে রাঃআ হুন্ডি কাতে কায় গাম কুয়ায়্য় য়, ইঞ লো রাঃআসকায় পে, এন্তে আতলেনতিংআ ভিডি দ নাম রুয়ার তিং। ");
INSERT INTO cdz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ইঞ গাম তানাপিং, এংকা গে মন পাল্টা রুয়াড়/হিয়াতিং কা লাকতিং তানা গ্রাহ গেলে গ্রাহ ধার্মিকোয় তে ইন্তি মিয়াত মন পাল্টা রুয়াড়/হিয়াতিং তান পাপী নাতিনাং চিন্তিত সেরমা রেকু রাঃআসকা য়া। ");
INSERT INTO cdz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","চায়/এন্তে যাহায় বাহুকুড়ি গেল সিকি মেনাতেয়া, হেৎদ ইনি মিয়াত আত লেন খান, কিনা ইনি দ দিমি/দিউহা জুল কাতে অড়া কায় জগেআয়/জয়আয়, হেৎদ ইনা আউরি নাম ভুর/ধাবিজ চুহুল/চগল তে কায় পাঞ্জা ভাড়া আয়। ");
INSERT INTO cdz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","হেৎদ নাম লেন্খান ইনি গাতি কু হেৎদ হাতু/পাড়া পড়শি কুকে রাঃআ হুন্ডি কাতে কায় গাম কুয়ায়্য় য়, ইঞ লো রাঃআসকা পে, এন্তে আতলেনতিংআ সিকি দ নাম রুয়ার তাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ইঞ গাম তানা পিং এংকা লেকা গে, মিহুড় পাপী মন পাল্টা রুয়াড়/হিয়াতিং লেন্খান ঈশ্বর রাঃআ সরগ নাগা কু সামাং রে রাঃআসকা য়া। ");
INSERT INTO cdz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","অটঃ হ যীশুদ অট মিয়াৎ উপমা গাম কিইয়ায়্য়, মিয়াত হড় রাঃআ বারিয়া, কড়া হন তাহীন কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","মিৎ হুলাং হুডিং হন আপুতেত কে গাম কিয়ায়, এ বা, ধন-সম্পদ রাঃআ জাগে হাটিংয়া/হাক তিংয়া হুইয়া এমাইঞ মে। ইনাতে আপুতেত ইঙ্কিন কে সম্পতি হাটিং আত কিনায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","হুডাং মাহা তায়ম তে হুডিংইজ হন যতচ া হুন্ডি কেৎ তে, সাংগিন দিশুম তে সেনে নায় হেৎদ এন্ডে আয়া সম্পতি নাআহানা এট্কান কামিতে (লানছান কাতে) ছিতিবিতি/অটাং চা কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","হেৎদ যতচ অটাং চাবা কেৎ খানয়, ইনা দিশুম রে কুঠিন মারাঃআং আকাল সেটের এনা হেৎদ ইনি দ রেঙ্গেজ য়েনায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ইন্তং ইনি ইনা দিশুম রিনিজ মিয়াৎ হড় রাঃআ হান্ডে মিয়াত মুনিস লেকা তাহি নায়, ইনি আয়া মিয়াত ডাহি রে শুকুরি গুপি য়ে কুল কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","হেৎদ ইনি শুকরি কু জমেদ কেনা চকলা/লুপু কুতে আয়া লা হিচ বি সানাংতানয়/নামে নায়, মেন্খান যাহায় হ জাহানা জমা নাতিনাং কাকু এমালিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","মেন্খান/এন্তে ইনি ভুল বুঝাকেৎ খানয়/সুতিয়েন্তে গাম কিইয়ায়্য়, আপুইঞ অড়া রে চিনতি-চিনতি মুনিস কু (অটঃ-অটঃ তে জমেয়া কু) সারে উতারে লেকা জমা মেনা তাকুয়া আর ইঞ নেন্ডে রেঙ্গেজ তিং গয়চ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ইঞ বিরিৎ কাতে আপুইঞ রাঃআ হান্ডে সেনআইঞ হেৎদ গামিয়াইঞ, এ বাবা/বাআ ইঞ দ সেরমা রাঃআ বিরুদ্ব রে হেৎদ আমাঃ সামাং রেইঞ কাই তাৎ আ। ");
INSERT INTO cdz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ইঞ দ আমাঃ হন গামলেকানিয় কাইঞ তানা। আমাঃ মিয়াত মুনিস লেকা দঃহ তাইঞ মে। ");
INSERT INTO cdz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ইনাতে ইনি বিরিৎ কাতে আয়া আপুতেত রাঃআ হান্ডে রুয়াড় হিচে নায়, হেৎদ ইনি সাংগিন রে তাহীন রেগে, আপুতেত ইনিকে নেল নাম কিয়ায় হেৎদ দায়াতে পেরেজ এনায়, ইনি নির সেনে নায় হেৎদ হাম্বুদ কিয়ায় হেৎদ চঅ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ইন্তং হনতেত আপুতেত কে গাম কিয়ায়, এ বাবা/বাআ ইঞ সেরমা রেয়া হেৎদ আমাঃ সামাং রে পাপ আকাদা। ইঞ দ আমাঃ হন গামলেকানিয়ই কাইঞ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","মেন্খান আপুতেত আয়া দাসি কুকে গামাৎ কুয়ায়্য় , উসারাঃআ গে, বুগিনা সন মিয়াৎ আগুই পে হেৎদ ইনিকে তুসিংই পে, তিহি রে মুদাম/আংটি হেৎদ কাটা রে খড়ম তুসিং ই পে। ");
INSERT INTO cdz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","আসুল মোটা আকানায় পুশু বাছারাঃআ গুই পে হেৎদ গজি পে হেৎদ আবু জমকাতেবু রাঃআসিকায়াআ। ");
INSERT INTO cdz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","এন্তে নি ইঞ আ হন গয় লেন তাহি কেনায় হেৎদ জিউত রুয়াড় আকানায়। আত লেনায় নামা কানায়। হেৎদ ইঙ্কূ রসিকায় কো এটে কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ইন্তং মারাঃআংইজ হনতেত ক্ষেত/বাইত রে তাহীন কেনায়, হেৎদ হিজু তানরে অড়া তায়া সেটের য়েন্তে রুতুতে এনেজ তানাকু সাডি আয়ুম কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ইনি মিয়াত দাসকে রাঃআ কাতে কুলি কিয়ায়, নিয়া যত কিনা তানা? ");
INSERT INTO cdz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ইনি গাম রুয়াড় কিয়ায়, আমাঃ বকম অড়া তে রুয়াড় হিচ া কানায়, বা তামাঃআ আসুল মোটা আকানায় পুশু বাছারাঃআ গয় তিয়ায়, চিয়াচি আপুম ইনিকে বুগি/বেশ গটা ার নাম তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ইনাতে ইনি মারাং হাগা রাঃআগায় নায় হেৎদ অড়া ভিতার তে কায় বলঃঅ সানাং য়েনায়/লেনায় ইন্তং আয়া বা তেত্তাগে উদুঙ য়েন্তে ইনিয়ে বিন্তি/নেহরাঃআ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","মেন্খান ইনি অপুতেত কে গাম রুয়াড় কিয়ায়, নেলেম/নেলেমে, ইঞ আমিন সির্মাং হাতেন আমাঃ কামী আগু কিং/আগুই তানা যাহা চিললং আমাঃ জাগার/আনচু/হুকুম কাইঞ টোটা তা, তুবুই রহ আম ইঞ আ গাতি কুলঃঅ রাঃআসকা নাতিনাং যাহা চিললং মিয়াত মেরম হন হ কাম এমা তিংয়া ");
INSERT INTO cdz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","মেন্খান আমাঃ নিই হনতামা দ বেশ্যাকুলঃঅ সম্পত জম ওটাং কেৎ তে হিচে নায় খান, আম দ ইনি নাতিনাং আসুল মোটা আকানায় মীহুম/বাছারাঃআ গয় কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","মেন্খানঅপুতেতইনিকে গাম কিয়ায়, এ হনআম জানাব/সেতা-আয়ুব ইঞ লো মেনা মা হেৎদ ইঞ আ যতচ া আমাঃ গে তানা। ");
INSERT INTO cdz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","মেন্খান রাঃআসকা হেৎদ ভোজ/সুখ দ লাকতিং তান গেয়া, নি আমাঃ হুন্ডিঙ বকম গচ লেনায় হেত্তে জিউত রুয়াড় আকানায়, আত লেনায় নাহাআ নাম রুয়াড়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","হেৎদ যীশু আয়া চেলা কুকে গামাৎ কুয়ায়্য় , মিয়াত কিসাড় হড় তাহীন কেনায়, ইনি রাঃআ মিয়াত দেওয়ান তাহীন কেনায়, ইনি দ ধন-সম্পত তেয়া তহজ-নহজ/চিতি-বিতি য়দা মেন্তে ইনি রাঃআ সামাং রে দেওয়ান কে দোষী/চিটাকিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","কিসাড় হড় দ ইনিকে মিয়ুড় লিয়া রাঃআ কিয়তে গাম কিয়ায়, আমাঃ বাব্ত্তে ইঞ কিনা আয়ুম মে তানাই? আমাঃ দেওয়ান কামী রাঃআ লেকা/হিসাব এমাইঞ মে, আম দ অটঃ দেওয়ানি কাম তাহি দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ইন্তং ইনি দেওয়ান মনে মনে গাম কিইয়ায়্য়, কিনা চিকা আইঞ ? ইঞ আ প্রভু মা ইঞ য়া হান্ডে হাতেন দেওয়ানি-গিরি/কামি হাতেন উডুং হুই য়া, হাসা মাআ/তাড়া রাঃআ দাড়ি ইঞ আ বায়ায় না, ককয় আসি তে গিউগো ওইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ইঞ আ দেওয়ানি-গিরি হাতা/রেজ লেংখান/রেদ হড় কু আলয় আকুয়াআ আকুয়াআ অড়া রে দঃহ/আতাং ইয়া। ইনা নাতিনাং অকা করাঃআ ইঞ, ইনা সারি নাম কিং। ");
INSERT INTO cdz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","হেৎদ ইনি আয়া প্রভু যত ধারুয়া কুকে রাঃআ কেৎ কুয়ায়্য় য়, সিদাই কে গাম কিয়ায়, আম ইঞ আ প্রভু রাঃআ চিনতি ধারুয়া আম তেয়া? ");
INSERT INTO cdz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ইনি গাম কিইয়ায়্য়, উপুন জুলু লিটার সুনুম। ইন্তং ইনিকে গাম কিয়ায়, আমাঃ ধারুয়া-চুকা হতাম, হেৎদ ঘিড় মেন্তাং বার গেলে লিটার অলেম। ");
INSERT INTO cdz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","হেৎদ ইনি এটায়িজ/ অটঃ মিহুড়ইজ কে গাম কিয়ায়, আম চিনতি ধারুয়াম, ইনি গাম কিইয়ায়্য়, মিত শ বার বিসি গহম। ইন্তং ইনি গাম কিইয়ায়্য়, আমাঃ ধারুয়া-সেকাম হাতাম হেৎদ আসি অলেম। ");
INSERT INTO cdz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ইনাতে ইনি হুশিয়ার কামীতায়ায় মেন্তে ইনি রাঃআ মালিক ইনা কা/বে ধরমমান/অধার্মিক দেওয়ান কে সারহাও কিয়ায়। নিয়া পিড়ি রিঙ্কূ হন কুদ আকুয়াআ মার্শাল রিন হনকুএ তেজাত রেঙ্কূ সেড়ায়/হুশিয়ার য়ে না। ");
INSERT INTO cdz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","হেৎদ যীশু গাম কেৎআয় ইঞ গে আপেকে গাম তানা পিং, আপেয়া নাতিনাং বে-ধার্মিক ধন তে গাতি বাই জম পে, এন্তে ইনা চাবা লেনখান, ইঙ্কূ জানাম-জানাম রাঃআ /হানা পুরি রাঃআ অড়া রেকু দঃ পেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","অকয় হুডিং য়া/হুডাং রে/ইতিজ তকয় রে পাতিয়াও-লেকানিজ/ইমান দার তানায়, ইনি দ মারাঃআং/গাদা লেকা রেআ পাতীয়াওরো লেকা হেৎদ অকয় হুডিংয়া রে কা পাতিয়াও গেয়ায় মারাঃআং য়া রেহ কায় পাতিয়াওরো লেকায়/পাতিয়াও গেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","নিয়া মেন্তে আপে এটকান খুর্জিরে/ধন-দৌলত রে পাতিয়াওরো লেকা/পাতিয়াওনো লেকা কাপে তাহি কেন রেদ, এন্খান অকয় পাতীয়াও কাতে আপেয়া হান্ডে সার্তি তে সম্পা/জিমা পেয়াকু? ");
INSERT INTO cdz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","আপে এটা হড়রাঃআ এটায়িজ রাঃআ ধন রে কাপে পাতীয়াও লেকানিজ তাহি কেন রেদ, একখান অকয় নিজ ধন আপেকে এমাপেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","যাহায় দাসী বারিয়া মালিক কায় দাসী কামী দাড়িযায়, চিয়াচি ইন্তে ইনি মিহুড় কে হিংসাআইয়া হেৎদ এটাগিজ কে কুশিয়াআয়, চায়/চাএ মিহুড় লো মেশায় এটাগিজ লো কায় ছুতাং ইয়ায়। আপে ঈশ্বর হেৎদ ধার্তি ধন বারাঃআন রাঃআ কাপে দাসী কামী দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ইন্তং ফারিশিকু, একয় কু টাকা কুসিয়া/লালসা কু, নে নিয়া যত থুতিকু আয়ুম কেৎয়াকু, হেৎদ ইঙ্কূ যীশু কে টিটকারি/লান্দা কিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","যীশু ইঙ্কূ চেলা কু কে গামাৎ কুয়ায়্য় , আপে গে মান্মি/হড় কুরাঃআ সামাং রে আপেকে/আপে তেত কে ধার্মিক উদুয়াকু তানা পে, মেন্খান ঈশ্বর আপেয়া অন্তর সারি আয়, চিয়া চি মান্মি কুরাঃআ তালারে অকয় চেতান ওয়া/চেতাংইজ ইনি ঈশ্বর রাঃআ সামাং রে লাতারো আয়/ইর্খাওয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","সাস্তর/মোশি রাঃআ ব্যবস্থা হেৎদ অনল নবিকু যোহন যাকিৎ তাহিকেনা, ইনা হাতেন ঈশ্বর রাঃআ রাঃআজ্য রাঃআ বুগিন বার্তা/সংবাদ পাসরাঃআও তানা, হেৎদ যতচ /মিৎ -কে-মিৎ হড় জোর মত তে ইনা রাঃআজ্য রেকু বলন তানা। ");
INSERT INTO cdz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","সেরমা হেৎদ অতে আলগা তে পরম সেনয়া/সেন দাড়িয়া, মেন্খান ব্যবস্থা মিয়াৎ আচাড়/টুডা কায় মিটা দাড়িয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","যাহায় গে আয়া এরাঃআতেত কে বগি কাতে হেৎদ অটঃ মিহুড়ইজ কে দুতাম ওয়ায়/আঙগির ওয়ায়, ইনি হেৎদ যাহায় ছাডুই এরাঃআ/বাহুকুড়ি এটা কড়া লো অংগিরো আয়, ইনি হ আঙগিরাঃআ য়। ");
INSERT INTO cdz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","যীশু উপমা গাম কেৎআয়,মিহুর/মিয়াৎ কিসার হড় তাহীন কেনায়, ইনি হালি হেৎদ বুগিন সুতাম রাঃআ কিচি তুসিং ও কেনায় হেৎদ মাহা হুলাং এলাই-বালাই জম-নুই কেনায় আনন্দ ফুর্তি তে তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ইনি রাঃআ দুর সামাং রে লাসার নুতুমিজ/নুতুম তেয়া মিয়াৎ রেঙ্গেজ হড় তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ইনি ঘা তে পেরেজ আকান, হেৎদ ইনি কিসাড় অড়া রাঃআ মেজ হাতেন নুরু/হিরিজ তান টাকরাঃআ-টুকরাঃআ কু/কেচা-কুচু কু জম সানা কিয়া। হেৎদ সেতাকু হ হিচ কাতে আয়া ঘা জালি কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","মিৎ হুলাং রেঙ্গেজ হড় গয়চে নায়, সেরমা সরগ নাগা কু ইনিকে ইদি কিয় তেকু আব্রাঃআহাম রাঃআ কয়ং রেকু দঃহ কিয়া, হেৎদ ইনি কিসাড় হড় হ গয়য়ে নায়, হেৎদ তপা কিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","হেৎদ কিসাড় হড় পাতাল রে দুখ/জ্বালা তে সাহাতিং কেনায়, ইনি সাঙ্গিন হাতেন আব্রাঃআহাম কে আরিদ রাঃআকাব কিয়ায় হেৎদ ইনি রাঃআ কয়ং রে লাসার কে নেল নাম কেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ইনাতে ইনি কিকিচ কাতে গাম কিইয়ায়্য়, এ আপু আব্রাঃআহাম ইঞ কে দায়াইঞ মে, লাসার কে কুলিম, ইনি কাটু রাঃআ চুটি দা রে তুপু কাতে ইঞ য়া আলাং রাঃআড়েজ এ কায়, চিয়াচি নিয়া জুলু তান সেঙ্গেল-এলাং রে ছট-পটা তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","মেখান আব্রাঃআহাম গাম কিয়ায়, এ হন, পাহাম মেম, আমাঃ বুগিন জিনিস আম জীউৎ তাহীন রে নাম তাম, এনকাগে লাসার এট্কান নাম তাআয়, নাহা ইনি নিয়া থাং রে সুখ নাম তাআয় হেৎদ আম ছটফটা তানাম। ");
INSERT INTO cdz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","হেৎদ নিয়া যত ছাড়া আলে হেৎদ আপে তালারে মিয়াৎ মারাঃআং গাহডা/ফারাঃআক দঃহ মেনা, যাতে নেন্ডে হাতেন যাহায় আপেয়া হান্ডে সেন বুঝা/নানামা/সানাকুয়া, ইঙ্কূ কাকু দাড়িয়া, অটঃ এন্ডে হাতেন আলেয়া হান্ডে যাহায় পরম কাতে হিচ কাকু দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ইন্তং ইনি কিসাড় হড় গাম কিইয়ায়্য়, এন্খান ইঞ আমকে/আমিং নেহরাঃআ তানা মাইঞ, এ বা/আপু, ইঞ য়া আপুইঞ রাঃআ অড়া তে ইনি কে কুলিম। ");
INSERT INTO cdz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","চিয়াচি ইঞ য়া মড়েয়া বকঞ তিংয়া তুকু মেনাকুয়া, ইনি সেন কাতে ইঙ্কূ য়া হান্ডে গোহায় এমে কায়, যাতে ইঙ্কূ দ নিয়া দুকু টায়াদ তেকু/থাং তেকু আলকু হিজু কা। ");
INSERT INTO cdz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","মেন্খান আব্রাঃআহাম গাম কিইয়ায়্য়, ইঙ্কূ য়া হান্ডে মোশি হেৎদ নবি কু রাঃআ বেবস্তা রীতি মেনাআ, ইনা য়া থুতি গেকু ইঙ্কূ আয়ুম মে কা। ");
INSERT INTO cdz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ইন্তং কিসাড় হড় গাম কিইয়ায়্য়, ইনা দ লহয়, আপুইঞ আব্রাঃআহাম বচ্ছম গয় কুয়া তালা হাতেন যাহায় ইঙ্কূ য়া হান্ডে সেনায়, এনে এনকা হুই লেনখান ইঙ্কূ মন রুয়াড় এয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","মেন্খান আব্রাহাম গাম কিয়ায়, ইঙ্কূ যদি মোশি হেৎদ নাবি কুয়া থুতি কাকু আয়ুম মেয়াকু এন্খান গয় কুয়া তালা হাতেন যাহায় জীউৎ -রাঃআকাব/বিরিৎ লেন্খান হ ইঙ্কূ কাকু পাতিয়া/মানা য়া। ");
INSERT INTO cdz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","যীশু আয়া চেলা কুকে অটঃ হ গামাৎ কুয়ায়্য় , সময় কা সেটেরয়া, ইনা দ/নেকা দ কা হুই দাড়িয়া, মেন্খান অকয় দ্বারাঃআয় তে হুইয়া, ইনি দ হায়-হায়। হায় না। ");
INSERT INTO cdz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ইনি দ নিকু হুডিং কুরাঃআ তালা হাতেন মিয়াৎ তোদারি কাইএতে, ইনা হাতেন বচ্ছম ইনি রাঃআ হট রে যাতা দিরি হাকায়েনতে ইনি দরেয়া রেএ হুল্লা/হুরাঃআং গিদি লেংখান, নিয়া ইনি রাঃআ নাতিনাং বুগিনিয়ো তেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","আপে অপেয়া বাব্ত্তে হুসিয়ার তাহিন্পে, বকম যদি কাই ইয়ায়্য় এন্খান ইনিকে সটাই এমাই মে, হেৎদ ইনিএ মন রুয়াড় রেদ ছেমাই মে। ");
INSERT INTO cdz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ইনি মাহা রে/মাহা হুলাং এয়াই শা আমাঃ বিরুধ তে গুনহা এয়ায়, হেৎদ এয়াই শা আমাঃ হান্ডে রুয়াড় হিজু কাতে গামে আয়, মন-রুয়াড় কে ইঞ, এন্খান, ইনিকে ছেমাই মে। ");
INSERT INTO cdz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","হেৎদ কুলিচ কু প্রভু কে গাম কিয়াকু, আলেয়া পাতীয়াও মারাঃআং এম/জাদকায় মে। ");
INSERT INTO cdz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","প্রভু গাম কেৎ কিইয়ায়্য়, মিয়াত বাটনা জাং লেকা পাতিয়াও আপেয়া তাহীন রেদ/লেন্খান এন্খান আম বুটা-পাটা সমেত তুদ মে দরেয়া রে রয়/রহা মে, জাগার সুকামিন/লোয়া দারু কেপে গাম লেখান, ইনি আপেয়া থুতি আয়ুম মেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","আপে কুয়া তালা রে এনকা একয় মেনাইয়া, যাহায় নাহল/সিউ চায় গুপি দাসী মেনাই রেদ, ইনি ক্ষেত-বাইত হাতেন হিচ থরাঃআ ইনিকে গামিয়ায় মার আম নাহা গে জজম দুব মে। ");
INSERT INTO cdz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","বচ্ছম ইনিকে চি কায় গাম দাড়িআয়, ইঞ কিনা জমিং, ইনা তেয়ারেম/বাইএম, হেৎদ ইঞ চিমিন ভুর জম-নুইয়া ইমিন ভুর মায়াং তল কাতে ইঞ কে/ইঞ য়া সেবাইঞ /শুশরিং মে হেৎদ ইনা তায়ম তে আম জম-নুই মে। ");
INSERT INTO cdz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","চিয়া ইনি দাসি আন্চু কিয় কামি এ কামী কিইয়ায়্য় মেন্তে ইনি এ সারহাও কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","এনকা লেকাগে যত আন্চু আকান কামি কামী চাবা তায়ম গামে পে আলে দ একেন লে গুতি তেত তানা আবুলো ক দাসী কু কাতানাবুয়া আবু লাগতিং গে/লেক কামী এ সাকার বু কামী কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","যীরুশালেম তে সেন বাতিরাঃআং ইনি/যীশু শমরিয়া হেৎদ গালিল দিশুম রাঃআ তালা হরকা তে সেন তান কেনায়/সেনতান তাহি কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ইনি মিয়াৎ হাতুতে বলন তানায় ইন্তং গে/এনকান সময় গেলে থুন্টা হড় আয়া সামাং রে নুরে নাকু/নেল নাম কেৎ কুয়ায়্য় য় ইঙ্কূ সাংগিন রে তিঙ্গুই নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","হেৎদ ইঙ্কূ জোরতে কিকিচ কাতে গাম লাগায় নায় এ যীশু গুরু দায়া আলে মে ");
INSERT INTO cdz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ইঙ্কূকে নেল কাতে ইনি গামাৎ কুয়ায়্য় সেন পে দু বামড়ে রাঃআ হান্ডে সেন কাতে আপেতেত কে উদুয়া কূপে সেন সেন তে তেগে (সেন তানালো কো সাপা ফার্চায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ইন্তং ইঙ্কূ য়া তালা হাতেন মিহুড় আয় কে/নিজে কে বুগিয়া কানায় নেলেন তে কিকিচ কাতে ঈশ্বর রাঃআ মহিমা কেৎ তে রুয়াড় হিচে নায় ");
INSERT INTO cdz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","হেৎদ যীশু রাঃআ কাটা কাতারে তাবের/অম্বা/উকড়ুম য়েন তে ইনিকে জহার কিয়ায় ইনি হড় শমরিয় দিসুম রিনিজ তাহীন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","যীশু গাম রুয়াড় কেৎ কুতে গেল হড়কু কাকু সাপা-ফার্চা কানা? এন্খান ইঙ্কূ আরে/নয় জন কু কদেরে না? ");
INSERT INTO cdz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ঈশ্বর রাঃআ মহিমা নাতিনাং রুয়াড় হিচ া কানাকু নি এটা জাতি রিনিজ হড় বাগি কি তে এনকা যাহায় কেহ কি কাকু নাম লেনা? ");
INSERT INTO cdz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","হেৎদ যীশু ইনি কে গাম কিয়ায় মার বিরিৎ মে আমাঃ পাতিয়াও আমকে বুগি কেৎ মেয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ফারিশীকু যীশু কে কুলি কিয়া কু ঈশ্বর রাঃআ রাঃআজ্য দ চিললং হিজু য়া ইনি ইঙ্কূ কে গাম রুয়াড় কেৎ কুয়ায়্য় য় ঈশ্বর রাঃআ রাঃআজ্য নেল/নেপেল রে কা হিজু য়া? ");
INSERT INTO cdz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","হেৎদ হড় কু গামেয়া কু লহয় নেলেপে নেথাং রে/নেন্ডে টা চায় নেথাং রে নেন্ডে টা চিয়াচি নেলেপে ঈশ্বর রাঃআ রাঃআজ্য আপেয়া হান্ডে গে মেনা ");
INSERT INTO cdz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ইনি চেলা কুকে গামাৎ কুয়ায়্য় এনকান সময় হিজু য়া চিনতং আপে মান্মি হন রাঃআ মিৎ মাহা হুলাং নেল সানাপেয়া/নানামা পে মেন্খান কাপে নেল নাম দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ইন্তং হড় কু আপেকে গাম পেয়াকু নেলেপে হানে এন্ডে/হানা হান্ডে/হানে এন্থাং রে আলপে সেনয়া আলপে তায়ম তায়ম তে/পানতি-পাঞ্জা কুয়া ");
INSERT INTO cdz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","চিয়াচি চিল্কা বিজলি/জুলু তান হিজু র দ সেরমা লাতার মিৎ দর হাতেন ঝালকা লেখান এটা দর জকিৎ মার্শাল য়া মান্মি হন আয়া হুলাং এনকা গে হুই য়া ");
INSERT INTO cdz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","মেন্খান মারাঃআং/মাড়াং ইনিকে গাদা দুখ সাহা হুইয়া হেৎদ নিয়া/নে পিড়ি রেঙ্কূ হড় কু কাকু গ্রহণ/ছুতাং ইয়া ");
INSERT INTO cdz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","নোহ রাঃআ হুলাং/সময় চিল্কা হুই লেনা মান্মি হন রাঃআ হিজু মাহা হুলাং রেহ এনকা গে হুইয়া। ");
INSERT INTO cdz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","হড় কু জম নুই কেনাকু গংঅ-দুতাম কেনাকু নোহ চিমিন ভুর জাহাজ রে কায় দেচ এনায়/বলঃঅ লেনায় হেৎদ বান/দুবা দা হিচে ন তে যতোই কুকে/কে ধ্বংস চা কেৎ কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","এনকা গে লোট রাঃআ সময় রে চিল্কা হুই লেনা হড় কু জম নুই কেনাকু কিরিং আখরিং য়ে কেনাকু দারু লাগায় কেনাকু হেৎদ অড়া বাই য়ে কেনাকু ");
INSERT INTO cdz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","মেন্খান অকা হুলাং লোট সদোম হাতেন বাহার উদুঙ য়ে নায় ইনা হুলাং চেতাং হাতেন সেঙ্গেল হেৎদ গন্ধকএ নুর কেয় তে হেৎদ ইনা যত ধ্বংস চা কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","মান্মি হন অকা হুলাং উদু-সদর আয় ইনা হুলাং হ এনকা গে হুই য়া ");
INSERT INTO cdz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ইনা হুলাং অকয় গে ছাদ চেতান রে তাহি নায় হেৎদ আয়া জিনিস-গুটি অড়া রে মেনা ইনি ইনা নাম নাতিনাং লাতার আলোয় আড়গু হিজু কায় হেৎদ এনকা গে যাহায় বাইত ক্ষেত রে মেনা কুয়া/মেনা কু রেদ ইনি হ তায়ম দর রুয়াড় আল হিজু কায় ");
INSERT INTO cdz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","লোট রাঃআ এরাঃআ তেৎ কে পাহাম মিপে ");
INSERT INTO cdz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","যাহায় গে আয়া/আকুয়াআ জিউ বাঞ্চাও মেন রেদ/নানা মায় ইনি ইনা আদে আয় যাহায় গে আদ রেদ ইনি ইনা নামেআয় ");
INSERT INTO cdz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ইঞ আপেকে গাম তানা পিং ইনা নিদা হুলাং/নিদা রে বার হড় মিয়াত বিছানা রেকিন তাহিনা/গীতিজা ইঙ্কিন া হান্ডে হাতেন মিয়াত/মিহুড় কে ইদি আয় হেৎদ এটা গিজ কে বাগি তকায়। ");
INSERT INTO cdz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","বারিয়া এরাঃআ/বাহু কুড়ি হন মিসা/মিৎ তে যাতাকিন রিদেয়া ইঙ্কিন া মীহুড় কে ইদিয়া হেৎদ এটাগিজ কে বাগী তকায় ");
INSERT INTO cdz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ইন্তং ইঙ্কূ যীশু কে গাম রুয়ার কিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","এ প্রভু কদেরে? ইনি ইঙ্কূ কে গামাৎ কুয়ায়্য় কদেরে মাড়া এন্ডে গে গিধি জুটা/হুন্ডিয়া কু ");
INSERT INTO cdz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","মিৎহুলাং যীশু ইঙ্কূ চেলা কে মিয়াৎ জনকা/দৃষ্টান্ত গামাৎ কুয়ায়্য় মিমিৎ -মিমিৎ ঘাড়ি আপেয়া বিন্তি লাক্তি /লাকতিং তানা বিন্তি রে ঘাটতি/ঘাটি আলোয় তাহীন কা লাক্তি তানা/লেকতানা ");
INSERT INTO cdz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ইনি গামাৎ কুয়ায়্য় মিয়াৎ শেহার রে মিয়াত ধরবারিজ/ধরবারনিঃই তাহীন কেনায় ইনি ঈশ্বর কে কায় বরই কেনায় মান্মি কে হ কায় মানা কেন কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","হেৎদ ইনা শেহার রে মিয়াৎ রাঃআন্ডি বুঢি তাহীন কেনায় ইনি বুঢি ইনি রাঃআ হান্ডে হিচ কাতে গামি কেনায় ইঞ য়া বাইরি/অন্যায় বাবদ ধরবারাঃআইঞ মে অন্যায় রাঃআ বিরুধ/বিপক্ষ হাতেন ইঞ কে বাঞ্চাইঞ মে ");
INSERT INTO cdz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ধরবারিজ/ধরবারনিঃই হড় ঢের মাহা যাকিৎ কায় মানা লেনায় মেন্খান তায়ম তে মনে মনে গাম কিইয়ায়্য় ইঞ দ ঈশ্বর কেহ কাইঞ বরই তানা মান্মি কুকেহ কাইঞ মানা তান কুয়াইঞ ");
INSERT INTO cdz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","তুবুই রহ নিই রাঃআন্ডি ইঞ কে জ্বালাইঞ /সাতাইঞ তানায় ইনা নাতিনাং ইঞ দ ইনি রাঃআ ধরবারিং বাংখান নেকা গে অটঃ হ একশায়গে/ঘাড়ি-ঘাড়ি হিচ কাতে ইঞ কে সাতাইঞ য়া/জ্বালাইঞ য়া ");
INSERT INTO cdz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","হেৎদ প্রভু গাম ইদি কেৎ কুয়ায়্য় য় আয়ুম মে পে ইনি বিন-ধার্মিক ধরবারিজ হড়/ধরবারনিঃই কিনা গামেয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","এন্খান ঈশ্বর কি আয়া/আপনার বাছাআকানকু ইঙ্কূ অকয় সিঙ্গি-নিদা আয়া হান্ডে ইয়ামাকু কিনা ইনি অন্যায়রাঃআ প্র্রতিকার/ন্যায় কায় রুয়াড়া কুয়ায়্য় য় ? কিনা ইনি ইঙ্কূকে দেংগাতে হিলাং-ঢলংএয়ায়/দেরি আয় ");
INSERT INTO cdz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ইঞ আপেকে গাম তানা পিং ইনি উসারাঃআ গে ইঙ্কূ কে অন্যায়রাঃআ প্র্রতিকার/ধরবার এমা কুয়ায়্য় য় মেন্খান মান্মি হন চিনতং হিজু আয় ইন্তং কি ধারতি রে পাতিয়াও নেল নামেআয় ");
INSERT INTO cdz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","যাহায় আকুয়াআ চেতাং রে পাতিয়াও দহয় কেনাকু মনেয় কেনাকু ইঙ্কূগে ধার্মিক তানাকু এটা কুকেৎ নিহাতকু মনে কেনাকুয়াকু নেকান/এনকান কথক/মিহুড় বার হড়কে ইনি নিয়া জোনোকা/দৃষ্টান্ত গামাৎ কুয়ায়্য় ");
INSERT INTO cdz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","বার হড় কয় জম/বিন্তি নাতিনাং জাহের স্থান তে সেএ নাকিন মিহুড় দ ফরিশি অটঃ মিহুড় দ কর/মাসুল আদায়িজ/রাঃআকাবিজ ");
INSERT INTO cdz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ফারিশী তিঙ্গুইয়েন তে আয়-আয়গে নেকা বিন্তি জম কিইয়ায়্য়/কয় জম কিইয়ায়্য় এ ঈশ্বর ইঞ আমকে সারহাও এমা তানা মাইঞ ইঞ এটা হড় কুরাঃআ লুট/বাগা রেজ-আতকির বেদাকু আংগিরাঃআ কু লেকা চি ইনি মাসুল রাঃআকাবীজ লেকা দ লহয় তানাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ইঞ হাপ্তা রে বার্সাইঞ বারিং/উপাস দঃহ য়া যত আয় রাঃআ কামিয়ারাঃআ গেল/গেনেলেয়া হাটিং দানিং/এমেতানাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","মেন্খান মাসুল রাঃআকাবিজ সাঙ্গিন রে তিনগু য়েন্তে সেরমা দর আরিচ রাঃআকাব কায় দাড়িলায়/সানাকিয়া মেন্খান ইনি কুড়াম তাপড়ি কাতে কাহিসতে গাম কিইয়ায়্য় এ ঈশ্বর ইঞ পাপী হড়কে দায়াইঞ মে। ");
INSERT INTO cdz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ইঞ আপেকে গাম তানা পিং নি হড় ধার্মিক মেন্তে আয়া অড়া তে সেনে নায় ইনি হড় দ ধার্মিক লহয় বুটি উঠায়ইচ তানায় চিয়া চি যাহায় গে আয়তেত কে চেতাং রাঃআকাব ইয়াং ইনিকে আড়গু হুইয়া মেন্খান অকয় আয় কে লাতা রিয়ায় ইনিগে চেতাং রাঃআকাব আয় ");
INSERT INTO cdz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","হেৎদ আপু কু আকুয়াআ হুদিং হন কুকে হ ইনি রাঃআ হান্ডে আউ কেয়া কুয়াকু যাতে ইনি ইঙ্কূ কে জুতেৎ লেকাতে আশিস কু দাড়ি কুয়ায়্য় য় চেলা কু ইনা নেল কাতেন ইঙ্কূ কে এগের কেৎ কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","মেন্খান যীশু ইঙ্কূ চেলা কু কে ঠাইন তে রাঃআ কেৎ কুতে গামাৎ কুয়ায়্য় জু হন কুকে ইঞ য়া হান্ডে হিচ তকা কুপে ইঙ্কূ কে আল পে মানা/বাধা কুয়া চিয়া চি ঈশ্বর রাঃআ রাঃআজ্য দ নেকান হন হড় কু লেকা ");
INSERT INTO cdz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ইঞ আপেকে সার্তি গে গাম তানা পিং যাহায় গে হন লেকা হুই কাতে ঈশ্বর রাঃআ রাঃআজ্য কায় আতাং তেলালায় যাহা লেকা তে হ ঈশ্বর তে বলঃঅ কায় দাড়িআয় ");
INSERT INTO cdz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","মিয়াত জিহুদী মুখিয়া ইনিকে কুলি কিয়ায় এ বুগিন গুরু কিনা কামী লেখান ইঞ যায় যুগ জিয়ন/জিউইঞ নামেআইঞ ");
INSERT INTO cdz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","যীশু ইনিকে গাম রুয়াড়া কিয়ায় ইঞ কে বুগিনেম গামিং তানা? মিহুড় ছাড়া/বাগি কাতে অটঃ যাহায় সৎ/বুগিন বানু কুয়ায়্য় য় ইনি দ ঈশ্বর ");
INSERT INTO cdz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","আম হুকুম/আচুম আলম আংগিরাঃআ আলম গয় কুয়া আলম কুম্বুরুয়া বেদা/খালি/হসসড় গোহায়া আমাঃ এন্ঙ্গা আপু তেকিন কে মানা কিন মে ");
INSERT INTO cdz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","হানি হড় গাম কিইয়ায়্য় হন/বালেজ হাতেন নিয়া যতচ া পালা/মানা আগুই তানাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","নিয়া থুতি আয়ুম কাতেন যীশু ইনিকে গাম কিয়ায় নাহা যাকিৎ তুবুই রহ মিয়াত জিনিস তে/বাব্ত্তে তে খাটো গেয়া/অভাব গেয়া আমাঃ যা লেকা/গোটা মেনা যত আখরিং কাতে হেৎদ রেঙ্গেজ হড় কুকে হাটিংয়া কুম হেৎদ হিজু ম ইঞ য়া তায়ম তে ");
INSERT INTO cdz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","মেন্খান নিয়া থুতি আয়ুম কাতেন ইনি কুঠিন গে দুখ নাম কিইয়ায়্য় চিয়াচি ইনি আনড্রাঃআ/কুঠিন গে কিসাড় তাহীন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ইন্তং ইনিকে আরিদ/কয় কিয় তে যীশু গাম কিইয়ায়্য় যাহায় রাঃআ ধন মেনা ইঙ্কূ য়া নাতিনাং ঈশ্বর রাঃআ রাঃআজ্য রে বলঃঅ আশু হাম্বালা/মুসকিল ");
INSERT INTO cdz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","মিয়াৎ কিসাড় হড় ঈশ্বর রাঃআ রাঃআজ্য বলঃঅ বাগি কাতে/হাতেন বচ্ছম মিয়াৎ উট সুজ/শুই ভূউ রে বলঃঅ সহজ গেয়া/আলগা ");
INSERT INTO cdz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","অকয় আয়ুম কেৎয়াকু ইঙ্কূ গাম কেয়া কু এন্খান একয়-এ উদ্ধার/বাঞ্চাও দাড়িআয় ");
INSERT INTO cdz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ইনি গাম কিইয়ায়্য় অকা মান্মি কা দাড়িআয় ইনা ঈশ্বর এ দাড়িআয় ");
INSERT INTO cdz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ইন্তং পিতর গাম কিইয়ায়্য় নেলেপে আবু অকা অকা আবুয়া ইনা যত বাগি গিডি কেৎ তেলে আমাঃ তায়ম তে সেন তানা লে আমকে পাঞ্জাওয়াতান মালে ");
INSERT INTO cdz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ইনি ইঙ্কূ কে গামাৎ কুয়ায়্য় ইঞ আপেকে সার্তি গাম তানা পিং এনকান যাহায় বানুকুয়া অকয় ঈশ্বর রাঃআ রাঃআজ্য রাঃআ নাতিনাং অড়া চায় এরাঃআ চায় হাগা তেত কু চায় এংগা আপু চায় চায় হন হপন কে বাগি গিডি তকাদ কুয়ায়্য় য় খান/লেখান ");
INSERT INTO cdz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","নিয়া যুগ রে ইঙ্কূ ঢের নামেয়া হেৎদ হিজু তানা যুগ রে/হানা পুরি রে যায় যুগ জিয়ন কাকু নামেয়া ");
INSERT INTO cdz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","হেৎদ ইনি ইঙ্কূ গেলে বার চেলা কুকে ঠাইন তে হুন্ডি কেৎ কুতে গামাৎ কুয়ায়্য় নেলেপে আবু যীরুশালেম তে সেন তানা বু ভাবিজাগার কু অকা অল তকা লাআ কু ইনা যত মান্মি হন রাঃআ হান্ডে পুরাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","চিয়াচি ইনি এটা জাতি হড় কুরাঃআ তিহি রে সাবআয়/এমআয় হেৎদ হড় কু ইনিকে লান্দাইয়া ইনিকে অপমানিয়া ইনি রাঃআ হড়মো রে বেজজিয়া কু ");
INSERT INTO cdz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","হেৎদ কোড়া দালিয়া হেৎদ গয়চ জিয়া হেৎদ আপি মাহা হুলাং জীউৎ বিরিৎ রাঃআকাব আয় ");
INSERT INTO cdz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","নিয়া জাহানা ইঙ্কূ চেলা কাকু আটকার দাড়ি লা নিয়া থুতি ইঙ্কূ য়া হান্ডে দানাং/উকু তাহি না হেৎদ অকা গামে না/গাম তানা ইঙ্কূ কাকু আট কার নাম দাড়ি লা ");
INSERT INTO cdz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ইনি যিরিহো সরগ নাগার রাঃআ ঠাইঞ তে হিচে নায় মিয়াৎ কাড়া হড় হরাঃআ কাতা রে দুব কানতে কয়এ তান তাহিন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ইনি হড় কুরাঃআ তাড়ম/সেন পরম তান আয়ুম নাম কেৎ কুতে নিয়া চিকানা তানা মেন্তে কুলি কেৎ কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","হড় কু ইনিকে গাম কিয়া কু নাসরতীয় যীশু এঙ্কাতে/ইনা হরাঃআ-হরকা তে সেন তানায় মেন্তে ");
INSERT INTO cdz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ইন্তং ইনি জোর তে কিকিচ কাতেন গাম কিইয়ায়্য় এ যীশু দাউদ রাঃআ-হন ইঞ কে দায়াইঞ মে ");
INSERT INTO cdz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","অকয় কু মাড়াং তে সেন কেনাকু ইঙ্কূ থির থিরপে গাম কাতে ইনিকে ধমকাঃআ কিয়াকু মেন্খান ইনি অটঃ হ জোর তে কিকিচ কাতে গাম লাগায় নায় এ দাউদ রাঃআ-হন ইঞ কে দয়া ইঞ মে ");
INSERT INTO cdz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ইন্তং যীশু তিঙ্গুয়েন তে ইনিকে আয়া কাতা তে আগু নাতিনাং হড় কুকে হুকুম/আচু কেৎ কুয়ায়্য় য় হেৎদ ইনি কাতা তে হিচ য়েন্তে ইনিকে কুলি কিয়ায় আম কিনা নানাম তানাম? ");
INSERT INTO cdz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ইঞ আম নাতিনাং কিনা চিকা দাড়ি আইঞ ? ইনি গাম কিইয়ায়্য় প্রভু যাতে নেল নাম দাড়ি কাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","যীশু ইনিকে গাম্কিয়ায় মা নেলেম আমাঃ পাতিয়াও আমকে বুগি কেৎ মেআয় ");
INSERT INTO cdz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ইনাতে ইনি ইন্তং গে/ইনা ঘাড়ি গে নেল নাম কিইয়ায়্য় হেৎদ ঈশ্বর রাঃআ মহিমা কেয় তে যীশু রাঃআ তায়ম তায়ম তে সেনে নায় ইনা নেল কাতেন যতচ হড় ঈশ্বর রাঃআ সারহাও কেৎয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","যীশু দ যিরিহো সরগ নাগার তে বলন/বলয়েন তে শেহার রাঃআ তালা/তালা-মাঙ্গা হরকা তে সেন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","হেৎদ নেলেপে সক্কেয় নুতুম তে মিয়াৎ হড় ইনি মিয়াৎ মারাঃআং/মুখিয়া মাসুল রাঃআকাববিজ হেৎদ ইনি কিসাড় গে তাহীন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","অকয় যীশু ভালে/ভেলে ইনিকে নেল সানা কিয়া মেন্খান গাদেল হড় কুয়া তে কায় নেল নাম দাড়িলিয়ায় চিয়াঃ চি ইনি বাঠিয়া/গেডরাঃআ হড় তাহীন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ইনাতে ইনি মাড়াং তে নিরকেয় তে যীশু কে নেল নাতিনাং মিয়াত সুকমোর/লোয়া দারু রে দেচ এনায় চিয়া চি ইনি ইনা হরাঃআ-হরকা তে সেন কেনায় ");
INSERT INTO cdz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","হেৎদ যীশু চিন্তং ইনা থাংতে হিচে ন তে চেতাং দর কয় কিয় তে রাঃআ কিয়ায় সক্কেয় উসারাঃআ/নাহা গে/ঘিড় মেন্তাং আড়গু হিজু ম চিয়া চি তিহিং আমাঃ অড়া রে তিহিং ইঞ কে তাহি হুই য়া ");
INSERT INTO cdz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ইনাতে ইনি আকাপাকা/চিদগি আড় গু হিচে নায় হেৎদ রাঃআসকা তে ইনিকে দারম কিয়ায় ");
INSERT INTO cdz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ইনা নেল কাতে যতচ টিট কারি লালিজ লাগায় নাকু ইনি দ মিয়াৎ মাসুল রাঃআকাবিজ/পাপি রাঃআ অড়া রে নিদা তাহি নাতিনাং পাহি লেকা তে সেনে নায় ");
INSERT INTO cdz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ইন্তং সক্কেয় তিঙ্গুয়েন তে প্রভু কে কুলিকিয়ায় এ প্রভু নেলেম ইঞ য়া সম্পতি রাঃআ ইঞ আ তারাঃআ/আধা ইঞ রেঙ্গেজ-দুখী কুকে দান/হাটিং তানা কুইঞ হেৎদ বেদা কাতে/ঠেকা কাতে/খালিয়াইঞ তে যাহানাইঞ হাতা তাইঞ রেদ উপুন সাইঞ এম রুয়াড় য়ে তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ইন্তং যীশু ইনিকে গাম কিয়ায় তিহিং নিয়া অড়া রে উদ্ধার হিচে না চিয়াচি নি হড় হ আব্রাঃআহাম রাঃআ কুল তানায় ");
INSERT INTO cdz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","চিয়াচি অকা আদ নেনা ইনা পাঞ্জা হেৎদ পরিত্রাঃআন/উদ্ধার নাতিনাং মান্মি হন হিচ া কানায় ");
INSERT INTO cdz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","চিনতং ইঙ্কূ নিয়া যত থুতি কু আয়ুমে কেনাকু ইন্তং ইনি মিয়াত জনকা গামাৎ কুয়ায়্য় য চিয়াচি ইনি যিরুশালেম তে ঠেকা হিজু কানায় হেৎদ ইঙ্কূ আটকার-এ কেনাকু ঈশ্বর রাঃআ রাঃআজ্য বলন ইন্তং গে হুই য়া (উদুগো য়া ");
INSERT INTO cdz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","যীশু ইঙ্কূ কে উপমা গাম কিইয়ায়্য় মিয়াত মানতান/বাপ-ধন/মারাঃআং হড় সাঙ্গিন দিশুম তে সেনে নায় ইঞ য়া নাতিনাং রাঃআজ্যইঞ নামেয়া হেৎদ ইনা তায়ম তে ইঞ রুয়াড় হিজু য়া ");
INSERT INTO cdz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ইনি আয়া গেলে হড় দাসীকে রাঃআ কেৎ কুতে গেলে সোনা কাউডি এ এম কেৎ কুতে গামাৎ কুয়ায়্য় ইঞ চিমিন ভুর কাইঞ হিজু য়াইঞ ব্যাপার/ব্যবসা হাতাড়ে পে। ");
INSERT INTO cdz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","মেন্খান ইনি রাঃআ দিশুম রিঙ্কূ হড় কু ইনিকে কাকু কুশিয়াইয়া/ঘিনাই আকু ইঙ্কূ ইনি রাঃআ তায়ম তায়ম তে সরগ নাগা কুল কেৎ কুতে গাম কিইয়ায়্য় আলেয়া সানা তিং দ লহয় গে/আলে কালে নানাম তানা নি:ই হড় আলেয়া চেতাংরে রাঃআজ্য এ কায় ");
INSERT INTO cdz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","হেৎদ ইনি রাঃআজ্য নাম কেৎ তে হিচ রুয়াড় য়ে নায় ইন্তং অকয় কুকে টাকা এম তকা লা কুয়ায়্য় য় ইঙ্কূ দাসী কুকে আয়া হান্ডে রাঃআ আউ কাতে গামাৎ কুয়ায়্য় ইঙ্কূ ব্যবসা রে অকয় চিনতি পোসা/লাভ তাকু ইনা সারি নানামে নায় ");
INSERT INTO cdz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ইন্তং মারাঃআংয়ীজ হিচে ন তে গাম কিইয়ায়্য় এ প্রভু আমাঃ গনং/মোহর তে (আম/আমেম এমা লিংয়া/এমা লিয়াম গেলে সনা কাউডি অটঃ পোসা/লাভ তাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ইনিকে গাম কিয়ায় বেশ গে এ বুগিন দাসী আম হুডাং তে পাতিওয়ায়ে নামেন তে/পাতিয়াওইয়েন তে ইনা নাতিনাং আম গেল শেহার রাঃআ চেতাং রে জিমা এময়া ");
INSERT INTO cdz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","দশারিজ হিচে ন তে গাম কিইয়ায়্য় আম হ মড়েয়া শেহার রাঃআ চেতাং রে বার হড়ইজ হিচ কাতে গাম কিয়ায় এ প্রভু আমাঃ কাউডি তে অটঃ মড়ে কাউডি উডুং য়া কানা উডুং য়ে না ");
INSERT INTO cdz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ইনিকে হ গাম কিয়ায় আম হ মড়েয়া শেহার রাঃআ চেতান রে মুখিয়া হুইয়াম ");
INSERT INTO cdz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","হেৎদ অটঃ এটাইজ হিচ য়েন্তে গাম কিয়ায় এ প্রভু নেলেম/নেলেমে নে আমাঃ কাউডি ইঞ নিয়া গামছা রে গাইট দঃহ তাইঞ ");
INSERT INTO cdz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","চিয়া চি ইঞ আমকে বরয়ামিয়াইঞ আম কুঠিন/কেটেজ মনেন হড় তানাম অকা কাম দঃহ তা ইনা হালাং/হাউর রে আম হেৎদ অকা কম হের/রহা তা ইনা ইর রে আম ");
INSERT INTO cdz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ইনিকে গাম কিয়ায় এটকান/বদমাশ দাশি ইঞ আমাঃ মচা রাঃআ জাগার তেইঞ ধরবারাঃআ মা আম কম সারিয়া ইঞ কুঠিন হড় তানাইঞ অকা কাইঞ দঃহ তা ইনা হালাং/হাউর ইদি আম অকা কাইঞ হের তা ইনা ইর এ আম ");
INSERT INTO cdz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","এন্খান ইঞ য়া টাকা বাঙ্কার রে/পোদ্দার কুরাঃআ হান্ডে কম দঃহ তকালা এনকা লেং খান ইঞ হিচ রুয়াড় কাতে সুদ সমেতেইঞ হাতাইঞ হুনাং/আদায়ইঞ হুনাং ");
INSERT INTO cdz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","অকয় কু ঠাইন রে তিঙ্গু লেনাকু ইঙ্কূ কে গামাৎ কুয়ায়্য় নি:ইরাঃআ হান্ডে হাতেন ইনা টাকা/কাউডি হাতা রুয়াড় তে পে হেৎদ অকয় রাঃআ হান্ডে গেলে কাউডি মেনা ইনিকে এমাই পে ");
INSERT INTO cdz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ইঙ্কূ ইনিকে গাম কিয়া কু প্রভু ইনি রাঃআ হান্ডে মা গেলে কাউডি মেনা ");
INSERT INTO cdz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ইঞ আপেকে গাম তানা পিং অকয় রাঃআ মেনা ইনিকে এমোয়া মেন্খান অকয় রাঃআ বায়ায় না ইনি রাঃআ অকা মেনা ইনা হ আয়া হান্ডে হাতেন হাতাওয়া ");
INSERT INTO cdz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","তুবুই রহ ইঞ য়া নিকু বাইরি কু কাকু সানা কুয়া/নানামা কু ইঞ ইঙ্কূ য়া চেতাং রে রাঃআজে কাইঞ ইঙ্কূ কে নেন্ডে তা/নেথাং রে আউ কূপে হেৎদ ইঞ য়া সামাং রে গয় কূপে ");
INSERT INTO cdz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","নিয়া যত থুতি গাম কাতে ইনি ইঙ্কূ য়া মারাঃআং তে সেনেন তে যীরুশালেম দর রাঃআকাব এ নায় ");
INSERT INTO cdz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","জৈতুন নুতুম বুরু হেদে রে বৈতফগি সরগ নাগার হেৎদ বৈথনিয়া সরগ নাগার রাঃআ কাতাতে/ঠাইন তে হিচ সেটের এ নায় ইন্তং বারিয়া চেলা কিন কে কুল কেৎ কিনতে গাম কেৎ কিনায় ");
INSERT INTO cdz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","যীশু গাম কেৎ আয় ইনা মারাঃআং/সামাং রাঃআ হাতু তে সেন বেন এন্ডে/এনথাং রে বলঃঅ থর মিয়াৎ গাধা হন তল মেনাইয়া/তলা কানায় নেল নামিয়া বেন অকয় রাঃআ হান্ডে যাহায় হড় যাহা চিল লং কাকু দুবা কানা ইনিকে লাড়া আগুই বেন ");
INSERT INTO cdz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","এন্তে যাহায় আবেন কে কুলি বেনাকু নি কে চিয়া লাড়াই তানা বেন? এনখান নেকা গামে বেন নি:ই প্রভু রাঃআ লাকতি তানা ");
INSERT INTO cdz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ইন্তং একয় তিকিন কে কুল হুই লেনা ইনকিন সেন কাতেন চিল্কা গাম লা কিনায় এনকা গে নেল নাম কিয়া কিন ");
INSERT INTO cdz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","চিনতং ইঙ্কিন গাধা হন টা কে লাড়াই তানা কিন ইন্তং মালিক ইনকিন কে গাম কেৎ কিনায় গাধা হন টাকে লাড়াই তানা বেন চিয়া? ");
INSERT INTO cdz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ইঙ্কিন গাম কেয়া কিন নিঃই প্রভু রাঃআ লাক্তি তানা? ");
INSERT INTO cdz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ইঙ্কিন ইনিকে যীশু রাঃআ হান্ডে আউ কিয়া কিন হেৎদ ইনি রাঃআ চেতাং রে আকিনা কিচি আটেত কেয় তেকিন যীশু কে দুব কিয়া কিন ");
INSERT INTO cdz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","হেৎদ ইনি সেন তান্নায় হড়কু আকু আকুয়াআ কিচি হরাঃআ রে আটেত কেয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ইনি কাতাতে/ঠাইন তে সেটের হিচে তানারে/তানায়/তানা রেদ জৈতুন বুরু হাতেন আড় গু থাং রে সেটেরে নায় এনকান ঘাড়ি রে ইন্তং গে যতচ চেলা কু অকা-অকা নেল তা আকু/নেল নাম আউ তাকু ইনাকু নাতিনাং রাঃআসকায়েন তে কিকিচ কাতে ঈশ্বর কে মাহিমা কিয়তেকু গাম এহব বে নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ধন্য ইনি রাঃআজা অকয় প্রভু রাঃআ নুতুম তে হিজু তানায় সেরমা রে সুলুক-শান্তি হেৎদ চেতাং রে মহিমা হুয়ুকা। ");
INSERT INTO cdz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ইন্তং গাদেল হড় কুরাঃআ তালা হাতেন মিত বার হড় ফারিশী ইনিকে কুলি কিয়া কু এ গুরু আমাঃ চেলা কুকে ধমকাঃআ কুম ");
INSERT INTO cdz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ইনি গাম রুয়াড় কেৎ কুয়ায়্য় য় ইঞ আপেকে গাম তানা পিং ইঙ্কূ থির-থার/হাপে তাহি লেন্খান/থির তাহীন রেহ দিরি কু কিকি জেয়া/কিকিচ রাঃআকাব বেয়া ");
INSERT INTO cdz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","হেৎদ ইনি ঠাইঞ তে হিচে ন তে ইন্তং শেহার টা নেল কেয় তে ইনারাঃআ নাতিনাং ইয়াম মে নায় ");
INSERT INTO cdz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","গাম কিইয়ায়্য় আম গে নে হুলাং নাম রেয়া থুতিম জাগার সারি রেদ/রেহ সুলুক তান ইনা আটকার নাম দাড়ি কেয়াম মেন্খান নাহা ইনা যত আমাঃ সামাং রে উকু/দানাং/দাপাল এ না (সুলুক সংবাদ এম সারি রেদ/সারি ওরম রেহ/লেখান হুনাং মেন্খান নাহ ইনা দ আমাঃ মেদতামে তে উকুয়া কানা)। ");
INSERT INTO cdz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","চিয়া চি আমাঃ চেতাং রে এনকান সময় সেটের য়া এন রে/অকা সময় রে আমাঃ বাইরিকু পাচিরি এসেদ দেয়াকু/এসেদ মেয়াকু হেৎদ আমকে ঘেরাঃআ ঘুরাঃআ মেয়া হেৎদ যত দর হাতেন তেকু কেসেদ রেনঢেত মেয়া ");
INSERT INTO cdz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","আমকে হেৎদ আমাঃ হন হপন্কুকে অতে/হাসা রেকু তাবা পেয়া/মিৎ পেয়া আমাঃ হান্ডে/আম রে দিরি চেতাং দিরি কাকু বাগিয়া/বাগি গিডি য়া চিয়াচি আম দ ঈশ্বর এ সময় কম নেল উরুম দাড়িকেয়া/আটকার দাড়ি লা ");
INSERT INTO cdz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","হেৎদ ইনি জাহের স্থান রে বলঃঅ য়েন তে হেৎদ আখরিং তান কুকে হার উডুং লাগায় নায়। ");
INSERT INTO cdz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ইঙ্কূ এ কে গামাৎ কুয়ায়্য় শাস্ত্র রে অল মেন ইঞ য়া অড়া বিন্তি/কয় জং রাঃআ অড়া হুই য়া মেন্খান আপে ইনা কুম্বুডু/ডাকু কুরাঃআ ডেরাঃআ/অড়া বানা কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ইনি মাহা হুলাং গে জাহের স্থান রে ইতু/গাম-চেদ কেন কুয়ায়্য় য় হেৎদ মারাঃআং বামড়ে কুহ হেৎদ আইন/সাস্তর পণ্ডিত কু হেৎদ মুরুব্বি হড় কু ইনি কে গয় সানা কিয়া/নানা মে নাকু ");
INSERT INTO cdz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","মেন্খান কিনা বু চিকায়া নিয়া/ইনা কাকু নেল নাম দাড়ি লা হড় কু যত মিৎ মন তে ইনি রাঃআ থুতি আয়ুম মে কেনাকু ");
INSERT INTO cdz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","মিত মাহা হুলাং যীশু জাহের স্থান রে হড় কুকে চেদা/ইতুকু তান কুয়ায়্য় য় হেৎদ বুগিন বার্তা গাম পাসরাঃআয় কেনায় ইন্তং মুখিয়া/মারাঃআং-মাপরাঃআং বামড়ে হেৎদ আইন ইতুকু/সাস্তর গ্মসায় কু মুরুব্বিকু লো হিচে না ");
INSERT INTO cdz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","হেৎদ ইনিকে গাম কিয়াকু আলে কে গাম লেম আম অকা দাড়ি তে নিয়াম কামী তানা আমকে অকয় নিয়া দাড়ি এমতা মায় ইনি দ অকয় তানায়? ");
INSERT INTO cdz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ইনি ইঙ্কূ কে গাম রুয়াড় কেৎ কুয়ায়্য় য় ইঞ আপেকে মিয়াত জাগার/থুতু কুলি পেয়াইঞ ইঞ কে গামিং পে ");
INSERT INTO cdz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","যোহন রাঃআ ডুবুল দ সেরমা হাতেন চি মান্মি/হড় কুয়া হাতেন/সায়তে হুইলেনা ");
INSERT INTO cdz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ইন্তং ইঙ্কূ আকু আকু গে তক্ষ য়েন তেকু গামেনাকু সেরমা হাতেন এন্খান/এনকা লেনখান ইনি গামেয়ায় আপে ইনিকে চিয়া কাপে পাতিয়াও কিয়া/লিয়া ");
INSERT INTO cdz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","মেন্খান হড়/মান্মি কুয়া হাতেন গামেয়া বু খান এন্খান হড় কু যতচ আবুকে দিরি তে কটেজ লেবদা/হুরাঃআং/হুল্লা বুয়াকু চিয়াচি ইঙ্কূ দ নিয়া সার্তি গে মনে কেৎয়াকু যোহন দ নবী তানায় ");
INSERT INTO cdz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","হেৎদ ইঙ্কূ গাম রুয়াড় কেৎয়াকু আলে কালে সারিয়া কথাং/কদের হাতেন ");
INSERT INTO cdz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় এন্খান ইঞ হ চিলকান/কিনা/অকা দাড়ি/পেড়ে তে নিয়াইঞ কামী তানা ইনা আইঞ আপেকে কাইঞ গাম পিয়াইঞ ");
INSERT INTO cdz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","এন্তে ইনি হড় কুকে নিয়া কহিনী গাম এহব কিইয়ায়্য় মিয়াৎ হড় রাঃআ দ্রাঃআক্ষা বাড়গি মেনা হেৎদ ইনি মালি কুকে জিমা তকা কেৎ কুতে/গটা া এমাদ কুতে ঢের মাহা নাতিনাং এটা দিশুম তে সেএ নায়। ");
INSERT INTO cdz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","হেৎদ গটা ইরঅ অক্ত চাষী/মালি কুরাঃআ হান্ডে মিয়াত মুনিস কে কুল কিয়ায় যাতে ইনিকে ইঙ্কূ দ্রাঃআক্ষা বাড়গি রাঃআ জ এমাই কাকু মেন্তে মেন্খান চাষী ইনিকে দাল কিয়াকু হেৎদ একেন তিহি তে কুল কিয়া ");
INSERT INTO cdz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","হেৎদ ইনি অটঃ মিহুড় দাসী কে কুল কিয়ায় ইনকে হ ইঙ্কূ দাল হ মা দাল কিয়াকু হেৎদ অপমান কাতে একেন তিহি তে কুল কিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","হেৎদ ইনি আপিয়ানি কে কুল কিয়ায় ইঙ্কূ ইন্কিকে হ দাল পুটুর-চেগেড় কিয় তেকু বাহার রে লেবদা/হুরাঃআং গিডি কিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ইন্তং দ্রাঃআক্ষা বাড়গি রিনিজ গিরিহা গামকিইয়ায়্য় ইঞ কিনা চিকা আইঞ ? ইঞ য়া কুশিয়া/দুলাড়িয়া হন তিংয়া কে কুলি আইঞ পাছে ইঙ্কূ ইনিকে লোভাই আকু/লোভা-ভুলা ভাড়াইয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","মেন্খান চাষী/কামিয়ান/মুলিয়া কু ইনিকে নেল কিয় তেকু আকু আকু গে গাম নাকু নি:ই গে ভাগিদার/হাকদার/ওয়ারিস তানায় দেলা বু গয়চ জিয়া যাতে হাক/হাটিং য়া আবুয়া হুইয়া ");
INSERT INTO cdz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","হেৎদ ইঙ্কূ ইনিকে দ্রাঃআক্ষা বাড়গি বাহার রেকু গয় কিয়া নাহা দ্রাঃআক্ষা বাড়গি রিনিজ মালিক কিনা চিকা আয় ");
INSERT INTO cdz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ইনা তায়্ম কর্তা হিচ কাতে ইঞ কু চাষী কুকে কিনায় চিকা কুয়ায়্য় য় ? নিকু চাষী কুকে গয় চা কুয়ায়্য় য় হেৎদ বাড়গি এটা হড় কুকে এমকুয়ায়্য় য় নিয়া থুতি আয়ুম কাতে ইঙ্কূ হড় গাম কেৎয়াকু এনকা আল হুইয় কা ");
INSERT INTO cdz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","মেন্খান ইনি ইঙ্কূ কে আরিৎ কাতে গামাৎ কুয়ায়্য় এন্খান নিয়া কিনা শাস্ত্র রে অলা কানা অকা দিরি বাইয়ান কু কাকু ছুতাং লা ইনা কোণ রাঃআ মুর্ধুন দিরি হুই য়েনা। ");
INSERT INTO cdz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ইনা দিরি চেতাং রে অকয় উয়ুগো আয় ইনিদ পেটেজ আয় মেন্খান ইনা দিরি অকয় রাঃআ চেতান রে নুরু য়া ইনি কে গুন্ডা উতার ই আয়। ");
INSERT INTO cdz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ইনা ঘাড়ি রেগে সাস্তর পণ্ডিত হেৎদ মারাঃআং বামড়ে কু ইনিকে দাল নাতিনাং তিহি রাঃআকাব নাতিনাং আটুপাটুয় নাকু হেৎদ ইঙ্কূ হড় কুকে বর কেয়া কুয়াকু চিয়াচি ইঙ্কূ সারিনাম লাআকু ইনি ইঙ্কূ য়া নাতিনাং গে নিয়া জনক গাম লাআয় ");
INSERT INTO cdz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ইন্তং ইঙ্কূ ইনি রাঃআ চেতানরে মেত আডা দঃহ কেৎয়াকু এনকান মিয়াত লছনাই কে কুল কিয়াকু অকয় ছদ্দবেশ ধরম হড় সাজায় যাতে ইনি রাঃআ থুতি আয়ুম-আতেন কাতে ইনিকে রাঃআজ দুয়ার হেৎদ দিশুম গমকে রাঃআজ রাঃআ হেপাজত এম তকাই কাকু (একতিয়ার রেকু দড়ম মিকা/দড়ম-গিডিকা ");
INSERT INTO cdz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ইঙ্কূ ইনিকে কুলি কিয়াকু এ গুরু আলে সারিয়া লে আম হক থুতি আম হেৎদ হক চেত কুয়ায়্য় য় ম যাহায় রাঃআ কাম ধার ধরিয়া মেন্খান সার্তি তে ঈশ্বর রাঃআ হরাঃআ নাতিনাং আনচু কু এম কুয়াম ");
INSERT INTO cdz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","গামালেম নিয়া বাব্ত্তে কোইসর রাপাজ কে খাজনা এম আলেয়া লাকতি তানা চি লহয়? ");
INSERT INTO cdz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","মেন্খান ইনি ইঙ্কূ কে ইঙ্কূ য়া কারসাদি কামী কু সাব-উদু কেৎ কুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ইঞ কে মিয়াত কাউডি সিকি উদুয়ান্পে ইনা রে অকয় রাঃআ ছাপ হেৎদ নুতুম মেনা? ইঙ্কূ গাম কেৎয়াকু কোইসর রাপাজ রাঃআ ");
INSERT INTO cdz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ইন্তং ইনি ইঙ্কূ কে কুলি কেৎ কুয়ায়্য় য় এন্খান অক অকা কোইসর রাঃআ ইনা কোইসর কে এমি পে হেৎদ অকা অকা ঈশ্বর রাঃআ ইনা দ ঈশ্বর কে এমাই পে ");
INSERT INTO cdz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ইনাতে ইঙ্কূ হড় কুরাঃআ সামাং রে ইনি রাঃআ থুতি রাঃআ জাহানা ত্রুটি সাব কাকু দাড়িলা বচ্ছম ইনি রাঃআ গাম রুয়াড় রে হায় কাতেন্তে তেকু থির থারে নাকু ");
INSERT INTO cdz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","হেৎদ সদ্দুকি কু অকয় গাম রুয়াড়য়ে য়াকু জিউত বিরিৎ রুয়াড় বায়ায় না ইঙ্কূয় তে মিত বার হড় আয়া কাতা তে হিচ য়েন্তে যীশু কে কুলি কিয়াকু ");
INSERT INTO cdz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","এ গম্কে মোশি আলেয়া নাতিনাংশাস্ত্র অল তায়ায় যাহায় রাঃআ বকতেত এরাঃআ তাহীন তে গয়চ আয় হেৎদ একেন আটকুড়া (হন হপন বানু আন তে এন্খান ইনি রাঃআ বকতেত ইনি এরাঃআ কে আপনাই/দঃহি আয় হেৎদ আয়া বকতেত রাঃআ নাতিনাং কূল /পিড়ি জানাম কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","বেiশ, এয়াই হাগাকু তাহি নেনা, মারাঃআন্গী দ মিয়াৎ কুড়ি হন কে দুতাম এনায়, হেৎদ হন হপন আউরি হুই মারাঃআং তে গয়চ নায়। ");
INSERT INTO cdz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","বারিচ হেৎদ আপিচ ইনি এরাঃআ কেইঞ দহ কিয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","এঙ্কাগে সাতি হাগা কু গে হন হপন আউরি হুই মারাঃআং তে গয়চ নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","মুচাৎ রে ইনি এরাঃআ হ গচে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","এন্খান জিউত রুয়াড় রে ইনি ইঙ্কূ য়া অকয় রাঃআ এরাঃআ হুইআয়? ইঙ্কূ এয়াই গে মা দহ লিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","যীশু ইঙ্কূ কে গামাৎ কুয়ায়্য় , নিয়া ধারতি রিঙ্কূ হন (কড়া-কুড়ি) কুমা দুতাম-গং আকু। ");
INSERT INTO cdz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","মেন্খান অকয় ইনা ধার্তি রেঙ্কূ হেৎদ গয় কুরাঃআ হাতেন জিউত রুয়াড় রিন কুরাঃআ হাকদার লেক তানা কু, ইঙ্কূ কাকু দুতাম হেৎদ গংয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ইঙ্কূ হেৎদ গয় হ কাকু গয়চ আ, চিয়াচি ইঙ্কূ সরগ নাগা লেকা কুগে, হেৎদ জিউত রুয়াড় রিঙ্কূ য়া হনহপন হ ঈশ্বর রাঃআ হনহপন গে। ");
INSERT INTO cdz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","অটঃ গয় কুজে জিউত দা কানাকু, ইনাদ মোসি ঝোপ রাঃআ ঘটনা গাম সদর কিইয়ায়্য়/উদু তিয়ায়। চিয়াচি ইনি প্রভু কে আব্রাঃআহাম রাঃআ ঈশ্বর, ইসহাক রাঃআ ঈশ্বর হেৎদ যাকোব রাঃআ ঈশ্বর গামে আয়। ");
INSERT INTO cdz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ঈশ্বর মা গয় কুরাঃআ ঈশ্বর লহয় তানায় মেন্খান জিউত রুয়াড় কুরাঃআ ঈশ্বর তানায়, ইনি রাঃআ সামাং রে যতচ গে জিউত ইত/চিয়াচি ইনি রাঃআ সামাং রে যতচ গে জীউৎ গেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ইন্তং মিত বার হড় সাস্তর পণ্ডিত গাম কেৎয়াকু, এ গুরু, আম বেশ গাম তাআম। ");
INSERT INTO cdz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","বাস্তব রে ইনা ধাবিজ ইনিকে অটঃ জাহানা থুতি কুলি নাতিনাং ইঙ্কূ য়া সাহস/টের কা হুই লেনা। ");
INSERT INTO cdz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","হেৎদ যীশু ইঙ্কূকে গামাৎ কুয়ায়্য় , হড় চিল্কা তে ক্রিস্ট কে দাউদ রাঃআ হন তেত মেতেন গামিয়া কু? ");
INSERT INTO cdz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","দাউদ গেমা/মা আয়া দুরাঃআং পুথিরে গাম তাআয়, প্রভু ইঞ আ প্রভু কে গামকিয়ায়, আম ইঞ আ মানডি/জজম তিহি রে দুবম। ");
INSERT INTO cdz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","আমাঃ শত্র্রু কুকে আমাঃ কাতা লাতাড় রে কাইঞ দঃহ কুইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","দাউদ ইনিকে প্রভু গামিয়ায়, এন্খান ইনি কিনা লেকাতে ইনি রাঃআ হন? ");
INSERT INTO cdz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","হেৎদ যীশু যতোই হড় কুকে লুতুর রে আয়া চেলাকুকে গামাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","সাস্তর পণ্ডিত কুরাঃআ হান্ডে হাতেন হুঁশিয়ার /চির্গাল লোম। ইঙ্কূ জিলিংজিলিং/মারাঃআং-মারাঃআং সন তুসিং কাতে দাড়া-ভাড়ায়া আকু, হেৎদ হাটবাজার রে হড়কুরাঃআ হাতেন জোহার নামোয়া কু, সমাজ-অড়ারে মারাঃথাং রে দুবোয়াকু, হেৎদ ভোজ রে মারাঃথাং দুব কুসিয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ইঙ্কূ রাঃআন্ডি কুরাঃআ অড়া উদ/জম-উজাড়ে তাকুয়া/উজাড় চায় আকু হেৎদ ঢং/খালিটা/খালিগে/খালিয়াং কাতে গাদা ঘাড়ি গাদা ঘাড়ি বিন্তি/কয়-জংয়েয়া কু। ইঙ্কূ ধরবার হুলাং হ অটঃ মরনআঁটা সাতাও নামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","হেৎদ যীশু আরিদ রাঃআকাব কেৎ কুতে, কিসাড় হড়কু গাড়ু রে দান সানজুই কেন তানাকু/কেনাকু নেল কেৎ কুয়ায়্য় য় /নেলাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","হেৎদ যীশু নেল নাম কিইয়ায়্য়, মিয়াত রেঙ্গেজ/নাচার এনথাং রে বার সিকি সানজু কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","এন্খান গে যীশু গাম কিইয়ায়্য়, ইঞ আপেকে সার্তিগে গাম তানাপিং, নিই রেঙ্গেজ রাঃআন্ডি যতচ কুরাঃআ হাতেন গাদা ঢের কাউডি সানজু/দঃহ কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","চিয়াচি ইঙ্কূ যতচ আকুয়াআ ঢের হাতেন সানজু কেৎয়াকু, ধন হাতেন হুডাং হুডাং গাড়ু রে দঃহ কেৎয়াকু, মেন্খান নিই আয়া অভাব তাহিন কানারেহ ইতিজ-তরাঃআং/হুডাং লেকা হাতেন, আয়া যত আশুলো তেয়া সানজু কেয়া (অভাব রে হুই সত্তে হ ইনি রাঃআ অকা তাহি লেনা যত আরজা দঃহ লায় আসুল নাতিনাং এম চা কিইয়ায়্য়)। ");
INSERT INTO cdz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","হেৎদ চিনতং হানি নাহি হড় কু জাহের স্থান রাঃআ বাবাদ তে, ইনা চিল্কা বুগিন দিরি হেৎদ সিরাঃআনি/দান কুতে সাজাওয়া কানা মেন্তে, ইনি গামাৎ কুয়ায়্য় (জাহের স্থান বাবদ গাম কেনা কু, ইনা চিল্কা গটা ার দিরি হেৎদ নাআহানা জিনিস তে সাজা মেনা), ");
INSERT INTO cdz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","যীশু গাম কিইয়ায়্য় আপে নিয়া যত নেলে তানা পে, এনকান সময় হিজু তানা, ইন্তং নিয়া রাঃআ মিয়াত দিরি হ এটা দিরি রাঃআ চেতান রে মেনা নেল কাপে নামেয়া, যতচ াগে নুর-ধাসুড় লান্দুড় চা। ");
INSERT INTO cdz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","চেলা কু দ যীশু কে কুলি কিয়াকু, এ গুরু, এন্খান নিয়া যত ঘটনা চিনলং হুইয়া ? হেৎদ নিয়া কু হুইয়া রাঃআ সময় হিজু য়া, ইন্তং ইনারাঃআ চীনহা কিনা (হেৎদ নিয়া কু হুই নাতিনাং কিনা চিহ্না হুইয়া)। ");
INSERT INTO cdz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","যীশু গাম কিইয়ায়্য়, নেলে পে/চিরগাল পে, আলপে হতভোম্বয়া/ফুসলা-ভুলাওয়া, চিয়াচি গাদা লেকা/এমান-এমান/আমান হড়কু ইঞ আ নুতুম তে হিজু য়া কু হেৎদ গামেয়া কু, ইঞ গে ইনি তানাইঞ, সময় দ সেটের রাঃআ কানা, আপে ইঙ্কূ য়া তায়মতে আলপে সেনয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","হেৎদ চিন্তং আপে লাড়হাই/অপ্তা-গপয় হেৎদ হালা-গুলা রাঃআ/রেটেপেটে রাঃআ থুতি আয়ুম মেয়াকু, আলপে আত্রাঃআস/বর আ, চিয়াচি সিদা/মাড়াং রে/তে নিয়া যত হুইয়া/লাকতিংয়া, মেন্খান ইন্তং দ মুচাৎ /মুনডু/টুনডু কা হুই গদোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","হেৎদ যীশু চেলা কু কে গামকেৎ কুয়ায়্য় য়, জাতিকু দ হড় কুরাঃআ বিরুধ হেৎদ জাতি হেৎদ রাঃআজ্য দ রাঃআজ্য রাঃআ বিরুধ রাঃআকাব/বিরিৎ ওয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","মারাঃআং /মাপরাঃআং ভূমিকম্প/অতে হিলা/লাড়া হেৎদ মিমিৎ থাং/থান রে আকাল হেৎদ মারি হেৎদ হুই য়া হেৎদ সেরমা রে বর লেকান বর তারে আম হেৎদ মারাঃআং চীনহা হুইয়া/উদু গোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","মেন্খান নিয়া যত আউরি এনকা রে/হুইয়ো রে হড় কুদ আপে কে সাবপেয়া, আপেকে সিগিদ/কুদা/সাতাও পেয়া হেৎদ মন্ডলী রে হেৎদ কাঈদ/হাজত/জিহাল অড়া রে সাম্ভা পেয়া, ইঞ য়া নুতুম তে আপেকে রাঃআজা হেৎদ হাকিম কুরা সামাং রে ইদি পেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","নিয়া আপেয়া নাতিনাং গোহা/সাক্ষ পেরেয়ে আয়/এম রাঃআ সংনজগ হুইয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","এন্তে মনে মনে/মনে রে গটা /রেবেত দহয় পে, কিনা গাম রুয়াড় হুইয়া, ইনারাঃআ নাতিনাং মাড়াং রে আলো পে পাহাম দহয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","চিয়াচি ইঞ আপেকে এনকান মচা হেৎদ আকাল/আকিল/সেড়াইঞ এম পিং/এমাপেয়া, ইনা অকা দ আপেয়া বিরুধ রে যাহায় আটকা নাতিনাং জাহানা গাম রুয়ার কাকু দাড়ি য়া (বাইরি কুদ যাহায় কাকু তিঙ্গু দাড়িয়া হেৎদ কাকু গাম রুয়াড় দাড়িয়া)। ");
INSERT INTO cdz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","হেৎদ আপে এঙ্গা-আপু/বাই-মাই রাঃআ, বকম/হাগা/ভাই-ভেগর, জ্ঞাতি হেৎদ গাতিকু দ্বারাঃআয় তে সাব উদু-ইদি পেয়াকু, হেৎদ আপেকে যাহায় যাহায় কে গয় পেয়াকু/হেৎদ আপে কয় তে চিমিন কুকে গয় পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","হেৎদ ইঞ য়া নুতুম নাতিনাং তে আপে কে যতচ ঘিনা/ধুরধুরাঃআও/ইরখাও/নিহাইত পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","মেন্খান আপেয়া বহ রাঃআ মিত গোছা/মিয়াৎ উব হ কাকু নষ্ট/তুদ দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","আপে আপে আপেয়া সাহা তিং তানলো/লেখান ধীরাঃআজ/ধৈর্য্য রে নিজ নিজ জিউ পে নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","হেৎদ চীনতং আপে যীরুশালেম কে বৈরী পাল্টন তে এসেদ/কেসেদ আকান পে নেলেয়া, ইন্তং সারি পে ইনা দ লান্দুড় ওয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ইন্তং যাহায় যিহুদিয়া রে তাহিন/তাহিআন কু/মেনাআন কু, ইঙ্কূ দ বুরু ডাহি রে নির-জম কা আকু, হেৎদ যাহায় শেহার তালা রে তাহিনকু/তাহিআন/মেনাআন কু ইঙ্কূ দ বাহার তেকু উডুং সেনকা। হেৎদ অকয়/যাহায় হাতু টলা রে তাহিনকু/তাহিআন/মেনাআন কু ইঙ্কূ শেহার তে আল কু বলন কা। ");
INSERT INTO cdz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","চিয়া চি ইন্তং প্রতিশোধ/সাজা/হালা হুলাং তানা, অকা থুতি/জাগার অলাকানা/অলমেনা ইনা যত পুরাঃআ চাবা হুলাং রাঃআ মাহা তানা। ");
INSERT INTO cdz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ইনা হুলাং লা হিচ -হাম্বাল/লা হিচ -আকান কু হেৎদ তোয়া নুনুয়াকু তান এঙ্গা/বাহু কুড়ি কুরাঃআ হায়-হায়/হায়না, চিয়াচি দিশুম রেদ মারাঃআং দু:খ হেৎদ ঈশ্বর রাঃআ রাঃআগ/ক্রোধ নিকু হড় কুরাঃআ চেতাং রে হিজু য়া/জানামো য়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","হড় কু খড়গ/তরৌয়াড়ি তেকু মা:গয়চ য়া, হেৎদ যতচ কে এটা/পড় দিশুম তেকু তল ইদি কুয়া, হেৎদ এটা জাতি রেঙ্কূ রাঃআ সময় আউরি/আল পুরাঃআ রে/পুরাঃআও যাকিৎ যিরুশালেম দ এটা-জাতি কু রেঙ্কূ তিকা-রচদ গয়-কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","হেৎদ বেলা, চানডু, হেৎদ ইপিল কুরে নাআহানা চিহ্না কু উদুগো য়া, হেৎদ ধার্তিরে/অতে রে দরেয়া হেৎদ ঢেউ/ছালকা কু সাডি ও রে জাতি রেঙ্কূ দুকু/কসদ-কসদ তেকু আকাবাকা/লিচা-লচ/তাপিং-রাঃআকাব য়েনা। ");
INSERT INTO cdz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ধার্তি তে/অতে রে হুইয়া/হুইয় নাতিনাং কু নেল-হর রাঃআ বরতে জিউ অটাং ওয়া তাকুয়া, এন্তে সেরমা রাঃআ দাড়ি দাল-দালোয়া/দালাপ-দালোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ইনা হুলাং ইঙ্কূ মানমি হন কে কুঠিন দাড়ি হেৎদ মহিমা/মানা রাঃআং/পরতাপ লো তে রিম্বিল কুরে হিজু তান নেলয়া/ হিজু নেলো য়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","মেন্খান নিয়াকু এহব লেনখান হ আপে দ তিঙ্গু কেটেজ কাতে কয়/আরিদ রাঃআকাবে পে, চিয়াচি, আপেয়া বাঞ্চাও দ/বাঞ্চাও/উদ্ধার রাঃআ মাহা দ সেটেরাঃআ কানা/কাতারে য়া/ঠাইন রেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","হেৎদ ইনি ইঙ্কূ কে মিয়াত জনকা গামাৎ কুয়ায়্য় , লোয়া দারু হেৎদ এটা যত দারু নেলেপে। ");
INSERT INTO cdz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","চীনতং ইনাকু সাঙ্গেনে য়া ইন্তং ইনাকু নেল কাতে আপে গে সারি/আটকার নাম দাড়ি/দাড়িয়া পে, নাহা দ সিতুম-সিঙ্গি তানা/সেটে রাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","এনকা গে, আপে হ নিয়াকু যত হুইয় তানা নেলয়া পে/নেনেল রে/নেললে রে, ইন্তং সারি পে, ঈশ্বর রাঃআ রাঃআজ্য সেটেরাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ইঞ আপে কে সার্তি গে গাম তানাপিং, নে/নিয়া যতচ া আউরি পুরাঃআও যাকিৎ নে/নিয়া পিড়ি রেঙ্কূ হড় কু কাকু পারম/সেনয়া/আদ ইদিয়া কু। ");
INSERT INTO cdz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","সেরমা হেৎদ ধার্তি আদ-য়া/সেনয়া/পরমো-য়া, মেন্খান ইঞ য়া জাগার দ যাহা চিললং কা আদ-য়া/সেনয়া/পরমো-য়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","মেন্খান আপে দ চিরগাল তাহীন পে/হুশিয়ার তাহীন পে, কারে দ/পাছেন দারিদাহা হেৎদ নু-বুল/ভূতুড়াঙ তে হেৎদ জিউ রাঃআ চিন্তা তে আপেয়া মন হাম্বালো য়া, হেৎদ ইনা হুলাং আপে রে আচকা গে ফাসিয়া/ঝম্পা লেকা হিজু য়া/আপেয়া চেতাং রে নুর য়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","চিয়া চি ইনা দ ইনা হুলাং যত অতে-দিশুম হড় কুরাঃআ চেতান সেটের য়া/অতে রেঙ্কূ রে হিজু য়া। ");
INSERT INTO cdz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","মেন্খান আপে যত সময়/হার ঘাড়ি চির্গাল তাহীন পে হেৎদ কয় জং/বিন্তি পে যাতে নিয়া যত হুইও তেয়াকোএ তে বাঞ্চাও হেৎদ (ইনা টানডা/পাউড়ি ইদি পে), হেৎদ মান্মি হন রাঃআ সামাং রে তিঙ্গু-দাড়ি নাতিনাং কেটেজ জ/দাড়িয়ান পে। ");
INSERT INTO cdz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","হেৎদ ইনি মাহা দ-মাহা /মাহা হুলাং জাহের স্থান রে চেদ-চেচেদ কেনকুনায়, হেৎদ মাহা আয়ুব বাতিরাঃআং জৈতুন বুরু রে দাড়ান আঙয়েত/নিদা-আরিজ আঙয়েত কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","সেতা ইদাং রে যতচ হড়কু ইনি রাঃআ থুতি আয়ুম নাতিনাং জাহের স্থান রে ইনি রাঃআ হান্ডে হিচু কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","সাবা/বিন রাঃআনুয়া (তাড়ি) লাড/লাৎ /পিঠা রাঃআ পরব সেটের হিচে না খান, ইনা অকা দ ফাসাহা/সাক্রাতপর্ব্ব কু গামেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","মাপরাঃআং/মারাঃআং বামড়ে হেৎদ সাস্তর পণ্ডিতকু/আইন ইতুকু ইনিকে গয়ঃজিয়াকু মেন্তে সুসিকু/হরাঃআকু নামভাড়ায়কেনা, মেন্খান ইঙ্কূ দ হড়কুকে বরআকুতানা। ");
INSERT INTO cdz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","গেলে বার চেলাকুরাঃআ হাতেন মিয়াত ইস্করিরিয়তিয় নুতুম তে যীহুদা রাঃআ হান্ডে সয়তান এ বলয়নায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ইন্তং ইনি মাপরাঃআং/মারাঃআং বামড়ে হেৎদ পাল্টন কুরাঃআ গমকে কু গামিয়া/কর্তা রাঃআ হান্ডে সেয়েন তে থুতি মেসায় নায়, চিল্কা ইনিকে ইঙ্কূ য়া তিহিরে এমিআয়। ");
INSERT INTO cdz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ইন্তং ইঙ্কূ কুঠিনগে রাঃআস্কায় নাকু হেৎদ টাকা এমোয়াকু রাঃআজিএনা/এম নাতিনাং একরাঃআরে নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","হেৎদ ইনি দ সুকুয়নায়/রেবেনে নায়/একরাঃআর রেনায় কা হালাগুলা তানলোতে/গাদেল হড় কা সারিনাম কাতে, ইনিকে তিহিরে এম নাতিনাং আটঘাটকু নামভাড়ায় নাকু/পাঞ্জা লাগায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","সাবা/বিন রাঃআনুয়া লাড/লাৎ /পিঠা রাঃআ মাহা /হুলাং সেটের হিচে না খান, ইনা হুলাং ফাসাহা/সেন-পারম ভিডিহন মাআঃ/মাআঃই/দানরে/তেন্গেন লাকতিং গে তাহি কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ইন্তং ইনি পিতর হেৎদ যোহন তিকিন কে কুলকেৎ কিনায়, দু সেনবেন হেৎদ আবু জম নাতিনাং ফাসাহা/সেন-পারম জোমা তেয়ার রেবন। ");
INSERT INTO cdz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ইঙ্কিন গাম্কেয়াকিন, কদেরে তেয়ার রেয়া লিং আম নানাম তানাম? ");
INSERT INTO cdz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","যীশু ইঙ্কিন কে গাম কেৎ কিনায়, আবেন শেহার রেবিন বলঃঅ লেন্খান দা ঠিলি গঅঃ ইদিতানায় এনকান মিয়াত হড় বিন নামিয়া, ইনি অকা অড়ারে বলনায় আবেন দ ইনিকে পাঞ্জা আদের রিবিন। ");
INSERT INTO cdz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","হেৎদ আবেন দ অড়া রিনিজ মালিক/গমকে কে গামি বেন, এ গুরু আমকে গাম তানা মালিং, পাহিপেড়া রাঃআ জম-অড়া দ কদে রে মেনা, এন্ডে/কদেরে ইঞ চেলাকুল ফাসাহা/সেন-পারম ভোজিং জমেয়া? ");
INSERT INTO cdz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ইনাতে ইনি দ সাজা-সাপড়া তাআয় মিয়াত মারাঃআং কুঠি উদুয়া বেনায়, এন্ডে গে আবেন দ তেয়ারেবেন? ");
INSERT INTO cdz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","হেৎদ ইঙ্কিন দকিন সেএ না/সেনেয়েন তে, ইনি চিল্কা গামলাআ কিনায় এনকাগে নেল নাম কেয়াকিন হেৎদ ফাসাহা/সাক্রাতপর্ব্ব রাঃআ ভোজ তেয়ারেবেন। ");
INSERT INTO cdz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ঘড়ি/মাহা /গাপা হুলাং সেটেরানা খান/সেটেরেন খান ইনি আয়া কুলিচ /কুলতানাইজ কুল জম দুবে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ইন্তং ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় য়, ইঞ আ দুখ আউরিং সাহাওরে, আপে লো নিয়া ফাসাহা/সাক্রাতপর্ব্ব রাঃআ ভোজ আশুগে/কুঠিনগে জম সানাকিংআ। ");
INSERT INTO cdz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","চিয়াচি ইঞ আপেকে গাম তানা পিং, চিমিন ভুর ঈশ্বর রাঃআ রাঃআজ্য কা/আউরি পুরাঃআ তানা ইমিন ভুর ইঞ নিয়া কাইঞ জমেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","হেৎদ /ইনা তায়ম ইনি মিয়াত বাটি/টাটিয়া হাতা কাতে ইশ্বর সাহারাঃআও/জোহার কাতে চেলা গামকিইয়ায়্য়, নিয়া হাতা পে/নে নিয়া আতাং পে, হেৎদ আপে তালারে হাটিং জম পে। ");
INSERT INTO cdz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","চিয়াচি ইঞ আপেকে গাম তানা পিং, নাহা হাতেন ঈশ্বর রাঃআ রাঃআজ্য কা/আউরি সেটের/ হিজু ধাবিজ ইঞ দ্রাঃআক্ষা/দ্রাক্ষাঃআ জ রাঃআ রস দ কাইঞ নুইআ। ");
INSERT INTO cdz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ইনা তায়ম ইনি সাহারাঃআও/জোহার কাতে পিঠা পেটেজ কিইয়ায়্য়, হেৎদ ইঙ্কূকে এমকাতেন গামকেৎ কুয়ায়্য় য়, নিয়া দ ইঞ আ হড়মো তানা, ইনা অকা আপে নাতিনাং এম হুই তানা। নিয়া ইঞ কে পাহাম নাতিনাং রিকায় পে। ");
INSERT INTO cdz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","হেৎদ ইনি এনকালেকাগে জম পুরাঃআয় নায় খান, বাটি/কাঠুয়া সাব কাতে গাম কিইয়ায়্য়, নিয়া বাটি দ ইঞ আ মায়ম রাঃআ নামা নিয়ম তানা, ইনা অকা দ আপে নাতিনাং লিঙ্গীও তানা। ");
INSERT INTO cdz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","মেন্খান নেলেপে অকয় তানিজ ইঞ কে সাব-ইদিং/তিহিরে-এম ইঞ আয়, ইনি রাঃআ তিহি দ ইঞ লো নিয়া মেজ রে মেনা। ");
INSERT INTO cdz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","চিয়াচি মান্মি হন দ আয় নাতিনাং দঃহাকান লেকায় সেন তানায় মেন্খান ইনি সাবরিকানিয়/সাবলেকানিজ/সাবিজ দ হায়-হায়! ");
INSERT INTO cdz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","হেৎদ ইঙ্কূ আকু-আকুগে কুকলি নাকু, এন্খান অকয় আবুয়া তালা হাতেন নিয়া কামী কামিনী দ অকয় তানাইজ। ");
INSERT INTO cdz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","হেৎদ ইঙ্কূ চেলা কু য়া তালারে অকয় মারাঃআংইজ আটকারেয়া মেন্তেকু এগেররে না। ");
INSERT INTO cdz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","মেন্খান ইনি ইঙ্কূকে গামকেৎ কুয়ায়্য় য়, জাতিকুরাঃআ/সাংসার কুরাঃআ তালারে রাঃআজাকু, ইঙ্কূয়া চেতান রেকু মালিককো/রাঃআজয়ে তানা হেৎদ ইঙ্কূ য়া আইদাড়িয়ান/গুসিয়া কুদ ভালাই/বুগিনা/ডেঙ্গাকু গে গামনাম তান। ");
INSERT INTO cdz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","মেন্খান আপে আলোপে ইঙ্কূ লেকা হুয়ুয়া, বচ্ছম আপেয়া তালারে অকয় গে মারাঃআংইজ ইনি গে হুডিংইজ লেকায় হেৎদ গমকে দ দাসীলেকানিজ/সাপ শশরিজ হুইয় কায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","এন্তে অকয়-এ মারাঃআংআয়? জম দুবা কানাইজ চি দাসী/সাপ শশরিজ? চিয়া, জম দুব আকানিজ দ লহয়? তুবুই রহ নাহা ইঞ আপে তালা রে দাসী/সাপ শশরিজ লেকাগে মিনাইআ। ");
INSERT INTO cdz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","আপে দ ইঞ আ বিডা/বিড়া/বিনিড়ি কুরে আইঞ লো জামার-জুটুং কাতেপে তাহি হিচ া কানা পে। ");
INSERT INTO cdz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","হেৎদ নাহা ইঞ আ আপুইঞ চিল্কা ইঞ কে ঠারাঃআও তিং আয় এনকাগে ইঞ হ আপেয়া নাতিনাং মিয়াত রাঃআজ্য এ ঠারাঃআও তা পিং। ");
INSERT INTO cdz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","যাহাতে আপে ইঞ আ রাঃআজ্য রে ইঞ আ মেজরে জম-নুই পে, ছিং ইঞ অপেয়া রাপাজ কাতে হিজু য়াং হেৎদ আপে সিংহা সনরে দুব কাতে ইস্রাঃআয়েল রাঃআ গেল বার কিলি/কূল কুরাঃআ ধরবার রেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","যীশু সাইমন কে গাম্কিয়ায়, এ শিমোন, এ শিমোন, নেলেম, শয়তান দ গহম লেকা ঘুমপে নাম তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","মেন্খান ইঞ দ আমিং বিন্তি কেৎ মিয়াইঞ /বিন্তিয়া কাতমিয়াইঞ, আমাঃ পাতিয়া আলম রাঃআও/চাবাআ তামা হেৎদ আম রুয়াড় লেনরে আমাঃ বকমতুকু কে কেটেজ/পোকতা কুমে। ");
INSERT INTO cdz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","হেৎদ পিতর গামকিইয়ায়্য়, এ প্রভু, আম লো ইঞ হাজত তে সেন হেৎদ আম লো গয়চ সাপড়া গেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","যীশু গাম কিইয়ায়্য়, পিতর, ইঞ আমকে গাম তানা মাইঞ, তিহিং সিম আউরি রাঃআ রে আম আপিসা ইঞ কে কাম সারিয়া মেন্তে। ");
INSERT INTO cdz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","হেৎদ যীশু ইঙ্কূকে কুলিকেৎ কুয়ায়্য় য়, ইঞ দ আপে বেগর/ছাড়া থাইলি/বাগুলি, ঝোলা/তরাঃআ হেৎদ খড়ম /উহিরখার্পা কুলকেৎ পেরে/কুল লাআ পিং, চিয়া/কিনা আপে জাহানা তেপে কাপে কুলিয়া লেনা/টোনটা/অভাব/রেঙ্গেজ লেনা পে। ইঙ্কূ দুকু গাম কেৎয়াকু, জাহানা হ লহয়। ");
INSERT INTO cdz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ইন্তং যীশু ইঙ্কূকে গাম রুয়াড় কেৎ কুয়ায়্য় য়, মেন্খান নাহ অকয় রাঃআ থাইলি/বাগুলি মেনা ইনি দ ইনায় ইদিকা আয়, এনকাগে ঝোলা/তরাঃআ হ ইদি ধরাঃআয় কায় হেৎদ অকয় রাঃআ তারোয়ারি/খানডা বানে/বায়ায় না, ইনি আয়া উয়ুনা/বারকি আখরিং কাতে মিয়াৎ -এ কিরিংয়ী কায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","চিয়াচি ইঞ আপেকে গাম তানা পিং, নিয়া যে থুতি/জাগার কু অল মেনা, ইনি এতকান কামীয়ানকুল গে লেখামেসায় নায়। মেন্তে ধরম-পুথি রে/শাশতর রে অলাকান ইঞ য়ে টুড়ু/পুরাঃআ লাগতিং আ। ");
INSERT INTO cdz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ইন্তং ইঙ্কূ গাম কেৎয়াকু, এ প্রভু, নেলেম, বারিয়া তারোয়ারি মেনা, ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় , ইনাগে ঢের গেয়া/আশু গেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","হেৎদ এন্ডে হাতেন উডুং কাতেন, যীশু দ আয়া আরি-চালি লেকাতে, জেইতুন বুরুরে সেনয়েন্তে হেৎদ চেলা কু দুকু পাঞ্জা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","এন্ডে সেটের কাতে ইঙ্কূকে গামাৎ কুয়ায়্য় য়, বিডা/বিড়া/বিনিড়ি রে আলবু উয়ুগোয়া মেন্তে বিন্তি-ই পে। ");
INSERT INTO cdz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","হেৎদ ইনি মিয়াত দিরি হুরাঃআং ইমিনাং/ইন্তি সাংগিন ইঙ্কূ য়া ফারাঃআক কাতে উকুড়ুম কাতে, বিন্তি আসি কিইয়ায়্য়, গামাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","এ বাঃআ, আম সানাং খান/নানাম লেংখান/মেনে নিয়া দুঃখ রেদ ইঞ আ হান্ডে হাতেন নিয়া বাটি অচয় মে, ইঞ আ দ লহয় বচ্ছম আমাঃ মেনলেকা/নানামা লেকা হুয়ু কা। ");
INSERT INTO cdz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ইন্তং গে সেরমা হাতেন মিয়াৎ সরগ নাগা ইনি রাঃআ হান্ডে নেল কিয়ায় হেৎদ দাড়িয়ান কিয়ায়/দাড়ি এম তকা কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","হেৎদ ইনি পুরাঃআ দুকুয়েন্তে আয় মিন মতে তেগে বিন্তি কিইয়ায়্য় হেৎদ ইনি রাঃআ হুকা দা মায়ম ঠপ লেকা অতে রে জরয় না। ");
INSERT INTO cdz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","হেৎদ ইনি দ বিন্তি কেৎ তে বিরিৎ দেনায় খান, চেলা কুরাঃআ হান্ডে হিচে ন্তে ইঙ্কূ দুকু ভাবনাতে দুদরুমতান এ নামকেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ইনি গামাৎ কুয়ায়্য় , চিয়া পে দুদরুমতানা? মা বিরিৎ পে, বিন্তি পে ইনাতে আপে দবিডা/বিড়া/বিনিড়ি রে আলপে উয়ুগোয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","হেৎদ ইনি থুতি তান কেনায় ইন্তং গে নেলেপে, গাদেল হড় কু দুকু হিচে না হেৎদ গেল বার চেলা কুরাঃআ তালা হাতেন যীহুদা নুতুম তে মিয়াৎ চেলা ইঙ্কূ মাড়াং কানায় তাহি কেনায় হেৎদ যীশুকে চঃঅ নাতিনাং আয়া কাতাতে হিচে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","মেন্খান যীশু দ ইনি কে গাম তার কিয়ায়, এ যীহুদা, কিনা আম মান্মি হন চোঃই তানরে/তানলোম সাবাই চিতানাএ/সাবি/সাবই তানাম। ");
INSERT INTO cdz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","হেৎদ ইনিলো (যীশুলো) চেলা কু তাহিকান কু কিনা কিনা হুইয় আ মনে/আটকার তানা মেন্তে কু নেল কেৎ খান গামাৎ কুয়ায়্য় য়, এ প্রভু, কিনা আলে তারোয়ারি/খানডা তে মাআ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","মেন্খান যীশু গাম রুয়াড় কেৎ কুয়ায়্য় য়, ইঙ্কূ য়া তালা হাতেন মিয়াত চেলা মারাঃআং বামড়ে রাঃআ দাসী রাঃআ জজম লুতুর দ মাআ হেড় নুর কেৎ তেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","মেন্খান যীশু গাম রুয়াড় কেৎ কুয়ায়্য় য়, হোকা লেপেএ/বাস ইন্তিগে/থির পে। হেৎদ ইনি দাসীরাঃআ লুতুর জুটিত কেৎ তে বুগি কেৎ তায়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ইনাতে যীশু দ আয়া হান্ডে হিজু কান মারাঃআং বামড়ে, জাহের স্থান হরঃআ কানকু, গুসিয়া/সুবেদার কু হেৎদ মুরুব্বি কু গাম রুয়াড় কেৎয়াকু, কিনা, ইঞ দ ডাকু/রেরেঃনি তা লেকা তানায়ইঞ, ইনাতে আপে তারোয়ারি/খানডা হেৎদ ঠেঙ্গা সাব কুয়ান তে ইঞ যত উডুং হিজু কানা পে। ");
INSERT INTO cdz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","মাহা গে ইঞ দ আপে লোইঞ জাহের স্থান রে তাহী কানরে, ইন্তং আপে ইঞ রে তিহি কাপে জিলিং কেয়া, মেন্খান নিয়া আপেয়া নেডা/সময় হেৎদ নুবাঃরাঃআ একতিয়ারি তানা। ");
INSERT INTO cdz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ইঙ্কূ ইনিকে সাব ইদিকি তে মারাঃআং বামড়ে রাঃআ অড়া তেকু আউকিয়া। হেৎদ পিতর সাংগিন রে তাহি কাতেন তায়ম তায়ম তে সেনে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","হেৎদ হড় কু তালা রাঃআচা রে সেংগেল তিং/জুল কেৎ তে, যত কু দুবেনা। হেৎদ পিতর হ ইঙ্কূ লো দুবে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","হেৎদ ইনি সেংগেল মার্শাল রে দুবা কানতে মিয়াত দাসী মিত ঢেক তে কয়আ/লোড দঃহ কিত্ তে গাম কিইয়ায়্য়, নিই হঅ ইনিলো তাহিন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","মেন্খান পিতার বেদা এন্তে/কা পাতিয়া লেন্তে, এ বুডি /এ এংগাইঞ ! ইঞ ইনিকে কাইঞ সারি আইঞ /চিহ্না তিইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","হুডাং তায়ম তে অটঃ মিত হড় ইনিকে নেল কাতে গাম কিয়ায়, আম হঅ ইঙ্কূ য়তে মিয়াতনি তানাম। মেন্খান গামকিইয়ায়্য়, এ হড়, ইঞ দ লহয় তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","হেৎদ মিত ঘন্টা লেকা তায়ম তে হেৎদ অটঃ মিহুড় সার্তি গে নিই ইনিলো তাহী কেনায়, নি দো গালিল রিনিই তানা মেন্তে এ গাম কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ইন্তং পিতর গাম কিইয়ায়্য়, এ হড়/এ হো, আম কিনা গামে তানাম, ইঞ কাইঞ সারিয়া। ইনি থুতি তানায় ইন্তং গে সিম কু রাঃআ কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","এন্তে প্রভু মচা ঘুরাঃআ লুআড় কেৎ তে পিতর রাঃআ হানতে আরিদ/কয়ঃঅ/লড কিইয়ায়্য়, ইনাতে পিতর সিম আউরি রাঃআ রে আম আপিসা আইঞ ইনি কাইঞ সারিয়াম গামেয়া মেন্তে প্রভু আয়া অকা জাগার কু গামলিয়ায় ইনা জাগার কু পাহাম তকা কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","হেৎদ পিতর বাহার উডুং এন্তে সিকিৎ -এ রাঃআ /ইয়াম কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","অকা হড়কু যীশুকে সাব লিয়াকু, ইনি কে দাল কেৎ তিকু লান্দাই কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ইনিয়া মেত তল জাপিত কিঃতে হেততে কুলি কিয়াকু, ভাবি/আয়ার জাগারেম, মার উদুয়া লেম, অকয় আমকে থাপরি/চাটি কেৎ মেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","হেৎদ ইঙ্কূ দ ইনিকে ঢের লেকা হিলা/ঘাসাও জাগার কেৎ তেকু ইনি রাঃআ বিরুধ তে গাম কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","সেতায় না খান/আংএনা খান/লেগে, সমাজ হড়কুরাঃআ মুরুব্বি কু, মারাঃআং বামড়ে কু, হেৎদ সাস্তর পণ্ডিত কু/আইন ইতুকু হুন্ডি য়েনা হেৎদ আকুয়াআ সভা/পাচাইত রে আগু কেৎ আম ক্রিস্ট তানমে রেদ/যদি আম ক্রিস্ট তানাম মার আলেকে গাম লেমে। ");
INSERT INTO cdz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","আম যদি ইনি ক্রিস্ট তানাম, তবে আলেকে গামালেম, যীশু ইঙ্কূকে গামাৎ কুয়ায়্য় য়, আপে কেইঞ গামপেয়া, মেন্খান আপে কাপে পাতিয়া। ইঞ ইনি তানা মেন্তে. ");
INSERT INTO cdz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","আপে কেইঞ কুলিপেয়া, মেন্খান আপে কাপে গাম রুয়াড় দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","মেন্খান নাহা হঅ মান্মি হন ঈশ্বর রাঃআ দাড়িয়ান/পেড়েঃয়ান এতম সায়রে দুবা কানায়। ");
INSERT INTO cdz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ইন্তং যতচ কুলিকিয়া, তবে দ কিনা আম ঈশ্বর রাঃআ হন তানাম? ইনি গামাৎ কুয়ায়্য় য়, আপে গেত গামে তানাপে, ইঞ দ ইনি গে। ");
INSERT INTO cdz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ইন্তং ইহুদি রিঙ্কু হড় কু গামকেৎয়াকু, নাহা দ আবুয়া চিকান গোহা লাকতি তানবুয়া? আবু গেবু/আবুতেত গেবু ইনি রাঃআ মচা হাতেন আয়ুম কেয়াবু। ");
INSERT INTO cdz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","হেৎদ দরবার হাতেৎ বিরিৎ এন্তে ইনি পিলাত রাঃআ হান্ডে যীশু কে কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","হেৎদ ইঙ্কূ দ ইনি আজাস/আনদেন/চাকাদ নাতিনাং কু লাগায় না, হেৎদ গামে তানাকু, নি হড় দ আলেয়া জাত রিঙ্কূ বাগড়াকোতান কুয়ায়্য় য় হেৎদ কোইসর খাজনা আলোপে এমিয়া গাম তানকুয়ায়্য় য়, হেৎদ আয়গে ক্রিস্ট রাঃআজা গামঃ তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ইন্তং পিলাত যীশু কে কুলি কিয়ায়, কিনা আম যিহুদি কুরাঃআ রাঃআজা তানাম? ইনি গাম রুয়াড় কিয়ায়, আম গে গামেম। ");
INSERT INTO cdz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ইন্তং পিলাত মারাঃআং বামড়ে কুকে হেৎদ গাদেল হড় কুকে গামাৎ কুয়ায়্য় য়, ইঞ নি হড় রাঃআ জাহানা দোষ/গুনহা কাইঞ নাম তানা। ");
INSERT INTO cdz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","মেন্খান ইঙ্কূ জেরাঃআ কাতেকু গামকেয়া, নি দ গালিল হাতেন নেন্ডে ধাবিজ গোটা যিহুদিয়া দিসুম রে হড় কুকে চেত/ইতুকোতানলেএ উস্কুররে লেত কেন কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","নিয়া আয়ুম কাতে পিলাত কুকলি কেৎ কুয়ায়্য় য়, নি হড় টা কিনা গালিলিয় রিনিজ তানায়? ");
INSERT INTO cdz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","তায়ম তে সারি/আটকার নাম কেৎ খানয়, ইনি দ হেরদ রাঃআ রাঃআজ্য রিনিজ। ইন্তং ইনি হেরদ রাঃআ হান্ডে কুল কিয়ায়, চিয়াচি ইনি দ ইনা হুলাং কুরে যিরুশালেম রে তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","যীশু কে নেল নাম কাতেন হেরদ কুঠিন গে রাঃআসকায় নায়, চিয়াচি ইনি দ ইনি রাঃআ বিসয়/বানার-এ আয়ুমা কেৎ তে ইনা নাতিনাং গাদা মাহা হাতেন আয়কে নেল সানা কিয়া হেৎদ ইনি রাঃআ জাহানা চিনা কামীতাইঞ নেল আশা রেইঞ মেনাইঞ আ। ");
INSERT INTO cdz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ইনাতে হেরদ গাদা থুতি কুলি কিআইঞ যীশু কে, মেন্খান যীশু ইনকে জাহানা হ কায় গামরুয়াড় কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","মারাঃআং বামড়ে হেৎদ সাস্তর পণ্ডিত কু তিনগু য়েন্তে জেরাঃআ কাতেকু আজাস/আনদেন/চাকাদ/দোষী কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","হেরদ হেৎদ আয়া পাল্টন কুল ইনি কে হিলাকিত্ তে লান্দা কিয়া হেৎদ ঠনক কিচি তুসিং কাতে ইনিকে পিলাত রাঃআ হান্ডে কুল রুয়াড় কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ইনা হুলাং হেরদ হেৎদ পিলাত দকিন গাতি রুয়াড় এনা, ইন্তে মাড়াং তে আকিন-আকিন রে বাইরি/খিসতান কিং তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","হেৎদ পিলাত মারাঃআং বামড়ে, সাস্তর দরম গসিই হেৎদ হড় কুকে রাঃআ হুন্ডি কাতে গামাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","আপে নি হড় কে নিয়া গাম কাতেন ইঞ আ হান্ডে আউ তিয়াপে, নি ই হড় কুকে এটা হরাঃআ তে ইদি কুয়ায়্য় য়, হেৎদ নেলেপে ইঞ আপেয়া সামাং রে ধরবার লেখান হঅ আপে ইনি রাঃআ চেতান রে অকা আজাস/আনদেন/চাকাদ/দোষ কু উদু লাপে, ইনা কুরাঃআ জাহানা হঅ নিই রাঃআ হান্ডে কাইঞ নেল নাম লা। ");
INSERT INTO cdz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","হেরদ হঅ কা নাম দাড়ি লাআয়। চিয়াচি ইনি নি কে আয়া হান্ডে রুয়াড় কুল তিয়ায়, হেৎদ নেলে পে, নি হড় গয়চ লেকান জাহানা হঅ কামী কায় কামী তায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ইঞ নি কে হাড়সাকি তিং আড়া গিডিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(ইনা সাকরাত পরবরে হড় কু নাতিনাং মিয়াত হড় আড়াই লাকতিং তাহি কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","মেন্খান ইঙ্কূ যতচ মিয়াৎ য়েন্তে কিকিচ কাতে গাম কেৎয়াকু, নিই কে হার/কুদা গিডি পে, আবুয়া নাতিনাং বারাঃআব্বাকে আড়াই পে। ");
INSERT INTO cdz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","যীরুশালেম সরগ নাগার তালারে হালাগুলা হেৎদ হড় গয় নাতিনাং কায়দি/হেপাজত আকানায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","পিলাত দ যীশু কে আড়া সানাইয় তে অটঃ ইঙ্কূ লো থুতি লাগায় নায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","মেন্খান ইঙ্কূ কিকিচ কাতে গাম কেৎয়াকু, ক্রশ রে রাঃআকাব বিম/এমিপে, ইনিকে ক্রশ রে এমিপে। ");
INSERT INTO cdz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","হেৎদ ইনি আপিসা গামাৎ কুয়ায়্য় , চিয়া? নিই কিনা আজাস/আনদেন/চাকাদ/দোষ তাআয়, নি হড় গয়চ লেকান জাহানা হঅ কামী কায় কামী তায় এন্খান গে ইঞ নি কে হাড়সাকি তিং আড়া গিদিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","মেন্খান ইঙ্কূ জোর তে কিকিচ, যাতে ইনি কে ক্রশ রে রাঃআকাব বিম/এমিপে, মেন্তে কু অটঃ জোর তেকু কিকিচ কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ইন্তং পিলাত ইঙ্কূ য়া আসিতান কুলেকা/নানামান লেকা গে হুকুম কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","হালাগুলা হেৎদ হড় গয় নাতিং কায়দি কু নামে না, ইনি কে আড়া গিদি কিয়ায় মেন্খান যীশু কে ইঙ্কূ য়া সানাইঞ রে এম্কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","হেৎদ ইঙ্কূ ইনিকে ইদি তানা কু, ইন্তং গে শিমোন নুতুম তে মিয়াত হড় হাতু হাতেন হিজু কেনায়, ইঙ্কূ ইনিকে সাব কাতেন কুরুশ ইনি রাঃআ তারাঃআন রে লাৎ কেৎয়াকু, যাতে যীশু রাঃআ তায়ম তায়ম তে বহা ইদি কায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","গাদেল হড় তায়ম তায়ম তে সেএ নাকু, গাদা লেকা বাহুকুড়ি হন হ তাহীন কেনাকু, ইঙ্কূ ইনি রাঃআ নাতিনাং গার্জা কাতে ইয়াম মে নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","মেন্খান যীশু ইঙ্কূ কে কয়অ কাতে গামাৎ কুয়ায়্য় , যীরুশালেম রেঙ্কূ কুড়িহন কু, ইঞ আ নাতিনাং আলপে ইয়ামা আ বচ্ছম আপেয়া হেৎদ আপেয়া হন-হপন কুরাঃআ নাতিনাং ইয়াম পে। ");
INSERT INTO cdz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","চিয়াচি নেলেপে, এনকান সময় হিজু তানা, ইনা রে/হুলাং হড় কু গামেয়া, সুকুতানগেয়া/বুগিনতানগেয়া ইঙ্কূ কুড়ি হন, অকয় আটকুড়া গেয়াকু, ইঙ্কূ য়া লা হিচ যাহা হুলাং/চিললং কাকু তয়া নুনু তান কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ইনা হুলাং হড় কু বুরু কুকে গাম কুয়াকু, আলেয়া চেতানরে নুরোম হেৎদ গুটু কু আলেকে হারুব দঃহ লেম। ");
INSERT INTO cdz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ইঙ্কূ দ হারিয়াড় দারু কু নেকায় লেংখান, লহড়া কান দারু কিনা চিকাঃআয়? ");
INSERT INTO cdz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","হেৎদ ইঙ্কূ ইনিলো গয় কিইঞ নাতিনাং এট্কানায় কামী কেন হেৎদ অটঃ বার হড়কিন কে ইদি কেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","হেৎদ ইঙ্কূ বহঃ জাং/খাপরি কু নুতুমঃমোতান/গামেয়া জায়গা/টায়াট তে সেটের লেন্তে এন্ডে যীশু কে কুরুশ কিয়াকু, ইনিকে হেৎদ ইঙ্কিন বারহড় ডাকু/এত্কান কামীকেন কিনকে, মিয়াত দ জোম/এতম সায়/দর, এতাগীই দ লেঙ্গাসায় ক্রশ রে হাকা কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ইন্তং যীশু গামকিইয়ায়্য়, এ বাঃ, বাবা, ইঙ্কূ ছেমা কুম, এন্তে নিকু দ কিনা চিকায় য়েতানা, কাকু সারিয়া তানা। হেৎদ ইঙ্কূ গুলিবাট/চিটঠি সালাকেৎ তে ইনি রাঃআ কিচি কু হাটিং কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","হড়কু তিনগু কাতে নেলে কেনাকু, মুখিয়াকু হ লান্দা কিঃতেকু গামকিয়াকু, ইনি দ এটাকুকে বাঞ্চাও কেৎ কেন কুয়ায়্য় য়, ইনি ঈশ্বর রাঃআ সালাকান/বাঞ্চাওঃ ইজ ক্রিস্ট তানিঃরেদ/তান খানয়, আয়গে/আয় তেত ভালে/ভেলে বাঞ্চাও কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","হেৎদ পাল্টন কু/পাল্টন কু হ ইনিকে হিজু লেন্তে লান্দা কিয়া হেততে সিরকা/জোজো রাঃআশিকু নু তকা কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","আম যিহুদি কুরাঃআ রাপাজ তানরেদ/তান খানম, আমতেত বাঞ্চাও মে। ");
INSERT INTO cdz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ইনি রাঃআ চেতান রে মিয়াত অল তাহি লেনা \"নিই দ যিহুদি কুরাঃআ রাঃআজা তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","কুরুশ রে হাকা আকিন বারহড় ডাকু/এত্কান কামীকেন কিনকে, ইঙ্কিন এয়তে মিহুড় হিলা কিঃতে গামকিয়ায়, আম ক্রিস্ট তানমে রেদ/তান খানম, আম হেৎদ আলিং বাঞ্চাও লিং মে। ");
INSERT INTO cdz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","মেন্খান এটাই ইনিকে ধমকাঃআ কাতে গাম রুয়াড় কিয়ায়, কিনা আম ঈশ্বর কে হ কম বর ইয়া? আম হঅ মা ইনা সাজাএম নামেতানা। ");
INSERT INTO cdz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","আলিং দ/আলং মা হক লেকাতে, আলং আ নানদান/আজাস/অপরাঃআধ রাঃআ জো/সাজা লাং নামে তানা, মেন্খান নিই মা জাহানা হঅ কায় এট্কান কামী তাআয়। ");
INSERT INTO cdz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","হেৎদ ইনি গাম কিইয়ায়্য়, যীশু আম চিল লং গে আমাঃ রাঃআজ্য রে হিজু য়া/সেটের রআ, ইঞ এ পাহাম মিং মে। ");
INSERT INTO cdz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","যীশু দ ইনিকে গাম কিয়ায়, ইঞ মাকে সার্তিগে গাম তানা মাইঞ, নাহা/তিহীন গে আম ইঞ লো পার দিশুম/সেরমা দিশুম/সেরমা পুরি/সুখ-পুরি এম সেনআ। ");
INSERT INTO cdz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","বেলা/বেড়া দ তিকিন গেলে বার উতারে না, সিং চানদো দানাং এনায় (মুলি তিকিন হালাজলাএতে তার্সিং অপি যাকিৎ গোটা দিশুম নুবায় য়েনা/দানাং এনা)। ");
INSERT INTO cdz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","সিঙ্গি নুবায় না/হেৎদ তারসিং ধাবিজ গোটা দিশুম নুবায় না হেৎদ মান্দির রাঃআ ওরওয়াল/দানাং কিচি দ তালা তালা তে অরেজে না। ");
INSERT INTO cdz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","হেৎদ যীশু দ জোর তে কিকিচ কেৎ তে, এ বাবা/বা/আব্বা, আমাঃ তিহিরেগে ইঞ আ আত্মা দ জিমায় তানা/এমিতানা। হেৎদ নিয়া গাম কেৎ তে জিউ তেয়া উডুং এনা। ");
INSERT INTO cdz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","হেৎদ শতপতি কুরাঃআ গমকে/সুবেদার ইনা অকা হুইয়া কানা/হুই লেনা নেল কাতে, ঈশ্বর রাঃআ সারহাও/জোহার কিইয়ায়্য়, হেৎদ গাম কিইয়ায়্য়, সার্তিগে, নিই হড় দ ধরমান/ধরম হড় তান কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","যত গাদেল হড় কুগে, অকয় নেল জম নাতিনাং সেন হুন্ডি নাকু, ইঙ্কূ দ অকা হুই লেনা, ইনা নেল কাতে কুড়াম তাপরি-থাপরি কাতে রুয়াড় য়ে নাকু। ");
INSERT INTO cdz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ইনি রাঃআ যত নেপেল উপরুম/চীনহা ফার চা হড় কু হেৎদ গালিল হাতেন ইনি লো হিচ লেন বাহুকুড়িহন কুদ সাঙ্গিন রে তিংগু কাতে কু নেল জম তানা। ");
INSERT INTO cdz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","হেৎদ নেলেপে/ ইন্তং গে, জোসেফ নুতুমতাইজ/নুতু মিজ মিয়াত মন্ত্রী ইনি দ বুগিন হেৎদ ধরম মান হড় তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ইনি দ ইঙ্কূ য়া সালহা/উড়ুঃ হেৎদ কামী কুরে কায় মেসা কেনায়। নিই দ যিহুদিকুরাঃআ রিমাথিয়া শেহার রিনিজ হড় তানায়, ইনি দ/আয়তেত হ ঈশ্বর রাঃআ রাঃআজ্য নেল হর তানয়ে তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ইনি/নিই দ পিলাত রাঃআ হান্ডে সেন কাতে যীশু রাঃআ হড় মো এ আসি কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","হেৎদ ইনি ইনা আড়গু কিইয়ায়্য় হেৎদ নিরাঃআল/মুসনা কিচি তে দাপাল/পটম কিয়ায় হেৎদ সেরেন রে/দিরি চেতান রে উরলেদ মিয়াত তপা টায়াত/কবর রে দঃহ কিয়ায়, ইনা অকা দ নাহা ধাবিজ অকয় কে হঅ কাকু দঃহ তা কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ইনা হুলাং দ সাপড়াও রাঃআ মাহা /হুলাং, হেৎদ ঝিরাঃআও মাহা আরম্ভ/নাড়ে আকান তাহি কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","হেৎদ গালিল হাতেন যীশু লো হিজু কানাবাহুকুড়ি হন কু তায়ম-তায়ম তেকু সেনে না, হেৎদ তপা টায়াত/কবর রে ইনি রাঃআ হডমো চিল্কালেকা দঃহ য়েনা/দঃহ তাঃআকু ইনাকু নেল কেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","হেৎদ ইঙ্কূ দ রুয়াড় সেনকাতে, মশলা/বুগিন সোয়ান তে হেৎদ সোয়ান সুনুম কু তেয়ার/সামপাড়/সাপড়া কেয়া। মেন্খান ইঙ্কূ দ আরি-চালি/আনচু লেকাতে রুড়ুন/ঝিরাঃআও হুলাং/মাহা রেকু ঝিরাঃআও য়েনা লে। ");
INSERT INTO cdz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","রাবি হুলাং পায়াং থরাঃআ ইঙ্কূ অকয় এরা কু গালিলিতে যীশু লঅ কু হিচ লেনদ, আকু শয়ান সুনুম সাপড়া আউকেৎ তে তপা থান তেকু হিচে না। ");
INSERT INTO cdz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ইঙ্কূ কবর/তপা টায়াততে দিরি বাটিয়া কানা/অচয়া কানা কু নেল কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","মেন্খান বলঃঅ য়েন্তে ইঙ্কূ প্রভু রাঃআ হড় মো কাকু নেলনাম লাআ। ");
INSERT INTO cdz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ইঙ্কূ নিয়াতে, দান্দা পান্দা কানরে, এনকান সময় রে, নেলেপে, জুলতান/ঝালকাতান কিচি তুসিং আকানা বার হড়কিন ইঙ্কূ য়া কাটা রেকিন তিঙ্গুই নাকিন। ");
INSERT INTO cdz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ইন্তং ইঙ্কূ বর কেৎ তে অতে দর তিরুপ কেৎয়াকু /তিরুপ বেনাকু। ইঙ্কিন বার হড় দকিন ইঙ্কূ কে গাম কেৎ কুয়া কিন, গয় আকান কুরাঃআ তালারে জীউৎকুকে চিয়া পাঞ্জা ভাড়াতানাকুয়াপে? ");
INSERT INTO cdz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ইনি নানডে বানুই আ, মেন্খান ইনি দ জিউত রুয়াড় আকানায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","গালিল রে তাহি কান রে/তাহিন কেনায় ইন্তং ইনি কিনা গাম লা পেয়ায়, পাহাম মেপে। ");
INSERT INTO cdz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ইন্তং এরা হন কু যীশু রা আ জাগার কু পাহাম নাম কেৎআ। ");
INSERT INTO cdz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","হেৎদ ইঙ্কূ তপা থান হাতেন রুয়াড় য়েন্তে ইঙ্কূ গেল মিত চেলা কুকে হেৎদ এটা যত কুকে নিয়া কু গাম সদর কেয়া কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ইঙ্কূ দ মগদলিনি মরিয়ম, জোহানা হেৎদ যাকোব রাঃআ মাইতেত মরিয়ম, ইঙ্কূ লঃঅ এটা বাহু কুড়ি হনকু হ কুলিচ কুকে নিয়া যত থুতি গাম কেয়া কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","মেনখান, নিয়া যত থুতি কু ইঙ্কূ মিৎ গেলে মিৎ দ গাম একেন ফান্দা কাহিনী লেকা আটকার কেয়া। ইঙ্কূ ইনুকুয়া থুতি রে কাকু পাতিয়াও লেনা। ");
INSERT INTO cdz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","হেৎদ পিতর বিরিৎ য়েন্তে তপা থান তে নির ইদি কিইয়ায়্য়, হেৎদ উংগুত য়েন্তে কোয়অ কিইয়ায়্য় একেন উয়ু মুসনা কিচিকুগে দঃহ মেনা নেল কিইয়ায়্য়। হেৎদ ইনি দ অকা হুইলেনা ইনা কুতে হায়কাট য়েন্তে অড়া তে রুয়াড় এনায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","হেৎদ নেলেপে, ইনা হুলাং ইঙ্কূ য় তে চেলা কু হাতেৎ বার হড় ইম্মায়ু নুতুম মাঃ হাতু তেকিন সেন কেনা কিন, ইনা অকা দ যিরুশালেম হাতেন মিৎগেলে মিৎ মাইল লেকা সাংজিন রে তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","হেৎদ ইনকিন দ ইনা গাঢা ভীতির যীশু বানু ইয়া হুয়াকানা/হুই লেন যতচ া কিন থুতি জম কেনা কিন। ");
INSERT INTO cdz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ইঙ্কিন বারিয়া চেলা আকিন-আকিন গে থুতি কেনা কিন হেৎদ কুলিকেনা কিন, ইন্তং গে যীশু আয়গে কাতাতে হিচ য়েন্তে ইঙ্কিন লো গাতি ইদি নায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","মেন্খান ইঙ্কিন হুঁস কা তাহি লেন্তে মেৎ দানাং আকান তাহিন কেনা হেৎদ যীশু কে কাকিন নেল চিহ্না নাম কিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","যীশু ইঙ্কিন কে গামকেৎ কিনায়, আবেন সেসেন সেসেনতে কিনা বিন থুতি জম কেনা? ইঙ্কিন দকিন তিংগু এনা হেৎদ কুঠিন ভবনা গে কিন নেলে না। ");
INSERT INTO cdz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","হেৎদ ক্লিয়পা নুতুম মিয়াত হড় ইনি গাম রুয়াড় কিইয়ায়্য়, কিনা আম একলা যিরুশালেম রে ডেরাঃআয়েতান রেহ তিহিং গাপা এনে নিয়াকু এন্ডে হুইয়া কানা কাম সারিয়া? ");
INSERT INTO cdz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ইনি ইঙ্কিন কে কুলি কেৎ কিনায়, কিনা হুইয়া কানা? হেৎদ ইঙ্কিন গাম রুয়াড় কিয়াকিন, নাসরতীয় যীশু পাতা/বাব্ত্তে /বাবত তে। ইনি অকয় দ ঈশ্বর হেৎদ যত হড় কু সামাং রে, কামী হেৎদ থুতি তে দাড়িয়ান নাবি তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","চিল্কা লেকা, মারাঃআং বামড়ে হেৎদ আলেয়া গমকে কু ইনিকে গচ নাতিনাং সাব দুব ইদি কিয়াকু হেৎদ রোম সেনা কুদ যীশু কে কুরুশ রেকু হাকাকিয়া। ");
INSERT INTO cdz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","মেন্খান আলে আশায় তানা কেনা লে, ইনি গে ইস্রাঃআয়েল কে ছাডা কুয়ায়্য় য় মেন্তে। নিয়া যত দ লহয়, ইনাকু হুইঅ তায়ম, নিয়াকু তিহিং আপি মাহা হুইঅ তানা। ");
INSERT INTO cdz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","অটঃ গে আলেয়া কথক বাহু কুড়ি হন দুকু আলেকে হায়কাট কেৎলেয়াকু, ইঙ্কূ দ ভোর অপি পহররে তপা থান তেকু সেনলেনা। ");
INSERT INTO cdz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","হেৎদ ইঙ্কূ যীশু রাঃআ হড়মো কাকু নেল নাম কেৎআ, হিচ রুয়াড়য়েন্তে গামকেৎয়াকু, আলে সেরমা সরগ নাগা কিনকে নেল কেৎ কিনালে, ইঙ্কিন দ যীশু জিউত রুয়াড়কানায় মেন্তে কিন গাম কেৎ লেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","হেৎদ আলে লঃঅ অক্য়য় কু তপা থান তেকু সেনলেনা, ইঙ্কূ বাহু কুড়ি হন চিল্কা গাম লা কুয়াকু, এনকা নেল নাম কেৎয়াকু, মেন্খান যীশু রাঃআ হড়ম কাকু নেল নাম লাঃআ। ");
INSERT INTO cdz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ইন্তং যীশু ইঙ্কূকে গামাৎ কুয়ায়্য় য়, এ লেল্হা, নাবি গাম তা আকু যত থুতি পাতিয়াও নাতিনাং মন কেটে আকান হড় কিন। ");
INSERT INTO cdz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","কিনা, ক্রিস্ট/মাশি দ নিয়াকু দুখ সাতাও হেৎদ আয়া মহিমা রে বলঃঅ কা লাকতিংতান তাহিকেনা। ");
INSERT INTO cdz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ইনাতে ইনি দ মোশি হেৎদ যত নাবিকুকে এটেকেৎ তে গোটা ধরম পুঠি রে আয় নাতিনাং অলাকানা যত থুতি কু, ইঙ্কিন কে বুঝা কেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","হেৎদ ইঙ্কিন সেন কেনাকিন হাতু তেকিন সেটের লেনচি/লেনতি ইনি মাড়াং দর লেকায়/লেকাএ উদুয়েননা। ");
INSERT INTO cdz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","মেন্খান ইঙ্কিন দ ইনি কেকিন নেহরাঃআ কিয়া, আলিঙয়া অড়ারে আলিং লো তাহীন মে, ইন্তে আয়ুব ব তানা, বেলা ডুম্বুইজ এনায়/সিঙ্গি হাসুর রে না। হেৎদ ইনি ইঙ্কিন লো তাহি নাতিনাং বলয় নায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","হেৎদ ইনি ইঙ্কিন লো জম দুবেন তে, পিঠা সাব কেৎ তে আশির্বাদ/ভরাঃআন কিইয়ায়্য়, হেৎদ পেটেজ/কেচা কেৎ তে ইঙ্কিন এমাত কিনায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","এন্তে ইঙ্কিন মেত অটায় না হেৎদ ইঙ্কিন ইনিকে নেল গটা /নেল উরুম কিয়া কিন, মেন্খান ইনি ইঙ্কিন মেত সামাং হাতেন ছান/ছানে নায়/গদে নায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ইন্তং ইঙ্কিন (চেলা কিন দকিন) কুলি-কুকলি তানা, চিললং ইনি দ হরাঃআ রে আলং লো থুতি লেনায়/কেনায় হেৎদ সাস্তর/ধরম পুথি রাঃআ মুডি/আরাঃআথ গাম সদর রাঃআ লাং তাহি কেন/কান রে, কিনা আলাং আ অন্তর দ আলাং মন/ভীতির রে কায় জুল রাঃআকাব এনা/লেনা তাহি কেনা। ");
INSERT INTO cdz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ইঙ্কিন দ ইনা ঘাড়ি রেগে/ ইন্তং গে বিরিৎ য়েন তিকিন যিরুশালেম তে রুয়াড় এনা, হেৎদ ইঙ্কূ গেলে মিৎ চেলাকুকে ইঙ্কিন গাতিকু লো/এটা হড়কু লো হুন্ডিয়া কানাকিন নাম কেৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","হেৎদ ইঙ্কূ আয়ুম তাৎআ কু অক্য়য় চেলা গামেত কেনাকু, হে সার্তিগে প্রভু দ জিউত রুয়াড় আ কানায় হেৎদ শিমোন কে নেল সদর রাঃআ তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","হেৎদ ইনকিনা হরাঃআরে হুইয় লেনা হেৎদ পিঠা কেচা তান রে চিল্কা লেকা কিন নেল-মুন্ডি পাছনা কিয়া কিন মেন্তে নিয়া কু গাম সদর রাঃআত কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ইঙ্কিন আকিন তেত গে নিয়া কু থুতি কেনা কিন, ইন্তং গে যীশু দ আয় তেত গে ইঙ্কিন তালারে তিংগুই নায় হেৎদ গাম কেৎ কিনায়, আপে সুলুক কা পে তানা/তানায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ইনাতে ইঙ্কূ দ বর কেৎয়াকু হেৎদ থারথারাঃআ য়েন তে চমকা য়েন তে, আটকার কেৎয়াকু, চুড়ীন নেলি তানা। ");
INSERT INTO cdz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","যীশু গামাৎ কুয়ায়্য় য়, আপে দ চিয়া পে ধুকু-চুকু তানা হেৎদ আপেয়া অন্তর রে নিয়া সন্দেহ/দিগ্ধা-দিগ্ধি/আরাঃআ-উরু দ চিয়া রাঃআকাব য়ে তানা। ");
INSERT INTO cdz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ইঞ আ তিহিকিন হেৎদ কাটা কিন নেলতিন পে, ইঞ দ ইনতেত তানগে, ইঞ কে চাপুইঞ পে/জুটিজ জিং মে হেৎদ নেলেন পে, চিয়া চি আপেপে নেলে য় চুড়ীন লেকা ইঞ য়ে মেনা তিং লেকা জাং-জিলু বানে না। ");
INSERT INTO cdz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","নিয়া গাম কাতেন ইনি ইঙ্কূ কে তিহি হেৎদ কাতা উদু কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","তুবুই রহ ইঙ্কূ রাঃআসকা তেয় কাকু পাতিয়া দাড়ি লেনা, হায়কাট/আকা-দান্দা য়েন্তে/লেকা তাহি নাকু। ইনাতে ইনি ইঙ্কূকে গামকেৎ কুয়ায়্য় য়, আপেয়া হান্ডে জম নাতিনাং নেন্ডে জাহানা মেনা তাপেয়া। ");
INSERT INTO cdz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ইন্তং ইনিকে ইঙ্কূ মিয়াত আন্দা কানা হাকু এমা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","হেৎদ ইনি দ আতাং কাতে ইঙ্কূয়া সামাং রে ইনাকু জম কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","হেৎদ ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় , আপে লো তাহী-তাহি তে ইঞ আপেকে অকা গাম লাআ পিং, ইঞ আ ইনা জাগার নিয়া, মোশি রাঃআ রি-চালি রে হেৎদ নাবি কুরাঃআ পুথি রে হেৎদ দুরাঃআং পুথি রে ইঞ আ নাতিনাং অকা অলা কানা ইনা যত পুরাঃআ লাকতি না। ");
INSERT INTO cdz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ইন্তে ইনি শাস্ত্রড়/ধরম পুথি আটকার ইচি/উরু নাতিনাং ইঙ্কূ য়া (বুদ্ধি ঝিঃইত কেৎ তাকুয়া) মনে সেঃঞড়া/সেড়া কিইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","হেৎদ ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় য়, শাস্ত্র রে নিয়াগে অলমেনা ক্রিস্ট দুখ-সাহাও আয় হেৎদ আপি মাহা হুলাং গয় হাতেন জিউত রুয়াড় ওয়ায় লাকতি তানা। ");
INSERT INTO cdz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","হেৎদ ইনি রাঃআ নুতুম তে পাপ ছেমা নাতিনাং মন-লুয়াড় আউ /হিয়াতিন রাঃআ যিরু সালেম হাতেন এটে কাতে যত জাইত/দিশুম রেঙ্কূয়া তালারে পচারো কা। ");
INSERT INTO cdz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","নিয়া কুরাঃআ গোয়া/লুকুন্দী কু দপে আপে কু তানাগে। ");
INSERT INTO cdz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","হেৎদ নেলে পে ইঞ আ আপুইঞ রাঃআ একরাঃআর আগম রনদ আপেতেত তিং নাহা কুলা তানা পিং, মেন্খান চোট্/চেতান হাতে দাড়ি আউরি পে নাম ধাবিজ/ভুর আপে দ নিয়া শেহার যীরুশালেম রেগে তাহি থাড় পে। ");
INSERT INTO cdz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ইনাতে যীশু দ বোইথনিয়া হাতু সামাং তেয়/সীমা ধাবিজ ইঙ্কূয়ে/ইঙ্কূ কে উডুং ইদি কেৎ কুয়ায়্য় য়। হেৎদ আয়া তিহি দনদো/তুল কেৎ আশিস/ভরাঃআত কেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","হেৎদ ইনি ইঙ্কূকে আশিসকোতান লো/আশিস কেৎ তুলুইঞ জ গে ইনি দ ইঙ্কূ য়া হান্ডে হাতেন ভিনা/ভেগার এনায় হেৎদ সেরমা তে রাঃআকাব ইদি নায়। ");
INSERT INTO cdz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ইঙ্কূ দ ইনিকে জোহার কিঃতেকু আশু রাঃআসকা তে যিরুশালেম তেকু রুয়াড় সেএঃ না। ");
INSERT INTO cdz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","হেৎদ ইঙ্কূ দ জাহের স্থান রে গে তাহি কাতেন ঈশ্বর রাঃআ সারহাও রেকু তাহি না।");
INSERT INTO cdz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","গুনমান থিওফিল, ইঞ দ মাড়াঙ পুথিটা ইনা যত বাবত ইদিকাতে অল তাৎআইঞ, অকা যীশু ইনা হুলাং যাকিৎ করা হেৎদ চেচেদ এতহব লাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","অকা হুলাং ইনি আয়া বাছায়ান কুলিচ কুকে রীলামালা আত্মা রাঃআ তে হুকুম এমকেৎ কুতে সেরমাতে সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","নিজেরাঃআ দুঃখ সাহাকেৎতে গজ বিরিৎ তায়মতে ইনি দ ঢের লেকা চিপ্না এমকাতে ইঙ্কূয়া হান্ডে নিজেকে জীউৎ উদুয়াকেৎ কুয়ায়্য় য়, পুলি মাহা যাকিৎ ইঙ্কূয়া হান্ডে নেল-সদর তুকাকেৎ কুয়ায়্য় য়, হেৎদ ঈশ্বর রাঃআ মুলুক রাঃআ বাবদ তে নাআহানা থুতি গাম কেৎকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","হেৎদ ইনি ইঙ্কূলোঅ যজম অক্ত নাপাম মেন্তে নিয়া হুকুম এমাৎকুয়ায়্য়, আপে যিরুশালেম শেহার শাহার হাতেন বাহারতে আলপে সেনা মেন্খান আপুরাঃআ এক্ড়ার লাৎআয় অকা দান রাঃআ থুতিকু ইঞা হান্ডে আয়ুম তাৎ আপে, ইনা রাঃআ তাঙ্গিপে। ");
INSERT INTO cdz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","চিয়াচি যোহন দ দাঃআ রে ডুবুলেৎ কুকেনায়, মেন্খান আপে দ হুডাং মাহা তায়ম খানগে প্রভু রাঃআ রীলামালা আত্মাতে ডুবুলআঃপে। ");
INSERT INTO cdz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","এন্তে ইঙ্কূ যতচ মিশাতে ইনিকে কুলিকিয়াকু, প্রভু, নিয়া কি ইনা মাহা তানা, চিন্তং আম খেরোয়াল দিসুম রাঃআ তিহিরে পারহড় এম রুয়াড় কুয়াম? ");
INSERT INTO cdz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ইনি ইঙ্কূকে গামকেৎ কুয়ায়্য়, অকা মাহাকু চি কাল আপু নিজে রাঃআ আইদারি রে দহঃঅ তাৎআয় ইনা আপেয়া সারিরাঃআ বাবত লহয়তানা। ");
INSERT INTO cdz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","মেন্খান রীলামালা আত্মা আপেয়া চেতান রে হিচ লেংখান আপে দাড়িপে নামেয়া, হেৎদ আপে পারহড় যীরুশালেম শেহার, গোটা ইহুদিয়া মুলুক দিশুম হেৎদ শমরিয়া দিশুমরে হেৎদ ধারতি রাঃআ মুচাৎ যাকিৎ ইঞা লুকুন্দী হুইওয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","চিন্তং প্রভু যীশু নিয়া যত থুতিকু গামেতানায়, ইনি ইঙ্কূয়া মেদরাঃআ সামাং রে রাকাব ইদি লাগায়নায়, মিয়াৎ রিম্বিল ইঙ্কূ য়া নেলহরা হাতেন ইনিকে দানাংকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ইনি সেনঃতানায় হেৎদ ইঙ্কূ নিরালা দর মিৎ ঢেকতে কয়ঃঅ তাৎ আকু, এনকান অক্ত, পুন্ডি সনঃঅ তুসিংআ কানাকিন বার হড় ইঙ্কূ য়া হান্ডে তিঙ্গুই নাকিন, ");
INSERT INTO cdz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","হেৎদ ইনকিন গামকেয়াকিন, দুলাড়িয়া গালিল রিঙ্কূ হড়কু, আপে নিরালা দর কয়অ কাতেন তিঙ্গুয়া কানাপে চিয়া? ইনি দ যীশু আপেয়া হান্ডে হাতেন সেরমাতে রাকাবেনায়, ইনিকে চিল্কা সেরমাতে সেনঃঅ নেল কিয়াপে, এনে এনকাগে ইনিকে রুয়াড় হিচু নেলিয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ইন্তং ইঙ্কূ জৈতুন নুতুমান বুরু হাতেন যীরুশালেম শেহার তেকু রুয়াড় সেনেনা। ইনা বুরু যীরুশালেম শেহার রাঃআ কাতারে, মিয়াৎ ঝিরাও মাহা রাঃআ হরা তারা মাইল। ");
INSERT INTO cdz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","শেহার তে সেনকাতে কদেরে ইঙ্কূ তাহিনকেনাকু, ইনা চেতাং রাঃআ অড়াতে চেলা সেনেনাকু পিতর, যোহন, যাকোব হেৎদ আন্দ্রিয়, ফিলিপ হেৎদ থোমা, বর্থলময় হেৎদ মথি, আলফেয়ের রাঃআ হনতেদ যাকোব হেৎদ ঈশ্বর ভক্ত শিমোন, জীলট হেৎদ যাকোব রাঃআ বকতেদ যিহুদা, ");
INSERT INTO cdz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ইঙ্কূ যতচ গে কুড়িহন কুলঅ, হেৎদ যীশু রাঃআ মাইতেদ মরিয়ম হেৎদ যীশু রাঃআ বকতেদ তুকুলঅ মিৎ অন্তরতে বিন্তিরে তাহিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ইনা হুলাং মিৎ হুলাং প্রায় মিৎ চাকি রিলে হড় মিৎ থাংরে হুন্ডি লেনাকু, এন থাংরে পিতর বকতেদ কুরাঃআ তালারে তিঙ্গুয়েন্তে গামাকেৎ কুয়ায়্য় ");
INSERT INTO cdz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","দুলাড়িয়া বকইঞকু, অকয় যীশু কে সাবলিয়াকু, ইঙ্কূকে হরা উদুলাৎ কুয়ায়্য় য় অকা যিহুদা, ইনি রাঃআ ব্যাপারতে রীলামালা আত্মা দায়ুদ রাঃআ মচা হাতেন মাড়াঙতে অকা গামলাৎআয়, ইনা শাস্ত্রীয় জাগার পুরা হুইওরাঃআ জরুর তাহিনোকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","চিয়াচি ইনি (যিহুদা) হড় দ আবুলঅ তাহিলেনায় হেৎদ নিয়া সেবাকামী রাঃআ হাকদার হুইলেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ইনি দ বাড়িচ কামী রাঃআ কামানি তে মিয়াৎ বাইত কিরিং লাৎআয়। ইনা তায়ম ইনিদ তাবের কাতে অতেরে নুরেনায়, ইনি রাঃআ লাহিচ অটেজেন্তে পটা যত উডুঙয়েনা, ");
INSERT INTO cdz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","হেৎদ যীরুশালেম শেহার রিঙ্কূ যতচ হড় ইনাটা সারি নামলাৎ আকু, নিয়া মেন্তে ইঙ্কূয়া জাগারতে ইনা বাইত/অতে হকলদামা অর্থাৎ \"মায়ম ভূমি নুতুমতে সারিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","চিয়াচি দুরাং পুথিরে অল মেনা \"ইনিরা ডিপা উজাড়োকাআ, ইনারে তাহিনাকু এনকান যাহায় আলোকু তাহীনকাআ হেৎদ ইনিরা পালক রাঃআ গান্ডূ এটা যাহায়কে এম হুইওকাআ। ");
INSERT INTO cdz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","এন্তে, ইনা হুলাং যাকিৎ, চিমিন মাহা যীশু আবুয়া তালারে তাড়ম ভাড়ায় কেনায়, ইমিন মাহা হারহুলাং অকয় আবুলঅ সুতুঃ এমতাঃআকু, ");
INSERT INTO cdz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","যোহন রাঃআ ডুবুল হাতেন এহব কাতেন অকা হুলাং প্রভু যীশু কে আবুয়া হান্ডে হাতেন সেরমাতে রাকাব হুইয়া কানায়, নিকুয়া মিয়াৎ হড় আবুলঅ ইনি রাঃআ জিউৎ-রাকাব রাঃআ লুকুন্দী ী হুইওয়ায়, নিয়াটা অবশ্যই জরুড় তানা। ");
INSERT INTO cdz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ইন্তং ইঙ্কূ নিকিন বার হড়কে তিঙ্গুকেৎ কিনাকু, যোষেফ অকয়কে বার্শবা গামায়াকু, অকয় রাঃআ উপাধি যুষ্টতানা। ");
INSERT INTO cdz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","হেৎদ মত্তথিয়, হেৎদ ইঙ্কূ বিন্তি কেৎয়াকু, এ প্রভু আম যতচ রাঃআ অন্তর সারিয়াম, এন্তে নিকিন বার হড় রাঃআ তালারে অকয়কে বাছা তিয়াম ইনিকে উদুয়িইম। ");
INSERT INTO cdz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","যিহুদা নিজে রাঃআ থাংতে সেনঅ নাতিনাং নিয়া যে সেবা রাঃআ হেৎদ কুলিচ রাঃআ গান্ডূ আড়া গিডিতাৎ আয়, ইনি রাঃআ বদলতে গান্ডূ হাতা রাঃআ নাতিনাং উদুয়ালেম। ");
INSERT INTO cdz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","তায়মতে বার হড় রাঃআ নাতিনাং অন্দাজাহালাং কেৎয়াকু, হেৎদ মত্তথিয় রাঃআ নুতুমতে গুলিবাঁট নুরেনা, ইনাতে ইনি গেলে মিৎ কুলিচ কুলঅ সাথ এমকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","নিয়া তায়মতে ড়েলিমাহা হুলাং ইহুদি কুরাঃআ সাকরাত পরব ভোজ রাঃআ তায়ম সাকরাত মাহা কে সাকরাত রাঃআ মাহা গামেয়াকু। মাহা সেটেরানা, ইঙ্কূ যতচ মিৎ মনেতে, মিৎ থাংরে হুন্ডিয়েনন্তেকু বিন্তিরে তাহিনকেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ইন্তং আচকাগে নিরালা হাতেন কুঠিন জোরতে হয়অ রাঃআ সাডি লেকা সাডি হিচেনা, অকা অড়ারে ইঙ্কূ দুবলেনাকু, ইনা অড়া রাঃআ যত থাংরে ইনা পাসরায়না। ");
INSERT INTO cdz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","হেৎদ আলাং লেকা নেলতে এনকান গাদা সেঙ্গেলরাঃআ এলাং ইঙ্কূ নেল নামকেৎয়াকু হেৎদ ইনাকু ইঙ্কূ মিমিৎ কুরাঃআ চেতাংরে হিচ সেটেরেনা। ");
INSERT INTO cdz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ইনাতে ইঙ্কূ যতচ রীলামালা আত্মাতেকু পেরেজেনা হেৎদ আত্মা অকয়কে চিল্কা চিল্কা জাগারতে গামরাঃআ দাড়ি এমকেৎকুয়ায়্য়, এনকাগে ইঙ্কূ এটা এটা জাগারতে থুতি গাম এহব কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ইনা হুলাং যীরুশালেম শেহার রে বাসায়ান ইহুদিকু রাঃআ হেৎদ নিরালা রাঃআ লাতাররে মিমিৎ জাতি হাতেন হিচাকানা কু ঈশ্বর রাঃআ হড়, এনথাংরে তাহিন কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ইনা নানান হুনার জাগার আয়ুম কাতে এনথাংরে গাদাকু হুন্ডিনাকু হেৎদ ইঙ্কূ যতচ গে কুঠিন হায়কাটেনাকু, চিয়াচি যতচ ইঙ্কূ আপান আপিন রাঃআ জাগারতে ইঙ্কূয়া থুতি গাম আয়ুমকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ইন্তং যতচ কুঠিনগে হাহাড়া হেৎদ হায়কাটকাতে গাম লাগায়নাকু, নিকু যে হড়কু থুতি গামে তানাকু নিকু যতচ কি গালিলিয় রিঙ্কূ লহয় তানাকু? ");
INSERT INTO cdz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","এন্খান আবু চিল্কাতে আবুয়া নিজে মাই জাগার রাঃআ জাগারতে ইঙ্কূয়া থুতি গাম আয়ুম তাৎ কুয়াবু? ");
INSERT INTO cdz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","পার্থীয়, মাদীয় হেৎদ এলমীয় হড় হেৎদ মেসোপটেমিয়া, ইহুদিয়া মুলুক হেৎদ কাপ্পাদকিয়া, পন্ত হেৎদ এশিয়া মুলুক। ");
INSERT INTO cdz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ফুরুগিয়া হেৎদ পামফুলিয়া, মিশর হেৎদ লুবিয়া মুলুক রাঃআ কুরিনীয় রাঃআ কাতারে তাহিয়ান হেৎদ রোম শেহার মুলুক রিঙ্কূ বাসিন্দাকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ইহুদি হেৎদ ইহুদি ধরমরে ধরমাতাঙইচকু হেৎদ ক্রীতীয় হেৎদ আরব রিঙ্কূ বাসিন্দা যে আবু, যতচ আপান আপিন জাগারতে ঈশ্বর রাঃআ হাহাড়া হেৎদ বুগিন কামি রাঃআ থুতি ইঙ্কূয়া মচা হাতেন আয়ুম তাৎআবু। ");
INSERT INTO cdz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","নিয়া যত নেলকাতে ইঙ্কূ যতচ হাহাড়া হেৎদ বরকাতে মিহুড় এটাগিচ কে গাম লাগায়নায়, নিয়াকু রাঃআ মানে কিনা? ");
INSERT INTO cdz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","অট এটাকু লান্দাকাতে গাম লাগায়নাকু নিকু মাৎকম রাঃআ রস নুঃউ কাতে বুলাকানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ইন্তং পিতর গেলে মিৎ কুলিচকু লঅ তিঙ্গুয়েন্তে জোরতে কিকিচ কাতে ইঙ্কূয়া দিশা কাতে গামকেৎয়ায়্য়, এ ইহুদি হেৎদ যিরুশালেম শেহার রিঙ্কূ বাসিন্দাকু, আপেয়া নিয়া রাঃআ অর্থ সারি জরুর তানা, ইনাতে আপে ইঞা থুতি মনতে আয়ুমেপে। ");
INSERT INTO cdz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","চিয়াচি আপে কিনা আটকারে তানাপে ইনা দ লহয়, নিকু হড়কু যাহায় বুল-ভূতুড়াঙ লহয়, চিয়াচি নাহা এখেন সেতা বাসিয়ামা (নয় টাড়াঙ) কানা। ");
INSERT INTO cdz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","মেন্খান নিয়াটা ইনা ঘটনা তানা, অকা বাবত তে যোয়েল ভাবি জাগারিজ গামতাৎআয়, ");
INSERT INTO cdz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"মুচাৎ মাহা রে এনকা হুইওয়া, ঈশ্বর গামেয়ায়, ইঞ যতচ মান্মি রাঃআ চেতাংরে ইঞা আত্মা দুলেয়াইঞ, ইনাতে আপেয়া কড়াহন হেৎদ কুড়িহনকু ভাবি জাগার গামেয়াকু, আপেয়া জুয়ানকু ভেট নামেয়াকু হেৎদ আপেয়া হাড়াম-বুঢিকু হঅ কুকুমু নেলেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","অট ইনা হুলাংকুরে ইঞ ইঞা মুনিশ হেৎদ মুনিশ কুরাঃআ চেতাংরে ইঞা আত্মা দুলেয়াইঞ, হেৎদ ইঙ্কূ ভাবি জাগার গামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ইঞ নিরালা চেতাংরে নাআহানা আদভূত লক্ষণ হেৎদ লাতার ধার্তিরে নাআহানা চিহ্না, মায়ম, সেঙ্গেল হেৎদ শুকুলরাঃআ রিম্বিল উদুয়াপেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","প্রভু রাঃআ ইনা মাপরাং হেৎদ বিশেষ মাহা রাঃআ হিচু মাড়াঙতে বেলা নুম্বাগোআয় হেৎদ চাঁনডু মায়ম লেকা আরাচাবাআ। ");
INSERT INTO cdz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","হেৎদ এনকা হুইওয়া, যতচ অকয় প্রভু রাঃআ নুতুমতে রাঃআয়াকু, ইঙ্কূ রুক্ষীয়া নামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","এ খেরোয়াল রিঙ্কূ হড়কু নিয়া থুতি আয়ুমেপে। নাসরত রিনিজ যীশু হাহাড়া, পরাক্রম হেৎদ বুগিন কামিরাঃআ চিহ্না হরকাতে আপেয়া হান্ডে ঈশ্বর রাঃআ হাতেন প্রমাণিত মান্মি, ইনি রাঃআ মাধ্যমতে ঈশ্বর আপেয়া তালারে নিয়া যত কামি তাৎআয়, চিল্কা আপে যতচ সারিয়াপে, ");
INSERT INTO cdz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ইনিকে ঈশ্বর রাঃআ মাড়াঙ পরিকল্পনা লেনায় হেৎদ আকেল লেকাতে সম্পা হুইলেনায় হেৎদ আপে ইনিকে অধার্মিক কুরাঃআ দ্বারায়তে ত্রুশরে হাকা কাতে গয়চ লিয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ঈশ্বর গজঃঅ জ্বলান লাড়েচ কাতে ইনিকে গজঃঅ হাতেন রাকাব তিইআয়, চিয়াচি ইনিকে সাব দঃহঅ গজঅ রাঃআ সাধ্য কাঃআ তাহীনকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","চিয়াচি দায়ুদ রাপাজ ইনি রাঃআ বাবদতে গামতাৎআয় \"ইঞ প্রভুকে হার মাহা ইঞা সামাংরে নেলিকেনাইঞ, চিয়াচি ইনি ইঞা মান্ডি তিহি দররে মেনাইয়া, যেন ইঞ আলঞ আকা পাকা কাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","নিয়া নাতিনাং ইঞা মন কুশিআয় হেৎদ ইঞা আলাং সারাও মান্তেয়ায়, হেৎদ ইঞা হড়মোহঅ আশারে বাসাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","চিয়াচি আম ইঞা জিউ পাতাল পুরিরে কাম বাগি তুকায়া, হেৎদ নিজেরাঃআ রীলামালা হড়কে ক্ষয় কায় নেল দাড়িকুআয়। ");
INSERT INTO cdz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","আম ইঞকে জিউরাঃআ হরা উদুতিঞআম, আমা মেৎ মুহাড়তে ইঞকে কুশিতে পেরেজিঞাম। ");
INSERT INTO cdz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","হাগাইঞকু, ইনি মুশিঞ রিনিজ কূল হাপড়াম দাউদ রাপাজ রাঃআ বাবত তে ইঞ জোরকাতে গাম দাড়িআইঞ যে, ইনি গয়চাকানায় হেৎদ ইনিকে কবর এম হুইয়াকানায়, হেৎদ ইনি রাঃআ কবর তিহিঞ যাকিৎ আবুয়া তালারে (1 রাপাজ) ");
INSERT INTO cdz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","এন্তে, ইনি ভাবি জাগারিজ তাহিন কেনায় হেৎদ সারিকেনায়, ঈশ্বর দিব্যি কাতে নিয়া এক্ড়ার করালাৎ আয় যে, ইনি রাঃআ কূল রিনিজ মিহুড়কে ইনি রাঃআ কূলাসন রে দুবিআয়, ");
INSERT INTO cdz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","হেৎদ ইনি খ্রীষ্টরাঃআ গচ হাতেন জীউৎ রাঃআ বাবত তে নিয়া থুতি গামলাৎ আয় যে, ইনিকে পাতাল পুরিরে কায় বাগি তুকা কানায়, ইনি রাঃআ হড়মো কা শয়াআ। ");
INSERT INTO cdz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","নিই যীশু কেগে ঈশ্বর গয়চ হাতেন রাকাবতিয়ায়, আবু যতচ অকয় রাঃআ লুকুন্দী তানাবু। ");
INSERT INTO cdz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","এন্তে, আপে অকা নেলতাৎ আপে হেৎদ আয়ুমতাৎ আপে, ইনা নিয়াতানা, যে, ঈশ্বর রাঃআ মান্ডি তিহি দররে রাকাবঅ রাঃআ তায়মতে হেৎদ এক্ড়ার লেকাতে বাঃ রাঃআ হাতেন রীলামালা আত্মা আতাং হাতা তায়মতে, যিশু কে ইনি ইনা আইদারী দুল তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","চিয়াচি রাপাজ দাউদ সেরমাতে কায় রাকাবা কানায়, মেন্খান নিজে নিয়া থুতি গামতাৎআয় \"প্রভুঈশ্বর ইঞা প্রভু কে গামা কিয়াআ, আম ইঞা মান্ডি তিহি দররে দুবমে, ");
INSERT INTO cdz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","চিমিন ভুর ইঞ আমা বাইরিকুকে আমা কাটা দঃহ রাঃআ জায়গা কাইঞ বানহাআ। ");
INSERT INTO cdz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","খেরোয়ালকু রাঃআ যত কূল নিশ্চিত সারিপে যে, অকয়কে আপে ত্রুশরে হাকা লিয়াপে, ইনি যীশু কেগে ঈশ্বর প্রভু হেৎদ খ্রীষ্ট বারানকিন কেগে করাতিৎ ইয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","নিয়া থুতি আয়ুমকাতে ইঙ্কূয়া অন্তর কুঠিন আঘাত লাগায়না, হেৎদ ইঙ্কূ পিতর হেৎদ এটা কুলিচ কুকে গামকেৎ কুয়াকু \"বকইঞতালেয়াতুকু আলে কিনা চিকায়াআলে? ");
INSERT INTO cdz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ইন্তং পিতর ইঙ্কূকে গামাৎ কুয়ায়্য় য় \"আপে যতচ আপেয়া কাই ঈকা রাঃআ নাতিনাং মন পাল্টায়পে হেৎদ যীশু খ্রীষ্ট রাঃআ নুতুমতে ডুবুলোঅপে, এন্খান রীলামালা আত্মা রাঃআ ভর নামেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","চিয়াচি নিয়া এক্ড়ার আপে হেৎদ আপেয়া হন-হপনকুরাঃআ নাতিনাং হেৎদ অকয় সাঙ্গিনরে হেৎদ চিন্তি হড়কে প্রভু আবুয়া ঈশ্বর রাঃআ আউকুয়ায়্য়য়। ");
INSERT INTO cdz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","অটঃহঅ গাদা থুতি গামকাতে ইনি লুকুন্দী ী এমলাৎআয় হেৎদ ইঙ্কূকে কষামুদি কাতেন গামালাৎ কুয়ায়্য় য় \"নিয়া কাল রিঙ্কূ বাড়িচ হড়কু রাঃআ রেয়াজ হাতেন আপে নিজে কুকে রখেয়াকূপে। ");
INSERT INTO cdz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ইন্তং অকয় পিতর রাঃআ থুতি আয়ুম কেৎয়াকু, ইঙ্কূ ডুবুল হাতাকেৎয়াকু, ইনাতে ইনা হুলাং প্রায় আপি জুলু আত্মা ইঙ্কূলঅ পাতিয়ান কু লঅ মেশা খন্জায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","হেৎদ ইঙ্কূ কুলিচ কুরাঃআ চেচেদ হেৎদ সহভাগিতারে আকুয়া তালারে যতচ য়্য় হাটিং একেনাকু জম নু, পিঠা কেচারে হেৎদ বিন্তিরে মাহা পারমঅ কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ইন্তং যতচ রাঃআ ভিতাররে বরঅ বলয়নাঃ হেৎদ কুলিচ কু গাদা হাহাড়া কামি হেৎদ চিহ্না -কামি করায়কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","হেৎদ অকয় পাতিআয়নাকু, ইঙ্কূ যতআঃ মিশাতে দঃহয় কেনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","হেৎদ ইঙ্কূ ইঙ্কূয়া যত সম্পত্তি হেৎদ ঢিপা বাইত-ক্ষেত আখরিং কাতে, অকয় রাঃআ চিল্কা জরুর হুইওকেনা ইনিকে এনকা অর্থ এম হুইওকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","হেৎদ ইঙ্কূ মিৎ মনতে জাহের থান্তে সেনঃঅকেনাকু হেৎদ অড়ারে কুশিতে কেচা পিঠা জমেৎ কেনাকু হেৎদ কুশি লঅ হেৎদ উদার মনেতে জমা জমেৎ কেনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ইঙ্কূ ঈশ্বর রাঃআ গুনমানত য় কেনাকু হেৎদ ইনাতে যতচ হড় রাঃআ হান্ডে ইঙ্কূ দুলাড় রাঃআ পাত্র চিফ্না। হেৎদ অকয় রুক্ষীয়া নামেকেনাকু, প্রভু ইঙ্কূকে মন্ডলীরে জুড়াকেৎ কুয়ায়্য়য়। ");
INSERT INTO cdz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","মিৎ মাহা তারসিং আপি টাড়াং রে বাতিরাং বিন্তি হুলাং পিতর হেৎদ যোহন উপাসনা অড়াতে সেনঅ কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ইনা হুলাং হড়কু মিয়াৎ হড়কে গঃঅ কাতে আগুইকেনাকু। ইনি হড় মাইতেৎ রাঃআ হড়ম হাতেন লেংড়া গে জানাম লেনায়। ইনিকে যত মাহা জাহের থান্তেরাঃআ বুগিন নুতুমান মিয়াৎ দুয়ার কাতারে দঃহইকেনাকু, যাতে, জাহের থান্তেরে অকয় বলন উদুঙয়াকু, ইঙ্কূয়া হান্ডে হাতেৎ কাউডি কয় আসি দাড়িকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ইনি চিন্তং পিতর হেৎদ যোহন তিকিনকে জাহের থান্তেতে বলঃন তানাকিন নেলকেৎ কিনায়, ইন্তং ইঙ্কিনা হান্ডে কয় আসি কেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ইনাতে যোহন লঅ পিতর হঅ ইনি রাঃআ হান্তে মিৎ ঢেকতে কয়অ কিয়াকিনতে গামা কিয়াকিন, আলিংয়া হান্তে কয়অম। ");
INSERT INTO cdz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ইনাতে ইনি ইঙ্কিনা হান্তে কয়অ দঃঅকেয়ায় হেৎদ ইঙ্কিনা হান্ডে হাতেন হুডাং নামঃঅরাঃআ নাতিনাং তাঙ্গিই কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ইন্তং পিতর গামরুয়াড় কিয়ায় \"সোনা চি রুপা ইঞা হান্ডে বায়ায়না মেন্খান অকা মেনা ইনা আমকে এমাম তানাইঞ \"নাসরত রিনিজ যীশু খ্রিষ্ট রাঃআ নুতুমতে তাড়ম ভাড়াম দু। ");
INSERT INTO cdz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","তায়মতে পিতর ইনি রাঃআ মান্ডি তিহি সাবকেৎ তে তুলকিয়ায়, ইনাতে ইন্তংগে ইনি ককয় রাঃআ কাটা হেৎদ কাটারাঃআ এডি মুকড়ি-গাইট কেটেজেনা। ");
INSERT INTO cdz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","হেৎদ ইনি জেহেৎ কেৎতে তিঙ্গু বিরিদেনায় হেৎদ ইনি তাড়ম তাড়মতে, চিন্তং দ জেহেদ জেহেদতে হেৎদ ঈশ্বর রাঃআ মৌন জহার জহারতে ইঙ্কূ লঅ উপাসনা পিন্ডগীরে বলয়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","যত হড় চিন্তং ইনিকে তাড়ম হেৎদ ঈশ্বর রাঃআ মৌন জহার নেলকিয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ইন্তং ইঙ্কূ ইনিকে নেলকিয়তেকু চীনহা কিয়াকু যে নিইদ ইনি ককয় হড় তানায় অকয় জাহের থান্তেরাঃআ বুগিন নুতুমান দুয়াররে দুবকাতে কয় আসিৎ কেনায়, হেৎদ ইনি রাঃআ প্রতি নিয়া ঘটনা ঘটায়না খানঃঅ ইঙ্কূ কুঠিনগে চমকায় নাকু হেৎদ হায়কাটে নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","হেৎদ চিন্তং হড়কু কঃঅয়িজকে পিতর হেৎদ যোহন লঅ নেলকিয়াকু ইন্তং যতচ সাবাসিয়নাকু হেৎদ শলোমন রাঃআ নুতুমতে চিহ্না পিন্ডগিতে ইঙ্কূয়া হান্ডে নির হিচে নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","নিয়া যতচ কু নেল কেয়তে পিতরদ যতচ কে গামকেৎকুয়ায়্য়, এ খেরোয়াল রিঙ্কূ হড়কু নিই মান্মিরাঃআ বাবত তে চিয়া হাহাড়া তানাপে। হেৎদ আলিংগে আলিংয়া দাড়ি চি ভক্তি গুণতে নিইকে তাড়ম রাঃআ দাড়ি এমতিয়ালিং, নিয়া যত পাহাম কাতে চিয়া মিৎ ঢেকতে কয়অ তাৎ আপে। ");
INSERT INTO cdz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","আব্রাহাম হেৎদ ইসহাক হেৎদ যাকোব রাঃআ ঈশ্বর, আলেয়া আপুইঞ-হাড়াম-হাপাড়াম কুরাঃআ ঈশ্বর, আয়া বাদ্য হন ইনি যীশু কে মৌন গুনাত তিইযায়, অকয়কে আপে বাইরিকু রাঃআ তিহিরে দরবার রাঃআ নাতিনাং সম্পা লিয়াপে হেৎদ পিলাত চিন্তং ইনিকে আড়া নাতিনাং ফায়সালা হাতা লাৎআয়, ইন্তং ইনি রাঃআ সামাংরে আপে কাপে পাতিয়ালেনা। ");
INSERT INTO cdz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","আপে ইনি রীলামালা হেৎদ ধার্মিক হড়কে কাপে পাতিয়ালিয়া, হেৎদ পিলাত রাঃআ হান্ডে আপে নানাম লেনাপে ইনি রাঃআ বদলতে যেন আপেয়া নাতিনাং মিয়াৎ খুনিকে রেহাই এম কাআয়, ");
INSERT INTO cdz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","মেন্খান আপে জিউ রিনিজ সির্জন বাঃআকে গয়চ লিয়াপে, মেন্খান ঈশ্বর ইনিকে গয়চকু রাঃআ তালা হাতেন জিউৎ রাকাব তিয়ায়, আলে ইনি রাঃআ লুকুন্দী ী তানালে। ");
INSERT INTO cdz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","হেৎদ প্রভু রাঃআ নুতুমতে পাতিয়াকাতে নিই হড় দাড়ি বিডাকানায়, অকয়কে আপে নেল তিয়াপে হেৎদ চীনহাতিয়াপে, যীশু রে ইনি রাঃআ পাতিয়া তেগে আপেয়া যতচ মান্মি রাঃআ সামাংরে ইনিকে নিয়া পুরা বুগি এমা তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","নাহা, বকইঞকু, ইঞ সারিংইঞ যে আপে অআকেলতা লঅ নিয়া কামি করাতাৎ আপে, চিল্কা আপেয়া সর্দারকু করালাৎ আকু। ");
INSERT INTO cdz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","মেন্খান ঈশ্বর আয়া খ্রীষ্টরাঃআ দুঃখসাহারাঃআ বাবদতে অকা যত ভাবি জাগার যত ভাবি জাগারিজকু রাঃআ মচাতে মাড়াঙ সারি তুকা লাৎবুয়ায়, ইনা যত নাহা পুরাঃআ তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","এন্তে, আপে মন রুয়াড়েপে, হেৎদ রুয়াড় হিজুপে, যেন আপেয়া কাই যত মুছা/পুছা চাবায়কায়, যেন নেএ নেকালেকাতে ঈশ্বর রাঃআ হান্ডে হাতেন আত্মিক ঝিরা হিচু কাআ, ");
INSERT INTO cdz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","হেৎদ আপেয়া নাতিনাং মাড়াঙ নির্ধারিত খ্রীষ্ট যীশু কে নিরুপণ/বাহাল তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","হেৎদ ইনি হানিতানায়, অকয়কে সেরমা নিশ্চয়ই গ্রহণকাতে দঃহইয়ায়, চিমিন ভুর যাকিৎ যত বাবত রাঃআ অটঅগে থাপনারাঃআ মাহা কা সেটেরোয়া, অকা মাহা রাঃআ বাবদতে ঈশ্বর আয়া রীলামালা ভাবি জাগারিজকুরাঃআ মচাতে গামতাৎআয়, অকা মুশিংকাল হাতেন হুই হিখড়ম না। ");
INSERT INTO cdz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","মোশি মা গামলাৎ আয় \"ঈশ্বর আপেয়া নাতিনাং আপেয়া বকমকুরাঃআ তালা হাতেন ইঞা লেকানিজ মিয়াৎ ভাবি জাগারিজকে রাকাবিয়ায়, ইনি আপেয়া অকা অকা গামাপেয়ায়, ইনা যত বাবত তে আপে যতচ আয়ুমেপে, ");
INSERT INTO cdz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","হেৎদ নাহা হুইওয়া যে, অকয় নিকু ভাবি জাগারিজ কু রাঃআ থুতি কাকু আয়ুমেয়া, ইনি মান্মিকু রাঃআ তালা হাতেন নাশআয়। ");
INSERT INTO cdz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","হেৎদ শামূয়েল হেৎদ ইনি রাঃআ তায়মতে চিমিন হড় ভাবি জাগারিজ জাগারতাৎ আকু, ইঙ্কূহঅ যতচ নিয়া মাহা রাঃআ জাগারতাৎ আকু। ");
INSERT INTO cdz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","আপে ইঙ্কূ ভাবিজাগারিজ কুরাঃআ হেৎদ ইনা আরিচালি রাঃআ হঅ হনহপন তানাপে, অকা ঈশ্বর আপেয়া আপুম-বুঢামকু লঅ এক্ড়ার লাৎ আয়, ইনি চিল্কা আব্রাহামকে গামালিয়ায় \"আমা কূল হাতেন ধার্তি রিঙ্কূ যত পরিবার আশীষ নামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ঈশ্বর নিজে রাঃআ বাদ্য হন কে জানাম কিয়ায় হেৎদ মাড়াঙতেগে ইনিকে আপেয়া হান্ডে কুলকিয়ায়, যাতে ইনি আপে যতচ কে যত অধর্ম হাতেন রুয়াড় কাতে যীশু রাঃআ দ্বারায়তে আপেকে আশীষ পেযায়। ");
INSERT INTO cdz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","চিন্তং পিতর হেৎদ যোহন হড়কু রাঃআ হান্ডে থুতিকেনাকিন গটা ইনা হুলাং মারাং মীদুন রিঙ্কূ বামড়েকু হেৎদ জাহের থান্তে রিঙ্কূ হরয়ান কু রাঃআ বহঃ কু হেৎদ সদ্দুকিকু ঘিড়মেন্তাং ইঙ্কিনা হান্ডে হিচ সেটেরেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ইঙ্কিন গাহির এটকেটরেৎ রে নুরলেনাকিন চিয়াচি ইঙ্কিন হড়কুকে উপদেশ এমকেনা কুয়াকিন হেৎদ যীশু যে গয়চ কু রাঃআ তালা হাতেন জীউৎ রাকাবা কানায় ইনা পাসনাৎ কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","হেৎদ ইঙ্কূ ইঙ্কিন কে সাবকেৎ কিনকুতে গাপা হুলাং যাকিৎ আটকা দঃহঅ লাৎ কিনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","চিয়াচি ইন্তং আয়ুব চাবালেনা, তুবুই রহঅ অকয় জাগার আয়ুমেৎ কেনাকু ইঙ্কূয়া তালারে গাদাকু পাতিয়ায়না, ইঙ্কূয়া তালারে কড়াহন কু রাঃআ গুঁডুর হুডাংঢের মড়ে জুলু লেকা তাহিলেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","গাপা হুলাং হড়কু রাঃআ শাসককু, মুরুব্বিকু হেৎদ চেচেদিজ গমকেকু যিরুশালেম শেহার রে হুন্ডিলেনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","হেৎদ হানন মারাং বামড়ে, কায়াফা, যোহন, আলেকসান্দর হেৎদ মারাং বামড়ে রাঃআ হড়কু হাজির তাহিলেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ইঙ্কূ ইঙ্কিন পিতর হেৎদ যহন কে তালা মাঙ্গারে তিঙ্গুকেৎ কিনাকুতে কুলিকেৎ কিনাকু কিনা দাড়ীয়ানতে চি অকয় রাঃআ নুতুমতে আবেন নিয়া কামি করায়তানা বেন? ");
INSERT INTO cdz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ইন্তং পিতর রীলামালা আত্মাতে পেরেজেন্তে ইঙ্কূকে গামলাৎ কুয়ায়্য় য় এ মান্মিকুরাঃআ শাসককু হেৎদ মুরুব্বিকু, ");
INSERT INTO cdz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","মিয়াৎ কাহিলাকান হড়রাঃআ উপকার করা নাতিনাং যদি তিহিঞ আলিঞকে কুলি তানাপে চিল্কাতে নিই হড়টাকে বুগিনায়, ");
INSERT INTO cdz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","এন্খান আপে যতচ হেৎদ যত খেরোয়াল হড়কু নিয়া সারি কাআকু যে, নাসরত রিনিজ যীশু খ্রীষ্ট রাঃআ নুতুমতে অকয়কে আপে ত্রুশরে এমলিয়াপে, অকয়কে ঈশ্বর গয়চকু রাঃআ তালা হাতেন জিউৎ রাকাব লিয়ায়, ইনি রাঃআ নুতুম গুণতেগে নিই হড় আপেয়া হান্ডে বুগিন হড়মোতে তিঙ্গু মেনাইয়া। ");
INSERT INTO cdz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ইনি ইনা দিরিতানা অকাটা কারিগরি মিস্ত্রীকু যে আপেতানা আপেয়া দ্বারায়তেগে কায় ছুতাংলেনায়, অকাদ কোণ রাঃআ বঃহঅ দিরি হুইয়েনা ");
INSERT INTO cdz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","অট এটা যাহায় রাঃআ হান্ডে রুক্ষীয়া বায়ায়না, চিয়াচি নিরালা রাঃআ লাতাররে হেৎদ মান্মিকু রাঃআ তালারে এমাআ কানা এনকান অট যাহায় রাঃআ নুতুম বায়ায়না অকা নুতুমতে আবু রুক্ষীয়া নাম দাড়িয়াবু। ");
INSERT INTO cdz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ইনা হুলাং খেরয়াল কুরা আ গম্কেকু পিতর হেৎদ যোহন রাঃআ সাহস নেলকেৎ তেকু হেৎদ নিকিন যে বিন অল ফড়া নিরহ হড়তানা কিন নিয়া নেলকেৎতেকু হায় কাটেনা কু হেৎদ চিহ্না নামকেৎ কিনাকু যে নিকিন যীশু লঅ তাহিন কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","হেৎদ ইনি বুগিন হড়টা ইঙ্কিন লঅ তিঙ্গুয়া কানায় নেলকিচ তেকু ইঙ্কূ দরবার রে ইঙ্কিনা বিরুধতে যাহানা কাকু গাম দাড়িলাৎ আ। ");
INSERT INTO cdz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","মেন্খান ইঙ্কূ কুলিচ কুরাঃআ দরবার কুঠুরি হাতেন বাহারতে সেনঅ হুকুমকেৎ কিনাকু হেৎদ নিজে রাঃআ তালারে থুতি জাগার লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","যে নিকিন হড়কিনকে ইদিকাতে কিনা চিকা হয়য়া? চিয়াচি ইঙ্কিন অকা হাহাড়া কামি করালাৎ আকিন ইনা যিরুশালেম শেহার রিঙ্কূ হড়কু সারিনাম লাৎ আকু, আবু ইনা কাবু পাতিয়া দাড়িয়া ইঙ্কা দ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","মেন্খান নিয়া থুতি যেন হড়কুরাঃআ তালারে আল পাসরাকাআ, ইনাতে ইঙ্কূ ইঙ্কিন কে বরঅ ধমকাকেৎ কিনাকুতে গামকেৎ কিনাকু ইঙ্কিন যেন যীশু নুতুমতে যাহায়কে যাহানা আল কিন গামকুকা। ");
INSERT INTO cdz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ইনাতে ইঙ্কূ পিতর হেৎদ যোহনকে ভীতিরতে রাঃআকেৎ কিনাকু হেৎদ ইঙ্কিন কে আদেশকেৎ কিনাকু যাহায়কে যেন যাহানা আল গামকুকাকিন হেৎদ যীশু রাঃআ নুতুমতে চেচেদ আল এমকুকাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","পিতর হেৎদ যোহন উত্তর এমকাতে ইঙ্কূকে গামকেৎ কুয়াকিন \"ঈশ্বর রাঃআ থুতি বাগিকাতে আপেয়া থুতি আয়ুম ঈশ্বর রাঃআ নজররে লাক্তি চি লহয় আপেগে দরবারপে। ");
INSERT INTO cdz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","মেন্খান অকা আলিং নেলতাৎ আ হেৎদ আয়ুমতাৎ আ ইনা কা গামকাতে তাহি কালিং দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","তায়মতে ইঙ্কূ দরবার রিঙ্কু বহঃকু পিতর হেৎদ যোহনকে অটঃহঅ বর দেখাকাতে আড়াকেৎ কিনাকু। চিয়াচি হড়রাঃআ বরতে ইঙ্কিন কে সাজা এমরাঃআ কাকু নামলাৎ আ চিয়াচি অকা করা হুইলেনা ইনা নাতিনাং হড় ঈশ্বর রাঃআ গৌনজহারে কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","অকা হড় নিয়া হাহাড়া কামিরাঃআ দ্বারায়তে বুগিলেনায় ইনি হুডাংঢের পুলি সির্মাং রাঃআ চেতাংরে তাহিলেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ইঙ্কিন কে আড়া গিডি রাঃআ তায়ম ইঙ্কিন আকিনা গাতি কু রাঃআ হান্ডে সেনেএ নাকিন হেৎদ মারাং বামড়ে হেৎদ মুরুব্বিকু ইঙ্কিন কে অকা থুতি গামালাৎ কিনাকু ইনা ইঙ্কূকে সারি তুকাকেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","চিন্তং ইঙ্কূ নিয়া থুতি আয়ুমেৎ কেনাকু ইঙ্কূ মিশাতে কুঠিন জোর কিকিচ কাতে ঈশ্বর রাঃআ নাতিনাং গামেৎ কেনাকু, প্রভু আম অকয় সেরমা পুরি, ধার্তি, দরেয়া হেৎদ ইনা রাঃআ তালারে অকাগে মেনা যতচ রাঃআগে সির্জন বাঃআ। ");
INSERT INTO cdz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","আম আমা মুনিশ আলেয়া হাপড়াম দাউদরাঃআ মচা হাতেন রীলামালা আত্মারাঃআ দ্বারায়তে জাগার তাৎ আম চিল্কা বিনইহুদিকু চিয়া হুইহুল্লাকেৎয়াকু ? হড়কু চিয়া বেকার বাবত তে ধ্যান কেৎয়াকু ? ");
INSERT INTO cdz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ধার্তি রিঙ্কূ রাপাজ কু মিশাতে তিঙ্গুইনাকু, শাসককু মিৎ থাংরে হুন্ডিইনাকু প্রভু রাঃআ বিরুধরে হেৎদ ইনি রাঃআ আভিষিক্ত খ্রীষ্টরাঃআ বিরুধরে, ");
INSERT INTO cdz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","চিয়াচি সার্তি যীশু অকয় আমা রীলামালা হন অকয়কে আম আভিষিক্ত তিয়াম, ইনি রাঃআ বিরুধরে হেরোদ (অন্তিওপা) হেৎদ পন্তীয় পিলাত বিনইহুদিকুরাঃআ হঅ হেৎদ খেরোয়াল হড়কু লঅ মেশা লেনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","যেন আমা তিহিরাঃআ হেৎদ আমা আকেল রাঃআ দ্বারায়তে মাড়াঙ অকা যত বাবত গটা হুইলেনা ইনা পুরাঃআ তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","হেৎদ নাহা হে প্রভু, ইঙ্কূয়া বরঃঅ প্রভেট রাঃআ (বরঃঅয়ান রাঃআ) হান্তে নেলেম, হেৎদ আমা নিকু মুনিশ কুকে কুঠিন সাহসলঅ আমা জাগার গামরাঃআ দাড়ি এমকুম, রোগ বুগিকা ইনা আশীষাকুম, ");
INSERT INTO cdz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","হেৎদ আমা রীলামালা হন যীশু রাঃআ নুতুমতে যেন চিহ্না হেৎদ হাহাড়া কামি পুরাঃআ কাআ। ");
INSERT INTO cdz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ইঙ্কূ কথাংরে বিন্তিই কেনাকু ইনা ঘাড়িগে এনথাংরে থারথারা রাকাবেনা হেৎদ ইঙ্কূ যতচ রীলামালা আত্মাতে পেরেজেনাকু হেৎদ সাহসতে ঈশ্বর রাঃআ জাগার পাসনা লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","অটঅ যে গাদা হড় অকয় পাতিয়া লেনাকু, ইঙ্কূ মিৎ অন্তর হেৎদ মিৎ মনে রিঙ্কূ পাতিয়ান তাহিনকেনাকু, ইঙ্কূয়া মিহুড়হঅ নিজের সম্পত্তিরাঃআ যাহানা নিজেরাঃআ কায় গামেকেনায়, মেন্খান ইঙ্কূয়া যতচয়া যতচ হড়কু রাঃআ তাহিন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","হেৎদ কুলিচ কু কুঠিন ক্ষমতাতে প্রভু যীশু রাঃআ জীউৎ রুয়াড় বাবত তে লুকুন্দী এমেকেনাকু হেৎদ ইঙ্কূ যতচ রাঃআ চেতাংরে বহুত দায়া-দুলাড় তাহিন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","এমনকি ইঙ্কূয়া তালারে যাহায় রেঙ্গেজ কাকু তাহিলেনা, চিয়াচি অকয় বাইত বাংখানদ অড়া দুয়ার রিঙ্কূ হাকদারি তাহিন কেনাকু, ইঙ্কূ ইনা আখরিং কাতে সম্পতি রাঃআ কাউডি আগুই কেনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","হেৎদ ইঙ্কূ কুলিচ কুরাঃআ কাটা রাঃআ কাতারে দঃহয় কেনাকু, তায়মতে অকয় রাঃআ চিল্কা জরুর ইনিকে এনকা এমঅ হুইওকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","হেৎদ যোষেফ অকয়কে কুলিচ কু বার্ণবা নুতুম এমলিয়াকু অনুবাদ লেংখান নিয়া নুতুম রাঃআ মানে উৎসাহএমিজ, অকয় লেবিয় হেৎদ ইনি হড় অকয় কুপ্র ঢিপ রে তাহিনায়, ");
INSERT INTO cdz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ইনি রাঃআ ইতিজ তরাং বাইত তাহিনকেনা, ইনি ইনা আখরিং কাতে ইনারাঃআ কাউডি আগুকাতে কুলিচ কুরাঃআ কাটারে দঃহকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","অননিয় নুতুমতে মিয়াৎ পাতিয়ান হড় তাহীনকেনায় হেৎদ ইনি রাঃআ বাহুতেৎ সাফেরা মিয়াৎ বাইত আখরিং কেৎয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","হেৎদ ইনি ইনা আখরিং কাউডি হাতেৎ হুডাং লেকা অকিনা আ নাতিনাং অকিনাআ হান্ডে কাউডি দঃহ কেয়ায় হেৎদ বাড়তি কাউডি কুলিচ কু রাঃআ হান্ডে এমকেয়ায়, নিয়া বাবত তে ইনি রাঃআ এরাতেৎ হঅ সারিকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ইন্তং পিতর ইনিকে গামা কিয়ায়, অননিয় আমা আত্মা রে চিয়া শয়তানকে কামি এমকিয়াম যে রীলামালা আত্মা রাঃআ হান্ডে বেদা জাগার কেৎয়াম হেৎদ বাইত রাঃআ আখরিং কাউডি হাতেন কথক কাউডি নিজে রাঃআ হান্ডে দঃহ কেয়াম? ");
INSERT INTO cdz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","বাইতটা আখরিং রাঃআ মাড়াঙতে নিয়া কি আমা কা তাহিলেনা? হেৎদ আখরিং রাঃআ তায়মতেহঅ কি আমা অধিকাররে কা তাহিলেনা? এন্খান আম চিল্কাতে নিয়া জিনিসকু আমা অন্তররে ভরা কেৎয়াম ? আম মান্মি রাঃআ হান্ডে বেদা গামকেয়াম ইনাদ লহয়, মেন্খান ঈশ্বর কেগে বেদা গামাকিয়াম। ");
INSERT INTO cdz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","অননিয় নিয়া যত আয়ুম কেৎতে নুরকাতে গজেনায়। হেৎদ অকয় আয়ুম কেৎয়াকু ইঙ্কূ কুঠিন বরঅ কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","কথক জুয়ান কড়া হন কু হিচে নাকু হেৎদ ইনিকে কিচিতে পটম কিয়াকু হেৎদ বাহারতে ইদি কিচতেকু তপা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","প্রায় আপি টাড়াং তায়ম, ইনি রাঃআ এরাতেদ হিচ লেনায় মেন্খান ইনি কায় সারিকেনায় কিনা হুইয়াকানা আয়ায়্য় হিজু মাড়াঙতে ");
INSERT INTO cdz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","পিতর ইনিকে কুলি কিয়ায় \"ইঞকে গামাইঞমে, আবেন ইনা বাইত চি কিনাআ নিন্তি কাউডিতে আখরিং লাৎআবেন? ইনি গাম রুয়াড় কেয়ায় \"হে, নিন্তি কাউডি তেগে। ");
INSERT INTO cdz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ইনা তায়ম পিতর ইনিকে গামা কিয়ায় \"আবেন প্রভু রাঃআ আত্মাকে বিডা নাতিনাং চিল্কাতে মিৎ মনে নাবেন? নেলেম, অকয়কু আমা হেরেল তামাকে তপা কাতে হিচাকানা, ইঙ্কূ দুয়াররে হিচা কাতে তিগুয়া কানাকু হেৎদ আমকে হঅ তপা ইদি মেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","তুক্ষনি গে সাফেরা পিতর রাঃআ কাটা কাতা অতেরে নুর কাতে গজেনায়। হেৎদ জুয়ানকু ভীতির হিচ কাতে নেলকিয়াকু, ইনিদ গজা কানায়, ইঙ্কূ ইনিকে বাহারতে ইদিকিয়াকু হেৎদ ইনি রাঃআ হেরেল তেৎ রাঃআ কাতারে তপা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","গোটা মন্ডলী হেৎদ অকয় নিয়া জাগার আয়ুম কেৎয়াকু যতচ কুঠিন বরয়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","কুলিচ কুরাঃআ হরকাতে গাদা চিহ্ন-কামি হেৎদ হাহাড়া কামি পুরা হুইও লাগায়না। ইঙ্কূ যতচ মিৎ মনেতে শলোমন রাঃআ পিন্ডগীরে হুন্ডিই নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","অকয় ইঙ্কূকে কাকু পাতিয়াৎ কু কেনা, ইঙ্কূ যত হড়কু ইঙ্কূ লঅ গাতিতে কাকু সাহসেৎ কেনা, মেন্খান ইনা সত্বে হঅ হড়কু ইঙ্কূকে যথা যথ মৌন এমা তাৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","হেৎদ গাদেল গাদেল গাদা কড়াহন হেৎদ কুড়িহন প্রভু যীশু রে পাতিয়া কাতে ইঙ্কূ লঅ মেশায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","এমনকি হড়কু রুয়া-হাসু বেরাম কুকে ইদিকাতে হরা রাঃআ তালারে পাটি রে হেৎদ পারখমরে গিতিজ গিডিকেনা কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","যিরুশালেম শেহার রাঃআ চারুধার নাডে হান্ডে রাঃআ শেহার রিঙ্কূ হাতেন গাদা হড় রুয়া-হাসু হেৎদ চুত আত্মাতে নামাকানা হড়কুকে ইদিকাতে হুন্ডিকেনাকু হেৎদ ইঙ বুগিকেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","তায়মতে মারাং বামড়ে হেৎদ ইনি রাঃআ গাতিকু অর্থাৎ সদ্দূকী সম্প্রদায় রিঙ্কূ হড়কু কুলিচ কুরাঃআ নাতিনাং ষা তে পেরেজচায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","হেৎদ কুলিচ কুকে স্যাপ কাতে মামুলি জিহাল রে হান্ডেতকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","মেন্খান আয়ুব বাতিরাং প্রভু রাঃআ মিয়াৎ সরগ নাঙ্গা হিচ কাতে জিহাল অড়ারাঃআ দুয়ার নিজকেয়ায় হেৎদ কুলিচ কুকে বাহারতে উডুঙ আউকেৎ কুয়ায়্য় হেৎদ গামকেৎ কুয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"সেনঃঅপে, রুমঅ অড়া রাঃআ তালারে তিঙ্গুকাতে নিয়া নামা জিউরাঃআ যত জাগার হড়কুকে গামাকূপে। ");
INSERT INTO cdz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","নিয়া যত আয়ুম তায়ম কুলিচ কু ভোর বাতিরাং উপাসনা অড়ারে সেনকাতে উপদেশ এম লাগায় নাকু। ইনা তালরে, মারাং বামড়ে হেৎদ ইনি রাঃআ গাতিকু, খেরোয়াল রিঙ্কূ হড়কুরাঃআ মানাগুনা মুরুব্বি হড়কুকে ইদিকাতে মিয়াৎ মারাং দরবার রাঃআকেৎয়াকু হেৎদ কুলিচ কুকে আউ নাতিনাং হড় কুলকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","মেন্খান চিন্তং ইঙ্কূ আধিকারিককু জিহাল অড়ারে সেটেরেনাকু, ইঙ্কূ নেলকেৎয়াকু কুলিচ কু এনথাংরে বানুকুয়া, এন্তে ইঙ্কূ রুয়ার হিচে নাকু হেৎদ নিয়া বার্তা এমকেৎ কুয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","\"আলে নেলকেয়ালে জিহাল অড়া রাঃআ দুয়ার রেনঢেত কাতে হান্ডেত মেনা হেৎদ দুয়ার দুয়াররে হর কু তিঙ্গু মেনাকুয়া, মেন্খান চিন্তং আলে দুয়ার হলেজকাতে ভিতারতে সেনেনালে যাহায়কে কালে নেলনামলাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ইন্তং উপাসনা অড়ারাঃআ রক্ষীয়া পাল্টন রিনিজ বহঃঅ হেৎদ মারাং বামড়েকু নিয়া থুতি আয়ুমকেৎ তেকু হায় কাটেন্তে পাহাম লাগায়নাকু, নিয়ারাঃআ হাল কিনা হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ইনা তায়্ম যাহায় মিহুড় হড় হিচেনায় হেৎদ ইঙ্কূকে গামকেৎ কুয়ায়্য় \"আয়ুমেপে, অকা হড়কুকে আপে জিহাল অড়ারে দঃলাৎ কুয়াপে ইঙ জাহের থান্তেরে তিঙ্গুকাতে হড়কুকে বাৎলাৎ কুয়াকু\" ");
INSERT INTO cdz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ইন্তং উপাসনা অড়া রিঙ্কূ রক্ষীয়া পাল্টন রিনিজ মারাং পাল্টনা আয়া সেনা কুকে ইদিকাতে এনথাংতে সেনেনায় হেৎদ কুলিচ কুকে আউ ধরা কেৎকুয়ায়্য় মেন্খান ইঙ্কূ যাহানা কাকু জোর লাৎ কুয়া, চিয়াচি ইঙ্কূ হড়কুকে বরঃঅ কেনাকুয়াকু যে হড়কু হুই দাড়িয়া ইঙ্কূকে দিরি লেব্দাকাতে গয়চ দাড়িকুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","তায়মতে ইঙ্কূ কুলিচ কুকে মারাং দরবার রে আউকেৎ কুয়াতে তিঙ্গুকেৎ কুয়াকু, মারাং বামড়ে কুলিচ কুকে কুলিকেৎ কুয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","গামাকেৎ কুয়ায়্য় \"আলে যীশু রাঃআ নুতুমতে চেচেদ কা এম নাতিনাং কেটেজ লেকাতে হুকুম এমলাৎ পেয়ালে, ইনা সত্বেহঅ নেলেপে, আপে আপেয়া চেচেদতে যিরুশালেম শেহার পেরেজচাআতাৎ পে হেৎদ ইনি হড়রাঃআ মায়মরাঃআ দায়তে আলেকে দোষী নানামতানাপে। ");
INSERT INTO cdz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","মেন্খান পিতর হেৎদ এটা কুলিচ কু গামকেৎয়াকু \"আলেকে মান্মি রাঃআ হাতেন বরঞ্চ ঈশ্বর রাঃআ হুকুম মানাবাতা হুইওয়া! ");
INSERT INTO cdz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","আলেয়া আপুইঞ -বুঢাইঞ কুরাঃআ ঈশ্বর ইনি যীশু কে জীউৎ রাকাবতিয়ায়, অকয়কে আপে ত্রুশরে হাকাকাতে গয়চলিয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ঈশ্বর যীশু কেগে রাপাজ হন হেৎদ রুক্ষীয়া ইজ লেকাতে বাহালকাতে ইনি রাঃআ মান্ডি তিহি দররে দুপ তিয়ায়, যেন খেরোয়াল কুরাঃআ মন পাল্টা হেৎদ কাই রাঃআ ছেমা দানকুকায়। ");
INSERT INTO cdz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","নিয়া যত বাবত রাঃআ আলেহঅ লুকুন্দী ী হেৎদ রীলামালা আত্মাহঅ লুকুন্দী ী, অকা আত্মা ঈশ্বর আয়াআ হুকুম বহানকুকে এমতাৎ কুয়ায়্য় য়\" ");
INSERT INTO cdz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","নিয়া থুতি আয়ুমকাতে ইঙ্কূ রাগাতে কষকষ চায়নাকু হেৎদ কুলিচ কুকে গচ রাঃআ নাতিনাং গটা কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","মেন্খান মারাং দরবার গমলিয়েল নুতুমতে মিয়াৎ ফরিশী তাহীন কেনায়, ইনি আরিচালি রিনিজ গুরু তানায়, অকয়কে হড়কু মানাইকেনা, ইনি বিরিদেনায় হেৎদ কুলিচ কুকে হুডাং ঘাড়ি রাঃআ নাতিনাং বাহারতে ইদিরাঃআ হুকুম কেৎকুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","তায়মতে পাহারাদারকু কুলিচ কুকে বাহারতে ইদিরাঃআ তায়মতে, ইনি গাম কেৎ কুয়ায়্য় \"এ, খেরোয়াল রিঙ্কূ হড়কু, আপে ইঙ্কূ হড়কুকে ইদিকাতে কিনা করা বুঝাপে তানা পেয়া, ইনা বাবত তে চিন্তা-ভাবনায়পে। ");
INSERT INTO cdz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ইনা মাড়াঙতে থুদা নুতুমতে মিহুড় নিজেকে মারাং মেন্তে দাবিলিয়ায় হেৎদ হুডাংঢের চারশো জন হড় ইনি লঅ মেশালেনাকু, ইনি গয়চরাঃআ তায়ম ইনি রাঃআ সুতুয়ানকু যত ছিতি বিতিই নাকু, যাহায় কাকু তাহিলেনা। ");
INSERT INTO cdz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ইনি হড়রাঃআ তায়মতে হড় লেখা হুলাং গালিলিয় যিহুদা রাকাবেনায় হেৎদ কথক হড়কে নিজেরাঃআ দলরে অরকেৎকুয়ায়্য়, তায়মতে ইনিহঅ গয়চেনায়, হেৎদ ইনি রাঃআ সুতুয়ানকু পাসরায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","নাহা দ ইঞ আপেকে গামাপে তানাইঞ, আপে ইঙ্কূ হড় কুরাঃআ হান্ডে হাতেন সাঙ্গিনরে তাহিনোপে হেৎদ ইঙ্কূকে আড়াঃ গিডিকুপে, যদি নিয়া মন্ত্র চি কামি মান্মিরাঃআ হান্ডে হাতেন উডুঙওয়া, এন্খান ইনা বেকারচাবাআ। ");
INSERT INTO cdz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","মেন্খান যদি ঈশ্বর রাঃআ হাতেন হুইওয়া, এন্খান ইঙ্কূকে থাম্বা আপেয়া লিয়া সম্ভব লহয়, হয়তো নেল নামোয়া যে, আপে ঈশ্বর রাঃআ বিরুধরে লাড়হাই তানাপে। ");
INSERT INTO cdz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ইন্তং ইঙ্কূ গমলিয়েলরাঃআ জাগারতে মিৎ মতেনাকু, হেৎদ কুলিচ কুকে রাঃআ আউকাতে দাদালকেৎ কুয়াকু হেৎদ যীশু রাঃআ নুতুমতে যাহানা থুতি আলকু গামেকা মেন্তে হুকুম কেৎ কুয়াকু হেৎদ ইঙ্কূ আড়াকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ইন্তং কুলিচ কু মারাং দরবার হাতেন কুশি কুশিতে সেনেনাকু, চিয়াচি ইঙ্কূ যীশু রাঃআ নুতুমরাঃআ নাতিনাং অপমান হুইওরাঃআ যোগ্য় মেন্তে বাহাললেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ইনা তায়মতে যত মাহা, কুলিচ কু রুমঅ অড়ারে হেৎদ অড়া অড়ারে লাগাতার যীশু খ্রীষ্ট রাঃআ বুগিন বার্তা পাস্না লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","হেৎদ ইনা হুলাংকুরে, চিন্তং চেলাকু রাঃআ গুঁডুর বাড়তি ইদিৎ কেনাকু, ইন্তং গ্রীক জাগারতে থুতিয়ান পাতিয়ান কু ইব্রীয় জাগারতে থুতিয়ান পাতিয়ান কু রাঃআ বিরুধরে নিপিয়ায় লাগায়নাকু, চিয়াচি মিৎ- মিৎ মাহা রাঃআ জোমা রাঃআ হাটিং হাতেন ইঙ্কূয়া রান্ডি বুঢিকু বাদঅ কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ইন্তং ইঙ্কূ বারজন (কুলিচ) চেলাকুকে ঠাইনতে রাঃআ কেৎ কুয়াকুতে গামাৎ কুয়াকু, আলে যে ঈশ্বর রাঃআ জাগার বাগিকাতে জমা আড়তি তানালে, ইনাদ গটা লহয়। ");
INSERT INTO cdz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","মেন্খান দুলাড়িয়া বকইঞ কু, আপে আপেয়া তালা হাতেন নুতুমান হেৎদ আত্মাতে হেৎদ আকেলতে পেরেজাকান সতি হড় কে বাছাকূপে, ইঙ্কূকে আলে নিয়া কামিরাঃআ ভারাজনা এমাকুয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","মেন্খান আলে বিন্তিরে হেৎদ ইনি রাঃআ জাগার সেবারে বহাল তাহিনালে। ");
INSERT INTO cdz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","নিয়া থুতিতে যতচ হড় কুশিনাকু, হেৎদ নিকু কথককে বাছাকেৎ কুয়াকু, স্তিফান নিই হড় পাতিয়ারে হেৎদ রীলামালা আত্মারে পেরেজ তাহিলেনায়, হেৎদ ফিলিপ, প্রখর, নিকানর, তিমোন, পার্মিনা, হেৎদ নিকলয়, ইনি আন্তিয়খিয়া রিনিজ ধর্ম পাল্টায়াকান পাতিয়ানিচ; ");
INSERT INTO cdz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ইঙ্কূ নিকুকে কুলিচ কুরাঃআ সামাংরে দড়মকেৎ কুয়াকু হেৎদ ইঙ্কূ ইঙ্কূয়া বঃহঅরে তিহি দঃহকাতে বিন্তিকেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","হেৎদ ঈশ্বর রাঃআ জাগার পাসরা ইমাএনা হেৎদ যিরুসালেমরে চেলা কুরাঃআ সংখ্যা বাড়তি ইদিএনাকু, হেৎদ বামড়ে কুরাঃআ তালারে গাদা হড় পাতিয়ায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","হেৎদ স্তিফান দায়া-দুলাড়তে হেৎদ দাড়িতে পেরেজেন্তে হড়কুরাঃআ তালারে গাদা হাহাড়া লক্ষণ হেৎদ চিহ্না -কামি করা লাগায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","মেন্খান অকাকে লিবর্ত্তিনি কুরাঃআ সমাজ অড়া গামেয়াকু, ইনা রাঃআ কথক হড় হেৎদ কুরিনিয় হেৎদ আলেকসান্দ্রিয় শেহার রিঙ্কূ হড়কু হেৎদ কিলিকিয়া হেৎদ এশিয়া মুলুক টলারাঃআ কথক হড় বিরিদেন্তেকু স্তিফান লঅ তর্ক বিতর্ক লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","মেন্খান ইনি অকা আকেল হেৎদ রিলামালা আত্মা রাঃআ দাড়িতে থুতি জাগারেৎ কেনায়, ইনা রাঃআ বিরুধ রাঃআ ক্ষমতা ইঙ্কূয়া কা তাহিনকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ইন্তং ইঙ্কূ কথক হড়কে উস্কূর কেৎ কুয়াকু, হেৎদ ইঙ্কূ গামাকেৎয়াকু, আলে স্তিফানকে মোশি রাঃআ হেৎদ ঈশ্বর রাঃআ নিন্দা হেৎদ মানখাট লেকেনেআ থুতি গাম আয়ুম তিয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ইঙ্কূ হড়কুকে হেৎদ মুরুব্বি কুকে হেৎদ আরিচালি চেচেদিজ কুকে রাগা তুকাৎ কুয়াকু হেৎদ স্তিফানকে গচ রাঃআ নাতিনাং সাবকিয়াকু হেৎদ মারাংদরবার ইদি কিয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","হেৎদ বেদা লুকুন্দী ী তিঙ্গুকেৎ কুয়াকু অকয় গামকেৎয়াকু, নিই হড় রীলামালা থাংরাঃআ হেৎদ আরিচালিরাঃআ বিরুধতে ঈশ্বরনিন্দারাঃআ থুতি কায় বন্ধতাৎআয়, ");
INSERT INTO cdz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","চিয়াচি আলে নিইকে গাম আয়ুমতিয়ালে যে, ইনি নাসড়তিয় যীশু নিয়া থাং পেটেজ গিডিআয় হেৎদ মোশি আবুয়া হান্ডে অকা যত আরিচালি এমতাৎ বুয়ায়, ইনা যত পাল্টা চাবাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ইন্তং অকয় দরবার দুবলেনাকু, ইঙ্কূ যতচ ইনিরা হান্তে মিৎ ঢেকতে কয়অকিয়াকু, ইনি রাঃআ মচা সেরমা সরগ নাঙ্গা লেকা নেলকেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ইনা তায়মতে মারাং বামড়ে কুলি কিয়ায়, নিয়া যত থুতি দচি সার্তিতানা? স্তিফান গামকেয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","গাম রুয়াড় দুলাড়িয়া বকইঞ কু হেৎদ বাঃআকু, আয়ুমেপে। আবুয়া আপু আব্রাহাম হারণ শেহার রে তাহিনো রাঃআ মাড়াঙতে চিললং মিসপটেমিয়া দিশুমরে তাহীনকেনায়, ইনা হুলাং মহিমারাঃআ ঈশ্বর ইনিকে ভেট এমালিয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ইনি গামকেয়ায় \"আম নিজে রাঃআ দিশুম হাতেন হেৎদ যত পাহি পেড়া কুরাঃআ হান্ডে হাতেন বাহারতে উডুঙ হিজুম হেৎদ ইঞ অকা দিশুম উদু মাইঞ, ইনা দিশুমতে সেনম(আদী. ");
INSERT INTO cdz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ইন্তং ইনি কল্দিয়কু রাঃআ দিশুম হাতেন উডুঙ হিচেন্তে হারোণরে বাসায়নায়, হেৎদ ইনি রাঃআ বাঃতেৎ রাঃআ গযচ তায়ম (ঈশ্বর) ইনিকে এনথাং হাতেন নিয়া দিশুমতে আউকিয়ায়, অকা দিশুমরে আপে নাহাআ মেনাপেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","মেন্খান নিয়া দিশুমরে ইনিকে আইদারি কায় এমালিয়ায়, ইতিজ তরাং বাইতহঅ ল্হয়, আব্রাহাম এক্ড়ার কেয়ায় যে, হানি ইনিকে হেৎদ ইনা তায়ম ইনি রাঃআ কূলকে অধিকার এমাকুয়ায়্য় য়, যদিহঅ ইন্তং ইনি রাঃআ যাহান হন-হপন কাকু হুইয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","হেৎদ ঈশ্বর নেকাগে গামকেয়ায় যে \"ইনিরা কূল এটা দিশুমরে বাসায়াআকু হেৎদ হড় ইঙ্কূকে মুনিশ বানহাকুয়াকু হেৎদ ইঙ্কূয়া নাতিনাং উপুনশো সির্মাং যাকিৎ সাসেৎ সাতাও পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","হেৎদ ইঙ্কূ অকা জাতিরাঃআ মুনিশ হুইওয়াকু, ইঞগে ইঙ্কূয়া দরবার ইন , নিয়াটা ঈশ্বর অটঃহঅ গামকেয়ায় \"ইনা তায়ম ইঙ্কূ বাহারতে উডুঙ হিজু য়াকু হেৎদ নেথাংরে ইঞা বাখেড় রুমুয়াআকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","হেৎদ ইনি ইশ্বর আব্রাহামকে সুন্নু চুটি গেদ রাঃআ এক্ড়ার এমাকিয়ায়, হেৎদ নেকাগে আব্রাহাম ইসহাককে জানাম কিয়ায় হেৎদ আটি মাহা রাঃআ হুলাং ইনি রাঃআ সুন্নু চুটি গেদকেয়ায়, তায়মতে ইসাহাক যাকোব রাঃআ হেৎদ যাকোব ইঙ্কূ বারজন আপু-বাঃআকুকে জানাম কেৎকুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","হেৎদ আয়াআ হাগা কুগে যোষেফ রাঃআ চেতাংরে হিংসানতেকু ইনিকে আখরিংকিয়াকু খানঃ ইনি মিশরতে সেনেনায় হেৎদ ঈশ্বর ইঙ্কূ লঅ তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","মেন্খান ঈশ্বর ইনি লঅগে তাহীনকেনায়, হেৎদ ইনি রাঃআ যত দু:খকষ্ট হাতেন ইনিকে রুক্ষীয়া কিয়ায়, হেৎদ মিশর রিনিজ রাপাজ ফরৌণরাঃআ হান্ডে দায়া-দুলাড় হেৎদ আকেলরাঃআ পরিচয় এমকেয়ায়, নিয়া নাতিনাং ফরৌণ ইনিকে মিশররাঃআ হেৎদ নিজেরাঃআ গোটা অড়ারাঃআ চালাইজ বাহালকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","তায়মতে গোটা মিশর হেৎদ কনানরে আকাল হুইয়েনা, হড়কু কুঠিন ফেসাদ নামকেৎয়াকু, হেৎদ আলেয়া আপু-বাঃআকু জমারাঃআ অভাবেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","মেন্খান মিশররে জমাআ মেনা আয়ুমকেৎ তে আলেয়া আপু-বাঃ খেরয়াল কুকে মাড়াঙ রে কুলকেৎকুয়ায়্য় ");
INSERT INTO cdz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","তায়মতে ধহড়া সা যোসেফ নিজে রাঃআ বকতেদকু লঅ উপরুমেনায় হেৎদ যোসেফরাঃআ কূল বাবদতে ফরৌণ সারি নামকেয়ায় (আদী , আদী , আদী. ");
INSERT INTO cdz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","তায়মতে যোসেফ নিজে রাঃআ বাঃআতেদ যাকোবকে হেৎদ নিজেরাঃআ যত কূলকে, পঁচাত্তর জন তিলিমড়ে হড়কুকে নিজেরাঃআ হান্ডে রাঃআ কুলকেৎকুয়ায়্য় (আদী , আদী. সেসেন , বারগাম ");
INSERT INTO cdz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ইনাতে যাকোব মিশরতে সেএনায়, হেৎদ ইনি হেৎদ আবুয়া আপুইঞ-বুঢাইঞকু গজেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","হেৎদ ইঙ্কূকে শিখিমরে আগু কাতে করব এম হুইয়াকানা হেৎদ অকা কবর আব্রাহাম রুপা দিয়া শিখিমরে হামোরাঃআ হনতেদতুকুয়া হান্ডে হাতেন কিরিংলাৎ আয়, এনথাংরে কবর হুইয়াকানাকু ");
INSERT INTO cdz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","তায়মতে ঈশ্বর অব্রাহামরাঃআ হান্ডে অকা এক্ড়ার লাৎ য়ায়, ইনা একরার পুরারাঃআ মাহা সেটের হিচেনা, হড়কু মিশররে ঢেরনতুকু গুঁডুর রে গাদা হুই রাকাবেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","মুচাৎ রে মিশররাঃআ চেতাংরে এনকান অট মিহুড় নামা রাপাজ জানামেনায়, অকয় যোষেফকে কায় সারিকেনায় (সেসেন . ");
INSERT INTO cdz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ইনি আলেয়া জাতি লঅ চালাকিকেয়ায়, আলেয়া আপুইঞ-বুঢাইঞতুকু লঅ খারাপ ব্যবহারকেয়ায়, উদ্দেশ্য নিয়া তানা যে, ইঙ্কূয়া হনকুকে যেন বাহাররে লেব্দা গিডি হুইওকাকু, যেন ইঙ্কূ আলকু বাঁঞ্চা দাড়িকাআ ");
INSERT INTO cdz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ইনা হুলাং মোশি রাঃআ জানাম হুইয়েনা। ইনি ঈশ্বর রাঃআ সামাংরে বুগিন লেকা তাহিনকেনায় হেৎদ আপি বঙ্গা যাকিৎ বাঃ মাই তেদরাঃআ অড়ারে আসুল-হারালেনায় । ");
INSERT INTO cdz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","তায়মতে ইনিকে গাডা রে বুহাল গিডি কিয়াকু খানঃঅ ফরৌণ রাঃআ হনরাতেদ ঝাকা রাকাব কিয়ায়, হেৎদ নিজে রাঃআ হন তেদ করা নাতিনাং আসুল-হারাকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","হেৎদ মোশি মিস্রিয় কু রাঃআ চেচেদতে চেদকিয়্যায় হেৎদ ইনি জাগার হেৎদ কামিরে দাড়িয়ান তাহীন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","হেৎদ ইনিরা প্রায় পুলি সির্মাং হুইরাঃআ তায়ম নিজে রাঃআ বকতেদ তুকু, খেরোয়াল হনতেদ তুকু, উপরুম রাঃআ ইচ্ছা ইনি রাঃআ অন্তররে চির্গালেনা ");
INSERT INTO cdz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ইন্তং মিৎ হড় রাঃআ চেতাংরে অন্যায়ে তানাকু নেলকেৎ তে, ইনি ইনি রাঃআ সঙ্গ হাতাকেয়ায়, ইনি মিশ্রিয় হড়কে গয়চকিৎ তে সাসেৎ সাতাও সাহাইজ হড়টাকে ন্যায় এমাকিয়ায় ");
INSERT INTO cdz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ইনি আটকার কেয়ায় যে, ইনিরা বকতেদ তুকু বুঝাকানাকু যে, ইনি রাঃআ তিহি দ্বারায় ঈশ্বর ইঙ্কূকে রেহাই এমতানা কুয়ায়্য় য়, মেন্খান ইঙ্কূ কাকু আটকার লাৎআ। ");
INSERT INTO cdz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","হেৎদ দশার হুলাং ইঙ্কূ চিন্তং দাল-গপজোঃ কেনাকু, ইন্তং ইনি ইঙ্কূয়া হান্ডে সেনকাতে মিটমাট কাতে সুলুক এমরাঃআ কুরুমুটু কেয়ায়, গামকেৎ কুয়ায়্য়, এ দুলাড়িয়া, আপেমা বকবায়া কু, মিহুড় অট মিহুড় লঅ গ্প্জ তানাবেন চিয়া? ");
INSERT INTO cdz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","মেন্খান প্রতিবাশি রাঃআ পড়শিরাঃআ হান্তে অন্যায়লাৎ আয় অকা হড়, ইনি মুশাকে ঠেলা নুরকিৎ তে গামকিয়ায়, আমকে শাসনিজ হেৎদ দরবার িজ মেন্তে আলেয়া চেতাংরে অকয় বাহাল কেৎ মেয়ায়? ");
INSERT INTO cdz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","হলা চিল্কা ইনি মিশ্রিয়কে গয়চলিয়াম, এনকা কি ইঞকেহঅ গয়চ নানাম তানাম চি কিনাআ? ");
INSERT INTO cdz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","নিয়া থুতিতে মোশি নির জমেনায়, হেৎদ মিদিয়ণ দিশুমতে প্রাবাশী লেকা বাসায়নায়, এনথাংরে ইনি রাঃআ বারিয়া হনতেদ জানাম য় নাকিন ");
INSERT INTO cdz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","হেৎদ পুলি সির্মাং পুরায়না খানঃঅ সীনয় বুরুরাঃআ মরুডাহিরে মিয়াৎ সরগ নাঙ্গা মিয়াৎ ঝোপরে সেঙ্গেল শিখারে ইনিকে দেখা এমকিয়ায় ");
INSERT INTO cdz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","মোশি ইনা দৃশ্য় নেলকাতে হায়কাটেনায়, অটঅ বেশ নেল নাতিনাং ঠাইনতে সেনকেনায়, এনকান অক্ত প্রভু ইশ্বর রাঃআ মিয়াৎ সাডি আয়ুমেনা, গামকিয়ায়, নিয়া আড়াঙ হুই য়ে না ");
INSERT INTO cdz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"ইঞ আমা আপুম-বুঢাম তুকুয়া ঈশ্বর, অব্রাহাম, ইসহাক হেৎদ যাকোব রাঃআ ঈশ্বরতানাইঞ। ইন্তং মোশি আত্রাসয়েন্তে বেশ অটঅ নেলরাঃআ কায় সাহস লেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","হেৎদ প্রভু ইনিকে গামকিয়ায় \"আমা কাটা হাতেন খড়ম হলেজ গিডিম চিয়াচি কথাংরে আম তিঙ্গুয়া কানাম, ইনা রীলামালা থাংতানা (সেসেন . 3:5 ) ");
INSERT INTO cdz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ইঞ মিশররাঃআ তালারে ইঞা হড়কুরাঃআ দুঃখ বেশ নেলতাৎ আইঞ, ইঙ্কূয়া ইয়াম আয়ুমকেয়াইঞ, হেৎদ ইঙ্কূকে রুক্ষীয়া নাতিনাং আড়গু হিচাকানাঞ, নাহ হিজুপে, ইঞ আমকে মিশররে কুললে মাইঞ (সেসেন . 2:24, সেসেন . 3:7-10 ) ");
INSERT INTO cdz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","নেএ যে মোশিকে অস্বীকারলিয়াকু, গামলিয়াকু, আমকে শাসনইজ হেৎদ দরবার জ করাকাতে অকয় বাহাল তাৎ মেয়ায়? ইনিকেগে ঈশ্বর, অকা সরগ নাঙ্গা ঝোপরে ইনিকে ভেট এমলিয়ায়, ইনি সরগ নাঙ্গা রাঃআ তিহি দ্বারায়তে অধক্ষ্য হেৎদ বাঁঞ্চাইজ করাকাতে কুলকিয়ায় (সেসেন . 2:14, সেসেন . ");
INSERT INTO cdz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","মসি মিশর দিসুম রে, আরাঃআ দরেয়ারে হেৎদ মরুডাহিরে পুলি সির্মাং যাকিৎ নাআহানা অদভূত লক্ষণ হেৎদ চিহ্না -কামি করাকাতে ইঙ্কূকে উডুঙ আউকেৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ইনি হানি মোশি তানায় অকয় খেরোয়াল হনকুকে নিয়া থুতি গামলাৎ কুয়ায়্য় য় \"ঈশ্বর আপেয়া নাতিনাং আপেয়া বকম তাপেয়া তুকুয়া তালা হাতেন ইঞ লেকা মিয়াৎ ভাবি জাগারিজকে উডুঙইয়ায় (বারগাম . 18:15-18) ");
INSERT INTO cdz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ইনিগে মরুঢাহিরে ইহুদিকু লঅ মিদুণ তাহিনকেনায়, অকা সরগ নাঙ্গা সীনয় বুরুরে ইনি লঅ থুতিকেনায়। ইনিগে আয়া হেৎদ আবুয়া আপুইঞ-বুঢাইঞকু লঅ তাহিন কেনায়। ইনি আবুকে এমরাঃআ নাতিনাং জিউ এমিজ জাগার যত নামলাৎ আয় (সেসেন . 19:1-6, সেসেন . 20:1-17, বারগাম . 5:4-22, বারগাম . 9:10, 11) ");
INSERT INTO cdz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","আলেয়া আপুইঞ-বুঢাইঞকু ইনিরা থুতি কাকু মানাবাতা নানামলেনা, বরঞ্চ ইনিকে ঠেলা নুর কিয়াকু, হেৎদ মনে মনে অট মিশর দিসুম রাঃআ হান্তে রুয়াড়েনায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","হারোণকে গামকিয়ায়, আবুয়া নাতিরাং ঠাকুর বায়িইম, ইঙ্কূগে আবুয়া মাড়াঙ মাড়াঙতে সেনাকু, চিয়াচি নেএ যে মোশি মিশর দিশুম হাতেন আবুকে উডুঙ আউকেৎ বুয়ায়, ইনি রাঃআ কিনা হুইয়েনা, আবু কাবু সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","হেৎদ ইনা হুলাং ইঙ্কূ মিয়াৎ বাছুর বাইকিয়াকু, হেৎদ ইনা বাছুর মূর্তি রাঃআ সামাংরে বলি সামাঙ্গ কেৎয়াকু, হেৎদ নিজে রাঃআ তিহিতে বানহা ঠাকুর রে রাসকা লাগায়নাকু ");
INSERT INTO cdz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","মেন্খান ঈশ্বর কায় কুশিলেনায়, ইঙ্কূকে নিরালা রিনিজ পাল্টন বঙ্গা রাঃআ নাতিনাং সম্পা কেৎকুয়ায়্য়, চিল্কা ভাবি জাগারিজ পুথিরে অলমেনা, দুলাড়িয়া খেরোয়াল হড়কু, মরুডাহিরে পুলি সির্মাং যাকিৎ আপে কি ইঞা উদ্দ্যেশে পশুবলি হেৎদ বলিদান উৎসর্গ য়কেনাপে? ");
INSERT INTO cdz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","আপে বরঞ্চ মোলক রাঃআ তাম্বু হেৎদ রিফন রাঃআ ইপিল তুলকাতে গঅতাৎ কুয়াপে, ইঙ্কূ মূর্তিকু, অকা আপে বঙ্গা নাতিনাং বাইলাৎ কুয়াপে, হেৎদ ইঞ আপেকে বাবিলরাঃআ এন্তে হারগিডি পেয়াইঞ ");
INSERT INTO cdz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","চিল্কা ইনি আচুলাৎ বুয়ায়, লুকুন্দী তাম্বু মরুডাহিরে আবুয়া আপুই-বুঢাই তুকুয়া হান্ডে তাহীনকেনা। অকয় মোশিকে গামলিয়ায়, আম চিল্কা নমুনা নেলকেয়াম, এনকাগে ইনা বাইয়েম। ");
INSERT INTO cdz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","হেৎদ আলেয়া আপুইঞ-বুঢাইঞতুকু ইঙ্কূয়া অক্ত ইনা নামকাতে যিহোশুয় রাঃআ হান্ডে আউকেৎয়াকু, চিন্তং ইঙ্কূ এটা জাতি রিঙ্কূ হড়কুরাঃআ আইদারিরে বলয়নাকু, অকয় রাঃআ ঈশ্বর আলেয়া আপুইঞ-বুঢাইঞ তুকুয়া সামাং হাতেন কুদা গিডিকেৎ কুয়ায়্য় য়। ইনা তাম্বু দাউদ রাপাজ রাঃআ অক্ত যাকিৎ তাহিলেনা। যিহোশুয় 18:1; 24:18) ");
INSERT INTO cdz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ইনি দাউদ রাপাজ ঈশ্বর রাঃআ সামাংরে দায়া-দুলাড় নামকেয়ায় হেৎদ যাকোব রাঃআ ঈশ্বর রাঃআ নাতিরাং মিয়াৎ অড়া বাইরাঃআ নাতিরাং অনুমতি (2 শামু. 1 রাপাজ . 8:17, 18, 1 ইতি 17:1-14, 2 ইতি . 6:7, 8, দুরাং মালা . 132:5) ");
INSERT INTO cdz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","মেন্খান শলোমন রাপাজ ইশ্বর নাতিরাং মিয়াৎ অড়া বাইকেয়ায় (1 রাপাজ . 6:1, 2, 1 রাপাজ . 6:14, 1 রাপাজ . 8:19, 20, 2 ইতি . 3:1, 2 ইতি . 5:1, 2 ইতি . 6:2, 2 ইতি . 6:10) ");
INSERT INTO cdz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","অথচ মারাং চুট উতারিনিজ ঈশ্বর তিহিতে বাইয়াকান অড়ারে কা তাহিনায়। চিল্কা ভাবিজাগারিজ গামেআয়, ");
INSERT INTO cdz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"সেরমা ইঞা কুলান্ডূ, ধার্তি ইঞা কাটা দঃহ রাঃআ থাং, প্রভু গামেআয়, আপে ইঞা নাতিরাং চিল্কান অড়া বাইয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","\"বাংখান ইঞা ঝিরারাঃআ থাং কদেরে? ইঞা তিহিতে কি নিয়া যত কাইঞ বানহাতাৎ আ? ");
INSERT INTO cdz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","এ কেটেজ হড়কু হেৎদ অন্তরতে হেৎদ লুতুরতে অচ্ছিন্নত্বককু/হার্তা-কা-গেদকু বেরাহিকু, আপে যত মাহা রীলামালা আত্মারাঃআ প্রতিরোধেয়াপে/বিরুধেয়াপে, আপেয়া আপুইঞ-বুঢাইঞতুকু চিল্কা, আপেহঅ গটা এনকাগেসেসেন 32:9; লেবিয় 26:41; লেখাযখা 27:14; জিসাই 63:10; জেরামিয়া 6:10; জেরামিয়া 9:26 ");
INSERT INTO cdz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","আপেয়া আপুইম-বুঢাইঞ মতুকু যাহায় ভাবিজাগারিজকে কাকু তাড়নাতাৎ কুয়াকুদা? ইঙ্কূ হাঙকু গয়চলাৎ কুয়াকু, অকয় মাড়াঙতে ইনি ধার্মিকরাঃআ হিজু রাঃআ থুতি সারিকেনাকু, অকয়কে হুডাং মাহা মাড়াঙতে আপে শত্রু রাঃআ তিহিরে রাকাবকিয়াপে হেৎদ গয়চলিয়াপে ");
INSERT INTO cdz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","আপে যতচ সরগ নাঙ্গা কুরাঃআ দ্বারায়তে মোশিরাঃআ হুকুম নামলাৎ আপে, মেন্খান কাপে মানাবাতাতাৎ আ। ");
INSERT INTO cdz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","নিয়া থুতি আয়ুমকেৎ তুকু মহাদরবার রিঙ্কূ সদস্য়কু আঘাতেনাকু, স্তিফান রাঃআ হান্তে কয়অকেৎ তুকু ডাটারে ডাটা তগজ লাগায়নাকু (ইযব . 16:9, দুরাং মালা . 35:16, দুরাং মালা . 37:12, দুরাং মালা . 112:10) ");
INSERT INTO cdz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","মেন্খান ইনি স্তিফান, রীলামালা আত্মাতে পেরেজেন্তে সেরমা রাঃআ হান্তে মিৎ ঢেকতে কয়ঃঅকেৎ তে ঈশ্বর রাঃআ মহিমা নেলকেয়ায়, হেৎদ যীশু ঈশ্বর রাঃআ জজম তিহি সায়রে তিঙ্গুয়া কানায়, ");
INSERT INTO cdz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","হেৎদ ইনি গামকেয়ায়, সেরমা হলেজ গিডিয়াকানা, মান্মি হন ঈশ্বর রাঃআ জজম সায়রে তিঙ্গুয়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","মেন্খান ইঙ্কূ কুঠিন জোরতে কিকিচ রাকাব কেৎয়াকু, আকু নিজে নিজে রাঃআ লুতুর তুবেদ কেৎয়াকু হেৎদ মিশাতে ইনিরা চেতাংরে সেনকাতে অতা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","হেৎদ ইনিকে শেহার হাতেন গহাড় উডুঙ কিয়তুকু দিরি দুহাড় লাগায়নাকু, হেৎদ লুকুন্দী ীকু নিজে নিজেরাঃআ কিচ-সনঃঅ অড়েচ হলেজকেৎ তেকু শৌল নুতুমিজ মিহুড় জুয়ান কড়াহন রাঃআ কাটা রাঃআ কাতারে ঢেলা স্বমদ কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","নাতেরে ইঙ্কূ স্তিফানকে দিরিতে ঠকনাইকেনাকু, হেৎদ ইনি ইনিরা নুতুম রাঃআকাতে বিন্তিকেয়ায়, এ প্রভু যীশু ইঞা আত্মাকে গ্রহনিইম (দুরাং মালা . 31:5) ");
INSERT INTO cdz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","হেৎদ ইনি উকুড়ুমেন্তে জোর জোরতে কিকিচ কাতে গামকেয়ায়, প্রভু, নিকুয়া বিরুধরে নিয়া কাই আলম সাবেয়া। নিয়া গামকাতেন ইনি গয়চেনায়। হেৎদ শৌল ইনি রাঃআ গয়চরাঃআ হুকুম এমাদকেনকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","শৌল এনথাংরে ইনি স্তিফান রাঃআ গয়ঃজ রাঃআ নাতিনাং সায় তাহিলেনা। ইনা হুলাং যিরুশালেম শেহার মন্ডলী রাঃআ চেতাংরে কুঠিন সাসেৎ সাতাও এতহবেনা, ইনাতে কুলিচ কু বাগীকাতে এটা যতচ ইহুদিয়া মুলুক হেৎদ শমরিয়াতে ছিতিবিতিইনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ইনা হুলাং কথক ভক্ত হড় স্তিফানকে তপা কিয়াকু, হেৎদ ইনিরা নাতিরাং শোক সদর কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","মেন্খান শৌল মন্ডলীকে নাশ নাতিনাং, অড়া অড়াতে বলকাতেন পাতিয়ান কড়া- কুড়ি কুকে সাবকাতে গহাড় গহাড়তে আউকাতে জিহালরে খড়া কাতে আটক কেৎকুয়ায়্। ");
INSERT INTO cdz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ইন্তং অকয় গোটা ছিতি বিতি লেনাকু, ইঙ্কূ ইনা যত জায়গারে বুগিনবার্তা উছান লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","হেৎদ ফিলিপ শমরিয় রাঃআ মুর্ধুন শেহার সেন কাতেন হড়কুরাঃআ হান্ডে খ্রীষ্টকে উছান লাগায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","হড়কু ফিলিপরাঃআ থুতি আয়ুম কেয়াকু হেৎদ ইনিরা যত হাহাড়া কামি নেলকেৎ তুকু মিৎ মনতে ইনি রাঃআ থুতি আয়ুম লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","চিয়াচি বাড়িচ আত্মাতে নামাকান গাদা হড় কুরাঃআ তালা হাতেন ইঙ্কূ বঙ্গা আত্মাকু কিকিচ কাতে উডুঙ হিচেনাকু হেৎদ গাদা অসাড় হেৎদ লেংড়া হড়কু বুগিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ইনাতে ইনা নগররে কুঠিন রাস্কা হুইয়েনা। ");
INSERT INTO cdz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","মেন্খান শিমোন নুতুমতে মিয়াৎ হড় তাহীনকেনায়, ইনি মাড়াঙ হাতেন ইনা নাগার রে যাদু দেখায়কেনায়, হেৎদ শমরিয় জাতি রিঙ্কূ হড়কুকে হায়কাট কেনকুয়ায়্য়, হেৎদ নিজেকে মিয়াৎ মারাং হড় মেন্তে উদুই সদর কেনায়, ");
INSERT INTO cdz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ইনিরা থুতি হুডিং মারাং যতচ আয়ুমেৎ কেনাকু, হেৎদ গামেৎ কেনাকু, নিই হড় ঈশ্বর রাঃআ ইনা দাড়ি, অকা মাপরাং নুতুমতে সারিয়াআ। ");
INSERT INTO cdz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","হড়কু ইনিরা থুতি আয়ুমমেৎ কেনাকু, চিয়াচি ইনিদ গাদা হুলাং হাতেন ইঙ্কূ যাদু দেখাকাতেন হায়কাট কাতেন দঃহলাৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","মেন্খান ফিলিপ ঈশ্বর রাঃআ মুলুক হেৎদ যীশু খ্রীষ্টরাঃআ নুতুম বুগিন বার্তা উছান কেয়ায় খানঃঅ ইঙ্কূ ইনিরা থুতিরে পাতিয়া আয়নাকু, হেৎদ কড়াহন হেৎদ কুড়িহনকু ডুবুলেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","হেৎদ শিমোন নিজেহঅ পাতিয়াআয়নায়, হেৎদ ডুবুলেনতে ফিলিপ লঅগে তাহিনায়, হেৎদ হাহাড়া হেৎদ দাড়িয়ান কামী নেলকাতেন হায়কাটেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","যিরুশালেম শেহার রিঙ্কূ কুলিচ কু চিন্তং আয়ুমকেয়াকু যে শমরিয়কু ঈশ্বর রাঃআ জাগার আতাং তাঃআকু, ইন্তং ইঙ্কূ পিতর হেৎদ যোহন তিকিনকে ইঙ্কূয়া হান্ডে কুলকেৎ কিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","চিন্তং ইঙ্কিন হিচেনাকিন, ইঙ্কূ শমরিয়া রিঙ্কূ পাতিয়ান হড় নাতিনাং বিন্তি কেয়াকু, যাতে ইঙ্কূ রীলামালা আত্মা নামেকাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","চিয়াচি ইন্তং যাকিৎ ইঙ্কূ রীলামালা আত্মা কাকু নামতাৎ আ, ইঙ্কূ একেন প্রভু যীশু রাঃআ নুতুমতে ডুবুলাকানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ইন্তং ইঙ্কিন পিতর, যহন ইঙ্কূয়া চেতাংরে তিহি দহঃঅ কেয়াকিন, হেৎদ ইঙ্কূ রীলামালা আত্মা নামকেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","হেৎদ শিমোন চিন্তং নেলকেয়ায়, কুলিচ কুরাঃআ তিহি দহঃঅকাতে (তিহি এমকাতে) রীলামালা আত্মা নামতানা, ইন্তং ইনি ইঙ্কিনা হান্ডে কাউডি আউকাতে গামকেৎ কিনায়, ");
INSERT INTO cdz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ইঞকেহঅ নিয়া দাড়ি এমাইঞবেন, যাতে ইঞ অকয়রাঃআ চেতাংরে তিহি দহঃঅ আইঞ, ইনিহঅ রীলামালা আত্মা নামেকাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","মেন্খান পিতর ইনিকে গামকিয়ায়, আমা রুপা আম লঅ নষ্টকাআ, চিয়াচি ঈশ্বর রাঃআ দান আম কাউডি দিয়া কিরিং সানাকেৎ মেয়া (দুরাং মালা . 78:37) ");
INSERT INTO cdz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","নিয়া বাবত রে আমা যাহানাহঅ হাক বাআয়না, চিয়াচি আমা অন্তর ঈশ্বর রাঃআ মেদরে বেশ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","এন্তে আমা নিয়া বাড়িচ হাতেন মন রুয়াড়এম, হেৎদ প্রভু রাঃআ হান্ডে বিন্তিম, তাহলে হুইদাড়িয়া, আমা অন্তররাঃআ কাই ছেমা হুইদাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","চিয়াচি আলিঞ নেলকেয়ালিঞ, আমা হান্ডে হিংসা মেনা হেৎদ আম কাইতে আটক া কানাম (বারগাম দ্বিতীয় বিবরণী . 29:18, বিলাপ ) ");
INSERT INTO cdz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ইন্তং শিমোন গামকেৎ কিনায়, আবেনগে ইঞা নাতিরাং প্রভু রাঃআ হান্ডে বিন্তিবেন, যাতে আবেন যাহানা গামেয়াবেন ইনা যেন ইঞ লঅ আল হয়ু কআ। ");
INSERT INTO cdz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","তায়মতে ইঙ্কিন লুকুন্দী এমকেয়াকিন হেৎদ প্রভু রাঃআ বাবদতে অটঃহঅ গাদা থুতি গামকেয়াকিন হেৎদ যিরুশালেম শেহার রে সেনঃঅ হুলাং ইঙ্কিন শমরিয়কুরাঃআ হাতু হাতুতে বুগিন বার্তা উছান কেয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","তায়মতে প্রভু রাঃআ মিয়াৎ সরগ নাঙ্গা ফিলিপকে গামাকিয়ায়, জজম তিহিদর, অকা হরাটা যিরুশালেম শেহার হাতেন ঘসা নাগার রাঃআ হান্তে আড়গু ইদিয়াকানা, এন্তে সেনম। ");
INSERT INTO cdz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ইনাতে ইনি সেসেন এহবকেয়ায় হেৎদ, ইথিয়পিয় দিশুম রিনিজ মিয়াৎ হড় লঅ ইনিরা দেখা হুইয়েনা, অকয় ইথিয়পিয় রিনিজ কান্দাকি রাপনীরাঃআ রাজত্বরাঃআ অধীনরে বাহালাকান চেতাং পদরিনিজ মিয়াৎ মায়ো, অকয় রাপনীরাঃআ মারাং খাজাঞ্জি তাহীন কেনায়, ইনি নেহর বিন্তি নাতিনাং যিরুশালেম শেহার তে হিচ লেনায়, ");
INSERT INTO cdz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","হেৎদ রুয়াড় সেনঃঅ হুলাং, রাথরে দুবকাতে যিশাইয় ভাবি জাগারিজ রাঃআ পুথি পড়হাকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ইন্তং রীলামালা আত্মা ফিলিপকে গামকিয়ায়, আম ইনি হড়রাঃআ রথরাঃআ সঙ্গে সঙ্গে সেনম। ");
INSERT INTO cdz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ইনাতে ফিলিপ রাথরাঃআ সাথ হাতাকেয়ায় হেৎদ আয়ুমকেয়ায়, ইনি হড় যিশাইয় ভাবি জাগারিজ রাঃআ পুথি পড়হাকেনায়, ফিলিপ গামকেয়ায়, আম কিনা পড়হাতানাম, ইনা বাবত কুকি আটকার নামদাড়িতানাম? ");
INSERT INTO cdz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ইথিয়পীয় রেনিচ মায়ো গামকেয়ায়, যাহায় কাকু দেঙ্গা লিঞখান, ইঞ চিল্কাতে বুঝা দাড়িয়াইঞ? ইন্তং ইনি মায়ো ফিলিপকে আয়া রাথতে হিচু হেৎদ আয়চলঅ দুবতে নেহর কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ইনি শাস্ত্ররাঃআ অকা অংশটা পড়হাকেনায়, ইনা হুইওতানা, যেমন ভিডি বলিদান করা নাতিনাং ইদি হুইওয়া, এনকা ইনিহঅ বলিনায় হেৎদ উব কাটরপ/ছাডাকুরাঃআ হান্ডে ভিডি চিল্কা থির তাহিনায়, এনকাগে ইনিহঅ থির তাহিনায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ইনিরা হীনাবস্তারে/হেরেশমেনরে (অসহায়রে) ইনিকে দরবার কিয়াকু, ইনি রাঃআ সমানিজ হড়কুরাঃআ বর্ণনা অকয় করাঃআ দাড়িয়াকু? চিয়াচি ইনি রাঃআ জিউ ধার্তি হাতেন হাতা হুইয়েনা ");
INSERT INTO cdz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","মায়ো খাজাঞ্জি ফিলিপ কে কুলিকিয়ায় হেৎদ নেহর লঅ সারি নানামেনায়, ভাবি জাগারিজ অকয় রাঃআ বাবদতে নিয়া থুতি গামতাৎআয় ? নিজেরাঃআ বাবত তে চি এটা যাহায়রাঃআ বাবত তে? ");
INSERT INTO cdz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ইন্তং ফিলিপ শাস্ত্ররাঃআ অংশ হাতেন এহবকাতে, প্রভু যীশু রাঃআ বুগিন বার্তা ইনিকে গামসাডিকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","হেৎদ ইঙ্কিন হরাতে সেন সেনতে মিয়াৎ গাডিয়া রাঃআ কাতাতে সেটেরেনাকিন, ইন্তং মায়ো ফিলিপকে গামকিয়ায়, নেএ নেলেম, দাঃআ মেনা, ডুবুল হাতাতে ইঞা বাধা কদেরে? ");
INSERT INTO cdz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","38","তায়মতে ইনি রাথ তিঙ্গু নাতিনাং হুকুমকিয়ায়, ফিলিপ হেৎদ ইনি বারহড়গে দাঃআরে আড়গুইনাকিন হেৎদ ফিলিপ ইনিকে ডুবুল এমাকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ইঙ্কিন চিন্তং দাঃআ হাতেন রাকাববেনাকিন, প্রভু রাঃআ আত্মা ফিলিপকে আচ্কাগে ইদিকাতেন সেনেনায় হেৎদ মায়ো অটদ ইনিকে কায় নেলনাম দাড়িলিয়ায়, মেন্খান রাসকাতে ইনি রাঃআ অড়া সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","নাতেরে ফিলিপকে আসদোদ নাগাররে নেলনামেনায়, হেৎদ ইনি নাগার নাগাররে বুগিন বার্তা উছান উচ্ছান করকৈসরিয়া শেহার শহরতে সেটেরেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","শৌল ইন্তং হঅ প্রভু রাঃআ চেলাকুকে বর উদুয়া কুকেনায় হেৎদ গজেৎকু কেনায়, ইনি মারাং বামড়েকুরা হান্ডে সেনলেনায় হেৎদ, ");
INSERT INTO cdz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","দম্মেশকস্থ নাগার রাঃআ সমাজ অড়া, যতচ রাঃআ নাতিনাং গিরা নানামেনায়, যেন ইনি ইনা হরাতে সেনয়াকু কড়াহন হেৎদ কুড়িহন অকয়কে নামকুয়ায়্য় য়, ইঙ্কূকে আটক কাতে যিরুশালেম শেহার তে আউ দাড়িকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","চিন্তং সেনকেনায়, হেৎদ দম্মেশকরাঃআ কাতাতে চিন্তং সেটেরেনায়, আচকাগে চেতাং হাতেন মার্শাল ইনিরা চারুধার ঝালকা রাকাবেনা। ");
INSERT INTO cdz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","হেৎদ ইনি অতেরে নুরেনায় হেৎদ মিয়াৎ আড়াঙ আয়ুমকেয়ায় শৌল, শৌল, চিয়া ইঞকে হেরেশমেন এমাঞতানাম? ");
INSERT INTO cdz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","শৌল গাম কেয়ায় \"প্রভু, আম অকয়তানাম? প্রভু গাম কেয়ায়, ইঞ যীশু, অকয়কে আম হেরেশমেন এমাইতানাম। ");
INSERT INTO cdz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","মেন্খান বিরিৎমে, শেহার তে বলনমে, আমকে কিনা চিকা হুইয়া, ইনা গামোয়া। ");
INSERT INTO cdz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","হেৎদ ইনিরা গাতিকু হায়কাটেনতেকু তিঙ্গু তাহীনাআ হেৎদ ইঙ্কূ ইনা আড়াঙ আয়ুম কেৎয়াকু মেন্খান ইঙ্কূ যাহা নাহঅ কাকু নেল নামলাৎ আ। ");
INSERT INTO cdz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","হেৎদ শৌল তায়মতে অতে হাতেন রিরিদদেনায়, মেন্খান চিন্তং মেদ আরিৎ কেৎ খানে ইনি যাহানা কায় নেলনামলাৎ আয়, হেৎদ ইনি রাঃআ গাতিকু ইনি রাঃআ তিহি সাবকেৎ তেকু ইনিকে দম্মেশক শেহারতে ইদিকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","হেৎদ ইনি আপি মাহা যাকিৎ যাহানাগে কায় নেলনাম দাড়িলাৎ আয় হেৎদ যাহানা কায় জমলাৎ আয় চি কায় নুঃউ লাৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","দম্মেশকরে অননিয় নুতুমতে মিয়াৎ চেলা তাহীনকেনায়। প্রভু ইনিকে কুকুমুতে গামকিয়ায় \"অননীয়। ইনি তেলা কেয়ায়, প্রভু, নেলিঞ মে ইঞ নেথাংরিঞা গামেম ? ");
INSERT INTO cdz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ইন্তং প্রভু ইনিকে গাম কিয়ায় \"বিরিদমে হেৎদ সোজা নুতুমান হরাতে সেনকাতে যিহুদারাঃআ অড়াতে তার্ষ শেহার রে শৌল নুতুমান মিয়াৎ হড়কে পাঞ্জাইম, চিয়াচি, ইনি বিন্তিতানায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","শৌল কুকুমু নেলকেয়ায় যে \"অননিয় নুতুমতে মিয়াৎ হড় হিচ কাতে ইনি রাঃআ বহঅ চেতাংরে তিহি দঃহকেয়ায় যেন ইনি দঃহরা নেল নামেকায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","অননীয় গাম রুয়াড় কেয়ায়, প্রভু গো, ইঞ গাদালেকা হড় কুরাঃআ হান্ডে হাতেন ইনি হড়রাঃআ বাবত তে আয়ুমতাৎ আইঞ, ইনি যিরুশালেম শেহার রে আমা বাছায়ান রীলামালা হড়কুকে চিন্তিৎ হেরেশমেন তাৎ কুয়ায়্য় য়, ");
INSERT INTO cdz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","নেডে হঅ চিন্তিলেকা হড় আমা নুতুম তে বিন্তি রাঃআয়াকু, ইঙ্কূ যত হড়কে আটক ইদিরাঃআ আইদারী ইঙ্কূ মারাং বামড়ে কুরাঃআ হান্ডে হাতেন নাম তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","মেন্খান প্রভু যীশু ইনিকে গাম কিয়ায়, আম সেনম, চিয়াচি অইহুদি কুরাঃআ হেৎদ রাপাজ কুরাঃআ হেৎদ খেরোয়াল হনহপন কুরাঃআ তালারে ইঞা নুতুম গঃঅ নাতিনাং ইনিদ ইঞা বাছায়ান হড় তানায়, ");
INSERT INTO cdz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","চিয়াচি ইঞ হানিকে নেলতকাইঞ, ইঞা নুতুম রাঃআ নাতিরাং হানিকে চিন্তি কষ্ট সাহা হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","এন্তে অননীয় সেএনায় হেৎদ ইনা অড়ারে বলনতে ইনিরা বহঅ চেতাংরে তিহি দঃহঅকাতে গামকেয়ায়, বকইঞ শৌল, প্রভু যীশু, অকয় আমা হিজুহরারে আমকে দেখা এমলাৎ আমায়, ইনি ইঞকে কুল তিয়াইঞ, যেন আম অটঅ দিশা নাম রুয়াড়েম হেৎদ রীলামালা আত্মাতে পেরেজম। ");
INSERT INTO cdz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","হেৎদ ইনা ঘাড়িগে ইনিরা মেদ হাতেন যেন মিয়াৎ হাকুরাঃআ সিড়িইঞ লিঙ্গীনাআ হেৎদ ইনি দিশা নামরুয়াড়কেয়ায়, হেৎদ বিরিদেন্তে ডুবুলেনায়, ");
INSERT INTO cdz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","তায়মতে ইনি জমকেয়ায় হেৎদ দাড়ি নামকেয়ায়। হেৎদ ইনি দম্মেশক রিঙ্কূ চেলাকু লঅ কথক মাহা তাহিনায়, ");
INSERT INTO cdz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","হেৎদ সাঙ্গে সাথ ইনি সমাজঅড়ারে সেনকাতে যীশু রাঃআ জাগার পাসনা লাগায়নায়, যে ইনিগে ঈশ্বর রাঃআ হন তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","হেৎদ অকয় ইনি রাঃআ থুতি আয়ুম কেৎয়াকু, ইঙ্কূ যতচ হাহাড়ায় নাকু, গাম লাগায়নাকু, নিই কি হানি হড়টা ল্হয়, অকয় তানায়, যাহায় যিরুশালেম শেহার রে যীশু রাঃআ নুতুমতে নেহর বিন্তিৎ কেনাকু ইঙ্কূকে উচ্ছেদকেৎ কুয়ায়্য়য়? হেৎদ ইনি নেথাংরে হিচা কানায় যেন ইঙ্কূকে আটক কাতে মারাং বামড়ে কুরাঃআ হান্ডে ইদিকুকায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","মেন্খান শৌল হুদাং হুদাংতে দাড়ি নামকেয়ায় হেৎদ দম্মেশকরে বাসায়ান ইহুদিকুকে উত্তর এমরাঃআ হরা কায় এমলাৎ কুয়ায়্য় য় হেৎদ প্রমাণ এম লাগায়নায় যে যীশু গে ইনি খ্রীষ্ট তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","হেৎদ গাদা মাহা পারমেনাআ খানঃঅ, ইহুদিকু ইনিকে গচরাঃআ কারসাদী কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","মেন্খান শৌল ইঙ্কূয়া চালাকি কারসাদী সারিনামকেয়ায়। হেৎদ ইঙ্কূ যেন ইনিকে গয়চ দাড়িকাআকু ইনা নাতিরাং নিদা সিঙ্গি শেহার রাঃআ দুয়াররে হরঃঅ লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","মেন্খান ইনিরা চেলাকু আয়ুব বাতিরাং ইনিকে ইদিকাতে মিয়াৎ ঝুড়িয়াতে পাঁচিল রাঃআ চেতাং হরকাতে বাহারতে আড়গু কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","হেৎদ ইনি চিন্তং যিরুশালেম শেহার রে সেটেরকাতে চেলাকুলঅ মেসা নাতিনাং কুরুমুটু কেয়ায়, যতচ ইনিকে বর কিয়াকু, ইনি যে চেলা তানায়, ইনা কাকু পাতিয়া লেনা। ");
INSERT INTO cdz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ইন্তং বার্ণবা শৌলরা তিহি সাবকাতে কুলিচ কুরাঃআ হান্ডে ইদিকিয়ায়, হেৎদ হরা তালারে চিল্কা প্রভুকে নেলনামলিয়ায়, হেৎদ প্রভু যে ইনি লঅ থুতিকেনায় হেৎদ চিল্কা ইনি দম্মেশকরে যীশু রাঃআ নুতুমতে সাহস লঅ পাসনা কেনায়, নিয়া যত ইঙ্কূয়া হান্ডে গামকেৎয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","হেৎদ শৌল যিরুশালেম শেহার রে ইঙ্কূ লঅ তাহীনকেনায় হেৎদ ভীতিরতে হেৎদ বাহারতে সেনঃঅ হিজু কেনায়, প্রভু রাঃআ নুতুমতে সাহস লঅ পাসনা কেয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","হেৎদ ইনি গ্রীক আড়াঙ জাগারতে থুতিয়ান ইহুদিকু লঅ থুতিজাগার হেৎদ নিপিয়ায়, মেন্খান ইঙ্কূ ইনিকে গয়চ নাতিরাং কুরুমুটু কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","চিন্তং পাতিয়ান হাগাকু নিয়াটা সারিনামকেৎয়াকু, ইনিকে কৈসরিয়া শেহার নাগার তে ইদিকিয়াকু হেৎদ এন্ডে হাতেন তার্স শেহার রে কুলকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","এন্তে ইন্তং যিহূদীয়া, গালীল হেৎদ শমরিয়া রাঃআ যত টলা রে মণ্ডলী সুলুক হেৎদ হারা রাকাববেনাআ হেৎদ প্রভু রাঃআ বরতে হেৎদ রীলামালা আত্মা রাঃআ লোভানতে সেন সেনতে মন্ডলী গুঁডুররে গাদা লেকায়নাআ। ");
INSERT INTO cdz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","হেৎদ পিতর যত থাংরে ঘুরা ঘুরাতে লুদ্দা শেহার রে বাসায়ান তাহিয়ান ইশ্বর রাঃআ রীলামালা হড় কুরাঃআ হান্ডে সেএনায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","এন্ডে ইনি ঐনিয় নুতুমতে মিয়াৎ হড় লঅ নাপামেনায়, ইনি আটি সির্মাং বিছানারে তাহিন কেনায়, চিয়াচি ইনি রাঃআ অবস হড়ম হুইলেনা। ");
INSERT INTO cdz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","পিতর ইনিকে গামা কিয়ায়, ঐনিয়, যীশু খ্রীষ্ট আমকে বুগিকেৎ মেয়ায়, বিরিৎমে হেৎদ আমা পাটি কুড়াম মা। ইনাতে ইনি ইন্তংগে বিরিদেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ইন্তং লুদ্দা শেহার হেৎদ শারণ টলা রে বাসায়ান যত হড়কু ইনিকে নেল নাম কিয়াকু হেৎদ ইঙ্কূ প্রভু রাঃআ হান্তে রুয়াড়েনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","হেৎদ যোফা শেহাররে মিয়াৎ চেলা তাহীন কেনায় ইনিরা নুতুম টাবিথা, অনুবাদ লেংখান নিয়া নুতুম রাঃআ অর্থ গ্রীক নুতুম দরীকা (হরিণী), ইনি রেঙ্গেজকু রাঃআ নাতিরাং নানান সৎ কামী হেৎদ দানেৎ কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ইনা হুলাং ইনি রুআয়নায় হেৎদ গজেনায়, এন্ডে হড়কু ইনিকে উম কিয়াকু হেৎদ চেতাংরাঃআ অড়ারে দক্ষীণ দর বহঅ কাতে গিতিয় দঃহঅ কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","হেৎদ লুদ্দা যাফো শেহার রাঃআ কাতারে হুইয়েনতে হেৎদ পিতর লুদ্দারে মেনাইয়াআ আয়ুমকেৎ তেকু, যাফো রিঙ্কূ চেলা ইনিরা হান্ডে বার হড়কে কুলকেৎ কিনতেকু নিয়া গামকাতে নেহরা কিয়াকু \"কা দেরি কাতে আলেয়া হান্ডে হিজুম। ");
INSERT INTO cdz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","হেৎদ পিতর বিরিদেন্তে ইঙ্কূ লঅ সেনেনায়। চিন্তং ইনি সেটেরেনায়, ইঙ্কূ ইনিকে চেতাং রাঃআ অড়াতে ইদিকিয়াকু। হেৎদ যত রান্ডিকু ইনিরা চারুধার তিঙ্গুইয়েন তেকু ইয়াম লাগায় নাকু হেৎদ দরীকা ইঙ্কূলঅ তাহীন অক্ত অকা যত পাঞ্চি হেৎদ কিচি-সিনিব বানালাৎ আয়, ইনাকু যত উদু লাগায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ইন্তং পিতর যতচ কে অড়া বাহারতে উডুঙকেৎ কুয়ায়্য় য়, উকুড়ুমেনায় হেৎদ বিন্তিকেয়ায়, ইনা তায়ম ইনি গজিচ রাঃআ হান্তে ঘুরায়েন্তে ইনি গামকেয়ায় \"টাবিথা মা বিরিদমে। ইনাতে ইনি মেদ আরিৎ কেৎআয় হেৎদ পিতরকে নেলকিয়তে বিরিদ দুবেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ইন্তং পিতর তিহিতে ইনিকে বিরিৎ রাকাব কিয়ায় হেৎদ পাতিওয়ানকুকে হেৎদ রান্ডিকুকে রাঃআকেৎ কুতে জীউৎ উদুকেৎ কুয়ায়্য়য়। ");
INSERT INTO cdz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","নিয়া ঘটনা যাফো শেহার রাঃআ যত থাংরে পসরায়না হেৎদ গাদালেকা হড় প্রভুকে পাতিয়া কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","হেৎদ পিতর গাদামাহা যাকিৎ যাফোরে শিমন নুতুমান মিয়াৎ চামার হড় রাঃআ অড়ারে তাহীনলেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","কৈসরিয়া শেহার রে কর্নীলিয় নুতুমিজ মিহুড় হড় তাহীনকেনায়, ইনি ইতালী রিনিজ পাল্টন কুরাঃআ চাকি পতি তাহীনকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ইনি ঈশ্বর ভক্ত হেৎদ ঘারঞ্জ রিঙ্কূ যতচ কুলঅ ঈশ্বরকে মানাগুনাই কেনাকু, গাদা হড়কুকে ঢের উতার দানধানেৎ কুয়ায়্য় য় হেৎদ মিৎ মাহা গে ঈশ্বর রাঃআ হান্ডে বিন্তি কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","মিৎ মাহা সাবেম তারসিং আপি টাড়াং বেৎরাং কর্নীলিয় মিয়াৎ ভেট নেল নামলাৎ আয় যে ঈশ্বর রাঃআ মিয়াৎ সরগ নাঙ্গা ইনিরা হান্ডে হিচেন্তে গামকিয়ায় কর্নীলিয়, ");
INSERT INTO cdz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ইন্তং কর্নীলিয় ইনিরা হান্তে মিৎ ঢেকতে কয়অ কিয়তে বরলঅ গামকিয়ায় প্রভু কিনা নানামতানাম? সরগ নাঙ্গা ইনিকে গামকিয়ায় আমা বিন্তি হেৎদ আমা দান যত স্মারক নৈবেদ্য লেকাতে সেরমারে ঈশ্বর রাঃআ সামাংরে সেটেরাকানা। ");
INSERT INTO cdz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","নাহাআ আম যাফো শেহার তে হড় কুলকুম হেৎদ শিমোন অকয়কে পিতর গামিয়াকু, ইনিকে রাঃআ আগুইম। ");
INSERT INTO cdz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ইনি শিমোন নুতুমিজ মিহুড় মুচিরাঃআ অড়ারে মেনাইআ, ইনিরা অড়াদ দরেয়া কাতারে, ");
INSERT INTO cdz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","কর্নীলিয় লঅ অকা সরগ নাঙ্গা থুতিকেনায় ইনি সেনরাঃআ তায়ম কর্নীলিয় অড়া রিঙ্কূ চাকরকুরা তালাহাতেন বার হড়কে হেৎদ অকয় যত মাহা গে ইনিরা সেবায় কেনাকু, ইঙ্কূয়া মিয়াৎ ভক্ত সেনাকে রাঃআ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","হেৎদ ইঙ্কূকে যত থুতি গামকেৎ কুতে যাফোতে কুলকেৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","দশার হুলাং ইঙ্কূ হরা হরাতে সেন কেনাকু চিন্তং শেহার রাঃআ ঠাইনতে সেটেরেনাকু, ইন্তং পিতর ছাদ চেতাংরে বিন্তি নাতিরাং রাকাববেনায় সব্তাম তিকিন গেলেবার বাতিরাং। ");
INSERT INTO cdz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ইনিকে রেঙ্গেজ কিচখান হেৎদ হুডাং যাহানা জমা নানাম কেনায়। মেন্খান চিন্তং হড়কু জমা বাইএ কেনাকু, এনকান ইন্তং গে ইনি ছানেনায়, ");
INSERT INTO cdz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","হেৎদ নেল কেয়ায়, নিরালা হলেজাকানা হেৎদ মিয়াৎ মারাং চাদর আড়গু হিজু তানা ইনারা উপুনিয়া টুনি সাবকাতে ধার্তিরে আড়গু হুইওতানা; ");
INSERT INTO cdz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","হেৎদ ইনারে ধার্তি রিঙ্কূ যত ধরন জানোয়ার,কিদিং হেৎদ নিরালা রিঙ্কূ অড়ে মেনাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","তায়মতে ইনিরা হান্ডে নিরালা হাতেন নিয়া জাগার হুইয়েনা বিরিদমে পিতর \"গজকুম হেৎদ জমকুম। ");
INSERT INTO cdz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","মেন্খান পিতর গাম রুয়াড় কেৎয়ায়, প্রভু এনকা আল হুইয়ওকা, ইঞ যাহাহুলাং যাহানা হঅ অরীলামালা হেৎদ অছুথী জিনিস কাইঞ জমতাৎ কুয়া (লেবি . 11:1-47, যেহিকি . 4:14) ");
INSERT INTO cdz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ইন্তং দোহরা অটঃহঅ নিয়া আড়াঙ হুইয়েনা, ঈশ্বর অকা ছুত তাৎ কুআয়, আম ইনা অরীলামালা আলম গামেয়া, ");
INSERT INTO cdz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","নেকাগে আপি সাআ হুইয়েনা, তায়মতে অটগে ইনা চাদরটা চেতাংতে রাকাব ইমাহা। ");
INSERT INTO cdz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","পিতর অকা ভেট নামলাৎ আয়, ইনারাঃআ অর্থ কিনা হুই দাড়িয়া, নিয়া বাবত তে মনে মনে পাহাম মেকেনায় গটা ইন্তংগে নেলেপে, কর্নীলিয় রাঃআ কুলিচ হড়কু শিমোন রাঃআ অড়া পাঞ্জাকেৎ তেকু দুয়ার রাঃআ কাতারে হিচেন্তে তিঙ্গুইনাকু, ");
INSERT INTO cdz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","হেৎদ রাঃআ কিয়তেকু কুলিকিয়াকু, শিমোন অকয়কে পিতর গামিয়াকু, ইনি কি নেন্ডে তাহিনায়? ");
INSERT INTO cdz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","পিতর ইনা ভেট রাঃআ বাবত তে পাহামেৎ কেনায়, এনকান রিলামালা আত্মা গামকিয়ায়, নেলেম আপি হড় আমকে পাঞ্জাম তানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","মেন্খান আম বিরিদকাতে লাতারতে সেনম, ইঙ্কূ লঅ সেনম, যাহানা হঅ আলম সন্দেহআ চিয়াচি ইঞগে ইঙ্কূকে কুলতাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ইন্তং পিতর ইঙ্কূ হড়কুরা হান্ডে আড়গুন্তে গাম্কেৎ কুয়ায়্য় য়, নেলেপে আপে অকয়কে পাঞ্জাই তানাপে, ইঞ ইনি হড় তানাইঞ, আপে কিনা নাতিরাং হিচাকানাপে? ");
INSERT INTO cdz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ইঙ্কূ গামকেৎয়াকু, মিহুড় চাকিপতি কর্নীলিয় নুতুমতে চিহ্নাইয়া, মিয়াৎ ধার্মিক হড়তানায়, অকয় ঈশ্বরকে বরইআয় হেৎদ যত ইহুদি জাতি কু রাঃআ তালারে নুতুমান হড়, ইনি রীলামালা সরগ নাঙ্গা রাঃআ দ্বারায়তে এনকান হুকুম নামতাৎআয়, যেন আমকে রাঃআ কাতেন নিজে রাঃআ অড়াতে আউকাতে আমা মচা রাঃআ থুতি আয়ুমেকা আয়। ");
INSERT INTO cdz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ইন্তং পিতর ইঙ্কূকে ভীতিরতে রাঃআ ইদিকেৎ কুতে ইঙ্কূকে নেল-আতেন কেৎকুয়ায়্য়। দশার হুলাং বিরিদেন্তে ইনি ইঙ্কূ লঅ সেএনায়, হেৎদ যাফোত শেহার রিঙ্কূ হাগাকু রাঃআ তালা হাতেন কথক হড় ইঙ্কূ লঅ সেএনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","দশার হুলাং ইঙ্কূ কৈসরিয়া শেহার শেহারতে বলয়নাকু; ইন্তং কর্নীলিয় নিজে রাঃআ হড়কুকে হেৎদ গাতিকুকে মিৎ থাংতে রাঃআ কেৎ কুতে ইঙ্কূয়া তাঙ্গিরে তাহীন কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","তায়মতে পিতর চিন্তং বলয়নায়, ইনা হুলাং কর্নীলিয় ইনি লঅ নাপামেন্তে ইনি রাঃআ কাটারে নুরেন্তে জোহার কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","মেন্খান পিতর ইনিকে রাকাব কিয়ায়, গামকিয়ায় বিরিদমে, ইঞ নিজেহঅ আমলেকা মিয়াৎ মান্মি তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ইনাতায়ম পিতর কর্নীলিয় লঅ থুতি থুতিতে বলয়েন্তে নেলকেৎ কুয়ায়্য়, গাদালেকা হড় হুন্ডিয়া কানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ইন্তং ইনি ইঙ্কূকে গামাৎ কুয়ায়্য় য়, আপে সারিয়াপে, এটা জাতি লঅ সাথ এমঃঅ হেৎদ ইনিরা হান্ডে হিজু ইহুদি হড় রাঃআ পক্ষে আরিচালি রাঃআ বাহাররে, মেন্খান ইঞকে ঈশ্বর উদুয়া তিঞআয় যে, যাহা মান্মিকে অধার্মিক বাংখান অছুথী গাম লাক্তি লহয় তানা। ");
INSERT INTO cdz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","নিয়া নাতিনাং ইঞকে রাঃআ কুল কিঞাআপে খান ইঞ যাহানা হঅ কা আপত্তি কাতে হিচা কানাঞ; নাহাআ কুলি লেপে য়াইঞ, আপে কিনা নাতিরাং ইঞকে রাঃআ কুলতিঞাপে? ");
INSERT INTO cdz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ইন্তং কর্নীলিয় গামকেয়ায়, তিহিঞ লঅ উপুন মাহা হুইওতানা, ইঞ নিয়া মাহা যাকিৎ নিজে রাঃআ অড়ারে বেলা প্রায় তিকিন তারসিং আপি টাড়াং বাতিরাং বিন্তি কেনাঞ, ইনা হুলাং মিয়াৎ কড়াহন জুলুতান সনঃঅ তুসিংকাতে ইঞা সামাংরে রে তিঙ্গুইনায়; ");
INSERT INTO cdz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ইনি গামকেয়ায়, কর্নীলিয়, আমা বিন্তি আতাং হুইয়াকানা হেৎদ আমা দান যত ঈশ্বর রাঃআ সামাংরে সদরা কানা। ");
INSERT INTO cdz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","এন্তে যাফো শেহারতে হড় কুলকাতে শিমোন অকয়কে পিতর গামিয়াকু, ইনিকে রাঃআ আগুই; ইনি গাডা কাতারে সিমন চামার রাঃআ অড়ারে মেনাইয়াআ। ");
INSERT INTO cdz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","নিয়া নাতিরাং ইঞ ইনতংগে আমা হান্ডে হড় কুল কেৎ কুয়াইঞ, আম হিচা কানাম বেচাকি াৎ আম, এন্তে নাহাআ আবু যতচ ঈশ্বর রাঃআ সামাংরে সেটের মেনাবুয়া, প্রভু আমকে অকা হুকুম এমাতাৎ মায়, ইনা আয়ুমেয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ইনাতায়ম পিতর আয়া মচা হলেজকেৎ তে ইঙ্কূকে গামলাগায়নায় সার্তিগে ইঞ আটকার নাম কেয়াইঞ যে ঈশ্বর যাহায় রাঃআ মচা নেলকাতেন কায় দরবার রেআয় (বারগাম . 10:17, 2 ইতি . 19:7) ");
INSERT INTO cdz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","মেন্খান যত জাতি রাঃআ তালা হাতেন যাহায়গে ইনিকে গুনমান্তিয়া আয় হেৎদ ধার্মিক হরাতে সেসেনায়, ঈশ্বর ইনিকে আপনারিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","আপে সারিয়াপে যে ইনি খেরোয়াল হড়কুরা হান্ডে মিয়াৎ জাগার ঘোষণা তাৎআয়, চিন্তং ইনি যীশু খ্রীষ্টরাঃআ দ্বারায়তে সুলুকরাঃআ বুগিনবার্তা পাসনা তাৎআয়, অকয় যতচ রাঃআ প্রভু (দুরাং মালা . 107:20, দুরাং মালা . 147:18, জিসাই. 52:7, নহুম 1:15) ");
INSERT INTO cdz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","আপে যতচ নিয়া ঘটনা সারিয়াপে, অকা যোহনরাঃআ দ্বারায়তে পাসনাৎকান ডুবুলরাঃআ তায়ম গালিলমুলুক হাতেন এহব কাতেন গোটা ইহুদিয়া মুলুক তে পাসরায়না; ");
INSERT INTO cdz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","নাসরতীয় যীশু রাঃআ থুতি, চিল্কা ঈশ্বর ইনিকে রীলামালা আত্মাতে হেৎদ দাড়িতে গসঃঅ লিয়ায়, বুগিন কামী ভাড়ায়কেনায় হেৎদ শয়তান দ্বারায়তে রুয়া-হাসু তান যত হড়কুকে বুগিৎ কেনকুয়ায়্য়য়; চিয়াচি ঈশ্বর ইনি লঅ তাহীলেনায় (জিসাই. 61:1) ");
INSERT INTO cdz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","হেৎদ ইনি ইহুদি রাঃআ হরাকুরে হেৎদ যিরুশালেম শেহার রে অকা অকা করাতাৎআয়, ইনা যতচ রাঃআ লুকুন্দী ী, অট হড় ইনিকে ক্রসরে টাঙ্গাকাতে গজকিয়াকু (বারগাম) ");
INSERT INTO cdz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ইনিকে ঈশ্বর আপি মাহারে রাকাবকিয়ায়, প্রমাণ কাতে উদু কেৎকুয়ায়্য় যত হড়কুরা হান্ডে এনকা লহয়, ");
INSERT INTO cdz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","মেন্খান মাড়াঙতে ঈশ্বর রাঃআ দ্বারায়তে বাছায়ান লুকুন্দী কু, অর্থাৎ আলেকে উদু-সদর কেৎ লেয়ায়, হেৎদ গজকুরা তালা হাতেন ইনিরা জিউত-রাকাব তায়ম খানঃগে ইনি লঅ আলে জম হেৎদ নুঃউকেয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","হেৎদ ইনি হুকুমকেৎকুয়ায়্য়, যেন আলে হড়কুরা হান্ডে পাসনা কায়লে হেৎদ লুকুন্দী এমেয়ালে যে, হানিগে ইনি হড়তানায় অকয়কে ঈশ্বর জীউৎ হেৎদ গজকুরা দরবার জ বহালতিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ইনিরা নাতিরাং যত ভবিষৎ গাময়ানকু নিয়া লুকুন্দী এমেয়াকু, যাহায়গে ইনিকে পাতিয়াইআকু, ইনি ইনিরা নুতুমরা গুণতে কাই রাঃআ ছেমা নামেআয় (জিসাই , জিসাই , জেরামিয়া. 31:34, দানিয়েল . 9:24) ");
INSERT INTO cdz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","পিতর নিয়া থুতি গামলাৎ আয় গটা ইনা হুলাং চিন্তিলেকা হড় জাগার আয়ুমলাআকু, যতচ রাঃআ চেতাংরে রীলামালা আত্মা আড়গু হিচেনা। ");
INSERT INTO cdz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ইন্তং পিতর লঅ হিচাকান পাতিয়ান সুন্নু চুটি -গেৎ হড় যত হায়কাটেনাকু, চিয়াচি বিন-ইহুদিকুরা চেতাংরেহঅ রীলামালা আত্মা দান এমঃঅ হুইয়েনা; ");
INSERT INTO cdz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","চিয়াচি ইঙ্কূ ইঙ্কূকে নাআহানা জাগারতে থুতি গামঃঅ হেৎদ ঈশ্বর রাঃআ মহিমা দুরাং আয়ুমকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","'নিকু যে হড়কু আলে লেকাগে রীলামালা আত্মা নামতাৎআকু, যাহায় কি নিকুকে দাঃআরে ডুবুল এমঃতে বাধা এম দাড়িকুয়াকু? ");
INSERT INTO cdz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","তায়মতে ইনি ইঙ্কূকে যীশু খ্রীষ্ট রাঃআ নুতুমতে ডুবুল এমঃরাঃআ হুকুম এমকেৎকুয়ায়্য়। ইন্তং ইঙ্কূ কথক মাহা পিতর কে তাহি নাতিরাং নেহরাকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","নাআহাআ কুলিচ কু হেৎদ ইহুদিয়া মুলুক টলা রিঙ্কূ পাতিয়ান হাগাকু আয়ুম নামকেৎয়াকু যে, অইহুদি হড়কুহঅ ঈশ্বর রাঃআ জাগার আতাং তাৎআকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","হেৎদ চিন্তং পিতর যিরুশালেম শেহার তে হিচেনায়, ইন্তং সুন্নু চুটি -গেৎ ইহুদি পাতিয়ানকু ইনিকে দোষীকাতে গামকিয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","আম সুন্নু চুটি -কাগেৎ অইহুদি পাতিয়ানকুরা অড়াতে সেনাকানাম, হেৎদ ইঙ্কূ লঅ জমা জম তাৎ আম। ");
INSERT INTO cdz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","মেন্খান পিতর ইন্তং ইঙ্কূকে মাড়াঙ রাঃআ ঘটনা বেশলেকা বুঝাকেৎ কুয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","গামকেয়ায়, ইঞ যাফো শেহার রে বিন্তিৎ কেনাইঞ, এনকান মাহারে বেহুঁশেন্তেঞ মিয়াৎ ভেট নামকেয়াইঞ, নেল কেয়াইঞ, মিয়াৎ মারাং চাদর লেকা যাহান মিয়াৎ আড়গু হিচে না, অকারা উপুন টুনি রে সাবকাতে নিরালা হাতেন আড়গু হুইওতানা হেৎদ ইনাটা ইঞা হান্ডে হিচেনা। ");
INSERT INTO cdz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ইঞ ইনা রাঃআ হান্তে মিৎ ঢেকতে কয়ঃঅ কাতেইঞ পাহাম লাগায়নাইঞ, হেৎদ নেলকেয়াইঞ, ইনারা তালারে ধার্তি রিঙ্কূ উপুন কাটায়ান জানোয়ার হেৎদ বির রিঙ্কূ জানোয়ার, কিদিং হেৎদ নিরালা রিঙ্কূ অড়েকু মেনাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","হেৎদ ইঞ মিয়াৎ রাহা আয়ুম কেৎয়াইঞ, অকা ইঞকে গামকিঞায়, বিরিদমে, পিতর, গজকুম হেৎদ জমকুম। ");
INSERT INTO cdz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","মেন্খান ইঞ গামরুয়াড় কেৎআইঞ, প্রভু, এনকা আল হুইঅকাআ, চিয়াচি অরীলামালা চি অছুথী যাহান জিনিসরে ইঞ তিহি কাইঞ জুটেৎ তাৎ আঞ চি জমতাৎ কুইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","মেন্খান দঃহরাসা নিরালা হাতেন নিয়া রাহা হুইয়েনা, ঈশ্বর অকা ছুথী তাৎআয়, আম ইনা অছুথী আলম গামেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","নেকা গে আপিসা হুইয়েন খানঃ, তায়মতে ইনা যত অটঅ নিরালাতে গহাড় ইদিকেৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","হেৎদ নেলকেৎ আইঞ, চিদগি কাতে আপিহড় কড়াহন, অকা অড়ারে আলে তাহীলেনালে, এন্ডেটা হিচেন্তেকু তিঙ্গুইনায়, কৈসরিয়া শেহার হাতেন ইঞা হান্ডে কুল হুইলেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","হেৎদ রিলামালা আত্মা ইঞকে কা সন্দেহ কাতে ইঙ্কূ লঅ সেন গামকিঞায়। হেৎদ নিকু তুরুই হাগাকু হঅ ইঞ লঅ সেএনাকু। হেৎদ আলে ইনি হড় রাঃআ অড়াতে সেএনালে। ");
INSERT INTO cdz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ইনি আলেকে গামাৎ লেআয় যে, ইনি মিয়াৎ সরগ নাঙ্গা রাঃআ ভেট নামলাৎ আয় ইনি সরগ নাঙ্গা ইনিরা অড়ারে তিঙ্গুয়েনতে গামকেৎয়ায়, যাফোরে হড় কুলকাতে শিমোনকে রাঃআ আগুইম, অকয় রাঃআ এটা নুতুম পিতর তানা; ");
INSERT INTO cdz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ইনি আমকে এনকান থুতি গামামেআয়, অকা দ্বারায়তে আম হেৎদ আমা যত অড়াহড় আওসান নামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","তায়মতে ইঞ থুতি গাম লাগায়নাইঞ খানঃ, ইঙ্কূয়া চেতাংরেহঅ রীলামালা আত্মা হিচ লেনা, চিল্কা আলেয়া চেতাংরে মাড়াঙতে হুইলেনা। ");
INSERT INTO cdz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ইনাতে প্রভু রাঃআ থুতি আলেয়া পাহাম হিচেনা, চিল্কা ইনি গামলাৎ আয়, যোহন দাঃআরে ডুবুল কেৎকুয়ায়্য় য়, মেন্খান আপে রীলামালা আত্মাতে ডুবুল নামেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","এন্তে, ইঙ্কূ প্রভু যীশু খ্রীষ্টরে পাতিয়ান হুইও রাঃআ তায়ম, চিল্কা আলেকে এনকা ইঙ্কূ কেহঅ ঈশ্বর সমান আশিষ এমকেৎ কুয়ায়্য়, ইন্তং ইঞ অকয় যে ঈশ্বরকে এটকে টড়েৎ এম দাড়িয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","নিয়া যত থুতি আয়ুম কাতে ইঙ্কূ হাপেনাকু হেৎদ ঈশ্বর রাঃআ গৌনজহার কেৎয়াকু, গামকেৎয়াকু, এন্খান মা তো ঈশ্বর অইহুদি রিঙ্কূ হড়কু রাঃআ হঅ জীউ রাঃআ নাতিরাং মন পাল্টা রাঃআ সুযোগ করাতাৎ কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ইনা ঘাড়িগে স্তিফান গজঃঅরাঃআ তায়ম পাতিয়ান কুরাঃআ যে সাতাও হুইলেনা, ইনা নাতিরাং যতচ যিরুশালেম শেহার হাতেন নাতেহান্তে ছিতি বিতিইনাকু, ইঙ্কূ ফৈনীকিয়া টলা, কুপ্রঢিপ, হেৎদ আন্তিয়খিয়া শেহার যাকিৎ গোটা দাড়াকেৎ তেকু একেন ইহুদিকুরা হান্ডে জাগার বুগিনবার্তা পাসনা লাগায়নাকু অট এটা যাহায়কে লহয়। ");
INSERT INTO cdz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","মেন্খান ইঙ্কূ য়া তালারে কথক হড় কুপ্রীয় হেৎদ কুরিনিয় হড় তাহীনকেনাকু, ইঙ্কূ আন্তিয়খিয়াতে হিচে ন্তেকু গ্রিককু রাঃআ হান্ডে গামকেৎয়াকু হেৎদ প্রভু যীশু রাঃআ বাবত তে বুগিন বার্তা পাসনা কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","হেৎদ প্রভু রাঃআ তিহি ইঙ্কূ য়া চেতাংরে তাহীনকেনা হেৎদ গাদা হড় পাতিয়ানতেকু প্রভু রাঃআ হান্ডে রুয়াড়েনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","তায়মতে ইঙ্কূ য়া বাবত তে যিরুশালেম শেহার রাঃআ মন্ডলী রেঙ্কূ হড়কু সারিকেৎয়াকু, নিয়া নাতিরাং নিকু আন্তিয়খিয়া শেহার যাকিৎ বার্ণবাশ কে কুলকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","চিন্তং ইনি নিজে হিচ কাতে ঈশ্বর রাঃআ দায়া-দুলাড় নেলকেআয়, ইনি রাসকায়নায়, হেৎদ ইনি ইঙ্কূকে উৎসাহ এমঃঅ লাগায়নায় যেন ইঙ্কূ গোটা অন্তর দিয়া প্রভুরে মেশা তাহীনাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","চিয়াচি ইনি বার্ণবাশ সৎহড় হেৎদ রীলামালা আত্মাতে হেৎদ পাতিয়াতে পেরেজ তাহীনকেনায়। হেৎদ গাদা হড় প্রভুরে মেশা তাহী নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","তায়মতে ইনি শৌলকে পাঞ্জা নাতিরাং তার্ষতে সেএনায়। ");
INSERT INTO cdz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ইনি চিন্তং ইনিকে নাম কিয়ায়, হানি ইনিকে আন্তিয় খিয়াতে আউকিয়ায়। হেৎদ ইঙ্কিন পুরা মিৎ সির্মাং যাকিৎ মন্ডলীরে নাপামো কেনাকিন হেৎদ গাদা হড়কে চেচেদ এমকেৎ কুয়াকিন, হেৎদ আন্তিয় খিয়ারেগে চেলাকু খ্রীষ্টান মেন্তে এহবরে নুতুম লাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","নাহা ইনা হুলাং কথক হড় ভাবিজাগারিজ যিরুশালেম শেহার হাতেন আন্তিয়খিয়াতে হিচেনা কু। ");
INSERT INTO cdz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ইঙ্কূ য়া তালা হাতেন আগাব নুতুমিজ মিহুড় রাকাবেন্তে আত্মা দ্বারায়তে সারিতুকাৎ কুয়ায়্য় য় যে, গোটা ধার্তিরে মিয়াৎ মারাং আকাল হুইওয়া, ইনা রোম শেহার রাপাজা ক্লৌদিয় রাঃআ শাসন কালরে ঘটালেনা। ");
INSERT INTO cdz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ইনাতে চেলাকু, যতচ আকু আকুয়া সামর্থ্য লেকাতে, ইহুদিয়া মুলুক রেঙ্কূ পাতিয়ান হাগাকুকে সেবা রাঃআ নাতিরাং দেঙ্গা কুল গটা কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","হেৎদ এনকা লেকাগে কামীহঅ পুরা কেৎয়াকু, বার্ণবাশ হেৎদ শৌল রাঃআ তিহিতে মুরুব্বিকু রাঃআ হান্ডে কাউডি কুলকেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","নাহাআ, ইনা হুলাং হেরোদ রাপাজ মন্ডলী রিঙ্কূ কথকহড় রাঃআ চেতাংরে সাতাও নাতিরাং তিহি রাকাব কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ইনি যোহন রাঃআ দাদাতেৎ যাকোবকে ছরাতে গজকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ইনাতে ইহুদি গংকেকু কুশিনাকু নেলকেৎকু খানঃঅ ইনি অটঃঅ পিতরকেহঅ সাবকিয়ায়। ইন্তং বিন-তাড়ি (সাক্রাত-পরব) পরব মাহা তাহিনকেনা। হানি ইনিকে সাবকিয়তে জিহালরে দঃহঅ কিয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","হেৎদ ইনিকে হর নাতিরাং উপুন হড় কাতে উপুনিয়া হুডিং হর দল, এনকান উপুনিয়া পাল্টন দল রাঃআ হান্ডে আড়া গিডিকিয়ায়, মনে কেয়ায়, সাক্রাত-পরব রাঃআ তায়ম ইনিকে হড়কুরা হান্ডে হাজিরিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","এন্তে পিতরকে জিহালরে আটক দঃহ হুইলেনায়, মেন্খান মন্ডলী ইনি রাঃআ নাতিরাং ঈশ্বর রাঃআ হান্ডে আগ্রহ লেকাতে বিন্তিইকেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","তায়মতে হেরোদ অকাহুলাং ইনিকে বাহারতে আগুইআয়, ইনা হুলাং আয়ুব বেত্রাং পিতর বার হড় সেনাকিন রাঃআ তালারে বারিয়া ঝিনঝিরিতে আটক কাতে গিতিচ লেনায় হেৎদ দুয়ার সামাংরে হরলাৎআকু। ");
INSERT INTO cdz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","নেলেপে, ইনা হুলাং প্রভু রাঃআ মিয়াৎ সরগ নাঙ্গা ইনিরা হান্ডে হিচেন্তে তিঙ্গুইনায় হেৎদ জিহাল অড়া মার্শাললেনা। ইনি পিতরকে হাতালাৎ লাতাররে তাপড়ি কিয়তে চির্গালকাতে গামকিয়ায়, ঘিড়মেন্তাং বিরিৎমে। ইন্তং ইনিরা বারতিহি হাতেন ঝিনঝিরি হলেজেনা। ");
INSERT INTO cdz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","তায়মতে ইনিকে সরগ নাঙ্গা গামকিয়ায়, মায়াং আটক ম হেৎদ আমা খড়ম তুসিংঅম, ইনি ইন্তং ইনা করাকেয়ায়। তায়মতে সরগ নাঙ্গা ইনিকে গামাকিয়ায়, হড়মোরে কিচি এমকাতে ইঞা তায়ম তায়মতে হিজুম।নেকা লেকাতে ইনি রুক্ষীয়া নাম কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ইনাতে ইনি উডুঙয়েন্তে ইনিরা তায়ম তায়মতে সেনঃঅ লাগায়নায়, মেন্খান সরগ নাঙ্গা রাঃআ দ্বারায়তে অকা করা হুইলেনা, ইনা যে সার্তি, ইনা ইনি কায় সারি নামলাৎ আয়, বরঞ্চ মনেকেয়ায়, ইনি কুকুমু নেলেতানায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","হেৎদ ইনকিন এতব হেৎদ দশরা হরয়ানকু রাঃআ দল তায়ম গিডিকাতে, মেড়হেৎ রাঃআ দুয়ার কাতাতে হিচেনা কিন, কথাং হরকাতে শেহার তে সেনঃঅ হড় য়া, ইনা দুয়ার রাঃআ কবাট আয়তেগে হলেজেনা, ইনাতে ইনকিন উডুঙয়েন্তেকিন মিয়াৎ হরা রাঃআ মুকাম যাকিৎ সেনেঃএ নাকিন। হেৎদ আচকা গে সরগ নাঙ্গা ইনিরা হান্ডে হাতেন ছানেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ইন্তং পিতর আটকার নামকেৎ তে গামকেয়ায়, নাহাআ ইঞ আটকার নামকেয়াইঞ, প্রভু নিজে সরগ নাঙ্গা কে কুলকিয়ায়, হেৎদ হেরদ রাঃআ তিহি হাতেন হেৎদ ইহুদি হড়কুরা যত মনেরাঃআ আশা হাতেন ইঞকে রুক্ষীয়া কিঞাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","নিয়া ব্যপারতে থুথীজাগার কাতে ইনি মরিয়ম রাঃআ অড়া দর সেএনায়, হানি ইনি যোহন রাঃআ মাইতেত, অকয় রাঃআ নুতুম মার্ক, এনথাংরে গাদালেকা হুন্ডি লেনাকু হেৎদ বিন্তিই কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","হেৎদ ইনি বাহার রাঃআ কবাটরে ঠেলা কেয়ায় খানঃঅ রোদা নুতুমিজ মিয়াৎ মুনিশ আয়ুম নামকেয়ায়; ");
INSERT INTO cdz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","হেৎদ পিতর রাঃআ রাহাআ পাছনাকেৎ তে রাসকাতে কবাট কায় নিজলাৎ আয়, মেন্খান ভিতিরতে সেনকাতে বার্তা এমকেৎ কেয়ায়, পিতর দুয়ার সামাংরে তিঙ্গুয়াকানায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","হেৎদ ইঙ্কূ ইনিকে গামকিয়াকু, আম পাগলিয়া কানাম, মেন্খান ইনি মনেরাঃআ দাড়িতে গাম লাগায়নায়, ল্হয়, নিয়াটাগে সার্তি তানা। ইন্তং ইঙ্কূ গামকেৎয়াকু, হানি ইনিরা সরগ নাঙ্গা তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","মেন্খান পিতর ঠেলা লাগায়নায়, ইন্তং ইঙ্কূ কপাট নিচ কাতে ইনিকে নেলকিয়াকু হেৎদ হায়কাটেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ইনাতে ইনি তিহি দিয়া যতচ কে থির তাহিরাঃআ ইশারা কেৎ কুয়ায়্য় য় হেৎদ প্রভু চিল্কা ইনিকে জিহাল হাতেন ছাডা আউতিয়ায়, ইনা ইঙ্কূ য়া হান্ডে গাম সদর কেৎকুয়ায়্য়, অটঅ নিয়াহঅ গামাৎ কুয়ায়্য় য়, আপে যাকোবকে হেৎদ পাতিয়ান হাগাকুকে নিয়া বার্তা এমা কূপে, তায়মতে ইনি উডুয়েন্তে এটা জায়গাতে সেএনায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","নাহা, চিন্তং আঙ্গেনা, এনথাংরে পাল্টন কুরা তালারে যাহানা ইতিজ-তরাং হুইহাল্লা কা তাহিলেনা, পিতর রাঃআ বাবত তে অকাগে ঘটালেনা। ");
INSERT INTO cdz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","তায়মতে হেরোদ ইনিকে পাঞ্জা নাতিনাং পাল্টন কুকে কুল কেৎকুয়া হেৎদ ইনিকে কায় নামলিয়ায়, কা নামকিয়ায় খানঃঅ হরয়ানকুকে কুলিকেৎ কুতে ইঙ্কূ কে গচ রাঃআ নাতিরাং হুকুম এমকেৎকুয়ায়্য় হেৎদ পিতর ইহুদিয়া মুলুক টলা হাতেন উডুয়েন্তে কৈসরিয়া শেহার রে বাসায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","হেৎদ ইনি সোরীয় হেৎদ সীদোন শেহার ীয় কুরা চেতাংরে কুঠিন রাগালেনায়, মেন্খান ইঙ্কূ মিৎ মতেএন্তেকু ইনিরা হান্ডে হিচেনা কু হেৎদ রাপাজ রাঃআ গীতিজ অড়া রিনিজ গমকে ব্লাস্তকে ফুশলাকিয়তে নিজে রাঃআ হান্তে আগু কাতে মেশা নাতিরাং নেহর কিয়ায়। ইন্তং ইঙ্কূ সুলুক নানামেনাকু, চিয়াচি রাপাজ রাঃআ দিশুম হাতেন ইঙ্কূ য়া দিশুমতে জমা হিজু কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ইন্তং মিয়াৎ নির্দিষ্ট হুলাং হেরোদ রাপাজ রাঃআ কিচি সিনিব তুসিংকাতে দরবার রাঃআ আসনরে দুবকাতে ইঙ্কূয়া হান্ডে ভাষণ এমকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ইন্তং হড়কু জোরতে কিকিচকাতে গামকেৎয়াকু, নিয়া দেবতারাঃআ রাহাতানা, মান্মিরাঃআ লহয়। ");
INSERT INTO cdz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","হেৎদ প্রভু রাঃআ মিয়াৎ সরগ নাঙ্গা ইনা ঘাড়িগে ইনিকে দালকিয়ায়, চিয়াচি ইনি ঈশ্বরকে গৌনজহার কায় এমালিয়ায়, হেৎদ ইনিরা হড়মো তিজুকু জমকিয়ায় খানঃঅ গজেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","মেন্খান ঈশ্বর রাঃআ জাগার বাড়ায়না হেৎদ গোটা পাসরায়না। পাতিয়ান কুহঅ বাড়ায়না। ");
INSERT INTO cdz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","হেৎদ বার্ণবা হেৎদ শৌল আকিনা সেবাকামি চাবা কেৎতিকিন যিরুশালেম শেহার হাতেন সেনেনাকিন, যোহন, অকয় রাঃআ নুতুম মার্ক, ইনিকে আকিন লঅ ইদিধরা কিয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","নাহা আন্তীয়খিয়ারা মন্ডলীরে বার্ণনা, শিমোন, অকয়কে নিগের গামিয়াকু কুরিনীয় রিনিজ লুকিয়, মনহেম (অকয় হেরোদ রাপাজ রাঃআ আসুল হারা বকতেদ) হেৎদ শৌল নুতুমান কথক হড় ভাবিজাগারিজ হেৎদ চেচেদিজ তাহিনকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ইঙ্কূ প্রভু রাঃআ হমর বিন্তি হেৎদ বারে কেনাকু, এনকান মাহারে প্রভু রাঃআ রিলামালা আত্মা গামকেয়ায়, ইঞ বার্ণবা হেৎদ শৌলকে অকা কামী মেন্তে রাঃআ তাৎ কিনাইঞ, ইনা কামী ইঞা নাতিনাং ইনকিনকে ভিনা কাতে দঃহ কিনপে। ");
INSERT INTO cdz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ইন্তং ইনকিন দরবার রাঃআ তায়মতে বার হেৎদ বিন্তি কেয়াকিন হেৎদ নিকু হড়কু রাঃআ চেতাংরে তিহি দঃহ কেয়ায় ইঙ্কূকে কয়্তুকা কেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","নেকাগে রীলামালা আত্মা ইনকিনকে সিলুকিয়া নাগার তে কুলকেৎ কিনায় হেৎদ এন্ডে হাতেন জাহাজতে কুপ্রঢিপ সেনেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ইঙ্কিন সালামি শেহার তে সেটেরেনাকিন হেৎদ এন্ডেটা ইহুদীকুরা মন্ডলীরে ঈশ্বর রাঃআ জাগার পাসনা লাগায় নাকিন হেৎদ যোহন মারক দেঙ্গাইচ লেকা সাথ এমকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","হেৎদ ইনকিন যত ঢিপ ঘুরাকাতে পাফঃ নাগার তে সেটেরেনা কিন। এনথাংরে ইনকিন মিয়াৎ ইহুদি পাইটকর হেৎদ ভন্ড ভাবিজাগারিজকে নেল নামকেৎ কিনাকিন, ইনিরা নুতুম ;বর-যিসু; ");
INSERT INTO cdz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ইনি মুলুক পাল সের্গিয় পল লঅ তাহীন কেনায়, ইনি মীহুড় বুদ্ধিমান হড়। ইনি বার্ণবা হেৎদ শৌলকে ঠাইনতে রাঃআ কেৎকিনায় হেৎদ ঈশ্বর রাঃআ জাগার আয়ুম নানামেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","মেন্খান ইলুমা, ইনি পাইটকর (জুগনি (নেকাগে এলিমা গ্রীক নুতুম রাঃআ অনুবাদ করা হুইয়াকানা) ইঙ্কিন বিরুধে কেনায়; ইনি কুরুমুটু কেনায় যেন মুলুক পাল পাতিয়া হাতেন মচা রুয়াড়ে কাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","মেন্খান শৌল অকয়কে পৌল গামিয়াকু, ইনি রীলামালা আত্মাতে পেরেজেন্তে ইনিরা হান্তে মিৎ ঢেকতে কয়ঃঅ কিয়তে গামকিয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","আম যত চাল-চালাকিতে হেৎদ খারাপ পাইরকাতে পেরেজেকানাম, শয়তান রাঃআ হন, আম যতরকম ধার্মিকতা রাঃআ চাকি, আম প্রভু রাঃআ সজেহে হরাকু বাঁকাতে কি কাম বাগিয়া? নীতি . 10:9, হোশেয় 14:9) ");
INSERT INTO cdz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","নাহা নেলেম, প্রভু রাঃআ রাগ তিহি আমা চেতাংরে মেনা, আম কাঁড়াম, কথক মাহা বেলা কাম নেলনামিয়াম। হেৎদ সাতে সাথ ইনি রাঃআ চেতাং মিয়াৎ নুম্বা আড়গু হিচেনা, ইনাতে ইনি তিহি সাবকাতে তাড়ম হড়কে পাঞ্জা নাতিনাং নাতেহান্তে তাড়ম ভাড়াকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ইন্তং মুশিং রোম শেহার রাঃআ শাসক ইনা ঘটনা হেৎদ প্রভু রাঃআ আনচু আয়ুমকাতে আকাদান্দায়নায় হেৎদ পাতিয়ায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","পৌল হেৎদ ইনিরা গাতিকু পাফঃ শেহার হাতেন জাহাজতে পামফুলিয়া দিশুম রাঃআ পার্গা শেহার তে সেটেরেনাকু। ইন্তং যোহন মার্ক ইঙ্কিন কে বাগিকাতে হেৎদ যিরুশালেম শেহার তে রুয়াড় সেএনায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","মেন্খান ইঙ্কিন পার্গা হাতেন মাড়া য়েন্তেকিন পিসিদিয়া দিশুম রাঃআ আন্তীয়খিয়া শেহার তে সেটেরেনা কিন, হেৎদ ঝিরাও মাহাহুলাং (হাপ্তারাঃআ মুচাৎ হুলাং) ইনকিন সমাজ-অড়ারে সেনকাতে দুবেনা কিন। ");
INSERT INTO cdz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","আরিচালি হেৎদ মসি রাঃআ বেবস্থা ভাবিজাগারিজ কুরাঃআ পুথি পড়হা চাবা তায়ম সমাজ অড়া রিঙ্কূ মুখিয়াকু ইঙ্কিন হান্ডে মিয়াৎ বার্তা কুলকেৎয়াকু হেৎদ গামকেৎয়াকু বকইঞকু, হড়কু রাঃআ হান্ডে চেচেদ এমঃরাঃআ যদি যাহানা মেনা আবেন গামেবেন। ");
INSERT INTO cdz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ইন্তং পৌল তিঙ্গুয়েন্তে তিহি হিলাকাতে গাম লাগায়নায়, এ খেরোয়াল হড়কু, এ ঈশ্বর রাঃআ বরতানকু, বিন ইহুদিকু আয়ুমেপে। ");
INSERT INTO cdz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","নিই খেরোয়াল জাতিরাঃআ ঈশ্বর আলেয়া হাড়াম-হাপাড়াম কুকে বাছাতাৎ কুয়ায়্য় য়, নিই জাতি চিন্তং মিশর দিশুমরে বাসালেনাকু, ইন্তং ইঙ্কূকে রাকাব (কূল বাড়া) কেৎকুয়ায় হেৎদ ইনি রাঃআ দাড়িতে ইঙ্কূকে উডুঙ আগুকেৎ কুয়ায়্য় (সেসেন . 6:1, সেসেন . 12:51 ) ");
INSERT INTO cdz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","হেৎদ ইনি মরু ডাহিরে প্রায় পুলি সির্মাং ইঙ্কূয়া ব্যবহার সাহাকেয়ায় (সেসেন . 16:35, লেখাযখা . 14:34, বারগাম . 1:31) ");
INSERT INTO cdz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","তায়মতে ইনি কনান দিশুম রিঙ্কূ সাতী জাতিকে উচ্ছেদ কেৎকুয়ায়্য় হেৎদ খেরোয়াল জাতিকে ইঙ্কূ যত জাতি রাঃআ দিশুম এমকেৎ কুয়ায়্য়। নেকাগে উপুন চাকি ড়েলি সির্মাং পারমেনা (বারগাম . 7:1, যিহোশুয় . 14:1) ");
INSERT INTO cdz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ইনা তায়ম শমুয়েল ভাবিজাগারিজ রাঃআ মাহা যাকিৎ ইঙ্কূকে কথক হড় দরবার িজ এমাদকুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ইনা তায়ম ইঙ্কূ মিয়াৎ রাপাজ আসিকিয়াকু, ইনাতে ঈশ্বর ইঙ্কূকে পুলি সির্মাং নাতিনাং বিন্যামিন কূলরিনিজ কিস রাঃআ হনতেত শৌলকে এমাকিয়ায় (1 শামু. 8:5, 1 8:19, 10:24, 11:15) ");
INSERT INTO cdz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","তায়মতে ঈশ্বর শৌলকে অচঃঅ কিয়তে ইঙ্কূয়া রাপাজ হুই রাঃআ নাতিনাং দায়ুদকে বাছা কিয়ায়, অকয় রাঃআ বাবত তে ঈশ্বর গামকেয়ায় ইনি তাহীন কেনায় দাউদ, ইঞ যিশয় রাঃআ হনতেদ দাউদ নামতিয়াইঞ, ইনি ইঞা মনের মত হড়, ইনি ইঞা যত ইচ্ছা পালাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","নিই হড়রাঃআ কূল হাতেনগে ঈশ্বর রাঃআ দিব্যিলেকাতে খেরোয়াল রাঃআ নাতিনাং মিয়াৎ বাবাঞ্চায়িজকে, যীশু কে হাজির কিয়ায় (2 শামু 7:12, 13, জিসাই. 11:1) ");
INSERT INTO cdz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","যীশু রাঃআ হিজু মাড়াঙতে যোহনডুবান যত খেরোয়াল জাতিকুরা হান্ডে মন পাল্টা রাঃআ ডুবুল জাগার পাসনা কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","হেৎদ যোহনডুবান রাঃআ কামী চিন্তং চাবা হিজুকেনা, ইনি গামেৎ কেনায় ইঞ অকয় তানাইঞ, আপে কিনা আটকারে তানাপে? ইঞ ইনি খ্রীষ্ট ল্হয় তানাইঞ। মেন্খান নেলেপে, ইঞা তায়মতে এনকান মিয়াৎ হড় ইখড়ূম কাতে, ইনি রাঃআ খড়ম রাঃআ বায়র হলেজ রাঃআ আইদারী ইঞা বাআয়না। ");
INSERT INTO cdz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","এ খেরয়ার হাগাকু, আব্রাহাম রাঃআ কূল রিঙ্কূ হনকু হেৎদ আপে যত হড় ঈশ্বরকে বরইয়াপে, আলেয়া হান্ডেগে নিয়া রুক্ষীয়া রাঃআ জাগার কুল হুইয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","চিয়াচি যিরুশালেম শেহার রিঙ্কূ তাহীআনকু হেৎদ ইঙ্কূ য়া শাসককু ইনিকে কাকু চিহ্না দাড়িলিয়া হেৎদ ভাবিজাগারিজ কুরাঃআ অকা যত জাগার ঝিরামাহা হুলাং পড়হা হুইওয়া, ইনা জাগার ইঙ্কূ কাকু আটকার দাড়িলা, মেন্খান ইনিকে কুড়াই এমকাতে ইনা যত জাগার সফলতাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","যদিহঅ ইনিকে গজরাঃআ কুড়াই রাঃআ নাতিনাং যাহান দোষ ইনিরে কাকু নামলাৎ আ, ইঙ্কূ পিলাত রাঃআ হান্ডে দাবি কেৎয়াকু, যেন ইনিকে গজ রাঃআ কুড়াই এম হুইওকা। ");
INSERT INTO cdz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ইনি রাঃআ বাবত তে অকা শাস্ত্র পুথি অল হুইলেনা, ইনাকু পুরা লেংখান ইনিকে ত্রুশ হাতেন আড়গু কাতে কবর এম হুইওকা আয়। ");
INSERT INTO cdz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","মেন্খান ঈশ্বরদ যীশু কে গজকু রাঃআ তালা হাতেন জিউৎ কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","হেৎদ অকয় ইনি লঅ গালিল তালুক হাতেন যিরুশালেম শেহার তে হিচ লেনাকু, ইঙ্কূকে ইনি গাদামাহা যাকিৎ নাপাম লাৎকুয়ায়্য়, ইঙ্কূগে নাহা যত হড়কুরা হান্ডে ইনিরা লুকুন্দী ী। ");
INSERT INTO cdz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ইনাতে আলে আপেয়া হান্ডে নিয়া বুগিন বার্তা সারিতকাতানাপেয়ালে অকা, ঈশ্বর আলেয়া হাড়াম-হাপাড়াম কু রাঃআ হান্ডে এক্ড়ার লাৎ আয় যে, ");
INSERT INTO cdz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ঈশ্বর যীশু কে জীউৎ কিৎ তে আলেয়া হনকু রাঃআ পক্ষে ইনি রাঃআ একড়ার পুরা তাৎআয়, চিল্কা বার-দুরাং পুথিরে অল মেনা \"আম ইঞাঃ হন তানাম, তিহিঞ ইঞ আমকে জানাম তাৎ মাইঞ (দুরাং মালা . 2:7) ");
INSERT INTO cdz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","হেৎদ ইনি যে হানিকে গজাকানকুরা তালা হাতেন জীউৎ তিয়ায় হেৎদ ইনি রাঃআ হড়মো যে অটঅ যাহা চিল্লং কা শয়া, নিয়া বাবত তে ঈশ্বর গামতাৎআয়, ইঞ আপেয়া পাতিয়ানকুকে দায়ুদরাঃআ রিলামালা আরিচালি হেৎদ নিশ্চিত আশিষকু এমপেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ইনা নাতিনাং ইনি এটা দুরাংরেহঅ গামতাৎআয় \"আম আমা সাধুকে শয়া কা নেল তুকা মেয়ায় (দুরাং মালা . 16:10) ");
INSERT INTO cdz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","দায়ুদ, আয়া হড়কু রাঃআ তালারে ঈশ্বর রাঃআ ইচ্ছা পালাকেয়ায় হেৎদ গজেনায় হেৎদ ইনিকে হাড়াম-হাপাড়াম কুরাঃআ হান্ডে কবর এম হুইয়েনা হেৎদ ইনিরা হড়মো কা শয়ায়না (বিচার , 1 রাপাজ ) ");
INSERT INTO cdz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","মেন্খান ঈশ্বর অকয়কে জীউৎ তিয়ায়, ইনি নাশ কা নেলতাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","এন্তে, এ ইঞা বকইঞকু, আপেকে সারি জরুরতানা যে, নিই হড়রাঃআ হরকাটেগে কাই ঈকা রাঃআ বাবদতে পাসনা হুইওতানা; ");
INSERT INTO cdz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","হেৎদ মোশি রাঃআ আরিচালি হরকাতে আপে কাই রাঃআ ছেমা কাপে নামতাৎ আ, মেন্খান যাহায়গে ইনি হড়কে পাতিয়াইআয় ইনি কাই রাঃআ ছেমা নামেআয়। ");
INSERT INTO cdz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ইনাতে হুঁশিয়ার পে, অলা কান শাস্ত্র পুথি রে ভাবি জাগারিজকু অকা গাম লাৎআকু ইনা যেন আপেয়া জিউরে আল হুইয়াআ, ");
INSERT INTO cdz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","এ বেঃরাহীকু, নেলেপে হেৎদ হায় কাটপে হেৎদ নাশঃঅপে; চিয়াচি আপেয়া বাতিরাং ইঞ এনকান কামি করাঃআইঞ যে, ইনা যত কামি রাঃআ থুতি যদি যাহায় আপেকে গামা পেয়াকু, তুবুইরহ আপে আলপে পাতিয়াপে (হবককুক 1:5) ");
INSERT INTO cdz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","পৌল হেৎদ বার্ণবা সমাজঅড়া বাগি গিডি হুলাং, হড়কু ইনকিনকে কষামুদিকেৎ কিনাকু, যেন ইনকিন গাপা রাঃআ গাপা -হুলাং রাঃআ ঝিরা মাহারে নিয়া বাবদতে অটঃহঅ হুডাং গামেকা আকিন। ");
INSERT INTO cdz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","সমাজ অড়া রাঃআ দরবার ভাঙ্গা রাঃআ তায়ম গাদা ইহুদি হেৎদ (বিন ইহুদি হড়) ইহুদি ধরমরে আড়গুয়াকান পাতিয়ান হড়কু পৌল হেৎদ বার্ণবালঅ সেনেনাকু, ইঙ্কূ ইনকিন লঅ থুতিনাকু, হেৎদ ঈশ্বর রাঃআ দায়া-দুলাড়রে থির তাহি গামকেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","তায়্ম হুলাং রাঃআ ঝিরা মাহারে শেহার রিঙ্কূ প্রায় যত হড় ঈশ্বর রাঃআ জাগার আয়ুম নাতিনাং হুন্ডিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","চিন্তং ইহুদিকু হড়কু রাঃআ হুন্ডি নেল কেৎয়াকু, ইঙ্কূ হিংসাতে পেরেজেনাকু হেৎদ ইনিকে নিন্দা কিয়তেকু পৌল রাঃআ থুতিরে বিরুধ লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","মেন্খান পৌল হেৎদ বার্ণবা সাহসলঅ গাম রুয়াড়কেৎ কুয়াকিন হেৎদ গামকেৎয়াকিন, মাড়াঙ আপেয়া হান্ডে ঈশ্বর রাঃআ জাগার পাসনা জরুড় তানা; নেল কেয়ালিঞ আপে নিয়া বাব্ত্ত টাকে অগ্রাহ্য কাতে সাঙ্গিনরে অচ গিডি তানাপে, হেৎদ নিজে রাঃআ যায়যুগ জীবন রাঃআ অযোগ্য় কাতে দহয় তানাপে, ইনাতে আলিঞ বিনইহুদিকু রাঃআ হান্ডে সেনালিঞ। ");
INSERT INTO cdz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","চিয়াচি প্রভু আলিঞকে এনকান হুকুম এমতাৎ লিঞায় \"ইঞ আমকে যত জাতিরাঃআ হান্ডে মার্শাললেকা করাতাৎ মেয়াইঞ, যেন আম ধার্তি রিঙ্কূ যত মান্মি রাঃআ হান্ডে বাবাঞ্চাওইজ লেকা হুইঅম। ");
INSERT INTO cdz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","নিয়া থুতি আয়ুমকেৎ তেকু অইহুদি হড়কু কুশিনাকু হেৎদ ঈশ্বর রাঃআ জাগার রাঃআ গৌনজহার লাগায় নাকু; হেৎদ অকয় অনন্ত জীউ রাঃআ নাতিনাং বাছা লেনাকু, ইঙ্কূ পাতিয়ায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","হেৎদ প্রভু ঈশ্বর রাঃআ ইনা জাগার ইনা টলারে গোটা জায়গারে পাসরায়না। ");
INSERT INTO cdz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","মেন্খান ইহুদিকু ভক্ত ধার্মিক কুড়িহন হেৎদ শেহার রিঙ্কূ বহঃঅ লাউড়িয়া কুকে উস্কুরকেৎ কুতে, পৌল হেৎদ বার্ণবা রাঃআ চেতাংরে সাসেৎ সাতাও এহবেনা হেৎদ ইনকিনকে (পৌল, বার্নাবা) শেহার রাঃআ এলাকা বাহারতে কুদাগিডিকেৎ কিনা। ");
INSERT INTO cdz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ইন্তং ইঙ্কিন ইঙ্কূ হড়কুরাঃআ বিরুধরে কাটারাঃআ ধুড়ি কটা গিডিকাতে ইকনিয় এটা শেহার তেকিন সেনেনা। ");
INSERT INTO cdz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","হেৎদ চেলাকু কুশিতে হেৎদ রীলামালা আত্মাতে পেরেজ লাগায়নাকু। মথি 10:14, 15, মার্ক 16:11 ");
INSERT INTO cdz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","হেৎদ পৌল হেৎদ বার্ণবা ইকনিয় নাগাররে ইহুদি কুরাঃআ সমাজ অড়ারে বলয় নাকিন হেৎদ সাপা সাপি বুগিন থুতি গামকেয়ায় যে, ইহুদি হেৎদ গ্রিক (বিন ইহুদি) কুরাঃআ তালারে গাদা হড়কু পাতিআয়না। ");
INSERT INTO cdz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","মেন্খান অকা ইহুদিকু বেঃরাহি নাকু, ইঙ্কূ হাগাকু রাঃআ বিরুধরে অইহুদি হড় কুরাঃআ জিউতাকুয়া উস্কুরকেৎ কুয়াকু হেৎদ ক্ষেপা রাকাবকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","এন্তে ইঙ্কিন অটঃহঅ গাদামাহা এনথাংরে তাহীনাকিন, সাহস লঅ হেৎদ প্রভু রাঃআ দাড়িতে থুতি কেনা কিন, হেৎদ ইনি প্রভু রাঃআ দায়া-দুলাড় রাঃআ থুতি গামে কেনায়, হেৎদ প্রভুহঅ পৌল হেৎদ বার্ণবা রাঃআ তিহি হরকাতে নাআ হানা চিহ্না হেৎদ হাহাড়া কামি কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ইনাতে শেহার রিঙ্কূ হড়কু বার ভাগেনাকু, মিয়াৎ দল ইহুদিকু রাঃআ হেৎদ অট মিয়াৎ দল কুলিচ কুরাঃআ পক্ষ হাতাকেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ইন্তং অইহুদি হেৎদ ইহুদিকু রাঃআ কথক হড় আকুয়া লাউড়িয়াকু লঅ যুক্তি থুতি জাগার কাতে, ইনকিনা মানখাট হেৎদ দিরি লেবদা রাঃআ কারসাদি কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ইনকিন ইঙ্কূয়া কারসাদি আটকার নামকাতে লুকায়নিয়া মুলুক রাঃআ, লুস্ত্রা হেৎদ দর্বী নাগার তে হেৎদ ইনা রাঃআ গোটা টলাতে নিরে নাকিন; ");
INSERT INTO cdz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","হেৎদ এন থাংরে ইনকিন বুগিন বার্তা পাসনা লাগায়নাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","লুস্ত্রা নাগার রে মিয়াৎ হড় দুবতাহিনো কেনায়, ইনি রাঃআ তিঙ্গু রাঃআ যাহান দাড়ি কা তাহিনো কেনা, ইনি জানাম হাতেনগে বারান কাটা খড়দা, যাহা চিল্লং কায় তাড়ম ভাড়া তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ইনি হড় পৌল রাঃআ থুতি আয়ুমেৎ কেনায়; পৌল ইনি রাঃআ হান্তে মিৎ ঢেকতে কয়ঃঅ কিয়ায়, হেৎদ নেল নাম কেয়ায় বুগি রাঃআ নাতিনাং ইনি রাঃআ পাতিয়া মেনা। ");
INSERT INTO cdz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ইনি জোরতে ইনিকে গামকিয়ায়, আমা কাটারে ভর এমকাতে সজেহে তিঙ্গুনমে; এন্খান ইনি জেহেদ কাতে তিঙ্গুইনায় হেৎদ তাড়ম লাগায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","পৌল অকা করাকেয়ায়, ইনা নেলকাতে হড়কু লুকানিয় জাগারতে জোরতে গাম লাগায়নাকু, দেবতাকু মান্মি রাঃআ ভেশ হাতাকাতে আবুয়া তালারে হিচা কানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ইঙ্কূ বার্ণবাকে দ্যুপিতর (জিউস) হেৎদ পৌলকে মর্কুরিয় (হারমেশ) গামাৎ কিনাকু, চিয়াচি পৌল মুখিয়া জাগারিজ তাহিনকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","হেৎদ শেহার রাঃআ সামাংরে দ্যুপিতর রাঃআ অকা জাহের থান্তে তাহীন কেনা, এনথাং রিনিজ বামড়ে কথক লেকা উরিচ আন্ডিয়া হেৎদ মালা ইদিকাতে শেহার রাঃআ বলন দুয়াররাঃআ সামাংরে হড়কু লঅ বলিদান নানামেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","মেন্খান কুলিচ কু, বার্ণবা হেৎদ পৌল, নিয়া থুতি আয়ুমকাতে ইঙ্কূ নিজে রাঃআ কিচি-সনঃঅ ওড়েজ কেৎয়াকিন হেৎদ নিরকাতে বাহারতে সেনকাতে হড়কু রাঃআ দিশাকাতে গাম লাগায়নাকু, ");
INSERT INTO cdz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","গমকেকু, আপে নেকা চিয়া করায় তানাপে? আলেহঅ আপে লেকা সমান সুখ দুঃখ সাহা হড়; আলে আপেকে নিয়া বুগিন বার্তা সারিতকা হিচাকানালে যে, নিয়া যত অসার জিনিস হাতেন জীউৎ ঈশ্বর রাঃআ হান্ডে হিজুপে, অকয় সেরমা, ধার্তি, দরেয়া, হেৎদ দরেয়ারে যাগে মেনা ইনা যত সির্জনতাৎ আয় (সেসেন . 20:11, দুরাং মালা . 146:6) ");
INSERT INTO cdz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ইনি মুশিং হাড়াম-হাপাড়ামকু রাঃআ পিড়ি লেকাতে যত জাতিকে ইঙ্কূয়া ইচ্ছালেকা সেন তকাতাৎ কুয়ায়্য়য়; ");
INSERT INTO cdz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","মেন্খান তুবুই রহঃঅ ইনি নিজেকে সদর দঃহঅকিয়ায়, ইনি মঙ্গল তাৎআয়, নিরালা হাতেন আপেকে দাঃআ হেৎদ জোঃ সাবরাঃআ কালতে জোঃ এমতাৎ আপেয়ায় হেৎদ কুশিতে আপেয়া অন্তর পেরেজ তাৎ আপে। ");
INSERT INTO cdz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","নিয়া যত থুতি গামকাতে পৌল হেৎদ বার্ণবা গাদা কষ্টতে ইঙ্কূয়া উদ্দেশে বলি রাকাব হাতেন হড়কুকে আটকা কেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","মেন্খান আন্তীয়খিয়া শেহার হেৎদ ইকনীয় নাগার হাতেন কথক হড় ইহুদি হিচেনা কু; ইঙ্কূ হড়কুকে ইন্ধন এমকেৎ কুয়াকু হেৎদ হড়কু পৌলকে দিরি লেবদা কিয়াকু হেৎদ ইনিকে শেহার রাঃআ বাহারতেকু গহাড় ইদিকিয়াকু, ইনি দ গজাকানায় মেন্তে। ");
INSERT INTO cdz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","মেন্খান চেলাকু ইনিরা চারুধার ঘেরাকাতে তিঙ্গুইনতেকু দাঃআ কু ছিটকা কিচ খানঃঅ ইনি বিরিৎ এন্তে শেহার রে বলয়নায়। তায়মতে ইনি বার্ণবা লঅ দর্বী নাগার তে সেনেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ইনকিন ইনা শেহার রে বুগিনবার্তা পাসনা কেয়াকিন হেৎদ গাদা হড় প্রভু রাঃআ চেলা হুইয়েনাকু। ইনকিন লুস্ত্রা হাতেন ইকনিয়তে, হেৎদ আন্তিয়খিয়াতে রুয়াড় হিচেনা কিন; ");
INSERT INTO cdz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ইনকিন ইনা টলা রিঙ্কূ চেলাকুরাঃআ জিউরে দাড়ি আর্জাকেৎ কুয়াকিন হেৎদ ইঙ্কূকে ভরসা এমকেৎ কুয়াকিন, যেন ইঙ্কূ পাতিয়ারে থির তাহীনকাআকু। হেৎদ ইনকিন ইঙ্কূকে গামাৎ কুয়াকিন আবুকে গাদা কষ্টরাঃআ তালা হরকাতে ঈশ্বর রাঃআ মুলুক রে বলঃঅ হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","চিন্তং ইনকিন ইঙ্কূ য়া নাতিনাং মিমিৎ মন্ডলীরে মুরুব্বিকুকে বহালকেৎ কুয়াকিন হেৎদ বার হেৎদ বিন্তিকেয়াকিন হেৎদ অকয় ঈশ্বরকে পাতীয়ালিয়াকু ইঙ্কূকে প্রভু রাঃআ তিহিরে সম্পাকেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","হেৎদ ইঙ্কিন পিষীদিয়া মুলুক রাঃআ তালা হরকাতে পারমকাতে পাম্ফুলিয়া মুলুক তেকিন সেটেরেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ইনা তায়ম ইঙ্কিন পর্গা নাগার রে ঈশ্বর রাঃআ জাগার পাসনা কেৎ তেকিন অত্তালিয়া নাগার তে রুয়াড় সেনেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","হেৎদ এন্ডে হাতেন জাহাজ তে আন্তীয়খিয়া শেহার তে সেনেনাকিন, অকা কামি ইনকিন চাবাকেয়াকিন, ইনা কামিরাঃআ নাতিনাং পাতিয়ানকু ইনকিনকে নেথাংরেগে ঈশ্বর রাঃআ দায়া-দুলাড় রাঃআ হান্ডে নিজেকিন সম্পায় নাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","আন্তীয়খিয়া শেহার তে ইঙ্কিন চিন্তং রুয়াড় হিচেনাকিন, হেৎদ মন্ডলীকে মিৎ কেৎ কুয়াকিন, হেৎদ ঈশ্বর ইঙ্কিন দ্বারায়তে অকা যত কামি করালাৎ আয় হেৎদ চিল্কা অইহুদি হড়কুরাঃআ নাতিনাং পাতিয়া রাঃআ দুয়ার নিজতাৎআয়, ইনি যত থুতি ইঙ্কূকে গুছিয়া কাতেন সারি তুকা কেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","তায়মতে ইঙ্কিন, পৌল হেৎদ বার্নাবা এনথাংরে পাতিয়ানকু লঅ গাদামাহা কিন তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","হেৎদ ইহুদিয়া মুলুক হাতেন কথক হড় হিচেনা কু হেৎদ পাতিয়ান হাগা কুকে চেচেদ এম লাগায় নাকু যে, আপে যদি মোশি রাঃআ আরিচালি লেকাতে সুন্নু চুটি -গেৎ কাপেয়া এন্খান রুক্ষীয়া কাপে নামেয়া (লেবি . 12:3) ");
INSERT INTO cdz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","হেৎদ ইঙ্কূ লঅ পৌল হেৎদ বার্ণবা রাঃআ গাদা তর্কা তর্কি হেৎদ নিপিয়ায় হুইয়েনা খানঃঅ হাগাকু গটা কেৎয়াকু, ইনা তর্ক গটা গুটি রাঃআ নাতিনাং হেৎদ ইঙ্কূয়া অটঅ কথক হড় যিরুশালেম শেহার তে কুলিচ কু রাঃআ হেৎদ মুরুব্বি কু রাঃআ হান্ডে সেনোয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","এন্তে মন্ডলী ইঙ্কূকে কুল কেৎকুয়ায়্য় হেৎদ ইঙ্কূ ফৈনিকিয়া হেৎদ শমরিয়া টলা হরকাতে সেন সেনতে বিন ইহুদিকু রাঃআ পাল্টা রাঃআ বাবত গাম কেৎয়াকু হেৎদ যত পাতিয়ান হাগাকু কুঠিন রাস্কায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","চিন্তং ইঙ্কূ যিরুশালেম শেহার তে সেটেরেনাকু, মন্ডলী হেৎদ কুলিচ কু হেৎদ মুরুব্বিকু ইঙ্কূকে আতাং দারমকেৎ কুয়াকু হেৎদ ঈশ্বর ইঙ্কূ লঅ তাহি কাতেন অকা কামি করাতাৎ আয় ইনা যতগে গামকেৎ কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","মেন্খান ফরিশী দল হাতেন কথক হড় পাতিয়ান তিঙ্গুয়েন তেকু গাম লাগায় নাকু, ইঙ্কূ য়া সুন্নু চুটি -গেৎ কুঠিন জরুর তানা হেৎদ মোশি রাঃআ যত আরিচালি মানা বাতা রাঃআ হুকুম এম হুইওকা। ");
INSERT INTO cdz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","এন্তে নিয়া বাবত তে আলোচনা নাতিনাং কুলিচ কু হেৎদ মুরুব্বিকু হুন্ডিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","হেৎদ গাদা নিপিয়ায় হুইরাঃআ তায়মতে পিতর বিরিদ কাতে তিঙ্গুইয়েন্তে ইঙ্কূকে গামাৎ কুয়ায়্য় য়, এ হাগাকু, আপে সারিয়াপে যে, গাদামাহা মাড়াঙতে ঈশ্বর আপেয়া তালা হাতেন ইঞকে বাছা তিঞায়, যেন ইঞা মচা হাতেন বিনইহুদিকু বুগিন বার্তা রাঃআ জাগার নিশ্চয়ই আয়ুমে কাআকু হেৎদ পাতিয়া কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ঈশ্বর, অকয় হৃদয় রাঃআ অন্তঃকরণ সারিয়ায়, ইনি ইঙ্কূ য়া পক্ষে লুকুন্দী এমতাৎআয়, আলেকে চিল্কা, ইঙ্কূকেহঅ এনকা রীলামালা আত্মা রীলামালা আত্মা দানা তাৎ কুয়ায়্য় য়; ");
INSERT INTO cdz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","হেৎদ আলেয়া হেৎদ ইঙ্কূ য়া তালারে যাহানা বিশেষ বাছবিছ কায় দঃহ তাৎআয়, পাতিয়া দিয়াতে ইঙ্কূ য়া অন্তর রীলামালা তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","এন্তে আপে নাহা চিয়া ঈশ্বর রাঃআ বিডায়ই তানাপে, চেলাকু রাঃআ তারানরে আরাড় চিয়া লাদি তানাপে, অকারাঃআ হাম্বাল চি আলেয়া আপুইঞ-বুঢাইঞতুকু চি আলে গঃঅ দাড়িয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","মেন্খান আলে পাতিয়ালে ইঙ্কূ চিল্কা, আলেহঅ এনকা প্রভু যীশু রাঃআ দায়া-দুলাড়তে রুক্ষীয়া নামেয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ইন্তং যতচ দরবাররে থিরথারেনাকু, হেৎদ বার্ণবা হেৎদ পৌল রাঃআ হরকাতে বিনইহুদিকুরাঃআ তালারে ঈশ্বর কিনা কিনা চীনহা-কামি হেৎদ হাহাড়া লক্ষণ পুরাতাৎআয়, ইনা রাঃআ বিবরণ ইঙ্কূ য়া হান্ডে হাতেন আয়ুমে কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ইঙ্কিনাআ থুতি চাবা তায়মতে, যাকোব উত্তর এমকাতে গাম এহব কেয়ায়্য়, হাগাইঞ কু ইঞা থুতি আয়ুমেপে। ");
INSERT INTO cdz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ঈশ্বর নিজে রাঃআ নুতুম রাঃআ নাতিনাং বিনইহুদিকু রাঃআ তালা হাতেন মিৎ দল হড়কে আতাং রাঃআ দিশা চিল্কা মাড়াঙ ইঙ্কূকে আশীষ লাৎ কুয়ায়্য়, ইনা কুদ শিমোন ব্যখ্যা কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","হেৎদ ভাবি জাগারিজ কুরাঃআ জাগার ইনি লঅ মেশা মেনাআ, চিল্কা শাস্ত্র রে অল মেনা, ");
INSERT INTO cdz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","নিয়া যত রাঃআ তায়মতে ইঞ রুয়াড় হিচ য়াইঞ, দাউদ রাঃআ নুর-উয়ু গিডিয়াকান পারগানা অট বাইয়েআইঞ, যত লান্দুড় থাং অটঅ বাইয়েআইঞ, হেৎদ দোহরা তিঙ্গুয়াইঞ, ");
INSERT INTO cdz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","এন্তে, বাকি যত হড় যেন প্রভুকে পাঞ্জাই কাআকু হেৎদ অকা জাতি রাঃআ চেতাংরে ইঞা নুতুম কীর্ত্তিত হুইয়াকানা, ইঙ্কূ যেন যতচ পাঞ্জাই কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","প্রভু নিয়া থুতি গামেয়ায়, অকয় মুশিং হাতেন নিয়া যত বাবত সারিআয়। ");
INSERT INTO cdz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","এন্তে ইঞা দরবার নিয়া যে, অকয় এটা জাতি অইহুদি কুরাঃআ তালা হাতেন ঈশ্বর হান্ডে রুয়াড় হিচয়াকু ইঙ্কূকে আলে কালে কষ্ট এমাকুয়ালে, ");
INSERT INTO cdz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","মেন্খান ইঙ্কূ কে অলকাতে কুলকুয়ালে, যেন ইঙ্কূ হাসা ঠাকুর বাবদতে অছুথী তা, হড়মো লটম, হটটিপা কাতেন গজাকান পশুকু রাঃআ জিলু হেৎদ মায়ম হাতেন সাঙ্গীনরে তাহিন কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","চিয়াচি মিমিৎ শেহার রে কূলপিড়ি হাতেন মোশি রাঃআ নাতিনাং এনকান হড় মেনাআ কুয়া, অকয় ইনিকে পাসনা য়াকু হেৎদ মিমিৎ ঝিরা মাহারে সমাজ অড়াকুরে ইনিরা পুথি পড়হা হুইও তানা। ");
INSERT INTO cdz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ইন্তং কুলিচ কু হেৎদ মুরুব্বিকু মাড়াঙরাঃআ যত মন্ডলীরাঃআ দেঙ্গাতে, নিজেরাঃআ তালা হাতেন বাছায়ান কথক কথক হড়কুকে, অর্থাৎ বার্শবা নুতুমতে পরিচিত যিহুদা হেৎদ শেলাস, হাগাকু রাঃআ তালারে পরিচিত নিকিন বার হড়কে পৌল হেৎদ বার্ণবা লঅ আন্তীয়খিয়াতে কুল নাতিনাং লাক্তি আটকার কেৎয়াকু ; ");
INSERT INTO cdz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","হেৎদ ইঙ্কূ য়া তিহিরে নেএনেকা অল কুলকেৎয়াকু আন্তীয়খিয়া শেহার, সুরিয়া দিসুম হেৎদ কিলিকিয়া মুলুক রিঙ্কূ অইহুদি হাগাকু রাঃআ হান্ডে কুলিচ হেৎদ মুরুব্বি হাগাইঞ কুকে জোহার। ");
INSERT INTO cdz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","আলে আয়ুম কেৎয়ালে যে, আলে অকয়কে যাহান সুন্নু চুটি -গেৎ হুকুম কালে এমতাআকুয়া, ইঙ্কূ কথক হড় আলেয়া ভীতির হাতেন সেন কাতেন থুতি রাঃআ হরকাতে আপেয়া জিউ চঞ্চল কাতে আপেকে চিন্তারে দঃহঅতাৎ পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","নিয়া মেন্তে আলে মিৎ মদেন্তেকু কথক হড়কে বাছাতাৎ কুয়ালে হেৎদ আলেয়া দুলাড়িয়া যে, বার্ণবা হেৎদ পৌল, ");
INSERT INTO cdz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","আবুয়া প্রভু যীশু খ্রীষ্ট রাঃআ নুতুম রাঃআ নাতিনাং মনে জিউতে কুরুমুটু তানাকু, ইঙ্কূ লঅ ইঙ্কূ এ আপেয়া হান্ডে কুল লাক্তি মনেক কেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","এন্তে বার্সাবাস যিহুদা হেৎদ শেলাশ কেহঅ কুলকেৎ কিনালে নিকিন হঅ আপেকে নিয়া যত বাবত গামা পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","চিয়াচি রীলামালা আত্মা রাঃআ হেৎদ আলেয়া নিয়াগে বেশ মেন্তে মনে কেয়ালে, যেন নিয়া চিমিনটা জরুরী বাব্ত্ত ছাড়া আপেয়া চেতাংরে যাহানা হাম্বাল আল এমেকালে, ");
INSERT INTO cdz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ইনাতে হাসা ঠাকুর প্রসাদ হেৎদ মায়ম হেৎদ হট টিপাকাতে গজাকান জিয়ানকু রাঃআ জিলু হেৎদ হড়মো লটম হাতেন সাঙ্গিনরে তাহিনো আপেয়া লাক্তি তানা; নিয়া যত হাতেন নিজেকুকে সাঙ্গিনরে দঃহ লেংখান আপেয়া মঙ্গল হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","এন্তে ইনকিন, কয়্তুকা হাতা কাতে আন্তীয়খিয়াতে হিচেনা কিন হেৎদ হড়কুকে হুন্ডিকেৎ কুতেকিন গিরা সেকাম এমকেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","গিরা পড়হা তায়ম ইঙ্কূ ইনা জিউ রাড়েজ রাঃআ থুতিতে। ");
INSERT INTO cdz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","হেৎদ বার্সাবাস যিহুদা হেৎদ শেলাস নিজেহঅ ভাবি জাগারিজ তাহিন কেনাকিন মেন্তে, গাদা থুতিতে হাগাকুকে আশ্বাস এমকেৎ কুয়াকিন হেৎদ থির-থারকেৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","কথক মাহা এনথাংরে তাহি তায়ম, অকয়কু ইঙ্কিন কে কুললাৎ কিনাকু, ইঙ্কূ য়া হান্ডে সেন রুয়াড় নাতিনাং ইঙ্কিন হাগাকুরাঃআ হান্ডে হাতেন ইঙ্কিন সুলুক তেকিন কয়্তুকা হাতাকেয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","যীশু ইঙ্কূ কে গামকেৎ কুয়ায়্য়, আপেয়া হান্ডে চিমিনটা পিঠা মেনা? ইঙ্কূ গামকেৎয়াকু, সাতটা, হেৎদ কথক হুডিং হাকু। ");
INSERT INTO cdz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","মেন্খান পৌল হেৎদ বার্ণবা আন্তিয়খিয়া শেহার রে এটা গাদা হড়কু লঅ তাহিনাকিন, কদেরে ইঙ্কিন প্রভু রাঃআ জাগার চেচেদ এমেৎকেনা কুয়াকিন হেৎদ বুগিনবার্তা পাসনাৎ কেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","কথক মাহা তায়মতে পৌল বার্ণবাকে গামকিয়ায়, দঅ আলং অকা যত শেহার রে প্রভু রাঃআ জাগার পাসনা লাআলাং, ইনা যত শেহার রে রুয়াড় সেনকাতে হাগাকুকে পরিচর্চা কুয়ালাং হেৎদ নেললিকুয়ালাং ইঙ্কূ চিল্কা মেনাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","হেৎদ বার্ণবা নানামেনায়, যোহন, অকয়কে মার্ক গামিয়াকু ইনিকেহঅ সঙ্গেতে ইদি ধরাইয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","মেন্খান পৌল মনেকেয়ায় অকা হড় পামফুলিয়া মুলুক রে ইনিকিন বাগিগিডি কাতেন সেনলেনায় হেৎদ ইনিকিন লঅ অটঅ কামি কায় সেনা কানায় ইনি মার্ককে সঙ্গেতে ইদি গটা কা হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ইন্তং ইঙ্কিন তালারে মনরাঃআ মেল কা হুইলেনা, এন্তে ইঙ্কিন আপান-আপিন ভাগে নাকিন; হেৎদ বার্ণবাস মার্ককে সঙ্গেতে ইদিকিয়তে জাহাজতে কুপ্রেঢিপতে সেনে নাকিন; ");
INSERT INTO cdz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","মেন্খান পৌল শেলাস কে বাছাকিয়ায় হেৎদ হাগাকু রাঃআ দ্বারায়তে প্রভু রাঃআ দায়া-দুলাড়তে সম্পানতে কয়্তুকা হাতাকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","হেৎদ ইনি সুরিয়া হেৎদ কিলিকিয়া হরকাতে সেন সেনতে মন্ডলীকে সুস্থির হেৎদ কেটেজ কেৎকুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","হেৎদ ইনি (পৌল) দর্বিতে হেৎদ লুস্ত্রা শেহারতে সেটেরেনায় হেৎদ নেলেপে এনথাংরে তীমথিয় নুতুমিজ মিয়াৎ চেলা তাহীনকেনায়, ইনি মিয়াৎ পাতীয়ানিজ ইহুদি কুড়িরাঃআ হনতেদ মেন্খান ইনি রাঃআ বাঃতেৎ তাহীন কেনায় গ্রিক। ");
INSERT INTO cdz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","লুস্ত্রা হেৎদ ইকনিয়রে শেহাররে মেনায়ান পাতিয়ান হাগামিশিকু ইনি রাঃআ বাবদতে বেশ লুকুন্দী এম দাড়িয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","পৌল নানামেনায় যেন নিই হড় আয় লঅ সেনকাআয়; এন্তে ইনি তিমথি কে ইদিকিয়তে ইহুদি কুরাঃআ লেকাগে সুন্নু চুটি গেদকিয়ায়, চিয়াচি যতচ সারিয়াকু যে ইনি রাঃআ বাঃআতেদ গ্রিকতানায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","হেৎদ ইঙ্কূ চিল্কা শেহার ঘুরা ঘুরাকাতে সেন কেনাকিন, ইঙ্কিন মন্ডলীকুকে হুকুম এমকেৎ কুয়াকিন যেন যিরুশালেম শেহার রেঙ্কূ কুলিচ কুরাঃআ হেৎদ মুরুব্বি কুরাঃআ অলাকান হুকুমকু মানা বাতায়কাআ। ");
INSERT INTO cdz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","নেএ নেকাগে মন্ডলীকু পাতিয়ারে কেটেজেনাকু হেৎদ মাহাদ মাহা গুঁডুর রে বাড়া ইমাহাকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","পৌল হেৎদ ইনি রাঃআ গাতিকু ফারুগিয়া হেৎদ গলাতিয়া টলা হরকাতে সেনেনাকু চিয়াচি এশিয়া মুলুক দিশুমরে জাগার পাসনা নাতিনাং রীলামালা আত্মা হাতেন মানা তাহিন কেনা; ");
INSERT INTO cdz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ইঙ্কূ মুশিয়া মুলুক ঠাইনতে সেটেরেন্তেকু বৈথুনিয়া মুলুক তে সেনঃঅ সানাকেৎ কুয়া, মেন্খান যীশু রা আত্মা ইঙ্কূকে সেনতে বাধা এমকেৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","এন্তে ইঙ্কূ মুশিয়া দিশুম বাগি কাতে ত্রোয়া শেহার তে সেনেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","নিদা বাতিরাং পৌল মিয়াৎ ভেট নামকেয়ায়, মিহুড় মাকিৎনীয় মুলুক রিনিজ কড়াহন কষামুদি কাতে ইনিকে রাঃআ কিয়ায় হেৎদ গামকিয়ায়, মাকিৎ নিয়া মুলুকতে হিচ কাতে আলেকে দেঙ্গালেম। ");
INSERT INTO cdz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ইনি ইনা ভেট নাম থরা আলে মাকিৎ নিয়া দিশুমতে সেন নাতিরাং সাপড়ায়নালে, চিয়াচি আলে আটকার কেয়ালে ইঙ্কূ য়া তালারে বুগিনবার্তা পাসনা রাঃআ নাতিনাং ঈশ্বর আবুকে রাঃআতাৎ বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","আলে ত্রোয়া শেহার হাতেন দাঃআ হরকাতে সজেহে হরাতে সামথ্রাকি ঢিপ হেৎদ দশার হুলাং নিয়া পৌলি শেহার তে সেটেরেনালে। ");
INSERT INTO cdz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","এন্ডে হাতেন ফিলিপ শেহার তে সেনেনালে; ইনাটা মাকিৎ নিয়া মুলুক রাঃআ মারাং শেহার হেৎদ রোম শেহার িয় কু রাঃআ গিরাবাসী। আলে ইনা শেহার রে কথকমাহা তাহিলেনালে। ");
INSERT INTO cdz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","হেৎদ ঝিরামাহা হুলাং শেহার রাঃআ মেন দুয়ার রাঃআ বাহারতে গাডাকাতা সেনেনালে, মনেকেয়ালে এনথাংরে বিন্তি রাঃআ জায়গা মেনা; আলে এনথাংরে দুবকাতে মিৎ দল এরাহন অকয় হিচ লেনাকু ইঙ্কূ লঅ থুতিনালে। ");
INSERT INTO cdz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","হেৎদ থুয়াতির শেহার রে লুদিয়া নুতুমিজ মিয়াৎ ঈশ্বরভক্ত বাহুকুড়ি, অকয় হালি কিচি আখরিঞেকেনায় ইনি আলেয়া থুতি আয়ুমেকেনায়। প্রভু ইনি রাঃআ অন্তর হলেজ কেয়ায় যেন ইনি পৌলরাঃআ থুতি মনদিয়া আয়ুমেকাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ইনি হেৎদ ইনি রাঃআ যত অড়া হড় ডুবুল হাতা তায়ম ইনি কষামুদি কাতেন গামাৎ কুয়ায়্য়, আপে যদি ইঞকে প্রভুরে পাতিয়ান মেন্তে দরবার িঞাপে এন্খান ইঞা অড়াতে হিচ কাতে তাহিনপে হেৎদ ইনি আলেকে নেলআতেন কাতে ইদিকেৎ লেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","মিৎ মাহা হুলাং আলে ইনা বিন্তি থাংতে সেনকেনাল, ইনা হুলাং এটা দেবতা রাঃআ আত্মাতে পেরেজাকান মিয়াৎ ডাঙ্গুয়া কুড়িহন মুনিশ আলেয়া সামাংরে নুরেনায়, ইনি পেত্নীদ হাপেন মহাকুরে কিনাআ হুইয়া মেন্তে গেমৎ কেনায় ইনি রাঃআ গিরিয়া কুকে গাদা লাভোবানেৎ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ইনি পেত্নী, পৌলরাঃআ হেৎদ আলেয়া তায়মতে সেন সেনতে কিকিচ কাতে গামকেয়ায় নিকু হড়কু হুইওতানা মারাং উতারিজ ঈশ্বর রাঃআ মুনিশ, নিকু আপেকে রুক্ষীয়া রাঃআ হরা গামাপে তানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ইনি পেত্নী, গাদামাহা যাকিৎ নেএ নেকা করা ইদিৎ কেনায়। মেন্খান পৌল কাদরাঃআ কেনায় খানঅ কয়ঃ ঘুরাকেৎ তে ইনি বাড়িচ আত্মাকে গামাকিয়ায়, ইঞ যীশু খ্রীষ্ট রাঃআ নুতুমতে আমকে হুকুমাম তানাইঞ, নিইরাঃআ হান্ডে হাতেন উডুঙ গদম। ইনাতে ইনা হুলাংগে পেত্নীআত্মা উডুঙয়েনায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","মেন্খান ইনিরা মালিককু নেলকেৎয়াকু যে, রোজগার রাঃআ আশা উডুঙ গিডিয়া কানায় নেল কিয়তিকু পৌল হেৎদ শেলাস কে সাবকাতে বাজাররে মুখিয়া রাঃআ সামাংরে গহাড় ইদি কেৎকিনাকু; ");
INSERT INTO cdz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","হেৎদ শাসন কর্তাকুরা হান্ডে ইঙ্কিন কে আগুকাতে গামাৎ কিনাকু, নিকিন হড়কিন হুইওতানা ইহুদি, নিকিন আবুয়া শেহার রে গাদা সমস্যা তেয়ারে তানাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","আবু রোম শেহার ীয়, আবুয়া অকা আরিচালি গ্রহণ হেৎদ মানা লাক্তি ল্হয় ইনাকু নিকিন পাসনাৎ তানাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ইনাতে হড়কু ইঙ্কিন বিরুধতে সেনেনাকু হেৎদ শাসন কর্তা ইঙ্কিন কিচি সিনিব হলেজ গিডি কেয়ায় হেৎদ হাপাতে দানাল রাঃআ নাতিনাং হুকুম কেৎকুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ইঙ্কিন কে গাদা দাল আটক রাঃআ তায়মতে ইঙ্কূ জিহালরে এমকেৎ কিনাকু হেৎদ হুঁশিয়ারতে হরঅ নাতিনাং জিহাল হরয়ানকে হুকুম এমাৎকুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","নে নেকা হুকুম নামকেৎ তে জিহাল রিনিজ পাহারাদার ইঙ্কিন কাটারে খাড়ুয়া লাগাকাতে জিহাল ভীতির রাঃআ অড়ারে হান্ডেত দঃহঅ কেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","মেন্খান তালানিদা পৌল হেৎদ শেলাস বিন্তি তানাকিন ঈশ্বর রাঃআ দিশা হমর বিন্তি হেৎদ দুরাং তানাকিন, এটা কায়দীকু ইঙ্কিন দুরাং লুতুর আডাকাতে আয়ুমেৎ কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ইন্তং আচকাগে অতে হিলায়না, এমনকি জিহাল অড়া রাঃআ ভিত যাকিৎ থারথার রাকাবেনা; হেৎদ তখুনি যত কবাট দুয়ার হলেজেনা হেৎদ যতচ রাঃআ ঝিনঝিরি আটক রাড়ায়না। ");
INSERT INTO cdz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","এন্তে জিহাল রখেয়া রাঃআ গিতিজ ভাঙ্গায়না হেৎদ জিহাল রাঃআ দুয়ারকু হলেজাকানা নেলকেৎতে নিজে রাঃআ কাপি উডুঙকেৎতে নিজেকে গজ রাঃআ নাতিনাং সাপড়ায়নায়, ইনি মনেলাৎ আয় আটক কু যতচ নিরাকানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","মেন্খান পৌল কিকিচ কাতে রাঃআ কিয়তে গামাকিয়্যায়, নিজে জিউ আলম নাশেয়া, চিয়াচি আলে যতচ নেথাংরে মেনালেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","এন্তে ইনি হরইচ মার্শাল আগু মেন্তে ভীতিরতে নির বলয়নায় হেৎদ বরতে একলান্তে পৌল হেৎদ শেলাস রাঃআ সামাংরে নুরেনায়; ");
INSERT INTO cdz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","হেৎদ ইঙ্কিন কে বাহার উডুঙকেৎ কিনতে গামাৎ কিনায়, গমকেকিন রুক্ষীয়া নাম নাতিনাং ইঞয়া কিনা চিকা হুইওয়া? ");
INSERT INTO cdz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ইঙ্কিন গামায়াকিন, আম হেৎদ আমা পরিবার প্রভু যীশু রে পাতীয়াপে, ইনাতে আম হেৎদ আমা পরিবার রুক্ষীয়া নামেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","তায়মতে ইঙ্কিন ইনিকে হেৎদ ইনি রাঃআ অড়া রিংকু যত হড়কে ঈশ্বর রাঃআ জাগার গামাৎ কুয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ইন্তং জিহাল রিনিজ কর্তা ইনা হুলাং নিদা ইঙ্কিন দাদাল রাঃআ চেগেড়কু আবুং সাপাকেৎ কিনায় হেৎদ ইনি রাঃআ অড়া হড় রেঙ্কূ যতচ হেৎদ নিজে ডুবুল হাতা কেৎয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","হেৎদ ইনি ইঙ্কিন কে চেতাংরাঃআ অড়াতে ইদিকেৎ কিনতে ইঙ্কিন সামাংরে জমা নয়াকু দঃহকেয়ায়। হেৎদ যত অড়া হড় লঅ ঈশ্বররে পাতিয়ানা খানঅ ইনি কুঠিন কুশিনায়। ");
INSERT INTO cdz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","হেৎদ চিন্তং আঙয়েনা, দরবার হুইয়াকান হরয়ান কুকে গামা কুলকেৎকুয়ায়্য় যে ইঙ্কূ হড়কুকে সেন তকাকূপে। ");
INSERT INTO cdz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","জিহাল হরয়িইজ পৌলকে নিয়া খবর এমাকিয়ায় যে, দরবার কান আবেনকে আড়া গিডি নাতিনাং গাম কুলতিঞায়। এন্তে আবেন নাহা বাহারতে হিজুবেন হেৎদ সুলুকতে সেনঃবেন। ");
INSERT INTO cdz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","মেন্খান পৌল ইঙ্কূ কে গাম কেৎ কুয়ায়্য় য় ইঙ্কূ আলিং রোম শেহার িয় হড় কিন বেগর দরবার রে হড় কুয়া সামাং রেকু দল কেৎ লিংয়া হেৎদ কু হাজত কেৎ লিংয়া চিয়া নাহা দ উকু-উকু তেকু আড়ালিং তানা?এনকা দ কা হুই দাড়ি য়া ইঙ্কূ আকু গে হিচ কাতেকু কয়্তুকা লিং কা। ");
INSERT INTO cdz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","হেৎদ পাল্টন কু নিয়া থুতি হাকিম কেকু গাম কেৎ কুয়া হেৎদ ইঙ্কিন রোম শেহার িয় তানা কিন মেন্তে আয়ুম কেৎ খান বর কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","হেৎদইঙ্কূ হিচ লেন তেকু বুঝা কেৎ কিনা হেৎদ ইনকিন উডুঙ কেৎ কিন তে শেহার হাতেন উডুঙঅ বেনমেন্তেকু বিন্তি কেৎ কিনা। ");
INSERT INTO cdz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","হেৎদ ইঙ্কিন পৌল হেৎদ শেলাস জিহাল অড়া হাতেন উডুঙ য়েন তে লুদিয়া রা অড়া তে হেৎদ হাগা কুকে নেল কেৎ কুতে হেৎদ চেদ কেৎ কুতে কিন সেনে না। ");
INSERT INTO cdz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","হেৎদ ইঙ্কিন আম্ফিপলি শেহার হেৎদ আপৌল্লোনিয়া শেহার র হরকাতে সেএন্তেকিন থিষলনীকী নাগার তে হিচে নাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","হেৎদ পৌল ইনিরাঃআ আরিচালি লেকাতে ইঙ্কূ য়া হান্ডে সেনেনায় হেৎদ আপিয়া ঝিরা মাহারে ইঙ্কূ লঅ শাস্ত্ররাঃআ জাগার ইদিকাতে আলোচনা কেয়ায়, উদুকেৎকু য়ায় যে, ");
INSERT INTO cdz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ইনি শাস্ত্ররাঃআ জাগার হলেজকাতে চেচেদকেৎকু য়ায় যে খ্রীষ্টরাঃআ গজঃঅ হেৎদ গজাঃকানকুরাঃআ তালা হাতেন জীউৎ রাকাব জরুরি তাহিনকেনা হেৎদ নিই যে যীশুরাঃআ বাব্ত্তে ইঞ আপেকে গামাপে তানা, ইনিগে হানি খ্রীষ্টতানায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ইনাতে ইহুদি কুরাঃআ তালারে কথক হড় সায় এমকেয়াকু হেৎদ পৌল হেৎদ শেলাস লঅ মেশায়নাকু; হেৎদ ভক্ত গ্রীক কুরাঃআ তালারে গাদা হড় হেৎদ গাদা মুখিয়া কুড়ি হনকু ইঙ্কূ লঅ মেশায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","মেন্খান ইহুদিকু ঋৃষা কাতে বাজার রেঙ্কূ কথক বদমাশ হড়কুকে ইদিকাতে মিয়াৎ দল বাইকেৎতেকু নাগার রে রেটেপেটে তেয়ার কেয়াকু হেৎদ যাসোন রাঃআ অড়াতে জার্পা কাতে হড়কু রাঃআ সামাংরে আগু নাতিনাং পৌল হেৎদ শেলাস কে পাঞ্জা লাগায় নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","মেন্খান ইনকিনকে কাকু নামকেৎ কিনতে ইঙ্কূ যাসোন হেৎদ কথক হাগাকুকে সাবকাতে শেহার রিনিজ মাঝিরাঃআ সামাংরে গহাড় ইদিকেৎ কুয়াকু, কিকিচকাতে গাম লাগায়নাকু, নিকু হড়কু গোটা ধার্তিরে রেটেপেটে করা ঘুরায়তানাকু, নিকু নেথাং রেহঅ সেটেরা কানাকু; ");
INSERT INTO cdz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","যাসোন ইঙ্কিন কে খাতিরতাৎ কিনায়; হেৎদ নিকিন বারহড় কৈসররাঃআ হুকুম রাঃআ বিরুধরে তাড়ম কাতে গামেয়াকিন যীশু নুতুমতে অটঅ মিয়াৎ রাপাজ মেনাইয়া। ");
INSERT INTO cdz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","চিন্তং নিয়া থুতি আয়ুম কেয়াকু ইন্তং সাধারণ হড়কু হেৎদ মাঝিকু ললচায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ইন্তং ইঙ্কূ যাসোন রাঃআ হেৎদ এটা যতচ কুরাঃআ জামিন এমকাতে আড়াকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","হেৎদ হাগাকু ইনা নিদা বাতিরাংগে পৌল হেৎদ শেলাস তিকিনকে বিরয়া নাঙ্গা র তেকু কুলকেৎ কিনা। এনথাংরে সেটেরেন্তেকিন ঘিড়মেন্তাং ইহুদিকু রাঃআ সমাজ অড়ারে সেনেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","নিকুদ থিষলনীকী শেহার রেঙ্কূ ইহুদীকু রাঃআ হাতেন ভদ্র তাহিন কেনাকু; চিয়াচি নিকু পুরা ইচ্ছাতে জাগার আয়ুমে কেনাকু হেৎদ সার্তি সারিরাঃআ নাতিনাং সারা হুলাং শাস্ত্র দরবার লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ইনাতে ইঙ্কূ য়া তালারে গাদা ভদ্র হেৎদ গ্রীককু রাঃআ তালারেহঅ গাদা সম্ভ্রান্ত কুড়িহন হেৎদ কড়াহন পাতিয়ায়নাকু ");
INSERT INTO cdz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","মেন্খান থিষলনীকী শেহার রেঙ্কূ ইহুদি চিন্তং সারিনাম কেয়াকু যে, বিরয়ারেহ পৌল রাঃআ হরকাতে ঈশ্বর রাঃআ জাগার পাস্না হুইয়াকানা, ইন্তং ইঙ্কূ এনথাংরেহঅ হিজকাতে হড়কে অস্থির হেৎদ উত্তেজিতকাতে রাকাব লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ইন্তং হাগাকু ঘিড় মেন্তাং পৌলকে দরেয়া জাকিৎ সেন রাঃআ নাতিনাং কুলকিয়াকু; হেৎদ শেলাস হেৎদ তিমথীয় এনথাংরে তাহীনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","হেৎদ অকয় পৌলকে সঙ্গেতে ইদিধরা লিয়াকু, ইঙ্কূ আথীনী শেহার জাকিৎ ইদিকিয়াকু; হেৎদ ইঙ্কূ চিল্কা পৌলকে আড়াকাতে সেনেনাকু, ইঙ্কূ ইনিরাঃআ হান্ডে হাতেন শেলাস হেৎদ তীমথিরাঃআ ঘিড় মেন্তাং ইনিরাঃআ হান্ডে যেন সেন দাড়িকাকিন ইনি রাঃআ নাতিনাং হুকুম নাম কেয়া কিন। ");
INSERT INTO cdz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","পৌল চিন্তং ইঙ্কিন তাঙ্গিরে আথানীতে তাহিনকেনায়, ইন্তং নাগার রাঃআ নাআহানা জায়গারে হাসা ঠাকুর মূর্তি নেলনামকেৎ তে ইনিরাঃআ আত্মা রাগতে জুল রাকাবেনা। ");
INSERT INTO cdz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","এন্তে ইনি সমাজ অড়ারে ইহুদি হেৎদ অইহুদিভক্ত হড়কু রাঃআ হান্ডে হেৎদ বাজাররে সারা হুলাং অকয়কু লঅ নাপাম কেনায়, ইঙ্কূ য়া হান্ডে যীশু রাঃআ বাব্ত্তে থুতিকেনায় ");
INSERT INTO cdz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","হেৎদ ইপিকু রেঙ্কূ হেৎদ ও স্তোয়িকী রেঙ্কূ কথক হড় দার্শনিক পৌল লঅ তর্ক বিতর্ক লাগায়নাকু। হেৎদ অকয়দ গামকেয়াকু \"নিই বকৎবকৎ কিনা গাম বুঝাই তানা? অটঅ অকয়দ গামকেয়াকু ইনিকে এটা দেবতা কুরাঃআ পাস্নাইচ মেন্তে মনেআয়; চিয়াচি ইনি যীশু হেৎদ জিউৎ রাকাব বাব্ত্তে বুগিনবার্তা পাস্না কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","হেৎদ ইঙ্কূ পৌলরাঃআ তিহি সাবকাতে আরেয়পাগে মারাং দরবাররে ইদিকাতে গামকিয়াকু, আলে কি সারি দাড়িয়ালে, নেএ যে নামা চেচেদ আম পাস্না তানাম, নিয়া চিল্কা লেকানা? ");
INSERT INTO cdz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","চিয়াচি আম হুডাং হাহাড়া থুতি গামতাৎ আম; ইনাতে আলে সারিনামে তানালে নিয়া যত থুতি রাঃআ মানে কিনা। ");
INSERT INTO cdz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","চিয়াচি আথীনী নাগার রেঙ্কূ হড় হেৎদ এনথাং রেঙ্কূ বাসায়ান বিদিশুমকু শুধু নামা যাহানা থুতি গাম চি আয়ুম ছাড়া এটা যাহুনারে মাহা কাকু নষ্টয় কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ইন্তং পৌল আরেয়পাগরাঃআ তালারে তিঙ্গুয়েন্তে গামকেয়ায় \"এ আথীনীয় রিন হড়কু নেলেতানাইঞ, আপে যত বিষয়রে কুঠিন ঠাকুর দেবতাভক্ত\" ");
INSERT INTO cdz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","চিয়াচি দাড়াভাড়া হুলাং আপেয়া উপাসনারাঃআ জিনিস নেল নেলতে মিয়াৎ বেদি নেলকেয়াইঞ, অকারাঃআ চেতাংরে অলমেনা \"এটা দেবতা রাঃআ দিশা \" এন্তে আপে যে এটা দেবতা রাঃআ হমরবিন্তি য় তানাপে, ইনিকে ইঞ আপেয়া হান্ডে পাস্না তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ঈশ্বর অকয় জগত হেৎদ ইনারাঃআ তালারে যত জিনিস বাইতাৎ আয়। ইনিগে সেরমা হেৎদ ধার্তি রিনিগ প্রভু, এন্তে মান্মিরাঃআ তিহিরে বাইয়াকানা বাড়িচ রে কায় তাহিনায়; ");
INSERT INTO cdz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","যাহান অভাবরাঃআ কারণতে হড়রাঃআ দেঙ্গাহঅ কায় হাতায়আয়, ইনিগে যতচ কে জিউ হেৎদ শাঃহেদ যতগে এমতাৎ কুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","হেৎদ ইনি মিয়াৎ মান্মি হাতেন মান্মিরাঃআ যত জাতি সির্জাওতাৎ কুয়্যায়, ইনি তাহিরাঃআ নাতিনাং নিয়া ধার্তি এমতাৎ আয়, ইনি তাহিরাঃআ নাতিনাং মাহা সীমা ঠারাও তাৎ আয়, ");
INSERT INTO cdz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","যেন ইঙ্কূ ঈশ্বরকে পাঞ্জাইকাআকু, যদি যাহানা পাঞ্জা পাঞ্জাতে ইনি রাঃআ নাপাময়াকু, অথচ ইনি আবুয়া যাহায় রাঃআ হান্ডে হাতেন সাঙ্গিনরে বানুইয়া। ");
INSERT INTO cdz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","চিয়াচি ঈশ্বররেগে আবু বাঞ্চা মেনাবুয়া, আবুয়া গজঃঅ হেৎদ বাঞ্চা, চিল্কা আপেয়া কথক হড় কবিহঅ গামতাৎকু \"চিয়াচি আলেহঅ ইনিরাঃআ পিড়ি। ");
INSERT INTO cdz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ইনা মেন্তে আবু চিন্তং ঈশ্বর রাঃআ হন, ইন্তং ঈশ্বর রাঃআ স্বভাবকে মান্মিরাঃআ শিল্প হেৎদ চিন্তা লেকাতে বাইয়াকানা সোনা চি রুপা চি দিরি লঅ তুলনা আবুয়া লাক্তি লহয়তানা। ");
INSERT INTO cdz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ঈশ্বর ইনা অবুঝ মাহা কে বাগিগিডিতিয়ায়, মেন্খান নাহা যত থাং রেঙ্কূ যত মান্মিকে মন পাল্টারাঃআ হুকুম এমকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","চিয়াচি ইনি মিয়াৎ মাহা গটা তাৎ আয়, অকা হুলাং নিজেরাঃআ বাছায়ান হড়রাঃআ দ্বারায়তে ধার্তি রেঙ্কূ হড়কে দরবার কুয়ায়, হেৎদ নিয়া যতরাঃআ পাতিয়া জুকুরাং প্রমাণ এমতাৎ আয়, ইনাতে গজকুরাঃআ তালা হাতেন ইনিকে রাকাবতিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","এন্তে গজকুরাঃআ জীউৎ রাকাবরাঃআ থুতি আয়ুমকাতে কথক লান্দা লাগায়নাকু, মেন্খান কথক গামকেয়াকু, আমা হান্ডে নিয়া বাব্ত্তে অটঅ মিশা আয়ুমেয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","নেকাগে পৌল ইঙ্কূ য়া হান্ডে হাতেন সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","মেন্খান কথক হড় ইনি লঅ গাতিকাতে যীশুকে পাতিয়া কিয়াকু, ইঙ্কূ য়া তালারে আরেয়পাগী রিনিজ দিয়নুষিয় হেৎদ দামারি নুতুমিজ মিয়াৎ কুড়িহন হেৎদ অটঅ কথক হড় তাহিন কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ইনা তায়ম পৌল আথীনী নাঙ্গা র হাতেন সেএন্তে করিন্থ নাঙ্গা র তে হিজেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","হেৎদ ইনি আক্কিলা নুতুমিজ মিয়াৎ ইহুদিরাঃআ দেখা/সাক্ষাত নামকেয়ায়, ইনি জাতিতে পন্তীয়, হুডাং মাহা মাড়াঙতে নিজেরাঃআ এরাতেদ প্রিস্কিল্লা লঅ ইতালীয়া হাতেন হিজেনাকিন, চিয়াচি ক্লৌদিয় যত ইহুদিকুকে রোম শেহার হাতেন নির নাতিনাং হুকুম লাদকুয়ায়। পৌল ইনকিনা হান্ডে সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","হেৎদ ইনি ব্যাপারি লেকা হুইয়েন্তে ইঙ্কিন লঅ তাহিনায়, হেৎদ ইঙ্কূ কামী লাগায় নাকু, চিয়াচি ইঙ্কূ তাম্বু বাইরাঃআ ব্যাপারি তাহিনকেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","মিমিৎ ঝিরাও মাহারে ইনি সমাজ অড়ারে (মন্ডলীরে) জাগার গামেৎ কেনয় হেৎদ ইহুদি হেৎদ গ্রীক কুকে পাতিয়া নাতিনাং উৎসাহ কেনকুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","চিন্তং শেলাস হেৎদ তীমথিয় মাকিৎ নিয়া হাতেন হিজেনাকিন, ইন্তং পৌল জাগার পাস্না কেনায়, যীশুগে যে খ্রীষ্ট, ইনারাঃআ প্রমাণ ইহুদিকে এমকেন কুয়্যায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","মেন্খান ইহুদিকু বিরুধ হেৎদ নিন্দা কিয়াকু খানঃঅ পৌল সনঃঅ ককাউডি তে ইঙ্কূকে গামাৎ কুয়ায়, আপেয়া মায়ম আপেয়া বহঃঅরে নুরঃঅকা, ইঞ ছুত, নাহা হাতেন অইহুদি কুরাঃআ হান্ডে সেনেনাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","হেৎদ ইনি এন্ডে হাতেন সেনেএন্তে তিতিয় যুষ্ঠ নুতুমিজ মিয়াৎ ঈশ্বর ভক্তরাঃআ অড়াতে সেনেনায়, অকয়রাঃআ অড়া সমাজ অড়ারাঃআ (মন্ডলীরাঃআ) ঠাইনরেগে তাহীনকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","হেৎদ সমাজ রিনিজ মন্ডলী রিনিজ চালাইজ ক্রিস্প পুরা পরিবার লঅ প্রভুকে পাতিয়াকিয়াকু, হেৎদ করিন্থীয়কুরাঃআ তালারে ঢেরলেকা হড় আয়ুমকেৎ তেকু পাতিয়ায়নাকু, হেৎদ ডুবুনেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","হেৎদ প্রভু নিদা বাতিরাং কুকুমুতে পৌলকে গামকিয়ায়, আলম বরয়া, বরঞ্চ থুতিম, আলম থির তাহিনা, ");
INSERT INTO cdz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","চিয়াচি ইঞ আম লঅ সঙ্গে সঙ্গে মেনাইঞা, আমকে হিংসাকাতে যাহায় আমকে কাকু আক্রমণ মেয়াকু, চিয়াচি নিয়া নাঙ্গা র রে ইঞা গাদা বিশ্বাসী মেনাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ইনাতে ইনি মিদ সির্মাং তারা তাহীনতে ইঙ্কূয়া তালারে ঈশ্বর রাঃআ জাগার চেদ কেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","মেন্খান গাল্লীয়ো চিন্তং আখায়া টোলা রিনিজ মুখিয়া হুইয়েনায়, ইন্তং ইহুদিকু মিশাতে পৌল রাঃআ বিরুধরে রাকাবেনাকু, হেৎদ ইনিকে দরবার আসনরে ইদিকিৎ তিকু গামকেয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","নিই হড় আরিচালিরাঃআ উল্টা ঈশ্বর রাঃআ হমরবিন্তি নাতিনাং হড়কুকে খারাপ বুদ্ধিতে ফুসলাকুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","মেন্খান চিন্তং পৌল মচা লাড়াতে সেনকেনায়, ইন্তং গাল্লিয়ো ইহুদিকুকে গামাৎ কুয়ায়, যাহান ব্যপারতে দোষ চি অপরাধ যদি হুইয়া হুনাং, এন্খান এ ইহুদিকু, আপেয়া নাতিনাং ন্যায় দরবার ইঞা হান্ডে লাক্তি সম্মত হুইয়া হুনাং, ");
INSERT INTO cdz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","মেন্খান জাগার চি নুতুম চি আপেয়া আরিচালি ব্যাপারতে কুকলি যদি হুইয়া, এন্খান আপে নিজেগে সাম্ভাড়ায়পে, ইঞ ইঙ্কূ রাঃআ নাতিনাং দরবার িজ হুইঅ কাইঞ নানামতানা। ");
INSERT INTO cdz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","হেৎদ ইনি ইঙ্কূকে দরবার আসন হাতেন হারগিডি কেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ইনাতে যতচ মন্ডলী অড়া রিনিজ চালাইজ সোস্থিনিকে সাবকিৎ তিকু সমাজরাঃআ দরবার আসনরাঃআ সামাংরে দালকিয়াকু, হেৎদ গাল্লীয় ইনা যত বাব্ত্তে যাহানা কায় লুতুর লাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","পৌল অট গাদামাহা তাহীনতে হাগাকুরাঃআ হান্ডে হাতেন কয়্তুকা হাতাকেৎ তে দরেয়া হরাতে সুরিয়া প্রদেশতে সেনেনায় হেৎদ ইনি লঅ প্রিস্কিল্লা হেৎদ আকিলা হঅ সেনেনাকিন, ইনি কংক্রিয়া নাঙ্গা র রে বহঃঅ হয়কেয়ায়, চিয়াচি ইনিরা মিয়াৎ দিব্যি তাহীনকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","তায়মতে ইঙ্কূ এফিষতে সেটেরেনাকু, হেৎদ ইনি ইঙ্কিন বারহড়কে এনথাংরে দঃহকেৎ কিনায়, নিজে সমাজ অড়ারে সেনকাতে ইহুদিকুরাঃআ হান্ডে জাগার পাস্না কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","হেৎদ ইঙ্কিন আকিনা হান্ডে অট হুডাং মাহা তাহী নাতিনাং ইনিকে কষামুদিকিৎ তিকিন রহঅ ইনি কায় রাজি লেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","মেন্খান ইঙ্কিন হান্ডে হাতেন কয়্তুকা হাতাকেৎতে, গামকেৎ কিনায়, ঈশ্বর রাঃআ ইচ্ছা হুই লেংখান ইঞ অট আপেয়া হান্ডে রুয়াড় হিজুআইঞ। হেৎদ ইনি দাঃআ হরকাতে ইফিষ হাতেন সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","কৈসরিয়া শেহার তে হিজকাতে (যিরুশালেম শেহার তে) সেনেনায় হেৎদ মন্ডলীকে জোহারকেৎকু তে আনচু এমকাতে এন্ডে হাতেন আন্তিয়খিয়াতে সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","এনথাংরে কথকমাহা পারম তায়ম ইনি অট সেনেনায় হেৎদ পরপর গালাতিয়া হেৎদ ফরুগিয়া প্রদেশ ঘুরা ঘুরাতে চেলাকুকে আশ্বাসকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","আপৌল্লো নুতুমিজ মিয়াৎ ইহুদি, জাতিতে, জানাম হাতেন মিয়াৎ আলেকসান্দ্রিয়, মিয়াৎ বুগিন গামিজ, ইফিষতে হিজেনায়, ইনি শাস্ত্ররে আকেলী তাহিনকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ইনি প্রভুরাঃআ হরারাঃআ বাব্ত্তে চেচেদ নামলাৎআয় হেৎদ আত্মারাঃআ দাড়িতে যীশু রাঃআ বাব্ত্তে বেশঠিকরা থুতি গামেকেনায় হেৎদ চেচেদ এমকেনকুয়ায়, মেন্খান ইনি শুধু যোহনরাঃআ ডুবুন সারিকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ইনি সমাজ অড়ারে (ধর্ম অড়ারে) সাহসতে থুতি গাম লাগায়নায়। হেৎদ প্রিস্কিল্লা হেৎদ আক্কিলা ইনিরা আচু আয়ুমকিয়তিকিন ইনিকে আকিনা হান্ডে আউকিয়াকিন হেৎদ ঈশ্বর রাঃআ হরা অট বেশ ঠিকরা বুঝাকেৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","হেৎদ ইনি আখায়াতে সেন সানাকিয়া খানঃঅ হাগাকু উৎসাহ এমকিয়াকু, হেৎদ ইনিকে সঙ্গেতে ইদি নাতিনাং চেলাকুকে গিরা অলকেৎকু য়ায়। ইনাতে ইনি এন্ডেটা সেটেরেন্তে, অকয় দায়া দুলাড়তে পাতিয়ালেনাকু, ইঙ্কূকে গাদা দেঙ্গাকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","চিয়াচি যীশুগে যে খ্রীষ্ট, নিয়া শাস্ত্ররাঃআ জাগাররে প্রমাণকাতে আ পৌল্লো ক্ষমতা লঅ হড়কুরাঃআ তালারে ইহুদিকুকে একদম থিরকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","আপৌল্লো অকা হুলাং করিন্থ নগররে তাহিন কেনায়, ইনা হুলাং পৌল বুরু টোলা হরকাতে ইফিষ নগরতে হিজেনায়। এনথাংরে কথক চেলাকু লঅ নাপামেনায়, ");
INSERT INTO cdz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","হেৎদ পৌল ইঙ্কূকে গামাৎ কুয়ায়, চিন্তং আপে বিশ্বাসী হুইলেনাপে ইন্তং আপে দচি রীলামালা আত্মা নামলাআপে? ইঙ্কূ ইনিকে গামাকিয়াকু, রীলামালা আত্মা যে মেনা, ইনা থুতি আলে কালে আয়ুমতাৎআ। ");
INSERT INTO cdz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ইনি কুলিকেৎ কুয়ায়্য়, এন্খান কিনাতে ডুবুন লেনাপে? ইঙ্কূ গাম রুয়াড় কেয়াকু, যোহনরাঃআ ডুবুনতে। ");
INSERT INTO cdz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","পৌল গামকেয়ায়, যোহন মন পাল্টা রাঃআ ডুবুলতে ডুবুলেৎ কেন পেয়ায়, হড়কুকে গামকেৎ কুয়ায়, অকয় ইনিরা তায়মতে হিজুআয়, ইনিকে অর্থাৎ যীশুকে পাতিয়া হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","নিয়া থুতি আয়ুমকাতে ইঙ্কূ প্রভু যীশুরাঃআ নুতুমতে ডুবান হাতাকেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","হেৎদ পৌল ইঙ্কূয়া চেতাংরে তিহি দঃহ কাতে বিন্তিকেয়ায় খানঃঅ রীলামালা আত্মা ইঙ্কূ য়া চেতাংরে হিজেনা, ইনাতে ইঙ্কূ নাআহানা জাগারতে থুতি গাম হেৎদ হাপেন জাগার গাম লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ইঙ্কূ যতচ তে মোট গেল বার কড়াহন তাহিন কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","হেৎদ ইনি সমাজ অড়ারে সেনকাতে আপি বঙ্গা সাহস লঅ থুতি গামকেয়ায়, ঈশ্বর রাঃআ মুলুক রাঃআ বিষয় যুক্তিতে বুঝাকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","মেন্খান কথক হড় দয়াবানু হেৎদ বেঃরাহী য়েন্তেকু হড়কু রাঃআ সামাংগে ইনা হরারাঃআ নিন্দা লাগায়নাকু, হেৎদ ইনি ইঙ্কূ য়া হান্ডে হাতেন সেনেএন্তে চেলাকুকে ভিনাকেৎকু য়ায়, হার মাহা তূরান্ন রাঃআ আখড়া অড়া রে থুথি জাগার লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","নেকাগে বার সির্মাং সেনেনা, ইনাতে এশিয়া মুলুক মুলুকরে বাসায়ান ইহুদি হেৎদ গ্রীক যতচ গে প্রভু রাঃআ জাগার আয়ুম কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ঈশ্বর পৌল রাঃআ তিহি হরকাতে গাদা হাহাড়ায কামী কেয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","নেকাগে পৌল রাঃআ হড়মো হাতেন ইনিরাঃআ তিজোৎ চি হড়মছা রুয়া-হাসুতান হড় কুরাঃআ হান্ডে আগু লেন্খান ইঙ্কূ য়া রুয়া-হাসু বুগিকেনা হেৎদ বাড়িচ আত্মা উডুঙওকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","কথক হড় দাড়ান ইহুদি ওঝাকুহঅ প্রভু যীশু রাঃআ নুতুম কাতে বাড়িচ আত্মাতে নামাকান হড়কে বুগিতে কুরুমুটু কেয়াকু, হেৎদ গাম কেয়াকু, পৌল অকয়কে পাস্নায়ায়, ইনি যীশুরাঃআ নুতুমতে ইঞ আপেকে উডুঙ রাঃআ নাতিনাং হুকুমা তানাপিঞ। ");
INSERT INTO cdz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","হেৎদ স্কিবা নুতুমিজ মিয়াৎ ইহুদি ডিহি বামড়ে রাঃআ সাতটা কড়াহন তাহীন কেনাকু, ইঙ্কূ নেকায় কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ইনাতে বাড়িচ আত্মা গাম রুয়াড় কাতে ইঙ্কূ কে কুলিকেৎ কুয়ায়, যীশুকে ইঞ সারিঞ, পৌল কেহঅ সারিঞ, মেন্খান আপে অকয়? ");
INSERT INTO cdz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ইন্তং অকা হড়টা বাড়িচ আত্মাতে সাবলিয়ায়, ইনি ইঙ্কূ য়া চেতাংরে জেহেৎ কাতে নুরেনায়, বার্ হড়কে এনকা দাড়িতে লাঠা দঃহঅ কেৎ কিনায় যে, ইঙ্কিন ডেন্ডে হেৎদ পুটুর-চেগেড়েন্তেকিন অড়া হাতেন নিরেনাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","হেৎদ ইনা ইফিষ রেঙ্কূ যত ইহুদি হেৎদ গ্রীক হড়কু সারিনামকেয়া, ইনাতে যতচ বরয়নাকু হেৎদ প্রভু যীশুরাঃআ নুতুম গৌনজহার কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","হেৎদ গাদা পাতিয়ান হড় হিজলেনাকু হেৎদ ললয়েন্তেকু ইঙ্কূয়া আকুয়া আকুয়া বেবাড়িচ কামি হেৎদ স্বীকার উদু লাগায়নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","হেৎদ অকয় পাইটকার কামিকেনাকু, ইঙ্কূ য়া তালারে গাদাকু নিজে নিজেরাঃআ পুথি আগুকাতে হুন্ডিকেৎ তেকু যতচ রাঃআ সামাংরে আতার তরেচ কেয়াকু, ইনা যতরাঃআ দাম হিসাব কাতে নেল নামেনা, ড়েলি জুলু রুপা রাঃআ কাউডি। ");
INSERT INTO cdz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","নেকাগে প্রভু রাঃআ জাগার হাহাড়াগে বাড়ায়না হেৎদ পাতিয়ান হড় কুহঅ ডেরে নাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","নিয়া যত কামী চাবা তায়ম পৌল রীলামালা আত্মাতে ভরেনতে গটা কেয়ায় যে, ইনি মাকিদনিয়া হেৎদ আখায়া সেন তায়ম যিরুশালেম শেহার সেনায়, ইনি গাম কেয়ায়, এনথাংতে সেন তায়ম ইঞকে রোম শেহার নাগার হঅ নেল হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","অকয় ইনিরাঃআ সেবায় কেনাকিন, ইঙ্কিন বারহড়কে, তীমথিয় হেৎদ ইরাস্তকে, মাকিৎ নিয়াতে কুলকেৎ কিন্তে ইনি নিজে কথক মাহা এশিয়া মুলুক রে তাহীনায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ইনা হুলাং নিয়া প্রভু রাঃআ হরা ইদিকাতে রেটেপেটে হুইয়েনা। ");
INSERT INTO cdz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","চিয়াচি দিমীত্রিয় নুতুমিজ মিয়াৎ রৌপ্যকারিগরী দেবী টুসু (দিয়ানা) রাঃআ রুপা বাড়িচ বাইয়েৎ কেনায় হেৎদ কারিগরীকুকে যাহুকামি জোগাড়েৎ কেনকুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ইনি হড়টা ইঙ্কূকে হেৎদ ইনা ব্যবসা রেঙ্কূ কারিগরী কুকে রাঃআ কাতে গামকেৎকুয়ায়, গমকেকু, আপে সারিয়াপে, নিয়া কামী দ্বারায়তে আলে আরজায়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","আপে নেলেয়াআপে হেৎদ আয়ুমেয়াআপে, একেন নিয়া এফিষরে লহয়, প্রায় গোটা এশিয়া মুলুকরে নিই পৌল গাদা হড়কে প্রভাব তাৎ কুয়ায়, নিয়া গামতাৎ আয় যে, অকা দেবতা তিহিতে বাইয়াকানা, ইঙ্কূ ঈশ্বর লহয়। ");
INSERT INTO cdz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","এন্তে নিয়া বরঃঅ বুঝাতানা, একেন আবুয়া ব্যবসারাঃআ দুর্নাম হুইওয়া, ইনাদ লহয়, মেন্খান মারাং দেবী দিয়ানা রাঃআ মন্দির ধাসা চাবা, অটঅ ইনিকে কাকু ছুতাংইয়া, অকয়কে গোটা এশিয়া মুলুক, এমনকি, গোটা দুনিয়া বঙ্গাইয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","নিয়া থুতি আয়ুমকাতে ইঙ্কূ হড় রাগেন্তেকু কিকিচ কাতে গাম লাগায়নাকু, ইফিষয় রেঙ্কূরাঃআ দিয়ানাগে মারাং দেবীতানায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ইনাতে নাগার রে রেটেপেটে লাগায়না, হেৎদ হড়কু মিশাতে এনেচ আখড়া রাঃআ হান্তে নিরকেয়াকু, মাকিদনিয়া রিনকিন গায় হেৎদ আরিষ্টার্খ, পৌল রাঃআ নিকিন বারহড় গাতিকিনকে সাব ইদিকেৎ কিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ইন্তং পৌল হড় রাঃআ হান্ডে সেন নাতিনাং মনকেয়ায় খানঃঅ চেলাকু কাকু সেনতুকালিয়া। ");
INSERT INTO cdz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","হেৎদ এশিয়া মুলুক রেঙ্কূ হাকিমকু রাঃআ তালারে কথক হড় গাতি তাহিলেনাকু মেন্তে ইনিরাঃআ হান্ডে হড় কুল কেৎকু তে নিয়া কষামুদি কিয়ায়, যেন ইনি রঙ্গ ডাহিতে নিজে রাঃআ বিপদ ঘটাতে আল সেনঃঅ কাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","হেৎদ নায়িজ-হানিজ হড় নাআহানা থুতি গামকাতে কিকিজে কেনাকু, চিয়াচি দরবার রেটেপেটে লাগালেনা হেৎদ কিনা মেন্তে হুন্ডিলেনাকু, ইনা গাদা হড়গে কাকু সারিকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ইন্তং ইহুদিকু আলেকসান্দরকে সামাংরে হাজির কিয়াকু খানঃঅ হড়কু রাঃআ তালা হাতেন ইনিকে উডুঙ কিয়াকু, ইনাতে আলেকসান্দর তিহিতে চুন্দুল কাকেৎ তে হড় কুরাঃআ হান্ডে সায় নাতিনাং কুরুমুটু কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","মেন্খান চিন্তং ইঙ্কূ সারিনাম কেয়াকু যে, ইনি, ইহুদি তানায়, ইন্তং যতচ মিৎসুরতে বার্ ঘান্টি লেকা নিয়া গামকাতে কিকিচ লাগায়নাকু, এফিষ শেহার রিনিজ দিয়ানা গে মারাং দেবী তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","মুচাদরে নাগার রিনিজ কোটাল হড়কুকে হাপেকেৎকু তে গামকেৎকু য়ায়, দুলাড়িয়া ইফিষীয় নাগার হড়কু, গামেপে সিনাং, ইফিষীয় নাগার কুরাঃআ নাগার রে অকা মারাংদেবী দিয়ানা রাঃআ হেৎদ নীরালা হাতেন উয়ুয়াকান মূর্তি রাঃআ ধিরি কেচা হড়কু রাঃআ তালারে, অকয় কাকু সারিয়া? ");
INSERT INTO cdz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","এন্তে নিয়া থুতি কা-পাতিয়া রাঃআ যাহানা হরা বায়ায়না সারিকাতে আপে থির থার তাহিন হেৎদ অবিবেচনা রাঃআ যাহানা কামি লাক্তি ল্হয়তানা। ");
INSERT INTO cdz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","চিয়াচি নিকু যে হড়কুকে নেথাংরে আউতাৎ কুয়াপে, ইঙ্কূ বাড়িচ কুম্বুড়ুহঅ লহয়, আবুয়া মারাংদেবী রাঃআ বিরুধরে কাকুহঅ ধর্মনিন্দায়া। ");
INSERT INTO cdz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","এন্তে যদি যাহায়রাঃআ বিরুধরে দীমীত্রিরাঃআ হেৎদ ইনিরা হঃঅ কারিগী কু রাঃআ যাহান অভিযোগ তাহিনা, এন্খান কাচারী হজেল মেনা, দিশুম রেঙ্কূ নাপরাং কুহঅ মেনাকুয়া, ইঙ্কূ আকুয়া বিরুধরে লালিচে কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","মেন্খান আপেয়া এটা যাহানা দাবি দাওয়া যদি তাহিনা, এন্খান সারা হুলাং রাঃআ দরবার ইনা শালা হুইওকা। ");
INSERT INTO cdz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","সাধারনতঃ তিহিংরাঃআ ঘটনা রাঃআ নাতিনাং ইঞকে সাসেৎ সাতাও মেন্তে আলেয়া নুতুমতে লালিচ হুইও রাঃআ বর মেনা, যেহুতু নিয়ারাঃআ যাহান কারণ বায়ায়না, নিয়া হড় হুন্ডি রাঃআ বাব্ত্তে তেলা রুয়াড় এম রাঃআ হরা আলেয়া বায়ায়না। ");
INSERT INTO cdz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","নিয়া গামকাতে দরবার রেঙ্কূ হড় কুকে রুয়াড়কেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ইনা রেটেপেটে চাবা তায়মতে পৌল পাতিয়ান চেলাকুকে রাঃআ কুলকেৎ কুয়ায় হেৎদ উৎসাহ এমকেৎকু য়ায় হেৎদ জোহার লঅ কয়্তুকা হাতাকাতে মাকিৎ নিয়াতে সেনঃঅ নাতিনাং সাপড়ায়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","হেৎদ ইনা টোলা হরকাতে সেনকেনায় ইন্তং সেন সেনতে নাআ হানা থুতিতে পাতিয়ান চেলাকুকে উৎসাহ এম এমতে গ্রীক দিশুমতে হিজ সেটেরেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","এনথাংরে আপি বুঙ্গা তাহী তায়ম চিন্তং ইনি দাঃআ হরাতে সুরিয়া দিশুমতে সেন নাতিনাং সাপড়ায়নায় ইন্তং ইহুদিকু ইঙ্কূ য়া বিরুধরে কারসাদীকেয়াকু খানঃঅ ইনি গটা কেয়ায় যে ইনি মাকিৎ নিয়া হরকাতে রুয়াড় সেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","বিরয়া নাগার রিনিজ পুর্হরাঃআ হনতেদ সোপাত্র, থিষলনীকিয় রিনিজ আরিষ্টার্খ হেৎদ সিকুন্দ, দার্ব্বী নাঙ্গা র রিনিজ গায় তীমথিয় হেৎদ এশিয়া মুলুক রিনকিন তুখিক হেৎদ ত্রফিম ইঙ্কূ যতচ ইনি লঅ সেএনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","মেন্খান ইঙ্কূ মাড়াঙতে সেনেন্তিকু রহঅ আলেয়া নাতিনাং ত্রোয়া নাঙ্গা র রে তাঙ্গি কেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","হেৎদ বিনরানু রাঃআ পিঠা পরব(সাক্রাত) চাবায়না খানঃঅ আলে ফিলিপী হাতেন দাঃআ হরাতে সেনকাতে মড়ে মাহারে এোয়াতে ইঙ্কূয়া হান্ডে সেটেরে নালে এনথাংরে সাত মাহা তাহিনালে। ");
INSERT INTO cdz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","হাপ্তারাঃআ মাড়াঙ হুলাং আলে প্রভু ভোজ নাতিনাং পাতিয়ান হড় কুলে হুন্ডিনালে খানঃঅ পৌল দশার হুলাং এনথাং হাতেন সেনঃঅ নাতিনাং পরিকল্পনা কেয়ায় খানঃঅ ইনি চেলা কুরাঃআ হান্ডে তালা নিদা জাকিৎ ভাষন এমলাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","আলে অকা চেতাং কুঠিরে যতচ হুন্ডিলেনালে এনথাংরে গাদা দিউহা তাহিন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","হেৎদ উতুখ নুতুমিজ মিয়াৎ জুয়ান ঝুরকা কাতারে দুবলেনায়, ইনি হরদম দুদুড়ুমেন্তে গিতিজ-শয়ঃজেনায়, হেৎদ পৌল অটঅ গাদা ঘাড়ি জাকিৎ ভাষন এমকেয়ায় খানঃঅ ইনি গিতিজ-শয়ঃ জেনায় খানঃঅ আপি তালা হাতেন লাতারতে নুরেনায়, ইনাতে হড়কু ইনিকে গজ অবস্থারে তুল ইদিকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ইন্তং পৌল আড়গু য়েন্তে ইনিরাঃআ হড়মো চেতাংরে নুরেনায়, হেৎদ ইনিকে হাম্বুত কিয়ায় হেৎদ গামাৎ কুয়ায় আপে কিকিজেয়া, চিয়াচি নিই রাঃআ হান্ডে নাহাহঅ জিউ মেনাগেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","হেৎদ ইনি চেতাংতে সেনকাতে পিঠা কেচাকেৎ তে গাদাঘাড়ি, এমনকি, নিদা হাতেন সেতা জাকিৎ থুতি বাত্রায়নায়, হেৎদ ইনি এনথাং হাতেন সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","হেৎদ ইঙ্কূ ইনি কড়াহনটাকে জীউৎ অবস্থারে নাম রুয়াড় কিৎ তেকু অসাধারণ পাতিয়া আর্যাকেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","হেৎদ আলে মাড়াঙতে সেনকাতে জাহাজরে দেজেন্তে, আসস নাগার রাঃআ দিশাকাতে সেসেন কেয়াকু হেৎদ এন্ডে হাতেন পৌলকে রাকাব নাতিনাং মন গটা কেয়ালে, নিয়া ইনি নিজেগে সানালিয়ায়, চিয়াচি ইনি অতে হরাতে সেনঃঅআয় মেন্তে পরিকল্পনা কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","হেৎদ ইনি আঃসেরে আলে লঅ আলে ইনিকে দেচকিৎ তেকু মিৎ লীনী নাঙ্গা র তে হিজেনালে। ");
INSERT INTO cdz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","এনথাং হাতেন জাহাজ লাড়াকেৎ তে গাপা হুলাং খীয়র ঢিপরাঃআ সামাংরে সেটেরেনালে, ইনা দশার হুলাং সামস ঢিপ তেলে সেনেনাআ, তিশার হুলাং মিলিত নাগার তে হিজেনা। ");
INSERT INTO cdz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","চিয়াচি পৌল ইফিষ বাগি গিডিকাতে সেন গটা লাৎআয়, যাতে এশিয়া মুলুকরে ইনিরাঃআ গাদা মাহা আল তাহি হুইওকা, ইনি ঘিড় ঘিড়কেনায় যেন সাধ্য হুইলেনখান পঞ্চসপ্তমী হুলাং যিরুশালেম শেহার তে হাজির তাহি দাড়িকাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","মিলিত হাতেন ইনি ইফিষতে হড় কুলকেৎকু তে মন্ডলী রেঙ্কূ মুরুব্বি কুকে রাঃআ আউ কেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ইঙ্কূ যতচ ইনিরা হান্ডে হাজিরেনাকু খানঃঅ ইনি ইঙ্কূকে গামাৎ কুয়ায়, আপে সারিয়াপে, এশিয়া মুলুক হিজকাতে, ইঞ মাড়াঙ হুলাং জাকিৎ আপে লঅ চিল্কা মাহা পারমতাৎ আইঞ, ");
INSERT INTO cdz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","পুরাপুরি নম্র মনতে হেৎদ মেদ দাঃআ জরঃঅকাতে হেৎদ ইহুদিকুরাঃআ কারসাদী হাতেন উডুঙও নাআহানা বিডা রাঃআ তালা হাতেন প্রভু রাঃআ সেবা কামিৎ আইঞ, ");
INSERT INTO cdz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","বুগিন লেকানা যাহানা হঅ থুতি কাইঞ উকুকাতে আপে যতচ কে সারিতকা নাতিনাং হেৎদ হড়কু রাঃআ তালারে হেৎদ অড়া অড়ারে চেচেদ এমঃঅতে, কাইঞ তায়মা কানাঞ, ");
INSERT INTO cdz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ঈশ্বর রাঃআ হান্তে মন রুয়াড় হেৎদ আবুয়া প্রভু যীশু খ্রিষ্ট রাঃআ চেতাংরে পাতিয়া বাব্ত্তে ইহুদি হেৎদ গ্রীক বিন ইহুদি কুরাঃআ হান্ডে লুকুন্দী এমকাতে হিজা কানাঞ। ");
INSERT INTO cdz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","হেৎদ নাহাআ নেলেপে, ইঞ আত্মাতে ভরেন্তে যিরুশালেম শেহার তে সেনতানাঞ, এনথাংরে ইঞা কিনা কিনা ঘটাআ, ইনা কাইঞ সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","নিন্তি সারিইঞ, রীলামালা আত্মা মিমিৎ নাগার রে ইঞা হান্ডে নিয়া গামকাতে লুকুন্দী এমেতানায় যে, দাল আটক হেৎদ সাসেৎ ইঞাকে তাঙ্গি তিইনায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","মেন্খান ইঞ ইঞা জিউকেহঅ যাহানা রাঃআ তালারে কাইঞ মেশা য়াইঞ, ইঞা নিজে রাঃআ জিউকে দামি মেন্তে কাইঞ মনেয়াইঞ, যেন ইঞ ঈশ্বর রাঃআ এমাকান হরাতে মুচাদ জাকিৎ নির দাড়িকাইঞ হেৎদ ঈশ্বর রাঃআ দায়া দুলাড় রাঃআ বুগিনবার্তা রাঃআ নাতিনাং লুকুন্দী এমরাঃআ নাতিনাং অকা সেবা কামি রাঃআ দায়িত্ব প্রভু জিহ্সু রাঃআ হাতেন নামতাৎ আইঞ, ইনা চাবা দাড়িকাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","হেৎদ নেলেপে, ইঞ সারিঞ যে, অকয়কু রাঃআ তালারে ইঞ ইনা মুলুক রাঃআ পাস্না কাতে ঘুরাকানাঞ, ইনা আপে যতচ ইঞা মেদমুহাড় অটঅ কাপে নেলনাম দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ইনা মেন্তে ইঞ তিহিঞ আপেয়া হান্ডে নিয়া লুকুন্দী এমেতানাইঞ যে, যতচ রাঃআ মায়মরাঃআ দায় হাতেন ইঞ ছুত, ");
INSERT INTO cdz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","চিয়াচি ইঞ আপেয়া ঈশ্বর রাঃআ যত পতিকল্পনা সারিরাঃআ নাতিনাং কাইঞ বুকুড়ুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","আপে আপেয়া বাব্ত্তে হুঁশিয়ার হেৎদ রীলামালা আত্মা আপেকে পরিচয় নাতিনাং অকয়রাঃআ তালারে পালক করাতাৎ আপে, ইনা যত পালরাঃআ বাব্ত্তে হুঁশিয়ার পে, ঈশ্বর রাঃআ ইনা মন্ডলীকে নেল আতেনেপে, অকয় কে ইনি নিজে রাঃআ মায়মতে কিরিঞ তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ইঞ সারিঞ ইঞ সেনঃঅ তায়ম হাগুরী হুন্ডার আপেয়া তালারে হিজুআয়, হেৎদ পাল রাঃআ নাতিনাং কায় দায়া-মায়াআয়, ");
INSERT INTO cdz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","হেৎদ আপেয়া তালা হাতেন কথক হড় বিরিদ কাতে চেলাকুকে নিজে রাঃআ হান্তে অর নাতিনাং বাকা ঢেকা উল্টা থুতিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","এন্তে চির্গাল তাহিনোপে, মনে দঃহয়পে ইঞ আপি সির্মাং জাকিৎ নিদা সিঙ্গি মেদ দাঃআ যর লঅ মিমিৎ কে চেতনা এমঃঅতে কাইঞ থাকা কানাঞ। ");
INSERT INTO cdz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","হেৎদ নাহা ঈশ্বর রাঃআ হান্ডে হেৎদ ইনি রাঃআ দায়া দুলাড় জাগার রাঃআ হান্ডে আপেকে সম্পাকেৎ পেয়াইঞ, ইনি আপেকে গালাং রাকাবতে হেৎদ রীলামালায়ান যতচ কু রাঃআ তালারে দায়া-অধিকার এমঃঅতে সক্ষম। ");
INSERT INTO cdz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ইঞ যাহায় রাঃআ রুপা চি সোনা চি কিচি-সনঃঅরাঃআ চেতাংরে কাইঞ লালসা কানাইঞ (1 শামু . 12:3 ");
INSERT INTO cdz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","আপে নিজেহঅ সারিয়াপে, ইঞা নিজে রাঃআ হেৎদ ইঞা গাতিকু রাঃআ অভাব সরা গিডি রাঃআ নাতিনাং নিয়া বারতিহিতে পরিসেবায় তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","যত বাব্ত্তে ইঞ আপেকে দৃষ্টান্ত উদুতাৎ পেয়াইঞ যে, নে নেকা মেহনত কাতে নিজুরি কুকে দেঙ্গা হুইওয়া হেৎদ প্রভু যীশু রাঃআ জাগার পাহাম লাক্তি হেৎদ ইনি নিজে গামতাৎ আয়, হাতা হাতেন বরঞ্চ এমঃঅ সারাও বিষয়। ");
INSERT INTO cdz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","হেৎদ নিয়া থুতি গামকাতে ইনি উকড়ুমেন্তে যতচ লঅ বিন্তিকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ইনাতে যতচ কুঠিনগে ইয়ামকেয়াকু হেৎদ পৌলকে হাম্বুত কিৎ তেকু চঃঅ কিয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","যত হাতেন ইনিরাঃআ নিয়া থুতিরাঃআ নাতিনাং গাদা দুঃখয়নাকু যে, ইঙ্কূ ইনিরাঃআ মেদ মুহাড় অটঅ কাকু নেলনাম লাদআ। তায়মতে জাহাজ জাকিৎ ইনিকে আড়াতকা সেনেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","মুরুব্বি কুরাঃআ হান্ডে হাতেন দুখ লঅ কয়তুকা হাতাকেৎ তেলে হেৎদ জাহাজতে সজে হরাতে কো ঢিপ তে হিজেনালে, গাপা হুলাং রোদঃঅ ঢিপ তে হেৎদ এনথাং হাতেন পাতারা নাঙ্গা র তে সেটেরে নালে। ");
INSERT INTO cdz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","হেৎদ এন তাহংরে এনকান মিয়াৎ জাহাজ নাম কেয়ালে অকাটা ফৈনীকিয়াটলা তে সেনাঃআ, আলে ইনা জাহাজতে সেনেনালে। ");
INSERT INTO cdz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","হেতদ কুপ্র ঢিপ নেলনাম কেয়ালে হেৎদ ইনা ঢিপ টাকে আলেয়া লেঙ্গা তিহিদর বাগি তুকা কেয়ালে, সুরিয়া দিশুমতে সেনেকাতে, সোর নাঙ্গা র তে আড়গুনালে, চিয়াচি এনথাংরে জাহাজ রাঃআ মালপত্র আড়গু রাঃআ কথা তাহিলেনা। ");
INSERT INTO cdz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","হেৎদ এনথাং রেঙ্কূ চেলা কুকে পাঞ্জা কাতে আলে এনথাংরে সতী মাহা তাহিনালে, ইঙ্কূ আত্মা রাঃআ দ্বারায়তে পৌলকে যিরুশালেম শেহার তে সেনঃঅ মানা কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ইনা সাতী মাহা তাহিন তায়ম আলে সেনেনালে, ইন্তং ইঙ্কূ যতচ এরা হেৎদ কড়াহন কুড়ি হন কুকে লঅ ইদিকাতে আলেকে আড়াতুকা হিজেনাকু, নাই পাড়, এনথাংরে আলে উকুড়ুমেন্তে বিন্তিকাতে মিহুড় অটঅ মিহুড়কে কয়্তুকা এমকেৎকু য়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","আলে জাহাজরেলে দেজেনা, ইঙ্কূ আকুয়া অড়াকু রুয়াড় সেনেনা। ");
INSERT INTO cdz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","হেৎদ সোর শেহার রাঃআ দাঃআ হরকাতে সেন মুচাদকাতে আটক িমায়ি শেহার তে সেটেরেনালে, হেৎদ পাতিয়ান হাগাকুকে জোহার কেৎকু য়ালে হেৎদ ইঙ্কূ লঅ মিদ মাহা তাহিনালে। ");
INSERT INTO cdz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","গাপা হুলাং আলে এনথাং হাতেন সেনেএন্তে কৈসরিয়া শেহার তে সেটেরেনালে হেৎদ বুগিন বার্তা পাস্না ক ফিলিপ, অকয় ইঙ্কূ সাত জন রেঙ্কূ মিহুড়, ইনিরাঃআ অড়ারে আলে তাহিনালে। ");
INSERT INTO cdz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ইনিরা উপুনিয়া ডাংগুয়া হনেরাতেদ তাহিলেনাকু, ইঙ্কূ ভাবি জাগার গামেকেনাকু (যোয়েল . 2:28 ) ");
INSERT INTO cdz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","আলে এনথাংরে গাদা মাহা তাহিন কেনালে হেৎদ ইহুদিয়া মুলুক হাতেন আগাব নুতুমতে মিয়াৎ ভাবি জাগারিজ হাজিরেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","হেৎদ ইনি আলেয়া হান্ডে হিজেন্তে পৌলরাঃআ মায়াং তনলটা ইদিকেৎ তে, নিজেরাঃআ তিহি কাটা আটক ন্তে গামকেয়ায়, রীলামালা আত্মা নিয়া থুতি গামেতানায়, নিয়া মায়াং তনলটা অকয়রাঃআ, ইনিকে ইহুদিকু যিরুশালেম শেহার রে নেকাগে আটকয়াকু হেৎদ বিনইহুদি হড়কু রাঃআ তিহিরে সম্পাইয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","নিয়া থুতি আয়ুমকেৎ তেলে আলেহঅ এনথাং রেঙ্কূ পাতিয়ান হাগাকু পৌলকে কষামুদিকিয়াকু, ইনি যেন যিরুশালেম শেহার তে আলয় সেনঃঅ কাআয়। ");
INSERT INTO cdz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ইন্তং পৌল গামকেয়ায়, আপে নাআ কিনা চিকায় তানাপে? ইয়ামকাতে ইঞা অন্তরকে চিয়া ছারখারে তানাপে? চিয়াচি ইঞ প্রভু যীশু রাঃআ নুতুম রাঃআ নাতিনাং যিরুশালেম শেহার রে একেন আটক নাতিনাংদ লহয়, গজঃঅতেহঅ তেয়ার মেনাইঞা। ");
INSERT INTO cdz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","নেকাগে ইনি আলেয়া থুতি আয়ুমতে কায় মানা লেনায়, ইন্তং আলে থিরে নালে হেৎদ গামকেয়ালে প্রভুরাঃআ ইচ্ছা পুরাঃআ কাআ। ");
INSERT INTO cdz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ইনা তায়ম আলে জিনিসপত্র গুটিয়া কাতে যিরুশালেম শেহার তেলে সেনেনা। ");
INSERT INTO cdz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","হেৎদ কৈসরিয়া শেহার হাতেন কথক হড় চেলা আলে লঅ হিজেনাকু, ইঙ্কূ কুপ্র ঢিপ রিনিজ ম্নাসোন নুতুমিজ মিহুড়কে সঙ্গেতে আউকিয়াকু, ইনি মাড়াঙ চেলাকুরাঃআ মিহুড়, ইনিরাঃআ অড়ারেগে আলেয়া পাহি হুইরাঃআ কথা। ");
INSERT INTO cdz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","যিরুশালেম শেহার তে সেটেরেনায় খানঃঅ পাতিয়ান হাগাকু আলেকে কুশি লঅ দারমকেৎ লেয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","গাপা হুলাং পৌল আলে লঅ যাকোব রাঃআ অড়াতে সেনেনালে, এনথাংরে যত মুরুব্বিকু হাজিরেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","হেৎদ ইনি ইঙ্কূকে জোহারকেৎকু য়ায় হেৎদ ঈশ্বর ইনি রাঃআ খাতির রাঃআ হরকাতে বিন-ইহুদিকু রাঃআ তালারে অকা সব কামিৎ আয়, ইনা শালাশালী কাতে গামাৎ কুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","নিয়া থুতি আয়ুম কাতে ইঙ্কূ ঈশ্বর রাঃআ গৌনজহার লাগায়নাকু, ইনিকে গামকিয়াকু, বকইঞ, আম সারিয়াম, ইহুদিকু রাঃআ তালারে জুলুজুলু হড় পাতিয়া কানাকু, মেন্খান ইঙ্কূ যতচ আরিচালি মানাবাতা নাতিনাং কুব গে উজ্জুগী। ");
INSERT INTO cdz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","হেৎদ ইঙ্কূ আমা বাবদতে নিয়া থুতি আয়ুমতাৎ আকু যে, আম বিনইহুদিকু রাঃআ তালারে প্রবাসী ইহুদিকুকে মোশি রাঃআ আরিচালি বাগি নাতিনাং চেচেদ এমাতান কুয়াম, যেন ইঙ্কূ হনকুরাঃআ সুনু চুটি আল গেদকুকাকু হেৎদ ইনা লেকাতে আল সেনঃঅ কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","এন্তে নাহা কিনা করা হয়ুয়া ? ইঙ্কূ আয়ুম নামেগেয়াকু যে, আম হিজাকানাম। ");
INSERT INTO cdz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ইনা মেন্তে আলে আমকে কিনা গামাঃআমালে, ইনা করাম। আলেয়া এনকান উপুনিয়া কড়াহন মেনাকুয়া, অকয় মানত তাৎআকু, ");
INSERT INTO cdz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","আম ইঙ্কূ লঅ সেনকাতে নিজেকে ছুতম হেৎদ ইঙ্কূ য়া বহঃঅ হেড় রাঃআ নাতিনাং খরচাম। এন্খান যতচ সারি নামেয়াকু, আমা বাব্ত্তে অকা যত থুতি ইঙ্কূ আয়ুমতাৎ আকু, ইনাকু সার্তি লহয়, বরঞ্চ আম নিজেহঅ আরিচালি মানা বাতাকাতে সার্তি আরি চালি তে সেসেনতানাম। ");
INSERT INTO cdz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","মেন্খান অকা বিনইহুদিকু পাতিয়ানাকানাকু, ইঙ্কূ য়া বাব্ত্তে আলে দরবার কাতে অলতাৎ আলে যে, প্রতিমা রাঃআ প্রসাদ, মায়ম, হটঅ টিপাকাতে গজঃ জানুয়ার কুরাঃআ জিলু হেৎদ হড়মো লটম, নিয়া সমস্ত বিষয় হাতেন যেন নিজেকেকু রুক্ষীয়া আকা। ");
INSERT INTO cdz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","তায়্ম হুলাং পৌল ইঙ্কূ কথক হড় লঅ, ছুত য়েন্তে মুন্দির পিন্ডগীরে বলয়নায় হেৎদ ইঙ্কূ বলি সামাং হাতেন ছুত নাতিনাং চিমিন মাহা লাগাআ, ইনা গাম সদর কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","হেৎদ ইনা সাত মাহা চাবায়না খানঃঅ এশিয়া মুলুক রেঙ্কূ ইহুদিকু মুন্দির রে ইনিরাঃআ দেখা নামকেৎ তেকু যত হড়কে উস্কুরকাতে ললকেৎকু য়াকু হেৎদ ইনিকে সাবকাতে কিকিচকাতে গাম লাগায়নাকু, ");
INSERT INTO cdz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ইস্রায়েল রেঙ্কূ হড়কু দেঙ্গালেপে, নিই ইনি হড়তানায়, অকা সব জায়গারে যতচ কুকে আবুয়া জাতিরাঃআ হেৎদ আরিচালিরাঃআ বিরুধরে নেথাংরে চেচেদ এমকুয়ায়, অট নিকু গ্রীককুকেহঅ মুন্দির রে আউতাৎ কুয়ায়, হেৎদ নিয়া রীলামালা থাং অরীলামালাতাৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","চিয়াচি ইঙ্কূ মাড়াঙতেগে নাগার রে ইফিষীয় নাগার রিনিজ বিনপাতিয়ান ইহুদি ত্রফিমসকে পৌল লঅ নেললিয়াকু হেৎদ আটকার কেয়াকু পৌল ইনিকে মুন্দির ভীতিরতে আদের তিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ইন্তং নাগার রেঙ্কূ হড়কু কিকিচ কাতে জেহেৎ রাকাবেনাকু, হড়কু নির হিজেনাকু হেৎদ পৌলকে সাবকাতে উপাসনা অড়ারাঃআ বাহারতে গহাড় ইদিকিয়াকু, হেৎদ সাথে সাথ উপাসনা অড়ারাঃআ কবাটকু হান্ডেৎ কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","নেএ নেকাগে ইঙ্কূ ইনিকে গজ সানায়নাকু, ইন্তং সৈন্যদলরাঃআ জুলু পতিরাঃআ হান্ডে নিয়া খবর হিজেনা যে, গোটা যিরুশালেম শেহার রে রেটেপেটে এহবাকানা। ");
INSERT INTO cdz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","চিদগি ইনি পাল্টন কুকে হেৎদ চাকি পতিকু লঅ ইঙ্কূ য়া হান্ডে নির সেনেনাকু, ইনাতে হড়কু জুলু পতিকে হেৎদ সেনাকুকে নেল নামকেৎকু তেকু পৌলকে দাল বন্ধকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ইন্তং মারাং পাল্টন হিজকাতে ইনিকে সাবকিয়ায় হেৎদ বারিয়া শিকড়িতে ইনিকে আটক তে হুকুম এমকেৎকু য়ায় হেৎদ কুলিকেৎকু য়ায়, নিই অকয়তানায়, হেৎদ নিই কিনা চিকাতাৎ আয়? ");
INSERT INTO cdz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","মেন্খান হড় কুরাঃআ তালা হাতেন নাইজ-হানিজ হড় কিকিচকাতে নাআহানা থুতি গাম লাগায়নাকু, হেৎদ ইনি যাহানা কায় আটকার দাড়িলাৎআয়, ইনাতে ইনিকে গাড়তে ইদিতে হুকুম কেৎকুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ইন্তং সিঁড়িতে চেতাংতে হাজিরেনায় খানঃঅ হড়কু রাঃআ ক্ষিপ্ততারাঃআ নাতিনাং সিপাইকু পৌলকে কুডুরুব ইদিকিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","চিয়াচি হড়কু রাঃআ ভিড় তায়ম তায়ামতে সেনঃঅ কেনাকু, হেৎদ কিকিচ কাতে গাম লাগায়নাকু ইনিকে দাল কুদা গিডিপে। ");
INSERT INTO cdz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ইঙ্কূ পৌলকে ইদিকাতে গাড় রাঃআ ভীতার বলঃঅনাকু, পৌল মারাং পাল্টন কে কুলি কিয়ায়, আমা হান্ডে কি যাহানা গাম দাড়িয়াইঞ? ইনি পাল্টন গামকেয়ায় আম কি গ্রীক জাগারতে থুতিআম? ");
INSERT INTO cdz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","এনখান আম কি ইনি মিশরীয় ল্হয় তানাম, অকয় নিয়া মাড়াঙতে বিদ্রোহ লাৎআয়, হেৎদ উকুয়াকান গজিজ রাঃআ উপুন জুলু হড়কে লঅ তে ইদিধরাকাতে মরুডাহিতে সেনলেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ইন্তং পৌল গাম কেয়ায়, ইঞ ইহুদি তার্ষরাঃআ রিনিজ কিলিকিয়া দিশুম রিনিজ হড়, ইঞ মিয়াৎ নুতুমান নাঙ্গা র রিনিজ হড়, আমকে কষামুদি তানামাঞ, হড়কু লঅ থুতি রাঃআ নাতিনাং সায় ইঞকে এমাইঞমে। ");
INSERT INTO cdz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","হেৎদ ইনি সায় এমাকিয়ায় খানঃঅ পৌল সিঁড়ি রাঃআ চেতাংরে তিঙ্গুকাতে যতচ কে তিহিতে ইশারা কেৎকু য়ায়, ইন্তং যতচ থিরেনাকু, ইনি ইঙ্কূকে ইব্রীয় জাগারতে গামকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","হাগাকু হেৎদ বাপধনকু, ইঞ পৌল নাহা আপেয়া হান্ডে ইঞতেৎতে সায় তানাইঞ, আয়ুমেপে। ");
INSERT INTO cdz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ইন্তং ইনি ইব্রীয় জাগারতে ইঙ্কূ লঅ থুতি তানায় আয়ুমকেৎ তেকু ইঙ্কূ যতচ হাপেন থিরেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ইঞ ইহুদি, কিলিকিয়া রাঃআ তার্ষ নাগার রে ইঞা জানাম, মেন্খান নিয়া নাঙ্গা র রে গমলীয়েল রাঃআ হান্ডে আসুল হারাকানাঞ, মুশিং হাপাড়াম কুরাঃআ আরিচালি বেশলেকা চেদা কানাঞ, হেৎদ তিহিং আপে যতচ চিল্কা মেনাপেয়া, এনকা ইঞহঅ ঈশ্বর রাঃআ নাতিনাং চুহুলনিঞ তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ইঞ এমনকি গজঃঅ জাকিৎ নিয়া প্রভু রাঃআ হরা রেঙ্কূ হড়কুকে সাসেৎ সাতাও তাৎ কুয়াঞ, পাতিয়ান কড়াহন কুকে হেৎদ কুড়িহন কুকে আটক কাতে জিহালরে আটক দহেৎ কুকে নাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","নিয়া বাব্ত্তে মারাং বামড়ে হেৎদ যত মুরুব্বিকু ইঞা লুকুন্দী তানাকু, ইঙ্কূয়া হান্ডে হাতেন ইঞ হাগাকু রাঃআ নাতিনাং গিরা হাতাকাতে, দম্মেশক শেহার তে সেন লেনাইঞ, হেৎদ অকয় এনথাংরে তাহিলেনাকু, ইঙ্কূকে হঅ আটক কাতে যিরুশালেম শেহার তে আগু নাতিনাং সেন লেনাঞ, যাতে ইঙ্কূ সাজা নামেকাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","হেৎদ সেন সেনতে দম্মেশক শেহার রাঃআ কাতাতে হিজেনাইঞ খানঃঅ, তিকিন বেত্রাং আচকাগে চেতাং হাতেন জুলতান মার্শাল ইঞা চারুধার জুল রাকাবেনা। ");
INSERT INTO cdz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ইনাতে ইঞ অতেরে নুরেনাইঞ, হেৎদ মিয়াৎ রাহা আয়ুম কেয়াইঞ, অকয় তার ইঞকে গামাঞ তানায়, শৌল, শৌল, চিয়া ইঞকে সাসেৎ সাতাওঞ তানাম? ");
INSERT INTO cdz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ইঞ কুলি কেৎয়াইঞ, প্রভু, আম অকয় তানাম ? ইনি ইঞকে গাম রুয়াড় কিঞায়, ইঞ নাসরত রিনিজ যীশু, অকয়কে আম সাসেৎ সাতাও তানাম। ");
INSERT INTO cdz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","হেৎদ অকয় ইঞ লঅ তাহিনকেনাকু, ইঙ্কূহঅ ইনা মার্শাল নেলনামকেয়াকু, মেন্খান অকয় ইঞ লঅ থুতিকেনায়, ইনিরাঃআ থুতি কাকু আয়ুম নামলাদআ। ");
INSERT INTO cdz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","তায়মতে ইঞ গামকেয়াইঞ, প্রভু, ইঞ কিনা চিকাআইঞ? প্রভু ইঞকে গামকিঞায়, বিরিদকাতে দম্মেশকতে সেনম, আমকে অকা অকা করা হুইওয়া মেন্তে গটা হুইয়াকানা, ইনা এন্ডেটাগে আমকে গামঃঅ হুইওয়া। ");
INSERT INTO cdz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","হেৎদ ইঞ ইনা মার্শাল রাঃআ তারাসতে কাঁড়ায়েন্তেইঞ যাহানা কাইঞ নেল নামলাদআ হেৎদ ইঞা গাতিকু ইঞা তিহি সাবকাতে দম্মেশক শেহার তেকু ইদিকিঞা। ");
INSERT INTO cdz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","হেৎদ অননিয় নুতুমতে মিয়াৎ হড়, অকয় আরিচালি লেকাতে ধার্মিক তাহিন কেনায় হেৎদ এনথাং রেঙ্কূ যত ইহুদি কুরাঃআ তালারে ইনিরাঃআ মৈন তাহিনকেনা, ");
INSERT INTO cdz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ইনি ইঞা হান্ডে হিজকাতে কাতারে তিঙ্গুকাতে গামকেয়ায়, বকইঞ শৌল, আম অটহঅ নেলনাম দাড়িম, হেৎদ ইন্তঙ্গে ইঞ ইনিকে নেল নামকিয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","হেৎদ ইনি ইঞকে গামকিঞায়, আলেয়া মুশিং বুঢাইঞকুরাঃআ ঈশ্বর ইনিকে বাছাতাৎ মেয়ায়, যেন আম ইনিরাঃআ ইচ্ছা সারি নামেকাম হেৎদ ইনি ধার্মিককে নেলনাম নাতিনাং হেৎদ ইনিরাঃআ মচারাঃআ থুতি আয়ুম নামেম, ");
INSERT INTO cdz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","চিয়াচি আম অকাগে নেলতাৎ আম হেৎদ আয়ুমতাৎ আম, ইনা বাব্ত্তে যত মান্মিরাঃআ হান্ডে ইনারাঃআ লুকুন্দী হুইওয়াম। ");
INSERT INTO cdz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ইনাতে নাহাআ চিয়া দেরিতানাম? বিরিদকাতে, ইনি রাঃআ নুতুমতে পাতিয়াকাতে ডুবান হাতাম, হেৎদ আমা কাই আবুংফার্চাম। ");
INSERT INTO cdz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ইনা তায়মতে ইঞ যিরুশালেম শেহার তে রুয়াড় হিজকাতে মিদ মাহা মুন্দির রে বিন্তিএকেনায়, এনকান ইন্তং বেহুশ মন হুইয়েন্তে প্রভু কে নেল নামকেৎ য়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ইনি ইঞকে গামকিঞায়, ঘিড়ঘিড়ম, নাহাগে যিরুশালেম শেহার হাতেন উডুঙওম, চিয়াচি নাইকি হড়কু ইঞা বাব্ত্তে আমা লুকুন্দী কাকু গ্রহনেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ইঞ গামকেয়া, প্রভু, ইঙ্কূ সারিয়াকু যে, অকয় আমকে পাতিয়ামাকু, ইঞ মিমিদ সমাজ অড়ারে ইঙ্কূকে আটক কেৎ কুয়াইঞ হেৎদ গজকেৎ কুয়াইঞ, ");
INSERT INTO cdz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","হেৎদ চিন্তং আমা লুকুন্দী স্তিফানকে গজিচ কেনাকু, ইন্তং ইঞ নিজে সামাংরে তিঙ্গুকাতে সায় এমলাৎআইঞ, হেৎদ অকয়কু ইনিকে দালিকেনাকু ইঙ্কূ য়া কিচিই সিনিব হর লাৎআঞ। ");
INSERT INTO cdz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ইনি ইঞকে গামকিঞায়, আম সেনম, ইঞ আমকে সাঙ্গিনতে বিনইহুদিকু রাঃআ হান্ডে কুলমেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","হড়কু নিন্তি জাকিৎ ইনি রাঃআ থুতি আয়ুম কেয়াকু, তায়মতে কিকিচ কাতে গাম লাগায়নাকু, নিইকে ধার্তি হাতেন গচ গিডিপে, ইনিকে বাঞ্চা দঃহঅ আইদারি বায়ানা। ");
INSERT INTO cdz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ইন্তং ইঙ্কূ কিকিচকেৎ তেকু ইঙ্কূয়া সনঃঅ অড়েজকাতে, ধুড়ি অটাং লাগায়নায়কু, ");
INSERT INTO cdz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ইন্তং সেনা মারাং পৌলকে গাড়রাঃআ ভিতারতে ইদি নাতিনাং হুকুম এমকেৎকু য়ায় হেৎদ গামকেৎকু য়ায় চাবুক দালকাতে নিইরাঃআ পরীক্ষা হুইওয়া, যেন ইনি সারি নামে কাআয় যে, চিয়া হড়কু ইনিকে দোষ এমকাতে কিকিচ কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","তায়মতে চিন্তং ইঙ্কূ বায়রতে ইনিকে আটক কিয়াকু, ইন্তং অকা চাকি পতি কাতারে তিঙ্গুলেনায়, পৌল ইনিকে গামকিয়ায়, অকা হড় রোম শেহার ীয় হেৎদ দরবার রে যাহান দোষ কাকু নামলাদাআ, ইনিকে চাপকা কি আপেয়া লাক্তি ? ");
INSERT INTO cdz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","নিয়া থুতি আয়ুমকাতে চাকিপতি বহঅ সেনা রাঃআ হান্ডে সেনকাতে কুলি কিয়ায়, আম কিনা করাতে সেনঃঅ তানাম? নিই হড়টামা রোম শেহার ী বাসিন্তা তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ইন্তং বহঅ সেনা ঠাইনতে সেনকাতে ইনিকে গামা কিয়ায়, গামেম সিনাং, আম দচ রোম শেহার ীয় রিনিজ হড়? ইনি গামকেয়ায়, হে। ");
INSERT INTO cdz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","মারাং পাল্টন গামকেয়ায়, নিয়া নাগরিকত্ব ইঞ গাদা কাউডি তে কিরিং তাৎআ। পৌল গাম রুয়াড় কেয়ায়, মেন্খান ইঞ জানাম হাতেনগে রোম শেহার ীয়। ");
INSERT INTO cdz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ইন্তং অকয়্য়কু ইনিকে কুলি নাতিনাং সাপড়ায়নাকু তাহি লেনা, ইঙ্কূ তুক্ষনি ইনিরাঃআ হান্ডে হাতেন সেনেনাকু, হেৎদ ইনি যে রোম শেহার ীয় নিয়া থুতি সারিকেৎ তেকু, হেৎদ ইনিকে আটক লিয়াকু মেন্তে, মারাং পাল্টন হঅ বরকেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","মেন্খান তায়্ম হুলাং, ইহুদিকু ইনিরাঃআ চেতাং চিয়া দোষ এমেতানাকু, সার্তি সারি নাতিনাং মারাং পাল্টন ইনিকে আড়া গিডিকিয়ায়, হেৎদ মারাং বামড়ে কুকে হেৎদ মারাংদরবার রেঙ্কূ হড়কু মিশাতে হিজুতে হুকুম এমকেৎকু য়ায় হেৎদ পৌলকে আড়গু কাতে ইঙ্কূ য়া হান্ডে হাজির কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","হেৎদ পৌল মারাংদরবার রাঃআ হান্তে মিদঢেকতে কয়ঃঅ কেৎ তে গামকেয়ায়, এ হাগাঞকু, তিহিঞ জাকিৎ ইঞ যত বাব্ত্তে বিবেক লঅ ঈশ্বর রাঃআ হড় লেকা চাল-চলন করা আউতাৎ আইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ইন্তং মারাং বামড়ে অননিয়, অকয় ঠাইনরে তিঙ্গুনেনাকু, ইঙ্কূকে হুকুমাৎ কুয়ায়, যেন ইনি রাঃআ মচারে থাপাই কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ইন্তং পৌল ইনিকে গামকিয়ায় \"এ চুনতে লেপায়াকান কাঁথ, ঈশ্বর আমকে দাল মেয়ায়, আম আরিচালিতে ইঞা দরবার দুবা কানাম, হেৎদ আরি চালি রাঃআ উল্টা ইঞকে দাল নাতিনাং হুকুম এমতান কুয়াম? ");
INSERT INTO cdz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ইনাতে অকয় কাতারে তিঙ্গু লেনাকু ইঙ্কূ গামকেয়াকু \"আম কি ঈশ্বর রাঃআ মারাং বামড়েকে নেকা মানহানিই তানাম? ");
INSERT INTO cdz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","পৌল গামকেয়ায় \"এ বকইঞকু, ইঞ কাইঞ সারিকেনাইঞ যে, ইনি মারাংবামড়ে তানায়\" চিয়াচি অল মেনা \"আম নিজে জাতি রাঃআ হড়কু রাঃআ বাগালকে খারাপ থুতি আলম গামকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","মেন্খান পৌল চিন্তং আটকার নামকেৎয়ায় যে, ইঙ্কূয়া মিৎ হাটিং সদ্দূকী হেৎদ মিৎ হাটিং ফরীশী, ইন্তং মারাংদরবার রাঃআ তালারে কুঠিন জোরতে কিকিচকাতে গামকেৎয়ায় \"এ বকইঞকু, ইঞ ফরীশী হেৎদ ফরীশীকু রাঃআ হনতানাইঞ, গজকু রাঃআ আশাহঅ জিউৎ রাকাব বাব্ত্তে ইঞা দরবার হুইঅতানা। ");
INSERT INTO cdz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ইনি নিয়া থুতি আউরি গামেয়ায় ফরীশী হেৎদ সদ্দূকীকুরাঃআ তালারে বিরুধ সৃষ্টিইনা, দরবার রাঃআ তালারে বারিয়া দল হুইয়েনা। ");
INSERT INTO cdz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","চিয়াচি সদ্দূকীকু গামেয়াকু, জীউৎ রাকাব বায়ায়না, সেরমা রেঙ্কূ সরগনাঙ্গা চি বাড়িচ আত্মা বায়ায়না, মেন্খান ফরীশীকু বারানা গে পাতিয়াআকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ইন্তং কুঠিন রেটেপেটে হুইয়েনা হেৎদ ফরীশী পক্ষরে কথক আরিচালি রেঙ্কূ চেচেদিজ তিঙ্গু বিরিদেন্তেকু নিপিয়ায়কাতে গাম লাগায়নাকু, আলে নিই হড়টারে যাহানা ভুল কালে নেম নাম দাড়িতানা, যাহান বাড়িচ আত্মা চি যাহান সরগ নাঙ্গা যদি নিই লঅ থুতিয়াকানায়, এন্খান কিনা? ");
INSERT INTO cdz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","নেকাগে কুঠিন রেটেপেটে হুইয়েনা, যদি ইঙ্কূ পৌলকে গঃজিয়াকু, নিয়া বরতে পাল্টন হকুমকেৎকু য়ায়, সৈন্যদল সেনকাতে ইঙ্কূ য়া তালা হাতেন পৌলকে গাড় ইদিকাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","তায়মতে নিদা বেত্রাং প্রভু পৌল রাঃআ কাতারে তিঙ্গুয়েন্তে গামকিয়ায়, সাহসেম, চিয়াচি ইঞা বাব্ত্তে চিল্কা যিরুশালেম শেহার রে লুকুন্দী এমতাৎ আম, এনকা রোম শেহার রেহঅ এমঃঅ হুইঅয়া। ");
INSERT INTO cdz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","সিঙ্গিন খানঃঅ ইহুদিকু কারসাদি কেয়াকু হেৎদ নিজেকুকে শাপ কেৎকু য়াকু, ইঙ্কূ গামকেয়াকু আলে জিমিন ভুর পৌলকে কালে গঃজিয়া, ইমিন ভুর জমা হেৎদ দাঃআ কালে নুঃইয়া। ");
INSERT INTO cdz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","পুলি হড় রাঃআ বেশি হড় মিশাতে দিব্যিকাতে নিয়া কারসাদী কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ইঙ্কূ মারাং বামড়েকুরা হেৎদ মুরুব্বিকুরা হান্ডে সেনকাতে গামকেৎকু য়াকু, আলে মিয়াৎ কেটেজ দিব্যি হাতাতাৎ লে, চিমিন ভুর পৌলকে কালে গঃজিয়া, ইমিন ভুর যাহানা কালে জ্মেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","এন্তে আপে নাহা মারাং দরবারে সুবেদার রাঃআ হান্ডে আর্জিপে, যেন ইনি আপেয়া হান্ডে ইনিকে হাজিরিকাআয়, গামেপে যে, আপে অটঅ বেশলেকা ইনিরাঃআ বাব্ত্তে দরবার নাতিনাং সাপড়াকানাপে, হেৎদ ইনি ঠাইনতে হিজু মাড়াঙতে ইনিকে গঃজ নাতিনাং সাপড়া তাহিনালে। ");
INSERT INTO cdz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","মেন্খান পৌলরাঃআ বকতেদ কুড়িরাঃআ হনতেদ (ভাগনাতেদ) ইঙ্কূ য়া আট-ঘাঁটি বাইসা রাঃআ থুতি আয়ুম কেৎকুতে গাড়রাঃআ ভীতির সেনকাতে পৌলকে গামাকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ইনাতে পৌল মিহুড় চাকিপতিকে রাঃআ কিৎ তে গামকিয়ায়, জুলুপতি রাঃআ হান্ডে নিই কড়াহনকে ইদিম, চিয়াচি ইনিরা হান্ডে নিই রাঃআ হুডাং থুতি গাম রাঃআ মেনা। ");
INSERT INTO cdz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ইনাতে ইনি সঙ্গেতে ইদিকাতে সুবেদার রাঃআ হান্ডে ইদিকিৎ তে গামকিয়ায়, বন্দি পৌল ইঞকে ঠাইনতে আমা হান্ডে নিই জুয়ানকে আগু গামকিঞায়, আমা হান্ডে নিই রাঃআ হুডাং থুতি মেনা। ");
INSERT INTO cdz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ইন্তং জুলু গমকে ইনিরা তিহি সাবকাতে মিৎ কাতাতে ইদিকিয়তে অছাড়রে কুলিকিয়ায়, ইঞা হান্ডে আমা কিনাআ গামঃরাঃআ মেনা? ");
INSERT INTO cdz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ইনি গামকেয়ায়, ইহুদীকু আমা হান্ডে নিয়া কষামুদিকাতে পরামর্চাকিৎ আকু, যেন আম গাপা অটঅহঅ বেশ গটার পৌল রাঃআ বাব্ত্তে সারিরাঃআ নাতিনাং ইনিকে মারাং দরবার তে ইদিম। ");
INSERT INTO cdz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","এন্তে আম ইঙ্কূ য়া থুতি আলম লুতুরেয়া, চিয়াচি ইঙ্কূয়া তালারে পুলি হড় রাঃআ বেশি হড় ইনিরাঃআ নাতিনাং ফাসিয়া আডাতাৎ আকু, ইনকু মিয়াৎ কুঠিন দিব্যিতাৎ আকু, চিমিন ভুর ইনিকে কাকু গঃজিয়া, ইমিন ভুর জম চি নুঃউ কাকুয়া, হেৎদ নাহাগে সাপাড়া মেনাকুয়া, আমা সায় রাঃআ তাঙ্গিরে মেনাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ইন্তং জুলু পতি ইনি জুয়ানকে হুসিয়ার কিৎ তে কয়অ তুকা কিয়ায়, আম যে নিয়া সব ইঞকে গামা তিইঞাম ইনা যাহায়কে আলম গামাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","তায়মতে ইনি বার হড় চাকি পতিকিনকে ঠাইনতে রাঃআ কাতে গামাৎ কিনায়, কৈসরিয়া শেহার জাকিৎ সেনঃঅ নাতিনাং আয়ুব নটা গ্রাহ বাতিরাং বার চাকি সিপাই হেৎদ তিলিহড় সাদম চালাইজ হেৎদ বার চাকি বরলম সাসাব হড় সাপড়া দঃহকুবেন। ");
INSERT INTO cdz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","হেৎদ সাদম তেয়ার দঃহ নাতিনাং আঁচু এমকেৎ কিনায়, যেন ইঙ্কিন পৌলকে ইনিরাঃআ চেতাংরে দুবকাতে নিরাপদরে মুলুক পারগানা হেৎদ ফেলিক্সরাঃআ হান্ডে সেটেতকাইকাকিন। ");
INSERT INTO cdz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","হেৎদ ইনি পাল্টনপতি নেএনেকা মিয়াৎ গিরা অলকেয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","মুলুক পারগানা ফীলিক্স রাঃআ হান্ডে ক্লোদিয় লুষিয় রাঃআ জোহার। ");
INSERT INTO cdz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ইহুদিকু নিই হড়টাকে সাবকাতে গজ সানায়নাকু খানঃঅ ইঞ সিপাইকু লঅ হাজিরেন্তে ইনিকে রুক্ষীয়া কেৎয়াইঞ, চিয়াচি সারি নামকেয়াইঞ যে, নিই হড়টা রোমিয় তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","হেৎদ ইঙ্কূ কিনা নাতিনাং নিই হড়টারাঃআ চেতাংরে দোষ এমেকেনাকু ইনা সারিরাঃআ নাতিনাং ইঙ্কূ য়া মারাং দরবার নিই হড়টাকে ইদি কিয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","এন্তে ইঞ আটকার নামকেয়াইঞ, ইঙ্কূ য়া আরিচালি লেকাতে নিইরাঃআ চেতাংরে দোষ এম হুইয়াকানা, মেন্খান গজঃঅ চি জিহাল অড়ারে এমঃঅ লেকা আর্জি নিইরাঃআ নুতুমতে কা হুইয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","হেৎদ নিই হড়টা রাঃআ বিরুধরে চক্রান্ত হুইঅয়া, নিয়া খবর আয়ুমকাতে ইঞ ঘিড় মেন্তাংগে আমা হান্ডে কুল কেৎ য়াইঞ। নিইরাঃআ চেতাং অকয় দোষ এমতাৎ আকু, ইঙ্কূকে হঅ আঁচু এমকেৎকু য়াইঞ, ইঙ্কূ আমা হান্ডে ইনি রাঃআ বিরুধরে অকা গামরাঃআ তাহিনা, গামে কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","হেৎদ সিপাইকু হুকুম লেকাতে পৌলকে ইদিকাতে নিদা বাতিরাং আন্তিপাত্রি শেহার তে সেনেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","তায়্ম হুলাং আসোয়ারি কুকে ইঙ্কূ লঅ সেনঃঅ নাতিনাং দঃহঅ কাতে ইঙ্কূ গাড়তে রুয়াড় হিজেনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ইঙ্কূ কৈসরিয়া শেহার তে সেটেরেন্তে মুলুক পারগানা রাঃআ তিহিরে গিরাটা এমকাতে পৌল কেহঅ ইনি রাঃআ হান্ডে হাজির কিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ইনি গিরাটা ইনা পড়হা কাতে কুলি কেৎ কুয়ায়, নিই অকা মুলুক রিনিজ হড়তানায়? ইন্তং ইনি সারিনাম কেয়ায় ইনি কিলিকিয়া মুলুক রিনিজ হড়। ");
INSERT INTO cdz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","নিয়া সারিনাম কাতে মুলুক পারগানা গামকেয়ায়, অকয় আমা চেতাংরে দোষ এমতাৎ আকু, ইঙ্কূ চিন্তং হিজুয়াকু ইন্তং আমা থুতি আয়মেয়াইঞ। তায়মতে ইনি হেরোদ রাঃআ রাপাজ বাখুল রে ইনিকে দঃহ নাতিনাং আঁচুকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","মড়েমাহা তায়ম, অননিয় মারাংবামড়ে, কথক হড় মুরুব্বি হেৎদ তর্তুল্ল নুতুমিজ মিয়াৎ উকিলকে সঙ্গেতে এনথাংতে ইদিকিয়ায় হেৎদ ইঙ্কূ পৌলরাঃআ বিরুধরে মুলুক পারগানা রাঃআ হান্ডে আর্জিকেয়াকু, ");
INSERT INTO cdz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","পৌলকে রাঃআ তায়ম হেৎদ তর্তুল্ল ইনিরাঃআ নুতুম নিয়া গামকাতে দোষ এমঃঅ লাগায়নাকু, এ বাপধন ফীলিক্স, আমা দ্বারায়তে আলে বেশ সুলুক আটকারেতানা হেৎদ আমা আকিল রাঃআ হরকাতে নিয়া খেরয়াল জাতি রাঃআ নাতিনাং গাদা উন্নতি আউতাৎ আকু। ");
INSERT INTO cdz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","নিয়া আলে যতচ যত থাংরে যত কিছু মাইনান লঅ স্বীকারে তানালে। ");
INSERT INTO cdz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","মেন্খান বেশি থুতি গামকাতে যেন আমকে কষ্ট আল এমমেকালে, নিয়া নাতিনাং কষামুদি তানামা, আম দায়াকাতে আলেয়া থুতি আয়ুমেম। ");
INSERT INTO cdz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","চিয়াচি আলে নেলকেয়ালে, নিই হড়টা বিদ্রোহী লেকানিজ, দুনিয়া রেঙ্কূ যত ইহুদিরাঃআ ভিতাররে নিপিয়াইজ হেৎদ নাসরতীয় দল রাঃআ গুডিদার, ");
INSERT INTO cdz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","হেৎদ নিই ধরম থান ররেহঅ অছুথী নাতিনাং কুরুমুটু কেনায়, আলে নিইকে সাবতিয়ালে। ");
INSERT INTO cdz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","মেন্খান চিন্তং লিসিয়াস সর্দার সেটেরেনায়, ইনি জোরকাতে পৌলকে আলেয়া তিহি হাতেন ইদিকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","চিন্তং আম নিয়া যত বাব্ত্তে পৌলকে কুলিয়াম ইন্তং আমহঅ ইনা যত সারিনামেয়াম চিয়া ইনিকে দোষটাহর হুইঅতানা। ");
INSERT INTO cdz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","এটা ইহুদীকুহঅ সায় এমকাতে নিয়া যত জাগার গটা কেৎয়া। ");
INSERT INTO cdz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","হেৎদ মুলুক পারগানা পৌলকে থুতি গাম নাতিনাং ইশারা কিয়ায় খানঃঅ ইনি নিয়া তেলা কেয়ায়, আম গাদা সির্মাং হাতেন নিয়া জাতিরাঃআ দরবার আগুইতানাম, সারি নামকাতে ইঞ স্বচ্ছন্দে ইঞতেৎতে সায় তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","আম জাচা দাড়িয়াম, তিহিঙ গেলে বার মাহা রাঃআ বেশি কা হুইয়াকানা, ইঞ উপাসনা রাঃআ নাতিনাং যিরুশালেম শেহার তে সেনলেনাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","হেৎদ নিকু বাড়িচরে ইঞকে যাহায় লঅ নিয়ায়তে, চি হড়কুকে ভিড়কাতে কাকু নেলতিঞা, সমাজ অড়ারেহঅ লহয়, নাগার রেহঅ লহয়। ");
INSERT INTO cdz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","হেৎদ নাআহাআ নিকু ইঞকে অকা সব দোষ এমাইঞ তানাকু, আমা হান্ডে ইনা যত ভজা কাকু দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","মেন্খান আমা হান্ডে ইঞ নিয়া মানাঃঞ, নিকু অকয়কে দল গামকুয়াকু, ইনা হরা লেকাতে ইঞ আপুইঞ-বুঢাইঞকু রাঃআ ঈশ্বর রাঃআ হমরবিন্তি আইঞ, অকা অকা মোশি রাঃআ আরিচালি হেৎদ ভাবি জাগারিজ পুথিরে অল মেনা, ইনাকু পাতিয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","হেৎদ নিকুহঅ চিল্কা তাঙ্গিরে তাহিনাকু, এনকাগে ইঞহঅ ঈশ্বররে নিয়া আশায় তানাইঞ যে, ধার্মিক হেৎদ অধার্মিক বার-রকম হড়কু রাঃআ জীউৎ রাকাব হুইঅয়া। ");
INSERT INTO cdz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","হেৎদ নিয়া বাব্ত্তে ইঞহঅ ঈশ্বর রাঃআ হেৎদ মান্মিকু রাঃআ নাতিনাং বিবেক হার মাহা সাপা দঃহঅ রাঃআ নাতিনাং কুরুমুটু তানাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","মেন্খান গাদা সির্মাং তায়ম ইঞ নিজে রাঃআ জাতিকু রাঃআ হান্ডে দান এমঃঅ নাতিনাং হেৎদ বলিসামাং নাতিনাং হিচ লেনাইঞ, ");
INSERT INTO cdz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","নিয়া পিড়ি রেঙ্কূ হড়কু ইঞকে ছুত হালরে নেললিঞাকু, ভিড়হঅ কা হুইয়া কানা, রেটেপেটে হঅ কা হুইয়া কানা, মেন্খান এশিয়া মুলুক দিশুম রেঙ্কূ কথক হড় ইহুদি হাজির তাহিনো কেনাকু, ইঙ্কূ য়াগে লাক্তি তাহিনো কেনা ");
INSERT INTO cdz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","যেন আমা হান্ডে ইঞা বিরুধরে যদি ইঙ্কূ য়া যাহানা থুতি তাহিনা, এন্খান নেথাংরে হিজকাতে হেৎদ ইঞকে দোষ এমাইঞ কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","বাংখান দ নেথাংরে হাজিরা কানা হড়কুগে গামে কাআকু, ইঞ মারাং দরবার রাঃআ সামাংরে তিঙ্গু লেনখান নিকু ইঞা কিনা দোষ নামতাৎ আকু? ");
INSERT INTO cdz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","লহয়, শুধু নিয়া মিয়াৎ থুতি, অকা ইঙ্কূয়া তালারে তিঙ্গু ইন্তে ইঞ জোরতে গামলাদ আইঞ \"গজকুরাঃআ জীউৎ রাকাব বিষযতে তিহিং আপেয়া সামাংরে ইঞা দরবার হুইঅতানা। ");
INSERT INTO cdz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ইন্তং ফীলিক্স, ইনা হরা রাঃআ বাব্ত্তে বেশলেকা সারিয়ায় মেন্তে, দরবার বিন-মুচাদরে দঃহঅ কেয়ায়, গাম কেয়ায়, লুসিয় জুলু পতি চিন্তং হিজুআয়, ইন্তং ইঞ আপেয়া দরবার মুচাদিইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","হেৎদ ইনি চাকিপতিকে নিয়া হুকুম এমকিয়ায়, আম নিইকে আটক দঃহিম, মেন্খান বেশলেকাতে দঃহিম, নিই রাঃআ যাহান পাহিকে নিই রাঃআ খাতির নাতিনাং হিজুতে আলম মানা কুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","কথক মাহা তায়ম তেমা ফীলিক্স দ্রুষিল্লা নুতুমিজ নিজে রাঃআ ইহুদি এরাতেদ লঅ হিজকাতে পৌলকে রাঃআ কুলকেৎকুয়া কিন হেৎদ ইনিরাঃআ মচারে খ্রীষ্ট যীশু রাঃআ বাব্ত্তে পাতিয়ান থুতি আয়ুম কেয়াকিন। ");
INSERT INTO cdz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","পৌল ন্যায় দার্মিকতা রাঃআ, আত্মকব্জ রাঃআ হেৎদ হাপেন মাহা রাঃআ দরবার রাঃআ বাব্ত্তে বাখাড় কেৎ খানঃঅ ফীলিক্স বরঃয়েন্তে গাম রুয়াড়কেয়ায়, নাহা সেনম দু, বুগিন মাহা হিচ লেন্খান ইঞ আমকে রাঃআ মেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ইনিহঅ আশা লাৎআয় যে, পৌল ইনিকে কাউডিউগুর এমিআয়, নিয়া নাতিনাং ঘনে ঘনে ইনিকে রাঃআ কাতে ইনি লঅ থুতি কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","মেন্খান বার সির্মাং তায়মতে পর্কীয় ফীষ্ট শাসক ফীলিক্স রাঃআ গাঁডুরে ব্হালেনায়, হেৎদ ফীলিক্স ইহুদীকুকে খুশিকেৎকু তে দায়া-দুলাড় নাম নাতিনাং পৌলকে আটক কাতে বাগিতুকা কিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ফীষ্ট শাসক ইনা তালুকতে এ হিজু রাঃআ আপি মাহা তায়মতে কৈসরিয়া শেহার হাতেন যিরুশালেম শেহার তে সেনেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ইনাতে মারাং বামড়েকু হেৎদ ইহুদিকু রাঃআ মাপরাং মাপরাং হড় ইনিরা হান্ডে পৌল রাঃআ বিরুধরে আর্জিকেয়াকু ");
INSERT INTO cdz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","হেৎদ কষামুদিকিৎ তেকু ইনি রাঃআ বিরুধরে নিয়া দায়া-দুলাড় নাম রাঃআ আশা লাগায়নাকু, যাতে পৌলকে যিরুশালেম শেহার তে রাঃআ কুলিকাআকু। ইঙ্কূ হরা তালারে পৌলকে গজ নাতিনাং ফাসিয়া আডা সানালাৎ কুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","মেন্খান ফীষ্ট শাসক গাম রুয়াড়কাতে গামকেৎকু য়ায়, পৌল কৈসরিয়া শেহার তে হাঁডেৎ মেনাইয়া, ইঞহঅ এনথাংতে নিশ্চয়ই সেনাইঞ ");
INSERT INTO cdz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","এন্তে ইনি গামকেয়ায়, আপেয়া তালারে অকয় আই-দাড়িয়ান, ইঙ্কূ ইঞ লঅ এনথাংতে সেনঃঅকাআকু, ইনি হড়রাঃআ যদি যাহানা দোষ তাহিনা এন্খান ইনিরাঃআ চেতাংরে দোষ লাদিকাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","হেৎদ ইঙ্কূ য়া হান্ডে আট-গেলে মাহা রাঃআ বেশি তাহিনো রাঃআ তায়ম ইনি কৈসরিয়া শেহার তে সেনেনায়, হেৎদ তায়্ম হুলাং দরবার আসনরে দুবয়েন্তে পৌলকে আগু নাতিনাং হুকুম এমকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ইনি হাজিরেনায় খানঃঅ যিরুশালেম শেহার হাতেন হিজাকান ইহুদি লাউড়িয়াকু ইনিরাঃআ চারুধার তে তিঙ্গুয়েন্তে ইনি রাঃআ বাব্ত্তে গাদা মারাং মারাং দোষ রাঃআ থুতি গাম লাগায়নাকু, মেন্খান ইনি রাঃআ প্রমাণ উদু কাকু দাড়িলাআ। ");
INSERT INTO cdz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","নাতেরে পৌল নিজে রাঃআ ইঞতেৎতে সায় কাতে গামকেয়ায়, ইহুদিকু রাঃআ আরিচালি রাঃআ বিরুধরে, বাড়িচ রাঃআ বিরুধরে, বাংখান কৈসর রাঃআ বিরুধরে ইঞ যাহানা কাইঞ অপরাধতাৎ আইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","মেন্খান ফীষ্ট শাসক ইহুদিকু রাঃআ হক হুই সানাকিয়া খানঃঅ পৌলকে তেলা এমকাতে গাম লাগায়নায়, আম কি যিরুশালেম শেহার তে সেনকাতে ইঞা মেৎরে নিয়া যত বাব্ত্তে দরবার তে সায়এমেয়াম? ");
INSERT INTO cdz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","পৌল গাম রুয়াড় কেয়ায়, কৈসর রাঃআ দরবার আসন রাঃআ সামাংরে তিঙ্গু মেনাইঞা, নেথাংরে ইঞা দরবার হুই জরুর। ইঞ ইহুদিকু রাঃআ নাতিনাং যাহান কাইঞ অন্যায়তাৎআ, নিয়াটা আপে বেশ লেকা সারিয়াপে। ");
INSERT INTO cdz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","এন্খান যদি ইঞ দায়ীয়াইঞ হেৎদ গজঃ রাঃআ যোগ্য় যাহানা করাতাৎ আইঞ, এন্খান ইঞ গজঃতে কাইঞ বাধায়া, মেন্খান নিকু ইঞা চেতাং অকা অকা দোষ লাদিতাৎ আকু নিয়া যত যদি যাহানা কা হুইঅয়া নিকুয়া তিহিরে ইঞকে জিমারাঃআ যাহায়রাঃআ আইদারি বাআয়না, ইঞ কৈসর রাঃআ হান্ডে আর্জিয়েআইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ইন্তং ফীষ্ট শাসক মন্ত্রী দরবার লঅ থুথিকু গটাগুটি কাতে গাম রুয়াড় কেয়ায়, আম কৈসর রাঃআ হান্ডে আর্জিতাৎ আম, কৈসর রাঃআ হান্ডেগে সেনম। ");
INSERT INTO cdz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","হেৎদ কথক মাহা পারমেনা খানঃঅ আগ্রিপ্পা রাপাজ হেৎদ বর্নিকী কৈসরিয়া শেহার তে হাজিরেনায় হেৎদ ফীষ্ট শাসক কে জহারকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","হেৎদ ইঙ্কিন গাদা মাহা এনথাংরে বাসায়নাকিন হেৎদ ফীষ্ট শাসক রাপাজ রাঃআ হান্ডে পৌলরাঃআ জাগার হাজিরকাতে গামকেয়ায়, ফীলিক্স মিয়াৎ হড়কে আটক কাতে দঃহ তুকাতিয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","চিন্তং ইঞ যিরুশালেম শেহার রে তাহিলেনাইঞ, ইন্তং ইহুদিকু রাঃআ মারাং বামড়েকু হেৎদ মুরুব্বিকু ইনি হড়টা রাঃআ বাব্ত্তে আর্জিকেৎ তেকু ইনি রাঃআ বিরুধরে কুড়াই রাঃআ বিন্তিলাদআকু। ");
INSERT INTO cdz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ইঞ ইঙ্কূ কে নিয়া উত্তর এমলাদ কুয়াইঞ, অকয় রাঃআ নুতুমতে দোষ এম হহুয়া, চিমিন ভুর দোষ-এমিজকু লঅ সামনা-সামনি কাকিনা (মোকাবিলা কাকুয়া) হেৎদ এমতান দোষ বাবদতে ইঞতেৎতে সায় রাঃআ অক্ত কা নামেআয়, ইমিন ভুর যাহান হড়কে সম্পা রোম শেহারয় কুরাঃআ চল লহয়। ");
INSERT INTO cdz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","এন্তে ইঙ্কূ মিশাতে নেথাংতে হিজেনাকু খানঃঅ ইঞ কাইঞ দেরিকাতে গাপা হুলাং দরবার আসনরে দুবকাতে ইনি হড়কে আগু নাতিনাং আঁচুকেৎকু য়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","হেৎদ দোষ এমিজকু তিঙ্গুয়েন্তেকু, ইঞ চিল্কা লেকানা দোষ আটকারেকেনাইঞ, এনকা লেকানা যাহান দোষ ইনিরাঃআ বাব্ত্তে কা রাকাবলেনা, ");
INSERT INTO cdz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","মেন্খান ইনিরাঃআ বিরুধরে আপেয়া নিজেরাঃআ ধর্ম বাব্ত্তে হেৎদ যীশু নুতুমতে যাহান গজঃ হড়, অকয়কে পৌল জীউৎ গামিকেনায়, ইনিরাঃআ বাব্ত্তে হুডাঙ তর্ক হাজির কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ইন্তং নিয়া সব বিষয় চিল্কাতে পাঞ্জা হুইওয়া, ইঞ গটা কাইঞ দাড়িলা মেন্তে গামকেয়াইঞ, আম কি যিরুশালেম শেহার তে সেনকাতে নিয়া বিষয়কুতে দরবার নাতিনাং রাজিমেনামা। ");
INSERT INTO cdz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","মেন্খান পৌল আপিলকাতে সম্রাটরাঃআ দরবার রাঃআ নাতিনাং বাঞ্চা তাহিতে বিন্তিকেয়ায় খানঃঅ, ইঞ চিমিন ভুর ইনিকে কৈসররাঃআ হান্ডে কাইঞ কুল দাড়িইঞ, ইমিন ভুর আটক কাতে দঃহঅরাঃআ হুকুম এমকেৎকু য়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ইন্তং আগ্রিপ্পা রাপাজ ফীষ্ট শাসক কে গামকিয়ায় ইঞহঅ ইনি হড়রাঃআ হান্ডে থুতি আয়ুম সানালিঞা। ফীষ্ট শাসক গামকেয়ায়, গাপা আয়ুম নামেআম: ");
INSERT INTO cdz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","এন্তে গাপা হুলাং আগ্রিপ্প হেৎদ বর্ণীকী পুরা সাজা-সাপড়াকাতে হিজেনায় হেৎদ জুলু পতিদকু হেৎদ নাঙ্গা র রেঙ্কূ মাপরাং হড়কু লঅ দরবার থাংতে হাজিরেনাকু, হেৎদ ফীষ্ট শাসক রাঃআ হুকুমতে পৌলকে আগু হুইয়েনা। ");
INSERT INTO cdz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ইন্তং ফীষ্ট শাসক গামকেয়ায়, এ রাপাজ আগ্রিপ্প হেৎদ আলে লঅ দরবার হাজিরাকান গমকেকু, আপে যতচ নিইকে নেলিতানাপে, নিইরাঃআ বাব্ত্তে ইহুদিকুরাঃআ দলবল সমেত যত হড় যিরুশালেম শেহার রে হেৎদ নেএ নেথাংরে ইঞা হান্ডে আর্জিকাতে জোরতে গামলাদআকু, ইনিরাঃআ অটঅ বাঞ্চা তাহিনোরাঃআ জরুর বাআয়না। ");
INSERT INTO cdz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","মেন্খান ইঞ নেলকেয়াইঞ যে ইনি হড় গজ লেকানা যাহানহঅ কামী কায় করাতাৎ আয়। এন্খান ইনি নিজে চিন্তং সম্রাটরাঃআ হান্ডে আপিলতাৎ আয় ইন্তং ইঞ ইনিকে সম্রাটরাঃআ হান্ডে কুলগে গটা কেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","মেন্খান মারাং সম্রাটরাঃআ হান্ডে অলরাঃআ লেকানা এনকান গটা যাহানা কাইঞ নামলাদআ। ইনা নাতিনাংগে ইঞ আপে যতচ রাঃআ সামাংরে, বিশেষকাতে রাপাজ আগ্রিপ্পা রাপাজ, আমা সামাংরে ইনিকে আউ তিয়াইঞ যাতে ইনিকে কুলিকাতে অন্তত ইঞ অল দাড়ি কাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","চিয়াচি ইঞা মতে, যাহান আটক কে চালান এমরাঃআ অক্ত ইনিরাঃআ দোষকুহঅ সারিতকা লাক্তি তানা। ");
INSERT INTO cdz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ইন্তং রাপাজ আগ্রিপ্প পৌলকে গামকিয়ায় \"আমা নিজেরাঃআ পক্ষে থুতি গাম নাতিনাং আমকে অনুমুতি এম হুইয়েনা। নাহাআ পৌল তিহি দোন্দো কেৎতে নিজেরাঃআ পক্ষে নিয়া থুতি গামকেয়ায়, ");
INSERT INTO cdz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","এ রাপাজ আগ্রিপ্পা, ইহুদিকু ইঞকে অকা যত দোষ এমাৎ ঞাকু ইনারাঃআ বিরুধরে আমা সামাংরে তিহিঞ ইঞা নিজেরাঃআ পক্ষে থুতি গামরাঃআ সুযোগ নামতাৎ আইঞ মেন্তে ইঞ নিজেকে ধন্য মনে তানাইঞ, ");
INSERT INTO cdz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","বিশেষকাতে ইহুদিকুরাঃআ আরি-চালি হেৎদ তর্করাঃআ তক্ষরাঃআ বিষয়কু বাবদতে আমা বেশ ঠিকরা সারি মেনা। নিয়া নাতিনাং ধৈর্য্যকাতে ইঞা থুতি আয়ুম নাতিনাং ইঞ আমকে বিশেষকাতে কষামুদিতানামাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","হুডিং হাতেন, অর্থাৎ ইঞা জীবনরাঃআ এহব হাতেন ইঞা নিজেরাঃআ জাতি হেৎদ তায়মতে যিরুশালেম শেহার রেঙ্কূ হড়কুরাঃআ তালারে ইঞ চিল্কা জীবন পারমতাৎ আইঞ ইহুদিকু যতচ ইনা সারিয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ইঙ্কূ গাদা মাহা হাতেনগে ইঞকে সারিয়াকু হেৎদ ইচ্ছা লেনখান নিয়া লুকুন্দী এম দাড়িয়া যে, আলেয়া ধর্মরাঃআ ফরীশী নুতুমতে অকা গোঁড়া দল মেনা ইঞ ফরীশী জীবন পারমতাৎ আইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ঈশ্বর ইঞা আপুইঞ-বুঢাইঞ কুরাঃআ হান্ডে অকা দিব্যি লাৎআয় ইনাতে ইঞ আশা দঃহয়াইঞ মেন্তে নাহা ইঞা দরবার তানাপে। ");
INSERT INTO cdz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","আলেয়া গেলেবার গোষ্ঠী খেরয়াল রেঙ্কূ হড়কু নিদা-সিঙ্গি মনজিউ এমকাতে ঈশ্বর রাঃআ উপাসনায়াকু ইনা মানত পুরাকাআ নেল নাতিনাং আশারে মেনাকুয়া। মহারাপাজ, ইনা আশারাঃআ নাতিনাংগে ইহুদিকু ইঞকে দোষ এমিঞতানাকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ঈশ্বর যদি গজআ কানকুকে জীউৎ রাকাব কুয়ায় নিয়া থুতি বিন-পাতিয়া মেন্তে আপে চিয়া আটকারেতানাপে? ");
INSERT INTO cdz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ইঞ নিজেগে পাতিয়া কেনাইঞ, নাসরত নাঙ্গা র রিনিজ যীশু নুতুম রাঃআ বিরুধরে অকা করা হুযুয়া ইনা যতচ গে ইঞা করা লাক্তি তানা, ");
INSERT INTO cdz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","হেৎদ গটা ইনা ইঞ যিরুশালেম শেহার রে করালাদআইঞ। মারাং বামড়ে কুরাঃআ হান্ডে হাতেন আই-দারি নামকাতে ইঞ রীলামালা পাতিয়ান কুরাঃআ তালারে গাদা লেকাতে জিহালরে এমকেন কুয়াইঞ হেৎদ ইঙ্কূয়া গজঃঅ হুলাং ইঙ্কূ য়া বিরুধরে লুকুন্দী এমে কেনাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ইঙ্কূ য়া কুড়াই এম নাতিনাং ইঞ প্রায়গে মিয়াৎ সমাজ অড়া হাতেন এটা সমাজ অড়াতে সেনঃঅ কেনাইঞ হেৎদ ধর্ম্মনিন্দা রাঃআ নাতিনাং ইঞ ইঙ্কূ য়া চেতাংরে জোর খাটায় কেনাইঞ। ইঙ্কূয়া চেতাংরে ইঞা কুঠিন রাগ তাহিনকেনা যে, ইঙ্কূয়া চেতাংরে সাসেৎ সাতাও নাতিনাং ইঞ বিদেশ রাঃআ নাঙ্গা র কুতে জাকিৎ সেনকেনাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","নেকাগে মিশা মারাং বামড়েকুরাঃআ হান্ডে হাতেন আই-দারি হেৎদ হুকুম হাতাকাতে ইঞ দম্মেশক শেহার তেইঞ সেনঃঅকেনা। ");
INSERT INTO cdz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","মহারাজ, ইন্তং বেলা প্রায় তিকিন। হরারে বেলা হাতেনহঅ জুলুতান মিয়াৎ মার্শাল সেরমা হাতেন ইঞ হেৎদ ইঞা গাতিকুরাঃআ চারুধার জুল লাগায়না। ");
INSERT INTO cdz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","আলে যতচ অতেরেলে উয়ুইনা হেৎদ ইঞ আয়ুম নাম কেয়াইঞ ইব্রীয় ভাষা রাঃআ জাগারতে অকয় যেন ইঞকে গামিইঞতানায়, শৌল, শৌল, চিয়া আম ইঞা চেতাংরে সাসেৎ সাতাওইঞ তানাম? সেঙ্গেল আঙ্গারা রে লল মেড়েৎ তিড়সা কাতে চি আম নিজেরাঃআ কাম ক্ষতিইতানা? ");
INSERT INTO cdz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ইন্তং ইঞ কুলি কিয়াইঞ \"প্রভু, আম অকয়? ");
INSERT INTO cdz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","প্রভু গামরুয়াড় কেয়ায় \"ইঞ যীশু, অকয় রাঃআ চেতাং আম সাসেৎ সাতাওএ তানাম। নাহা বিরিদমে, আমা কাটারে ভর এমকাতে তিঙ্গুনমে। ঈশ্বর রাঃআ মুনিশ হেৎদ লুকুন্দী লেকাতে আমকে জিমা নাতিনাং ইঞ আমকে ভেট এমকেৎ মেয়াইঞ। আম ইঞকে চিল্কা নেলকিঞাম হেৎদ ইঞ আমকে অকা উদুমেয়াইঞ আম এটাকুরাঃআ হান্ডে গামেআম। ");
INSERT INTO cdz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","আমা নিজেরাঃআ হড়কুরাঃআ হেৎদ বিনইহুদি কুরাঃআ তিহি হাতেন ইঞ আমকে রুক্ষীয়া মেয়াইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ইঙ্কূকে মেৎতে আরিৎ নেল নাতিনাং হেৎদ নুবা হাতেন মার্শালতে হেৎদ শয়তান রাঃআ আইদারি একতিয়ার হাতেন ঈশ্বর রাঃআ হান্ডে রুয়ার আউ নাতিনাং ইঞ আমকে ইঙ্কূয়া হান্ডে কুলেৎমাইঞ, যেন ইঞা চেতাং পাতিয়া লেন্খান ইঙ্কূ কাই রাঃআ ছেমা নামেয়াকু হেৎদ ঈশ্বর রাঃআ দিশা অকয়কে আলদা কাতে দঃহঅ হুইয়া কানা ইঙ্কূ রীলামালা হড়কুরাঃআ তালারে ইঙ্কূ ক্ষমতা নামেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","রাপাজ আগ্রিপ্প, ইনা নাতিনাং সেরমা হাতেন নিয়া ভেট রাঃআ হরকাতে ইঞকে অকা গাম হুইয়াকানা ইনারাঃআ ইঞ কাইঞ বেরাহিয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","অকয় দম্মেশকশ শেহার রে মেনাকুয়া মাড়াঙ ইঙ্কূ য়া হান্ডে, তায়মতে অকয় যিরুশালেম শেহার রে হেৎদ যত যিহুদিয়া মুলুক অকা মুলুকরে মেনাকুয়া ইঙ্কূ য়া হান্ডে হেৎদ বিনইহুদি কুরাঃআ হান্ডে হেৎদ ইঞ পাস্না তাৎ আইঞ যে, কাই হাতেন মন পাল্টা কাতে ঈশ্বর রাঃআ হান্তে ইঙ্কূয়া রুয়াড় লাক্তি, হেৎদ নেকান কামি করা লাক্তি অকা দ্বারা প্রমাণ নামআ যে, ইঙ্কূ মন রুয়াড়তাৎ আকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","নিয়া নাতিনাং কথক ইহুদিকু ইঞকে উপাসনা অড়াতে সাবকাতে গজ নাতিনাং কুরুমুটু লাদআকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","মেন্খান ঈশ্বর তিহিং জাকিৎ ইঞকে দেঙ্গা আগুইঞ তানায় হেৎদ ইনা নাতিনাং ইঞ নেথাংরে তিঙ্গুকাতে হুডিং মারাং যতচ রাঃআ হান্ডে লুকুন্দী এমেতানাইঞ। ভাবি জাগারিজকু হেৎদ মোশি অকা ঘটারাঃআ থুতি গামতকাতাৎ আয় ইনা বাহাররে ইঞ যাহানা কাইঞ গামেতানা। ");
INSERT INTO cdz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ইনা থুতি হুইঅতানা নিয়া যে, খ্রীষ্টকে দুঃখ সাহা হুইঅয়া হেৎদ ইনিগে মাড়াঙ রাকাবোআয় হেৎদ ইনিরাঃআ নিজে জাতি রেঙ্কূ হড়কুরাঃআ হেৎদ অইহুদি কুরাঃআ হান্ডে মার্শাল মুলুক রাঃআ বাব্ত্তে ঘোষণা হুইঅয়া। ");
INSERT INTO cdz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","পৌল নেকাগে চিন্তং ইঞতেৎতে সায় এমেৎ কেনায় ইন্তং ফীষ্ট শাসক ইনিকে বাধাকিৎ তে কিকিচকাতে গামকিয়ায় \"পৌল, আম গাদা অলপড়হা কানাম হেৎদ ইনা অলপড়হাগে আমকে পাগলা বানাতাৎ মেয়াআয়। ");
INSERT INTO cdz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ইন্তং পৌল গামরুয়াড় কেয়ায়, মানতান ফীষ্ট শাসক, ইঞ পাগলা লহয়। ইঞ অকা গামে তানাইঞ ইনা সার্তি হেৎদ যুক্তি পেরেজ মেনাআ, ");
INSERT INTO cdz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","রাপাজ মা নিয়াবিশ্য় সারিআয় হেৎদ ইঞ ইনি লঅ সাহস লঅ থুতি তানাইঞ হেৎদ নিয়া থুতি ইঞ নিশ্চয় সারিয়াইঞ যে, নিয়ারাঃআ যাহানাগে ইনিরাঃআ মেদরে কা দানাংয়াকানা, চিয়াচি নিয়া যত ঘটনা মা মিয়াৎ লুব্বা কচারে কা হুইয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","এ রাপাজ আগ্রিপ্প, আম কি ভাবি জাগারিজ কুরাঃআ শাস্ত্র থুতি পাতিয়াম? ইঞ সারিঞ আম পাতিয়াম। ");
INSERT INTO cdz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ইন্তং আগ্রিপ্প পৌলকে গামকিয়ায় \"আম চি নিন্তি হুডাং মাহা রাঃআ ভিতারে ইঞকে খ্রীষ্টান করা নাতিনাং কুরুমুটু তানাম? ");
INSERT INTO cdz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","পৌল গামরুয়াড় কেআয় \"হুডাং মাহা হুইঅকা চি গাদা মাহা, ইঞ ঈশ্বর রাঃআ হান্ডে নিয়া বিন্তিই তানাইঞ যে, একেন আম লহয়, মেন্খান অকয় তিহিং ইঞা থুতি আয়ুম লাৎআকু ইঙ্কূ যতচ গে যেন নিয়া ঝিনঝিরি ছাড়াকাতে ইঞ লেকা যীশু পাতিয়ান হড় হুইঅ কাআকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ইন্তং মারাং শাসক কর্ত্তা ফিষ্ট হেৎদ বর্নিকী হেৎদ অকয়কু ইঙ্কিন লঅ দুবলেনাকু যতচ তিঙ্গু বিরিৎ ইদিনাকু। ");
INSERT INTO cdz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ইনা তায়ম ইঙ্কূ ইনা অড়া বাগিকাতে সেনেনাকু হেৎদ মিহুড় অট মিহুড়কে গাম লাগায় নাকু \"নিই হড়টা গজ রাঃআ কুড়াই নামরাঃআ চি জিহাল খাটারাঃআ লেকানা যাহানা কায় কামীতাৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","হেৎদ আগ্রিপ্পা ফীষ্ট শাসক কে গামকিয়ায় \"নিই হড়টা যদি কৈসররাঃআ হান্ডে কায় আপিলেআয় হুনাং এন্খান ইনিকে আড়া গিডি হুইয়া হুনাং। ");
INSERT INTO cdz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","চিন্তং ফায়সালা হাতা হুইয়েনা আলে জাহাজতে ইতালিয়া দিসুম সেনালে, ইন্তং পৌল হেৎদ এটা কথক আটকান হড় আগস্তীয় পাল্টন রিনিজ পাল্টন যুলিয় নুতুমান গম্কে জুলু পতি রাঃআ তিহিরে সম্পায়নালে। ");
INSERT INTO cdz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","হেৎদ আলে আদ্রামুত্তীয় শেহার হাতেন জাহাজ রে দেজেন্তেলে সেনেএনা, অকা জাহাজটা এশিয়া মুলুক রাঃআ উপকূল রাঃআ যত ঘাটতে সেনা। মাকিদনিয়া রাঃআ থিষলনীকী রিনিজ অদিবাসী আরিষ্টার্খ আলে লঅ তাহিন কেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","হেৎদ দশার হুলাং আলে সীদোন শেহার তেলে সেটেরেনা, কদেরে যুলিয় পৌলেরকে সম্মান লঅ ইনিকে গাতিকুরা হান্ডে ইদিকিদতে খাতির এমঅ নাতিনাং অনুমুতি এমকেৎ কুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","হেৎদ এনথাং হাতেন জাহাজ লাড়াকাতে সামাং দর হোয়অ কেদ খানয় আলে কুপ্র ঢিপ রাঃআ দানাং দানাংতেলে সেনেএনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","হেৎদ কিলিকিয়া হেৎদ পামফুলিয়া টলা রাঃআ সামাং দররাঃআ দরেয়া পারমকেৎতেলে লুকিয়া তালুক রাঃআ মুরা শেহার তেলে সেটেরেনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","হেৎদ পাল্টন কুরাঃআ গমকে এনথাং হাতেন ইতালিয়াতে সেনকেনায় মিয়াদ আলেকজান্দ্রীয় জাহাজ নেলনামকাতে আলেকে ইনা জাহাজরে দেচকেৎ লেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","হেৎদ গাদা মাহা বাই বাইতে জাহাজটা সেনেএন্তে কুঠিন কষ্টেতে ক্লীদ শেহারতে সেটেরেনা, হোয়অ রাঃআ দেঙ্গা কা নামকেদতে মাড়াঙ কাদাড়িলাদআয় খানঅ আলে সলমোনি রাঃআ মাড়াঙ হরকাতে ক্রীতী ঢিপ রাঃআ অছাড় হরকাতে সেনেনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","হেৎদ আলে সাশাতি-তে ইনা পারমে তানলো আলে বুগিন ঘাট নুতুমান মিয়াৎ তাহীনথাং তেলে সেটেরে না। ইনা ঠাইন রে লাসেয়া শেহার মেনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","হেৎদ গাদা মাহা হুইয়েন রে হেৎদ ইহুদি কুরাঃআ বার পরব পারমলেনা হেৎদ দাআ হরাতে সেসেন বর আন হুইওতান তাহি কেনা, ইনা মেন্তে পৌল ইঙ্কূ পরামর্শকেৎ কুতে গামাৎ কুয়ায়্য়য়, ");
INSERT INTO cdz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","এ হাগাকু ইঞ নেলনামে তানাইঞ যে, নিয়া দাআ তে সেসেন রে গাদা বিপদ হেৎদ ক্ষতি হুইয়া, ইনা একেন জিনিসপত্র হেৎদ জাহাজরা লহয়, আবুয়াহঅ গজয়াবু। ");
INSERT INTO cdz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","মেন্খান জুলুপতি পৌলরাঃআ থুতি কা লুতুর কাতে ক্যাপ্টেন হেৎদ জাহাজ মালিক রাঃআ থুতিরে ডের মন এম কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","হেৎদ ইনা থাং রাবাং মাহা তাহি নাতিন গটা কা তাহি কান রে এনথাং হাতেন সেন কু তে হুই দাড়িয়া রেদ ফৈনীকা শেহার রে রাবাং মাহা তাহি কেনা মেন্তে ঢের লেকা কু গাম কেয়া, ইনা ক্রীতীঢিপ রাঃআ মিয়াৎ বন্দর তানা, নিয়া উত্তরপশ্চিম হেৎদ দক্ষিণপশ্চিম দর নিজোতানা। ");
INSERT INTO cdz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","হেৎদ দক্ষিণ হোও বাই বাই তে হয়ওয় তান রে ইঙ্কূ আবুয়া মনে লেকা হুইয়া মেন্তে কু সারি কেৎতে লাঙ্গার কু রাকাব কেয়া হেৎদ ক্রীতী ঘাট তেকু সেনে য়ানা। ");
INSERT INTO cdz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","মেন্খান হুডিং মাহা তায়ম তে ঘুরব্যান্ডূ (উরাকুলো আইলা) নুতুমান হয়ও জাহাজ এ টঅ কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","জাহাজ ইনা হয়ও তে ঠেলা ইদিয়েন তে হেৎদ ইনা কা টঅ দাড়িআদ তে আলে সেন তকা কেয়াহেৎদ লে বুহাল ইদিয়া না। ");
INSERT INTO cdz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","হেৎদ কৌদা নুতুমান মিয়াৎ হুডিং ঢিপ রা দানাং রে বুহালো তানালে গাদা কষ্ট তে লাউকা লেরে রাকাব দাড়িয়াদালে। ");
INSERT INTO cdz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ইনা রাকাব কেৎ তে ইঙ্কূ রুখিয়া নাতিন তে জাহাজ কু আটক ঘুরা কেয়া হেৎদ সুতি নুতুমান চরাবালি রে নুর বরতে ইঙ্কূ জাহাজ নোঙ্গর কু আড়গু কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","হেৎদ আলে গাদা বিরঝড় রে হবু ডাবুন খান ইঙ্কূ দশার হুলাং জিনিষকু দাআরে লেবদা গিডি কেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","হেৎদ আপি মাহারে ইঙ্কূ নাবি আকুয়া তিহি তে জাহাজ রা জিনিস কুকু দাআরে লেবদা গিডি কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","হেৎদ গাদা মাহা যাকিৎ বেলাকে হেৎদ ইপিলকু কাকু নেলনাম লেনা হেৎদ মারাং হয়ওএবীর হয়ও দাআ হুইঅ তানগেএ খান আলেয়া বানচা রাঃআ আশ কা তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","হেৎদ ইঙ্কূ গাদা মাহা বিন জম নু কাতে কাটায় কেৎকু, পৌল ইঙ্কূ য়া তালা রে তিন্গুইয়েন তেএ গামাৎ কুয়ায়্য়য়, এ মান্তান হড় কু, আপে ইঞয়া থুতি যদি মানা-বাতা কাতে ক্রীতী হাতেন কাপে হিজ লেখান নিয়া দুঃখ দুর্দশা হেৎদ হানি কাপে নাম কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","নাহা দইঞ আপেকে সাহস এমাপে তানাইঞ, যাহায় রাঃআ জিউ নাশ কা হুয়াআ, শুধু জাহাজ রাঃআ ক্ষতিয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","চিয়া চি ইঞদ ঈশ্বর রা হড়, হেৎদ অকয়্য় কে গুনমানত তিয়াং ইনি রাঃআ মিয়াৎ সেরমা রিনিজ নাঙ্গা হলা নিদা ইঞ য়া হান্ডে তিঙ্গুয়ে নায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","এ পৌল, আলম বরয়া, আম কৈসর রা সামাং রে তিঙ্গুন হুযুয়া হেৎদ নেলেমে, অকয়কু আম লঅ সেনতানকু যতচ কুকে ঈশ্বর দায়াদুলাড় এমাদ কুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","এন্খান গম্কে কু, সাহস পে, চিয়া চি ঈশ্বররে ইঞয়া নেকান পাতিয়া মেনাআ, ইঞ হান্ডে চিল্কা গামা কানা এন্কাগে হুযুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","মেন্খান আবু যাহান ঢিপ রেগে সেটের হুযুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","হেৎদ আলে আদ্রিয়া দরেয়া রে বাই বাইতে সেসেন সেসেন্তে গেলে পুন নিদা হুইয়েন্তে তালা নিদা জাহাজ নাবি কু টাহর কেৎআকু জাহান দিশুম কাতা বু সেটেরা কানা মেন্তেকু আটকার কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","হেৎদ বায়র লেব্দা ডুম্বুইজ কেতে বিশ বাঁউ দাআ নাম কেয়া হেৎদ হুডিং লেকা সেনে য়েন্তে অট মিসা বায়র ডুম্বুইজ কে তে গেল মড়ে বাঁউ কু নাম কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ইন্তং ধীরি দর রে তাকিচ তাহীন রাঃআ বর তে ইঙ্কূ জাহাজ রাঃআ তায়ম দর তে উপুনিয়া গল্সীফাল কু আড়গু কেয়া হেৎদ বিন্তিতে তাহি কাতে সিঙ্গি রাঃআ তাঙ্গিরেকু তাহিন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","মেন্খান জাহাজ নাবি কু জাহাজ হাতেন নির জময়াকু মেন্তে কুরুমুটুৎ কেনায়কু হেৎদ গ্ল্হির রাঃআ হুডাঙ মাড়াঙ দর গল্সীফাল আড়গু ছলতে ডঙ্গা দরেয়া রে আড় গুৎকেনা কু, ");
INSERT INTO cdz_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","মেন্খান পৌল জুলু পতি গমকে হেৎদ পাল্টন কুকে গামৎ কুয়ায়্য়, ইঙ্কূ হড় জাহাজ রে কাকু তাহিনখান আপে কাপে বাঞ্চা কাপে নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ইন্তং পাল্টন কু লাউকারা বায়র মাআটটা কেৎতেকু ইনা দাআরে কু উয়ু কেৎআ। ");
INSERT INTO cdz_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","হেৎদ পায়াং পুয়ুং আঙ্গ তান্খানঅ পৌল যতচ কুকে জমা জমেপে মেন্তে এ গমকেৎ কুয়ায়্য় হেৎদএ গামা কেৎ কুয়ায়্য়, আপে তিহিং গেলে পুন মাহা যুহুয়েনা,আপে তাঙ্গিরে মেনাআ পেয়া, কা জম নু কাতে মেনা আ পেয়া, জাহানা কা জম নু কাতে নিদা সিঙ্গি পে হরতাৎআ, ");
INSERT INTO cdz_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ইনা মেন্তেইঞ নেহরাপে তানা জমা জমে পে ইনা দ অপেয়া বাঞ্চা নাতিনাং লাকতিয়া, আপেএ-তে বহ রা মিয়াৎ উব হঅ কা উয়ু গোয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","হেৎদ নিয়া গাম কেৎ তেল পৌল ইনা পিঠা এ সাব কেয়ায়, হেৎদ যতচ কুয়া সামাং রে ঈশ্বর এ সারহাও কিয়ায় হেৎদ ইনা কেচা কেৎ তেএ জম কেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","এন্তে যতচ কু সাহস কেৎ তেকু জম কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","হেৎদ জাহাজ রে আলে যতচ কু বার জুলু তিলি তুরুই হড় লে তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","হেৎদ জম বি কেৎতে দরেয়া রে গহম কু লেবদা গিডি কেয়া হেৎদ জাহাজ কু হাউলকা কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","আঙ্গ য়েন খান ইঙ্কূ ইনা ঢিপা কাকু নেল চীনহা দাড়ি লাৎআ, মেন্খান এনকান মিয়াৎ পাড় কু নেল নামকেয়া, ইনাদ বালিচর তাহীন কেনা, হেৎদ হুইও দাড়ি রেদ আবু জাহাজ এনথাং রেবু ঠেকা দেয়া মেন্তে কু গটা কেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","হেৎদ আকুড়া ফাল কুরা রাঃআ বায়রকু মাআটটা কেৎ তে ইনা দরেয়া রেকু বাগি তুকা কেয়া হেৎদ ইনতং গে হাল রা তলকু রাড়া কেৎ তে হেৎদ হয়ও সামাং রে পাল রাকাব কেৎ তেকু ইনা বালি ঘাট তেকু সেনে য়ানা। ");
INSERT INTO cdz_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","মেন্খান বানার দর দরেয়া রাঃআ গাহির দাআ মেনাআ এনে এনকান জায়গারে হিচেন খান্কু চররে জাহাজ আটকায়না হেৎদ জাহাজ সামাং দর তাকিচেন্তে রচৎ এনা মেনখান তায়ম দর ঢেউ রাঃআ তাকিচ তাকিচতে পেটেজে না। ");
INSERT INTO cdz_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","মেন্খান সিপাই কু আটক কুকে গচ গিডি নাতিনাং কারসাদি কেয়াকু যাতে যাহা হঅ অয়ার কাতে আল কু নির দাড়িকাআ। ");
INSERT INTO cdz_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","মেনখান জুলু পুতি কুরাঃআ গমকে পৌলকে বাঞ্চা নাতিনাং ইঙ্কূয়া কারসাদী এড়িচ কেৎআয় হেৎদ হুকুমাৎ কুয়া হেৎদ অকয়্য় অয়ার দাড়িআপে মাড়াঙ তে যেহেত কাতে ঘাট তে আড়গুন পেদু, ");
INSERT INTO cdz_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","হেৎদ বাকি যতকু তক্তা কুরে হেৎদ জাহাজ রা এটা এটা জিনিসকুরে সাহারা হাতা কাতে পরম পে মেন্তে এ আচু কেৎ কুয়ায়্য় য়। নেকা গে যতচ ডাঙা তে পারম মেন তেলে বাঞ্চায় না। ");
INSERT INTO cdz_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","আলে রেহাই নামরাঃআ তায়ম সারিনামকেয়ালে যে, ইনা ঢিপ রাঃআ নুতুম মিলিতা। ");
INSERT INTO cdz_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","হেৎদ এনথাং মিলিতা ঢিপ রেঙ্কূ বর্ব্বর হড়কু আলেকে বেশঠিকার পাহি খাতিরকেৎ লেয়াকু, বিশেষকাতে দাঃআরে হেৎদ রাবাংরাঃআ নাতিনাং সেঙ্গেল জুলকাতে যতচ কেকু আতাং দারামকেৎ লেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","মেন্খান পৌল মিৎ বঝা সাহান হালাং হুন্ডিকেৎ তে ইনা সেঙ্গেলরে তিনকেয়ায় খানঅ সেঙ্গেলরা এলাংতে মিয়াৎ জজম বিং উডুঙয়েনতে ইনিরা তিহিরে লাঠা দঃহয়নায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ইন্তং বর্ব্বর হড়কু ইনি রাঃআ তিহিরে ইনি বিংটা হাকাকানায় নেলকিদতেকু আকু-আকুগে গাম লাগায়নাকু, নিই হড়টা নিশ্চয় হড় গজিই, দরেয়া হাতেন রক্ষেয়া নামকাতেন হঅ ধর্ম নিইকে কায় বাঞ্চা তুকালিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","মেনখান ইনি তিহি কটা গিডিকাতে বিংটাকে সেঙ্গেলরে হুল্লা কিয়ায় হেৎদ পৌল রাঃআ যাহানা কা ক্ষতি হুইলেনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ইন্তং ইঙ্কূ তাঙ্গি হাতাড়েনাকু যে, ইনি ফুলা রাকাবোওয়ায়, বাংখান দ আচকাগে গচ কাতে অতেরে নুরআয়, মেন্খান গাদা ঘাড়ি জাকিদ তাঙ্গি তায়ম, ইনিরা যাহালেকানা খারাপ কাকু নেলনামকেৎ তে, ইঙ্কূ এটালেকাতে আটকার নামকেৎ তেকু গাম লাগায়না, ইনিদ দেবতা তানায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ইনা থাং রে পুব্লীয় নুতুমিজ গম্কে রাঃআ হাসা ঢিপা তাহি লেনা ; ইনি আলেকে খুশি তুকা লেকাতে আতানাং ইদি কেৎ লেতে পাহি লেকাতে আপি মাহা জাকিৎ খাতির যত্ন কেৎ লেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","হেৎদ পুব্লীয় রাঃআ আপুতেত রুয়া হেৎদ সুল বাহির অতে থাকা কাতে পার্ক্ম্রে বাজিয়া আকান তাহি কেনায়, ইনি রাঃআ হান্ডে পৌল এ বলয়েন্তে হেৎদ ইনি রাঃআ বহ রে তিহি দঃহ কেৎ তে বিন্তিকেৎতে ইনিকে বুগিকিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","এনেএংকা হুই লেন তে ইনা ঢিপি রেনকু এটা রুয়া হাসু হড় কু হিচ য়েন তেকু বুগি না। ");
INSERT INTO cdz_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","হেৎদ ইঙ্কূ আলেকে গাদা কু মাইন হেৎদ লভা কেৎ লেয়ায়কু হেৎদ আলে অকা হুলাং রুয়াড় হিজুয়ালে লাকতিয়াকু জাহাজ রে আগু তুকা কেৎআকু। ");
INSERT INTO cdz_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","হেৎদ আপি বঙ্গা তায়ম তে আলে আলেকসান্দ্রিয় রাঃআ মিয়াৎ জাহাজ রেলে দেজেনা; ইনা জাহাজ ঢিপ রে রাবাং কাল কাটাৎ কেনায়, জাহাজ রাঃআ সামাং চেতাং দররে \" গ্রীক দেব্তা যিয়াস রাঃআ জমকা-জুড়ি হন কিন\" রাঃআ ছাপ তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","হেৎদ সুরাকুষ শেহার তে সেটেরেন তে আলে এনথাং রে আপি মাহা লে তাহীলেনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","হেৎদ এন থাং হাতেন আলে ঘুরা ঘুরা তে রাগী শেহার তেলে সেটেরেনা হেৎদ দশার হুলাং দক্ষিন দর হাতেৎ হয়ও কেয়ায়, ইনা তে আলে দশার হুলাং পুতিয়লী শেহার তেলে সেটেরেনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","এনথাং রে আলে কথক পাতিয়ান হাগা কুলঅ নাপামেনালে, হেৎদ ইঙ্কূয়া নেহরতে আপি মাহা আকু লোঅ তাহীনালে হেৎদ নেকা লেকাতে আলে রোম শেহার তেলে সেটে রেনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","হেৎদ আলেয়া খবর আয়ুম কেৎতেকু রোম রিঙ্কু পাতিয়ান হাগা কু এনথাং হাতেন অপ্পিয় রাঃআ হাট হেৎদ আপিয়া ডেরা যাকিৎ আলেকে দারম ইদি নাতিনাং উডুঙ য়েনা, হেৎদ পৌল ইঙ্কূকে নেল কেৎ কুতে ঈশ্বরকে সারহাও কিয়ায় হেৎদ জিউ তেয়া রাড়েজ য়েনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","হেৎদ রোম শেহার তে সেটের লেনতে পৌল রা মিয়াৎ হরিচকে পাল্টন কুলঅ তাহি নাতিনাং সায় নাম কেৎআয়। ");
INSERT INTO cdz_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","হেৎদ আপি মাহা তায়ম তে পৌল ইহুদি কুয়া মাপরাং হড় কুএ রাঃআ হুন্ডি কেৎ কুয়ায়্য়য় হেৎদ ইঙ্কূ হুন্ডিয়েনখান ইনি এ গামাৎ কুয়ায়্য়, এ দুলাড়িয়া হাগা কু, ইঞ আবুয়া জাতি রিনকু চি আবুয়া হাড়াম হাপড়াম কুরায়া আরি-চালি কুরা বিরুধ যাহানা কাইঞ কামীতাৎ কেন রেঅ, তবু রঅ যিরুশালেম শেহার হাতে রোমীয় কুরা তিহি রেকু জিমা কিংয়া। ");
INSERT INTO cdz_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","হেৎদ ইঙ্কূয়া দরবাররে ইঞআ গচ নাতিনাং যাহানা গুনহা কা তাহি কেনা ইনা মেন্তে ইঞকে আড়া গিডি বুঝা লাৎকুয়া। ");
INSERT INTO cdz_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","মেন্খান ইহুদি কু বিরুধ কেৎ রেদ ইঞ কৈসর রাঃআ হান্ডে আপিল লাকতিংয়ানা, ইঞয়া নিজ জাতি রেন কুয়া চেতাং জাহানা নালিশ নাতিন কেনা এংকাদ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","নিয়া নাতিনাং তে ইঞ আপে লঅ নেপেল চি জাগার নাতিনাং আপেকে রাআ কুল কেৎ পিঞ ; খেরয়াল কুরাঃআ তাঙ্গিতাড়াআ রাঃআ শিকড়ি তেইঞ আটকা কানা। ");
INSERT INTO cdz_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ইঙ্কূ গাম কেয়াকু, আলে আমা নাতিন তে জিহুদিয়া হাতেন গিরা কালে নাম তাৎআ; হেৎদ যাহায় হাগা হিচেন্তে আমা বাড়িচ অবস্থা বাব্ত্তে যাহায় হিচ কাতে আমা বেশ বাড়িচ খবর কাকু গামাতাৎ লেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","মেন্খান আমা থুতি কিনা তানা, ইনা আমা মচা হতেন আয়ুম লে বুঝালে তানা, চিয়াচি ইনা দল বাব্ত্তে সারিয়ালে, যত থাংরেন কু হড় নিয়া বিরুত তে থুতি ভাড়া য়াকু। ");
INSERT INTO cdz_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","হেৎদ ইঙ্কূ ইনি নাতিনাং তে মিৎ মাহা গাদা হড় কু ইনিরাঃআ অড়া কু হিচ লেনা, হেৎদ ইনি ইঙ্কূ য়া হান্ডে ঈশ্বর রাঃআ মুলুক রাঃআ গোহা সেতাঃআ হতেন বেলা ডুঁবুজ হাবিজ এম কেৎআয়, হেৎদ মোশি আরি-চালি তে হেৎদ ভাবি-জাগারিজ কুরা পুথি তেহ যীশু রাআ বাব্ত্তে থুতি-জাগার চেদকেৎ কুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","এন্খান কথক হড় কু পাতিয়ানাকু কথক হড় কু কাকু পাতিয়াও লেনা। ");
INSERT INTO cdz_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ইঙ্কূ আকু আকুরেকু মিৎ মত কা হুই য়েন তে হেৎদ পৌল মিয়াৎ থুতি এ গাম লেদ তায়ম তে ইঙ্কূ কু সেনে না ইনি এ গাম কেয়ায়, রীলামালা আত্মা যিশাইয় ভাবি-জাগারিজ রাঃআ হরা তে আবুয়া হাড়াম হড় কু বুগি লেকা তেএ গামাৎ কুয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","চিল্কা ইনি এ গাম কেয়ায়, নিকু হড় কুয়া হান্ডে সেন মে হেৎদ ইঙ্কূ কে গামা কুমে, আপে লুতুরতে আয়ুম দপে আয়ুম মেয়া মেন্খান কাপে আটকার নামেয়া, হেৎদ মেৎতে নেল দপে নেলেয়া মেন্খান কাপে নেল টাহর দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","চিয়া চি নিকু হড় কুরাআ অন্তর কেটেজা কানা, হেৎদ ইঙ্কূ লুতুর তে কাকু আয়ুম পাছনায় তানা, হেৎদ আকুয়া মেৎ কুকু জাপিৎ কেয়া, যাতে ইঙ্কূ মেদ তেকু নেলে তানা হেৎদ লুতুর তেকু আয়ুম এ তানা হেৎদ মন রেকু বুঝায়ে তানা হেৎদ কু রুয়াড় হিজুয়া হেৎদ ইঙ্কূকু ইঞ বুগি কুতেয়া হুনাইঞ। ");
INSERT INTO cdz_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ইনা মেন্তে আপে সারিই কাআপে, ঈশ্বর রাআ বান্চাও রুক্ষীয়া জাগার (বিনজাতিরেনকু) বিনইহুদিকু হান্ডে কুলা কানা; হেৎদ ইঙ্কূ কো আয়ুমেয়া। ");
INSERT INTO cdz_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(হেৎদ ইনি নেয়া এ গাম কেৎ তে ইহুদি কু আকু আকু রেঢের সেনে না) ");
INSERT INTO cdz_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","হেৎদ পৌল গোটা গুটি বার সির্মাং জাকিত আয়া ভাড়া অড়ারে বার সির্মাং এ তাহিন কেনায়, হেৎদ আয়া হান্ডে অকয়্য় গেকু হিচুকেনা যতচ কুকে আতাং দারামেৎ কুকেনায়। ");
INSERT INTO cdz_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","হেৎদ ইনি ঈশ্বর রা মুলুক রা জাগার পুরা সাহস তে গাম-পাসরা তান হেৎদ প্রভু যীশু খ্রীষ্ট রাআ জাগার চেদকু তানএ তাহীন কেনায় হেৎদ যাহায় এ ইনিকে কাকু বাধা এমাই কেনা।");
INSERT INTO cdz_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ইঞ পৌল, ঈশ্বর রাঃআ ইচ্ছা লেকাতে খ্রীস্ট যীশু রাঃআ কুলিচ হুই নাতিনাং অকয় কে বাছা হুই লেনা হেৎদ হাগা সোস্থিনি, ");
INSERT INTO cdz_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","করিন্থি শেহার রে তাহিন হড় ঈশ্বর রাঃআ মন্ডলী কে, খ্রীস্ট যীশু অকয় কুকে রিলামালা তাৎ কুআয় হেৎদ অকয়কুকে রিলামালা হুই নাতিনাং রাআ তাৎ কুয়ায় ইঙ্কূ হেৎদ অকয় কু যত জায়গারে আবুয়া যীশু খ্রীস্ট রাঃআ নুতুমতেকু বিন্তিয়া ইঙ্কূকে নিয়া গিরা অলা তান কুয়াঞ, ইনিদ ইঙ্কূয়া হেৎদ আবুয়া প্রভু। ");
INSERT INTO cdz_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","আবুয়া বাঃআ-ঈশ্বর হেৎদ প্রভু যীশু খ্রীস্ট হাতেৎ নিরাই হেৎদ সুলুক আপেকে এমা ইদি পেকায়। ");
INSERT INTO cdz_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ঈশ্বর রাঃআ অকা নিরাই খ্রীস্ট যীশু লিয়া আপেকুকে দত্ত হুয়াকানা, ইনা নাতিনাং ইঞ আপেয়া বাবদতে ঈশ্বরকে গুন জহারাই তানাঞ; ");
INSERT INTO cdz_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","চিয়াচি ইনিরাআ লিয়া আপে যত বেপার্তে, যত জাগার তে হেৎদ যত আকেল তে কিসাড়া কানাপে, ");
INSERT INTO cdz_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ইন্যা লেকাতেগে খ্রীস্ট রাঃআ বাব্দতে আলেয়া সাক্ষ আপেয়া তালারে বাসা হাপেয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","নিয়া নাতিনাং আপে জাহান আত্মিক দানরে কাপে তায়মা কানা; আবুয়া প্রভু যিশু খ্রীস্ট রাঃআ সদর রাঃআ তাঙ্গি রে মেনা পেয়া; ");
INSERT INTO cdz_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","হেৎদ ঈশ্বর দঅ আপেকে মুচাত হাবিচ স্থির দহ পেয়ায়্য়, যেন আবুয়া প্রভু যীশু খ্রীস্ট রাআ হিজু রুয়াড় মাহারে বিনা নিন্দারে তাহিনোপে। ");
INSERT INTO cdz_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ঈশ্বর পাতিয়ানকু, অকয় লিয়া আপে ইনি রাঃআ হন, আবুয়া প্রভু যীশু খ্রীস্ট রাঃআ সহভাগিতা রাআ খাতিরাং রাআ হুইয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","মেন্খান এ ব্কঞ তিকু হেৎদ মিশি তিকু, আবুয়া প্রভু যীশু খ্রীস্ট রাঃআ নুতুমতে ইঞ আপেকে নেহর কাতেত গামাপে তানাঞ, আপে যতয়চ হড় মিৎ মনেতে হেৎদ বিচার রে মিৎ দিশাতে গে জাগার পে, মেন্খান আপেয়া তালারে দলা দলি আল হ্যুইওকাঃ আ। ");
INSERT INTO cdz_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","চিয়া চি, এ ব্কঞ তিকু, ইঞ ক্লোয়ী রাঃআ অড়াহড় কু রাঃআ হান্ডে হাতেৎ আপেয়া বাব্ত্তে খবর নাম তাত্যাং চি, আপে তালারে বিবাদ মেনা আ। ");
INSERT INTO cdz_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ইঞ নিয়া গামে তানাঞ চি, আপে যতয়চ গাম ভাড়ায়াপে \"ইঞ পৌল কে মানাইয়াঞ, হেৎদ ইঞ আপল্ল কে মানাইয়াঞ, হেৎদ ইঞ কৈফা কে মানাইয়াঞ, হেৎদ ইঞ খ্রীস্ট কে মানাইয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","খ্রীস্ট দঅ চি হাটিং য়া কানায়? পৌল দঅ চি আপে নাতিনাং ক্রুশ রে গচ লেনায়? হেৎদ চি পৌল রাঃআ নুতুমতে দুবুং ঙ্গআ কানাপে? ");
INSERT INTO cdz_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ঈশ্বর রাঃআ সারাও ইয়াঞ যে, ইঞ আপেয়্য়া তালারে ক্রীস্প হেৎদ গায়ঃ কে বিনা অটঅ জাহায়কেগে কাঞ দুবুং তাৎকুয়া, ");
INSERT INTO cdz_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","যেন যাহায় আলকু গামেকাঃ আ চি, আপে ইঞা নুতুম তে দুবুং ঙ্গাআ কানাপে মেন্তে। ");
INSERT INTO cdz_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","হেৎদ স্থিফান রাঃআ অড়া হড় কুকে দুবুং তাৎ কুয়াঞ, অটঅ যাহায় কুকে হঅ দুবুং তাৎ কুয়াঞ, ইনা দঅ কাঞ সারিয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","চিয়া চি খ্রীস্ট ইঞকে দুবুং এমঅ নাতিনাং দঅ কায় কুল তিঞ আয়, মেন্খান বুগিন বার্তা গাম পাসনা নাতিনাং; ইনা হঅ আকেল রাঃআ থুতি তে দঅ ল্হয়, যাতে খ্রীস্ট রাঃআ ক্রাস রে গচঅ বেকার আলঃঅ সেনঃঅ কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","চিয়া চি ইনি খ্রীষ্ট রাঃআ ক্রস রে গচঅ রাঃআ বার্তা, অক্য়য় কু বিনাশঃ তানা, হান্কুয়া হান্ডে মুর্কতা, মেন্খান পরিত্রান নামেতানা আবু আবুয়া হান্ডে ইনা ঈশ্বর রাঃআ মহা পরাক্রম। ");
INSERT INTO cdz_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","চিয়া চি শাস্ত্র রে অল মেনা আ 'ইঞ আকিলান কু রাঃআ আকেলেইঞ নাশেয়া, বিবেচক মান্মি কু রাঃআ বিবেচনাইঞ ব্যর্থয়া। ");
INSERT INTO cdz_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","আকিলান কুরা গুরুত্ব করে? কটাল কুরা গুরুত্ব করে? নিয়া যুগরিঙ্কূ বিতর্ক হড় কুরা গুরুত্ব করে? ঈশ্বর দ্চি ধার্তি রাঃআ আকেলকে মুর্ক কাতে কায় ধহ তাত্যায়্য়? ");
INSERT INTO cdz_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","চিয়া চি, ঈশ্বর আয়া আকেল রে ঠিক কেৎআয় আকিলান হড় আয়ায়্য় আকেল লিয়া ঈশ্বরকে কায় সারি নাম তিয়ায়্য়, ইনাতে ঈশ্বর সন্তুষ্ট কাতে গাম্পাসনাআ রাঃআ মুর্খতা লিয়া পাতিয়ান হড় কু কাই হাতেৎ পরিত্রান নামে কাআ কু। ");
INSERT INTO cdz_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","চিয়া চি যিহুদী কু দঅ চিনহা কু নানামা হেৎদ গ্রীক কু দঅ আকেল কু পাঞ্জা ভাড়ায়া; ");
INSERT INTO cdz_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","মেন্খান আলে দঅ ক্রাস রে গ্চাকান খ্রীস্ট কেলে গাম পাসনায়া; ইনি দঅ জিহুদিকু রাঃআ হান্ডে বাধা হেৎদ অজিহুদী কু রাঃআ হান্ডে মুর্ক লেকা, ");
INSERT INTO cdz_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","মেন্খান জিহুদী হেৎদ গ্রীক,অকয় কুকে রাঃআ হুইয়াকানা ইনকু যতয়চ রাঃআ হান্ডে খ্রীস্ট ঈশ্বর রাঃআ গে মহা পরাক্রম হেৎদ ঈশ্বর রাঃআ গে আকেলতানা। ");
INSERT INTO cdz_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","চিয়া চি ঈশ্বর রাঃআ অকা মুর্খতা রাআ বাবদ, ইনা মান্মি রাঃআ আকেল হাতেৎ গাদা আকেলী হেৎদ ঈশ্বর রাঃআ অকা নিজুরি, ইনা মান্মি রাঃআ দাড়ি হাতেৎ গাদা দাড়িয়ান। ");
INSERT INTO cdz_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","চিয়া চি, এ ব্কঞ তুকু হেৎদ মিশিতুকু, আপেয়া আতাংশিপিং নেলেপে, চিল্কা মান্মি রাআ নজর রে আকিলান বেশি বানু কুয়া, পরাক্রম বেশি বানু কুয়া, সাল্গী গান্ডূ গুনমান হঅ বেশি বানুকুয়া; ");
INSERT INTO cdz_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","মেন্খান ঈশ্বর ধার্তি রিঙ্কূ যত মুর্খ বাবত কুকে বাছা কেৎ কুয়্য়ায়, যাতে আকিলান হড় কুকে গিয়ুউ এম কুকায় হেৎদ ঈশ্বর দঅ ধার্তি রিঙ্কূ যত নিজুরি বাবদ কু বাছা কেৎ আয়, যাতে দারিয়ান বাবদ কুকে গিয়ুউ এম কুকায়; ");
INSERT INTO cdz_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","হেৎদ ধার্তি কু রাঃআ অকা অকা নিচ হেৎদ অকা অকা তুচ্ছ, অকা অকাআ যাহানাগে ল্হয়, ইনা যতয়া কুগে ঈশ্বর বাছা কেৎআয়, যাতে, অকা অকা কুরাআ দাম মেনাআ, ইনা যত আমানকে দামান হীন ক্রায়ায়্য় কায়; ");
INSERT INTO cdz_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ইনি নিয়া নাতিনাং গে করা তাৎআয় যাতে যাহায় ঈশ্বর রাআ সামাংরে শ্লাগা আলঃঅ কু সদর দাড়ি কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ঈশ্বর আপেকে খ্রীস্ট যীশু লঅ মেশা কেৎ পেয়ায়, আবুয়া ফায়দা রাআ নাতিনাং ঈশ্বর ইনিকে আকেল রাআ হরা কিৎআয়, ইনি আবুয়া নাতিনাং ঈশ্বর লঅ মেশা রাআ, রিলামালা বানা নাতিনাং, হরারাআ বানায়নায়, হেৎদ আবুকে কাই হাতেৎ পরিত্রান এমা কেৎবুআয়। ");
INSERT INTO cdz_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","চিল্কা অল মেনা আ 'অকয় হড় স্লাগায়ায়্য়, ইনি দঅ প্রভূ রেগে শ্লাগায় কাআয়। ");
INSERT INTO cdz_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","হেৎদ, এ হাগাঞ হেৎদ মিশি তুকু ইঞ চিন্তং আপেয়া হান্ডে সেন লেনাঞ, ইন্তং বুগিন বুগিন থুতি জাগার্তে হেৎদ আকেল তে গুরুত্ব লেকাতে আপেকে অকা ঈশ্বর রাঃআ সাক্ষসদর পাস্না নাতিনাং সেটের লেনাঞ, ইনা দঅ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","চিয়া চি ইঞ মনেঞ গটা লাৎআ, আপেয়া ভীতিররে অটঅ জাহানা আ আলঞ সারিই কাআ, একেন যীশু খ্রীষ্ট কেগেঞ হেৎদ ইনিকে ক্রাস রে গচ লিৎয়াকু মেন্তে, সারিকা আঞ। ");
INSERT INTO cdz_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","হেৎদ ইঞ আপেয়া হান্ডে নিজুরি, বর হেৎদ বর তে থার থারিঞ বুজাত কেনা, ");
INSERT INTO cdz_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","হেৎদ ইঞা জাগার হেৎদ ইঞা গাম পাস্না আপেকে ভুলা রাঃআ নাতিনাং দঅ ইনা আকেল রাঃআ জাগার রাঃআ লেকা কাঃআ তাহিলেনা, বরং ইনাকু দঅ রিলামালা আত্মা রাঃআ মহা পরাক্রম রাঃআ প্রমাণ তাহিলেনা, ");
INSERT INTO cdz_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","যাতে আপেয়া পাতিয়া মান্মি কু রাঃআ আকেল লেকা তে আলঅ হ্যুকা আ, মেন্খান ঈশ্বর রাঃআ মহা পরাক্রম লেকা তে হ্যুকা আ। ");
INSERT INTO cdz_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","এন্খান আলে আত্মিক সীদ্ধ হড় কুরাঃআ তালারে আকেল রাঃআ জাগার তানালে, মেন্খান হানা আকেল নিয়া যুগ রাঃআ লহয় হেৎদ নিয়া যুগ রাঃআ নাশঃতান শাসন কর্তা কু রাঃআ হঅ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","মেন্খান আলেদ সাক্ষসদর রাঃআ লেকা অর্থাৎ ঈশ্বর রাঃআ হানা আকেল রাঃআ লে জাগারে তানা, ইনা উকুয়া আ কান আকেল, অকা ঈশ্বর আবু কে সম্মান এমঃঅ নাতিনাং ধার্তি সির্জন রাঃআ মাড়াং হাতেৎ গে স্যাপড়া ধহ লাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","নিয়া যুগ রিঙ্কূ শাসন কর্তা কু রাঃআ তালারে ইনা যাহায় কাকু সারি কেনা; চিয়া চি যদি কু সারি কেয়া হুনাং এন্খান দারিয়ান প্রভুকে ক্রাস রে কাকু গচ কিয়া হুনাং। ");
INSERT INTO cdz_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","মেন্খান, চিল্কা রিলামালা শাস্ত্র রে অল মেনা আ 'মেত অকা আ কায় ঞেল নাম তাৎআয়, লুতুর অকা কায় আয়ুম তাৎআয়, হেৎদ অকা মান্মি যাহা চিল্লং অন্তররে কায় আটকার তাৎআয়, অকা ঈশ্বর, অক্য়্কু ইনিকে কুসিয়া ইয়াকু, ইঙ্কূয়া নাতিনাং স্যাপড়া ধহ তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","চিয়াচি আলেয়া হান্ডে ঈশ্বর আয়ায়্য় আত্মা তে ইনাকু সদর তাৎআয়, চিয়া চি রিলামালা আত্মা দঅ যত বাবদ কু সমেত ঈশ্বর রাঃআ গাহির বাবদ কু হঅ তুনুম নামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","চিয়া চি মান্মি রাঃআ ভাবনা মান্মি কু রাঃআ আত্মারাআ বিনা অক্য়্কু সারিয়া? ইনে এন্কাগে ঈশ্বর রাঃআ আত্মা বিনা ঈশ্বর রাআ ভাবনা যাহায় কাকু সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","মেন্খান আলে দঅ ধার্তি রাঃআ আত্মা কে দঅ কালে ঞাম তিৎআ, বরং ঈশ্বর হাতেৎ উডুঙয়াকান আত্মাকেলে ঞাম তিইয়া, যাতে আলে আটকার দাড়ি কাঃআ লে অকা ঈশ্বর আলে কে দায়া-দুলাড় লঅ এমা তাৎলেআয়। ");
INSERT INTO cdz_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","নিয়া যত বার্তা আলে জাগারেতানা, নিয়া বার্তা মান্মি রাআ চেদাকান আকেল তে দঅ লহয়, মেন্খান রিলামালা আত্মা রাআ চেদাকান জাগার তে, আত্মা রাআ চেদা কান থুতি তে আত্মিক সার্তি টাকে বুঝাই তানালে। ");
INSERT INTO cdz_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","মেন্খান জাগতিক মান্মি ঈশ্বর রাঃআ আত্মা রাঃআ বিষয় কায় গ্রহনেয়া, চিয়া চি ইনিরাআ হান্ডে ইনাকু যত মুর্খতা লেকা; হেৎদ ইনা কু যত ইনি কায় সারি নামেয়ায়, কারন ইনা কু আত্মিক লেকাতে পরীক্ষা আয়। ");
INSERT INTO cdz_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","মেন্খান অকয় আত্মিক, ইনি দঅ যতয়া বাবদ রাঃআ পরীক্ষা আয়, মেন্খান এটা যাহায় ইনি রাঃআ পরীক্ষা কাকু দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","চিয়া চি 'অকয় প্রভু রাঃআ মন সারিতাত্যায়্য়, ইনিকে উপদেশ এম দারিয়ায়্য়? মেন্খান নিয়া সারি নাম তাৎআবু চিল্কা খ্রিস্ট ভাবা আয় এনকা আবু ভাবায় কাঃআবু। ");
INSERT INTO cdz_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","হেৎদ, এ ব্কঞ তুকু হেৎদ মিশি তুকু, ইঞ আপেকে আত্মিক মান্মি লেকা জাগার কাঞ গামা তাৎপেয়া, মেন্খান জাগতিক হড় কু লেকা, খ্রীস্ট রে পাতিয়া আকান হন কুরাঃআ লেকা জাগারে তানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ইঞ আপেকে তয়া নুউ তুকা লাৎ পেয়া, ম্যাডী কাঞ জম তুকা তাৎ পেয়া, চিয়াঃ চি ইন্তং আপেয়া দাড়ি কা হয়ুয়া কানা, এমনকি, নাহা আ হঅ আপেয়া দাড়ি বাআয়না। ");
INSERT INTO cdz_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","চিয়া চি নাহা আ আপে জাগতিক হড় লেকা মেনা আ পেয়া; বাস্তবিক চিন্তং আপেয়া তালারে ঈর্ষা হেৎদ বিবাদ মেনা আ গেয়া, ইন্তং আপেদ চি জাগতিক হড় ল্হয় তানাপে, হেৎদ মান্মি কু রাঃআ আরি চালি লেকা দ্চি কাপে সেসেন তানা? ");
INSERT INTO cdz_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","চিয়াঃ চি চিন্তং আপেয়া তালারে মিৎ হড় গামেয়ায় \"ইঞ পৌল কে মানায়াঞ, হেৎদ অটঃ মিৎ হড়, ইঞ দঅ আপল্ল কে মানায়াঞ, ইন্তং আপেদ্চি মান্মি সুমুং ল্হয়? ");
INSERT INTO cdz_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","বেশ, আপল্ল দঅ অকয়? হেৎদ পৌলদ অকয়? ইন্কিন মা ত পরিচারক মাত্র, অকয় লিয়া আপে পাতিয়ান হড় পে হয়ুয়া কানা; হেৎদ মিমিৎ হড়কে প্রভু চিল্কা এমা তাৎ কিনায়। ");
INSERT INTO cdz_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ইঞ রহা কেৎআ, আপল্ল দাঃ আ দুল কেৎ আয়, মেন্খান ঈশ্বর হারা বুরু কেৎআয়্য়। ");
INSERT INTO cdz_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","তাহলে রহাইচ দ জাহিনিচ ল্হয়, দুলিইচ হঅ জাহিনিচ ল্হয়, হারা বুরুইচ ঈশ্বর দাতা গে সার। ");
INSERT INTO cdz_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","হেৎদ রহাইচ হেৎদ দুলিইচ বানার হড় রাআ দিশা মিয়াৎ গে, মেন্খান অকয় রাঃআ চিল্কা শ্রম, ইনি এনেঙ্কা আয়ায়্য় কাউডি নামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","চিয়া চি আলে ঈশ্বর রাঃআ গে গাতি কামিয়ান হড়; আপে ঈশ্বর রাঃআ গে বাইদ, ঈশ্বর রাঃআ গে অড়া তানাপে। ");
INSERT INTO cdz_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ঈশ্বর রাঃআ অকা অনুগ্রহ দান ইঞ কে এম হয়ুয়া কানা, ইনালেকাগে ইঞ আকিলান গাত্নি বাইয়ান হড় লেকা ভিত্তি বুটা বানা তাৎআঞ; হেৎদ ইনা রাঃআ চেনাং রে এটা হড় কু হঅ গাত্নি তানা; মেন্খান যত হড় সতর্ক আকু, চিল্কা লেকা ইনি ইনা রাঃআ চেতাং রে গাত্নিআয়। ");
INSERT INTO cdz_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","চিয়াঃ চি অকা স্থাপন হয়ুয়া কানা, ইনা বিনা এটা ভিত্তি বুটা যাহায় কাকু স্থাপন দাড়িয়া তাৎআ, ইনি দঅ যীশু খ্রীস্ট। ");
INSERT INTO cdz_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","মেন্খান নিয়া ভিত্তি বুটা রাঃআ চেতাং রে সনা, রুপা, গাদা দামী ধিরি, কাট, বুসু, ঘাসাড় লিয়া যদি যাহায় কু গাত্নিয়া, এন্খান যত হড় কু রাঃআ কামী সদর আ। ");
INSERT INTO cdz_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","কারন ইনা হুলাং গে ঞেলয়া, চিয়া চি ইনা হুলাং রাঃআ সদর সেঙ্গেল তেগে হ্যুয়ায়; হেৎদ জ্ত্চ রাঃআ কর্ম চিল্কা লেকা, ইনা সিঙ্গেল গে বিডা য়ায়্য়; ");
INSERT INTO cdz_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","অক্য়য় অকা গাত্নি তাত্যায়, হানি রাঃআ ইনা কর্ম যদি স্থির তাহিনা, এন্খান হানিদ কাউদী নামেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","অকয় রাঃআ কর্ম আতার আ, হানি দ ক্ষতিরে তাহিনায়, মেন্খান হানিদ আয়ায়্য় পরিত্রান নামেয়ায়। এনেখান্গে নিয়া লেকা নামেয়ায়, চিল্কা সিঙ্গেল তালাতে জিত্কার হ্যুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","আপে দ চি কাপে সারিয়া, আপেদ ঈশ্বর রাঃআ মুন্দির, হেৎদ ঈশ্বর রাঃআ আত্মা আপেয়া অন্তরে বাসা কানায়? ");
INSERT INTO cdz_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","যদি যাহায় ঈশ্বর রাঃআ মুন্দির নষ্ট ইয়াকু, ইন্খান ঈশ্বর ইনিকে নষ্ট ইয়ায়্য়, চিয়াঃ চি ঈশ্বর রাঃআ মুন্দির রীলামালান, হেৎদ আপেগে ইনা মুন্দির। ");
INSERT INTO cdz_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","যাহায় আপনারকে আলয় ঠেকাই কাঃআয়, আপেয়া তালারে যাহায় যদি আপনারকে নিয়া যুগরে আকিলান মেন্তে মনেয়ায়, এন্খান ইনিদ আকিলানআয় মেন্তে মুর্ক কাতে তাহীন কাঃ আয়। ");
INSERT INTO cdz_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","যেহেতু নিয়া জগত রাঃআ অকা আকেল, ইনাদ ঈশ্বর রাঃআ হান্ডে মুর্ক। কারন রিলামালা শাস্ত্র রে অল মেনা আ 'ইনিদ আকিলান হড়কুকে ইন্কুয়া চালাকিতে স্যাপকুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","অটঃ হঅ গে 'প্রভু আকিলান কু রাঃআ বাক ঝৌড়ি সারিয়ায়্য় যে, ইনা যত অসার। ");
INSERT INTO cdz_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ইন্খান যাহায় মান্মি কুকে আলকু শ্লাঘা কুকা আ। চিয়া চি যতয়্যা গে আপেয়া; ");
INSERT INTO cdz_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","পৌল, চি আপৌল্লো, চি কৈফা, চি জগত, চি জীবন, চি মরণ, চি মেনা আ বিষয়কু, চি হাপেন হুলাং কু রাঃআ বিষয়, যতয়্যা গে আপেয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","হেৎদ আপে দ খ্রীস্ট রাঃআ হেৎদ খ্রীস্ট দ ঈশ্বর রাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","হড়কু আবুকে নিয়া লেকা কু মনেৎ বুয়াআ যে, আবুদ খ্রীস্ট রাঃআ সেবক হেৎদ ঈশ্বর রাঃআ উকুয়াকান বাবদ কুরাঃআ কটাল অকয় কু রাঃআ চেতাং রে নেল আতেন রাঃআ জেমি দারি এমা কানা। ");
INSERT INTO cdz_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","হেৎদ নেথাং রে কটাল গংকে রাঃআ নিয়া গুণ হুয়ু লাক্তি, ইন্খান ইনিকে পাতিয়ানিচ লেকা ঞেল কাআয়। ");
INSERT INTO cdz_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","মেন্খান আপে লিয়া বাংখান যাহায় মান্মি রাঃআ বিচার আখড়া রে অকা ইঞাঃআ বিচার হ্যুয়ায়্য়, নিয়াদ ইঞাঃআ মতে ইতিচ তরাং রাঃআ বেপার; ইন্খান, ইঞ ইঞাঃআ হঅ কাঞ বিচারেয়া। ");
INSERT INTO cdz_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","চিয়া চি ইঞ ইঞাঃআ বাব্ত্তে যাহানা কাঞ সারিয়া, তুবুই রহঅ ইঞ বিন্দায়ী মেন্তে কাঞ প্রমাণ তানা; মেন্খান অকয় ইঞাঃআ বিচারেআয়, ইনি প্রভু (দুরাং. 19:12) ");
INSERT INTO cdz_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","এন্খান আপে অক্ত রাঃআ মাড়াং তে, অকা অব্দি প্রভু কায় হিজুয়ায়্য়, এনা অব্দি যাহান বিচার আল্পে করায়া; ইনি গে লুম্বারে উকুয়া কানা যতচআয়্য় মার্সালতে সদরেয়ায়্য়, হেৎদ রিদয় রাঃআ যত মন্ত্রনা সদরেয়ায়্য়; হেৎদ ইনা হুলাং যত হড় ঈশ্বর রাঃআ হান্ডে হাতেৎ আপান আপিন সাবাসিকু নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","এ ব্কঞ হেৎদ মিশিঞ তুকু, ইঞ ইঞাঃআ হেৎদ আপল্লো রাঃআ উপমা লিয়া আপেয়া নাতিনাং নিয়া যত জাগারিঞ গাম কেৎআঞ; যেন আলে লিয়া আপে নিয়া চেচেদাঃ নামেপে চি, অকাকু শাস্ত্র রে অল মেনাআ, ইনাকু তাড়ম পারম কাঃআ বেসা, আপে যাহায় যেন মিৎ হড় রাঃআ পক্ষে এটা হড় রাঃআ বিপক্ষে আল্পে গর্ব্ব য়াআয়্য়। ");
INSERT INTO cdz_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","চিয়া চি অকয় আপেয়া তালারে পক্ষপাতিত্ব সির্জন তাৎআয়? হেৎদ অকা কাম নামতাৎআ, এনেইঙ্কা না আ আমাঃ আ কিনা আ মেনা আ? হেৎদ চিন্তং ঞাম তাৎআম; ইন্তং যেন কাম ঞাম তাৎ আ, নিয়া লেকা চিয়া মনে কাতেন গর্ব্বয় তানাম? ");
INSERT INTO cdz_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","আপে নাহা আ পেরেচা কানাপে! নাহা আ কিসাড়া কানাপে! আলেয়া বিনা রাজত্ব নাম তাৎ আ পে! হেৎদ রাজত্ব নাম লেখান্পে বেশ কআপে হুনাং, আপে লঅ আলে হঅ রাজত্ব নাম্কেয়ালে হুনাং। ");
INSERT INTO cdz_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","চিয়াচি ইঞাঃআ মনে লেকা তেদ, কুলিচ কু যে আলে, ঈশ্বর আলেকে গজঃঅ রাআ সাজা নামাকান হড়কু লেকা মিছিল রাঃআ মুচাদিজ মেন্তে উদু নাতিনাং দঃহ তাৎলেআয়; চিয়া চি আলে দ ধার্তি রাঃআ হেৎদ নাঙ্গা কু রাঃআ অটঃহঅ মান্মি কু রাঃআ হান্ডে কুকলী রাঃআ জিনিস হুইয়াকানালে। ");
INSERT INTO cdz_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","আলে খ্রীস্ট নাতিনাং মুর্খ, মেন্খান আপেদ খ্রীস্ট হতেত্তে বুদ্ধিজিবি! আলেদ নিজুরি, মেন্খান আপেদ দাড়িয়ান হড়; আপেদ গৌরবান হড়, মেন্খান আলেদ হেয়ালি হড়। ");
INSERT INTO cdz_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","নাহা আ রাঃআ নিয়া অব্দি আলেদ রেঙ্গেচাকান, তেতাংয়াকান হেৎদ বিন কিচি সিনিব গেয়ালে, হেৎদ তিহিতে ভুকুড়া কাতে ঘায়েলা কানালে, হেৎদ বরবর রেলে মেনা আ লেয়া অড়া দুয়ার বাআয়না তালেয়া; ");
INSERT INTO cdz_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","হেৎদ নিজ তিহিতে কামী কাতে কুঠিন খাটাতানালে; নিন্দা নাম নামতে আশিষা কু তানালে, তাড়না নাম নামতে সাহাৎ আলে, ");
INSERT INTO cdz_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","বদনাম নাম নামতে বিনয়া কু তানালে; তিহিং অব্দি আলে ইহুদি কু যেন ধার্তি রিঙ্কূ আবর্জনা, যত বিষয় নাতিনাং জঞ্জাল হুই কাতে মেনা লেয়া। ");
INSERT INTO cdz_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ইঞ আপেকে গিয়ু এম নাতিনাং দঅ ল্হয়, মেন্খান ইঞাঃআ প্রিয় হন মেন্তে আপেকে চেতনা এম নাতিনাং নিয়া যত অলাপে তানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","চিয়া চি যদিও খ্রীস্টতে আপেয়া গেলেজুলু চেচেদিজ কু তাহিনা, ইন্খান আপু দঅ গাদা লেকা ল্হয়; চিয়া চি খ্রীস্ট যীশু রে বুগিন বার্তা লিয়া ইঞগে আপেকে জানাম তাৎ পেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ইন্খান আপেয়া হান্ডে নেহর, আপে ইঞাঃ সুতু হড় হ্যুইওপে। ");
INSERT INTO cdz_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","নিয়া নাতিনাং ইঞ থিম্তিকে আপেয়া হান্ডে কুল্তিঃআঞ; ইনি দ প্রভুতে ইঞাঃআ প্রিয় হেৎদ পাতিয়ানিচ হন; ইনি আপেকে খ্রীস্ট যীশু রাঃআ বাব্ত্তে ইঞাঃআ হরা দিশা যত পাহামাপেয়ায়, অকাকু ইঞ যত ঠাওরে যত মন্ডলীরে চেচেদা আ এম আগু তাৎআঞ। ");
INSERT INTO cdz_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ইঞ আপেয়া হান্ডে কাঞ হিজুয়া মেন্তে আপে কথক হড় গরবা কানাপে। ");
INSERT INTO cdz_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","মেন্খান যদি প্রভু মনেয়ায়, ইন্খান ইঞ ঘিড় মেন্তাংগে আপেয়া হান্ডেঞ হিজুয়া, হেৎদ অক্য়্কু গ্র্বাকান্দুকু, ইঙ্কূয়া জাগার দঅ লহয়, মেন্খান ইঙ্কূয়া ঈশ্বর চিন্তি দাড়িয়ানিচ মেন্তেগে সারি কাঞ। ");
INSERT INTO cdz_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","চিয়া চি ঈশ্বর রাঃআ পরগনাদ জাগার তেদঅ ল্হয়, মেন্খান ঈশ্বর রাআ দাড়িয়ান্তে। ");
INSERT INTO cdz_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","আপেয়া আ ইচ্ছা কিনা আ? ইঞ দ চি সাজা এম নাতিনাং হাপা স্যাপ কাতে আপেয়া হান্ডেঞ সেনা? চি দুলাড় হেৎদ মুলুচ মচা সাপা আত্মা তেঞ সেনা ? ");
INSERT INTO cdz_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","সার্তি গে আয়ুমঅ তানা যে আপে কু তালারে হড়মালটম মেনা আ, হেৎদ নেকান হড়মালটম, অকা এটা জাতিকুরে হঅ বাঃআয় না, নেকানাঃআ চি আপেয়া তালারে হঅ হড়কু হড়মালটম নাতিনাং বুল চাবা কানাকু (নেকানাঃআ চি আপেয়া তালারে মিহুড় আয়া বাআ তেৎ রাআ এরা/হিরুম মাইতেৎ লঅ সম্পর্ক দঃহঅ তাৎআয়) ");
INSERT INTO cdz_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","অটঃহঅ আপে নিয়া বাবত্তে গর্ব অ তানাপে, বরং চিয়া আ কাপে রদন লাৎআ, যাতে ইনিকে আপেয়া সমাজ হাতেৎ কুদা গিডি হ্যুয়কাআ, অকয় হড় নেকান কামী তাত্যায় মেন্তে! ");
INSERT INTO cdz_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ইঞ, হড়মতে কাঞ তাহিলেন্খান চিকেয় না আত্মা তে তাহি কাতে, অকয় হড় নেকান কামী তাত্যায়্, তাহিয়ান হড় লেকা ইনি রাঃআ বিচার তাৎআঞ; ");
INSERT INTO cdz_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","আবুয়া প্রভু যীশু রাঃআ ঞুতুম তে আপেয়া আ হেৎদ ইঞা আ আত্মা মিৎ ঠাঁওরে তাহিলেন খান, ");
INSERT INTO cdz_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","আবুয়া প্রভু যীশু রাঃআ দাড়িয়ান লঅ ইনি লেকান হড়কে হড়মো নাসা নাতিনাং বঙ্গা রাঃআ তিহিরে এম উচাড় হ্যুয়া, যাতে প্রভু যিশু রাঃআ মাহারে ইনিরাআ আত্মা পরিত্রান নামে কাঃয়ায়্য। ");
INSERT INTO cdz_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","আপেয়া শ্লাঘা করা বেশ ল্হয়তানা। আপে দ্চি কাপে সারিয়া, ইতিচ তরাং তাড়ী রস গটা সুজি থাড়ি তাড়ি রসতে গাবা চাবাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","মারি তাড়ি রাসি বাহার দুল গিডি কাতে আপনার কুকে শুচিকূপে; যাতে আপে নামা তাল লেকাপে হ্যুয়ায়্য়, আপে মাত তাড়ীবিহীন তানাপে, চিয়াচি আবুয়া সাকরাৎ পরব রাঃআ ভিডিদ বুলি দাড়ি সামাং হুয়ুয়া কানায়, ইনিদ খ্রীস্ট। ");
INSERT INTO cdz_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ইন্খান হিজুপে, আবুদ মারি তাড়ি তেদ ল্হয়, হিংসা হেৎদ দুষ্টুমি রাঃআ তাড়ি দ ল্হয়, মেন্খান উদার তে হেৎদ সার্তিমন ভাবতে তাড়িবিনা পিঠা তে পরব বু মানায়ায়। ");
INSERT INTO cdz_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ইঞ ইঞাঃআ গিরা রে আপেকে নেকা অলালাৎ পেয়াঞ, হড়মালটমিচ কু লঅ জাহান সাগাই আল্পে দহ য়াআয়্য়; ");
INSERT INTO cdz_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","নিয়া ধার্তি রিঙ্কূ হড়মালটমিচ, চি লোভি, চি এটা হড় রাঃআ সম্পদ হাতা রাঃআ ইচ্ছা হড়কু, চি ধিরি হাসা রিঙ্কূ বানা ঠাকুরকে দেবা সেবা হড়কু লঅ ভিড়া হাতেৎ গাদা সাঙ্গীঙ রে তাহীন হ্যুয়ায়ায়্, এঙ্কা দ ল্হয়, চিয়া চি ইনেইন্কা করা লেনখান ধার্তি হাতেৎ বাহারতে সেন আপেয়ায়্য় লাক্তি হুয়ু দাড়ীয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","মেন্খান নাহা আ আপেকে অলাপে তানাঞ যে, পাতিয়ানিচ হাগা হুইকাতে যাহায় হড় যদি, হড়মালটমিচ, চি লোভি, চি ঠাকুর দেবা সেবায়ইচ, চি কু-জাগারিচ, চি বুলিচ, চি এটা হড় রাঃআ দৌলত লুটিচ হ্যুয়আ, এনেখান্ ইনি হড় লঅ সাগাইরে আলপে তাহিনা, এঙ্কান হড় লঅ হঅ আলপে জম নুয়া। ");
INSERT INTO cdz_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","চিয়াঃচি বাহার রিঙ্কূ হড়কু রাঃআ দরবার রে ইঞাঃআ কিনাআ ফায়দা হ্যুয়আ? আপে দ চি মন্ডলী ভীতির রিঙ্কূ কু হড় রাঃআ কাপে দরবার রাঃআ? ");
INSERT INTO cdz_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","মেন্খান ঈশ্বর দরবারে আয় বাহার হড়কু রাঃআ। আপে আপেয়া তালা হাতেৎ ইনি দুষ্টু হড়কে উডুং গিডিইপে। ");
INSERT INTO cdz_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","আপেয়া তালা কুরাআ হাতেৎ যাহায় রাঃআ সাহস মেনা আ চি, এটা মিহুড় পাতিয়ানিচ্ হড় রাঃআ বিরূদ রে জাহান নালিস তাহি লেন্খান হানি রাঃআ দরবার রীলামালা হড় কু রাঃআ হান্ডে কাঃআ ইদি কাতে অধার্মিক হড় কু রাঃআ হান্ডে ইদিয়াকু? ");
INSERT INTO cdz_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","আপে চি কাপে সারিয়াপে যে, ঈশ্বর রাঃআ রীলামালা হড় কু ধার্তি রাঃআ কু দরবারেয়া? অটঃহঅ ধার্তি রাঃআ দরবার যদি আপেকে লিয়া হ্যুয়আ, এন্খান আপে চি সাধারণ বাব্ত্ত কু রাঃআ দরবার তে জ্গ্য় ল্হয়? ");
INSERT INTO cdz_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","আপে দ্চি কাপে সারিয়া যে, আবু সরগ নাঙ্গা কু রাঃআ বু দরবারেয়া? এনা নাতিনাং নিয়া জীউ রাঃআ বাবত মাআ আল্গা গেয়া। ");
INSERT INTO cdz_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ইনাখান আপে লিয়া যদি নিয়া জীউ রাঃআ বাব্ত্তে দরবার হ্যুয়আ, ইন্খান মন্ডলীরে অকয় কুরাঃআ বাব্ত্তে লেখা লেকানা জাহানা আ বাআয়না, ইঙ্কূ কেগে দ চিয়া আ দরবার রেপে দুবেৎ কুয়া? ");
INSERT INTO cdz_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ইঞ আপেকে গিয়ুঃ তুকা নাতিনাং নিয়া থুতিকু জাগারেপে তানাঞ। নিয়া দ চিল্কা? আপেয়া মন্ডলী তালারে দ্চি এনে এন্কান যাহায় মিৎ হড় হঅ আকেলবান বানুঃ কুয়া যে, অকয় হাগায়া হাগায়া কিন বিবাদ লেন্খান ইন্কিনা আ নিস্পত্তি তুকা কিনায়? ");
INSERT INTO cdz_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","মেন্খান হাগায়া লঅ হাগা দরবার ঠাওরে নিপিয়া আকিন, ইনাদ অটঃহঅ কাপাতিয়ান হড় কু রাঃআ হান্ডে। ");
INSERT INTO cdz_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","আপেমাত আপন আপিন রাঃআ দরবারপে আসি তানা, ইনাতে আপেয়া আ গে গাদা ক্ষতি হ্য়ুয়অ তানা। বরং অন্যায় চিয়া আ কাপে সাহাঃৎআ? বরং চিয়া আ কাপে বঞ্চিত তানা ? ");
INSERT INTO cdz_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","মেন্খান আপেগেপে অন্যায় এৎআ, ঠেকাৎ কুয়াপে, হেঁঃএ নিয়াদ পাতিয়ান হাগা কু লঅ গেপে করাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","বাংখান আপে দ্চি কাপে সারিয়া যে, অধার্মিক কুদ ঈশ্বর রাঃআ পরগনা রে আইদারি কাকু নামেয়া? আল্পে ভ্রান্তঃআ, অকয় কু ছিনারী চি, ঠাকুর দেবা সেবায়ইচ চি, বিলাসিতা চি, রান্ডিবাজ চি, পরকিয়া চি, কুঠিয়া চি, ");
INSERT INTO cdz_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","কুমড়ু চি, লোভী চি, মাতাল চি, কুটুজাগারিচ চি, লুটারী চি, ইঙ্কূদ ঈশ্বর রাঃআ পরগনারে আইদারি কাকু নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","হেৎদ আপে তালারে হঃঅ কথক এনে এন্কান হড় পে তাহিলেনা; মেন্খান আপে প্রভু যিশু খ্রীস্ট রাঃআ নুতুমতে হেৎদ আবুয়া আ ঈশ্বর রাঃআ আত্মাতে আপে জ্ত্চ্ আবুং সাপা কানাপে, রীলামালান কানাপে, ধার্মিক মেন্তে পে লেখা কানা। ");
INSERT INTO cdz_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","জ্ত্যাআঃ গে ইঞাঃআ করনীয়, মেন্খান জ্ত্যাআঃ গে ইঞাঃআ হিত রাআ নাতিনাং, এংকা দ ল্হয়; জ্ত্যাআঃ গে ইঞাঃআ করনীয়, মেন্খান ইঞ জাহানা আ তেগে ভরসা কাতে কাঞ সেসেনাঞ। ");
INSERT INTO cdz_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","আপেয়া তালারে কথক পে গামেয়া \"জমা নুউয়া লাহিচ্ নাতিনাং হেৎদ লাহিচ্ নাতিনাং জমা নুউয়া, মেন্খান ঈশ্বর বারানা আ গে লুপ্ত য়াআয়্য়। চিয়াচি হড়ম অ দঅ হড়মালটম নাতিনাং দ ল্হয়, মেন্খান প্রভু রাঃআ নাতিনাং, হেৎদ প্রভু দঅ হড়ম অ রাঃআ নেল আতেন নাতিনাং। ");
INSERT INTO cdz_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","হেৎদ ঈশ্বর আয়ায়্য় নিজ দাড়িয়ান্তে প্রভুকে জিউত বিরিৎ লিয়ায়্য়, আবু কে হঅ বিরিৎ বুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","আপেদ্চি কাপে সারিয়া? আপেয়াআ হড় ম খ্রীস্ট রাঃআ অঙ্গ? এন্খান ইঞ দ্চি খ্রীস্ট রাঃআ অঙ্গ হুই কাতে রহঅ ছিনারী রাঃআ অঙ্গ কাতেঞ দহ্যয়আ? এঙ্কা দ সাঙ্গিংরে তাহিন্কাঃ আ। ");
INSERT INTO cdz_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","বাংখান আপেদ্চি কাপে সারিয়া? অকয় হড় হড়মালটমরে তাহিনায়, ইনি হানি লঅ মিয়াৎ হড় মঅ কিন হ্যুয়াআ, কারন শাস্ত্ররে অল মেনাআ \"ইন্কিন বার হড় মিয়াৎ হড় ম কিন হ্যুয়াআ। ");
INSERT INTO cdz_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","মেন্খান অকয় হড় প্রভুরা ভরসা রে তাহিনায়, ইনি দ হানি লঅ মিয়াৎ আত্মা কিন হ্যুয়আ। ");
INSERT INTO cdz_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","আপে হড়মালটম হাতেৎ সাসঙ্গিনরে তাহিনঃ পে। মান্মি এটা জাহানা য় কাই লেখানে য়, ইনা ইনি রাঃআ হড় ম রাঃআ বাহার রে, মেন্খান অকয় হড়মালটম য়ায়্য় ইনিদ আয়ায়্য় নিজ হড় ম রাঃআ বিরুধরে কাই য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","বাংখান আপেদ চি সারিয়া পে, আপেয়ায় হড় ম রীলামালা আত্মা রাঃআ মুন্দির তানা, অকয় আপেয়ায়্য় অন্তরে তাহিনায়, অকইকে আপে ঈশ্বর রাঃআ হান্ডে হাতেৎ নাম তিৎয়াপে? ");
INSERT INTO cdz_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","হেৎদ আপেদ আপেয়া ল্হয়, কারণ মূল্য লিয়া কিরিং তুকা কানাপে। এন্খান আপেয়ায় হড় ম তে ঈশ্বর রাঃআ গৌনমানতেপে। ");
INSERT INTO cdz_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","অটঃহঅ আপে অকা যত থুতিপে ইঞকে অল লিৎঞাআ, ইনা বাব্ত্তে ইঞা নিয়া তেলা রুয়াড় তানা, যাহায় কুড়ি হন কুকে কাঃআ জুটেত কড়া হন কু রাঃআ ভালাই; ");
INSERT INTO cdz_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","মেন্খান হড়মালটম হাতেৎ বাঁঞ্চা নাতিনাং মিমিৎ কড়া হন কুরাঃআ আপনার এরাবাহুকু তাহীন কা আ, হেৎদ মিমিৎ এরা কু রাঃআ আপনার হেরেল কু তাহীন কা আ, ");
INSERT INTO cdz_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","হেরেল আয়া আ এরাকে প্রাপ্য় এমাই কা আয়; এনে ইঙ্কা লেকাগে এরা হঅ হেরেল কে প্রাপ্য় এমাই কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","এরাদ আয়া আ নিজ হড় ম চেতান রে আইদারি বায়া আ না, মেন্খান আয়া হেরেল রাঃআ মেনা আ; এনে ইঙ্কা লেকাগে নিজ হড় ম চেতাং রে হেরেল রাঃআ আইদারি বায়া আ না, মেন্খান আয়া এরা রাঃআ মেনা আ; ");
INSERT INTO cdz_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","আবেন আপান আপিন আলবেন ভেগার রে তাহিনোয়া; শুধু বিন্তি নাতিনাং ঝিরা-বসং ঞাম নাতিনাং বার হড় মিশাতে দুপ কাতে থুতি জাগার কাতে বারসিঙ লেকা ভেগার রে বেন তাহি দাড়ি য়া আ; ইনা তায়্ম অটঃহঅগে মিৎ থাংরেবেন তাহিনা, যাতে শয়তান আবেনা আ অসংযমতা রাঃআ নাতিনাং আবেনকে বিডারে আলয় নুর বেন কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","মেন্খান ইঞ দ আবেনকে হুকুম লেকাতেদ ল্হয়, মেন্খান অনুমতি লেকাতে নিয়াকু গামা বেন তানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","হেৎদ ইঞাঃআ ইচ্ছা নিয়া তানা, যত মান্মিকুগে ইঞ লেকা ডাঙ্গুয়া তাহীনঃঅ কাঃআকু; মেন্খান যত মান্মি ঈশ্বর রাঃআ হান্ডে হাতেৎ আপান আপিন দায়া দুলাড় ঞাম তাৎ আ কু, মিমিৎ হড় মিমিৎ লেকানা আ, এটা এটা হড় এটা লেকানা আ। ");
INSERT INTO cdz_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","নাহাআ ডাঙ্গুয়া হড়কু রাঃআ হেৎদ রাঁন্ডি হড়কু রাঃআ হান্ডে ইঞাঃআ নিয়া থুতি, ইঙ্কূ যদি ইঞ লেকা তাহি দাড়িইয়াকু, এন্খান আকুয়াআ আ নাতিনাং ইনাগে বেশা আ; ");
INSERT INTO cdz_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","মেন্খান ইঙ্কূ যদি আকুয়াআ আ হড় ম কাকু কবজ দাড়িয়া আ, এন্খান গঙ্গঅ দুতামঅ কা আ কু; চিয়া আ চি সিঙ্গেল রে মগদ মগদ জুল হাতেৎ গঙ্গ দুতামঅ গাদা বেশা। ");
INSERT INTO cdz_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","অটঃঅ হঅগে গঙ্গঅ দুতাম হড় কুকেঞ হুকুমা পে তানা ইঞ, ইঞ গামাপে তানা ইঞ আঙ্কাদ ল্হয়, মেন্খান প্রভুগেয় গামাপে তানায়, এরা দঅ হেরেল কে বাগী কাতে আলয় সেনঃঅ কাআয়, ");
INSERT INTO cdz_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","যদি সেনঃগেয়ায়্য়, এন্খান আলয় গংঅঃ কা আয়, বাংখান হেরেল লঅ মিশাতে কিন তাহীন কা আ, হেৎদ হেরেল হঅ এরা কে আলয় ছাডুই ঈকা আয়। ");
INSERT INTO cdz_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","মেন্খান যত হড় কেঞ গামাপে তানা, প্রভু দ ল্হয়; যদি যাহায় পাতিয়ান হাগা রাঃআ অপাতিয়ান এরা মেনা ইয়া, হেৎদ ইনি কুড়ি হন ইনি লঅ তাহি নাতিনাং রাজি মেনাই আ, এন্খান ইনি হানিকে আলয় বাগিই কা আয়; ");
INSERT INTO cdz_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","অটঃহঅগে অকয় পাতিয়ান এরা রাঃআ অপাতিয়ান হেরেল মেনা ইয়া, হেৎদ ইনি কড়া হন যদি হানি লঅ তাহীন নাতিনাং রাজি মেনাই আ, এন্খান ইনিদ হেরেল কে আলয় বাগী কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","চিয়া চি অপাতিয়ান হেরেল হানি এরা তে রিলামালা কানায়, অটঃহঅ অপাতিয়ান এরা হানি হেরেল তে রিলামালা কানায়; ইনা কাঃআ হুই লেনখান আপেয়া হন হপন কু অরীলামালা হুই কঃআকু হুনাং, মেন্খান বাস্তবরেদ ইঙ্কূ রীলামালান। ");
INSERT INTO cdz_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","তুবু রহঅ অপাতিয়ান হেরেল বাংখান এরা কু সেনঃঅ খানঃঅ কু সেন কা আ কু; নেকানাআরে ইনি পাতিয়ান হাগা দ চি হানি মিসি আকিনা একরার রে আটক বানু কিনা, মেন্খান ঈশ্বর আবুকে সুলুকতে বাঞ্চাকাতে তাহি নাতিনাং গে রাঃআ তাৎ বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","কারণ, এ এরা কুড়ি হন, আম চিল্কাতে সারি ঞামেয়াম যে, আমাঃ আ হেরেল কে আম পরিত্রানিয়াম চি ল্হয় ? বাংখান এ কড়া হন, আম চিল্কাতে সারি ঞামেয়াম যে, আমাঃ আ এরাকে আম পরিত্রানিয়াম চি ল্হয়? ");
INSERT INTO cdz_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","শুধু প্রভু অক্য়য়কে চিল্কা অংশ এমা তিৎআয়, ঈশ্বর অক্য়য়কে চিল্কা কাতেৎ রাঃআ তিৎ আয়, ইনিদ এঙ্কাগে সেসেন কা আয়। হেৎদ নেএ নেকান হুকুম যত মন্ডলীরে এমে তানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","যাহায় দ চি সুনু চুটি গেত কাতে রাঃআ তুকা কানা পে? এন্খান ইনিদ গেতাকান সুনু চুটি আল্য়য় মেটায় কা আ। যাহায় চি সুনু চুটি কাঃআ গেত লেকাতে রাঃআ তুকা কানা পে? এন্খান ইনিদ সুনু চুটি আল্য়য় গেতে কাঃআয়, ");
INSERT INTO cdz_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","চুটি গেত জাহানা আ ল্হয়, চুটি কাঃআ গেত হঅ জাহানা ল্হয়, মেন্খান ঈশ্বর রাঃআ হুকুম গুনান মানানগে সার। ");
INSERT INTO cdz_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","যিশু খ্রিষ্ট রে পাতিয়া বাত্রাং অকা হড়কে অকা দশা রে রাঃআ তুকা কানায়, ইনিদ ইঙ্কা দশা রেগে তাহীন কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","আম্ দ্চি মুনিশ লেকাতেম রাঃআ তুকা কানাম? আলম ভাব্নায়া; মেন্খান যদি আল্গা সাল্গা হুই দাড়িয়াম, ইনা আল্গা সাল্গা আলম আড়া গিডিয়াম, বরং ইঙ্কা না আ গে করাম। ");
INSERT INTO cdz_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","চিয়া চি প্রভুতে রাঃআ তুকা কানায় অকয় মুনিশ, ইনিদ প্রভু রাঃআ আল্গা সাল্গা হড় তানায়; এন্কাগে আল্গা সাল্গা রারাঃআন অকয় হড়, ইনিদ খ্রীস্ট রাঃআ মুনিশ তানায়। ");
INSERT INTO cdz_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ঈশ্বর, যিশু খ্রিষ্ট রাআ লিয়া বিশেষ মূল্য এমাকাতে আপেদ কিরিং তুকা কানাপে, যাহান মান্মি কু রাঃআ মুনিশ দ আল্পে হুইয়আ। ");
INSERT INTO cdz_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","এ ব্কঞ হেৎদ মিশিঞ তুকু, আপে যত হড় অকা অবস্থাতে রাঃআ তুকা কানাপে, ইনি ইনা অবস্থারে গে ঈশ্বর রাঃআ হান্ডে তাহীন কাআয়। ");
INSERT INTO cdz_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","হেৎদ ডাংগুয়া কুড়ি হন কু রাঃআ বাব্ত্তে প্রভু রাঃআ জাহান আজ্ঞা ইঞ কাঞ ঞাম তাৎ আ, মেন্খান বিশ্বস্ত হুই নাতিনাং প্রভু রাঃআ দায়াহান মান্মি লেকা ইঞাঃআ মতামত সদরেত্য আঞ। ");
INSERT INTO cdz_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ইনাতে ইঞাঃআ মন গামেৎআয়, বর্তমান সঙ্কট রাআ নাতিনাং নিয়াটা বেশা, অর্থাৎ মান্মিকুকে ইঙ্কা গে তাহীনটা বেশা। ");
INSERT INTO cdz_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","এরা লঅ আটকা কানা সম্বন্ধ টাআ আল্গা রাঃআ আলম কুরুমুটু য়া। আম দ চি ছাডুই গেয়াম? বাহু এরা নাম রাঃআ আলম কুরুমুটুয়া। ");
INSERT INTO cdz_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","মেন্খান দুতাম অম রেহ কাই কাঃআ হ্যুয়আ; অটঃহঅ ডাঙ্গুয়া কুড়ি হন যদি গঙ্গঅঃ য়াআয়্, হানি রাঃআ হঅ কাই কাআ হ্যুয়আ। এন্খান নেকান হড়কু রাঃআ হড় ম রে গাদা কষ্ট হিজুয়াআ; হেৎদ আপে নাতিনাং ইঞাঃআ মমতা হ্যুইয়তানা। ");
INSERT INTO cdz_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","মেন্খান ইঞ নিয়া থুতি গামাপেতানাঞ, ব্কঞ হেৎদ মিশিঞ তুকু, অক্ত বায়ায় না, নাহা আ হাতেৎ অকয় কু রাঃআ এরা মেনা কুয়া, ইঙ্কূ দ নেকাকু সেসেন কা আ, চিল্কা ইঙ্কূয়া আ এরা বানু কুয়া; ");
INSERT INTO cdz_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","অটঃহঅ অকয় কু রোদন তানা, ইঙ্কূ কাকু রোদন তানা লেকা; অকয় কু রৌস্কা তানা, ইঙ্কূ কাকু রৌস্কা তানা লেকা; অকয় কু কিরিঞ এৎঃআ, ইঙ্কূ জাহানা আ কাকু দহ রুয়াড় তাৎআ লেকা মনেয় কাঃআকু; ");
INSERT INTO cdz_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","অটঃহঅ অকয় কু ঘাঁরজ রাআ বিষয়বাবদ লঅ জড়িত গেয়া কু, এঙ্কা মনেয় কাঃকু, যেন ঘাঁরজ রাআ বিষয় বাবদ লঅ জড়িত বানু কুয়া; চিয়া চি নিয়া ঘাঁরজ রাঃআ অভিনয় মুচাতা কানা। ");
INSERT INTO cdz_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","মেন্খান ইঞাঃআ গাম রাঃআ দ নিয়া ইচ্ছা তানা, আপে দ চিন্তারে আল্পে তাহিনা। অকয় ডাঙ্গুয়া গেয়ায়, ইনিদ প্রভু বাব্ত্তে চিন্তা য়াআয়্, চিল্কা লেকাতে প্রভু কে খুশি তুকায়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","মেন্খান অকয় গংঅ দুতামা কানায়, ইনিদ ঘাঁরজ বাব্ত্তে চিন্তা য়াআয়্, চিল্কা লেকাতে এরাকে খুশি তুকায়ায়্য়; এন্খান্গে আয়ায়্য় চিন্তা ভাবনা রাঃআ বিভিন্নতা ঘটাআ। ");
INSERT INTO cdz_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","হেৎদ কাঃআ গঙ্গঅ হেৎদ ডাঙ্গুয়া কুড়ি হন কু দ প্রভু রাঃআ বাব্ত্তে কু চিন্তায়ায়্য়, যেন হড় ম হেৎদ আত্মাতে রীলামালান লেকা তাহি ন কাআকু; মেন্খান গঙ্গঅ এরা ঘাঁরজ বাব্ত্তে চিন্তা য়াআয়্য়, চিল্কা লেকাতে হেরেল কে খুশি তুকায়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","আপেয়া আ হিত রাঃআ নাতিনাং নিয়াঞ জাগারাপে তানাঞ; আপেয়া আ হটঃঅ রে বায়র আটক নাতিনাং দ ল্হয়, মেন্খান আপে যেন ঠিকঠাক পে তাহিন কা আ, হেৎদ মিৎ মনেতে প্রভুরাআ সেবা রে আসক্ত তাহীন কাঃআ পে। ");
INSERT INTO cdz_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","মেন্খান যাহায় রাঃআ যদি দিশা হিজু তানা চি, হানি আয়ায়্য় ডাঙ্গুয়া হনেরা তেৎ রাআ বাগদত্তা রাআ প্রতি সঠিক ব্যবস্থা কাঃআ হাতায় তানায়, যদি গংঅ রাআ উমুর পারমাকানা, হেৎদ ইনিকে গংঅ রাআ উপযুক্ত মেন্তে মনেআয়, এন্খান ইনি কিনা ইচ্ছায়া আয়, ইনাগে করায় কাআয়, ইন্তে ইনিরাআ যাহান কাই কাঃআ হুইয়াআ, ইনি গংঅ কাআয়. ");
INSERT INTO cdz_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","মেন্খান অকয় হড় হৃদয় তে স্থীর, অকয় রাঃআ জাহানা প্রয়োজন বায়ায় না, হেৎদ নিজ রাঃআ ইচ্ছা তেগেয় সেসেনায়, ইনি যদি আয়ায়্য় হনেরা তেৎকে অড়া রে ডাঙ্গুয়া তে গে দহ নাতিনাং হৃদয় তে স্থীর দহয়ায়্য়, ইনা হঅ বেশগে তানা। ");
INSERT INTO cdz_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","এন্তে অকয় আয়ায়্য় ডাঙ্গুয়া হনেরা তেৎকে গঙ্গিয়ায়, ইনি দ বেশ কামী য়ায়্য়, অটঃহঅগে অকয় কায় গঙ্গি খানঃঅয়, ইনিদ দ অটঃহ বেশ কামী য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","চিমিন মাহা হেরেল জীউত এ তাহিনায়, ইমিন মাহা এরা দ ত্লরে তাহিনায়, মেন্খান হেরেল জাপিত তাড়ম মাড়াং লেন খানেয় ইনিদ আল্গায় নায়, অক্য়য়কে ইচ্ছায়ায়্য় ইনি লঅগেয় গংঙ দাড়িয়ায়, মেন্খান ইনি হেরেল প্রভুরে গে পাতিয়ানিচ হুইঅ কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","মেন্খান ইঞাঃআ গাম লেকাতেদ ইনি কায় গঙ্গ লেন্খানয় গাদা সারাও। হেৎদ ইঞাঃআ মনে হুইয়আ, ইঞ হঃঅ ঈশ্বর রাঃআ আত্মা ঞাম তাৎ আঞ। ");
INSERT INTO cdz_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","অটঃহঅগে হাসা ঠাকুর রাঃআ সামাংরে উতসৃষ্ট বলি বাব্ত্তে, আবু সারিয়াবু যে, আবুয়ায়্য় যত হড় রাঃআ আকেল মেনা আ। আকেলদ গরব উদুঃ এয়ায়, মেন্খান দুলাড় মিহুড় অটঅ মিহুড়কে পাতিয়ারে খন্জা রাকাপ ইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","যদি যাহায় মনে তাৎ আয়, ইনিদ জাহানা আ সারিয়ায়্য়, এন্খান চিল্কা সারি হ্যুয়আ, এঙ্কা নাহা হঅ আউরি সারি নামেয়ায়; ");
INSERT INTO cdz_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","মেন্খান যদি যাহায় ঈশ্বর কে দুলাড়ি য়্য়আয়, এনখান হানিকে দঅ ঈশ্বর সারি আয়ায়্য়, ");
INSERT INTO cdz_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","বেশ, বানা ঠাকুর রাঃআ সামাংরে উতসৃষ্ট বলি জম বাব্ত্তে আবু সারিয়াবু, বানা ঠাকুর ধার্তি রিঙ্কূ জাহিনিচ ল্হয়, হেৎদ ঈশ্বর মিয়াৎ গেয়ায়্য়, মিয়াৎ বিনা বারিয়া বানু ইয়া। ");
INSERT INTO cdz_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","মেন্খান কথক হড় নেকাগে পাতিয়া কু যে স্বর্গ রে হেৎদ ধার্তি রে গাদা দেব্তা হেৎদ প্রভু কুকে মানাতানা কুয়াকু হেৎদ সেবা দেবা হঅ তানাকুয়াকু, ");
INSERT INTO cdz_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","এন্খান র হঅ আবুয়া আ আকেলতে দ মিয়াৎ গে ইনিদ বাবা ঈশ্বর, অকয় রাঃআ হ্তেত তে জ্ত্যা আ গে সির্জনা কানা, হেৎদ আবু অকয় লিয়াগে বাঁঞ্চাবু; হেৎদ মিয়াৎ মাত্র প্রভু ইনি যীশু খ্রীস্ট, অকয় হ্তেত তে জ্ত্যায় আগে সির্জনা কানা, হেৎদ আবু অকয় নাতিনাংগে জিউ নাম তাৎআবু। ");
INSERT INTO cdz_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","এন্খান দ চি যত হড় রাঃআ তালারে নিয়া আকেলদ বায়ায় না; মেন্খান কতক হড় নাহা হঅ হাসা ঠাকুর কু রাঃআ সতেরে তাহিকাতেৎ ঠাকুর রাঃআ হান্ডে উতসৃষ্ট বলি সারিকাতেগে ভোগ কু জ্মেয়া; হেৎদ আকুয়ায়্য় বিবেক নিজুরি গেয়া মেন্তে কুলষিত য়াকু। ");
INSERT INTO cdz_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","মেন্খান জমা কুদ আবুকে ঈশ্বর রাঃআ হান্ডে গ্রাহ্য কায় তকা বুয়ায়; কাঃআ জম লেন্খান আবুয়ায়্য় জাহানা কাঃআ ক্ষতিয়া, জম লেখান হঅ আবুয়ায়্য় জাহানা কাঃআ লাভয়া। ");
INSERT INTO cdz_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","মেন্খান হুঁশিয়ার, আপেয়ায়্য় নিয়া ক্ষমতা জাহালেকাতে পাতিয়ারে নিজুরি কু রাঃআ ব্যাঘাত রাআ কারণ আল হ্যুয়্কা আ। ");
INSERT INTO cdz_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","কারন, আম লেকান আকেলবান হড়, আমকে যদি যাহায় দেব্কুঠিরে জম নাতিনাং দুপ কু নেলমেয়া, এন্খান ইনি নিজুরি হড় তানায় মেন্তে আয়া আ বিবেক দ চি ঠাকুর রাঃআ হান্ডে উতসৃষ্ট বলি জম নাতিনাং চি সাহস কায় নামেয়া? ");
INSERT INTO cdz_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","তবেখানঃঅ আমাঃ আ আকেলতে ইনি হাগা অকয় খাতিরাং খ্রীস্ট গচা কানায়, ইনি পাতিয়ারে নিজুরি হাগা আত্মিক লেকাতেদ নাশয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","নিয়ালেকাতেগে পাতিয়ানিচ হাগা কু হেৎদ মিশি কুরাঃআ বিরুদ্ রে কাই লেখান পে, হেৎদ ইঙ্কূয়া নিজুরি বিবেকরে আঘাত লেখানপে, আপে খ্রীস্ট রাঃআ বিরূদ রে কাই য়াপে। ");
INSERT INTO cdz_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","এন্তে জমা আ নুয়ইয়আ যদি ইঞা ব্কঞ হেৎদ মিশিঞ রাঃআ বিগ্ন তেয়ারেয়ায়্য়, তবেখান ইঞ জাহাহুলাং জিলু কাঞ জ্মেয়ায়্য়, পাছেন ইঞা ব্কঞ হেৎদ মিশিঞ রাঃআ বিগ্ন হ্যুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ইঞদ চি এটা আ হড়কু লেকা আল্গা সাল্গা ল্হয় তানাঞ? ইঞদ চি কুলিচ ল্হয় তানাঞ? ইঞদ চি আবুয়া আ প্রভূ যীশু কে কাঞ নেল তিৎআ? আপে দ চি প্রভু তে ইঞাঃআ কৃত কর্ম্ম ল্হয় তানাপে? ");
INSERT INTO cdz_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ইঞ যদি হঅ এটা আ হড়কু রাআ নাতিনাং কুলিচ আলঞ হ্য়ুয়অ কাঃআ, তুবুই রহঅ আপেয়া নাতিনাং মা নিশ্চই, চিয়া চি প্রভুতে আপেগেপে ইঞা কুলিচপদ রাআ প্রমাণ তানাপে। ");
INSERT INTO cdz_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","অকয় কু ইঞকে দোষ এমিঞাকু, ইঙ্কূয়া হান্ডে ইঞাঃআ তেলা রুয়াড় নিয়া তানা, ");
INSERT INTO cdz_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","আপেয়া অড়ারে এঙ্কাতে তাহিনোঃ রাআ হেৎদ জম নুউ রাঃআ নাতিনাং আইদারি দচি আলেয়া আ বায়ায় না? ");
INSERT INTO cdz_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","এটা আ যত কুলিচ হেৎদ প্রভু রাঃআ হাগাকু হেৎদ কৈফা, নুকু লেকা যাহায় পাতিয়ানিচ এরাকে দুতাম কাতে সঙ্গে তে ইদিকাতে নান্ডে হান্ডে সেনঃঅ রাআ আলেয়া আইদারি দচি বায়ায় না ? ");
INSERT INTO cdz_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","একেন ইঞাঃআ হেৎদ বার্নাবাস রাঃআ গে জিউ যাপন রাআ নাতিনাং পরিশ্রম রাআ আইদারি দচি মেনা? ");
INSERT INTO cdz_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","অকয় পাল্টন যাহাচিল্লং আয়ায়্য় খরচা তে লাড়াই সেনায়? অকয় দ্রাক্ষাদারু রহায়ায়্য়্, হেৎদ ইনারাআ জঅ কায় জ্মেয়ায়? অটহঃঅ অকয় ভিডি গট গুপি কুয়ায়্য় হেৎদ ভিডি গট কুরাআ তয়া কায় নুয়ায়্য়্ ? ");
INSERT INTO cdz_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ইঞ দচি মান্মি কুরাআ আইদারি লেকা নিয়া কুঞ জাগারাপেতানাঞ? অথবা আরিচালি দ্চি নেকা কায় গাম তাৎ আয়? ");
INSERT INTO cdz_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","কারণ মুশি রাআ আরিচালি রে নেকা অল মেনা আ 'হুড়ু বিন্ডা মান্ডায় তানা উরিচ কু রাঃআ ম্চারে মহতি আলম আটকায়া। ঈশ্বর দ চি উরিচ রাঃআ বাব্ত্তেগে চিন্তা য়ায়্য়? ");
INSERT INTO cdz_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","হেৎদ চি সর্ব্বদা আবুয়া আ নাতিনাং নিয়া জাগারেয়ায়্য়? মেন্খান আবুয়ায়্য় নাতিনাং গে নিয়া অল মেনা আ, কারন অকয় চাষেয়ায়্য়, ইনিকে আশা তেগে চাষ হ্যুয়আ; হেৎদ অকয় হুড়ু মান্ডায়ায়, ভাগ নাম রাঃআ আশা তেগে মান্ডায়ায় কাঃআ আয়্য় ");
INSERT INTO cdz_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","আলে চিন্তং আপেয়া হান্ডে আত্মিক হিতা জাং লে হের তাৎআ, ইন্তং যদি আপেয়ায়্য় হড়মঅ জঅ হাতা তাৎ আলে, ইন্খান ইনা দ্চি মহৎ বিষয় তানা ? ");
INSERT INTO cdz_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","যদি আপেয়া চেতাং রে হুকুম্মাত এটা হড়কু রাঃআ আইদারি তাহিনো য়ায়্য়, ইন্খান আলেয়ায়্য দ্চি অটহঅ ঢের আইদারি বায়ায় না? তা সত্বে হঅ আলে নিয়া হুকুম্মাত কালে এমেতানা, বরং জত্যায়ালে সাহায় তানা, যাতে আলেয়া লিয়া খ্রীস্ট রাঃআ বুগিন বার্তা রাঃআ জাহান বাধা আল জানাম কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","আপে দ্চি কাপে সারিয়া, রীলামালান বাব্ত্তে অক্য়্কু কামিয়া, ইঙ্কূ দ রীলামালান ঠাওরে জমা আ কু জ্মেয়া, হেৎদ বঙগা গানডু রাআ অকয় কু দেবা সেবায়ায়্য়, ইঙ্কূ দ বঙগা গানডু রাঃআ ভাগ কু নামেয়া? ");
INSERT INTO cdz_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","এনেখান্গে প্রভু রাঃআ বুগিন বার্তা গাম পাসনা হড় কু রাআ নাতিনাং প্রভু নিয়া বিধান বানাতাৎআয় যে, ইঙ্কূয়া শাখাআসুল বুগিন বার্তা হাতেৎগে হ্যুয়আ। ");
INSERT INTO cdz_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","মেন্খান ইঞ নিয়া কু রাঃআ জাহানা কাঞ ব্যবহার তাৎঞ, হেৎদ ইঞাঃআ বাব্ত্তে যে নেন্কানা করা হ্যুয়ায়্য়, ইনা নাতিনাং ইঞ নিয়া কু কাঞ অলে তানাঞ; চিয়া চি যাহায়গে ইঞাঃআ গরব নিষ্ফলেয়াকু, ইনা হাতেৎ বরং ইঞাঃআ গচঃঅ গাদা বেশা। ");
INSERT INTO cdz_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","কারণ ইঞ যদি হঅ বুগিন বার্তা পাসনাৎ আয়ঞ। এনরঃহ ইঞাঃআ গরব রাঃআ জাহানা আ বায়ায় না; চিয়াচি অবশ্য গঃঅ ইদি রাঃআ বঝা ইঞাঃআ চেতাংরে লাদিয়া কানা; ছিঃ ইঞকে, যদি ইঞ বুগিন বার্তা কাঞ পাসনা য়ায়্য়্। ");
INSERT INTO cdz_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","বস্ততঃ ইঞ যদি ইঞাঃআ ইচ্ছাতে নিয়া কামিয়াঞ, এন্খান ইঞাঃআ মজুরি মেনা আ; মেন্খান ইঞাঃআ ইচ্ছাতে যদি কাঞ কামিয়া, তবুই রহঃঅ কিসাড়িয়া কামী রাঃআ জেমিদারি ইঞাঃআ তিহিরে সম্পা মেনা আ। ");
INSERT INTO cdz_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","তবে খান ইঞাঃআ মজুরি কিনা আ? ইনাদ নিয়া তানা, কাউডি বিনা বুগিন বার্তা পাসনায় তানাঞ, যাতে বুগিন বার্তা পাসনা নাতিনাং অকা আইদারি নাম তাৎআ ইনা আলঞ বাড়িচে কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","কারণ ইঞ যতচ হাতেৎ আল্গা সাল্গা হুই কাতে রহঅ যতচ রাঃআ সেবকেঞ হুইয়া কানাঞ, যাতে গাদা হড় কুকে আগু দাড়িয়া কুকাঞ। ");
INSERT INTO cdz_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","যিহুদি কুকে আগু নাতিনাং ইঞ দ যিহুদি কু রাঃআ হান্ডে যিহুদি লেকা কানাঞ, ইঞ আরিচালি অধীনরে বানুঞ রেহ আরিচালি রাআ অধিনরে তাহীন হড় কুকে আগু নাতিনাং আরিচালি হড় কুরাআ হান্ডে আরিচালি হড় লেকাঞ হুইয়েনা। ");
INSERT INTO cdz_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ইঞ ঈশ্বর রাঃআ বিন আরিচালি বানুঃঞা, বরং খ্রীস্ট রাঃআ আরিচালি রাঃআ অধিনরে মেনাঃঞা, তবুরঃঅ বিন আরিচালি হড় কুকে আগু নাতিনাং বিন আরিচালি হড় কুরাআ হান্ডে বিন আরিচালি হড় লেকাঞ হুইয়েনা। ");
INSERT INTO cdz_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","নিজুরি হড় কুকে আগু নাতিনাং নিজুরি হড় কু রাঃআ হান্ডে নিজুরি লেকা হয়ুয়া কানাঞ; ইঞ যত হড়কুকে উদ্ধার নাতিনাং মিমিৎ উপায় রাআ সায় হাতা তাৎআঞ। ");
INSERT INTO cdz_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ইঞদ যতচয়াগে বুগিন বার্তা রাআ নাতিনাং খাটা তানাঞ, যেন ইনা রাঃআ সহভাগি হুয়ু কাআঞ। ");
INSERT INTO cdz_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","আপে দ চি কাপে সারিয়া যে, নির রাঃআ হেপাবাডি সারিরে অকয় কু নিরেয়া, ইঙ্কূ জ্ত্চ গে কু নিরিয়েআ, মেন্খান সির্পা নামেয়ায়্য় মিহুড়গে? আপে এনে ইঙ্কা নিরেপে, যাতে আপেগে সির্পা নামে কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","হেৎদ অকয় গে ভুকড়া অপ্তায়, ইনিদ যত বাব্ত্তে হড় মঅ কব্জায়ায়্য়্। ইঙ্কূ দঅ হেড়ঃয়ান বহাড়ী ঞাম নাতিনাং কু ইনা করায়া, মেন্খান আলেদ অহেড়ঃয়ান বহাড়ী ঞাম নাতিনাংলে করায় তানা। ");
INSERT INTO cdz_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","এন্তে ইঞ দঅ এনে ইঙ্কা গে নিরে তানাঞ; মেন্খান বিনা দিশা তেদ লহয়, এনে ইঙ্কা লেকা ভুকড়া অপ্তা তানাঞ, মেন্খান ইঙ্কূ লেকা দঅ লহয় অকয় হয়ঃঅ রে ভুকড়া অপ্তা তানাকু। ");
INSERT INTO cdz_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","বরংচ ইঞাঃআ নিজ হড় মঅ কে বাড়িচ লালচকুকে সাম্ভাড়া নাতিনাং বশ রে দহ তিয়াঞচ, নেকা আল হুইঅ কাঃআ পালেত এটা হড়কু রাঃআ হান্ডে গাম পাসনা তায়্ম ইঞ ইঞগে যাহা লেকাতে সির্পা নাম রাআ নাতিনাং আলঞ অগ্রাহ্য কাঞ। ");
INSERT INTO cdz_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","এ ব্কঞ হেৎদ মিশিঞ তিকু, ইঞাঃআ নেকা ইচ্ছা ল্হয় তানা, আপে কাঃআ সারি কাতে তাহিন্পে যে, আবুয়াআ পিতৃকুল কু তুরুই লাক্ষি এখেন হেরেল জ্ত্চ ইনা রিঁবিল লাতার রেকু রক্ষেয়া কাতে তাহি লেনাকু; হেৎদ যত হড় ইনা আরা দরেয়া তালা হরকাতে কু তাড়ম পারম লেনাকু; ");
INSERT INTO cdz_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","হেৎদ যতয় মুশি রাঃআ সুতুঃকু হুইকাতে রিঁবিল রে হেৎদ দরেয়া রেকু দুবুং লেনা, ");
INSERT INTO cdz_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","হেৎদ যতয় মিয়াৎগে আত্মিক জমা কু জম লাৎ আ; ");
INSERT INTO cdz_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","অটঃহঅ, যতয় মিয়াৎগে আত্মিক দাআঃ কু নুউ লাৎআ; কারণ ইঙ্কূ এনকান মিয়াৎ আত্মিক ধিরি হাতেৎ নুউই কেনাকু, অকাআ দ আকু লঅ সেনঃঅ কেনা; ইনা ধিরি দ খ্রীস্ট তানায়। ");
INSERT INTO cdz_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","মেন্খান আকুয়াআ তালারে তাহিয়ান ঢেরউতার হড় কু রাঃআ নাতিনাং ঈশ্বর সন্তুষ্ট কাঃআ তাহীন কেনায়; এন্খান্গে ইঙ্কূ দ তালা ডাহি রেকু গচ চাবা এনা। ");
INSERT INTO cdz_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","নিয়া যত ঘটনা কু আলেয়া আ ঞেলজম লেকানা হুই লেনা, চিল্কা হাঁঙ্কূ লালচ লেনাকু, আবু এঙ্কা বাড়িছ বাব্ত্তে লালচ আলবু করায় কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","অটঃহঅ চিল্কা ইঙ্কূ য়া আ তালারে গাদা হড় কু বানা ঠাকুর কু রাঃআ বঙ্গা বামড়ে হুই লেনা; আপে এনে এঙ্কা বানা ঠাকুর কু রাঃআ বঙ্গা বামড়ে আল্পে হ্যুয়ায়্য়, চিল্কা শাস্তর রে অল মেনা আ \"হড় কু জম নুউ কেৎয়া আ খানঃঅ এনেচ দুরাং নাতিনাং কু স্যাপড়া এনা। ");
INSERT INTO cdz_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","হেৎদ চিল্কা আকুয়াআ তালারে কথক হড় কু দ হড়মালটম লাৎ আ কু, এন্খান মিৎ মাহারে তেইস হাজার হ্ড়কু গচ এনা। আবু যেন ইঙ্কা আলবু হড়মালটম কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","অটঃহঅ চিল্কা আকুয়াআ তালারে কথক হড় কুদ প্রভু রাআ বিডা লাৎ আ কু, হেৎদ বিঞ গের তেকু গয়চ লেনা, আবু ইঙ্কা যেন প্রভু রাঃআ আলবু বিডায় কাআ। ");
INSERT INTO cdz_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","অটঃহঅ চিল্কা আকুয়াআ তালারে কথক হড় কুদ নিপিয়ায় কেনা আকু, হেৎদ ধ্বংসইচ সরগ নাঙ্গা লিয়া ধ্বংস লেনা কু, আপে হঅ ইঙ্কূ লেকা আল্পে এগেরআ। ");
INSERT INTO cdz_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","নিয়া কু যত আকু নাতিনাং ঞেলজম লেকানা হুই লেনা, হেৎদ আবুয়া চেতনা নাতিনাং গে অলেনা; আবুয়াআ, অকয় কু রাঃআ চেতানরে যুগব্যবস্থা রাঃআ মুচাত হিচ্ সেটেরা কানা। ");
INSERT INTO cdz_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","তবেখান অকয় মনেৎ আ, ইঞ পাতিয়া রে স্থির কাতে মেনাঞা, ইনিদ হুঁসিয়ার কাঃ আয়, পাছেন পাতিয়া হাতেৎ আলয় নুরু কাঃয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ইনাতে মান্মি অকা আ সাহা দাড়িয়াআ, ইনা বিনা এটা আ জাহান বিডা আপে নাতিনাং কাঃআ ঘটা কানা আ; হেৎদ ঈশ্বর রাঃআ হান্ডে পাতিয়ান তাহীন পে; ইনিদ আপেকে আপেয়ায়্য় কাঃআ সাহা দাড়িয়া আ হাতেৎ বাড়তি লেকানা আ বিডা কায় হুই তুকা য়ায়্য়্, বরংচ বিডা লঅ এটাআ বাঞ্ছা রাঃআ হরা হঅ তেয়ার দহ য়ায়্য়্, যাতে আপে সাহা দাড়িয়া কাআ পে। ");
INSERT INTO cdz_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","এন্খান এ ইঞাঃআ নিজ দুলাড়ীয়া হড়কু, বানাঠাকুর বঙ্গা হাতেৎ সাঙ্গিনতে নির জমঃ পে। ");
INSERT INTO cdz_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","আকিলান হড় তানাপে মেন্তে গামাপে তানাঞ, অকাঞ গামাপেতানা আপেগে পরখ কাতে নেলেপে। ");
INSERT INTO cdz_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","প্রভু ভোজ বাত্রাং আবু অকা নুঘুটি রে আঙ্গুর রস লিয়া ঈশ্বর কে সারায় এমকাতে নুই তানাবু, ইনাদ চি খ্রীস্ট রাঃআ মায়মতে সহভাগিতা ল্হয়? আবু অকা পিঠা বু কেচায় তানা, ইনা দ্চি খ্রীস্ট রাঃআ হড়মতে সহভাগিতা ল্হয়? ");
INSERT INTO cdz_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","কারণ গাদাহড়কুতে গে আবু, আবুদ যতয় মিয়াৎ পিঠাকেগে কেচা কাতেন জমেয়াবু, মিয়াৎগে হড়মঅ তানা; চিয়াচি আবু যত হড় ইনা মিয়াৎ পিঠা রাআগে হাকদার তানাবু। ");
INSERT INTO cdz_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ইস্রায়েল জাতি রিঙ্ক হড়কুরাআ বাবদতে ভাবাকাতে হ্যাংকুকে ঞেলকুপে; অক্য়্কু বলি জমেয়া, হ্যাংকুদ্চি বঙ্গাঃগাঁনডু রাঃআ সহভাগিতা ল্হয়? ");
INSERT INTO cdz_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","তবেখান ইঞদ কিনা আঞ গামেতানা? বানাঠাকুর রাঃআ হান্ডে উতসৃষ্ট বলিদ্চি জাহানা আ রে মেনা আ মেন্তে লেখা গানআ? অটঃহঅ বানা ঠাকুর দ্চি যাহাদররে মেনা আইয়া মেন্তে মানাগুনা গানয়া? ");
INSERT INTO cdz_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","বরংচ বিজাতি কু অকাআ অকা আ বলিকু সামাংএয়া, ইনা কু দ বঙ্গা রাঃআ নাতিনাং সামাংএয়া, ঈশ্বর রাঃআ নাতিনাং দ ল্হয়, হেৎদ ইঞা নেকান ইচ্ছা ল্হয় তানা, আপে বঙ্গালঅ পে হেল মেলঃআ কাআ। ");
INSERT INTO cdz_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","প্রভু রাঃআ নুউ ঘটিতে হেৎদ বঙ্গ রাঃআ নু ঘটিতে, আপে নিয়া বারিয়া ঘটিতে নু কাপে দাড়িয়া আ; প্রভু রাঃআ জমা অড়াঃআরে হেৎদ বঙ্গ রাঃআ জমা অড়াঃআরে বারান অড়াঃআরে দাও কাপে হাতা দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","এন্খান আবুদ্চি প্রভু রাঃআ অন্তরজ্বলন তুকায় তানাবু? হানি হাতেৎ দ আবুদ্চি দাড়িয়ান হড় তানাবু? ");
INSERT INTO cdz_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","আপেয়া তালারে কথক কু নেকা গাম ভাড়ায়াকু, জ্ত্যআয়্য় গে বৈধ, মেন্খান জ্ত্যায়্য়য়দ আবুয়া নাতিনাং বাংখান এটা কুরাআ নাতিনাং হিত রাআ, ইনা দঅ ল্হয়, হ্যাঁ, আপেয়া তালারে কথক কু নেকা গাম ভাড়ায়াকু \"জ্ত্যআয়্য় গে বৈধ তানা, মেন্খান জ্ত্যায়্য়য় গে যে ইঙ্কয়া আত্মিক জিউ কেটেজ লেকাতে গাথা রাকাপ এয়ায়্য়। ইনা দ লহয়। ");
INSERT INTO cdz_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","অকয় হঅ স্বার্থ রাআ নাতিনাং আল্পে কুরুমুটুয়া, বরংচ মি মিৎ হড় এটা হড় কু রাঃআ বেশ নাতিনাং কু কুরুমুটুই কাআ। ");
INSERT INTO cdz_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","অকা জিলু কু বাজার রে আখরিঙ অ তানা; বিবেক তে জাহানা আ কাঃআ কুকলী দহ কাতে জ্মেপে; ");
INSERT INTO cdz_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","চিয়া চি 'ধার্তি রাঃআ হেৎদ ধার্তি রাঃআ যাবতীয় জিনিস কুদ প্রভু রাঃআগে। ");
INSERT INTO cdz_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","যদি যীশুকে কাপাতিয়ান হড় কু তালা হাতে যাহায় আপেকে জম নাতিনাং রাঃআ পেয়াকু খানঃঅ, হেৎদ সেনঃঅ সানা পেয়া, তবে বিবেক রাআ নাতিনাং জাহানা কুক্লি কাঃআ দহ কাতে ইনাগে জম নুউই পে, অকা জিনিসগে আপেয়া আ সামাং রে দহঅয়া পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","মেন্খান যাহায় যদি আপেকেকু গামাপেয়া, নিয়া মাত বানাঠাকুর রাঃআ হান্ডে উতসৃষ্ট ভোগ তানা, এনখান অকয় কু সারি ঞাম তুকাৎ পেয়াকু, ইনি রাআ নাতিনাং হেৎদ বিবেক রাআ নাতিনাং ইনা আল্পে জ্মেয়া। ");
INSERT INTO cdz_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","অকা বিবেক রাঃআ থুতিঞ জাগার কেৎআ, ইনাদ আপেয়া আ ল্হয়, মেন্খান এটাআ হড় রাঃআ। কারণ ইঞাঃআ আল্গা সাল্গা টা চিয়া এটা হড় রাঃআ বিবেক্তে দরবার অ হুয়ুয়া? ");
INSERT INTO cdz_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ঈশ্বর কে সারাও লঅ যদিঞ জ্মেয়া, এনখান অকয় লিয়া সারাও ইঞ এমে তানা, হানি নাতিনাং চিয়া আ ইঞা বদনাম হুইঅয়া? ");
INSERT INTO cdz_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","তবেখান আপে জ্মেয়াপে, চি পে নুয়া, চি জাহানা আ গেপে করায়া, জ্ত্যাগে প্রভু রাঃআ গৌরব নাতিনাং করায় পে। ");
INSERT INTO cdz_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","যিহুদি চি গ্রীক হড়, চি ঈশ্বর রাঃআ মন্ডলী, যাহায় রাআ হঅ এটকেট্রেত রাআ কারণ আল্পে হুইঅয়া; ");
INSERT INTO cdz_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","চিল্কা ইঞ হঅ যত ব্যাপাররে যত হড় রাঃআ প্রীতিকর হুয়ুয়া কানাঞ, ইঞা আ হিত রাঃআ কাঞ কুরুমুটু তাৎ আঞ, মেন্খান গাদা হড় রাআ হিত রাঃআ কুরুমুটু তাৎ আঞ, যাতে ইঙ্কূ পরিত্রান কু নামে কাআ। ");
INSERT INTO cdz_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ইঞা অতংইচ হুয়ুঅপে, চিল্কা ইঞ খ্রীষ্ট রাআ অতংইচ হুয়ুআ কানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ইঞ আপেকে গুনমানত এমাপে তানাঞ যে, আপে যত বিষয়রে ইঞ কেপে পাহাম দহ তিঃইঞা, অটঃহঅ আপেয়া হান্ডে চিল্কা চেচেদাঃআ কুঞ কুল তাৎ আঞ, ইনা চেচেদাঃআ কু আপে অতং ইদি তানাপে। ");
INSERT INTO cdz_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","মেন্খান ইঞাঃআ ইচ্ছা নিয়া তানা, যাতে আপে সারি নামে কাআ পে যে, যত হেরেল কু রাঃআ বহঅ চেতান রেদ খ্রীস্ট মেনা ইয়াআ হেৎদ এরা হন কু রাঃআ বহঅ চেতান রেদ হেরেল মেনা ইয়াআ হেৎদ খ্রীষ্ট রাঃআ বহঅ চেতান রেদ ঈশ্বর মেনাইয়া। ");
INSERT INTO cdz_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","অকয় কড়া হন বহঅ দাপাল কাতে বিন্তিয়ায়্, বাংখান ভাবী জাগারেয়ায়্য়, ইনিদ আয়ায়্য় বহঅ কে অর্থাৎ খ্রিষ্ট কে অপমানিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","মেন্খান অকয় এরা হন বহঅ রে কিচি কাঃআ এম কাতে বিন্তিয়ায়্য়, চি ভাবী জাগারেয়ায়, ইনিদ আয়ায়্য় বহঅ কে অপমানিয়ায়; কারন ইনি দঅ চাড্রা বহঅ এরা হন লেকা হুইঅআ। ");
INSERT INTO cdz_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","বেশ, এরা হন যদি আয়ায়্য় বহঅ কায় গুগুলুকাতে দহ য়েআয়, ইনি দ উপ হঅ গেদ গিডিকাঃ আয়; মেন্খান বহঃঅ রাঃআ উপ গেদ গিডি চি বহঅ চাড্রা এরা হন রাঃআ গিয়ু রাআ বাবদ তানা, এন্খান বহঃঅ তেয়ায়্য় দাপাল কাতে দহয় কাঃ আয়্য়। ");
INSERT INTO cdz_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","সার্তি জাগার্তে কিনা আ হেরেল হড় রাঃআ বহঅ দাপাল দহ ঠিক ল্হয়, কারন ইনিদ ঈশ্বর রাঃআ লেকা বানা তুকা কানায় হেৎদ ইনি রাআ দ্বারায়তে ঈশ্বর রাআ মহিমা হুইঅয়া; মেন্খান এরাদ হেরেল রাঃআ সন্মান। ");
INSERT INTO cdz_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","কারণ হেরেল দ এরা হাতেৎ লহয়; মেন্খান এরা দ হেরেল হাতেৎ বানা কানায়। ");
INSERT INTO cdz_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","অটঃহঅ এরা নাতিনাং হেরেল কায় সির্জনা কানায়, মেন্খান হেরেল নাতিনাং গে এরাদ সির্জনা কানায়। ");
INSERT INTO cdz_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","চিয়াচি সরগ নাঙ্গা কু নেলেতানা ইনা খাতিরাং এরা কু রাঃআ বহঅ রে কর্তৃত্ব রাঃআ চিন্হা দহ লাক্তি। ");
INSERT INTO cdz_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","এন্খান প্রভুতে এরা হঅ হেরেল বাংখান লহয়, অটঃহঅ হেরেল হঅ এরা বাংখান লহয়। ");
INSERT INTO cdz_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","কারন হেরেল হাতেৎ চিল্কা এরায়, ইঙ্কা গে এরা লিয়া হেরেল জন্মা কানায়, মেন্খান জ্ত্যয়্য়াগে ঈশ্বর হাতেৎ হুয়ুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","আপে আপেতে দরবার পে, বহঅ কাআ দাপাল কাতে ঈশ্বর রাঃআ হান্ডে বিন্তি দ চি এরা রাঃআ ঠিক? ");
INSERT INTO cdz_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","প্রকৃতি স্বয়ং দ্চি আপেকে কায় চেদ তাৎ পেয়া যে, হেরেল হড় জিলিং উপ পে দহ লেখান, ইনাদ আপেয়া গিয়ু রাআ বিষয়; ");
INSERT INTO cdz_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","মেন্খান এরা হন যদি জিলিং উপ দহ্যায়্য়, এন্খান ইনাদ আয়ায়্য় সনমান রাঃআ বিষয়; কারন ইনা উপ দাপাল নাতিনাং এম হুয়ুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","মেন্খান যাহায় নিয়া বাব্ত্তে কু বাকঝৌড়িয়া, এন্খান নিয়া সারি কাঃআকু নেকানা আ চল দঅ আলেয়া আ তালারে বায়ায়না হেৎদ ঈশ্বর রাআ মন্ডলী তালা রেহ অ বায়ায়না। ");
INSERT INTO cdz_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","নাহাআ নিয়া হুকুম এম নাতিনাং আপে কে কাঞ গুনমানতাঃ পে তানাঞ, কারণ আপে ঈশ্বর রাআ আরাধনা নাতিনাং মিশাতে হুন্ডিই তানা পে, ইনাতে বেশ দ কাঃআ হুয়অ তানা বরংচ বাড়িছ গে হুয়অ তানা ");
INSERT INTO cdz_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","কারণ মাড়াং মাতঃঅ, আয়ুম নামে তানাঞ, চিন্তং আপে মিসাতেপে মন্ডলীরে হুন্ডি তানা, ইন্তংগে পে দল হাটিং তানা, হেৎদ নিয়াদ হুডাঞ পাতিয়া তানা। ");
INSERT INTO cdz_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","সার্তি গাম তেদ কিনা আ আপেয়া তালারে দল হাটিং জারুরী মেনা আ, চিয়া চি আপেয়া তালারে অকয় কু প্রাকৃত ইঙ্কূ চিন্হা নাম্যাকু। ");
INSERT INTO cdz_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","জাহান গেয়া, আপে চিন্তং মিৎ থাং রেপে হুন্ডি তানা, ইন্তং প্রভু রাঃআ ভোজ কাপে মানায় তানা, ");
INSERT INTO cdz_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","নিয়াদ চিল্কা? যত হড় আপেয়া আ জমাপে জমে আ এটা হড় রাঃআ জম মাড়াং তে, ইনাতে চিকা তানা অক্যয় মিহুড় দঅ রেঙ্গেজ গে তাহিনোঃ তানায়, হেৎদ এটা অক্য়্কুদ বুল চাবা তানা। ");
INSERT INTO cdz_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","আপেয়া দ্চি অড়া দুয়ার বায়ায়্য় না জম নুউ নাতিনাং? চি ঈশ্বর রাঃআ মন্ডলীকে পে অমান্যই তানা? চি গিয়ু পে এমাকু তানা অকয় রেঙ্গেজ পাতিয়ানিচ হাগা মিশি কু রাঃআ জাহানা বায়ায়্য় না মেন্তে? কিনাঞ গামাপেয়া আপেকে? চি আপেকেঞ গুনমানত পেয়া ? কাইঞ গুনমানত পেয়া নিয়া কু খাতিরতে। ");
INSERT INTO cdz_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","কারন প্রভু হাতেৎ নিয়া চেচেদা আঞ চেদাকানা হেৎদ ইনা চেচেদা আ লেকাতে আপেকেঞ চেদেৎ পেয়া, প্রভু যিশু অকা নিদা বৈরী রাঃআ তিহিরে সাপতুকা লেনায়, ইনা নিদা পিঠা স্যাপ/হাতা কেৎ আয়, হেৎদ সারাও কেৎতে কেচা কেৎ আয়, ");
INSERT INTO cdz_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","হেৎদ গাম কেৎ আয় 'নিয়াদ ইঞাঃআ হড়মঅ তানা, নিয়াদ আপেয়া নাতিনাং গে; ইঞকে পাহাম দহ নাতিনাং নেকাগে করাঃআ আগুই পে। ");
INSERT INTO cdz_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","এনে ইঙ্কা লেকাগে জম কেৎ তে নুঘুটি হঅ স্যাপ কেৎ তে গাম কেৎ আয় 'নিয়া নুঘুটি ইঞাঃআ মায়মতে বানায় না নামা আরি চলি; চিমিন্সা নিয়াপে নুয়ায়্য় ইমিন্সা ইঞকে পাহাম নাতিনাং নেকা করায় পে। ");
INSERT INTO cdz_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","কারন চিমিন্সা নিয়া পিঠাপে জ্মেয়া, হেৎদ নুঘ্টি তেপে নুয়ায়্য়, ইমিন্সা গে প্রভু রাঃআ গজ তত্ত্বপে পাসনায়া পে, চিল্লং অব্দি কায় রুয়াড় হিজুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","তবেখান অযোগ্য় য়ান হড় কু প্রভু রাঃআ পিঠা কু জ্ম লেখান চি নুঘ্টি তে কু নু লেখান, ইঙ্কূ প্রভু রাঃআ হড় ম তে হেৎদ মায়্ম্তেকু দষীকু হ্যুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","মেন্খান মান্মি আচ আয়া মাড়াঙ যাচাঃই কাঃআয়, হেৎদ ইনা পিঠা জম হেৎদ নুঘ্টিতে নুই কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","কারন অকয় মান্মি জম নুয়ায়্, অথর্চ ইনি প্রভূ রাআ হড়ম কে কায় মর্যাদা ইয়ায়, তবেখান ইনি জম নুউ নাতিনাং নিজেকেগে বিডাইএম হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","নেকানা আ নাতিনাং গাদা মান্মি নিজুরিয়া কানাকু হেৎদ রুয়া তানাকু, হেৎদ গাদা মান্মি কু গ্চাকানা। ");
INSERT INTO cdz_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","আবু যদি আবু নিজেকে যাচাই কুয়্য়াবু হুনাং, তবেখান আবু বিডারে কাবু নুর কয়্য়া হুনাং; ");
INSERT INTO cdz_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","মেন্খান আবু চিন্তং প্রভু এ দরবার বুয়ায়, ইন্তং বু শাসিতআ, চিয়া চি জাগতিক হড় লঅ আবু হঅ কুড়াই আলবু নামে কা আ। ");
INSERT INTO cdz_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","এন্খান এ ইঞা ব্কঞ হেৎদ মিশিঞ তিকু আপে চিন্তং জম নুউ নাতিনাং হুন্ডিয়া আপে, তায়্ম রে অকয় মেনাইচ গেয়া ইনিকে তাঙ্গিপে। ");
INSERT INTO cdz_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","যদি অকয় রাঃআ খুব রেঙ্গেচ লাগা কানা, ইনিদ অড়ারে জম হাতাড়ে কাআয়; আপেয়া হুন্ডি যেন দরবার রাঃআ কারণ আল হুইঅ কাঃআ। হেৎদ যতচয়া বাব্ত্তে, চিন্তংইঞ হিজুয়া, ইন্তংঞ হুকুমা পেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","অটঃহঅ এ বকঞ হেৎদ মিশিঞ তিকু, রীলামালা আত্মিক দান বাব্ত্তে আপে যে আল সারিকাতে তাহীন কাআপে, নেকান ইচ্ছা ইঞাঃআ বায়ায়না। ");
INSERT INTO cdz_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","আপে সারিয়া পে, যখন আপে খ্রিষ্ট রে কাঃপাতিয়ান তাহি লেনা, ইন্তং চিল্কাপে সেসেন কেনা, ইঙ্কাগে নির্বাক বানাঠাকুর রাঃআ হান্তে পে সেনঃঅ কেনা। ");
INSERT INTO cdz_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","নিয়া নাতিনাং আপেকেঞ সারি তুকাপে তানা যে, ঈশ্বর রাঃআ আত্মাতে জাগার লেখান, যাহায় কাকু গামেয়া 'যীশু অভিশপ্ত তানায় মেন্তে হেৎদ রীলামালা আত্মাতে ভরাকান বিনা যাহায় কাকু গাম দাড়িয়া 'যীশু প্রভুগে। ");
INSERT INTO cdz_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","নানা হুনার অনুগ্রহ রাঃআ দানদ, মেন্খান আত্মা দ মিয়াৎ গেয়ায়্য়; ");
INSERT INTO cdz_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","নানা হুনার রাঃআ সেবা কামী মেনা আ, মেন্খান প্রভু দ মিয়াৎ গেয়াআয়্য়; ");
INSERT INTO cdz_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","হেৎদ নানা হুনার সেবা কামী রাঃআ গুনা গুন, মেন্খান ঈশ্বরদ মিয়াৎ গেয়ায়; ইনিদ জ্ত্যায় রেনিচ জ্ত্য কামী পুরা রাআ কর্তা তানায়। ");
INSERT INTO cdz_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","মেন্খান মিমিৎ মান্মি কে আকুয়াআ বেশ রাআ নাতিনাং রীলামালা আত্মা রাঃআ ভরদান এমহ্যুয়ায় কানা। ");
INSERT INTO cdz_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","কারন মিহুড় কে ইনা আত্মাতে প্রজ্ঞাবান জাগার এমা কানায়, অটঃহঅ মিহুড় কে ইনা আত্মাতে আকেলবান রাঃআ জাগার এম হুয়ুয়া কানা, ");
INSERT INTO cdz_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","অটঃহঅ মিহুড় কে ইনা আত্মাতে পাতিয়া রাঃআ গুন, অটঃহঅ মিহুড় কে ইনা আত্মাতে রুয়াবুগি রাঃআ অনুগ্রহ দান, ");
INSERT INTO cdz_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","অটঃহঅগে মিহুড় কে ইনা আত্মাতে হাহাড়া কামী দাড়ি রাঃআ গুন, অটঃহঅগে মিহুড় কে ভাবিজাগার রাঃআ গুন, অটঃহঅগে মিহুড় কে আত্মা কুকে চিন্হা নাতিনাং দাড়ি, অটঃহঅগে মিহুড় কে নানা হুনার কাঃআ সারি জাগারতে থুতি রাঃআ দাড়ি, অটঃহঅগে মিহুড় কে নানা হুনার ভাষা রাঃআ অর্থ উদু রাঃআ দাড়ি এমা কানা; ");
INSERT INTO cdz_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","মেন্খান নিয়া যত কামীকু ইনি আত্মাগে পুরা দাড়িয়ায়্য়্; ঈশ্বর বিশেষকাতে আয়ায়্য়্ মেনজং লেকাতে অকয় কে অকা এম লাক্তি, ইনিকে ইনা গে এমাই য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","চিয়া চি চিল্কা মিয়াৎ হড়ম, হেৎদ ইনি রাঃআ বদন গাদা লেকাআ হেৎদ হড়ম রাঃআ বদন গাদা লেকা মেনা রহঅ হড়মদ মিয়াৎ গে, এনে ইঙ্কা গে খ্রীস্ট হঅ। ");
INSERT INTO cdz_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","এন্খান্গে, আবুদ্চি জিহুদী চি গ্রীক, চি মুনিস চি আল্গা সাল্গা, যত হড় মিয়াৎ হড়ম হুই নাতিনাং রীলামালা আত্মাতে দুবাং হ্যুয়া কানা হেৎদ যত হড় মিয়াৎ আত্মা হাতেৎ দাড়ি নামাকানা। ");
INSERT INTO cdz_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","এন্খান হড়ম দ মিয়াৎ গে বদন ল্হয়, গাদালেকা। ");
INSERT INTO cdz_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","কাটা যদি গামেয়ায়্য়, ইঞ মাত তিহি ল্হয়, ইনা নাতিনাং হড়ম রাঃআ বদন ল্হয়, এন্খান ইনাদ্চি হড়ম রাঃআ বদন ল্হয়, ইঙ্কা দ ল্হয়গে। ");
INSERT INTO cdz_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","অটঃহঅগে লুতুর যদি গামেয়ায়্য়, ইঞ মাত মেত ল্হয়, ইনা নাতিনাং হড়ম রাঃআ বদন ল্হয়, এন্খান ইনাদ্চি হড়ম রাঃআ বদন ল্হয়, ইঙ্কা দ ল্হয়গে। ");
INSERT INTO cdz_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","যদি গটা হড়মঅ রে মেত হুই কআ হুনাং, এন্খান্দ লুতুর কথাং রে তাহি কআ? হেৎদ গটা হড়মঅ রে যদি লুতুর হুই কআ হুনাং, তবেখান মুউ কদের রে তাহি কআ ? ");
INSERT INTO cdz_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","মেন্খান ঈশ্বর যত বদন কু হড়মঅ রে মিমিৎ কাতেত আয়ায়্য় চিল্কা ইচ্ছা তাহিলেনা, এনে ইঙ্কা গে বদন কু সাজা তাৎ য়ায়্য়্। ");
INSERT INTO cdz_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","যদি যত বদন মিয়াৎ লেকাগে হুই কয়াআ হুনাং এন্খান হড়মঅ কথাং রে তাহি ক্যায়্য় হুনাং? ");
INSERT INTO cdz_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","মেন্খান নাহাআদ বদন গাদা লেকাআ, মেন্খান হড়মঅ দ মিয়াৎ গেয়া। ");
INSERT INTO cdz_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","মেত দ তিহিকে কায় গাম দাড়িয়া ইয়াআয়্য়্, আমকে ইঞাঃআ জারুর বায়ায়না; অটঃহঅ বহঃঅ হঅ কাটা কিনকে কায় গাম দাড়িয়াআয়্য় কিনায়, আবেনকে ইঞাঃআ জারুর বায়ায়না; ");
INSERT INTO cdz_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","বরংচ হড়মঅ রে অকা বদন্কু কে নিজুরি মেন্তে মনেয়া, ইনা কুগে বেশি জারুরি তানা। ");
INSERT INTO cdz_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","অটঃহঅ আবুয়ায়্য় হড়মঅ রাঃআ অকা বদনকুকে অকাজী মেন্তে বু মনেৎআ, ইনাকুকে বিসি সাজগুজে তানা হেৎদ আবুয়ায়্য় অকা বদন্কু বেশ কাআ নেলআ ইনা কুগে অটঃঅ বিসি সাজগুজ হুইয়আ; ");
INSERT INTO cdz_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","মেন্খান আবুয়ায়্য় হড়মঅ রে অকা বদন খুব বেশি বেশ নেল তানা ইনাদ আবুয়া নেল আতেন রাআ বিশেষ জারুর বায়ায়না। নিয়াদ ঠিক, ঈশ্বর হড়ম সাজা তাৎ আয়, কাঃআ পুরাকানা লেকানাআ বেশি মানতা এম তাৎ আয়, ");
INSERT INTO cdz_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","যাতে হড়মঅ হাতেৎ আল ভেগার হাটিং ঞঃকাঃআ। মেন্খ্ন যত বদন যাতে মিলজুল কাতে সমানতে কু ভাবনায় কাআ. ");
INSERT INTO cdz_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","হেৎদ মিয়াৎ বদন দুক নাম লেখান এটা বদনকু হঅ সমান দুক কু নামেয়া হেৎদ মিয়াৎ বদন সাবাসে নাম লেখান সাতে সাতে এটা যত বদন কু সাবাসী নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","আপেগে খ্রীস্ট রাঃআ হড়মঅ হেৎদ মিৎ মি ৎ হড় মিয়াৎ মিয়াৎ বদন। ");
INSERT INTO cdz_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ঈশ্বরদ যত হাতে মাড়াঙ তে মন্ডলীরে কুলিচকুকে; দশার রেদ ভাবি জাগার কুকে, তেসার রেদ চেচেদিচ কুকে আইদারি এমাৎ তকুয়া; ইনা তায়্ম নানা হুনার হাহাড়া কামী, ইনা তায়্ম রুয়াবুগি রাআ অনুগ্রহ দান, উপ্কার, শাসনহাপা, নানা হুনার ঠার এম তাৎআয়। ");
INSERT INTO cdz_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","যত হড় দ্চি কুলিচ? যত হড় দ্চি ভাবিজাগারিচ? যত হড় দ্চি চেচেদিজ? যত হড় দ্চি হাহাড়া কামি কু দাড়িয়া? ");
INSERT INTO cdz_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","যত হড় দ্চি রুয়া বুগি রাঃআ নিরাই দান নাম তাৎ ইয়াকু ? যত হড় দ্চি নানা হুনার কাঃআ সারি ঠার তেকু থুতিয়া? যত হড় দ্চি কাআ সারি ঠার শালা কাতে বুঝা তুকা দাড়িয়া মেয়ায়্য়? ");
INSERT INTO cdz_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","আপে মারাং দান হাতা নাতিনাং বেশি বেশি আগ্রহপে। হেৎদ ইঞ আপেকে অটঃহঅগে বুগিন নজ্ঞাঃআ হরাঞ উদুয়াপে তানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ইঞ যদি মান্মি কু রাঃআ হেৎদ নাঙ্গা কু রাঃআ ঠার তেঞ জাগারা, মেন্খান ইঞাঃআ দুলৌড় কাঃআ তাহিনা, ইন্খান ইঞদ শুধু সাডি তান পিতল হেৎদ ঝম ঝম করতাল লেকাঞ হয়ুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","অটঃহঅ ইঞকে যদি ভাববাণী এময়া, হেৎদ উকু মেনা আ সার্তি কু হেৎদ আকেলতে পেরেচ মেনাঞ রেহ হেৎদ ইঞাঃআ পুরা পাতিয়া মেনা আ যে বুরুকে রাড়া দাড়িয়া আঞ, মেন্খান ইঞাঃআ অন্তররে এটাকুরা নাতিনাং দুলৌড় কাআ তাহিনা, এন্খান ইঞদ জাহিনিচ তেৎ রহঅ ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","অটঃহঅ ইঞা অকা মেনা আ যতচয়া রেঙ্গেচ হড় কুকে জম নাতিনাং এমা কুয়াঞ হেৎদ ইঞ যদি বুগিন বার্তা পাসনা নাতিনাং সম্পা তুকা কানাঞ, মেন্খান ইঞাঃআ দুলৌড় কাআ তাহিনা, এন্খান জাহানা আ লাভ বায়ায় না। ");
INSERT INTO cdz_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","দুলৌড়দ সাহাইচ, দুলৌড়দ দায়ানিচ, কায় ঈর্ষা আয়, দুলৌড় দুপৌলৌড়রে ধকা কায় এমেয়ায়্য় (দুলাড় করায়তান হড় আয়া জীবন রে ধীর দঃহঅ হুইঅয়া হেৎদ এটা কুকে দায়া কুআয় হেৎদ এটা কুকে কায় জ্বালা কুআয় হেৎদ এটা কুকে কায় ধোকা এমাকুআয় হেৎদ কায় গর্ব্ব আয় ");
INSERT INTO cdz_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","হেৎদ ইনি এটা হড়কু লঅ খারাপ ব্যবহার কায়ায়্ য়, শুধু আয়া গে ভাল কায় নানামায়, ঘিড় মেন্তাং কায় রাগায়ায়্, ইনিরাআ চেতাং যাহানা গে ক্ষতি হুই লেনখান রেহঅ ক্ষতি রাআ বদলা কায় হাতাআয় (ভুল যাহায় রাঃআ কায় নেলেয়ায়্ য়, ");
INSERT INTO cdz_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ইনি দঅ খারাপ কামী কুরে কায় খুশিখুসাল আয়, মেন্খান সৎরে খুশিখুসাল আয় (দুলৌড়দ অধর্মীকামিরে কায় খুশিখুসাল আয়, মেন্খান সার্তিরে (সততে) খুশিখুসাল আয়; ");
INSERT INTO cdz_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ইনি দঅ জ্ত্যায় গে সাহা ইদিয়ায়্য়, জ্ত্যায় গে পাতিয়া য়ায়্, জ্ত্যায়া রাঃআ গে আশা দঃহয়ায়্য়, যত অবস্থা রেগে ধৈর্য্যতে সাহা য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","দুলৌড়দ যাহা হুলাং কা মুচাতআ। মেন্খান ভাববাণী যদি তাহিনা, ইনাদ লোপ আ; যদি কাঃআ সারি ঠার তাহীন রেহঅ, ইনা যত চাবা চাআ; যদি আকেল তাহীনা, ইনা হঅ লোপয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","কারন আবু হুডাং লেকাবু সারিয়া, হেৎদ হুডাং লেকাবু ভাববাণী গামেয়া; ");
INSERT INTO cdz_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","মেন্খান পূর্ণতা হিচ্ লেন্খান, অকা কেচাগাআ ইনাদ লোপ্য়আ। ");
INSERT INTO cdz_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ইঞ চিন্তং হুডিং হন্গে তাহিলেনা, ইন্তং হুডিং হন লেকা থুতি কেনাঞ, হুডিঞ হন লেকা চিন্তাৎ কেনা, হুডিং হন লেকা দরবারেৎ কেনা; নাহা আ হারা কানাঞ মেন্তে হুডিং হন রাঃআ লেকা যত মন ভাব বাগী তাৎয়াং। ");
INSERT INTO cdz_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","কারণ নাহাআ আবু আরসিরে অব্ছাবু নেলেৎআ, মেন্খান ইন্তং সামাং সদর কাতে ঈশ্বর রাআ স্পষ্টরূপ নেলেয়াবু। নাহা ইঞ ইনিকে কথক অংশ লেকাতে সারি আইঞ, মেন্খান ইনা হুলাং ইঞ নিজেকে ঈশ্বর চিল্কা উপুরুমায়াআঞ, এঙ্কা উপরুম নামেয়াবু ");
INSERT INTO cdz_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","হেৎদ নাহা আ আপিয়া জিনিষ মেনা অকা আবুকে করা তেগে হুইঅয়া, ঈশ্বর রাআ চেতাং ভরসা, ইনি অকা এমা বুয়ায় ইনা নাম নাতিনাং নিজে রাঃআ পাতিয়া রে আশা দঃহ হুইঅয়া হেৎদ এটা কুকে দুলৌড় হুইঅয়া। মেন্খান নিয়া আপিয়া জিনিষ রাঃআ তালা রে দুলৌড় গে যত হাতেৎ সরসা। ");
INSERT INTO cdz_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","এটা কুকে দুলৌড় নাতিনাং আপে জিউযাপনে পে, হেৎদ আত্মিক বরদান কুরাআ নাতিনাং কুরু মূটুই পে, বিশেষ কাতে যেন ভাবিজাগার গাম দাড়ি কাঃআ পে। ");
INSERT INTO cdz_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","চিয়া আ চি অকয় হড় বিশেষ ঠারতে জাগারেয়ায়্য়, ইনিদ মান্মি রাঃআ হান্ডে দ ল্হয়, মেন্খান ঈশ্বর রাঃআ হান্ডে গামে তানায়; কারন যাহায় কাকু বুঝা, বরং ইনি রীলামালা আত্মাতে নিগুড়তত্ব গামেয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","মেন্খান অকয় মান্মি ভাবিজাগারেয়ায়্য়, ইনিদ মান্মি কু রাঃআ হান্ডে গাথা রাকাপ নাতিনাং হেৎদ আশা হেৎদ সান্তনা রাঃআ থুতিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","অকয় হড় বিশেষ ঠারতে থুতিয়ায়্য়, ইনিদ আচ্কেগে গাথা রাকাপিয়ায়, মেন্খান অকয় হড় ভাবিজাগারেয়ায়্য় ইনিদ মন্ডলীকে গাথা রাকাপিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ইঞাঃআ ইচ্ছাদ নিয়া তানা, আপে যাতে বিশেষ বিশেষ ঠারতে জাগার দাড়িকাঃআ পে, মেন্খান বেশি নঅঞ আসি তানা, যাতে ভাবিজাগার গাম দাড়ি কাপে; চিয়া চি অকয় বিশেষ বিশেষ ঠারতে জাগারায়, মন্ডলী কে গাথা রাকাপ নাতিনাং ইনি যদি অর্থ গাম বুঝা কাঃআ দাড়িয়া কুয়া, তবেখান ভাবিজাগার জাগারিচ হানি হাতেৎ মহান তানায়। ");
INSERT INTO cdz_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","নাহাআ, এ হাগাঞ- মিসিঞ তিকু আপেয়া হান্ডে হিচ্ কাতে যদি বিশেষ বিশেষ ঠারতেঞ জাগারা, মেন্খান আপেয়া হান্ডে সার্তি সদর রাঃআ চি আকেল রাঃআ চি ভাবিজাগার রাঃআ চি চেচেদা আ লেকানা উপমা কাঞ গামেয়া, তবেখান ইঞাঃআ হান্ডে হাতেৎ আপে কিনা আ উপ্কার পে নেল্নামেয়া ? ");
INSERT INTO cdz_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","রুতু হুয়েন চি বানাম হুয়েন, যদি জীউহীন রুউয়ান জিনিস হঅ তাল মান কাঃআ দহ কাতে সাডিয়ায়্, তবে খান রুতুতে চি বানামতে কিনা আ সাডি তানা মেন্তে, চিল্কাতে সারি নাম আ? ");
INSERT INTO cdz_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","রুতু রাঃআ সুর যদি অস্পস্ট হ্যুয়ায়্, এন্খান অকয় লেকানিচ দঅ লাড়াই নাতিনাং স্যাপড়াআয় ? ");
INSERT INTO cdz_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","এনে এন্খাগে আপে যদি আলাংতে জাগরাপে, অকা আল্গাতে বুঝা নামআ, ইঙ্কান জাগার কাপে গামেয়া, এন্খান কিনা গাম বুঝাপে তানা, এন্খান ইনা চিল্কাতে সারি নামেয়াপে? আপে গাম কেৎআপে হেৎদ যাহায় কাপে বুঝা দাড়িলাৎআ। ");
INSERT INTO cdz_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","হুই দাড়িয়া ধার্তি রে আন্তীত লেকা আড়াং মেনা আ, হেৎদ অর্থহীন জাহানা বায়ায়না। ");
INSERT INTO cdz_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","বেশ, ইঞ যদি আড়াং কু রাঃআ অর্থ কাঞ সারিয়া আ, তবেখান অকয় গামেয়ায়্য়, ইনি রাঃআ হান্ডে ইঞদ বর্ব্বর লেকাইঞ হুইঅআ, হেৎদ ইঞাঃআ হান্ডে হানি জাগারিচ হঅ বর্ব্বর লেকা হুইঅয়ায়্য়্। ");
INSERT INTO cdz_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","এন্খান আপে চিন্তং নানা হুনার আত্মিক বরদাড়ি নাম নাতিনাং স্যাপড়া পে, ইন্তং কুরু মূটুইপে, যাতে মন্ডলীকে গাথা রাকাপ নাতিনাং আশিসষ পে। ");
INSERT INTO cdz_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","নিয়া নাতিনাং অকয় মান্মি এটা ঠার তে থুতিয়ায়্, হানিদ বিন্তি কা আয়, যাতে অর্থ বুঝা তুকা দাড়িয়া কুকায়। ");
INSERT INTO cdz_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","চিয়া চি ইঞ যদি এটা ঠার তেঞ বিন্তিয়া, এন্খান ইঞআ আত্মা বিন্তিয়ায়, মেন্খান ইঞআ বুদ্ধিদ বেকারআ। ");
INSERT INTO cdz_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","এন্খান কিনাঞ চিকায়াআ? ইঞ আত্মা তে হঅঞ বিন্তি য়াআ, বুদ্ধি তে হঅঞ বিন্তিয়া; আত্মা তে হঅঞ দুরাং য়েয়া, বুদ্ধি তে হঅঞ দুরাং য়েয়া। ");
INSERT INTO cdz_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","বাংখান আম যদি আত্মাতে মানতগুনাৎয়েয়াম, এন্খান আয়ুম হড় অকয় কায় বুঝায়, ইনিদ চিল্কাতে আমাঃ আ সারাওরে 'আমেন (পুরায়না) গামেয়ায়্য়? আম কিনা আ গামে তানাম, ইনা মাত ইনি কায় সারিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","মেন্খান আম মাত বুগিন লেকাতে সারাও এমাই তানাম ঠিক, মেন্খান আয়ুম হড় কুকে মাত কাঃম গাথা রাকাপকুতানা। ");
INSERT INTO cdz_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ইঞ ঈশ্বর রাঃআ সারাওএ তানাঞ, আপে জ্ত্ হড়কু হাতেৎ ইঞ গাদা লেকা এটা ঠার তেঞ থুতি তানাঞ মেন্তে; ");
INSERT INTO cdz_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","মেন্খান মন্ডলী তালারে, এটা ঠারতে দশ হাজার থুতি কুরা জাগার হাতেৎ, বরঞ্চ বুদ্ধিতে মড়েয়া থুতিঞ জাগার বুঝাইঞ তানা, যাতে এটা হড় কুকে হঅ চেচেদাঞ এম দাড়িয়া কুকাইঞ। ");
INSERT INTO cdz_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","এ বকঞ হেৎদ মিশিঞ তুকু, আপেদ বুদ্ধিতে আল্পে হুডিং হনঃঅ লেকা হ্যুয়ুআ, বরঞ্চ হিংসাতে হুডিং হন লেকা হ্যুয়ুপে, মেন্খান বুদ্ধি তে পাক্লঅঃ পে। ");
INSERT INTO cdz_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","রিলামালা আরিচালিরে অল মেনা আ 'ইঞদ এটা আ ঠার তে থুতিয়ান হড়কু লিয়া হেৎদ এটা দিশুম রিঙ্কূ হড় কুরাঃআ লুটিতে নিকু যাইত কু রাঃআ হান্ডে জাগারাঞ হাঞ আ, মেন্খান ইঙ্কা কাতে রহ অ হাঁঙ্কূ জাগার কাকু আয়ুমেয়া, নিয়া দ প্রভু জাগার কেৎ আ। ");
INSERT INTO cdz_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","তবেখান ইঙ্কূ এটা এটা ঠার পাতিয়ান হড় কু নাতিনাং দ ল্হয়, বরংচ কাপাতিয়ান হড় কু রাঃআ নাতিনাং চিন্হা লেকাগে; মেন্খান ভাবিজাগারদ কাপাতিয়ান হড়কু নাতিনাংদ ল্হয়, বরংচ পাতিয়ান হড়কু রাঃআ নাতিনাংগে। ");
INSERT INTO cdz_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","এন্খান যত মন্ডলী মিৎ থাংরে গে দুপ হুন্ডি কাতে যদি যত হড়কু এটা এটা ঠার তেকু থুতিয়া, হেৎদ হুডাং লেকা কাআ পাতিয়ান হড়কু তাহিনা, এন্খান ইঙ্কূ দচি কাকু গামেয়া, যে আপেদ পাগলা হড় তানাপে। ");
INSERT INTO cdz_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","মেন্খান যত হড় যদি ভাবি জাগারেয়া কু হেৎদ যাহায় কাআ পাতিয়ান হড় চি বাহার রিঙ্কূ হড় কু ভীতির বলনা, তবেখান ইনিদ যত হড় রাঃআ ভাবি জাগার মাধ্যমতে দষী মেন্তে লেখাআয়। ইনিদ যত হড় রাঃআ ভাবি জাগার লিয়া দরবার রে তিঙ্গুনায়, ");
INSERT INTO cdz_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","চিন্তং ইঙ্কূ বাহার রিঙ্কূ হড়কু আয়ুমেয়াকু, ইনিরাআ অন্তরে উকুয়া কানা ভাবকু যত সদর য়া; হেৎদ হেঙ এ নেকা লেকা কাতেগে ইনিদ উকুড়ুম কাতে ঈশ্বর রাঃআ ভজনা য়ায়্, গামেয়ায়্, ঈশ্বর সার্তি গে আপেয়া তালারে মেনাইয়া। ");
INSERT INTO cdz_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","পাতিয়ান ব্কঞ তিকু হেৎদ মিশিঞ তিকু এন্খান কিনা আ তিঙ্গুইনা? আপে চিন্তং পে দুপ হুন্ডিয়া, ইন্তং অকয় রাঃআ দুরাং, অকয় রাঃআ উপদেশ, অকয় রাঃআ সার্তি সদর রাঃআ বাব্ব্দ, অকয় রাঃআ এটা ঠারতে জাগার, অকয় রাঃআ অর্থ ব্যাখ্যা, যতয়াগে আত্মিক লেকাতে মন্ডলী রাঃআ গাথা রাকাপ নাতিনাং তাহীন কা আ। ");
INSERT INTO cdz_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","যাহায় যদি এটা ঠারতে জাগারেয়ায়্য়, তবে খান বার হড়, বাংখান বড়জোর আপি হড় কু গামে কা আ, পালি-পালি কাতেগে কু গামে কা আ, হেৎদ মিৎ হড় অর্থ ভাঙ্গা কাতে গামে কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","মেন্খান অর্থ ভাঙ্গানিইচ্ যদি যাহায় কাঃআ তাহিলেন খান এন্খান এটা ঠারতে জাগারিচ মন্ডলী রে থির থার তাহিনঃঅ কাআয়; একেন আয়ায়া নাতিনাং হেৎদ ঈশ্বর লঅ জাগরে কাআয়। ");
INSERT INTO cdz_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","হেৎদ ভাবিজাগারিচ কু বার হড় বাংখান আপি হড় কাতে জাগারে কাআকু। এটা হড় কুদ ইনি কিনা গামকেৎআয় ইনা দরবারে আকু। ");
INSERT INTO cdz_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","মেন্খান অটঃহঅ নেকাগে যাহায় রাঃআ হান্ডে যাহানা সদর র আ, অকয় মিশাতে দুপ মেনাইয়া, তবেখান পুইলা অকয় সদরিচ ইনি দ থির তাহিন কা আয়। ");
INSERT INTO cdz_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","কারন আপে যত হড় মিমিৎ কাতে ভাবিজাগার গাম দাড়ি কাআপে, যেন যত হড় চেদ কা আ কু, হেৎদ যত হড় আশাবাদী হুয়ুকা আ কু। ");
INSERT INTO cdz_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","হেৎদ ভাবিজাগারিচ কু রাঃআ আত্মা ভাবিজাগারকু রাঃআ বশরেকু তাহিনা; ");
INSERT INTO cdz_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","চিয়া চি ঈশ্বরদ গন্ডগোল রেনিচ ঈশ্বর ল্হয়, মেন্খান সুলুক রেনিচ। চিল্কা রীলামালান মান্মি কু রাঃআ মন্ডলী কুরে হুই ভাড়া। ");
INSERT INTO cdz_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","মন্ডলী রে এরা হন কু থির কু তাহীন কা আ, চিয়া আ চি এরা হন কুকে জাগার রাঃআ আদেশ কা এম হুয়াকানা, বরংচ চিল্কা রেয়াজ গামেয়ায়্, ইঙ্কূ অধীন রেকু তাহীন কা আ। ");
INSERT INTO cdz_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","হেৎদ জাহানা আ চেদ নানাম তানা কু খানঃঅ, অড়ারে আকুয়াআ হেরেল কুকে কু কুলি কুকাআকু, কারণ মন্ডলীরে এরাহন কু রাঃআ কুক্লি জাগার গিয়ু রাআ বাবদতানা। ");
INSERT INTO cdz_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","গামেপে মাহীন, ঈশ্বর রাঃআ জাগার দ চি আপেয়া হান্ডে হাতেৎ গে উডুঙ লেনা? চি শুধু আপেয়া হান্ডেগে হিচ্ লেনা? ");
INSERT INTO cdz_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","যদি যাহায় আচ্কেগে ভাবিজাগারিচ বাংখান আত্মিক হড় মেন্তে মনেয়া আ, তবেখান ইনি সারিই কায়ায়্ য়, অকাকু আপেয়া হান্ডে অল কাতেৎ কুলা তাৎ পেয়া, ইনাকু যত প্রভু রাআ হুকুম তানা। ");
INSERT INTO cdz_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","মেন্খান যদি যাহায় হড় অকা কু ইঞ অল তাৎঞ ইনাকু কাকু মানাবাতায়া খানঃঅ, এন্খান ইনি হড় রাঃআ জাগার কু আপে হঅঞ আল্পে মানাবাতায়া। ");
INSERT INTO cdz_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","এন্খান, এ হাগাঞ হেৎদ মিশিঞ তুকু, আপে ভাবিজাগার গাম নাতিনাং স্যাপড়া তাহিন্ পে, হেৎদ এটা ঠারতে জাগার নাতিনাং আল্পে মানা কুয়া। ");
INSERT INTO cdz_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","মেন্খান জ্ত্যাগে সুষ্ট হেৎদ খাটি আরিচালি লেকা হুয়ু কা আ। ");
INSERT INTO cdz_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","এ হাগাঞ হেৎদ মিশি তুকু, ইঞ আপেকে ইনা বুগিন বার্তা সারি তুকা পে তানাঞ, অকা বুগিন বার্তা আপেয়া হান্ডে পাসনা লাৎআ, অকা আপে পে আতাং তাৎআ, আপে অকারে স্থিরা কানাপে; ");
INSERT INTO cdz_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","হেৎদ ইনা লিয়াগে, আপেয়া হান্ডে অকা জাগারতে বুগিন বার্তা পাসনা তাৎ আ, ইনাকু যদি পাতিয়াপে, এন্খান পরিত্রান নাম্কেৎআ পে; বাংখান খালিয়াগে পে পাতিয়ান হড় য়া কানা। ");
INSERT INTO cdz_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ফলতঃ মাড়াং তে আপেয়া হান্ডে নিয়া চেচেদা আ সম্পাতাৎ পেয়া, হেৎদ নিয়া ইঞ হঅ নাম তাৎআ যে, শাস্ত্র লেকাতে খ্রীস্ট আবুয়া কাই নাতিনাং গচেনায়, ");
INSERT INTO cdz_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","হেৎদ তপা তুকালেনায়, হেৎদ শাস্ত্রলেকাতে ইনিদ আপি মাহারে বিরিৎ রুয়াড়া কানায়; ");
INSERT INTO cdz_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","হেৎদ ইনি কৈফাকে, ইনা তায়্ম ইঙ্কূ মিৎগেলে বার চেলাকুকে ভেট এমাৎ কুয়া; ");
INSERT INTO cdz_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ইনা তায়্ম মিশাতে মড়ে চাকি হাতেৎ হঅ বিশি হাগাকুকে ভেট এমাৎ কুয়ায়, ইঙ্কূয়া তালা হাতেৎ কথক কু নাহা হঅ মেনা কুগেয়া, মেন্খান কথক কুদ গচাকানা। ");
INSERT INTO cdz_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ইনা তায়্ম ইনিদ যাকোব কে, হেৎদ যত কুলিচ কুকে ভেট এমাৎ কুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","জ্ত্চ কু রাঃআ তায়্মতে অকাল-জাত অকাল জাত মানে ঠিক সময় রে কাআ জান্মায়াকান হড় লেকানিচ ইঞকে ভেট ইমাইঞায় ");
INSERT INTO cdz_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","চিয়া আ চি কুলিচ কুরাআ তালা হাতেৎ ইঞদ যতয়চ হাতেৎ হুডিং তারিচ তানাঞ, বরংচ কুলিচ গাম তে হঅ যগ্য ল্হয়, কারন ইঞ ঈশ্বর রাঃআ মন্ডলী কুকে কুদা-নীরেত কুকে নাঞ। ");
INSERT INTO cdz_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","মেন্খান ইঞ চিল্কা মেনাঞা, ঈশ্বর রাঃআ অনুগ্রহ লেকাতে মেনাঞা; হেৎদ ইঞকে এমা কানা আয়া আ অনুগ্রহ কাআ বের্থ্কা কানা, বরং ইঙ্কূ যতচ কুরাঃআ হাতেৎ বেশি খাটা কানাঞ; ইঞ খাটা কানাঞ, ইঙ্কাদ ল্হয়, মেন্খান ইঞ লঅ মেনাইআ ঈশ্বর রাঃআ অনুগ্রহ তেগে কামী তাৎ আয়; ");
INSERT INTO cdz_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","এন্খান ইঞগেঞ হ্যুয়েন বাংখান হ্যাঁঙ্কূ গে হ্যুয়েন, আলে চিল্কালে পাসনা কেৎ আ হেৎদ আপে ইঙ্কা গেপে পাতিয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","খুব বেশ, যখন খ্রীস্ট নিয়া লেকাতে গটা পাসনা তানায় যে, ইনিদ গচকু হাতেৎ জিউত বিরিৎআ কানায়, এন্খান আপেয়া তালাকু হাতেৎ হানি নাঃআই চিল্কা তেকু গামেৎ আ যে, গচ হড় কু রাঃআ বিরিৎ রুয়াড় বাঃয়ানা ? ");
INSERT INTO cdz_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","যদি গচ হড় কু রাঃআ জিউত বিরিৎ রুয়াড় বাআয় না তবেখান মাআ খ্রীস্ট হঅ কায় বিরিৎ রুয়াড়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","অটঃহঅ খ্রীস্ট যদি কায় বিরিৎআ কানায়, এন্খান মাত আলেয়া পাসনা হঅ বৃথা গেয়া, হেৎদ আপেয়া আ পাতিয়া হঅ বৃথা গেয়া। ");
INSERT INTO cdz_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","অটঃহঅ আলে যে ঈশ্বর রাঃআ বাবদতে বেদা সাক্ষী হড় তানালে, নিয়াগে সদরঅ তানা; কারণ আলে ঈশ্বর রাঃআ বাব্ত্তে নিয়া সাক্ষ লে এমে তানা যে, হানিদ খ্রীস্ট কে জীউত বিরিৎ তিৎআয়; মেন্খান যদি গচ কু রাঃআ জিউত বিরিৎ কাআ হ্য়ুয়া, এন্খান ইনি হানিকে কায় জীউত বিরিৎ তিৎআয়। ");
INSERT INTO cdz_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","চিয়া চি যদি গ্চাকানাকু হড় কু রাঃআ জীউত বিরিৎ বাআন খানঃঅ, খ্রীস্ট হঅ কায় বিরিৎ রুয়াড়া কানায়। ");
INSERT INTO cdz_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","হেৎদ খ্রীস্ট যদি কায় বিরিৎ রুয়াড়া কান খানে, তবেখান আপেয়া পাতিয়াদ ভিল্কি গেয়া, নাহাঃআ হঅ আপেদ আপন আপিন কাই রে মেনাঃপেয়া। ");
INSERT INTO cdz_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","তবেখান অক্য়্কু খ্রীস্টতে জাপিত তাৎআকু, ইঙ্কূ হঅ নষ্টয়া কানাকু। ");
INSERT INTO cdz_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","শুধু নিয়া জিউরে যদি খ্রীস্টরে দয়া রাআ আশ তাহিনা, তবেখান আবু যত হড়কু তালারে দুর্ভাগা। ");
INSERT INTO cdz_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","মেন্খান বাস্তবরে খ্রীস্ট গচ হড়কু তালা হাতেৎ জীউত বিরিৎআ কানায়, ইনিদ গিতিচাকানাকু তালা হাতেৎ মাড়াং জঃঅ হুইআয়্য়। ");
INSERT INTO cdz_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","চিয়া চি মান্মি খাতির তে গচঅ হিচ্লেনা, ইন্তং মান্মি খাতির তে গচ হড়কু রাঃআ জীউত বিরিৎ হিচা কানা। ");
INSERT INTO cdz_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","কারন আদম রাঃআ পাপ খাতির তে চিল্কা যত হড় কু গচ লেনা, এন্কাগে খ্রীস্ট রে পাতিয়া খাতিরতে যত হড় কু জীউ নামরুয়া ড়েয়া। ");
INSERT INTO cdz_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","মেন্খান যত হড় আকুয়াআ নিজ তাঁড়িতে; খ্রীস্ট দ মাড়াং রে, ইনা তায়্ম খ্রীস্ট রাঃআ হড় কু যত আয়া আ রুয়াড় হিজু মাহারে। ");
INSERT INTO cdz_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ইনা তায়্ম জগত রাঃআ মুচাদঅ য়াআ, ইন্তং ইনিদ জ্ত্চ রাঃআ আইদারী, বাহাদুরী, দাড়িকু নাশ চাবায়াআয়্য়্, হেৎদ বাআ ঈশ্বর রাঃআ তিহিরে পরগনা সম্পায়ায়্য়্। ");
INSERT INTO cdz_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","কারন জামিন মাহা অব্দি বৈরী কুকে ইনি রাঃআ কাটা লাতার রে কায় আগু কুয়ায়্য় ইমিন মাহা অব্দি আচ্কে পারগানা তেগে হ্যুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","মুচাত বৈরী মা গচঃ তানা, ইনা হঅ ধংস য়ায়্য়্। ");
INSERT INTO cdz_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","কারন ঈশ্বরদ জ্ত্যাগে খ্রীস্ট রাঃআ কাটা লাতার্রে দহ তাত্যায়্য়। মেন্খান, যখন গামাকানা, জ্ত্যায়্য় গে খ্রীস্ট রাঃআ কাটা লাতার্রে দহ হুইয়া কানা, ইন্তং সাফা- সাফিয়া কানা, ঈশ্বর কেদ কাঃআয় মেশা কানায়, অকয় দ জ্ত্যা গে খ্রীস্ট রাঃআ তিহিরে সম্পা তাত্যায়্য় ");
INSERT INTO cdz_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","হেৎদ জ্ত্যা গে ঈশ্বর রাআ আয়্দারীরে তাহীন কাতে রহঅ প্রভু আচ নিজ হঅ ঈশ্বর রাঃআ আয়্দারীরে তাহিনায়, অকয় জ্ত্যাগে খ্রীস্টকে আয়্দারি এমাৎ য়ায়্য়্, যাতে ঈশ্বর যত হাতেৎ সরস রে তাহীন কাআয়্য়। ");
INSERT INTO cdz_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","এন্খান, অকয় হড় কু গচ নাতিনাং ডুবানয়া কু, ইঙ্কূ কিনা আ কু চিকায়া ? গ্চাকানা হড় কু রাঃআ বিরিৎ রুয়াড় বাআন খান, এন্খান চিয়ায়্য় ইঙ্কূকে গজ নাতিনাং ডুবান এম হুয়ুয়া ? ");
INSERT INTO cdz_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","হেৎদ আলে চিয়া ঘড়ি ঘড়ি বিপদ রে লে নুরুয়া ? ");
INSERT INTO cdz_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","এ হাগাঞ হেৎদ মিশিঞতুকু, আবুয়া প্রভু যীশু খ্রীস্ট রে আপে লিয়া ইঞা অকা গর্ব মেনা আ, ইনা শপত কাতে গামেতানাঞ, ইঞ সবদিন গজ তানাইঞ ");
INSERT INTO cdz_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","যদি ইঞ এটা হড় লেকাইঞ হঅ ইপিস রেনকু বির পুশু কু লঅ অপতা রেঞ তাহিনা, এন্খান ইঞাঃআ কিনাঃ বেশ হয়ুয়া ? গজ হড় কু রাঃআ যদি বিরিৎ রুয়াড় কা তাহিনা, এন্খান ' দেলা জম নুউ য়াবু, কারন গাপা মা আবু গ্জ্য়াবু । ");
INSERT INTO cdz_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","যাহায় নেকা গামেয়ায় ইনিরাআ জাগার রে আলপে ঠেকা, চিয়াচি খারাপ হড় লঅ মেলা মেশা তাহি লেন্খান বুগিন আচরন খারাপআ ");
INSERT INTO cdz_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ধার্মিক হুই নাতিনাং আকিলঃঅপে হেৎদ কাই রে আল্পে তাহিনয়া, কারন আপে কু তালারে নেকান ক্থ্ক হড় কু মেনাকুয়া অকয় রাঃআ ঈশ্বর বাব্ত্তে আকেল বায়ায়না। ইঞ আপেকে নেকা জাগারেপে তানাঞ, যাতে হুডাং গিয়ু গঅ পে। ");
INSERT INTO cdz_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","মেন্খান, যাহায় কু গামেয়াঃ গজ হড় কু চিল্কা লেকাতে কু বিরিৎ রুয়াড়য়া? চিল্কা লেকান হড়ম তে কু বিরিৎ আ ? ");
INSERT INTO cdz_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","এ বকা ! আম অকা হিতা জাঙ্গ হেরে তানাম, ইনা জাঙ্গ কাআ গজ লেন্খান নামা দারু কাআ গজাউডুংআ। ");
INSERT INTO cdz_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","আপে এমন এন্কানা আ কাপে হের তাৎ আ, অকা হের থরা দারু হারা রাকাপা কানা। বরংচ আপে মিয়াৎ হিতা জাঙ্গ হেরেপে, গহম হুয়ুকাআ বাংখান এটা জাহানা আ হিতা জাঙ্গ; হিতা জাংগ গে মা হেরে তানাপে; ");
INSERT INTO cdz_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","মেন্খান, ঈশ্বর আয়া আ ইচ্ছা লেকাতে হারা রাকাপ তুকাইয়ায়্য় হেৎদ যত গজাকু হারা রাকাপআ, ইনাকু দ যত মিৎ লেকা কাআ নেল য়া। ");
INSERT INTO cdz_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","যত হড় রাঃআ হড়মঅ মিৎ লেকা লহয়। মান্মি হড়মঅ মিৎ লেকা, আসুল পশু রাঃআ হড়মঅ মিৎ লেকা, অড়ে কু রাঃআ হড়মঅ মিৎ লেকা, অটঃহঅ হাকু কু রাঃআ হড়মঅ মিৎ লেকা। ");
INSERT INTO cdz_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","হেৎদ সরগ রেন্কু হড় কু রাঃআ হড়ম মেনা আ, হেৎদ জাগতিক রেহঅ হড়ম মেনা আ; মেন্খান, সরগ রেনকু হড় কু রাঃআ হড়ম গঠন মিৎ লেকা; হেৎদ জাগতিক মান্মি কু রাঃআ হড়মঅ গঠন মিৎ লেকা। ");
INSERT INTO cdz_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","বেলা রাঃআ গঠন মার্শাল মিৎ লেকা, চাঁডুঃ রাঃআ গঠন মার্শাল মিৎ লেকা, ইপিল রাঃআ গঠন মার্শাল মিৎ লেকা; গঠন মার্শাল লেকাতে মিয়াৎ ইপিল হাতেৎ এটা ইপিলকুদ ভেগার গেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","গজাকানাকু হড় কু রাঃআ বিরিৎ রুয়াড় হঅ এনে এঙ্কাগে, মিয়াৎ হিতা জাঙ্গ লেকা হড়মসমেৎ হের হুয়ুয়া, মেন্খান বিনা হড়মঅ তে বিরিৎ রুয়াড় হয়ুয়া ");
INSERT INTO cdz_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ইনিকে গিয়ু সরম লেকাতে হের হুয়ুয়া, মেন্খান মানতান লঅ রাকাপ অআয়, ইনিকে নিজুরি লেকাতে হের হুয়ুয়া, মেন্খান দাড়িয়ান লেকাতে বিরিৎ হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","মায়ম- জিলু হড়ম হের হুয়ু য়ায়্, মেন্খান সরগ লেকানাআ হড়ম বিরিৎ হুয়ুয়া, চিল্কা মায়ম-জিলু রাঃআ হড়ম মেনা আ এনে ইঙ্কা গে সরগ রাঃআ হড়ম হঅ মেনা আ। ");
INSERT INTO cdz_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","শাস্ত্র রে নেএ নেকা হঅ অল মেনা আ 'আদিম মান্মি আদম জিউত জীয়ান। মেন্খান যিশু অকয় মুচাদিচ আদম জিউ এমিচ জিয়ান আত্মা হুয়েনায়। ");
INSERT INTO cdz_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","মেন্খান, মাড়াঙ তে অকা হড়মঅ আবুকে এমা হুইয়াকানা ইনা জাগতিক তানা, মেন্খান অকা হড়মঅ তায়মতে এম গানয়া ইনা দঅ আত্মিক হুইঅয়া। ");
INSERT INTO cdz_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","আদিম মান্মি ধার্তি রাঃআ হাসা ধুড়ি হাতেৎ বানহা লেনায় হেৎদ দশার মান্মিদ সরগ হাতেৎ হিচলেনায়। ");
INSERT INTO cdz_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","চিল্কা ইনি আদিম মান্মি হাসা ধুড়ি হাতেৎ বাইহুয়ুয়া কানা, এঙ্কা গে আবু যতয়চ হড় হাসা ধুড়ি হাতেৎ গে বাইহুয়ুয়া কানাবু হেৎদ চিল্কা দশার মান্মি রাঃআ হড়মঅ সরগ রাঃআ হড়মঅ লেকা এঙ্কাগে আবুয়া হড়মঅ হঅ সরগ রাঃআ হড়মঅ লেকা হুইঅয়া । ");
INSERT INTO cdz_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","হেৎদ আবু চিল্কা ইনি হাসা ধুড়ি রেনিচ ঠাকুর লেকা হুয়ুয়া কানাবু, ইঙ্কা গে সরগ রেনিচ ইনি মান্মি লেকা গেবু হুয়ুয়া ");
INSERT INTO cdz_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","মেন্খান এ হাগা হেৎদ মিশিঞ তুকু, আপে কেঞ গামাপে তানা, মায়ম-জিলু রাঃআ হড়ম তে সরগ তে কাপে সেন দাড়িয়া আ, অটঃহঅ ক্ষয় হড়মঅ অক্ষয়তা হড়ম রাঃআ অধিকার কায় হুই দাড়ি য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","নেলেপে, ইঞ আপেকে মিয়াৎ উকুয়াকান রহস্য গামা লেপেয়াঞ, আবু যত হড় মাত গয়চ রে কাবু গিতিচ তাহিনাবু, মেন্খান আবু যত হড় দঅ উচাড়য়াবু ");
INSERT INTO cdz_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ইন্তংগে হুইঅয়া, মেৎ আরিৎ-জাপিত তেগে, মুচাত রুতু সাডি লঃঅগে, চিয়াচি চিন্তং রুতু সাডিয়া, ইন্তং গচ হড় কু অক্ষয়তা হড়মঅ তেকু বিরিৎ আ হেৎদ আবু উচাড় পারম্যাবু। ");
INSERT INTO cdz_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","কারন অকা আ হেড়য়াআ ইনাকে উচাড় গিডি কাতেত কাহেড়য়া য়ুই তুকা হয়ুয়া, হেৎদ অকা আ গজআ ইনাদ কাঃআ গজআ নাতিনাং উচাড় হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","মেন্খান অকা হেড়য়া ইনা চিন্তং কাহেড় নাতিনাং উচাড়য়া হেৎদ অকা আ গজআ ইনা ইন্তং কাগজআ মেন্তে উচাড়য়া, ইন্তং অলাকানা নিয়া জাগার কু পু রাঃআঃ 'জিতকার গজঅ কে উদ পারম কিৎআয় ");
INSERT INTO cdz_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","গজঅ, আমাঃ আ জিত্কার কদেররে ? গজঅ আমাঃ আ হুল ক্দেরেনা ? ");
INSERT INTO cdz_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","গজঅ রাঃআ সুঁয়া হুয়ু তানা কাই হেৎদ কাই রাঃআ দাড়িদ রীতি । ");
INSERT INTO cdz_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","মেন্খান ঈশ্বরকে সারাঞ এমাই তানা চিয়াচি ইনি আবুয়া আ প্রভু যীশু খ্রীস্ট রাঃআ মাধ্যমতে আবুকে পাপ হেৎদ গয়চ হাতেৎ জিত্কার তাৎবুয়া আ! ");
INSERT INTO cdz_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","এন্তে, এ ইঞা প্রিয় হাগাঞ হেৎদ মিশিঞ তুকু, আপে কাজাগ তে তাহিন্পে, স্থির তাহিন্পে, প্রভু রাঃআ সেবারে মন এমেপে, কারন সারিয়াপে, প্রভু রাঃআ নাতিনাং আপে অকা পে কামী তানা, ইনা দ কাআ নিষ্ফলয়া। ");
INSERT INTO cdz_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","হেৎদ রিলামালা হড় কু রাঃআ নাতিনাং দান হাতা রাঃআ বাব্ত্তে গালাথিয়া টলা কু রাঃআ মন্ডলী কুকে অকা আজ্ঞাঞ এমাৎ কুয়াঞ, আপে হঅ ইনাকু পান্তি ইদিপে। ");
INSERT INTO cdz_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","সপ্তা রাঃআ পুইলা হুলাং আপে যত হড় আপেয়া আয় রাঃআ সম্বল লেকাতে হুডাং কাউডি ভেগার রে দহ তায়াপে, হিচ্ লেনখানিঞ ইঞ কে দান রাকাপ আল হুয়ু কা আ। ");
INSERT INTO cdz_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","মেন্খান ইঞ চিন্তং আপেয়া হান্ডেঞ হিজুয়া, ইন্তং কথক হড় কে জেরুশালেম তেঞ কুল কুয়া, যাতে ইঙ্কূ আপেয়া উদার দান হাতা আগু দাড়ি কা আ কু। আপে আপেয়া অলরে অকয় কুকে পে উদু কুয়া, ইঙ্কূ কেগেঞ কুল কুয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","তবে, ইঞাঃহঅ এন্ডে সেন রাঃআ জরুর মেনা আ মনেঞ খান, এন্খান ইঙ্কূ লঅ এন্ডেঞ সেনঃআঞ। ");
INSERT INTO cdz_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","মেন্খান, ম্যাসিডোনিয়া টলা দর হাতেৎ ঘুরা হিচ্ কাতে আপেয়া হান্ডেঞ হিজুয়া চিয়া চি ম্যাসিডোনিয়া টলা হরকাতেগেঞ হিজুয়া; ");
INSERT INTO cdz_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ইঞ আপে লঅ কিছু মাহা তাহি দাড়িয়াঞ বাংখান রাবাং কাল আপে লঅঞ তাহিনা। ইনা তায়্ম ইঞ জাহাদর গেঞ সেনঃআ, এন্তে সেনঃঅ হুলাং হরা দর কয়ঃঅ কুলিঞ পে। ");
INSERT INTO cdz_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","চিয়াচি নাহাঃআ সেনঃঅ হরারে আপে লঃঅ কাঞ নাপামা, নিয়াদ ইঞাঃআ ইচ্ছা, যদি ঈশ্বর রাঃআ ইচ্ছা তাহিনা এন্খান আপে লঃঅ হুডাং ঘাড়ি তাহি দাড়িআঞ। ");
INSERT INTO cdz_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","মেন্খান, বিরিৎ পারম অব্দি ইফিসেরে তাহিনাঞ, ");
INSERT INTO cdz_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","কারন প্রভু রাঃআ কামী নাতিনাং ইঞাঃআ সামাং রে গাদা মারাং দুয়ার নিচ্চা কানা। অব্শ্য নিয়া কামিরে গাদা বিরোধ মাত মেনাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","তিম্থিয় যদি আপেয়া হান্ডে হিজু য়ায়্, এন্খান নিয়া ব্যাপার রে খেয়াল ধহয়পে, যেন আপে লঃঅ তাহি কালীন জাহানাঃআ জিনিষ কুতে আল্য়য় বরয় কাঃআয়, চিয়া চি ইনিদ ঈশ্বর রাঃআ কামিই তানায়, চিল্কা ইঞিঞ কামী তানা, ");
INSERT INTO cdz_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","এন্তে যাহায় যেন ইনিকে টেরা মেত্তে আলকু নেলি কাঃআ, মেন্খান ইনিকে সুলুকতে আধাধুরা হরাকু উদুঃয়াই পে, যাতে ইনি ইঞাঃআ হান্ডে সেটের দাড়িঃ কাঃআয় চিয়া চি ইঞ হেৎদ হাগাকুলে আয়ায়া নাতিনাং তাঙ্গিরেলে মেনাঃলেয়া। ");
INSERT INTO cdz_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","অটঃহঅগে ইঞ আবুয়া হাগা আ আপৌল্লো রাঃআ বাব্ত্তেঞ গামেতঃআ। ইঞ ইনিকে হাগা কু লঅ সেন নাতিনাং বিন্তি লিয়াঞ। মেন্খান নাহাঃআ আপেয়া হান্ডে সেন রাঃআ মন বাআয়না ইনি রাঃআ, মেন্খান অক্ত নাম লেখানে সেন্যায়। ");
INSERT INTO cdz_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","চির্গাল তাহীন পে, পাতিয়ারে কেটেচ তাহিন্পে, সাহসঃঅ পে, দাড়িয়ান নঃঅপে। ");
INSERT INTO cdz_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","আপে জাহানাগেপে কামিয়া দুলাড় লঅ কামিইপে। ");
INSERT INTO cdz_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","আপে সারিই গেয়াপে, আখায়া টলা রে স্তিফান রাঃআ অড়া রেন্কু হড় কুদ মাড়াঙতে খ্রীস্ট রাঃআ অনুগামী হুই লেনাকু হেৎদ ইনা তায়ম রিলামালা হড় কুকে সেবা নাতিনাং নিজেকে কু সম্পা লেনা। ইনাতে এ ব্কঞ হেৎদ মিশিঞ তেকু, আপেয়া হান্ডেঞ বিন্তি তানাঞ; ");
INSERT INTO cdz_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","আপে হঅ এনে এনকান হড় কুরাআ হেৎদ অক্যয় দেঙ্গাকু এমেয়া হেৎদ প্রভু রাঃআ নাতিনাং কুঠিন খাটাকু, ইঙ্কূয়া বাগতরে তাহিন্পে। ");
INSERT INTO cdz_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","মেন্খান স্তিফান, ফর্তুনাত হেৎদ আখায়িক নেডেকু হিচ্লেনা মেন্তে ইঞ খুব কুশি, চিয়া চি আপে চিন্তং কাপে তাহিলেনা ইন্তং ইঙ্কূ ইঞকে গাদা কু দেঙ্গা তিইঞা। ");
INSERT INTO cdz_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ইঙ্কূ ইঞকে হেৎদ আপেয়া আত্মাকে গাদা আগ্রহী তাৎবুয়াকু। ইনাতে আপে নেকান হড়কুকে ঠাহর কাতে মান্ন্তা কূপে ");
INSERT INTO cdz_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","এশিয়া মুলুক রিঙ্কূ মন্ডলী তরফ হাতেৎ আপেকে মানত জহারকু এমাপে তানা, আক্কিলা হেৎদ প্রিস্কা হেৎদ ইঙ্কূয়া জাহের মন্ডলী রিঙ্কূ যত হড় আপেকে ঢের গাদা আত্মাগুন জহার কু এমাপে তানা। ");
INSERT INTO cdz_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","হেতৎদ যত পাতিয়ান হাগা মিশি কু হঅ আপেকে গড় জহার কু এমাপে তানা। আপে হঅ আপন আপিন কুকে রিলামালান দুলাড়তে সুলুকজহার এমা কূপে। ");
INSERT INTO cdz_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ইঞদ পৌল তানাঞ, ইঞ নাহাঃআ নিজ তিহিতে আপেকে গুন জহার এমাপে তানাঞ। ");
INSERT INTO cdz_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","প্রভু রাঃআ নাতিনাং যদি যাহায় রাঃআ দুলাড় কা আ তাহিনা, ইন্খান ইনিদ শাপগ্রস্ত হুয়ু কাঃআয়। এ আলেয়া প্রভু দেলা হিজুম। ");
INSERT INTO cdz_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","প্রভু যীশু রাঃআ মারাংদায়া আপে লঅ তাহীন কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","যীশু খ্রীস্ট রে ইঞাঃআ দুলাড় আপে জ্ত্চকু লঅ তাহীন কাঃআ। আমেন ।");
INSERT INTO cdz_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","ইঞ পল, মিতহড় কুলিচ, যাহায় মান্মি হাতেৎ দ ল্হয়, বরং যীশু খ্রীস্ট হেৎদ ঈশ্বর বা তেগেঞ বহালা কানাঞ, অকয়দ খ্রীস্ট কে গচ কু তালা হাতেৎ বিরিৎ রুয়াড় লিঃইআয়। ");
INSERT INTO cdz_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ইঞ হেৎদ ইঞ লঅ এটা হাগাকু মেনা কুয়া, আলে গালাতীয়া মুলুক রিঙ্কূ মন্ডলী কুকে লে গিরা অলা কু তানা। ");
INSERT INTO cdz_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","আবুয়া আ ঈশ্বর হেৎদ প্রভু যীশু খ্রীস্ট যাতে আপেকে দায়াদুলাড় হেৎদ সুলুক নিরাঃআই দানাপেকা আয়। ");
INSERT INTO cdz_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","আবুয়া ঈশ্বর রাঃআ মেন্ লেকাতে খ্রীস্ট আবুয়া আ কাই নাতিনাং আয়া আ নিজ রাঃআ জীউ দান তাৎআয়, যাতে ইনি আবুয়া আ (কুব্যবস্থা) বাড়িচযুগ হাতেৎ বাঞ্চা বুকাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","যুগ যুগ আটকাল ঈশ্বর রাঃআ মহিমা হযু কাঃআ। পুরাম। ");
INSERT INTO cdz_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ইঞ গাদাঞ হাড়াতানা চি, অকয় খ্রীস্ট রাঃআ দায়াদুলাড় আপেকে রাঃআ কেৎ পেয়ায়্য়, ইনি ধার্তিআপু রাঃআ হান্ডে হাতেৎ আন্তীত ঘিড় মেন্তাং সরাঃআ সঙ্গী হিচ্ কাতে আপে এটা অটঃ মিয়াৎ বেদা জাগার পে আয়ুমেৎআ। ");
INSERT INTO cdz_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","মেন্খান এটা জাহান বুগিন সমাচারদ ল্হয় তানা; বরং এনে এঙ্কান কথক হড় মেনাকুয়া, খ্রীস্ট রাঃআ বাব্ত্তে অকা বুগিন সমাচার মেনা আ, ইনাকু কুতশ্রীৎ লেকাতে মনগড়া কাতেত আপেকে এটা হরতে তিয়াগেৎ পেয়াকু। ");
INSERT INTO cdz_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","মেন্খান আলে অকা আপেয়া হান্ডে বুগিন সমাচার লে পাসনা তাৎআ, ইনা হাতেৎ যাহায় যদি এটা লেকা আপেয়া হ্যান্ড বুগিন বেদা সমাচার কু পাসনা য়া, আলেকু লেকান যাহায় চি সরগ নাগাকু, এন্খান ইঙ্কূ স্যাপ গ্রহস্ত কু হয়ু কাআ। ");
INSERT INTO cdz_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","ইঞ চিল্কা মাড়াংতেঞ জাগার লাত আ এঙ্কাগে অটঃহঅঞ নাহাঃ জাগার তানা আপে অকা বুগিন সমাচার পে আতাং তৎ আ, ইনা হাতেৎ এটা লেকানা আ যাহায় বুগিন বেদা সমাচার কু এমাপেয়া, তবেখান ইনিদ স্যাপগ্রহস্ত কাআয়। ");
INSERT INTO cdz_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ইঞদ চি মান্মি রাঃআ হান্ডে হাতেৎ স্কৃতি হাতা নাতিনাং কুরুমুটু তাৎআঞ চি ঈশ্বর রাঃআ হান্ডে হাতেৎ স্কৃতি হাতা নাতিনাং কুরুমুটু তাৎআঞ ? চি কিনাআ ইঞদ চি মান্মিকে খুশি তুকা নাতিনাং কুরুমুটু তাৎআঞ ? যদি নাহাঃহঅ মান্মিকে খুশি তুকা নাতিনাং কুরুমূটু লাআঞ, এন্খান ঈশ্বর রাঃআ দাস কাইঞ হুই কঃআঞ। ");
INSERT INTO cdz_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","চিয়াচি এ হাগাং তিকু, ইঞ আসঃঅ তানাঞ আপে সারিয়াপে যে, ইঞ অকা বুগিন সমাচার আপেয়া হান্ডে পাসনা তাৎ আঞ ইনাদ যাহায় মান্মি রাঃআ হান্ডে হাতেৎ দ ল্হয়; ");
INSERT INTO cdz_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","চিয়াচি ইনা বুগিন সমাচারদ যাহায় মান্মি রাঃআ হান্ডে হাতেৎ কাইঞ নাম তাৎআঞ, যাহায় মান্মি কাকু চেৎ তিইঞা, বরং যীশু খ্রীস্ট ইঞা হান্ডে সদর তৎআয়. ");
INSERT INTO cdz_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","চিন্তং ইঞ জিহুদী ধরমরে ঞ তাহীন কেনা, ইন্তং চিল্কাঞ আচারনেৎ কেনা ইনা মাত যত হড়গেপে আয়ুম সারি তাৎআ। ইঞ ঈশ্বর রাঃআ মন্ডলী কুকে কুঠিন গেঞ হামলাৎ কু কেনাঞ হেৎদ ইনা মন্ডলী কুরাঃআ গাদা খান্ডাজ ন্ডূজ তাত্যাঞ; ");
INSERT INTO cdz_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","ইঞ পিড়ি হাপড়াম কুরাঃআ রীতি রেয়াজ কুরে কুঠিন উদ্যোগ তাহীন কেনা, ইনাতে ইঞাআ জ্ঞাতী রেন্কু ইঞাআ সমান উঁবুর মান্মি হাতেৎ জিহুদী ধর্ম কে গাদা উন্নতিরে রাকাপ লিইআঞ। ");
INSERT INTO cdz_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","মেন্খান ঈশ্বর, অকয় রাঃআ নাতিনাং তে মাই রাঃআ লাহিচরে হিচু মাড়া হাতে ভাছা দহ লিইঞা হেৎদ মাই হড়ম হাতেৎ ভিনা কাতে নিয়া ধার্তি তেঞ হিচা কানা হেৎদ অকয় রাঃআ দায়াদুলাড়তে ইঞকে রারাঃআ হয়ুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","ইনি ইঞাঃআ হান্ডে আয়াঃআ হনকে সদরিয়ায়্য়, যাতে অইহুদি হড় কু রাঃআ তালারে আয়ায়্য়্ হন রাঃআ বাব্ত্তে বুগিন সমাচার পাসনায় কাঃআঞ। ইনি চিন্তং ইঞকে নিয়া কামী নাতিনাং রাস্কাতে বাছা তিইঞাআ, ইন্তং ইঞ যাহায় রাঃআ হান্ডে হাতেৎ পরামর্শ কাঞ হাতা তাৎআ; ");
INSERT INTO cdz_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","যীরুশালেমরে অকয় কুলিচ্কু মেনাঃআ কুয়া ইঙ্কুয়া হান্ডে হঅ কাঞ সেনা কানা, অক্য়্কু ইঞাঃআ মাড়াং হাতেৎ কুলিচ মেন্তেকু বহালাকানা। বরং আরব দিসুম রুয়াড় সেএনাইঞ হেৎদ ইনা তায়্ম দামেস্কা সরগ নাগার তেঞ রুয়াড় সেএনাঞ। ");
INSERT INTO cdz_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ইনাতায়ম পিতার লঅ নাপাম নাতিনাং অপি সির্মাং তায়্ম জেরুসালেমতে সেএনাঞ, ইনি লঅ এন্ডে 15 মাহা তাহি কেনাঞ। ");
INSERT INTO cdz_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","মেন্খান হান্ডে এটা যাহায় কুলিচ কুকে কাঞ নেল নামলাত কুয়া, প্রভু রাঃআ হাগা যাকোব কেগে নেল নামতি য়াঞ। ");
INSERT INTO cdz_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ঈশ্বর সাক্ষি মেনাঃইআ, আমকে অকা অকাকুঞ অল তাৎআঞ, ইনাকু জ্ত্যাঃ অল বেদা ল্হয় তানা। ");
INSERT INTO cdz_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ইনা তায়্ম ইঞ সিরিয়া হেৎদ কিলিকিয়া দিসুম রাঃআ হানা নাআ হাতুটলা তেঞ সেনলেনা। ");
INSERT INTO cdz_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","মেন্খান জিহুদী দিসুম কুরাঃআ পিড় মন্ডলী কুতে খ্রীস্ট রাঃআ অকয় নেলআতেন হড়কু তাহীন কেনা ইঙ্কূ লঅ কয়ঃঅ নাপাম চিন্হা কা তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ইঙ্কুদ নিয়া জাগার কু আয়ুম লাৎআ, যে অকয় হড় আবুয়াঃআ ধরম ধংস নাতিনাং হিচু কেনায়, হেৎদ নিয়া মাড়ংতে গাদা তড়না এম তাৎআয়, ইনি নাহাঃআ বুগিন জাগার পাসনায় তানা। ");
INSERT INTO cdz_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","এন্খান্গে ইঞ লঅ অকা ঘটনা কু ঘটা লেনা, ইনা নাতিনাং ইঙ্কূ ঈশ্বর রাঃআ গুনমানত জহারেৎআ কু। ");
INSERT INTO cdz_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","গেলেপুন সির্মাং তায়্ম, বার্নাবাস কে ইদি কাতে অটঃহঅগে জেরুসালেমতে সেএঃনাঞ হেৎদ তিতকে হঅ ইঞ লঅ ইদি ধরাঃআ লিঃইআঞ। ");
INSERT INTO cdz_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ঈশ্বর রাঃআ সদর বাত্লা লেকাতেঞ হান্ডে সেন লেনাঞ। হান্ডে গুনমান হাগা মিসি কু লঅ নাপাম লেনাঞ হেৎদ ইঙ্কূকে ইনা বুগিন জাগার বাব্ত্তে গামা তাৎ কুয়াঞ, অকা ইঞ বিন যিহুদি কুরাঃআ তালারে পাসনা তানাঞ। মেন্খান মানতান মন্ডলী আগুয়ান কুরাঃআ হান্ডে দ উকু দহ কেৎআঞ, চিয়া চি সারি বুঝাইঞ কেনা, ঈশ্বর রাঃআ নাতিনাং যে কামীইৎ কেনাঞ, কামীটা বেসা চি ল্হয়। যদি বেশ ল্হয়, এন্খান বৃথক ইঞাঃআ কামী। ");
INSERT INTO cdz_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","হেৎদ চি, তীত, অকয় ইঞ লঅ তাহিলেনায়, ইনিদ গ্রীক হই কাতে রহঅ সুনু গেত নাতিনাং কালে পাতিয়া দাড়ি তুকা তিয়া। ");
INSERT INTO cdz_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","উকু উকুতে হিচা কানাকু ইঙ্কূ কথক হড় ভন্ড হাগা মিসি কু নাতিনাং নেকা হ্যুয়েনা; খ্রীস্ট জিশুরে আবুয়াঃআ অকা স্বাধীন মেনাআ, ইনা রাঃআ গুন্হা পাঞ্জা নাম নাতিনাং ইঙ্কূ উকু উকুতে কু বলঃঅ হিচা কানা, যাতে আবুকে দাস কাতেকু দহ দাড়িযাবু কাঃআকু। ");
INSERT INTO cdz_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","আলে মিৎ টুঢাং হঅ ইঙ্কূ য়া অধীনতা কালে মানা তাৎআ, যাতে বুগিন বার্তা রাঃআ সার্তিতা আপেয়া হান্ডে তাহীন কাআ। ");
INSERT INTO cdz_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","হেৎদ অকয় কু মানতান মেন্তে কু সদর তানা ইঙ্কূ ইঞাঃআ হান্ডে জাহান হক বাআয় না, ইঙ্কূ চিল্কান হড় কু তাহি লেনা, ইঙ্কূ লিয়া আলেয়া জাহানা কা বুহাল সেনা, ঈশ্বর মান্মি রাঃআ ধরবার কায় নেলেয়ায়। ইঙ্কূ মান্তান হড়কুদ ইঞকে জাহানাআ কাকু এমাঞ তানা; ");
INSERT INTO cdz_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","বরংচ ইনাতে নেলেনা,অসুনু গেত ইহুদি কু রাঃআ তালারে ইঞ কে চিল্কা বুগিন বার্তা পাসনা রাঃআ ভার এম হ্যুয়েনা এঙ্কাগে সুনু গেত ইহুদিকু রাঃআ তালারে পিতর কে হঅ এনেএঙ্কাগে এম হ্যুয়া কানা ");
INSERT INTO cdz_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","চিয়াচি সুনু গেৎ ইহুদি কুরাঃআ হান্ডে কুলতিইচকামী নাতিনাং ঈশ্বর পিতর রাঃআ কামী পুরাঃআ তাৎ আয়, এঙ্কাগে ইনি বিনইহুদি নাতিনাং ইঞ কে লিয়া হঅ কামী পুরাঃআ কেৎ আয়। ");
INSERT INTO cdz_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","চিন্তং ইঙ্কূ সারি নামকেৎআকু যে ইঞকে ইনা দায়াদুলাড় এমাকানা, ইন্তং যাকোব, কৈফা হেৎদ যোহন অক্য়্কু গুপিচকু লেকা চিহ্নামেনাকুয়া, ইঞকে হেৎদ বার্নাবে কে সহভাগিতা রাঃআ ম্যাডী তিহিকু এমাৎলিঞাকু, যাতে আলিঞ বিনইহুদি কুরাঃআ হান্ডে সেনা, হেৎদ ইঙ্কূ দ সুনুগেৎ কু রাঃআ হান্ডে কু সেনআ; ");
INSERT INTO cdz_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","আসিতানাকু যাতে আলে রেগেঁচ হড় কুকেলে পাহাম কুকাঃআ; ইনা কামী নাতিনাং ইঞহঅ স্যাপড়াঞ তাহি লেনা। ");
INSERT INTO cdz_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","মেন্খান কৈফা চিন্তং অন্তিয়াখিয়া দিসুম রে হিচ্ লেনায়, ইন্তং আয়া আ মচা চেতাং রে থুতি কেৎআঞ, চিয়া চি ইনিদ অপরাঃআধী তাহি লেনায়। ");
INSERT INTO cdz_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","যাকোব রাঃআ হান্ডে হাতেৎ কথক হড় হিচু রাঃআ মারাঃআং তে কৈফা বিনইহুদি কু লঅ জম নু এৎ কেনায়, মেন্খান ইঙ্কূ হিচ্ তায়্ম সুনু গেৎ কুরাঃআ বরতে উকুরে হেৎদ বিনইহুদি হাতেৎ ভেগাররে তাহিন তানায়। ");
INSERT INTO cdz_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","হেৎদ কৈফা লঅ এটা যত ইহুদি পাতিয়ান হড় কু হঅ ভণ্ডা আচরন কেৎআকু; এন্খান দ চি, বার্নবা হঅ ইঙ্কূ য়া ভণ্ডামিতে লিল্কা নায়। ");
INSERT INTO cdz_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","মেন্খান ইঞ চিন্তং নেল কেৎআঞ,ইঙ্কূদ বুগিন বার্তা রাঃআ সার্তি সরল হরাঃআতে কাকু সেসেন তানা, ইন্তং জ্ত্চ রাঃআ হাজিরাঃআনরে কৈফাকে কুলি কিচআঞ, আম ইহুদি হুই কাতে রহঅ ইহুদি লেকা ল্হয়, মেন্খান এটা জাতি বিন ইহুদি লেকা আচরন তামাআ, তবেখান চিয়াআ বিনইহুদি কুকে ইহুদি কু লেকা আচরন নাতিনাং জোরেৎ কুয়াম? ");
INSERT INTO cdz_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","আলেদ জাতিরে ইহুদি, আলে এটা জাতি বিনইহুদি কাই ল্হয়; ");
INSERT INTO cdz_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","আটকার তাৎআঞ, ব্যবস্থা কামী লিয়াদ ল্হয়, যীশু খ্রীস্ট কে পাতিয়া রাঃআ মাধ্যম তে মান্মি ধার্মিক মেন্তে কু লেখাঃআ, ইনা নাতিনাং আলে হঅ খ্রীস্ট যীশুরে পাতিয়া কানালে, যাতে ব্যবস্থা রাঃআ কামীতে দ ল্হয়, মেন্খান খ্রীস্ট কে পাতিয়া নাতিনাং ধার্মিক লেখা হয়ুয়াঞ; চিয়া চি ব্যবস্থা রাঃআ কামী নাতিনাং যাহা হড়ম ধার্মিক মেন্তে কাকু লেখাআ। ");
INSERT INTO cdz_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","মেন্খান আবু খ্রীস্ট রে ধার্মিক লেখা হুই রাঃআ কুরু মূটুই কাতে রেহঅ আবুকে যদি কাই ী মেন্তে চিপ্না বু এমেয়া, এন্খানদ্ খ্রীস্টদ্চি কাই রাঃআ দাস তানায়? ইনাদ এঙ্কা একেবারে লহয়গে! ");
INSERT INTO cdz_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","চিয়া চি ইঞ অকাঃআ নীতি লাঁন্ধুড় গিডি তৎআঞ, ইনা অটহঅগে গাঁথা রুয়াড় লেখা নিঞ, এন্খান ইঞকেগে অপরাঃআধী মেন্তে জাহির কেৎআঞ। ");
INSERT INTO cdz_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ইঞ মাত ব্যবস্থা লিয়াগে ব্যবস্থা রাঃআ উদ্দেশ তেগেঞ গ্চাকানা, যাতে ঈশ্বর রাঃআ উদ্দেশ তেগে জীউৎ আঞ। ");
INSERT INTO cdz_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","খ্রীস্ট লঅঞ ক্রশা কানাঞ, ইঞদজীউৎ হড় ল্হয়, মেন্খান খ্রীস্টদ ইঞাঃআ তালারেজীউৎ মেনইয়া; হেৎদ নাহাঃআ হড়মতে মেনাঞরে অকা জিউ মেনঃআ, ইনাদ ইঞাঃআ পটিয়াতে, ঈশ্বর রাঃআ হনরে পাতিয়া তেগে জীউৎ মেনাইঞা; ইনিগে ইঞকে দুলাড় কিইঞায়, হেৎদ ইঞ নাতিনাং আচ নিজেকেগে সম্পা কিইযায়। ");
INSERT INTO cdz_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ইঞ ঈশ্বর রাঃআ দায়াদুলাড় কাঞ বিফল তুকাঃআ; কারন ব্যবস্থা লিয়া যদি ধার্মিক হুই কআ, তবে খান খ্রীস্ট দ চি অকারন তে গ্চাকানায়? ");
INSERT INTO cdz_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","এ লেলাঃআ গালাতীয়্কু, অকয় আপেকে মুহিনী কেৎপেয়ায়্য় ? আপেয়া মেৎসামাং রেগেত যীশু খ্রীস্ট ক্রাশ রে হাকা লেনায় মেন্তে সপাস্যফি দ চি কা অল তাহি লেনা? ");
INSERT INTO cdz_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","নিয়া থুতি আপেয়া হান্ডে হাতেৎ সারি বুঝাঞ তানা, আপেদ চি ব্যবস্থা রাঃআ কামী খাতির রিলামালা আত্মাকে নামতিয়া পে ? চি পাতিয়া রাঃআ বার্তা আয়ুম কাতে ? ");
INSERT INTO cdz_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","আপেদ চি নান্তীত লেলাঃআ? রিলামালা আত্মাতে এতহব কাতে নাহাঃআ দ চি জিলু তে মুচাৎ এৎআপে ? ");
INSERT INTO cdz_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","আপে আন্তীত দুঃখ দ্চি খালিগেপে সাহা লাআ ? যদি সর্তিগে বেদা হয়ুয়া ? ");
INSERT INTO cdz_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","গামেপে মাহীন, অকয় ইনি ইশ্বর আপেকে রিলামালা আত্মা যোহড় এমাপে তানায় হেৎদ আপেয়া তালারে হাহাড়া কামিকু পুরাঃআয় আগুই তানায়, ইনি দ্চি ব্যবস্থা রাঃআ কামী পুরাঃআ নাতিনাং ইনা করাঃআৎআয়? দচি পাতিয়া রাঃআ বুগিন বার্তা আয়ুম কাতে ? ");
INSERT INTO cdz_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","শাস্ত্র গামেয়া চিল্কা অব্রাহাম ঈশ্বরকে পাতিয়া লিঃআয়, হেৎদ ইনাগে আয়াঃআ পক্ষে ধার্মিক মেন্তে লেখায়না। ");
INSERT INTO cdz_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","তবেখান সারিই পে, অক্য়্কু পাতিয়ান হড় ইঙ্কূ গে অব্রাহাম রাঃআ হন, ");
INSERT INTO cdz_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","অটঃহঅ পাতিয়া খাতির ঈশ্বর এটাআ জাতি বিনইহুদি কুকে ধার্মিক মেন্তে লেখাতাৎ কুয়ায়্য় য়, শাস্ত্র মাড়াং হাতেৎ অব্রাহাম রাঃআ হান্ডে সদর কাতে বার্তা পাসনা লেনা, নেকা, আমাঃআ তালাতে যত যাইত রেন্কু মান্মি আশ্বীশভর কু নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","তবেখান অক্য়্কু পাতিয়াভর, ইঙ্কূ পাতিয়ান হড় অব্রাহাম লঅ আশ্বীশভর কু হ্য়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","সার্তি কায়তে অকয় কু ব্যবস্থা তে তল মেনা আ কুয়া, ইঙ্কূ যত হড় অভিসাপ রাঃআ ধিনরে, চিয়া চি অল মেনা আ 'যাহায় গে ব্যবস্থা পুথিরে অলা কানা যত থুতি মানায় নাতিনাং আয়ায়্য় মন থীর কা তাহিনা, ইনিদ অভিসপ্ত । ");
INSERT INTO cdz_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","মেন্খান মসি রাঃআ ব্যবস্থা মানান গুনান লিয়া যাহায় গে ঈশ্বর রাঃআ মেৎতে ধার্মিক মেন্তে কাকু লেখাআ, নিয়াদ সাপাসাপি, চিয়া চি ' ধার্মিক মান্মি পাতিয়া খাতির তেয় বাঞ্চাআয়। ");
INSERT INTO cdz_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","মেন্খান ব্যবস্থা পাতিয়া লেকানাআ দ ল্হয়, বরংচ 'যাহায় গে নিয়াকু মানায় য়েয়ায়্য়, ইনিদ ইনাতে বাঞ্চাআয়। ");
INSERT INTO cdz_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","খ্রীস্ট গে গনঙ্গ এম কাতে আবুকে ব্যবস্থা রাঃআ স্ব্যাপ হাতেৎ ছাডা তাৎ বুয়ায়, চিয়া চি ইনিদ আবু নাতিনাং স্ব্যাপরুপী হুই লেনায়; চিল্কা রিলামালা শাস্ত্ররে অল মেনা আ, অকয় কে দারুরে কু হাকা কুয়া, ইনিদ অভিসপ্ত, ");
INSERT INTO cdz_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","চিল্কা অব্রাহাম রাঃআ নামাকান আশিস খ্রীস্ট যীশুতে এটা জাতি বিন ইহুদি কুরাঃআ হান্তে হিযুতানা, আবু যাতে পাতিয়া লিয়া অঙ্গীকৃত আত্মাকে নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","এ হাগাকু, ইঞদ মান্মি লেকাঞ জাগার তানা। মান্মি রাঃআ নিয়ম সেকাম হুই কাতে রহঅ ইনা চিন্তং গটাআ, ইন্তং যাহায় কাকু অমান্যয়া, ইনারে নামা জাহানাআ কাকু মেসায়া। ");
INSERT INTO cdz_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","বেশ, অব্রাহাম কে হেৎদ আয়ায়্য় কুল কুকে এক্ড়ার উছান হুই লেনা। ইনি গাদাহড়কুতে 'হেৎদ যত কুল কুরাঃআ মেন্তে কা গাম কাতে, মিৎহড় কে উদুঃ কাতে গাম লাআয় 'হেৎদ আমাআ কুলকুকে ' ইনি কুলদ খ্রীষ্ট। ");
INSERT INTO cdz_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","নাহাঃআ নিয়াঞ গামেৎআঞ, অকা এক্ড়ার ঈশ্বর হাতেৎ মাড়াং হাতেৎ গটা ঠাক তাহি লেনা, ৪ শায় ৩০ সির্মাং তায়্ম সেসেন হিচা কানা ব্যবস্থা ইনা এক্ড়ার কে বাদ কা হড় য়া, অকা কমিতে এক্ড়ার বিফলআ। ");
INSERT INTO cdz_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","চিয়া চি দায়াধিকার যদি ব্যবস্থা লেকা হয়ুয়া, তবে খান এক্ড়ার লেকানা কা হয়ুয়া; মেন্খান অব্রাহামকে ঈশ্বর এক্ড়ার লেকাতে ইনা কু দানা লিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","তবেখান নীতি দ কিনা তানা ? গুনাহা নাতিনাং ইনাদ মেশা হুই লেনা, অকা অব্দি ইনা কুল কা হিচু তানা, অকয় রাঃআ হান্ডে এক্ড়ার হুই লেনা, হেৎদ ইনাদ সরগ নাগাকু লিয়া মিৎ হড় মধ্য়স্থ রাঃআ তিহিতে, বিধিবদ্ধ হুইয়ে নায়। ");
INSERT INTO cdz_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","মিত হড় রাঃআ মধ্য়স্থ তেমা কা হুই য়াআ, মেন্খান মিৎ ঈশ্বর। ");
INSERT INTO cdz_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","তবে খান ব্যবস্থা দ চি ঈশ্বর রাঃআ এক্ড়ার ব্যবস্থা রাঃআ বিরূদ? একেবারে ল্হয় গে। যদি এনে এঙ্কানা আ ব্যবস্থা দহ হুই ক্যাআ, অকা জীউ এম দাড়ি কিইয়ায়্য়্য়, তবে খান ধর্মতা ব্যবস্থা লেকানাআ হুই কঅগেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","মেন্খান ব্দলতে, শাস্ত্র যতচ াগে কাই রাঃআ অধিনরে আটকা তিইয়ায়, যাতে নামা এক্ড়ার রাঃআ জ, যীশু খ্রীস্ট রাঃআ পটিয়াতে, পাতিয়ান হড় কুকে বাঞ্চা হুই য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","মেন্খান যীশু তে পাতিয়া হিচ্ রাঃআ মাড়াং তে আবু ব্যবস্থা রাঃআ ধিনরে তল তাহীন কেনাবু, অকা পাতিয়া তায়্মতে সদর কআ, ইনা রাঃআ তাঙ্গি রেলে তাহীন কেনা। ");
INSERT INTO cdz_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","নিয়া লেকাতে ব্যবস্থা খ্রীস্ট রাঃআ হান্ডে আগু নাতিনাং আলেয়া আ পরিচালককু মুনিসেনা, যাতে আলে পাতিয়া লেকাতে ধার্মিক মেন্তে লেখারেলে তাহীন কাআ। ");
INSERT INTO cdz_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","মেন্খান অকা অব্দি পাতিয়া হিচেনা, ইনাব্দি আলেদ পরিচালক কুরাঃআ মুনিস ল্হয়। ");
INSERT INTO cdz_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","চিয়া ল্হয় আপে যত হড়, যীশু খ্রীস্ট তে পাতিয়া নাতিনাং, ঈশ্বর রাঃআ হন পে হুইয়া কানা; ব্যবস্থা ");
INSERT INTO cdz_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","চিয়া চি আপে চিমিন হড় খ্রীস্ট নুতুমতে ডুবানা কানাপে, ইন্তং যত হড় খ্রীস্ট কে আতাং কাতেনামা তেপে সাজা কানা, ");
INSERT INTO cdz_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ইহুদি চি গ্রীক দ ল্হয়, মুনিসচি মালিকদ ল্হয, কড়া চি কুড়ি দ ল্হয়, চিয়া চি খ্রীস্ট যীশু তে আপেযত হড় মীহুড় ");
INSERT INTO cdz_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","হেৎদ আপে যদি খ্রীস্ট রেন্কু, তবে খান আব্রাহাম রাঃআ কুল, এক্ড়ার লেকাতে পিড়িধীকার। ");
INSERT INTO cdz_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","মেন্খান ইঞ গামেয়াঞ, পিড়িধীকার দ চিমিন মাহা হুডিং হন লেকায় তাহিনা, ইমিন মাহা যতচ ায়্য়্ রাঃআ মালিক হুই কাতে রহঅ মুনিস রাঃআ তিহিরে থির হাতাড়আ; ");
INSERT INTO cdz_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","মেন্খান আপু রাঃআ নির্দিস্ট মাহা অব্দি ইনিদ নেলাতেন রাঃআ হেৎদ সম্পতি যত জিমিৎ ারী মুনিস রাঃআ ধিনরে তাহি না। ");
INSERT INTO cdz_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","এনে এঙ্কাগে আবু হঅ চিন্তং হুডিং হন বু তাহীন কেনা, ইন্তং ধার্তি রাঃআ তলা কানা ব্যবস্থারে তল্বু তাহীন কেনা খ্রীষ্ট হিচু ব্দি। ");
INSERT INTO cdz_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","মেন্খান মাহা পুরালেন খান ঈশ্বর আয়া আ হান্ডে হাতেৎ আয়ায়্য় একাপুত হন কে কুলকিইয়ায়্য়; ইনিদ ডাঁগুয়া কুড়ি হন রাঃআ হর কাতে জানামে নায়, ব্যবস্থা রাঃআ ধীনরেগে জানাম লেনায়. ");
INSERT INTO cdz_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","যাতে ইনিদ গনঙ্গ এম কাতে ব্যবস্থা তে তলা কানাকু হড়কুকে রাঃআড়া ছাডা কুয়ায়্য়, যাতে আবু ঈশ্বর রাঃআ ধরম বেটা মেন্তেবু হয়ুকা আ। ");
INSERT INTO cdz_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","হেৎদ আপে ইনি রাঃআ হন, নিয়া খাতির ঈশ্বর আয়ায়্য় একাপুত হন রাঃআ আত্মা কে আয়ায়্য় হান্ডে হাতেৎ আবুয়া আ অন্তর রে কুলতাৎ আয়্য়; ইনি আব্বা বা মেন্তে রাঃআইয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","তবে খান আমদ নাহা আ মুনিসদ ল্হয়, বরং বেটা; হেৎদ চিন্তং এম বেটায়নাম ইন্তংদ ঈশ্বর লিয়া পিড়িধীকারীম হুএনা। ");
INSERT INTO cdz_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","নিয়া মাড়াং তে, পাহামেম মিৎ কাল তাহীন কেনা আপে ঈশ্বর কে কাপে সারিই কেনা, সার্তি কাতে অকয় ঈশ্বর ল্হয় ইঙ্কূ হাসা ঠাকুর কেপে সেবা আগু লাত কুয়া; ");
INSERT INTO cdz_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","মেন্খান নাহাআ ঈশ্বর রাঃআ চিপ্না পে নাম তাৎআ, ঈশ্বর লিয়া চিন্হায় নাপে; তবে খান চিকা কাতে অটহঃঅ ইনা মায়াং পেটেছ জাগতিক আরিচালি দরেম রুয়াড় তানাম, রুয়াড় কাতে অটহঃঅগে মুনিস লেকা তাহিন বুঝাৎ মেয়া? ");
INSERT INTO cdz_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","আপে বিশেষ বিশেষ মাহা, বঙ্গা, ঋতু, হেৎদ সির্মাং পে মানায় তানা। ");
INSERT INTO cdz_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","আপেয়ায়্য় বাব্ত্তে ইঞাঃআ বর হুয়ায়্য়; উকুই তার, আপেয়া তালারে সুধুগেং কামী তানা। ");
INSERT INTO cdz_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","এ হাগাঞকু, আপেকে নিয়া বিন্তিয়াপে তানাঞ, আপে ইঞ লেকা হুয়াপে, চিয়া চি ইঞ হঅমা আপে লেকাঞ তাহি লানা। আপে ইঞাঃআ জাহানাআ কাপে অপকার তাৎআ; ");
INSERT INTO cdz_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","হেৎদ আপে সারিগেয়াপে, ইঞাঃআ হড়ম রাঃআ রুয়া রাবাং নাতিনাং আপেয়া আ হান্ডে যত হাতেৎ মাড়াংতে বুগিন বার্তা পাসনা নাতিনাং দাওঞ নাম লাৎআ; ");
INSERT INTO cdz_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","হেৎদ ইঞাঃআ হড়ম রাঃআ থাকা নাতিনাং আপে অকা বিডা রেপে নুর লেনা, ইনা কাপে অবহেলা তাৎআ, কাপে ঘিন্না কানা, ঈশ্বর রাঃআ সরগ নাগাকু লেকা, খ্রীস্ট লেকা ইঞ কেপে আতাং লিইচাঞা, ");
INSERT INTO cdz_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","তবে খান অপেয়ায় ইনা সারাঃআও আত্মা নাহাআ ক্দেরেনা ? চিয়া চি ইঞ আপেয়া হুই কাতে সাক্ষিঞ এমে তানাযে, সাধ্য় তাহি লেন্খান আপে আপান আপিন রাঃআ মেৎ উদুঙ কাতেপে এম কিঞা। ");
INSERT INTO cdz_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","তবে খান আপেয়া হান্ডে সার্তি গামতে কিনা আ ইঞদচি আপেয়া হান্ডে বৈরীঞ হুয়াকানা ? ");
INSERT INTO cdz_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ইঙ্কূ চিল্কা বেস্লেকা আপেকে নেল আতেনেৎ পেয়াকু, ইঙ্কদ বেশগটা কাকু করায় তানা; বরংচ ইঙ্কূ দ আপেকে বাহারে দহ নাতিনাং ইচ্ছা মেনা আ, যেন আপেগে ইঙ্কূ কে বেস্লেকা নেল আতেন কূপে। ");
INSERT INTO cdz_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","শুধু আপেয়া হান্ডে হাজিরা কানাঞ মেন্তেদ ল্হয় মেন্খান সর্বকলরে বুগিন বাব্ত্তে বেস্লেকা নেল আতেন বেসা। ");
INSERT INTO cdz_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ইঞাঃআ আপানার রিঙ্কূ হন হপন আপে নাতিনাং অটহঅগে জানাম বেদনাতে কষ্ট তানাইঞ, যত ভুর খ্রীস্ট লেকা কাপে হুয়ায়্য় তানা। ");
INSERT INTO cdz_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ইঞাঃআ নেকা মনে হয়ুতানা যে, ইঞ যদি নাহা আ গে আপেয়া হান্ডে সেন দাড়ি কঃআ হেৎদ মটা সুরতে এগের দাড়ি কিইয়ায়্য়্য়ঞ ! চিয়া চি ইঞ আপেকে লিয়া কিনাঃআ যে চিকাঞ জাহানাআ কাইঞ বুঝা দাড়িতানা! ");
INSERT INTO cdz_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","গামেপেসিন, আপে মা ব্যবস্থা রাঃআ অধিনরে তাহীন বুঝাপে তানা, ব্যবস্থা অকা আ গামেয়ায়্য়, ইনা দ্চি আপে কাপে আয়ুম তাৎআ ? ");
INSERT INTO cdz_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","চিয়া চি রিলামালা শাস্ত্র রে অল মেনা আ, অব্রাহাম রাঃআ বারিয়া হন কিন তাহি লেনা, মিহুড় দ কিরিং কুড়ি রাঃআ, অটঃঅ মিহুড় রাঃআ দ অড়া এরাঃআ রাঃআ, ");
INSERT INTO cdz_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","কিরিং কুড়ি রাঃআ হনদ জাগতিক হড়ম ভাবতে জানাম লেনায়, মেন্খান অড়া এরাঃআ রাঃআ হনদ জানাম লেনায় মিয়াৎ এক্ড়ার চিহ্নালেকা। ");
INSERT INTO cdz_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","নিয়া থুতি রাঃআ রহস্য মেনা আ, চিয়া চি ইঙ্কিন বারিয়া এরাঃআ বারিয়া চুক্তি; মিয়ুড় রাঃআ চুক্তি দ সিয়ান বুরু হাতেৎ, অকয়্য় দ মুনিস হড়কুকে জানাম কুয়ায়্য় য়। ইনিদ হাগার। ");
INSERT INTO cdz_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","হাগার দ আরব দিসুম রেনিচ সিয়ান বুরু; হেৎদ নাহা আ ইনিদ জেরুসালেম রাঃআ লেকা, চিয়া চি ইনিদ আয়া আ হন হপন কু লঅ মুনিস তানাকু। ");
INSERT INTO cdz_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","মেন্খান সাল্গী জেরুসালেম অকাঃআ সরগরে ইনাদ স্বাধীনা, হেৎদ ইনি আবু য়াআ মাই তানায়। ");
INSERT INTO cdz_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","চিয়া চি অল মেনা আ 'আমদ আটকুড়া এরা, আপে অকয় হন আউরি পে জানাম কুয়া ! রম্জেপে, আপে অক্য়্কু জানাম বেদনা যাহা হুলাং আউরি পে আটকারেয়া, রম্জেপে, চিয়া চি গং কুড়ি হাতেৎ ছাডুই কুড়ি রাঃআ হন হপন কু ডেরঅ আকু। ");
INSERT INTO cdz_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","এ হাগা মিসি তুকু, আপে হঅ ইনি ইসহাক লেকা এক্ড়ার রিঙ্কূ হন। ");
INSERT INTO cdz_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","মেন্খান হড়ম লেকাতে জানামা কান হনকু চিল্কা ইনা হুলাং আত্মিক লেকাতে অকয় আম্মাতে জানামা লেনায় ইনিকে নির্যাতনেৎ কেনাকু, এনে এঙ্কাগে নাহা আ হঅ হুয়্তানা। ");
INSERT INTO cdz_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","তবেখান শাস্ত্রকিনাআ গামেৎ আয়? ইনি মুনিস কুড়িকে হানি রাঃআ ইনি হনকে উডুং গিডিকিন মে; চিয়া চি ইনি মুনিস হনদ যাহা হুলাং স্বাধীনা হন লঅ সমান পিড়িধীকার কায় হুই দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","তবেখান, এ ব্কং তেকু আবুদ মুনিস হনদ লহয়, আবুদ স্বাধীনা হন। ");
INSERT INTO cdz_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","আল্গা আল্গী নাম নাতিনাং খ্রীস্ট আবুকে আল্গা আল্গী তাৎ বুয়ায়; ইনাতে আঁট তে তিঁগু তাহিন্পে, মুনিস লেকা আল্পে আরাড়রে আল্পে স্যাপতল তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","আয়ুমেপে, ইঞ পল আপেকে গামাপে তানাআঞ, আপে যদি সুনু চুটি গেৎএয়াপে, তবে খান খ্রীস্ট রে তাহি কাতে আপেয়া যাহানাআ লাভ কা হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","অকয় কু সুনুচুটি গেৎ বুঝা পে তানা, উন্কুকে অটহঅ গেঞ গামাপে তানাঞ, ইনিকে ধারুয়া হালা লেকা যত জাগতিক ব্যবস্থা মানাতেগে হয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","আপে অক্য়্কু জাগতিক ব্যবস্থা তেপে তলা কান্তে ধার্মিক মেন্তে পে মনেৎআ, আপেদ খ্রীস্ট হাতেৎ পে সরাঃআ সাঙ্গীঞা কানা, আপেদ দায়াদুলাড় হাতেৎ পে ছিট্কা নুরাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","চিয়া চি আলে রিলামালা আত্মা পাতিয়া কাতে, ধার্মিকতা রাঃআ আশ পুরাঃআ নাতিনাং তাঙ্গিরে মেনালেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","চিয়া চি যীশু খ্রীস্ট তে সুনুচুটি গেৎ রাঃআ যাহান দাড়ি বায়ানা, সুনুচুটি কা গেৎ হঅ দাড়ি বায়ানা। মেন্খান দুলাড়তে কামী পুরাঃআ ইনা পাতিয়াগে দাড়িয়ান তানা। ");
INSERT INTO cdz_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","আপেমাত বেশ গটা তেপে খ্রীস্ট হরাতে নিরেৎ কেনা; অকয় আপেকে কু তিন্গু তুকা কেৎ পেয়া যে, আপে সর্তি রাঃআ এটকে টড়েৎ আলপে হুইয়া ? ");
INSERT INTO cdz_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ঈশ্বর আপেকে রাঃআ লাৎপেয়া, নিয়া বিডাও দ ইনি লিয়া কা হুয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ইতিচ তরাঃআং তাড়িরস তে যত সুজি তাড়ি চাবাআ। ");
INSERT INTO cdz_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","প্রভুতে ইঞ নিন্তিৎ আত্মাসা যে আপে জাহান এটা হরাঃআ কাপে বাঝায়া, অকয় আপেকেকু ভড়কাৎ পেয়া, ইনিদ যাহায় গে হুয়েন খান চিকেনা, ইশ্বর ধরবার রাঃআ রায়রে কুড়াই নামে গেয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","এ বক্যং তিকু, ইঞ যদি নাহাআ হঅ সুনুচুটি গেৎ নাতিনাং জাগারঞ পাসনায়া, এন্খান চিয়াআ নাহা হঅ ইঞ কে এটকে টড়েৎ রে তাহি হুয়াঞ তানা ? এন্খান মাত ক্রাঃআস রাঃআ জাগার পাস্নারে এটকে টড়েৎ কা তাহি কআ। ");
INSERT INTO cdz_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","অকয় আপেকেকু ঝামেলাৎ পেয়া ইঙ্কূ নিজেরাঃআ সুনু গেৎ গিডিই কাআ কু। ");
INSERT INTO cdz_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","এ ব্কং তেকু, আপে আল্গা আল্গী নাতিনাং রাঃআতুকা কানাপে; নেলেপে ইনা আল্গা সাল্গা তিনাং লালসা রাঃআ উস্কানি আলম হাতায়া, বরংচ দুলাড় তে আপান আপিন রাঃআ নতরে তাহিন্পে। ");
INSERT INTO cdz_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","বেবস্থা রাঃআ যত ব্যবস্থা মিৎ জাগারতে পুরাঃআ কানা, ইনাদ 'আমাঃআ পড়সি কুকে আম লেকা কুসি-কুসাল কুম। ");
INSERT INTO cdz_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","মেন্খান আপে যদি আপান আপিন লঅ নিয়ায়-এগেরয়াপে, নেলেপে, আপে নিয়া খাতির আপান আপিন ধ্বংসয়াপে। ");
INSERT INTO cdz_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","মেন্খান গাম লিঞ, আপে রিলামালাআত্মা জ্ঞান তে সেসেন্পে, এন্খান হড়ম লাল্স আলম মেটায়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","চিয়া চি হড়মদ রিলামালা আত্মা বিরূদ, হেৎদ আত্মা হড়ম বিরূদ, কারন নিকিন বারিয়া আপান আপিন রাঃআ ভেগার মহড়া তানা, ইনাতে আপেয়াআ অকা করাঃআ বুঝাপে তানা, হুঁসিয়ার ইনাদ আলপে করাঃআয়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","মেন্খান রিলামালা আত্মা জ্ঞানতে সেসেন তানাপে, তবেখান জাগতিক ব্যবস্থা রে বানুপেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","অটহঅ হড়ম লিয়া কামিকু রাঃআ সদর মেনাআ; ইনা কুদ রেন্ডিবাজি, বিন রিলামালা,লালচ, ");
INSERT INTO cdz_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","জাদু বিদ্যা, ঠাকুর বন্গা, নানান হুনার বৈইরীঃ,নিয়ায়্য়,রাগ, হেপাবাডি, ভিনা-ভিনী, রেষারেষী, ");
INSERT INTO cdz_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","হিঁসা সিঁসী, বুলামী,ফুর্তি হেৎদ নিয়া লেকানাআ এটা এটাগা গুনাঃকু। নিয়া যত কুরাঃআ বাব্ত্তে ইঞ আপেকে হুসিয়ারেৎ পেয়াঞ, মাড়াংতে হঅঞ গামালাৎ পেয়াঞ, অকয় কু নেকা কু কামিয়া, ইঙ্কূ ঈশ্বর রাঃআ পরগনা রে আইদারি কাকু নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","মেন্খান রিলামালা আত্মা রাঃআ জদ দুলাড়, কুশি, সুলুক, সাহা, দায়া, দেঙ্গাইচ, পাতিয়াইচ, ");
INSERT INTO cdz_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","নেমশ, হড়মকব্জ, নিয়া লেকানা গুনা গুন বিরূদ ব্যবস্থা বায়ায়না। ");
INSERT INTO cdz_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","হেৎদ অক্য়্কু খ্রীষ্ট যীশুরে মেনাঃআ কুয়া, ইঙ্কূদ আকুয়া হড়ম রাঃআ যত লোভ লালচ ক্রসরেকু হাকা তাৎআ। ");
INSERT INTO cdz_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","আবু যদি রিলামালা আত্মাজ্ঞানতে জিউ বাঞ্চায়াবু, এন্খান দেলা আবু রিলামালা আত্মাজ্ঞান তেবু সেসেন কাআ; ");
INSERT INTO cdz_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","আউহা সাউহা আলবু ফুটানিয়া, আপান অপিনকে কাবু সাঁতাকুয়া আপান অপিনকে কাবু হিংসা হুলুং কুয়া। ");
INSERT INTO cdz_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","বকংতেকু, যাহায় যদি জাহান গুনাঃ রে স্যাপ তুকা কানায়, এন্খান আপে অকয় আত্মাজ্ঞানীকু, আপে এনে এঙ্কা সাপা হেৎদ রিলামালা মনেতে বুঝা রুয়াড় আগুই পে, মেন্খান হুঁসিয়ার তাহিন্মে বাংখান্দ আম হঅ ছাঁদাবাঁদাম। ");
INSERT INTO cdz_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","আপে যত হড় পারা পারি রাঃআ হাঁবাল গঅয়পে, নেকা লেকাতেগে খ্রীস্ট রাঃআ নামা ব্যবস্থা পুরাঃআয়পে। ");
INSERT INTO cdz_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","চিয়া চি যাহায় যদি মনেয়ায়, ইঞগে যত কিছু, মেন্খান কামিরে ইনিদ যাহানিচ ল্হয়, আচ আচকেগে খাটঃ তানায়। ");
INSERT INTO cdz_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","মেন্খান ঝত হড় আকুয়াআ কামিতে প্রক্ষাঃআকু, এন্খান এটা হড় রাঃআ কামী লঅ কা যখা তুলা কাতেত, আয়ায়্য় নিজ কমিতে খুসিরে তাহি নায়। ");
INSERT INTO cdz_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","চিয়াচি জ্ত্চ রাঃআ উচিৎ, আপান আপিন হাম্বাল গঅ ইদি। ");
INSERT INTO cdz_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","মেন্খান অকয় হড় ঈশ্বর রাঃআ বচন বাব্ত্তে জ্ঞান নামেয়ায়, ইনি চেচেদিচ কে যত লেকানা বেশ কামী কুরে দেঙ্গা এমাই কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","আলপে চম্কাঃআ, ঈশ্বরকে হিয়ালি করাঃআ কা হড় আ; চিয়া চি মান্মি অকাঃআ কু হেরেয়া ইনাগে কু ইরিয়া। ");
INSERT INTO cdz_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","অকয় হড়ম রাঃআ লোভ লালচ নাতিনাং জাং হেরেয়ায়, ইনিদ ইনা হড়ম নাতিনাং গে বিনাশক গেলে ইরিয়েয়্য়; মেন্খান রিলামালা আত্মা রাঃআ জাং অকয় হেরেয়ায়, ইনিদ আত্মা হাতেৎ জায়যুগ জিউ রাঃআ গেলে ইরিয়ে য়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","দেলা, আবু বুগিন কামী কমিতে আল্বু থাকা কাঃআ; চিয়া চি কাবু থাকা লেন খান সেটের মাহারে বুগিন গেলেবু নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ইনাতে দেলা, আবু চিল্কা দাও নামেৎ আবু এনেঙ্কা পাতিয়ান হড় কুরাঃআ পাহি কুরাঃআ বেশ মনন্তরতে দেঙ্গা কুয়াবু। ");
INSERT INTO cdz_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","নেলেম, ইঞাঃআ নিজ তিহিতে চিন্তিৎ মারাঃআং হরফ তে অলাৎ মেয়াঞ! ");
INSERT INTO cdz_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","অকয় হড় কু হড়ম নেল নাতিনাং ইচ্ছা মেনাআ, ইঙ্কূ হড় কুগে আপেকে সুনু চুটি গেৎ নাতিনাং উস্কাৎ পেয়া; নিয়া নাতিনাং নেকান কামী করাঃআ বুঝা কু তানা, যেন খ্রীস্টকে ক্রাঃআস নাতিনাং এঙ্কূ কে সাসেৎ আল হয়ুকআ। ");
INSERT INTO cdz_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","চিয়া চি অকয় কু সুনু চুটি গেৎএ তানাকু ইঙ্কূ হঅ জাগতিক ব্যবস্থা কাকু মানায় তানা, তুবু রহঅ আসি তানাকু আপে হঅ সুনু চুটি গেৎএ পে, যাতে ইঙ্কূ আপেয়া হড়ম বাব্ত্তে খুশিকু নামে কআ। ");
INSERT INTO cdz_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","মেন্খান আবুয়াআ প্রভু খ্রীস্ট রাঃআ ক্রাঃআস বিনা ইঞ এটাআ জাহান বাব্ত্তে খুশি কাঞ তাহি দাড়িয়া; ইনি লিয়া ইঞাঃআ দিসুম, হেৎদ দিসুম নাতিনাং ইঞ ক্রাঃআস রে হাকা কানাঞ। ");
INSERT INTO cdz_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","চিয়া চি সুনু চুটি গেৎ হঅ জাহানা লহয়, সুনু চুটি কা গেৎ হঅ জাহানাআ লহয়, মেন্খান নামা সির্জ্ন গে আসল্দ। ");
INSERT INTO cdz_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","অকয় হড় নিয়া হরাঃআ তেকু তাড়মেয়া, ইঙ্কূ য়া হান্ডে 'সুলুক' হেৎদ দায়া হিচু কাঃআ, ঈশ্বর রিঙ্কূ হড় 'খেরয়াল কুরাঃআ হান্ডে হিচু কাঃআ' ");
INSERT INTO cdz_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","নাহাআ হাতেৎ যাহায় ইঞকে কষ্ট আলকু এমাংকআ, চিয়া চি ইঞাঃআ হড়ম রে যীশু রাঃআ হড়ম চেগেড় চিন্হ গঅ তাৎআঞ। ");
INSERT INTO cdz_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","এ ব্কং তুকু আবুয়া প্রভু যীশু খ্রীস্ট রাঃআ দায়াদুলাড় অপেয়াআ আত্মা তালারে তাহীন কাঃআ, পেরেচ।");
INSERT INTO cdz_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","আপু ঈশ্বর রাঃআ হেৎদ যীশু খ্রীস্টরে পাতিয়ানিচ থিষলনীকীয় সরগ নাগার রিঙ্কূ মন্ডলী রাঃআ হান্ডে পল রাঃআ গিরা সেকাম, সীল হেৎদ তীমথিয় রাঃআ মৌন জহার। দায়াদুলাড় হেৎদ সুলুক আপে লঅ তাহীন কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","আলে বিন্তি অক্তরেলে আপেয়া নুতুমকাতে আপেয়া যতচ কুরাঃআ নাতিনাং সবসময় ঈশ্বর রাঃআ সারহাওয়ে তানালে; ");
INSERT INTO cdz_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","আলে আবুয়া ঈশ্বর বাঃআ রাঃআ সামাং রে আপেয়া পাতিয়া রাঃআ কামী হেৎদ আপেয়া দুলাড় রাঃআ খাটনি হেত্তেদ আবুয়া প্রভু যীশু খ্রীষ্টরাঃআ বাবদ আশা রাঃআ ধৈর্য্য লে সবদিন পাহামে তানালে। ");
INSERT INTO cdz_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","চিয়াঃচি, এ বকইঞ তেকু ঈশ্বর রাঃআ দুলাড়িয়াকু, আলে সারিয়া লে, আপে বাছাকানা হড় তানা পে। এপিসিয় 1:4 ");
INSERT INTO cdz_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","চিয়াচি আলেয়া বুগিন বার্তা দ একেন জাগারতেদ লহয়, মেনখান দাড়িতে হেৎদ রিলামালা আত্মাতে হেৎদ বেশলেকা আটকার-নাম কেৎতেপে আপেয়া হান্ডে সেটেরলেনা, হেৎদ আপেয়া তালা রে আপেয়া নাতিনাং আলে চিল্কান লেকা মান্মি তাহীনকেনালে, ইনা মা আপে সারিয়াপে। ");
INSERT INTO cdz_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","হেৎদ আপে কুঠিন দুখ সাহাকাতে লঅ রিলামালা আত্মা রাঃআ রাঃআসকাতে জাগারটাপে আতাং কেৎ তে আলেয়া হেৎদ প্রভু রাঃআ অনুকারীপে হুইয়ে না। ");
INSERT INTO cdz_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","হেৎদ নেকাগে আপে মাকিদনিয়া হেৎদ আখায়াস্থ রেঙ্কূ যত পাতিয়ান হড় কুরাঃআ আদর্শ পে হুইয়ে না। ");
INSERT INTO cdz_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","চিয়াচি আপেয়া হান্ডে হাতেন ঈশ্বর রাঃআ জাগার দঅ জাগারাকানা, একেন মাকিদনিয়া হেৎদ আখায়া এলাকারে দঅ ল্হয়, মেন্খান ঈশ্বর রাআ চেতাংরে আপেয়া অকা পাতিয়া, ইনা বাবদ যত থাংরে পাসরাঃআকানা, ইনা নাতিনাং আলেয়া যাহানা গামরাঃআ বাআয়না। ");
INSERT INTO cdz_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","চিয়াচি ইঙ্কূ আকুগে আলেয়া বাব্ত্তে তে নিয়া বার্তা গাম পাসরাঃআয় কেনাকু যে, আলে আপেয়া হান্ডে চিল্কা আতাংদারাম লেনালে, মূর্তি বংগা কুয়া হাতেন চিল্কা ঈশ্বর রাআ থাংতে মনপে রুয়াড় কেয়া। যাতে জিউত হেৎদ সারি ঈশ্বর রাঃআ সেবা দেবা করা দাড়িকাআপে। ");
INSERT INTO cdz_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","অকয়কে ইনিদ গচা কু হাতেন জিউত বিরিৎ তিৎআয়, অকয় দঅ হিজুতান মাহা রাঃআ রাঃআগ হাতেন আবুআ উদ্ধারকর্তা:যাতে সেরমা হাতেন হানিরাঃআ ইনি হনতেৎ যীশুরাঃআ হিজুরাআ তাঙ্গি রে তাহি দাড়িয়াকাআপে। ");
INSERT INTO cdz_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","এ বকইঞতুকু হেৎদ মিসি তুকু, আলে আপেয়াআ হান্ডেলে বেকার কালে হিচা কানা ইনা আপেগেপে সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","আপে সারিয়াপে আলে মাড়াংতে ফিলিপী রে দুঃখ হেৎদ অপমান সাহা তাৎআলে, রহ আলে আলেয়া ঈশ্বররেলে সাহসেন্তে গাদা হড়রাআ বিরুধ সত্বে হঅ আলে আপেয়া হান্ডেলে ঈশ্বররাআ বুগিন বার্তা রাআ জাগার পাস্না লাৎআলে। ");
INSERT INTO cdz_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","চিয়াচি আলেয়া চেচেদা দ যাহান বেদালেকানাআ চেচেদা, চি অছুতি চি ছল-চাল হাতেন দ লহয়, ");
INSERT INTO cdz_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","মেন্খান ঈশ্বর চিল্কা আলেকে জিমাকাতে আলেয়া চেতাংরে বুগিন বার্তারাআ ভারাজনা দঃহঅতাৎআয় এনকালে জাগারেতানা, হড়আমানকুকে কুশিতকা নাতিনাংদ লহয় মেন্খান ঈশ্বর, অকয় আবুয়া অন্তর বিডায়াআয়। তিত্স 1; 3 ইপিসিয়্ন 6:6 ");
INSERT INTO cdz_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","চিয়াচি আপে পে সারিয়া, আলে দ যাহাচিল্লং লুবুর-চুবুর/লসর-পসর থুতি তে চি লালচাকান ছলতে কালে লাঠাকানা, নিয়ারাঃআ লুকুন্দী দ ঈশ্বরতানায়। ");
INSERT INTO cdz_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","হেৎদ আলে মান্মিকুরাআ হাতেৎ মান হাতা নাতিনাং কালে কুরু মুটু তাৎআ, আপেয়া হান্ডে হাতেৎ হঅ লঅহয়, এটা মান্মি কুরাঃআ হান্ডে হাতেৎ হঅ ল্হয়, যদি হঅ খ্রীষ্ট রাঃআ কুলিচ কু হুইয়েন তেহ আলে আপেয়াআ হান্ডে হাতেন সুযোগ হাতাহঅ দাড়িয়া কেয়ালে হুনাং। ");
INSERT INTO cdz_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","মেন্খান চিল্কা মাইতেৎতুকু আপনাররাআ হনকুকে হারা বুরুকুয়াকু, এঙ্কা আলে আপেয়া তালা রে স্নেহ রাআ ভাব উদুলাৎআলে। ");
INSERT INTO cdz_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","এঙ্কালেকা আলে আপেকে দুলাড় কাতে একেন ঈশ্বর রাঃআ বুগিন জাগারতেদ লহয়, মেন্খান আপান আপিন জিউ হঅ আপেকে হাটিংলে সাপড়াকেনা, চিয়াচি আপে আলেয়া দুলাড়িয়া কুপে হুইলেনা। ");
INSERT INTO cdz_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","এ বকইঞ কু আপে দ আলেয়া খাটনি/মেহনৎ হেৎদ কুঠিন কুরু মুটু পাহাম মেনাআ; আপেয়া যাহায় রাঃআ বঝা আল হুইয়কাঃআলে, ইনা মেন্তে আলে সিঙ্গি নিন্দা কামী কামীতে আপেয়া তালা রে বুগিন জাগার পাস্নাৎ কেনালে। ");
INSERT INTO cdz_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","হেৎদ আপে পাতিয়ানকু যে, আপেয়া হান্ডে আলে চিল্কা রিলামালা হেৎদ ধরমমান হেৎদ নির্দোষলে তাহীনকেনা, ইনারাঃআ লুকুন্দীকু আপে মেনাপেয়া হেৎদ ঈশ্বর হঅ মেনাইয়া। ");
INSERT INTO cdz_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","আপে মা সারিয়া পে, আপু চিল্কা আয়া হনকুকে, এনকাগে আলে আপে মিমিৎ হড়কে উৎসাহ হেৎদ সান্তনা এমাকেনাপেয়ালে, ");
INSERT INTO cdz_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","যেন আপে ঈশ্বর রাঃআ সামাং রে নেক লেকাতে সেসেনপে, অকয় আয়া রাঃআজ্য হেৎদ মহিমা রে বাতলা পে তানায়। ");
INSERT INTO cdz_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","হেৎদ নিয়া নাতিনাং আলে হঅ দিন হুলাং ঈশ্বর রাআ লে সারহায় তানা, আলেয়া হান্ডে ঈশ্বর রাঃআ কুলাকান নামকাতে/আয়ুমকাতে, আপে মান্মিকু রাআ জাগার দঅ লহয়, মেন্খান ঈশ্বর রাআ জাগার মেন্তে ইনা আতাং লাৎআপে, ইনা সার্তিগে ঈশ্বর রাআ জাগার হেৎদ আপে পাতিয়ান আপেয়া তালারে নিজেরাআ কামী পুরায়তানাপে। ");
INSERT INTO cdz_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","চিয়াচি, এ হাগা মিসি কু, যিহূদিয়া রে খ্রীষ্ট যীশু তে ঈশ্বর রাঃআ অকা যত মন্ডলী মেনা, আপে ইঙ্কূয়া সেসেনিজকু হুইয়াকানাপে, চিয়াচি ইঙ্কূ ইহুদিকুরাআ হাতেন চিল্কা লেকা দুখ নামতাৎআকু, আপে হঅ আপেয়া নিজে জাইতকুরাআ হড়কুরাআ হান্ডে হাতেন এঙ্কালেকা দুখ নামতাৎআপে। ");
INSERT INTO cdz_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","যিহূদীকুদ প্রভু যীশুকে হেৎদ ভাবি জাগারিজ কুকে গয়চলাৎ কুয়াকু, অটঅ আলেকে কুদা-গিডি লাৎলেয়াকু, ইঙ্কূ ঈশ্বর রাআ কুশিয়ানকু লহয় হেৎদ ইঙ্কূ যতয় হড়কুরাআ উল্টা। ");
INSERT INTO cdz_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","ইঙ্কূ আলেকে বিন-ইহুদিকুরাআ উদ্ধার রাআ নাতিনাং ইঙ্কূয়া হান্ডে থুতি গামঅতে মানাতানালেয়াকু, নেএ নেকাগে দিনাৎ দিন নিজেরাআ কাইরাআ হাম্বাল বাড়ায়েন্তে ঈশ্বররাআ মুকামতে সেটেরেনা, মেন্খান ইঙ্কূয়া হান্ডে চূড়ান্ত ক্রোধ সেটেরেনা। ");
INSERT INTO cdz_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","হেৎদ, এ হাগা-মিসি কু, আলে হুডাং মাহা/ঘাড়ি নাতিনাং ভিনা লেনা লে, অন্তর তেদ ল্হয় মেন্খান আপেয়া হাজির তাহিনো তে হেৎদ আপেয়া মেদ মুহাড় নেল নাতিনাং তে আলেকে কুঠিন সানাকেৎ লেয়া হেৎদ চুহুলে নালে। ");
INSERT INTO cdz_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","চিয়াচি আলে দ, বিশেষকাতেন ইঞ পল, মিসা বারসা আপেয়া হান্ডে সেন সানা কেৎ লেয়া, মেনখান শয়তান এ মানা/আটকাকেৎ লেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","চিয়া চি আলেয়া আশা চায় রাঃআসকা চায় মহিমা রাঃআ মুকুট কিনা তানা? চিয়া আপে গে আবুয়া প্রভু যীশুরাঃআ সামাং রে ইনি রাঃআ হিচু হুলাংরে লহয় তানা পে? ");
INSERT INTO cdz_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","আপে গেমা আলেয়া মহিমা হেৎদ রাঃআসকা তানা পে। ");
INSERT INTO cdz_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ইনা নাতিনাংতে আলে ধৈর্য্য সাহা কালে দাড়িয়ান্তে আথীনী নাগার রে একলা গে তাহি হঅ বেশ লে আটকার কেয়া। ");
INSERT INTO cdz_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","হেৎদ আলেয়া হাগা হেৎদ খ্রীষ্ট রাঃআ বুগিন বার্তা রিনিজ ঈশ্বর রাঃআ দাস তিমথীয়কেলে কুললিয়ালে, যেন ইনি আপেকে সুস্থির পেকায় হেৎদ আপেয়া পাতিয়া রাআ বাবত্তে আশা এমাপেকায়। ");
INSERT INTO cdz_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","যাতে আপে যাহায় নিয়া কষ্টরে আল্পে অস্থিরোয়া, চিয়াচি আপে অপেগেপে সারিয়াপে, আলে নিয়া নাতিনাংগে সম্পাকানালে। ");
INSERT INTO cdz_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","নিয়া দ সার্তি তানা যে আলে চিন্তং আপেয়া হান্ডে লে তাহীন কেনা, আলে মাড়াং হাতেৎ লে গাম তাৎআ পেয়া যে, আলেয়া কষ্ট হুইওয়া, হেৎদ ইনাগে হুইয়া কানা, ইনামা আপে সারি গেয়া। ");
INSERT INTO cdz_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","ইনা নাতিনাং তে ইঞ হঅ ধৈর্য্য কাইঞ সাহা দাড়িয়ান্তেঞ আপেয়া পাতিয়া রাঃআ তত্ত্ব সারি নাম নাতিনাং হানিকেঞ কুল লিৎআঞ, ভাবালাৎআঞ,পাছেন বিড়াইজ যাহা লেকাতে আপেকে বিডা তাৎপেয়ায় মেন্তে চি, আলেয়া কামী বেকারাঃআ কানা। ");
INSERT INTO cdz_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","মেন্খান নাহা তীমথিয় আপেয়া হান্ডে হাতেন আলেয়া হান্ডে হিচেন্তে আপেয়া পাতিয়া হেৎদ দুলাড় রাঃআ জাগার বাব্ত্তে বুগিন বার্তা আলেকে এমা তাৎ লেয়ায় হেৎদ গামাতাৎ লেয়ায়, আপেদ সারা ঘাড়ি আলেকে স্নেহ লেকাতে পাহাম দহ তাৎলেয়াপে, চিল্কা আলে হঅ আপেকে নেনেল বুঝা তাৎলেয়া, এঙ্কাগে আপে হঅ আলেকে নেলেল বুঝাপে তানা। ");
INSERT INTO cdz_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","ইনা নাতিনাং, এ হাগাঞ কু, আপেয়া নাতিনাং তে আলে যত বিপদ হেৎদ কষ্ট রে মেনালে রহঅ আপেয়া পাতিয়া তে যেদলে নাম কেৎআ। ");
INSERT INTO cdz_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","চিয়াচি আপে যদি প্রভুরে কেটেচ তে তাহিনাপে, এন্খান্ নাহা আলে সার্তি বাঁঞ্চা মেনাঃ লেয়া। ");
INSERT INTO cdz_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","বাস্তবিক আপে নাতিনাং আলে আলেয়াঃআ ঈশ্বর রাঃআ সামাংরে অকা খুশি খুসালতে খুশি খুসাল লআলে, ইনা বদলতে আপেয়া নাতিনাং ঈশ্বরকে চিল্কা লেকাতে সারহাও এম দাড়িয়া লে? ");
INSERT INTO cdz_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","আলে যাতে আপেয়া মেদমুহাড় নেলনামে কাঃআলে, হেৎদ আপেয়া পাতিয়া রে ত্রুটিকু সুধরা দাড়ি কাঃআলে, ইনা নাতিনাং নিদা সিঙ্গি লে বিন্তিই তানা। ");
INSERT INTO cdz_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","হেৎদ আবুয়া আপু ঈশ্বর হেৎদ আবুয়া প্রভু যীশু আপেয়া হান্ডে আলেয়া হরা সজেহে দহয় কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","হেৎদ চিল্কা আলে হঃঅ আপেয়াআ লিয়া ফুরি তানালে, এঙ্কাগে প্রভু আপেকে আপান আপিন হেৎদ জ্ত্চ কে দুলাড় তে পেরেচ পে কাঃআয় হেৎদ ফুরিই পেকাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","ঈশ্বর আপেয়া হৃদয়রে ভর দাড়ি এমে য়ায়্য়, যাতে আয়াআ যত রিলামালা কু লঅ আবুয়া প্রভু যীশু রাঃআ রুয়াড় হিচু মাহারে ইনি আবুয়ায়্য় আপু ঈশ্বরতে নাপাম লঅ আপেকে রিলামালা হেৎদ মৌন এমাপে কাঃআয়। ক্ল্সিয়ান 1:22 ইফিসিয়া 5:27 । ");
INSERT INTO cdz_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","এন্খান, এ বকইঞ কু, মুচাদরে আলে প্রভু যীশুলিয়া আপেকে উৎসা এমাপে তানালে, চিল্কা পে সেসেন লেন্খান ঈশ্বরএ সন্তুষ্ট আয়, নিয়া বাব্ত্তে আলেয়াআ হান্ডে অকা চেচেদাআ পে হাতা তাৎআ, হেৎদ চিল্কা পে সেসেন তানা, এনে এঙ্কা লেকাগে আলে আপেকে উৎসা এমাপে তানালে আপে গাদা ফুরি এমেপে। ");
INSERT INTO cdz_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","চিয়া চি আলে প্রভু যীশু লিয়াতে আপেকেলে কিনাঃআ কুলে আচু এমা তাৎ পেয়া, আপে দঅ ইনা সারিগেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","বিশেষকাতেন, নিয়া দঅ ঈশ্বর রাঃআ ইচ্ছা তানা, আপেয়া নির্মলা, ");
INSERT INTO cdz_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","যেন হড়মালটম হাতেন সাঙ্গিন রে তাহীন পে। আপে যত হড় চেদঃঅপে যে রিলামালা হেৎদ গুনমৌনতে আপান আপিন এরা লঅ চিল্কা তাহি হুইআয়্য়া, ");
INSERT INTO cdz_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","অক্য়য়কু ঈশ্বরকে কাকু সারিয়া, ইঙ্কূ বিন ইহুদিকু লেকা হড়মো লালচ লেকা দঅ ল্হয়, ");
INSERT INTO cdz_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","হেৎদ যাহায় যেন নেকান কামিরে তিড়সা পারম কাতে আপনারাআ হাগা কে আলয় ঠেকাই কাঃআয়, চিল্কা মাড়াং হাতেন আপেকে হুসিয়ার কাতে গামাতেৎ পেয়াং, প্রভু দ ইনা যত কাই নাতিনাং যত হড় কে কুড়াই এমাকুয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","চিয়াচি ঈশ্বরদ বাড়িছ কামী নাতিনাং দ ল্হয়, মেন্খান রিলামালা কামী নাতিনাং রারাঃআ তাৎ বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ইনা নাতিনাং অক্যয় হড় নিয়া কায় মানা বাতায়ায়, ইনিদ মান্মি কে দ ল্হয়, ঈশ্বরকেগে কায় ছুতাং ইআয়্য় , অকয়্য়দ আয়া নিজে রাঃআ রিলামালা আত্মা আপেকে এমাতাৎ পেয়া। ");
INSERT INTO cdz_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","হেৎদ হাগা দুলাড় বাব্ত্তে আপেকে জাহানা অল রাঃআ লাক্তি বাআয়্য়না, চিয়া চি আপে আপান আপিন দুপুলাড় নাতিনাং ঈশ্বর রাআ হান্ডে চেচেদ নাম তাৎআ পে। ");
INSERT INTO cdz_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","হেৎদ সার্তি গে, আপে দ মাকিদনিয়া রেঙ্কূ যত হাগা মিসি কু নাতিনাং এঙ্কা গেপে দুলাড়াকু তানা, ");
INSERT INTO cdz_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","মেন্খান আপেকে নেহর কাতে গামা পেতানাঞ, এ হাগা মিসি কু, ঢের উতার দুলাড় দুপুলাড় পে, হেৎদ আলে আচুকেৎ পে লেকা থিরথার তাহীন পে হেৎদ আপান আপিন কামীতে কামীই পে হেৎদ আপান আপিন তিহি তে কামী-জম পে। ");
INSERT INTO cdz_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","যেন আপেয়া গুনমৌন বেভার নাতিনাং বাহার হড় কু রাঃআ হান্ডে আপে চিল্কা আতাং তুকা কানাপে, ইনাতে আপেয়া যাহানা তে আলপে অভাব ওয়া। ");
INSERT INTO cdz_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","মেন্খান এ হাগাকু আলে কালে আসিতানা, গচ কুরাঃআ বাব্ত্তে আপে কাপে সারিয়া এঙ্কাদ লহয়; চিল্কা ইঙ্কূ য়া আসা বায়ানা, ইনা নাতিনাং যত হড় কু লেকা আল্পে দুঃখ হমরআ। ");
INSERT INTO cdz_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","চিয়া চি, আলে নিন্তং পাতিয়া কানালে যে, যীশু গচ লেনায় হেৎদ জীউৎ বিরিৎ এনায়, ইনা লেকাগে ঈশ্বর যীশু রে গিতিচ গচা আকানা কুয়া ইনিলো বিরিৎ আগু কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","চিয়া চি নিয়া দ আলে প্রভু রাঃআ জাগার লেকাতে গামাপে তানা, আবু অকয় কু জীউৎ গেয়াবু হেৎদ প্রভু রুয়াড় হিচু যাকিৎ চিনতি লেকা জীউৎ তাহিনাবু, আলেদ গচা কানা কু রাঃআ হাতেন কালে মাড়াং ওয়া। ");
INSERT INTO cdz_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","চিয়া চি প্রভু দ আয় গে রাস্কা রম্চতে, মারাং সরগ নাগা রাঃআ কন্ঠতে হেৎদ ঈশ্বর রাঃআ রুতু বানাম সাডি তে সরগ হাতেন আড়গু হিচু য়ায়্য়, হেৎদ অকয় কুদ খ্রীষ্ট নুতুম তেকু গচা কানা, ইঙ্কূ দ মাড়াং তেকু জীউৎ বিরিৎ দয়াকু। ");
INSERT INTO cdz_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","ইনা তায়্মতে আবু অকয় কু জীউৎ মেনাঃবুয়া, অক্যয় কু সারেচ তাহিনাবু, আবু নিরালারে প্রভু লঅ নাপাম নাতিনাং মিশাতে উঙ্কূ লঅ রিঁবিল তেবু সেনাঃবু হেৎদ নেকাগে প্রভুলঅ সারা ঘাড়ি তাহিনাবু। ");
INSERT INTO cdz_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","নেকা গে আপে আপে নিয়া জাগার তেগে জিউ রাড়েচ দহয়পে। ");
INSERT INTO cdz_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","মেন্খান, এ বকইঞ তুকু, বিশেষ বিশেষ মাহা কুরাঃআ হেৎদ হুলাং কুরাঃআ বাব্ত্তে আপেকে জাহানা অল কা বেসা। ");
INSERT INTO cdz_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","চিয়াআ চি আপে দপে সারিয়া, চিল্কা কম্বুড়ু নিদায় হিচুয়া এঙ্কাগে প্রভু রাঃআ মাহা হিচু য়া। ");
INSERT INTO cdz_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","মান্মি চিন্তং গামেয়া কু, আলে শুলুকতে মেনা লেয়া হেৎদ জাহান বর বায়ানা, ইন্তং গে আকুয়াআ হান্ডে পয়াতি রাঃআ জানাম হাসু হিচ সেটেরআ, এঙ্কা আচ্কাগে বিনাশ সেটেরআ; হেৎদ ইনা ক যাহা লেকা তে কাকু নির বানচা দাড়িয়া (মথি 24:27 -29) ");
INSERT INTO cdz_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","মেন্খান আপে, এ হাগাকু, নুবারে বানুপেয়া ইনাতে ইনা হুলাং কুম্বুড়ুলেকা কায় সাবপেয়ায়, ");
INSERT INTO cdz_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","আপে যতচ কুদ মার্শাল রিঙ্কূ হেৎদ সিঙ্গি রিঙ্কূ হন তানাপে; আবু নিদা নুবা রেঙ্কূদ লহয়। ");
INSERT INTO cdz_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","নিয়া মেন্তে দেলা, আবু এটাকু লেকা কাবু গিতিচ শচজআ, এনাখান চির্গালবু তাহীনা হেৎদ রিলামালা আত্মা পেরেচ বু তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","চিয়া চি অকয়কু গিতিচ শচয়া, ইঙ্কূদ নিদা গেকু গিতিচআ হেৎদ অকয় কু আরখি নুইয়া, ইঙ্কূদ নিদা কু বুল গিতিচ আকু। ");
INSERT INTO cdz_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","মেন্খান আবুদ সিঙ্গি রিঙ্কূ মেন্তে দেলা হিচু পে, আত্মা তেবু কব্জ কাতে সেসেন কাআ, পাতিয়া হেৎদ দুলাড় রাঃআ কুড়াম ঢাকুল তুসিঙ কাতে হেৎদ বাঞ্চা রাঃআ আশলেখানাঃআ দাহাড়ী বহরে তুসিঙঅ কাআবু (জিসাই 59:17) ");
INSERT INTO cdz_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","চিয়াচি ঈশ্বর আবুকে রাগ নাতিনাং তেদ কায় বাছা তাৎবুয়া, মেন্খান আবুয়া প্রভু যীশু খ্রীষ্ট লিয়া বাঞ্চা নামজম নাতিনাংগে দঃহ কেৎ বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","ইনিদ আবু নাতিনাং গচ লেনায়, চির্গালবু তাহীন চি গিতিচ শ্চ য়াবু, যীশু লঅগে বু জীউৎ তাহীন কাআ। ");
INSERT INTO cdz_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","এন্খান চিল্কা আপে দ করা আগু তাৎআপে, এঙ্কাগে আপান আপিন কে ভরসা এমা কূপে, হেৎদ আপান আপিন কে গাঁথা রাকাবআপে। ");
INSERT INTO cdz_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","মেন্খান এ হাগা মিসি কু, আলে আপে কেলে নেহরাপে তানা; অকয়কু অপেয়ায় তালা রে কামী তানাকু হেৎদ প্রভু নুতুম তে আপেয়ায় চেতান রে বহাল মেনাঃআ কুয়া হেৎদ আপেকে চেথ এমাপে তানা কু, ইঙ্কূ কে মৌন এমাকুপে। ");
INSERT INTO cdz_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","হেৎদ আকুয়াআ কামি নাতিনাং ইঙ্কূকে দুলাড়তে নামলেকান কু আটকার কুপে। আপে মেসাজুড়িআকান পে ");
INSERT INTO cdz_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","হেৎদ এ হাগা মিসি কু, আপে লে বিন্তিয়াপে তানা অকয় কু পাড়ুয়া গেয়া, ইঙ্কূ কে চেথ এমাকুপে, ঢুর্কা কুকে স্বান্তনা একা কূপে, নিজুরি কুকে দেঙ্গা কূপে, যত হড় নাতিনাং সাহায়চ হুইপে। ");
INSERT INTO cdz_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","নেলেপে যাহায় গে যাহায় বিন উপ্কার হালা রাঃআ নাতিনাং যাহায় রাঃআ আলয় বিন উপকারে কাআয়, মেন্খান আপান আপিন হেৎদ জত্চ কু লঅ বেশ আচরণ নাতিনাং কুরুমুটু কাআয় (1 পিতর 3:9) ");
INSERT INTO cdz_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","সারাঘাড়ি রাঃআসকা পে। ");
INSERT INTO cdz_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","হেৎদ সারাঘাড়ি বিন্তিয়েপে। ");
INSERT INTO cdz_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","যত বাব্ত্ত কুরে সারহাও পে, চিয়া চি নিয়া দ খ্রীষ্ট যীশু রে আপে নাতিনাং ঈশ্বর রাঃআ ইচ্ছা তানা। ");
INSERT INTO cdz_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","রিলামালা আত্মাকে আলো পে ইড়িচ ইয়া। ");
INSERT INTO cdz_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ভাবি জাগারাঃআ কু আলো পে খাট কুয়া। ");
INSERT INTO cdz_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","যত বাব্ত্তে তুনুম আটকারেপে, অকাঃআ বুগিনা,ইনা যত সাপ ধ্যয়পে। ");
INSERT INTO cdz_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","যত লেকান বাড়িচ হাতেন সাঙ্গিন রে তাহীনপে। ");
INSERT INTO cdz_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","হেৎদ জিউ সুলুক রিনিচ ঈশ্বর আচ গে বেসলেকা কাতে রিলামালা পে কাঃআয়, হেৎদ আপেয়া আত্মা, জিউ, হড়ম গোটাকু হেৎদ আবুয়া প্রভু যীশু খ্রীষ্ট রুয়ার হিচু হুলাং উতার মৌন রুখিয়া দঃহয় কায়। ");
INSERT INTO cdz_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","অকয়্য় আপেকে রাঃআ পেয়ায়্য়, ইনিদ পাতিয়ানিচ, ইনিগে এঙ্কা করায়ায়। ");
INSERT INTO cdz_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","এ হাগা মিসি কু, আলে নাতিনাং বিন্তি পে। ");
INSERT INTO cdz_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","যত হাগা -মিসি কুকে রিলামালা তে চঅ লঅ আতাং দারম কুপে। ");
INSERT INTO cdz_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ইঞ আপেকে যীশু নুতুম তে গামাপে তানাঞ, যত হাগা মিসি কুকে নিয়া গিরা সেকাম ফড়াহা আয়ুমাকুপে। ");
INSERT INTO cdz_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","আবুয়া প্রভু যীশু খ্রীষ্ট রাঃআ দায়া-দুলাড় আপে লঅ তাহীন কা।");
INSERT INTO cdz_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","পল, সীল হেৎদ তীমথিয় আবুয়া আপু ঈশ্বর হেৎদ প্রভু যীশু খ্রীষ্ট রাঃআ থিষলনীকীয় শেহার রেঙ্কূয়া মন্ডলী রাঃআ হান্ডে, ");
INSERT INTO cdz_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","আবুয়া আপু ঈশ্বর হেৎদ প্রভু যীশু খ্রীষ্টরাঃআ থাং হাতেন সায়াদ/দায়াদুলাড় হেৎদ সুলুক আপেয়া হুইও কাঃআ ");
INSERT INTO cdz_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","এ হাগা মিসি কু, আলে আপে নাতিনাং মিৎ সরগ নাগাড় তে ঈশ্বর এ গুনমান জহারিপে। এন্তে এনকা লেখান দ গটা গেয়া, চিয়া চি আপেয়া পাতিয়া ঢের হারা-রাকাব ইদিতানা হেৎদ আপে মিমিৎ হড় এটাগিজ নাতিনাং তে দুপুলাড়-দুলাড় ঢের-বুরু ইদি তানা। ");
INSERT INTO cdz_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ইনা মেন্তে আপে দ নানতিৎ জ্বালা হেৎদ কষ্ট সাহা তাৎআপে, ইনাকু তালা হাতেৎ রহঅ আপেয়া ধৈর্য্য হেৎদ পাতিয়া তাহি নাতিনাং তে আলে ঈশ্বর রাঃআ মন্ডলী কুরে আপে নাতিনাং তেলে গরবো তানা। ");
INSERT INTO cdz_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","অটঃহঅ ইনা দ ঈশ্বর রাঃআ ধরম দরবার রাঃআ স্পষ্ট নিশান, যাতে আপে ঈশ্বর রাঃআ রাজ নাম লেখান উপযুক্ত মেন্তেপে লেখা হুইঅয়া, ইনা নাম নাতিনাং তেগে দুখ পে সাহায় তানা। ");
INSERT INTO cdz_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","নিয়া দ গটা ঈশ্বর রাঃআ হান্ডে ন্যায় ধরবার মেনাঃআ, অকয় দুখ এমাপে তানকু, ইনিদ উংকুয়া হান্ডে দুখ হালা রুয়াড়এয়া। ");
INSERT INTO cdz_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","হেৎদ দুখ অকয় কূপে নামেৎআ, আপেকে আলে লঅ ঝিরাবাসং এমা পেয়ায়্য়, চিন্তং প্রভু যীশু সরগ হাতেৎ আয়া নিজ দাড়িয়ান সরগ নাগা কুলঃঅ দাঙ্গালদাঙ্গাল লঅ তানা সেঙ্গেল লেকা সদরয়ায় (যোহন 1:14-15, প্রাকাশিত বাক্য 14:13) ");
INSERT INTO cdz_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","হেৎদ অক্য়য় আবুয়া ঈশ্বরকে কাকু সারিয়া হেৎদ প্রভু যীশু রাঃআ বুগিন জাগাররে কাকু মানাবাতায়া, ইঙ্কু কে ইনিদ সাজা এমা কুয়ায়্য় য় (গীত সংহিতা 79:6, যিশাইয় 66:15, যিরমিয় 10:25) ");
INSERT INTO cdz_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","ইঙ্কূ ঈশ্বর রাঃআ সামাং হাতে হেৎদ ইনি রাঃআ দাড়িয়ান প্রতাপ হাতেন ফারাগ ভেগারতেকু যায়-যুগ নাতিনাং তেকু সাজাকু ভোগেয়া (প্রাকাশিত বাক্য 21:8, মথি 25:41, 46, যিশাইয় 2:19, 21) ");
INSERT INTO cdz_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","নিয়াদ ইনা হুলাং হয়ুয়া, অকা হুলাং ইনি আয়াআ নিজ রিলামালা হড় কু লিয়া সরসয়ায়্য় হেৎদ যত পাতিয়ান হড় হাহাড়াকু, আপে হঅ মেশা মেনাআ পেয়া চিয়াচি আলেয়া লুকুন্দ আপে পাতিয়া কাতে আতাং তাৎআপে (1 থিষলনীকীয় 2:13, 1 করিন্থীয় 1:6, গীত সংহিতা 89:7, যিশাইয় 49:3) ");
INSERT INTO cdz_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","ইনা নাতিনাংতে আলে সারাহুলাং বিন্তিই তানালে, যাতে আবুয়া ঈশ্বর আপে জ্ত্চ কে রারাঃআঃ রাঃআ উপযুক্ত লেকাতে আতাং পেয়ায়্য়, হেৎদ গুনমান্তান রাঃআ যত ইচ্ছা হেৎদ পাতিয়া রাঃআ কামী আয়াআ নিজ দাড়ীয়ান্তে পুরায়ায়; ");
INSERT INTO cdz_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","হেৎদ ইনা তে আবুয়া ঈশ্বর রাঃআ হেৎদ প্রভু যীশু খ্রীষ্ট রাঃআ দায়াদুলাড় লেকাতে আবুয়ায় প্রভু যীশু রাঃআ নুতুম আপেয়া তালারে গুনমান্তানঅ কাআ হেৎদ ইনা হর লেকাতে আপে হঅ গুনমান্তানঅ পে (যিশাইয় 24:15, যিশাইয় 66:5, 1 পিতর 1:7-8) ");
INSERT INTO cdz_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","অটঃ হঅ, এ হাগা মিসি কু, আবুয়া প্রভু যীশু খ্রীষ্ট রাঃআ হিচু হেৎদ আয়ায়া হান্ডে আবু কে ইদি হুন্ডি নাতিনাং লে নেহরঅ তানা। ");
INSERT INTO cdz_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","আপে যাহান আত্মা লিয়া, চি জাহান থুতি জাগার লিয়া, চি আলেলে অলা তাৎপে লেকা, গিরা সেকাম লিয়া, মন রাঃআ যেদ হাতেত আলম হান্তে নাতেয়া চি আলম চমকাঃআ,আলম হুদিসেয়া যে প্রভু রাঃআ রুয়াড় হিচু মাহা সেটেরেনা; ");
INSERT INTO cdz_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","যাহায় যাহালেকা তে আপেকে আলকু প্টাপেকাআ, চিয়াচি ইনা মাহা দ কা হিচু য়া চিন্তং উতার ইনি বিন ধরম মান্মিৎ ইনি বিনাশ-হন কায় সদরয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","অকয় বিরূধে য়ায়্য় ইনিদ আচকে ঈশ্বর রাঃআ নুতুম তে হেৎদ মান্তান যত কুরাঃআ হাতেত আচ নিজেকে মারাংইয়ায়্য়, নেকা হঅ হুয়য়া ইনি ঈশ্বর রাঃআ জাহের স্থান রে দুপ কাতে আচ নিজেকে ঈশ্বর মেন্তে গাম্যয়ায়্য় (যিশাইয় 28:2, দানিয়েল 11:36, 37) ");
INSERT INTO cdz_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","অপেয়ায় দ চি পাহাম কা হিচু তানা, মাড়াংতে ইঞ আপেয়া হান্ডে চিন্তং তাহীন কেনাইঞ ইন্তং আপেকে নিয়াকু জাগরেত পেকেনাইঞ? ");
INSERT INTO cdz_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","হেৎদ ইনি যেন নিজ মাহা রাঃআ সদরঅ কাআ, ইনা নাতিনাং ইনিকে কিনাআ তে বাধা তে দহ হুয়া কানা, ইনা মাপে সারিগেয়া। ");
INSERT INTO cdz_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","চিয়া চি বিন ধরমীয় রাঃআ উকু মেনাআ দাড়ি নাহাআ হঅ কামী তানায়; মেন্খান চিমিন ভুর হানিকে কুদা গিডি ক হয়ুয়া, ইমিন ভুর অকা কামিরে বাধা দহ তাৎআয় ইমিন ভুর ইন্কা কামী ইদিয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","হেৎদ ইন্তং ইনি বিন ধরমীয় সদরয়ায়্য়, মেন্খান প্রভু যীশু আয়ায়্য় মচা রা আ সাহেতে ইনি এ উদু-সদরোআয়, ইনি প্রভু আয়া মচারেয়া সাহেত ইনি দুষ্ট মান্মি কে ভসমিয়ায়, হেৎদ নিজ রুয়াড় হিচ সদর নাতিনাং হানি রাঃআ দাড়ি কমা চাবায়ায়্য় (ইয়োব 4:9, যিশাইয় 11:4) ");
INSERT INTO cdz_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ইনি অধার্ম্মিক হড় শয়তান রাঃআ দাড়ি তে হিচু য়ায়, অকাআ লাভাকিয়া নানান হুনার হাহাড়া কামীকু হেৎদ যত লেকানাআ চীনহা কু হেৎদ আকাধান্দা নালাআকু তাহিনা, ");
INSERT INTO cdz_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","হেৎদ অকয় কু বিনাশঅ তানা উন্কু কে খাটঅ নাতিনাং যত রকম রাঃআ অধার্মিক রাঃআ হাতিয়ার কামিরে লাগায়ায়; চিয়াচি ইঙ্কূ বানচা নাতিনাংতে সার্তিরাঃআ দুলাড় কাকু আতাং তাৎআ। ");
INSERT INTO cdz_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","হেৎদ ইনা নাতিনাং ঈশ্বর ইঙ্কূয়া হান্ডে চমক-চাম্ক লেকানাআ কামি কূলেয়ায়, যাতে ইঙ্কূ ইনা বেদা থুতি-জাগারকু পাতিয়াকাআ, ");
INSERT INTO cdz_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","যাতে ঈশ্বর ইঙ্কূ যত হড়কুকে ধরবার দরবাররে দায়ী/দোষী দাড়িয়া কুকাঃআয়, অকয়কু সার্তিকে কাকু পাতিয়া কানা, মেন্খান অধার্মিকরে তাহিকাতেন খুশিকু তাহিলেনা। ");
INSERT INTO cdz_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","মেন্খান এ হাগাকু, প্রভু রাঃআ দুলাড়াকানকু, আলে আপে নাতিনাং যত মাহা ঈশ্বরকে ধন্যবাদ এম বাধ্য়তানালে, চিয়াচি ঈশ্বরদ মাড়াং হাতেন আপেকে আত্মারাঃআ রিলামালা এমকাতে হেৎদ সার্তিরাঃআ পাতিয়ারে বাঞ্চা নাতিনাং বাছাতাৎপেয়ায় (ইফিসিয় 1:4, 5, 1 পিতর 1:1-5, দ্বিতীয় বিবরণ 33:12) ");
INSERT INTO cdz_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","হেৎদ ইনা দিশা কাতে আলেয়া বুগিন বার্তা নাতিনাং তে আপেকে রাঃআ তাৎ পেয়ায়্য়,যাতে আপে আবুয়া প্রভু যীশু খ্রীষ্ট রাঃআ গুনমানত রে হাটিং নামিচ হুই দাড়িয়াপে। ");
INSERT INTO cdz_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","এন্খান এ হাগা মিসি কু, তিঙ্গুকেটেচ পে হেৎদ আলেয়া জাগার তে চি আলেয়া অলতেপে চেদাকান জাগার কু স্বাব দহয় পে। ");
INSERT INTO cdz_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","হেৎদ আবুয়া প্রভু যীশু খ্রীষ্ট গে হেৎদ ঈশ্বর আপুগে, অকয় দ আবুকে দুলাড় তাৎ বুয়ায় হেৎদ যায়-যুগ রাঃআ জিউ রাড়েজ হেৎদ সরেষ আশ এমাৎ বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","ইনি আপেয়া অন্তররে রাড়েজে কাঃআয় হেৎদ যত বেশ লেকানাআ কামিরে হেৎদ জাগাররে দাড়িয়ান এমে কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","মুচাৎ জাগার নিয়া, এ পাতিয়ান হড়কু, আলেয়াঃআ নাতিনাং বিন্তিইপে, চিল্কা আপেয়া ভিতিরে হ্যুই তানা, এঙ্কাগে প্রভু রাঃআ জাগার গোটা পাসরাঃকা আ হেৎদ গুন্মান্ত হ্যুই কাআ, ");
INSERT INTO cdz_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","অটঃহঅ আলে চিল্কা দুষ্টু হেৎদ বাড়িচ হড় রাঃআ হান্ডে হাতেত রুখিয়া নাম নাতিনাং বিন্তিপে; চিয়াচি জ্ত্চ রাঃআ পাতিয়া বায়ানা। ");
INSERT INTO cdz_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","মেন্খান প্রভু বিশ্বস্ত; ইনিগে আপেকে দাড়ি য়ান পেয়ায়্য় হেৎদ শয়তান-বঙ্গা হাতেন রুখিয়া পেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","অটঃহঅ আপেয়া বাব্ত্তে আলে গাদা পাতিয়া মেনাঃআ প্রভুরে মেনাঃআ পেয়া মেন্তে, আলে আপেকে অকা অকাঃকুলে গাম দহা তাৎ পেয়া, ইনা যতচ াআ কু মানায় তানাপে হেৎদ মানা আগুই গেয়াপে। ");
INSERT INTO cdz_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","হেৎদ প্রভু আপেয়া অন্তর কে ঈশ্বর রাঃআ দুলাড় হরাতে হেৎদ খ্রীষ্ট রাঃআ সারি হরাতে সুতুঃ পেয়ায়। ");
INSERT INTO cdz_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","হেৎদ, এ হাগামিশিকু, আলে প্রভু যীশু খ্রীষ্ট নুতুম তে নিয়া লে আচুপে তানা, যাহায় হাগা পাড়ুয়া গেয়ায়্য়, হেৎদ আপে আলেয়ায়্য় হান্ডে হাতেত অকা চেচেদাঃআ নামতাৎআ পে, ইনা লেকা ইনি কায় সেসেনায়, ইনি লঅ দ অল্পে তাহিনা, ");
INSERT INTO cdz_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","আপে দ চিল্কা তে আলেয়াঃআ সুতুঃপে হয়ুয়া, ইনা মাপে সারি গেয়া, চিয়াচি অপে লঃঅ তাহীন অক্ত আলে পাড়ুয়া কালে তাহীন কেনা, ");
INSERT INTO cdz_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","হেৎদ যাহায় রাঃআ হান্ডে মাডি/জমা বেগর গনং তে কালে জমেৎ কেনা, আপে যাহায় রাঃআ হান্ডে লাৎ ি কাতে আল লে তাহীন কাঃআ, ইনাতে খাটাঃ হেৎদ মেহনত লঅ সিঙ্গি নিদালে কামীৎ কেনা। ");
INSERT INTO cdz_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","আলেয়া আইদারি যে বায়না, মেন্তে দ ল্হয়, মেন্খান আপেয়া হান্ডে আলে কে উডুঃ সদর নাতিনাং লে উডুঃতাৎ পেয়া, যাতে আপে আলেয়াআ অতংঅ কূ লেকাপে হুই দাড়িয়া। ");
INSERT INTO cdz_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","চিয়ায় চি আলে চিন্তং আপেয়া হান্ডেলে তাহীন কেনা, ইন্তং আপেকে নিয়া লেকা গামা তাৎপেয়া যে, যাহায় যদি কাকু কামিয়া, তবেখান ইনিদ আল্য়য় জমে কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","আলে আয়ুম নামে তানালে, আপে তালা রে অকয় হড় কুদ গায়া লেকা মেনা কুয়া, জাহান কামী কা কামী কাতে বিন আইদারি জাগার কু সগা ভাড়াৎআ। ");
INSERT INTO cdz_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","নিয়া লেকা হড়কুকে আলে প্রভু যীশু খ্রীষ্ট রাঃআ নুতুম তে বাত্লা হেৎদ চেৎনা লে এমাকু তানা, ইঙ্কূ থীর থার কাতে আকু তেগে কামী কাতে জমে কাআ কু। ");
INSERT INTO cdz_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","হেৎদ এ হাগামিশিকু, সৎ কামিকুরে আলপে কাদরাঃআ, ");
INSERT INTO cdz_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","হেৎদ যাহায় নিয়া গিরা রে অলা কান লেকা জাগারকু কাকু বাতায়া, তবেখান ইনিকে নেল চিহ্না তাইপে, হেৎদ ইনি লঅ আল পে মেসা। ");
INSERT INTO cdz_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","যাতে ইনি গিয়ুগ কায়ায়্য়; তবু রহঅ ইনিকে বাইরী মেৎতে দ অল্পে নেলিয়া হাকা তানায় মেন্তেগে চেৎনা এমাই পে। ");
INSERT INTO cdz_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","হেৎদ সুলুক রিনিচ প্রভু আয়গে সারা ঘড়ি যতলেকানাতে আপেকে সুলুক বুরুয়া পেকাঃআয়। প্রভু আপে যতচ কু লো তাহীন কাঃআয়। ");
INSERT INTO cdz_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","নিয়া মৌন জহার ইঞ পল নিজ তিহিতেইঞ অলাপে তানাইঞ, নেকা গে যত গিরা কুরেইঞ ওলে তানাইঞ। নিয়া গে চিহ্না। ");
INSERT INTO cdz_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","আবুয়া প্রভু যীশু খ্রীষ্ট রাঃআ দায়া দুলাড় আপে য়া যতচ কু রাঃআ হান্ডে তাহীন কাআ।");
INSERT INTO cdz_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","পল, আবুয়াঃআ ত্রানকর্তা ঈশ্বর রাঃআ হেৎদ আবু য়াঃআ আসাইচ খ্রিস্ট যীশু রাঃআ হুকুম লেকাতে খ্রিস্ট জিসুরাঃ আ কুলিইচ ");
INSERT INTO cdz_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","পাতিয়ায়চ থিমথিয়া ইঞাঃআ হন আমাঃআ হান্ডে। ঈশ্বর বা রাঃআ হেৎদ প্রভু যীশু খ্রিস্ট রাঃআ হান্ডে হাতেত দায়াদুলাড়, দায়া হেৎদ সুলুক নামেকাম/তাহীন কাঃআ ");
INSERT INTO cdz_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","চিল্কা মাকিৎ ানিয়া টলাতে সেনঅঃঅ বেত্রাঙ আমকে চিল্কা অনুরোধ লাত মাঞ যে আম ইফিষ শেহার তে তাহি কাতেত হড় কুকে নিয়া হুকুম এমা কুম, যাতে উনকু এটা চেচেদাঃআ আলকু এমাকু কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","কাহিনী হেৎদ কুলরাসীতে মন আলম এমেয়া, চিয়াঃ চি ইনা যত দ বিতন্ডা হ্যুই তুকায়ায়, ঈশ্বর রাঃআ অকা দোলতিয়া রাঃআ কামী দ পাতিয়ারাঃআ বেপার, ইনা লেকা বায়াঃনা ");
INSERT INTO cdz_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","অকাঃআ সাপা আত্মা, স্ত্সংবেদ হেৎদ অকল্পিত পাতিয়া হাতেত উত্পন্ন; ");
INSERT INTO cdz_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","কিছুহড় কু নিয়া যত হরা হাতেত ভ্স্ট হুই কাতে 'বেদা ভছড়ীয়া লেকা ইটাঃআ হরা তে কু সেনা কানা। ");
INSERT INTO cdz_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","উঙ্কুদ বেবস্থা রাঃআ চেচেদিচ্কু হুই বুঝাকু তানা অথ্চ অকাঃআ কু গামেয়া, হেৎদ অকা বাব্ত্তে গটা মেন্তে কথা কু গামেয়া ইনা রাঃআ যাহানাঃআ কাকু সারিয়া। ");
INSERT INTO cdz_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","মেন্খান আলে সারিয়ালে, বেবস্থা ভাল যাহায় যদি বিধিমতে ইনা কু বেবহারেয়া ");
INSERT INTO cdz_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","নিয়া সারি কাতে গেকু করায়া যে, ধর্মিক রাঃআ নাতিনাং দ ল্হয়, মেন্খান অকয় কু বিধার্মিয় হেৎদ অদম্য, ভুকতিহীন হেৎদ কাই ী, সাধুল্হয়, হেৎদ ধর্মবিরূপ, অপু গ্জিচ, মাইগ্জিচ, হড়গ্জিচ, ");
INSERT INTO cdz_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","রেন্ডা, হড়ম সানায়চ, অটঙ্গা, লাব্বাক, বেদা এক্ড়ারইচ, উঙ্কু খাতির হেৎদ যত কিছু বুগিন ছেদা রাঃআ উল্টা, ইনি রাঃআ বেবস্তা বানা হুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","গাদা সারাও, ইস্বরাঃ অনা গুন্জহার বুগিন সমাচার লেকাতে, অকা বুগিন সমাচার ইঞা হান্ডে গুছিয়া কাতে মেনাঃআ ");
INSERT INTO cdz_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","অকয় ইঞ কে দাড়ি এমাতিইচঞা, আবুয়াঃআ প্রভু যীশু খ্রিস্ট কে সারাও এমাইতানা, চিয়াঃচি ইনিদ ইঞ কে বিশস্ত জ্ঞান এম কাতেত দেখ-ভাল রাঃআ নাতিনাং বহাল তিইঃঞায়। ");
INSERT INTO cdz_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","যদি ও ইঞ মাড়াংতে ধরম নিন্দক, কুদাগিডিয়চ, অপ্মানিচ তাহিলেনাঞ; মেন্খান দয়াঞ ঞাম তাঃআঞ, চিয়াঃ চি কা সারি কাতেত অপাতিয়ান রাঃআ মহতে এনকান কামিত কেনাঞ; ");
INSERT INTO cdz_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","আবুয়া প্রভু রাঃআ দায়াদুলাড়তে, খ্রিস্ট যীশু রাঃআ বাব্ত্তে, পাতিয়া, হেৎদ দুলাড় লঃঅ, মিতগাদা দুলবুরু য়া তিইঃঞায়। ");
INSERT INTO cdz_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","নিয়া জাগার পাতিয়ালেকানা হেৎদ যতবাব্ত্তে লেকাতে গ্রহনলেকানাঃআ যে, খ্রিস্ট যীশু কাই ী কুরা ঞাতিনাঙ পরিত্রান এম কুরাঃআ ঞাতিনাঙ দিসুমতে হিচা কানায়; উঙ্কু কুরাঃআ তালারেনিচ ইঞগে মাড়ং লেখাতে রেনিচ; ");
INSERT INTO cdz_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","মেন্খান নিয়া নাতিনাং দয়াঞাম তাঃআ, চিয়াঃ চি যীশু খ্রিস্ট নিয়া মাড়াংইদি নাতিনাঙ ইঞকে সম্পুর্ন সাহাও দাড়ি নাতিঞাং সতুঃ তি ইঞায়, যাতে ইঞ আকুয়াঃআ আদর্শ হুই দাড়ি কাঃআঞ, অক্য়্কু জায়্যুযুগ জীউ রাঃআ নাতিনাঙ পাতিয়া আঃকু ");
INSERT INTO cdz_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ইনিদ যুগযুহড় রেনিচ রাপাজ, অক্ষয়, অদৃশ্য মিত ঈশ্বর, যুগযুহড় রেনিচ যুগ যুগ আয়াঃআ গুনমান হেৎদ গুনজহার হযুঃ কাঃআ, আমেন ");
INSERT INTO cdz_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","তিম্থিয় আম ইঞা হনলেকা, আমাঃ বাব্ত্তে গাদা মাড়াং হাতেত যত ভাবীজাগার লেকাতে ইঞ আমাঃ আ হান্ডে নিয়া হুকুম সম্পা কেৎ আঞ, যেন আম ইনা কুরাঃআ গুনালেকাতে বেশগটা লাড়াই দাড়িম, ");
INSERT INTO cdz_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","যেনপাতিয়া হেৎদ বুগিনহাদিস বান্চাধ্হম; বুগিন্হ্দিস সাঁঙ্গিঞ দরলেপ্দাগিডিতে অকয় অকয় কুরা দ পাতিয়া রুপি লাউকা পেটেচা কানা। ");
INSERT INTO cdz_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","উঙ্কু কুরাঃআ তালারেন্কু কুদ হুমিনয় হেৎদ আলেকজান্দার; ইঞ হান্কিনকে শয়তান রাঃআ তিহিরে স্প্মা তাতকিনাঞ, যাতে ইঙ্কিন হার্কেৎ সাসেত ঞাম কাতেত ধরম নিন্দা ব গীরা চেতনা কিন ঞামে কা আ। ");
INSERT INTO cdz_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","যত হাতেত মাড়াংতে ইঞা সদর উচাড় নিয়া, যেন যত মান্মি নাতিনাং বিন্তি প্রাথ্না, অনুরোধ, সারাও হযু কা আ; ");
INSERT INTO cdz_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","রাপাজ কুরাঃআ হেৎদ গুন্মানিয়াকু জ্ত্চ খাতির; আবু যেন সম্পুর্ন ভুক্তিতে হেৎদ নিরসলঅ থীরহেৎদ থীর-থার জিবান -যাপন করা দাড়ি কা আ বু। ");
INSERT INTO cdz_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","চিয়াচি আবুয়া আ ত্রানকর্তা ঈশ্বর রাঃআ সমাংরে ইনা কুগে উত্তম হেৎদ গ্রাহ;আয়া আ ইছা নিয়াগে, ");
INSERT INTO cdz_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","যাতে গঠা ধরতি রিঙ্কূ মান্মি পরিত্রান কু ঞামে কাঃ আ হেৎদ সার্তি রাঃআ তত্ত্বজ্ঞান অবধি সেটের দাড়ি কা আ (যিহিস্কেল 18:23) ");
INSERT INTO cdz_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","চিয়াঃচি ঈশ্বরদ মিয়াৎ গে মেনাইঞা; ঈশ্বর রাঃআ হেৎদ মান্মি রাঃআ তালারে মিয়াৎ আগুহা মেনাইয়া ইনিদ মান্মি তানায়, যীশু খ্রিস্ট ");
INSERT INTO cdz_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","ইনি দ যত হড় রাঃআ খাতির মুক্তি রাঃআ মূল্য লেকাতে আচনিজ কেগে এম্তিয়ায়;নিয়া সাক্ষ যথাসময়রে দাতব্য;ইঞ ইয়া রাঃআ উদ্দেসতে পাসনা ক হেৎদ কুলিচ মেন্তে বহালা কানাইঞ; ");
INSERT INTO cdz_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","সার্তি গামেতানাঞ বেদা কাইঞ গামেত য়াঞ গামিচ কুলিচ হেৎদ পতিয়াতে হেৎদ সত্তে ইঞ বিন যিহুদিকুরাঃআ চেদিচ ");
INSERT INTO cdz_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ইনাতে ইঞাআ বাসনা নিয়া, যত জায়গা কুরা হেরেল্কু কা রাগ্তে হেৎদ কা নিয়ায়্তে ছুত তিহি চেতাং তুল্কাতে প্রার্থনা কায়াকু। ");
INSERT INTO cdz_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","এনে এঙ্কা গে কুড়ি হন কু হ অ গিয়ু ল অ হেৎদ বুদ্দিতে, পাঠেকেৎ অয়র তে বেশ গটা সাজা কা আ কু;গলাং সুপেত উপরে হেৎদ সনা-দানা চি মুক্তা চি গাদা দামিয়ান সাজ্গ্জতে দ ল্হয়, ");
INSERT INTO cdz_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","মেন্খান অকয় ঈশ্বর ভুক্তি পাতিয়ান কুড়ি হন কু জগ্গ স্ত্কামিকুরআ ভার তাহীন কা আ, ");
INSERT INTO cdz_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","কুড়ি হন কু বেশ গটা বহাল তে মনতে ছেদ কা আকু, ");
INSERT INTO cdz_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ইঞ চেতনা জাগার এম রাঃআ বান্খান হেরেল কু রাঃআ চেতান রে আইদারি রাঃআ অনু মতি কাঞ এমেয়া, মেন্খান থীর থার তাহীনিঞ গামাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","চিয়াঃচি আদমকে (পিল্চু হাড়াম)মাড়াং, হবাকে (পিল্চু বুডি) তায়্মতে বানালিআয় (1 করিন্থীয় 11:8) ");
INSERT INTO cdz_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","হেৎদ আদম অবাধ্ধ কায় হযুলেনা, মেন্খান এরাহন অবাধ্ধএন্তে অপরাদতেপেরেচ এনায় (আদিপুস্তক 3:6) ");
INSERT INTO cdz_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","যদি পটিয়াতে আত্মাসংযোম, দুলাড় হেৎদ রিলামালাতে উঙ্কু থীর তাহীনা কু, তবেখান উঙ্কু দ হন জনম কাতেত পরিত্রান কু ঞামেয়া। ");
INSERT INTO cdz_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","নিয়া জাগার কুদ পাতিয়া লেকানা আ, যদি যাহায় চেচেদিচ রাঃআ গুরুভার হাতা রাঃআ আক্ষাঙ্কা হ্যুয়া, তবে ইনি বুগিন কামীরাঃআ ইচ্ছাযায়। ");
INSERT INTO cdz_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","এন্খান নিয়াদ হইতারাঃআ, চেচেদিচরাঃআ ঞতুম খারাপ ল্হয়, মিত এরা রাঃআ হেরেল, সিবিল থুতি জাগার, হড়মক্ব্জ, সাজ-গজ, পাহিখাতিরিচ, হেৎদ চেচেদ এমরে পুটু হ্য়ুউম; ");
INSERT INTO cdz_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","আরখি -ক্লাঙ্ রে ডুঁবুচ চি দাদালিচ আলম হয়ূয়া মেন্খান নিরহ, নির্ব্বিরোধ হেৎদ অর্থলোভি আল তাহীন কা আ ");
INSERT INTO cdz_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","আমাঃ আ নিজ পরিবার/ঘারঞ্জ শাসন বেশলেকাতে করাম, হেৎদ নিরশ তে হন-হপন কুকে বসতে দহ কুম; ");
INSERT INTO cdz_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","মেন্খান যদি যাহায় অড়া আ শাসন কায় দাড়িয়া আ, ইনি চিল্কাতে ঈশ্বর রাঃআ মন্ডলী (ঘারঞ্জ) লালন -পাল্নেয়া ? ");
INSERT INTO cdz_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","ইনিদ নামা চেলা আলয় হয়ুঃকাঃআ পালেত গরব কাঁড়া কাতেত শয়তান রাঃআ ধরবাররে নুরুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","হেৎদ মন্ডলী বাহার রিঙ্কূ হড় কু রাঃআ হান্ডে হ অ বেশ সাক্ষ হাতা আয়া আ করনীয়, পাছে তিরস্কারতে হেৎদ শয়তান রাঃআ জলরে ঝালিয়ায়। ");
INSERT INTO cdz_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","এনেএঙ্কাগে ঞেল আতেন কুরাঃআ হ অ করনীয়, যেন উঙ্কু ধীর হয়ুকা আ কু, যেন বারথুতিয়ান, ক্লাঙ্ আরখি তে ডুঁবুজ, খারাপ হরকাতে আয়কাতে কিসাড়রাঃআ ইচ্ছা আল তাহিনকা। ");
INSERT INTO cdz_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","হেৎদ সুচি সংবেধরাঃআ পাতিয়া রাঃআ নিগূড়তত্ত্ব আতাঙ এম ");
INSERT INTO cdz_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","হেৎদ মাড়াংতে উন্কুকে হ অ বিধাও য়ু কা আ যদি উঙ্কু আ দুর্নাম বায়া আ না এনকান নেলাতেন রাঃআ কমীরা তাহীন কা আ কু ");
INSERT INTO cdz_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","এনে এঙ্কাগে এরা হনকু হ অ গে ধীর, অপবামাহা ী ল্হয়, সিবিল লান্দাথুতি, হেৎদ যত বেপার রে পাতিয়ানিচ হযু কা আ ");
INSERT INTO cdz_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ঞেল আতেন কুরাঃআ মিত মিত হড় কু রাঃআ মিত মিত বাহু বর হযু কা আ কু, হেৎদ হন হপন কুকে হেৎদ নিজ অড়া দুয়ার বেস্লেকাতে শাসনেম। ");
INSERT INTO cdz_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","চিয়াঃ চি অকয় বেসলেকাতে ঞেল আতেন রাঃআ কামী পুরা তাত আয়, উঙ্কু আকুয়াআ খাতির সুপ্রতিষ্টা, হেৎদ যীশু খ্রিস্ট রাঃআ বাব্ত্তে পাতিয়ারাঃআ গাদা সাহস লাভ নামেয়া। ");
INSERT INTO cdz_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","ইঞ খুব ঘিড় মেন্তাং আমাঃ আ হান্ডে হাজির র অআইঞ, নিয়া আস তেনিয়া কুঞ অলাম তানা;মেন্খান যদি ইঞা আ বিলম্ব আ, ");
INSERT INTO cdz_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","যদি ইঞা হিচু রাঃআ দেরিয়া তবে আম সারিঞামে য়াম যে ঈশ্বর রাঃআ অড়ারে চিল্কা আচার বেবহার করা হ্যুয়া; ইনা অড়া মা জিউতঈশ্বর রাঃআমন্ডলী, সার্তি রাঃআ খুনটু হেৎদ শক্তভিতরে। ");
INSERT INTO cdz_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","হেৎদ ভুক্তি রাঃআ নিগুড় তত্ত্ব ম্হ্ত্ক, নিয়া দ সর্বব সম্মত, অকিৎ মায়ম-জিলুতে স্দরেনায়, নাঙ্গাকুরাঃআ হান্ডে ভেট লেনায়, জাতিকুরাঃআ হান্ডে পাসনাএনায়, ধার্তিরে পাতিয়া লেকাতে আতাঙ লেনায়, আয়া আদাড়িতে চেতাঙ রাকাপ এনায়। ");
INSERT INTO cdz_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","মেন্খান রিলামালা আত্মা স্যাপা স্যাপি গামেতঃ আয়, মুচাত মাহা রে কিছু হড় কুদ পাতিয়া হাতেত সরা হিচু য়াকু বরয়ান আত্মা কুতে হেৎদ বঙ্গা কুরাঃআ লালাযত মন কাতির। ");
INSERT INTO cdz_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","ইনা এমন লাখ্বাকিয়হড় রাঃআ কপটিয়া তেগে ঘটা আ, অকয় কু রাঃআ বিবেক রে লল মেড়ততে দাগাকান লেখা দাগ তাহিনা ");
INSERT INTO cdz_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","উন্কুদ দুতাম মানায়াকু, হেৎদ নানাহুনার জমা আ নু য়া আ মানায়াকু, ঈশ্বর অকা আ অকা আ নিয়া নাতিনাঙ সির্জ্ন তাৎআয়। যেন, অক্য়্কু পাতিয়া হেৎদ সার্তি রাঃআ তত্ত্ব জ্ঞানতে, উঙ্কু সারাও ল জম নুই কা আয় কু (আদিপুস্তক 9:3) ");
INSERT INTO cdz_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","চিয়াচি ঈশ্বর রাঃআ যত সির্জ্নকু গে উত্তম;সারাও লেকাতে হাতা লেখান যাহানা আ গে অগ্রহনীয় ল্হয় (আদিপুস্তক 1:31) ");
INSERT INTO cdz_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","চিয়াঃ চি ঈশ্বর রাঃআ বাক্ক হেৎদ প্রাথ্না তে ইনা কু যত নির্মলা হযুআ ");
INSERT INTO cdz_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","নিয়া যত কথা হাগামিশি কুকে পাহাম তুকা লেখান আম যীশু খ্রিস্ট রাঃআ বুগিন সেবক হ্যুয়াম, অকা পাতিয়া হেৎদ উত্তম চেচেদা আ পাঞ্জা আগুৎ আম ইনি রাঃআ বাক্ক তে তাহিনমে ");
INSERT INTO cdz_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","মেন্খান ইশ্বররাঃআ ভক্তি হেৎদ বাড়িছ এরা হনকু লেকানা আ কাহিনী হাতেত সাঁঙ্গীরে তাহিনমে ");
INSERT INTO cdz_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","হেৎদ দ ভুক্তিতে পুটু হই নাতিনাঙ অভেস এম; চিয়াঃচি হড়ম দাড়িরাঃআ অভ্যাস দ হুডাঙ সময় নাতিনাঙগে; মেন্খান ভুক্তি রাঃআ জ দ যত সময় ভাল, অকা আ দ নাহ আ হেৎদ হাপেন মাহা রাঃআ জীউ রে এক্ড়ার মেনা আ। ");
INSERT INTO cdz_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","নিয়া জাগার কুদ পাতিয়ালেকানা আ হেৎদ হাতা লেকানা আ; ");
INSERT INTO cdz_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","কারন নিয়ারাঃআ খাতির আবু কামী হেৎদ জীউ পেরেচ ইয়া আবু;চিয়াঃচি অকয় যত মান্মি রাঃআ, বিশেষ কাতে পাতিয়ান হড় কুরাঃআ ত্রানকর্তা, আবু ইনি জিউত ঈশ্বর রাঃআ আত্মাসা করাঃআগুতা আ বু ");
INSERT INTO cdz_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","আম নিয়া যত বাব্ত্তে হুকুম য়েম হেৎদ চেচেদ এমেম। ");
INSERT INTO cdz_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","আমাঃ আ যবনিকা যাহা রাঃআ হান্ডে আলম হুঁডিং তুকা য়া; মেন্খান বাক্কতে, আচার বেভারতে, দুলাড়তে, পটিয়াতে, হেৎদ শুদ্ধতাতে পাতিয়ান্কুরাঃআ হান্ডে আদরশবন্ লেকা তাহিনমে ");
INSERT INTO cdz_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","ইঞ চিমিন মাহা উতার কাঞ হিচু আঞ, আম ইমিন মাহা উতার পাঠ হেৎদ নীতি থুতি রাঃআ চেত হাতাড় এম ");
INSERT INTO cdz_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","আপে ইনা অন্তর তালা রাঃআ দায়াদুলাড় রাঃআ দান আলপে অব হেলায়া, অকা আ ভাবিজাগারিচ লিয়া মুরুব্বি কুরাঃআ তিহিতে আমকে এম উচাড়া কানা। ");
INSERT INTO cdz_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","নিয়া কু বাব্ত্তেচিন্তাম, নিয়া যতআথিতি তাম যেন আপেয়া জ্ত্চ রা উন্নতি হযুকা আ ইঞা বাব্তে হেৎদ আমাঃ আ ছেদআ বাব্তে হুঁশিয়ারম, ");
INSERT INTO cdz_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","নিয়া যত বাব্তে থীর তাহিনমে; চিয়াঃচি ইনকাম কামী লেখান আম কে হেৎদ অকয়কু আমাঃ আ জাগার্ কু আয়ুমেয়া, উন্কুকে পরিত্রান কুয়াম। ");
INSERT INTO cdz_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","আমদ যাহায় মুরুব্বিকে আলম এগের কুয়া, মেন্খান ইনিদ অপুলেকা, জুয়ান কড়া হন কুকে হাগা লেকা (লেবিয় পুস্তক 19:32) ");
INSERT INTO cdz_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","মুরুব্বি বুডি কুকে দ মাই লেকা, জুয়ান কুড়ি হনকুকেৎ একদম সাফা মনেতে মিসি লেকা ঞেলিম। ");
INSERT INTO cdz_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","অকয় রাঁডীকুকে নিহাত জরুর তানা, উঙ্কু রাঁডী এরা কুকে আল্লাৎ কূপে। ");
INSERT INTO cdz_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","মেন্খান যদি ইনি রাঁডী রাঃআ হন্হ্প্ন চি হাগা-হন্হ্প্ন কু তাহিনা, উঙ্কু তবে জ্ত্চ হাতেত মাড়াংতে আকুয়াআ আ অড়াঃহড়কে মান্ত্গুনাততে হেৎদ এঙ্গা আপু রাঃআ মান এম ছেদ কা আ কু; চিয়াঃচি ইনাগে ঈশ্বর রাঃআ সামাংরে গ্রাজ আ, ");
INSERT INTO cdz_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","অকয় এরা রাঁডী চি ইনিকে নেল আতেন রিঙ্কূ যাহায় বানুকুয়া, ইনিদ ঈশ্বর রাঃআ চেতানড়ে ভরসা কাতেত নিদা সিঁঙ্গী বিন্তি হেৎদ প্রাথনা তে তাহীন কা আয়, নেল আতেন নাতিনাঙ (যিরমিয় 49:11) ");
INSERT INTO cdz_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","মেন্খান অকয় বিলাসিতানি ইনিদ জিউত তে গচ্ছা কানায় ");
INSERT INTO cdz_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","নিয়া কু যত হুকুম ইম, যেন উঙ্কু পাতিয়ানকুরা আ দুর্না আল হযু কা আ। ");
INSERT INTO cdz_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","মেন্খান যাহায় যদি নিজ সম্পর্কীয় হড় রাঃআ বিশেষ কাতে নিজ পাহি কুরাঃআ কায় দিশা হুদিসেয়ায়, ইনাখান পাতিয়া কামানালাত আয় এন্খান কাপাতিয়ান হড় কু হাতেত হ অ অধমা কানায়। ");
INSERT INTO cdz_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","রাঁডী লেকাতে ইনিগেয় লেখা হযু কা আ, অকয় রাঃআ উমুর ষাট সির্মাং লাতার রে ল্হয়হেৎদ অকয় রাঃআ মিয়াৎ গে হেরেল তাহিলেনায়, হেৎদ অকয় রাঃআ কামান অ অড়ারাঃআ প্রমাণ ঞাম আ; ");
INSERT INTO cdz_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","এন্খান যদি ইনি হন্হ্প্ন আসুলরে মেনাইয়া, যদি পাহি পেড়া কুকে সেবারে মেনাইয়া, যদি নির্মল হড় কুরাঃআ কাটা আবুঙ তাত্যায়, যদি খ্রিস্টান কুরাঃআ উপ্কার তাত্যায় যদি যত বুগিন কামিকুরা পাঞ্জা তাত্যায়। ");
INSERT INTO cdz_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","মেন্খান জুয়ান রাঁডীকুকেৎ অমানত কূপে, চিয়াঃ চি খ্রিস্ট রাঃআ বিরুদরে বিলাসিতানি কু হুই লেন্খান্কু উঙ্কু দ গংঅঃ বুঝা কুয়া; ");
INSERT INTO cdz_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","উঙ্ককু ইনি মাড়াংতে পাতিয়া অগ্রজতে কুড়াই ঞাম রাঃআ হুকুম মেনা আ। ");
INSERT INTO cdz_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","নিয়া ছাড়া উন্কুদ অড়াঃ অড়াঃ দাড়াভাড়াকাতেকু আড়সা আ; সধু আড়সা দ ল্হয়, বাচালিয়া, হেৎদ অনধিকারিন্চর্চা হেৎদ অনুচিত থুতি গাম্কু চেদ্যাআ। ");
INSERT INTO cdz_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","মেন্খান ইঞাআ নিয়া বস্না, জুয়ান রাঁডী কুড়ি হন এরা গংঅঃ কা আ কু, অড়াঃআ আইদারি কা আয়, ইটাহড়কু খারাপ গামেয়া এনেএনকান হরাঃআল তাহীন কা আ ");
INSERT INTO cdz_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","চিয়াঃচি নিয়া মাড়াংতে হ অ অকয় অকয় কুদ বঙ্গা রাঃআ হরাতে সেসেনরাঃআ কূড়াইকু ঞাম তাত আ। ");
INSERT INTO cdz_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","যদি যাহায় পাতিয়ানি রাঃআ অড়াঃরে রাঁডীকু তাহিনা, ইনি উঁকুয়া উপ্কারে কা আয়;মন্ডলী হাঁবালগ্রস্ত আল হুউঃকাঃআ, যেন সার্তি কায়তে রাঁডীকু রাঃআ উপ্কার করা দাড়ি কা আ। ");
INSERT INTO cdz_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","অকয় মুরুব্বিকু বেসলেকাতে শাসনেয়া কু, বিসেস্কাতে উঙ্কুদ বাক্কে হেৎদ ছেদঅ এম ঞাতিনঙ খাটা আ কু, উন্কুদ বারগুন খাতির যতন রাঃআ যোগ আইদারি হয়ুকা আয়। ");
INSERT INTO cdz_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","অটঅ শাস্ত্র গামেয়ায় হুরু চাউলই চাষইচ নাহেল উরিইচ্ রাঃআ মচংরে মহতি আলম ত্লেয়া, হেৎদ কামিয়ান হড় আয়া আ গনঙ রাঃআ যোগ্গ (লেবিয় পুস্তক 19:13; দ্বিতীয় বিবরণ 25:4) ");
INSERT INTO cdz_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","বার অপি হড় সাক্ষি বান্খান মুরুব্বি কুরাঃআ বিরধ রাঃআ নালিস আলম হাতায়া (দ্বিতীয় বিবরণ 17:6, 19:15) ");
INSERT INTO cdz_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","একয় কু কাইয়া পাতিয়ানকু, উন্কুকে জ্ত্চ রাঃআ সামাঙ শাসন কুম; যেন ইটা কু বরয় কা আ। ");
INSERT INTO cdz_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","ইঞ ঈশ্বর কে, যীশু খ্রিস্ট কে হেৎদ বাছান সরগ নাগা কুকে সামাংরে দহ কাতেত আমকে নিয়া আদেশীঞ ইমাম তানাঞ, আম আরিচালি ছাড়া নিয়া বিধি যত পাল্নেম, প্ক্ষপতিত রাঃআ ঝুঁকতে যাহানা আ আলম কামিয়া। ");
INSERT INTO cdz_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","যাহায় রাঃআ চেতান রে ঘিড়মেন্তাঙ তিহি আলম বাড়ায়া, হেৎদ ইটা হড় রাঃআ কইতে আলম ভাগী দারিয়া; আমনিজেকে শুদ্ধ লেকাতে বাঁচাআম। ");
INSERT INTO cdz_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","নাহা আ অব্দি দা আ আলম নুয়া, মেন্খান আমাঃ আ লাহিচ্ নাতিনাঙ হেৎদ আমাঃ আ ঘিড়ঘিড় রুয়া হ্যুয়া মেন্তে ইতিচ তরাঙ কলাঙ বেভারেম। ");
INSERT INTO cdz_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","অকয় অকয় হড়রাঃআ কাই সুস্পস্ট, ধরবার আ হরারে মাড়াংতে;অটঃহঅ অকয় অকয় হড়কুরাঃআ কাই আকুয়াআ তায়্ম তে ");
INSERT INTO cdz_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","সার্তি কামী কু হ অ এনেএঙকা সুস্পস্ট; হেৎদ অকা আ অকা আ এটা আ লেকানা আ, ইনা কু হ অ উকু কা তাহি দাড়ি য়া আ। ");
INSERT INTO cdz_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","অকয় মান্মি যত আরাড় রাঃআ অধীন রিঙ্কূ মুনিস, উন্কুদ আকুয়াআ আ নিজ নিজ গিরিহা কুকে সম্পুর্ন গুনাত মানত কমা, চিয়াঃচি ঈশ্বর রাঃআ ঞুতুম হেৎদ ছেদ্দা আল নিন্দা কা আ। ");
INSERT INTO cdz_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","হেৎদ অকয় কু রাঃআ পাতিয়ান গিরিহা মেনা কু য়া, উঙ্কু দ উন্কুকে হাগা গাম কাটাত আলকু হুঁডিঞ কুক আ; বরঙ অঠহঅগে বেসলেকাতে দাসত্ব কামীই কা আ কু, চিয়াঃচি অক্য়্কু ইনা সদ্ধবেভার রাঃআ জ কু জ্মেয়া, উঙ্কু পাতিয়ান হেৎদ দুলারিচ তানা কু। ");
INSERT INTO cdz_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","নিয়া যত চেচেদা আ এমেম হেৎদ অনুনয়েম। যদি যাহায় এঠাঃ ছেদাঃ ছেদ কুয়া, হেৎদ নিরাময় জাগার, অর্থাৎ আবুয়া প্রভু যীশু খ্রিস্ট রাঃআ জাগার, হেৎদ ভুক্তিরাঃআ লেকানা আ ছেদাঃআ কাকু স্বীকারেয়া, ");
INSERT INTO cdz_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","তবে ইনিদ টেঁঠ ক্র্লায়াত আয়, যাহানা আ কায় সারিয়ায়, মেন্কান বিবাদ হেৎদ নিয়ায় এগের রাঃআ রোগ হ্যুয়া কানা;নিয়া যতচ ারাঃআ জ কুদ রৃষা, গ্প্চ, নিন্দা, খারাপ সন্দেহ, ");
INSERT INTO cdz_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","হেৎদ নস্ট বিবেক হেৎদ রগড়, ঝগড়, হুই রেগে তাহিনা, এন্খান বুদ্ধি নাস য়া হেৎদ সার্তি হাতেত ঝাড়া কানায়, অকয় বুজ ঞাম তাত আয় ভুক্তি দ আয় রাঃআ হরা তানা। ");
INSERT INTO cdz_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","ইনাতে খুশি ল অ ভুক্তিতে গাদা বেশী লাভ হরা, ");
INSERT INTO cdz_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","চিয়াঃচি নিয়া সংসারে আবু যাহানা আ আগু তাত আ বু, চি যাহানা আ নিয়া সংসার হাতাত ইদিয়াবু (ইয়োব 1:21; গিত সংহিতা 49:17) ");
INSERT INTO cdz_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","মেন্খান জমা নুয়া, অয়র ভাগয়া ঞাম লেখান গে ইনা তা খান খুসিলে তাহিনা। ");
INSERT INTO cdz_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","মেন্খান অকয় কিসাড় রাঃআ বাসনায়, উন্কুদ বিডাও রে ফাঁসিয়ারে হেৎদ নানাহুনার বার্থ হেৎদ হানিকর লাল্চ্ রে ঢুঁবুুজ জঃআয়, ইনি যত মান্মিকুকে ছিতরা হেৎদ বিনাশ রে ডুঁবুজ কুয়ায়্য় য় (হিতপদেশ 23:4) ");
INSERT INTO cdz_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","চিয়াঃচি ধনদাড়ী যত খারাপ রাঃআ মিয়াৎ পাটা;ইনাকুতে মাতা য়াকান তেকু কথক হড় কু দ পাতিয়া হাতেত সরা গিডিয় আ কানা কু, হেৎদ গাদা কস্টএম ইচ জানুম তে আকু একুতেগে ফকা আ তানা কু। ");
INSERT INTO cdz_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","মেন্খান আম এ ঈশ্বর রাঃআ হড়, নিয়াকু হাতেত নিরকে;ধার্মিকতে, ব্যক্তিতে, পাতিয়াতে, দুলাড়তে, সাহায়তে, নম্ব্র ভাবতে নিয়া কুরাঃআ অনুধাব্নেম। ");
INSERT INTO cdz_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","পটিয়াতে বেস্গটা লাড়াই রে জীউ স্ম্র্পনেম;জায়জুগ জীউ সাপ ধহম;ইনি রাঃআ নাতিনাঙ আমকে জুমা হ্যুয়া কানা, হেৎদ গাদা সক্ষি রাঃআ সামাংরে ইনা বেশ এক্ড়াড় মানাবাতা তাত আম। ");
INSERT INTO cdz_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","জ্ত্চ রাঃআ জীউ এম্গিচ ঈশ্বর রাঃআ সামাংরে, হেৎদ অকয় পন্তীয় পিলাতরাঃআ হান্ডে ইনা উত্ত্ম এক্ড়ার রাঃআ সাক্ক এম লাতআয়, ইনি যীশু খ্রিস্ট রাঃআ সামাংরে, ");
INSERT INTO cdz_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ইঞ আমকে নিয়া জাগারামাঞ তানা, আম ধরমবিধি নিষ্কলঙ্ক হেৎদ আলম দুর্নাম তুকাঃআ যত মাহা পর্যন্ত প্রভু যীশু খ্রিস্টরাঃআ রুয়াড় মাহা কা সেটেরঃ আ, ");
INSERT INTO cdz_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","অকা ইনা পরমধন্য হেৎদ মিত সম্রাট, রাজত্বকারী কুরাঃআ রাপাজ হেৎদ প্রভুত্বকরি কুরাঃআ প্রভু, লাক্তি সময়রে সদরঅঃ আয় (গিতসংহিতা 47:2) ");
INSERT INTO cdz_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","অকয় দ অমরতাহীন রাঃআ আয়াগেধিকার, আগ্ ম্ম মার্শালনিবাসী, অকয় কে জাহাহুলাঙ মান্মি রাঃআ তালারে কাকু ঞেলঞাম তিয়া, ঞেলহঅ কাকু ঞেলঞামিয়া, ইনি রাঃআ গে সমাদর হেৎদ যুগযুগ অব্দি আইদারি হয়ুকা আ। আমেন (1 তিমথিয় 1:17) ");
INSERT INTO cdz_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","অকয় দ নিয়া যুগ রেনকু কিসাড় হড়, উঙ্কূ কে নিয়া হুকুম এমাকুম, যেন উঙ্কূ গরব ম্নেয়ান হড় আলকু হযু কা আ, হেৎদ সম্পদ আর্ঝারাঃআ নাতিনাং দ ল্হয়, মেন্খান অকয় কিসাড়িচ লেকা যতচ া গে আবুয়া আ জম নু নাতিনাঞ যোগাড়েয়ায়, ইনি ঈশ্বর রাঃআ চেতান রে আস দহ্যায়; যেন এটাঃ হড় কুরাঃআ উপ্কার কা আ (গিতসংহিতা 62:1০) ");
INSERT INTO cdz_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","অটঅ সতকমিতে কিসাড়ম, দানবান হযুম, হেলমেল তাহিনাতিনাঙ মনস্থিরেম; ");
INSERT INTO cdz_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","নিয়ালেকাতে উঙ্কু উন্কুয়া নাতিনাঙ হাপেন মাহা রাঃআ নাতিনাঞ বুগিন ভিত্তিপাটা লেকা আরিচালি বানায় কা আয়, যেন, অকা জিয়ন জীউ, ইনা সাপ ধহ দাড়ি কায়ায়। ");
INSERT INTO cdz_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","এ থিমতি, আমাঃ আ হান্ডেঅকা কু গ্ছিয়া মেনা আ, ইনা কুদ হুসিয়ারতে দহম;অকা কু অযথা বিদ্যা ঞুতুুমতে মেনা আ, ইনা রাঃআ দরম বিরুধ নিঃসার আউহাসাডী হেৎদ বিরধিতা হ্স্তেত সাঁঙ্গীঞ রে তাহিনমে; ");
INSERT INTO cdz_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ইনা বিদ্যা হাড়ুপ ধহ কাতে অকয় অকয় কুদ পাতিয়া হাতেত নজর ভ্রস্ট হ্যুয়া কানা কু। ইশ্বররাঃআ দায়াদুলাড় অপেকুল তাহীন কা আ।");
INSERT INTO cdz_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","পল, খ্রীষ্ট যীশুরা জিউ এমাবুয়া একরাড় লেকাতে ঈস্বররা মর্জিতে নাতিরাং ইনা দ খ্রীষ্ট যীশুরা কুলিয়জ, ");
INSERT INTO cdz_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ইঞআ আলাৎ হন তিমথীয়রা হান্ডে আপু ঈশ্বর হেৎদ আবুয়া প্রভু খ্রীষ্ট যীশু হাতেন মায়া, দায়া অটঃ সুলুক এমাবুকায়। ");
INSERT INTO cdz_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ঈশ্বর, অকয়রাঃহমরবিন্তি ইঞ আপুইঞ-বুঢাইঞতুকুয়া/হাপড়াম কুয়া হাতেন সাপা/ফার্চা মনেতে/বিবেকতে সেবা-দেবা করাঃআউতাইঞ, আয়কে সারহা এমাইতানাই যে, ইঞআ বিন্তিরে/কয় জং সারাঘাড়ি/সিঙ্গি নিদা আমকে পাহাম তানামাই। ");
INSERT INTO cdz_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","আমা মেত্দাআ পাহাম কাতেন সিঙ্গি নিদা আমকে নেল/নেপেল নাতিরাং চিকাচাতানাই, যাতে খুসিতে পেরেজ তাহীনকাইঞ । ");
INSERT INTO cdz_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","আমা অন্তর ভিতাররা খাঁটি পাতিয়াও থুতি পাহাম কিঞায়, যাহাদ মাড়াং আমা বুঢিমতামা লোয়ী অটঃ আমা এন্গাম উনিকি অন্তররে বাসা তাহিনেনা, হেৎদ ইঞআ গটা মনে হুয়ুআ, আমা অন্তরেহঃ বাসা তানায়/মেনা। ");
INSERT INTO cdz_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","নিয়া নাতিরাং আমকে পাহাম তকা তানামাই, ইঞ তিহি বাড়া কাতেন ঈশ্বররা যে দায়াদুলাড় দান আমা হান্ডে মেনাআ ইনা উস্কুর-জুল দহম। ");
INSERT INTO cdz_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","চিয়াঃচি ঈশ্বর আবুকে বর-রাঃআ আত্মাদ কা এম তায়াআবুয়ায়, মেন্খান্দ দাড়ি, দুলাড় তে অটঃ বুঝা/আটকার (সু বুদ্ধি-হাতাং) দাড়িরাঃআত্মা এমতাআবুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","এন্খান্দ আবুয়া প্রভুরা লুকুন্দ মেনতে অটঃ আনিরা ইঞ কায়দী তানাই, ইঞআ বাব্ত্তে তে আম আলোম গিউগ আ, মেন্খান্দ ঈশ্বর রা দাড়িতে বুগিন সংবাদ লো/সাথ্তে কষ্ট/লেন্দকেৎ সাহায় পে। ");
INSERT INTO cdz_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ইনিগে আবুকে বান্চাতাআবুয়ায়, অটঃ রিলামাল আড়াংতে রাঃআতানাবুয়ায়, আবুয়া কামী লেকাতে এঙ্কাদঃ লহয়, মেন্খান্দ আয় পাহাম কাতেন অটঃ দায়াদুলাড়লেকাতে যুগ যুগ মাড়াং হাতেন খ্রীষ্ট যীশু আবুকে এমহুয়াকানায়। ");
INSERT INTO cdz_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","হেৎদ নাহা আবুয়া উদ্ধারকর্তা/বান্চাওইজ খ্রীষ্ট যীশু দ্বারায়তে উদু সদরে নায়, যাহায়দ গয়ঃকে নানদান/নষ্ট কিয়ায়, হেৎদ বুগিন সংবাদ দ্বারায়তে জিউ আর বিন/কা গয়ঃজ মার্শালতে আগুতান কেকুয়ায়্য় য় ");
INSERT INTO cdz_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","ইনা বুগিন সংবাদ রিনিজ ইঞ পাসনা ক/গামিইজ, কুলিইজ অট গুরু/শিখাওনি মেনতে দহ/ঠারাও তিঞাকু। ");
INSERT INTO cdz_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ইনা নাতিরাং ইনতি দুখ সাহা কিঞ তুভুইরঅ কাইঞ গিউ তানাই, চিয়াঃচি অকয়কে পাতিয়া তিইঞ, ইনিকে/আনিকে সারিঞ, হেৎদ কুঠিন্গে কেটেজ পাতিয়া তানাইঞ, ইঞ আনিরা হান্ডে জাহানা গুছিয়া/জগা কাতেন দহলাইঞ, ইনি ইনা মাহা নাতিরাং ইনা বাঁনচা দাড়িকায়। ");
INSERT INTO cdz_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","আম ইঞা হান্ডে যাহানাগে আয়ুম্তাম, ইনা বেশ বুগি চেচেদ কুয়া আদর্শ/শিখানাও খ্রীষ্ট যীশুরে পাতীয়াউ অট দুলাড়তে সাব দহয়্পে। ");
INSERT INTO cdz_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","আমা হান্ডে অকা বুগিন ধন দৌলত গুছিয়াদহমেনা, ইনা আবুয়া অন্তররে বাসা তাহীনকা, ইনা রিলামাল /রিলামালা আত্মা যতন দহ কুম। ");
INSERT INTO cdz_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","আম সারিয়াম, এশিয়ারে যাহায় মেনা কুয়া, ইঙ্কূ যতচ ইনঞা হান্ডে হাতেন অচ গিডিয়া কানাকু ইঙ্কূয়া ভিতার হাতে ফুগিল্ল অট হর্ম্মগিনি মেনাকিনা। ");
INSERT INTO cdz_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","প্রভু অনিশিফোররা ইফিশিয় শেহার হতেন হিচ াকানায় অড়া হড়কুকে দায়া এম্কেৎ কুয়ায়্য় য়, চিয়াঃচি ইনি বার বার ইনঞা জিউ রাড়েজ কিইয়ায়্য়, হেৎদ ইঞা ঝিন্ঝিরি নাতিরাং কাইঞ গিউ লেনাইঞ । ");
INSERT INTO cdz_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","বরংচ আয় রোমরে শেহার সেটের কাতেন বেশগটা ার খোজ হাতা কাতেন ইনঞলো নাপামেনায়। ");
INSERT INTO cdz_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","প্রভু আনিকে নিয়া বর এমিকায়, যাতে ইনা মাহা আয় প্রভুরা হান্ডে হাতেন দায়া নামেকায়, অট এফিষ শেহার রে ইনি চিনতি সেবা কামী করাতকালায়, ইনাকু আমা বেশগটা ার সারি মেনা। ");
INSERT INTO cdz_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","এন্খান, এ ইঞা হন, খ্রীস্ট যীশু রাঃআ দায়াতে কেটেজ তাহিনম। ");
INSERT INTO cdz_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","হেৎদ গাদা লুকুন্দী রা/গোহা রা মচা হাতেন অকা যত জাগার ইঞা হান্ডে হাতেন আয়ুমতাম, ইনা যত এন্খান পাতিয়াও হড়কুয়া হান্ডে সমপাওম, যাহায় অট এটা হড়কুকেহও চেদ দাড়ি কুকাকু ");
INSERT INTO cdz_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","আম ক্রিস্ট জিসুরা বুগিন লাড়হাই হড় লেকা ইঞলো দুখ/কসত হাটিংঅম। ");
INSERT INTO cdz_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","অকয় লাড়াযইচ লাড়হাই বেলারে আচ নিজকে সাংসরিক জিউরে কায় তল তুকায়, অকয় হড় ইনিকে লাড়াইচ মেন্তে বহাল তিয়ায়্য়, যাতে ইনিকে খুশি তুকা দাড়িয়ায় কআয়। ");
INSERT INTO cdz_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","অট যাহায় লাড়হাইয়ান/পালুয়ান যদি জাহান হেপাবাডি রে দাও হাতায়ায়্য় হেৎদ ইনি যদি হেপাবাডি রাঃআ রীতি কায় মানাবাতায়ায়, হাপড়াওয়ান খানয়, এন্খান ইনি দ মৌন বাহাজ কায় নাম দাড়িয়ায়্য়। ");
INSERT INTO cdz_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","যাহায় চাষী খাটায়, ইনিগে মাড়াং জ-রা, হাকদার হুই আয়। ");
INSERT INTO cdz_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","ইঞ মাড়াংতে জাহানা গামিং, ইনা বিবেচনায়/সুজ-বুজ পে, চিয়াঃচি প্রভু যত বাব্ত্তে আমকে বুদ্ধি এমামেয়াঞ। ");
INSERT INTO cdz_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","যীশু খ্রীষ্টকে পাহামমিম, ইনঞা বুগিন সংবাদ লেকতে ইনি গয়হড় কুয়া তালামাগা হাতেন জিউত বিরদা কানায়, দায়ুদরা কূল। ");
INSERT INTO cdz_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ইনা বুগিন সংবাদ মেন্খাতে ইনঞ বাড়িজ কামী হড়কু লেকা সিকরি তল ধাবিজ, কষ্ট/সাতাও সাহা হুয়াকানা, মেন্খান্দ ঈশ্বররা জাগার তল আটকা কা তাহিনাকানা। ");
INSERT INTO cdz_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","নিয়া খাতিরাং ইনঞ বাছাওয়ানকুয়া নাতিরাং যতচ া গে সাহায় তানাই, যাতে আনকু/ইঙ্কূ ক্রিস্ট জিসুরে মেনা উদ্ধার/বান্চাও যায় যুগ ধাবিজ নামোয়া। ");
INSERT INTO cdz_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","নিয়া জাগার সার্তিগে:চিয়াঃচি আবু যদি আয়লো গয়চ:আবু, আয়লোগে জীউৎ াবু। ");
INSERT INTO cdz_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","এন্খান্দ যদি সাহা দাড়িয়াবু, আয়লো রাজ দাড়িয়াবু, এন্খান্দ আয়কে কাবু মানায়া, আয়হ আবুকে কা মানা বুয়ায়। ");
INSERT INTO cdz_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","যদি আবু কাবু/বিন/বে পাতিয়াও, আয় বিশস্ত তাহিনায়, চিয়াঃচি আনি আয়কে কা মানা দাড়িআয় (1 থিসলনিকিয় 5:24) ");
INSERT INTO cdz_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","নিয়া যত জাগার পাহাম তকাইম, প্রাভুরা সামাংরে কেটেজ দিশা/মানা তকাকুম (প্রমান ভজাম/এমএম), যাতে মানমিকু আলকু নিয়া-গপয়জ কাআকু, চিয়াঃচি আয়ুম নামেয়ায় ইনারে যাহানা ফায়দা বায়ায় না, ইঙ্কূগে নষ্ট/দরবস চাবাকু। ");
INSERT INTO cdz_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","আমকে ঈশ্বররা সামাংরে পাতীয়া-কেটেজ হড় মেতেন উদু সদরম, ইনকা কামীয়ান হুয়ুম, যাহায়রা গিউ নামরা জরুর বায়ায় না, যাহায় সার্তি জাগার গটা ঠাক ব্যবহার সারিয়ায় (চেদাকো/চেদাকুম হুইয় মে)। ");
INSERT INTO cdz_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","এন্খানদ ধর্মবিরুধ বেকার বকবককুয়া হান্ডে হাতেন এটারে তাহীন মে, চিয়াঃচি এনকান মান্মিগে ভক্তিলঙ্ঘনরে মারাংরেগে তাহিনাকু। ");
INSERT INTO cdz_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","হেৎদ ইঙ্কূ য়া চেচেদ/জাগার হাতেন নিরাকানাকিন পুটুর-চেগেড় ঘা লেকা সয়া-লেয়া/পাসরা চাআ। ইঙ্কূ য়া ভীতির হাতেন হুমিনায় হেৎদ ফিলিত হঅ মেনা কিনা। ");
INSERT INTO cdz_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","ইনকিন সার্তি মেনতে লক্ষ্য (ভেটকা/ভিংড়া/ছিটকা সাংগিন না কানাকিন) আত তাআকিন, গামেতানাকু গজ হাতেন জিউত বিরিৎ হুয়াকানা, হেৎদ আকয় অকয়রা পাতীয়াও উল্টাচায় তানাকিন। ");
INSERT INTO cdz_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","এন্খান্দ ঈশ্বর কেটেজ-সেটেজ ভিত-পাটা গটা বাইসাদহতায়, ইনারা/এন্ডে নিয়া জাগার অল রেনঢেত/রেহেত দহ হুয়াকানা, প্রভু সারিয়ায় অকয়কু আয়াইজ (প্রভুরা অকয় কু আয়া সারিয়ায়) হেৎদ যাহায় আনি প্রভুরা নুতুমেয়ায়, ইনি অধার্মি (তেনথা/খাচরাহা) হান্ডে হাতেন সাগিনরে তাহীনকায় (ন্হুম ১:7) ");
INSERT INTO cdz_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","মেন্খান্দ, মিয়াৎ মাপড়াং অড়ারে তাহীনঅ একেন সোনা অট রুপারা ভাজান দ লহয়, কাঠরা অট হাসা রা ভাজান তাহিনয়া, ইনিরা চিনতিলেকা বুগিন নাতিরাং, চিনতিলেকা বাড়িজ/খারাপ ভাজান মাহা াদ মাহা রা তাহিনয়া। ");
INSERT INTO cdz_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","মেন্খান যাহায় আপান র তে/আয়তেত নিয়া যত (এটকান জিনিস) হাতেন শাপাগে তাহীন/শাপা দঃহ ইয়ায়, ইনি দ গটা /আসল সময় বেবহার নাতিরাং ভাজান এ হুইয়আয়। এন্তে ইনি দ রিলামাল / রীলামালা আয়, মালিক রা কামীরা উপযোগী/লেকতানা, যত বুগিন কামী নাতিরাং তায়ার হুয়াকানা। ");
INSERT INTO cdz_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","মেন্খান্দ আম ডাঙগুয়ারে লালসা/হায়া/আনগাও হাতেন নিরজমম/এড়ান সেনম, হেৎদ যাহায় সাপা মনতে প্রভুকে রাঃআইয়াআ, ইঙ্কূ লো ধার্মিক, পাতিয়াও, দুলাড় অট সুলুক হরাতে তাড়মে পে। ");
INSERT INTO cdz_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","মেন্খান্দ মুর্খ, তর্ক রেদ যাহানা হঅ বায়ায় না, আম সারি আম, নিয়া যত দাল-গপয়জ জানাম আয়। ");
INSERT INTO cdz_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","অট প্রভুরা দাস কুরা দাল-গপয়জ দ লোহয় তানা, মেন্খান্দ যতচ রা হান্ডে লেবেজ, শিক্ষা এমরে যতন, সাহা দাড়িকায়। ");
INSERT INTO cdz_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","হেৎদ লেবেজ লেকাতে, বিরূধকুকে শাসনকরাঃআনিরাদায়, হুয় দাড়িয়া ঈশ্বর আন্কুকে মন-পাল্টা দাড়িকুকায় (ইঙ্কূ হঅ সার্তিকু সারিনামেককু)। ");
INSERT INTO cdz_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","যাতে আঙ্কু সার্তিরা বুটা-পাটা নাম দাড়িকাকু, হেৎদ আয়াইচ্ছা পুরা নাতিরাং প্রভুরা দাস দ্বারায়তে শয়তানরা ফাসিয়া হাতেন বান্চা নাতিরাং চেদ নামেকায়। ");
INSERT INTO cdz_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","মেন্খান্দ নিয়া সারি দহম, মুচাৎ বেড়ারে কুঠিন কষ্টরা মাহা হিচু য়া। ");
INSERT INTO cdz_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","চিয়াঃচি মান্মিহড় আকু আকুগে কুশিয়াকু, টাকা-পয়সারা লালচি, গর্ব, অহংকার, ঈশ্বরনিন্দা, এঙ্গা-আপুরা বেঃরাহী, অকৃতজ্ঞ, অসৎ। ");
INSERT INTO cdz_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","দুলাড়আকান, ছামা/ক্ষমাহীন, হড়রা চুগলী জাগার, কা সামভাড়াদাড়িকু, কুঠিন রাগ, বুগিনাআ কা কুশিয়ায়, ");
INSERT INTO cdz_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","বিশ্বাসঘাতক, সাহসী, অহংকারী, ঈশ্বরকেৎ লহয় বরংচ আনন্দ-ফুর্তিরে ডুবুইজ তাহিনাকু। ");
INSERT INTO cdz_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","মান্মিকু ভক্তিরা বাখ্লাআ তুসিং কাতেন মেনাকুয়া, মেন্খান্দ আনিরা দাড়িতেয়া কাকু মানায়া, আম এনকান হড়কুয়া কাতা হাতেন সরা তাহীনমে। ");
INSERT INTO cdz_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","ইঙ্কূয়া তালামাগাহাতেন এনকান হড় মেনাকুয়া, যাহায়দ চাল-ছল কাতেন অড়া অড়ারে বল কাতেন কাই হামবাল হেৎদ নাআহানা লালিচতে সেসেনতানাকু নিজুরি বাহুকুড়িহনকু চেদ দাড়িকাকু। ");
INSERT INTO cdz_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","মেনখান্দ এনকান বাহুকুড়িহনকু সার্তিরা তত্ত্বজ্ঞান পাঁজা ঠেকা কাকু দাড়িয়া, ");
INSERT INTO cdz_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","হেৎদ যান্নি হেৎদ জাম্ব্রী চিলকা মোশিরা বিরুধ লায়, এঙ্কাগে ইঙ্কূ চেচেদকু সার্তিরা বিরুধ তানায়কু, নিকু হড়কু বিবেকহীন, অকয়কুরা বুদ্ধি ভ্রষ্টয়াকানা (প্রেরিত 13:8) ");
INSERT INTO cdz_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","মেন্খান্দ ইঙ্কূ হেৎদ মাড়াং দর কাকু সেন দাড়িয়া, চিয়াঃচি এঙ্কাগে আন্কুয়াহতন হুইনেনা, এঙ্কাগে ইঙ্কূ য়া লেলাহা যতচ রা হান্ডে উদু সদররে নায়। ");
INSERT INTO cdz_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","মেন্খান আম ইনআ শিক্ষা, চাল-চলন, চিন্তা, পাতিয়াও, সাহা-দাড়ি, দুলাড়, ধীর, নাআহানা তাড়না, হেৎদ দুখ সাহায় তানাই। ");
INSERT INTO cdz_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","নানান হানার তাড়না হেৎদ দুঃখ সাহা আগু তৎআয়, আন্তিয়াখিয় শেহার রে, ইকনিয় শেহার রে, লুস্ত্রারে শেহার রে ইন্আ সামাংরে অকা অকা ঘটাকানা, চিনতি তাড়না সাহা তাইঞ, হেৎদ ইনা যত হাতেন প্রভু ইনকে বানচা দহ তিয়ায় (গিত সংহিতা 34:19) ");
INSERT INTO cdz_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","অট জাগুটি হড় ভক্তি কাতেন যীশুরে সেসেন দাড়িরা ইচ্ছা হুয়ুয়া, ইনাকুতেগে তাড়না হুয়ুয়া। ");
INSERT INTO cdz_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","মেন্খান্দ বদমাশ হেৎদ গাদা চাল-থুতি হড়কু, এটাকে ঠেকা কাতেন হেৎদ আকুহ ঠেকা কাতে/তুলুই খারাপ হরাতে মাড়াং দর সেনঃ ইদিতানাকু। ");
INSERT INTO cdz_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","মেন্খান্দ আম অকাআ কু চেদা কানাম হেৎদ ইনাকু আম সারি দহম ইনাকুতেগে পাতীয়াও তাহীনমে, আমা সারি মেনা অকয়রা হান্ডে হাতেন চেদাকানাম। ");
INSERT INTO cdz_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","হেৎদ সারিমে, আম হুডিঙ ধাবিজ রীলামালা-শাস্ত্র যত সারি মেনা, ইনা যত ক্রিস্ট যীশু মেনতে পাতীয়াও কাতেন আমকে উদ্ধার খাতিরাং বুদ্ধি এমদাড়িমায়। ");
INSERT INTO cdz_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","যত শাস্ত্র চিকি দ ঈশ্বর হাতেন নিশ্বাস উডুং য়া কানা, অট চেদ নাতিরাং, ভুল সাআ-উদু, সুধড়ানাতিন, ধার্মিক লেকাতে শাসন নাতিরাং ডেঙ্গা/তেলা। ");
INSERT INTO cdz_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","যাতে ঈশ্বররা হড় কেটেজ সেটেজ তাহীনকাকু, যত বুগিন কামী নাতিরাং (সাজা) সাপড়া তাহীন কাকু। ");
INSERT INTO cdz_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","ইঞ ঈশ্বররা সামাংরে, হেৎদ ইনি জিউত হেৎদ গয়কুকে বিচার কুয়ায়্য় য়, ইনি ক্রিস্ট যীশুরা সামাংরে, আয় উদু সদররে নায়, হেৎদ মুলুক নুতুমকাতে আমকে নিয়া কামিরা ভারাম তানাই হুকুম এম তানামাই। ");
INSERT INTO cdz_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","আম সংবাদ পাসনায় মে , সময়রে অসময়রে কামীরে লাগা তাহিনম, কুঠিন সাহা-দাড়ি কাতেন হেৎদ চেত নাতিরাং তাড়না নামেআম, এগেরকুম, চেত নামেকাকু বুঝাকুম। ");
INSERT INTO cdz_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","চিয়াঃচি এনকান সময় হিচু য়া, অকা সময় মান্মি বুগিন শিখা/শিক্ষা কাকু সাহা দাড়িয়া মেন্খান্দ লুতুর বাকতা মেনতে আকু আকুগে লালিচ লেকাতে আকুয়াআ নাতিরাং গাদা গাদা গুরু হাটিং কুয়াকু। ");
INSERT INTO cdz_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","হেৎদ সার্তি হাতেন লুতুর লুয়াড় ইদিকাতে, গাম-কাহিনী দর এটা হরাতে সেনআয়। ");
INSERT INTO cdz_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","মেন্খান্দ আম যত রেগে হুঁশিয়ার তাহিনম, দুখ সাহা দাড়িম, বুগিন সংবাদ গামরাঃআ কামীম, আমা সেবাকামী পুরা চাবাম। ");
INSERT INTO cdz_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","চিয়াঃচি, নাহা ইঞকে দাড়ি সামাং লেকা দুলিং তানাকু হেৎদ ইনআ গজ রাঃআ ঠাঁও সেটের হিচ া কানা। ");
INSERT INTO cdz_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","ইঞ ক্রিস্ট লিয়া জিউ এম কাতে লাড়হাই আকানাই, মুকাম ধাবিজ নিরতাইঞ পাতিয়াও রুখিয়া দহতাইঞ। ");
INSERT INTO cdz_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","নাহা হাতেৎ ইনআ নাতিরাং ধার্মিকরা বাহাজ রাকাব দহয়াকানা, প্রভু ইনি ধার্মিক ধরবারি, ইনা হুলাং ইঞ কে এমিয়াঞ, একেন ইঞ কে লহয়, বছম জান্তি হড় আয়া উদু-সদর কুশিয়াকু, ইঙ্কূ জতয়কেহঅ এম্কুয়ায়্য় য়। ");
INSERT INTO cdz_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","আম ঘিড়ঘিড় ইঞ আ হান্ডে হিচু নাতিনাং তেয়ার তাহিনম। ");
INSERT INTO cdz_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","চিয়াঃচি দিমা নিয়া পিরথিরা দুলাড়রে নুর কাতেন ইঞ কে বাগি গিডি তিয়াং, হেৎদ থিসলনিকিরে সরগ নাগারতে সেনাকানায়, ক্রিসেন্দ গালাতিয়াতে টলা, তিত দাল্মাতিয়ারতে টলা সেনাকানায় ");
INSERT INTO cdz_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","একলা লুক একেন ইঞ ল মেনাই আ, আম মার্ককে সাথরে দহ কাতেন হিচু বেন, চিয়াঃচি ইনি সেবা কামিরে ইঞ কে ঢের-গাদা ডেঙ্গা এম্দাড়িআয়। ");
INSERT INTO cdz_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","হেৎদ তুখিককে ইঞ ইফিস শেহার রে কুল্তিং। ");
INSERT INTO cdz_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ত্রয়ারে শেহার কার্পরা হান্ডে অকা চাদর বাগি তকালাইঞ, আম হিচু বেড়া ইনা হেৎদ বারিয়ালেকা বই কুহ, বিশেষ কাতেন হার্তারা চিনতিলেকা বই, আমলোঃ আগুধরাম। ");
INSERT INTO cdz_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","আলেক্সান্দার সেকরা/তাম্রকার ইঞ আ গাদা খারাপ করাতকাতায়, প্রভু আয়া কামিরা ফল এমিয়ায় (হালাও ইয়ায় (গিত সংহিতা 28:4; রোমীয় 12:19) ");
INSERT INTO cdz_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","আমহ ইনি হড়রা হাতেন সতর্ক/হুশিয়ার তাহিনম, চিয়াঃচি ইনি আবুয়া জাগাররা গাদা বিরুধ লাআয়। ");
INSERT INTO cdz_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","ইঞ আ মাড়াং ইঞ আ হানতে গাম নাতিরাং অকয়হঃ গাম কাকু ডেঙ্গালিয়ায়, জতয়্গে ইঞ কে বাগি গিডি কিঞাকু, নিয়া আকুয়াআ চেতাংরে দোষ আল নুরুকা (গিত সংহিতা 22:21; দানিয়েল 6:21) ");
INSERT INTO cdz_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","মেন্খান্দ প্রভু ইঞ আ কাতারে তিঃগুইনায়, হেৎদ ইঞ কে দাড়ি কেটেজ কিয়ায়, যাতে ইঞ দ্বারায়তে পাসনা কামী পুরা চাবাকা, হেৎদ বিন যিহুদিরিংকু যত মানমি ইনা আয়ুম কেৎয়াকু হেৎদ ইঞ কুলরা মচা হাতেন বান্চায় নাই। ");
INSERT INTO cdz_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","প্রভু ইঞ কে যত খারাপ কামী হাতেন রক্ষা ইঞ আয়, হেৎদ আয়া সেরমা মুলুক তে ইদি সেটের কিয়ায়, ইনিরাগে মহিমা যুগ যুগ ধাবিজ হুয়ুকা। ");
INSERT INTO cdz_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","প্রিসকা হেৎদ ইনিরাঅ হাড়ামতেদ আক্কিলাকে হেৎদ অনিশিফররা অড়াহড়কুকে ইঞ আ জোহার এমাকুম। ");
INSERT INTO cdz_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ইরাস্ত করিন্থ সরগ নাগাররে তাহিথাড়াকানায়, হেৎদ এফিম শেহার রুয়া-হাসু খাতিরাং ইঞ আনিকে মিলিতিরে দহ তকাতিং। ");
INSERT INTO cdz_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","আম রাবাং নুর মারাংতে হিচু নাতিরাং তেয়ার তাহীনমে, উবুল, পুদেন্ত, লিন, ক্লদিয়া হেৎদ যত হাগামিশিতুকু যত পাতিয়ানকু আমকে জোহার তানামাকু। ");
INSERT INTO cdz_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","প্রভু আমা আত্মা লঃঅ তাহীনকায়, দায়াদুলাড় আপে লঃঅ তাহীনকায়।");
INSERT INTO cdz_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","পল, ঈশ্বর রাঃআ গুপিচ হেৎদ যীশু খ্রীষ্ঠেরাঃআ কুলীচ, ঈস্বর রাঃআ বাচ্ছায়ান হড়কু রাঃআ পাতিয়ানুশারে, হেৎদ ভুক্তিনুযায়ী সত্তে আত্বজ্ঞানুশারে ");
INSERT INTO cdz_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","অকয় সত ইনিদ অমরত্ব জীউ গাবান আশা মেনাঃআ, অকা বেদা জাগার্রে সায়বায়া না ঈশ্বর দ গাদা কাল মাড়াং হাতেত মিত্জাগারলাঃআয় ");
INSERT INTO cdz_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","হেৎদ লাক্তি সময় রে আয়াঃআ জাগার গাম্চাল নাতিনা বাছা কিঃই ঞাআ, আবু ত্রানকর্তা ঈশ্বর বা রাঃআ হুকুম লেকাতে গামউচাড় রাঃআ গুরুভার ইঞাঃআ হান্ডে সম্পা হ্যুয়া কানা ");
INSERT INTO cdz_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","সাদার্ন পাতিয়া রাঃআ সম্বন্ধে ইঞাঃআ আপান র হন লেকা গুনমান তীত। ঈশ্বর বারাঃআ হেৎদ আবুয়াঃআ ত্রাণকর্তা খ্রীষ্ট যীশু রাঃআ হ্তেত সুলুক -নিরহাই জাড়ীকাঃআ ");
INSERT INTO cdz_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","নিয়া নাতিনাঞ আমকে ক্রীতীতে ধহ তুকালাত মাঞ চিয়াঃ চি অকা অকাঃকু কা পুরা কানা, আম ইনাকু পুরাতাম, গটা চিল্কা আমকে বাত্লাত মেয়া, যত ডিহি ডিহি রিঙ্কূ মুরুব্বী কুকে বহাল কুম ");
INSERT INTO cdz_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","অকয় হড় কু অ-মান্তান ল্হয় হেৎদ মিত এরা স্বামী, অকয় রাঃআ হন হপন খাঁটিত্ব 'দষীতে মান্খাটো চি আড়ষা বায়ানা ");
INSERT INTO cdz_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","চিয়াঃচি নিয়াদ জারুর গেয়া, ঈশ্বর রাঃআ অধ্ক্ক, ধনাধ্ক্ক মেন্তে লিয়া দূরনাম মেনা, সেচ্ছাচারী, অতিরাগী, আরখি ক্লাঙ্ ডুবুজ, দাদালিচ, খারাপ হরআ তে আয় রাঃআ লোভ আল তাহীন কা আ। ");
INSERT INTO cdz_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","মেন্খান পাহিখাতিরিচ, সারীদুলৌড়ীচ্ বুগিনা নানামানকু, ধীরচ্, ন্যায়ইচ, সাদু হেৎদ হড়ম কব্জিচ হয়ুকায় ");
INSERT INTO cdz_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","হেৎদ চেত্আকান্লেকা পাতিয়ালেকানাঃআ বাক্ক সাব দহয় কাঃআয়, নিয়া লেকা গে ইনি আদর্শ শিক্ষাতে উপদেশ এম হেৎদ বাদীহড় কুরাঃআ দোষ বাচ্ছা উডুং দাড়ীকঃআ। ");
INSERT INTO cdz_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","কারন, গাদা অধম মান্মি, অসার নিয়ায়মচা হেৎদ নির্বুদ্দী হড় মেনা কুয়া, বিসেস্কেৎ কাতে সুন্নু চুটি গেদ কুরাঃআ তালারে মেনাঃআ কুয়া, উন্কুয়া মচা ক্লুপ চাই, ");
INSERT INTO cdz_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","উঙ্কু দ কুত্সিদ আর্যারাঃআ পুস্কানিতে অচেদাঃ চেত্কাতেত চিন্তঙ তার অড়াঃআ কু উল্টা গিডিয়া। ");
INSERT INTO cdz_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","উন্কুয়া মিত্ হড়, উন্কুয়া নিজ দিসুম রিনিচ ভাবিজাগারিচ্ গাম লাত্ আয় (কিরিইঞ মুনীসকুদ) ক্রীতি দ্বিপ বাসিদ হসসড় হিন্স্র জানোয়ার, কুঠিয়া পীটুক। ");
INSERT INTO cdz_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","নিয়া দ সার্তি সক্কা;ইনা খাতির আম উন্কুকে কাযাগতে, যাহাতে উঙ্কু পাতিয়ারে নিরল কু তাহীন কাঃআ, ");
INSERT INTO cdz_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","জিহুদিয়া কাহিনিরে, হেৎদ সার্তি হাতেত ম্চাগ্ছে মান্মি কু কে হুকুম তে ম্নস্তির আল তাহিন কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","সূচিহড়কুরাঃআ মতে যত হড়সূচি মেন্খান কুলষিতহেৎদ কাপাতিয়ান মতেযাহানাঃআ সূচি ল্হয়, বরঞ্চ উন্কুয়ামন হেৎদ বিবেক বরনাঃআ কুলষিত হ্যুয়া কানা। ");
INSERT INTO cdz_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","উঙ্কু দ মানাঃ কানা চিয়াঃ চি, ঈশ্বরকে কু সারিয়া, মেন্খান কামিরে ইনি কেকু কাকু মানাবাতাইয়া; উঙ্কু দ ঘিন্নাসম্পদ, অবাধ্য় হেৎদ যত সত্কামিরে প্রমান্হীন। ");
INSERT INTO cdz_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","মেন্খান আমঃ আদর্স শিক্ষাতে উপযুক্ত থুতিম। ");
INSERT INTO cdz_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","হাড়াম কু কে গামা কুম, উঙ্কু যেন সিবিলমচা, ধীর, সংযত, পাতিয়াতে, দুলারতে, সাহাত্তে আদর্শবন্ হয়ুকাঃ আ। ");
INSERT INTO cdz_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","ইনালেকা মুরুব্বি কুকে গামাকুম, উঙ্কু যেন আচার বেভার্তে বরতা তাহীন কাঃআ অপ্বামাহা ি/ইশ্বরকে মানাবাতা কি আরখি কলাঙরে, বাগালী আলয় হযু কাঃ আয় সু চেচেদী নি হয়ুকাঃ আয়। ");
INSERT INTO cdz_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","উঙ্কু যেন দাঁগুয়া কুড়ি হন কুকে সংযত৷ কাতেত তাহীন কাঃ আকু, উঙ্কু যেন স্বামীপ্রিয়া, হন্হ্প্ন প্রিয়া, সংযতা, সতি, অড়াঃদুয়ার কমীরাঃআ পটু, ");
INSERT INTO cdz_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ঠাকুরমচা, হেৎদ স্বামি বাগ্তরে তাহিন্কা আ, নিয়ালেকাতে ঈশ্বর কাথা আল অপচর্চাঃ আ কাঃ আ। ");
INSERT INTO cdz_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","এঙ্কাতেগে ডাঁগুয়া কড়া হন কুকে সংযত নাতিনাঙ হুকুম এমাকুম ");
INSERT INTO cdz_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","হেৎদ আম যত বাব্ত্তে রে সত কামিকুরাঃ নিস্টআ তাহীন মে। ");
INSERT INTO cdz_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","চেদতে পুটু, ধীর, হেৎদ ছান (ছল)নিরামি কাথা উডুং ইদিম যেন বাদী হড় আবুয়া বাব্ত্তে তে বাড়িছ গাম রাঃআ হরা কাকু ঞামলে খান গিয়ু গ্যাকু ");
INSERT INTO cdz_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","কিরিঞ বাগালকে গামাকুম, আকু যেন আকুঃ আ নিজ স্বামী রাঃআ বাধ্য়রে হেৎদ যত বাব্ত্তে কু রাঃআ রে খুশি খুসী কা আয়, আলয় প্রতি বাদে কা আয়, ");
INSERT INTO cdz_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","যাহানা কু গে আলয় উকু বাগায় কা আ, মেন্খান যত জিনিষরে উত্ তম পাতিয়া জগ্গ উডু কা আয় যেন উঙ্কু আবু আ ত্রআন নাথ ঈশ্বর বা রাঃআ ছেদা কু যত বেপার্রে সন্মানিত এমেকাঃ আ ");
INSERT INTO cdz_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","চিয়াঃ চি ঈশ্বর রাঃআ দয়া দুলাড় পাসনা কানা অকা দ সারা ভূমি রিঙ্কূ মান্মি পরিত্রান রাঃআ হরা কু ঞামেয়া ");
INSERT INTO cdz_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","অকয় আবুকে উপদেশ এম্তানাবুয়ায় যেন আবু অভুক্তিমনা হেৎদ স্ন্সারিক বিলাসিতা যত আ কাপাতিয়া কাতে স্ন্জ্ত, ধার্মিক হেৎদ ব্যক্তি লেকাতে নিয়া নাহ যুগরে আসুল বান্চা বু, ");
INSERT INTO cdz_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","হেৎদ মন্নধন্য আশসিদ্ধী খ্যাতির, হেৎদ মহান ঈশ্বর হেৎদ আবুয়া ত্রান নাথ যীশু খ্রিস্ট রাঃআ জুলুত্রাস পাসনা নাতিনাঞ তাঙগীযাবু ");
INSERT INTO cdz_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","যীশু খ্রিস্ট আবুয়া নাতিনাঞ আয কেগে এমাত্বুয়া, যেন আচদিয়া যতরকম অধার্ম হাতেদ ছাড়াউডুং বুয়াআয়, হেৎদ আয়াআ লিয়ানীজপ্রজাদলকে, সতকর্ম তেউদ্জ্গী, প্রজাদলকে, সুদ্ধকুয়ায়্য় য় (সেসেন পুস্তক 19:5, দ্বিতীয় বিবরণ 4:20, গিত সংহিতা 72:14, যিহিস্কেল 37:23) ");
INSERT INTO cdz_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","আম নিয়া যত কাথা জাগারেম, হেৎদ সম্পুর্ন মনবলতে জাগার পাস্নাম, হেৎদ অনুযোগেম; আমকে হেও নাতিনাঙ যাহায় কে আলম এমাকুয়া। ");
INSERT INTO cdz_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","আম পাতিয়ান হড়কুকে ইঙ্কূ কে পাহাম তকাকুম, যাতে ইঙ্কূ আধিপত্যরে ও বশরে তাহিন্কাকু, বাধ্য়রে, সত্কর্ম নাতিনা তেয়ার্ম। ");
INSERT INTO cdz_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","যাহা য় রাঃআ আলকু নিন্দায় কা আ নিরবরদ হেৎদ নিরহ ভাবএম, যত হড় রাঃআ হান্ডে সম্পুর্ন রুপতে নম্রতা উদুম। ");
INSERT INTO cdz_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","চিয়াঃচি আদিতে আলেঃহঅ কঙকা, ঠেঠ, ভ্রান্ত, নানান্হুনার বিলাসিতা, সুক্ভোগের দাস, হিন্সাতে হেৎদ মাত্স্জে, কালক্ষেপারি, ঘৃণ্যহেত দ হানিনা আইল নিয়ায়চ ইঞ তাহিলেনা, ");
INSERT INTO cdz_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","মেন্খান চিন্তঙ আবুয়া আ বান্চাইচ ঈশ্বর বা রাঃআ সিবিল স্বভাব হেৎদ মান্মি জ্ঞাতি কে দুলাড়ি উচানেনা, ");
INSERT INTO cdz_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ইন্ত্ন ইনি আবুয়া যত ধর্মকর্ম নাতিনাঙ দ ল্হয় মেন্খান আয়া আ দায়াদুলড়তে পরজন্মরাঃআ (ডিপা) উম অ হেৎদ (রীলামালা)রিলামালা আত্মা রাঃআ নামাকিয় দ্বারাঃআবুকে বান্চা তাৎ বুয়ায় ");
INSERT INTO cdz_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","ইনা আত্মাকে ইনি আবুয়া ত্রানকর্তা যীশু খ্রিস্ট লিয়া আবুয়া চেতানরে গাদালেকা দুল্বুরু তা আয় (যোয়েল 2:28) ");
INSERT INTO cdz_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","যেন আয়া আ দায়াদুলাড়তে ধর্মিক লেখা হই কাতেত অনন্ত জীউ রাঃআ (টঙ্গী) তাঙ্গী তাড়াতে (মেনা আ বুয়া)তাহি কাতেত দায়াধিকার বু হয়ূঃ কাঃআ। ");
INSERT INTO cdz_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","নিয়া কাথা পাতিয়ান গেয়া; হেৎদ ইঞাঃআ বাসনা নিয়া গে, নিয়া যত বাব্ত্তে রে আম তিন্গু কেৎটেজ কাতে থুতিম (অকয় ঈশ্বর কেকু পতিয়া তিয়া কানা) উঙ্কু যেন স্ত্কামিরে বেপৃতকাত (হই রাঃ আ (বাবে) ভাবায় কা আ কু, নিয়া যত বাব্ত্তে মান্মি রাঃআ পক্ষে ভাল হেৎদ বুগিন জ পেরেচ। ");
INSERT INTO cdz_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","মেন্খান আম মুর্খামিরাঃআ যত বিতন্ডা, কুলরাসী, নিয়ায়, হেৎদ মোশিরাঃআ বেবস্থাবাব্ত্তে নিয়ায় গপচ হাতেদ সাঙ্গীঞরে তাহিনমে; চিয়াঃ চি নিয়া যত আ নিচ (জ) হেৎদ অসার। ");
INSERT INTO cdz_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","অকয় মান্মি দলছুট/দলকে ভাগে, হানীকে মিসা বর্সা ভুঝা তায়াম গেত ভেগারিম/হুশিয়ারিম, ");
INSERT INTO cdz_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","সারিম (নেকন) নেকান মান্মি ভির্কা কানায়, হেৎদ ইনিদ কাইরে তাহিনায়, আয়চ আয়চতেগে দোসিয়া ");
INSERT INTO cdz_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","ইঞ চিন্তঙ আমাঃ আ হান্ডে অর্তিমকে বান্খান তুখিককে কুলকিনাঞা, ইন্ত্ন আম নিক্প্লিতে শেহার ইঞা আ (হান্ডে) হিজু নাতিনাঙ সাপড়া আম, চিয়াঃচি ইনা ঢিপারে রবংসময় এন্তেরে তাহিরাঃআ মন গোটা তাথআঞ ");
INSERT INTO cdz_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","বেবস্থাইচ কিন (বাব্ত্তে) সিনাকে হেৎদ আপল্লো কে বেশ বেশতে কুলকিন্মে (যেন) ইঙ্কিন া আ জাহানা আ অভাব আল হয়ুকা আ ");
INSERT INTO cdz_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","হেৎদ আবুয়া হড়কু যত প্রযজ্নিন উপ্কারকা আ স্ত্কামি (তে) রাঃআ বাব্ত্তে অভ্যাসে কাআ কু, যেন নি (য) জ আল হযুকাআ। ");
INSERT INTO cdz_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ইঞাঃআ যত (গতিকু) গাতিকু বুগিন (জহর) জহার ইমাম তানা, অক্য়য়কু পাতিয়া তেত ইঞকেকু খুসিয়াঞা, হান্কু কে হঃঅ বুগিন জহর এমাকুম। আপেয়া যত রাঃআ হান্ডে ইশ্বররাঃআ দায়াদুলাড় জাড়িকাআ।");
ALTER TABLE cdz_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
