﻿USE sofia;
DROP TABLE IF EXISTS sofia.cbv_vpl;
CREATE TABLE cbv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cbv_vpl WRITE;
INSERT INTO cbv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Weém, Mateo, ded pah Jesucristo ã jʉmatjidih wã daácna caá. Jesucristo ã nʉowãji ĩ wʉ̃tnadih wã jwíih naóhbipna caá. Ã nʉoji jon jã́tih bóo David wʉ̃t jʉmni ãt jʉmʉp wʉt jĩ. Caán ã jʉmat pínah jã́tih ã nʉoji Abraham wʉ̃t jʉmnibʉt ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac íip ãt jʉmʉp wʉt jĩ. Isaacboó Jacob íip ãt jʉmʉp wʉt jĩ. Jacobboó Judá ã déewãjĩh ĩ íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judáboó ã weh chénewã ĩt jʉmʉp wʉt jĩ. Fares, Zara ĩt wʉ̃t jʉmʉp wʉt jĩ. Ĩ íin Tamar mit wʉ̃t jʉmʉp wʉt jĩ. Faresboó Esrom íip ãt jʉmʉp wʉt jĩ. Esromboó Aram íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramboó Aminadab íip ãt jʉmʉp wʉt jĩ. Aminadabboó Naasón íip ãt jʉmʉp wʉt jĩ. Naasónboó Salmón íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónboó Booz íip ãt jʉmʉp wʉt jĩ. Ã íin Rahab mit wʉ̃t jʉmʉp wʉt jĩ. Boozboó Obed íip ãt jʉmʉp wʉt jĩ. Ã íin Rut mit wʉ̃t jʉmʉp wʉt jĩ. Obedboó Isaí íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíboó David íip ãt jʉmʉp wʉt jĩ. David wʉt jĩí judíowã ĩ chah maáh ãt jʉmʉp wʉt jĩ. Davidboó Urías wʉ̃t jʉmniji áadih jwʉ́ʉb áa jʉmat tʉ́ttimah, Salomóndih ãt weh jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónboó Roboam íip ãt jʉmʉp wʉt jĩ. Roboamboó Abías íip ãt jʉmʉp wʉt jĩ. Abíasboó Asa íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaboó Josafat íip ãt jʉmʉp wʉt jĩ. Josafatboó Joram íip ãt jʉmʉp wʉt jĩ. Joramboó Uzías íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasboó Jotam íip ãt jʉmʉp wʉt jĩ. Jotamboó Acaz íip ãt jʉmʉp wʉt jĩ. Acazboó Ezequías íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasboó Manasés íip ãt jʉmʉp wʉt jĩ. Manasésboó Amón íip ãt jʉmʉp wʉt jĩ. Amónboó Josías íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasboó Jeconías ã déewãjĩh ĩ íip ãt jʉmʉp wʉt jĩ. Queét jʉm láa Israel baácdih moondíh míic mao yap yohnit, Babilonia baácdih moónboó queétdih ĩ́ih baácna ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonia baácna ĩ jʉibíát tʉ́ttimah, Jeconíasboó Salatieldih ãt weh jʉmʉp wʉt jĩ. Salatielboó Zorobabel íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelboó Abiud íip ãt jʉmʉp wʉt jĩ. Abiudboó Eliaquim íip ãt jʉmʉp wʉt jĩ. Eliaquimboó Azor íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorboó Zadoc íip ãt jʉmʉp wʉt jĩ. Zadocboó Aquim íip ãt jʉmʉp wʉt jĩ. Aquimboó Eliud íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudboó Eleazar íip ãt jʉmʉp wʉt jĩ. Eleazarboó Matán íip ãt jʉmʉp wʉt jĩ. Matánboó Jacob íip ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobboó José íip ãt jʉmʉp wʉt jĩ. Joséboó María áa ãt jʉmʉp wʉt jĩ. Maríaboó Jesús íin mit jʉmʉp wʉt jĩ. Jesúsboó Dios ã wahni Cristo ĩ niijní ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahamjidih jwĩ jenah jwíihichah, pʉ́ʉ́ Davidji jʉm láa jwĩ jenah péanachah, nihat ĩ jʉimenájĩh jʉmna, catorce poómp ĩt jʉmʉp wʉt jĩ. Davidjidih jwĩ jwʉ́ʉb jenah jwíihichah, pʉ́ʉ́ Babilonia baácna judíowãdih ĩ ʉb bej láa jwĩ jenah péanachah, nihat ĩ jʉimenájĩh jʉmna, catorce poómp ĩt jwʉ́ʉb jʉmʉp wʉt jĩ. Babilonia baácna ĩ jʉibí láa jwĩ jwʉ́ʉb jenah jwíihichah, pʉ́ʉ́ Cristo ã cã́ac jʉm láa jwĩ jenah péanachah, nihat ĩ jʉimenájĩh jʉmna, catorce poómp ĩt jwʉ́ʉb jʉmʉp wʉt jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nin pah Jesucristo ãt cã́ac jʉmʉp wʉt jĩ. Ã íin Maríaboó Joséjĩh téihya chéonih pínah mit jʉmʉp wʉt jĩ. Ĩ téihya chéwat pínah jã́tih Tʉ́ini Espíritu ã wẽpatjĩh caántdih ã wʉdhdanachah, mit wʉdʉ jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Páant mi wʉdʉ jʉmʉchah jéihna, Joséboó yoobópdih chãjni jʉmna, cã́acwã ĩ encahjeh, caántdih yohat tʉ́ʉt ãtih chãjap wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pánih jenah joí ʉ̃onit, ã oo jʉ́mʉchah, Dioíh ángelboó caandíh jígohnit, “José, Davidji jʉima, Tʉ́ini Espírituboó ã teo wáacatjĩh María mi wʉdʉ jʉmna caá. Pánihna, tíiccanjeh caántjĩh ma téihya chéweé. ");
INSERT INTO cbv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Caánt newé weépdih mi tʉ́ʉhbipna caá. Caanjéh tigaá ã́ih cã́acwã iiguípna bejnit déejidih tʉ́i ʉbni ã jʉmbipna caá. Páant cã́acwãdih tʉ́i ʉbni pínah ã jʉmʉchah, Jesús ma wʉ̃t bʉ́ʉdhdʉ́p”, ángel Josédih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jon jã́tih Dios naáwátdih naóh yapani nin ã daacátji pahjeh ãt yapap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Jáap wili wébít bid jʉiníh newé weépdih mi tʉ́ʉhbipna caá. Caandíh ‘Emanuel’, ĩ niijbípna caá”, ãt niíj daacáp tajĩ. “Emanuel”, niijná, “Dios jwĩjeéh ã jʉmna caá”, niíj naóhna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dioíh ángel caandíh ã naáwát tʉ́ttimah, ã niiját pahjeh José Maríadih ãt téihya chéwep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Obohjeéhtih, mi weh jʉmat pínah jã́tih, José mijeéh ãt jʉmcap wʉt jĩ. Pánihna, caánt mi weép jʉmat tʉ́ttimah, Joséboó mi wʉ̃ʉ́hdih Jesús ãt wʉ̃t bʉ́ʉdhdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes Judea baácdih moón ĩ maáh jʉm láa, caán baácdih jʉmni Belén tʉ́tchidih Jesús ãt cã́ac jʉmʉp wʉt jĩ. Ã cã́ac jʉmat tʉ́ttimah, cʉ́iwãdih bohénit yeó aáb jʉ̃ʉ́wʉ́pmant moón jʉ̃óhnit, Jerusalén tʉ́tchina ĩt jʉyʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pánih jʉinít, caanjĩ́h moondíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Judíowã ĩ chah maáh pínah dedjĩh tigaá ã cã́ac jʉmat? Yeó aáb jʉ̃ʉ́wʉ́pmant jʉmna, chah iigní cʉ́i ã jáap jígohochah enna, ‘Maáh ã cã́ac jʉmna caá’, jwĩ niíj jéihyep jĩ. Páant ã jígohochah enna, caandíh weñedih jʉ̃óhna caá jwĩ chãjap, cʉ́iwãdih bohénit ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Páant, ĩ ʉʉ́bh joyát doonádih joinít, Herodesboó bʉ́dí ãt jenah joyóp wʉt jĩ. Nihat Jerusalén tʉ́tchidih moonbʉ́t biíc yoobó bʉ́dí ĩt jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pánihna, Herodesboó sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitdihbʉt ãt bid wáacap wʉt jĩ. Páant ĩ míic wáac jʉí beedéchah ennit, queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedboo tígaá Cristo ã cã́ac jʉmat pínahdih Dios naáwátdih naóh yapanit ĩt niíj daác jĩ? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Judea baácboó jʉmni Belén tʉ́tchidih Cristo ã cã́ac jʉmbipna caá. Nin pah Dios naáwátdih naóh yapani ãt niíj daacáp tajĩ: ");
INSERT INTO cbv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judea baácboó jʉmni Belén tʉ́tchimant judíowãdih wʉtni pínah ã jʉ̃óhbipna caá. Caán queétdih tʉ́i en daoní ã jʉmbipna caá. Pánihna, Belénboó ã cã́ac jʉmni pínah tʉ́tchi ã jʉmʉchah, oboh jʉmni tʉ́tchi nihcan caá’, ãt niíj daacáp tajĩ, Herodesdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Páant ĩ niiját tʉ́ttimah, cã́ac wihcah, yeó aáb jʉ̃ʉ́wʉ́pmant moondíh Herodes ãt jwʉ́ʉb bid bojop wʉt jĩ. Ã pebh ĩ jʉibínachah ennit, débólih caán cʉ́i ã jwíih jígohatjidih queétdih ãt ʉʉ́bh joyóp wʉt jĩ. Páant ã ʉʉ́bh joyóchah, caán cʉ́idih ĩ jwíih enatjidih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Páant ĩ naáwát tʉ́ttimah, Belén tʉ́tchina wahna, Herodes queétdih nin pah ãt niijíp wʉt jĩ: —Caandíh ñi tʉ́i bidbi jwʉhʉʉ́. Bid jʉinít, weemdíh naáwádih ñi jwʉ́ʉb jʉ̃ʉ́wʉ́, weembʉ́t caandíh weñedih wã bejat pínah niijná, ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Páant ã niijíchah joinít, queét ĩt bejep wʉt jĩ. Páant ĩ bejechah, yeó aáb jʉ̃ʉ́wʉ́pmant ĩ jwíih enni cʉ́ijeh mʉntih queétdih ãt jwʉ́ʉb waáwáp wʉt jĩ. Pánihna, wébít ã jʉmni mʉʉ cháh pohba caán cʉ́i ãt chãwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Páant ã chãwáchah ennit, bʉ́dí ĩt weñep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pánihna, wébít ã jʉmni mʉʉdíh waád jʉibínit, caandíh beh wili biícdih ĩt enep wʉt jĩ. Pánih ennit, wébítdih wẽina, bódicha ĩt caj yoh ñajap wʉt jĩ. Pánih wẽi péanit, ĩ ʉb jʉ̃óhni paihnadih wãtnit, bʉ́dí jíib jʉmni oro, tʉ́i chej jʉmni cáwat pínah, mirra wʉ̃t jʉmni chej jʉmnidihbʉt caandíh ĩt wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Caandíh wʉ̃h péanit, ʉ̃wʉdih ĩt bejep wʉt jĩ. Pánih ʉ̃onit, ĩ oo jʉ́mʉchah, Dios queétdih nin pah ãt niíj naáwáp wʉt jĩ: “Herodes pebhboó ñi jwʉ́ʉb bejca bojoó”, ãt niijíp wʉt jĩ. Páant ã niijíchah joinítji jáanit, ĩ́ih baácna jwʉ́ʉb bejna, biíh namáboó ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Páant ĩ jwʉ́ʉb bejat tʉ́ttimah, José jwʉh ã jwʉ́ʉb oo jʉ́mʉchah, Dioíh ángel caandíhbʉt nin pah ãt niíj naáwáp wʉt jĩ: “Ma jáa bojoó. Bainídih ĩ mawat pínah niijná, Herodes ã́ih soldadowãdih wahna caá ã chãjap. Pánihna, bainídih, ã íindihbʉt Egipto baácboó waícanjeh ma nʉmah jwei béjeé. Caanná wã niiját pah bóo ñi jʉm jwʉhʉʉ́”, ángel Josédih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Páant ã niijíchah joinít, cheijeh jáanit, Egipto baácna bainídih ã íin biícdih José ãt nʉmah jwei béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Caán Egipto baácna jʉibínit, Herodes ã báadh jwʉhat pah bóo caánboó ĩt jʉm jwʉhʉp wʉt jĩ. Páant Jesús ã yapachah, Dios naáwátdih naóh yapani nin ã daacátji pah ãt yapap wʉt jĩ: “ ‘Egipto baácboó jʉmni wã wʉ̃ʉ́hdih wã bid bojbipna caá’, Dios ã niijíp be”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cʉ́iwãdih bohénit biíh namáboó ĩ jwʉ́ʉb bejat doonádih joinít, Herodesboó bʉ́dí ãt íijip wʉt jĩ. Pánih íijnit, Belén tʉ́tchidih moón neoná weépdih, caán tʉ́tchi jwẽ́ejdih moondíhbʉt ãt mawat tʉ́ʉtʉp wʉt jĩ. Cʉ́iwãdih bohénit débólih caán cʉ́i ã jwíih jígohatjidih ĩ naáwáchah joiníji Herodes ã mawíhniboó chéne jópchi dée ã bíbohatdih ãt jéihyep wʉt jĩ. Pánih jéihna, chéne jópchi nʉmp bíbohnit nihat neoná weépdih ãt mao yohat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Páant ã mawat tʉ́ʉtʉchah, Dios naáwátdih naóh yapani Jeremías ã daacátji pah ãt yapap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá wʉ̃t jʉmni tʉ́tchidih moón bʉ́dí ñaacátdih ĩ joiná caá. Bʉ́dí jĩ́gahnit, ĩ ñaác jʉñát bʉ́dí ã yáana caá. Raquel mi jʉimená yaádh, judíowã ĩ weha mána yaádh, ĩ wehdih ĩ mao yohochah ennit, bʉ́dí ĩ ñaác jʉ̃iná caá. Ĩ weh ĩ wihcatdih enna, ĩ jĩ́gahat ã yaicán niít”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes ã wʉnat tʉ́ttimah, Joséwã Egipto baácboó páantjeh ĩt jʉm jwʉhʉp wʉt jĩ. Pánih jʉmnit, biíc chei José ã oo jʉ́mʉchah, Dioíh ángel caandíh jígohnit, nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wébítdih mawíhnitji maátaboó ĩ wʉn beedáh bejep be. Pánihna, caandíh ã íinjĩh Israel baácboó ma nʉmah jwʉ́ʉb bejeé, páant mʉntih”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Páant ã niiját tʉ́ttimah, jáanit, wébítdih ã íin biícdih Israel baácboó ãt nʉmah jwʉ́ʉb bejep wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Obohjeéhtih, Herodes ã bʉʉdát tʉ́ttimah, ã wʉ̃ʉ́h Arquelaoboó Judea baácdih moondíh ãt jwʉ́ʉb tʉ́ʉt nʉʉ́m maáh waadáp wʉt jĩ. Páant ã jʉmat doonádih joinít, José caanná ã jwʉ́ʉb bejat pínahdih ãt ʉ́ʉm jenah joyóp wʉt jĩ. Pánih ʉ́ʉm jenah joinít, ã jwʉ́ʉb oo jʉ́mʉchah, Dios caandíh Judea baácboó ãt chãwát tʉ́ʉtcap wʉt jĩ. Páant ã chãwát tʉ́ʉtcah joinít, Judea baácdih yap bejnit, pʉ́ʉ́ Galilea baácna ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pánihna, caanná jʉibínitji, Nazaret wʉ̃t jʉmni tʉ́tchiboó ĩt jʉmʉp wʉt jĩ. Caanná ĩ jʉmʉchah, Dios naáwátdih naóh yapanit ĩ daacátji pah Jesús ãt jʉmʉp wʉt jĩ. “ ‘Nazaret tʉ́tchidih bóo caá’, cã́acwã Dios ã wahnidih ĩ niijbípna caá”, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dawá jópchi tʉ́ttimah, Juan Daabáni cã́acwãdih daabána ãt chãjap wʉt jĩ. Judea baácdih mʉʉ́ wihcapboó ã pebhna jʉibínitdih Dios naáwátdih ãt bohé jwíihip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nin pah queétdih ãt niíj naáwáp wʉt jĩ: “¡Ñi yéej chãjatdih cádahnit, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmʉ́! Nihat baácdih moondíh Dios ã maáh jʉmatdih ã jʉ́ʉtat pínah bahnijeh ã jʉdhna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon jã́tih Dios naáwátdih naóh yapani Isaíasboó Juan ã bohéát pínahdih nin pah ãt niíj daacáp tajĩ: “Mʉʉ́ wihcapboó nin pah ã niíj ñaác bohébipna caá: ‘Jwĩ Maáh ã jʉ̃ʉ́wát pínah jã́tih ñi yéej chãjatdih cádahnit, tʉ́iniboodíh tʉ́ʉt nʉʉmnít, caandíh ñi tʉ́i páñaá’, ã niijbípna caá”, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juaníh yégueh chóo camello wʉ̃t jʉmni nʉñʉ́p yoócjĩh nóomnit, ĩ yacni chóo wʉt jĩ. Ã́ih jʉyáát tõp momo jiwi chóo tõp wʉt jĩ. Wʉ̃ʉ́c joowã́dih jeémpnit, belo macdihbʉt ãpĩ́ déebep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén tʉ́tchimant, nihat Judea baácmant, Jordán mʉj jwẽ́ejmantbʉt dawá caandíh joyódih ĩpĩ́ jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pánih jʉibínit, ã bohénachah joinít, ĩ yéej chãjatdih Diosdih ĩpĩ́ naáwáp wʉt jĩ. Páant ĩ naáwáchah joinít, Jordán mʉjboó Juan queétdih ãt daabánap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dawá fariseowã, saduceowãbʉt daabáát tʉ́ʉtʉdih ĩ jʉibínachah ennit, Juan queétdih nin pah ãt jípónih niijíp wʉt jĩ: “¡Maiwã panihnit yeejépwã jʉmna, peéh chãjat pínahdih ʉ́ʉm jweííhnitjeh caá! Obohjeéhtih, yeéb ñi yéej chãjatdih ñi cádahíhcat jíib Dios yeebdíh ã peéh chãjachah, ñi jéih jweicán niít. ");
INSERT INTO cbv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yéej chãjatdih yoobópdih cádahnit, tʉ́iniboodíh chãjat caá yeebdíh náahap. ");
INSERT INTO cbv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nin pah ñi niíj jenah joicá bojoó: ‘Jon jã́tih bóo Abraham jwiít judíowã jwĩ nʉo ãt jʉmʉp wʉt jĩ. Pánihna, ã jʉimená jʉmna, Dioíhwã caá jwĩ jʉmʉp’, ñi niíj jenah joicá bojoó. Yeebdíh nin pah wã niijná caá: Abraham jʉimená ñi jʉmʉchah yʉhna, dedé pínah nihcan caá. Diosboó nin jee dáhnadih tʉ́ʉt nʉʉmnít, Abraham jʉimená pínahdih ã jéih chãjna caá. Abraham jʉimená ñi jʉmat nin oboh jʉmni jee dáhna ã nihat pahjeh tigaá. ");
INSERT INTO cbv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nin pah ã jʉmna caá: Yeéb máa nah panihni ñi jʉmʉchah, Diosboó máa nahdih tib yohni panihni caá ã jʉmʉp. Yeejép dahna quehnidih tib yoh bojnit, ã́ih náatnadihbʉt ã pʉd yohbipna caá. Tib yoh péanit, caan náhdih, ã́ih náatnadihbʉt ã cáo yohbipna caá. Páant ã cáwat pah caandíh jepahcannitdih iiguípna ã wahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wã tʉ́ttimah jʉ̃óhni wã chah wẽpni caá. Páant ã jʉmʉchah jenah joinít, ‘Weém oboh jʉmni caá’, wã niíj jenah joiná caá. Pánihna, ñi yéej chãjatdih cádahnit, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmʉ́chah, yeebdíh wã daabána caá. Páant wã daabáát panihni, caánboó yeebdíh Tʉ́ini Espíritu ã wẽpatdih bʉ́dí ã wʉ̃hbipna caá. Caán ã wẽpat tʉʉ iigát panihnijĩh ñi yéejatdih cáwat pah ã chãjbipna caá, jwʉ́ʉb yéej chãjíhatdih ñi jenah joicát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigo teoni panihni caá. Ã́ih chóonadih caóh caj péanit, caán tíibna yoobátdihjeh wʉh wʉʉ́hboó jʉ́i yacnit, ã́ih mʉʉ́boó ã ámohbipna caá. Obohjeéhtih, ã caóh cajni chóonaboodíh ã cáo yohbipna caá. Páant ã chãjat pah wã tʉ́ttimah jʉ̃óhni caandíh jepahnitdih ã tʉ́i ʉbbipna caá. Obohjeéhtih, caandíh jepahcannitboodíh iiguípna ã wahbipna caá. Caán iigát dedé ã noón dʉbcan niít”, Juan ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tʉ́ttimah, Jesús Galilea baácboó jʉmniji bejnit, Juandih ã daabáát tʉ́ʉtat tʉ́ʉt niijná, Jordán mʉjna ãt dei jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Obohjeéhtih, daabáíhcan, nin pah Juan caandíh ãt niíj jepahap wʉt jĩ: —Meémboó chah wẽpni jʉmna, weémboodíh ma daabána ãta tʉ́i tagaá. Meemdíh daabáni pínah nihcan caá, Juan Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—Páant niijcánjeh, weemdíh ma daabánaá. Pánih daabánit, Dios ã́ihwãdih ã chãjat tʉ́ʉtat pahjeh tigaá jwĩ chãjbip. Páant jwĩ chãjachah ennit, cã́acwãboó Dios ã wahni wã jʉmatdih ĩ jéihbipna caá, Jesús ãt niijíp wʉt jĩ. —Caán láa bácah, ã tʉ́imi nacaá, Juan ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Páant niíj jepahnit, Jesúsdih ãt daabánap wʉt jĩ. Ã daabá péanachah, Jesús mʉjna ñʉhniji ãt aab ñʉ́hʉp wʉt jĩ. Pánih aab ñʉ́hnitjeh, Jesús ã enechah, jeá ãt jéweah bejep wʉt jĩ. Páant ã jéweah bejechah, jop pah jígohni Tʉ́ini Espíritu jeámant dei jʉ̃óhnit, caandíh ãt jʉí jaamáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Páant ã jʉí jaamáchah, “Nin wã wʉ̃ʉ́h, wã oini caá. Caandíh bʉ́dí wã wẽina caá”, Dios jeámant ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Páant ã daabáát tʉ́ttimah, Tʉ́ini Espíritu Jesúsdih mʉʉ́ wihcapboó ãt nʉmah bejep wʉt jĩ, nemépwã ĩ maáh, Satanás, caandíh yeejép ã wʉtat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Caánboó jʉmna, Diosdih tʉ́i ʉʉ́bát tʉ́ʉt niijná, cuarenta yeó jáap ãt jeémpcap wʉt jĩ. Pánih jeémpcan, Jesús nʉʉgʉ́p wʉnna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Páant ã nʉʉgʉ́p wʉnʉchah enna, Satanásboó ã pebhna jʉibínit, —Meém Dios wʉ̃ʉ́h jʉmna, nin jee dáhnadih ‘Pan dahna ma jʉmʉʉ́’, ma niijí, ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Páant wã chãjcan niít. Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Jeémátdihjeh pohba ĩ jeéméchah, cã́acwãíh caolih tʉ́i booni panihni ã jʉmcan niít. Ĩ́ih caolih tʉ́i booni ã jʉmat pínah niijná, Dios naáwátdih tʉ́i joyát caá náahap’, ãt niíj daacáp tajĩ, Jesús Satanásdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Páant ã niíj jepahat tʉ́ttimah, Jerusalén, “Dioíh tʉ́tchi”, ĩ niijní tʉ́tchina Satanás Jesúsdih ãt nʉmah bejep wʉt jĩ. Caanná nʉmah jʉibínit, Dioíh mʉʉ́ chah jap bóo jʉmni waolí beo nah yapatboó Jesúsdih ãt ñʉhat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pánih ñʉhat tʉ́ʉtnit, nin pah ãt niíj naáwáp wʉt yʉh jĩ: —Meém Dios wʉ̃ʉ́h jʉmna, meemdíh ã wapat pínahdih jʉ́ʉtat tʉ́ʉt niijná, ninmant ma ñaáp jéen bejeé. Davidji nin pah ã niíj daacátjidih ma tʉ́i náhninaá: ‘Dios ã́ih ángelwãdih meemdíh ã en dawát tʉ́ʉtbipna caá. Pánihna, queét meemdíh ĩ jípónih teobipna caá, jee dáhboó míih jítcha ã bʉʉg lájcat pínah niijná’, ãt niíj daacáp tajĩ, Satanás Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—Páant wã chãjcan niít. Dios naáwátdih biíh naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Ñi Maáh Dios ã niijátjidih “¿Yoobópdih niít?” niíj jéihíhna, caandíh ñi chãjat tʉ́ʉtca bojoó’, ãt niíj daacáp tajĩ, Jesús caandíh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Páant ã niíj jepahat tʉ́ttimah, jap bóo jeená Jesúsdih Satanás ãt nʉmah pʉ́ʉh laab béjep wʉt jĩ. Caán jeejína pʉ́ʉh laáb jʉibínit, nihat cã́acwã ĩ jʉmat yoobó Jesúsdih ãt jʉ́ʉtʉp wʉt jĩ. Dawá ĩ́ih bií déedihbʉt ãt jʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pánih jʉ́ʉtnit, nin pah caandíh ãt niijíp wʉt yʉh jĩ: —Wã pebh bódicha caj yoh ñajnit, weemdíh ma weñeé. Páant ma weñechah, nihat nin tʉ́tchina ã jʉmatdihbʉt meémboodíh wã wʉ̃hbipna caá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Satanás, weemdíh ma cádah bejeé. Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Ma Maáh Diosdihjeh wẽinit, ã wʉtatdih ma jepahaá’, ãt niíj daacáp tajĩ, Jesús Satanásdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Páant ã niijíchah joinít, Satanás caandíh ãt cádahap wʉt jĩ. Páant ã cádahat tʉ́ttimah, Dioíh ángelwãboó Jesús pebh jʉibínit, caandíh ĩt teo wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tʉ́ttimah, Juandih nemat mʉʉ́boó ĩ nemat doonádih joinít, Jesús Galilea baácna ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Caanjĩ́h jʉmniji Nazaret tʉ́tchimant bejnit, Capernaum tʉ́tchina ãt jʉibínap wʉt jĩ. Caán tʉ́tchi Galilea íim jwẽ́ejdih Zabulón, Neftalí ĩ jʉimenáíh baácji jʉmni tʉ́tchi ãt jʉmʉp wʉt jĩ. Caanná jʉibínit, Jesús ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Páant ã jʉmʉchah, Dios naáwátdih naóh yapani Isaías nin ã daacátji pah Jesús ãt yapap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón, Neftalí ĩ jʉimenáíh baácji, Jordán mʉj conanaamánt, íim pebh, Galilea wʉ̃t jʉmni baácdih dawá judíowã nihcannit ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Caanjĩ́h moón dʉpʉ́napboó jʉmnit panihnit Diosdih ĩt jéih jwʉhcap taga. Pánih jéihcan, iiguípna bejnit déeji ĩt jʉmʉp taga. Obohjeéhtih, Dios ã wahni, yeh iigát panihni, ã tʉ́i chãjatdih jʉ́ʉtnit, queétdih caandíh ãt jéihyanap taga bʉca”, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Caanná jʉmna, nin pah Jesús ãt niíj naóh bohé jwíihip wʉt jĩ: “Nihat baácdih moondíh Dios ã maáh jʉmatdih ã jʉ́ʉtat pínah bahnijeh ã jʉdhna caá. Pánihna, ñi yéej chãjatdih cádahnit, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmʉ́”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tʉ́ttimah, Galilea íimna dei jʉibí, pʉ́ʉd bejnit, Simón, ã ʉ́ʉd Andrésjĩh queéj jʉ́ʉt maona, ĩ́ih ñʉodíh ĩ yoh báhanachah, Jesús queétdih ãt enep wʉt jĩ. Simónboó Pedro ĩ niijní ãt jʉmʉp wʉt jĩ. Pánih ennit, nin pah queétdih ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Weemdíh ñi pej jʉm jʉ̃ʉ́wʉ́. Páant ñi jʉ̃ʉ́wʉ́chah, yeebdíh wã bohébipna caá. Páant wã bohénachah joinít, queejwã́dih ñi bidat pah, cã́acwãboodíh bidnit, wĩ́ih doonádih ñi naóhbipna caá, weemdíh jepahna, wĩ́ihwã ĩ jʉmat pínah niijná, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Páant ã niijíchah joinítjeh, ĩ́ih ñʉonádih cádahnit, Jesúsjeéh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pánih chibít yʉʉ́p queétdih nʉmah bejnit, Santiago ã ʉ́ʉd Juandihbʉt Jesús ãt enep wʉt jĩ. Queét ĩ íip Zebedeo biícdih ĩ́ih jãáj chóodih chʉ́ʉdnit, ĩ́ih ñʉonádih ámohna ĩt chãjap wʉt jĩ. Pánih ennit, queét chénewãdihbʉt ãt bid bojop wʉt jĩ, caandíh ĩ pej jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Páant ã bid bojochah joiná, queétbʉt biícmantjeh nihat ĩ tewatdih, ĩ íipdihbʉt cádahnit, Jesúsjeéh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pánihna, nihat Galilea baácdih moondíh Jesús ã bohénitdih ãt nʉmah bohé jibip wʉt jĩ. Jwiít judíowã jwĩ míic wáacat mʉʉná jʉmat pah waadnít, Dios ã maáh jʉmat tʉ́ini doonádih ãt bohénap wʉt jĩ. Pánih bohéna, det wʉnnitdihbʉt ãt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Páant ã chãjat doonádih nihat Siria baácdih moonbʉ́t ĩt joyóp wʉt jĩ. Pánih joinít, dawá mácah wʉnat jʉmnit, bʉ́dí tʉbanit, nemép caolih jʉmnit, wãá wʉnat jʉmnit, jéih wʉ̃lícannitdihbʉt ĩt ʉb jʉibínap wʉt jĩ. Nihat ĩ ʉb jʉibínitdih Jesús ãt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Páant ã chãjat doonádih joinít, Galilea baácdih moón, Diez Tʉ́tchinadih moón, Jerusalén tʉ́tchidih moón, Judea baácdih moón, Jordán mʉj conanaamánt moonbʉ́t dawá caandíh ĩt pée bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dawá ã pebh ĩ jʉibínachah ennit, jeé ñaj yacapboó pʉ́ʉh laáb jʉibínit, Jesús caanjĩ́h ãt chʉ́ʉdʉp wʉt jĩ. Páant ã chʉ́ʉdʉchah, ã bohénitbʉt ã pebhna ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Páant ĩ jʉibínachah ennit, queétdih bohéna, nin pah ãt niíj naóh jwíihip wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Det moh yéejnit panihnit Dios ã teo wáacatdih bidnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, queétdih ã teo wáacbipna caá, Dios ã maáh jʉmʉpboó ĩ tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Det ĩ yéejatdih jĩ́gahnit, bita ĩ yéejatdihbʉt jĩ́gahnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, queétdih tʉ́i teo wáacnit, ĩ yéejatdih ã yohochah, ĩ jĩ́gahat ã yaibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Det bitadih yap yohcanjeh teo wáacnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, nin baác jáap ã jʉmʉchah, queétdih maáta pínah ã waadábipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Det nʉʉgʉ́p wʉn babhbíhnit panihnit yoobópdih chãjat pínahdih bidnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, Dios queétdih ã teo wáacbipna caá, caandíh ĩ tʉ́i jepahat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Det bitadih jĩ́gah en teo wáacnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, Diosbʉt queétdih ã jĩ́gah en teo wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Det Diosdihjeh bidnit, yoobópdih jenah joinítdih Dios ã wẽi enna caá. Pánih wẽi ennit, ã teo wáacachah, Diosdih ĩ enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Det bitadih míic jʉ̃ihñat tʉ́ʉtcan, tʉ́i biícdih chãjat tʉ́ʉtnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, ‘Wã weh caá’, queétdih ã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Det Dios ã náahat pah ĩ chãjat jíib bitaboó queétdih yeejép ĩ chãjachah yʉhna, caandíh cádahcannitdih Dios ã wẽi enna caá. Pánih wẽi ennit, ã teo wáacachah, Dios ã maáh jʉmʉpboó ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Wĩ́ihwã ñi jʉmat jíib bita yeebdíh ĩ jʉ̃ihñʉchah, yeejép ĩ chãjachah, ĩ yee naóh yacachah, yeebdíh wẽi ennit, wã teo wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dios naáwátdih naóh yapanitjidih biíc yoobó yeejép ĩtát chãj waáwáp tajĩ. Pánihna, queétdih ĩ chãjatji pahjeh bita yeebdíhbʉt yeejép ĩ chãjbipna caá. Obohjeéhtih, jeáboó ñi jʉibínachah, Dios yeebdíh bʉ́dí ã tʉ́i chãjbipna caá. Páant ã tʉ́i chãjat pínahdih jéihnit, bita yeebdíh yeejép ĩ chãjachah yʉhna, ñi tʉ́i weñeé”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yeéb nin baácboó jʉmna, nʉ́ʉmni panihni ñi jʉmna caá. Nʉ́ʉmnijĩh ñipĩ́ bʉiná caá, jeémát ã nʉñat pínah niijná. Pánihat pah yeéb wĩ́ihwãboó nihat bitajeéh jʉmna, queétdih ñi tʉ́i teo wáacna caá, ĩ tʉ́i jʉmat pínah niijná. Obohjeéhtih, nʉ́ʉmni ã bʉyát beedéchah, ñi jéih jwʉ́ʉb bʉyácan caá. Páant ã bʉicáh, caandíh yohatjeh caá náahap. Pánih yohnidih cã́acwã jéihcanjeh, ĩ wid chʉ̃ibipna caá. Pánihat dée pah yeéb Diosdih cádahna, bitadih teo wáacat dée wihcan, bʉicánni nʉ́ʉmni panihni ñita jʉm tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yeéb nin baácboó jʉmna, jiiát panihni ñi jʉmna caá. Chei namáboó ñi jii béjat pah, ñi tʉ́i chãjachah ennit, bitabʉt biíc yoobó Dioíh namáboó ĩ jéih bejna caá. Jeejíh jʉmni tʉ́tchidih dedé jãhat wihcah, nihat cã́acwã ĩ tʉ́i enat pah, yeéb ñi tʉ́i chãjatdihbʉt nihat ĩ tʉ́i enna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jiiát dahdih jiinít, pamap dahjĩh cã́acwã ĩpĩ́ páah jwejcan caá. Obohjeéhtih, caandíh japboó ĩpĩ́ jií cáagna caá, nihat mʉʉ́ diítboó jʉmnit ĩ tʉ́i enat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pánihna, caán japboó cáagni jiiát dah panihni jʉmna, yeebbʉ́t bitadih ñi tʉ́i chãjaá. Páant ñi tʉ́i chãjachah ennit, ñi íip jeámant bóodih cã́acwã ĩ wẽi naóhbipna caá”, queétdih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nindihbʉt yeebdíh wã jéihyaat tʉ́ʉtna caá: Moisés ã wʉtatjidih, Dios naáwátdih naóh yapanit ĩ daacátjidihbʉt yohodih wã jʉ̃óhcan beé. Queét ĩ daacátjidih yoobópdih cã́acwãdih jéihyanit, ĩ niijátji pah biíc yoobó chãjat tʉ́ʉt niijná, wã jʉ̃ʉ́wʉ́p be. ");
INSERT INTO cbv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yoobópdih yeebdíh wã naóhna caá. Péeni yeó jáap jã́tih, Moisés ã wʉtatji ã bʉʉdcán niít. Nihat ã daacátji pah ã yap beedáát pínah jã́tih, nin baác, jeábʉt ã bʉʉdcán niít. ");
INSERT INTO cbv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ded biíc wʉtatdih yap yohna, ‘Dedé pínah nihcan caá’, niijní, bitadihbʉt yap yohat tʉ́ʉtni, Dios ã maáh jʉmʉpboó oboh jʉmni ã jʉmbipna caá. Obohjeéhtih, ded ã wʉtatdih tʉ́i jepahna, bitadihbʉt jepahat tʉ́ʉtni, Dios ã maáh jʉmʉpboó maáh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yoobópdih yeebdíh wã naóhna caá. Moisés ã wʉtatjidih bohénit, fariseowãbʉt ‘Dios ã wʉtatdih jwĩ tʉ́i jepah beedána caá’, niijná yʉhna, ĩ tʉ́i chãjcan caá. Pánihna, Dios ã wʉtatdih yeébboodíh queét chah tʉ́i jepahat caá náahap. Pánih jepahcan, Dios ã maáh jʉmʉpboó ñi jʉibícan niít”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ñi nʉowãdih nin pah ĩ niíj naóh bohéátjidih yeebbʉ́t ñit joijí tagaá: ‘Cã́acwãdih ñi mao yohca bojoó. Ded cã́acdih mao yohnidih peéh chãjat ã jʉmbipna caá’, ĩ niijátjidih ñit joijí tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Obohjeéhtih, weémboó nin pah yeebdíh wã naóhna caá: Ded biíhdih íijna, cã́acdih mao yohnidih ĩ peéh chãjat pah, caandíhbʉt peéh chãjat ã jʉmbipna caá. Ded biíhdih jʉ̃ihna ‘Meém jenah joicánni caá’, ã niijátji jíib, peéh chãjat tʉ́ʉtnit pebhboó ĩ ʉb bejbipna caá. ‘Meém yeejépabeh caá’, niijní iiguípna bejni pínah ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Diosdih weñedih jʉibína, sacerdotedih nʉñʉ́pdih ñi mao wʉ̃hat tʉ́ʉtat pínah jã́tihbitjeh, biíh yeebdíh ã íijatdih náhninit, nin pah ñi chãjaá: ");
INSERT INTO cbv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ñi wʉ̃hni pínah nʉñʉ́pdih jwej jwʉhnit, ã pebhna jwʉ́ʉb bej, ñi míic ámohoó. ‘Páant wã chãjatjidih wã jĩ́gahna caá. Chéneji wã jwʉ́ʉb chãjcan niít, páant mʉntih. Pánihna, weemdíh ma íij jenah joyátdih ma cádahaá’, ñi niijí. Páant ñi míic ámohat tʉ́ttimah, Dioíh mʉʉná caandíh weñedih ma jwʉ́ʉb bejeé, bʉca. ");
INSERT INTO cbv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Biíhdih ma jíib bʉʉdáátdih bidnit, cã́acwãdih peéh chãjat tʉ́ʉtni maáh pebhna naóh yacadih meemdíh ã ʉb bejechah, ãjeéh íijcanjeh ma bejeé. Peéh chãjat tʉ́ʉtni pebhboó ñi jʉibíát pínah jã́tih, meemdíh ã naóh yaccat pínah niijná, caanjĩ́h ñi míic ámohoó. Páant ñi chãjcah nihna, yeebdíh ãta naóh yac tagaá. Páant ã naóh yacachah joinít, peéh chãjat tʉ́ʉtniboó meemdíh nemat mʉʉ́boó ãta nemat tʉ́ʉt tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yoobópdih yeebdíh wã naóhna caá. Caán nemat mʉʉ́boó ñi jíib chãj beedáát pah bóo ñi jʉm jwʉhbipna caá. Caán jíib chãjat tʉ́ʉtnidih jíib chãj péanit, ñi bacbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ñi nʉowãdih nin pah ĩ niíj naóh bohéátjidih yeebbʉ́t ñit joijí tagaá: ‘Bita weha mánajĩh yeejép ñi chãjca bojoó’, ĩ niijátjidih ñit joijí tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Obohjeéhtih, weémboó yeebdíh nin pah wã naóhna caá: Ded yad wilijĩh yeejép chãjcan yʉhna, caántdih en ñinahnitjeh, yeejép ãtát chãj péanap taga. Pánihna, yaddihbʉt biíc yoobó mʉntih ã yapna caá. ");
INSERT INTO cbv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ma jéihyepmant bóo quíibjĩh en ñinahnit, yeejép chãjna, caan dáhdih wã́at yohat pah, caán yéej chãjatdih ma cádahaá. Caandíh cádahcan, iiguípna mata bej tagaá. Míih quíib dahdih ma wã́at yohochah, caan dáhjeh ãta bʉʉd tágaá. Obohjeéhtih, chénat pah dahjĩh iiguípna bejna, chah yeejép pohba mata yap tagaá. Pánihna, en ñinahnit, yeejép chãjatdih cádahat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Míih jéihyepmant bóo téihyajĩh yeejép chãjna, caán téihyadih ma dʉ́ʉc bóod yohat pah, caán yéej chãjatdih ma cádahaá. Caandíh cádahcan, iiguípna mata bej tagaá. Míih téihyadih ma yohochah, caán téihyajeh ãta bʉʉd tágaá. Obohjeéhtih, chénat pah téihyajĩh iiguípna bejna, chah yeejép pohba mata yap tagaá. Pánihna, yéej chãjatdih cádahat caá náahap”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ñi nʉowãdih nin pah ĩ niíj naóh bohéátjidih yeebbʉ́t ñit joijí tagaá: ‘Yaddih yohíhna, ñi yohat pínah papélahdih wʉ̃hnit, caántdih ñi jéih yohna caá’, ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Obohjeéhtih, weémboó nin pah yeebdíh wã naóhna caá: Ãjeéh bóli biíh newéjĩh yeejép mi chãjat jíibjeh, newé caántdih ã jéih yohna caá. Páant mi chãjcah yʉhna, ã yohat tʉ́ttimah, biíhjĩh mi jwʉ́ʉb áa jʉmna, caanjĩ́h yeejép mita chãj tagaá. Pánihna, det yohnitjĩh jwʉ́ʉb áa jʉmna, yeejép ĩ chãjna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Jon jã́tih moondíh nin pah ĩ niíj naóh bohéátjidih yeebbʉ́t ñit joijí tagaá: ‘ “Dios ã enechah, wã niiját pah wã chãjbipna caá. Páant wã chãjcah, weemdíh ã peéh chãja naáh”, niijnít, ñi niiját pahjeh chãjat caá náahap’, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Obohjeéhtih, yeébboó ñi niiját pah chãjíhcan, Dios ã wʉ̃tjĩh niijcánjeh, ‘weemdíh peéh chãjná’, niijná, biíh wʉ̃tjĩhjeh ñipĩ́ niijná caá. Yoobópdih nin pah yeebdíh wã naóhna caá: ‘Jeá tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá’, ñipĩ́ niijná caá. Obohjeéhtih, ‘jeá’, niijná yʉhna, Dios ã maáh jʉmʉpboó ã jʉmʉchah, ã wʉ̃tdih niiját pahjeh mʉntih niijná caá ñi chãjap. ");
INSERT INTO cbv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘Nin baác tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá’, ñipĩ́ niijná caá. Obohjeéhtih, ‘baác’, niijná yʉhna, nin baácdih moondíh Dios maáh ã jʉmʉchah, ã wʉ̃tdih niiját pahjeh mʉntih niijná caá ñi chãjap. ‘Jerusalén tʉ́tchi tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá’, ñipĩ́ niijná caá. Obohjeéhtih, Jerusalén jwĩ Maáh chah wẽpni ã ñíoni, caandíh jwĩ weñat pínah tʉ́tchi, oboh jʉmni tʉ́tchi nihcah, biíc yoobó mʉntih niijná caá ñi chãjap. ");
INSERT INTO cbv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‘Wã báadhna, wã niiját pah yoobópdih wã chãjbipna caá’, ñi niijíchah, biíc yoobó ã tʉ́ican caá. Diosjeh yeebdíh ã jéih báadhdat tʉ́ʉtna caá. Caanjéh ñíih waó yoócdih jéih baabána, ã jéih jwʉ́ʉb eyana caá. Yeéb ã́ihwã jʉmna, ñíih bácahjĩh niijná yʉhna, ã́ih wʉ̃tjĩh niiját pahjeh mʉntih niijná caá ñi chãjap. ");
INSERT INTO cbv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Obohjeéhtih, nin pahjeh ñi niijí: ‘Páant wã chãjbip caá’, niíj, ‘Páant wã chãjcan niít’, ñi niijí. Chah dawá jacna ñi niijíchah, ã tʉ́ican caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ñi nʉowãdih nin pah ĩ niíj naóh bohéátjidih yeebbʉ́t ñit joijí tagaá. ‘Biíh míih quíib dahdih ã bʉ́ʉh mawat pahjeh, meembʉ́t caandíh bʉ́ʉh mao jwʉ́ʉbanaá. Míih maó doóbhdih ã daj mawat pahjeh, meembʉ́t caandíh daj mao jwʉ́ʉbanaá’, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Obohjeéhtih, weémboó nin pah yeebdíh wã naóhna caá: Meemdíh yeejép chãjnidih yeejép ma chãj jwʉ́ʉbaca bojoó. Ded meemdíh íijnit, míih jéihyepmant bóo pʉ́o tíibdih ã mawachah, biámantbʉt ma jʉ́ʉtʉ́, mawíhna, ã jwʉ́ʉb mawat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Biíhboó ded pah ma chãjatji jíib meemdíh ã naóh yacachah, peéh chãjat tʉ́ʉtniboó míih camisadih meemdíh naóh yacnidih ã wʉ̃hat tʉ́ʉtʉchah, caandíh wʉ̃hnit, ma dʉoní jih bóo chóodihbʉt ma wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Biíhboó ã́ih bií déedih namá tacdih meemdíh ã dʉo wáhat tʉ́ʉtʉchah, meémboó ã jʉibíát pínahna ma dʉo wáhaá. ");
INSERT INTO cbv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ded ã náahatdih meemdíh ã ʉʉ́bʉ́chah, ma wʉ̃hʉʉ́. Biíh meemdíh ã waííhichah, caandíh ma wayaá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ñi nʉowãdih nin pah ĩ niíj naóh bohéátjidih yeebbʉ́t ñit joijí tagaá: ‘Ñijeéh jʉmnitdih ñi oyoó. Obohjeéhtih, yeebdíh eníhcannitdih eníhcat caá náahap’, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Obohjeéhtih, weémboó nin pah yeebdíh wã naóhna caá: Yeebdíh eníhcannitdih oinit, ñi tʉ́i chãjaá. Det yeebdíh yeejép ĩ chãjachah, Diosdih ñi ʉʉ́bʉ́, queétdih ã tʉ́i chãjat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pánih chãjna, jwĩ íip jeámant bóo ã weh ñi jʉmbipna caá. Diosboó nihat cã́acwãdih biíc yoobó ã tʉ́i chãjna caá. Yeejépwãdih, tʉ́initdihbʉt yeó ã tʉ́i chãhat tʉ́ʉtna caá. Ã wʉtatdih jepahnitdih, jepahcannitdihbʉt mah ã bʉʉgát tʉ́ʉtna caá. Cã́acwãdih biíc yoobó Dios ã tʉ́i chãjat pah, yeebbʉ́t biíc yoobó ñi tʉ́i chãjaá. ");
INSERT INTO cbv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yeebdíh oinitdihjeh ñi oi jwʉ́ʉbanachah, dedé pínah nihcan caá. Romano maáta ĩ ʉʉ́bát tʉ́ʉtni dinerodih ʉʉ́bhnitboó tʉbit yéejnit jʉmna yʉhna, páant ĩ chãjna caá. Obohjeéhtih, yeéb wĩ́ihwãboó nihatdih oinit, biíc yoobó teo wáacat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yeéb ñi déewãdihjeh míic jwãáhnit, ñi wẽi naóh ʉʉ́bʉ́chah, dedé pínah nihcan caá. Diosdih jéihcannit yʉhna, biíc yoobó ĩ chãjna caá. Obohjeéhtih, yeébboó nihatdih ñi tʉ́i wẽi jwãáá. ");
INSERT INTO cbv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jeámant bóo jwĩ íip nihatdih tʉ́i chãjni ã jʉmat pah, ã weh jʉmna, biíc yoobó yeebbʉ́t nihatdih tʉ́i chãjnit ñi jʉmʉʉ́”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Dios tʉ́inidih ã chãjat tʉ́ʉtʉchah jepahnit, ‘¡Ñi eneé! Dios ã wʉtat pah wã tʉ́i chãjna caá’, bitadih ñi niijcá bojoó. Pánih bita ĩ wẽi enat pínahdihjeh bidna, ĩ wẽi naáwátjeh ñi tʉ́i chãjat jíib wãát jʉmna caá. Dios jeámant bóo yeebdíh ã wʉ̃hcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Moh yéejnitdih teo wáacna, bitadih ñi jʉ́ʉtca bojoó. Tʉ́i chãjnit pah jígohnitboó nihat ĩ wẽi enatdih bidna, ded pah ĩ chãjat pah ñi chãjca bojoó. Queét namánaboó jʉmnitdih, jwiít judíowã jwĩ míic wáacat mʉʉnáboó jʉmnitdihbʉt ĩpĩ́ wʉ̃hna caá, dawá queétdih ennit, ĩ wẽi naáwát pínah niijná. Queétdih ĩ wẽi naáwáchah, ĩ tʉ́i chãjatji jíib dée ĩ bíbohna caá. Diosboó ĩ tʉ́i chãjatji jíib queétdih ã jwʉ́ʉb wʉ̃hcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Obohjeéhtih, moh yéejnitdih teo wáacna, biíh ma chéen yoobát ã jʉmʉchah yʉhna, caandíh jʉ́ʉtcanjeh, ma wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Páant moh yéejnitdih ñi teo wáacachah, cã́acwã ĩ encah yʉhna, Diosboó ã enna caá. Pánih enna, caanjéh ñi tʉ́i chãjatji jíib yeebdíh ã wʉ̃hbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Diosdih ʉʉ́bhna, tʉ́i chãjnit pah jígohnitboó nihat ĩ wẽi enatdih bidna, ĩ ʉʉ́bát pah yeébboó ñi ʉʉ́bhca bojoó. Queétboó ʉʉ́bhna, jwiít judíowã jwĩ míic wáacat mʉʉnáboó, namánaboobʉ́t ñʉhnit, Diosdih ĩ ʉʉ́bhna caá, dawá queétdih ennit, ĩ wẽi naáwát pínah niijná. Páant cã́acwã ĩ wẽi enatjeh caá ĩ ʉʉ́bát jíib dée. ");
INSERT INTO cbv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Obohjeéhtih, yeébboó Diosdih ʉʉ́bát tʉ́ʉt niijná, ñíih tólihboó ñi nem waad béjeé. Pánih nem waad béjnit, jwĩ íip jwĩ jéih enca naáhdih ñi ʉʉ́bʉ́. Pánihna, cã́acwã ĩ encah yʉhna, jwĩ íipboó yeebdíh ennit, ã tʉ́i joibípna caá. Pánih joinít, ñi ʉʉ́bʉ́chah, yeebdíh ã tʉ́i teo wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ ‘Dawá láa nin jacnajĩhjeh wã ʉʉ́bʉ́chah, Dios weemdíh ã tʉ́i jepahbipna caá’, caandíh jéihcannitboó ĩ niíj jenah joiná yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pánihna, queét ĩ ʉʉ́bát pah ñi ʉʉ́bhca bojoó. Obohjeéhtih, ñi ʉʉ́bát pínah jã́tih, jwĩ íipboó ded pah ñi náahatdih ã jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pánihna, yeébboó nin pah jwĩ íipdih ñi niíj ʉʉ́bʉ́: ‘Paá, meém jeáboó jʉmni, chah tʉ́ini ma jʉmʉchah, meemdíh jwĩ wẽina caá. Ma wʉ̃t chah yáaat caá jwiít jwĩ náahna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nihat meém maáh ma jʉmatdih jéihnit, ĩ jepaha naáh. Ma wʉtʉchah, jeáboó jʉmnit ĩ tʉ́i jepahat pah, nin baácdih moonbʉ́t ĩ jepaha naáh. ");
INSERT INTO cbv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yeó jáap jʉmat pah jwĩ jeémát pínahdih ma wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bita jwiítdih ĩ yéej chãjatdih jwĩ yohat pah, meembʉ́t jwĩ yéej chãjatdih ma yohoó. ");
INSERT INTO cbv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nemépwã ĩ maáh jwiítdih ã yéejaíhichah, ma teo wáacá, jwĩ yéej chãjcat pínah niijná. Páant jwĩ ʉʉ́bʉ́chah, meém jwĩ Maáh chah wẽpni jʉmna, ma jéih jepahna caá. Páant ma jʉmʉchah, yeó jáap jʉmat pah nihat meemdíh ĩ wẽi naáwát caá náahap. Páant tií ã jʉmʉ nah’, Diosdih ñi niíj ʉʉ́bʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bita yeebdíh ĩ yéej chãjatdih ñi yohochah ennit, jwĩ íip jeáboó jʉmnibʉt yeéb ñi yéej chãjatdih ã yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Obohjeéhtih, bita yeebdíh ĩ yéej chãjatdih ñi yohcah, jwĩ íipbʉt ñi yéej chãjatdih ã yohcan niít”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Diosdih tʉ́i ʉʉ́bát tʉ́ʉt niijná, jeémp jwʉhcan, jĩ́gahnit pah ñi jígohca bojoó. Páant tigaá tʉ́i chãjnit pah jígohnitboó ĩpĩ́ chãjap. Cã́acwã queétdih ĩ wẽi naáwátdih bidna, queét ĩ́ih móotdih jĩ́gahni pah ĩ chãjna caá. Páant ĩ chãjachah, jeémp jwʉhcannit ĩ jʉmatdih nihat ennit, ‘Queét tʉ́init caá’, ĩ niíj wẽina caá. Yoobópdih yeebdíh wã naóhna caá: Cã́acwã queétdih ĩ wẽi naáwátjeh ĩ jeémp jwʉhcat jíib dée ã jʉmna caá. Diosboó queétdih ã wẽi naóhcan niít. Queét ĩ chãjat pah ñi chãjca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Obohjeéhtih, yeébboó jeémp jwʉhcan, ñíih móotdih tʉ́i chocnit, yeó jáap jʉmat pah ñi tʉ́i míic ámohat pah ñi chãjaá. ");
INSERT INTO cbv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yeéb páant ñi chãjachah, ñi jeémp jwʉhcatdih cã́acwã ĩ jéihcah yʉhna, jwĩ íipboó ã jéihbipna caá. Jwĩ íip, jwĩ jéih enca naáh, ñijeéh jʉmnit, jeémp jwʉhcanjeh, ñi ʉʉ́bʉ́chah, ã enbipna caá. Pánih ennit, ded pah jeémp jwʉhcan, ñi ʉʉ́bát jíib yeebdíh ã tʉ́i chãjbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nin baácboó jʉm jwʉhna, ‘Wĩ́ih pínahjeh caá’, niíj jenah joinít, bií déedih dawá ñi ʉb ámohca bojoó. Nin baácboó jʉmni ã moopáh bejbipna caá. Biíh moópcannidih bitaboó ĩ nʉʉmbípna caá. Pánihna, nin baácdih bóo bií dée bʉʉdní pínahjeh ã jʉmʉchah, caandíh ñi en ñinahca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Obohjeéhtih, bií déedih ñi en ñinahat pah Dios ã weñat pínahdih tʉ́i jenah joí chãjnit, bʉ́dí jíib jʉmni panihnidih jeáboó ñi bíbohbipna caá. Caán ñi bíbohniboó ã moópcan niít. Nʉʉmnít ĩ jéih ʉb bejcan niít. Pánihna, caanná ñi bíbohat pínah ã bʉʉdcán niít. ");
INSERT INTO cbv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dios pebhboó ñíih bʉ́dí jíib jʉmni panihni ã jʉmʉchah jéihnit, Dios ã weñat pínahdih ñi tʉ́i jenah joibípna caá. Obohjeéhtih, nin baácboojéh ñíih bʉ́dí jíib jʉmnidih bíbohnit, ñi weñat pínahdihjeh ñi jenah joibípna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Jiiát ã tʉ́i yeh iiguíchah, jwĩ tʉ́i jéih enat pah, Dios ã weñat pínahdih tʉ́i jenah joinít, tʉ́inidih ñi chãjbipna caá. Ded pah ñi jenah joyátdihjeh ñi chãjbipna caá. Tʉ́inidih jenah joinít, tʉ́inidih ñi chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Obohjeéhtih, tʉ́icannidih jenah joinít, yeejépdih ñi chãjbipna caá. Páant yeejépdih ñi jenah joyóchah, tʉbit yeejép ñi chãjat ã jʉmbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ded Diosdih oini ã weñat pínahdih chãjna, tʉbit pohba dinerodih ã jenah joicán niít. Obohjeéhtih, ded dinerodihjeh bʉ́dí jenah joiníboó Diosboodíh ã oican caá. Dinerojĩhjeh wẽini jʉmna, Diosboodíh ã náahcan niít. Pánihna, Diosdih, dinerodihbʉt biíc yoobó ñi jéih bidcan caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nin pah yeebdíh wã jwʉ́ʉb naóhna caá: Ñi jeémát pínah, ñi babhbat pínah, ñi dʉwát pínah yéguehnadihbʉt ñi náhni dahwaca bojoó. Obohjeéhtih, caandíh bidat chah Diosjeéh ñi tʉ́i jʉmat pínahboodíh ñi bidií. Páant ñi bidichah, caán yeebdíh oina, ñi jeémát pínah, ñi dʉwát pínahdihbʉt ã wʉ̃hbipna caá, ñi tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jwébehwãdih ded pah Dios ã en dawátdih ñi jenah joyoó. Queét wápchi wihcan, jeémát ĩ ámohat mʉʉnádihbʉt ĩ bíbohcah yʉhna, jwĩ íipboó queétdih tʉ́i en daoná, ĩ jeémát pínahdih ãpĩ́ wʉ̃hna caá. ¡Obohjeéhtih, jwébehwãdih ã oyat chah yeébboodíh Dios ã oina caá! Pánih oinit, yeebdíhbʉt ã tʉ́i en daobípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nindih ñi tʉ́i jenah joyoó: Bʉ́dí náhni dahwana yʉhna, ñi wʉnat pínah yeó jáapdih ñi jéih tʉ́ʉt nʉʉmcán niít. Pánihna, bʉ́dí ñi jenah joyát dedé pínah nihcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ñi dʉwát pínah yéguehnadihbʉt bʉ́dí ñi jenah joicá bojoó. Jiadih bóo cháanadih ñi tʉ́i jenah joyoó. Caán cháana behna, ã tʉ́i jígohat pínahdih ãpĩ́ teocan caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pánih teocan yʉhna, maáh Salomónji ã́ih tʉ́ini yégueh chóodih dʉonít, ã tʉ́i jígohat chah cháanaboó ã tʉ́i jígohna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Caán cháanadih Diosboó ã tʉ́i jígohat tʉ́ʉtna caá. Obohjeéhtih, caán cháanaboó bʉʉ déedih jʉm, cheibit déedih ã diib téh bejna caá. Páant ã diib téhechah, cã́acwã ĩpĩ́ cáo yohna caá. Páant maátcanjeh ã jʉmʉchah yʉhna, Dios caán cháanadih tʉ́i jígohni ã chãjna caá. Caán cháanadih tʉ́ini yégueh dée pah ã wʉ̃hat chah yeébboodíh Dios yéguehdih ã wʉ̃hbipna caá. Pánihna, caandíh bʉ́dí jenah joicánjeh, Diosboodíh ñi tʉ́i jenah joyoó. ");
INSERT INTO cbv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ñi jeémát pínah, ñi babhbat pínah, ñi dʉwát pínahdihbʉt bʉ́dí ñi jenah joicá bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diosdih jéihcannitboó bií déedih tʉbit ĩpĩ́ jenah joiná caá. Obohjeéhtih, jwĩ íip jeáboó jʉmni, ñi jeémát pínah, ñi dʉwát pínahdihbʉt ded pah yeebdíh jʉdhdatdih ã jéihna caá. Pánih jéihna, yeebdíh ã teo wáacat pínahdih ñi tʉ́i jenah joyoó. ");
INSERT INTO cbv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bií déedih ñi bidat chah, Dios ã maáh jʉmatdih bidnit, caandíh ñi tʉ́i jepahaá. Pánih jepahnit, ã́ih tʉ́ini doonádih bitadih ñi naáwá, queétbʉt caandíh ĩ jepahat pínah niijná. Páant ñi chãjachah, Diosboó nihat ñi náahatdih ã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Cheibit dedé ã yapat pínahdih bʉ́dí ñi jenah joicá bojoó. Cheibit yeejép ñi yapachah, Dios yeebdíh ã teo wáacbipna caá. Bʉʉ ded pah ñi chãjatdihjeh jenah joyát caá náahap. Biíh yeó jáapdih bóo pínahdih tʉbit ñi jenah joicá bojoó. Dios yeebdíh en daonít, ã tʉ́i teo wáacbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ ‘Meém yeejép caá’, bitadih ñi niijcá bojoó. Páant ñi niijcáh, Dios yeebdíhbʉt ‘Meém yeejép caá’, ã niijcán niít. ");
INSERT INTO cbv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bitadih ‘Ãpĩ́ tʉ́i chãjcan caá’, ñi niíj enat pah, Diosboó yeebdíhbʉt biíc yoobó ã niíj enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nin pah yeéb ñipĩ́ chãjna caá: Ñi déedih bainí quíib becát ã jʉmʉchah, caanbítdih ñi tʉ́i enna caá. Caán bainí oj ã jʉmʉchah yʉhna, ñi enat pah, ñi dée ã yéej chãjatbitdih ñipĩ́ enna caá. Obohjeéhtih, yeebdíh bʉ́dí quíib becát ã jʉmʉchah yʉhna, caandíh ñi encan caá. Caandíh ñi encat pah, bʉ́dí yeejép chãjna yʉhna, ñi enah bojna caá. ¿Dépanih tigaá páant ñi chãj? ");
INSERT INTO cbv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Yeebdíh bʉ́dí quíib becát panihni ã jʉmʉchah yʉhna, ‘Némé, ma quíib becátdih weémboó meemdíh wã póoj yohbipna caá’, ñipĩ́ niijná caá. Pánihat pah, bʉ́dí yéej chãjnit jʉmna yʉhna, ‘Némé, tʉbit yeejép chãjna caá ma chãjap. Caandíh ma cádahaá’, ñipĩ́ niijná caá. ¿Dépanih tigaá yeéb yeejép chãjnit jʉmna yʉhna, bʉ́dí ñi yéej chãjatdih jenah joicánjeh, bita bainí ĩ yéej chãjatdihjeh ñi jenah joí? ");
INSERT INTO cbv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Páant niijnít, tʉ́init pah jígohnit ĩ chãjat pahjeh mʉntih yeebbʉ́t biíc yoobó ñi chãjna caá. Yeebdíh bʉ́dí quíib becát panihnidih ñi jwíih póoj yohat pah, ñi yéej chãjatdih jwíih cádahat caá náahap. Páant ñi cádahat tʉ́ttimah, ñi déeíh bainí quíib becát panihnidih tʉ́i jéih enna, ñi jéih póoj yohat pah, ã yéej chãjatdih ñi jéih cádahat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mʉjjiowã́ panihnit yeejépwã Diosdih náahcannitdih ã́ih tʉ́ini doonádih ñi naóhca bojoó. Páant ñi naáwáchah, caandíh joí íijnit, yeebdíh tʉbit yeejép ĩta chãj taga. Momo mʉʉwã panihnit, ií náah chãjnitdih Dioíh tʉ́ini doonádih ñi naóhca bojoó. Queétdih ñi naáwáchah, joííhcan, bʉ́dí jíib jʉmni jeé tíibnadih momo mʉʉwã bepédih ĩ wid chʉñat pah, caán tʉ́ini doonádih ĩta yoh tagaá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Diosdih ʉʉ́bhna, ñi ʉʉ́bh cádahca bojoó. Páant ñi ʉʉ́bʉ́chah, ded pah ñi ʉʉ́bátdih Dios yeebdíh ã wʉ̃hbipna caá. Ded pah ñi náahatdih bidnit, ñi bid cádahcah, ded pah ñi bidatdih yeebdíh ã wʉ̃hbipna caá. Jẽc panihnidih wʉʉ́mp mao cádahcah, Dios ã wãtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Det Diosdih tʉ́i ʉʉ́bhnit, ĩ ʉʉ́bátjidih ĩ bíbohbipna caá. Det Diosdih bidnit, caandíh ĩ jwãáhbipna caá. Det ĩ wʉʉ́mp mawachah joinít, jẽc panihnidih Dios queétdih ã wãtbipna caá. Pánihna, yeó jáap jʉmat pah Diosdih ñi ʉʉ́bʉ́chah, yeebdíh ã jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Pan dahdih ñi wʉ̃ʉ́h yeebdíh ã ʉʉ́bʉ́chah joinít, jee dáhboodíh caandíh ñita wʉ̃h taniít? Ñita wʉ̃hcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Queejdíh ã ʉʉ́bʉ́chah, bʉcdih ñita wʉ̃h taniít? Ñita wʉ̃hcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yeéb yéejnit jʉmna yʉhna, ñi wehdih tʉ́inidih ñipĩ́ wʉ̃hna caá. Pánihna, ñi íip Diosboó yéejcanni jʉmna, tʉ́ini ñi wʉ̃hat chah caandíh ʉʉ́bhnitdih ã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bita yeebdíh ĩ tʉ́i chãjat pínahdih ñi náahat pah, yeebbʉ́t bitadih ñi tʉ́i chãjaá. Queét yeebdíh ĩ tʉ́i chãjcah yʉhna, yeébboó queétdih ñi tʉ́i chãjaá. Páant tigaá Moisés ã wʉtatji, Dios naáwátdih naóh yapanit ĩ daacátjibʉt ã niijíp”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Jeáboó bejíhna, Diosdih tʉ́i jenah joinít, ñi jepahaá. Pánih jepahnit, ã weñat pínahdihjeh ñi chãjbipna caá. Pánih chãjnit, bainí jẽc panihni ã jʉmʉchah yʉhna, ã pebhna bejni bainí namádih ñi jéih ñáan bejbipna caá. Obohjeéhtih bʉ́dí jẽcdih waadnít, bʉ́dí namádih ñi bejechah, dedé bʉwat ã wihcan niít. Páant ã bʉocah, dawá jenah joicánjeh iiguípna bejni namádih bejna, bʉʉdnít ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Obohjeéhtih, bainí jẽcdih waadná, bainí namáboó ñi ñáan bejechah, tʉ́i jenah joyát caá náahap. Pánihat pah, Dios pebhboó yeéb ñi bejíhichah, ã bʉwʉchah yʉhna, caandíh tʉ́i jenah joinít jʉmna, ñi jéih bʉʉjábipna caá. Pánih ñáan bejna, Dios pebhboó jʉibínit, páantjeh ãjeéh ñi tʉ́i jʉmbipna caá. Obohjeéhtih, daocánnit tʉ́i jenah joinítjeh caán namáboó ĩ jéih ñáan bejbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ñi tʉ́i chãja chaáh. ‘Dios naáwátdih naóh yapani caá’, niíj yeenitdih ñi joyáh bojoó. Queét tʉ́init pah jígohna yʉhna, ĩ jenah joyátboó yeejép ã jʉmʉchah, yeebdíh ĩ yéejaíhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Queétdih beh enat tʉ́ʉt niijná, ded pah ĩ chãjatdih ñi tʉ́i eneé. Yeejép ĩ chãjachah enna, yeejépwã ĩ jʉmatdih ñi jéihbipna caá. Ĩ tʉ́i chãjachah enna, tʉ́init ĩ jʉmatdih ñi jéihbipna caá. Nin pah caá ã jʉmʉp: Ded óot nah iguíh pihana ãpĩ́ quehcan caá. Mai bab nahbʉt bab dahna ãpĩ́ quehcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tʉ́ini nah tʉ́ini dahna ã quehna caá. Obohjeéhtih, yeejép nahboó yeejép dahna ã quehna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tʉ́ini nah yeejép dahna ã quehcah, yeejép nahbʉt tʉ́ini dahna ãpĩ́ quehcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yeejép dahna quehni nahdih tib yohnit, cã́acwã ĩpĩ́ cáo yohna caá. Pánihat dée det yeejép chãjnitdih Dios ã yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","‘Dios naáwátdih naóh yapani wã jʉmna caá’, niíj yeenitdih nin pah ñi beh enbipna caá: Ded pah ĩ chãjatdih enna, yeenit ĩ jʉmatdih ñi jéihbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Dawá weemdíh ‘Maá’, niijnít jʉmna yʉhna, jeáboó ĩ jʉibícan niít. Wã íip jeáboó jʉmni ã weñat pínahdih chãjnitjeh ã maáh jʉmʉpna ĩ jʉibíbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Péeni yeó jáapnadih wã íip ã maáh jʉmʉpna waádíhnit, dawá weemdíh jepahcannitjibʉt nin pah ĩ niijbípna yʉh caá: ‘Maá, ma wẽpatjĩh ma naáwátdih jwiít jwĩ naóh yapanap jĩ. Ma wẽpatjĩh nemépwãdih jwĩ bacat tʉ́ʉtʉp jĩ. Cã́acwãjeh ĩ jéih chãjca naáhdih ma wẽpatjĩh jwĩ chãj jʉ́ʉtʉp jĩ’, ĩ niijbípna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Obohjeéhtih, ‘¡Yeebdíh wã jéihcan caá! ¡Yeejép chãjnitjeh ñi jʉmna caá! Pánih jʉmnit, wã pebhna ñi waád jʉ̃óhca bojoó’, queétdih wã niíj jepahbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ded wã bohéátdih joí jepahna, mʉʉ́ chãj pooni panihni ã jʉmna caá. Tʉ́i jenah joiní jwʉmʉ́p baácdih nʉmah baád waadánit, ã́ih jagápdih ã tʉ́i dodhdop be. ");
INSERT INTO cbv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Caán mʉʉdíh ã péaat tʉ́ttimah, bʉ́dí mah jʉ̃óh, mʉj bʉ́dí daab béj, bʉ́dí johlitbʉt ã jʉ̃ʉ́wʉ́p be. Páant tʉbit ã johochah yʉhna, caán mʉʉ́ nʉmah dodhni jʉmna, ã ã́accap be. ");
INSERT INTO cbv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Obohjeéhtih, ded wã bohéátdih joiná yʉhna, jepahcan, tʉ́i jenah joicánni mʉʉ́ chãjni panihni caá ã jʉmʉp. Caánboó óonjihbitjeh baád waadánit, ã́ih jagápdih ã dodhdop be. ");
INSERT INTO cbv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Caán mʉʉdíh ã péaat tʉ́ttimah, mah bʉ́dí jʉ̃óh, mʉj daab béj, bʉ́dí johlitbʉt ã jʉ̃ʉ́wʉ́p be. Pánih bʉ́dí ã johochah, caán mʉʉ́ ã́acna, bʉ́dí ã yáanap be”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Páant ã niíj naáwáchah joiná, cã́acwã ĩt joí wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Caán tʉ́i jéihni pah jwiítdih ã niíj bohéna caá. Moisés ã wʉtatjidih bohénit páant ĩpĩ́ niíj bohécan caá. Pánih bohéna, caánboó yoobópdih tigaá maáh ã jʉmʉp”, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Páant niíj naóh bohé péanit, Jesús jeé ñaj yacapboó chʉ́ʉdniji ã bohénitdih ãt nʉmah dei bejep wʉt jĩ. Ã dei bejechah ennit, dawá ãjeéh ĩt pée bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Páant ĩ bejechah, bácah moópni jwãáhnit, bódicha caj yoh ñajnit, nin pah ãt niijíp wʉt jĩ: —Maá, ma booaíhna, weemdíh ma jéih booana caá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","—¡Jʉ́ʉ! Wẽinit meemdíh wã booana caá, caandíh teo jã́hanit, ãt niijíp wʉt jĩ. Páant Jesús ã niijíchahjeh, ã moopát ãt ñʉʉmáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—Meemdíh wã booaatjidih bitadih ma naóhca bojoó. Pánih naóhcan, sacerdotedihjeh naáwádih ma bejeé. Caanná jʉibínit, míih bácah ã ñʉʉmátjidih ma jʉ́ʉtʉ́. Moisés ã wʉtatji pah sacerdotewã ĩ cáo wʉ̃hat pínah niijná, chéne jopwãdih ma wʉ̃hʉʉ́, Dios meemdíh ã booaatjidih ĩ jéihyat pínah niijná. Tʉ́ttimah, ma déewãjeéh ma jwʉ́ʉb jʉmʉchah, ã tʉ́ibipna caá, Jesús caandíh ãt wẽp niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tʉ́ttimah, Jesús Capernaum tʉ́tchina ã jʉibínachah, Romano cien soldadowã ĩ maáh ã pebh jʉibínit, nin pah caandíh ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Maá, weemdíh ma teo wáacá. Weemdíh teo wʉ̃hni bʉ́dí wʉnna, wĩ́ih mʉʉ́boó ã lajna caá. Ã́ih bácah jwioní ã jʉmʉchah, bʉ́dí tʉbanit, ã jéih bejcan caá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Caandíh booanadih wã bejmi caá, Jesús caandíh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","—Obohjeéhtih, Maá, wĩ́ih mʉʉná ma bejcah, ã tʉ́imi nacaá. Weem cháh wẽpni ma jʉmʉchah, ‘Wĩ́ih mʉʉdíh ma waád jʉ̃ʉ́wʉ́’, niijní dée nihcan caá. Ma naáwáchahjeh, weemdíh teo wʉ̃hni ã boobipna caá. Wã chah jʉmnit bita maáta weemdíh ĩ wʉtna caá. Weembʉ́t soldadowãdih wʉtni caá. Biícdih ‘Ma bejeé’, wã niijíchah, ãpĩ́ bejna caá. Biíhdih ‘Ma jʉ̃ʉ́wʉ́’, wã niijíchah, ãpĩ́ jʉ̃óhna caá. ‘Nindih ma chãjaá’, wã niijíchah, páant ã chãjna caá. Weém wʉtni jʉmna, meembʉ́t wʉtni ma jʉmatdih wã jéihna caá. Ma wʉtat pahjeh weemdíh teo wʉ̃hni ã boobipna caá, soldadowã ĩ maáh Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Páant ã niijíchah joí wẽinit, Jesús ãjeéh péenitdih nin pah ãt niijíp wʉt jĩ: —Yoobópdih yeebdíh wã naóhna caá. Nin soldadowã ĩ maáh judío nihcan yʉhna, Diosdih ã tʉ́i jenah joiná caá. Caandíh teo wʉ̃hnidih wã booaat pínahdih ãt jéihyep taga. Weemdíh caán ã tʉ́i jenah joyát pah, ded judío biíc yoobó jenah joinídih wã en jwʉhcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yeebdíh wã naóhna caá. Péeni láa bita judíowã nihcannit, nihat baácdih moón Diosdih tʉ́i jenah joinít, jeáboó Dios ã maáh jʉmʉpna dawá ĩ jʉibíbipna caá. Caanná jʉmnit, Abraham, Isaac, Jacob biícdih ĩ jeémpbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Obohjeéhtih, judíowã Dios ã maáh jʉmʉpna bejnit déejidih, yeejép dʉpʉ́napboó ã wahbipna caá. Caanná ã wahnitboó bʉ́dí jĩ́gahnit, ĩ́ih maodíh ĩ néeh chãác jʉ̃ibípna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Páant queétdih niíj péanit, soldadowã ĩ maáhdih nin pah ãt jwʉ́ʉb niijíp wʉt jĩ: —Míih mʉʉná ma jwʉ́ʉb bejeé. Meemdíh teo wʉ̃hni booni ã jʉmna caá. ‘Jesús caandíh ã booabipna caá’, ma niíj jenah joyát pahjeh ã yapna caá, Jesús caandíh ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, ã́ih mʉʉ́boó jʉmni caandíh teo wʉ̃hni ãt boonap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Páant niíj péanit, Jesús ã bohénitdih ãt jwʉ́ʉb nʉmah bejep wʉt jĩ, páant mʉntih. Pánih bejna, Pedroíh mʉʉná jʉibínit, ĩt waad béjep wʉt jĩ. Pánih waad béjnit, Pedro chʉdh bʉ́dí pahat wʉnna, mi ñajat chóoboó mi ñajachah, Jesús ãt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pánih ennit, miíh téihyadih ã teo jã́hanachahjeh, pahat ãt dʉ́ʉcah bejep wʉt jĩ. Páant ã dʉ́ʉcʉchah joinít, caántboó ñah ñʉhnit, Jesúsdih jeémát mit wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tõo ñáh jʉ̃ʉ́wʉ́chah, dawá nemép caolih jʉmnitdih ĩ chéenwã Jesús ã jʉmni mʉʉ́ jóocmant ĩt ʉb jʉibínap wʉt jĩ. Páant ĩ ʉb jʉibínachah ennit, Jesúswã ĩt bac bejep wʉt jĩ. Pánih bac bejnit, Jesúsboó nemépwãdih ã bac bejat tʉ́ʉtʉchahjeh, cã́acwãíh bácahmant ĩt bac bejep wʉt jĩ. Bita tʉbʉ́p chʉ̃ʉ́hnitdihbʉt Jesús ãt booa beedánap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Páant ã chãjachah, Dios naáwátdih naóh yapani Isaías ã niijátji pah ãt yapap wʉt jĩ. “Jwĩ tʉbʉ́p chʉ̃ʉ́átdih, jwĩ wʉnatdihbʉt jĩ́gah ennit, ãt booanap taga”, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dawá Jesús pebh ĩ jʉí ñʉhʉchah ennit, Jesús ã bohénitdih nin pah ãt niijíp wʉt jĩ: —Chóbe conanaáboó jwĩ chʉ́ʉh bejjĩh, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Páant niijnít, jẽ́litna ĩ dei bejechah, Moisés ã wʉtatjidih bohéni Jesúsdih jwãáhnit, nin pah ãt niijíp wʉt jĩ: —Bohéní, deyoób ma bejechah, weembʉ́t majeéh wã bejmi caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—Jia mʉjjiowã́ ĩ́ih mʉʉ́ pínah íitnadih ĩ bíbohna caá. Jwébehwãbʉt ĩ́ih yécanadih ĩ bíbohna caá. Obohjeéhtih, weémboó nihat cã́acwã ʉ́ʉd jeñé, wĩ́ih mʉʉjéh pohba wã bíbohcan caá. Pánihna, wãjeéh ma jʉ̃ʉ́wʉ́chah, bʉ́dí bʉwat meemdíhbʉt ã jʉmbipna caá, Jesús caandíh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Páant ã niijíchah joinít, biíh jwʉh nin pah ãt niijíp wʉt jĩ: —Maá, majeéh weembʉ́t wã bejmi caá. Obohjeéhtih, wã bejat pínah jã́tih wã íip ã wʉnʉchah, ã́ih bácahdih wã yohat pínah niijná, ‘Ma chão jwʉ́hʉʉ́’, weemdíh ma niijí. Ã wʉnʉchah yoh péanit, majeéh wã bejbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Weemdíh náahcannit wʉnnit panihnit jʉmna, queétboó wʉnnitdih ĩ yoho naáh. Obohjeéhtih, meémboó wãjeéh jʉmni pínah bʉʉ ma jʉ̃ʉ́wʉ́, Jesús caandíh ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Páant niíj péanit, jẽ́litboó dei jʉibínit, bʉ́dí jãáj chóodih ã bohénitdih ãt nʉmah waadáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Íimdih ĩ chʉ́ʉh bejechah, Jesúsboó ãt ʉ̃wah bejep wʉt jĩ. Pánihna, íim tac yoób ĩ bʉʉg lájachah pohba, Jesús ã ʉ̃wat pónih, bʉ́dí johlit ãt jʉ̃ʉ́wʉ́p wʉt jĩ. Páant bʉ́dí nolihat ã jʉmʉchah, ĩt daábíhip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","—¡Maá, jwiítdih ma teo wáacá! ¡Daabná caá jwĩ chãjap! ĩt niíj wʉcʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Páant ĩ niíj wʉcʉchah, jáanit, Jesús queétdih nin pah ãt niijíp wʉt jĩ: —¿Dépanih tigaá bʉ́dí ñi ʉ́ʉm? Weemdíh tʉ́i jenah joiná, ñita ʉ́ʉmcan tagaá, ãt niijíp wʉt jĩ. Páant niijnít, ñah ñʉhnit, johlit, nolihatdihbʉt jʉ̃ihnit, “Ma yayaá”, ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, johlit nolihatbʉt biícmantjeh ãt yayáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Páant ã yapachah, en wʉ́hi bejnit, queétjeh nin pah ĩt míic niijíp wʉt jĩ: —¿Dedé cã́ac tigaá nin? Ã naáwáchahjeh, johlit, nolihatbʉt ã yayáh bejna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Páant ã yapat tʉ́ttimah, Gadara baácna ĩt chʉ́ʉh jʉibínap wʉt jĩ. Caanná ĩ chʉ́ʉh jʉibínachah, chéne neoná cã́ac yohopmant Jesúsdih ĩt jwãáh dei jʉ̃ʉ́wʉ́p wʉt jĩ. Queét nemép caolih jʉmnit, tʉbit tac behnit ĩ jʉmʉchah, caanná cã́acwã ĩpĩ́ bejcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pánihna, Jesúsdih jwãáh dei jʉibínit, nin pah ĩt niíj ñaacáp wʉt jĩ: —¿Meém Dios wʉ̃ʉ́h, dépanih chãjadih jʉ̃óh tigaá ma chãj? ¿Dios ã peéh chãjat pínah ã jʉdh jwʉhʉchah yʉhna, jã́tih jwiítdih peéh chãjadih jʉ̃óhnit beé ma chãjap? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yʉʉ́pbit dawá momo mʉʉwã bid jeémpna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pánihna, queétdih ennit, nemépwã nin pah Jesúsdih ĩt niijíp wʉt jĩ: —Jwiítdih bacat tʉ́ʉtna, cot mʉʉwãdih ma waadát tʉ́ʉtʉ́, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Jʉ́ʉ, caán láa bácah ñi bejeé, Jesús queétdih ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, queét cã́acwãíh bácahmant bacnit, mʉʉwãdih nemépwã ĩt waadáp wʉt jĩ. Páant ĩ waadáchah, wẽpép ñáo dei bej, íimna bʉʉ́g báah bejnit, mʉʉwã ĩt chĩíc wʉn beedáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Páant ĩ yapachah enna, bʉ́dí ʉ́ʉmnit, queét mʉʉwãjidih en daonítboó ĩ́ih tʉ́tchina ĩt ñáo jweí jwʉ́ʉb bejep wʉt jĩ. Pánih ñáo jwʉ́ʉb jʉibínit, mʉʉwã ded pah ĩ yapatjidih, nemép caolih jʉmnitdihbʉt ded pah Jesús ã booaatjidih ĩt naóh peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Páant ĩ naáwáchah joinít, nihat caán tʉ́tchidih moón Jesúsdih enedih ĩt bejep wʉt jĩ. Pánih jʉibínit, caandíh náahcan, ĩ́ih baácmant Jesúswãdih ĩt jwʉ́ʉb bejat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Páant ĩ jwʉ́ʉb bejat tʉ́ʉtʉchah joinít, ĩ́ih jãáj chóona waadnít, Jesúswã ĩt jwʉ́ʉb chʉ́ʉh bejep wʉt jĩ. Pánih chʉ́ʉh bejnit, Jesús ãpĩ́ jʉibíni tʉ́tchina ĩt jwʉ́ʉb jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Caanná ĩ jʉibínachah, caanjĩ́h moón jéih yoocannidih ã ñajat chóojĩh Jesús pebhna ĩt beo jʉibínap wʉt jĩ. “Jesús nindih ã jéih booabipna caá”, ĩt niíj jenah joyóp wʉt jĩ. Páant ĩ niíj jenah joyátdih jéihnit, jéih yoocannidih nin pah Jesús ãt niijíp wʉt jĩ: —Ma weñeé. Ma yéejatdih meemdíh wã yohna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Páant ã niijíchah joinít, biquína Moisés ã wʉtatjidih bohénit nin pah ĩt niíj jenah joyóp wʉt yʉh jĩ: “Diosjeh yéejatdih ã jéih yohna caá. Nin cã́acjeh jʉmna yʉhna, páant niijná, ‘Dios wã jʉmna caá’, niíj yeena caá ã chãjap”, ĩt niíj jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Páant ĩ niíj jenah joyátdih jéihnit, nin pah Jesús queétdih ãt niijíp wʉt jĩ: —¿Dépanih tigaá páant yeejép ñi jenah joí? ");
INSERT INTO cbv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Ma yéejatdih wã yohna caá’, wã niijíchah joinít, weemdíh jéihcan yʉhna, ‘Yeeni caá’, ñi niíj jenah joiná caá. Obohjeéhtih, ‘Ñah ñʉhnit, ma yáac chʉ̃i bejeé’, wã niijíchah, caán ã bejechah ennit, wã niiját yoobópdih ã jʉmatdih ñi jéihbipna caá. Pánih jéihna, yéejat yohat wẽpat wã bíbohatdihbʉt ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Weém nihat cã́acwã ʉ́ʉd jeñé, nin baácdih moondíh jéih booanit, ĩ yéej chãjatdihbʉt wã jéih yohna caá. Pánih tibeé Dios weemdíh ã wah deyanap jĩ, cã́acwã ĩ yéejatdih wã yohat pínah niijná. Pánihna, caán wẽpatdih wã bíbohatdih yeéb ñi jéihyat pínah niijná, nin pah wã chãj jʉ́ʉtbipna caá, ãt niijíp wʉt jĩ. Páant niíj péanit, jéih yoocannidih nin pah ãt niijíp wʉt jĩ: —Ma ñah ñʉhʉʉ́. Ma ñajat chóodih ʉbnit, míih mʉʉ́boó ma jwʉ́ʉb bejeé, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Páant ã niijíchah joinít, jéih yoocanniji ñah ñʉhnit, ã́ih mʉʉ́boó ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Páant ã booanachah ennit, cã́acwã ĩt en wʉ́hi bejep wʉt jĩ. Pánih en wʉ́hi bejnit, Dios Jesúsdih bʉ́dí wẽpat ã wʉ̃hatdih jéihnit, Diosdih bʉ́dí ĩt wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pánih booa péaniji caán mʉʉmánt bac bejnit, Jesús ã bohénitdih ãt jwʉ́ʉb nʉmah jib bejep wʉt jĩ. Pánih bejnit, caanmánt jʉ̃óhnit, weém Mateo pebh ĩ jʉyʉ́p jĩ. Romanowã ĩ maáta ĩ ʉʉ́bát tʉ́ʉtni dinerodih ʉʉ́bh wʉ̃hni wã jʉmʉp jĩ. Pánihna, caán láa wĩ́ih tewat tólihboó wã chʉ́ʉdʉp jĩ. Caanjĩ́h wã chʉ́ʉdʉchah ennit, nin pah weemdíh Jesús ã niijíp jĩ: —Wãjeéh ma pée jʉ̃ʉ́wʉ́, ã niijíp jĩ. Páant ã niijíchah joinítjeh, ñah ñʉhnit, ãjeéh wã bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tʉ́ttimah, Jesúswãdih wĩ́ih mʉʉ́boó nʉmah jeémédih wã bejep jĩ. Weem páh dawá dinerodih ʉʉ́bh wʉ̃hnitdih, bita “Yeejépwã caá”, ĩ niijnítdihbʉt wã nʉmah jeémép jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Páant queét biícdih jwĩ jeéméchah ennit, biquína fariseowã jwiít Jesús ã bohénitdih nin pah ĩ niíj jʉ̃ihñʉp jĩ: —¿Dépanih tigaá ñíih bohéni dinerodih ʉʉ́bh wʉ̃hnit, yeejép chãjnit biícdih ã jeémp? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Páant ĩ niijíchah joinít, Jesúsboó queét fariseowãdih nin pah ã niíj jepahap jĩ: —Tʉbʉ́p chʉ̃ʉ́hcannit cohnidih ĩpĩ́ bidcan caá. Wʉnnitjeh caá caandíh ĩ bidip. Pánihat pah ‘Weém yéejat wihcanni caá’, niíj jenah joinít, teo wáacni pínahdih ĩpĩ́ bidcan caá. Obohjeéhtih, ‘Wã yéejatdih jĩ́gahnit, wã tʉ́ʉt nʉʉ́míhna caá’, niíj jenah joinít caá teo wáacni pínahdih ĩ bidip. ‘Jwiít yeejépwã caá’, niíj jenah joinítdihjeh teo wáacadih wã jʉ̃ʉ́wʉ́p be, ĩ yéej chãjatdih cádahnit, tʉ́iniboodíh ĩ tʉ́ʉt nʉʉmát pínah niijná. Dios naáwátdih naóh yapani ã niíj daacátjidih yeebdíh jéihyat caá náahap. ‘ “Nʉñʉ́pwãdih ñi mao cáo wʉ̃hatdih weém wã náahcan caá. Obohjeéhtih, bitadih ñi jĩ́gah en teo wáacatdih caá yeebdíh wã náah yacap”, Dios ã niijná caá’, ãt niíj daacáp tajĩ.Caán ded pah ã daacátjidih jéihyat tʉ́ʉt niijná, ñi jwʉ́ʉb bohénaá. Caán ã daacátji pah, jĩ́gah ennit, weém cã́acwãdih teo wáacadih wã jʉ̃ʉ́wʉ́p be, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tʉ́ttimah, Juan Daabáni ã bohénitboó jwĩ pebh jʉinít, nin pah Jesúsdih ĩ niíj ʉʉ́bh joyóp jĩ: —Jwiít Juan ã bohénit, jwĩ nʉowã ĩ wʉtat pah jwĩpĩ́ jeémp jwʉhcan caá. Fariseowãbʉt biíc yoobó ĩpĩ́ chãjna caá. ¿Dépanih tigaá ma bohénitboó páantjeh ĩ jeémp? Jesúsdih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","—Nin pah caá ã jʉmʉp: Téihya chéoni ã nʉmah jeémpnit biícdih ã jʉm jwʉhʉchah, jĩ́gahcan, ĩpĩ́ tʉ́i wẽi jeémpna caá. Obohjeéhtih, caán téihya chéonidih bita ĩ ʉb bejat tʉ́ttimah, jĩ́gahnit, ĩta jeémp jwʉhcan tagaá. Weém caán téihya chéoni panihni wã jʉmna caá. Pánihat pah tigaá wã bohénit wãjeéh jʉmna, wẽinit, páantjeh ĩ jeémpna caá. Obohjeéhtih, bita weemdíh ĩ ʉb bejat tʉ́ttimah, wã bohénitjeéh wã wihcah, caán láa jĩ́gahnit, ĩ jeémp jwʉhcan niít, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pánihna, ded pah jwĩ nʉowã ĩ wʉtatji ã́ih jáap bohéátjĩh fariseowã ĩ widíhichah enna, Jesús queétdih nin pah ã jwʉ́ʉb niíj bohénap jĩ: “Jáap yégueh chóo chocca naáh chóojĩh máa yégueh chóodih nah wai bʉ́ʉdhdat ã náahcan caá. Páant ñi chãjachah nihna, caandíh ñi chocat tʉ́ttimah, jiínt bejna, máa chóodih chah ãta yewa tagaá. Páant tigaá jwĩ nʉowã ĩ naáwátjidih wĩ́ih jáap bohéátjĩh wid naóhcat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pánihat dée, pah jwʉhcanni iguíh macdih nʉñʉ́p chóojĩh ĩ chãjniji máa wʉh wʉʉ́hdih yáacat ã náahcan caá. Páant ñi yáacachah nihna, iguíh mac pahna, máa wʉh wʉʉ́h jéih yʉ́ʉhcan, ãta yewah bej tagaá. Páant ã yewechah, chénat pah ãta bʉʉd tágaá. Pánihna, jáap macdih, jáap wʉh wʉʉ́hboó yáacat caá náahap. Páant ñi yáacachah, iguíh mac, caandíh yáacni chóobʉt ã tʉ́i jʉmbipna caá. Pánihat pah, wĩ́ih jáap bohéát jwĩ nʉowã ĩ naáwátjijĩh wid naóhcat caá náahap”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wĩ́ih mʉʉ́boó páantjeh jwĩ jʉmʉchah, jwiít judíowã jwĩ míic wáacat mʉʉdíh en daonít ĩ maáh ã waád jʉyʉ́p jĩ. Waád jʉinít, Jesús pebh bódicha caj yoh ñajnit, nin pah ã niijíp jĩ: —Wã nʉʉ́m jáantjeh mi wʉnah bejep be. Obohjeéhtih, caántdih ma teo jã́ha booaat tʉ́ʉt niijná, wãjeéh ma jʉ̃ʉ́wʉ́. Páant ma teo jã́hanachah, mi jwʉ́ʉb boobipna caá, Jesúsdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Páant ã niijíchah joinít, Jesús wĩ́ih mʉʉ́boó jeémp chʉ́ʉdniji, ñah ñʉhnit, ãjeéh ã bac bejep jĩ. Jwiít ã bohénitbʉt ĩjeéh jwĩ bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pánih bejnit, namádih jwĩ bejechah, cã́acwã cãtíh biíh wili wʉnnih mit jʉmʉp tajĩ. Caánt doce jópchi mácanihat panihat wʉnnih, “Jesúíh yégueh chóodihjeh jʉibí teona, wã boobipna caá”, mit niíj jenah joyóp wʉt jĩ. Páant niíj jenah joinít, Jesús tã́ahmant jʉ̃óhnit, ã́ih yégueh chóo yapatbitdih mit jʉí tewep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Páant mi jʉí tewatdih jéihna, tac pʉ́ʉd ennit, Jesús caántdih nin pah ã niijíp jĩ: —Nʉʉmʉ́, ma weñeé. Weemdíh tʉ́i jenah joinít, ma boona caá, ã niijíp jĩ. Páant ã niijíchahjeh, mit boonap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tʉ́ttimah, jwiít Jesús biícdih maáíh mʉʉná jwĩ waád jʉibínap jĩ. Pánih waád jʉibínit, chío póojnitdih, dawá ñaác jʉ̃inítdihbʉt jwĩ enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Páant ĩ jʉñʉ́chah ennit, Jesús queétdih nin pah ã niijíp jĩ: —Yeéb ñi bac bejeé. Mi wʉncan caá. Ʉ̃ona caá mi chãjap, ã niijíp jĩ. Páant ã niijíchah joinít, “Nih yáana caá ã chãjap”, niijnít, cã́acwã caandíh ĩ dehwep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pánihna, queét ĩ bac bejat tʉ́ttimah, wʉnnih pebhna waad béjnit, miíh téihyadih Jesús ãt tewep wʉt jĩ. Páant ã tewechahjeh, boonit, mit ñah ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jóocmant ñʉhnit caántdih ã booaat doonádih joinít, caán tʉ́tchidih moondíh ĩt naóh peetép tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Caanjĩ́h jʉmnitji jwʉ́ʉb jibidih jwĩ bejechah, chénewã jéih encannit neoná jwiítdih pée bejnit, nin pah ĩ niíj ej ñaacáp jĩ: —¡David jʉima, Dios ã wahni, jwiítdih ma jĩ́gah eneé! ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Páant ĩ niíj ej ñaacáchah, jwiít Jesús biícdih biíh mʉʉ́boó jwĩ waad béjep jĩ. Páant jwĩ waad béjechah, queét jéih encannitbʉt ĩ ñʉʉ́n waád jʉyʉ́p jĩ. Páant ĩ waád jʉyʉ́chah ennit, Jesús queétdih nin pah ã niijíp jĩ: —‘Jwiítdih ã jéih booami nacaá’, ¿weemdíh ñi niíj jenah joí niít? ã niijíp jĩ. —Páant tigaá jwĩ niíj jenah joyóp, caandíh ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Páant ĩ niíj jepahachah joinít, ĩ́ih quíibdih teo jã́hanit, nin pah ã niijíp jĩ: —‘Páant ã chãjbipna caá’, ñi niíj jenah joyát pahjeh tigaá wã chãjbip, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Páant ã niijíchahjeh, ĩ jéih enep jĩ, bʉca. Pánih booanit, Jesús nin pah queétdih ã jwʉ́ʉb niijíp jĩ: —Weém bʉʉtéh yeebdíh wã booaatdih bitadih ñi naóhca bojoó, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Páant ã niijíchah yʉhna, bac bejnit, queétdih ded pah ã booaatjidih nihat pebhboó ĩt naóh peetép tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Páant ĩ bac bejechah, Jesús pebh nemép jʉmnidih bita ĩ ñahwat ʉb waád jʉyʉ́p jĩ. Caán nemép caandíh ãt jéih wéheat tʉ́ʉtcap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Páant ĩ ʉb jʉyʉ́chah ennit, Jesús nemépdih ã bacat tʉ́ʉtʉp jĩ. Páant ã bacat tʉ́ʉtʉchahjeh, jéih wéhecanniji ã jwʉ́ʉb wéhenap jĩ. Caandíh ennit, nihat ĩ en wʉ́hi bejep jĩ. —¡Nin pah yapatdih nihat jwiít Israel baácdih moón jwĩpĩ́ encan jĩ! ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Obohjeéhtih, fariseowã mácah ĩ míic niíj wéhenap jĩ. —Nemépwã ĩ maáh ã wẽpatjĩh caá nemépwãdih ã bacat tʉ́ʉtʉp, ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pánihat tʉ́ttimah, nihat botoni tʉ́tchina, dahwani tʉ́tchinadihbʉt bohé jibidih bejna, Jesús jwiítdih ã nʉmah bejep jĩ. Tʉ́tchina yoobó naóh jib bejna, jwiít judíowã jwĩ míic wáacat mʉʉná waadnít, Jesús ãpĩ́ bohénap jĩ. Dios ã maáh jʉmat tʉ́ini doonádih naóhnit, nihat caanjĩ́h moón tʉbʉ́p chʉ̃ʉ́hnitdihbʉt ãpĩ́ booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pánih bejna, dawá cã́acwã ovejawãdih en daoní wihcat pah yeejép yapnit, moh yéejnit ĩ jʉmʉchah ennit, Jesús queétdih bʉ́dí ãt jĩ́gah enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pánih jĩ́gah ennit, jwiít ã bohénitdih nin pah ã niijíp jĩ: —Jóo dajat láa bʉ́dí tewat ã jʉmʉchah yʉhna, teonitboó daocánnitjeh ĩ jʉmna caá. Pánihat pah, tʉ́ini doonádih joinít pínah dawá ĩ jʉmʉchah yʉhna, queétdih naóhnit pínahboó daocánnitjeh ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pánihna, tʉ́ini doonádih chah dawá bohénitdih ã wahat pínah niijná, Diosdih ñi ʉʉ́bʉ́, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tʉ́ttimah, jwiít doce ã bohénitdih bid bojnit, nemépwãdih bacaat pínah wẽpat, nihat wʉnnitdih booaat pínah wẽpatdihbʉt jwiítdih ã wʉ̃hʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nin caá jwiít Jesús ã bohénit, ã naáwát tʉ́ʉtnit pínah jwĩ wʉ̃t: Simón ã jʉmʉp jĩ. Caandíh Pedro Jesús ã wʉ̃t bʉ́ʉdhdʉp jĩ. Ã ʉ́ʉd Andrésbʉt ã jʉmʉp jĩ. Santiago, ã ʉ́ʉd Juanjĩhbʉt ĩ jʉmʉp jĩ. Queét chénewã Zebedeo weh ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, weém Mateobʉt jwĩ jʉmʉp jĩ. Weémboó Romanowã ĩ maáta ĩ ʉʉ́bát tʉ́ʉtni dinerodih ʉʉ́bh wʉ̃hni wã jʉmʉp jĩ. Biíh Santiago, Alfeo wʉ̃ʉ́hbʉt ã jʉmʉp jĩ. Tadeo, Lebeo ĩ niíj wʉ̃t bʉ́ʉdhnibʉt ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Biíh Simón, Celote wʉ̃t jʉmni poómpdih bóobʉt ã jʉmʉp jĩ. Judas Iscariote, Jesúsdih eníhcannitdih dʉó wáini pínahbʉt ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jwiít doce ã bohénitdih ã wẽpatdih wʉ̃h, biíh tʉ́tchinaboó wahna, ded pah jwĩ chãjat pínahdih nin pah Jesús jwiítdih ã niíj naáwáp jĩ: “Judíowã nihcannit pebhna ñi bejca bojoó. Samaria baácboobʉ́t ñi bejca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Diosdih jéihcannit jʉmna, bʉʉdnít ovejawã panihnit ĩ jʉmʉchah, judíowã pebhboojéh ñi bejeé. ");
INSERT INTO cbv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‘Dios maáh ã jʉmatdih ã jʉ́ʉtat pínah bahnijeh ã jʉdhna caá’, queétdih ñi niíj naáwá. ");
INSERT INTO cbv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pánih naóhna, bácah moópnit, dawá tʉbʉ́p chʉ̃ʉ́hnit, wʉnah bejnitdihbʉt ñi booanaá. Nemép caolih jʉmnitíh bácahmant nemépwãdih ñi bacanaá. Páant ñi chãjat pínah wẽpatdih yeebdíh wã wʉ̃hna caá. Jíib náahcanjeh yeebdíh wã wʉ̃hat pah mʉntih, yeebbʉ́t biíc yoobó jíib náahcanjeh cã́acwãdih ñi teo wáacá. ");
INSERT INTO cbv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Pánih bejna, dinerodih ñi ʉb bejca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wʉh wʉʉ́h, tʉ́ʉt nʉʉmát pínah camisa, zapatos ʉb bejcan, íoh cajat nahdihbʉt ñi ʉb bejca bojoó. Ñi dʉwát chóojeh ñi dʉo béjeé. Ñi bohénit pínahboó yeebdíh ĩ nʉmah jeémpbipna caá. Ñi dʉoní chóo ã moopóchah, queétboó ñi tʉ́ʉt nʉʉmát pínah chóodihbʉt ĩ wʉ̃hbipna caá. Queétdih ñi teo wáacat jíib, páant caá yeebdíh ĩ chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Caán tʉ́tchina jʉibínit, caán tʉ́tchidih jʉm jwʉhna, yeebdíh wẽi jwãáhnitíh mʉʉdíhjeh ñi chão jwʉ́hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ĩ́ih mʉʉná waad béjnit, ‘Dios ã tʉ́yat ñijeéh ã jʉmʉ naáh’, caán mʉʉdíh moondíh ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Páant ñi niijíchah, tʉ́init ĩ jʉmat jíib, Dios ã tʉ́yat ĩjeéh ã jʉmbipna caá. Obohjeéhtih, tʉ́icannit ĩ jʉmʉchah, páant ñi niijíchah yʉhna, Dios ã tʉ́yat ĩjeéh ã wihcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yeebdíh náahcan, ĩ joííhcah, caán mʉʉmánt ñi bac bejeé. Bac bejnit, queétdih Dios ã yohat pínahdih jʉ́ʉtat tʉ́ʉt niijná, ñíih zapatosdih tóo dʉgnit, caán jʉmni becchídih ñi péoh mao yoh jéenanaá. Pánihna, caán tʉ́tchidih moón yeebdíh ĩ náahcah, biíc yoobó mʉntih queétdihbʉt ñi chãj jʉ́ʉtʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yoobópdih yeebdíh wã naóhna caá. Peéh chãjni yeó jáapdih Sodoma tʉ́tchidih moón, Gomorra tʉ́tchidih moondíhbʉt Dios bʉ́dí ã peéh chãjbipna caá.Obohjeéhtih, queétdih ã peéh chãjat chah, yeebdíh náahcannitboodíh ã peéh chãjbipna caá”, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Weemdíh ñi tʉ́i joyoó! Yeéb ovejawã panihnitdih jiowã́ panihnit pebhboó wã wahna caá. Pánihna, jopwã pah tac behcannit, maiwã pah ñi tʉ́i yap náhninaá. ");
INSERT INTO cbv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","¡Ñi tʉ́i chãja chaáh! Yeebdíh eníhcannit ñi maátadih ĩ wʉ̃hbipna caá. Jwiít judíowã jwĩ míic wáacat mʉʉ́boó waadnít, yeebdíh ĩ pʉ̃ibipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wĩ́ihwã ñi jʉmat jíib, caán tʉ́tchinadih moón ĩ maáta pebhna, chah wẽpnit maáta pebhnabʉt yeebdíh ĩ ʉb bejbipna caá. Caanná ĩ ʉb bejechah, queét maátadih, judíowã nihcannit maátadihbʉt wĩ́ih tʉ́ini doonádih ñi naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Páant maátadih ĩ wʉ̃hʉchah, ‘Ded pah wã niiját pínahdih wã jéihcan niít’, ñi niíj jenah joicá bojoó. Yeebdíh ĩ ʉʉ́bh joyóchahjeh, ñi niiját pínahdih Dios yeebdíh ã jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Páant ã jéihyanachah, queétdih jepahna, yeéb ñi jenah joyátjĩhjeh ñi jepahcan niít. Dios jwĩ íip ã jenah joyátdih Tʉ́ini Espírituboó yeebdíh ã naáwát tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Caán láa, det wĩ́ihwã ĩ jʉmat jíib, biíc weh jʉmna yʉhna, maátadih naóh yacnit, ã déedih ã mao yohat tʉ́ʉtbipna caá. Ĩ mána ĩ wehdih, ĩ wehboó ĩ mánadihbʉt ĩ mao yohat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pánihna, yeéb wĩ́ihwã ñi jʉmat jíib, nihat yeebdíh ĩ eníhcan niít. Páant ĩ eníhcah, yeebdíh yeejép ĩ chãjachah yʉhna, weemdíh páantjeh ñi cádahcah, yeebdíh wã tʉ́i ʉbbipna caá, wã íip pebhboó ñi tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wĩ́ih tʉ́ini doonádih ñi naáwát jíib, biíc tʉ́tchidih moón yeebdíh ĩ yéej chãjachah, biíh tʉ́tchina jwei béjnit, caanjĩ́h moondíhbʉt ñi naáwá. Yoobópdih yeebdíh wã naóhna caá. Nihat Israel baácboó jʉmni tʉ́tchinadih moondíh ñi naóh beedáát pínah jã́tih, weém nihat cã́acwã ʉ́ʉd jeñé nin baácboó wã jwʉ́ʉb dei jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Jáap jéihni caandíh bohéni chah nihcan caá. Biíc yoobó teo wʉ̃hnibʉt ã maáh chah nihcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","‘Ded pah weemdíh bohénidih ã yapat pah mʉntih weemdíhbʉt ã yapbipna caá’, jáap jéihnidih niíj jenah joyát caá náahap. Teo wʉ̃hnibʉt ‘Ded pah wã maáhdih ã yapat pah mʉntih weemdíhbʉt ã yapbipna caá’, niíj jenah joyát caá náahap. Obohjeéhtih, ‘Wã maáh chah jʉmna, caandíh yeejép ã yapat pah weémboodíh ã yapcan niít’, niíj jenah joicát caá náahap. Weém mʉʉ́ mínah panihni, yeébboó wã pebh moon pánihnit ñi jʉmna caá. Pánihna, cã́acwã weemdíh ‘Beelzebú caá’, niijná, yeéb wĩ́ihwãdihbʉt biíc yoobó yeejép ĩ niijbípna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bʉʉ láa cã́acwãdih wĩ́ih tʉ́ini doonádih ñi naáwáchah yʉhna, joííhcan, bita ĩ encah, yeebdíh yeejép ĩ chãjbipna caá. Pánih yeejép ĩ bih chãjachah yʉhna, tʉ́ttimah nihat ĩ tʉ́i jéihbipna caá. Yeebdíh yeejép chãjnitdih ñi ʉ́ʉmca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pánihna, bʉʉ ded pah yeebdíhjeh wã bohéátdih tʉ́ttimah dawá cã́acwã cãtíh ʉ́ʉmcanjeh ñi naáwá. ");
INSERT INTO cbv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cã́acwã yeebdíh maona, ñíih bácahdihjeh ĩ mao yohna caá. Obohjeéhtih, ñíih caolihdih ĩ jéih maocan caá. Pánihna, det yeebdíh mao yohíhnitdih ñi ʉ́ʉmca bojoó. Obohjeéhtih, Diosboodíh caá ʉ́ʉmat náahap. Caanjéh tigaá ñíih bácahdih, ñíih caolihdihbʉt iiguípna ã jéih yohna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Chéne jwébehwãbit bainíbitjeh ĩ jíib jʉmʉchah yʉhna, biícbitdih Dios ã bʉʉdácan caá. Dios ã wʉtcah, caanbít ã wʉncan niít. ");
INSERT INTO cbv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ñíih waó yoócnadih Dios jenah en beedáni jʉmna, ded pah ñi jʉmatdihbʉt ã tʉ́i jéih beedána caá. Pánih jéih beedána, yeebdíh ã tʉ́i jéih en daoná caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jwébehwãdih ã oyat chah, yeébboodíh ã oina caá. Pánih oinit, ã en dawátdih jéihna, ñi náhni dahwaca bojoó”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ ‘Weém Jesúíh caá’, ded bitadih ã niijíchah, weembʉ́t caandíh ‘Caán wĩ́ih caá’, wã íip jeáboó jʉmnidih wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Obohjeéhtih, ded wĩ́ih jʉmna yʉhna, ‘Weém Jesúíh nihcan caá’, bitadih ã niijíchah, ‘Caán wĩ́ih nihcan caá’, weembʉ́t wã íipdih wã niijbípna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“¿Ded pah tigaá yeéb weemdíh ñi niíj jenah joí? ‘Ã́ih doonádih joinít, nihat cã́acwã tʉ́i biícdih ĩ jʉmbipna caá’, ¿ñi niíj jenah joí niít? Obohjeéhtih, pánihcan caá. Cã́acwã wã bohéátdih ĩ joyát tʉ́ttimah, biquína wã naáwátdih ĩ tʉ́i wẽi joyóchah, bitaboó caandíh jepahcan, queétdih ĩ en jʉ̃ihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Biquína behnit wã naáwátdih ĩ tʉ́i joyát jíib ĩ weh queétdih ĩ eníhcan niít. Behnit yaádh wã naáwátdih ĩ tʉ́i joyát jíib ĩ weh yatá queétdih ĩ eníhcan niít. Ĩ chʉdhna yaádh wã bohéátdih ĩ tʉ́i joyát jíib, ĩ weh áana yaádh queétdih ĩ eníhcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ded weemdíh jepahnidih ã déewã yoobát ĩ eníhbican nacaá. ");
INSERT INTO cbv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ded weemdíh ã oyat chah ã mánadih, ã wehdih oina, wĩ́ih nihcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pánihna, cruzboó wʉnna, yeejép wã yapat pínah pah, ded wĩ́ih ã jʉmat jíib yeejép ã yapbipna caá. Pánih yeejép yapatdih ʉ́ʉmnit, jweiná, wĩ́ih nihcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ded weemdíh tʉ́i jenah joicán, bií déedih en ñinahnit, ã náahatdihjeh chãjna, iiguípna ã bejbipna caá. Obohjeéhtih, ded ã́ih pínahdih jenah joicánjeh, wã weñat pínahdih chãjniboó páantjeh wãjeéh ã tʉ́i jʉmbipna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Det yeéb wĩ́ihwãdih tʉ́i náahna, weemdíhbʉt ĩ náahna caá. Pánihna, weemdíh tʉ́i náahni weemdíh wahnidihbʉt ã náahna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dios naáwátdih naóh yapani ã tewat jíib Dios caandíh ã tʉ́i chãjbipna caá. Ã naáwátdih naóh yapani ã jʉmʉchah enna, ded caandíh tʉ́i náahna, naóh yapanidih ã tʉ́i chãjat pah Dios caandíhbʉt biíc yoobó ã tʉ́i chãjbipna caá. Ded tʉ́ini ã jʉmat jíib, Dios caandíh ã tʉ́i chãjbipna caá. Tʉ́ini ã jʉmʉchah ennit, biíhboó caandíh tʉ́i náahna, tʉ́inidih Dios ã tʉ́i chãjat pah, caandíh náahnidihbʉt biíc yoobó ã tʉ́i chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ded wĩ́ih moh yéejni ã jʉmʉchah enna, caandíh ã babhbat pínah, bainí mahjeh ã wʉ̃hʉchah yʉhna, ã teo wáacatbit jíib, Dios caandíhbʉt ã tʉ́i chãjbipna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Páant jwiít ã bohénitdih ã naóh péaat tʉ́ttimah, caán baácdih bóo tʉ́tchinadih moondíh Jesús ã́ih tʉ́ini doonádih bohénadih ã bejep jĩ. Jwiítbʉt biíh tʉ́tchinadih moondíh bohénadih jwĩ bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pánih bejnitji jwĩ jwʉ́ʉb jʉyʉ́chah, Jesús ded pah ã chãjat doonádih Juan Daabáni nemat mʉʉ́boó jʉmni ãt joyóp tajĩ. Pánih joiníji ã bohénitdih Jesús pebhna ãt wahap tajĩ, caandíh ĩ ʉʉ́bh joí enat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Páant ã wahachah, jwĩ pebh jʉinít, nin pah Jesúsdih ĩ niíj ʉʉ́bh joyóp jĩ: —Juan jwiítdih nin pah ã niíj ʉʉ́bh joí enat tʉ́ʉtʉp be: ‘ “Wã tʉ́ttimah biíh ã jʉ̃óhbipna caá”, ¿wã niijníji niít meém? ¿Wã niijníji ma nihcah, biíhdih páñat náah niít?’ ã niijíp be, Jesúsdih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Páant ĩ niíj ʉʉ́bh joyóchah joinít, Jesús queétdih nin pah ã niíj jepahap jĩ: —Bʉʉ ded pah ñi joyátji, ñi enatjidihbʉt Juandih nin pah niíj naáwádih ñi bejeé: ");
INSERT INTO cbv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Jéih encannitji, jéih joicánnitji, jéih bejcannitjidihbʉt ã booana beé. Bácah moópnitji, wʉnah bejnitjidih yʉh bʉca ã booana beé.Moh yéejnitdih ã tʉ́i ʉbat pínah doonádihbʉt naóhna ã chãjap be. ");
INSERT INTO cbv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pánihna, “Ded weemdíh tʉ́i jenah joí cádahcannidih Dios ã wẽi enna caá”, Jesús ã niijíp be’, Juandih niíj naáwádih ñi bejeé, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Páant ã niijíchah joinít, Juandih naáwádih ĩ jwʉ́ʉb bejep jĩ. Páant ĩ jwʉ́ʉb bejechah, Juan ded pah ã jʉmatdih dawá jwĩjeéh péenitdih Jesús nin pah ã niíj naáwáp jĩ: “¿Dedédih enedih bej tigaá ñipĩ́ chãj, mʉʉ́ wihcapboó bejna? ¿Jiwi jeémp yílip déedih johlit ã joh jwejni panihnidih enedih ñi bejnit beé? Obohjeéhtih, Juan pánihcan beé. Det biáboó ĩ naáwáchah yʉhna, caánboó jweéhcanjeh, yoobópdih ãpĩ́ naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pánih jʉmnidih bidcan, ¿tʉ́ini yégueh dʉonídih enedih ñi bejnit beé? Obohjeéhtih, tʉ́ini yégueh dʉonít maátaíh mʉʉ́boó ĩpĩ́ jʉmna caá. Juanboó queét pah nihcan beé. ");
INSERT INTO cbv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pánih jʉmnidihbʉt bidcan, ¿Dios naáwátdih naóh yapanidih enedih bejnit beé ñi chãj? Páant tigaá Juan ã jʉmʉp. Bita naóh yapanit chah ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan ã jwíih naóh waáwát pínahdih jon jã́tih Dios naáwátdih naóh yapani nin pah ãt niíj naóh daacáp tajĩ: ‘Ã wʉ̃ʉ́hdih Dios nin pah ã niijíp be: “Ma jã́tih wã naáwátdih naóh waóhni pínahdih wã wahbipna caá, meémboó ma naáwáchah joinít, cã́acwã ĩ jepahat pínah niijná”, Dios ã niijíp be’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yoobópdih yeebdíh wã naóhna caá. Nihat bita chah Juan Daabáni ã jʉmna caá. Obohjeéhtih, páant ã jʉmʉchah yʉhna, Dios ã maáh jʉmʉpna ded oboh jʉmniboó Juan chah ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan ã bohé jwíih láa bʉʉ láana, Dios ã maáh jʉmʉpboó dawá ĩ waadát pínahdih bʉ́dí ĩ bidna caá. Pánih bidna, Diosdih tʉ́i jenah joinít, yeó jáap jʉmat pah chah dawá waadná caá ĩ chãjap. Obohjeéhtih, bitaboó páant ĩ waadátdih íijnit, queétdih ĩ jãhna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan ã jʉ̃ʉ́wát pínah jã́tih, nihat Dios naáwátdih naóh yapanitboó daácna, Moisésbʉt daácna, Dios ã maáh jʉmat pínahdih ĩt naóh daacáp tajĩ. Juanbʉt caandíhjeh mʉntih ã naóh bohénap be. ");
INSERT INTO cbv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","‘Dios ã wahni ã jʉ̃ʉ́wát pínah jã́tih, Elías panihni ã jʉ̃óhbipna caá’, jon jã́tih ĩ niijní tigaá Juan ã jʉmʉp. Pánihna, ‘Yoobópdih tigaá Juan ĩ niijní Elías panihni ã jʉmʉp’, yeebdíh niíj jenah joyát caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ded molít jʉmna, ã tʉ́i joyó naáh! ");
INSERT INTO cbv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bʉʉ láa moón weemdíh jepahcannit nin pah ñi jʉmna caá: Yoahdih tíohnit wébít pah caá ñi jʉmʉp. Tíoh chʉ́ʉdnit, nin pah ĩpĩ́ niíj míic jʉ̃ihna caá: ");
INSERT INTO cbv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Jwĩ pelat póoj tíhwichah yʉhna, yeébboó ñi bʉ́ʉdíhcan beé. Wʉnnitdih jwĩ jʉ̃í tíhwichah yʉhna, ñi jʉ̃í wáaquíhcan beé’, ĩ niíj míic jʉ̃ihna caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Páant ĩ chãjat pah, yeebbʉ́t biíc yoobó ñipĩ́ chãjna caá. Juan Daabáni cã́acwãjeéh jeémpcan, poonidihbʉt ãpĩ́ babhcap jĩ. Páant ã chãjcah enna, ‘Nemép caolih jʉmni caá’, niíj jʉ̃ihnit, ã bohéátdih ñi joííhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Obohjeéhtih, weém, nihat cã́acwã ʉ́ʉd jeñé, cã́acwãjeéh jeémpnit, wãpĩ́ babhna caá. Páant wã chãjachah ennit, ‘Eneé. Nin bʉ́dí jeémpni, babh máihni caá ã jʉmʉp. Romanowã ĩ ʉʉ́bát tʉ́ʉtni nʉ́odih ʉʉ́bh wʉ̃hnit, yeejép chãjnit biícdih ãpĩ́ pej jʉmna caá’, niíj jʉ̃ihnit, weemdíhbʉt ñi jepahcan caá. Páant niíj jʉ̃ihna, wébít pah caá ñi jʉmʉp. Obohjeéhtih, ded pah Dios ã wʉtat pah wã tʉ́i chãjachah enna, ã jenah joyát yoobópdih ã jʉmatdih ñi jéihbipna caá”, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tʉ́ttimah, biíh tʉ́tchinadih moón caandíh ĩ jepahcatji jíib, Jesús queétdih ã jʉ̃ihñʉp jĩ. Caán tʉ́tchinadih moón biíh tʉ́tchina chah Dios ã wẽpatjĩh Jesús ã chãj jʉ́ʉtʉp yʉh jĩ. Páant ã chãj jʉ́ʉtʉchah yʉhna, ĩ yéejatdih ĩ cádahcap jĩ. Páant ĩ cádahcatji jíib nin pah queétdih ã niíj jʉ̃ihñʉp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Corazín tʉ́tchidih moón yeejép ñi yapbipna caá! ¡Betsaida tʉ́tchidih moonbʉ́t yeejép ñi yapbipna caá! Ñíih tʉ́tchinadih Dios ã wẽpatjĩh bʉ́dí wã chãj jʉ́ʉtʉp yʉh be. Páant ã wẽpatjĩh wã chãj jʉ́ʉtʉchah enna, Tiro tʉ́tchidih moón, Sidón tʉ́tchidih moonbʉ́t ĩ yéejatdih cádahnit, tʉ́iniboodíh ĩta tʉ́ʉt nʉʉm tágaá. Jĩ́gahna dʉwát chóo dʉonít, ĩ jĩ́gahatdih jʉ́ʉtna, tʉʉ jõóhjĩh ĩta míic waáh tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nin pah yoobópdih yeebdíh wã naóhna caá: Peéh chãjat yeó jáapdih Dios Tiro tʉ́tchidih moón, Sidón tʉ́tchidih moondíhbʉt ã peéh chãjat chah yeébboodíh bʉ́dí ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yeebbʉ́t Capernaum tʉ́tchidih moón, ‘Jwiít chah jʉmnit jwĩ jʉmna caá’, ¿ñi míic niíj jenah joí niít? Páant niíj jenah joiná yʉhna, oboh jʉmnit ñi jʉmbipna caá.Ñíih tʉ́tchidih Dios ã wẽpatjĩh dawá láa wã chãj jʉ́ʉtʉchah yʉhna, yeéb weemdíh ñi jepahcap be. Sodoma tʉ́tchijidih Dios ã wẽpatjĩh páant wã chãj jʉ́ʉtʉchah nihna, caán tʉ́tchidih moón ĩ yéejatdih ĩta cádah tagaá. Páant ĩ cádahachah, caán tʉ́tchi páantjeh ãta jʉm tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yeebdíh yoobópdih wã naóhna caá. Peéh chãjat yeó jáapdih Dios Sodoma tʉ́tchidih moondíh ã peéh chãjat chah yeébboodíh bʉ́dí ã peéh chãjbipna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Caán láa nin pah Jesús jwĩ íipdih ã niíj ʉʉ́bʉ́p jĩ: “Paá, meém nihat baácdih moón, nihat jeádih moondíhbʉt ĩ maáh ma jʉmʉchah, meemdíh bʉ́dí wã wẽina caá. ‘Jwiít tʉ́i jéihnit caá’, niijnítdih wã bohéátdih ma beh joyát tʉ́ʉtcap be. Obohjeéhtih, jéih jwʉhcannitboodíh mapĩ́ beh joyána caá. Páant ma chãjachah, ‘Tʉ́ina caá, Paá’, meemdíh wã niijná caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Páant tigaá, Paá, mapĩ́ wẽi chãjap”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Páant niíj ʉʉ́bh péanit, cã́acwãboodíh nin pah Jesús ã niíj naáwáp jĩ: “Dios wã íip nihat ã wẽpat biíc yoobó weemdíhbʉt ã wʉ̃hʉp be.Ded pah wã jʉmatdih wã íipjeh caá ã jéihyep. Biíh jéihni wihcan caá. Pánihna, ded pah wã íip ã jʉmatdihbʉt weemjéh caá wã jéihyep. Det wã ñíonitdihbʉt wãpĩ́ bohéna caá. Jwiítjeh caá caandíh jwĩ jéihyep. ");
INSERT INTO cbv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yeéb nihat teo wẽejnít, chodóp dʉonít panihnit wã pebh ñi jʉ̃ʉ́wʉ́. Páant ñi jʉ̃ʉ́wʉ́chah, yeebdíh wã chooát tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Weém biícdih tʉ́i bejnit, wã naáwátdih jenah joinít, ñi wẽi jepahaá. Weém cã́acwãdih jĩ́gah ennit, oboh jʉmni pah queétdih tʉ́i teo wáacni wã jʉmna caá. Páant wã jʉmatdih en yacnit, wã naáwátdih tʉ́i jenah joiná, tʉ́i choonít panihnit ñi jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pánih choonít jʉmna, wã weñat pínahdih ñi chãjachah, yeebdíh ã bʉocan niít. Bʉ́dí chodat panihnidih dʉwát tʉ́ʉtcan, ñi bʉʉjáca naáhdih yeebdíh wã wʉtcan niít”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Biíh chooát yeó jáapdih Jesús jwiítdih bohé bejna, trigo wáapdih ã nʉmah chóop yap bejep jĩ. Pánih bejna, jwiít ã bohénit nʉʉgʉ́p wʉnna, trigodih jwĩ ʉ́ʉc jeémép jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Páant jwĩ ʉ́ʉcʉchah enna, jwĩjeéh bejnit fariseowã íijnit, Jesúsdih nin pah ĩ niíj jʉ̃ihñʉp jĩ: —Jwiítdih ma joi jwʉ́hʉʉ́. ¿Dépanih tigaá jwĩ chooát yeó jáapdih yʉhna, ma bohénit ĩ teo? Pánih teona, Dios ã wʉtatdih yap yohna caá ĩ chãjap, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Páant ĩ niijíchah joinít, “Wã bohénit ĩ yap yohcan caá”, niiját tʉ́ʉt niijná, Jesús queét fariseowãdih nin pah ã niíj bóod chʉñʉp jĩ: —Davidji ã pej jʉmnitjĩh nʉʉgʉ́p wʉnna, Dioíh mʉʉná waadnít, sacerdotewã Diosdih ĩ wʉ̃hniji pandih ĩt jeémép wʉt jĩ. Obohjeéhtih, caán pan sacerdotewãjeh ĩ jeémát pínah ãt jʉmʉp wʉt jĩ. Dios wʉtna, bitadih caán pandih ãt jeémát tʉ́ʉtcap wʉt jĩ. ¿Davidwã páant ĩ chãjatjidih Dios naáwátdih ĩ daácni nʉ́odih ñi bohécannit jĩí? Caán pandih ĩ jeéméchah yʉhna, ‘Ñi tʉ́i chãjcan beé’, Diosboó ãt niijcáp wʉt jĩ. Pánihat pah, bʉʉ nin trigodih ʉ́ʉc jeémpna, wã bohénitbʉt Diosdih ĩ yap yohcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nindihbʉt ñi náhninaá: Dioíh mʉʉ́boó teonit sacerdotewã jwĩ chooát yeó jáapdih ĩpĩ́ choocán caá. Páant ĩ choocán yʉhna, Dios ã wʉtatdih yap yohnit nihcan caá. ¿Páant Moisés ã wʉtatjidih ñi bohécannit jĩí? ");
INSERT INTO cbv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yeebdíh nin pah niíj naóhna caá wã chãjap: Dioíh mʉʉdíh wẽina, caán mʉʉ́boó teonit ĩ choocáh enna yʉhna, ‘Ã tʉ́ina caá’, ñipĩ́ niijná caá. Obohjeéhtih, caán mʉʉdíh ñi weñat chah weémboodíh weñat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios naáwát nin pah ã niijná caá: ‘Nʉñʉ́pwãdih mao cáo wʉ̃hat wã náahcan caá. Obohjeéhtih, bitaboodíh ñi jĩ́gah en teo wáacat caá wã náahap’, Dios ã niijná caá.Páant ã niijátjidih beh joiná nihna, wã bohénitdih ñita jʉ̃ihcan tagaá. Queét caandíh ʉ́ʉc jeémpna, yap yohna ĩ chãjcan caá. Pánihna, queétdih ñi jʉ̃ihñat ã tʉ́ican caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nihat cã́acwã ʉ́ʉd jeñé, weemjéh tigaá chooát yeó jáapdih cã́acwã ded pah ĩ chãjat pínahdih wʉtni wã jʉmna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Páant niíj péa, bejnit, jwĩ míic wáacat mʉʉná jwiítdih Jesús ã nʉmah waád jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Caanjĩ́h téihya ágahni ã jʉmʉp jĩ. Pánihna, fariseowãboó Jesúsdih naóh yacat tʉ́ʉt niijná, caandíh nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —¿Ma jenah joyóchah, jwĩ chooát yeó jáapdih Dios ã booaat tʉ́ʉt niít? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—¿Ñíih oveja íitboó ã bʉʉg yácachah ennit, ñita jwʉ́ʉb ʉbcan taniít? ");
INSERT INTO cbv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Obohjeéhtih, oveja chah caá cã́acboó ã jíib jʉmʉp. Pánihna, chooát yeó jáapdih yʉhna, cã́acwãdih Dios ã teo wáacat tʉ́ʉtna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Páant niíj péanit, caán téihya ágahnidih nin pah ã niíj wʉtʉp jĩ: —Míih téihyadih ma yoo dʉwʉʉ́, ã niijíp jĩ. Páant ã niijíchah joinít, ã́ih téihyadih ã yoo dʉwʉ́p jĩ. Páant ã yoo dʉwʉ́chahjeh, ã́ih téihya ã tʉ́yah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Páant Jesús ã booanachah ennit, fariseowã ĩ íij bac bejep jĩ. Pánih íij bac bejnit, ded pah Jesúsdih ĩ mao yohat tʉ́ʉtat tʉ́ʉt niijná, ĩt míic wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pánihna, fariseowã caandíh ĩ mao yohíhatdih jéihna, Jesús jwiítdih biáboó ã nʉmah bejep jĩ. Páant jwĩ bejechah ennit, dawá jwiítdih ĩ péenap jĩ. Páant ĩ péenachah, nihat ĩ ʉb jʉ̃óhnit wʉnnitdih Jesús ã booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pánih booanit, ded pah ã chãjatdih bitadih ã naáwát tʉ́ʉtcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Queétdih booana, jon jã́tih Isaías nin pah ã daacátji biíc yoobó ã chãjap jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dios nin pah ã niijná caá: ‘Nin wã wahni, wã oini, weemdíh ã tʉ́i teo wʉ̃hʉchah, bʉ́dí wã wẽina caá. Caandíh Tʉ́ini Espíritudih wã wʉ̃hbipna caá, wã wẽpat biíc yoobó caanbʉ́t ã bíbohat pínah niijná. Pánih jʉmnit, yoobópdih wã chãjat doonádih nihat baácdih moondíh ã naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pánih naóhna, míic jʉ̃ihcan, bitadih íijacan, tʉ́inijeh ã naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Moh yéejnit panihnitdih jʉ̃ihcanjeh, ã tʉ́i teo wáacbipna caá. Bita jĩ́gahnitdihbʉt ã weñabipna caá. Pánih jʉmna, cã́acwã ĩ míic yéej chãjatdih ámohnit, tʉ́inijeh ã chãjat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ã́ih tʉ́ini doonádih joinít, nihat baácdih moón caandíh ĩ tʉ́i jepahbipna caá. Páant ĩ tʉ́i jepahachah, queétdih ãjeéh ã tʉ́i jʉmat tʉ́ʉtbipna caá’, Dios ã niijná caá”, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Biíh yeó jáap nemép jʉmnidih jwĩ pebhna cã́acwã ĩ ʉb jʉyʉ́p jĩ. Nemépwã caandíh enat tʉ́ʉtcan, ĩt wéheat tʉ́ʉtcap tajĩ. Páant ĩ ʉb jʉyʉ́chah, Jesús caandíh ã booanap jĩ. Páant ã booanachahjeh, ennit, ã wéhenap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pánihatdih ennit, nihat ĩ wʉ́hi bejep jĩ. Pánih wʉ́hinit, “¿Nin David jʉima, Dios ã wahni, jwĩ maáh pínahna niít?” ĩ míic niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Obohjeéhtih, páant ĩ niijíchah joinít, fariseowãboó nin pah ĩ niijíp jĩ: “Nihcan caá. Nemépwã ĩ maáh Beelzebú ã wẽpatjĩhjeh caá nemépwãdih ã bacanap”, ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Páant ĩ niíj jenah joyátdih jéihnit, Jesús queétdih nin pah ã niíj naáwáp jĩ: “Det biíc baácdih moonjéh yʉhna, míic maona, ĩta wʉn beedáh bej tagaá. Det tʉ́tchidih moón biícwã yʉhna, míic maona, queétbʉt ĩta jweí peét bej tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pánihna, Satanás, nemépwã ĩ maáh ã́ihwãdih ã bacanachah, biíc yoobó mʉntih ãta yap tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Obohjeéhtih, ‘nemépwãdih bacanit, ĩ maáh ã wẽpatjĩh ã wʉtna caá’, ñi niiját yoobópdih ã jʉmʉchah nihna, ñijeéh jʉmnitboó ¿déhe ã wẽpatjĩh tigaá ĩpĩ́ baca? Páant ĩ bacanachah ennit, ‘Ĩ tʉ́i chãjna caá’, ñipĩ́ niijná caá. Pánihna, weém páant wã bacanachah ennit, ‘Ã tʉ́i chãjcan caá’, ñi jéih niijcán caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dios ã wẽpatjĩh nemépwãdih wã bacanachah, Dios ã maáh wẽpat ñi cãtíh ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nin pahbʉt ã jʉmna caá: Wẽpép newéíh mʉʉná ded nʉʉ́míhna yʉhna, ã jéih waadcán caá. Obohjeéhtih, caandíh chéo péanit, ã́ih bií déedih ã jéih ʉbna caá”, Jesús á niijíp jĩ. Páant niijná, nin pah niíj naóhna ãt chãjap wʉt jĩ: Nemépwã ĩ maáh wẽpép ã jʉmʉchah yʉhna, Jesúsboó caandíh chah wẽpni jʉmna, ã jéih yap yohna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ded wãjeéh teocanni, weemdíh en jʉ̃ihni, nemépwã ĩ maáhjeéh ã jʉmna caá. Pánih jʉmna, weemdíh jepahíhnitdih ñʉʉn yóhna caá ã chãjap. ");
INSERT INTO cbv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Nin pah yoobópdih yeebdíh wã naóhna caá: Det yéej chãjna, Diosdih yeejép wéhena yʉhna, ĩ jwʉ́ʉb tʉ́ʉt nʉʉmʉ́chah, Dios ĩ yéejatdih ã yohbipna caá. Det weém nihat cã́acwã ʉ́ʉd jeñédihbʉt yeejép wéhenit, ĩ tʉ́ʉt nʉʉmʉ́chah, yeejép ĩ wéheatjidih Dios ã yohbipna caá. Obohjeéhtih, det Tʉ́ini Espírituboodíh yeejép ĩ wéhenachah, ĩ yéejatdih ã yohcan niít. Páant ĩ yéej chãjatdih quíib bʉʉdcán, Dios queétdih iiguípna ã wahbipna caá”, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ded máa nah tʉ́ini dahna ã quehechah ennit, tʉ́ini nah ã jʉmatdih ñi jéihna caá. Obohjeéhtih, biíh nah tʉ́icanni ã quehechah ennit, caan náh yeejép ã jʉmatdih ñi jéihna caá. Pánihat pah, cã́ac ded pah ã jʉmatdih jéihíhna, ã chãjatdih enat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yeéb maiwã panihnit tʉbit yeejépwã jʉmna, yoobópdih ñi wéhecan caá.Cã́acwã ded pah ĩ jenah joyát pah biíc yoobó ĩpĩ́ wéhena caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pánih jʉmna, ded tʉ́i jenah joiní ãpĩ́ tʉ́i wéhena caá. Obohjeéhtih, ded yeejép jenah joiníboó yeejép ãpĩ́ wéhena caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pánihna, Dios ã peéh chãj láa ded yeejép wéhenidih ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tʉ́i wéhenidih ‘Meém tʉ́ini caá’, Dios ã niijbípna caá. Obohjeéhtih, yeejép wéheniboodíh ‘Meemdíh peéh chãjat ã náahna caá’, ã niijbípna caá”, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Biíh láa mʉʉ́ diítboó jwĩ jʉmʉchah, biquína fariseowã, Moisés ã wʉtatjidih bohénitjĩh waád jʉinít, nin pah Jesúsdih ĩ niijíp yʉh jĩ: —Bohéní, jwiít cã́acwã jwĩ jéih chãjca naáhdih ma chãj jʉ́ʉtʉ́, meém Dios ã wahni yoobópdih ma jʉmatdih jwĩ jéihyat pínah niijná, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Páant ĩ niijíchah joinít, Jesús queét maátadih nin pah ã niíj jepahap jĩ: —Yeéb yeejépwã Diosdih náahcannit ñi jʉmna caá. Pánihnit jʉmna, Dios ã wẽpatjĩh ñipĩ́ chãj jʉ́ʉtat tʉ́ʉtna yʉh caá. Obohjeéhtih, yeebdíh páant wã chãj jʉ́ʉtcan niít. Dios naáwátdih naóh yapani Jonásjidih Dios ã wẽp chãjat pah mʉntih weemdíhbʉt chãjnit, ã wẽpat yeebdíh ã jʉ́ʉtbipna caá. Páant bóojeh ã wẽpat jʉ́ʉtat ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pánihna, Jonásjidih bʉ́dí queéj ã jeéméchah, biíc peihcanni yeó jáap ã́ih wʉdah diítboó ãt jʉmʉp wʉt jĩ. Pánihat pah weém nihat cã́acwã ʉ́ʉd jeñéboó wʉnnit, jeé íitboó ĩ yohat tʉ́ttimah, biíc peihcanni yeó jáap caánboó wã jʉmbipna caá. Pánihat tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃ʉ́wʉ́chah, Jonás ã yapatjidih náhninit, Dios ã wẽpatdih ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonás Nínive tʉ́tchidih moonjídih Dios queétdih ã peéh chãjat pínah doonádih ã naáwáchah, ĩ yéejatdih cádahnit, ĩt tʉ́ʉt nʉʉ́m beedép wʉt jĩ. Pánihna, cã́acwãdih ã peéh chãjat yeó jáapdih queét Nínive tʉ́tchidih moondíh Dios ã peéh chãjcan niít. Obohjeéhtih, Jonásji chah caá weém wã jʉmʉp. Páant wã jʉmʉchah yʉhna, yeébboó weemdíh ñi jepahcan caá. Páant ñi jepahcat jíib Dios yeebdíh bʉ́dí ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chóop yapapboó jʉmni baácdih moón ĩ maáh wili maáh Salomón tʉ́i jéihni ã jʉmat doonádih joinít, ã naáwátdih joyát tʉ́ʉt niijná, yʉʉ́pmant mit jʉ̃ʉ́wʉ́p wʉt jĩ. Obohjeéhtih, caán tʉ́i jéihni ã jʉmat chah weémboó wã jʉmna caá. Páant wã jʉmʉchah yʉhna, yeébboó weemdíh ñi joííhcan caá. Páant ñi joííhcat jíib cã́acwãdih ã peéh chãjat yeó jáapdih Dios yeebdíh bʉ́dí ã peéh chãjbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nemép ĩ bacaniji, mʉʉ́ wihcapboó jibna, ã jʉmat pínah biíh mʉʉ pánihnidih ã táoh bidna caá. Pánih bidna yʉhna, ã jéih bid jʉicán caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pánih bid jʉicán, ‘Weemdíh ĩ bacaniji mʉʉná wã jwʉ́ʉb bejbipna caá, páant mʉntih’, ã míic niíj jenah joiná caá. Páant niíj jenah joinít, ã jwʉ́ʉb jʉí enechah, ã́ih mʉʉjí tʉ́i tóodh ámohni panihni ã jʉmna caá. Caán cã́acboó ã tʉ́ʉt nʉʉmcáh, ã́ih jẽc páantjeh pãa lajni panihni ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Páant ã jʉmʉchah ennit, nemépboó bita siete ã chéenwã chah yeejép wʉtnitdih bid wáacnit, queétdih ã nʉmah waadná caá. Páant yeejép ĩ wʉtʉchah, ĩ waadní cã́ac chah yeejép chãjni ã jʉmbipna caá. Pánihat dée pah yeéb yeejépwãdih ã yapbipna caá”, Jesús cã́acwãdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Páant Jesús queétdih ã naáwát pónih, caandíh míic wéheat tʉ́ʉt niijná, ã íin ã ʉ́ʉdwã biícdih jóocmant ĩt jʉyʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Páant ĩ jʉyʉ́chah ennit, jwĩjeéh jʉmni Jesúsdih nin pah ã niijíp jĩ: —¡Ma eneé! Meemdíh míic wéheat tʉ́ʉt niijná, ma íin ma ʉ́ʉdwã biícdih jóocmant ĩ pã́ina caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","—Ma niiját tʉ́ina caá. Obohjeéhtih, ¿Dedh tigaá wã íin? ¿Det tigaá wã ʉ́ʉdwã? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Páant niijnít, jwiít ã bohénitdih jʉ́ʉtnit, nin pah ã niijíp jĩ: —Nit caá wã íin, wã ʉ́ʉdwã panihnit. ");
INSERT INTO cbv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Det wã íip Dios ã náahat pah chãjnitjeh wã ʉ́ʉd, wã jwan, wã íin panihnit ĩ jʉmna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Caán yeó jáapjeh mʉntih Jesús mʉʉ́ diítboó jʉmniji ã bac bejep jĩ. Pánih bac bejnit, íim jwẽ́ejna jwiítdih ã nʉmah dei bejep jĩ. Pánih dei bej, caanná jʉibínit, jwĩ chʉ́ʉdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Páant jwĩ chʉ́ʉdʉchah ennit, dawá cã́acwã ã pebh míic wáac jʉyʉ́chah, bʉ́dí jãáj chóodih waadnít, ã chʉ́ʉdʉp jĩ. Jwiítboó bita biícdih jwĩ ñʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ã jenah joyátjĩh queétdih bohéna, nin pah ã niíj naáwáp jĩ: “Biíc newé, waáh momodih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Páant ã waáh bojochah, biquí tíibna namádih ã bʉʉg ñájap yʉh be. Obohjeéhtih, waícanjeh jʉ̃óhnit, jwébehwã caán tíibnadih ĩ jeémp beedánap be. ");
INSERT INTO cbv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Biíh tíibna jeejíh yewéni baác jʉmʉpboó ã bʉʉg ñájap be. Pánih bʉʉg ñájnit, waícanjeh ã chíih jʉ̃ʉ́wʉ́p yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pánih chíihna yʉhna, yeó tʉbit ã chãhachah, ñeh bainíjeh jʉmna, ã diib téhah bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Biíh tíibna nemép óot cãtíh ã bʉʉg ñájap be. Pánih bʉʉg ñájnit, ã chíihichah, caán nemép óotnaboó caandíh ã chíih yap bejechah, momniboó mánahnit, ã wʉnah bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Obohjeéhtih, biíh tíibna tʉ́ini baácboó ã bʉʉg ñájap be. Pánih bʉʉg ñájna, chíihnit, ã tʉ́i quehep be. Pánihna, caánboó chíihni biquí wawánadih cien tíibna, biíh wawánadih sesenta tíibna, biíh wawánadih treinta tíibna ã jʉmʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Ded molít jʉmna, ã tʉ́i joyó naáh!” queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Páant ã niiját tʉ́ttimah, jwiít ã bohénit ã bohéátdih beh joicán, ã pebhna jʉibínit, nin pah jwĩ niíj ʉʉ́bh joyóp jĩ: —¿Dépanih tigaá cã́acwãdih bohéna, ma jenah joiní naáwátjĩhjeh mapĩ́ bohé? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Páant jwĩ niijíchah joinít, Jesús nin pah jwiítdih ã niíj jepahap jĩ: —Dios jwĩ maáh yoobát jʉmna, nihat cã́acwãdih ã teo wáacat pínah dooná, jwĩ déewã jon jã́tih moondíh ã jéihya jwʉhca naáh doonádih bʉʉ yeéb wã bohénitdih Dios ã jéihyaat tʉ́ʉtna caá. Obohjeéhtih, bitadih páantjeh ã jéihya jwʉhcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Det caán doonádih tʉ́i joinítdih chah ã jéihyabipna caá. Obohjeéhtih, det tʉ́i joicánnitboodíh bainí ĩ jéihyatdih ã dʉ́ʉc wáyat pah ã chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cã́acwã quíib wihcannit dée, ded pah ĩ enatdih ĩ beh encan caá. Molít wihcannit dée, ĩ joiná yʉhna, ĩ jéih beh joicán caá. Páant ĩ jʉmatdih jéihna, wã jenah joiní naáwátjĩhjeh queétdih wã bohéna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jon jã́tih Isaías ã daacátji pah caá ĩ jʉmʉp. ‘Nin pah caá Dios ã niijíp: “Wã naáwátdih maatápdih joiná yʉhna, caandíh ñi beh joicán niít. Ded pah wã chãjatdih enna yʉhna, ñi beh encan niít. ");
INSERT INTO cbv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ded pah wã naáwát, wã chãjatdihbʉt jéihíhcannitjeh ñi jʉmna caá. Pánih jʉmnit, weemdíh joííhcan, ñíih molítdih ñi nem teona caá. Wã chãjatdih eníhcan, ñi quíib ʉ̃ona caá. Páant ñi chãjcan nihna, tʉ́i enna, tʉ́i joiná, tʉ́i beh joinít ñita jʉm tagaá. Pánih tʉ́i beh joinít jʉmna, tʉ́ʉt nʉʉmnít, weemdíh ñita bid tagaá. Páant weemdíh ñi bidichah, ñi yéejatdih yohnit, yeéb iiguípna ñi bejat déedih wãta tʉ́i ʉb tagaá”, Dios ã niijná caá’, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Obohjeéhtih, yeéb wã bohénitboó jéihíhnit jʉmna, ennit, ñi beh enna caá. Joinít, ñi beh joiná caá. Páant ñi jʉmʉchah, Dios yeebdíh ã wẽi enna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yoobópdih yeebdíh wã naóhna caá. Bʉʉ ñi enatdih jon jã́tih moón Dioíhwã, Dios naáwátdih naóh yapanitbʉt bʉ́dí eníhna yʉhna, ĩ encap jĩ. Bʉʉ ñi joyátdihbʉt bʉ́dí joííhna yʉhna, ĩ joicáp jĩ”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Waáh momni naáwátdih beh joyát tʉ́ʉt niijná, nindih wã naáwáchah, ñi tʉ́i joyoó. ");
INSERT INTO cbv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wĩ́ih tʉ́ini dooná naóhni waáh momni panihni caá. Biquína joinít namáboó bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joiná yʉhna, beh joicán, ĩ jepahcan caá. Pánihna, caandíh ĩ joyát tʉ́ttimahbitjeh, nemépboó jʉ̃óhnit, jwébehwã caán tíibnadih ĩ jeémát pahjeh, queét ĩ joyátjidih ã quíib bʉʉdána caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bita joinítboó, jeejíh yewéni baácdih bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joinít, bʉ́dí ĩ wẽi jwʉhna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Obohjeéhtih, wẽi joiná yʉhna, ñeh jáap bejni panihni ĩ jʉmna caá. Pánihna, yeejép ã yapachah, wĩ́ihwã ĩ jʉmat jíib bita queétdih ĩ yéej chãjachah, waícanjeh wĩ́ih tʉ́ini doonádih ĩ cádahna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bita joinítboó nemép óotna cãtíh bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joinít, ĩ jepahna yʉh caá. Obohjeéhtih, nin baácdih bóodih bʉ́dí jenah joinít, bií déedihbʉt bʉ́dí ĩ bidna caá. Páant ĩ jenah joyóchah, ĩ joiní tʉ́ini dooná pácahi panihni ĩ́ih caolihboó ã jéih behcan caá. Pánihna, caandíh jenah joicán, tʉ́iniboodíh ĩ jéih chãjcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Obohjeéhtih, bitaboó wĩ́ih tʉ́ini doonádih joinít, tʉ́ini baácboó bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joiná, tʉ́i beh joinít, ĩ tʉ́i jepahna caá. Pánih jepahnit jʉmna, Dios ã náahat pahjeh ĩ tʉ́i chãjna caá. Biquína, cien tíibna ã quehat pah, chah tʉ́ini yoobát ĩ chãjna caá. Bita, sesenta tíibna ã quehat pah, tʉ́ini ĩ chãjna caá. Bitaboó, treinta tíibna ã quehat pah, nʉmp tʉ́ini ĩ chãjna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","“Dios ã maáh jʉmat nin pah ã jʉmna caá: Wápchi mínah ã́ih wápchiboó trigodih ã momop yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Obohjeéhtih, caán, nihat ãjeéh moonbʉ́t ĩ ʉ̃wat pónih, caandíh eníhcanniboó ã́ih wápchina jʉinít, ã momatji cãtíh yeejép yílipdih ã momop be. Mom péanit, ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tʉ́ttimah, trigo chíihnit, ã jáap quehe jʉ̃ʉ́wʉ́chah, yeejép yílip ã jʉmatdihbʉt teo wʉ̃hnit ĩ enep be. ");
INSERT INTO cbv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pánih ennit, wápchi mínah pebhna jʉibínit, nin pah ĩ niíj ʉʉ́bh joyóp be: ‘¿Maá, trigodihjeh ma momochah yʉhna, dépanih tigaá míih wápchidih yeejép yílipbʉt ã chíih?’ ĩ niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Weemdíh eníhcanni caandíh ãt momop taga’, ã niíj jepahap be. ‘¿Caán jã́oni yílipdih jwĩ wʉi yóh jĩíh?’ ĩ niíj ʉʉ́bh joyóp be. ");
INSERT INTO cbv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ñi wʉi yóhca bojoó. Caandíh wʉiná, trigodihbʉt ñita wʉi yóh tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trigo yílip biícdih ã beh jwʉhʉ naáh. Caán trigo ã behechah, yeebdíh nin pah wã niijbípna caá: “Yeejép yílipdih ñi jwíih wʉyʉʉ́. Pánih wʉí, nah chéo péanit, caandíh ñi cáo yohoó. Pánih cáo péanit, trigoboodíh ñi bóod ʉbʉʉ́. Pánih bóod ʉb beedánit, caandíh wã ámohat mʉʉná ñi ámohoó”, wã niijbípna caá’, caandíh teo wʉ̃hnitdih wápchi mínah ã niijíp be”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","“Dios ã maáh jʉmat nin pahbʉt ã jʉmna caá: Mostaza tíib cã́o tíbih pah bóo ã jʉmna caá. Pánih bainí tíbih jʉmna yʉhna, caandíh ĩ momochah, chíihna, ã tʉ́i behna caá. Páant ã behechah, ã́ih cã́canaboó dawá jwébehwã ĩpĩ́ jaamná caá. Pánihat pah tigaá Dios ã maáh jʉmat. Ã́ihwã daocánnit jwíih jʉmnitji, tʉ́ttimah ĩ dao béjbipna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","“Dios ã maáh jʉmat pan paááni panihni ã jʉmna caá. Pandih chãjíhna, yad wili trigo ojdih pamapdih yacnit, mahjĩh wid, caandíh paááni pínahdihbʉt mipĩ́ tʉ́i widna caá. Pánihna, nihat mi widniji ã tʉ́i paabípna caá. Pánihat pah tigaá Dios ã maáh jʉmat doonádih joinít, cã́acwã ĩ tʉ́ʉt nʉʉmbípna caá. Queét joinítboó bitadih ĩ jwʉ́ʉb naáwáchah, dawá joinít, queétbʉt ĩ tʉ́ʉt nʉʉmbípna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cã́acwãdih bohéna, ã jenah joiní naáwátjĩhjeh Jesús ãpĩ́ bohénap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pánih bohéna, Dios naáwátdih naóh yapani nin ã daacátji pahjeh biíc yoobó ãpĩ́ bohénap jĩ: “Nin pah Dios ã niijná caá: ‘Wã jenah joiní naáwátjĩh wã bohébipna caá. Nin baácdih wã chãjat tʉ́ttimah, cã́acwãdih wã naóh jwʉhca naáhdih wã naóhbipna caá’, ã niijná caá”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pánih naóh péanit, jãáj chóodih chʉ́ʉdniji aáb jʉ̃óhnit, caandíh joinítdih “Jwĩ bejna caá”, niijnít, mʉʉná Jesús jwiítdih ã nʉmah jwʉ́ʉb aab béjep jĩ. Pánih mʉʉná aáb jʉibínit, jwiít caandíh nin pah jwĩ niijíp jĩ: —Trigo cãtíh yeejép yílip chíihat naáwátjĩh ma bohénachah, jwĩ beh joicán beé. Pánihna, jwiítdih ma jéihya naáwá, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Páant jwĩ niijíchah joinít, Jesús nin pah ã niíj jepahap jĩ: —Weém, nihat cã́acwã ʉ́ʉd jeñé, wápchi mínah panihni caá. Weém Dios ã wahni jʉmna, trigodih momni panihni wã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nin baác wápchi panihni, Diosdih jepahnit trigo panihnit ĩ jʉmna caá. Obohjeéhtih, nemépwã ĩ maáhdih jepahnitboó trigo cãtíh chíihni yeejép yílip panihni ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nemépwã ĩ maáh wápchi mínahdih eníhcanni yeejép yílipdih momni panihni caá. Caán trigo ã behechah, ĩ bóod ʉb láa, péeni yeó jáap panihni caá. Ángelwã caán trigodih yeejép yílipdihbʉt bóod ʉbnit panihnit ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Trigodih ʉbnit, yeejép yílipboodíh ĩ wʉí cáwat pah péeni yeó jáapdih nemépíhwãdih iiguípboó ĩ yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Weém nihat cã́acwã ʉ́ʉd jeñé, wĩ́ih ángelwãdih nin baácboó wã wahbipna caá, wĩ́ih cã́acwã cãtíh yeejép chãjnit, yéej chãjat tʉ́ʉtnitdihbʉt ĩ ʉb bejat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pánih ʉb bejnit, queétdih iiguípboó ĩ yohbipna caá. Caán iiguípboó jʉmna, jĩ́gahnit, queétjeh ĩ míic néeh chãác jʉ̃ibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dioíhwãboó jwĩ íip Dios biícdih ã maáh jʉmʉpboó ĩ jʉmbipna caá. Caanjĩ́h jʉmna, yeo páh tʉ́i yeh iigní panihnit, maáta ĩ jʉmbipna caá.¡Ded molít jʉmna, ã tʉ́i joyó naáh! Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Dios ã maáh jʉmat wápchiboó bʉ́dí jíib jʉmnidih ĩ baad bíhniji panihni ã jʉmna caá. Biíc newé caán wápchi mínahdih teo wʉ̃hna, caán bʉ́dí jíib jʉmnidih bid jʉinít, bʉ́dí wẽina, ã jwʉ́ʉb bihip be, páant mʉntih. Pánihna, caandíh bʉ́dí náahna, ã́ih bií déedih jíib chãj beedánit, caán jíibjĩh wápchidih ã jíib chãjap be. ‘Bʉʉ caán wápchi wĩ́ih ã jʉmʉchah, caánboó wã bid jʉiníjibʉt wĩ́ihjeh ã jʉmna caá’, wẽinit, ã míic niijíp be. Dios ã maáh jʉmʉpboó ñi waadát pínah caán bʉ́dí jíib jʉmni panihni ã jʉmna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Dios ã maáh jʉmat nin panihnibʉt ã jʉmna caá. Bʉ́dí jíib jʉmni jeé tíib dée perlas wʉ̃t jʉmni tíibnadih jíib chãjniboó chah jíib jʉmni perlas tíibnadih nihat pebhboó ã bid bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chah bʉ́dí jíib jʉmni tíibdih bid jʉinít, caandíh jíib chãjíhna, nihat ã́ih bií déedih jíib chãj wʉ̃hʉdih ã bejep be. Pánih jíib chãj wʉ̃h beedánit, caán bʉ́dí jíib jʉmni tíibdih ã jíib chãjap be. Caán tíibdih bʉ́dí ã náahat pah, Dios ã maáh jʉmʉpboó waadát pínahdih chah bidat caá náahap”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Dios ã maáh jʉmat nin pahbʉt ã jʉmna caá. Cã́acwã queejwã́dih jʉ́ʉt maona, ñʉodíh ĩ yoh báahanachah, queejwã́ jʉmat yoobó ĩpĩ́ chʉ̃ʉ́hna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Páant dawá ĩ chʉ̃ʉ́ʉ́chah, nihat queejwã́dih íim jwẽ́ejna ʉb ñáan jʉibínit, tʉ́initdihjeh ĩ ñíona caá. Pánih ñíonit, ĩ́ih wʉhnaboó ĩpĩ́ mao yacna caá. Obohjeéhtih, jeémpca naáhwãboodíh ĩpĩ́ yohna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Pánihat pah, péeni yeó jáapdih ángelwãboó cã́acwãdih ĩ ñíobipna caá. Yeejépwãdih ñíonit, iiguípna ĩ yohbipna caá. Caán iiguípboó jʉmna, jĩ́gahnit, queétjeh ĩ míic néeh chãác jʉ̃ibípna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Páant niíj péanit, Jesús jwiítdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Bʉtéh wã bohéátdih ñi beh joinít beé? ã niijíp jĩ. —Jwĩ beh joiná beé, caandíh jwĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Páant jwĩ niíj jepahachah joinít, jwiítdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Det Moisés ã wʉtatjidih bohénit Dios ã maáh jʉmatdihbʉt bohéna, máadih, jáapdihbʉt cã́acwãdih ĩ jéih bohéna caá. Queét bohénit mʉʉ́ mínah panihnit caá ĩ jʉmʉp. Caán, bitadih teo wáacat tʉ́ʉt niijná, ã́ih mʉʉdíh jʉmni tʉ́inidih ʉb bacanit, jáapdih, máadihbʉt queétdih ã jéih wʉ̃hna caá, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Páant ã jenah joiní naáwátnajĩh bohé péanit, Jesús jwiítdih ã nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pánih bejnit, ã behni tʉ́tchina jwĩ jʉibínap jĩ. Caanná jʉibínit, jwiít judíowã jwĩ míic wáacat mʉʉná waadnít, caanjĩ́h jʉmnitdih ã bohénap jĩ. Páant ã bohénachah joiná, joí wʉ́hi bejnit, nin pah ĩ míic niíj ʉʉ́bh joyóp jĩ: —¿Dedmant tigaá nin bohéátdih ãt joí? ¿Dépanih tigaá ã tʉ́i jéih beedá? Dios ã wẽpatjĩh jwiít cã́acwã jwĩ chãjca naáhdih ãpĩ́ chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Nin máa teoni wʉ̃ʉ́h nihcan niít? ¿Ã íin María nihcan niít? ¿Santiago, José, Simón, Judas, ã ʉ́ʉdwã nihcan niít? ");
INSERT INTO cbv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Yad jʉpʉna yaádh nin tʉ́tchidih jwĩjeéh jʉmnit nihcan niít? Pánihna, jwiít jwĩ jʉmat pahjeh jʉmni tigaá ã jʉmʉp. ¿Pánih jʉmna yʉhna, nin bohéátdih dee tígaá ãt joí? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Páant niíj jenah joinít, íijna, caandíh ĩ náahcap jĩ. Páant ĩ náahcatdih enna, nin pah queétdih Jesús ã niijíp jĩ: —Dios naáwátdih naóh yapanidih bita ĩpĩ́ wẽi joiná caá. Páant ĩ wẽi joyóchah yʉhna, ã́ih tʉ́tchidih moón, ã déewãboó caandíh ĩpĩ́ joííhcan caá. Pánihna, ninjĩh wã behechah ennitji, weemdíh ñi joííhcan caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Caandíh ĩ joííhcah enna, caán tʉ́tchidih Dios ã wẽpatjĩh daocánni láajeh Jesús ã chãj jʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Caán láa Herodes, Galilea baácdih moón ĩ maáh, Jesús ded pah ã chãjat doonádih ãt joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pánih joinít, caandíh teo wʉ̃hnitdih nin pah ãt niijíp wʉt yʉh jĩ: “Wã maoniji Juan Daabáni ãt jwʉ́ʉb boo pʉd jʉ̃óh tagaá. Pánih jwʉ́ʉb booni jʉmna, jwiít cã́acwã jwĩ jéih chãjca naáhdih ãt chãjap taga”, ãt niijíp wʉt jĩ. Jesúsdih “Juan tigaá”, ãt niíj jenah joyóp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Juandih ã mao yohat tʉ́ʉtat pínah jã́tih, Herodes ã ʉ́ʉd Felipe áadih ãt bíbohop wʉt jĩ. Páant ã chãjat doonádih joiná, Juan Daabáni Herodesdih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: “Ma ʉ́ʉd áadih dʉ́ʉc wái áa jʉmna, Dios ã wʉtatdih yap yohna caá ma chãjap”, ãt niijíp wʉt jĩ. Páant ã niiját jíib Herodes caandíh ãt mao yohíhip wʉt yʉh jĩ. Obohjeéhtih, “ ‘Juan Dios naáwátdih naóh yapani ã jʉmna caá’, judíowã ĩ niíj jenah joiná caá. Pánihna, caandíh wã mao yohat tʉ́ʉtʉchah, queét weemdíh ĩta íij tagaá”, niíj jenah joinít, queétdih ãt ʉ́ʉmʉp wʉt jĩ. Pánih ʉ́ʉmna, Juandih mao yohcanjeh, caandíh teonit, chéwat tʉ́ʉtnit, nemat mʉʉ́boó ãt nemat tʉ́ʉtʉp wʉt jĩ. Yad Herodías mi wʉtʉchah joinít, páant ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pánihat tʉ́ttimah, Herodes ã cã́ac jʉmni yeó jáapjidih náhninit, nʉmah jeémát ãt chãjap wʉt jĩ. Pánih chãjnit, caanjĩ́h jʉmnit ĩ enechah, ã aá nʉʉ́m mit eo jʉ́ʉtʉp wʉt jĩ. Páant mi eo jʉ́ʉtʉchah enna, Herodesboó bʉ́dí ãt weñep wʉt jĩ. Pánih wẽinit, caántdih nin pah ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","—Dios ã enechah, meemdíh yoobópdih wã naóhna caá. Dedé ma náahatdih weemdíh ma ʉʉ́bʉ́chah, meemdíh wã wʉ̃hbipna caá, caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Páant ã niijíchah joinít, mi íin ded pah mi niiját tʉ́ʉtat pahjeh Herodesdih mit jepahap wʉt jĩ. —Juan Daabániíh wao dáhdih dʉ́ʉc bóodat tʉ́ʉtʉ́. Pánih péanit, pamapjih ã́ih wao dáhdih cáagnit, weemdíh ma wʉ̃hʉʉ́, caán ã wʉnatdih wã jéihyat pínah niijná, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Páant mi niijíchah joinít, Herodes bʉ́dí ãt jĩ́gahap wʉt yʉh jĩ. Obohjeéhtih, caanjĩ́h míic wáacnitdih tíicnit, “Meemdíh wã wʉ̃hcan niít”, caántdih ãt jéih niijcáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pánihna, Juaníh wao dáhdih ãt dʉ́ʉc bóodat tʉ́ʉtʉp wʉt jĩ, bʉca. ");
INSERT INTO cbv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pánih péanit, pamapjih ã́ih wao dáhdih cáagnit, ĩt ʉb jʉ̃ʉ́wʉ́p wʉt jĩ. Pánih ʉb jʉ̃óhnit, Herodías nʉʉmdíh ĩ wʉ̃hʉchah, caántboó mi íindih mit teo yapanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Páant ĩ chãjat tʉ́ttimah, Juan ã bohénitji jʉ̃óhnit, ã́ih bácahjidih ʉbnit, cã́ac yohop íitboó ĩt yohop wʉt jĩ. Pánih yoh péanit, queét jʉ̃inít, Jesúsdih naáwádih ĩ jʉyʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Páant ĩ niijní doonádih joí péanit, jãáj chóona waadnít, cã́ac wihcapboó Jesús jwiítdih ã nʉmah chʉ́ʉh bejep jĩ. Jwiít Jesús biícdih jwĩ chʉ́ʉh bejat doonádih joinít, caandíh jwãáát tʉ́ʉt niijná, dawá ĩ́ih tʉ́tchinamant jʉ̃óhnit, íim jwẽ́ejmant ĩt pʉ́ʉd bejep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jwiít jwĩ chʉ́ʉh jʉibíát pínah jã́tih, queét ĩtát jʉibínap tajĩ. Pánihna, dawá cã́acwã ĩ páñachah ennit, Jesús queétdih ãt jĩ́gah enep jĩ. Pánih jĩ́gah enna, ĩ ʉb jʉ̃óhnit wʉnnitdih ã booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cheyeh jʉmʉchah, jwiít ã bohénit caandíh nin pah jwĩ niijíp yʉh jĩ: —Cheyeh caá. Nin pebhbit tʉ́tchi wihcan caá. Pánihna, queétdih yʉʉ́pbit jʉmni tʉ́tchina ma wahaá, jeémátdih ĩ jíib chãjat pínah niijná, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Ĩ bejca bojo naáh. Yeebjéh queét ĩ jeémát pínahdih ñi wʉ̃hʉʉ́, Jesús jwiítdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Obohjeéhtih, biícjĩh bóo téihya botoni pan dahna, chéne queejwã́bitdihjeh jwĩ bíbohna caá, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Caán ñi bíbohnidih weemdíh ñi ʉb jʉ̃ʉ́wʉ́, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Páant ã niijíchah joinít, ʉb jʉ̃óhnit, caandíh jwĩ wʉ̃hʉp jĩ. Páant jwĩ wʉ̃hat tʉ́ttimah, yílipboó cã́acwãdih ã chʉ́ʉdat tʉ́ʉtʉp jĩ. Páant ĩ chʉ́ʉdʉchah, biícjĩh bóo téihya pan dahna chéne queejwã́dihbʉt ʉbnit, chéi ennit, “Tʉ́ina caá, Paá”, Diosdih ã niijíp jĩ. Páant niíj péanit, pan dahna, queejwã́ biícdih jwiítdih ã daj wʉ̃hʉp jĩ. Páant ã daj wʉ̃hʉchah, jwiítboó nihat cã́acwãdih jwĩ pãááp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Páant jwĩ pãááchah, nihat ĩ tʉ́i jeémp wʉd jʉmʉp jĩ. Pánihna, ĩ jʉdh jeémpnidih doce wʉhna jwĩ ʉb yac yáwanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Caandíh jeémpnit neonádihjeh jwĩ jenah enechah, cinco mil ĩ jʉmʉp jĩ. Yaádh, ĩ wehbʉt ĩ jeémép jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Páant jwĩ jeémp péanachah, jwiít ã bohénitdih Jesús ã chʉ́ʉh bej páñat tʉ́ʉtʉp jĩ. Pánih chʉ́ʉh bejat tʉ́ʉtnit, cã́acwãdihbʉt ĩ́ih tʉ́tchina ãt jwʉ́ʉb bejat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pánih wah péanit, ã íipdih ʉʉ́bát tʉ́ʉt niijná, jeéboó ãt pʉ́ʉh laab béjep wʉt jĩ. Pánih pʉ́ʉh laab béjnit, tõo ñáh jʉ̃ʉ́wʉ́chah, biícjeh caánboó ãt jʉm jwʉhʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Caánboó Jesús ã jʉmat pónih, íim tac yoób jwiítboó jwĩ bʉʉg lájachah, jwĩ wawápmant johlit, nolihatbʉt bʉ́dí ã jʉ̃ʉ́wʉ́chah, maatápdih meenná yʉhna, jwĩ jéih bejcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pánihna, johlit páantjeh bʉ́dí ã johochah, baáb aabá bojat pínah jã́tih, Jesús jwĩ pebhna íimjih ã yáac chʉ̃i jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jwĩ pebhna ã jʉ̃ʉ́wʉ́chah ennit, bʉ́dí jwĩ ʉ́ʉmʉp jĩ. —¡Cã́aquíh dadah caá! jwĩ niíj ñaacáp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Páant jwĩ ʉ́ʉmʉchah ennit, Jesúsboó jwiítdih nin pah ã niijíp jĩ: —¡Weemjéh tigaá! ¡Weemdíh ñi en ʉ́ʉmca bojoó! ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Páant ã niijíchah joinít, Pedroboó caandíh nin pah ã niijíp jĩ: —Maá, yoobópdih meemjéh jʉmna, íimjih weemdíhbʉt ma pebhna ma yáac chʉ̃i bejat tʉ́ʉtʉ́, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Ma jʉ̃ʉ́wʉ́, Jesús ã niíj jepahap jĩ. Páant ã niijíchah joinít, Pedro jãáj chóodih jʉmniji íimjih dei ñʉhnit, Jesús pebhna ã yáac chʉ̃i bejep yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Obohjeéhtih, johlit nolihatbʉt bʉ́dí ã jʉmʉchah enna, ãt ʉ́ʉmʉp jĩ. Pánih ʉ́ʉmna, daab béjnajeh, Jesúsdih nin pah ã niíj ejep jĩ: —¡Maá, weemdíh ma teo wáacá! ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Páant ã niijíchahjeh, ã́ih téihyadih teonit, Jesús caandíh ã wái ñahanap jĩ. —¡Bainíjeh wã wẽpatdih ma jenah joiná caá! ¿Dépanih tigaá weemdíh ma tʉ́i jenah joicán? Pedrodih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Páant ã niiját tʉ́ttimahjeh, jãáj chóona queét ĩ waadáp jĩ. Páant ĩ waadáchahjeh, johlit ã yayáh bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Páant ã yapachah ennit, jwiít ã bohénit Jesúsdih jwĩ wẽi naáwáp jĩ. —¡Yoobópdih meém Dios wʉ̃ʉ́h tigaá ma jʉmʉp! jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pánih íimdih chʉ́ʉh bejnit, Genesaret wʉ̃t jʉmni baácna jwĩ chʉ́ʉh jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Páant jwĩ jʉibínachah, caán baácdih moón Jesúsdih beh ennit, caán tʉ́tchinadih moondíh ã jʉyát doonádih ĩt wahap tajĩ. Pánihna, caán doonádih joinít, dawá ĩ chéenwã tʉbʉ́p chʉ̃ʉ́hnitdih Jesús pebhna ĩ ʉb jʉyʉ́p jĩ. Pánih ʉb jʉinít, nin pah Jesúsdih ĩ niijíp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Míih yégueh chóodihjeh nit wʉnnitdih ma tewat tʉ́ʉtʉ́, ĩ niijíp jĩ. Pánihna, ã́ih yégueh chóodih teonit pah moonjéh ĩ boonap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tʉ́ttimah, Jerusalén tʉ́tchidih moón fariseowã, Moisés ã wʉtatjidih bohénit biícdih, Jesús pebhna jʉinít, caandíh nin pah ĩ niíj ʉʉ́bh joyóp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Dépanih tigaá ma bohénitboó jwĩ nʉowã ĩ wʉtatji pah ĩ chãjcan? Jwiít jwĩpĩ́ téih chocat pah, queét ĩ jeémát pínah jã́tih ĩ téih choccan caá, ĩ niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Páant ĩ niijíchah joinít, Jesús nin pah queétdih ã niíj ʉʉ́bh joí jwʉ́ʉbanap jĩ: —¿Yeébboó dépanih tigaá Dios ã wʉtatdih jepahcan, jwĩ nʉowã ĩ wʉtatboodíhjeh ñi jepah? ");
INSERT INTO cbv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nin pah caá Dios ã wʉtʉp: ‘Ñi mánadih tʉ́i wẽinit, ñi teo wáacá.Pánihna, ded ã mánadih yeejép ã niijíchah, cã́acdih mao yohnidih peéh chãjat pah mʉntih caandíhbʉt peéh chãjat ã jʉmbipna caá’, Dios ãt niijíp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Obohjeéhtih, páant ã niijíchah yʉhna, yeébboó ded ã mánadih teo wáaquíhnidih nin pah caá ñipĩ́ niíj wʉtʉp: ‘Ma mánadih teo wáaccanjeh, caán dinerodih Diosboodíh ma wʉ̃hʉʉ́’, ñipĩ́ niíj wʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pánih wʉtna, ã mánadih ñi tʉ́i chãjat tʉ́ʉtcan caá. Pánih chãjat tʉ́ʉtcan, Dios ã wʉtatdih jepahat tʉ́ʉtcanjeh, jwĩ nʉowã ĩ wʉtatjiboodíh caá ñi jepahat tʉ́ʉtʉp. ");
INSERT INTO cbv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","‘Jwiít tʉ́init caá’, niijná yʉhna, cã́acwã ĩ encapboó yeéb yeejép chãjnit caá. Dios naáwátdih naóh yapani Isaíasji ded pah ñi jʉmatdih yoobópdih ãt niíj daacáp tajĩ: ");
INSERT INTO cbv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Dios nin pah ã niijná caá: “Nit weemdíh tʉ́i wẽi naóhna yʉhna, yoobópdih ĩ jepahcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pánihna, weemdíh ĩ wẽi naáwát dedé pínah nihcan caá. Ĩ jenah joyátjeh wʉtnit, ‘Nin pah caá Dios ã wʉtat’, ĩ niíj yee naóh bohéna caá”, Dios ã niijná caá’, Isaías ãt niíj daacáp tajĩ, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Páant niíj péanit, caanjĩ́h jʉmnitdih ã pebhna jʉ̃ʉ́wát tʉ́ʉtnit, queétdih nin pah ã niíj bohénap jĩ: —Nin wã naáwátdih ñi tʉ́i joyoó. ");
INSERT INTO cbv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dios ã enechah, ñi jeémát yeebdíh ã yéejacan caá. Obohjeéhtih, ded pah ñi niijátboó yeebdíh ã yéejana caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Páant ã niiját tʉ́ttimah, jwiítboó caandíh nin pah jwĩ niijíp jĩ: —Páant ma niijíchah joinít, queét fariseowã bʉ́dí ĩ íijna beé, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—Obohjeéhtih, queét fariseowã wã íip Dios ã momca naáh panihnit ĩ jʉmʉchah, queétdih ã yoh beedábipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pánihna, queétdih páantjeh ñi enah bojoó. Queét jéih encannit pah Diosdih ĩ jéihcan caá. Pánih jéihcan yʉhna, bita jéih encannit panihnitdihbʉt ĩ bohéna yʉh caá. Pánih jéih encannit míic jʉmna, íitdih ĩ bʉʉg yácat pah, queét nihat iiguípna ĩ bejbipna caá, jwiítdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Páant ã niijíchah joinít, Pedroboó nin pah ã niijíp jĩ: —Jwiítdih ma naáwátjidih ma jéihyanaá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Yeebbʉ́t páantjeh ñi beh joi jwʉ́hcan niít? ");
INSERT INTO cbv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dedé ñi jeémátji ñíih wʉdah diítboó jʉmnijidih ñipĩ́ jont yohna caá. Caán ñíih caolihdih, ñi jenah joyátdihbʉt chʉ̃ʉ́hcan, Dios ã enechah, yeebdíh ã jéih yéejacan caá. ");
INSERT INTO cbv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Obohjeéhtih, ded pah yeejép ñi jenah joyát pah ñi niijíchah, caán caá Dios ã enechah, yeebdíh ã yéejanap. ");
INSERT INTO cbv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nindih ñi tʉ́i náhninaá: Yeejép chãjat, mao yohat, ñi áa nihcannitjĩh yeejép chãjat, nʉʉmát, yeeat, yeejép míic niiját pínahdihbʉt ñipĩ́ jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Páant ñi jenah joyátjeh caá, Dios ã enechah, yeebdíh ã yéejanap. Obohjeéhtih, ñi téih chocochah, ñi choccahbʉt yeebdíh biíc yoobó ã enna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Páant niíj bohé péanit, Jesús Tiro tʉ́tchi, Sidón tʉ́tchi jʉmni baácna jwiítdih ã nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Caanná jwĩ jʉibínachah, caán baácdih bóli Jesús pebh jʉinít, nin pah mi niíj ñaacáp jĩ: —¡David jʉima, Dios ã wahni, weemdíh ma jĩ́gah eneé! ¡Wã nʉʉmdíh nemép jʉmna, caántdih bʉ́dí ã moh yéejana caá! mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Páant mi niijíchah joiná yʉhna, caántdih ã jepah jwʉhcap jĩ. Páant ã jepahcatdih enna, jwiít ã bohénitboó caandíh nin pah jwĩ niijíp jĩ: —Páantjeh jwiítdih mi ñaác péenachah, ma jwʉ́ʉb bejat tʉ́ʉtʉ́, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—Judíowã bʉʉdnít ovejawã panihnit ĩ jʉmʉchah ennit, queétdihjeh teo wáacat náahna, Dios weemdíh ã wahap jĩ, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Páant ã niijíchah joinít, caánt judío nihcannihboó ã pebh bódicha caj yoh ñajnit, nin pah mi niijíp jĩ: —¡Maá, weemdíh ma teo wáacá! mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Wébít ĩ jeémát pínahdih ʉbnit, ĩ́ih mʉjjiowã́dih jwĩ wʉ̃hʉchah, ã tʉ́ican caá. Pánihat pah judíowã ĩ jeémát panihnidih biíh baácdih moondíh wã wʉ̃hʉchah, ã tʉ́ican caá, Jesús caántdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Ma niiját yoobópdih tigaá, Maá. Obohjeéhtih, queét ĩ jeémp jéenanidih mʉjjiowã́ ĩpĩ́ jeémpna caá, mi niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Meémboó weemdíh tʉ́i jenah joiníh ma jʉmʉchah, ma niiját pah wã chãjna caá, Jesús caántdih ã niijíp jĩ. Páant ã niijíchahjeh, mi nʉʉ́m mit boonap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pánihat tʉ́ttimah, Jesús jwiítdih caanmánt Galilea íim jwẽ́ejna ã nʉmah dei bejep jĩ. Caanná dei jʉibínit, íim jwẽ́ejdih jʉmni jeená ã nʉmah pʉ́ʉh laab béjep jĩ. Pánih pʉ́ʉh laáb jʉibínit, biícdih jwĩ chʉ́ʉdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Páant jwĩ chʉ́ʉdʉchah enna, dawá cã́acwã Jesús pebhna ĩt jʉ̃ʉ́wʉ́p tajĩ. Pánih jʉ̃óhna, ĩ chéenwã wʉnnitdih ĩ jʉí jwejep jĩ. Queét nihat mácah wʉnat jʉmnit ĩ jʉmʉp jĩ. Jéih bejcannit, jéih encannit, téihya jítcha wihcannit, jéih wéhecannit, dawá biíh wʉnat jʉmnitbʉt ĩ jʉmʉp jĩ. Páant ĩ jʉmʉchah ennit, Jesús queét nihatdih ã booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Páant ã booanachah, jéih wéhecannitji ĩ wéhenachah joinít, téihya jítcha wihcannitji téihya jítcha ĩ jʉmʉchah ennit, jéih bejcannitji ĩ bejechah ennit, jéih encannitji ĩ enechah ennit, cã́acwãboó bʉ́dí ĩ en wʉ́hi bejep jĩ. Pánih en wʉ́hi bejnit, “Jwiít judíowã jwĩpĩ́ wẽini Dios bʉ́dí ã wẽpatjĩh jwiítdih ã tʉ́i teo wáacna caá”, ĩ niíj wẽi naáwáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pánih booa péanit, Jesús jwiítdih ã pebh jʉ̃ʉ́wát tʉ́ʉtnit, nin pah ã niijíp jĩ: —Queét jwĩjeéh biíc peihcanni yeó jáap ĩ jʉmʉchah, ĩ́ih jeémát ã beedná nacaá. Pánih jeémát wihcannit ĩ jʉmʉchah, queétdih bʉ́dí wã jĩ́gah enna caá. ‘Queét nʉʉgʉ́p wʉn bʉʉgná’ niijná, queétdih ĩ́ih mʉʉnáboó wã jwʉ́ʉb bejat tʉ́ʉtcan niít, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—¿Obohjeéhtih, ninjĩh tʉ́tchi wihcapboó jʉmna, queét dawá ĩ jʉmʉchah, dedboo tígaá ĩ jeémát pínahdih jwĩ jíib chãj bií? Jesúsdih jwĩ niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Débói pan tigaá ñi bíboh? Jesús ã niijíp jĩ. —Siete pan dahna, daocánni queejwã́bit, páant bóojeh jwĩ bíbohna caá, caandíh jwĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Páant jwĩ niijíchah, Jesús cã́acwãdih ã chʉ́ʉdat tʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Páant ĩ chʉ́ʉdat tʉ́ttimah, Jesús caán siete pan dahna, queejwã́bit biícdih ʉbnit, “Tʉ́ina caá, Paá”, Diosdih niíj péa, jwiítdih ã daj wʉ̃hʉp jĩ, cã́acwãdih jwĩ pãáát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Páant queétdih jwĩ pãáát tʉ́ttimah, ĩ tʉ́i jeémp wʉd jʉmʉp jĩ. Páant ĩ jeémp péanachah, ĩ jʉdh jeémpnidih ʉbnit, siete wʉhdih jwĩ ʉb yac yáwanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Caandíh jeémpnit neonádihjeh jwĩ jenah enechah, cuatro mil ĩ jʉmʉp jĩ. Yaádh, ĩ wehbʉt ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Páant ĩ jeémp péanachah, Jesús queétdih ĩ́ih mʉʉnáboó ã jwʉ́ʉb bejat tʉ́ʉtʉp jĩ. Pánih wah péanit, jãáj chóodih waadnít, Mágdala tʉ́tchi jʉmni baácna jwiítdih ã nʉmah chʉ́ʉh bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Biíh láa fariseowã, saduceowã biícdih Jesús pebhna ĩ jʉibínap jĩ. Cã́acwã ĩ jéih chãjca naáhdih Jesúsdih ĩ chãjat tʉ́ʉtʉp yʉh jĩ, ã jepahcah, “Dios ã wahni nihcan caá”, niiját tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Páant ĩ wʉtʉchah joinít, Jesús queétdih nin pah ã niijíp jĩ: “Yeó ã bʉʉg yácna, jeá dʉʉni ã jʉmʉchah enna, ‘Cheibit tʉ́i jóbohni yeó jáap ã jʉmbipna caá’, ñipĩ́ niijná caá. ");
INSERT INTO cbv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Baáb jéenna, mah tólihna dʉʉni ã jʉmʉchah enna, ‘Mah yeó jáap ã jʉmbipna caá’, ñipĩ́ niijná caá. Ded pah jeá ã jʉmatdih tʉ́i beh enna yʉhna, Dios ã wẽpatjĩh wã chãj jʉ́ʉtatboodíh ñi beh encan caá. ");
INSERT INTO cbv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bʉʉ láa moón yeejépwã, Diosdih náahcannit, Dios ã wẽpatjĩh wã chãjatdih ĩ eníhna yʉh caá.Obohjeéhtih, Dios naáwátdih naóh yapani Jonás ded pah ã yapatjidih ñitát jéihjip taga.Pánihna, Dios ã wẽpatjĩh caandíh ã chãjatji pahjeh mʉntih ã jwʉ́ʉb chãjbipna caá, weém ã wahni wã jʉmatdih ñi jéihyat pínah niijná”, ã niijíp jĩ. Páant niíj péanit, jwiítdih ã jwʉ́ʉb nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pánih bejnit, íimdih chʉ́ʉh bejna, jwĩ jeémát pínah pandih ʉbat jwĩt quíib bʉʉdʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Páant jwĩ chʉ́ʉh bejechah, Jesús jwiítdih nin pah ã niijíp jĩ: —¡Ñi tʉ́i chãja chaáh! Fariseowã, saduceowãbʉt ĩ bohéát pan paáát panihni caá. Páant ĩ bohéát yeebdíh ã tobohna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Páant ã niijíchah, joí wʉ́hi bejna, jwiítjeh nin pah jwĩ míic niijíp jĩ: —Pandih jwĩ ʉb jʉ̃óhcah enna, jwiítdih páant ã niijná caá, jwĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Páant jwĩ míic niijátdih jéihna, Jesús jwiítdih nin pah ã niíj naáwáp jĩ: —¿Dépanih tigaá pan ã wihcatdih ñi náhni dahwa? ¡Wã wẽpatdih bainíjeh caá ñi jenah joyóp! ");
INSERT INTO cbv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Páantjeh ñi jéih jwʉhcan niít? ¿Cinco mil neoná yaádh biícdih cinco pandihjeh wã pãáátjidih ñi náhnican niít? ¿Ĩ jʉdh jeémpni doce wʉhna ñi ʉb yac yáwaatjidihbʉt ñi náhnican niít? ");
INSERT INTO cbv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Bʉʉ siete pandih dajnit, cuatro mil neoná yaádh biícdih wã wʉ̃hatdihbʉt ñi náhnican niít? ¿Débói wʉhnadih ñi yáwaatdih ñi náhnican niít? ");
INSERT INTO cbv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pánihna, ‘pan paáát’, wã niijíchah, ¿dépanih tigaá ñi beh joicán? Páant niijná, pan yoobátdih niijná wã chãjcan caá. Fariseowã, saduceowãbʉt ĩ bohéát pan paáát panihni ã jʉmʉchah, ñi tʉ́i chãja chaáh. Ĩ bohéát yeebdíh ã tobohna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Páant ã niíj naáwáchahna, jwiít jwĩ beh joyóp jĩ bʉca. “Pan paáát”, niijná, pan yoobátdih niijná ã chãjcap jĩ. Páant niijná, “fariseowã, saduceowãbʉt ĩ bohéátdih ñi joicá bojoó”, niijná ã chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pánih chʉ́ʉh jʉibínit, Cesarea Filipo wʉ̃t jʉmni tʉ́tchina bejni namáboó bejnit, Jesús jwiít ã bohénitdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Weém nihat cã́acwã ʉ́ʉd jeñédih ded pah tigaá bita ĩ niíj? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Biquína ‘Juan Daabáni nacaá’, niíj, bita ‘Elías nacaá’, niíj, bita ‘Jeremías, Dios naáwátdih biíh naóh yapani nacaá’, ĩpĩ́ niijná caá, caandíh jwĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Queét páant ĩ niijíchah, ¿yeébboó ded pah tigaá ñi niíj jenah joí? jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Meém Cristo, Dios ã wahni caá. Dios báadhni wʉ̃ʉ́h yoobát caá, Pedroboó ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Simón, Jonás wʉ̃ʉ́h, meemdíh wã wẽina caá. Cã́acwã meemdíh ĩt naóhcap taga. Dios wã íip, jeáboó jʉmnijeh ãt jéihyanap taga. ");
INSERT INTO cbv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pánihna, meemdíh nin pah wã niíj naóhna caá: Meém Pedro wʉ̃t jʉmni caá. (Pedro niijná, jee dáh niijná ã chãjap jĩ.) Nin jeejíh bʉ́dí mʉʉ́ wã chãjat panihni dawá wĩ́ihwã pínahdih wã chãjbipna caá. Queét dawá ĩ jʉmʉchah, nemépwã queétdih jéih yap yohcan, queét iiguípna ĩ bejcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dios ã maáh jʉmʉpdih bóo llave panihnidih meemdíh wã wʉ̃hbipna caá. Páant wã wʉ̃hni panihnijĩh, cã́acwãdih wĩ́ih tʉ́ini doonádih naóhnit, weemdíh jepahnitdih Dios ã maáh jʉmʉpna wãt waadáát pah ma chãjbipna caá. Obohjeéhtih, weemdíh jepahcannitdih nemat pah ma chãjbipna caá, Jesús Pedrodih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Páant niíj péanit, jwiítboodíh nin pah ã niijíp jĩ: “ ‘Nin Jesús Dios ã wahni Cristo caá’, bitadih ñi niíj naóh jwʉhca bojoó”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Páant ã niiját tʉ́ttimah, Jesús jwiít ã bohénitdih nin pah ã niíj naóh bohé jwíihip jĩ: —Bʉʉ, Jerusalén tʉ́tchiboó weemdíh bejat caá náahap. Caanná jwĩ jʉibínachah, jwĩ maáta, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt weemdíh yeejép ĩ chãjbipna caá. Pánih chãjnit, weemdíh ĩ mao yohat tʉ́ʉtbipna caá. Páant tigaá weemdíh yeejép yapat náahap. Obohjeéhtih, páant ĩ mawachah yʉhna, biíc peihcanni yeó jáap tʉ́ttimah wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Páant ã niijíchah joinít, Pedroboó Jesúsdih chibít yʉʉ́pbit nʉmah bejnit, —¡Maá, ma niiját pah yapcan, meemdíh queét ĩ mao yohca bojo naáh! ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Páant ã niijíchah joinít, Jesús tac pʉ́ʉd ñʉhnit, —Pánih naóhna, Satanás ã náahat pah naóhna caá ma chãjap. Cã́acwã ĩ jenah joyátjeh caá ma jenah joyóp. Dios ã jenah joyát nihcan caá. Pánihna, Dios ã náah yacat pah wã chãjat pínahdih ma jãhíhna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Páant niíj péanit, jwiítboodíh nin pah ã niíj naáwáp jĩ: —Ded wĩ́ih jʉmíhna, ã weñat pínahdih chãjcan, wã náahatboodíh chãjat caá náahap. Wĩ́ih ã jʉmat jíib yeejép yapna yʉhna, weemdíh páantjeh cádahcat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ded weemdíh jepahcanni, ã weñat pínahdihjeh chãjni, iiguípna ã bejbipna caá. Obohjeéhtih, ded weemdíh cádahcanniboó bita caandíh yeejép ĩ chãjachah yʉhna, páantjeh wãjeéh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Cã́ac nin baácboó jʉm jwʉhna, dawá bií déedih bíbohna yʉhna, Diosdih náahcan, iiguípna bejna, nihat ã bíbohat dedé pínah nihcan caá. Iiguípboó jʉmna, ded pah ã jéih jíib chãj baccan niít. ");
INSERT INTO cbv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Weém nihat cã́acwã ʉ́ʉd jeñé wã íip ã yeh iigátjĩh ã́ih ángelwã biícdih nin baácboó jwʉ́ʉb dei jʉ̃óhnit,nihat cã́acwã ded pah ĩ chãjatji jíib wã jíib wʉ̃hbipna caá. Tʉ́i chãjnitjidih wã tʉ́i chãjbipna caá. Obohjeéhtih, tʉ́i chãjcannitjiboodíh wã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yoobópdih yeebdíh wã naóhna caá. Biquína ninjĩh ñʉhnit ñi wʉnat pínah jã́tih, weém nihat cã́acwã ʉ́ʉd jeñé chah maáh wã jʉmatdih ñi enbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis yeó jáap tʉ́ttimah, Pedro, Santiago, ã ʉ́ʉd Juan queét biíc peihcannitdihjeh jap bóo jeená Jesús ã nʉmah pʉ́ʉh laab béjep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Caanná ĩ pʉ́ʉh laáb jʉibíát tʉ́ttimah, ĩ enechah, ã jígohat ãt tʉ́ʉt nʉʉmʉ́p wʉt jĩ. Ã́ih móot yeó ã yeh iigát pah yeh iíg, ã́ih yéguehbʉt biíc yoobó tʉ́i baabní ãt yeh iiguíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Páant ã yeh iiguíchahjeh, Moisés, Elíasji biícdih Jesús pebh jígohnit, caandíh ĩt míic wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Páant ã yapachah ennit, Pedroboó Jesúsdih nin pah ãt niijíp wʉt yʉh jĩ: —¡Maá, ninjĩh jwĩ jʉmʉchah, ã tʉ́ina caá! Ma náahachah, biíc peihcanni mʉʉ dáhna jwĩ chãjbipna caá. Míih pínah, Moiséíh pínah, Elíaíh pínahdihbʉt jwĩ chãj wʉ̃hbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Obohjeéhtih, páant ã niijíchahjeh, tʉ́i yeh iigní mah põh panihni queétdih ãt dei jʉyʉ́p wʉt jĩ. Páant ã dei jʉyʉ́chah, caán chawat yoób nin pah Dios ãt niijíp wʉt jĩ: “Nin wã wʉ̃ʉ́h wã oini caá. Caandíh bʉ́dí wã wẽina caá. Pánihna, ã naáwáchah, caandíh ñi tʉ́i joyoó”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Páant ã niíj wéhenachah joinít, ʉ́ʉmna, ã bohénit ĩt páah yoh ñajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Páant ĩ páah yoh ñajachah ennit, Jesús ĩ pebhna jʉí, queétdih teo jã́hanit, —Ñi ñah ñʉhʉʉ́. Bʉtéh ñi ennidih, ñi joinídihbʉt ñi ʉ́ʉmca bojoó, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Páant ã niijíchah joinít, ñah ñʉhna, Jesúsdihjeh ĩt enep wʉt jĩ. Bita ĩ ennitjiboó ĩt wihcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tʉ́ttimah, jeemánt dei jʉ̃óhna, Jesús queétdih nin pah ãt niíj wʉtʉp wʉt jĩ: —Bʉtéh ñi enatjidih bitadih ñi naóh jwʉhca bojoó. Weém, nihat cã́acwã ʉ́ʉd jeñé, wʉnniji wã jwʉ́ʉb boo pʉd jʉ̃ʉ́wát tʉ́ttimah, caandíh bitadih ñi naáwáchah, ã tʉ́ibipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Páant ã niijíchah joinít, queét biíc peihcannit caandíh nin pah ĩt niíj ʉʉ́bh joí enep wʉt jĩ: —‘Dios ã wahni, ã jʉ̃ʉ́wát pínah jã́tih, Elíasboó ã jʉ̃óhbipna caá’, Moisés ã wʉtatjidih bohénit ĩpĩ́ niíj bohéna caá. ¿Dépah niíjíh tigaá queét páant ĩ niíj? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Yoobópdih tigaá ĩ niíj naáwáp. Elíasdih Dios ã jwíih jʉ̃ʉ́wát tʉ́ʉtʉp jĩ, nihatdih ã ámohat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Páant niijnít, nin pah yeebdíh niijná caá wã chãjap. Elías wãát jʉí péanap be. Páant ã jʉyʉ́chah yʉhna, yeebdíh bohénit caandíh ĩt beh encap jĩ. Pánih beh encan, ded pah ĩ náahat pahjeh caandíh ĩt chãjap taga. Páant ĩ chãjat pahjeh mʉntih, weemdíhbʉt ĩ chãjbipna caá. Páant ĩ chãjachah, weém nihat cã́acwã ʉ́ʉd jeñé, yeejép wã yapbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Páant ã niíj naáwáchah joinít, “ ‘Elías’, niijná, Juan Daabánidih naóhna caá ã chãjap”, niijnít, queét ĩt beh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pánih míic wéhe dei jʉ̃óhnit, jeé ñaj deyepboó Jesús biíc peihcannit ã pej jʉmnit biícdih ã jwʉ́ʉb dei jʉyʉ́p jĩ. Páant ĩ jwʉ́ʉb dei jʉyʉ́chah, dawá cã́acwã cãtíh jʉ̃óhnit, biíc newé Jesús pebh jʉinít, ã bódicha caj yoh ñajap jĩ. Pánih bódicha caj yoh ñajnit, nin pah Jesúsdih ã niíj naáwáp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Maá, wã wʉ̃ʉ́hdih ma jĩ́gah eneé. Caandíh wãá wʉnat ã ñahachah, yeejép ãpĩ́ yapna caá. Dawá láa tʉʉ cʉ́ʉtboó ãpĩ́ bʉʉ́g cáona caá. Biíh láa mʉjboó ãpĩ́ daab yóh bejna caá. ");
INSERT INTO cbv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pánihna, caandíh ĩ booaat pínah niijná, ma bohénit pebh caandíh wã ʉb jʉyʉ́p yʉh be. Obohjeéhtih, queét caandíh ĩ jéih booacap be, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Páant ã niijíchah joinít, Jesús nin pah ã niijíp jĩ: —Yeéb yeejépwã weemdíh jenah joicánnit ñi jʉmna caá. ¿Débólih maatápdih tigaá weemdíh tʉ́i jenah joicán, ñi tac bʉʉgábi? Wã pebh caandíh ñi ʉb jʉ̃ʉ́wʉ́, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Páant ã niijíchah joinít, Jesús pebh ã wʉ̃ʉ́hdih ĩ ʉb jʉyʉ́p jĩ. Páant ĩ ʉb jʉyʉ́chah, caandíh wʉnat tʉ́ʉtni nemépdih Jesús ã bacat tʉ́ʉtʉp jĩ. Páant ã wʉtʉchahjeh, ã bacachah, wʉnnijiboó ã tʉ́i boonap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Páant ã yapat tʉ́ttimah, jwiít ã bohénit míicjeh jʉmna, Jesúsdih nin pah jwĩ niíj ʉʉ́bh joyóp jĩ: —¿Dépanih tigaá jwiítboó caán nemépdih jwĩ wʉtʉchah yʉhna, ãt baccan? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Wã wẽpatdih yeebdíh wã wʉ̃hʉchah yʉhna, caandíh náhnican, weemdíh ñit tʉ́i jenah joicáp taga. Yoobópdih yeebdíh wã naóhna caá. Mostaza tíbih ã jʉmat pah, yeéb Dios ã wẽpatdih bainíjeh ñi tʉ́i jenah joiná yʉhna, nin pah ñi jéih chãjbipna caá: Nin jeedíh ‘Conboó ma bejeé’, ñi niijíchah, ã bejbipna caá. Pánih tʉ́i jenah joiná, nihatdih ñi jéih chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Obohjeéhtih, pánihni nemépdih ñi bacaat tʉ́ʉt niijná, Diosdih bʉ́dí ʉʉ́bát caá náahap. Pánih ʉʉ́bhna, jeémp jwʉhcan, Dios ã wẽpatdih chah ñi tʉ́i jenah joibípna caá. Pánih chah jenah joinít jʉmna, pánihnit nemépwãdihbʉt ñi jéih bacat tʉ́ʉtbipna caá, jwiítdih Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea baácboó Jesús biícdih jwĩ bejechah, caán jwiítdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Weém nihat cã́acwã ʉ́ʉd jeñédih cã́acwã teonit, bitadih ĩ wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Páant ĩ wʉ̃hat tʉ́ttimah, queétboó weemdíh ĩ mao yohbipna caá. Páant ĩ maoniji biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá, ã niijíp jĩ. Páant ã niíj naáwáchah joiná, bʉ́dí jwĩ jĩ́gahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaum tʉ́tchina jwĩ jʉibínachah, Dioíh mʉʉdíh ĩ en dawát jíib ʉbnitboó Pedro pebhna jʉibínit, caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Yeebdíh bohéniboó Dioíh mʉʉdíh en dawát jíib pínahdih ã jíib chãjcan niít? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Ã jíib chãjbipna caá, Pedro ãt niíj jepahap wʉt jĩ. Páant ã niiját tʉ́ttimah, jwĩ jʉmni mʉʉná Pedro ã waadáchah, Jesúsboó caandíh nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Simón, dépah tigaá ma niíj jenah joí? ¿Nin baácdih moón ĩ maáta detboodíh tigaá ĩ jíib ʉb, ma jenah joyóchah? ¿Ĩ́ih baácdih moondíh niít? ¿Biíh baácdih moónboodíh niít ĩ jíib ʉbʉp, ma jenah joyóchah? Pedrodih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Biíh baácdih moondíh tigaá ĩpĩ́ jíib ʉbʉp, Pedro ã niíj jepahap jĩ. —Pánihna, maáta ĩ́ih baácdih moónboodíh ĩpĩ́ jíib ʉbcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Páant ĩ jíib ʉbcah yʉhna, queét jíib ʉbnitdih íijaíhcan, jwĩ jíib chãjbipna caá. Íimboó queéj wáyadih ma bejeé. Caán jeémpni queejdíh ʉbnit, ã́ih jacna dinero jʉ́dʉdih ma bid jʉibípna caá. Caán jʉ́dʉ jwiít chénewãíh jíib pínahdih ʉbnit, jwĩ jíib bʉʉdáátdih jíib chãjadih ma bejeé, Jesús Pedrodih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Caán láa jwiít ã bohénit Jesús pebh jʉibínit, nin pah caandíh jwĩ niíj ʉʉ́bh joyóp jĩ: —¿Dios ã maáh jʉmʉpboó jwĩjeéh jʉmni déhe tigaá jwĩ maáh panihni ã jʉmbi? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Páant jwĩ niijíchah joinít, Jesús wébítdih jʉ̃ʉ́wát tʉ́ʉtnit, caandíh jwĩ cãtíh ã ñʉhat tʉ́ʉtʉp jĩ. Páant ã ñʉhʉchah, jwiítdih nin pah ã niíj naáwáp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Yoobópdih yeebdíh wã naóhna caá. Ñi jenah joyátdih tʉ́ʉt nʉʉmnít, wébít oboh jʉmnit ĩ jenah joyát pah jenah joinít, Dios ã maáh jʉmʉpboó ñi jéih waadbípna caá. Obohjeéhtih, caán dée pah ñi jenah joicán, Dios ã maáh jʉmʉpboó ñi jéih waadcán niít. ");
INSERT INTO cbv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pánihna, det wébít ĩ jenah joyát pah jenah joinít, Dios ã maáh jʉmʉpboó chah wʉtnit ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Det wĩ́ihwã jʉmna, wã wʉtat pah bita nin wébít panihnidih wẽi jwãáhnit, weemdíhbʉt ĩ wẽi jwãáhna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nin wébít panihni weemdíh tʉ́i jenah joinídih ded ã yéej chãjat tʉ́ʉtatji jíib, Dios caandíh yeejép pohba ã peéh chãjbipna caá. Pánihna, caandíh ã yéej chãjat tʉ́ʉtat pínah jã́tih, ã́ih bʉtdih bʉ́dí jeé jʉ́dʉjĩh chéo bʉ́ʉdhnit, bʉ́dí mʉjna caandíh ĩ yohochah, ãta tʉ́i taga. Páant ĩ chãjachah, caán wébít panihnidih ã yéejacah nihna, Dios páant bóo pohba caandíh ãta peéh chãjcan taga. ");
INSERT INTO cbv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ded bitadih yéej chãjat tʉ́ʉtnidih Dios bʉ́dí ã peéh chãjachah, tʉbit yeejép ã yapbipna caá. Bitadih yéej chãjat tʉ́ʉtnit páantjeh ĩ jʉmbipna caá. Obohjeéhtih, queétboó yeejép yoobát ĩ yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Míih téihyajĩh, jítchajĩh yéej chãjna, caandíh ma bóod yohat pah, caán yéej chãjatdih ma cádahaá. Caandíh cádahcan, iiguípna ma bejbipna caá. Caanná iigát ã dʉbcan niít. Caandíh ma yohochah nihna, caan dáhjeh ãta bʉʉd tágaá. Meémboó pánihni cólohjeh jʉmna yʉhna, tʉ́ttimah Diosjeéh ma tʉ́i jʉmbipna caá. Obohjeéhtih, caandíh bóod yohcan nihna, chénat pah dahjĩh iiguípna ma bejechah, bʉ́dí yeejép mata yap tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pánihat pah mʉntih, míih quíibjĩh ennit, yéej chãjna, caan dáhdih ma wã́at yohat pah, caán yéej chãjatdih ma cádahaá. Caandíh cádahcan, iiguípna ma bejbipna caá. Caanná iigát ã dʉbcan niít. Caan dáhdih ma yohochah nihna, caan dáhjeh ãta bʉʉd tágaá. Biícjĩh quíib wihcan yʉhna, tʉ́ttimah Diosjeéh ma tʉ́i jʉmbipna caá. Obohjeéhtih, míih quíib chénat pah dahjĩh iiguípna ma bejechah, chah yeejép mata yap tagaá. Pánihna, yéej chãjatdih cádahat caá náahap”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nin wébít panihnidih ñi en iicá bojoó. Yeebdíh yoobópdih wã naóhna caá. Queét wébítdih ded pah ĩ yapachah Diosdih naáwát tʉ́ʉt niijná, queétdih en daonít ángelwã wã íip pebhna ĩpĩ́ bejna caá. ");
INSERT INTO cbv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Weém nihat cã́acwã ʉ́ʉd jeñé, nin baácdih moón yeejép chãjnit, iiguípna bejnit déedih tʉ́i ʉbʉdih wã jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Queét iiguípna bejnit, bʉʉdnít ovejawã panihnit ĩ jʉmna caá. Pánihnit ĩ jʉmʉchah, nin wã naáwátdih ñi tʉ́i jenah joyoó: Cien ovejawãdih bíbohni biíc oveja ã bʉʉdʉ́chah ennit, ¿ded pah tigaá ã chãjbi, yeéb ñi jenah joyóchah? Bita noventa y nueve ovejawãdih ĩ jeémát yílip jʉmʉpboó jwejnit, caán bʉʉdnídih bididih ã bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yoobópdih yeebdíh wã naóhna caá. Caán bʉʉdnídih ã bid jʉyʉ́chah, ã jwejnit noventa y nuevedih ã weñat chah caán ã bid jʉiníboodíh ã wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pánihat pah wã íip jeáboó jʉmni nin oboh jʉmni panihni bʉʉdnít ĩ jʉmatdih ã náah yaccan caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ded weemdíh jepahni meemdíh ã yéej chãjachah, míic ámohat tʉ́ʉt niijná, bita ĩ joicápboó caandíh míic wéhenadih ma bejeé. Páant ma niijíchah joinít, ã jepahachah, ñi jwʉ́ʉb míic pej jʉmbipna caá, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Obohjeéhtih, meemdíh ã jepahcah bácah, Dios ã wʉtat pah, bita chénewãdih ma nʉmah bejeé, queét ĩ joyóchah, caandíh míic wéheat tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yeéb biíc peihcannitdih ã jepahcah enna, wĩ́ihwã nihat ñi míic wáacapna caandíh ñi nʉmah bejeé, ã yéej chãjatdih ma naáwáchah, queét nihat ĩ joyát pínah niijná. Pánihna, míic wáacnitdihbʉt ã jepahcah enna, Diosdih náahcan, ã yéejatdih cádahíhcat peéh, caandíh ñi pej jʉm cádahaá. ");
INSERT INTO cbv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yoobópdih yeebdíh wã naóhna caá. Ded ã yéej chãjatdih cádahcat jíib, ‘Meém yéejatdih yohcanni ma jʉmna caá’, yeéb wĩ́ihwã ñi niijíchah, Diosbʉt caandíh biíc yoobó ã niijbípna caá. Ded ‘Wã yéej chãjatdih jĩ́gahnit, wã cádahna caá’, niijnídih ‘Meém yéejatdih yohni ma jʉmna caá’, ñi niijíchah, Diosbʉt caandíh biíc yoobó ã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Chénewã, biíc peihcannit wĩ́ihwã ñi míic wáacachah, ñijeéh wã jʉmna caá. Pánihna, det chénewã Diosdih ñi ʉʉ́bát pínahdih biíc yoobó ñi jenah joyóchah, wã íip jeáboó jʉmni ñi ʉʉ́bát pah ã chãjbipna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Páant Jesús ã niijíchah joiníji Pedro ã pebh jʉibínit, nin pah caandíh ã niijíp jĩ: —¿Maá, wã dée dawá láa weemdíh ã yéej chãjachah, débói láa tigaá caán ã yéej chãjatdih wã íij cádahbi? ¿Siete láa cádahat ã náah niít? ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—¡Ma joyoó! Biíh meemdíh dawá láa ã yéej chãjachah yʉhna, siete láajeh íij cádahat ã náahcan caá. Obohjeéhtih, páant ã yéej chãjachah yʉhna, meémboó caandíh ma jwʉ́ʉb náhnica bojoó, Pedrodih Jesús ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Bita ĩ yéej chãjatdih quíib bʉʉdátdih jenah joinít, nin wã naáwátdih ñi tʉ́i jenah joyoó: Dios ã maáh jʉmat nin pah ã jʉmna caá. Biíc baácdih moón ĩ maáh ã pebh moón caandíh ĩ jíib bʉʉdánachah, ĩ jíib bʉʉdáátdih ã jíib chãj beedáát tʉ́ʉtʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ĩ jíib bʉʉdáátdih ã jenah enechah, biíc caandíh teo wʉ̃hniboó bʉ́dí yoobát ã jíib bʉʉdánap be. Bʉ́dí ã jíib bʉʉdáátdih jéihnit, caandíh ã pebh ã bid bojop be. ");
INSERT INTO cbv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ã jéih jíib chãjcah enna, ã maáhboó caandíh, yad, ã weh, nihat ã́ih bií dée biícdih bitaboodíh ã jíib chãjat tʉ́ʉtʉp be, queét ĩ jíibjĩh ã jíib bʉʉdáátdih ã jíib chãjat tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Páant ã jíib chãjat tʉ́ʉtʉchah joinít, caán bʉ́dí jíib bʉʉdániboó ã maáh pebh bódicha caj yoh ñajnit, bʉ́dí ã ʉʉ́bʉ́p be. ‘Maá, weemdíh jĩ́gah ennit, ma pã́i jwʉhʉʉ́. Meemdíh wã jíib bʉʉdáátdih wã jíib chãj beedábipna caá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Páant ã niíj ʉʉ́bʉ́chah joinít, caandíh jĩ́gah ennit, ‘Weemdíh ma jíib bʉʉdáát ã jʉmʉ naáh’, ã maáh caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Páant ã niiját tʉ́ttimah, bʉ́dí jíib bʉʉdánijiboó bac bejnit, biíh caán biícdih ĩ maáhdih teo wʉ̃hnidih ã jwãááp be. Pánih jwãáhnit, caánboodíh bainí ã jíib bʉʉdáátdih íijnit, ã́ih bʉt nahdih jõp teonit, ‘¡Weemdíh ma jíib bʉʉdáátdih waícanjeh ma jíib chãjaá!’ caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Páant ã niijíchah joinít, caán bainí jíib bʉʉdániboó ã pebh bódicha caj yoh ñajnit, caandíh bʉ́dí ã ʉʉ́bʉ́p yʉh be. ‘Weemdíh jĩ́gah ennit, bainí ma pã́i jwʉhʉʉ́. Meemdíh wã jíib bʉʉdáátdih wã jíib chãj beedábipna caá’, ã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Obohjeéhtih, páant ã niíj ʉʉ́bʉ́chah yʉhna, caandíh jĩ́gah encanjeh, caánboó ã jepahcap be. Pánih jepahcan, caán teo wʉ̃hnidih nemat mʉʉ́boó ã nemat tʉ́ʉtʉp be. Ã jíib chãj beedánachahna, caandíh ãta baca tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Pánihna, bʉ́dí jíib bʉʉdániji bainí jíib bʉʉdánidih páant ã chãjachah enna, íijnit, bita teo wʉ̃hnitboó ĩ maáhdih naóh yacadih ĩ bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Páant ĩ naóh yacachah joinít, ĩ maáh ĩ naóh yacnidih bid bojnit, nin pah caandíh ã niíj jʉ̃ihñʉp be: ‘¡Meém yeejép pohba caá! Meém weemdíh bʉ́dí ma ʉʉ́bʉ́chah, “Bʉ́dí ma jíib bʉʉdáátdih ã jʉmʉ naáh”, wã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Obohjeéhtih, meemdíh páant wã niijíchah yʉhna, bac bejnit, meemdíh bainí jíib bʉʉdánidih meémboó mat jĩ́gah encap wʉt be. Ma jíib bʉʉdáátdih wã náhnicat pah mʉntih, caánboó meemdíh ã jíib bʉʉdáátdih ma náhnicah, ãta tʉ́i tagaá. ¿Dépanih tibeé caandíh jĩ́gah encanjeh, páant ma chãj?’ ã maáh caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Páant niijnít, bʉ́dí íijnit, nemat mʉʉ́boó caandíh ã nemat tʉ́ʉtʉp be. Ã jíib chãj beedánachahna, ãta baca tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Caan páh tigaá Dios yeebdíh ã chãjbipna caá. Yeéb nihat ñi déewã yeebdíh yeejép ĩ chãjatjidih ñi quíib bʉʉdcáh ennit, caánboó yeéb ñi yéej chãjatjidihbʉt biíc yoobó ã quíib bʉʉdcán niít”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Páant niíj naóh péanit, caán Galilea baácboó jʉmniji Judea baácna Jesús jwiítdih ã nʉmah bejep jĩ. Pánih bejnit, caanná jʉibína, Jordán mʉjdih chʉ́ʉh bejnit, conanaamánt jwĩ jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pánih caanná jʉibínit, jwĩ jib bejechah, dawá cã́acwã jwiítdih ĩ péenap jĩ. Páant ĩ péenachah ennit, ĩjeéh bejnit wʉnnitdih Jesús ã booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Páant jwĩ bejechah, jwiítdih jwãáhnit, biquína fariseowã nin pah Jesúsdih ĩ niíj ʉʉ́bh joyóp jĩ, ded pah ã jepahachah joinít, caandíh naóh yacat tʉ́ʉt niijná: —¿Jwĩ weha mána yaádhdih jwĩ yohochah, ãta tʉ́i taniít? ¿Dios ã wʉtatboó páant niít ã chãjat tʉ́ʉtʉp, ma jenah joyóchah? ĩ niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—¿Moisés nin pah ã niíj daacátjidih ñi bohé jwʉhcannit jĩí? ‘Dios biíhmah nin baácdih chãjni newé yaddihbʉt ãt chãjap wʉt jĩ’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Páant niíj daácnit, nin pahbʉt ãt jwʉ́ʉb niíj daacáp tajĩ: ‘Páant ã chãjachah, newé ã mánadih cádahnit, yadjĩh biícdih ã jʉmbipna caá. Pánih jʉmna, queét chénewã jʉmna yʉhna, biíc bácah panihnit caá ĩ jʉmʉp’, ãt niíj daacáp tajĩ.¿Páant ã niíj daacátjidih ñi bohé jwʉhcannit jĩí? ");
INSERT INTO cbv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Páant ã daacátji pah queét chénewã jʉmnitji biíc bácah pah ĩ jʉmna caá. Pánihna, ĩ téihya chéwechah, Diosjeh tigaá queétdih biícdih ã jʉmat tʉ́ʉtna caá. Páant biícdih ã chãjachah, queétjeh ĩ míic cádahcat caá náahap, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Páant ã niijíchah joinít, queét fariseowã nin pah ĩ jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ, páant mʉntih: —Meém páant ma niijíchah yʉhna, Moisésjeh nin pah ãt niíj daacáp tajĩ: ‘Majeéh bólidih yohíhna, “Meém ma tʉ́icat enna, meemdíh wã yohna caá”, niíj daácnit, caántdih ñi wʉ̃hʉʉ́. Páant niíj daác wʉ̃hnit, majeéh bólidih ma yohochah, ã tʉ́ina caá’, Moisés ãt niíj daacáp tajĩ. ¿Páant ma niijíchah yʉhna, Moisésboó dépanih tigaá páant ãt niíj daácji? ĩ niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Ñi nʉowã Diosdih ĩ yap yohochah enna, Moisés nin pah ãt niíj daacáp tajĩ ‘Ĩ weha mánadih yohna, páant tií ĩ chãj dáhwa naáh’, ãt niíj daacáp tajĩ. Páant ã niijíchah yʉhna, biíhmah pohba páant ãt nihcap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Obohjeéhtih, weémboó yeebdíh nin pah wã naóhna caá: Ded ãjeéh bólidih yohna, biíhjĩh mi yeejép chãjcah yʉhna, biíh wilidih jwʉ́ʉb áa jʉmna, caántjĩh yeejép chãjna caá ã chãjap. Pánihna, ã yohnihjidih áa jʉmnibʉt caántjĩh yeejép ã chãjna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Páant ã niijíchah joinít, jwiít ã bohénit caandíh nin pah jwĩ niijíp jĩ: —Páant newé yadjĩh ĩ míic yohat ã tʉ́icah, áa wihcah ãta tʉ́i tagaá, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—Yeéb ñi niiját pahjeh tigaá ã jʉmʉp. Dios biquína ã ñíonitdihjeh ã áa jʉmat tʉ́ʉtcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Biquína neoná yaádhdih náahcannit pínah ĩ cã́ac jʉmna caá. Bitadih ĩ́ih quehli tíibnadih ĩ íib yohochah, yaádhdih náahcannit ĩ jʉmna caá. Bitaboó Diosdih teo wʉ̃hnit jʉmat tʉ́ʉt niijná, yaádhdih ĩ bidcan caá. Pánihna, ded tʉ́i joiní jʉmna, Diosdih teo wʉ̃hat tʉ́ʉt niijná, páant tigaá jʉmat náahap, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Páant jwiítdih ã naáwát tʉ́ttimah, Jesús queétdih ã teo jã́ha ʉʉ́bát pínah niijná, cã́acwã ĩ wehdih ã pebhna ĩ ʉb jʉyʉ́p jĩ. Páant ĩ ʉb jʉyʉ́chah ennit, jwiít ã bohénitboó queétdih jwĩ jípónih jʉ̃ihñʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Páant jwĩ jʉ̃ihñʉchah joinít, Jesús jwiítdih nin pah ã niijíp jĩ: —Wébít wã pebh ĩ jʉ̃ʉ́wʉ́ naáh. ‘Ñi bejca bojoó’, queétdih ñi niijcá bojoó. ‘Dios wã maáh caá’, niijnít, queét wébít caá tʉ́i jenah joinít ĩ jʉmʉp. Pánihna, Dios ã maáh jʉmʉpna waadnítboó nit wébít ĩ jenah joyát pah jenah joinít ĩ jʉmna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Páant niijnít, queét wébítdih ã teo jã́ha ʉʉ́bʉ́p jĩ. Pánih ʉʉ́bh péanit, jwiítdih ã jwʉ́ʉb nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Páant jwiítdih ã nʉmah bejechah, biíc newé Jesús pebh jʉinít, nin pah caandíh ã niíj ʉʉ́bh joyóp jĩ: —¿Bohéní, páantjeh Diosjeéh jʉmíhna, ded pah tigaá tʉ́inidih wã chãjbi? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Dépanih tigaá tʉ́i chãjat pínahdih weemdíh ma ʉʉ́bh joí? Diosjeh caá tʉ́ini. Páantjeh Diosjeéh jʉmíhna, ã wʉtat pah ma chãjaá, caandíh Jesús ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ded wʉtatdih niij tígaá ma chãj? ã niíj jwʉ́ʉb ʉʉ́bh joyóp jĩ. —Cã́acwãdih ma mao yohca bojoó. Ma áa nihcannijĩh ma yéej chãjca bojoó. Ma nʉʉmcá bojoó.Ma yeeca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma mánadih ma tʉ́i chãjaá.Meemjéh ma míic oyat pah bitadihbʉt ma oyoó.Nin wʉtatdih jepahat caá náahap, Jesús caandíh ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Caán wʉtatdih weém wãpĩ́ yap yohcan caá. ¿Diosjeéh tʉ́i jʉmat tʉ́ʉt niijná, ded panihat tigaá weemdíh páantjeh ã jʉdh? Jesúsdih ã jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Meém yéejat wihcanni jʉmíhna, nihat míih bií déedih jíib chãj wʉ̃hʉdih ma bejeé. Pánih jíib chãjnit, nihat ma jíib teonidih moh yéejnitdih ma jwʉ́ʉb wʉ̃hʉʉ́. Páant ma wʉ̃hʉchah, nin baácboó ma bíbohatji chah tʉ́ini míih pínah Dios pebhboó ã jʉmbipna caá. Pánih queétdih wʉ̃h péanit, wãjeéh ma jʉ̃ʉ́wʉ́, Jesús caandíh ã niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Obohjeéhtih, páant ã niijíchah joinít, dawá bií déedih bíbohni jʉmna, ã́ih bií déedih jíib chãj wʉ̃híhcan, bʉ́dí ã jĩ́gahap jĩ. Pánih jĩ́gahnit, jepahcanjeh, ã jwʉ́ʉb bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Páant ã bejechah ennit, Jesús jwiítdih nin pah ã niíj naáwáp jĩ: —Yoobópdih yeebdíh wã naóhna caá. Ded dawá bií déedih bíbohni Dios ã maáh jʉmʉpboó ã bejíhichah yʉhna, caandíh ã bʉona caá. ");
INSERT INTO cbv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Camelloboó awí íitbitdih ã yabac bejíhichah nihna, ãta bʉo tagaá. Pánihat pah, dawá bií déedih bíbohni Dios ã maáh jʉmʉpboó ã waádíhichah yʉhna, bʉ́dí ã bʉona caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Páant ã niijíchah, joí wʉ́hi bejnit, nin pah Jesúsdih jwĩ niijíp jĩ: —Páant ma niijíchah bácah, Dios ã jʉmʉpboó ded ã jéih waadcán niít, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","—Cã́acwã ded pah ĩ jenah joyátjĩhjeh ĩ tʉ́i chãjíhna yʉhna, Dios pebhboó ĩ jéih bejcan niít. Diosjeh caá iiguípna bejnit déedih ã tʉ́i ʉbʉp. Caanjéh tigaá nihatdih chãj beedáni. Dedé jéihcat pínah caandíh ã wihcan caá, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Páant ã niijíchah joinít, Pedroboó caandíh nin pah ã niijíp jĩ: —Maá, weemdíh ma joi jwʉ́hʉʉ́. Majeéh péeat tʉ́ʉt niijná, jwiítboó nihatdih jwĩ cádahap jĩ. ¿Páant jwĩ chãjat jíib, dedédih tigaá jwiítdih ma wʉ̃hbi? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Yoobópdih yeebdíh wã naóhna caá. Péeni yeó jáap tʉ́ttimah, nihat jáap míic ã tʉ́ʉt nʉʉmbípna caá. Caán láa weém nihat cã́acwã ʉ́ʉd jeñé, jeáboó maáh wã jʉmbipna caá. Páant maáh wã jʉmʉchah, yeéb wã bohénitboó judíowã doce poómpnadih wãjeéh wʉtnit ñi jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ded weemdíh teo wʉ̃hat tʉ́ʉt niijná, ã́ih mʉʉ́, ã mána, ã déewã, ã weh, ã́ih wápchidih yʉh bʉca ã cádahachah, Diosboó caandíh chah ã jwʉ́ʉb wʉ̃hbipna caá. Pánih cádahnit, weemdíh teo wʉ̃hnitboó Diosjeéh páantjeh ĩ tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Obohjeéhtih, nin baácboó dawá maáta panihnitji Dios pebhboó oboh jʉmnit ĩ jʉmbipna caá. Nin baácboó dawá oboh jʉmnitji jeáboó maáta ĩ jʉmbipna caá, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Dios ã maáh jʉmat nin pah ã jʉmna caá: Iguíha mínah cheibitjeh ã́ih iguíhadih teo wʉ̃hnit pínahdih bididih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pánih bejnit, jwãáhna, queétdih nin pah ã niijíp be: ‘Wĩ́ih iguíhadih ñi teo wʉ̃hat jíib jwĩpĩ́ jíib chãjat pah yeebdíh wã wʉ̃hbipna caá’, ã niijíp be. Páant ã niijíchah joinít, tewedih ĩ bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Las nueve dée, jíib chãjat tólihna pebhboó ã bejep be. Pánih bejnit, bita caanjĩ́h ñʉhnitdih ã enep be. ");
INSERT INTO cbv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pánih ennit, queétdihbʉt nin pah ã niijíp be: ‘Yeebbʉ́t wĩ́ih iguíhaboó tewedih ñi bejeé. Teo cádahat horadih ñi tewat jíib wã wʉ̃hbipna caá’, queétdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Páant ã niijíchah joinít, queétbʉt tewedih ĩ bejep be. Yeó jáap tac yoób bejna, bita ñʉhnitdih jwãáhnit, biíc yoobó queétdihbʉt ã niijíp be. Las tres dée bita ñʉhnitdih jwãáhnit, biíc yoobó queétdihbʉt ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Las cinco dée bita ñʉhnitdih jwãáhnit, nin pah queétdih ã niíj ʉʉ́bh joyóp be: ‘¿Dépanihna nihat yeó jáap teocan, ñʉh tigaá ñi chãj?’ ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Jwiítdih tewat wʉtni ã wihcan caá’, ĩ niíj jepahap be. Páant ĩ niijíchah joinít, iguíha mínah queétdih nin pah ã niijíp be: ‘Wĩ́ih iguíhana bejnit, ñi teobi jwʉhʉʉ́’, queétdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Cheyeh caán iguíha mínah caandíh teo wʉ̃hni maáhdih nin pah ã niijíp be: ‘Queét teonitdih jʉ̃ʉ́wát tʉ́ʉtnit, ĩ tewat jíib ma wʉ̃hʉʉ́.Pée jʉinítdih ĩ tewat jíib ma jwíih wʉ̃hʉʉ́. Páant queétdih ma wʉ̃hat tʉ́ttimah, ĩ jã́tih jʉinítdih ma wʉ̃hʉʉ́. Pánih queétdih jíib chãj péa, bita ĩ jã́tih jʉinítdih ma wʉ̃hʉʉ́. Queétdih wʉ̃h péa, bita ĩ jã́tih jʉinítdihbʉt ma wʉ̃hʉʉ́. Queétdih wʉ̃h péa, waóh jʉinítdih ma jíib wʉ̃hʉʉ́’, ã niijíp be. Pánihna, ã niiját pah queétdih ã jíib chãjap be. ");
INSERT INTO cbv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Las cinco dée tewedih jʉinítdih nihat yeó jáap ĩ tewat jíib pah bóo ã wʉ̃hʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Queét nihat teonitdih biíc yoobó ã wʉ̃hʉp be. Queét waóh tewedih jʉinítboó ‘Jwiítdih chah ã jíib wʉ̃hbipna caá’, ĩ niíj jenah joyóp yʉh be. Obohjeéhtih, queétdihbʉt biíc yoobó ã wʉ̃hʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Queétdih biíc yoobó míic ã jíib chãjachah enna, caandíh bʉ́dí íijnit, nin pah ĩ niíj jʉ̃ihñʉp be: ");
INSERT INTO cbv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Jwiítboó nihat yeó jáap, tʉbit ã chãhachah, bʉ́dí jwĩ tewechah, queét pée jʉinítboó biíc horabitjeh ĩ tewechah yʉhna, jwiít nihatdih biíc yoobó ma jíib wʉ̃hat, ã tʉ́ican caá’, caandíh ĩ niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Páant ĩ niíj jʉ̃ihñʉchah joinít, nin pah biíc ĩjeéh jʉmnidih ã niijíp be: ‘Meemdíh wã niijátji pah tigaá wã jíib chãjap. Ñi tewat jíib wʉ̃hnit, meemdíh wã yeecan caá. ");
INSERT INTO cbv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma tewat jíib ʉbnit, ma bejeé. Weém wã náahat pahjeh queét bainí teonitdihbʉt meemdíh wã wʉ̃hat biíc yoobó wã jíib wʉ̃hʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ded pah wĩ́ih dinerojĩh chãjna, wĩ́ih pínahjeh caá. Weém queét moh yéejnitdih jĩ́gah ennit, bʉ́dí wã jíib wʉ̃hʉchah enna, ¿yeébboó íij niít, páant ñi niijíp?’ iguíha mínah queétdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Pánihat pah tigaá det waóhnitji péenit ĩ jʉmbipna caá. Péenitjiboó waóhnit ĩ jʉmbipna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Páant niíj péanit, dawá cã́acwã jwĩjeéh ĩ péenachah, Jerusalén tʉ́tchina bejni namádih jwĩ bejep jĩ. Pánih bejna, chibít yʉʉ́p jwiítdih nʉmah waóh bejnit, jwiítdihjeh nin pah Jesús ã niíj naáwáp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalén tʉ́tchina bejna caá jwĩ chãjap. Caanná jwĩ jʉibíát tʉ́ttimah, weém nihat cã́acwã ʉ́ʉd jeñédih eníhcanniboó sacerdotewã ĩ maátadih, Moisés ã wʉtatjidih bohénitdihbʉt ã dʉó wáibipna caá. Páant ã dʉó wáyachah, weemdíh teonit, ĩ mawat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pánih mawat tʉ́ʉtnit, judíowã nihcannitdih ĩ jwʉ́ʉb wʉ̃h yapabipna caá. Queétboó weemdíh deohnit, ĩ pʉñat tʉ́ttimah, cruzboó ĩ péoh dodh mao yohbipna yʉh caá. Obohjeéhtih, biíc peihcanni yeó jáap tʉ́ttimah, wã íip weemdíh ã jwʉ́ʉb booabipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pánihat tʉ́ttimah, Zebedeo ã weh íinboó mi weh biícdih Jesús pebh jʉinít, caandíh ʉʉ́bát tʉ́ʉt niijná, mi bódicha caj yoh ñajap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Páant mi bódicha caj yoh ñajachah ennit, Jesús nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Ded pah wã chãjatdih tigaá ma náah? ã niijíp jĩ. —Maáh waadná, nit chénat pah wã weh meém biícdih ĩ wʉtat pínah niijná, biíc ma jéihyepmant bóo bʉwámant, biíhdih wáyámant bóo bʉwámant ma chʉ́ʉdat tʉ́ʉtʉ́, mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Ded pah ñi ʉʉ́bátdih ñi jéihcan caá. Ded wã maáh jʉmʉpboó jʉmíhni, weemdíh yeejép ã yapat pínah, biíc yoobó caandíhbʉt ã yapachah yʉhna, weemdíh cádahcat caá náahap. Pánih cádahcan, wã maáh jʉmʉpboó wãjeéh ã wʉtbipna caá. ¿Yeebdíhbʉt páant yeejép ã yapachah yʉhna, ñi cádahbican naniít? mi wehdih Jesús ã niijíp jĩ. —Jwĩ cádahcan niít, ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Yoobópdih yeebdíh wã naóhna caá. Yeejép wã yapat pah yeebbʉ́t biíc yoobó ñi yapbipna caá. Obohjeéhtih, wãjeéh wʉtnit pínahdih weémboó wã jéih ñíocan caá. Wã íipboó queétdih ãtát ñíwip taga, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Páant ĩ niíj ʉʉ́bʉ́chah joinít, jwiít diezboó queétdih jwĩ íijip jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Páant jwĩ íijatdih ennit, Jesús jwiít nihatdih ã míic wáacat tʉ́ʉtʉp jĩ. Páant jwĩ míic wáacachah, nin pah jwiítdih ã niíj naáwáp jĩ: —Judíowã nihcannit ĩ maátaboó ĩ́ih cã́acwãdih tʉbit wʉtnit ĩ jʉmatdih ñi tʉ́i jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Obohjeéhtih, queét wʉtnit ĩ jʉmat pah yeéb ñi jʉmca bojoó. Yeébboó maáta jʉmíhna, bitadih tʉ́i teo wáacnit ñi jʉmʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Waóhnit jʉmíhna, teo wʉ̃hnit pah jʉmat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Weém nihat cã́acwã ʉ́ʉd jeñéboó cã́acwã weemdíh ĩ teo wáacat pínah niijná, nin baácboó wã jʉ̃óhcap jĩ. Obohjeéhtih, cã́acwãdih teo wáacat tʉ́ʉt niijná, queét iiguípna ĩ bejat déedih wʉn wʉ̃hʉdih wã jʉ̃ʉ́wʉ́p be, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jwiít Jerusalén tʉ́tchina bejna, Jericó tʉ́tchidih jwĩ chóop yap bejep jĩ. Páant jwĩ chóop yap bejechah, dawá cã́acwãbʉt jwiítdih ĩ péenap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jericó wáihyat jʉ́dʉ jẽcdih bac bejnit, chénewã jéih encannit namá jwẽ́ejdih ĩ chʉ́ʉdʉchah, jwĩ enep jĩ. “Jesús, Nazaret tʉ́tchidih bóo caá ã yap bejep”, bita ĩ niijíchah joinít, nin pah ĩ niíj ñaác ejep jĩ: —¡Maá, David jʉima, Dios ã wahni jwiítdih ma jĩ́gah en teo wáacá! ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Páant ĩ niíj ñaacáchah joinít, cã́acwãboó queétdih jʉ̃ihnit, —¡Páant bóojeh! Ñi ñaác cádahaá, ĩ niijíp yʉh jĩ. Obohjeéhtih, páant ĩ niíj jʉ̃ihñʉchah yʉhna, queétboó joicánjeh, chah ĩ ñaacáp jĩ: —¡Maá, David jʉima, Dios ã wahni, jwiítdih ma jĩ́gah en teo wáacá! ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Páant ĩ niíj ñaacáchah joinít, Jesús chão ñʉ́h, ã pebhna jʉ̃ʉ́wát tʉ́ʉtnit, queétdih nin pah ã niijíp jĩ: —¿Ded pah wã chãjatdih tigaá ñi náah? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Maá, jéih enatdih caá jwĩ náahap, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Páant ĩ niijíchah joinít, Jesús queétdih jĩ́gah ennit, ĩ́ih quíibdih ã teo jã́hanap jĩ. Páant ã teo jã́hanachahjeh, ĩ yoób enep jĩ, bʉca. Pánih ennit, caandíh ĩ péenap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén tʉ́tchina tóah jʉibínit, Olivo wʉ̃t jʉmni pácahi jʉmni jeéboó jwĩ jʉibínap jĩ. Pánih jʉibí, pʉ́ʉh laab béjna, Betfagé wʉ̃t jʉmni tʉ́tchibitdih jwĩ tóah jʉibínap jĩ. Caanná jʉibínit, Jesús chénewã jwĩjeéh jʉmnitdih caán tʉ́tchina ã wahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Pánih wahnit, nin pah queétdih ã niíj wʉtʉp jĩ: —Con tʉ́tchina waadnít, burroma mi wʉ̃ʉ́h biícdih ñi enbipna caá. Pánih en, queétdih watnit, weemdíh ñi ʉb jʉ̃óh wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Páant ñi ʉb jʉ̃ʉ́wʉ́chah ennit, cã́acwã yeebdíh ĩ ʉʉ́bh joyóchah, nin pah ñi niíj jepahaá: ‘Jwĩ maáh queétdih ã náah jwʉhʉp be. Péanit, queétdih ã jwʉ́ʉbabipna caá’, ñi niijí, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Páant ã yapat pínahdih Dios naáwátdih naóh yapani Zacaríasji nin pah ãt niíj daacáp tajĩ: ");
INSERT INTO cbv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén tʉ́tchidih moondíh nin pah ma niíj naáwá: ‘Dios weemdíh nin pah ã niiját tʉ́ʉtʉp be: “Ñi eneé, ñi Maáh ñi pebhna ã jʉ̃óhna caá. Caán oboh jʉmni pah burro wʉ̃ʉ́hjih chʉ́ʉdni ã jʉ̃óhbipna caá”, Jerusalén tʉ́tchidih moondíh ma niijí’, weemdíh ã niijíp be”, Zacarías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús ã wahnitboó bejnit, ã niijátji pah ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burroma, mi wʉ̃ʉ́h biícdih ĩ ʉb jʉyʉ́chah, jwĩ́ih jih bóo yéguehdih tóo dʉgnit, burromajih mi wʉ̃ʉ́hjihbʉt jwĩ cáagap jĩ. Páant jwĩ cáagat tʉ́ttimah, Jesús caán burro wʉ̃ʉ́hjih ã pʉ́ʉh laáb chʉ́ʉdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pánih chʉ́ʉdnit, Jerusalén tʉ́tchina jwiítdih ã nʉmah bejep jĩ. Páant ã bejechah ennit, dawá cã́acwã ĩ́ih jih bóo yéguehdih tóo dʉgnit, Jesúsdih wẽina, namáboó ĩ jwej waáwáp jĩ. Bitaboó ĩ bóodniji táam nʉ́onadih ʉbnit, queétbʉt Jesúsdih wẽina, namáboó ĩ jwej waáwáp jĩ. Páant ĩ jwejniji chóona, nʉ́onajih Jesús ã bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Páant Jesús ã bejechah, ã waáwápmant moón, ã méimant péenitbʉt caandíh wẽinit, biícdih nin pah ĩ niíj ñaacáp jĩ: —¡David jʉima, Dios ã wahni, jwiítdih ma tʉ́i ʉbʉʉ́! ¡Meém jwĩ maáh pínahdih bʉ́dí jwĩ wẽina caá! ĩ niíj wẽi ñaacáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pánih bejnit, Jerusalén tʉ́tchina jwĩ waadáchah, caanjĩ́h jʉmnitboó en wʉ́hi bejnit, nin pah ĩ niíj míic ʉʉ́bh joyóp jĩ: —¿Nin déhe tigaá? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Nin Jesús, Galilea baác, Nazaret tʉ́tchidih bóo, Dios naáwátdih naóh yapani caá, bita queétdih ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jerusalén tʉ́tchina waadnít, Dioíh mʉʉ jóocmant bóo jʉʉ́hdih Jesús jwiítdih ã nʉmah waad béjep jĩ. Pánih waad béjnit, caánboó jíib chãjnitdih ã ñʉʉn yóh bacanap jĩ. Dinerodih tʉ́ʉt nʉʉmnít ĩ cáagat naanádih ʉb yoh ã́acanit, jopwãdih jíib chãjnitíh chʉ́ʉdat naanádihbʉt ã ʉb yoh ã́acanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pánih ʉb yoh ã́acanit, Jesús nin pah queétdih ã niíj jʉ̃ihñʉp jĩ: —Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘ “Wĩ́ih mʉʉ́ cã́acwã weemdíh ĩ ʉʉ́bát pínah mʉʉ́ caá”, Dios ã niijíp be’, ĩt niíj daacáp tajĩ.Obohjeéhtih, cã́acwã Diosdih ʉʉ́bʉ́dih ĩ jʉyʉ́chah yʉhna, yeébboó queétdih yeenit, nʉʉmná caá ñi chãjap. Pánih nʉʉmnít, Dioíh mʉʉdíh yéejanit, nʉʉmnít ĩ jʉmat pínah mʉʉ́ chãjna caá ñi chãjap, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Páant Dioíh mʉʉdíh Jesús ã jʉmat pónih, dawá jéih encannit, wʉ́ʉat nahjĩh bejnitbʉt ã pebhna ĩ jʉyʉ́p jĩ. Páant ĩ jʉyʉ́chah ennit, queétdih ã booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Obohjeéhtih, queétdih ã booanachah ennit, caanjĩ́h jʉmnit sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt Jesúsdih bʉ́dí ĩ íijip jĩ. Jwĩjeéh péenit wébítboó “¡David jʉima, Dios ã wahni, jwiítdih tʉ́i ʉbni pínah, meemdíh bʉ́dí jwĩ wẽina caá!” ĩ niíj ñaác cádahcah joiná, chah ĩ íijip jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Pánih íijnit, Jesúsdih nin pah ĩ niíj jʉ̃ihñʉp jĩ: —Meemdíh páant ĩ niíj ñaacáchah, ¿ma joicán niít? Páant ĩ niijcá bojo naáh, Jesúsdih ĩ niijíp jĩ. —Wã joiná caá. Obohjeéhtih, Davidji Dios naáwátdih naóh yapani nin pah ã niíj daacátjidih ¿yeébboó ñi bohécannit jĩí? ‘Wébítdih, bita ĩ tʉ́ʉhnitdihbʉt meém ma wẽi naáwát tʉ́ʉtna caá’, Diosdih wẽinit, David ãt niíj daacáp tajĩ, Jesús queétdih ã niíj jʉ̃ihñʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Páant niíj péanit, queétdih cádahnit, caán tʉ́tchimant Jesús jwiítdih ã nʉmah bac bejep jĩ. Pánih bac bejna, Betania tʉ́tchidih jʉibínit, caan chéi caanjĩ́h jwĩ ʉ̃wʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cheibit bóo yeó jáapdih, Betania tʉ́tchiboó ʉ̃onitji Jerusalén tʉ́tchina jwʉ́ʉb bejna, Jesúsboó ãt nʉʉgʉ́p wʉnʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pánih nʉʉgʉ́p wʉnna, namá jwẽ́ejdih lajni higuera nahdih ennit, ã́ih quehedih jeémíhna, caan náh pebh enedih ã bejep yʉh jĩ. Obohjeéhtih, caan náhboó quehcan, tʉ́ini wawájeh pohba ã jʉmʉp jĩ. Páant ã quehcatdih enna, —¡Ma jwʉ́ʉb quehcan niít! caan náhdih ã niijíp jĩ. Páant ã niijíchahjeh, ã́ih nʉ́ona ã diib téhah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Páant ã wʉnʉchah ennit, jwiít ã bohénitboó jwĩ en wʉ́hi bejep jĩ. —¿Dépanih tigaá waícanjeh ã wʉnah bej? Jesúsdih jwĩ niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Yoobópdih yeebdíh wã naóhna caá. Dios ã wẽpatdih tʉ́i jenah joiná, nin nahdih wã chãjat pahjeh mʉntih yeebbʉ́t ñi jéih chãjbipna caá. Páant wã chãjat chahbʉt ñi jéih chãjbipna caá. Con jeedíh ‘Conmant bejnit, bʉ́dí mʉjna ma bʉʉ́g báahá’, ñi niijíchah, ñi wʉtat pah ã yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Diosdih tʉ́i jenah joinít, ded pah caandíh ñi ʉʉ́bát pah ã chãjbipna caá, Jesús jwiítdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pánih bejna, Jerusalén tʉ́tchina jʉibí, Dioíh mʉʉdíh waad béjnit, Jesús cã́acwãdih ã jwʉ́ʉb bohénap jĩ. Páant ã bohéát pónih, sacerdotewã ĩ maáta, jwiít judíowã jwĩ maátabʉt ã pebh jʉinít, nin pah caandíh ĩ niíj ʉʉ́bh joyóp jĩ: —¿Deíh wẽpatjĩh tibeé jwíin páant ma chãj? ¿Déhe tibeé meemdíh páant ã wʉt? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Yeebdíh wã jwíih ʉʉ́bh joibípna caá. Weemdíh ñi tʉ́i jepahachah, weembʉ́t yeebdíh wã jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juan Daabánidih ¿déhe tigaá ãt wʉtji? ñi jenah joyóchah. ¿Dios ãt wʉtjican taniít? ¿Cã́acwãboó niít caandíh ĩt daabáát tʉ́ʉtjip? yeéb ñi jenah joyóchah, Jesús queétdih ã niíj ʉʉ́bh joyóp jĩ. Páant ã niíj ʉʉ́bh joyóchah joinít, queétjeh nin pah ĩt míic niijíp wʉt jĩ: “¿Ded pah tigaá jwĩ niíj jepahbi? ‘Dios caá Juandih ãt wʉtjip taga’, jwĩ niijíchah, ‘Páant ã jʉmʉchah yʉhna, ¿dépanih tijĩí caandíh ñi jepahcan?’ jwiítdih ã niíj jʉ̃ihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Obohjeéhtih, nitboó ‘Juan Dios naáwátdih naóh yapani yoobát ã jʉmʉp jĩ’, ĩ niíj jenah joiná caá. Páant ĩ niíj jenah joyóchah, ‘Cã́acwãjeh caandíh ĩt daabáát tʉ́ʉtjip taga’, jwĩ niíj jepahachah, jwiítdih bʉ́dí ĩ íijbipna caá”, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pánih míic wéhe péanit, nin pah Jesúsdih ĩ niíj jepahap jĩ: —Jwiít jwĩ jéihcan caá, ĩ niijíp jĩ. —Caán láa bácah weemdíh wʉtnidih weembʉ́t yeebdíh wã naóhcan niít, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Páant niíj péanit, jwĩ maátadih Jesús nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Nin wã naáwátdih ¿ded pah ñi niíj jenah joí? Biíc newé chénewã ã weh ĩ jʉmʉp be. Pánihna, biíc yeó jáap ĩ íipboó weép jeñédih, ‘Wʉ̃ʉhʉ́, bʉʉ wĩ́ih iguíhaboó tewedih ma bejeé’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Wã bejcan caá’, ã niíj jepahap be. Páant niijná yʉhna, jwʉ́ʉb jenah joinít, tewedih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tʉ́ttimah, ã ʉ́ʉddihbʉt biíc yoobó ã niijíp be. ‘Wã bejmi caá’, ã niíj jepahap yʉh be. Obohjeéhtih, páant niijná yʉhna, ã bejcap be. ");
INSERT INTO cbv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ded tigaá ã íipdih ã tʉ́i jepah? Jesús queétdih ã niijíp jĩ. —Weép jeñéboó ã tʉ́i jepahap be, queét ĩ niíj jepahap jĩ. —Yoobópdih yeebdíh wã naóhna caá. Romano maátadih nʉ́o ʉʉ́bh wʉ̃hnit, deoh nah jʉmnit yaádh biícdih yeéb jã́tih Dios ã maáh jʉmatdih ĩ waadná caá. ");
INSERT INTO cbv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Daabáni cã́acwãdih bohénadih jʉiná, ded pah ñi tʉ́i chãjat pínahdih yeebdíh ãt naáwáp tajĩ. Páant ã naáwáchah yʉhna, yeébboó caandíh ñit jepahcap tajĩ. Obohjeéhtih, queét nʉ́o ʉʉ́bh wʉ̃hnit, deoh nah jʉmnit yaádhbʉt ĩt tʉ́i jepahap tajĩ. Páant ĩ jepahachah enna yʉhna, yeébboó tʉ́ʉt nʉʉ́míhcan, ñit jepahcap tajĩ, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nin biíh wã naáwát pínahdih ñi tʉ́i joyoó. Biíc newé jiwá iguíhdih ã momop be. Pánih mom péa, wáihyat jʉ́dʉdih chãj péa, iguíhdih ĩ bʉ́ʉh chʉñat pínah mʉʉdíhbʉt ã chãjap be. Pánih chãj péa, caán iguíhadih ĩ tʉ́i en dawát pínah niijná, jap bóo mʉʉdíhbʉt ã chãjap be. Páant nihatdih chãj péa, bitadih en dawát tʉ́ʉtnit, biáboó jib jwʉhʉdih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tʉ́ttimah, iguíh ei láa, ã́ih iguíh jíibdih ĩ ʉʉ́bát pínah niijná, iguíha mínah caandíh teo wʉ̃hnitdih ã́ih iguíhana ã wah bojop yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Obohjeéhtih, caandíh teo wʉ̃hnit caanná ĩ jʉibínachah, biícdih pʉ̃i, biíhdih mao yoh, biíhdih jeejĩ́h ĩ yoh mawap be. ");
INSERT INTO cbv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pánihat tʉ́ttimah, bita caandíh teo wʉ̃hnitdih ã́ih iguíhaboó ã jwʉ́ʉb wahap be, páant mʉntih. Chah dawá ã wahachah yʉhna, queét en daonít biíc yoobó mʉntih queétdihbʉt yeejép ĩ chãjap be. ");
INSERT INTO cbv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Tʉ́ttimah, ‘Wã wʉ̃ʉ́hdih caá ĩ jepahmi dée caá’, niijnít, caandíh ã wahap be. ");
INSERT INTO cbv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Páant ã wahachah yʉhna, caandíh ennit, en daonítboó nin pah ĩ míic niijíp be: ‘Iguíha mínah ã wʉnat tʉ́ttimah, nin ã wʉ̃ʉ́hboó ã tʉ́ʉt nʉʉmbípna caá. Pánihna, caandíh jwĩ mao yohochah, iguíha jwĩ́ih ã jʉmbipna caá’, queétjeh ĩ míic niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Páant niíj, ã wʉ̃ʉ́hdih teonit, iguíhamant ʉb bac bejnit, ĩ mao yohop be. ");
INSERT INTO cbv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Páant ĩ chãjat doonádih joinít, iguíha mínahboó ã́ih iguíhana jwʉ́ʉb jʉinít, ¿queétdih ded pah tigaá ã chãjbi?” Jesús queétdih ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Páant Jesús ã niijíchah joinít, queét caandíh nin pah ĩ niíj jepahap jĩ: —Queét yeejépwãdih peéh chãjna, ã mao yohat tʉ́ʉtbipna caá. Tʉ́ttimah, bitaboodíh ã́ih iguíhadih ã en dawát tʉ́ʉtbipna caá, ã́ih iguíhdih caandíh ĩ tʉ́i dic wʉ̃hat pínah niijná, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Páant ĩ niijíchah joinít, Jesús nin pah ã jwʉ́ʉb niijíp jĩ: —Dios naáwátdih naóh yapani nin pah ã niíj daacátjidih ¿yeébboó ñi bohécannit beé? ‘Mʉʉ́ teonit tʉ́ini jee dáhnadih ñíonit, ĩ náahcanni dahdih ĩ yohop yʉh be. Obohjeéhtih, queét ĩ yohni dahdihjeh tigaá Dios ã ñíwip. Caandíh ñíonit, ã́ih mʉʉ pánihnidih chãjna, caán mʉʉdíh ã tʉ́i jenah enat tʉ́ʉt niijná, choójboó caan dáhdih ã jwíih jwejep be. Caán jee pánihni Dios ã wahni pínah tigaá. Páant ã chãjachah ennit, jwiítboó caandíh bʉ́dí jwĩ wẽina caá’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Páant ã nihat pah tigaá yeebdíh yoobópdih wã naóhna caá. Dios ã́ihwã pínah yeebdíh ã jwíih ñíonitji ñi jʉmʉchah yʉhna, weém Dios ã wahnidih ñi náahcah, bita weemdíh tʉ́i jepahnit pínahboodíh ã ñíobipna caá, páantjeh ãjeéh ĩ jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pánihna, weemdíh jepahcannitboó caán jee dáhdih tóoc bʉʉgnít panihnit ĩ jʉmbipna caá. Weemdíh ĩ jepahcatji jíib caán jee dáh ã néehat pah, peéh chãjna, iiguípna Dios queétdih ã wahbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Páant ã niijíchah joinít, sacerdotewã ĩ maáta, fariseowãbʉt “Jwiítdih niijná caá ã chãjap”, ĩt niíj jéihyep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Páant niíj jéihnit, caandíh ded pah ĩ tewat pínahdih ĩt bidip wʉt yʉh jĩ. Obohjeéhtih, cã́acwã caandíh “Dios naáwátdih naóh yapani caá”, ĩ niíj jenah joyóchah jéihnit, queétdih ʉ́ʉmna, tewíhna yʉhna, ĩt jéih teo jwʉhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Páant ã niiját tʉ́ttimah, Jesús nin ã jenah joiní naáwátjĩh queétdih ã jwʉ́ʉb niíj naóh bohénap jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dios ã maáh jʉmat nin pah caá ã jʉmʉp: Maáh wʉ̃ʉ́h ã téihya chéwat tʉ́ʉt chãjachah, ã íip ã nʉmah jeémát pínahdih ã chãjap be. ");
INSERT INTO cbv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pánih ámoh péanit, ã nʉmah jeémpnit pínahdih jʉ̃ʉ́wát tʉ́ʉtna, caandíh teo wʉ̃hnidih ã wahap yʉh be. Obohjeéhtih, caandíh ĩ jepahcap be. ");
INSERT INTO cbv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tʉ́ttimah, bita caandíh teo wʉ̃hnitdihbʉt wahnit, ‘Ã nʉmah jeémát pínah momo jiwiwã, ã in débehanitdih mao pʉʉbnít, nihatdih ámoh péa, yeebdíh ã jʉ̃ʉ́wát tʉ́ʉtʉp be’, wã bidnitdih ñi niíj naáwá. ");
INSERT INTO cbv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Páant ã wʉtʉchah joinít, ĩ bejep yʉh be, páant mʉntih. Obohjeéhtih, páant ĩ niijíchah yʉhna, queétbʉt ĩ joyáh bojop be. Joyáh bojnit, biíc ã́ih wápchiboó bej, biíh ã tewat mʉʉ́boó ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bitaboó queét ĩ naáwáchah joííhcan, yeejép pʉ̃init, queétdih ĩ mao yohop be. ");
INSERT INTO cbv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Páant ĩ chãjat doonádih joinít, bʉ́dí íijnit, maáhboó ã́ih soldadowãdih ã wahap be, queétdih mao yoh beedánit, ĩ́ih tʉ́tchidihbʉt ĩ cáwat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pánihat tʉ́ttimah, bita caandíh teo wʉ̃hnitdih nin pah ã niijíp be: ‘Wã wʉ̃ʉ́h ã téihya chéona nʉmah jeémát pínahdih ámoh péanit, cã́acwãdih wã bidichah yʉhna, queét yeejépwã ĩt jepahcap taga. ");
INSERT INTO cbv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pánihna, tʉ́tchi tac yoób jʉmni jʉʉ́hna bejnit, det ñi jwãáhnitdih ñi nʉmah jʉ̃ʉ́wʉ́’, queétdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Páant ã niijíchah joinít, bejna, biquína tʉ́i chãjnitdih jwãáh, bita tʉ́i chãjcannitdihbʉt jwãáhnit, nihatdih ĩ nʉmah jwʉ́ʉb jʉ̃ʉ́wʉ́p be. Pánihna, ĩ maáíh mʉʉná jwʉ́ʉb jʉibínit, ã nʉmah jeémát tólihdih ĩ yáwap yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Obohjeéhtih, maáhboó queét jʉinítdih enedih jʉiná, téihya chéwechah enna ĩ dʉwát chóodih biíc newé ã dʉocáh, ã enep be. ");
INSERT INTO cbv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pánih ennit, ‘¿Íin wʉ̃ʉ́á, dépanih tibeé wã dʉwát tʉ́ʉtni yégueh dʉocán yʉhna, ma waád jʉ̃óh?’ caandíh ã niijíp be. Páant ã niijíchah joinít, caánboó ã jéih jepahcap be. ");
INSERT INTO cbv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Páant ã jepahcah enna, maáh caandíh teo wʉ̃hnitdih nin pah ã niijíp be: ‘Chéonit, caandíh ñi ʉb bac bejeé. Pánih ʉb bac bejnit, weemdíh ã jepahcat jíib, dʉpʉ́napboó ñi yohoó, wã pebh ã jʉmcat pínah niijná. Caánboó jʉmnit, tʉbit jĩ́gahna, ĩ́ih maonádih néeh chãác jʉ̃inít ĩ jʉmbipna caá’, caandíh teo wʉ̃hnitdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Bʉʉ wã naáwát pah, dawá cã́acwã wĩ́ih tʉ́ini doonádih joiná yʉhna, daocánnitjeh ĩ jepahna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Páant ã niijíchah joinít, íijna, Dioíh mʉʉmánt bac bejnit, fariseowã nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: “¿Ded pah tigaá caandíh jwĩ niíj ʉʉ́bh joibí, mácah ã jepahachah, caandíh naóh yacat tʉ́ʉt niijná?” ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Páant niijnít, biquína ĩjeéh jʉmnit, Herodes ã jʉimenádih maáh waadáíhnitdihbʉt Jesús pebhna ĩt wahap tajĩ, Jesúsdih ĩ ʉʉ́bh joyát pínah niijná. Páant ĩ wahnitboó waád jʉinít, nin pah Jesúsdih ĩ niijíp jĩ: —Bohéní, yeecanni jʉmna, Dios ded pah jwiítdih ã chãjat tʉ́ʉtatdih yoobópdih ma bohéátdih jwĩ jéihna caá. Ded pah cã́acwã ĩ niijíchah, maáta ĩ jʉmʉchah yʉhna, ʉ́ʉmcanjeh yoobópdih mapĩ́ naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Páant yoobópdih naóhni jʉmna, ded pah ma jenah joyátdih jwiítdih ma naáwá. ¿Roma baácdih moón ĩ maáh César ã ʉʉ́bát tʉ́ʉtni nʉ́odih caandíh jwĩ wʉ̃hʉchah, ã tʉ́i niít? ĩ niíj ʉʉ́bh joyóp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Páant ĩ niíj ʉʉ́bh joyóchah, ĩ yeeatdih jéihnit, nin pah queétdih ã niíj ʉʉ́bh joí jwʉ́ʉbanap jĩ: —Yeéb yeenit, ¿dépanih tigaá weemdíh mácah ñi jepahat tʉ́ʉt? ");
INSERT INTO cbv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Césardih ñi wʉ̃hat pínah jʉ́dʉdih weemdíh ñi jʉ́ʉtʉ́, ã niijíp jĩ. Páant ã niijíchah joinít, biíc jʉ́dʉdih caandíh ĩ jʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Caán jʉ́dʉdih deíh móot, deíh wʉ̃t tigaá ã jʉm? queétdih ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Césaríh móot, ã́ih wʉ̃tbʉt ã jʉmna caá, ĩ niíj jepahap jĩ. —Caán láa bácah caán jʉ́dʉ Césaríh pínah caá. Pánihna, ã́ih pínah ã jʉmʉchah, caandíh wʉ̃hat caá náahap. Obohjeéhtih, Dioíh pínah mácah ã jʉmʉchah, Diosboodíh ñi wʉ̃hʉʉ́, queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Páant ã niíj jepahachah, ĩ joí wʉ́hi bejep jĩ. Pánih joí wʉ́hi bejnit, ĩ bac bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Páant queét ĩ bac bejat tʉ́ttimah, biquína saduceowã jwʉh, Jesúsdih ʉʉ́bh joyát tʉ́ʉt niijná, caán mʉʉná mʉntih ĩ waád jʉyʉ́p jĩ. Queét saduceowã “Cã́acwã wʉnna, ĩ jwʉ́ʉb boo pʉd jʉ̃óhcan niít”, niijnít ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Pánih jenah joinít, nin pah Jesúsdih ĩ niijíp jĩ: —Bohéní, nin pah Moisés ãt niíj bohénap tajĩ: ‘Weép jeñé weh wihcanjeh ã wʉnʉchah, ã ʉ́ʉdboó weép jeñé áajidih jwʉ́ʉb áa jʉmat caá náahap. Pánihna, ã ʉ́ʉdboó áa wih jwʉhcanni jʉmna, éemp wʉnnihdih ã bíboho naáh, ã ʉ́ʉd jeñé báadhda weh pah ĩ weh jʉmat pínah niijná’, jwiítdih Moisés ãt niijíp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Biíc weh sietewã ĩ jʉmʉp be. Weép jeñéboó áa jʉm, weh wihcanjeh ã wʉnʉp be. Pánihna, ã ʉ́ʉdboó weép jeñé áajidih ã jwʉ́ʉb áa jʉmʉp yʉh be. Páant áa jʉmat tʉ́ttimah, weép jeñé pahjeh mʉntih, weh wihcanjeh caanbʉ́t ã wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Páant míicjeh queét nihat ĩ bʉʉ́d beedép be. ");
INSERT INTO cbv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Páant mi weha mána ĩ wʉn beedát tʉ́ttimah, ĩ áajibʉt mi wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pánihna, queét nihat ĩ áa jʉmnihji, nihat cã́acwã ĩ jwʉ́ʉb boo pʉd jʉ̃ʉ́wʉ́chah, ¿ded áa tigaá mi yoób jʉmbi? Jesúsdih ĩ niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Páant ĩ niijíchah joinít, Jesús queétdih nin pah ã niíj jepahap jĩ: —¡Dios naáwátdih jéihcan, ã wẽpatdihbʉt jéihcan, yeébboó yoobópdih jenah joicánnit caá! ");
INSERT INTO cbv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wʉnnitji ĩ jwʉ́ʉb boo pʉd jʉ̃ʉ́wát tʉ́ttimah, jeáboó jʉmna, ángelwã pah áa wihcannit ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Obohjeéhtih, wʉnnitji ĩ boo pʉd jʉ̃ʉ́wát pínahdih yeéb ñi jéihyatdih náah yacna, nin pah wã naóhna caá. ¿Moisésdih Dios nin pah ã niijátjidih ñi encannit jĩí? ");
INSERT INTO cbv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Weém Abraham, Isaac, Jacob ĩ Maáh caá’, ãt niíj naáwáp wʉt jĩ. Queét ĩ wʉnat tʉ́ttimah yʉhna, ‘Ĩ Maáh caá’, Dios ãt niijíp wʉt jĩ. ‘Ĩ Maáh caá’, ã niijátjidih joinít, báadhnit ĩ jʉmatdih jwĩ jéihna caá. Dios báadhnitdihjeh maáh ã jʉmna caá. Pánihna, ‘Wʉnnitji ĩ jwʉ́ʉb boo pʉd jʉ̃óhcan niít’, niíj jenah joiná, yoobópdih ñi jenah joicán caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Páant ã niijíchah joinít, nihat cã́acwã ã bohéátdih ĩ joí wʉ́hi bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Páant Jesús saduceowãdih ã tʉ́i jepahachah joinít, fariseowãboó ĩ míic wéhenap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pánih míic wéhe péanit, biíc ĩjeéh jʉmni, Moisés ã wʉtatjidih tʉ́i jéihniboó caandíh nin pah ã niíj ʉʉ́bh joyóp yʉh jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—¿Bohéní, Dios jwiítdih ã wʉtat deddih tigaá chah jenah joyát náah? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—Nin wʉtat caá chah ã jʉmʉp. ‘Diosdih chah jenah joí, tʉ́i jepahnit, wẽinit, caandíh bʉ́dí ñi oyoó’, Moisés ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Caán wʉtatji caá jwíih jʉmni. ");
INSERT INTO cbv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Caán wʉtat pahjeh mʉntih, nin biíh wʉtatbʉt biíc yoobó ã jʉmna caá: ‘Meemjéh ma míic oyat pah mʉntih, bitadihbʉt bʉ́dí ma oyoó’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pánihna, Diosdih oinit, bitadihbʉt oinit, Dios ã náahat pah ñi chãjbipna caá. Pánih chãjnit, nihat Moisés ã wʉtatjidih, Dios naáwátdih naóh yapanit ĩ niijátjidihbʉt ñi tʉ́i jepahbipna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Páant niíj péanit, Jesús jwʉh caanjĩ́h jʉmnit fariseowãdih nin pah ã niíj ʉʉ́bh joyóp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Dios ã wahni Cristodih ded pah tigaá ñi jenah joí? ¿Ded jʉima tigaá? queétdih ã niijíp jĩ. —David jʉima caá, ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Páant ã jʉmʉchah yʉhna, ¿Dépanih tigaá Tʉ́ini Espíritu nin pah caandíh ã naáwát tʉ́ʉtʉchah, Davidjiboó caandíh ‘Maá’, ãt niijí? ");
INSERT INTO cbv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wã Maáhdih Dios nin pah ã niijíp be: “Wã jéihyepmant bóo bʉwámant ma chʉ́ʉdʉ́. Pánih chʉ́ʉdnit, nihatdih ma wʉtʉchah, meemdíh en jʉ̃ihnitdih wã yap yohat tʉ́ʉtbipna caá”, ã niijíp be’, Davidji ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Páant niíj daácnit, Davidji Cristodih ‘Maá’, ãt niijíp wʉt jĩ. Páant ã niijíchah yʉhna, ¿dépanih tigaá Cristo David jʉima ãt jʉmji? Jesús queétdih ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Páant ã niíj naáwáchah joinít, nihat ĩ jwʉ́ʉb ʉʉ́bh joííhna yʉhna, ĩ ʉʉ́bh joí cádahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Páant niíj péanit, caanjĩ́h jʉmnitdih, jwiít ã bohénitdihbʉt Jesús nin pah ã niíj naáwáp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés ã wʉtatjidih bohénit, fariseowãbʉt caán ã wʉtatdih chah tʉ́i jéihnit jʉmna, yeebdíh ĩ wʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Páant yeebdíh ĩ wʉtʉchah, ĩ niiját pahjeh chãjat caá náahap. Obohjeéhtih, páant ĩ niíj bohéna yʉhna, ĩpĩ́ chãjcan caá. Páant ĩ tʉ́i chãjcatdih yeébboó ñi en yacca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Queét yeebdíh bʉ́dí wái náah jʉmnidih chãjat tʉ́ʉtna, bainíbitjeh ñi yapachah ennit, yeebdíh jĩ́gah encanjeh, ĩpĩ́ peéh chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ded pah chãjna, cã́acwã ĩ wẽi enat pínahdihjeh ĩpĩ́ bidna caá. Dios naáwátdih ĩ daácni nʉ́onabit ã́ih ʉ̃tna yacnit, ĩ́ih móot chah, ĩ́ih mʉj nahboobʉ́t bʉ́dí bʉwá jʉmni tõpjĩh ĩpĩ́ nah chéona caá. Ʉʉ́bhna dʉwát chóona ã yapat waanadih maátni ĩpĩ́ chãjat tʉ́ʉtna caá, queétdih ennit, ‘Diosdih tʉ́i jepahnit caá’, niijnít, cã́acwã ĩ tʉ́i wẽi enat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nʉmah jeémépboó bejnit, waáwápna chʉ́ʉdnit, ĩpĩ́ wẽina caá. Jwĩ míic wáacat mʉʉ́boó bejnit, cã́acwã ĩ tʉ́i enepboó ĩpĩ́ chʉ́ʉdna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tʉ́tchi tacboó bií déedih jíib chãjat jʉʉ́hna ĩ bejechah, cã́acwã queétdih wẽinit, mʉj teonit, ‘Ma jʉ̃óh, Bohéní’, ĩ niíj ʉʉ́bʉ́chah joinít, ĩpĩ́ wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Obohjeéhtih, ‘Bohéní’, yeébboó cã́acwãdih ñi niiját tʉ́ʉtca bojoó. Weemjéh caá yeebdíh bohéni. Yeéb nihat biíc yoobó jʉmna, ‘Bohéní’, cã́acwãdih ñi niiját tʉ́ʉtʉchah, ã tʉ́ican caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pánihat pah, cã́acwã míicjeh ‘Tʉ́ini Paá’, ñi niijíchah, ã tʉ́ican caá. Dios, jeáboó jʉmnijeh, ñi íip tʉ́ini yoobát ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pánihat pah mʉntih, yeéb míicjeh ‘Maá’, ñi niijcá bojoó. Weém, Dios ã wahni Cristojeh, ñi maáh wã jʉmna caá. Pánihna, cã́acwã míicjeh páant ñi niijíchah, ã tʉ́ican caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ded maáh jʉmíhna, yeebdíh teo wʉ̃hni ã jʉmʉ naáh. ");
INSERT INTO cbv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Caanjéh míic maáh waadánidih Dios oboh jʉmni ã chãjbipna caá. Obohjeéhtih, teo wʉ̃hni panihniboodíh Dios maáh ã waadábipna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Páant niíj péanit, nin pah fariseowã, Moisés ã wʉtatjidih bohénitdihbʉt Jesús ã niíj jʉ̃ihñʉp jĩ: “¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Dios ã wʉtatdih ñi yee bohénachah joinít, Dios ã maáh jʉmʉpboó cã́acwã ĩ jéih waadcán caá. Pánih bohénit, yeebjéhbʉt waadcán, queét ĩ waádíhichah yʉhna, ñipĩ́ jãhna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Diosdih tʉ́i maatápdih ʉʉ́bhna yʉhna, éemp wʉnnitíh mʉʉnádih ñipĩ́ dʉ́ʉc wáina caá. Pánih yeenit ñi jʉmat jíib bʉ́dí peéh chãjat yeebdíh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Yʉʉ́p jib bejnit, dawá cã́acwãdih ñipĩ́ bohéna caá, ñi jenah joyát pahjeh ĩ tʉ́ʉt nʉʉmát pínah niijná. Páant ĩ tʉ́ʉt nʉʉmʉ́chah, yeejép ñi chãjat chah queétdih ñi chãjat tʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Yeéb bohénit, bitadih waóhna, jéih encannit panihnit ñi jʉmna caá! Yeena, nin pah ñi niíj bohéna yʉh caá: ‘ “Dioíh mʉʉ́ tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá”, ñi niijíchah yʉhna, dedé pínah nihcan caá. Obohjeéhtih, “Dioíh mʉʉdíh jʉmni oroboó tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá”, ñi niijíchah, ñi niijátji pahjeh chãjat caá náahap’, ñipĩ́ niíj bohéna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Yeéb jenah joicánnit, jéih encannit panihnit ñi jʉmna caá! ¿Ded tigaá chah ã jʉm? ¿Dioíh mʉʉ́ chah niít? ¿Caán mʉʉ́ diítboó jʉmni oroboó niít chah ã jʉmʉp? Caán mʉʉ́ diítboó oro jʉmna, Dioíh caá ã jʉmʉp. Obohjeéhtih, biíh pebhboó jʉmna, Dioíh ãta nihcan taga. Pánihna, oro chah Dioíh mʉʉ́ ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yeéb nin pahbʉt ñipĩ́ niíj bohéna yʉh caá: ‘ “Dioíh mʉʉ́boó jʉmni nʉñʉ́pdih mao cáo wʉ̃hat naá tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá”, ñi niijíchah yʉhna, dedé pínah nihcan caá. Obohjeéhtih, “Ĩ mao cáo wʉ̃hniboó tʉ́ini ã jʉmat pah, wã niiját biíc yoobó wã chãjbipna caá”, ñi niijíchah, ñi niijátji pah chãjat caá náahap’, ñipĩ́ niíj bohéna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Yeéb jéih encannit panihnit ñi jʉmna caá! ¿Ded tigaá chah ã jʉm? ¿Diosdih cáo wʉ̃hni niít chah ã jʉm? ¿Caán ñi cáagat naá niít chah ã jʉm? Caán naajíh ñi cáagna, Diosdih ñi wʉ̃hʉchah, ã́ih pínah caá. Biáboó ñi cáagachah nihna, Diosdih ñi wʉ̃hni ãta nihcan tagaá. Pánihna, caán ñi cáagat naá caá chah ã jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Páant ã jʉmʉchah, ‘Jwĩ cáagat naá tʉ́ini ã jʉmat pah, wã niijátji biíc yoobó wã chãjbipna caá’, niijnít, caán naá caanjíh ñi cáagnibʉt ã tʉ́yatdih ñi jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pánihat pah, Dioíh mʉʉ́ ã tʉ́yatdih jenah joiná, ã́ih mʉʉ́ diítboó jʉmni ã tʉ́yatdihbʉt ñi jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","‘Jeá tʉ́ini ã jʉmat pah, wã niijátji biíc yoobó wã chãjbipna caá’, niijnít, Dios maáh jʉmna ã chʉ́ʉdatdihbʉt jenah joinít, Dios, caanjíh chʉ́ʉdni ã tʉ́yatdihbʉt ñi jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Dios ã wʉtatdih jepahna, ded chénat pah téihya chej jʉmni nʉ́onadih bíbohna, biíc nʉ́odih Diosdih ñipĩ́ wʉ̃hna yʉh caá.Obohjeéhtih, pánih wʉ̃hna yʉhna, biíh ã wʉtatna chah jenah joyát pínah ã jʉmʉchah yʉhna, caandíh ñipĩ́ joyáh bojna caá. Cã́acwãdih tʉ́i chãjatboodíh ñi jenah joicán caá. Queétdih ñipĩ́ jĩ́gah en teo wáaccan caá. Ded pah bitadih ñi niijátji pah ñipĩ́ chãjcan caá. Pánihna, Dios ã wʉtat pah, chej jʉmni nʉ́onadih caandíh wʉ̃hna, ã tʉ́ina caá. Obohjeéhtih, biíh ã wʉtatdihbʉt jepahat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Yeéb bitadih waóhna, jéih encannit panihnit ñi jʉmna caá! Ñi wʉtatdih, oboh jʉmni ã jʉmʉchah yʉhna, ñipĩ́ jepahna yʉh caá. Obohjeéhtih, Dios yoobópdih ã wʉtatboodíh ñipĩ́ jepahcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Ñíih pamapnadih, ñíih babhbat dahnadihbʉt jiimantjeh ñipĩ́ chocna caá, ã tʉ́i jígohat pínah niijná. Páant ñi chocochah yʉhna, diítboó bʉ́dí queí ã jʉmna caá. Caan pámap jiimantjeh ñi chocat pah, yeebbʉ́t biíc yoobó ñi jʉmna caá. Tʉ́i jígohna yʉhna, ñi jenah joyát yeejép ã jʉmna caá. Ñi weñat pínahdihjeh chãjnit, tʉbit en ñinahnitbʉt ñi jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Yeéb fariseowã jéih encannit panihnit ñi jʉmna caá! Pánih jʉmna, ñi jenah joyátdih tʉ́ʉt nʉʉmnít, tʉ́iniboodíh ñi chãjaá. Pánih chãjna, yoobópdih tʉ́init ñi jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Cã́ac yohopdih bóo mʉʉ dáhnabit tʉ́i baabní chítahjĩh ĩ ñáini panihnit ñi jʉmna caá. Cã́acwã caán yohopdih ĩ enechah, tʉ́i jígohni ã jʉmna caá. Páant jiimant tʉ́ini ã jígohochah yʉhna, ĩ yohni bácahji ã moopátdih queét ĩ jéih encan caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Páant ã nihat pahjeh mʉn tigaá yeebdíh cã́acwã ĩ enechah, tʉ́init pah ñipĩ́ jígohna yʉh caá. Obohjeéhtih, ñi jenah joyátboó bʉ́dí yeeat jʉm yapna, yeejép ã jʉmʉchah, moópni dée pah caá ñi jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Yeéb Moisés ã wʉtatjidih bohénit, yeéb fariseowãbʉt bʉ́dí yeejép ñi yapbipna caá! Tʉ́i bohénit pah jʉmna yʉhna, tʉbit yee naóhnit caá ñi jʉmʉp. Tʉbit yeenit jʉmna, Dios naáwátdih naóh yapanitji, tʉ́i chãjnitjidihbʉt ñi oyatdih jʉ́ʉtat tʉ́ʉt niijná, queétdih ĩ yohopjidih ámohnit, tʉ́ini ñipĩ́ chãjna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pánih chãjnit, nin pah ñipĩ́ niijná caá: ‘Jon jã́tih jwĩ nʉowã ĩ chãjatji pah jwiítboó jwĩta chãjcan tagaá. Dios naáwátdih naóh yapanitdih wẽinit, queétdih jwĩta mao yohcan tagaá’, ñipĩ́ niijná yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Obohjeéhtih, Dios naáwátdih naóh yapanitdih mao yohnit ĩ jʉimená jʉmna, biíc yoobó tigaá ñi chãjap. ");
INSERT INTO cbv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pánihnit ĩ jʉimená jʉmna, ñi nʉowã ĩ yéej chãjatji pahjeh mʉntih ñi chãj péanaá. ");
INSERT INTO cbv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Yeéb maiwã pah yeejépwã ñi jʉmna caá! Pánihna, ñi yéej chãjatdih ñi tʉ́ʉt nʉʉmcátji jíib, Dios yeebdíh peéh chãjna, iiguípna ã wahachah, ñi jéih jweicán niít. ");
INSERT INTO cbv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Páant niijná, nin pah niíj naóhna caá wã chãjap: Dios naáwátdih naóh yapanitdih, bita ã́ih tʉ́ini doonádih tʉ́i jéihnitdih, bita ã naáwátdih bohénit pínahdihbʉt yeebdíh wã wahbipna caá. Páant wã wahachah yʉhna, yeébboó biquínadih cruzboó péoh dodhnit ñi mao yohbipna caá. Bitadih ñi míic wáac jʉyʉ́pboó pʉ̃init, tʉ́tchimant bacanit, queétdih mawat tʉ́ʉt niijná, ñi ñʉʉ́n péebipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pánih chãjna, jon jã́tih jʉmnit tʉ́i chãjnitjidih ĩ mawatji jíib yeébboodíhbʉt Dios ã peéh chãjbipna caá. Pánihna, tʉ́i chãjni Abeljidih Caín ã mawatji jíib pʉ́ʉ́ʉ́ʉ́ Zacaríasjidih ñi nʉowã ĩ mawatji jíib tigaá yeébboodíh Dios ã peéh chãjbipna caá. Caán Zacarías Berequíasji wʉ̃ʉ́h ãt jʉmʉp tajĩ. Dioíh mʉʉ́ jʉʉ́hboó jʉmni nʉñʉ́pdih mao cáo wʉ̃hat naa pébh ã jʉmʉchah yʉhna, caandíh ĩt mawap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yoobópdih yeebdíh wã naóhna caá. Queét nihatdih ĩ mawatji jíib bʉʉ láa moondíhbʉt Dios ã peéh chãjbipna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Páant niíj péanit, caanjĩ́h jʉmnitdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: “¡Yeéb Jerusalén tʉ́tchidih moondíh bʉ́dí wã jĩ́gahna caá! Dios naáwátdih naóh yapanitdih maonit, ñi pebhna bita ã wah bojnitdihbʉt jeejĩ́h yohnit, yeéb ñipĩ́ maona caá. Ñi nʉowãbʉt biíc yoobó ĩt chãjap wʉt jĩ. Pánihnit ñi jʉmʉchah yʉhna, yeebdíh bʉ́dí wã oina caá. Pánih oinit, mʉjbaima mi wehdih mi páamat pah, wã pebh yeebdíh wã jʉmat tʉ́ʉtna yʉh caá. Obohjeéhtih, yeébboó weemdíh ñi náahcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Páant ñi náahcat peéh, bʉʉ ñíih tʉ́tchidih Dios ã wap cádahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yoobópdih yeebdíh wã naóhna caá. Ninboó weemdíh ñi jwʉ́ʉb encan niít. Tʉ́ttimah bóo láa nin baácna wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chahjeh, weemdíh ñi jwʉ́ʉb enbipna caá. Pánih ennit, ‘¡Dios ã wahni, meemdíh bʉ́dí jwĩ wẽina caá!’ ñi niijbípna caá”, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Páant niíj péanit, Dioíh mʉʉmánt Jesús jwiítdih ã nʉmah bac bejep jĩ. Pánih bac bejnit, Dioíh mʉʉdíh wẽi enna, ã tʉ́i jígohatdih Jesúsdih jwĩ naáwáp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Obohjeéhtih, páant jwĩ naáwáchah joinít, nin pah jwiítdih ã niijíp jĩ: —Caandíh ennit, ñi tʉ́i jenah joyoó. Yoobópdih yeebdíh wã naóhna caá. Yeebdíh eníhcannitboó nin ñi en wẽinidih ĩ boto mao jéena beedábipna caá. Biíc jee dáh biíh dahjih lajni ã wihcan niít, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Páant niíj míic wéhe bejna, Olivo jeená bejni namáboó bejna jwĩ chãjap jĩ. Pánih bejna, caán jeená pʉ́ʉh laáb jʉibínit, Jesús ã chʉ́ʉdʉp jĩ. Páant ã chʉ́ʉdʉchah ennit, jwiítboó ã pebh jʉibínit, nin pah caandíh jwĩ niíj ʉʉ́bh joyóp jĩ: —Maá, jwiítdih ma naáwá. ¿Débólih tigaá ma niiját pah ã yapbi? ¿Meém ma jwʉ́ʉb dei jʉ̃ʉ́wát pínah jã́tih, péeni yeó jáap jã́tihbʉt ded pah ã jwíih yapachah tigaá jwĩ enbi? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—Yeéb ñi tʉ́i chãja chaáh. Bita ĩ yeeatdih ñi joicá bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","‘Weém Cristo caá’, niíj yeenit, dawá ĩ jʉ̃óhbipna caá. Páant ĩ niíj yeenachah joinít, Diosdih cádahna, páant niijnítboodíh dawá ĩ péebipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pebhbit jʉmnit ĩ míic mawat, yʉʉ́p jʉmnit ĩ míic mawat doonádihbʉt ñi joibípna caá. Pánih joiná yʉhna, caandíh bʉ́dí ñi ʉ́ʉm jenah joicá bojoó. Páant ã yapbipna caá. Obohjeéhtih, páant ã yapachah yʉhna, péeni yeó jáap pínah páantjeh ã jʉdh jwʉhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Caán láa biíc baácdih moón biíh baácna bejnit, ĩ míic maobipna caá. Nihat baácboó bʉ́dí míic mawat ã jʉmbipna caá. Dawá pebhboó nʉʉgʉ́p láa, baác méméatbʉt ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Obohjeéhtih, páant ã yapachah yʉhna, chah yeejép yapat pínah ã jʉdh jwʉhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tʉ́ttimah, bita yeebdíh teonit, maátadih ĩ wʉ̃hbipna caá, yeejép ĩ chãjat pínah, ĩ mao yohat pínahbʉt niijná. Wĩ́ihwã ñi jʉmat jíib, nihat baácdih moón yeebdíh ĩ eníhbican nacaá. ");
INSERT INTO cbv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Caán láa, wĩ́ihwã jʉmna yʉhna, dawá weemdíh ĩ cádahbipna caá. Pánih cádahnit, bita wĩ́ihwãdih eníhcan, maátadih ĩ naóh yacbipna caá, queétdih ĩ peéh chãjat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","‘Weém Dios naáwátdih naóh yapani wã jʉmna caá’, niíj yeenit dawá ĩ jʉmbipna caá. Ded pah ĩ yee naáwáchah joinít, dawá queétdih ĩ jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Caán láa cã́acwã chah yeejép ĩ chãjbipna caá. Pánih yeejép chãjnit, dawá bitadih ĩ oi cádahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Obohjeéhtih, páant yeejép yapna yʉhna, ded weemdíh cádahcanniboó wãjeéh páantjeh jeáboó ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pánihna, Dios ã maáh jʉmat doonádih nihat baácdih moondíh naáwát caá náahap. Páant naáwát tʉ́ttimah, péeni yeó jáap ã jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bita ĩ pãpnidih Diosdih weñat mʉʉ́ diítboó jwejnit, cã́acwã caánboodíh weñaat tʉ́ʉtna, caán mʉʉ́ ã tʉ́yatdih ĩ yéejanachah, ñi enbipna caá. Dios naáwátdih naóh yapani Danielji páant ã yapat pínahdih ãt daacáp tajĩ. Caán ã daacátjidih ennit, ñi tʉ́i beh joyoó. ");
INSERT INTO cbv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Caanjĩ́h yeejép ĩ pãpni ã jʉmʉchah ennit, Judea baácboó jʉmnit jeéboó ĩ jweí pʉ́ʉh laab béje naáh. ");
INSERT INTO cbv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Caán láa cã́acwã tʉbit yeejép ĩ yapachah, waícanjeh ĩ jweí ñáo pʉ́ʉh laab béje naáh. Ded mʉʉ́ chahmant bóo coahboó jʉmni dei bejna, ã́ih bií déedih ʉbʉdih waadcánjeh, yoobópdih ã jwei béje naáh. ");
INSERT INTO cbv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wápchiboó jʉmni ã́ih yéguehnadih ʉbʉdih ã jwʉ́ʉb bejca bojo naáh. ");
INSERT INTO cbv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Caán láa wʉdʉ jʉmnit, weh tʉ́ʉhnitbʉt ĩ jweyéchah, queét yaádhdih chah ã bʉobipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nin pah Diosdih ñi niíj ʉʉ́bʉ́: ‘Mah noój láa, jwĩ chooát yeó jáapdihbʉt páant yeejép ã yapca bojo naáh, caán láa jwĩ jweyát pínah niijná’, ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Caán yeó jáapnadih cã́acwã tʉbit yeejép ĩ yapbipna caá. Nin baácdih Dios ã chãjat tʉ́ttimah, cã́acwã yeejép yapna yʉhna, péeni yeó jáapnadih chah yeejép pohba ĩ yapbipna caá.Páant yeejép yapat tʉ́ttimah, biíc yoobó ã jwʉ́ʉb yeejép yapcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pánihna, tʉbit yeejép yapat pínah daocánni yeó jáapna Dios ã chãjbipna caá, ã ñíonitboó ĩ jéih bʉʉjáát pínah niijná. Páant ã chãjcah nihna, ded ãta bʉʉjácan tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Caán láa det yeebdíh ‘Ñi eneé. Ninjĩh caá Cristo ã jʉmʉp’, ĩ niijíchah, bitabʉt ‘Conjĩh caá Cristo ã jʉmʉp’, ĩ niijíchah, ñi joyáh bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Caán láa dawá yeenit ĩ jʉmbipna caá. ‘Weém Cristo caá’, niíj yeenit, ‘Weém Dios naáwátdih naóh yapani caá’, niíj yeenitbʉt ĩ jʉmbipna caá. Queét ʉ́ʉm náah jʉmnidih ĩ chãj jʉ́ʉtbipna caá, cã́acwã ĩ en wʉ́hi bejat pínah niijná. Páant ĩ chãjatdih ennit, Dios ã ñíonitboó ĩ yeeatdih joiná, Diosdih cádahnit, queétdihjeh ĩ péeat pínahdih ĩ náahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Páant ã yapat pínah jã́tih, yeebdíh wãát naóhna caá, caandíh ñi tʉ́i jéihyat pínah niijná. Páant wã naáwátjidih náhninit, yeebdíh yeenitdih ñi joicá bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pánihna, caán láa ‘Mʉʉ́ wihcapboó Cristo tigaá ã jʉmʉp’, det yeebdíh ĩ niijíchah yʉhna, caanná enedih ñi bejca bojoó. ‘Caán mʉʉ́ diítna jʉmni tólihboó ã jwei ñʉ́hna caá’, ĩ niijíchah yʉhna, ñi joyáh bojoó. ");
INSERT INTO cbv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yeó aáb jʉ̃ʉ́wʉ́pmant ã bʉʉg yácapna wedóát ã yeh iigát ã jígohochah, nihat cã́acwã ĩ jéih enat pah, weém, nihat cã́acwã ʉ́ʉd jeñé, wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, nihat ĩ enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jóopwã wʉnni bácahjidih ã jʉmatdih jéihnit, caanjĩ́h ĩpĩ́ wáac jʉiná caá. Pánihat pah wĩ́ihwã wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah ennit, wã pebh ĩ wáac jʉibípna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Caán láa cã́acwã yeejép ĩ yapat tʉ́ttimah, yeó, widhbʉt ã tʉ́i yeh iigcán niít. Páant ã tʉ́ʉt nʉʉmʉ́chah, jeá ã méménachah, cʉ́iwã ĩ yʉ́ʉg jéen bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Páant ã yapachah, weém nihat cã́acwã ʉ́ʉd jeñé, mah tólihjih wã dei jʉ̃óhbipna caá. Bʉ́dí wẽpatjĩh, tʉ́i yeh iigní wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, nihat baácdih moón weemdíh ĩ enbipna caá. Pánih ennit, bʉ́dí ʉ́ʉmna, ĩ jʉ̃ibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Páant wã dei jʉ̃ʉ́wát pónih, póojat nah bʉ́dí ã yáanachah, wĩ́ih ángelwãdih nihat baácboó wã wahbipna caá, wã ñíonitdih ĩ ʉb wáacat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Higuera nah ded pah ã jʉmatdih ñi tʉ́i náhninaá. Caan náh jáap wawá ã jʉmʉchah ennit, jópchi ã tóah jʉ̃ʉ́wátdih ñi jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Páant ã jʉmat pah, nihat wã niijátji biíc yoobó ã yapachah enna, wã jwʉ́ʉb dei jʉ̃ʉ́wát pínah bahni ã jʉdhdatdih ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yoobópdih yeebdíh wã naóhna caá. Nihat wã niijátji pah ã yapat pínah jã́tih, caán láa moón ĩ bʉʉdcán niít. ");
INSERT INTO cbv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nin baác, jeábʉt ã bʉʉdʉ́chah yʉhna, wã naáwátboó ã bʉʉdcán niít. Nihat wã niijátji pahjeh wã péabipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Obohjeéhtih, wã jwʉ́ʉb dei jʉ̃óhni pínah yeó jáap, horadihbʉt nihat ĩ jéihcan caá. Cã́acwã, ángelwã, weem yʉ́h bʉca nihat jwĩ jéihcan caá. Wã íip Diosjeh caá caandíh ã jéihyep. ");
INSERT INTO cbv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé jʉm láa cã́acwã ded pah ĩ jʉmatji pahjeh mʉn tigaá wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, biíc yoobó ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pobyit ã jʉ̃ʉ́wát pínah jã́tih cã́acwã jeémp babhnit, téihya chéonit, ĩ wehdih téihya chéwat tʉ́ʉtna ĩt chãjap wʉt jĩ. Noéboó jãáj chóona ã waadáchah, ĩpĩ́ jʉmat pah, páantjeh ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pánih jʉmna, pobyit ã jʉ̃ʉ́wʉ́chah, queét nihat ĩ wʉn beedáát pínahdih ĩt jéihcap wʉt jĩ. Pánihat pah biíc yoobó mʉntih wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, cã́acwã ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pánih jʉmnit, chéne neoná ĩ́ih wápchi pínahdih ĩ tewat pónih, weemdíh jepahnidih ángelwã ĩ ʉb bejechah, biíhboó ã chãobípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chénewã yaádh biícdih ĩ tewechah, weemdíh jepahnihdih ĩ ʉb bejechah, weemdíh jepahcannihboó mi chãobípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Páant ã yapat pínahdih jenah joinít, weém ñi Maáh wã jwʉ́ʉb dei jʉ̃óhni yeó jáap pínahdih jéihcan, yeó jáap jʉmat pah tʉ́i pã́init ñi jʉmʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nin wã naáwátdih ñi tʉ́i jenah joyoó: Nʉʉmní dedé hora ã waadát pínahdih jéihna, mʉʉ́ mínahboó ãta tʉ́i en dao tágaá, ã jéih waadcát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pánihat pah weém, nihat cã́acwã ʉ́ʉd jeñé, ñi jéihcat láa wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, yeebbʉ́t biíc yoobó tʉ́i pã́init jʉmat caá náahap”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Biíc teo wʉ̃hni tʉ́i jenah joiní, ã maáhdih tʉ́i jepahni ã jʉmʉp be. Páant ã jʉmʉchah ennit, ã maáh ã bejat pínah jã́tih, nihat bita caandíh teo wʉ̃hnit ĩ maáh pínah caandíh ã waadánap be, queét ĩ jeémát pínahdih yoobópdih ã wʉ̃hat pínah niijná. Pánih maáh waadá péanit, biíh baácboó ã bej jwʉhʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pánih bejniji ã́ih mʉʉná ã jwʉ́ʉb jʉyʉ́chah, caandíh teo wʉ̃hni ã wʉtatji pah ã chãjachah ennit, caandíh bʉ́dí ã wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yoobópdih yeebdíh wã naóhna caá. Caandíh wẽinit, nihat ã bíbohatdih en daoní maáh ã waadábipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Obohjeéhtih, biíh caandíh teo wʉ̃hni tʉ́icanni jʉmna, nin pah ãta niíj jenah joi tágaá: ‘Wã maáh maatápdih jígohcan, bʉʉtéh ã jwʉ́ʉb jʉ̃óhcan niít’, niíj jenah joinít, ");
INSERT INTO cbv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bita teo wʉ̃hnitdih pʉ̃init, babh máihnit biícdih ãta jeémp babh máih tagaá. ");
INSERT INTO cbv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pánihna, caán ã náhnicanni yeó jáap, ã pã́icanni horadih ã maáhboó ã jwʉ́ʉb jʉibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pánih jʉinít, caandíh ã jepahcatji peéh, tʉbit ã pʉ̃ibipna caá. Pánih pʉ̃i péanit, tʉ́i chãjnit pah jígohnit biícdih, iiguípna ã wahbipna caá. Caánboó jʉmna, tʉbit jĩ́gahnit, maonádih ĩ míic néeh chãác jʉ̃ibípna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Péeni yeó jáapdih Dios ã maáh jʉmat nin pah ã jʉmbipna caá: Chénat pah téihya japata yaádh biíc chei ĩ́ih jiiát páhanadih ʉbnit, téihya chéoni pínahdih enat tʉ́ʉt niijná, ã jʉ̃óhni pínah horadih jéihcanjeh, caandíh páñadih ĩ bac bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Biícjĩh bóo téihya jenah joicánnit yaádh ĩ jʉmʉp be. Bita biícjĩh bóo téihya tʉ́i jenah joinít yaádh ĩ jʉmʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pánihna, jenah joicánnit yaádh ĩ́ih jiiát páhanadihjeh pohba ĩ ʉbʉp yʉh be. Obohjeéhtih, caán jiiát páhana ã yíi beedát pínahdih jenah joicánjeh, ĩ jwʉ́ʉb pʉhwat pínahboodíh ĩ ʉb bejcap be. ");
INSERT INTO cbv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bita tʉ́i jenah joinít yaádhboó ĩ́ih jiiát páhana ã yíi beedéchah, ĩ jwʉ́ʉb pʉhwat pínah yíidihbʉt ĩ ʉbʉp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Téihya chéoni pínah ã jígohcah enna, quíib chei ã jʉ̃ʉ́wʉ́chah, queét nihat ĩ ʉ̃wah bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tʉ́ttimah, chei tac yoób téihya chéoni pínah ã jʉ̃ʉ́wʉ́chah, ãjeéh jʉ̃óhnit ĩ wẽi ejat ã yáanap be: ‘¡Ñi joyoó, téihya chéoni pínah ã jʉ̃óhna caá! ¡Caandíh wẽi jwãáádih ñi jʉ̃ʉ́wʉ́!’ ĩ niíj wẽi ejep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Páant ĩ niíj wẽi ejechah joiná, tʉ́i jenah joinít yaádh ĩ́ih jiiát páhanadih ĩ jwʉ́ʉb yíi pʉhwʉp be, ã tʉ́i iigát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Obohjeéhtih, jenah joicánnit yaádhboó tʉ́i jenah joinítdih nin pah ĩ niíj ʉʉ́bʉ́p yʉh be: ‘Jwĩ́ih jiiát páhana dʉbna caá ã chãjap. Pánihna, ñíih yíidih jwiítdihbʉt ñi wʉ̃hʉʉ́’, ĩ niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Jwĩ́ih yíi nihatdih ã jʉibícan niít. Yíi bíbohnitdih yeebjéh jíib chãjadih ñi bejeé’, tʉ́i jenah joinít queétdih ĩ niíj jepahap be. ");
INSERT INTO cbv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Páant ĩ niijíchah joinít, yíi jíib chãjadih ĩ bejep be. Páant ĩ bejat pónih, téihya chéoni pínahboó ã jʉyʉ́p be. Páant ã jʉyʉ́chah ennit, ĩ́ih jiiát páhanadih jiinít, tʉ́i jenah joinít yaádh caandíh jwãáádih ĩ bejep be. Caandíh jwãáhnit, ã téihya chéona nʉmah jeémátdih jeémát tʉ́ʉt niijná, ãjeéh ĩ waad béjep be. Nihat ĩ waád beedéchah ennit, teo wʉ̃hnitboó jẽcdih ĩ nemep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Páant ĩ nemat tʉ́ttimah, jenah joicánnit yaádhboó jwʉ́ʉb jʉinít, ‘¡Maá, jwiítdihbʉt ma wãt jʉ̃ʉ́wʉ́!’ ĩ niíj ejep yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Obohjeéhtih, ‘Yeebdíh wã jéihcan caá’, téihya chéoni queét yaádhdih ã niíj jepahap be. ");
INSERT INTO cbv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Yeebbʉ́t queét tʉ́i jenah joinít yaádh panihnit ñi jʉmʉʉ́. Wã jwʉ́ʉb dei jʉ̃óhni yeó jáapdih, caán horadihbʉt jéihcan, ĩ́ih jiiát páhanadih tʉ́i ámohnit, yíidihbʉt tʉ́i bíbohnit, ĩ páñat pah, yeebbʉ́t tʉ́i jenah joinít, tʉ́inijeh chãjnit, weemdíh ñi páñaá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Dios ã maáh jʉmat nin pahbʉt ã jʉmbipna caá: Biíc newé biáboó jibidih ã bejat pínah jã́tih, caandíh teo wʉ̃hnitdih ã bid wáacap be. Páant ĩ wáac jʉyʉ́chah, dinero jʉ́dʉnadih queétdih ã wʉ̃hʉp be, ĩ jíib tewat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pánih wʉ̃hna, biícdih biícjĩh bóo téihya jʉ́dʉ ã wʉ̃hʉp be. Biíhdih chéne jʉ́dʉ ã wʉ̃hʉp be. Biíhboodíh biíc jʉ́dʉjeh ã wʉ̃hʉp be. Pánih wʉ̃hna, chah jéihnidih chah ã wʉ̃hʉp be. Pánih queétdih wʉ̃h péanit, biíh baácboó jibidih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Páant ã bejat tʉ́ttimah, biícjĩh bóo téihya jʉ́dʉ bíbohni jíib chãjadih ã bejep be. Pánih jíib chãjna, biíh biícjĩh bóo téihya jʉ́dʉ ã jwʉ́ʉb jíib tewep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chéne jʉ́dʉ bíbohnibʉt jíib chãjnit, biíh chéne jʉ́dʉ ã jwʉ́ʉb jíib tewep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Obohjeéhtih, biíc jʉ́dʉ ã wʉ̃hniboó caán jʉ́dʉdih páantjeh ã baad jwéjep be. ");
INSERT INTO cbv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ĩ maáh bejniji maatápdih jígohcan, biíh yeó jáap ã́ih mʉʉná ã jwʉ́ʉb jʉyʉ́p be. Pánih jwʉ́ʉb jʉinít, ded pah ĩ jíib tewatjidih queétdih ã ʉʉ́bh joyóp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Páant ã ʉʉ́bh joyóchah joinít, biícjĩh bóo téihya jʉ́dʉ ã wʉ̃hniji ã jíib tewatjidih ʉb wʉ̃hnit, nin pah ã maáhdih ã niijíp be: ‘Maá, ma eneé. Weemdíh biícjĩh bóo téihya jʉ́dʉ ma wʉ̃hnijĩh jíib chãjnit, biíh biícjĩh bóo téihya jʉ́dʉ wã jwʉ́ʉb jíib tewep be’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Ma tʉ́i teona beé. Wã náahat pah mat chãjap taga. Páant bainí meemdíh wã wʉ̃hʉchah yʉhna, mat tʉ́i jíib tewep taga. Páant ma tʉ́i tewat jíib, dawá wĩ́ih bií déedih en daoní maáh pínah wã waadábipna caá, wãjeéh ma tʉ́i weñat pínah niijná’, ã maáh caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pánihat tʉ́ttimah, chéne jʉ́dʉ ã wʉ̃hnijiboó ã maáhdih nin pah ã niijíp be: ‘Maá, ma eneé. Weemdíh chéne jʉ́dʉ ma wʉ̃hnijĩh jíib teonit, biíh chéne jʉ́dʉ wã jwʉ́ʉb jíib tewep be’, ã maáhdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Ma tʉ́i teona beé. Wã náahat pah mat chãjap taga. Páant bainí meemdíh wã wʉ̃hʉchah yʉhna, mat tʉ́i jíib tewep taga. Páant ma tʉ́i tewat jíib, meemdíh dawá wĩ́ih bií déedih en daoní maáh pínah wã waadábipna caá, wãjeéh ma tʉ́i weñat pínah niijná’, ã maáh caandíhbʉt ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pánihat tʉ́ttimah, biíc jʉ́dʉ ã wʉ̃hnijiboó ã maáhdih nin pah ã niijíp be: ‘Maá, meém ʉ́ʉm náah jʉmni ma jʉmatdih wã jéihna caá. Meemjéh teocan, bitadih wʉtnitjeh, ĩ tewat jíib mapĩ́ bíbohna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Páant ma jʉmatdih jéihnit, meemdíh ʉ́ʉmna, ma wʉ̃hni jʉ́dʉdih páantjeh wã baad jwéjep be. Dáa, nin míih pínahdih ma bíbohoó’, ã maáhdih ã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Meém yeejép tewíhcanni ma jʉmna caá. Weemjéh teocan, bitadih wʉtnitjeh ĩ tewat jíib wã bíbohatdih ¿ma jéihnit beé? ");
INSERT INTO cbv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pánih jéihna, cã́acwã ĩ́ih nʉ́o ámohopboó ma jwejechah, ãta tʉ́i tagaá. Páant ma jwejechah, chah ã jíib aab béjechah, chah wãta bíboh tagaá’, ã maáh caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Páant caandíh jʉ̃ih péanit, bitadih nin pah ã niijíp be: ‘Caán ã bíbohni jʉ́dʉdih dʉ́ʉc wáinit, chénat pah téihya jʉ́dʉ bíbohniboodíh ñi wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ded ã bíbohatjĩh ã tʉ́i chãjachah ennit, caandíh chah ĩ wʉ̃hʉchah, chah bʉ́dí bíbohni ã jʉmbipna caá. Obohjeéhtih, ded bainí bíbohni “Weém wã bíbohcan caá”, niijníboodíh ã bíbohatdih ĩ dʉ́ʉc wáibipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pánih dʉ́ʉc wái péanit, caán yabh teonidih ʉb bac bejnit, dʉpʉ́napboó ñi yohoó. Caanná jʉmnit, ĩ́ih maonádih ĩ míic néeh chãác jʉ̃ibípna caá’, ĩ maáh ã niijíp be”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Weém nihat cã́acwã ʉ́ʉd jeñé, tʉ́i yeh iigátjĩh nihat ángelwã biícdih wã jwʉ́ʉb dei jʉ̃óhbipna caá. Pánih jʉ̃óhnit, maáh waadná, tʉ́i yeh iiguípboó chʉ́ʉdnit, wã wʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Páant wã chʉ́ʉdʉchah, ángelwã nihat cã́acwãdih wã pebhna ĩ ʉb jʉ̃óhbipna caá, ded pah ĩ chãjatji jíib wã naáwát pínah niijná. Páant ĩ ʉb jʉyʉ́chah ennit, chéne poómp queétdih wã ñíobipna caá. Ovejawãdih en daoní ã́ih ovejawã cabrawã biícdih ĩ jʉmʉchah ennit, queétdih ã ñíwat pahjeh weembʉ́t cã́acwãdih wã ñíobipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pánih ñíona, ovejawã panihnit tʉ́initdih wã jéihyepmant bóo bʉwámant wã ñʉhat tʉ́ʉtbipna caá. Cabrawã panihnit yéejnitdih wã wáyámant bóo bʉwámant wã ñʉhat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pánih ñío péanit, weém nihat cã́acwã ĩ maáh wã jéihyepmant bóo bʉwámant ñʉhnitdih nin pah wã niíj naóhbipna caá: ‘Yeéb wã íip ã wẽi ennit ñi jʉ̃ʉ́wʉ́. Nin baácdih ã chãj láa ãjeéh wʉtnit ñi jʉmat pínahdih jenah joinít, bʉʉ láa yeebdíh maáta ã waadána caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Weém wã nʉʉgʉ́p wʉnʉchah, yeébboó weemdíh jeémát ñi wʉ̃hʉp jĩ. Weemdíh ã taca jootóchah, babhbat ñi wʉ̃hʉp jĩ. Ñi pebh wã jib bejechah, weemdíh jéihcan yʉhna, ñi tʉ́i wẽi jwãááp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yégueh wihcanni wã jʉmʉchah enna, weemdíh ñi yégueh yacap jĩ. Tʉbʉ́p chʉ̃ʉ́hni wã jʉmʉchah enna, weemdíh ñi en dawáp jĩ. Nemat mʉʉ́boó wã jʉmʉchah, weemdíh enedih ñi jʉyʉ́p jĩ’, tʉ́initdih wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Páant wã niíj naáwáchah joinít, queét weemdíh nin pah ĩ niíj ʉʉ́bh joibípna caá: ‘¿Maá, débólih tijĩí meém ma nʉʉgʉ́p wʉnʉchah, jeémát jwĩ wʉ̃h? ¿Débólih tijĩí meemdíh ã taca jootóchah, babhbat jwĩ wʉ̃h? ");
INSERT INTO cbv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Débólih tijĩí meemdíh beh encan yʉhna, jwĩ tʉ́i wẽi jwãáh? ¿Débólih tijĩí yégueh ma wihcah enna, jwĩ yégueh yac? ");
INSERT INTO cbv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Débólih tijĩí ma tʉbʉ́p chʉ̃ʉ́ʉ́chah, meemdíh enedih jwĩ jʉibí?’ weemdíh ĩ niíj ʉʉ́bh joibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Páant ĩ niíj ʉʉ́bh joyóchah joinít, weém queétdih nin pah wã niíj jepahbipna caá: ‘Yoobópdih yeebdíh wã naóhna caá. Nin wĩ́ih cã́acwãjeéh jʉmni, oboh jʉmni ã jʉmʉchah yʉhna, caandíh yeéb pánih chãjna, weemdíh tijĩí páant ñi chãjap’, queétdih wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Páant tʉ́initdih niíj péanit, wã wáyámant bóo bʉwámant ñʉhnitboodíh nin pah wã niijbípna caá: ‘Dios ã peéh chãjnit pínah caá yeéb ñi jʉmʉp. Wã pebh chãocánjeh, iiguípna ñi bejeé. Nemépwã ĩ maáh biícdih caán iiguípboó ĩ jʉmat pínahdih Dios ã chãjap jĩ. Pánihna, caandíh jepahnitbʉt ãjeéh ĩ bejbipna caá. Caánboó jʉmni iigát ã noón dʉbcan niít. ");
INSERT INTO cbv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Weém wã nʉʉgʉ́p wʉnʉchah, yeébboó jeémát ñi wʉ̃hcap jĩ. Weemdíh ã taca jootóchah, babhbat ñi wʉ̃hcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Weemdíh jéihcannit, wẽi jwãáhcan, páantjeh ñi enah bojop jĩ. Yégueh moh yéejni wã jʉmʉchah enna yʉhna, weemdíh ñi yégueh yaccap jĩ. Wã tʉbʉ́p chʉ̃ʉ́ʉ́chah, nemat mʉʉ́boó wã jʉmʉchah, weemdíh ñi en daocáp jĩ’, yeejépwãdih wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Páant wã niijíchah joinít, queét weemdíh nin pah ĩ niíj ʉʉ́bh joibípna caá: ‘Maá, ma nʉʉgʉ́p wʉnʉchah, meemdíh ã taca jootóchah, jwĩ jéihcanni ma jʉmʉchah, yégueh ma moh yéejechah, ma tʉbʉ́p chʉ̃ʉ́ʉ́chah, nemat mʉʉ́boó ma jʉmʉchah, ¿débólih tijĩí jwiítboó meemdíh jwĩ teo wáaccan?’ weemdíh ĩ niíj ʉʉ́bh joibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Páant ĩ niíj ʉʉ́bh joyóchah joinít, nin pah queétdih wã niíj jepahbipna caá: ‘Yoobópdih yeebdíh wã naóhna caá. Nin wĩ́ih cã́acwãjeéh jʉmni, oboh jʉmnidih yeéb ñi teo wáaccan, weemdíh tijĩí páant ñi teo wáaccap jĩ’, queét yeejépwãdih wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Queétdih Dios ã peéh chãjachah, iiguípboó páantjeh ĩ jʉmbipna caá. Queét tʉ́initboó wã íip biícdih ã pebhboó páantjeh ĩ jʉmbipna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Páant niíj péanit, nin pah Jesús jwiítdih ã jwʉ́ʉb niíj naáwáp jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Oveja wʉ̃ʉ́hdih jwĩ jeémát yeó jáap, Pascua ĩ niijní, chéne yeó jáap ã jʉdhdatdih ñi jéihna caá. Caán yeó jáapdih weemdíh eníhcannitboó teonit, weém nihat cã́acwã ʉ́ʉd jeñédih bitadih ĩ wʉ̃hbipna caá, weemdíh cruzboó péoh dodhnit ĩ mao yohat pínah niijná, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tʉ́ttimah, sacerdotewã ĩ chah maáh, Caifás wʉ̃t jʉmni pebhna bita jwĩ maáta biícdih ĩt míic wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pánih míic wáacnit, ded pah Jesúsdih teonit, ĩ mawat tʉ́ʉtat pínahdih nin pah ĩt niíj míic wéhenap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Pascua yeó jáapnadih, dawá cã́acwã ĩ jʉmʉchah, Jesúsdih jwĩ tewat tʉ́ʉtʉchah, nihat tʉbit ĩta íij tagaá. Pánih íijnit, jwiítdih ĩta míic mao tagaá. Pánihna, ĩ encah, jwĩ tewat tʉ́ʉtʉ́p, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Queét Jerusalén tʉ́tchiboó ĩ míic wéheat pónih, jwiít Betania tʉ́tchiboó jʉmna, bácah moópniji Simóníh mʉʉná jeémpna jwĩ chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Páant jwĩ jeéméchah, biíc yad wili tʉ́i chej jʉmni bʉ́dí jíib jʉmni yíi quiítdih mi ʉb waád jʉyʉ́p jĩ. Caán quiít alabastro ĩ niijní jeejĩ́h ĩ chãjni quiít ã jʉmʉp jĩ. Pánihna, Jesús pebh jʉinít, caán yíijĩh ã́ih wao dáhdih mi pʉhwʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Páant mi pʉhwʉchah ennit, jwiít ã bohénitboó jwĩ íijip jĩ. Pánih íijnit, nin pah jwiítjeh jwĩ míic niijíp jĩ: —¿Dépanih tigaá nint chej jʉmni yíi bʉ́dí jíib jʉmnidih páant mi pʉoh peét? ");
INSERT INTO cbv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Caandíh jíib chãj wʉ̃hnit, mi jíib teonidih moh yéejnitdih mi wʉ̃hʉchah, chah ãta tʉ́i taga, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Páant jwĩ míic niijíchah joinít, Jesús jwiítdih nin pah ã niíj naáwáp jĩ: —¿Dépanih tigaá caántdih páant ñi niíj jʉ̃ih? Weemdíh caántboó mi tʉ́i chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Moh yéejnit ñijeéh páantjeh ĩ jʉmbipna caá. Débólih teo wáaquíhna, queétdih ñi jéih teo wáacbipna caá. Obohjeéhtih, weémboó ñijeéh nin baácboó bahnibit wã jʉm jwʉhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pánihna, wʉnniíh bácahjidih jwĩpĩ́ pʉhwat pah, weemdíh chej jʉmni yíijĩh pʉohna, wã wʉnʉchah weemdíh ĩ yohat pínahdih mi ámohna caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yoobópdih yeebdíh wã naóhna caá. Nihat baácboó wĩ́ih tʉ́ini doonádih naóhna, nint bʉʉ weemdíh mi chãjatjidihbʉt ĩ naóhbipna caá. Páant ĩ naáwáchah joinít, caántdih dawá ĩ náhnibipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Páant ã niijíchah joinít, jwĩjeéh jʉmni, Judas Iscariote, sacerdotewã ĩ maáta pebhna bejnit, nin pah ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Jesús pebhna yeebdíh wã dʉó wáyat pínah jíib ¿débóo ñi wʉ̃hbi? ãt niijíp wʉt jĩ. —Páant jwiítdih ma dʉó wáyachah, treinta platajĩh ĩ chãjniji jʉ́dʉnadih jwĩ wʉ̃hbipna caá, wẽinit, ĩt niijíp wʉt jĩ. Páant niijnít, Judasdih ĩt jíib chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Páant ĩ jíib wʉ̃hnidih ʉbnit, Judasboó débólih queétdih ã dʉó wáyat pínahdih ãt jenah joyóp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Paacánni pandih jwĩ jeémát yeó jáapna jwíih waadní yeó jáapdih jwiít Jesúsdih nin pah jwĩ niíj ʉʉ́bh joyóp jĩ: —¿Ded mʉʉ́boo tígaá Pascua jeémátdih jwiítdih ma nʉmah jeémpbi? ¿Dedboo tígaá jeémát jwĩ chãjbi? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Jerusalén tʉ́tchina ñi bejeé. Caanná jʉibínit, biíc newédih jwãáhnit, caandíh nin pah ñi niijí: ‘ “Wã wʉnat pínah bahnijeh ã jʉdhna caá. Pánihna, míih mʉʉ́boó Pascua jeémátdih wã bohénitdih wã nʉmah jeémpbipna caá”, Bohéni ã niijná be’, caandíh ñi niijí, Jesús jwiítdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Páant ã niijíchah joinít, biquína jwĩjeéh jʉmnit ĩ bejep jĩ. Caanná jʉibínit, ĩ jwãáhni newé ã waóh bejni mʉʉná waadnít, jwiítdih Jesús ã nʉmah jeémát pínahdih ĩt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tʉ́ttimah, tõo ñáh jʉ̃ʉ́wʉ́chah, Jesús jwiítdih caán mʉʉná nʉmah waadnít, Pascua jeémátdih biícdih jwĩ jeémép jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Páant jwĩ jeémát pónih, Jesús jwiítdih nin pah ã niijíp jĩ: —Yoobópdih yeebdíh wã naóhna caá. Weemdíh eníhcannitdih dʉó wáini pínah ñi cãtíh ã jʉmna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Páant ã niijíchah joinít, bʉ́dí jenah joiná, jwiít nihat biquínajeh caandíh nin pah jwĩ niíj ʉʉ́bh joyóp jĩ: —¿Weém nihcan niít? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Pandih weém biícdih neéh jeémpni weemdíh eníhcannitdih dʉó wáini pínah ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Páant yeejép wã yapat pínahdih jon jã́tih Dios naáwátdih naóh yapani ãt daacáp tajĩ. Pánihna, weém nihat cã́acwã ʉ́ʉd jeñé caán ã daacátji pahjeh yeejép wã yapbipna caá. ¡Obohjeéhtih, weemdíh eníhcannitdih dʉó wáiniji yeejép pohba ã yapbipna caá! Caán ã cã́ac jʉmcah, chah ãta tʉ́i tagaá, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Páant ã niijíchah joinít, Judas, caandíh eníhcannitdih dʉó wáini pínah, Jesúsdih nin pah ã niijíp jĩ: —¿Maá, weém nihcan niít? ã niijíp jĩ. —Ma niiját pah meemjéh tigaá, Jesús caandíh ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Páant ã niiját tʉ́ttimah, Jesús pandih ʉbnit, “Tʉ́ina caá, Paá”, niíj, caandíh dajnit, jwiítdih ã wʉ̃hʉp jĩ. —Nin pan wĩ́ih bácah panihni caá. Caandíh ñi jeémé, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Páant niíj péanit, jiwá iguíh mac jʉmni pamapdih ʉbnit, “Tʉ́ina caá, Paá”, niijnít, caandíhbʉt jwiítdih ã wʉ̃hʉp jĩ. —Yeéb nihat nindih ñi babhbaá. ");
INSERT INTO cbv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nin wĩ́ih meép panihni caá. Wĩ́ih meépjĩh ĩ yéejat jíib bʉʉdáátdih jíib chãjna, dawá cã́acwãdih wã wʉn wʉ̃hbipna caá, Dios biícdih ĩ tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yeebdíh yoobópdih wã naóhna caá. Nin baácboó jʉm jwʉhna, jiwá iguíh macdih wã jwʉ́ʉb babhcan niít. Tʉ́ttimah, wã íip biícdih maáh jʉmnajeh, yeebdíh wã jwʉ́ʉb nʉmah wẽi babhbipna caá, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Páant ã niiját tʉ́ttimah, jeémp péanit, Diosdih jwĩ wẽi eo péanachah, Jesús jwiítdih Jerusalén tʉ́tchimant ã nʉmah bac bejep jĩ. Pánih bac bejnit, Olivo jeéboó bejni namádih ã nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pánih bejna, nin pah jwiítdih ã niíj naáwáp jĩ: —Bʉʉ cheijeh yeéb nihat ʉ́ʉmna, weemdíh ñi cádahbipna caá. Jon jã́tih Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘ “Ovejawãdih en daonídih wã mawachah, nihat ovejawã ĩ jweí peét bejbipna caá”, Dios ã niijná caá’, naóh yapani ãt niíj daacáp tajĩ.Pánihna, weemdíh ñi cádahat pínahdih wã jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Obohjeéhtih, weemdíh ĩ mao yohochah yʉhna, Dios weemdíh ã jwʉ́ʉb booaat tʉ́ttimah, Galilea baácna yeebdíh wã waóh bej pã́ibipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","—Queét nihat ĩ cádahachah yʉhna, weémboó wã cádahcan niít, Pedro ã niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Yoobópdih meemdíh wã naóhna caá. Bʉʉ cheijeh mʉjbai ã ewat pínah jã́tih biíc peihcanni láa ‘¡Caandíh wã jéihcan caá!’ ma niíj yeebipna caá, Jesús caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Majeéh weemdíhbʉt ĩ mawachah nihna, weémboó ma niiját pah wã niijcán niít, Pedro chah ã jwʉ́ʉb niijíp jĩ. Jwiít nihatbʉt biíc yoobó jwĩ niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Olivo jeená pʉ́ʉh laab béjnit, Getsemaní ĩ niijní pácahi jʉmʉpna jwĩ jʉibínap jĩ. —Conboó Diosdih ʉʉ́bʉ́dih wã bej jwʉhʉchah, ninjĩh ñi chʉ́ʉd páñaá, Jesús jwiítdih ã niijíp jĩ ");
INSERT INTO cbv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Páant niíj péanit, Pedrodih, Zebedeo ã weh chénat pahdihbʉt yʉʉ́pbit ã nʉmah bejep jĩ. Pánih bejnit, ded pah ã yapat pínahdih bʉ́dí jenah joinít, ãt jĩ́gah jwíihip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Tʉbit jĩ́gahnit, wʉnni pah caá wã jʉmʉp. Pánihna, yeebbʉ́t ʉ̃ocanjeh, ninjĩh ñi ʉʉ́bh páñaá, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Páant niíj péanit, chibít yʉʉ́pbit bej, baácboó páah yoh ñajnit, “Paá, ma náahna, weemdíh ma wʉnat tʉ́ʉtca bojoó. Obohjeéhtih, weém wã wʉníhcah yʉhna, meémboó páant ma náah yacachah, wã wʉn wʉ̃hbipna caá”, Jesús Diosdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Páant niíj ʉʉ́bh péanit, Jesús queét biíc peihcannit ã bohénit ĩ páñapboó ãt jwʉ́ʉb jʉyʉ́p wʉt jĩ. Páant ã jwʉ́ʉb jʉí enechah, ʉ̃ona ĩt chãjap wʉt jĩ. —¿Pedro, biíc horabit ʉ̃ocanjeh, ma noón pã́icannit beé? ");
INSERT INTO cbv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tʉ́i jáanit, Diosdih yeebdíh ʉʉ́bát caá náahap, yéej chãjat jenah joyátdih ñi yap yohat tʉ́ʉt niijná. Tʉ́i chãjíhna yʉhna, jáacan, ʉʉ́bhcan, páant ñi jéih bʉʉjácan niít, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Páant niíj péanit, jwʉ́ʉb ʉʉ́bʉ́dih bejnit, nin pah ãt niijíp wʉt jĩ: “Paá, cã́acwãdih wã wʉn wʉ̃hat pínahdih ma náah yacachah, wã yeejép yapíhcah yʉhna, ma náahat pah weemdíh ã yapa naáh”, Diosdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pánih ʉʉ́bh péanit, biíc peihcannit pã́init pebhboó ã jwʉ́ʉb jʉyʉ́chah, jwʉ́ʉb ʉ̃ona ĩt chãjap wʉt jĩ. Tʉbit quíib chei jʉmʉchah, ĩt jwʉ́ʉb ʉ̃wah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Páant ĩ ʉ̃wʉchah ennit, jwʉ́ʉb ʉʉ́bʉ́dih ãt bejep wʉt jĩ. Pánih bejnit, biíc yoobó ãt ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pánih ʉʉ́bh péanit, ã bohénit pebhna jwʉ́ʉb jʉinít, nin pah ãt niijíp wʉt jĩ: —¿Yeéb páantjeh ʉ̃onit, choó niít ñi chãjap? Páant bóojeh tigaá. Bʉtéh yeejépwã weemdíh tewedih jʉiná caá ĩ chãjap. ");
INSERT INTO cbv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ñi jáa bojoó. Chóbe, jwĩ chéenwã ĩ páñapboó jwĩ bejjĩh. Weemdíh eníhcannitdih dʉó wáini ã jʉiná caá, queétdih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Páant ã niijíchahjeh, ã bohéniji Judas ã jʉyʉ́p jĩ. Judasjeéh dawá cã́acwãbʉt ĩ jʉyʉ́p jĩ. Íibat naaná, máa quiítnadihbʉt ĩ bíbohop jĩ. Sacerdotewã ĩ maáta, bita jwĩ maátabʉt queétdih ĩt wahap tajĩ, Jesúsdih teonit, ĩ pebhna ĩ ʉb bejat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jesús pebhna ĩ jʉ̃ʉ́wát pínah jã́tih, Judasboó queétdih nin pah ãtát niíj jéihya naáwáp wʉt jĩ: “Pʉ́o tíibdih nomnit, wã ʉʉ́bhnidih ñi teweép”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pánihna, jwĩ pebhna jʉinít, Judasboó Jesús pebh ã jʉyʉ́p jĩ. —¿Ma jʉm, Bohéní? niíj ʉʉ́bhnit, Jesúíh pʉ́o tíibdih ã nomop jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Páant ã niíj ʉʉ́bʉ́chah enna, Jesús caandíh nin pah ã niijíp jĩ: —Wã chéen, ma jenah joyátji pah ma chãjaá, ã niijíp jĩ. Páant Judas ã ʉʉ́bʉ́chah ennit, Jesúsdih tewedih jʉ̃óhnit caandíh ĩ tewep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Páant ĩ tewechah ennit, biíc jwĩjeéh jʉmniboó íibat naadíh jwã́at wái ʉbnit, sacerdotewã ĩ maáhdih teo wʉ̃hniíh moli chóodih ã dʉ́ʉc bóod yohop jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Páant ã dʉ́ʉc bóod yohochah ennit, Jesús caandíh nin pah ã niijíp jĩ: —Míih íibat naadíh ma jwʉ́ʉb jwejeé. Nihat íibat naajĩ́h míic maonitboó íibat naajĩ́h ĩ wʉnbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Nindih ñi jéihcan niít? Wã íip ã teo wáacatdih wã ʉʉ́bʉ́chah, cien mil ángelwãdih ãta wah taga, weemdíh ĩ ʉb bejat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Obohjeéhtih, páant ã chãjachah, ã naáwátdih naóh yapanit ĩ niíj daacátji pah ãta yapcan tagaá. Pánihna, wã íip weemdíh ã náah yacat pah, jon jã́tih ĩ niíj daacátji pahjeh tigaá weemdíh yapat náahap, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Páant niíj péanit, caandíh tewedih jʉinítboodíh nin pah ã niijíp jĩ: —¿Nʉʉmnídih tewat pah íibat naaná, máa quiítnadihbʉt ʉbnit, weemdíh tewedih ñi jʉ̃óhnit beé? Yeó jáap jʉmat pah Dioíh mʉʉ́boó ñijeéh wã jʉmʉchah yʉhna, weemdíh ñi teocap be. ");
INSERT INTO cbv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Obohjeéhtih, Dios naáwátdih naóh yapanit ĩ daacátji pah bʉʉ weemdíh yapat ã náahna caá, ã niijíp jĩ. Páant ã yapachah enna, jwiít nihat ã bohénit jwĩ jweí peét bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesúsdih teonitboó sacerdotewã ĩ maáh Caifáíh mʉʉná ĩt ʉb waad béjep wʉt jĩ. Jesúsdih naóh yacat tʉ́ʉt niijná, ã́ih mʉʉ́boó jʉmni míic wáacat tólihboó sacerdotewã ĩ maáh, caandíh nʉmp jʉmnit maáta, Moisés ã wʉtatjidih bohénit, bita jwĩ maátabʉt ĩt míic wáac jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Obohjeéhtih, Pedroboó Jesúsdih yʉʉ́pjeh ãt en péenap wʉt jĩ. Pánihna, sacerdotewã ĩ maáíh mʉʉ́ wáihyat jʉ́dʉboojéh ãt waád jʉibínap wʉt jĩ. Pánih waád jʉibínit, ded pah Jesúsdih ĩ chãjachah, jéihyat tʉ́ʉt niijná, Pedro tʉʉ cʉ́ʉt jwẽ́ejdih, mʉʉdíh wapnit biícdih, ãt mée chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sacerdotewã ĩ maáta, nihat bita maáta biícdih Jesúsdih mao yohat tʉ́ʉt niijná, yee naóh yacnit pínahdih ĩt bidip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Obohjeéhtih, dawá yee naóhnit ĩ jʉmʉchah yʉhna, chénewã biíc yoobó niijnítdih ĩt bid jʉicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Maatápdih ĩ bidat tʉ́ttimah, chénewã waád jʉibínit, nin pah ĩt niíj yee naóh yacap wʉt yʉh jĩ: —Caán nin pah ã niijíchah, jwĩ joyóp be: ‘Dioíh mʉʉdíh wã yoh beedábipna caá. Pánih yohnit, biíc peihcanni yeó jáap tʉ́ttimah jáap mʉʉ́ wã chãj péabipna caá, páant mʉntih’, ã niijíp be, ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Páant ĩ niijíchah joinít, sacerdotewã ĩ maáh ñah ñʉhnit, Jesúsdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih tigaá queétdih ma jepahcan? ¿Dedé tibeé ma yéej chãj, meemdíh páant ĩ niíj naóh yacachah? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Páant ã niijíchah joiná yʉhna, Jesús ãt jepahcap wʉt jĩ. Páant ã jepahcah enna, sacerdotewã ĩ maáh nin pah caandíh ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Meemdíh wã wʉtna caá. Dios ã enechah, yoobópdih jwiítdih ma naáwá. ¿Meém Dios wʉ̃ʉ́h, ã wahni Cristo niít ma jʉmʉp? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Páant ma niiját yoobópdih tigaá. Yeéb nihatdih nin pah wã naóhna caá: Weém nihat cã́acwã ʉ́ʉd jeñé Chah Wẽpni ã jéihyepmant bóo bʉwámant chʉ́ʉdnit, wã wʉtʉchah, mah tólihjih wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chahbʉt, ñi enbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Páant ã niijíchah joinít, sacerdotewã ĩ maáh bʉ́dí ãt íijip wʉt jĩ. Ã íijat jʉ́ʉtna, ã́ih jih bóo yégueh chóodih ãt yeo wáyap wʉt jĩ. Pánih yeo wáina, ãjeéh jʉmnitdih nin pah ãt niijíp wʉt jĩ: —Nin newé ‘Weém Dios wʉ̃ʉ́h caá’, ã niíj yeenachah, yeéb nihat ñi joiná beé. Pánihna, bita ĩ naáwátdih jwĩ náahcan caá. ");
INSERT INTO cbv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Yeébboó ded pah tigaá ñi niíj jenah joí? queétdih ãt niijíp wʉt jĩ. —Caandíh peéh mao yohat caá náahap, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Páant niijnít, Jesúíh móotdih coí jã́hanit, téihyajĩh ĩt póocop wʉt jĩ. Bitabʉt téihyajĩh ã́ih móotdih ĩt mawap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Pánih maonit, nin pah caandíh ĩt niíj deoh naáwáp wʉt jĩ: —Dios ã wahni Cristo jʉmna, ma naáwá ¿déhe tibeé meemdíh mao? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Páant ĩ chãjat pónih, wáihyat jʉ́dʉ diítna Pedro ã mée chʉ́ʉdʉchah, teo wʉ̃hnih ã pebh jʉibínit, nin pah mit niíj ʉʉ́bh joyóp wʉt jĩ: —¿Meembʉ́t Jesús Galilea baácdih bóojeéh péeni nihcan niít? mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Ãjeéh péeni nihcan caá. ¿Ded pah niij tígaá ma chãj? Pedro caántdih ãt niíj yee jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Páant niijnítjeh, tʉʉ cʉ́ʉt jwẽ́ejmant bejnit, jẽcna ãt jwei béj ñʉhʉp wʉt jĩ. Páant caánboó ã jwei ñʉ́hʉchah, biíh wili jwʉh caandíh mit enep wʉt jĩ. Pánih ennit, caanjĩ́h jʉmnitdih nin pah mit niijíp wʉt jĩ: —Nin Jesús Nazaret tʉ́tchidih bóojeéh jʉmni caá, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—Dios ã enechah, yoobópdih wã naóhna caá. ¡Ma niijní newédih wã jéihcan caá! Pedro ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Páant ã niiját tʉ́ttimah, caanjĩ́h ñʉhnitboó Pedro pebh bejnit, —Yoobópdih meém ĩjeéh péeni mʉn tigaá. Míih wéheat Galilea baácdih moón ĩ wéheat pah caá ã jʉmʉp. Nihat caandíh pej jʉm bejnit Galilea baácdih moón ĩ jʉmʉchah, meembʉ́t ĩjeéh jʉmni mʉn tigaá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Weém yeeni nihcan caá. Yoobópdih yeebdíh wã naóhna caá. ¡Ñi niijnídih weém wã jéihcan caá! Páant yoobópdih wã naóhcah, ¡Dios weemdíh ã peéh chãja naáh! ãt niijíp wʉt yʉh jĩ. Páant ã niijíchahjeh, mʉjbai ãt ewep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Páant ã ewechah joinít, “Mʉjbai ã ewat pínah jã́tih, biíc peihcanni láa ‘Caandíh wã jéihcan caá’, ma niijbípna caá”, Jesús ã niijátjidih ãt náhninap wʉt jĩ. Pánih náhnina, bac bejnit, bʉ́dí ãt jʉñʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tʉ́ttimah, baáb jéenechah, sacerdotewã ĩ maáta, jwiít judíowã jwĩ maáta biícdih míic wáacnit, Jesúsdih ĩ mawat tʉ́ʉtat pínahdih ĩt míic wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pánih míic wéhe péanit, Jesúsdih chéonit, Maáh Pilato pebhna ĩt wahap wʉt jĩ. Pilato Romano maáta ĩ maáh waadáni jʉmna, jwĩ́ih baácdih moondíh wʉtni ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesúsdih eníhcannitdih dʉó wáinijiboó, caandíh ĩ mao yohat pínahdih jéihnit, bʉ́dí ãt jĩ́gahap wʉt jĩ. Pánih jĩ́gahnit, ĩ jíib wʉ̃hniji treinta jʉ́dʉnadih sacerdotewã ĩ maáta, jwĩ maátadihbʉt ãt jwʉ́ʉbaíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Pánih jwʉ́ʉbaíhnit, nin pah queétdih ãt niijíp wʉt yʉh jĩ: —Weém wã tʉ́i chãjcap be. Yeebdíh wã dʉó wáiniboó yoobópdih yéej chãjcanni ãt jʉmʉp taga, ãt niijíp wʉt jĩ. —Meemjéh tigaá páant mat náahap taga. Pánihna, jwĩ́ih pínah nihcan, míih pínahjeh caá, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Páant ĩ niijíchah joinít, Judasboó ĩ wʉ̃hni jʉ́dʉnadih Dioíh mʉʉ́boó ãt yoh waadá bojop wʉt jĩ. Pánih yoh waadá péanit, biáboó bejnit, ãt míic jõp wái wʉnʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Páant ã yoh waadá bojniji jʉ́dʉnadih ʉbnit, nin pah sacerdotewã ĩ maáta ĩt míic niijíp wʉt jĩ: —Nin jʉ́dʉna, cã́acdih mawat náahna, jwĩ jíib wʉ̃hni beé. Páant ã jʉmʉchah, Dioíh mʉʉ́boó jwĩ jéih jwejcan caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Páant niíj míic wéhe péa, bac bejnit, wáam dah chãjniíh bainí baácdih ĩt jíib chãjap wʉt jĩ, biámant moón caán tʉ́tchina jib jʉinít ĩ wʉnʉchah, ĩ yohat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Páant ĩ chãjachah, caán baácdih “Meép jʉmni baác”, jwiít jwĩpĩ́ niijná caá. ");
INSERT INTO cbv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Páant ã yapat pínahdih Dios naáwátdih naóh yapanit Jeremíaswã nin pah ĩt niíj daacáp tajĩ: “Judíowã ĩ maáta caandíh ĩ mawat pínah jíib treinta platajĩh ĩ chãjniji jʉ́dʉnajeh ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pánihna, caán jíibjĩh wáam dah chãjniíh baácdih Dios weemdíh ã wʉtat pah ĩt jíib chãjap tajĩ”, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Páant ã chãjat pónih, sacerdotewã Jesúsdih ĩ ʉb jʉibínachah ennit, Maáh Pilato caandíh nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Meém yoobópdih judíowã ĩ maáh niít? ãt niijíp wʉt jĩ. —Ma niiját pah tigaá, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Obohjeéhtih, sacerdotewã ĩ maáta, jwĩ maáta biícdih caandíh ĩ jwʉ́ʉb naóh yacachah joiná yʉhna, Jesús queétdih ãt jepahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Páant ã jepahcah enna, Pilatoboó Jesúsdih nin pah ãt niijíp wʉt jĩ: —Páant meemdíh ĩ niíj naóh yacachah, joiná yʉhna, ¿queétdih ma jéih jepahcan niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Páant ã niijíchah joiná yʉhna, dedé ĩ naóh yacatdih Jesús ãt jepahcap wʉt jĩ. Páant ã jepahcah ennit, Maáh Pilato bʉ́dí ãt joí wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pascua jʉmat pah Maáh Pilato biíc cã́ac nemat mʉʉ́boó jʉmni, cã́acwã ĩ bacaat tʉ́ʉtnidih ãpĩ́ bacanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Caán láa bʉ́dí yéej chãjni, chah wʉ̃t yáani, Barrabás wʉ̃t jʉmni, nemat mʉʉ́boó ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pánihna, dawá cã́acwã ã pebhna ĩ jʉibínachah enna, Pilato queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Deddih tigaá yeebdíh wã baca wʉ̃h bií? ¿Barrabásdih ñi náah niít? ¿Jesús, Dios ã wahni Cristo ĩ niijnídih niít ñi náahap? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Dawá cã́acwã Jesúsdih ĩ weñechah, sacerdotewã ĩ maátaboó caandíh tʉbit íijna, caandíh ĩt mawat tʉ́ʉtʉp wʉt jĩ. Pánihatdih jéihnit, Pilato cã́acwãdih páant ãt ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato peéh chãjat pínahdih naóhni chʉ́ʉdatdih ã chʉ́ʉdat pónih, ãjeéh bóli papélah nʉ́ojĩh caandíh nin pah mit niíj daác wahap wʉt yʉh jĩ: “Bʉʉ chei oo jʉ́mna, caandíh bʉ́dí ʉ́ʉm náah jʉmnidih wã oo jʉ́mʉp be. Caánboó yéej chãjcanni caá. Pánihna, ma mawat tʉ́ʉtca bojoó”, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Cã́acwã Jesúsdih ĩ náahachah yʉhna, sacerdotewã ĩ maáta Barrabásdih bacaat tʉ́ʉtnit, Jesúsboodíh ã mao yohat tʉ́ʉtat pínah niijná, queétdih ĩt jac wʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tʉ́ttimah, cã́acwãdih Pilato nin pah ãt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ: —¿Deddih tigaá wã bacaat pínahdih ñi náah? ãt niijíp wʉt jĩ. —¡Barrabásdih ma bacaat tʉ́ʉtʉ́! cã́acwã ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Páant ñi niijíchah, Jesús Dios ã wahni Cristo ñi niijnídih ded pah tigaá wã chãjbi? ãt niijíp wʉt jĩ. —¡Caandíh cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! nihat ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Dépanihna? ¿Dedé tibeé ã yéejatji? ãt niijíp wʉt jĩ. —¡Caandíh cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! chah ĩt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Páant ĩ niíj ñaacáchah joinít, queétdih jéih yap yohcan, chah ĩ íijatdihbʉt enna, mah pamapdih ʉbnit, nihat ĩ enechah, ãt téih chocop wʉt jĩ. Pánih téih chocnajeh, queétdih nin pah Pilato ãt niijíp wʉt jĩ: —Nin newédih yeebjéh tigaá ñi mawat tʉ́ʉtʉp. Páant ñi wʉtat jíib yeebdíhjeh peéh chãjat ã jʉmʉ naáh. Weémboodíh peéh chãjat ã wihcan niít, cã́acwãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—¡Caandíh mawat jíib jwiítdih, jwĩ jʉimenádihbʉt caán peéh chãjat ã jʉmʉ naáh! nihat cã́acwã ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Páant ĩ niiját tʉ́ttimah, ĩ wʉtat pah Barrabásdih ãt bacaat tʉ́ʉtʉp wʉt jĩ. Obohjeéhtih, Jesúsboodíh ã́ih soldadowãdih ãt ʉb bejat tʉ́ʉtʉp wʉt jĩ, caandíh pʉ̃init, cruzboó péoh dodhnit, ĩ mao yohat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pánih ʉb bejnit, Pilatoíh mʉʉ́ diítna Jesúsdih ĩt ʉb waad béjep wʉt jĩ. Pánih ʉb waad béjnit, caanjĩ́h wapnit soldadowã Jesús pebh ĩt ñʉh pʉ́ʉda bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pánih ñʉhna, Jesúíh yégueh jih bóo chóodih tóo dʉgnit, maáh ã dʉwát pah jígohni dʉʉni chóodih caandíh ĩt yacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Maáh ã dʉwát jʉ́dʉ pah chãjnit, óot pihdih péeb wao péanit, Jesúíh wao dáhdih ĩt yacap wʉt jĩ. Maáh ã wẽpat pah ã jʉ́ʉtat pínah máa doóbhdih ã́ih jéihyepmant bóo téihyajĩh ĩt tewat tʉ́ʉtʉp wʉt jĩ. Pánih chãj péanit, maáhdih ĩpĩ́ chãjat pah ã pebh ĩt bódicha caj yoh ñajap wʉt jĩ. Pánih bódicha caj yoh ñajnit, nin pah caandíh ĩt niíj dehwep wʉt jĩ: —¡Ma tʉ́i jʉmʉʉ́, judíowã ĩ maáh! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Páant niíj deoh, caandíh coí jã́hana, ã bíbohni máa doóbhdih jwʉ́ʉb ʉbnit, caán doóbhjĩh ã́ih wao dáhdih dawá láa ĩt pʉñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pánih deoh naóh péa, ĩ yacniji yéguehdih tóo dʉgnit, ã́ih yéguehdihjeh ĩt jwʉ́ʉb yacap wʉt jĩ, páant mʉntih. Pánih yac péa, cruzboó péoh dodhnit, mao yohat tʉ́ʉt niijná, caandíh ĩt ʉb bac bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ĩ mao yohat pínah jeéboó ʉb bejna, Simón, Cirene baácdih bóodih ĩt jwãááp wʉt jĩ. Pánih jwãáhnit, caandíh Jesúíh cruzdih ĩt bewat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pánih bejnit, Gólgota wʉ̃t jʉmʉpna ĩt jʉibínap wʉt jĩ. “Gólgota”, niijná, “Waó iidíp jeé”, niijná ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pánih caanná jʉibínit, bijnijĩh widnit, ĩ ʉb bejni jiwá iguíh macdih Jesúsdih ĩt tóihyop wʉt yʉh jĩ. Obohjeéhtih, bainí déeb joinítjeh, ãt babhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Caandíh cruzboó ĩt péoh dodhdop wʉt jĩ. Pánih péoh dodh péanit, ã́ih yégueh chóojidih “¿Deíh tigaá ã jʉmbi?” míic niijnít, tíhwat jʉ́dʉnabitjĩh ĩt yoh tíhwip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pánih chãj péanit, pã́i chʉ́ʉdnit, caandíh ĩt wapap wʉt jĩ, bita caandíh ĩ ʉb bejcat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","“Jesús judíowã ĩ maáh caá”, bita ĩ niíj daácniji naadíh Jesús wao cháh cruzdih soldadowã ĩt nah péoh bʉ́ʉdhdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chénewã nʉʉmnítdihbʉt mao yohat tʉ́ʉt niijná, biíh cruznadih Jesús pebh ĩt péoh dodhdop wʉt jĩ. Biícdih ã jéihyepmant bóo bʉwámant, biíhdih ã wáyámant bóo bʉwámant péoh dodhnit, queét tac yoób Jesúsdih ĩt péoh dodhdop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Cruz pebh en yap bejnit, Jesúsdih nin pah yeejép ĩt niíj deoh naáwáp wʉt jĩ: —¡Eneéh bʉca! ¿Dioíh mʉʉdíh yohnit, biíc peihcanni yeó jáap tʉ́ttimah, meém caán mʉʉdíh jwʉ́ʉb chãjni pínah niít? Pánihni jʉmna, Dios wʉ̃ʉ́h yoobát jʉmna, wʉncat tʉ́ʉt niijná, caán ĩ péoh dodhdopmant meemjéh ma dei jʉ̃ʉ́wʉ́, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, jwĩ maátabʉt biíc yoobó ĩt deoh naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Bitadih tʉ́i teo wáacni jʉmna yʉhna, caanjéh ã jéih míic teo wáaccan caá. ‘Judíowã ĩ maáh caá’, niijná, caán míicjeh ã dei jʉ̃ʉ́wʉ́chah enna, caandíh jwĩ jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‘Weém Dios wʉ̃ʉ́h caá. Caandíh wã tʉ́i jenah joiná caá’, ã niiját jíib, Dios caandíh oina, ã tʉ́i ʉbʉ naáh, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ãjeéh ĩ péoh dodhnit nʉʉmnítbʉt biíc yoobó caandíh ĩt deoh naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesús cruzboó ĩ péoh dodhni ã ñʉhʉchah, yeó jáap tac yoób ã dʉpʉ́áh bejep jĩ. Nihat baác dʉpʉ́niji, biíc peihcanni horas tʉ́ttimah, ã jwʉ́ʉb baáb jwʉ́ʉb bejep jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Páant ã jwʉ́ʉb baabát pínah jã́tihbit, Jesús nin pah ãt wẽp niíj ñaacáp wʉt jĩ: “Elí, Elí, ¿lemá sabactani?” niijná, “¿Wĩ́ih Dios, wĩ́ih Dios, dépanih tigaá weemdíh ma éemp bej?” Jesús ãt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Páant ã niijíchah joinít, biquína caanjĩ́h ñʉhnit nin pah ĩt míic niijíp wʉt jĩ: —Dios naáwátdih naóh yapani Elíasjidih bidna caá ã chãjap, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Biíc ĩjeéh jʉmni ñáo ñah bejnit, páab chʉí déedih ʉbnit, bijni jiwá iguíh macdih báah, máa doóbh yapatdih chéo bʉ́ʉdh, jʉ́ʉt ñahanit, Jesúsdih ãt wái nomat tʉ́ʉtʉp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Obohjeéhtih, wái nomat tʉ́ʉtnidih bita nin pah ĩt niijíp wʉt jĩ: —¡Ã jʉmʉ naáh! Elíasji nindih teo wáacadih ã jʉ̃ʉ́wʉ́chah, jwĩ en jwʉh jĩíh, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Páant ĩ niiját tʉ́ttimah, tʉbit ñaácnit, Jesús ãt wʉnah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Páant ã wʉnʉchahjeh, Dioíh mʉʉ́ diítboó ĩ jãh yaíhni bʉ́dí wʉ́ʉpni chóo yeo dei bejna, chéne chóo pah ãt chãwáp wʉt jĩ. Pánihat pónih, baác bʉ́dí méména, jee dáhna ãt pah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pánihichah, cã́acwãíh bácahjidih ĩ yohopji jeéboó ã bʉ́ʉh bejechah, Diosdih jepahnitji jwʉ́ʉb boo pʉd jʉ̃óhnit, dawá ĩt bacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pánihna, Jesús ã boo pʉd jʉ̃ʉ́wát tʉ́ttimah, Jerusalén tʉ́tchina ĩ jwʉ́ʉb waad béjechah, dawá queétdih ĩt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Páant baác méméatdih nihat biíh ã yapachah enna, Jesúsdih wapnit soldadowã ĩ maáh, ãjeéh jʉmnitbʉt bʉ́dí ʉ́ʉmnit, nin pah ĩt míic niijíp wʉt jĩ: —¡Yoobópdih nin Dios wʉ̃ʉ́h tigaá ãt jʉmʉp! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chibít yʉʉ́pbit dawá yaádhbʉt ĩt en ñʉhʉp wʉt jĩ. Queét yaádh jwiít biícdih Galileamant jʉ̃óhnit, Jesúsdih teo wáacnitji ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ĩjeéh jʉmnit, Mágdala tʉ́tchidih bóli María, biíh wili Maríabʉt mit jʉmʉp wʉt jĩ. Caánt José, ã ʉ́ʉd Santiago ĩ íin mit jʉmʉp wʉt jĩ. Biíh wili Zebedeo ã weh íin mit jʉmʉp wʉt jĩ. Queét biíc peihcannit yaádh ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jesús ã wʉnat tʉ́ttimah, caan chéyeh tõo ñáh jʉ̃ʉ́wát pínah jã́tih, José, Arimatea tʉ́tchidih bóo, Jesúsdih jepahni, ã́ih bácahjidih ʉb deyanit, yohat tʉ́ʉt niijná, cruzboó ãt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Caanjĩ́h jʉmniji Pilatodih ʉʉ́bʉ́dih ãt bejep wʉt jĩ. Páant ã ʉʉ́bʉ́chah joinít, Jesúíh bácahjidih Pilato ã́ih soldadowãdih caandíh ãt wʉ̃hat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Páant ã jepahachah joinít, José cruz jʉmʉpna jwʉ́ʉb jʉibínit, Jesúíh bácahjidih ʉb deya, lino wʉ̃t jʉmni quei wíhcanni yégueh chóojĩh ãt pinip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","José ã wʉnʉchah, caandíh ĩ yohat pínah jeé íitdih ãtát baadát tʉ́ʉtʉp wʉt jĩ. Caán íitdihjeh Jesúíh bácahjidih ãt yohop wʉt jĩ. Páant ã yohat tʉ́ttimah, caandíh nemat tʉ́ʉt niijná, caán íitdih waadápboó bʉ́dí jeé jʉ́dʉdih tóo pʉ̃tʉ́ bejnit, caán íitdih ãt nemep wʉt jĩ. Pánih nem péanit, ã́ih mʉʉná ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Páant ã chãjachah, Mágdala tʉ́tchidih bóli María, biíh Maríabʉt caandíh ã yohatji jeé íit pebh ĩt en chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ã wʉnniji yeó jáap, chooát yeó jáap pínah jwĩpĩ́ ámohni yeó jáap ã jʉmʉp jĩ. Tʉ́ttimah bóo yeó jáapdih sacerdotewã ĩ maáta, fariseowãbʉt Maáh Pilato pebhna bejnit, nin pah ĩt niíj ʉʉ́bʉ́p wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Maá, caán yeeniboó jwĩjeéh jʉm jwʉhna, ‘Wʉnna, biíc peihcanni yeó jáap tʉ́ttimah wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá’, ã niijátjidih jwĩ náhnina caá. ");
INSERT INTO cbv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pánihna, caandíh ĩ yohopji jeé íitdih biíc peihcanni yeó jáapna ã nematdih míih soldadowãdih ma tʉ́i wapat tʉ́ʉtʉ́, ã bohénit ã́ih bácahjidih ĩ nʉʉmcát pínah niijná. Pánih nʉʉmnít, cã́acwãdih ã boo pʉd jʉ̃ʉ́wátdih ĩta naóh tagaá. Pánih naóhna, Jesús ã jwíih yeeatji chah ĩ pée yee naáwát ãta jʉm tagaá, Pilatodih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Páant ĩ niijíchah joinít, Pilato nin pah ãt niíj jepahap wʉt jĩ: —Biquína soldadowãdih nʉmah bejnit, yeebjéh ñi jéihyat pah caán íitdih nemnit, queétdih ñi tʉ́i wapat tʉ́ʉtʉ́, Pilato ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Páant ã niijíchah joinít, soldadowãdih nʉmah bej, caán íitdih José ã nemniji jeé jʉ́dʉdih bʉʉjcán nah chéonit, soldadowãdih ĩt wapat tʉ́ʉtʉp wʉt jĩ. Pánih chãj péanit, queét maáta ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jwiít judíowã jwĩ chooát yeó jáap tʉ́ttimah bóo yeó jáap ã baáb jéenechah, Mágdala tʉ́tchidih bóli María, biíh wili Maríabʉt Jesúíh bácahdih José ã yohopji jeé íitboó enedih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Páant caanná ĩ jʉibínachah, Dioíh ángel jeámant ã dei jʉ̃ʉ́wʉ́chah, baác bʉ́dí ãt méménap wʉt jĩ. Pánih dei jʉ̃óhnit, José ã nemniji jeé jʉ́dʉdih pʉ̃tʉ́ dodhnit, caanjíh ãt chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Caán ángel wedóát pah jígohni ã jʉmʉchah, ã́ih yéguehbʉt tʉ́i yeh iigní ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pánihna, caandíh enna, caán jeé íitdih wapnit soldadowã bʉ́dí ʉ́ʉmna, méménit, wʉnnit pah ĩt bʉʉg ñájap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Caanjĩ́h chʉ́ʉdni ángel queét yaádhdih nin pah ãt niijíp wʉt jĩ: —¡Ñi ʉ́ʉmca bojoó! Cruzboó ĩ péoh dodh mao yohniji Jesúsdih ñi bidatdih wã jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Obohjeéhtih, ninjĩh ã wihcan caá. Ã niijátji pah jáantjeh ã boo pʉd jʉ̃ʉ́wʉ́p be. Ã lajapjiboó ñi en jʉ̃ʉ́wʉ́. ");
INSERT INTO cbv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Caandíh en péanit, waícanjeh ã bohénitjidih nin pah ñi niíj naóhbi jwʉhʉʉ́: ‘Jesús ãt boo pʉd jʉ̃ʉ́wʉ́p tabeé. Galilea baácna yeebdíh waóh bej pã́ina caá ã chãjap. Caanná bejnit, caandíh ñi enbipna caá’, queétdih ñi niijí. Páant beé yeebdíh niíj naáwádih wã jʉ̃ʉ́wʉ́p be, ángel queét yaádhdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Páant ã niijíchah joinít, queét yaádh yohopji jeé íitmant ĩt ñáo jwʉ́ʉb bejep wʉt jĩ. Pánih ñáo jwʉ́ʉb bejnit, ʉ́ʉmna yʉhna, bʉ́dí wẽinit, ã bohénitjidih naáwádih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Páant ĩ bejechah, Jesús jwʉh queét yaádhdih ãt jígohop wʉt jĩ. —¿Ñi jʉ̃óhca beé? ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ã́ih jítcha pebh páah yoh ñajnit, ã́ih wʉ́ʉdih pin teonit, caandíh ĩt weñep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Páant ĩ chãjachah enna, queét yaádhdih nin pah ãt niijíp wʉt jĩ: —Ñi ʉ́ʉmca bojoó. Wã ʉ́ʉdwã panihnitdih nin pah ñi niíj naóhbi jwʉhʉʉ́: ‘Waícanjeh nin tʉ́tchimant bacnit, Galilea baácna ñi bejeé. Caánboó Jesúsdih ñi jwãáhbipna caá’, queétdih ñi niijí, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Queét yaádh tʉ́tchina ĩ jwʉ́ʉb bejat pónih, biquína caán íitdih wapnit soldadowãboó sacerdotewã ĩ maáta pebhna ĩt bejep wʉt jĩ. Ĩ pebhna jʉibínit, ded pah ĩ yapatjidih queétdih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Páant ĩ naáwáchah joinít, caán ã yapatjidih míic wéheat tʉ́ʉt niijná, jwĩ déewã maátadihbʉt ĩt míic wáacat tʉ́ʉtʉp wʉt jĩ. Pánih míic wéhe péanit, queét soldadowãdih bʉ́dí ĩt jíib chãjap wʉt jĩ, ded pah ã yapatjidih yoobópdih ĩ naóhcat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pánih jíib chãjnit, nin pah queétdih ĩt niíj wʉtʉp wʉt jĩ: —Bitadih nin pah ñi niijí: ‘Chei jwĩ ʉ̃wat pónih, ã bohénitjiboó jʉ̃óhnit, ã́ih bácahjidih ĩt nʉʉmʉ́p tabe’, ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Páant ã yapatji doonádih Maáh Pilato ã joyóchah, jwiítboó caandíh jwĩ ámoh naóhbipna caá, yeebdíh ã peéh chãjcat pínah niijná, soldadowãdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Páant ĩ niijíchah joinít, ĩ jíib chãjatdih ʉbnit, ĩ niijátji pah soldadowã ĩt naóh peetép wʉt jĩ. Páant ĩ niíj naáwáchah joinítji, bʉʉ láabʉt páantjeh nihat jwĩ déewã ĩ yee naáwátjidih ĩpĩ́ jenah joiná yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Queét yaádh tʉ́tchina jʉibínit, Jesús ã niiját tʉ́ʉtatji pah jwiít ã bohénitjidih ĩ naóh yapanap jĩ. Páant ĩ naóh yapanachah joinít, jwiít once ã bohénitji Galilea baácna bejnit, Jesús jwiítdih ã bejat tʉ́ʉtniji jeená jwĩ jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pánih caanná jʉibínit, Jesúsdih ennit, Dios wʉ̃ʉ́h ã jʉmatdih jéihna, caandíh jwĩ weñep jĩ. Obohjeéhtih, biquína jwĩjeéh jʉmnit “¿Yoobópdih Jesúsjeh niít?” ĩt niíj jenah joi jwʉ́hʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jwĩ pebh jʉinít, Jesús nin pah jwiítdih ã niijíp jĩ: —Nihat wẽpatdih wã íip weemdíh ã wʉ̃hʉp be. Páant ã wẽpat wʉ̃hni jʉmna, nihat jeáboó jʉmnit, nihat nin baácboó jʉmnitdihbʉt wʉtni wã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pánih wẽpni jʉmna, nin pah yeebdíh wã naóhna caá: Wĩ́ih tʉ́ini doonádih nihat baácdih moondíh ñi tʉ́i naáwá, jepahnit, weemdíh ĩ tʉ́i péeat pínah niijná. Páant ĩ jepahachah ennit, wã íip ã wẽpatjĩh, wã wẽpatjĩh, Tʉ́ini Espíritu ã wẽpatjĩhbʉt queétdih ñi daabánaá. ");
INSERT INTO cbv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Páant ñi daabánitdih ñi tʉ́i bohénaá, yeebdíh nihat wã wʉtatjidih queétbʉt ĩ jepahat pínah niijná. Páant ñi chãjachah, yeó jáap jʉmat pah pʉ́ʉ́ʉ́ péeni yeó jáapna páantjeh ñijeéh wã jʉmbipna caá. Páant wã naáwátdih ñi tʉ́i náhninaá, Jesús jwiítdih ã niijíp jĩ. Páant bóojeh tigaá weém Mateo wã daacát.");
INSERT INTO cbv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Weém, Marcos, nin tólihjĩh Dios wʉ̃ʉ́h Jesucristo, ded pah ã chãjatjidih, ã́ih tʉ́ini doonádihbʉt wã naóh daácna caá. Juan Daabáni ded pah ã chãjat pínahdih Dios naáwátdih naóh yapani Isaíasji ãt daacáp tajĩ. Páant ã niíj daacátji pahjeh tih Jesúíh tʉ́ini dooná ãt jwíihip tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nin pah Malaquías, Isaíasjĩh ĩt niíj daacáp tajĩ: “Ã wʉ̃ʉ́hdih Dios nin pah ã niijná caá: ‘Ma jã́tih meemdíh naóh waóhni pínahdih wã wahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Caán naóh waóhni pínah mʉʉ́ wihcapboó nin pah ã niíj ñaác bohébipna caá: “Jwĩ Maáh ã jʉ̃ʉ́wát pínah jã́tih ñi yéej chãjatdih cádahnit, tʉ́iniboodíh tʉ́ʉt nʉʉmnít, caandíh ñi tʉ́i páñaá”, ã niijbípna caá’, ã wʉ̃ʉ́hdih Dios ã niijná caá”, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juan Daabáni Isaíaswã ĩ niíj daacátji pah mʉʉ́ wihcapboó jʉmna, nin pah cã́acwãdih ãt niíj naóh bohénap wʉt jĩ: “Ñi yéej chãjatdih cádahnit, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmʉ́. Pánih tʉ́ʉt nʉʉmnít, ñi daabáát tʉ́ʉtʉ́. Páant ñi chãjachah ennit, Dios ñi yéejatdih ã yohbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nihat Judea baácdih moón, Jerusalén tʉ́tchidih moonbʉ́t caandíh joyát tʉ́ʉt niijná, ã pebhna ĩt jʉibínap wʉt jĩ. Pánih joinít, Diosdih ĩ yéejatdih ĩ naáwáchah, Juan Jordán mʉjboó queétdih ãt daabánap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juaníh yégueh chóo camello wʉ̃t jʉmni nʉñʉ́p yoócjĩh nóomnit, ĩ yacni chóo wʉt jĩ. Ã́ih jʉyáát tõp momo jiwi chóo tõp wʉt jĩ. Wʉ̃ʉ́c joowã́dih jeémpnit, belo macdihbʉt ãpĩ́ déebep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan cã́acwãdih bohéna, nin pah ãpĩ́ niíj naáwáp wʉt jĩ: “Wã tʉ́ttimah jʉ̃óhni wã chah wẽpni caá. Páant ã jʉmʉchah jenah joinít, ‘Weém oboh jʉmni caá’, wã niíj jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Weém yeebdíh mahjĩhjeh wã daabána caá. Obohjeéhtih, wã daabáát panihni caánboó yeebdíh Tʉ́ini Espíritu ã wẽpatdih bʉ́dí ã wʉ̃hbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan cã́acwãdih ã daabánachah, Galilea baác, Nazaret tʉ́tchimant Jesús ã pebhna ãt jʉibínap wʉt jĩ. Páant ã jʉibínachah, Juan caandíhbʉt Jordán mʉjboó ãt daabánap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pánih daabá péanachah, Jesús mʉjna ñʉhniji ãt aab ñʉ́hʉp wʉt jĩ. Pánih aab ñʉ́hnitjeh, Jesús ã enechah, jeá ãt jéweah bejep wʉt jĩ. Páant ã jéweah bejechah, jop pah jígohni Tʉ́ini Espíritu jeámant dei jʉ̃óhnit, caandíh ãt jʉí jaamáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Páant ã jʉí jaamáchah, “Meém wã wʉ̃ʉ́h, wã oini caá. Meemdíh bʉ́dí wã wẽina caá”, Dios jeámant ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Juan caandíh ã daabáát tʉ́ttimah, Tʉ́ini Espíritu Jesúsdih mʉʉ́ wihcapboó ãt nʉmah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Páant ã nʉmah bejechah, caánboó cuarenta yeó jáap Jesús ãt jʉmʉp wʉt jĩ. Páant ã jʉmʉchah, nemépwã ĩ maáh, Satanás, Jesúsdih ãtih yeejép chãjat tʉ́ʉtʉp wʉt yʉh jĩ. Pánihna, Jesús mʉʉ́ wihcapboó nʉñʉ́pwã biícdih ã jʉmʉchah, ángelwã caandíh ĩt tʉ́i en dawáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juandih nemat mʉʉ́boó ĩ nemat tʉ́ttimah, Jesús Galilea baácna Dios ã maáh jʉmat tʉ́ini doonádih naáwádih ãt bejep wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Nihat baácdih moondíh Dios ã maáh jʉmatdih ã jʉ́ʉtat pínah bahnijeh ã jʉdhna caá. Pánihna, tʉ́ini doonádih joinít, ñi yéej chãjatdih cádahnit, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmʉ́”, cã́acwãdih ãpĩ́ niíj naóh bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Páant niíj bohé bejna, Galilea íimdih dei jʉibí, pʉ́ʉd bejnit, Simón, ã ʉ́ʉd Andrésjĩh queéj jʉ́ʉt maona, ĩ́ih ñʉodíh ĩ yoh báhanachah, Jesús ãt enep wʉt jĩ. Pánih ennit, nin pah queétdih ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Weemdíh ñi pej jʉm jʉ̃ʉ́wʉ́. Páant ñi jʉ̃ʉ́wʉ́chah, yeebdíh wã bohébipna caá. Páant wã bohénachah joinít, queejwã́dih ñi bidat pah, cã́acwãboodíh bidnit, wĩ́ih doonádih ñi naóhbipna caá, weemdíh jepahna, wĩ́ihwã ĩ jʉmat pínah niijná, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Páant ã niijíchah joinítjeh, ĩ́ih ñʉonádih cádahnit, Jesúsjeéh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chibít yʉʉ́p queétdih nʉmah bejnit, Santiago, ã ʉ́ʉd Juandihbʉt Jesús ãt enep wʉt jĩ. Queét ĩ íip Zebedeo biícdih ĩ́ih jãáj chóodih chʉ́ʉdnit, ĩ́ih ñʉonádih ámohna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pánih ennit, Jesús queétdih ãt bid bojop wʉt jĩ. Páant ã bid bojochah joiná, biícmantjeh ĩ íipdih, caandíh teo wʉ̃hnit biícdih jãáj chóomant cádahnit, queétbʉt Jesúsjeéh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tʉ́ttimah, Jesúswã Capernaum tʉ́tchina ĩt bejep wʉt jĩ. Caanná jʉibínit, jwiít judíowã jwĩ chooát yeó jáapdih Dios naáwátdih bohéát tʉ́ʉt niijná, jwĩ míic wáacat mʉʉ́boó Jesúswãbʉt ĩt waadáp wʉt jĩ. Waadnít, caanjĩ́h míic wáacnitdih Jesús ãt bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pánih bohéna, Moisés ã wʉtatjidih bohénit chah Jesús ãt wẽp naáwáp wʉt jĩ. Páant ã wẽp naáwáchah joinít, cã́acwãboó ĩt joi ñʉ́hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cã́acwã cãtíh nemép caolih jʉmnibʉt ñʉhnit, nin pah Jesúsdih ãt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Jesús, Nazaret tʉ́tchidih bóo, ded pah jwiítdih ma chãjbi? ¿Meém jwiítdih bacanadih ma jʉ̃óhnit beé? ¿Bacanit, jwiítdih ma mao yohmi niít? Meemdíh jwĩ tʉ́i jéihna caá. Meém caá Dioíh Tʉ́ini, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","—¡Ñi laihca bojoó! ¡Caán newémant ñi bac bejeé! Jesús queét nemépwãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Páant ã niijíchah joinítjeh, nemépwã caán newédih tʉbit méméanit, ñaácna, ã́ih bácahmant ĩt bac bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Páant ã yapachah ennit, cã́acwã bʉ́dí ĩt joi ñʉ́hʉp wʉt jĩ. —¿Ded jáap naáwát tigaá nin? ¡Maáh yoobát pah ã wẽp naóhna caá! ¡Ã wʉtʉchah joinít, nemépwã yʉh bʉca jepahnit, ĩ bac bejna caá! queétjeh ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Páant ã chãjatji doonádih joinít, waícanjeh Capernaum tʉ́tchidih moón, nihat Galilea baácdih moonbʉ́t ĩt míic naóh peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jwiít judíowã jwĩ míic wáacat mʉʉmánt Jesúswã bac bejnit, Simóníh mʉʉná ĩt jʉibínap wʉt jĩ. Simón, ã ʉ́ʉd Andrésjĩh mʉʉ́ monó wʉt jĩ. Pánihna, ĩ́ih mʉʉná Jesús, Juan, Santiagodihbʉt, ĩt nʉmah waadáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón chʉdh bʉ́dí pahat wʉnna, mi ñajat chóoboó mit ñajap wʉt jĩ. Jesúswã ĩ waadáchah, mi wʉnatdih caandíh ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Páant ĩ naáwáchah joinít, Jesús mi pebh jʉibínit, caántdih ãt wái pʉd chʉ́ʉd jwejep wʉt jĩ. Páant ã chãjachahjeh, pahat ãt dʉ́ʉcah bejep wʉt jĩ. Páant ã dʉ́ʉcah bejechah, queétdih jeémát mit wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tõo ñáh jʉ̃ʉ́wʉ́chah, dawá Jesús pebh jʉibínit, wʉnnitdih, nemép caolih jʉmnitdihbʉt ĩt ʉb jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nihat caán tʉ́tchidih moón caán mʉʉ́ jẽc pebh ĩt wáac jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dawá wʉnnitdih booanit, dawá nemépwãdihbʉt Jesús ãt bacat tʉ́ʉtʉp wʉt jĩ. Pánih bacat tʉ́ʉtna, nemépwã caandíh ĩ jéihyechah, Jesús queétdih ãt wéheat tʉ́ʉtcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chei bʉʉgjéh jáanit, chibít dʉpʉ́ jwʉhʉchah, cã́ac wihcapboó Jesús Diosdih ʉʉ́bʉ́dih ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tʉ́ttimah, ã wihcah ennit, Simónwã caandíh ĩt bid bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pánih bidna, caandíh jwãáhnit, nin pah caandíh ĩt niijíp wʉt jĩ: —Nihat cã́acwã meemdíh bidna beé, ĩ chãjap be, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—Nihat tʉ́tchidih moondíh tʉ́ini doonádih naáwádih wã jʉ̃ʉ́wʉ́p be. Chóbe ninjĩhjeh bóo tʉ́tchinadih jwĩ bejat dée caá. Caanjĩ́h jʉmnitdihbʉt tʉ́ini doonádih weemdíh naáwát caá náahap, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pánih bej, nihat Galilea baácboó jib, jwiít judíowã jwĩ míic wáacat mʉʉná jʉmat pah waadnít, Jesús ãt bohénap wʉt jĩ. Pánih bohéna, nemépwãdih ã bacat tʉ́ʉtʉchahjeh, cã́acwãíh bácahmant ĩt bac bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Biíc yeó jáap bácah moópni Jesús pebh ãt jʉibínap wʉt jĩ. Pánih jʉibína, bódicha caj yoh ñajnit, nin pah caandíh ãt niijíp wʉt jĩ: —Ma booaíhna, weemdíh ma jéih booana caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Páant ã niijíchah joinít, caandíh bʉ́dí jĩ́gah enna, teo jã́hanit, —¡Jʉ́ʉ! Wẽinit, meemdíh wã booana caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Páant Jesús ã niijíchahjeh, ã moopát ãt ñʉʉmáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Páant ã ñʉʉmʉ́chah, sacerdotewã ĩ pebh wahnit, nin pah Jesús caandíh ãt niíj wʉtʉp wʉt yʉh jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Meemdíh wã booaatjidih bitadih ma naóhca bojoó. Pánih naóhcan, sacerdotedihjeh naáwádih ma bejeé. Caanná jʉibínit, míih bácah ã ñʉʉmátjidih ma jʉ́ʉtʉ́. Moisés ã wʉtatji pah sacerdotedih ma wʉ̃hʉʉ́, booni ma jʉmatdih nihat ĩ jéihyat pínah niijná, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Páant ã niijíchah yʉhna, nihat ã jwãáhnitdih ãt naáwáp wʉt jĩ. Páant ã naáwáchah joinít, chah dawá Jesúsdih enedih ĩpĩ́ jʉibínap wʉt jĩ. Tʉbit dawá ĩ jʉmʉchah, tʉ́tchina Jesús ãt jéih waadcáp wʉt jĩ. Pánihna, daocánnit ĩ jʉmʉpboojéh ãpĩ́ jʉmʉp wʉt jĩ. Obohjeéhtih, caánboó ã jʉmʉchah yʉhna, dawá biíh tʉ́tchinadih moón Jesúsdih enedih ĩpĩ́ jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Daocánni yeó jáap tʉ́ttimah, Jesúswã Capernaum tʉ́tchiboó ĩt jwʉ́ʉb jʉibínap wʉt jĩ. Ãpĩ́ jʉibíni mʉʉdíh ã jwʉ́ʉb jʉibínachah, ã jʉmat doonádih joinít, cã́acwã ĩt míic naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pánih caán doonádih joinít, dawá caán ã jʉmni mʉʉná ĩt jʉibínap wʉt jĩ. Jẽc yehmant ĩt ñʉh péenap wʉt jĩ. Pánih jʉibínitdih Jesús Dioíh tʉ́ini doonádih ãt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jesús queétdih ã naáwát pónih, chénena míic neoná jéih yoocannidih ĩt beo jʉibínap wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Obohjeéhtih, Jesús ã jʉmni mʉʉná jʉibínit, dawá ĩ jʉmʉchah enna, Jesús pebh ĩt jéih waád jʉibícap wʉt jĩ. Pánih jéih waadcán, jéih yoocannidih mʉʉ́ chah bóo coahna beo pʉ́ʉh laab béjnit, ĩt íit chãjap wʉt jĩ. Pánih íit chãj péanit, jéih yoocannidih ã ñajni chóojĩh Jesús pebh ĩt cádah deya bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ĩ cádah deya bojochah ennit, “Jesús jwĩ chéendih ã booabipna caá”, ĩ niíj jenah joyátdih jéihnit, nin pah jéih yoocannidih Jesús ãt niijíp wʉt jĩ: —Ma yéejatdih wã yohna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Páant ã niijíchah joinít, caanjĩ́h chʉ́ʉdnit Moisés ã wʉtatjidih bohénitboó ĩ́ih caolihjĩhjeh nin pah ĩt niíj jenah joyóp wʉt yʉh jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Diosjeh yéejatdih ã jéih yohna caá. Nin cã́acjeh páant niijná, ‘Dios wã jʉmna caá’, niíj yeena caá ã chãjap”, ĩt niíj jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Queét páant ĩ niíj jenah joyóchah jéihnit, Jesúsboó nin pah queétdih ãt niijíp wʉt jĩ: —Yeéb páant ñi niíj jenah joyát ã tʉ́ican caá. ");
INSERT INTO cbv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‘Ma yéejatdih wã yohna caá’, wã niijíchah joinít, weemdíh jéihcan yʉhna, ‘Yeeni caá’, ñi niíj jenah joiná caá. Obohjeéhtih, ‘Ma ñah ñʉhʉʉ́. Ma ñajatdih ʉbnit, ma yáac chʉ̃i bejeé’, wã niijíchah, caán ã bejechah ennit, wã niiját yoobópdih ã jʉmatdih ñi jéihbipna caá. Pánih jéihna, yéejat yohat wẽpat wã bíbohatdihbʉt ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Weém nihat cã́acwã ʉ́ʉd jeñé, nin baácdih moondíh jéih booanit, ĩ yéej chãjatdihbʉt wã jéih yohna caá. Páant wã jéih yohatdih yeéb ñi jéihyat pínah niijná, nin pah wã chãj jʉ́ʉtbipna caá, ãt niijíp wʉt jĩ. Páant niíj péanit, jéih yoocanniboodíh nin pah ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ma ñah ñʉhʉʉ́. Ma ñajat chóodih ʉbnit, míih mʉʉ́boó ma jwʉ́ʉb bejeé, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jesús páant ã niijíchahjeh, caán newé ãt ñah ñʉhʉp wʉt jĩ, bʉca. Ñah ñʉhnit, ã ñajat chóodih ʉbnit, ãt bac bejep wʉt jĩ. Páant ã bac bejechah, nihat ĩt en wʉ́hi bejep wʉt jĩ. En wʉ́hi bejnit, Diosdih bʉ́dí wẽinit, nin pah queétjeh ĩt míic niijíp wʉt jĩ: —¡En yʉh bʉca! Bʉ́dí náhniat pínahdih bʉʉ jwĩ enna caá. Jã́tih pánihatdih jwĩ en jwʉhcan jĩí, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tʉ́ttimah, íim jwẽ́ejdih Jesúswã ĩt jwʉ́ʉb bejep wʉt jĩ. Pánih bejnit, dawá caan pébh ĩ míic wáac jʉyʉ́chah ennit, queétdih Jesús ãt bohé bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pánih bohé bejna, Leví Alfeo wʉ̃ʉ́hdih ã tewat tólihdih ã chʉ́ʉdʉchah, ãt enep wʉt jĩ. Leví, jwĩ dée jʉmna yʉhna, Romanowã maáta ĩ ʉʉ́bát tʉ́ʉtni dinerodih ʉʉ́bh wʉ̃hni ãt jʉmʉp wʉt jĩ. Caandíh ennit, Jesús nin pah ãt niijíp wʉt jĩ: —Wãjeéh ma pée jʉ̃ʉ́wʉ́, ãt niijíp wʉt jĩ. Páant ã niijíchah joinítjeh, ñah ñʉh, ã́ih tewatdih cádahnit, Levíbʉt Jesúsjeéh ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tʉ́ttimah, Levíboó ã́ih mʉʉná nʉmah bejnit, Jesúswãdih ãt nʉmah jeémép wʉt jĩ. Páant ã nʉmah jeéméchah, caán ã nihat pah dawá dinerodih ʉʉ́bh wʉ̃hnit, bita “Yeejépwã caá”, ĩ niijnítbʉt, Jesúswãjeéh bejnit, queét biícdih ĩt jeémép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Páant queét biícdih Jesúswã ĩ jeémp chʉ́ʉdʉchah, Moisés ã wʉtatjidih bohénit fariseowã queétdih ĩt enep wʉt jĩ. —¿Dépanih tigaá yeejépwã, dinerodih ʉʉ́bh wʉ̃hnit biícdih Jesús ã jeémp? ã bohénitdih ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","—Tʉbʉ́p chʉ̃ʉ́hcannit cohnidih ĩpĩ́ bidcan caá. Wʉnnitjeh caandíh ĩ bidna caá. Pánihat dée ‘Weém yéejat wihcanni caá’, niíj jenah joinít, teo wáacni pínahdih ĩpĩ́ bidcan caá. Obohjeéhtih, ‘Wã yéejatdih cádahnit, wã tʉ́ʉt nʉʉ́míhna caá’, niíj jenah joinítboó teo wáacni pínahdih ĩ bidna caá. Pánihna, ‘Yeejépwã caá jwiít’, niíj jenah joinítdihjeh teo wáacadih wã jʉ̃ʉ́wʉ́p be, ĩ yéej chãjatdih cádahnit, tʉ́iniboodíh ĩ tʉ́ʉt nʉʉmát pínah niijná, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Caán láa Juan ã bohénit, fariseowãbʉt jwĩ nʉowã ĩ wʉtat pah ĩt jeémp jwʉhcap wʉt jĩ. Obohjeéhtih, queét ĩ jeémp jwʉhcah yʉhna, Jesúswã páantjeh ĩt jeémép wʉt jĩ. Páant ĩ jeéméchah ennit, biquína Jesúsdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —Juan ã bohénit, fariseowã ĩ bohénitbʉt, ĩ jeémp jwʉhcan caá, Dios queétdih ã wẽi enat pínah niijná. ¿Dépanih tigaá ma bohénitboó páantjeh ĩ jeémp? Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","—Nin pah caá ã jʉmʉp: Téihya chéoni ã nʉmah jeémpnit biícdih ã jʉm jwʉhʉchah, jĩ́gahcan, ĩpĩ́ tʉ́i wẽi jeémpna caá. Páant tigaá, wãjeéh jʉm jwʉhna, wã bohénit ĩ tʉ́i wẽi jeémpna caá. ");
INSERT INTO cbv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Obohjeéhtih, bita caandíh ĩ ʉb bejat tʉ́ttimah, ã chéenwã jĩ́gahnit, ĩ jeémp jwʉhcan niít. Pánihat pah bita weemdíh ĩ ʉb bejat tʉ́ttimah bácah, wã bohénitjeéh wã wihcah, queétbʉt ĩ jeémp jwʉhcan niít, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ded pah jwĩ nʉowã ĩ wʉtatji ã́ih jáap bohéátjĩh fariseowã ĩ widíhichah enna, Jesús queétdih nin pah ãt jwʉ́ʉb niíj bohénap wʉt jĩ: “Jáap yégueh chóo chocca naáh chóojĩh máa yégueh chóodih nah teo wai bʉ́ʉdhdat ã náahcan caá. Páant ñi chãjachah nihna, caandíh ñi chocat tʉ́ttimah, jiínt bejna, máa chóodih chah ãta yewa tagaá. Páant tigaá jwĩ nʉowã ĩ naáwátji wĩ́ih jáap bohéátjĩh widcat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pánihat dée, pah jwʉhcanni iguíh macdih nʉñʉ́p chóojĩh ĩ chãjniji máa wʉh wʉʉ́hdih yáacat ã náahcan caá. Páant ñi yáacachah nihna, iguíh mac pahna, máa wʉh wʉʉ́h jéih yʉ́ʉhcan, ãta yewah bej tagaá. Páant ã yewechah, chénat pah ãta bʉʉd tágaá. Pánihna, jáap macdih jáap wʉh wʉʉ́hboó yáacat caá náahap. Páant ñi yáacachah, iguíh mac, caandíh yáacni chóobʉt ã tʉ́i jʉmbipna caá. Pánihat pah wĩ́ih jáap bohéát jwĩ nʉowã ĩ naáwátjijĩh widcat caá náahap”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Biíc chooát yeó jáapdih Jesús ã bohénitdih bohé bejna, trigo wáapdih ãt nʉmah chóop yap bejep wʉt jĩ. Pánih bejna, ã bohénit trigodih ĩt ʉ́ʉc jeémp bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Páant ĩ ʉ́ʉcʉchah enna, ĩjeéh bejnit fariseowã íijnit, nin pah Jesúsdih ĩt niíj jʉ̃ihñʉp wʉt jĩ: —Jwiítdih ma joi jwʉ́hʉʉ́. ¿Dépanih tigaá jwĩ chooát yeó jáapdih yʉhna, ma bohénitboó ĩ teo? Pánih teona, Moisés ã wʉtatjidih yap yohna caá ĩ chãjap, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Páant ĩ niijíchah joinít, “Wã bohénit ĩ yap yohcan caá”, niiját tʉ́ʉt niijná, Jesús queétdih nin pah ãt niíj bóod chʉñʉp wʉt jĩ: —Davidji ã bohénit biícdih nʉʉgʉ́p wʉnna, Dioíh mʉʉná waadnít, sacerdotewã Diosdih ĩ wʉ̃hniji pandih ãt jeémép wʉt jĩ. Pánih jeémpna, ã pej jʉmnitdihbʉt ãt wʉ̃hʉp wʉt jĩ. Obohjeéhtih, caán pan sacerdotewãjeh ĩ jeémát pínah ãt jʉmʉp wʉt jĩ. Dios wʉtna, bitadih caán pandih ãt jeémát tʉ́ʉtcap wʉt jĩ. Caán láa Abiatar wʉ̃t jʉmni sacerdotewã ĩ maáh ãt jʉmʉp wʉt jĩ. ¿Davidwã páant ĩ chãjatjidih Dios naáwátdih ĩ daácni nʉ́odih ñi bohécannit jĩí?Caán pandih ĩ jeéméchah yʉhna, Diosboó ‘Ñi tʉ́i chãjcan beé’, ãt niijcáp tajĩ. Pánihat pah, bʉʉ nin trigodih ʉ́ʉc jeémpna, wã bohénitbʉt Diosdih ĩ yap yohcan caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Páant niijnít, nin pah Jesús queétdih ãt jwʉ́ʉb niijíp wʉt jĩ: —Dios chooát yeó jáapdih cã́acwãdih ã jwejep jĩ, teo chʉʉnít, ĩ chooát pínah niijná. Caán yeó jáapdih dawá wʉtatnadih ĩ jepahat pínahdih jenah joicán, queétdih ã teo wáacat pínahdihjeh ãt jenah joyóp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pánihna, weém nihat cã́acwã ʉ́ʉd jeñé, chooát yeó jáapdih ded pah ĩ chãjat pínahdih wã jéih wʉtna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jwĩ míic wáacat mʉʉná jʉibínit, Jesúswã ĩt waad béjep wʉt jĩ. Caán mʉʉdíh téihya ágahnibʉt ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Caán mʉʉdíh jʉmnitboó Jesúsdih ĩt en ñʉʉnʉ́p wʉt jĩ. Chooát yeó jáapdih yʉhna, Jesús téihya ágahnidih ã booanachah, eníhna ĩt chãjap wʉt jĩ, caandíh naóh yacat tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Téihya ágahnidih nin pah Jesús ãt niijíp wʉt jĩ: —Ñah ñʉhnit, wã pebhna ma jʉ̃ʉ́wʉ́, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Páant niijnít, caán mʉʉdíh jʉmnitboodíh nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Ñi jenah joyóchah, ¿jwĩ chooát yeó jáapdih Dios jwiítdih ded pah tigaá ã wʉt? ¿Tʉ́i chãjatdih niít ã wʉtʉp? ¿Yeejép chãjatdih niít ã wʉtʉp? ¿Cã́acdih ã booaat tʉ́ʉt niít? ¿Cã́acdih ã mao yohat tʉ́ʉt niít? queétdih ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, queét ĩt jéih jepahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Páant ĩ jepahcah enna, cã́acwãdih ĩ jĩ́gah encatdih jéihnit, Jesús queétdih ãt íijip wʉt jĩ. Queétdih íijna yʉhna, bʉ́dí ãt jĩ́gahap wʉt jĩ. Pánih jĩ́gahnit, téihya ágahniboodíh nin pah ãt niijíp wʉt jĩ: —Míih téihyadih ma yoo dʉwʉʉ́, ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ã́ih téihyadih ãt yoo dʉwʉ́p wʉt jĩ. Páant ã yoo dʉwʉ́chahjeh, ã́ih téihya ãt tʉ́yah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Páant Jesús ã́ih téihyadih ã booanachah ennit, fariseowã ĩt íij bac bejep wʉt jĩ. Pánih íij bac bejnit, Herodeíh cã́acwã biícdih míic wáacnit, “¿Ded pah tigaá Jesúsdih jwĩ jéih mao yohbi?” queétjeh ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesús ã bohénit biícdih íim jwẽ́ejdih ĩt jwʉ́ʉb bejep wʉt jĩ. Páant ĩ bejechah enna, Galilea baácdih moón dawá queétdih ĩt pée bejep wʉt jĩ. Ded pah ã wẽp chãjat doonádih joinít, Judea baácdih moón, Jerusalén tʉ́tchidih moón, Idumea baácdih moón, Jordán mʉj conanaamánt moón, Tiro wʉ̃t jʉmni tʉ́tchidih moón, caan pébh jʉmni Sidón wʉ̃t jʉmni tʉ́tchidih moonbʉ́t dawá ã pebhna ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Dawá jʉmna, Jesús pebh ĩt tʉ́i yáo ñʉh jʉibínap wʉt jĩ. Dawá wʉnnitdih ã booanachah enna, bita wʉnnitbʉt Jesúsdih chʉ̃ʉ́íhnit, bʉ́dí ĩt míic tóonap wʉt jĩ. Páant ĩ míic tóonachah ennit, Jesús ã bohénitdih caanjĩ́h ñajni jãáj chóodih ãt tóo deya pahaat tʉ́ʉtʉp wʉt jĩ, caán chóodih waad páhnit, queétdih bohéát tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jesúsdih ennit, nemép caolih jʉmnitboó ĩpĩ́ páah yoh ñajap wʉt jĩ. Pánih páah yoh ñajnit, nin pah ĩt niíj ñaacáp wʉt jĩ: —¡Meém Dios wʉ̃ʉ́h caá! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Obohjeéhtih, Jesús queétdih nin pah ãpĩ́ niíj wʉtʉp wʉt jĩ: —Dios wʉ̃ʉ́h wã jʉmatdih bitadih ñi naóhca bojoó, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jeéboó pʉ́ʉh laab jʉibínit, ã náahnitdih Jesús ã pebhna ãt bejat tʉ́ʉtʉp wʉt jĩ. Ã bejat tʉ́ʉtʉchah joinít, ã pebhna ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Doce ã naáwát tʉ́ʉtnit pínah biíh tʉ́tchinaboó wahna, ã́ih tʉ́ini doonádih naóh jibnit pínahdih ãt ñíwip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pánih ñíonit, nemépwãdih ĩ bacaat pínah wẽpatdihbʉt queétdih ãt wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Jesús nit docewãdih ãt ñíwip wʉt jĩ: Simón, Santiago, ã ʉ́ʉd Juan, Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago Alfeo wʉ̃ʉ́h, Tadeo, Simón Celote poómpdih bóo, Judas Iscariote ã ñíonit ĩt jʉmʉp wʉt jĩ. Pánihna, Jesús Simóndih Pedro ãt wʉ̃t bʉ́ʉdhdʉp wʉt jĩ. Santiago, ã ʉ́ʉd Juanjĩh Zebedeo weh ĩt jʉmʉp wʉt jĩ. Queét waícanjeh íijnit ĩ jʉmʉchah enna, queétdih Boanerges Jesús ãt wʉ̃t bʉ́ʉdhdʉp wʉt jĩ. “Boanerges” niijná, “Énoh panihnit”, niijná ãt chãjap wʉt jĩ. Judas Iscariote Jesúsdih eníhcannitdih dʉó wáini pínah ãt jʉmʉp wʉt jĩ. Pánih queétdih ñío péanit, Jesús doce ã naáwát tʉ́ʉtnit pínahdih ãt nʉmah jwʉ́ʉb dei bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jwʉ́ʉb dei bejnit, Jesús ã bohénit biícdih mʉʉná ĩt waad béjep wʉt jĩ. Páant ĩ waadát tʉ́ttimah, dawá cã́acwã míic wáac jʉibína, caan mʉʉdíh ĩt yáwap wʉt jĩ. Páant ĩ míic wáac jʉibínachah ennit, Jesúswã ĩt jéih jeémpcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pánihna, dawá ĩ míic wáacat doonádih joinít, caán mʉʉná jʉibínit, Jesús ã déewã caandíh wapat tʉ́ʉt niijná, ĩt ʉb bejíhip wʉt yʉh jĩ. “Jesús déhena caá ã chãjap”, queét ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Biquína Moisés ã wʉtatjidih bohénit Jerusalén tʉ́tchimant dei jʉibínitboó nin pah ĩt míic niijíp wʉt jĩ: “Nemépwã ĩ maáh Beelzebú ã wẽpatjĩhjeh caá nemépwãdih ã bacat tʉ́ʉtʉp”, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Páant ĩ niijíchah joinít, Jesúsboó queétdih nin pah ãt niíj naáwáp wʉt jĩ: “Nemépwã míicjeh ĩpĩ́ míic bacacan caá. Nemépwã ĩ maáh ã wẽpatjĩh nihcan, Tʉ́ini Espíritu ã wẽpatjĩh queétdih wã bacana caá. ");
INSERT INTO cbv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nin pah ã jʉmna caá: Det biíc baácdih moonjéh yʉhna míic maona, queét nihat ĩta wʉn beedáh bej tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pánihat pah, biíc yoobó, biíc mʉʉdíh moonjéh yʉhna, míic maona, ĩta jweí peét bej tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanás, nemépwã ĩ maáh ã́ihwãdih bacana, biíc yoobó mʉntih páant ã yapachah, ã wẽpatbʉt ãta bʉʉd tágaá. ");
INSERT INTO cbv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nin pahbʉt ã jʉmna caá: Wẽpép newéíh mʉʉná ded nʉʉ́míhna yʉhna, ã jéih waadcán caá. Obohjeéhtih, caandíh chéo péanit, ã́ih bií déedih ã jéih ʉbna caá. ");
INSERT INTO cbv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Yoobópdih yeebdíh wã naóhna caá. Det yéej chãjna, Diosdih yeejép wéhena yʉhna, ĩ jwʉ́ʉb tʉ́ʉt nʉʉmʉ́chah, Dios ĩ yéejatdih ã yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Páant ĩ yéejatdih ã yohochah yʉhna, Tʉ́ini Espírituboodíh yeejép ĩ wéhenachah, caandíh bácah ã noón quíib bʉʉdcán niít. Páant ĩ niijátji jíib, peéh chãjat páantjeh ã jʉmbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús Tʉ́ini Espíritu ã wẽpatjĩh nemépwãdih ã bacanachah yʉhna, “Caán nemépwã ĩ maáh ã wẽpatjĩh nemépwãdih ã bacana caá”, Moisés ã wʉtatjidih bohénit ĩ niijíchah joinít, Tʉ́ini Espíritudih ĩ yéej wéheatji jíib Jesús queétdih páant ãt niíj naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Páant ã naáwát pónih, Jesús ã íin ã ʉ́ʉdwã biícdih ĩt jʉibínap wʉt jĩ. Pánih jʉibínit, jóocmant pã́init, Jesúsdih ĩt bid baca bojat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pánihna, ã pebh chʉ́ʉdnitboó caandíh nin pah ĩt niijíp wʉt jĩ: —Ma íin, ma ʉ́ʉdwã biícdih jóocmant meemdíh bidna wʉʉ́t ĩt chãjap, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—Ma naáwát tʉ́ina caá. Obohjeéhtih, ¿Dedh tigaá wã íin? ¿Det tigaá wã ʉ́ʉdwãbʉt, yeéb ñi jenah joyóchah? Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Páant niijnít, ã pebh chʉ́ʉdnitdih jʉ́ʉtnit, nin pah ãt niijíp wʉt jĩ: —Nit caá wã íin panihnit, wã ʉ́ʉdwã panihnitbʉt ĩ jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pánihna, ded Diosdih tʉ́i jepahni wã ʉ́ʉd, wã jwan, wã íin panihni ã jʉmna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pánih bohé péanit, bac bej, íim jwẽ́ejdih dei jʉibí ñʉhnit, Jesús cã́acwãdih ãt jwʉ́ʉb bohénap wʉt jĩ. Pánih bohénit, dawá ã pebh ĩ jʉibí ñʉhʉchah, íimdih pahni jãáj chóodih Jesús ãt waad páhap wʉt jĩ. Queét íim jwẽ́ejdih ĩt tʉ́i yáo ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pánih waad páhnit, dawá ã jenah joiní naáwátnajĩh bohéna, Jesús nin pah queétdih ãt niíj naóh bohénap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“¡Nin naáwátdih ñi tʉ́i joyoó! Biíc newé waáh momodih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Páant ã waáh bojochah, biquí tíibna namádih ã bʉʉg ñájap yʉh be. Obohjeéhtih, waícanjeh jʉ̃óhnit, jwébehwã caán tíibnadih ĩ jeémáh bojop be. ");
INSERT INTO cbv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Biíh tíibna jeejíh yewéni baác jʉmʉpboó ã bʉʉg ñájap be. Pánih bʉʉg ñájnit, waícanjeh ã chíih jʉ̃ʉ́wʉ́p yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pánih chíihna yʉhna, yeó tʉbit ã chãhachah, ñeh bainíjeh jʉmna, ã diib téhah bejep be. ");
INSERT INTO cbv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Biíh tíibna nemép óotna cãtíh ã bʉʉg ñájap be. Pánih bʉʉg ñájnit, ã chíihichah, caán nemép óotnaboó caandíh ã chíih yap bejechah, momniboó mánahna, ã quehcap be. ");
INSERT INTO cbv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Obohjeéhtih, biíh tíibna tʉ́ini baácboó ã bʉʉg ñájap be. Pánih bʉʉg ñájna, chíihnit, ã tʉ́i quehep be. Pánihna, caánboó chíihni biquí wawánadih treinta tíib, biíh wawánadih sesenta tíib, biíh wawánadih cien tíib ã jʉmʉp be”, cã́acwãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Páant niíj péanit, “¡Ded molít jʉmna, ã tʉ́i joyó naáh!” Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Queét joinítji ĩ jwʉ́ʉb bejat tʉ́ttimah, Jesús doce ã bohénit, bita daocánnit biícdih caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih tigaá cã́acwãdih bohéna, ma jenah joiní naáwátjĩhjeh mapĩ́ bohé? caandíh ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","—Dios jwĩ Maáh yoobát jʉmna, nihat cã́acwãdih ã teo wáacat pínah dooná, jwĩ déewã jon jã́tih moondíh ã jéihya jwʉhca naáh doonádih bʉʉ yeéb wã bohénitdih Dios ã jéihyat tʉ́ʉtna caá. Obohjeéhtih, bitadih páantjeh ã jéihya jwʉhcah, wã jenah joiní naáwátjĩhjeh queétdih wãpĩ́ bohéna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Pánihna, wã chãjatdih enna yʉhna, ĩ beh encan caá. Wã naáwátdih joiná yʉhna, ĩ beh joicán caá. Pánih beh encan, beh joicán, ĩ yéejatdih cádahcan, wã pebh ĩ tac pʉ́ʉd jʉ̃óhcah, ĩ yéejatdih wã yohcan niít, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Yeéb bʉtéh wã naóhnidih beh joicán, biíh wã naáwát pínahdihbʉt ñi beh joicán niít”, Jesús ã bohénitdih ãt niijíp wʉt jĩ. Tʉ́ttimah, ã jenah joiní naáwátdih ĩ jéihyat pínah niijná, queétdihjeh nin pah ãt jwʉ́ʉb niíj naóh bohénap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Wĩ́ih tʉ́ini doonádih naóhni, waáh momni panihni caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Biquína joinít namáboó bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh ĩ joyát tʉ́ttimahbitjeh, Satanás jʉ̃óhnit, jwébehwã caán tíibnadih ĩ jeémát pahjeh, queét ĩ joyátjidih ã quíib bʉʉdána caá. Páant ã quíib bʉʉdánachah, ĩ joyátjidih náhnican, ĩ jéih jepahcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bita joinítboó jeejíh yewéni baácdih bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joinít, bʉ́dí ĩ wẽi jwʉhna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Obohjeéhtih, wẽi joiná yʉhna, ñeh jáap bejni panihni ĩ jʉmna caá. Yeejép ã yapachah, wĩ́ihwã ĩ jʉmat jíib bita queétdih ĩ yéej chãjachah, waícanjeh wĩ́ih tʉ́ini doonádih ĩ cádahna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bita joinítboó nemép óotna cãtíh bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joinít, ĩ jepahna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Obohjeéhtih, nin baácdih bóodih bʉ́dí jenah joinít, dinerodih, bií déedihbʉt bʉ́dí ĩ bíbohíhatdihjeh ĩ jenah joiná caá. Páant ĩ jenah joyóchah, ĩ joiní tʉ́ini dooná pácahi panihni ĩ́ih caolihboó ã jéih behcan caá. Pánihna, caandíh jenah joicán, tʉ́iniboodíh ĩ jéih chãjcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Obohjeéhtih, bitaboó wĩ́ih tʉ́ini doonádih joinít, tʉ́ini baácboó bʉʉg ñájni panihni ĩ jʉmna caá. Caandíh joiná, tʉ́i jepahnit, tʉ́inidih ĩ jéih chãjna caá. Queét treinta tíibna ã quehat pah ĩ jʉmna caá. Bita tʉ́i jepahnit, bʉ́dí tʉ́i chãjna, sesenta tíibna ã quehat pah ĩ jʉmna caá. Bita tʉ́i jepahnit, chah bʉ́dí tʉ́i chãjna, cien tíibna ã quehat pah ĩ jʉmna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Páant niíj péanit, nin pah queétdih ãt jwʉ́ʉb niíj naóh bohénap wʉt jĩ: “Wã bohéát jiiát panihni caá. Jiiát dahdih jií péanit, wáam dahjĩh ñipĩ́ páah jwejcan caá. Caan dáhdih chʉ́ʉdat páha nʉmpboobʉ́t ñipĩ́ jii jwéjcan caá. Obohjeéhtih, ã tʉ́i yeh iigát pínah niijná, japboó ñipĩ́ jií cáagna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jiiát dah ã yeh iiguíchah jwĩ tʉ́i enat pah, jã́tih ĩ beh joicátjidih tʉ́ttimah cã́acwã ĩ jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Ded molít jʉmna, ã tʉ́i joyó naáh! ");
INSERT INTO cbv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Páant ñi tʉ́i jepahachah ennit, Dios yeebdíh ã tʉ́i teo wáacbipna caá, chah ñi beh joyát pínah niijná. Obohjeéhtih, joiná yʉhna, ñi joyáh bojochah enna, yeebdíh ã teo wáaccan niít. Páant ã teo wáaccah, ñi beh joicán niít. ");
INSERT INTO cbv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ded tʉ́i jepahni tʉ́i beh joiní ã jʉmbipna caá. Obohjeéhtih, jepahcanniboó ‘Bainí wã beh joiná caá’, niijná yʉhna, beh joicánni ã jʉmbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","“Dios ã maáh jʉmat, trigodih momat panihni caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mom péanit, chei jʉmat pah ʉ̃o, yeó jáap jʉmat pah ãpĩ́ jáana caá. Páant ã chãjat pónih, ã jéihcah yʉhna, ã momni ã behna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Baácboó momnidih Diosjeh ã behana caá. Páant ã behanachah, caán pínah ã jwíih chíihna caá. Caán ã behechah, ã́ih wawá pínah ãpĩ́ yabacna caá. Caán wawá behnit, ã bʉ́ʉhʉchah, ã́ih quehena ã jígohna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Caandíh ʉb láa caan quéhena ã behechah ennit, cã́acwã ĩpĩ́ bóod ʉbna caá.Ã momni ded pah ã behatdih ã beh joicát pah, cã́acwã ded pah Diosdih ĩ jepahatdihbʉt ñi jéih beh joicán caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“¿Dios ã maáh jʉmat ded pahna tigaá, ñi jenah joyóchah? ¿Caandíh ñi jéihyat pínah niijná, dedédih jenah joinít tigaá caandíh wã naóhbi? ");
INSERT INTO cbv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza tíib ded pah ã jʉmatdih wã naáwáchah, caandíh ñi beh joibípna caá. Caán tíib cã́o tíbih pah bóo ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pánih bainí tíbih jʉmna yʉhna, caandíh ĩ momochah, chíihna, ã tʉ́i behna caá. Páant ã behechah, ã́ih cã́canaboó jwébehwã yeó chãhatdih ĩpĩ́ jweí jaamná caá. Pánihat pah tigaá Dios ã maáh jʉmat. Ã́ihwã daocánnit jwíih jʉmnitji, tʉ́ttimah ĩ dao béjbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Caán dée naáwátnajĩh cã́acwã ĩ jéihyat pah bóo Jesús queétdih ãpĩ́ bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naáwátna ã wihcah, queétdih ãpĩ́ bohécap wʉt jĩ. Obohjeéhtih, ã bohénitdihjeh ã bohéátjidih Jesús ãpĩ́ jwʉ́ʉb naáwáp wʉt jĩ, ĩ tʉ́i beh joyát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pánih cã́acwãdih bohé péanit, tõo ñáh jʉ̃ʉ́wʉ́chah, —Chóbe íimdih jwĩ chʉ́ʉh bejjĩh, Jesús ã bohénitdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesús páantjeh jãáj chóodih pahnit, ã bohénit biícdih, caandíh joinítdih ĩt éemp chʉ́ʉh bejep wʉt jĩ. Bitabʉt biíh jãáj chóonajĩh ĩjeéh ĩt chʉ́ʉh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Páant ĩ chʉ́ʉh bejechah, Jesús jãáj chóo méimant waó cáagatjih cáag lajnit, ãt ʉ̃wʉp wʉt jĩ. Páant ã ʉ̃wat pónih, bʉ́dí johlit nolihatbʉt ãt jʉ̃ʉ́wʉ́p wʉt jĩ. Bʉ́dí nolihat ã jʉmʉchah, ĩ́ih jãáj chóo ãt daábíhip wʉt jĩ. Obohjeéhtih, Jesúsboó ãt jáacap wʉt jĩ. Páant ã jáacah ennit, nin pah caandíh ĩt niíj wʉcʉp wʉt jĩ: —Bohéní, daabná caá jwĩ chãjap. ¿Jwĩ chĩíc wʉnat pínahdih ma ʉ́ʉmcan niít? ĩt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Páant ĩ niíj wʉcʉchah jáanit, Jesús johlit, nolihatdihbʉt —¡Laihca bojoó! ¡Ma yayaá! ãt niíj jʉ̃ihñʉp wʉt jĩ. Páant ã niijíchahjeh, johlit, nolihatbʉt biícmantjeh ãt yayáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Páant ã niiját tʉ́ttimah, ã pej jʉmnitdih nin pah ãt niijíp wʉt jĩ: —¿Dépanih tigaá bʉ́dí ñi ʉ́ʉm? Weemdíh tʉ́i jenah joiná, ñita ʉ́ʉmcan tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Obohjeéhtih, bʉ́dí ʉ́ʉmnit, queétboó nin pah ĩt míic niijíp wʉt jĩ: —¿Dedé cã́ac tigaá nin? Ã naáwáchahjeh, johlit, nolihatbʉt ã yayáh bejna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús johlitdih yayániji ã bohénit biícdih Gadara baácna ĩt chʉ́ʉh jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pánih chʉ́ʉh jʉibínit, Jesúswã ĩ aab béjechah, cã́ac yohopmant nemépwã jʉmni newé Jesúsdih ãt jwãáh dei bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Caán newé cã́ac yohopboó jeé íitna ãpĩ́ jʉmʉp wʉt jĩ. Cã́acwã caandíh chéona yʉhna, ĩt jéih teocap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dawá láa ĩtah tõpjĩh ã́ih téihya colóhnadih ĩ chéwechah yʉhna, ãpĩ́ pʉ́ʉd wái daj yohop wʉt jĩ. Ã́ih jítcha colóhnadihbʉt ĩtah tõpjĩh ĩ chéwechah yʉhna, ãpĩ́ daj mao yohop wʉt jĩ. Pánih wẽpni ã jʉmʉchah, cã́acwã caandíh ĩt jéih teocap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cã́ac yohop jeé íitnaboó chei jʉmat pah, yeó jáap jʉmat pahbʉt caán míicjeh jee dáhjĩh ãpĩ́ míic mao ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pánihna, Jesús yʉʉ́p ã jʉ̃ʉ́wʉ́chah ennit, caandíh ãt jwãáh ñáo dei jʉibínap wʉt jĩ. Jesús pebh jʉibínit, ã wẽpatdih jéihna, ãt bódicha caj yoh ñajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Páant ã chãjachah enna, —¡Nemépwãá, nin newémant ñi bac bejeé! Jesús ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, caán newéíh jacmant nin pah nemépwã ĩt niíj ñaacáp wʉt jĩ: —Jesús, Dios chah wẽpni wʉ̃ʉ́h ¿Dépanihat tʉ́ʉt tigaá jwiítdih páant ma chãj? Dios ã enechah, meemdíh jwĩ ʉʉ́bhna caá. Jwiítdih ma peéh chãjca bojoó, Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Dedé tigaá ma wʉ̃t jʉm? Jesús ãt niijíp wʉt jĩ. —Dawá caá jwiít jwĩ jʉmʉp. Pánihna, Legión caá wã wʉ̃t, Jesúsdih ãt niijíp wʉt jĩ. “Legión” niijná, “Dawá” niijná ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","—Jwiítdih biíh baácboó ma wahca bojoó, nemépwã ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Queét pebh, jeé ñaj deyepboó, momo mʉʉwã ĩ bid jeéméchah ennit, nin pah nemépwã Jesúsdih ĩt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","—Queét mʉʉwãdih jwiítdih ma waadát tʉ́ʉtʉ́, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Ñi waad béjeé bácah, Jesús ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, caán newéíh bácahmant bac bejnit, mʉʉwãdih ĩt waadáp wʉt jĩ. Páant ĩ waadáchah, íimna ñáo dei bej, bʉʉ́g báahnit, mʉʉwã ĩt chĩíc wʉnʉp wʉt jĩ. Dos mil mʉʉwã ĩt wʉnʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Páant ĩ bʉʉ́g báah chĩíc wʉnʉchah ennit, queétdih en daonítji ĩ́ih tʉ́tchiboó ĩt jweí jwʉ́ʉb bejep wʉt jĩ. Jweí jwʉ́ʉb bejnit, nihat ĩ jwãáhnitdih ĩt naáwáp wʉt jĩ. Queét ĩ jʉmni tʉ́tchidih jwʉ́ʉb jʉibínit, caánboobʉ́t ĩt naóh peetép wʉt jĩ. Páant ĩ naáwáchah joinít, caán tʉ́tchidih moón Jesús ded pah ã chãjatjidih enedih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús pebh jʉibínit, nemépwã jʉmniji caánboó tʉ́inijeh ã chʉ́ʉdʉchah, ĩt enep wʉt jĩ. Pánih chʉ́ʉdna, yégueh dʉonít, tʉ́i jenah joiní ãt jʉmʉp wʉt jĩ, bʉca. Obohjeéhtih, queét jʉibínitboó caandíh enna, bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jesús ã chãjatjidih ennitji jáap jʉinítboodíh Jesús ded pah nemépwãdih bacat tʉ́ʉtnit, mʉʉwãdih ã waadát tʉ́ʉtatjidihbʉt ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Caán doonádih joinít, Jesúsdih náahcan, caán baácdih moón ĩ́ih baácmant Jesúswãdih ĩt jwʉ́ʉb bejat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesúswã jãáj chóodih ĩ waadáchah, nemépwã jʉmniji nin pah ãt niijíp wʉt yʉh jĩ: —¿Majeéh weembʉ́t wã bej jĩíh? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Wãjeéh ma jʉ̃ʉ́wʉ́chah, ãta tʉ́i ta yʉh caá. Obohjeéhtih, weém, ma Maáh, meemdíh jĩ́gah ennit, ded pah wã teo wáacatjidih ma déewãdih naáwát tʉ́ʉt niijná, ĩ pebhna ma jwʉ́ʉb bejeé, Jesús caandíh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Páant ã niíj jepahachah joinít, jwʉ́ʉb bejna, nemépwã jʉmniji ã déewãdih ãt naáwáp wʉt jĩ. Chénat Pah Téihya Tʉ́tchi wʉ̃t jʉmni baácboó Jesús ded pah ã chãjatjidih nihatdih naóh jibidih ãt bejep wʉt jĩ. Páant ã naáwáchah joi ñʉ́hnit, nihat Diosdih bʉ́dí ĩt wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tʉ́ttimah, Gadara baácmant Jesúswã ĩt jwʉ́ʉb chʉ́ʉh bejep wʉt jĩ. Pánih chʉ́ʉh bejna, íim jwẽ́ejdih ĩ ñáan jʉibínachah, dawá Jesúsdih enedih ĩt jʉibínap wʉt jĩ. Pánih jʉibínit, Jesúsdih ĩt wáac ñʉh pʉ́ʉda bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Páant ĩ ñʉh pʉ́ʉda bojochah, queét cãtíh Jairo Jesús pebh ãt jʉibínap wʉt jĩ. Jairo jwiít judíowã jwĩ míic wáacat mʉʉdíh en daonít maátajeéh jʉmni wʉt jĩ. Jesús ã wẽpatdih jéihnit, ã́ih jítcha pebh páah yoh ñajnit, nin pah ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Wã nʉʉ́m mi wʉnat tʉ́ʉt chãjachah ennit, ma pebh wã jʉ̃ʉ́wʉ́p be. Caántdih teo jã́ha booaat tʉ́ʉt niijná, wĩ́ih mʉʉná wãjeéh ma jʉ̃ʉ́wʉ́, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Páant ã niijíchah joinít, Jesús Jairojeéh ãt bejep wʉt jĩ. Páant ĩ bejechah, cã́acwãbʉt ĩjeéh ĩt bejep wʉt jĩ. Páant cã́acwã cãtíh ã bejechah, dawá caandíh tʉbit ĩt tóo péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cã́acwã cãtíh biíh wili wʉnnihbʉt mit jʉmʉp wʉt jĩ. Caánt doce jópchi mácanihat panihat wʉnnih mit jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dawá cohnit caántdih ĩtih cohop wʉt yʉh jĩ. Obohjeéhtih ĩ cohochah yʉhna, chah mit tʉbanap wʉt jĩ. Nihat miíh dinero ĩ cohat jíib wʉ̃hna yʉhna, mit boocap wʉt jĩ. Chah yeejép wʉt jĩ mi wʉnat. ");
INSERT INTO cbv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Pánihna, cã́acwã Jesúíh doonádih ĩ míic wéhenachah, mitát joyóp wʉt jĩ. Joinít, caántjeh nin pah mit niíj jenah joyóp wʉt jĩ: “Jesúíh yégueh chóodihjeh jʉibí teona, wã boobipna caá”, mit niijíp wʉt jĩ. Páant niíj jenah joiná, cã́acwã cãtíh Jesús tã́ahmant jʉibínit, ã́ih yégueh chóodih chaíhbitjeh mit jʉibí tewep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Páant mi tewechahjeh, mi wʉnat ãt yayáh bejep wʉt jĩ. Páant ã yayátdih miíh bácahjĩh mit joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Páant mi jʉibí tewechah, ã booaat wẽpat caántdih ã chʉ̃ʉ́átdih Jesúsbʉt ãt joyóp wʉt jĩ. Pánih joiná, cã́acwã cãtíh tac pʉ́ʉd ñʉhnit, nin pah ãt niijíp wʉt jĩ: —¿Déhe tigaá wĩ́ih yégueh chóodih ã jʉí teo? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—¿Páant, dawá cã́acwã meemdíh ĩ tóo péenachah jéihna yʉhna, páant ma niíj ʉʉ́bh joí? ã bohénitboó Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Obohjeéhtih, yégueh chóodih jʉí, teonidih jéihíhna, Jesús ãt en bidip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pánihna, mi booatdih jéihnit, ʉ́ʉmna, caánt Jesús pebh mit páah yoh ñajap wʉt jĩ. Pánih páah yoh ñaj, méménit, Jesúsdih tʉ́i yoobópdihjeh mit naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Páant mi naáwáchah joinít, nin pah Jesús caántdih ãt niijíp wʉt jĩ: —Nʉʉmʉ́, wã wẽpatdih tʉ́i jenah joiná, ma boona be. Wẽinit, ma bejeé. Caán wʉnat meemdíh ã jwʉ́ʉb jʉ̃óhcan niít, páant mʉntih, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús caántdih páant ã niijíchahjeh, Jairoíh mʉʉmánt bejnit, ã déewã ã pebh ĩt jʉibínap wʉt jĩ. —Jáantjeh ma nʉʉ́m mi wʉnah bejep be. Bohénidih ma jwʉ́ʉb bejat tʉ́ʉtʉ́, Jairodih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Obohjeéhtih, ĩ niijátdih joyáh bojnit, Jesús nin pah Jairodih ãt niijíp wʉt jĩ: —¡Ma ʉ́ʉmca bojoó! ¡Wã wẽpatdih páantjeh ma tʉ́i jenah joyoó! ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tʉ́ttimah, ãjeéh péenitdih “Ninjĩh ñi páñaá”, niijnít, Jesús Jairojeéh ã́ih mʉʉná ĩt béjep wʉt jĩ. Pánih bejna, Pedro, Santiago, ã ʉ́ʉd Juan, queét biíc peihcannitdihjeh ãt nʉmah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairoíh mʉʉná jʉibínit, wʉnnihdih dawá tʉbit ñaác jʉ̃inítdih ãt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pánih enna, caán mʉʉdíh waadnít, queétdih nin pah ãt niijíp wʉt jĩ: —¿Dépanihna tʉbit ñaác jʉ̃i tígaá ñi chãj? Nint wébít wʉnnih nihcan caá. Ʉ̃ona caá mi chãjap, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Obohjeéhtih, páant ã niijíchah joinít, caandíh ĩt dehwep wʉt jĩ. Páant ĩ dehwechah, queét nihatdih Jesús ãt bacat tʉ́ʉtʉp wʉt jĩ. Páant ĩ bac bejechah, Pedro, Santiago, Juan, wʉnnih mi mánadihbʉt wébít mi lajni tólihboó ãt nʉmah waad béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pánih waád jʉibínit, miíh téihyadih teonit, —¡Talita cumi! Jesús caántdih ãt niijíp wʉt jĩ. Páant niijná, “Bainíhmaá, ma ñah ñʉhʉʉ́”, niijná ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Páant ã niijíchahjeh, ñah ñʉhnit, mit yáac chʉ̃i bejep wʉt jĩ. Caánt doce jópchi mit bíbohop wʉt jĩ. Páant mi booatdih ennit, caán tólihdih ã nʉmah waad béjnit bʉ́dí ĩt joi ñʉ́hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Obohjeéhtih, Jesús queétdih ded pah mi booatdih naáwát tʉ́ʉtcan, jeémátdih ãt wʉ̃hat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jairoíh mʉʉmánt bac bejnit, Jesús ã bohénit biícdih ã behni Nazaret tʉ́tchina ãt jwʉ́ʉb jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pánih jʉibínit, chooát yeó jáapdih jwĩ míic wáacat mʉʉdíh Jesúswã ĩt waad béjep wʉt jĩ. Pánih waad béjnit, Jesús caanjĩ́h jʉmnitdih ãt bohénap wʉt jĩ. Páant ã bohénachah, dawá caandíh ĩt joí wʉ́hi bejep wʉt jĩ. Pánih joí wʉ́hi bejnit, nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: —¿Jesús dedjĩh tigaá, nin bohéátdih ãt joijí? ¿Ded pah tigaá ã tʉ́i jéih beedá? Pánih jéihnit, jwiít cã́acwã jwĩ jéih chãjca naáhdih ãpĩ́ chãj jʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Máa teonijeh caá. María wʉ̃ʉ́h ã jʉmʉchah, Santiago, José, Judas, Simón ã ʉ́ʉdwã ĩ jʉmna caá. Ã jwanna yaádhbʉt jwĩ pebh ĩ jʉmna caá. Caán jwiít panihni mʉn tigaá ã jʉmʉp, ĩt míic niijíp wʉt jĩ. Páant niijnít, ded pah ã jʉmatdih jéihcanjeh, caandíh ĩt náahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Páant ĩ náahcah ennit, Jesús nin pah queétdih ãt niijíp wʉt jĩ: —Dios naáwátdih naóh yapanidih cã́acwã ĩpĩ́ wẽina caá. Páant ĩ weñechah yʉhna, ã́ih tʉ́tchidih moón, ã déewã, ã́ih mʉʉdíh jʉmnitboó, caandíh ĩpĩ́ wẽican caá. Pánihna, ninjĩh behni wã jʉmʉchah, weemdíh ñi náahcan caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Caán tʉ́tchidih jʉmna, Jesús Dios ã wẽpatjĩh ãt jéih chãj jʉ́ʉtcap wʉt jĩ. Pánih chãjcan yʉhna, biquína wʉnnitdih teo jã́hanit ãt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Caanjĩ́h moón caandíh ĩ jepahcah, ãt en wʉ́hi bejep wʉt jĩ. Pánihna, caan pébh jʉmni tʉ́tchinadih Jesúswã bohénadih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tʉ́ttimah, doce ã bohénitdih ã pebh bid bojnit, ã wẽpatdih queétdih wʉ̃hna, chénewã, chénewã, chénewã míic Jesús ãt wahap wʉt jĩ, biíh tʉ́tchinadih moondíh teo wáacnit, nemépwãdih ĩ bacat tʉ́ʉtat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pánih wahnit, nin pah queétdih ãt niijíp wʉt jĩ: —Bií dée, pan, wʉh wʉʉ́h, dinerodih ʉbcan, ñi íoh cajat nahdihjeh pohba ñi ʉb bejeé. ");
INSERT INTO cbv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ñi tʉ́ʉt nʉʉmát pínah yégueh, zapatosdihbʉt ñi ʉb bejca bojoó. ");
INSERT INTO cbv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Páant ñi bejechah, ñi jʉibíni tʉ́tchinadih moón yeebdíh ʉ̃wat tólih ĩ wʉ̃hʉchah, caán mʉʉdíhjeh ñi chão jwʉ́hʉʉ́. Caán tʉ́tchimant bejnajeh, caán mʉʉdíh ñi cádah bejeé. ");
INSERT INTO cbv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ded tʉ́tchidih moón yeebdíh náahcan, ĩ joííhcah, caán tʉ́tchidih yap bejna, ñíih zapatosdih bóo becchídih ñi péoh mao yoh jéenanaá, queétdih Dios ã yohat pínahdih ĩ jéihyat pínah niijná. Yoobópdih yeebdíh wã naóhna caá. Sodoma tʉ́tchidih moón, Gomorra tʉ́tchidih moonbʉ́t tʉbit yeejép chãjnit ĩ jʉmʉchah yʉhna, péeni yeó jáap, yeebdíh náahcannitjiboodíh chah peéh chãjat ã jʉmbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pánihna, queét doce ã wahnitboó Jesúíh tʉ́ini dooná naáwádih ĩt bejep wʉt jĩ, cã́acwã ĩ yéej chãjatdih cádahnit, tʉ́iniboodíh ĩ tʉ́ʉt nʉʉmát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pánih bejnit, dawá nemépwãdih bacat tʉ́ʉtnit, wʉnnitdihbʉt yíijĩh ñái, ʉʉ́bhnit, ĩt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesús ã bohénit ĩ bohé jibichah, ded pah Jesús ã chãjat doonádih dawá ĩt joyóp wʉt jĩ. Maáh Herodesbʉt ãt joyóp wʉt jĩ. Pánih joinít, “¿Juan Daabáni ã wʉnat tʉ́ttimah, ãt jwʉ́ʉb boo pʉd jʉ̃óh niít ãt chãjap? Pánih boo pʉd jʉ̃óhni jʉmna, jwiít cã́acwã jwĩ jéih chãjca naáhdih ã jéih chãjna caá. Pánihna, caán Jesús Juanjehna tigaá”, ãt niíj jenah joyóp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bita “Elías caá”, niíj, bitabʉt “Jon jã́tih Dios naáwátdih naóh yapani dée ã jʉmna caá”, ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Páant ĩ niijíchah joinít, Herodesboó —Juanjidih waó wã bóod yohat tʉ́ʉtniji ãt jwʉ́ʉb boo pʉd jʉ̃óh tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Juandih ĩ mawat pínah jã́tih, Herodes ã ʉ́ʉd Felipe áa Herodíasdih ãt dʉ́ʉc wái áa jʉmʉp wʉt jĩ. Páant ã dʉ́ʉc wái áa jʉmat peéh Juan caandíh nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: “Ma ʉ́ʉd áadih dʉ́ʉc wái áa jʉmna, Dios ã wʉtatdih yap yohna caá ma chãjap”, ãt niijíp wʉt jĩ. Páant ã niiját peéh yad Herodías Herodesdih nemat mʉʉ́boó Juandih mit nemat tʉ́ʉtʉp wʉt jĩ. Páant mi wʉtatdih jepahnit, Herodes caandíh chéwat tʉ́ʉtnit, nemat mʉʉ́boó ãt nemat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías Juandih tʉbit eníhcan, mit mao yohat tʉ́ʉtíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Obohjeéhtih, Herodes “Juan Dios naáwátdih naóh yapani ã jʉmna caá”, niíj jenah joinít, Dios ã peéh chãjatdih ʉ́ʉmna, caandíh ãt mao yohat tʉ́ʉtcap wʉt jĩ. Ded pah ã tʉ́i chãjat pínahdih Juan caandíh ã naáwáchah, Herodes bʉ́dí ãt jenah joyóp wʉt jĩ. Pánih bʉ́dí jenah joiná yʉhna, Herodes caandíh ãpĩ́ tʉ́i wẽi joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Páant ã wẽi joyóchah yʉhna, Herodíasboó “Ded pah caandíh wã mawat tʉ́ʉtbi”, páantjeh mit niíj jenah joyóp wʉt jĩ. Páant mi niíj jenah joyóchah, ã cã́ac jʉmat yeó jáapdih wẽina, mi áa Herodes ã́ih cã́acwãdih míic wáacat tʉ́ʉtnit, bʉ́dí ãt nʉmah jeémép wʉt jĩ. Caán nʉmp jʉmnit maáta, ã́ih soldadowã maáta, Galilea baácdih moón maátabʉt, ã nʉmah jeémátdih enedih ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Biícdih ĩ jeéméchah, Herodías nʉʉ́mboó queétdih mit eo jʉ́ʉtʉp wʉt jĩ. Páant mi eo jʉ́ʉtʉchah ennit, Herodes, ã bid bojnitbʉt, bʉ́dí ĩt weñep wʉt jĩ. —Dedé ma náahatdih weemdíh ma ʉʉ́bʉ́chah, meemdíh wã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dios ã enechah, yoobópdih meemdíh wã naóhna caá. Ma ʉʉ́bát pah bóo tac yoób wã maáh jʉmatdih meemdíh wã wʉ̃hbipna caá, mi íbi Herodes caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Páant ã niijíchah joinít, mi íin pebhna bejnit, nin pah caántdih mit niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedé déedih tigaá wã ʉʉ́bhbi? mit niijíp wʉt jĩ. —Juan Daabániíh wao dáhdih dʉ́ʉc bóodnit, meemdíh ĩ wʉ̃hʉ naáh, mi nʉʉmdíh mit niíj jac wʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Páant mi niíj jac wʉtʉchah joinít, mi íbi pebhna wẽpép bejnit, nin pah caandíh mit niijíp wʉt jĩ: —Juan Daabániíh wao dáhdih dʉ́ʉc bóodnit, caán ã wʉnatdih wã jéihyat pínah niijná, pamapjih cáagnit, weemdíh ĩ wʉ̃hʉ naáh, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Páant mi niijíchah joiná, maáh Herodesboó bʉ́dí ãt jĩ́gahap wʉt yʉh jĩ. Obohjeéhtih, cã́acwã ĩ enechah, “Dedé ma náahatdih meemdíh wã wʉ̃hbipna caá”, ãtát niijíp wʉt jĩ. Pánihna, ã niijátjidih cã́acwã ĩ joyóchah, tíicna, “Meemdíh wã wʉ̃hcan niít”, caántdih ãt jéih niijcáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Biícmantjeh Juaníh wao dáhdih dʉ́ʉc bóodat tʉ́ʉtnit, soldadodih ãt ʉb jʉ̃ʉ́wát tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Páant ã wʉtʉchah joinájeh, bejnit, ã́ih wao dáhdih dʉ́ʉc bóod, pamapjih cáagnit, ãt ʉb jʉ̃ʉ́wʉ́p wʉt jĩ. Pánih ʉb jʉ̃óhnit, Herodías nʉʉmdíh ãt wʉ̃hʉp wʉt jĩ. Páant ã wʉ̃hʉchah, ã́ih wao dáhjidih teonit, beh wilidih mit teo yapanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pánihna, caandíh ĩ mawatji doonádih joinít, ã́ih bácahjidih ʉbʉdih jʉibínit, Juan ã bohénitji cã́ac yohopboó ĩt yohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús ã wah bojnitji ã pebh jwʉ́ʉb jʉibínit, ded pah ĩ chãjatjidih, tʉ́ini dooná ĩ naáwátjidihbʉt Jesúsdih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tʉ́ttimah, queét ĩ jʉmʉpboó dawá cã́acwã jwíih jʉibínitji bita ĩ jʉibínachah, ĩpĩ́ ñahwat jwʉ́ʉb bejep wʉt jĩ. Páant dawá ĩ jʉmʉchah, Jesúswã ĩt jéih bid jeémpcap wʉt jĩ. Pánihna, ã bohénitdih biáboó ãt nʉmah bejep wʉt jĩ. —Chóbe cã́ac wihcapboó jwĩ choo jwʉ́hjĩh, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Páant ã niijíchah joinít, queét jãáj chóodih waadnít, cã́ac wihcapboó ĩt chʉ́ʉh bejep wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Obohjeéhtih, queét ĩ chʉ́ʉh bejechah, dawá queétdih beh ennit, íim jwẽ́ejdih ĩt ñʉʉ́n ñáo pʉ́ʉd bejep wʉt jĩ. Íim pebh bóo tʉ́tchidih moonbʉ́t ĩt ñʉʉ́n ñáo pʉ́ʉd bejep wʉt jĩ. Pánihna, Jesúswã ĩ jʉibíát pínah jã́tih queétboó ĩtát jʉibínap wʉt jĩ. Jesúswã ĩ chʉ́ʉh jʉibínachah, dawá queétdih ĩt pã́i ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Queétdih bohéni ã wihcah, en daoní wihcanni ovejawã panihnit ĩ jʉmatdih ennit, Jesús queétdih bʉ́dí ãt jĩ́gah enep wʉt jĩ. Jĩ́gah ennit, queétdih ãt tʉ́i bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cheyeh ã jʉmʉchah, ã bohénit Jesúsdih nin pah ĩt niijíp wʉt yʉh jĩ: —Cheyeh caá. Ninjĩhbitjeh tʉ́tchi wihcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pánihna, nitdih pebhbit jʉmni tʉ́tchinadih ma wahaá, ĩ jeémát jíib chãjat pínah niijná, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Yeebjéh queétdih jeémát ñi wʉ̃hʉʉ́, Jesús queétdih ãt niíj jepahap wʉt jĩ. —Páant, ocho widh tewat jíibjĩh jeémátdih jwĩ jíib chãjachah yʉhna, queét nihatdih ãta jʉicán tagaá, Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Débói pan dah tigaá ã jʉm? Jéihyat tʉ́ʉt niijná, ñi bidbi jwʉhʉʉ́, Jesús queétdih ãt niijíp wʉt jĩ. Páant ã bidat tʉ́ʉtnitji jwʉ́ʉb jʉinít, —Cinco botoni pan dahna, chéne queejwã́bʉt ã jʉmna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","—Cã́acwãdih can tʉ́i jaihni yílipdih ñi chʉ́ʉdat tʉ́ʉtʉ́. Biíc poómp ninboó, biíh poómp canboó, biíh poómp conboó, ñi chʉ́ʉdat tʉ́ʉtʉ́, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Páant ã niijíchah joinít, nihatdih ĩt chʉ́ʉdat tʉ́ʉtʉp wʉt jĩ. Biquí poómpna cincuenta, biíh poómpna cien, nihat ĩ dawát yoobó páant ĩt chʉ́ʉd peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tʉ́ttimah, caán biícjĩh bóo téihya pan dahna, chéne queejwã́dihbʉt ʉbnit, Jesús jeáboó ãt chéi enep wʉt jĩ. Chéi ennit, “Jeémát ma wʉ̃hat tʉ́ina caá, Paá”, Diosdih ãt niijíp wʉt jĩ. Pánih ʉʉ́bh péanit, pan dahnadih ãt dajap wʉt jĩ. Dajnit, nihat cã́acwãdih ã bohénitdih ãt jwʉ́ʉb daj wʉ̃hat tʉ́ʉtʉp wʉt jĩ. Tʉ́ttimah, queejwã́dihbʉt ĩ wʉ̃hat pínah niijná, ãt daj wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Páant ĩ wʉ̃hʉchah, jeémpnit, nihat ĩt tʉ́i wʉd jʉmʉp wʉt jĩ. Nihat ĩ tʉ́i wʉd jʉmʉchah, páantjeh ĩ jʉdh jeémpni ĩt bíbohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Páant ĩ jʉdh jeémpni pan, queéj déepjĩh doce wʉhnadih ã bohénit ĩt ʉb yac yáwanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Queejdíh pandihbʉt jeémpnit neonájeh cinco mil ĩt jʉmʉp wʉt jĩ. Yaádh, ĩ wehjeéh chah ĩt jʉmjip tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Páant ĩ jeémp péanachah, jãáj chóona waadát tʉ́ʉtnit, Betsaida tʉ́tchina ã jã́tih Jesús ã bohénitdih ãt chʉ́ʉh bej páñat tʉ́ʉtʉp wʉt jĩ. Páant ĩ chʉ́ʉh bejechah, caandíh joinítjidih jwʉ́ʉb bejat tʉ́ʉtnit, ");
INSERT INTO cbv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","caanjéh jeéboó Diosdih ʉʉ́bʉ́dih ãt pʉ́ʉh laab béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tʉ́ttimah, cheina ã bohénit íim tac yoób ĩ chʉ́ʉh bejechah, Jesús biícjeh caánboó ʉʉ́bhna, ãt chão jwʉ́hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pánih ʉʉ́bhna, queétdih ãt en chʉ́ʉha bojop wʉt jĩ. Ĩ wawápmant queétdih johlit bʉ́dí ã jʉ̃ʉ́wʉ́chah, ã bohénit ĩ meenná yʉhna, ĩ wẽp bejcatdih ãt enep wʉt jĩ. Pánihna, baabát pínah jã́tihbit, ĩ pebh bejna, íimjihjeh Jesús ãt yáac chʉ̃i bejep wʉt jĩ. Pánih bejna, queétdih ãtih yap bejíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Obohjeéhtih, ã yap bejíhichah yʉhna, caán íimjih ã bejechah enna, “Wʉnniíh caolih caá”, niíj jenah joí, en wʉ́hi bejnit, queét tʉbit ĩt ñaacáp wʉt jĩ. Páant ĩ en wʉ́hi bejechah ennit, —¡Weemdíh ñi en ʉ́ʉmca bojoó! ¡Weemjéh tigaá! Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Páant niíj péanit, ĩjeéh jãáj chóona ãt waadáp wʉt jĩ. Páant ã waadáchahjeh, johlit ãt yayáh bejep wʉt jĩ. Páant ã yayáh bejechah ennit, queétboó ĩt joi ñʉ́hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús nihat ã wẽp chãj jʉ́ʉtatjidih enna yʉhna, ĩ tʉ́i beh joicátji jíib, dawá pandih ã jígohaatjidihbʉt ĩt beh joicáp wʉt jĩ. Pánih beh joicán, Jesús johlitdih ã yayáátdihbʉt beh joicánjeh, ĩt joi ñʉ́hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pánih chʉ́ʉh bej, Genesaret baácna jʉibínit, jãáj chóodih caán jẽ́litdih ĩt chéo pahanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pánih chéo pahanit, jãáj chóomant ĩ aab béjechahjeh, cã́acwãboó Jesúsdih ĩt beh enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pánih beh ennit, nihat ĩ́ih mʉʉnáboó ñáo aab béjnit, wʉnnit ĩ ñajat chóomant teonit, Jesús pebhna ĩt ʉb dei bejep wʉt jĩ. Jesús ã jʉmat doonádih joinít, nihat caanná ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ded ĩ jʉibíni tʉ́tchinaboó, dahwani tʉ́tchidih moón, botoni tʉ́tchinadih moonbʉ́t, bií dée ĩ jíib chãjat mʉʉ́ jóocmant bóo yoahdih ĩ chéenwã wʉnnitdih ĩpĩ́ ʉb jʉibí jwejep wʉt jĩ. Páant ĩ jʉibí jwejnitboó Jesúíh yégueh chóodih tewíhna, caandíh bʉ́dí ĩt ʉʉ́bʉ́p wʉt jĩ. Pánihna, det wʉnnit caandíh teonitboó ĩt boonap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jerusalén tʉ́tchimant bejnit, Moisés ã wʉtatjidih bohénit, fariseowãbʉt Jesús pebh ĩt míic wáac jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Jwĩ nʉowã ĩ wʉtatji pahjeh, jeémát pínah jã́tih fariseowã, nihat bita jwĩ déewãbʉt jwĩpĩ́ téih chocop jĩ. Bií dée jíib chãjadih bejnitji mʉʉná jwʉ́ʉb jʉibínit, ĩ wʉtatji pahjeh téih choccan, jwĩpĩ́ jeémpcap jĩ. Pamapna, pʉʉbátna, jwĩ lajatjinadihbʉt jwĩpĩ́ chocop jĩ. “Dios páant caá ã náahap”, niíj jenah joinít, jwĩ nʉowã dawá biíh ĩ wʉtatjidihbʉt jwĩpĩ́ chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jesús pebh míic wáacnit, ã bohénit téih choccanjeh ĩ jeéméchah ennit, fariseowã Jesúsdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —Jwĩ nʉowã ĩ wʉtatjidih yap yohnit, ma bohénit téih choccanjeh ĩ jeémpna caá. ¿Dépanih tigaá caandíh ĩ jepahcan? Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Páant ĩ niijíchah joinít, Jesús nin pah queétdih ãt niijíp wʉt jĩ: —‘Jwiít tʉ́init caá’, niijná yʉhna, cã́acwã ĩ encapboó yeéb yeejép chãjnit caá. Dios naáwátdih naóh yapani Isaíasji ded pah ñi jʉmatdih yoobópdih ãt niíj daacáp tajĩ: ‘Dios nin pah ã niijná caá: “Nit weemdíh tʉ́i wẽi naóhna yʉhna, yoobópdih ĩ jepahcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Weemdíh ʉʉ́bhna yʉhna, ĩ yee ʉʉ́bhna caá. Ĩ jenah joyátjeh wʉtnit, ‘Nin pah caá Dios ã wʉtat’, ĩpĩ́ niíj yee naóh bohéna caá”, Dios ã niijná caá’, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Páant ã niíj daacátji yoobópdih tigaá. Dios ã wʉtatdih yap yohnit, ñi nʉowã ĩ wʉtatboodíhjeh ñi chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pánih chãjnit, Dios ã wʉtatdih cádahna, ñi déewã ĩ wʉtatboodíh ñi jepahna caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dios Moisésjidih nin pah ãt niíj naáwát tʉ́ʉtʉp tajĩ: ‘Ñi mánadih oinit, ñi tʉ́i chãjaá. Ded ã mánadih yeejép naóhnidih peéh mao yohat ã jʉmbipna caá’, ãt niijíp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Páant Moisésji ã niiját pah, ded ã mánadih ã teo wáaquíhichah yʉhna, yeébboó ñi teo wáacat tʉ́ʉtcan caá. Ã mánadih ã wʉ̃hat déejidih Diosboodíh ñi wʉ̃hat tʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Pánih bohéna, ã mánadih caandíh yeéb ñi tʉ́i chãjat tʉ́ʉtcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jwĩ déewã ĩ wʉtatdih jepahna, Dios ã wʉtatboodíh yap yohna caá ñi chãjap. Dawá biíh ñi wʉtat pahjeh chãjat tʉ́ʉtna, Dios ã wʉtatdih ñipĩ́ yap yohat tʉ́ʉtna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Páant fariseowãdih niíj péa, bita ãjeéh péenitdih ã pebh bid bojnit, nin pah ãt niijíp wʉt jĩ: —Yeéb nihat wã naáwátdih tʉ́i joinít, ñi beh joyoó. ");
INSERT INTO cbv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dedé jeémát ñíih jacdih ã waadáchah, ñi téih chocochah, ñi téih choccahbʉt, Dios yeebdíh biíc yoobó ã enna caá. Obohjeéhtih, ñi yéej wéheatboó ñíih jacmant ã bacachah joiná, ‘Caán yeejép cã́ac caá’, ã niíj enna caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Ded molít jʉmna, ã tʉ́i joyoó naáh! Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Páant niíj péanit, Jesúswã mʉʉná ĩt waad béjep wʉt jĩ. Pánih waád jʉibínit, ã bohénit ã naáwátjidih ĩt ʉʉ́bh joyóp wʉt jĩ. Páant ĩ ʉʉ́bh joyóchah joinít, Jesús nin pah queétdih ãt niíj jepahap wʉ jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿Páantjeh yeéb ñi beh joi jwʉ́hcan niít? Ñíih jacdih waadnít, ñíih jeémátboó ñi jenah joyátdih ã jéih yéejacan caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dedé ñi jeémátji ñíih wʉdah diítboó jʉmnijidih ñipĩ́ jont yohna caá. Caán ñíih caolihdih, ñi jenah joyátdihbʉt chʉ̃ʉ́hcan, Dios ã enechah, yeebdíh ã jéih yéejacan caá, ãt niijíp wʉt jĩ. Páant niijná, “Nihat jeémát tʉ́ini caá”, niijná ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nin pahbʉt ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Ñi yéej wéheatboó ñíih jacmant bacna, ded pah yeejép ñi jenah joyát ã jʉmatdih ã jʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Pánih yeejép jenah joiná, nin pah ñi jʉmna caá: Ñi áa nihcannitjĩh yeejép chãjna, bií déedih nʉʉmná, cã́ac mao yohna, bitaíh bií déedih tʉbit en ñinahna, bitadih yéejaíh jenah joiná, yeena, yeejép chãjat pínahdih wéhena, biíh cã́ac ã jʉmat pah en ñinahna, yeejép dooná naóhna, ‘Weém chah jéihni wã jʉmna caá’, niíj jenah joiná, tʉ́i jenah joicánnitbʉt ñi jʉmna caá. Páant yéej chãjat ñi jenah joyátmant ã jʉ̃óhna caá. ");
INSERT INTO cbv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Páant yeejépdih ñi jenah joyóchah ennit, ‘Queét tʉ́icannit caá’, Diosboó yeebdíh ã niíj enna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tiro tʉ́tchi, Sidón tʉ́tchi pebh jʉibínit, caanjĩ́h jʉmni mʉʉdíh Jesúswã ĩt waadáp wʉt jĩ. Caán mʉʉ́boó ã jʉmatdih bitadih ãt naáwát tʉ́ʉtcap wʉt yʉh jĩ. Obohjeéhtih, ã naáwát tʉ́ʉtcah yʉhna, ã jʉmatdih jéihnit, dawá ĩ jʉibínachah, queétdih ãt jéih jweicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Caán tʉ́tchidih biíc yad wili mi nʉʉmbít nemép jʉmnih mit jʉmʉp wʉt jĩ. Pánihna, Jesús ded pah ã chãjat doonádih joí, caanjĩ́h ã jʉmat doonádihbʉt joinít, ã pebhna mit jʉibínap wʉt jĩ. Pánih jʉibínit, Jesúsdih wẽina, ã́ih jítcha pebh mit bódicha caj yoh ñajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Caánt Siria baác Fenicia wʉ̃t jʉmni tʉ́tchidih bóli, Griega wili mit jʉmʉp wʉt jĩ. Pánihna, Jesús pebh bódicha caj yoh ñajnit, mi nʉʉmdíh jʉmni nemépdih ã bacat tʉ́ʉtat pínahdih mit ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Páant mi ʉʉ́bʉ́chah joinít, nin pah Jesús caántdih ãt niijíp wʉt jĩ: —Wébít ĩ jeémát pínahdih ʉbnit, ĩ́ih mʉjjiowã́dih jwĩ jwíih wʉ̃hʉchah, ã tʉ́ican caá. Pánihat pah, judíowã ĩ jeémát panihni biíh baácdih moondíh wã jwíih wʉ̃hʉchah, ã tʉ́ican caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Ma niiját yoobópdih tigaá, Maá. Obohjeéhtih, mʉjjiowã́ jeémát cáagat naá nʉmp pã́init, wébít ĩ jeémp jéenanidih ĩpĩ́ jeémpna caá. Pánihna, biíh baácdih bóli wã jʉmʉchah yʉhna, weemdíhbʉt ma teo wáacachah, ã tʉ́ina caá, Jesúsdih mit niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Páant ma niíj jepahachah, ma nʉʉmdíh jʉmniji nemép wãát bac bejna caá. Enedih ma bejeé, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Páant ã niijíchah joinít, miíh mʉʉná jwʉ́ʉb jʉibínit, mi nʉʉmdíh nemép wihcannih mi lajachah, mit enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesúswã Tiro tʉ́tchi jʉmni baácmant bejnit, Sidón tʉ́tchidih jʉibí yap bej, Galilea íim conanaamánt jwʉ́ʉb dei jʉibínit, Chénat Pah Téihya Tʉ́tchina wʉ̃t jʉmni pebhboó ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Páant ĩ jʉibínachah, biíc newé wéhecan, joicánnidih Jesús pebh cã́acwã ĩt ʉb jʉibínap wʉt jĩ, caandíh ã booaat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jéih joicánnidih chibít yʉʉ́p Jesús ãt nʉmah bejep wʉt jĩ. Pánih bejnit, newéíh molítdih Jesús ã́ih téih tíibjĩh chibít ãt taj waadánap wʉt jĩ. Pánih taj waadá péanit, Jesús ã́ih téih tíibdih coí cáagnit, newéíh nʉʉ́cdih ãt teo jã́hanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pánih teo jã́ha péanit, jeáboó chéi ennit, caolih jʉí jéena bojnit, “¡Efatá!” ãt niijíp wʉt jĩ. “¡Efatá!” niijná, “¡Ma wãtaá!” niijná ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Páant ã niijíchahjeh, caán joicánniji jéih joinít, ã́ih nʉʉ́cbʉt ã wilahachah, ãt tʉ́i jéih wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Páant ã chãjatjidih ãjeéh péenitdih Jesús ãt naáwát tʉ́ʉtcap wʉt yʉh jĩ. Obohjeéhtih, páant ã naáwát tʉ́ʉtcah yʉhna, queétboó chah ĩt naóh peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Páant ĩ naáwáchah joinít, cã́acwã ĩt joí wʉ́hi bejep wʉt jĩ. “Nihatdih caán ã tʉ́i chãjna caá. ¡Jéih joicánnidih ã joyána caá! ¡Jéih wéhecannidihbʉt ã wéheat tʉ́ʉtna caá!” ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Biíh yeó jáap dawá cã́acwã Jesús pebh ĩt míic wáac jʉibínap wʉt jĩ, páant mʉntih. Páant ãjeéh jʉmna, jeémát beednít ĩ jʉmʉchah enna, Jesús ã bohénitdih bid bojnit, nin pah queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Queét jwĩjeéh biíc peihcanni yeó jáap ĩ jʉmʉchah, ĩ́ih jeémát ã beedná nacaá. Pánih jeémát wihcannit ĩ jʉmʉchah, queétdih bʉ́dí wã jĩ́gah enna caá. ");
INSERT INTO cbv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bita ĩjeéh jʉmnit yʉʉ́p jʉ̃óhnitji ‘Queét nʉʉgʉ́p wʉn bʉʉgná’, niijná, ĩ́ih mʉʉnáboó wã jwʉ́ʉb bejat tʉ́ʉtcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Obohjeéhtih, ninjĩh tʉ́tchi wihcapboó jʉmna, queét dawá ĩ jʉmʉchah, ¿dedboo tígaá ĩ jeémát pínahdih jwĩ jíib chãjbi? Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Débói pan dah tigaá ñi bíboh? queétdih ãt niíj ʉʉ́bh joyóp wʉt jĩ. —Siete dah caá, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cã́acwãdih baácboó chʉ́ʉdat tʉ́ʉtnit, siete pan dahdih ʉbnit, “Tʉ́ina caá, Paá”, Diosdih Jesús ãt niijíp wʉt jĩ. Páant niíj péanit, caan dáhnadih dajnit, ã bohénitdih wʉ̃hnit, cã́acwãdih ãt pãáát tʉ́ʉtʉp wʉt jĩ. Páant ã wʉtʉchah, ã bohénitboó cã́acwãdih pandih ĩt pãááp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Biquína queejwã́dihbʉt ĩt bíbohop wʉt jĩ. Pánihna, “Tʉ́ina caá, Paá”, Diosdih niijnít, queejwã́dihbʉt ãt pãáát tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ĩ pãáh péanachah, jeémpna, queét ĩt tʉ́i wʉd jʉmʉp wʉt jĩ, bʉca. Ĩ jʉdh jeémpnidih siete wʉhna ĩt ʉb yac yáwanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Queét jeémpnit neonádihjeh ĩ jenah enechah, cuatro mil ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Páant ĩ jeémp péanachah, Jesús cã́acwãdih ãt wah jwʉ́ʉbanap wʉt jĩ. Pánih wah jwʉ́ʉba péanit, ã bohénit biícdih jãáj chóodih ãt waadáp wʉt jĩ. Waadnít, Dalmanuta wʉ̃t jʉmni baácna ĩt chʉ́ʉh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Páant ĩ chʉ́ʉh jʉibínachah, fariseowã Jesúsdih jwãáhnit, caanjĩ́h ĩt míic wéhenap wʉt jĩ. Dios ã wẽpatjĩh Jesúsdih ĩt chãj jʉ́ʉtat tʉ́ʉtʉp wʉt yʉh jĩ, ã jepahcah, “Dios ã wahni nihcan caá”, niiját tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Páant ĩ wʉtʉchah joinít, Jesús íijnit, caolih jʉí jéena bojnit, nin pah ãt niijíp wʉt jĩ: —¿Dépanih tigaá yeéb bʉʉ láa moón Dios ã wẽpatjĩh chãj jʉ́ʉtatdih ñi eníh? Yoobópdih yeebdíh wã naóhna caá. Bʉʉ jʉmnitdih Dios ã wẽpatjĩh weém wã chãj jʉ́ʉtcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Páant niíj péanit, ã bohénitdih jãáj chóona nʉmah jwʉ́ʉb waadnít, bitadih ĩt yoh chʉ́ʉh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pánih jwʉ́ʉb chʉ́ʉh bejnit, ã bohénit ĩ jeémát pínah pandih ĩt quíib bʉʉdʉ́p wʉt jĩ. Biíc pan dahjeh caán jãáj chóoboó ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ĩ jeémát pínahdih tʉbit ĩ jenah joyóchah jéihnit, Jesús queétdih nin pah ãt niíj naáwáp wʉt jĩ: —¡Ñi tʉ́i chãja chaáh! Fariseowã, Herodesbʉt ĩ yee bohéát yeebdíh ã tobohna caá. Ĩ yee bohéát pan paáát panihni caá. Caán paáát nihat pan pínahdih ã chʉ̃ʉ́hna caá. Páant ã chʉ̃ʉ́át pah, det ĩ yee bohéátdih joinít ĩ yéej bejna caá. Pánihna, ĩ yee bohéátdih ñi tʉ́i chãja chaáh, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Páant ã niijíchah joinít, “Pandih jwĩ ʉb jʉ̃óhcah enna, páant niijná caá ã chãjap”, ĩt míic niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Páant ĩ míic niijíchah jéihnit, Jesús queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih tigaá yeéb pandih tʉbit ñi jenah joí? Caandíh tʉbit jenah joinít, ded pah wã naáwátdih ñi beh joi jwʉ́hcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pánih tʉbit jenah joiná, quíib ñi bíbohna yʉhna, molít jʉmna yʉhna, páantjeh ñi beh joicán caá. ");
INSERT INTO cbv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Cinco pan dahbitjĩh cinco mil neonádih wã wʉ̃hatjidih ñi náhnican niít? ¿Ĩ jʉdh jeémpnidih débói wʉh tijĩí ñi ʉb yac yáwa? ãt niijíp wʉt jĩ. —Doce wʉh jĩí, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Weém siete pan dahdih cuatro mil cã́acwãdih wã wʉ̃hat tʉ́ttimah, ¿débói wʉh tijĩí ĩ jʉdh jeémpnidih ñi ʉb? Jesús ãt niijíp wʉt jĩ. —Siete wʉh jĩí, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Pánih enna yʉhna, páantjeh wã wẽpatdih ñi tʉ́i jenah joicán niít? Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Queét Betsaida tʉ́tchina ĩ chʉ́ʉh jʉibínachah ennit, cã́acwã jéih encannidih Jesús pebh ĩt ʉb jʉibínap wʉt jĩ. —Caandíh teo jã́hanit, ma booanaá, Jesúsdih tʉbit ĩt niíj ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jéih encannidih ã́ih mʉjmant teonit, tʉ́tchi jwẽ́ejboó caandíh Jesús ãt wái bejep wʉt jĩ. Caanná nʉmah jʉibínit, ã́ih téih tíibnadih coí cáagnit, caán newéíh quíibnadih ãt teo jã́hanap wʉt jĩ. —¿Ma enechah, jígoh niít? Jesús caandíh ãt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","—Cã́acwãdih wã enna yʉh caá. Obohjeéhtih, wã enechah, queét máa nahna bejni pah caá ĩ jígohop, ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Páant ã niijíchah joinít, Jesús ã́ih quíibnadih ãt jwʉ́ʉb teo jã́hanap wʉt jĩ, páant mʉntih. Páant ã jwʉ́ʉb teo jã́hanachah, nihatdih ãt tʉ́i enep wʉt jĩ, bʉca. ");
INSERT INTO cbv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pánihna, Jesús caandíh ã́ih mʉʉná wah bojnit, nin pah ãt niijíp wʉt jĩ: —Tʉ́tchiboó jwʉ́ʉb bejcanjeh, bʉtéh meemdíh wã chãjatjidih bitadih ma naóh peétca bojoó, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús ã bohénit biícdih Cesarea Filipo wʉ̃t jʉmni tʉ́tchi pebh jʉmni tʉ́tchinaboó ĩt bejep wʉt jĩ. Pánih namádih bejnit, Jesús ã bohénitdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Weemdíh ded pah tigaá cã́acwã ĩ niíj? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Biquína ‘Juan Daabáni nacaá’, niíj, bita ‘Elías nacaá’, niíj, bita ‘Dios naáwátdih naóh yapanit biícdih bóo nacaá’, ĩ niijná beé, ã bohénit caandíh ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Queét páant ĩ niijíchah, ¿yeébboó ded pah tigaá ñi niíj jenah joí? queétdih ãt niijíp wʉt jĩ. —Meém Cristo, Dios ã wahni caá, Pedroboó ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Weemdíh ‘Caán Cristo caá’, bitadih ñi niíj naóh peét jwʉhca bojoó, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús queétdih nin pah ãt niíj naóh bohé jwíihip wʉt jĩ: “Weém, nihat cã́acwã ʉ́ʉd jeñédih tʉbit yeejép yapat caá náahap. Weemdíh náahcan, jwĩ nʉowã, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt weemdíh ĩ mawat tʉ́ʉtbipna yʉh caá. Obohjeéhtih, páant ĩ mawachah yʉhna, biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Páant niíj naóhna, ĩ tʉ́i beh joyátjeh queétdih ã naáwáchah, Pedroboó chibít yʉʉ́pbit caandíh nʉmah jʉibí ñʉhnit, páant ãt niiját tʉ́ʉtcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Páant ã niiját tʉ́ʉtcah joinít, Jesús ã bohénitdih tac pʉ́ʉd ennit, Pedrodih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: —Satanás ã náah yacat pah wéhena caá ma chãjap. Ma jenah joyát cã́acwã ĩ jenah joyátjeh caá. Dios ã jenah joyát nihcan caá, Pedrodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Páant niíj péanit, cã́acwãdih, ã bohénit biícdih ã pebhna bid bojnit, nin pah Jesús queétdih ãt niíj naóh bohénap wʉt jĩ: —Ded wãjeéh péeíhna, ded pah caanjéh ã wẽi chãjíhatdih cádahnit, weém wã weñat pínahboodíh caá chãjat náahap. ");
INSERT INTO cbv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ded ã weñat pínahdihjeh chãjni, iiguípna ã bejbipna caá. Obohjeéhtih, wã weñat pínahboodíh chãjni, wã bohéátdih tʉ́i jenah joiní, yeó jáap jʉmat pah wãjeéh ã tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nin baácdih jʉmni dawá bií déedih bíbohna yʉhna, iiguípna ã bejechah, ã bíbohatji caandíh dedé pínah nihcan niít. ");
INSERT INTO cbv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ã́ih caolih iiguípna ã bejechah, ded pah tigaá ã́ih caolihjidih ãta jwʉ́ʉb jíib chãj baca. ");
INSERT INTO cbv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bʉʉ yeejépwã, Diosdih náahcannit, ĩ weñat pínahdihjeh chãjnit ĩ jʉmna caá. Páant queét yeejépwã ĩ joyóchah, biquína weemdíh, wã bohéátdihbʉt tíic jenah joinít, ‘Weém caandíh wã jéihcan caá’, ĩ niijbípna caá. Pánihna, weém nihat cã́acwã ʉ́ʉd jeñé, tʉ́init ángelwã biícdih, wã íip ã yeh iigátjĩh jwʉ́ʉb dei jʉ̃óhna, queét weemdíh ĩ tíic jenah joyátjidih náhninit, ‘Queétdih wã jéihcan caá’, weembʉ́t wã niijbípna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Páant niíj péanit, nin pah Jesús queétdih ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Yoobópdih yeebdíh wã naóhna caá. Biquína yeéb ninjĩh jʉmnit ñi wʉnat pínah jã́tih, Dios nihat maáh jʉmna, ã wẽpatdih ã jʉ́ʉtʉchah, ñi enbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis yeó jáap tʉ́ttimah Pedro, Santiago, Juan, queét biíc peihcannitdihjeh jap bóo jeená Jesús ãt nʉmah pʉ́ʉh laab béjep wʉt jĩ. Caanná ĩ pʉ́ʉh laáb jʉibíát tʉ́ttimah, ĩ enechah, ã jígohat ãt tʉ́ʉt nʉʉmʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ã́ih yégueh chóo tʉ́i baáb yeh iigní ãt jígohop wʉt jĩ. Nin baácdih moón yégueh chocnit, pánih tʉ́i baabní ĩ jéih choccan caá. ");
INSERT INTO cbv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Páant ã yeh iiguíchah, Elías, Moisésji biícdih Jesús pebh jígohnit, caandíh ĩ míic wéhenachah, queét biíc peihcannit ã bohénit ĩt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Páant ĩ jígohochah ennit, queét tʉbit ĩt ʉ́ʉmʉp wʉt jĩ. Pánih ʉ́ʉmna, ded pah ã niiját pínahdih jéihcan, nin pah Pedro Jesúsdih ãt niijíp wʉt yʉh jĩ: —¡Maá, jwiít ninjĩh jwĩ jʉmʉchah, ã tʉ́ina caá! Biíc peihcanni mʉʉ dáhna jwĩ chãjbipna caá. Míih pínah, Moiséíh pínah, Elíaíh pínahdihbʉt jwĩ chãjbipna caá, ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Páant ã niijíchahjeh, mah põh panihni queétdih ãt dei jʉyʉ́p wʉt jĩ. Páant ã dei jʉyʉ́chah, caanmánt Dios nin pah ãt niijíp wʉt jĩ: “Nin wã wʉ̃ʉ́h, wã oini caá. Pánihna, ã naáwáchah, caandíh ñi tʉ́i joyoó”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Páant ã niíj péanachah, Pedrowã jwʉ́ʉb enna, Jesúsdihjeh ĩt enep wʉt jĩ. Ĩ ennitjiboó ĩtát jwʉ́ʉb bʉʉdáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pánihna, jeemánt jwʉ́ʉb dei bejnit, Jesús queétdih nin pah ãt niijíp wʉt jĩ: “Bʉtéh páant ã yapatdih bitadih ñi naóh jwʉhca bojoó. Weém, nihat cã́acwã ʉ́ʉd jeñé, wʉnniji wã jwʉ́ʉb boo pʉd jʉ̃ʉ́wát tʉ́ttimah, caandíh bitadih ñi naáwáp bʉca”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pánihna, ã niijátji pahjeh queét ĩ enatjidih bitadih ĩt naóh jwʉhcap wʉt jĩ. Queétjeh nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: “ ‘Wʉnniji wã jwʉ́ʉb boo pʉd jʉ̃ʉ́wát tʉ́ttimah’, niijná, ¿Ded pah niij tígaá páant ã niíj?” ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Páant niíj míic wéhenit, Jesúsdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —‘Cristo, Dios ã wahni, ã jʉ̃ʉ́wát pínah jã́tih, Elías ã jwíih jʉ̃óhbipna caá’, Moisés ã wʉtatjidih bohénit ĩpĩ́ niijná caá. ¿Ded pah niij tígaá páant ĩ niíj? caandíh ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","—Yoobópdih tigaá. Elías jwíih jʉ̃óhni, nihatdih ámohni ã jʉmna caá. Dios naáwátdih naóh yapanit ĩ naóh daacátji pahjeh, weém, nihat cã́acwã ʉ́ʉd jeñé, dawá láa yeejép wã yapbipna caá. Bita weemdíh náahcan, yeejép ĩ chãjbipna caá. ¿Páant ĩ niíj daacátjidih yeéb ñi beh joicán niít? Pánihna, nindih yeebdíh wã naóhna caá: Elías panihni Juan Daabáni wãát jʉí péana beé. Páant ã jʉyʉ́chah, queét ĩ náahatji pahjeh caandíh yeejép ĩt chãjap wʉt jĩ. Páant jĩí caandíhbʉt ĩt niíj daacáp tajĩ, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Páant ã niiját tʉ́ttimah, jeejíboó jʉmnitji jwʉ́ʉb dei bejna, dawá cã́acwã ã bohénit pebh ĩ jʉmʉchah, Jesúswã ĩt enep wʉt jĩ. Moisés ã wʉtatjidih bohénitboó ã bohénit biícdih míic jʉ̃ih ñaácna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pánihna, Jesúswã ĩ dei jʉibínachah, nihat caandíh wẽi ennit, Jesúsdih jwãáádih ĩt ñáo ñah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ã pebh ĩ jʉibínachah, nin pah queétdih Jesús ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih yeéb míic jʉ̃ih ñaác tibeé ñi chãj? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Páant ã niíj ʉʉ́bh joyóchah joinít, cã́acwã cãtíh ñʉhni nin pah ãt niíj jepahap wʉt jĩ: —Bohéní, wã wʉ̃ʉ́h nemép jʉmnidih meemdíh wã ʉb jʉ̃ʉ́wʉ́p yʉh be. Nemépboó caandíh déheanit, ãpĩ́ wéheat tʉ́ʉtcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wã wʉ̃ʉ́hdih déheat ã jʉ̃ʉ́wʉ́chah, baácboó bʉʉgnít, maojĩ́h nah chãácnit, ãpĩ́ jwiwáh bejna caá. Pánih bejnit, jacmant moj chej tʉbit ãpĩ́ bacna caá. Páant ã jʉmʉchah, ma pej jʉmnitdih nemépdih wã bacaat tʉ́ʉtʉp yʉh be. Obohjeéhtih, queét ĩ jéih bacacap be, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—Maatápdih yeebdíh wã bohénachah yʉhna, páantjeh weemdíh ñi tʉ́i jenah joicán caá. ¿Débólih maatápdih tigaá weemdíh yeéb ñi jepahbi? Caán wébítdih ma ʉb jʉ̃ʉ́wʉ́, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Páant ã niijíchah joinít, nemép jʉmnidih Jesús pebh ĩt ʉb bejep wʉt jĩ. Ĩ ʉb jʉibínachah, Jesúsdih ennit, nemépboó wébítdih baácboó nʉmah bʉʉgʉ́chah, ãt ñaj tʉ̃pʉ́nap wʉt jĩ. Páant ã ñaj tʉ̃pʉ́nachah, jacmant moj chej bʉ́dí ãt bacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Débólih maatápdih tigaá nin wébít páant ãpĩ́ jʉm? Jesús behedih ãt niíj ʉʉ́bh joyóp wʉt jĩ. —Wébítjeh ã jʉmʉchah, ã jwíihip be. ");
INSERT INTO cbv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nemépboó caandíh tʉʉ cʉ́ʉtboó nʉmah bʉʉ́g cáwíhnit, mʉjboobʉ́t nʉmah bʉʉ́g báahnit, dawá láa ã mao yohíhip jĩ. Ma jéihna, jwiítdih jĩ́gah ennit, ma teo wáacá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Weemdíh ma tʉ́i jenah joyóchah, Dios nihat tʉ́i jéihni meemdíh ã teo wáacbipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","—Meemdíh wã tʉ́i jenah joiná yʉh caá. Obohjeéhtih, chah wã tʉ́i jenah joyát pínah niijná, weemdíh ma teo wáacá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dawá queét pebhna ñáo ñah bejnit, ĩ míic wáac jʉibínachah ennit, Jesús nemépdih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: —Meém wéheat tʉ́ʉtcanni, joyát tʉ́ʉtcanni nemép nin wébítdih jʉmni ma bac bejeé. Pánih bac bejnit, caandíh ma jwʉ́ʉb tac bʉʉgáca bojoó, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Páant ã niíj jʉ̃ihñʉchah joinít, ñaácnit, wébítdih baácboó jwʉ́ʉb nʉmah bʉʉgnít, ñaj tʉ̃pʉ́ánit, nemép ãt bac bejep wʉt jĩ. Páant ã chãjachah, wébítboó wʉnni pah ãt ñajap wʉt jĩ. “Caán ã wʉnah bejna caá”, dawá ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Páant ĩ niijíchah yʉhna, Jesúsboó caandíh ã́ih mʉj nahdih ãt teo wái ñahanap wʉt jĩ. Páant ã teo wái ñahanachah, wébít ãt ñah ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tʉ́ttimah, Jesúswã mʉʉ́boó ĩ waád jʉibínachah, bita wihcah, ã bohénitjeh caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih tigaá jwiítboó caán nemépdih jwĩ jéih bacacan? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Pánihni nemépdih yohíhna, jeémp jwʉhcanjeh, Diosdih bʉ́dí ʉʉ́bát caá náahap, Jesús queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Tʉ́ttimah, ĩ jʉmniji tʉ́tchimant Galilea baácna Jesúswã ĩt bejep wʉt jĩ. Capernaum tʉ́tchina bejni namádih bejna, Jesús ã bohénitdih ãt bohé bejep wʉt jĩ. Pánih queétdih bohé bejna, ã bohénitdihjeh ã tʉ́i bohéát tʉ́ʉt niijná, dedboó ĩ bejat pínahdih bita ĩ jéihyatdih ãt náahcap wʉt jĩ. Pánih bohé jib bejna, nin pah queétdih ãt niíj naáwáp wʉt jĩ: —Weém nihat cã́acwã ʉ́ʉd jeñédih teonit, jwĩ déewã bitaboodíh ĩ wʉ̃hbipna caá. Páant ĩ wʉ̃hʉchah, weemdíh ĩ mao yohbipna yʉh caá. Obohjeéhtih, ĩ mawachah yʉhna, biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá, páant mʉntih, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Páant ã niijíchah joiná yʉhna, queét ĩt tʉ́i beh joicáp wʉt jĩ. Pánih beh joicán, ʉ́ʉmna, ĩt jwʉ́ʉb ʉʉ́bh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Galilea baácdih bejna, Jesúswã Capernaum tʉ́tchiboó ĩt jʉibínap wʉt jĩ. Pánih jʉibínit, ã chéenwãíh mʉʉdíh waadnít, Jesús ã bohénitdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Namáboó jʉ̃óhnit, ¿Dedédih míic wéhe tibeé ñi chãj? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Páant ã niijíchah joinít, ĩt jepahcap wʉt jĩ. Namádih bejna, nin pah queétjeh ĩt niíj míic wéhenap wʉt jĩ: “Chah jéihni jʉmna, weémboó maáh panihni wã jʉmna caá”, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Páant ĩ míic niijátjidih tíicna, Jesúsdih ĩt jepahcap wʉt jĩ. Páant ĩ jepahcah ennit, jʉibí chʉ́ʉdnit, ã bohénitdih bid bojnit, nin pah queétdihjeh ãt niíj naáwáp wʉt jĩ: —Ded waóhni jʉmíhna, péeni jʉmat caá náahap. Ded maáh jʉmíhna, nihatdih teo wʉ̃hni jʉmat caá náahap, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Páant niijnít, wébítdih bid bojnit, queét cãtíh ãt ñʉhat tʉ́ʉtʉp wʉt jĩ. Ñʉhat tʉ́ʉtnit, caandíh pin teonit, Jesús nin pah queétdih ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ded wã náah yacatdih chãjat tʉ́ʉt niijná, biíc nin panihni wébítdih wẽi jwãáhna, weemdíhbʉt ã wẽi jwãáhna caá. Pánih weemdíh wẽi jwãáhna, wã íip, weemdíh wahnidihbʉt ã wẽi jwãáhna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tʉ́ttimah, Juan Jesúsdih nin pah ãt niijíp wʉt jĩ: —Bohéní, jwĩ enechah, biíc newé ma wẽpatjĩh nemépwãdih ã bacat tʉ́ʉtʉp be. Obohjeéhtih, jwĩjeéh jʉmni ã nihcah, caandíh páant jwĩ chãjat tʉ́ʉtcap be, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Páant ã niijíchah joinít, Jesús ã bohénitdih nin pah ãt niíj jepahap wʉt jĩ: —Páant caandíh ñi niijcá bojoó. Ded wã náah yacatdih chãjat tʉ́ʉt niijná, wã wẽpatjĩh chãj jʉ́ʉtna, tʉ́ttimah weemdíh yeejép ã jéih niijcán niít. ");
INSERT INTO cbv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ded jwiítdih en jʉ̃ihcanni jʉmna, jwĩjeéh ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yoobópdih yeebdíh wã naóhna caá. Wĩ́ihwã ñi jʉmat jíib, ded yeebdíh ã tʉ́i teo wáacachah enna, Dios caandíhbʉt ã tʉ́i chãjbipna caá. Ñi babhbat pínah mahbitdihjeh yeebdíh ã wʉ̃hʉchah, páant ã chãjat jíib caandíhbʉt Dios ã tʉ́i chãjbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nin wébít panihni weemdíh tʉ́i jenah joinídih ded yeejép ã chãjat tʉ́ʉtatji jíib, Dios caandíh yeejép pohba ã peéh chãjbipna caá. Caán ã yéej chãjat tʉ́ʉtat pínah jã́tih, ã́ih bʉtdih bʉ́dí jeé jʉ́dʉjĩh chéo bʉ́ʉdhnit, bʉ́dí mʉjna caandíh ĩ yohochah, ãta tʉ́i tagaá. Páant ĩ chãjachah, caán wébít panihnidih ã yéejacah nihna, Dios páant bóo pohba caandíh ãta peéh chãjcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ñíih téihyajĩh yeejép chãjna, caán téihyadih bóod yohat pahjeh caán ñi yéej chãjatdih ñi cádahaá. Caandíh cádahcan, iiguípna ñi bejbipna caá. Caanná iigát dʉbcan, coyíwãbʉt wʉncannit ĩ jʉmbipna caá. Ñíih téihyadih ñi bóod yohochah nihna, caan dáhjeh ãta bʉʉd tágaá. Yeébboó pánihni cóloh jʉmna yʉhna, tʉ́ttimah Diosjeéh ñi tʉ́i jʉmbipna caá. Obohjeéhtih, chénat pah téihyajĩh iiguípna ñi bejechah, bʉ́dí yeejép ñita yap tagaá. Pánihna, ñi yéej chãjatdih cádahat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Biíc yoobó ñíih jítchajĩh yeejép chãjadih bejna, caán jítchadihbʉt bóod yohat pahjeh caán ñi yéej chãjatdih ñi cádahaá. Caandíh cádahcan, iiguípna ñi bejbipna caá. Caanná iigát dʉbcan, coyíwãbʉt wʉncannit ĩ jʉmbipna caá. Ñíih jítchadih ñi bóod yohochah nihna, caan dáhjeh ãta bʉʉd tágaá. Yeébboó pánihni cólohjeh jʉmna yʉhna, tʉ́ttimah Diosjeéh ñi tʉ́i jʉmbipna caá. Obohjeéhtih, chénat pah jítchajĩh iiguípna ñi bejechah, bʉ́dí yeejép ñita yap tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Biíc yoobó ñíih quíibjĩh ennit, yeejép chãjna, caan dáhdih ñi wã́at yohat pah caán ñi yéej chãjatdih ñi cádahaá. Caandíh cádahcan, iiguípna ñi bejbipna caá.Caanná iigát dʉbcan, coyíwãbʉt wʉncannit ĩ jʉmbipna caá.Caán quíibdih ma yohochah nihna, caan dáhjeh ãta bʉʉd tágaá. Pánihna, biíc bʉwá quíib wihcanni yʉhna, tʉ́ttimah Diosjeéh ñi tʉ́i jʉmbipna caá. Obohjeéhtih, chénat pah quíibjĩh iiguípna ñi bejechah, yeejép pohba ñita yap tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Nin baácdih jʉm jwʉhna, nihat cã́acwã yeejép yapat caá náahap, ĩ yéej chãjatdih cádahnit, tʉ́inijeh ĩ tʉ́ʉt nʉʉmát pínah niijná. Jwĩ jeémátdih nʉ́ʉmni ãpĩ́ náahna caá, ã tʉ́i nʉñat pínah niijná. Pánihat pah, cã́acwãdihbʉt yeejép yapat ã náahna caá, tʉ́ʉt nʉʉmnít, ĩ tʉ́i chãjat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nʉ́ʉmni bʉiná, jeémátdih ã tʉ́i nʉñana caá. Obohjeéhtih, nʉ́ʉmni ã bʉyát beedéchah, ñi jéih jwʉ́ʉb bʉyácan caá. Pánihna, ñi jeémátdih nʉ́ʉmnijĩh ñi tʉ́i bʉyát pah, yeéb bitajeéh biícdih ñi tʉ́i jʉmat tʉ́ʉt niijná, tʉ́inijeh ñi chãjaá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaum tʉ́tchimant bejnit, Judea baácna jʉibínit, Jordán mʉj conanaáboó Jesúswã ĩ chʉ́ʉh jʉibínachah, dawá Jesús pebh ĩt míic wáac jʉibínap wʉt jĩ, páant mʉntih. Páant ã pebh ĩ míic wáac jʉibínachah ennit, ãpĩ́ bohéátji pahjeh mʉntih ãt jwʉ́ʉb bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Páant ã bohéát pónih, fariseowãbʉt ĩt jʉibínap wʉt jĩ. Pánih jʉibínit, Jesúsdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ, ded pah ã jepahatdih joinít, caandíh ĩ naóh yacat tʉ́ʉt niijná: —¿Jwĩ weha mána yaádhdih jwĩ yohochah, ã tʉ́imi naniít? ¿Dios ã wʉtatboó páant niít ã chãjat tʉ́ʉtʉp, ma jenah joyóchah? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Ded pah tigaá Moisés ãt niíj wʉtji? Jesús queétdih ãt niíj ʉʉ́bh joí jwʉ́ʉbanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—‘Majeéh bólidih cádahíhna, “Meém ma tʉ́icat enna, meemdíh wã yohna caá”, niíj daácnit, caántdih ñi wʉ̃hʉʉ́. Páant niíj daác wʉ̃hnit, majeéh bólidih ma cádahachah, ã tʉ́ina caá’, Moisés ãt niíj daacáp tajĩ, fariseowã ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Diosdih ñi nʉowã ĩ jepahíhcah enna, páant Moisés ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Páant ã niíj daacátji ã jʉmʉchah yʉhna, jon jã́tih nin baácdih chãjnit, newé yad biícdih Dios ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pánih biícdih ã chãjachah, newé ã mánadih cádahnit, yad biícdih ãpĩ́ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Queét chénewã jʉmna yʉhna, biíc bácah panihnit caá ĩ jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pánihna, Dios queétdih biíc bácah panihnit ã chãjachah, queétjeh míic cádahcat caá náahap, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Páant ã niiját tʉ́ttimah, mʉʉ́boó jʉmna, páant ã naáwátjidih ã bohénit caandíh ĩt ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Páant ĩ ʉʉ́bh joyóchah, nin pah queétdih ãt niíj jepahap wʉt jĩ: —Ded ãjeéh bólidih yohnit, biíh wilidih jwʉ́ʉb áa jʉmna, ã yohnihdih yeejép ã chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yad wilibʉt newédih yohnit, biíhdih jwʉ́ʉb áa jʉmna, mi yohnidih yeejép mi chãjna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cã́acwã ĩ wehdih ã teo jã́ha ʉʉ́bát pínah niijná, Jesús pebhna ĩ mána ĩt ʉb jʉibínap wʉt yʉh jĩ. Obohjeéhtih, ã bohénitboó queétdih ennit, ĩt jípónih jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Páant ĩ jʉ̃ihñʉchah ennit, Jesús íijnit, ã bohénitboodíh nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: —Wébít wã pebh ĩ jʉ̃ʉ́wʉ́ naáh. ‘Ñi bejca bojoó’, queétbitdih ñi niijcá bojoó. ‘Dios wã maáh caá’, niijnít, queét wébít caá tʉ́i jenah joinít ĩ jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Dios ã maáh jʉmʉpna waadnítboó nit wébít ĩ jenah joyát pah jenah joinít ĩ jʉmna caá. Yoobópdih yeebdíh wã naóhna caá. Nitbit Diosdih ĩ náahat pah yeéb ñi náahcan, Dios pebhna ñi jéih bejcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Páant niíj péanit, wébítdih ʉb tʉ́ʉh teo jã́hanit, nin pah Diosdih ãt niíj ʉʉ́bʉ́p wʉt jĩ: “Nitbitdih ma tʉ́i teo wáacá, Paá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesúswã namádih ĩ bejechah, biíc newé ñáo ñah bej, Jesús pebh bódicha caj yoh ñajnit, caandíh wẽina, nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Tʉ́i Bohéní, páantjeh Diosjeéh jʉmíhna, ded pah tigaá wã chãjbi? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Dépanih tigaá ‘Tʉ́ini’, weemdíh ma niíj? Diosjeh caá tʉ́ini. ");
INSERT INTO cbv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dios ã wʉtatdih ma jéihna caá. ‘Cã́acdih ma mao yohca bojoó.Ma áa nihcannihjĩh ma yéej chãjca bojoó.Ma nʉʉmcá bojoó.Ma yeeca bojoó.Bitadih yee naóhnit, ĩ́ih bií déedih ma ʉbca bojoó. Ma mánadih tʉ́inijeh ma chãjaáp’,Dios ã niijíp jĩ. Caán ã wʉtatdih jepahat caá náahap, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Bohéní, wébít jʉmna, wã yap yohcatji pah, bʉʉbʉt biíc yoobó wã yap yohcan caá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Páant ã niijíchah joí, en jã́hanit, Jesús caandíh ãt oyop wʉt jĩ. —Diosjeéh ma tʉ́i jʉmat pínah, bainí caá meemdíh ã jʉdhdʉp. Nihat míih bií déedih jíib chãjadih ma bejeé. Pánih jíib chãjnit, caán jíibdih moh yéejnitdih ma wʉ̃hʉʉ́. Páant ma wʉ̃hʉchah, nin baácboó ma bíbohatji chah tʉ́ini míih pínah Dios pebhboó ã jʉmbipna caá. Wã niiját pah chãj péa, wãjeéh ma pée jʉ̃ʉ́wʉ́, Jesús ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Obohjeéhtih, páant ã niijíchah joiná yʉhna, caánboó dawá bií déedih bíbohni jʉmna, ã́ih bií déedih jíib chãj wʉ̃híhcan, bʉ́dí ãt jĩ́gahap wʉt jĩ. Pánih jĩ́gahnit, jepahcanjeh, ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Páant ã jwʉ́ʉb bejechah, ã bohénitdih tac pʉ́ʉd ennit, nin pah Jesús queétdih ãt niijíp wʉt jĩ: —¡Dawá bií dée bíbohnit Dios ã maáh jʉmʉpna ĩ waadát ã bʉona caá! ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Páant ã niijíchah joinít, queétboó ĩt joí wʉ́hi bejep wʉt jĩ. Páant ĩ wʉ́hi bejechah ennit, queétdih Jesús nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Némewãá, det Diosdih tʉ́i jenah joicán, ‘Nihat wĩ́ih bií déejĩh wã tʉ́i yapbipna caá’, niíj jenah joinít, Dios ã maáh jʉmʉpna ĩ jéih waadcán caá. ");
INSERT INTO cbv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camelloboó awí íitbitdih ã yabac bejíhichah nihna, ãta bʉo tagaá. Pánihat pah, dawá bií dée bíbohni Dios ã maáh jʉmʉpboó ã waádíhichah yʉhna, bʉ́dí ã bʉona caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Páant ã niijíchah joinít, chah wʉ́hi bejna, queétjeh nin pah ĩt míic niijíp wʉt jĩ: —Páant ã niijíchah bácah, Dios ã jʉmʉpboó ded ã jéih waadcán niít, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","—Cã́acwã ded pah ĩ jenah joyátjĩhjeh ĩ tʉ́i chãjíhna yʉhna, Dios pebhboó ĩ jéih bejcan niít. Diosjeh iiguípna bejnit déedih ã tʉ́i ʉbna caá. Caanjéh tigaá nihatdih jéih beedáni. Dedé jéihcat pínah caandíh ã wihcan caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—Maá, weemdíh ma joi jwʉ́hʉʉ́. Majeéh péeat tʉ́ʉt niijná, jwiítboó nihatdih jwĩ cádahap jĩ, Pedroboó ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","—Yoobópdih yeebdíh wã naóhna caá. Det wĩ́ih tʉ́ini doonádih jepahnit, wã weñat pínahdih chãjat tʉ́ʉt niijná, nihat ĩ́ih bií déedih cádahnit, páant ĩ chãjat jíib bʉ́dí tʉ́inidih ĩ bíbohbipna caá. Ĩ́ih mʉʉnádih, ĩ ʉ́ʉdwãdih, ĩ mánadih, ĩ weha mána yaádhdih, ĩ wehdih, ĩ́ih wápchidih yʉh bʉca cádahnit jʉmna, nin baácboó jʉm jwʉhna, chah dawá ĩ bíbohbipna caá. Obohjeéhtih, pánih tʉ́ini jʉmna yʉhna, yeejépbʉt ĩ yapbipna caá. Tʉ́ttimah bóo láabʉt páantjeh Dios biícdih ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Obohjeéhtih, nin baácboó jʉm jwʉhnit, dawá cã́acwã bʉ́dí bií dée bíbohnitji, Dios pebhboó moh yéejnit ĩ jʉmbipna caá. Pánihna, nin baácboó dawá moh yéejnitji jeáboó maáta ĩ jʉmbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tʉ́ttimah, Jesús Jerusalén tʉ́tchina ã bohénitdih ãt nʉmah aab béjep wʉt jĩ. Caán tʉ́tchina ã nʉmah bejechah ennit, ã bohénitboó ĩt wʉ́hi bejep wʉt jĩ. Bita ĩjeéh péenitbʉt bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. Pánihna, Jesús doce ã bohénitdihjeh bitadih yʉʉ́pbit nʉmah bejnit, ded pah cã́acwã caandíh ĩ chãjat pínahdih queétdih ãt jwʉ́ʉb naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jerusalén tʉ́tchina aab béjna caá jwĩ chãjap. Caanná jwĩ jʉibíát tʉ́ttimah, weém, nihat cã́acwã ʉ́ʉd jeñédih caanjĩ́h moón ĩ teobipna caá. Pánih teonit, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit biícdih ĩ wʉ̃hbipna caá. Pánih wʉ̃hnit, judíowã nihcannitboodíh ĩ jwʉ́ʉb wʉ̃h yapabipna caá, weemdíh ĩ mao yohat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Páant ĩ mao yohat tʉ́ʉtʉchah, queétboó deoh naóh, mao mácjĩh coí jã́hanit, weemdíh ĩ pʉ̃ibipna caá. Páant ĩ chãjat tʉ́ttimah, weemdíh ĩ mao yohbipna yʉh caá. Obohjeéhtih, páant ĩ mao yohochah yʉhna, biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá, páant mʉntih”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Páant Jesús queétdih ã niíj naóh péanachah, Zebedeo weh Santiago, Juanjĩh Jesús pebhna jʉibínit, caandíh nin pah ĩt niijíp wʉt jĩ: —Bohéní, jwĩ niiját pah jwiítdih ma chãj wʉ̃hʉʉ́, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Ded pah wã chãjat tigaá yeéb ñi náah? Jesús queétdih ãt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Nihat cã́acwã ĩ maáh waadná, meém biícdih jwiítdihbʉt ma chʉ́ʉdat tʉ́ʉtʉ́, majeéh maáta jwĩ jʉmat pínah niijná. Weemdíh ma jéihyepmant bóo bʉwámant chʉ́ʉdat tʉ́ʉt, wã ʉ́ʉdboodíh wáyámant bóo bʉwámant ma chʉ́ʉdat tʉ́ʉtʉ́, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Ded pah yeéb yeejép ñi yapat pínahdih jéihcan yʉhna, páant weemdíh ñi niíj ʉʉ́bhna caá. ¿Bʉʉ weém yeejép wã yapat pínahdih biíc yoobó yeebbʉ́t yeejép yapnit, ñi jéih bʉʉjámi naniít? queétdih ãt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Biíc yoobó yapna yʉhna, jwiítboó jwĩ jéih bʉʉjámi nacaá, ĩt niíj jepahap wʉt jĩ. —Weém yeejép wã yapat pahjeh yeebbʉ́t yeejép ñi yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Obohjeéhtih, pánih yapnit pínah ñi jʉmʉchah yʉhna, wãjeéh chʉ́ʉdnit pínahdih wã jéih ñíocan caá. Caandíh wã íipboó ãtát ámoh jwej péa tagaá. Pánihna, caán ã ñíonitjeh wã jéihyepmant bóo bʉwámant, wáyámant bóo bʉwámantbʉt ĩ chʉ́ʉdbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiago Juanjĩh ĩ ʉʉ́bátjidih joinít, bita ã bohénitboó queétdih ĩt íijip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Páant ĩ íijichah ennit, nihat queétdih bid bojnit, Jesús nin pah ãt niíj naáwáp wʉt jĩ: —Diosdih jéihcannit maátaboó ĩ́ih cã́acwãdih wʉtna, nihat jéihnit dée pah queétdih ĩpĩ́ wẽp wʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yeébboó páant ñi jʉmca bojoó. Obohjeéhtih, ñijeéh jʉmni ded maáh jʉmíhna, nihat ãjeéh moondíh teo wʉ̃hni panihni jʉmat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ded nihatdih wʉtíhna, bitadih teo wʉ̃hni ã jʉmʉ naáh. ");
INSERT INTO cbv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Weembʉ́t oboh jʉmni panihni wã jʉmna caá. Pánih jʉmna, weém nihat cã́acwã ʉ́ʉd jeñé jʉmna yʉhna, nin baácboó jʉ̃óhna, cã́acwã weemdíh ĩ teo wʉ̃hatdih wã bidcan caá. Pánih bidcan, queétdih teo wáacadih wã jʉ̃ʉ́wʉ́p be. Dawá ĩ yéejat jíib iiguípna bejnit déejidih tʉ́i ʉbat tʉ́ʉt niijná, queétdih wʉn wʉ̃hʉdih wã jʉ̃ʉ́wʉ́p be, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tʉ́ttimah, Jesús ã bohénit biícdih Jericó tʉ́tchiboó ĩt jʉibínap wʉt jĩ. Jʉibínit, ĩ waad yábac bejechah, queétdih dawá ĩt péenap wʉt jĩ. Páant ĩ yabac bejechah, jéih encanni, Bartimeo wʉ̃t jʉmni, namá jwẽ́ejdih dinero ʉʉ́bh chʉ́ʉdna ãt chãjap wʉt jĩ. Caán Timeo ã wʉ̃ʉ́h wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pánih chʉ́ʉdnit, Jesúswã ĩ yap bejechah joinít, Bartimeo nin pah ãt niíj ej jwíihip wʉt jĩ: —¡Jesús, David jʉima, Dios ã wahni, weemdíh ma jĩ́gah en teo wáacá! ãt niíj ejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Obohjeéhtih, páant ã niíj ejechah joinít, cã́acwã caandíh ĩt jʉ̃ihñʉp wʉt jĩ: —Pánih ejcan, ma laihca bojoó, ĩt niijíp wʉt yʉh jĩ. Obohjeéhtih, páant ĩ niíj jʉ̃ihñʉchah yʉhna, Bartimeoboó chah wẽpép ãt ejep wʉt jĩ. —¡David jʉima, Dios ã wahni, weemdíh ma jĩ́gah en teo wáacá! ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bartimeo páant ã niíj ejechah joinít, bejna yʉhna, chãonít, nin pah Jesús ãt niijíp wʉt jĩ: —Caán ã jʉ̃ʉ́wʉ́ naáh, ãt niijíp wʉt jĩ. —Ma weñeé. Ma ñah ñʉhʉʉ́. Meemdíh ‘Jʉ̃ʉ́wʉ́’, ã niijná caá, caandíh ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Páant ĩ niijíchah joinít, ã́ih jih bóo yégueh chóodih ʉb yoh jéena, ñah ñʉhnit, Bartimeo Jesús pebhna ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Páant ã pebhna jʉibínachah, Jesús caandíh nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedé dée tigaá meemdíh wã chãjbi? ãt niijíp wʉt jĩ. —Bohéní, bʉ́dí wã eníhna caá, ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Ma bejeé. Weemdíh ma tʉ́i jenah joyát jíib enni ma jʉmna caá, Bartimeodih ãt niijíp wʉt jĩ. Jesús páant ã niijíchahjeh, Bartimeo ãt jéih enep wʉt jĩ, bʉca. Pánih ennit, Jesús ã bejechah, Bartimeobʉt ãjeéh ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jericó tʉ́tchimant bejnit, Jesús ã bohénit biícdih Jerusalén tʉ́tchina ĩt bejep wʉt jĩ. Caán tʉ́tchidih ĩ jʉibíát pínah jã́tih, Betfagé tʉ́tchibit, Betania tʉ́tchibitbʉt pebhbit ĩt jʉibínap wʉt jĩ. Olivo dah jeé pʉ́ʉjdih bóo tʉ́tchina wʉt jĩ. Caánboó jʉibínit, chénewã ã bohénitdih caán bainí tʉ́tchina Jesús ãt wahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Con pebhbit bóo tʉ́tchibitna ñi bejeé. Caanná jʉibínit, chéoni burro wʉ̃ʉ́hdih ñi enbipna caá. Cã́acdih dʉo jwʉ́hcanni caá. Caandíh ñi wataáp. Watnit, ñi ʉb jʉ̃ʉ́wʉ́. ");
INSERT INTO cbv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bita ñi watatdih ennit, ‘¿Dépanih tigaá caandíh ñi wat?’ ĩ niijíchah, ‘Jwĩ Maáh caandíh ã ʉb jwʉhat tʉ́ʉtʉp be. Ã náahatdih chãj péa, ã jwʉ́ʉbabipna caá’, queétdih ñi niijí, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jesús páant ã niijíchah joinít, ĩt bejep wʉt jĩ. Jʉibínit, jẽc pebh chéoni, namáboó ñʉhni, burro wʉ̃ʉ́hdih ĩt enep wʉt jĩ. Ennit, caandíh ĩt watap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Caan pébh en ñʉhnit, nin pah ĩt niijíp wʉt jĩ: —¿Dépanih tigaá caandíh ñi wat? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Páant ĩ niíj ʉʉ́bh joyóchah joinít, Jesús ã niijátji pah queétdih ĩt jepahap wʉt jĩ. —Páant ta tigaá. Ñi ʉb bej jwʉhʉʉ́, ĩt niijíp wʉt jĩ. Páant ĩ niijíchah joinít, Jesús ã páñapboó ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pánih ʉb jʉibínit, ĩ́ih jih bóo yégueh chóodih tóo dʉgnit, burrodih ĩt cáagap wʉt jĩ. Cáag péanachah, burrodih pʉ́ʉh laabnít, yéguehjih Jesús ãt chʉ́ʉdʉp wʉt jĩ. Pánih chʉ́ʉdnit, Jesúswã Jerusalén tʉ́tchina ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dawá cã́acwã ĩ́ih jih bóo yégueh chóodih namáboó ĩt jwej waáwáp wʉt jĩ. Bitabʉt tʉ́tchi jwẽ́ejdih ĩ bóodniji táam nʉ́onadih ʉb jʉ̃óhnit, namáboó ĩt jwej waáwáp wʉt jĩ. Ĩ́ih yégueh, táam nʉ́onadihbʉt namáboó jwej waóhna, Jesús ĩ maáh pínah ã jʉmatdih jʉ́ʉtna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Páant Jesúswã ĩ bejechah, ã waáwápmant, ã méimant péenitbʉt nin pah ĩt niíj ejep wʉt jĩ: —¡Diosdih jwĩ wẽi naóh jĩíh! ¡Hosana, nin Dios ã wahni jwiít judíowãdih teo wáacni pínah ã tʉ́i jʉmʉ naáh! ");
INSERT INTO cbv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jwĩ nʉo David ã maáh jʉmatji pah nin jʉ̃óhni ã jwʉ́ʉb maáh jʉmbipna caá. ¡Tʉ́ina caá ã maáh jʉmat pínah! ¡Tʉ́ina caá, Paá! ¡Meém caá mat wahap! niijná ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pánih bejna, Jesúswã Jerusalén tʉ́tchina jʉibínit, Dioíh mʉʉná ĩt waad béjep wʉt jĩ. Pánih waad béjnit, Jesús nihatdih ãt táoh en jibip wʉt jĩ. Táoh en péanit, tõo ñáh jʉ̃ʉ́wʉ́chah, Betania tʉ́tchina Jesús doce ã bohénit biícdih ʉ̃wʉdih ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tʉ́ttimah bóo yeó jáapdih queét Betania tʉ́tchidih ʉ̃onitji Jerusalén tʉ́tchina ĩt jwʉ́ʉb bejep wʉt jĩ. Pánih bejnit, nʉʉgʉ́p wʉnna, higuera tʉ́i wawá jʉmni nahdih yʉʉ́p en bojnit, Jesús ã́ih quehedih bididih ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Obohjeéhtih, tʉ́ini wawá jʉmna yʉhna, quehcat láa ã jʉmʉchah, ã́ih quehe ãt wihcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pánihna, ã quehcatdih enna, nin pah Jesús caan náhdih ãt niijíp wʉt jĩ: —¡Ma quehcah, cã́acwã míih quehedih ĩ jwʉ́ʉb jeémpcan niít! ãt niijíp wʉt jĩ. Caan náhdih páant ã niijíchah, ã bohénit ĩt joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Páant niíj péanit, Jerusalén tʉ́tchina ĩt bejep wʉt jĩ. Caanná jʉibínit, Dioíh mʉʉ́ jóocmant bóo jʉʉ́hdih ĩt jwʉ́ʉb waad béjep wʉt jĩ. Pánih waad béjnit, bií dée jíib chãjnitdih Jesús ãt jʉ̃ih ñʉʉn bácanap wʉt jĩ. Dinero tʉ́ʉt nʉʉmnít cã́acwãíh cáagat naanádih, jopwãdih jíib chãjnitíh chʉ́ʉdat naanádihbʉt ãt ʉb yoh ã́acanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pánihna, bií déedih jípónih ʉb yabac bejnitdih Jesús ãt jʉ̃ih jwʉ́ʉba bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pánih jʉ̃ih baca péanit, caánboó jʉmnitdih Jesús nin pah ãt niíj bohénap wʉt jĩ: —Dios naáwátdih naóh yapani jon jã́tih nin pah ãt niíj daacáp tajĩ: ‘ “Wĩ́ih mʉʉ́ nihat baácmant moón weemdíh ʉʉ́bát pínah mʉʉ́ caá”, Dios ã niijíp be’, ãt niíj daacáp tajĩ.Obohjeéhtih, cã́acwã Diosdih ʉʉ́bʉ́dih ĩ jʉyʉ́chah yʉhna, yeébboó queétdih yeenit nʉʉmná caá ñi chãjap. Pánih chãjnit, Dioíh mʉʉdíh yéejana, nʉʉmnít ĩ jʉmat pínah mʉʉ́ chãjna caá ñi chãjap, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Páant Jesús ã niíj bohéátdih joinít, dawá cã́acwã bʉ́dí ĩt joí wʉ́hi bejep wʉt jĩ. Ĩ joí wʉ́hi bejatdih jéihnit, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt cã́acwãboó queétdih cádahnit, Jesúsboodíh ĩ jwʉ́ʉb péeat pínahdih ĩt ʉ́ʉmʉp wʉt jĩ. Jesús Dioíh mʉʉdíh páant ã niijíchah joinít, caandíh ʉ́ʉmna, nin pah ĩt míic niijíp wʉt jĩ: “¿Ded pah tigaá caandíh jwĩ jéih mao yohbi?” ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tõo ñáh jʉ̃ʉ́wʉ́chah, Jesúswã Jerusalén tʉ́tchimant ĩt jwʉ́ʉb bac bejep wʉt jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tʉ́ttimah bóo yeó jáap, Jerusalén tʉ́tchina jwʉ́ʉb aab béjna, higuera nahjidih ĩt enep wʉt jĩ. Caan náh ãtát wʉnah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Caan náh ã wʉnatdih ennit, Jesús ã niijátjidih náhninit, Pedroboó caandíh nin pah ãt niijíp wʉt jĩ: —¡Bohéní, ma eneé! Higuera nah ma wʉnat tʉ́ʉtni jáantjeh ãt wʉnah bejep tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Dios ã wẽpatdih ñi tʉ́i jenah joyoó. ");
INSERT INTO cbv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yoobópdih yeebdíh wã naóhna caá. Diosdih tʉ́i jenah joinít, ‘Weém wã ʉʉ́bát pahjeh ã yapbipna caá’, ñi niíj jenah joyóchah, ñi niiját pahjeh ã yapbipna caá. Dios ã wẽpatdih tʉ́i jenah joiná, nin jeedíh bʉ́dí mʉjna ñi bejat tʉ́ʉtʉchah, ñi niiját pahjeh ã yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nin pah yeebdíh wã jwʉ́ʉb naóhna caá. Diosdih ʉʉ́bhna, ‘Wã ʉʉ́bát pahjeh tigaá weemdíh ã wʉ̃hʉp’, niíj jenah joinít, ñi ʉʉ́bátdih ñi bíbohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Obohjeéhtih, Diosdih ñi ʉʉ́bát pínah jã́tih, yeebdíh bita yeejép ĩ chãjatjidih ñi íij yayaá. Páant ñi íij yayáchah ennit, yeébboó ñi yéej chãjatdih jwĩ íip jeáboó jʉmnibʉt ã íij yaibípna caá. ");
INSERT INTO cbv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Obohjeéhtih, yeebdíh yeejép chãjnitdih ñi íij yaicáh ennit, jwĩ íip jeáboó jʉmni biíc yoobó ñi yéej chãjatdih ã íij yaicán niít, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Páant niij béjna, Jerusalénna Jesúswã ĩt jʉibínap wʉt jĩ. Pánih jʉibínit, Dioíh mʉʉ́ jóocmant bóo jʉʉ́hdih ĩt táoh enep wʉt jĩ, páant mʉntih. Páant Jesús ã táoh enechah, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, jwiít judíowãdih waóhnit biícdih ã pebh jʉibínit, ");
INSERT INTO cbv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nin pah caandíh ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Deíh wẽpatjĩh tibeé jwíin páant ma chãj? ¿Déhe tibeé meemdíh páant ã wʉt? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Yeebdíh caá wã jwíih ʉʉ́bh joibíp. Weemdíh ñi tʉ́i jepahachah, weembʉ́t ñi ʉʉ́bh joyátdih wã jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Juan yeebdíh ã daabánachah, déhe tibeé caandíh ãt daabáát tʉ́ʉtji? yeéb ñi jenah joyóchah. ¿Dios ãt wʉtjican taniít? ¿Cã́acwãboó niít caandíh ĩt daabáát tʉ́ʉtjip? ñi jenah joyóchah, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Páant ã niijíchah joinít, queétjeh nin pah ĩt míic niijíp wʉt jĩ: “¿Ded pah tigaá jwĩ niíj jepahbi? ‘Dios Juandih ãt wʉtʉp tajĩ’, jwĩ niijíchah, ‘Páant ã jʉmʉchah yʉhna, ¿dépanih tijĩí caandíh ñi jepahcan?’ jwiítdih ã niíj jʉ̃ihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Obohjeéhtih, nitboó ‘Juan Dios naáwátdih naóh yapani yoobát ã jʉmʉp jĩ’, ĩ niíj jenah joiná caá. Páant ĩ niíj jenah joyóchah, jwiítboó ‘Cã́acwãjeh caandíh ĩt daabáát tʉ́ʉtjip taga’, jwĩ niíj jepahachah, queét jwiítdih ĩ íijbipna caá”, ĩt míic niijíp wʉt jĩ. Pánihna, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, jwiít judíowãdih waóhnitbʉt cã́acwãdih ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pánih ʉ́ʉmnit, Jesúsdih nin pah ĩt niíj jepahap wʉt jĩ: —Juandih daabáát tʉ́ʉtnidih jwĩ jéihcan caá, ĩt niijíp wʉt jĩ. —Caán láa bácah weemdíh wʉtnidih weembʉ́t yeebdíh wã naóhcan niít, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Páant niíj péanit, Jesús nin ã jenah joiní naáwátjĩh cã́acwãdih ãt niíj bohénap wʉt jĩ: “Biíc newé jiwá iguíhdih ã momop be. Mom péanit, wáihyat jʉ́dʉdih chãj péa, caán iguíhdih ĩ bʉ́ʉh chʉñat pínah mʉʉdíhbʉt ã chãjap be. Pánih chãj péa, jap bóo mʉʉdíhbʉt ã chãjap be, caán iguíh wáapdih ĩ en dawát pínah niijná. Caandíh chãj péa, bitadih en dawát tʉ́ʉtnit, caán biíh baácboó jib jwʉhʉdih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tʉ́ttimah, iguíh ei láa caandíh teo wʉ̃hnidih ã́ih iguíh wáapna ã wah bojop yʉh be, ã́ih iguíh jíibdih ã ʉʉ́bát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Obohjeéhtih, caanná ã jʉibínachah, iguíhadih en daonítboó caandíh teonit, ĩ maáhdih jíib wahcanjeh, ĩ pʉ̃i ñʉʉn yóh jwʉ́ʉba bojop be. ");
INSERT INTO cbv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tʉ́ttimah, iguíha mínah biíh caandíh teo wʉ̃hnidih ã jwʉ́ʉb wahap yʉh be, páant mʉntih. Obohjeéhtih, ã jʉibínachah, caandíhbʉt yeejép niijnít, ã́ih wao dáhdih ĩ dʉ́ʉc mawap be. ");
INSERT INTO cbv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Páant ĩ chãjat tʉ́ttimah, biíhdih ã wah bojochah, wápchi en daonít caandíh ĩ mao yohop be. Dawá bitadihbʉt ã wahachah, biquínadih mao yohnit, bitadih ĩ yeejép chãjap be. ");
INSERT INTO cbv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Caán iguíha mínahdih ã wʉ̃ʉ́h, bʉ́dí ã oinijeh ã jʉdhdʉp be. Pánihna, ã wʉ̃ʉ́h ã oinidih ã wahap be, bʉca. Pánih wahnit, nin pah ã niíj jenah joyóp yʉh be: ‘Wã wʉ̃ʉ́hboodíh ĩ tʉ́i chãjbipna caá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Obohjeéhtih, wápchi en daonítboó queétjeh nin pah ĩ míic niíj wéhenap be: ‘Nin wápchi mínah wʉ̃ʉ́h caá. Caandíh jwĩ mao yoh jĩíh, behe ã wʉnat tʉ́ttimah, nin jwĩ́ih wáap ã jʉmat pínah niijná’, queétjeh ĩ míic niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Páant niijná, caandíh mao yohnit, wápchi jwẽ́ejboó ã́ih bácahjidih ĩ yohop be. ");
INSERT INTO cbv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Wápchi mínah jwʉ́ʉb jʉibínit, ded pah tigaá caán wápchidih en daonítdih ã chãjbi? Nin pah queétdih ã chãjbipna caá: Queétdih mao yohnit, bitaboodíh caán wápchidih ã en dawát tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","¿Dios naáwátdih naóh yapani ã daacátjidih yeéb ñi bohécannit jĩí? Nin pah ãt niíj daacáp tajĩ: ‘Mʉʉ́ teonit tʉ́ini jee dáhnadih ñíonit, ĩ náahcanni dahdih ĩ yohop yʉh be. Obohjeéhtih, caán ĩ yohni dahdihjeh tigaá Dios ã ñíwip. Caandíh ñíonit, ã́ih mʉʉ pánihnidih chãjna, choójboó caan dáhdih ã jwíih jwejep be, caán mʉʉdíh tʉ́i jenah enat tʉ́ʉt niijná. Caán jee pánihni Dios ã wahni pínah Cristo tigaá. Páant ã chãjachah ennit, jwiítboó caandíh bʉ́dí jwĩ wẽina caá’, ãt niíj daacáp tajĩ”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Páant ã niijíchah joinít, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, jwiít judíowã jwĩ maáta biícdih nin pah ĩt niíj jenah joyóp wʉt jĩ: “Jesús iguíhadih en daonít naáwátjĩh jwiítdih jʉ̃ihna caá ã chãjap”, ĩt niijíp wʉt jĩ. Páant niíj jenah joinít, Jesúsdih ĩt tewíhip wʉt yʉh jĩ. Obohjeéhtih, cã́acwãdih ʉ́ʉmnit, caandíh teocanjeh, ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pánih bejnitji fariseowã ĩ maátaboó biquína ĩjeéh moondíh Herodesjeéh moondíhbʉt, Jesús pebhna wahna, caandíh ĩt ʉʉ́bh joyát tʉ́ʉtʉp wʉt jĩ, Jesús mácah ã jepahachah, caandíh naóh yacat tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pánihna, Jesús pebhna jʉibínit, queét yeenitboó caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt yʉh jĩ: —Bohéní, yeecanni jʉmna, Dios ded pah jwiítdih ã chãjat tʉ́ʉtatdih yoobópdih ma bohéátdih jwĩ jéihna caá. Ded pah cã́acwã ĩ niijíchah, maáta ĩ jʉmʉchah yʉhna, ʉ́ʉmcanjeh yoobópdih mapĩ́ naóhna caá. Páant yoobópdih naóhni jʉmna, nin jwĩ ʉʉ́bh joyátdih ma jepahaá: ¿Roma baácdih moón ĩ maáh César ã ʉʉ́bát tʉ́ʉtni nʉ́odih caandíh jwĩ wʉ̃hʉchah, ã tʉ́i niít? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Páant ĩ niíj ʉʉ́bh joyóchah, ĩ yeeatdih jéihnit, nin pah Jesús queétdih ãt niíj jepahap wʉt jĩ: —Yeéb yeenit, ¿dépanih tigaá weemdíh mácah ñi jepahat tʉ́ʉt? Ñi bíbohni dinero jʉ́dʉdih weemdíh ñi wʉ̃hʉʉ́, wã en jwʉhat pínah niijná, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Páant ã niijíchah joinít, caandíh biíc jʉ́dʉ ĩt wʉ̃hʉp wʉt jĩ. Páant ĩ wʉ̃hʉchah, caán jʉ́dʉdih ennit, —¿Nin jʉ́dʉboó deíh móot, deíh wʉ̃t tigaá ã jʉm? queétdih ãt niijíp wʉt jĩ. —Césaríh móot, ã́ih wʉ̃tbʉt ã jʉmna caá, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Caán láa bácah nin jʉ́dʉ Césaríh pínah caá. Pánihna, ã́ih pínah ã jʉmʉchah, caandíh wʉ̃hat caá náahap. Obohjeéhtih, Dioíh pínah mácah ã jʉmʉchah, Diosboodíh ñi wʉ̃hʉʉ́, Jesús queétdih ãt niijíp wʉt jĩ. Páant ã niíj jepahachah, ĩt joí wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Páant queétdih ã jepahat tʉ́ttimah, biquína saduceowã jwʉh Jesús pebh ĩt jʉibínap wʉt jĩ. Queét saduceowã “Cã́acwã wʉnna, ĩ jwʉ́ʉb boo pʉd jʉ̃óhcan niít”, niijnít ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Páant niíj jenah joinít, nin pah Jesúsdih ĩt niijíp wʉt jĩ: —Bohéní, nin pah Moisésji ãt niíj bohénap tajĩ: ‘Weép jeñé weh wihcanjeh ã wʉnʉchah, ã ʉ́ʉdboó weép jeñé áajidih jwʉ́ʉb áa jʉmat náahap. Pánihna, ã ʉ́ʉdboó áa wih jwʉhcanni ã jʉmʉchah, éemp wʉnnihdih ã bíboho naáh, ã ʉ́ʉd jeñé báadhda weh pah ĩ weh jʉmat pínah niijná’, Moisésji ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Biíc weh sietewã ĩ jʉmʉp be. Weép jeñéboó áa jʉm, weh wihcanjeh ã wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ã ʉ́ʉdboó weép jeñé áajidih ã jwʉ́ʉb áa jʉmʉp yʉh be. Páant áa jʉmat tʉ́ttimah, weép jeñé pahjeh mʉntih, weh wihcanjeh caanbʉ́t ã wʉnʉp be. Tʉ́ttimah bóobʉt weép jeñé áajidih jwʉ́ʉb áa jʉmna yʉhna, caanbʉ́t weh wihcanjeh ã wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Páant míicjeh queét nihat ĩ bʉʉ́d beedép be. Páant mi weha mána ĩ wʉn beedát tʉ́ttimah, ĩ áajibʉt mi wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pánihna, queét nihat siete ĩ áaji, nihat ĩ jwʉ́ʉb boo pʉd jʉ̃ʉ́wʉ́chah, ¿ded áa tigaá mi jʉmbi? Jesúsdih ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Páant ĩ niijíchah joinít, Jesús queétdih nin pah ãt niíj jepahap wʉt jĩ: —Dios naáwátdih jéihcan, ã wẽpatdihbʉt jéihcan, yeébboó yoobópdih jenah joicánnit caá. ");
INSERT INTO cbv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wʉnnitji ĩ jwʉ́ʉb boo pʉd jʉ̃ʉ́wát tʉ́ttimah, jeáboó jʉmna, ángelwã pah áa wihcannit ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Obohjeéhtih, wʉnnitji ĩ boo pʉd jʉ̃ʉ́wát pínahdih yeéb ñi jéihyatdih náah yacna, nin pah wã naóhna caá: Moisésji iigní chálihdih ã enatjidih nin pah ãt niíj daacáp tajĩ: ‘Dios nin pah weemdíh ã niijíp jĩ: “Weém Abraham, Isaac, Jacob ĩ Maáh caá”, ã niijíp jĩ’, Moisés ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ĩ wʉnat tʉ́ttimah yʉhna, ‘Ĩ Maáh caá’, Dios ãt niijíp wʉt jĩ. ‘Ĩ Maáh caá’, ã niijátjidih joinít, báadhnit ĩ jʉmatdih jwĩ jéihna caá. ¡Dios báadhnitdihjeh maáh ã jʉmna caá! Pánihna, ‘Wʉnnitji ĩ jwʉ́ʉb boo pʉd jʉ̃óhcan niít’, niíj jenah joiná, yoobópdih ñi jenah joicán caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisés ã wʉtatjidih bohénitjeéh jʉmni Jesúswã pebh jʉibínit, ĩ míic wéhenachah, ãt joyóp wʉt jĩ. Jesús ã tʉ́i jepahachah joinít, nin pah caandíh ãt niijíp wʉt jĩ: —¿Dios jwiítdih ã wʉtat deddih tigaá chah jenah joyát náah? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Nin wʉtat caá chah ã jʉmʉp: ‘Yeéb judíowã nindih ñi joyoó: Dios ñi Maáh, biícjeh tigaá ã jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Páant ã jʉmʉchah, chah jenah joí, tʉ́i jepahnit, wẽinit, caandíh bʉ́dí ñi oyoó’, Moisés ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Caán wʉtat nʉmp, nin biíh wʉtat ã jʉmna caá. ‘Meemjéh ma míic oyat pah mʉntih, bitadihbʉt bʉ́dí ma oyoó’, ãt niíj daacáp tajĩ.Caán chéne wʉtatna nihat biíh wʉtatnadih chah jenah joyát pínah ã jʉmna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Páant tigaá Bohéní. Yoobópdih tigaá ma niijíp. Dios biícjeh tigaá báadhni. Biíh wihcan caá. ");
INSERT INTO cbv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Páant ã jʉmʉchah, caandíh chah jenah joí, tʉ́i jepahnit, wẽinit, oyat caá jwiítdih náahap. Jwĩ míic oyat pahjeh bitadihbʉt oyat caá náahap. Nʉñʉ́pdih mao cáonit, Diosdih jwĩ weñechah, ã tʉ́ina caá. Páant ã tʉ́yʉchah yʉhna, Diosdih, cã́acwãdihbʉt jwĩ oyat caá chah ã náahap. Meém páant ma niiját yoobópdih tigaá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","—Dios ma maáh ã jʉmat pínah bainí caá meemdíh ã jʉdhdʉp, Moisés ã wʉtatjidih bohénidih Jesús ãt niijíp wʉt jĩ. Páant ã niijíchah joí ʉ́ʉmnit, bita ĩt ʉʉ́bh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Dioíh mʉʉdíh waadnít, Jesús nin pah ãt niíj bohénap wʉt jĩ: —‘Dios ã wahni pínah Cristo David jʉima ã jʉmbipna caá’, Moisésji ã wʉtatdih bohénit ĩ niíj naóhna caá. ¿Páant niíj naóhna, ded pah niíj bohé tigaá ĩ chãj? ");
INSERT INTO cbv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidjijeh Tʉ́ini Espíritu ã wʉtʉchah, nin pah ãt niíj daacáp tajĩ: ‘Diosboó wã Maáhdih nin pah ã niijná caá: “Wã jéihyepmant bóo bʉwámant ma chʉ́ʉdʉ́. Pánih chʉ́ʉdnit, nihatdih ma wʉtʉchah, meemdíh en jʉ̃ihnitdih wã yap yohat tʉ́ʉtbipna caá”, ã niijná caá’, Davidji ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Páant niíj daácnit, Davidji Cristodih ‘Maá’, ãt niijíp wʉt jĩ. Páant ã niijíchah yʉhna, ¿ded pah tigaá Cristo David jʉima ãt jʉmji? Jesús queétdih ãt niíj ʉʉ́bh joyóp wʉt jĩ. Páant ã niíj bohénachah, dawá caandíh ĩt tʉ́i wẽi joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Páant niíj péanit, Jesús nin pah queétdih ãt jwʉ́ʉb niíj naóh bohénap wʉt jĩ: “Moisés ã wʉtatjidih bohénit ĩ yéej chãjatdih ñi tʉ́i eneé. Páant queét ĩ chãjat pah ñi chãjca bojoó. Queét maátni yégueh tʉ́ini chóo dʉonít, cã́acwã ĩ enepdih ĩpĩ́ táoh jib bejna caá. Bií dée jíib chãjapboó bita queétdih tʉ́i wẽi jwãáh ʉʉ́bátdih ĩpĩ́ náahna caá. ");
INSERT INTO cbv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jwiít judíowã jwĩ bohéát mʉʉdíh waáwápboó ĩpĩ́ chʉ́ʉdna caá, nihat queétdih ĩ tʉ́i wẽi enat pínah niijná. Nʉmah jeémépboobʉ́t bejnit, waáwápboó míicjeh chʉ́ʉdna, ĩpĩ́ wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Obohjeéhtih, queét éemp wʉnnit yaádíh mʉʉnádih ĩpĩ́ dʉ́ʉc wáina caá. Páant queét yaádhdih dʉ́ʉc wáina yʉhna, cã́acwã ĩ enepdih Diosdih maatápdih ĩpĩ́ ʉʉ́bhna caá, queétdih ĩ wẽi enat pínah niijná. Páant ĩ chãjat jíib Dios queétdih bʉ́dí ã peéh chãjbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Judíowã ĩ wʉ̃hni dinero ámohat paih pebh Jesús ãt chʉ́ʉdʉp wʉt jĩ. Pánih chʉ́ʉdna, cã́acwã caan páihdih dinero ĩ yacachah, ãt enep wʉt jĩ. Caán dinero Dioíh mʉʉdíh ĩ ámohochah, ĩ jíib chãjat pínah ãt jʉmʉp wʉt jĩ. Dawá bií dée bíbohnit caan páihdih bʉ́dí dinero ĩt yacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Obohjeéhtih, éemp wʉnnih moh yéejnihboó caan páih pebh jʉibínit, chéne jʉ́dʉna cobrejĩh ĩ chãjnijidih mit yacap wʉt jĩ. Caán jʉ́dʉna nʉmp bainí jíib jʉmni ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Caán jʉ́dʉnadih mi yacachah ennit, ã bohénitdih ã pebhna jʉ̃ʉ́wát tʉ́ʉtnit, nin pah Jesús queétdih ãt niijíp wʉt jĩ: —Yoobópdih yeebdíh wã naóhna caá. Nint éemp wʉnnih moh yéejnihboó bita nihat ĩ wʉ̃hat chah mi wʉ̃hʉp be. ");
INSERT INTO cbv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bita dawá bií dée bíbohnit, bʉ́dí ĩ wʉ̃hʉchah yʉhna, queétboó páantjeh bʉ́dí ĩ bíbohna caá. Obohjeéhtih, nint moh yéejnihboó nihat mi jeémát pínahdih mi jíib chãjat déejibitdih mi wʉ̃h beedánap be, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Páant niíj péanit, Dioíh mʉʉmánt ĩ bac bejechah, biíc ã bohéni nin pah ãt niijíp wʉt jĩ: —¡Bohéní, ma eneé! Nin mʉʉ́ bʉ́dí jee dáhnajĩh ĩ chãjni ¿tʉ́ini mʉʉ́ nihcan niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—Tʉ́ttimah, jwiít judíowãdih eníhcannit jʉinít, nin jwĩ enni bʉ́dí mʉʉ́, nin jee dáhnadihbʉt, ĩ yoh beedábipna caá. Biíc jee dáh biíh dahjih lajni ã wihcan niít, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tʉ́ttimah, Jesúswã Olivo jeená pʉ́ʉh laab béjnit, Dioíh mʉʉ́ ã tʉ́i jígohopboó ĩt jʉibínap wʉt jĩ. Caanná jʉibínit, Jesús yʉʉ́pbit ã chʉ́ʉdʉchah, Pedro, Santiago, Juan, Andrésjĩh ã pebh jʉibínit, nin pah caandíh ĩt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ma naáwá jwiítdih. ¿Débólih tigaá meém ma niiját pah ã yapbi? ¿Péeni yeó jáap jã́tih ded pah tigaá ã jwíih yapachah, jwĩ enbi? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—Yeéb ñi tʉ́i chãja chaáh. Bita ĩ yeeatdih ñi joicá bojoó. ");
INSERT INTO cbv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","‘Weém Cristo caá’, niíj yeenit, dawá ĩ jʉ̃óhbipna caá. Páant ĩ yeenachah joinít, Diosdih cádahna, tʉ́ʉt nʉʉmnít, páant niijnítboodíh dawá ĩ péebipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Pebhbit jʉmnit ĩ míic mawatdih, yʉʉ́p jʉmnit ĩ míic mawat doonádihbʉt ñi joibípna caá. Pánih joiná yʉhna, caandíh bʉ́dí ñi jenah joicá bojoó. Páant ã yapbipna caá. Obohjeéhtih, páant ã yapachah yʉhna, péeni yeó jáap pínah páantjeh ã jʉdh jwʉhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Caán láa biíc baácdih moón biíh baácdih moonjĩ́h ĩ míic maobipna caá. Nihat baácboó bʉ́dí míic mawat ã jʉmbipna caá. Dawá pebhboó nʉʉgʉ́p láa, baác méméatbʉt ã jʉmbipna caá. Páant ã yapachah yʉhna, nin baácdih moón chah yeejép ĩ yapat pínah ã jʉdh jwʉhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Páant ã yapachah ennit, yeebjéh ñi tʉ́i chãja chaáh. Bita yeebdíh teonit, maátadih ĩ wʉ̃hʉchah, jwiít judíowã jwĩ míic wáacat mʉʉ́boó ĩ pʉ̃ibipna caá. Páant ĩ chãjachah, wĩ́ihwã ñi jʉmat jíib, tʉ́tchidih moón maátadih, queét chah maátadihbʉt bita yeebdíh ĩ naóh yacbipna caá, ĩ peéh chãjat pínah niijná. Páant queét pebh ñʉhnit, wĩ́ih tʉ́ini doonádih queétdih ñi naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Péeni yeó jáap jã́tih tʉ́ini doonádih nihat baácdih moondíh naóh bohéát caá náahap. ");
INSERT INTO cbv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yeebdíh peéh chãjat tʉ́ʉtni pebhna ĩ ʉb bejechah, ‘¿Caandíh ded pah wã naóhbi?’ ñi niíj jenah joicá bojoó. Caanná ñi jʉmʉchahjeh, ñi naáwát pínahdih Tʉ́ini Espírituboó yeebdíh ã jéihyabipna caá. Páant ã niijátdih joinít, ñi naóh yapanaá. Pánih naóhna, ñi jenah joyátjĩhjeh ñi niijcán niít. ");
INSERT INTO cbv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Caán láa biíc ã ʉ́ʉddih, biíhboó ã ʉ́ʉd jeñédih mao yohat tʉ́ʉtna, ĩ wʉ̃hbipna caá. Ĩ íip ã wehdih, ĩ wehboó ĩ mánadihbʉt mao yohat tʉ́ʉtna, ĩ wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pánihna, wĩ́ihwã ñi jʉmat jíib nihat yeebdíh ĩ eníhcan niít. Páant yeejép ñi yapna yʉhna, weemdíh ñi cádahcah, péeni yeó jáapdih yeebdíh wã tʉ́i ʉbbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bita ĩ pãpnidih Diosdih weñat mʉʉ́ diítboó jwejnit, cã́acwã caánboodíh weñaat tʉ́ʉtna, caán mʉʉ́ ã tʉ́yatdih ĩ yéejanachah, ñi enbipna caá. Diosdihjeh cã́acwã ĩ ʉʉ́bát mʉʉ́ ã jʉmʉchah, caán pãpnidih caánboó jwejcat caá náahap. Dios naáwátdih naóh yapani Danielji, caandíh ãt naóh daacáp tajĩ.Caán ã daacátjidih ennit, ñi tʉ́i beh joyoó. Caanjĩ́h yeejép ĩ pãpni ã jʉmʉchah ennit, Judea baácboó jʉmnit, jeéboó ĩ jweí pʉ́ʉh laab béje naáh. ");
INSERT INTO cbv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Caán láa cã́acwã tʉbit yeejép ĩ yapachah, waícanjeh ĩ jweí ñáo pʉ́ʉh laab béje naáh. Ded mʉʉ́ chahmant bóo coahboó jʉmni dei bejnit, ã́ih bií déedih ʉbʉdih waadcánjeh, yoobópdih ã jwei béje naáh. ");
INSERT INTO cbv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wápchiboó jʉmni ã́ih yéguehnadih ʉbʉdih ã jwʉ́ʉb bejca bojo naáh. ");
INSERT INTO cbv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Caán láa wʉdʉ jʉmnit yaádh, ĩ wehdih tʉ́ʉhnitbʉt ĩ jweyéchah, queét yaádhdih chah ã bʉobipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nin pah Diosdih ñi niíj ʉʉ́bʉ́: ‘Mah noój láa ã jʉmʉchah, páant yeejép ã yapca bojo naáh’, caandíh ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Caán yeó jáapnadih cã́acwã tʉbit yeejép ĩ yapbipna caá. Nin baácdih Dios ã chãjat tʉ́ttimah, cã́acwã yeejép ĩ yapna yʉhna, péeni yeó jáapnadih chah yeejép pohba ĩ yapbipna caá. Páant yeejép ĩ yapat tʉ́ttimah, ĩ jwʉ́ʉb yeejép yapcan niít. ");
INSERT INTO cbv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tʉbit yeejép yapat pínah daocánni yeó jáapna Dios ã jwej jwʉhbipna caá, ã ñíonitboó ĩ jéih bʉʉjáát pínah niijná. Páant ã chãjcah nihna, ded ãta bʉʉjácan tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Caán láa det yeebdíh ‘Ñi eneé. Ninjĩh caá Cristo ã jʉmʉp’, ĩ niijíchah, ‘Conjĩh caá Cristo ã jʉmʉp’, bitabʉt ĩ niijíchah, ñi joyáh bojoó. ");
INSERT INTO cbv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Caán láa dawá yeenit ĩ jʉmbipna caá. ‘Weém Cristo caá’, niíj yeenit, ‘Weém Dios naáwátdih naóh yapani caá’, niíj yeenitbʉt ĩ jʉmbipna caá. Cã́acwã ĩ en wʉ́hi bejat pínah niijná, ʉ́ʉm náah jʉmnidih ĩ chãj jʉ́ʉtbipna caá. Páant ĩ chãjatdih ennit, Dios ã ñíonitboó ĩ yeeatdih joiná, Diosdih cádahnit, queétdihjeh ĩ péeat pínahdih ĩ náahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Páant ã yapat pínah jã́tih, yeebdíh wãát naóhna caá, caandíh ñi tʉ́i jéihyat pínah niijná. Páant wã naáwátjidih náhninit, yeebdíh yeenitdih joicát tʉ́ʉt niijná, ñi tʉ́i chãja chaáh”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Caán láa cã́acwã yeejép ĩ yapat tʉ́ttimah, yeó, widhbʉt ã tʉ́i yeh iigcán niít. ");
INSERT INTO cbv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pánih tʉ́ʉt nʉʉmná, jeá ã méménachah, cʉ́iwã ĩ yʉ́ʉg jéen bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Páant ã yapachah, weém nihat cã́acwã ʉ́ʉd jeñé, mah tólihjih wã dei jʉ̃óhbipna caá. Bʉ́dí wẽpatjĩh, tʉ́i yeh iigní wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, nihat cã́acwã weemdíh ĩ enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pánih dei jʉ̃óhna, wĩ́ih ángelwãdih nin baácboó wã wahbipna caá, nihat pebhboó wã ñíonitdih ĩ ʉb wáacat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Higuera nah ded pah ã jʉmatdih ñi jenah joyoó. Caan náh jáap wawá ã jʉmʉchah ennit, jópchi ã jʉ̃ʉ́wátdih ñi jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Páant ã jʉmat pah, nihat wã niijátji ã yapachah enna, wã jwʉ́ʉb dei jʉ̃ʉ́wát pínah bahni ã jʉdhdatdihbʉt ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yoobópdih yeebdíh wã naóhna caá. Caán láa moón ĩ wʉnat pínah jã́tih, wã niijátji pah biíc yoobó ã yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nin baác, jeábʉt ã bʉʉdʉ́chah yʉhna, wã naáwátboó ã bʉʉdcán niít. Nihat wã niijátji pahjeh wã péabipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Obohjeéhtih, wã jwʉ́ʉb dei jʉ̃óhni pínah yeó jáap, horadihbʉt nihat ĩ jéihcan caá. Cã́acwã, ángelwã, weem yʉ́h bʉca nihat jwĩ jéihcan caá. Wã íip Diosjeh caá caandíh ã jéihyep. ");
INSERT INTO cbv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Pánihna, yeebbʉ́t caán yeó jáapdih jéihcannit jʉmna, weemdíh tʉ́i pã́init jʉmat tʉ́ʉt niijná, jáanit pah Diosdih ñi tʉ́i ʉʉ́bʉ́. ");
INSERT INTO cbv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ded pah pã́init ñi jʉmat pínahdih nin naáwátjĩh wã bohébipna caá: Mʉʉ́ mínah yʉʉ́p ã jib bej jwʉhat pahjeh tigaá. Ã bejat pínah jã́tih, ã pebh moondíh ã́ih mʉʉdíh ã tʉ́i en dawát tʉ́ʉtʉp be. Biquínadih ã tewatdih ã jwejep be. Jẽcdih wapniboodíh ã jwʉ́ʉb jʉ̃ʉ́wát pínahdih ã tʉ́i páñat tʉ́ʉtʉp be. ");
INSERT INTO cbv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yeebbʉ́t ñi tʉ́i jenah joí páñaá. Mʉʉ́ mínah ã jwʉ́ʉb jʉ̃ʉ́wʉ́chah, queét ĩ jéihcat pah, weém ñi Maáh wã jwʉ́ʉb dei jʉ̃óhni pínah yeó jáapdih yeebbʉ́t ñi jéihcan caá. Cheyeh, chei tac yoób, mʉjbai eo láa, baabáchah caá wãta dei jʉyʉ́p tagaá. ");
INSERT INTO cbv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Páant wã jwʉ́ʉb dei jʉ̃ʉ́wát pínahdih jéihcan, wã wʉtatdih páantjeh ñi chãjaá. Pánih chãjnit, báadhdajeh wã jwʉ́ʉb dei jʉyʉ́chah, ʉ̃onit pah ñi jʉmcan niít. ");
INSERT INTO cbv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pánihna, yeebdíh wã niiját pah mʉntih, nihatdihbʉt naóhna caá wã chãjap: ¡Jáanit pah, tʉ́i teo pã́init ñi jʉmʉʉ́!” Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Oveja wʉ̃ʉ́hdih jwĩ jeémát yeó jáap, Pascua ĩ niijní, chéne yeó jáap jã́tih paacánni pandih jwĩ jeémát yeó jáapna ãt jʉmʉp wʉt jĩ. Sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt Jesúsdih mawíhna, caandíh ĩt tewat tʉ́ʉtíhip wʉt jĩ. Cã́acwã ĩ encah, caandíh ĩ tewat pínah niijná, nin pah ĩt míic niíj wéhenap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Pascua yeó jáapnadih, dawá cã́acwã ĩ jʉmʉchah, Jesúsdih jwĩ tewat tʉ́ʉtʉchah, nihat tʉbit ĩta íij tagaá. Pánih íijnit, jwiítdih ĩta míic mao tagaá. Pánihna, cã́acwã ĩ encah, jwĩ tewat tʉ́ʉtʉ́p, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Queét Jerusalén tʉ́tchiboó ĩ míic wéheat pónih, Jesúswã Betania tʉ́tchiboó bácah moópniji Simóníh mʉʉná jeémpna ĩt chãjap wʉt jĩ. Páant ĩ jeémát pónih, biíc yad wili tʉ́i chej jʉmni quiítdih mit ʉb waád jʉibínap wʉt jĩ. Caán alabastro jeejĩ́h ĩ chãjni quiít diítna nardo ĩ niijní chej jʉmni yíi ãt jʉmʉp wʉt jĩ. Caán yíi bʉ́dí jíib jʉmni ãt jʉmʉp wʉt jĩ. Pánihna, caán quiít yapatdih dajnit, Jesúíh wao dáhdih mit pʉhwʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Páant mi pʉhwʉchah ennit, biquína caánboó jʉmnit ĩt íijip wʉt jĩ. Pánih íijnit, nin pah ĩt niijíp wʉt jĩ: —¿Dépanih tigaá nint chej jʉmni yíi bʉ́dí jíib jʉmnidih páant mi pʉoh peét? ");
INSERT INTO cbv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Caandíh mi jíib chãj wʉ̃hna, ãta tʉ́i tagaá. Pánih jíib chãjna, biíc jópchi tewat jíib pah bóo mita jíib tewep tagaá. Caán jíibdih moh yéejnitdih mita jéih wʉ̃h tagaá, ĩt niijíp wʉt jĩ. Páant niijnít, queét caántdih ĩt jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Páant ĩ niíj jʉ̃ihñʉchah joinít, Jesús queétdih nin pah ãt niíj naáwáp wʉt jĩ: —Páant caántdih ñi niijcá bojoó. Weemdíh caánt mi tʉ́i chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Moh yéejnitboó ñijeéh páantjeh ĩ jʉmbipna caá. Débólih ñi teo wáaquíhna, queétdih ñi jéih teo wáacna caá. Obohjeéhtih, weémboó ñijeéh nin baácboó bahnibit wã jʉm jwʉhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nint mi bíbohat pah bóo weemdíh páant mi chãjna caá. Wʉnniíh bácahjidih jwĩpĩ́ pʉhwat pah, weemdíh chej jʉmni yíijĩh pʉohna, ĩ yohat pínahdih mi ámohna caá. ");
INSERT INTO cbv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yeebdíh yoobópdih wã naóhna caá. Nihat baácboó wĩ́ih tʉ́ini doonádih naóhna, nint bʉʉ mi chãjatjidihbʉt ĩ naóhbipna caá. Páant ĩ naáwáchah joinít, caántdih dawá ĩ náhnibipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Caán láa, Judas Iscariote, Jesús doce ã bohénitjeéh bóo, Jesúsdih eníhcannit sacerdotewã ĩ maátadih ã dʉó wáyat pínahdih naáwádih ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Caandíh joinít, maáta ĩt weñep wʉt jĩ. Pánih wẽinit, —Meemdíh dinero jwĩ wʉ̃hbipna caá, queét Judasdih ĩt niijíp wʉt jĩ. Pánihna, Jesúsdih eníhcannitdih dʉó wáyat tʉ́ʉt niijná, Judas ãt jenah joi bídip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Paacánni pandih jwĩ jeémát yeó jáapna jwíih waadní yeó jáap, oveja wehdih jwĩ mawat yeó jáap, Jesús ã bohénit caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Ded mʉʉdíh tigaá Pascua jeémátdih jwiítdih ma nʉmah jeémpbi? ¿Dedboo tígaá jeémát jwĩ chãjbi? Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Páant ĩ niijíchah, Jesús chénewã ã bohénitdih wahnit, nin pah ãt niijíp wʉt jĩ: —Jerusalén tʉ́tchina ñi bejeé. Caanná ñi jʉibínachah, wáam dahjĩh mah beoni yeebdíh ã jwãáhbipna caá. Caandíh péenit, ded mʉʉdíh ã waadáchah, yeebbʉ́t ñi pée waadá. ");
INSERT INTO cbv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Waadnít, caán mʉʉ́ mínahdih nin pah ñi niíj ʉʉ́bh joyoó: ‘ “¿Dedboo tígaá wã bohénit biícdih Pascua jeémátdih wã nʉmah jeémát pínah tólih ã jʉm?” Bohéni ã niijná be’, ñi niijí mʉʉ́ mínahdih. ");
INSERT INTO cbv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Páant ñi niijíchah joinít, nihat jwĩ náahat jʉm beední bʉ́dí chah bóo tólihdih ã jʉ́ʉtbipna caá. Caán tólihboó jwĩ jeémát pínahdih ñi chãjaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Páant ã niijíchah joinít, Jerusalén tʉ́tchina ĩt bejep wʉt jĩ. Caanná jʉibínit, nihat Jesús ã niijátji biíc yoobó ĩt jwãááp wʉt jĩ. Queétdih ã jʉ́ʉtni tólihdih waadnít, Pascua jeémát pínahdih ĩt chãjap wʉt jĩ. Nihat chãj péanit, Jesús ã páñapboó ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tõo ñáh jʉ̃ʉ́wʉ́chah, Jerusalén tʉ́tchina bejnit, Jesús doce ã bohénit biícdih caán chah bóo tólihna waád jʉibínit, Pascua jeémátdih queétdih ãt nʉmah jeémép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Páant ĩ jeémát pónih, Jesús queétdih nin pah ãt niijíp wʉt jĩ: —Yeebdíh yoobópdih wã naóhna caá. Weemdíh eníhcannitdih dʉó wáini pínah ñi cãtíh ã jʉmna caá. Caánboó wãjeéh jeémpni caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Páant ã niijíchah joinít, bʉ́dí náhni dahwanit, nihat biquínajeh nin pah Jesúsdih ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Weém nihcan niít? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Biíc ñijeéh jʉmni, pandih weém biícdih neéh jeémpni caá. ");
INSERT INTO cbv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Páant yeejép wã yapat pínahdih jon jã́tih Dios naáwátdih naóh yapani ãt daacáp tajĩ. Pánihna, weém, nihat cã́acwã ʉ́ʉd jeñé, caán ã daacátji pahjeh yeejép wã yapbipna caá. ¡Obohjeéhtih, weemdíh eníhcannitdih dʉó wáini yeejép pohba ã yapbipna caá! Caán ã cã́ac jʉmcah, chah ãta tʉ́i tagaá, Jesús queétdih ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, Jesúsdih eníhcannitdih dʉó wáini pínah ãt bac bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ã bac bejat tʉ́ttimah, queét páantjeh ĩ jeéméchah, Jesús pandih ʉbnit, “Nin jeémát ma wʉ̃hat tʉ́ina caá, Paá”, Diosdih niíj péanit, ã bohénitdih ãt daj wʉ̃hʉp wʉt jĩ. —¡Dáa, ñi jeémé! Nin pan wĩ́ih bácah panihni caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tʉ́ttimah, jiwá iguíh mac jʉmni babhbat dahdih ʉbnit, “Nin babhbat ma wʉ̃hatbʉt tʉ́ina caá, Paá”, niíj péanit, queétdih ãt wʉ̃hʉp wʉt jĩ. Páant ã wʉ̃hʉchah, queét nihat ĩt babhbap wʉt jĩ. Páant ĩ babhbachah, queétdih nin pah ãt jwʉ́ʉb niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Nin babhbat wĩ́ih meép panihni caá. Nin babhbatdih yeebdíh wã wʉ̃hat pah, wĩ́ih meépdih yohnit, wã wʉn wʉ̃hbipna caá, dawá cã́acwã Dios biícdih ĩ tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yeebdíh yoobópdih wã naóhna caá. Nin baácboó jʉm jwʉhna, jiwá iguíh macdih wã jwʉ́ʉb babhcan niít. Tʉ́ttimah, Dios maáh ã jʉmʉpboó wã jwʉ́ʉb babhbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pascua jeémátdih jeémp péanit, Diosdih ĩt wẽi ewep wʉt jĩ. Pánih eo péa, bac bejnit, Olivo jeená bejni namána ã bohénitdih Jesús ãt nʉmah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pánih bejna, Jesús queétdih nin pah ãt niíj naáwáp wʉt jĩ: —Yeéb nihat weemdíh ñi cádahbipna caá. Jon jã́tih Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘ “Ovejawãdih en daonídih wã maobipna caá. Páant wã mawachah, nihat ovejawã ĩ jweí peét bejbipna nacaá”, Dios ã niijná caá’, naóh yapani ãt niíj daacáp tajĩ.Pánihna, weemdíh ñi cádahat pínahdih wã jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Obohjeéhtih, weemdíh ĩ mao yohochah yʉhna, Dios weemdíh ã jwʉ́ʉb booaat tʉ́ttimah, Galilea baácna yeebdíh wã waóh bej pã́ibipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Páant ã niijíchah joinít, Pedro nin pah ãt niijíp wʉt yʉh jĩ: —Queét nihat ĩ cádahachah yʉhna, weémboó wã cádahcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Yoobópdih meemdíh wã naóhna caá. Bʉʉ cheijeh mʉjbai chéne ã ewat pínah jã́tih biíc peihcanni láa ‘¡Caandíh wã jéihcan caá!’ ma niíj yeebipna caá, Jesús Pedrodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Majeéh weemdíhbʉt ĩ mawachah nihna, weémboó ma niiját pah wã niijcán niít, Pedro Jesúsdih chah ãt jwʉ́ʉb niijíp wʉt yʉh jĩ. Queét nihatbʉt biíc yoobó ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tʉ́ttimah, Olivo jeená jʉibínit, Getsemaní ĩ niijní pácahi jʉmʉpna Jesúswã ĩt jʉibínap wʉt jĩ. —Diosdih wã ʉʉ́bát pónih, ninjĩh ñi chʉ́ʉd páñaá, Jesús ã bohénitdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Páant niíj péanit, yʉʉ́pbit bejnit, Pedro, Santiago, Juandihbʉt Jesús ãt nʉmah bejep wʉt jĩ. Pánih bejnit, cã́acwãdih ã wʉn wʉ̃hat pínahdih bʉ́dí jenah joinít, ãt jĩ́gah jwíihip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Tʉbit jĩ́gahnit, wʉnni pah caá wã jʉmʉp. Pánihna, yeebbʉ́t ʉ̃ocanjeh, ninjĩh ñi ʉʉ́bh páñaá, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Páant niíj péanit, chibít yʉʉ́pbit bej, baácboó páah yoh ñajnit, ");
INSERT INTO cbv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Paá, meém nihatdih jéih beedáni caá. Pánih jʉmna, ¡Weemdíh ma wʉnat tʉ́ʉtca bojoó! Obohjeéhtih, weém wã wʉníhcah yʉhna, meémboó páant ma náah yacachah, wã wʉn wʉ̃hbipna caá”, Jesús Diosdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Páant niíj ʉʉ́bh péanit, biíc peihcannit ã bohénit ĩ páñapboó Jesús ãt jwʉ́ʉb bejep wʉt jĩ. Páant ã jwʉ́ʉb jʉibí enechah, ʉ̃ona ĩt chãjap wʉt jĩ. —¿Ma ʉ̃o niít, Simón? ¿Biíc horabitjeh ʉ̃ocanjeh, ma noón pã́icannit beé? ");
INSERT INTO cbv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tʉ́i jáanit, yeebdíh Diosdih ʉʉ́bát caá náahap, yéej chãjat jenah joyátdih yap yohat tʉ́ʉt niijná. Tʉ́i chãjíhna yʉhna, jáacan, ʉʉ́bhcan, páant ñi jéih bʉʉjácan niít, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Páant queétdih niíj péa, jwʉ́ʉb bejnit, ã jwíih ʉʉ́bátji pahjeh mʉntih biíc yoobó ãt jwʉ́ʉb ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pánih ʉʉ́bh péa, biíc peihcannit pã́init pebhboó ã jwʉ́ʉb jʉibínachah, jwʉ́ʉb ʉ̃ona ĩt chãjap wʉt jĩ. Tʉbit quíib chei jʉmʉchah, ĩt jwʉ́ʉb ʉ̃wʉp wʉt jĩ. Jesús queétdih ã wʉcʉchah, tíicna, caandíh ĩt jéih jepahcap wʉt jĩ. Tʉ́ttimah, jwʉ́ʉb ʉʉ́bʉ́dih bejniji, pã́init pebhboó Jesús ãt jwʉ́ʉb jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Biíc peihcanni láa ʉʉ́bhnit, pã́init pebhboó ãt jwʉ́ʉb jʉibínap wʉt jĩ. —¿Yeéb páantjeh ʉ̃onit, choó niít ñi chãjap? ¡Páant bóojeh tigaá! Bʉtéh yéejnit weemdíh tewedih jʉiná caá ĩ chãjap. ");
INSERT INTO cbv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ñi jáa bojoó. Chóbe. Weemdíh eníhcannitdih dʉó wáini ã jʉiná caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Páant Jesús ã niijíchahjeh, ã bohéniji Judas ãt jʉibínap wʉt jĩ. Judasjeéh dawá ĩt jʉibínap wʉt jĩ. Íibat naaná, máa quiítnadihbʉt ĩt bíbohop wʉt jĩ. Sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, jwiít judíowãdih waóhnitbʉt queétdih ĩt wahap wʉt jĩ, Jesúsdih teonit, ĩ pebhna ĩ ʉb bejat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesús pebh ĩ bejat pínah jã́tih, Judas ãjeéh bejnit pínahdih nin pah ãtát niíj jéihya naáwáp wʉt jĩ: “Pʉ́o tíibdih nomnit, wã ʉʉ́bhnidih ñi teweép. Teonit, ñi cãtíh ñi ʉb bejeé, ã jweicát pínah niijná”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pánihna, Jesúswã pebhna jʉibínit, Judas Jesús pebh ãt jʉibínap wʉt jĩ. —¿Ma jʉm, Bohéní? niíj ʉʉ́bhnit, Jesúíh pʉ́o tíibdih ãt nomop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Páant Judas ã ʉʉ́bʉ́chah ennit, Jesúsdih tewedih jʉ̃óhnit caandíh ĩt tewep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Obohjeéhtih, pebhbit ñʉhni Jesús ã bohéniboó íibat naadíh jwã́at wái ʉbnit, sacerdotewã ĩ maáhdih teo wʉ̃hniíh moli chóodih ãt dʉ́ʉc bóod yohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Caandíh tewedih jʉibínitdih nin pah Jesús ãt niijíp wʉt jĩ: —¿Nʉʉmnídih tewat pah íibat naaná, máa quiítnadihbʉt ʉbnit, weemdíh tewedih ñi jʉ̃óhnit beé? ");
INSERT INTO cbv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yeó jáap jʉmat pah Dioíh mʉʉ́boó ñijeéh wã jʉmʉchah yʉhna, weemdíh ñi teocap be.Obohjeéhtih, Dios naáwátdih naóh yapani ã daacátji pahjeh bʉʉ weemdíh ã yapa naáh, ãt niijíp wʉt jĩ. Pánihna, Jesúsdih teonit, ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Páant ĩ teo bejechah enna, nihat ã bohénit caandíh ĩt éemp jwei béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Obohjeéhtih, weémboó jáap behni, ʉ̃oniji wĩ́ih ñajapdih bóo chóojĩhjeh míic bainit, Jesúswã ĩ bejat tʉ́ttimah wã ñʉʉ́n péenap jĩ. Páant wã ñʉʉ́n péenachah ennit, Jesúsdih teonitboó weemdíhbʉt ĩ tewep yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Obohjeéhtih, páant ĩ tewechah yʉhna, caán chóodih cádah yoh bojnit, yégueh wihcannijeh wã ñáo jwei béjep jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pánih Jesúsdih ʉb bejnit, sacerdotewã ĩ maáíh mʉʉná ĩt ʉb waad béjep wʉt jĩ. Ã́ih mʉʉ́boó jʉmni míic wáacat tólihboó caanjéh, bita sacerdotewã ĩ maáta, jwiít judíowãdih waóhnit, Moisés ã wʉtatjidih bohénitbʉt jʉibínit, Jesúsdih naóh yacat tʉ́ʉt niijná, queét nihat ĩt míic wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Obohjeéhtih, Pedroboó Jesúsdih yʉʉ́pjeh ãt ñʉʉ́n péenap wʉt jĩ. Pánih ñʉʉ́n péenit, sacerdotewã ĩ maáíh mʉʉ́ wáihyat jʉ́dʉboojéh ãt waád jʉibínap wʉt jĩ. Pánih waád jʉibínit, Pedro tʉʉ cʉ́ʉt jwẽ́ejdih, mʉʉdíh wapnit biícdih, ãt mée chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sacerdotewã ĩ maáta, nihat bita maáta biícdih wáac jʉibínit, “Jesús yeejép chãjna beé”, niijnítdih bidna ĩt chãjap wʉt jĩ. Jesúsdih peéh mawíhna, chénewã biíc yoobó naóhnitdih bidna ĩtih chãjap wʉt yʉh jĩ. Obohjeéhtih, ĩt bid jʉicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dawá nih yáanit, mácah míic ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Biquína ñah ñʉhnit, nin pah ĩt niíj yee naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nin pah ã niijíchah, jwĩ joyóp be: ‘Nin Dioíh mʉʉ́ cã́acwã ĩ chãjnijidih wã yéeja beedábipna caá. Biíc peihcanni yeó jáap tʉ́ttimah jáap mʉʉ́, cã́acwã ĩ chãjca naáh mʉʉdíh wã chãjbipna caá’, ã niijíp be, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Obohjeéhtih, páant niijná yʉhna, mácah míic ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sacerdotewã ĩ maáh cã́acwã cãtíh ñah ñʉhnit, —¿Dépanih tigaá queétdih ma jéih jepahcan? ¿Dedé tibeé ma yéej chãj, meemdíh páant ĩ niíj naóh yacachah? Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Obohjeéhtih, Jesúsboó ãt jepah jwʉhcap wʉt jĩ. Páant ã jepahcatdih enna, sacerdotewã ĩ maáh —¿Meém Dios ã wahni niít? ¿Dios, jwĩ wẽini, ã wʉ̃ʉ́h niít? Jesúsdih ãt jwʉ́ʉb niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Páant ma niiját yoobópdih tigaá. Weém nihat cã́acwã ʉ́ʉd jeñé Chah Wẽpni ã jéihyepmant bóo bʉwámant chʉ́ʉdnit, wã wʉtʉchah, ñi enbipna caá. Mah tólihnajih wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chahbʉt ñi enbipna caá, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Páant ã niijíchah joinít, sacerdotewã ĩ maáh bʉ́dí ãt íijip wʉt jĩ. Ã íijat jʉ́ʉtna, ã́ih jih bóo yégueh chóodih ãt yeo wáyap wʉt jĩ. Pánih yeo wáinit, —¿Dépanih tigaá bita naóhnit pínah jwĩta bid? ");
INSERT INTO cbv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","‘Weém caá Dios wʉ̃ʉ́h’, Jesúsjeh ã niijíchah, yeéb nihat ñi joiná be. ¿Yeébboó ded pah tigaá caandíh ñi niíj jenah joí? ãjeéh jʉmnitdih ãt niijíp wʉt jĩ. —Caandíh peéh mao yohat caá náahap, queét nihat ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Páant niijnít, biquína Jesúsdih ĩt coí jã́ha jwíihip wʉt jĩ. Coí jã́hanit, quíib nem chéo póocnit, —Dios wʉ̃ʉ́h jʉmna, ma naáwá ¿déhe tibeé meemdíh mao? ĩt niíj deoh naáwáp wʉt jĩ. Tʉ́ttimah, Dioíh mʉʉdíh wapnit soldadowãdih ĩ wʉ̃hʉchah, queétbʉt Jesúsdih ĩt pʉñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Páant ĩ chãjat pónih, wáihyat jʉ́dʉ diítna Pedro ã mée chʉ́ʉdʉchah, sacerdotewã ĩ maáhdih teo wʉ̃hnih mit jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jʉibínit, Pedro tʉʉ cʉ́ʉtdih ã mée chʉ́ʉdʉchah ennit, —¿Meembʉ́t Jesús Nazaret tʉ́tchimant bóojeéh péeni nihcan niít? mit niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Ĩjeéh péeni nihcan caá. Caán ma niijní Jesúsdih wã jéihcan caá. ¿Ded pah niij tígaá ma chãj? Pedro ãt niíj yee jepahap wʉt jĩ. Páant niijnítjeh, tʉʉ cʉ́ʉt jwẽ́ejdih chʉ́ʉdniji bejnit, jẽcna ãt jwei béj ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Páant caánboó ã ñʉhʉchah, teo wʉ̃hnih Pedrodih mit jwʉ́ʉb enep wʉt jĩ. Pánih ennit, mi pebh en ñʉhnitdih nin pah mit jwʉ́ʉb niijíp wʉt jĩ: —Nin newé Jesúsjeéh péeni caá, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Nihcan caá. Weém ãjeéh péeni nihcan caá, Pedro ãt jwʉ́ʉb niíj yeenap wʉt jĩ. Tʉ́ttimah, bita caanjĩ́h en ñʉhnit jwʉh —Ãjeéh péeni caá meém. Caandíh péenit Galilea baácdih moón míicjeh caá. Meembʉ́t Galilea baácdih bóo ma jʉmna caá. Pánihna, meembʉ́t ãjeéh péeni nacaá, Pedrodih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—Weém yeeni nihcan caá. Tʉ́i yoobópdih yeebdíh wã naóhna caá. ¡Ñi niijní newédih wã jéihcan caá! ¡Páant yoobópdih wã naóhcah, Dios weemdíh ã peéh chãja naáh! Pedro ãt jwʉ́ʉb niíj yeenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Páant ã niijátjeéhjeh, mʉjbai ãt jwʉ́ʉb ewep wʉt jĩ. Páant ã jwʉ́ʉb ewechah joinít, “Mʉjbai chéneji ã ewat pínah jã́tih ‘Caandíh wã jéihcan caá’, meém biíc peihcanni láa ma niijbípna caá”, Jesús ã niijátjidih Pedro ãt náhninap wʉt jĩ. Pánih náhninit, Pedro bʉ́dí ãt jʉñʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Baáb jéenechah, sacerdotewã ĩ maáta, jwiít judíowã jwĩ maáta, Moisés ã wʉtatjidih bohénit, bita maátabʉt ĩt míic wáac jʉibínap wʉt jĩ. Pánih míic wáac jʉibínit, Jesúsdih ded pah ĩ chãjat pínahdih ĩt míic wéhenap wʉt jĩ. Pánih míic wéhe péanit, Jesúsdih ĩt chéwat tʉ́ʉtʉp wʉt jĩ. Ĩ chéo péaat tʉ́ttimah, maáh Pilato pebhboó ĩt ʉb bejat tʉ́ʉtʉp wʉt jĩ. Pilato, Roma baácdih bóo, Judea baácdih moondíh wʉtni ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Páant ĩ ʉb jʉibínachah ennit, Pilato Jesúsdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Meém yoobópdih judíowã ĩ maáh niít? ãt niijíp wʉt jĩ. —Ma niiját pah tigaá, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pánihna, sacerdotewã ĩ maáta Pilatodih yeenit, Jesúsdih yeejép ĩt naóh yacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Páant ĩ naóh yacachah joinít, nin pah Pilato Jesúsdih ãt niijíp wʉt jĩ: —¿Páant meemdíh ĩ naóh yacachah joiná yʉhna, ma jéih jepahcan niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Obohjeéhtih, Jesús ãt jwʉ́ʉb jepahcap wʉt jĩ. Páant ã jepahcatdih ennit, Pilato bʉ́dí ãt wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Caán láa, Romanowã queét judíowãdih ĩ maáh jʉmatdih íijnit, biquína judíowã Romanowãdih ĩt míic mawap wʉt jĩ. Pánih míic maona, cã́acwãdih ĩt mao yohop wʉt jĩ. Páant ĩ mawachah, ĩ teonitji nemat mʉʉ́boó dawá ĩt jʉmʉp wʉt jĩ. Barrabás wʉ̃t jʉmnibʉt ĩjeéh nemat mʉʉ́boó ãt jʉmʉp wʉt jĩ. Pascua jʉmat pah Pilato biíc cã́ac nemat mʉʉ́boó jʉmni, cã́acwã ĩ bacaat tʉ́ʉtnidih ãpĩ́ bacanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pánihna, cã́acwã Pilato pebh jʉibínit, biíc nemnidih ã bacaat pínahdih ĩt ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Páant ĩ ʉʉ́bʉ́chah joinít, Pilato queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Yeéb judíowã ñi maáhdih wã baca wʉ̃h jĩíh? ¿Caandíh niít ñi náahap? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Dawá cã́acwã Jesúsdih ĩ weñechah, sacerdotewã ĩ maátaboó caandíh tʉbit íijna, ĩt mawat tʉ́ʉtʉp wʉt jĩ. Pánihna, queét Jesúsdih ĩ íijatdih jéihnit, cã́acwã ĩ weñatdihbʉt jéihnit, Pilato queétdih páant ãt ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Obohjeéhtih, cã́acwã Jesúsdih ĩ náahachah yʉhna, sacerdotewã ĩ maátaboó queétdih jac wʉtnit, Barrabásboodíh ã bacaat pínahdih ĩt jepahat tʉ́ʉtʉp wʉt jĩ. Páant ĩ jac wʉtʉchah joinítji, —¡Barrabásdih caá jwĩ náahap! ¡Caandíh jwiítdih ma baca wʉ̃hʉʉ́! Pilatodih cã́acwã ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—¿Yeéb judíowã ‘jwĩ maáh’, ñi niijnídih dedé tigaá wã chãjbi? Pilato ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—¡Caandíh cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! ĩt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Dépanihna? ¿Dedé tigaá ã yéejatji, páant ñi niijíchah? Pilato ãt niíj ʉʉ́bh joyóp wʉt jĩ. Obohjeéhtih, queét chah ĩt jwʉ́ʉb niíj ñaacáp wʉt jĩ. —¡Caandíh cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pánihna, cã́acwã caandíh ĩ íijcat pínah niijná, Pilato Barrabásdih queétdih ãt baca wʉ̃hʉp wʉt jĩ. Pánih bacanit, soldadowãdih momo jiwi chóo coóh jʉmni tõpnajĩh Jesúsboodíh ãt pʉñat tʉ́ʉtʉp wʉt jĩ. Pánih pʉñat tʉ́ʉtnit, Pilato caandíh ãt ʉb bejat tʉ́ʉtʉp wʉt jĩ, cruzboó péoh dodhnit, ĩ mao yohat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Páant ã ʉb bejat tʉ́ʉtʉchah joinít, Pilatoíh mʉʉ́ diítna Jesúsdih ĩt ʉb waad béjep wʉt jĩ. Pánih ʉb waad béjnit, caanjĩ́h wapnit soldadowã ĩt míic wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pánih míic wáacnit, Jesúíh yégueh jih bóo chóodih tóo dʉgnit, maáh ã dʉwát pah jígohni dʉʉni chóodih caandíh ĩt yacap wʉt jĩ. Maáh ã dʉwát jʉ́dʉ pah chãjnit, óot pihdih péeb wao péanit, Jesúíh wao dáhdih ĩt yacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Maáhdih ĩpĩ́ chãjat pah Jesúsdih nin pah ĩt niíj deoh naáwáp wʉt jĩ: —¡Ma tʉ́i jʉmʉʉ́! ¡Meém caá judíowã ĩ maáh! ĩt niíj deoh naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pánih deoh naóhnit, máa doóbhjĩh ã́ih wao dáhdih maonit, ĩt coí jã́hanap wʉt jĩ. Pánih mao coí jã́hanit, maáhdih weñat pah Jesús pebh ĩt bódicha caj yoh ñajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Páant niíj deoh naóh péanit, dʉʉni chóodih tóo dʉgnit, ã́ih yégueh chóodihjeh ĩt jwʉ́ʉb yacap wʉt jĩ. Pánih yacnit, ĩt ʉb bac bejep wʉt jĩ, cruzboó péoh dodhnit, ĩ mao yohat tʉ́ʉt niijná. Pánih ʉb bejna, ã́ih cruzdih bewat tʉ́ʉtnit, ĩ mao yohat pínah jeéboó caandíh ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ĩ mao yohat pínah jeéboó bejnit, Simón, Cirene baácdih bóodih ĩt jwãááp wʉt jĩ. Simón Jerusalén tʉ́tchiboó jʉibína ãt chãjap wʉt jĩ. Caán Simón ã wehboó jwĩjeéh jʉmnit Alejandro, Rufojĩh ĩ jʉmna caá. Pánihna, queét ĩ íip Simóndih jwãáhnit, soldadowã caandíh Jesúíh cruzdih ĩt bewat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pánih bejnit, Gólgota wʉ̃t jʉmʉpna ĩt jʉibínap wʉt jĩ. “Gólgota” niijná, “Waó Iidíp jeé”, niijná ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pánih caanná jʉibínit, mirra wʉ̃t jʉmni macjĩh widnit, ĩ ʉb bejni jiwá iguíh macdih Jesúsdih ĩt tóihyop wʉt yʉh jĩ. Obohjeéhtih, caan mácdih Jesús ãt babhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tʉ́ttimah, cruzboó Jesúsdih ĩt péoh dodhdop wʉt jĩ. Pánih péoh dodh péanit, ã́ih yégueh chóojidih “¿Deíh tigaá ã jʉmbi?” míic niijnít, tíhwat jʉ́dʉnabitjĩh soldadowã ĩt yoh tíhwip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cheibitjeh nueve yeó ã jʉmʉchah, Jesúsdih cruzboó ĩt péoh dodhdop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ã yéejatdih naóhna, cruzboó ã́ih wao cháh, nin pah ĩt niíj daác bʉ́ʉdhdʉp wʉt jĩ. “Judíowã ĩ maáh”, caán naadíh ĩt niíj daacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chénewã nʉʉmnítdihbʉt biíh cruznadih Jesús pebh ĩt péoh dodhdop wʉt jĩ. Biícdih ã jéihyepmant bóo bʉwámant, biíhdih ã wáyámant bóo bʉwámant péoh dodhnit, queét tac yoób Jesúsdih ĩt péoh dodhdop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jon jã́tih Dios naáwátdih naóh yapani ã daacátji biíc yoobó Jesús ãt yapap wʉt jĩ: “ ‘Wʉtatdih yap yohnitjeéh jʉmni caá’, cã́acwã caandíh ĩ niíj jenah joibípna caá”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cruz pebh en yap bejnit Jesúsdih nin pah yeejép ĩt niíj deoh naáwáp wʉt jĩ: —¡Eneéh bʉca! ¿Dioíh mʉʉdíh yohnit, biíc peihcanni yeó jáap tʉ́ttimah, meém caán mʉʉdíh jwʉ́ʉb chãjni pínah niít? ");
INSERT INTO cbv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pánihni jʉmna, ¡caán ĩ péoh dodhdopmant meemjéh ma dei jʉ̃ʉ́wʉ́! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Páant ĩ niiját pah sacerdotewã ĩ maáta, Dios ã wʉtatdih bohénitbʉt biíc yoobó caandíh nin pah ĩt niíj deoh naáwáp wʉt jĩ: —Caán bitadih tʉ́i teo wáacni jʉmna yʉhna, caanjéh ã jéih míic teo wáaccan caá. ");
INSERT INTO cbv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","‘Judíowã ĩ maáh caá’, niijná, cruzmant ã dei jʉ̃ʉ́wʉ́chah enna, caandíh jwĩ jepahbipna caá, ĩt niijíp wʉt jĩ. Ãjeéh ĩ péoh dodhnitbʉt yeejép ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesús cruzboó ĩ péoh dodhni ã ñʉhʉchah, yeó jáap tac yoób ã dʉpʉ́áh bejep jĩ. Nihat baácboó dʉpʉ́ bejnit, biíc peihcanni horas tʉ́ttimah, ã jwʉ́ʉb baáb jwʉ́ʉb bejep jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Páant ã jwʉ́ʉb baabát pínah jã́tihbit, Jesús nin pah ãt niíj wẽp ñaacáp wʉt jĩ: “Eloí, Eloí, ¿lemá sabactani?” niijná, “¿Wĩ́ih Dios, wĩ́ih Dios, dépanih tigaá weemdíh ma éemp bej?” Jesús ãt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Páant ã niijíchah joinít, biquína caanjĩ́h ñʉhnit, —Dios naáwátdih naóh yapani Elíasjidih bidna caá ã chãjap, ĩt míic niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Biíc ĩjeéh jʉmniboó ñáo ñah bejnit, páab chʉí déedih ʉbnit, bijni jiwá iguíh macdih báah, máa doóbh yapatdih chéo bʉ́ʉdh, jʉ́ʉt ñahanit, Jesúsdih ãt wái nomat tʉ́ʉtʉp wʉt yʉh jĩ. Pánih wái nomat tʉ́ʉtnit, caanjéh nin pah ãt míic niijíp wʉt jĩ: —¡Ã jʉmʉ naáh! Elíasji nindih teo wáacadih ã jʉ̃ʉ́wʉ́chah, jwĩ en jwʉh jĩíh, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Páant ã niiját tʉ́ttimah, tʉbit ñaácnit, Jesús ãt wʉnah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Páant ã wʉnʉchahjeh, Dioíh mʉʉ́ diítboó ĩ jãh yaíhni bʉ́dí wʉ́ʉpni chóo yeo dei bejnit, chéne chóo pah ãt chãwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Caán ã wʉnʉchah ennit, Jesús pebh ñʉhni soldadowã ĩ maáh nin pah ãt niijíp wʉt jĩ: —Yoobópdih nin Dios wʉ̃ʉ́h ta tigaá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Chibít yʉʉ́pbit biquína yaádh Jesúsdih ĩt en ñʉhʉp wʉt jĩ. Queét yaádhjeéh Mágdala tʉ́tchidih bóli María mit jʉmʉp wʉt jĩ. Biíh wili Maríabʉt mit jʉmʉp wʉt jĩ. Caánt José, ã ʉ́ʉd Santiago ĩ íin mit jʉmʉp wʉt jĩ. Biíh wili Salomébʉt mit jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galilea baácboó ã jʉm jwʉhʉchah, queét yaádh caandíh teo wáacnit ĩt jʉmʉp wʉt jĩ. Pánihna, Jerusalén tʉ́tchina Jesús ã bejechah, queét yaádh dawá bita yaádhbʉt ãjeéh ĩt péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jwĩ chooát yeó jáap jã́tih bóo, jwĩ chooát pínahdih jwĩ ámohni yeó jáapdih, Jesús ãt wʉnʉp wʉt jĩ. Caan chéyeh tõo ñáh jʉ̃ʉ́wát pínah jã́tih, José, Arimatea tʉ́tchidih bóo, Jesúíh bácahjidih Pilatodih ʉʉ́bʉ́dih ãt bejep wʉt jĩ. Caán José jwiít judíowã jwĩ maátajeéh ã jʉmʉchah, caandíh bita maáta ĩpĩ́ tʉ́i joyóp wʉt jĩ. Dios ã maáh jʉmat pínahdih tʉ́i pã́ini ãt jʉmʉp wʉt jĩ. Caán ʉ́ʉmcanjeh, Pilatodih Jesúíh bácahjidih ʉʉ́bʉ́dih ãt bejep wʉt jĩ, jwĩ chooát yeó jáap ã waadáchah, ã́ih bácahji páantjeh cruzboó ã ñʉhcat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesús jã́tih ã wʉnat doonádih joinít, Pilato ãt joí wʉ́hi bejep wʉt jĩ. Pánih joí wʉ́hi bejnit, soldadowã ĩ maáhdih ãt bid bojop wʉt jĩ. Ã pebh ã jʉibínachah, nin pah caandíh ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Jesús wãát wʉnah bejnit beé? ãt niijíp wʉt jĩ. —Wãát wʉnah bejna beé, soldadowã ĩ maáh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Páant ã niíj jepahachah joinít, Pilato ã́ih soldadowãdih Jesúíh bácahjidih ʉb deyanit, Josédih ãt wʉ̃hat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Páant ã niiját joinít, tʉ́i baabní yégueh chóodih jíib chãj, cruzna jʉmʉpboó jwʉ́ʉb bejnit, Josédih Jesúíh bácahjidih ĩ ʉb deya wʉ̃hʉchah, ãt ʉbʉp wʉt jĩ. Pánih ʉbnit, caán yéguehjĩh pin péanit, jeedíh ĩ baadníji íitboó caandíh ãt yohop wʉt jĩ. Yohnit, bʉ́dí jeé jʉ́dʉdih tóo pʉ̃tʉ́ bejnit, caán íitdih ãt nemep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Páant ã yohochah, Mágdala tʉ́tchimant bóli María, biíh wili Maríabʉt ĩt enep wʉt jĩ. Caánt María biíh José íin mit jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jwiít judíowã jwĩ chooát yeó jáap ã yapachah, tõo ñáh jʉ̃ʉ́wʉ́chah, biíc peihcannit yaádh chej jʉmnidih jíib chãjadih ĩt bejep wʉt jĩ, Jesúíh bácahjidih ĩ ñáñat pínah niijná. Mágdala tʉ́tchimant bóli María, biíh wili María Santiago íin, Saloméjĩh, queét biíc peihcannit yaádh jíib chãjadih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tʉ́ttimah bóo yeó jáap baáb jéenechah, chej jʉmnidih ʉbnit, queét yaádh Jesúíh bácahdih yohopji jeé íitboó ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—¿Déhe tigaá jwiítdih jeé jʉ́dʉdih ĩ pʉ̃tʉ́ yoh wʉ̃hbi? queétjeh ĩt niíj míic wéhe bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pánih jʉibína, José ã nemniji jeé jʉ́dʉ caán íit jwẽ́ejdih ã ñʉhʉchah ĩt enep wʉt jĩ. Caán bʉ́dí jʉ́dʉ ã jʉmʉchah, cã́acwã ĩ tóo pʉ̃tʉ́ dodhdat pah ãt lajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pánihna, caán íitdih waád jʉibínit, jáap behni pah jígohni ángeldih ĩt enep wʉt jĩ. Caán ángel tʉ́i baabní yégueh chóo dʉonít, ĩ jéihyepmant bóo bʉwámant ãt chʉ́ʉdʉp wʉt jĩ. Caandíh ennit, bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Páant ĩ ʉ́ʉmʉchah ennit, caán ángel queét yaádhdih nin pah ãt niijíp wʉt jĩ: —¡Ñi ʉ́ʉmca bojoó! ¿Yeéb Jesús, Nazaret tʉ́tchidih bóo cruzboó ñʉhnit, wʉnnijidih bid niít ñi chãjap? Obohjeéhtih, ninjĩh ã wihcan caá. Jáantjeh ã boo pʉd jʉ̃ʉ́wʉ́p be. Caandíh ĩ cáagatjidih ñi eneé. ");
INSERT INTO cbv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ʉ́ʉmcanjeh, ã bohénitdih naáwádih ñi bejeé. Pedrodihbʉt ñi tʉ́i naáwá chaáh. ‘Jáantjeh ã naáwátji biíc yoobó Jesús yeebdíh Galilea baácna ã waóh bej pã́ina caá. Caánboó caandíh ñi jwãáhbipna caá’, ã bohénitdih ñi niijí, ángel ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Páant ã niijíchah joinít, bac bejnit, yohopji jeé íitmant ĩt ñáo jwʉ́ʉb bejep wʉt jĩ. Ñáo jwʉ́ʉb bejnit, ʉ́ʉmna, méménit, bitadih ĩt naóhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chooát yeó jáap tʉ́ttimah, Jesús boo pʉd jʉ̃óhniji Mágdala tʉ́tchidih bóli Maríadih ãt jwíih jígohop wʉt jĩ. Caánt siete nemépwã jʉmnihjidih Jesús ã booanih mit jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús ã bohénitji caandíh ĩ jʉñʉ́chah, Maríaboó caandíh mi enatjidih queétdih naáwádih mit jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Cristo ãt jwʉ́ʉb boo pʉd jʉ̃óh tabeé. Caandíh weém wã enna be”, queétdih mitih niijíp wʉt yʉh jĩ. Obohjeéhtih, páant mi niijíchah yʉhna, ĩt joyáh bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tʉ́ttimah, chénewã Jesúswãjeéh jibnitji mʉʉ́ wihcapboó ĩ jib bejechah, Jesús queétdih ãt jígohop wʉt yʉh jĩ. Obohjeéhtih, mácah ã jígohochah, jwíih beh encan yʉhna, tʉ́ttimah, caandíh ĩt beh enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pánih beh ennitji jwʉ́ʉb bejnit, ĩ chéenwãdih Jesúsdih ĩ enatjidih ĩt naáwáp wʉt yʉh jĩ. Obohjeéhtih, páant ĩ naáwáchah yʉhna, queétdihbʉt ĩt joyáh bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tʉ́ttimah, once ã bohénitji ĩ jeéméchah, queétdih Jesús ãt jígohop wʉt jĩ. Caán ã naáwátjidih tʉ́i jenah joicán, jwʉ́ʉb booni bitadih ã jígohatdih ĩ naáwáchah yʉhna, ĩ joyáh bojatji jíib queétdih ãt jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pánih jʉ̃ih péanit, queétdih nin pah ãt niijíp wʉt jĩ: “Nihat baácboó wĩ́ih tʉ́ini doonádih nihat cã́acwãdih naáwádih ñi bejeé. ");
INSERT INTO cbv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Weemdíh jepahnit, daabáát tʉ́ʉtnit, iiguípna ĩ bejat déejidih Dios ĩ yéejatdih ã yoh wʉ̃hbipna caá. Obohjeéhtih, weemdíh jepahcannitdih Dios ã peéh chãjachah, iiguípna ĩ bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Det weemdíh jepahnitboó wã wẽpatjĩh nin pah ĩ chãjbipna caá: Nemépwã cã́acwãíh bácahmant jʉmnitdih ĩ bacat tʉ́ʉtbipna caá. Mácah wéheatjĩh ĩ wéhebipna caá. ");
INSERT INTO cbv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Maidih ĩ tewechah, ĩ chãacáchah yʉhna, dedé ebépdih ĩ babhbachah yʉhna, queétdih ã chʉ̃ʉ́hcan niít. Wʉnnitdih ĩ teo jã́ha ʉʉ́bʉ́chah, ĩ tʉ́i boobipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Páant niíj naóh péanit, jwĩ Maáh Jesús jeáboó ãt pʉ́ʉh laab béjep wʉt jĩ. Pánih pʉ́ʉh laáb jʉibínit, maáh waadná, Dios ã jéihyepmant bóo bʉwámant ãt chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pánihna, Dios cã́acwãdih ã tʉ́i ʉbat pínah doonádih Jesús ã bohénitji nihat pebhboó naáwádih ĩt bejep wʉt jĩ. Pánih naóhnit, jwĩ Maáh queétdih ã teo wáacachah, ã wẽpatjĩh cã́acwã ĩ jéih chãjca naáhdih ĩt chãj jʉ́ʉtʉp wʉt jĩ. Páant ĩ chãj jʉ́ʉtʉchah, ã naáwátdih joinítboó, “Ĩ naáwát yoobópdih caá ã jʉmʉp”, niijnít, Diosdih ĩt tʉ́i jepahap wʉt jĩ. Páant bóojeh tigaá weém Marcos wã daacát.");
INSERT INTO cbv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wã dée Teófilo, weém Lucas meemdíh bainí wã naóh daácbipna caá. Jwĩ cãtíh Jesús ã chãjatjidih dawá cã́acwã ĩt daác jwíihip tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesús ã cã́ac jʉmni yeó jáapdih pʉ́ʉ́ ã péani yeó jáapna ãjeéh jʉmnitji, ded pah ã chãjatdih ennitji, ã naáwátdihbʉt joinítji, jwiítdih ĩ bohénap jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Páant ĩ bohéátdih joiníji weembʉ́t bʉʉ wã jéihyep bʉca. Pánih jéihnit, “Nin pah Teófilodih wã daác wʉ̃hʉchah, ã tʉ́ibipna caá”, wã niíj jenah joyóp be. ");
INSERT INTO cbv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Páant niíj jenah joinít, meemdíh wã daác wahna caá, ma joiníji doonádih tʉ́i yoobópdih ma jéihyat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jesucristo ã cã́ac jʉmat pínah jã́tih, Herodes Judea baácdih moón ĩ maáh jʉm láa, Zacarías wʉ̃t jʉmni sacerdote ãt jʉmʉp wʉt jĩ. Caán Abías wʉ̃t jʉmni sacerdotewã poómpdih bóo wʉt jĩ. Yad Elisabetbʉt Aarón jʉima mit jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Queét chénewã Dios ã enechah, nihat ã wʉtatjidih tʉ́i jepahnit ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Obohjeéhtih, Elisabet weh wihcannih wʉt jĩ. Pánihna, queét chénat pah behnitjeh jʉmna, weh wihcannitjeh máahna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Biíc semana Zacarías jʉmni sacerdotewã poómp Dioíh mʉʉdíh ñahwat en daonít pínah ĩt tʉ́ʉt nʉʉmʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Biíc yeó jáapdih sacerdotewã ĩpĩ́ chãjat pah, Zacaríasdih ĩt ñíwip wʉt jĩ, Dioíh mʉʉdíh waadnít, chej jʉmnidih ã cáwat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chej jʉmnidih ĩ cáwat horadih waad béjnit, ã cáwachah, tã́ahmant bóo tólihdih dawá cã́acwã Diosdih ʉʉ́bh pã́ina ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías chej jʉmnidih ã cáwachahjeh, Dios ã wahni ángel ãt jígohop wʉt jĩ. Chej jʉmni cáwat dah jéihyepmant bóo bʉwámant ãt ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pánihna, Zacarías caandíh en wʉ́hi bejnit, bʉ́dí ãt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Páant ã ʉ́ʉmʉchah ennit, ángel caandíh nin pah ãt niíj naáwáp wʉt jĩ: —Zacarías, ma ʉ́ʉmca bojoó. Ma ʉʉ́bátdih Diosboó ãt joiná wʉt be. Yeebdíh ã tʉ́i chãjachah, majeéh bóli, Elisabet, newé weépdih mi weh jʉmbipna caá. Caandíh Juan ma wʉ̃t bʉ́ʉdhdʉ́p. ");
INSERT INTO cbv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ñi wʉ̃ʉ́h ã cã́ac jʉmʉchah enna, bʉ́dí ñi wẽibipna caá. Dawá cã́acwãbʉt biíc yoobó ĩ wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Dios ã enechah, caán oboh jʉmni nihcan niít. Ã ñíoni jʉmna, jiwá iguíh mac, pooni, poocannidihbʉt ã babhcan niít. Beh wiliíh wʉdah diítmah jʉm jwʉhna, Tʉ́ini Espíritu ã wẽpatdih ã bíbohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma wʉ̃ʉ́h behna, dawá quíib bʉʉdnít judíowãdih Diosdih ã jwʉ́ʉb jepahat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dios ã wahni ã jʉ̃ʉ́wát pínahdih naóh waóhni pínah ã jʉmbipna caá. Dios ã wẽpat bʉ́dí bíbohna, Elíasji ã wẽp naáwátji pah mʉntih ma wʉ̃ʉ́hbʉt biíc yoobó wẽp naóhni ã jʉmbipna caá. Páant ã naáwáchah joinít, behnitboó tʉ́ʉt nʉʉmnít, ĩ wehdih ĩ tʉ́i oibipna caá. Tʉ́inidih yap yohnitbʉt tʉ́ʉt nʉʉmnít, tʉ́i chãjnit ĩ jenah joyát pah mʉntih ĩ jwʉ́ʉb jenah joibípna caá. Pánihna, Cristo ã jʉ̃ʉ́wát pínah jã́tih, cã́acwã tʉ́ʉt nʉʉ́m pã́init ĩ jʉmbipna caá, caandíh ĩ tʉ́i jepahat pínah niijná, ángel Zacaríasdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Páant ã niijíchah joinít, Zacarías ángeldih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Ded pah tigaá ma naáwátdih wã jéihbi? Weém behe caá. Wãjeéh bólibʉt beh wili caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—Weém Gabriel, Diosdih teo wʉ̃hni caá. Weém ãjeéh jʉmnidih ã wahap be, nin tʉ́ini doonádih meemdíh wã naáwát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wã naáwátdih ‘Yoobópdih nihcan caá’, ma niíj jenah joyát jíib, meém jéih wéhecanni ma jʉm jwʉhbipna caá. Wã niiját pah ã yapachahjeh, ma jwʉ́ʉb wéhebipna caá, páant mʉntih, ángel caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zacarías maatápdih ã jígohcah, tã́ahmant bóo tólihdih ʉʉ́bh pã́initboó ĩt náhni dahwanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pánihna, jwʉ́ʉb bac jʉ̃óhnit, jéih naóhcanjeh, queétdih ã́ih téihyajĩh ãt jenah jʉ́ʉt naáwáp wʉt jĩ. Ã jéih wéhecah ennit, “Oo jʉ́mat déedih ãt en tagaá”, ĩt niíj jéihyep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tʉ́ttimah, Zacaríaswã ĩ teo péanachah, ã́ih mʉʉ́boó ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Páant ã jwʉ́ʉb bejat tʉ́ttimah, ãjeéh bóli Elisabet mit wʉdʉ jʉmʉp wʉt jĩ. Wʉdʉ jʉmnit, biícjĩh bóo téihya widh mit míic jʉ́ʉtcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Pánih wʉdʉ jʉm wẽina, nin pah mit míic niijíp wʉt jĩ, “Weém weh wihcannihji tíic náah jʉmnihdih jĩ́gah ennit, Dios weemdíh ãt teo wáacap taga. Weemdíh newé weép ãt wʉ̃hʉp taga, cã́acwã weemdíh yeejép dooná ĩ jwʉ́ʉb naóhcat pínah niijná”, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet seis widh mi wʉdʉ jʉmʉchah, Maríadih naáwát náahna, Dios ã́ih ángel Gabrieldih ãt jwʉ́ʉb wahap wʉt jĩ. Pánihna, Gabriel Galilea baácboó Nazaret tʉ́tchidih jʉibínit, María pebhna ãt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María neonájeéh jʉm jwʉhcannih José áa pínah wʉt jĩ. José Davidji jʉima wʉt jĩ. Caán David judíowã ĩ chah maáh ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel Maríadih naáwádih jʉibínit, nin pah caántdih ãt niijíp wʉt jĩ: —¿Ma jʉm, Dios chah oinih? Dios majeéh ã jʉmna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Obohjeéhtih, páant ã niijíchah joinít, María bʉ́dí mit joí wʉ́hi bejep wʉt jĩ. Pánih joí wʉ́hinit, caántjeh nin pah mit míic niíj ʉʉ́bh joyóp wʉt jĩ: “¿Ded pah ã nihat pínahdih niij tígaá ã chãj, páant niijná?” mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Páant mi niíj jenah joyóchah, ángel caántdih nin pah ãt niíj naáwáp wʉt jĩ: —¡Ma ʉ́ʉmca bojoó, María! Dios meemdíh bʉ́dí ã wẽi enna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ded pah meemdíh yapat pínahdih naáwádih wã jʉ̃óhna caá. Meém wʉdʉ pínah caá. Newé weépdih ma weh jʉmbipna caá. Caán ã cã́ac jʉmʉchah, Jesús ma wʉ̃t bʉ́ʉdhdʉ́p. ");
INSERT INTO cbv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","‘Dios chah wẽpni wʉ̃ʉ́h caá’, caandíh ĩ niijbípna caá. David jʉima jʉmna, David maáh ã jʉmatji pah Dios caandíh maáh ã waadábipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pánihna, ma wʉ̃ʉ́h nihat judíowãdih maáh ã jʉmbipna caá. Nihat bitadihbʉt maáh ã jʉmʉchah, jwʉ́ʉb tʉ́ʉt nʉʉmní pínah ã wihcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Páant ã niijíchah joinít, María ángeldih nin pah mit niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedé, weém neonájeéh jʉmcannih, ded pah tigaá wã wʉdʉ jʉmbi? mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Tʉ́ini Espíritu meemdíh ã waadáchah, Dios ã wẽpatjĩh ma wʉdʉ jʉmbipna caá. Pánihna, ma wʉ̃ʉ́h tʉ́ini, yéejat wihcanni ã jʉmbipna caá. ‘Dios wʉ̃ʉ́h caá’, caandíh ĩ niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma dée wili, Elisabetbʉt beh wili yʉhna, wʉdʉ caá. Caántbʉt newé weépdih mi weh jʉmbipna caá. Bʉʉ biíc peihcanni widhjeh jʉdhna caá, caánt mi weh jʉmat pínah. Jáap wili jʉmna, weh wihcannihji bʉʉ wʉdʉ caá bʉca. ");
INSERT INTO cbv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios nihat jéihni dedé ã bʉwacan caá, ángel Maríadih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Páant ã niijíchah joinít, María caandíh nin pah mit niíj jepahap wʉt jĩ: —Weém Dioíh wili caá. Ma niijátji pah weemdíh ã yapa naáh, mit niijíp wʉt jĩ. Páant mi niijíchah joinít, Dios pebhboó ángel ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ángel páant ã niiját tʉ́ttimah, María waícanjeh mi dée wilidih enedih mit bejep wʉt jĩ. Caánt mijeéh bóo Zacaríasjĩh Judea baác jeé cãtíh bóo tʉ́tchidih ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pánihna, ĩ́ih mʉʉná waád jʉibínit, Elisabetdih mit ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Caántdih mi ʉʉ́bʉ́chah joinítjeh, Tʉ́ini Espíritu mi weépdih ã weñanachah, tʉbit ãt wʉ̃línap wʉt jĩ. Mi weépdih weñanit, beh wilidihbʉt Tʉ́ini Espíritu bʉ́dí ãt weñanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","María mi wʉ̃ʉ́h pínahdih ã jéihyanachah, bʉ́dí wẽinit, nin pah Elisabet mit niíj wẽp naáwáp wʉt jĩ: —María, nihat yaádhdih en beedánit, meemdíh wẽi ennit, Dios ãt tʉ́i chãjap taga. Ma wʉ̃ʉ́hdihbʉt ã tʉ́i chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Oboh jʉmnih wã jʉmʉchah yʉhna, wã Maáh íin pínah weemdíh enedih ma jʉyʉ́chah, bainí wã wẽican caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma wíhenachahjeh, wã weép wẽina, ãí wẽp wʉ̃línap be. ");
INSERT INTO cbv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pánihna, Dioíh ángel ã naáwátji pahjeh ã yapat pínahdih jenah joiná, meemdíh ã tʉ́i chãjachah, bainí ma wẽican niít, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Páant mi niijíchah joinít, Maríabʉt nin pah mit wẽi niíj naáwáp wʉt jĩ: “Jwĩ Maáh Diosdih bʉ́dí wã wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Caán weemdíh tʉ́i ʉbnidih bainí wã wẽican caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Caandíh oboh teo wʉ̃hnih wã jʉmʉchah yʉhna, jĩ́gah ennit, weemdíh ãt teo wáacap taga. Dios wẽpni, tʉ́ini yoobát jʉmna, weemdíh chah tʉ́ini ãt chãjap taga. Páant ã chãjachah jéihnit, nihat cã́acwã, bʉʉ jʉmnit, tʉ́ttimah jʉmnitbʉt ‘Caántboó Dios ã chah tʉ́i chãjnih wʉt jĩ’, weemdíh ĩ niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Det caandíh jepahnitdih jĩ́gah ennit, ãpĩ́ teo wáacna caá. Jon jã́tih jʉmnit, bʉʉ jʉmnitdihbʉt teo wáacnit, pʉ́ʉ́ tʉ́ttimah jʉmnitdihbʉt ã teo wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ded pah náahna, ã wẽpatjĩh ãpĩ́ chãjap wʉt jĩ. Pánih chãjnit, ‘Weém tʉ́i jéihni caá’, niíj jenah joinítdih teo wáaccan, bʉ́dí ã wẽpatjĩh ãt wah peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yeejépwã ĩ maáh wẽpatdih ãt dʉ́ʉc wáyap wʉt jĩ. Obohjeéhtih, ‘Weém oboh jʉmni caá’, niíj jenah joinítdih teo wáacnit, maáta dée ãt waadánap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Moh yéejnitdih tʉ́inidih ãt wʉ̃hʉp wʉt jĩ. Obohjeéhtih, dawá bií dée bíbohnitboodíh wʉ̃hcanjeh, biáboó ãt wahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jwiít caandíh teo wʉ̃hnit judíowãdih jĩ́gah ennit, ãt teo wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Biíc yoobó mʉntih jwĩ nʉo Abraham ã jʉimenádih jĩ́gah ennit, ãt teo wáacap wʉt jĩ. Pánih jĩ́gah ennit, ã teo wáacat pínahdih jwĩ nʉowãjidih ãt naáwáp wʉt jĩ”, María mit niíj wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pánih jʉibínihji Elisabetjeéh biíc peihcanni widh mit jʉm jwʉhʉp wʉt jĩ. Tʉ́ttimah, miíh tʉ́tchina mit jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","María mi jwʉ́ʉb bejat tʉ́ttimahbit, Elisabet mit weh jʉmʉp wʉt jĩ. Newé weépdih mit tʉ́ʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Miíh mʉʉ pébh jʉmnit mi déewãbʉt Dios caántdih jĩ́gah ennit ã teo wáacat doonádih joinít, mijeéh bʉ́dí ĩt weñep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho yeó jáap tʉ́ttimah, sacerdotewãdih caandíh quehli nah yapat chóodih ĩt bóodat tʉ́ʉtʉp wʉt jĩ. Páant judíowã ĩpĩ́ chãjap wʉt jĩ. Caandíh beheíh wʉ̃tjeh ĩt bʉ́ʉdhdíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Obohjeéhtih, páant ĩ niijíchah joinít, ã íinboó nin pah mit niijíp wʉt jĩ: —Zacarías nihcan caá. Juan caá ã wʉ̃t pínah, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Obohjeéhtih, ñi déewã poómpdih Juan wʉ̃t jʉmni ã wihcan caá, cã́acwã caántdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Páant niíj péanit, queét Zacaríasdih téihyajĩh ĩt jʉ́ʉtʉp wʉt jĩ, “¿Dedé tigaá wʉ̃t ma bʉ́ʉdhbi?” niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Páant ĩ jʉ́ʉtʉchah ennit, Zacarías ã́ih téihyajĩh daacát naadíh jʉ́ʉt ʉʉ́bhnit, “Juan caá ã wʉ̃t”, ãt niíj daacáp wʉt jĩ. Páant ã daacáchah en wʉ́hi bejnit, queét nihat ĩt joí yai ñʉ́h bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pánih daácnajeh, wéhecanniji ãt jwʉ́ʉb wéhenap wʉt jĩ, páant mʉntih. Pánih wéhenit, Diosdih bʉ́dí ãt wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pánihna, nihat ĩ pebh jʉmnit bʉ́dí ĩt wʉ́hi bejep wʉt jĩ. Páant ã yapat doonádih joinít, nihat cã́acwã, Judea baácboó jʉmni jeé cãtíh jʉmni tʉ́tchinadih moón ĩt míic wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pánih míic wéhenit, Dios caandíh ã tʉ́i chãjachah jéihnit, “¿Caán wébít ded pah chãjni pínahna tigaá?” bʉ́dí ĩt niíj jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tʉ́ini Espíritu Zacaríasdih ã weñanachah, ã wẽpatjĩh nin pah Diosdih ãt niíj wẽi naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Jwiít judíowã jwĩpĩ́ wẽini Diosdih bʉ́dí wã wẽina caá! Jwiít ã́ih cã́acwãdih teo wáacadih jʉ̃óhnit, chéonit panihnit jwĩ jʉmcat pínah niijná, nemépwã ĩ maáh ã wẽpatdih ã dʉ́ʉcbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Jon jã́tih Dios naáwátdih naóh yapanitji nin pah ĩt niíj daacáp tajĩ: ‘Diosdih teo wʉ̃hni David jʉima chah wẽpni jʉmna, jwiít ã́ihwãdih teo wáacnit, iiguípna jwĩ bejat déedih tʉ́i ʉbni pínahdih Dios ã wahbipna caá, ");
INSERT INTO cbv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","jwiítdih eníhcannit ĩ wẽpatdih ã dʉ́ʉcʉchah, jwĩ tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Pánihna, jwĩ nʉowãdih ã naáwátji pahjeh mʉntih, jĩ́gah ennit, jwiítdih ã teo wáacbipna caá. Nin pah jwĩ nʉo Abrahamjidih ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Ma jʉimenádih eníhcannit ĩ wẽpatdih wã dʉ́ʉcbipna caá, ʉ́ʉmcanjeh, weemdíh ĩ weñat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pánihna, nin baácboó jʉm jwʉhnit, wã enechah, tʉ́initjeh wĩ́ihwã ĩ jʉmbipna caá”, Abrahamdih ãt niijíp wʉt jĩ’, Dios naáwátdih naóh yapanit ĩt niíj daacáp tajĩ”, Zacarías Diosdih ãt niíj wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Diosdih páant niíj péanit, ã wʉ̃ʉ́hdih jwʉh nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: “Wʉ̃ʉhʉ́, jwĩ Maáh jwiítdih tʉ́i ʉbni pínah ã jʉ̃ʉ́wátdih naóh waóhni ma jʉmbipna caá. ‘Dios naáwátdih naóh yapani caá’, meemdíh ĩ niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jwiít ã́ihwãdih jwĩ yéejatdih yohnit, iiguípna jwĩ bejat déedih ã tʉ́i ʉbat pínahdih ma naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jĩ́gah en teo wáacnit, jwiítdih tʉ́i ʉbni pínahdih Dios jeámant ã wahbipna caá, baabát panihipboó jwĩ jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wʉnatdih ʉ́ʉmna, dʉpʉ́át panihipboó jʉmnitdih jiiát déedih ã wʉ̃hbipna caá, tʉ́ini namádih ĩ jií en bejat pínah niijná”, Zacarías ãt niíj wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pánihna, Zacarías wʉ̃ʉ́h ãt behep wʉt jĩ. Dios ã tʉ́i teo wáacachah, caolih jʉ́ʉtíhni, caandíh tʉ́i jepahni ãt behep wʉt jĩ. Pánih behnit, judíowãdih ã bohéát pínah jã́tih mʉʉ́ wihcapboó ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","María mi weh jʉmat pínah jã́tih, Cirenio Siria baácdih moón ĩ maáh jʉm láa, César Augusto Roma tʉ́tchimant jʉmna, nihat baácdih moondíh wʉtni ãt jʉmʉp wʉt jĩ. Démoón cã́acwã ĩ jʉmatdih jéihyat tʉ́ʉt niijná, nihat cã́acwãdih ĩ́ih wʉ̃tnadih ãt daacát tʉ́ʉtʉp wʉt jĩ. Caandíh náahna, nihat cã́acwãdih ã daácni nʉ́odih ãt wahap wʉt jĩ. Páant ã chãjat tʉ́ʉtni yeó jáap ĩ jwíih wʉ̃t daacát yeó jáap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Páant ã wʉtʉchah joinít, nihat cã́acwã ĩ nʉowãji ĩ cã́ac jʉmni tʉ́tchina yoobó wʉ̃t daacádih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josébʉt yad pínahjĩh ĩt bejep wʉt jĩ. María wʉdʉ jʉmna yʉhna, Galilea baác Nazaret tʉ́tchimant, pʉ́ʉ́ Judea baác Belén tʉ́tchina mit bejep wʉt jĩ. Belén tʉ́tchidih Davidji ãt cã́ac jʉmʉp wʉt jĩ. Pánihna, David jʉima jʉmna, José yadjĩh Belén tʉ́tchina wʉ̃t daacádih ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Queét chénewã Belén tʉ́tchiboó jʉibínit, dawá cã́acwã ĩ jʉmʉchah, ʉ̃wat mʉʉná ã yáwachah, momo jiwiwã ʉ̃wat tólihboó Joséwã ĩt ʉ̃wʉp wʉt jĩ. Caánboó jʉmna, María mi jáap bácahdih bóodih mit weh jʉmʉp wʉt jĩ. Pánih weh jʉm péanit, mi wʉ̃ʉ́hdih yéguehjĩh tʉ́i pin bojnit, momo jiwiwã jeémát yacat paihdih mit cáagap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Páant mi weh jʉmni chei, Belén tʉ́tchi jwẽ́ejdih ovejawãdih en daonít ĩ́ih ovejawãdih en daoná ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Páant ĩ en dawáchah, Dioíh ángel queétdih ãt jígohop wʉt jĩ. Pánih jígohnit, bʉ́dí ã yeh iiguíchah ennit, bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Páant ĩ ʉ́ʉmʉchah ennit, ángel queétdih nin pah ãt niíj naáwáp wʉt jĩ: “¡Ñi ʉ́ʉmca bojoó! ¡Ñi joyoó! Bʉ́dí ñi weñat pínah tʉ́ini doonádih yeebdíh naáwádih jʉ̃óhna caá wã chãjap. Caán doonádih joinít, nihat cã́acwãbʉt bʉ́dí ĩ wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bʉtéh Daviíh tʉ́tchidih cã́acwãdih tʉ́i ʉbni pínah ã cã́ac jʉmʉp be. Caán Dios ã wahni Cristo, nihat cã́acwã ĩ maáh pínah caá. ");
INSERT INTO cbv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wã niijnídih ñi bid jʉyʉ́chah, momo jiwiwã jeémát yacat paihdih yégueh chóojĩh pin bojni, ã lajbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ángel queétdih páant ã niijíchahjeh, dawá ángelwã ãjeéh jígohnit, Diosdih nin pah ĩt niíj wẽi naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Nihat jeáboó jʉmnit Dios wẽpnidih ĩ weñe naáh! ¡Nin baácboó ã oinit ĩ tʉ́i jʉmʉ naáh!” ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ángelwã queétdih páant niíj naóh péanit, Dios ã jʉmʉpboó ĩt jwʉ́ʉb bejep wʉt jĩ. Ĩ jwʉ́ʉb bejat tʉ́ttimahbitjeh, ovejawãdih en daonít nin pah ĩt míic niijíp wʉt jĩ: —Chóbe, Belén tʉ́tchina Dioíh ángel jwiítdih ã niijátdih enjĩh, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Páant niijnít, Belén tʉ́tchina wẽpép caandíh enedih ĩt bejep wʉt jĩ. Pánih bej, caanná jʉibínit, María, José, wébítdihbʉt ĩt enep wʉt jĩ. Wébít momo jiwiwã jeémát yacat paihdih ãt lajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","20","Pánih bid jʉinít, ángel ded pah ã niijátdih Maríawãdih ĩt naóh yapanap wʉt jĩ. Pánih en péanit, ĩ́ih ovejawã pebhboó ĩt jwʉ́ʉb bejep wʉt jĩ. Pánih bejnit, ángel queétdih ã niijátji pahjeh ennitji Diosdih bʉ́dí ĩt wẽi naáwáp wʉt jĩ. Nihat ĩ jwãáhnitdihbʉt ĩt naáwáp wʉt jĩ. Páant ĩ naáwáchah joinít, cã́acwã ĩt joí wʉ́hi bejep wʉt jĩ. Obohjeéhtih, beh wiliboó wébítdih páant ĩ niijátjidih caántjeh bʉ́dí mipĩ́ jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesús ã cã́ac jʉmniji ocho yeó jáap tʉ́ttimah, sacerdotewãdih ã́ih quehli nah yapat chóodih ĩt bóodat tʉ́ʉtʉp wʉt jĩ. Páant judíowã ĩpĩ́ chãjap wʉt jĩ. Pánih bóod péanit, ã íin wʉdʉ jʉmat pínah jã́tih ángel ã niijátji pahjeh caandíh Jesús ĩt wʉ̃t bʉ́ʉdhdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Biíc widh tʉ́ttimah, Moisés ã wʉtatji pah chãj péanit, mi wʉ̃ʉ́hdih Diosdih wʉ̃hat tʉ́ʉt niijná, Jerusalénna ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pánih wʉ̃hnit, Dios nin ã wʉtatjidih ĩt jepahap wʉt jĩ: “Jáap bácahdih bóo newé weép ã jʉmʉchah, weemdíh ñi wʉ̃hʉʉ́. Caán wĩ́ih, weemdíh teo wʉ̃hni pínah caá”, Dios ãt niíj wʉtʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pánihna, Jerusalénna Dioíh mʉʉdíh jʉibí, jopwãdih jíib chãjnit, sacerdotewãdih ĩt wʉ̃hʉp wʉt jĩ, Diosdih ĩ cáo wʉ̃hat pínah niijná. Pánih chãjnit, Dios nin ã wʉtatjidih ĩt jepahap wʉt jĩ: “Chénewã jopwãdih ñi wʉ̃hʉʉ́ weemdíh, jáap bácahdih bóodih tʉ́ʉt nʉʉmná”, Dios ãt niíj wʉtʉp tajĩ. Pánih chãjna, ĩ weh jʉmat tʉ́ttimah, nihat Dios ã wʉtatjidih ĩt chãj péanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Caán láa Dios naáwátdih tʉ́i jepahni, Simeón wʉ̃t jʉmni, Jerusalén tʉ́tchidih ãt jʉmʉp wʉt jĩ. Caán Diosdih tʉ́i wẽini jʉmna, Dios ã wahni judíowãdih tʉ́i ʉbni pínahdih pã́ina ãt chãjap wʉt jĩ. Caandíh Tʉ́ini Espíritu ã wẽpat bʉ́dí ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pánih jʉmna, nin pah caandíh ãtát niíj jéihyanap wʉt jĩ: “Ma wʉnat pínah jã́tih Dios ã wahni Cristo, ã́ih cã́acwãdih tʉ́i ʉbni pínahdih meémboó ma enbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pánihna, caandíh Dioíh mʉʉná Tʉ́ini Espíritu ãt bejat tʉ́ʉtʉp wʉt jĩ. Joséwã Jesúsdih ĩ ʉb waad béjechah, Dios ã wʉtatji pah chãjat tʉ́ʉt niijná, Simeón queétdih ãt jwãááp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pánih jwãáhnit, Tʉ́ini Espíritu caandíh ã jéihyanachah, wébítdih ãt ʉb tʉ́ʉhʉp wʉt jĩ. Ʉb tʉ́ʉhnit, nin pah Diosdih ãt niíj wẽi naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Maá, meém ma niijátji pahjeh míih cã́acwãdih tʉ́i ʉbni pínahdih ma wahnidih bʉʉ wã enna caá. Weém, meemdíh teo wʉ̃hni, bʉʉ wã wʉnʉchah, ã tʉ́ibipna caá, bʉca. ");
INSERT INTO cbv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nihat cã́acwã ĩ enechah, meém nindih mat wahap taga, cã́acwã iiguípna ĩ bejat déedih ã tʉ́i ʉbat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nin tigaá nihat judíowã nihcannitdih ded pah Dios ã jʉmatdih ã jéihyabipna caá. Páant ã jéihyanachah, judío ã jʉmʉchah jéihnit, bitaboó míih judíowãdih ĩ tʉ́i wẽibipna caá”, Simeón ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Páant ã niijíchah joinít, Joséwã bʉ́dí ĩt wẽi jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tʉ́ttimah, Simeón queétdih wẽinit, “Dios yeebdíh ã tʉ́i chãja naáh”, niijnít, Maríadih jwʉh nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Nin wã naáwátdih ma tʉ́i joyoó. Nin wébít Dios ã wahni caá. Dawá judíowã caandíh ĩ náahcatji peéh ĩ bʉʉdbípna caá. Obohjeéhtih, dawá bita judíowã caandíh náahnit, ĩ tʉ́i jʉmbipna caá. Caán Dios ã weñat pínahdih jéihyani ã jʉmʉchah yʉhna, dawá caandíh yap yohnit, yeejép ĩ naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nihat cã́acwã ded pah ĩ jenah joyátdih jéihyani pínah Dios nin wébítdih ãt wahap taga. Obohjeéhtih, meémboó bʉ́dí ma jĩ́gahbipna caá, Simeón caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Caanjĩ́h beh wili Ana wʉ̃t jʉmnihbʉt mit jʉmʉp wʉt jĩ. Caántbʉt Dios naáwátdih naóh yapanih wʉt jĩ. Caánt Fanuelji nʉʉ́m, Aserji jʉimená poómpdih bóli wʉt jĩ. Caánt jáap beh tóahnih jʉmna, mit áa jʉmʉp wʉt jĩ. Obohjeéhtih, siete jópchijeh caántdih bíbohnit, mijeéh bóo ãt éemp wʉnʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pánih éemp wʉnnih jʉmna, ochenta y cuatro jópchi bíbohnit, Dioíh mʉʉ́ diítboó mipĩ́ jʉmʉp wʉt jĩ. Yeó jáap jʉmat pah, chei jʉmat pahbʉt jeémp jwʉhcan, Diosdih mipĩ́ wẽi ʉʉ́bh jáanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Caán horadih pohba Joséwã pebhna mit jʉibínap wʉt jĩ. Pánih jʉibí, Jesúsdih enna, Tʉ́ini Espíritu ã jéihyanachah, Diosdih mit wẽi naáwáp wʉt jĩ. Dios ã wahni, queétdih tʉ́i ʉbni pínahdih judíowã ĩpĩ́ páñap wʉt jĩ. Pánihna, Jesús ĩ bidni ã jʉmatdih nihat queét pã́initdih mit naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joséwã nihat Dios ã wʉtatji pah chãj péa, jwʉ́ʉb bejnit, Belén tʉ́tchidih ĩt jʉm jwʉhʉp wʉt jĩ. Tʉ́ttimah, Galilea baác ĩ jʉmniji Nazaret tʉ́tchina ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ĩ wʉ̃ʉ́h tʉ́i behnit, caolih jʉ́ʉtíhnijeh jʉmna, Dios ã weñat pínahdih ãt tʉ́i jéihyep wʉt jĩ. Pánihna, Dios caandíh tʉ́i wẽi ennit, bʉ́dí ãt teo wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Oveja wʉ̃ʉ́hdih ĩ mao jeémát yeó jáap, Pascua ĩ niijní, paacánni pandihbʉt ĩ jeémp wẽi láa, Dios ã wʉtatjidih jepahnit, nihat judíowã jópchi jʉmat pah, Jerusalén tʉ́tchidih ĩpĩ́ míic wáac jʉibínap wʉt jĩ. Jesús mánabʉt jópchi jʉmat pah Jerusalénna ĩpĩ́ aab béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce jópchi bíbohnit, caanbʉ́t ã mánajeéh ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pánih jʉibínit, ĩ wẽi jeémát ã beedéchah, ĩ chéenwã biícdih Joséwã Nazaret tʉ́tchina ĩt jwʉ́ʉb dei bejep wʉt jĩ. Obohjeéhtih, ã mána ĩ jéihcah yʉhna, Jesús Jerusalénboojéh ãt chãwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Dawá jwĩ bejechah, jwĩ wʉ̃ʉ́h jwĩ déewãjeéh ã jʉmna nacaá”, ĩt niíj jenah joyóp wʉt jĩ. Páant niíj jenah joiná, nihat yeó jáap bejnit, cheyeh caandíh ĩtih bidip wʉt yʉh jĩ. Obohjeéhtih, ĩt bid jʉicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pánih bid jʉicán, Jerusalén tʉ́tchina bididih ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jerusalénna jwʉ́ʉb jʉibínit, caanná ĩ wʉ̃ʉ́hdih bʉ́dí ĩt bidip wʉt yʉh jĩ. Chéne yeó jáap tʉ́i bid, biíh yeó jáapdih ĩt bid jʉyʉ́p wʉt jĩ, bʉca. Dioíh mʉʉ́ diítna Moisés ã wʉtatjidih bohénit cãtíh chʉ́ʉdnit, queétdih joiná, ʉʉ́bh joí enna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Beh joinít, ã tʉ́i jepahachah, nihat caandíh joinít bʉ́dí ĩt joí wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pánihna, ã mána Dioíh mʉʉná waád jʉibínit, caanná behnitjeéh ã chʉ́ʉdʉchah ennit, queétbʉt bʉ́dí ĩt wʉ́hi bejep wʉt jĩ. Páant ã chãjachah ennit, ã íin nin pah mit niíj ʉʉ́bh joyóp wʉt jĩ: —¿Wʉ̃ʉhʉ́, dépanih tigaá jwiítdih páant ma nih chãj? Ma joyoó, ma íbijĩh meemdíh bʉ́dí jwĩ bidip be. Meemdíh bid jʉicán, bʉ́dí jwĩ náhni dahwanap be, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿Dépanih tibeé weemdíh ñi bid? ¿Wã íipíh mʉʉ́boó ã náahatdih chãjni wã jʉmatdih ñi jéihcannit beé? Jesús queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Obohjeéhtih, ded pah ã niijátdih ĩt beh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Caandíh bid jʉinít, Nazaret tʉ́tchina ĩt nʉmah jwʉ́ʉb dei bejep wʉt jĩ. Caanná jwʉ́ʉb dei jʉibíniji behna, ã mánadih ãpĩ́ tʉ́i jepahap wʉt jĩ. Obohjeéhtih, beh wili nihat páant ã chãjatjidih bʉ́dí mipĩ́ jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús tʉ́i jéihnijeh ãt behep wʉt jĩ. Páant ã jʉmʉchah, Dios caandíh bʉ́dí ãt wẽi enep wʉt jĩ. Cã́acwãbʉt biíc yoobó caandíh ĩt weñep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tʉ́ttimah, Zacarías wʉ̃ʉ́h Juan behna, mʉʉ́ wihcapboó ã jʉmʉchah, Dios caandíh ãt jwíih naáwát tʉ́ʉtʉp wʉt jĩ. Caán láa Roma tʉ́tchidih moón ĩ maáh Tiberio César quince jópchi maáh ãt jʉmʉp wʉt jĩ. Poncio Pilato Judea baácdih moón ĩ maáh ãt jʉmʉp wʉt jĩ. Herodes Galilea baácdih moón ĩ maáh ãt jʉmʉp wʉt jĩ. Ã ʉ́ʉd jeñé Felipe Iturea baácdih moón, Traconite baácdih moón biícdih ĩ maáh ãt jʉmʉp wʉt jĩ. Lisanias Abilinia baácdih moón ĩ maáh ãt jʉmʉp wʉt jĩ. Páant ĩ maáh jʉmʉchah, Anás Caifásbʉt sacerdotewã ĩ maáta ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Caán láa, Juan mʉʉ́ wihcapboó ã jʉmʉchah, Dios caandíh ãt naáwát tʉ́ʉtʉp wʉt jĩ. Pánihna, Dios ã naáwát tʉ́ʉtʉchah joinít, Juanboó Jordán mʉj pebh dei jʉibínit, ãt táoh naóh jibip wʉt jĩ. Nin pah ãpĩ́ niíj naóh bohénap wʉt jĩ: “Ñi yéej chãjatdih cádahnit, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmʉ́. Páant ñi tʉ́ʉt nʉʉmʉ́chah, Dios ñi yéejatdih ã yohbipna caá. Páant ñi chãjachah, yeebdíh wã daabábipna caá, ñi yéejat yohat jʉ́ʉtat pínah niijná”, cã́acwãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon jã́tih Dios naáwátdih naóh yapani Isaías, nin pah Juan ã chãjat pínahdih ãt niíj naóh daacáp wʉt jĩ. “Dios naáwátdih naóh yapani mʉʉ́ wihcapboó jʉmni nin pah ã niíj ñaác bohébipna caá: ‘Jwĩ Maáh ã jʉ̃ʉ́wát pínah jã́tih ñi yéej chãjatdih cádah, tʉ́iniboodíh tʉ́ʉt nʉʉmnít, caandíh ñi tʉ́i páñaá. ");
INSERT INTO cbv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Det jĩ́gah náah jʉmnitdih ã teo wáacbipna caá. Obohjeéhtih, det “Weém nihat jéihni, dedé weemdíh jʉdhdat wihcan caá”, niíj jenah joinítdih ĩ wẽpatdih jwĩ Maáh ã dʉ́ʉc wáibipna caá. Det biáboó jenah joinít ĩ jenah joyátdih ã yoobábipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pánihna, nihat cã́acwã yoobópdih ĩ jenah joibípna caá, iiguípna ĩ bejatji déedih Dios ã tʉ́i ʉbatdih ĩ jéihyat pínah niijná’, ã niíj naóhbipna caá”, Isaías ãt niíj daacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dawá cã́acwã Juan pebhna ĩt jʉibínap wʉt jĩ, queétdih Juan ã daabáát pínah niijná. Ã pebhna jʉibínitdih nin pah ãpĩ́ niíj naáwáp wʉt jĩ: “¡Yeéb yeena caá ñi chãjap! ¡Maiwã panihnit yeejépwã jʉmna, peéh chãjat pínahdih ʉ́ʉm jweííhnitjeh caá! Obohjeéhtih, yeéb ñi yéej chãjatdih ñi cádahíhcat jíib, Dios yeebdíh ã peéh chãjachah, ñi jéih jweicán niít. ");
INSERT INTO cbv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ñi yéejatdih cádahnit, tʉ́iniboodíh tʉ́ʉt nʉʉmát caá yeebdíh náahap. ‘Abrahamjidih Dios ãt wẽi enep wʉt jĩ. Pánihna, ã jʉimená jwĩ jʉmʉchah, jwiítdihbʉt ã tʉ́i wẽi enna caá’, ñi niíj jenah joiná yʉh caá. Obohjeéhtih, pánihcan caá. Yeejép ñi chãjachah ennit, ã wẽican caá. Ñi joyoó. Dios náahna, Abrahamji ã jʉimená pah nin jee dáhnadih ã jéih tʉ́ʉt nʉʉmná caá. ");
INSERT INTO cbv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wápchi mínah ã́ih wápchidih en dawát pah, yeebdíhbʉt Dios ã en daoná caá. Biquí nahna yeejép ã quehechah enna, tib yohnit, ã́ih náatnadihbʉt ã pʉd yohbipna caá. Pánih péanit, caan náhdih, ã́ih náatnadihbʉt ã cáo yohbipna caá. Páant ã chãjat pah mʉntih, yeejép ñi chãjachah enna, Dios yeebdíhbʉt iiguípna ã wahbipna caá”, Juan ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Páant ã niijíchah joinít, cã́acwã Juandih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Ded pah tigaá jwĩ tʉ́ʉt nʉʉmbí? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Ded chéne yégueh chóo bíbohni yégueh wihcannidih ã wʉ̃hʉ naáh. Jeémát bíbohnibʉt jeémát wihcannidih ã wʉ̃hʉ naáh, queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Romanowã maáta ĩ ʉʉ́bát tʉ́ʉtni dinerodih ʉʉ́bh wʉ̃hnitbʉt daabáát tʉ́ʉt niijná, Juan pebhna jʉibínit, nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Bohéní, jwiítboó ded pah tigaá jwĩ tʉ́ʉt nʉʉmbí? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Ñi maáta ĩ wʉtat pah bóojeh ñi ʉʉ́bʉ́p. Chah ñi ʉʉ́bátdih ñi cádahaá, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Biquína soldadowãbʉt caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Jwiítbʉt ded pah tigaá jwĩ tʉ́ʉt nʉʉmbí? ĩt niijíp wʉt jĩ. —Biíh pah bóonadih en ñinahnit, ñi dʉ́ʉc wáica bojoó. Dawá láa nʉ́o náahna, cã́acwãdih yee naóh ʉ́ʉmanit, nemat mʉʉ́boó bejíhcan ĩ jíib chãjatdih ñipĩ́ wʉtna caá. Páant ñi chãjatdih ñi cádahaá. Ñi tewat jíibdihjeh wẽinit, ñi teweé, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nihat judíowã Dios ã wahni queétdih tʉ́i ʉbni pínahdih ĩt bidip wʉt jĩ. Pánihna, Juan páant ã niijíchah joinít, queétjeh nin pah ĩt niíj jenah joyóp wʉt jĩ: “¿Nin Dios ã wahni jwĩ pã́ini naniít?” ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Obohjeéhtih, Juan queétdih nin pah ãt niijíp wʉt jĩ: “Weém yeebdíh mahjĩhjeh wã daabána caá. Obohjeéhtih, wã tʉ́ttimah jʉ̃óhni, chah wẽpni ã jʉmna caá. Páant ã jʉmʉchah jenah joinít, ‘Weém oboh jʉmni caá’, wã niíj jenah joiná caá. Caánboó mahjĩh daabáát panihni, yeebdíh Tʉ́ini Espíritu ã wẽpatdih bʉ́dí ã wʉ̃hbipna caá. Caán ã wẽpat tʉʉ iigát panihnijĩh ñi yéejatdih cáwat pah ã chãjbipna caá, jwʉ́ʉb yéej chãjíhatdih ñi jenah joicát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Trigo teoni panihni caá. Ã́ih chóonadih caóh caj péanit, caán tíibna yoobátdihjeh wʉh wʉʉ́hboó jʉ́i yacnit, ã́ih mʉʉ́boó ã ámohbipna caá. Obohjeéhtih, ã caóh cajni chóonaboodíh ã cáo yohbipna caá. Páant ã chãjat pah, wã tʉ́ttimah jʉ̃óhni caandíh jepahnitdih ã tʉ́i ʉbbipna caá. Obohjeéhtih, caandíh jepahcannitboodih iiguípna ã wahbipna caá. Caán iigát dedé ã noón dʉbcan niít”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Páant niijnít, biíh naáwátjĩhbʉt Juan cã́acwãdih ãpĩ́ bohénap wʉt jĩ, tʉ́ʉt nʉʉmnít, iiguípna ĩ bejcat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Galilea baácdih moón ĩ maáh Herodes ã ʉ́ʉd Felipe áa Herodíasdih ã dʉ́ʉc wái áa jʉmatji peéh Juan ãt jʉ̃ihñʉp wʉt jĩ. Nihat biíh yeejép ã chãjatjidihbʉt ãt jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Páant ã niíj jʉ̃ihñatji jíib Herodes Juandih joííhcan, ãt nemat tʉ́ʉtʉp wʉt jĩ. Pánih chãjna, chah ãt yoób yéej bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nemat mʉʉ́boó Herodes ã nemat pínah jã́tih, Juan cã́acwãdih ã daabánachah, Jesúsbʉt ã pebhna daabáát tʉ́ʉtʉdih ãt jʉibínap wʉt jĩ. Páant ã daabáát tʉ́ttimah, Jesús Diosdih ã ʉʉ́bʉ́chah, jeá ãt jéweah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Páant ã jéweah bejechah, jop pah jígohni Tʉ́ini Espíritu jeámant dei jʉ̃óhnit, caandíh ãt jʉí jaamáp wʉt jĩ. Páant ã jʉí jaamáchah, jeámant Dios Jesúsdih nin pah ãt niíj naáwáp wʉt jĩ: —Meém wã wʉ̃ʉ́h, wã oini caá. Meemdíh bʉ́dí wã wẽina caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tʉ́ini Espíritu ã dei jʉ̃ʉ́wát tʉ́ttimah, Jesús treinta jópchi bíbohnit, cã́acwãdih ãt bohé jwíihip wʉt jĩ. Nit wʉt jĩ Jesús ã nʉowã: “José ã wʉ̃ʉ́h caá”, cã́acwã ĩt niíj jenah joyóp wʉt yʉh jĩ. José Elí ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elíboó Matat ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Matatboó Leví ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Levíboó Melqui ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Melquiboó Jana ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Janaboó José ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joséboó Matatías ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Matatíasboó Amós ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Amósboó Nahúm ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Nahúmboó Esli ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Esliboó Nagai ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiboó Maat ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Maatboó Matatías ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Matatíasboó Semei ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Semeiboó Josec ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Josecboó Judá ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judáboó Joanán ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Joanánboó Resa ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Resaboó Zorobabel ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Zorobabelboó Salatiel ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Salatielboó Neri ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriboó Melqui ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Melquiboó Adi ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Adiboó Cosam ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Cosamboó Elmadam ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Elmadamboó Er ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erboó Josué ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Josuéboó Eliezer ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Eliezerboó Jorim ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Jorimboó Matat ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatboó Leví ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Levíboó Simeón ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Simeónboó Judá ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Judáboó José ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Joséboó Jonam ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Jonamboó Eliaquim ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimboó Melea ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Meleaboó Mena ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Menaboó Matata ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Matataboó Natán ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánboó David ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Davidboó Isaí ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Isaíboó Obed ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Obedboó Booz ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Boozboó Sala ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Salaboó Naasón ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasónboó Aminadab ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Aminadabboó Admin ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Adminboó Arni ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Arniboó Esrom ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Esromboó Fares ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Faresboó Judá ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judáboó Jacob ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Jacobboó Isaac ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Isaacboó Abraham ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Abrahamboó Taré ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Taréboó Nacor ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorboó Serug ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Serugboó Ragau ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Ragauboó Peleg ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Pelegboó Heber ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Heberboó Sala ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Salaboó Cainán ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainánboó Arfaxad ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Arfaxadboó Sem ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Semboó Noé ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Noéboó Lamec ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecboó Matusalén ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Matusalénboó Enoc ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Enocboó Jared ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Jaredboó Mahalaleel ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Mahalaleelboó Cainán ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánboó Enós ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Enósboó Set ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Setboó Adán ã wʉ̃ʉ́h ãt jʉmʉp wʉt jĩ. Adánboó Dios wʉ̃ʉ́h, ã jwíih chãjniji, ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Juan Jesúsdih ã daabánachah, Tʉ́ini Espíritu caandíh ã yáwachah, Jesús Jordán mʉjmant ãt jwʉ́ʉb aab béjep wʉt jĩ. Jwʉ́ʉb aab béjnit, Tʉ́ini Espíritu caandíh mʉʉ́ wihcapboó ãt nʉmah bejep wʉt jĩ. Caánboó cuarenta yeó jáap ã jʉmʉchah, Satanás, nemépwã ĩ maáh, caandíh ãtih yeejép chãjat tʉ́ʉtʉp wʉt yʉh jĩ. Páant bói yeó jáap caánboó jʉmna, Jesús jeémpcan, nʉʉgʉ́p wʉnna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Páant ã nʉʉgʉ́p wʉnʉchah jéihnit, Satanás caandíh nin pah ãt niíj naáwáp wʉt yʉh jĩ: —Meém Dios wʉ̃ʉ́h jʉmna, can jee dáhdih “Pan dah ma jʉmʉʉ́”, ma niijí, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—Páant wã chãjcan niít. Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Jeémátdihjeh pohba ĩ jeéméchah, cã́acwãíh caolih tʉ́i booni panihni ã jʉmcan niít’, ãt niíj daacáp tajĩ, Jesús Satanásdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Páant ã niíj jepahat tʉ́ttimah, jap bóo jeená Jesúsdih Satanás ãt nʉmah pʉ́ʉh laab béjep wʉt jĩ. Caán jeejína pʉ́ʉh laáb jʉibínit, nihat cã́acwã ĩ jʉmat yoobó Jesúsdih ãt jʉ́ʉtʉp wʉt jĩ. Nihat biícdih ñaáp jígoh, ãt bʉʉdáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pánih jʉ́ʉtnit, nin pah caandíh ãt niijíp wʉt yʉh jĩ: —Nihat baácboó jʉmnit ĩ maáh wẽpat weemdíh wʉ̃hniji caá. Ded wã wʉ̃híhnidih wã jéih wʉ̃hna caá. ");
INSERT INTO cbv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pánihna, meém bódicha caj yoh ñajnit, ‘Meém nihatdih chah maáh caá’, weemdíh ma niijíchah joinít, nihat ĩ maáh wẽpatdih meemdíh wã wʉ̃hbipna caá. Nihat míih pínah ã jʉmbipna caá, Satanás Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—Páant wã chãjcan niít. Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Ma Maáh Diosdihjeh wẽinit, ã wʉtatdihjeh ma jepahaá’, ãt niíj daacáp tajĩ, Jesús Satanásdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Páant ã niiját tʉ́ttimah, Jerusalén tʉ́tchina Dioíh mʉʉ́boó Satanás Jesúsdih ãt nʉmah bejep wʉt jĩ. Dioíh mʉʉ́ jap bóo mʉʉ wʉ́t jĩ. Caanná nʉmah jʉibínit, Satanás caán mʉʉ́ chah jap bóo jʉmni waolí beo nah yapatboó Jesúsdih ãt ñʉhat tʉ́ʉtʉp wʉt jĩ. Pánih ñʉhat tʉ́ʉtnit, nin pah ãt niíj naáwáp wʉt yʉh jĩ: —Meém Dios wʉ̃ʉ́h jʉmna, meemdíh ã wapat pínahdih jʉ́ʉtat tʉ́ʉt niijná, ninmant ma ñaáp jéen bejeé. ");
INSERT INTO cbv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Davidji nin pah ã niíj daacátjidih ma tʉ́i náhninaá: ‘Dios ã́ih ángelwãdih meemdíh ã en dawát tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pánihna, meemdíh ĩ jípónih teobipna caá, jee dáhboó míih jítcha ã bʉʉg lájcat pínah niijná’, ãt niíj daacáp tajĩ, Satanás caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","—Páant wã chãjcan niít. Nin pah Dios naáwátdih naóh yapani ãt niíj daacáp tajĩ: ‘Ñi Maáh Dios ã niijátjidih “¿Yoobópdih niít?” niíj jéihíhna, caandíh ñi chãjat tʉ́ʉtca bojoó’, ãt niíj daacáp tajĩ, Jesús caandíh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pánih yee naóh péanit, Satanás Jesúsdih cádah jwʉ́ʉb bejnit, ã jwʉ́ʉb yéejaat pínah yeó jáapdih ãt páñap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Páant Satanás ã chãjat tʉ́ttimah, Jesús Galilea baácna jwʉ́ʉb jʉibínit, Tʉ́ini Espíritu bʉ́dí ã wẽpatjĩh ãt táoh bohé jwíihip wʉt jĩ. Páant ã bohéát doonádih cã́acwã ĩt naóh peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pánih táoh bohénit, judíowã ĩ bohéát mʉʉná waadnít, queétdih ãpĩ́ bohénap wʉt jĩ. Páant Dios naáwátdih ã bohénachah, nihat caandíh joinít ĩt wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pánih bohé jibnit, Nazaret, ã behni tʉ́tchina ãt jwʉ́ʉb jʉibínap wʉt jĩ. Pánih jwʉ́ʉb jʉibínit, judíowã ĩ chooát yeó jáapdih, ãpĩ́ chãjat pah caanbʉ́t ĩ míic wáacat mʉʉdíh ãt waadáp wʉt jĩ. Pánih waád jʉibí chʉ́ʉdniji ñah ñʉh bejnit, Dios naáwátdih en naáwát tʉ́ʉt niijná, naóhnit ĩ ñʉhʉpna ãt jʉibí ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Caanjĩ́h ã jʉibí ñʉhʉchah, Isaías ã daácni tólihjidih ĩt wʉ̃hʉp wʉt jĩ. Pánihna, caán tólihdih pah teonit, ã naáwát pínahdih bid jʉinít, nin pah ãt niíj en naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wã Maáh Dios Tʉ́ini Espíritu ã wẽpatdih weemdíh bʉ́dí ã wʉ̃hʉp be, cã́acwãdih wã teo wáacat pínah niijná. Pánih wʉ̃hnit, jĩ́gah náah jʉmnit panihnitdih ã́ih tʉ́ini doonádih ã naáwát tʉ́ʉtʉp be. Chéonit panihnitdih ã watat pínah doonádihbʉt ã naáwát tʉ́ʉtʉp be. Jéih encannitdih ã booat tʉ́ʉtʉp be, ĩ jéih enat pínah niijná. Nihat cã́acwã wẽicannit, yeejép yapnitdihbʉt ã teo wáacat tʉ́ʉtʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pánihna, ‘Bʉʉ jwʉh caá, Dios jĩ́gah ennit, cã́acwãdih bʉ́dí ã teo wáac jwíihbipna caá’, weemdíh ã niíj naáwát tʉ́ʉtʉp be, Isaías ãt niíj daacáp tajĩ”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pánih en naóh péanit, caán tólihdih jwʉ́ʉb nah teo, sacerdotedih jwʉ́ʉbanit, ãt jwʉ́ʉb chʉ́ʉdʉp wʉt jĩ. Páant ã chãjachah, nihat caánboó jʉmnit ĩt en ñʉʉnʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pánih chʉ́ʉdnit, Jesús queétdih nin pah ãt niíj bohé jwíihip wʉt jĩ: —Páant ã niíj daacátji bʉʉ caá bʉca ñi cãtíh ã yapap. Weemdíh caá páant ãt niíj daácjip taga, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Páant ã tʉ́i naáwáchah joinít, nihat caandíh wẽi naóhna yʉhna, bʉ́dí ĩt wʉ́hi bejep wʉt jĩ. Pánih wʉ́hi bejnit, nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: —¡Joyoó bʉca! ¿Nin José wʉ̃ʉ́hjeh nihcan niít? ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Páant ĩ míic niíj ʉʉ́bh joyóchah joinít, nin pah Jesús queétdih ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —‘Cohniá, ma míic cohoó’, jwĩ míic niiját pah weemdíh ñi niijmí nacaá. ‘Capernaum tʉ́tchiboó ma wẽp chãjat pah mʉntih ninjĩh ma behni tʉ́tchiboobʉ́t biíc yoobó ma chãjaá, Dios meemdíh ã wahatdih jwĩ jéihyat pínah niijná’, weemdíh ñi niijná yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Obohjeéhtih, ñi joyoó. Ded Dios naáwátdih naóh yapanidih ã pebh jʉmnitboó ĩpĩ́ joííhcan caá. Pánihna, yeéb weemdíhbʉt biíc yoobó ñi joííhcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dios naáwátdih naóh yapani Elíasji jʉm láa, biíc peihcanni jópchi tʉ́i beéd, biíh jópchi tacdih mah bʉʉgcán, nʉʉgʉ́p láa, Israel baácboó dawá éemp wʉnnit yaádh ĩt jʉmʉp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Obohjeéhtih, ñi nʉowã Diosdih ĩ jepahcatdih jéihnit, biíh baácdih bóli éemp wʉnnihdih teo wáacat tʉ́ʉt niijná, Dios Elíasdih ãt wahap wʉt jĩ. Pánihna, Sidón tʉ́tchi pebh Sarepta tʉ́tchibitdih bólidihjeh ãt teo wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dios naáwátdih biíh naóh yapani Eliseo jʉm láabʉt Israel baácboó dawá bácah moópnit ĩt jʉmʉp wʉt yʉh jĩ. Obohjeéhtih, ñi nʉowã Diosdih ĩ jepahcatdih jéihnit, queétdih booaat tʉ́ʉtcan, Naamán Siria baácdih bóodihjeh Eliseodih ãt booaat tʉ́ʉtʉp wʉt jĩ.Páant caán láa ĩ jepahcat pah, bʉʉ yeebbʉ́t weemdíh ñi jepahcan niít, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Páant ã niijíchah joinít, nihat caanjĩ́h chʉ́ʉdnit tʉbit ĩt íijip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pánih íij ñah ñʉh, Jesúsdih teonit, ĩ míic wáacat mʉʉmánt caandíh ĩt wái bac bejep wʉt jĩ. Nazaret tʉ́tchimant wái bac bejnit, tʉ́tchi jwẽ́ejdih bóo jeé tʉ́lʉhna ĩt ʉb bejep wʉt jĩ, caandíh tóo yoh yac bojat tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Obohjeéhtih, Jesúsboó queét cãtíh tac pʉ́ʉd ñʉhnit, biáboó ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nazaret tʉ́tchimant Jesúsdih ĩ bacaat tʉ́ttimah, Capernaum tʉ́tchina ãt dei bejep wʉt jĩ. Capernaum tʉ́tchibʉt Galilea baácdih bóo tʉ́tchi wʉt jĩ. Capernaum tʉ́tchina dei jʉibínit, chooát yeó jáapdih judíowã ĩ míic wáacat mʉʉná ãt jʉibínap wʉt jĩ. Caán mʉʉdíh waád jʉibínit, caanjĩ́h jʉmnitdih Dios naáwátdih ãt bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pánihna, ã wẽp bohénachah, bʉ́dí ĩt joí wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Caanjĩ́h chʉ́ʉdnit biícdih, nemép jʉmnibʉt ãt jʉmʉp wʉt jĩ. Pánihna, Jesús ã bohénachah joinít, nin pah ãt niíj ñaacáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ayó! Jesús, ¡Nazaret tʉ́tchidih bóo jwiítdih tac bʉʉgáca bojoó! ¿Jwiítdih dedé tigaá ma chãjbi? ¿Yoh bacanadih nit beé ma jʉ̃ʉ́wʉ́p? Weém meemdíh wã jéihna caá. Dios ã wahni, chah tʉ́ini caá meém, Jesúsdih ãt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—¡Ma laihca bojoó! ¡Caandíh cádahnit, ma bac bejeé! Jesús nemépdih ãt niijíp wʉt jĩ. Páant ã niíj wʉtʉchah joinít, cã́acwã cãtíh nemépboó caandíh dʉó bʉʉgnít, ãt bac bejep wʉt jĩ. Pánih dʉó bʉʉgná yʉhna, caán newédih ãt yéejacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Páant Jesús ã chãjatdih nihat cã́acwã bʉ́dí ĩt en wʉ́hi bejep wʉt jĩ. —¡En yʉh bʉca! ¡Ã naáwát wẽpép caá! ¡Ã naáwáchahjeh, nemépwã yʉh bʉca caandíh ĩ jepahna caá! ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús páant ã chãjatdih nihat Capernaum tʉ́tchi pebh jʉmnit ĩt míic naóh peetép wʉt jĩ. Bʉ́dí ãt wʉ̃t yáanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Páant ã chãjat tʉ́ttimah, judíowã ĩ míic wáacat mʉʉmánt Jesúswã ĩt bac bejep wʉt jĩ. Bac bejnit, Simóníh mʉʉná ĩt jʉibínap wʉt jĩ. Caanná ĩ waád jʉibínachah, mi íindih tʉbit ã pahachah, Simón áa Jesúsdih mit naáwáp wʉt jĩ. Páant tʉbit ã pahachah, mit lajap wʉt jĩ. “Caántdih ma booanaá”, caán mʉʉdíh jʉmnit Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Páant ĩ niijíchah joinít, Jesús mi pebh jʉibí ñʉhnit, “Ma yayaá”, pahatdih ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, pahat ãt dʉ́ʉcʉp wʉt jĩ. Páant ã dʉ́ʉcʉchah, ñah ñʉhnit, ĩ jeémát pínahdih mit cáagap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tõo ñáh jʉ̃ʉ́wʉ́chah, dawá tʉbʉ́p chʉ̃ʉ́hnitdih Jesús pebhna ĩt ʉb jʉibínap wʉt jĩ. Dawá mácah wʉnat queétdih ãt jʉmʉp wʉt jĩ. Nihat ĩ ʉb jʉibínit wʉnnitdih Jesús ãt teo jã́ha booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dawá nemépwãdihbʉt ãt bacat tʉ́ʉtʉp wʉt jĩ. Páant ã bacat tʉ́ʉtʉchah, —¡Meém Dios wʉ̃ʉ́h caá! tʉbit ĩt niíj ñaacáp wʉt yʉh jĩ. Obohjeéhtih, Jesús queétdih jʉ̃ihnit, “Dios ã wahni caá”, ãt niiját tʉ́ʉtcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Daa jʉ̃ʉ́wʉ́chah, ã íipdih ʉʉ́bát tʉ́ʉt niijná, Jesús cã́ac wihcapboó ãt bejep wʉt jĩ. Obohjeéhtih, cã́acwã caandíh bid bejnit, ĩt jwãááp wʉt jĩ. Jwãáhnit, caandíh ĩjeéh jʉmat náahna, ĩt chãwát tʉ́ʉtʉp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","—Ñijeéh wã jéih chãocán caá. Biíh tʉ́tchinadih moondíhbʉt Dios ã maáh jʉmat doonádih weemdíh naáwát caá náahap. Páant naáwát pínah niijná, Dios weemdíh ã wahap be, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pánihna, nihat Galilea baácboó jib bejnit, judíowã ĩ míic wáacat mʉʉná waadnít, Jesús ãpĩ́ bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Biíh yeó jáap, Jesús Genesaret íim jwẽ́ejdih ñʉhnit, dawá cã́acwãdih Dios naáwátdih naóhna ãt chãjap wʉt jĩ. Caán ã bohéátdih bʉ́dí joííhna, Jesúsdih ĩt tóo péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Páant tʉbit caandíh ĩ tóonachah, Jesús chéne bʉ́dí jãáj chóonadih ãt enep wʉt jĩ. Caanjĩ́h queéj jʉ́ʉt maonit ĩ aabní chóona ãt pahap wʉt jĩ. Queét ĩ́ih jãáj chóona pebh ĩ́ih ñʉonádih chocna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pánihna, biíc chóodih Jesús ãt waadáp wʉt jĩ. Caán chóo mínah Simón wʉt jĩ ã wʉ̃t. Caán chóodih waadnít, “Weemdíh chibít ma tóo pʉ́ʉd baca pahanaá”, ãt niijíp wʉt jĩ. Páant ã tóo pʉ́ʉd baca pahanachah, Jesús caán chóodih chʉ́ʉdnit, cã́acwãdih ãt bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pánih bohé péanit, nin pah Jesús Simóndih ãt niijíp wʉt jĩ: —Íim tac yoób pʉ́ʉd bac bejnit, queejwã́dih mawat tʉ́ʉt niijná, ñíih ñʉonádih ñi yoh báahanaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Bohéní, nihat chei jwĩ jʉ́ʉt mawachah yʉhna, queejwã́ ĩ wihcan beé. Obohjeéhtih, páant ma niijíchah joinít bácah, jwĩ́ih ñʉonádih jwĩ yoh báaha enmi caá, Simón ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Páant niíj péa, íim tac yoób pʉ́ʉd bac bejnit, ĩ́ih ñʉonádih ĩt yoh báahanap wʉt jĩ. Páant ĩ yoh báahanachah, dawá yoobát queejwã́ waadná, ĩ́ih ñʉonádih boloh wáina ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Páant ĩ boloh wáyachah ennit, ĩ pej jʉmnit queét pebh pahnitdih Simón ãt ejep wʉt jĩ: “¡Jwiítdih ñi teo wáac jʉ̃ʉ́wʉ́!” ãt niijíp wʉt jĩ. Pánih teo wáacadih jʉibínit, chénat pah chóo queejwã́dih ĩt ʉb yac yáwanap wʉt jĩ. Dawá queejwã́ jʉmna, ĩ́ih jãáj chóona ãt daábíhip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Páant dawá queejwã́dih ennit, Jesús ã wẽpatdih jéihna, Simón bʉ́dí ãt ʉ́ʉmʉp wʉt jĩ. Pánih ʉ́ʉmna, Jesús pebh bódicha caj yoh ñajnit, Jesúsdih nin pah ãt niijíp wʉt jĩ: —Maá, meém chah wẽpni, tʉ́ini caá. Obohjeéhtih, weémboó yéejni caá. Pánihna, meemdíh wã ʉ́ʉmʉchah, biáboó ma bejeé, ãt niijíp wʉt jĩ. —¡Ma ʉ́ʉmca bojoó! Bʉʉ meém queejwã́dih bid jwʉhni caá. Obohjeéhtih, meemdíh wã tʉ́ʉt nʉʉmʉ́chah, queejwã́dih ma bidat pah mʉntih, cã́acwãboodíh bidnit, wĩ́ih doonádih ma naóhbipna caá, weemdíh jepahna, wĩ́ihwã ĩ jʉmat pínah niijná, Jesús caandíh ãt niijíp wʉt jĩ. Simón ã ʉ́ʉmat biíc yoobó ã pej jʉmnitbʉt ĩt ʉ́ʉmʉp wʉt jĩ. Santiago, Juan wʉt jĩ ã pej jʉmnit. Queét chénewã Zebedeo weh wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pánihna, jwʉ́ʉb ñáan jʉibínit, queét nihat ĩ́ih tewatdih cádahnit, Jesúsjeéh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús biíh tʉ́tchiboó ã jʉmʉchah, bácah moópni ã pebh ãt jʉibínap wʉt jĩ. Pánih jʉibíni Jesúsdih ennit, ã wẽpatdih jéihna, páah yoh ñajnit, nin pah ãt niíj ʉʉ́bʉ́p wʉt jĩ: —Maá, ma booaíhna, weemdíh ma jéih booana caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Páant ã niijíchah joinít, Jesús caandíh teo jã́hanit, —¡Jʉ́ʉ! Wẽinit, meemdíh wã booana caá, ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, moopát nihat ãt ñʉʉmáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pánihna, Jesús caandíh nin pah ãt wẽp niíj naáwáp wʉt yʉh jĩ: —Bitadih naóhcanjeh, sacerdotedih míih bácah ã jwʉ́ʉb ñʉʉmátdih jʉ́ʉtʉdih ma bejeé. Moisés ã wʉtatji pah sacerdotewã ĩ cáo wʉ̃hat pínah niijná, chéne jopwãdih ma wʉ̃hʉʉ́, Dios meemdíh ã booaatjidih ĩ jéihyat pínah niijná, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Obohjeéhtih, páant ã niijíchah joiná yʉhna, bejnit, dawá cã́acwãdih ãt naóh peetép wʉt jĩ. Páant Jesús ã chãjat dooná chah ãt wʉ̃t yáanap wʉt jĩ. Caán doonádih joinít, ã naáwátdih joyát tʉ́ʉt niijná, ĩ wʉnatdihbʉt ã booaat pínah niijná, dawá ã pebhna ĩpĩ́ wáac jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Obohjeéhtih, Jesús cã́ac wihcapboó, ã íipdih ʉʉ́bʉ́dih ãpĩ́ bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Biíh yeó jáap Jesús cã́acwãdih ã bohénachah, fariseowã, Moisés ã wʉtatjidih bohénitbʉt ĩt joí chʉ́ʉdʉp wʉt jĩ. Queét Galilea baácmant, Judea baácmant, Jerusalén tʉ́tchimantbʉt bejnit, ĩtát jʉibínap wʉt jĩ. Jesús ã bohénachah, dawá joiná ĩt chãjap wʉt jĩ. Dios cã́acwãdih booaat wẽpatbʉt Jesúsdih bʉ́dí ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Páant ã bohénachah, biquína neoná jéih yoocannidih ã lajat chóojĩh Jesús pebh ĩtih beo waad béj jwejíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Obohjeéhtih, dawá mʉʉdíh ĩ yáo yapachah ennit, chah bóo coahna caandíh ĩt beo pʉ́ʉh laab béjep wʉt jĩ. Pánih pʉ́ʉh laáb jʉibínit, biquína jeé naanádih ʉb jwej, íit chãjnit, jéih yoocannidih ã lajat chóojĩh Jesús pebh ĩt cádah deyanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pánihna, caán ã booaat wẽpatdih ĩ jenah joyátdih jéihnit, Jesús caán jéih yoocannidih nin pah ãt niijíp wʉt jĩ: —Ma yéejatdih wã yohna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Páant ã niijíchah joinít, Moisés ã wʉtatjidih bohénit, fariseowãbʉt íijnit, queétjeh nin pah ĩt niíj jenah joyóp wʉt jĩ: “¿Dedé cã́ac tigaá nin? Diosjeh yéejatdih ã jéih yohna caá. Pánihna, ninboó cã́acjeh jʉmna yʉhna, ‘Ma yéejatdih wã yohna caá’, niijná, ‘Dios wã jʉmna caá’, niíj yeena caá ã chãjap”, queétjeh ĩt niíj jenah joyóp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","24","Páant ĩ niíj jenah joyóchah jéihnit, Jesús queétdih nin pah ãt niíj naáwáp wʉt jĩ: —¿Dépanih tigaá páant yeejép ñi niíj jenah joí? ‘Ma yéejatdih wã yohna caá’, wã niijíchah joinít, weemdíh jéihcan yʉhna, ‘Yeeni caá’, ñi niíj jenah joiná caá. Obohjeéhtih, ‘Ma ñah ñʉhʉʉ́. Ma ñajatdih ʉbnit, ma yáac chʉ̃i bejeé’, wã niijíchah, caán ã bejechah ennit, wã niiját yoobópdih ã jʉmatdih ñi jéihbipna caá. Pánih jéihna, yéejat yohat wẽpat wã bíbohatdihbʉt ñi jéihbipna caá. Weém nihat cã́acwã ʉ́ʉd jeñé, Dios ã wahni nin baácdih moondíh jéih booanit, ĩ yéej chãjatdihbʉt wã jéih yohna caá. Páant wã jéih yohatdih yeéb ñi jéihyat pínah niijná, nin pah wã chãj jʉ́ʉtbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. Páant niíj péanit, jéih yoocannidih nin pah ãt niijíp wʉt jĩ: —Ma ñah ñʉhʉʉ́. Ma ñajat chóodih ʉbnit, míih mʉʉ́boó ma jwʉ́ʉb bejeé, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Páant ã niijíchahjeh, nihat ĩ enechah, jéih yoocanniji ñah ñʉh, ã ñajat chóodih ʉbnit, ã́ih mʉʉ́boó ãt jwʉ́ʉb bac bejep wʉt jĩ. Pánih bejnit, Diosdih bʉ́dí ãt wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Páant ã bac bejechah, nihat en wʉ́hi bej, bʉ́dí jenah joinít, queétbʉt biíc yoobó Diosdih ĩt wẽi naáwáp wʉt jĩ. —¡En yʉh bʉca! Bʉ́dí náhniat pínahdih bʉʉ jwĩ enna caá, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pánihat tʉ́ttimah, Jesúswã caán tʉ́tchidih jʉmnitji bac bejnit, biíh tʉ́tchina ĩt bejep wʉt jĩ. Caán ĩ bejni namá jwẽ́ejdih Leví wʉ̃t jʉmni ã tewat tólihboó ãt chʉ́ʉdʉp wʉt jĩ. Caán Romanowã maáta ĩ ʉʉ́bát tʉ́ʉtni nʉ́odih ʉʉ́bh wʉ̃hni ãt jʉmʉp wʉt jĩ. Pánihna, Levídih ennit, nin pah caandíh Jesús ãt niijíp wʉt jĩ: —Wãjeéh ma pée jʉ̃ʉ́wʉ́, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Páant ã niijíchah joinít, ñah ñʉh, ã́ih tewatdih cádahnit, Jesúsjeéh ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pánihat tʉ́ttimah, Leví ã́ih mʉʉ́boó Jesúswãdih ãt nʉmah jeémép wʉt jĩ. Caán ã nihat pah dawá nʉ́odih ʉʉ́bh wʉ̃hnitdih, bita ã chéenwãdihbʉt ãt nʉmah jeémép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Páant Jesúswã ĩjeéh ĩ jeéméchah ennit, fariseowã, Moisés ã wʉtatjidih bohénitbʉt queétdih ĩt íijip wʉt jĩ. Íijnit, Jesús ã bohénitdih nin pah ĩt niíj jʉ̃ihñʉp wʉt jĩ: —¿Dépanihna queét dinero nʉʉmnítjeéh, yéej chãjnitjeéhbʉt jeémp babh tigaá ñi chãj? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Páant queétdih ĩ niijíchah joinít, Jesúsboó nin pah ãt niíj jepahap wʉt jĩ: —Tʉbʉ́p chʉ̃ʉ́hcannit cohnidih ĩpĩ́ bidcan caá. Wʉnnitjeh caá caandíh ĩ bidip. ");
INSERT INTO cbv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pánihat pah ‘Weém yéejat wihcanni caá’, niíj jenah joinít, teo wáacni pínahdih ĩpĩ́ bidcan caá. Obohjeéhtih, ‘Wã yéejatdih jĩ́gahnit, wã tʉ́ʉt nʉʉ́míhna caá’, niíj jenah joinít caá teo wáacni pínahdih ĩ bidip. Pánihna, ‘Yeejépwã caá jwiít’, niíj jenah joinítdihjeh teo wáacadih wã jʉ̃ʉ́wʉ́p be, ĩ yéej chãjatdih jĩ́gahnit, tʉ́iniboodíh ĩ tʉ́ʉt nʉʉmát pínah niijná, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Páant queétdih ã niiját tʉ́ttimah, queét Jesúsdih nin pah ĩt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ: —Dios ã wʉtat pah jwĩ nʉowã ĩpĩ́ jeémp jwʉhcap jĩ. Juan ã bohénitbʉt, fariseowã ĩ bohénitbʉt páant ĩ chãjna caá. ¿Dépanihna ma bohénitboó páantjeh ĩ jeémp? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","—Nin pah caá ã jʉmʉp: Téihya chéoni ã nʉmah jeémpnit biícdih ã jʉm jwʉhʉchah, jĩ́gahcan, ĩpĩ́ tʉ́i wẽi jeémpna caá. Páant tigaá, wãjeéh jʉm jwʉhna, wã bohénit ĩ tʉ́i wẽi jeémpna caá. ");
INSERT INTO cbv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Obohjeéhtih, bita caandíh ĩ ʉb bejat tʉ́ttimah, ã chéenwã jĩ́gahnit, ĩ jeémp jwʉhcan niít. Pánihat pah bita weemdíh ĩ ʉb bejat tʉ́ttimah bácah, wã bohénitjeéh wã wihcah, queétbʉt ĩ jeémp jwʉhcan niít, Jesús queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ded pah jwĩ jeémp jwʉhcatdih jwĩ nʉowã ĩ wʉtatdih, ã́ih jáap bohéátjĩh fariseowã ĩ widíhichah enna, Jesús queétdih nin pah ãt jwʉ́ʉb niíj bohénap wʉt jĩ: —Jáap yégueh chóo chocca naáh chóojĩh máa yégueh chóodih nah wai bʉ́ʉdhdat ã náahcan caá. Páant ñi chãjachah nihna, caandíh ñi chocat tʉ́ttimah, jiínt bejna, máa chóodih chah ãta yewa tagaá. Páant tigaá, jwĩ nʉowã ĩ naáwátjidih, wĩ́ih jáap bohéátjĩh wid naóhcat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pánihat dée, pah jwʉhcanni iguíh macdih nʉñʉ́p chóojĩh ĩ chãjniji máa wʉh wʉʉ́hdih yáacat ã náahcan caá. Páant ñi yáacachah nihna, iguíh mac pahna, máa wʉh wʉʉ́h jéih yʉ́ʉhcan, ãta yewah bej tagaá. Páant ã yewechah, chénat pah ãta bʉʉd tágaá. ");
INSERT INTO cbv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pánihna, jáap macdih, jáap wʉh wʉʉ́hboó yáacat caá náahap. Páant ñi yáacachah, iguíh mac, caandíh yáacni chóobʉt ã tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Obohjeéhtih, ded máa iguíh macdih ã babhbat tʉ́ttimah, pah jwʉhcanni macdih babhbíhcan, ‘Máa mac chah tʉ́ini beé’, ã niijbípna caá. Pánihat pah cã́acwã wã jáap bohéátdih náahcan, ‘Jwĩ nʉowã ĩ bohéátjiboó chah ã tʉ́yʉp be’, ĩ niijbípna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Biíc chooát yeó jáapdih Jesús ã bohénitdih bohé bejna, trigo wáapdih ãt nʉmah chóop yap bejep wʉt jĩ. Pánih bejna, ã bohénit trigodih ʉ́ʉcnit, ã́ih chóodih jẽqué yohnit, ĩt jeémp bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Páant ĩ chãjachah ennit, biquína ĩjeéh bejnit fariseowã íijnit, Jesúsdih nin pah ĩt niíj jʉ̃ihñʉp wʉt jĩ: —¿Dépanih tigaá jwĩ chooát yeó jáapdih yʉhna, ma bohénit ĩ teo? Pánih teona, Dios ã wʉtatdih yap yohna caá ĩ chãjap, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Páant ĩ niijíchah joinít, “Wã bohénit ĩ yap yohcan caá”, niiját tʉ́ʉt niijná, Jesús queétdih nin pah ãt niíj jepahap wʉt jĩ: —Davidji ã bohénit biícdih nʉʉgʉ́p wʉnna, Dioíh mʉʉná waadnít, sacerdotewã Diosdih ĩ wʉ̃hniji pandih ãt jeémép wʉt jĩ. Pánih jeémpna, ã bohénitdihbʉt ãt wʉ̃hʉp wʉt jĩ. Obohjeéhtih, caán pan sacerdotewãjeh ĩ jeémát pínah ãt jʉmʉp wʉt jĩ. Dios wʉtna, bitadih caán pandih ãt jeémát tʉ́ʉtcap wʉt jĩ. ¿Davidwã páant ĩ chãjatjidih Dios naáwátdih ĩ daácni nʉ́odih ñi bohécannit jĩí? Caán pandih ĩ jeéméchah yʉhna, Diosboó ‘Ñi tʉ́i chãjcan beé’, ãt niijcáp tajĩ.Pánihat pah, bʉʉ nin trigodih ʉ́ʉc jeémpna, wã bohénitbʉt Diosdih ĩ yap yohcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Weém, nihat cã́acwã ʉ́ʉd jeñé, chooát yeó jáapdih ded pah ĩ chãjat pínahdih wã jéih wʉtna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Biíh chooát yeó jáapdih Jesús judíowã ĩ míic wáacat mʉʉná waadnít, ã bohénachah, caandíh joinít cã́acwã cãtíh téihya ágahni ãt jʉmʉp wʉt jĩ. Ã́ih jéihyepmant bóo mʉj nah ãt ágahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés ã wʉtatjidih bohénit, fariseowãbʉt Jesúsdih ĩt en ñʉʉnʉ́p wʉt jĩ. Chooát yeó jáapdih yʉhna, Jesús téihya ágahnidih ã booanachah, caandíh naóh yacat tʉ́ʉt niijná, eníhna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Obohjeéhtih, Jesús páant ĩ jenah joyátdih jéihnit, téihya ágahnidih nin pah ãt niijíp wʉt jĩ: —Ñah ñʉhnit, nit cãtíh ma jʉí ñʉhʉʉ́, ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ñah ñʉhnit, queét cãtíh ãt jʉibí ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pánihna, caandíh naóh yaquíhnitdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Yeéb ñi jenah joyóchah, ¿jwĩ chooát yeó jáapdih Dios jwiítdih ded pah tigaá ã wʉt? ¿Tʉ́i chãjatdih niít ã wʉtʉp? ¿Yeejép chãjatdih niít ã wʉtʉp? ¿Wʉnnidih ã booat tʉ́ʉt niít? ¿Cã́acdih ã mao yohat tʉ́ʉt niít? Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Páant niijnít, ĩ jepahatdih pã́ina, Jesús queét nihatdih ãt en behep wʉt jĩ. Ĩ jepahcah ennit, téihya ágahniboodíh nin pah ãt niijíp wʉt jĩ: —Míih téihyadih ma yoo dʉwʉʉ́, ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ã́ih téihyadih ãt yoo dʉwʉ́p wʉt jĩ. Páant ã yoo dʉwʉ́chahjeh, ã́ih téihya ãt tʉ́yah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Obohjeéhtih, queét Jesúsdih naóh yaquíhnitboó caandíh ã booaatdih ennit, bʉ́dí ĩt íijip wʉt jĩ. Pánih íijnit, nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: “¿Ded pah tigaá caandíh chãjat náah?” ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pánihat tʉ́ttimah, biíh yeó jáap Jesús jeéboó Diosdih ʉʉ́bʉ́dih ãt bejep wʉt jĩ. Nihat chei ãt ʉʉ́bh daa jʉ̃ʉ́wʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Daanachah, ã naáwátdih joí péenitdih bid bojnit, doce ã bohé bejnit pínahdih ãt ñíwip wʉt jĩ, ã́ih doonádih naóhnit ĩ jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nit wʉt jĩ ã ñíonit: Simóndih ñíonit, Pedro ã wʉ̃t ãt bʉ́ʉdhdʉp wʉt jĩ. Simón ʉ́ʉd Andrésdihbʉt ãt ñíwip wʉt jĩ. Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO cbv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomásdihbʉt ãt ñíwip wʉt jĩ. Biíh Santiago Alfeo wʉ̃ʉ́hdih ñío, biíh Simón Celote poómpdih bóodih ñío, ");
INSERT INTO cbv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas biíh Santiago wʉ̃ʉ́hdih ñío, Judas Iscariote Jesúsdih eníhcannitdih dʉó wáini pínahdihbʉt ãt ñíwip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pánih ñío péa jwʉ́ʉb dei jʉ̃óhnit, jeé ñaj yacapboó ãt chão ñʉ́hʉp wʉt jĩ. Páant ã chão ñʉ́hʉpboó ã naáwátdih dawá joí péenit jʉm, dawá bitabʉt ĩt jʉmʉp wʉt jĩ. Queét jʉmnit Judea baácdih moón, Jerusalén tʉ́tchidih moón, bʉ́dí mʉj jwẽ́ejdih jʉmni Tiro tʉ́tchi, Sidón tʉ́tchidih moonbʉ́t ĩt jʉibínap wʉt jĩ, ");
INSERT INTO cbv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús ã bohénachah joyát tʉ́ʉt niijná, ĩ wʉnatnadihbʉt ã booaat pínah niijná. Nemép jʉmnitbʉt ĩt jʉibínap wʉt jĩ, nemépwãdih ã bacat tʉ́ʉtat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Booat tʉ́ʉt niijná, queét nihat Jesúsdih ĩt jʉibí tewíhip wʉt jĩ. Caandíh ĩ jʉibí teonitdih ã wẽpat ã chʉ̃ʉ́ʉ́chah, nihat ĩt boonap wʉt jĩ. Pánihna, wʉnnitjibʉt, nemép jʉmnitjibʉt ĩt tʉ́i jʉmʉp wʉt jĩ, bʉca. ");
INSERT INTO cbv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús ã bohénitdih ennit, nin pah queétdih ãt niíj bohénap wʉt jĩ: “Yeéb moh yéejnit panihnit Dios ã teo wáacatdih bidnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, yeebdíh ã teo wáacbipna caá, Dios ã maáh jʉmʉpboó ñi tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Yeéb bʉʉ nʉʉgʉ́p wʉnnit panihnitdih Dios ã wẽi enna caá. Pánih wẽi ennit, yeebdíh ã teo wáacbipna caá, wʉd jʉmnit pah ñi tʉ́i jʉmat pínah niijná. “Bʉʉ yeéb jʉ̃inítdih Dios ã wẽi enna caá. Pánih wẽi ennit, ã teo wáacbipna caá, ñi tʉ́i weñat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Weém nihat cã́acwã ʉ́ʉd jeñédih ñi jepahat jíib bita yeebdíh eníhcan, yeejép naóhnit, ĩ́ih poómpmant ĩ bacanachah, Diosboó yeebdíh wẽi ennit, ã teo wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Páant ñi yapachah yʉhna, caandíh ñi cádahcatji jíib Dios pebhboó ñi jʉibínachah, tʉ́inidih ã wʉ̃hat pínahdih jenah joinít, ñaáp ñahnit, bʉ́dí ñi weñeé. Pánih chãjnit ĩ nʉowãbʉt Dios naáwátdih naóh yapanitjidih biíc yoobó yeejép ĩt chãjap wʉt jĩ. Páant queétdih ã yapat pahjeh mʉntih yeebdíhbʉt yeejép ã yapachah yʉhna, ñi weñeé. ");
INSERT INTO cbv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Obohjeéhtih, yeéb dawá bií dée bíbohnit, Dios ã teo wáacatdih bidcannit, bʉʉ nin baácboó jʉmna pohba ñi wẽina yʉh caá. Tʉ́ttimah, Dios ã peéh chãjachah, bʉ́dí moh yéejnit ñi jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Bita yeebbʉ́t bʉʉ dedé ñi náahatdih bíbohnit, wʉd jʉmnit panihnit ñi jʉmna caá. Obohjeéhtih, tʉ́ttimah, Dios ã peéh chãjachah, tʉb nʉʉgʉ́p wʉnnit panihnit, bʉ́dí moh yéejnit ñi jʉmbipna caá. “Bita yeebbʉ́t ñi weñat pínahdihjeh chãjnit, bʉʉ bʉ́dí wẽi jwʉhnitji, Dios ã peéh chãjachah, bʉ́dí ñi jʉ̃ibípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Diosdih jepahcannitboó yeebdíh ĩ tʉ́i wẽi naáwáchah, ¡ñi tʉ́i chãja chaáh! Pánihat dée pah jon jã́tih ĩ nʉowãbʉt ‘Dios naáwátdih naóh yapanit caá’, niijná yʉhna, yee naóhnitboodíh ĩpĩ́ tʉ́i wẽi naáwáp wʉt jĩ. Pánihna, ñi tʉ́ʉt nʉʉmcáh, Dios yeebdíhbʉt ã peéh chãjbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Obohjeéhtih, yeéb weemdíh joinítdih nin pah wã naóhna caá: Yeebdíh eníhcannitdih oinit, ñi tʉ́i chãjaá. ");
INSERT INTO cbv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","‘Meemdíh yeejép ã yapa naáh’, yeebdíh niijnítdih, ‘Dios meemdíh ã tʉ́i chãja naáh’, ñi niíj jwʉ́ʉbanaá. Yeebdíh yeejép chãjnitdih, Diosdih ñi ʉʉ́bʉ́, queétdih ã teo wáacat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yeebdíh íijnit, biíc bʉwá pʉ́o tíibdih maonidih, biíh bʉwámantbʉt ñi jʉ́ʉtʉ́, mawíhna, ã jwʉ́ʉb mawat pínah niijná. Ñíih cʉ́bʉh jweyát chóodih dʉ́ʉc wáinidih, ã náahachah, ñíih japih bóo chóodihbʉt ñi wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ded moh yéejni ã náahatdih ã ʉʉ́bʉ́chah, ñi wʉ̃hʉʉ́. Ded ñíih bií déedih dʉ́ʉc wáinidih, ñi jwʉ́ʉbaat tʉ́ʉtca bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bita yeebdíh ĩ tʉ́i chãjat pínahdih ñi náahat pah, yeebbʉ́t bitadih ñi tʉ́i chãjaá. Queét yeebdíh ĩ tʉ́i chãjcah yʉhna, yeébboó queétdih ñi tʉ́i chãjaá. ");
INSERT INTO cbv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Yeebdíh oinitdihjeh ñi oi jwʉ́ʉbanachah, dedé pínah nihcan caá. Diosdih jéihcannitboó queétdih oinitdihjeh ĩpĩ́ oi jwʉ́ʉbana caá. Pánihna, queét ĩ oyat chah yeébboodíh bitadih oyat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yeebdíh tʉ́i chãjnitdihjeh ñi tʉ́i chãj jwʉ́ʉbanachah, dedé pínah nihcan caá. Diosdih jéihcannit biíc yoobó ĩ chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‘Wã wayát pah bóo ã jwʉ́ʉbabipna caá’, niíj jenah joinít, nʉ́odih ñi wayáchah, dedé pínah nihcan caá. Yeejépwã yʉhna, bitadih páant ĩpĩ́ wainá caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Obohjeéhtih, yeebdíh eníhcannitdih ñi oyoó. Ĩ tʉ́i chãj jwʉ́ʉbaat pínahdih bidcanjeh, tʉ́inidih ñi chãjaá. Nʉ́odih náahnit ĩ ʉʉ́bʉ́chah, ĩ jwʉ́ʉbaat pínahdih bidcanjeh, ñi wayaá. Pánih chãjna, Dios weh ñi jʉmʉchah, ‘Ma tʉ́i chãjna beé’, niijnít, caánboó yeebdíh tʉ́ini ã wʉ̃hbipna caá. Caandíh ‘Tʉ́ina caá’, niijcánnitdih, yeejép chãjnitdihbʉt Diosboó ã tʉ́i chãjna caá. Páant ã chãjat pah biíc yoobó ñi chãjat pínahdih yeebdíh ã wʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dios jwĩ íip yeebdíh jĩ́gah ennit, ã teo wáacat pahjeh mʉntih, yeebbʉ́t bitadih jĩ́gah ennit, ñi teo wáacá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ ‘Meém yeejép caá’, bitadih ñi niijcá bojoó. Páant ñi niijcáh, Dios yeebdíhbʉt ‘Meém yeejép caá’, ã niijcán niít. Bita ĩ yéej chãjachah, ‘Meemdíh peéh chãjat caá náahap’, ñi niijcá bojoó. Páant ñi niijíchah nihna, Diosbʉt yeebdíh biíc yoobó ãta niij tágaá. Bita ĩ yéejatdih ñi náhnica bojoó. Páant ñi náhnicah, Diosbʉt ñi yéejatdih ã náhnican niít. ");
INSERT INTO cbv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bitadih ñi tʉ́i wʉ̃hʉʉ́. Ñi tʉ́i wʉ̃hʉchah, Diosbʉt yeebdíh ã tʉ́i wʉ̃hbipna caá. Bʉ́dí béguepdih becchidih jʉi cáj waó bíi chãjat dée ã wʉ̃hbipna caá. Ded pah yeéb bitadih ñi wʉ̃hat pah bóojeh mʉntih, Diosbʉt yeebdíh ã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“Jéih encanni biíh jéih encannidih ã dʉó wáyachah, íit jʉmʉpboó bejna, queét chénat pah biícdih ĩ bʉʉg yácbipna caá ");
INSERT INTO cbv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jáap bohéni caandíh bohéni chah ã jéihcan caá. Obohjeéhtih, nihat ã jéihyat pínahdih ã bohé péanit, caandíh bohénidih biíc yoobó ã jéihbipna caá. Pánihna, yeéb bitadih dʉó wáiíhna, wã naáwátdih jwíih tʉ́i bohéát caá náahap, jéih encannit dée ñi jʉmcat pínah niijná. Pánihna, wã naáwátdih tʉ́i jéihnit, wã bohéát pah mʉntih bitadihbʉt ñi tʉ́i jéih bohébipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nin pah yeéb ñipĩ́ chãjna caá: Ñi déedih bainí quíib becát ã jʉmʉchah, caanbítdih ñi tʉ́i enna caá. Caán bainí oj ã jʉmʉchah yʉhna, ñi enat pah, ñi dée ã yéejatbitdih ñipĩ́ enna caá. Obohjeéhtih, yeebdíh bʉ́dí quíib becát ã jʉmʉchah yʉhna, caandíh ñi jéih encan caá. Caandíh ñi jéih encat pah, bʉ́dí yeejép chãjna yʉhna, ñi míic jéih encan caá. ¿Dépanih tigaá páant ñi chãj? ");
INSERT INTO cbv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Yeebdíh bʉ́dí quíib becát panihni ã jʉmʉchah yʉhna, ‘Némé, ma quíib becátdih weémboó meemdíh wã póoj yohbipna caá’, ñipĩ́ niijná caá. Pánihat pah, bʉ́dí yéej chãjnit jʉmna yʉhna, ‘Némé, tʉbit yeejép chãjna caá ma chãjap. Caandíh ma cádahaá’, ñipĩ́ niijná caá. ¿Dépanih tigaá yeéb yeejép chãjnit jʉmna yʉhna, bʉ́dí ñi yéej chãjatdih jenah joicánjeh, bita bainí ĩ yéej chãjatdihjeh ñi jenah joí? Yeéb yeejépwãá, ñi yéej chãjatdih jwíih cádahat caá náahap. Páant ñi tʉ́ʉt nʉʉmát tʉ́ttimah, ñi dée ã yéejatdih ñi jéih cádahat tʉ́ʉtbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ded tʉ́ini nah yeejép dahna ã quehcah, yeejép nahbʉt tʉ́ini dahna ãpĩ́ quehcan caá ");
INSERT INTO cbv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pánihna, ded pah máa nahna ã jʉmatdih jéihíhna, ã́ih quehe dahnadih enat caá náahap. Nemép óot nahdih higo wʉ̃t jʉmni dahnadih ñipĩ́ bidcan caá. Ei náhdih iguíh ñipĩ́ bidcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pánihat dée pah tʉ́ini cã́ac ã tʉ́i jenah joyát jíib, tʉ́inijeh ã naóhbipna caá. Obohjeéhtih, yeejép cã́ac yeejép ã jenah joyát jíib, yeejépjeh ã wéhebipna caá. Pánihna, cã́ac ded pah ã jenah joyát biíc yoobó ã naóhbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Dépanihna, ‘Maá’, weemdíh niijná yʉhna, wã wʉtatdih ñi jepahcan? ");
INSERT INTO cbv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ded wã bohéátdih joinít, jepahna, nin pah ã jʉmna caá: ");
INSERT INTO cbv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mʉʉ́ chãj pooni panihni ã jʉmna caá. Tʉ́i jenah joiní jwʉmʉ́p baácdih nʉmah baád waadánit, ã́ih jagápdih ã tʉ́i dodhdop be. Pánih chãj péaat tʉ́ttimah, mʉj daabáchah yʉhna, ã́ih mʉʉ́ tʉ́i chãjni jʉmna, ã mónócap be. ");
INSERT INTO cbv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Obohjeéhtih, ded wã bohéátdih joiná yʉhna, jepahcanni tʉ́i jenah joicánni mʉʉ́ chãjni panihni caá ã jʉmʉp. Caánboó óon jihbitjeh baád waadánit, ã́ih jagápdih ã dodhdop be. Pánihna, caán mʉʉdíh ã péaat tʉ́ttimah, mʉj ã jwíih daabáchah, ã́ih mʉʉ́ tʉ́i chãjni nihcah, chéwat boloh bejnit, ã́ac bejna, ã boto peetáh bejep be”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Páant cã́acwãdih bohé péanit, Jesús Capernaum tʉ́tchiboó ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Romano cien soldadowã ĩ maáh Capernaum tʉ́tchidih ãt jʉmʉp wʉt jĩ. Caandíh teo wʉ̃hni ã oini bʉ́dí wʉnna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pánihna, Jesús ã jʉibíát doonádih joinít, judíowã ĩ maátadih Jesús pebhna ãt wahap wʉt jĩ, caandíh teo wʉ̃hnidih booanadih ã bejat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Páant ã wahachah, judíowã ĩ maáta Jesús pebhna jʉibínit, bʉ́dí ʉʉ́bhna, nin pah ĩt niíj naáwáp wʉt jĩ: —Jwiítdih wahni tʉ́ini caá. Jwiít judíowãdih tʉ́i oinit, jwĩ míic wáacat mʉʉdíh chãjat pínah dinero ã wʉ̃hʉp jĩ. Páant ã tʉ́i chãjat jíib, caandíh ma teo wáac jʉ̃ʉ́wʉ́, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Páant ĩ niijíchah joinít, Jesús ĩjeéh ãt bejep wʉt jĩ. Pánih bejnit, cien soldadowã ĩ maáh pebhna ĩ tóah jʉibínachah, caán bita ã chéenwãdih wahnit, nin pah ãt niíj naáwát tʉ́ʉtʉp wʉt jĩ: “Maá, weem cháh wẽpni ma jʉmʉchah jéihna, ma pebhna jʉibícan, ‘Wĩ́ih mʉʉdíh ma waád jʉ̃ʉ́wʉ́’, niijní dée nihcan caá. Meemdíh wã tac bʉʉgáíhcan caá. Pánihna, yʉʉ́pmahjeh jʉmna, ma wẽpatjĩh weemdíh teo wʉ̃hnidih ma booanaá. ");
INSERT INTO cbv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wã chah jʉmnit bita maáta weemdíh ĩ wʉtna caá. Weembʉ́t soldadowãdih wʉtni caá. Biícdih ‘Ma bejeé’, wã niijíchah, ãpĩ́ bejna caá. Biíhdih ‘Ma jʉ̃ʉ́wʉ́’, wã niijíchah, ãpĩ́ jʉ̃óhna caá. ‘Nindih ma chãjaá’, weemdíh teo wʉ̃hnidih wã niijíchah, ãpĩ́ chãjna caá. Pánihna, ma wʉtat wẽpatdihbʉt wã tʉ́i jéihna caá. Ma wʉtʉchahjeh, weemdíh teo wʉ̃hni ã boobipna caá”, cien soldadowã ĩ maáh ã chéenwã Jesúsdih ĩt niíj naóh yapanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Páant ĩ niijíchah joinít, caán soldadowã ĩ maáh “Jesús caandíh ã booabipna caá”, ã niíj jenah joyátdih jéihnit, Jesús bʉ́dí ãt weñep wʉt jĩ. Pánih wẽinit, ãjeéh péenitdih tac pʉ́ʉd ennit, nin pah queétdih ãt niijíp wʉt jĩ: —Caán soldadowã ĩ maáh judío nihcan yʉhna, weemdíh ã tʉ́i jenah joyát yeéb judíowãboodíh ã yapna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pánihna, soldadowã ĩ maáh ã wahnitji ã́ih mʉʉdíh ĩ jwʉ́ʉb jʉibínachah, caandíh teo wʉ̃hni booni ãtát jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tʉ́ttimah, Naín wʉ̃t jʉmni tʉ́tchina Jesúswã ĩt bejep wʉt jĩ. Dawá cã́acwãbʉt ĩjeéh ĩt péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pánih bejnit, Naín tʉ́tchi jẽc pebh ĩ tóah jʉibínachah, caán tʉ́tchidih moón wʉnni bácahjidih yohat tʉ́ʉt niijná, caandíh ĩ ʉb bac jʉ̃ʉ́wʉ́chah, Jesúswã queétdih ĩt jwãááp wʉt jĩ. Beh wili éemp wʉnnih mit jʉmʉp wʉt jĩ. Mi wʉ̃ʉ́h biíc jʉmni ãt wʉnʉp wʉt jĩ. Dawá cã́acwãbʉt mijeéh ĩt ñʉʉn bác jʉ̃ʉ́wʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Páant ĩ jʉ̃ʉ́wʉ́chah ennit, Jesús caántdih jĩ́gah ennit, nin pah ãt niijíp wʉt jĩ: —Ma jʉ̃icá bojoó, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Páant niijnít, wʉnni ã́ih bácahji lajni naadíh ã tewechah, caandíh beonit ĩt chão ñʉ́hʉp wʉt jĩ. Pánih teonit, “¡Némé, ma boo pʉd jʉ̃ʉ́wʉ́!” wʉnnidih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Páant ã niijíchahjeh, wʉnniji jwʉ́ʉb boo pʉd chʉ́ʉdnit, ãt wéhenap wʉt jĩ. Páant ã boonachah, Jesús beh wilidih nin pah ãt niijíp wʉt jĩ: —Dáa, ma wʉ̃ʉ́h ã jwʉ́ʉb boona caá, páant mʉntih, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Páant ã booanachah enna, nihat cã́acwã wʉ́hi bejnit, Diosdih bʉ́dí ĩt weñep wʉt jĩ. —Dios naáwátdih wẽp naóh yapani ãt jʉi tágaá. Dios jwiít ã́ih cã́acwãdih teo wáacadih ãt jʉi tágaá, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Páant ã chãjatji doonádih nihat Judea baác, pebhbit jʉmni baácnadihbʉt ĩt naóh peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús páant ã chãjatji dooná Juan Daabánidihbʉt ãt jʉibínap wʉt jĩ. Caán nemat mʉʉ́boó ã jʉmʉchah, ã bohénit caandíh ĩt jʉibí naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Páant ĩ naáwáchah joinít, chénewã ã bohénitdih Jesús pebhna ãt wahap wʉt jĩ. “¿Meém Dios ã wahni, jwiít judíowã jwĩ pã́ini niít? ¿Biíhdih bidat niít náahap?” queétdih ãt niíj ʉʉ́bh joyát tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Páant ã niijíchah joinít, Jesús pebhna ĩt bejep wʉt jĩ. Caanná jʉibínit, Jesúsdih nin pah ĩt niijíp wʉt jĩ: —Juan Daabáni jwiítdih wahnit, nin pah ã niíj ʉʉ́bh joyát tʉ́ʉtʉp be: ‘¿Meém Dios ã wahni, jwiít judíowã jwĩ pã́ini niít? ¿Biíhdih bidat niít náahap?’ jwiítdih ã niiját tʉ́ʉtʉp be, Jesúsdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ĩ jʉibínachahjeh, Jesús dawá cã́acwãdih booana ãt chãjap wʉt jĩ. Nemép jʉmnitdihbʉt booa, dawá jéih encannitdihbʉt ãt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Juan ã wahnit ĩ niijíchah joinít, nin pah Jesús queétdih ãt niíj jepahap wʉt jĩ: —Ded pah ñi enatji, ñi joyátjidihbʉt Juandih naáwádih ñi bejeé. ‘Jéih encannitji, jéih joicánnitji, jéih bejcannitjidihbʉt ã booana beé. Bácah moópnitji, wʉnah bejnitjidih yʉh bʉca ã booanap be.Moh yéejnitdih ã tʉ́i ʉbat pínah doonádihbʉt naóhna ã chãjap be. ");
INSERT INTO cbv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“¡Ded weemdíh tʉ́i jenah joí cádahcanidih Dios ã wẽi enna caá!” Jesús ã niijíp be’, Juandih niíj naáwádih ñi bejeé, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan ã wahnitji ĩ jwʉ́ʉb bejat tʉ́ttimah, Juan ded pah ã jʉmatdih cã́acwãdih nin pah Jesús ãt niíj naáwáp wʉt jĩ: “¿Dedédih enedih bej tigaá ñipĩ́ chãj, mʉʉ́ wihcapboó bejna? ¿Jiwi jeémp yílip déedih johlit ã joh jwejni panihnidih enedih ñi bejnit beé? Obohjeéhtih, Juan pánihcan beé. Det biáboó ĩ naáwáchah yʉhna, caánboó jweéhcanjeh yoobópdih ãpĩ́ naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pánih jʉmnidih bidcan, ¿tʉ́ini yégueh dʉonídih enedih ñi bejnit beé? Obohjeéhtih, tʉ́ini yégueh dʉonít, dawá bií dée bíbohnit, maátaíh mʉʉ́boó ĩpĩ́ jʉmna caá. Juanboó queét pah nihcan beé. ");
INSERT INTO cbv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pánih jʉmnidihbʉt bidcan, ¿Dios naáwátdih naóh yapanidih enedih bejnit beé ñi chãj? Páant tigaá Juan ã jʉmʉp. Bita naóh yapanit chah ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan ã jwíih naóh waáwát pínahdih jon jã́tih nin pah ĩt niíj naóh daacáp tajĩ: ‘Ã wʉ̃ʉ́hdih Dios nin pah ã niijíp be: “Ma jã́tih wã naáwátdih naóh waóhni pínahdih wã wahbipna caá, meémboó ma naáwáchah joinít, ĩ jepahat pínah niijná”, Dios ã niijíp be’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Yoobópdih yeebdíh wã naóhna caá. Nihat bita chah Juan Daabáni ã jʉmna caá. Obohjeéhtih, bʉʉ láa páant ã jʉmʉchah yʉhna, Dios ã maáh jʉmʉpna ded oboh jʉmnijiboó Juan chah ã jʉmbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juandih ĩ nemat pínah jã́tih, ã bohéátdih joinít, nihat cã́acwã, Romano maáta ĩ ʉʉ́bát tʉ́ʉtni nʉ́odih ʉʉ́bh wʉ̃hnitbʉt, Juandih ĩtát daabáát tʉ́ʉtʉp wʉt jĩ. Páant Diosdih jepahnit ĩ jʉmʉchah, Jesúsboó ã niijíchah joinít, “Dios ã wʉtat yoobópdih caá”, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Obohjeéhtih, fariseowã, Moisés ã wʉtatjidih bohénitbʉt, Juandih daabáát tʉ́ʉtcan, Dios queétdih ã náah yacat pínahdih ĩt náahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Páant ĩ jʉmatdih jéihnit, Jesús nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: “Bʉʉ láa moón weemdíh jepahcannit, nin pah ñi jʉmna caá: ");
INSERT INTO cbv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yoahdih tíohnit wébít pah caá ñi jʉmʉp. Tíoh chʉ́ʉdnit, nin pah ĩpĩ́ míic niíj jʉ̃ihna caá: ‘Jwĩ pelat póoj tíhwichah yʉhna, yeébboó ñi bʉ́ʉdíhcan beé. Wʉnnitdih jwĩ jʉ̃í tíhwichah yʉhna, ñi jʉ̃í wáaquíhcan beé’, ĩ míic niíj jʉ̃ihna caá. ");
INSERT INTO cbv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Páant ĩ chãjat pah, yeebbʉ́t biíc yoobó ñipĩ́ chãjna caá. Juan Daabáni cã́acwãjeéh jeémpcan, poonidihbʉt ãpĩ́ babhcap jĩ. Páant ã chãjcah enna, ‘Nemép jʉmni caá’, niíj jʉ̃ihnit, ã bohéátdih ñi jepahcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Obohjeéhtih, weém, nihat cã́acwã ʉ́ʉd jeñé cã́acwãjeéh jeémpnit, wãpĩ́ babhna caá. Páant wã chãjachah ennit, ‘Eneé. Nin bʉ́dí jeémpni, máihni caá ã jʉmʉp. Romanowã ĩ ʉʉ́bát tʉ́ʉtni nʉ́odih ʉʉ́bh wʉ̃hnit, yeejép chãjnit biícdih ãpĩ́ pej jʉmna caá’, niíj jʉ̃ihnit, weemdíhbʉt ñi jepahcan caá. Páant niíj jʉ̃ihna, wébít pah caá ñi jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Obohjeéhtih, ded pah Dios ã wʉtat pah wã tʉ́i chãjachah enna, ã jenah joyát yoobópdih ã jʉmatdih ñi jéihbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Biíh yeó jáap biíc fariseo, Simón wʉ̃t jʉmni, Jesúsdih ãt nʉmah jeémép wʉt jĩ. Ã́ih mʉʉná jʉibínit, Jesús ãjeéh ãt jeémép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Simóníh mʉʉdíh Jesús ã jʉmat doonádih joinít, queét ĩ jeéméchah, caán tʉ́tchidih bóli, deoh nah jʉmnih, tʉ́i chej jʉmni yíi quiítdih mit ʉb waád jʉibínap wʉt jĩ. Caán quiít alabastro ĩ niijní jeejĩ́h ĩ chãjni quiít ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pánih ʉb waád jʉibínit, Jesús pebh bódicha caj yoh ñajnit, caandíh mi oyat jʉ́ʉtna, ã́ih jítchanadih miíh quíib macjĩh jʉ̃i chócnit, miíh waó yoócjĩh mit jõp wiwip wʉt jĩ. Pánih chãj péa, ã́ih jítchanadih nomnit, mi ʉb jʉ̃óhni tʉ́i chej jʉmni yíidih pʉohnit, mit ñáñap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Páant mi chãjachah ennit, Jesúsdih nʉmah jeémpni Simónboó nin pah caanjéh ãt niíj jenah joyóp wʉt jĩ: “Nin newé Dios naáwátdih naóh yapani jʉmna, caandíh teonih yeejép mi jʉmatdih ãta jéih tagaá. Jéihnit, caántdih ãta tewat tʉ́ʉtcan tagaá. Obohjeéhtih, páant ã chãjcan, naóh yapani yoobát nihcan nacaá”, ãt niíj jenah joyóp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Páant ã niíj jenah joyátdih jéihnit, nin pah Jesús caandíh ãt niijíp wʉt jĩ: —Simón, meemdíh bainí wã naáwát tʉ́ʉt caá, ded pah mi chãjatdih ma jéihyat pínah niijná, ãt niijíp wʉt jĩ. —Ma naáwá, Bohéní, Simón caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Biíc newédih chéne neoná dinerodih ĩ wayáp be. Biícboó chéne jópchi ã tewat jíibdih pohba waí, biíhboó chéne widh ã tewat jíibbitdih ã wayáp be. ");
INSERT INTO cbv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Queét chénat pah ĩ wayátjidih ĩ jéih jíib chãjcah ennit, queétdih wʉ̃hniboó ‘Jʉmʉ naáh. Ñi jíib chãjcah, ã tʉ́ina caá’, queét chénat pahdih ã niijíp be. Páant ã chãjachah, ¿ded tigaá caandíh chah ã oibi? Jesús Simóndih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Bʉ́dí nʉ́o wainíboó caandíh chah ã oibipna caá, Simón ãt niíj jepahap wʉt jĩ. —Yoobópdih ma jepahna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Páant niijnít, yad wilidih jʉ́ʉt jã́hanit, Simóndih nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Ma jenah joyoó. Ma chéen yoobát wã jʉmʉchah nihna, míih mʉʉná wã waád jʉyʉ́chah, wĩ́ih jítchanadih wã chocat pínah niijná, mah weemdíh mata wʉ̃h tagaá. Obohjeéhtih, nintboó wĩ́ih jítchanadih miíh quíib macjĩh jʉ̃i chócnit, miíh waó yoócjĩh mi jõp wiwip be. ");
INSERT INTO cbv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wã jʉyʉ́chah, meém weemdíh pʉ́o tíibdih nomcanjeh, ma tʉ́i ʉʉ́bhcap be. Obohjeéhtih, nintboó weemdíh mi oyat jʉ́ʉtna, wĩ́ih jítchanadih mi nom cádahcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wã jʉyʉ́chah, wĩ́ih wao dáhdih yíijĩh pʉoh jã́ha ñáicanjeh, ma tʉ́i ʉʉ́bhcap be. Obohjeéhtih, nintboó wĩ́ih jítchanadih tʉ́i chej jʉmni yíijĩh pʉohnit, mi ñáñap be. ");
INSERT INTO cbv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yoobópdih meemdíh wã naóhna caá. Bʉ́dí mi yéej chãjatjidih Dios ãt yoh wʉ̃h tagaá. Páant ã chãjatdih jéihnit, weemdíh bʉ́dí mi oina caá. Obohjeéhtih, ‘Bainíjeh wã yéej chãjap jĩ’, niíj jenah joinít, ã yéejat yohat ʉʉ́bhniboó bainíjeh Diosdih ã oina caá. Pánihatdih ma tʉ́i jenah joyoó, Jesús Simóndih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Caandíh páant niíj péanit, caántdih jwʉh nin pah ãt jwʉ́ʉb niijíp wʉt jĩ: —Meém yéejat yohnih caá. ");
INSERT INTO cbv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","50","Weemdíh ma tʉ́i jenah joyát jíib, ma yéejat peéh iiguípna ma bejatji déedih, meemdíh Dios ãt tʉ́i ʉb tagaá. Pánihna, tʉ́i wẽinit, ma bejeé, ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ãjeéh jeémpnit nin pah queétjeh ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedé newéna tigaá nin? ¡Yéejat yohat wẽpatbʉt ã bíbohna caá! ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tʉ́ttimah, Jesús tʉ́tchina yoobó cã́acwãdih ãt táoh bohé jibip wʉt jĩ. Dios ã maáh jʉmat doonádih ãt naáwáp wʉt jĩ. Doce ã bohénitbʉt ãjeéh ĩt jib bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Biquína yaádhbʉt ĩjeéh ĩt pej jʉm bejep wʉt jĩ. Jesús ã booanit yaádh, nemép jʉmnitdih ã booanitbʉt ĩt jʉmʉp wʉt jĩ. María, Mágdala tʉ́tchidih bólidih siete nemépwãdih Jesús ã bacat tʉ́ʉtnihji jʉm, ");
INSERT INTO cbv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, Maáh Herodesdih teo wʉ̃hni Chuza áabʉt jʉm, Susana wʉ̃t jʉmnihbʉt mit jʉmʉp wʉt jĩ. Dawá bita yaádhbʉt ĩjeéh ĩt pej jʉm bejep wʉt jĩ. Queét yaádh ĩ́ih dinerojĩh Jesúswãdih ĩt teo wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Biíc yeó jáap dawá cã́acwã ĩ jʉmni tʉ́tchinamant bejnit, caandíh enat tʉ́ʉt niijná, Jesús pebhna ĩt jʉibínap wʉt jĩ. Dawá páant ĩ wáac jʉibínachah ennit, ã jenah joiní naáwátjĩh queétdih bohéna, Jesús nin pah ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Biíc newé waáh momodih ã bejep be. Páant ã waáh bojochah, biquí tíibna namádih ã bʉʉg ñájap be. Namádih bʉʉg ñájni tíibnadih cã́acwã ĩ néeh chʉñʉp be. Biíh tíibnadih jwébehwã jʉ̃óhnit, ĩ jeémp beedánap be. ");
INSERT INTO cbv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Biíh tíibna, jeejíh yewéni baác jʉmʉpboó ã bʉʉg ñájap be. Bʉʉg ñájnit, chíih jʉ̃óhna yʉhna, mac ã jõpah bejechah, ã wʉnah bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Biíh tíibna nemép óot cãtíh ã bʉʉg ñájap be. Pánih bʉʉg ñájni ã chíihichah yʉhna, caán nemép óotboó caandíh ã chíih yap bejechah, momniboó mánahnit, ã wʉnah bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Obohjeéhtih, biíh tíibna tʉ́ini baácboó ã bʉʉg ñájap be. Pánih bʉʉ́g ñájna, chíihnit, ã tʉ́i quehep be. Pánih quehnit, wawána jʉmat pah cien tíibna ã quehep be”, Jesús queétdih ãt niijíp wʉt jĩ. Caán naáwátjĩh bohé péanit, “¡Ded molít jʉmna, ã tʉ́i joyó naáh!” ãt niíj ej ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Páant naáwátjĩh ã bohénachah joiná yʉhna, beh joicán, ã bohénit ã bohéátjidih ĩt ʉʉ́bh joyóp wʉt jĩ. —¿Ded pah niíj naóh bohé tibeé jwiítdih ma chãj? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Páant ĩ niijíchah joinít, Jesús nin pah ãt niíj jepahap wʉt jĩ: —Ded pah Dios maáh ã jʉmatdih bitadih naóh jwʉhca naáhdih bʉʉ yeebdíhjeh wã naóhna caá. Obohjeéhtih, bitadih naáwátjĩhjeh wãpĩ́ bohéna caá, weemdíh enna yʉhna, ĩ beh encat pínah, wã naáwáchah joiná yʉhna, ĩ beh joicát pínah niijná. Weemdíh ĩ jepahíhcat jíib páant ĩ jʉmna caá, queétdih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tʉ́ttimah, waáh momni naáwátjidih ĩ beh joyát pínah niijná, nin pah Jesús queétdih ãt jwʉ́ʉb niijíp wʉt jĩ: “Nin pah niíj naóhna wã chãjap be: Waáh momni tíibna Dios naáwát panihni caá. ");
INSERT INTO cbv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Biquína joinít namáboó bʉʉg ñájni panihni caá. Dios naáwátdih ĩ joyóchahjeh, nemépwã ĩ maáh ĩ joyátjidih ã jenah joyát tʉ́ʉtcan caá, jepahcanjeh iiguípna ĩ bejat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bita joinít jeejíh yewénibit baácboó bʉʉg ñájni panihni caá. Dios naáwátdih joiná, ĩ tʉ́i wẽi jwʉhna yʉh caá. Obohjeéhtih, ĩ́ih caolihboó ñeh jáap choo bejni panihni ã jʉmʉchah, bitaboó queétdih deohnit, ĩ yéej chãjat tʉ́ʉtʉchah, Diosdih jepah cádahnit, ĩ jwʉ́ʉb yéej chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bita joinítboó nemép óotna cãtíh bʉʉg ñájni panihni ĩ jʉmna caá. Dios naáwátdih joinít, ĩ jepahna yʉh caá. Obohjeéhtih, yeó jáap jʉmat pah ĩ chãjat pínahdih queét tʉbit ĩ náhni dahwana caá. Bʉ́dí dinero bíbohatdihjeh ĩ wẽina caá. Ĩ weñat pínah chãjatdihjeh ĩ jenah joiná caá. Pánih jenah joinít, chéonit panihnit jʉmna, Dios naáwátdih jenah joicánjeh, queétdih behat dée wihcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Obohjeéhtih, bita joinítboó tʉ́ini baácdih bʉʉg ñájni panihni caá. Dios naáwátdih tʉ́i joinít, jwʉ́ʉb náhnina, caandíh ĩ cádahcan caá. Pánih jʉmna, Dios ã náahat pah ĩpĩ́ tʉ́i chãjna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wã bohéát jiiát panihni caá. Ded ã́ih jiiát dahdih jií péanit, pʉʉbát dahjĩh ãpĩ́ páah jwejcan caá. Caan dáhdih chʉ́ʉdat páha nʉmpboobʉ́t ãpĩ́ jii jwéjcan caá. Obohjeéhtih, japboó ãpĩ́ jií cáag jwejna caá, ã yeh iiguíchah, nihat waadnít ĩ tʉ́i enat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Caán ã yeh iiguíchah, dedé ĩ bihniji ã jígohbipna caá. Dedé ĩ bih chãjatjidihbʉt nihat cã́acwã ĩ enbipna caá. Wã naáwátdih ĩ bohénachah, cã́acwã ded pah ĩ́ih caolih ã jʉmatdih ã jéihyana caá. ");
INSERT INTO cbv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“¡Ñi tʉ́i chãja chaáh! Ded pah wã naáwátdih joinít, ñi tʉ́i jepahaá. Ded wã naáwátdih tʉ́i joiní ã jwʉ́ʉb náhninachah, Dios caandíh chah ã jéihyabipna caá. Obohjeéhtih, ded joiná yʉhna, ã jwʉ́ʉb náhnicah, ã jwíih joyátjidih Dios ã dʉ́ʉc wáibipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Caán láa Jesús íin ã ʉ́ʉdwãbʉt ã pebhna ĩtih jʉibínap wʉt yʉh jĩ. Obohjeéhtih, dawá cã́acwã ĩ jʉmʉchah, Jesúsdih ĩt jéih jwãáhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pánihna, bita caanjĩ́h jʉmni Jesúsdih nin pah ãt niijíp wʉt jĩ: —Ma íin ma ʉ́ʉdwãbʉt meemdíh bidnit, jóocmant ĩ pã́i ñʉhna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","—Ma naáwát tʉ́ina caá. Obohjeéhtih, nit panihnit wã déewã yoobát ĩ jʉmna caá. Dios naáwátdih wã bohénachah, joí jepahnit wã íin panihnit, wã ʉ́ʉdwã panihnitbʉt ĩ jʉmna caá, Jesús caandíh ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Biíh yeó jáap Jesús ã bohénitdih jãáj chóodih nʉmah waadnít, —Chóbe conanaáboó íimdih jwĩ chʉ́ʉh bejjĩh, ãt niijíp wʉt jĩ. Páant niijnít, ĩt chʉ́ʉh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Páant ĩ chʉ́ʉh bejechah, Jesúsboó ãt ʉ̃wʉp wʉt jĩ. Ã ʉ̃wat pónih, bʉ́dí johlit ãt jʉ̃ʉ́wʉ́p wʉt jĩ. Pánih bʉ́dí nolihat ã jʉmʉchah, ĩ́ih jãáj chóo ãt daábíhip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Páant ã tobohochah, ã bohénit Jesús pebh jʉibí wʉcnit, caandíh nin pah ĩt niijíp wʉt jĩ: —¡Bohéní, Bohéní, daabná caá jwĩ chãjap! ¡Jwĩ bʉʉdbípna caá! caandíh ĩt niijíp wʉt jĩ. Páant ĩ niíj wʉcʉchah, jáanit, Jesús johlitdih, nolihatdihbʉt “Ma yayaá”, ãt niijíp wʉt jĩ. Páant ã niijíchahjeh, johlit, nolihatbʉt biícmantjeh ãt yayáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—¿Dépanih tibeé weemdíh ñi tʉ́i jenah joicán? Jesús ã bohénitdih ãt niijíp wʉt jĩ. Páant ã yayánachah en wʉ́hi bejnit, bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. Pánih ʉ́ʉmna, bʉ́dí jenah joinít, queétjeh nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedé cã́acna tigaá nin? Ã naáwáchahjeh, johlit, nolihatbʉt ã yayáh bejna caá, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Páant ã yapat tʉ́ttimah, Gadara baácboó Jesúswã ĩt chʉ́ʉh jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Caanná chʉ́ʉh jʉibínit, Jesúswã ĩ aab béjechah, caán tʉ́tchidih bóo nemép jʉmni Jesúsdih ãt jwãáh dei jʉ̃ʉ́wʉ́p wʉt jĩ. Caán maatápdih yégueh dʉocán, mʉʉdíh jéih jʉmcanjeh, cã́ac yohopboó ãpĩ́ jʉmʉp wʉt jĩ. Maatápdih nemépwã caandíh ĩt déheanap wʉt jĩ. Páant ĩ déheanachah, cã́acwã ã́ih téihya colóhnadih, ã́ih jítcha colóhnadihbʉt ĩtah tõpjĩh ĩt chéwep wʉt jĩ. Pánih chéonit, nemat mʉʉ́boó ĩtih nemep wʉt yʉh jĩ. Obohjeéhtih, ĩ chéwatjidih pʉ́ʉd wái daj yohnit, queét nemépwã mʉʉ́ wihcapboó caandíh ĩt nʉmah jwei bác bejep wʉt jĩ. Pánihna, Jesúswãdih jwãáh dei jʉibínit, nemépwãdih Jesús ã bacat tʉ́ʉtʉchah joinít, Jesúsdih nin pah ĩt niíj ñaacáp wʉt jĩ: —¿Jesús, Dios chah wẽpni wʉ̃ʉ́h, dépanihat tʉ́ʉt tigaá weemdíh páant ma chãj? ¡Weemdíh ma peéh chãjca bojoó! ãt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Páant ã niíj ñaacáchah joinít, —¿Dedé tigaá ma wʉ̃t? Jesús caán nemépdih ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, dawá nemépwã jʉmna, nin pah ãt niíj jepahap wʉt jĩ: —‘Dawá’ caá wã wʉ̃t. ");
INSERT INTO cbv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","¡Bʉ́dí iigní íitboó jwiítdih ma wahca bojoó! ĩt niíj wẽp ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Queét pebh, jeé ñaj yacapboó dawá momo mʉʉwã ĩ bid jeéméchah ennit, —Jwiítdih queét mʉʉwã diítna ma wahaá, nemépwã Jesúsdih ĩt niijíp wʉt jĩ. Páant ĩ niijíchah joinít, Jesús queétdih ãt bejat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Páant ã bejat tʉ́ʉtʉchahjeh, nemépwã newéíh bácahmant bac bejnit, mʉʉwãdih ĩ waadáchah, ñáo dei bej, bʉʉg báhnit, mʉʉwã ĩt chĩíc wʉn beedáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Páant ã yapachah ennit, mʉʉwãdih en daonítjiboó ĩ́ih tʉ́tchina ĩt jweí jwʉ́ʉb bejep wʉt jĩ. Jweí jwʉ́ʉb bejna, ĩ jwãáhnitdih naóhnit, ĩ́ih tʉ́tchidih moondíhbʉt páant ã yapat doonádih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Páant ĩ naáwáchah joinít, cã́acwãboó ĩ́ih tʉ́tchimant Jesús ã chãjatjidih enedih ĩt bejep wʉt jĩ. Pánih bej, Jesúswã ĩ jʉmʉpna jʉibínit, nemépwã jʉmniji yégueh dʉó, tʉ́inijeh jenah joinít, Jesús pebh ã chʉ́ʉdʉchah enna, bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jesús nemépwã jʉmnidih ã booanachah ennitjiboó, jáap jʉinítdih ded pah ã yapatjidih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Páant ĩ naáwáchah joinít, nihat Gadara baácdih moón bʉ́dí ʉ́ʉmnit, ĩ́ih baácmant Jesúsdih ĩt jwʉ́ʉb bejat tʉ́ʉtʉp wʉt jĩ. Páant ĩ bejat tʉ́ʉtʉchah joinít, Jesúswã ĩ́ih jãáj chóona ĩt jwʉ́ʉb dei bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Páant ĩ jwʉ́ʉb dei bejechah, nemépwã jʉmnijiboó Jesúsdih bʉ́dí ãtih pej jʉmíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wãjeéh ma jʉ̃ʉ́wʉ́chah, ãta tʉ́i ta yʉh caá. Obohjeéhtih, weém ma Maáh meemdíh jĩ́gah ennit, ded pah wã teo wáacatjidih ma déewãdih naáwát tʉ́ʉt niijná, ĩ pebhboó ma jwʉ́ʉb bejeé, Jesús caandíh ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, nemépwã jʉmniji jwʉ́ʉb bej, nihat ã́ih tʉ́tchidih moondíh caandíh Jesús bʉ́dí ã teo wáacatjidih ãt naóh peetép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gadara baácmant Jesúswã ĩ jwʉ́ʉb chʉ́ʉh jʉibínachah, dawá míic wáac pã́init cã́acwã wẽinit, queétdih ĩt jwãááp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jairo wʉ̃t jʉmni, judíowã ĩ míic wáacat mʉʉdíh en daonít ĩ maáh, Jesús pebh ãt jʉibínap wʉt jĩ. Jʉibínit, bódicha caj yoh ñajnit, Jesús ã́ih mʉʉ́boó ã bejat pínahdih bʉ́dí ãt ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ã nʉʉ́m biíc wilijeh wʉt jĩ. Caánt doce jópchi bíbohnih, bʉ́dí mi wʉnʉchah, caántdih ã booaat pínah niijná, Jesúsdih ã́ih mʉʉná ãt bejat tʉ́ʉtʉp wʉt jĩ. Páant ã niijíchah joinít, Jesús Jairojeéh ã bejechah, dawá cã́acwã caandíh ĩt tóo néeh péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pánihna, queét cãtíh biíh wili mácanihat panihat wʉnnihbʉt mit jʉmʉp wʉt jĩ. Doce jópchi caán wʉnatdih mi bíbohochah, ĩ cohochah yʉhna, ãt yaicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pánih jʉmna, Jesúíh yégueh chóo yapat waadih tã́ahmant mi jʉibí tewechahjeh, mi mácanihat panihat wʉnat ãt yayáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Páant mi tewechah, Jesús cã́acwãdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Déhe tigaá wĩ́ih yéguehdih jʉí teoni? ãt niijíp wʉt jĩ. —Weém meemdíh wã teocan beé, nihat ĩt niijíp wʉt jĩ. —Páant Bohéní, dawá meemdíh ĩ tóo néeh péena caá, Pedroboó ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Páant ã niijíchah joinít, Pedrodih nin pah ãt jwʉ́ʉb niijíp wʉt jĩ: —Obohjeéhtih, wʉnni weemdíh jʉí tewechah, booaat wẽpat wĩ́ih bácahmant ãí bejep be, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Páant ã niijíchah joinít, caandíh jʉibí teonih, jéih jweicán, ʉ́ʉm méménit, Jesús pebh mit bódicha caj yoh ñajap wʉt jĩ. Pánih bódicha caj yoh ñajnit, nihat cã́acwã ĩ enechah, ded pah mi jʉibí teonitjeh booatjidih caandíh mit naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Páant mi naáwáchah joinít, —Némá, weemdíh tʉ́i jenah joiná, mat boonap tagaá. Ʉ́ʉmcanjeh, wẽinit ma jwʉ́ʉb bejeé, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Páant ã niijíchahjeh, Jairoíh mʉʉmánt bej, Jesúswã pebhna jʉibínit, Jairoboodíh nin pah ãt niijíp wʉt jĩ: —Jáantjeh ma nʉʉ́m mi mʉʉjáh bejep be. Páant mi wʉnʉchah, bohénidih ma jwʉ́ʉb bejat tʉ́ʉtʉ́, Jairodih ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Obohjeéhtih, páant ã niijíchah joinít, —Ma ʉ́ʉmca bojoó. Wã wẽpatdih ma tʉ́i jenah joyóchah, ma nʉʉ́m mi boobipna caá, Jesús Jairodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Tʉ́ttimah, Jairoíh mʉʉná jʉibínit, ĩ jã́tih jʉibínitji wʉnnihdih bʉ́dí jĩ́gahnit, ĩ jʉñʉ́chah, Jesús ãt enep wʉt jĩ. —Ñi jʉ̃í cádahaá. Caánt wʉnnih nihcan caá. Ʉ̃ona caá mi chãjap, Jesús queétdih ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, mi wʉnatdih jéihnit, caandíh ĩt dehwep wʉt jĩ. Queétdih páant niíj naóh péanit, Jairoíh mʉʉdíh waadnít, ãjeéh bejnitdih jóocmantjeh ãt chãwát tʉ́ʉtʉp wʉt jĩ. Pánihna, Pedro, Santiago, Juan, wʉnnihji mi mánadih pohba ãjeéh ãt waadát tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pánih waadnít, Jesús wʉnnihíh téihyadih teonit, —¡Bainíhmaá, ma ñah ñʉhʉʉ́! caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Páant ã niijíchahjeh, caánt jwʉ́ʉb boonit, mit ñah ñʉhʉp wʉt jĩ. Mi jwʉ́ʉb boonachah, Jesús mi mánadih caántdih jeémát ãt wʉ̃hat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Páant ã booanachah, mi mána bʉ́dí ĩt en wʉ́hi bejep wʉt jĩ. Obohjeéhtih, caántdih ã booaatjidih bitadih Jesús ãt naáwát tʉ́ʉtcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Biíc yeó jáap doce ã bohénitdih Jesús ã pebhna bid wáacnit, nemépwãdih ĩ bacaat pínah, wʉnnitdihbʉt ĩ booaat pínah niijná, ã wẽpatdih queétdihbʉt ãt wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pánih wʉ̃h péanit, queétdih ãt wahap wʉt jĩ, Dios ã maáh jʉmatdih ĩ naáwáchah, cã́acwã ĩ jepahat pínah, cã́acwãdihbʉt ĩ booat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pánih wahnit, Jesús queétdih nin pah ãt niíj naáwáp wʉt jĩ: —Bejna, dedé bií déedih ñi ʉb bejca bojoó. Íoh cajat nah, wʉh wʉʉ́h, jeémát, dinerodih yʉh bʉca ñi ʉb bejca bojoó. Ñi dʉwát chóodihjeh ñi dʉo béjeé. ");
INSERT INTO cbv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Caán tʉ́tchidih moondíh bohéna, ded ñi jwíih waadní mʉʉdíhjeh ñi ʉ̃wʉʉ́. Caanjĩ́h moondíh bohé péanitjeh caán mʉʉdíh ñi cádah bejeé. ");
INSERT INTO cbv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Det tʉ́tchidih moón yeebdíh náahcan, ñi naóhni doonádih ĩ joííhcah, bac bejna, ĩ enechah, queétdih Dios ã yohat pínahdih ĩ jéihyat pínah niijná, ñíih zapatosdih tóo dʉgnit, becchídih ñi péoh mao jéenanaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Páant ã niijíchah joinít, nihat tʉ́tchibitna yoobó ĩt bejep wʉt jĩ. Pánih jʉibínit, Dioíh tʉ́ini doonádih nihat cã́acwãdih naóhnit, wʉnnitdihbʉt ĩt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Caán láa Maáh Herodes Jesús ã bohénitbʉt ded pah ĩ chãjat doonádih jwʉ́ʉb joiná, bʉ́dí ãt ʉ́ʉmʉp wʉt jĩ. “Juanji ãt jwʉ́ʉb boo pʉd jʉ̃óh tagaá”, biquína niíj, ");
INSERT INTO cbv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","“Elías ãt jwʉ́ʉb jígoh tagaá”, bita niíj, “Dios naáwátdih biíh naóh yapaniji ãt jwʉ́ʉb boo pʉd jʉ̃óh tagaá”, bitabʉt ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Páant ĩ niijíchah joinít, Herodesboó nin pah ãt niijíp wʉt jĩ: —Weemjéh tijĩí Juandih wã waó bóod yohat tʉ́ʉtʉp jĩ. ¿Pánihna, deíh doonádih tigaá wã jwʉ́ʉb joí, páant mʉntih? ãt niijíp wʉt jĩ. Páant niijnít, Herodes Jesúsdih tʉbit ãt eníhip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tʉ́ttimah, Jesús ã wahnitji ã pebhna jwʉ́ʉb jʉibínit, ded pah ĩ chãjatjidih caandíh ĩt naáwáp wʉt jĩ. Páant ĩ naáwáchah joinít, ã bohénitjĩhjeh jʉmíhna, cã́acwãdih ãt cádah bejep wʉt jĩ. Pánih cádah bejnit, Betsaida tʉ́tchina ĩt bejep wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Obohjeéhtih, cã́acwãboó ĩ bejatdih jéihnit, queétdih ĩt ñʉʉn béjep wʉt jĩ. Ĩ ñʉʉ́n jwãááchah, Jesús queétdih wẽinit, Dios ã maáh jʉmatdih ãt bohénap wʉt jĩ. Wʉnnitdihbʉt ãt booanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cheyeh doce ã bohénit nin pah Jesúsdih ĩt niijíp wʉt yʉh jĩ: —Nin pebhbit tʉ́tchinaboó nitdih ma bejat tʉ́ʉtʉ́, ĩ ʉ̃wat tólih pínah, ĩ jeémát pínahdihbʉt ĩ bidat pínah niijná. Ninjĩhbitjeh pohba mʉʉná ã wihcan caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Yeebjéh queétdih jeémát ñi wʉ̃hʉʉ́, Jesús ãt niíj jepahap wʉt jĩ. —Páant, cinco botoni pan dahna, chéne queejwã́bitdihjeh jwĩ bíbohna caá. ¿Queét ĩ jeémát pínahdih jíib chãjadih jwĩ bejmi naniít? ã bohénit ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Cinco mil neonájeh ĩt jʉmʉp wʉt jĩ. Yaádh ĩ weh biícdih chah ĩt jʉmʉp wʉt jĩ.) —Cã́acwã poómp jʉmat pah cincuenta ñi chʉ́ʉdat tʉ́ʉtʉ́, ã bohénitdih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Páant ã niijíchah joinítjeh, queétdih ĩt chʉ́ʉdat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Páant ĩ chʉ́ʉdʉchah, Jesúsboó cinco pan dahnadih, chéne queejwã́dihbʉt ʉbnit, chéi ennit, —Nin pandih, queejwã́dihbʉt ma wʉ̃hat tʉ́ina caá, Paá, ã íipdih ãt niijíp wʉt jĩ. Páant niíj péanit, pan dahnadih queejwã́dihbʉt dajnit, cã́acwãdih ĩ pãáát pínah niijná, ã bohénitdih ãt wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pánihna, nihat ĩt tʉ́i jeémp chʉ̃ʉ́ʉ́p wʉt jĩ. Ĩ jʉdh jeémpnidih doce wʉhdih ĩt ʉb yac yáwanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Biíh láa Jesús Diosdih ʉʉ́bh péanit, ã bohénitdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Weemdíh ded pah tigaá cã́acwã ĩ niíj? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—‘Juan Daabáni nacaá’, biquína niíj, ‘Elías nacaá’, bita niíj, ‘Jon jã́tih Dios naáwátdih naóh yapaniji ãt jwʉ́ʉb boo pʉd jʉ̃óh tagaá’, bitabʉt ĩ niijná beé, Jesúsdih ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Queét páant ĩ niijíchah joiná, ¿yeébboó ded pah tigaá ñi niíj jenah joí? queétdih ãt niijíp wʉt jĩ. —Meém Cristo, Dios ã wahni caá, Pedroboó ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Páant Pedro ã niijíchah joinít, Jesús ã bohénitdih nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Dios ã wahni wã jʉmat doonádih bitaboodíh ñi naóhca bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Weém nihat cã́acwã ʉ́ʉd jeñédih tʉbit yeejép yapat caá náahap. Jwĩ maáta, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt weemdíh náahcan, ĩ mao yohat tʉ́ʉtbipna yʉh caá. Obohjeéhtih, páant ĩ mawachah yʉhna, biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá. Páant yeejép yapat caá weemdíh náahap, Dios ã jenah joyátjidih biíc yoobó ã yapat pínah niijná, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tʉ́ttimah, queét nihatdih nin pah ãt niíj naáwáp wʉt jĩ: —Ded wĩ́ih jʉmíhna, ã weñat pínahdih jenah joicán, wã weñat pínahboodíh jenah joinít, ã jepaha naáh. Bita caandíh ĩ wẽi encah yʉhna, caandíh tʉbit yeejép ĩ chãjachah yʉhna, ĩ mao yohíhichah yʉhna, weemdíh jepah cádahcat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ded ã weñat pínahdihjeh jenah joí chãjni iiguípna bejni ã jʉmbipna caá. Obohjeéhtih, ded ã weñat pínahdih joyáh bojni, wã weñat pínahboodíh chãjni, ã bʉʉdcán niít. ");
INSERT INTO cbv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ded ã weñat pínahdihjeh chãjni, bʉ́dí dinero ã bíbohochah yʉhna, caandíh dedé pínah nihcan caá. Wã weñat pínahdih ã chãjcatji jíib, iiguípna ã bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pánihna, weém maáh jʉmna, wã íip ã yeh iigátjĩh, ã́ih tʉ́init ángelwã ĩ yeh iigátjĩhbʉt jwʉ́ʉb dei jʉ̃óhna, ded weemdíh náahcan, wã naáwátdihbʉt joííhcannidih wã wẽpatjĩh wã yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yeebdíh yoobópdih wã naóhna caá. Biquína ninjĩh ñʉhnit ñi wʉnat pínah jã́tih, Dios ã maáh jʉmatdih ã jʉ́ʉtʉchah, ñi enbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Biíc semana tʉ́ttimah, Diosdih ʉʉ́bát tʉ́ʉt niijná, Pedro, Santiago, Juan queét biíc peihcannitdihjeh jap bóo jeená Jesús ãt nʉmah pʉ́ʉh laab béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Caanná ĩ pʉ́ʉh laáb jʉibínit, Jesús ã ʉʉ́bʉ́chah, ã jígohat ãt tʉ́ʉt nʉʉmʉ́p wʉt jĩ. Ã́ih móot yeó ã yeh iigát pah yeh iíg, ã́ih yéguehbʉt biíc yoobó tʉ́i baabní ãt yeh iiguíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Páant ã yeh iiguíchah, Moisés, Elíasji biícdih ã pebh ĩt jígohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Queétbʉt Jesús biíc yoobó ĩt yeh iiguíp wʉt jĩ. Pánih jígohnit, Dios ã jenah joyátjidih biíc yoobó ã yapat pínah niijná, Jesús Jerusalén tʉ́tchiboó ã wʉnat pínahdih ĩt míic wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Páant ã yapachah, Pedro ã chéenwã biícdih chʉʉnít jʉmna, queétdih quíib chei ãt jʉmʉp wʉt jĩ. Obohjeéhtih, jwʉ́ʉb jáanit, Jesús bʉ́dí ã yeh iiguíchah, ã pebh ñʉhnitdihbʉt ĩt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pánih ñʉhnitji ĩ jwʉ́ʉb bʉʉ́d jʉ̃ʉ́wʉ́chah, Pedro Jesúsdih nin pah ãt niijíp wʉt jĩ: —¡Bohéní, ninjĩh jwĩ jʉmʉchah, ã tʉ́ina caá! ¿Biíc peihcanni mʉʉ dáhnadih, míih pínah, Moiséíh pínah, Elíaíh pínahdihbʉt jwĩ chãj jĩíh? ãt niijíp wʉt yʉh jĩ. Páant niijná, ãt jenah joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Páant ã niijíchahjeh, mah põh panihni queétdih ãt dei jʉyʉ́p wʉt jĩ. Páant ã dei jʉyʉ́chah, bʉ́dí ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mah põh cãtíh Dios queétdih nin pah ãt niijíp wʉt jĩ: —Nin wã wʉ̃ʉ́h, wã oini caá. Ã naáwáchah, caandíh ñi tʉ́i joyoó, Dios queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Páant ã niiját tʉ́ttimah, Pedrowã jwʉ́ʉb enna, Jesús biícjeh ã ñʉhʉchah, ĩt enep wʉt jĩ. Páant ĩ enatjidih bitadih ĩt naóh jwʉhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cheibit Jesúswã ĩ jwʉ́ʉb dei jʉibínachah, dawá cã́acwã caandíh ĩt jwãááp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Páant ĩ jwãááchah, queét cãtíh biíc newé Jesúsdih ejnit, nin pah ãt niíj ʉʉ́bʉ́p wʉt jĩ: —Bohéní, meemdíh wã ʉʉ́bhna caá. Wã wʉ̃ʉ́h biíc jʉmnidih jĩ́gah ennit, ma teo wáacá. ");
INSERT INTO cbv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dawá láa nemép caandíh ãpĩ́ déheana caá. Pánih déhe bʉʉg ñájnit, tʉbit mémé ñaácnit, chʉ̃i bid ñajnit, ãpĩ́ jac moj chej bac ñaj bejna caá. Pánih chãjna, wã wʉ̃ʉ́hdih dedé ã noón yaicán caá. Pánihna, ã́ih bácahdih tʉbit yéejana caá ã chãjap. ");
INSERT INTO cbv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Páant ã chãjachah, nemépdih ĩ bacaat pínah niijná, ma bohénitdih wã ʉʉ́bʉ́p yʉh be. Obohjeéhtih, queétboó caandíh ĩ jéih bacacap be, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Páant ã niijíchah joinít, Jesús queét nihatdih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: —¡Yeéb yeejépwã weemdíh jenah joicánnit ñi jʉmna caá! ¿Débólih tigaá weemdíh tʉ́i jenah joicán, ñi tac bʉʉgábi? ãt niijíp wʉt jĩ. Páant niijnít, —Ma wʉ̃ʉ́hdih wã pebhna ma ʉb jʉ̃ʉ́wʉ́, behedih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Páant ã niijíchah joinít, ã wʉ̃ʉ́hdih Jesús pebhna ã ʉb jʉ̃ʉ́wʉ́chah, nemépboó déhea ʉb yoh bʉʉgánit, tʉbit caandíh ãt méméanap wʉt jĩ. Páant ã chãjachah ennit, Jesús nemépdih ãt jʉ̃ih bacanap wʉt jĩ. Pánih baca péanit, —Dáa, ma wʉ̃ʉ́h ã tʉ́i boona caá bʉca, behedih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Páant ã bacaatdih ennit, Dios ã wẽpatdih nihat cã́acwã ĩt en wʉ́hi bejep wʉt jĩ. Páant nemépdih ã bacaatjidih cã́acwã bʉ́dí ĩ jenah joyóchah, Jesúsboó ã bohénitdihjeh nin pah ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ñi tʉ́i joyoó. Weém yeebdíh bainí wã naáwát tʉ́ʉt caá. Weém nihat cã́acwã ʉ́ʉd jeñédih cã́acwã teonit, bitadih ĩ wʉ̃hbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Páant ã niijíchah joiná yʉhna, Dios queétdih ã beh joyát tʉ́ʉtcah, ĩt tʉ́i beh joicáp wʉt jĩ. Pánih beh joicán, ĩ jwʉ́ʉb ʉʉ́bh joyátji déeji ĩt tíiquip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Páant Jesús ã niiját tʉ́ttimah, ã bohénitboó nin pah queétjeh ĩt míic niijíp wʉt jĩ: “¿Déhe tigaá jwĩ cãtíh jwĩ maáh panihni?” ĩt míic niíj jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Páant ĩ míic niíj jʉ̃ihñatdih jéihnit, biíc wébítdih Jesúsboó ã pebh ãt wái boj dodhdop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Det wĩ́ihwã jʉmna, nin wébít panihni, oboh jʉmnidih wẽi jwãáhnit, weemdíhbʉt wẽi jwãáhnit caá. Det weemdíh wẽi jwãáhnit, weemdíh wahnijidihbʉt wẽi jwãáhnit ĩ jʉmna caá. Pánihna, ded nin wébít dée oboh jʉmniboó ñi maáh panihni ã jʉmna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Páant ã niijíchah joinít, Juanboó Jesúsdih nin pah ãt niijíp wʉt jĩ: —Bohéní, jwĩ enechah, biíc newé ma wẽpatjĩh nemépwãdih ã bacat tʉ́ʉtʉp be. Obohjeéhtih, jwĩjeéh jʉmni ã nihcah, caandíh páant jwĩ chãjat tʉ́ʉtcap be, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Páant caandíh ñi niijcá bojoó. Ded yeebdíh en jʉ̃ihcanni jʉmna, ñijeéh ã jʉmna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pánihat tʉ́ttimah, jeáboó ã pʉ́ʉh laab béjat yeó jáap pínah tóah jʉ̃ʉ́wʉ́chah, “Weemdíh Jerusalén tʉ́tchina bejat caá náahap”, Jesús bʉ́dí ãt niíj jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Páant niíj jenah joinít, biquína ã bohénitdih Samaria baácdih bóo tʉ́tchina ĩ ʉ̃wat pínah pebhboó ĩ ámoh páñat pínah niijná, ĩ jã́tih ãt wah waáwá bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Obohjeéhtih, caán tʉ́tchiboó ĩ jʉibínachah yʉhna, Jerusalén tʉ́tchina Jesús ã bejat doonádih joinít íijna, caán tʉ́tchidih moón caandíh ĩt náahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Páant ĩ náahcat doonádih joinít, Jesús ã bohénit Santiago Juanjĩh nin pah Jesúsdih ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Maá, meemdíh ĩ náahcatji peéh, queét ĩ iíg beedáát pínah niijná, jeámant iigátdih jwĩ dei jʉ̃ʉ́wát tʉ́ʉt jĩíh? ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Páant ĩ niijíchah joinít, Jesús tac pʉ́ʉd ennit, —Yeéb íijnit, ñi peéh chãjíhichah, ã tʉ́ican caá. ");
INSERT INTO cbv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Weém, nihat cã́acwã ʉ́ʉd jeñé cã́acwãdih yohat tʉ́ʉt niijná, nin baácboó wã dei jʉ̃óhcap jĩ. Obohjeéhtih ĩ yéejat peéh iiguípna ĩ bejat déejidih queétdih tʉ́i ʉbat tʉ́ʉt niijná, wã dei jʉ̃ʉ́wʉ́p jĩ, Jesús queétdih ãt niíj jʉ̃ihñʉp wʉt jĩ. Páant niijnít, biíh tʉ́tchina ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Páant Jesúswã namáboó ĩ bejechah, biíc ĩjeéh péeni Jesúsdih nin pah ãt niíj naáwáp wʉt jĩ: —Deyoób ma bejechah, weembʉ́t majeéh wã bejmi caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—Jia mʉjjiowã́ ĩ́ih mʉʉ́ pínah íitnadih ĩ bíbohna caá. Jwébehwãbʉt ĩ́ih yécanadih ĩ bíbohna caá. Obohjeéhtih, weém nihat cã́acwã ʉ́ʉd jeñé wĩ́ih mʉʉjéh pohba wã bíbohcan caá. Pánihna, wãjeéh ma jʉ̃ʉ́wʉ́chah, bʉ́dí bʉwat meemdíhbʉt ã jʉmbipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Páant ĩ bejechah, Jesús biíh ĩjeéh péeniboodíh —Wãjeéh ma jʉ̃ʉ́wʉ́, ãt niijíp wʉt jĩ. —Wã bejmi caá, Maá. Obohjeéhtih, wã bejat pínah jã́tih wã íip ã wʉnʉchah, ã́ih bácahdih wã yohat pínah niijná, ‘Ma chão jwʉ́hʉʉ́’, weemdíh ma niijí. Ã wʉnʉchah, yoh péanit, majeéh wã péebipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Weemdíh náahcannit wʉnnit panihnit jʉmna, queét wʉnnitdih ĩ yoho naáh. Obohjeéhtih, meémboó wãjeéh jʉmni pínah bʉʉ ma jʉ̃ʉ́wʉ́. Wĩ́ih tewatboodíh chah jenah joinít, Dios maáh ã jʉmat dooná, bitadih naáwádih bejat caá meemdíh náahap, Jesús caandíh ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Páant ĩ bejechah, biíh ĩjeéh péenibʉt nin pah Jesúsdih ãt niijíp wʉt yʉh jĩ: —Maá, majeéh wã bejmi caá. Obohjeéhtih, wã bejat pínah jã́tih ‘Wã bejna caá’, wã pebh moondíh wã niíj babhbat pínah niijná, weemdíh ma wahaá. Pánih chãj péanit, majeéh wã péebipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—Ded wã wʉtni tewatdih teo jwíihna yʉhna, ã weñat pínahdih jwʉ́ʉb jenah joí chãjnit, Diosdih teo wʉ̃hni pínah ã jéih jʉmcan caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tʉ́ttimah, Jerusalén tʉ́tchina bejna, Jesús setenta y dos ãjeéh péenitdih ñíonit, ãt wahap wʉt jĩ. Pánih wahna, ã bejat pínah tʉ́tchinadih ã jã́tih ĩ naóh waáwát pínah niijná, chénewã míic ãt wahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Queétdih ã wahat pínah jã́tih, nin pah ãt niíj naáwáp wʉt jĩ: “Wĩ́ih doonádih jepahnit pínah dawá ĩ jʉmna yʉh caá. Obohjeéhtih, daocánnit naóhnit ĩ jʉmʉchah, queét jepahíhnit ĩ joi jwʉ́hcan caá. Pánihna, yeébboó Diosdih ñi ʉʉ́bʉ́, chah dawá naóhnit pínahdih ã wahat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pánihna, naáwádih ñi bejeé. Bejnit, nin pah ñi tʉ́i jenah joyoó: Diosdih jepahcannit, jiowã́ cãtíh ovejawãdih wahat pah, yeebdíh wã wahna caá. ");
INSERT INTO cbv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pánih bejna, dinerodih ʉbcan, wʉh wʉʉ́hdihbʉt ʉbcan, biíh zapatosdihbʉt ʉbcanjeh, wẽpép ñi bejeé. Dawá cã́acwãdih tʉ́i naáwát tʉ́ʉt niijná, deddih jwãáh ʉʉ́bhna, chãocánjeh, bejat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ded ñi jwíih waadní mʉʉdíh moondíh ‘Dios ã tʉ́yat ñijeéh ã jʉmʉ naáh’, ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tʉ́init jʉmna, páant ñi niijíchah joinít, ĩ tʉ́i jepahbipna caá. Obohjeéhtih, tʉ́icannit jʉmna, páant ñi niijíchah yʉhna, ĩ jepahcan niít. Páant ĩ jepahcah, caán mʉʉdíh moondíh Dios ã tʉ́yat ã wihcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yeebdíh jwíih jepahnitjeéh ñi jʉm jwʉhʉʉ́p. Queét yeebdíh jeémát, babhbatdihbʉt ĩ wʉ̃hʉchah, ñi tʉ́i jeémp babhbaá. Yeéb queétdih teo wáacnit bohénachah, queétboó ñi teo wáacat jíib jeémát babhbat ĩ wʉ̃hʉchah, ã tʉ́ina caá. Caán tʉ́tchidih moondíh ñi bohé jwʉhna, ñi jwíih jʉibíni mʉʉdíhjeh ñi jʉm jwʉhʉʉ́p. ");
INSERT INTO cbv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ded tʉ́tchidih ñi jʉibínachah, yeebdíh jepahnit, dedé jeémátdih ĩ wʉ̃hʉchah, ñi tʉ́i jeémé. ");
INSERT INTO cbv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Caán tʉ́tchidih moón wʉnnitdih booanit, queétdih nin pah ñi niijí: ‘Dios yeebdíh bʉ́dí caá ã bidip, ã́ihwã ñi jʉmat pínah niijná. Wʉnnitdih ã booana, Maáh jʉmna ã wẽpatdih yeebdíh ã jʉ́ʉtna caá. Páant ã wẽpatdih jéihnit, ñi yéejatdih cádahna, tʉ́iniboodíh tʉ́ʉt nʉʉmnít, caandíh ñi jepahaá’, queétdih ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Obohjeéhtih, ded tʉ́tchidih jʉibí, bohéna, wʉnnitdih ñi booanachah yʉhna, ĩ jepahcah, ĩ́ih namádih bejnit, nin pah queétdih ñi niijí: ");
INSERT INTO cbv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Dios maáh jʉmna, ã wẽpat yeebdíh ã jʉ́ʉtʉchah yʉhna, yeébboó caandíh ñi jepahcap jĩ. Pánihna, ñíih tʉ́tchi becchídih jwĩ́ih jítchamant jwĩ pit yohna caá. Páant jwĩ chãjat pah, ñi jepahcatji jíib Dios yeebdíhbʉt ã yohbipna caá’, ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yeébboó nin pah wã niijátdih ñi tʉ́i náhninaá: Sodoma tʉ́tchidih moonjí tʉbit yeejép chãjnit ĩt jʉmʉp wʉt jĩ. Obohjeéhtih, queétdih Dios ã peéh chãjat chah, ã peéh chãjat pínah yeó jáapdih ñi bohéátdih jepahcannitboodíh ã peéh chãjbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Yeéb Corazín tʉ́tchidih moón, Betsaida tʉ́tchidih moondíhbʉt Dios bʉ́dí ã peéh chãjbipna caá! Weém ñíih tʉ́tchinadih jʉmna, Dios ã wẽpatjĩh bʉ́dí wã teo wáacachah yʉhna, ñi jepahcap jĩ. Tiro tʉ́tchidih moón, Sidón tʉ́tchidih moondíhbʉt Dios ã wẽpatjĩh páant wã teo wáacachah nihna, queétboó jáantjeh ĩ yéejatdih bʉ́dí jʉ̃inít, ĩta tʉ́ʉt nʉʉm tágaá. ");
INSERT INTO cbv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pánihna, Tiro tʉ́tchidih moón, Sidón tʉ́tchidih moondíhbʉt Dios ã peéh chãj láa, Corazín tʉ́tchidih moón, Betsaida tʉ́tchidih moondíhbʉt chah ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yeéb Capernaum tʉ́tchidih moondíhbʉt peéh chãjna, maáta panihnit chãjcanjeh, yeebdíh moh yéejnit Dios ã chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Ded yeebdíh joí jepahni, weemdíhbʉt jepahni caá. Obohjeéhtih, ded yeebdíh jepahcanni, weemdíhbʉt jepahcanni caá. Weemdíh jepahcanni, wã íip weemdíh wahnidihbʉt jepahcanni caá”, ãt niijíp wʉt jĩ. Páant ã niíj péanachah joinít, ã wahnitboó ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pánih bejnitji wẽinit, queét setenta y dos Jesús ã wahnitji ã pebhna ĩt jwʉ́ʉb jʉibínap wʉt jĩ. Pánih jwʉ́ʉb jʉibínit, nin pah Jesúsdih ĩt niijíp wʉt jĩ: —¡Maá, ma wẽpatjĩh jwĩ wʉtʉchah, nemépwã yʉh bʉca jepahnit, ĩt bac bej tagaá! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—Japmant wedóát pah ã bejechah, nemépwã ĩ maáh ã bʉʉ́g jéen jʉ̃ʉ́wʉ́chah, wã enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","¡Ñi joyoó! Wã wẽpat yeebdíh wãát wʉ̃hʉp be, maiwãdih, dʉ́owãdihbʉt jwãáhnit, ñi jéih chʉñat pínah niijná. Nemépwã ĩ maáh ã wẽpatjĩh yeejép ã chãjat déedih jãhat wẽpat wã wʉ̃hʉp be. Páant wã wʉ̃hʉchah, ã́ih nemépwã yeebdíh ĩ jéih yéejacan niít. ");
INSERT INTO cbv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pánihna, nemépwãdih yeéb ñi wʉtʉchah, ĩ jepahatdih ennit, bʉ́dí ñi wẽina yʉh caá. Obohjeéhtih, nin caá chah bʉ́dí ñi weñat pínah pohba: Yeéb Dioíhwã ã pebhboó bejnit pínah ñi jʉmʉchah, ã́ih papélah tólih panihniboó ñi wʉ̃tna daácni ã jʉmna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Páant niíj naóh péanit, Jesús Tʉ́ini Espíritu ã wẽpatjĩh bʉ́dí wẽinit, Diosdih nin pah ãt niijíp wʉt jĩ: “Paá, meém nihat baácdih moón ĩ maáh, nihat jeádih moonbʉ́t ĩ maáh ma jʉmʉchah, meemdíh bʉ́dí wã wẽina caá. ‘Jwiít tʉ́i jéihnit caá’, niijnítdih wã bohéátdih ma beh joyát tʉ́ʉtcap be. Obohjeéhtih, jéih jwʉhcannitboodíh mapĩ́ jéihyanap be. Páant mapĩ́ wẽi chãjna caá”, ã íipdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Páant ã íipdih niíj ʉʉ́bh péanit, ã pébh joi ñʉ́hnitdih nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: “Dios, wã íip nihat ã wẽpat biíc yoobó weemdíhbʉt ã wʉ̃hʉp be. Ded pah wã jʉmatdih wã íipjeh caá ã jéihyep. Biíh páant jéihni ã wihcan caá. Ded pah wã íip ã jʉmatdihbʉt weemjéh caá wã jéihyep. Det wã ñíonitdihbʉt caandíh wãpĩ́ bohéna caá. Pánihna, jwiítjeh caá caandíh jwĩ jéihyep”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Páant cã́acwãdih naóh péanit, ã bohénitdih tac pʉ́ʉd ennit, queétdihjeh nin pah ãt niijíp wʉt jĩ: “Yeéb wã wẽpatdih ennit, Dios weemdíh ã wahatjidih ñi tʉ́i jéihna caá. Pánihna, bitabʉt páant wã jʉmatdih jéihnit, queétbʉt tʉ́i wẽinit ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ñi jenah joyoó. Jon jã́tih Dios naáwátdih dawá naóh yapanitji, dawá maátajibʉt yeéb ñi ennidih bʉ́dí eníhna yʉhna, ĩt encap wʉt jĩ. Ñi joinídihbʉt bʉ́dí joííhna yʉhna, ĩt joicáp wʉt jĩ”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Biíh láa, Moisés ã wʉtatjidih bohénit poómpdih bóo Jesús pebh ãt jʉibínap wʉt jĩ. Pánih jʉibínit, nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Bohéní, Dios pebhna bejíhna, ded pah wã chãjbi? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—¿Moisés ded pah tigaá ãt niijjí? Caandíh enna, ¿dépah tií mapĩ́ niíj jenah joí? Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—‘Diosdih chah jenah joí, tʉ́i jepahnit, wẽina, caandíh bʉ́dí ñi oyoó. Meemjéh ma míic oyat pah mʉntih, bitadihbʉt bʉ́dí ma oyoó’, Moisés ãt niíj daacáp tajĩ, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Yoobópdih ma jepahna caá. Pánih chãjnit, wʉnna, Dios pebhna ma bejbipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Páant ã niijíchah joinít, Moisés ã wʉtatjidih bohéni ã tʉ́i chãjatdih jʉ́ʉtat tʉ́ʉt niijná, nin pah ãt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ: —¿Obohjeéhtih, Bohéní, deddih tigaá wã oibi? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Páant ã niijíchah joinít, nin ã jenah joiní naáwátjĩh Jesús ãt niíj naóh bohénap wʉt jĩ: —Biíc newé Jerusalén tʉ́tchimant Jericó tʉ́tchina ã dei bejechah, namá tacdih nʉʉmnít cã́acwã caandíh jwãáhnit, nihat ã́ih bií dée, ã dʉoní chóodihbʉt dʉ́ʉc wáyat tʉ́ʉt niijná, ĩ wʉn mao jwejep be. Páant ĩ wʉn mao jwejni namáboó ã ñajap be. ");
INSERT INTO cbv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Páant ĩ chãjat tʉ́ttimah, biíc sacerdote caán namádih dei bejna, ĩ wʉn mao jwejnijidih ã enep yʉh be. Obohjeéhtih, enna yʉhna, chãocánjeh, ã bóod pʉ́ʉd yap bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tʉ́ttimah, Leví ã jʉimená poómpdih bóobʉt ã bejep be. Caán ñajni pebh jʉibí ennit, chãocánjeh, caanbʉ́t ã bóod pʉ́ʉd yap bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Obohjeéhtih, páant ĩ yap bejat tʉ́ttimah, ñi eníhcanni Samaria baácdih bóo caán namádihjeh mʉntih ã dei bejep be. Pánih dei bejna, caán ñajnidih jʉibí ennit, caandíh ã jĩ́gah enep be. ");
INSERT INTO cbv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pánih jĩ́gah ennit, ã pebh jʉibínit, yíi, iguíh mac biícdih ã́ih yahwítnadih ã cohop be. Coh péanit, yégueh chóojĩh ã chéwep be. Chéo péanit, caandíh dʉoníji burrodih ʉb tʉ́ʉh cáagnit, ʉ̃wat tólihna jʉmni mʉʉná ã nʉmah bejep be. Caanná ʉb jʉibínit, nihat chei ã en dao dáa jʉ̃ʉ́wʉ́p be. ");
INSERT INTO cbv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cheibit, ʉ̃wat mʉʉ́ mínahdih caandíh ã en dawát pínah niijná, ã jíib chãjap be. Pánih jíib chãjnit, nin pah caandíh ã niijíp be: ‘Nindih ma tʉ́i en dao jwʉ́hʉʉ́. Caandíh ma en dawát pínah jíib wã wʉ̃hna caá. Pánihna, chah ma jwʉ́ʉb jíib náahachah, jwʉ́ʉb jʉinít, wã jwʉ́ʉb jíib chãj jã́habipna caá, páant mʉntih’, Samaria baácdih bóo mʉʉ́ mínahdih ã niíj naáwáp be, Jesús ãt niíj bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Páant niíj naóh bohé péanit, Moisés ã wʉtatjidih bohénidih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Queét biíc peihcannit bií déedih chewe maonijidih ennit, ¿déhe tibeé tʉ́i oini ã jʉm? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Caandíh jĩ́gah en teo wáacni ã tʉ́i oyop be, ãt niíj jepahap wʉt jĩ. —Pánihna, meembʉ́t bejna, biíc yoobó meemdíh eníhcannitdih oinit, ma tʉ́i teo wáacá, Jesús caandíh ãt niíj naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tʉ́ttimah, Jesúswã Jerusalén tʉ́tchina bejnit, bainí tʉ́tchidih ĩt jʉibínap wʉt jĩ. Ĩ jʉibínachah, caán tʉ́tchidih bóli, Marta wʉ̃t jʉmnih, Jesúswãdih miíh mʉʉ́boó mit chão jwʉ́hat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mi jwan, María wʉ̃t jʉmnihbʉt mit jʉmʉp wʉt jĩ. Maríaboó Jesús ã bohénachah, ã pebh mit joí chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Obohjeéhtih, Martaboó yójah jeémát teona, mit íijip wʉt jĩ. Pánih íijnit, Jesús pebh jʉibínit, nin pah mit niijíp wʉt yʉh jĩ: —Maá, wã jwan weemdíh mi teo wáaccah, weém biíc wilidihjeh wái náah jʉmni tewat ã jʉmna caá. ¿Páant mi teo wáaccah, weemdíh ma jĩ́gah encan niít? Weemdíh ma teo wáacat tʉ́ʉtʉ́, Marta mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—¡Marta, Marta, ma joyoó! Dawá tewatnabitdih meém tʉbit jenah joinít, ma míic íijana caá. ");
INSERT INTO cbv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Obohjeéhtih, wã bohéátdih jenah joyát caá chah náahap. Pánihna, Maríaboó chah tʉ́inidih mi ñíwichah, caántdih ded mi joyátjidih ã jéih dʉ́ʉc wáican niít, Jesús Martadih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Biíh yeó jáap Jesús ã íipdih ã ʉʉ́bʉ́chah, ã bohénitbʉt ĩt jʉmʉp wʉt jĩ. Páant ã ʉʉ́bh péanachah ennit, —Maá, Juanji ã bohénitdih Diosdih ded pah ĩ ʉʉ́bát pínahdih ãt bohénap wʉt jĩ. Caán ã bohéát pah mʉntih jwiítdihbʉt ma bohénaá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Páant ĩ niijíchah joinít, nin pah queétdih ãt niíj jepahap wʉt jĩ: —Yeéb Diosdih ʉʉ́bhna, nin pah ñi niíj ʉʉ́bʉ́: ‘Paá, meém chah tʉ́ini ma jʉmʉchah, meemdíh jwĩ wẽina caá. Ma wʉ̃t chah yáaat caá jwiít jwĩ náahna caá. Meém maáh ma jʉmatdih jéihnit, nihat cã́acwã ĩ jepaha naáh. ");
INSERT INTO cbv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yeó jáap jʉmat pah jwĩ jeémát pínahdih ma wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bita jwiítdih ĩ yéej chãjatdih jwĩ yohat pah, meembʉ́t jwiít jwĩ yéej chãjatdih ma yohoó. Nemépwã ĩ maáh jwiítdih ã yéejaíhichah, ma teo wáacá, jwĩ yéej chãjcat pínah niijná’, Diosdih ñi niíj ʉʉ́bʉ́, ã bohénitdih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Páant niijnít, ded pah ĩ ʉʉ́bát pínahdih nin pahbʉt ãt niíj naóh bohénap wʉt jĩ: —Ded chei tac yoób ã dée pebhna bejnit, ‘Némé, bainí jeémátdih weemdíh ma wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wã chéen yʉʉ́p jʉ̃óhni ã jʉyʉ́chah, caandíh wã wʉ̃hat pínah jeémát wã bíbohcan caá’, ã niijíchah, ");
INSERT INTO cbv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ã dée mʉʉ́ diítmant nin pah ã niíj jepah bacacan niít. ‘Weemdíh tac bʉʉgáca bojoó. Jáantjeh jẽc nem péanit, wã wehdih wãát nʉmah ʉ̃wʉp be. Meemdíh jeémát wʉ̃hat déedih, queétdih wã wʉquíhcan caá’, ã dée ʉʉ́bhnidih ã niíj jepahcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yeebdíh wã naóhna caá. Ã dée tíiccanjeh ã ʉʉ́bʉ́chah, jáanit dedé ã náahatdih ã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Pánihna, nindih ñi tʉ́i náhninaá: Tíiccanjeh ñi ʉʉ́bʉ́chah, ded pah ñi ʉʉ́bátdih Dios yeebdíh ã wʉ̃hbipna caá. Ded pah ñi náahatdih bidna, ñi bid cádahcah, ded pah ñi bidatdih yeebdíh ã wʉ̃hbipna caá. Jẽc panihnidih wʉʉ́mp mao cádahcah, Dios ã wãtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Det Diosdih tʉ́i ʉʉ́bhnit, ĩ ʉʉ́bátjidih ĩ bíbohbipna caá. Det Diosdih bidnit, caandíh ĩ jwãáhbipna caá. Det ĩ wʉʉ́mp mawachah joinít, jẽc panihnidih Dios queétdih ã wãtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Ñi wʉ̃ʉ́h yeebdíh queejdíh ã ʉʉ́bʉ́chah, bʉcdih ñita wʉ̃h taniít? Ñita wʉ̃hcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Mʉjbai tíipdih ã ʉʉ́bʉ́chah, dʉ́odih ñita wʉ̃h taniít? Ñita wʉ̃hcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yeéb cã́acwã yéejnit jʉmna yʉhna, ñi wehdih tʉ́inidih ñipĩ́ wʉ̃hna caá. Pánihna, Diosboó tʉ́ini yoobát jʉmna, det Tʉ́ini Espíritu ã waadát pínahdih ĩ ʉʉ́bʉ́chah, ñi íip jeáboó jʉmni caandíh ã waadát tʉ́ʉtbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Biíh yeó jáap biíc newé wéheat tʉ́ʉtcanni nemép jʉmni Jesús pebh ãt jʉibínap wʉt jĩ. Páant ã jʉibínachah, Jesús caán nemépdih ã́ih bácahmant ãt bacat tʉ́ʉtʉp wʉt jĩ. Páant ã bacat tʉ́ʉtʉchah, caán newé ãt jwʉ́ʉb wéhenap wʉt jĩ, páant mʉntih. Páant ã jwʉ́ʉb wéhenachah joinít, nihat en wʉ́hi bejnit, bʉ́dí ĩt jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Obohjeéhtih, bita nin pah ĩt niíj naáwáp wʉt jĩ: “Nemépwã ĩ maáh, Beelzebú wʉ̃t jʉmni, ã wẽpatjĩh caá Jesús nemépwãdih ãpĩ́ bacat tʉ́ʉtʉp”, ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bitaboó, “Dios ã wẽpatjĩhjeh nit ã yoób chãjap”, niijná, biíh ã wẽp chãj jʉ́ʉtatdih ĩtih bidip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Obohjeéhtih, “Beelzebú ã wẽpatjĩh nemépwãdih ã bacat tʉ́ʉtna caá”, ĩ niíj jenah joyóchah jéihnit, Jesúsboó nin pah queétdih ãt niíj naáwáp wʉt jĩ: “Det biíc baácdih moonjéh yʉhna míic maona, ĩta wʉn beedáh bej tagaá. Ded tʉ́tchidih moón biícwã yʉhna, míic maona, queétbʉt ĩta jweí peét bej tagaá. ");
INSERT INTO cbv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pánihna, Satanás, nemépwã ĩ maáh ã́ihwãdih ã bacanachah, biíc yoobó mʉntih ãta yap tagaá. Weém Satanáíh jʉmna nihna, ã́ihwãdih wãta bacacan tagaá. Ñi naóh yacat yoobópdih nihcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nemépwãdih bacanit, ĩ maáh Beelzebú ã wẽpatjĩh wã wʉtʉchah nihna, ñijeéh jʉmnitboó ¿déhe ã wẽpatjĩh tigaá ĩpĩ́ baca? Páant ĩ bacat tʉ́ʉtʉchah ennit, ‘Ĩ tʉ́i chãjna caá’, ñipĩ́ niijná caá. Pánihna, weém páant wã bacanachah ennit, ‘Ã tʉ́i chãjcan caá’, ñi jéih niijcán caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Obohjeéhtih, Dios ã wẽpatjĩh nemépwãdih wã bacanachah, Dios ã maáh wẽpat ñi cãtíh ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wẽpép newé nihat ã́ih tʉa nah déenadih bíbohni ã́ih mʉʉdíh ã wapachah, nihat ã́ih bií dée ã tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Obohjeéhtih, biíh caán chah wẽpniboó jʉí míic mao yap yohnit, nihat ã wẽp ñʉhat tʉa nah déenadih dʉ́ʉc wái, bií déedihbʉt dʉ́ʉc wáinit, ã pej jʉmnitdih ã pãáhbipna caá. Pánihat pah weém chah wẽpni jʉmna, nemépwã ĩ maáhdih wã jéih yap yohna caá. Yap yohnit, ã́ihwãdih wã dʉ́ʉc wáibipna caá, wĩ́ihwã ĩ jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ded wãjeéh teocanni, weemdíh en jʉ̃ihni, nemépwã ĩ maáhjeéh ã jʉmna caá. Pánih jʉmna, weemdíh jepahíhnitdih ã ñʉʉn yóhna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nemép ĩ bacaniji mʉʉ́ wihcapboó jibna, ã jʉmat pínah biíh mʉʉ pánihnidih ã táoh bidna caá. Pánih bidna yʉhna, jéih bid jʉicán, ‘Weemdíh ĩ bacaniji mʉʉná wã jwʉ́ʉb bejbipna caá, páant mʉntih’, ã míic niíj jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Páant niíj jenah joinít, ã jwʉ́ʉb jʉí enechah, ã́ih mʉʉjí tʉ́i tóodh ámohni panihni ã jʉmna caá. Obohjeéhtih, caán cã́acboó ã tʉ́ʉt nʉʉmcáh, ã́ih jẽc páantjeh pãa lajni panihni ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Páant ã jʉmʉchah ennit, nemépboó bita siete ã chéenwã chah yeejép wʉtnitdih bid wáacnit, queétdih ã nʉmah waadná caá. Páant yeejép ĩ wʉtʉchah, ĩ waadní chah yeejép ã jʉmbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús páant ã niiját pónih, cã́acwã cãtíh jʉmnih nin pah mit niíj ejep wʉt yʉh jĩ: —¡Meemdíh weép jʉm noma behanih mi wẽina nacaá! mit niíj ejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","—Obohjeéhtih, Dios naáwátdih joí jepahnitboó mi weñat chah ĩ wẽina caá, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Páant ã bohénachah, chah dawá cã́acwã Jesús pebh ĩ míic wáac jʉibínachah, nin pah queétdih ãt niíj naóh bohénap wʉt jĩ: “Yeéb bʉʉ láa moón tʉbit yeejépwã ñi jʉmna caá. Pánihnit jʉmna, Dios ã wẽpatjĩh ñipĩ́ chãj jʉ́ʉtat tʉ́ʉtna yʉh caá. Obohjeéhtih, yeebdíh páant wã chãj jʉ́ʉtcan niít. Jonásjidih Dios ã wẽp chãjat pahjeh mʉntih weemdíhbʉt chãjnit, ã wẽpat yeebdíh ã jʉ́ʉtbipna caá. Páant bóojeh ã wẽpat jʉ́ʉtat ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonásjidih bʉ́dí queéj ã jeéméchah, biíc peihcanni yeó jáap tʉ́ttimah, Dios caandíh jwʉ́ʉb ʉb bacanit, Nínive tʉ́tchidih moondíh ãt wahap wʉt jĩ.Pánihna, ded pah caandíh ã yapatjidih ã naáwáchah joinít, Dios caandíh ã wahatjidih queét ĩt jéihyep wʉt jĩ. Páant ã yapatji pah mʉntih weém nihat cã́acwã ʉ́ʉd jeñé wʉnnit, biíc peihcanni yeó jáap tʉ́ttimah wã jwʉ́ʉb boo pʉd jʉ̃ʉ́wʉ́chah, Dios weemdíh ã wahatjidih yeebbʉ́t ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jon jã́tih Salomónji ã tʉ́i jéihyat doonádih joinít, Sabá baácdih moón ĩ maáh wiliji, yʉʉ́p miíh baácmant ã naáwátdih joyódih mit jʉibínap wʉt jĩ. Obohjeéhtih, ninjĩh weém Salomón chah jéihni wã jʉmʉchah yʉhna, yeébboó weemdíh ñi joííhcan caá. Pánihna, Dios nihat cã́acwã ĩ yéejatji peéh chãjat pínah yeó jáapdih Dios pebh caántboó yeéb biícdih ñʉhnit, yeebdíh nin pah mi niíj naóh yacbipna caá: ‘Wã joiníji Salomóndih chah jéihni Jesús ã jʉmʉchah yʉhna, ¿dépanih tibeé yeébboó caandíh ñi jepahcan?’ mi niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jonásji Nínive tʉ́tchidih moondíh Dios naáwátdih ã naóh yapanachah, queét ĩ yéejatdih bʉ́dí jʉ̃inít, ĩt tʉ́ʉt nʉʉmʉ́p wʉt jĩ. Obohjeéhtih, Jonás chah wẽpni ninjĩh wã jʉmʉchah yʉhna, weemdíh joííhcan, yeébboó ñi tʉ́ʉt nʉʉmcáp be. Pánihna, ñi tʉ́ʉt nʉʉmcátji jíib, peéh chãjat pínah yeó jáapdih Dios pebh Nínive tʉ́tchidih moonjí yeéb biícdih ñʉhnit, queétbʉt yeebdíh ĩ naóh yacbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ded jiiátdih jiinít, jãh cáagcan, pamap dahjĩhbʉt ãpĩ́ páah jwejcan caá. Obohjeéhtih, caandíh japboó ãpĩ́ jií cáagna caá, nihat caán tólihboó waadnít ĩ tʉ́i enat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñíih quíib dahna ñíih jiiát dah panihni caá. Ã tʉ́i jʉmʉchah, ded pah ñi chãjatdih ñi tʉ́i enna caá. Obohjeéhtih, yeejép jʉmna, dʉpʉ́át dée ã jʉmʉchah, ded pah ñi chãjatdih ñi jéih encan caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Pánihna, ñíih quíib dah panihni ã tʉ́yʉchah, wã naáwátdih tʉ́i jenah joinít, tʉ́inidihjeh ñi chãjbipna caá. Obohjeéhtih, ã tʉ́icah, wã naáwátdih jenah joicán, yeejépboodíh ñi chãjbipna caá. Pánihna, ¡ñi tʉ́i chãja chaáh! Wã naáwátdih tʉ́i jenah joinít ñi jepahaá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús queétdih ã naóh péanachah, biíc fariseo Jesúsdih ã́ih mʉʉ́boó nʉmah jeémédih ãt bejep wʉt jĩ. Caanná waád jʉibínit, ĩ jeémát tʉ́ʉt niijná, Jesúswã ĩt jʉibí chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dios queétdih ã tʉ́i wẽi enat pínah niijná, queét judíowã ĩ jeémát pínah jã́tih ĩ nʉowã ĩ wʉtatji pah ĩpĩ́ téih chocop wʉt jĩ. Obohjeéhtih, Jesúsboó waadnít, queét ĩ wʉtatji pah téih choccanjeh ã jeéméchah enna, caandíh nʉmah jeémpni fariseoboó bʉ́dí ãt en wʉ́hi bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Páant ã en wʉ́hi bejechah ennit, Jesús nin pah caandíh ãt niíj naáwáp wʉt jĩ: —Yeéb fariseowã ñíih pamapnadih, ñíih babhbat dahnadihbʉt jiimantjeh ñipĩ́ chocna caá, ã tʉ́i jígohat pínah niijná. Páant ñi chocochah yʉhna, diítboó bʉ́dí queí ã jʉmna caá. Caan pámap jiimantjeh ñi chocat pah, yeebbʉ́t biíc yoobó ñi jʉmna caá. Ñi tʉ́i jígohna yʉhna, ñi jenah joyát yeejép ã jʉmna caá. Ñi weñat pínahdihjeh chãjnit, tʉbit en ñinahnitbʉt ñi jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Yeéb jenah joicánnit caá! ¿Pamap jiimant dée, Dios jwĩ́ih bácahdih chãjni, pamap diítboó dée, jwĩ́ih caolihdihbʉt chãjni nihcan niít? Pánih chãjnit, jwiítdih jéih beedáni caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pánihna, pamap diítboobʉ́t chocat pah, ñíih caolihdih tʉ́ʉt nʉʉmnít, moh yéejnitdih ñi teo wáacá. Pánih chãjnit, pamap quei wíhcat pah, Dios ã enechah, ñi tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Yeéb fariseowã bʉ́dí yeejép ñi yapbipna caá! Dios ã wʉtatdih jepahna, ded chénat pah téihya chej jʉmni nʉ́onadih bíbohnit, biíc nʉ́odih caandíh ñipĩ́ wʉ̃hna yʉh caá. Obohjeéhtih, pánih wʉ̃hna yʉhna, biíh ã wʉtatnadih ñipĩ́ joyáh bojna caá. Cã́acwãdih tʉ́i chãjatboodíh ñi jenah joicán caá. Diosdih ñi oyatdihbʉt ñipĩ́ jenah joicán caá. Dios ã wʉtat pah, chej jʉmni nʉ́onadih caandíh ñi wʉ̃hʉchah, ã tʉ́ina caá. Obohjeéhtih, biíh ã wʉtatdihbʉt jepahat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Yeéb fariseowã bʉ́dí yeejép ñi yapbipna caá! Jwiít judíowã jwĩ míic wáacat mʉʉ́boó waád jʉibínit, waáwápna ñipĩ́ chʉ́ʉdna caá, nihat cã́acwã yeebdíh ĩ wẽi enat pínah niijná. Tʉ́tchi tacboó bií dée jíib chãjat jʉʉ́hna bejnit, cã́acwã yeebdíh ĩ wẽi jwãáátdih ñipĩ́ náahna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Yeéb fariseowã bʉ́dí yeejép ñi yapbipna caá! Yeéb cã́ac tacchiana panihnit ñi jʉmna caá. Cã́acwã baác diítboó jéih en waadácan, caán tacchianajih yáac chʉ̃i bejna, ĩ yohniji yagáp ã jʉmatdih ĩ jéih encan caá. Caan pánihat pah cã́acwã ñi bohéátdih joinít, ñíih caolihdih jéihcan, ñi jenah joyát yeejép ã jʉmatdih ĩ jéihcan caá”, Jesús queét fariseowãdih ãt niíj jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Páant fariseowãdih Jesús ã niíj jʉ̃ihñʉchah joinít, Moisés ã wʉtatjidih tʉ́i jéihni jwʉh nin pah Jesúsdih ãt niijíp wʉt jĩ: —¿Bohéní, queétdih páant niíj jʉ̃ihna, jwiítdihbʉt jʉ̃ih niít ma chãjap? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Páant ã niijíchah joinít, Jesús queét Moisés ã wʉtatjidih bohénitdih jwʉh nin pah ãt jwʉ́ʉb niíj jʉ̃ihñʉp wʉt jĩ: —¡Yeebbʉ́t bʉ́dí yeejép ñi yapbipna caá! Yeéb cã́acwãdih bʉ́dí wái náah jʉmnidih chãjat tʉ́ʉtna, bainíbitjeh ĩ yapachah ennit, queétdih jĩ́gah encanjeh, bʉ́dí ñipĩ́ peéh chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Yeéb Moisés ã wʉtatjidih bohénit bʉ́dí yeejép ñi yapbipna caá! Dios naáwátdih naóh yapanitjidih ñi nʉowã ĩt mao yohop wʉt jĩ. Pánihna, queétdih ñi weñat jʉ́ʉtat tʉ́ʉt niijná, ĩ́ih tacchianadih ñi tʉ́i ámohna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Obohjeéhtih, pánih chãjna yʉhna, ĩ bohéátjidih ñi jepahcan caá. Pánih jepahcan, ñi nʉowã ĩ chãjatji biíc yoobó ñi chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Dios, nihat jéihni jʉmna, nin pah ãt niíj naáwáp wʉt jĩ: ‘Weém wã naáwátdih naóh yapanit pínahdih, wã naáwátdih bohénit pínahdihbʉt cã́acwãdih wã wahbipna yʉh caá. Obohjeéhtih, cã́acwãboó biquína queétdih ĩ mao yohbipna caá. Bitadihbʉt yeejép ĩ chãjbipna caá’, Dios ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Nihat Dios naáwátdih naóh yapanitdih ĩ mao yohatji peéh yeéb bʉʉ láa moondíh caán waó jíib ã jʉmbipna caá. Jwíih mao yohni Abeldih ã mao yohatji jíib, pʉ́ʉ́ sacerdote Zacaríasdih, Dioíh mʉʉ́ coah tac yoób ĩ mao yohatji jíibbʉt, yeéb bʉʉ láa moondíh Dios ã peéh chãjbipna caá. Queét ĩ jepahcatji pahjeh, yeéb biíc yoobó weemdíh ñi jepahcatji jíib yeebdíhbʉt ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Yeéb Moisés ã wʉtatjidih bohénit bʉ́dí yeejép ñi yapbipna caá! ‘Jwiít Dios ã wʉtatdih bohénit caá’, niijná yʉhna, ã naáwátdih cã́acwã ĩ jéihyat déedih ñi jãhna caá. Pánih jãhna, Dios pebhboó ñi wãt waadát déedih bíbohna yʉhna, queétdih ñi wãt waadácan caá. Pánih chãjna, yeebbʉ́t waadcán, queétdihbʉt ñi waadát tʉ́ʉtcan caá”, Jesús queétdih ãt niíj jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Queétdih páant niíj jʉ̃ih péanit, Jesús ãt bac bejep wʉt jĩ. Páant ã bac bejechah, fariseowã, Moisés ã wʉtatjidih bohénit biícdih Jesúsdih naóh yacat tʉ́ʉt niijná, yeejép ã jepahachah joííhna, tʉbit caandíh ĩt ʉʉ́bh joí ñʉʉ́n pée bac bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Páant ã bohéát pónih dawá cã́acwã Jesús pebh míic wáac jʉibínit, ĩ míic tóo néeh chʉ̃i bejechah, Jesús ã bohénitdih nin pah ãt niíj naóh bohénap wʉt jĩ: “¡Yeéb ñi tʉ́i chãja chaáh! Fariseowã ĩ jenah joyát pah ñi jenah joicá bojoó. ‘Weém tʉ́inijeh caá’, ĩ niijíchah yʉhna, ĩ́ih caolih yeejép ã jʉmna caá. Páant ĩ jʉmat pah yeébboó ñi jʉmca bojoó. Páant niíj jenah joyát, pan paáát panihni ã jʉmna caá. Jwíih jígohcanni ã jʉmʉchah yʉhna, tʉ́ttimah ã jʉmatdih nihat ĩ jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pánihat pah, ded pah caolih diítboó jʉmna, jwíih jígohcan yʉhna, tʉ́ttimah ã jígohbipna caá. Ded ñi bih chãjnidihbʉt tʉ́ttimah cã́acwã ĩ jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ded pah dʉpʉ́napboó ñi niijátjidih baabápboó cã́acwã ĩ joibípna caá. Ded pah yeéb ñíih tólihboó daocánnitdih ñi jéyé niijátjidih, tʉ́ttimah dawá ĩ míic wáacapboó ĩ jwʉ́ʉb wẽpép naóh yapabipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wã chéenwãá, yeebdíh nin wã naáwátdih ñi tʉ́i náhninaá: Ñíih bácahdih mao yohnit pínahdih ñi ʉ́ʉmca bojoó. Páant ĩ chãjat tʉ́ttimah, yeebdíh chah yeejép ĩ jéih chãjcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Obohjeéhtih, ñi ʉ́ʉmat pínahdih wã naóhna caá. ¡Diosboodíh bʉ́dí ʉ́ʉmat caá náahap! Caanjéh ñi wʉnat tʉ́ttimah, yeebdíh peéh chãjna, iiguípna ã jéih wahbipna caá. Pánihna, caandíhjeh caá ʉ́ʉmat náahap. ");
INSERT INTO cbv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ñi náhni dahwaca bojoó. Dios yeebdíh oinit, ã quíib bʉʉdcán niít. Cinco jwébehwãdih chéne jʉ́dʉbit yeéb ñipĩ́ jíib teona caá. Botonit ĩ jʉmʉchah yʉhna, Diosboó biíc jwébehdihjeh ã quíib bʉʉdcán niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Obohjeéhtih, jwébehwã chah yeebdíh Dios ã oina caá. Bʉ́dí oinit, ñíih waó yoócnajeh débói ã jʉmatdih Dios ã tʉ́i jéihna caá. Páant ã oyatdih jenah joinít, ñi náhni dahwaca bojoó”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Cã́acwã ĩ joyóchah, ded ‘Weém Jesúíh caá’, ã niijíchah, weembʉ́t wã íipíh ángelwã ĩ joyóchah, ‘Caánboó wĩ́ih caá’, wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Obohjeéhtih, cã́acwã ĩ joyóchah, ded ‘Weém Jesúíh nihcan caá’, ã niijíchah, weembʉ́t wã íipíh ángelwã ĩ joyóchah, ‘Caánboó wĩ́ih nihcan caá’, wã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ded weém nihat cã́acwã ʉ́ʉd jeñédih yeejép wéhenachah yʉhna, ã tʉ́ʉt nʉʉmʉ́chah, yeejép ã wéheatdih Dios ã yohbipna caá. Obohjeéhtih, ded Tʉ́ini Espírituboodíh yeejép wéhenit, ã jéih tʉ́ʉt nʉʉmcát jíib, Dios ã yéejatdih ã yohcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wĩ́ihwã ñi jʉmat jíib cã́acwã yeebdíh teonit, naóh yacat tʉ́ʉt niijná, ñi míic wáacat mʉʉ́boó, peéh chãjat tʉ́ʉtnit pebhboó, bita ñi maáta pebhboobʉ́t ĩ ʉb bejechah, ‘¿Ded pah wã niíj jepahbi?’ ñi niíj náhni dahwaca bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Caanná ñi jʉibínachah, Tʉ́ini Espírituboó ded pah ñi jepahat pínahdih ã jéihyabipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Páant ã niíj naóh péanachah, ĩ cãtíh jʉmni Jesúsdih nin pah ãt niijíp wʉt jĩ: —Bohéní, jwĩ íip báadhda ã́ih bií dée jwiítdih ã wʉ̃hʉchah yʉhna, wã ʉ́ʉd jeñé nihatdih ʉbnit, wĩ́ih pínahdih ã wʉ̃hcap jĩ. Páant ã chãjachah, weemdíh wĩ́ih pínahdih caandíh ma wʉ̃hat tʉ́ʉtʉ́, ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Weém bií déedih pãáhni maáh nihcan caá. Pánih chãjat wĩ́ih pínah nihcan caá, caandíh Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Páant caandíh niijnít, nihat ãjeéh péenitdih nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —¡Ñi tʉ́i chãja chaáh! Dawá bií déedih ñi en ñinahca bojoó. ‘Dawá bií dée bíbohna, wã tʉ́i jʉmbipna caá’, ñi niijná yʉh caá. Obohjeéhtih, dawá bií dée bíbohat jíib nihcan caá jeáboó ñi bejat pínah, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Páant niíj naóhnit, ĩ tʉ́i beh joyát pínah niijná, nin ã jenah joiní naáwátjĩh ãt jwʉ́ʉb bohénap wʉt jĩ: “Biíc newé dawá bií dée bíbohni, ã́ih wápchiboó pácahi ã momochah, dawá ã quehep be. ");
INSERT INTO cbv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dawá ã quehechah ennit, nin pah ã míic niíj jenah joyóp be: ‘¿Ded pah wã chãjbi? Wĩ́ih pácahi wã ámohat pínah mʉʉ́ bainí ã jʉmʉchah, ã yáo yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nin pah wã chãjbipna caá: Caandíh ámohat mʉʉnádih wai yoh jéena péanit, chah bʉ́dí ámohat pínah mʉʉnádih wã chãjbipna caá. Pánih chãjnit, nihat wĩ́ih pácahidih, wĩ́ih bií déedihbʉt wã ámohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pánih ámoh péanit, nin pah wã míic niijbípna caá: “Dawá jópchina tʉ́i jʉmat tʉ́ʉt niijná, dawá bií déedih bʉʉ wã bíbohna caá, bʉca. Pánih jʉmnit, choonít, babh jeémpnit, wã wẽibipna caá”, wã míic niijbípna caá’, caán newé ã niíj jenah joyóp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Obohjeéhtih, páant ã niíj jenah joyóchah jéihnit, Dios caandíh nin pah ã niijíp be: ‘¡Jenah joicánniabeh! Bʉʉ cheijeh ma wʉnʉchah, míih caolih ã bʉʉdbípna caá. ¿Páant ma wʉnat tʉ́ttimah, nihat ma ámohniji bií dée deíh pínah tigaá ã jʉmbi? Meémboó caandíh ma jéih ʉb bejcan niít’, Dios caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pánihna, ded ã́ih pínahjeh dawá bií déedih en ñinah ʉb jwejnit, Dios ã weñat pínahdih bidcanjeh, bʉʉdní ã jʉmbipna caá”, Jesús cã́acwãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Páant niíj péanit, nin pah ã bohénitboodíh ãt jwʉ́ʉb niíj naóh bohénap wʉt jĩ: “Ded pah ñi jʉmatdih ñi náhni dahwaca bojoó. Ñi jeémát pínah, ñi dʉwát pínah yéguehdihbʉt, ñi náhni dahwaca bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Caandíh bidat chah Diosdih tʉ́i biícdih ñi jʉmat pínahboodíh ñi bidií. Páant ñi bidichah, caán yeebdíh oina, ñi jeémát pínah, ñi dʉwát pínahdihbʉt ã wʉ̃hbipna caá, ñi tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jwébehwãdih ñi jenah joyoó. Queét ĩ́ih jeémát pínahdih ĩpĩ́ momcan caá. Ĩ́ih jeémátdih ámohat pínah mʉʉná ĩpĩ́ bíbohcan caá. Pánihnit ĩ jʉmʉchah yʉhna, Dios queétdih ĩ jeémát pínahdih ãpĩ́ wʉ̃hna caá. Jwébehwãdih oina, ã en dawát chah, yeebdíh oinit, Dios ã tʉ́i en daoná caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yeéb bʉ́dí náhni dahwana yʉhna, ñi wʉnat pínah yeó jáapdih ñi jéih tʉ́ʉt nʉʉmcán niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pánih jéih tʉ́ʉt nʉʉmcán, bʉ́dí ñi náhni dahwana yʉhna, biíh pínahdihbʉt ñi jéih tʉ́ʉt nʉʉmcán niít. Pánihna, náhni dahwaat dedé pínah nihcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Cháanadihbʉt ñi jenah joyoó. Caán cháana behna, ã tʉ́i jígohat pínahdih ãpĩ́ teocan caá. Pánih teocan yʉhna, Maáh Salomónji ã́ih tʉ́ini yégueh chóo dʉonít, ã tʉ́i jígohatji chah, cháanaboó ã tʉ́i jígohna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Caán cháanadih Dios ã tʉ́i jígohat tʉ́ʉtna caá. Obohjeéhtih, cháana bʉʉ déedih jʉm, cheibit déedih ã diib téh bejna caá. Páant ã diib téhechah, cã́acwã ĩpĩ́ cáo yohna caá. Páant maátcanjeh ã jʉmʉchah yʉhna, Dios caán cháanadih tʉ́i jígohni ã chãjna caá. Caán cháanadih tʉ́ini yégueh dée pah ã wʉ̃hat chah, yeébboodíh Dios yéguehdih ã wʉ̃hbipna caá. Pánihna, caandíh náhni dahwacanjeh, Diosboodíh ñi tʉ́i jenah joyoó. ");
INSERT INTO cbv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ded pah ñi jeémát pínah, ñi babhbat pínahdihbʉt tʉbit náhni dahwa joi bídca bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nihat Diosdih jéihcannit bií déedih tʉbit ĩpĩ́ náhni dahwa joi bídna caá. Obohjeéhtih, ñi íipboó ñi jeémát pínah, ñi dʉwát pínahdihbʉt ded pah yeebdíh jʉdhdatdih ã jéihna caá. Pánih jéihna, yeebdíh ã teo wáacat pínahdih tʉ́i jenah joiná, bʉ́dí ñi náhni dahwaca bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pánihna, bií déedih ñi bidat chah, Dios ã maáh jʉmatdih bidnit, caandíh ñi tʉ́i jepahaá. Pánih jepahnit, ã́ih tʉ́ini doonádih bitadihbʉt ñi naáwá, queétbʉt caandíh ĩ jepahat pínah niijná. Páant ñi chãjachah, Diosboó nihat ñi náahatdih ã tʉ́i wʉ̃hbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yeéb wĩ́ihwã daocánnit jʉmna yʉhna, Diosdih tʉ́i jenah joinít, ñi ʉ́ʉmca bojoó. Páant ñi tʉ́i jenah joyóchah, Dios ñi íip yeebdíh bʉ́dí oinit, wẽinit, tʉ́inidih ã wʉ̃hbipna caá. Pánihna, yeebdíh ã pebhboó ã ʉb bejbipna caá, ãjeéh ñi tʉ́i jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ñíih bií déedih jíib chãj wʉ̃hna, caán jíibdih ʉbnit, tʉbit moh yéejnitdih wʉ̃hat caá náahap. Páant ñi chãjatji jíib, Dios ã jʉmʉpboó ñi jʉibínachah, yeebdíh tʉ́ini yoobátdih ã wʉ̃hbipna caá. Páant ã wʉ̃hni pínah ã bʉʉdcán niít. Ded nʉʉmní caandíh ã jéih nʉʉmcán niít. Pólohwãbʉt ĩ jéih jeémp yéejacan niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pánihna, Dios pebhboó ñíih bʉ́dí jíib jʉmni panihni ã jʉmʉchah, Dios ã weñat pínahdih ñi tʉ́i jenah joibípna caá. Obohjeéhtih, nin baácboojéh ñíih bʉ́dí jíib jʉmnidih bíbohnit, ñi weñat pínahdihjeh ñi jenah joibípna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Weemdíh ñi jenah joyátdih ñi tʉ́i míic ámoh páñaá. Ded pah míic ámoh páñatdih ñi beh joyát pínah niijná, nin bainí naáwátdih yeebdíh wã naóhna caá: ");
INSERT INTO cbv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Biíc newé ã chéeníh téihya chéwat weñatdih nʉmah jeémédih ã bejep be. Páant ã bejat tʉ́ttimah, chei ã jwʉ́ʉb jʉyát pínahdih pã́ina, jẽcdih wẽpép ĩ jéih wãtadih bejat tʉ́ʉt niijná, caandíh teo wʉ̃hnitboó ĩ́ih yégueh chóodih wái aabá chéonit, ĩ́ih jiiát dahnadihbʉt ĩ jií cáag pã́ina caá. Páant ĩ chãjat pah, wã jwʉ́ʉb dei jʉ̃ʉ́wát pínahdih yeebbʉ́t ñi jenah joyátdih ñi tʉ́i míic ámoh páñaá. ");
INSERT INTO cbv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ĩ maáh ã jwʉ́ʉb jʉyʉ́chah, caandíh teo wʉ̃hnit tʉ́i pã́init, bʉ́dí ĩ wẽibipna caá. Yoobópdih yeebdíh wã naóhna caá. Páant ĩ tʉ́i páñat jíib, ĩ maáhboó teo wʉ̃hnit ĩ dʉwát dée chóodih dʉó péa, queétdih chʉ́ʉdat tʉ́ʉtnit, jeémát ã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chei tac yoób, daa jʉ̃ʉ́wʉ́chah, caán ã jʉyʉ́chah yʉhna, tʉ́i pã́ina, queét bainí ĩ wẽican niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nin biíh bainí naáwátdihbʉt yeebdíh wã naóhna caá: Nindihbʉt ñi tʉ́i jenah joyoó. Débólih nʉʉmní cã́ac nʉʉmʉ́dih ã jʉyát pínahdih mʉʉ́ mínahboó jéihna, nʉʉmní ã jéih waadcát pínah niijná, tʉ́i jáanit, ã́ih mʉʉdíh ãta tʉ́i wap tagaá. ");
INSERT INTO cbv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pánihat pah, weém, nihat cã́acwã ʉ́ʉd jeñé, ñi jéihcat láa wã jwʉ́ʉb dei jʉ̃óhbipna caá. Pánih jéihcan, weemdíh tʉ́i jwãáát tʉ́ʉt niijná, ñi jenah joyátdih tʉ́i tʉ́ʉt nʉʉ́m páñat caá náahap”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Páant ã niijíchah joinít, Pedroboó nin pah Jesúsdih ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Maá, páant niíj naóhna, ¿jwĩ́ih pínahjeh niít? ¿Nihat cã́acwãíh pínah niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Páant ã niijíchah joinít, nin naáwátjĩh queétdih Jesús ãt jwʉ́ʉb bohénap wʉt jĩ: “Biíc teo wʉ̃hni tʉ́i jenah joiní, ã maáhdih tʉ́i jepahni ã jʉmʉp be. Páant ã jʉmʉchah ennit, ã maáh ã bejat pínah jã́tih, nihat bita caandíh teo wʉ̃hnit ĩ maáh pínah caandíh ã waadánap be, queét ĩ jeémát pínahdih yoobópdih ã wʉ̃hat pínah niijná. Pánih waadá péanit, biíh baácboó ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pánih bejniji ã́ih mʉʉná ã jwʉ́ʉb jʉyʉ́chah, caandíh teo wʉ̃hni ã wʉtatji pah ã chãjachah ennit, caandíh bʉ́dí ã wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yoobópdih yeebdíh wã naóhna caá. Caandíh wẽinit, nihat ã́ih bií déedih en daoní maáh ã waadábipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Obohjeéhtih, biíh caandíh teo wʉ̃hni tʉ́i jepahcan, ‘Wã maáh maatápdih jígohcan, bʉʉtéh ã jwʉ́ʉb jʉ̃óhcan niít’, niíj jenah joinít, bita teo wʉ̃hnit neoná yaádhdihbʉt pʉ̃init, ã jeémp babh máihñap be. ");
INSERT INTO cbv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ã náhnicanni yeó jáap, ã pã́icanni horadih ã maáhboó ã jwʉ́ʉb jʉibípna caá. Pánih jʉinít, caandíh ã jepahcatji peéh, tʉbit ã pʉ̃ibipna caá. Pánih pʉ̃i péanit, Diosdih jepahcannit biícdih iiguípna ã wahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pánihna, ded teo wʉ̃hni ã maáh ã weñat pínahdih jéihna yʉhna, tʉ́i ámoh pã́ican, ã maáhdih jepahcah, ã maáh caandíh peéh chãjna, bʉ́dí ã pʉ̃ibipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Obohjeéhtih, ded teo wʉ̃hniboó ã maáh ã weñat pínahdih tʉ́i jéihcan, yeejép ã chãjachah, ã yéej chãjat jíib bʉ́dí ãta peéh chãj tagaá. Obohjeéhtih, ã tʉ́i jéihcatdih ennit, caandíh peéh chãjna yʉhna, nʉmp ã pʉ̃ibipna caá. Pánihna, deddih tʉ́i chãjat pínahdih Dios bʉ́dí ã jéihyanachah, tʉ́i jepahat caá náahap. Ded maáhdih cã́acwã bʉ́dí wʉtat wẽpatdih ĩ wʉ̃hʉchah, tʉ́inijeh wʉtat caá caandíh náahap”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ñi náahcannidih ñi cáo yohat pah, Dios yéej chãjnitdih peéh chãjna, iiguípna ã yohat pínah niijná, nin baácboó wã dei jʉ̃ʉ́wʉ́p jĩ. ¡Jã́tih páant ã chãjachah nihna, wãta wẽi tagaá! ");
INSERT INTO cbv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Obohjeéhtih, páant ã peéh chãjat pínah jã́tih, weémboó bʉ́dí yeejép wã yapbipna caá. Pánih yeejép wã yapat pínahdih jéihnit, tʉbit wã jĩ́gahna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ded pah weemdíh ñi niíj jenah joí? ‘Ã́ih doonádih joinít, nihat cã́acwã tʉ́i biícdih ĩ jʉmbipna caá’, ¿ñi niíj jenah joí niít? Obohjeéhtih, páant ã nihcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cã́acwã wã naáwátdih ĩ joyát tʉ́ttimah, biícwãjeh jʉmna yʉhna, biíc peihcannit weemdíh jepahnitdih chénewã jepahcannitboó ĩ míic jʉ̃ihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Behe ã wʉ̃ʉ́hdih ã jʉ̃ihñʉchah, ã wʉ̃ʉ́hbʉt behedih ã jʉ̃ihbipna caá. Beh wili mi nʉʉmdíh mi jʉ̃ihñʉchah, mi nʉʉmbʉ́t beh wilidih mi jʉ̃ihbipna caá. Beh wili mi wʉ̃ʉ́h áadih mi jʉ̃ihñʉchah, mi wʉ̃ʉ́h áabʉt mi chʉdhdih mi jʉ̃ihbipna caá. Biquína weemdíh ĩ jepahachah, biquína ĩ jepahcat jíib páant tʉbit ĩ míic jʉ̃ihbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Páant ã bohénitdih naóh péanit, nin pah Jesús ĩjeéh péenitdih jwʉh ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: “Yeébboó yeó dei bejepmant mah tólihna ã jʉ̃ʉ́wʉ́chah enna, ‘Mah bʉʉgát tʉ́ʉt caá’, ñipĩ́ niijná caá. Ñi niiját pah ãpĩ́ bʉʉgná caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mah bʉʉgcáp bʉwámant johlit ã jʉ̃ʉ́wʉ́chah enna, ‘Chaíh chãhat tʉ́ʉt nihcan caá’, ñipĩ́ niijná caá. Ñi niiját pah tʉbit ãpĩ́ chãhna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Obohjeéhtih, yeéb yeejépwã, ‘Wã jéih beedána caá’, niíj jenah joiná yʉhna, jéihcannit caá ñi jʉmʉp. Baácdih, jeádihbʉt ennit, ded pah ã yapat pínahdih ñi jéihna yʉh caá. Obohjeéhtih, wã chãjatdih ennit, wã naáwátdih joiná yʉhna, ded pah tʉ́ttimah ã yapat pínahdih ñi jéihcan caá”, Jesús queét cã́acwãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ded pah ñi chãjat pínahdih yeebjéh jenah joinít, ñi tʉ́i chãjaá. ");
INSERT INTO cbv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yeebdíh naóh yacni peéh chãjat tʉ́ʉtni pebhboó ã nʉmah bejechah, ‘¿Majeéh tʉ́i jʉmat tʉ́ʉt niijná, ded pah tigaá wã chãjbi?’ caandíh ñi niijí, yeebdíh peéh chãjat tʉ́ʉtni pebhna ã ʉb bejcat pínah niijná. Páant caanjĩ́h ñi míic ámohcah, peéh chãjat tʉ́ʉtniboó yeebdíh nemat mʉʉ́boó ã nemat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Páant ã nemechah, nihat ñi jíib bʉʉdáátdih ñi jíib chãj péaat pínah jã́tih, yeéb ñi baccan niít. Pánihat pah, Diosdih ‘¿Majeéh tʉ́i jʉmat tʉ́ʉt niijná, ded pah tigaá wã chãjbi?’ niijnít, caandíh ñi jepahaá, yeebdíh ã peéh chãjcat pínah niijná”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Caán láa biquína Jesúsdih joinít nin pah caandíh ĩt niíj naáwáp wʉt jĩ: —Galilea baácdih moón Jerusalén tʉ́tchidih Dioíh mʉʉ́boó ovejadih cáo wʉ̃hnit, Diosdih ĩ wẽi ʉʉ́bʉ́chahjeh, Pilatoboó queétdih ãt mawat tʉ́ʉtʉp wʉt jĩ. Pánih maonit, oveja meép, cã́acwã ĩ maonitji meépjĩh ĩt widip wʉt jĩ. ¿Ded panih tigaá páant ĩt yap? queét Jesúsdih ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Páant ĩ niíj ʉʉ́bh joyóchah joinít, nin pah ãt niíj jepahap wʉt jĩ: —¿Ded pah tigaá yeebjéh ñi niíj jenah joí? ‘Páant queét tʉbit yeejép yapna, nihat bita Galilea baácdih moón ĩ yéejat chah niít ĩt yéej chãjap’, ¿yeéb ñi niíj jenah joí niít? ");
INSERT INTO cbv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nihcan caá. Dedé yéejatdih biíc yoobó Dios ã peéh chãjbipna caá. Yeébboó ñi yéejatdih cádahcan, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmcátji jíib ã peéh chãjachah, yeebbʉ́t iiguípna ñi bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nindihbʉt ñi tʉ́i jenah joyoó: Siloé wʉ̃t jʉmni jap bóo mʉʉ́ ã́ac jéennit, dieciocho cã́acwãdih ãt tãjap wʉt jĩ. ‘Pánih wʉnna, bita Jerusalén tʉ́tchidih moón ĩ yéejat chah ĩt yéej chãj tagaá’, ¿ñi niíj jenah joí niít? ");
INSERT INTO cbv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nihcan caá. Obohjeéhtih, yeéb ñi yéejatdih cádahcan, tʉ́iniboodíh ñi tʉ́ʉt nʉʉmcán, yeebbʉ́t wʉnna, iiguípna ñi bejbipna caá, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Páant niíj péanit, nin naáwátjĩh queétdih ãt jwʉ́ʉb bohénap wʉt jĩ: “Biíc newé ã́ih wápchiboó higuera wʉ̃t jʉmni nah ã jʉmʉp be. ‘Caan náh ã quehna nacaá’, niijnít, diquidih ã bejep yʉh be. Obohjeéhtih, caan náh ã quehcah, ã bid jʉicáp be. ");
INSERT INTO cbv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pánih bid jʉicán, ã́ih wápchidih teo wʉ̃hnidih nin pah ã niijíp be: ‘Weemdíh ma joyoó. Biíc peihcanni jópchi nin higuera nah quehedih wã bidip yʉh caá. Obohjeéhtih, ã quehcan caá. Páant ã quehcat jíib ma tib yohoó. Nin nah wĩ́ih wápchidih ã jʉmʉchah, biíh nahdih wã jéih momcan caá. Ã wihcah, biíh nahdih momnit, caan náh quehedih wãta jeémp tagaá’, caandíh teo wʉ̃hnidih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Páant ã niijíchah joinít, caandíh teo wʉ̃hni nin pah ã niíj jepahap be: ‘Maá, nin jópchidih pohba ã jʉm jwʉhʉ naáh. Nin nah pʉ́ʉj yehmant baád pʉ́ʉda péanit, nʉñʉ́p jónópdih wã yacbipna caá, míih higuera nah ã quehat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Páant wã chãjat tʉ́ttimah, ã quehmi dée caá. Ã quehcat ennit bácah, weemdíh ma yoób tib yohat tʉ́ʉtʉ́’, ã maáhdih ã niíj jepahap be. Pánihat pah, yeébboó ñi tʉ́ʉt nʉʉmát pínahdih Dios ã pã́ina caá. Maatápdih ã pã́ina beé. Pánihna, ñi tʉ́ʉt nʉʉmcát ennit bácah, yeebdíh ã yoób peéh chãjbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Biíh láa judíowã ĩ chooát yeó jáapdih ĩ míic wáacat mʉʉdíh Dios naáwátdih Jesús ãt naóh bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Caanjĩ́h nemép jʉmnih mit jʉmʉp wʉt jĩ. Nemépboó dieciocho jópchi caántdih ã jʉmʉchah, caántboó chóyó bejnihjeh mit jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Páant mi jʉmatdih ennit, Jesús caántdih ãt jʉ̃ʉ́wát tʉ́ʉtʉp wʉt jĩ. —Némá, meemdíh wã booana caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Páant niijnít, caántdih ã teo jã́hanachahjeh, yoobópdih mit ñʉhʉp wʉt jĩ. Pánih boonit, Diosdih bʉ́dí mit wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Obohjeéhtih, Jesús chooát yeó jáapdih caántdih ã booaat peéh, judíowã ĩ míic wáacat mʉʉdíh en daoní maáhboó ãt íijip wʉt jĩ. Pánih íijnit, caánboó míic wáacnitdih nin pah ãt niijíp wʉt jĩ: —Biíc semanadih seis yeó jáap jwĩpĩ́ teona caá. Pánihna, yeéb tʉbʉ́p chʉ̃ʉ́hnit booat tʉ́ʉtʉdih jʉ̃óhna, caán tewat yeó jáapnadihjeh ñi jʉ̃ʉ́wʉ́. Jwiít jwĩ chooát yeó jáapnadih páant ñi chãjca bojoó, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Páant ã niijíchah joinít, Jesúsboó queétdih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: —Yeéb yeenit caá. Yeebjéhbʉt chooát yeó jáapdih yʉhna, ñíih jiwidih, burrodihbʉt ĩ jeémát tólihmant watnit, mah ĩ babhbat pínah niijná, ñipĩ́ wái bac bejna caá. Pánih chãjna, teo tigaá ñi chãjap. ");
INSERT INTO cbv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Nint Abrahamji ã jʉimadih nemép dieciocho jópchi pohba chéonih dée ãt bíbohop be. Páant ã chéonihdih chooát yeó jáapdih wã watachah, ã tʉ́ican niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Páant ã niijíchah joinít, tíicnit, queét ĩt jepahcap wʉt jĩ. Pánihna, nihat cã́acwã Jesús ã wẽp chãjatdih ennit, bʉ́dí ĩt weñep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nin naáwátjĩh cã́acwãdih Jesús ãt jwʉ́ʉb bohénap wʉt jĩ: “¿Dios ã maáh jʉmat ded pahna tigaá, yeéb ñi jenah joyóchah? ¿Caandíh ñi jéihyat pínah niijná, dedédih jenah joinít tigaá, wã naóhbi? ");
INSERT INTO cbv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza tíib ded pah ã jʉmatdih jenah joinít, Dios ã maáh jʉmatdih ñi beh joibípna caá. Caán tíib cã́o tíbih pah bóo ã jʉmna caá. Momni ã́ih wápchiboó caán tíbihdih ã momop be. Ã momat tʉ́ttimah, chíihna, bʉ́dí nah ã behep be. Páant caan náh ã behechah, ã́ih cã́canaboó jwébehwã ĩ jaamáp be. Pánihat pah tigaá Dios ã maáh jʉmat. Ã́ihwã daocánnit jwíih jʉmnitji, tʉ́ttimah ĩ dao béjbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","“¿Dios ã maáh jʉmatdih ñi jéihyat pínah niijná, dedédih jenah joinít tigaá caandíh wã naóhbi? ");
INSERT INTO cbv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pan paáát ded pah ã jʉmatdih wã naáwáchah, caandíh ñi beh joibípna caá. Pandih chãjíhna, yad wili trigo ojdih pamapdih yacnit, mahjĩh wid, caandíh paááni pínahdihbʉt mipĩ́ tʉ́i widna caá. Pánihna, nihat mi widniji ã tʉ́i paabípna caá. Páant ã jʉmat pah Dios ã maáh jʉmat doonádih joinít, cã́acwã ĩ tʉ́ʉt nʉʉmbípna caá. Pánihna, queét joinítboó bitadih ĩ jwʉ́ʉb naáwáchah, dawá joinít, queétbʉt ĩ tʉ́ʉt nʉʉmbípna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tʉ́ttimah, Jerusalén tʉ́tchina bejna, dahwani tʉ́tchina, botoni tʉ́tchinadihbʉt Jesús Dios naáwátdih naóh bejna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Páant ã bejechah, biíc newé caandíh nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Maá, daocánnitjeh niít iiguípna bejnit déejidih Dios ã tʉ́i ʉbnit pínah ĩ jʉmʉp? ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, nin naáwátjĩh Jesús ãt jwʉ́ʉb bohénap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Yeéb dawá Dios ã jʉmʉpboó ñi waádíhna yʉh caá. Obohjeéhtih, bʉ́dí ñi yéejatdih cádahíhcan, ñi jéih waadcán caá. Bainí jẽc panihnidih waádíhna, ñi yéejatdih cádahat caá náahap. Pánihna, yeéb waadátdih bidna, ñi yéejatdih cádahnit, Diosboodíh ñi tʉ́i jepahaá. ");
INSERT INTO cbv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ñi beh joyát pínah niijná, mʉʉ́ mínah ded pah ã jʉmatdih wã naóhbipna caá. Chei caán mʉʉ́ mínah ã́ih jẽcdih ã nemna caá. Páant ã nemat tʉ́ttimah, yeébboó caán jẽcdih jʉibí, wʉʉ́mp maonit, nin pah ñi niíj ejbipna caá, ‘Maá, jẽcdih ma wãt jʉ̃ʉ́wʉ́’, ñi niijíchah, mʉʉ́ mínahboó diítmant nin pah ã niij bácabipna caá. ‘Dedmant ñi jʉ̃ʉ́wátdih wã jéihcan caá. Yeéb wã jéihca naáhwãdih wã wãtcan caá’, ã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Páant ã niijíchah joinít, yeébboó nin pah ñi jwʉ́ʉb niijbípna caá, ‘Majeéh jeémpnit, jwĩ babhbap jĩ. Jwĩ́ih tʉ́tchiboó jʉmna, ma naáwátdih jwiítdih ma bohénap jĩ’, ñi niíj ejbipna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yeéb páant ñi niijíchah yʉhna, caánboó nin pah ã jwʉ́ʉb niíj jepahbipna caá, ‘Obohjeéhtih, yeebdíh yoobópdih wã jéihcan caá. Pánihna, nihat yéejnit jʉmna, wã pebh jʉ̃óhcanjeh, biáboó ñi bejeé’, mʉʉ́ mínah ã niijbípna caá. Páant ã niiját pah Dios yeebdíh ã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pánihna, Abraham, Isaac, Jacob, nihat Dios naáwátdih naóh yapanitjibʉt, Dios pebhboó ĩ jʉmʉchah ennit, yeébboó jéih waadcán, tʉbit jĩ́gahna, ñíih maodíh ñi néeh chãác jʉ̃ibípna caá. Pánih jĩ́gahna, jóocmantjeh ñi chãobípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Caán láa nihat baácdih moón Dioíhwã ã pebhboó ĩ jʉibínachah, caánboó queétdih ã nʉmah jeémpbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nin baácboó oboh jʉmnitji Dios ã jʉmʉpboó maáta ĩ jʉmbipna caá. Ninboó maáta jʉmnitji Dios pebhboó moh yéejnit ĩ jʉmbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Páant ã niíj péanachahjeh, biquína fariseowã Jesús pebhna jʉibínit, nin pah ĩt niijíp wʉt jĩ: —Herodes meemdíh ã mawíh pã́ina caá. Pánihna, biáboó ma jwei béjeé, caandíh ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Páant ĩ niijíchah joinít, nin pah queétdih ãt niíj jepahap wʉt jĩ: —Nin pah caán yeejépabehdih niíj naáwádih ñi bejeé: ‘Jesús nemépwãdih baca, wʉnnitdihbʉt booana caá ã chãjap. Bʉʉ yeó jáap, cheibitbʉt páant ã chãjbipna caá. Pánihna, cheibit daani ã teo péabipna caá’, Herodesdih ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bʉʉ bej, cheibit bej, daanibʉt bejnit, Jerusalén tʉ́tchina wã jʉibíbipna caá. Dios naáwátdih naóh yapanitjidih caán tʉ́tchidih míicjeh ĩpĩ́ mao yohop wʉt jĩ. Pánihna, caán tʉ́tchina wã jʉibínachah, weemdíhbʉt ĩ mao yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yeéb Jerusalén tʉ́tchidih moondíh bʉ́dí wã jĩ́gahna caá. Dios naáwátdih naóh yapanitdih maonit, ñi pebhna bita ã wah bojnitdihbʉt jeejĩ́h yohnit, yeéb ñipĩ́ maona caá. Ñi nʉowãbʉt biíc yoobó ĩt chãjap wʉt jĩ. Pánihnit ñi jʉmʉchah yʉhna, yeebdíh bʉ́dí wã oina caá. Pánih oinit, mʉjbaima mi wehdih mi páamat pah, wã pebh yeebdíh wã jʉmat tʉ́ʉtna yʉh caá. Obohjeéhtih, yeébboó weemdíh ñi náahcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Páant ñi náahcat peéh, bʉʉ ñíih tʉ́tchidih Dios ã wap cádahbipna caá. Yoobópdih yeebdíh wã naóhna caá. Ninboó weemdíh ñi jwʉ́ʉb encan niít. Tʉ́ttimah bóo láa nin baácna wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chahjeh, weemdíh ñi jwʉ́ʉb enbipna caá. Pánih ennit, ‘Dios ã wahni, meemdíh bʉ́dí jwĩ wẽina caá’, weemdíh ñi niijbípna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Biíh chooát yeó jáapdih fariseowã ĩ maáh ã́ih mʉʉná Jesúsdih nʉmah jeémédih ãt bejep wʉt jĩ. “¿Ded pah caá ã chãjbi?” niijná, caán mʉʉdíh moón caandíhjeh ĩt tʉ́i en ñʉʉnʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Caán mʉʉdíh, bácah chalani ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Caandíh ennit, Moisés ã wʉtatjidih bohénitdih, fariseowãdihbʉt nin pah Jesús ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿‘Chooát yeó jáapdih tʉbʉ́p chʉ̃ʉ́hnitdih ñi booanaá’, Moisés ãt niijnít jĩí? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Páant ã niijíchah yʉhna, queét ĩt jepahcap wʉt jĩ. Ĩ jepahcat ennit, Jesús wʉnnidih teo jã́ha booanit, ãt jwʉ́ʉb bejat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pánih booa péanit, queét fariseowãdih ãt jwʉ́ʉb ʉʉ́bh joí jʉ̃ihñʉp wʉt jĩ. —Jwĩ chooát yeó jáapdih ñi wʉ̃ʉ́h, ñíih momo jiwibʉt íitna ã bʉʉg yác bejechah, yeéb ñita ʉb pʉ́ʉh laabácan taniít. ¿Páant ñi chãjat, tewat nihcan niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Páant ã niijíchah, ded pah ĩt jepahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús fariseoíh mʉʉná waadnít, bita ã nʉmah jeémpnit pínahboó waád jʉibínit, waáwápna ĩ chʉ́ʉdat pínahdih ĩ ñíwichah, Jesús ãt enep wʉt jĩ. Páant ĩ ñíwichah ennit, queét nihatdih nin pah ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Téihya chéwat nʉmah jeémát yeó jáapdih yeebdíh ã bid bojochah, caanná jʉibínit, waáwápna ñi chʉ́ʉdca bojoó. Páant ñi chʉ́ʉdʉchah nihna, ñi chah maáh ã jʉyʉ́chah, ");
INSERT INTO cbv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","‘Ma chʉ́ʉdni páhadih nindih ma chʉ́ʉdat tʉ́ʉtʉ́’, yeebdíh ã niijbípna caá. Páant ã niijíchah joinít, jwẽ́ejboó jʉibí chʉ́ʉdna, ñita tíic tagaá. ");
INSERT INTO cbv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Obohjeéhtih, mʉʉ́ mínah yeebdíh ã bid bojochah, jwẽ́ejdih bóo páhadih ñi jʉibí chʉ́ʉdʉ́p. Yeéb páant ñi chʉ́ʉdʉchah ennit, ‘Waáwápboó ñi chʉ́ʉd jʉ̃ʉ́wʉ́’, mʉʉ́ mínah yeebdíh ã niijbípna caá. Pánihna, yeéb waáwápboó ñi bejechah, bita ã bid bojnit yeebdíh ĩ tʉ́i wẽi enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ded caán míicjeh ‘Weemdíh dedé jʉdhdat wihcan caá’, niijnídih Dios moh yéejni ã chãjbipna caá. Obohjeéhtih, ded laihcanniboodíh Dios maáh ã waadábipna caá. Pánihna, yeebjéh míic maáta ñi waadáca bojoó. Diosjeh maáta pínahdih ã jéih waadána caá, queét jeémédih jʉibínitdih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Páant niíj péanit, Jesús mʉʉ́ mínahboodíh nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Ma nʉmah jeémíhna, ma pebh jʉmnitdih, bʉ́dí dinero bíbohnitdih, ma déewãdih, ma pej jʉmnitdihbʉt ma bidca bojoó. Meém queétdih ma bidichah, ma tʉ́i chãjat jíib, queétbʉt meemdíh biíc yoobó ĩ nʉmah jeémpbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Obohjeéhtih, bitadih ma nʉmah jeémíhna, moh yéejnit, jéih bejcannit, wio wihcannit, jéih encannitdihbʉt ma bidiíp. ");
INSERT INTO cbv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Queétboó meemdíh biíc yoobó ĩ jéih nʉmah jeémpcan niít. Páant ma tʉ́i chãjatji jíib, tʉ́init ĩ boo pʉd jʉ̃óhni yeó jáapdih Diosboó meemdíh ã tʉ́i chãjbipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Páant ã niijíchah joinít, biíc ĩjeéh chʉ́ʉdni Jesúsdih nin pah ãt niijíp wʉt jĩ: —Dios pebhboó ded ã nʉmah jeémpni bʉ́dí ã wẽibipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","—Bʉ́dí nʉmah jeémát chãjni dawá cã́acwãdih ã bidip be. Páant ã bidichah joinít, queét nihat ĩ tʉ́i wẽi jepah jwʉhʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Caán ã yoób nʉmah jeémát yeó jáapdih queétdih naáwát náahna, caandíh teo wʉ̃hnidih wahnit, ‘Nihat jwĩ jeémát pínahdih ámoh péanit, yeebdíh ã bidip be, bʉca’, ã niíj naáwát tʉ́ʉtʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Caandíh teo wʉ̃hni páant ã niíj naáwáchah joinít, queét ĩ jʉmat yoobó nin pah ĩ niíj jepahap be: ‘Weemdíh jéihcat dée caá. Bʉtéh jáap wáapdih jíib chãj péanit, caandíh enedih bejat tʉ́ʉt caá wã chãjap. Pánihna, ma maáhdih ma naáwá, weemdíh ã pã́icat pínah niijná’, ã jwíih bidni ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Biíhbʉt nin pah ã niíj jepahap be: ‘Weemdíh jéihcat dée caá. Bʉtéh biícjĩh bóo téihya máha jiwiwãdih wã jíib chãjap be. Pánih jíib chãjniji queétdih enedih bejat tʉ́ʉt caá wã chãjap. Pánihna, ma maáhdih ma naáwá, weemdíh ã pã́icat pínah niijná’, caanbʉ́t ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Biíhbʉt nin pah ã niijíp be: ‘Weém bʉtéh wã téihya chéwep be. Pánihna, nʉmah jeémátboó wã jéih bejcan caá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Páant ĩ niijíchah joinít, caandíh teo wʉ̃hni ã maáh pebhna jwʉ́ʉb jʉinít, queét ĩ niijátjidih ã jwʉ́ʉb naóh yapanap be. Páant ã naáwáchah joinít, ã maáhboó tʉbit íijnit, nin pah ã niijíp be: ‘Tʉ́tchi tac yoób bʉ́dí namánadih, bainí namánadihbʉt bejnit, moh yéejnit, jéih bejcannit, jéih encannit, wio wihcannitdihbʉt jwãáhnit, waícanjeh ma ʉb jʉ̃ʉ́wʉ́p’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pánih naáwádih bejniji jwʉ́ʉb jʉinít, ‘Maá, ma niijátji pah wã chãjap be. Páant wã chãjachah yʉhna, páantjeh chʉ́ʉdat ã jʉdhna caá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Páant ã niijíchah joinít, ã maáh caandíh ã jwʉ́ʉb wʉtʉp be. ‘Tʉ́tchi jwẽ́ejboó bʉ́dí namánaboó bejnitdih, bainí namánaboó bejnitdihbʉt ma jʉ̃ʉ́wát tʉ́ʉtʉ́, chʉ́ʉdatnadih ĩ tʉ́i yáwat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Meemdíh yoobópdih wã naóhna caá. Queét wã jwíih bidnitboó wã nʉmah jeémátdih ĩ jeémpcan niít’, ã niijíp be. Pánihat pah, Dios ã́ihwã pínahdih ã bidichah yʉhna, det ĩ weñat pínahdihjeh chah jenah joiná, caandíh jepahcannit, ãjeéh ĩ jʉmcan niít. Obohjeéhtih, caandíh jepahnitjeh ã pebhboó ãjeéh ĩ jʉmbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Biíh láa dawá cã́acwã Jesúsjeéh ĩt bejep wʉt jĩ. Pánihna, Jesús queétdih tac pʉ́ʉd ennit, nin pah ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ded wã bohéni jʉmíhna, bita chah weémboodíh oyat caá náahap. Ã íipdih, ã íindih, ã áadih, ã wehdih, ã déewãdih, ã déewã yaádhdihbʉt ã oyat chah weémboodíh oyat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ded wãjeéh pée bohéni jʉmíhna, ded pah ã weñat pínahdih jenah joicát caá náahap. Pánih chãjna, wĩ́ih ã jʉmat jíib yeejép yapna yʉhna, weemdíh cádahcat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nindihbʉt ñi jenah joyoó: Mʉʉ́ teoni jap bóo mʉʉdíh ã chãjat pínah jã́tih, ã jíib jʉyátdih jéihyat tʉ́ʉt niijná, caán mʉʉ́ jíib pínahdih ã jwíih jenah enna caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ã jíib pínahdih ã jwíih jenah encan, ã́ih mʉʉdíh ã jéih péacah enna, bitaboó caandíh ĩ deohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Nin pohba ã́ih mʉʉdíh teona, ãt péa tagaá’, ĩ niíj deohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nindihbʉt ñi jenah joyoó: Maáh biíh maáhjĩh ĩ míic mawat pínah jã́tih, nin pah ã niíj jenah joiná caá: ‘¿Weém diez mil soldadowã bíbohnit, caánboó veinte mil soldadowã ã bíbohochah, jwĩ míic maona, wãta jéih bʉʉjá taniít?’ ã niíj jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Páant niíj jenah joinít, ã bʉʉjácat pínahdih jéihna, biíh maáh ã́ih soldadowãjĩh míic mawadih jʉ̃óhnit, yʉʉ́pjeh ĩ jʉm jwʉhʉchah, ‘Jwĩ míic maoca boj jĩíh’, niiját tʉ́ʉtnit, caandíh teo wʉ̃hnidih ã wah bojbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pánihna, wĩ́ihwã jʉmíhna, weemdíh ñi jepahat pínah jã́tih, ‘Nihat wã yéej chãjatdih wã cádahbipna caá. Wĩ́ih bií déedih jenah joicán, Jesúsboodíh jenah joiná, caandíhjeh wã jepahbipna caá. Páant wã jepahat jíib, yeejép yapna yʉhna, caandíh wã cádahcan niít’, niíj jenah joyát caá náahap. Páant niíj jenah joinít jʉmna, wĩ́ihwã ñi jéih jʉmbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Páant niíj naóhnit, nin biíh naáwátjĩh Jesús queétdih ãt jwʉ́ʉb bohénap wʉt jĩ, ã jwíih naáwátdih ĩ beh joyát pínah niijná: “Nʉ́ʉmni bʉiná, jeémátdih ã tʉ́i nʉñana caá. Obohjeéhtih, nʉ́ʉmni ã bʉyát beedéchah, ñi jéih jwʉ́ʉb bʉyácan caá. ");
INSERT INTO cbv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pánih bʉicánni dedé pínah nihcah, caandíh yohatjeh caá náahap. Caán ã nihat pah yeéb ñi jʉmca bojoó. Dios naáwátdih tʉ́i joinít, caandíh ñi cádahca bojoó. ¡Ded molít jʉmna, ã tʉ́i joyó naáh!” Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Biíh yeó jáapdih dawá cã́acwã, Romanowã ĩ maáta ĩ ʉʉ́bát tʉ́ʉtnit dinerodih ʉʉ́bh wʉ̃hnit, bita Moisés ã wʉtatjidih jepahcannit “Yeejépwã”, niijnítbʉt Jesúsdih joyódih ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Páant ĩ jʉibínachah ennit, fariseowã, Moisés ã wʉtatjidih bohénitbʉt íijnit, queétjeh nin pah ĩt míic niijíp wʉt jĩ: —Nin newé yeejépwãdih tʉ́i wẽi jwãáhnit, ĩjeéh ãpĩ́ jeémpna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Páant ĩ niijíchah jéihnit, Jesús nin naáwátjĩh queétdih ãt bohénap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Cien ovejawãdih bíbohni, biíc oveja caandíh ã bʉʉdʉ́chah ennit, ¿ded pah tigaá ã chãjbi? yeéb ñi jenah joyóchah. Bita noventa y nueve ovejawãdih ĩ jeémát yílip jʉmʉpboó jwejnit, caán bʉʉdnídih bididih ã bejbipna caá. Pánihna, caandíh bid jʉinítna, ã cádahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Caandíh bid jʉí wẽina, ã́ih daadjíh mao cáagnit, ã́ih mʉʉná ã ʉb jwʉ́ʉb bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pánih ʉb jwʉ́ʉb jʉibínit, ‘Wĩ́ih oveja bʉʉdnídih wã bid jʉyʉ́p be. Pánihna, wãjeéh ñi wẽi wáac jʉ̃ʉ́wʉ́’, niijnít, ã pebh jʉmnitdih, ã déewãdihbʉt ã bid wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Páant ã weñat pah, ded biíc cã́ac ã yéejatdih cádahnit, ã tʉ́ʉt nʉʉmʉ́chah, Dios pebhboó jʉmnit bʉ́dí ĩ wẽibipna caá. Obohjeéhtih, noventa y nueve panihnit ‘Weemdíh yéejat wihcan caá. ¿Dépanih tigaá wãta tʉ́ʉt nʉʉ́m?’ niíj jenah joinítdih Dios pebhboó jʉmnit ĩ wẽican niít”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Diez dinero jʉ́dʉ bíbohnih biíc jʉ́dʉ caántdih ã bʉʉdʉ́chah ennit, ¿ded pah tigaá mi chãjbi? Jiiát dahjĩh jiinít, mʉʉdíh mi tʉ́i tóodh bid beedábipna caá. Caán jʉ́dʉdih bid jʉinítna, mi cádahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Caán jʉ́dʉdih bid jʉinít, ‘Weemdíh bʉʉdní dinero jʉ́dʉdih wã bid jʉiná beé. Pánihna, wãjeéh ñi wẽi wáac jʉ̃ʉ́wʉ́’, niijnít, mi pebh jʉmnitdih, mi déewãdihbʉt mi bid wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yoobópdih yeebdíh wã naóhna caá. Páant mi weñat pah, biíc yéejni ã yéejatdih cádahnit, tʉ́iniboodíh ã tʉ́ʉt nʉʉmʉ́chah, Dioíh ángelwãbʉt bʉ́dí ĩ wẽibipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","“Biíc newé chénewã ã weh jʉmʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ʉ́ʉdyiboó ã íipdih nin pah ã niijíp be: ‘ “Wʉnna, meemdíh wã wʉ̃hbipna caá”, ma niijnídih bʉʉ ma wʉ̃hʉʉ́, Paá’, ã niijíp be. Páant ã niijíchah joinít, ã íip ã́ih bií déedih ã wehdih ã pãááp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Daocánni yeó jáap tʉ́ttimah, ʉ́ʉdyiboó nihat ã́ih bií déedih ʉbnit, yʉʉ́p biíh baácboó jibidih ã bejep be. Caán baácboó jʉmna, cheha náahdih jíib chãj, yaádh metat jíib wʉ̃h, nʉmah jeémát jíib wʉ̃h, bʉ́dí ã jíib chãjap be. Pánih jíib chãjna, ã́ih dinerodih ã yoh beedánap be. ");
INSERT INTO cbv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Páant ã yoh beedáát tʉ́ttimah, caán baácboó jeémát wihcah, nʉʉgʉ́p láa ã jʉmʉp be. Caanbʉ́t nʉʉgʉ́pjĩh diib wʉ́nna ã chãjap be. ");
INSERT INTO cbv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Páant jeémát ã wihcah, tewat bididih ã bejep be. Páant ã bid bejechah, biíc newé caandíh ií náah jʉmni tewat wʉ̃hnit, ã́ih momo mʉʉwã jʉmni wáihyat jʉ́dʉboó caandíh ã wahap be, queétdih jeémát ã wʉ̃hat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pánih queétdih inna, queét mʉʉwãdih wʉ̃hni jeémátdih bʉ́dí ã jeémíhip yʉh be. Obohjeéhtih, ã maáh caandíh ã jeémát tʉ́ʉtcah, bitabʉt caandíh dedé jeémát ĩ wʉ̃hcap be. ");
INSERT INTO cbv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Páant ã yapat tʉ́ttimah, ã jwʉ́ʉb náhninap be, ‘Nihat wã íipdih teo wʉ̃hnit jeémát bíboh, ĩ jʉdh jeémpni jeémátbʉt ãpĩ́ jʉmna beé. Obohjeéhtih, nin baácboó jʉmna, weemdíh jeémát wihcah, wʉnna caá wã chãjap. ");
INSERT INTO cbv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pánihna, wã íip pebhna wã jwʉ́ʉb bejbipna caá. Caanná jwʉ́ʉb jʉibínit, wã íipdih nin pah wã niijbípna caá: “Diosdih bʉ́dí wã yéej chãjna beé, Paá. Meemdíhbʉt wã yéej chãjna beé. ");
INSERT INTO cbv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pánihna, ¡‘Wʉ̃ʉhʉ́’, bʉʉ weemdíh ma niijcá bojoó! Meemdíh teo wʉ̃hnijeh wã jʉmbipna caá”, wã íipdih wã niijbípna caá’, caán míicjeh ã niíj, jenah joyóp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Páant niíj jenah joinít, ã íip pebhna ã jwʉ́ʉb bejep be. “Pánih jwʉ́ʉb bejna, ã íipíh mʉʉdíh ã tóah bejechah, ã íipboó caandíh yʉʉ́pmah ã jwãáh enep be. Pánih jwãáh enna, ã́ih caolihjĩh bʉ́dí jĩ́gahnit, ã wʉ̃ʉ́hdih jwãáádih ã ñáo ñah bejep be. Jwãáhnit, caandíh bʉ́dí wẽina, ã pin tewep be. ");
INSERT INTO cbv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Páant ã pin tewechah, ã íipdih nin pah ã niíj naáwáp be: ‘Diosdih bʉ́dí wã yéej chãjap be, Paá. Meemdíhbʉt wã yéej chãjap be. Pánihna, “Wʉ̃ʉhʉ́”, weemdíh ma niijcá bojoó’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Obohjeéhtih, páant ã niijíchah yʉhna, ã íipboó caandíh teo wʉ̃hnitdih nin pah ã niíj wʉtʉp be: ‘Waícanjeh tʉ́ini yégueh chóodih ʉb jʉ̃óhnit, wã wʉ̃ʉ́hdih ñi yacaá. Tʉ́ini téihya yacat jʉ́dʉdih ã́ih téih tíibdihbʉt ñi yacaá. Ã́ih jítchadihbʉt tʉ́ini zapatos ñi yacaá. ");
INSERT INTO cbv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jwĩ tʉ́i in débehani momo jiwi wʉ̃ʉ́hdih ʉb jʉ̃óhnit, ñi mawaáp. Mao péa, quibh péanit, ñi pʉʉbʉ́. ");
INSERT INTO cbv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“Wã wʉ̃ʉ́h ã wʉnah bejna nacaá”, wã niíj jenah joyóp yʉh be. Bʉʉdní déeji bʉʉ ã tʉ́i jwʉ́ʉb jʉiná caá, bʉca. Bʉ́dí wẽinit, chóbe jeémpjĩh’, caandíh teo wʉ̃hnitdih ã niijíp be. Pánihna, queét nihat bʉ́dí wẽinit, ĩ jeémép be. ");
INSERT INTO cbv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Obohjeéhtih, ʉ́ʉdyi ã jwʉ́ʉb jʉyʉ́chah, weép jeñéboó momo jiwiwã jʉmni wáihyat jʉ́dʉboó ã jʉmʉp be. Pánihna, ã íipíh mʉʉdíh tóah bejna, ĩ wẽi ewechah, ã joyóp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pánih joinít, teo wʉ̃hnidih nin pah ã niíj ʉʉ́bh joyóp be: ‘¿Dépanih eo tigaá queét ĩ chãj?’ ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Páant ã niíj ʉʉ́bh joyóchah joinít, teo wʉ̃hni caandíh nin pah ã niíj jepahap be: ‘Ma ʉ́ʉd ã jwʉ́ʉb jʉiná beé. Ã tʉ́i jʉyʉ́chah, ma íip jwĩ in débehani momo jiwi wʉ̃ʉ́hdih ã mawat tʉ́ʉtʉp be. Pánih maonijidih jwĩ pʉʉ́b péanachah, nʉmah jeémp wẽi eona caá ĩ chãjap’, caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Páant teo wʉ̃hni ã niíj naáwáchah joinít, weép jeñé ã íipdih tʉbit ã íijip be. Íijnit, ã waádíhcap be. Páant ã waádíhcah enna, ã íipboó bac bejnit, ‘Wʉ̃ʉhʉ́, ma waád jʉ̃ʉ́wʉ́’, caandíh ã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Obohjeéhtih, ã íipdih nin pah ã niíj jepahap be: ‘Maatápdih meemdíh bʉ́dí teo wʉ̃hnit, ma naáwáchah wã yap yohcah yʉhna, wã pej jʉmnitdih wã nʉmah jeémát déedih cabra wʉ̃ʉ́hbitdih weemdíh mapĩ́ wʉ̃hcan beé. ");
INSERT INTO cbv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Obohjeéhtih, bʉʉ yeejép ma wʉ̃ʉ́h ã jwʉ́ʉb jʉyʉ́chah, yaádh metat jíib míih dinero yoh beedánidih bʉ́dí wẽinit, meém ma nʉmah jeémpna caá. Jwĩ in débehani momo jiwi wʉ̃ʉ́hdih maonit, caandíh ma nʉmah jeémpna caá’, ã íipdih ã niíj jʉ̃ihñʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Páant ã niíj jʉ̃ihñʉchah joinít, ã íip caandíh nin pah ã niíj jepahap be: ‘Wʉ̃ʉhʉ́, meém wãjeéh mapĩ́ jʉmna caá. Nihat wĩ́ih bií déedih míih mʉn caá. ");
INSERT INTO cbv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Obohjeéhtih, ma ʉ́ʉd wʉnni déeji bʉʉ ã tʉ́i jwʉ́ʉb jʉyʉ́p be. Pánihna, wẽinit, jwĩ nʉmah jeémp ewechah, ã tʉ́ina caá’, ã íip weép jeñédih ã niijíp be”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Biíh láa Jesús nin naáwátjĩh ã bohénitdih ãt jwʉ́ʉb bohénap wʉt jĩ: “Biíc newé bʉ́dí dinerodih bíbohni, ã́ih dinerodih en daoníboó ã tʉ́i en daocát ennit, biíh teo wʉ̃hniboó ĩ maáhdih ã naóh yacap be. ");
INSERT INTO cbv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Páant ã naóh yacachah, ĩ maáhboó ã́ih dinerodih en daonídih ã bid bojop be. Páant ã bid bojni ã jʉyʉ́chah, nin pah caandíh ã niijíp be: ‘Wĩ́ih dinerodih ma tʉ́i en daocát doonádih wã joyóp be. Pánihna, wĩ́ih dinerodih tʉ́i en daocát jíib weemdíh ma jwʉ́ʉb teo wʉ̃hcan niít. Ded pah wĩ́ih dinerodih ma chãjatjidih weemdíh ma naóh daác beedánaá’, ã maáh caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Páant ã niijíchah joinít, en daoníjiboó caanjéh nin pah ã niíj jenah joyóp be: ‘Wã maáh weemdíh yohat tʉ́ʉt caá páant ã niijíp. Weém wẽpcanni jʉmna, baác baadát tewatnadih wã bʉʉjácan niít. Weém bitadih dinero wã ʉʉ́bhna, tíic náah jʉmni wãta ʉʉ́bh tac bʉʉgá tagaá. Pánihna, ¿ded pah tigaá weemdíh chãjat náah? ");
INSERT INTO cbv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bʉʉ, wã chãjat pínahdih wã jéihna caá, bʉca. Nin pah wã chãjachah, wã teo cádahat tʉ́ttimah, wã maáhdih jíib bʉʉdánit weemdíh ĩ oibipna nacaá. Pánih oinit, jĩ́gah ennit, weemdíh ĩ teo wáacbipna caá’, caanjéh ã niíj jenah joyóp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Páant niíj jenah joinít, nihat ã maáhdih jíib bʉʉdánit yoobó ã bid bojop be. Páant ã jwíih bid bojni ã jʉyʉ́chah, nin pah caandíh ã niíj ʉʉ́bh joyóp be: ‘¿Wã maáhdih débóo tigaá meém ma jíib bʉʉdá?’ ã niíj ʉʉ́bh joyóp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Jeémát chãjat yíi cien dahwani quiítnadih caandíh wã jíib bʉʉdána caá’, ã niíj jepahap be. ‘Ninboó ma jíib bʉʉdáátdih daácni nʉ́o ã jʉmna caá. Waícanjeh jʉí chʉ́ʉdnit, ma jíib bʉʉdáátdih jwʉ́ʉb deyanit, tac yoobjéh ma daacá’, teo wʉ̃hni ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Páant niíj péanit, biíh jíib bʉʉdánidih bid bojnit, nin pah caandíhbʉt ã niíj ʉʉ́bh joyóp be: ‘¿Débóo tigaá wã maáhdih ma jíib bʉʉdá?’ ã niijíp be. ‘Cien trigo wʉh wʉʉ́hnadih wã jíib bʉʉdána caá’, ã niijíp be. ‘Ninboó ma jíib bʉʉdáátdih daácni nʉ́o ã jʉmna caá. Ochentajeh ma daacá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Páant ã chãjatdih jéihnit, ã maáhboó ã́ih dinerodih en daoníjidih nin pah ã niijíp be: ‘Meém yeeni yʉhna, ded pah tʉ́ttimah ma tʉ́i jʉmat pínahdih mat jenah joyóp taga’, ã niijíp be. Páant ã chãjat pah, Diosdih jéihcannit, tʉ́ttimah tʉ́i jʉmat tʉ́ʉt niijná, bií déenadih ĩ tʉ́i jéih ʉbna caá. Ded pah ĩ bíbohat pínahdih Dioíhwãboodíh chah ĩ tʉ́i jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Yeébboodíh nin pah wã naóhna caá: Moh yéejnitdih jĩ́gah ennit, ñíih bií déejĩh queétdih ñi tʉ́i teo wáacá. Páant ñi teo wáacachah, queétbʉt Diosdih jepahnit, ã pebhboó ñi jʉibínachah, yeebdíh ĩ wẽi jwãáhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ded bainíbit bíbohna yʉhna, caanjĩ́h bitadih tʉ́i teo wáacni jʉmna, tʉ́ttimah bʉ́dí bíbohna, caanjĩ́hbʉt ã tʉ́i teo wáacbipna caá. Obohjeéhtih, ded bainí ã bíbohatjĩh tʉ́i chãjcan, tʉ́ttimah bʉ́dí ã bíbohnabʉt, biíc yoobó ã tʉ́i chãjcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ñíih bií déejĩh ñi tʉ́i chãjcat enna, Diosboó ã wẽpatjĩh yeebdíh ã teo wáaccan niít. ");
INSERT INTO cbv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pánihna, nin baácboó jʉm jwʉhna, Dios yeebdíh ã wʉ̃hni bií déejĩh ñi tʉ́i chãjcat enna, jeáboó ñi jʉibínachah, tʉ́ini yoobátdih ã wʉ̃hcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ded Diosdih tʉ́i jenah joiní jʉmna, ã́ih bií dée pínahdih tʉbit ã jenah joicán niít. Obohjeéhtih, bií déedih tʉbit bidni jʉmna, Diosboodíh ã jéih jenah joicán niít. Pánihna, Diosdih bií déedihbʉt chénat pah biícdih ñi jéih jenah joicán niít. Diosdihjeh bidat caá náahap”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Páant ã niijíchah joinít, fariseowã dawá bií déedih bidnit jʉmna, caandíh ĩt dehwep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Páant ĩ dehwechah ennit, Jesús queétdih nin pah ãt niijíp wʉt jĩ: “Cã́acwã ĩ enechah pohba, yeéb tʉ́init pah tigaá ñi jígohop, ‘Nit tʉ́i chãjnit caá’, yeebdíh ĩ niíj jenah joyát pínah niijná. Obohjeéhtih, dawá bií déedih ñi bid jenah joyátdih Dios ã jéihna caá. ‘Nit tʉ́init caá’, cã́acwã ĩ niíj ennitdih Diosboó ‘Yeejépwã caá’, ã niíj enna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Juan Daabáni ã jʉmat pínah jã́tih, Diosjeéh tʉ́i jʉmat tʉ́ʉt niijná, Moisés ã wʉtatjidih, Dios naáwátdih naóh yapanit ĩ daacátjidihbʉt cã́acwãdih jepahat caá ãtih náahap. Obohjeéhtih, Juanboó Dios ã maáh jʉmat tʉ́ini doonádih cã́acwãdih ã jwíih naáwáp jĩ. Bʉʉ weem jwʉ́h caán tʉ́ini doonádih yeebdíh wã naóhna caá. Pánihna, yéejatdih cádahnit, Diosdih jepahat ã bʉwʉchah, det jepahíhnitboó Diosdih bʉ́dí bidat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jeá, nin baácbʉt ã bʉʉdʉ́chah yʉhna, Moisés ã wʉtatjiboó ã bʉʉdcán niít”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ded ãjeéh bólidih yohnit, biíh wilidih jwʉ́ʉb áa jʉmna, yeejép ã chãjna caá. Ded biíh áajidih jwʉ́ʉb tʉ́ʉt nʉʉ́m áa jʉmna, caántjĩh ã yéej chãjna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Dawá bií déedih bíbohni, dinerobʉt bʉ́dí bíbohni newé ã jʉmʉp be. Bʉ́dí jíib jʉmni tʉ́ini chítah jʉmni yégueh chóodih ãpĩ́ dʉwʉ́p be. Yeó jáap jʉmat pah tʉ́ini jeémátdih míic ãpĩ́ jeémép be. ");
INSERT INTO cbv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ã́ih mʉʉ́ jẽc pebh moh yéejni, Lázaro wʉ̃t jʉmni, ãpĩ́ ñajap be. Nihat ã́ih bácah áoh peétni ã jʉmʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Páant ã ñajachah, mʉjjiowã́ ã́ih áhwatnadih déebedih ĩpĩ́ jʉibínap be. Dawá bií déedih bíbohniboó ã jeémp jéenanidih Lázaro ã jeémíhip yʉh be. Obohjeéhtih, caandíh ãpĩ́ wʉ̃hat tʉ́ʉtcap be. ");
INSERT INTO cbv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Biíc yeó jáap, Lázaro ã wʉnʉp be. Abraham ã jʉima yoobát ã jʉmʉchah, Dioíh ángelwã Abraham pebhna ã́ih caolihdih ĩ ʉb bej wahap be. Cʉbʉcah, dawá bií dée bíbohnibʉt ã wʉnʉp be. Obohjeéhtih, ã wʉnat tʉ́ttimah, cã́acwã ã́ih bácahjidih ĩ yohochah, ã́ih caolih iiguípna ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Caánboó jʉmna, tʉbit ã tʉbanap be. Pánih tʉba chéi enna, Abrahamdih, Lázaro ã pebh ã ñʉhʉchah, ã enep be. ");
INSERT INTO cbv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pánih ennit, Abrahamdih nin pah ã niíj ejep be: ‘Nʉwá, weém nin iiguípboó wã jʉmʉchah, weemdíh tʉbit ã tʉbna caá. Páant ã tʉbʉchah, weemdíh jĩ́gah ennit, ma teo wáacá. Lázarodih ã́ih téih tíibjĩh mahdih taj daabánit, wĩ́ih nʉʉ́cdih ã cámahat pínah niijná, ma chíiaat tʉ́ʉtʉ́’, Abrahamdih ã niíj ejep yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Obohjeéhtih, páant ã niijíchah yʉhna, Abraham caandíh nin pah ã niíj jepahap be: ‘Jʉimá, meém baácboó jʉm jwʉhna, nihat ma náahatdih ma bíboh beedánap jĩ. Obohjeéhtih, Lázaroboó ã moh yéejep jĩ. Bʉʉ Lázaro ninjĩh ã tʉ́i jʉmʉchah, meemdíh caá tʉbit an tʉbʉp. ");
INSERT INTO cbv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jwĩ cãtíh jéih bejcat dée ã jʉmʉchah, ded ninmant conna ã jéih dei bejcan caá. Ded conmant ninnabʉt ã jéih aáb jʉ̃óhcan caá’, Abraham caandíh ã niíj jepahap be. ");
INSERT INTO cbv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Páant ã niijíchah joinít, dawá bií déedih bíbohniji nin pah ã jwʉ́ʉb niijíp be: ‘Nʉwah Abraham, wã íip pebhboó biícjĩh bóo téihya wã ʉ́ʉdwã páantjeh ĩ jʉmʉp be. Pánihna, wã ʉ́ʉdwãdih naáwát náahna, Lázarodih ma wahaá, queétbʉt nin iiguípna ĩ jʉ̃óhcat pínah niijná’, Abrahamdih ã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Obohjeéhtih, Abraham caandíh nin pah ã niíj jepahap be: ‘Dios naáwátdih Moisésji, bita ã naáwátdih naóh yapanitji ĩ daácni nʉ́onadihbʉt ma ʉ́ʉdwã ĩ bíbohna caá. Caán naáwátdih ma ʉ́ʉdwãdih jepahat caá náahap’, Abraham ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Páant ã niijíchah joinít, iiguípboó jʉmni nin pah ã jwʉ́ʉb niijíp be: ‘Yoobópdih tigaá ma niijíp, Nʉwah Abraham. Obohjeéhtih, biíc wʉnniji ĩ pebhna ã jwʉ́ʉb bejechah, queét caandíh joinít, ĩta tʉ́ʉt nʉʉm tágaá’, Abrahamdih ã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Queét Moisés ã daacátjidih tʉ́i joicán, bita naóh yapanit ĩ daacátjidihbʉt tʉ́i joicán, wʉnniji ã boo pʉd jʉ̃ʉ́wʉ́chah yʉhna, queét caandíhbʉt ĩ joibícan nacaá’, Abraham caandíh ã niijíp be”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Biíh láa, Jesús nin pah ã bohénitdih ãt niíj naáwáp wʉt jĩ: “Dawá yeebdíh yéej chãjat tʉ́ʉtnit ĩ jʉmbipna caá. Obohjeéhtih, ĩ yéej chãjat tʉ́ʉtatji jíib, Dios queétdih bʉ́dí ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nin wébít panihni weemdíh jáap jepahnitdih ded ã yéej chãjat tʉ́ʉtatji jíib Dios caandíh yeejép pohba ã peéh chãjbipna caá. Pánihna, caán ã yéej chãjat tʉ́ʉtat pínah jã́tih, ã́ih bʉtdih bʉ́dí jeé jʉ́dʉjĩh chéo bʉ́ʉdhnit, bʉ́dí mʉjna caandíh ĩ yohochah, ãta tʉ́i taga. Páant ĩ chãjachah, caán wébít panihnidih ã yéejacah nihna, Dios páant bóo pohba caandíh ãta peéh chãjcan taga. ");
INSERT INTO cbv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ded pah ñi chãjat pínahdih ñi tʉ́i jenah joyoó. Ñi dée yeebdíh ã yéej chãjachah, ‘Páant ma chãjatdih ma cádahaá’, caandíh ñi niijí. Páant ñi niijíchah joinít, tʉ́inidih ã tʉ́ʉt nʉʉmʉ́chah, yeébboó ã yéej chãjatjidih ñi jwʉ́ʉb náhnica bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pánihna, ñi déeboó biíc yeó jáapdihjeh siete láa yeebdíh yéej chãjnit, ‘Páant wã chãjatjidih wã jĩ́gahna caá. Chéneji wã jwʉ́ʉb chãjcan niít’, ã niijíchah, páant bóo láa ã yéej chãjatjidih ma jwʉ́ʉb náhnica bojoó”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Páant ã niijíchah joinít, Jesús ã bohénit caandíh nin pah ĩt niijíp wʉt jĩ: —Meemdíh chah jwĩ jenah joyát pínah niijná, jwiítdih ma teo wáacá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Mostaza bainí tíbih jʉmna yʉhna, chíihna, bʉ́dí nah ã behna caá. Pánihat pah, Dios ã wẽpatdih bainíjeh jenah joiná yʉhna, nin pah ñi jéih chãjbipna caá: Can bʉ́dí máa nahdih ‘Máa nahaá, meemjéh dʉg ñah bejnit, bʉ́dí mʉjna ma jʉibí ñʉhʉʉ́’, ñi niiját pahjeh ã bejbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“¿Yeebdíh teo wʉ̃hni wápchidih teo, ovejawãdih en daoníji ã jwʉ́ʉb jʉyʉ́chah, ded pah tigaá caandíh ñita niíj? ‘Ma jeémp jʉ̃ʉ́wʉ́. Ma jeémát pínahdih ninjĩh wã pʉʉ́b páñap be’, ¿ñita niijtá niít? ");
INSERT INTO cbv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Páant ñita niijcán tagaá. Nin pahjeh caá caandíh ñita niijíp: ‘Wã jeémát pínahdih ma pʉʉbbí jwʉhʉʉ́. Wã jeémp babhbachah, weemdíh ma pã́i jwʉhʉʉ́. Wã jeémp péaat tʉ́ttimah, meem jwʉ́h jeémpnit ma babhbaá’, yeebdíh teo wʉ̃hnidih ñita niij tágaá. ");
INSERT INTO cbv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yeebdíh teo wʉ̃hni ñi wʉtatdih ã chãjachah, caandíh ‘Tʉ́ina caá’, ñita niijcán tagaá. Páant ñi niijátdih bidcan, ã tewatdihjeh caá ãpĩ́ chãjap. ");
INSERT INTO cbv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pánihna, teo wʉ̃hnit ĩ jʉmat pah mʉn tigaá yeebbʉ́t ñi jʉmʉp. Dios ã wʉtatdih jepahnit, ‘Tʉ́ina caá’, ã niiját pínahdih bidcanjeh, nin pah yeebdíh niíj jenah joyát caá náahap: ‘Meemdíh teo wʉ̃hnijeh mʉn tigaá wã jʉmʉp. Ma wʉtatdihjeh tigaá wãpĩ́ tewep’, ñi niíj jenah joyoó”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Biíh yeó jáapdih Jesúswã Jerusalén tʉ́tchina bejna, Samaria baác, Galilea baác cãtíh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bainí tʉ́tchidih ĩ waadáchahjeh, diez bácah moópnitboó yʉʉ́p caandíh ĩt en ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Pánih ennit, nin pah ĩt niíj ejep wʉt jĩ: —Maá Jesús, jwiítdih ma jĩ́gah eneé, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Páant ĩ niíj ejechah, Jesús queétdih ennit, nin pah ãt niijíp wʉt jĩ: —Moisés ã wʉtatji pahjeh sacerdotewãdih ñíih bácahdih jʉ́ʉtʉdih ñi bejeé, caán moopát ã ñʉʉmátdih ĩ jéihyat pínah niijná, ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ĩ bejechahjeh, ĩ́ih bácah moopát ãt ñʉʉmáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Biíc ĩjeéh jʉmni ã́ih bácah ã ñʉʉmʉ́chah ennit, Jesús pebhna ãt jwʉ́ʉb bejep wʉt jĩ. Pánih jwʉ́ʉb bejnit, Diosdih bʉ́dí ãt wẽi ejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pánih wẽinit, Jesúíh jítcha pebh bódicha caj yoh ñajnit, “Tʉ́ina caá, Maá”, ãt niijíp wʉt jĩ. Caán bácah moópniji Samaria baácdih bóo judío nihcan wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","—¿Yeéb boonit diez nihcannit beé? ¿Bita nueve dépanih tigaá weñedih ĩ jwʉ́ʉb jʉ̃óhcan? ");
INSERT INTO cbv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nin biícjeh, judío nihcan yʉhna, Diosdih ‘Tʉ́ina caá’, niijídih ã jwʉ́ʉb jʉ̃ʉ́wʉ́p be. ¿Dépanih tibeé bita ĩ jʉ̃óhcan? Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Páant niijnít, bódicha caj yoh ñajnidih —Ñah ñʉhnit, ma jwʉ́ʉb bejeé. Wã wẽpatdih ma tʉ́i jenah joyát jíib ma boonap be, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Biíh yeó jáapdih fariseowã Jesúsdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Débólih tigaá nin baácboó Dios ã maáh jʉm jwíihbi? ĩt niijíp wʉt jĩ. —Dios ã maáh jʉmatdih yeéb cã́acwã ñi jéih encan caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Jã́aj, ninjĩh caá ã jʉmʉp’, ‘Jã́aj, cõj caá ã jʉmʉp’, ñi jéih niijcán caá. Obohjeéhtih, weém Dios ã wẽpatjĩh yeebdíh wã teo wáacachah, Dios ã maáh jʉmat ñi cãtíh ã jʉmna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Páant niíj péanit, Jesús ã bohénitdih jwʉh nin pah ãt niíj naáwáp wʉt jĩ: —Tʉ́ttimah, bʉ́dí yeejép yap láa ã jʉmʉchah, nin baácboó wã jwʉ́ʉb dei jʉ̃ʉ́wát pínahdih bʉ́dí ñi bidbipna yʉh caá. Obohjeéhtih, wã jígoh jwʉhcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‘Candih eneé. Can Dios ã wahni Cristo caá’, niíj, ‘Nin Cristodih eneé’, bita yeebdíh ĩ niijbípna yʉh caá. Páant ĩ niijíchah yʉhna, yeébboó queétdih ñi joyáh bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wedónachah, nihat yʉʉ́p jʉmna yʉhna, ĩ enat pah, weém nihat cã́acwã ʉ́ʉd jeñé, wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, nihat ĩ enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Obohjeéhtih, páant wã jwʉ́ʉb dei jʉ̃ʉ́wát pínah jã́tih, bʉʉ láa moón weemdíh náahcan, tʉbit yeejép ĩ chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Weém, nihat cã́acwã ʉ́ʉd jeñé wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, Noéwã jʉm láa ĩ jʉmatji pahjeh cã́acwã ĩ jwʉ́ʉb jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Caán láa moón nihat jeémp babhnit, téihya chéona ĩt chãjap wʉt jĩ. Pánih chãjna, Diosdih ĩt jenah joicáp wʉt jĩ. Páant ĩ jʉmʉchah, Noéwãji bʉ́dí jãáj chóoboó ĩ waadát tʉ́ttimah, Dios pobyit wahnit, caandíh náahcannitdih ãt mao beedánap wʉt jĩ. Páant ĩ jʉmatji pahjeh mʉn tigaá wã jwʉ́ʉb dei jʉ̃ʉ́wát pínah jã́tih cã́acwã ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot jʉm láa ĩ jʉmatji pahjeh, wã jwʉ́ʉb dei jʉ̃ʉ́wát pínah jã́tih, cã́acwã ĩ jʉmbipna caá. Caán láa moón jeémp, babh, jíib chãj, wápchidih taj, mʉʉ́ ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Páant ĩ chãjat pónih, Sodoma tʉ́tchimant Lotwãji ĩ jwei béjechahjeh, tʉʉ iigát panihni iigní jee dáhna jeámant ãt bʉʉ́g jéenep wʉt jĩ. Nihat caán tʉ́tchidih moondíh yohna, Dios caán iigátdih ãt wahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Páant ĩ jʉmatji pahjeh mʉn tigaá weém nihat cã́acwã ʉ́ʉd jeñé, wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, cã́acwã ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Caán yeó jáapdih ded ã́ih mʉʉ́ chahmant bóo coahboó jʉmni dei bejna, ã́ih bií déedih ʉbʉdih waadcánjeh, yoobópdih ã jwei béje naáh. Wápchiboó jʉmnibʉt ã́ih yéguehnadih ʉbʉdih ã jwʉ́ʉb bejca bojo naáh. ");
INSERT INTO cbv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot áaji ded pah mi yapatdih ñi náhninaá. Dios ã wʉtatjidih jepahcan, miíh bií déedih oinit, tac pʉ́ʉd enna, nʉ́ʉmni nah mit wẽéép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pánihna, ded ã weñat pínahdihjeh jenah joí chãjni, iiguípna bejni ã jʉmbipna caá. Obohjeéhtih, ded ã weñat pínahdih joyáh bojni, wã weñat pínahboodíh chãjni, ã bʉʉdcán niít. ");
INSERT INTO cbv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Yeebdíh yoobópdih wã naóhna caá. Wã jwʉ́ʉb dei jʉ̃óhni yeó jáapdih chénewã ĩ́ih mʉʉ́ diítna biícdih ĩ ʉ̃wʉchah, weemdíh jepahnidihjeh wã ʉbbipna caá. Weemdíh jepahcanniboó ã chãobípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chénewã yaádh biícdih ĩ tewechah, weemdíh jepahnihdihjeh wã ʉb bejechah, biíh wili chãobípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wápchiboó chénewã teonit ĩ jʉmʉchah, weemdíh jepahnidihjeh wã ʉbbipna caá. Biíh ã chãobípna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Páant ã niijíchah joinít, ã bohénit caandíh nin pah ĩt ʉʉ́bh joyóp wʉt jĩ: —¿Dedboo tígaá páant ã yapbi? ĩt niijíp wʉt jĩ. —Jóopwã ĩ jiíj jʉ́ʉdʉchah ennit, nʉñʉ́p ã moopópboó jéihna, biáboó ñi bidcan niít. Páant ñi jéihyat pah, dedjĩh wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah jéihna, biáboó bidcat caá náahap, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tʉ́ttimah, Diosdih ĩ ʉʉ́bh cádahcat pínahdih bohéna, nin pah Jesús ã bohénitdih ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Biíc tʉ́tchidih yéejat peéh chãjat tʉ́ʉtni ã jʉmʉp be. Caán Diosdih ʉ́ʉmcan, cã́acwãdihbʉt ãpĩ́ tʉ́i chãjcap be. ");
INSERT INTO cbv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Caán tʉ́tchidih éemp wʉnnihbʉt mi jʉmʉp be. Pánihna, peéh chãjat tʉ́ʉtni pebhna jʉibínit, ‘Weemdíh eníhcan, yeejép chãjnidih ma peéh chãjat tʉ́ʉtʉ́’, mi niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Páant mi niijíchah yʉhna, dawá láa caánboó ‘Wã peéh chãjcan niít’, caántdih ã niijíp be. Páant ã niijíchah yʉhna, caántboó caandíh chah mi ʉʉ́bh tac bʉʉgánap be. Páant mi ʉʉ́bh tac bʉʉgánachah yap joiná, caanjéh nin pah ã niíj jenah joyóp be: ‘Weém Diosdih, cã́acwãdihbʉt wã ʉ́ʉmcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Páant wã jʉmʉchah yʉhna, nintboó mi ʉʉ́bh tac bʉʉgána, weemdíh mi chʉʉábipna caá. Pánihna, caántdih yeejép chãjnidih wã peéh chãjat tʉ́ʉtbipna caá’, ã niijíp be”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Páant niijnít, Jesús queétdih nin pah ãt niíj jéihyanap wʉt jĩ: “Caán yéejat peéh chãjat tʉ́ʉtni ded pah ã chãjatdih ñi tʉ́i jenah joyoó. ");
INSERT INTO cbv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Caán tʉ́icanni yʉhna, caandíh ʉʉ́bh tac bʉʉgánihdih ã teo wáacap be. Diosboó tʉ́ini jʉmna, ã ñíonit ã teo wáacat pínahdih bʉ́dí ĩ bidichah, queétdih maatápdih ã páñat tʉ́ʉtcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pánih tʉ́i teo wáacnit, queétdih yeejép chãjnitdih waícanjeh ã peéh chãjbipna caá. Pánih tʉ́i jepahni ã jʉmʉchah yʉhna, weém nin baácboó jwʉ́ʉb dei jʉ̃óhna, daocánnit Diosdih tʉ́i jenah joinítdih wã bid jʉimí dée caá. Pánihna, yeébboó caandíh ñi tʉ́i jenah joí cádahca bojoó”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Páant niíj péanit, “Jwiítboó tʉ́init caá. Bitaboó yeejépwã caá”, niíj jenah joinítdih Jesús nin pah ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Chénewã Diosdih ʉʉ́bhna ĩ chãjap be. Biíc fariseo ã jʉmʉp be. Biíh Romanowã ĩ maáh ã wʉtni dinerodih ʉʉ́bhni ã jʉmʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pánihna, fariseo ñʉhnit, nin pah Diosdih ã niíj ʉʉ́bʉ́p be: ‘Weém bií déedih nʉʉmní, yaádhdih yéej chãjni nihcan caá. Nin Romanowã ĩ maáh ã wʉtni dinerodih ʉʉ́bhni ã yéej chãjat pahbʉt wã chãjcan caá. Bita ĩ yéej chãjat pah wãpĩ́ chãjcan caá. Pánih tʉ́i jʉmna, “Tʉ́ina caá”, meemdíh wã niijná caá. ");
INSERT INTO cbv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Weém semana jʉmat pah chéne yeó jáap jeémp jwʉhcanjeh, wãpĩ́ ʉʉ́bhna caá. Ded cien dinero jʉ́dʉdih wã jíib ʉbna, diez jʉ́ʉdʉdih meemdíh wãpĩ́ wʉ̃hna caá. Ma wʉtat pahjeh wãpĩ́ tʉ́i chãjna caá’, fariseo ã niíj ʉʉ́bʉ́p be. ");
INSERT INTO cbv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Obohjeéhtih, dinerodih ʉʉ́bhniboó ã yéej chãjatdih jĩ́gahna, yʉʉ́pbit yaíh dʉo ñʉ́hnit, japboó en ñahacanjeh, Diosdih nin pah ã niíj ʉʉ́bʉ́p be: ‘Dios, weém yéejni caá. Weemdíh jĩ́gah ennit, ma teo wáacá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yoobópdih yeebdíh wã naóhna caá. Caán dinerodih ʉʉ́bhni ã́ih mʉʉná ã jwʉ́ʉb bejechah, ‘Caán tʉ́ini caá’, Dios caandíh ã niíj enep be. Obohjeéhtih, fariseoboodíh ‘Caán tʉ́ini caá’, Dios ã niíj encap be. ‘Weém tʉ́ini, dedé yéejat wihcanni caá’, niijnídih ‘Meém tʉ́icanni caá’, Dios ã niíj enna caá. Obohjeéhtih, ‘Meemjéh caá tʉ́ini. Weém yéejni wã jʉmʉchah, weemdíh ma jĩ́gah en teo wáacá’, niijníboodíh Dios ã wẽi enna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Biíh láa, cã́acwã ĩ tʉ́ʉhnitdih ã teo jã́ha ʉʉ́bát pínah niijná, Jesús pebhna ĩt ʉb jʉibínap wʉt yʉh jĩ. Obohjeéhtih ã bohénitboó queétdih ennit, ĩt jípónih jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Páant ĩ jʉ̃ihñʉchah ennit, Jesús wébítdih jʉ̃ʉ́wát tʉ́ʉtnit, ã bohénitboodíh nin pah ãt niijíp wʉt jĩ: —Queét wébít wã pebhna ĩ jʉ̃ʉ́wʉ́ naáh. Ĩ jʉ̃ʉ́wát déedih ñi jãhca bojoó. Queét panihnit Diosdih chah ĩ tʉ́i jenah joiná caá. Páant moonájeh Dioíhwã ĩ jéih jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yoobópdih yeebdíh wã naóhna caá. Nit Diosdih ĩ tʉ́i jenah joyát pahjeh yeébboó ñi jenah joicáh, Dios ñi maáh ã nihcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Páant niijníji Jesús ã bohénit biícdih ã bejechah, judíowã ĩ maátajeéh jʉmni caandíh ʉʉ́bh joyódih ãt jʉibínap wʉt jĩ. —¿Tʉ́i Bohéní, páantjeh Diosjeéh tʉ́i jʉmíhna, ded pah tigaá wã chãjbi? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿Dépanih tigaá ‘Tʉ́ini’, weemdíh ma niíj? Diosjeh caá tʉ́ini. ");
INSERT INTO cbv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dios ã wʉtatnadih ma jéihna caá. ‘Ma áa nihcannihjĩh ma yéej chãjca bojoó.Cã́acdih ma mao yohca bojoó.Ma nʉʉmcá bojoó.Ma yeeca bojoó.Ma mánadih tʉ́inijeh ma chãjáp’,Dios ã niijíp jĩ. Caán ã wʉtatnadih jepahat caá náahap, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Wébít jʉmna, wã yap yohcatji pah, bʉʉbʉt biíc yoobó wã yap yohcan caá, Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","—Diosjeéh ma tʉ́i jʉmat pínah, bainí meemdíh ã jʉdhna caá. Nihat míih bií déedih jíib chãjadih ma bejeé. Pánih jíib chãjnit, caán jíibdih moh yéejnitdih ma wʉ̃hʉʉ́. Páant ma wʉ̃hʉchah, nin baácboó ma bíbohatji chah tʉ́ini míih pínah Dios pebhboó ã jʉmbipna caá. Wã niiját pah chãj péa, wãjeéh ma pée jʉ̃ʉ́wʉ́, Jesús caandíh ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Obohjeéhtih, páant ã niijíchah joiná yʉhna, caánboó dawá bií déedih bíbohni jʉmna, ã́ih bií déedih jíib chãj wʉ̃híhcan, bʉ́dí ãt jĩ́gahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Páant ã jepahcatdih ennit, Jesús nin pah ãt niijíp wʉt jĩ: —Ded dawá bií déedih bíbohni Diosdih ã jepahíhichah yʉhna, caandíh ã bʉona caá. ");
INSERT INTO cbv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camelloboó awí íitbitdih ã waad yábac bejíhichah nihna, ãta bʉo tagaá. Pánihat pah, dawá bií déedih bíbohni Dios ã maáh jʉmʉpboó ã waádíhichah, bʉ́dí ã bʉona caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Páant ã niijíchah joinít, bita caandíh nin pah ĩt niijíp wʉt jĩ: —Páant ma niijíchah bácah, Dioíh pínah ded ã jéih jʉmcan niít, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Cã́acwã ded pah ĩ jenah joyátjĩhjeh ĩ tʉ́i chãjíhna yʉhna, Dios pebhboó ĩ jéih bejcan niít. Diosjeh caá iiguípna bejnit déedih ã tʉ́i ʉbʉp. Caanjéh tigaá nihatdih chãj beedáni. Dedé jéihcat pínah caandíh ã wihcan caá, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Páant ã niijíchah joinít, Pedroboó caandíh nin pah ãt niijíp wʉt jĩ: —Weemdíh ma joi jwʉ́hʉʉ́. Majeéh péeat tʉ́ʉt niijná, jwiítboó nihatdih jwĩ cádahap jĩ, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","—Yoobópdih yeebdíh wã naóhna caá. Diosdih jepahni ã́ih mʉʉdíh, ã mánadih, ã déewãdih, yaddih, ã wehdih cádah bejnit, nin baácboó ã jʉm jwʉhʉchah, Dios chah dawá caandíh ã wʉ̃hbipna caá. Pánihna, ã wʉnat tʉ́ttimahbʉt, Diosjeéh páantjeh ã jʉmbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Páant niíj péanit, Jesús doce ã bohénitdih chibít yʉʉ́p bʉʉ́g ãt nʉmah bejep wʉt jĩ. Pánih bejnit, nin pah queétdih ãt niíj naáwáp wʉt jĩ: “Bainí yeebdíh wã naáwíhna caá. Bʉʉ Jerusalén tʉ́tchina bejna caá jwĩ chãjap. Caanná jwĩ jʉibínachah, Dios naáwátdih naóh yapanit jon jã́tih ĩ daacátji biíc yoobó weém nihat cã́acwã ʉ́ʉd jeñé wã yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Weemdíh teonit, judíowã nihcannitdih ĩ jwʉ́ʉb wʉ̃h yapabipna caá. Páant ĩ wʉ̃h yapanachah, queétboó weemdíh deoh naóhnit, mao mác coí jã́ha, yeejép wéhe, pʉ̃init, ĩ mao yohbipna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Obohjeéhtih, biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá”, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Páant ã niijíchah joiná yʉhna, ã bohénit ded pah ã naáwátdih ĩt beh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesúswã Jerusalén tʉ́tchina bejna, Jericó tʉ́tchina ĩt tóah jʉibínap wʉt jĩ. Caanjĩ́h jéih encanniboó namá jwẽ́ejdih chʉ́ʉdnit, dinero ʉʉ́bhna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pánih chʉ́ʉdnit, dawá ã pebh ĩ yap bejechah joinít, queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih tigaá dawá cã́acwã ĩ yap bej? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jesús, Nazaret tʉ́tchidih bóo ã yap bejna caá, caandíh ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Páant ĩ niijíchah joinít, caán ãt ej jwíihip wʉt jĩ. —¡Jesús, David jʉima, Dios ã wahni, weemdíh ma jĩ́gah eneé! ãt niíj ñaác ejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Páant ã niíj ñaác ejechah joinít, Jesúsdih waóhnitboó, nin pah ĩt niijíp wʉt jĩ: —¡Ma laihca bojoó! caandíh ĩt niíj jípónih jʉ̃ihñʉp wʉt jĩ. Páant ĩ niíj jʉ̃ihñʉchah yʉhna, caánboó chah ãt wẽp ejep wʉt jĩ. —¡David jʉima, Dios ã wahni, weemdíh ma jĩ́gah eneé! ãt jwʉ́ʉb niíj ñaác ejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Páant ã niíj ñaác ejechah joinít, Jesúsboó chão ñʉ́hnit, caandíh ã pebhna ãt ʉb bejat tʉ́ʉtʉp wʉt jĩ. Páant ã bejat tʉ́ʉtʉchah joinít, jéih encannidih Jesús pebhna ĩt ʉb bejep wʉt jĩ. Ã pebhna ĩ ʉb jʉibínachah, nin pah caandíh ãt niíj ʉʉ́bh joyóp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ded pah wã chãjat tigaá ma náah? ãt niijíp wʉt jĩ. —Maá, jéih enatdih caá wã náahap, ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—¡Ma eneé! Weemdíh tʉ́i jenah joiná, ma boona caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Páant ã niijíchahjeh, jéih encanniji ãt yoób enep wʉt jĩ, bʉca. Pánih ennit, Jesúsjeéh bejna, Diosdih bʉ́dí ãt wẽi naáwáp wʉt jĩ. Pánihna, bita caán jéih encanniji ã enechah ennit, queétbʉt Diosdih bʉ́dí ĩt wẽi naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesúswã Jericó tʉ́tchina jʉibínit, bac bejat tʉ́ʉt ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Caán tʉ́tchidih Zaqueo wʉ̃t jʉmni ãt jʉmʉp wʉt jĩ. Caán Romanowã ĩ maáta dinerodih ʉʉ́bát tʉ́ʉtnit ĩ maáh jʉmna, bʉ́dí dinero ãt bíbohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","“Caán dedna tigaá”, niijnít, Jesúsdih ãt eníhip wʉt yʉh jĩ. Obohjeéhtih, ã eníhichah yʉhna, japcanni dahbit ã jʉmʉchah, dawá cã́acwã caandíh ĩt jãhap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pánihna, Jesús ã yap bejechah, tʉ́i enat tʉ́ʉt niijná, cã́acwãdih ñáo yap bejnit, sicómoro wʉ̃t jʉmni nahdih aab béjnit, caanjĩ́h Jesúsdih ãt pã́i lajap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Caanjĩ́h ã pã́i lajachah, caan náh pʉ́ʉjdih Jesús jʉibí ñʉhnit, Zaqueodih chéi ennit, —¡Zaqueo, waícanjeh ma dei jʉ̃ʉ́wʉ́! Bʉʉ míih mʉʉ́boó wã chão jwʉ́hbipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Páant ã niijíchah joinít, Zaqueoboó wẽpép dei jʉ̃óh, bʉ́dí wẽinit, ã́ih mʉʉná Jesúsdih ãt nʉmah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jesús caandíh ã pej jʉm bejechah ennit, nihat cã́acwã íijnit, queétjeh nin pah ĩt míic niijíp wʉt jĩ: —Jesús tʉbit yéejniíh mʉʉná ã bejna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ã́ih mʉʉná nʉmah jʉibínit, queétdih ãt nʉmah jeémép wʉt jĩ. Pánih jeémp chʉ́ʉdniji Zaqueoboó ñah ñʉhnit, Jesúsdih nin pah ãt niijíp wʉt jĩ: —Maá, meemdíh bainí wã naáwát tʉ́ʉt caá. Wã yéejatdih cádah, tʉ́iniboodíh tʉ́ʉt nʉʉmnít, moh yéejnitdih nihat wĩ́ih bií déedih tac yoób wã wʉ̃hbipna caá. Ded dinero wã yee ʉʉ́bhnidih cuatro láa wã jwʉ́ʉbabipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Páant ã niijíchah joinít, nin pah caandíh Jesús ãt niijíp wʉt jĩ: —Abrahamji Diosdih ã jepahat jíib, Dios caandíh ãt tʉ́i ʉbʉp wʉt jĩ. Bʉʉ meembʉ́t Diosdih ma jepahat jíib, Abrahamji ã jʉima yoobát ma jʉmna caá. Páant ma jʉmʉchah, meém, majeéh jʉmnitbʉt iiguípna bejnit déejidih Dios ã tʉ́i ʉbna caá. ");
INSERT INTO cbv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Weém nihat cã́acwã ʉ́ʉd jeñé, bʉʉdnít panihnitdih bidnit, tʉ́i ʉbat tʉ́ʉt niijná, wã jʉ̃ʉ́wʉ́p be, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Páant ã niijíchah joinítboó Jerusalén tʉ́tchi pebhjeh jʉmna, caanná jʉibínit, “Maáh ã waadbípna nacaá”, ĩ niíj jenah joyátdih jéihnit, nin pah queétdih ãt niíj bohénap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ã́ih baácdih moondíh wʉtat tʉ́ʉt niijná, ĩ maáh wʉ̃ʉ́h biíh baácboó maáh waad jwʉ́hʉdih ã bejep be. ");
INSERT INTO cbv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ã bejat pínah jã́tih, chénat pah téihya caandíh teo wʉ̃hnitdih ã bid wáacap be. Ĩ wáac jʉyʉ́chah, queét nihatdih biíc yoobó bʉ́dí jíib jʉmni míic dinero jʉ́dʉnadih ã wʉ̃hʉp be. Wʉ̃hnit, ‘Wã jwʉ́ʉb jʉ̃ʉ́wát pínah jã́tih, nin dinerojĩh ñi jíib chãj teo páñaá’, ĩ maáh pínah queétdih ã niijíp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Obohjeéhtih, ã́ih cã́acwã caandíh eníhcan, ã maáh jʉmatdih náahcan, biquínadih chah maáhdih naáwádih ĩ bejat tʉ́ʉtʉp be. ‘Jwiítboó caán ã maáh jʉmatdih jwĩ náahcan caá’, ĩ niíj naáwát tʉ́ʉtʉp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Obohjeéhtih, caánboó maáh waadnít, ã jwʉ́ʉb jʉyʉ́p be. Jwʉ́ʉb jʉinít, ĩ tewatdih jéihyat tʉ́ʉt niijná, caandíh teo wʉ̃hnitdih ã jwʉ́ʉb bid wáacap be. ");
INSERT INTO cbv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jwíih waóh jʉiní nin pah ã niijíp be, ‘Maá, ma wʉ̃hni jʉ́dʉjĩh jíib chãj teonit, diez jʉ́dʉdih wã jwʉ́ʉb jíib ʉbʉp be’, ã maáhdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Páant ã niijíchah joinít, ‘Ma tʉ́i chãjap be. Weemdíh tʉ́i teo wʉ̃hni ma jʉmna caá. Bainíbitjĩhjeh ma tʉ́i chãjat jíib, diez tʉ́tchinadih moondíh ĩ maáh meemdíh wã waadána caá’, ã maáh caandíh ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Caán tʉ́ttimah jʉiníboó ‘Maá, ma wʉ̃hni jʉ́dʉjĩh jíib chãj teonit, cinco jʉ́dʉdih wã jwʉ́ʉb jíib ʉbʉp be’, ã maáhdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Páant ã niijíchah joinít, ‘Meém ma tʉ́i chãjat jíib, cinco tʉ́tchinadih moondíh ĩ maáh meemdíh wã waadána caá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Obohjeéhtih, tʉ́ttimah jʉiníboó ‘Maá, ma eneé. Weemdíh ma wʉ̃hni jʉ́dʉdih yégueh chóojĩh wã tʉ́i tai jwej ámohop be. ");
INSERT INTO cbv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Meém tʉbit ʉ́ʉm náah jʉmni caá. Bitadih momat tʉ́ʉt, dicat tʉ́ʉtnit, meemjéh caán jíibdih mapĩ́ ʉbna caá. Páant ma chãjatdih jéihnit, meemdíh wã ʉ́ʉmʉp be’, ã maáhdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Páant ã niijíchah joinít, ‘Meém weemdíh ma tʉ́i teo wʉ̃hcap be. Ma niijátjĩhjeh meemdíh wã jwʉ́ʉb naóh yacbipna caá. ¿Weém ʉ́ʉm náah jʉmni niít? ¿Bitadih momat tʉ́ʉtni, dicat tʉ́ʉtni niít? ");
INSERT INTO cbv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Páant wã jʉmʉchah nihna, wĩ́ih dinerodih dinero jwejat mʉʉná ma ámohochah, ãta tʉ́i tagaá. Páant ma chãjachah, caán mʉʉdíh teonit weemdíh chah ĩta wʉ̃h tagaá’, ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Páant niíj péanit, pebhbit ñʉhnitdih nin pah ã niijíp be: ‘Caandíh wã wʉ̃hni jʉ́dʉdih dʉ́ʉc wáinit, chénat pah téihya jʉ́dʉjĩh tʉ́i teoniboodíh ñi wʉ̃hʉʉ́’, queétdih ã niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Páant ã niijíchah joinít, ‘¡Obohjeéhtih, Maá, caánboó chénat pah téihya jʉ́dʉ jáantjeh ã bíbohna caá!’ caandíh ĩ niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Páant ĩ niijíchah joinít, ‘Ded ã bíbohnijĩh tʉ́i teonidih chah wã wʉ̃hbipna caá. Obohjeéhtih, ded ã bíbohna yʉhna, ã tʉ́i teocat jíib, ã bíbohnidih wã dʉ́ʉc wáibipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Weemdíh eníhcannit, ĩ maáh wã jʉmatdih náahcannitdih, ninna ʉb jʉ̃óhnit, wã enepdih ñi mao yohoó’, ĩ maáh ã niijíp be”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Páant niíj péa, cã́acwãdih chibít yʉʉ́pbit waóh bejnit, Jerusalén tʉ́tchina Jesúswã ĩt tóah pʉ́ʉh laab béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pánih tóah pʉ́ʉh laab béjnit, Betfagé wʉ̃t jʉmni, Betania wʉ̃t jʉmni tʉ́tchina pebh, Olivo Jeé pʉ́ʉjdih ĩt jʉibínap wʉt jĩ. Pánih jʉibínit, Jesús chénewã ã bohénitdih wahnit, nin pah queétdih ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Con jígohni tʉ́tchibitdih ñi bejeé. Waád jʉibínitjeh, burro wʉ̃ʉ́h cã́acwãdih dʉo jwʉ́hcannidih ñi jwãáhbipna caá. Caandíh ĩ chéwat tõpdih watnit, ñi ʉb jwʉ́ʉb jʉ̃ʉ́wʉ́. ");
INSERT INTO cbv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yeebdíh enni ‘¿Dépanih caandíh watnit, ʉb bej tigaá ñi chãj?’ ã niíj ʉʉ́bh joyóchah joinít, ‘Jwĩ Maáh ã náah jwʉhna caá’, ñi niíj jepahaá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Páant ã niijíchah joinít, ĩt bejep wʉt jĩ. Caanná jʉibínit, Jesús ã niijátji pahjeh ĩt jwãááp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pánihna, burro wʉ̃ʉ́hdih ĩ watachah ennit, —¿Dépanih caandíh wat ʉb bej tigaá ñi chãj? ã monó ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Nindih jwĩ Maáh ã náah jwʉhna caá, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","—Páant ta tigaá. Ñi ʉb bej jwʉhʉʉ́, ĩ niíj jepahachah joinít, Jesús ã páñapboó ĩt ʉb jwʉ́ʉb bejep wʉt jĩ. Pánih ʉb jʉibínit, Jesús ã chʉ́ʉdat pínah niijná, ĩ́ih jih bóo yégueh chóonadih tóo dʉgnit, burro wʉ̃ʉ́hdih ĩt cáagap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pánih pʉ́ʉh laáb chʉ́ʉdnit, ã bejechahjeh, ã jã́tih waóhnit, caán ĩ maáh pínahdih ĩ weñat jʉ́ʉtna, ĩ́ih jih bóo yégueh chóonadih tóo dʉgnit, namádih ĩt jwej waáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pánih bejnit, Jerusalén tʉ́tchina tóah jʉibí, Olivo Jeé pʉ́ʉjdih dei jʉibínit, Jesús ã wẽp chãjatjinadih náhninit, Diosdih bʉ́dí wẽina, nin pah ĩt niíj ejep wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Tʉ́ina caá, Dios! ¡Meém caá nin jwĩ Maáh pínahdih mat wahap taga! ¡Nin ma wahnidih ma tʉ́i teo wáacá! Páant jwĩ maáh ã jʉmʉchah, majeéh jwĩ tʉ́i jʉmbipna caá. ¡Nin baácdih jʉmnit jeáboó jʉmnitbʉt meém chah wẽpni Maáhdih ĩ wẽi naáwá naáh! ĩt niíj wẽi ejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Páant ĩ niíj wẽi ejechah joinít, ĩjeéh péenit fariseowã nin pah Jesúsdih ĩt niíj jʉ̃ihñʉp wʉt jĩ: —¡Bohéní, páant bóojeh! Ma bohénitdih ma ej cádahat tʉ́ʉtʉ́, ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Obohjeéhtih, Jesús queétdih nin pah ãt niíj jepahap wʉt jĩ: —Yoobópdih yeebdíh wã naóhna caá. Queét ĩ yayáchah, nin ñajni jee dáhnaboó ãta wẽi ej tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pánihna, Jerusalén tʉ́tchina tóah jʉibínit, caandíh enna, caán tʉ́tchidih moondíh jĩ́gahna, ãt jʉñʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Pánih jʉ̃inít, nin pah ãt niijíp wʉt jĩ: “Yeéb Jerusalén tʉ́tchidih moón bʉʉ yeó jáapna ded pah ñi tʉ́i jʉmat pínahdih jéihna nihna, ãta tʉ́i tagaá. Obohjeéhtih, weemdíh jepahcan, ñi tʉ́i jʉmat pínahdih ñi beh joicán caá. ");
INSERT INTO cbv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Maátcanjeh yeebdíh eníhcannit ñíih tʉ́tchidih ĩ tʉ́i bóod chʉ̃i ñʉh pʉ́ʉd bejbipna caá, yeéb tʉ́tchi diítboó jʉmnit ñi jéih jwei báccat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pánih chãjna, ñíih tʉ́tchidih ĩ tʉ́i boto mao jéena beedábipna caá. Nihat yeéb diítboó jʉmnitdih, ñi wehdihbʉt ĩ mao yoh beedábipna caá. Dios yeebdíh teo wáacni pínah weemdíh ã wahachah yʉhna, ñi jepahcatji jíib páant yeejép ã yapbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalén tʉ́tchidih waád jʉibínit, Dioíh mʉʉ́ jóocmant bóo jʉʉ́hdih Jesúswã ĩt waad béjep wʉt jĩ. Pánih waad béjnit, Diosdih ĩ wʉ̃hat pínah nʉñʉ́pwãdih jíib chãjnitdih Jesús ãt ñʉʉn bácanap wʉt jĩ. Pánih ñʉʉn bácanit, queétdih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Dios naáwátdih naóh yapani nin pah ãt niíj naóh daacáp tajĩ: ‘Wĩ́ih mʉʉ́ weemdíh ʉʉ́bát mʉʉ́ pínah caá’, Dios ã niijná caá,ãt niíj daacáp tajĩ. Obohjeéhtih, yeébboó Diosdih ʉʉ́bʉ́dih jʉ̃óhnitdih yeenit, chah ñi jíib waadá ʉʉ́bhna, nʉʉmnít ĩ wáac jʉyát mʉʉ́ pínah ñit chãjap taga, ãt niijíp wʉt jĩ. Queétdih jʉ̃ih péanit, ãt bac bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yeó jáap jʉmat pah Jesús Dioíh mʉʉná bohénadih ãpĩ́ bejep wʉt jĩ. Páant ã bohénachah ennit, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, bita maátabʉt caandíh ĩt mao yohíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Obohjeéhtih, ã bohénachah joinít, nihat cã́acwãboó bʉ́dí ĩt weñep wʉt jĩ. Páant ĩ weñechah jéihnit, ĩ mao yohat tʉ́ʉt niijná yʉhna, ĩt jéih teo jwʉhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Biíh yeó jáap Jesús Dioíh mʉʉ́ jóocmant bóo jʉʉ́hboó cã́acwãdih ãt bohénap wʉt jĩ. Páant ã bohénachah, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit, bita maátabʉt caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Jwiítdih ma naáwá. ¿Deíh wẽpatjĩh tibeé jwíin páant ma chãj? ¿Déhe tibeé meemdíh páant ã wʉt? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Páant ĩ niijíchah joinít, Jesúsbʉt nin pah ãt niíj ʉʉ́bh joí jwʉ́ʉbanap wʉt jĩ: —Weembʉ́t yeebdíh wã ʉʉ́bh joibípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Juan Daabánidih déhe tigaá ãt daabáát tʉ́ʉtji? yeéb ñi jenah joyóchah. ¿Dios ãt wʉtjican taniít? ¿Cã́acwãjeh niít ĩt daabáát tʉ́ʉtjip? Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Páant ã niijíchah joinít, queétjeh nin pah ĩt míic niijíp wʉt jĩ: “¿Ded pah tigaá jwĩ niíj jepah bií? ‘Dios caandíh ãt wʉtʉp taga’, jwĩ niíj jepahachah, caánboó ‘Páant ã jʉmʉchah yʉhna, ¿dépanih tií caandíh ñi jepahcan?’ jwiítdih ã niíj jʉ̃ihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Obohjeéhtih, ‘Juan Dios naáwátdih naóh yapani yoobát ã jʉmʉp jĩ’, nihat cã́acwã ĩ niíj jenah joiná caá. Páant ĩ niíj jenah joyóchah, jwiítboó ‘Cã́acwãjeh caandíh ĩt daabáát tʉ́ʉtjip taga’, jwĩ niíj jepahachah, queét jee dáhnajĩh yohnit, jwiítdih ĩ maobipna caá”, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pánih míic wéhe péanit, —Jwĩ jéihcan caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Caán láa bácah weemdíh wʉtnidih weembʉ́t yeebdíh wã naóhcan niít, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Páant niíj péanit, nin naáwátjĩh cã́acwãdih ãt bohénap wʉt jĩ: “Biíc newé jiwá iguíhdih ã momop be. Mom péanit, bitadih ã́ih iguíhadih en dawá tʉ́ʉtnit, biíh baácboó jib jwʉhʉdih ã bejep be. Pánih bejniji maatápdih ã jígohcap be. ");
INSERT INTO cbv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tʉ́ttimah, iguíh ei láa, ã́ih iguíh jíibdih náahna, caandíh teo wʉ̃hnidih ã́ih iguíhana ã wah bojop yʉh be. Obohjeéhtih, caanná ã jʉibínachah, iguíhadih en daonítboó caandíh teonit, ĩ maáíh pínahdih wʉ̃hcanjeh, ĩ pʉ̃i ñʉʉn yóh jwʉ́ʉba bojop be. ");
INSERT INTO cbv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tʉ́ttimah, iguíha mínah biíh caandíh teo wʉ̃hnidih ã jwʉ́ʉb wahap yʉh be. Obohjeéhtih, ã jʉibínachah enna, caandíhbʉt biíc yoobó yeejép niijnít, jíib wʉ̃hcanjeh, ĩ mao ñʉʉn yóh jwʉ́ʉba bojop be. ");
INSERT INTO cbv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Páant ĩ chãjat tʉ́ttimah, biíhdih jwʉh ã jwʉ́ʉb wahap yʉh be, páant mʉntih. Obohjeéhtih, caandíhbʉt biíc yoobó ĩ mao ñʉʉn yóh jwʉ́ʉba bojop be. ");
INSERT INTO cbv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Páant ĩ chãjatjidih ennit, iguíha mínah nin pah caanjéh ã niíj jenah joyóp be, ‘Bʉʉ biíc peihcanni láa wã wahnitjidih ĩt yeejép chãjap tagaá. ¿Bʉʉ ded pah tigaá wã chãjbi? Wã wʉ̃ʉ́h wã oinidih wã wahachah, caánboodíh yeejép chãjat ʉ́ʉmnit, ĩ jepahmi nacaá’, ã niíj jenah joyóp yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Obohjeéhtih, iguíhadih teonitboó ĩ maáh wʉ̃ʉ́h ã jʉyʉ́chah ennit, nin pah ĩ míic niijíp be: ‘Jwĩ maáh ã wʉnʉchah, ninboó iguíha mínah ã jʉmbipna caá. Pánihna, nin iguíhadih jwiítjeh bíbohat tʉ́ʉt niijná, ¿caandíh jwĩ mao yoh jĩíh?’ ĩ míic niijíp be. ");
INSERT INTO cbv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Páant niijnít, ĩ maáh wʉ̃ʉ́hdih teonit, iguíhamant ʉb bac bejnit, ĩ mao yohop be. “Pánih mao yohat doonádih joinít, ĩ maáhboó ¿ded pah tigaá queétdih ã chãjbi? ");
INSERT INTO cbv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ã́ih iguíhana jwʉ́ʉb jʉibínit, ã wʉ̃ʉ́hdih ĩ mawatji peéh queét teonitdih ã mao yohbipna caá. Queétdih mao yoh péanit, ã́ih iguíhadih bitaboodíh ã wʉ̃hbipna caá”, Jesús cã́acwãdih ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, —¡Ma niiját pah ã yapca bojo naáh! cã́acwã ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Páant ĩ niijíchah joinít, Jesús queétdih ennit, nin pah ãt niijíp wʉt jĩ: —Obohjeéhtih, caan páh tigaá ã jʉmbipna caá. Caandíhjeh mʉntih Dios naáwátdih naóh yapani nin pah ãt niíj naóh daacáp tajĩ: ‘Mʉʉ́ teonit tʉ́ini jee dáhnadih ñíonit, ĩ náahcanni dahdih ĩ yohop yʉh be. Obohjeéhtih, queét ĩ yohni dahdihjeh tigaá Dios ã ñíwip. Caandíh ñíonit, ã́ih mʉʉ pánihnidih chãjna, caán mʉʉdíh tʉ́i jenah enat tʉ́ʉt niijná, choójboó caan dáhdih ã jwíih jwejep be. Caán jee pánihni Dios ã wahni pínah tigaá’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pánihna, ded jéih encanni dée pah caan dáhdih tóoc bʉʉgní ã́ih bácah dajni ã jʉmbipna caá. Obohjeéhtih, deddih caan dáh ã bʉʉ́g jéen néehnit, ã boto yoh bojbipna caá. Páant ã yapat dée, ded weém Dios ã wahnidih jepahcan, bʉʉdní ã jʉmbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesús caán naáwátjĩh ã bohénachah joinít, “Jwiítdih niijná caá ã chãjap”, Moisés ã wʉtatjidih bohénit, sacerdotewã ĩ maátabʉt ĩt niíj jéihyep wʉt jĩ. Pánih jéihnit, Jesús ã naóh péanachahjeh, ĩtih tewíhip wʉt yʉh jĩ. Obohjeéhtih, cã́acwãboodíh ʉ́ʉmna, Jesúsdih ĩt jéih teo jwʉhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pánih jéih teo jwʉhcan, débólih teonit, ĩ maátadih wʉ̃hat tʉ́ʉt niijná, caandíh encanni pahjeh, ĩt en ñʉʉ́n péenap wʉt jĩ. Pánihna, bita tʉ́init pah jígohnitdihbʉt Jesús pebh ĩt wahap wʉt jĩ, mácah ã jepahachah, ĩ naóh yacat tʉ́ʉt niijná. ");
INSERT INTO cbv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Queét yeenitboó Jesúsdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt yʉh jĩ: —Bohéní, yeecanni jʉmna, Dios ded pah jwiítdih ã chãjat tʉ́ʉtatdih yoobópdih ma bohéátdih jwĩ jéihna caá. Ded pah cã́acwã jwĩ niijíchah, maáta ĩ jʉmʉchah yʉhna, ʉ́ʉmcanjeh yoobópdih mapĩ́ naóhna caá. Páant yoobópdih naóhni jʉmna, nin jwĩ ʉʉ́bh joyátdih ma jepahaá: ");
INSERT INTO cbv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Roma baácdih moón ĩ maáh César ã ʉʉ́bát tʉ́ʉtni dinero jʉ́dʉdih caandíh jwĩ wʉ̃hʉchah, ã tʉ́i niít? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Páant ĩ niijíchah, ĩ yeeatdih jéihnit, nin pah queétdih Jesús ãt niíj ʉʉ́bh joí jwʉ́ʉbanap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Dinero jʉ́dʉdih weemdíh ñi jʉ́ʉtʉ́. ¿Caán jʉ́dʉdih deíh móot, deíh wʉ̃t tigaá ã jʉm? ãt niijíp wʉt jĩ. —Césaríh móot, ã́ih wʉ̃tbʉt ã jʉmna caá, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Caán láa bácah caán jʉ́dʉ Césaríh pínah caá. Pánihna, ã́ih pínah ã jʉmʉchah, caandíh wʉ̃hat caá náahap. Obohjeéhtih, Dioíh pínah mácah ã jʉmʉchah, Diosboodíh ñi wʉ̃hʉʉ́, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Páant ã niíj jepahachah joinít, queét caandíh mácah jepahat tʉ́ʉtíhnitboó joí yai ñʉ́h bejnit, ĩt jéih jwʉ́ʉb yee ʉʉ́bh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Páant queétdih ã jepahat tʉ́ttimah, biquína saduceowã jwʉh Jesús pebh ĩt jʉibínap wʉt jĩ. Queét saduceowã “Cã́acwã wʉnna, ĩ jwʉ́ʉb boo pʉd jʉ̃óhcan niít”, niijnít ĩt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pánih jenah joinít, nin pah Jesúsdih ĩt niijíp wʉt jĩ: —Bohéní, nin pah Moisés ãt niíj daacáp tajĩ: ‘Weép jeñé weh wihcanjeh ã wʉnʉchah, ã ʉ́ʉdboó weép jeñé áajidih jwʉ́ʉb áa jʉmat caá náahap. Pánihna, ã ʉ́ʉdboó áa wih jwʉhcanni jʉmna, éemp wʉnnihdih ã bíboho naáh, ã ʉ́ʉd jeñé báadhda weh pah ĩ weh jʉmat pínah niijná’, jwiítdih Moisés ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Biíc weh sietewã ĩ jʉmʉp be. Weép jeñéboó áa jʉm, weh wihcanjeh ã wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ã ʉ́ʉdboó weép jeñé áajidih ã jwʉ́ʉb áa jʉmʉp yʉh be. Páant áa jʉmat tʉ́ttimah, weép jeñé pahjeh mʉntih, weh wihcanjeh caanbʉ́t ã wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tʉ́ttimah bóobʉt weép jeñé áajidih jwʉ́ʉb áa jʉmna yʉhna, caanbʉ́t weh wihcanjeh ã wʉnʉp be. Páant míicjeh queét nihat ĩ bʉʉ́d beedép be. ");
INSERT INTO cbv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Páant mi weha mána ĩ wʉn beedát tʉ́ttimah, ĩ áajibʉt mi wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pánihna, queét nihat ĩ áa jʉmnihji, nihat cã́acwã ĩ jwʉ́ʉb boo pʉd jʉ̃ʉ́wʉ́chah, ¿ded áa tigaá mi yoób jʉmbi? saduceowã Jesúsdih ĩt niíj ʉʉ́bh joyóp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Páant ĩ niijíchah joinít, Jesús nin pah ãt niíj jepahap wʉt jĩ: —Nin baácboó jʉmna, yad pínahdih ĩpĩ́ ʉbna caá. Ĩ weh yatádihbʉt ĩpĩ́ wʉ̃hna caá. ");
INSERT INTO cbv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Obohjeéhtih, wʉnnitji ĩ jwʉ́ʉb boo pʉd jʉ̃ʉ́wát tʉ́ttimah, Dios weh jʉmna, jeáboó jʉmnit, ángelwã pah ĩ jwʉ́ʉb wʉncan niít. Pánih jwʉ́ʉb wʉncan, ĩ jwʉ́ʉb áa jʉmcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Obohjeéhtih, wʉnnitji ĩ boo pʉd jʉ̃ʉ́wát pínahdih yeéb ñi jéihyatdih náah yacna, nin pah wã niíj naóhna caá: Moisésji iigní chálihdih ã enatjidih nin pah ãt niíj daacáp tajĩ: ‘Dios nin pah weemdíh ã niijíp jĩ: “Weém Abraham, Isaac, Jacob ĩ Maáh caá”, ã niijíp jĩ’, Moisés ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ĩ wʉnat tʉ́ttimah yʉhna, ‘Ĩ Maáh caá’, Dios ãt niijíp wʉt jĩ. ‘Ĩ Maáh caá’, ã niijátjidih jéihnit, báadhnit ĩ jʉmatdih jwĩ jéihna caá. ¡Dios báadhnitdihjeh Maáh ã jʉmna caá! Pánihna, cã́acwãíh bácah ã wʉnʉchah yʉhna, ĩ́ih caolih páantjeh ã báadhna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Páant ã niijíchah joinít, bita Moisés ã wʉtatjidih bohénitboó, —Ma tʉ́i jepahap be, Bohéní, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Páant ã jepahachah joinít, ʉ́ʉmna, bitabʉt caandíh ĩt jwʉ́ʉb ʉʉ́bh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús queétdih nin pah ãt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ: —‘Dios ã wahni pínah Cristo David jʉima ã jʉmbipna caá’, ĩ niíj naóhna caá. ¿Páant niíj naóhna, ded pah niíj bohé tigaá ĩ chãj? ");
INSERT INTO cbv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidjijeh Salmos ĩ niijní tólihdih nin pah ãt niíj daacáp tajĩ: ‘Wã Maáhdih Dios nin pah ã niijná caá: “Wã jéihyepmant bóo bʉwámant ma chʉ́ʉdʉ́. ");
INSERT INTO cbv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Pánih chʉ́ʉdnit, nihatdih ma wʉtʉchah, meemdíh en jʉ̃ihnitdih wã yap yohat tʉ́ʉtbipna caá”, ã niijná caá’, Davidji ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Páant niíj daácnit, Davidji Cristodih ‘Maá’, ãt niijíp wʉt jĩ. Páant ã niijíchah yʉhna, ¿ded pah Cristo David jʉima ãt jʉmji? Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Páant niíj péanit, nihat ãjeéh péenit ĩ joyóchah, nin pah ã bohénitboodíh Jesús ãt niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“¡Moisés ã wʉtatjidih bohénitdih ñi tʉ́i chãja chaáh! Queét maátni yégueh tʉ́ini chóo dʉonít, cã́acwã ĩ enepdih ĩpĩ́ táoh jib bejna caá. Bií dée jíib chãjapboó bita queétdih tʉ́i wẽi jwãáh ʉʉ́bátdih ĩpĩ́ náahna caá. Jwiít judíowã jwĩ bohéát mʉʉdíh waáwápboó ĩpĩ́ chʉ́ʉdna caá, nihat cã́acwã queétdih ĩ tʉ́i wẽi enat pínah niijná. Nʉmah jeémépboobʉ́t bejnit, waáwápboó míicjeh chʉ́ʉdna, ĩpĩ́ wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Obohjeéhtih, queét éemp wʉnnit yaádíh mʉʉnádih ĩpĩ́ dʉ́ʉc wáina caá. Páant queét yaádhdih ĩ dʉ́ʉc wáina yʉhna, cã́acwã ĩ enepdih Diosdih maatápdih ĩpĩ́ ʉʉ́bhna caá, queétdih ĩ wẽi enat pínah niijná. Páant ĩ chãjat jíib Dios queétdih bʉ́dí ã peéh chãjbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ã enechah, Dioíh mʉʉdíh jʉmni dinero jʉ́dʉna ámohat paihdih bʉ́dí dinero bíbohnitboó Diosdih ĩ wʉ̃hni jʉ́dʉnadih ĩt yacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Páant ĩ yacachah, éemp wʉnnihbʉt chéne jʉ́dʉbitdih mi yacachah, ãt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Páant ĩ yacachah ennit, nin pah ã bohénitdih ãt niíj naáwáp wʉt jĩ: —Nint éemp wʉnnihboó moh yéejnih yʉhna, queét chah mi wʉ̃hʉp be. ");
INSERT INTO cbv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Queét bʉ́dí dinero bíbohnit, ĩ náahcanni jʉ́dʉnadih Diosdih ĩ wʉ̃hʉp be. Obohjeéhtih, caántboó bainíbit bíbohnih nihat biíh pah bóonadih mi jíib chãjat déedih Diosdih mi wʉ̃h beedánap be, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Biquína ã bohénit Dioíh mʉʉdíh wẽi ennit, nin pah ĩt niíj míic wéhenap wʉt jĩ: —Nin mʉʉ́ tʉ́ini caá. Tʉ́ini jee dáhnajĩh ĩt chãjjip taga. Nin diítboó cã́acwã Diosdih ĩ wʉ̃hnibʉt tʉ́ini caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Páant ĩ niijíchah joinít, nin pah queétdih Jesús ãt niijíp wʉt jĩ: —Maátcanjeh, nihat bʉʉ ñi wẽi ennidih yeebdíh eníhcannitboó ĩ boto mao jéena beedábipna caá. Biíc jee dáh biíh dahjih lajni ã wihcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Páant ã niijíchah joinít, queétboó nin pah ĩt niíj ʉʉ́bh joí enep wʉt jĩ: —Bohéní, páant ma niiját ¿débólih tigaá ã yapbi? ¿Ded pah tigaá jwiít jwĩ jéihbi? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Páant ĩ niijíchah joinít, nin pah ãt niíj jepahap wʉt jĩ: “¡Yeéb ñi tʉ́i chãja chaáh! Bita ĩ yeeatdih ñi joicá bojoó. ‘Weém Cristo caá’, niíj yeenit, dawá ĩ jʉ̃óhbipna caá. ‘Yeejépwã ñi maáta ĩ wẽpat dʉ́ʉc wáinit, yeebdíh tʉ́i ʉbni pínah ã jʉmna caá’, ĩ niijíchah yʉhna, yeébboó ñi joyáh bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dawá baácdih moón ĩ míic mawat doonádih joinít, biíh baácdih moón ĩ maátadih yohíhna, ĩ míic mawat doonádihbʉt joiná, ñi ʉ́ʉmca bojoó. Péeni yeó jáap jã́tih páant ã yapbipna caá. Obohjeéhtih, caán péeni yeó jáap caán láajeh ã nihcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Caán láa biíc baácdih moón biíh baácna bejnit, ĩ míic maobipna caá. Pánihna, nihat baácboó bʉ́dí míic mawat ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dawá pebhboó bʉ́dí baác méméat, nʉʉgʉ́p láa, wẽpép wʉnat ã jʉmʉchah, dawá ĩ wʉnbipna caá. Nin baácboó tʉbit yeejép ã yapachah, jeámantbʉt ʉ́ʉm náah jʉmni ã jígohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Obohjeéhtih, páant ã yapat pínah jã́tih, yeebdíh eníhcannitboó teonit, yeejép ĩ chãjbipna caá. Pánih chãjnit, ñi míic wáacat mʉʉdíh moón maátadih naóh yacnit, nemat mʉʉ́boó ĩ nemat tʉ́ʉtbipna caá. Wĩ́ihwã ñi jʉmat jíib dawá baácdih moón ĩ maátadihbʉt yeebdíh ĩ naóh yacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yeebdíh páant yeejép ĩ chãjachah, wĩ́ih doonádih queétdih ñi naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Páant ã yapat pínahdih jéihnit, ĩ naóh yacachah, ded pah ñi jepahat pínahdih jã́tih ñi jenah joicá bojoó. ");
INSERT INTO cbv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Weémboó ded pah ñi naáwát pínahdih wã jéihyabipna caá. Páant ñi naáwáchah joinít, yeebdíh naóh yacnit ĩ jéih niíj jwʉ́ʉbacan niít. ");
INSERT INTO cbv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ñi mána, ñi ʉ́ʉdwã, ñi déewã, ñi pej jʉmnitbʉt yeebdíh naóh yacnit, ñi maátadih ĩ tewat tʉ́ʉtbipna caá, nemat mʉʉ́boó ĩ nemat pínah niijná. Biquínadih nemat mʉʉ́boó nem, bitadih ĩ mao yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pánihna, wĩ́ihwã ñi jʉmat jíib, nihat yeebdíh ĩ en jʉ̃ihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Páant ĩ chãjachah yʉhna, Dios yeebdíh ã tʉ́i wapbipna caá, ñi bʉʉdcát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Páant yeebdíh yeejép ĩ chãjachah yʉhna, Diosdih cádahcan, wʉnna yʉhna, Diosjeéh páantjeh ñi tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Biíh baácdih moón soldadowã Jerusalén tʉ́tchidih ĩ ñʉh pʉ́ʉda bojbipna caá, diítboó jʉmnit ĩ jéih jwei báccat pínah niijná. Páant ĩ ñʉh pʉ́ʉda bojochah ennit, ‘Nin tʉ́tchi bʉʉdná caá ã chãjap’, ñi niíj jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pánih jéihnit, Judea baácdih jʉmnit jeená ĩ jwei béje naáh. Jerusalén tʉ́tchi diítna jʉmnitboó ĩ jwei bác beje naáh. Wápchiboó jʉmnit jweiná, tʉ́tchina ĩ jwʉ́ʉb waad béjca bojo naáh. ");
INSERT INTO cbv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Páant ñi jweicáh, caán láa Diosdih jepahcannit judíowãdih ĩ yap yohatji jíib ã peéh chãjachah, yeebdíhbʉt ã chʉ̃ʉ́hbipna caá. Páant ĩ yéejat peéh ã chãjachah, jon jã́tih Dios naáwátdih naóh yapanit ĩ daacátjidih biíc yoobó ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Dedh wʉdʉ jʉmnihdih, weh tʉ́ʉhnihdihbʉt jweyát chah ã bʉobipna caá. Caán láa Dios judíowã ĩ yéejatdih bʉ́dí íijnit, queétdih bʉ́dí ã peéh chãjbipna caá. Páant ã chãjachah, nin baácdih moón tʉbit ĩ jĩ́gahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Biquínadih ĩ mao yohbipna caá. Bitaboodíh teonit, ĩ́ih baácna jʉmat yoobó ĩ ʉb bejbipna caá. Jerusalén tʉ́tchidih moondíh beedánit, queét judíowã nihcannit caán tʉ́tchidih waadnít, maáta ĩ jʉmbipna caá. Tʉ́ttimah, Dios ã jenah joyátji pah, maáta ĩ jʉmatdih ã jwʉ́ʉb dʉ́ʉc wáibipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Caán péeni yeó jáap tóah jʉ̃ʉ́wʉ́chah, yeó, widh, cʉ́iwãbʉt mácah ĩ jígohbipna caá, Dios ded pah ã chãjat pínahdih cã́acwã ĩ jéihyat pínah niijná. Bʉ́dí mʉj ã nolihat yáaat pah ã yáabipna caá. Pánihna, jeáboó jʉmni mácah jígohatdih ennit, bʉ́dí yáaatdihbʉt joiná, nihat baácdih moón tʉbit ʉ́ʉmnit, bʉ́dí ĩ náhni dahwabipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pánih ʉ́ʉmnit, nin baác ded pah ã yapat pínahdih bʉ́dí jenah joinít, jeámant jʉmni ã tʉ́ʉt nʉʉmʉ́chah enna, náhni joicánnit pah ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Páant ã yapachah, weém nihat cã́acwã ʉ́ʉd jeñé, maáh waadníji, mah tólihjĩh, bʉ́dí yeh iigátjĩhbʉt wã jwʉ́ʉb dei jʉ̃óhbipna caá. Páant wã jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, nihat cã́acwã ĩ enbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pánihna, wã jwʉ́ʉb dei jʉ̃ʉ́wát pínahdih ded pah ã jʉ́ʉt waáwátdih ennit, ʉ́ʉmcan, ñi náhni dahwaca bojoó. Yeebdíh tʉ́i ʉbni waícanjeh wã jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","“Higuera nah, biíh nahbʉt ded pah ã jʉmatdih ñi náhninaá. ");
INSERT INTO cbv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Caan náh jáap wawá ã jʉmʉchah ennit, jópchi ã tóah jʉ̃ʉ́wátdih ñipĩ́ jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pánihat pah wã niijátji biíc yoobó ã yapachah ennit, ‘Jesús nin baácboó maáh jʉmʉdih ã jwʉ́ʉb dei jʉ̃ʉ́wát pínah bahnijeh ã jʉdhna caá’, ñi niíj jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yoobópdih yeebdíh wã naóhna caá. Wã niijátji biíc yoobó ã yapat pínah jã́tih, nihat caán jʉ́ʉt waáwátdih ennitboó ĩ wʉncan niít. ");
INSERT INTO cbv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nihat nin baác jeábʉt ã bʉʉdbípna caá. Obohjeéhtih, wã naáwátboó bʉʉdcánjeh, nihat biíc yoobó ã yapbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“¡Yeéb ñi tʉ́i jenah joyó chaáh! Bʉ́dí nʉmah jeémátdih chãj, babh máihnit, dawá bií déedih bíbohatdihjeh jenah joiná, wã jwʉ́ʉb dei jʉ̃ʉ́wát pínahdih ñi jenah joicán niít. Pánih jenah joicán, ñi jéihcat láa yeebdíh ñi yéejat peéh chãjadih wã jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nihat baácdih moonbʉ́t ĩ jenah joicát láa wã jwʉ́ʉb dei jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pánihna, yeó jáap jʉmat pah tʉ́i jenah joinít, Dios ã teo wáacatdih ñi ʉʉ́bʉ́, yeejép ã yapachah yʉhna, weemdíh ñi cádahcat tʉ́ʉt niijná. Pánih yap yohnit, weemdíh cádahcan, weém nihat cã́acwã ʉ́ʉd jeñé pebh tíiccanjeh ñi ñʉhbipna caá”, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yeó jáap jʉmat pah Dioíh mʉʉ́boó bohénit, cheyeh jʉmat pah tʉ́tchimant jwʉ́ʉb bac bejnit, Olivo Jeéboó Jesúswã ĩpĩ́ jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pánihna, cã́acwãboó Jesús ã naáwáchah bʉ́dí joííhnit, cheibitjeh jáanit, Dioíh mʉʉ́boó ĩpĩ́ jʉibí páñap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Paacánni pandih jeémát yeó jáap, Pascua ĩ niijní, bahnibit ãt jʉdhdʉp wʉt jĩ. Caán yeó jáapnadih dawá cã́acwã Jerusalén tʉ́tchina ĩpĩ́ míic wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Caán láa sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénit biícdih, Jesúsdih ĩ tewat pínahdih ĩt míic wéhenap wʉt jĩ. Obohjeéhtih, ĩ tewechah, nihat cã́acwã íijnit, queétdih ĩ míic mawat pínahdih ĩt ʉ́ʉmʉp wʉt jĩ. Pánih ʉ́ʉmna, cã́acwã ĩ encah, ded pah Jesúsdih teonit, ĩ mawat pínahdih ĩt bidip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Páant ĩ bidat pónih, nemépwã ĩ maáh, Judas, Iscariote ĩ niijnídih ãt waadáp wʉt jĩ. Caán Judas, Jesús ã bohéni ã jʉmʉchah yʉhna, ã́ih jenah joyátdih ãt tʉ́ʉt nʉʉmʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pánih jenah joyát tʉ́ʉt nʉʉmníji Jesús pebh queétdih dʉó wáyat tʉ́ʉt niijná, sacerdotewã ĩ maáta, Dioíh mʉʉdíh wapnit ĩ maátadihbʉt naáwádih ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Páant ã naáwáchah wẽi joinít, —Cã́acwã ĩ encah, ded pah soldadowã Jesúsdih ĩ tewat pínah niijná, ma dʉó wáyat pínah jíib, meemdíh jwĩ jíib chãjbipna caá, Judasdih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Páant ĩ niijíchah joinít, jepahna, cã́acwã ĩ encah, Jesús pebhna ã dʉó wáyat pínahdih Judas ãt jenah joi bídip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Paacánni pandih jeémát yeó jáap, oveja wʉ̃ʉ́hdih ĩpĩ́ maoni yeó jáap, Pascua ĩ niijní yeó jáapdih, ");
INSERT INTO cbv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pedro, Juandihbʉt ã nʉmah jeémát pínah mʉʉdíh bidat tʉ́ʉtna, Jesús ãt wahap wʉt jĩ. Pánih wahnit, nin pah queétdih ãt niijíp wʉt jĩ: —Pascua yeó jáapdih biícdih jwĩ jeémát pínahdih, ñi ámohbi jwʉhʉʉ́, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Páant ã niijíchah joinít, —¿Dedjĩh tigaá ámohodih jwĩ bejbi? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Jerusalén tʉ́tchidih ñi waadáchah, wáam dahjĩh mah beoni yeebdíh ã jwãáhbipna caá. Ãjeéh bejnit, ã waadní mʉʉdíh yeebbʉ́t ñi pée waadá. ");
INSERT INTO cbv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Waadnít, caán mʉʉ́ mínahdih nin pah ñi niíj ʉʉ́bh joyoó: ‘ “¿Deyoob tígaá Pascua jeémátdih wã bohénitdih wã nʉmah jeémát tólih pínah ã jʉm?” Bohéni ã niijná beé’, caandíh ñi niijí. ");
INSERT INTO cbv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Páant ñi niijíchah joinít, bʉ́dí chah bóo tólih, nihat jwĩ náahat jʉm beední tólihdih ã jʉ́ʉtbipna caá. Caán tólihboó Pascua jwĩ jeémát pínahdih ñi chãjaá, queét chénewãdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Páant ã niijíchah joinít, Jerusalén tʉ́tchina ĩt bejep wʉt jĩ. Caanná jʉibínit, nihat Jesús ã niijátji pah ĩt jwãááp wʉt jĩ. Pánihna, queétdih jʉ́ʉtni tólihdih waadnít, Pascua ĩ jeémát pínahdih ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ĩ jeémát hora ã jʉyʉ́chah, ĩ ámohni tólihna jʉibínit, Jesús ã bohénitdih ãt nʉmah jeémép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Páant ĩ jeéméchahjeh, nin pah queétdih ãt niijíp wʉt jĩ: —¡Wã wʉnat pínah jã́tih, nin Pascua jeémátdih yeebdíh bʉ́dí wã nʉmah jeémíhip be! ");
INSERT INTO cbv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yoobópdih yeebdíh wã naóhna caá. Dios pebhboó jwĩ jʉmat pínah jã́tih, chéneji nindih wã jwʉ́ʉb jeémp jwʉhcan niít. Dios ã jenah joyátji pah ã maáh jʉmʉpboó biícdih jwĩ jwʉ́ʉb jeémpbipna caá, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Páant niíj péanit, jiwá iguíh mac jʉmni pamapdih ʉbnit, “Tʉ́ina caá, Paá”, Diosdih niíj péanit, ã bohénitdih ãt wʉ̃hʉp wʉt jĩ. —Dáa, yeebjéh ñi babhbaá. ");
INSERT INTO cbv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Weém páant bóojeh wã babh péa jwʉhna caá. Dios ã maáh jʉmʉpboó biícdih jwĩ jwʉ́ʉb babhbipna caá, Jesús ãt niijíp wʉt jĩ. Páant ã niijíchah joinít, ĩt babhbap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Páant ĩ babhbat tʉ́ttimah, pandih ʉbnit, “Tʉ́ina caá, Paá”, Diosdih niíj péanit, ã bohénitdih ãt daj wʉ̃hʉp wʉt jĩ. —Nin pan wĩ́ih bácah panihni caá. Nindih wã dajat pah, weemdíh ĩ maobipna caá, yeebdíh wã tʉ́i ʉbat pínah niijná. Pánihna, yeebdíh wã wʉn wʉ̃hatdih náhninit, nindih ñi jeémé, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pascua jeémátdih jeémp péanit, Jesús biíh pamapdih jwʉ́ʉb ʉbnit, nin pah queétdih ãt niijíp wʉt jĩ: —Nin iguíh mac wĩ́ih meép panihni caá. Wĩ́ih meépjĩh ñi yéejat jíib bʉʉdáátdih jíib chãjna, Dios biícdih ñi tʉ́i jʉmat pínah niijná, yeebdíh wã wʉn wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Obohjeéhtih, ñi joyoó. Weemdíh eníhcannitdih dʉó wáini pínah wã pebh ã chʉ́ʉdna caá. ");
INSERT INTO cbv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wã íip jon jã́tih weemdíh ã wʉtatji biíc yoobó wã wʉnbipna caá. Obohjeéhtih, weemdíh eníhcannitdih dʉó wáiniboodíh Dios bʉ́dí ã peéh chãjbipna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Páant ã niijíchah joinít, “¿Déhe tigaá ã dʉó wáibi?” queétjeh ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pánih jeémpnajeh, ã bohénitboó nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: “¿Jwĩjeéh jʉmni déhe tigaá maáh panihni ã jʉmbi?” ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Páant ĩ míic niijíchah joinít, Jesús nin pah queétdih ãt niíj naáwáp wʉt jĩ: “Judíowã nihcannit ĩ maáta ĩ́ih cã́acwãdih tʉbit wʉtnit caá. Pánih chãjna, ‘Yeebdíh wã tʉ́i teo wáacna caá’, queétdih ĩpĩ́ niijná yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Obohjeéhtih, queét ĩ chãjat pah, yeéb ñi chãjca bojoó. Ded chah jʉmíhna, ʉ́ʉdyi pah ã jʉmʉ naáh. Maáh jʉmíhna, teo wʉ̃hni pah ã jʉmʉ naáh. ");
INSERT INTO cbv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Jeémp chʉ́ʉdnitdih teo wʉ̃hnitboó jeémátdih ĩpĩ́ cáagna caá. Pánihna, jeémpnitboó maáta panihnit ĩ jʉmna caá. Obohjeéhtih, weémboó ñi Maáh jʉmna yʉhna, teo wʉ̃hni pah wã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yeéb wãjeéh pée cádahcan, yeejép ã yapachah yʉhna, ñi jweicáp be. ");
INSERT INTO cbv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Páant ñi jʉmʉchah, wã íip weemdíh maáh ã waadáát pah mʉntih, yeebdíhbʉt maáta wã waadábipna caá, ");
INSERT INTO cbv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","doce judíowã poómp ĩ maáta ñi jʉmat pínah niijná. Páant bólihna yeebdíh wã jwʉ́ʉb nʉmah jeémp babhbipna caá”, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Páant queétdih niíj naóh péanit, Pedroboodíh nin pah ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: —Simón, Simón, meemdíh bainí wã naáwíhna caá. Yeéb nihat weemdíh ñi cádahat pínah niijná, Satanás Diosdih ãt ʉʉ́bʉ́p wʉt yʉh be. ");
INSERT INTO cbv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Obohjeéhtih, ma cádahcat pínah niijná, weémboó meemdíh bʉ́dí wã ʉʉ́bʉ́p be. Pánihna, jwʉ́ʉb tʉ́i jenah joinít, bita wĩ́ihwãdih ma teo wáacá, queétbʉt biíc yoobó ĩ jwʉ́ʉb tʉ́i jenah joyát pínah niijná, Pedrodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Maá, majeéh weemdíhbʉt nemat mʉʉ́boó ĩ nemechah, ĩ mawachah yʉhna, weémboó meemdíh wã cádahcan niít, Pedro ãt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Pedro, meemdíh yoobópdih wã naóhna caá. Bʉʉjeh mʉjbai ã ewat pínah jã́tih, biíc peihcanni láa ‘Caandíh wã jéihcan caá’, ma niíj yeebipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pedrodih páant niíj péanit, nihat ã bohénitdih nin pah Jesús ãt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ: —Wĩ́ih doonádih naáwát tʉ́ʉtna, yeebdíh wã wahachah, dinerodih ʉbcan, bií déedih yacat pínah wʉh wʉʉ́hdih ʉbcan, zapatosdihbʉt ʉbcah yʉhna, ¿náahat yeebdíh ã jʉmnit jĩí? ãt niijíp wʉt jĩ. —Jwiítdih náahat ã wihcan jĩí, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Obohjeéhtih, bʉʉ láa ded dinero bíbohni, bií dée yacat pínah wʉh wʉʉ́hdih bíbohnibʉt ã ʉb beje naáh. Íibat naadíh bíbohcanni ã́ih jih bóo yégueh chóodih jíib chãj wʉ̃hnit, caán jíibjĩh íibat naadíh ã jíib chãja naáh. Tʉbit tobohat láa jʉ̃óhna caá ã chãjap. ");
INSERT INTO cbv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dios naáwátdih naóh yapanit nin pah weemdíh ĩt niíj daacáp tajĩ. ‘ “Yeejép chãjni caá”, niijnít, caandíh ĩ peéh chãjbipna caá’, ĩt niíj daacáp tajĩ.Yoobópdih yeebdíh wã naóhna caá. Páant ĩ niíj daacátji biíc yoobó weemdíh eníhcannit ĩ chãjbipna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—¡Maá, ma eneé! Ninjĩh chéne íibat naá ã jʉmna caá, queét ĩt niijíp wʉt jĩ. —¡Páant bóojeh! Caandíh ñi jenah joí cádahaá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Páant niíj péa, bac bejnit, cheyeh jʉmat pah ãpĩ́ bejepboó Olivo Jeená ãt jwʉ́ʉb bejep wʉt jĩ. Ã bohénitbʉt ãjeéh ĩt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Caanná jʉibínit, Jesús nin pah queétdih ãt jwʉ́ʉb niijíp wʉt jĩ: —Yeebdíh Satanás ã yéejaat tʉ́ʉtʉchah, caandíh jepahcat tʉ́ʉt niijná, Diosdih ʉʉ́bát caá náahap, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Páant niíj péa, chibít yʉʉ́pbit bej, bódicha caj yoh ñajnit, ");
INSERT INTO cbv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Paá, ma náahna, weemdíh ma wʉnat tʉ́ʉtca bojoó. Obohjeéhtih, weém wã wʉníhcah yʉhna, meémboó páant ma náah yacachah, wã wʉn wʉ̃hbipna caá”, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Páant ã niíj ʉʉ́bʉ́chahjeh, Dios ã wahni ángel caandíh jígohnit, ãt teo wáacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tʉbit jĩ́gahnit, Jesús ã íipdih bʉ́dí ãt ʉʉ́bʉ́p wʉt jĩ. Pánih ʉʉ́bhnit, bʉ́dí tʉ̃p bejna, meépjĩh widni ãt chíinap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pánih ʉʉ́bh péa, jwʉ́ʉb ñah ñʉhnit, ã bohénit pebh ãt jwʉ́ʉb jʉibínap wʉt jĩ. Páant ã jwʉ́ʉb jʉibínachah, bʉ́dí jĩ́gahnit, tʉbit chʉʉná, ĩtát ʉ̃wah bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Páant ĩ ʉ̃wʉchah ennit, Jesús queétdih nin pah ãt niíj wʉcʉp wʉt jĩ: —Ñi jáa bojoó. ¿Dépanih ʉ̃o tigaá ñi chãj? Yéejatdih tʉ́i yap yohat tʉ́ʉt niijná, Diosdih ʉʉ́bát caá náahap, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús páant ã niijíchahjeh, dawá cã́acwã ĩt jʉibínap wʉt jĩ. Judas, Jesús ã bohéniji, queétdih ãt dʉó wái jʉibínap wʉt jĩ. Pánih dʉó wái jʉibínit, Jesúíh pʉ́o tíibdih nomnit, caandíh ãt ʉʉ́bʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Páant ã ʉʉ́bʉ́chah, Jesús caandíh nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Judas, weém nihat cã́acwã ʉ́ʉd jeñédih pʉ́o tíib nomnit ʉʉ́bhna, weemdíh eníhcannitdih jʉ́ʉt niít ma chãjap? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Páant ã niijíchah, Jesús ã bohénit ded pah ã yapat pínahdih jéihnit, nin pah caandíh ĩt niijíp wʉt jĩ: —¿Maá, nin jwĩ bíbohni íibat naajĩ́h queétdih jwĩ mao jĩíh? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Páant ĩ niijíchahjeh, biíc Jesús ã bohéniboó sacerdotewã ĩ maáhdih teo wʉ̃hniíh jéihyepmant bóo moli chóodih ãt dʉ́ʉc bóod yohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Páant ã dʉ́ʉc bóod yohochah ennit, —Páant ñi chãjca bojoó, Jesús queétdih ãt niijíp wʉt jĩ. Páant niijnít, ã́ih moli chóo jʉmʉpjiboó teo jã́hanit, booanachah, jáap chóo ãt jígohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pánih booanit, sacerdotewã ĩ maáta, Dioíh mʉʉdíh wapnit soldadowã ĩ maáta, bita maáta biícdih caandíh tewedih jʉibínitdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanihna nʉʉmnídih tewat pah íibat naaná, máa quiítnadihbʉt ʉbnit, weemdíh tewedih ñi jʉ̃óh? ");
INSERT INTO cbv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yeó jáap jʉmat pah Dioíh mʉʉ́boó ñijeéh wã jʉmʉchah yʉhna, weemdíh ñi teocap be. Obohjeéhtih, bʉʉ nemépwã ĩ maáhdih jepahnit, ded pah ñi weñat pínahdih Dios ã chãjat tʉ́ʉtna caá, Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pánih Jesúsdih teonit, sacerdotewã ĩ maáíh mʉʉná ĩt ʉb bejep wʉt jĩ. Páant ĩ ʉb bejechah, Pedroboó yʉʉ́pjeh ãt en péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Maáíh mʉʉná waád jʉibínit, Jesúsdih teonitji soldadowã wáihyat jʉ́dʉ diítboó tʉʉ ĩt cáo jwejep wʉt jĩ. Pánih cáonit, ĩt mée chʉ́ʉd pʉ́ʉda bojop wʉt jĩ. Pedrobʉt ĩ cãtíh ãt mée chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Páant ã chʉ́ʉdʉchah ennit, biíc teo wʉ̃hnih queétdih nin pah mit niijíp wʉt jĩ: —Ninbʉt Jesúsjeéh jʉmni beé, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Obohjeéhtih, Pedro nin pah ãt niíj yeenap wʉt jĩ: —Caandíh wã jéihcan caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tʉ́ttimah, biíh jwʉh Pedrodih ennit, —Meembʉ́t ĩjeéh jʉmni caá, ãt niijíp wʉt jĩ. —Nihcan caá, Pedro ãt jwʉ́ʉb niíj yeenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Biíc hora tʉ́ttimah, biíh jwʉh bitadih nin pah ãt niijíp wʉt jĩ: —Yoobópdih tigaá ninbʉt Jesúsjeéh jʉmniji caá. Caandíh péenit Galilea baácdih moón míicjeh caá. Ninbʉt Galilea baácdih bóo jʉmna, ãjeéh péeni mʉn tigaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—¡Ma niijnídih wã jéihcan caá! Pedro ãt jwʉ́ʉb niíj yeenap wʉt jĩ. Páant ã niijíchahjeh, mʉjbai ãt ewep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Páant ã ewechahjeh, Jesús Pedrodih ãt tac pʉ́ʉd enep wʉt jĩ. “Bʉʉ chei mʉjbai ã ewat pínah jã́tih, ‘Weém nin newédih wã jéihcan caá’, biíc peihcanni láa ma niíj yeebipna caá”, Jesús ã niijátjidih Pedro ãt náhninap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pánih náhninit, bac bej, bʉ́dí ãt jʉñʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesúsdih wapnit soldadowã caandíh yeejép deohnit, ĩt pʉñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pánih pʉ̃init, ã́ih quíibdih nem chéonit, nin pah ĩt niíj ʉʉ́bh joí dehwep wʉt jĩ: —¿Déhe tibeé meemdíh pʉ̃i? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pánih chãjnit, Jesúsdih yeejép ĩt niíj jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Baáb jéenechah, judíowã ĩ maáta, sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt ĩt míic wáacap wʉt jĩ. Páant ĩ míic wáacachah, soldadowã Jesúsdih ĩt ʉb waad béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Caanná ĩ ʉb waád jʉibínachah, queét míic wáacnitboó nin pah Jesúsdih ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —Jwiítdih yoobópdih ma naáwá. ¿Meém Dios ã wahni Cristo niít? ĩt niijíp wʉt jĩ. —Yeebdíh wã naáwáchah yʉhna, ‘Yoobópdih nihcan caá’, ñi niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yeebdíhbʉt wã ʉʉ́bh joyóchah, ñi jepahcan niít. ");
INSERT INTO cbv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Obohjeéhtih, Dios chah wẽpni ã jéihyepmant bóo bʉwámant weém nihat cã́acwã ʉ́ʉd jeñé chʉ́ʉdnit, nihatdih wã wʉtbipna caá, Jesús queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—Páant niijná, ¿Meém Dios wʉ̃ʉ́h niít? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. —Caan tígaá weém, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Páant ã niíj jepahachah joinít, queétjeh nin pah ĩt míic niíj wéhenap wʉt jĩ: —Nin Diosdih bʉ́dí ã yéej naáwáchah, jwĩ joiná caá. Pánihna, biíh naóh yacni pínahdih bidat náahcan caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Queét maátajeh míic wéhe péanit, Jesúsdih Pilato pebhna ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ã pebhna ʉb jʉibínit, Jesúsdih nin pah ĩt niíj naóh yacap wʉt jĩ: —Nin newé jwĩ déewãdih ã yee naáwáchah, jwiít jwĩ joyóp be. Jwĩ maáh Césardih dinero ã wʉ̃hat tʉ́ʉtcap be. ‘Weém Dios ã wahni Cristo ñi maáh caá’, ãpĩ́ niijíp be, Pilatodih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Páant ĩ niijíchah joinít, Pilato Jesúsdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Meém judíowã ĩ maáh niít? ãt niijíp wʉt jĩ. —Ma niiját pahjeh tigaá, Jesús ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Páant ã niijíchah joinít, Pilato sacerdotewã ĩ maátadih, bita en ñʉhnitdihbʉt nin pah ãt niijíp wʉt jĩ: —Nindih dedé peéh mawat wihcan caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Obohjeéhtih, páant ã niijíchah joinít, queét chah ĩt naóh yacap wʉt jĩ. —Caán nihat ã bohénitdih yeejép ã chãjat tʉ́ʉtna caá. Galilea baácdih moondíh jwíih bohénit, Judea baácdih moondíh, nin tʉ́tchidih moondíhbʉt yeejép ãpĩ́ bohéna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Páant ĩ niijíchah joinít, Pilatoboó queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —Galilea baácdih moondíh jwíih bohéna, ¿nin Galilea baácdih bóo niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Caán baácdih bóo tigaá, ĩt niíj jepahap wʉt jĩ. Páant ĩ niíj jepahachah joinít, Galilea baácdih moondíh Herodes maáh ã jʉmʉchah, Pilato Herodes pebhna Jesúsdih ãt wahap wʉt jĩ. Pascua yeó jáapnadih Herodes Jerusalén tʉ́tchiboó jʉibíni ãt jʉm jwʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Páant ã wahni Herodes pebhna ã jʉibínachah, Herodesboó caandíh ennit, bʉ́dí ãt weñep wʉt jĩ. Jesús ded pah ã chãjat doonádih joiníji maatápdih Jesús ã wẽp chãjatdih bʉ́dí ãt eníhip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pánihna, Jesús Herodes pebhna ã jʉibínachah, Herodes maatápdih ãtih ʉʉ́bh joí ñʉʉnʉ́p wʉt yʉh jĩ. Obohjeéhtih, caandíh Jesús ãt jepahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sacerdotewã ĩ maáta, Moisés ã wʉtatjidih bohénitbʉt, Herodes pebhna jʉibí ñʉhnit, Jesúsdih chah yeejép ĩt naóh yacap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tʉ́ttimah, Herodes ã́ih soldadowã biícdih yeejép niijnít, Jesúsdih ĩt dehwep wʉt jĩ. Pánih deohnit, tʉ́ini yégueh chóo, maáh ã dʉwát dée chóodih yacnit, Pilato pebhna ĩt wah jwʉ́ʉba bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pánihna, caán yeó jáapjeh Jesúsdih ĩ míic wah jwʉ́ʉba boj ñʉhna, Herodes Pilatojĩh ĩt míic wẽi jwíihip wʉt jĩ. Páant ĩ chãjat pínah jã́tih ĩt míic eníhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesúsdih Pilato pebhna ĩ jwʉ́ʉb ʉb jʉibínachah, Pilatoboó sacerdotewã ĩ maátadih, judíowã ĩ maátadih, cã́acwãdihbʉt ãt míic wáacat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Páant ĩ míic wáacat tʉ́ttimah, nin pah queétdih ãt niíj naáwáp wʉt jĩ: —Nindih weemdíh ʉb jʉ̃óhnit, ‘Cã́acwãdih yeejép chãjat tʉ́ʉtni caá’, ñi niíj naóh yacap be. Páant ñi niíj naóh yacachah joinít, yeéb ñi enechah, caandíh wã ʉʉ́bh joí beedánap be. Obohjeéhtih, dedé peéh mawat caandíh ã wihcan caá. ");
INSERT INTO cbv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesbʉt caandíh ʉʉ́bh joí ennit, dedé ã yéejatjidih bid jʉicánjeh, jwĩ pebhna ãt jwʉ́ʉba bojop taga. ");
INSERT INTO cbv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pánihna, caandíh pʉñat tʉ́ʉtnitjeh, wã bacabipna caá, Pilato queétdih ãtih niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua jʉmat pah nemat mʉʉ́boó jʉmni ĩ náahnidih Pilato ãpĩ́ bacanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pánihna, “Jesúsdih wã bacami caá”, ã niijíchah joinít, nihat cã́acwã nin pah ĩt niíj ñaacáp wʉt jĩ: —¡Caán newédih bacacanjeh, ma mao yohat tʉ́ʉtʉ́! ¡Barrabásboodíh jwiítdih ma baca wʉ̃hʉʉ́! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jerusalén tʉ́tchiboó jʉmnit Romano maátadih ã yohíhatji jíib, bitadih ã mao yohatji jíibbʉt, Barrabás nemat mʉʉ́boó ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pánihna, Pilato Jesúsboodíh bacaíhnit, cã́acwãdih ãt jwʉ́ʉb ʉʉ́bh joyóp wʉt jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Obohjeéhtih, páant ã bacaíhichah joinít, —¡Cruzboó péoh dodhnit, caandíh ma mao yohat tʉ́ʉtʉ́! ĩt niíj ñaacáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Páant ĩ niíj ñaacáchah joinít, —Yeéb páant ñi niíj ñaacáchah, ¿dedé tigaá caán ã yéej chãjatji jʉm? Obohjeéhtih, dedé ã yéejat peéh mawat ã wihcah, caandíh wã mao yohat tʉ́ʉtcan niít. Pánihna, pʉñat tʉ́ʉtnitjeh, wã bacabipna caá, Pilato queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Obohjeéhtih, páant ã niijíchah joinít, chah ĩt yoób ñaacáp wʉt jĩ, bʉca. —¡Jesúsdih cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! ĩt niijíp wʉt jĩ. Páant tʉbit ĩ niíj ñaacáchah joiná, Pilato ã jenah joyát tʉ́ʉt nʉʉmnít, ");
INSERT INTO cbv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ĩ niiját pah ãt chãjat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pánih jepahnit, cã́acwãdih mao yohni, nemat mʉʉ́boó jʉmni, cã́acwã ĩ ʉʉ́bhni Barrabásboodíh Pilato ãt bacanap wʉt jĩ. Jesúsdih cruzboó ãt yoób mao yohat tʉ́ʉtʉp wʉt jĩ, bʉca. ");
INSERT INTO cbv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesúsdih soldadowã cruzdih bewanit, caandíh mao yohat tʉ́ʉt niijná, ĩt ʉb bejep wʉt jĩ. Pánih ʉb bejnit, Simón wʉ̃t jʉmni, Cirene tʉ́tchidih bóodih ĩt jwãááp wʉt jĩ. Jerusalén tʉ́tchidih ã waád jʉibínachah, caandíh Jesúíh cruzdih ĩt bewat tʉ́ʉtʉp wʉt jĩ. Pánih bewat tʉ́ʉtnit, Jesús tʉ́ttimah caandíh ĩt péeat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesúsdih ĩ ʉb bejechah, dawá cã́acwã caandíh ĩt en péenap wʉt jĩ. Yaádhbʉt caandíh bʉ́dí ĩt ñaác jʉ̃í péenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Páant ĩ ñaác jʉ̃í péenachah, tac pʉ́ʉd ennit, Jesús queét yaádhdih nin pah ãt niijíp wʉt jĩ: —Yeéb Jerusalén tʉ́tchidih moón yaadá, weemdíh ñi jʉ̃icá bojoó. Yeéb míicjeh, ñi wehdihbʉt jʉñát caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Biíh yeó jáap yeebdíh yeejép ã yapachah, ‘Weh wihcannit yaádh chah wẽinit ĩ jʉmna caá’, ñi niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pánihna, ʉ́ʉm jweííhna, ‘¡Jeená jwiítdih ma jãh jʉ̃ʉ́wʉ́!’ ñi niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ñi jenah joyoó. Weém tʉ́ini wã jʉmʉchah yʉhna, weemdíh yeejép chãjnit, yeéb yéejnitboodíh bácah, chah yeejép ĩ chãjbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesúsdih, chénewã yéej chãjnitdihbʉt ãjeéh mao yohat tʉ́ʉt niijná, Waó Iidíp Dah wʉ̃t jʉmni jeéboó soldadowã ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Caán jeená jʉibínit, Jesúsdih cruzboó péohnit, ĩt pʉd dodhdop wʉt jĩ. Yéejnitdihbʉt biíh cruznadih péohnit, ĩt pʉd dodhdop wʉt jĩ. Biíc yéejnidih Jesús ã jéihyepmant bóo bʉwámant, biíhdih ã wáyámant bóo bʉwámant, Jesúsdih tac yoób ĩt dodhdop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Páant ĩ péoh dodhdat tʉ́ttimah, cruzboó ñʉhnit, Jesús ã íipdih nin pah ãt niíj ʉʉ́bʉ́p wʉt jĩ: “Weemdíh mao yohnit ĩ yéejatdih ma yohoó, Paá. Ded pah ĩ chãjatdih ĩ beh joicán caá”, ãt niijíp wʉt jĩ. Cruzboó ñʉhnitdih wapnit soldadowã Jesúíh yégueh chóojidih “¿Deíh tigaá ã jʉmbi?” míic niijnít, tíhwat jʉ́dʉnabitjĩh ĩt yoh tíhwip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Dawá cã́acwã pebhbit ĩt en ñʉhʉp wʉt jĩ. Judíowã ĩ maátabʉt en ñʉhnit, Jesúsdih nin pah ĩt niíj deoh naáwáp wʉt jĩ: —Cã́acwãdih tʉ́i teo wáacni jʉmna, Dios ã wahni Cristo nihna, caanjéhbʉt ã míic teo wáaca naáh, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadowãbʉt caandíh deoh naóhnit, ã pebh jʉibínit, bijni iguíh macdih Jesúsdih babhbat tʉ́ʉtna, ĩtih toonap wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Pánih toonit, queétbʉt nin pah ĩt niíj deoh naáwáp wʉt jĩ: —¡Meém judíowã ĩ maáh jʉmna nihna, ma wẽpatjĩhjeh ma míic tʉ́i teo wáacá! ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“Nin judíowã ĩ maáh caá”, ĩ niíj daácni nʉ́odih Jesúíh wao cháh cruzboó ĩt nah péoh bʉ́ʉdhdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Biíc péoh dodhni Jesúsdih nin pah ãt niíj jʉ̃ihñʉp wʉt jĩ: —¡Meém Dios ã wahni Cristo jʉmna nihna, ma wẽpatjĩh ma míic teo wáacá! ¡Jwiítdihbʉt ma teo wáacá! ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Obohjeéhtih, páant niíj jʉ̃ihnidih biíh yéejniboó nin pah ãt niíj jʉ̃ih jwʉ́ʉbanap wʉt jĩ: —¡Caandíh páant ma niijcá bojoó! ¿Páant niijná, Diosdih ma ʉ́ʉmcan niít? Meemdíh peéh mawat biíc yoobó caandíh ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jwiít yéej chãjnitdih ĩ peéh mawachah, yoobópdih caá. Obohjeéhtih, nin ã yéej chãjcah yʉhna, caandíh ĩ peéh maona caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Páant niíj péanit, Jesúsdih nin pah ãt niijíp wʉt jĩ: —Jesús, meém maáh waadná, weemdíh ma tʉ́i náhninaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Yoobópdih meemdíh wã naóhna caá. Bʉʉ yeó jáapjeh Tʉ́ini Pebhboó wãjeéh ma jʉmbipna caá, Jesús caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Páant ĩ péoh dodhdat tʉ́ttimah, yeó jáap tac yoób ãt dʉpʉ́áh bejep wʉt jĩ. Pánihna, nihat baác dʉpʉ́niji biíc peihcanni horas tʉ́ttimah ãt jwʉ́ʉb baabáh bejep wʉt jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Páant ã jwʉ́ʉb baabáh bejat pínah jã́tih, Jesús nin pah ãt niíj ñaacáp wʉt jĩ: —Wĩ́ih caolihdih ma ʉbʉʉ́, Paá, ãt niijíp wʉt jĩ. Páant niíj péanit, ãt wʉnah bejep wʉt jĩ. Páant ã wʉnʉchahjeh, Dioíh mʉʉ́ diítboó ĩ jãh yaíhni bʉ́dí wʉ́ʉpni chóo yeo dei bejna, chéne chóo pah ãt chãwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Páant niijnít, Jesús ã wʉnʉchah ennit, pebh ñʉhni soldadowã ĩ maáhboó Diosdih wẽinit, —Nin yéejniji ãt nihcan tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pánihna, nihat enedih wáac jʉibínitji Jesús ã wʉnʉchah ennit, bʉ́dí jĩ́gahnit, ĩ́ih mʉʉnáboó ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Obohjeéhtih, nihat Jesúsdih jéihnit, Galilea baácmant ãjeéh jʉ̃óhnit yaádhbʉt Jesúsdih yʉʉ́pbit ĩt en ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Caán láa José wʉ̃t jʉmni, Judea baácdih bóo, Arimatea tʉ́tchimant Jerusalén tʉ́tchina jʉibíniji ãt jʉmʉp wʉt jĩ. Yoobópdih chãjni, Dios ã maáh jʉmatdih pã́ini wʉt jĩ. Judíowã ĩ maátajeéh jʉmna yʉhna, Jesúsdih ĩ mao yohat tʉ́ʉtatdih ãt náahcap wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pánihna, José Pilato pebhna Jesúíh bácahjidih ʉʉ́bʉ́dih ãt bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pánih ʉʉ́bh péanit, Jesúíh bácahjidih ʉb deya, tʉ́ini yégueh chóojĩh tainit, wʉnnitdih ĩ yoh jwʉhca naáh jeé íitboó ãt yohop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jesús ã wʉnni yeó jáap judíowã ĩ chooát pínahdih ĩ ámohat yeó jáap wʉt jĩ. Pánihna, ĩ chooát pínah hora jã́tihbitjeh ã jʉmʉchah, Jesúíh bácahjidih tʉ́i ámohcanjeh ãt yohop wʉt jĩ. Chooát yeó jáap tʉ́ttimah ãt tʉ́i ámoh péaíhip wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea baácmant Jesúsjeéh jʉ̃óhnit yaádh, ã yohat pínah íitboó Jesúíh bácahjidih ã ʉb bejechah, Joséjeéh ĩt en péenap wʉt jĩ. Pánihna, caán jeé íitna jʉibínit, ã́ih bácahjidih ã yohochah, ĩt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pánih en péa, ĩ́ih mʉʉná jwʉ́ʉb bejnit, Jesúíh bácahjidih ĩ ñáñat pínah chej jʉmni nʉ́ona, chej jʉmni macdihbʉt ĩt ámohop wʉt jĩ. Pánihna, chooát hora ã jʉyʉ́chah, Moisés ã wʉtatji pahjeh ĩt choonáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo yeó jáap baáb jéenechah, queét yaádh ĩ ámohni chej jʉmnidih ʉbnit, Jesúíh bácahdih ĩ yohopjiboó caandíh ñáñadih ĩt bejep wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Caandíh ĩ yohopji íitna jʉibínit, caán íitdih nematji jeé jʉ́dʉdih bita ĩ pʉ̃tʉ́ dodhdatji pah ã jʉmʉchah, ĩt enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pánih ennit, caán íitdih waad béjnit, ĩ Maáh Jesúíh bácahjidih ĩt bid jʉicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pánih bid jʉicán, “¿Ded pah tigaá ãt bej?” ĩt niíj jenah joyóp wʉt jĩ. Páant ĩ niíj jenah joi ñʉ́hʉchah, chéne neoná yeh iigní yégueh chóo dʉonít, queét yaádh pebh ĩt jígoh ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Páant ĩ jígoh ñʉhʉchah ennit, bʉ́dí ʉ́ʉmna, queét yaádh ĩt páah yoh ñajap wʉt jĩ. Páant ĩ páah yoh ñajachah ennit, ángelwã queétdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanih tigaá wʉnnitdih ĩ yohopboó Jesúsdih ñi bid? ");
INSERT INTO cbv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Caán ninboó ã wihcan caá. Jáantjeh ã boo pʉd jʉ̃ʉ́wʉ́p be. ¿Galileaboó ñijeéh jʉm jwʉhna, yeebdíh ã niijátjidih ñi náhnican niít? ");
INSERT INTO cbv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Weém nihat cã́acwã ʉ́ʉd jeñédih yeejépwãdih ĩ wʉ̃hʉchah, cruzboó péoh dodhnit, ĩ mao yohbipna caá. Páant ĩ mawachah yʉhna, biíc peihcanni yeó jáap tʉ́ttimah, wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá’, yeebdíh ã niíj naáwátjidih ¿ñi náhnican niít? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Páant ĩ niijíchah joinít, Jesús ã niijátjidih ĩt náhninap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pánih náhninit, Jesús once ã bohénitji, bita biícdih ĩ jʉmʉpna ĩ enatjidih naáwádih ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Queét yaádh María Mágdala tʉ́tchidih bóli, Juana, biíh wili María Santiago íin, bita yaádhbʉt ĩjeéh bejnit Jesús ã bohénitjidih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Obohjeéhtih, ĩ naáwáchah joiná yʉhna, “Nih yáana caá. Déhenit yaadábeh caá”, niíj jenah joinít, queét yaádhdih ĩt joyáh bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Obohjeéhtih, Pedroboó ĩ naáwáchah joinít, Jesúíh bácahjidih ĩ yohopjina ãt ñáo ñah bejep wʉt jĩ. Caanná jʉibínit, jeé íit diítna péeb jéen ennit, Jesúíh bácahjidih ĩ pinni chóojijeh ã ñajachah, ãt enep wʉt jĩ. Pánih en, bʉ́dí jenah joinít, ã́ih mʉʉ́boó ãt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Caán yeó jáapjeh chénewã Jesúsjeéh péenitji Emaús tʉ́tchina ĩt bejep wʉt jĩ. Jerusalén tʉ́tchimant Emaús tʉ́tchina once kilómetros wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pánih bejna, nihat Jesús ded pah ã yapatjidih queétjeh míic wéhe bejna ĩt chãjap wʉt jĩ. Jesús cruzboó ñʉhnit, ã wʉnatjidih, ã jwʉ́ʉb boo pʉd jʉ̃ʉ́wátji doonádihbʉt míic wéhe bejna ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Páant ĩ míic wéhe bejechah, queétdih ñʉʉ́n jwãáh jʉibínit, ĩjeéh Jesúsjeh ãt bejep wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Obohjeéhtih, caandíh ĩt beh encap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pánih ñʉʉ́n jwãáh jʉibínit, Jesús queétdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dépanihatdih míic wéhe bej tigaá ñi chãj? ãt niijíp wʉt jĩ. Páant ã niijíchah, chãonít, wẽicanjeh, caandíh ĩt en ñʉhʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pánih en ñʉhnit, Cleofas caandíh nin pah ãt niíj jepahap wʉt jĩ: —¿Meém Jerusalén tʉ́tchidih nih jibni niít? ¿Bʉʉ yeó jáapna caán tʉ́tchiboó ded pah ã yapatjidih ma jéihcan niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Dedé ã yapatjidih niij tígaá ñi chãj? Jesús ãt niíj ʉʉ́bh joyóp wʉt jĩ. —Jesús, Nazaret tʉ́tchidih bóodih ã yapat. Caán Dios naáwátdih naóh yapani jʉmna, ã naáwát wẽpni, ã chãjatbʉt wẽpni beé. Páant ã jʉmatdih Dios ã enechah, nihat cã́acwãbʉt ĩ enep be. ");
INSERT INTO cbv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tʉ́ttimah, Dioíh mʉʉdíh en daonít maáta, bita jwĩ maátabʉt caandíh peéh mawat pínah niijná, Romanowãdih ĩ wʉ̃hʉchah, queét cruzboó péoh dodhnit, ĩ mao yohop be. ");
INSERT INTO cbv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","‘Romanowã ĩ wʉtatdih Jesús jwiít judíowãdih ã tʉ́i ʉbbipna caá’, niíj jenah joinít, bʉ́dí wẽina jwĩ chãjap yʉh be. Obohjeéhtih, ã wʉnʉp be. Bʉʉ ã wʉnat tʉ́ttimah biíc peihcanni yeó jáapjeh ã yapna caá. ");
INSERT INTO cbv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Biquína jwiít biícdih Jesús báadhdajeéh péenit yaádh jwiítdih ĩ naáwáchah, jwĩ joí wʉ́hi bejep be. Bʉʉ cheibitjeh Jesúsdih ĩ yohopji jeé íitna jʉibínit, ");
INSERT INTO cbv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ã́ih bácahjidih ĩt bid jʉicáp wʉt be. Bid jʉicánjeh, jwĩ pebhboó jwʉ́ʉb jʉinít, ángelwãdih ĩ enatjidih jwiítdih ĩ naáwáp be. ‘Jesús ã boo pʉd jʉ̃ʉ́wʉ́p be’, ángelwã queétdih ĩ niíj naáwátjidih jwiítdih ĩ jwʉ́ʉb naóh yapanap be. ");
INSERT INTO cbv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bita jwĩjeéh jʉmnitbʉt Jesúsdih yohopji jeé íitna ĩt bejep wʉt be. Caanná jʉibínit, queét yaádh ĩ naáwátji pah ĩt enep wʉt be. Obohjeéhtih, Jesúsdih ĩt encap wʉt be, Emaús tʉ́tchina bejnit Jesúsdih ĩt niíj naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Páant ĩ niijíchah joinít, Jesús nin pah queétdih ãt niíj naáwáp wʉt jĩ: —Yeéb tʉ́i jenah joicánnit jʉmna, Dios naáwátdih naóh yapanit nihat ĩ daacátjidih páantjeh ñi joyáh bojna caá. Páant ñi joyáh bojat jíib, ñi beh joicán caá. Tʉ́i joinít, ñi beh joyóchah, ãta tʉ́i tagaá. Nin pah Dios naáwátdih naóh yapanit ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","‘Dios ã wahni pínahdih cã́acwã bʉ́dí yeejép chãjnit, ĩ mao yohbipna caá. Páant ĩ mawat tʉ́ttimah, Dios caandíh booanit, ã pebhboó maáh ã waadábipna caá’, naóh yapanit ĩt niíj daacáp tajĩ, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tʉ́ttimah, Dios ã wahni Cristodih ded pah ã yapat pínahdih nihat Dios naáwátdih naóh yapanit ĩ daacátjidih Jesús queétdih ãt beh joyánap wʉt jĩ. Moisés ã daacátjidih jwíih bohé, tʉ́ttimah nihat bita naóh yapanit ĩ daacátjidihbʉt ãt bohénap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Páant ĩ míic wéhe bejna, ĩ jʉibíát pínah tʉ́tchidih ĩ tóah bejechah, Jesús caán tʉ́tchidih yap bejni pah ãt nihip wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Páant ã yap bejíhichah ennit, “Jwĩjeéh ma chão jwʉ́hʉʉ́. Tõo ñáh jʉ̃óhna caá ã chãjap”, Jesúsdih ĩt niijíp wʉt jĩ. Páant ĩ niijíchah joinít, ĩjeéh ãt chão jwʉ́hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pánihna, ĩ jeéméchah, Jesús pan dahdih ʉbnit, Diosdih nin pah ãt niíj ʉʉ́bʉ́p wʉt jĩ: “Jeémát ma wʉ̃hat tʉ́ina caá, Paá”, niíj péanit, queétdih ãt daj wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Páant niíj ʉʉ́bhnit, ã daj wʉ̃hʉchahjeh, caandíh ĩt yoób beh enep wʉt jĩ, bʉca. Ĩ beh enechahjeh, Jesús ãt bʉʉdáh bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ã bʉʉdáh bejechah ennit, nin pah ĩt míic niijíp wʉt jĩ: —Namáboó jwiítdih jwãáhnit, Dios naáwátdih ã bohé jʉ̃ʉ́wʉ́chah, jwĩ́ih caolih bainí ã wẽican beé, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pánihna, jeémp péanitjeh, Jerusalén tʉ́tchina waícanjeh ĩt jwʉ́ʉb bejep wʉt jĩ. Caanná jʉibínit, Jesús once ã bohénitji bita ĩ chéenwãbʉt ĩ míic wáacapboó ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jã́tih jwíih míic wáac jʉibínitboó queét chénewã jáap jʉibínitdih nin pah ĩt jípónih jwãáh naáwáp wʉt jĩ: —¡Jwĩ Maáh ãt boo pʉd jʉ̃óh tagaá! Pedrodih ãt jígohop wʉt be, bʉca, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Páant ĩ niijíchah joinít, queét jáap jʉibínitbʉt namádih ĩ bejechah, queétdih ded pah ã yapatjidih ĩt naáwáp wʉt jĩ. Jesús pan dahdih ʉʉ́bhnit, ã dajachah, caandíh ĩ beh enatjidihbʉt ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Páant ĩ naáwát tacjeh, ĩ cãtíh Jesús ãt jígoh ñʉhʉp wʉt jĩ. —¿Ñi jʉm caá? Dios ã tʉ́yat ñijeéh ã jʉmʉ naáh, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Páant ã niijíchah joinít, “Ã́ih dadahjidih enna caá jwĩ chãjap”, niíj jenah joinít, tʉbit ĩt ʉ́ʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Páant ĩ ʉ́ʉmʉchah, queétdih nin pah ãt jwʉ́ʉb niijíp wʉt jĩ: —¿Dépanih tigaá ñi ʉ́ʉm? ¿Dépanihna ‘Nin Jesús nihcan caá’, ñi niíj jenah joí? ");
INSERT INTO cbv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wĩ́ih téihyanadih, wĩ́ih jítchanadihbʉt ĩ péhwatji íitnadih ñi eneé. Weemdíh ñi teo joyoó. Pánih teo joinít, ñi jéihbipna caá. Dadahjeh wã jʉmʉchah nihna, ñita jéih teo joicán tagaá. ¡Weemjéh tigaá! Jesús queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Páant niijnít, ã́ih téihyana, jítchanadihbʉt, queétdih ãt jʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Obohjeéhtih, páant ã jʉ́ʉtʉchah yʉhna, bʉ́dí wẽina, en wʉ́hi bejnit, páantjeh ĩt tʉ́i jenah joi jwʉ́hcap wʉt jĩ. Páant ĩ tʉ́i jenah joicátdih ennit, —¿Jeémát ñi bíbohcan niít? Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Páant ã niíj ʉʉ́bʉ́chah joinít, diibáni queejdíh caandíh ĩt wʉ̃hʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Páant ĩ wʉ̃hʉchah ʉbnit, queét nihat ĩ enechah, ãt jeémép wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pánih jeémp péanit, Jesús queétdih nin pah ãt niijíp wʉt jĩ: —Ñijeéh jʉm jwʉhna, ded pah wã yapat pínahdih yeebdíh wã naáwáp jĩ. Moisés ã daacátji, Dios naáwátdih naóh yapanit ĩ daacátji, David Salmos ĩ niijní ã daacátjidihbʉt biíc yoobó weemdíh yapat ã náahap be, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Páant niijnít, Dios naáwátdih jwʉ́ʉb bohénit, nin pah ãt niíj beh joyánap wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Dios naáwátdih daácnit nin pah ĩt niíj naóh daacáp tajĩ. ‘Dios ã wahni pínah Cristo yeejép yapnit, biíc peihcanni yeó jáap tʉ́ttimah, ã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Páant, ã boo pʉd jʉ̃ʉ́wát tʉ́ttimah, cã́acwã ĩ yéejatdih cádahnit, tʉ́iniboodíh ĩ tʉ́ʉt nʉʉmát pínah niijná, nihat baácdih moondíh ã́ih tʉ́ini doonádih ĩ naóh peét bejbipna caá. Páant ĩ tʉ́ʉt nʉʉmʉ́chah, Diosboó ĩ yéejatdih ã yoh wʉ̃hbipna caá. Jerusalén tʉ́tchidih moondíh ĩ jwíih naóhbipna caá. Tʉ́ttimah, nihat baácdih moondíhbʉt ĩ naóh peét bejbipna caá’, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pánihna, yeébboó ded pah weemdíh ã yapatdih ennitji, bitadih tʉ́i naáwát caá náahap. ");
INSERT INTO cbv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dios ã niijníji yeebdíh teo wáacni pínah Tʉ́ini Espíritudih weémboó yeebdíh wã wahbipna caá. Pánihna, wã wahni pínahdih nin tʉ́tchidih ñi pã́i jwʉhʉʉ́, Jesús ã bohénitdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Páant niíj péanit, Jesús Jerusalén tʉ́tchimant Betania tʉ́tchi pebh queétdih ãt nʉmah bejep wʉt jĩ. Caanná jʉibínit, ã́ih téihyajĩh jʉ́ʉt ñahanit, “Dios yeebdíh ã tʉ́i teo wáaca naáh”, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Páant niíj péanitjeh, jeáboó ãt pʉ́ʉh laab béjep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Páant ã pʉ́ʉh laab béjechah ennit, caandíh ĩt wẽi naáwáp wʉt jĩ. Tʉ́ttimah, bʉ́dí wẽinit, Jerusalén tʉ́tchiboó ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pánihna, caanjĩ́h jʉmna, yeó jáap jʉmat pah Dioíh mʉʉná bejnit, Diosdih ĩpĩ́ wẽi naáwáp wʉt jĩ. Páant bóojeh tigaá weém Lucas wã daacát.");
INSERT INTO cbv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Biíhmahjeh ded pah Dios ã jʉmatdih naóhni pínah, Cristo, Diosjeéh ãtát jʉmʉp wʉt jĩ. Caán Cristo Dios yoobát ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nin baácdih Dios ã chãjat pínah jã́tih, Cristo Diosjeéh ãtát jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Caan wʉ́t jĩí nin baácdih jʉmni pínahdih ãt chãjap wʉt jĩ. Nin baácdih, jeádih, nihatdih Dios caandíh ãt chãjat tʉ́ʉtʉp wʉt jĩ. Pánih chãjat tʉ́ʉtnit, cã́acwãdihbʉt caandíh ãt chãjat tʉ́ʉtʉp wʉt jĩ. Páant ã wʉtʉchah, Cristo nihatdih ãt chãj beedánap wʉt jĩ. Bʉʉ jwĩ ennidih, jwĩ enca naáhdihbʉt ã chãjcah, nihat ãta wihcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo tigaá nihatdih báadhdani. Jiiátjĩh jwĩ jií enat pah, jwĩ íip ded pah ã jʉmatdih caán jwiít cã́acwãdih ã tʉ́i jéihyana caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chei jwĩ jéih encat pah, yéej chãjna, jéih encannit panihnit jwĩ jʉmna caá. Obohjeéhtih, Cristoboó jiiát panihni jʉmna, jwiítdih tʉ́i ennit panihnit ã chãjna caá. Pánihna, dʉpʉ́átboó jiiátdih ded pah ã jéih dʉbacat pah, dedé yéejatbʉt Cristoboodíh ded pah ã jéih yap yohcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Cã́acwãdih daabáni Juan wʉ̃t jʉmnidih Diosboó ã wahni Cristoíh doonádih ãt naóh waáwát tʉ́ʉtʉp wʉt jĩ, cã́acwã caandíh joinít, Cristodih ĩ tʉ́i jepahat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Caán Juan Cristo ãt nihcap wʉt jĩ. Obohjeéhtih, Cristo baabát panihni ã jʉmatdih naóhni Juan ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Caán Cristo baabát panihni, nihat cã́acwã Diosdih ĩ jéihyat pínah niijná, nin baácboó ãt jʉ̃ʉ́wʉ́p wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dios nin baácdih chãjna, caán Cristo biícdih ĩt chãjap wʉt jĩ. Pánih chãjni Cristo ã jʉmʉchah yʉhna, nin baácdih moónboó caandíh ĩ jéihcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nin ã chãjniji baácdihjeh ãt cã́ac jʉmʉp wʉt yʉh jĩ. Obohjeéhtih, páant ã cã́ac jʉmʉchah yʉhna, ã chãjni baácdih jʉmnitboó caandíh ĩ náahcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Páant ĩ náahcah yʉhna, biquína caandíh jepahnitdih Dios ã weh pah ãt chãjap wʉt jĩ. Caandíh jepahnitboó bácah, yoobópdih ã weh yoobát tigaá ĩ jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Páant niíj naóhna, jwiít jwĩ weh jʉmíhat dée panihcan caá. Obohjeéhtih, Diosboó Cristodih jepahnitdih biíc weh pah ã chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pánihna, Cristo ã cã́ac jʉmat tʉ́ttimah, jwĩjeéh ã jʉmʉp jĩ. Páant ã jʉmʉchah ennitji, cã́acwãdih oinit, yoobópdih naóhni ã jʉmatdih jwĩ jéihna caá. Caán Dios wʉ̃ʉ́h biícjeh jʉmna, Dios ã wẽpat ã tʉ́yatbʉt caandíh ã jʉmʉp jĩ. Pánihni ã jʉmʉchah, jwĩ tʉ́i jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Daabániboó cã́acwãdih daabána, Cristo ã jʉ̃ʉ́wʉ́chah ennit, nin pah ã niíj naáwáp jĩ: “Con caá yeebdíh wãpĩ́ naóhni. Obohjeéhtih, weém wã cã́ac jʉmat pínah jã́tih, caán ãtát jʉmʉp wʉt jĩ. Nin baác ã jʉmat pínah jã́tihbʉt ãtát jʉmʉp wʉt jĩ. Pánihna, caán weem cháh ã jʉmna caá”, Juan cã́acwãdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Caán Cristo wẽpni jʉmna, jwiítdih bʉ́dí oinit, dawá láa ã tʉ́i teo wáacap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios ã wʉtatdih Moisésboodíh ã́ih cã́acwãdih ãt naóh yapaat tʉ́ʉtʉp wʉt jĩ. Obohjeéhtih, Jesucristoboó Dios cã́acwãdih bʉ́dí ã oyatdih, ã naáwát tʉ́i yoobópdih ã jʉmatdihbʉt naóh yapanadih ãt jʉ̃ʉ́wʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Obohjeéhtih, Diosdih jwiít cã́acwã jwĩ jéih encan caá. Pánihna, Dios wʉ̃ʉ́h biícjeh ãjeéh jʉmniji nin baácboó cã́ac jʉmnit, ded pah ã íip ã jʉmatdih jwiítdih ã jéihyanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén tʉ́tchidih moón jwĩ maátaboó sacerdotewãdih, Dioíh mʉʉ́boó teonitdihbʉt Juan Daabáni pebhna “¿Déhe tigaá meém?” niíj ʉʉ́bh joyát tʉ́ʉtna, ĩt wah bojop tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Páant ĩ niíj ʉʉ́bh joyóchah joinít, Juanboó nin pah ã niíj jepahap jĩ: —Yoobópdih yeebdíh wã naóhna caá. Weém, Dios ã wahni Cristo nihcan caá, ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—¿Caán láa bácah déhe tigaá? ¿Meém Cristo nihcan, Elíasji niít? ĩ niíj ʉʉ́bh joyóp jĩ. —Nihcan caá, queétdih ã niíj jepahap jĩ. —¿‘Dios naáwátdih naóh yapani ã jʉ̃óhbipna caá’, jwĩ nʉowã ĩ niijní niít? ĩ niíj ʉʉ́bh joyóp jĩ. —Obohjeéhtih, weém caán nihcan caá, ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Caán láa bácah déhe tigaá meém? Jwiítdih biícmantjeh ma naáwá, jwiítdih ʉʉ́bh joyát tʉ́ʉtnitdih jwĩ tʉ́i naáwát pínah niijná. ¿Ded pohba tigaá ma yoób jʉm? ĩ niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Páant ĩ niíj ʉʉ́bh joyóchah joinít, nin pah queétdih ã niíj jepahap jĩ: —Weemdíh jenah joiná, Isaíasji nin pah ãt niíj daacáp tajĩ: ‘Biíc cã́ac mʉʉ́ wihcapboó nin pah ã niíj wẽp naóhbipna caá: “Jwĩ Maáh ã jʉ̃ʉ́wát pínah jã́tih ñi yéej chãjatdih cádahnit, tʉ́iniboodíh tʉ́ʉt nʉʉmnít, caandíh ñi tʉ́i páñaá”, ã niijbípna caá’, ãt niíj daacáp tajĩ. Páant ã niíj daácniji caá weém, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Páant ã niijíchah joinít, biquína fariseowã ʉʉ́bh joyát tʉ́ʉtnit ĩ wahnitboó nin pah ĩ jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ: —Meém Cristo nihcan, Elíasjibʉt nihcan, Dios naáwátdih naóh yapani pínah nihcan, ¿Caán láa bácah dépanih tigaá meém cã́acwãdih ma daabá? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Páant ĩ niijíchah joinít, Juanboó queétdih nin pah ã niíj jepahap jĩ: —Weém cã́acwãdih mahjĩhjeh wã daabána caá. Obohjeéhtih, biíh ñi beh enca naáh ñi cãtíh ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Caán wã tʉ́ttimah jʉ̃óhni chah wẽpni caá. Pánihna, caandíh jenah joiná, ‘Weém oboh jʉmni caá’, wã niíj jenah joiná caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betania tʉ́tchi Jordán mʉj conanaamánt Juan cã́acwãdih ã daabánapdih queét páant ĩ niíj míic wéhenap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Daanimant bóo yeó jáapdih Jesús ĩ niijní ã pebhna ã dei jʉyʉ́chah ennit, jwiít caandíh joinítdih Juan Daabáni nin pah ã niíj naáwáp jĩ: “Ñi eneé. Con jʉ̃óhni Dios ã wahni oveja wʉ̃ʉ́h panihni caá. Jwiít judíowã jwĩ yéejat yohat tʉ́ʉt niijná, oveja wʉ̃ʉ́hdih sacerdotewãdih jwĩ mawat tʉ́ʉtna caá. Páant ĩ chãjat dée panihni, con Dios ã wahnidihbʉt cã́acwã ĩ mao yohbipna caá. Pánih wʉnnit, nihat baácdih moón jwĩ yéejatdih ã yoh wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Con caá yeebdíh wãpĩ́ naóhni. ‘Wã tʉ́ttimah jʉ̃óhni wã cã́ac jʉmat pínah jã́tih jʉmniji weem cháh ã jʉmbipna caá’, yeebdíh wãát niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Caán láa, weembʉ́t Dios wʉ̃ʉ́h ã jʉmatdih wã jéih jwʉhcap jĩ. Obohjeéhtih, panih jéihcan yʉhna, yeéb wã déewã caandíh ñi tʉ́i jéihyat pínah niijná, yeebdíh mahjĩh wã daabánap be”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Páant niíj péanit, Juan jwiítdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: “Wã daabáát pínah jã́tih weembʉ́t caandíh wã jéih jwʉhcah, weemdíh daabáát tʉ́ʉtni nin pah ã niíj naáwáp jĩ: ‘Jop pah jígohni Tʉ́ini Espíritu jeámant dei jʉ̃óhnit, biíc newédih ã jaamáchah enna, “Caán Dios ã wahni caá”, ma niíj jéihbipna caá. Caánboó mahjĩh daabáát panihni Tʉ́ini Espíritu ã wẽpatdih bʉ́dí ã wʉ̃hbipna caá’, weemdíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pánihna, Tʉ́ini Espíritu, jop pah jígohni, dei jʉ̃óhnit, caandíh ã jaamáchah, wã enep be. Pánih ennit, con Dios ã wahni ã jʉmatdih jéihna, ‘Yoobópdih Dios wʉ̃ʉ́h caá’, yeebdíh wã niíj naóhna caá”, jwiítdih Juan ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Daanimant bóo yeó jáapdih, jwiít chénewã Juan Daabáni ã bohénit, caán biícdih jwĩ ñʉhʉchah, Jesús ã yap bejechah ennit, nin pah jwiítdih ã niíj naáwáp jĩ: —Condih ñi eneé. Con tigaá Dios ã wahni oveja wʉ̃ʉ́h panihni, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Páant ã niijíchah joinít, jwiít Jesúsdih jwĩ ñʉʉ́n pée bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Páant jwĩ ñʉʉ́n pée bejechah, tac pʉ́ʉd ennit, jwiítdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Jʉ̃ʉ́h, dedédih tigaá ñi bid? ã niijíp jĩ. —¿Bohéní, deh tigaá meém ma jʉm? caandíh jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Wãjeéh ñi jʉ̃ʉ́wʉ́, jwiítdih Jesús ã niíj jepahap jĩ. Páant ã niijíchah joinít, ã jʉmatdih jéihyat tʉ́ʉt niijná, ãjeéh jwĩ bejep jĩ. Cheyeh jwãáhnitji caandíh jwĩ pej jʉm tʉ̃́wʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jwiít chénewã Juan Daabáni ã niijíchah joinítji Jesúsjeéh bejnit, weém Andrésjĩh jwĩ jʉmʉp jĩ. Andrésboó Simón Pedro ã ʉ́ʉd jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Waícanjeh Andrés weép jeñédih bididih ã bejep jĩ. —Mesías jwĩ niijní, Dios ã wahnidih jwĩ jwãááp be, ãt niijíp wʉt jĩ. Griegowãboó Dios ã wahni niijná, ‘Cristo’ ĩpĩ́ niijná caá. ");
INSERT INTO cbv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Páant niijnít, Andrés Simóndih jwĩ pebhna ãt nʉmah jʉ̃ʉ́wʉ́p tajĩ. Páant ã nʉmah jʉyʉ́chah, Jesús Simóndih nin pah ã niijíp jĩ: —Meém Simón, Juan ã wʉ̃ʉ́h caá. Obohjeéhtih, meém Cefas wʉ̃t bʉ́ʉdhni ma jʉmbipna caá, ã niijíp jĩ. Jwiít judíowã “Cefas” jwĩ niijnídih griegowãboó “Pedro”, ĩpĩ́ niijná caá. Páant niijnídih “Jee dáh panihni”, niijná caá jwĩ chãjap. ");
INSERT INTO cbv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Daanimant bóo yeó jáapdih Jesús Galilea baácna jwiítdih nʉmah bejna, Felipedih jwãáhnit: —Wãjeéh ma jʉ̃ʉ́wʉ́, caandíhbʉt ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipeboó Betsaida wʉ̃t jʉmni tʉ́tchidih bóo ã jʉmʉp jĩ. Andrés Pedrojĩh caán tʉ́tchidih moon mʉ́ntih ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Páant Jesús caandíh ã niijíchah joinít, Felipeboó Natanaeldih jwíih bididih ã bejep jĩ. Caandíh jwãáhnit, —Moisés ã naóh daácniji, bita Dios naáwátdih naóh yapanitbʉt ĩ daácnijidih jwĩ jwãáhna beé. Jesús Nazaret tʉ́tchidih bóo José wʉ̃ʉ́h caá, Felipe caandíh ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Obohjeéhtih, páant ã niijíchah joiná yʉhna, Natanaelboó nin pah ãt niíj jepahap wʉt jĩ: —Páant, Nazaret tʉ́tchi oboh jʉmni tʉ́tchi ã jʉmʉchah, ded caán tʉ́tchidih bóo cã́acwãdih teo wáacni pínah ã wihcan niít, ãt niijíp wʉt jĩ. —Caán láa bácah, meemjéh tih enedih ma jʉ̃ʉ́wʉ́p, Felipe ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Páant niijnít, Jesús biícdih jwĩ jʉmʉpna ãt nʉmah jʉ̃ʉ́wʉ́p tajĩ. Páant, ĩ jʉ̃ʉ́wʉ́chah ennit, Jesús nin pah ã niijíp jĩ: —Con jʉ̃óhni, yoobópdih tʉ́ini judío cã́ac caá. Caandíh dedé yeeat ã wihcan caá, Natanaeldih enna, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Páant ã niijíchah joinít, Natanaelboó caandíh nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Ded pah tigaá weemdíh ma tʉ́i jéih? ã niijíp jĩ. —Meemdíh Felipe ã naáwát pínah jã́tih, higuera nah pʉ́ʉjdih ma chʉ́ʉdʉchah, wãát enep be, Jesús caandíh ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Bohéní, meém Dios wʉ̃ʉ́h caá. Jwiít judíowã jwĩ Maáh pínah caá, Jesúsdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—‘Higuera nah nʉmp ma chʉ́ʉdʉchah, wã enep be’, wã niijíchah joinít, ‘Dios wʉ̃ʉ́h caá meém’, ¿ma niíj jenah joí niít? Páant meemdíh wã enatji chah wã chãjachah, ma enbipna caá, Natanaeldih Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Páant niijnít, nin pah jwiít nihatdih ã jwʉ́ʉb niijíp jĩ: —Yoobópdih yeebdíh wã naóhna caá. Jeáboó wãtni pah ã jʉmʉchah, weém nihat cã́acwã ʉ́ʉd jeñé namá panihni wã chãjnidih Dioíh ángelwã aab béjnit, ĩ jwʉ́ʉb dei jʉ̃ʉ́wʉ́chah, ñi enbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Chéne yeó jáap tʉ́ttimah, Galilea baác Caná tʉ́tchidih, téihya chéwat ã jʉmʉp jĩ. Pánihna, Jesúsdih ĩ bidichah, jwiítbʉt ãjeéh jwĩ bejep jĩ. Jesús íin jwĩ jã́tih caán mʉʉná mitát jʉibínap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ĩ tʉ́i wẽi babhbachah, ĩ́ih jiwá iguíh mac ãt beedáh bejep wʉt jĩ. Páant ã beedéchah, Jesús íin caandíh nin pah mi niijíp jĩ: —Wʉ̃ʉhʉ́, jáantjeh ĩ́ih jiwá iguíh mac ã beedáh bejep be, mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Naá, ¿dépanih tigaá weemdíh páant ma niíj? Wã tewat pínah ã jʉibí jwʉhna caá, Jesús ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Páant ã niíj jepahachah joiná yʉhna, ã íinboó queét teo wʉ̃hnitdih nin pah mit niíj wʉtji taga: —Wã wʉ̃ʉ́h ded pah yeebdíh ã wʉtat pah ñi chãjáp, mit niijí taga. ");
INSERT INTO cbv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Caanjĩ́h seis dahwani wáam dahna ã jʉmʉp jĩ. Biíc wáam bʉ́dí jãaj cómoh pah bóo ã jʉmʉp jĩ. Jwiít judíowã Dios ã wʉtatji pah jwĩ téih chocat tʉ́ʉt niijná, páant bóo dahdih mah yáac yáwaat pínahdih jwĩpĩ́ bíbohop jĩ. Pánihna, caán mʉʉdíh moonbʉ́t caan dáhnadih ĩ bíbohop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pánihna, queét teo wʉ̃hnitdih nin pah Jesús ã niíj wʉtʉp jĩ: —Mahdih ʉb jʉ̃óhnit, caán wáam dahnadih ñi yáac yáwanaá, ã niijíp jĩ. Páant ã niijíchah joinít, teo wʉ̃hnit caán wáam dahnadih mah ĩ tʉ́i yáac yáwanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Páant ĩ yáac yáwaat tʉ́ttimah, Jesús queétdih nin pah ã jwʉ́ʉb niíj wʉtʉp jĩ: —Bʉʉ caandíh tóih ʉbnit, yeebdíh wʉtnidih ñi jʉibí wʉ̃hʉʉ́, ã niijíp jĩ. Páant ã niijíchah joinít, caandíh tóih ʉbnit, ĩ maáhdih ĩ jʉibí wʉ̃hʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Obohjeéhtih, queét mahdihjeh ĩ yáacnijidih Jesús ã tʉ́ʉt nʉʉmʉ́chah, jiwá iguíh mac yoobát ãt bejep tajĩ. Pánihna, queétdih wʉtniboó caan mácdih ã jwíih babh joyóchah, dedmant ĩ ʉbatjidih ãt jéihcap wʉt jĩ. Obohjeéhtih, caandíh teo wʉ̃hnitboó mahjeh ĩ yáacatjidih ĩ jéihyep jĩ. Pánihna, queétdih wʉtni babh joinít, téihya chéonidih ã jʉ̃ʉ́wát tʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Caán ã jʉyʉ́chah, teo wʉ̃hnit ĩ maáh nin pah ã niijíp jĩ: —Jwĩ bidnitdih caán yoobát macdih jwĩpĩ́ jwíih wʉ̃hna caá. Pánihat tʉ́ttimah, ĩ babh yáwachah ennit, jʉʉ macdih jwĩpĩ́ ñʉʉ́n tóihna caá. Obohjeéhtih meémboó páant mat chãjat tʉ́ʉtcan tagaá. Caán yoobát macdih tóihcanjeh, jʉʉ macboodíh mat jwíih tóihyat tʉ́ʉtʉp taga. Pánihat tʉ́ttimah, bʉʉ caán yoobát macboodíh mat wʉ̃hat tʉ́ʉtʉp taga, teo wʉ̃hnit ĩ maáhboó téihya chéonidih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Pánih chãjna, Galilea baác Caná tʉ́tchidih ã jwíih wẽp chãj jʉ́ʉtʉp jĩ, “Dios wʉ̃ʉ́h caá”, cã́acwã ĩ niiját pínah niijná. Pánihna, “Caán Dios ã wahni yoobát caá”, jwiít ã bohénit caandíh jwĩ niíj jenah joí jwíihip jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tʉ́ttimah, Capernaum tʉ́tchina Jesús jwiítdih ã nʉmah bejep jĩ. Páant ã nʉmah bejechah, ã íin, ã ʉ́ʉdwãbʉt jwĩjeéh biícdih ĩ bejep jĩ. Caanná jʉibínit, daocánni yeó jáap jwĩ jʉm jwʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua yeó jáapna ã tóah jʉ̃ʉ́wʉ́chah jéihnit, dawá jwĩ déewã Jerusalén tʉ́tchina ĩ bejep jĩ. Jesúsbʉt jwiítdih caanná ã nʉmah bejep jĩ. Caanná jʉibínit, Dioíh mʉʉná enedih jwĩ bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Caán mʉʉdíh jiwiwã, ovejawã, jopwãdihbʉt jíib chãjnitdih Jesús ã enep jĩ. Bitabʉt dinero jʉ́dʉdih tʉ́ʉt nʉʉmnít ĩ chʉ́ʉdʉchah, ã enep jĩ. Queét tʉ́ʉt nʉʉmnítboó cã́acwãdih bʉ́dí nʉʉmná ĩt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pánihna, caanjĩ́h jʉmni tõpnadih ʉbnit, caánboó jʉmnit cã́acwãdih ĩ́ih nʉñʉ́pwãdihbʉt ã pʉ̃i ñʉʉn bácanap jĩ. Dinero tʉ́ʉt nʉʉmnít ĩ chʉ́ʉdat páhana, ĩ́ih cáagat naanádihbʉt ã tóo yoh ã́acanachah, ĩ́ih dinero jʉ́dʉna ã pʉo yóh ñajap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pánihna, jopwãdih jíib chãjnitdih nin pah ã niíj jʉ̃ihñʉp jĩ: —Ñíih jopwãdih ñi ʉb bac bejeé. Nin wã íipdih ʉʉ́bát mʉʉdíh jíib chãjat mʉʉ́ ñi chãjca bojoó, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesús páant ã niijíchah joinít, Dios naáwátdih naóh yapani ã daacátjidih jwĩ náhninap jĩ. “Dios wã Maáh, míih mʉʉdíh bʉ́dí wã oina caá. Pánih oina, caandíh yeejép ĩ chãjachah ennit, bʉ́dí wã íijna caá”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesús páant ã chãjachah ennit, jwĩ maáta caandíh nin pah ĩ niíj jʉ̃ihñʉp jĩ: —¿Dépanihna queétdih páant ma ñʉʉn yóh baca? Meemdíh Dios páant ã chãjat tʉ́ʉtʉchah, cã́acwã ĩ chãjca naáhdih ma chãj jʉ́ʉtʉ́, jwĩ jéihyat pínah niijná, Jesúsdih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Páant ĩ niijíchah joinít, Jesús queétdih nin pah ã niíj jepahap jĩ: —Nin mʉʉdíh ñi yohochah, biíc peihcanni yeó jáap tʉ́ttimah, yeéb ñi yohni mʉʉjídih wã jwʉ́ʉb ámohbipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Páant ã niijíchah joinít, queét maáta caandíh nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —Cuarenta seis jópchi nin mʉʉdíh teona, ĩt péanap tajĩ. Obohjeéhtih, ¿meémboó biíc peihcanni yeó jáapbitjeh teona, ma ámoh péami naniít? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Obohjeéhtih, caán mʉʉdíhjeh niijcán, ã́ih bácahdih niijná ãt chãjap tajĩ. Páant ã naáwáchah yʉhna, maáta ĩ jéihcah, jwiítbʉt jwĩ jéih jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pánihna, wʉnniji Jesús ã boo pʉd jʉ̃ʉ́wát tʉ́ttimah, jwiít ã bohénitboó páant ã niijátjidih náhninit, jwĩ beh joyóp jĩ, bʉca. Dios naáwátdih ĩ daácniji nʉ́odih, Jesús ã niijátjidihbʉt “Caán yoobópdih tigaá”, jwĩ niíj jéihyep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua yeó jáapdih Jesús Jerusalén tʉ́tchiboó ã jʉmʉp jĩ. Pánih jʉmnit, jwiít cã́acwã jwĩ jéih chãjca naáhdih Dios ã wẽpatjĩh Jesús ã chãjachah ennit, “Caánboó Dios ã wahni Cristo caá”, dawá ĩ niíj jenah joyóp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Obohjeéhtih, ded pah ĩ jenah joyátdih jéihnit, “Weemdíh yoobópdih ĩ jepahcan caá”, Jesús ãt niíj jéihyep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pánihna, caanjéh cã́acwã ĩ jenah joyátdih tʉ́i jéih beedáni jʉmna, bita ded pah ĩ jenah joyátdih caandíh ʉʉ́bh joyát ã wihcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nicodemo, fariseo, jwiít judíowã jwĩ maáta poómpdih bóo wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesucristo Jerusalén tʉ́tchiboó jʉm láa, chei tac yoób dée, Nicodemo Jesúsdih enedih ãt jʉibínap wʉt jĩ. Pánih jʉibínit, nin pah ãt niijíp wʉt jĩ: —Bohéní, Dios jwiítdih ma bohéát pínah niijná, meemdíh ã wahatdih jwĩ jéihna caá. Pánih wahnit, majeéh ã jʉmatdihbʉt jwĩ jéihna caá. Majeéh ã wihcah, jwiít cã́acwã jwĩ jéih chãjca naáhdih mata jéih chãjcan tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Páant ã niijíchah joinít, Jesús caandíh nin pah ãt niíj jepahap wʉt jĩ: —Yoobópdih meemdíh wã naóhna caá. Ded jáap cã́ac jʉmni panihni jwʉ́ʉb jʉmcan, ded pah Dios ã maáh jʉmatdih ã jéihcan niít, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Páant cã́ac behe ¿ded pah jáap cã́ac jʉmni panihni ã jéih jwʉ́ʉb jʉmbi? ¿Ded pah ã íiníh wʉdahboó ã jéih jwʉ́ʉb waadbí? ¿Caandíh mi jwʉ́ʉb jéih weh jʉmca niít? Nicodemo ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","—Cã́acwãjeh ĩ weh jʉmʉchah, cã́acjeh caá. Obohjeéhtih, Tʉ́ini Espírituboó cã́acwãíh caolih wʉnni panihnidih ã booanachah, jwʉ́ʉb jáap cã́ac jʉmni panihnit ĩ jʉmna caá. Jáap caolih jʉmni panihnitjeh Dios weh ĩ jʉmna caá. Yoobópdih meemdíh wã naóhna caá. Ded mahjĩh daabácanni, Tʉ́ini Espíritu wihcanni, jáap panihni jʉmcan, Dios ã maáh jʉmʉpboó ã jéih waadcán niít. ");
INSERT INTO cbv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yoobópdih meemdíh wã naóhna caá: Meemdíhbʉt jáap cã́ac jʉmat panihni caá náahap. Caandíh páant wã niíj naáwáchah, ‘¿Ded pah caán ã yapbi?’ ma niíj ʉʉ́bh joicá bojoó. ");
INSERT INTO cbv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Johlit johat panihni caá. Johlit ã jʉ̃ʉ́wʉ́pmant ma jéihcan caá. Ã bejep pínahboobʉ́t ma jéihcan caá. Ã joh bʉʉg láajatdihjeh ma jéih enna caá. Pánihat pah, caolih wʉnni panihnitdih Tʉ́ini Espíritu ã booanachah, ded pah ã booaatdih jéih encan yʉhna, cã́ac ã tʉ́ʉt nʉʉmátdih ma tʉ́i jéih enna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Páant ã niijíchah joinít, Nicodemo Jesúsdih nin pah ãt jwʉ́ʉb niijíp wʉt jĩ: —¿Ded pah niíj naóh tigaá ma chãj? Ma naáwátdih wã beh joicán caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—¿Páant, meém judíowãdih bohéni yʉhna, ded pah wã naáwátdih ma beh joicán? ");
INSERT INTO cbv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yoobópdih meemdíh wã naóhna caá. Jwĩ jéihyatdih, jwĩ enatdihbʉt yeebdíh jwĩ naóhna yʉh caá. Obohjeéhtih, jwiítdih ñi joííhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nin baácboó ded pah ã jʉmatdih wã naáwáchah, ‘Yoobópdih ã naóhcan caá’, niijná, Dios pebhboó ded pah ã jʉmatdihbʉt wã naáwáchah, biíc yoobó ñi niíj jenah joibípna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Ded Dios ã jʉmʉpboó enedih aab béjniji jwʉ́ʉb dei jʉ̃óhni ã wihcan caá. Obohjeéhtih, weémboó, nihat cã́acwã ʉ́ʉd jeñé, caánboó wãpĩ́ jʉmʉp jĩ. Pánihna, caanmánt dei jʉ̃óhni weemjéh ded pah ã jʉmatdih yoobópdih wã jéih naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Jon jã́tih, Moisésji jʉm láa, Dioíh cã́acwã tʉ́tchi wihcapboó jʉm jwʉhna, caandíh ĩ jʉ̃ihñʉchah, dawá maiwãdih wahnit, queétjĩh cã́acwãdih ãt peéh chãjap wʉt jĩ. Mai pah jígohnidih ĩtahjĩh Dios Moisésdih ãt chãjat tʉ́ʉtʉp wʉt jĩ. Caán mai pah jígohnidih chãj péanit, máa nahdih bʉ́ʉdhnit, ãt baad dódhdop wʉt jĩ. Pánihna, det Diosdih tʉ́i jenah joinít, caán ã baad dódhni mai pah jígohnidih ennit, ĩt boonap wʉt jĩ.Caán ã baad dódhdat pah, cruzboó péohnit, pʉd dodhnit, cã́acwã weemdíh ĩ maobipna caá.Pánihna, weém caán cruzboó wã wʉnʉchah, det weemdíh tʉ́i jenah joinít, iiguípna bejnit déeji Diosjeéh páantjeh ĩ tʉ́i jʉmbipna caá”, Jesús Nicodemodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Dios nihat cã́acwãdih bʉ́dí ã oina caá. Pánih bʉ́dí oina, queétdih ã peéh chãjat déedih tʉ́i ʉbat tʉ́ʉt niijná, weém ã wʉ̃ʉ́h biíc jʉmnidih ã wah deyanap jĩ. Páant ã wahachah, det weemdíh jepahnit iiguípna bejnit déeji Diosjeéh páantjeh ĩ tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios cã́acwãdih yéejat peéh chãjat tʉ́ʉtna, weém ã wʉ̃ʉ́hdih nin baácboó ã wah deyacap jĩ. Obohjeéhtih, iiguípna ĩ bejat déedih queétdih wã tʉ́i ʉbat pínah niijná, ã wah deyanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Weém ã wʉ̃ʉ́hdih det jepahnitdih Dios ĩ yéejat jíib ã peéh chãjcan niít. Obohjeéhtih, det weemdíh ĩ jepahcah, queétboodíh ĩ yéejat jíib ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Weém Dios wʉ̃ʉ́h baabát panihni nin baácboó jʉ̃óhna, ded pah cã́acwã Diosjeéh ĩ tʉ́i jʉmat pínahdih wã jéihyaíhna caá. Obohjeéhtih, weém caán baabát panihnidih cã́acwã ĩ náahcap be. Ĩ chãjat yeejép ã jʉmʉchah, dʉpʉ́át panihnidihjeh ĩ náahap be. Pánihna, baabát panihnidih náahcan, yeejép chãjnit ĩ jʉmʉchah, Dios queétdih ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nihat yéej chãjnit ĩ yéej chãjatdih cádahíhcan, páant ĩ chãjatdih bita ĩ encat pínah niijná, baabát panihipboó ĩ jʉ̃ʉ́wíhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Obohjeéhtih, det Diosdih jepahnit baabápboó ĩ jʉ̃ʉ́wíhna caá, Dios ã wẽpatjĩh ĩ tʉ́i chãjatdih bita ĩ enat pínah niijná”, Nicodemodih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tʉ́ttimah, jwiít ã bohénitdih Judea baácna Jesús ã nʉmah jib bejep jĩ. Caanná jib bejnit, caanjĩ́h moón Diosdih ĩ jepahachah, queétdih ã daabánap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Enón wʉ̃t jʉmni pebh Salim wʉ̃t jʉmʉpdih caan mʉ́j nʉmahni ã jʉmʉchah, Juanbʉt cã́acwãdih daabána ãt chãjap wʉt jĩ. Queétdih ã daabáát pínah niijná, dawá ã pebhna ĩt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Caán láa Juan Daabánidih jwĩ maáta ĩ teo jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Biquína Juan Daabáni ã bohénit biíc jwĩ déejĩh ded pah jwiít judíowã jwĩpĩ́ daabáátdih míic wéhena ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pánih míic wéhe péanit, Juan pebhna jʉibínit, ã bohénit caandíh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —Bohéní, Jordán mʉj conanaajĩ́h majeéh jʉmniji ‘Caán caá weemdíh chah jʉmni’, ma niijníjiboó bʉʉ cã́acwãdih daabána caá ã chãjap. Páant ã daabánachah, nihat caan pébhna míicjeh bejna caá ĩ chãjap, Juandih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Páant ĩ niijíchah joinít, Juan nin pah ãt niíj jepahap wʉt jĩ: —Diosboó weemdíh ã jwíih daabáát tʉ́ʉtʉp jĩ. Pánihna, bʉʉ caandíh jwʉh daabáát tʉ́ʉtnit, ã pebhna cã́acwãdih ã bejat tʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Weém Cristo nihcan caá’, wã niijíchah, yeéb ñi joiná beé. Obohjeéhtih, Cristo jã́tih weemdíh Dios ã wahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pánihna, ãjeéh cã́acwã ĩ bejechah enna, bʉ́dí wã wẽina caá. Nin panihat dée caá: Téihya chéonih pínahboó mi áajeéh mi bejechah ennit, ã pej jʉmniboó bʉ́dí ã wẽina caá. Páant ã pej jʉmni ã weñat pah mʉn tigaá, weembʉ́t Jesúsdih ĩ tʉ́i péenachah ennit, bʉ́dí wã wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pánihna, cã́acwã weemdíh pée cádahnit, Cristoboodíh jwʉ́ʉb tʉ́i péeat caá náahap, Juan queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Páant niíj naóh péanit, nin pah Juan ã bohénitdih ãt jwʉ́ʉb niíj naáwáp wʉt jĩ: “Jeámant jʉmniji nin baácboó dei jʉ̃óhni nihatdih ã tʉ́i jéih beedána caá. Obohjeéhtih, jwiít cã́acwã nin baácboó jʉmnit, nin baácdihjeh ded pah ã jʉmatdih jéihnit, jwĩ naóhna caá. Caán Dios ã wahniboó jwiít cã́acwã chah jéihni ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ded pah ã enatji, ã joyátjidihbʉt jwiítdih ã naóhna caá. Páant ã naáwáchah yʉhna, cã́acwãboó ã naáwátdih ĩ joííhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pánihna, jeámant jʉ̃óhni ã naáwáchah, ded tʉ́i joiní ‘Dios yoobópdih naóhni caá’, ã niíj jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios ã wahni Cristodih ã́ih Tʉ́ini Espíritudih bʉ́dí yoobát ã wʉ̃hʉp be. Pánihna, Cristo Dios naáwátdih yoobópdih ãpĩ́ naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios ã wʉ̃ʉ́hdih bʉ́dí oinit, caandíh nihat ĩ maáh ã jʉmat tʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dios wʉ̃ʉ́hdih ded jepahni Diosjeéh páantjeh ã jʉmbipna caá. Obohjeéhtih, ded ã wʉ̃ʉ́hdih yap yohniboodíh íijnit, Dios bʉ́dí ã peéh chãjachah, ãjeéh ã wihcan niít”, Juan ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Juan chah dawá cã́acwã Jesúsdih péenitdih ã daabáát doonádih fariseowã ĩt joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Obohjeéhtih, Jesús pohba ã daabácan jĩí. Jwiít ã bohénitboó jĩí cã́acwãdih jwĩ daabánap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseowã ĩ jéihyat doonádih joinít, Jesúsboó Judea baácdih jʉmniji Galilea baácna jwiítdih ã nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Caanná bejna, Samaria baácdih yap bejat tʉ́ʉt jwĩ chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pánih yap bejna, Samaria baácdih bóo Sicar tʉ́tchina jwĩ jʉibínap jĩ. Caan pébh jwĩ nʉo Jacob ã wʉ̃ʉ́h Josédih ã wʉ̃hniji baácbit ãt jʉmʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Caanjĩ́h Jacobwãji ĩ mah tóihyat íit ã jʉmʉp jĩ. Pánihna, Jesúsboó yʉʉ́p jʉ̃óhniji chʉʉná, yeó jáap tac yoób caán íit pebh ã choó chʉ́ʉdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Páant ã choó chʉ́ʉdat pónih, jwiít ã bohénitboó tʉ́tchina jeémát jíib chãjadih jwĩ aab béjep jĩ. Caanjĩ́h Jesús ã chʉ́ʉdʉchah, Samaria baácdih bóli mah tóhyodih mit dei jʉibínap wʉt jĩ. Páant mi mah tóhyochah, Jesús nin pah caántdih ãt niijíp wʉt jĩ: —Weemdíh mah ma wʉ̃hʉʉ́, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—Meém judío cã́ac caá. Weémboó Samaria baácdih bóli caá. ¿Dépanih tigaá weemdíh mah ma ʉʉ́bh? Jesúsdih mit niíj jepahap wʉt jĩ. (Jwiít judíowã Samaria baácdih moondíh jwĩpĩ́ eníhcap jĩ. Pánihna, páant mit niijíp wʉt jĩ.) ");
INSERT INTO cbv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Páant mi niijíchah joinít, Jesús caántdih nin pah ãt niíj naáwáp wʉt jĩ: —Dios meemdíh ã teo wáacat déedih jéihcan, meemdíh mahdih ʉʉ́bhnidihbʉt ma jéihcan caá. Pánih jéihna nihna, ‘Mah ma wʉ̃hʉʉ́’, weémboodíh mata niíj ʉʉ́bh tagaá. Caán wã wʉ̃híhni mah panihnidih ma babhbachah, míih caolih ãta tʉ́i boo tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—¿Dépah niij tígaá páant ma niíj? Nin mah tóhyat íit nʉmah bóo caá. Mah tóhyat pínah wáam dah bíbohcan, ¿deh tigaá caolihdih booat tʉ́ʉtni mah ma ʉbbi? ");
INSERT INTO cbv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jwĩ nʉo Jacobji, ã wehbʉt, ĩ́ih nʉñʉ́pwã biícdih nin íitdih mah ʉbnit, ĩt babhbap wʉt jĩ. Ã́ihjidih jwiít ã jʉimenádih ãt wʉ̃hʉp wʉt jĩ. ¿Pánihna, jwĩ nʉo Jacobji chah wẽpni niít ma jʉmʉp, páant ma niijná? mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Ded nin íitdih bóo mahdih babhni ã jwʉ́ʉb taca joótbipna caá, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Obohjeéhtih, weém wã wʉ̃hni mah panihniboodíh babhna, chéneji ã taca joótcan niít. Ded wã wʉ̃hni mah panihnidih babhna, Diosjeéh páantjeh ã tʉ́i jʉmbipna caá. Meo waó cáahdih mah nooj bácni ã jõpcat pah wã wʉ̃hni mah panihni ã beedcán niít, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Caán láa bácah, caán ma niijní mahdih weemdíh ma wʉ̃hʉʉ́, jwʉ́ʉb taca joótcah, ninboó yeó jáap jʉmat pah mah tóhyodih wã jʉ̃óhcat pínah niijná, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Majeéh bóodih ma bidbi jwʉhʉʉ́, Jesús ãt niijíp wʉ̃t jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","—Obohjeéhtih, weém áa wihcannih caá, mit niíj jepahap wʉt jĩ. —Yoobópdih tigaá ma niijíp. Obohjeéhtih, cinco neoná caá ma weha mánaji. Bʉʉ majeéh jʉmni ma áa yoobát nihcan caá. Pánihna, ‘Weém áa wihcannih caá’, ma niiját yoobópdih tigaá, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Meémboó Dios naáwátdih naóh yapani nacaá. ");
INSERT INTO cbv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pánihna, yoobópdih wã jéihyat pínah niijná, weemdíh ma naáwá: Con jeená jwĩ nʉowãji Diosdih ĩpĩ́ ʉʉ́bʉ́p wʉt jĩ. Obohjeéhtih, ‘Jerusalén tʉ́tchiboó Diosdih ʉʉ́bʉ́dih bejat caá náahap’, yeéb judíowã ñipĩ́ niijná caá, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Yad wilí, weemdíh ma joi jwʉ́hʉʉ́. Nin wã naáwát yoobópdih caá. Tʉ́ttimah bóo láa, con jeéboó, Jerusalén tʉ́tchiboobʉ́t jwĩ íipdih ñi ʉʉ́bhcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yeéb Samaria baácdih moón ñi ʉʉ́bhnidih ñi jéihcan caá. Obohjeéhtih, jwiít judíowãboó caandíh jwĩ jéihna caá. Dios ã wahni, nihat cã́acwãdih tʉ́i ʉbni, judíojeh tigaá ã jʉmʉp. Pánihna, jwĩ wẽini Diosdih jwiít judíowãboó jwĩ jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bʉʉ láa, tʉ́ttimahbʉt Tʉ́ini Espíritu ã teo wáacachah, tʉ́i yoobópdih jenah joinít, cã́acwã Diosdih ĩ tʉ́i wẽibipna caá. Páant caandíh tʉ́i wẽinitboodíh caá Dios ã bidip. ");
INSERT INTO cbv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios jígohcanni ã jʉmʉchah, cã́acwã caandíh ĩ jéih encan caá. Pánihna, dedboó jʉmna, caandíh jwĩ wẽi ʉʉ́bʉ́chah, biíc yoobó ã tʉ́ina caá. Caandíh wẽina, Tʉ́ini Espíritu ã teo wáacatjĩh, tʉ́i yoobópdih jenah joinít, weñat caá náahap, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Mesías, ‘Cristo’, ĩ niijní, ã jʉ̃ʉ́wát pínahdih weém wã jéihna caá. Caán jʉ̃óhna, jwiítdih nihat ã jéihya beedábipna caá, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Weém ma niijní Cristo tigaá, Jesús caántdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Páant caántdih ã míic wéhenachah, jwiít ã bohénitboó jeémát jíib chãjadih bejnitji jwĩ jwʉ́ʉb jʉibínap jĩ. Pánih jwʉ́ʉb jʉibínit, Jesús yad wilijĩh ã míic wéhenachah ennit, jwĩ en wʉ́hi bejep jĩ. Pánih en wʉ́hi bejna yʉhna, “¿Dépanih tibeé caántdih ma míic wéhe?” niíj ʉʉ́bh joinít déeji jwĩ niijcáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pánihna, caántboó miíh mah tóhyat wáam dahdih cáag jwejnit, tʉ́tchina mi jwʉ́ʉb aab béj jwʉhʉp jĩ. Pánih bejnit, miíh tʉ́tchidih moondíh nin pah mit niíj naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ded pah wã chãjatjidih weemdíh naóh beedánidih ñi en jʉ̃ʉ́wʉ́. Caán yoobópdih Cristo dée caá, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Páant mi niijíchah joinít, caán tʉ́tchidih moondíh Jesúsdih mi jwãáápjina mit nʉmah jwʉ́ʉb jʉ̃ʉ́wʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pánihna, ĩ jʉyát pínah jã́tih, jwiít Jesús ã bohénitboó jwĩ jíib chãjni jeémátdih caandíh jwĩ nʉmah jeémíhip jĩ. —Bohéní, ma jeémp jʉ̃ʉ́wʉ́, jwĩ niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Obohjeéhtih, ñi jéihca naáh jeémát weemdíh ã jʉmna caá, Jesús jwiítdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—¿Bita caandíh jeémát ĩtát wʉ̃h taniít? jwiítjeh jwĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Páant jwĩ míic niijíchah joinít, Jesús jwiítdih nin pah ã jwʉ́ʉb niijíp jĩ: —Cã́acwã jeémát ĩ bidat pah, weemdíh wahni ded pah ã wʉtatdih chãj péaatdih bʉ́dí wã bidna caá. Pánihna, bʉtéh caandíh jepahnit, caántjĩh míic wéhena, wĩ́ih jeémát panihni ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‘Chénena míic widh ã jʉdhna caá jwĩ momni ã quehechah, jwĩ dicat pínah’, wápchi mínah ã niiját pah, yeébboó ñi niíj jenah joicá bojoó. ‘Dios naáwátdih jwĩ naáwát pínah ã jʉdh jwʉhna caá’, ñi niíj jenah joicá bojoó. Yoobópdih yeebdíh wã naóhna caá. Jáantjeh quehat láa panihni ã jʉmna caá. Bʉʉ láa bácah cã́acwã jwĩ pebhna ĩ jʉyʉ́chah, ñi tʉ́i eneé. Queétboó pácahi ã quehat pah ĩ jʉmna caá. Pánihna, bʉʉ cã́acwãdih wã bohénachah, ĩ joyát láa ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cã́acwãdih wĩ́ih tʉ́ini doonádih jepahat tʉ́ʉtni dicni panihni ã jʉmna caá. Queét jepahnit, caán ã dicni panihnit, Diosjeéh páantjeh ĩ tʉ́i jʉmbipna caá. Pánihna, cã́acwã ĩ tʉ́i jepahachah enna, dicni panihni, momni panihni biícdih bʉ́dí ĩ wẽibipna caá. Páant ĩ weñat ĩ tewatji jíib panihni ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cã́acwã nin pah ĩ niijná caá: ‘Biíc ã jwíih momop be. Biíhboó ã momni ã quehechah ã diquip be’, ĩpĩ́ niijná caá. Momni panihni wĩ́ih tʉ́ini doonádih naóh jwíihni caá. Bita caandíh dicnit panihnit wĩ́ih tʉ́ini doonádih jepahat tʉ́ʉtnit caá. ");
INSERT INTO cbv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Páant ã jʉmat pah, bitaboó cã́acwãdih ĩtát jwíih bohénap tajĩ. Queétdih jwíih bohénit ñi jʉmcah yʉhna, bʉʉ yeebdíh jwʉh wã wahna caá, wĩ́ih tʉ́ini doonádih jwʉ́ʉb joinít ĩ tʉ́i jepahat pínah niijná, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Páant Jesús jwiítdih ã míic wéheat pónih, caánt Samaria baácdih bóli “Ded pah wã chãjatjidih jéih beedánidih mah tóhyop íitdih wã jwãááp be”, mi niijíchah joinít, dawá Samaria baácdih moón Jesúsdih ĩ jepahat pínahdih ĩt jenah joyóp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pánihna, queét jwĩ pebh jʉinít, “jwĩjeéh ma chão jwʉ́hʉʉ́”, Jesúsdih ĩ niijíp jĩ. Páant ĩ niijíchah joinít, chéne yeó jáap ĩjeéh jwĩ jʉm jwʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesúsjeh queétdih ã naáwáchah joinít, dawá caandíh ĩ jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ĩ dée wilidih nin pah ĩ niijíp jĩ: —Ma jwíih naáwáchah joinájeh, jwiítbʉt Jesúsdih jepahíhat jwĩ jenah joyóp be. Bʉʉ caanjéh ã naáwáchah joiná, jwĩ tʉ́i jepahna caá. ‘Nihat nin baácdih moón iiguípna bejnit déejidih yoobópdih tʉ́i ʉbni caá’, jwĩ niíj jéihna caá, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chéne yeó jáap Sicar tʉ́tchidih nʉmah chão jwʉ́hniji, Jesús Galilea baácboó jwiítdih ã nʉmah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“Ded Dios naáwátdih naóh yapanidih ã́ih baácdih moón ĩpĩ́ wẽican caá. Pánihna, Galilea baácdih wã behechah ennitji, weemdíh ĩ tʉ́i jenah joibícan nacaá. Obohjeéhtih, páant ĩ jʉmʉchah yʉhna, caanná jwĩ jwʉ́ʉb bejna caá”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jerusalén tʉ́tchiboó Pascua yeó jáapnadih jwĩ jʉm láa, Jesús ã chãjatjidih ennitji biquína Galilea baácdih moón ĩt jʉmʉp tajĩ. Pánihna, ĩ́ih baácna jwĩ jʉibínachah, queétboó ã wẽp chãjatdih jwʉ́ʉb eníhna, caandíh ĩ tʉ́i wẽi jwãááp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mahdihjeh jiwá iguíh mac Jesús ã tʉ́ʉt nʉʉmníji Caná tʉ́tchidih jwĩ jwʉ́ʉb jʉibínap jĩ. Capernaum tʉ́tchiboó maáh Herodes nʉmp jʉmni maáh wʉ̃ʉ́h wʉnna ãt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pánihna, Jesús Judea baácboó jʉmniji Galilea baácna ã jwʉ́ʉb jʉyát doonádih joinít, jwĩ pebhna ãt aáb jʉ̃ʉ́wʉ́p tajĩ: Pánih aáb jʉinít, nin pah Jesúsdih ã niijíp jĩ: —Wã wʉ̃ʉ́h mʉʉjná beé ã chãjap be. Pánihna, caandíh booaat tʉ́ʉt niijná, wãjeéh waícanjeh ma dei jʉ̃ʉ́wʉ́, ã wẽp niíj ʉʉ́bʉ́p yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Páant ã niijíchah joiná yʉhna, Jesús caandíh nin pah ã niíj jepahap jĩ: —Dios ã wẽpatjĩh wã chãj jʉ́ʉtʉchah encan, ‘Caán Dios ã wahni Cristo caá’, weemdíh ñi niíj jenah joibícan nacaá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Obohjeéhtih, Maá, wã wʉ̃ʉ́h ã wʉnat pínah jã́tih, waícanjeh ma booa wʉ̃h jʉ̃ʉ́wʉ́, Jesúsdih ã niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Páant ã niijíchah yʉhna, —Míih mʉʉná ma jwʉ́ʉb bejeé. Ma wʉ̃ʉ́h ã boona caá, Jesús caandíh ã niijíp jĩ. Páant ã niijíchah joinít, “Ã niiját pah tih wã wʉ̃ʉ́h ã boona nacaá”, niíj jenah joinít, ã́ih mʉʉ́boó ã jwʉ́ʉb bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Páant ã jwʉ́ʉb jʉibínachah, ã pebh moón caandíh ĩt jwãáh naáwáp wʉt jĩ: —Ma wʉ̃ʉ́h jáantjeh ã jwʉ́ʉb boona beé, caandíh ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Deyoób yeó lajachah tibeé caán ã boo? queétdih ãt niíj ʉʉ́bh joyóp wʉt jĩ. —Jwíin yeó jáap tac yoób tʉ́ttimahbit caandíh pahat ã dʉ́ʉcʉp be, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Páant ĩ niijíchah joinít, “Jesús weemdíh ‘Ma wʉ̃ʉ́h ã boona caá’, ã niijíchahjeh, wã wʉ̃ʉ́h ãt boonap taga”, maáhboó ãt niíj jenah joyóp wʉt jĩ. “Jesús weemdíh yoobópdih tigaá ãt niijíp”, niijná, ã déewã biícdih Jesúsdih “Caán Dios ã wahni Cristo yoobát caá”, ĩt niíj jenah joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesús Judea baácdih jʉmniji Galilea baácna jwʉ́ʉb jʉibínit, maáh wʉ̃ʉ́hdih booana, chéne láa jwiít cã́acwã jwĩ jéih chãjca naáhdih Dios ã wẽpatjĩh ã chãj jʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tʉ́ttimah, jwiít judíowã Diosdih jwĩ wẽi láa Jesús Jerusalén tʉ́tchina jwiítdih ã nʉmah jʉibínap jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Caanjĩ́h Ovejawã Bejni Jẽc wʉ̃t jʉmni pebh jẽ́ehat jʉ́á ã jʉmʉp jĩ. Jwiít judíowã jwĩ́ih wéheatjĩh niijná, caán jʉ́ádih Betzata jwĩ niijná caá. Caán Betzata jʉ́á jwẽ́ejdih cinco nemat wihcanni jẽcna ã jʉm pʉ́ʉd bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Caán jʉ́ádih mʉʉ́ wãáp lap nʉmp dawá tʉbʉ́p chʉ̃ʉ́hnit ĩpĩ́ ñaj pʉ́ʉd bejep tajĩ. Jéih encannit, jéih jibcannit, jéih yoocannitbʉt caán jʉ́á pebh ĩt ñajap tajĩ. Caanjĩ́h ñajnit, mah chibít ã dácohatdih pã́i ñajna ĩt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","“Dioíh ángel dei jʉinít, caán jẽ́ehat jʉ́ádih ã dácohanachah ennit, ded jã́tih jwíih bʉʉ́g báahniboó dedé wʉnat jʉmni ãpĩ́ boonap wʉt jĩ”, ĩt niíj jenah joyóp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pánihna, caanjĩ́h jʉmni biíc jéih bejcanni, treinta ocho jópchi tʉbʉ́p chʉ̃ʉ́hni ã ñajap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Caandíh ennit, maatápdih ã tʉbʉ́p chʉ̃ʉ́átdih jéihna, Jesús caandíh nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Meém ma booíh niít? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Wã booíhna yʉh caá. Obohjeéhtih, can jʉ́ána weemdíh ded ʉb báahni pínah ã wihcan caá. Pánihna, dawá láa ã dácohochah, wã bʉʉ́g báah bejíhichah yʉhna, bita wã jã́tih ĩpĩ́ jʉibí bʉʉ́g báahna caá, Jesúsdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Páant ã niijíchah joinít, —Ma ñah ñʉhʉʉ́. Ma ñajatdih ʉbnit, ma yáac chʉ̃i bejeé, Jesús caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Páant ã niijíchahjeh, caán jéih bejcanniji ñah ñʉhnit, ã ñajatjidih ʉbnit, ã yáac chʉ̃i bejep jĩ, bʉca. ");
INSERT INTO cbv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Páant ã boonachah enna, jwĩ chooát yeó jáap ã jʉmʉchah, jwĩ maáta caandíh nin pah ĩt niíj jʉ̃ihñʉp wʉt jĩ: —¿Dépanihna, ma ñajatjidih beo bej tigaá ma chãj? Bʉʉ jwĩ chooát yeó jáap ã jʉmʉchah, ma ñajatjidih ma beo bejechah, ã tʉ́ican caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Obohjeéhtih, ‘Ma ñajatjidih ʉbnit, ma yáac chʉ̃i bejeé’, weemdíh booani ã niijíp be. Páant ã niijíchah joinít, nin wã ñajatjidih ʉb bejna caá wã chãjap, ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Déhe tibeé meemdíh páant niíj, booani? queét ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Obohjeéhtih, Jesús dawá cã́acwã cãtíh ã bejechah, caandíh booanidih ãt beh encap wʉt jĩ. Pánihna, ã wʉ̃tdih jéihcan, ãt jéih jepahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tʉ́ttimah, Dioíh mʉʉ́boó Jesús caandíh jwãáhnit, nin pah ã niijíp jĩ: —Weemdíh ma joi jwʉ́hʉʉ́. Bʉʉ ma tʉ́i jʉmna caá. Pánihna, ma jwʉ́ʉb yéej chãjca bojoó, páant mʉntih. Jwʉ́ʉb yéej chãjna, chah yeejép wʉnat meemdíh ã jʉ̃óhbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Caandíh páant ã niijíchah joinít, Jesúsdih ãt beh enep wʉt jĩ, bʉca. Pánih beh enniji jwĩ maátadih naáwádih ãt bejep jĩ. —Jesús wʉ̃t jʉmni beé weemdíh ãt booanap tabe, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Páant ã niijíchah joinít, Jesús chooát yeó jáapdih ã booaatjidih jéihnit, jwĩ maátaboó caandíh yeejép ĩ chãj jwíihip jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Páant caandíh ĩ mawíhatdih jéihna, Jesús queétdih nin pah ã niijíp jĩ: —Wã íip páantjeh teona caá ã chãjap. Pánihna, weembʉ́t wã teo jwʉhna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesús páant ã niijíchah joinít, jwĩ maátaboó chah ĩ íijip jĩ. Jwĩ chooát yeó jáapdih caán tʉbʉ́p chʉ̃ʉ́hnidih ã booanachah enna, queét ĩ íij jwíihip jĩ. Pánih íijna, “Wã íip”, Diosdih ã niijíchah joiná, chah ĩ yoób íijip jĩ. “‘Wã íip’, niijná, ‘Diosdih biíc yoobó wã jʉmna caá’, Jesús caán míicjeh ã niíj jenah joiná caá”, jwĩ maáta ĩt niíj jenah joyóp tajĩ. Páant niíj jenah joinít, chah íijna, Jesúsdih ĩ yoób mao yohíhip yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Páant ĩ niíj jenah joyátdih jéihnit, Jesús queétdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: “Yoobópdih yeebdíh wã naóhna caá. Weém, Dios wʉ̃ʉ́h, wã jenah joyátjeh wã chãjcan caá. Wã íip weemdíh ded pah ã wʉtʉchah, caandíhjeh wã jepahna caá. Wã íip ded pah ã chãjachah ennit, weém ã wʉ̃ʉ́hbʉt biíc yoobó wãpĩ́ chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wã íip weém ã wʉ̃ʉ́hdih oina, ded pah ã chãjatdih weemdíh ãpĩ́ jéihyana caá. Bʉʉ wã chãjatji chah, biíh wã chãjat pínahdih weemdíh ã jéihyabipna caá. Páant weemdíh ã wʉtatdih joinít, ã wẽpatjĩh yeebdíh wã chãj jʉ́ʉtʉchah, ñi en wʉ́hi bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wã íip ded pah wʉnah bejnitdih ã booaat pah, weembʉ́t ã booaat tʉ́ʉtnitdih biíc yoobó wã booana caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Wã íip cã́acwã ĩ yéej chãjatdih peéh chãjni nihcan caá. Obohjeéhtih, ĩ yéejat jíib wã peéh chãjat pínah niijná, weémboodíh ã wʉtʉp be, nihat cã́acwã caandíh ĩ weñat pah, weemdíhbʉt biíc yoobó ĩ weñat pínah niijná. Wã íip caá weemdíh wahni. Pánihna, ded weém ã wʉ̃ʉ́hdih wẽicanni, wã íipdihbʉt ã wẽican caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Yoobópdih yeebdíh wã naóhna caá. Det wã naáwátdih joinít, weemdíh wahnidih jepahna, páantjeh ãjeéh ĩ tʉ́i jʉmbipna caá. Páant ãjeéh ĩ jʉmʉchah, queétdih wã peéh chãjcan niít. Queét iiguípna bejnit déejidih tʉ́i ʉbnit ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yoobópdih yeebdíh wã naóhna caá. Iiguípna bejnit déeji weém Dios wʉ̃ʉ́hdih bʉʉ jepah jwíihna caá ĩ chãjap. Wã naáwátdih joí jepahnitboó Dios biícdih páantjeh ĩ tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wã íip Dios páantjeh jʉmniboó cã́acwãdih páantjeh ã jʉmat tʉ́ʉtna caá. Pánihna, weém ã wʉ̃ʉ́hdihbʉt páantjeh jʉmat tʉ́ʉtni pínah ã chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Weém nihat cã́acwã ʉ́ʉd jeñé wã jʉmʉchah, cã́acwãdih wã peéh chãjat pínah niijná weémboodíh ã wʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Páant wã naáwáchah joiná, ñi joí wʉ́hi bejca bojoó. Cʉbʉcah nihat wʉnnit ĩ́ih bácah ĩ yohopjiboó jʉmna yʉhna, wã ejechah, ĩ joibípna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pánih joiná, nihat tʉ́i chãjnitji boo pʉd jʉ̃óhnit Dios pebhboó ĩ pʉ́ʉh laab béjbipna caá. Obohjeéhtih, yeejép chãjnitjiboó, ĩ yéej chãjatji jíib iiguípna ĩ bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Weém wĩ́ih jenah joyátjeh, wã weñat pínahdih wã chãjcan caá. Obohjeéhtih, weemdíh wahni ã wʉtatdihjeh wã chãjna caá. Ã niiját pahjeh cã́acwãdih wã peéh chãjbipna caá. Páant wã peéh chãjachah, yoobópdih ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‘Weém Dios wʉ̃ʉ́h, ã wahni caá’, weemjéh wã niijíchah, ‘Ma nih yáana caá’, weemdíh ñita niij tágaá. ");
INSERT INTO cbv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Obohjeéhtih, biíh caá weemdíh naóhni pohba. Caán naóhni Juan Daabáni caá. Pánihna, ‘Ã niijátji yoobópdih ã jʉmna caá’, wã niíj jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yeéb weemdíh jéihíhna, bitaboodíh Juan pebhna ĩ ʉʉ́bh joyát pínah niijná, ñit wahap tabe. Caán yoobópdih yeebdíh ãt naáwáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","‘Nin Dios wʉ̃ʉ́h caá’, weemdíh niijnítdih wã bidcan caá. Pánih bidcan yʉhna, ‘Dios wʉ̃ʉ́h caá’, Juanboó weemdíh ã niiját yoobópdih caá. Pánihna, weemdíh jepahnit, iiguípna ñi bejcat pínah niijná, Juan ã niijátjidih yeebdíh wã náhniana caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tʉ́i enat tʉ́ʉt niijná, jiiát dahdih jwĩ jií cáagat pah, Juan ded pah wã jʉmatdih ñi jéihyat pínah niijná, yeebdíh ãt naáwáp tajĩ. Páant ã naáwáchah joiná, daocánni yeó jáap ñi tʉ́i wẽi joi jwʉ́hʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Obohjeéhtih, wã íip weemdíh ã wʉtʉchah, ã wẽpatjĩh wã chãjachah ennit, yoobópdih Dios ã wahni wã jʉmatdih ñita tʉ́i jéih tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Juan weemdíh ã daabánachah, wã íipjehbʉt weemdíh wahni ‘Caán wã wʉ̃ʉ́h caá’, ã niijíp jĩ. Páant ã niijíchah yʉhna, yeébboó caandíh encan, joicánnitbʉt ñi jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Weém Dios ã wahnidih jepahcan, wã íip ã naáwátdihbʉt ñi náahcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","‘Dios naáwát tólihdih bohéna, yeó jáap jʉmat pah Diosjeéh jwĩ tʉ́i jʉmbipna caá’, ñi niíj jenah joiná caá.Obohjeéhtih, caán tólihjeh tigaá weém ded pah wã jʉmatdih ã naáwáp. ");
INSERT INTO cbv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Caán tólih weemdíh ã naáwáchah yʉhna, yeébboó weemdíh ñi náahcan caá. Yeó jáap jʉmat pah Diosjeéh jʉmíhna yʉhna, weemdíh páant ñi ʉʉ́bhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Weemdíh wẽi naóhnitdih wã bidcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Obohjeéhtih, yeébboó mácah ñi jenah joyátdih wã tʉ́i jéihna caá. Pánih jenah joinít, Diosdih ñi oicatdihbʉt wã jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wã íip weemdíh ã wʉtat pah wã chãjachah yʉhna, weemdíh ñi náahcan caá. Obohjeéhtih, ã wahcanniboó ã weñat pínahdihjeh ã chãj jʉ́ʉtʉchah ennit, caánboodíh ñi náahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bita yeebdíh ĩ wẽi naáwátdihjeh bidna yʉhna, Diosboó yeebdíh ã wẽi naáwátdih ñi náahcan caá. Pánih náahcan, ‘Caán Dios ã wahni Cristo nihcan caá’, niíj jenah joiná, weemdíhbʉt ñi joííhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Páant weemdíh ñi joííhcatji jíib ‘Jwĩ íipdih Jesús jwiítdih ã naóh yacbipna caá’, ñi niíj jenah joicá bojoó. ‘Moisés ã wʉtatjidih jwĩ jepahna, Dios pebhboó jwĩ bejbipna caá’, ñi niíj jenah joiná yʉh caá. Obohjeéhtih, ded pah Moisés weemdíh ã naáwátjidih ñi joyáh bojat jíib, Dios yeebdíh ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés weemdíhjeh ãt naóh daacáp tajĩ. Pánihna, caán ã daacátjidih ‘Yoobópdih tigaá’, niijná, wã naáwátdihbʉt ‘Yoobópdih tigaá’, ñita niíj jenah joi tágaá. ");
INSERT INTO cbv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Obohjeéhtih, Moisés ã daacátjidih ‘Yoobópdih tigaá’, niijcán, wã naáwátdihbʉt ‘Yoobópdih tigaá’, ñi niijcán niít”, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tʉ́ttimah, Galilea íimdih conanaáboó Jesús jwiítdih ã nʉmah chʉ́ʉh bejep jĩ. Caán íimjeh mʉntih Tiberias íim ã wʉ̃t jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jesús ã booanachah ennitji dawá cã́acwã ĩt ñʉʉ́n péenap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pánih chʉ́ʉh jʉibínitji, aab béjnit, jeená pʉ́ʉh laab jʉibínit, jwiít ã bohénitdih ã nʉmah chʉ́ʉdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Caán láa Pascua yeó jáapna pínah bahnijeh ã jʉdhdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Caanná jʉibí chʉ́ʉdna, Jesús dawá cã́acwã jwĩ pebhna ĩ jʉ̃ʉ́wʉ́chah, ã enep jĩ. Pánih ennit, Felipedih nin pah ã niíj ʉʉ́bh joyóp jĩ: —Dawá cã́acwã jwĩ pebhna ĩ jʉ̃óh jígohna caá. ¿Deh tigaá ĩ jeémát pínahdih jwĩ jíib chãjbi? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","“Ded pah caá Felipe ã niíj jepahbi”, niijná, Jesús caanjéh ã chãjat pínahdih jéihna yʉhna, Felipedih páant ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Páant ã niíj ʉʉ́bh joyóchah joinít, Felipeboó nin pah ã niíj jepahap jĩ: —Ocho widh tewat jíibjĩh jeémátdih jwĩ jíib chãjachah yʉhna, queétdih ãta jʉibícan tagaá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jwiít biícdih jʉmni Simón Pedro ʉ́ʉdboó, Andrés wʉ̃t jʉmni, Jesúsdih nin pah ã niijíp jĩ: ");
INSERT INTO cbv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Cinco pan dah, chéne queejwã́dih nin wébít ã bíbohna caá. Obohjeéhtih, páant bóobitjeh ã jʉmʉchah, queét páant moón dawá cã́acwãdih ã jʉibícan niít, Andrés ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Queétdih ñi chʉ́ʉdat tʉ́ʉtʉ́, Jesús jwiítdih ã niijíp jĩ. Caanjĩ́h tʉ́ini yílip ã jʉmʉp jĩ. Pánihna, jwĩ chʉ́ʉdat tʉ́ʉtʉchah, yílip jʉmʉpdih cã́acwã ĩ tʉ́i chʉ́ʉd beedép jĩ. Cinco mil neonájeh ĩ jʉmʉp jĩ. Yaádh, ĩ weh biícdih chah ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Páant ĩ chʉ́ʉd beedéchah ennit, Jesús pan dahnadih ʉbnit, “Tʉ́ina caá, Paá”, Diosdih ã niijíp jĩ. Páant niíj péanit, jwiít ã bohénitdih queét chʉ́ʉdnitdih pan, queejdíhbʉt ã pãáát tʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Páant jwĩ pãááchah, jeémpnit, cã́acwãboó ĩ tʉ́i wʉd jʉmʉp jĩ. Páant ĩ wʉd jʉmʉchah ennit, Jesús jwiítdih nin pah ã niíj wʉtʉp jĩ: —Ĩ jʉdh jeémpnidih ñi tʉ́i ʉbʉʉ́, ĩ yoh peétcat pínah niijná, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Páant ã niijíchah joinít, cinco pan dahnaji, chéne queejwã́jidihbʉt ĩ jʉdh jeémpnidih jwĩ ʉb yacachah, doce wʉhna pohba ã yáwap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pánihna, jwiít cã́acwã jwĩ jéih chãjca naáhdih Jesús ã chãjachah enna, cã́acwã nin pah ĩ míic niijíp jĩ: —Yoobópdih tigaá. Nin Dios naáwátdih naóh yapani, nin baácboó jʉ̃óhni pínahdih jwĩpĩ́ pã́ini caá, queét ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Páant míic niijnít, queét Jesúsdih maáh pínah ĩ waadáíhip yʉh jĩ. Obohjeéhtih, queét páant ĩ niíj jenah joyátdih jéihnit, biícjeh jeená pʉ́ʉh laab béjnit, Jesús ã bejah bojop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Páant ã pʉ́ʉh laab béjat tʉ́ttimah, tõo ñáh jʉ̃ʉ́wʉ́chah ennit, jwiít ã bohénit íimboó jwĩ dei bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Caanná jʉibí, jãáj chóodih waadnít, Capernaum tʉ́tchina chʉ́ʉh bejat tʉ́ʉt jwĩ chãjap jĩ. Obohjeéhtih, Jesúsboó jwĩ pebhna ã jʉicáp jĩ. Páant ã jígohcah, caandíh pã́i chʉʉnít, jwĩ chʉ́ʉh bejep jĩ. Páant jwĩ chʉ́ʉh bejechah, ã tʉb tõoáh bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Páant ã tõoáh bejat tʉ́ttimah, johlit bʉ́dí ã jʉ̃ʉ́wʉ́chah, bʉ́dí nolihatbʉt ã ñahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pánihna, caán íim tac yoób jwĩ bejechah pohba, Jesús íimjih jwĩ pebhna ã yáac chʉ̃i jʉ̃ʉ́wʉ́chah, jwĩ enep jĩ. Páant ã jʉ̃ʉ́wʉ́chah ennit, bʉ́dí jwĩ ʉ́ʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Páant jwĩ ʉ́ʉmʉchah ennit, caán jwiítdih nin pah ã niijíp jĩ: —¡Ñi en ʉ́ʉmca bojoó! ¡Weemjéh tigaá! ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Páant ã niijíchah joinít, bʉ́dí wẽinit, caandíh jãáj chóona jwĩ waadát tʉ́ʉtʉp jĩ. Páant ã waadát tʉ́ttimah, waícanjeh jwĩ jenah joi béjepna jwĩ chʉ́ʉh jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Cheibit bóo yeó jáapdih Jesús Diosdih “Tʉ́ina caá, Paá”, niijnít, queétdih jeémát ã wʉ̃hʉpjiboó dawá cã́acwã pã́ina ĩtih chãjap wʉt yʉh jĩ. Jwĩ jwʉ́ʉb chʉ́ʉh jʉ̃ʉ́wʉ́chah, Jesús jwĩjeéh ã waadcátdihbʉt ĩ enep jĩ. Caandíh páantjeh pã́i jwʉhna ĩt chãjap wʉt yʉh jĩ. Tiberias tʉ́tchiboó jʉmniji jãáj chóona ĩ jʉmʉpboó ãt jʉibínap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pánihna, Jesús ã wihcatdih ennit, queét caandíh bidna, caán jãáj chóonadih waadnít, Capernaum tʉ́tchina chʉ́ʉh jʉ̃óhnit, jwiítdih ĩ ñʉʉ́n jʉyʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pánih ñʉʉ́n chʉ́ʉh jʉinítji, Jesúsdih jwãáhnit, caandíh nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —¿Bohéní, débólih tibeé ninboó ma jʉ̃óh? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Páant ĩ niíj ʉʉ́bh joyóchah joinít, queétdih Jesús nin pah ã niíj jepahap jĩ: —Yoobópdih yeebdíh wã naóhna caá. Dios bʉ́dí ã wẽpatjĩh yeebdíh wã teo wáacachah yʉhna, ‘Caán Dios ã wahni Cristo caá’, weemdíh ñi niíj jenah joicán beé. Páant niíj jenah joicán yʉhna, jwʉ́ʉb jeémp, wʉd jʉmatdihjeh ñit bid jʉ̃óh tagaá, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Obohjeéhtih, yoobópdih yeebdíh wã naóhna caá. Nin baácdih bóo jeémát moopáh bejnijeh caá. Pánihna, caán déenadih jíib chãjíhcan, teocat caá náahap. Obohjeéhtih, Diosjeéh tʉ́i jʉmat tʉ́ʉtni jeémát panihniboodíh bidat caá náahap. Weém nihat cã́acwã ʉ́ʉd jeñé caán jeémát panihnidih wã wʉ̃hna caá. Wã íip weemdíh páant ã wʉ̃hat tʉ́ʉtʉp be. Páant wã jʉmatdih yeéb ñi jéihyat pínah niijná, Dios ã wẽpatjĩh weemdíh ã chãj jʉ́ʉtat tʉ́ʉtʉchah, yeéb ñi enep be, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Páant ã niijíchah joiná yʉhna, queét caandíh nin pah ĩ jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ: —¿Ded pah tigaá jwĩ chãjbi, Dios ã náahatdih chãjat tʉ́ʉt niijná? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Nindih Dios yeebdíh ã chãjat tʉ́ʉtna caá: ‘Wã wahnidih tʉ́i jenah joinít, ñi jepahaá’, yeebdíh ã niíj wʉtʉp be, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—Meém Dios ã wahni yoobát jʉmna, ã wẽpatjĩh ma chãj jʉ́ʉt en tigaá bácah, meemdíh jwĩ jepahat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jwĩ nʉowãji jon jã́tih tʉ́tchi wihcapboó maná ĩ niijníjidih ĩt jeémép wʉt jĩ. Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Jeámant queétdih jeémátdih ãt wʉ̃hʉp wʉt jĩ, ĩ tʉ́i jeémát pínah niijná’, ãt niíj daacáp tajĩ. ¿Páant ã chãjatji chah meémboó mata jéih chãj taniít? caandíh ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Yoobópdih yeebdíh wã naóhna caá. Moisésjeh pohba queétdih japmant jʉ̃óhni jeémátdih ã wʉ̃hcap jĩ. Wã íip jeémát yoobát panihnidih jeámant cã́acwãdih ãpĩ́ wʉ̃hna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pánihna, Dios ã wʉ̃hni jeémát panihni japmant dei jʉ̃óhnit, nihat baácdih moondíh ã báadhdat tʉ́ʉtna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Maá, yeó jáap jʉmat pah ma niijní jeémátdih jwiítdih ma wʉ̃hʉʉ́, queét ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Weem tígaá báadhdat tʉ́ʉtni jeémát panihni caá. Det weemdíh tʉ́i péenitboodíh jwʉ́ʉb nʉʉgʉ́p wʉnat panihat ã wihcan niít. Det weemdíh náhninit, wẽi jenah joinítboodíh taca jootát panihatbʉt ã wihcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Obohjeéhtih, yeebdíh jã́tih naóhna, yoobópdih naóhna beé wã chãjap be. Yeébboó weemdíh enna yʉhna, ‘Caán Dios ã wahni Cristo caá’, ñi niíj jenah joicán caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nihat wã íip ã jepahat tʉ́ʉtnitjeh weemdíh ĩ péebipna caá. Weemdíh pánih péenitdih wã yohcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Japmant jʉ̃óhna, wã náahatdihjeh chãjcan, weemdíh wahni ded pah ã weñat pínahboodíh chãjadih wã jʉ̃ʉ́wʉ́p be. ");
INSERT INTO cbv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nin caá weemdíh wahni ã weñat pínah yoobát: Nihat weemdíh ã jepahat tʉ́ʉtnitdih bʉʉdácan, weemdíh caán péeni yeó jáapdih queétdih wã jwʉ́ʉb booaat pínahdih ã náah yacna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nihat weém ã wʉ̃ʉ́hdih jepahnit, páantjeh ãjeéh ĩ jʉmat pínahdih wã íip, weemdíh wahni, ã náah yacna caá. Pánihna, péeni yeó jáapdih queétdih wã jwʉ́ʉb booabipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Weém japmant jʉ̃óhni jeémát panihni tigaá wã jʉmʉp”, Jesús ã niijíchah joinít, jwĩ maátaboó caandíh íijnit, tʉbit ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Nin Jesús José wʉ̃ʉ́h nihcan niít? Ã íip, ã íindihbʉt jwiít jwĩ jéihna caá. Pánihna, jwiít panihnijeh mʉn tigaá. Pánihni jʉmna yʉhna, ¿dépanihna “Japmant jʉ̃óhni wã jʉmna caá”, ã niíj? ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Queét páant ĩ míic niijíchah joinít, Jesús queétdih nin pah ã jwʉ́ʉb niíj jepahap jĩ: —Weemdíh yeejép ñi niijcá bojoó. ");
INSERT INTO cbv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Det ĩ jenah joyátjĩhjeh weemdíh ĩ jéih jepahcan niít. Obohjeéhtih, wã íip, weemdíh wahniboó, ‘Caán Dios ã wahni Cristo yoobát caá’, queétdih ã niíj jenah joyát tʉ́ʉtna caá, wãjeéh ĩ péeat pínah niijná. Páant ã chãjcah, det wĩ́ihwã pínah ĩta jéih jʉmcan tagaá. Pánihna, péeni yeó jáapdih weemdíh jepahnitjidih wã jwʉ́ʉb booabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios naáwátdih naóh yapanitboó nin pah ĩt niíj daacáp tajĩ. ‘Dios queét nihatdih ã bohébipna caá’, ĩt niíj daacáp tajĩ.Pánihna, nihat wã íip ã bohéátdih joinít, weemdíhbʉt ĩ jepahbipna caá. Pánih jepahnit wĩ́ihwã ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Wã íipdih ded ã encan caá. Weém ã wahnijeh caandíh wã enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yoobópdih yeebdíh wã naóhna caá. Det weemdíh jepahnit páantjeh wã íipjeéh ĩ tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Weém báadhdani jeémát panihni wã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ñi nʉowãji tʉ́tchi wihcapboó manádih jeémpna yʉhna, ĩt wʉnʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Obohjeéhtih, japmant jʉ̃óhni wã niijní jeémát panihnidih ded jeémpna, iiguípna ã bejcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Weém japmant jʉ̃óhni báadhdani jeémát panihni wã jʉmna caá. Caán jeémát panihnidih jeémpnitjeh wã íipjeéh páantjeh ĩ jʉmbipna caá. Caán báadhdani jeémát panihni wĩ́ih bácah ã jʉmna caá. Pánihna, wĩ́ih bácahdih wã wʉ̃hbipna caá, nihat baácdih moón wã íipjeéh ĩ tʉ́i jʉmat pínah niijná. Pánih wʉ̃hna, nihat cã́acwãdih wã wʉn wʉ̃hbipna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Páant ã niijíchah joinít, jwĩ maátaboó, queétjeh nin pah ĩ niíj míic wéhenap jĩ: —¿Nin dépanih tigaá ã́ih bácahdih jeémát pínah panihni ã wʉ̃hbi? ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Páant ĩ niijíchah joinít, Jesús nin pah queétdih ã niijíp jĩ: —Yoobópdih yeebdíh wã naóhna caá. Weém nihat cã́acwã ʉ́ʉd jeñé wã jʉmʉchah, ded wĩ́ih bácah panihnidih jeémpcanni, wĩ́ih meép panihnidih babhcanni wã íip pebhboó ã bejcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ded wĩ́ih bácah panihnidih jeémpni, wĩ́ih meép panihnidih babhnidih péeni yeó jáapdih wã jwʉ́ʉb booabipna caá. Caánboó wã íipjeéh páantjeh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wĩ́ih bácah ñi jeémát yoobát panihni, wĩ́ih meépbʉt ñi babhbat yoobát panihni ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Det wĩ́ih bácah panihnidih jeémpnit, wĩ́ih meép panihnidihbʉt babhnit, weém biícdih ĩ tʉ́i jʉmbipna caá. Weembʉ́t queét biícdih wã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wã íip páantjeh jʉmni weemdíh wahna, weemdíhbʉt páantjeh jʉmni ã jʉmat tʉ́ʉtna caá. Páant ã chãjat dée, jeémátdih ñi bidat pah, ded weém páantjeh jʉmnidih bʉ́dí bidna, caandíh wã íipjeéh páantjeh jʉmni wã jʉmat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bʉtéh yeebdíh wã naóhni jeémát panihni Dios pebhmant dei jʉ̃óhni caá. Caán jeémát panihni jwĩ nʉowãji ĩ jeémpni maná panihni nihcan caá. Queétboó caán jeémátdih jeémpnitji ĩt wʉnʉp wʉt jĩ. Obohjeéhtih, bʉtéh wã naóhni jeémát panihniboodíh ded jeémpni wã íipjeéh páantjeh ã jʉmbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum tʉ́tchidih moón ĩ míic wáacat mʉʉ́boó Jesús queétdih páant ã niíj naóh bohénap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dawá jwĩjeéh péenit Jesús ã bohéátdih joinít, nin pah ĩ niíj wéhenap jĩ: —Jesús nin ã bohéát bʉoni yoobát ã jʉmʉchah, caandíh jwĩ joííhcan caá, queétjeh ĩt míic niijíp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Páant ĩ míic wéheatdih jéihnit, Jesúsboó queétdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Nin wã bohéátdih joiná, ñi íij niít? ");
INSERT INTO cbv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Weém, nihat cã́acwã ʉ́ʉd jeñé, jã́tih wã jʉmʉpjiboó wã jwʉ́ʉb pʉ́ʉh laab béjechah enna, ¿ded pah ñita niíj jenah joí? ¿Caandíhbʉt ñita íij taniít? ");
INSERT INTO cbv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dios ã wahni Tʉ́ini Espíritu cã́acwãíh caolihdih ã booana caá. Cã́acwãjeh ĩ́ih caolihdih ĩ jéih booacan caá. Pánihna, wã naáwátdih ñi tʉ́i jenah joyóchah, Tʉ́ini Espírituboó ñíih caolihdih ã booabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Obohjeéhtih, páant ã jʉmʉchah yʉhna, ‘Caán Dios ã wahni Cristo nihcan caá’, biquína ñi niíj jenah joiná caá, Jesús ã niijíp jĩ. Jesús páant niíj jenah joinítdih jã́tih ãtát jéihyep tajĩ. Pánihna, caandíh eníhcannitdih dʉó wáini pínahdihbʉt ãtát jéihyep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Páant niíj naóh péanit, nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Nin pah yeebdíh wã niíj naáwáp yʉh be: ‘Wã íipboó cã́acwãdih weemdíh ã jepahat tʉ́ʉtcah, det wĩ́ihwã pínah ĩta jéih jʉmcan tagaá’, wã niijíp be, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Páant ã niijíchah joiná, dawá jwĩjeéh péenitji Jesúsdih wẽican, ĩ cádahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Páant ĩ cádahachah ennit, Jesús jwiít docewã ã bohénitboodíh nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Yeebbʉ́t weemdíh ñi cádahmi naniít? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Páant ã niíj ʉʉ́bh joyóchah joinít, Simón Pedro nin pah ã niíj jepahap jĩ: —Obohjeéhtih, Maá, jwiítdih biíh bohéni ã wihcan caá. Diosjeéh páantjeh jwĩ jʉmat pínah niijná, ma naáwátjeh jwiítdih ã tʉ́i jéihyana caá. ");
INSERT INTO cbv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pánihna, jwiítboó meemdíh jepahnit, ‘Meém tʉ́ini, Dios wʉ̃ʉ́h, ã wahni caá’, jwĩ niíj jéihna caá. Pánih jéihnit, meemdíh jwĩ cádahcan niít, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Páant ã niijíchah joinít, Jesús jwiítdih nin pah ã niijíp jĩ: —Weém yeéb docewãdih wã ñíwip yʉh jĩ. Obohjeéhtih, biíc ñijeéh jʉmni nemépíh pínah ã jʉmna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Páant niijná, Judas, Simón Iscariote wʉ̃ʉ́hdih niijná ãt chãjap tajĩ. Judas jwiít Jesús ã bohénitjeéh jʉmna yʉhna, Jesúsdih eníhcannitdih dʉó wáini pínah ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tʉ́ttimah, Jesús Galilea baácboó jwiítdih nʉmah jibidih ã bejep jĩ. Judea baácdih moón jwĩ maáta caandíh ĩ mao yohíhatdih jéihna, Judea baácboó ã bejíh jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jwiít judíowã wãpchí dahna jwĩ chãjatjidih náhniat yeó jáapna, bahni ã jʉdhdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pánihna, Jesúsdih ã ʉ́ʉdwã nin pah ĩ niijíp yʉh jĩ: —Ninjĩh chãocánjeh, Judea baácna bejnit, meemdíh péeíhnitdih ma wẽpatjĩh ma chãj jʉ́ʉtʉ́. ");
INSERT INTO cbv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ded ã wẽpatdih jʉ́ʉtíhna, bih jʉ́ʉtcat caá náahap. Pánihna, yoobópdih wẽpni jʉmna, jwĩ míic wáac jʉibíni tʉ́tchiboó ma wẽpatdih jwĩjeéh ma jʉ́ʉt jʉ̃ʉ́wʉ́, Jeñé, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Queét ã ʉ́ʉdwãjeh yʉhna, ‘Caán Dios wʉ̃ʉ́h caá’, Jesúsdih ĩ niíj jenah joicáp jĩ. Páant niíj jenah joicán, caandíh páant ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Páant ĩ niijíchah joinít, Jesús queétdih nin pah ã niíj naáwáp jĩ: —Wã wẽpatdih cã́acwãdih jʉ́ʉtat pínah ã jʉdh jwʉhʉchah, wã bejcan caá. Yeébboó fiestadih eníhna, caán tʉ́tchina ñi enbi jwʉhʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cã́acwã yeebdíh ĩ íijcan caá. Obohjeéhtih, ĩ yéej chãjatdih wã naáwáchah joinít, weémboodíh ĩ íijna caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pánihna, caán fiesta yeó jáapna ã jʉmʉchah, yeebjéh ñi enbi jwʉhʉʉ́. Weém caanná wã bejat pínah ã jʉdh jwʉhna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Páant niijnít, Galilea baácboó jwiítdih ã nʉmah chãwáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Obohjeéhtih, ã ʉ́ʉdwã ĩ bejat tʉ́ttimah, Jesúsbʉt Jerusalén tʉ́tchina jwiítdih ã nʉmah bejep jĩ. Pánih bejna, cã́acwã ĩ encapmantbit jwĩ bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiesta yeó jáapdih míic wáac jʉibínit, jwĩ maáta Jesúsdih bʉ́dí ĩt bidip wʉt yʉh jĩ. —¿Dee tígaá ã jʉm? ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pánihna, cã́acwãbʉt caandíh bʉ́dí jenah joinít, ĩt míic wéhenap wʉt jĩ. “Caán tʉ́ini caá”, biquína niíj, “Caán yeejép caá. Cã́acwãdih yee naóhni caá”, bitaboó ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Páant niijná yʉhna, jwĩ maátadih ʉ́ʉmna, Jesús ded pah ã jʉmatdih queétjeh ĩt míic wéhenap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ĩ weñat yeó jáapna tac yoób Jesús Dioíh mʉʉná waád jʉibínit, cã́acwãdih ã bohénap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Páant ã bohénachah, jwĩ maáta joí wʉ́hi bejnit, nin pah queétjeh ĩ míic niijíp jĩ: —¿Nin bohécanni yʉhna, dépanih tigaá bohéátdih ã tʉ́i jéih? ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Páant ĩ niijíchah joinít, Jesús queétdih nin pah ã niíj naáwáp jĩ: —Wã bohéát weemjéh wã naáwát nihcan caá. Obohjeéhtih, weemdíh wahni ã naáwát tʉ́ʉtat caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ded Dios ã weñat pínahdih chãjíhni ‘Páant ã bohénachah, ã jéihyatjeh nihcan caá. Yoobópdih Dios naáwát caá’, ã niíj jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ded ã jenah joyátjeh naóhna, cã́acwã caandíh ĩ weñat pínahdih bidna caá ã chãjap. Obohjeéhtih, weemdíh wahniboó weemdíh ã naóh yapaat tʉ́ʉtna caá. Pánih naóh yapana, caandíhjeh ñi weñat pínahdih yeebdíh wã náah yacna caá. Páant wã naóh yapanachah joiná, ‘Yeecanjeh, yoobópdih ã naóhna caá’, ñi niíj jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moisésji ded pah Dios yeebdíh ã wʉtatdih ãt jwʉ́ʉb naóh yapanap wʉt jĩ. Obohjeéhtih, biíc ñijeéh jʉmni caán ã wʉtatjidih jepahni wihcan caá. Pánihna, ¿dedé wã chãjatji jíib tigaá weemdíh ñi mao yohíh?” jwĩ maátadih ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Meemdíh nemép ã jʉmna caá. ¿Déhe tigaá meemdíh mao yohíhnit ĩ jʉm, páant ma niijíchah? queét dawá caandíh ĩ niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Biíc láa jwĩ chooát yeó jáapdih yeéb cã́acwã ñi jéih chãjca naáhdih weémboó yeebdíh wã chãj jʉ́ʉtʉp be. Páant wã chãj jʉ́ʉtʉchah ennit, bʉ́dí ñi en wʉ́hi bejep be. ");
INSERT INTO cbv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Jon jã́tih Moisésji nihat neoná weépdih quehli nah yapat chóodih ãt bóodat tʉ́ʉtʉp wʉt jĩ. Pánihna, nihat neoná weép ñi weh jʉmna, ocho yeó jáap tʉ́ttimah chooát yeó jáapdih yʉhna, ã wʉtatji pahjeh ñipĩ́ bóodna caá.Obohjeéhtih, Moisés ã wʉtatji pohba ãt nihcap wʉt jĩ. Jwĩ nʉo Abrahamjidih Dios páant bóodat pínahdih ãt jwíih wʉtʉp wʉt jĩ.Pánihna, caán tʉ́ttimah, jwĩ nʉowã páant ĩpĩ́ chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chooát yeó jáapdih yʉhna, Moisés ã wʉtatjidih yap yohíhcan, yeebbʉ́t ñi wehdih ñipĩ́ bóodat tʉ́ʉtna caá. Páant ñi chãjna yʉhna, ¿dépanihna, chooát yeó jáapdih weémboó wʉnnidih wã booanachah enna, ñipĩ́ íij? ");
INSERT INTO cbv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ded pah wã chãjatdih tʉ́i jéihcan, ‘Caán yeejép ã chãjna caá’, ñi niijcá bojoó. Obohjeéhtih, ded pah wã chãjatdih jéihna, weemdíh yoobópdih ñi jenah joyoó, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Páant ã niijíchah joinít, biquína Jerusalén tʉ́tchidih moón nin pah ĩ míic niíj ʉʉ́bh joyóp jĩ: —¿Nin jwĩ maáta ĩ mao yohíhni nihcanna niít? ");
INSERT INTO cbv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wãát en tih. Páantjeh jwĩ cãtíh bohéna caá ã chãjap. Páant ã bohénachah yʉhna, jwĩ maáta ded pah ĩ niijcán caá. ‘Cristo, Dios ã wahni caá’, queét ĩ niijjéhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Obohjeéhtih, Dios ã wahni Cristo dedmant ã jʉ̃ʉ́wátjidih ded ã jéihcan niít. Nin Jesús ã jʉmni tʉ́tchidih jwiít jwĩ jéihna caá. Pánihna, Dios ã wahni Cristo nihcanna caá, queét ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús Dioíh mʉʉ́ diítboó queétdih bohénajeh, páant ĩ míic niijíchah jéihnit, nin pah ã jwʉ́ʉb niíj ñaacáp jĩ: —Yeebjéh pohba ‘Caandíh jéihna, ã jʉmni tʉ́tchidihbʉt jwĩ tʉ́i jéihna caá’, ñi niíj jenah joiná yʉh caá. Obohjeéhtih, wã jenah joyátjĩhjeh ninboó jʉ̃óhna wã chãjcan jĩí. Wã íip jĩí weemdíh ã wahap jĩ. Pánih wahni yeecanni, yoobópdih chãjni caá ã jʉmʉp. Caandíh ñi jéihcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Obohjeéhtih, weémboó ã pebhmant jʉ̃óhniji caandíh wã tʉ́i jéihna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Páant ã niijíchah joinít, jwĩ maáta caandíh ĩ tewíhip yʉh jĩ. Obohjeéhtih, caandíh ĩ mao yohat pínahdih Dios ã jenah joyát ã jʉdh jwʉhʉchah, caandíh ĩ jéih teo jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pánihna, dawá Jesúsdih tʉ́i jenah joiná, nin pah ĩ míic niijíp jĩ: —Nin Jesús jwiít cã́acwã jwĩ jéih chãjca naáhdih dawá láa ã chãj jʉ́ʉtʉp be. Dios ã wahni pínah Cristoboó ¿caan cháh ãta chãj taniít? ¿Páant tih jʉ̃ʉ́h? ¿Pánih chãjna, caanjéh Dios ã wahni Cristo nihcan niít? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Páant ĩ niíj wéhenachah joinít, fariseowã, sacerdotewã ĩ maáta biícdih Dioíh mʉʉdíh wapnit soldadowãdih Jesúsdih ĩ tewat pínah niijná, ĩt wahap wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús queét cã́acwãdih nin pah ã jwʉ́ʉb niijíp jĩ: —Daocánni yeó jáap ñijeéh wã jʉm jwʉhbipna caá. Weemdíh wahni pebhboó wã jwʉ́ʉb bejat pínah bahnijeh ã jʉdhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wã jʉmat pínah pebhboó yeéb ñi jéih bejcan niít. Weemdíh bidna yʉhna, ñi jéih bid jʉibícan nacaá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Páant ã niijíchah joinít, queétjeh nin pah ĩ míic niíj ʉʉ́bh joyóp jĩ: —Nin páant niijná, ¿dedboó bejat tʉ́ʉt tigaá ã chãj? yeéb ñi jenah joyóchah. ¿Jwĩ déewã ĩ bej peétni baácnaboó bejnit, jwĩ déewã nihcannitdih ã bohémi naniít? ");
INSERT INTO cbv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Yeéb weemdíh bidna yʉhna, ñi jéih jwãáhcan niít’, niijná, ‘Wã bejat pínah pebhboó ñi jéih bejcan niít’, niijná, ¿ded pah niij tígaá páant ã niíj? ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta péeni yeó jáap, chah jwĩ weñat yeó jáap yoobát ã jʉmʉchah, Jesús caanjĩ́h ñʉhnit, tʉbit ã ñaác niíj naáwáp jĩ: —Ded taca joótni wã pebh ã jʉ̃ʉ́wʉ́ naáh. Ã jʉyʉ́chah, tʉ́i báadhdani mahdih caandíh wã wʉ̃hbipna caá. Wã wʉ̃hni pínah mah panihnidih babhna, Diosjeéh ã tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ded weemdíh jepahni pínahdih Dios naáwátdih naóh yapanit nin pah ĩt niíj daacáp tajĩ: ‘Ded weemdíh jepahna, ã́ih caolihmant mʉj nooj bácat panihni ã jʉmʉchah, wẽinit wĩ́ih tʉ́ini doonádih bitadih ã wẽp naóhbipna caá’, ĩt niíj daacáp tajĩ, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Páant niijná, Jesúsdih jepahnitdih Tʉ́ini Espíritu jʉmna, ded pah ã teo wáacat pínahdih naóhna ã chãjap jĩ. Obohjeéhtih, Jesús jeáboó ã jwʉ́ʉb aab béj jwʉhcah, Tʉ́ini Espíritu ã dei jʉ̃óh jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Páant Jesús ã niijíchah joinít, dawá cã́acwã nin pah ĩt míic niíj wéhenap wʉt jĩ: —Nin yoobópdih Dios naáwátdih naóh yapani jwĩpĩ́ pã́ini caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","—Nin Cristo jwiítdih tʉ́i ʉbni nacaá, bita ĩt niijíp wʉt jĩ. Obohjeéhtih, bitaboó nin pah ĩt míic niijíp wʉt jĩ: —Cristo jʉ̃óhna, Galilea baácboó ãta jʉmcan tagaá. Nin Jesús caanjĩ́h bóo tigaá. ");
INSERT INTO cbv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ. ‘Cristo David jʉima yoobát ã jʉmbipna caá. Pánihna, David ã cã́ac jʉmni Belén tʉ́tchiboó ã cã́ac jʉmbipna caá’, ãt niíj daacáp tajĩ. Pánihna, Jesús Belén tʉ́tchidih bóo nihcan, Dios ã wahni yoobát nihcan caá, queétjeh ĩt míic niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pánihna, queét Jesúsdih biíc yoobó ĩt jenah joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Biquína Jesúsdih ĩt teo nemíhip wʉt yʉh jĩ. Obohjeéhtih, ĩ jéih teocap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sacerdotewã ĩ maáta, fariseowã biícdih Jesúsdih ĩ tewat tʉ́ʉtnit soldadowã Jesús pebh jʉinítji, queétdih wahnit pebhboó ĩt jwʉ́ʉb bejep wʉt jĩ. Ĩ pebhna ĩ jwʉ́ʉb jʉibínachah, soldadowãdih queét nin pah ĩt niijíp wʉt jĩ: —¿Dépanih tibeé Jesúsdih ñi teocan? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Caán yoobópdih naóhni beé. Biíh caan pánih wẽp naóhni ã wihcan caá, queét soldadowã ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Páant ĩ niíj jepahachah joinít, fariseowãboó nin pah ĩt niijíp wʉt jĩ: —¿Yeebdíh caán ã yeenachah, ‘Yoobópdih tigaá’, ñi niijnít beé? ");
INSERT INTO cbv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Det jwĩ maáta Jesúsdih jepahcan, caandíh ĩ náahcan caá. Pánihna, jwiítbʉt caandíh jwĩ náahcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Obohjeéhtih, queét caandíh jepahnitboó Moisés ã wʉtatjidih ĩ jéihcan caá. Caandíh ĩ jéihcat jíib jwĩ íip queétdih peéh chãjna, iiguípna ã yohbipna caá, fariseowã ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Obohjeéhtih, biíc fariseo, Nicodemo wʉ̃t jʉmni, chei Jesúsdih wéhenadih jʉibíniji, páant ĩ niijíchah joiná, bita caanjĩ́h jʉmnitdih nin pah ãt niijíp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jesús yeejép ã chãjachah, jwĩ jéihcan caá. Pánih jéihcannit jʉmna, ded pah ã chãjatdih caanjéh ã naóhcah, jwĩ jéih peéh chãjcan caá. Pánih jéihcan yʉhna, caandíh jwĩ peéh chãjachah, jwĩ wʉtatdihjeh jwĩta yap yoh tagaá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Páant ã niijíchah joinít, queét nin pah caandíh ĩt niíj jʉ̃ihñʉp wʉt jĩ: —¿Meembʉ́t Galilea baácdih bóo niít, jwiítdih páant ma niíj naóhna? Dios naáwátdih meemdíh tʉ́i bohéát caá náahap. Pánih bohéna, ‘Galilea baácmant ded Dios naáwátdih naóh yapani ãtát wihcap tajĩ’, ma niíj jéihbipna caá, Nicodemodih ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Páant niíj péanit, ĩ́ih mʉʉnáboó ĩt jwʉ́ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Dioíh mʉʉ́boó jʉmnitdih naóh péanit, Olivo Jeéboó Jesús jwiítdih ã nʉmah pʉ́ʉh laab béjep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cheibitjeh, jwʉ́ʉb dei jʉ̃óhnit, Dioíh mʉʉdíhjeh mʉntih jwiítdih ã jwʉ́ʉb nʉmah waadáp jĩ. Ã jwʉ́ʉb jʉyʉ́chah ennit, nihat cã́acwã ã pebhna ĩ míic wáac jʉyʉ́p jĩ. Ĩ míic wáac jʉyʉ́chah ennit, caanjĩ́h jʉibí chʉ́ʉdnit, Jesús queétdih ã bohénap jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ã bohéát tac jʉmʉchah, Moisés ã wʉtatjidih bohénit, fariseowã biícdih deoh nah jʉmnihdih ĩt ʉb jʉ̃ʉ́wʉ́p jĩ. Pánih ʉb jʉ̃óhnit, Jesús pebh cã́acwã cãtíh caántdih ĩ ʉb jʉí ñʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pánih ʉb jʉí ñʉhnit, Jesúsdih nin pah ĩ niíj naáwáp jĩ: —Nint mi áa nihcannijĩh yeejép mi chãjachah, jwĩ enep be. ");
INSERT INTO cbv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dios ã wʉtatdih Moisésji nin pah ãt niíj daacáp tajĩ. ‘Det ĩ áa nihcannitjĩh yeejép ĩ chãjachah ennit, jee dáhnajĩh ñi yoh mawaá’, ãt niíj daacáp tajĩ. Pánihna, meémboó ¿ded pah tigaá ma niíj naóhbi? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Páant niijnít, caandíh naóh yacat tʉ́ʉt niijná, Jesúsdih mácah ĩ naáwát tʉ́ʉtʉp yʉh jĩ. Obohjeéhtih, Jesús páant ĩ niijíchah joinít, páah jéennit, ã́ih téih tíibjĩh baácboó ã daacáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Páant ã daác jwʉhʉchah, queétboó caandíh ʉʉ́bh joí yójahna ĩ chãjap jĩ. Páant ĩ ʉʉ́bh joí yójahachah, Jesús ñah ñʉhnit, queétdih nin pah ã niíj jepahap jĩ: —Ded ñijeéh jʉmni yéejat wihcanniboó caántdih jee dáhjĩh ã jwíih yoh waáwá naáh, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Páant niíj péanit, jwʉ́ʉb páah jéennit, ã jwʉ́ʉb daacáp jĩ, páant mʉntih. ");
INSERT INTO cbv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Páant ã niijíchah joinít, caántdih naóh yacnitboó ĩ yéej chãjatjidih náhninit, chah behnit biquína ĩ jwʉ́ʉb beedáh bejep jĩ. Páant ĩ bejat tʉ́ttimah, deoh nah jʉmnih Jesús pebh ñʉhnit, caandíh joinít cãtíh queét chénewãjeh ĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pánihna, caántdih ʉb jʉ̃óhnitji ĩ wihcah enna, jwʉ́ʉb ñah ñʉhnit, Jesús caántdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Deyoob tígaá queét ĩ bej? ¿Meemdíh peéh chãjat tʉ́ʉtnit ĩ wihcan caá? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Wihcan caá, Maá, mi niijíp jĩ. —Weembʉ́t meemdíh wã peéh chãjat tʉ́ʉtcan niít. Ma jwʉ́ʉb bejeé. Ma jwʉ́ʉb yéej chãjca bojoó, páant mʉntih, Jesús caántdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Caántdih naóh péanit, Jesús caanjĩ́h jʉmnitdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ, páant mʉntih: —Weemjéh tigaá baabát panihni nin baácdih moondíh wã íip Dios ded pah ã jʉmatdih wã jéihyana caá. Det weemdíh péenit, dʉpʉ́át panihipboó bejcan, wã íipdih ĩ jéihbipna caá. Pánihna, weemdíh ĩ jepahachah, páantjeh Diosjeéh wã tʉ́i jʉmat tʉ́ʉtbipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Páant ã niijíchah joinít, fariseowãboó nin pah caandíh ĩ niijíp jĩ: —Meém ma tʉ́i jʉmatdih meemjéh naóhna, oboh nih yáana caá ma chãjap. Páant ma niijíchah, ma naáwát dedé pínah nihcan caá, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Weemjéh dedmant wã jʉ̃ʉ́wátjidih wã jéihna caá. Wã bejat pínahdihbʉt wã jéihna caá. Obohjeéhtih, yeébboó caandíh ñi jéihcan caá. Páant weemdíh ‘nih yáani caá’, ñi niijíchah yʉhna, ded pah wã jʉmatdih yoobópdih yeebdíh wã naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yeébboó ded pah ñi enatdihjeh jenah joinít, cã́ac ded pah ã jenah joyátdih yoobópdih ñi jéihcan caá. Pánih jéihcan yʉhna, ‘Caánboó tʉ́ican caá’, weemdíh ñipĩ́ niijná caá. Obohjeéhtih, yeéb ñi jenah joyát pah jenah joicán, ded pah cã́acwã ĩ jʉmatdih weémboó wãpĩ́ naóhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Weém biícjeh pohba nihcan caá cã́acdih páant niíj naóhni. Wã íip weemdíh wahni biícdih, páant jwĩ niíj naóhna caá. ‘Nin tʉ́ini caá. Nin tʉ́icanni caá’, niíj naóhna, yoobópdih wã naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés yeebdíh wʉtna, nin pah ãt niíj daacáp tajĩ: ‘Chénewã biíc yoobó ĩ naáwáchah, ĩ niiját yoobópdih caá’, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Weémboó ded pah wã jʉmatdih naóhna, weemdíh wahni, wã íipbʉt biíc yoobó ã naóhna caá. Pánihna, ded pah wã jʉmatdih chénewã naóhnit jwĩ jʉmʉchah, jwĩ naáwát yoobópdih caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Páant ã niijíchah joinít, fariseowã nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —¿Ma íip dedboo tígaá ã jʉm? ĩ niijíp jĩ. —Weemdíh jéihcan, wã íipdihbʉt ñi jéihcan caá. Obohjeéhtih, weemdíh jéihna nihna, wã íipdihbʉt ñita jéih taga, Jesús queétdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Páant niíj bohéna, Dioíh mʉʉ́boó cã́acwã ĩ wʉ̃hni dinerodih ĩ jwejat paihna pebh ã jʉmʉp jĩ. Obohjeéhtih, caandíh ĩ mao yohat pínahdih Dios ã jenah joyát ã jʉdh jwʉhʉchah, caandíh tewíhnit pínahbʉt caanjĩ́h jʉmna yʉhna, caandíh ĩ jéih teo jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pánih bohénajeh, Jesús nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Wã jʉ̃ʉ́wʉ́pjiboó wã jwʉ́ʉb bejbipna caá. Páant wã bejat tʉ́ttimah, weemdíh ñi bidbipna caá. Obohjeéhtih, ñi yéej chãjatdih ñi cádahcatji jíib, wʉnna, ñíih caolih iiguípna bejna, wã bejep pínahboó ñi jéih bejcan niít, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Páant ã niijíchah joinít, jwĩ déewã queétjeh nin pah ĩ míic niíj ʉʉ́bh joyóp jĩ: —‘Wã bejep pínahboó yeéb ñi jéih bejcan niít’, niijná, ¿caanjéh míic mao wʉnat tʉ́ʉt niít ã chãjap? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Páant ĩ míic niijíchah joinít, Jesús queétdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Yeéb nin baácdih moón jʉmna, Dioíhwã nihcannit ĩ jenah joyát biíc yoobó ñi jenah joiná caá. Obohjeéhtih, weémboó japmant jʉ̃óhni jʉmna, wã íip Dios ã jenah joyát biíc yoobó wã jenah joiná caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Wã íip ã wahni wã jʉmatdih yeebdíh wã naáwáchah yʉhna, ‘Ã naáwát yoobópdih nihcan caá’, ñi niijátji jíib ñi yéejatdih cádahcan, iiguípna ñi bejbipna caá. Pánihna, ñi yéejatdih cádahcat peéh, wã niijátji biíc yoobó yeebdíh ã yapbipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Déhe pohba tigaá, meém? ĩ niijíp jĩ. —Ded pah wã jwíih naáwátji pahjeh wã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yeéb ñi tʉ́i chãjcatji jíib Dios ã peéh chãjat pínahdih yeebdíh wã naáwát pínah bʉ́dí ã jʉdhna caá. Obohjeéhtih, weemdíh wahni ã naáwát tʉ́ʉtnidihjeh yeebdíh wã naóh yapana caá. Caán ã naáwát tʉ́ʉtat yoobópdih caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Obohjeéhtih, “Wã íip caá weemdíh wahni”, ã niijíchah joinít, queét ĩt beh joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Páant ĩ beh joicátdih jéihna, Jesús queétdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Weém nihat cã́acwã ʉ́ʉd jeñédih cruzboó péohnit, ĩ pʉd dodhbipna caá. Páant ĩ chãjachah, ‘Caán Dios ã wahni caá’, ñi niíj jéihbipna caá. Pánih jéihnit, wã jenah joyátjeh wã chãjcatjidihbʉt ñi jéihbipna caá. Wã íip ded pah weemdíh ã bohéátjidihjeh yeebdíh wã naáwátjidihbʉt ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Weemdíh wahniboó wãjeéh ã jʉmna caá. Pánih wahni jʉmna, ã weñat pínahdihjeh yeó jáap jʉmat pah wãpĩ́ chãjna caá. Páant wã chãjachah, weemdíh ã cádahcan caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Páant ã niijíchah joiná, “Caán Dios ã wahni Cristo yoobát ã jʉmna caá”, dawá ĩ niíj jenah joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Biquína jwĩ déewã “Caán Dios ã wahni Cristo caá”, niíj jenah joinítdih Jesús nin pah ã niijíp jĩ: —Wã naáwátdih cádahcannit, wã bohénit yoobát ñi jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pánih jʉmna, yoobópdih ñi jéihbipna caá. Yoobópdih jéihnit jʉmna, watnit panihnit ñi jʉmbipna caá. Pánih jʉmna, ded yéej chãjat jenah joyát ã jʉ̃ʉ́wʉ́chah yʉhna, caandíh ñi jéih yap yohbipna caá. Yeebdíh wʉtni panihni ã jwʉ́ʉb wihcan niít, queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Páant ã niijíchah joinít, queétboó nin pah ĩ niíj jepahap jĩ: —Jwiítboó Abrahamji ã jʉimená jwĩ jʉmna caá. Páant jwĩ jʉmʉchah, ded jwiítboodíh wʉtni ã wihcan caá. Páant wihcah yʉhna, ¿ded pah niij tígaá ‘yeebdíh wʉtni ã jwʉ́ʉb wihcan niít’, ma niíj naóh? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Yoobópdih yeebdíh wã naóhna caá. Cã́acwãjeh ĩ yéej chãjatdih ĩ jéih cádahcan caá. Pánihna, queétdih yéej chãjat tʉ́ʉtni ĩ maáh panihni caá. Pánih yéej chãjnit jʉmna, caandíh teo wʉ̃hnit panihnit ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ded teo wʉ̃hni ã maáh wʉ̃ʉ́h pah nihcan caá. Bita caandíh ĩ ʉbʉchah, queétboodíh teo wʉ̃hni ã jʉmbipna caá. Obohjeéhtih, ã maáh wʉ̃ʉ́hboó páantjeh ã wʉ̃ʉ́h ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pánihna, weém Dios wʉ̃ʉ́h jʉmna, deddih wã watachah, caanbʉ́t wã íip wʉ̃ʉ́h ã jʉmbipna caá. Páant wã watachah, yéej chãjatdih teo wʉ̃hni panihni ã jwʉ́ʉb jʉmcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yeéb Abrahamji ã jʉimená ñi jʉmatdih wã jéihna caá. Obohjeéhtih, ã jʉimená jʉmna yʉhna, wã naáwáchah joííhcan, weemdíh ñi mao yohíhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wã íipjeéh jʉmna, wã enatjidih yeebdíh wãpĩ́ naóhna caá. Obohjeéhtih, ñi íip, nemépwã ĩ maáh, yeebdíh ã wʉtʉchah joinít, yeébboó ñipĩ́ jepahna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Jwĩ íip yoobát Abraham caá, queét ĩ niijíp jĩ. —Abrahamji ã weh yoobát jʉmna, ded pah ã chãjatji biíc yoobó ñita chãj tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Obohjeéhtih, yeebdíh wã íip ã naáwátdih yoobópdih wã naóh yapanachah yʉhna, yeébboó weemdíh ñi mao yohíhna caá. Abrahamjiboó páant ãta chãjcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pánihna, ñi íip panihni ã chãjíhat biíc yoobó mʉn tigaá yeebbʉ́t ñi jenah joyóp, Jesús queétdih ã niijíp jĩ. —Jwiít íip wihcannit pohba jwĩ nihcan caá. Dios biícjeh caá jwĩ íip, queét ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Weém Diosjeéh jʉmniji nin baácna wã jʉ̃ʉ́wʉ́p jĩ. Pánihna, Dios ñi íip ã jʉmʉchah nihna, yeéb weemdíh ‘jwĩ ʉ́ʉd jeñé’, ñita niíj oi tagaá. Wã jenah joyátjeh nin baácboó wã dei jʉ̃óhcan jĩí. Wã íip Dios ninboó weemdíh ã wahachah, wã jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Dépanih tigaá wã naáwátdih ñi beh joicán? Ñi joííhcat jíib caandíh ñi beh joicán caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ñi íipboó yeejép chãjat tʉ́ʉtnit ĩ maáh caá. Pánihna, caán ã weñat pínahboodíh ñipĩ́ chãjna caá. Nin baác ã jwíih jʉmʉchah, bʉʉbʉt páantjeh cã́acwãdih mao yohat tʉ́ʉtni caá. Caán biícmant yeenijeh jʉmna, yoobópdih ã jéih naóhcan caá. Pánih yeeat bʉʉ́hna, nih yáaatdihjeh ãpĩ́ naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Páant yeebdíh yeeni ã naáwáchah joinítji weémboó yeebdíh yoobópdih wã naáwáchah yʉhna, ñi joííhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Páant wã naáwáchah, ‘Meém yeejép chãjni caá’, weemdíh ñi jéih niijcán caá. Yoobópdih wã naáwáchah yʉhna, ¿dépanih tigaá ñi joííhcan? ");
INSERT INTO cbv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Det Dios wehboó ã naáwátdih ĩ tʉ́i joiná caá. Obohjeéhtih yeéb ã weh nihcannit, ã naáwátdih wã naóh yapanachah yʉhna, ñi joííhcan caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Páant ã niijíchah joinít, queét nin pah Jesúsdih ĩ niijíp jĩ: —‘Meém Samaria baácdih bóo jʉmna, Diosdih jéihcanni, nemép caolih jʉmni caá’, jwĩ niiját yoobópdih caá, ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Weemdíh nemép wihcan caá. Obohjeéhtih, wã íip ã wẽpatjĩh yeebdíh wãpĩ́ chãj jʉ́ʉtna caá, caandíh ñi wẽi naáwát pínah niijná. Páant wã chãjachah yʉhna, yeébboó weemdíh wẽi naóhcanjeh, yeejép ñipĩ́ wéhena caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Weemdíh ñi wẽi naáwátdih wã bidcan caá. Obohjeéhtih, cã́acwã weemdíh ĩ tʉ́i weñat pínahdih wã íipboó ã náah yacna caá. Pánihna, weemdíh ĩ náahcatji jíib queétdih ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yoobópdih yeebdíh wã naóhna caá. Det wã naáwátdih jepahnit, ĩ wʉncan niít, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Bʉʉ bácah chah jenah joicánniabeh meém ma jʉmatdih jwĩ jéihna caá. Abrahamji, nihat Dios naáwátdih naóh yapanitji pah mʉntih ĩt wʉnʉp wʉt jĩ. ‘Wã naáwátdih jepahni ã wʉncan niít’, niijná ¿dépanih tigaá meém páant ma niíj? ");
INSERT INTO cbv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Jwĩ nʉo Abrahamji, Dios naáwátdih naóh yapanitjibʉt chah wẽpni niít ma jʉmʉp? ¿Ded pohba tigaá meém? páant niíj naóhni, queét ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—‘Chah wẽpni caá’, weemjéh wã jéih niijcán caá. Wã íipjeh ‘Caán chah wẽpni caá’, weemdíh ã niijná caá. Yeéb ‘Diosjeh caá jwĩ íip’, ñi niijníjeh wã íip ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Obohjeéhtih, páant niijná yʉhna, caandíh yoobópdih ñi jéihcan caá. Weém caá caandíh wã jéihyep. ‘Caandíh wã jéihcan caá’, niijná, yeéb ñi nihat pah yeeni wãta jʉm tagaá. Obohjeéhtih, caandíh yoobópdih wã jéihna caá. Pánih jéihna, ded pah ã naáwáchah, wãpĩ́ chãjna caá. ");
INSERT INTO cbv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jwĩ nʉo Abrahamji nin baácboó wã dei jʉ̃ʉ́wát pínahdih jéihnit, ã weñep jĩ. Pánihna, wã dei jʉ̃ʉ́wʉ́chah ennit, bʉ́dí ã yoób weñep jĩ, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—Páant, meém cincuenta jópchi ma jʉibí jwʉhcan caá. Páant niijná, ¿jon jã́tih bóo Abrahamjidih meém ma ennit jĩí? Jesúsdih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Yoobópdih yeebdíh wã naóhna caá. Abrahamji jʉm láa, weém wãát jʉmʉp jĩ, Jesús queétdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Páant ã niíj jepahachah joinít, queétboó jee dáhnadih ʉbnit, Jesúsdih ĩ yohíhip yʉh jĩ. Obohjeéhtih, páant ĩ yohíhichah, ĩ encat pónih, Jesúsboó Dioíh mʉʉmánt ã bac bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tʉ́ttimah, jwiítdih Jesús namáboó nʉmah bejna, jéih encannidih jwĩ jwãááp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Caandíh enna, Jesúsdih nin pah jwĩ niíj ʉʉ́bh joyóp jĩ: —¿Bohéní, dépanih tigaá nin jáap cã́ac jʉmnajeh jéih encanni ãtát jʉmji? ¿Caanjéh yeejép ãt chãjji taniít? ¿Ã mánaboó ĩt yéej chãjji taniít? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Nin ã yéej chãjatji jíib nihcan caá. Ã mánabʉt ĩ yéej chãjatji jíib nihcan caá. Obohjeéhtih, pánihni ã jʉmʉchah, wã íip ã wẽpatjĩh caandíh wã teo wáacbipna caá. Páant wã booanachah ennit, wã íip ã wẽpatdih cã́acwã ĩ tʉ́i jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yeó jáap cã́acwã ĩ́ih tewatdih ĩ jéih teona caá. Obohjeéhtih, chei ĩ jéih teocan caá. Pánihna, bʉʉ caá ã baab jwʉ́hat panihichah, weemdíh wahni ã wʉtatdih jwiítdih chãjat ã náahna caá. Tʉ́ttimah, chei jwĩ teocat pah, caandíh jwĩ jéih chãjcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pánihna, nin baácboó wã jʉm jwʉhʉchah, baabát panihni cã́acwãdih ded pah Dios ã jʉmatdih wã jéihyabipna caá, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Páant niíj péanajeh, baácboó mao mác ã coí jéenanap jĩ. Pánih coí jéenanit, baácdih wid teo, jéih encanniíh quíibnadih ã ñáñap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pánih ñái péa, Jesús caandíh nin pah ã niijíp jĩ: —Siloé wʉ̃t jʉmni jẽ́ehat jʉ́ána quíib táñadih ma bejeé, ã niijíp jĩ. Siloé niijná, jwĩ́ih wéheatjĩh “Wahni”, niijná ã chãjap jĩ. Jesús páant ã niijíchah joinít, jéih encanni quíib táñadih ã bejep jĩ. Pánih quíib tã́iniji ennit, ã́ih mʉʉná ãt jwʉ́ʉb bejjip taga. ");
INSERT INTO cbv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Páant ã jwʉ́ʉb jʉibínachah, ã chéenwã, caán dinero ʉʉ́bhniji ã jʉmatdih jéihnitbʉt, ennijeh ã́ih mʉʉná ã jwʉ́ʉb jʉibínachah ĩt enep wʉt jĩ. Pánih ennit, queétjeh nin pah ĩt míic niíj ʉʉ́bh joyóp wʉt jĩ: —¿Nin dinero ãpĩ́ ʉʉ́bhniji nihcan niít? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Caanjéh tigaá, biquína ĩt niijíp wʉt jĩ. —Obohjeéhtih, caán yoobát pohba nihcan caá. Caan páh jígohna caá ã chãjap, bitaboó ĩt niijíp wʉt jĩ. —Caanjéh tigaá, weém, encanniji ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—Jéih encanniji jʉmna yʉhna, ¿ded pah tibeé ma nih? bʉʉ ma jéih enat pínahdih, ĩt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jesús wʉ̃t jʉmni ã́ih mao mácjĩh baácdih wid teonit, wĩ́ih quíibnadih ãí ñáñap be. Weemdíh ñái péanit, ‘Siloé wʉ̃t jʉmni jẽ́ehat jʉ́ána quíib táñadih ma bejeé’, ã niijíchah joinít, caanná wã bejep be. Pánih quíib tã́inajeh, wã jéih enep be bʉca, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Meemdíh pánih chãjni deyoob tígaá an jʉm? ĩt niijíp wʉt jĩ. —Jaóh jʉ̃h. Deh caá an jʉmʉpna caá, queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Páant niíj ʉʉ́bh joí péanit, jéih encannijidih fariseowã maáta pebhboó ĩt ʉb bejep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jwiít judíowã jwĩ chooát yeó jáapdih caán encannijidih Jesús ã booanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Páant chooát yeó jáapdih ã booanachah jéihnit, caán newédih fariseowã jwʉh ĩt jwʉ́ʉb ʉʉ́bh joyóp wʉt jĩ: —¿Ded pah tibeé meém ma nih en? ĩt niijíp wʉt jĩ. —Mao mácjĩh baácdih wid teonit, wĩ́ih quíibnadih ãí ñáñap be. Pánih ñái péanit, ã quíib táñat tʉ́ʉtʉchah joinít, wã bejep be. Pánih quíib tã́inajeh, wã yoób enep be, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Páant ã niijíchah joinít, biquína queét fariseowã nin pah ĩt niijíp wʉt jĩ: —Caán jwĩ chooát yeó jáapdih ãt tewep taga. Páant chooát tʉ́ʉtatdih yap yohna, Dioíh yoobát nihcan caá, ĩt niijíp wʉt yʉh jĩ. Obohjeéhtih, bitaboó —Yeejép chãjni nihna, páant ãta jéih booacan tagaá. Pánihna, caán tʉ́ini nacaá, ĩt niijíp wʉt jĩ. Páant niijná, queét chénat pah poómp biíc yoobó ĩt jenah joicáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Caán encannijidih queét nin pah ĩt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ, páant mʉntih: —Meemdíh míih quíibdih booani Jesúsdih meémboó ¿ded pah ma niíj jenah joí? ĩt niijíp wʉt jĩ. —Caán yoobópdih Dios naáwátdih naóh yapani nacaá an jʉmʉp, queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pánihna, jwĩ maáta nin pah ĩt niíj jenah joyóp wʉt yʉh jĩ: “Nin jéih encanni ãt nihjican tagaá”, ĩt niijíp wʉt jĩ. Páant niíj jenah joinít, jéih encanniji mánadih ĩt bid bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pánih bid bojnit, ã mánadih jwʉh nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Nin yoobópdih ñi wʉ̃ʉ́h niít ã jʉmʉp? ¿Biícmantjeh caán jwíih cã́ac jʉmna, jéih encanni nitjĩí wãát jʉmʉp? ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Nin jwĩ wʉ̃ʉ́h tigaá. Biícmant jéih encannijeh ã cã́ac jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Caandíh jéihna yʉhna, ded pah bʉʉ ã enatdih, caandíh booanidihbʉt jwĩ jéihcan caá. Jwĩ wʉ̃ʉ́h wébít nihcan caá. Caandíhjeh ñi ʉʉ́bh joyoó. Caanjéh ã jéih naóhna caá, ã mána ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ded “Jesús Dios ã wahni Cristo caá”, niijnídih jwĩ maátaboó jwĩ míic wáacat mʉʉdíh ĩta waadát tʉ́ʉtcan tagaá. Páant ĩ chãjat pínahdih jéihna, encanniji mána jwĩ maátadih ĩt ʉ́ʉmji tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pánih ʉ́ʉmna, “Caán wébít nihcan caá. Caandíhjeh ñi ʉʉ́bh joyoó”, ĩt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Páant ĩ niíj jepahachah joinít, jwĩ maáta jéih encannijidih ĩt jwʉ́ʉb niijíp wʉt jĩ: —Jesús yéejni ã jʉmatdih jwiítboó jwĩ jéihna caá. Pánihna, Diosdih wẽinit, jwiítdih yoobópdih ma naáwá, caandíh ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Jesús yéej chãjni ã jʉmatdih wã jéihcan caá. Nindihjeh wã jéihna caá. Jéih encanni wã jʉmʉp jĩ. Obohjeéhtih, bʉʉ wã enna caá, queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Ded pah tií meém ma enat pínahdih caán ãí chãj? ĩt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Caandíhjeh tibeé yeebdíh wãát naáwáp be. Páant wã naáwáchah yʉhna, weemdíh ñi joííhcan beé. ¿Dedé chãjat tʉ́ʉt tigaá wã jwʉ́ʉb naáwáchah, ñi joííh, páant mʉntih? ¿Yeebbʉ́t ã́ihwã ñi jʉmíh niít? queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","—Meém Jesús ã bohéni caá. Obohjeéhtih, jwiítboó Moisésji ã bohénit caá. ");
INSERT INTO cbv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dios Moisésdih ã naáwátjidih jwĩ jéihna caá. Obohjeéhtih, caán Jesúsboó dedmant ã jʉ̃ʉ́wátjidih jwĩ jéihcan caá, queét caandíh ĩt niíj jʉ̃ihñʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—¡Páant! Dedmant ã jʉ̃ʉ́wátjidih ñi jéihcah yʉhna, ¿caán weemdíh enani Dios ã wahni ãta nihcan taniít? ");
INSERT INTO cbv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yéejnit ĩ ʉʉ́bʉ́chah, Dios ã joicán caá. Caandíh bácah jwiít nihat jwĩ jéihna caá. Obohjeéhtih, Diosdih wẽini, ã wʉtatdih jepahniboó ã ʉʉ́bʉ́chah, Dios ã joiná caá. ");
INSERT INTO cbv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jon jã́tih nin baác ã jwíih jʉmʉchah, jwíih cã́ac jʉmnajeh, jéih encannidih ded ã enaat doonádih jwĩ joicán jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pánihna, Jesús Dios ã wahni nihcan, weemdíh ãta jéih enacan tagaá, queétdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Biícmantjeh yéejni mat jʉmʉp wʉt jĩ. ¿Pánih yéejni jʉmna yʉhna, jwiítdih meém ma bohéíh niít? jwĩ maáta caandíh ĩt niíj jʉ̃ihñʉp wʉt jĩ. Páant niíj péanitjeh, Dioíh mʉʉmánt caandíh ĩt bacanap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jéih encannijidih ĩ bacaat doonádih Jesús ã joyóp jĩ. Pánih joinít, jéih encannijidih jwãáhnit, caandíh nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Meém nihat cã́acwã ʉ́ʉd jeñédih jepahni niít? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Maá, déhena tigaá caán? Caandíh jéihna, wã jepahbipna caá, Jesúsdih ã niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Caandíh ma enna caá. Weém meemdíh wéheni caanjéh tigaá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Maá, meemdíh wã jepahna caá, ã niíj jepahap jĩ. Páant niijnájeh, Jesús pebh bódicha caj yoh ñajnit, caandíh ã weñep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Páant ã weñechah ennit, Jesús cã́acwãboodíh nin pah ã niijíp jĩ: —Ded pah tʉ́i chãjat, ded pah tʉ́i chãjcatdihbʉt cã́acwã ĩ jéihyat pínah niijná, nin baácboó wã jʉ̃ʉ́wʉ́p jĩ. Wã íip ded pah ã wʉtatdih jéihcan, jéih encannit panihnit ĩ jʉmna caá. Det páant ĩ jʉmatdih jéihnitdih wã íip ded pah ã jʉmatdih wã bohébipna caá, jéih ennit panihnit ĩ jʉmat pínah niijná. Obohjeéhtih, bita jéih encannit panihnit jʉmna yʉhna, ‘Jwiít tʉ́i jéihnit caá’, niíj jenah joinítdih wã bohécan niít, páantjeh jéih encannit panihnit ĩ jʉmat pínah niijná, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Páant ã niijíchah joinít, biquína caan pébh jʉmnit fariseowã caandíh nin pah ĩ jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ: —‘Jéih encannit panihnit’, niijná, ¿jwiítdih niíj niít ma chãjap? Jesúsdih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Jéih encannit panihnit ñi jʉmatdih ñi jéihyechah, yeebdíh peéh chãjat ãta wihcan tagaá. Obohjeéhtih, jéih encannit panihnit jʉmna yʉhna, ‘Diosdih jwĩ tʉ́i jéihna caá’, ñi niíj jenah joyát jíib, yeebdíh peéh chãjat ã jʉmbipna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tʉ́ttimah, biíh naáwátjĩh, bohéát tʉ́ʉt niijná, nin pah Jesús cã́acwãdih ã niíj naáwáp jĩ: “Yoobópdih yeebdíh wã naóhna caá. Ded ovejawãdih wáihyat jʉ́dʉ jẽcdih waadcánjeh, jẽc wihcapmant aáb pʉ́ʉd deini, nʉʉmní tigaá ã jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Obohjeéhtih, wáihyat jʉ́dʉ jẽcdihjeh waadníboó ã́ih ovejawãdih en daoní yoobát ã jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ovejawã mínah wáihyat jʉ́dʉdih ã jʉyʉ́chah, caán jẽcdih wapni caandíh ã wãt wʉ̃hbipna caá. Páant ã wãtachah, queétdih en daoníboó ĩ́ih wʉ̃tna yoobó ã ejechah, ã́ih wéheatdih ã́ih ovejawã ĩpĩ́ beh joiná caá. Pánih beh joinít, queét ãjeéh ĩpĩ́ pée bac bejna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nihat ã́ihwã ĩ bac beedéchah ennit, queétdih ã waóh bejna caá. Pánihna, ã wéheatdih tʉ́i beh joiná, caandíhjeh ĩ tʉ́i pée bejna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Obohjeéhtih, biíh ĩ jéihca naáhdih ĩpĩ́ pée bejcan caá. Bita ĩ wéheatdih joiná, ʉ́ʉmnit, ĩpĩ́ jwei béjna caá”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús páant ã niijíchah yʉhna, queét ĩt beh joicáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Páant ĩ beh joicátdih jéihnit, Jesús queétdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: “Yoobópdih yeebdíh wã naóhna caá. Ovejawãdih wáihyat jʉ́dʉ jẽc panihni tigaá weém wã jʉmʉp. ");
INSERT INTO cbv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nihat wã jã́tih jʉ̃óhnit, nʉʉmnít panihnit, cã́acwãdih ĩt yee bohénap jĩ. Queét ĩ wéhenachah yʉhna, cã́acwã, ovejawã panihnit, queétdih ĩt joyáh bojop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Weémboó wáihyat jʉ́dʉ jẽc panihni caá. Weemdíh jepahnit jẽcdih waadnít panihnit ĩ jʉmna caá. Pánihna, queét iiguípna bejnit déejidih wã tʉ́i ʉbna caá. Ovejawã ʉ́ʉmcanjeh, ĩ́ih wáihyat jʉ́dʉmant jʉmnitji wãíca naáhwã jeémédih bac bejnit, jwʉ́ʉb waadnít, ĩpĩ́ tʉ́i jʉmna caá. Pánihat pah, wĩ́ih cã́acwãboó wãjeéh jʉmna, ĩpĩ́ ʉ́ʉmcanjeh, wãíca naáhwã panihnit, ded pah ĩ náahatdih ĩ bíbohna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Queét nʉʉmnítboó ovejawã panihnit Dioíh cã́acwãdih mao yohodih ĩ jʉ̃óhna caá. Obohjeéhtih, bʉ́dí wẽinit, yeó jáap jʉmat pah wãjeéh ĩ tʉ́i jʉmat pínah niijná, weémboó queét ovejawã panihnitdih bididih wã jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Weémboó ovejawã panihnitdih tʉ́i en daoní wã jʉmna caá. Ded ovejawãdih tʉ́i en daoní caandíh ĩ mao yohat dée tobohat ã jʉmʉchah yʉhna, ã́ih ovejawãdih ãpĩ́ en daó cádahcan caá. Pánihat dée pah queét iiguípna bejnit déejidih wã tʉ́i ʉbat tʉ́ʉt niijná, weémboó cã́acwãdih wã wʉn wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Obohjeéhtih, ã maáíh ovejawãdih en daoníboó yoobópdih ã tʉ́i en daocán caá. Ã́ihwã nihcah, jió ovejawãdih jeémédih ã jʉ̃ʉ́wʉ́chah enna, teo wʉ̃hniboó ã en daonít ovejawãdih ã yoh jwei béjna caá. Ã yoh jwei béjat tʉ́ttimah, jió ovejawãdih ã tewechah enna, queét ĩ jweí peét bejna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Caán teo wʉ̃hniboó ã jíib chãjatdihjeh ã bidna caá. Ã maáíh ovejawãdih oican, queétdih ã tʉ́i en daocán caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Weém ovejawãdih tʉ́i en daoní panihni tigaá wã jʉmʉp. Wã íip weemdíh ã tʉ́i jéihna caá. Weembʉ́t caandíh wã tʉ́i jéihna caá. Páant wã íipdih wã tʉ́i jéihyat pah, wĩ́ih ovejawã panihnit weemdíhbʉt ĩ tʉ́i jéihna caá. Wã íip weemdíh ã jéihyat pah, weembʉ́t queétdih wã tʉ́i jéihna caá. Pánih jéihna, wã íipjeéh ĩ tʉ́i jʉmat pínah niijná, queétdih wã wʉn wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Biíh wáihyat jʉ́dʉ diítboó jʉmnit ovejawã panihnitbʉt wĩ́ihwã ĩ jʉmbipna caá. Pánih jʉmnit, wã naáwáchah, queétbʉt ĩ joi póobipna caá. Pánih joinít, wĩ́ihwã biícdih queétbʉt ĩ jʉmbipna caá.Pánihna, weemjéh nihat wĩ́ihwãdih wã tʉ́i en daobípna caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wĩ́ihwã Diosjeéh ĩ jʉmat pínah niijná, queétdih páant wã wʉn wʉ̃hat pínah, wã jwʉ́ʉb boo pʉd jʉ̃ʉ́wát pínahdihbʉt jéihnit, wã íip weemdíh ã oina caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ded ã náahat pah weemdíh mao yohni pínah ã wihcan caá. Wã náahat pahjeh weemdíh ĩ mao yohbipna caá. Pánihna, wã náahat pahbʉt wã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá. Páant wã íip weemdíh ã chãjat tʉ́ʉtʉp jĩ”, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Páant ã niijíchah joinít, queét jwĩ déewã biíc yoobó ĩt jenah joicáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Caán nemép jʉmni caá. Pánih jʉmna, ã tʉ́i jenah joicán caá. ¿Dépanih tigaá caandíh jwĩ jwʉ́ʉb joííh, páant mʉntih? dawá ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Obohjeéhtih, bitaboó —Nemép jʉmni nihna, páant ãta niíj naóhcan tagaá. Ded nemép jʉmni jéih encannijidihbʉt ãta jéih enacan tagaá. Pánih chãjna, nemép jʉmni nihcan caá, ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Tʉ́ttimah, mah noój láa, jwiít judíowã Jerusalén tʉ́tchidih biíh fiesta jwĩ jwʉ́ʉb chãjap jĩ. Jon jã́tih Dioíh mʉʉdíh chãj péanit, Diosdih ĩ wẽi wʉ̃hatjidih jwĩ náhniat yeó jáapna ã jʉmʉp jĩ. Caán yeó jáapnadih Dioíh mʉʉdíh wãáp lap nʉmpboó Salomón ã chãjat tʉ́ʉtni coahjidih Jesús ã en jibip jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Caan cóahboó Jesús ã jʉmʉchah enna, jwĩ maáta caandíh ñʉh pʉ́ʉda bojnit, nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —Maatápdih jwiítdih ma tʉ́i naóhcan caá. Pánihna, bʉʉ jwiítdih yoobópdih ma naáwá. ¿Meém Dios ã wahni Cristo yoobát niít ma jʉmʉp? Jesúsdih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Yeebdíh jã́tih wãát naáwáp jĩ. Páant wã naáwáchah yʉhna, weemdíh ñi joííhcan jĩí. Wã íip ded pah weemdíh ã wʉtʉchah joinít, ã wẽpatjĩh wãpĩ́ chãjna caá. Pánih chãjna, weém Cristo yoobát wã jʉmatdih jʉ́ʉt tigaá wã chãjap. ");
INSERT INTO cbv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Páant wã jʉ́ʉtʉchah yʉhna, bitaíh ovejawã panihnit jʉmna, weémboodíh ñi joííhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ovejawã queétdih en daonídih ĩ tʉ́i joyát pahjeh tih, wĩ́ihwã weemdíh ĩ tʉ́i joiná caá. Queétdih wã jéihyechah, weemdíh ĩ tʉ́i péena caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Páantjeh Diosjeéh queétdih wã tʉ́i jʉmat tʉ́ʉtʉchah, iiguípna ĩ bejcan niít. Pánihna, queétdih wã tʉ́i en dawáchah, bitaboó weemdíh ĩ jéih dʉ́ʉc wáican niít. ");
INSERT INTO cbv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wã íip, wĩ́ih cã́acwãdih weemdíh wʉ̃hni, nihatdih chah wẽpni caá ã jʉmʉp. Pánih jʉmna, wĩ́ihwãdih ã wapachah, bitaboó caandíhbʉt ĩ jéih dʉ́ʉc wáican niít. ");
INSERT INTO cbv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Weém wã íipjĩh biíc pahjeh jwĩ jʉmna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Páant ã niijíchah joinít, jwĩ maátaboó caandíh yohat tʉ́ʉt niijná, jee dáhnadih ĩ ʉbʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Páant ĩ chãjachah ennit, Jesús queétdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —Wã íip ã wẽpatjĩh dawá láa yeebdíh wã chãj jʉ́ʉtʉp yʉh jĩ. ¿Dedé wã chãjatji jíib tigaá weemdíh jee dáhnajĩh ñi yohíh? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Dios ã wẽpatjĩh ma chãj jʉ́ʉtatji jíib nihcan caá. Obohjeéhtih, meém cã́acjeh jʉmna yʉhna, ‘Diosjeh tigaá weém’, ma niíj yee naáwát jíib, meemdíh jee dáhnajĩh jwĩ yoh mawíhna caá, queét ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","—Obohjeéhtih, Dios naáwátdih naóh yapani nin pah ãt niíj daacáp tajĩ: ‘Yeéb wã naáwát tʉ́ʉtnitdih “weem pánihnit ñi jʉmna caá”, wã niijíp be’, Dios ãt niíj daacát tʉ́ʉtʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Páant ã niíj daacátji yoobópdih ã jʉmatdih jwiít nihat jwĩ jéihna caá. ‘Yeeni caá’, caán tólihdih jwĩ jéih niijcán caá. Dios naáwátdih jéihnitdih ‘Dios panihnit ñi jʉmna caá’, ã niíj naáwáchah, yoobópdih caá. ");
INSERT INTO cbv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios ã náahat pah weemdíh nin baácboó ã wahap jĩ. Pánihna, ‘Weém Dios wʉ̃ʉ́h caá’, wã niijíchah joinít, ¿dépanih tigaá weemdíh ‘Jesús Diosdih yéej naóhna caá ã chãjap’, ñipĩ́ niíj? ");
INSERT INTO cbv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wã íip ã náahat pah wã chãjcah bácah, wã bohéátdih ‘Yoobópdih tigaá’, niijcát caá náahap. ");
INSERT INTO cbv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Obohjeéhtih, wã íip ã wẽpatjĩh wã chãj jʉ́ʉtʉchah yʉhna, ‘Caán Dios ã wahni Cristo caá’, ñi niíj jenah joicán caá. Páant niíj jenah joicán yʉhna, wã chãj jʉ́ʉtatdih ‘Yoobópdih Dios ã wẽpatjĩh chãjni caá’, niíj jenah joyát caá náahap. Páant niíj jenah joiná, weém wã íip biícdih wã jʉmatdih ñi tʉ́i jéihbipna caá, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Páant ã niijíchah joí íijnit, queét chéneji ĩ tewíhip yʉh jĩ. Obohjeéhtih, ĩ tewíhichah jéihnit, Jesús queétdih ã jwei bác bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pánih bac bejniji Juan cã́acwãdih ã daabánapji, Jordán mʉj conanaáboó jwiítdih ã nʉmah chʉ́ʉh bejep jĩ, páant mʉntih. Caanná jʉibínit, jwiítdih ã nʉmah jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dawá cã́acwã caanná caandíh enedih ĩpĩ́ jʉibínap jĩ. Nin pah queét míicjeh ĩ niijíp jĩ: —Juan Dios ã wẽpatjĩh chãj jʉ́ʉtcan yʉhna, ded pah Jesús ã jʉmat pínahdih ã naáwáchah, yoobópdih tajĩí, ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Páant niíj jenah joinítji dawá Jesúsdih ĩ jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Lázaro, María, Marta queét biíc peihcannit, Betania tʉ́tchidih moon tájĩ. Queét yaádh ĩ ʉ́ʉd Lázaro biícdih ĩpĩ́ jʉmʉp jĩ. Caánt María, Jesúíh jítchanadih tʉ́i chej jʉmni macjĩh pʉohnit, miíh waó yoócjĩh jõp wionih pínah mit jʉmʉp tajĩ. Biíc yeó jáap Lázaro bʉ́dí ãt wʉnʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ã wʉnʉchah, yad jeñéna yaádh Jesúsdih dooná ĩt wahap tajĩ. —Ma oini bʉ́dí wʉnna beé ã chãjap be, Maá, ĩt niíj naáwát tʉ́ʉtʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pánihna, Lázaro ã wʉnat doonádih joinít, Jesús jwiít ã bohénitdih nin pah ã niíj naáwáp jĩ: —Lázaro wʉnna yʉhna, ã boobipna caá. Wʉnna, Dios ã wẽpat jʉ́ʉtat pínahjeh caá. Páant ã wẽpatdih jʉ́ʉtnit, ã wʉ̃ʉ́h wã jʉmatdih, wẽpni wã jʉmatdihbʉt cã́acwãdih ã jʉ́ʉtbipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lázarodih, yad jeñéna yaádhdihbʉt Jesús bʉ́dí ã oyop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pánihna, Lázaro ã wʉnat doonádih joiná yʉhna, caán yʉʉ́pbit bóo tʉ́tchidih Jesús chéne yeó jáap jwiítdih ã nʉmah jʉm jwʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tʉ́ttimah, Jesús jwiítdih nin pah ã niijíp jĩ: —Chóbe Judea baácboó, Lázarowã ĩ jʉmni tʉ́tchina, jwĩ jwʉ́ʉb bejjĩh, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Bohéní, jwínah bóonajeh tibeé, jwĩ maáta meemdíh jee dáhnajĩh ĩ yoh mawíhip be. ¿Dépanihna bʉʉ ma jwʉ́ʉb bejíh, páant mʉntih? jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Páant jwĩ niijíchah joinít, caandíh ĩ mao jwʉhcat pínahdih naóhna, biíh naáwátjĩh jwiítdih nin pah ã niíj jéihya naáwáp jĩ: —Bʉ́dí ñi jenah joicá bojoó. Biíc yeó jáapdih doce horajeh caá ã baabáp. Páant ã baabáchah, jwĩ tʉ́i enna caá. Pánihna, yeó jáap jibna, jwĩ bʉʉgcán caá. ");
INSERT INTO cbv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Chei jibna, baabcáh, jwĩpĩ́ bʉʉgná caá, Jesús ã niijíp jĩ. Páant niijná, nin pah niijná ãt chãjap jĩ: “Bʉʉ wã íip ded pah ã chãjat tʉ́ʉtatdih wã chãj beedá jwʉhcan caá. Páant weemdíh ã chãjat tʉ́ʉtat jʉdh jwʉhʉchah, weemdíh ĩ jéih mao jwʉhcan caá”, niijná ãt chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Páant niíj péanit, jwiítdih nin pah ã jwʉ́ʉb niijíp jĩ, páant mʉntih: —Jwĩ chéen Lázaro, ʉ̃ona caá an chãjapna caá. Páant ã ʉ̃wʉchah, weém caandíh wʉcʉdih wã jʉibíbipna caá, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Caán láa bácah, Maá, ʉ̃ona, ã tʉ́i boobipna caá, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Páant jwĩ niíj jenah joyóchah yʉhna, Jesús “Ʉ̃ona caá an chãjapna caá”, niijná “Mʉʉjáh bejna beé”, niijná ãt chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Páant jwĩ niíj jenah joyátdih jéihnit, Jesús jwiítdih nin pah yoobópdih ã niijíp jĩ: —Lázaro jáantjeh ã wʉnʉp be. ");
INSERT INTO cbv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wã wihcah, caán ã wʉnʉchah, wã wẽina caá. Bʉʉ bejnit, ded pah wã chãjat pínahdih enna, weemdíh chah ñi tʉ́i jenah joibípna caá. Pánihna, chóbe tí bácah, caandíh ĩ yohopjina enedih jwĩ bejjĩh, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Páant ã niijíchah joinít, Tomás, waláhni jwĩ niijní, nin pah jwiítdih ã niijíp jĩ: —Chóbe jwiítbʉt ãjeéh jwĩ en péejĩh. Caandíh maona, jwiítdihbʉt ĩ mawa naáh, ã niijíp jĩ. Páant ã niijíchah joinít, biícdih jwĩ bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jwiít Jesúsjeéh Betania tʉ́tchina jwĩ jʉibíát pínah jã́tih, Lázaroíh bácahjidih jeé íitboó ĩtát yohop tajĩ. Biícjĩh bóo téihya yeó jáap jã́tih ãtát wʉnʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania tʉ́tchi Jerusalén tʉ́tchi pebhjeh, biíc hora tacdih bejat ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Páant pebhjeh ã jʉmʉchah, dawá jwĩ déewã María, Marta ĩ ʉ́ʉddih ĩ jĩ́gahat yayáát tʉ́ʉt niijná, ĩ pebhna ĩt jʉibínap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jwĩ jʉibíát doonádih joinít, mʉʉmánt bac jʉ̃óhnit, Marta Jesúsdih jwãáádih mi jʉyʉ́p jĩ. Obohjeéhtih, yad jʉpʉ mʉʉ́ diítboó mit jʉm jwʉhʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pánihna, Jesúsdih jwãáhnit, Marta nin pah caandíh mi niijíp jĩ: —Maá, ninboó meém ma jʉmʉchah, wã ʉ́ʉd ãta wʉncan tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Obohjeéhtih, ded pah ma ʉʉ́bʉ́chah, Dios ã jepahat pínahdih weém wã jéihna caá, mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ma ʉ́ʉd ã boo pʉd jʉ̃óhbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Páant tih, Maá, caán péeni yeó jáap, nihat cã́acwã ĩ boo pʉd jʉ̃óhni yeó jáapdih, wã ʉ́ʉdbʉt ã jwʉ́ʉb boo pʉd jʉ̃ʉ́wát pínahdih wã jéihna caá, mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—Weemjéh wʉnnidih wã jéih jwʉ́ʉb booana caá. Ded weemdíh jepahni wʉnna yʉhna, ã jwʉ́ʉb boo pʉd jʉ̃óhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ded báadhnibʉt weemdíh jepahni, iiguípna ã bejcan niít. ¿Caandíh ma jenah joí niít? Martadih Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Maá, meém Cristo Dios wʉ̃ʉ́h ma jʉmatdih wã tʉ́i jéihna caá. Nin baácboó meemdíh ã wahatjidihbʉt wã jéihna caá, Marta mi niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Páant Marta caandíh niíj péanit, Maríadih naáwádih mi jwʉ́ʉb bejep jĩ. Pánih jwʉ́ʉb bejnit, mi jwandih mit jʉibí jéyé naáwáp wʉt jĩ. —Bohéni ãt jʉi tábeé. ‘Mi jʉ̃ʉ́wʉ́ naáh’, meemdíh ã niijná beé, mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Páant mi niijíchah joinít, María waícanjeh Jesúsdih jwãáádih mit bac jʉ̃ʉ́wʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Marta mi jwʉ́ʉb bejat tʉ́ttimah, tʉ́tchiboó waadcán, caanjĩ́hjeh jwĩ páñap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jwĩ déewã, Maríajeéh jʉmnit, wẽpép mi bac bejatdih ennit, “Mi ʉ́ʉddih yohopjiboó jʉñʉ́dih bejna caá mi chãjap”, ĩt niíj jenah joyóp tajĩ. Páant niíj jenah joinít, caántdih ĩt pée jʉ̃ʉ́wʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jwĩ pebhna jʉinít, Jesúsdih enna, ã pebh María baácboó mi páah yoh ñajap jĩ. Pánih páah yoh ñajnit, caandíh nin pah mi niijíp jĩ: —Maá, ninboó meém ma jʉmʉchah, wã ʉ́ʉd ãta wʉncan tagaá, mi niíj jʉ̃í naáwáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Páant mi jʉ̃í naáwáchah ennit, mijeéh péenit jwĩ déewã ĩ jʉñátdihbʉt ennit, Jesús bʉ́dí ã jĩ́gahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pánih jĩ́gahnit, Jesús queétdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Dee tíbeé caandíh ñi yoh? ã niijíp jĩ. —Maá, caandíh jwĩ yohopjiboó ma en jʉ̃ʉ́wʉ́, ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pánih jĩ́gahnit, Jesúsbʉt ã jʉñʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Páant Jesús ã jʉñʉ́chah ennit, mijeéh péenit jwĩ déewã nin pah queétjeh ĩ míic niijíp jĩ: —Jesús Lázarodih bʉ́dí ãt oi tagaá, ĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Obohjeéhtih, bita caanjĩ́h jʉmnit nin pah queétjeh ĩ míic niijíp jĩ: —¿Dépanih tigaá jéih encannidih ã jéih booana yʉhna, Lázaroji ã wʉnat pínah jã́tih, caandíh ãt jéih booaji caá? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Páant ĩ niíj míic wéheat pónih, Jesús bʉ́dí ã jwʉ́ʉb jĩ́gahachah, Lázarodih ĩ yohopjiboó jwiítdih ĩ nʉmah jʉibínap jĩ. Caán íitdih bʉ́dí jee dáhjĩh ĩt nemep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Páant ĩ nematjidih ennit, Jesús queétdih nin pah ã niijíp jĩ: —Can jeé jʉ́dʉdih ñi pʉ̃tʉ́ dodhdoó, ã niijíp jĩ. —Maá, biícjĩh bóo téihya yeó jáap jã́tih ã wʉnʉchah, jwĩ yohop be. Pánihna, bʉʉ ã́ih bácah an wĩ́ijna nacaá bʉca, Marta mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Wã naáwátjidih ma tʉ́i náhninaá. Dios ã wẽpatdih ma enat pínahdih meemdíh wãát naóhna beé, caántdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Páant caántdih ã niíj péanachah, queét jeé jʉ́dʉdih ĩ pʉ̃tʉ́ dodhdop jĩ. Ĩ pʉ̃tʉ́ dodh péanachah, Jesús jeáboó chéi ennit, Diosdih nin pah ã niíj ʉʉ́bʉ́p jĩ: —Weemdíh ma joyátji tʉ́ina caá, Paá. ");
INSERT INTO cbv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wã ʉʉ́bát pah ma joyátdih wã jéihna caá. Pánihna, weemdíh ma wahatjidih nit jʉmnit ĩ jéihyat pínah niijná, bʉʉ meemdíh páant wã niíj ʉʉ́bhna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Páant niíj ʉʉ́bh péanit, Jesús nin pah ã niíj wẽp ejep jĩ: —¡Lázaro, ma bac jʉ̃ʉ́wʉ́! ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jesús páant ã niíj ejechahjeh, Lázaro ĩ yohniji yʉhna, jeé íitmant ã bac jʉ̃ʉ́wʉ́p jĩ. Pánih bac jʉ̃óhna, ã́ih bácah, ã́ih wao dáhdihbʉt yégueh chóo tõpjĩh ĩ pinatji pahjeh ã dʉo bác jʉ̃ʉ́wʉ́p jĩ. Páant ã bac jʉ̃ʉ́wʉ́chah, Jesús queétdih nin pah ã niijíp jĩ: —Caandíh ñi pinatji yégueh chóo tõpnadih ñi wataá, ã niijíp jĩ. Páant ã niijíchah joinít, ĩ pinatji tõpnadih Lázarodih ĩ watap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Páant Lázarodih ã booanachah ennit, María pebh jʉinítji dawá jwĩ déewã, Jesúsdih ĩ jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Obohjeéhtih, biquína jepahcannitboó fariseowã pebhna jʉibínit, ded pah Jesús ã chãjatjidih ĩt naáwáp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Pánihna, sacerdotewã ĩ maáta, fariseowã, bita jwĩ maáta biícdih míic wáacnit, queétjeh nin pah ĩt niíj míic wéhenap wʉt jĩ: —Jesús dawá láa Dios ã wẽpatjĩh ã chãj jʉ́ʉtna caá. Pánihna, ‘Páant ma chãjca bojoó’, jwĩ niijcáh, nihat cã́acwã ãjeéh ĩ bejbipna caá. Páant dawá biícdih ĩ jʉmʉchah ennit, Jesúsdih maáh ĩ waadáát pínahdih jenah joinít, Romadih moón ĩ maáta ‘Jwiítdih yohna caá ĩ chãjap’, niijnít, jwiít judíowãboodíh ĩ peéh chãjbipna caá. Pánih peéh chãjnit, Dioíh mʉʉdíh ĩ yohat pínah niijná, ĩ́ih soldadowãdih ĩ wahbipna caá. Jwĩ́ih baácdihbʉt ĩ dʉ́ʉc wáibipna caá. Pánihna, ¿bʉʉ ded pah tigaá jwĩ chãjbi? ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Páant ĩ niijíchah yʉhna, biíc ĩjeéh jʉmni, caán jópchidih sacerdotewã ĩ maáh yoobát Caifás wʉ̃t jʉmni, queétdih nin pah ãt niíj naáwáp wʉt jĩ: —Wã déewãá, weemdíh ñi joi jwʉ́hʉʉ́. Páant niíj míic wéhena, yeéb ñi tʉ́i jéihcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nihat jwiít judíowã jwĩ tʉ́i jʉmat pínahdih biíc cã́ac ã wʉn wʉ̃hʉchah, ã tʉ́ibipna caá. Ã wʉn wʉ̃hcah, jwiít nihatdih Romadih moón ĩ maáta ĩ yoh beedábipna caá. Caandíh yeéb ñi tʉ́i beh joi jwʉ́hcan caá, Caifás ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Páant niíj naóhna, ã jenah joyátjeh niijná ãt chãjcap wʉt jĩ. Sacerdotewã ĩ maáh yoobát ã jʉmʉchah, jwĩ déewã ĩ tʉ́i jʉmat pínah niijná, Jesús ã wʉn wʉ̃hat pínahdih Diosboó Caifásdih ãt naáwát tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Obohjeéhtih, pánih wʉnna, jwiít judíowãdihjeh pohba ãt wʉn wʉ̃hcap tajĩ. Nihat baácdih moón Dios ã weh pínah biíc weh pah jwĩ jʉmat pínah niijná, jwĩ yéejat jíib Jesús ãt wʉn wʉ̃hʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Páant Caifás ã niijíchah joinít, caán yeó jáapjeh “¿Jesúsdih ded pah tigaá jwĩ mao yohbi?” queét ĩt niíj míic wéhe jwíihip tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pánihna, caandíh ĩ mao yohíhatdih jéihnit, Jesús dahwani tʉ́tchinadih jibidih ã bejíhcap jĩ. Tʉ́tchi wihcapboó bejnit, caán pebhbit Efraín wʉ̃t jʉmni bainí tʉ́tchibitna jwiítdih ã nʉmah jʉibínap jĩ. Pánih jʉibínit, caanjĩ́h jwĩ jʉm jwʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Caán láa jwiít judíowã jwĩpĩ́ wẽini Pascua yeó jáapna pínah bahnijeh ã jʉdhdʉp jĩ. Moisés ã naóh yapaatji pah, Diosdih jwĩ weñat pínah jã́tih tʉ́i míic ámohat ãpĩ́ náahap jĩ, Dios ã enechah, yéejat wihcannit jwĩ jʉmat pínah niijná. Pánihna, caandíh chãjat tʉ́ʉt niijná, dawá jwĩ déewã nihat tʉ́tchinadih moón Jerusalén tʉ́tchina ĩt aab béjep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Caán tʉ́tchina jʉibínit, queét Jesúsdih bidna ĩtih chãjap ta yʉh jĩ. Pánih bidna, Dioíh mʉʉdíh jʉmnit, queétjeh nin pah ĩt niíj míic wéhenap wʉt jĩ: —¿Pascua yeó jáapnadih Jesús enedih ã jʉ̃óhca naniít? ñi jenah joyóchah, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sacerdotewã ĩ maáta, fariseowãbʉt jã́tih nin pah cã́acwãdih ĩtát niíj wʉtʉp wʉt jĩ: “Jesús dedboó ã jʉmat doonádih joinít, jwiítdih ñi naáwá”, ĩtát niijíp wʉt jĩ. Caandíh tewat tʉ́ʉt niijná, páant ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua yeó jáapna pínah seis yeó jáap ã jʉdhdʉchah, Efraín tʉ́tchimant Betania tʉ́tchina Jesús jwiítdih ã nʉmah jwʉ́ʉb jʉibínap jĩ. Caanná jʉibínit, Lázaro wʉnniji, Jesús ã booaniíh mʉʉná jwĩ jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Páant jwĩ jʉibínachah, jwĩ jeémát pínahdih ĩ chãj wʉ̃hʉp jĩ. Pánihna, Lázaro, Jesús, jwiít biícdih jeémát cáagat naadíh jwĩ laj pʉ́ʉda bojop jĩ. Páant jwĩ laj pʉ́ʉda bojochah, Marta jwiítdih jeémát mi cáagap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maríaboó nardo wʉ̃t jʉmni chej jʉmni quiítdih, biíc kilo tac yoób ʉb jʉ̃óhnit, Jesúíh jítchanadih mi pʉhwʉp jĩ. Pʉohnit, miíh waó yoócjĩh mi jõp wiwip jĩ. Páant mi pʉhwat tʉ́ttimah, caán nihat mʉʉ́ ã tʉ́i chej jʉm chéyah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Páant mi chãjachah ennit, jwiít biícdih jʉmni Judas Iscariote wʉ̃t jʉmniboó, Jesúsdih eníhcannitdih dʉó wáini pínah, nin pah ã niijíp jĩ: ");
INSERT INTO cbv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Dépanih tigaá nint caan mácdih mi bíbohna yʉhna, mit jíib chãj wʉ̃hcan? Caandíh jíib chãjna nihna, biíc jópchi tewat pah bóo mita jíib teo tagaá. Pánihna, caán dinerojĩh moh yéejnitdih jwĩta jéih teo wáac tagaá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Obohjeéhtih, Judasboó moh yéejnitdih teo wáaquíhcan, caanjéh dinerodih náahna, nih yáana, páant ãt niijíp jĩ. Caán jwĩ́ih dinerodih en daoní jʉmna yʉhna, biquí láana ãpĩ́ nʉʉmʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Páant ã niijíchah joinít, Jesús nin pah ã niijíp jĩ: —Caántdih páant ma niijcá bojoó. Mi ámohniji chej jʉmnijĩh wĩ́ih bácahdih ĩ yohat pínah jã́tih ñáñat dée pah weemdíh páant mi pʉohna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Moh yéejnitboó páantjeh ñijeéh ĩ jʉmbipna caá. Páant ĩ jʉmʉchah, débólih wʉ̃híhna, queétdih ñi jéih wʉ̃hna caá.Obohjeéhtih, weémboó ñijeéh maatápdih wã jʉmcan niít, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús biícdih Betania tʉ́tchiboó jwĩ jʉmʉchah, dawá jwĩ déewã caandíh enedih ĩt jʉ̃ʉ́wʉ́p tajĩ. Obohjeéhtih, caandíhjeh pohba nihcan, ã booaniji Lázarodihbʉt enedih jʉ̃óhna ĩt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Páant enedih ĩ jʉibínachah jéihnit, sacerdotewã ĩ maáta Lázarodihbʉt ĩt mao yohíhip jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro wʉnnijidih ã booaat doonádih joinít, dawá jwĩ déewã Jesúsdih ĩt jepahap tajĩ. Pánih jepahnit, sacerdotewã ĩ bohéátboodíh ĩt cádahap tajĩ. Páant ĩ cádahachah ennit, sacerdotewã ĩ maátaboó íij yapnit, Lázarodihbʉt ĩtih mao yohíhip ta yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jwĩ jʉibíni daanimant bóo yeó jáapdih dawá cã́acwã Jerusalén tʉ́tchina jʉibínitji jwĩ jʉibíát pínah doonádih ĩtát joyóp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pánih joinítji táam nʉ́onadih bóodnit, Jesúsdih ĩ ʉb jwãáh dei jʉ̃ʉ́wʉ́p jĩ. Pánih jwãáh dei jʉ̃óhnit, nin pah ĩ niíj wẽi ñaacáp jĩ: —¡Diosdih jwĩ wẽi naóh jĩíh! ¡Hosana, nin Dios ã wahni jwiít judíowãdih teo wáacni pínah ã tʉ́i jʉmʉ naáh! ¡Nin jwĩ Maáh yoobát tigaá! queét ĩ niíj wẽi ñaacáp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Burrodih bid jʉinít, Jesús caanjíh ã chʉ́ʉdʉp jĩ. Pánih chʉ́ʉdna, Dios naáwátdih naóh yapaniji ã daacátji pahjeh ã yapap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalén tʉ́tchidih moón, ñi ʉ́ʉmca bojoó. Eneé, ñi Maáh burro wʉ̃ʉ́hjih chʉ́ʉdnit, ã jʉ̃óhna caá”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Obohjeéhtih, ‘Caán ã daacátji Jesúsdih niijná caá ãt chãjap’, jwiít ã bohénit jwĩ niíj jéih jwʉhcap jĩ. Pánih jéihcan yʉhna, jeáboó Jesús ã pʉ́ʉh laab béjat tʉ́ttimah, ã daacátjidih náhninit, jwĩ beh joyóp jĩ. Pánih beh joinít, “Dios naáwátdih ã daacátji biíc yoobó Jesúsdih ã yapap jĩ”, niíj jenah joinít, jwĩ yoób jéihyep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús ã ejechah, Lázaroíh bácahdih ĩ yohatji íitmant báadhni ã bac jʉ̃ʉ́wʉ́chah ennitjiboó bitadih ĩt naáwáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Caán doonádih joinítji dawá cã́acwã Jesúsdih ĩ jwãáh jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Páant dawá ĩ bejechah ennit, fariseowã queétjeh nin pah ĩt míic niijíp wʉt jĩ: —¡Eneé bʉca! Nihat Jesúíhwã míicjeh bʉʉ jʉmna caá ĩ chãjap. Queétdih jwĩ naáwáchah yʉhna, ĩ joicán caá. Pánihna, ded pah queétdih jwĩ jéih chãwácan caá, ĩt míic niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Fiesta yeó jáapnadih Diosdih weñedih jʉ̃óhnitjeéh, biquína griegowãbʉt ĩt jʉyʉ́p tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pánih jʉinít, jwĩjeéh jʉmni Felipe pebhna queét ĩt jʉyʉ́p tajĩ. Felipeboó Galilea baácdih jʉmni Betsaida wʉ̃t jʉmni tʉ́tchidih bóo ã jʉmʉp jĩ. Caan pébh jʉinít, nin pah caandíh ĩt niijíp wʉt jĩ: —Jwiít Jesúsdih jwĩ eníhna caá, ĩt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Páant ĩ niijíchah joinít, Felipe Andrésdih naáwádih ãt bejep wʉt jĩ. Queét chénat pah Jesúsdih naáwádih ĩ jʉyʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Páant ĩ naáwáchah joinít, Jesús queétdih nin pah ã niíj naáwáp jĩ: —Weém nihat cã́acwã ʉ́ʉd jeñé wã wʉnat pínah, wã boo pʉd jʉ̃ʉ́wát pínah, jeáboó wã jwʉ́ʉb bejat pínahbʉt bahnijeh ã jʉdhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nin naáwátjĩh yeebdíh wã bohébipna caá. Pácahi tíibdih jwĩ momat tʉ́ttimah, ã́ih japih bóo chóo ã moopáh bejna caá. Páant ã moopóchah, ã́ih diítmant bóo tíib ãpĩ́ chíih jʉ̃óhna caá. Pánih chíih, behna, dawá ã quehna caá. Obohjeéhtih, caán tíib moópcan, ãta chíihcan tagaá. Chíihcan, caanjéh ãta jʉm tagaá. Pánihat pah, weémboó wʉnna, wã boo pʉd jʉ̃ʉ́wát tʉ́ttimah, dawá cã́acwãdih Diosjeéh wã tʉ́i jʉmat tʉ́ʉtbipna caá. Obohjeéhtih, wʉncan, weemjéh wãta jʉm tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Det ĩ weñat pínahdihjeh jenah joiná, Dios ã weñat pínahboodíh chãjíhcan, iiguípna ĩ bejbipna caá. Obohjeéhtih, det ĩ weñat pínahdih joyáh bojnit, Diosdih tʉ́i jepahna, páantjeh ãjeéh ĩ tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Det weemdíh teo wʉ̃hnit jʉmíhna, wã naáwátdih tʉ́i joyát caá náahap. Pánih chãjna, queétbʉt wãjeéh ĩ jʉmbipna caá. Pánihna, queét weemdíh teo wʉ̃hnitdih bʉ́dí oina, wã íipbʉt ãjeéh ã tʉ́i jʉmat tʉ́ʉtbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Bʉʉ bʉ́dí wã jĩ́gahna caá. ¿Wã íipdih ded pah tigaá wã niijbí? ‘Paá, weemdíh yeejép ã yapca bojo naáh’, ¿wãta niij tániít? Caandíh páant wã niíj ʉʉ́bhcan caá. Yeejép yapnit, wʉnat tʉ́ʉt niijná, nin baácboó wã jʉ̃ʉ́wʉ́p jĩ. Pánihna, bʉʉ weemdíh chah yeejép bʉwat ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Paá, bʉʉ ded pah wẽpni ma jʉmatdih cã́acwãdih ma jéihyanaá”, Diosdih ã niijíp jĩ. Páant ã niijíchahjeh, jeámant Dios nin pah ãí niijíp jĩ: —Wã wẽpatdih queétdih wãát jʉ́ʉtʉp be. Pánihna, wã jwʉ́ʉb jʉ́ʉtbipna caá, páant mʉntih, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Páant ã niijíchah joiná, dawá caanjĩ́h joi ñʉ́hnit, ĩ joí wʉ́hi bejep jĩ. Pánih joí wʉ́hi bejnit, nin pah ĩ niijíp jĩ: —Énoh niít páant yáani, biquína ĩ niijíp jĩ. —Ángel Jesúsdih naóhna caá ã chãjap, bita ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Queét páant ĩ niijíchah joinít, Jesúsboó nin pah ã niijíp jĩ: —Jeámant wéheni wĩ́ih pínah nihcan, weém Dios ã wahni wã jʉmatdih yeéb ñi jéihyat pínah niijná, páant ãí niijíp be. ");
INSERT INTO cbv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bʉʉ nin baácdih moón yeejépwã ĩ yéej chãjat jíib wã íip queétdih ã peéh chãjbipna caá. Queétdih wʉtni nemépwã ĩ maáhdihbʉt ã yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Weemdíh cruzboó péoh dodhnit ĩ mawachah, dawá cã́acwã wĩ́ihwã pínah wã chãjbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Páant niijná, ded pah ã wʉnat pínahdih Jesús cã́acwãdih naóhna ãt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Páant ã niijíchah joinít, cã́acwãboó caandíh nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —Dios naáwátdih daácnitji nin pah ĩt niíj daacáp tajĩ: ‘Dios ã wahni Cristo páantjeh ã jʉmbipna caá’, ĩt niíj daacáp tajĩ. ¿Páant ĩ niíj daacáchah, meém nihat cã́acwã ʉ́ʉd jeñé, Dios ã wahnidih dépanihna pohba cruzboó ĩ péoh dodh mao yohcan niít? ¿Meém Dios ã wahni nihcan niít? ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Páant ĩ niijíchah joinít, Jesús queétdih nin pah ã niíj jepahap jĩ: —Weémboó baabát panihni ded pah wã íip ã jʉmatdih yeebdíh wã jéihyana caá. Obohjeéhtih, maátcanbitjeh ñijeéh wã jʉmbipna caá. Pánihna, tʉ́i jʉmat tʉ́ʉt niijná, yeebdíh wã bohéátjidih ñi quíib bʉʉdcá bojoó. Ded dʉpʉ́napboó jib bejni dedboó ã bejat pínahdih ã en jʉicán caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pánihna, weém baabát panihni wã jʉmʉchah, bʉʉ wã bejat pínah jã́tih weemdíh ñi jepahaá. Pánih jepahna, baabátboó jʉmnit panihnit wĩ́ihwã ñi jʉmbipna caá, ã niijíp jĩ. Páant niíj naóh péanit, jwiítdih ã nʉmah bac bejep jĩ. Pánih bac bejnit, queétdih ã jwei béjep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Dawá láa Dios ã wẽpatjĩh Jesús queétdih ã chãj jʉ́ʉtʉchah yʉhna, dawá jwĩ déewã caandíh ĩ joííhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dios naáwátdih naóh yapani Isaías ã naáwátji pahjeh queét ĩ chãjap jĩ. Nin pah ãt niíj daacáp tajĩ: “Maá, ma naáwátdih wã bohénachah yʉhna, cã́acwã ĩ joííhcan caá. Ma wẽpatjĩh queétdih wã chãj jʉ́ʉtʉchah yʉhna, ‘Caán naáwát yoobópdih nihcan caá’, ĩ niíj jenah joiná caá”, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Páant ĩ joííhcat ennit, Dios queétdih ã jéihyat tʉ́ʉtcan caá. Caandíhbʉt Isaías nin pah ãt niíj daacáp tajĩ: ");
INSERT INTO cbv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Jéih encannit panihnit Dios queétdih ãt chãjap wʉt jĩ. Pánih chãjnit, ã naáwátdih queétdih ãt jéihyat tʉ́ʉtcap wʉt jĩ. Pánihna, ã wẽp chãj jʉ́ʉtatdih enna yʉhna, ĩ beh encan caá. Ã bohéátdih joiná yʉhna, ĩ beh joicán caá. Ã bohéátdih jéihna nihna, ĩ yéej chãjatdih ĩta cádahji tagaá. Páant ĩ cádahachah, queétdih Dios ãta tʉ́i ʉbji tagaá”, Isaías ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Páant niíj daácna, Isaías Cristo ã wẽpat, bʉ́dí ã yeh iigátdihbʉt enniji jʉmna, ded pah Cristo ã yapat pínahdih naóh daácna ãt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Obohjeéhtih, dawá cã́acwã, biquína jwĩ maátabʉt “Caán Dios ã wahni Cristo yoobát caá”, Jesúsdih ĩt niíj jenah joyóp tajĩ. Páant niíj jenah joiná yʉhna, queét fariseowãdih ʉ́ʉmna, bita “Jesúsjeéh wã waadáp be”, ĩt niíj naáwíhcap wʉt jĩ. Páant ĩ naáwáchah nihna, jwĩ míic wáacat mʉʉná fariseowãboó queétdih ĩta waadát tʉ́ʉtjican tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Queétdih Dios ã wẽi naáwátdih náahna yʉhna, cã́acwãboó ĩ weñatdih chah ĩt bidip wʉt jĩ. Pánihna, queét “Weém Jesúíh caá”, bitadih ĩt niíj naáwíhcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tʉ́ttimah, Jesús cã́acwãdih nin pah tʉbit ã niíj ñaác naáwáp jĩ: “Ded weemdíh jepahni weemdíhjeh pohba jepahna ã chãjcan caá. Weemdíh wahnidihbʉt ã jepahna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ded weemdíh enni weemdíh wahnidihbʉt ã enna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ded dʉpʉ́napboó jʉmniji, weemdíh jepahna, baabát panihipboó ã jwʉ́ʉb jʉmat pínah niijná, weém baabát panihni nin baácboó wã jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Obohjeéhtih, ded wã naáwátdih joiná yʉhna, ã jepahcah, weémboó wã peéh chãjcan niít. Nin baácdih moón weemdíh jepahcannitdih peéh chãjadih jʉ̃óhna wã chãjcan jĩí. Obohjeéhtih, iiguípna bejnit déedih tʉ́i ʉbat tʉ́ʉt niijná, wã jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ded weemdíh náahcanni, wã naáwátdihbʉt joííhcannidih peéh chãjat ã jʉmbipna caá. Wã naáwátdih ĩ joííhcatji jíib péeni yeó jáapdih wã íipboó queétdih ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Weém wã jenah joyátjeh yeebdíh naóhna wã chãjcan caá. Wã íip weemdíh wahniboó ded pah wã naáwát pínahdih ã naáwát tʉ́ʉtna caá. Pánihna, wã naáwátboó ã naáwátjeh tigaá. ");
INSERT INTO cbv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ded ã naáwátdih joí waadána, wã íipjeéh páantjeh ã tʉ́i jʉmbipna caá. Pánihna, wã íip ã naáwát tʉ́ʉtatdihjeh tigaá, yeebdíh wã naáwáp”, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua yeó jáapna pínah jã́tihbit, Jesús nin baácdih cádahnit, ã íip pebhboó ã bejat pínah bahni ã jʉdhdatdih ãtát jéihyep tajĩ. Ã́ihwã nin baácdih moondíh bʉ́dí oina, queétdih ã oi cádahcap jĩ. Pánihna, ã oyatdih jʉ́ʉtna, ã́ihwãdih ã wʉn wʉ̃hʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Caan chéi Jesús jwiítdih ã nʉmah jeéméchah, Jesúsdih eníhcannitdih ã naáwát pínah niijná, Judas, Simón Iscariote wʉ̃ʉ́hdih nemépboó ãt waád dée tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Dios pebhmant ã jʉ̃ʉ́wátjidih, ã jwʉ́ʉb pʉ́ʉh laab béjat pínahdihbʉt Jesús ãtát jéihyep tajĩ. Ã íip caandíh chah maáh ã waadáát pínahdihbʉt ãtát jéihyep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pánih jéihna, jwĩjeéh jeémp lajniji ñah ñʉhnit, ã́ih yégueh jih bóo chóodih tóo dʉgnit, jõp wiwat pínah yégueh chóojĩh chʉ́hlit yoób ã chéwep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chéo péanit, pamapdih mah pʉoh yacnit, jwĩ́ih jítchanadih ã choc jwíihip jĩ. Pánih chocnit, ã chéo bʉ́ʉdhni chóojĩh jwĩ́ih jítchanadih ã jõp wiwip jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pánihna, biquínadih choc péa bejnit, Simón Pedro pebhna ã jʉibínap jĩ. Ã́ih jítchanadih chocat tʉ́ʉt ã chãjachahjeh, Pedroboó caandíh nin pah ã niijíp jĩ: —¿Maá, wĩ́ih jítchanadih chocodih jʉ̃óh niít ma chãjap? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Weém bʉtéh yeebdíh ded pah wã chocatdih ma jéih jwʉhcan yʉhna, tʉ́ttimah ma jéihbipna caá, Jesús caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Obohjeéhtih, wĩ́ih jítchanadih meemdíh wã chocat tʉ́ʉtcan caá, Pedro ã niijíp jĩ. —Meemdíh wã choccah, wĩ́ih ma nihcan niít, Jesús caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Pánihna, Maá, wĩ́ih jítchanadihjeh nihcan, wĩ́ih téihyanadih, wĩ́ih wao dáhdihbʉt ma chocoó bácah, Pedro ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Ded jẽ́ehna, nihat ã́ih bácahdih ã tʉ́i chocna caá. Caandíh chéne jwʉ́ʉb chocat ã náahcan caá. Ã́ih jítchanadihjeh chocat caá náahap. Pánihna, yeébboó jẽ́ehnit panihnit ñi jʉmʉchah yʉhna, biíc ñijeéh jʉmni jẽ́ehcanni panihni ã yéejatdih cádahcanni ã jʉmna caá, Jesús Pedrodih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Páant niijná, Jesús caandíh eníhcannitdih dʉó wáini pínahdih jéihnit, jwiítdih páant ãt niijíp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jwĩ́ih jítchanadih choc péanit, ã́ih yégueh chóodih jwʉ́ʉb dʉonít, ã lajapjina ã jwʉ́ʉb jʉí lajap jĩ, páant mʉntih. Pánih jwʉ́ʉb jʉí lajnit, nin pah jwiítdih ã niíj naáwáp jĩ: —¿Bʉtéh yeebdíh wã chocatjidih ñi jéih niít? ");
INSERT INTO cbv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yeéb weemdíh ‘Bohéní’, niijná, ‘Maá’, niijná, yoobópdih niij tígaá ñi chãjap. Weém yeebdíh bohéni, ñi Maáh yoobát tigaá. ");
INSERT INTO cbv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Páant yeebdíh bohéni, ñi Maáh jʉmna yʉhna, teo wʉ̃hnit ĩpĩ́ chãjat pah ñíih jítchanadih wã chocna beé. Páant wã chãjachah ennitji jʉmna, yeebbʉ́t ñíih jítchanadih míic chocat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ded pah ñijeéh jʉmnitdih ñi teo wáacat pínahdih bʉtéh wã jʉ́ʉtʉp be. Pánihna, yeebdíh ded pah wã chãjatji pah yeebbʉ́t biíc yoobó ñi chãjaá. ");
INSERT INTO cbv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yoobópdih yeebdíh wã naóhna caá. Ded teo wʉ̃hniboó ã maáh chah nihcan caá. Ded ã wahniboó caandíh wahni chah nihcan caá.Obohjeéhtih, yeéb chah jʉmna yʉhna, yeebdíh teo wʉ̃hni pah ñíih jítchanadih yeebdíh wã choc wʉ̃hʉp be. Pánihna, wã chãjatjidih ennitji biíc yoobó ñi chãjaá. ");
INSERT INTO cbv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Páant wã wʉtatdih jéihnit, chãjna, bʉ́dí ñi wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Obohjeéhtih, yeéb nihatdih páant wã niijcán caá. Det wã ñíonitdih wã tʉ́i jéihna caá. Dios naáwátdih naóh yapanit ĩ daacátji biíc yoobó ã yapbipna caá. ‘Wãjeéh jeémpnijeh tigaá weemdíh yeejép ã chãjbipna caá’, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Páant ã chãjat pínah jã́tih yeebdíh naóhna caá wã chãjap, páant ã yapat tʉ́ttimah, ‘Caán Jesús, Dios ã wahni Cristo ta tigaá’, ñi niíj jéihyat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nindihbʉt yoobópdih yeebdíh wã naóhna caá. Wã wahnidih ded tʉ́i wẽi jwãáhni, weemdíhbʉt ã tʉ́i wẽi jwãáhna caá. Pánih weemdíh wẽi jwãáhni, weemdíh wahnijidihbʉt ã wẽi jwãáhna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Páant niíj péanit, Jesús bʉ́dí ã jĩ́gahap jĩ. Pánih jĩ́gahnit, jwiítdih nin pah ã niijíp jĩ: —Yoobópdih yeebdíh wã naóhna caá. Biíc ñi cãtíh jʉmni weemdíh eníhcannitdih ã dʉó wáibipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Páant ã niijíchah joinít, caandíh jʉ́ʉtni pínahdih jéihcan, jwiítjeh jwĩ míic en jã́hanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Weém, Jesús bʉ́dí ã oiniboó caandíh wã dodh jã́ah lajap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pánihna, Simón Pedro weemdíh ã́ih téihyajĩh jenah jʉ́ʉtnit, nin pah ã niijíp jĩ: —Caandíh ma ʉʉ́bh joí eneé dedna tigaá caandíh dʉó wáini pínah, weemdíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Páant ã niijíchah joinít, weémboó Jesúsdih jwʉ́ʉb dodh jã́ah lajnit, caandíh nin pah wã niíj ʉʉ́bh joyóp jĩ: —¿Maá, deddih niij tígaá ma chãj? wã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Nin pandih dajnit wã neéh wʉ̃hni pínah weemdíh eníhcannitdih ã dʉó wáibipna caá, weemdíh Jesús ã niíj jepahap jĩ. Páant niíj péanitjeh, pan dahdih daj ʉb neéhnit, Judas, Simón Iscariote wʉ̃ʉ́hdih ã wʉ̃hʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Páant Jesús ã daj neéh wʉ̃hni pandih Judas ã jeéméchah, nemépboó caandíh yeejép ãt chãjat tʉ́ʉtʉp tajĩ. Pánih jéihna, Jesús caandíh nin pah ã niijíp jĩ: —Ded pah ma chãjat pínahdih waícanjeh chãjadih ma bejeé, Judasdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Páant Judasdih ã niijíchah joiná yʉhna, jwiít nihat jwĩ jéihcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pánih jéihcan, “Judas jwĩ́ih dinerodih en daoní ã jʉmʉchah, jwĩ jeémát pínahdih jíib chãjat tʉ́ʉtna, Jesús páant ã niíj wahna caá”, biquína ĩt niíj jenah joyóp ta yʉh jĩ. Bitaboó “Moh yéejnitdih dinero wʉ̃hat tʉ́ʉtna caá ãt chãjap”, ĩt niíj jenah joyóp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pánihna, Jesús ã neéh wʉ̃hni pandih jeémp péanit, Judas ã bac bejep jĩ. Páant ã bac bejechah, chei wãát jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Páant Judas ã bac bejat tʉ́ttimah, Jesús jwiítdih nin pah ã niíj naáwáp jĩ: —Bʉʉ láa bácah weém nihat cã́acwã ʉ́ʉd jeñé wã íip ã wahni wã jʉmatdih, wã wẽpatdihbʉt cã́acwãdih ã jéihyabipna caá. Caán ã wẽpatdih weembʉ́t queétdih wã jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Páant wã íip ã wẽpatdih wã jéihyanachah, caán wã wẽpatdihbʉt waícanjeh ã jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yeéb wã weh panihnit, nindihbʉt wã naáwáchah ñi tʉ́i joyoó. Daocánni yeó jáapbitjeh ñijeéh wã jʉm jwʉhbipna caá. Wã bejat tʉ́ttimah, weemdíh bʉ́dí ñi bidbipna caá. Jwĩ déewãdih wã niijátji pah yeebdíhbʉt biíc yoobó niijnít, ‘Wã bejep pínahna yeébboó ñi jéih bejcan caá’, wã niijná caá. ");
INSERT INTO cbv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pánihna, jáap wʉtatdih yeebdíh wã naóhna caá. Yeebjéh ñi míic oyoó. Yeebdíh wã oyatji pah, yeebjéhbʉt ñi míic oyoó. ");
INSERT INTO cbv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Páant ñi míic oyochah ennit, wĩ́ihwã ñi jʉmatdih bita ĩ jéihbipna caá, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Páant ã niijíchah joinít, Simón Pedro Jesúsdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Maá, dedboo tígaá ma bejbi, páant ma niijná? ã niijíp jĩ. —Wã bejat pínahna wãjeéh ma jéih bej jwʉhcan caá. Obohjeéhtih, bʉʉ jéih bejcan yʉhna, tʉ́ttimah wã pebhna ma jʉibíbipna caá, Pedrodih Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—¿Maá, dépanih tigaá bʉʉ majeéh wã jéih bejcan? Weemdíh ĩ mawachah yʉhna, meemdíh wã cádahcan niít, Pedro ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Páant niijná, ¿weemdíh wapna, ma wʉn wʉ̃hmi naniít? Obohjeéhtih, yoobópdih meemdíh wã naóhna caá. Mʉjbai ã ewat pínah jã́tih, ‘Caandíh wã jéihcan caá’, biíc peihcanni láa pohba bitadih ma niíj yeebipna caá, Jesús Pedrodih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tʉ́ttimah, Jesús jwiítdih nin pah ã niijíp jĩ: “Bʉtéh wã niijátdih náhninit, ñi jĩ́gahca bojoó. Wã íipdih tʉ́i jenah joinít, weemdíhbʉt biíc yoobó ñi tʉ́i jenah joyoó. ");
INSERT INTO cbv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wã íip ã jʉmʉpboó dawá jʉmat pínah mʉʉná ã jʉmna caá. Pánihna, caanná jʉibínit, ñi jʉmat pínahdih ámohodih wã bejbipna caá. Wã naáwát pah biíc yoobó ã wihcah, páant yeebdíh wãta niíj naóhcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yeéb ñi jʉmat pínahdih tʉ́i ámoh péanit, yeebdíh ʉbʉdih wã jwʉ́ʉb dei jʉ̃óhbipna caá, wãjeéh ñi jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wã bejat pínah namá panihnidih ñi jéihna caá”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Maá, deh ma bejat pínahboó jwiít jwĩ jéihcan caá. ¿Ded pah tigaá caán namá panihnidih jwĩ jéihbi? Tomás Jesúsdih ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Weemjéh tigaá namá panihni wã jʉmʉp, wã íip pebhboó ñi jʉibíát pínah niijná. Weemjéh mʉn tigaá yoobópdih naóhni. Jeáboó jʉibínit pínahdih weemjéh mʉn tigaá caolih booani wã jʉmna caá. Caolih wã booanit míicjeh wã íip pebhboó páantjeh ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Weemdíh tʉ́i jéihna nihna, wã íipdihbʉt ñita jéih tagaá. Pánihna, bʉʉ caandíh ennit panihnit jʉmna, caandíh ñi tʉ́i jéihna caá bʉca, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Páant ã niijíchah joinít, Felipe jwʉh nin pah ã niijíp jĩ: —Maá, jwĩ íipdih jwiítdih ma jʉ́ʉtʉ́. Páant bóojeh tigaá jwĩ eníhip, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—¿Felipe, maatápdih wãjeéh jʉmna yʉhna, weemdíh ma tʉ́i jéih jwʉhcan niít? Weemdíh enna, wã íipdihbʉt maát enep be. ‘Jwĩ íipdih ma jʉ́ʉtʉ́’, niijná, ¿dépanih tigaá weemdíh páant ma niíj? ");
INSERT INTO cbv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Weém wã íipjĩh chénewã jʉmna yʉhna, biícjeh caá. ¿‘Páant caán yoobópdih nihcan caá’, ma niíj jenah joicáh? Yeebdíh naóhna, wã jenah joyátjĩh wãpĩ́ naóhcan caá. Wã íip ã naáwát tʉ́ʉtʉchahjeh, wã naóhna caá. Pánihna, caán biícdih jʉmna, ã wẽpatjĩh wãpĩ́ chãj jʉ́ʉtna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Weém wã íipjĩh chénewã jʉmna yʉhna, biícjeh caá. Caán ‘Yoobópdih tigaá’, niíj jenah joicán, wã íip ã wẽpatjĩh wã chãj jʉ́ʉtatjidih náhninit, biícjeh jwĩ jʉmatdih ñi jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yoobópdih yeebdíh wã naóhna caá. Det weemdíh tʉ́i jenah joinít wã chãjat pah biíc yoobó ĩ chãjbipna caá. Bʉʉ wã íip pebhboó jwʉ́ʉb bejna, wã chãjat chah pohba wã íip ã wẽpatjĩh ĩ chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Weemdíh tʉ́i jenah joinít ĩ ʉʉ́bát pah wã chãjbipna caá, wã íip ã wẽpatdih cã́acwã ĩ jéihyat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pánihna, weemdíh jepahnit ñi jʉmʉchah, dedé ñi ʉʉ́bát biíc yoobó wã chãjbipna caá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Yeéb weemdíh oina, wã wʉtatdih ñi jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yeebdíh Tʉ́ini Espíritu ã wahat pínah niijná, wã íipdih wã ʉʉ́bhbipna caá, wã wihcah, ñijeéh ã jʉmat pínah niijná. Caán Tʉ́ini Espíritu yeebdíh teo wáacniboó yoobópdih naóhni jʉmna, yeó jáap jʉmat pah ñijeéh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nin baácdih moón wã íipdih jéihcannit, caán Tʉ́ini Espíritudihbʉt ĩ jéihcan caá. Pánih jéihcan, caandíh ĩ tʉ́i jenah joicán caá. Obohjeéhtih, caán ñijeéh jʉmni pínahdih yeébboó ñi tʉ́i jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Yeebdíh wã éemp bejcan niít. Pánih éemp bejcan, caán Tʉ́ini Espíritu yeebdíh ã jʉyʉ́chah, weém wã jʉmat pahjeh mʉntih ñijeéh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wã bejat pínah bahnijeh ã jʉdhna caá. Páant wã bejat tʉ́ttimah, nin baácdih moón weemdíh jepahcannit, weemdíh ĩ jwʉ́ʉb encan niít. Obohjeéhtih, yeébboó weemdíh ñi enbipna caá. Weém jwʉ́ʉb boo pʉd jʉ̃óhni wã jʉmat pah mʉntih, yeebbʉ́t jwʉ́ʉb boonit Diosjeéh páantjeh ñi jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jwĩ wahni Tʉ́ini Espíritu yeebdíh jʉinít, wã íip biícdih wã jʉmatdih yeebdíh ã tʉ́i jéihyabipna caá. Pánihna, wã íip biícdih wã jʉmat pah mʉntih, yeéb biícdih wã jʉmatdihbʉt ã jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ded wã wʉtatdih joí waadáni weemdíh oini caá.Weemdíh oinidih wã íipbʉt ã oibipna caá. Weembʉ́t caandíh biíc yoobó wã oibipna caá. Páant weemdíh oinidih ded pah wã jʉmatdih wã tʉ́i jéihyabipna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jwĩjeéh jʉmni biíh Judas, Iscariote nihcanni, Jesúsdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Maá, dépanihna jwiítdihjeh páant ma jéihyana yʉhna, bita meemdíh jepahcannitboodíh ma jéihyabican? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Ded weemdíh oini wã naáwátdih ã tʉ́i joí waadábipna caá. Páant ã tʉ́i joí waadánachah, wã íip caandíh ã oibipna caá. Pánih oina, wã íip biícdih ã́ih caolihdih waadnít, ãjeéh jwĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Obohjeéhtih, weemdíh oicanniboó wã wʉtatdih ã jepahcan caá. Páant ã jepahcah, ãjeéh jwĩ wihcan niít. Bʉtéh ñi joiní weemjéh wã naáwát pohba nihcan caá. Obohjeéhtih, wã íip weemdíh wahnijeh páant ã naáwát tʉ́ʉtʉp be. ");
INSERT INTO cbv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ñijeéh jʉm jwʉhna, páant yeebdíh wãát niíj naáwáp be. ");
INSERT INTO cbv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Obohjeéhtih, tʉ́ttimah wã íipdih wã ʉʉ́bʉ́chah, Tʉ́ini Espíritudih yeebdíh ã wahbipna caá. Pánihna, caán Tʉ́ini Espíritu yeebdíh teo wáacni jʉmna, ã tʉ́i bohébipna caá. Pánih bohénit, nihat yeebdíh wã naáwátjidih ã náhniabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Yeebdíh wã tʉ́i jʉmat tʉ́ʉtna caá. Weém wã tʉ́i jʉmat pah mʉntih yeebbʉ́t ñi tʉ́i jʉmbipna caá. Wã wʉ̃hni tʉ́i jʉmat pah nin baácdih moón ĩ jéih wʉ̃hcan caá. Pánihna, bʉ́dí náhni dahwanit, ñi ʉ́ʉmca bojoó. ");
INSERT INTO cbv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Weém wã bej jwʉhbipna caá. Obohjeéhtih, ñijeéh jʉmat tʉ́ʉt niijná, wã jwʉ́ʉb dei jʉ̃óhbipna caá, páant mʉntih’, yeebdíh páant wã niíj naáwáchah, ñiát joiná jĩí. Páant wã niijíchah joinít, weemdíh yoobópdih ñi oina nihna, ñita wẽi tagaá. Wã íipboó weém chah wẽpni ã jʉmʉchah, ãjeéh jʉmnit, chah yeebdíh wã jéih teo wáacbipna caá. Páant wã chãjat pínahdih jéihna, yeebdíh weñat caá náahap. ");
INSERT INTO cbv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Weemdíh ded pah ã yapat pínahdih yeebdíh wãát naóhna jĩ, wã niijátji biíc yoobó ã yapachah, weemdíh tʉ́i jenah joinít ñi jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Yeebdíh wã míic wéhe jwʉhat pínah bahnibitjeh ã jʉdhna caá. Waícanjeh, nin baácdih moón ĩ maáh, weemdíh yeejép chãjadih ã jʉ̃óhbipna yʉh caá. Nemépwã ĩ maáh wẽpni jʉmna yʉhna, weemdíh ã jéih yap yohcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Obohjeéhtih, weemdíh wã íip ã wʉtat pahjeh wã chãjbipna caá, nihat cã́acwã caandíh wã oyatdih ĩ jéihyat pínah niijná. Ñi ñah ñʉhʉʉ́. Chóbe bejjĩh”, Jesús jwiítdih ã niijíp yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Páant niijná yʉhna, nin pah jwiítdih ã jwʉ́ʉb niíj bohénap jĩ, páant mʉntih: “Weém jiwá iguíh pʉ́ʉj panihni, wã íipboó iguíhadih en daoní panihni, wĩ́ih cã́acwã iguíh pihna panihnit ĩ jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Quehcanni pihdih iguíhadih en daoní ã bóod yohbipna caá. Páant ã bóod yohat pah, det weemdíh tʉ́i jenah joicánnitdih wã íip ã yohbipna caá. Ded tʉ́i quehni pihboodíh ã bóod ámohna caá, dawá ã quehat pínah niijná. Páant ã chãjat pah det wĩ́ihwã ĩ náahatdihjeh ĩ chãjachah enna, wã íip queétdih ã cádahat tʉ́ʉtbipna caá, ded pah wã náah yacatboodíh ĩ chãjat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yeébboó wã naáwátdih joí jepahnit, bóod ámohni panihnit ñi jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tʉ́i biícdih wãjeéh ñi jʉmʉʉ́. Páant wãjeéh ñi jʉmʉchah, weembʉ́t yeéb biícdih wã jʉmbipna caá. Ded iguíh pih ã́ih pʉ́ʉjdih tʉ́i dʉʉj lájcan, ã jéih quehcan caá. Pánihat pah, yeebbʉ́t weemdíh tʉ́i joicán, wã wẽpat ã wihcah, wã weñat pínahdih ñi jéih chãjcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Weém jiwá iguíh pʉ́ʉj panihni, yeébboó ã́ih pihna panihnit caá ñi jʉmʉp. Ded weemdíh tʉ́i joiní wãjeéh tʉ́i biícdih ã jʉmʉchah, weembʉ́t ãjeéh tʉ́i biícdih wã jʉmbipna caá. Pánih jʉmna, tʉ́i quehni pih panihni wã weñat pínahdih ã tʉ́i chãjbipna caá. Obohjeéhtih, weemdíh joicánnitboó, wã weñat pínahdih ĩ jéih chãjcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ded wʉn jʉ̃óhni pihdih ã yohat pah, weemdíh cádahni, wãjeéh tʉ́i jʉmcannidih wã íip ã yohbipna caá. Pánihna, caán yohni iguíh pihna ã diib téhechah, iguíhadih en daoníboó caán tehni pihnadih wao wáacnit, ã cáo yohbipna caá. Páant ã chãjat pah, weemdíh cádahnitdih Dios peéh chãjna, iiguípna ã yohbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Yeéb weemdíh cádahcan, wã naáwátdih tʉ́i joiná, ded ñi náahatdih ñi ʉʉ́bʉ́chah, biíc yoobó wã chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wã weñat pínahdih ñi chãjachah ennit, ‘Queét Jesúíhwã caá’, bita ĩ niíj jéihbipna caá. Páant niíj jéihnit, wã íipdihbʉt ĩ wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Wã íip weemdíh ded pah ã oyat pah mʉntih weembʉ́t yeebdíh biíc yoobó wã oina caá. Páant yeebdíh wã oyatdih ñi tʉ́i náhninaá. ");
INSERT INTO cbv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wã íip weemdíh ded pah ã wʉtʉchah, caandíh jepahna, ã oyatjĩh ãjeéh wã tʉ́i jʉmna caá. Páant wã chãjat pah, weem jwʉ́h yeebdíh ded pah wã wʉtatdih jepahna, wã oyatjĩh wãjeéh ñi tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Páant yeebdíh wã naóhna caá, wãjeéh tʉ́i jʉmnit, bʉ́dí ñi weñat pínah niijná. Bainí ñi wẽican niít. ");
INSERT INTO cbv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nin pah yeebdíh wã niíj wʉtna caá: Yeebdíh wã oyat pahjeh mʉntih, yeebjéhbʉt ñi míic oyoó. ");
INSERT INTO cbv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ded ã chéendih bʉ́dí oina, caanjéh ã wʉnat pínah tobohochah yʉhna, caandíh ã tʉ́i teo wáacbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ded pah wã wʉtatdih jepahna, yeébboó wã chéenwã ñi jʉmna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wã chéenwã yoobát ñi jʉmʉchah, ‘queét wã pebh moonjéh caá’, yeebdíh wã niijcán caá. Ĩ maáh ded pah ã chãjatdih ã pebh moón ĩ jéihcan caá. Obohjeéhtih, wã chéenwã ñi jʉmʉchah, ded pah wã íip ã naáwátdih yeébboodíh wãát naóh yapanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yeéb weemdíh ñi ñíocan beé. Obohjeéhtih, weémboó yeebdíh wã ñíwip jĩ, wã íipíhwã jʉmna, ã wʉtatdih jepahnit, ñi tʉ́i chãj cádahcatdih ennit, bitabʉt Diosdih ĩ jepahat pínah niijná. Pánih tʉ́i chãj cádahcannit, wĩ́ihwã jʉmna, ded pah wã íipdih ñi ʉʉ́bʉ́chah, yeebdíh ã wʉ̃hbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pánihna, nin pah yeebdíh wã jwʉ́ʉb wʉtna caá: Yeebjéh ñi míic oyoó”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nin baácdih moón yeebdíh ĩ iináchah, weemdíhbʉt ĩ iiátjidih ñi tʉ́i náhninaá. ");
INSERT INTO cbv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Diosdih jepahcannit ñi jʉmʉchah nihna, queétjeh ĩ míic oyat pahjeh, yeebdíhbʉt ĩta oi tagaá. Obohjeéhtih, yeéb wã ñíonit jʉmna, ded pah queét ĩ chãjat pah biíc yoobó ñi chãjcatdih ennit, yeebdíh ĩ eníhcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Wĩ́ihwã jʉmna, weem cháh ñi jʉmcan caá’, yeebdíh wã niijátjidih ñi tʉ́i náhninaá. Pánih weém nʉmp jʉmna, weemdíh yeejép ĩ chãjat pahjeh yeebdíhbʉt biíc yoobó ĩ chãjbipna caá. Bitaboó wã bohéátdih jepahnit, yeebbʉ́t queétdih ñi bohénachah, ĩ jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pánihna, nin baácdih moón weemdíh wahnidih ĩ jéihcat jíib, yeéb wĩ́ihwã ñi jʉmʉchah ennit, yeebdíhbʉt yeejép ĩ chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Queétdih bohénadih wã jʉ̃óhcah, weemdíh ĩ náahcatji jíib queétdih peéh chãjat ãta wihcan tagaá. Obohjeéhtih, bʉʉ queétdih wã bohéát tʉ́ttimah, ‘Yéejat jíib weemdíh ã wihcan caá’, queét ĩ jéih niijcán caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ded weemdíh eníhcanni wã íipdihbʉt eníhcanni caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wã íip ã wẽpatjĩh cã́acwã ĩ jéih chãjca naáhdih wã chãj jʉ́ʉtʉp be. Páant wã chãj jʉ́ʉtcah, queétdih yéejat jíib ãta wihcan tagaá. Obohjeéhtih, wã chãj jʉ́ʉtatdih enna yʉhna, weemdíh, wã íipdihbʉt ĩ eníhcan caá. Páant ĩ eníhcat jíib, Dios queétdih ã peéh chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pánih eníhcan, Dios naáwátdih naóh yapanit ĩ daacátji biíc yoobó chãjna caá ĩ chãjap. ‘Queétdih yeejép wã chãjcah yʉhna, weemdíh ĩ eníhcan caá’, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tʉ́ttimah, wã íipjeéh jʉmni Tʉ́ini Espíritudih wã wahbipna caá, yeebdíh ã teo wáacat pínah niijná. Yeebdíh yoobópdih naóhni pínah jʉmna, yeebdíh ded pah wã jʉmatdih ã tʉ́i jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Cã́acwãdih wã bohé jwíihichah, yeéb wãjeéh ñiát jʉmʉp jĩ. Pánih wãjeéh jʉmnit, ded pah wã chãjatdih ennitji yeeb jwʉ́h bitadih naáwát caá náahap. ");
INSERT INTO cbv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Bʉtéh yeebdíh ded pah ã yapat pínahdih wã naáwáp be, caandíh tʉ́i náhninit, biíc yoobó yeebdíh ã yapachah, weemdíh ñi cádahcat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tʉ́ttimah, wĩ́ihwã ñi jʉmat jíib, ñi maáta jwĩ míic wáacat mʉʉná ĩ waadát tʉ́ʉtcan niít. Biíh láa ded yeebdíh mao yohna, ‘Dios ã náahat pah chãjna caá wã chãjap’, ã niíj jenah joibípna yʉh caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wã íipdih, weemdíhbʉt ĩ jéihcat jíib páant ĩ chãjbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pánihna, yeebdíh yeejép ã yapachah enna, ‘Páant ã yapat pínahdih Jesús jwiítdih ã naáwáp jĩ’, ñi niíj náhnibipna caá. Caandíh ñi náhniat pínah niijná, bʉʉ yeebdíh wã naóhna caá”, Jesús jwiítdih ã niijíp jĩ. “Weemdíh ñi jwíih pej jʉm láa weémboó ñijeéh jʉmna, bʉtéh wã bohéátdih yeebdíh wã naóh jwʉhcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Obohjeéhtih, bʉʉ weemdíh wah deyani pebhboó wã jwʉ́ʉb béjat pínah bahnijeh ã jʉdhdʉchah, yeebdíh páant wã naóhna caá. Obohjeéhtih, ‘¿Dee tígaá ma bejbi?’ weemdíh ñi niíj ʉʉ́bh joicán caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wã pʉ́ʉh laab béjat pínahdih yeebdíh wã naáwáchah, bʉ́dí ñi jĩ́gahna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Obohjeéhtih, tʉbit ñi jĩ́gahcat pínah niijná, yeebdíh yoobópdih wã naóhna caá. Wã pʉ́ʉh laab béjat tʉ́ttimah, yeebdíh teo wáacni pínah, Tʉ́ini Espíritudih wã wahachah, chah ñi tʉ́i jʉmbipna caá. Wã pʉ́ʉh laab béjcah, yeebdíh teo wáacni pínahboó ãta jʉ̃óhcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wã wahachah, caán dei jʉiná, nin baácdih moón ĩ yéejatdih queétdih ã jéihyabipna caá. Ded pah tʉ́i chãjat pínahdihbʉt ã jéihyabipna caá. Yéej chãjnitdih ĩ yéejat jíib Dios ã peéh chãjat pínahdihbʉt caán ã jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Caán Tʉ́ini Espíritu cã́acwãdih nin pah ã niíj jéihyabipna caá: ‘Jesucristodih ma jepahcat caá ma yéejat’, ã niijbípna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wã íip pebhboó wã jwʉ́ʉb bejat tʉ́ttimah, cã́acwã weemdíh ĩ jwʉ́ʉb encah, Teo Wáacni jwʉh queétdih ã bohébipna caá, ded pah ĩ tʉ́i jʉmat pínahdih ĩ jéihyat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nin baácdih moón ĩ maáh nemépdih Dios ã peéh chãjat pínahdih Tʉ́ini Espíritu ã jéihyabipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Bʉ́dí caá yeebdíh wã naáwát pínah ã jʉdhdʉp. Obohjeéhtih, bʉʉ caandíh wã naáwáchah, ñita beh joicán tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Páant wã naóhcah yʉhna, Tʉ́ini Espírituboó yeebdíh ã jéihyabipna caá. Caán ã jenah joyátjeh ã naóhcan niít. Obohjeéhtih, wã íip caandíh ã naáwát tʉ́ʉtʉchah, yeebdíh yoobópdih ã naóh beedábipna caá. Tʉ́ttimah ded pah ã yapat pínahdihbʉt ã bohébipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pánihna, ded pah wã jʉmatdih ã naáwáchah joinít, yeébboó weemdíh bʉ́dí ñi wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wã íip ã jéihyat pah, weembʉ́t wã jéihna caá. Páant tigaá ‘Tʉ́ini Espíritu ded pah wã jʉmatdih ã jéihyabipna caá’, yeebdíh wã niíj naáwáp be. ");
INSERT INTO cbv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Bahnibitjeh weemdíh ñi en jwʉhbipna caá. Obohjeéhtih, maátcanjeh encannitji, weemdíh ñi jwʉ́ʉb enbipna caá, páant mʉntih”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Páant ã niijíchah joinít, jwiít biquína nin pah jwĩ míic niíj ʉʉ́bh joyóp jĩ: —‘Bahnibitjeh weemdíh ñi en jwʉhbipna caá. Obohjeéhtih, maátcanjeh encannitji, weemdíh ñi jwʉ́ʉb enbipna caá, páant mʉntih’, niijná, ¿ded pah niij tígaá páant ã niíj? ‘Wã íip pebhboó wã jwʉ́ʉb pʉ́ʉh laab béjbipna caá’, niijná, ¿ded pah ã chãjat pínahdih niíj naóh tigaá jwiítdih páant ã niíj? ");
INSERT INTO cbv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Bahnibitjeh’, ‘maátcanjeh’, niijná, ¿ded pah niij tígaá ã chãj? Obohjeéhtih, jwĩ beh joicán caá, jwĩ míic niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Páant niijnít, caandíh jwĩ ʉʉ́bh joííhatdih jéihna, Jesús nin pah jwiítdih ã niíj naáwáp jĩ: —‘Bahnibitjeh weemdíh ñi en jwʉhbipna caá. Obohjeéhtih, maátcanjeh encannitji, weemdíh ñi jwʉ́ʉb enbipna caá páant mʉntih’, ¿wã niijátdih beh joicán, ʉʉ́bh joííh niít ñi chãjap? ");
INSERT INTO cbv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yoobópdih yeebdíh wã naóhna caá. Wã wʉnat pínah bahnibitjeh ã jʉdhna caá. Pánihna, wã wʉnʉchah enna, bʉ́dí ñi jʉ̃ibípna caá. Obohjeéhtih, weemdíh eníhcannitboó bʉ́dí ĩ wẽibipna caá. Yeébboó bʉ́dí jĩ́gahnitji, tʉ́ttimahbitjeh ñi jwʉ́ʉb wẽibipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nin pah ã jʉmna caá: Yad wili mi weép jáana, yeejép mi yapat pínah ã jʉmʉchah, bʉ́dí mi jĩ́gahna caá. Pánih jĩ́gahna yʉhna, mi weép jʉmat tʉ́ttimah, caántdih ã tʉbatjidih náhnican, wébít ã cã́ac jʉmʉchah ennit, bʉ́dí mi wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Páant mi jʉmat pah tigaá bʉʉ yeéb ñi jĩ́gahbipna caá. Tʉ́ttimah, yeebdíh wã jwʉ́ʉb enechah, yeebbʉ́t bʉ́dí ñi jwʉ́ʉb wẽibipna caá. Páant ñi weñechah, det yeebdíh ĩ jéih jwʉ́ʉb jĩ́gahacan niít. ");
INSERT INTO cbv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Weemdíh ñi jwʉ́ʉb enni yeó jáapdih tʉ́i beh joinít jʉmna, weemdíh ñi ʉʉ́bh joicán niít. Yoobópdih yeebdíh wã naóhna caá. Wĩ́ihwã jʉmna, wã wẽpatjĩh ñi ʉʉ́bʉ́chah, wã íip yeebdíh ã jepahbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jã́tih wã íipdih páant ñi ʉʉ́bh jwʉhcap jĩ. Obohjeéhtih, yeebdíh wã wʉn wʉ̃hat tʉ́ttimah, wĩ́ihwã jʉmna, páant caandíh ñi ʉʉ́bʉ́. Páant ñi ʉʉ́bʉ́chah, ñi ʉʉ́bátdih ã wʉ̃hbipna caá, bʉ́dí ñi weñat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Jã́tih wã jenah joiní naáwátjĩhjeh yeebdíh wã bohénachah, ñi tʉ́i beh joicán beé. Obohjeéhtih, wã boo pʉd jʉ̃ʉ́wát tʉ́ttimah, ded pah jwĩ íip ã jʉmatdih tʉ́i bʉocannijeh wã naóhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Caán láa wĩ́ihwã jʉmna, wã wẽpatjĩh yeebjéh wã íipdih ñi ʉʉ́bhbipna caá. Weémboó ñíih pínahdih wã jwʉ́ʉb ʉʉ́bh wʉ̃hcan niít. ");
INSERT INTO cbv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pánihna, wã íip pebhmant jʉ̃óhni wã jʉmʉchah ‘Yoobópdih tigaá’, niíj jenah joinít, weemdíh ñi oyochah ennit, wã íipboó yeebdíhbʉt ã oibipna caá. Páant ã oyatdih jéihnit, yeebjéh caandíh ñi ʉʉ́bhbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Weém wã íip biícdih jʉmniji nin baácboó wã jʉ̃ʉ́wʉ́p jĩ. Pánihna, bʉʉ nin baácboó jʉm jwʉhni wã íip pebhboó wã jwʉ́ʉb pʉ́ʉh laab béjbipna caá”, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Páant ã niijíchah joinít, jwiít caandíh nin pah jwĩ niijíp jĩ: —Bʉʉ bácah ma jenah joiní naáwátjĩhjeh bohécan, bʉocannijeh jwiítdih ma naóhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pánihna, meém jéih beedáni ma jʉmatdih bʉʉ jwʉhna jwĩ jéihna caá. Ded meemdíh bohéni pínah ã wihcan caá. Páant tigaá Dios pebhmant jʉ̃óhni ma jʉmatdih jwĩ tʉ́i jéihna caá, jwĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","—Bʉʉ ‘Yoobópdih Dios pebhmant jʉ̃óhni tigaá ãt jʉmʉp’, ¿ñi niíj niít bʉca? ");
INSERT INTO cbv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Páant niijnítji yʉhna, bʉʉ cheijeh nihat yeéb ñíih mʉʉnáboó ñi jweí jwʉ́ʉb bejechah, weém biícjeh wã chãobípna caá. Obohjeéhtih, biícjeh pohba wã nihcan niít. Weemdíh ñi yoh bejechah yʉhna, wã íipboó wãjeéh ã jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Páant wã yapat pínah jã́tih yeebdíh naóhna caá wã chãjap, jĩ́gahcanjeh ñi tʉ́i jʉmat pínah niijná. Nin baácboó ñi jʉm jwʉhʉchah, Diosdih náahcannit yeebdíh yeejép ĩ chãjbipna caá. Obohjeéhtih, nin baácdih moón ĩ yéej chãjatdih yap yohni wã jʉmatdih jéihnit, bʉ́dí ñi weñeé, jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Páant niíj péanit, Jesús jeáboó chéi ennit, Diosdih nin pah ã niíj ʉʉ́bʉ́p jĩ: “Paá, bʉʉ ma niijátji pah tih weemdíh ĩ mawat pínah ã jʉiná caá. Pánihna, weém ma wʉ̃ʉ́h wã jʉmatdih cã́acwãdih ma jéihyanaá, weemdíh ĩ weñat pínah niijná. Páant ma chãjachah, weem jwʉ́h meemdíhbʉt queétdih wã weñat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nihat cã́acwã ĩ maáh weemdíh ma waadánap be. Pánih maáh jʉmna, det weemdíh ma wʉ̃hnitdih majeéh wã jʉmat tʉ́ʉtbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Det meém Dios biícjeh jʉmnidih jéihna, weém ma wahnidihbʉt jéihna, japboó jwĩjeéh biícdih páantjeh ĩ tʉ́i jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Nin baácboó jʉm jwʉhna, ma chãjat tʉ́ʉtatjidih wã chãj péanap be. Pánih chãjna, ded pah ma jʉmatdih cã́acwãdih wã tʉ́i jéihyanap be, meemdíh ĩ weñat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pánihna, nin baácdih jwĩ chãjat pínah jã́tih, majeéh biícdih jʉm jwʉhna, biíc yoobó jwĩpĩ́ wʉtat pah mʉntih, weemdíh ma jwʉ́ʉb maáh waadánaá. ");
INSERT INTO cbv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Paá, nit wĩ́ihwãdih jwʉh wã ʉʉ́bhna caá. Nit weemdíh ma wʉ̃hnit nin baácboó yeejépwã cãtíh ĩ jʉmʉchah yʉhna, queétdih ded pah ma jʉmatdih wã jéihyanap be. Queét míihwãdih weemdíh ma wʉ̃hʉchah, queét ma wʉtat pah ĩ chãjna beé. ");
INSERT INTO cbv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Weemdíh ma naáwátjidih queétdih wã bohénachah, ĩ tʉ́i wẽi joyóp be. Pánih wẽi joinít, ma pebhmant jʉ̃óhni wã jʉmatdih, ma wahni wã jʉmatdihbʉt ĩ tʉ́i jéihna caá. Pánih jéihnit, ‘Nihat jwiítdih ã bohéátjidih, nihat ã chãj jʉ́ʉtatjidihbʉt Dios ãt wʉtʉp taga’, ĩ niíj jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Paá, nit wã bohénitíh pínahdihjeh ʉʉ́bhna caá wã chãjap. Bitaíh pínahdih ʉʉ́bhna wã chãj jwʉhcan caá. Nit weemdíh ma wʉ̃hnit míihwã caá ĩ jʉmʉp. Ĩ́ih pínahdih meemdíh ʉʉ́bhna caá wã chãjap. ");
INSERT INTO cbv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nit wĩ́ihwã nihat míihwã mʉn tigaá. Pánihna, míihwãboó wĩ́ihwã mʉn tigaá. Weemdíh jepahna, ĩ tʉ́ʉt nʉʉmʉ́chah ennit, bitabʉt weemdíh ĩ wẽina caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Bʉʉ nin baácboó wã chãocán niít. Ma pebhna jwʉ́ʉb bejat tʉ́ʉt caá wã chãjap. Páant ma pebhna wã jwʉ́ʉb bejechah yʉhna, nit weemdíh ma wʉ̃hnit nin baácboó ĩ chãobípna caá. Paá, meém tʉ́ini jʉmna, nit weemdíh ma wʉ̃hnitdih ma wẽpatjĩh, weemdíh ma wʉ̃hni wẽpat biícdih, ma tʉ́i en dawaá. Páant ma tʉ́i en dawáchah, jwiít tʉ́i biícdih jwĩ jʉmat pah mʉntih nitbʉt tʉ́i biícdih ĩ jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ĩjeéh jʉm jwʉhna, ma wẽpatjĩh nitdih wã tʉ́i en dawáp be, biícboó ã bʉʉdcát pínah niijná. Obohjeéhtih, ma naáwátdih ĩ daacátji pahjeh tih, biíc bácah iiguípna ã bejbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Bʉʉ ma pebhboó bejat tʉ́ʉt caá wã chãjap. Nin baácboó jʉm jwʉhna, ĩ́ih pínahdih páant wã niíj ʉʉ́bʉ́p be, caandíh joinít, weém biícdih bʉ́dí ĩ weñat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ded pah ma jʉmatdih nitdih wãát naáwáp be. Weém yeejép wã chãjcat pah nit wĩ́ihwãboó yeejép chãjnitji ĩ tʉ́ʉt nʉʉmʉ́p be. Páant ĩ tʉ́ʉt nʉʉmʉ́chah ennit, bita tʉ́ʉt nʉʉmcánnitboó queétdih ĩ iiná caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","‘Nin baácdih jʉmnit wĩ́ihwãdih ma ʉb bejeé’, wã niíj ʉʉ́bhcan caá. Obohjeéhtih, ‘nin baácdih ĩ jʉm jwʉhʉchah, ma tʉ́i en dawaá, Nemép queétdih ã yéejacat pínah niijná’, wã niíj ʉʉ́bhna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Weém nin baácdih moón yeejép ĩ jenah joyát pah wã jenah joicán caá. Pánihna, weemdíh jepahnit jʉmna, nin baácdih moón ĩ jenah joyát pah queétbʉt ĩ jenah joicán caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ma naáwát yoobópdih ã jʉmʉchah, caandíh nit wĩ́ihwãdih ma tʉ́i bohénaá, meemdíh chah ĩ jepahat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nin baácboó weemdíh ma wahat pahjeh mʉntih, weembʉ́t nit wĩ́ihwãdihbʉt wã wahna caá, ded pah jwĩ jʉmatdih queét jwʉh bitadih ĩ bohéát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cã́acwãdih wã wʉn wʉ̃hbipna caá, míihwã jʉmna, ma weñat pínahdihjeh ĩ chãjat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","“ ‘Nit wĩ́ihwãdihjeh ma teo wáacá’, wã niíj ʉʉ́bhcan caá. Bʉʉ queétboó bitadih wĩ́ih doonádih ĩ bohénachah joinít, weemdíh jepahnitdihbʉt ma teo wáacat pínahdih wã ʉʉ́bhna caá, nihat wĩ́ihwã biícdih ĩ jʉmat pínah niijná. Weém majeéh jwiít chénewã jʉmna yʉhna, biícjeh caá. Pánihna, jwiít biícjeh jwĩ jʉmat pah queétbʉt jwĩjeéh tʉ́i biícdih ĩ jʉmʉ naáh, ma wahni wã jʉmatdih nihat cã́acwã ‘Yoobópdih tigaá’, ĩ niíj jéihyat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Weemdíh ma wʉ̃hni wẽpatdih wĩ́ihwãdihbʉt wãát wʉ̃hʉp be, biícdih jwiít jwĩ jʉmat pah, queétbʉt tʉ́i biícdih ĩ jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Weém queét biícdih wã jʉmʉchah, meembʉ́t weém biícdih ma jʉmna caá. Páant biícdih jwĩ jʉmʉchah, wĩ́ihwã yoobópdih biícwã pahjeh ĩ jʉmbipna caá. Páant biícwã pah ĩ jʉmʉchah enna, ma wahni wã jʉmatdih cã́acwã ĩ jéihbipna caá. Pánihna, weemdíh ma oyat pah mʉntih, queétdihbʉt biíc yoobó ma oyatdih ĩ tʉ́i jéihbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Paá, nin baácdih jwĩ chãjat pínah jã́tih weemdíh bʉ́dí oina, ma wẽpat weemdíh wʉ̃hnit, biíc yoobó maáta jwĩ jʉmʉp jĩ. Pánihna, wĩ́ihwã jwĩ pebhboó wãjeéh ĩ jʉmat pínahdih queétdih wã náah yacna caá, weemdíh maáh ma jwʉ́ʉb waadáátdih ĩ enat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Paá, meém tʉ́ini yoobát chãjni, nin baácdih moón yeejépwã meemdíh ĩ jéihcah yʉhna, weémboó meemdíh wã tʉ́i jéihna caá. Ma wahni wã jʉmatdih nit wĩ́ihwã ĩ tʉ́i jéihna caá. ");
INSERT INTO cbv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ded pah meém ma jʉmatdih queétdih wã jéihyanap be. Tʉ́ttimahbʉt, páantjeh wã jéihyabipna caá, weemdíh ma oyat pahjeh mʉntih queétdihbʉt ma oyatdih ĩ jéihyat pínah niijná. Pánih jéihnit, queétjehbʉt ĩ míic oyochah, ĩjeéh biícdih wã jʉmbipna caá”, Diosdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Páant niíj ʉʉ́bh péanit, Jesús jwiít ã bohénitdih nʉmah bac bejnit, Cedrón wʉ̃t jʉmni mʉjdih chʉ́ʉh bej, Olivo pácahi jʉmni jeená jwĩ jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Dawá láa caán pácahi jʉmʉpna Jesúsjĩh jwĩpĩ́ míic wáacap jĩ. Pánihna, Judas Jesúsdih eníhcannitdih dʉó wáini pínah caanná jwĩ bejat pínahdih ãt jéihyep tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pánih jéihna, Jesúsdih jʉ́ʉtat tʉ́ʉt niijná, Romano soldadowãdih, Dioíh mʉʉdíh wapnitdihbʉt ãt dʉó wái jʉ̃ʉ́wʉ́p tajĩ. Queétdih sacerdotewã maáta, fariseowã maátabʉt ĩt wahap tajĩ. Pánih jʉ̃óhna, ĩ́ih jiiát yʉyʉ́ déejĩh jiinít, ĩtah tṍopna, íibat naaná, máa quiítnajĩh man jʉmnit, ĩ jʉyʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pánihna, jwĩ jʉmʉpdih ĩ tóah jʉ̃ʉ́wʉ́chah ennit, yeejép ã yapat pínahdih jéihna, Jesúsboó queétdih jwãáh bejnit, nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Déhedih bid jʉ̃óh tigaá ñi chãj? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús Nazaret tʉ́tchidih bóodih bid jʉ̃óhna caá jwĩ chãjap, queét ĩ niíj jepahap jĩ. —Caan tígaá weém, Jesús ã niijíp jĩ. Queétdih dʉó wáini, Judas, queét cãtína ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Caan tígaá weém”, Jesús ã niíj jepahachah joinít, caandíh tewedih jʉ̃óhnitji tã́ahjĩh ĩ chéi jwʉ́ʉb bej bʉʉgʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Páant ĩ bʉʉgʉ́chah ennit, queétdih Jesús nin pah ã jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ: —¿Déhedih bid tigaá ñi chãj? ã niijíp jĩ. —Jesús Nazaret tʉ́tchidih bóodih bidna caá jwĩ chãjap, queét ĩ jwʉ́ʉb niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—‘Caan tígaá weém’, yeebdíh wãát niíj jepahap be. Pánihna, weemdíh teona, nit wãjeéh jʉmnitdih ñi teoca bojoó, Jesús queétdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“Míihwã weemdíh ma wʉ̃hnitdih biíc cã́acdih wã bʉʉdát tʉ́ʉtcap be”, Diosdih ã niíj ʉʉ́bátji pah biíc yoobó ã yapat pínah niijná, “Nitdih ñi teoca bojoó”, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro ã́ih íibat naadíh jwã́at wáinit, sacerdotewã ĩ maáhdih teo wʉ̃hni Malco wʉ̃t jʉmniíh jéihyepmant bóo moli chóodih ã bóod yohop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Páant ã bóod yohochah ennit, Jesús Pedrodih nin pah ã niijíp jĩ: —Míih íibat naadíh ma jwʉ́ʉb yacaá. Wã íip ded pah weemdíh ã náah yacat pah biíc yoobó yeejép wã yapbipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Páant ã niíj péanachah, soldadowã, ĩ maáhjĩh, jwiít judíowã jwĩ maátabʉt Jesúsdih teonit, caandíh ĩ chéwep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chéo péanit, Anás pebhna ĩ ʉb bejep jĩ. Anás Caifás jóon wʉt jĩ. Caifásboó caán jópchidih sacerdotewã ĩ maáh ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“Nihat jwiít judíowã jwĩ tʉ́i jʉmat pínahdih biíc cã́ac ã wʉn wʉ̃hʉchah ã tʉ́ibipna caá”, niíj naóhniji Caifás ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Weém, Simón Pedrojĩh Jesúsdih yʉʉ́pbit jwĩ en péenachah, Anáíh mʉʉná Jesúsdih ĩ ʉb jʉibínap jĩ. Pánihna, weémboó sacerdotewã ĩ maáh ã jéihni jʉmna, Jesús tʉ́ttimah maáíh mʉʉ́ wáihyat jʉ́dʉna weembʉ́t wã waad béjep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Obohjeéhtih, weém wã waadáchah, Pedroboó wáihyat jʉ́dʉ waadápmahjeh ã chãwáp jĩ. Pánihna, jwʉ́ʉb bac jʉ̃óhnit, waadátboó wapnihdih Pedrodih wã waadát tʉ́ʉtʉp jĩ. Páant mi waadát tʉ́ʉtʉchah joinít, weém Pedrodih wã nʉmah waad béjep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Páant wã nʉmah waad béjechah ennit, caánt wapnihboó Pedrodih nin pah mi niíj ʉʉ́bh joyóp jĩ: —¿Meembʉ́t Jesús ã pej jʉmni nihcan niít? mi niijíp jĩ. —Nihcan caá weém, Pedro ã niíj jepahap yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Caan chéi tʉbit pohba ã cʉ́bʉhʉchah, caanjĩ́h moón teo wʉ̃hnit tʉʉ cáonit, ĩ mée chʉ́ʉdʉp jĩ. Pánihna, jwiítbʉt Pedrojĩh ĩjeéh jwĩ mée chʉ́ʉdʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Páant jwĩ mée chʉ́ʉdat pónih, sacerdotewã ĩ maáh ã jóon Anásboó Jesúsdih ãt ʉʉ́bh joyóp wʉt jĩ. Jwiít ã bohénitdih, ded pah ã bohéátjidihbʉt ãt ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Páant ã ʉʉ́bh joyóchah, Jesús caandíh nin pah ãt niíj jepahap wʉt jĩ: —Weém nihat ĩ joyóchah, jweéhcanjeh wãpĩ́ bohénap jĩ. Jwiít judíowã jwĩ míic wáacat mʉʉdíh, Dioíh mʉʉdíhbʉt wãpĩ́ bohénap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Páant wã bohénachah yʉhna, ¿dépanihna weemdíh páant ma niíj ʉʉ́bh joí? Ma jéihíhna, weemdíh joinítjidih ma ʉʉ́bh joyoó. Queétboó meemdíh yoobópdih ĩ naóhbipna caá, ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","—Sacerdotewã ĩ maáhdih páant ma niijcá bojoó, niijnít, caan pébh ñʉhni soldado téihyajĩh Jesúíh pʉ́o tíibdih ãt mawap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Ded pah yeejép wã niijátjidih weemdíh ñi naáwá. ¿Yoobópdih yeebdíh wã naáwáchah yʉhna, dépanih tigaá weemdíh ma mao? Jesús soldadodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pánih ʉʉ́bh joí péanit, Anásboó Jesúsdih páantjeh ĩ chéonijidih ã jíi Caifás, sacerdotewã ĩ maáh yoobát pebhna ãt wahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jesúsdih páant ã ʉʉ́bh joyát pónih, jwiít Simón Pedrojĩh páantjeh tʉʉ cʉ́ʉt pebh jwĩ mée chʉ́ʉdʉp jĩ. Páant jwĩ mée chʉ́ʉdʉchah ennit, caanjĩ́h moon jwʉ́h Pedrodih nin pah ĩ niíj ʉʉ́bh joyóp jĩ: —¿Meembʉ́t Jesús ã pej jʉmni nihcan niít? ĩ niijíp jĩ. —Nihcan caá weém, Pedro ã jwʉ́ʉb niíj jepahap yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Páant ã niiját tʉ́ttimah, sacerdotewã ĩ maáhdih teo wʉ̃hni, Pedro moli chóodih ã bóod yohniji ã dée jwʉh Pedrodih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Pácahi jʉmʉpdih meemdíh nihcannit beé Jesús biícdih wã enep? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Weém ãjeéh wihcan beé, Pedro ã niíj jepahap yʉh jĩ. Páant ã niijíchahjeh, mʉjbai ãí ewep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Baáb jéenechah, Caifáíh mʉʉmánt Jesúsdih ʉb bac bejnit, caán tʉ́tchidih moón ĩ maáh Pilato wʉ̃t jʉmniíh mʉʉná caandíh ĩ ʉb bejep jĩ. Pánih ʉb bejna yʉhna, queétjeh ã́ih mʉʉná waadcán, soldadowãdih Jesúsdih ĩ ʉb waad béjat tʉ́ʉtʉp jĩ. Pilato judío nihcah, ã́ih mʉʉná waadnít, jwĩ wʉtatdih yap yohna, Pascua jeémátdih ĩta jéih jeémpcan tagaá. ");
INSERT INTO cbv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Páant ĩ waadcáh ennit, Pilato jẽcdih bac jʉí ñʉhnit, queétdih nin pah ã niíj ʉʉ́bh joyóp jĩ: —¿Dedé jíib tigaá nindih ñi naóh yac? ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Caán yeejép nihcah, meemdíh jwĩta ʉb jʉ̃óhcan tagaá, ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Caandíh ʉb bejnit, ñi wʉtat pah yeebjéh ñi peéh chãjaá, Pilato queétdih ã niíj jepahap jĩ. —Obohjeéhtih, yeéb Romano maátaboó jwiít judíowãdih cã́acwãdih ñi mao yohat tʉ́ʉtcap jĩ, ĩ niijíp jĩ. Páant niijná, Jesúsdih ĩ mawat tʉ́ʉtatdih niijná ĩ chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Páant ĩ mawat tʉ́ʉtʉchah, Jesús cruzboó ã wʉnat pínahdih, jã́tih ã naáwátji biíc yoobó ĩ chãjat tʉ́ʉtʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Páant ĩ niiját tʉ́ttimah, Pilatoboó jwʉ́ʉb waad béjnit, Jesúsdih ãt bid bojop wʉt jĩ. Pánih bid bojnit, caandíh nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Meém judíowã ĩ maáh niít? ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Meemjéh ʉʉ́bh joí en niít ma chãjap? ¿Bita ĩ naáwáchah joiníji niít, páant ma niíj ʉʉ́bh joyóp? Pilatodih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Páant, weém judío nihcan caá. Ma déewã, ñíih sacerdotewã maátabʉt meemdíh ĩ wahap be. ¿Dedédih tibeé yeejép ma chãj, páant ĩ peéh chãjíhichah? Jesúsdih ãt niíj ʉʉ́bh joyóp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Weém nin baácdih moón ĩ maáh nihcan caá. Páant wã jʉmʉchah nihna, wã bohénit weemdíh ĩta teo wáac tagaá, jwĩ déewã ĩ teocat pínah niijná. Obohjeéhtih, wã maáh jʉmat nin baácboó nihcan caá, Jesús Pilatodih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—Pánihna, ¿meém maáh niít? páant niijná, Pilato ãt niijíp wʉt jĩ. —Ma niiját pah maáh tigaá wã jʉmʉp. Cã́acwã ĩ maáh jʉmat tʉ́ʉt, queétdih yoobópdih naáwát tʉ́ʉt niijná, nin baácboó wã jʉ̃ʉ́wʉ́p jĩ. Pánihna, ded yoobópdih chãjíhni, weemdíh ã tʉ́i jepahna caá, Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Dedé tigaá yoobópdih jʉmat? Pilato ãt niijíp wʉt jĩ. Páant niíj péa, Pilato jwʉ́ʉb bac jʉ̃óhnit, queét pã́i ñʉhnit judíowãdih nin pah ã niíj naáwáp jĩ: —Ñi mawat tʉ́ʉtni Jesúsdih dedé peéh mawat wihcan caá. ");
INSERT INTO cbv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Jópchi jʉmat pah, Pascua yeó jáapdih biíc nemat mʉʉ́boó jʉmnidih wãpĩ́ baca wʉ̃hna caá. Pánihna, ¿ñi maáh ñi niijnídih yeebdíh wã baca wʉ̃h jĩíh? Pilato jwĩ maátadih ã niíj ʉʉ́bh joyóp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—Nihcan caá. Caandíh ma bacaca bojoó. Barrabásboodíh jwiítdih ma baca wʉ̃hʉʉ́, Pilatodih jwĩ déewã ĩ niíj ñaác jepahap jĩ. Barrabásboó Romano maátadih yohíhnitjeéh ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Páant ĩ niíj ñaác jepahachah joinít, Pilato Jesúsdih soldadowãdih ãt pʉñat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Páant ĩ pʉñat tʉ́ttimah, queét óot tõpdih péeb waoni jʉ́dʉ chãjnit, Jesúíh wao dáhdih ĩt yacap tajĩ. Pánih yac péanit, maátaíh yégueh pah jígohni caandíh yacnit, nin pah ĩt niíj deoh naáwáp wʉt jĩ: ");
INSERT INTO cbv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—Ma tʉ́i jʉmʉʉ́, judíowã ĩ maáh, niíj deoh naóhnit, Jesúsdih ĩ dawát yoobó pʉ̃ina ĩt chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Páant ĩ pʉñat tʉ́ttimah, Pilato jwʉ́ʉb bac jʉ̃óhnit, caanjĩ́h pã́i ñʉhnit jwĩ déewãdih nin pah ã jwʉ́ʉb niíj naáwáp jĩ: —Ñi joyoó. Nindih dedé peéh mawat wihcan caá. Páant ã wihcatdih ñi jéihyat pínah niijná, wã jwʉ́ʉb ʉb bac jʉ̃óhna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Páant ã niíj péanachahjeh, Jesús óot jʉ́dʉ dʉoní, maátaíh yégueh pah jígohni ĩ yacniji mʉʉ́ diítmant ã bac jʉ̃ʉ́wʉ́p jĩ. Páant ã bac jʉ̃ʉ́wʉ́chah, Pilato queétdih nin pah ã niijíp jĩ: —Ñi eneé. Nin caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Páant ã niijíchah joinít, sacerdotewã ĩ maáta, Dioíh mʉʉdíh wapnitbʉt Jesúsdih ennit, bʉ́dí ĩ jʉ̃ih ñaacáp jĩ. —¡Caandíh cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! ¡Caandíh cruzboó péoh dodhnit, ma mao yohat tʉ́ʉtʉ́! ĩ niijíp jĩ. Páant ĩ niíj ñaacáchah joinít, Pilato nin pah queétdih ã jwʉ́ʉb niijíp jĩ: —Caandíh peéh mawat wihcah yʉhna, ñi mawíhna, yeebjéh ʉb bejnit péoh dodhnit, ñi mawaá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Páant ã niijíchah joinít, jwĩ maáta nin pah ĩ jwʉ́ʉb niijíp jĩ: —‘Weém Dios wʉ̃ʉ́h caá wã jʉmʉp’, caanjéh ã niijíp be. Páant ã niijátji jíib jwĩ nʉowã ĩ wʉtatji pah caandíh mao yohat caá náahap, queét Pilatodih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Páant ĩ niijíchah joinít, Pilatoboó chah ã joí wʉ́hi bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pánih joí wʉ́hi bejna, Jesúsdih jwʉ́ʉb nʉmah waad béjnit, caandíh nin pah ãt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ: —¿Dedjĩh bóo tigaá meém? ãt niijíp wʉt jĩ. Páant ã niijíchah yʉhna, Jesús caandíh ãt jepahcap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Páant ã jepahcah, Pilato nin pah ãt jwʉ́ʉb niíj ʉʉ́bh joyóp wʉt jĩ, páant mʉntih: —¿Weemdíh ma jepahíhcan niít? Weémboó meemdíh wã jéih bacana caá. Cruzboobʉ́t wã jéih péoh dodh mawat tʉ́ʉtna caá. ¿Caandíh ma jéihcan niít? Jesúsdih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Dios meemdíh pánih wẽpatdih ã wʉ̃hcah, weemdíh ded pah mata jéih chãjat tʉ́ʉtcan tagaá. Obohjeéhtih, weemdíh eníhcannitdih dʉó wáiniboó meém chah yéejni ã jʉmna caá, Jesús Pilatodih ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Páant ã niijíchah joinít, Pilato caandíh ãtih bacaíhip wʉt yʉh jĩ. Pánih bacaíhna, jwʉ́ʉb bac jʉ̃óhnit, queét jwĩ maátadih ã bacaíhat déejidih ã wẽp naáwáp yʉh jĩ. Obohjeéhtih, páant ã naáwáchah, jwĩ déewãboó chah íijnit, bʉ́dí ĩ jwʉ́ʉb niíj jʉ̃ih ñaacáp jĩ. —‘Weém maáh caá’, niijná, Jesús jwĩ maáh Césardih eníhcanni caá. Pánihna, caandíh bacana, meembʉ́t Césardih yap yohni mata jʉm tagaá, Pilatodih ĩ niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Páant ĩ niijíchah joinít, Jesúsdih jwʉ́ʉb bac jʉ̃ʉ́wát tʉ́ʉtnit, caandíh ded pah ã chãjat pínahdih naáwát tʉ́ʉt niijná, peéh chãjat pínahdih naóhnit ĩpĩ́ chʉ́ʉdʉpboó Pilato ã yoób jʉí chʉ́ʉdʉp jĩ. Pilato ã chʉ́ʉdʉpboó jee dáhna ĩ jwejni coah ã jʉmʉp jĩ. Caan cóah jwiít judíowã jwĩ́ih wéheatjĩh Gabatá ã wʉ̃t jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Caán yeó jáapdih Pascua jeémát yeó jáap jã́tih jwĩ míic ámohat yeó jáap, yeó téih pʉ́ʉh laáb jʉiní ã jʉmʉp jĩ. Pánih jʉí chʉ́ʉdnit, —Nin caá ñi maáh, Pilato caanjĩ́h pã́init jwĩ déewãdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","—¡Ã wʉn dáhwa naáh! ¡Ã wʉn dáhwa naáh! ¡Ʉb bejnit, cruzboó péoh dodhnit, caandíh ñi mao yohoó! ĩ niíj ñaacáp jĩ. —¿Ñi maáh ã jʉmʉchah yʉhna, caandíh cruzboó péoh dodhnit, mao yohat tʉ́ʉt niít ñi chãjap? Pilato queétdih ã niíj jepahap jĩ. —Roma tʉ́tchidih bóo César jwĩ maáh yoobát caá. Biíh maáh jwiítdih ã wihcan caá, sacerdotewã ĩ maáta ĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Páant ĩ niiját tʉ́ttimah, queét ĩ weñat pínah niijná, Jesúsdih cruzboó mao yohat tʉ́ʉtna, Pilato ã́ih soldadowãdih ã ʉb bejat tʉ́ʉtʉp jĩ. Pánihna, queét soldadowã Pilatoíh mʉʉmánt Jesúsdih ĩ ʉb bac jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pánih ʉb bac jʉ̃óhnit, Jesúsjeh ã́ih cruzdih ã bewechah, Waó Iidíp wʉ̃t jʉmni jeejína caandíh ĩ ʉb bejep jĩ. Jwĩ́ih wéheatjĩh caán jeé Gólgota ã wʉ̃t jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pánihna, bita chénewãdihbʉt caán biícdih ĩ mao yohat tʉ́ʉt niijná, ãjeéh ĩ ʉb bejep jĩ. Pánih ʉb bejna, caanná jʉibínit, queét biíc peihcannit ĩ beoniji cruznadih soldadowã ĩ nah péoh jwejep jĩ. Biícdih Jesús ã jéihyepmant bóo bʉwámant péoh jwej, biíhdih ã wáyámant bóo bʉwámant ĩ péoh jwejep jĩ. Pánihna, ĩ tac yoób Jesúsdih ĩ péoh jwejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pánih péoh jwej péanit, Pilato ã daacát tʉ́ʉtni naadíh Jesúíh waó chahmant ĩ nah péoh bʉ́ʉdhdʉp jĩ. Nin pah ãt niíj daacát tʉ́ʉtʉp tajĩ: “Nin Jesús Nazaret tʉ́tchidih bóo judíowã ĩ maáh caá”, ãt niíj daacát tʉ́ʉtʉp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Caán naadíh páant ã niíj daacát tʉ́ʉtna, jwĩ́ih wéheatjĩh, Roma tʉ́tchidih moóníh wéheatjĩh, Grecia baácdih moóníh wéheatjĩhbʉt páant ãt niíj daacát tʉ́ʉtʉp tajĩ. Pánih nah péoh péanit, queét biíc peihcannitdih ĩ yoób pʉd dodhdop jĩ, bʉca. Queétdih cruzboó ĩ péoh dodh mawapboó tʉ́tchi jwẽ́ejdih ã jʉmʉp jĩ. Dawá jwĩ déewã queétdih ĩ mawachah enat tʉ́ʉt niijná, jwĩjeéh ĩ pée bejep jĩ. Pánihna, caanná jʉibínit, Pilato ã daacát tʉ́ʉtatjidih dawá jwĩ enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Páant ã niíj daacát tʉ́ʉtatjidih dawá jwĩ enechah íijnit, Pilato pebhboó jwʉ́ʉb bejnit, sacerdotewã ĩ maáta nin pah caandíh ĩt niíj wʉtʉp wʉt yʉh jĩ: —‘Nin judíowã ĩ maáh caá’, ma niíj daacát tʉ́ʉtca bojoó. Caánboó jwĩ maáh nihcan caá. Obohjeéhtih, nin pah ma jwʉ́ʉb niíj daacát tʉ́ʉtʉ́: ‘“Judíowã ĩ maáh caá weém”, ã niijíp be’, ma niíj daacát tʉ́ʉtʉ́, ĩt niijíp wʉt yʉh jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Wã jwíih daacát tʉ́ʉtat pahjeh ã jʉmʉ naáh, Pilato queétdih ãt niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesúsdih ĩ péoh dodhdat tʉ́ttimah, chénena míic soldadowã Jesúíh yéguehnajidih ĩ jʉmat yoobó ĩ ʉbʉp jĩ. Ã́ih jih bóo chóo, waica naáh chóo ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Caán chóo, pánihni ã jʉmʉchah, nin pah queét míicjeh ĩ niijíp jĩ: —Nin yégueh chóodih jwĩ yeo wáica boj jĩíh. Ded nin chóodih ʉbni pínahdih jéihyat tʉ́ʉt niijná, jwĩ yoh tíoh jwʉh jĩíh, ĩ míic niijíp jĩ. Páant niijnít, ĩ́ih tíhwat naajĩ́h ĩ yoh tíhwip jĩ. Pánih tíohna, Dios naáwátdih naóh yapani ã daacátji pahjeh ã yapat pínah niijná, queét páant ĩ chãjap jĩ. “Wĩ́ih yégueh chóodih queét ĩ jʉmat yoobó ĩ ʉbbipna caá. Pánihna, wĩ́ih yéguehdih ʉbni pínahdih jéihíhna, tíhwat naajĩ́h ĩ yoh tíohbipna caá”, ãt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Páant ĩ chãjachah, Jesúíh cruz pebhbit chénena míic yaádh biícdih weém wã en ñʉhʉp jĩ. Jesús íin, ã cheh, biíh wili María Cleofas áa, biíh wili María Mágdala tʉ́tchidih bóli jwĩ en ñʉhʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pánihna, ã íin biícdih weém bʉ́dí ã oinibʉt ã pebh wã en ñʉhʉchah ennit, ã íindih Jesús nin pah ã niijíp jĩ: —Naá, can wã bohénijiboó meemdíh ma wʉ̃ʉ́h pah ã jʉmbipna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Páant niíj péanit, weemdíh jwʉh nin pah ã niijíp jĩ: —Bʉʉ cant ma íin pah mi jʉmbipna caá, ã niijíp jĩ. Páant ã niijíchah joinít, caán yeó jáapjeh caántdih jwĩ́ih mʉʉ́boó wã ʉb waadánap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Páant ã niíj péaat tʉ́ttimah, “Nihat Dios weemdíh ã wʉtnidih wã chãj péanap be”, niíj jéihna, Dios naáwátdih naóh yapanit ĩ daacátji pahjeh ã yapat pínah niijná, Jesús nin pah ã niijíp jĩ: —Weemdíh taca joótna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Caanjĩ́h bijni jiwá iguíh mac jʉmni wáam dahdih ĩ bíbohop jĩ. Pánihna, biíc soldado hisopo wʉ̃t jʉmni máa doóbhdih ʉbnit, páab chʉí déedih chéo bʉ́ʉdhnit, bijni macdih ã taj báahanap jĩ. Taj báaha péanit, Jesúíh jacna ã nah tewep jĩ, ã wái nomat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Páant ã chãjachah, Jesús caandíh wái nom péanit, —Páant bóojeh tigaá, niíj, waó yaíh dʉonít, ã wʉnah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Caán ã wʉnni yeó jáapdih, Pascua yeó jáapna jwĩ chooát yeó jáap pínahdih jwĩ ámohat ã jʉmʉp jĩ. Jwiít judíowã caán chooát yeó jáapdih cruzboó páantjeh ĩ ñʉhatdih jwĩ náahcap jĩ. Pánihna, ĩ́ih wʉ́ʉ nahnadih daj mawachah, waícanjeh ĩ wʉnat pínah niijná, jwĩ maátaboó Pilatodih ĩt daj mawat tʉ́ʉtʉp wʉt jĩ. Páant ĩ daj mawat tʉ́ttimah, ĩ́ih bácahjidih waícanjeh ʉb deyaat tʉ́ʉt ĩt chãjap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Páant ĩ wʉtʉchah joinít, Pilato cruzboó ñʉhnitdih ĩ́ih wʉ́ʉ nahnadih soldadowãdih ãt daj mawat tʉ́ʉtʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Obohjeéhtih, caan pébh ñʉhnitdih daj mao péa, yap jʉ̃óhnit, Jesús jã́tih ã wʉnatjidih enna, ã́ih wʉ́ʉ nahnaboodíh ĩ daj maocap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pánih daj maocan yʉhna, biíc soldado ã́ih ĩtah tṍopjĩh Jesúíh páwá pĩjmant ã jwã́ag aabánap jĩ. Páant ã jwã́agachah, biícmantjeh meép mahjĩh wid jʉmni ã chíi jʉ̃ʉ́wʉ́p jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Páant ã chíi jʉ̃ʉ́wʉ́chah, weemjéh wã enep jĩ. “Weém nin tólihdih páant wã niíj daácna, yoobópdih naóhna caá wã chãjap”, wã niíj jéihna caá. Pánihna, yeebdíhbʉt wã naóh yapana caá, yeebbʉ́t Jesúsdih ñi tʉ́i jenah joyát pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dios naáwátdih naóh yapanit ĩ naóh daacátji pahjeh tibeé páant ã yapap jĩ. “Ã́ih bácahdih ded iidípdih ĩ daj maocan niít”, ĩ niíj daacátji pahjeh, Jesúíh wʉ́ʉ nahnadih ĩ daj maocap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dios naáwátdih biíh tólihdih nin pahbʉt ĩt niíj daacáp tajĩ: “Queét ĩ jwã́agnijidih ĩ enbipna caá”, ĩt niíj daacáp tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesús ã wʉnat tʉ́ttimah, José Arimatea tʉ́tchidih bóo, ã́ih bácahjidih ʉb deyaat tʉ́ʉt niijná, Pilatodih ʉʉ́bʉ́dih ãt bejep wʉt jĩ. Páant ã ʉʉ́bʉ́chah joinít, ã yohat pínah niijná, Pilato caandíh ãt ʉb deyaat tʉ́ʉtʉp wʉt jĩ. Páant ã ʉb deyaat tʉ́ʉtʉchah joinít, José cruzboó ñʉhnit pebhna jʉinít, Jesúíh bácahjidih ã ʉb deyanap jĩ. José jwĩ déewã maátadih ʉ́ʉmna, Jesúsdih ã jepahatjidih ãt naáwíhcap tajĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo, Jesúsdih chei jʉí wéhenijibʉt, ãjeéh jʉ̃óhnit, mirra wʉ̃t jʉmni chej jʉmni ah, áloe wʉ̃t jʉmni chípéh déejĩh widnidih ã ʉb jʉyʉ́p jĩ, Jesúíh bácahjidih ĩ yohat pínah jã́tih ñáñat tʉ́ʉt niijná. Caán ã ʉb jʉ̃óhni treinta kilos ãt chodop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pánihna, queét chénewã Jesúíh bácahjidih ʉb deyanit, jwiít judíowã wʉnnitdih jwĩpĩ́ yohat pah, ã́ih bácahjidih chej jʉmnijĩh ñáinit, yéguehnajĩh ĩ pinip jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Cruzboó Jesúsdih ĩ mawap pebh pácahi ã jʉmʉp jĩ. Caán pácahi tac yoób cã́ac ĩ yohat pínah ĩ jáap baadní jeé íit ãt jʉmʉp jĩ. Caán ĩ baadní íitdih cã́ac yoh jwʉhca naáh ãt jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pánihna, jwĩ chooát hora tóah jʉ̃ʉ́wʉ́chah, ã́ih bácahjidih ʉb bejnit, chooát yeó jáap tʉ́ttimah caandíh tʉ́i ámoh péaat tʉ́ʉt niijná, caán pebhbit jʉmni jeé íitdih yójahnitjeh ĩ yohop jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo yeó jáapdih baab bójat pínah jã́tih, María Mágdala tʉ́tchidih bóli, Jesúsdih ĩ yohopjiboó mit bej jáanap wʉt jĩ. Caanná jʉibínit, caán íitdih ĩ nemniji jeé jʉ́dʉdih bita ĩ pʉ̃tʉ́ dodhdatji pah ã jʉmʉchah, mit enep wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pánih ennihji weém, Jesús bʉ́dí ã oini, Simón Pedrojĩh jwĩ jʉmʉpna mi ñáo jʉyʉ́p jĩ. Pánih ñáo jʉinít, jwiítdih nin pah mi niíj naáwáp jĩ: —Jwĩ Maáíh bácahjidih jáantjeh ĩt ʉbʉp tabe. Pánih ʉb bejnitji ded ĩ jwʉ́ʉb jwejepjiboó wã jéihcan caá, mi niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Páant mi niijíchah joinít, jwiítbʉt Jesúsdih ĩ yohopjiboó enedih jwĩ ñáo ñah bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pánih ñáo ñah bejna, weém Pedrodih ñáo yapnit, ã jã́tih caán yohopji jeé íitna wã waóh jʉibínap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pánih jã́tih jʉibína yʉhna, caán íitdih waadcánjeh, péeb jéen enna, Jesúsdih ĩ pinni chóonajijeh ã lajachah, wã enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Páant wã péeb jéen enechahjeh, Simón Pedro pée jʉinít, chão ñʉ́hcanjeh, caán íitna ã waad béjep jĩ. Pánih waad béjnit, Jesúíh bácahjidih ĩ pinni chóonajijeh ã lajachah, caanbʉ́t ã enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesúíh wao dáhdih ĩ pinni chóo chibít yʉʉ́p ã lajachah, caandíhbʉt ã enep jĩ. Ĩ pinni chóona ã́ih bácahdih ã́ih wao dáhdihbʉt ĩ pinatji pahjeh ã lajap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pánihna, waad béjnit, ã en ñʉhʉchah ennit, weembʉ́t wã ñʉʉ́n waad béjep jĩ. Pánih ñʉʉ́n waadnít, Jesúíh bácah ã wihcah ennit, “Yoobópdih Jesús ãt jwʉ́ʉb boo pʉd jʉ̃óh tagaá”, weém wã niíj jéihyep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Caán íitboó jwĩ bejat pínah jã́tih, Dios naáwátdih naóh yapanit Cristo ã wʉnat pínahdih, ã jwʉ́ʉb boo pʉd jʉ̃ʉ́wát pínahdihbʉt ĩ daacátjidih jwĩ tʉ́i beh joi jwʉ́hcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pánih en péanit, jwĩ́ih mʉʉná jwĩ jwʉ́ʉb bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Jwiítdih mi naáwát tʉ́ttimah, María Mágdala tʉ́tchidih bóli jwĩ tʉ́ttimah pée bejnit, Jesúíh bácahdih ĩ yohopji jeé íit jẽc jípónih ñʉhnit, mit jʉ̃i ñʉ́hʉp wʉt jĩ. Pánih jʉ̃i ñʉ́hnajeh, péeb jéennit, caán íitna mit en waadá bojop wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pánih en waadána, Dios ã wahnit ángelwã chénewãdih mit enep wʉt jĩ. Tʉ́i baabní yéguehna dʉonít, Jesúíh bácah ã lajapjidih ĩt chʉ́ʉdʉp wʉt jĩ. Biíc ã́ih waó jʉmʉpjimant, biíh ã́ih jítcha jʉmʉpjimant ĩt chʉ́ʉdʉp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Páant queétdih mi péeb jéen enechah, queétboó caántdih nin pah ĩt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Yad wilí, dépanih tigaá ma jʉ̃í? ĩt niijíp wʉt jĩ. —Wã maáíh bácahjidih ʉb bejnit, ded ĩ jwʉ́ʉb jwejepjiboó wã jéihcan caá, mit niíj jepahap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Queétdih páant niijnít, tac pʉ́ʉd enna, Jesús caanjĩ́h ã ñʉhʉchah, mit enep wʉt yʉh jĩ. Obohjeéhtih, pánih enna yʉhna, mit beh encap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Páant mi beh encah, Jesús caántdih nin pah ãt niíj ʉʉ́bh joyóp wʉt jĩ: —¿Yad wilí, dépanih tigaá ma jʉ̃í? ¿Déhedih tigaá ma bid? ãt niijíp wʉt jĩ. Páant caandíh beh encanjeh, “Nin pácahidih en daoní nacaá”, mit niíj jenah joyóp wʉt yʉh jĩ. Páant niíj jenah joiná, —¿Meemnít beé jwĩ maáíh bácahjidih ma ʉb bejep? Ʉb bejna, ded ma jwʉ́ʉb jwejepjiboó weemdíh ma naáwá, caandíh jwʉ́ʉb ʉbʉdih wã bejat pínah niijná, caandíh mit niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—María, ãt niijíp wʉt jĩ. Páant ã niijíchah joí, tac pʉ́ʉd ñʉhnit, Hebreo wéheatjĩh nin pah mit niijíp wʉt jĩ. —Raboni, niijnít, Jesúsdih mit pin tewep wʉt jĩ. “Raboni”, niijná, “Bohéni”, niijná mit chãjap wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Páant mi pin tewechah, Jesús caántdih nin pah ãt niijíp wʉt jĩ: —Weemdíh ma pin teoca bojoó. Wã íip pebhboó wã pʉ́ʉh laab béj jwʉhcan caá. Pin teocanjeh, wã ʉ́ʉdwã panihnitdih nin pah niíj naáwádih ma bejeé: ‘Jesús nin pah yeebdíh ã niíj naáwát tʉ́ʉtʉp be: “Wã íip ñi íip mʉn tigaá. Caanjéh wĩ́ih Dios ñíih Dios mʉn tigaá. Pánihna, ã pebhboó wã pʉ́ʉh laab béjbipna caá”, ã niíj naáwát tʉ́ʉtʉp be’, queétdih ma niijí, Maríadih Jesús ãt niijíp wʉt jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Páant ã niijíchah joiníhji jwĩ pebhna jʉinít, nin pah mi niijíp jĩ: “Jwĩ Maáhdih wã enep be”, niijnít, Jesús caántdih ã naáwát tʉ́ʉtatjidih jwiítdih mi naóh yapanap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Caán domingo yeó jáap cheyeh tʉ̃́o yap aabát tʉ́ttimah, jwiít Jesús ã bohénitji, jwĩ maátadih ʉ́ʉmna, jẽcdih tʉ́i nem beedá bojnit, mʉʉ́ diítna biícdih jwĩ chʉ́ʉdʉp jĩ. Páant tʉ́i nem beedáni ã jʉmʉchah yʉhna, Jesús jwĩ cãtíh ã jígohop jĩ. Pánih jígohnit, nin pah ã niijíp jĩ: —¿Ñi jʉm caá? Dios ã tʉ́yat ñijeéh ã jʉmʉ naáh, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Páant niíj péanit, ã́ih téihyanadih, ã́ih jítchanadihbʉt jwiítdih ã jʉ́ʉtʉp jĩ. Páant ã jʉ́ʉtʉchah enna, jwĩ Maáh ã jʉmatdih jéihnit, bʉ́dí jwĩ weñep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Páant jwĩ weñechah, Jesús nin pah jwiítdih ã jwʉ́ʉb niijíp jĩ: —Ʉ́ʉmcanjeh, ñi tʉ́i jʉmʉʉ́. Wã íip weemdíh ã wahat pah mʉntih, wĩ́ih tʉ́ini doonádih ñi naáwát pínah niijná, yeebdíhbʉt wã wahna caá, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Páant niíj péanit, jwiítdih ã póoj jã́hanap jĩ. —Bʉʉ Tʉ́ini Espíritudih ñi ʉbʉʉ́, ñíih caolih diítboó ã jʉmat pínah niijná. ");
INSERT INTO cbv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Páant ñijeéh jʉmna, ã wẽpatjĩh det ĩ yéej chãjatdih ñi yohochah, yohni ã jʉmbipna caá. Obohjeéhtih, det ĩ yéej chãjatdih ñi yohcah, yohca naáh ã jʉmbipna caá, Jesús jwiítdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús jwĩ cãtíh ã jwíih jígohni chei, Tomás pohba jwĩjeéh ã wihcap jĩ. Tomás Jesúsdih jwĩjeéh bohéni “Waláhni”, ĩpĩ́ niíj wʉ̃t ejni ã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tʉ́ttimah, ã jwʉ́ʉb jʉyʉ́chah, caandíh nin pah jwĩ niijíp jĩ: —Jwiít jwĩ maáh Jesúsdih jwĩ enna beé, jwĩ niijíp jĩ. Páant jwĩ niijíchah joiná yʉhna, Tomásboó nin pah ã jípónih niíj jepahjehep jĩ: —Weémboó ã́ih téihyadih ĩ péhwatji íitnadih wĩ́ih téih tíibjĩh teo encan, ã́ih páwádih ĩ jwã́agatji íitdihbʉt teo encan, ‘Ã boo pʉd jʉ̃ʉ́wát dooná yoobópdih caá’, wã niíj jenah joicán niít, jwiítdih ã jãh niijjéhep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tʉ́ttimah bóo domingo yeó jáap caán mʉʉdíhjeh jwĩ jwʉ́ʉb míic wáac jʉyʉ́chah, Tomásbʉt jwĩjeéh ã jʉmʉp jĩ. Pánih míic wáac jʉinít, nihat jẽcnadih jwĩ jwʉ́ʉb tʉ́i nemechah yʉhna, Jesús jwĩ cãtíh ã jwʉ́ʉb jígohop jĩ. Pánih jígohnit, nin pah jwiítdih ã niijíp jĩ: —¿Ñi jʉm caá? Dios ã tʉ́yat ñijeéh ã jʉmʉ naáh, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Páant niijnít, Tomásboodíh nin pah ã niijíp jĩ: —Tomás, wĩ́ih téihyadih ĩ péhwatji íitnadih meemjéh ma teo eneé. Wĩ́ih páwádih ĩ jwã́agatji íitdihbʉt ma teo eneé. Teo ennit, ‘Yoobópdih tigaá ãt boo pʉd jʉ̃ʉ́wʉ́p taga’, ma niíj jéihyeé, caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Meémboó wã Maáh, wĩ́ih Diosbʉt caá, Tomás caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—Weemdíh ennitjeh, ‘Yoobópdih tigaá ãt boo pʉd jʉ̃ʉ́wʉ́p. Pánih boo pʉd jʉ̃óhna, Dios ã wahni Cristo yoobát caá’, meém ma niíj jéihna caá. Obohjeéhtih, bitaboó weemdíh encan yʉhna, páant niíj jéihnit, bʉ́dí ĩ wẽibipna caá, Jesús Tomásdih ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jwĩjeéh jʉm jwʉhna, dawá láa jwiít cã́acwã jwĩ jéih chãjca naáhdih Dios ã wẽpatjĩh Jesús ã chãj jʉ́ʉtʉp jĩ. Páant ã chãjatjidih nin tólihdih wã jéih daác beedácan caá. ");
INSERT INTO cbv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pánih daác beedácan yʉhna, nin tólihdihjeh wã daacáp be, “Yoobópdih Dios ã wahni Jesúsjeh tigaá. Caanjéh tigaá Dios wʉ̃ʉ́h”, ñi niíj jéihyat pínah niijná. Páant niíj jéihna, caandíh jepahnit, yeéb Diosjeéh páantjeh ñi jʉmbipna caá. ");
INSERT INTO cbv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tʉ́ttimah, jwiít siete ã bohénitjidih Tiberias íim jwẽ́ejdih Jesús ã jwʉ́ʉb jígohop jĩ. Nin pah ã jʉmʉp jĩ: ");
INSERT INTO cbv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jwiít biícdih jʉmnit, Simón Pedro, Tomás “Waláhni”, jwĩ niíj ejni, Natanael Galilea baác Caná tʉ́tchidih bóo, jwiít chénewã Zebedeo weh, bita chénewã Jesús ã bohénitji, páant moón jwĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Páant moón jwĩ jʉmʉchah, Simón Pedro jwiítdih nin pah ã niijíp jĩ: —Weém queéj jʉ́ʉt mawadih bejna caá wã chãjap, ã niijíp jĩ. —Jwiítbʉt majeéh jwĩ bejmi caá, jwĩ niijíp jĩ. Páant niíj, dei jʉibí, jãáj chóodih waadnít, íimdih jwĩ pʉ́ʉd bac bejep jĩ. Pánih pʉ́ʉd bac bejnit, nihat chei jwĩ jʉ́ʉt mawachah yʉhna, queejwã́ ĩ chʉ̃ʉ́hcap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Baáb báahachah, Jesús íim jwẽ́ejdih ã ñʉhʉchah, jwĩ enep yʉh jĩ. Obohjeéhtih, caandíh jwĩ beh encap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pánih ñʉhna, jwiítdih nin pah ã niíj ej ʉʉ́bh joyóp jĩ: —¿Wã déewãá, queejwã́dih ñi bid jʉicá? ã niijíp jĩ. —Wihcan caá, jwĩ niíj jepahap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Páant jwĩ niíj jepahachah joinít, nin pah Jesús ã jwʉ́ʉb niíj ejep jĩ: —Jéihyepmant bóo bʉwáboó ñíih ñʉodíh ñi yoh báaha en tigaá, ã niijíp jĩ. Páant ã niijíchah joinít, caán ñʉodíh yoh báahana, dawá queejwã́ ĩ chʉ̃ʉ́ʉ́chah joinít, jwĩ́ih ñʉodíh jwĩ wái ñaha bojop yʉh jĩ. Obohjeéhtih, tʉb dawá ĩ jʉmʉchah, jãáj chóoboó jwĩ jéih ʉb yaccap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Páant dawá ĩ jʉmʉchah, Jesúsdih jwĩ jwíih jwãáh láa biíc yoobó ã yapatjidih náhninit, weémboó, Jesús bʉ́dí ã oini, —Jwĩ Maáh caá, Pedrodih wã niijíp jĩ. Páant wã niijíchah joinítjeh, ã tóo dʉg jwejni yégueh chóodih jwʉ́ʉb dʉó ámoh chéonit, ñaáp báah bejnit, Jesús pebhna ã yaáh ñáan bejep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Páant ã yaáh ñáan bejechah, caán ñʉodíh teonit, jwiítboó jãáj chóojĩh jwĩ wái ñáan jʉibínap jĩ. Íim tac yoob póhba ã nihcan jĩí, tʉ́i jwẽ́ej bʉʉgdíhjeh jwĩ jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pánih wái ñáan jʉibínit, Jesús ã chãjni tʉ́i iigní tʉʉ tãóhjih queejwã́ pan biícdih ã lajachah, jwĩ enep jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Páant jwĩ ñáan jʉibínachah, Jesús nin pah jwiítdih ã niijíp jĩ: —Bʉtéh ñi jʉ́ʉt maonitdih daocánnit ñi ʉb jʉ̃ʉ́wʉ́, ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Páant ã niijíchah joinít, Simón Pedro jãáj chóodih waadnít, ñʉodíh watnit, óon coahboó ã wái ñáan jʉ̃ʉ́wʉ́p jĩ. Dahwanit míicjeh ciento cincuenta y tres queejwã́ ĩ jʉmʉp jĩ. Páant moón dawá ĩ jʉmna yʉhna, caán ñʉodíh ĩ boloh wáicap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Pánihna, Jesús jwiítdih nin pah ã jwʉ́ʉb niijíp jĩ: —Ñi jeémp jáa jʉ̃ʉ́wʉ́, ã niijíp jĩ. Páant ã niijíchah joinít, ã pebh jʉibínit, caandíh en poonit jʉmna, “Jwĩ Maáh caá”, niijná, jwiít jwĩ ʉʉ́bh joí encap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Páant ã pebh jwĩ jʉibínachah, Jesús queéj pan biícdih nah teonit, jwiítdih ã wʉ̃hʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Caán yeó jáapdih ã boo pʉd jʉ̃ʉ́wát tʉ́ttimah, jwiítdih biíc peihcanni láa míic jʉ́ʉtna ã chãjap jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Páant jwĩ jeémp péaat tʉ́ttimah, Jesús Simón Pedrodih yʉʉ́pbit nʉmah bejnit, nin pah ã niíj ʉʉ́bh joyóp jĩ: —Simón, Jonás wʉ̃ʉ́h, ¿queét ĩ oyat chah weemdíh ma oi niít? ã niijíp jĩ. —Wã oina caá, Maá. Wã oyatdih ma jéihna caá, ã niíj jepahap jĩ. —Pánih oina, wĩ́ih oveja weh panihnitdih ma tʉ́i inií, Jesús caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Páant niijnít, nin pah ã jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ, páant mʉntih: —Simón, Jonás wʉ̃ʉ́h, ¿yoobópdih weemdíh ma oi niít? ã niijíp jĩ. —Maá, meemdíh wã oina caá. Wã oyatdih ma jéihna caá, ã niíj jepahap jĩ. —Pánih oina, wĩ́ih ovejawã panihnitdih ma tʉ́i en dawaá, Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Páant niijnít, nin pah ã jwʉ́ʉb niíj ʉʉ́bh joyóp jĩ: —Simón, Jonás wʉ̃ʉ́h, ¿weemdíh oyat yoobát niít ma oyop? ã niijíp jĩ. Biíc peihcanni láa “¿Weemdíh ma oi niít?” ã niíj ʉʉ́bh joyóchah joinít, Pedro bʉ́dí jĩ́gahnit, nin pah ã niíj jepahap jĩ: —Maá, nihatdih jéihni jʉmna, meemdíh wã oyatdih ma jéihna caá, ã niíj jepahap jĩ. —Pánih oina, wĩ́ih ovejawã panihnit ĩ jeémát pínahdih ma tʉ́i wʉ̃hʉʉ́. ");
INSERT INTO cbv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yoobópdih meemdíh wã naóhna caá. Jáap jʉm jwʉhna, meemjéh yégueh waadnít, ded ma bejíhipboó mapĩ́ bejep jĩ. Obohjeéhtih, behe ma jʉmʉchah, míih mʉj nahdih ma jʉ́ʉt ñahanachah, meemdíh yégueh yacnit, ded ma bejíhcapboó bita ĩ ʉb bejbipna caá, Pedrodih Jesús ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Páant niijná, Jesúsdih jepahni ã jʉmat jíib, ded pah Pedrodih bita ĩ mawat pínahdih jéihya naóhna ã chãjap jĩ. Páant niíj péanit, —Weém ded pah wã chãjatjidih enniji jʉmna, biíc yoobó ma chãjaá, Jesús caandíh ã niijíp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Páant ã niíj naáwáchahjeh, Pedroboó tac pʉ́ʉd ennit, weém Juan, Jesús bʉ́dí ã oini, queétdih wã ñʉʉ́n péenachah, ã enep jĩ. Biícdih jwĩ pée jeémp láa, weémboó Jesús ã pebh dodh jã́ah lajni “¿Maá, meemdíh eníhcannitdih jʉ́ʉtni pínah ded tigaá ã jʉm?” Jesúsdih niíj ʉʉ́bh joiní wã jʉmʉp jĩ. ");
INSERT INTO cbv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pánihna, weemdíh ennit, Pedro Jesúsdih nin pah ã ni