﻿USE sofia;
DROP TABLE IF EXISTS sofia.cbuNT_vpl;
CREATE TABLE cbuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cbuNT_vpl WRITE;
INSERT INTO cbuNT_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Apanll chtakchu, kanindaatstam, tsapootstam tinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Anpur zar tsap izuuru ndunarimuna; kurimunazimuna. Ichingaru kungunandamuna. Mishat, izuuru tápimuna. Itaru, kungumunsha iwaz Apanll wani mangamangtar ashishtar ashku ksutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mang Apanll tárangiya, 'Sineem taachpa, táyaru, 'sineerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Sheeru, Apanll nap ashku, Kizpurcha wanasiri, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","'Sin kaschireem waani taachpa, mishat tapi waani psaanaam taachpa, mang tárangiya. Anush zar minumtarini tapitaranll ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Apanll mangush chinarangu, Waani íwar kung msas tamapari ashiru taachpa; tsapushsha kung waanitam taachpa, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Sheeru, tsapushsha kungunand taarangiya. Kanindapshat arang kungutam taarangiya. Apusashsha kurimunazeem kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Anush tsimbunarini zar tapitaranll mang ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Apanll tárangiya; Kungoo piyam waanitam wayachima. Puzaatssha waanitam wayachima, táyaru, ");
INSERT INTO cbuNT_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","puzaa tsapu átu ísamarangiya. Itaru, kungootssha mar átu ísamarangiya. Ashiramchu, Apanll tsapoo, mishat kungoo kis naparangiya. Kizpurcha wanasiri, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Waanitam tsapumun mangina kxoonachpa; chirichir waanitam kxoonachpa. Mangintam wanus waani yusiyustanllpa; aranginasha pzapanichpa. Chirichirtam wach arang pzapanichtampa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Amb mangin sheeru taachpa; ichingaru kxoonachpa. Wanus waanitam yusiyku, ashiru taachpa, tárangiya. Sheeru anoo Apanll kis naparangu, Kizpurcha wanasiri, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Anush tuchparini zar tapitaranll ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","16","Apanll tárangiya; Tsapoom tuwasineemaam zareewa wayachima. Waani kanindap zar, tsup, tsangach ashiru taachpa. Zar waani kaschireem 'sineemaam taachpa. Tsupsha psaanaam 'sineemaam achim taachpa, mang tárangiya. Ashkachu, tputssha: Na zar tatsameenlltanda, táchpasinaya. Na in tsup tatsumamaam waritayanlltanda. Kanusamaamtam tatsameenlltanda. Na in masach amb ashtachinipa, tputs ayam ántanchinaya, tárangu, Apanll anoom zareewa wayarangiya. Ashchiri ztaru kanindamand tsapurunasish tuwasineemaam wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Apanll napku, Kizpurcha wanasiri, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Anush ipunpunarini zar tapitaranll mang ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ashiriya, Apanll waani kayupcheewaa kungush taaratartanllpa. Kpurangamashsha waani yuwar mangamangtanllpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","22","Kungushuch waani watareew taaratartanllpa, tárangiya. Sheeru napku, kungush kayupich kuringkuringtangat, yuwarsha nap ashku, ichingaru kpurangamash mangarurtangat ashirangiya. Apanllsha naparangu, Kizpurcha wanasiri, tárangiya. Waani kungushuch kpukchu, kayupchirtatam ichingaroom tsapurunas pzapanintanllpa. Zamizsha waani wayangchirtatam ituwartakchu zamzeem pzapanintanlltampa ichingaroom tsapurnasi, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Anush zar zameetpatarini tapitaranll mang ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Apanll tárangiya; Waanitam maachi kayustaneew tsapush taachpa. Chinuzeetssha waani tputs ksutku taachpa. Mishat, tsapumun pshiyrataru an waanitam taachtampa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Sheeru Apanll napku, Kizpurcha wanasiri, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Maacheetsi tinamaam iwatsparamchu, anush Apanll mangush chinarangu, Na tputseemsha yaana tamapari ashiritam tinayani, tárangiya. Waamari tputsimari kurak tamapari ashiru ichingaroo kasiru taachiya. Kungushcheetstamta, manginshucheetstam, chinuzee chinutarich anootstam, misha tsapush pshiyrataru anootstam tputsimari kasiru taachiya. Waamari tputs mangurir kasikastachpa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tárangu, tputseemshat tinarangiya. Chtaru kamuzaatsima tinarangu, anumunshat wipunasheemsha kizaatssha tinarangitamta. Waana tamapari ashtamaru mang' kapung tinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tinaramchu, tputsee tárangiya; Mangis kis taangtsa. Aranginasha iparis pzapaneengtsa. Tsapurnasish ashchiri shuneeyarus tatsitangtsa. Sheerus, siyamari ichingaroo kasitssa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Táyaru, arangeem yusur kamachtarangiya. Manginshucheetstam wanus ktungangtsa. Mishat, wanuseetstam wach katungchitamsa. Mishat, tsapushtam yutataru anootstam katungchitamsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ashiriya, zamzeetssha manginaa wanus katungku taachiya, misha tsiripcheetstam karutaa wach katungkusin taachinllinaya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ashiriya, Apanlli amb ashiramchu, napku, Ichingaru kizpurcha wanasirinanda, tárangiya. Anush, minamtarini matayaru zar tapitaranllu, tinamaam iwatsparangiya. Putam tarasitaranll mang ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ashiriya, na yuwaa Apanlli tinamaa iwatsparangu anootsi kamaneena. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tinamaa iwatsparamchu, arangich tsimbun matayaru zar tatsamooramchu anush Apanll kanusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ashiriya, Apanll tárangiya; Zar arangich tsimbun matayaru maats tatsamkachu anush kanusish urutamari taachpa, watam anush nuw kanusaranginawa, tárangiya Apanlli. Ashiriya, na kamaneena yuwaa Apanlli ichtakachuri arangich tsimbun matayaru zar tinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Apanlli kanindaa misha tsapootstam tinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Anpur mzats ndunarimuncha, mishat tatsumshishtam ndunarimunatamcha, watam tputs tarawaztamaam ndunarimunatamtawa, sin ndunarimuntamta. Nda sinatariya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Anpur Apanll msas ashiru zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ashiriya, Apanllsha tsapupa tputseem tinarangiya. Tsapupa wayapur tinaramchu, mang shipashsha tapus ashirangiya. Ashkachu, taarashee panarangu, tputseemsha kamuzaamsha kinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tinaramchu, anumunsha, yap zar yaku amb Edengap arangeema, Apanll tipuranlliz mzatseem ashiru wanasireew wayarangu, anushsha tputsee wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mzatsushshat kizpur wanasireew tatsumim wanus zapan katungamaam taarangitamta. Anushshat Apanll mzats apusanand tsimbun yasin tatsumirangiya. Min tatsumim kizpur wanasirimshi. Tputsich anoo wanus katungkachuch, urutamari taachinllinaya. Minungichichsha tatsumim wayarangitamta. Tputsich katungkachuch, chínash wanasirimshee yasachchee, mishat yutaritamashee yasachtamchee. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Anushsha Edenganung kung naantar ashirangiya. Arangeemsha muchup ipunpunar kung pzeenarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kung Pisonga, misha kung Guiyona, misha kung Tigirisa, misha kung Eufratisa, aship kung pzeenaru taarangiya. Ichtakachuri, kung Pisonga tushaparangiya. Ambiri muchup tsap suru Hapira taarangiya. Anush maachi kizpur wanasirimash zapan taarangiya; oroo, ");
INSERT INTO cbuNT_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","misha patumbich kurakurtangatu, misha yasin kzammashi antam, aship maachi kungup much taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mishat, arangeem kung tsimbunarini sur Guiyona tushaparangitamta. Muchup tsap sur Kusa taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Anumunshat, arangeemsha kung tuchparini sur Tigirisa tushaparangitamta. Yapeem zar yaku ambeem tsap sur Asiriya taarangiya. Mishat, arangeemsha kung ipunpunarini suru Eufratisa tushaparangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ashiriya, Apanllsha kamuzaa mzatsish Edengash wayarangiya. Shiy mzats ksutangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Itaru waneeyaru: Ichingaru wanus shiy zandkush ktungangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Itaru, mzatsish apusanand tatsumim taaru anoo wanusi ktunginllpa. An tsipatsimashtanda. Anoo katungkachinaareesha, urutamari tsipiptatsha, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Anumunsha, Apanll; Kamuz waani minum taaku pinasakcha. Ashiriya, nimun wipunasheem tinachima. Ashkachuri, waanpatatin uru kis ipunkusin taachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Apanllshat ichingaru tinarangiya; manginshucheetstam, mishat purangtaru anootstam ichingaru tsapuptari tinarangiya. Sheeru, kamuzaatsshat tárangiya; Shiyshat ashpari maacheetsi suroom ísamangcha, tárangiya. Táyaru, tputssha anooritam maacheetsi ichingaru suroo ísamarangiya. Ashirucha, natpur anooritam iyshat suroo tssurtakuni taakaniya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Tputssha zamzee, chinuzee, maachee kayustaneew, manginshucheew, kpurangamsheew, kayupcheew, ashpa anoo ichingaru ísamarangiya. Zamiz waani minamtawari sur taachinllinpa, tárangiya. Itaru, kamuzaamsha wipunasheem wand ndunarimuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ashiriya, Apanllsha kamuzaa tumachirtarangiya. Tputsshat kizpur maramchu, anush Apanllshat tputsee watandaram iwachirangiya. Watandaramaa iwacheeru, kararamchu anoo yusursha waanchichitam wanuts yáyaru, tapatstarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yuwshat kamuzaa watandaram yarangu anootsshat kizaamshat tinarangiya. Ashiramchu, anush kamuzsha támarangiya. Apanllshat, Neewa, shiyaam ipunshish, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kamuzshat kizpur mangu ksarangiya. ¡Kizpurcha wanasiriya! Nuwaana nutsi tamapari ashiritamta, watam nuwaantatam nutsinawa, mishat watam nuwaantatam napurinawa. Ashiriya, nee kizaa, Izanllchee, táchshaparina, watam nuwash shitungaranguwa, mang kamuz tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Apanllsha tputsee tárangu: Ashiriya, tputssha kamuz uruta waparee, wanireetstam kasayaru, izuuru wizanllpatamarisha minumaripaz nutsas ashirusin taachinllinaya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ashiriya, tsimbunartisin zapeersin taaranganaya. Itaru, yuwaa zapeerangana anoo pakchiyam nda tácharangusin, yasarangazinllinaja, izuuru mapiyrsin taaranganaya. Ashiriya, na kamaneena yuwaa Apanll kamuzaa wizanllpatari tinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Apanll maacheetsi ichingaru tinaramchu, anshutam maak kizpur tamapingampan taarangiya. Ashiriya, maaksha kizaa mang masharangiya: ¿Apanll shiyaa amaranga? ¿Mzatsshuchee wanus ktungintspa, ndusha tárang? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kizshat: Nda, ¿nitaati Apanll amb ateeja? Dancha. Wanusee ichingaru ktungangtsa, tárangcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Itaru, minam apusanand mzatsish xiyaru anootsimari ktunginllpa; misha ayamtaatiya ptatinllpa. Patatkachinaareesa ashiru, uru tsipatssa, Apanll tárangcha, kiz mkaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Maaksha: Nda, uru katungkachitaateesa nda tsipatssa. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Siyaa Apanll pachindkucha atasha. Watam nee wanusee katungkachus uru kizpur yasatssa. Waana Apanll tamapari ashiritamtis taatssa. Chinashis wanasirimshee yasatssa. Mishat, yutaritamasheetstam yasachitamsa, maak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ashirucha, kizsha wanusee napeeru, Kizpurcha wanasiriya, tárangiya. ¿Tamareeja? Katungachuri, kizpurshapari yasachina, mangush chinaku kiz tárangiya. Naantachu, wanusee pusayaru, katungkarangiya. Wazaranlleemshat, Na shiysha káchangancha. ¡Kischa! tárangiya. Wazaranllshat anuritam ayu táyaru, katungkarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Katungam iwatsparamchusin, mangush chinakataraa ashiranganaya. Waanaatstisin nap ashkusin, Zapeerniwa, mang tárangusin, kizpur paziranganaya. Ashirucha, masharpasha k'tayarusin, anpa maxaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mang pukamatsha zar kchizataramchu, Apanll mzatsish káyashinu naantachu, anoo mazinanataranll ashiranganaya. Papcha, Apanll naanllpa. Tapisheeni yasinshu, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Apanllshat kuruzurangiya. ¿Yapshasa? ¿Tamaksa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kamuzsha: Shiyap kusamaam paziktanicha; watam zapeeraniwa. Ashirucha tapisheerini, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Apanllshat; ¿Chaksha siyaa, Zapeetischa átu, Zapeetanicha átssa? tárangiya. ¿Ndusha nuw yuwaa ktunginllpa tárangi anoo katungeeris? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kamuzsha; Yuw shiy kizaa ipunsheemi panarangish ancha nuwaam martayranda. Ashirucha, nuwsha katungeeri, kamuz tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Apanllshat kizaa masharangiya; ¿Mayaamsha amb ashirangsha? tárangiya. Kizshat; Maakcha nuwaa tamapingayranda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Apanll mkaatsshat; Yuwamand tputsee tamapingarangish anumand kizpur kiyung kachiyachsha. Shiyamari maacheetsi kasiru mantsirimish taakush, kiyung kachiykush taachsha. Uru nimun titkurpatish pshiyrapshiyrtansha. Tsapumun chishish ipuxpuxtar ashkush, tsapuri katungkush taachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Shiyaatsimari ichingarusin tputs kundartaksin taachinllinaya. Ayamtaati kiz nllurnur shiyaatsimari kundartaksin taachinllinaya. Itaru, minam tputs shiyaa kasichiya. Yuwamand shiy wanashiree kapuxkachish anumand uwsha shiyaa mucheetsish tsaritsartachiya, Apanll tárangiya mkaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Apanll kizaatsshat tárangiya; Watam shiy nuwaa kuki kapeeteerush katungkarangshawa. Urutamari shiy iparinakush, wasuree kiyung kachiychitanllsha. Mishat, zaranllimaritish shiyaa kasiku taaratartanllsha. Shiysha uru zaranllingazish zandkush, chinakush tachitaa kizarush ashichsha, Apanll kizaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Apanll kamuzaatssha tárangiya; Shiysha izanlleetsish kuk payuyarush, wanusee katungkarangsha. Yuwamand nuwaa kuki kapeetarangish anumanda na nimun arang urutamari tarawaztayarush, kchitakush taaratartansha. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mzakush, urutamari kpaa kiyung kachiychiytansha. Mzarshish karut urutamari karutaku puptanlliya; kiyung kachiyachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mzatsee tarawaztakchush, msastatansha. Ambiri ashkush, anpa katungkush kchitachsha. Anuri ashkush tsipachsha. Tsipakchush, yusur wapitam tsapoomatam kinachsha, watam nuw shiyaam tsapuptatam tinaranginawa, Apanlli kamuzaatssha tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mang kamuz suru Ataga. Wizanlleetssha sur Epa ísamarangiya. Watam ichingarusin Epamand tputs pzapanichinllinaya, tárangiya Ataga. ");
INSERT INTO cbuNT_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","24","Ashiriya, Apanllshat kamuzaa misha kizaa ashiru maachi tas tumaxtarangiya yuwaam zapeerna anooma. Apanllsha tárangiya; Ashiriya, kamuz, kiz ashirusin yaana tamapari ashiritamsin zapan chinaksin taakanawa. Yutaritamashee mishat wanasirimshee yasakusin, ashirusin taakanaya. Ashiriya, tputsee Edengash mzatsi tashitungchima. Tashitungayaruri, arap wayachima nda wanusee wanasirimshee taarashipanee katungamaama; watam katungkusin urutamari taachinllinaya, tárangiya. Táyaru, tputsee tashitungayaru, piyamsha zanganirangiya. Ambirisha tarawaztakush taangcha, tárangiya. Táyaru, anumunshat Edengash yap zar yaku amb wasundururee ksutamapaneem wayarangiya. Nda tputs anush wanusee wanasirimshee patatamaama, átu wayarangiya. Anumunsha, mchit wazuran sumas tamapari ashiru kurakurtaru anush wayarangitamta. Anshat, mchit piyam naanataraa piyam naanataraa ashirangu, ngootsee kámanarangiya. Nda tputs nish mzatsish pshtumaama átu, ashirangiya Apanlli. Ashiriya, na kamaneena yuwaa Atagarini Apanllee kuk kapeetarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Atagarini Eppat wizanllpa maarangana. Anush wipsha ichtamarini wanindarangiya. Suroo Kayínaa ísamaranganaya. Epshat, Apanllpari nuwaam ipareemi panayandanaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Anumunshat zapish, yusur wip kamuztam wanindarangiya. Suru Abela ísamarangiya. Sheeru, zoonllpatari kanungaranganaya. Abela chinuzpan opeejpanimuna ksutamapan taarangiya. Kayínshat mzatspaneem tatsumapani taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Anumunsha zapish, Kayínarini Apanlleem ungirtamaam mazarish wanusee pusayaru, anpat Apanlleem ungirtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Zoonllshat Abelarini, uwshat Apanlleem ungirtamaam chinoo opeeja putarangiya. Yuwanandari karupanawa kizpur wanasireewa annandari ipuseeru, anpat Apanlleem pachayaru, mucheeru, kis ungirtarangiya. Ashirucha, Apanllshat Abelarineetsi kis naparangiya yuwaa ungirtaku Apanlleem ashirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Itaru, Kayínarineetsshat Apanll nda kaapa kis naparangiya yuwaa wanusee wayarangu anootsi. Ashirucha, Kayínarinshat kizpur tsiyantarangiya. Zoonllee pamaam nda zandarangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Apanllshat; ¿Mayaamsha kapung tsiyantaksha? ¿Zuwanlleetsish natsamaama zandaksha? ");
INSERT INTO cbuNT_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mangish ksanaari taakush, uru kisshapari taachsha. Itaru, arang tsiyantakinaareesha, papcha. Tsiyanus kasiyanllpa. Itaru, shiyshat tsiyaneetsish zambazangcha. Mapiyrush taangcha, tárangiya Apanlli. Kayínarinshat Apanllee kuk nda mazinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Zapishsha, Kayínarini zoonllee tamapingayaru, mzatsip machtarangiya. Ansha mzatsish kuseeramatssin, Kayínarinshitini zoonllee putayaru pacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Apanllshat Kayínarineetsi másharangiya. ¿Natuwa? ¿Zuwanllish yapshita Abela? tárangiya. Kayínarinsha: Nuw yasareezi. ¿Antaati nuw zuwanlleemi ksutamapan taakinawa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Itaru, Apanllshat: ¿Mayaamsha amb ashiksha? Nuw shiyaa paranginawa; zuwanlleetsish ursir tsapumun tuchumurangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Yuwamand zuwanlleetsish ursir tuchumurangish tsapushu anumand uru nuw wanichinllpa. Watam zuwanllish ursirimand, Waneengi, atuwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mishat, yuwamand zuwanlleetsish tsapumun ursiree tuchumurangish anumand uru mzakush, tatsumkush, nda kxunku taachiya. Arap tsap naachsha minup tsapurunasiya. Ambiri masarush xixtarashin ashichsha. Kiyung kachiykush taaratartanllsha, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayínarinsha kizpur mang' mantsarangiya; punirangiya. ¿Tamari amb ashkuri kis taachee? Nuwaa kapung kiyung yachamaam shiy zandaksha. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","¿Tamari tsapuneetsi arap kasachi? Mishat, ¿tamari shiyaatstam, Apaa, arap kasachi? Amb ashkachinaareena, nuw arap masaruri xitat ashkuri, nuwaa tputs pachachapandanaya, watam minumtinawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Itaru Apanllsha: ¡Ndaj! ¿Tamari shiyaa tputs pachach? Shiyaa tputs pachakchinaari, nuwsha anoo tputsee kizpurinasha wanichima. Shiyaa waneerangi anoo kasirinashta. Ashiriya, shiyaa tputs nda pachamaam nutsimunish yandayarunll kasachinllpa. Anumunari shiyaa tputs pakchusin, natstakchusin, nda shiyaa pachachinllinaya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Amb táyaru, Apanll zanganirangiya Kayínarineetsi. Itaru, Kayínarinshitini mang naatarangiya. Maachiritawaa kasarangiya. Apanlleetstam arap kasarangitamta. Sheeru, yapeem zar yaku amb naatarangiya. Ambiri taarangiya. Ashirucha, tsapoo suru ísamaranganaya Masangunazi atusina, itaru Hebrewshuchsha kuk Nod atiya, watam masaru taaratartarashin ashtaruwa. Ashiriya, na kamaneena yuwaa Kayínarini zoonllee Abelarineetsini pacharangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Yapiri masataru taarangu ambiri Kayínarini wizanlleem yamarangiya. Anush wip kamuz iparinarangiya. Sur Enoka ísamarangiya. Anumunshat, wipsha pzapaneeyaranllu, pangoom, pangu, pangu ashirusin, yaktaa sur Enoka ísamarangiya. Wipatam suru Enoka ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Arangshat, Kayínarini wizanll iparinarangitamta. Wipaa sur ísamarangiya Irada. Iradaatssha wachinayaru, uwshat arang iparinarangiya Meyujaela. Meyujaelshat uwshat iparinarangitamta Metusaela. Metusaelsha uwshat iparinarangitamta Lamekaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamekshat wizanlleem tsimbun yamarangiya. Min wizanll ichtam sur Adamuncha. Anumunsha mashingamarinshitini suru Silámuncha. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ichtamarini Ada wipaam iparinarangiya Jabalaamshita. Jabalshat chinuzpanimun taarangiya. Pangoomshat chinuzpat tas pangurangiya. Jabalchichimun tputs ichingaru taspa pangoom pangu, pangu, sheersin anush taataranaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Anumunshat yusurshat Ada iparinarangitamta Jobalaamshita. Jobalshat kitarpanimuna. Kitartama kizpur yasarangiya. Tiruchimaam yasarangitamta. Jobalchich tputs ichingarusin anpaneewtamsin taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Mishat, Lamek wizanll mashingamarinshitini sur Selá iparinarangitamta. Topalkayina sur ísamarangiya. Topalkayinshat ichingaru maacheewaatsi tinamaam yasarangiya. Ngusambawaatstam mishat yuwapa tarawaztatarich anoowaatstam ichingaru tinamaam yasarangiya mbammasheewaatstamta. Mishat, wizarsha taarangtamta suru Nahaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Minushshat zar Lamek wizanllee tsimbunaatsiri Adaatsi, mishat Selaátsi ashiru tamasingaru kapung tsiyatarangiya; Izanllee, siysa nuwaam kurakaatsi kuki mazinangcha. Kanungas nuwaa tpeerangu, nuwshat anumand kapung tsiyantaranguri, anoo kanungasee pacharangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mishat, waanari yuwamand ashirangi anumand tputs kisatamaam zandkinaariya, nuwsha kizpur wanichima. Zitamina Kayínarineetsi tputs pacharanginaariya, anumand sietinasha tputs tsipamaam waritaranginaparee. Itaru, nuwamandsha setentisietinasha tputs tsipamaam waritachiya, Lamek wizanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Atagarinshitini yusursha wizanllpa maarangana. Sheeru, Epsha mireerangshita. Mireeyaru, yusursha tatsipurangiya. Wipaa sur Set ísamarangiya. Ashirucha, Epsha; Apanll nuwaa kizpurparee chinakiya. Napangi, ipareemi yusursha panayanda Abelamuncheema yuwamunach Kayín pacharangu anumunchiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setshat kanungeeru, uwshat arang iparinarangitamta. Enos suroo ísamarangu. Anpursha zar ashpatam tputs Apanllimun sur Apanllee ungirtamaam chtaranganaya. Ashiriya, na kamaneena yuwaa Atagarini Setaam iparinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_1b","002_5_1b","GEN","5","1b","1b","Ichtakachuri Apanll tputseem waana tamaparee ashiru tinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Minum kamuz, anumunsha minumtam kiz ashiru Tinayaru, Apanllsha, Nee, Tputsee, atina; watam nuw tamaparee ashiru chinakanawa, tárangiya. Apanllsha anoo tputs kizpur chinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Atagarin mang taarangiya 130 masachirini yuwapur Setaa iparinarangu anpur zari. Setshat wapar wach tamapari ashtamaru nllurtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Anumunsha zapish Atagarini 800 masachiri taarangiya. Anush wip arangshat pzapaneerangiya; kamuztam mishat kizatam ashiru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ashiriya, zapishshat Atagarini 930 masachirini taaramchu, anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Anumunshat, Setshat mang 105 masachirini taaramchu anush Enosaa iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosaa iparinachu anumunsha arang 807 masachirini taarangiya. Wipshat anush uwshat arang iparinarangiya kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ashiriya, zapishshat Setarini 912 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Anumunshat, Enosarinshitini 90 masachirini tatsamooramchu anush iparinarangiya. Wipaa Kayinaga sur ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Anumunshat arang Enosarini 815 masachirini taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ashirucha, zapishshat Enosarini 905 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Anumunshat, Kayinagarinshitini 70 masachirini taaramchu anush iparinarangiya. Wipaa Malalela sur ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Anumunshat arang Kayinagarini 840 masachirini mang taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ashirucha, zapishshat Kayinagarini 910 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Anumunshat, Malalelarinishitini 75 masachirini taaramchu anush iparinarangiya. Wipaa Hareta sur ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Anumunshat arang Malalelarini 830 masachirini mang taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ashirucha, zapishshat Malalelanini 895 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Anumunshat, Haretarinishitini 162 masachirini taaramchu anush iparinarangiya. Wipaa Enokaa sur ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Anumunshat arang Haretarini 800 masachirini mang taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ashirucha, zapishshat Haretarini 962 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Anumunshat, Enokarinshitini 65 masachirini taaramchu anush iparinarangiya. Wipaa Matusalemaa sur ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Anumunshat arang Enokarini 300 masachirini mang taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Washunandari Enokarini 365 masachirini taarangiya. Anush mang Enokarini Apanllee kizpur chinarangiya. Apanllee kuk payurangiya. Ashirucha, Apanllsha Enokaa yamakchu, Enokshat tsípata ashirangiya. Enokarini nda tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Anumunshat, Matusalemarinishitini 187 masachirini taaramchu anush iparinarangiya. Wipaa Lamekaa sur ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Anumunshat arang Matusalemarini 782 masachirini mang taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ashirucha, zapishshat Matusalemarini 969 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Anumunshat, Lamekarinshitini 182 masachirini taaramchu anush iparinarangiya. Wipaa Nowe sur ísamakchu, ");
INSERT INTO cbuNT_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","anush tárangiya; Sirú Apanll tsapoo mbamaam wayarangu, iysha tarawaztakuni, kiyung kachiyarangani. Itaru, nimandana iparimandi ndushaparee kiyung kachiychiniya, tárangiya Lamekarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Anumunshat arang Lamekarini 595 masachirini taarangiya. Wipsha anush uwshat arang iparinarangitamta kamuztam mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ashirucha, zapishshat Lamekarini 777 masachirini tatsamoochu anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Anumunshat, Nowerinshitini mang masachirini 500 tatsamooramchu anush wip kamuzanand tuchip wanindarangiya. Suroo ísamarangiya iwachiztamaa Simo, mishat Kamu, mishat Hapeta ashpamuna. Ashiriya, na kamaneena yuwaa Atagarini wip Setchich pzapaneerangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Yuwapur Nowerini taarangu anpur tputs tsapurunasish zapan pzapaneerangana. Uwshtisin arang iparinanatara, iparina ashiranganaya; kamuztam misha kiztam ashiru pzapaneeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ashirucha, Apanllchichtisin wip piyartacheewa wip kizaa paksin, anungaziri támararanganaya. Tputsee wip parangusin, yuwaatsimari zandarangana anootsimari yamakaktangat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ashiriya, Apanllsha: Yuwamand tputs yutarit taakana anumand nuwshat taarashee ningatsha wayachima wanuts musásimasheemshita. 120 yungandpasimunarishta wachinayarusin, tsipachinllinaya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Anpur ashpatam tputs wazuraneewa, wanuts kapunguwatam, tapazpaneewtam taaranganaya. Anumunshat, Apanllchichtisin wip piyartacheewa wip yamayarusin, kurakaamaw pzapaneeranganaya. Tsiyatsis waamunamari zapan kimarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Zitaminarini ichingarusin chínash mantsiri chinaranganaya. Ashirucha, Apanllsha yuwaa tputs ashkana anoo parangu, tárangiya: Anootsimari yutaritshisheetsimari kis chinakana. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nuw anoom zandkeezi. Yuwamand tputseem tinarangi, itaru yutaritaam patatarangana anumand nuwcha mangi mantsakina. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ashiriya, nuw tputsee izuuru wanichima; ichingaru tpachingachima. Ichinguru zamizpatarta, maachit purangtaru anpatatam, mishat manginshuchpatatam, ichingaru tpachingachima. Tputsireemi tinarangitaati, ¿mayaamaja nuwaa kuki kapeetak? Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Táyaru, Noweetsimsha kis napkina, Shiy wanasirtishcha, tárangiya. Ashiriya, na kamaneena yuwaa tputs yutarit taarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_9b","002_6_9b","GEN","6","9b","9b","Tputs yutaritshisheetsimari chinarangana. Itaru, Nowerinsha nda ashirangiya; Apanlleetsimari kapung chinarangiya. Mang' kis Apanllpata ipunarangiya. Tiptsirshtisin Nowee kis naparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Wipsha tuchpamuna: sura Simo, Kamu, Hapeta; aship taaranganaya ");
INSERT INTO cbuNT_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Apanll tputsee parangu, ichingarusincha yutaritshisheetsimarit chinakana. Tsiyantaksin, waratkusin, pachakaktangat ashkusin, ichingaru tsapurunas ztaru ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ashiriya, Apanllsha Nowee tárangiya: Tsapurunasshuch tputs ichingarusin yuwaatsimari waana zandkana anootsimari ashkanaya. Nda pakchiyam nuwaa chinakanaya. Ashiri nuw ichingaru tpachingachima. Izuuru kachingchima. Yuw ichingaru maachit manginshuch tsapurunasush taakana anoo tpachingayaruri kasachima, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ashiriya, shiysha karipanpa boteem kapung warkashtangcha. Nda kuchamaama ichingaru pingartangcha; wantsush pingartaku, minsha iwaz pingartaku shingcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","16","Ashiri boteem tinakchush, tuchip pisu, anumunshat iwaz 'sineemaam wachoo wayangcha. Sheerush, wantsush tandapunu shingcha yuwash maachi ichingaroom wayachish anooma, Apanll Nowee tárangiya. 150 metoro wazuranirini botee tinangcha. Zánganarinshtini 25 metoro, íwaririnsha wingu 15 metoro, ashiru boteem tinangcha. Mishat, yuwaari 'sineemaam wach chawap metoro karartangcha. Mishat, wachoom tinangtamcha pshtumaama. Ashiri yuwari nuw kamachtarangi anuritam shingcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Yuwaparamchush, nuwsha sinaa kizpur zanganchima. Tsapoo ichingaru puchiya. Ichingaru yuw nuw tinarangi anoo izuuru tpachingachima. Ichingaru tsapurunasshuch tsipachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Itaru, siyamaritis kamungatssa, watam nuw shiyapat amikurtaranginawa. Ashirucha, shiyamari iparpatish, izanllpatatamtish, iparpatatamtish wizanll botish zarungtsa, atashina. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mishat, maachi zamiz ichingaru yamangcha. Upapchir minam, wizarsha minamtam ashiru, yuw ichingaru tsapush taataru anootsi, ");
INSERT INTO cbuNT_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","yuw pshiyrataru anootstam, tsiripcheewtstam, chinuzeewtstam wakaraa, botish tuzarungcha. ¿Tamashta yusur ayam pzapanichinllina tsapurunasshu? Ashpari boteerishish tapshtungcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mishat, watungasheem pshtangtamcha maacheemi chinuzeem maritamaama, tárangiya Apanlli Noweetsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ashirucha, Nowerinsha anuritam botee tinarangiya yuwaa Apanll kamachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ashiri botee ichingaru iwaparamchu, Apanllsha Nowerineetsi: Shiya misha ipartamtish wizanllpatari zarungtsa. Ashiri nuw siyaa tapachindachintspa. ¿Chakaja shiyapa tatsamooch? Siyamari wanasirtischa. Shiy wanasir taamaam chinarangsa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","4","Nimun tsimbun matayaru zari sinaa zanganchima. Sin sinasintar ashku 40 zar taachiya. Ashiri wanasir mazinangcha. Yuw maachi ichingarusin taakana anoo yamangcha. Itaru, zamzimari upapchiri 7 yamangcha; misha wizarsha sietitam yamangtamcha ayam tsapurunasish pzapaneemaama. Mishat, manginshucheetssha mantsamoo upapchir minamtam wizar minamtam ashiru yamangcha. Yuw katuchkachu anoo izuuru tpachingachima ichingaru tputspatatamta, Nowee tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowerinsha, Ayu tárangiya yuwaa Apanll kamachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yuwapur sin sinamaam chtarangu anpur Nowerini 600 masachirini taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Chiynaa kamungachpachee, tárangusin, wipapat, wizanllpatatam, wipaptatam wizanll ashirusin ichingarusin zaruranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Maacheetsi ichingaru izarurangiya. Zamzee, purangtaru anootstam, pshiyrataru tsapushu anootstam, ichingaru tsapurunasish taakana; manginshuchi anoo tapshturangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Upapchir, wizar ashirusin kusatarangusin, Nowepat washunand zaruranganaya, watam Apanll waana kamachtaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Zaruramchusin, anumun tsimbun matayaru zari tushiyramchu, anush tsapurunasee tayutaritamaam chtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","12","Nowerini 600 masachirini taarangiya. Anumunsha tsimbun tsupi tushiyramchu, kanindamand sin kapung zaw zaw ashirangu, tsapushsha kazupeeru anush kung kapungtam zaw zaw ashitangattamta. Ichingaru zar psaanpatari putam putam ashiru sinarangiya. 40 zar sinarangiya. Nda pastarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kaapa nuwaa kuki mazinangtsa. Anpur zar ndatuma sin sinaru, Nowerini botirinshini zaruranganaya. Ichingaru wip ashparta Simo, Kamu, Hapeta, wip wizanlli tuchparitamsina zaruranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Sheersin, maachitpatari washunand yapatarsin, zamzitam, manginshuchtam, chinuztam, yuwatam tsapumun pshiyrataru anutam zaruranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ashirusin, washunandari maachi ichingaru upapchir wizarpatari tsimbun tsimbun ashirusin botish zaruranganaya. Nowerini yuwari Apanll kamachtarangu anooritam tuminurangiya. Ashiramchu, ichingaru maachi zarum yuwaparamchu, Apanllsha waana wachoo mbam shtandayaru kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kizpuri ichingaru zar sinasintar ashirangiya. 40 zar kaschiritam psaanpatari sinarangiya. ¡Maya! tsapoo ichingaroo purangiya. Botsha pamuzingarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","¿Mayaatseeja nda puch? Ichingaru purangiya. Itaru, botsha muziztar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kizpur kung kumbiyrangu, ichingaroo macheewa yuwaatstaa kizpur íwar anoowaatstaa purangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ashirangu anumunsha, kung wandari aranginasha machee kuwiz arangich tsimbun matayaru metor kánuru purangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ashiriya, ichingaru manginshuch tsiparanganaya. Izuuru maachee pchingaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yuw tsapush maachi zamiz ichingaru taakana an, misha mantsamtam ichingaru kungumun tsiparanganaya. Minamtiyam nda kchitarangiya. Tputstam ichingarusin pchingaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Maachi ichingaru kchitamuntaa taarangu, ashiritaa Apanll waana izuuru tpachingarangiya kungupta. Itaru, Nowerinchichimari tputs botosh ichingarusin kamungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kungsha watam tsapurunasee zameetpat tsup izuuru puru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Anush botish taar ashkusin, Apanllsha Nowerineetsini ksutarangiya. Ichingaroo ashparitaa chinarangiya; nda mbizarangiya. Zamzeetstam, manginshucheetstam kizpur chinarangiya. Waana wizpuririni kambusuroo zanganirangu, kungsha manasamaam chtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Mishat, kung mimim shitangat ashirangu antam zanayarangiya. Mishat, sinasintar ashirangu anutam tsíparangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sheeru, zameetpatash tsupi manasam chtarangiya. Anush apinll manas, manas shitarat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ashiriya, tsimbun matayaru tsupi tushiyramchu, anumunsha 17 maatsi bot mach sur Araratamuna tamuyeeramach ashirangiya. Tamuyeeramchu, anamunsha kungsha aranginasha manasatarat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","10 tsupi anumun minam maatsi tushiyramchu kung manasarangiya. Tsapoo machee íwar paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Machee paramchusin, anumunsha 40 maats tushiyramchu, Nowerinsha botee wachoo tawatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Yunganee putayaru, yachamaam zanganirangiya. Itaru, yungansha naatarangu, nda waptam kanapurangiya. Ndaturi manasaru, piyamsha mangakatara, piyamsha mangakatara ashishtar ashirangu, Waziweeyi, átu, xapoorangu, ambirisha tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Sheeru, Nowerinsha ¿Tamaa kung manasakachtee? tárangu, mukukootssha yachamaam zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mukuksha naatarangu, yasinaa naxpoorangu, wapitam botish kusarangiya. Nowerinsha mukukoo putayaru, washtam wachush yapshturangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Sheeru, yusursha minam simanaa tushiyramchu, anumunsha yusur mukukoo yachamaam zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mukuksha naatarangu, zar pukamchu masharootssha kamachip waru olivo kasutsutanu yushindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ashiriya, anumandsha Nowerini kungoo yasarangiya. Manasayanllparee. Napa, masharoo yushindayaru, tárangiya. Yusursha minam siman tushiyramchu, mukukoo putayaru zanganirangiya. Mukuksha naatarangu, ambirishat tsípataramach ashirangiya. Ashiriya, na kamaneena yuwaa Apanll tsapoo kungupa purangu, itaru Nowerinsha nda tsiparangu anootsiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yuwash Nowerini 601 masach tatsamooramchu, anush tsup tsap puzarangiya. Anshurtatam zar, masach, Nowerinsha ashchiri pangoo tawatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Anumunsha, tsimbun tsup, yusur 27 zar tushiyramchu, tsap wanasir puz ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Apanllsha Nowerineetsi, Shtungangcha ashparitis, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Iparpatartish, izanllpatartish, iparpatartamtish wizanll shtungangcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sheerush, zamizsha tshitungangcha. Ashpari maachi ichingaru manginshucheetstamta tshitungangcha. Waani arang pzapanichpa tsapurunasshu, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nowerini botosh shitungaranganaya, wipaptarta, wizanllpatatamta, wipaptatam wizanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sheeru, zamzeetssha manginshuchpatari ashpari tashitungartaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Sheeru, Nowerini, Apanlleem ungirtapi átu, patumbchee xanateeru, zamzee putayaru, minchich minchich sheeru, anush muchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Apanllshat anoo kis naparangiya. Ksatam ishingarangiya. Kizpuritam mang' ksarangiya. Apanllsha: Na nimun ndusha kungupat tputsee tpachingachima, tárangiya. Tputs kanungasimandari mantsir taaktaateesinaya, yutaritshisheetsimari chinaktaateesinaya ashiru, yusur kungupa tputsee tpachingcheezi ndambari. Maacheetstatam zamzee, manginshuchee nduntam yusur kungupat tpachingacheezi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ndatuma tsapurunas pastaru, Siy tputsis tatsumkus, pusakus ashkus taatssa. Zaritam ksaneemaam, mishat kachizaamtam taachiya. Minurpasaamtam, zarpasaamtam ashishtar ashku tsup tushiychiya. Mishat, psaanaamtam, kaschireemtam ashiru ayamtaatiya urutamari taachiya. tárangiya Apanlli iyaam tsapurunasshucheemani kasakchu. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ashiriya, Nowerineetsi Apanll tsiyatarangiya ichingaru wipaptarta. Na nuw shiyaam kapung istachintspa. Siysa ipareemis iwanzukinaareesa, urupa tsapurunasish pzapaneerus taatssa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","3","Siyamari manginshuchee, zamzeetstam, kungushcheetstam, tsapumun pshiyrataru anootstam, ichingaroo siyamari kasirus taatssa. Ichingaru maachi tputseetsis punichinlliniya. Siyamari katungkus taatssa. Washunand yuwapa tatsumkis anpat ktungangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Itaru, zamzeetsshat katungamaam zandkus, ursiree izuuru kapeeteerus ktungangtsa. Watam zamiz ichingarusin ursirimuntam kchitaru taakanawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Mishat, ngutish tputsee pcharintspa. Watam tputsee nuwaana tamaparina ashiritam tinaranginawa. Tputssha waannaari tputspatatin pachakchinaari ashiru, siysa anumand tputsee pchangtamtsa. Mishat, manginshuchsha kázamish tputsee zakchinaari ashiru, siysa anumand pchangtamtsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ashiriya, wanasiririsha ipareetsish pzapaneengtsa. tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","11","Anumunsha Apanll Nowerineetsi mishat wipaatstam; Nat in nuw siyapat tputsiripti izuuru amikurtachima. Nuw kuki urutamari taachiya, tárangiya Apanlli. Anootstam zamzeem tárangitamta yuwaa botish maachi ichingarusin shitungarangana anootsi. Zamzi, misha manginshuchitamta, mishat chinuztamta ashirusin waani tsapurnasish taachinllinpa. Nuw siyaa kizpurcha chinaki. Nimun ndushapari tputsee, ayamtaati tputsee, mishat maacheetstatam kungupa tpachingacheezi, ndambaree. Tpachingarangi anoo ndushapa ashtachina. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ashiriya, na siyaam chinakuri, nda mbizamaam tsungee wayachima. In tsiyatsis ayamtaati nda pastachiya. Tputseetstamtis, ichinguroo manginshucheemtam wayachima. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nuw kanindap tsungee tuyamandakchuri napangtsa. Anumand siysa pakchus, iyaa Apanll ndushaparee kungupat tpachingachiya, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Na nimun ndushapari sinapa tputsee tpachingachina. Ashiriya, sin tapitara ashkitaati, nuwsha tsungitkachuri, yuwaa tárangi anoo chinakchuri, sin ndunshaparee siyaa tpachingachiya. Nuw siyangaz kizpur chinakuri ashtachima. Ichingarumarita, manginshuchtam, zamzitam ichingurusin anoo pangchinllinaya. Ashiriya, yuwaa tárangi anoo urutamari taachiya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ashiriya, Nowerinsha wip Sim, Kam, Hapet, ashirusin taaranganaya. Kamsha wip Kanaana taarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nowerini wip tuchip taarangu, anumandarisha arangeem tsapurunasish tputs pzapaneeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Anpur Nowerinsha kizpur mzatspaneem taarangiya. Mzayaru, kizarunaa tatsumirangiya. Itaru, kizarunsha kayanarangu, anoo pusayaru, kanasharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sheeru, anoo kis waarangiya. Warangu, kizpur karusarangu, pangushsha zapeeru tsapush tamuramach ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Wipsha Kam waparish pang' pshtuyaru, nda ksimunaku, nap ashku, wapar zapeeru tamuru anoo parangiya. Shitungeeru, zoonlleetsshat kamanirangiya, ");
INSERT INTO cbuNT_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Zoonllsha wapareem punlloo yáyashinu, pupi átu, waparee zapeeru anoo ksimunaku, ushpiri kanap kanap sheeru, punllupa puyaru, kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Zapish Nowerini warsar ipuriramchu, yuwaa wip Kam waanaatsi parangu anoo yasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Yasayaru, Nowerinsha Kamoo wip, waanaatsi wachinllinoo Kanaanaa mantsir tsiyatarangiya. Shiynaa Kanaanaa, kiyung kachiykush taachsha. Shiyaatsimari zuwanllish itarawaztaksin, Muchchureem ínaksin taachinlliniya. Nowerini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tárangu anumunsha, Apanlleetssha: Apaa, yuwamand Sim shiyaa chinaku anumand wappari, shiyaa atina. Waani Kanaanaa muchchureem wayachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hapetaatssha wachinllin istakchush, tsapurunasee ztaru taachinllinaya. Simosh watsapun washunand taachinllinaya. Itaru, waani Kanaanaatssinaa muchchureem ínachinllinaya, Nowerini Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nowerinsha yuwamun Apanll kungupa tsapurunasee purangu anumun iwaz taarangiya 350 masachirini. ");
INSERT INTO cbuNT_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Washunandsha sirú yuwapa masachirini taarangu anpatarisha 950 masachirini taaramchu anush Nowerini tsiparangiya. Ashiriya, na kamaneena yuwaa Nowerini botish shitungeeru taarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nowerini wip tuchip taarangiya: Sim, Kam, Hapet, ashpa. Yuwamun tsapurunasee kung purangu anumun iwaz Hapetarinshat uwshat arang pzapaneerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wip kamuzanand arangich tsimbun matayaru taarangiya. Iwachiztamarini sura Gomer, anumunshat Mangung, Madayi, Avana, Tubara, Misek, Tirasa, aship taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Sheeru, Gomershat uwshat arang iparinarangitamta. Sur Askenasa, anumunsha Aripata, Tokarinee, ashpamuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Avanshat uwshat arang iparinarangitamta. Sur Elisa, Társis, Kitim, Rodanin. Aship Hapetarinchich wachinllin pzapaneerangana. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ashirucha, musamun wing pseertayarusin taaranganaya. Yapiri zandkana ambirisha nambeersin, watsapuneemarisha pachirtayarusin taaranganaya. Kuksha nllitaritawsha tsiyatartarangana. Ashiriya, na kamaneena yuwaa Hapetarinchich wachinllin pzapaneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kamurinshitini uwshat arang iparinarangitamta. Iwachiztamarini sur Kus, anumunsha Misrayima, Puta, Kanaana, aship iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kussha uwsha wip arang iparinarangitamta Seba, anumunsha Apira, Arooma, Sapteka, aship taarangiya. Aroomshat uwshat arang iparinarangitamta sur Sepa, anumunsha Dedana aship taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusshat uwshat arang minumari iparinarangiya Nimrodaatsimarita. Nimrodsha kizpur kurakamuna. Ashchiri tsapurunas waamari kurak kasiru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Mishat, kizpur washungamuna. ¿Chakaja waapa tatsamooch? Waamari ashiru Apanll kasarangiya. Ashirucha, tputs machin zamzee pachaku anoo pakchusin, Uru shiy ashtarish. Waj shiy Nimrodarini ashirish, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrodarini kizpur kurakamuna, tputsee waamari ksutku taarangiya. Tsap Sinarush ipunpunar yakat taarangu anoo waamari ksutarangiya. Yakatsha sur Babel, Erek, Akat, anumunsha Kalné, ashiru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Zapishsha Nimrodarini zaree puwachingaratu táshtap naatarangiya. Ambirisha yaktaam ipunpunartam wayarangiya. Yaktarini sur taarangiya: Ninipi, Areopitira, Kara, Aresema. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Aresemsha yakat apusantaru kapung taarangiya. Ninipisha piyamaritam taarangiya; Kalsha arangich watandaram taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kamurinsha wip Misrayit waanitaritamsin taaranganaya. Ludewshuchsha tputs anchichtamta. Anamshuchsha tputs anchichtamta. Areopitshuchsha tputs anchichtamta. Naptoyshuchsha tputs anchichtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrosewshuchsha tputs anchichtamta. Kaslohitshuchsha tputs anchichtamta. Kaptowitshuchsha tputs anchichtamta. Itaru, Filistewshuchsha tputs Kaptowitchichi. Ashpisin Misraychichinandari tputs taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaansha wip tsimbun taarangiya. Iwachiztamarini sur Sidon, anumunsha Heta. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Hetchichinandarita ichingaru Jebusewshuch tputs anchichtamta. Amorrewshuchsha tputs anchichtamta. Gergesewshuchsha tputs anchichtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hebewshuchsha tputs anchichtamta. Arasshuchsha tputs anchichtamta. Sinshuchsha tputs anchichtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwatshuchsha tputs anchichtamta. Semarshuchsha tputs anchichtamta. Hamatshuchsha tputs anchichtamta. Anchich tputs ashpisin pzapaneeranganaya. Sheersin, ambirisha yap zandkana amb nambaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ambiritam watsapuneem pachirtaranganaya. Sidonshuchshat tputs zaree puwachingaru tuwash naatarangsin, ambirisha yakat Guerarush, mishat Gasash kusaranganaya. Minchichshat tputs yap zar yaku amb naatarangsin, yakat sur Sodoma, Gomora, Átamu, Sepoyin, arangeemsha Arasa aship taarangu, amb kusataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ashiriya, Kamchichinandaritam pzapaneerangusin, minchich piyam, minchich piyam ashirusin taaranganaya. Sheersin, waanitaritam kuk tsiyataranganaya. Ashiriya, na kamaneena Kamurinchichinandari wachinllin pzapaneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Nowerini wip iwachiztamarini Simomuncha. Waamari zoonllee Hapetarineetsi putsisarini kasirangiya. Simorincha wip arang pzapaneengu, anchichinand zapish Eberchichsha arang pzapaneerangitamta Hebrewshucheema. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Simorin wip zameetpa taarangiya. Iwachiztam sura Eram, anumunsha Asór, Arfaksad, Lud, Aram ashpamuncha ichingaru. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Mishat, Eramurinsha wip taarangtamta. Iwachiztamarini sura Us, anumunsha Ur, Keter, Mas. Ashpamunsincha. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadsha uwshat wip minam wanindarangiya sura Salája. Uwshat, Salájshat wip suru Ebera. Anumari taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebersha wip tsimbun taarangiya. Iwachiztamarineetsini wip sur ísamarangiya Peleka. Anumunatsha Jokatánmuncha. Yuwapursha Pelekarini taarangu anpur zar tputs watsapunee kasatartayarusin, piyamsha pseertaranganaya. Ambirisha watsapuneem pachimbaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Sheeru, Jokatánarinshitini uwshat arang iparinarangitamta. Wip iwachiztam suru Armotat, anumunsha Selef, Jasarmavet, Jera, ");
INSERT INTO cbuNT_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Osar, Tikra, ");
INSERT INTO cbuNT_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opar, Apimayir, Sap, ");
INSERT INTO cbuNT_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Hapir, Jobaba. Ashpamunsincha. Waatatssincha ichingarusin Jokatánarini wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Watsapuneetssha sur ísamaranganaya Misaa. Ambirisha tsap sur taarangitamta Separa yap zar puku machpi kung katuktakatu ambi. Mang ansha anchichinandari tputs itsutaru taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ichingarusin Simorinchichinandaritcha. Anchichinandari pseertaranganaya. Minchich piyam, minchichsha piyamaritam ashirusin naatartaranganaya. Mishat, kuksha waanitawaritam tsiyataranaya. Watsapuneemsha waanitawaritam pachirtaranganaya. Sheersin, waantawari watsapuneewamarisha yambaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Waatatcha ini ichingarusin Nowerinchichi tputsi. Yuwamun tsapurnasee kung purangu anamunach iwaz tputs pzapaneerangana. Sheersin, ambirisha yakat pzapaneerangu, tsapurnas ztasha taaranganaya. Ashparitani iy Nowerinchichtanicha. Ashiriya, na kamaneena yuwaa Nowerinchich pzapaneerangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Yuwapur tputsee kungupa Apanll waneerangu anumun iwaz tputs minamari k'kuz tsiyataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Yap zar yaku amb apinll naatarangsin, tsapoo parangusin, sura Sinara anush kusaranganaya. Tsapoo tandsaa wanasir pachirtaranganaya. Anshurisha taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Zapishsha tputs waanpatatin tsiyatkusin táranganaya. Na ladrichoom tinayani. Tsapupat tinayaruni, mbamakchu, sumasush kchayani, tárangusin, ladrichoom tinaranganaya. Tinayarusin, pingarpat tapatstarangusin, washunand panguranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yusursha táranganaya; Pza, yakat kapung panguyani. Anushsha apusanand torreem íwar kanindap tuxiyani. Amb ashkachuni, iysha uru washunand taachiniya. Ichingaru tsapurunas yuwamun torre kapung tuxiykeerangini anumun iyaa yasachinllinaya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Itaru, Apanllsha yuwaa tputs torre íwar tuxiykeeru anoo parangiya. Ichingarusin tputs tarawaztatarach ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Apanllsha anoo pakeeru, tárangiya; Na, siy natumari washunand taaksa. Minamari k'kuz payuktamsa. Yuwari saana zandkis anuri tarawaztakus chinaksa. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Itaru, na nimun nuw siyaam k'kuz mbam wayakchuri, saanpata ndushapari yuwaa tsiyatkis anoom mazinatssa. Ngutis torre kasayarus, pseertachpasa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ashirucha amb sheeru, Apanll tputsee tarawaztamaam apusari tayutariteeru, anuritam tputssha torre wazuran tánungamaam kasaturtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ashirucha, anoo yakta suru Babelaa ísamaranganaya. Tputssha kukuritam, uwsha kukuritam ashiru tsiyataranganaya. Anumunsha, tputs ichingarusin piyam naaku, piyam naaku ashirangsin, pseertaranganaya. Na kamaneena yuwaa Apanll tputsee nllitarit k'kuz mbam tutsiyachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yuwamun Apanll tputsee kungupa waneerangu anumun tsimbun masach tushiyramchu, Simorini Arfaksadaa iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Anpur Sim masachirini 100 taarangiya. Anumuncha iwaz, wipaam kamuzaamtam, kizaamtam ashiru iparinarangiya. Arfaksadamuna iwaz 500 masach taarangu, anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksadsha masachirini 35 taarangu, anush Salájaa iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Salájamun iwaz Arfaksad taarangiya 403 masachirini. Anush wip zapan taarangiya kamuza misha kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salájarinsha masachirini 30 taarangiya. Wipaamsha iparinarangu, sur Ebera ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eberamuna iwaz Salájarini 403 masachirini taarangiya. Anush wip zapan iparinarangitamta kamuza misha kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebersha masachirini 34 taarangiya. Anumun Pelekaa iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelekamunsha Eberini masachirini 430 taarangiya. Aship masachirini taaramchu anush wipaam zapan izapaneerangitamta kamuza misha kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleksha masachirini 30 taarangiya. Anamun Resaa sura iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Resamunsha, Pelekarini 209 masachirini taarangiya. Aship masachirini taaramchu anush wip zapan pzapaneerangiya kamuza mish kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ressha masachirini 32 taarangiya. Anumun Seroka iparinarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Anumunsha 207 masachirini taarangiya. Anush wipaam zapan iparinarangiya kamuza mish kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seroksha masachirini 30 taarangiya. Sheeru, anamun Nahoraatssha iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sheeru, anumun Serokarini 200 masach taarangiya. Anush wip zapan iparinarangitamta kamuza misha kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahorsha masachirini 29 taarangiya. Nahorsha Teraa iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Anumunsha Nahorini 119 masachirini taarangiya. Anush wip zapan izapaneerangiya kamuza mishat kizatamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terasha masachirini 70 taarangiya. Wipaamsha iparinarangiya. Tuchip wip sur taarangiya, Apram, Nahora, Jarana. Ashiriya, na kamaneena Semorinchich tputsi izapaneerangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terarinsha iparinarangiya Apramaatsi, Nahoraatsi, Jaranaatsi. Jaransha uwsha arang Lotaa iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Anamunsha kiz tsimbun Milka, Iska ashiru iparinarangitamta. Jaranarinsha anshuri tsiparangiya yaptam nllurtarangu ambtam yakat sur Urshu. Wapar Tera wandari kchitamasa anpur Jaranarini uwmasa tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Apramarinshitini wizanlleem Saraya yamarangiya. Itaru, Sarayrinshat nda iparinaku, mipish taarangiya. Nahorarinsha wizanlleem zoonllee wip, Milkaa yamarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terarinsha: Pza, Kanaanap tsap naayani, tárangu, wachinllinoo Jaranarineetsi wip Lota machtarangiya, wipaatstam Apramarineetsi, Apramaatstam wizanll Sarayaatstamta. Itaru, ndaturi Kanaanash tsap kusarusin, upusap yakat sur Jaranush taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terarini yakat Jaranshuri tsiparangiya. Masachirini 205 taarangiya. Ashiriya, na kamaneena yuwaa Terarinchich tputs izapaneerangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Apramarini Apanllpa tsiyataramchu, anush Apanll; Apramaa, nee tsapuneetsish ksangcha. Zuwanlleetstamtish, maachiritawaatstamtish, pangeetstamtish, apareetstamtish pangu, ichingaru ksangcha. Kasayarush, minupsha tsapu naangcha. Nuw shiyaam tsapuneemish yámandachinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mishat, táchinllpa, Shiyachchimari tputsirish pzapanichinllinaya. Mishat, nuw shiyaam kapung istachinllpa. Shiyaa tputs ichingarusin: Apram kizpurcha wanasiri, táchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mishat, yuw tputs shiyaa chinakana anoo nuwsha istachtamna. Itaru, yuw tputs shiyaa natsakana anoo nuwsha nduntam istachina. Itaru, shiyamand kaminish ichingaru tsapurunas ztaru istachima, tárangiya Apanlli Apramarineetsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ashiriya, Apramarini Apanllee kuk mazinarangu, naatarangiya, ");
INSERT INTO cbuNT_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Wizanllpa Sarpat, zoonllinpa wip Lotarinpat, chinupat, muchchurpatatam, ichingaru ashpari naataranganaya. Apramarini anpur masachirini 75 taarangiya, yuwapur watsapunee Jarana kasarangu anpuru. Naatarangu, Kanaanashshat tsap kusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Anshuri Kanaanash tsap xirangu, Sekemashsha yakat kusarangiya. Sekemshuch tputs yasin washitanish puch waanaatsi tinamarinee apanllputstsee wayayarusin, kis ungirtataranaya. Yasin sur Moreyaa ísamaranganaya. Kanaanshuch tputs ambiri ashkusin taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Anush tsap, Sekemash, yusur Apanll Aprampa tsiyatarangiya: Nuw shiyaam tsapuneemish Kanaanaa panachinllpa, siyachcheemtamta, Apanll tárangu, Apramarinshitini Apanllee ungirtapi átu, patumbich xanateeru, anumun maacheetsi muchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yusur Kanaanash tsap xirangu, machipsha naatarangiya. Machip káreeranllu, ambirisha yakat sur Betela taarangiya. Anoo yakta tushiyarandsin, yap zar yaku amb ndatuma yakat Hayash kusarusin, apusari taaranganaya. Anush Apramarini yusursha patumbchee xanateeru, Apanllee ungirtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ashiriya, minushsha zar Apramarini yusur zaree puwachingaru tuwashsha apinlliri chinpatari naataranganaya. Apus maamchusin Neguebash tsap kusarangusin, anshurisha zapan masach taaranganaya. Ashiriya, na kamaneena yuwaa Apramarini shitungeeranllu naatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Apramarini anush tsap taarangu, katungats maringarangu, katungtsingaz Ijiptopsha tsap naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ijiptosh kusamaam kayumatanu anush Apramarini wizanllpa Sarayrinpa tsiyatarangiya. Shiy kizpurtishcha wanasirish. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ashiriya, Ijiptoshuch tputs shiyaa pakchusin, kurakaatsshat kamankatssin, Nish kiz kizpur wanasir kuseenllpa wazaranllpata, tákchusin, kuraksha: Wazaranllee pchangtsa. Sheerus, wizanllee nuwashsha yushindangtsa, táchparee. Tákchu, shiyamand kaminish nuwaa pachachpasinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ashiriya, tputs shiyaa mashkatssin, shiysha: Nuwaa wawartana, ngutish tángcha. Ambinaari tákchush nuwaa pachachazinllinaja, ndambaree, Apramarini wizanllee Saray tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Amb táyarusin, Ijiptosh kusaranganaya. Sundarsha Sarayrineetsi napku, kizpur wanasir parangana ");
INSERT INTO cbuNT_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Urkareetssha parawaa kamaniranganaya: Kiz kizpur wanasir kuseenllpa, tárangiya. Kuraksha: Yamayarus, nuwash pangi yushindangtsa, tárangiya. Sundarsha, Ayu, atusin, Saraya yamayashinusin, kurakaam panaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Parawarinsha Apramarinpat wanasir tsiyatarangiya. Maacheetsi zapan chinoom, opeejatam, wakaratam, burrutam, kameechutam, anumunsha tputsee muchchureem kamuz, kiz ashiru panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yuwamand Apramarineetsini wizanll Saraya itutsirangana anumand Apanll parawaa kapung waneerangiya. Parawarini maachiri zapan kas yutaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Parawarinshitini Apramaa kuruzeeru: ");
INSERT INTO cbuNT_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Mayaamsha nuwaa amb ashirangsha? Nuwaa ngutish ngichirangsha, izanlleetsish nuwaa izartana, shiy tárangshawa. Amb táyarush, nuwsha nda yasaruri, mapiyruri yamapi, tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ashiriya, na izanllish shaantatam yanpungcha. Neewa izanllish. Natu naangints, tárangiya. Táyaru, wasundururee: Tputsee zanganingcha arapi, kamuzawaatstam, kizawaatstamta. Nish nuwash tsapuni taarusinapa, tárangiya. Sundarsha ayu táyarusin, anuritam Apramaa ashparit tiptsirpatari arap zanganiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Apramarinsha, wizanllpa Sarpat Ijiptosh shitungeerandsin, waptam watsapuniptam Neguebap kanapuranganaya. Lotarinsha mang anshutam tachitarangiya. Ichingaru ashpari maachiri payurangu anpatari naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Apramarinsha anpur urkirpanimuna. Maachiri zapan taarangiya; chinuzeetstam, orootstam payurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ashirucha, Neguebash tsap kusarangsin, anumand yusur Betelapshat tsap kunguchich much apinll naataranganaya. Itaru, Betelamandsha naatarangsin, yakat Hayi kayumanasha apusash taaranganaya yuwashtam sirú taarangana anshutamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Yuwashtam Apanlleem urngirtamaam patumbchee xanateersin, maacheetsi muchirangana anshutam kusaranganaya. Ashiriya, na kamaneena yuwaa Apramarin Ijiptosh tsap napeeshinu waptam kanapurangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Apramarini Lotarinpatini washunand taaranganaya. Lotarinshitini chin zapantam taarangiya. Opeeja, wakaratamta, muchchur zapantam taarangitamta. Ashirusin, anshuri tambtayarusin, maachitpat tas taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Anush tsap tputs taamaam tatsitarangiya. Chinuzeem watungash martamaam pishtarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ashiriya, muchchursha waanpatatin natsamaam zandarangtamsinaya. Feresewshuchsha tputs, Kanaanshuchtam tputs anushtam taaranganaya. Ashirucha, kis taamaam tsap pshatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Apramarinsha zoonllee Lotarinee tárangiya; Shiyapa tputsirish nuwapa m'chachuri waratamaam zandaksincha. ¿Tamareeja chaanpata zuwanllpatatich natsachich? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ashiriya, pza, wanlliteeni. Tsapuneemish napangcha; yapimasaja wanasir pakchush amb naangcha. Wandaya shiy yap zar yaku amb naakchush, nuwshat yap zar puku amb naachima. Wandaya shiy yap zar puku amb naakchush, nuwsha yap zar yaku amb naachima, Lotarineetsi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lotarinsha yakat Sówarap tsap kizpur wanasir tándsa chirichir kamachpaptaru anoo parangiya. Kungsha sur Ortaga anshuritam naantar ashirangiya. Sirútama Apanll mzatsee wayarangu an tamapari ashtamaru parangiya; Ijipot tsap tamapari ashiritam kizpur wanasiri. Anpur ndatuma Apanll yaktaa Sodoma, Gomoraa tpachingachu ashiru amb tsap kizpur wanasir taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lotarini Ortagap kung taachima átu, waziparee Apramaa: Ichee, na, naamachima. Kazurakchima. Yap zar yaku amb naachima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Táyaru, naatarangiya. Itaru, Apramsha anshuri machish Kanaanash tsap taarangiya. Lotarini yakat Sodomanung kayumari taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Itaru, Sodomshuchsha tputs yutaritanand taaranganaya. Nda Apanllee mangoonaranganaya. Kizpur mantsirimshee chinaksin taaranganaya. Ashiriya, na kamaneena yuwaa Apramarini zoonllinpa wip wanllitarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lotarini naataramchu, anush Apanllsha Apramaa tsiyatarangiya: Ichingaru tsap napangcha; yap zar yaku ambtam, yap zar puku ambtam, tuwshutam ashiru ichingaru napangcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yuwaa pakchish anoo panachinllpa. Chinllineemtamtish ichingaru tsap panachima. Siysa anush tsap urutamari taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Sheerus, arang pzapaneetssa. Mazach tamapari ashiru taachinllinaya. Napa; mazachee wayapur táchimaam pinasakich ashchinllinaya tputsireetssha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ashiriya, naayarush napangi tsapu wazuranarini, wamanarinitamta, yuw nuw shiyaam tsapuneemish panachinllinpa tárangi anootsi, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Apramarinsha ayu átu, machish karuweeru, yuwash mangin wanasirimash taaru amb naatarangiya. Ashiriya, Apramarini yakat sur Hebrona watsiritanasha taarangiya. Mamre tsap watsiritanasha Apramarini taarangiya. Anush Apramarini patumbchee xanatarangiya Apanlleem ungirtapi átu. Ashiriya, na kamaneena yuwaa Apanll Apramarineetsi: Nee tsapuneemish panachinllpa tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Yuwapur Apramarini Mamresh tsap taarangu anpur, kurak zapan waanpatatin warataranganaya. Kuraksha ipunpunar uwsin washunand waratarangana kurakpat zameepata. Ipunpunar sur Kertora, yakat Elamshuch tputsi, Amrafel, yakat Sinarshuch tputsi, Ariyok, yakat Elasarshuch tputsi, Tidal, yakat Goyimshuch tputsi, ashpin washunand yambiyeersin, waratamaam shitungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Piyartach kurak zameetpa sur Bera, yakat Sodomshuch tputsi, Birsa, yakat Gomorshuch tputsi, Sinab, yakat Admashuch tputsi, Semeber, yakat Seboyinshuch tputsi, kurak minu chakamasaja sur yakat Belashuch tputsi, Bela watamcha Suwartam yakta suru, ashpin washunand yambiyarusin, ");
INSERT INTO cbuNT_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","yuwaa kurakpat ipunpunar taaru anoo tapazeem naataranganaya. Naatarangsin, wazawap Sidin sura amb naateersin shaniyarangana. Sidina tsurtakanaya Musa Tsipatsimashi atanaya. Anush waratamaam shaniyaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sirútari Kertorarin neetstam kurak zameetpat waratarangu, kasirangu, Uru kurikee ichingaru masach ashpatam tuwapanda, átu, kasarangiya. Natpur washunand 12 masachi zanganngantar ashkusin tushiyramchu, anush niziranganaya. Tsiyantarangusin, masachish 13 kurikee ndusha zanganiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Anumandsha, kurak Kertorshat kapung tsiyantarangu, wamkuree yambirangiya. Waanpata ipunpunar kurakaa waratamapan kuruzurangu, kurak ichingarusin wasundururee yushindaranganaya. Ashiriya, anpuritam zar waratamaam shitungeerandsin, naataranganaya. Rafayitshuchish yaktarini, kung Astarota-Karnash kuseersin, anshuchee tputsi kachingaranganaya. Sheersin, Jamap kung naateersin, Susitshuchee tputs kasirangitamsina. Sheersin, Save-Kiriyatap kung naateersin, Emitshuchee tputsee pachingaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Anumunsha, machip Seirap sur káreersin, arangeem apusap tsap puz Paránap naateersin, Horewshuchee tputsee kasirangitamsina. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Anumandsha kanapeerandsin, Enmisap kung, mintam sur Kades taaritam, anush kuseersin, Amalekshuchee tputsee kasirangitamsina. Arangeem Jases-Tamarap kung kuseersin, Amorrewshuchee tputsee kasirangitamsina. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Anumunsha, Sodomshuchshat kurak uwshat wamkuree zameetpa kurakaa kuruzurangiya. Ashpari kurak wasundururee yushindarangitamsina Sidinash wazawa. Natu taringsints. Warateeni, tárangusin, warataranganaya. Yusursha waatsimaritam Kertorchich tputs kasiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ashirucha, Sodomshuchsha tputs machip suwasuwaranganaya. Ashpatam tputs pingarashsha pshturanganaya suwaksina. Watam pingar kapung mus tamapari ashiru ksheewarangiya. Ashirucha, anush pshturangusin, tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Amb ashirangsin, anush Sodomshucheewatsshat katungtseetstam, chinuzeetstam ashpari yamaranganaya. Anumunsha, tputseewa putata, kizaatstam, nllurawaatstam ashpari putaranganaya. Putayarandsin, waptam naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Anush Lotarineetsi, Apramarinee zoonll putaranganaya, watam Lotarini Sodomash taaranguwa. Ashirucha, ichingaru muchchurpatari, chinpatari, waama muchchur yamarangitamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Itaru, minam tputs suwarangiya. Apramarinpini watsapuni anush iriputanu kusarangiya. Apramaatscha kamankamchu: Apramaa, mazinanlla. Zuwanlleetsish tputs Keramarshuch sundar putayarusin, macheenllinpa, Apramaa kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ashiriya, Apramarini anoo mazinarangu, uwshat wamkuree kuruzurangiya suru Mamre anootsi. Mamresha zoonll tsimbun taarangiya suru Eskara, mishat Anera. Ashipa an Apramarini yambirangiya. Nuwaam istanda, tárangiya wamkureetsi. Uwshtisin anuritam: Ayu. Ashiriya, istachinllpa, táyarusin, naataranganaya. Apramarini waana tiptsir taarangiya ichingaru 318 tputsi. Anoo ichingaru tiptsiree sundaroom ínarangiya. Anpasha sundar tputseem tachitarusin, Danap iriputat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tachiturusin, iripurusin, ambiri nachungakatarandsin, zapish apus kamataranganaya psaana schirusshita. Yuwash ashparitin mapiyrsin maarana anush uwshtisin katiripeersin, pacharanganaya. Yuwash mapiyrna anush waamaritin kasiranganaya. Zapan pacharanganaya. Mishat, zapantam suwasuwaranganaya. Yapsha Joba suwayaranllina ambsha tachitarusin, pachata, pachata shitarandsin, yakat Damáskupsha túshindayarusin, anumandari kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yuwash ashirangu anush Lotarineetsi yanpurangiya. Ashparitaa tputs yuwaa putarangana anoo yanpurangiya. Ichingaru maachirita, katungtsiptarta, mishat kamispatarta, mishat chinuzpatarta ichingaru yuwaa yarangana anoo yanpurangiya. Ashiriya, na kamaneena yuwaa Apramarineetsi zoonll putayarusin, uwsha Apramarinshitini yanpurangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ashiriya, Apramarini undararpa Kertorpa waratam iwatsparamchusin, yuwaa kasatartayarusin watsapunip kurak wapitam kanaputeeranllina anoo Sodomshuchsha yakat k'kuzee mazinaranganaya. Mazinayarusin, Pzaya, chamayangaani, táyarusin, naataranganaya. Amb naatarangsin, apus machish wazawash kung sur Savi anush chamayangaranganaya Apramarineetsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sarenshuchshat yakat apanllpan urkar suru Melkisa an tputsee mang' yaramapanimuna anshat naatarangtamta. Apramaa chamayangakatu, Apanllpa Melkis Apramaam mashpi átu, katungats yáyaru, mishat vinoo kasha anoo yarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Anush Apanllpa kapung tsiyatarangiya. Apanllimari kizpurcha. Waamari ichingaroom kasiriya. Watam waamari kanindaa, misha tsapootstam tinaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ashirucha, Apanllee íwarpichee ungirtakaniya yuwamand siy kundarareetsis waanpata wizpurirni siyamarisha kasirangis anumanda, apanllpan urkar tárangiya. Anoomsha, Apramarinshitini yuwaa maachi zapan washunand chung payurangu anoo minchich minumtam minchichsha minumtam sheeru ashpari panarangiya apanllpaneem urkari. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ashiriya, yuwaa Sodomshuchee maachiri itutsirangana Kertora anootsshat Apramarinshitini ashpari yanpurangiya. Yanpuyashinu, anush Sodomshuchshat kurak tsiyatku: Apramaa, Shiy yanurangtishcha. Iyaa ichingaroo maachiritini yanpurangsha. Ashiriya, nuwaam tputsirimti tuwanpungandama. Itaru, maacheetsitsha yuwaa sundar iyashchee kamis itutsirangana, anoo na shiysha yanpurangish anootsinaa shaamatari yángcha, Apramarineetsi Sodomshuch kurak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Itaru, Apramarinsha: Nuwamari Apari íwarpich kizpurcha. Waamari ichingaroo tinarangu kanindaatstam misha tsapootstamta. Ashiriya, nuw Aparpati tsiyatkuri: Apaa, nuw Sodomshuchee maachiri yanpurangi anoo waamatamsin tuwanpuchima, tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Mishat, nuw anchichee maacheetsi pakchiyam yacheezi. Irootsiyam, mishat wanumaatsiyam, mishat shineeraatsiyam yacheezi, ndambari. Yuwaa tárangi anoo ¿tamareeja k'keetsi kapeetchi? Ashiriya, nuw siyaa maachiritis yakchinaareena, tputs nuwaa táchpasinaya: Apram na kurikpanshacha. Zapan maacheetsi payukiya Sodomshuchee maachiri yarangu anootsi, tputs nuwaa tárundama atina. Ashiriya, nuw yamaam zandkeezi. Saana maachiritaatsis yángsints. ");
INSERT INTO cbuNT_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Itaru, yuwaam sundaruri katungarangana anumari waani pastachpa. Mishat, ipunsheemi Aneraam, mishat Eskaraam, mishat Mamreem anoom chawpitam panangcha maachtaatsi kamisawaatsi, Apramarini tárangiya. Táyaru, Sodomshuchsha kurak anuritam Apramarineetsi kuk tuminurangiya. Ashiriya, Apramarini Sodomshuchpa urkar tsiyatsis iwatsparamchusin, anumun waptam kanapurangiya watsapuniptamta. Ashiriya, na kamaneena yuwaa Melkisarini Apanllpa Apramaam masharangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Apramarini kanapuramchu anush pamazurangiya. Apanll Apramaa: Apramaa, punirinllpa. Nuw urutamari shiyaa tapachindakuri taakina. Ashiriya, nuw shiyaam kapung istachinllpa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Itaru, Apramarinshitini: Nuw, Apaa, shiyaa kurakartana. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","¿Mayaamaja shiy nuwaam maachta zapannaa panachish? Nuw tsipakchuri, m'chachurshaparina sur Elíyaser Damáskushuch yachiya. Antaati shiy nuwaam ipareemi panarangshawa. Tsipakchuri maachiritaatsi iparshiti yapu, Apramarini Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Apanllsha: Nduni. ¿Tamareeja shiyaa maachiritish m'chachurish yach? Uru iparish shiyaa maachiritish uwshat ksutku taachiya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Táyaru, Wishchipsha shitungeeni, tárangu, wishchipsha shitungeersin, Apramaa, Yuwar nachayarush kanindap napangi. ¿Wanipaja tsangach taar? Na táchingi. Shiyachich tputsirish ashippari taachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Apramarini Apanllee kuk anuritam payurangiya. Shiy nuwaa kuki mangoonarangush, ashirucha nuw shiyaa kis napkina. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mishat, shiyaa táchinllpa. Waatatana nuwaya shiy Apanllirisha. Yuwapur sirútama yaktash Urush, Kaldewshuchish tsap taarangish anpur shiyaa tárangina. Tsapuneetsish kasayarush, arap naangcha. Nuwsha shiyaam tsap panachinllpa tárangi, an watacha ini tsapu, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Itaru, Apramarinshitini Apanllee: Apaa, ¿Nuw tamareeja anoo wasina yasachee anush tsap taachparina taachee? Apramarini Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Apanllsha Apramarineetsi: Nuw shiyapa amikurtamaam zandaktana. Ashiriya, chinish yushindanlla, opeeja, chipoo, wakaraa, aship tuchip payutanlla. Itaru, yuwanandari karupana tuchip masachirini taaru annandarita. Mishat, mukuk wip karupan kizpur wanasiri an payutanitamcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Apramarinisha chiyzayaru, chinoo tuchip putarangiya. Putayaru, machtarangiya. Anootssha pachayaru, apusash taaruyaru, minnungichich watandaram wayarangiya piyama. Mishat, annungitam watandaram wayarangitamta. Anumunshat mukukootsshat wip putayaru pacharangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sheeru, anungaz yapsha katungkani atusin, kusataranganaya. Itaru, Apramsha anoo kapung ksutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Zar tapitaranllu anush Apramaa maats kasirangu, kizpur maarangiya. Anush kizpur taap ashirangiya. Nda pamaam waritarangiya. Apramarini kizpur punirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Anush Apanllsha, Siyachich tputs minush tsapurunas arapchish taakchusin, anush uru kiyung kachiykusin, washunand ichingaru 400 masach taachinlliniya. Anshuch tputs kiyung yachakchinllinaya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","16","Itaru, nuwsha yuwaa tputs ashkachinllina anoo wanichima. Itaru, shiyachchee nllurnuri tapachindachima. Tsapoo kasakchusin, ichingaru maachtaatsimari yachinllinaya; wakara, opeeja, kurikitam zapan yachinllinaya. Kanapeersin, anshutam tsap Kanaanash kuseersin, Amorrewshuchee tputs kachingachpasinaya. Natumas kizpur yutaritanand taakitaatssin, itaru wand yutaritshish pishtariya uwaama. Itaru, shiynaa tsipachpasha nishuri tsapuya. Yuwash shiy zitaminarish taakana anush nuwaampee wayachinllpa. Shiy kizpur wachinayarush, tsipachsha. Tsipakchus, shiyaa nishuri mapchinllinaya, Apanll Apramarinee tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Zar tapitaranllu anush msas kizpur mzeetaru anush tuzaz ashiru kurakurtaru, yuwash wakar wanuts wayaru anush apusanand sunlliychitaraa ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Anuritam zar psaan Apanll Apramarinpatini amikurtaranganaya. Anshuri Apanll Apramarinee; Nuw shiyachcheem nlluranur watsapuneem kapung panachima; kung Ijiptomand yáyaruri, arangeem kung kapung Eufratis anumun tutsipeeri, yáyaruri panachima, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Ambchee tputs watsapun ashpari yaktarini tatutschima: sur Kinitasshuchee, Kinisitshuchee, Kamuniyshuchee, Hititshuchee, Feresewshuchee, Repaytiyshuchee, Amorrewshuchee, Kanaanshuchee, Gergesewshuchee, Jebusewshuchee, ashpari tsap tatutseeruri, shiyaam panachinllpa, Apanll Apramarineetsini tárangiya. Ashiriya, na kamaneena yuwaa Apanll Apramarinpatini amikurtarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Apramarini Kanaanash tsap wizanllpata Sarpat chung masach taarangiya. Itaru, Sarayrinsha anpur wip ndunarimuna; mipish taarangiya. Sarsha anpur minum muchchur kiz sur Akara, Ijiptoshchi tputsi taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ashirucha, Sarayrinshitini wazaranllpa tsiyatkusin táranganaya. Apramaa, nda iparinakaniwaa. Nda ipareemani Apanll panakuwa. Ashirucha, nuwsha shiyaa táshina. ¿Mayaamsha shiy nda nuwash m'chachurishi pshtuyarush maaksha? Ashkachinaareesha, uru iparinakchush, nuwpaz ipari ashisha tatsipchiya, tárangiya Sarayrini. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tárangu, anoo Apramarinshitini, Ayu, ashiri maachima, tárangiya. Sarayrinshitini muchchuree Akara kiz wazaranlleem tupanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Apramarinshitini Akarpa maarangusin, Akarsha mireerangshita. Mireeyaru, Sarayrineetssha starangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ashirucha, Sarayrinshat wazaranllpa Apramarinpa kapung tsiyantarangiya. Ipari ndunareetseeru, nuwaa stakanda. Amb ashku, nuwaatssha kapung tatsiyuntakanda, táyaru, Shiyatamcha nuwaa m'chachuri yamarangush, na iparinarangasha. Itaru, yuwamand amb ashirangish anumand Apanll waana shiyaa yasachiya; shiyaa wanichapanlla. Nuwaatsina wanicheeja ndambari, wazaranllee Apramarineetsi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Apramarinshitini Sarayaa: Ashiriya, shiy m'chachurtishcha Akaraatsi. ¿Tamanda? yuw mangishish shaana chinakish an shingcha, tárangiya. Ashirucha, Sarayrini anooritam Akararineetsi kiyung yacharangiya. Akararini suwarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Akarini piyamsha apusapsha zaree charapungaru tuwash naatarangiya. Anush tsapush kung wir pakich zaw shitaru parangiya. Anush Apanll wasundur yakarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Sheeru: Akaraa, ¿mayaam nish kusarangsha? Shiyaa Sar muchchurimunawa. ¿Ningeem tamakatshasha? ¿Yapsha naayaransha? tárangu, Akarsha: Sarcha nuwaa nabataru, ningeemsha suwayaranlli, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Apanllsha: Watsta, arap naarinllpa. Mapiyrush waptam kanapeerush, yusur Sarshutam taamatsha. Itaru, Saraya kuk payungcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mishat, Akaraa, shiyachich chinllinish zapan pzapanichinllinaya. Tputs shiyachchee nlluranur táchimaam pinasachtamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mishat, na mireerish anoo kamuz tatsiputsha. Tatsipuramchush suroo Ismaelaa ísamangcha. Mishat, nuw shiyaa parangina yuwaa mangish mantsarangish anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Iparish Ismaela kanungachu, uru kizpur kurakaam kinachiya. Mishat, waamari wizpur kapaach tamapari ashiru waanpatatin waratkatssin waamaritam kasichiya. Amb ashku, zoonllpa urutamari ayamta natsatangat ashkusin taachinllinaya, táyaru, anumun Apanll wasundurur tsípatara ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","14","Ashiramchu, anush Akarsha yuwaa Apanllpa tsiyatarangana anoo, waanaatsisha tárangiya. Apanll nuwaa parangparee, yuwaa kiyung kachiyarangi anootsi. Nuwaa parangitaa, wand kchitana. Mishat, na ashiritam neetssha kungoo wiree tssurtachima, Apanll waana nee kungoo kis napkiya. Nuwaatssha pakeenda, tárangiya. Ansha kung apuspimuna, yap tsap sur Kades, mishat Beredis ashiru taarangu ambi. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Anumunsha, Akararini wipaa tatsipurangiya Apramaa wipa. Wipaatssha Ismaelaa átu ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Anpur Apramarinsha 86 masachirini taarangiya. Ashiriya, na kamaneena yuwaa Akararini Apramaa wip tatsipurangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Apramarini masachirini 99 taaramchu, anush yusur Apanll waanaatsi tuyamandayaru, Apramarineetsi tsiyatarangiya. Apramaa, Nuw waatatana Apanlli. Nuwamaricha kizpuri taaki. Ashirucha, shiysha wanasiriri taarashish taangcha; urutamari nuwaa kuki payungcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Amb ashkachush, shiyapa kapungunashapari chinachiniya. Shiyaam uru nuw kapung istachinlla. Shiyachich aranginasha chinllinish pzapanichinllinaya, tárangiya. Nuwaana shiyaa amikureemi kapung ínchinllpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","4","Ashirucha, Apramarinshitini anoo mazinarangu, tutunlltayaru, much tsapush timuchachawu, mazinazinaw ashirangiya. Uru nuw shiyapa kapung chinakchuri, shiyamari chinllinish tsapurnasish ztaru tatsitchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Amb ashkachush, shiyaa surish ndushapari nimun tsurtaksin Apramaa táchinllinaya. Nimun shiyaa sureetsish, tsurtaksin Aprahamaa, tátshapsinaya, watam shiyamari chinllinish tsapurunas ztaru taachinllinawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Shiyamari chinllinish ayam kurakaamaw kinaksin, yaktash ksutchinlliniya. Mishat, ichingaroom tsapurunas tputs shiyaatsimari wapareempaz ashirusin ínachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Itaru, amb ashkachuri, shiyachcheetsimari chinllineetsish, ayamta nllurnureetstamtish kapung chinachima. Urutamari nuw shiyachchee chinllinish ksutkuri taachina. Amb ashkachuri, nuwaatsimari Apanllireemani ínachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ashiriya, natum tputsish watsapun masarush taaratarshin ashiksha, itaru nuwsha nee Kanaana tsap shiyaam, chinllineemtamtish ashchiri panachinllpa. Chinllinish nee tsap urutamari amuytachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Mishat, shiyaa atashina; Shiysha nlluranureetsish kamaningcha. Nuwaa kuki urutamari payuchinllinapa, watam nuw shiyaa amikurtaranginawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Itaru, Apramaa, shiyshat chinllinitamtish, tputsiritamtish, yuw shaanshu taakana an ichingarusin nuwaa kuki tuminchinllinpa, yuwaa nuw kamachtakachi anootsi. Ashiri ichingaru tputs kamuzanur wayumshiree tas ktsupchinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Wayumshir tas tspakamchu, kukurini anoo kturchinllinpa. Amb ashiramchusin, tputs ichingarusin yuwaa nuw shiyapa kapung chinakurini taakani anoo uwshtisin yasachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Na nimun iwaz ichingarus tputsiritamtish wipaa wayumshir tas kturchinllinpa. Uru nllur nllurtaramchu, anamunsha tuchip matayaru zar maramchu anush kturungtsa. Tunareewaatstaa nllurtakachu, m'chachureetstamtish, yuwaatstam kurikpa tputsee wip paxanxarangish anootstam, kturungtsa, atashina. Ashkachus, nutseetis yusur tapatsteeyaa atitaateesa, ndunshaparee. Anumun urutamari tputs yasayastanllinaya yuwaa nuw siyapa amikurtarangi anootsi, yuwaatstam nuw siyachchee uru ksutki anootstamtaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Itaru, yuw nllur nda wayumshiree tas ksuparangu an nda siyapa washunand taachinllinaya. Watam nuwaa kuki nda payuranganawa, tárangiya Apanll Apramarineetsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ashiriya, anumunsha Apanll Apramaa: Na nimun iwaz ndushapari izanlleetsish tsurtakush, Saray táchsha. Na nimun izanlleetsish suru Saraa ísamangcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nuw izanlleemish Saraam kizpur istamaam zandkina. Nimun izanllish iparinachiya. Anumunarisha tputs pzapanichinlliniya. Zapan yakat taachiya. Anchich nllurnur kizpur kurakaw taachinllinaya, tárangiya Apanlli Apramarineetsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Apramarinsha timucheeru, mangshuri chinayaru, starangiya. ¿Tamareeja tputsich wachinich 100 masachirich taaru iparinachich? Mishat, ¿tamareeja izanlli Sar masachirini 90 taaru iparinach? tárangiya Apramarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Itaru, Apanlleetssha: Apaa, ¿Ismaelazuwa, ashtachiwa? Ashiri Ismaelaam istangi, tárangiya Apramarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Itaru, Apanllsha: Uru izanlliritish Sara wip tatsipchiya. Tatsipkachu, Isaakaa suru ísamangcha. Uru nuw Isaakaam kapung istachima. Iparpatish Isaakpa kapung amikurtachima. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Itaru, ipareemish Ismaelaam istachtamparina. Ismaelchich pzapanichtampasinaya. Iparish Ismael 12 wip wanindachiya. Kizpur kurakanand taachinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Itaru, kaapa Isaakaam kizpur istachima. Isaakpa kapung amikurtachina, Na nimun izanllish Sar minush masach Isaakaa tatsipchiya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Táyaru, Apanll Apramarineetsi mikeeru kasarangiya. Kasayaru, Apanll naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Apramarinsha anuritam Apanllee kuk tuminurangiya. Wipaa wayumshir tas kturarangiya. Ichingaru yuwaa kamuz nllurtaku anuwaa wayumshiree tas kturtarangiya, muchchureewa wipa. Yuwaa kurikpa muchchureem paxanxarangu anoowaatstam wayumshir tas ktururangiya. Apramarini waanaatstatam wayumshir tas ktururangitamta. Yuwari Apanll tárangu anuri kukoo tuminuranganaya. Anpuritam zar Apramarini wip Ismaelarini wayumshiree tas ktururangitamta. Anpur Apramarini masachirini 99 taarangiya. Anpuritam zar wipsha Ismael masachirini 13 taarangiya. Ashiriya, na kamaneena yuwaa Apanll Apramarinee: Tputsee wayumshir tas kturungtsa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Anpur zar Apanll Aprahamarinshini yakarangiya yuwash taarangu anshu. Mamresh tsap manginnung taarangiya. Anush zar wachamuree Aprahamarini pangush washitungashinung kuxinxinaw ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Watsiri wanungee tputs tuchip yakarangiya. Anuritam mikeeru chiyzayaru, tputsip teet ashirangiya. Chamayangayaru, tutunlltayaru, much tsapush timuchta ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Sheeru tputseetssha, Nuw shiyaa kurakartana. Shiyaam istamaam zandkina. Musá naarintspa. Neetsiri kutangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kungooma tipayrunts, pakich panachintspa k'tseetsis kupamaama. Sheerus, yasinash puchi pakich kanusangints wayanpishu. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nuwma katungats yátama siyaam maritamaama. Anumun kizpurtayarus, katungkeerus, ngootsip naatssa, tárangu, anoo uwshtisin: Kizpurcha wanasiri yuw átish anoo, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Aprahamarinshitini waptam pangup Sarangaz teet ashirangiya. Kuseeru, Saraa, mikeerush tirik 20 kilo yángi yuw kizpur wanasiri anoo. Sheerush, pangaam zapan tinangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Táyaru, wakarapsha taárash teet ashirangiya. Yuwaa wakar karupan wanasiri anoo putayaru, muchchureemsha patatamaam panarangiya. Muchchursha anuritam pachayaru, katungamaam patatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ashiramchu, anumun Aprahamarini wakaraa mimir minamaw yáyaru, anumunshat wakara mimiri mburshi anoo yarangitamta. Aship wakarpatari wanuts yáyaru, yasinash puch tputseem martayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tputssha katungam iwatsparamchusin, Aprahamarineetsi masharanganaya. ¿Izanllish yapinaaree, Sara? táranganaya. Aprahamarinshitini: Anshuri pangishi tindash wantsush taariya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Apanllsha wasundurur: Minushsha masach ningtam kuschinipa. Anush zari uru izanllish Sara wip wanindachsha anush kuschiniya, tárangiya. Aprahamarini pangush wach shitungash xiyeeru, tsiyatstangat ashiranganaya. Apanllpa tiptsir ántarusin anoo Sarsha Aprahamarinungini ush tapishuru mazinazinaw ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Anpur Aprahamarini wizanllpa Sarpa kizpur wachinaw taaranganaya. Sarsha anpur ndusha wanguytarangiya; izuuru tsíparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","¿Tamareeja nuw wachini iparinachee? ¿Antaati kurassee mantsakinawa nlluraa miripi? amb átu mangush chinayaru, starangiya. Mishat, ¿tamareeja zaranlli wachin iparinachee? mangush chinaku Sar tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Apanllsha, tputs tamaparee ashiru, Aprahamaa: ¿Mayaamsha Sar kapung staka? Itaru, yuwaa áti anoo nda Sar mangush chinakiya. Nda nuwaa kuki yasakiya yuwaa wachinataa taarangu iparinachu anootsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Itaru, Apanllsha, Nuwaam ¿antaati maachi xapshish taatareeja? Yusur arangtachish masach kuschima. Nishtam zari anush Sar urutarisha wip wanindachu anush kuschima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarsha anoo mazinarangu, kizpur punirangiya; ngichimaam zandarangiya. ¿Antaati starangeezi? tárangiya. Itaru, Apanllsha: Nuw yasaktana, yuwaa shiy starangish anootsi, tárangiya. Ashiriya, na kamaneena yuwaa Apanll Saraa: Iparish uru wanindachiya tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Apanllsha tiptsir chiyzayarandsin, Sodomapsha yakat pangaani atusin, naakchusin, anush Aprahamarinshitini; Ipunamchuri apus kapati, átu, tachitarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Apanllsha mangush chinarangu, Xamachi. Aprahamaatsima kamanchimasima, yuwaa Sodomshuchee tpachingachi anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Watam Apraham wachinllin zapan kizpureewa taachuwa. Ashiriya, anoom nuw kapung istachshaparina yuwaam ichingarusin tputs tsapurnasish taakana anoomaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Watam nuwaana ipusaranginawa, nuwaanaatsi kuki kamanimaama, wipaamtamsin, wachinllinoomtamsina. Yuwaa nuw kuki kamanirangi anoo payuksin, wanasiririsha taamaama amb ashkusin, tputspatari mapiyrsin taachinllinaya. Ashkatssin, nuwsha yuwaa siyaam istachintspa tárangi anoo tumineeruri kasachintspa, mangush chinayaru tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Apanllsha Aprahamaa tárangiya; Tputs atanaya: Sodomshuch, Gomorshuchtam tputs kizpur yutaritanand taakanaya átssincha. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ashiriya, nuwaanasha naayaruri, kaapaniri kchiparishti pangatama. Kamapari zurampatartaya mantsir taaksin, yutaritshishirineetsi izuuru yasachima, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Táyaru, Apanll wasundurur tsimbunartisin Sodomap naataranganaya, Aprahamarinsha anshuri Apanllpa shaneey ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","24","Aprahamarinisha Apanllee káyamayaru masharangiya; ¿Yuwaptari wanasir tputs taakana anpatari washunand yutaritshishpanpa kapeeteerush kasachish? ¿Nda yuwamand anush yakat tputs 50 wanasirmash taakana anumand nda yaramaam waritak? ¿Yuwaptartaja tputs 50 wanasirimash taarana anpatartaja ashpari kapeeteerush kasachish? ");
INSERT INTO cbuNT_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¿Mayaamsha tputs wanasirimashpatari tpachingaksha? ¿Mayaamsha shiy anumashee chinaksha? Shiy watam Apanllshawa. Shiyamari tputsee itsinsaru yasayarush, tsapurunashuchee waneekshawa, tárangiya Aprahamarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Apanllsha: Waanari tputs Sodomash 50 wanasirimash pakchuri, napachparina. Nda tputsee tpachingachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tárangu, anumun yusur Aprahamarini Apanllee: Na yusursha Apaa, shiyaa tsiyatamaam zandkina. Itaru, nuwsha nduntaa waritaruri, tputstaati ashiritaa shiyaa mashkina. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Itaru, apaz anush Sodomash yakat tputs 45 taaru, ¿wanasirimshi anoo tamaycheezish? ¿Yaktaa kapeetcheezish? tárangiya. Apanllsha: Sodomash 45 taaru anoo yakat kapeetcheezi; uru napachparina, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Anumun yusursha Apanllee masharangiya. ¿Apaz itaru tputs wanasirimash 40 anush yakat taaru? tárangiya. Yusur anoo Apanll: Waanari tputs wanasirimash 40 taaru anoo yakat kapeetcheezi, ndambari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Yusur Aprahamarini arang masharangiya: Nuw shiyaa Apartana. Tsiyantarinllpa, yuwaa shiyapa tsiyatki anootsi. ¿Apaz tputs wanasirimash 30 taaru anoo yakat kapeetchitamtazish? tárangiya. Apanllsha: Waanari tputs 30 wanasirimash taaru anoo yakat kapeetcheezi, ndambari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Yusurshat Aprahamarini tayuseeru, arang tsiyatarangiya; Na nuw yusursha Apaa, shiyaa mashkina k'keetsish kapeeteeruri; ¿Apaz tputs 20 taaru? ¿Anoo tamaycheezish? tárangiya. Apanllsha: Waanari 20 tputs wanasirimash taaru nda anoo yaktaa kapeetchina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Yusurshat Aprahamarini masharangiya. Apaa; Nuwaa tsiyantariyshpa. Na nimun arang ndushapari mashchina. ¿Apaz 10 taaru anoo tamacheezish? ¿Shiy amaksha? tárangiya. Apanllsha: 10 taaru nduntam yaktaa kapeetchina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Anumun tsiyatsis Aprahamarinpatini yuwatsparamchusin, Apanll naatarangiya. Aprahamarinshitini waptam pangpitam naatarangiya. Ashiriya, na kamaneena yuwaa Aprahamarini Apanllpa yakat Sodomaam tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","3","Ashiriya, zar tapitaranllu, Apanll muchchur tsimbun Sodomash yakat kusaranganaya Lotarinshini pangu. Lotarinsha kuxinxinawu anush watsiritari yakat ashirangiya, yuwash tputs shaniykana anshu. Ashiriya, Lotarinsha Apanllee muchchur parangu, ¿Tamarimta, ichee? tápi átu chiyzaranll ashirangiya. Apanllip muchchur nda napku, yuwashuri timucharu anshuri, Ichee, nuwash pangi kusangtsa. Nuwash kuseerus, chumayarus, anshuri maatssa pangishina, Lotarini tárangiya. Itaru, Apanllsha muchchur: Wappari, yuwamand iyaa istamaam zandarangish anumanda, táranganaya. Itaru ashiritaa, naturi naachinipa apus ngootsish yuwaa timburanlliz apusanand kapung kureeru anoo maachinipa, Apanll muchchuri Lotarinee táranganaya. Lotarinsha nda sambaytarangiya. Nishuri maangints, átana nuwaya siyaatsiya, tárangu; ashiriya, Apanllsha muchchur, Ayu; ashiri nishuripari maachiniya shiyash pangishsha, táranganaya. Lotarinsha pangaa nda tputaru anoo yáyaru, wanasir maritarangiya. Apanllsha muchchur anoo kis katungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","5","Ashiriya, yuwash Apanll muchchur maakamchinllina anushsha yaktashchiri tputs zapan kusataranganaya. Kanungaseewtam, misha wachinawtam ashirusin kusaranganaya. Lotarineetsi pang' turipingaranganaya. Sheersin, kapung zamangarangana. Lotarineetsshitini: ¿Natuwa? ¿Shiyash pangish tputs psaan kusarangana, anuwa? Natu an tputs tashitungangi. Tayutariteeruni, kasapani atiniya, táranganaya tputsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ashiriya, Lotarinsha tputsee tsiyatamaam shitungarangiya. Shitungachu, pangusee wach mbam tstsarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","10","Wishchipsha shitungeeru, Ashiriya, na zuwaa, mazinantsa; Nuw siyaa tina. Kizpur yutarit nee tputsee mantsir tsiyatintspa. Itaru, nuw ipari taarcha. Tsimbuna kamasina, nda kamuzpa minamtiyam yutarit taakanaya. An siyaam nuw ipari tashitungachima. Ashiriya, siysa anoo yuw zandkis an ashimaam waritariya. Itaru, yuwaa nuw yambiyari anoo tayutaritamaama watsta, watam nuw anoo tputs ksutkinawa, Lotarini tárangiya. Itaru, uwshtisin: Nduni. Ksangi anoo tputsi. Pshtupani átanicha. ¿Mayaamsha shiy anoo tputsee pachindaksha? ¿Antaati shiy nishucheezish? ndambaree. Ashiriya, papcha shaanaatsishta. Aranginasha kiyung yachachiniya, táranganaya Lotarineetsi. Tputs tárangusin, Lotarineetsi putayarusin, tunununtara ashiranganaya, yuwaa tandapunuzee wach kámanaru anootsi. Itaru, uwshtisin Apanll muchchur pangusish wantsush shanee ashiranganaya. Itaru, anshitisin Lotarineetsi putayarusin, pangush tapshturanganaya. Sheersin, wachoo mbam shtandaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ashiriya, uwshtisin yuw tputs wishchipiri natsampani shaneerana anshitisin wishchipiri wach mchustaranganaya. Ndusha pangusish pshtumaam waritaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Ashiriya, Apanllsha muchchur Lotarineetsi: Min iparish yaktash taarinaari ashiru, kamuz, kizatam, misha ngusirish, misha maachiritish ichingaru anoo kuruzungi pangishish, tárangiya Apanll muchchuri. Nee yakta iy kachingamaam zandaktanicha, watam kizpur yutarit taakanawa. Sodomshuch ichingarusin tputsee natsakanaya, tárangiya. Iyaa Apanll zanganirangiya nishuchee yakat wanimaama, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ashiriya, Lotarinsha pangush shitungeeranllu, yuwaa tputs wipaa yamapi atusin tsiyatarangu anoo kamankatu naatarangiya. Anushsha kuseeru, Nee yakat mikeerus kasayarus naangtsa. Nee yakat mikeerutanda, Apanll kapeeteeru kasachu, tárangiya. Itaru, ungsirshitisin nda k'kuzee payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Anuritam zar tarasitaranllu, Apanll muchchur Lotarineetsi: Naturi mikeerush chiyzayarush naangcha izanllpatartish, iparish tsimbunari, ashparitis tsipatsee punireesa suwangtsa. Nee na musásiri yaktaa Apanll mikeeru wanichiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Itaru, Lotarinsha nda mikarangiya. Apanllsha muchchur waantari putayaru, wizanlleetstam, wipaatstam ashpari Apanll tashitungarangiya, watam Apanll Lotarineetsi kizpur chinaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tashitungaramchu, Kamungamaam zandkeesa, mikeerus iripungtsa. Kushipish pakchiyam napintspa. Pakchiyam ngootsish tándsapeem xiyintspa. Izuuru machip suwamamari suwangtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Itaru, Lotarinsha: Nduni. Amb shirinllpa, Apaa. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Watam shiy nuwaa chinarangshawa, misha nuwaa taarasheetsi tapachindarangshawa. Ashirucha, nuw shiyaa atashina. Nuw machip suwamaam zandkeezi. Suwakinaareena, apusaripa waneeshish nuwaa kamatchindanaya. Ashkachu, nuwshapari tsipachina. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Itaru, na mazinanganlla. Nishuri yakat pakich watsiri taarcha, amb suwakuri, ¿shiy anoo amaksha? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Apanllsha muchchur: Zuraktishcha. Yuwaa átish anoo yakat wanicheezi, watam átshawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ashiriya, naangsi mikeerush. Itaru, musá wanicheezi. Urupa shiyamari kusachsha yakat Sówarshuya, tárangiya. Yakat pakchi atusin Sówaraa ísamaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lotarini puturi zar yakataranllu anush kusarangiya yakat Sówarshu. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Apanllsha yuwarpich sin ashiru sumasee kawamban zanganirangiya. Pingar kuraku tamatarpari ashiru kizpur kurarangiya Sodomshucheetsi, Gomorshucheetstamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Amb sheeru, Apanll Sodomshuchee tputsi ichingaru tpachingarangiya: tiptsirpatatam, chirichiritam, maachi ichingaru muchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Itaru, Lotarinsha wizanll suwayarandsin, apus uship nap ashirangu, yumeemsha kinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aprahamarinsha sing zar Apanllpa Lotaam tapachindapi átu, tsiyatashinu, ambtam putam zar puturi naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodomap, Gomorap yakat nap ashirangu, ichingaru tsimbunari wazawash yakat taaru an msas tuwap mzeetaru parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ashiriya, Apanll yaktashchee Sodomshuchi, wazawshuchtam tputs ichingarusin waneerangiya. Itaru, Apanll Aprahamarineetsi chinarangu, Lotarineetsi nda waneerangiya. Itaru, Sodomshucheetsim kiyung yacharangiya. Ashiriya, na kamaneena yuwaa Apanll tsimbunaa yakat Sodomaa, Gomoraatstam ashiru sumaspat waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","31","Lotarini Sówarush taamaam punirangu, Sówaraa yakat kasayarandsin, wipaptari kiz tsimbun machip naataranganaya. Ambirisha wachush wantsush taaranganaya. Lotarinsha wip iwachiztamarini munaa shipamunchee tárangiya. Iy aparini kizpuri wachinayanllcha. Ashiriya, ¿chiy tamaycheezich? ¿Chakaja chiyaa yamachinllina? Kamuz nduniwa, mun wachin tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ashiriya, Apapaam tuwarsayaruni, washunand maayani. Ashkachuni, iparinayani yaamatari ipareemani, tárangiya iwachiztamarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Anuritam psaan tapitaranllu, mun putsisarini vinoo wapareem yáseeru, tuwarsarangiya. Sheeru, waparpa maarangiya. Itaru, Lotarinsha kapung karusarangu, nda chinarangiya yuwaa wip ashirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","36","Putamsha munaa: Nuw psaan apapat tamanllimna. Ashiritam, na psaan shiysha apapaa tuwarsayarush, apapash mangi. Tsimbunartini iparinapani, tárangiya. Táyarusin, yusursha wapareem tuwarsaranganaya. Wipsha nllurarini uwsha waparpa maarangitamta. Itaru, waparsha kapung karusarangu, nduntam tácharangiya. Amb sheersin, tsimbunurtisin mireeranganaya waparee wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ashiriya, Lotarinsha wip iwachiztamarini uwma kamuzaa tatsipurangu, wipaa sur Mowabaa ísamarangiya. Mowabchich tputs pzapaneerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yusursha Lotarini wip nllurarinshitini tatsipurangitamta. Uwsha wipaa suru Pegami ísamarangiya. Pegamsha pzapaneerangitamta. Watacha Amónshuchinandarita tputsi. Ashiriya, na kamaneena yuwaa Lotarini wip iparinarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aprahamarini shitungeeranllu, minupshat tsap Neguebapsha naatarangiya. Ambshat yakat Guerarash kusarangiya. Anshurisha taarangiya. Annungitam tsimbun yakat Kades, Surtam ashiru taarangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Anushsha Aprahamarini kuseeru, kurakaa Abimelekaa punirangu, wizanlleetstaa Saraa, Izartana, tárangiya. Yaktashuchshat Guerarshuch kurak Abimelek anoo k'kuzee mazinarangu, wasunduree kamachtayaru, wasundursha yamayashinusin, Abimelekaam panaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Sheeru, natam zar Abimelek kizpur maaranllu anush pamasarangiya. Anush Apanllsha: Abimelekaa, uru shiy mikeerush tsipachsha, yuwamand kizaa wazaranll waninda yamarangish anumandaya, tárangiya. Táyaru, Abimeleksha anoo mazinarangu, kizpur punirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Uwshat: Apaa, itaru ¿mayamanda nuwaa wanichish? ¿Antaati nuw kizaa mantsir patataranginawa? Nda pakchiyam yutarit patatarangina. Waanacha Apraham nuwaa tamapingaranganda. Wizanlleetstaa Saraa izartana, tárangiya. Kizsha: Nee kamuzaa nuw wawartana, tárangitamta. Ashirucha, nuwsha mapiyruri yamarangina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Apanllsha: Zuraktishcha. Nuw shiyaa yasakina. Nda kizaa mantsir patatarangish. Anoo nuw parangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Itaru, shiysha na kizaa izuuru wazaranlleemtam tuwanpungcha. Nduniya shiy tuwanpukush, uru nuw shiyaa kapungtanda wanichinll. Uru zurampatari shiy tsipachsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Putamsha tarasitaranllu, támeeru, Abimelek tiptsiree kuruzurangiya. Kuruzeeru, yuwaa pamasarangu anoo kamanirangiya. Típtsirsha anoo mazinarangusin, kapung punirustaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Anumunshat, Abimelek Aprahamarineetssha kuruzeeru, Abimeleksha tunuxinayaru, ¿Mayaamsha shiy nuwaa ngutish tamapingarangsha? Nuwaa kiyung yachamaam zandarangsha. Tputsireetstamti tayutaritamaam zandarangtamsha, ");
INSERT INTO cbuNT_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","11","tárangu, Aprahamarinsha: Nuw mangishi chinaranguri, Nishuch tputs Apanllee kuk ndunpari payukanaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Itaru, ashiritaati, nuw zurkuri tárangina. Antaati nuw kaapana tunareezi. Nee izartana; Apapcha wipaya. Itaru, wanirin minshuchi. Ashiritaa, nuwsha anoo yamarangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ashirucha, na ningsha, waana Apanll nuwaa kamachtarangu, apareetsi pang' kasayaruri, anush nuwshat izanlleetsi waneerangina. Yapimasaja yakat kuskachiniya, ashiri tputssha shiyaa mashkinaari, shiyshat; Nuw nee wawartana tángcha, tárangina, Aprahamarini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelekarinshitini waamatam wazaranlleemtam Saraa tuwanpurangiya. Sheeru, anumand maachtaa mangutari Aprahamarineem zapan panarangiya. Opeejtam, wakaratam, muchchureemtam: kiz, kamuz ashiru panarangiya. Shimbeeru, ");
INSERT INTO cbuNT_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Napangi, nuw tsapunni waninll taara. Sheerush, nachungangi. Yapim shaana naamaam zandaksha, amb naayarush taamacha, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","anamunsha Saraatsshat tsiyatarangtamta. Nuw shiyaam zaranlleemish kurikee minum milo panarangina. An aship kurik shiyamand tuwapakpaz ashkina. Ashkachuri, anoo tputs ichingarusin yasachinllinaya. Ayamtaati shiyaa nda mantsirimash k'kuz tsiyatkusin táchinllina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ashiriya, Aprahamarinshitini Apanllee masharangiya. Apaa, Abimelekaa yusur chinangcha. Mishat, wizanlleetstam wánguyareem yarangcha, muchchureewaatstamta. ¿Tamashtaj ayam wip pzapanichinllina? Aprahamarin tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Yuwamand Saraa Abimelek yamarangu anumand Apanll waneerangiya. Abimelekchich tputs nda ayamtaati iparinachinllinaya, Apanll tárangiya. Ashirucha anoom Aprahamarini Apanllpa masharangiya. Ashiriya, na kamaneena yuwaa Aprahamarini wizanllee Sararinee yanpurangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Apanll waana Saraa chinarangu, Sararineemi kapung istachinllpa, tárangu, anuritam kukoo tuminurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sararinsha mireeyaru, kamuz tatsipurangiya. Anpursha Aprahamarini kizpur wachinamuna. Ashiritaa, iparinarangiya. Apanll waana anush zar iparinachsha, tárangu, anshuritam zar Isaakarini nllurtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aprahamarinisha wipaa sur Isaak ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Anumun tuchip matayaru zar wipaa Isaakaa wayumshir tas ktururangiya. Apanll yuwari kamachtarangu anuritam Aprahamarini tuminurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Anpur Aprahamarini masachirini 100 taarangiya. Anpuritam zar Isaak nllurtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ashirucha, Sararinsha: Nuwsha mangi kapung ksakuri stakina. Tputs nuwaa ichingarusin mazinakchusin, nuwaa stachtampasinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Chakaja Aprahamaa, izanllish iparinachpari tárang? Apanll waana iyaam zandeeru, nuwsha kizpur wachinataati iparinarangina, Sararini tárangiya. Ashiriya, na kamaneena Aprahamarini wip Isaak nllurtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aprahamarinsha wip Isaak waniree mimir kasarinaramchu, kapung shambatchima, táyaru, tputsee yambiyaru, kapung shambatshisheem wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ismaelarinsha waparee wip Isaakaa michitku, zarungchaku natsarangiya. Sararinsha anoo pakeeru, kapung tsiyantarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Wazaranlleetssha Aprahamarinee, M'chachuri wip ¿mayaamshtaja nish iyapa washunand taach? Arap zanganeerush, ksangi wanirpatarta. Ayam tsipakinaareesha, yaantari iparitani Isaak maachiritaatsish yaku nuw mangi ksachina. ¿Mayaamshitaja tputs shiyaa maachiritish patatach? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sararini tárangu, Aprahamarinsha wipangaz Ismaelangaz kapung mang' mantsarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Itaru, Apanllsha: Iparimandish mangish mantsarinllpa. Saraa kuk payungcha. Nuw kaapa chinachi an watacha iparish Isaaka. Sirútama yuwaa nuw suroo kamanirangi an waatatanda. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Itaru, ipareemish Ismaelaam istachtamna. Waani anchich pzapanichtamtaya, watam shiyatam iparshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Putamsha zar tarasitaranllu, pangaa yáyaru, kungootssha maachtash tas tuzureeru, anpatari ichingaru katungatspatari wipaam panarangiya. Akararinshitini apusap naatarangiya. Ambiri naantanll ashku, arap tsap Beersebash kung ndunarip kusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Anush wakungur kawatsirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Wanirsha, Ipari sachisimun tsipakchu, anoo patareema átu, wipaa yasinash puch wayayaru, annungirtatam kayum kuxinxinaw ashirangiya. Ansha, Akarini kuxineeru, wipangazsha kapung tanutantaru, ");
INSERT INTO cbuNT_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","anoo Apanllsha mazinarangu, yuwaa nllur kiyung kachiykachu anoo, Apanll muchchur kanindamand Akararineetsi kuruzurangiya: ¿Akaraa, mashta? Punirinllpa. Nuw yasakina yuwaa iparish kiyung kachiykachu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Natu iparish yamangi. Watstaa; tsipatpa. Anchich urutanda iparchichish tsapurnasish pzapanichinllina, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Anshuritam Apanll kungoo Akaraam yámandarangiya. Kungsha tsap kachutam ashiru anush wir kcheewaru parangiya. Akararinsha parangu, anuritam tuzurshineetsi yaranllu, tipayaru, wipaam yásirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Anamunsha, zapish Ismaelarini kanungarangiya. Apanll Ismaelarineem kapung istarangiya. Kanungeeru, ambiri apusap, tsap sur Paránash, taarangiya. Tsak ashshineemshitini wasapamash tinayaru, anoo kis payumaam yasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Wanirsha Akar wipaam wizanll nachungarangu, Ijiptoshuchee wizanuri pakeeru, wipaam Ismaelaam wizanll tupanarangiya. Ashiriya, na kamaneena yuwaa Akararini wipapat Ismaelpat apusap tsap naatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Anpursha Aprahamarini Abimelekash watsapun kayum taarangiya. Ashirucha Abimelek, Aprahampa tsiyatati átu, wipunasheem sundaroo urkar Fikolaa yamayaranllu, anpat ipuneerandsin Aprahamarinshini kusaranganaya. Kuseersin, Aprahamaa, shiyaa Apanll kapungcha chinaksha; wanasir taarasheetsish ksutkiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ashirucha, nuw shiyangaz kapung amikurtamaam zandki. Nuwaa ngutish tamapingariyshpa. Zurmamshiptari Aparimunich sur kamaningandama, ipareetstamti, tputsireetstamti. Nuw shiyaa tamarangimna, nda natsarangina. Arapchitaatish nuwash tsapuni kusarangush, nuw shiyaa kapung chinarangina. Wanasir shiyaa ksutarangina. Ashiriya shiyshat nuwapa ipari, tputsiritamti, shiyapa tputsirish kis ipunchinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aprahamarinshitini, Na shiyapa urutamarishapari chinakurini taachiniya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Itaru, zuwaa Abimelekaa, táchinllpa wanasirirta. Mang shiycha tputsirish iyaa posorini itutsiranganaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleksha, naturi átush mazinayaana. Uru nda yuwari yasarangish anuri nuwaa nda kamanirangsha. Natsha átush ¿nuw tamaycheezi? ¿chakamasaja waatssin kamachtayaru amb ashiranganaya? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Aprahamaamsha, Zuraksha. Ashiri amikurtayani tárangiya. Táyaru, Aprahamarini opeejaa, wakaraatstam Abimelekaam putayaru panarangiya. Sheersin, wanasir amikurtayarusin kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","29","Anamunsha Aprahamarini yusur tsimbun matayaru opeeja Abimelekaam panapi átu, xanateeru kasarangiya. Abimeleksha anoo parangu: ¿Mayaamsha zuwaa, aship opeejareetsish putarangsha? ¿Chakamsha panapi átshaa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Aprahamsha, In shiyaamcha mangutariti panapi túri putarangi. Nimunuri nuwaa tputs ichingarusin pakchusin, Aprahamtanda ktsimarini, táchindanaya túri, ashkina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Amb ashirangsin, anumand posoo Hebrewshuchish k'kuz Beersebaa atusin ísamaranganaya. Watam anush pososh Aprahamarini Abimelekpa zurmaptari tsiyatarangsin, wanasir amikurtaranganawa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Annacha amikurtam yuwaparamatssin, Abimelek wipunashpa Fikolpa yusur wapitam, Beersebamand kasayarandsin, watsapuniptam Filistewshuchip kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aprahamarinsha anshuri Beersebash taarangu, yasinaa sur tamarisku minum tatsumirangiya. Sheeru anush Apanllee tsiyatarangiya. Tsiyatku: Apaa, shiy urutamari taatarsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ashirucha Aprahamarini Filistewash tsap, zapan masach taarangiya. Ashiriya na kamaneena yuwaa Aprahamarini Abimelekpa wanasir amikurtarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Anumunsha zapish Aprahamarini wip kanungaramchu, anush Apanll Aprahamarineetsi yacharangiya taárasheetsi. ¿Zurkeeja nuwaa kuki payuk? átu, Apanll Aprahamarinee yacharangiya. Apanllsha: Aprahamaa, táyaru, Aprahamsha: ¿Mayaa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Apanllsha: Iparish Isaak yuw minum kapung chinakish an pachayarush, muchingi nuwaam ungirtamaama. Iparish machip Moreyap machtancha. Nuw anoo mach yámandachinllpa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Aprahamarinsha anuritam ayu táyaru, sitkachu chiyzayaru, ndaturi taraseeru, sumasee zapan surayaru, burrumun ush uxinasheem wayarangiya. Sheeru, wipapat Isaakpa, tiptsiritam tsimbun aship naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tuchip zar Aprahamarini maayaranllu, anush nap ashku, machee parangiya. Tiptsireetssha tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Siy nishuri burrpat taaraptsa. Nuwshat iparpati Apanllpa tsiyatanipa piyam machpi. Na kanapunipa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aprahamarinsha sumasee yáyaru, wipaam Isaakaam tunukurangiya. Waama Isaakaam tazumaama átu, ashirangiya. Sheeranllsin, naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ashiriya, ngootsish naatach ashkusin, Isaakarinsha waparee: Apaa, sumasee na payukaniwa. ¿Yapshta opeej karupana? ¿Mashtaja pachayaruch, mucheeruch, Apanllee ungirtachich? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Waparshat: Waana Apanll opeejaa karupan iyaam panachpari, tárangiya. Táyaranllu, naataranganaya, yap Apanll yámandachinllpa tárangu ambi. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Anushsha kuseersin, Aprahamarini patumbchee xanatarangiya. Sheeru, suramaa tazumaam xanatarangiya. Anumun wipaatssha Isaaka putayaru, kamuriyaru, surammun xanatamamun wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Sheeru, k'chiroo yáyaru, wipaa Isaakaa yuwaa kayungpi átu ínakchu anoo Apanllsha ");
INSERT INTO cbuNT_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","íwar kanindamand kuruzurangiya. Aprahamaa, iparish pachamanaa pcharinllpa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Na, nuw shiyaa yasayana. Shiy nuwaa izuuru k'keetsi mangoonaksha; payuksha. Nda ipareetsish pachindarangsha. Izuuru ipareetsish minamtaatstaa pachayarush, anpa nuwaa ungirtamaam zandarangsha, Apanll Aprahamarinee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aprahamarinisha anshuri piyam nap ashku, opeej karupan yasinamun wapzeer witsimun yungambeeyaru, xarayaru, xixeewu parangiya. Anootssha putayaru, pachayaru, anoo mucheeru, Apanllee ungirtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ashirucha, Aprahamarini anoo machi ísamarangiya. Apanll nuwaam opeejaa karupan panarangiya átu, surunarangiya. Tputs na wandaritam anoo mach atanaya; Yuwash Apanll opeejaa karupan iyaam panakiya, tánaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ashiriya, yusursha Apanll wasundurur Aprahamarineetsi íwar kanindamand tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Nuw zurampatarichsha atashina. Nuwaa kizpur chinaksha. Napa ipareetsish minamtaatstaa nda pachindarangish. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Anumand nuwsha shiyaa aranginasha istachinllpa. Shiyachich tputs pzapanichinllinaya. Aship tsangach taachinllinaya. Mazachee táchimaam pinastarich ashchinllinaya. Mishat, shiyachchipa nllitari tputs yakat kundartakchusin, shiyachichsha tputs waamaritin undararee kasichinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Yuwamand shiy nuwaa kuki payurangish anumand nuw tsapurunasish tputseem ztaru istachima. Shiyachich nlluranur tputsee istachiya, Aprahamarinee Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Táyaru, Aprahamarini waptam yuwash tiptsiree kasarangu ambtam kanapurangiya. Sheerandsin, washunand muchchurpatari waptam taarshiptam Beersebap kanapuranganaya. Anush kapung taarangiya. Na kamaneena yuwaa Apanll kamachtayaru, Aprahamarini wipaa pakchim pachamaam pishtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Minushsha zar Aprahamarini taar ashku, k'kuzee mazinarangiya. Aprahamaa, na zuwanllish Nahor wizanll wip pzapaniyanllshacha. Washunand arangich tuchip matayaru wip taariya, táyaru, ");
INSERT INTO cbuNT_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","surootssha kamanirangiya; Iwachiztamarni sur Osa, anumunsha Busa, Kemuela, ");
INSERT INTO cbuNT_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseta, Asó, Pildas, Idrata, Bitowera, watacha Milka wipa washunand 8 taariya Nahor wizanlli, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Itaru, Bitowersha wip Rebekaa kiz sur wanindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahorsha Aprahamarin zoonll minshuchishsha wizanll Rumashsha iparinarangiya ipunpunaru, iwachiztamarni sur Teba, anumunshat Gahama, Tahasa, Maak, aship taarangiyaa. Ashiriya, na kamaneena yuwaa Aprahamarini zoonll Nahorarini iparinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sararini masachirini 127 taaramchu, yakat Hebronush, Kanaanash tsap tsiparangiya. Aprahamarinsha wizanllingaz kapung tanurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","4","Tsiparee kasayaranllu, wamkuripsha tsiyatati átu, naatarangiya. Aprahamarini wamkurish Hititshuchish kuseeramchu, Nuw siyaa átana: Arapchitaateena, nuw siyash kusaranguri, nuwaam tsapuneetsis mapshishee tupaxanxangasinda. Izanllini tsipar mappi aturi atina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hititshuchsha: Zuwaa, mazinanganlla; Arapchitaateesha ashiru, itaru shiyaa kis napkiniya. Watam shiysha kizpur kurak ashirush iyash taakshawa. Mapiyrush izanllinish tsipar mapungsi. Mapshish iyash kizpur wanasireewcha taaru, napeerush, yuwash shaana zandkish anush mapungsi. Antaati iy ¿mayaamaja mapshisheetssha pachindchinee? Uru mapumaam taariya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","8","Aprahamarinshitini much tsapush timucheeru, Hititshuchee tasaseeru, Zurkeesa átus, nishuripari izanllineetsi tsiparee mapchina. Ashiriya, nuwamun suri Efronaa, Sojararinee wip mashangints. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Mapshish patumbich wach, Makpela sur paxanxpi átana. Waanpatatari watimburanll paxanxpi atina. ¿Wanipamasaja waritakiya? Nuwshat anuritam tuwapachina. Ashkachinareena, nuwaamatarishapari mapshishireemi payuchina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efronsha Hititshuch mazinazinaw ashirangiya. Efronsha waani tputs chapungucheewtamta mazinapana átu kapunguri tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ichee, amb tárinllpa. ¿Mayaamaja nuw shiyaam tipuranlleetsi tupaxanxachi? Ngutariti panachinllpa. Annungirtam patumbich wach taariya tsipareem mapumaama. Iyashuch ichingarusin partamsin, shiyaam ngutariti panachinllpa. Anush izanllinish mapungsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Itaru, Aprahamarinshitini yusur tsapush tutunlltayaru, much timucheeru, ");
INSERT INTO cbuNT_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Efronaa: Ayu, tángcha. Kurik tuwapachinllpa tipuranllimandish. Ashiramchuri, annaapari mapiyashti, izanllineetsi mapuchshitina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efronsha: Ichee, mazinangcha. Timburanlliz 400 kurik waritakiya. Ashiritaa, mapiyrush izanllinish mapungcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aprahamarinsha anuritam kurikee yáyaru, tatsamooru tuwaparangiya. Ashparitam Efron táyaru anuritamta 400 kurikee panarangiya Hititshucheema. Wanasir tácheeru tuwaparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ashirucha, Efronaa watsapun ichingaru ashpari watimburanllee mapshishpatari paxanxarangiya, yapeem Mamre tsap tatsumawtam taarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Anoo ichingaru Aprahamaammarisha yarangiya. Hititshuchsha tputs ichingarusin anoo paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Amb ashiramchu, anacha Aprahamarini wizanllinaa tsiparee yáyaru, Makpelash wach pshtayaru, mapurangshita. Makpel wach Kanaanash tsap taariya, yap Mamre, Hebron ashiru tsap taarangu ambi. ");
INSERT INTO cbuNT_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Amb sheersin, Hititshuch waanaatsi watsapun Makpelaa Aprahamarineemi tupaxanxarangiya patumbchee wachu. Aprahamarinsha anoo tsap waamatarisha yarangiya tsipareemtam mapshisheema. Ashiriya, na kamaneena yuwaa Sararini tsiparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aprahamarini anpur zar kizpur wachin taarangiya. Apanllsha Aprahamarineetsi kizpur chinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Anpursha zar Aprahamarini taar ashku, mangush chinarangu, muchchuree kuruzurangiya. Ansha muchchur wachina; sirútari Aprahamarinpatari urutari ipunuru taarangiya. Uwsha Aprahamarinee maachiri ichingaru ksutarangiya. Muchchursha kusarangu, Shiyshat maxishi pzungandama. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Zurampatari Apanllimun íwarpichimun sur tsiyatangandama. Watam Apanll tsapurunasee ksutkuwa. Nishuchee Kanaanshuchee kiz ipareemi Isaakaam panamaam watsipparee, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nuwap tsapuni yap sirútama taarangi amb shiy napashini; ipareemi Isaakaam wizanll nachungashini. Itaru, nuwaanchichitari kamindi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Muchchursha; Waritariya. Yuwaa átish anu mazinakina. Zuraksha. Itaru, ¿apaz kizsha nuwash tachitamaam nda zandku? ¿Anoo nuw tamayachshitazee? Waanari ashiru, ¿ndushat amuypatari Isaakpa naamaam waritak? yap sirútama taarangish ambi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aprahamarinshitini; Nduni, ipareetsi amb machinllpa, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","watam Aparich wansipich waana nuwaa shtungangcha; apareetsish pang' ksangi: tsapuneetstamtish, maachiritaatstamtish, zipareewaatsish ashpari ksangi, táranguwa. Nuwshat anoo tsap shitungaranguri, ningeemsha kusaranguri, na neetssha tsap Apanll nuwaam panarangiya, ichingaru chinllineemtamti pzapaneemaama. Ashiritaa, naakchush, waana Apanll wasundurur shiyaa imachchiya; waana Apanll shiyaam kizaa tuyamandachiya. Shiyshat, anoo kiz nuwaam ipari wizanll yushindachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wandaya, shiyash kiz tachitamaam ngatkitaatiya, shiyshat mangutaritish xunarush kanapumaam waritartamta. Itaru, ipareetsinaari amb machinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Muchchursha: Ayu tárangu, Aprahamarineetsi máxash pazurangiya yuwaa tsiyatarangu anoo zurarangiya. Yuwaa kamachtarangu anuritam tuminurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sheeru, Aprahamarini muchchuree zanganirangiya. Ichingaroom maachi panarangiya; kameechootstam chung zanganirangiya. Ashiramchu, Aprahamarini muchchur naatarangiya Nahorap watsapuni Mesopotamiyapi. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ambshat káyaranllu, apusarit maamchu, zapishsha zar pukamchu kusarangiya. Anshurisha yaktanung chapung, kungunung tipashinung kuxineerteeramach ashiranganaya, kameechurini yansakamchusina. Ashin kiz kungoo tipakatu kuseemach ashku ashinutam zari. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Aprahamarinshitini muchchur Apanllee mashamashtaru kuxinxinaw ashirangiya. Mashku; Apaa, nuw shiyaa táchinllpa, watam shiy Aprahamaa kapung chinakshawa. Shiyshat nuwaa kapunguya chinakush, nuwaam istangandama. Wanasir nish yakat kuschima nda mantsirimash shitungamaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Shiy nuwaa partamsha yuwaa nish kungunung tipashinung ashparitani kanuskini anootsi. Shiyshat kiz kamasin ningeem zanganingcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nuwshat mashkuri, Nuwaam, izaree, kungurish pakich pananda, tákchuri, uwshat watundurish tipayaru, nuwaam yásichpa. Itaru, nda nuwaamatam wapi túri tina. Ichingaru kameechureemtamti yásichpa. Anshat kiz shaana, Apaa, wasina ipusangcha Isaakaam wizanlli anuri tupanamaama. Anoom nuw shiyaa mashkina, watam shiy paturunarineetsi Apraham kapung chinakshawa, tárangiya. Yuwaatsiri tsiyatku ántaru anootsiri, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ndaturi Apanllpa tsiyatam iwatsparu, anush kiz kamasin shitungta sheeshinu, watundur kuktaranllu, iriptaranll ashirangiya kung tipakatu. Ansha kiz kamasin Bitowera wipa. Bitoweraatssha Mirak wipa. Waparsha Nahora, Aprahamarini zoonlli. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeksha kamasin kizpur wanasirimuna. Taárashsha wanasirimunatamta. Kamuzpa nda minumtiyam mantsirimash chinarangiya; izuuru tsasamuna. Ashirucha, anush pososh kusarangu, wantsush tipakatu karuwarangiya. Watundurish kungoo tipayaru, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","wapitam íwar káreemchu, anoo Aprahamarinshitini muchchur tsiyatati átu, iriptaranllu; Izaree, kungurish nuwaam tundurshish pakich pananda; waachima, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","kizsha: Ayu táyaru, tundoo yáyaru, Aprahamarineemi muchchur tunayungayaru, yásirangiya. Sheeru, kungoo ashpiritssin waaramchusin, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","anush Rebeksha; Xa, musámachimasi; neetsiritamapa nuwma yusur kung tipatama. Waani kameechurish waaptamsina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Táyaranllu, watundurish wakunguree iwatseeranllu, wapitam yusur kung tipakatu, wantsush karuweeru, tipayaru wayata, yusur tipayaru wayata, zapan ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Aprahamarinshitini tiptsir anoo kizaa parangu, napa ashirangiya. Nda musá tsiyatarangiya. Mangshuri, ¿Tamaa nee kizaa Apanllti zanganirangu Isaakaam wizanlli? mangush chinaku ántar ashirangiya. Izuuru yasapi átu, nda musá tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ashiriya, kameechoom yásim iwatsparamchu, ashpari kameech waaramchusin, anush Aprahamarinsha muchchur anichoo yáyaru, Rebekamun ship tawanurangiya. Ansha anich kizpur wanasirimshi oroomuna, kayakarinshitini 6 gramos taarangiya. Sheeru, arang yusur pázoosheemsha tsimbun panarangitamta. Ansha pazushish wiykan 100 gramos taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Aprahamarinshtini tiptsir kizaa mashku, Izaree, itsinsarush kamaningandama. ¿Kaapa shiy aparish chakanaaree? Mishat, ¿shiy nuwaa tputsiri zandeecheezish na psaan shiyash pangish kuskachuree? ¿Anoo amcheezish? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","25","Rebeksha; Nuw apari Bitowercha, Mirakcha apapaa wipaya. Waparsha Nahorcha. Watacha nuw pachirina. Mishat, pangshitini kapungutam kureeriya yuwash na psaan maachis anooma. Katungatssha zapantam taariya. Kameechoomtam martamaam taaritamta, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Aprahamarinshitini tiptsir, Zuraktishcha, tárangu. Tsapush tutunlltayaru, Apanllpa tsiyatku, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Apaa, shiy kizpurtishcha. Wappari yuwamand shiy nuwaam istarangish anumanda. ¿Shiy tamaru Aprahamaa kapung chinaksha? Shiy uru istaksha. Aprahamamand wamin shiy nuwaa kapung istarangush, na nish kusarangina waanshutam maachiri pangu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeksha, Ataataa kamaniti átu, wanirip pang' iripurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Anushsha Rebek wayuch kanungas sur Laban taarangiya. Ashirucha, Rebek wanirish pang' kuskamchu, wayuchsha wizaree parangiya yuwaa anich shipamun tawanuru, pazushitam pazumbaru anootsi. Rebeksha yuwaa kamuzaa parangu anoo waniree kamanimantaramach ashirangiya. Wayuchsha Laban mazinarangu, uwshat shturanllu, nachungakatu, Aprahamangaz muchchur iripeeranll ashirangiya. Kungunung tipashinung kuskamchu, Aprahamaa muchchur parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labansha pakeeru, ¿Tamarimta? Ichee. ¿Wanasir kusarangish? Apanllpari shiyaa nish yushindarangiya. Napa ningeem kusarangish. Pzaya, nuwap pangi naayani. ¿Mayaamaja neetsiri wishchip shiy kuxinxinaw ashchish? Nuwashuna pangi pshtuyani. Iy pangini kapung kureeriya shiyaama, yuwash maachish anshu, mishat chineemshitish kameechoom pangus taaritamta, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Aprahamarinsha muchchur, Ayu táyarandsin, naantatssin, Rebekash pang' pshturanganaya. Pshturangusin, kameechootssha yuwaa kayak chiparutarana anoo tapurimbayaru, ashpari yuwaparamchu, watungasheemsha yáyaru, martarangitamta. Sheeru, ashpari kameechoom martarangiya. Ashiramchu, Labansha kungoo tipayaru, Aprahamaam muchchur panarangiya. Wipunasheemtam kungoo panarangitamta waani wats kupapana átu. Sheeru, anumun wats kuparamchusin, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Labansha katungats mbaseeshinu, Ichee, shiyshat ktungangi, tárangiya. Aprahamarinshitini muchchur: Nda, zuwaa, musámachi. Nuwma tsiyachimasima yuw k'kuz payururi, yushindarangi anumasa. Ndatuma tsiyataruri, katungamaam zandkeezi, tárangiya. Labansha: Ashiri Ichee, natu tsiyatangsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Uwshat: Nuw paturunari kurkirpancha. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Apanllsha Aprahamaa kapung chinakiya. Ashirucha, kapung istarangu maachiri zapan payuku taakiya. ¿Mayaja pshatach Aprahamshu? Chinutam opeeja, wakaratamta, urkirtamta, orootam, muchchurtamta, muchchureewtam kizawaw kamasinawa, burrutamta, kameechutamta, aship maachiri payuku taakiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Wizanllsha sur Sara kizpur wachinataa, wip kamuz minum nllurtarangiya. Na ansha kanungas putsis taariya. Ashirucha, nuw paturunari maachirita ashpari wipaamsha tuchingeeru panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Paturunari nuwaa waneerangiya, Ipareemi nishuchee kiz panarinllpa Kanaanshuchish tsapu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ashirucha, nuwaa kamachtarangu; Ambinaa nuwap tsapuni napashini aparpi maachirita. Amb nuwaanchichitari kamindi kiz nachungayarush, nuwaam ipari wizanll tupanangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ashirucha, nuwshat paturunareetsi; Itaru, ¿apaz kizsha nuwash tachitamaam ngatku? ¿anoo nuw tamayachtazee? táranguri, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","paturunarshiti; Nuwaa Apanll taarasheetsi kapung ksutkiya. Wanasir imachkiya. Shiyaatssha ashiritam naakchush, uru Apanll wasundurur shiyaa wanasir imachchiya yap naakchish ambi. Itaru, shiynaa kaapaniri nachungangcha nuwaam ipari wizanlli. Itaru, nuwaanchichitari aparchichirti maachirita. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wandaya shiyash wipaa zanganimaam pachindkachinaareesinaya, shiy mangutaritish xunarush kanapuchsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ashirucha, amb tárangu, nuwaa ningeem zanganirangu, nuwshat nish kusaranguri, ambiri chapung kungunung tipashinung kuxineeramachuri, Apanlleetssha masharangina. Mashkuri, Apaa, shiyshat nuwaa ningeem wanasir zanganingandama, watam Apraham shiyaa kapung chinakuwa. Shaana zandkinaareesha, nuwaa istangandama. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Natsha nish kungunung tipashinungi shaneeriniya. Ashiriya, shiyshat, Apaa, ningeem kiz kamasin zanganingcha. Waanitari kung tipakatu, kusachpa. Tiparamchu, nuwshat mashkachuri, Izaree, kungurish pakich pananda. Waachima, tákchuri, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","uwshat, Ayu, ichee wangsi táchpa, táyaru, iyaam watundurish kungoo yásichpa. Yásiramchu, yusur kameechoomsha tipayaritam yásichitampa. Ashiramchu, shiyshat, Apaa, anuritam kizaa wasina ipusangcha nuwaam paturunari wip wizanlli, tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Amb Apanllpa mashkuri ántaruri, ndaturi k'keetsi tawatspari anush kiz kamasin watundur kuktaranllu, kungush tipashish tipapi átu, karuweeru, kungoo tipayaranllu, káritaratu, anoo nuwshat chiyzaranlluri; Izaree, kungurish pakich pananda, waachima, táranguri, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","uwshat: Neewa ichee, waangsi, tárangu, watunduree tunayungayaru; nuwshat waarangina. Sheeruri, Na kameechureemshitish yaschima, tárangu, kameechureemshiti kungoo tipayaru yásirangtamta. Yásim iwatsparamchu, nuwshat masharangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Izaree ¿shiy aparish chakshita? táranguri, uwshat; Nuw apari Bitowercha; apapaatsshacha Bitowera Mirak wipaya. Waparsha Nahorcha, tárangu, nuwshat anichoo yáyaruri, shipamun tawanurangina. Sheeruri, anumun pachtamamunsha pazushishsha tupazurangitamna. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Sheeruri, tutunlltayashti, Apanllpa tsiyatarangina. Apaa, paturunarimandi Aprahammand wamin shiy nuwaa kapung istarangsha. Nuwaam paturunareemi wip wizanlli waanchichitari zoonll wachinllinu yámandarangsha, tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ashirucha, na nuwsha shiyaa Labanaa atashina: Siysat paturunareetsi Aprahamaa chinakinaareesa ashirus, na ¿may mangishis chinaksa? yuwaa nuwash k'kuzee kamachtarangu anootsee. Ashiriya, na siysat itsinsarus nuwaatssha kamaningtsa. Waritachpari atinaareesa, Ayu átanicha, tángtsa. Wandaya ipareetsish nuwash zanganimaam pinasakus, itsinsartamtis pinasaktanicha tángtamtsa; nuwshat anuritam wanasir yasamaama, watam nuw wanasir yasayanlluri, kanapunlli átana, tárangiya Aprahamarini muchchuri. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labansha, wapar Bitower ashirusin, Zuraktishcha. Yuwaa átish anoo kis mazinakaniya. Waannaapari Apanll amb ashichpa, tárangu, shiyaa ningeem zanganirangiya. Iyshat ¿mayaamshitaja anoo tsiyantakuni, yuwshat zandkini anshat tsiyachinee? Mishat, ¿mayaamshitaja piyarisha mantsirimashsha mangishini chinachinee? ");
INSERT INTO cbuNT_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Itaru iyshat, Rebekaa machimaam waritachparee átanicha. Wandaya machimaam zandkush, machingsiya. Neewa, waani ambirisha zaranlliya shiyamun paturunarish wipaya, watam waana Apanll amb ashiru kamachtaranguwa. Waana amuy ipusarangiya, uwshtisin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Aprahamarinshitini muchchur mazinayaru, tsapush tutunlltayaru, much timucheeru, Apaa, wappari shiy nuwaam kapung istarangsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sheeru, maacheetsisha mangutari zapan panarangiya, orootam, kurikitam, kamisatam ashiru ichingaru Rebekaam panarangiya. Wanireemtamta, wayucheemtam Labanaam panarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ashiramchusin, ichingaru tawatsparamchu, annacha Aprahamarini muchchur, wipunashpa katungarangshitisinaya. Katungeersin, anumunsha waarangusin, anshurisha zar tapeerangu, maaranganaya. Maarangusin, putamsha tarasitaranllu, chiyzayarusin, masharanganaya. Ashiriya, natunaa ksangandama. Naatshitinpa yaanpeetam paturunarini pangu. Ashiriya, naamachinipa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tárangu Rebeksha wayuch, wanir ashirusin, Xamachi. Musá ipareetsi machinllpa. Waanari ashiru, nimun chung zar maakinaari, aship zar maaramchush, annaapari ipareetsi machichsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Itaru, Aprahamarinshitini muchchur, Ndambari. Anoomna nuw zandkeezi. Arang zar taxarariyshpa, watam Apanll waana yuwaa naachi anoo wayaranguwa. Anoo nuw ¿mayaamshitaja arang yanchee? Ashtaa ksangandama; naachima, nuwaanpeetam paturunari pangu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","58","Tárangu, uwshtisin, Musámachi. Amuyaatsima kuruzeeruni, yasachinipa. ¿Amcheeja uwshta? táranganaya. Táyarusin, Rebekaatssha kuruzuranganaya. Kuruzeersin masharanganaya. Rebekaa, ¿Amaksha shiya? ¿Nipat kamuz naamaam zandkish? tárangiya. Rebeksha uwshat nda pakchiyam xararangiya. Ayu, naachparina, ataa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ashiramchusin, anacha Aprahamarini muchchur Rebekaa machirangshitisina ichingaru muchchurpatarta. Watam Rebek waana minum nllur yanungamarini taaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Labansha wizaree wanasir waneeyaru zanganirangiya. Zangankachu tárangiya. Ashiri apchee, naatachcha. Ambiri zaranllimachcha. Zaranlliramchush, uru iparish anush pzapanichsha, chinllinitamtish pzapanichtamsha. Ashiramchush, shiyamari chinllinish undararpa waratkatssin, waamari kasichinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ashiramchusin, tsiyatam iwatsparamchusin, Rebek naataranshita. Muchchuree yamayaranllu, muchchurpatari kameechumun ush chipayarandsin naatarangiya. Aprahamash muchchur tachitarangiya. Amb sheersin, Rebekaa yamayashinusin, zapish kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Anpursha zar, Isaak Neguebash tsap taarangiya. Anshutam kung tipashish taarangtamta. Anootssha kungoo tipashee ísamaranganaya, Apanll anoo posoo kis napkiya tusina. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Zar puputaranllu, Isaaksha paseektakatu shitungeeranllu, mzatsipsha xitarat ashirangiya. Mapiyru xittu, piyam nap ashku, yap nda chinaru amb kameechsha shitungeeshinusin, wanungi turutut shitanu anoo parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeksha mapiyrtam kameechumun ush kuxinaru, naantachu, nap ashku, parangitamta Isaak káyashinu naantachu anootsi. Paranllu, kameechumun ush kuxinaru an tsapushsha karuwaranllu, ");
INSERT INTO cbuNT_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Aprahamarineetssha muchchur masharangiya. Ichee, ¿chaka anoo? kamuz mzatsish shitungeeshinu naantanllu; ningeem iyap chamayangakatu naanlliya, tárangiya. Aprahamarinsha muchchur: Anoo nuwcha paturunari wipa yuw kizpur chinaki ancha, tárangiya. Rebeksha anoo mazinarangu, paziku, wachoo chirikpasha kámanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Aprahamarinsha muchchur Isaakaa ashpari yuwaa sheeshinu anoo kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaaksha Rebekaa anush yamayaranllu, machirangiya wanirinap Sararinpini pangu. Sheeru, anpatarisha yamaranganaya. Yamayaru, Isaak wizanllee kapung chinarangiya. Rebeksha wazaranllee kapungtam chinarangitamta. Isaaksha waniringaz kapungtaa mang' mantsarangu, anoo mikeesha mbizarangiya. Ashiriya, na kamaneena yuwaa Isaak wizanlleem Rebekaa yamarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aprahamarini wizanllin Sararin tsiparamchu, anumun minootssha kiz Kertoraa yamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Anoo yamarangu, wipaam pzapanirangiya. Ansha wip iwachiztam Simran, anumunsha Joksan, Medan, Madiyan, Isbak, Sówa, ashpamuncha washunanda ichingaru. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksanshaa arang iparinarangitamta tsimbunaa, Seba, Dedantamta. Sheeru, Dedanchichsha maachiri taarangtamta; Asurewshuchi, Letusewshuchi, Lewmewshuch, ansincha anchichimuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Anumunsha Madiyansha wip taarangtamta. Iwachiztamarini sur Efaa, Efer, Hanok, Abida, Eldaá ashpamuncha Kertor wachinllinu. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aprahamarinshtini taar ashku, kizpur wachinachu, wipaamsha Isaakaam maachiritaa tuchingarangiya. Ashirucha, Isaaksha waparee maachirit amuytarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Itaru, minshucheemsha wizanll wip yuwaatsimari payuru anoo pakchimari panarangiya. Ashiramchu, ndaturi waana tsiparu, wizanllee wipaptari piyamaw zanganimbarangiya. Isaakaa kasarangusin, yapsha zar yaku ambsha naataranganaya. Ashiriya, na kamaneena yuwaa Aprahamarin wipaamsha maachiritaa panarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aprahamarini 175 masachirini tatsamooramchu, anush tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kizpur wachinayaru, Apanllsha yamayaru, zitaminarinpat wani ipunkamchu, naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Wipshitisin Isaak, Ismaelpat ipuneeru, waparee tsiparee yáyarandsin, mapshiship patumbchish wach Makpelash pshtayarusin, mapuranganaya. Tsap sur Mamre, Efronash watsapuni Sojararinshini wipa, Hititshuchimuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Watam sirútama Aprahamarini anoo tsap wizanllinaam mappi átu paxanxaranguwa. Ashirucha, anshutam wizanllinshutam ipunaru, Aprahamarineetsi mapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Aprahamarin tsiparamchu, Apanll Isaakaatssha kapung chinarangiya. Anpur Isaak taarangiya kung tipashish kayumanashta yuwash Apanll anoo posoo kis napkiya atusin ísamarangana anshu. Ashiriya, na kamaneena yuwaa Aprahamarini tsiparamchu, wizanllinshutam mapurangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","16","Ismaelshaa wipaam pzapaneerangitamta. Ismaelaatssha Aprahamarintamcha wipa yuw Akarinshini iparinarangu anu. Saraa muchchur yamarangu anshuchi. Anshat Ismael zapan iparinarangiya ichingaru 12 taarangiya. Anshitisin kanungartaramchusin, waamatawaritamsin watsapuneemaw pachirtaranganaya. Anshitisin sur iwachiztamarni Nebayot, Kedar, Adbeel, Mibsam, Misma, Dumá, Masaá, Hadar, Teman, Jetur, Napis, Kedmá, ashpamunsincha. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelarinshitini kizpur wachin masachirini 137 tatsamooramchu, anush tsiparangiya. Tsiparamchu, Apanllsha yamayaru, yuwash zitaminarini taakana anush Apanllip naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismaelarini tsiparamchu, wachinllinsha pseertaranganaya. Yapeem zar puwachingaku ambi, Hapiramand yakat káyarusin, Surush yakat kuseersin, anshuwari taaranganaya. Ijiptop tsap tasasaru yap ngoots yakat Asiriyap naaku, anshuri taaranganaya. Zoonllin tsapoo kapung pachindarangitaa, ashiritaa anushurisha tsap pseertarsin taaranganaya. Ashiriya, na kamaneena yuwaa Ismaelarin wachinllin pseertarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Sirútama Aprahamarini wip Isaakarin wipaam zapan pzapaneerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yuwapur Isaak masachirini 40 taarangu anpur Rebekaa yamarangiya Bitowera wipa, Labana wizari. Anshitisin, Amorrewshuchi Padán-Aramash tsap taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeksha nda wip wanindarangiya; mipish taarangiya. Ashirucha, Isaaksha Apanllee masharangiya wizanll wip wanindamaama. Apanllsha anoo mazinarangu, kapung Rebekaam istarangiya. Rebekshaa nlluraa mireerangshita. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nllur tsimbunaru, wanir mireeru anshuri waanpatatin natsatatangat ashiranganaya. Ashirucha, Rebeksha waanaatsi wanuts tácharangu, Apanlleetssha: Apaa, ¿tamakee nuwaanaatsi nutsi ashiru táchakee? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Apanllsha, Ipareewtandish ashku; uru iparish tsimbun taariya. Ashiriya, iparinakchush, tsimbun kurak taachiya. Uru waanpatatin kundartachinllinaya. Itaru ashiritaa, shipamunach iparish kizpur kurak taachiya. Itaru, iwachiztamarinsha kurakatam zuwanllimand tsipas taachiya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","25","Ashiramchu, nllurtarangshitisina iwachiztamarinshitini pur taarangiya. Ansha, pur chumbeep zxaru ashchiri wanutsimun taarangiya. Ashirucha, anoomand sur Esawaa ísamaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Esaw nllurtaramchu, anumun zoonll nllurtarangiya. Anootssha sur Akopaa ísamaranganaya. Ansha Akop zoonllimun Esawmun wats putaru nllurtarangiya. Yuwapur wip nllurtarangana anpur Isaak 60 masachirini taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","28","Esawsha kanungaramchu, kizpur washungamuna. Zamzipanimuna. Ashirucha, kis xitariya. Isaakarinsha anoo wip kizpur chinarangiya. Itaru, Akopsha mintam taarash taarangiya. Nda zamzipanimuna. Mzatsipanimun, chinuzpantam taarangiya. Ashirucha, Rebeksha Akopaa kizpur chinatariya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Minushsha zar taar ashku, Akop katungtseemsha chumbeepimashee k'parangiya. Kizpur wanasiri kzama katungamaam kisa. Itaru, Esawsha manginap xitkatu, naatarangu, kanapeeshinsha. Kizpur nizirangu, kapung mariz kayatachu, iriptaranll ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ashirucha, zoonllee masharangiya; Nuwaam katungats chumbeep k'payrish anchich mbaseerush pananda. Papcha, nuw marizimun tsipakchima, tárangiya. Anumand waanaatstarisha Esawaa Edomaa táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Akopsha mangu tamapingarangiya. Ashiriya, chtaru nuwaama nutsish wachinarish, wizpurirtamtish pananda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ashirucha, Esawsha mangush chinarangu, ¿Mayaamaja nuw wachinareetsi zandchi? Ashirimapari, marizimunasha tsipachinashtina. Mangutamparina nuw wachini taachina. ¿Chak ashishtap? tárangu, Ashiri, Shiyshat Akopaa wachinaam kinangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Akopsha: Ashiri ambinaa sheeni. Zurampatari, Apanllimun sur tángandama, tárangu, Esawsha Zurampatari áti, táyaru, zoonlleemsha waanaatsi wachinarni, wizpurireetsitam panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ashiramchu, annacha Akop katungtsee yáyaru, paratush mbaseeru, pangaa yaku sheeru, Neewa. Ktungangsi átu, panarangiya. Esawsha yáyaru, katungkeeru, waaku shimbayaranllu, naatarangiya. Nda mangush pakchiyam xararangiya. Mapiyrangiya; nllur tamapari ashishat taarangiya. Ashiriya, na kamaneena yuwaa Esaw zoonlleemsha waanaatsi wanuts tupaxanxakpaz ashirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","5","Anpursha zar Kanaanash tsap katungats maringarangiya. Sirútama Aprahamarinshini watsapun katungats pishtarangu ambitam anpuru zar ashirangiya. Ashirucha, katungats pishtarangu, Isaakarinsha mangush chinarangu, Ijiptopsha tsap naamaam zandarangiya. Itaru, Apanllsha: Isaakaa, Ijiptop tsap naarinllpa. Wandaya naamaam zandkush, yakat Guerarap tsap naangi yap kurak sur Abimelek taaru ambi. Ashiriya, naakchush, ichingaru zar uru nuw ksutchinlla. Ashchiri in tsap tputsireemtamtish panachima. Sirútama aparineemis Aprahamaam kapung istarangi ambitam sheeruri, ichingaru uru tuminchima. Uru nuw shiyaam istachinllpa. Shiyachich tputs chinllinish uru izapaneersin, kanindap tsangach sunlleerutaru patarich aship pzapanichinllinaya. Ashchiri tsap ztaru panachima, watam aparini nuwaa kuki payuranguwa. Yuwaa kamachtarangi anoo tuminurangtamtawa. Tayapstarangi anootstam nda kapeetarangiya. Ashirucha, shiyamand kaminish nuw ztaru tputsee tsapurunasush istachima, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ashiriya, Isaaksha anuritam Guerarap tsap naatarangiya. Anushsha kuseeramchu anshurisha Guerarash yakat taar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ashirucha, anshuchshitisin tputs Isaakaa masharanganaya; ¿Nee kizaa Rebekaa uchamarshasha shiya? táranganaya. Isaaksha puniku, Nee nuw izartana; tárangiya, watam anpur Rebeksha kizpur wanasirimuna. Ashirucha, Isaaksha mangush chinarangu, watam nuw izanlli kizpur wanasiriwa, izanllimandi wamin nishuch tputs nuwaa pcharundama átu, kamapshirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Minushshat zar kurak Abimelek pangumandsha wach nazambayaru, napanapaw ashirangu, Isaak mapiyru wizanllee Rebekaa pachipta ashishtaru anoo parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","10","Pakeeru, ashiriya kuraksha Abimelek Isaakaa kuruzeeru, Shiy ¿tamaree nuwaa tamapingachish? Nee shiy izanlltishcha. ¿Antaati shiy izareezish? Apaz nuwshat tputsiri nda yasarsin, shiyaa izanllish mantsir patatkatssin, shiyshaparee iyaatssha tayutaritachsha, tárangiya. Isaaksha, Zuraktishcha. Punikutana. Wandazuwa izanllimandi wamin nishuch tputs nuwaa pachachindanawa atutana, nguti kamapshirangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ashirucha, Abimeleksha anuritam ashpari tiptsiree anshuchee yakat ichingaru waneerangiya. Ashiriya, Nuwaa kuki mazinangtsa. Waanari Isaakaa, mishat wizanlleetstam muntakinaareesa, uru tsipamaam waritaktanda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Anpursha zapan masach Isaakaam Apanll kapung istarangiya. Anush tsap mazareem mzayaru, zapan tatsumirangiya. Maachi wanus zapan kxuneeru, zapan yusirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Anoo wanus pusayaru, zapan kurikee putarangiya, Ashirangu, kurkirpaneemsha kinarangiya. Chinshat zapantam pzapaneerangiya, ");
INSERT INTO cbuNT_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","opeej, wakaratam, muchchurtam zapan taarangiya. Ashirucha, maachiri zapan payurangu, Filistewshuchshitisin yuwamand ashku anumand natsaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Natsarangusin, yuwaa kungoo tipayaru waaku anootssha posorinshini tsapupa tamiriranganaya yuwaa wapar Aprahamarini ktseerarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ashirucha, kurakangaz Abimelekangaz kamaniti átu kuseeru, kuraksha Abimelek; Nish tsap shtungangsi, ¿watam iyaatstaa kasimaam waritaksha, maachiritish zapansha payuksha? tárangiya kuraka. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ashirucha, Isaaksha anuritam anoo tsap Filistewshuchee kasayaranllu, piyamsha Guerarap tsap naatarangiya. Ambirisha taarsheem pacheeru wazawash taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aprahamarinsha sirútama kchitama anush kungoom posoom wanasir ktseeyaru kasarangiya. Zapishsha Aprahamarini tsiparamachsha, Filistewshuch naatarandsin, posoo tamireersin, kasaranganaya. Itaru, anootssha Isaak yusur tawangeeru, waparin tamarangpari ambitam sheeru, yusur wanasiritam kasarangiya. Waparin posoo ísamarangu, uwshat anuritam ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Minushsha zar Isaak muchchur wazawash wandatsamun posorineemi ktsitangatssin, waanshuchee tucharchichee kung izupiranganaya. Kizpur wireetsi pakeersin, posoreemarinsha ínaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Itaru, Guerarshuchshitisin chinuzpan tputs kungumandsha pachindatangat ashirangsin, Iycha posorini, atusin, waratarangshitisina. Ashirucha, anumand Isaaksha posoo suroo yasamarangiya, Waratshishi, átu. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ashirucha, anoo posoo kasayarusin, piyamsha posoreemani ktseeranganaya. Ktseeyarusin, yusursha Guerarshuch pachindkusin, waratarangtamsinaya. Isaaksha anoo pos suroo ísamarangitamta, Kundartama, átshita. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Amb tsiyantayaru, anoo tsap wanllitarangshita; minupsha tsap naatarangiya. Yusur posoreemani ktseerangitamsina. Ktsiyarusin, anshunaa ndusha tputs muntaranganaya. Annacha mapiyshtisin taaranganaya. Isaaksha kaneeschee pos parangu, anoo, Xarashish ndunarshita, átu ísamarangiya. Natunaacha Apanll iyaam tsap wanasirsha ipuseeru, panayanllu. Natunaa kisshapari taachchi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Zapishsha taar ashku, Isaak anoo tsap kasayaru, piyamsha yusur Beersebap tsap naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Naayaranllu, apusari zar purangiya. Anshurisha psaan yusur Apanll Isaakaa waanaatsi tuyamandarangiya. Sheeru, Nuw waatatana Apanllina. Aparinish Aprahamarini nuwaa chinarangiya. Ashirucha, punirinllpa, Isaakaa. Nuw shiyaa kapung ksutkina. Na shiyaam kapung istachinllpa, watam aparineetsish kapung chinaranginawa. Uru chinllinish aranginasha pzapanichsha, Isaakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaaksha anush tsap patumbchee yáyaru, xanateeru, anushsha maacheetsisha pshtayaru, mucheeru, Apanlleem ungirtaranganaya. Sheeru, anshuritam tsap pangoomsha tambtarangiya. Yusur muchchurshitisin posoreemani ktseeranganaya. Sheersin, anshurisha taaranganaya. Ashiriya, na kamaneena yuwaa Isaak urkirpaneem kinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kuraksha Abimelek Isaakap pangati átu, wipunasheem Ahusataa ksutamapanee urkar yamaku, anamunsha minamtam sundar urkar suru Fikolaa yamaku, ashpisin Gueraramand tsap káyarandsin, Isaakapsha tsiyatati átu naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Anushsha kuseeramchusin, Isaaksha masharangiya. ¿Mayangaz nuwangaz pangaani átus kusarangsa? Watam sirú nuwaa tsapuneetsis pachindarangsawa. Nuwaa tsapunshish tashitungarangsawa, Isaak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Abimeleksha kurak, Shiyaa paranginiya. Apanll shiyaa kapung ksutkiya. Ashirucha, mangishini chinaranguni, Pzaa, wanasir tsiyatani táranguni, shiyangaz na amikurtamaam zandkuni, kusarangani. Na Apanllimun sur zurampatari tsiyatkuni, amikurtakachuni: ");
INSERT INTO cbuNT_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Shiy nduntam iyaa mantsirimash chinachsha. Iyshat shiyaa waatatamtaya; nduntam shiyaa muntachiniya. Shiyaa Apanll kapungpari chinakiya, tárangana. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaaksha; Zuraktishcha, táyaru, mang' ksarangusin, kis shambateersin, kapung katungkeersin, waambeersin, maarangana. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Putamsha taraseechu, waanpatatin kurakpatin Abimelek Isaakpa wanasir tsiyateersin, amikurtaranganaya. Sheeru, Isaak kanapeeranllu, naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Anpuritam zari Isaak muchchur kungoo pakeeshinusin, Isaakaatssha kamaneeni tusin, kuseersin, kamaniranganaya. Kungoo pachinipa, tárangana. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaaksha anoo posoo pakeeru, suroo, Wanasirimshiptari amiktama, átu ísamarangiya. Anumunsha yakat sura Beersebaa ísamaranganaya. Wandaritam nat in tputs anootstam yaktaa atanaya. Anushsha taarangshitisinaya. Ashiriya, na kamaneena yuwaa Isaak Beersebash tsap kuseeru taarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Anpur zar Esaw 40 masachirini taarangiya. Aship masachirini taaru anush kizaa yamarangiya Juditaatsi; ansha kiz Hititshuch Beriy wipa. Sheeru, anumun yusur minootssha kiz yamarangiya Basemataatshita; ansha kiz Hititshuchtamta Eronarin wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ashirucha, tsimbun kiz íparangu, anshitisin kiz ipambataatssin, ungsirshitisin mantsir tsiyatstangat ashkusin, Isaak wizanllpa Rebekpa kapung mangoo imantsarangusin, nda kis taaranganaya. Ashiriya, na kamaneena yuwaa Esaw kizaa tsimbun íparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Anpursha zar Isaak kizpur wachinarangu, wach pamaam maacheetsi nda waritarangiya; izuuru pinasarangiya. Wipaatssha putsisarineetsi Esawaa kuruzeeru, ");
INSERT INTO cbuNT_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Esawaa, napanganlla. Na nuw kizpurcha wachinayanlli. Tsipani natunaa watsiriteenllshacha. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ashirucha, nuw shiyaa atashina; Ndaturi nuw tsiparuri, timbanllizirish yáyarush, zamzeem xitashini. Yuw zamiz pakish anoo pchashini. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Pachayachush, ptatangshiti. Nuwaam katungshi. Kizpur wanasir ptatangcha. Ashimari nuwaana katungki. Masamurtayarush, kizpur kis kzam mbaseerush, panangandama. Nuwshat natum, ndaturi tsiparuri katungchima. Katungaramchuri, anamun iwaz shiyaamsha nuwaanaatsi wizpuriri panachinllpa, Isaak wipaa ántar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeksha yuwaa wazaranll Esawaa tsiyatstaru waneeku anoo mazinarangiya. Esawsha yuwari wapari tárangu anuritam tuminarangiya. Zamiz pachati átu, xikatu naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Anumunsha kuzizimun waanitarishtisin Rebek wipaa Akopaa: Mazinanganlla. Yuwaa aparish zuwanllpatish tsiyatku anoo mazinarangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ateeja aparish; Zamiz pchashini. Pachayachush, wanasir ptatangi. Ashimari nuwaana kzam katungki. Nuwshat anoo katungaramchuri, shiyaamsha Apanllimun sur tsiyateeruri, wizpurireetsi panachinllpa, tárangiya, ántarutanda mazinayari, wipaa Akopaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ashiriya, shiyshat mazinanganlla. Wanasir mangeetsish p'tsichinllpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tandapunuzip chinuz napashini. Yuw kaapar kizpur wanasiri yungandaru anoo pakchush, tsimbun p'tashini. Putayarush, nuwaam pananganda. Nuwshat pachayaruri, Aparish kamachtanllu ashimatam kis kzam patatchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Amb sheerunll kasachinllpa. Shiyshat yáyarush, paratush mbaseerush, apareemish panangcha. Uwshat katungaramchu, shiyaamsha waanaatsi wizpur wanasirimshee panachiya. Papcha; zapshinaa aparish tsipachshapa, wipaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Akopsha waniree; Itaru, ataa, watam zuwanllinaari Esaw pur taaruwa. Itaru, nuwshat puri nutsimuni nduniwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Apaz nuwshat apapash pang' kuskamchuri, nuwaatssha patatkachu, puri ndunar anoo táchakchu, nuwaa natstakachu, ¿Mayaamsha tamapingaksha? táchapandanaya; táyaru nuwaatssha yutaritam ínachindanaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Itaru wanirsha; Nduni. Amb tárinllpa. Wandtaati aparish shiyaa yutarit tsiyatkachu, shiyshat nuwamun tapshingandama. Natu shingi yuwari áti anurita. Mikeerush, p'tashini, yuw tsimbun kaapar karupana anu. Nuwsha apareemish patatchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Wipsha Akoparini anuritam, putatama átu, chinuzip taárash teet ashirangiya. Putayashinu, tsimbun kaapar karupanaw wanireemsha panarangiya. Wanirsha kaapraa pachayaru, ashim Isaak kis katungku ashimatam patatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Anumunsha, Esawaa wamar yuw kizpur wanasir kamartaku anootssha kurimunazish pshtuyarusin, watuniree yáyarusin, Akopaamsha túmartarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Anumunsha, kaapar pur túchingayarusin, pachtamamun turimeeshinusin, watsurarimun tutsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Yuwaparamchu, Rebek wipaam Akopaam paratush mbaseeru, pangapa washunand panarangiya. Natunaa apareemish panashini, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Akopsha anuritam paratoo yáyaranllu, payuytaranllu, waparish pang' pshtutaa sheeru, Apaa ¿Tamarimta? táyaru, waparsha: ¿Chakshasha shiya? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Akopsha; Esawtana Waatatana nuwaya; iparish putsisariniya. Yuwaa kamachtarangish anoo yuwaparangtandi. Neewa. Chiyzayarush, apinll ningeem kuxineerush, ktungangsi, watam natunaa yuwangaz, Apaa, kamachtarangish anoo zamzee pachayashintandi. Na katungaramchush, nuwaamsha shaanaatsi wizpurish wanasirimshee panangandama, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaaksha wipaa; Itaru, Esawaa, ¿tamasha ashinurisha zamzee pachata sheerush, kanapta sheeshinsha? tárangu; Akoparinsha; Apaa, waana Apanll nuwaam panarangiya. Ashirucha, mikeeruri pachata sheeshinuri, kanapeeshini, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaaksha; Naani; ningeem watsiri xiyangi. Nutsish patateeni. ¿Tamapari shiy Esaweesha ashirush? Nutseetsish patatkachuri, táchachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Akopsha ayu tárangu, waparinung watsiri xiyarangu; Isaaksha wipaa pachtam patatarangu, Mshee, tsiyatkush, Akopshinll kuk tsiyataksha, itaru pachtamshatishcha patatkuri, Esaw pachtam ashitichsha átu, Akoparinsha Aája. Nuwtanda Apaa. Esawtana suri, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Itaru, Isaaksha nda natstarangiya, watam Akopaa pachtam patatarangu, Esaw pachtam tamapari ashiritam patatarangiya. Itaru, ashiritaa yusur tayusarangiya. ¿Kaapaniri zurkush átish? ¿Esawaa, shiy? átu, Akoparinsha, Apaa, nuwcha átana. Nuw Esawtana tárangu, waparsha mapiyrangshita. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Sheeru, Natunaa yuw zamiz pacharangish an mbaseerush, panangandama; katungchima. Na katungaramchuri, anamun shiyaamsha nuwaatsi wizpuriri wanasirimshee panachinllpa, tárangiya. Akoparinsha paratush mbaseeru, payuytaranllu, wapareem panarangiya. Sheeru anumunsha, vinootssha tipayaritam panarangitamta. Isaaksha anoo yáyaru, katungarangiya. Vinootssha waarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sheeru, wipaa Akopaa; Natunaa naansi. Nuwaanaatsi pachipeerush, ishambangandama, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Akoparinsha anuritam ayu átu, waparee pachipeeru, ishambarangiya. Ashkachu, anush wamaree wasipshin ishingarangu, Na psineetsish ishingaranguri, mzatspan ashirush psinish pchazakiya. Ashiriya, na Apanll shiyaa mzareetsish kisshapari napchiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kapung shiyaa istachiya. Waana Aparich sinaa wansipchee ningeem tsapush zanganchiya. Tatsumimarshitish aranginasha wanasir kxunchiya. Ashkachush, zapannaasha pusachsha tirikootsiya, kizarunaatstam wanusiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Uru ashkachush, shiyamari kurak tamapari ashirush taachsha. Shiyangaz tputs zapan kuschinllinaya. Sheersin, shiyaam istaksin, taachinllinaya ichingaroo tsapurnasiya. Mishat, shiyaa kukish kapung payuchinllinaya. Tputsirish zapan taakchusin, shaanaatsi tutunlltayarusin ungirtachinllinaya. Shiyaatsimari urkareem zuwanlleewtamtish ínachinllinaya. Shiyaa tputs yutaritam ínakchu, mantsir tsiyatkachu, waanaatstatamsin tayutaritchinllinaya. Shiyaa wanasiriri chinakchusin, uwshtisin wanasiritam kis taachinllinaya, Isaak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaak wipaam Akoparineem waanaatsi wizpurirni wanasirimshee panam iwatsparamchu, Akopsha waparish pang' shitungpi átu chiyzakchu, anootsiri zoonllsha Esaw zamzee pachayashinu, iriptaranllu kusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kuseeramchu, yuwaa pachayashinu anoo wanasiritam patateeru, kizpuritam kzam paratush mbaseeshinu payuytaranllu, waparish pang' pshtuyaru, Neewa apaa. Natunaa pachayashinina. Ashiriya, apaa, natunaa chiyzayarush ktungansi. Na katungaramchush, nuwaamsha wizpurirish wanasirimash panangandama, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tákamchu, anoo waparsha masharangiya. ¿Shiy chakanaasha? tárangu; wipsha; Apaa, nuwcha Esawtana, waatatana nuwaya; iparish putsisariniya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaaksha anoo mazinarangu, kapung punirustarangu, wanuts ashchiri tatat ashirangu, anshuri tsiyatku, ¿Chakanaa nuwaam ichtakachuri zamzee wanuts patateeru panarangu, nuwshat anoo kizpur kis katungarangina? Ndatuma shiy kuschush, katungeeri; nuwaanaatsisha wizpuriri wanasirimshee panarangshitina. Ashiri natunaa nuwaanaatsi wizpurireetsi panayanllshatana, Isaakarini wipaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esawsha anoo mazinarangu, kapung mangu mantsarangu, tanurangiya. Yuwashuri tanuntaru anshuri kapung tsiyatatar ashirangiya. Apaa, nuwaamsha wizpurirish pananganda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Itaru Isaaksha, Natunaa zuwanlleemish panaranginawa. Mangu nuwaa tamapingarangu, ngichirangu, ashirucha nuwshat anoom mapiyruri, nuwaanaatsi wizpuriri waamsha panarangina, yuwaa shiyaamta panapi tárangi anootsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ashirucha, Esawsha kapung tsiyantarangu zoonllee; Zuwanlli anumashiritcha. Yuwamandaricha ashku anumandaritcha suroo Akop ísamarangashinllinaya, nda yutarit tamapingaku anumandaya. Ichtarumacha ambitam nuwaam ashirangtamta; mangu nuwaa tamapingayaru, Nuwnaa wachinaam kinachima; shiyshat nlluraam kinangcha, átu, nuwaa tamapingarangiya. Natsha in waamaritam apapaa wizpurirni wanasirimshee yusur nuwaa itutseenlliya. Itaru, na apaa, ashiritaa ¿nda nuwaamsha wizpurireetsish panamaam waritak? ¿Mayaamsha nuwaa niyraksha? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaksha; ¿Shiyaam tamaycheezich? Itaru, watacha shiyaam kurakarish ínarangashina, watam nuw táranginawa. Shiyachich maachiritish zuwanlltamtish ichingarusin maachtawaa payuksin taachinllinaya. Mazarish tirikootstam mishat kizarunaatstam zapannaasha pzapanichinllinaya, tárangina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawsha Apaa, ¿mayaamsha ashiksha? Nuwaamsha pananganda wizpurirish. Anumarisha minumari payukish átu, aranginasha kapung tanurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Waparsha wipaa; Uru shiy arap tsap naachsha. Ambiri tsap naayarush taachsha. Amb tsap wanasirimash ndunarcha. Tatsumkush nda wanasir kxoonchiya. ¿Antaati amb sin íwarpich sinakeeja? ndunarcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Shiysha shaanamumtamari wizpurirish shaanaatsi nutsish tapachindakush taachsha. Shiyaa zuwanllimaritish kasiru, shiyaatsimari tumuchchurtachinllinaya. Itaru, shiyshat kizpurtakchush, ndushat zuwanllish shiyaa tumuchchurtachinllinaya, Isaakarini wipaa Esawaa tárangiya. Ashiriya, na kamaneena yuwaa Akoparini waparee wizpurirni zoonllee Esawaa itutseeru waamarisha yarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esawsha zoonllee Akoparinee mangush mantsir chinarangu, tsiyantarangiya; yuwamand waparee wizpurirni waamari itutseeru anumanda. Yuwash wapar Isaakarini tsiparamchu anush Esaw zoonllee pachamaam zandarangiya. Apinll tamapingayaruri, pachapi átu, ");
INSERT INTO cbuNT_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","anoo wanirsha Rebek k'kuzee mazinayaru, wipaatssha Akoparinee kuruzeeru, kamanirangiya. Papcha. Zuwanllish shiyaa pachamaam zandakpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ashirucha, nuw shiyaa kamankina. Yuwaa áti anoo mazinangcha. Arap suwangi yap ziparish taakana; Jaranap tsapu. Labanash taamacha. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ashinumsaja zuwanllish watsiyun pastachiya anush kusangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Yuwaa ashirangish anoo izuuru mapiyramchu, annaapari nuwsha shiyaa kuruzchinlla. Ipari tsimbunari taaksin, nuw mangi kis taakina. Itaru, nuw ipareetsi tsimbunari kanatsipkachinaareena ashiru, uru nuw mangi kapung mantsachina, Rebek tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ashiriya, Rebeksha wazaranllee Isaakaa: ¿Tamaycheezich? Nuw nishucheetsina kiz tayuyana. Esawma nishuchee kiz Hititshuchee yamarangu, nda kaapa iyshat kis taakaniya. Nuw kiyung kachiykina iparimandi Esawamand waminu. Ashirucha, ndusha nishuchee kiz ipareemi Akopaam panamaam zandkina. Wandaya Akop nishucheetsiritam kiz Kanaanshuchee yamakchu, zurampatari nuwnaa taamaam zandakshitazi. Uru nuw mikeeshti tsipachima, Rebek wazaranllee Isaakaa tárangiya. Ashiriya, na kamaneena yuwaa Rebek wipaa Akopaa tusuwapi átu, wazaranllee mangu tamapingarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaaksha wipaa kuruzeeru, wanasir waneerangiya. Nuwaa kuki payukinaareesha ashiru, uru Apanll shiyaa kapungparee istachiya. Shiyaam nishuchee kiz Kanaanshuchee yamamaam watsippari, nuw átana. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Akopaa, shiy piyamanaapari Padán-Aramap tsap yuwash pachirish Bitower taaku anush kuseerush, ziparirtish Laban wip shaanchichitari maachiritish yamachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Wamari Apanllimari kizpurcha. ¿Chakaja waapa tatsamooch? Urutanda shiyaam kapung istakachu, shiy iparish zapan pzapanichish. Ashkachush, tputsirish zapan taachiya; chinllinish tsapurnasish tatsitchiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ashiriya, amb shingcha. Uru ashkachush, Apanll shiyaa kapung chinachiya. Chinllineetstamtish kapungtam chinachtamtaya. Sirútama aparneetsi Aprahamarinee Apanll kapung chinarangu, ambitam shiyaa ashtachiya. Amb sheerush, shaamatarisha tsapunish na yuwash arapich ashiruni msangamari taarini anoo amuytatsha. Watam Apanll aparineemi watsapun panachinllpa táranguwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tárangu, Isaak wipaa zanganirangiya Padán-Aramap tsapu. Akopsha ambiri Labanangaz pangu chinarangiya. Labanarini Bitowercha wipa Amorrewchichi, wanir Rebek wayuchi, wapar washunanda. Ashirucha, wipsha Akop, Esaw ashirusin, Labanaa waziparimunaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","8","Akopsha waparee ayu táyaru, waziparip watsapun naatarangiya. Itaru, Esawsha waparee kuk ichingaru mazinarangiya. Akopaa, piy Padán-Aramap tsap, ziparipish kiz yamashini. Ayamtaatiya Kanaanshuchee kiz yamarinllpa. Ashkachush, Apanll shiyaa istachparee, tárangu anoo mazinaru, mangush chinachintar ashku, ¿Tamakee nuw ashirangi? Nuw nishuchee kiz yamarangina, átu, yusur Aprahamarinchichee wachinllin yamachima, watam apap izanlleetsi nda kis napkanawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ashirucha, Esaw Kanaanshuchee kiz yamarangu anumun yusur minootssha kiz wámindootsi yamarangiya, Ismaela wipa, Aprahamarineetsi wachinllinu, Majalataa suru, Nebayota wizari. Ashiriya, na kamaneena yuwaa Isaak wipaa Akopaa waziparip zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Akoparini Beersebamand tsap shitungeeranllu, Jaranapsha tsap naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Naayaranllu, apus tapeerangiya tputs ndunarishu. Neetsiri maachima, watam tapiyanlluwa, tárangu, patumbichsha tamaru anamun ktuyaru, maarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Maaramchu, anush pamasarangiya. Káringashish tamapari ashiru kanindamand káyashinu, muchunung xum ashirangiya. Anumunsha Apanll wasundurur karuwawtara, kárirtara, karuwawtara ashishtangat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Waanungeetari Apanll waana xixeewu tsiyatstar ashirangiya. Nuw Apanlltana. Pachirinish Aprahamarin, aparish Isaak ashiru Apanllirini. Uru nuw shiyaam, chinllineemtamtish watsapun panachima yuwash na patumbchimun kturush maarish anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Chinllinish pzapanichsha. Chinllineetsish táchimaam pinasachchee. Aship tsap puyumburni taachinllinaya. Tsapunshish tatsitchinllinaya. Shiyaam tsapunish zar yaku amb, zar puku ambtam, zar puwachingaru ambtam, ashpari ichingaru kung ztaru panachinllpa. Ashiriya, nuw shiyamand ichingaroo tputs tsapurunasshuchee, nlluranureemtamtish istachima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mangish mantsarinllpa. Nuw shiyaa ksutatandi. Nda kasachinllpa yap naakchish ambi. Uru ningitam tsap kanapuchsha. Yuwaa nuw shiyaa áti anoo uru tatsamchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Apanll ántaru, Akopsha támaranllu, kapung punirangiya. ¿Tamaa nee tsap Apanllti taárashi? Napangi ashkuya. Apanllpa waana nee tsapoo ksutkiya. Waana amuy nish taarpari. Nuw nda yasaranguri, nee tsap maayarina. In Apanllpari panguya. Nduntaati ashiru, kanindpari wach nipa tasasariya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Putamsha tarasitaranllu, Akop chiyzayaru, yuwamun patumbich kturu maarangu anoo ichizayaru, wayungunpasha ichumayaru, Apanlleemsha wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ashiriya, yuwash Apanllee wasundurur Akoparin pamasarangu anoo sirútama tsap sur Lus átaranaya. Akopsha anoo tsap nllitarisha Betelaa átsha ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Sheeru, Akoparin tárangshita; Natunaa Apanll nuwaa zurampatarishapari ksuchindanaya, yap naakchi anootstam napchindanaya, katungsheemtamti, kamareemtamti panachapandanaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Amb naakchuri, matambshiritamti apapap pang' kanapchina. Apanll nuwaa kaapa istakchinaari ashiru, nuwshaparee Apanllee zurampatarisha chinachshaparina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ashiriya, natunaa nee patumbchee urutamarishapari Apanlleem taárash ísamachina. Natunaa nuwaam Apanll maacheetsi panakchu, nuwshat anchich chungarneetsi minamtam yáyaruri, Apanlleem panachina, tárangiya. Ashiriya, na kamaneena yuwaa Akoparini Apanllee wasundurur pamasarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Akoparin naayaranllu, yapsha zar yaku amb tsap kusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Tsap puripuritaru anush kungsha pos wakar waashini taaru parangiya. Anushsha tuchip tputs chinuzpan chinuritam, chinuritam ashirusin, tuchip wanir ishinaranganaya. Anushsha posoo wachoo patumbichpa kayakpa shtandam kasarangana. Ashirucha, posoo minumtanaarich wachoo tawateeruch, kungoo waamaam pinasamuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Opeejaam yásimaam zandkatssin, ashparitssin ksutamapan washunand mapuyarusin, tawateersin, opeejaam yásiranganaya. Sheersin, opeejaam yásim iwatsparmatssin, yusursha washtam wachoo shtandayarusin, kasataranaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ashiriya, Akopsha yap chinuzpan ksutamapan shaneerana amb iriptaranllu, kuseeru, Zuwaa, ¿yapsha in tsap shanee ashtarsa? tárangiya. Uwshtisin, In tsap Jarancha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Akopsha yusur masharangiya. Zuwaa, siy ichee Labanaa paktaatis, Nahorarinee wachinllinu, tárangu, uwshtisin, Aája, paktanicha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tárangusin, Akopsha, ¿Tamaru zipari taaka? ¿Matambish? ¿Kas yutakeezuwa? tárangiya. Uwshtisin: Nduni zuwaa. Matambishtanda taaku. Wipsha Rakel nishutamtanda. Anuwa, piy opeejarinpatini naanllina, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ashiriya, Akopsha apinll mashamashtar ashirangiya. ¿Tamara nda naturi posoreetsis tawatamaam waritak? watam naturitana zar yuwaritawa. Annaapari tawateerus, chineemis opeejareemis yásim iwaparamchus, martamamaamsha machitssa. Watam naturitana zar watandpunish tapshtumaam pishtarimanda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Itaru uwshtisin: Nda, zuwaa. Wandari zar pishtariya yásimaama, watam iy uru kutakaniya ichingaruni chinuzpanni. Ashparitani kusataramchuni, ancha washunand yapandaychuni, kungoo tawateechuni, chineemani yáskini, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Akop yuwaa tsiyatkusin, ántarana anoo Rakelsha káyashinu, chinpat washunand shurangakatan ashiranganaya. Ansha Rakel anshutam wapar opeejarini ksutku taarangiya. Ashirucha, anush kuseeramchu, ");
INSERT INTO cbuNT_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Akopsha waziparee Labanaa chin opeeja parangu, uwshat posoo mikeeru patumbchee tawatarangiya. Tawateeru, opeejaam yásirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yásiramchu, Rakelaatssha pachipeeru, ishambarangiya. Sheeru, tanurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Akopsha waanaatsi kamanirangiya. Nuw Rebektana wipi, Laban wizari. Nuw Labanaa zipartana, tárangiya. Ashirucha, Rakelsha anoo mazinarangu, waparee kamaniti átu, iripurangiya. Waparee ashpari kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ashiriya, Labansha anoo mazinarangu, ¿Tamaa nuwaanaati izari wipa? átu, káyaranllu, pusap iriptaranllu, chamayangarangiya. Ansha wizaree wip paranllu, paxaneeru ishambarangiya. Sheeru, Pzaya. Nuwap pangi naayani, táyaru, pangupsha machirangiya. Akopsha anush waziparish pang' kuseeru, ");
INSERT INTO cbuNT_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labansha, Nuw zuwaa, shiyapa kapunguritanda maachiritani, watam shiyaa nuwaana izari wipawa, tárangiya. Ashiriya, na kamaneena yuwaa Akoparin waziparish watsapun kusarangu anootsi. Akoparinsha waziparish Labanash minum tsup taaramchu, ");
INSERT INTO cbuNT_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labansha, Akopaa, shiy nuwaa maachiritaateesha, ¿tamareeja nuwaam mangutaritish tarawaztachish? Ashiri shiyshat nuwaa itsinsarush kamaningandama. ¿Wanip shiyaam tuwapchinlla? ¿Mayaa zandaksha? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Anpursha Laban wip kiz tsimbun kamasinanand taarangiya. Iwachiztamarni sur Liya, anumunsha Rakela. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Anshat Liy wachumari kizpur wanasirimuna. Itaru, wanuts pakich ungshimuna. Rakelshat uwshat kizpur wanasirimuna; ashchiri wanuts ichingaru wanasirimuna. Nda pakchiyam pishtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ashirucha, Akopsha Rakelaa chinarangu, kapung zandeeru, yamapi átu wazipareetssha itsinsayaru, masharangiya. Ichee, ¿nuwcha shiyaa iparish shipamunchee yamamaam zandkashina? Anoo shiy ¿amaksha? Ambinaapari sheeruri, shiyaam mangutariti tsimbun matayaru masach tarawaz istachinlla, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labansha: Zuwaa, zuraktishcha. Ambinaacha sheerush wanasiriya. Watam shiyaam kiz nxakumutana panamaam nduniwa. Shiy yaanpatatanacha yamakush, wanasiriya. Shaana zandkeesha, amb shingsiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Rakel wamin tsimbun matayaru masach mangutari tarawaztaku, waziparish taarangiya. Rakelaa kizpur zandeeru, kissha tarawaztarangiya. Uwaam minamaripaz tsup ashiru nda tácharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ansha Akop tsimbun matayaru masach tarawaztachu, waziparee masharangiya. Ichee, natunaa iparish izanlleemarishti yamachima, watam natunaa yuwaa tárangini anoo ashpari tatsameenawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labansha, Zuraktishcha. Natunaa izanlleemarishtish panachinllpa, tárangu, ashpari tiptsiree kuruzeeru, tushaneerangiya. Anushsha, shaneersin, zamamtarusin, tapitaranll ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Annacha tapeeramchu, anush Laban wipaa yamayashinu, Akopaam tupanayaru kasarangiya. Akopsha mapiyru anpa kizapa maarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Sheeru, anumun Silpaatssha Liyaam muchchur panarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ansha Akop mapiyru maaranllu, putamsha tarasitaranllu, támeeru, Liysha wiramash tamuru parangiya. Ashirucha, Akop kapung tsiyantarangu, wazipareetssha Labanaa, ¿Ameerush nuwaa amb ashirangsha? Ngutish nuwaa tamapingarangish, watam Rakelangaz wamin yamapi túri, kapung tarawaztaranginawa. Itaru, na shiyshat minootssha iparish putsisarineetssha nuwaam panarangsha, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labansha: Zuwaa, zurmana zuraktishcha. Itaru, iyashuch yámash nllitaritamcha. Iyashuch chtarima wipaa iwachiztamaatsima panatariya. Ancha sheeru, shipamuncheetssha panatariya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ashiriya, wandaya iparingazi Rakelangaz zandkush, Liyaamma minum siman michinuz tushiynimani. Ashiramchush, anamun yusur Rakelaatssha yamachsha. Itaru sheerush, yusur nuwash tsimbunatam matayaru masach mangutaritish tarawaztachsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Akopsha, ¿Tamaycheezi? Ashiri waritachpari, ichee, tárangiya. Táyaru, Liyaamma minum siman michinuz itupshiyngarangiya. Ashiramchu, yusur Laban minootssha wip shipamunchee Rakelaa Akopaamtam panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Anamun yusur Bilhaatssha Rakelaam muchchur panarangitamta, waama wipunasheema. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Akopsha Rakelaatssha wizanlleem yamarangiya. Rakelaa Liyamand kasiru kapung chinarangiya. Liyaatssha nda kaapa ashirangiya. Ashirucha, Rakel wamin yusur Akoparini tsimbunatam matayaru masach tarawaztarangiya. Zapan masach waziparish taarangiya. Ashiriya, na kamaneena yuwaa Akoparini waziparee wip munpatari íparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Apanllsha yuwaa Akop wizanllee ichtamaa Liyaa nda kaapa chinarangu anoo parangu, Liyaam kapung istarangiya. Liysha wip zapan pzapaneerangiya. Itaru, Rakelsha mipish taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ashirucha, Liyamarisha nlluraa mireeyaru, kamuzaa tatsipurangshita. Sheeru, wipaa sur Ruben ísamarangiya. Na Apanllpari yuwaa mangi mantsaki anoo parangu, ipareemi panarangandanaya. Na nimunanaa zaranlli nuwaa chinachshapari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Liy yusur tsimbunarinsha wip wanindarangiya. Iparinayaru, wipaa kamuzaatstam sur Simeón ísamarangiya. Apanllpari yusur pakeendanaya yuwaa zaranlli nuwaanaatsi kaapa nda chinaku anootsiya. Napangi ipari yusur arang wanindayanlluya, tárangu, kapung mang' ksarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Liy yusur arang wip tuchparinsha wanindarangiya. Anootssha wip kamuztam sur Leviy, ísamarangiya. Sheeru, Natunaa zaranlli nuwaanaatstamarishapa kapung chinachindanaya, watam ipari tuchipsha na wanindayanlluwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yusur Liyatam wip ipunpunarinsha wanindarangiya. Anootssha kamuztam wip sur Utaá ísamarangiya. Liy, Natunaa Apanllee kapungshapari ungirtachina, tárangiya. Anumunarisha Liy mipsheerangshita. Ashiriya, na kamaneena yuwaa Liy zapan iparinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakelsha mipish taarangu, Akopaa wip nda minumtiyam iparinarangiya. Ashirucha, kapung tsiyantarangiya. Watam munaatssha parangu, Liyamarisha wip pzapaneeyaranlluwa. Ashirucha, wazaranlleetssha: ¿Tamasha nuwaamsha ipari nda tinaksha? Nduniya nuw iparinakuri, papcha, nuw tsipakchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Itaru, Akopsha anoo mazinarangu, wizanllee kapung tsiyantarangu, ¿Antaati nuw Apanlleezi? shiyaa nuw mipsheem ínayarunll kasacheena ashiru, mang Akoparinsha tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rakelsha: Watam nuwaantana iparinay túri xapookinawa. Ashiri nuwaanaa yanungamari Bilha sur m'chachurirti panachinllpa. Shiyshat m'chachureetsi yamayarush, anpasha maakchush, m'chachurshiti iparinachiya. Ashkachu, nuwaanapaz iparinayaruri ashtachina. Ambinaapari sheeruch, ipareemich pzapanichchee, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Amb tárangu, Rakelarini muchchuree Bilha wazaranlleemsha panarangiya. Akoparinsha anuritam wizanlleemarisha yamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilharin nlluraa yáyaru mireerangshita. Akoparinee wip kamuzaa tatsipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rakelsha mang anoo nlluraa parangu, kizpur mang' ksarangiya. Nee nllura sur Dan átu ísamachima. Watam nuw kapung mangi mantsaranguri, Apanllpa kapung masharanguri anoo mazinarangu, nuwaam ipareemi minum panarangu, natunaa tatsameenlliya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Anamun Bilha, yusur wipaa kamuz tatsipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rakelsha yusur anoo nlluraa parangu; Na neetssha nlluraa sur Neftaliy, átsha ísamachima. Watam sirú nuwaa pamunimasi kasirangu, itaru natsha nuwshat tsimbun iparinaranguri, na nuwshat pamuneetsi kasiyana. Apanllpari waana nuwaa kapung istarangiya, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ashiriya, Liysha uwsha mipsheem kinarangiya. Ndusha arang iparinarangiya. ¿Tamaycheezi? ¿Nda mireekinawa? Ashiri nuwaana m'chachuri panachima, tárangu, muchchuree Silpa wazaranlleem panarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Akoparinsha wizanlleem muchchur Silpaa yamarangu, Silparinsha nlluraa mikeeru mireeyaru, Akoparineets wip iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liysha anoo nlluraa parangu, kizpur shambatarangiya. Yungpartand m'chachureetsi panarangi. Ashiriya, suru Gad átu ísamachima, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Yusur Silparini kamuzaatsha tsimbunarinshitini iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Anootssha Liyarin yusur parangu, Ichingarupsinaya na nuwamun kizaptatini yasayanllinaya. Kapungpari mang' ksakiya átpasinaya. Na nlluraa sur Aser átu ísamachima, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Minushsha zar Ruben Liy wip mzatsip tirikungaz wanus pusakatu naatarangiya. Ansha mzatsip naayaranllu, maachtaatssha karuta wiparirpanee sur mandrágora parangiya. Ashirucha, Rubensha anoo parangu, atataama átu, xpurangiya. Xpuyaranllu wanireemsha payuwtu yushindarangiya. Rakelsha anoo parangu, Nuwaamsha apchee, anchich pakich pananda, yuw iparish yushindarangu anootsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liysha: ¿Tamaa Rakelaa, shiy anumashiritishtee? Chtaru zaranlleetsimasi itutsirangush, na yusur ipareetshiti mandrágorarini itutsimaam zandaksha, tárangiya. Rakelsha anootsina: Zuraktishcha. Itaru, waanari iparish mandrágorarini nuwaam panakchush, uru na zar shiyma zaranllpati Akoppa maachsha. Putsha zar nuwashsha maachiya. Pzaa. Ambinaa sheeruni, yachayani, tárangiya Rakelarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ashiriya, anshat Akoparini mang mzatsip xitarangu, zar tapitaranllsha kanapeeshinu, Liysha paranllu, chiyzaranllu, Akopaa, na in zar shiy nuwapashatanda maachish. Watam Rakel ipareetsi mandrágorarini yáyanlluwa. Ashirutanda, anpat istayarini. Ambtanda sheeni, tárangiya. Ashirucha, Akoparini anuritam ayu tárangu, Liyashsha maarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Liysha nlluraa yáyaru, mireerangshita. Akoparineetsi wip kamuz zameeturinshitini iparinarangiya. Watam kapung mang' mantsarangu Apanllee masharanguwa. Apanllsha anoo mazinarangu, kapung Liyarineemi istarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ashirucha, Liyarini: Apanllpari nuwaa nayniyanllindanaya. Watam zaranlleemi nuwaanaatsi muchchuri panaranginawa. Na nee ipareetsi sur Isaakar átu ísamachima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Anamun Liy yusur Akopaa wip kamuzatam iparinarangiya. Anpat washunand minum matayaru wip taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Anootssha Liy: Apanllpari ipareemi yusur mangutari panayandanaya. Natunaa zaranlli nuwaatsimarishapa kapung chinaku taachiya. Na ipareetsi sur Sabulón átsha ísamachima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sheeru, Liy yusur yuwaamanaarisha tspakamchu anumun wipaa kiz Dina sur iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Itaru, Apanll Rakelaa nda mbizarangiya. Yuwaa mipish taarangu anoo parangu, wip wanindamaam istarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ashirangu, Rakel wip kamuz minum wanindarangiya. Iparnaramchu tárangiya; Apanllpari nuwaa pazitpa átu, ipareemi panayandanaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Na ipareetsi sur, Osiyaa átu ísamachima, yusur Apanll arang ipareemi panamaama, tárangiya. Ashiriya, na kamaneena yuwaa Akoparin wip pzapaneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rakelsha Osiyaa iparinachu anamun, Akoparini Labanaa: Natunaa ichee, naamachima. Kasangandama. Nuwaanpeetam tsapuni kanapchima. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ipareetstamtish, chinllineewaatstamtish ashpari machkachima, watam izanllimandinaari shiyash zapan zar tarawaztaranginawa. ¿Tamaru nuw shiyaam tarawaztarangina? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Itaru, Labansha: Nda zuwaa. Musá naarinllpa. Nishurtama nuwashuri taangimasi. Na yuwaa tuwachirangi anoo yasayana. Apanll shiyaam kapung istamaam zandkiya. Shiyamand kaminish nuwaamtam istachindanaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Shiyshat nuwaa itsinsarush, kamaningandama. Nuwash yusur tarawaztakchinaareesha ashiru, anumand nuw shiyaam wanipaja tuwapachinll, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Akoparinsha: Shiy ichee, nuwaa parangsha. ¿Tamaru nuw shiyaam tarawaztarangina? ¿Tamaru nuw shiyaa chinish ksutarangina? ");
INSERT INTO cbuNT_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ndatumaa nuw shiyash kuschuri, shiy maachiritish pakchim payurangsha. Itaru, natsha shiy maachiritish zapansha payuksha. Apanllpari shiyaam kapung istarangiya. Nuwaamatsha pakich putapi túri tarawaztamaam zandkitamana ipareemtamti, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labansha: Zuwaa, zuraksha. Itaru, wanipaja tuwapachinll átana, tárangiya. Akopsha: Nda ichee. Nuwaam kurikpa tuwapariyshpa. Ayu tinaareesha, yusur opeejareetstamtish ksutchima. Yuwaa áti anoo mazinangcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nuwaa opeejpim taárash zanganingandama. Yuwamari mantsiririni anumari nuw ipuseeruri, karupanaw upapchireew kantsirpeewa, minllur tuwapeewa nda ashku marapaparu anu, mishat, kaapra yuwarnitamani minllur tuwapeew marapaparu anumaritam nuw ipuseeruri yamachima yuwamand ksutki anumanda. Ambimari ashkuri, nuw shiyash tarawaztakuri taachima. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Amb ashtachima. Shaanasha yuwash zandkachish anush kuseerush, napachsha. Nda shuchichima. Tamapari nuw shuchikcheena ashiru, shaana napkush, yuw shuchiyari an wanasireewsha minllur ndunareewsha mbursheew pangachsha. Wandaya ashima pakchush, nuwaa ¿Mayaamsha shuchiksha? tángandama, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labansha: Waritacha. Amb shingsi, watam shaana átshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Itaru, Laban anuritam zar ndaturi Akopaa chinuzeem ksutamaam zanganiru, mang wasina wipaa kamachtarangiya. Shiy wasina kaapraa, opeejaatstam upapchireew, yuwanandari yutaritarini kantsirpeewa, wayandar isingukuru minllur tuwapeew machin pur mbursheew taaru anpatari shiy ipuseerush, wasina piyamaritam ksutamachcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tárangu, Laban Akopaa arap wanlliteeru, wipaa minupsha pasut zanganirangiya. Yuwamand Akop ksutku taaru anumand arapirini tuchip zar naakich anush, Laban wip waanitaritam ksutku taarangiya. Itaru, Akopsha waanitaritam Labanaatstam chin ksutku taarangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Akopsha mangush chinarangu, yasinaa kamachpamashee pizawaa wareerangiya. Yasin mburash kantsirap yapandayaru, tangateeru, pamaama átu pashuchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Anootssha yáyaru, yuwash opeej kungoo waamaam kusatkana anush pashuchu pashuchu sheeru kasarangiya, yuwash upapchir wizarpa kusateersin yangakana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ashirucha mang, opeejsha anpat yasinpa tasasaru yangarangusin, wipsha ambiritam yasinap yarangu marapaparsha kantsirpeewsha iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Amb ashiramchu, Akop opeeja wip tapuseeru, yuwandari kantsirpeew marapaparu annandtari waanitam piyam waama chin xanatarangiya. Amb sheeru, Akop waamataritamsha pastureemani wayayaru, watandpuneemaritam tandapunayaru, anush chinoo xanateeru kasarangiya. Labanaa watandpun wanlliteeshta. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ashirucha mang, Akopsha anuri mangush chinarangu, kaapra wizar wanuts kapung kuratam kuskachu, upapchirsha yangakchu, anoo uwshat paru yasinaa piz tupzitangamaa yáta, sheeru yap yangakchinllina amb tasingayaru, pashucheeru kasatariya, waani nee yangaksin pangpana átu. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Itaru, kaapra xangitamawsha kuskatssin, anumuna yasina piz tupzitangamaa nda pashuchtariya. Ashirucha, ashirangu yuw wanuts xangitamawa anoo Labanaamaritam panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ashirucha, Akop amb ashirangu, yuwshat wanuts kapungunanda anootssha Akop waama chin yamarangiya. Kurkirpaneemsha kinarangiya. Chin zapansha taarangiya. Opeejatam, kameechutam, burrutam, muchchurtam, muchchureewatam kizaw taarangtamta. Ashiriya, na kamaneena yuwaa Akoparin yusur waziparish tarawaztarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Labansha wip kamuz tputsee tsiyatarangu; Na Akop kurikpan taakiya. Maachiri zapanshita. Itaru, anoo ichingaru apapanandari maachirita, tát tát ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Akopsha anoo mazinarangu, Nuwaa ngusiri nizikpaz ashkiya. Watam sirú nuwaa kapung chinatariya. Itaru, na ndusha ashiru chinakiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Apanllsha: Akopaa; Shaanpeetam tsapunish kanapungi yap shaana maachiritish taakana ambi. Nuw shiyaam kapung istachinllpa, Apanll tárangu, Akopsha; Ayu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Akopsha wizanllee tsimbunarta kuruzurangiya, yapiri opeejarini ksutku taarangu ambirita. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Anushsha wizanll kusarangsin, wizanllee tsiyatarangu; Izanllee, aparish sirútama nuwaa kapung chinatariya. Itaru, na ndunsha chinakiya; napakshita. Ashkitaa aparish, itaru Apanllsha nuwaa urutamari ksutkiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Siy yasaksa yuwaa nuw aparshish tarawaztaki anootsi. Nda apareetsish kuk kapeetarangina. Mangi ksaptari tarawaztakina. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ashkitaati anoo, aparshitish nuwaam xarashish wayakiya. Yuwaa tarawaztaki anoo mantsir tuwapamaam zandkiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Aparish waana mangush chinarangu, Yuw chinuz yutaritarini tatsipkachu, yuw pur kantsirpamasheewa an shaama yamangcha yuwamand tarawaztakchish anumanda, tárangiya. Itaru, chinuzsha iparinaku, ichingaru pur kantsirpinand minllur tuwapinand iparnarangiya. Ashirucha, anootssha parangu, yusur nuwaa tsiyatarangiya: Na nimun yuwanandarisha pur isingukuru annandarisha ipuseerush shaama yamangcha yuwamand tarawaztakish anumanda, tárangu, yusur chinuz pur isingumanandsha iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Apanll waana nuwaam kapung istaku ashirangiya. Apareetsis chinoo itutseeru, nuwaamsha chineemi zapan panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Yuwapur chinuz sirútama ichingaru kuratarangu anpur pamasaranguri, kaapar upapchir wizaree yangaranganaya. Ichingaru wip isingumanandari, minllur tuwapinandari, kantsirpinandari ashiru tatsipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Anshuritam yuwash pamaski anush Apanllsha wasundurur nuwaa kuruzurangu, Akopaa, tárangu, nuwshat; ¿Maya? tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Uwshat; Akopaa, nuwaa kuki mazinangandama. Nuw shiyaa parangina yuwaa Laban shiyaa kiyung yachaku anootsi. Na nimun kaapar ichingaru isingumanand, kantsirpinand, minllur tuwapinand wizaree yangachinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nuw Apanlltana. Zurampatari shiyaa atina. Nuw waatatana yuw shiyapa Betelash tsap tsiyatarangani antana; yuwapur shiy patumbchimun kzammashpa tapararangush, anush nuwapasha zurmaptari tsiyatarangani antana. Ashiriya, na nee tsap kasayarush, wapitam tsapunpitamtish kanapungi yapitam nllurtarangish ambitamta, nuwaa tárangiya. Ántar, Akoparini wizanllee kamanku ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Wizanllshitisin; Natunaa átish anoo mazinaktanicha. Watam na iyaam apap maacheetsi panamaam wanindshitaja. ¿Apapaam mayaamaja kutachini? Pzaya, átush waritacha. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","¿Watam apap iyaa tunareepaz ashisha, arapeetarisha napkuwa? ¡Shiy iyaa yamarangus, apapsha iyaa maacheetsipaz ashiru tarawaz wamin tupaxanxarangiya! Itaru, iyamand kamini apapaam tuwapamaam tarawaztarangush, na tputseemsha chinoo tuchingarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Itaru, iyaatssha Apanll ¿tamaranga? Kizpur wanasirimash iyaam istarangiya. Apapaa maachiri itutseeru shiyaam panarangiya. Ipareemtamani panarangitamta. Ashirupa, Apanll waana shiyaa parangu tsiyatarangiya, wizanll táranganaya. Ashiriya, na kamaneena yuwaa Akoparin waziparee watsapun shitungamaam zandarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Akoparinsha wapitam waparip Isaakap watsapun kanapunlli, átu, ichingaru maachiritaa ashpari xanatarangiya. Wizanllsha ashparitam, wip ashparitam, kameechumun ush tuchipayaranllu, Padán-Aramash tsap shitungeeranllu, yuwaatstam tarawzumand putarangu anootstam ashpari chinu machtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Itaru, anushsha zar Laban pangoo shitungeeranllu, chinuzipsha opeejaa pur kturkatu naatarangiya. Ashirucha, waanisha Rakel pangusish kurimunazish pshtuyaru, waparee apanllputsirini tinamaa payuku anoo shuchirangiya. Itaru, Akoparinsha anoo nda yasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Naamaam yareersin, Akoparini ungsiree kukshari tsiyatsshari naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ashirucha, maachiritaa ashpari ichingeerandsin, apus kung sur Eufratis taaru anoo kiteerandsin, aranginasha naataranganaya, yap mach sur Galaad taarangu ambshita. Ashiriya, na kamaneena yuwaa Akoparini Padán-Aramash tsap shitungarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mang, tuchparinshini zar tushiyramchu anush Laban tsiyatssee mazinarangiya yuwaa ungsir Akop naayaranllu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ashiriya, uwshtisin káyarandsin, tachitaranganaya. Ichingaru tiptsirtam, maachiritam kutaranganaya. Sheerandsin, yap Akop naayaranllina amb tachitaranganaya. Apusari tsimbun matayaru zar maamatanusin, anush mach sur Galaadash kamataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ndatuma kamatchu, apus maarangu, anush Laban Apanllee pamasarangiya. Apanll waana tsiyatku, Labanaa, kaapa zapaninaa Akopaa nambinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ashiriya, ansha Akoparin ichingaru tiptsirpat, wachinllinutam ashparitssin apus machish Galaadash tsap kanuskamchusin, anush Labansha wasundurpatari kamataranganaya. Anushutam kanusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Anshurisha shaniyeeramchusin, Labansha Akopaa tsiyatarangiya. Akopaa, ¿mayaamsha shiy nuwaa amb ashirangsha? Ngutish nuwaa tamapingarangish. Arangirisha nuwaa tsiyatsshari ipareetsi isuwambeeranllish. Tputs kpachamash ashiru ipareetsi putayaranllush isuwambeeranllish. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Shiy nda nuwaa pakchiyam tsiyatarangsha. Waanari shiy nuwaa kamanirangush, nuw anuritam yasaranguri, maya, nuw shiyaam wanasir tsiyateeri kasamaam taariya. Shaniyeeruni, natum shiyapa michteenee, aturi, uru kapusis wayayaruni, shambateeni. Shambatkuni, tamburtataruni, tiruchiruchtaranguni, natunaa naangsi, táchima, táranguri, shiyshat arangiri suwarangsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ipareetstamti wanasir tsiyateeruri, ishambeeri, chinllineetstamti pachipeeruri, ishambeeruri, kasamaam taariya. Itaru, nuwshat ipareetsi, chinllineetstamti nda pakchiyam tsiyateeri, nda ishambaruri, ¿tamari kasachee? Tputs mang' ndunar tamaparee ashirangsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nuw siyaa waanari wanimaam zandkuri, ashparitaatsis nuw siyaa kamirana kiyung yachamaama. Itaru, nuwsha pamasaranguri, miranish Apanll nuwaa; Labanaa, k'keetsi mazinangcha. Kaapana kapung nambinllpa, tárangu, nuwsha anuritam payukina. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Itaru, shiysha Akopaa, mikeerus tsapuningazish zandarangush, kanapurangsha aparpish watsapuni. Itaru, amb ashkush, nuwaatssha apanllputsiri shuchirangsha, Laban tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","32","Itaru, Akopsha nda yasarangiya yuwaa wizanll Rakel apanllputsee shuchirangu anootsi. Ashirucha, Akopsha, ¡Antaati nuw shiyaa maachiritish shuchirangeezi! Natu nachungangsi. Payurim pakchush, pachamari pachayarush, ksangcha. Paranllimsin, ashiri shiyshat, Neewa, ¿yapimta yuw nuwaa apanllputsiri shuchirangis anu? táchsha. Tákchush, nuwshat yuwaa shuchirangi anoo, Ashiri neewa, yanpungsi, táyaruri, uru shaamatam tuwanpuchina. Nish tputs ichingurusin wach parsin, ¿kamapari, Neewa. In watach shiy shuchirangish? táchsha. Itaru, nuw shiyaa punikuri, kamapshikuri suwarangina, watam shaanaatstari iparish yanpumaam zandakshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labansha; Ashiriya, nachungachima, tárangu, Akopash watambur pshtuyaru, nachungarangiya. Liyashsha watambur pshtuyaru, nachungarangitamta. Muchchurim tsimbun maachiru parangiya. Sheeru, naxpoorangu, yusur shitungeeru, Rakelapsha watambur pshturangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Itaru, Rakelsha yuwaa apanllputsee shuchirangu anoo, chinush kameechush watsirar wantsush pishurangiya. Sheeru, anamun iwaz mang kuxinxinaw ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakelsha mang waparee tárangiya; Apaa, nuwaatsina tsiyantariyshpa, apaa. Kizich tamatarpachi wanguytaranguri, nuwnaa chiyzamaam pinasakina; mang waparee tárangiya. Ashirucha, Labansha, nachungaku, xapoorangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Akopsha kapung tsiyantarangiya. ¿Natuwa? Na ¿apanllputsireetsish yanpuyanllish? Natu nuwaam yámandanda. Watam shiy anungaz nuwaa tachitarangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nuwash maachiriti nachungarangsha. Natu nee wayangi. Ichingarusin tputsirish pamaama. Nuwatam tputsiri ichingaritamsin yasamaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nuw shiyash wanip masach tarawaztarangina. ¿Ndusha 20 masach tarawaztayaranllee? Nda minumtiyam opeej wipaa kapirangiya. ¿Antaati chineetsish minamtiyam katungarangeezi? ");
INSERT INTO cbuNT_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Manginshuch chineetsish zakchu, nuwaanaatsisha opeejari tuwanpurangurina. Chinish wipaw tsipakchu, shiyshat nuwaatsimarisha tapshiyarush nambtarsha. Natu tuwapanda, átarsha. Nuwshat anuritam; Ayu, aturi tuwapatarina. Shiy ichingaru nuwaa tuwapanda átarsha. Ambiri ashkuri, shiyash taarangina 20 masachi. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Wanip zar shiyaa chinish ksutkuri kiyung kachiyarangina. Psaantam ksutataw ashkuri, kachizamun tsipamaam pshatarangina. Maats ksata ksutataw ashtarina. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Shiyaam tarawaz kapung m'chateeraana. Iparimandish wamin tsimbunari, washunand 14 masach tarawaztarangina. Chineemshitish ksutkuri minum matayaru masach tarawaztarangitamana. Ambtaa ashiranguri, shiyshat nuwaam mantsir tuwaparangsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Itaru, Aparich yuwarpich nuwaa pachiri Aprahamarinee kizpur chinataru, mishat apapaatstam Isaaka kizpur ksutaru anu nuwaa zanganirangu, uru nuwaa kapung ksutkitamta. Waana Apanll yuwaa tarawaztakuri, psaan kiyung kachiyki anoo paranguwa. Itaru, ambtaa ashiranguri, na mangutaritamti maachiriti ndunar kanapeeraana. Ashirucha, anoo Apanll parangu, na in psaan shiyaa waneerangiya, Akoparini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labansha, Zuraksha. Izanllish tsimbunari nuwaanandari iparina; iparish nuwaanandaritam chinllinina. Chineemshitish nuwashtam yamarangsha. Ashirucha, nuw shiyaa kizpur wanimaam waritaktaati, ashiritaa chinllineetsi nayanikuri, nda ashkina. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ashirucha, nuw shiyaa, Akopaa, táshina; Nda nuwapa natsamaam wanasir tsiyatssis zurampatari, Apanllimun sur yareeni, nuw shiyaa atina, Laban tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ashiriya, Akoparinshitin anuritam, Ayu. Ashiri amb sheeni, tárangiya. Patumbchee yáyaru tunuxinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Tiptsireetssha kamachtarangiya; Natu, patumbich yáyarus xanatangints, tárangiya. Tiptsirsha anuritam, Ayu, tusin, patumbchee yáyarusin, wanasir taturpiyarusin, xanateersin, anumun katungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labansha patumbchee taturpima sur waanshuchish kuk ísamarangiya Jegar-Sahadutá átu. Akopsha, uwshat wanshutam kuk Galaad átu ísamarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Wandaritam anoo tsap Galaad atanaya. Labansha, Ashiriya, watacha na patumbchimun xanateerni anamun shaniykuni, na ¿mayaamaja yutaritshishee chinachich? Wanasir tsiyatssis na yareeniya, táyaru, ");
INSERT INTO cbuNT_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","yusur Laban anootssha tsap sur Mispa átsha ísamarangiya. Watam táranguwa. Na arapeew kasambkachiniwa. Itaru, arapeewtaati kasakchuni, Apanll waana iyaa pariya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ipareetsi kizaa tsimbunari wanasir ksutangcha. Ipareetsi natsariyshpa. Minootsshat kiz yamarinllpa. Mangishish chinangcha, watam Apanll waana iyaa paruwa. Nduntaati tputs nuwaa kamankusin, watam Apanllsha yuwaa ashkich anoo yasaruwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Mishat, Akopaa, ¿mayaama piy shimbayaruni, na wanasir patumbchimun kuxineeruni tsiyatkini? ¿Anoo mayaamaja mbizachinee? ");
INSERT INTO cbuNT_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Patumbchee xanateerni, anumandaritam arangiri shiy naatacha. Shiyshat mbizarinlltampa, nuwsha waatatamta nduntam mbizachima. Na nimunarishat nuw shiyaa tayutaritcheezi, shiysha nuwaa nduntam muntachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Watam yaanaa Apanllirini paruwa, yuwaa Apanll shiy pachirish Aprahamarini kizpur chinarangu, nuw pachirini Nahor kizpuritam chinarangu anu iyaa yasakiya, Labanarini tsiyatku ántar ashirangiya. Ashirucha, anuritam Akoparinsha, Zuraktishcha. Watam Apanll waana yuwaa apari Isaak chinaku an paru, zurampatari shiyapa wanasir tsiyataranganiwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Táyaru, wanasir itsinsaru Apanllimun suru tsiyatarangiya. Sheeru, chinuzeetsshat pachayarusin, machip káreersin, ambiri ashparitssin katungaranganaya. Sheersin, anootsiri maaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Maayarusin, putamshat wipaa pachipeeru, wachinllinootstam pachipeeru, ishambarangiya. Sheeranllu, waptam watsapuniptam kanapurangiya. Ashiriya, na kamaneena yuwaa Akoparini tsiyatssee yararangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Akoparinsha naatarangiya. Kanaanap ngoots naatarangu, Apanllee wasundurur zapan chamayangarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Akoparinsha; Nee tsap Apanllpari wasundurur taárashiya, tárangu anoo tsap sur Maanayim átu ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Anumunsha iwaz, Akoparini zoonlleem tsiyatssee tputsish wasina zanganirangiya. Anpur Esaw waanpee watsapun Seirash taarangiya Edomap tsapu. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Akop tsiyatssee kamachtaku zoonlleem tárangiya. Zuwanlleetsi Esawaa pakchush, Zuwanllish Akop na ningitam naanlliya. Ziparishish Labanash taarangu na kasarangiya, tángcha. Shiyaatsimari kukish payumaam zandkiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Maachiri zapan chin payuriya: wakar, burru, opeeja, ichinguru payukiya, tiptsirtam zapani, kizatam, kamuzawtamta. Nuwaanaatsi wanasir napanda aturi, tsiyatsis wasina zangankina, átcha tángcha, Akop kamachtaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Táyaru, tiptsirsha tsiyatssee kamaneeshinusin, yusur Akopaatsshat k'kuzee kamaniranganaya. Zuwanllpish Esawap napeeshininiya. Shiyaam apus chamayangati átu, naanlltanda. Wasundarurpatari 400 anpa naanlliya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ashirucha, Akopsha anoo tsiyatsis mazinarangu, kapung punirustarangu, mangush zapan chinarangiya. ¿Tamacheezi? mangush tárangu, tiptsiree tsimbun chawpishtarangiya. Minush ashpatam tiptsir, minush ashpatam tiptsir sheeru, tushaneerangiya. Mishat, piyam waanitaritam chinpatari, tushaneerangitamta. Ichingaru wakaratam, opeejatam, kameechutam wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Amb sheeruri, zuwanlleetsi Esawa imamarpachina. Minungicheetsim tputsiri pachakchusin, itaru, minungich tputsiri suwachinllinaya, mangush chinaku Akop tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Sheeru, Akoparini Apanllee kapung masharangiya. Mashku; Apaa, shiy kizpurtishcha. Shiyaamari nuwaa istangandama. Watam nuw pachiri Apraham, apari Isaak, ashiru urutari shiy anchicheetsini kizpur chinakshawa. Nuwaam kapung istangandama, watam shaana nuwaa wanasir kanapumaam istachinllpa, tárangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nuwnaa nduntaa waritaranguri, itaru shiysha nuwaa uru wanasir ksutarangsha. Nuwaa kapung chinarangush, nda pakchiyam kasarangasha. Ashirucha, sirútama nuw kungoo Ortagaa kitamaam zandaranguri, tushuwshimariti payuri, anpatamari kitarangina. Na nish tsap kusarangshiti, tputsireetsi tsimbun chawpishtaranguri, tushaneeyarina. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","12","Ashiriya, Apaa, shiyshat nuwaam istangandama zuwanlli Esaw nda nuwaa pachamaama. Shiy tapachindangandama. Zuwanlleetstana Esawa puniki. Apaz pachamaam kuskachu, izanlleetsshiti pachakchu, nllurawaatstam ipareetsi pachachtamtaya. Itaru watam, Apaa, shiysha; nuwaa shiyaam tputsirish tuzapanichima, tárangshawa. Mazach wasipur tamapari ashiru tputsirish taachiya; táchimaam pinasachiya, shiy Apaa, tárangshawa. Ashiriya, amb sheerush, wayangandama, Apanllee mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Akoparinsha anshuri maamaam shaniyaranganaya. Itaru, ndaturi maarsin, anush muchchuree tuchip kuruzeeru, maachi zapan zuwanlleem ipusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 kaapar wizarinanda, 20 kaapra upapchirinanda. 200 opeeja wizarinanda, 20 opeej upapchirinanda. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 kameechu wipaptarta. 40 wakara wizari, 10 wakara upapchirinanda; 20 burrus wizarinanda, 10 burrus upapchirinanda. Aship zoonlleem zanganimaam ipusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Anumunshat, tiptsireemshat anoo panayaru, wasina arap tuyamzayaru zanganirangiya. Imazarsin wasina naataranganaya. Siyma naangtsa. Siy tuchpis arap, arap sheerus, Esawaa chamayangangtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Wandaya zuwanlleetsi Esawa chamayangaktaateesa, siyaa mashkachu, ¿Yapsha naamachsha? ¿Chaksasa siya? ¿Chaksha in chinoo? tákchitaatiya, siysat: ");
INSERT INTO cbuNT_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","20","Dancha, ichee. Zuwanlltishcha chinu. Shiyaam chinish ashparit zanganirangiya, watam shiy kizpur kurakshawa. Ashirucha, shiyaa kizpur chinaku, shiyaam mangutari chineemish zanganirangiya, tángcha. Táyarus, Kuzizimun zuwanllish Akop apinll naanlliya, tángtsa, tárangiya. Waana Akop mangush chinarangu, Chinoo zuwanlleemi zangankachuri, zuwanllshiti kapungtaa tsiyantaru, itaru anoo pakchu, watsiyun tsíparamchu, anumun iwaz nuwapashat tsiyatchiniya. Zuwanlli ndusha nuwaa natsachiya. Ashiriya, amb ashchima, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","amb sheeru, chinoo wasina tuyamzarangiya. Anuritam chinuz imazaranganaya. Waanasha Akop anootsiri maarangiya. Ashiriya, na kamaneena yuwaa Akoparini wasina tsiyatssee zoonlleem kamachtayaru, zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ashiriya, natamatam psaan chiyzayaranllu, Wizanll tsimbunari, muchchurtam tsimbunaa yamarangu antam, wipshat 11 ashparit machtarangiya. Sheerandsin, kungoo Jabokaa arachichsha kitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Akoparini amb ashirangu, ichingaru maachiri yuwaa payuku anoo ashpari yátarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Akoparin waanitarisha kanapeeranllu, Apanllee tiptsir chamayangarangiya. Itaru, nda natstarangiya. ¿Chakshita ashtar? átu, putarangu pachipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kizpur mbammari patsisarangiya. Apanllsha tiptsir: Kaseeya átu, xapoorangiya. Ashirucha, Kasapanda, átu, Akopaa wanumbee wizpurirnee puwarangiya. Akopsha wanumb tok ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Itaru, ashiritaa Akoparini nda kasaku anoo, Apanllsha tiptsir: Kasanda. Papcha, zar yakachpa, tárangu, Akopsha: Nduni, nuw kasamaam zandkeezi, watam shiy nda nuwaam wizpurirish wanasirimash nda panakshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Apanllsha tiptsir: ¿Chaksha shiy surish? tárangu, Akopsha: Nuw suri Akoptana, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Itaru, Apanllsha tiptsir: Na ndushapari shiyaa surish Akopaa, táchinllinaya. Na nimun shiyaa tsurtaksin, Israel táchshapsinaya. Watam shiy Apanllpa tiptsir tputspapaz ashirush waratarangshawa. Mishat, watam shiy tputspatatam waratangush, shiyamaritam kasirangshawa. Na shiy Israelsha surunarangsha, watam shiy Apanllee wanasirimshirini yarangshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Akoparinsha: Shiyshat ¿chaksha surish? tárangiya. Itaru, Apanllsha tiptsir: ¿Mayaamshat shiy nuwaa suri yasamaam zandaksha? ¿Washat shiy nda nuwaa yasakish? tárangiya. Tárangu, anumun Apanll wizpurirnee wanasirimshee panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ashirucha, Akopsha anoo tsap sur Penuel átu ísamarangiya, watam, Kchiptarti Apanllee pakeenawa. Itaru ashirangtaati, nda tsiparanginawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ashiriya, Akoparin zar yakataranllu, anush tsap Penuela kasayaranllu, kungoo kiteeranllu, apinll naatarangiya, watam waturtash tok ashiranguwa. Ashirucha, naaku kuyam kuyam ashtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ashirucha, anumand Israelchich tputs maachta kitstamsheewa wanuts nda katungtaranaya, watam kitstamsheewa zamiz waturtashuch wayanx tuwapi anoom manguksin, nda wayanxa katungtaranaya. Watam Akopaa Apanll tiptsir wayanxa puwaku, waturtash tok ashiranguwa. Ashiriya, na kamaneena yuwaa Apanll tiptsir Akoppa chamayangayarusin, waratarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Anpur zar Akoparini kanapeeshinshat, zoonllshat Esawsha tiptsir 400 machiru, káyaranlltam naataran ashirangiya. Akopsha káyaranllu, wipaa tuyamzayaranllu, arang tuyamza, arang tuyamza ashtarangiya wipaa, Liyshucheetsi, Rakelshucheetstamta, anumun muchchureetsshat tsimbunatam íparangu anshucheetstam wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Chtaru muchchurnandama wipaptari tuyamzarangiya. Anumunsha Liyaatsshat wipaptartatam wayarangiya. Anumunsha kuzizimun Rakelaatssha wipapatartam Osiypa wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Akop muchchurshucheetsima wip tuyamzayaru, naatarangiya. Naayaranllu, tutunlltayaru timuchta, yusur anamun timuchta ashirangu, tsimbun matayaru timuchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Asheemchu, Esawsha zoonllee Akopa paranllu, mang' ksarangu, teet ashtaranllu, zuwanllee pachipurangiya. Pachipeeru, watsurarish zoonllee ishambarangiya. Sheersin, zoonllpa pachipeersin, tsimbunartisin kapung tanuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Sheeru, kasaranllu, napaksha, zuwanllee wizanll parangiya. Wipaatstam izapaneeyashinu anoo parangiya. Pakeeru, ¿Chakawnaareesinaya ini, aship shaneeranaya? tárangiya. Akopsha: Nuw m'chachtaateena, Apanll waana nuwaa zandeeru, kapung chinarangu, nuwaam ipari panarangiya. In aship shaneerana anu nuwaanandaricha ipari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Táyaru, muchchurshuchima wip waziparee Esawaa tasaseeru timuchartata ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Anamunsha yusur minshootsshat wip, Liyshuchshitisin, uwshtisin ambtam ashiranganaya tasaseersina. Anumunsha, yuwamunarisha tspakamchu anshitisin, Rakel wipapat Osiypa, ambtam sheersin, tasaseersin timuchartata ashirangtamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ashiramchusin, Esawsha zoonllee tárangiya; ¿Maysha mangishish chinakush, chineetsish wasina tuyamzarangush, nuw anoo apus chamayangarangina? tárangu, Akopshat: Nuw shiyaam zanganeerangina. Zuwanlli anoo pakchu, nuwaanaatsi kapung chinapanda aturi ashirangina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Itaru, Esawsha: Ndaj, zuwanllee. Shaama yamangi. ¿Nuw mayaamaja zandchee? Na nuw maachiriti zapanshat payukina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","11","Akopsha, Ndaj, nuw shiyaa zuwanllee, táchinllpa: Shiy nuwaa kis naparangush, nuw shiyaa Apanlleetspaz ashiru mangi kis napkina. Yamangi chineemish, watam shiy nuwangaz pangati átush, kusarangshawa. Shiyaamcha wayarangashina. Yamangi. Shiy nuwangaz zandarangush, wanasirpatari nuwaa chamayangarangsha. Nuw shiyaam mangutariti panakina chinampatari shiyaam istakuri ashkina. Watam Apanll nuwaam mangutari istaranguwa. Zapan nuwaam Apanll maachiriteemi panarangiya. Nuwaam maachi pishtamaam nduni, tárangiya. Ashirucha, Esaw: Ayu. Zuraktishcha, zuwanllee. Ashiri yamachparina natunaari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Táyaru, Pza, tatsamooruni naayani nuwap nungi, Esaw tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Itaru, Akopsha: Ndambaree, zuwanllee. Shiy yasartamsha. Nllurpa punangeeruch naamaam uru nllur mikeeru nizkiya. Opeejari apinll machtanima. Wakarari taaritamta wipaptawa. Na nizirtambayanchinaya. Arang yusur minum zar naakchuri, uru chini ashparishapa tsipakchusin, pchingchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nda ashishtamaam, zuwaa, shiy wasina imazayarush naangsi. Nuw apinll chinipti naatanitama. Chineemi apinll kutamchuri, uru apinllta naamchuri nllurpataw, uru kuschitamna Edomash tsapu, tárangiya Akoparini. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawsha: Zuraktishcha zuwanllee. Ashiri tputsiri nuw shiyaam kasachinllpa ipunsheemish, tárangu, itaru, Akopsha: Nda zuwanllee, ¿Mayaamaja nuw shiyaa muntachee? Na nuwsha mapiykina, watam shiy nuwaa kis napakshawa. Tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esawsha anuritam; Zuraktishcha, tárangu, waptam kanapurangiya watsapuniptam Seirap Edomap tsapu. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Anuritam zar Akopsha ambiritam piyamaritam ktapeeranllu, naatarangiya. Ambiri tsap sur taariya Sokota, watam uru chinoom ishinchu anoom tsap kureeru taaranguwa. Ashirucha, ambiri Akoparini pangoom wayarangiya. Chinuzeemsha tambtarangitamta. Anumand Sokotaa táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ashirucha, Akoparini tsap Padán-Arammand káyashinu, Kanaanash tsap wanasirish kusataranganaya. Nda wanguytaranganaya. Anushshat yaktash tputs taarangiya sur Sekema. Ashiriya, Sekemash tsap kusarangsin, annungirisha kayum panguyarusin, taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Anushshat Akop kuseeramchu, watsapuneem paxanxarangiya. 100 kurik mbammash tputs sur Hamoraam panarangiya. Hamorsha wip kanungas taarangiya sur Sekema. ");
INSERT INTO cbuNT_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Sheeru, Akopsha Apanlleemshat ungirtasheemani patumbich xanatarangtamta. Anoo: El-eluhé-israel, tárangiya. Hebrewshuch kuk: Nishuri nuw Israeli Apanlleem ungirtachima, átu tárangiya. Ashiriya, na kamaneena yuwaa Akoparini zoonllpa tatsuyarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina mang, Liycha wipaya. Waparshat Akopcha. Anshat Din kamasinayaru, yaktashuchpa kamasinpatatin ipunpi átu, xiyrangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kanungassha anush yakat taarangiya, suru Sekema, Hamorcha wipaya. Hamor anpur anush yakat kurakamuna Hebewchich tputsi. Anoo yaktaa ksutarangiya. Ashirucha, Sekemsha Dinaa pakeeru, putarangiya. Nduntaa Din zandarangu, ashiritaa, pshiyreeru, mantsir patatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Kanungassha Dinangaz kapung zandarangu, Din nuwaa chinapanda átu, Dinaa zapan izamzaztar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekemsha waparee Hamoraa tsiyatku, tárangiya; Apaa, nuwaam mashanda. Nuw izanlleemi yamaamamaricha. Nee kiz zandki, tárangiya wapareetsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Akopsha anoo k'kuz mazinarangiya, yuwaa Sekem wipaa Dinaa mantsir patatku anootsi. Itaru, wipsha ashpari apusap pastup chinuzip taárash shanee ashiranganaya. Akopsha wipaa kutaku, natumasam nda tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Itaru, ndaturi wip kusarusin, Sekemsha wapar kizaa mashpi átu, Akopash naparangiya. Itaru, Akopsha: Xamachi. Ipari ichingaru kuseemasa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ashiriya, zapishsha ashpari wip pangusish kusateeramchusin, anush tsiyatssee yuwaa Sekem wizaree yutarit patatarangu anoo mazinaranganaya. Mazinarangusin, ashpari Akop wip kapung tsiyantaranganaya. ¿Mayaamshitaja Sekem apapaa yutaritash wayamaam zandak? Iyaatstam yutaritam ínaranganawa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Itaru, Hamorsha; Nuw ipari siyaa izarish zandkiya. Ashirucha, nuwsha siyaa táshina: Waanari ashiru, izarish ipareemi panamaam waritakinaariya, watam nuw ipari kanungas taakuwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ashirucha, ipareemi panakchus, siysa iyachchee nutsas yamachtamsa. Siyashuch kamuzanur iyaa iparni yamachinllinaya. Ambinaapa sheeruch kis taachchee. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Siy nishurtatam tsap taarasheemis saamataritam tsapunis yachtamsa. Washunandarisha yapandayaruch taachchee. Sheernapsa, nishurisha tsap taatssa; tsapuneemaritamtis paxanxatssa, tárangiya Hamorarini. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ántaru, wipshat Sekem Dinaa wapar, wayucheetstam tsiyatarangiya. Mashku; Nuwaam izanlli iparish kasanganda. Waanari iparish nuwaam panatarush, nuw shiyaam istachinlla. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ipareetsish yamatarinaareena, uru nuw maachiritaatsi siyaam mangutariti panamaam taariya. Maachi aranginasha zapan siyaam panachintspa. Ashirucha, nuwaam iparish pananda atashina, tárangiya Sekemsha tsiyatku. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sekem Akopaa wip Dinaa mantsir patatarangu, itaru wayuchtisin, Akopsha wip tsiyataranganaya. Mangu Sekemaa tamapingaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Zuraktishcha. Itaru, iyashuch tputs kamuz yuwaam nda wayumshiri tas nllurtama nda ktsuparangu anoom ¿nitaati iy izareetsini panatareezini? Iy amb ashimaam paziktanicha. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ashirucha, anumun nuw siyaam izareetsi panamaam pachindakpazi ashkina, watam iy nllitaritamaniwa. Nuwsha siyaa táshina; wandaya iyapa taamaam zandkus, ashiri ashparitis tputs kamuzaw kanungaseew taarana, anoo ashpari wayumshiree tas ktsupchinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ambinaapari sheerus, uru iyaa izarini yamatartatssa. Iyshat kamuzanurini siyachchee izaris yamachtamaniya. Siyashuch kanungas iyaa izarni yamakatarusin, iyshat siyashchee kizanurnis yamakatpitamaniya. Ambinaapa sheeruch, washunandarisha yapandachchee. Washunandarisha yakat kayaneeruch taachchee. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Itaru, yuwaa áti anoo nduniya, ayu, átus, nda siyashuch nuwaa kuki nda payuksin, kamuzanur wayumshiree tas nda ktsupkusin, uru iy nee yakat shitungeeruni, arapsha naachiniya, Akoparinshitisin wip táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ashirucha, Hamorsha, anuritam mang chinaranganaya wipaptarta Sekempatarta. Ashiriya, amb sheeni, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ashirucha, Sekem nda pakchiyam xararangiya, watam Akopaa wip Dinaa kapung zandaranguwa. Akoparini wip tárangana anoo kuk payurangu, anuritam tuminurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ashirucha, waparpat yuwash tputs paxanxamaam shaniykana anshutam kamankatu naatarangiya. Kamanku tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","In tputs wanasircha. Amikurtamaam iyapat zandkanaya. ¿Ndushat nish ishinanda át? Iyashuch kamuzanur waa wizanur yamachinllinaya. Uwshtisin kamuzanur iyashchee kizanur uru yamachtamsinaya. Ashiriya, amb sheeruni, washunandarisha yapandayaruni taayani. Watam tsap kapung kureeruwa. Waani watsapuneem paxanxeersin taachtamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Iyshat ashparitini kamuzanuri mshirni tas ktsupeeni, watam uwshtisin anuritam payukanawa. Iyshat sheertamani washunandarisha kis taapani. Waani iyash tsapuni taapana. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Amb ashkatssin, uru iyshat wakararineetsini yamachtamaniya. Ashpari chinoo iyshat amuytachiniya. Maachtaw payukana anuwa ashpari iyamari amuytachiniya, mang táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ashiriya, yaktashuchshat kamuzanur kanungaseewtam, Ayu, tárangusin, ashparitssin zamangaranganaya. Ashiri pza. Amb sheeni Hamor tánna anootsi, tárangusin, ashparitssin wayumshiree tas ktsuparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tuchpashsha zar Akop wip Simeón, Leviy ashirusin, Dinanandari wayuch: Pzaya, pangaani yaktapi, táranganaya. Anshuchshitisin yaktashuch yuw wayumshiree tas ktsupeerna an kizpur ksurangiya; chiyzamaam nda waritarangusin, wasurimun tamurutar ashiranganaya. Nda waanaatsi tapachindamaam nda waritaranganaya. Akopsha wip machtaree yátartaranganaya. Sheersin, kamuzanuree kachingaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamorashshat pang' pshtuyarusin, mchitpa pacharangitamsinaya wipaptari Sekempatarta. Sheersin, Sekemash pangu wizaree yanpuranganaya. Sheerandsin, wapitam wapariptam pang' kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Zoonllshtisin kuzizimun káyashinusin, yaktash kusarangtamsina. Tsiparimunsha iwaz kata kata sheersin, maachiritawa ashpari ichingaranganaya. Maachtawaatstam, chinuzeewaatstam ichingaru machtarangana. Wizaree Dina Sekem mantsir patatarangu anumand tsiyantayarusin ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ashchiri yaktash shuchiranganaya; wakaraatstam, opeejaatstam, burrootstam, ichingaru yaktashuch payurana anoo ashpari shuchiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nllurawaatstam ashpari yamaranganaya, kizawaatstamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ashiriya Akopsha mang tsimbunuri wipaa Simeóna, Leviyaa ashiru kuruzeeru, ¿Mang, siy tputsee pacharangis? ¿Ndushta anumand nuwaatsshat tputs natsaychinda, Kanaanshuchshitisina, Feresewshuchtamta? Anshuchshitisin uru nuwaa kapung natsachinllinaya. Watam wazapanshitisinawa. Iyshat tputsirini pakchim kamuzanurni taariniya. Uru iyaatsim pachachinllinaya, zuwanlleewaatstamti uru pachachtamsinaya, mang wipaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Itaru wipshitisin: ¿Antaati iy izarni mshipaneeja? Anumand nuw nda mbizamaam zandkiniya, mang waparee táranganaya. Ashiriya, na kamaneena yuwaa Akopaa wip Dina Sekem mantsir patatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Apanll Akopaa; Natu Betelap tsap naayarush, taamacha. Anshurisha patumbich xanateerush, nuwaam ungirtamachcha. Yuwashtam zuwanlleetsish punikush suwarush maarangish anshutam yusur siyapa tsiyatsteeni, tárangiya Apanll Akopaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Akopsha anuritam wizanlleewa, wipunasheetstam, Natu; ichingarus yuw apanllputsiris yarangis anoo ashpari yáyarus xanatangints. Sheerus chumangshitints. Chumayarus, kamaris nllitarisha k'tuntayarus, kamartangints. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pzaya; Betelapsha tsap naayani. Amb nuw patumbich xanateeri Apanllee ungirtamaama. Sirú kiyung kachiyaranguri, mangi kapung mantsaranguri, itaru Apanllsha nuwaam kapung istarangiya. Yapta waritaru naataranguri, uwshat ambitam nuwaa ksutarangiya, tiptsiree tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Uwshtisin ashparitssin yuw tputsee maachiri apanllputsirini shuchiyarusin, witsish tawanurangana anootstam ichingaru yusheersin, Akopaam panaranganaya. Akopsha uwshat yáyaru, ashpari tsapush wantsush ktseeyaru, anush pshtayaru, Sekemanung yakta yasinash puch mapurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Akopsha ichingarusin anoo tsap shitungeerandsin, naataranganaya. Apanllsha tputsee anshuchee, annung yakat taararutaritamta anoo ichingaru ashpari tpuxtarangiya, nda Akopangaz tachitamaama átu. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Shitungeerandsin, Akoparini ichingarusin tiptsirpatari Kanaanash tsap yaktash Lusash kusaranganaya. Anshat yakat sur tsimbunumuncha, Beteltamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Anshuri Akoparin patumbich xanateeru, anoo tsap sur El-Betel átu ísamarangiya, watam anootstam tsap Akopaa Apanll sirú tsiyataranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Anshutam tsap kusarangsin, Deborarini Rebek muchchur tsiparangiya. Anshuri Betelash tsapu yasinashsha puch mapuranganaya. Ashirucha, Akop anoo tsap, In tsap tanushshi, átu ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Akoparini Padán-Aramap tsap kanapeeshinu, anush Apanll yusur Akoparineetsi tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Shiy surish naturi Akoptishcha. Itaru, na nimun zar shiy surish Israelshaparee ísamachinlla, tárangiya. Apanll Akoparineetsi misha sur ísamarangu, anush waanaatsi kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nuw Apanlltana kizpurtana. Nuwamari ichingaroo kasikina. Ashiriya, shiy uru nimun iparish wazapan izapanichsha. Chinllinitamtish shiyachchimari nutsas pzapaneeyarusin, tsapurnasish ztaru taachinllinaya. Watsapuneewaritam zapan yachinllinaya; anushsha tatsitchiya. Ashiramchusin, anamun kurakaamshat kinakinaarsin taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tsapootstam Aprahamarineemi, Isaakarineemtamani panarangi anoo shiyaamsha panachinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Anshat, Apanll Akoparinpatini tsiyatstarangu, tsípata ashkachu, ");
INSERT INTO cbuNT_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Akopsha patumbchee ichizata sheeru, wayungunootssha, misha vinootstam yáyaru, yuwamun pshkuru xumbaataru anamun zaw zaw sheeru, ichumayaru, kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ashiramchu, anoo tsap Betel átshat ísamarangiya. Hebrewshuchish k'kuz: Nee Apanll waana pangu átu tárangiya. Na kamaneena yuwaa Apanll Akoparinpatini tsiyatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Anumunshat, Akoparini Betelaa tsap kasayarandshitisin, izuuru shitungeerandsin, apus naarsin, ndaturi Efratash tsap kusarusin, apusari ngootsish naarsin, anush Rakelarini nlluraa tatsipku, mantsir tatsipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ashirucha, mantsir iparinarangu, anshuri yuwaa patusamaamshita anush nllur shitungarangu, istampansha tputs: Rakelaa, punirinllpa. Napangi; yusur kamuztam iparinayanllish, átaritaa, ");
INSERT INTO cbuNT_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","itaru Rakelarinsha anshuri tspapatarat ashirangiya. Tsipasheemamsha tsiyatarangu, wipaa sur Benonin átu ísamarangiya. Itaru, waparshat wipaa yamayaru, Benjamin átshat uwshat ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Amb sheeru, Rakelarini tsiparangiya. Tsiparamchu, anshuri Efratshuri ngoots mapuranganaya. Itaru, natpursha anoo tsap Biring átshitisin tsurtakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Akoparinsha wizanllinaa yáyaru, patumbchish wach kawaru anush pshtayaru, wanasir mapeeru, patumbichpa kapungumashpa kámanayaru, kasarangiya. Natshat wandaritam yuwash Rakelarineetsini mapurangana anoo patumbchee pakaniya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ashirangu, Israelarini aranginasha ngootsip naatarangiya. Apus tsap sur Eder torreerini tána anoo kaneeru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ashiriya, Israelarini anush tsap taarangsin, wipshat Ruben kanungas taarangu, wapareetsshat wizanll mashingamarineetsi sur Bilhaa mantsir patatarangiya. Akoparinsha anoo parangu, kizpur tsiyantarangiya. Ashiriya, na kamaneena yuwaa Rakelarini tsiparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Akoparini wip washunand 12 taarangiya. Ichtakchuri Liyshuma iparnarangiya iwachiztamaatsi, Rubena, Simeón, Leviy, Utaá, Isakar, Sabulón. Aship Liyshuchima taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakelshuchshat Osiya, Benjamin ashpanand tsimbunandam taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilhashuchshat yuwashuch Rakelaa muchchur yamarangu anshuchshat, Dan, Neftaliy ashiru tsimbunatam taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silpashuchshat yuwashuch Liyaa muchchur yamarangu anshuchshat Gad, Aser ashiru tsimbunatam taarangiya. Aship in ichingaru Akoparini wip taarangiya yuw Padán-Aramash tsap nllurtarangana anu. Ashiriya, na kamaneena yuwaa Akoparini wip pzapaneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Akoparini k'kuzee mazinarangu, waparingaz Isaakangaz Mamrep tsap pakatu naatarangiya, yap yakat Arba, Hebrona, tána ambi. Anush Isaakarini taarangiya yuwashtam Aprahamarini taarangu anshutamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaakarinshat kizpur wachinamuna 180 masachirini taaramchu, tsiparangshita. ");
INSERT INTO cbuNT_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Anshat tsiparamchu, yuwash zitaminarini taakana anush Apanllip naatarangiya. Wipshitisin Esaw, Akop ashirusin, waparinaa anshutam mapuranganaya. Ashiriya, na kamaneena yuwaa Isaakarini tsiparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esaw sur tsimbun taarangiya, min sur Edoma. Esaw wip zapan taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Anshat, Esaw Kanaanshuchee kiz tuchip yamarangiya. Ichtamarini wizanll sur Adaa. Anshat, Elón wipa Hititshuch tputsi. Mishat, wizanll sur Olibama. Anshat, kiz Anaan wipa, Sibonaa wachinllinu Hebewshuch tputsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Mishat, wizanll tuchparinshitini sur Basemata. Anshat Ismael wipa, Nebayot muna. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaw aship wizanll taarangu; Adashuma iparnarangiya minumta sur Elifas. Minushshat wizanll Basematash iparnarangitamta. Anshat wip sur Rewela. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Minushshat wizanll tuchparinishtini Olibamash iparnarangitamta, Jeús, Jalam, Koré. Aship an ichingaru Esaw wip taarangiya, yuw Kanaanash tsap nllurtarangana anu. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Anamun zapish zoonll Akop kusachshat; tsap washunand taamaam pishtarangu, Esawsha arap nllitaritap tsap naatarangiya. Ichingaru wizanll ashpari, wipshat ashparitam, chinutam, yuwatam Kanaanash tsap kusachu maachiritam yarangu, payusheema anutam, muchchurtam, kamuzpatari, kizaptari, yuwatam anush tputs taarangana anutam, wipunashtam ichingarusin káchingayarandsin, minupshat tsap naataranganaya. Akopaa zoonllee arap wanllitpi átu ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Watam zoonllpa Akoppat washunand watsiritaw taamaam pinasaranguwa, yuwamand chin chirichiree kaching kaching ashku anumand washunand taamaam pinasaranganaya. Minupshat arapshat wanlliteeru naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ashirucha, Esaw anoo tsap shitungeeranllu, minupshat tsap, mach sur Seirap taakamchu naatarangiya. Ashiriya, na kamaneena yuwaa Esaw wip pzapaneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","In ichingaru Esawnandari wachinllinu, Edomchich tputsi atanaya. Mach tsap sur Seirash anush pzapaneeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ashiriya, Esawaa wachinllin sur kamanchintspa. Esaw ichtakchuri Adash iparnarangiya, sur Elifas, minushshat wizanll Basematashsha Rewelaa iparnarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ashirucha, wip aship taarangu, Elifasshat, Adaa wip, uwshat arang iparnarangiya Esawam wachinllinu. Teman, Omar, Sefo, Gatam, Quenas, aship Elifas wip taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifassha wizanll mashingamashsha sur Timnash minumtam iparinarangiya. Sur Amalekaa Esawtam wachinllinu. Aship in ichingaru Esaw wachinllin Adash taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Tsimbunarnishitini wizanll Basematash Rewelaa iparinarangiya. Uwshat Rewelsha arang iparnarangitamta Esawam wachinllinu. Iwachiztamarni sur Nahat, Serah, Sama, Misa. Aship in ichingaru Basemat wachinllin taarangiya Rewel wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Mishat, Esawtam wizanll tuchparinshitini Olibam arang iparinarangitamta. Anaa wip yamarangu anshu, Sibonash wachinllinu. Olibam wip iwachiztamarni sur, Jeús, Jalam, Koré. Aship in ichingaru Olibam wip taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ashiriya, na minootsshat Esaw wachinllin kurakaamshat kinarangana anootsshat kamanchima. Ashiriya, Esaw wachinllin iwachiztamshuchima Elifasshuch wip taarangiya: Teman, Omar, Sefo, Quenas, ");
INSERT INTO cbuNT_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Koré, Gatam, Amalek. Aship an ichingaru Elifasanandari wip kurakaam kinaranganaya Edomash tsapu. An ichingarusin Edomchichinandari tputsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rewelshat wip kurakaam kinarangitamsinaya Esawtam wachinllinu, Nahat, Serah, Sama, Misa, aship an ichingarusin kurakamtam kinaranganaya. Edomshutam tsapu Rewel wipa Basemat wachinllinu. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Olibamshat wip kurakaam kinarangitamsinaya. Esawtam wipa Olibamash wanindarangu anu. Ansha wip sur taarangiya: Jeús, Jalam, Koré. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aship ichingaru washunand Esawa wachinllin kurakaam kinaranganaya. Ashiriya, na kamaneena yuwaa Esawchich wachinllin kurakaam kinarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Anshat Seir Horewsh tsap taarangu, wipaam pzapaneerangitamta. Wip zapantam taarangiya, Lotan, Sobal, Sibon, Ana, ");
INSERT INTO cbuNT_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser, Disan. Aship an ichingaru kurakaam kinarangitamsinaya, Horewshuch tputs, Seirnandari wachinllinu Edomash tsap nllurtarangana anu. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanshat uwshat arang iparnarangitamta sur, Hori, Hemam, ashpanandtam wip taarangiya. Lotanshat wizar sur Timna taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalshat uwshat arang iparnarangitamta, Alban, Manaat, Ebal, Sefo, Onaam aship wip Sobal ichingaru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Anumunshat, Sibonshat uwshat arang iparnarangitamta Aíya, Anaa, aship Sibon wip taarangiya. Anshat ashirangsin min wip shipamunach sur Anaa, apusap tsap xittu kungoo wanasirimshee parangu ambirisha naayaru wapar chin burrurini ksutku taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anaa wipa minumtam kamuz sur Dison, mishat kizshat wip minumtam sur Olibama ashiru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disonshat uwshat arang iparnarangitamta, Hemdan, Esban, Itran, Quenas, aship Dison wip taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esershat uwshat arang iparnarangitamta Bilan, Saavan, Akan, aship Eser wip iparnarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disanshat uwshat arang iparnarangitamta, Osa, Arán. Aship an ichingaru Seir wachinllin taarangiya. Ashiriya, na kamaneena yuwaa Seirchich wachinllin pzapaneerangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horewchich kurakaam kinarangitamsinaya, suroo na kamanchima: Lotan, Sobal, Sibon, Anaa, ");
INSERT INTO cbuNT_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser, Disan. Aship an ichingaru Horewnandari wachinllin kurakaam kinaranganaya. Aship an ichingaru maachiritanandaritssin zoonllinandaritssin kurakaam kinayarusin, Seirash tsap taaranganaya. Ashiriya, na kamaneena yuwaa Horewshuch tputs ichingarusin kurakaam kinarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ndatuma Israelchich tputs kurakaam kinatssin, ichtakachuri Edomshuchima tputs zitaminarini kurakaam kinarsin, ksutkusin taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ashiriya, zitamin Beor wip sur Bela taarangiya, yuw Edoma tsap kurakaam kinayaru ksutarangu anu. Yaktarinshat sur Dinaba taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belarini tsiparamatshat, Serarinshat wip Jobabshat uwshat anoo tsap kurakaam kinayaru ksutarangiya. Anshat tputs Bosráshuch yakta. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabarinshat tsiparamchu, Hosamshat uwshat anoo tsap kurakaam kinayaru ksutarangiya. Anshat tputs Temanshuchi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hosamarinshat tsiparamchu, Bedadshat wip Hadad sur, uwshat anoo tsap kurakaam kinayaru ksutarangiya. Sheeru, Madiyanshuchee tputs kachingeeru kasarangiya, Mowabshucheetstam tputsi. Anshat tputs ambichshuchi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadarinshat tsiparamchu, Samlashat uwshat kurakaam kinayaru, anoo tsap ksutarangiya. Anshat tputs Masrekayshuchi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlarini tsiparamchu, Saulshat uwshat kurakaam kinayaru, anoo tsap ksutarangiya. Anshat tputs Rewbotshuchi yaktarini kungumun wing taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saularinshat tsiparamchu, Baal-Hananshat uwshat zamuyaru, kurakaam kinayaru, anoo tsap ksutarangiya Akborarini wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hananarinshat tsiparamchu, Hadadshat uwshat zamuyaru, kurakaam kinayaru, anoo tsap ksutarangiya. Anshat tputs Pawushuchi, wizanllsha sur Meetabela, Matredarini wipa Mesabarini wachinllinu. Ashiriya, na kamaneena yuwaa Edomash tsap zitamin kurakaam kinarsin taarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","In waatatcha yuw ichingaru Esaw wip waannandaritssin zoonllinandari watsapunish taarangana an sur Timna, Alba, Jetet, ");
INSERT INTO cbuNT_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ela, Pinon, ");
INSERT INTO cbuNT_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenas, Teman, Mibsar, ");
INSERT INTO cbuNT_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiel, Irám. Aship ichingarusin taaranganaya. Mishat, Esaw sur tsimbun taarangiya, minu Edoma. Ashirucha, aship Esaw wachinllin taarangu, anchichinandari ichingaru kurakaam kinaranganaya Edomchichinandari tputsi. Ichingarusin minush kung, minush kung, ashirusin taaranganaya. Ashiriya, na kamaneena yuwaa Edom wachinllin kurakaam kinarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Itaru, Akoparini Kanaanapsha tsap taarangiya yuwash sirútama waparin Isaakarini taarangu anshutamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Watacha Akoparini zitaminchich maachirita. Anpur zar Osiyarin kanungasiri masachirini 17 taaru, waparee chin opeejaa ksutku taarangiya. Akoparini muchchurish Bilhash, Silpash ashiru iparinarangu anpa zoonllpa Osiyarin chinuzee ipunarusin, ksutaranganaya. Ksutkusin, itaru Osiyshat waparee yuwaa zoonll mantsir napkana anoo kamanimantar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Itaru, Akoparinsha Osiyarinee kizpur chinarangiya, watam kizpur wachinachu anush Osiyaa iparinaranguwa. Akoparini Osiyaa kapung chinaku, wamareem kizpur wanasirimash yáyaru, túmartarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yuwamand ashku anumand zoonllshitisin Osiyaa kapung natsataranaya. Izuuru niyrtaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ashkusin, anush Osiysha kizpur maarangu wanasirimash pamazurangiya. Yuwaa pamazurangu anoo zoonllee kamanirangu, zoonllshitisin aranginasha natsaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Mazinantsa. Nuw maaranguri, anush pamasarangina. Iyshat mzatsish shanee ashiranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tirikoo yáyaruni, kamuriyaruni, nuwshat tirikuri kamurimari apusunand chiyzata sheeru, pshkuyarangiya. Itaru, siysat tirikuris nuwaa tirikuri turipingaru, timuchataranll ashirangiya, kamanku zoonllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Zoonllshitisin anoo mazinayarusin, kizpur tsiyantaranganaya. ¿Tamashta iyshat shiyaa kurakareemani ínachinee? ¿Tamashtaja shiyshat nllurshitish iyaatsshat kasiyarush kurakaam kinachish? tárangusin, tsiyantaranganaya. Tsiyantayarusin, Átish anoo ksaja mazinakani. Wapa tamundaksha. Zamangi, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Anumunshat, yusur Osiyarini maarangu anush pamasarangiya. Anootssha, yusur zoonllee kamanirangtamta. Pamaskuri, nuwaanaatsi zaritam, tsupitam, anumunsha tsangach 11 turipingarangandanaya. Aship an nuwaa turipingayarusin, timuchartaranganaya, kamanku ántar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ashiriya, waparsha anoo mazinarangu, Osiyaa waneerangiya. ¿Tamashtaja iyshat aneerish, nuwatam, zoonlltamtish ashiruni shiyaa turipungayaruni, tsapumun tunduchtayaruni, muchini timuchta ashtachini? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ashirucha, zoonllshitisin anumand kapung tsiyantarangusin, aranginasha Osiyaa natsaranganaya. Itaru, waparsha mangush chinaku, ¿Mayaamaja nuw ipari pamazuku ashik? ántar ashirangiya. Ashiriya, na kamaneena yuwaa Osiy pamazumarineetsi kamanirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Minushsha zar Osiy zoonll Sekemap tsap pastungaz nachungakatu, opeejarini ishinpani atusin, naataranganaya. Watam wapar opeejarini zapan chinuranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ashirucha, waparsha Israel wipaa Osiyaa tárangiya. Mazinangcha. Zuwanllish Sekemap tsap opeejarini ksutkusin taakanaya. Nuw shiyaa amb zanganimaam zandkina, tárangiya. Osiysha: Apaa, zuraktishcha. Átish anoo tuminchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israelsha: Kaapa wanasir napangcha. ¿Tamakazinllinaja taarana? ¿Opeejatam tamareeja taar? Napam iwatsparamchush, ningitam kanapungcha. Kanapeechush, nuwaatssha yuw pakeeshinish anoo kamaningandama, tárangiya. Táyaru, Osiysha anuritam naatarangiya. Wazawap Hebronap karuwarangu, ambirisha naatarangiya. Sekemash tsap kuseeramchu, zoonllee naxpoorangiya. Anshurisha xitat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Piyamsha nachungtaat ashirangu, tputsee chamayangarangiya. Tputssha Osiyaa: ¿Shiy tamakshitish nish xitat ashiksha? ¿Mayangaz nachungaksha? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Osiysha: Zuwanllingazi nachungakina. ¿Shiy zuwanlleetsi paktaatish? Yasakinaareesha, nuwaa kamaningandama. ¿Yapeeja chin ksutku taak? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tputssha: Nishunaa tsap shitungarangiya. Itaru, nuw pakich mazinarangina, yuwaa tsiyatstangat ashirangana anootsi. Pzaa. Ndutanap tsap, naayani, ántangat ashiranganaya, tárangiya. Osiysha anuritam, Ambsha pangandama, átu naatarangiya zoonllingazi. Yusursha nachungakatanu, Ndutanash tsap kuseeramach ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Uwshtisin zoonll shaneersin, napataranllsin, arap Osiyaa iriptaranllu anoo paranganaya. Pakeersin, ndaturi kusaru anush tsiyataranganaya. Pzaya. Pachayaruni kasayani, tárangusin, ");
INSERT INTO cbuNT_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","zamangarangusin, Napangi; ¿chakamasa? Yuwamanda iyaa pamazumpa kasimaam zandku anumanda. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Waani kusap. Pachayaruni, pososhsha wachush wantsush kapeeteeruni kasayani. Tumuzpari manginshuch zayaru, katungarangiya, táyani. Pachakchuni, ¿ashim tputs pamazumarini tamatareeja yasamaama? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben yuwaa ántarana anoo mazinarangiya. Uwshat, ¿Mayaama zuwanlleetsini natsachini? Watsta. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","¿Mayaama ursiree tsapumun tuchumchich? Wandaya nda anoo zandkus, posshuna wachush wantsush kapeeteerinaaris, ksangints. Itaru, pachamanaa pcharintspa. Ngutis pososh kpitangtsa, zoonllee naynirangu, tárangiya. Tapachindapi átu, wapitam waparip yusur wayapi átu tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Osiyarinsha zoonllish shaneerana anush kusarangiya. Zoonllshitisin tsiyantarangusin, putayarusin, wamaree wanasirimashee itutsiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Putayashtisin, pososh pshtarangana. Itaru, anushsha pososh kung ndunarimuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sheersin, anshurisha kuxineersin katungaranganaya. Katungkusin, anush nap ashkusin, arap tputs shurangarsin, naantssin paranganaya. Zapan tputs shurangakatan ashiranganaya. Ismaelchich tputsi kusataranganaya. Yakat Galaadamand káyashinusin, kameechumun maachi zapan yushindarangana. Balsamoatstam, mirraatstam, kzammasheetstam payuranganaya Ijiptop naakchusina. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ashiriya, Utaásha zoonllee tárangiya: ¿Zuwanlleetsini mayaamaja pachachini? ¿Pachakuni, mayaja anush istach? ¿Tamareeja anoo kamapshichich? ");
INSERT INTO cbuNT_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","¿Ndusha putayaruch, tupaxanxanda át? ambinaapa sheeruch, kurikee putachchi. Watam yaantari zuwanlliniwa, tárangu, zoonllshitisin piyartach anuritam chinaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ashirucha, Madiyanshuchsha tputs amb naakchusin, anoomsha zoonllee pososh yusheersin, kurik mbamash 20 anpa tupaxanxaranganaya. Madiyanshuchsha Osiyaa Ijiptop tsap machtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","30","Itaru, zoonllsha Ruben pososh napkatu naxpoorangiya. Naxpoorangu tanurangiya. Tanuku wamaree izichta izichta shitar ashirangiya. Yapsha zoonll shaneerana ambshat teet ashirangiya. Zoonllee masharangiya. ¿Atuwa, zuwanlliniwa? tárangiya. Uwshtisin: Tupaxanxaranginiya, táranganaya. Rubensha: ¿Ashiriya tamaycheezich? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","zoonllshitisin opeejaa karupan pachayarusin, ursir tuchumeersin, anush wamaree tazuriptaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Anumunshat, wapareemsha yámandamaam muchchurish uw zanganiranganaya. Waparishsha kuseeru, kamazee yushindayaru, wapareem panakamchu, ¿Chaka wamar ashtar? ¿Ndushat shiy iparish wamar? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Akoparinsha yuwaa ashirangana anoo nda yasarangiya. Ashirucha, Zuraktishcha. Nuwcha ipari Osiy wamari. Natstaktana. ¿Ndushat maachit manginshuch zarang? Zayaru, katungarangparee, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kapung mangu mantsarangu, waanaatsi wamaree putayaru, izichirangiya. Sheeru, kustarsha kamartarangiya. Kamartayaru, wipangaz tanuku, kiyung kachiyarangiya. Kapung mang' mantsaku taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Itaru, wipshitisin, kizatam, kamuztamsin waparee tuwizpurtamaam zandarangsin, itaru waparsha: ¿Antaati nuw siyaa tuwizpurtangasinda ateezi? Nuw nuwaanitari zansimun tsipachima. Yuwashuri tsipakchi anshuri iparineetsi pangchina, tanutantaru anush tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Itaru, Ismaelchich tputs Osiyaa Ijiptop tsap machiranganaya. Anush Madiyanshuchsha tputs Osiyaa muchchureem paxanxarangiya, kurak sur Potifara. Potifara kurakamuntamta. Parawarineemi sundar ksutkana anoom urkar taarangiya. Ashiriya, na kamaneena yuwaa Osiyaa zoonll tupaxanxarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yuwapur Osiyarinee zoonll tupaxanxarangu anpur Utaárin zoonllee kasayaru, nllitaritap tputs taamchi átu, naatarangiya. An tputs sur Iraá. Yaktash Adulamush taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Utaárini anush taarangu, Kanaanshuchee wizanuri parangu, izuuru wizanlleemari yamarangiya. Ungsirsha suru Sówa anoo wip yamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Yamarangu, anumun wizanllsha mireerangu, kamuz tatsiparangiya. Suru Eraa ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Anumun zapish yusur mireerangu, kamuzaatstam tatsipurangiya. Suru Onán ísamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Anumun yusur mireerangu, kamuzaatstam tatsipurangiya. Sur Sir ísamarangiya. Sirarin nllurtarangiya yuwapur Utaárini Kespash taarangu anpuru. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Zapishsha Utaárini Eraam wizanlleem panarangiya kiz sur Támaraatsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Itaru, Apanll Erarinee nda wanasir parangiya, watam uru yutarit taaranguwa. Ashirucha, Apanll: Watsta, tárangu, tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Erarini tsiparamchu, ashiriya Utaárinsha yusur minootssha wip, Zuwanllinish wizanll mashind izuuru yamangcha. Ashkachush, an kiz zuwanllineemish wip iparinachiya. Shiyamunsha zuwanllineemshtish nlluranur taachinllinpa, Utaárini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Itaru, Onánarinsha uru yasarangu, Támarash iparinakinaareena, Ershapaz wipa ashishapa taachiya. ¿Antaati an nuwaamaja ipareemi taach? nda, tárangiya. Kizash Támarash iparinamaam ngatarangiya. Támarpa maarangitaa, Onánsha nda wanasir ipunarangiya. Ashirucha, Támararin ndusha mireerangiya. Onánsha ndusha zoonlleem wip tinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Apanllsha anumand tsiyantayaru, Onánarinee: Watsta, tárangu, tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Anumunsha, Utaárini ungsirimunpa tsiyatku: Natumasam mashind taachsha. Aparpish kanapungcha. Ipari Sir kanungaskachu, annaa shiyaa yamachparee, tárangiya. Táyaru, itaru Utaárini waana wipangaz Sirarinee kapung chinaku, Panakchuri, yusur ipari tsipachparee átu, nda panarangiya. Watam na nuw iparini tsimbun tsipayanlluwa, tárangu, Támararinee waparip zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Zapish yusur Utaárin wizanll Sówarini wip tsiparangiya. Ashirucha, Utaárin tanurangu, anumunsha wazan kanusaramchu, nllitaritapsha yakat, Timnatap naatarangiya. Uru anush opeejaa pur kturamapan tputs taaranganaya. Utaárin wamkur, Iraárini Adulamshuch tputsi, Kayanutamta átu, anpa ipuneersin naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Támararin tsiyatssee mazinayaru, Utaárin Timnatap tsap opeejaam pur kturamaam naayanllina, atusin mazinarangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Támararinsha mashindoo watunir yusheeru kasarangiya. Tputs nuwaa natstarundama átu, waanaatsi wach izuuru kamispa kámanarangu, wamarsha mshipaneempaz ashiru k'tuntarangiya. Utaárinee ngootsush tsangayaru, yaktanung Enayimanungsha ngootsush kuxinxinaw ashirangiya. Mangush chinayaru, Na Sir wachinayanlluwa. Ngusiri nda nuwaa wipaa Sira yamangi átu táyaru, tsangarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Utaárinsha ngootsinung kizaa pakeeru, wchoo kamispa kámanaru, mshipanind átu, ");
INSERT INTO cbuNT_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","mapiyru, kizap naantachu, kizaatssha: Nuw shiyapa tsiyatamaam zandaktana, tárangiya. Kizsha: ¿Itaru, mayshitaja nuwaam panaychish? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Utaárinisha: Kaapraa wip zanganchinllpa, tárangu, kizsha: Ayu, waritachparee. Itaru, zurkeesha átush maachiritaatsish yuwaa payurish anoo natumasamaam pananda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Utaárinisha, Ashiri ¿mayaatseeja kuwishish kasachi? tárangu, kizsha, Shaanaa surish yandam xanurish. Tushuwshitamtish kuwishiriti ksanda, tárangiya. Utaárini maachiritaa panayaru, kizaa yutarit patatarangiya. Anumun kizsha mireerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Anumunsha, Támararin natamari, kamisaa kámanashee kasayaru, yusursha mashindoo wamar kamartarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Zapishsha, Utaárini kaapraa wip wamkurish Iraásh Adulamshuchish tputs zanganirangiya. Panayarush, nuwaa maachiriti yusur kiz tuwanpuchpa, táyaru zanganirangiya. Wamkursha kizaam nachungarangitaa, itaru ndusha parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Anshucheetssha tputsee mashirangu, ¿Mshipaniwa kiza? ¿Enayimanung ngootsinung kuxinarangu anuwa? tárangiya. Anshuchsha tputs, ¿Nish ngootsinung kiz mshipan antaati taar? Wanindaja, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Wamkursha Utaárinip xunaru kanapurangiya. Utaárineetssha: Kizaa naxpoorangina. Anshuchshitin tputs nuwaa, Mshipan nish ngootsinung wanindaja, táranganaya, Utaárin wamkuri tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Utaárinisha: ¿Tamaycheezich? Maachiritaatsi kiz waanipari payuchiya. Ashkachu, tputs nuwaa stamaam pinasachpasinaya. Watam kaapraa wip shiyash zanganirangtaati; itaru shiysha naxpoorangshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tuchip tsup tushiyaru, anumunshat tputssha Utaárinish kuseersin, Utaárineetssha: Ngusirimunish Támar mirimshatanda. Tputspat ipunarangu mireerangiya, táranganaya. Utaárinsha kizpur tsiyantayaru, Ashiri Támaraa arap kapeeteerus, sumaspat mucheerus ksangtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Itaru, Támararnee putarangusin, uwshat tsiyatssee ungsireem zanganirangiya. Támararinsha: ¿Chakamasaja nee maachiri amuyaya? Watacha tputs nuwaa yutarit patatarangu, nuwsha mireerangi. Natu, shaana napangcha. ¿Chakaam nimun sura yandara? Mishat, ¿chakamta in tushuwshirinee? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Utaárinisha waanaatsi maachirit pakeeru, ¡Maa, xam! Támar yutaritaja kiza. Itaru, nuwcha yutaritti, watam ipareemi Siraam wizanlli nda panaranginawa, tárangiya. Táyaru, anamunsha ayamtaati ndusha yusur Támararinee yutarit patatamaam chinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Zapish Támararin tatsipurangu, nlluraa kamuz tsimbun iwiparu tatsipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tatsipkachu, anush nllursha uw paxayarangiya. Kizsha istampaneew anoo pakeeru, ir chumbeepimashpa uwimun tupazurangiya. In watacha chtaru shitungarangu anu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Táyaru, nllursha yusur uw yanpurangiya. Itaru, misha zoonllsha shitungarangu anumand istampansha nlluraa sur Fares ísamarangiya. Watam shiyma chtaru shitungarangshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Anumunsha, nllur uwimun irupa chumbeeppa tupazoom shitungarangiya. Anootssha sur Serah átsha ísamarangiya. Ashiriya, na kamaneena yuwaa Támararni Utaárineetsi tamapingarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ashirucha, Ismaelchich tputs Osiyaa paxanxeersin, Ijiptopsha tsap machtaranganaya. Ijiptosh kurak sur Potifar taarangiya. Potifarsha Osiyaa paxanxarangiya. Anpursha Potifar kizpur kurakamuna, parawarin wasundurur urkarimuna. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Itaru, Osiyaatssha Apanll kapung chinarangu, nda kasarangiya. Urutamari Osiyaa Apanll ksutarangiya. Ichingaru uwamari wanasir shitungarangiya. Wamari nllur ashirangiya. Osiy upaturunarish pang' taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ashirucha, upaturunarsha Potifar natstarangu, Nee nlluraa Apanll kizpurcha chinaksha. Ashirucha, uru Osiyaam ichingaru wanasir shitungkiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Osiyarinsha kizpur wanasir taarangu, ¿Tamaa in nllur wanasirimashtee? Nee nlluraa pangeemi ksutamapaneem wayachima. Waani kurak tamapari ashiru pangeetsi ksutataw ashku taachiya. Mangpatari uwshat pangeetsi ksuchiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","6","Ksutamapaneem wayayaru, Apanllsha Osiyarineetsini kapung istarangiya. Apanllsha Potifareetssha kapung istarangitamta. Ijiptoshcheetstaata Apanll kis naparangiya. Mazareetstam, pangootstam maachiritam zapan izapaneerangiya. Potifarsha mapiyru, pangoo, mazareetstam wanasir Osiyarinish uw kasayaru, yuwaatstam waanaa amuy payurangu anootstam, ashpari: Shiyshat ksutangcha, tárangu, Potifarsha katungamaamsha katungku pangush taarangiya; ndushat maachiritpa mapeerangiya. Wamarisha Osiyamari kizpur wanasir kanungas taarangiya. Wazan wanindamuna, waatsimari tputs pakchusin tpustaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ashirucha, ashimatseeru, Potifarsha wizanll parangu, ¿In kanungas tamashta? tárangu, nazandarangiya. Natu, Osiyaa, shiyapasha maayani, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Itaru, Osiyarinsha anoom nda zandarangiya. Uwshat: Na mazinanlla. Nuwaa paturunari pangoom ksutamapaneem ínayaru, kasarangiya. Ashirucha, na ashpari yuw paturunari maachiri taaru anoo, na wanasir ksutkuri taakina. Amb ashkuri, paturunarshiti uwshat mapiyrtam kamingeenll ashkiya. Ndushat mapeekiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Itaru, nuwamari ashiruri, nish pangus taakina. Paturunarshiti nuwaa paku, mapiyrtam ichingaroo nuwaam kaminkasha. Itaru, paturunari shiyaatsimari wizanlleetseeru nuwaam pachindkiya. Ashirucha, nuwshat ¿tamareeja paturunareetsi yutaritash wayachi? táshina. Amb ashkachinaareena, Apanllee kuk nuw kapeetkina, tárangu, ngatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Itaru, kizsha nda pazirangiya. Aranginasha ichingaru zar muntarangiya. Putam muntat, putam muntat ashirangiya. Natu nuwapa maayani. Kis ipuneeni, táta táta ashirangiya. Itaru ashirangtaa, Osiyarinsha izuuru ngatamari ngatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ashirucha, kizsha xapooyaru, Osiyaa tamapingarangshita. Minushshat zar Osiyarini upaturunarish pang' tarawaztapi átu pshtuyaramchu, mapiyru, upaturunarish pang' pshturangiya. Tputs kurimunazimuna anush pangusi. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yap nda chinaru anush kizsha Osiyarineets wamar putarangiya. Natunaa shiyapa tsiyateeni, tárangiya. Itaru, Osiyarinsha wamareetsim tuwapimashee tushuranllu, anshuri kasayaranllu, pangusish shitungaranllu, teet ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Itaru, kizsha kamuz shitungeenllu, anoo paru, kamazeetsimsha yarangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","minungazsha muchchur kapung kuruzutar ashirangiya. Mangutarisha ngicheeru, Napangints. Kamuz nuwaa muntayaranda. ¿Ndushat zaranlli Potifar nish panguseem ksutamapaneem ipuseeru ínarangu Hebrewshuchee nllura? Nuwaa mantsir patatamaam zandarangu, itaru nuwshat puniranguri, kapung ay táyachuri, ");
INSERT INTO cbuNT_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","anoo siyaa mazinayanllpasinaya átu, puniku, iripuranlliya. Mangu wamaree punirustachu, nuwashurisha tandapuni mbizatachiya, tárangu, Osiyaa wamar yáyaru, tputseemsha yámandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Itaru, kamazee nda Osiyaam tuwanpurangiya. Zaranlleemshiti kuskachu, yámandapi átu, kamazee pishurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Zapishsha, wazaranll kuseeramchu, wazaranlleetssha mangu ngicheeru, ambitam táyaru kamanirangiya. Wazaranllee: Napanganlla. ¿M'chachurish nuwaa tamayarimta? Hebrewshuch nllur nuwaa kapung muntaranganda. Nuwaa mantsir patatamaam zandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ashirucha, nuwshat punikuri, kapung ay táranguri, tputsingaz kuruzumbapuri anoo puniku, nuwaa kasaranshat shitungaranllu iripurangiya. Mangu wamareetsimsha mbizatachiya, watacha ini wamari, ");
INSERT INTO cbuNT_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","tárangiya. Potifarsha anoo mazinarangu, kapung tsiyantarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ashirucha, wasundurureetssha kamachtarangu, Natu putayarus, tumanshiship macheerus tumanashinints, tárangu, wasundururshitisin Osiyaa putayarusin, tumanshish tumaneersin, kasaranganaya. Yuwashtam kurak wamachtash tumanshisheew tputs taakana anshutam Osiyarineetsi tumanaranganaya. Itaru, tumanamashtaa taarangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Apanllsha Osiyarineetsi nda kasarangiya. Kizpur Osiyaa Apanll chinarangiya. Ashirucha, tumanshishpansha urkar Osiyaa parangu, ¿Tamashta in nllur kizpur wanasir mang' kapungparee? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Osiyaa, shiyaatssha napamapaneem ínachinllpa. Shiyshat tumanamawaa tputs napangcha, tárangu, Osiyarineetsi tumanamawaa tputs ksutamapaneem ínayaru kasarangiya. Osiyarinshitini anuritam tumanshishee wanasir naparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tumanshishpan urkar izuurasha mapiyrangu, mangutarisha arapeetari tumanshishee ksutamanaa ksutarangiya. Watam Osiyarineetsshat Apanll kizpur ksutaranguwa. Osiyarinsha tumanshishee kizpuritam wanasir ksutarangiya. Ashiriya, na kamaneena yuwaa Osiyarineetsi tumanshish tumanarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Anumunsha, tputs kurakaam yásimapan urkar taarangiya. Mishat, tputs pangapan urkar taarangtamta. Anshitisin Ijiptoshchee kurak parawaa tatsiyunuchtaranganaya. Ashirucha, kuraksha paraw kapung tsiyantarangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","tsimbunari tumanshishpanipsha urkar, kapitanap zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kapitansha Osiyaa; Shiysha ksutangcha, tárangu, Osiyarinsha anoo tputs ksutarangiya. Anshat tumanshishish zapan tsup taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Minushshat zar maarangusin, tsimbunartisin anshunandari zar pamasaranganaya. Ansha pamazuksin, minuritam pamazuku, uwshat minuritam pamazuku ashiranganaya. Yuwamaritam ashchinllina anumaritam pamasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ashirucha, Osiy putamsha taraseechu, tumanshishush napku, tsimbunartisin mang' mantsataranll ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Uwshat Osiysha parangu, masharangiya. ¿Mayangaz mangis mantsataranll ashiksa? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","uwshtisin: Maaranguni, mantsir pamazuranginiya. Anoo ¿mayaama amb pamazukuch ashtarich? atuni, yasangsani atiniya. ¿Chakza kamanpanda? atuni, mangini mantsataranll ashkiniya, táranganaya. Itaru, Osiysha: Zuraktishcha. Chiynaa anoo yasamaam wanindaja. Waana Apanll wasina yasakiya. Siysa na kamaninda yuwaa pamasarangis anootsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ichtaru yásimapanima urkar ashpari yuwaa pamasarangu anoo ichingaru Osiyaa kamanirangiya. Kamanku tárangiya. Na maaranlluri, miranish pamasarangina. Kizarunaa wanus zapani parangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ansha kizarun minum puch xiyaru, itaru tuchip pzeenarangiya. Ashpari piz tuchpari waroom yawtarangu, naturitam chaptarangiya. Natamatam wanuseemsha kinarangiya. Anuritam kayanaranshita. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ashirucha, nuwshat kurakaa parawaa mánguwaree yáyaruri, anush kamiyayawuri, wanusee tatsirapshirangina. Sheeruri, wakungureemsha tinaranguri, kurakaamsha parawaam yásirangina. Kuraksha paraw waarangiya. Ambcha pamaskuri ashirangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","13","Osiysha. Yuwaa pamazurangish anoo nuw itsinsarunll kamanchinllpa. ¿Ndushat yuw tuchip pzeenaru parangish an yuwaamtam nimun tuchpashtam zar ashtachish? ¿Ndushat anoomtam ashkish? Uru nimun tuchpashtam zar kurak paraw shiyaa yusur tashitungachiya. Yusur shiy yásimapaneemtam urkar kinachsha. Kinaramchush yusur kurakaamtam parawaam mangawash tipayarush, vinoo yásichsha, sirú tamatarsha yusur ambitam ashtaachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Itaru, shiyshat kanapkachush, nuwaa mbizariyshpa. Kanapkachush, kurakaa parawaa kamanimantar shingcha nuwaatsshat tashitungamaamtamta. Shiyshat nuwaa nayningandama. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nuw sirútama Hebrewshutaa taaranguri, itaru nuwaatssha tupaxanxarangshitisin, tputs shuchirangunda, tsapuneetsi kasaranguri, na nishsha tumanshishsha taakina. Nduntaa yutarit maacheetsi patataranguri, msangarusin nuwaa tumanaranganaya, Osiysha ántar tsiyatku ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ashirucha, pangapansha urkar yuwaa pamazumaa wanasirimshee kamanirangu anoo, Nuwshat zuwaa, yuwaa pamazurangi anoo kamanchinllpa. Nuwshat pamazukuri, tuchip tsumb pangaa mburshimashee tatsiteeranlluri, muchimuni ktundumbayaranlluri, kuktaranll ashirangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Iwazchirini, minumtam tsumb yuw parawaampa ini táyaranlli, anushsha pang' yapandaru pshtarangina. Anoo kurakaam parawaam panati táyaranlluri, nuwaantana kuktaranlluri, yap nda chinari anush mangu íwarpichsha purangataranllu, pangareetsi katungaranganaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Osiyshat anoo mazinarangu, kamanirangiya. ¿Ndushat yuw tuchip tsumbu átish anu tuchpamtam zar átish? ");
INSERT INTO cbuNT_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nimun uru tuchip zar maaramchush anush kurak paraw shiyaa ishitungaramchu, yarpunishish wasikpashat spuyarusin, yasinamun yuwar kayxukchusin, nutseetsish yapsha katungchinllinaya. ¿Ndushat anoom ashirangish? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ansha tuchip zar maaramchu, anush kuraksha masachirini tatsameeru, kapung michinzeem wayarangiya. Anshuchee kurak ksutamapanee ashpari yambirangiya. Tiptsireetssha tumanshiship, zanganirangiya. Natu. Yásimapani urkar tumanshishshu ishitungashinints, pangapanpatari urkari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ashiriya, tputsee tsimbunari ishitungaranganaya. Yásimapaneetsim yusur yásimapaneemaritam urkar ínaranganaya. Yásimapan urkar kurakaa mánguwar yusur yáyaru, vinoo tipayaru, parawaam yásirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Itaru, pangapaneetsshat urkar yuwartatam Osiy kamanku tárangu anuritam tuminurangiya. Wayarpunish spuyarusin, yasinamun yuwar kayxuranganaya. Sheeru, yapsha wanutsee katungarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Itaru, yásimapansha urkar yuwaa Osiy nayaningandama tárangu anootssha izuuru mbizarangiya; nda kamanirangiya. Ashiriya, na kamaneena yuwaa Osiyarin uwshat tumanshishee ksutarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Anushsha tsimbun masach tushiyramchu anush kurak parawarini pamazurangiya. Miranish kungumun Nilomun wing naantach ashirangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","anushsha wakar wingumun tsimbun matayaru shitungeeshinu, kizpur wanasirinand wanutssha kapungunandtamta. Chirichiree katungkusin, chirichirish shaneersin parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Anoo arangeemsha napku, ashpatam tsimbunatam matayaru wakaratam parangiya. Itaru, ansha wakar kizpur mantsirinanda; xangitamawa wingumuntam shanee ashiranganaya, yuwannungitam wanuts kapungunand shaneerana annungitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Itaru, ashiritaa wanuts xangitamawtaa, waamarisha wanuts kapungumasheetsimarisha zayaru katungarangiya. Anush parawarini támarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Arang yusur maarangiya. Anush yusur minootssha pamasarangiya. Anshat yusur naantachu tirikootssha parangiya. Tirik minum puch xiyaru, wayasinarsha tsimbun matayaru taarangiya. Wanussha ashpari wayasinar tuwapinandarita. Wachsha kapungumashinandarita kizpur wanasirimshinandarita parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Yusur arangeemsha napku, tirikutam tsimbunatam matayaru wayasinar parangiya. Wanussha taamana taarangtaa, itaru mantsirimshinandarita; wach mchusanandarita kizpur mayapshimananda. Anushsha zar kizpur zatarangu, ashparit mchiroorangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Yuwamaritam wanus mayapshimananda anumaritam tirikpatatssin wanasirimsheetsimari katungarangiya. Amb ashiru, pamazumaztaru anush yusur parawarini támaranll ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Putamsha támeesha mangush chinachintar ashirangiya. ¿Mayaamaja ashtarich? ántar ashirangu, tputsee yasampaneewaatsi, tuwachima yasarana anpaneewaatstam, Ijiptoshuch wazurireew yasampaneew taarangana anoowaatstam kuruzurangiya. Ashirucha, tputssha ashpari yasampaneew kusatarangsin, anootssha ashpari pamasamarineetsi kamanirangiya. Itaru, tputsshitisin minamtiyam nda yámaranganaya. Ashpari xapooranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Yásimapansha kurak, ¡Maa, natunaa kurakaa, chinayana! Nuw yutarittana, watam sirú shiyaa nda kamaniranginawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yuwapur shiy kapung tsiyantarangush, pangapanee urkar, mishat nuwaatstam ashiru, kapitanaatssha kamachtarangush, kapitansha iyaa tumanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Iyshat tumanshishish taar ashkuni, minushsha zar pangapan urkar minum pamasarangu, nuwshat anpuritam zar pamasarangtamna. Itaru, nuwshat minuritam pamasarangina, yapiritam ashtachi anumaritamta. Pangapansha urkar uwshat waanitaritam pamasarangiya yuwamaritam ashtachu anumaritamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Itaru, anpursha anshutam iyaa ksutarangiya, kapitan urkar tiptsiri tumanshishee napamapani. Ansha nllur kanungasi Hebrewshuch tputsi. Iyshat yuwaa pamazurangini anoo kamaniranganiya. Uwshat itsinsaru, Nuwnaa yasaktana tárangu, kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yapiritam tárangu ambiritam iyshat tuminuranganiya. Na nuw tamarangimna, yusur yásimapaneemtam urkar kinarangina, yuwartatam tárangu anuritamta. Nda ngichkina. Itaru, minootssha pangapanee urkar wayarpunish spuyarusin, yasinamun yuwar kayxuranganaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kuraksha paraw anoo mazinarangu, Ashiri natu yamashinints, tárangu, tiptsirshitisin ayu tárangusin, Osiyarineetsi mikeersin tumanshishish ishitungaranganaya. Sheersin, muchootssha wanasir kumaranganaya. Wamareemsha wanasirimshitam yáyarusin, túmartaranganaya. Sheersin, Osiyarini kurakashsha parawash naantachu kuseeru, ¿Mayaa kurakaa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Parawarinsha tárangiya. Nuwshat pamasaranguri, ¿Chakza tputs yasampani kamanpanda? aturi, kapung mangi mantsarangina. Itaru, shiyamunsha k'kuzee mazinaranguri, shiyaa anoom yasapi túri, kuruzurangina, parawarini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Osiysha tsiyatarangu. Itaru, nuw kaapa yasaktamtazi. Itaru, ¿tamapareeja? waana Apanll kamanimaam taarcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ashiri parawsha pamazumarineetsi ashpari kamanirangiya. Nuwshat maaranguri, mirnishat pamasarangina. Kungumun Nilomun wing naantach ashiranguri, ");
INSERT INTO cbuNT_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","yap nda chinari amb wakar tsimbun matayaru shitungarangiya. Wanuts kapungunand chirichiree katungkusin, shanee ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Arangeemsha napkuri, wakaratam tsimbunatam matayaru parangina. Itaru, ansha wakar kizpur xangitamawa, ashim nish Ijiptosh wanindaja. Ashima nuw minumtiyam wakar patareezi. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Itaru, ashimawtaa, xangitamawtaa, wanuts kapungumashee parangusin, waamaritin zayarusin, katungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Itaru ashirangtaatssin, wanuts kapunguwaa kachingarangtaatssin, nda wanuts pakchiyam sitatseemaam zandarangiya. Anuritam xangitamaw ashiranganaya. Yuwaa ashishtarana anoo nuw támaranll ashirangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Sheeruri, yusur maats zuw ashirangu anush yusur minootssha pamasarangina. Ansha, naantachuri, tirikootssha minum puch xiyaru, wayasinarsha tsimbun matayaru taarangiya. Wanussha ashpari wayasinar wanindanandarita; kizpur wanasirimshinandarita. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sheeruri, yusur arangeemsha napkuri, yusur tirikootstam xiyaru parangina. Tsimbunatam matayaru wanasinar taarangiya. Wanussha ashpari taamana taarangiya. Ashpari wach mchusananda. Kizpur mayapshimananda. Anushsha zar kizpur zatarangu, ashparit mchiroorangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Itaru, ashiritaa wach kapungumasheetsimari katungarangiya. Ashpari wanus wanasirimsheetsimari kachingarangiya. Amb ashiru pamasarangina. ¿Mayaam ashtarich? tápi táranguri, ashpari yasampaneetstam anoo masharanguri, mangu ashparitin yasamaam pinasaranganaya, parawarini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Osiyarinsha: Ichee, yuw tsimbun pamasarangish anu, anush minumari tsiyatsis taariya. Apanllcha waana ayam ashtachu anoo shiyaam tuyamandaku ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ashiriya, ¿ndushat yuw tsimbun matayaru wakar wanasirinand parangish, mishat yuw tirikoo tsimbunatam matayaru wayasinar parangina átish anu, ndushat tsimbunamtam matayaru masach ashtachish? Anoom ashirangish. Yuw tsimbun pamasarangina átish anu, anootstamtanda ashirangish. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ashiriya, yuw wakar tsimbun matayaru wanuts xangitamanand parangish anu, ¿ndushat yuwaam nish tsap tsimbunatam matayaru masach katungats maringachu anoom ashirangish? ");
INSERT INTO cbuNT_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Uru ambtanda ashtachu, nuw táyanlli ambiritam ashtachiya. Watam waana Apanll yasaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nimun iwaz tsimbun matayaru masach nish uru katungats zapan pangachchee. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Itaru, anamun iwaz tsimbunatam matayaru masach katungats kizpur maringachiya. ¿Yapeeja chiy katungtsee yáyaruch katungeechich? Amb ashkachu, nish tsap Ijiptosh ashchiri maringakchu, yuwatamsin katungats zapan payurangana antamsin ashparitssin watungash maringachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Uru kapungtanda iwariz maringachu, sirútama katungats zapanimuna, ndushapari na nimun ashtachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Anoomtanda kurakaa, shiy tsimbun pamazurangish. Apanll waana ashtachu anoo yasarucha tuyamandarangasha. Uru nimun mikeerupa ashtachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ashirucha, ichi kurakaa. ¿Ndusha tputseem nachunganda át? yuw kizpur yasampani, mangu kapungu an. Ipuseeruch, kizpur kurakaam ínamaam taar, neem tsap Ijiptoom ksutamapaneem kupeernoom ínangcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mishat, nuwsha atashina; Shiysha kurakaa nllitaritaa tputsee kamachtangcha tputsee mázari napamaama. Tputsshitisin wanusee pusakchusin, zameetpat kóstar tatsichinllinaya. Sheersin, anchich minamtam kóstar tatsitam yáyarusin, kurakaamshat panachinllinaya. Watam naturitana nimun tsimbun matayaru masach katungats zapan taachuwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ashiriya, amb ashkachu, kupeerunshapari uwshat katungtsee xanatchiya. Yaktashuch ichingurusin katungatsee xanachinllinpa. Tsimbunash matayaru masachi, zapansha xanatachu anush katungats ashchiri tsap nish maringachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ambinaacha sheeruch, xanatachuch katungats maringaktaati, tputs nda marizimun pchingchinllinaya. Waamaritin tsimbunataa matayaru masach taachinllinaya. Anumunarisha katungkusin taachinllinaya. ¿Siy amkimsa? Nuwnaa amb shingints átana, Osiyarini tárangiya. Ashiriya, na kamaneena yuwaa Osiyarini parawaa pamasamarini kamanirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kuraksha parawarini, kupeernuwtam wamachtasheew, ichingarusin Osiyaa kuk kis mazinarangusin, Osiyaa kurakaam ínamaam mangush chinaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Parawarinsha, Nee nllura kasayaruch, ¿yapeeja tputs ashim in Apanllee wan payuru anoo pakeechich? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Osiyaatsshat; Apanllpa shiyaam mangeemish panarangiya. Napa nee ashpari natstarangsha. ¿Antaati shiyaa tputs kasiru wanindaja? ");
INSERT INTO cbuNT_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ashiriya, shiyshat nuwaam ipunsheemi kinangcha. Kurakaa tsipasawa shiyamari kasiru ksutkush taachsha. Ijiptoshuch tputsiri ichingarusin shiyaa k'keetsish payuksin taachinllinaya. Itaru, kaapa nuw, nuwamari shiyaa kasiruri taachina, watam nuw kapung kuraki kupeerninawa. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Na mazinangcha, na in nuw shiyaa kurakaam ichingaroom Ijiptoshcheem urkar ínachinllpa, Osiyaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Anuritam paraw anichoorineetsi yuwaa pazuku, kirakaa anpatari seechtaku anoo yusheeru, Osiyaamsha tupazurangiya. Arang yusur wamareemsha yáyritam kizpur kamaz wanasirimash kurak kamartakana anoo túmartarangiya. Xanoomshat kizpuritam wanasir oroonandarita tuxantarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Sheeru anumunshat, kapaachushsha kurakush pshiyrshini izaruranganaya. Sheersin, anush yaktash naantach ashku, ichingarusin zamangaranganaya. Papcha, kurak naanllpa. Karartangints, tputs kizpur tsiyatku tárangiya. Paraw Osiyaa kizpur kurakaam ínakchu ashirangiya. Ashirucha, Osiysha Ijiptoshcheem tsap kurak ksutku taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Anumun yusur parawarini Osiyaa: Nuw kuraki shiyaa kizpur kasirtaateena, itaru, tputssha shiyaatsimari k'keetsish payuchinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Na nuw shiyaa surish ísamachshaparina; Ijiptoshchirisha k'kuz Safenat-Paniya átu ísamarangiya. Anumun wizanlleemsha panarangiya kiz sur Asenata, Potifera wipa. Potifersha pátireem urkar kinaru, Unush yakat sur taarangiya. Ambi ashiramchu, Osiyarini tarawzoom chtarangiya. Ijiptoshchee tputs itarawaztamaama. Ashiriya, na kamaneena yuwaa Osiyaa Ijiptosh tsap kurakaam ínarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yuwapur Osiy kurakamarisha kinarangu anpur 30 masachirini taarangiya. Anushsha kupeernoo parawaa tarawzir kamachtamaam naatarangiya Ijiptosh tsapu. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sheeru, 7 masachi tarawuztaranganaya. Yuwapururi katungats iwariz taarangu anpuri zapan pusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Anushsha Osiy pangusish katungtsee zapan yáyaru xanatarangiya. Minush yakat xanata, minushsha yakat xanata ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Osiysha katungtsee ichingaru zapan zar xanatarangiya. Mazach tamatarpari ashiru táchimaam pinasarangshita. Aship an tirikoo xanatarangu, yuwaa táchku anoo kasayaru, ndusha táchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Anush masach ndaturi katungats maringaru, Osiysha wizanllish Asenatash wip tsimbun wanindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Osiy wipaa iwachiztama sur Manases ísamarangiya. Apanll nuwaa mangooz mapiymash panarangiya, maachiritaatstamti ashpari mbizamaama amb átu, wipaa ísamaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Minootssha tsimbunarneetsshat wipaa sur Efrayin ísamarangiya. Anootsshat, Apanllpa nuwaam kapung istarangandanaya; nuwaam ipareemi wanindamaamaya. Watam Ijiptosh tsap kiyung kachiykuri taaranginawa, átu, wipaa ísamaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ashiramchu, Ijiptosh tsap ashchiri anumun 7 masach katungats kapung taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Anumunsha 7 masachitam katungats maringchiya, Osiy tárangu anuritam tatsamoorangiya. Amb ashirangu, ichingarup tsap maringaranganaya. Itaru, Ijiptoshsha tsap nda iwariz pshatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ashiri Ijiptoshuchsha tputs marizee tácharanganaya. Tputs ashpari mariz kayatarangusin, parawangaz naatarandsin, mashkusin, parawsha, Nuw nda kaapa yasarina. Natu kurakpina Osiyap napashinints. Amb mashangtsa. Uwshat, ¿amkachimasaja? Siysat anuritam kukoo payungtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Katungatssha Ijiptosh tsap ichingaru maringaramchu anush Osiy katungtsee xanatshish pangus tawatarangshita. Sheeru, Ijiptoshuch tputs kuskana anoomaw tupaxanxamaam chtarangshita. ");
INSERT INTO cbuNT_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ichingarusin arapcheewtamsin watungash kachingarangu, Osiyap katungats paxanxani atusin, Ijiptopsha tsap naatartaranganaya. Watam ichingaru yakat katungats maringaranguwa. Ashirucha, Ijiptopsha tsap tputs zapan katungtsingaz kuskustarach ashiranganaya. Ashiriya, na kamaneena yuwaa Osiy, 7 masach katungats maringachiya, tárangu anuritam katungats maringarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Akoparini taar ashku katungats maringarangu, zapish tsiyatseetssha mazinarangu, Ijiptop tsap katungats tirik zapantanda taaru tárangusin, anoo mazinarangu, wipaatssha: ¿Tamakinaaris mangutaritis shanee ashiksa? ");
INSERT INTO cbuNT_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nuw pakich tsiyatssee mazinarangina, Ijiptop tsap katungats zapantanda taaru atanaya. Ashiri siysat amb naayarus iyaam katungshini tirik pxanxashinints. Papcha, ndunnaa ashkuch ¿mayaja katungeechich? Uru marizimun tsipamaam taariya, wipaa tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","wipshitisin anuritam waparee kuk payurangusin, ashparitssin zoonllinandari 10 káyarandsin, Ijiptop tsap tirikungaz paxanxkatssin, naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Itaru, Akoparinsha wipaa shipamuncheetsina Benjaminaa, Osiypat washunandari nllurtarangana anoo amb zanganimaam pachindarangiya. Watam mangush chinarangu, Apaz mantsirimashsha k'kuz tushiykchu, átu pachindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ashirucha, piyartachimarisha wip mishat, Kanaanshuchtamsin tputs ashpari amb katungtsingaz paxanxkatssin naatartaranganaya. Watam Kanaanash tsap ashchiri katungats maringaranguwa. Ashirucha, ambsha paxanxkatssin naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Anpursha, Osiy kurakamuna; Ijiptoo tsap ashchiri ksutarangiya. Tsapurunashuch tputs arapcheewtaa taarusin, Osiyash kusta kusta ashirangsin, Osiysha katungtsee tupaxanxat tupaxanxat ashirangiya. Ashirucha, Osiysha zoonll kuseersin, Osiyaa tasaseersin, kurakaa ungirtaksin, tutunllta, timuchta, ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Osiysha zoonllee pakeeru, ashpari zoonllee natstarangiya. Ndunpaz tputsee pataruch ashiru, tsiyanuspatari tsiyatarangiya. Ijiptoshchish k'kuz tsiyateeru, tárangiya: Siy ¿yapimandsha káyashinsa? tárangiya. Uwshtisin: Iy Kanaanamand tsap káyashininiya. Nish tirik paxanxani táyaranlluni, naataraniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ashiriya, Osiy zoonllee ashpari natstarangiya. Itaru, uwshtisin Osiyaa nda natstaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Osiysha yuwaa sirútama nllurtama pamazurangu anoo mangush chinarangiya. Ashirucha, anoomand tsiyantakpaz ashirangu, Nuw siyaa natstaktana. Siy tputsis tamapingampantischa. Iyashcheecha tsap naarani táyaranllis, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Uwshtisin Israelshuchish kuk tsiyatkusin táranganaya: Nda kurakaa; amb tárinllpa. Marizimuncha tsipakchuni, pzaa, katungats paxanxani, táyarani. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Iy zuwanllinandaritani; apapanandari wip káyaranlluni naataraniya. Iy tputsini yutaritazini. K'kuzee payumpantanicha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Itaru, Osiysha anoo nda kis mazinamaam zandarangiya. Nda, siy ngichiktischa. ¿Antaati siy zurmapaneezis? ¿Ndushat mangutis tamapingakatus, nee yakat narkatus naataranis, minush zar pachapani átus? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Zoonllshtisin, Nda, kurakaa. Washunand ichingaru 12 taarininya. Itaru, minumtam zuwanlleetsini nlluraa ambiri apapshuri kasayaraniya Kanaanshuri tsapu. Minumtam zuwanllini tsiparangiya. Na 11 kchitini taariniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tárangitaatssin, Osiysha anoo mazinamaam nda zandarangiya. Ashirucha, yusur: Nda ngutis átssa. Nuw siyaa yasaktana; siy tamapingampansa. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ashiriya, zurkeesa átus, ¿tamapari na nimun siyaa yasamaam yachachintspa? Parawamun sur aturi, antaati tsapunpis kanapcheezis. Na in siy shitungamaam wanindaja. Nishuripa tsipatssa. Itaru, nda ashishtamaam ichtaru zuwanllimasis shipamunach yamashinints. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Natu, minamtamtis naayarus, wapitam zuwanllis yamashinints. Itaru, ashpatamtis nishuri tumanshishshuri kutangints. Zurkeesa átus ¿tamapari yushindatssa? Wandaya nda yushindakus, mangutis ngichkachus, siy ngutis tsapoom narkatus kusarangsa. Siyaa uru nuw táchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Amb sheeru, waanaa zoonllee tputsee tuchip zar tumanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sheeru, anush Osiyarini waantatam mangush chinarangu, Nuw Apanllee kapungcha chinaki, mangush tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Zoonlleetssha: Kustarishis tirikoo tatsiteerus, maachiriteemis naayarus, panashinints. ¿Mayaja iparis katungeechinllina, apareemtamtis? ");
INSERT INTO cbuNT_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ashiri natu mikeerus naangints. Zuwanllis nllurarini yushindangtsa, yuw ambiri kamingaranganiya átis anu. Zurkeesa átus, ¿tamapari amb ashtatssa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Zoonllshtisin waanshuchtarishtisin kuk tsiyatarangsin: Apanllpari iyaa waneekiya yuwamand zuwanlleetsini kiyung Osiyaa yacharangini anumandaya. Kapungtaa punirangu, mang' mantsarangitaa, iyaa, Ksanganda, átar ashirangtaa, itaru iyshat anoo mazinamaam nda zandaranganiya. Anumandpari iyaatssha na Apanll waneekiya, tárangusin. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Zoonllsha Ruben yámaranllu: Nuw ¿amarangparina? Nuwaana watsta; ¿mayaamaja zuwanlleetsini kiyung yachachich? átar ashirangtaati, itaru siysat anoo nda mazinarangsa. Ashirucha, amb ashirangtasa, natsha in ¿tamakimta? Anumandtanda Apanll iyaa waneeku ashku yuwamand, Ngicheeruni tsiparangtanda, atini anumandparee ashkiya, tárangiya Rubena. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Osiysha k'kuzee wazaree kamanimapan tputsee wayayaru, uwshtisin zoonllpa tsiyataranganaya. Zoonllsha Hebrewshuch kuk tsiyatarangsin, Osiysha Ijiptoshuch kuk tsiyatku ashishtar ashiranganaya. Itaru, Osiysha yuwaa zoonll ántarana anoo mazinazinaw ashirangiya. Itaru, uwshtisin mangush chinarangusin, Ninaa tputs iyaa k'kini ndunpari mazinakiya, ántangat ashiranganaya. Mapiyrsin waansshutarit kuk zamamtangat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Itaru, Osiysha yuwaa ántarana anoo mazinarangu, kapung tanurangiya. Tanukuri, sureetsi parundama átu, watandpunush yuwash tputs ndunari anush pshtuyaru, kapung tanurangiya. Sheeru, sur tsíparamchu, yusur shitungta sheeshinu, wasundurureetssha: Natu, putayarus, tumanashinints, tárangu, wasundurursha anuritam Simeónaa putayarusin, kamuriyarusin, tumanshishish tumaneersin, kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sheeru, anamun yusur kamachtarangiya. Natu, tirikoo kapunguri panangtsa. Sheerus, urkirtam yáyarus, kóstarinshini pshtayarus, ksangints. Anamun yusur watungasheemsha zapantam yáyarus, panangtsa, yuwaam apus katungchinllina anooma, tárangiya. Muchchurshitisin anuritam ayu táyarusin, Osiyaam zoonll panarangana. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Osiysha zoonll tirikoo yáyarusin, burrumun ush tuchipayarandsin, yátaranganaya. Waanpeetam watsapuniptam kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Apussha ngootsish tapitaranllu, anootsirisha maakamchusin, min zoonll: Burruri mariztayanllpari. Tirik yáyaruri, maritachimasima, tárangu, kóstarureetsini tapureeru, napta ashku, anush kuriksha, waantatam urkir, pshtaru parangiya yuwatam tirikumand tuwapanllu anutamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ansha paranllu, Xam. ¿Tamaki ashtar? Kurikiritamti tuwanpuyaranda. Na napangantsa, tárangu, zoonllshitisin parangusin, kapung puniranganaya. Puniksin, tátat shitangat ashiranganaya. Waanpatatshitisin tsiyatarangsin, ¿Maymandamasaja Apanll waana iyaa waneeku ashkiya? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ashiramchusin, naayarandsin, zapishsha Kanaanashsha tsap kuskamchusin, wapareetssha Akopaa kamanimantangatamach ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kamankusin, Apaa, kupeerun Ijiptoshuch kuk kizpurcha iyaa tsiyanuspa kapung tsiyatarangiya. Siy tputsis yutaritamashpansa tsapoompari narkatssa, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","iyshat itsinsaruni kamaniranganiya. Nda, kurakaa. Antaati iy tputsini yutaritazini; k'kuzee payumpantanicha, tamapingampaneezinee, iy minumtiyam tsapoo naarani atuni kustareezini. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Iy zuwanllinandaritani apapanandari wip ipuneeranlluni naataraniya. In ichingaru apapanandari wipa. Itaru, minum zuwanllini tsiparangiya. Zuwanlli nllurarini ambiri apapshuri kasayaraniya Kanaanshuri tsapu, táranguni, ");
INSERT INTO cbuNT_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","itaru, anshuchsha kurak: ¿Tamapari siy tputsis zurmamsheesa ashirus? Nuwash minumtam zuwanllis ksangints. Sheerus, ashpatamtis naangints. Tirikuris ambiri payutatssa maachiritis marizimun tsipakatchinllinpa. Natu neewa. Tirik yáyarus naangints. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Itaru, amb sheechus, zuwanllis nuwash yushindakamchus, anush nuw siyaa natstachima. In tputs zureerusincha, táshinllinaya. Antaati tsapoomaja narkatssin kusarangana, táchima, táyaruri, anush zuwanllis tashitungayaruri, saamatam tuwanpuchina. Annaa siy mapiyshtis tsapunpis kanapungtsa, tárangiya iyaatsi, apaa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ansha waparee kamankusin, ántaramchusin, anush kóstarootssha ashpari tapurirangusin, yap nda chinarna amb kurikeetssha yusur ashparitisin paranganaya, yuwatam tirikumand tuwapanllina anutamta. Akoparinsha kapung punirustaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ashirucha, Akoparinsha, Siy nuwaa kiyung yachamaam zandaksa. Waani wipashari taap átpasa. Napa Osiy ambari tsíparangu, na minootssha ipareetsi Simeónaatssha kapiyashinitamsa. Na yusur sheerus, minootssha ipareetsi, Benjaminaatssha machimaam zandaksa. Amb ashkachus, uru nuwshat kiyung kachiychina, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","itaru Rubensha, Nuwash kuwi ksangandama. Nuw uru ipareetsish ksutchima. Wandaya ipareetsish ambiri kapiyachuri, nda yushindakuri, shiysha anumand tsiyantakchush, nuwaatssha ipareetsi tsimbunari shaana pachambeerush kasachsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Itaru, Akoparinsha: Nduni. Ipari amb siyap naamaam wanindaja. Watam minuma zoonllin Osiy tsiparanguwa. Na minamarisha nuwash taakiya. Apaz macheerus, ambirisha mantsirimash k'kuz shitungeechu, anoo siy ¿tamayachshitazish? Uru amb ashkachus, nuwaatssha wachinaatsi kiyung yachatssa. Nuwshat zansimunari mangi mantsakchuri, anshurisha nuw tsipachina, tárangiya. Ashiriya, na kamaneena yuwaa Osiyarini zoonll Ijiptosh tsap katungtsingaz paxanxkatssin naatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Anshuri taar ashkusin, iwariz aranginasha anush tsap maringarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yuwaa Ijiptop tsap tirikoo paxanxarangana anoo kachingarangsin, mariz aranginasha kayataranganaya. Ashirucha, yusur Akop wipaa: Waptam naayarus, tirik yusur pxanxashinints. Papcha; ndunnaa ashkuch, ¿mayaja katungkuch kchitaychich? wipaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Itaru, Utaásha: Apaa, zurmana zuraktishcha. Itaru, kupeerunsha Ijiptoshuch iyaa zurampatari nda kis napchiya yuwaa zuwanllshartani kuskamchini anootsi. Watam iyaa itsinsaru tsiyatarangiya; Zuwanllis ndunnaa yushindarus, nuwash kusiyspa. Ashima nuw nda kis pamaam zandkina, táranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ashirucha, apaa, nuw ambinaa sheeni táshina. Ipareetsish Ijiptop tsap machchinipa. Amb sheeruni tirik paxanxamaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Itaru, ndunnaa apaa, ipareetsish iyash zanganimaam zandkush, iyshat nduntam naachinipa, watam kurak iyaa ndunnaa zuwanllis yushindarus nuwash kusiyspa zurampatari táranguwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Akoparinsha: ¿Mayaamsha siy nuwaa kiyung yachamaam zandarangsa? Mishat, ¿mayaamsha kurakaa msangarus zuwanlli minum ambiri taaritamcha, tárangsa? Akoparin tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tárangu, wipshitisin: Apaa, waantari kurak iyaa zapan masharangiya. Ichingaru maachiritaatstamani, shiyaatstam masharangtamta. ¿Tamaru aparis taara? ¿Aparis kchit? ¿Zuwanllis arang taaritam? tárangiya. Ashirucha, apaa, ¿tamari tputs átu anoo chiyshat kamapshichich? Iyshat itsinsartamani kamaniranganiya. Uwshat anoo mazinarangu, Zurkeesa átus, zuwanllis yushindangints. Nuwshat pangpi, tárangiya, tárangusin, ");
INSERT INTO cbuNT_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Utaásha waparee: Apaa, iyash zanganitarancha ipareetsish. Nuwaantari ipareetsish ksutchima. Ambtanda sheeruch, apaa, shiyatam, iyaantatam, ipartamani nda marizimun tsipachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Natu, apaa, iparish nuwash ksangi. Nuw uru ksutchima. ¿Tamari nuw nda ksutchee? Watam nuw nuwaantari tinawa, Ipareetsish ambiri kapiyachtaateena, uru nuwaantarisha nutsi tuwapamaam taariya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ndunari ipareetsish Benjaminaa iyash zanganimaam pachindtatush, na tsimbunannaapari amb pakeeniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Amb tárangusin, waparsha: Ashiri machingsints. Kustarishis maachi tpichingints yuw kizpur wanasirimsheewa anu. Kurakash kuskamchus, ¿mayaja panayamchis yuw yaana payukani anu? Karipan wash irimiyaam pakich yángints, kinduratamta, kzammashtam, mirraatstam, nueceetstam, ktupzatam aship wanasirimshinandari ipusatarantsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kuriktam yanlltamtsa yuw saamatam tuwanpurangu anu. Sheerus, saantawaritam kurikiris panatarantsa. Apaz mangu mamarparangusin, uru siyaatssha yutaritash wayachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ashiriya, neewa. Zuwanllis yamayarus naangints. Nee zuwanlleetsis kurakash yámandashini. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Itaru, Apanllimari kizpurcha. Siyaa uru istakachu, kuraksha siyaa nayaniku, minoo zuwanlleetsis Simoo tashitungachiya. Benjaminaatstam siyashtam tuwanpuchiya. Itaru, ndunnaa siyaam zuwanlleetsis tuwanpuku, uru nuw iparsharishaparina taachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ansha Akop wip kakchusin, kurikee yambeerandsin, zoonlleetstam Benjaminaa yamayaranlltamsin, Ijiptop tsap naataranganaya. Sheerandsin, yusur Osiyash taárash kuskamchusin, ");
INSERT INTO cbuNT_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Osiysha zoonllee Benjaminaa anshutam tachitaru parangiya. Anootssha paranllu, Ijiptoshuch kuk tsiyateeru, ksutamapanee: Natu, siy mikeerus, an tputs naanllina anoo pangipi macheerus, yapshtushinints. Minum wakar yuw wanuts kapungu an pachayarus, wanasir ptatangints tputseem martamaama. Nuwaanpatatam na zar wachamureetseem katungamaama, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Muchchurshitisin anuritam ayu tárangusin, anoo tputs yamayarandsin, Osiyap pang' machiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ashirangsin, uwshtisin nda yasarangusin, kapung puniranganaya. ¿Mayaamaja amb ashkachinllina? tárangusin, ¿Ndushat yuwapur nish paxanxeeshinuni, kóstarush mapiyruni tapurkamchuni, kurikireetstamani tuwanpuyarusin parangini, ndushat anumand putakchinllina? Papcha; putakchusin, uru iyaa muchchureemshapari tarawzupaneem wayachinllinaya ichingaru chiniptartatamaniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ashiriya, ansha pangusish yapshtukamchu, ndaturi wachoo tawataru, Osiy muchchur yuwaatssiri tsiyatpi átu, xiykamchu, anootsiri mang uwshtisin, ");
INSERT INTO cbuNT_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ichee, sirú yuwapur nish tirikoo paxanxarashinini anpur zar ndambari naayaranll ashiranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ancha apus naaruni, tapitaranllu, anootsirisha maakamchuni, kóstareetsini tapureeramchuni, napkuni, kuriksha yuwatam siyaam tuwaparangini anutam paranginiya. Anuritamtanda tatsamooru payutaranni. Na yusur saamatam tuwanpuchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nda anumarita yaanasha kurikirini zapantam yushindaranginiya, yusur tirikoo paxanxpani atuni. ¿Chakamasaja anootstaatiya iyash kóstarini kurikee pshtaranganaya? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Itaru, Osiysha muchchur: Nduni. Waritariya. Mangis mantsarintspa; punirintspa. Apanlltanda saana aparis anoo siyaam kapung istarangu, waana siyash kóstaris kurikee pshtarangiya. Yuwaana iyaam kurikee tuwaparangis anootsina nuw yarangtandi, tárangiya. Táyaranllu, tumanshishipsha naayaru, Simeóna ishitungayashinu, yuwashtam zoonll shaneerana anshutam yushindayaru, kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ashparisha macheeranllu, Osiyash pang' yapshtuyaru, kungsha watseem kupamaam tipayaru, panarangiya. Burroomtam watungasheem panarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Uwshtisin yuwaa yushindarangana anoo na kupeerunoom panapani atusin, mbursarishini yusheersin, wanasir yarkusin, Osiyaam kutaksin, shanee ashiranganaya. Watam Osiy muchchur kamanku, Natanda zar wachamuree kuschu siyapa washunand katungamaama, táranguwa. Ashirucha, anumaritam kutaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ansha Osiy zar wachamuree pangush kuskamchu, ashparitssin much tsapush timuchartata ashiranganaya. Sheersin, anamun yuwaatssha maachta yushindarangana anootssha Osiyaam panaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Osiysha masharangu: ¿Tamarim taaranaya tsapunpis? Aparis yuw siy nuwaam tsiyatarangis anuwa. ¿Na wandaritam kchit? ¿Ndaturitam tsipaa? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","anoo mazinarangusin, yusur timuchartata ashiranganaya. Sheersin, Apap naturitana kchitcha. Ndaturi tsipariya. Shiyaa kizpuritam chinakiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yuwaatssha turipingarsin shaneerana, ambsha Osiy napataran ashku, zoonllee Benjaminaa parangiya, waanaatstarisha zoonlli, wapar washunand, wanirsha washunandtam ashiru anootsi. Anootssha paranllu, ¿Waatat in zuwanllis, yuw shipamunach zuwanlli taarpa tárangis anoo? táyaru, zoonlleetssha Benjaminaa: Apanll shiyaa kapung chinakiya, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","kizpur mang' mantsarangiya. Itamsamaam Osiy pinasarangu, watandpunush mikeeru shitungta sheeru, maashipsha pshtuyaru, kapung tanurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sureetssha kungupa kupambeeranllu, itamsayaranllu, yusur shitungeeshinu, muchchuree, Natu katungtsee wayangtsa, tárangu, zoonlleetssha, Naanints; tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Osiy waanitaritam minumun mis kuxineeru katungarangiya. Ijiptoshuchsha tputs waanitaritamsin mis kuxinarangana. Zoonllshitisin waanitaritam mis kuxineersin, katungarangtamsinaya. Watam Ijiptoshuch tputs washunand Hebrewshuchpa yapandayarusin, katungamaam nda zandaranaya; Hebrewshuchee tputs tsachiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Osiysha zoonllpat tasaseeru katungarangiya. Zoonllee iwachiztamaa tuyamzayaru, anumun nllurarini arangeem, nllurarini arangeem sheeru, tushurangaru tunuxinarangiya. Ashirucha, anoo uwshtisin parangusin, waanpatatshitisin napta sheersin, ¿Tamashta in tputs arapchitaa iyaa masachirini yasak? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Sheersin, anumun katungats mbaseersin, katungarangshitisinaya. Osiysha waanamuntaritam misarini katungarangiya. Zoonlleemam Benjaminaam muchchuree kamachtarangu, katungats kapung mbaseersin panaranganaya. Washunand yapandayarusin, katungaranganaya. Anumun yusur shambatkusin, washunandtam kis waaranganaya. Ashiriya, na kamaneena yuwaa Osiy zoonllee Benjaminaa parangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Osiysha zoonll naamachinllina anoo muchchuree: Tputsish kóstarini tirik kizpur wanasir tushineerush, izuuru tatsitangtsa. Tatsitaramchush, anush kuriksha ashpartashuri kóstarini iwaziri pshtangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Sheerush, anamun nllurash kóstarini nuwaana mangawari yáyarush, pshtangcha. Nllur urkir anshutam pshtayarush ksangcha, tárangiya. Muchchursha ambiritam sheeru, tumineeru kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Putamsha, zar puturi zoonlleetssha; Ashiri natunaa burruriptis naangsints, tárangu, zoonllshitisin ayu tárangusin, naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Naataramchusin, ndaturi arap naarsin anush, musásiritam yusur Osiysha muchchuree: Natu, yap yáyaranllina amb tchitangtsa. Apusari kamatkamchus, anush siysat: ¿Mayaamsha siy nuwaa kurakari yutaritaam ínaksa? Napa, ¿uw siyaa wanasiripatari istarangu, itaru siysa mangawareetstam shuchirangasawa? ");
INSERT INTO cbuNT_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yuwash waana amuy kurak waaku anoo yarangsa. Anush waaku maachta ichingaru yasakiya. Yuw shuchirangis an kizpurcha yutarita, táshini, Osiy tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ashiriya, muchchurshitisin anuritam naayarusin, apusari kamateersin, anush yuwaa kurak kamachtarangu, anuritam kamaniranganaya. ¿Mayaamsa siy maacheetsi shuchirangsa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Osiysha zoonll: ¿Mayaamsha siy iyaa msangeerus amb átssa? ¿Antaati iy minamtiyam shuchireezinee? ");
INSERT INTO cbuNT_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Iynaa ¿mayaamaja yachini? Minush kusarangani anush kóstarishini iwaziri kurikee paranguni, Kanaanamand tsap arap kanapeeshinuni, anuritam tatsamooru tuwanpuranginiya. ¿Mayaamshitaja iyshat siyaa kurakaris mánguwar, mishat urkireetstam yachinee? Ashiriya, na kóstarishini tapureeruni napchinipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Wandaya tapurkuni, chakshumasaja kóstarini pshtaru pakchiniya. Anoo tputs pachamari pachangtsa. Anumunsha iyaatssha saamatarisha m'chachureemish ínachsha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Itaru, Osiysha muchchur: Yuwartatam siy átis anooritam ashtachiniya. Yuwash mangawa pshtaru pakchini anootsimari kurakaam muchchur putachiniya. ¿Antaati piyartacheetsinaa muntacheezinee? Siynaa mapiyrus naatssa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tárangu, uwshtisin anuritam mikeersin kóstarurineetsi tsapush naruwayarusin, tapuriranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Osiysha muchchur putsisarinshuma kóstarini napta napta ashirangu, naxpoorangiya. Itaru, nllurashsha Benmaminash kóstarini naparangu, anush kurakaa mánguwar pshtaru parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Zoonllshitisin anoo parangusin, kizpur zoonllingaz mang' mantsaksin, wamaree izichiranganaya. Anumunsha, yusur kóstarureetsini burrumuntam tuchipayarusin, wapitam yaktaptam kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yusur Osiyash pang' kuskamchusin, Osiy anootsiri taaru parangusin, ashparitssin Osiyash wats tutunlltayarusin, tsapumun much tuw ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Itaru, Osiysha: ¿Mayaamsha siy nuwaa maachiriti patatarangsa? ¿Nda siy nuwaa yasakis? Watam nuwamari ichingaroo maacheewaatsi yasakinawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Utaásha anoo: Iy ¿tamayareezini yuwaa átish anoo kamaneechinee? Watam na kapung yutaritshishee patataranganiwa. Apanll waana iyaa yutaritshishirini shiyaam yámandarangiya. ¿Iysha anoo amcheezinee? Ashparitani shiyaam m'chachurish kinachinipa, yuwaptari mangawa yarangu anpatarta, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Osiysha: Nduni. ¿Antaati amb ashimaam wanindaja? Yuwamari nuwaa mangawari yarangu anumari nish ishinchima. Itaru, siyaatsinaa ¿mayamandaja kiyung yachachee? Siy mapiyrus aparpis pang' naatatssa. Osiy tárangiya. Ashiriya, na kamaneena yuwaa Osiy zoonllish waanaatsi mangawar pshtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Utaásha Osiyanung káyamayaru, Na nuwsha kurakaa, shiyaptamari tsimbunandani tsiyateeni, atina. Yuwaa áti anoo shiysha nuwaa tsiyantarinllpa, watam shiy paraw tamapari ashiritamshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Shiy nuwaa apari masharangush, ¿Aparish na wandtam kchit? tárangush, nuwsha, Kchitcha. Zuwanlli minum arang taaritamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Apari na kizpur wachin taariya. Wipsha minumtam kizpur kanungas taaritamta. Apap uru wachinachu anush iparinarangiya. Tsimbun taarangsin, itaru minum tsiparangiya. Ashirucha, anoo wipaa minumtatseeru, apap ksumish chinakiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ashiriya, shiysha anoo mazinarangush, zuwanllish nllur yamashini. Nuw anoo nlluraa pamaam zandaktana, iyaa tárangsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Itaru, iysha shiyaa: Apap anoo wipaa nllura kasamaam zandkeeja. Zangankachinaari, apap tsipachshapari, shiyaa táranginiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Itaru, shiysha iyaa: Wandaya nda anoo nllura ningeem yushindakus, nuw ndushapari siyaa pamaam zandkina, tárangsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Anush kanapeeshinuni, apapash kusaranganiya. Apapaatssha shiyaa kukish ichingaru kamaniranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ashiritaa apap iyaa kamachtarangiya. Yusur wapitam naayarus, tirik pakich pxanxashinints, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Itaru, iysha zuwanllpatini nllurpa naachinipa, watam kupeerun waana kamachtakuwa. Ashiriya, iy zuwanllshartanaari naakchuni, uru kurak iyaa nda kis napchiya, táranginiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Táranguni, anoo apapsha: Siy nuwaa kiyung yachaksa. Siy yasaktamsa nuwaatsi; nuw izanlli tsimbunandamari iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Min ipari xikatu naatarangu, nda kanapurangiya. Izuuru kanatsiparangina. Ambiri pastarangiya. Nda pakchiyam ipareetsi parangina. ¿Tamayrimasaja ashirang? Mangishi chinakuri, maachipari manginshuch tumuz zayaru katungarangiya, tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na yusur minootsshat ipareetsi machkachush, yusur kanatsipkachus, nuwsha anungaz kizpur mangi mantsakuri tsipachshaparina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Wipapa washunand taaksin, nlluramun kizpurtaru mang' kis taakiya. Ashiriya, iyshat wipaa kanatsipkachuni, ");
INSERT INTO cbuNT_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","apapapsha uru tsipachiya. Amb ashkachuni, iyshapari apapaa kiyung yachachiniya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Watam, nuwtanda apaa, yasari ipareetsish, wanasirtanda ksutchi. Wandtaati ambiritaatiya pastakachu, nuwshat anumand nuwaana nutsi tuwapachima, apapaa tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ashirucha, natshat anuritam shiyaa mashkina, kurakaa. Nuwnaa zuwanllimandi wamin shiyash m'chachoom taachima. Zuwanllinaari waani ashparitssin apapap kanapchinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Itaru, ndunnaa amb ashkuri, ¿tamayareezi? ¿Wapitam apapash kuseechee? Yuwaa apap kizpur tanuku, anoo nayanikuri, nda pamaam zandkina, Utaá kurakaa tárangiya. Ashiriya, na kamaneena yuwaa Utaá Benjamin wamin kurakpa tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yuwaa zoonll Utaá tsiyatstaru anoo Osiy mazinarangu, tanumaam zandarangiya. Ashirucha, muchchuree parundama átu: Natu siy ashparitis shtungangints, tárangu, muchchursha anuritam shitungartaranganaya. Ashiramchusin, anush waanaatsisha zoonllee kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","3","Anush Osiy kapung tanurangu, Osiysha Hebrewshuch kuk tsiyateeru, waanaatsi itsinsaru kamanirangiya. Nuw suri Osiytana. ¿Apap tamaru taara? ¿Wandaritam kchit? tárangiya. Yuwaa kapung tanurangu anoo ichingarusin tputs Ijiptoshuch parawatam mazinaranganaya. Ashirucha, zoonllsha kapung napuxtaranganaya. Nda minumtiyam tsiyataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Osiysha: Naanints ningeema, watsiri xiyangints. Wanasir tsiyachintspa, tárangu, zoonllshitisin anuritam Osiyanung watsiri xiyaranganaya. Anushsha tsiyatarangu: Siyaa nuw zuwanlltana. Ijiptoshcheem tputs tupaxanxarangis nuw antana. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Itaru, punirintspa. Yuwamand nuwaa tupaxanxarangis anumand tsiyantarintspa. Apanll waana nuwaa zandarangu wayarangiya, siyaamtam taarashis tapachindamaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Na tsimbun masach yuw iwariz maringarangu an tushiyanlliya. Wand pshatari zameetpa masachi. Mzatsee tatsumkitaatich nda pusachchi. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Itaru, waana Apanll nuwaa amb ashimaam ipusarangu, na nuw nish ksutkina siyaam taarashis tapachindamaama, ipareemtamtis. Ashkachuri, siysa pzapanichis anooma. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ashirucha, Apanll waana nuwaa ningeem tsap zanganirangiya. Nda siy nuwaa ningeem zanganirangsa. Apanll waana nuwaatsimari ichingaroom kurak kasiru parawaam wipunash ínarangiya. Amb ashirangu, Ijiptoshcheem tputs ichingaroom na ksutkuri taakina. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Natunaa apapap mikeerus naangsints. Apapash kuskamchus, apapaa: Iparish Osiy na kchichcha. Osiy ateeja: Apanll waana nuwaa Ijiptoshcheem ksutamaam ínarangiya, áttanda, támatssa. Ashiriya, apapaa, Osiy ningeem napatandama. Mikeeru kusachpa, áttanda, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nish kuskachu, ashpari wipaptari, wachinllinpatartatam, chin ashpari yushindakamchu, nuwsha nuwanungitari tsap Ngusenash taarasheem wayachima. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Itaru, uru shiyaam ichingaroomis katungats panachintspa. Ndunnaa ashkuri, siysapari ichingarus marizimun tsipatssa. Na watam wandari 5 masach mariz tushiymaam pishtakuwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Siysa nuwaa saantari kachis parangsa; nuw zuwanlli Benjamin nuwaa na parangitamta. Yuwaatsitam nuwaanaatsi itsinsarpatari siyaa kamanirangi anoo mazinarangsa. Antaati nuw ngichkeezi. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Siysa apapaa itsinsarus kamanimatssa yuwaa kurakaam kinarangi anootsi. Ashiriya, mikeerus apap yamashinints, ");
INSERT INTO cbuNT_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","tárangu, Osiysha zoonllpa Benjaminpa pachipeersin, tanuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Osiy zoonllpat ichingarusin tanurangusin, anumun ishambta, minootssha zoonll ishambta, ishambta ashirangu, zoonllshitisin Osiypat tsiyataranganaya. Ndusha puniranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ashiriya, yuwaa Osiy zoonll Ijiptosh tsap kusarangana anoo parawsha tsiyatssee mazinarangu, ichingarusin tputs kapung mang' ksaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Parawsha Osiyaa: Zuwanlleetsish kamaningcha. Mikeersin burrumun maachi tuchipayarusin, wapitam Kanaanap tsap kanapchinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Aparish yamashinints, ashpari maachiritamtis. Tsapuneemis nishuri Ijiptosh panachintspa, yuw tsap kizpur wanasiri anu. Nishuri tsap taakchus, katungats kapung katungkus taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ashiriya, na zoonlleetsish kamachtangcha; nish Ijiptosh kapaachoom pshiyrshini yamaama. Anush pshtayarus, izanllis, ipartamtis, apartamtis washunand yushindamaama, átcha, kurakaa tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Maachiritaatsis ashpatam kamingangtsa. Anungaz mangis mantsarintspa. Tsapuningazis mangis mantsarintstampa. Mapiyrus ksangtsa. Nish Ijiptosh maachi payukani an ichingaru panachintspa, paraw Osiyaa tárangu, Osiysha zoonllee anuritam kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ashiriya, Osiysha yuwaa kurak kamachtaku anoo tuminurangiya. Zoonlleemaw kapaachoo pshiyrshini yáyaru, panata, panata ashirangiya. Anumun watungasheemshitisin panarangitamta yuw apus ngootsish katungchinllina anooma. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Anumunsha wamareemshitisin kaneesich kamaz wanasirimash minumtaw panata panata ashirangiya. Itaru, zoonlleemarisha, Benjaminaamam zameetpa kamaz yuwanandari kizpur wanasirimshi annandari panarangiya. Anumunsha kurikeetssha 300 mbammashi panarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Wapareemsha 10 burru upapchirinand yamayaru, anumun maachi zapan tuchipayaru zanganirangiya. Anumunsha yusur 10 burrutam wizarinanda, anumun yuw wapar apus katungattu kuschu anoom katungtsinandari ichingaru tuchipayaru, zanganirangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Naakachshitisin, anush Osiy zoonllee waneeku, Ashiriya, naakchus wanasir naatatssa. Apussha ngootsish saanpata natsatstintspa, táyaru zoonllee zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ashiriya, uwshtisin naayarandsin, Ijiptoo tsap shitungeerandsin, yusur Kanaanapsha tsap waparish taárash kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kuseeramchusin, waparee, Apaa, shiy iparish Osiy taarcha. Antaati tsiparangeeja. Na kupeerunoom kinaru, Ijiptoo tsap ksutku taakiya, táranganaya. Akopsha anoo mazinaranllu, mang' zuw ashirangu; Mangupari ipari tánaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Itaru, uwshtisin ashpari Osiy kamachtarangu anoo ichingaru kamaniranganaya. Mishat, kapaachootssha pshiyrshini yámandarangitamsinaya. Akopsha anoo parangu, ¿Kaapa zurkus átis? tárangu, mang' kizpur ksarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ashiriya, wipaatssha: Zuraktischa. Na ipari Osiy wandaripari kchitaya. Ndaturi tsipari iparpi pangatama, Akoparini tárangiya. Ashiriya, na kamaneena yuwaa Osiy wapareem zoonllish tsiyatssee zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israelsha watsapunee kasayaranllu, yuwaa maachiri payuku anoo ichingeeranllu, Ijiptopsha naayaranllu, tsap Beersebashsha kusarangiya. Anushsha kuseeru, Apanllee yuwaa waparin Isaakarini chinarangu anootstam ungirtaku; maacheetsi muchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Anuritam psaan maaranllu, anush Apanllee pamasarangiya. Apanllsha: Akopaa, ¿tamarimta? tárangu, Akopsha: Nishtanda, apaa, kusarangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Apanllsha Akopaa: Nuw Apanlltana. Shiy aparinish Isaak nuwaa kapung chinarangiya. Ashiriya, punirinllpa. Mapiyrush Ijiptop tsap naangi. Amb naakchush, uru aranginasha chinllinish tsapurnasish pzapanichiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nuwaana shiyaa Ijiptop tsap machchinllpa. Yusur ayam shiyachichee nlluranur nuwaana tsapunpitamtish Kanaanap wayachima. Itaru, shiynaa anshurishapa tsipachsha. Tsipakchush, iparshitish Osiy shiyaa ksutchiya, Apanll Akoparineetsi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Beersebamandsha tsap kakchusin, waparee Akopaa kapaachush pshiyrshini izaruranganaya, yuwash Ijiptoshuch kurak zanganirangu anshu. Anumunshat, kizatam nllurpatari ashparitin kapaachush pshiyrshini zaruranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ashiramchusin, ashpari yuwaa Kanaanash tsap payuku anoo ichingaru Ijiptop tsap machirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wipatam; kamuz, kiz, wachinllinutam, ashparitin káchingarsin, Ijiptop tsap naataranganaya. Ashiriya, na kamaneena yuwaa Akoparini Kanaanaa tsap shitungeeranllu, Ijiptopsha tsap naatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_8b","002_46_8b","GEN","46","8b","8b","Akop Liyash iparinarangiya iwachiztamarini sur Rubena. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubensha uwshat arang iparinarangitamta, sur Anuka, Falu, Esron, Karmí. Aship Ruben wip taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Anamunsha, Liyshutam iparinarangiya sur Simeóna. Simeónsha arang iparinarangiya sur Jemuel, Jamina, Ohad, Jakin, Sojar, Saul. Itaru, ansha Saul minshuchish wizanll Kanaanshuchish kiz iparinarangu anu. Ashpamuncha Simeón wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Anumunsha, Akopatam wip Liyshuchtamta sur Leviy taarangiya. Uwshat arang iparinarangiya, sur Guersón, Quejat, Merarí. Ashpamuncha Leviy wipaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Anumunsha Akopatam iparinarangiya Liyshutamta sur Utaá. Uwshat arang iparinarangitamta, sur Er, Onán, Selá, Fares, Serah. Ashpamuncha Utaá wipaya. Itaru, Utaá wip Kanaanash tsap tsimbun tsiparangiya, sur Er, Onán. Ashpisin wipashari tsiparanganaya. Anumunsha Akopatam wip Liyshuch Fares, uwshat arang iparinarangitamta. Sur Hesron, Hamul. Ashpamuna Fares wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Anumunsha Akopatam wip Liyshuch sur Isakara. Uwshat arang iparinarangitamta, sur Tolá, Powá, Job, Simrón. Ashpamuncha Isakara wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Anumunsha, Akopatam wip Liyshuchtam sur Sabulón. Uwshat arang iparinarangitamta, sur Sered, Elón, Jahleel. Ashpamuncha Sabulón wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ashiriya, Akoparini wip kamuz aship Liyash iparinarangiya. Wipsha kiz, sur Dina, iparinarangitamta. Padán-Aramap tsap iparinarshinu anu. Ashiriya, Akoparini wip Liyshu, wachinllinutamta washunandari kamuz, kiz ashiru 33 pzapaneeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Akoparinsha yuwaa minushshat kiz Liyaa muchchur sur Silpaa yamayaru, sur Gad iparinarangiya. Gadshat uwshat arang iparinarangiya, suru Sefo, Haguí, Esbón, Suní, Erí, Arodí, Arelí. Ashpamuncha Gad wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Anumunsha Silpatam wip sur Aser iparinarangiya. Asershat arangeem iparinarangitamta, sur, Imna, Isvá, Isví, Berió, anumunsha wip kizatam iparinarangiya, sura Serah. Ashpamuncha Aser wipa. Anumunsha Beriósha uwshat arang wip tsimbun iparinarangitamta, sur Eber, Malkiyel. Aship washunand ichingaru taarangiya, ");
INSERT INTO cbuNT_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Akop Silpash ichinguru wachinllinpatari washunand 16 pzapaneerangiya. Silpa Labancha muchchurimuna. Ashirucha Laban wipaamsha, Liyaamsha muchchureem panarangiya. Akopsha arang yamarangu anush wip wanindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Akoparinsha Rakelash tsimbun iparinarangiya. Iwachiztamarini suru Osiya, anumunsha Benjamin. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Osiysha uwshat arang tsimbun iparinarangitamta. Iwachiztamarini sur Manases, Efrayin. Ashpanandtam Osiy wip Ijiptosh tsap nllurtaranganaya wizanllish Asenata. Asenataa kurakcha Potifer wipaya. Itaru, Potifer yakat sur Un anush pátireem urkar taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Akopsha Rakelshutam Benjaminaa iparinarangiya. Benjaminsha arang iparinarangitamta, sur Bela, Beker, Asber, Guerá, Naamán, Ehí, Ros, Mopim, Hupim, Ardi. Ashpamuncha Benjamin wipa. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ashiriya, ichingaru Akoparini wizanllish Rakelash wachinllinpatari, washunand 14 taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Akoparinsha Bilhaa yamarangu, anushshat iparinarangiya iwachiztamarini sur Dan. Uwshat arang minam iparinarangiya sur Husim. Anumunsha Bilhatam wip sur Neftaliy taarangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftaliysha uwshat arang iparinarangitamta. Iwachiztamarini sur Jahseel, Guni, Jeser, Sílem. Ashpamuncha washunand 7 Akoparini Bilhash wachinllin wanindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilha Labancha muchchurimuna. Laban wipaamsha, Rakelaamsha muchchureem panarangiya. Anootssha Akopshat yamarangu anush wip wanindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Akoparini wipapa wachinllinpa ichingaru washunand 66 tputs taarangiya. Itaru, wipaatssha wizanll nda táchirangiya. Ashpisin an tputs Ijiptop tsap naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ashparisha washunand Osiypatari wip Akop maachiri 70 Ijiptosh tsap washunand taaranganaya. Ashiriya, na kamaneena yuwaa Akoparini wip ichingarusin Ijiptop tsap naatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ngootsish naantachu, Akoparinsha wasina tsiyatssee tuyamzaru wipash Utaásh zanganirangiya. Wasina zuwanllshish yasamacha. ¿Tamayreezini iy tsap Ngusenash kuschinee? Anush shiyapa pangchinipa, átanda tángcha. Anoom wasina kamanimacha, tárangu, wipaa Utaá wasina zanganirangiya. Amb sheeru, tsap Ngusenash kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kuseerna anoo Osiysha mazinarangu, muchchuree, Natu nuw kapaachuri pshiyrshini naamaam wanasir yarangints, tárangu, kapaachush pshiyrshini zaruyaru, ngootsip waparee chamayangakatu naatarangiya. Apus naanatanusin, waparpat chamayarangusin, pachipeersin, kapung tanuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Waparsha, Mshee, natunaa shiyaa pakeena kchiptarti. ¿Shiy na wand kchitish taakish? Nuw na kizpur wachinayana, mutashapari tsipachina, wipaa Osiyaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Osiysha zoonllee ashpari, wapareetstam maachiri ashpari shaneerana anoo; Nuwma kurakpa tsiyachima. Zuwanlli natunaa kusateensincha, yuw Kanaanash tsap taarangana anu. Uwshtisin na nuwapa taachinllinaya, táchima. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nuw zuwanlli chinuzpan taaksin, chinootstam zapan yushindaranganaya, opeejatam, wakaratam, misha ichingaru yuw maachi zapan payukana anoo nish yushindaranganaya pzapanimaama, nuw kurakaa parawaa táchima. ");
INSERT INTO cbuNT_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Paraw siyaa kuruzeeru, mashkachu, ¿Siy maypan tarawaztaksa? tákchu, siysat itsinsarus kamaningtsa; ");
INSERT INTO cbuNT_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Iy chinuzpantanicha. Opeejaa chinukuni taakaniya. Watam pachirini uru chinuzpaniri taaranguwa, tángtsa. Amb tákchus, uru kuraksha paraw, siyaa anuritam Ngusenash tsap wayachintsa. Saamatari tsapuneemis panachiya, watam Ijiptoshuch tputs chinuzpanpat nda kaapa ipunkanaya, zoonllee waneeku Osiy ántar ashirangiya. Ashiriya, na kamaneena yuwaa Akoparini wipapa Osiypa chamayangarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Osiysha parawash pang' kuseeru, Ichee, natunaacha apap Kanaanamand tsap káyashinusin, ashpari zuwanlltamti na Ngusenash tsap kuseenllina. Maachiri ashpari chinutam opeeja, wakaratam yushindaranganaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Osiysha zoonllee 5 ipuseeru, Kurak zuwanlleetsi waani pangap átu, kurakash pang' yapshturangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kuraksha, Zuwaa, ¿siy maypanis tarawaztakus taaksa? tárangu, uwshtisin, Kurakaa, iy tputsini chinuzpantanicha. Opeejaa chinukuni taakaniya, watam pachirini uru chinuzpan taaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Na ningsha shiyash tsapunish taamaam kusaranganiya. Watam Kanaanash tsap iwariz maringarangu, marizimun tsipakchuni, na ningsha kusaraniya. ¿Yapshtaja opeejareetsini yanungaychini? Anoomcha na shiyaatssha mashkashiniya. ¿Shiy amaksha? ¿Iyaam nish Ngusenaa tsap panachtatazish? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kuraksha: Osiyaa, Na aparish, zuwanlltamtish shiyash taamani atusin kusataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ashiriya, shiyshat shaana tsap Ngusenaa panangcha. Mishat, nuwshat shiyaa táchinllpa; Yuw zuwanllish chinuzee kapung ksutamaam yasaru an nuwaatssha chini ksutamapan taachiya, kurak Osiyaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Osiy wapareetstam kurakash pang' yapshturangiya. Akopsha kurakaa tasaseeru, tsapush much timuchta ashirangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","kuraksha, Ichee, ¿shiy wanipsha masachirish taara? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Akopshat: Na kizpur wachinaranguri, masachiri 130 taariya. Nuw ximpaniriti taakina. Yap zandki ambeew xixtarashin ashkina. Itaru, aship ashiranguri, nuwaam zapan taxarashish taarangiya. Itaru, nuw pachiri zitaminaw nuwamand aranginasha kizpureew wachinaw taaranganaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ashiriya, tsiyatsis iwaparamchusin, Akoparinshtini punirpatari: Kurakaa, Xamachi, táyaru, shitungarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Osiysha yuwaa kurak tárangu anuritam tuminurangiya. Wapareem, zoonlleemtam tsap Ngusenaa kizpur wanasiri anoo yakat Ramsisanungiri panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Sheeru, anumun watungasheemsha ashparitam wipamaritamsin maritamaam panarangiya. Katungtsee yáyaru, zoonlleemaw minoom ashpatam, minoomsha ashpatam sheeru tatsamooru panarangiya. Ashiriya, na kamaneena yuwaa Akoparini Ijiptoshuchpa kurak tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Anpursha Ijiptosh tsap tirikoo tatsumkitaatssin, nda kxunarangiya. Kanaanashsha tsap ashirangtamta. Ichingaru tsapurnas iwariz maringarangiya. Tputs marizimun pakchim tsipamaam pishtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ashirucha, Osiysha yuwaam tputs watungash pishtarangu anoomaw tirikoo tupaxanxarangu, kurikee zapan yáta, yáta ashirangu, parawashsha pang' xanatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Amb ashirangsin, Ijiptoshuch tputs ichingarusin urkiree tuchingaranganaya. Kanaanshuchtam tputs waanaatsi urkiree tuchingaranganaya. Ashirucha, Osiyash pang' kuseersin, Kurakaa, ¿tamaycheezini? Kurikirini nduniwa. ¿Ndusha iyaa nayanikish? ¿Tamareeja shiy parush, iysha tsipachini? Ndunnaa iyaam katungshini panakush, uru marizimun tsipachiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Osiysha, Zuraktischa. Kurikireetsis tuchingarangpasa. Itaru, watam chinis taaruwa. Nuwaamsha chineetsis panakamchus, nuwshat anumand siyaam katungtsee panachintspa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ashirucha, uwshtisin anuritam chinoo, kapaachu, opeeja, kaapra, wakara, burru, ashiru putaranganaya. Sheersin, anpasha katungtseem paxanxaranganaya. Ambiri ashkusin, ichingarusin anuri masach taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ashiriya, an masach tushiyramchu, anush chinootsshitisin tuchingarangsin, yusur Osiyash kuseersin, Kurakaa, shiyaa itsinsaruni kamankiniya. Nda ngutani ngichkuni atiniya. Kurikeetsima tuchingaranguni, naachsha in chineetsshitini tuchingeeniya. Ashiriya ¿maypashtaja katungsheemani paxanxeechinee? Ashpiri maachiritaatsini chingayaniwa. Na mzarimarishtini, mishat yaana nutsini ashpanandamarisha taariya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Iy ngutani tsipakchuni, ¿chakaja iyaam mzareemani tarawaztach? Ashiri, parawaamsha muchchur taachinipa. Shiyshat iyaam tirikoo wach panakchus, iyshat anoo tatsumchinipa. Ashkuni, kurakaamsha tarawaztakuni taachiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ashirucha, Osiysha anuritam, ayu, tárangu, Ijiptoshchee tputs mazar ashpiri parawaam watsapun paxanxarangiya. Marizimun tsipakchusin, watsapuneetssha tupaxanxaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Amb ashirangsin, Ijiptoshuch tputs ichingarusin, parawaamsha muchchur kinaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Itaru, apanllputsshitisin urkar mapiyrsin taaranganaya. Watam paraw katungtsee ichingaru zar panaranguwa. Ashirucha, mazaree nda tupaxanxamaam zandaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Zapish sin sinarangshat, Osiy tiptsiree: Natunaa nuw na siyaa tsapunis paxanxaranginawa. Na kurakshatanda watsapuni. Siysa anoo tarawaztangtsa; nuw tatsumsheemis panachintspa. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ashirucha, nuwsha siyaa itsinsari atina. Mzarshis pusaramchus, siysat kurakaam watsapunimand ashpatam wanusee panangtsa. Napaz zameetpa tsumb pusakchus, ashiri kurakaamsha anchich minumtam tsumb yáyarus panangtsa. Amb ashkachus, ipunpunaroomsha tsumb ituchku an saamatarisha katungtseemis, ipareemis, maachiritaamtamtis, kchitamaam yátssa. Anshutam wachoo tatsumamaam yátssa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ashirucha, tputssha Osiyaa: Iy marizimun tsipamaam waritarangitaatani, itaru shiyshat iyaam katungatspa kapung istarangsha. Shiy amb ashirangush, na wandaritam kchit taakaniya. Ashiriya, yuwamand ashirangish anumand iysha parawaamshapari muchchur taachiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Anumun Osiysha Ijiptoshchee tputsi kamachtamaam tsiyatssee kaneesich yandarangiya. Tputs mazarish wanusee zameetpa kilo pusakchu, anchich parawaamsha minumtam kilo panachiya. Sheeru, waama ipunpunaroomsha kilo yachiya, táyaru, kirakamun yandarangiya. Ashiri na in zar tsiyatsis anuritam taariya. Ashirucha, wandaritam apanllputs urkar nda katungtsee kurakaam panakanaya. Ashiriya, na kamaneena yuwaatssha Osiy tputsee kamachtamaam tsiyatssee kaneesich yandarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Akoparini Kanaanaa tsap kasarangu, Ijiptopsha kuseeru, Ngusenashsha tsap taarangiya. Anoo watsapuneemarisha yarangiya. Anshurishat wachinllinoom aranginasha pzapaneerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Akoparini Ngusenash tsap 17 masach taarangiya. Aship masach taarangu, kizpurinasha wachinarangu, washunand masachirini 147 taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Aship masachirini taachu, Akoparinsha: Kizpurcha wachinayanlli, tárangu, wipaa Osiyaa tsiyatpi átu, tputsish tsiyatssee kamachtarangiya. Osiysha anuritam waparish, kusarangiya. Akopsha wipaa: Mshee, natunaa itsinsashti kamanchinllpa. Nda shiy nuwaa ngichimaam kuwiptish maxishi pazungandama. Tsipakchuri, nishuri nuwaa Ijiptosh tsap mapiyshpa. Yuwari táyanlli, anuritam k'keetsi payungandama. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nishurtataati tsap tsipakuri, zitaminpat Apanllip ipunkamchuri, shiyshat nuwaa yáyarush, yapitam pachirineetsi mapurangana ambitam mapungandama, wipaa Osiya tárangiya. Osiysha; Apaa, tsipaktaateesha, ambiri wayachinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Akopsha maashimun putayaru, Osiyaa: Apanll waana paritam, zurampatari nuwaa tángandama, wipaa tárangu, Osiysha, Apaa, shiyaa kukish zurampatari payuchima, tárangiya. Akoparinsha anurisha Apanllee kis ungirtarangiya. Ashiriya, na kamaneena yuwaa Akoparini wipaa Osiya kamachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Musásiritam, Osiysha tsiyatssee mazinarangu, Aparish kizpurtanda wanguya, tputs tárangiya. Osiysha anoo mazinarangu, wipaa tsimbunari yamayaranllu, Manases mishat Efrayin, ashiru waparish yushindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tputsshitisin, Akopaa, iparish Osiy shiyangaz tsiyatati átu, kuseenlliya, tárangu, Akopsha apinlliri chiyzataraa sheeru, wirmashuri kuxinta ashirangiya. Sheeru, wipaa Osiya tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Mshee, Apanllimari kizpurcha. Wamari kasiru kurak taakiya. Sirútama apus yaktash Lusash, Kanaanshuri tsap, nuwaa Apanll tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Nuw shiyaa chinakina. Shiyaam kapung istachima. Uru iparish zapan pzapanitsha. Chinllinitamtish pzapanichtamsha. Ashkachush, shiyaanandari chinllinish watsapuneemaritam, watsapuneemaritam, sheersin yachinllinaya, Apanll tárangiya. Anush Apanll nuwaa kamanirangiya yuwaa nuwachich Kanaanaa tsap waamatari watsapun payuchinllina anootsi. tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na, shiyshat ningeem naatarangush, kizaa yamarangush, iparish wanindarangiya. Nuw ndatuma ningeem kuschuri, iparish urutari Efrayin, Manases ashiru nllurtaranganaya. Ashiriya, nuwshat ipareetsish tsimbunartaa nuwaana iparpazi Rubenaa, Simeónaa ashipaz ashiru ínachima. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Arang iparinakinaareesha ashiru, anootsina shaamatarisha iparish taachiya. Uwshtisin zoonllpa Efrayinpat, Manasespatatam washunand taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mishat, yuwapur Padán-Arammand tsap kanapurangani anpur Kanaanashshat tsap yakat Efrata kayumanasha aneerirnish zuwanlleetsish iparinayaru, anshurisha zureeru tsiparangiya. Nuwsha anshuri tsap mapurangina. Itaru, natsha anoo yakat Biringaa ísamaranganaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Anumun wachinllinootssha parangu, Mshee Osiyaa, ¿chakshitisinaya inee? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Osiysha: Apaa, nuwcha ipari. Watacha Apanll nuwaam ipareemi nish tsap panaranganda anu, tárangiya. Akopsha: Iparish nuwanungitari tunuxinangi. Ipareemish nuwaanaatsi wizpuriri wanasirimshee panachima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Watam anpursha Akop kizpur wachinarangu, wach arap pamaam pinasarangiya. Osiysha wipaa itataranllu, upachirinung wanumb tunuxinata, minootssha wip minungichich wanumbinung tunuxinata, ashirangiya. Akopsha wachinllinoo pachipeeru ishambta, minootssha ishambta ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Sheeru, wipaatssha Osiyaa: Mshee, nuw sirú mangishi chinaranguri, ayamtaati ndunpari ipareetsi pangchina, táranginatana. Itaru, natsha Apanll nuwaam kapung istarangu, shiyaa, ipareetstamtish pakeena, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Wachinllinoo pachipeeru ishambarangu, anumun Osiysha wipaa yusur tawanlltarangiya. Sheeru, uwshat waparish wats tutunlltayaru, much tsapush kizpur timuchta ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Anumunsha, wipaa putsisarineetsi Manasesaa waparinung upachtam mbutsanungach tunuxinarangiya. Minootssha wip nllurarineetsi Efrayinaa mbazinungach tunuxinarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Akoparinsha Apanllpa tsiyatpi átu, uwee mbutsanungach nllurarinimunshat much putarangiya. Uw mbazinungachsha charapungayaru, iwachiztamamun much putarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Sheeru, waanaatsisha wizpurirni wanasirimshee panarangiya. Apanllimari kizpurcha. Waamari wanasir zitaminaa pachirineetsi Aprahamarinee, aparneetstam Isaakarinee wanasir ksutarangiya. Uru Apanllish tachitarangana. Yuwamandari nuw nllurtarangi anumandari nuwaa ksutarangu, natsha in wandaritam nuwaa ksutkiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Apanll nuwaa pachindarangu, yutaritshish nda nuwaam tushiyrangiya, tárangu, Apanlleetssha mashku, Apaa, shiyshat nee nlluraa wanasir ksutangcha. Nichich ayam nlluranur pzapaneekchusin, ichingaru nuwachchinandari maachiriti taachinllinpa. Nuwaanaatsi, Aprahamaarineetstam, Isaakarineetstam sur ayamtaati mbizarusinapa. Waani nuwachichinandari tputs tsapurunasish ztaru taachinllinaya, Akoparini Apanllee mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Osiysha yuwaa wapar nlluramunsha Efrayinamun uw mbutsanungach putarangu anoo nda kis parangu, waparee uwee itutseeru, putsisamunsha much wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Apaa, watsta. Amb shirinllpa. Manasesamuna kuwish mbutsanungach wayangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Itaru, Akopsha wipaa: Nduni, mshee. Yasartaati, nuwaana zandkuri amb ashkina. Manases uru kizpur taachu, wachinllin pzapanichtamparee. Itaru, kaapa zoonllimari Efrayin nllurataa waamari kasiru wachinllin zapan taachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ayam nuwachich nlluranur wipaam wizpurirnee wanasirimshee panakchusin, Apanllee mashkusin, Apaa, shiy tamaru Efrayinaa misha Manasesaa chinarangsha ambitam shingcha ipareemi, Apanllee mashkusin, táchinllinaya, Akoparini tárangiya. Amb tárangu, Efrayinaa iwachiztamaampaz ashiru ínarangiya. Manasesaatssha nlluraampaz ashiru wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ashiriya, wachinllinoo tsiyatam iwatsparamchu, wipaatssha Osiyaa: Mshee, natunaa musásirishapari tsipachina. Itaru, tsipaktaateena, uru Apanll shiyaa ksutchiya. Waana shiyachchee nlluranur ayam yusur wapitam wayachiya yaptam sirútama zitamin pachirinis taarangana ambitamtaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Na shiyaam kapung istachinllpa. Shiyamari zuwanlleetsish ichingaroo kasirush taachsha. Yuwaa Amorrewshuchee watsapun Sekemaa itutsirangi anootstam tsap shiyaamsha panachinllpa, tárangiya. Ashiriya, na kamaneena yuwaa Akoparini waanaatsi wizpurirni wachinllinoom panarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Akoparini wipaa ashpari kuruzeeru, Naanints. Nuwash kusangints. Siyaa wanasir taamaam wanichintspa. Nuw tsipaktaateena, saani tsapunshish tamayareezis ayam taachis anoo kamanchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Siysa nuwaa Israelaatsi k'keetsi mazinangtsa, Nuw siyaa ipareetseeruri wanichintspa, tárangu, wipaa putsisarinee tasaseeru, ");
INSERT INTO cbuNT_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Mshee Rubenaa, shiycha iwachiztamish, watam shiyaatsima kanungastamasi iparinarangina. Ashirucha, shiy putsisarush kurak tamapari ashirush zuwanlleetsish ashpartaa kasiksha. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Shiy kung tamapari ashishtish, yapiri zandkish ambiri naakush taachsha. Nimunarisha ndusha wizpurirish iwachiztam ashirush taachsha. ¿Antaati nuw shiyachcheem nlluranur tsapoo wanasirimshee panacheezi? Yuwamand shiy nuwaa kapung tayutaritarangush, izanlleetsi mashingamaa mangishish mantsir chinarangish anumanda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Minootssha wip: Mshee Simeóna, shiyshat zuwanllpatartish Leviypat yutaritamtischa. Nduntam wanasir taamaam zandaksa. Siy watseenurtischa; tputsee nda naynirangus, mchitpat pacharangsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ashirucha, yuwamand ashkis anumand yuwash shaniyeerus tsiyatstangat ashkis, anush nuw nda pakchiyam mazinamaam zandkashina. Watam piyartach tputs siyamand yutaritshishiris nuwaa yutaritaam ínarangandanaya. Nduntaa nuw kamachtaranguri, kizpur tsiyantarangus, siysa tputsee zapan pacharangsa. Mishat, mang' ndunarpaz ashirus, wakaraatstam wirkar tururangus, kiyungutam yacharangsa. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ashiriya, yuwamand ashirangis anumand waana Apanll siyaa wanichapantsa. Nuwshat siyachcheem nlluranur Kanaanaa tsap panacheezi. Uru maachiritshuw watsapun washunand yanpatarsin, taachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Shiyachcheetssha, mshee Utaá, ayam nllurnur yuwaa kizpur kurakaw taakana, anumun maachiritshitisin mang' tatkusin, wanasir napchinllinaya. Undarareetstam ichingaru kasirsin taachinllinaya. Amb ashkatssin, maachiritshitisin waatsimarisha kukoo payuchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mishat, shiyachchimari kizpur tumuz manginshuch tamapari ashirusin taachinllinaya. Napangi, tumuz manginshuch ndaturi kizpur wachinaru, maacheetsi izuuru zamari zayaru, katungeeru, tazazasha, yusur taarshishtam mang' kissha maamawmach ashtaru, shiyachichsha ambitam undararee ashtachinllinaya. ¿Chakaja tputs yuwaa tumuz maamawamchu anoo naateeru muntayach? ");
INSERT INTO cbuNT_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ambtam ashikpaz ashkusin, shiyachchimari ichingaroo tputs kasirsin taachinllinaya. Shiyachich kizpur kurak urutari pishtacheeja, ndambari. Itaru, nimun zapish kurak shiyachcheetsimarisha nlluranur kasiru kizpur kurak kuschiya. Anootsimari uru kurakawtamsin istanda táchinllinaya. Ichingaru tsapurunas anootsimaritam kurakaa kuk payuchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mishat, mshee Utaá, shiyachchimari nlluranur watsapun kizpur wanasir maachi zapan yusiyku, pzapanichiya. Mazarish maachi zapan yusiykchu, anush burrurintamsin wippat mapiyrsin tazazarsin, maarutar ashtachiya. Arang ndusha muntachiya. Mishat, mazarish kizarun zapaneekchu, kungpaz ashiru wakungur taakchu, anush tputs wamareetstaa káchamaam waritachiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Anuri ichingaru zar waksin, wach chumbeepeewsha taachinllinaya. Wakaraatstam mimir ichingaru zar waksin, wanas mbursheewsha taachinllinaya. Amb ashkusin, shamangarsin mang' kissha taachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Shiyachichshat, mshee Sabulón; ayam nlluranur mus kapungumashimun wing taachinllinaya. Ashkatssin, anungaz tputs araanllash zapan mataychinllinaya. Watsapuneemsha musamun wing pzingaru, yakat Sidonamun ashchiri yachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ashiriya, mshee Isakaraa; shiyachichsha nlluranur kizpurinaa kizpureewtaatssin, itaru burr tamapari ashirusin taachinllinaya. Napangi, burr kizpuritaa kayak tuchipayaruch kanuspi átu, tsapush kuxineeru, kanusaramchu, yusur chiyzapi átu, xapooptar ashtaru, shiyachichsha nlluranur ashtachtamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Natumasam watsapuneem yuwaa kizpur wanasiri anoo yachinllinaya. Itaru, anumun zapish mishat tputs watsapunee itutschinllinaya. Sheersin, waanaatstatam muchchureemsha wayakchusin, kiyung kachiykusin taachinllinaya. tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Shiyachichshat, mshee Dan, Israelchicheetstam nlluranur waanpatatamsin ksutchitampasinaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Napangi; maak ngootsish tsangayaru, amb sundarsha kapaachumun kuxinaru iriptaranllu, anoo wanashirish kapuxkachu, kapaachsha sundaroo tsapush kapeetanganllu, tpaw támach ashtaru ashtachinllinaya. Amb ashkusin, waanaatsi tiptsiree tapachindachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Tárangu, Apanlleetssha: Apaa, nuwachchee nlluranur ksarinllpa; tapachindangcha, tárangu, anumun yusur minootssha wip tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Shiyshat, mshee Gad; kizpurtishcha. Shiyachcheengaz nlluranur tputs pachapani atusin, kuskitaatssin, itaru waamarishtisin kasita, kasita ashkusin, waanaatsi tapachindaksin taachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Mshee Aseraa, shiyachichshat nlluranur tsap wanasirish taachinllinaya. Wamaritssin katungats wanasirimshee zapan payuksin, anungaz kurakawtamsin arapcheew kuseersin, mashchinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Mshee Neftaliy; shiyachichshat nlluranur manllanus tamatarpari ashirusin apusap taachinllinaya. Napangi: manllanus machip mapiyru, wipaa machtat ashtaru, uwshtisin ambitam ashkusin mapiyrsin taachinllinaya. tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Shiyshat, mshee Osiyaa; kizarun tamapari ashirush taaksha. Napangi; kizarun kungunungiri wing tatsumeeruch, tandapunuzimun kuricheeru zapan pzeenaru, wanus yusiyramchu, an ayamtaati pishtacheeja. Shiyshat ambitam ashipaz ashtachsha. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kundararish shiyaa natsarangitaatssin, kiyungutaa yacharangusin, shiyaa pachamaam zandarangtaatssin, ");
INSERT INTO cbuNT_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","itaru shiyshat nda sambaytarangush, Apanllimun mangish taturangush, Apanllsha shiyaa tapachindarangiya. Apanll kizpureeru ashirangiya. Watam nuwaa opeejpan tputs chinoo wanasir ksutaru ashiru ksutaranguwa. Watam nuwaa patumbchishpaz wach tapshuku ashiru, nuwaa tapachindaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ashirucha, yuwamand nuwaa ksutarangu anumand Apanllsha shiyaatstam ksutkiya. Apanll waana kizpureeru, Shiyaa uru istachshaparee. Apanll shiyaa kis naparangu, sinaatssha zanganirangu, shiyash mzarish maachishsha zapan kxunachshaparee. Mishat, tsapushumandsha kung kusarangiya. Mishat, shiyachich wizanur uru mireechinllinaya. Chineemtamtish zapantam pzapanichtamparee. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nuwshat shiyachcheem Apanllee mashkuri, Yuwaa tsap maachi ichingaru taaru anoo urutamari payuchinllinaya. Uru katungats anush taachiya. Nuw tsiyatki anoo shiyaam nlluranurish urutari istachiya. Watam Apanll shiyaa zuwanlleemish ichingaroom ksutamaam ipusaranguwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Mshee Benjaminaa, shiyachichshat nlluranur urutamari maninung tamapari ashirusin, undararee waamari kasichinllinaya. Napangi: maninung puturi shitungeersin, maacheetsi zamamari zayarusin, katungeersin, pukamatsha wipaamsha anchichitam maritakanaya. Ashiri siyachichshat nlluranur ambitam ashtachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ashiriya, Akoparini wipaa ichingaroo 12 tushaneeyaru, minoom tsiyata, minoom tsiyata sheeru, wipaam Apanllpa kapung masharangiya. Ashiriya, na kamaneena yuwaa Akoparini wipaa ashparta waneeyaru, Apanllpa tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Minushsha zar Akoparini wipaatssha tsiyatarangu, Siyaa zurampatari táchintspa. Nuw kizpurshacha wachinayanlli: tsipachshaparina. Musásirishapari zitaminpat Apanllip ipunkamchuri, naachina. Ashiriya, tsipakchuri, siysa nuwaanpeetam tsapuni mapungasindama, yuwashutam zitaminarineewaa mapurangana anshutamta. Watam pachirini Aprahamarini anoo tsap Efronaa tputs Hititshuchee watsapun patumbchee wach mapshisheemari paxanxaranguwa. Ansha mapshish sur Makpela. Yakat Mamrenungiri watsiri taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","¿Anush wanipaja zitaminarineetsini mapurangana? Aprahamarineetsi, Sararineetstam, aparneetstam Isaakarineetsi, aneerneetstam Rebekarineetsi, izanllineetstam Liyarineetsi ashpari anush tsap mapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ashiriya, watam anoo tsap Aprahamarini izuurmamari mapshisheemari paxanxaranguwa. Ashiriya, siysa nuwaa anshutam mapungasindama, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tárangu, wipaa ashpari waneeyaru, tsiyatam iwatsparamchu, anush tsipakchu, yuwash zitaminarini taakana anush Apanllip naatarangu, anshuri maamataraa ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Osiyshat waparimun pachipeeru, kapung tanurangu, waparee ishambta, ishambta ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Anumun Osiy tputsee yuwaa Ijiptoshchee kizpur yasampan taakana, tsipareewa wanuts nda musá kuchamaam masharpat taparakana anoo kamachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ashirucha, Akoparineetsshitini 40 zar anumashpatatam tapararangusin, nda musá mapkusin, waya ashiranganaya. Itaru, Ijiptoshuchtisin tputs 70 zar Akopariningazi mang' mantsaksin taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ashiriya, 70 zar maaramchu anush Osiysha parawaa yasati átu, pangush pshtuyaru, parawaa wipunashee; Siy nuwaa chinakinaareesa ashiru, istangasindama parawaa tsiyatamaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Aparni ndatuma tsipachu; Tsipaktaateena, Kanaanash tsap urutari mapshish nuwaam taariya. Ashiri ambiri mapungandama táranguwa. Ashirucha, nuwaa natumasam ksangandama. Tsipar mapeeri kasatama. Sheechuri, yusur musásiritam kuschima, Osiy átcha, parawaa tángcha, Osiy parawaa wipunash kamachtaku, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Parawsha wipunash anuritam kurakaa kamanirangsin, uwshat; Waritachparee. Waaniparee naayaru, waparee mapchiya. Yuwaa waparin kamachtarangu anuritam tuminuchpa, kurak átanda tángcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Osiysha anuritam waparinaa yáyaranllu, mapkatu payutarangiya. Tputsshitisin ashpatam Osiyaam kutakatssin, tachitaranganaya. Wachinanuritamta, parawaa pang' ksutkana anutamsina, parawtam wamachtashi, ");
INSERT INTO cbuNT_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Akoparintamni wámindu, wipatam ashpari Osiy zoonlli, ashpisin Osiyaam kutakatssin tachitaranganaya. Ashirucha, aship naatarangsin, Ngusenash tsap pangusish kurimunazirisha kasaranganaya. Nllur chinuzpatamarisha taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ashirangsin, tputs ashpatam watspatari, ashpatam kapaachush pshiyrshini, ashpatam kapaachumun ush chipayarandsin, Osiyaam kutakatssin, washunandari shurangarsin, naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Sheerandsin, apus Ortagamun wing yakat sur Goren-ha-tad anush kusaranganaya, yuwash tirikoo wach tuchuwtampaneem wayarangana anshu. Anshurishat shaniyeeramchusin, Osiy tiptsirpatari ichingarusin tsimbun matayaru zar waparinangaz tanuksin, taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tputsshitisin Kanaanshuch anoo parangusin, waanpatatshitisin: Napangints, in tputs Ijiptoshchimanda tanuksin, shaneeranaya, tárangana. Ashirucha, anumand anoo tsap Abel-misra atusin ísamaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ashiriya, yuwartatam Akoparini wipaa tsiyatarangu, anuritam wipshitisin tuminaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kanaanashsha tsap kusarangsin, anshurisha mapshish sur Makpelash mapuranganaya, yuwash Aprahamarini sirútama mapshisheem Hititshuchee tputs Efronaa watsapun paxanxarangu anshu. Watam Aprahamarini: Ayam chinllini tsipaksin, nishuri mapchinllinaya, táranguwa. Ashirucha, anshuri mapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Sheerandsin, yusur Osiy zoonll ashparitamsin, wipunashsha aparitam wapitam Ijiptoptam tsap kanapuranganaya. Ashiriya, na kamaneena yuwaa Akoparini tsiparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Akoparini tsiparamatshat, wipshitisin Osiy zoonll mangush nllitari chinaranganaya. Watam aparni tsipayanlluwa. ¿Ndushta zuwanllshitini Osiy iyaa natsayach? yuwamand iy kiyung yacharangini anumanda, waanpatatin tsiyatkusin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ashirucha, amb tárangusin, tputsee; Wanasir tsiyatsis kamaningcha. Zuwanllish shiyaa ateeja: Aparni ndatuma tsipachu, iyaa waneerangiya. Nuw tsiparamchitaateena, siysat zuwanlleetsis Osiyaa nuwaa kuki kamaningtsa. Yuwaa nuw tsiyateenlli anuritam nuwaa kuki mazinachpa. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ashiri zuwanllpatis wanasir tsiyatsis yarangtsa. Zuwanllis shiyaa kiyungutaatiya yacharangusin, ashiritaa zuwanllpatis wanasir tsiyatssee yareerus, mapiyrus taangtsa, táranguwa. Ashirucha, na iysha shiyapa tsiyatssee wanasir yareeruni, mapiyshtini taamaam zandkiniya. Sheeruni, Apanlleetssha yuwaatstam aparini kizpur chinarangu anootsitam chinaptamni atiniya, zuwanllish shiyaa átssincha, tángcha Osiyaatsi, táranganaya. Ashiriya, tputssha anuritam tsiyatssee kamanirangiya. Osiysha anoo mazinarangu, kapung tanurangu, Nuwash zuwanlli mapiyrsin kuschinllinpa, átcha, tángcha, tputsee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ashirucha, zoonllshitisin kuseersin, Osiyash wats tutunlltayarusin, kizpur much tsapush timuchta sheersin, Shaana zandkush, iyaatssha m'chachureemish ínangcha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Itaru, Osiysha: Nduni, nuwaa punirintspa. ¿Antaatiya nuw Apanllinawa, siyaa wanipee? ");
INSERT INTO cbuNT_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Siy nuwaa kiyungutaati yacharangus, ashiritaa Apanllsha nuwaa waana ipusarangiya, siyaam ichinguroomis tapachindamaama. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ashiriya, punirintspa; nuw uru siyaa ipareetstamtis wanasir ksutchintspa, tárangu, Osiy zoonllpa tsiyatssee wanasir yararanganaya. Ashiriya, na kamaneena yuwaa Osiy zoonllpat tsiyatssee wanasir yararangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Osiy maachiritpat ashpari washunandari kayanurusin, Ijiptosh tsap taaranganaya. Anpur Osiy kizpur wachinarangu, masachirini 110 taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ashirangu, Efrayinaa wachinllin ichingaru parangiya. Arangeemsha Efrayinaa wachinllin wip parangitamta. Mishat, Manasessha wip sur Markira taarangtamta. Anootstam wip parangitamta. Aship in Osiynandari wachinllin taarangiya. Osiy wachinllinuwaa ashpari kapung chinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Anumun minushsha zar, Osiy zoonlleewaa wip ashpari kuruzeeru, natunaa musásirishapari tsipachina. Itaru, tsipaktaateena, mangis mantsarintspa. Uru Apanll siyaam istachparee. Nish tsap siyachchee nlluranur yamayaru, yusur Kanaanpitam tsap wayachiya. Yuwashutam Apanll waana tsapoo ipuseeru, Aprahamarineemi, Isaakarineemtamni, aparneemtam Akoparineemi panarangu, anshutamtaya: ");
INSERT INTO cbuNT_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ashiriya, nuw tsipaktaateena, mangis mantsarintspa. Uru Apanll siyaam zurampatari Kanaanpitam wayachparee. Ashiriya, tsipakchuri, natumasam nishuri Ijiptosh tsap mapungasindama. Yuwash waana Apanll siyaa yusur yamayaru, wapitam Kanaanap tsap wayakchu, anshutam napureetsimshiti yáyarus, yuwashtam taakamchis anshutam mapungasindama. Ashiriya, siysa nuwaa kuki zurampatari tuminungtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ashiriya, Osiy kizpur wachinarangu, masachirini 110 tatsamoorangu, anshurisha Ijiptosh tsap tsiparangiya. Tputsshitisin nda musá wanuts kuchamaam atusin, masharpat, irimiypa taparayarusin, táwar tinayarusin, anush pshtayarusin, kasaranganaya. Ashiriya, na kamaneena yuwaa Osiyarini tsiparangu anootsi. Ashiriya, nuw Móysisi: wapparee, atina siyaatsi. Na kamaneena yuwaa Apanll tputsee waana tiptsireem ipusarangu anootsi.");
INSERT INTO cbuNT_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ashiriya, Akoparini Ijiptosh tsap ichinguru wipapat, misha wizanllpataw, misha tiptsirpatatam kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Akoparini wip washunand 12 taarangiya. Sur Ruben, Simeón, Leviy, Utaá, ");
INSERT INTO cbuNT_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sabulón, Benjamin, ");
INSERT INTO cbuNT_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftaliy, Gad, Aser, ");
INSERT INTO cbuNT_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","aship an waparpat washunand Ijiptosh tsapu kusaranganaya. Itaru, Osiy urutari Ijiptosh tsap taarangiya. Ashiri ichinguru washunand tiptsirpatari 70 tputs Akoparinchich kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yuwamun Ijiptosh tsap kusarangana anumun zapan masach tushiyramchu, Osiy zoonll ichingurusin tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Itaru, wipshitisin Israelchich tputs uwshtisin arang pzapaneeranganaya. Mishat, tiptsireem izapaneerangitamsinaya. Ashirangsin, Ijiptosh watsapun Ngusenash tsap izuuru tatsitarangsin, kizpurinandaritanasha taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ashiriya, zapshinaa Osiyarini kurak tsiparamchu, anumun zapan masach tushiyramchu, nllitarisha tputs Ijiptoshcheem kurak kinarangiya. Ashirucha, yuw kaneesich kurak kinayaru an Osiyarinee nda yasarangiya, yuwaa Osiyarini kurakaam kinaru, Ijiptoshchee tputs ksutarangu anootsi. Amb ashirangu, Israelchichee tputs nda pakchiyam nayanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ashirucha, kurak tiptsiree tsiyatarangu, Israelchich tputs pzapaneekachpa. Iyashcheetsimari tputs wamaritssin kasikchinllinaya. Mishat, waashuch tputs iyashchimand kizpureewsincha. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ashiri iy ndunnaa yaanaatsi ksutkuni, iyash tsapuni aranginashaparee pzapanichinllinaya. Ashkatssin, yuwash kundararini iyapat waratamaam kuskachinllina anshutam uwshtisin Israelchich yapandayarusin, izuuru iyaa kasichinllinaya. Sheentssin, yusur waanpeetam watsapun suwachinllinaya, kurak tiptsiree tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Amb tárangu, arangeem Israelchich tputs pzapanitpa átu, Israelchichee kiyung yachamaam chtarangiya. Ijiptoshchee tputs tarawzipaneem urkar ínarangu, uwshitisin Israelchichee tputs pangus kapunguw tsimbun pangumaam kamachtaranganaya. Anoo yakat ísamaranganaya Pitona, misha Ramsisa. Ashiriya, anushsha pangusish katungtsee Ijiptoshcheem kurak ichinguru wayaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","13","Ashirangtaatssin, Ijiptoshuch tputs Israelchichee aranginasha kapung natsaranganaya. Ashiritaa, Israelchichsha aranginasha pzapanirangiya. Ashirucha, anoo Ijiptoshuch tputs puniksin, aranginasha itarawaztaksin, kiyung yacharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ladrichoo tinamaam itarawaztaranganaya. Tinaksin, tsapupat, misha masharpat aship íseersin, tinaranganaya. Sheersin, anpasha panguseem kapung panguranganaya. Mishat, mazareemtam itarawaztarangitamsinaya. Itaru, ashiritaa, Israelchich aranginasha pzapaneerangiya. Ashiriya, na kamaneena yuwaa Ijiptoshuch kurak Israelchichee muchchureem ínarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ashiriya, Ijiptoshuch kurak Israelchichee tatspumpan kiz tsimbun kuruzarangiya. Sifra, misha Powá ashiru yuwaa urutarimari kizaa tatspumpan taarangana anoo kuruzeeru tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ashiriya, siysa kizaa ksutkus, yuwaa wip kamuz nllurtakachu anoo pchangtsa. Itaru, wandaya wip kiz nllurtakachu, anootsinaa ksangtsa; waani taachpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Itaru, kizshitisin tatspumpan Apanllee kapung chinarangusin, kurakaa kuk nda payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ashiri kuraksha kizaa yusur kuruzeeru, ¿Tamaksasa, siya? ¿Mayaamsha nlluraa kamuza ngutis napaksa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Itaru, kizshitisin: Iyashuch Israelshuch kizanur nda siyashuch kizanur tamapari ashiranaya. Iyashuch kizpursincha. Ashirucha, iy ksutataritaatani, itaru urusha tatsipum pakaniya, kurakaa táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Itaru, anshitisin kiz Apanllee kapung chinarangusin, waanpatatin Israelchichpatatin pachamaam Watsta, táranganaya. Ashirucha, Israelchich aranginasha wip pzapaneeranganaya. Mishat, Apanll waana istarangu, tatspumpanshitisin wip pzapaneerangitamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Anumandshat, Ijiptoshuchsha kurak kizpur tsiyantarangu, tiptsiree: Ichinguroo Israelchichee wip yuwaa kamuz nllurtakachu anoo pakchus, kungush kpitangtsa. Itaru, wip kizaya nllurtakachu, anootsinaa ksangtsa; waani taachpa, kurak tárangiya. Ashiriya, na kamaneena yuwaa Israelchichee wip kamuzaa kungush kpitangtsa kurak tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","2","Yuwapur kurak yutarit waneerangu anpur, Leviyarinchich tputs waanpatatin kizaa yamarangiya. Kizsha mireerangu iparinarangiya. Wipaa napku, kizpur wanasir parangiya. Ashirucha, wanirsha wipaa kapung chinaku, tuchip tsup pishurangiya. Itaru, tambashitaranllu paru, pishumaam pinasaku, ");
INSERT INTO cbuNT_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ipareetsi kurak wasundurur pachatpa átu, tsumb ashiru wanasir tap wanind k'tayaru, pingartayaru, wanasir nda kung pshtumaam átu, tamireeru, anush wipaa wanasir pshtayaru, yuwash nduynduy tapuru anush, kung Nilomun wing tumuzirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ashiriya, nllursha wizar arapeetari xiyeeru, wayuchee ksutku, napanapaw ashirangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","zar pukamachsha, Ijiptoshuch kurak wip muchchurpa chumakatu, kungumun wing naantatssin, tsumb kungush muziztaru parangu, muchchureetssha: ");
INSERT INTO cbuNT_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Tsumb yashini. Napani, tárangu, muchchursha tsumboo yáyashinu, panarangiya. Kuraksha wip anush tawateeru napku, nllur taaru tanutu anoo parangu, nayanirangiya. Nllur kiyung kachiyakparee. Israelchich wipaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ashiriya, nllursha wizar tapishuru, shitungta sheeshinu, kurakaa wip: Shiy nlluraa zandkeesha, nuw Israelchichee wizanur yamatama tumintamaama, tárangu, kuraksha wip: Ayu, ashiri yamashinsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nllursha wizar waniree yamayashinu, wanirsha kusarangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","anoo kuraksha wip: Nee nlluraa shiy nuwaam ipari yanungangcha. Wanasir ksutangcha. Yuwamand shiy wanasir ksutkachish anumand nuwsha shiyaam tuwapachinllpa, tárangiya. Ashiri nllursha wanir wipaa yamayaranllu, waanpeetam pang' machirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nllursha kanungaramchu, waniree mimir kasaramchu, kurakaamsha wip kizaam nlluraa panarangiya. Kuraksha wip nlluraa yamayaru, waanaatsi wip tamapari ashiru wanasir ksutarangiya. Ashirucha, kungushuch yamaama átu, nlluraatssha sur Móysis ísamarangiya. Ashiri na kamaneena yuwaa Móysisi nllurtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ashiriya, zapish Móysis wachinarangu, yap maachirit tarawaztakana amb pakatu naatarangu, anushsha kuseeru, yuwaa Ijiptoshuch tputs Israelchichee kiyung yachaksin, pzkookataru anoo parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Móysissha anoo parangu, kapung tsiyantayaru, tputseem nllitaritaam napku, ndunar parangu, Ijiptoshcheetssha tputs pzkoompanee putayaru pacharangiya. Sheeru, mazacheetssha tawangeeru, anush mapeeranllu, ndunpaz tputsee pacharu ashiru, mapiyru, yusur waanpeetam kanapurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Putamsha zar yusur Móysis wapitam maachiritap pakatu naantachu, anush yusur waanpatatshitisin waratatangatssin anoo parangu, ¿Mayaamsha saanpata warataksa? waratamapanee tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","waratamapansha: ¿Chaksha shiyaa kurakaam ínayara? ¿Antaati iy shiyaa kurakarini? Ngutpasha nuwaa pachapi átush átsha. Watam shiy sing zar Ijiptoshchee tputs pacharangshawa, tárangiya. Móysissha anoo mazinayaru, kapung punirangiya. Nuwaa tputs yasayanllpasinaya, yuwaa Ijiptoshchee tputs pacharangi anootsiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Móysis wasina yasarangiya yuwaa Ijiptoshuch kurak waanamuna tsiyatssee mazinarangu anootsi. Ashiriya, kuraksha wasundururee: Móysisee pakchus, putayarus, pchangtsa, tárangiya. Móysissha anoo tsiyatsis mazinayaru, Madiyanap tsap arap suwarangiya. Anushsha tsap kuseeramchu, kanusku, posonung kuxinxinawmach ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Anushsha Madiyanash tsap apanllpan tputs sur Jetrona taarangiya. Wipsha kamasinanand tsimbun matayaru taarangu, uwshtisin waparee chin opeejaa ksutkusin, Pososh kung tipayaruni opeejaam yaseeni, táyarandsin, anush kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Tputssha nllitarit kamuzaw chinuzpantam ksutamapan anshutam kusarangsin, kizaatssha: Siy musápa. Iyma chineemani yaschinipa, táranganaya. Itaru, Móysissha kizaa nayanirangu, minoo tputsee: Nduni. Siy musámachi. Kizamasin chinoom yáspana, tárangu, uwsha kungoo pososh tipayaru, kizaam opeejarini yásirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ashirucha, kizshitisin anuritam mikeersin pangup kanapuranganaya. Anootssha wapar parangu, wipaa: ¿Tamasha mikeerus kanapeeshinsa? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","wipsha: Ijiptoshuch tputs iyaa kapung istarangiya; kamuzpatatin: Siy musápa, tárangu, pososh kungoo tipayaru, iyaama opeejarini yásirangiya. Ashirucha, mikeeruni kanapeeshinini, waparee táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ashiriya, waparsha: ¿Mayaamsha kamingeerandsa? Natu saantatam mikeerus yamashinints. Anpa washunand katungpani, tárangu, wipshitisin anuritam naayarusin, Móysisee yamayashinusin, yushindaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ashiriya, Jetronsha Móysisee: Kayun taapani, tárangu, Móysissha anshuri taarataraw ashku, zapish Jetron wipaa Seforaa sur Móysiseem wizanll izuuru panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Anushsha kiz Móysis wip wanindarangiya. Anootssha nlluraa: Nuw arapichtana tputsi átu, sur Guersonaa ísamarangiya. Ashiriya, na kamaneena yuwaa Móysis nllitaritapsha tsap naayaru taararangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ashiriya, Móysis kapung ungsirish taar ashku, zapan masach tushiyramchu, Ijiptoshuch kurak tsiparangiya. Itaru ashiritaa, Israelchichee wandari muchchurtarangusin, kiyung kachiyaranganaya. Ijiptoshuch tputs kapung kiyung yacharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","25","Ashiriya, Israelchich Apanllee mashkusin; Apaa, istanda, tanuksin, átangat ashiranganaya. Apanllsha anoo mazinayaru; Ashiri na siyaa istachintspa. Watam Aprahamarineetsi, misha Isaakarineetsi, misha Akoparineetsi, istachintspa, táranginawa. Ashiri na siyaa izuuru istachintspa, Apanll tárangiya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee kapung istachintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ashiriya, Móysis Madiyanush tsap ungsiree Jetronaa opeejarini ksutku taarangiya. Jetronsha apanllpanimuncha. Ashiriya, minushsha zar Móysis mach Orebap ipusap ungsiree opeejarini machtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Anushsha kusarangu, yuw yasin pakich xiyaru an kizpur kurarangu, Móysissha anoo parangu, napuxtarangiya. Yasin puch sumasush ipusinand xiyá ashirangtaa, itaru yasin nda muchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ashiriya, Móysissha, ¿Maya ashtar? átu, anush napkatu, ");
INSERT INTO cbuNT_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Apanllsha: Móysisee, musá ningeem kusinllpa, tárangu, Móysissha: ¿Mayaamshita? átu, ");
INSERT INTO cbuNT_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Apanllsha: Anootsiri xiyeerush, spaturish yushungi, watam nuwash wanasirimshish kusarangshawa, tárangu, Móysissha anootsirisha wasapturee yushirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Apanllsha: Nuw waatatana Apanlli. Sirútama shiy zitaminarish nuwaa chinaranganaya: Aprahamarini, misha Isaakarini, misha Akoparini aship nuwaa kizpur chinaranganaya, Apanll tárangiya. Móysissha anoo mazinarangu, puniku, Apanllee patareema, átu, wachoo pachtampat kámanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Itaru, Apanllsha wandari Móysisee tsiyatstar ashirangiya. Nuw Israelchichee izuuru yasaktana, yuwaa Ijiptoshuch tputs kiyung yachaksin, tanukana anootsi. Nuwaatssha: Apaa, tpachindangandama, atanaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","9","Ashirucha, nuwsha istapi aturi, shiyash kusarangina. Shiysha Israelchichee maachiritaatsish shaana istangcha. Nuw siyaa minup tsap kapungup maachchintspa. An tsap kizpur wanasiri, misha katungats zapantam taariya, misha kungutam wanasirimash taaritamta. Ansha tsap sur Kanaana yap tputs nda nuwaa kuki mangoonkana ambi. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ashiriya, nuw shiyaa Ijiptoshchipa kurak tsiyatamaam zanganchinllpa. Shiy nuwaa tputsireetsi kurakpa tsiyateerush, ishitungangcha, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Itaru, Móysissha: Nuw kurakaa tsiyatkuri, ¿antaati nuw waritareezi? ¿Ameereezi Israelchichee tputs minupsha tsap tashitungangcha, táyachee? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Apanllsha: Nduni, punirinllpa. Nuw shiyaam kapung istachinllpa. Shiysha Israelchichee tashitungayarush, nichchitam tsap mach Orebush kuskachus, anush ichingurusin tputs nuwaatsimari ungirtaksin taachinllinpa. Anumun tputs nuwaa ichingurusin yasachinllinaya. Zurukuparee Apanll Taarashipan Móysisee ningeem zanganirangiya, nuwaa táchpasinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ashiriya, Móysissha: Nuw Israelchichee: Iy zitaminarini Apanllirini nuwaa kamachtarangiya. Siyaa nish Ijiptosh tsap tashitungamaama, táchima. Itaru, wapaz nuwaa; ¿Tamamshita Apanllee? tákchusin, ¿nuwsha anoo amcheezi? Móysis Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","15","Apanllsha: Nuw Apanlli Taarashipantana. Nuw urutari sirútamastaatiya taaranguri, natsha urutamaritam taakina. Nuw waatatana Taarashipani. Siy zitaminarnis nuwaatsimari ichingurusin, Aprahamarini, misha Isaakarini, misha Akoparini kizpur chinarangana. Nuw waatatana. Min, nllitarit Apanll nuwamand wanindaja. Ashirucha, nuwaa ningeem zanganirangiya siyaa istamaama, Apanll átcha, tángcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ashiriya, Ijiptosh tsap Israelchichpat urkar shaniykachus, anush nuwaa kuki kamaningcha. Apanll Taarashipan watacha yuw zitaminaris Aprahamarini, misha Isaakarini, misha Akoparini chinarangana. An nuwaa tsiyatarangiya, tángcha. Mishat, siyaa ateeja; Nuw paktana yuwaa siy Ijiptosh tsap kiyung kachiykis anootsi, Apanll átcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ashiriya, nuw siyaa Ijiptosh tsap tashitungachintspa nda arangeem siy kiyung kachiymaama. Siyaa tsap Kanaanap machintspa, yap tputs nllitari Hititshuch, mishat Amorrewshuch, mishat Feresewshuch, mishat Hebewshuch, mishat Jebusewshuch taakana ambi. Anush tsap kizpur wanasiri; katungats zapan taariya, misha kung wanasirimash taaritamta. Izuuru siy anoo tsap urutamari payutssa, Apanll átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ashiri shiysha Israelchichpa kurak tsiyatkachush, kuraksha shiyaa kukish uru payuchiya. Mishat, Ijiptoshchee kurak tsiyatangtamcha. Ashiri Israelchich tputs shitungeersin, anumand tuchip zar naayarusin, ipusap anush nuwaa ungirtaksin, chinoowaa nuwaam muchchinllinaya, Apanll átcha, Ijiptoshchee kuraka tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Itaru, nuw wasina yasaktana. Amb atitaateesha, siyaa zangancheeja, ndambari. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Itaru, nuwsha ashiritaa, kurakaa kizpur kiyung yachachima. Nuwaanaatsi wizpurireetsi yuwamshee nda patarana anumashee yámandachima. Ashkachuri, Ijiptoshchee tputs tsipatspa wanichima. Ashkachuri, anoo kurak Ijiptoshuch pakchu, Israelchichee tputs zanganichparee. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mishat, nuw Israelchichee istachima. Ashkachuri, Ijiptoshuch tputs maachiritaa mangutari zapan panachinllinaya. Israelchichsha anoo maacheetsi zapan yáyandsin naachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ndatuma Ijiptoo tsap shitungarusin, Israelchich kizanur Ijiptoshchee wizanur maachiritaa yuwaa payukana anoo mashkatssin, uwshtisin nda pachindchinlliniya. Kurikee, misha orootstam, misha wayarangasheetstam, misha wamareetstam ichinguru maacheetsi panachinllinaya. Ashiri Israelchichsha anpa wipaam túmartachinllinaya. Ashkatssin, Ijiptoshcheetssha izuuru ixunayarusin kasachinllinaya, Apanll Móysisee tárangiya. Ashiriya, na kamaneena yuwaa Apanll Móysispa tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Itaru, Móysissha Apanllee tárangiya; Itaru, Israelchichsha kurak nuwamun mang' tatchazinllinaja. Mishat, nuw Apanllee Taarashipani parangtana atitaateena, nda nuwamun mang' tatchinllinaya. ¿Nuw anoo tamaycheezi? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Apanllsha: ¿Shiy mayaa kuwishish payusha? tárangu, Móysissha; Tushuwshishcha payuri, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Apanllsha: Tushuwshish tsapush kpitangi, tárangiya. Ashiri Móysissha tushuwshineetsi tsapush kapeetarangu, tushuwshishsha makaam kinarangiya. Ashiriya, Móysissha makaa puniku, arapinlltam xiyarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Apanllsha: Yusur makaa wanish kuwiptish putayarush yángi, tárangiya. Ashiriya, Móysissha yusur makaa wanish putayaru, yáta ashkachu, maksha yusur tushuwshishee kinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ashiriya, Apanllsha: Anpa ashkachush anoo pakchusin; Ashiriya, waatapari niya Taarashipani, Apanlliya yuw shiyaa yakarangu anuya, shiyaa atusin nuwamun mangu tatchinllinaya. Minsha, waatapari niya iy zitaminarni Aprahamarini, minsha Isaakarini, minsha Akoparini Apanlliriniya, nuwaa atusin, chinachinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Anumun nduniya mang' tatkusin, ashiri shiysha yusur nllitari yámandangcha. Kuwish k'tunirishish pazuyarush, titkureetsish patateerush, yusheerush kuwish napangcha, Apanll tárangiya. Móysissha, ayu táyaru, uwee wamarush pazuyaru, titkuree patateeru, yusur uwee yusheeru, nap ashku, uwish tsutashish nllitari tsutaru parangiya. Uwi kuchá kuchá ashisha kizpur chamirataru kazinaz tamapari ashiru parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ashiriya, yusursha Apanll: Ashiri yusursha k'tunirishish kuwish pazuyarush, yusheerush napangi, táyaru, Móysissha ayu, átu, uwee watunirush pazuyaru, yusur uwee yusheeru, nap ashku, uw wanasirsha parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Anumunsha, Apanllsha: Ashiri shiy minamtarini nuwaa wizpuri yámandayarush, anumun nda mang' tatkusin, ashiri tsimbunurinsha nuwaa wizpuri yámandakchush, anumun mang' tatchapsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Itaru, wandaya tsimbunutaa nuwaa wizpuri yámandayarush, anumun nda mang' tatkusin, ashiriya, kungup Nil wachinpa ipuneerush naayarush, kungoo tipayarush, suwish tsapumun tuchumungcha. Ashkachush, kung kuraseem kinachiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Itaru, Móysissha; Apaa, nuwsha tsiyatsispa waritareezi. ¿Nuw tamaycheezi? ¿Antaati nuw singirtaja ashirangi? Nuw shiyapa tsiyatamaam naturitaja ashki. Nuw tputsi anumashiriti taakina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Itaru, Apanllsha: Nuw waatatana tputsee kuk tinarangi ani; misha, tputsee kuk makuksheem wayarangi, misha ¿chak tputseem witsshartam wayaranga? Minsha ¿chak tputsee wach mchustam nllurtamaam wayaranga, ndusha nuwa? An watacha yuw nuw ichinguru tinarangi anu. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ashirucha, nuw shiyaa: Ashiritaa Ijiptop naangi. Nuwsha shiyaa istachinllpa wanasir tsiyatamaama, atina. Yuwash shiy tsiyatkachish anush nuwsha shiyaa kamanchinllpa, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","itaru, Móysissha wand ngatarangu; Apaa, nuwaa nayaningandama; min tputs tsiyatsipaneem zanganingcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Itaru, Apanllsha: Watam zuwanllish Aarona anush taaruwa. Nuwachchi, Leviyshuch tputsi. Aaron wanasir tsiyatamaam yasariya. Ashiriya, shiyangaz chamayangamaam naanchiya. Shiyaa pamaam kapung zandkiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ashiriya, shiysha nuwaa kuki Aaronaa kamaningcha yuw nuw shiyaa tsiyatkachi anu. Sheerush, Aaronsha shiyamand nuwaa kuki tputsee kamanchiya. Amb ashkachuri, nuwsha siyaa istachintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ashiri shiysha Aaronaa wanasir nuwaa kuki kamankachush, uwsha Israelchichee tputsi itsinsaru kamanchiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ashiriya, neewa yasinaa tushuwsheemish yáyarush, naangcha. Nuwaa kuki tuminungcha. Anpa yasin nuwaa wizpuri tputsee yámandangi yuw nuw shiyaa kamachtarangi anurita, Apanll Móysisee tárangiya. Ashiriya, na kamaneena yuwaa Móysis Apanllee kuk payumaam ngatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ashiriya, Móysissha waptam ungsirip, Jetronap, kanapurangiya. Kanapeeru, ungsireetssha: Ashiriya, ichee, waptam Ijiptop tsap kanapeeruri, zuwanllpi napatama. ¿Tamarangazinllinaja? ¿Taarazinllinaja? táyaru, ungsirsha: Ayu, naangsi. Mapiyrush naangcha, ungsir Jetron tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ashiriya, Móysis tsap Madiyanush taarangu, ndatuma shitungchu, Apanllsha: Waptam Ijiptop tsap kanapungi. Na ichinguru tputs yuw shiyaa pachamaam zandarangu an tsipamawcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ashiriya, Móysissha wizanllpa wipapa ashirusin burrumun kuxineerandsin, waptam Ijiptop tsap kanapeeru naatarangiya. Apanllee túshuwish uwish payuru, naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Apusapsha Apanllsha: Ashiriya, shiysha Ijiptosh tsap kuseerush, nuwaa wizpuriri yuwaa nuw shiyaam yámandarangi anoo shiysha kurakaa parawa yámandangcha. Ichinguru yámandangcha; punirinllpa. Nuw shiyaa istachinllpa. Itaru, shiysha nuwaa kuki kamankitaatish, kurak siyaa zanganimaam kapung ngatachparee, watam nuwsha kurakush mang' xarashish wayakchinawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ashiriya, shiysha parawaa tángcha; Apanll shiyaa ateeja; Nuw Israelchichee kapung chinakina; tputs wipaa iwachiztama chinataru ashiruri nuw Israelchichee kapung chinakina, átcha Apanlli, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mishat, Israelchichee zanganingi. Waani naayarusin, nuwaa ungirtapana, Apanll átcha, tángcha. Nduniya zangankush, wand pachindkush, nuwsha shiyaa ipareetsish iwachiztama pachachima, Apanll shiyaa átcha, parawaa tángcha, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ashiriya, Móysis Ijiptop ngoots naarsin, apus maakamchusin, wizanllpat Seforpata anush Apanll Móysisush kuseeru, Móysisee pachamaam zandarangiya, watam Móysis Apanllee kuk nda tuminuranguwa, wipaa wayumshiri tas nda ktsuparanguwa. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Ashiri Seforsha, Móysis waana wizanll, k'chiroo patumbich tinama yáyaru, wipaa wayumshir tas pakich ktsupeeru, anpa wipapa ursir wazaranllee wats tapararangiya. Ashiri; Neewa; iparimuni ursiri shiyaa Apanll mapiychparee; nda shiyaa pachachiya, Seforu wazaranllee taarangiya. Sefor, yuwamand Israelchich tputs uru wipaa kamuz wayumshiree tas ktsuptarana anumand tárangiya. Ashirucha, Apanllsha anoo pakeeru, mapiyrangiya. Ashiri na kamaneena yuwaa Móysis Ijiptop tsap kanapkatu naatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ashiriya, Apanllsha Aaronaa tárangiya; Machip naayarush, zuwanllish Móysis chamayangashini, táyaru, Aaronsha, Ayu, átu, arap machip naatarangiya, yap Apanll Móysisee yakarangu ambi. Amb kuseeru, anush zoonllee Móysisee chamayangarangiya. ¿Tamarimta, zuwaa? átu, ¿Kusaramchish? táyaru, zoonllee tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ashiri Móysissha zoonllee kamanirangiya; Apanll nuwaa wizpuri panarangiya, táyaru, ichinguru kamanirangiya. Mishat, yuw Apanll kamachtarangu anootstam ichinguru zoonllee kamanirangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ashiriya, ichinguru kamaneeru, tsimbunurisha zoonllpa ipuneerandsin, Israelchichpa urkar tsiyatamaam naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ashiriya, yuwash Israelchich urkar shaneerana anush kuseersin, Aaronsha kamanirangiya yuwaa Apanll Móysisee tsiyatarangu anootsi. Anumunsha, Móysissha Apanllee wizpur yámandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Israelchichsha kurak Apanllee wizpur payarusin, Móysisimun kapung mangu taturanganaya. Mishat, mangpa, yuwaa Apanll; Na nuw siyaa istachintspa, tárangu anootsi mazinazinarangana. Ashiri uwshatssin timucheersin, Apanllee ungirtaranganaya. Ashiriya, na kamaneena yuwaa Aarona Móysispa zoonllpa chamayangayarusin tsiyatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ashiri Israelchichpa tsiyatamaam iwatspayarandsin, Ijiptoshchipasha kurak tsiyatkatssin, Móysis zoonllpa Aaronpa naataranganaya. Ashiri kurakush kuseersin tsiyataranganaya. Kurakaatsi: Israelchichini Apanllirini, Taarashipani, iyash kuseeru, iyaa tsiyatarangiya. Tsiyatku tárangiya, shiyaatsi kurakaa; Nuwaa tputsiri zanganichpa. Waani arap machip naachinllinpa. Anush kuseersin, waani nuwaa ungirtachinllinpa, átcha Apanlli shiyaatsi, Móysisi kurakaa kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Itaru, Ijiptoshuchsha kurak parawarini tárangiya. ¿Chak Taarashipani? Nuw Taarashipani yasareezi. ¿Mayaamshta Taarashipanee kuk nuw payuchi? Itaru, nuw pakchiyam mangi Israelchicheetsis zanganimaam zandkeezi siyaatsi, Ijiptoshuch kurak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Móysissha: Itaru, yaana Apanllirini iyaa istamaam iyash kusarangcha. Itaru, uru ashiritaa, iy arapinlltama machip naachiniya. Tuchip zar maayaruni, anush machish kuseeruni, chinuzee pachayaruni, mucheeruni, Taarashipanee iy Apanllirineetsini ungirtachiniya. Ndunnaa iy amb ashkachuni, iyaa Apanll wanguypat wanichpari. Nduntaatiya ashiru, tapazpataya izuuru iyaa tpachingachiya, Móysisi kurakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Itaru, Ijiptoshsha kurak: Nduni; watsta; siy ngutis tputsee tárawzur tuxaraksa. Ngutis ántangatssa. Ashiritaa naangtsa. Ptatashinints. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Napancha; wanip tputs Israelchichis nish nuwash tsapuni taaranaya, itaru siysa tputseewa tárawzur tuxaraksa. Na wappa. Naangints; tarawaztashinints. Tamundaksa nuwaatsi, kurak paraw tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ashiri anuritam zar parawsha tarawzipanee urkar, Israelchicheetstam wamachtash kuruzurangiya. Uwshtisin kuseersin, parawsha kamachtaku tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Na siysa nimun aranginasha kamachtangtsa tarawaztamaam Israelchichee tputsi. Wayapuree pakchiyam panarintspa ladrichoom tinamaama. Waantin arap naayarusin, wayapuree nachungayarusin yachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Itaru, kamaningints; Izuuru putam putam ashiru ladrichoo tatsamooru kapunguri wayangtsa, tángtsa. Mingassincha tputsi. Uw mingas tarawaztamaam ngatkusin; Iyaa zanganingcha. Arapi naayaruni iyaatsi Apanllirini ungirtapani átanicha, atanaya nuwaatsi. Kapung nuwaa tamundakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Itaru, siysa ashiritaa aranginasha kizpurinasha itarawaztangtsa. Ashiri uwshtisin kapung tarawaztaksin, mapeeksin, mapiyashtisin patatchinlliniya. Yuwaa Móysis mangu ngichku átu anoo nda chinachinlliniya. Mishat, Aaronaatstam kuk nda payuchinlliniya, Ijiptoshuch kurak tarawzipanee urkar tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ashiriya, tarawzipansha urkar misha Israelchichtam wamachtash Israelchichee tputs kamankatssin, naataranganaya. Ashiri, kamankusin táranganaya; Kurak paraw iyaa kamachtaku táyareeja; Israelchicheem wayapuree panarintspa ladrichoo tinamaama. Waantin naayarusin, wayapuree yáyarusin, ladrichoom tinachinllinpa, átcha kurak siyaatsi, tarawzipan urkar kamankusin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ashiriya na, siy saantarisha naayarus, wayapuree nachungayarus yángtsa, táranganaya. Anumunsha, kurak atitamcha, Ashiri siysa izuuru putam putam ashiru ladrichoo tatsamooru kapunguri wayachinllinpa, átcha, kurakaa siyaatsi, tarawzipan urkar kamankusin táranganaya Israelchicheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ashiriya, watam wayapuree izuuru pachindarangsin, Israelchichsha arap pseertayarusin, chirichiree waroo nachungakatssin naataranganaya. Anoo yáyaruni tsapupa íseeruni ladrichoom tinapani atusina. Ashiriya, na kamaneena yuwaa Móysisi Ijiptoshchee kurak tsiyatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","14","Ichinguru zar tarawzipan urkar Israelchichee taxiyranganaya. Izuuru ladrichoo kapungari wayangtsa; ningat pakich wayarintspa, táranganaya. Itaru, Israelchichsha izuuru pinasaranganaya. Ashiritaa, tarawzipan urkar wandari kamachtaranganaya aranginashta; ¿Tamasha sirútama nda ashtarsa? táyarusin, shinambaranganaya Israelchichee wamachtashi. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Anumandsha, Israelchich wamachtash kurakap parawap naataranganaya. Kurakush kuseersin, tsiyatkusin, ¿Mayaamsha shiy sundarurish iyaa amb ashkanaya? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Mishat, tárangana; Sundarurish iyaa kapung tamundakanaya ladrichoo tinamaama. Wayapur nduntaa iyaam pakchiyam panaksin, itaru ashtaa iyaa; ¿Mayaamshta ladrichoo nda tatsamooru wayaksa? iyaa atanaya. Iyaa kapung shinambkanaya. Ladrichoo zapantaa panakuni, ashiritaa wandartisin mangu iyaa kapung natsaksin ashkanaya. Ashiri shiycha sundarish waantari ashkashinllinaya, Israelchich wamachtash kurakaa parawa táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Parawsha; Siy ngutischa tarawaztamaam ngatkus, ningeem nuwaa tákatis. ¿Mayaamsa nuwaa tamundaksa? Ngutis tarawaztamaam ngatkus, ántangatis. Arap naayaruni, chinuzee pachayaruni, Apanllee ungirtapani, ngutis átus tamundaksa. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Natu zamayarus, waptam kanapeerus tarawaztamatssa. Nduntaatiya siyaam wayapur panaksin, ashiritaa ladrichoo tatsamooru wayangtsa, támbeeru kurak kasarangiya Israelchichee wamachtashi. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ashiriya, kurakaa kuk mazinayarusin, yuwaa kurak ladrichoo tatsamooru wayangtsa, tárangu anoo kapung punirangusin, waptam kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Parawarinish pang' shitungeerandsin, Móysisipsha pang' naataranganaya. Wishchipari kutaranganaya. Ashiriya, táranganaya Móysisee, ");
INSERT INTO cbuNT_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Waanipari Apanll siyaa wanichiya yuwamand siy kurakaa mantsir kamachtarangish anumandaya. Na watam kurak wasundurur aranginasha iyaa kiyung yachakuwa. Sirútama taarangani anumand kasiru iyaa natsakanaya. Sirútama nduntaa ashiranguni, itaru natsha aranginasha kurak iyaa kiyung yachakiya. Yuwamand siy kurakaa taarangis anumand iyaa aranginasha itarawaztakanaya. Watam shaana ngichzee wayarangshawa. Anumand waani iyaa pachachiya, táranganaya Móysiseetsi mishat Aaronaatstamta. ");
INSERT INTO cbuNT_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","23","Ashiriya, Móysissha Apanllpa tsiyatamaam naatarangiya. Kapung mang' mantsaku tsiyatku tárangiya; Apaa, ¿shiy mayaamsha tputsireetsish mantsir ksutaksha? Shiy nuwaa zanganirangtaatish, Israelchichee istashini táyarush, nuwaa zanganirangsha. Itaru, nuwsha tsiyatarangtaati, Ijiptoshuch kurak uwsha nuwaa kuki nda payukiya, wandari aranginasha Israelchichee natsakanaya. Mishat, shiysha Apaa, nda pakchiyam tapachindarangsha, tárangiya Móysisi, Apanllee tsiyatku. Ashiriya, na kamaneena yuwaa Israelchich wamachtash parawpat tsiyatarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Apanllsha, Ashiri na nuw Ijiptoshchee kurak waneekchuri, shiy anoo shaana pangachsha, tárangiya. Paraw nuwaa wizpuriri pakchu, kapung kiyung yachakchuri, anoo punikchu, wandarisha siyaa tashitungachiya watsapunishuya, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Yusur minushsha zar Apanll Móysisee tsiyatarangiya; Nuw waatatana Apanlltana, ");
INSERT INTO cbuNT_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Siyashuch zitaminaris nuwaa ungirtaranganaya. Aprahamarini, Isaakarini, Akoparini, nuwaatsimari kapung chinaranganaya. Apanll kizpurcha, waamari kasiru, táranganaya nuwaatsi. Itaru, nuwsha uwaatssin; Nuw waatatana Taarashipantana zuramapani, nda tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mishat, nuw Apanlleeruri, nuwamari siyaa kapung chinakina. Ashiri Kanaanaa tsapu siyaam izuuru panachintspa, tárangina. Yuwash tsap naatturi siy ngutis masarus taakis, anoo siyaam panachintspa, tárangina Aprahamarineetsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ashiriya, na in yasayana yuwaa Ijiptoshuch tputs itarawaztaksin, Israelchicheetsis kiyung yachakana anootsi. Na nuw izuuru nuwaanaatsi kuki tuminchima. Israelchicheetsis istachima, watam nuwaana siyaam istachintspa táranginawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ashiri shiysha Móysisee, Israelchichee nuwaa kuki kamaningcha; Apanll Taarashipan ateeja siyaatsi; Nuw Apanlltana, Taarashipani. Ashiri nuw siyaa tapachindachintspa, átcha Apanlli, tángcha. Mishat, yuwaa Ijiptoshuch siyaa itarawaztaksin, siy kiyung kachiykis anumand nuwsha izuuru wizpurirpati tistachima; kiyungtam yachachima. Sheeruri, siyaa tapachindayaruri kasachima. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mishat, na nimunarisha nuw siyaa nuwamatarisha tputsireemi ínachintspa. Sheeruri, siyaa izuuru ksutchintspa. Ashiri siysa nuwaa Apanllireemis ínangandama. Ambi ashkachus, siy nuwaa yasatssa; Siyashchi uru nuwaa; Taarashipani iycha Apanllirini taakiya, táchinllinaya; Ijiptoshuch tputs iyaa kiyung yacharangusin, itaru Apanlli iyaa tapachindarangu. Ijiptosh watsapun iyaa tashitungarangu, siyashchi nuwaa uruta táchinllinaya, átcha Apanlli siyaatsi, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ashiri misha tárangitamta; nuw siyaa minup tsap maachchintspa yuwaa nuw siyaa zitaminaris Aprahama, misha Isaaka, Akopaam ashiru, tsapooneemis panachintspa, tárangi anootsiya. Anoo tsap urutamari siy tsapuneemis payutssa, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ashiri Móysissha anoo yusur tayusiru, Israelchichee tputsi kamanirangiya yuwaa Apanlli tárangu anootsi. Itaru, uwshtisin anumun mang' nda taturanganaya, watam kapung tarawaztaksin, nizimamun tsipambachinllinawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ashiri Apanll Móysisee tárangiya, ");
INSERT INTO cbuNT_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ashiri shiysha kurakaa parawa tsiyatashini. Apanll Taarashipani ateeja; Israelchichee tashitungachpa, átcha tángcha, Móysisee Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Itaru, Móysissha Apanllee tárangiya; Itaru, nuwaa Israelchichtaa nda nuwaa kuki payuksin, ashiri ¿kurakanashtaja nuwaa kuki payuku payuch? Nda. Mishat, nuw kuki mur tsiyatamaam pinasaktana kurakaatsi, Móysis Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ashiriya, Apanll Móysisee misha Aaronaa ashiru kamachtaku tárangiya; Ashiri kurak mikeeru Israelchichee tashitungamaam kamachtachpa. Israelchichi Ijiptosh watsapun taarusinapa, Apanll iyaa táyacha, tángcha, Apanll Móysisee tárangiya. Ashiriya, na kamaneena yuwaa Apanll Móysispat tsiyatku tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ashiri Apanll Ijiptosh tsap Móysisee tsiyatarangu, tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Nuw Apanlltana, Taarashipani, ashiri shiysha Ijiptoshchee kurak parawa, tsiyatashini. Nuwaa kuki ichinguru kamaningcha parawaatsi, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Itaru, Móysissha yámku tárangiya; Apaa, nuw kurakpat tsiyatamaam waritareezi. Ashirucha, nuw shiyaa áti, ¿antaati kurak nuwaa kuki payucheeja? Ndambari, Móysis Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Itaru Apanllsha; Mazinangcha; nuw nuwaana shiyaa parawpat tsiyatamaam ipusarangina. Ashiriya, shiysha nuwaa kuki Aaronaa kamaningcha. Sheeru, Aaronsha nuwaa kuki parawaa kamanichpa. Shiypaz ashiru kurakaa tsiyatchiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Itaru, shiysha izuuru nuwaa kuki ichinguru zuwanlleetsish Aarona kamaningcha. Anumun Aaronsha parawaa Israelchichee tashitungamaam tsiyatchiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Itaru, nuwaa kuki kamankitaatis, kurak siyaa zanganimaam kapung ngatachparee. Watam nuwsha kurakush mang' xarashish nda shiyaa zanganimaam wayakchinawa. Ashiri yuwash kurak shiyaa tuxarakchu anush nuwsha wizpurireetsi wanimaam yámandachima. Itaru ashtaa, uwsha shiyaa nda zanganchiya; wandari pachindchiya, Apanlli tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Itaru, Ijiptoshuch kurak parawa nda siyaa kukis payukchu, nuwsha wizpuri aranginasha Ijiptosh tsap kasachima. Yuwamand siyaa kiyung yacharangana anumand nuwsha kapung wanichima. Sheeruri, nuwaanaatsi tputsiree tashitungachima. Israelchichi sundar tamapari ashirusin marchampatari shitungchinllinaya, Apanlli Móysisi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ashiri, misha tárangiya; Amb ashkachuri anush, Ijiptoshchi tputs nuwaa yasachinlliniya. Ashiri waatatparee niya Apanlliya, Israelchich Apanlliriniya, nuwaa tputs ichingurusin táchinllinaya, Apanlli Móysisee tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ashiri Móysisi misha Aarona ashirusin, Apanllee kuk izuuru payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ashiri Móysisi mishat Aaronatam parawpa tsiyatarangsin, Móysisi 80 masachirini taarangiya. Aaronsha 83 masachirini taarangiya. Aship masachirini taarusin, kurakpa parawpa tsiyataranganaya. Ashiriya, na kamaneena yuwaa Apanll Móysisee mishat Aaronaatstam yusur kamachtaku, punirintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ashiri Taarashipansha Móysisee, Aaronaa ashiru tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Ashiriya, siysa kurakpat tsiyatkus, siyaa kurak kamachtakchu; Natu Apanllirish wizpur nuwaa yámandanda, tákchu, shiysha Móysisee tushuwshish Aaronaa panangcha. Aaronsha tushuwshishee yáyaru, tsapush kapeetachpa. Ashiri tushuwshishsha makaam kinachiya, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ashiriya, Móysissha Aaronpa ipuneersin, kurakap parawap naatarangiya. Napkatssin, Móysissha yuwari Taarashipan kamachtarangu anuritam tuminuranganaya. Parawanungarita misha yuwash wasundurur shaaneerana annungiritam, Aaron tushuwshineetsi yáyaru, tsapush kapitarangiya. Anurisha tushuwshishsha makaam kinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Itaru, uwsha kurak paraw wishunoo, kizpur yasamawaa, kuruzirangiya. Kusateersin, parawsha, Natu siysa shingtamtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ashiri wishunsha tushuwshinee ashpartisin kapitarangtamanaya. Wishunsha tushuwshini makaamtam kinaranganaya. Itaru, Aaronsha tushuwshini yuw makaam kinarangu an wishunoo makarinee izuuru katungeeru, pisharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Itaru ashiritaa, kurak paraw waantari Israelchichee pachindarangiya. Nda anumun mang' taturangiya. Yuwari Taarashipan tárangu anuri tuminurangiya. Siy nuwaa wizpuri yámandaktaateesa, kurak siyaa zangancheeja, tárangu anurita. Ashiriya na kamaneena yuwaa Aarona tushuwshineetsi kapeeteeru, makaamsha kinarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ashiriya, Taarashipansha Móysisee tárangiya; Kurak siyaa tuxarakchu, nda Israelchichee tashitungamaam zandchiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ashiri pu puturi naayarush, kurakap napangcha. Ashiri waana kurak kungup chumakatu naakchu, shiysha tushuwshiptish yáyarush, ambtam naangcha. Anush kuseerush, kungumun wingu k'tangcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ashiri kurakaa tsiyatkush tángcha; Taarashipani, Israelchich Apanllirini, nuwaa ningeem shiyapat tsiyatamaam zanganirangiya. Taarashipan shiyaa ateeja; Israelchichee arap machip tuzanganichpa. Nuwaa waani ungirtapana, Taarashipani shiyaa átcha, tángcha. Itaru, shiysha wandari nda tashitungamaam zandaksha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ashiri na Taarashipan shiyaa ateeja: Na shaana yasachsha nuwaatsi. Nuw Apanlli Taarashipantana. Apanll Taarashipani shiyaa átcha, parawaa tángcha. Sheeru, shiysha arang kamaningcha: Nuw nee kungoo Nilo tushuwshipti tiyá ashkachuri, kungsha kuraseem kinachiya, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Sheeruri, kayupichsha ichinguru tsipachinllinaya. Ashiri kungsha izuuru k'punichiya. Ijiptoshuch waamaam izuuru pinasachinlliniya, watam kung k'punshtawa, tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ashiri anumunsha Taarashipan Móysisee tárangiya; Parawpa tsiyatkush, shiysha kamaningcha Aaronaatsi; Aaron tushuwshini yáyaru, kungup uw ínachpa. Ichingurup kung pakcheewpitamta misha ktsimshutamta kungu Ijiptoshu, ichingurush kung waani kuraseem kinachpa yuw kung suwish kayatamash tipamaw taarataru antam waani ashpari kuraseem kinachpa, Aaronaa kamachtakchush tángcha, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ashiriya, Móysissha Aaronpa anuri Taarashipanee kuk tuminuranganaya, yuwari Taarashipan kamachtarangu anurita. Kung Nilop puturita naatarangsin, parawaa chamayangayarusin, Taarashipanee kuk kamanirangana. Ashiri Aaronsha tushuwshineetsini yáyaru, kungoo Niloo stee ashirangiya. Kurak paru misha wasundururtam ichingurusin parsina, ashkachu, kungsha kuraseem kinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ashiri kayupichsha mang ichingurusin tsiparanganiya. Kungsha izuururu k'puneerangiya. Ashiri Ijiptoshuchsha tputs kungoo waamaam pinasaranganiya. Ijiptosh ichinguru kung kurasinandari shuneeru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Itaru, uwshatssin Ijiptoshuch wishun ambitam ashiranganaya. Ashirucha, kurak paraw Móysisimun misha Aaronamuntam nda mang' taturangu. Wandari Israelchichee tashitungamaam pachindarangiya. Ashiri yuwari Taarashipan sirútama waana tárangu anuritam kurak ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ashiri parawsha wapitam pangup kanapurangiya. Pakchiyam nda anumun mang' chinarangiya. Mishat, anoo izuuru mapiyrangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ashiriya, Ijiptoshuchsha ichingurusin kungunung wing kungoo waasheem ktsiranganaya, Kung wanasir waamaam tipapani atusina. Ashiriya na kamaneena yuwaa Móysisi ichtakchuri kungoo kuraseem ínarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ashiri tsimbun matayaru maaramchu, yuwamun Taarashipan kungoo Nilo tiyá shingcha tárangu anumun iwaz, yusur Taarashipan Móysisee tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Taarashipani Móysisee tárangiya; Naayarush, kurakaa tsiyatkush, Taarashipan ateeja tángcha; Nuwaa tputsiree tashitungachpa. Waani arap naayarusin, nuwaa ungirtapana, átcha Taarashipani shiyaatsi, tángcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Mishat, tángcha; Nduniya, shiy nuwaa tputsiree Israelchichee tashitungakush, ashiri nuwsha aranginasha purumburpa wanichintspa siyaatsi. Ichinguru tputsush pangu purumbur kuschinllinaya, átcha Taarashipani, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mishat, yuwash kung kaputkachu anush purumbursha zapan shitungartachiya, Nilosh kunguya. Sheeru, shiyash pangish pshtuchtamtiya purumburuya, mishat kirimshitamtish pshtuchiya. Sheeru, purumbur sundararishtamtish pang' pshtuchiya. Mishat, yuwash pangaa tinakana anshutamtiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Purumbur ichinguru shuneeru pshtuturtachiya, átcha Taarashipani, tángcha, Apanll Móysisee tárangiya. Ashiriya, Móysissha mishat Aarona ashirusin parawap naayarusin, parawaa kamanirangiya, purumburootsi. Itaru, parawsha anoo nda mazinamaam zandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ashiri Taarashipan Móysisee, tárangiya. Ashiri shiysha Aaronaa kamachtangcha. Aaronsha tushuwshineetsi yáyaru, kung sur Niloo ínachpa. Mishat, kung wazangamaatstam ínachpa. Ashkachu, anush purumbur zapan shitungartachiya. Sheeru, Ijiptosh tsap shuneeru tatsitchiya, Taarashipan Móysisee kamachtaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ashiri Móysissha Aaronaa kamachtarangiya. Ashiri Aaronsha tushuwshini yáyaru, ichingurush kung Ijiptosh wakungar ína ína ashirangiya. Ashkachu, purumbursha zapan shitungartarangiya. Sheeru, Ijiptosh watsapun izuuru ichinguru shuneeru tatsitarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Itaru, wishunshtisin wizpurpa ambtam ashiranganaya, purumburoo kungushta tashitungarangitamanaya. Ichingurushta yakat purumbur pshturangitamta, Ijiptosh tsap tatsitarangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ashiri kuraksha purumburumun kapung tsiyantayaru, Móysisee misha Aaronaatstam kuruzumaam tiptsiree kamachtarangiya. Ashiri Móysissha Aaronpat kuseersin, kuraksha Móysisee tárangiya; Ashiri siysa Taarashipanee ichinguru purumbur pastamaama mashangtsa nuwashu pangee, mishat tputsirishtamti pangu. Ashkachus, purumbur pastaramchu, ashiri nuwsha siyaa tputsirish Israelchichis ichinguru zanganchima. Ashiri siysa Taarashipaneetsi mangis kis ungirtatssa, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ashiriya, Móysissha; Ashiri shiysha nuwaa kamaninda ¿ashinooja nuw shiyaam Taarashipanpa tsiyatchi? Ashiri kamaningandama. Itaru, purumbur shitungartachusin, kungushumarisha wing waani ashpari purumbur taachinlliniya, Móysis kurakaa parawaa tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Ashiri kuraksha; Zuraktishcha. Ashiri puturi zar purumbur tsipachpa, kurak tárangiya. Ashiri Móysissha; Ayu, waritachparee, tárangiya. Ashiri pu zar purumbur pastakachu, anumun shiy yasachsha. Apanll Taarashipan minamari kizpur taakiya; arangeem Apanll wanindaja, táchpasha, Móysisi kurakaa tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ashiriya, Móysissha misha Aarona ashirusin, kurakush pang' shitungeersin, Taarashipanpa tsiyatarangiya. Taarashipanpa tsiyatku; Apaa, shiy kizpurtishcha. Kurakush pangu ichinguru purumburoo tashitungangcha yuwaa shaana zanganirangish anootsi, Móysis Apanllpa tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ashiri Taarashipansha, purumburu izuuru tpachingarangiya. Ichinguru purumbur tsiparanganaya. Kurakush pangu, misha wishchiptamta, misha mazarpitamta izuuru pchingarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ashiriya, Ijiptoshuchsha tputs purumburoo tsiparee zapan tapuyaranganaya. Ashiri purumbursha tsipar yaktash shuneeru, k'pun pchazarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Itaru, Taarashipan kapungtaa istarangu, nda anumun mangu taturanganaya. Anoo mapiyarusin, yusur kurak Israelchichee zanganimaam pachindarangiya. Nda pakchiyam Taarashipanee punirangiya. Ashirucha, nda pakchiyam Móysisimun misha Aaronamuntaa nda mangu taturangiya. Yuwari Taarashipan tárangu anuritam tuminurangiya. Anuritam kurak Móysisee kuku ngatarangiya. Ashiriya, na kamaneena yuwaa Apanll tsimbunarini waneeshish purumburpa Ijiptoshchee waneerangu anu. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ashiri Taarashipansha Móysisee tsiyatku; Shiysha Aaronaa kamachtangcha. Aaronsha tushuwshinpa tsapumun tpaw ashichpa. Ashkachu, puyumbuchsha manxoom kinachiya, Taarashipan Móysisee tárangiya. Ashiri Móysissha anuritam Taarashipanee kuk payuyaru, Aaronaatssha kamachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Aaronsha tushuwshineetsi itsireeru, Ijiptoshchimun watsapun tiyá ashirangiya. Ashkachu, anush puyumbsha manxoom kinayaru, zapani shitungartarangiya. Sheeru, Ijiptoshchee tputs ichingurusin itipuranganaya. Maachtawa chinuzeetstam ichinguroo itipurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Itaru, Ijiptoshuchsha wishunurini, ambitam sheeyani tárangitaatssin, itaru xapooranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Itaru, uwshatssin wishun kurakaa táranganaya; in waatatamcha Apanllimun wizpuri ashkanaya, táranganaya. Ashirangtaa, kuraksha wandari tputsee zanganimaam pachindarangiya. Yuwari Taarashipan tárangu anuritam tuminurangiya. Izuuru Israelchicheetsi pachindarangiya. Ashiriya, na kamaneena yuwaa Apanll tuchparini waneeshish Ijiptoshchee manxupat waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ashiri Taarashipan Móysisee tárangiya: Ashiri pu puturi chiyzayarush, yap kurak kungup upeewap naakchu amb shiysha tachiteerush, nuwaa kuki kamaningcha. Ashiri shiy tángcha; Ateeja Taarashipani shiyaatsi; Israelchichee tputs zanganichpa, waani nuwaa ungirtapana, átcha Taarashipani tángcha kurakaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Itaru, nduniya Israelchichee zanganimaam zandkush, nuwsha aranginasha ptarpa wanichintspa. Siyashchee tputs muntamaam zapan ptar zanganchima, mishat tputsireetstamtish, sundarureetsish. Ichinguru pangus shuneeru ptar tputsee muntachinlliniya. Mishat, izuuru anshuri ptar taachiya; nda tsipachiya. Ijiptoshchish tputs pangu izuuru ptar ashpari tatsitchiya, misha tipuranllizeetstamtiya, átcha Taarashipani shiyaatsi, kurakaa tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mishat, kamaningcha; Shiyaa ateeja; Itaru, tsap sur Ngusenpi nuw nda ptaroo zanganchima, watam anush nuw tputsiri taakanawa; anush ptar izuuru ndunchiya. Itaru, Ijiptoshcheetsim ptar kapung muntachiya, ");
INSERT INTO cbuNT_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Itaru, Israelchicheetssha nda ptar muntachiya. Ashiri shiysha, parawau, anumun nuwaa yasachsha. Nuw nuwaanaatsi tputsiri kis napkina. Itaru, shiyaa tputsirish, parawau, nda kis napkina. Ashiri nuw pu ptaroo zanganchima, átcha Taarashipani shiyaatsi, tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Móysissha parawaa Taarashipanee kuk kamanirangtaa, itaru parawsha Israelchichee zanganimaam wand ngatarangiya. Ashiri Taarashipansha kukoo izuuru mang' tuminurangiya yuwaa waana tsiyatarangu anootsi. Ashiri ptarsha zapan kuseerangiya kurakush pangu, misha wasundururshutam pang' ichinguru pangus shuneeru kuseerangiya. Izuuru Ijiptosh yaktarini tatsitarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ashiri kuraksha yusur Móysisee zoonllpat kuruzurangiya. Ashiri kusarangsin, kuraksha Móysisee tárangiya; Ashiri nanaa izuurushapari naatssa; sheerus, Apanllireetsis saani ungirtatssa. Itaru, izuurina nuwash tsapuni shtungintspa, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ashiriya, Móysissha, Nuw shiyamun mangi tatkeezi. Itaru, iy ambinaa ashkachuni, iyaa Ijiptoshuch tputs ksaja napchinllina yuwaa Apanllee ungirtakani anootsi. Ashiri iyaani maacheetsi chinuzee pachayaruni, sumasush mucheeruni, anoo pakchusin, anumand iyaa natsachapsiniya, watam uwin maacheetsi nda amb ashkanawa. Ashiri anoo pakchusin, izuuru iyaa patumbichpat pachachpasinaya, Móysisi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Itaru, iy izuuru arap naayaruni, tuchipash zar naayaruni, anushpari Apanllirineetsini Taarashipani ungirtachiniya. Maacheetsi chinuz pachayaruni, sumasush muchiruni, mangini kis Apanllee ungirtachiniya. Yuwaa waana Apanll Taarashipani kamachtarangu anoo izuuru tuminchiniya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ashiri kuraksha; Ashiri saani naangsints. Arap machip naayarus, Apanllireetsis Taarashipan ungirtangsints. Itaru, naamana izuuru arap naarintspa. Ashiri misha, nuwaam Apanllpa tsiyatangcha, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ashiri Móysissha; Ashiri nuw shitungachuri, naturitam Apanllee Taarashipani mashkachuri, putari zar Ijiptosh ptar tsipachiya. Ichingurush tputsirish izuuru pastachiya, sundararishtamtish, mishat tputsirishtamsha. Ichingurusin mapiyshtisin mang' kis taachinllinaya. Itaru, shiysha nduniya arangeem nuwaa ngicheemchush. Ashiriya, iy naayaruni, Apanllirineetsini Taarashipaneem chinuzee mbuteeruni, ungirtachinipa. Itaru, shiysha arangeem iyaa ngichinllpa, Móysis kurakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ashiri Móysissha kurakush pang' shitungeeru, Apanllpa tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ashiri ptarsha ichinguru shitungarangiya kurakush pangu, misha Ijiptoshchish watsapun izuuru ptar pastarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Itaru ashiritaa, kurak Israelchichee yusur pachindarangiya. Nda zanganimaam zandarangiya. Ashiriya, na kamaneena yuwaa Apanll Ijiptoshchee ipunpunarini ptarpata waneerangu anootsi ");
INSERT INTO cbuNT_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ashiriya, Taarashipan Móysisee tárangiya, shiysha nuwaa kuki kurakaa kamaningcha; Taarashipani, Israelchich Apanllirini, shiyaa ateeja, tángcha; Nuwaa tputsiri zanganichpa. Waani arap naayarusin, nuwaa ungirtapana, Taarashipan shiyaa átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mishat, nduniya nuwaa tputsiri tashitungakchush, wandari tashitungamaam pachindkush, ");
INSERT INTO cbuNT_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nuw shiyaa waneekchuri, nuw wizpuriri shiyash wakararish wayakchuri, wakarareetsish tsutashishsha kizpur yutarit tsutatchiya. Ashkachu, wakararish, tsipachinlliniya; misha kapaachtamtiya, misha chiptamtiya, misha kameechtamtiya, misha wakar wizariya, misha opeejarish tsipachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Itaru, Israelchich wakararini Ijiptoshtaa tsap taarusin, ashtaa nda minumtiyam chinu tsipachinlliniya, Taarashipani shiyaa átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mishat, Taarashipan waneeshee wayamaam zaree wayarangcha. Nuw putari zar waneeshee wayachima, átcha, tángcha, Taarashipan Móysisee tárangiya. Táyaru; Móysissha parawap naatarangu, ichinguru kamanirangiya. Ashiritaa, paraw wand Israelchichee zanganimaam pachindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ashiri putamsha zar Taarashipan waneeshishsha wakarashu wayarangiya. Ijiptoshuch wakararinee tsutashshimun ichinguru tsiparanganaya. Itaru, Israelchichsha chin wakararini nda minumtiyam tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ashiri parawsha kurak tiptsiree kamachtarangiya, Israelchichee chin wakaraa napangtsa, táyaru, Ayu táyarusin, Israelchichee wakararini napeeshinusin, kanapeersin, parawaa kamankusin, Itaru Israelchichsha chin wakararini nda minamtiyam tsiparanganaya, táranganaya. Itaru ashiritaa, kurak nda Israelchichee tashitungamaam zandarangiya. Izuuru pachindarangiya. Ashiriya, na kamaneena yuwaa Apanll zameeturini Ijiptoshchee waneeku, wakararni zapan tsiparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ashiri Taarashipansha Móysisee misha Aaronaa tárangiya; Siysa sumasish puzachee minam kuwiz tachuyarush, kurakash pangu pshtuyarush, kurakanung íwar puzachee kuruta shingcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ashkachush, puzachsha tsutashishsha chiteemsha kinachiya. Chitsha tputsee tsutatkachu, tputs wanuts kuchá kuchá ashchinlliniya. Ijiptoshchee tputs chit ichinguru tsutachiya. Mishat, wakaraatstam ashpari shuneeru chit tsutachtamtaya, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ashiri Móysissha misha Aaron ashirusin, puzachee tachuyarandsin, parawash pangu pshtuyarusin, Móysissha puzachee íwar kuruta ashirangiya. Ashkachu, puzachsha tsutashish chiteem kinarangiya. Sheeru, chitsha Ijiptoshchee tputs ichinguru tsutarangiya; misha, chinuzeetstam wakara ichinguru tsutatarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Itaru, wishunsha nda amb ashiranganaya. Nda Móysispa tatsamooranganaya, watam waanaatstatam wishunu chit tsutarangitamtawa. Mishat, watam ichinguru Ijiptoshchee tputs shuneeru chit tsutataranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Itaru ashiritaa, kuraksha wandari Israelchichee zanganimaam pachindarangiya. Watam waana Taarashipan kurakush mang' xarashish wayaranguwa. Ashirucha, yuwari Taarashipan Móysisee; Shiyaa kukish kurak payucheeja, ndunaree, tárangu anuritam izuuru tuminurangiya. Ashiriya, na kamaneena yuwaa Taarashipan Ijiptoshchi tsutashshipa waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ashiriya, Taarashipan Móysisee tárangiya, Ashiri shiy pu puturi chiyzayarush, naayarush, kurakush kuseerush, kurakaa parawa kamaningcha nuwaa kuki. Kamankush tángcha, Taarashipani, iy Apanllirini ateeja, Nuwaa tputsiri zanganichpa. Waani naayarusin, arap nuwapa ungirtapana, Taarashipani átcha, tángcha, ");
INSERT INTO cbuNT_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mishat, tángcha, Nuwaa tputsiri pachindkachinaareesha, ashiri nuwsha na ini yusur aranginashat ichinguru waneeshish kasiru zanganchima. Nuwaanaatsi waneeshi shiyaama, misha sundareemish, misha tputsireemtamtish zanganchima. Anumun shiy nuwaa yasachsha. Min Apanll tsapurunasush wanindaja nuw tamapari ashiru, Taarashipan átcha, parawaa tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Mishat, Nuw siyaa kachingamaam zandkinaareena, izuurinaapari tputsirpatartish tpachingachina tsutashishpata. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Itaru, nuw nda siyaa ashiru chinarangina. Waani nuwaa wizpuriri pangpana aturi, ningat waneekina. Ashirucha, nda siyaa tpachingakina. Mishat, waani tputs ichingurusin tsapurunas ztaru nuwaa yasapana aturi ashkina. Taarashipan átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Itaru, shiy nuwaa wizpurireetsi paktaatish, ashiritaa wandari shiy nuwaa tputsiri pachindaksha; nda tashitungamaam zandaksha ");
INSERT INTO cbuNT_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mishat, watam wandaya shiy nuwaa kuki nda payukush, nuwsha pu zar puturita nuw kachizamashee kapeetchima íwarpichi kapungumashi ashich patumbich kapungumashi kiyakawa. Yuw nda sirútama pataris anoo pangatssa. Siysa anumun nuwaa yasayarus, siyashuch Ijiptoshuch nda sirútamastaa ashima paturusin, itaru natpursha kachizamashee kapungumashi Ijiptoshuch tputsi pangchinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ashiriya, shiysha parawaa, Tputsireetsish kamaningcha; Wakar ksutamapan, mishat maachiritawaatsis chinuziwaa ichinguru pangush wanasir pishuchinllinpa, tángcha. Wakararis yuw pastu xitangatana anootsi pangusush tapshtungtsa, watam kachizamash pantsatkachu tputseewa pachakchu, tsipachinllinaya; misha chinuzeetstam wakarawaa pachachtamtiya, átcha Taarashipani, tángcha, Taarashipan Móysisee tárangiya. Ashiriya, Móysissha parawap naayaru, ichinguru kamanirangiya, yuwaa Apanll kachizamashee tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ashiri anoo kurak wasundurur mazinayarusin, ashpatam Taarashipanee waneesh kapung puniranganaya. Ashiri chinuzee ksutamapani wakaraa pangush tapshturanganaya. Papcha, kachizamash pantsatkachu, pachatpa, atusina ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Itaru, ashpatamsha wasundurur mazinarangitaatssin, chinoo nda pangush tapshturanganaya. Wakararineetsi izuurusin mapiyranganaya. Wandari wakararni pastush xitangat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ashiri Taarashipansha Móysisee tárangiya; Tushuwshish yáyarush, íwar kanindap tusumingcha; waani kachizamash íwarpich pantsatap tputsimunu, misha chinuzimuntamta, misha iwarzimuntamta Ijiptoshchimun mazari, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ashiriya, Móysissha tushuwshineetsini yáyaru, íwar kanindap tusumirangiya. Ashkachu, Apanllsha kariyaa zanganirangiya. Kariysha kizpur kariytarangiya. Mishat, mamar kizpur mamartarangiya, Ijiptosh yakta. Anumunsha kachizamash kapunguwa íwarpich pantsatarangiya ashcheew patumbich kapungumashi. Izuuru zapan parat parat shitarach ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ashiri kachizamashsha kapungumash pantsatarangiya. Kariy kapung kariytarangiya, Mishat, mamarsha kizpuritam mamartarangu, ashiri anoo paranganaya. Sirútamastaa zitamin tputs nda ashima paturusin, itaru natpursha nlluranurshat Ijiptoshuch tputs ashimaa paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ashiriya, ashpatam tputs yuw mzatsush xitangat ashirangana anu kachizamashsha pacharangiya. Mishat, chinuzee wakarawaatstam pacharangitamta. Mishat, maachi yuw mzatsish tatsummaw taararutaru an tsiparangitamta. Mishat, yasinaatstam ichinguru pacharangiya. Ichinguru tsapoo kachizamash amb ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Itaru, Ngusensha tsap, yuwash Israelchich taarana anush, nda minumtiyam kachizamash pantsatarangiya ");
INSERT INTO cbuNT_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ashiri kuraksha wasundururee kamachtarangiya; Móysisee kuruzushini misha Aaronaatstamta, tárangiya. Wasindarursha Móysisee kuruzeeru, uwsha parawash pang' kuseersin, parawsha tárangiya; Na nuwaanaatsi yasaktana. Nuwcha Apanllee tayutaritki. Mishat, nuwaanamandaritcha ashku, misha nuw tputsiriptarti yutaritaniya. ¿Antaati Apanll mangutaja ashik? ");
INSERT INTO cbuNT_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ashiri na ndusha siyaa arangeem pachindchima. Na siysa Taarashipanee mashangtsa nuwaama; kariyaa mishat kachizamasheemtamta tsipachpa, tángcha, watam iyaa kasikuwa. Ashiri na izuurisha Israelchicheetsi zanganchima, kurak natuma kariyaa, mishat kachizamash ashiru pakeeru, puniyaru, Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ashiri Móysissha kurakaa tárangiya; Ashiri na mikeeru pangatssa; nuw yaktash shitungeeruri, kuwi íwar paxayaruri, Taarashipanpa tsiyatkachuri, ashiri kachizamash zanaychiya. Ndusha arangeem pantsatchiya. Mishat, kariytam pastachiya, nduntam arangeem kariytachiya. Anumand shiy yasachsha; Apanll Taarashipani tsapurunasee waanapari tinarangiya, tátssa. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Itaru, nuw shiyaa yasaktana misha sundareetsish, Apanllee Taarashipani nda punikis, Móysisi kurakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Yuwaa yutee, misha sebaadaatstam tatsumeeru anoo ichinguru kachizamash pacharangiya. Yuwaa sebaad yusiykchu ngumirtambachu, misha yutitam yuwaa chaptambachu anootsiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Itaru, tirikunaa tsipamana tsiparangitaa, itaru yusursha tameeru k'xunamaam waritarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ashiri Móysis kurakush pang' shitungeeru, uwee íwar paxayaru, Taarashipanpa tsiyatarangiya. Ashkachu, mikeeritam kachizamash pastarangiya. Mishat, sinatam izuuru pastarangiya. Mishat, kariytam izuururitam zamarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ashiri kurak anoo ashparita ichinguru parangu, itaru wandaritam pachindarangiya, wasundururpata. ");
INSERT INTO cbuNT_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ashiri kurak paraw izuuru Israelchichee tashitungamaam pachindarangiya, Israelchichee nda zanganimaam zandarangiya. Yuwari Taarashipan tárangu anuri tuminurangiya. Ashiriya, na kamaneena yuwaa Taarashipan tsimbunarni matayaru kachizamashpa waneerangu Ijiptoshchee anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ashiri Apanll Móysisee tárangiya, kurakush pang' pshtuyarush, kurakpa yusur tsiyatashini. Tsiyatkitaatish nda mazinachiya, mishat wasundururtam nda mazinachiya. Wandaritam nuwaa tputsiri zanganimaam pachindchiya. Watam nuw kurakush mangu xarashish wayaranginawa. Ashiriya, wand siyaa zanganimaam pachindchiya. Ashkachu, anumun nuwsha nimun aranginasha nuw wizpurireetsi yámandachima, kizpur napuxtamasheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Anumun siysa nuwaa, Taarashipaneetsi yasatssa. Nuw kapung wizpureetsi yámandakchuri, siysa Israelchichis anoo pakeerus, ipareetsis nuwaa wizpuri kamanimantantsa anumunsha chinllineetstamsa. Urutamari kamanimantarus taatssa, yuwamand Ijiptoshuch nuwaa tayutaritku, nuwsha Ijiptoshucheetsi kapung waneerangi anootsi. Itaru, siyaatsinaa tapachindarangina, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ashiri Móysisi misha Aarona ashirusin kurakap naataranganaya. Kuseersin, kurakaa tsiyatkusin; Taarashipani, Israelchich Apanllirini ateeja shiyaatsi, ¿Wanipaja nuwaa ngicheenll? Mishat, ¿ashinooja nuwaa kuki payuch? átana. Ashiri nuwaa tputsiri mikeerush zanganingcha. Waani arap naayarusin nuwaa ungirtamaama, átcha Apanlli shiyaatsi. Mishat, Apanll atitamta shiyaatsi, ");
INSERT INTO cbuNT_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Shiy nduniya nuwaa kuki payukush, wandari Israelchichee zanganimaam pachindkush, pu zar nuwsha putinduree zanganchima. Shiyash mzarish pantsachiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Putindursha tipuranllizush shuneeru pantsachiya zapaniritaya. Izuureeru tsapoo yambutachiya; nda tsapoo pamaam waritachiya. Mishat, maachiwaatsi, tatsumma tiriku war katungchinlliniya, yuwapur sirútama kachizamash pantsateeru, tatsumma tpachingayaru, pakchimsha katuchirangu anootsi katungchinllinaya. Ichinguru yasinawaatstam war katungchiya. Mishat, wanasirinaariwaatsta, tatsumareetsis katungchinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mishat, shiyash pangish putindur pshtuyarusin tatsitchinlliniya. Mishat, sundarishtamtish panguya, minsha Ijiptoshtam tputs panguya shuneeru pshtuchinlliniya. Izuuru tatsitchinlliniya. Nda sirútama shiy aparinis ashima parangusin, mishat siy pachiris nduntam ashima parangusin, itaru natsha pangchinlliniya, átcha iy Apanllirini shiyaatsi, Móysis kurakaa tárangiya. Ashiri táyaru, kurakush pang' shitungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Shitungaramchusin, kuraksha wasundurur, yuw urkaree ksutkana anshatssin táranganaya, ¿In tputsi wanipaja zar iyaam xarashish wayach? ¿Tamasha shiy nda yasaksha? watam iyash tsapuni kapung tayutaritkanawa. Waani shitungkanlliniya. Sheersin, waani arap naayarusin, Apanllirineetsi ungirtapanaya, wasundurur táranganaya urkareetsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Parawsha; Zuraktischa, tárangiya. Ashiriya, Móysiseetsi yusur kuruzurangiya Aaronaatstamta. Kuskatssin, kuraksha tárangiya: Ashiri naturi naayarus, arap Apanllireetsis ungirtangsints. Itaru, ndatuma naachus, ichtaru nuwaa kamaningandama; ¿Ashiri kaapana wanipis tputsis naamaam zandaksa? Kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ashiri Móysissha; Kachingarutanicha naamaam zandki, ashparitani; iparpatartini, misha wachinpatatamani, misha kamuzpa kizapa ashiru. Minsha chiniptini opeejpatatamta, minsha wakararpatatamti. Kapung shambatkuni, mangini kis Apanllee ungirtapani, átanicha ichinguru ashparitani, Móysis kurakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ashiri kuraksha paraw, kapung tsiyantayaru tárangiya; Na nuw siyaa izuuru yasayana. Siy mantsircha mangishis chinakis, izuuru suwamaam chinaksa. Mishat, siy átpasa, iyaa Apanll Taarashipani istachparee atupsa átssa, kurak tárangiya. Itaru, ¿nuw tamareeja siy ashirina chinakus, nuw siyaa zanganchi? Nuw siyaa ichingurootsis zanganimaam zandkeezi. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Zandkeesa saannandari kamuzanandaritis wachinanandaritis naayarus, Apanllireetsis ungirtashinints, atina nuw siyaatsi, kurak Móysisee támbeeru, pangush tashitungarangiya. ¡Wappa tamundaksa! Naangi, tárangu wishchip zanganirangiya. Kizpur tsiyantarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ashiriya, Apanllsha Móysisee tárangiya, Kuwish íwar Ijiptosh watsapunu paxayangi. Ashkachush, waani putindarsha kusatpana. Sheersin, waani Ijiptosh tsap tatsummawa kachingpana. Yuwapur kachizamash pantsateeru tpachingayaru pakchimsha katuchirangu, anoo kachingchinllinaya, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ashiri Móysissha Apanllee kuk payuyaru, uwee íwar Ijiptosh watsapunu paxayarangiya. Ashiri Apanllsha kambusuroo zanganirangiya. Kambusursha kizpur kambustataru, kaschir zar tapitarach, psaansha ashiritam kambustataru tarasitarach ashirangiya. Putindursha zapan anush kusarangiya. Kambusur putinduree yushindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ashiri putindursha Ijiptosh tsap izuuru tatsitarangiya: uru tipuranllizshutam putindurinandari tatsitarangiya. Ashiri sirútamasta nda ashiru paturusin itaru natpursha putindiree wachpatari paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ashiri izuuru putindar tsapoo purangiya; izuuru zapanirita tsapoo ashchiri yambutarangiya. Ashirucha, tsapoo pamaam izuuru pinasimuna. Sheersin, putindir tatsumma war katungaranganaya. Yuwapur sirútama kachizamash pantsateeru, ichinguroo tatsummaa tpachingayaru, pakchimsha katuchirangu anoo, putindur ichinguru katungaranganaya. Yasinaatstam wanasinaari yambutarangitamta. Wanusee katungarangu, anumunsha warootstam ichinguru katungarangu, minamtiyam nda waru katuchiranganaya. Izuuru ashparit kachingaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ashiri kuraksha parawa mikeeru Móysisee Aaronaatstamta kuruzeeru tárangiya; Nuwcha siyaa Apanlliris kapung tayutaritki, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ashiri na in nuwaa yutaritshishiri mapiyngandama. Ashiri shiysha, Móysisee nuwaam Apanllpa tsiyatangi putindir tsipamaama, watam iyaa kapung muntakuwa, misha iyaa pachamaam zandkuwa. Waani kasapanda, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ashiri Móysissha kurakush pang' shitungeeru, wishchip xiyeeru, Apanllpa kurakaam tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ashiri Apanllsha kambusuru kizpur zanganirangiya. Ashiri kambusursha kizpur kuseeru, putindiree arap musap chumbeepip kapeetarangiya. Ashiri ichinguru Ijiptosh yakat putindir tsíparangiya; izuuru pastarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Itaru, Apanll kurakaa istarangitaa, itaru kuraksha wandari Israelchichee tashitungamaama pachindarangiya. Ashiriya, na kamaneena yuwaa Apanll Ijiptoshchee tuchip matayaru putindurpa waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ashiriya, Apanllsha Móysisee tárangiya, kuwish íwar paxayangi. Ashkachush, zarsha kzachiya. Ichingurush Ijiptosh tsap izuuru zar kzachiya. Ashkachu, izuuru kizpur tapichiya; pamaam izuuru pinasachinlliniya, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ashiri Móysissha íwar uw paxayarangiya. Ashkachu, zarsha ichingurush Ijiptoshchish tsap izuuru kzatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tuchip zar kizpur tap ashirangiya; nda pamaam waritarangiya. Minsha waanpata napamaam, mishat xiymaam izuuru pinasaranganaya. Itaru, Israelushsha nda tapeerangiya; wandari kaschir ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ashiri kuraksha paraw anoo pakeeru, yusur Móysisee kuruzirangiya. Kuruzeeru tárangiya; Ashiri nanaa saanipari arap naayarus, Apanllireetsis Taarashipani ungirtatssa. Mishat, saani ashpartis kachingayarus, iparpatis naayarus, Apanllireetsis ungirtashinints, kurak tárangiya. Itaru, chineetsinaaris, opeejareetsis misha wakarareetsis nishuri ichinguru kamingantsa, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ashiri Móysissha; Ashiri ateesha ashiru, shaana chinish iyaam panachsha. Anoo pachayaruni, muchiruni, anpa iy Taarashipanee ungirtachiniya, Móysis kurakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Itaru, misha Móysisi kurakaa tárangiya. Itaru, iy ichingurutanicha wakararpatartini misha opeejarinpatartini naamaam zandkini. Itaru, iy nish minamtiyam chineetsini kamingamaam zandkeezini. ¿Tamashta yaanaatstari chinini wanasiree ipuseeruni, pachayaruni, mucheeruni, Taarashipanee mangini kis ungirtachini? Móysis kurakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Itaru, Apanll yusur kurakush mang' xarashish wayarangiya. Ashiri yusur kurak pachindarangiya Israelchichee zanganimaama. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ashiri kuraksha kizpur tsiyantaku; Siysa naangints. Yusur ningeem nuwash napispa. Yusur nuwash kuskachus, ashiri nuwsha tputsireetsi kamachtakchuri, nuw tputsiri siyaa pachachiya. Siyaa nda pakchiyam nayanichiya, tárangiya kurak Móysiseetsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ashiri Móysissha; Zuraktishcha, naakchuri ayamtaati shiyash pangcheezi, tárangiya. Ashiriya, na kamaneena yuwaa Apanll ipunpunar matayaru waneerangu zar izuuru kzatarangu Ijiptoshchishu tsapu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ashiriya, yusursha Taarashipan Móysisee tsiyatku tárangiya; Ashiri na nimunurisha wanichima Ijiptoshchee kuraka tiptsireetsimtamta. Sheeru, nimunuri Ijiptoshchee wanimaam kasachima. Ashiri nee waneeshee pakchusin, kurak waantari siyaa, Izuuru tashitungachintssa; Zurampatarisha shtungangtsa nuwash tsapuni. Yusur kanapintspa, kurak siyaa táchiya, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ashiriya, na shiysha Israelchichee kamaningcha kamuzawaatsi misha kizawaatstamta; Yuwash naamaam waritakchis, ndatuma naachus, ashiri ichinguru Ijiptoshchee maachiri mashangtsa. Kamuzawaa misha kizawaatstam maachiritaa masheerus yángtsa. Ijiptoshchee yuwapa washunand taakis anoowaatsi maacheetsi oroopat tinamaatsi, misha kurikpat tinamawaatstamta mashangtsa; sheerus yángtsa, Israelchichee tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ashiri yuwapur naamaam waritakchusin, anush mashkusin, Apanll waana wanasir Ijiptoshchee tuchinarangiya, Israelchicheetsi wanasir chinamaama. Minsha, kurak wasundurur Móysisee kapung punirusin, wanasirsha chinaranganaya. Móysisee kuk Ijiptoshuch tputsi payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ashiri yusursha Móysis kurakap naateeru, tsiyatku tárangiya, Taarashipani shiyaa ateeja, Ashiri na ini psaana schirus nuwsha sundaruri Ijiptoshchis tputs pang' ichingurush pshtuchiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Sheeru, iparis iwachiztamawa pachachiya. Ashiri iparis ichinguru iwachiztamaw tsipachinlliniya. Shiy, parawaa, shiyamari Ijiptoshuchee kasiru taaksha, ashtaa iparish iwachiztam tsipachiya. Mishat, tputstam muchchur, yuw tirikoo tumpani ksutku antam wip iwachiztamaw tsipachinlliniya. Mishat, chinuztam wakar wip iwachiztamaw an ichinguru tsipachtamanaya, átcha Taarashipani shiyaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ashiri ichingurusin Ijiptoshuch tputs wipangaz kapung mang' mantsaksin tanuchinlliniya. Sirútama nduntaa ashiru kiyung kachiytarus, itaru natsha in kizpur kiyung kachiyatssa, átcha Taarashipani shiyaatsi, Móysis kurakaa kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Itaru, Israelchichsha wip nda minumtiyam iwachiztam tsipachinlliniya. Mishat, Israelchich chinutam iwachiztam nduntam tsipachinlliniya. Mishat, Israelchich watumziri nda tanuksin, awu awu táchazinllinaja ndambaree. Israelchichsha tputs zaputuru mapiyrsin taachinllinaya, átcha Taarashipani shiyaatsi, parawaa, Móysis tárangiya. Ashiriya, Móysis tárangitamta parawaatsi; Anumand siysa Taarashipaneetsi yasatssa. Itaru, iyaatssha Israelchicheetsini Taarashipan kis napkiya. Itaru, siyaatssha Ijiptoshcheetsis nda kis napkiya, Móysis tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ashiri ichingurusin shiy tputsirish wip tsiparangana anin, siyashuch tputs nuwash kuseersin, minsha sundaritamtish kuseersin, nuwaa tutunlltayarusin; ashiri natunaa saani arap naangsints, ichingurus ashpartis kachingayarus naangtsa, shiyashuch nuwaa táchinllinaya. Ashiriya, siysa saana naangsints, nuwaa sundarish tákchus, ashiri iysha kachingayaruni naachinipa, Móysis kurakaa tárangiya. Ashiri Móysisi kapung tsiyantayaru, kurakush pang' shitungeeru naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Itaru, Taarashipani Móysisee tárangiya; Ashiri kurak shiyaa kukish payucheeja, ndambaree. Itaru ashkitaa, nuw wizpuree aranginasha yámandachima Ijiptoshchee tputsi, Taarashipani Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ashiri Móysis Aaronpa ipuneerandsin, kurakap pang' naat naat ashirangtaatssin, Taarashipanee kuk kaman kaman ashirangtaatssin, kizpur napuxtashimashee yámandarangitaatssin, itaru ashiritaa, kurak urutari izuuru Israelchichee pachindarangiya. Itaru, watam uru Taarashipani waana parawush mangu xarashshee wayaranguwa, ashirucha, anumand kurak izuuru pachindarangiya Israelchicheetsi zanganimaama. Ashiriya, na kamaneena yuwaa Apanll Ijiptoshchee minam chung wanichima tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ashiri Móysisi misha Aarona wand Ijiptosh tsap taarangsin, ndatuma shitungchusin, Taarashipansha uwaatssin wasina kamachtarangiya; Urutamari minam zaree wayangtsa nda mbizamaam yuwaa nuw tapachindarangi anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Nimun tsup kaneesich yakachu anush Marsush tsup watacha siyaam masach kaneesich yakchu anu. Ashiriya, urutarita Marsush tsupi siy Israelchichis aranginasha nuwaa chinamaam wayangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ashiriya, siysa ichinguroo Israelchichee kamaningcha; Taarashipan ateeja; Uru tsup kaneesich yakachu pakus, anamunsha minam chung zar maaramchus, ashiri siysa ichingurus minamtawari chinis wanasirinand ipuseerus, waanitam wayangtsa; sheerus ksutangtsa. Minamtaw pangus tputs chinoo, opeejaa karupana, nduntaati minam kaaparaa karupana putayarus, saamatawari wayayarus, ksutangtsa, átcha Taarashipan, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Itaru, minamtash pangus tputs pakchiya taaru, ashiri katungkusin, wanutsee kachingchazinllinaja, ndambari. Ashiriya, amuyarinsha, wamindoo yambiyaru, uwapashat washunand katungchinllinpa. Sheersin, wanutsee chawpishtayarusin, ¿wanipamasaja tputs taariya? ashpartisin wanutsee katungchinllinpa, átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ashiriya, uruta Marsush tsup kaneesich yakachu, anumunsha minam chung zar maaramchus, chineetsis putayarus, waanitam wayangtsa. Itaru, chinuz yuw minam masach taaru anu ipuseerus, upapchir wanasiri matambish taaru anu ipusangtsa. Opeejaa karupana, nduntaati ashiru kaaparaa karupan ipusangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Sheeru, anumunsha yusur ipunpunar zari maaramchus, yuwapur tsup tututkachu, anush ichinguru tputs pangus minamtawari tputs Israelchichis chineetsis pachakus, minam zari tapitssa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ashiri anumunsha amb sheerus, chinuzee opeeja karupana pachayarus, amuyarinsha ursirpat pangishis tandapuneetsis wach taparangtsa. Ushinung ningari pakich taparat, arangachsha pakchitam taparak, sheeru íwarsha tspakatu anootssha pakchitam taparat taparat shingtsa. Sheeru, pangusush pshtuyarus, wachoo shtandangtsa, átcha Taarashipan, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ashiri anush zar psaan wanutsee sumasush wanasir ksim ktungangtsa. Wanuts misha karutpa kapizpat, misha pang nda tputama anpat ktungangsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Itaru, pakchiyam wanutsee kaneesa katungintspa. Minsha wanuts k'pama katungintspa. Wanuts ichinguru sumasush ksimanandari, muchpatari, minsha watspatatam, mangpat, mishat washippatatam, ichinguru ashpari sumasush wanasir ksimawa anoo ktungangtsa, átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","11","Itaru, misha mikeerus ktungangtsa. Mishat, k'tuniri kamartayarus, anumunsha spaturis spatayarus, misha tushuwshis yáyarus kuwishis payungtsa, watam mikeerus shitungatssawa. Mishat, pakchiyam katungtsee ktuchintspa. Ichinguru katungamaam pinasakus, ashiri uru zari taraseekchu, katuchimaa ichinguru muchingtsa. Wanutsi katuchintspa, watam na in zar, nuw Taarashipan, siyaa tapachindachintspa. Ashiriya, siysa nuwaa chinamaam urutari shingtsa, átcha Taarashipani, tángcha. Ashiri siysa na saanshuchee tputs anoo ichinguru kamaningtsa, Taarashipan Móysisee mishat Aaronaatstam tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ashiriya, Taarashipan anoo kamanirangu; Ashiri na mazinangtsa, tárangiya. Na in psaan ichinguroots Ijiptoshchee wip iwachiztamarinee pachachima. Ichingurush Ijiptoshuchish pangusi wipaa kamuzawaatsi, misha chinuztam wip upapchireewa tsipachiya. Amb nuw ashkachuri, anumun Ijiptoshuch tputs nuwaa Apanlleetsi Taarashipaneetsi yasachinllinaya. Ashiri uwshatssin táchinllinaya; Iy apanllirini wizpur ndunarcha. Yutaritawcha. Nda iyaa istakiya, táchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Itaru, siynaa Israelchichis punirintspa, tángcha. Siysa na yuwamand kaaparaa karupan ursir yarangis anpa pangeetsis tapararangis anoo, nuw kaaparaa karupan ursir pakchuri siyaa iparis kasachima. Nda minumtiyam siyashchee ipareetsis iwachiztama pachachina; izuuru kasachina, átcha Taarashipani, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ashiriya, siy Israelchichis, ichingurus yuwamand nuw siyaa tapachindarangi anumand nuwaa ungirtangtsa. Yuwash zari tatsamkachu anush siy nuwaa chinayarus; Shiy kizpurtishcha Apaa, táyarus, nuwaa chinangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sheerus, ndatuma opeejaa karupana pacharus, pangaa ísim tputama pangishis pakchiyama wasipuriyam ktuchintspa. Izuuru pangaa tputama kpitangints. Sheeru, arangtach tsimbun mataykachu zar anush pangaa nda tputaru anumarita ktungangtsa. Itaru, tputs anush zar pangaa tputama katungachu, an tputs nuwaa kuki kapeetkiya. Ashkachu anu, siysa tputsee izuuru tashitungangtsa. Ayamtaati iyash kusinllpa, táyarus, saanpatat Israelchichpatatis izuuru tashitungangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ashiriya, chtakchurita nuwaa ungirtamaam shaniyshish kizpur wanasirimshi taachpa. Mishat, yuwash siman tushiykchu anush nuwaa ungirtamaamtam shaniyshish taachtamtiya. Anush zari minamtiyam tputs nda tarawaztachinllinpa. Minam simana tputs nda tarawztaksin taachinllinpa. Itaru, katungsheemamtis anush zar ptatangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","An zar tatsamkachu, anush zar nda pangaa tputamaam katungkus taatssa. Watam an zari nuw siyaa Ijiptosh tsap tashitungaranginawa. Ijiptosh tsap siyaa tashitungayaruri, siyaa tapachindarangina. Arangtach zar tsimbun mataykachu anush zari urutari nuwaa chinayarus, nuwaa ungirtakus tángtsa. Urutamari ashkus taangtsa. Siyashchee nlluranur urutamari kamanimantarus tángtsa. Anoo mbizarintspa, tángcha. Yapamasa siy taakamchis anshutam urutari zari tatsamkachu anush nuwaa ungirtakus tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ashiriya, yuwash tsup Marsu kaneesich yakachu anumun minam chung ipunpunar zar maayarus, yuwash tsup tututkachu anush chtayarus, minam simana tatsamkachu anush, zar veintiyunush, zar pukamchu ksangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Itaru, anush zar mbizarus pangaa tputama ktungintspa. Anu izuuru watsta. Yuw tputs nllitari siyapat taakana antamsin pangaa tputama ktungusinapa, tángcha. Ashiri arangtach zar tsimbun mataykachu anshumari zar ashkus taangtsa. Ashiri siysa, Móysisi, Aarona; Watacha ini Taarashipan kamachtamarini, tputsee siysa kamankus tángtsa. Ashiri siysa urutari Taarashipanee kamachtamarini payungtsa, Israelchichee tángcha, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ashiriya, Móysisi Israelchichee kurakawaatsi kuruzirangiya. Shaniyarusin, Ashiriya, siy tputsireetsis kamaningtsa; Ichingurus naayarus, minamtawaritis chinis nachungashinints minam opeeja karupan pachamaama. Ichingurus izanllpatis washunand shaniyrus katungamaama, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ashiri opeejareetsis karupana pachayarus, yasinsha wapzar sura hisopu yáyarus, anpa opeejpat karupanpa ursir pangishis tandapuneetsis wach taparangtsa. Ushinung ningari pakich taparat, arangachsha pakchitam taparak, sheeru íwarsha tspakatu an pakchitam taparat taparat shingtsa, tángcha. Anoo iwapakchus, pangishis ichingurus pshtungtsa. Shtungintspa wishchipi. Itaru, putam zar shtungangtsa, tángcha tputsireetsis, Móysis Israelchichee kurak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ashiri watam iy Aparini Taarashipani na psaan Ijiptosh watsapunu xiychuwa. Sheeru, Ijiptoshuchee wip iwachiztamawa pachachiya; Ijiptoshchee wipaya. Itaru, pangusee pakchu kuraspa taparamawa anootsim kasachiya. Itaru, siyashchee iparis nda minamtiyam iwachiztamaa pachachiya. Nda minamtiyam nllur iwachiztam tsipachiya, átcha Apanlli, tputsireetsis tángtsa, Móysis Israelchichee kurak kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mishat, tárangitamta kurakaatsi: Ashiri na nimun siy Israelchichis urutamarisha chinatssa yuwaa saana Taarashipanee waneesh parangis anootsiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mishat, yuwaa Taarashipan tsapuneemis panakchu, anush taakamchus, urutari washunand shaniyrus Taarashipanee ungirtangtsa. Urutari anpari ashkus taangtsa. Yuwash zari tatsamkachu anush ichinguru masachi ashishtarus, Taarashipanee ungirtakus, urutari taangsa, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ashiri siyachichsha nlluranuri yasapani atusin, mashkusin; ¿Nee zar mayaamsha psaan opeeja karupana pachayaruni katungkiniya? tákchusin, siysa ipareetsis kamankus tángtsa; ");
INSERT INTO cbuNT_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Taarashipanee ungirtakuni ashkiniya. Watam Taarashipan Ijiptoshchee nlluranur iwachiztama pacharanguwa. Itaru, iyaatssha iparini nda minumtiyam iwachiztama pacharangiya; arangari tushiyrangiya. Iyaa izuuru tapachindarangiya iyaa tsipaani, ipareetsis nlluranuri kamankus, tángcha. Ashirucha, anoo chinamaam nda anoo mbizamaama ashkiniya, siysa kamankus tátssa ipareetssa. Ashiri amb shingtsa, tángcha, Móysisi Israelchichee urkari, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ashiriya, Móysisi tsiyatamaam iwatspayaru, ichingurusin Israelchich tutunlltayarusin, Taarashipanee ungirtaranganaya. Ashiri sheersin, Taarashipanee kuk izuuru tuminuranganaya. Ashiriya, yuwapur Israelchichee Taarashipan tapachindayaru minum zari chinamaam wayarangu anoo kamaneena. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ashiriya, Taarashipan psaan schirus Ijiptosh yakat kuseeru, nlluraa iwachiztamawa pacharangiya. Ashiri ichingurusin Ijiptosh wip iwachiztamaw tsiparanganaya. Kurakawtam wip iwachiztamaw tsiparangiya. Mishat, yuw tputs tumanshishush taarana antamsin wip iwachiztamaw ichinguritam tsiparanganaya. Mishat, chinuzeewtam wip iwachiztamaw ichingurusin tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ashiri anpur zar psaan schirus kuraksha chiyzayaru, misha wasundururtam chiyzateersin, ashparitssin tanuksin zamamtar ashiranganaya wipangzi. Ichinguru yuw tputs wip iwachiztamaw tsiparangana anuwin kapung tanuksin, zamamtar ashiranganaya. Ijiptoshchi minamtiyam pangus tsas ndunirimuna; ichinguru pangus yuw tputs wip iwachiztamaw tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ashiriya, anuritam zar psaan kurak tiptsiree kuruzeeru; Móysisee, Aaronaatstamta kuruzushini, táyaru, zanganirangiya. Uwshatssin yamayashinusin, Móysissha mishat Aaronpat kusaranganaya. Ashiriya, kurak Móysisee tárangiya; Ashiri naturi siy Israelchichis ichingurus nuwash tsapuni shitungeerus arap naatssa. Sheerus, saani Apanllireetsis Taarashipani ungirtangtsa yuw saana zandkis anurita, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ashiriya, chineetsish ichinguru machingtsa. Opeejareetsis misha wakarareetstamtis yuw siy nuwaa sirú mashirangis anuri ichinguru machingtsa. Sheerus, mikeerus shitungeerus naatssa. Itaru, nuwaama Apanllpa tsiyatangi nda nuwaa arang Apanll wanimaama, kurak Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mishat, Ijiptoshuchsha punirustayarusin; Mikeerus shitungeerus naangtsa. Ndunnaa siy mikeerus shitungeerus, naakus, iyshaparee ichingarushtini tsipachiniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ashiri Israelchichsha watungasheem pangaa nda tputama wamarish kchiptaranganaya. Kchiptayarusin, kuyarandsin naataranganaya; Apus katungamaama, atusin, ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ashiriya, Israelchichsha Móysisee kuk payuyarusin, Ijiptoshchee maachiri mashiranganaya. Wamareetsi, misha maachiwaatstaa, urkireetsi misha orootstam tinama mashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ashiri Apanll Ijiptoshchee mang' wanasir tuchinarangu, ashirucha Israelchicheetsi wanasir tsiyataranganaya. Ichinguru maachirita mashirangsin, ashiri uwshatssin ichinguru panaranganaya. Ashiriya, Israelchichsha Ijiptoshchee maachiri zapan mangutari yáyarandsin naataranganaya. Ashiri Ijiptoshcheetssha izuuru ixunayarandsin kasaranganaya. Ashiriya, na kamaneena yuwaa Taarashipan Ijiptoshchee wip iwachiztamawa pacharangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ashiriya, Israelchich Ijiptosh tsap naataranganaya. Yakat Ramsisush sura káyarandsin naataranganaya. Yakat sur Sukotapi ambiri naamani, táyarusin, naatarangana. Israelchich tputs ichingurusin naataranganaya. Kamuzinandari tputs 600 mil taarangiya. Nda kizaa táchkusin, mishat nlluraatstam nduntam táchiranganaya. Ashiri anpat ichinguru washunand zapan tputs naataranganaya. Sundar tamapari ashirusin marchampatari shitungaranganaya Ijiptosh tsapu. Nda punirangana. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ashiri chinu zapani opeejaatsi misha wakaraatstamta machiranganaya. Mishat, minshuch tputsi zapan uwapashtisin washunand yapandayarusin naataranganaya Israelchichipata. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Mikeeru shitungkatssin, katungtseem patatamaama zar nda tatsamoorangiya. Ashirucha, pangaa nda tputama mangutari yuwaa Ijiptosh yarangana anoo anurisha pangaa museersin, upusap katungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Ashirucha, Taarashipan tiptsiri Ijiptosh tsap shitungeerandsin, anush zar tatsamoorangiya 430 masachi yuwapur Ijiptosh watsapun kuseersin taarangana anpuru. Sundar tamapari ashirusin, nda puniksin, marchampatari naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ashiri Taarashipan psaan napku, Israelchichee ksutarangiya. Ksutarangu, Israelchichee tapachindarangiya. Ijiptosh tsap tashitungarangiya. Yuwaa Taarashipan iyaa tapachindarangu anoo nda mbizamaama, atusin, uru Israelchich tputs zari tatsamkachu anush nda maaksin, psaan shaneersin, tarastaranaya. Ashirucha, Israelchich nlluranuri urutamaritam nda maaksin psaan taraschitamanaya. Ashiriya, na kamaneena yuwaa Israelchich Ijiptosh tsap shitungarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ashiriya, Ijiptoshuch kurak Israelchichee zanganirangiya. Nish nuwash tsapuni shitungeerus, arap naatssa, kurak tárangiya. Yap naakchinllina ambi Apanllsha waana ngootsee yámandarangiya. Itaru, nda machirangiya yap Filistew taakana ambi. An ngoots naamaam Kanaanap watsiritamunta naamaama. Itaru, Apanllsha mangush chinaku; Amb naakchinaareesinaya ashiru, Filistewshapari Israelchichee pakchusin, pachachinllinaya. Pachakchusin, ashiri Israelchichsha punikchusin, waptamshaparee Ijiptoptam kanapchinlliniya, Apanll mangush chinaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ashirucha, Apanll Israelchichee kamachtarangiya ngootsee iturpimaama. Ashiri Israelchichsha Apanllee kuk payuyarusin, ngootsee iturpiyarandsin, yap kung mar chumbeepimashi sur taaru ambi. Amb sheersin, ichingurusin sundar tamapari ashirusin marchamchusin, Ijiptoo tsap kasayarandsin, shitungaranganaya manga. ");
INSERT INTO cbuNT_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Itaru, ndatuma naarsin, Móysisi tputsee kamachtarangiya Osiyarineetsini wanap yamaama. Watam waana Osiyarini, ndatuma tsipachu, zoonllee kamachtaranguwa; Ashiri nuw átana siyaatsi; Apanll izuuru kusachparee iyashchee istamaamaya. Ashiri naakchus, siysa nuwaa napuri nish Ijiptosh tsap ksarintspa. Siysa yángtsa, Osiyarini tárangiya. Ashiri Móysissha anuritam chinarangu, Osiyarinee wanap yarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ashiri Israelchichsha naayarusin, Sukotush yakta shitungeerandsin, tsap sur Etamap naataranganaya. Etamush kuseersin, yuwash maach chtakatu anshurisha tambtaranganaya. Watam tambtamaam taspat tinamaw payuranganawa. Anush Etamush kanusaranganaya. Itaru, Taarashipansha pakchiyam Israelchichee nda kasarangiya; kapung ksutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Taarashipansha kaschiritam wanasir machirangiya. Psaspa zaree kámanamaam wayarangiya yap Israelchich naamachinllina amb ngootsi. Psaansha ashiritam sumas tamatarpari ashiru tuwasineerangiya ngootspi. ");
INSERT INTO cbuNT_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ashirucha, Israelchich anshuri naataranganaya, watam kaschir psas zaree kámanaranguwa. Ashirucha, anshurisha tasaseerandsin naaranganaya. Psaantam sumas ashiru tuwasineerangiya. Yap sumas ashiru tuwasineeru, ambiri tasaseerandsin, Israelchich naamach ashiranganaya. Ashiri Taarashipan waana Israelchichee kapunguri istarangiya. Pakchiyam nda psas mishat sumastamta tsíparangiya. Ichinguru zar kaschiritam psaantam ashiru taarangiya. Ashiri na kamaneena yuwaa Apanll Israelchichee Ijiptosh tsap tashitungarangu, waana machirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ashiriya, Taarashipansha waana Móysispa tsiyatku; ");
INSERT INTO cbuNT_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Ashiri shiy kamaningcha Israelchicheetsi, wapitam maramun wingu kanapeerus, washunand yakat sur Pi-ayirota annungi anush shaniychinllinpa. Yakat Baal-Sifron sur arachchi tasasaru taariya. Ashiri Pi-ayirotanungi tambtayarusin taachinllinpa, átcha Taarashipani tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ashkachus, parawsha mangush chinaku; Israelchich mangutari ipusap masarsin xitangatanaya, táchparee. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Sheeru, wasundururpat siyaa pachamaam tachitchinlliniya. Itaru, nuwsha siyaa istachintspa siyaa kurak tuxaraktaati ashiru. Ashiri nuwsha wizpurireetsi yámandakchuri, parawaa wasundururpatari kachingchima. Anumun nuwaa tputs ichingurusin yasachinllinaya. Mishat, Ijiptoshuchsha nuwaa yasachtamanaya; Watacha Apanll Taarashipani, wizpurpat tputsee kachingarangu, nuwaa táchinllinaya, Apanll Móysisee tárangiya. Ashiri Israelchichsha anuri Taarashipanee kuk payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ashiri kurakaatssha parawaa tputs tsiyatsis kamankusin; Papcha, Israelchich izuuru suwasuwayaranllinpa, tárangusin, anoo mazinayaru, kuraksha wasundururee kuruzurangiya Israelchichee tachitamaama. ¿Mayaamsha iyaa Israelchich izuuru kasayarusin naayaranlliniya? Anoo zandkeezi. ¿Iyaam chakanashtaja tarawaztachinllina? kurak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ashiri kuraksha mikeeru wasundururee kamachtayaru; kapaachumun wanasir pshiyrshineetsi kasingtsa. Sheeruni, Israelchichee tachiteeni, tárangiya. Ashiri wasundurursha kapaachoo pshiyrshini tapazpanee yátaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ashiri tapazpanee kapaach pshiyrshini 600 wanasirinandari yátaranganaya. Anumunshat kapaachoo pshiyrshini sirapcheewaatstam yátarangtamanaya. Ashiri aship pshiyrshinee yáyarandsin, Ijiptoshuch sundar naataranganaya. Minamtawush pshiyrshini, minamtaw komandante tachitaranganaya. Sheersin, Israelchichee tachitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Taarashipan kurakaa paraw mangu tuchinarangiya Israelchichee tuxaramaama. Ashiri parawsha wasundururee kamachtaku; Israelchichee tachiteeruni pachayani, tárangiya. Itaru, Israelchichsha Taarashipanimun wizpur Ijiptosh tsap shitungeerandsin, sundar tamapari ashirusin marchampatari shitungeerandsin, naataranganaya. Itaru, ashiritaa parawsha Israelchichee pachamaam tachitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ashiri Ijiptoshuchsha sundar Israelchichee tachitaranganaya. Kapaachurinpa pshiyrshini, misha kapaachumun ush kuxineerandsin, kurak paraw wasundururpat kachingarsin, Israelchichee tachitaranganaya. Sheersin, tachitarangsin, apus marimun wingu kamataranganaya Pi-ayirotanungi, yuwash washunand shaniyarangana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ashiriya, Israelchichsha arapeetari Ijiptoshchee kurak wasundurur paranganaya. Ashiri kapung puniyarusin; Ay, sitatstee, ¿tamachchee? táranganaya. Ashiri kapung punirusin Taarashipaneetssha; Apaa, iyaa istangcha. Iyaa nayaningcha, átangat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ashiriya, Móysiseetssha; ¿Shiy mayaamsha iyaa ningeem Ijiptosh tsap tashitungayarush, ningeem machirangsha? ¿Antaati Ijiptosh tsap mapshish ndunshat? Shiy ngutish iyaa ningeem tsipamaam yushindarangsha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","¿Ndusha iy shiyaa tárangini, shiy iyaa tamundarinllpa? Iyaani nish Ijiptosh tsap taakuni, m'chach tamapari ashiruni tarawaztakuni taachinipa, shiyaa táranginiwa. Itaru, shiysha iyaa ningeem kanatspamaam yushindarangsha, Israelchichi Móysisee táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Itaru, Móysissha; Punirintspa. Mapiyngtsa. Siy izuuru mapiymari mapiyngtsa. Ashiri na Taarashipan iyaa tapachindamaam kuschiya. Naturi Ijiptoshchee puniksa. Itaru, izuuru Ijiptoshuch pastachiya, Móysisi Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ashiri siy na izuuru mapiyngtsa. Waana Taarashipan siyamand waratchiya, Móysisi Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ashiri Taarashipansha Móysisee, tárangiya, ¿Mayaamsha shiy nuwaa mash mash ashiksha? Na waapa. Natu, Israelchichee kamachtangi waani aranginasha mapiyru naamaama. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ashiri shiysha tushuwshish yáyarush, marip kung tasaseerush, arachich mar tusumingi. Ashkachush, marsha kung apusinand itsupatara sheeru, tsapsha puriyatara ashchiya. Ashkachu, anush siysa arachich kitartatssa. Tsap puzamun naatssa, Taarashipan Móysiseetsi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mishat, Taarashipan tárangitamta; Ashiri na nuw paraw wasundururpat izuuru wanichima. Nuw parawash mang' xarashish wayarangina. Ashiri siyaa tachitkachunts, nuwsha wizpureetsi yámandakchuri, nuwamari parawaa kasichima, wasundururpat, misha kapaachpat pshiyrshini, misha kapaachirinpatatam, ashpari ichinguru pastachinllinaya, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ashiri nuw wizpureetsi yámandaramchuri, yuwaa kurak paraw wasundururpatari ashparit pastarangu anu mazinakchusin, ichingurusin Ijiptoshuch tputs nuwaa yasachinlliniya; Waatapari niya, Taarashipani, Israelchich Apanlliriniya, nuwaa táchinllinaya, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ashirucha, Apanllsha wasundurur yuwash psas shuruchungaru anush yamazaru tachitarangiya Israelchichee ksutamaama. Psasshat tputsee kánuru uwma arangeem imazaru naarangiya. Sheeru, uwsha Apanll wasundurur Israelchichinung ush tachitarangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ashiri psassha Israelchichinungi tuwap kámanarangiya. Ashirucha, Ijiptoshuchsha Israelchichee pamaam pinasarangana, watam psas tuwapimunuwa. Itaru, Israelchicheetssha psas tuwasineerangiya; nda tapeerangiya. Ashirucha, Ijiptoshuch Israelchichee kamatamaam pinasarangana. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ashiri Móysissha tushuwshineetsini yáyaru, maree kung tasaseeru, arachich tusumarangiya. Tusumta ashirangu, Taarashipansha kambusuru kizpur zanganirangiya. Ashiri kambusursha kizpur kambustataru, kambustataru tapeerangiya. Psaansha ashiritam kambustataru tarasitaranll ashirangiya. Ashiri marsha apusanand itsupatara sheeru, tuwanlltatara ashirangiya. Ashkachu, tsapsha puriyatara ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Tsap puzatara sheeru, ngoots ashiru kawaramach ashirangiya. Anush Israelchichsha naataranganaya. Ashiri kungsha tsimbun machtarangiya tsap tamapari ashiru mbutsinung maachtaru, mbazinungich maachtaru ashirangiya. Ashiri Israelchichsha ngootsush naayarusin, marush kung arachich kitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ashiri anushsha paraw wasundurur kapaachurinpa, minsha tapazpanpatatam kapaachpa pshiyrshini Israelchicheem pachamaam ambtam ngoots tachitaranganaya. Ngootsush tachitarusin, zar tarasitaranllu, apusanandtachu, ");
INSERT INTO cbuNT_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","anush Taarashipansha mus maree yuwash waana sumas ashiru waneesheem tutsangarangu anush parawsha mishat wasundururtam kuskamchusin, Apanllsha, Natu, natunaaree, tárangiya. Tákchu, kapaachsha pshiyrshirini mantsarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ijiptoshuchsha kapaachurini pshiyrshini ichinguru yutaritarangiya. Maachiri ichingaru ichip ichip ashirangiya. Amb ashirangu, arangeem naamaam pinasaranganaya. Ashiri Ijiptoshuchsha waanpatatin; ¿tamashta ashkachini? Ashiri pza, Israelchichee kasayaruni, waptam kanapeeni, Taarashipan iyaa waneekachpa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Itaru, Israelchichsha ichingurusin wanasiri kitaramchusin, Taarashipansha Móysisee tárangiya; Ashiri, natu; kuwish íwar paxayarush, maree kung tusumingi. Waani kung waptam kanapkachu, Ijiptoshchee tputs pshiyrshinpatari, minsha kapaachurinpatari ashpari pchinganllina, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ashiri Móysissha íwar uwi marip kungu tusumarangiya. Ashiri yuwapur zar shitungarangu anush marsha kung waptam kanapeeru, sirú tamarangpari ashiritam naantaramach ashirangiya. Ijiptoshuchsha; suwayani, atitaatssin, marimunsha kung xarambusin ichingurootssin ashparitaatsiri kung purangiya. Nda minamtiyam tputs kamungarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ashiri marsha waptam zaw ashirangu, izuuru tputsee kungupa tpachingarangiya. Ichinguru Ijiptoshuch pshiyrshirinpatari, minsha kapaachirinpatari ashpari kungush imurish yangarangusin, tsiparangana. Parawaa wasundurur yuwin Israelchichee pachamaam tachitarangana anin nda minumtiyam tputs kamungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Itaru, uwshatssin Israelchich mapiyrsin tsap puzap kitaranganaya. Kung yuwash mbutsinungich watandaram maachtaru arangich mbazinungich maachtaru ashiru, anush Israelchich ngootsush naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ashiri Taarashipan waana, Israelchichee tapachindarangiya, nda Ijiptoshuch pachamaama. Ashiri Israelchichsha marish kung napkusin, tputs tsipar marimun wing muzeerutaru paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ashiri yuwaa Taarashipan Ijiptoshchee sundar kungush yambutarangu anoo Israelchichsha Taarashipanee wizpur parangusin, Taarashipanee puniranganaya. Sheersin, Taarashipanee chinayarusin, Móysiseetsi kuk payuranganaya. Ashiriya, na kamaneena yuwaa Israelchich mar kung sur chumbeepimashee kitarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ashiriya, Móysisi Israelchichpa Taarashipanee ungirtaksin, nee yaseesshshee yaseeranganaya. Taarashipanee yasichima. Watam waanpata wizpur Ijiptoshchee izuuru kasiranguwa. Ijiptoshchee wasundurur, kapaachirinpatari, pshiyrshini ashparit ichingurusin marish kung yangaranganawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ashirucha, anu yaseesshish nuw yaseekina Taarashipaneetsi, watam nuwaa tapachindakuwa, misha nuwaa ksutkuwa. An watacha nuw Apanlliri. Ashirucha, nuw Apanllee ungirtaki. Nuw apari Apanlleetstam ungirtarangu, na nuwsha ashiritam ungirtakina. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Taarashipan tapazpani kizpurcha uwamarita. Minsha, Taarashipan kizpurcha Apanllirita. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ashiri Taarashipan uwamari kasiyaru, marish kung Ijiptoshuch sundar pshiyrshinpatari yangaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Yuw kurak kizpureewa an marish kung ashpari ichingurusin kung chumbeepimashush yangaranganaya. Patumbich tamapari ashirusin marush kung kizpur imurish yangaranganaya. Ashiri Taarashipan undarareetsi wizpuripa kachingarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Taarashipanee, shiy kuwish mbutsinungich kizpurcha. Wizpurirpatish shiy kundarareetsish kasirangsha. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Shiyaatspaz pachamaam zandkusina, ashirangsin, itaru shiysha kapung tsiyantarangush, wizpurirpatish izuuru kasirangsha. Shiy tsiyanish kurayaru, uwshtisin maachi yasin war tamapari ashirusin muchiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ashiri shiy shaana, Taarashipanee, tapusirangush, maree kung apusinand itsupangarangsha. Sheeru, marsha tsimbun wing taarangu, marsha zanaramach ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Itaru, wandanaarsin shiy kundararish chinaksin; Tachiteeruni, kamateeruni, pachayani. Izuuru kachingeeruni kasayani. Sheeruni, maachiritaa ichinguru itutseeruni, yaanpata chawpishtayaruni yapani. Sheeruni, mangini kasayani, tárangpasinaya. K'chirpunguriptini ichinguroo tputsee kachingchinipa, Ijiptoshuch sundar tárangpasinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Itaru, shiysha, Taarashipanee, shaana kambusurush tapusirangush, marsha kung ashpari izuururu purangiya. Maachi munisiy tamapari ashirusin, ichingurusin kungush imurish yangaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Taarashipanee, shiy tamapari tsinsashish ashiru nllitari Apanll wanindaja. Watam shiysha wizpureetsish uru yámandakshawa; tputsee tpuxtakshawa. Ashirucha, shiyaatsimari ungirtamaam waritakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ashiri shaana shiy wizpurireetsish napuxtamashee tuyamandarangush, tsapsha Ijiptoshchee tputs pisharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Shiy Apaa, shaana tputsireetsish kapung chinaksha. Watam iyaa chinakush tapachindarangshawa. Ashiri na shaana chinampatari iyaa machingcha. Wizpurirpatish machingcha yap shaana tsapoo wanasirimshi iyaam ipusarangish ambi. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kanaanshuch tputs ichingurusin shiyaa wizpurirish yasakchusin, kapung puniksin, nungtachinllinaya. Filistewshuch tputs anoo yasakchusin kapung punirastachinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Minsha, Edomshuchtam kurak, ndusha waritaksin táchinlliniya. Minsha, Mowabshuchtam kurak puniksin, nungtachinlliniya. Minsha, nduntam Kanaanshuch wizpur waritachinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ashiri Apaa, shiy tputsee tpuntangcha; waani punichinllinpa. Shiy shaana tpuxtakchush, waani patumbich tamatarpari ashirusin, nda shpoozaksin taachinllinpa. Ashkatssin, waani mapiyrsin, shiy tputsirish tushiychinllinpa. Watam shaana tputsireetsish tapachindarangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ashiri Taarashipanee, shaana iyaa machip machingcha yuwaa shaana, Siyaam tsapunis panachintspa, tárangish ambi. Ashiri Taarashipanee, anush iy shiyapa kis taachiniya, yuwash shiy pangish taaru anshuya. Anush shiy iyaa urutamari ksutachsha. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","¡Ashiri Taarashipanee, anush urutamari shiyamari kasiru taachsha! Móysis yaseeku ántarangiya. Ashiriya, na kamaneena yuwaa Móysisi Israelchichpa Taarashipanee ungirtaksin yaseerangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ashiriya, Ijiptoshuch pshiyrshini, minsha kapaachirini, misha paraw wasundurur ashparitssin marish kung pshturangu, Taarashipansha, Waani kung Ijiptoshchee tputs puchpa, tárangu, kungsha Ijiptoshchee kurak, wasundurur pshiyrshinpatari, minsha kapaachirinpatartam ichinguru purangiya. Itaru, Israelchichsha tsap puzumun mapiyrsin maree kung kitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ashiri Mariysha Apanllee kuk kamanimapan, yasimaam chtarangiya. Mariya Aaroncha wizari. Ashiri Mariysha kizaptatssin yambiyaru, charcharaa yáyarusin, michitkusin, yaseeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ashiri Mariysha yaseeksin táranganaya, Taarashipanee yaseeyani, watam waamari Ijiptoshchee kapunguri kasiranguwa. Marish kung Ijiptoshchee wasundurur kapaachurinpatari ichinguru marish kung yangaranganaya; Mariy, kizaptatssin yaseeksin ántangat ashiranganaya. Ashiriya na kamaneena yuwaa Mariya yaseerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ashiriya, Móysisi tputsee; Pzaya, naayani, átu, tputsee machtarangiya. Kung chumbeepimashi kasayarusin, arangeem naatarangiya. Ashiri Israelchichsha naayarandsin, tuchip zari apusap naataranganaya. Naatarangsin, nda kungoo paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Itaru, kungoo pamana paranganaya. Itaru, kungoo waamaam pinasaranganaya, watam kung kapzimunuwa. Ashirucha, anoo yásimaranganaya, Kung kapzi, atusina. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ashiri Israelchichsha tputs Móysisee nambaranganaya; ¿Ashiri na maya waaychich? Watam kung kapziwa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ashiriya, Móysissha Taarashipanee mashirangiya; ¿Tamaycheezi nuwa? Apaa, tárangiya. Ashiri Taarashipansha, Yasinaa kungumun wing Móysisee, yámandangcha, tárangiya. Ashiri Móysissha yasinaa ichipeeru, kungush kapeetarangiya. Ashkachu, kungsha misingapsheem kinarangiya. Ashiri anush Taarashipani Israelchichee, yachaku ashirangiya. Kamaparee nuwaa chinakeesinaya, nuwamun mang' tatchinllinaya, tárangiya. Sheeru, Israelchichee tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Nuw waatatana Taarashipani, siy Apanllirtischa nuwaatsi, tárangiya. Siy izuuritanaari nuwamun mangis tatkus, mishat nuwaa kuki puyuyarus wanasiri taakus, mishat nuwaa kamachtamarinee tuminkus, ashiri nuw nda shiyaa wanichima; Ijiptoshchee waneerangi nda amb ashtachima siyaatsiya. Nuw waatatana Taarashipani yuw siyaa matambish taamaam ksutki ani, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ashiri anamunsha Israelchich naataranganaya tsap sur Elimpi. Anush Elimush tsap kusarangsin, yuwash kung zapan tsapush shitungtungtar ashku anush kusaranganaya. Yuwash kung minam chung anumun tsimbun kung taaru anshu. Anumunsha kuyan 70 wanuspat taarangiya. Anush kuseersin, anshurisha taspa tambtayarusin, taaranganaya yuwash kung shitungku anshu. Ashiri na kamaneena yuwaa Apanll kungoo kapzee wanasirim ínarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ashiri Elimush tsap kanuseerangsin, sheeru, yusur káyarandsin, Machip Sinayap naamani, táyarusin, naataranganaya. Apuspi sheersin, Sinayash tsap kusaranganaya. Yuwamun Ijiptosh tsap shitungarangana anumun minam tsup anumunsha chawpi tsup Sinayash tsap kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ashiri anush tsap kuseersin, Israelchich ichingurusin mariz kayatatarsin, Móysisee, Aaronaatstam tsiyantayarusin nambaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","¿Mayaamsha nda Taarashipan iyaa ambari Ijiptosh tsap nda tpachingaranga? táranganaya. Iy sirútama Ijiptosh tsap taaranguni, kapung katungkuni, kungumun wing kuxinartayaruni, washunand shaniyaruni, kapung katungaranganiya. Wanutsee ngusambash tatsiteeruni, k'payaruni, katungeeruni, izuuru kapunguri tazaztariniya. Sheeruni, Ijiptosh tsap mapiyshtini taatariniya. Itaru, siysa iyaa ningeem machirangus, iysha mariz kiyung kachiykiniya. Siy ngutpasa iyaa ningeem marizimun kanatspamaam yushindarangsha, Móysisee táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","5","Ashiri Taarashipansha tputsee kuk mazinayaru, Móysisee tárangiya; Ashiriya, nuw katungtsee íwarpichee zanganchima. Zar puturta, sin tamaparee ashiru katungats sinakpaz ashiru parat ashchiya. Ichinguru zar puturi, putam putam ashiru katungats zanganchima. Itaru, tputssha minamtamari zar tatsamooru katungamaama tapuyachinllinpa. Arangeem yanuru tapuyarusinapa. Itaru, tputsee kamaningtsa; Zar tsimbun mataykachu anush, viernesash zari, yanusha zapan tapuyangtsa sabadshutam katungamaama, tángcha. Itaru, nuwaana napchima; nuwaa kuki tputs zurampataya payuksin, kamapari anuri tuminchinlliniya, tárangiya. Ashiri na yachachima anumun nuw yasachima, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ashiriya, Móysissha, minsha Aarona tputsee kamaniranganaya; Na in zar siy yasatssa; ¿tamayaru siyaa Taarashipan Ijiptosh tsap tashitungaranga? ¿Antaati iyaja siyaa tashitungarangini? Nduni. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ashiriya, pu zar puturita Taarashipanee wizpuri siy aranginasha yasatssa. Itaru, Taarashipan waana siyaa kukis mazinarangiya. ¿Siy antaati iyaatseeja mantsir tsiyatarangis? Nda; Taarashipanee siy mantsir tsiyatkateesa, watam waana Taarashipan siyaa ningeem yushindaranguwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mishat, Móysissha Israelchichee tárangitamta; Ashiri na zar pukamchu, Taarashipan zamzee katungamaam siyaam zanganchiya. Sheeru, putamsha zar yusur Taarashipan katungtsee zanganchiya zapaniya. Mishat, Taarashipan waana yuwaa siy uwaatsee tayutaritarangis anoo mazinarangiya. Iyaatseeja siy yutarit tsiyatarangis, nda; Taarashipanee yutarit tsiyatarangsa, Móysis tputsee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ashiri Móysissha Aaronaa tárangiya: Shiysha tputsee nishuri Taarashipanee kuk mazinamaama washunand tushaneengcha, watam Taarashipan siyaa kukis yuwaa mantsir tsiyatarangis anoo mazinaranguwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ashiriya, Aaronsha Israelchichee washunand tushaneeru, tsiyatstar ashirangu, íwarsha machip naparangsin, Taarashipanee wizpur psasshu paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Taarashipansha Móysisee tsiyatku tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Nuw mazinaktana yuwaa Israelchich nuwaa mantsir tsiyatkana anootsi. Itaru, na shiysha tputsee kamaningcha; Apanll siyaa ateeja; Na in zari, pukamchu siy ichingurus wanutsee katungatssa. Sheeru, putamsha puturi zar yusur siyaam pangaatssha zanganchima katungamaama. Ashiri izuuru kapunguri katungeerus, siyamari kamantsatssa. Ashiri anumand siy nuwaa Taarashipaneetsi yasatssa; Nuw waatana siy Apanlliris, tputsee tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ashiri anuritam zar puputanu zamizsha zapan katamish tamapari ashishiru ichingurush pangus tipuranllizush pantsatarangu tatsitarangiya. Shuneeru tipuranlliz katamshinandarita tatsitaranganaya. Ashiriya, putamsha zar puturi napkusin, mamburutar tsapumun ashirangu, izuuru tsapoo tipuranllizee yambutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mamboo ashirangu, tputssha napkusin, kurandar wach tamapari ashtamaru mbursheewa tsapumun pataru paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ashiriya, Israelchichsha nda ashima patarusin, Móysiseetsi mashkusin; ¿Mayaja in ashtar? táranganaya. Ashiri Móysissha; In watacha siyaam katungamaamaya. Taarashipan panaku ashkasha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mishat, Taarashipan siyaa ateeja; Ichingurus tputsis minamtawis katungsheemis tapuyangtsa. Tsimbun litro tputsimand tatsamooru tapuyangtsa. Wanipamtis minamtash pangus taaksa anpatari tputs tatsamooru shingtsa. Pangisis washunand taakis ashpari tatsamooru yarchinllinpa. Arangeem yanuru yarusinapa, minsha ningat yarusinapa, átcha Taarashipani, Móysisi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ashiri Israelchichsha anuritam Taarashipanee kuk payuyarusin, minamtaw tputs pangus tapuyaranganaya. Ashpatam zapan tapuyaku, ashpatam tputs ningat tapuyaku ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ashiru tapuyaksin, yuw tputs yanuru tapuyarangana an nduntam katuchiranganaya. Mishat, yuw tputs pakich tapuyarangana anoom nduntam pishtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ashiriya, Móysissha tárangiya; Pakchiyam pangishis putam zar katungamaam ktuchintspa. Natamari zar kchingangtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Itaru, Móysisi tárangitaa ashpatam tputs pangaa katucheersin pishuranganaya. Putam zar katungpani atusina, nda izuuru kachingaranganaya. Itaru, putamsha zar yuwaa katuchirangana anoo napkusin, katungpani atusin, itaru pangasha kindunandarisha tatsitaru, saj shitangat ashirangiya, yuwash wayarangana anshu. Ashiri pangsha k'pun pchazarangiya. Móysissha anoo pakeeru, kapung tsiyantarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ashiri minamtaw tputs waamatawaritam puturi zar, Natamamari katungpani atusin, tapuyataranaya, watam zar ksaneeratina, zarimun katungats kungusamaam taaruwa. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Itaru, tsimbunush zar matayaru (viernesash) pangaa tsimbunaam zari katungamaam tapuyataranaya. Minamtaw tputs ipunpunaraw litor yaranganaya. Ashiriya kurakawshitisin Móysisee kamaniranganaya; Tputs zapani pangaa yanuru tapuyakanawa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ashiriya Móysissha, An watacha Taarashipan waana kamachtarangu anu. Zar sabadush, minam zar kanusimaam taariya Taarashipanee chinamaama. Ashiri naturi viernesash zar katungsheemis k'payarus museerus kamiran wayangtsa putam zar katungamaama. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ashiri Móysisee kuk payuyarusin, anuritam sheersin, yuw katuchku anoo k'payarusin, museersin, wayaranganaya sabadush zari katungamaama atusina. Ashiri amb ashkusin, nda kindutarangiya; minsha nda k'puneerangiya; kis katungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ashiri Móysisi tárangiya; Ashiri na zar sabadush ichingurus, Taarashipanee chinakus, kanuskus, ktungangtsa, watam na zar sabadush katungtsee tipuranllizash nda pangatssawa ");
INSERT INTO cbuNT_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ashiri siy tapuyakus taatssa minam matayaru zariya. Watam tsimbunush matayaru zari, sabadush zari anush katungats nda pantsachuwa; izuuru ndunichiya, Móysisi Israelchichee, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Itaru, ashpatam tputs tsimbunush matayaru zar anush, wishchip shitungaranganaya, pangaa tapuyapani atusina. Itaru, ndusha pangaa paranganaya; izuuru ndunarimuna. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ashiri Taarashipansha Móysisee; Tputsee nuwaa kuki kamaningcha, tárangiya; ¿Ashinooja siy nuwaa kuki wanasiri payuchis? átcha Taarashipani, tángcha. Mishat, ¿yuwaa nuw tayaspatarangi anootstam ashinooja payuchis? átcha, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nuw Apanlli Taarashipantana. Ashiri anoo siy mbizarintspa. Watam nuw siyaam minam zar kanusimaama wayaranginawa, tángcha. Ashirucha, nuw minam matayaru zari katungtsee siyaam zanganchima, atashina. Minam matayaru zar katungtseem yáyarus, itaru tsimbun matayaru zar anush kanusangtsa, nuw siyaa átana. ¿Tamasha nda kitsis mazinaksa? Sabadush zari pangishis kanusangtsa. Katungtsee yamaam shtungintspa; átana siyaatsi, tángcha. ¿Tamasha anoo nda mazinaksa? tángcha, Taarashipan Israelchichee nambku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ashiriya Israelchichsha anuritam Taarashipanee kuk payuyarusin, tsimbun matayaru zar, sabadush zari, kanusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ashiri anoo katungtsee Israelchich yásamaranganaya, maná. Kizpur mburshi maachi kurandaroo wach tamapari ashiru. Mishat, kizpur kama; pangaa kindurpapaz taparama ashiru kisa. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ashiri Móysisi tputsee tárangiya; Taarashipan waana nuwaa kamachtarangiya; Chirimbuchush manaa tsimbun litro pshtangcha. Sheerush, wanasiri wayangcha, tárangiya. Ayam siyachich nlluranur manaa pangchinllinaya. Pakchusin, in waatapari sirútama iyashchee zitaminarini Ijiptosh tsap Taarashipan tashitungayaru, macheeru, apusap watungasheem katungamaam panataru anuya; siyachich nlluranur táchinllinaya; anoo Taarashipan nuwaa tárangiya; Móysisi Israelchichee kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ashiri Móysissha Aaronaa tárangiya; Shiysha Aaronaa, manaa tsimbun litro chirimbuchush pshtangcha. Ashiri yuwash Taarashipanee ungirtakani anush wayangcha. Waani anshuri taachpa ayam nlluranureemis yámandamaama, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ashiri Aaronsha anuritam Taarashipanee kuk payuyaru, manaa chirimbuchush pshtayaru, Apanllush pang' wayarangiya. Sheeru, Apanlleem kajonarini orpat tinayarusin, anushsha manaa pshtayaru wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ashiri ichingurusin Israelchich manaa ipunpunar chung masachi katungkusin taaranganaya. Ashiri anuri katungamchusin, Kanaannung tsap kuseersin, izuurishat manaa pastarangiya. Ayamtaa Taarashipan manaa nda zanganirangiya. Sheersin, kuseersin, anshurisha Kanaanshurishat izuurisha taararanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Hebrewshuch tputs, tsimbunu litor, minam gomer átssincha. Minamtachsha chung gomer minam efa atanaya. Ashiriya na kamaneena yuwaa Taarashipan waana Israelchicheem manaa watungasheem zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ashiriya, Israelchich Sinayash tsap shitungeerandsin naataranganaya. Apinlliritaa naamach ashiranganaya yuwari Taarashipan waana kamachtarangu anurita. Ashiri naarsin, Refidinush tsap kuseersin, anshurisha washunand shaniyaranganaya. Itaru, kungsha Refidinush tsap ndunarimuna. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ashiriya Israelchichsha Móysisee nambarangsin; Natu iyaam kung waamaam panangcha. Papcha; Iy sachisimun tsipambachinipa, táranganaya. Itaru Móysissha; ¿Mayaamsa nuwaa tamundaksa; Iyaam kung pananda, átssa? ¿Mayaamsa Taarashipanee tatsiynushtaksa? ");
INSERT INTO cbuNT_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Itaru, Israelchichsha sachisimun tsipambatssin, Móysisee wand nambaranganaya; ¿Mayaamsha shiy iyaa Ijiptosh tsap tashitungarangsha? Shiy ngutpasha sachisimun kanatspapi átush, iyaa ningeem machirangsha. Minsha ipareetstamani waani sachisimun tsipambanllina átushsha. Minsha chineetstamani waani sachisimun pchinganllina, atupsha shiy iyaa ningeem machirangsha, tputs Móysiseetsi táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ashiri Móysissha Taarashipanee; Apaa, Istangasinda, tárangiya. ¿Nuw tamaycheezee nee tputsi? Watam nuwaa patumbichpat pakchimari pachamaam pishtakanaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ashiri Taarashipansha Móysisee: Ashiri shiysha wasina yamazayarush, Israelchichpa tputs kurak ipuneerush, tsap Orebap naangcha. Mishat, tushuwshish yuwapa kung Nilo kuraseem ínarangish anoo yáyarush, izuuru naangcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nuwsha anush tsap Orebash shiyaam kutachinllpa. Shiysha anush kuseerush, tushuwshiptish patumbchee kapungu tiyá shingcha. Tiyá ashkachush, kungsha patumbchish shitungchiya. Ashiri tputssha ichingurusin anoo kung wachinlliniya, Taarashipan Móysisee tárangiya. Ashiri Móysissha anuritam Taarashipanee kuk payuyaru, Israelchichpa kurak ipuneerangsin, Orebap naataranganaya. Anush patumbchish kapungush kuseersin, Israelchich kurak napurusin, Móysissha tushuwshishpat patumbchee tiyá ashirangiya. Tiyá ashkachu, kungsha patumbchish zaw ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ashiri Móysissha anoo tsap yásamarangu, Meriba tárangiya. Meriba, atusin, tputs nambarangana átu, tárangiya. Minootssha sur yásamarangiya; Masa yásamarangiya. Masa atusin, Taarashipanee tatsiyunuchtarangu, atusin, tárangiya. Watam Taarashipanee mapiyranganawa. Ashirucha, ashiru tsiyataranganaya; Taarashipan iyash ndunarparee. Iyash taarinaariya ashiru, iyaa istachinaaparee, táranganaya. Ashiriya, na kamaneena yuwaa Taarashipan patumbchish kungoo tashitungarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ashiri anush, Refidinush Israelchich kanusarangana. Anush taarangsin, Amaritshuch tputs Israelchichpa waratamaama shitungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ashiri Móysisi Josueyaa wipunashi tárangiya; Shiysha wasina tputsee waratamaam wachinawa ipusangcha. Sheeru, pu zar Amaritshuchpa waratashinints. Nuwsha pu zar puturita, íwari machip kárchima. Sheeru, nuwsha anush, yuwaa Apanll nuwaam tushuwshishee panarangu anpat nuwsha siyaa istachintspa, tárangiya Móysisi. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ashiri Josueysha Móysisee kuk payuyaru, kamuzaa waratamaam ipuseeranllu, putam zar Amaritshuchpa waratamaama shitungaranganaya. Itaru, Móysissha Aaronpa, mishat minshat Israelchichpat wachin, Hurpat ashirusin ipuneerandsin, machip íwar káriranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ashiri Móysisirinsha tushuwshineetsi payuru, anu íwar uwee itsireeru paxayarangiya. Uw íwar paxaru, ashiri Israelchich tapazpa Amaritshuchee waamari kasisitaran ashirangiya. Itaru, Móysissha kapung nizirangu, uwsha íwar paxayamaam pinasarangu, Amaritshuchsha uwsha tapazpata Israelchichee kasimaam zandataraa ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ashiri Móysisi íwar uw paxayaru, kizpur nizirangu, Aaronsha mishat Hursha patumbich yáyarusin, wayayarusin, anumun Móysisee tunuxinarangana. Sheersin, pachtama minnunguchich Aaron putayaru, pachtama itsirarangiya. Mishat, Hursha arangach pachtam minamtam putayaru, itsirarangitamta. Amb sheersin, pachakaktarusina, zareem tapitaramach ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ashiri Josuey amb sheersin, k'chirpungpat waratkusin, Amaritshuchee uwamarisha kasiranganaya. Apanll kapung istarangiya Josueyaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ashiriya, anumunsha Taarashipani Móysisee tárangiya; Yuwaa Amaritshuch tputs siyaa waratarangana tapazpata anoo nda mbizamaam shiy kirakamun yandangcha. Sheerush, Josuey izuuru wits mazinachpa, nuwaa kuki kamaningcha; Taarashipan ateeja, Nuw Amaritshuchee tputs ichinguru izuuru tpachingachima. Nda minamtiyam nish tsapurunasush táchinllinaya, átcha Taarashipani, tángcha Josueyaatsi, Taarashipan Móysisee tárangiya. Ashiri Móysissha kirakamun ichinguru yandarangiya yuwaa Taarashipan tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ashiri Móysis patumbchee xanatarangiya. Sheeru, patumbchee xanateeru anoo yásamarangiya, Iy Taarashipanimun wizpuri kasiranginiya, yásamaku tárangiya. Apanll waanaatsi wizpurpa nuwaa imachirangiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Taarashipan urutari Amaritshucheetsi tputs nlluranureetstaa ayamta urutamari tapazpat waratkusin kasikastanlliniya, Móysisi tárangiya. Ashiriya, na kamaneena yuwaa Israelchich Amaritshuchpa waratarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Ashiri Israelchich tputs Refidinush tsap shitungeerandsin naataranganaya. Itsinsaru naayarusin, machush tsap Sinayush kusaranganaya. Sheersin, anshurisha machshu tandsamunu tambtayarusin taaranganaya. Ashiri yuwamun Ijiptosh tsap shitungarangana anumun tuchip tsup tushiyaru, Sinayush kuseeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ashiri Móysissha Apanllpa tsiyatpi átu, machip Sinaypi íwar kárirangiya. Ashiri kizpur íwar kárirangu, anush Taarashipan Móysisee kuruzeeru tárangiya; Móysisee, shiysha nuwaa kuki Israelchichee kamaningcha. Nuwaa Israelchich ichingurusin yasachinllinpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Taarashipan siyaa ateeja: Siy nuwaa yasarangtischa. ¿Tamaru nuw Ijiptoshchee waneerangina? Mishat, yasaktamsa, ¿tamaru nuw siyaa wanasir ksutaranguri ningeem nuwaanshu yushindarangina? Wanasir ksuteeruri, misha yungan tamapari wipaa wanasir ksutku wazitpungchipa wipaa kayantaru, sheeruri, nuw siyaa wanasir kayaneeruri, wanasir siyaa naparangina. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ashiriya, siy nuwaa kamachtamari payukinaareesa, misha nuwaa kuki izuuru tuminkus, nuwsha siyaa; Ini watacha nuw tputsiri, táchina siyaatsi; Tsapurunasshuch tputs ichingurusin nuwachichcha. Itaru ashiritaa, nuwsha siyaatsimari izuuru tputsireemariti wanasirim ínchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ashiri siyachchee Israelchichis ichingurootsis apanllpaneemari ínchintspa. Mishat, nuwsha siyaatsimari nuwaanaatsi tputsiri wanasiri taamaam ínachintspa, átcha Taarashipani siyaatsi tángcha; Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ashiri Móysissha tputsi wachinawa, kurakawaa kuruzeeru tushaneerangiya. Shaneerangusin, Móysissha ichinguru kamanirangiya yuwaa Taarashipan Israelchichee kamachtaku, Kamaningcha, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ashiri kuraksha mazinarangusin, Móysisee tárangana; Ashiri ichingurupari Taarashipanee kamachtamarini payuchiniya. Mishat, izuuru Taarashipanee kuk tuminchiniya, Israelchich kurak táranganaya. Ashiri Móysissha tputsee kuk Taarashipanee kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ashiri Taarashipansha Móysisee tárangiya; Nuw shiyapa msas tuwapish tsiyatchima. Ashiri Israelchichsha nuwaa kuki mazinachinlliniya. Ashiri nuw shiyapa tsiyatki anu tputssha mazinakchusin, tputs izuurisha shiyaa kukish uru payuchinllinaya, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mishat, Taarashipan tárangitamta; ");
INSERT INTO cbuNT_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ashiri tputsee shiysha kamaningcha: Na zari mangis yareerus, pusha zari Apanllpa ipunimaam mangis yarangtamsa. Mishat, kamaris wanasir káchangtsa. Anputam zari nuwapa ipunamaama wanasir yarangtsa. Watam nuw, Taarashipani anpu zari karuweeruri, tputsee nuwaanaatsi tuyamandachinawa. Ichingurusin tputs íwari Sinayush maachi nuwaa pangchinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","Ashiri Sinayanung maach patumbich yáyarush, wayat wayat wayat sheerush, maachi iturpeerush ksangcha. Sheerush, tputsee kamaningcha: Anoo patumbich kánuru naarusinapa. Izuuru machip kárinllpa. Tputs amb naayaru, maachee patatkachu, siysa anoo tputsee pchangtsa. Tputsee ptatintspa. Patumbichpatari pchangtsa, nduntaati ashiru toroopat pchangtsa. Maachi chinuz wakar, nduntaati ashiru opeeja anoo maach kandankachu anoo pchangtamtsa. Itaru, yuwash wakar pu pu pu tákchu, anoo tputs mazinakchusin, anush watsirit machinung kayum shaniychinllinpa, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ashiri Móysissha karuweerangu, Israelchichee tputs kamaneeru, tputspashat yararangiya. Sheersin, Israelchichsha ichingurusina wamaree kácharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ashiri Móysissha tárangiya: Siy izuuru wanasir kamiran yuwapangtsa. Mishat, izanllpatis ipunintspa. Natamasam mapiyngtsa. Paptsa; anpu zari Taarashipan siyapat ichingurus tsiyatchiya, Móysisi tputsee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ashiri sitataranllu tuchparini zar, íwar machip, kanindap tputssha kariyaatsi mazinaranganaya; misha, mamaroo parangitamanaya. Mishat, maachish psassha kizpur tuwap tapeerangiya. Anushshat, wakar wits kizpur zunganeerangu, anoo mazinarangusin, Israelchichsha tputs kapung puniksin, nungtatangat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ashiriya, Móysissha Israelchichee watamburish tashitungayaranllu; Natu, pzaya ichingurus, táyaranllu, tputsee machip Sinayap machtarangiya Apanllpa chamayangamaama. Yuwash Móysis patumbchee kámanarangu annungiri shaniyaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ashiri Taarashipansha maachish karuwarangiya. Psas kizpur tuwapi maachee kámanarangiya, watam Taarashipan sumasush karuwaranguwa. Psas kizpur tuwapi, kanindap káritara ashirangiya. Anumunsha, maachsha ashchiri kizpur mundaztarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ashiriya, wakarsha wits aranginash kizpur kimarangiya. Móysissha Apanllpat tsiyatstaru, Apanllsha uwsha tsiyatku, kariy tamapari ashiru kuk kimarangiya. Kizpur íwari machpi zunganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ashiriya, Taarashipan machush karuwarangu, sheeru, Móysiseetssha kuruzirangiya; Machip káringi, tárangiya. Ashiri Móysissha machip kárirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Machip káreeru, Taarashipansha tárangiya; Shiysha karuweerush, tputsee mangu p'tseengcha; Taarashipanee napamaam machip kárintspa, tángcha. Amb ashkatssin, uru ashpari tsipachinlliniya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Apanllpantaa tputs, ndatuma nuwaa tsiyatarusin, ichtaru mangoo yarchinllinpa. Ndunnaa ashkusin urutam tsipachinlliniya. Ashiri shiysha karuweerush, tputsee kamanishini; Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ashiriya, Móysissha tárangiya; Itaru, tputs antaati machip kárchazinllinaja, ndambari. Watam shaana kamachtarangush, patumbich yáyarush, wayat wayat shingtsa tárangush, ashiri iysha amb ashiranganiya. Itaru, tputs amb naachazinllinaja, ndambaree, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Itaru, Taarashipansha; Ashtaa, shiysha nuwaa kuki tputsee kamanishini. Sheerush, Aaronpa ipuneerush nish kanapungcha. Siyamari tsimbunandis. Itaru, nllitarit tputs kususinapa. Apanllpaneetstaa tputs waneekush, Taarashipanip kárintspa, tángcha. Tputs kárkachinaariya ashiru, uru tsipachinlliniya, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ashiri Móysissha machip karuweeru, Taarashipanee kuk ichinguru Israelchichee kamanirangiya. Ashiriya, na kamaneena yuwaa Taarashipan Israelchichpat tsiyatamaam Sinayush maach karuwarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ashiri Apanll tárangiya Israelchicheetsi tputsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Nuw waatatana Taarashipani; siyaam Israelchichis Apanlliris. Siysa Ijiptosh tsap kiyung kachiykus taakus, nuwsha siyaa nayaniranguri tashitungarangi; nuw antana. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ashiriya, siysa ngutis maacheetsi apanllireemis ínayarus; Anoo, In watacha Apanlli, tárintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Mishat, ngutis maacheetsi tinayarus, anoo ungirtarintspa. Maachee kanindush taaku anoom ngutis ungirtarintspa. Maachee tsapush taaku anootstam ngutis ungirtarintspa. Mishat, maachee kungoo imurish taaku anoo ngutis ungirtarintspa. Anoo maachee ngutis tinarinllpa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mishat, anoo ngutis tutunlltayarus ungirtarintspa. Pakchiyam chinarintspa. Nuwaatsimari ungirtangtsa. Watam nuw Taarashipani Apanlli watsiynurinawa. Tputs nuwaa ngatkana anoo nuwsha waneekina. Wipaatstam wanichina; misha wachinllinootstam wanichima. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Itaru, yuw tputs nuwaa chinakana anootssha nuwsha kizpur chinachina; misha istachina. Siyachchee nlluranuri urutamari istachima. Itaru, yuw tputs nuwaa chinakana anootsimtiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mishat, nuwaa Taarashipaneetsi, siy Apanllireetsis, ngutis ngicheerus, tamasingarus tsiyatintspa. Amb ashkachus, nuwsha siyaa wanichintspa yuwamand siy nuwaa ngicheerus tsiyatkis anumanda. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ashiri misha, sabadu zari nuwaa Taarashipaneetsi, siy Apanllireetsis, chinamaam mbizarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ashiri minamtash siman tarawaztakus, minam matayaru zari tarawaztangsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Itaru, zar tsimbun mataykachu anush kanusangtsa. Kanuskus, nuwaa ungirtangtsa; misha anush zar pakchiyam tarawaztarintspa. Mishat, ipartamtish kamuz, misha iparish kiz tarawaztarusinapa. Mishat, m'chachiritamtish kamuz, misha m'chachirish kiz tarawaztarusinapa. Mishat, chinllinitamtis, misha yuw tputs nllitari shiyapa taakana antamsin tarawaztarusinapa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Watam nuw, Taarashipani maacheetsi tinaranguri, minam matayaru zar yuwaparanginawa, kanindaatsi, misha tsapootsi, misha maree kung kapungootsi yuw na ichinguru taakana anootsi. Ashiri nuw kanusirangina tsimbunush matayaru zari, Ashirucha, anoo zar nuw kanusisheem wayarangina. Ashiriya, anush zari siysa nuwaa ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ashiri misha siyaa tina; Apareetsis wanasir ksutangtsa. Kuk payungtsa. Aneereetstamtish wanasir ksutangtsa; kukoo payungtamtsa. Ashkinaareesa ashiru, wambari siyamari wachinaru taatssa yuwash nuw, Taarashipani, siyaam tsapuneemis panakchi anshuya. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ashiri ngutis tputsee pcharintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Izanlleetsimaritish ksutangtsa. Minpa kiz imbangartarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Maacheetsi shuchirintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Tputsee mantsir tsiyatintspa. Tputsee ngichintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tputsingaz pangu tamararintspa. Siyamari kasiyarus, tputsee maachiri payuru anoo yamaam chinarintspa. Tputsingaz wizanll tamararintspa. Tputsingaz muchchur tamararintspa. Tputsingaz muchchur wizanur tamararintspa. Tputsingaz chin tamararintspa. Yuw tputs maachiri payukana anungaz tamararintspa. Izuuru mapiyngtsa, Taarashipan Israelchichee kamachtaku tárangiya. Ashiriya, na kamaneena yuwaa Apanll minam chung kamachtamarinee Israelchichee kamachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ashiriya, Israelchichsha kariyaa, misha wakaraa wits mazinayarusin, misha mamarootstam, misha psaseetstam parangusin yuwaa machee yambutarangu anoo parangusin, kizpurinasha puniranganaya. Arapeetarisha shaneersin, napatarach ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ashiri Móysisee tsiyatkatssin; Na wapaya Apanll tsiyatamaamaya. Waritayanllcha. Ashiri shiyaa kukish payuchshapariniya. Mishat, Apanlleetstam kuk tuminchitampariniya. Itaru, nimun Apanll yusur tsiyatkachinaari ashiru tsipachshapariniya, tputs Apanllee puniksin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ashiri Móysissha; Punirintspa. Apanll siyaa yachaku ashkiya. Nuwaa kuki mazinayarusin, puniksin, izuuru nuwaa kuki payupana, átu, siyaa kamanirangiya. Mishat, punirsin, nda yutaritshishee chinapana, átu ashkiya, Móysisi Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Itaru, Israelchichsha ashiritaa puniksin, arapinlltamari machee shaniyarsin, napatarach ashiranganaya. Itaru, Móysissha kayumarangiya yuwash psas tapeeru mzeetaru anshu, yuwash Apanll tsiyatstaru annungi. Ashiriya, na kamaneena yuwaa Israelchich Apanllee kapung punirangana anootsi. (Kapitoro 21-23) Ashiri Móysissha machish Taarashipanpat tsiyatku kapung zaptarangiya. Machish taarangu anush Taarashipansha yusur arangeem Israelchicheem kamachtarangiya: Tputs waanpatatin wanasiri taamaam kamachtarangiya. Mishat, tputs nda kizapa yutarit taamaam kamachtarangitamta. Pukiree tputs, mishat mashindootstam, mishat m'chachuwaatstam, misha muchchureetstam nda kiyung yachamaam kamachtarangiya. Yuwaam tputsirish shiyaam tarawaztakana anoom, wanasiri tatsamooru tuwapangtsa, Apanll tárangiya. Mishat, tputs waanpatatin istamaam kamachtarangitamta. Mishat, tputs yutarit taaku anoo wanimaamtam kamachtarangitamta. Sheeru, zapan kamachtayaru, anumunsha; Ashiriya shiysha na karuwangcha. Karuweerush tputsee, nuwaa kamachtamari kamaningcha, tárangiya. Kamaneerush ichingurus nuwaa ungirtangtsa. Sheerush shiysha yusur ningeem káringcha, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Taarashipan Móysisee tárangiya, Ashiri shiy karuweerush, tputspat tsiyateerush, yusur íwar machip káringcha; shiyapa yusur tsiyatpani. Itaru, yusur karuweerush, ipuneerush Aaronpa, misha Aaronpa wipa, Nadabpa, misha Abihunpa, ashirus káringtsa. Minsha Israelchichpa 70 wachinanand ashpis washunand nuwash kusangsa. Itaru, nuw shiyaa atina; Aarona wipapta, mishat Israelchichpa wachin arapinlltamari shaniychinllinpa. Sheersin, tutunlltayarusin, nuwaa ungirtachinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Itaru, shiyamari nuwanung kusangcha. Itaru, minshatssin tputs machip karusinapa, Taarashipan átcha tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ashiri Móysissha machip karuweeru, Israelchichee tputsi kamanirangiya. Ichinguru yuwaa Taarashipani kamachtarangu anoo kamanirangiya. Ashiri Israelchichshatssin ichingurusin; Ashiri iysha izuuru Taarashipanee kuk, mishat Taarashipanee kamachtamarini ichinguruparee payuchiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Móysissha Taarashipanee kamachtamarini ichinguru kirakamun yandarangiya. Ichinguru yandamaam iwaparamchu, putaamsha puturi chiyzayaru, Móysisi watandsimuna patumbchee xanatarangiya. Anumunsha sheeru, yuwannung xanateeru annungiri patumbchee kapunguwa ichizayaru, wayat wayat sheeru, izuuru iturpiru kasarangiya. Patumbchee minum chung anumun tsimbun wayarangiya. Minamtawaam tputs Israelchicheem Akoparineema wip, minam patumbich wayat wayat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Anumunsha kanungasiwa Móysisi kamachtarangu; Siysa toroo putayarus, patumbich xanatamamun pachayarus, muchingtsa, Taarashipanee ungirtamaama, kanungasiwa tárangiya. Ashiri kanungastisin, Taarashipanee ungirtapani atusin, toroo pachayarusin mbutaranganaya. Ashkachuni, Taarashipan iyaa yutaritshishirini mapiyp atusin, mishat Taarashipanpat kis ipunpani atusin, ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ashiriya, Móysissha toroo ursir mangawash yáyaru, ashtam chawip patumbchimun xanatamamun pzachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Sheeru, kirakaatssha yáyaru, ichinguru tputs mazinarsin, Taarashipanee kamachtamarini natstarangiya. Ashiri Israelchichsha anoo mazinayarusin; Zuraktishcha; ashiri waritachparee. Taarashipanee kamachtamarini payuchshapariniya ichinguruya; táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ashiriya Móysisi kurasee mangawash yáyaru, tputsimun kurasee ixuwat ixuwat ashirangiya. Watam siysa; Izuuru Taarashipanee kuk payuchinipa, tárangsawa. Ashiri nipat, toroopat ursiri Taarashipaneem tiptsir kinatssa, Móysisi Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ashiriya iwaparamchu, Móysisi Aaronpat machipsha yusur kárirangiya. Nadab, misha Abihun ashirusin, mishat Israelchichsha wachin 70 tputs Móysispat káriranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Anshurisha, Israelchich Apanllee watsish paranganaya. Apanll machimun watandas kizpur kurakurtaru, misha kanind tamapari kizpur kawambana ashiru anumun xiyarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Itaru, anshurisha ichingurusin Israelchich wachin Apanllee wats paranganaya. Apanllee parangitaatssin, itaru Apanllsha Israelchicheetsi nda pacharangiya. Anshurisha mapiyrsin katungaranganaya, misha mapiyrtamsin waaranganaya. Ashiriya, na kamaneena yuwaa Taarashipan Israelchichee waama tiptsireem ínarangiya anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ashiri Taarashipan Móysisee tárangiya; Na shiysha aranginasha nuwanung káreerush, anush nuwaam k'tangcha. Shiyaam patumbich táwar tamapari ashiru panachinllpa. Patumbchimun nuwaanaatsi kamachtamari yandayaruri panachinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ashiri Móysissha machip Sinay Josueypat ipuniranllu kárirangiya, ");
INSERT INTO cbuNT_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ndatuma machip káreeru, Israelchichee wachin tárangiya; Ashiri xamachi. Siy neetsiritama k'tangtsa. Ashiri yusur kanapkachuni, siyapa pangchinipa. Itaru, Aaron, misha Hur, ashirusin siyapa taachinlliniya. Tsiyatsis mantsirimash siyash taakchu, Aarona mishat Hur ashirusin siyaa istachinlliniya, Móysis Israelchichee wachina tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ántarangu, Móysisi machip Sinayap aranginash íwari kárirangiya. Móysissha kárirangu, msassha kizpur tuwapi machee yambutarangiya. Mishat, Taarashipan wizpur kizpur 'sineerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Minam matayaru zari msas mishat 'sin ashiru machee yambutaru, anush yusur Taarashipansha Móysisee kuruzurangiya. Wizpur sumas tamapari ashiru minam matayaru zari machee msas yambutarangiya. Ashiri anushsha Taarashipan Móysisee kuruzurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ashiru, Israelchichsha yuw tsapush watandsash shaneerana anshatssin Taarashipanee wizpur parangusin, sumas ashiru kizpur kurakurtar ashku, maachee muchikpaz ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Itaru, Móysissha msasush Taarashipanip pshturangiya. Sheeru, machpiri ipunpunar chunga zari psaanpatari zapshtarangiya. Ashiri na kamaneena yuwaa Móysisi machip Sinayap yusur kárirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ashiri Israelchich táranganaya ashparitin, ¿Tamarangshtaja Móysisee? ¿Tamashta nda kusak? ¿Yapishtaja Móysis naatarang? táranganaya. Ashiriya, washunandsha shaniyarsin, Aaronaatssha táranganaya, Ashiri shiy tinangi Apanlleema yaama Apanllirini iyaa ksutamaama, watam nda yasakaniwa; ¿Yapamasaja Móysis naatarang? yuw iyaa Ijiptosh tsap tashitungarangu anu. Watam izuuru tsipayaranlluwa, táranganaya. Itaru, ¿iyaa tamari Apanll machich? ¿watam Móysis iyash ndunariwa? Israelchich táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ashiriya, Aaronasha Israelchichee punirangu, tárangiya; ashiri siysa yuwaa izanllis witsush tawanurana an, misha iparis kamuz witsush tawanurana antam, misha iparis kizatam witsush oroo tawanurana anoo ichinguru yáyarus, ashparita nuwaam panangandama, Aarona tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ashiri uwshatssin ashpartisin ichingurus tputs yuw witsush uru tawanutaranllina anoo yáyarusin, Aaroneemani panaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ashiri Aaronsha ashpari yáyaru, oroo ngusambash kapungush pshtayaru, sumaspat kungsarangiya. Sheeru, anoo oroo yáyaru, Aaronsha wakar tamapari ashimatam tinarangiya. Ashiri Israelchichsha anoo wakaraa tinama parangusin, táranganaya, In watacha iy Apanllirini yuw iyaa Israelchicheetsini Ijiptosh watsapun tashitungarangu anu, Israelchich táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ashiri Aaronsha yuwaa tputs tsiyatkana anoo mazinarangiya. Ashiri uwsha patumbchee tinayaru, yuwamun wakar tinam taaru annungitam wayarangiya. Sheeru kapung tsiyatku tárangiya; Pu zar shaniychinipa. Sheeruni, ungirtani yaanaatsi Apanllirini Taarashipaneetsi tárangiya Aarona. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Putaamsha zar ichingurusin tputs shaniyarangaya. Sheersin, maacheetsi chinuzee muchiranganaya, Apanll iyaa mapiychpa atusina. Ashiri Israelchichsha tputs kuxineersin, katungaranganaya, misha waarangitamanaya. Sheersin, kizpur shambataranganaya. Mishat, kapungtam karusaranganaya. Sheersin, mang' kis yasiranganaya. Anumunsha michitaranganaya, misha staranganaya. Kizpur yutarit ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ashiri Apanllsha Móysisee tárangiya; Natu, shiy karuwangi machshu. Yuw shiy Ijiptosh watsapunoom tashitungarangish anin ichingurusin nuwaa kuki ndusha payumaam zandkanaya. Izuurishtisin mapiyanlliniya yuwaa nuw kamachtarangi anootsi, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Itaru, nuw siyaa kamachtakuri tárangtana; Ashiri ngutis maachi ur tinayarush, anoo in watacha Apanlli, táyarus, anoo ngutis ungirtarintspa, tárangina. Itaru, siysa anoo musásiri mbizayarus, maachitsha ur tinayarus, wakaraam anushsha, Watacha Apanlli táyarus, anootssha ngutis ungirtaksa. Anoomsha, yuwaa wakaraam tinarangis anoomsha maacheetsi wayaksa. In watacha Apanlli yuw iyaa Israelchicheetsini Ijiptosh tsap tashitungarangu anu ngutis átssa siya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Anumunsha, Apanll Móysisee tárangiya, Na nuw Israelchichee tputs yasayana yuwaa mikeersin nuwaa mbizakana anootsi. Sheersin, nuwaa kapung xarakana. Nda nuwamun mang' tatkana, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ashiri na nuw Israelchichee kapung tsiyantayana. Itaru, shiynaa nuwaa mapiyngcha. Yuw nuw chinaki anuri tuminchima. Izuuru kachingkachuri, Israelchichee kasachima. Sheeruri, yusursha siyachchee tuzapanichima. Nimun siyashuch nuw tputsiri kapung taachinlliniya, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ashiri Móysisirinsha Apanllee tárangiya. Apaa, amb shirinllpa shaanaatsi tputsirish, watam shaana tputsirishshawa. Mishat, shaantatam tputsireetsish Ijiptosh tsap tashitungarangshawa shaanpata wizpurish. Ashiriya, kapung tsiyantarinllpa. Pachakush, tputsirish chingarinllpa, Móysisi Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Itaru, shiy Israelchichee pachayarush, chingakchinaareesha ashiru, Ijiptoshuchsha kurak shiyaa ichingurusin táchpasinaya; Apanll ashtapi atupari, iyash tsapuni tashitungayuru, Israelchichee machirangiya. Mantsir chinayaruya, chingapi ichinguru atuya machpichiwaatstam Apanll waana tiptsiri pachayaru, kachingarangu, ashiri nish tsapurunas nda Israelchichee tputsi minuntiyam pakanaya, táchapsiniya Ijiptoshuch tputsiya, tárangiya Móysisi. Ashiriya, nayaningcha. Kapung tsiyantarinllpa. Tsiyanish zambazangcha. Mishat, shaanaatsi tputsirish tayutaritarinllpa, Móysisi Apanllee tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Mishat, chinangcha yuwaa shaana sirútama tsiyatarangish anootsi. Aprahamarineetsi, misha Isaakarineetstamta, shaana tárangsha, Israelchich tputs nlluranur zapish pzapanichinlliniya. Táchimaam izuuru pinasachinlliniya, aship tsangachiya kanindpichiya, shaana tárangsha. Mishat, shiy tárangitamsha; Siyaam tsapunis panachintspa Kanaanaatsi tsapu tárangsha. Anush tsap siyashuch nlluranur urutamari taachinlliniya, shiy Aprahamarineetsini tárangsha, tárangiya Móysisi Apanlleetsi. Ashiri izuurirush tsiyaneetsish zambazangcha. Pachamaam chinarinllpa, Móysisi Apanllee tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ashiri Apanllsha tárangiya; Ashiri watsitpari; pachacheezi Israelchichee ndambari, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ashiri Móysissha machip karuwamaam chtayaru karuwarangiya. Tsimbun patumbich táwar tamaparee ashiru payuru, karuwarangiya. Patumbchimun yandama Apanll waanaatsi wamachtash yandarangu anootsi. Ningach yandam taaru, arangeemsha yandam taaritam ashishiru, táwar tamapari ashiru anumunu. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Apanll waana amb ashirangiya, tstsarangiya. Mishat, Apanll waana wamachtashee patumbchimun yandarangiya táwar tamapari ashiru anumuna. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Josueysha Móysispa ipunaru karuwarangiya. Ashiri Josueysha mazinarangiya, yuwaa tputs zamamtarana anootsi. Ashiri tárangiya Móysiseetsi. Itaru, yuwaa tputs zamantarana anoo mazinayaru, tárangiya; ¿Tamashta tputspaz pangusshuchee pachakchusina ashirusin zamamtarana? Josuey Móysiseetsi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Itaru, Móysissha tárangiya, ¿Ndusha shambatkusin zamtarana undararee kasiyarusina? Mishat, ¿ndusha Israelchichee undarar pachaksin, uwaatsim kasiyarusin, tanuksin ántaranna? tárangiya. Itaru, nuw mazinaktana yuwaa yasiyastarana anootsi, tárangiya Móysisi Josueyaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Itaru, Móysissha pangusush kuseeru, napkamchu, wakaraa orpa tinama parangiya. Ashiri anoo tputs shambatkusin, wakaraa tinama michichitarana anoo parangiya. Ashiri Móysissha kapung tsiyantarangiya. Tsiyantayaru, yuwapa patumbich yandam payuru, Apanllee wamachtashi anpa tpoo ashirangiya wakaraa orpa tinamaatsi. Sheeru, wakaraa tinama pátangapeeru kasarangiya. Izuuru tsapush parat ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Sheeru, yusursha iriptarachu, uru tinamaa yaranllu, sumasushsha pshtayaru, izuuru tachuwimbiru, wayapuroomsha ínayaru, tachuyarisha kungush kurutambayaru, waani Israelchich anoo waapana átu, Móysisi shimbayaru kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Amb shimbayaru, kasayaru, Aaronsha tárangiya; ¿Tamarangtisinaya in tputsi? Ashiri ¿shiysha tamakshasha? Itaru, na kapung yutarit ashirangsha, tárangiya Móysisi. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ashiri Aaronsha tárangiya; Zuwaa, tsiyantarinllpa nuwaatsi. Shiy nee tputs yasaktishcha yuwaa yutaritshishee kis chinakana anootsi, tárangiya Aarona. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mishat, nuwaa táranganaya, Ashiri shiysha Apanllee tinangi iyaa machimaama. Watam na nda yasakaniwa. ¿Tamarangimsaja, Móysisi? yuw iyaa Ijiptosh tsap tashitungarangu anu, táranganaya nuwaatsi, Aaron Móysisee kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ashirucha, nuwsha tárangi, Ashiri pananda yuw saana ur payuris anu tárangina nuwaa. Ashiri uwshatssin ayu atusin, uru nuwaam panaranganaya. Ashirucha, nuwsha uru sumasush pshtayaruri, orsha kunguseeru, wakaraamsha kinarangu, tárangiya Aarona Móysisee kamanku. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Itaru, Móysissha natstarangiya yuwaa Israelchich tputs kizpur yutarit chinarangana anootsi, misha ndunimunu izuuru yasamaama. Ashiri mangush chinaku tárangiya; Itaru, iy kundararni nee pakchusin, iyaa mantsirpari tsiyatchinlliniya, tárangiya. Ashirucha, Aaronaa, pakchiyam nda yasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ashirucha, Aaron ksutamaam izuuru pinasarangu, Móysissha chiyzayaru wachunung pangus tasaseeru, xiyru tárangiya; Ashiri yuwis Apanllee wamachtash payumaam zandkis anis ningeem nuwanung nuwapta washunanda shaniyangtsa. Ashiri ichingurusin Leviychich shaniyaramchusin, ");
INSERT INTO cbuNT_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Móysissha tárangiya; Ateeja Apanll iy Apanllirini Israelchichini. Ashiri yakints k'chirpungaris. Sheerus, naangints. Ningeem pangus naaku, arangeem watandaram naaku, sheerus, pachangtsa tputsee yutaritawaatsi: zuwanlliwaatstamtish, misha amikureetstamtish, misha yuwapa taakis anootstamta, ichinguru pchangtsa, átcha Apanlli, Móysisi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ashiriya, Leviychichsha anuritam tuminuranganaya, yuwaa Móysisi kamachtarngu anootsi. Ashiri anshuri zar tsiparanganaya tputsi tuchip milo. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Anumunsha, Móysisi tárangiya Leviychicheetsi; Ashiri na siy Apanllee kamachtamarini tuminarangus, tputsee yutaritawa pacharangsa. Ashpatam ipareewaatstamtis, misha zuwanlleewaatstamtis pacharangis anumand Apanll siyaa ksutchiya. Mishat, kapung siyaam istachintsa, tárangiya Móysisi. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ashiri putaamsha zar Móysisi tputsi tárangiya. Siy na yutaritshishush kapung pantsarangsa. Ashiri na yusur machip yap Apanlli taaru amb kárchima Apanllpa siyaam mashimaama, siyaa yutaritshishiris Apanll mapiymaama. Kamapari nuwaa kuki Apanll mazinakchiya; siyaa yutaritshishiris tachingchiya, tárangiya Móysisi. Ashiri na kamaneena yuwaa Israelchich uru wakaraam tinayarusin, anoo ungirtarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ashiri yusursha Móysisi wapitam machip yap Apanllpa tsiyatku ambitam naatarangiya. Apanllee tárangiya mashku; Zurampatari Israelchich tputs yutaritshishush pantsaranganaya, yuwamand uru wakaraam tinayarusin, anootsimari chinayarusin, anoo kis ungirtakana, tárangiya Móysisi. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mishat, Apanllee mashku tárangiya; Nuw shiyaa mashkina: Shiysha ichinguru Israelchichee yutaritshishirini mapiyngcha. Nduniya mapiymaam zandkush, ashiri nuwaatstam suri izuureerush tchingangcha yuw nuwaa suri patumbchimun yandarangish anootsi, Móysisi Apanllee tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Itaru, Apanllsha tárangiya; Ashiri yuwaatsimari nuwaa suree tputs tayutaritarangana anootsimari nuwsha suru tachingchima nuwaanshu kirakari, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Apanllsha Móysisee tárangiya; Ashiri naangtsa. Machingcha tputseetsi yap nuw shiyaa tárangi ambi. Ashiri nuwsha sundari zanganchima siyaa machinaama. Itaru, nuwsha nda amb naachima siyapi. Yuwashumari nuw wanishi tatsamkachu anshumari nuwaana tputsee wanichima waanamandari yutaritshishirini, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ashiri Apanllsha tsutashshee zanganirangiya tputsi wanimaama yuwamand uru wakaraam tinayarusin, anootsimari ungirtarangana anumanda. Mishat, yuwamand Aarona tinarangu anumanda. Ashiri na kamaneena yuwaa Móysisi Israelchichee Apanllpa tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ashiri Taarashipansha Móysisee tárangiya; Ashiri na shiysha tputsiriptish Kanaanap tsap naangcha. Yuwapat shaana tputsireetsish Ijiptosh tsap tashitungarangish anpat naangcha. Watam nuw sirútama Aprahamarinee, mishat Isaakarinee mishat Akoparinee; Siyaam tsapuneemis panachintspa, táranginawa. Ashiri siysa amb naangtsa, Taarashipani tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ashiri nuw nuwaanaatsi sundaruri siyaa machinaam zanganchima. Mishat, nuwsha Kanaanshucheetsi tputs ichingurootssin tuzanganichima; misha Amorrewshuchee, misha Hititshuchee, misha Feresewshuchee, Hebewshuchee, Jebusewshuchee ashiru ichingurusin ashpari tashitungachima; watam nuw sirúta shiyachchee panachintspa, táranginawa, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ashiri siysa Kanaanap tsap izuuru naatssa, yap katungats ichinguru zapan taaru ambi, tárangiya. Itaru, nuw siyap Kanaanap tsap naacheezi, ndambari. Nuw siyap naakchinaareena ashiru, ipusirishapari ngootsush siyaa tpachingayaruri kasachina, watam siy nuwaa kuki nda pakchiyam payumaam zandaksawa, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ashiri Móysissha machip karuweeru Taarashipanee kuk tputsee kamanirangiya. Tputssha Taarashipanee kuk mazinayarusin, yuwaa Taarashipan; siyap naacheezi, ndambari, tárangu anu, mazinayarusin, punirustarangana. Kapung mang' mantsarangusin, tanuranganaya. Izuurusin wayarangashee wayaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Watam Taarashipan Móysisee tárangitamta; Tputsee nuwaa kuki kamaningcha; Siy Israelchichis kizpur yutarittischa, tángcha. Nuw siyash anshurtanaari taaruri, ¡maya! siyaa ichingurupari tpachingachina mikeeruya. Ashiri siysa kamareetsis wanasirimsheewa, mishat yarangasheetstamtis ashpari ichingurus wayangtsa. Ashiri nuwaana nuw siyaa yasachima, átcha Taarashipani siyaatsi tángcha, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ashirucha, anuritam zar, yuwapur Israelchich tsap Orebush taarangana anpur, Apanllee puniksin, tputs wayarangashee wayayarusin, ndusha yartaranaya. Ashiri na kamaneena yuwaa Taarashipan Móysisee; Tputsiriptish tsap Kanaanap naangcha, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ashiri Móysisi minam pangus, Apanlleem pangu pakich arapinlltam waanitam panguyaru kasarangiya. Anoo pangus Taarashipanpat tsiyatamaam átu, wayarangiya. Ashiri tputssha Apanllpa tsiyatpi átu, waanshu pang' shitungeeru, Apanllish pang' pshtuyarusin, Apanllpat Taarashipanpat tsiyataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ashiri Móysisi uru Apanllip pang' naamachu, ichingurusin tputssha pangumandarisha washitungash xiyeertayarusin, napatarach Móysisee ashtaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Móysissha Apanllush pang' pshtukchu, psassha kanindap káyashinu karuwataranllu, Apanllee pang' puputaran izuuru yambutatara ashtariya. Sheeru, Taarashipansha Móysispa tsiyatstar ashtariya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Sheeru, tputssha msasee Apanllee pang' yambutaru anoo pakeersin, uwshtisin uru pangumandari washitungashinungiri ichingurusin tutunlltayarusin, Taarashipanee ungirtataranaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ashiri Taarashipansha wandari tsiyatstar Móysispata ashirangiya. Tputs tamatarpari wamkurpa tsiyataru ashiritam Taarashipan Móysispat uru tsiyatstar ashtariya. Tsiyatamaam iwatspayaru, Móysissha waptamta pangup kanapurangiya. Itaru, wipunashsha kanungas Josuey, Nomarini wipa, Apanllee pang' ksutku, anshuri taarangiya. Ashiri na kamaneena yuwaa Móysis Apanlleem pang' taspat panguyaru, arapinlltam wayayaru, anush Taarashipanpat tsiyatarana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ashiri Móysis Apanllish pang' tsiyatku, Taarashipanee; Apaa, nuwaa nayaninda, tárangiya. Mazinangcha nuwaa kuki, watam shaana nuwaa; Tputsireetsish shaana machingcha Kanaanap tsapu, tárangshawa. Itaru Apaa, ¿chakaja nuwaam istamaam zanganchish? Anoo shiy nuwaa nda kamanirangshawa, tárangiya. Mishat, Apaa, shiy tárangitamsha nuwaatsi; Shiy wanasirtishcha; nuw shiyaa amikurtana, shaana nuwaa tárangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Itaru, Apaa, shiy zurampatari nuwaa chinakush, ashiri nuwaa nayaningcha; yuw shaana mangishish chinakish anoo nuwaa kamaningandama. Ashiri nuwsha yasayaruri, yuwari shiy chinakish anuritam tuminchima, tárangiya. Itaru, Apaa, mbizarinllpa, nee tputsi shaana tputsirishshawa, watam shaana tputsireemish ipusarangshawa. Ashiri tputsireetsish nayaningcha, Móysis Taarashipanee tsiyatku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ashiri Taarashipansha; Ashiri nuwsha shiyapa ipunchima shiy mangish mapiymaama. Shiyaa istachima, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Itaru, Móysissha; Itaru, Apaa, shiy tputsiriptish ipunamaam ngatkeesha, ashiri iyaa arangeem zanganinllpa, tárangiya Móysisi. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mishat, Apaa, shiy iyapa ichingurootsini ipunamaam ngatkush, antaati shiy iyaa tputsireezish, ndambaree. Nllitaritpazini tputsini ashiruparee taachiniya. Itaru, shiy iyaa ksutkachush, mishat iyapa ipunkachush, iysha shiyamunparee wizpurish taachiniya. Ndusha nllitaritpaz tputs ashiru taachiniya, Móysis tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ashiri Taarashipansha; Watam shiy nuwaa masharangshawa, ashiri yuwari shiy nuwaa mashirangish anuritam tuminchima. Siyapa ichinguruptis ipuneeruri naachima. Watam nuw shiyaa kapung chinakinawa, misha watam nuw shiyaa amikuritamanawa, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ashiri Móysissha; Apaa, nuw shiyaa izuuru pangasi átana; shiyaa wizpurish wanasirimshireetsish pangpi atina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Itaru, Taarashipansha; Nuw nuwaantari shiyaa arangeem yamazaru naachima. Anumunsha nuwaanaatsi, Taarashipaneetsi suri shiyaa arangeem yasamaam, izuuru mangoonamaam, kamanchinllpa. Nuw Taarashipani; nuw tputsee, yuwaa nuwaana chinaki anoo nayanichima. Mishat, yuwaa tputsee nuwaana chinaki anoo yutaritshishirinee mbizachima. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Itaru, shiyaa nuw itsinsaru kamanchinllpa; tputs minamtiyam nuwaa kachi patareeja. Nuwaa pamaam pinascha. Nuwaa pakchu, tputs izuuru tsipachiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Itaru, mazinangcha; machush íwari patumbich kapungumash taarcha. Anush nuwaa watsiritkachush anshuri k'tangcha. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Sheeru, nuwsha anush shiyanung tushiychima. Tushiykchuri, shiyaa patumbchish kachutamash pshtachinllpa. Sheeru, kuwippati kámanachintspa. Ashiri anumun, shiy nuwaa yasachsha yuwaa nuw tushiyranlli anootsi. Mishat, nuwaa kuki mazinachsha; itaru, nuwaa nda pangachsha. ");
INSERT INTO cbuNT_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Sheeruri, yuwaa patumbchimun kuwipti patateeruri, kasata ashkachuri, anumun shiysha nuwaa kusheetsimariti pangachsha. Itaru, kcheetsti pangcheezish, ndambaree, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ashiri Taarashipan waantari Móysispa tsiyatku; Shiy na shaanasha tsimbun táwar patumbich turungi. Turuyarush, shiy pátangarangish ashiritam tinangi. Sheerush, nuwsha nuwaanaatsi kamachtamari ichtaru táwaramun yandarangi antam yusur yandachima. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ashiri wasina ichinguru kamiran yuwapangcha. Sheerush, machip Sinayap pu zar puturta káringcha. Anpari machush íwar shiyapa chamayangachinipa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Itaru, shiy tputspa minamtiyam ipunurush kárinllpa. Mishat, tputs machish kustapa. Mishat, opeejatam, wakaratam anush machinungi kustapa, Taarashipan Móysisee taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ashiri Móysissha tsimbunoo táwara patumbchi tatsamooritam tururangiya. Ashiri putamsha puturi táwara patumbchee yáyaru, machip Sinayap kárirangiya. Yuwari Taarashipan kamachtarangu anuri Móysis tuminurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","6","Ashiri Taarashipansha msasush karuweeru, naantachu, yuwartatam Móysisee tárangu anuritam arangeem tushiyramchu; Nuwaa izuuru mangoonpana, átu, Móysisee tsiyatku tárangiya; Nuw Apanlli Taarashipantana. Nuw kchinamishtana. Tputsee nayanikina. Mishat, nuw nda ngutariti tputsee mikeeru tsiyantakina. Tputsireetsi kapung zurampatarta chinaktana, tárangiya Taarashipani. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ashiri tputsee chinakuri ayamta nda kasachima. Urutamaritam nlluranureewa chinachtamana. Urutamaritam yutaritshishirineetsini yarkuri taachima. Itaru, tputsee chinaktaati, uru yutaritshishimand wanichima. Yuwaatsimari tputs nuwaa kuki kapeetkana, misha nuwaa mantsir tsiyatkana anumandari nuw izuuru wanichima. Wipaatstamta, anumunsha wachinllinootstamta, anumun wachinllinootstam wipa, uru kiyung kachiykusin taachinllinaya, waparimand yutaritshishirini, tárangiya Taarashipani. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ashiri Móysissha mikeeru timucheeru, tsapumun much kandanchinand sheeru, Taarashipanee ungirtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ashiri Apaa, shiy zurampatari nuwaa chinakush, iyapat ipuneerush naangcha, Apaa. In tputs zurampatari yutaritssincha; itaru shiysha Apaa, iyaa yutaritshishirini izuuru mapiyngcha. Sheerush, shaana tputsireemish yusur iyaa ínangcha, Móysisi Taarashipanee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ashiri Taarashipansha; Na mazinangcha; Ashiri na nuw yusur tputsireemi siyaa ínchintspa. Ashiriya, nuw siyaa izuuru istachintspa. Nuwaa wizpuri kizpur napuxtamashee siysa pangatssa. Mishat, ichinguritam tputs nuwaa wizpuri pangchinllinaya. Yuwaa tputs tsapurunasush nllurtakchu nda anoo parangusin, itaru natsha pangchinllinaya. Mishat, siysa Kanaanush tsap taakchus, Kanaanshurisha ichingurusin nuwaa, Taarashipaneetsi wizpuri pangchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ashiri siysa nuwaa kuki payukinaareesa, nuwsha Kanaanshuchee tputs ichinguru tashitungachima; Amorrewshuchee, mishat Hititshuchee, mishat Feresewshuchi, mishat Hebewshuchee, mishat Jebusewshuchee ashpiri ichinguru Kanaanush tsap tashitungachima. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ashiri siysa Kanaanush tsap kuskachus, anpa tputs wanasir amikurtarintspa, watam uwapa mapiyru taakchus, uru siyaa xarashish wayachinllinawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ashiri paptsa. Siy mangiptis tángtsa. Uwaatssin apanllirinee minamtiyam chinarintspa, izuuru anoo mapiyngtsa. Anoo siysa ichinguroo kpitangtsa. Maachee ichinguru, patumbich xanatama anoo kapeeta kapeeta shingtsa. Mishat, apanllputsee waana tinayarusin, Aseraa sura ísamarangana, anoo ashpiri izuuru kpitangtsa. Ichinguroo pátangambeerus ksangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Apanllputsee ungirtarintspa, watam nuw Taarashipani Apanlli watseenurinawa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ashiri yusursha táchintspa siyaatsi, Kanaanshuchpa tputs wanasir amikurtarintspa. Uwapa wanasir amikurtakchinaareesha, ashiri uwshapsiniya shambatkusin, apanllputseem maacheetsi chinuzee mucheersin, siyaatssha; Pza; shiyaptatam washunand shambateeni, táyarusin, siysa uwapat anoo katungchitamsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ashiri minsha siyaa táchintspa; Siy minamtiyam ipareetsis kizaa uwashcheem wip kamuzinur panarintspa. Mishat, siysa iparis kamuzinur uwashchee wip kizanur yamarusinapa. Itaru, siyaa iparis yamakchinaari ashiru, apanllputseetssha wazaranllpa, nduntaati ashiru wizanllpa, ungirtachpasinaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Mishat, siyaa táchintspa; Ayamtaati yusur siy maachee orpat tinayarus, Watacha Apanlli ini, tárintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ashiriya, uru nuwaatsimari chinayarus, nuwaa kuki payungtsa. Ichinguru masach pangaa nda ísima tsimbun matayaru zari katungangtsa. Nuw sirú kamachtarangi anuri shingtsa. Ambari ashkus tángtsa yuwash Marsu tsup yakachu anshu, watam anush tsup Ijiptosh tsap nuw siyaa tashitungaranguri, siyaa tapachindarangina, Taarashipani tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Mishat, siyaa tina; Siy iparis kamuz iwachiztam nllurtakachu anoo nuwaam wayangtsa. Ashiri iparis iwachiztam nllurtakachu, minam opeejaa karupana, nduntaati ashiru kaaparaa karupana pchangtsa. Amb ashkachus, iparshitis ndusha tsipachinlliniya. Mishat, chineetsis wip iwachiztamawa upapchiri wakaraa, misha opeejaa, kaaparaa aship an karupanaw nuwaam wayayarus pchangtsa. Pachayarus, mucheerus, nuwaa ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Burroo wip iwachiztama nuwaam ipuseerus wayangtsa. Itaru, pcharintspa. Burrumand opeejaa karupana, nduntaati ashiru kaaparaa karupana pchangtsa. Itaru, nda ashimaam zandkus, ashiri burroo wayarpunish tupeerus, pchangtsa. Ashiri tputs maachee nuwaam wayamaam nda zandku, pachindku, ashiriya nuwashsha ungirtamaam kustapa, átcha Taarashipani tángcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Mishat, siyaa táchintspa; Ashiri siy minam matayaru zari tarawaztangtsa. Itaru, tsimbunurinsha matayaru zar anush kanusangtsa. Izuuru mapiyngtsa. Mapshis taaritaa, mzareemis mzaktaateesa ashiru, misha tatsumsheetsis pusaktaateesa ashiru, itaru anoo kanusishush zari kasayarus, izuuru kanusangtsa, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Urutamari yuwapur tirik wanus kayanakchu anush chtayarus, tsimbun matayaru siman pusakus, ichinguru xanateerus, nuwaatssha uru, Wapparee, átus, shambatkus tángtsa. Mishat, ichinguru tatsummareetsis wanus pusayarus, pusam iwapayarus, xanateerus, anumand shaniyeerus, nuwaatssha, Wapparee átus, shambatkus tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mishat, siy Israelchichis kamuzis ichingurus tputsis minamtash masach tuchip shaniykus, nuwash pangi kuseerus, nuwaa Apanlleetsi, Taarashipaneetsi, ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ashiri nuwsha siyash tsapunis, Kanaanush tsap, nllitaritaa tputs tashitungayaruri, arap zanganchima. Siyaamsha tsap kapunguri panachintspa. Anoo tsap siy ichinguru payutssa. Ashiri siysa tuchip nuwash pangi shaniymaam naakchus, itaru ¿chakaja siyaa tsapunis itutsich? mapiyrus, naatssa nuwap pangi, Taarashipan tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ashiri misha siyaa táchintspa; Chineetsis nuwaam pachakus, ursirpat pangapat tputampat nuwash wayarintspa. Yuwapur nuw siyaa tapachindarangi anush zar shaniykachus, opeejaa karupan wanuts katungkachus, katuchimaa putam zari katungamaam wayarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Anumunsha siy tatsumim wanus yuwaa ichtakachuri kayanakchu anoo pusayarus, nuwash pangi yushindayarus wayangtsa. Itaru, wanus wanasirinandari nuwash wayangtsa. Mishat, kaaparaa karupana waniripat mimiri k'parintspa, Taarashipan Móysisee kamachtaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ashiri Taarashipan Móysispat tsiyatamaam iwatspayaru; Na shiysha nuwaa kamachtamarini ichinguru kirakamun yandangcha. Sheeru, Israelchichee tputs ichingurusin nuwaa kamachtamari kamaningcha. Ashiri Israelchichsha nuwaa kamachtamarinee ichinguru payukchusin, nuwsha; Siyaa nuw tputsirtana, táchima siyaatsi, Taarashipan Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ashiri Móysisi anpari Taarashipanpat tsiyatku ipunpunar chunga zari psaanpatari zapshtarangiya. Nda katungku, misha nduntam waaku, taarangiya. Ashiri Taarashipansha yusur táwaramun patumbchimun waanaatsee wamachtash, minam chunga, yandarangiya. Yandamaam iwaparamchu, Móysiseem panarangiya. Ashiri na kamaneena yuwaa Apanll yusur kamachtamarineetsi patumbchimun yandarangu, mishat Israelchichee yusur tiptsireem ínarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ashiri Móysissha machip Sinayush karuweeshinu, táwar patumbich tsimbun Taarashipan kamachtamarini yandam payuru karuwarangiya. Itaru, Móysissha Taarashipanpat tsiyatarangu, wachsha kizpur kurakurtar ashirangiya. Itaru, Móysissha anoo nda waanaatsi yasarangiya yuwaa wach kurakurtaru anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ashiri tputsush kusarangu, Aaronsha misha ichingurusin Israelchich Móysisee wach kurakurtarangu anu parangusin, watsiri napamaam puniksin, arapinlltamarisha shaneersin napatarach ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Itaru, Móysissha Aaronaa mishat tputseetstam; Naanints ningeema, tárangiya. Ashiri Aaronsha mishat Israelchichtam urkar Móysispat tsiyatamaam kayumaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sheeru, uwshatssin, ichingurusin Israelchich, apinlliri naattusin kayumarangitamanaya. Ashiri ichingurusin Móysisush shaniyeersin, Móysissha Taarashipanee kuk yuwaa machish Sinayush tsiyatarangu anoo kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ashiri tsiyatssee kamanimaam iwatsparamchu, waanaatsisha natstarangiya yuwaa wach kurakurtaru anootsi. Ashiri wachoo kamispasha pakich kámanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Itaru, anumunsha sheeru, urutari Móysisi Taarashipanpat tsiyatamaam Apanllush pang' pshtukchu, kamisaa yusheeru wayarangiya yuwaa wachoo kámanaru anootsi. Sheeru, Apanllush pang' shitungeeru, Móysis yuwaa Taarashipan tputsee kamanishini, tárangu, anoo uwsha Israelchichee ichinguru kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ashiri Israelchich Móysisee wach kurakurtaru anoo paranganaya. Ashiriya, Móysissha waanasha wachoo yusur kamispat purangiya. Itaru yuwashumari Taarashipanpat tsiyatamaam Apanllush pang' pshtukchu anshumari kamisaa yushtariya. Ashiri na kamaneena yuwaa Móysis wach kizpur kurakurtar ashirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ashiri ndatuma Israelchich wakaraa orpat tinama ungirtatssin, Taarashipan Móysispat tsiyatku; Nuwaam pangi pangungandama, tárangiya. Ashiri Móysissha anoo nda mbizarangu, Israelchichee ichinguru tushaneerangu, Apanllee pang' pangumaam kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Taarashipan siyaa ateeja; Siysa maachee nuwaam pangi pangumaama wayangtsa. Ichinguru tputs yuw zurampatari nuwaam panamaam zandku, waana chinashimandari yushindachinllinpa; orootstamta, kurikeetstamta, ngusambaa ngusamb chumbeepimashatstamta anootstamta, átcha Taarashipani, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Anumunsha kamis tarikamashi, misha kawambanamshi, misha kamis kizpur chumbeepimashi yushindangtsa. Mishat, kamis kizpur wanasiri matsitamashi yushindangtsa. Mishat, kamistam kaaparapat pur k'tama yushindangtsa, átcha Taarashipani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Anumunsha, opeejaa upapchiri tasi tushiyram chumbeeppat, misha tasi musási yushindangtsa. Mishat, yasin sur Akasiya, yushindangtamtsa. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Mishat, wayungunu aramparinush muchimaam yushindangtsa. Anumunsha, wayungunutam kzammashpa íseeruch, apanllpanimun urkar much taparamaam yushindangtsa. Mishat, kzammashee wayungunpa íseeruch, wanasir nuwash pangi muchimaam wayangtsa, átcha Taarashipani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Ashiri misha, wich pakchimash chumbeepeewa, wich sur kornalina, anootstam yushindangtsa. Mishat, wichtam kizpur wanasirimshiwa nllitaritawa yushindangtsa apanllpanish urkar wamar pshtamaama. Sheeru, mangunung wanuru anushtam wichee pshtamaam yushindangtamtsa, átcha Taarashipan iyaatsi, Móysis Israelchicheetsi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Sheeru, Móysis tárangitamta; Ashiri yuwaa tputs maacheetsi tinamaam kizpur yasarana anin kuschinllinpa. Maachee kizpur wanasiri yuwaa Taarashipani kamachtarangu anu tinayani, Móysisi tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ichtaru Apanlleem pang' wansshucheem kamis kizpur wanasir kiz siritchinllinpa. Anumunsha, kiz kaapar pur k'tachinllinpa anpata imanamaama. Anumunsha, tasee kapung siriteerus, anpat pangungtsa Apanlleem pangu. Sheeru, wapzareemsha tinayani. Mishat, patuzinazeem, mishat unambeem, mishat wanupsheem, mishat maachee patuzinaz pshtamaam aship tinayani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Anumunsha, Apanlleem kajonarinee orpat taparayaruni tinayani. Anumunsha, Apanlleem kajonarinee kumaam unumbeem tinayani. Sheeru, kajoneemsha washtangash tinayani. Sheeru, kamisaa Apanllee kajonarini kámanamaam tinayanitamani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Anumunsha, mesaamshat tinayani. Sheeruni, mesaa kumaam unumbeemtam tinayani. Sheeru, maachisha mangawa, paratu, k'chara, aship, mishat pangaatstam mesamun wayamaam tinayani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Mishat, minam nambarinaa kapungumashi tinayani yuwash nambarin pakchimash 7 wayá wayáru anooma. Apanllush pang' 'sineemaam tinayani. Mishat, tirshisheema, mishat pshtasheema tinayani. Mishat, nambarinush tuzureeruch, wayungunoo tiroomaam yushindayani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ashiri kajoneemsha kzammashee Apanllish pang' mbutamaam tinayani. Mishat, yasinatam kajonee kumaam tinayani. Ashiri wayungunutam kzammashpa íseeruni mbutamaam tinayani. Sheeruni, kamisshat Apanllush pang' wachu kámanamaam tinayani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ashiri mishat, kajontam ngusambaam bronsi tinayani anush chinuzee Apanlleem muchimaam. Mishat, kajonee kumaam unumbeemtam tinayani. Mishat, maachee ichinguru sumasush patatamaamtam tinayani. Mishat, minam shtashish kapungumash ngusambapat bronsi tinayani apanllpani kuximaama. Mishat, shtashish wayamaam ngusambpat íseeruni bronsi tinayani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Mishat, patuzinazee, mishat patuzinazeem ktsimaam tinayani. Sheeru, patuzinaz wishchip pashucheeruni, kamissha patuzinazimun tstsayaani Apanllee pang' kámanamaama. Ashiri minamtam kamis Apanllish pangu pshtushinung kámanamaama tinayani ");
INSERT INTO cbuNT_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ashiri anamunsha, sookaam pangusee kasimaam nda yurangamaam tinayani. Mishat, wapzareemtam tsapush pashucheeruni, anumun sook yungayaruni, mbam kasimaam tinayani. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Anumunsha, Aaronaama wamar tsimbun tinayani. Minamtam mburish kamartayaru, Apanllush pang' kizpur wanasirimshish pshtumaam tinayani. Mishat, minumtam kizpur wanasiri kamartayaru Apanllush pang' wanasirimshi yareeru, patatamaam tinayani. Mishat, Aaronaamtam wip Apanllee pang' ksutamapaneem wamar tinayani, Móysis tputsee kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ashiriya, tputsshatssin Móysisee kuk mazinayarusin, ichingurusin pangup maacheetsi yaramaam naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Sheersin, yuw tputs mangush wanasiri chinarangana anumaritssin chinashimandari maachiritaa ichinguru Taarashipaneem yushindaranganaya. Anumunsha, apanllpaneem wamar kizpur wanasir siritamaam yushindarangitamanaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Kamuzawtam misha kizawtamta ichingurusin maachiritawa waanamandari chínashi, waanaatsee wayarangash orpat tinamawa yushindaranganaya. Xanootsi, mishat witsush tawankana anu, mishat anichu, mishat arangeem zapan payurangana anu ichinguru yushindaranganaya. Aship an Taarashipaneem panamaam izuuru zandarangsin, anuri ichinguru yushindaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Mishat, yuw tputs kamisaa wanasirimash payurangana anoo yushindarangana. Kamis kawambanamshi, misha kizpur chumbeepimash, misha kamis purashpat wanasir k'tama anu, misha kaaparaa pur k'tama yushindarangana. Anumunsha, opeejaa karupan tasi kizpur chumbeep tushiyramaa, misha tasee matsit wanasiri anootstam yushindaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Minsha, tputs ngusamb mburshimashi, misha ngusamb chumbeepimashi, ashirusin, waana zandarangsin, Taarashipaneem yushindaranganaya. Anumunsha misha, ashpatam tputs karipanaa, karipan sur Akasiya yushindaranganaya. Ashiri ichingurusin maachee zapan wanasirimash waana zandarangsin, aship an yushindaranganaya Taarashipaneema. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ashiri kizsha yuw maacheetsi kizpur wanasir k'tamaam yasarana anshatssin k'tamawa yushindaranganaya. Mishat, iru wanasir kusama tarikamashi, misha psiyaramashi, misha chumbeepimashi, misha purash k'tama kizpur wanasiri anootstam ichinguru yushindaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Mishat, kizaatssin yuw kaapara puru kusamaam yasarana anshtisin, kaapara pur k'sayarusin, yushindarangana. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ashiri kurakawshat wichee wanasirimshi yushindarangitamana. Wich sur kornalincha, misha wich kizpur wanasiri kapasurumbchi, apanllpanimun urkar watunir tapatstamaama, mishat mangunung watsingshish pshtamaam yushindarangana. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Mishat, tputs wayungunoo, misha kzammashee yushindaranganaya. Mbarinush kanapeeru, Apanllish pang' tiroomaam yushindarangana, Mishat, apanllpanimun much taparamaam yushindarangana. Mishat, Apanllish pang' tazumaamtam yushindarangana. ");
INSERT INTO cbuNT_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ashiriya, Israelchich tputs ichingurusin kamuztam misha kizatam yuw waana zandarangana anuri maacheetsi Taarashipaneem mangutarit panamaam yushindaranganaya. Yuwaa Taarashipan Móysisee kamachtarangu anuri maacheetsi ichinguru yushindaranganaya. Ashiri na kamaneena yuwaa Taarashipan; Nuwaam pangi pangungandama, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","2","Ashiriya, Móysissha tputsee kizpur yasamawa Besalela sura, mishat Aholiyaba sura aship tarawzipanee ksutamaam kuruzurangiya; watam Taarashipan waana uwaatssin tarawzipanee ksutamaam ipusaranguwa. Ashiriya, Móysissha tarawzipanee; Na siysa yasampanpat maachee ichinguru Apanlleem pang' tinangtsa, tárangiya. Ashiri ichinguru tatsamoongcha yuwaa Taarashipan waama pang' pangumaam iyaa kamachtarangu anurita, tárangiya Móysisi. ");
INSERT INTO cbuNT_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ashiri Móysissha maacheetsi ichinguru yuw tputs yushindarangana anoo yáyaru, tarawzipaneem panarangiya; Apanlleem pang' pangumaama. ");
INSERT INTO cbuNT_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Itaru, anumunsha tputs Israelchichsha aranginasha maacheetsi tarawzipaneem yushindat yushindat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Ashirucha, ichingurusin tarawzipan Móysisip naateersin táranganaya; Tputs aranginashshacha zapan yushindakchinllina. Ashiri na shiysha, wappa; waritayanlliya, tángcha. Tatsameenllcha Apanlleem pang' pangumaama, tángcha, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ashiri Móysissha tputsee kamachtarangiya; Na maachee yushindamaam na wappa. Apanlleem pang' pangumaam tatsameenllcha, kamuzaa misha kizaatstam tárangiya, Móysis. ");
INSERT INTO cbuNT_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ashiri anurisha tputs maacheetsi yushindamaam kasaranganaya, watam izuuru tarawaztamaam Apanlleem pang' pangumaama tatsamooranguwa. Ashiri na kamaneena yuwaa Israelchich maacheetsi zapan yushindarangana Apanlleem pang' pangumaama anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","An sheeru, yuwamun Ijiptosh tsap shitungarangana anumun minam masach izuuru tushiyramchu, putamsha anush Apanlleem pang' pangumaama chtaranganaya ");
INSERT INTO cbuNT_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ashiri tputs ichinguru maachi wayam iwapayarusin, Móysissha; Ashiri na panguyani, tárangiya. Ichtaru patuzinazee tuxiykeeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Sheeru, unambeem wayayaru, wanupsheemsha wayarangitamanaya. Sheeru, kamisshat unambeem kunaranganaya. Sheeru, iwapayarusin, anumun kaapara pur kamis k'tam anpat puranganaya. Sheeru, anumunsha taspat panguranganaya. Yuwaa Taarashipan kamachtarangu anuritam ichinguru tuminaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Sheeru, anumunsha patumbcheetssha yuwaa Taarashipan waanaatsi kamachtamarinee yandarangu anoo Apanllish kajonarini wayaranganaya. Sheeru, anumunsha kajonee washtangashpat shtandaranganaya. Anumunsha, kajonimun unambeem pshtamaam ipunpunar tstsaranganaya. Sheersin, unambee anush pshingaranganaya kumaama. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kuyarusin, Apanllish pang' waantsush wayaranganaya. Sheeru, anumunsha kamispasha kámanarangiya. Yuwari Taarashipan waana kamachtarangu anuritam tuminuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ashiriya, anumunsha Móysissha mesaa, kamisaa kámanaru anoo, ningari mbazinungich wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Sheeru, mesamunsha pangaa wayarangiya. Yuwari Taarashipan waana kamachtarangu anuritam ichinguru tuminuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Sheeru, anumunsha mbarinaa wantsushtam wayarangiya; mbatsutsunungich mesanungiri tasaseeru wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Sheeru, Nambarinaatssha wayat wayat sheersin, tirooranganaya yuwari waana Taarashipan kamachtarangu anuritamta. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","27","Anumunsha, kajonee orpat tinam kzammashee mbutamaam Apanllush pang' wantsshutam wayarangitamanaya. Kamis kámanaru annung tasaseeru wayarangana. Sheeru, kajonushsha kzammashee mbutarangtamanaya. Yuwari Taarashipan tárangu anuritam tuminaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Sheeru, anumunsha Móysis Apanllish pang' pshtushishinung kamispat kámanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Sheeru, anumunsha kajontam ngusambaam bronsi tinamaa wishchip wayayaru, chinootssha, wakaraa, mishat opeejaa ashiru pachayarusin, Taarashipanee ungirtamaam muchiranganaya. Mishat, tirikootstam Apanlleem muchirangtamanaya. Yuwari Taarashipan kamachtarangu anuri tuminaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","31","Anumunsha, shtashee kapungumashi wishchiptam wayarangana. Apanllish pang' tasaseeru kajoninung ush wayaranganaya. Sheeru, shtashishsha kungoo tatsitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ashiri anushsha Móysisi, misha Aaronatam, misha Aarontam wip kungoo tipayarusin, uw kuxirangana, mishat watseetstam kuparanganaya. Ndatuma Apanllish pang' pshtursin, mishat ndatuma kajonush kuseersin, uru ichtaru watseetsima kupayarusin, anumunsha kuxiranganaya. Yuwari Taarashipan kamachtarangu anuri tuminaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Anumunsha, Móysis ichinguru iwapayaru, kamispatshat tipuranllizee ichinguru kámanarangiya. Anamunshat, pshtushishinung kamispat wishchip pshtumaam kámanarangiya. Amb sheersin, ichinguru Taarashipanee wamachtash iwaparanganaya. Ashiri na kamaneena yuwaa Apanlleem panguyarusin, anush Apanllee ungirtarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ashiri pangumaam iwapurangusin, anuritam msassha karuweeru, Apanllee pang' yambutarangiya. Anumunsha, Taarashipansha wizpur waanaatsi pang' izuuru tatsitarangu tuwasineerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ashiri Móysissha nda Apanllish pang' pshtumaam waritarangiya, watam msas kizpur tuwapimunuwa. Mishat, Taarashipansha wizpur kizpur tuwasinirangiya. Izuuru 'sin Apanllush pang' tatsitarangiya. Msas uru Apanllee pang' yambutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Itaru, msassha pakich íwar káritara ashkachu, anush Israelchichsha pangoo yáyarandsin, naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Itaru, nduma msas íwar káru, Israelchich nduntam naamaam waritarangana. Msas íwar káreemasa atusin kutaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ashiri yuwapur Israelchichi naarangana anpur uru tputs Apanllish pang' msas yambutaru anoo parangana. Anumunsha, tputs psaantam napkusin, sumas tamapari ashiru msasush 'sinee ashirangiya. Ashiriya, na kamaneena yuwaa msas Apanllimun pangu karuwarangu anootsi. Ashiriya, nuw Móysisi: wapparee, atina siyaatsi. Na kamaneena yuwaa Apanll Israelchichee tashitungarangu anootsi.");
INSERT INTO cbuNT_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaron wip tsimbun nda Apanllee kuk payurangusin, yuwash kamis Apanllush pang' kámanaru anush arangeem msangeersin pshturanganaya. Anumand Apanllsha Aaronaa wip waneerangu, tsiparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Apanllsha Móysisee; Shiysha zuwanlleetsish kamaningcha, Apanll shiyaa ateeja: Shiysha kamis kámanaru anush arangeem msangeerush pshturinllpa. Kajoninung washtangash ngutish kusinllpa. Papcha tsiparush. Watam nuw kajonimun washtangash psasush karuwkinawa. Zuwanllish Aaron msangaru pshtukchinaari, anush uru tsipachiya, átanda, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ashiri Aaron pshtumaam zandku, minam wakaraa pachachpa waanaatsi yutaritshishirinee yaramaama. Mishat, opeejaatstam pachachtampa sumasush muchimaama. Ashkachu, nuwsha yutaritshishirineetsi tachingchima. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ndatuma pshturu, ichtaru kungushuma wanasir chumachpa. Sheeru, k'tunee mburshimashi kizpur wanasirimish kamartachpa. Kichpusheetssha wanasiritam mburshimash kichpuchpa. Turussha mburshimashtam turustachpa. Yuwaa apanllpaneem urkari kamachtarangi anuritam tuminungi tángcha. Apanll Móysisee tárangiya. Ashiriya, na kamaneena yuwaa Apanll, Nuwash pangi kizpur wanasirimshish msangarus pshturintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Apanll tárangitamta, Israelchichee tputsi yutaritshishee yaramaam Aaron chip upapchir tsimbun, mishat opeejaatstam minam yamachpa nuwaam panamaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ichtaru, waamatama yutaritshirinee wakar wip pachayaru, muchichpa. Ashkachu, nuwsha maachiritaa yutaritshishirinee ichingaru mapiychina. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Anumunsha, Aaron chip tsimbun yamayaru, pangipi washitungashinung kusachpa ");
INSERT INTO cbuNT_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","anush patumbichpa michitamaama. ¿Tamamaja chip sur shitungkach? átus yachayarus, yuw shitungkachu an watacha nuwaam Apanlleemi pachamaama. Itaru, minootssha chipoo waanitam minam kchit wayangcha arap upusap machinaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ashiri yuw chip sur nuwaam, Apanlleemi shitungkachu anoo Aaronaa, Pchangi, tángcha. Pachakchu, nuwsha Israelchichee yutaritshishirini yarchima, Apanlli Móysisaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mishat, chip kchit nuwaam wayangcha. Sheeru, Aaronsha chipumun much uw wayayaru, tputsee yutaritshishirini ichinguroo kamaneeru, chipsha yutaritshishee arap upusap maachchiya. Ambari yutaritshish waani pastachiya. Ashkachu, nuwsha tputsee izuuru yarchima. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ashiriya, Zuwanlleetsish Aaronaa kamaningcha. Yuwash zari yutaritshishee tachingamaam tatsamkachu anush, waanaatstamaa, misha wipaatstam yutaritshishirini yarchinllinpa, átcha Apanlli, tángcha. Chinuzee wakaraa pachayaru, ");
INSERT INTO cbuNT_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Apanllip wasuma naayaru, mangawash watsam tatsitachpa. Sheeru, kzammashee uwish tsimbunuri putayaru, kamis kámanaru anush arangeem pshtuchpa. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ashiri nuwsha anoo pangchima, yuwaa mangawash pshtaru watsamash kzammashee nuwaam muchchu anootsi. An kzammash pzeezakchu, kajonee washtangash yambutachiya. Wantsush nuw kuki kamachtamari taaru anoo nda mbizamaama. Amb ashkachu, ndusha tsipachiya, átcha Apanlli shiyaatsi, Aaronaa tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Anumunsha, shitungkachu, wakar ursir yáyaru, waptam kamis kámanaru anshutam arangeem kanapkachu, wakar ursir pakich uwish patateeru, anpa kajonee washtangash mbutsanungich ixuwtata ashichpa. Anumunsha, yusur uwish pakich kurasee patateeru, anpa kajonmun washtangash tasasaru tsimbun matayaru ixuwat, ixuwat ashichpa, átcha Apanlli, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","16","Ashiri anumunsha, Aaron shitungeeru, nuwaam chipoo pachachpa. Chipsha tsipakchu, nuwsha ichinguroo tputs yutaritshishirinee mapiychina. Itaru, wand nuwaam pangi yaramaam pishtakiya. Yuwaa Israelchich yutaritshishirini nuwaa pangi taminllurtarangu anoo yaramaam na kamachtachima. Chipootssha ursir pakich mangawash yáyaru, yusur kamis iwaz kámanaru anush nuwash pangi pshtuchpa. Anush wantsush wakar ursir washtangashimun ixuwtarangu sheertam ixuwtachpa chipoo ursiri, tángcha. Ashkachu, nuwsha pangi kámanaru anush izuuru wanasir tachingamsha taachiya. Shitungeeru, uwsha nuwaa pangi ichinguru wanasir yaramaam kuraspat ixuwtachpa, átcha, tángcha, watam anumand tputs urutamari tayutaritkanawa. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ndatuma Aaron nuwash pangi shitungkaru, tputs minamtiyam wanasirimshish pshturusinapa. Aaronamari pshtuyaru, nuw ichingaroo yutaritshishirinee tachingchima, maachiritaatstam, Israelchicheetstamta. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ashiriya, uwsha shitungkachu, wishchip yuwash chinuzee nuwaam mbutkana anshutam yarchitampa. Tachingamaamsha pakich wakaraa ursir yáyaru, chippat ursir kajonamun ixuwtachpa. Apanlleem mbutamaam wayarana wakaramun wits anumun kuraspat patateeru, kandanta, kandanta, ashichpa, tángcha ");
INSERT INTO cbuNT_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Anumunsha, uwpat kurasee patateeru, kajonee sietimari ixuwtachpa. Amb ashkachu, nuwashsha pangi yutaritshish pastachiya. Yuwamand Israelchich yutaritshishirini pangeetsi itsachtarangana anoo nuwsha izuuru mapiychima, átcha Apanlli shiyaatsi, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ashiri Aaron nuwash pangi kizpur wanasirimshish nuwash sumi kajonee yaramaam yuwaparamchu, Chipoo kchita yátani táchiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron uw chipumun much patatachpa. Sheeru, tputsee yutaritshishee ichinguru kamanichpa. Yuwaatstam ichinguru mantsir ashirangana anoo kamanichpa. Ashkachu an, yutaritshish ichinguru chipushsha wanuts pshtukiya. Ashiri tputsee minam kamachtachpa: Chipoo Asalelap arap yap tputs nduni amb machichpa, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Amb yutaritshishirini arap kapeetchiya mbizamaamarita. Ashkachu, chipsha waanasha tsipachiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ashiriya, Aaronsha ichinguru iwapayaru, nuwash pangi yusur pshtuyaru, watuniree mburshimashee tusheeru, anshuri tayapeeru kasachiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","25","Amb sheeru, anshurtatam chumayaru, yusursha kamartayaru, shitungeeru, minootssha opeejaa karupana pachayaru, waanaatsi yutaritshishirinee yaramaam muchchiya, tputseetstam yutaritshishirini yaramaama. Ashiri opeejaa karupan tatsamooru muchchiya, washunand wayungunpa ísiru, mang Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Mishat, yuw tputs chipoo arap machtarangu an ndatuma pangusip kanapuru, ichtaru watuniree yusheeru, káchachiya. Waanasha kungush chumachtampa. Amb sheeru, chumayaru, wanasir pangusush pshtuchiya, mang Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Mishat, tárangitamta; Ashiri yuw wakaraa, chipoo Aaron pacharangu, ursiri yarangu yutaritshishee tachingamaama anoo, waanaatsi, taspatari, mangpatari, washippatari, chikpatari ichingaru arap yáteeru, tputsee taárash piyam wishchip arangeem izuuru muchichpa. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Yuw tputs muchkachu ansha nduma pangusip kanapuru, watuniree káchachtampa, misha waanaatsi wanuts kungupat kupachtampa. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ashiriya, ichinguru masach siysa anuri tuminungtsa. Tsup sietish, zar diesash ambari ashkusin taachinllinaya. Anushsha zar ktungusinapa; misha tarawaztarusinapa. Tputs tunar siyapa taakana anoo, Siysa ambitam shingtamtsa, táchpa. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Anush zar nuwsha siyaa yutaritshishiris tachingchima. Anumunarisha, siy yutaritshishiris ichingarus tachingam taatssa. Ashirucha, ¿tamareeja anush zar katungkuch tarawaztachich? siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","An watacha nuw kuki Apanlli kamachtamari siyaam kizpur wanasirimshi, anush zar nda tarawaztamaam, misha nda katungamaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ashiriya, Aaronsha waanaatsi wip ipusachpa apanllpaneem urkari. Uwsha waparish zamuchiya. Nuwaatssha kuki tuminkachu, nuwsha siyaa yutaritshishireetsis tachingchina, mang Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ashiri kaneesichsha apanllpan kurakaam zuramaptari kinayaru, uwsha k'tunee k'tuntayaru, nuwash pangi wanasirimshish pshtuchpa. Ashkachu, nuwsha apanllpanee urkar yutaritshishirinee mapiychina, ichinguroo tputs yutaritshishirini tachingchina, mang Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","An watacha Apanll chínash wanasirimshi siyaama. Ichinguru masach, yuwash zar tatsamkachu anush, nuw kamachtarangi anoo ichinguru tuminkachus, nuwsha siyaa yutaritshishiris izuuru tachingchina, Apanll Taarashipan mang Móysisee tárangiya. Ashiriya mang, Israelchichsha anoo mazinayarusin, Móysisee kuk ichingurusin payuranganaya. Ashiri na kamaneena yuwaa Apanll yutaritshishireetsis mapiymaam, Chinuzee muchingcha, Aaronaa tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","Apanll Taarashipan Móysisee tárangiya, Shiysha Israelchichee tputsee nuwaa kuki kamaningcha. Nuw waatatana siy Apanlliris Taarashipani. Nuwamari wanasiriri taakina; nda mantsir chinamaam yasarina. Siysa ichingurus nuwaa kuki payungtsa; wanasir taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Siyaa táchintspa; Siy aneereetsis chinangtsa; apareetstamtis chinangtamtsa. Mishat, siy ichingurus urutari kanusisush kanuskus taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Mishat, yashingoo chinarintspa. Apanllputsimun mangis tatintspa. Ayamamtiyam apanllputsee tinayarus, anoo ungirtarintspa. Nuwamari waatatana Apanlli Taarashipani. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Mishat, shiyaa táchintspa, Tputs nuwapa tatsuyamaam zandkusin, mangiptis opeejareetsis karupana pachayarus, nuwaam muchingtsa. Ashkachus, nuwsha siyaa kis napchintsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Opeejaa karupana pachayarus, anumunsha wanutsee ktungangtsa. Wandaya wanutsee katuchkachus, putam zari katungamaam wayangtsa. Itaru, anoo tuchparini zar katuchkachus, ashiriya, anootsina muchingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Itaru, tputs tuchpash zar wanutsee katungkachu, nuwsha nda siyaa yutaritshishireetsis tachingchina, atina. Anoo tputs tsachikchuri, ndusha chinachina. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Tputs tuchpash zar katungkachinaari, waanamandari chayarini kiyung kachiychiya. Siysa anoo tputs tsapunshis izuuru tshitungangtsa. Anoo tputs izuuru ayamta naynirintspa, watam nuwaa Apanlleetsi k'keetsi kapeeteenlluwa, siyaa atashina. Na kamaneena yuwaa Apanll Móysisee, Wanasir taangtsa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Tirikureetsis pusamaam zar tatsamkachu, mzarshis chapung wayandapsheewa ngutaritis ksangtsa; yuw tsapush paratungtaru anoo tapuyarintspa; waani taachpa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kizarunaatssha pusakus, tsapush pantsatamawaa tapuyarintspa. Izuuru ksangtsa. Pukirireew, tunareewtam tputs waani tapuychinllinpa. Nuw waatatana Apanlli Taarashipani siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Mishat, siyaa tina; Shuchirintspa. Mishat, nllitaritawaa tputsi ngichintspa. Ngutis nllitaritaa tputs tamapingarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ngutis tputsee, nuw Apanllimun zureerutana áti, ngichzee ngichpi átus, tárintspa. Nuw waatatana tsinsampantana. Ashiri siy ngutis nuwaa yutaritaam ínarispa, siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Mishat, tputspatatis waratintspa. Mangishis chinakus, Nuwamari kasiyaruri, maachiritaa itutsichima, tárintspa. Mishat, siy tputsiris tarawaztampan taarinaari, tuwapamaam zaree zapshtarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Mishat, tputsee mitsshartaa mantsir tsiyatintspa. Tputs wach pchusaa pantsap átus, yasin ngootsush wayarintspa. Wanasir napangtsa, watam uwin nuwaa Apanlleetsi chinaktamnawa. Nuw waatatana Apanlli Taarashipani. Ashiri siysa nuwaa kuki payungandama, siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Mishat, tputs tsiyatssee yaramaam zandku, kurakaa yaramapanee kuruzku, ¿mayaamaja kuraksha minootsimsha tputs chinayaru, minootssha niyrach? Tatsamooru k'kuzee yarachpa. Pukiriya tputs yutarit ashirangu, uru pukiree wanichtampa. Tputs putitaatiya yutariteechu, ¿mayaamaja anoo tputs puniku punich? Shiy yutarit ashirangsha; ashiriya shiyaa wanichinllpa, itsinsaru táchpa. Shiy watam kurakshawa. Ashiri mangiptish itsinsaru tsiyatangcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Tputsee mantsir tsiyat, tsiyat shirintspa. Mishat, tputsee pachamaam mantsir tuchinarinllpa, siyaa atashina. Nuw waatatana Apanlli Taarashipani. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Mishat, tputs yutarit chinaku, siysa anoo mapiyrintspa. Tputsee mangu p'tseengtsa; chinampatari waneengcha. Ndunnaa waneekus shaanaatstatam tayutaritchiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ashiri tputsee natsarintspa. Tistamaam chinarintspa. Saanpatatis tsiyanpatis taarintspa. Shiyaa tputs natsaktaa, anoo ashtaa chinangcha, watam shaana tamapari ashiritamshawa. Tputsireetsish chinamari chinangcha. Nuw waatatana Apanlli Taarashipani. Ashirucha, nuw siyaa atashina. Ashiri na kamaneena yuwaa Apanll tputsee istangtsa tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Apanll tárangiya; Ichingurus mazinangtsa nuwaa kuki. Nuw siyaa táchintspa; chineetsis minpat chinuz mantsir tuyangarintspa. Mishat, minamtash mzats washunand yapandaru wach nllitaritawpat ttsumintspa. K'tamaamsha zandkus, yapandaru irupat washunand ísiru minpat k'tarintspa. Amb ashiru, washunand k'tamaa kamartarintspa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Minootssha táchintspa; Yuwaa tputs kurikpa kizaa muchchureem paxanxku anootsi. Kanungas anoo kiz kamasina yamapi atinaariya, upaturunarsha muchchuree ayu táranginaariya, itaru waantatamsha amuy anoo kiz yutarit patatkinaariya, uwsha kanungaseem kurik tuwapchiya yuwamand yutarit patatarangu anumanda. Itaru, pachamana pcharintspa, watam kizaa ndaturi izuuru yamaruwa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","22","Upaturunarsha nuwash pangi minam opeejaa karupan pachamaam yushindachpa. Shaniyshish pshtushinung opeejaa karupan wayachpa. Anush yutaritshishirinimand nuwaam muchchiya. Apanllpansha urkar yutaritshishee tachingamaam nuwaa mashchiya. Ashkachu, nuwsha upaturunaree yutaritshishirini yarchima. Nuw waatatana Apanll Taarashipani nuw siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ashiriya, siy Kanaanush tsap taakchus, wanusee tatsumingtsa. Waani yusiypana. Itaru tatsumareetsis tuchpatati masachi musá pizaa kturintspa. Mishat, wanusee ktungintspa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Itaru, ipunpunarush masach wanusee nuwash pangi ichinguru yushindangandama nuwaam panamaama. Sheerus shambatkus, nuwaa wappari tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Zameetarinsha masach annaaparee siysa wanusee katungatssa. Amb ashkus, ichinguru masach tatsumarshtis zapan yusiychiya. Nuw waatatana Apanll Taarashipani siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Mishat, táchintspa; Maachta pachayarus, ursirpatari ayamamtiyam ktungintspa. Mishat, tputs wishun ashirusin tputseewa yasakana, anpaneem siysat pshturintspa. Tuwacheerus, yuwaa ayam ashtachu anoo tsiyatintspa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Mishat, mucheetsis tatsamooru iripich ktireerintspa. Suseetstamtis yuwaa tsparatu anoo kturintspa ");
INSERT INTO cbuNT_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mishat, maachiritis tsipaku, mangis mantsakus, nutseetsis chawarintspa. Mishat, nutsimunis maacheetsi urutamari kataru anumashpa yandarintspa. Watam nuw Apanlli Taarashipani siyaam tinaranginawa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Mishat, ipareetsish kizaa yutaritam wayayarus, mshipaneem ínarintspa. Sheeruni, kurikee zapan putapani átus shirintspa. Amb ashkus mantsir ashiksa. Ashkachinaareesa, kizpur mantsir taatssa piyartach tputs tamakanaya siysat ashtachtamsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mishat, yuwaa nuw zar sápatoo kanusissheem wayarangi anush zar siysat kanusangtamtsa. Mishat, nuwash pangi kuskachus, mangiptis napangtsa, nuw siyaa atashina, watam nuw Apanlli Taarashipanawa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Mishat, wázuririp siy pshtukinaareesa, Nuwaa mangi natstanda, tárintspa. ¿Mayaamaja yashingoo chinachich? Apanlleemsha itsachtakpaz ashtachiya. Ashkachu, nuwsha siyaa tsachichina. Watam nuw Apanlli siyaam taakinawa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Wachinash tputs napkinaareesa, siysat wachinaam kutakus istangtsa. Amb ashkus, saanaatsi wanasir nuwaa Apanlleetsi tuyamandaksa. Watam nuw Apanlli Taarashipanawa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Mishat, arapich tputs tunar siyash taakinaariya, siysa wanasir napangtsa; kiyung yacharintspa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Saanpata chinakis ambtam shingtsa. Tatsamooru chinangtsa, watam tputstamtawa. Sirútama, siy Ijipto tsap arapchitamtis taarangsa. Ijiptoshuch tputs siyaa kiyung yacharangana, siysat ambtam tputsee arapcheewaa shirintspa, nuw siyaa atashina. Waatatana nuw Taarashipani siy Apanllirisa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Mishat, tupaxanxakus, nda shuchimaam tatsamooru táchintsa. Táchshisheem ningat metoroo mantsir wayarintspa. Baransaatssha kiloo táchimaam kayxukus, tatsamooritam tácheerus kayxungtsa. Aratash maacheetsi wayungunoo tatsamaru táchingtsa, nda yanuru shuchimaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Arangitam yanuru wayarintspa. Nuwaa kuki payungtsa, watam nuw siyaam istaranguri, Ijiptop tsap tashitungaranginawa. Waatatana nuw Taarashipani siy Apanllirisa. ");
INSERT INTO cbuNT_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ashirucha, nuw siyaa atashina; Yuwaatsimari nuw siyaa kamachtarangi anootsimari payungtsa. Kitsis mazinangtsa, watam nuw siyaa Apanlliris taakinawa. Ashiriya, na kamaneena yuwaa Apanll ichinguru tinamarineetsi piy shingtsa tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Apanll Taarashipani Móysisee tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Na siyaa kamachtachintspa yuw zar wanasirimish shaniyshisheem ipuschis anootsi. Siysa washunand ungirtamaam nuwaam shaniykus, anoo zar ísamangtsa; Apanlleem shaniyshini átus. Shiysha, Móysisee, nuwaa kuki Israelchichee tputsi ichinguru kamaningcha, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Anumunsha, Apanll tárangiya; Siy minam matayaru zari tarawaztangtsa. Itaru, tsimbun mataykachu zar sabadush siy pakchiyam maacheetsi tarawaztarintspa. Sabadush zari kizpur wanasirimish kanussish taachiya. Anush zar shaniykus, nuwaa Apanlleetsi ungirtangtsa. Yapamasaja taarus zar tatsamkachiya, anush kanusangtsa. Nuwaa ungirtangtsa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Mishat, Apanll Móysisee tárangiya. Zari siyaam kizpur wanasiri taarcha. Anush zar siy ichingurus nuwaa Apanlleetsi Taarashipaneetsi ungirtamaam washunand shaniyangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Masach kaneesich yakachu, tsupsha minumtarini yakchu, zarsha 14 tapitaranllu, anush shaniyangtsa. Nuw siyaa sirútama Ijiptosh watsapun tashitungarangi anoo chinamaam shingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Putamsha zar kinsish pangaa nda tputtaru anoo katungamaam chtangtsa. Zar sietimari katungkus kchingantsa. Nuw siyaa Ijiptosh tsap tashitungarangi anoo nda mbizamaama, átana. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Zar minumtarini washunand shaniyrus, nuwaatsimari ungirtangandama. Anush zar tarawaztarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Anumunsha, 7 zar maaramchus, siysa wakaraa, opeejaa, karupanaatstam pachayarus, nuwaam muchingtsa. Zar sietirini, yuwash kachingkachu anushsha shaniyeerus, nuwaa ungirtangtsa. Anush zar tputsirish pakchiyam tarawaztarusinapa. Ashiri shiysha tputsireetsish kamaningcha, Apanll Móysisee tárangiya. Ashiri na kamaneena yuwaa Apanll Israelchichee tapachindayanlli, anoom mbizarintspa átu, urutamari nee 7 zar shambatshisheem wayangtsa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Apanll Taarashipan tárangiya Móysiseetsi; ");
INSERT INTO cbuNT_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Shiy Israelchichee kamaningcha; Nuw Kanaanaa tsap siyaam panachintspa, tárangina. Ashiriya, anush tsap taakchus, tatsumareetsis pusayarus, yuw ichtakachuri pusakchis anoo kamuriyarus nuwap pangi yushindangtsa. Sheerus, apanllpaneem urkari panangcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kanussish zar tushiyramchu, putam apanllpansha urkar kamurimaa uwish yáyaru, íwar itsireeru, nuwaa Apanlleetsi, Wapparee, táchiya, Anoo pakchuri, nuwsha mangi kis siyaa napchintsa, átana; tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ashiri anshurtatam zar minamtam opeeja karupan yuw minumari masach taaru, wánguyar ndunari anoo yushindangtsa. Sheerus, pachayarus, muchingtsa. Ashkachus, nuwsha siyaa kis napchima. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Mishat, wasipur tirik ipunpunar kilo anumun chawpi kizpur wanasiri wayungunpa ísima yushindangtamtsa, Ashiri apanllpansha urkar nuwash sumi anoo muchchiya. Anoo muchkachu, nuwaam kizpur kzama. Anumunsha vinu minam litoru yushindachtampa. Aship an apanllpan urkar vinoo yáyaru, nuwanung sumi tuchumuchpa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ndatuma tirikoo wanus kaneeschee pusamaa nuwash pangi yushindachus, anoo ktungintspa. Pangaam tiriku wanus kaneesichpa tinamaa anoo ktungintspa. K'pichimaatstam ktungintspa. An watacha nuw kamachtamari urutamari payumaama. Ipareetstamtis tayaspatangtsa. Ipareetsis yap taakachis amb piy shingints, tángcha, Apanlli Móysisee tárangiya. Ashiri Móysissha anoo Apanllee kuk ichinguru Israelchichee tputsi kamanirangiya. Ashiri na kamaneena yuwaa Apanll; Tatsumaris tirik kayanakchu, ichtaru pusayarus, nuwaam wayangtsa shambatshisheema, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Apanll yusur minootssha kamachtaku tárangitamta; Zar yuwash tirikoo wayakis anoo zaree táchingtsa. Napa: kanussish zaree nuwaam tirikoo wayachus, an zar tushiyaru, putaam 7 simanaa táchingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Anumand zar putaamsha 50 zar izuuru tushiychiya. Anshurisha zar nuwaam tirikureetsis yuw kaneesich pusarangis anoo wayangandama. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ashiri siysa tirikoo wasipur uchu kilo kizpur wanasiri yáyarus, tsimbun pangaa tputamamshipat wanasiriri ptatangtsa. Sheerus, pangaa museerus, nuwash pangi yushindangtsa. An pang nuwaama tuchtamaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Pangaa 2, misha opeejaa upapchir 7 wip washunand aship yushindangtsa. Opeej yuw minam masach taaru anu wanasiri nda wanguyaa yushindangtsa. Minam wakar wip upapchiri, anumunsha tsimbun upapchir wachin opeej, muchimaam tatsamooru nuwash pangi yushindangtamtsa. Anoo tirikpa, vinuptatam washunand nuwaam yushindayarus wayangtsa. Anoo nuwaam muchingtsa. Ashkachus, nuwaam kizpur wanasir kzam pchazachiya. Nuwsha mangi ksachina, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mishat, minam chipoo nuwaam muchingtamtsa. Anumun nuw siyaa mangis yarchima. Mishat, tsimbun wip upapchir opeejaris, yuw minam masach taaru anu, muchingtamtsa. Anumun nuw siyaa mangeetsis yarkachuri, tatsuyachshaparina. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ashiri apanllpansha pangapa yuw ichtari kayanayaru tirikoo pusarangis anpatari yáyaru, íwar itsireeru, nuwaam ungirtachiya. Anumunsha tsimbunuri opeejaa putayaru, pangapa, tirikpa washunand nuwaam muchchiya. Ashkachu, nuwsha siyaa mapiychtina. Anoo iwatspayaru, apanllpansha wipapat ichingurusin anoo katungchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ashiri anuritam zar siy washunand shaniyeerus, nuwaa ungirtangandama. Mishat, anush zar minamtiyam tputs tarawaztarusinapa. An watacha Apanll uru payumaam kamachtarangu anu, tputsee tángcha. Ashiri siysa ipareetsis anoo tayaspatangtsa. Siy yapamasaja taakamchus anshutam, uru ipareetsis tayaspatakus taangtsa, átcha Apanlli, tángcha. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Mishat, Apanllsha siyaa atiya; Ashiri siy tirikureetsis, nduntaati ashiru sebaadaa, pusamaam iwapayarus, yusur mzarpish kanapeerush, yuwaa chapunguw kasarangish anoo yarintspa. Pukireem tputsi izuuru ksangcha, misha yuw arapich tputs mazar nduneew taakana anooma. Nuw Apanlli siyaa atina, átcha Apanlli, tángcha, Apanll Móysisee tárangiya. Ashiriya, na kamaneena yuwaa sincuentash zari shambatshishirini taakchu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mishat, Apanll Taarashipani Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Ashchiri shiysha Israelchichee kamaningcha; Tsup kaneesich yakchu, sietish tsupi anush zar kanusangints. Wakarash wits puu puu táyarus, washunand shaniyrus, nuwaa ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Nuwaa chinamaam minam wakaraa muchingtsa. Nuwaa wapparee tángandama. Anush zar tarawztarintspa, átcha Apanll siyaatsi, tángcha, Apanll tárangiya Móysiseetsi. Ashiri na kamaneena yuwaa shambatshishee wakaraa wits puu puu támaam wayarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Apanll Móysisee tárangiya, ");
INSERT INTO cbuNT_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Zar chung maaramchu, anshurtatam tsup, ningach tsimbun matayaru tsup, nuw siyaa yutaritshishireetsis tachingchima. Siysa anush zar minamtiyam katungintspa. Ichingurus, washunand shaniyrus, chineetsis muchingtsa nuwaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Minamtiyam tputs tarawaztarusinapa. Nuw siyaa yutaritshishirineetsis tachingpi tina. Apanllpansha urkar nuwaa tasaseeru, siyamand yutaritshishiris mashchiya. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Anush zar tputs katungtapa. Tputs katungachu, siysa anoo tputsee izuuru tashitungangtsa. Yuwash taakis anush yaktarshis zapshitaati an tputs kanapuru taatpa. Izuuru mapiyngtsa, átana. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mishat, tputs anush zar pakchitaa tarawaztakchu, nuwsha waneeyaruri, arap kapeetchima. Ndunshaparee anoo tputs patssa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ashirucha, nuw siyaa atashina, Minamtiyam tputs tarawaztarusinapa. An watacha nuw kamachtamari yuw uwamari kasiyru anu. An tsiyatsis urutamari taachiya. Siysa ipareewaatstamtis tayaspatangtsa yapamasaja taakamchis anshutamta. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","An watacha siyaam minam zar kanusissheem, misha anshutam mangungtamtsa; katungintspa. Katungamaam kasayarus, zar tapitaramchu, psaan mangumaam chtayarus, tarasiyarus, wazuran zar tapiyarus, yusur misha tapitaramchu, anush zar ksangtsa. Sheerus, katungamaam waritariya, Apanlli Móysisee tárangiya. Ashiri na kamaneena yuwaa Apanll tputsee yutaritshishirini yarchima tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Apanll Móysisee tárangiya; ");
INSERT INTO cbuNT_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Israelchichee kamaningcha, Zar yutaritshishee yaramaam tushiyaru, anshurtatam tsup, zar kinsish yusur shaniyangints. Masharpa tambtayarus, tsimbun matayaru zar shaniyeerus, nuwaa Apanlleetsi chinamaam ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Yuwash zar shaniymaam tatsamkachu, shaniyeerus, nuwaatsimari ungirtangtsa. Anush zar tputs maacheetsi pakchiyam tarawaztarusinapa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Tsimbun matayaru zari nuwaam Apanlleemi wakaraa, misha opeeja karupana ichinguru zar muchta, muchta, shingtsa. Tuchip arangtach matayaru zar iwatspakchus, ichingurus washunand shaniyeerus, mangis kis shambatangtsa. Chinuzee muchkachus, nuwaam Apanlleemi muchingtsa. Anush zar tputs tarawaztarusinapa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Na shaniyshi 7 kachingamaam Apanll wayarangu anoo kamanchintspa. An zar watacha zurampatari nuw Apanlli siyaa tárangi anu. Zar tatsamkachu, siysa uru shaniyangtsa nuwapa ipunamaama. Yuwari nuw siyaa kamachtarangi anuri nuwaam chinuzee pachamaam uru yushindangtsa. Mishat, apanllpan katungamaam tirikoo, sebaadaa, wanusee, vinoo nuwash pangi yushindangtsa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Mishat, zar tatsamkachu anush zaree kanusamaam wayangtsa. Kanussish zar tatsamkachu, nuwash pangi maachi yushindangtsa yuw nuw siyaa yushindangtsa tárangi anuritamta. Mishat, tputs aranginasha yushindamaam zandku, waani wanusee yushindachiya, Apanll tárangiya Móysiseetsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Mishat, Apanll Móysiseetsi tárangitamta. Tirikureetsis kaneesich kayan pusaramchus, tsup nuevish, zar kinsish, anush zar tatsamkachu, tambtayarus, 7 zar nuwaam shambatangtsa. Anushsha mangis kis nuwaa ungirtatssa. Zar shambatshisheem chtakchus, pakchiyam tarawaztarintspa. Zar shambatshishi itupshingaramchus, anshutam tarawaztarintstampa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Zar ichtaru yakchu anush ichinguru tputs wanusee kizpur wanasiri yachinllinpa. Yarinpat tambtangtsa. Mashar tuwapimashpat wanasiritam tambtamaama. Tambtayarus, tsimbun zar matayaru tamburishis tángtsa. Mishat, kis shaniykus, nuwaa Apanlleetsi ungirtangtsa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ichinguru masach tsup sietish ichingurus siy nuwaa Apanlleetsi wanasirimshiri shambatangtsa tsimbun matayaru zari. Yuwaa nuw zaree wayarangi anoo siysa ipareetsis kamaningtsa urutamari payumaama. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ashiri siy Israelchichis nllurtarangis anis, siyaa nuw atashina; Masharpa tambtayarus, zar 7 ichingurus anshuri taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Siyachich nlluranur zapshitaa anoo chinachinllinpa yuwaa nuw Ijiptosh tsap siyaa tashitungarangi anoo nda mbizamaama. Anpur siy tambtayarus, taar ashirangis anootsi. Ashirucha, anoo mbiztapa aturi, na nuw Apanlli masharpa taamaam kamachtarangina, tárangiya Apanlli Móysiseetsi. ");
INSERT INTO cbuNT_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ashiri Móysissha anoo ichinguru Israelchichee tputs kamanirangiya Apanllee kuku. Yuwaa waana Apanll Taarashipan zaree kanusissheem wayarangu anootsi, yuwash tsimbun matayaru shambatshish tatsamkachu anshu. Ashiriya, na kamaneena yuwaa Apanll shambatshisheem ichinguru wayangtsa tárangu anootsi. Ashiriya, nuw Móysisi: wapparee, atina siyaatsi. Na kamaneena yuwaa Apanll kamachtarangu anootsi.");
INSERT INTO cbuNT_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ashiriya, Apanll Móysisaa kamachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Kamachtaku: Shiyshat Móysisaa, Aaronaa wipaptar ashpari kamaningcha; Israelchicheem tputsee nuwaam mashkus, wanasiriri tsiyatangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Apanll siyaa kapung chinaku, wizpurireemani panaku, ksutkiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Apanll siyaa ksapa napkiya. Mishat, waanaatsi wanasirimshirini siyaam tuyamandaktamta. ");
INSERT INTO cbuNT_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Apanll siyaa chinampatari napku, tapachindakiya. Siyaam mapiymash panachiya. tángtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Amb nuwamun suri Israelchicheem tsiyatkusin, ántangat ashchinllinpa. Amb tákchusin, nuwsha anshucheem tputs kapung istachima, tárangiya. Ashiriya, na kamaneena yuwaa Apanll Móysisash tsiyatssee kamachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Anpur zar Apanlleem pang' shaniyamaam pangumaam iwaparangusin, anushsha msas pantsatarangu pangusee yambutarangiya. Pangusush tapeerangu, msas sumas ashiru tuwasineerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ambiri ashishtar ashku, ichingaru zar taarangiya. Kaschiritam Apanllish pang' msaspa yambutarangiya. Itaru, psaanamari msas pangusish yambutarangu, sumas tamapari ashiru 'sineerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ashiramchu, waana Apanll Israelchichee kamachtarangiya msas ashiru anoo tachitamaama. Msassha káriritaraa ashku, Israelchichsha tputs ambitam tachitaranganaya. Itaru, yuwash msas zanaykamchu anshutam tputsshitisin tachitarusin tambtata, tambtata shitan ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Yuwash msas káriritaraa ashkachu anush maachiritaa, watambureetstam tapureersin, yapitam msas naaku ambitam tachitaranaya; itaru, yuwash msas yusur karuwataraa ashkachu anush watambureem wayaturtataa ashtaranaya. Msas pangusimun wanupish iwaz karuwataraa ashkamchu, uwshtisin tambtayamach ashtaritamanaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Msas anshurisha taaratarawu Apanllush pang' zapantaa zar tushiyrangu, ashtaa Israelchichsha anshuri msaseem kutataranaya. Amb ashirangsin, Apanllee kamachtamarini izuuru payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Itaru, msas mikeeru káriritaraa ashkachu, uwshtisin anshuritam tachitaranaya. Yuwash yusur msas karuwkamchu, anshurtatam kutaranaya. Amb ashiru, Apanll tputsee msasish tachitamaam kamachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ashpatam msas psaanamari karuwtariya. Itaru, kaschirsha msas yusur yuwarsha kárim ashtariya. Ashiriya uwshtisin Israelchich minamari psaanamaritam kanusaranganaya. Sheeru, puturisha msas yuwar káriritaraa ashkachu, anacha yusur ngootsip naamaam chiyzartatataraa ashtaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Wandaya msas anshuri taaratarawu, tsimbuna zar, nduntaatiya ashiru minum tsup, nduntaatiya ashiru minum masach nda musá yuwar kárku, uwshtisin Israelchich anshuritam taar ashtaranaya. Anshuri shanee ashtaranaya. Itaru, msas yuwarsha káriritaraa ashkachu, uwshtisin ambitam tachitaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Watam Apanll waana kamachtaku: Nee kutangandama, tákchu, uwshtisin anuritam anshuri kutataranawa. Wandaya naangints, tákchiya; uwshtisin anuritam chiyzartayarusin tachitaranaya. Apanllee wamachtash ichingaru tuminuranganaya, watam Apanll Móysisaa tputsee waneengcha, táranguwa. Ashiriya, na kamaneena yuwaa Apanll wizpurirnee zanganirangu, msas sumas tamapari ashiru tputsee imachirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Israelchich tputs Sinaymand mach káyarandsin, tuchip zar naayintarashin ashkusin, Apanllee kajonarini yamazarsin kukutssin ashiranganaya. ¿Yapeeja taayamchich? atusin, ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Uwshtisin ngootsish naa ashkusin, msassha tputsimun iwaz zaree kámanarangiya. Ichingaru zar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Uru Apanllee wizpurirni kajon tinamaa yusur kuyarusin, naakchusin, anush Móysissha; Apaa, shiysha iyaa yamazangcha. Na iyaa machingcha. Sheerush, kundarareetsish tpachingayarush ksangi, yuwamand shiyaa natsakana anumanda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Msassha yusur karuwataraa ashirangu, kajoneetssha yusur tsapush wayaranganaya. Sheersin, Móysissha; Ashiri natunaa Apaa, ningtam kanapungcha. Israelchichee tputs urutamari ksutangcha, tárangiya. Ashiriya, na kamaneena, yuwaa Apanll yusur msasee Israelchicheem zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Minushsha zar taar ashkusin, Israelchich tputs Apanllee yuw zandkana an tsiyatkusin, Nish kusaranguni, kiyung kachiykuni taakaniya. Iyaam Apanll antaati istakeeja. Watstaya, ántangat ashirangsin, Apanllsha anoo mazinarangu, kapung tsiyantarangu, sumasee mikeeru zanganirangiya. Sumassha pantsatarangiya yuwash Israelchich ántarana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Anshuchshitisin kapung punirangusin, ¡Aay! Móysisaa, tpachindanganda, átangat ashiranganaya. Móysissha, Apanllee masharangu, Apaa, watsta. Tputsee nayaningcha. Musá waneerinllpa, tárangu, sumassha mikeeru, ztazataran ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ashirucha, anoo tsap sur Tabera atusin yásamaranganaya. Nee tsap Apanll sumaspa tiroorangu atusin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israelchichish tputs zapan minpicheewpa tputs washunand yapandayarusin taarangana. Anshitisin tputs katungtsingazimari chinaranganaya. Apanllee yutaritam ínaranganaya. ¿Chakza iyaam wanutsee taarinapaz panapanda? tárangusin, támararangusin, tanuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","¿Tamarinaareeja Ijiptosh tsap katungats zapan taarang? Ijiptosh tsap kayupchee ngutani kuwiptini putayaruni, zapan katungaranganiya. Ichingaroo katungats katungtariniya. Pipinutam, sandiyaatstam, puweerutam, sipuchatam, ajutam, aship katungkuni kis taaranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Itaru, natsha ¿tamakaniya? Marizimun yarpunishini puzatkiniya. Neetsshat katungats sur maná nda katungamaam yasaruni, tsachikaniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ansha maná kumaz wach tamatarpari ashiru psiyaruwa, yasin wash tamapari ashiritamta. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Anootssha tputs yáychusin, túshiysh tuyarusin, taxaptataranaya. Ashiramchusin, shtashishsha pshtayarusin mustaranaya. Mishat, pangaatstam tinaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Psaansha sirin kapung pantsatarangiya. Anshurtatam katungats maná pantsatarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Móysissha mazinarangiya yuwaa maachirit Israelchich kiyung kachiykusin, pangunung washitungash tanutantangat ashirangana anootsi. Apanllsha anumand kapung tsiyantarangitamta. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Móysissha Apanllee masharangiya ¿Mayaamsha Apaa, shiy nuwaa tputsireetstaatish kiyung yachaksha? ¿Shiy mayamand nuwaa amb ashimaam zandaksha, nuwaamamarisha nee tputs Israelchichee ksutamaam kasaksha? Kapung tarawaz kasarangshawa. ¿Nuwataati ashpam tputs tamaycheezee? ");
INSERT INTO cbuNT_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Antaati nuw ipareetsinawa? ¿Nuwshat pachipeeri yamapee? ¿Nlluraatscha pachipeeruch, titkurimunich wayataratachchee? ¿Tamareeja ashpa tputs yamayaruri, yap shaana zitaminaam tsapoo panarangish amb wayachee? Pinasaktana ashpa tputs ksutamaama. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Nuwangaz panapasinda atusin, tputs zapan kuskusin, Nuwaam wanuts pananda, katungpani, átanicha, átangat ashiksincha. Nuwshat ¿yapshitaja wanutsee yáyruri, Neewa, táychee? ");
INSERT INTO cbuNT_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ashiriya, nuw na zandakshitazi. Nuwaamamsha tarawaz kapung panaksha. ¿Nuwataati ashpa tputs tamayareezi ksutchee? Nuwaam mbamcha ksutamaama. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Apaa, wandaya tarawaz nuwaam arangeem panamaam zandkush, nuw zandakshitazee. Nda ashishtamaam tsipamaritana tsipachima. Tsipakchinaareena, ndusha kiyung kachiychina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Apanllsha, Ashiri, shiysha Móysisaa, tputs ashpari Israelchich yuwanandari wachin kurakaa annandari 70 tputs kuruzeerush, nuwash pangi tushaneengi. Nuwaam anush kutachindama. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nuwshat anush karuweeruri, shiyapa tsiyatchinipa. Nuwaana kani kurakaamtam panakchuri, uru shiyaam ipunshish Israelchicheem ksutamaam taachinllinaya. Ndusha shaani kiyung kachiykish ashtachsha, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Tárangu, anumunsha tputsee kamachtamaam Móysispa yusur tsiyatarangiya. Natu ashpari tputs wanasir yaramaam kamaningcha. Ashparitssin mangootstam yarchinllinpa. Sheersin, putamsha zar wanutsi katungamaam kuschinllinpa. Watam marizimun tanuntangat ashirangsin, ¿Chakza wanutsee panapasinda? Ijiptosh taarangani, anush katungats zapan kis katungaranganiya, táranganawa. Itaru, natsha nuw wanutsee katungsheemis zapan panachina. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nda natumari zar wanutsee katungatssa. Ichingaru zar putam, putam ashtatssa. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Minam tsup zurampatari katungachus, siyaatsimari wanuts kasikchu, katungamaris shipipis shitungchiya. Izuuru kaniztsimun saanaa tsungasambatssa, yuwamand nuwaa kasamaam zandkis anumandaya. Watam Ijiptosh tsap shitungarangus, nuwaa; ¿Mayaamshtaja Apanll iyaa ningeem wayarang? tárangsawa. Watam nuwaana siyaa imachkinawa, Apanll átcha, tángcha, tárangiya Móysisaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Móysissha; Zuraksha. Itaru, iyashuch tputs zapan washunand 600 mil tputs kamuzanandari taaranaya. Itaru, shiyshat iyaa tárangsha; Nuw siyaam wanuts katungsheemis zapan panachintspa. Ichingaru zar, ichingaritam tsup katungatssa, tárangsha. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Itaru, ¿yapsha chinuz opeeja, wakara zapan taara? Musash kapungumashish kayupich zapantaatiya kawakchurini, ashiritaa wandari pishtachtamparee. ¿Tamareeja ashpamich tputseets tatsamooch? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Itaru, Apanllsha; ¿Antaatiya nuw tputseezi nda uru ashtachina? K'keetsi tatsamchima. Na napangandama; ¿tamapari yuw táyanlli anoo nda nuw tatsamchina? Apanll tárangiya. Ashiriya na kamaneena yuwaa Apanll, Wanutsee panachintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Móysissha Israelchichee kamanirangiya yuwaa Apanll tsiyatarangu anootsi. Ashpari wachinaa kamanirangiya. Uwshtisin ashpari Israelchich wachinanandari 70 kusatarangsin, shaniyshishish pangus kutaksin, shaniy ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Apanllsha anush msasish karuwataraa ashirangu, Móysispa tsiyatarangiya. Waanaa wizpuree Móysisaam panarangu, anoo anchichtam tputseem 70 kurakaam panarangiya. Sheeru, tputsee tutsiyatstayaru, tputssha apanllpan tamaparee ashirusin Apanllee kuk natumasamaam kaman kaman ashiranganaya. Anumunarisha, arang Apanll ndushat anumashee k'kuzee tsiyatamaam tutsiyatstarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mishat, Móysis 70 kurakaa ipusarangitaa, itaru anchich kurak tsimbunatam nda shaniyshiship kusaranganaya. Anshitisin tputs suru Eldad, Medad ashirusin waanshutari pang' taar ashiranganaya. Ashirangtaatssin, anoom Apanllsha wizpuri anush tputs tapshturangitamta. Ashirucha, apanllpan tamapari ashiritamsin kizpuritam wanasir pangush tsiyataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ashiriya, nllursha anoo mazinarangu, Móysisap kamaniti átu iripurangiya. Anush kuseeru, Móysisaa kamanku; Eldad, misha Medad ashirusin mangu apanllpan tputs tamapari ashiritamsin wanasir pangush Apanllee kuk tsiyateenllinpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Anpur Josuey, Nomarini wip, kanungasimuna Móysisaam istampaneem taarangiya, Anshat; Ichee, Móysisaa, shiyshat watsta tángi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Itaru Móysissha; Josueyaa, ¿Mayaamsha shiy nuwaa pachindaksha? Waani Israelchich tputs ashparitssin Apanllee wizpur payuptamsina atina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Móysis, mishat wachinanur ichingaru kurakawtam Israelchich tputs pangpeewaritam kanapuranganaya. Ashiriya na kamaneena yuwaa Apanll waana wanee Israelchicheem wachinanur ichingaroom zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Apanllsha kambusurush marshuchee katamish zanganirangiya. Kambusursha kizpur kambustarangu zamzee tpurangayaru, yapsha tputs taarana ambshat katamish marshuch pantsatarangiya. Anshat katamish marshuch zapan pantsatarangu, ashchiri shuneeru yuwash taarana anush tatsitarangiya. Tputssha naparangsin, minum zar wazuran naakich anush ashchiri zamiz tatsitarangu, minumtam metor pakchimsha pshataru íwaririni tamusinlleerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Tputsshitisin, marshuchee katamish parangusin, anuritam zar, psaanpatari, ichingaru zar pacharanganaya. Sheersin, zapan xanataranganaya. Tputs minumtiyam nda pakich xanatarangana. Itaru ichingarusin tputs zapaniri tsimbunaa tunelat yanuru xanataranganaya. Sheersin, zareetssha mapzapani atusin, taarshishuri maputaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ashiri tputs wanutsee mangu zapan xanatarangsin, nda katungkusin mangutarishtisin itsaniranganaya. Wanutsee kanizirangsin, tsacheerpashtisin katungaranganaya. Anumandsha Apanllsha kizpur tsiyantarangu, tputsee waneerangu, zapan tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ashirucha, anoo tsap sur Kibrot-Hatawa, atusin yásamaranganaya. Nishuri tsap tputsee katungtsingazimari chinakana anumand Apanllsha waneeyanlliya, atusin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Tsap Kibrot-Hatawamand, shitungeerandsin Jaserotapsha tsap kuseersin, anshurisha taaranganaya. Ashiriya, na kamaneena yuwaa Apanll marshuchee katamish kambusurush zapan zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Móysisarinshitini Ijiptoshchee kiz wizanlleem yamarangiya. Ashirucha, anumand wizarsha Mariy, zoonlltam Aaron Móysisaa kapung tsiyantayarusin, yuw zandkana an mantsir tsiyataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","¿Antaati Apanllee Móysisaatsimtaja chinarangu tsiyatarang? Nda. Apanll iyapa tsiyatamaam taaritamcha, tárangusin, Apanllsha yuwaa aship mantsir tsiyatarangana anoo mazinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Itaru, kaapa Móysisamari kizpur wanasir taarangiya. ¿Chakaja waapa wanasirimshirini tatsamooch? Minumtiyam tsapurnasshuch ashim tputs ndunarimuna. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ashirucha, Apanllsha anumand kapung tsiyantarangu, Móysisaa, Aaronaatstam, mishat Mariyaatstam; Natu mikeerus Apanllish pang' shaniyshishush pshtungints tárangu, uwshtisin anuritam pshturanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ashiri Apanllsha msasish karuwarangu, msas tuwap pangusimun pantsatarangiya, Anush Aaronaatssha, Mariypatari kuruzurangiya. Mariysha wayuchpatari tsimbunartisin pshturanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Apanllsha, Nuwaa kuki mazinangtsa yuwaa tsiyatki anootsi. Nuw apanllpanpat urkar, mishat siyaptatam yuwashumari nuwaa pamaskachis anshumari tsiyataksa. Mirnishumari anpat tputs nuw tsiyatkina. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Itaru, nuwaanpatasha tputsiri Móysispat nda amb ashiru tsiyatkina. Anumari tputsiri Móysisamari kizpurcha wanasiriya. Nuwaa kapung chinakiya, Mishat, waamari kizpur taakiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Anpatamari tputsiripti kchiptarti pambeeruni, wanasiritaatsiri, tsiyatkiniya. Uwshat nuwaa Apanlleetsi kcheetsiriti pamari pakeeru tsiyatkiya. Ashiri, ¿mayaamsha siysat anoo kasiyarus, yuwshat zandkis ansha Móysisee tputsireetsi mantsir tsiyataksa? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Apanll Aaronaa mishat Mariyaatstam kapung tsiyantayaru, yusur wapitam kárirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Msassha pangusee yuwar wanllitatara ashkachu, Mariysha ashchiri tasirini mzapintayaru, tuchingarangu, wanuts ashchiri mbursheemsha kinarangiya. Wayuchsha Aaron wizar amb ashirangu anoo paranllu, kapung punirangiya, watam tsutashish tutungamash tsutaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ashirucha, puniku Móysisaatssha; Móysisaa istanganda. Yaanamandari yutaritshishirini miroosinlltakpaz ashiranguni, anumand Apanllsha iyaa waneerangiya, ");
INSERT INTO cbuNT_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","¿Tamaree kaapana ambinaa nutsich ashiru taachich? Yutaritcha. Nllur nllurtakachuri tamatarpari ashiru tas tuchingarangiya, zoonllee Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Móysissha Apanllee masharangiya; Apaa, mazinancha; shiyaa mashkina. Shiynaa naturi izareetsi yarangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Apanllsha; Uru tputs wipaa natsaku, wachush kawachkachu, nllursha kapung paziku, arangiri xitat ashku 7 zar pazir tsipachu, yusur kustariya. Ashiri nuwsha ambitampaz ashkuri ashtachima. Natumasamaam 7 zar paziku chapung suwachiya. Waani ambiri taar ashku, minum tuming tushiyramchu, yusur kuschiya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ashirucha, Móysis wizaree, zanganirangu, Mariysha paziku waani upusap naatarangiya. Ambirisha taar ashku, minum tuming tushiyrangiya. Anshuchshitisin tputs nduntam arang naaksin, anootsirisha kutaksin, Mariy kuseemasa atusin, shanee ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Mariy 7 zar maayashinu, kusaramach ashirangiya. Tputs ichingarusin Jaserotamand tsap káyarandsin, apusapsha tsap Paránapsha kuseersin taaranganaya. Ashiriya, na kamaneena yuwaa Apanll Mariya waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","2","Apanllsha Móysisaa kamachtarangiya: Móysisaa, shiyshat tputsireetsish Kanaanap tsap naramaam zanganingcha, watam nuw anoo tsap Israelchicheem watsapun kasaranginawa. Ashiri waani tsapoom naramaam naachinllinpa. Siyaam, Israelchicheemis anoo tsap panachintspa. Móysisaa, tputsireetsish ipuseerush, minchich kurak, minchich kurak sheerush, yuwanandari kurak tiptsiree ksutataranllina annandari zanganingcha, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Móysissha yuwartatam Apanll kamachtaku tárayaru anuritam chinarangu, tiptsiree, Israelchichee ipuseeru minchich kurak, minchich kurak sheeru, Paránamand tsap zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Naatarangsin, 12 tputs kurakanandari tsapoo Kanaanaa narkatssin, 40 zar ambiri maarshinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Sheerandsin, waptam taarshiptam kanapeerandsin, yuwash Móysis zoonllpa Aaronpa, mishat Israelchichtam tputs zapan taarana anshutam kusaranganaya Paránash tsapu. Yuwashtam kungoo sur Kadesa, parangana anshutamta. Ashparitssin kurak yuwaa pakeeshinana anoo kamaniranganaya. Wanuseetstam anush tsap yáyashinana anootstam yámandarangusin, ");
INSERT INTO cbuNT_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","watacha ambich tsap yáyashinini anu tárangusin, Móysisaatstam; Shiy iyaa zanganirangush, iyshat amb tsap naataranguni, maachi zapan katungtsitam taariya. Wakaratam mimir, kinduratam kung ashiru naantangatu paranginiya. Antaati ngichkeezinee. Zurampatari amb tsap maachi zapancha katungats taaru pakeeshinini. Na Napanlla, watacha ambich tsap maachi wanusiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Itaru, Kanaanshuchshitisin tputs kizpurinandari taaranaya. Yaktarinshitini kapungtamta. Waanaatsi watsapun wanasir patumbichpa ashchiri yakat kámanarsin taaranaya. Mishat, Anakarinchicheetstam tputs anush taarusin paranginiya. Uwshtisin wanuts kapungu wazuraneew taaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekshuchsha tputs zapanitam washunand yapatarsin, Neguebshuchpat, Hititshuchtam, Jebusewshuchtam, Amorrewshuchtam machip tsap taakana antamsin, Kanaanshuchtam mus kapungumashinung arangeem watandaram ksutkusin taakana. Antamsin taaranaya. Ortagumuntam wing Kanaanshuchtam tputs taaranaya, tárangusin, kapung punirangusin, punirpat Móysisaa kamankusin, zamamtangat ashiranganaya. Itaru Móysissha mangu mazinazinaw ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Tpuntaksin tárangitaatssin, Kalebamarisha yuwaa tputs Móysisaa zamamtarana anoo tsiyatku tárangiya. Waapa zamangints. Pzaya. Ashtaa pshtuyaruni, pachayani. Sheeruni, watsapunee itutseeni. ¿Mayaamshitaja mangutich punikuch zamamtangat ashtachich? watam Apanll iyaa ksutaruwa. ¿Tamareeja nda kasichich? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kaleb tárangitaa, ashiritaa wipunashtisin yuwapa tsapoo nareeshinana anshitisin; Nduni. ¿Tamaree chiy anshuchee tputs kasichich? Anshuch tputs kizpureewsincha. Iyashuchpa tputs waritarazinllinaja, ");
INSERT INTO cbuNT_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","tárangusin, tputs ichingarusin yuw tsapoo pakeeshinana anin mangutarishtisin zapan ngicheersin Israelchichee tputs tpuxtapani, atusin, Anshuch tputs kizpureewsincha. Anush tsap kuseeruni, napkuni, tputs mang yutaritanand paranginiya. Waanpatatin kis pachakanaya. Anshuch tputs wanuts kapungunandari taaranaya. ¿Antaati nuw ashcheewa tputs patareezi? ");
INSERT INTO cbuNT_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wamaritssin iyashchee tputs wanuts kasiksirnaya. Anakarinchicheetstam tputs anush parangitamaniya. Iyshat anush kusaranguni, annung watsiri káyamaranguni, iyapa nutsini táchkuni, iyshat ashcheewshitini pchichini pakcheewshitiniya. Ashirucha, uwshtisin iyaa nutsini pakcheewatsini kis naparanganaya, puniksin táranganaya. Ashiriya, na kamaneena yuwaa Móysisi tiptsir Kanaanap tsap nareeshinusin, Móysisaatssha kamanirangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Anuritam psaan, Israelchichshitisin ichingarusin tputs kapung punirangusin, tanuksin zamangaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ashirangsin, yuwshat zandkana anshat Móysisaa, Aaronaatstam mantsirsha ichingarusin tputs tsiyataranganaya. ¿Tamashtaja nda Ijiptoshuri tsap tsiparangini? Ambiritanaari tsiparanguni, ashireeja ningsha apusapsha tsap kiyung kachiyeeruch tsipachich, tárangusin, ");
INSERT INTO cbuNT_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Apanlleetssha, ¿Mayaamshitaja Apanll iyaa ningeemsha tsap apusapsha wayarang? Waani ningiri tsap tsipambanllina. Undarar waratkatssin, k'chirpungpa pachapana. Ashkatssin, waani yachanllina. Wizanlleewaatstam, mishat wipaatstam waani putambanchina atuparee, iyaa ningeem yushindarangiya. Nda ashishtamaam, pzaa, wapitam Ijiptop kanapunda átpari, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Tárangusin, waanpatatshitisin tsiyatarangsin, ¿Tamanda áta? ¿Ndushat chaama kurakarich minum tputs ipuseeruch ínanda át? ambinaapa sheeruch, uwshat chiyaa yusur Ijiptoptam tsap maachchiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ashirucha, Móysissha zoonllpa Aaronpa, kapung mang' mantsarangusin, tputsee tasaseersin, tsapush tutunlltayarusin, timuchta ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Anumunsha, Josueysha Nomarini wip, mishat Kaleb, Jefonarini wip ashirusin anshutam shanee ashiranganaya. Anshitisin, tsapoo nararangtamsinaya. Ashirucha, tputs zapan ngatarangana anoo parangusin, uwshtisin kapung mang' mantsarangusin, waanaatsi wamar putayarusin, izichiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Sheersin, uwshtisin Israelchichee tputs tsiyataranganaya; ¿Mayaamshitaja watsta táchich? watam iy naataranguni, tsap kizpur wanasir paranginiwa. ¿Tamareeja ashimaa chiyshat watsitpari táchich? ");
INSERT INTO cbuNT_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","watam Apanll iyaa kapung chinaku wanasir ksutkuwa. Uru amb naakchuch, chiyaam kapung istachiya. Apanllsha iyaam anoo tsap wanasiree, maachi zapan katungats, mishat wakaratam mimir, kinduratam zapan taaru anoo chiyaamsha tsapuneemaritich panachiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Itaru, siysat mangutis tsiyantayarus, Apanll kamachtarangu anoo watsitparee, tárintspa. Mishat, ambchee tputs yaktashchee punirintspa. ¿Mayaamaja punichich? watam nda waritachinllinawa. Chiyamariparee pangaa katungtarich sheeruch kachingachchee. ¿Chakaja anshucheem tputs tapachindaku tapachindach? watam iyaatsina Apanll waana ksutaruwa. Ashiriya, iynaa Apanllirini taaru ¿mayaamshitaja punichich? tárangana. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Tputsshitisin anumand kapung tsiyantayarusin, ¿Mayaamsha amb atanaya? Pzaa, pachayaruni kasayani, tárangusin, patumbchee ashparitssin tputs yátartaranganaya. Yuwari sheechinllina anuritam Apanllsha, waanaatsi wizpur wanshu pang' Israelchichish shaniyshini tuyamandarangu kizpur 'sineerangiya, yuwash Israelshuch shaneerana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Apanllsha Móysisee, ¿Ashinshtaja nishuch tputs yuw nuwaa niyrkana anin yusur nuwash tachiteechinllina? Mishat, ¿ashinshitaja nuwaa kuki zurkupari Apanll atiya, atusin nuwamun mang' tateechinllina? Yuwaa kamachtaki anoo nda payukanawa. Nuwaanaatsi wanasirimshiri tuyamandaktaati, anoo nda yasakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ashiriya, yuwamand ashkana anumand nuwshat tsutashish tsipatsimash zanganchima. Ashkachinaareena, ayamtaati Kanaanash tsap nda kuschinllinaya. Itaru, Móysisee, shiyaamamari kapung istachinllpa. Chinllineemaritish watsapun kizpur wanasiree yachinllinaya. Ashkatssin, waamaritin Israelchich kizpur taachinllinaya. Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Itaru, Móysissha; Apaa, mangishish kaapa chinangcha, ¿watam shaana wizpurirpatish tputsireetsish Ijiptosh tsap tashitungarangshawa? Waanari tputsireetsish waneekchush, uru anoo Ijiptoshuchsha mazinakchusin, ");
INSERT INTO cbuNT_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","waanpatatshitisin kaman, kaman ashkatssin, Kanaanshucheetstam tputs kamanchinllinaya. Watam shiy tputsireetsish kapung chinarangush, msasish tsapush karuwarangush, iyshat shiyaa kchiptaritani paranginiwa. Shaana iyaa imachirangush, ichingaru zar msas pantsatarangiya; kaschiritam, psaantam sumas ashiru kizpur 'sineerangiya. Ashiri amb ashirangush, ¿mayaamsha natsha shaantatam tputsee tpachingamaam zandaksha? ");
INSERT INTO cbuNT_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Itaru waanari shiy tputsireetsish shaantatam izuuru tpachingakchush, Kanaánshuchshapsinaya anoo mazinakchusin, waanpatatshitisin tsiyatkusin, ");
INSERT INTO cbuNT_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Apanlltaa ¿tamayanlla tiptsireetsi? Iyaa tsapunni Kanaanaa itutseeruri, siyaamsha Israelshucheemis panachintspa, tárangitaa, ndusha waritarangu, tiptsireetsimsha na izuuru apusap tsap tpachingayaru kasayanllu, táchpasinaya shiyaatsiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ashiriya, Apaa, watsta. Tsiyaneetsish mbizangcha. Kapung tsiyantarinllpa, watam, Siyaam nuwaanpataa wizpuriri istachintspa, shaana tárangshawa ");
INSERT INTO cbuNT_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Mishat, Apaa, watam shiy nuw musá tsiyantama yasareezi, Tputsireetsi kapung chinakina. Tputs yutaritaatstaa nuwaa kuki nda payukana anootstaa, nuw kapung chinakuri yutaritshishirineetsi tachingina, tárangshawa, Apaa. Itaru, yuwaatsimari tputs shiyaa kukish kapeetarangsin, mantsirimash chinarangana anootsimari urutamari waneekush taachsha. Waparimand yutaritshishirini wipaatstam, wachinllinootstam, wachinllinootstam wip urutamari waniwantarush taachsha. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ashiri Apaa, shiyamari, kchinamishtishcha. Nuw shiyaa mashkina. Natu mikeerush tputsee yutaritshshirini mbizangcha. Sirú tputsireetsish Ijiptosh tsap tashitungayashinush, yutaritshishirineetsi tachingarangush, ningsha yushindarangsha. Natsha ambitam shingcha. Móysis Apanllee tárangiya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee wanimaam zandarangtaa, Móysissha Apanllee waneerinllpa tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Apanllsha zuraktishcha. Yuwaa átish anoo mazinakina. Ashiri nuwsha tputsee yutaritshishirini tachingchima. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Itaru yuwaatsimari nuwaa kuki kapeetarangana anootsimari wanimaam waritaktana. Ashiriya, anin tputs nda ayamtaati yuwash nuw Kanaana tsap wanasirimshee ipusarangi anush nda taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Nuwaa wizpuriri wanasirimshee parangitaatssin, ashiritaa nda nuwaa kuki payurangusin, izuuru ngataranganaya. Wanipaja nuw kamachtakuri xapoorangi; Ijiptoshtam tsap, apuspitam tsap yap naatarangana anshutam xapoorangitamna. Zapancha sheenllina. Antaati nuwaa kuki payukazinllinaja. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ashiriya, nuw sirútama zitaminarneetsi, uru nuw siyachcheem chinllinis nee tsap Kanaana panachintspa tárangitaateena, ashiritaa natsha yuwamand nuwaa kuki kapeetarangana anumand ayamtaatiya anchich tputs minumtiyam nda Kanaanash tsap taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Itaru, minumari nuw tputsiri, Kalebamari nuwaa kuki payurangiya. Izuuru zurampatari nuwaa k'keetsi tatsamoorangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Itaru, siysa yap Amalekshuch, Kanaanshuchtam tándsamun taakana amb naarintspa. Nimandari pu zar wapitam kanapeerus, apusap tsap naangints, yap mus Chumbeepimash taaru ambi, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Móysisaa, Aaronpatari wanasir tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Wanipaja nuw k'kuzee mantsirimshee mazinayanlli yuwaa Israelshuch nuwaa yutaritam ínaksin, mantsirimash tsiyatkana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ashiriya, shiyshat nuwaa kuki tputsee kamaningcha, Apanll shiyaa ateeja; Nuw Apanlltana; uru zurampatari k'keetsi tatsamchima yuwaa ashtachi anootsi. Watam nuw siyaa kukis mazinaranginawa. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Na ichingaru tputsee sur yandayaana, veintimandari masachirini yaru arang wachinawa annandari uru apusap tsap tsipachinllinaya, nuwaa mantsir tsiyatarangana anumandaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ayamtaatiya, siyachich tputs nda minumtiyam, yap nuw tputsiri Kaleb, Josueypa taachinllina amb nda kuschinllinaya. Tsapoo nuw yap wanasiree zurampatari panachintspa tárangi ambiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Itaru, iparimarishtis yap siy kundarareetsis punikus, tsapoo wanasireetstaa ngatarangis amb, uwshtisin pshtuyarusin, undararee kachingeersin, watsapuneemarisha Kanaana tsap yachinllinaya. Maacheetsi aranginasha wanusee pzapanichinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Siynaa machip apusap tsipakchus, ambiri napuris tamutamtachiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ashkachus, iparshitis chinuzpan tputs tamatarpari ashirusin mangutari masarsin, apusap tsap xitangat ashkusin, 40 masach taachinllinaya. Ashkusin, siyamand wachinamandis yutaritshishiris kiyung kachiykusin taachinllinaya. Saantana wachinis tsiparamchus, anumun iwaz ashchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Watam siy tsapoom narkatus, 40 zar maarshinsawa. Anumandtam nuwshat 40 masach wayachima, siyamand yutaritshishiris tuwapamaama. Minumta zar, nuwshat minumtamsha masach wayachima. Amb sheeruri, kasachima yuwamand nuwaa yutaritam ínarangis anumanda. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nuw Apanlli uru k'keetsi zurampatari tatsamchina. Uru nuw yutaritshishimand waneeyaruri kasachima, yuwamand nuwaa ichingarusin tputs mantsirimash tsiyatarangana anumanda. Ambiri apusap tsap waani tsipachinllinaya, átcha Apanlli, tángcha, Móysisaa tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Anumunshat, Móysis tiptsiree Kanaanaa tsap naramaam zanganirangu, uwshtisin kanapeeshinusin, ngicheeshtisin kamaniranganaya. Ashirucha, amb tárangusin, ichingashtisin tputs zapan mantsir tsiyatarangayana. Apanllsha anumand ashpartaa waneerangu, tputs 10 tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Tsimbunandamsha tsapoo naramapan, Josuey, Kaleb ashirusin nda tsiparanganaya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Móysissha tputsee ashpari Israelchichee yuwaa Apanll táyaru anoo kamanirangu, uwshtisin anoo mazinarangusin, ashparitssin kapung mang' mantsaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Putamsha zar puturi káyarandsin, machipsha tsap káreerandsin, naataranganaya. Ambsha tsap kuseeramchusin, waanpatatshitisin, Natunaa nish machish tsap kuseeniya. Pzaa ashtaa arangsha tsap naayani yapsha Apanll iyaam tsapoo panachintspa tárangu ambi. Watam yaanaatsi zurampatari tayutaritaranganiwa, waanpatatin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Itaru, Móysissha; ¿Mayaamsha Apanllee kamachtamarini yusur kapeetaksa? Amb ashkus, saanaatsi aranginasha yusur tayutaritaksa. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Watsta arang naarintspa, watam Apanll siyaa izuuru kasamawa. ¿Chakaja siyaam istayach? Uru naakchus, siyaatsimari kundararis kachingchiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Watam na siyangaz amb Amalekshuch, Kanaanshuchtam pachapani atusin tsangakanawa. Itaru, siysat Apanllee niyrarangus, Apanllsha na siyaa izuuru kasama. Ndushat siyaam ksutkiya. Ashiri ¿na chakshitaja siyaam istayach? Móysis tárangitaa, ");
INSERT INTO cbuNT_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ashiritaa chawap nda mazinarangusin, aranginasha machip tsap káreerandsin, arang naataranganaya. Itaru, amb ashirangsin, uwinandari xunarsin, Apanllshari kajonarini naataranganaya; Móysisayam nda amb tachitarangiya; anshuri taarataraw ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ashirucha, Amalekshuchshitisin, Kanaanshuchtam yuw amb taakana anin, Israelchichingaz tachitarangsin, machish tsap sur Hormash kamateersin, ashpari kachingeersin, kasaranganaya. Ashiriya, na kamaneena yuwaa Kanaanshuch tputs Israelchichee Hormash tsap kachingarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Yuwashuri masach kaneeschiri yáyaru, tsup minumari kaneesich yáyaru, anshuri Israelchich tputs apusapsha Sinash kusaranganaya. Anshurisha tsap sur Kadesash zapan zar taaranganaya. Móysissha wizar Mariyarini tsiparangu, anshuritam tsap mapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Tputsshitisin kungungaz naxpoorangusin, shaniyeeshtisin Móysisaatssha, Aaronaatstam nambkusin, ");
INSERT INTO cbuNT_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Móysisaa táranganaya. ¿Tamashta nda yuwapururi Apanll iyashchee Israelchichee tpachingarangu, nda anpuritam iyaatsshat tpachingarangitam? ");
INSERT INTO cbuNT_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ashiriya, siy ¿mayaamsha iyaa Apanllipsha watsapun apusapsha yushindarangsa? Waani ningiri tsipakchusin, wakararinpatari pchinganchina atupsa, ashirangsa. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Iy Ijiptosh tsap ksataa taaranguni, ¿mayaamsha siysat iyaa tashitungayarus, ningeemsha tsap yutaritapsha yushindarangsa? ¿Ashimashtaati tsap tamari maacheetsi tatsumchich? Nish, ¡maachtaw wanus kpayunlleew, kizarunawtam, munllinawtam wanindaja; kungutaa waamaam ndunari! táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Móysissha zoonllpa Aaronpa ipuneerandsin, waanitarishtisin Apanllish pang' pshtuyarusin, wanasirimshinung washitungash tutunlltayarusin, tsapush timucheeranganaya. Apanllsha anuritam wizpuree wanasirimshee tuyamandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Apanll Móysisaa; ");
INSERT INTO cbuNT_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Natu tushuwshish yángi. Zuwanllshitish Aaron shiyaam istachpa. Ashiri Aaron tputsee ichingaru tushanichpa. Tushaneeramchus, shiyshat tputs ashpari parsin, patumbchee tsiyatangcha, Natu kungoo, patumbchish shtungangi, tángcha, tákchush kungsha kapung zaw ashtachiya. Ashkachus, tputsshitisin ichingarusin kungoo waachinllinaya; chinutam wakaratam waachtamsinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Móysissha yuwartatam Apanll kamachtaku anuritam tumineeru, Apanllish pang' tushuwshineetsi yarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Móysis zoonllpa Aaronpat ipuneersin, tputsee ashpari kuruzeeru, patumbchinung tushaneeyaru, Kitsis mazinangtsa; yuwis nda k'kuzee payumpanis anis: ¿Tamaree patumbchish kungoo yáyaruri, siyaam waamaam panachini? ");
INSERT INTO cbuNT_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","tárangu, Móysis kapung tsiyantayaru, tushuwshineetsi yat sheeru, patumbchee tsimbun kayungarangu, kungsha anuritam kapung zaw ashirangiya. Ashirucha, tputsshitisin anuritam kungoo waarangusin, chinoomtam wakaraam yasiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Itaru, Apanllsha Móysisaa, Aaronaatstam; Siysat nda nuwamun mangis taturangus, yuwaa kamachtanlli anoo kapeetarangsa. Nuw, siyaa k'kiptamaritis patumbchee tsiyatangtsa, táranginawa. Itaru, siysat tsiyantayarus, patumbchee tushuwshishpasha kayungambayasa. Amb ashirangus, mantsir Israelchicheem tuyamandarangsa. Ashiriya, yuwamand ashirangis anumand Kanaanap tsap nda tputsiriptish naatssa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Anootssha kungoo sur Meriba yásamaranganaya. Israelchich Apanllee zapan tamundarangusin, Apanllsha waana wizpuree tuyamandarangu ancha. Ashiriya, na kamaneena yuwaa Apanll Israelchicheem kungoo panarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Móysis Kadesamand tsap taaru, tiptsirish tsiyatssee kamachtayaru, kurakaam Edomshucheem zanganirangiya. Kurakaa pakchush, kamankush tángcha; Shaana maachiritish Israelchich, shiyaa táranlleeja. Shiy iyaa yasaktishcha yuwaa iy kapung kiyung kachiyrangini anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Watam iyashuch zitaminarni Ijiptop tsap naatarangsin, ambiri zapan masach taarangsin, itaru Ijiptoshuchshitisin tputs iyashchee zitaminarni nda wanasir chinarangusin, kapung natsataranaya. Iyaatssha ashirangtamsinaya. Iyaa kiyung yacharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Iy tanuranguni, Apanllpa kapung masharanganiya. Apanllsha iyaa k'keetsini mazinarangu, waanaatsi tiptsir iyaam Ijiptosh tsap tashitungamaam zanganirangiya. Natsha nish kusaranguni, shiyapat tsapunish tasasaru yakat Kadesash taariniya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ashiri na shiyaa mashkina. Shiyshat ¿amkimsha iyaam naamaam kamiran tsapuneetsish arachich kitkachinipa? Itaru, mzatseewaatssina pakchuni, maachtawa tatsumareetsis kizarunawa muntacheezini. Uru piyamari imarchiniya. Kungureetstaatis posoreetsis nda pakchiyam patatchiniya. Ngootsshuri naachiniya. Ngootsshuri wazingari naakchuni, siyaa tsapunis tushiyanlluni, annaapari ambirisha kuseeruni taachiniya, átcha, tángcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Itaru, Edomshuchsha kurak uwshat; Nda, anoom zandareezi. Nuwash nungi tsapunshi naarintspa. Ashiri misangayarus nuwaa kuki kapeeteerus, naakchus, urutanda nuwsha sundarurpati shitungeechuni, siyaa uru pachachiniya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israelchichsha tputs; Nduni kurakaa. Uru naakchuni, ngootsish itsinsariparee naachiniya. Wandtaati siyash posorishish kungureetsish waakchurini, mishat wakarareemtamani yáskachtaateeniya, uru yuwamand siyaa kunguris waayarini anumand kurik tuwapachiniya. Tsapunshimaritis nungishimaritis naachinipa. Naayaruni, Arang kitchinipa, atutanicha, shiyaa anoomam mashkashiniya, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","itaru, kuraksha Edomshuch; Nduni, watsta, siyaa atina. Antaati nuwash tsapuni naamaam wanindaja, tárangu, Israelchichsha mazinarangusin, Edomshuch kurak watsapunee pachindku, wasundureetssha kamachtarangiya. Sundarsha anshuch kizpurinanda ichingaru chiyzamaam zandaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ashirucha, wapitam kanapeersin, yusur Israelchich piyamsha minup ngoots nachungaranganaya. Ashiriya, na kamaneena yuwaa Edomshuch kurak watsapunee pachindarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ashiriya, Israelchich ichingarusin tsap Kadesash taarangana anoo shitungeerandsin, minupsha tsap sur Horapsha naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Anushsha taaranganaya. Edompeemtam tsapu, anushsha taar ashkusin, Apanll Móysisaa zoonllpatari Aaronpa tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Zuwanllish Aaron musáshapari tsipachiya. Yap nuw Israelchicheem tsap panachi amb nda naachiya, watam yuwash kung wir taarangu, sur Meriba ísamarangis, anush tsap nuwaa kuki kapeetarangsa. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ashiriya, shiyshat Móysisaa, zuwanlleetsish Aarona machingcha wipaptarta Elíyasarpatarta. Ambirisha Horpirisha ");
INSERT INTO cbuNT_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","kuskamchus, Aaronaa wamar tushiyarus, apanllpani wamari Elíyasaramsha yáyrush, panangcha. Ashkachus, anshurisha tsap Aaron tsipachiya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Móysissha anuritam yuwartatam Apanll kamachtarangu anuritam payurangiya. Ichingarusin Israelchich ashparitssin parsin, tuchpanandaritssin machip Horapsha naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","29","Anushsha tsap kuskamchusin, Móysis zoonllee Aaronaa apanllpani wamar kamarataru anoo tushiyaru, Elíyasaramsha túmartarangiya. Anshuritam machish Aaronarini tsiparangiya. Zoonll Aaronarini tsiparamchu, Móysissha waanitarishtisin Elíyasarpatamarisha machimand karuweerandsin, kuseeramchusin, anshuchee kamaniranganaya; Natunaa Aaronarini tsiparangtanda, tárangusin, uwshtisin kapung mang mantsarangusin, kizpur tanurangusin, minum tsup tushiyramchu anush wazan kanusarangshitisinaya. Ashiriya, na kamaneena yuwaa Aaronarini machip naayaru tsiparangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kurak Kanaanshuch yakat Aradush yapeem zar puwachingaru tuwash, Kanaanshuch tputs yaktarini Arad sura, apusap tsap Neguebash taarangiya. Anshuch yakat kurak k'kuzee mazinarangu tárangiya; Israelchich tputs naakatssincha, Atarimap ngootsi, tárangu, wasundurureetssha, Pzaya, iyaama pachayani, táranganaya Israelchicheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ashiriya, Israelchichshitisin Apanllee masharanganaya. Apaa, shiy iyaa Kanaanshuchee kasimaam istakchinaareesha, izuuru tputsee tpachingayani, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Apanllsha anoo mazinarangu kapung Israelchicheem istarangiya. Kanaana tsap ashpari tpachingarangiya. Ashiriya, Israelchichshitisin pacharangusin, Kanaanshuchee tputs ashpari kachingaranganaya. Ashirucha, amb ashirangsin uwshtisin anoo tsap sur Hormaa ísamaranganaya, Tpachingama, táranganaya. Ashiriya na kamaneena yuwaa Israelchich tputs Kanaanshuchee kachingamaam masharangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hormash shitungeerantssin, mus chumbeepimaship naayarandsin, Edomaa tsap tushiymaam punirangusin, arapsha iturpiyarusin, imaruranganaya. Ashirucha, Móysisarini tiptsir arap ngoots imarurangsin, kiyung kachiyarangsin, mantsir mangush chinaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Yuw waana zandkana anootsimsha mantsir tsiyataranganaya. Apanllee, misha Móysisaatstamta táranganaya; ¿Mayaamsha Apanll misha Móysis iyaa Ijiptosh tsap kis taaranguni, iyaa anush tsap ishitungaranga? Waani machip tsap apusap tsipanllina tupsinaya, iyaa Ijiptosh tsap ishitungarangiya. Waj, ningeem tsap kungoowtaa, misha katungamamta nduneewawa. Neetsimarisha katungkuni, ichingaru zar ndusha kaapa kis katungkiniya. Kanizeenllshatanicha, tárangusin, zapan mantsir tsiyataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Apanllsha anumand mkaa kasumash zanganirangiya. Maksha tputsee zapan kapuxta kapuxta ashirangu, zapan tputs Israelchich tsiparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ashirangsin, Móysisangaz tputs kusaranganaya. Kuseersin táranganaya; Móysisaa, itsinsaru kamanchinllpa. Iy yutaritshishish pantsaranginiya. Apanllee mantsir tsiyataranganiya. Shiyaatstam tsiyatarangani. Anumandpari Apanll iyaa waneekiya. Ashiriya, shiysha Móysisaa, Apanllee mashangi. Iyaa nda tpachingamaam mak ndusha iyaa kapuxamaama, arapsha mkaa zanganimaama, tárangiya. Móysissha anuritam Apanllee masharangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Apanllsha, Móysisaa, shiyshat ngusambaa yáyarush, mkaam amuy tamapari ashiritam tinangcha. Tinayarush, yasinamun tapamtayarush, pashuchunlla. Pashucheerush, tamamaatsimasaja tputs mak kapuxkachiya, uwshat ngusamb mkaam tinamaa tasaseeru nachayaru, nap ashkachu, anumunari yarchiya. Anumun waanaatsi tapachindachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ashiri Móysissha ngusambaa yáyru, mkaam tinarangiya. Tinayaru, yasinamun tapamtayaru, pashuchurangiya. Tputsee mak kapuxkachu anuritam iriputanusin, anoo ngusambaa mkaam tinamaa tasaseersin nap ashkatssin, yartaranaya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee yuwamand kukoo kapeetarangana anumand mkapa waneerangu, Móysissha ngusambaa mkaam tinayaru, anpat tapachindarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israelchich tputs kung Ortagap aranginasha, yap zar yaku ambi tsap naatarangsin, ambirisha tsap Mowabash kusaranganaya, tsap tándsapshita wazawshu. Anushsha kuseersin, yakat Jericosh Ortagoo kung arachich taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ashiriya, Balak, Siporarini wipa Mowabash tsap kurakaam kinaru taarangiya. Ansha k'kuzee mazinarangu; Israelchich Amorrewshuchee tputs tpachingayanllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ashirucha, uwshtisin kurakatam Mowabshuch, tiptsirtamsin Israelchichee parangusin, kapung puniranganaya, watam Israelchich tputs wazapaniwa. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Kuraksha Mowabshuch kurakpatatin Madiyanshuchee kurak kuruzeeru tsiyatarangiya; Papcha; anchich tputs zapaniwa. Uru iyashchi kachingchitampari siyaptarta tsapunis. ¿Tamatara wakar wazapan pastush pshtuyarusin, pasut kapungootstaa kachingta ashtariya? Uru iyaatssha ambitam ashimaam taariya, tárangiya. Kurak Balak Mowabshuch tsap kurakaa ");
INSERT INTO cbuNT_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","yusur minootssha apanllpaneetssha tputs Balamaa, Biyowararineetsi wip, kuruzurangtamta. Ansha yakat Pitor Eufratisamun kung wing napiwaru taaranganaya. Ambitam arap tsap sur Amawa taarangiya. Ashiriya, kuraksha Balak k'kuzee kamachtayaru, zanganirangiya. Kurakaa Balama pakchush tángcha; Ijiptosh tsap tputs shitungeerandsin, na ningeemsha naanchinpa, iyashsha tsapuni kuseenllpa. Anshitisin tputs wazapansincha; yutaritawina. Iyash tsapuni kuseenllinpa. Yaatsimaripa kasiyanllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ningeem kusachpa, tángcha. Kuseerush, zutayarush, tamantsayarush ksangi. Tputs tsipatsiptangatana. Nuwshat anush mikeeruri pachayaruri, kachingeeruri, kasapi, átana. Waashuch kizpursincha. Shiy tputsee wanasirpa tsiyatkachush, istamaam zandkachush, tputseem wanasir istayarush kasatarsha. Tputsee tayutaritamaam zandkachshitish, Waani kiyung kachiyachinllinpa, tákchush, tputsee zutayarush, kasakchush, tputssha kiyungutam kachiyeersin tsipakanaya, amb tángcha, táyaru, k'kuzee zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Anshitisin, yuw tputs k'kuzee kamanimapan Mowabshuch, Madiyanshuchtam Balamangaz naataranganaya. Kurik zapan yáyarusin, payutaranganaya Israelchichee tputs tuztachinllina anoom tuwapamaama. Anshitisin naatarangsin, anushsha Balamash pang' kuseerusin, ashpari k'kuzee kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balamsha, Ashiriya, musá naarintspa. Na in zar nishurtama maangints. Nuwma Apanllpatama yasachimasima. Waana Apanll nuwaa amchimasaja nuwshat anuritam na siyaa kamanchintspa, Balam tárangiya. Mowabshuchsha urkar, mishat Madiyanshuchtam urkar ashirusin, Ashiri nishuri maayani, tárangusin, anshuri Balamash maaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Itaru, Apanllsha Balam maarangu anush yakayaru masharangiya. ¿Chakshitisin an tputs shiyash pangish shaneeranaya? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balamsha; Balak Mowabshuch, Sipor wip k'kuzee kamachtayaru, anoom nuwangaz kamanini atusin kusateeranaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Ambcha kurakash Balakash watsapun Ijiptoshuch tputs shitungeeshinusin, wazapanisin naanaatarandsin, anushsha kuseersin, Balak nuwaa kuruzku, Naanpa, mang átza. Nuwsha amb kuseeri, tputsee tayutaritkachuri, zutakchuri, anush uwshat Balak pachakchusin, tashitungayarusin, anush tsap kasachinllina. ¿Nuw amb ashtachee? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Apanllsha Balamaa; Nda, amb shiy naarinllpa. Anpat tputs ipuninllpa. Ambchee tputs mantsir tsiyatinllpa, watam nuw ambchee tputs kapung chinakinawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ashirucha, anuritam putamsha taraseechu, Balam chiyzayaru, k'kuzee kamanimapaneetsi Balakaa tiptsir kamanirangiya. Waana Apanll Taarashipan nuwaa tárangeeja; Shiy amb naarinllpa yap naakchinllina ambi, tárangcha. Ashiri siy saanpeetam tsapunis kanapungsints, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kurakshitisin Mowabshuch, Madiyanshuchtam wapitam yuwari kurak Balak táyaru anuritam kanapuranganaya. Kuseeramchusin, Balamaa kamaniranguni, nda iyapa kusamaam zandarangiya. Kapunguri ngatarangiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Itaru, Balaksha kurak nda sambaytarangiya. Yusur mishat kurak yamayaru, zanganirangiya yuwanandarisha kurak putiteewa ipuseeru, annandarisha wazapanshitisin naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Naayarusin, Balamashsha kuseeramatssin táranganaya; Kurak Balak, Sipor wip shiyaa táranlleeja; Naanpa táranllcha. Nuwap kusamaam ngattapa, átcha. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nuwshat kapungunasha kurakaam ínachima. Yuwangzitam zandku anootstam panachima. Itaru, naanpa. Nuwash kuseeru, ashpari nee tputs tuztaramchu, tputsee ashpari tayutaritaramchu, anush nuwshat amb ashtachima, ambtanda táranllu, kurak Balaka shiyaatsi Balama táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Itaru, Balamsha; Nduni. Wandtaati kurak Balak nuwaam urkiree mbamashee oroo kurakush pang' kapungush tatsitaru, ashpari in panachinllpa, atitaati, nuw nda, ayu ashiri istachinllpa, nda táchina. Izuuru ngatamari ngatkina. ¿Tamareeja Apanll waana Taarashipan paru, nuw amb ashtachee? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","itaru ashiritaa, nishuri maangimasints ashpartis. Nuwma yasachimasima. Waana Apanll Taarashipan amchimasaja yusurshita, mang tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","psaansha Apanll Taarashipan Balamaa yakayaru, yusur tsiyatarangiya. Watam shiyangaz tputs naatarandsin kusataranganawa. Ashiriya, shiyshat káyarush, tachiteerush, napashintsi. Itaru, yuwamari nuwaana kamachtarangi anumari shingcha. Aranginaa shirinllpa, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balamsha anuritam putam taraseechu chiyzayaru, uxinashee burrumun ush wayayaru, anumun kuxineeranllu, Mowabshuchish kurak tachiteeranllu, ");
INSERT INTO cbuNT_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","anumun wipunasheemsha tsimbunatam, waanaatsi tiptsir machirangiya. Itaru Apanllsha waa kapung tsiyantarangiya. Ashirucha, Apanllsha waana wasundururee zanganeeru, ngootsip, yap naayaranllu amb apus ngoots apusanand Apanll wan xiyeeru, kámanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Burrurinshitini Apanllee wan parangiya. Ngoots kámananaru, wachirur uwish payuru, xixeew ashirangiya. Burrsha naamaam xararangu, mzatsipsha ngoots pshtuyaru, naarangiya. Itaru, Balamsha; Natu, wapitam kanapeerush, ngoots watsinsapirisha naangi, tárangu, burrureetsini yasinpat yáyaru stee stee ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yusur watsinsaptam naayarandsin, Apanll wan apussha yusur yuwaatssha ngoots shunlli anootssha apusanand kámanayaru xiyarangiya. Yuwaa ngoots kizpur shunlli wingunung patumbichpa kámanamanandari shurangaru, arangtach wing, arangtach wing ashiru, kizarunsha ashirangtamta minungichich ngoots kizarunandari shurangaru, minungichichsha ngoots kizarunatam shuranguru ashiru anoo apusanand Apanll wan kámanarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Burrsha iriptaranllu, Apanllee puniku, piyam ktapinganll ashku, patumbchimun ktukamchu, Balam upaz patumbchimun tuw ashirangu, Balamsha yasinpat yaranllu, yusur pzkoorangiya burrureetsini. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Itaru, Apanllsha yusur imazat sheeranllu, yuwashunasha apus ngoots kizpurinasha shunlli, izuuru minungichich watandaram tawineeru, naamaam pinasinaashtaa, minpiyeemtaati ngoots ktapumaam ndunarirtanashta anu kámanarangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","burrsha paranllu, anootsirisha kuxinta sheeru, apusanandarishta ngoots pumayarangiya. Balamsha kapung tsiyantarangu, yasin yarangu, burrureetsini kizpur pzkoorangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ashirucha, Apanllsha burroo waana tutsiyatstarangiya, Burrsha: ¿Mayaamsha nuwaa pzkooksha? Na nipat nuwaa tuchip pzkooyanllshawa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balamsha, Yuwamand nuwaa mantsangayarish anumand ashkina. Waanari k'chiru payururi, uru naturi shiyaa k'chirpa kayungataruri, pachayarunll, kasachinlla, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Itaru, burrsha, Nuw shiycha chinish. Urutamari nuwamun kushi chipayarush naatariniya. Shiy nuwaa yasaktamsha. Nda nuw shiyaa minumtiyam sirú naakuni, nda shiyaa mangish tamantsangtarina. ¿Antaati nuw shiyaa amb ashtareezi? tárangiya. Balamsha anootsinaa, Zuraktishcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ashiriya, Apanll Balamaam waanaatsi tuyamandamaam zandarangshita. Balamsha nap ashku, xixeewu wachirursha payuru, apusanand ngoots Apanllee wasundurur parangiya. Balamsha anoo paranllu, puniranllu Apanllee tasaseeru, tsapush much timuchta ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Apanllsha; ¿Mayaamsha chineetsish burrureetsish tuchip pzkooyanllsha? Nuwcha ningeem naatarani, ngootsee kámanakamchi nda arang tushiymaama aturi, watam nuw yasaranginawa yuwaa mangish mantsirimash chinarangish anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Chinshitish burrurish nuwaa parangu punirangiya. Ashirucha, piyam ktapurangu washunand tuchip ktapeenlliya. Ndunnaari ashiru, uru na shiyaa pachayanllinaparina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balamsha Apanllee wasundururee; Ashiri nuwaanaa yutaritshishish pantsarangina, watam nuw nda yasaranginawa yuwaa ngootsish apus kámanarangish anootsi. Wandaya shiyaam yutarit nuw ashkuri, ashiriya nuw kanapuchshaparina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Itaru, Apanllsha; Nduni, naamaam waritariya, watam naayaranllshawa. Yapiri tachiteeranllish ambiritam tchitancha. Itaru mangiptishpa. Yuwari tárangi anuritam payungcha, tárangiya. Ashiriya, na kamaneena yuwaa Apanll Balamaa apus tuxararangu anootsi. Balam yuwash kurak Balak tiptsiree zanganirangu anush tachitarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ashirucha, kuraksha Balak yuwaa Balam naanchu anoo mazinarangu, ¡Xa! Apus chamayangati átu, uwshat káyaranlltam apus yakat Mowabash yuwash kung sur Arnón taarangu anpatari tsap tasasarangu, anush chamayangarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Chamayangayarusin, Balaksha kurakpatatin Balamaa tárangiya. ¿Tamakinaarish nda musá kusarangsha? Zapan zar zapshtarangshawa, watam nuw wanip tputsireetsi zanganiranguri, shiyaa xapoorangi. Mangishish ¿antaati amb nuw naakchuri, nuwaam kurak Balak maachta panacheeja? ndambaree, tárangpasha. Napa nda musá kusarangsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balamsha; Zuraksha. Itaru, yuwamari Apanll nuwaa kamachtaku anumari nuw tsiyatchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Anumunsha Balam Balakpa ipuneerandsin ambirishat tsap Kiriyat-Hosotapsha naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Amb kurak Balak tiptsiree kamachtarangiya; Wakar pchangints. Opeejatam pachangints. Sheerus, Balamaam panashinints. Waani wipunasheem yuwaam macheetu kurakawtamsina anoom wani panap. Muchchurshitisin apanllputsee ungirtapana, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Putamsha taraseechu, kurak Balak Balamaa yamayaranllu, machipsha machtarangiya mach sur Bamot-Baal tána ambshita. Ambshat machip naayarusin, anumand machimand yapeeja Israelchich taarana atusin naparanganaya. Ashiriya, na kamaneena yuwaa Israelchichingaz nachungarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balamsha tárangiya; Nish patumbich 7 xanateerush, anumun wakar wip karupanawari 7, misha opeejsha karupan cietitam pachayarush muchingi, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","kuraksha Balak anuritam ayu táyaru, yuwaa Balam kamachtarangu anoo tuminurangiya. Maacheetsi chinuzee wip karupanawaatsiri waya waya ashiranganaya. Sheersin, muchiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Muchiramchusin, Balam kurakaa Balakaa tárangiya; Musápa. Shiy neetsiritamapa. Nishuri kutapandama. Nuwaanitarisha minumarishti naachima. Pangatamasima. Apaz Apanll nuwangaz chamayangati átu naataranu. Ashiri yasatamasima. Na yasaramchuri, shiyaatssha kamanchinllpa yuwaa waana Apanll nuwaa kamachtakachu anootsi, tárangiya. Táyaranllu, Balam ambirisha machip apusapsha, yap tputs ndunari amb, machip káreeru naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Anush machish kuskamchu, Apanllsha Balamash yakarangiya. Balamsha Apanllee parangu, tárangiya; Shiyaam Apaa, maacheetsi muchpani táranguni, 7 patumbchee xanataranganiya. Sheeruni, wakaraa, misha opeejaatstam karupan minam, minam sheeruni, wayaranginiya. Ichingaru yuwash 7 xanatarangani anush ashpari wayaranginiya, tárangu. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Apanllsha: Balamaa, shiyshat waptam kurakpitam Balakap kanapeerush, kamanimancha. Yuwari nuw shiyaa táyachi anuritam nuwaa kuki kamanishini, Apanll Balamaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balamsha anuritam kanapeeranllu, yusur Balakaa chamayangarangiya. Balaksha anshuritam tiptsirpa Mowabshuchpa tputs Balamaam kutaksin, shanee ashiranganaya. Balak kutaku, xixeew ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ashiri Balamsha tárangiya. Nuw tsapunshish, yap zar yaku amb, Aramush taaranguri, kurak Balak Mowabshuch tputs nuwaa kuruzurangiya. Ning nuwash kusangcha. Kuseerush, nee tputs Israelchichee zutayaru kasachpa, tárangu, Akoparinchichee tputs mantsir tsiyatamaam zandarangiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Itaru, nuwsha ¿Tamari amb sheeruri, tputssee zutambeeruri kasachee? ¿Antaati nuwaa Apanll; Tputssee zutambeerush ksangi, ateeja? nuw amb ashtapi. ¿Antaati Apanll nuwaa mantsirimash chinamaam kamachtakeeja? Apanll nuwaa wanasirimshireetsima kamachtarangiya. ¿Tamari nuw Apanllee kuk kapeetchee? ");
INSERT INTO cbuNT_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Nuw machimand káreeruri, naparanguri parangtana. Tputs wazapansincha. Nuw ashpa tputs patareezi. Waanapa Apanll tiptsiriya. Napa, ashpisin taarana minpicheewtampasinaya tsapuranas tputsiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Izuuru ashpiri tsap puyumboo, ¿tamari ashpa tputs taachchich? Ashirucha, nuwsha anungaz támarakuri, tamangsinda tsipapi nuwsha ambitam ashtapi túri támarakshina, Balam Balakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Kuraksha Balak Balamaa tárangiya; Nuw shiyaa kundarareemi tuztamaam kuruzurangina. Shiyshat nish ¿tamakshasha? ¿mangutaritashuwa pakatush kusarangshawa? Napa; anoow tputs shiy kis chinampatari tsiyataksha. Nuw anoomaja shiyaa kuruzurangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Tárangu, Balamsha; Zuraksha. Nuw tárangina shiyaatsi; Yuwamaritam Apanll nuwaa kamachtaku anootsiritam nuw tsiyatkina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Itaru, Balaksha anoo nda kis mazinamaam zandarangu; Ashiri pzaya. Yusur nuwapasha ipuneeruni, piyamsha mach naayani. Iturpiyaruni pakeeni. Amb naayaruch, pamaam waritartamparee. Itaru, nda ashparta tputsi nda pangachchee. Chawpimaritaa zutayarush ksangi atina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Táyaranllu, kurak Balak Balamaa piyamsha mach machirangiya mach sur Pisgapshita. Ambiri machimun káriranganaya. Anumun káreersin, ambirisha yusur, maacheetsi muchpani, atusin, patumbchee yáyarusin, arangich tsimbun matayaru xanatarangana. Sheersin, wakar wip, opeejaatstam karupan Apanlleem muchiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ashiramchusin, yusur Balam kurakaa Balaka tárangiya; Ashiri shiy musá neetsiritamapa nishuri patumbchirishish xanatamash kutapandama. Nuwma nuwaanitarisha naayaruni, pangatama, yapeeja Apanll nuwaa yusur chamayangachinda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Táyaranllu, waanitarisha naatarangiya. Anushsha apus Apanll Balamaa chamayangayaru tsiyatarangiya. Natu wapitam kanapeerush, kamanishini kurakaa Balakaatsi yuwaa shiyaa tsiyatarangi anootsi. Ashpari tatsamooru kamaningcha. Yaptam shiyaa tárangi anooritam kamaningcha, Apanll Balamaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balamsha wapitam kanapeeranllu, yusur Balakaa chamayangarangiya. Balaksha anshuritam tiptsirpa Mowabshuchpa tputs Balamaam kutaksin, shanee ashiranganaya. Balak kutaku, xixeew ashirangiya. Balak anush yusur masharangiya; ¿Natuwa, Apanll shiyaa amkimta? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balamsha ashparitam yuwaa Apanll tárangu anoo kamanirangiya. Shiy Balakaa, Siporarini wipaa, nuwaa kuki kaapa mazinangandama; ");
INSERT INTO cbuNT_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","¿Nitaati Apanll chiy tputssich tamapari ashireeja? Apanll nllitari chinamaam nda yasariya. Nduntam ngichimaam yasariya. Yuwaatsimari tsiyataku anootsimari payukiya. Urutamari kukoo tumineernand kasatariya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Apanll nuwaa itsinsaru kamanirangiya; Ambchee tputs kapungtanda nuw chinaki, tárangtanda. Átu anoo ¿nuwshat tamayareezee? Watsta Apaa, ambcheem tputs istamaama ¿tamaree nuw táchee? ");
INSERT INTO cbuNT_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ichingaru Israelchichee tputs yutaritshishirini tachingeeru, ngichiz ndunarsha kasarangiya. Ambich tputs ichingarusin Akoparinchichinandari wachinllinu. Waana Apanlltam Taarashipan anshuchee kapung ksutkiya. Ashirucha, anshuch tputs ichingarusin Apanllee; Iycha kurakarini, atusin, urkareem ínakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tor watarimash witspatari waanaatsi tapachindaru ashikpaz ashiru Apanll Israelchicheem ksutkiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Waana Apanll tiptsiree Ijiptosh tsap tashitungarangu, anshuch tputs ichingarusin kizpurinandaritssin taaranaya. ¿Tamamaja tputs anoo kasiku kasich? ¿Tamayareezich anshuchee tputs zutaychich? Zutamaam pinasa, watam Apanll waana ksutkuwa. Ashirucha, chiy Israelchichee tputs támaam waritariya; ¿Siyaamam wanip Apanll istaranga? Urutamari ambiri ashishtar ashtachiya, táchchi. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ashirusincha, anshuch tputs Israelchich ichingarusin kizpurinandaritssin taakanaya. Tumuz ashiru yáyachu, nda kapamaam waninda. Izuuru zamari zayaru, kapunguri katungkeeru, tazazayaru, ursiree wayaru, mapiysha maamawamach ashtaru, an tamaparee ashiritamsin, nda nizimaam yasaranaya. Ashirucha, ambchee tputs kasimaam wanindaja táshina, mang ántar ashirangiya kurakaa Balakaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaksha tsiyantayaru; Zamangi, Balamaa. Shiy zutamaam pinasakush, ¿mayaamshtaja wanasir tsiyataksha? Ashiriya, zamayarush taangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balamsha; Nda, amb tárinllpa. ¿Mayaamshitaja Apanll nuwaa nda kamachtaru, nuwshat nuwaanitari msangeeri amb ashtachee? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ashiriya, yusur Balak nda sambaytarangiya. Naani, yusur piyamsha machchinllpa minupsha machi. Apaz amb naakchuni, Apanll shiyaa kamachtakachshita Israelchicheem tuztamaama. Pzaya, ambsha yachani, mang tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","kurak Balak Balamaa minupsha mach machtarangiya. Mach sur Peyorapsha amb tsap puzap machimand ichingaru tsapoo pamaam waritarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Yusur Balamsha kurakaa Balaka kamachtarangiya; Na yusur patumbich tsimbun matayaru xanatangi. Sheerush, wakar wip karupanaw 7 pchangi. Opeejshat karupan ashpatam pchangi. Amb sheeruni, yusur mucheeni, mang tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ashirucha, Balaksha Balam táyaru anuritam wakaraa wip 7 pachayaru, opeejaa karupanaatssha ashpatam pacharangiya. Sheeru, patumbchishshat yusur minum, minum sheeru, xanateeru muchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Itaru Balamsha, yuwaa Apanll Israelchichee kapung chinarangu, ksutarangu anoo yasarangu, nda Apanllpa yusur tsiyatamaam zandarangiya. Ndusha tputsee, Apanllpa tsiyatatama, tárangiya. Wazawapsha napku, Israelchichee tputs shaneeru parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Israelchich tputs wazapan taarusin parangiya; tiptsirinandari waanitam, misha tputs tiptsirinandaritam waanitam ashirusin wazapan taarusin parangiya. Apanllsha Balamaa tutsiyachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ashirucha, Balamsha Apanllee kuk tsiyatarangu; Nuw Balamtana, aparshiti sur Biyowarcha. Nuw napkuri, maachee ichinguru pakuri, kapung natstakina. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Nuw pamazukpaz ashkachuri, anush natstamaam waritakina. Apanllee kuk mazinakina. Nuw pamazoorangi anush yasarangitamna. Apanllimari watam kizpuriwa. ¿Chakaja uwaapa waritach? Apanllimari waamari kizpur taakiya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Mishat, anin tputs ichingarusin Akoparinchichcha wachinllinu. Kizpur wanasirinand taaranaya; taárashshitisin wanasiritam taaranaya. Tatsumim yasin patarich ashiru watambur shurangaru, tambta tambta ashirusin, wanasir taaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Napkuch, ambiri watambur shurangatarusin, kuyan kungumun wing kuyantaru wanasir patarich ashiriya. Waanapari Apanll amuy kungumun wing wayayaru, Israelchichee kasarangiya. Napa; karipan kungumun wing shurangaru, patarich ashiritamtaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ashiriya, waamaritin Israelchicheemaritssin, ayamtaatiya uwaamin kung nda pishtatanlliya. Anchichtam kungoo tipayarusin, tatsumimarish mazarish kanachtachinllinaya. Mishat, urkarshitisin kizpuritam taariya. Wamari kurakaa Agagaa kasiriya. Wamari kizpur kurak taariya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Tor watarimash witspatari kizpur waanaatsi tapachindaku ashipaz ashiru Apanll Israelchicheem istakiya. Waana amuy Apanll Ijiptosh tsap tashitungayaru, ningsha tsap wayarangiya. Waana wizpurirnee panarangu, uru undararpa waratkatssin, waamaritin undararee kachingchinllinaya. Wanapuwaa chpambeersin, k'chirpungpasha kayungku shitarusin, waamari kasichinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Kanusakshitisin, tumuz manginshuch kázamash tamatarpari ashirusin, maakururtar ashchinllinaya. ¿Chakaja anoo naattu ituyamataru ituyamach? Chiynaa tputsich Israelchichee wanasir tsiyatkuch, Apanllsha chiyaatstam wanasir ksutchiya. Itaru, tayutaritkachuch, Apanllsha chiyaatstam zutakpaz ashtachiya, Balam tsiyatku ántar ashirangiya. Ashiriya, na yuwaa Apanll Balamaa tutsiyachtarangu anoo kamaneena. Ashiriya, nuw Móysisi: wapparee, atina siyaatsi. Na kamaneena yuwaa Israelchich apusash masaru taarangana anootsi.");
INSERT INTO cbuNT_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Israelchich ndatuma Ortaga kung kitarusin, Móysis nee tsiyatssee Israelchicheem kamanirangiya. Kung Ortagumun, yap zar yaku amb taaranganaya, tsap Arabashu, watsapuni. Anushsha tsap tputs yaktarini zapan taarangtamta. Ansha yakat sur Parána, misha Tofel, misha Labana, misha Jaserotee, misha Disapa, aship taaranganaya. Arachichsha yakat Suf taarangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Anshat mach Orebamand káyaruch, Seirshuri machish naaruch, 11 zar maayaruch kusamaam waritakiya yakat Kadés-Barneyashu. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Iwamun Israelchich Ijiptosh tsap shitungarangana anumun iwaz, 40 masach tushiyramchu, anumunsha 11 tsup kaneeschiri yáyaru anush Móysis Israelchichee Apanllee kamachtamarini, yusur tayuseeru ichingaroo kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ndatuma kung Ortagap kusarusin, Móysis wasundurur Amorrewshuchpa kurak Sihonpat waratarangsin, waamaritin kasirangusin, Sihonaa pacharanganaya. Ansha Sihon yaktash Hesbonush taarangiya. Arangsha Móysis Basanshuchpasha urkar, Ogpa waratarangsin, waamaritam pacharanganaya. Ansha kurak Astarotash yakat taarangiya, Edreyash watsapunu. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Anumunsha Israelchich yap zar yaku amb kung Ortaganung, Mowabash tsap taaranganaya. Anush Móysis Apanllee kuk tiptsireem yusur tayaspataku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Iyshat tsap Orebash, Sinaytam suru, taaranguni, anush Apanll iyaa tsiyatarangiya; Siy nish tsap zapancha zar taayanllis. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ashiriya, ashparitis maachiritis yáyarus, natu machip Amorrewap tsap mikeerus naangints. Amb siyaam tsap sur Araba zapan taararutariya. Arachichsha kungoo Ortaga tsap mach, anumun tandsatam taaritamta. Mishat, tsap Negueba taaritamta. Mishat, maranung tsap, Kanaanshuchpitam watsapun taaritamta. Libanshuchpitam tsap, mishat kung kapungumashpitam Eufratisip tsap taaritamta. ");
INSERT INTO cbuNT_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Aship an tsap nuw siyaam tsapuneemis panayana. Ashiri natunaa naayarus, siyamari tputsee kasiyarus tsapuneemarishtis yáttsa. Watam nuw Zurampatari, sirútama zitaminarineetsis Aprahamarineetsi, Isaakarineetsi, misha Akoparineetstam arangeem chinllineemtamtis panachima tárangi anoo. Ashiri na in siyaamsha tsapuneemis panachintspa, Apanll iyaa tárangiya, Móysis tárangiya. Ashiriya, na kamaneena yuwaa Apanll Móysisee, tsapuneemis kapung panachintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Móysissha: Na Israelchichis mazinangantsa. Nuw siyaa Apanllee kamachtamarini itsinsaru kamanirangina. Ashiri siysa tuminungtsa; kukoo payungtsa. Sirútama Apanll zitaminarineetsis, nee tsap panachintspa, tárangu, na anush tsap siysa taakchus, wamachtasheetstam payukus, urutamari anush tsap wanasir taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Yuwaa tsiyatsis kamanirangi anoo siysa minumtiyam tsiyatsis arangeem wayarintspa, misha minumtiyam kpitintspa. Tatsamooru yuwaari Apanll kamachtarangu anuri payungtsa ");
INSERT INTO cbuNT_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Sirútama Baal-peorush taaranguni, iyashuch tputs zapan anshuchee apanllputsirini ungirtaranganaya. Anumand Apanllsha ichingaru pacharangiya. Anoo siysa kchiptis parangimandis. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Itaru, siysa Apanllee nda kasarangsa; apanllputsish nda tachitarangsa. Wanasir Apanllee kuku payurangsa. Ashirucha, siy ashparitis na wandari kchitis taaksa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ashiriya mazinangtsa; yuwaa Apanll nuwaa kamachtarangu anoo nuwsha siyaa kamachtamarinee ichinguru kamanirangtana. Na siysa tsapunpis pshtumaam waritayanlltanda. Ashiriya anush taakchus, uru Apanllee kuk tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Tatsamoongtsa, misha tuminungtsa. Siy amb ashkachus, tputs siyaa, In tputs tamara, mangpatari taakanaya, táchapsinaya. Apanllee kamachtamarini mazinaksin; In tputs zurampatari yasampansincha, misha chinampansincha, siyaa táchpasinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Watam Iyamari Apanllirini iyaanshutari watsirit taakuwa. Itaru, minpichsha tputs iyapat Apanllirini tatsamaam wanindaja. Iyamari Apanllirini kizpur iyaanshutari watsirit taakiya. Iyshat tsiyatamaam zandkuni, mikeeruni tsiyatkiniya. Araptaa naakuni, itaru Apanllsha anshutamta napkiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","¿Tamamaja tputs watsapun kapungutaatiya tputs zapantaatiya taaksin, Apanllee kamachtamarini tputsee mangoo itsinsar yasamaam taar? ¡Wanindaja! Yuwaa nuw siyaam na tayaspataki anoo tputs nllitarit mazinatarazinllinaja. Itaru siyamari yasaksa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ashiriya, na siy mangiptis taangtsa. Yuwaa tsiyatsis kamanirangi anoo mbizarintspa. Ayamtaatiya Apanllee kuk kasarintspa. Mishat, Apanlleetstam wizpur parangis anootstam mbizarintspa. Itaru, siynaa ashparitis ipareetsis kamaningtsa. Mishat, chinllineetstamtis arangeem tayaspatangtsa yuwaa Apanllee wizpuri parangis anootsi, Móysis Israelchichee waneeku tárangiya. Ashiriya, na kamaneena yuwaa Móysis iyamari Apanllirini kizpurcha tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Mishat, Móysis Israelchichee tárangitamta; Siy yuwash machish Orebash taarangis, anpur Apanll nuwaa; Shiysha ashpari tputsee tushaneengcha. Tushaneerush nuwaa kuki kamaningcha. Tputs nuwaa kuki mazinakchusin, ichingaru zari k'keetsi payuchinllinpa. Sheersin, arangeem wipaamshitisin anuritam nuwaa kuki tayaspatachinllinpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Siysat ichingarus mach Orebamand kayumayarus, napkus, machsha kapung kurakataru, sumas íwar kshungataru parangsa. Msassha tuwap, kizpur kantsirpi machee purangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Apanllsha siyaa yuwash sumas kurakataru anush tsiyatarangiya. Siysa Apanllee kuk mazinarangitaatis, itaru nda waanaatsisha wach parangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Anush Apanll; Nuwaa kuki payukinareesa, nuwsha siyaa; Nuwaanacha tputsiri táchima, tárangiya. Táyaru, kamachtamarinee minam chung siyaam kamanirangiya. Sheeru, patumbchimun yandarangu; Na siysat anoo yasayarus, urutamari tuminungints. Nuwaa kuki payungtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Sheeru, Apanll nuwaatssha; Shiysha Móysisee nuwaa kamachtamari tputsee tayaspatangcha. Tputssha anuritam yasayarusin, Kanaanash tsap taakchusin, anuritam k'kuz payuchinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Yuwapur mach Orebash Apanll wandari amuyari siyaa sumas kurakataru anush tsiyatarangu, anpur nda minumtiyam maachee sumasush parangsa. Kukootsimari mazinarangsa. Ashirucha, nuw siyaa paptsa, mangiptis taangtsa atina. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Maacheetsi ungirtamaam tinarintspa. Tputseem kamuz ashiru, misha kiz ashiru tinayarus, anoo ungirtarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","18","Mishat, tsapurunasish maachi tsapush taakana anoo, íwarpicheetstam misha tsapush pshiyrataru anootstam, mishat kayupcheetstam ungirtamaam tinarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Mishat, ashiritam yuw kanindap taaru, zari, tsupi, tsangachi anoo pakeerus, ungirtarintspa, watam yuw ichingaru íwar pakis anoo ashpari Apanll tinarangiya, ichingaroom tsapurunasshucheem wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Siy Ijiptosh tsap taarangus, sumasishpaz ashiru kiyung kachiykus taarangsa. Itaru Apanllsha siyaa Ijiptosh tsap tashitungarangu, siy kizpurtarangus, ngusamb mbammash sumasish pshtam tamapari ashiru shitungarangsa. Sheeru, Apanllsha siyaa; Nuwaanacha tputsiri, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Siysa Ijiptosh tsap shitungarangus, itaru siyamand yutaritshishiris nuwsha tsiyantaranguri, Apanllee kuk kapeetarangina. Anumandsha Apanll nuwaa tsiyantarangu; Shiy Ortagoo kung arachich Kanaanap tsap pshtucheezish, ndambaree, tárangiya nuwaatsi. Itaru siyaamam tsapunis kizpur wanasiree Apanll panachiya. Ashkachu, nuwnaa amb naacheezi. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Nuwaana nishuritanda tsap tsipachi. Kungootsiyam Ortagoo arachich nda kitchina. Itaru, siynaa amb naatssa. Kungoo Ortagoo arachich kiteerus, naatatssa. Anoo tsapoo wanasiree saanasha ksutamaatsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Itaru, anush kuskamchus, mangiptis taamatssa. Apanll siyaa; Siy nuwaa kuki payukinareesa, ashiri nuwaanacha tputsiri taachima, tárangiya. Ashiriya siysa anoo mbizarintspa. Maacheetsi minamtiyam ungiritamaam tinarintspa. Yuwari Apanll kamachtarangu anuri tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Watam Apanll siyaa minootssha ungirtamaam pachindkiya. Apanll tsiyantakchu sumas tamapari ashiru ichingaru muchkiya. Ashiri siyaa, Paptsa, atina. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Siysa Kanaanush tsap taakchus, anshuri wachinakchus, iparis, mishat chinllinitamtis pzapaneekchus, ashiri paptsa atina. Zapish yuwashsha zandkis ansha maacheetsi ungirtamaam tinayarus, yutaritshishee chinakchus, uru Apanllee tatsiyunuchtachpasa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Na nuw Apanllimun sur itsinsaru kamanchintspa, zurampatari táchintspa; arachich kungoo Ortaga kiteerus, zapan masach Kanaanush tsap taakchinareesa, itaru tputsee tinamarini ungirtakchus, tsapunshis zapan masach taacheezis, ndambaree. Apanll uru ashparitaatssis chingayaru kasachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Siyaa ashparitaatssis Apanll minpeew tputs watsapun piyamaw zangan, zangan, ashkachu, siysa tsapurunasush pseertarus, uru kiyung kachiykus taatssa. Tsipatsiptar ashkus, pakchimshitis tputsipsha watsapun taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ambsha taakamchus, tputseetssha tinamarini, apanllputsee ungirtakus taatssa. Yasinaatsimsha, mishat patumbcheetstam tinama, wach nda pamaam yasaru anu, wits nda mazinaku anu, katungtseetstam nda katungamaam yasaru anu, misha kanusamaamtam nda yasaru, anootsimsha siysa ungirtakus taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Itaru, ashkitaateesa, kaapaniri mangiptis chinayarus; Apanllee mangoonpi, átus, zuramarpatari wanasir chinayarus, Apanllee mashkus, Apanllsha uru siyaa mazinachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ichingaru zar kiyung kachiyarangus, Apanllee kuk kapeetarangtaateesa, itaru mangipashtis chinayarus, yusur Apanllee mangoonpi átus, kukoo payukchus, ");
INSERT INTO cbuNT_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Apanllsha, watam nayanimpaniwa, siyaa kasacheeja; siyaa tpachingacheeja, ndambaree. Watam waana kuk zitaminarineetsis tsiyatarangu; Siyachchee nuwaanacha tputsiri, táchima, Apanll tárangu, anoo izuuru tuminchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","33","Mazinangtsa; Apanll siyaa sumasush tsiyatarangiya. Siy Apanllee kuk mazinarangitaatis, itaru nda tsiparangsa. ¿Nitaati Apanll minoowa tputs ambtamtaja ashiru tsiyatarang? nduni. ¿Antaati tputs ambtamtaja mazinayaru nda tsiparang? Nduni. Sirútamastaa, Apanll tsapurunasee tinarangu, tputseetstam tinarangu anpurta nda minamtiyam Apanll tputsee amb ashiru nda tsiyatarangiya. Wanari siy yasamaam zandkus, ashiri siysat naayarus tputseewa ichingaru tsapurunas mashangtsa. ¿Apanll sumasush tputsee tsiyatku anoo siy mazintaritaatis? Tákchus, tputsshitisin, Nda, anumashee tsiyatsis mazintareezini, uru tputs táchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Apanll waanaa siyaa tiptsireem sirútamasari ipusarangu, siyaa Ijiptosh tsap tashitungarangiya. ¿Nitaati Apanll minoowaa tputsee ambtamtaja ashirang? ¡Nda! Apanll siyaa tapachindamaam zandarangu, wizpurirnee kapung tuyamandarangu, siysa anoo parangitamsa. Ijiptoshuchee tputs kiyung yachamaam, tpuxtamaamtam ashirangiya. Sheeru, kundarareetstamtis zapantam tpachingarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Waana Apanll, Tputsiri wizpurireetsi pakchusin, nuwaa izuuru mangoonpana átu, siyaam tuyamandarangiya. Iy Apanllirini Taarashipan minumaritcha. Apanll nllitarit wanindaja. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Waatacha Apanll minumari kanindamand siyaa wanasir taamaam waneerangants anu. Mishat, siyaa tsapush yuwash sumas kurakataru anush tsiyatarangiya. Siysa sumasish Apanllee kuk mazinarangsa. Watacha an iy Apanllirini, arang Apanll wanindaja. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Apanll sirútama siyaa zitaminaris kapung chinarangu, siyaatssha nlluranureetsis waama tiptsireem ipusarangiya. Sheeru, siy Ijiptosh tsap kiyung kachiyrangus, uwshat wizpurpat siyaa tapachindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Waana tputsee wazapaneetstaa kizpureew taakana, anootstaa Apanll wizpurpat tpachingayaru kasachiya. Ashkachu, siysa anush tsap saamatarisha tsapuneemis amuytatssa. Watam naturita ashpatamtis nish tsapoo payuksawa. Ashiri amb sheertamtis ashparisha tsap yátssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Apanll minumaritcha kizpur kanindash taakiya, ichingaru tsapurunaseetstam kasiru taakiya. Ashiri na siysa anoo urutamari mangiptartis chinangtsa. Ayamtaati mbizarintspa. ¿Antaatiya min Apanll wanindaja? Minumaritcha Apanll taaru. ");
INSERT INTO cbuNT_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ashiri Apanllee kamachtamarini, yuwari na siyaa kamanki anuri payungtsa. Amb ashkus, uru wanasir taatssa. Nlluranurtamsin wanasir taachinllinaya. Ashkachus, uru anush tsap kis zapan masach taatssa, yuwash Apanll tsapoo saamatari taarashis panarangu anshuya, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee waama tiptsireem ipusarangu anootsi ");
INSERT INTO cbuNT_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Ashiriya, Watacha in Apanll Taarashipan kamachtamarini. Apanll nuwaa; Shiysha Israelchichee kamanincha. Izuuru mangoonkusin, tputsee watsapun taakamchusin, anuritam tuminchinllinaya, Apanll tárangiya nuwaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ashiri siysa nuwaa kuki mazinakus, Apanllee urutamari chinakus, kamachtamarinee payukus, ipartamtis chinllinitamtis anuri payukchusin, amb ashkachus, uru zapan masach taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Ashiriya, Israelchichis anoo tuminungtsa. Amb ashkachinaareesa, uru kisshapari taatssa. Siyachich tputs zapan pzapanichpasinaya, yuwash katungats zapan taaru anshu, kinduratam, anumunsha wakaratam mimir kung ashiru naantangatu anshuya. Yuwaa Apanll waana sirútama zitaminarinee; Nuw siyaam tsapuneemis panachintspa, tárangu anoo izuuru tuminchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Israelchichis, na mazinangantsa; Iy kurakarini Apanll Taarashipani minumari taariya. Apanll nllitarita wanindaja. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ashirucha, Apanllee Taarashipanee itsinsaru mangiptish chinangtsa. Chinayarus, uru tchitangtsa. Apanlleetsimarit zurampatari mangiptis mangoonangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Ashiriya, yuwaa tsiyatsis na siyaa kamaneenlli anoo mbizarintspa. Urutamari mangiptis chinayarus taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ipareetstamtis urutamari tayaspatata shingtsa. Ichingaru zar pangishis kamaningtsa. Yuwash naakis, yuwashutam maakamchis, yuwashutam maarangus chiyzakchis, anush nuwaa kuki kamaningcha. Ichingaru tayaspatatar shingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Apanllee kamachtamarini kirakamun yandamaa kuwishtis pzungints. Mishat, charimunis wayayarus tutayangtsa. Izuuru chinamaam, nda mbizamaam shingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Anumunsha sheerus, pangimunshitis washitungash patuzinazimun yandangtsa. Wachumunatam shtandashini yandayarus, ksangtsa anuri chinamaama, Móysis Israelchichee tárangiya. Ashiriya na Apanllee kamachtamarini yuw kasiru anoo kamaneena. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Ashiriya, na Apanll Taarashipani siyaa zangankachu, siyaam tsapoo panachiya. Sirútama zitaminarineetsi, Aprahamarineetsi, Isaakarineetsi, mishat Akoparineetstam, Kanaanaa tsap siyaam panachintspa, tárangu, na siyaam nlluranureemshitis panachiya. Ansha yakat kizpur wanasirimshi misha kapunguw taariya. Ashich siy nda pangutarus, ");
INSERT INTO cbuNT_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","anush pangusush maachi zapan taariya. Nda siy minumtiyam ashich maachta wayarangis. Kungutam waamaam taariya. Nduntaa siy posoom ashich ktsitarus, itaru natsha anush kungoo waatssa. Mishat, mzatsshutam kizarun mishat olivpatam, zapan tatsumim taariya. Aship nda siy tatsumtarus anoo katungkus kis tazazaru taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Amb ashkachus, Apanlleetsimarisha uru chinakus taaksa. Apanllee mbizarintspa. Watam siy Ijiptosh tsap tumuchchurtarangunts, kapung kiyung kachiyrangus, Apanllsha siyaa nayanirangu, tashitungarangiya. Ashiri anoo mbizarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Apanlleetsimari Taarashipani ungirtangtsa. Anootsimari kuk payukus taangtsa. Zurampatari tsiyatangtsa. Ngutish ngichintspa. Apanllimunari sur tsiyatangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Kanaanshuchish apanllputsirinee siysa tchitintspa; watsta. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Watam Apanll siyaa ksutku, siyaa apanllputsee ungirtamaam pachindkiya. Waanariya, apanllputsee ungirtakus, Apanllsha siyaa tsiyantachparee. Sheeru watstamari kapeetchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Mangutis, Apanllee tamasingarus, ¿Tamaree Apanll iyaa istach? tárintspa. Sirútama Masash tsap taaranguni, Apanll iyaa istakeeja, tárangis. Natsha ambtam tárintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Itaru, siysa ichingarus itsinsampatarit Apanllee kamachtamarini ichingaru tatsamoongtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ashiriya, yuwaatsimari Apanll waana zandku anoo tuminungtsa. Uru wanasiri taangtsa. Uru ambinaariya ashkachus, tsapunshis wanasirimish kisshapari taatssa, yuwash tsapoo sirútama siyaam zitaminaris, panachintspa, tárangu anshuya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Mishat ashkachus, kundarareetsis siyaa tasaskachusin, Apanll ichingaroo tpachingachiya. Watam Apanll; Siy nuwaa kuki payukus, nuwsha kundarareetsish tpachingachima, waana táranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ashiriya, siyaatssha zapshita iparis, mashkunts; ¿Mayaama Apanll kamachtamareetsi zurampatari payungtsa, tárang? tákchusin, siysa; Iyaam wanasiriri taamaam kamachtarangiya, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Iy Ijiptosh tsap taaranguni, parawarini iyaa ichingurootsini muchchureem wayarangiya. Kizpur kiyung yacharangiya. Itaru, Apanllsha waanpata wizpurirni iyaa tapachindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Apanll Parawaa tiptsirpatari, maachiritaatstam, wizpurpat tpuxtamaam waneeshee waanaatsi wizpur zapan zangan zangan ashirangiya. Iyshat ichinguruni Apanllee waneesh paranginiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Iyaatssha Ijiptosh tsap tashitungayaru, minupsha tsapurunas, yapsha sirútama zitaminarineem panachintspa tárangu, ambsha iyaatssha machirangiya. Sheeru iyaamsha tsapuneemini nee tsap Kanaanaa panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Ashirucha, Apanll Taarashipan amb ashirangu, iyaatssha kukoo payumaam kamachtarangiya. Payukchinaareeniya, uwsha iyaa uru kisshapari zapan masach taamaam wayachiya. Na in zar tamaru taakaniya, urutamari ashtachiniya. ");
INSERT INTO cbuNT_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ashiriya, iysha anuritam Apanllee Taarashipanee kamachtamarinee uru mangiptini tuminkachuni, Apanllee wamachtash tatsamchiniya. Sheeruni, kisshaparee washunand tatsamooruni taachchee, tárangiya. Ashiriya, na kamaneena yuwaa Apanll nuwaa kuki payukinaareesa kisshaparee Kanaanash tsap taatssa tárangu anu. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ashiriya, na Apanll Taarashipan Kanaanaa tsap siyaamsha izuuru tsapuneemis panachiya. Anush tsap tputs zapan kizpurinandari taaranaya. Hititshuch, Gergesewshuchtam, Amorrewshuchtam, Kanaanshuchtam, Feresewshuchtam, Hebewshuchtam, Jebusewshuchtam aship tsap tputs kizpurinand taarana. Siyachchimand kasiru kizpurinand taakanaya. Itaru, Apanllsha anoo ichingaroo tpachingachiya. Siysa anush kasiyarus taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ashiriya amb naakchus, Apanllsha siyamari kundarareetsis kasimaam wizpuree siyaam panachiya. Ashkachu, siysa tputsee nayanirintspa. Anshuchee izuuru tpachingangtsa. Mishat, anchichpa tputs pakchiyam ipuneerus tsiyatintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Anchichpat nutsas pzapaneerintspa. Ipartamtis kamuz misha kizatam anshuchpa yamamaam izuuru watsta, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Watam ambinaariya ashkachus, anshuchee iparis yamakchusin, ipareetsis; Apanllee ungirtamaam watsta, táyarusin; apanllputseetsimsha ungirtachinllinaya. Ashkatssin, Apanllsha tsiyantakchu, uru siyaatsirisha wanichiya. Ashinuri kachich mtsa ashtarich ashinuri siyaa kapeetchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Itaru, siysa anush taakchus, apanllputseem, yasinaa tinama, misha patumbcheetstam tinama, ashpari sumasush kapeeteerus, mucheerus ksangtsa. Minumtiyam wayarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Amb ashkachus, Apanlleemsha tiptsir taatssa. Watam Apanll siyaatsimari waamaa tiptsir ipusaranguwa. Tsapurunasshuchee nllitaritaatstaa tputs nda ipusarangu, siyamari Apanlleem taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Apanll siyaa chinarangu, waana zandeeru ipusarangiya. Nda yuwamand siy tputsiris zapan taakis nda anumand ashirangiya. Watam tputs minpich tsap siyamand kasirsin wazapaninaashsha taakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Itaru, Apanll siyaa kizpur chinarangu ipusarangiya. Watam sirútama zitaminarneetsini, Nuw siyachcheem izuuru istachima, táranguwa. Ashirucha, anoo tatsampi átu siyaa ipusarangiya. Anumand waana siyaa Ijiptosh tsap tashitungarangiya. Siyaa Ijiptoshuch kurak kiyung yacharangu, muchchureem ínarangitaa, itaru Apanllsha siyaa wizpurpata tapachindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Taarashipani iy Apanllirini zurampatari Apanlliritcha. Siysa anoo ayamtaati mbizarintspa. Apanlleetsimari chinangtsa. Apanll uru waanaatsi kuk zurampatari tatsamkiya. Nlluranureemtam urutamari kukoo tatsamchiya. Yuwaa tputs kukoo zurampatari payuku anoo ashchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Itaru, tputs Apanllee ngatkusin, natsakana anootssha wanichiya. ¿Antaatiya zapshtacheeja? Mikeeru ashchiri kapeeteeru kasachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Ashiriya, siynaa Apanllee kuk tatsamoongtsa. Yuwari Apanll Taarashipan waana kamachtarangu anuritam payungtsa. Ashirucha, na zar nuwsha siyaa kamachtakina, siynaa anuri tuminungtsa, nuw siyaa tina, tárangiya Móysisa. Ashiriya, na kamaneena yuwaa Apanll Israelchicheetsimari tiptsireem ipusarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ashiriya, siy ichingarus Apanllee kamachtamarini na mazinarangus, anuritam tuminkachinareesa, Apanllsha Taarashipan siyaam urutamari kapung istachiya. Zurampatari yuwaa sirútama zitaminarinpa tsiyatarangu anuri tuminchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Siyaa chinaku uru kapung istachintsa. Iparis zapaneeyarus taatssa. Tatsumareetstamtis tirooku, kizarunaatstam, yasinatam wayungunoom yakana anootstam, misha chineetstamtis, wakaraa wip, opeejata wip ashpari wanasir kanungartachiya. Yuwash tsapoo sirútama siyaam panachintspa tárangu anush taakamchusa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Siyaa Apanll kizpur istachiya. Ichingaroo tputs kasiru istachiya. Saanpatatis pzapaneerus taatssa. Minumtiyam siyashuch kiz nda mireeku, kamuzatam nda kizaa tinaku taacheeja, ndambaree. Mishat, ashiritam chinshitis, wakararis upapchir, misha wizaritam, minumtiyam mipshiri taacheeja, ndambaree. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Ashiriya, Apanll waana ichingaroo tsutashshee arap kapeeteeru kasachiya. Sirú Ijiptoshcheem tsap Apanll zapan tsutashshee zanganeerangu, na siyaamsha ashtacheeja, ndambaree. Itaru, kundarareemaritis Apanll tsutashishpat wanichiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Itaru, siyaam Apanll tapazpat istakachu, tputsee pachamaam pakchiyam nayanirintspa. Ichingaroo tpachingangtsa. Mishat, anshuchee tputs apanllputsirini ungirtarintspa. Anoo ungirtakinaareesa, Apanllsha uru siyaatstam tpachingachintsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Siysa punikus, mangishis chinakus, In tputs zapaneewa. Iyashcheetsimaripa kasichinllinaya. ¿Tamayreezich chiy ashpa in tputs tashitungaychich? táchpasa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Itaru anshuchee tputs punirintspa. Apanll Parawaa tiptsirpatari waneerangu anoo mangishis mbizarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Waana Apanll Ijiptoshuchee kiyung yacharangu anoo siy saana kchiptis parangtischa. Mishat, napuxtashee zapan parangitamsa uwamari amb ashirangiya wizpurpata. Apanll tapachindapi átu waana wizpurpat siyaa Ijiptosh tsap tashitungarangiya. Sirútama Ijiptoshchee waneerangu ambitam sheeru yuwaa na siy punikis anoo kiyung yachachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Suwakchitaateesinaya, nduntaati ashiru waanaatsi pishuktatssin, itaru Apanllsha ashpaatsiri tpuxtakchu, uru miroosinlltayarusin, izuuru tsipachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ashirucha, nuwsha siyaa; tputsee punirintspa, atashina. Watam siy Apanlliris wamari kasiru kizpureewa. Siyaa uru istachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Apanll ichingaroo apinllari kapeetchiya. Siysa natunandari ashpa tputs chingakchinaareesa, tputs kurimunazkachu anush tumuzshapari kázamish pzapanichiya. Ashkachu, uru saanaatstatam zachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Itaru, Apanllsha waana siyamari kasimaam wayakchu, siysa tputsee pachata, sheerus yusur arangsha pachat, pachat shitanus, zapish ashparita kachingeerus kasatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Apanll waana kurakaatstaa siyamarisha kasimaam wayachiya. Ashkachus, ayamtaatiya anoo kurakaa tputs chinachazinllinaja; watstamamari mbizachinllinaya. Siyamari kurakaa ichingaru kasirus taatssa. Siyamari kachingatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Ichingaroo apanllputsee pakchus, yáyarus, sumasish pshtayarus, mucheerus ksangtsa. Oroopat tinama, kurikpatata tinama, ashtaa, sumasish kpitangints. Orootstaa mishat kurikeetstaa yamaam chinarintspa. Paptsa, anoo nazandiyispa, watam Apanll Taarashipan apanllputsee kapung natsakuwa. ");
INSERT INTO cbuNT_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ashirucha, apanllputsee pakchiyam pangipshitis yamaam chinarintspa. Ichingaroo natsakus sumasush kpitangtsa. Ndunnaa ashkus, uru siyaa Apanll kapeeteeru kasachiya. Ashiriya, na kamaneena yuwaa Israelchichee Apanll kapung istarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Móysis wand Israelchicheetsi tsiyatarangu: Nuw na siyaa Apanllee kamachtamarini ichingaru kamanirangina. Ashiri siysa anoo tuminungtsa. Ambinaariya ashkachus, uru pzapaneeyarus, siyamari ichingaroo tputs kasiru taatssa, yuwaa Apanll sirútama zitaminarneetsi; Nuw siyaam tsap panachintspa, tárangu anootsiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Itaru, yuwash Apanll Taarashipan siyaa 40 masach tsap upusap machirangu anoo mbizarintspa. Amb, upusap xitangat ashirangus, waana Apanll siyaa yachapi átu, ¿kamapari nuwamun mang' tatkeesinaya, nuwaa kuki payuchinllinaya? átu siyaa kiyung yacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Marizpa siyaa kiyung yacharangu, itaru anumunsha katungtsee manaa siyaam maritarangiya. Manaa nduntaa patarus, misha zitaminaris nduntam anoo patarusin, itaru siyaamsha maritarangiya. Apanll siyaa mangeemis p'tsimaam ashirangiya. Apanll tárangeeja. ¿Antaatiya tputs katungtsimunamari taarashish urutamash payutareeja? ndambari. Itaru, yuwamunari nuw kamachtaki anumunari urutamari taamaam taariya, Apanll waana siyaa mangeetsis p'tsimaama tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Siy ichingarus 40 masach upusap xitangat ashirangtaatis, nda minumtiyamis kamaris kucharangiya. K'tsitamtis nda manarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Tputs wipaa; kukeetsi payupanda, átu, wanitaru, uwsha Apanll siyaa ashirangtamta. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Ashiriya, Apanllee chinakus kukoo tatsamoongtsa. Kamachtamarinee tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Apanll siyaa tsap wanasirimshish wayachiya. Kungsha anush nda pshatachiya. Machshutam, tandsashtam ichingaru kung zaw shitangat ashkiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Anush maachi tatsumim zapan taariya; tiriku, sebaada, kizaruna, kpayunlli, munllina, wayungunu, mishat kindur taaritamta. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Anush tsap taakchus, ¿mayangazeeja siy mangis mantsachis? Katungtsingazitam, misha maachtangaztam tamaracheezis, ndambaree. Watam yuwashuri taakchis anshuri patumbchish wantsush ngusambaa mbammasheetsi pangatssa. Mishat, anshuritam machish, ngusambaatstam chumbeepimash yátssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ashiri anush kis taakus, ichingaru maachi nda siyaam pishtaku, katungtsitam katungkus, kapung tazazakus, itaru Apanllireetsis Taarashipan urutamari mbizarintspa. Uru, Wappari Apaa, tángtsa yuwamand siyaa tsapuneemis wanasirimshish wayarangu anumanda. Ashiriya, na kamaneena yuwaa Apanll, tputs katungtsimunamari taarasheem pinasakiya, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Ashiriya paptsa. Mangiptis taangtsa. Apanllee Taarashipan mbizarintspa. Urutamari waanaatsi kamachtamarini tuminungtsa. Na nuw siyaa kamaneenlli anuritam payungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Tsapurunasis kis taakchus, katungtseetstam katungakchus, kapung tazazakchus, misha pangitamtis wanasirish pangumash taakchus, ");
INSERT INTO cbuNT_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","chinitamtis wakararis, misha opeejaritamtis pzapaneekchusin, misha orootstam, kurikiritamtis, misha maachi payukis an pzapaneekchusin, ");
INSERT INTO cbuNT_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","siysa ngutis saanaatsi ungirtakus; Iyaanamunaricha wizpurini ashiranganiya, tárintspa. Watam ndatuma Apanll siyaa Ijiptosh tsap tashitungachu, siysa anush muchchureem taarangsa. Itaru, natsha siyaa tashitungarangu anumand siysa Apanllee mbizarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Apanll siyaa tsap apusap machtarangu, mkatam kasumash zapan taaru, ztunllitam zapan taaru, anumunsha kungutam waamaam ndunari amb machirangu, itaru Apanllsha waana kungoo patumbchish zaaw ashirangu anoo siysa waarangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Mishat, siyaa amb apusap machirangu, siyaam katungtsee martarangiya yuwaamshee nda katungats pataris, misha sirútamastaatiya zitamin nda pataru anumashee siyaamsha martarangiya. Apanll waana ashimaam siyaa waanaatsi mangoonamaama yapstarangiya. Amb ashishtar ashku, uru siyaa aranginasha istamaam chinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ashiriya, siysa; paptsa, átana. Mangishis shambatkus; Yaanamandaricha wizpurirni aship in maacheetsi payukani, átus, anoo pakchiyam chinarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Apanlleetsimari ichingaru zar chinangcha. Watam waana zandarangu siyaam tuwizpurtarangu, kapung maacheetsi payumaama panarangiya. Yuwaa sirútama zitaminarineetsis; Nuw siyaam tsapoo panachintspa, tárangu, anoo na siyaamsha panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Itaru, siysa waanariya apanllputseetsim chinakus, waatsimarisha ungirtakus, Apanlleetssha mbizakchus, uru Apanllsha siyaa izuuru kapeeteeru kasachiya. Nuw siyaa zurampatari atashina. ");
INSERT INTO cbuNT_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Apanllee kuk kapeetkachinaareesa, Apanllsha Taarashipan uru minpichchee tputs kachingarangu, siyaatssha ambitam ashtachiya, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Móysis; Apanllee kuk kapeetkachus, uru Apanllsha siyaa wanichintsa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Ashiriya, na Israelchichis mazinangantsa. Na in zar tatsameenlliya. Ortagoo kung arachich kitamaam waritayanlltanda. Anshuch tputs kizpursincha, siyaa kapung kasiriya. Mishat, yaktarini patumbichpat tandapunursin íwar kámanariya kapungu. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Anchich tputs wazuraneewsincha, watam Anakarinchichiniwa. Ashirucha, anchicheeru ichingaroo wazuranirini tputs waamari kasiranaya. Siysa yuwaa tputs ¿chakaja anchichpat tputs minumtiyam tatsamooch? átarana anoo siy yasartamtischa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Itaru, naakchus Apanllsha uwma sumas tamapari ashiru wasina yamazaru tapazip naachiya. Ashkachu, anush siysa mikeeru kundarareetsis kapeeteerus kasatssa. Kachich ptsa ashtaru ashinuri mikeeru kapeetatsa. Apanll nuw amb ashtachima tárangu, ashiri anuritam uru tatsameeru kasachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Ashiriya, Apanll waana kundarareetsis arap kapeeteeru, kasakchu, siysa mangishis; Yuwamand iy wanasiri taakani anumand Apanll iyaa kasimaam istarangiya, tárintspa. Anoo chinarintspa. Itaru, yuwamand Kanaanshuch mantsir taakana anumand ichingaroo tputs kapeeteeru kasachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","¿Nitaati siy uru wanasiri taakis, uru chinampanari taakis? Nda. Nda anumand Apanll siyaa tputsee kasimaam istak. Itaru, yuwamand an tputs ichingarusin yutarit taakana anumand arap kapeeteeru kasachiya. Mishat, waanaatsi kuk payumaam yuwaamsha sirútama Aprahamarinee, Isaakarinee, mishat Akoparineetstam tsiyatarangu, anoomsha tatsampi átu ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Itaru, siysa nda wanasiri chinamaam yasasa. Siy watam yutaritamsawa. Ashiritaa, Apanll Taarashipan tsapuneemis wanasiri panachapantsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Mazinangtsa; ¿Siy wanipaja Apanllee kuk kapeetarangis? Apanll siyaa Ijiptosh tsap yushurangu, apusapsha machirangunts, uru Apanllee kuk tuminumaam ngatarangsa. Na in zari wandaritam nda Apanllee kuk payuksa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Tsap mach Orebash taarangus, kapung Apanllee tatsiyuntarangus, Apanllsha siyaa kapung tsiyantarangu; Ashchiri kapeetchima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Itaru, nuwsha machip káreeranlluri, Apanllee kamachtamarini, yuwaa Apanll siyaa kamachtarangu anoo, patumbchimun yandamaa yati aturi, naatarangina. Nuwsha anush machip ichingaru 40 zar kaschir psaanpatatam aship taarangina. Nda pakchiyam katungaranguri, misha waamaatstam nda pakchiyam waarangina. Marizpatari taarangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Anushsha Apanll waana kamachtamarinee patumbchimun yandayaru, nuwaam panarangiya; yuwashtam ichingaruni machimun shaneeruni, machish sumas kurakataru anush Apanll iyaa waanaatsi kuk kamanirangiya. Anootstam waanaatsee kuk patumbchimun yandayaru nuwaam panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Ashiriya, 40 zar psaanpatatam tushiyramchu, anumun Apanll waanaatsee kamachtamarini patumbchimun yandamaa nuwaam panarangiya. Apanll siyaa kamachtamareetsi mangishis tuminungtsa, tárangu, anoo patumbchimun yandayaru, nuwaam panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Itaru nuwaam panayaru, nuwaatssha, Mikeerush wapitam karuweerush naatacha. Papcha, tputs yutaritarusina. Shiy tputsirish Ijiptosh tsap yushirangish ansha yusur na musásiri nuwaa kamachtamari kasaranganaya. ¿Na tamakimanaya? ¡Wakaraatssha orpat tinayarusin anootssha kis ungirtakanaya! tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Mishat, Apanll nuwaa tárangitamta; Na in tputsee yasayana. ¿Antaatiya nuwaa kuki payumaam yasarazinllinaja? Nduni. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Ashparita izuuru tpachingachima. Ashiri shiysha nuwaa, Watsta, tárinllpa. Amb ashkachuri, minshuch tputs Israelchichee izuuru mbizchinllinaya. Itaru, Móysisee shiyashcheetsimarisha tputsireemi pzapanichima. Shiyachchimarisha aranginasha pzapaneersin, kizpurinand kasiru taachinllinaya, Apanll nuwaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Itaru nuwsha; Xamachi Apaa, táranguri, machimand karuweeshinuri, Apanllee kamachtamarini patumbchimun yandam payururi karuweerangina. Machimunsha sumas kizpur kurakurtar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Karuweeshinuri, siyaatssha parangina. Apanllee kamachtamarini kasayarus yutaritshisheetsimarisha payurangus apanllputseetsimsha orpat wakaraam tinayarus, anootsimarisha ungirtarangsa. Apanllee kamachtamarini izuuru kapeetarangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Nuwsha yuwaatssha Apanll patumbchimun yandayaru, nuwaam panarangu anoo yáyaruri, ichingarus siy parus, wazawash kapeetarangina. Patumbchee chuweerangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Ashiranguri, nuwsha Apanllpa siyaam tsiyatamaam yusur wapitam machip naatarangina. Apanllpa siyaam tutunlltayaruri, tsiyatkuri, 40 zari psaanpatatam nda pakchiyam waakuri, katungkumaatstam nda pakchiyam katungkuri taarangina. Yuwamand siy Apanllee kuk kapeeteerus, yutaritshishish pshturangus, Apanlleetssha kapung tatsiyuntarangis anumanda ashirangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Ashirucha, Apanllsha kapung tsiyantarangu, siyaa, Kapeeteeruri kasachima, tárangu, nuwsha mazinaranguri, anoo kapung punirangina. Itaru, nuwsha Apanllee; Musámachi. Musá kapitinllpa, táranguri, Apanllsha yusur nuwaa kuki mazinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Ashiritam Aaronaa Apanll tsiyantarangitamta; kapeeteeruri kasachima, tárangu, nuwsha, Xamachi, táranguri, tapachindarangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Nuwsha wakaraa orpat tinayarus, ungirtarangis, anoo yáyaruri, sumasishsha mucheeruri kapeetarangina. Anumunsha kachizaramachsha yáyaruri, patumbichpa ichuweeyaruri, izuuru puzacheem ínarangina. Sheeru puzachee wazawash kapeeteeruri kasarangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Ashiritam tsap Taberash anumunsha tsap Masash, mishat yakat Kibrot-Hatawash taaranguni anshutam siysa yutarit taarangus, Apanllsha watsiyun musárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Anumunsha, tsap Kadés-Barneyash taaranguni, siyaa Apanll; Natunaa arangeem naangtsa. Nuwsha amb tsapooneemis panachintspa, tárangitaa, itaru siysa kapung ngatarangsa. Apanllimun nda mangis taturangsa. Apanll kamachtarangu anootstam nda payurangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Nuw yuwapururi siyapa naamaam chtarangi anpur siy uru Apanllee kuk ngat ngat ashirangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Ashirangutischa, Apanll siyaa kapung tsiyantayaru, siyaa kapeetamaam zandarangiya. Nuwsha anush tutunlltayaruri, ichingaru 40 zar psaanpatatam mangi mantsaranguri masharangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Apaa, tputsee musá kapitinllpa, watam shaana tputsirshawa. Ijiptosh tsap kiyung kachiyrangusin, shiysha shaanpata wizpurirish tapachindarangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Mishat, Aprahamarinee, Isaakarinee, Akoparineetstam mbizarinllpa. Na in nlluranuri shiyaa kukish payumaam ngatkitaatssin, yutaritshishush pshtut pshtut ashkitaatssin, anoo chinarinllpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Watam tputsireetsish kapeeteerush, kasakchush, Ijiptoshuch tputs shiyaa; Apanll tputsee iyash tsapuni tashitungarangitaa, tsapoo panachintspa tárangitaa, xapoorangiya. Mangutari tiptsiree natsaku, upusap macheeri tpachingapi atupa tárangiya, táchapsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Itaru, watam anoo shaana tputsirshawa. Ijiptosh tsap kiyung kachiyrangsin, shiy shaanpatatari wizpurirpatish tapachindarangshawa. Ashiri Apaa, nuwaa kukee mazinangandama. Tputsee nayaningcha; nuw Apanllee tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Ashiriya, Apanllsha nuwaa; Patumbich tsimbun táwar ashiru tatsamooru tsimooyarush nuwaam yushindangcha. Mishat, minum kajonee karipanpa tinangcha. Tinamaam iwaparamchush nuwap machip káreerush kusangi. Shiyapa tsiyatpani, ");
INSERT INTO cbuNT_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Nuwsha patumbchimun yuwatam ichtakachuri yandayaruri shiyaam panaranguri, shiysha anoo pátangarangish, anootstam tsiyatsis yusur yandachima. Shiysha anoo yakchush kajonish wanasir wayamachcha, Apanll nuwaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Ashiriya, nuwsha anuritam minum kajoneem yasin sur Akasiya mbammashi anoo tinarangina. Tinaranguri wayarangina. Anumunsha, patumbich tsimbun táwar ashiru tsimooyaruri, yáyaranlluri, machipsha káreeranlluri naatarangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Ashiriya, Apanllsha yusur patumbchimun 10 tsiyatsis kamachtamarinee yandarangiya. Yuwartatam ichtakachuri iyaam kamachtarangu, anootstam yandarangiya. Iy machish watandsash shaniyaranguni, Apanllsha sumasush tsiyatarangu, iysha anoo kuku mazinarangini, anootstam yusur yandayaru, nuwaamsha panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Nuwsha anoo yáyaruri, machip karuwarangina. Yuwashsha yasin kajoneem tinarangi anush pshtayaruri kasarangina. Na wandaritam anush kajonish taariya. Yuwartatam Apanll nuwaa kamachtarangu anuritam tatsamoorangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Nuwsha íwar machip taaranguri 40 zar psaanpatatam, yusur Apanllpa mashimashtar ashirangina siy kaminis. Apanllsha nuwaa kuki mazinarangu, nda siyaa tpachingamaam zandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Nuwaatssha, Na naayarush, shiysha wasina tputsireetsish imazayarush naangcha. Ashkachush, nuwsha tsap ipusarangi, yuwaa sirútama zitaminareetsis nuw siyaam tsapoo panachintspa tárangi anoo siyaamsha panayaruri tatsameeri kasachima, Apanll tárangiya nuwaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Ashiriya, Israelchichsha ichingarusin tsap Beroat-Bene-Jakan káyaranllusin, Moserapsha tsap naataranganaya. Anush kusarangsin, Aaronarini anshurisha tsiparangiya. Anshuritam mapeerangsin, kasaranganiya. Ashirucha, Aaronarinsha wip, Eleasar sur, apanllpaneem urkar uwsha kinarangiya. Waparish zamurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Yusur anumandsha káyarusin tsap Gudgotap naataranganaya; Gudgotamandsha káyarusin, tsap Jotbata yapsha kung zapan taaru ambsha naatarangsin anushsha kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Anushsha Apanll waana Leviyarinchichee tputs apanllpaneem ipusarangiya. Waama kajonarinee, kumaama ipusarangiya. Mishat, waanaatsi ungirtamaam, anamunsha tputseem Apanllpat tsiyatamaam ipusarangitamta. Natpursha zar ambiritam ashkanaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Ashirucha, amb ashirangsin, Leviychich tputs Israelchich tamapari ashiru tsapoo nda mazareem payukanaya. Watam Leviychich Apanllpat kuk mapeeksin taakanaya. Ashirucha, Apanllsha Leviychicheetsi, Siysa nuw kamini xunarus taakitaateesa, nuwsha uru siyaam istachintspa, tárangiya. Yuwartatam Apanll, Nuw siyaam istachintspa, tárangu anuritam uru kukoo tuminkiya, nuw siyaa Leviychich atina. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Natsha Israelchicheetsis, nuw siyaa minootssha kamanchintspa: ¿Siyaa Apanll may kamachtaka? Apanll ateeja; Nuwaatsimari chinangtsa. Nuwashumari tchitangtsa. Mangiptis kaapaniri nuwaatsimari ungirtangtsa. Mangishis kaapaniri chinayarus nuwaa mangoonangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Nuwaatsimari kuki tuminungtsa. Ashiriya, siysa amb ashkus, uru wanasiriri taatssa, átcha Apanlli siyaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ashiri na mazinangantsa; siy Apanlliris Taarashipan maacheetsee ichingaru tinarangu wayarangiya. Kanindaatstam, misha kanind arangeemtam, yuwash waana kasiru taaku anshutamta. Mishat, tsapurunaseetstam, ichingaroo yuwaa tsapurunasish pakis anootstam Apanll tinarangu wayarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Apanll wamari kizpur kasirtaa kurak taaku, itaru uwsha waana zandarangu, siyaa zitaminaris kizpur chinarangu, na anchicheetsis siyaatssha tiptsireem ipusarangiya. Nllitaritaa tputs nda ipusarangiya; siyachcheetsimarit ipusarangiya. Siysa na wand Apanllshitis tiptsiris taaksa. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Ashiriya, Apanllee kamachtamarini izuuru mangishis pshtayarus chinangtsa. Mangishis yutarit chinarintspa. Apanllee kuk payumaam ngatintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Watam siy Apanlliris ichingaroo apanllputseetstam, mishat kurakaatstam waamari kasiriya. ¿Chakaja Apanllpat tatsamooru taach? Wanindaja. Apanllee wizpur punimaam taariya. Tputsee ichingaroo tatsamooru napkiya. ¿Chakaja Apanllee kurikpa paxanxach, Istanda natu, neewa, apaya kurikee, tách? Anoo taamaam wanindaja. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Apanll, nlluraa mxaxzi chinaku, misha mashindootstam chinaku ashiritam tputsee ichingaru tatsamooru chinakiya. Arapchitam tunar tputs yuw siyash taaku anootstam chinaku watungasheemtam, misha watunireemtam panakiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Ashirucha, siysa tputsee arapcheetstaa chinangtsa. Watam siy Ijiptosh tsap taarangus arapchimuntamsawa, siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Ashiriya, siysa Apanlleetsimari chinangtsa; uwaatsimari ungirtangtsa. Tsasaritis taangtsa. Tputs shiyaa mashku, itsinsaru kamaningasinda tákchu, siysa zurampatari kamaningtsa. Apanllimun sur itsinsaru tsiyatangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Siy Apanlleetsimari chinakus ungirtangtsa. Apanll minumaritcha taaksha, siy Apanllirisa. Siyaa tapachindamaam wanip wizpurpat istaranga. Siy ichingurus Apanllee wizpur parangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Yuwapur sirútama siy zitaminaris Ijiptop tsap naatarangsin, anpur ichingaru 70 tputs taaranganaya. Itaru natsha Apanll waana siyaa pzapaneerangu, na siy ashparisha tsangach kanindpich patarich ashparisha pzapaneerangsa, Móysisi Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Apanll Leviychichee tputs apanllpaneem ipusarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Móysissha Israelchichee waneerangu, Siysa Kanaanash tsap kuskachus, Apanllee kamachtamarini urutamari payungtsa. Apanll sirútama zitaminarneetsi tsapoo panachintspa, waana tárangu, anoo na musá waanaatsi kuk tatsamchiya. Anoo tsap siyaam panachiya. Anushsha taakchus, Apanlleetsimari kuk payungtsa, nuw siyaa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Anshuchsha tputs taaraarutarana an apanllputseetsim ungirtakana. Siysa anoo kpitangtsa. Machimun iwaz, yasinshutam puch, yapamasaja pakchus, anootstam zurampatari pátangambeerus, kpitangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Ichingaroo apanllputsee patumbichpa tinamawaa anoowaatstam, wasumawaatstam pátang pátang sheerus, kapeetambayarus ksangtsa. Ashkachinaareesa, yusursha pakchiyam ayamtaatiya apanllputsee nda chinatssa, siyaa atina. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Siysa Apanllee Taarashipanee ungirtakchus, tputs tamakpasinaya ambitam shirintspa. Ngutis yuw saana zandkis anush Apanllee ungirtarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Itaru, Apanll waana siyachchee yaktarini ipuseeru, ungirtamaam wayachiya. Waana Apanll anshuri taachiya. Siysa anshumarisha ichingarus minumtashuri Apanllish ipusamarini ungirtakus taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Anshurisha Apanlleem maacheetsi muchingtsa. Saanamandari mangishis chinayarus, chinis wanasireewa an yushindangtsa. Apaz tirikoo 10 kóstar pusakchus, saama 9 kóstar yángtsa. Apanlleemsha minamtam kóstar wayangtsa. Arang saanitarisha mangishis chinakeesa, Apanlleem arangitam panachima, átus, anuritam panangtsa. Yuwaa káxiztakchuri kayanakchu anoo pusakchus, anootstam wayangtsa. Iwaxiztamarini chinis tatsipkachu, anootstam anshuri yakat yushitangtsa. Ashiriya, anshurtatam yakat Apanllee uru ungirtakchus, maacheetsi chineetsis muchingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Maachiritpatartis ashparitis shambatshisheem wayayarus shambatatssa. Anshurtatam yuwaa wayakis anoo ichingaru katungatssa. Apanllsha anoo pakchu, siyaa kisshaparee napchintsa. Yuwamand Apanll siyaam katungtseem istarangu anumand Apanllee, Wapparee, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Natsha in yuwash taakamchis anush Apanlleem chineetsis muchiksa. Itaru, anushsha zapish ayam taakchus, Apanllsha minumtashumarisha yaktaa ipuskachu, ambsha chineetsis muchitssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Nish apusa taakus, wandari anush tsap nda kusasa. Anush tsap Apanll siyaa wayachiya. Anush taakchus, kisshapari mapiyrus taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Kung Ortagu arachich kitkachus, anush Apanllish yaktarini Apanllee ungirtatssa. Kundariris nat siyaa taturpiritaa, itaru zapshina ndushapari kundarareetsis pakchiyam chinatssa; nduntam punitssa. Mapiyshapsa kis taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Anushshat Kanaanash tsap Apanll minumari yakat waana pangoom pangumaam ipuschiya. Anushsha siysa Apanlleem maacheetsi chineetsis yushindayarus, muchitssa. Anshurtatam Apanlleem kurikireetsis yáyarus, wayatssa. In kizpur wanasircha. Apanlleem kis panachima, mangishis átus, anootstam anush wayatssa. Yuwartatam kamanirangi anuritam anush kis Apanlleem tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Anushshat shambatshisheem wayakchus, ichingarus iparitamtis, m'chachuritamtis, Leviychichpatatamtis washunand shaniyeerus, anush Apanllee ungirtangtsa. Leviychich nduntaatiya watsapuneem yarangusin, itaru watam siyaptatam washunand taakanawa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Ashiriya, siysa mangiptis taangtsa. Piyaamawsha yapeew saana zandkis ambeewsha maacheetsi yáyarus muchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Itaru, Apanll waana minummari yaktaa ipuskachu, anshumari siysa uwaa kamachtamarini ungirtamaam tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Itaru, saana zandkus, pangishis chineetsis katungamaam waritariya. Chineetsis pachayarus, wanutsee mapiyrus ktungangtsa. Watam Apanll waana siyaam chineemis panaranguwa. Tputs nduntaatiya waanaatsi wanutsee Apanlleem yarku, ashiritaa, zamzeetspaz wanutsi ashirus mapiyrus chineetsis katungamaam waritariya. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Itaru, ursireetssha katungamaam watsta. Kungootspaz ashiru tuchumeerus kpitangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Itaru, siysa; In Apanlleempa átus, wayarangis, tirikootstam wanusi, wakaratam wip, iwaxiztakachuri iparinayaru anootstam, opeejaatstam, vinootstam, wayungunootstam, mayamasaja maachee Apanlleem wayaranginaareesa, anoo ichingaru saanshutari taarashis ktungintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Itaru, yuwashumari Apanll waana siyaam ipusarangu, anshumari ktungangtsa. Ichingarus iparpatartis, m'chachurpatartis, Leviychichpatatam tputs, ichingarus washunand shaniyeerus, shambatkachus, Apanllee tasaseerus ktungangtsa. Yuwamand Apanll siyaam istarangu anumand shambatangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Siy anshurtatam Kanaanush tsap taarus, Leviychichee tputs ayamtaatiya niyramaam chinarintspa; urutamari chinakus taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Ashiri wanutsee katungamaam saana zandkus, mapiyrus ktungangtsa. Apanll waana siyaam tsapuneemis panakchu, yuwaa tárangu anoo tuminkachu, siyaam panat, yusursha arangitam panat ashtachiya. Ashkachu, anushsha siysa taakamchus, mapiyrus wanutsee ktungangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Wandtaatiya Apanll yaktarini siyamand taarashis arap taaru, amb naamaam arap pinasakchus, saanshutari taarashis wakaraa, opeejaa pachayarus, anshuritam wanutsee ktungangtsa. Yuwari zandkis anuri ktungangtsa. Watam Apanll waana siyaa istarangu, chineemis panaranguwa. Yuw nuw siyaa kamachtayanlli anuritam shingtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Nduntaatiya tputs waanaatsi wanutsee yarku, ashiritaa katungamaam waritariya; opeejaa wanuts, manllan'seetsitam wanuts ichingaru katungamaam waritariya. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Itaru, ursiree katungamaam pakchiyam chinarintspa, watam an kuras taarashiwa. ¿Tamareeja wanutspasha washunand íseeruch katungchich? pinasakiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Ashirucha, kurasee yáyarus, kungootspaz ashiru kpitangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Katungamaam watsta. Uru ambinaariya ashkachus, wanasirpari taatssa. Iparitamtis wanasir taachinllinaya; watam Apanllee kuk wanasir tuminuksawa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Itaru, In maachi Apanlleempa táyanlleesa, wayanllus, Apanllish yaktarini ashparitis yushindayarus, Apanlleem panangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Anushsha, maachtaa ursir mangawash zaweerus, payutus Apanllushsha sum muchingtsa. Itaru, wanutseetssha anshuritam saana ktungangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Ashirucha, k'keetsi ichingaru mazinangtsa. Izuuru payungtsa. Yuwaartatam Apanll zandku anuritam tatsamoongtsa. Ashkachinaareesa, wanasir taatssa. Iparitamtis wanasirtam urutamari taachinllinaya. Apanllsha anoo kis napkiya, Móysis tárangiya. Na kamaneena yuwaa Apanll Israelchichee; Nuw siyaatsimari nuwaam ungirtamaam ipuseeri wayachima, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","30","Apanll kanaanshuchee tputs ichingaroo tpachingachiya. Tputsee kapeeteeru, siysa anush tsap taatssa. Anushsha taakchus, mangiptis taangtsa; anshuch tputs tamakanaya ambitam shirintspa. Yuwaatsitam apanllputsee ungirtakana anoo pakchus, siysa pakchiyam anoo chinarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Itaru, siysa Apanllee ungirtakus, anshuch tputs apanllputsee ungirtaksin tamakanaya amb shirintspa. Anshuch tputs wipaa kapung chinakitaatssin, ashiritaa apanllputseemsha ungirtamaam sumasish pshtayarusin, muchtaranaya. Itaru, anoo Apanll nda kis napkiya. Apanll anumashee tputs natsakiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Itaru, siysa yuwaari nuw siyaa kamachtarangi anuritam tatsamooru payukus tuminungtsa; arangeem tsiyatsis wayarintspa, Móysis Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Apaz siyashuch Israelshuch tputs minam, Nuw Apanllee kuk kamanimapantana. Siyaam tsiyatsis yuw Apanll ashtachu anoo kamanchintspa, tákchu, napuxtamashtaatiya yámandakchu, siysa mangiptis taangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","Yuwaa tárangu anoo zurkachinaariya, itaru yusur waantatamsha zapishsha siyaatssha; Apanllee tachitamaam kasayani, minumashish Apanllee tachiteeni, Neetsimaritana tputs Apanllirini ungirtayani, siyaa tákchinaariya, ");
INSERT INTO cbuNT_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","siysa yuwaa átu anoo pakchiyam kukoo payurintspa. Watam Apanll waana amb ashiru siyaam yachachuwa. ¿Kamapari zurampatartaya nuwaa mangpatari chinaksin, anoo ngichiz nda payuchinllinaya? átu yachachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Siynaa aranginasha Apanllee chinangtsa. Waanaatsi kuk tatsamooru payukus tuminungtsa. Mazinangtsa yuwaa kamachtarangu anootsi. Apanlleetsimarisha ungirtangtsa. Uru Apanlleetsimarisha chinakus ksutangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Ashiriya, yuw tputs siyaa mantsir tsiyatssee tayaspatarangu anootssha pachayarus ksangtsa, watam: Apanllee ksangtsa; nishunaa tputsish apanllirini tachiteeni, mantsir siyaa tayaspaku táranguwa. Itaru, Israelchichis, siynaa Apanlleetsimari chinangtsa, watam Apanll waana; Nuwashumari tchitangandama, tárangiya. Siy Ijiptosh tsap kiyung kachiykus taarangtaatis, itaru Apanllsha siyaa tapachindarangu, kapung istarangu, ¿mayaamshtaja nda chinachich? Ashirucha, tputs siyaa, Apanllee kuk ksangtsa atinaari, siysa anoo wáyangichirirpanee ichingaroo tpachingayarus ksangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Nduntaatiya ashiru, maachiritis mantsir siyaa tuchinaku, waa kuk pakchiyam mazinarintspa. Saantaatiya zuwanllis ashkachu, nduntaatiya saana iparis kamuz, misha iparis kizatam, misha izanlltaateesa yuw kizpur chinakis an mantsir apanllputsee tuchinaku, yuwsha amikuris kizpur chinakis ansha siyaa, Neetsinaa tputsee apanllirini ungirtayani, tákchu, pakchiyam mazinarintspa. Sirútama iyashuch zitaminataa apanllputsee nda yasarangusin, ¿mayaamshtaja anoo k'kuz chiysha mazinachich? ");
INSERT INTO cbuNT_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","Apanllputs zapantaatiya taaku, anush tachitintspa. Arapchitaatiya tputs, siyanungiritaatiya tputs taaku, tsapurunashuchtaatiya kizpur arapich tputs taaku, an siyaa tsiyatkusin, Iyaa apanllirini ungirtayani, uru táchpasiniya. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","Ashiritaa, siysat yuwaa atana anoo kuk pakchiyam payurintspa. Anoo tputs pakchiyam nayanirintspa; anungaz pakchiyam mangis mantsarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Siynaa anoo tputs pachayarus ksangtsa. Siyma ichtaru pachamaam chtangtsa yuwaa siyaa tputs mangu ngichirangu anootsi. Ashkachus, Israelchich tputs ichingarusin siy tamarangsa ambitam ashtachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Patumbichpa yáyarus, ashparitis tpaw tpaw shitarus, izuuru tsiparamchu kasantsa, yuwamand siyaa Apanllee ksangints tárangu anumanda. Siy Ijiptosh tsap kiyung kachiykus taarangus, Apanllsha siyaa tapachindarangu, tatutsirangiya. Itaru, tputs yuwsha siyaa, Apanllee ksangtsa tárangu anoo ¿tamareeja nda pachayarus kasachis? ");
INSERT INTO cbuNT_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Ashiriya, siy amb ashkachus, tputs ichingarusin Israelchich pakchusin, yasakchusin, anumashish pshtumaam punichpasinaya. Ndushapari yutaritshishee yusur chinachinllinaya. Ashiriya, na kamaneena yuwaa Apanll: Nuwaatsimari urutamari chinakus taangtsa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Móysis Israelchichee tputs waneeku tárangiya. Anush Kanaanash tsap kapungush siy taakchus, tputs mangutari ngichkusin, anshuchiri natstampani mangu atanaya tamapingapani atusina. Nuw wasina tuwacheeruri, yasaktana yuw ashtachu anootsi. Nimun minush zar ambpa ashtachiya táta ashkanaya. Ngichkana anootstaa, ashiritaa anshuch tputs kis mazinakanaya. Itaru, Apanll: Ngichimapanee tputs kuk mazinarintspa, átcha. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Apanll waana siyashchee tputs ipuseeru, nuw tamapari ashiritam wayachiya waanaatsi kuk kamanimaama. Siysa anoo kukoo izuuru payungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Sirútama Apanll tárangu, anuritam ashtachiya. Yuwapur mach Orebash shaniyeerus, anush Apanllpa tsiyatarangus; Na nimun yuwaa shiy, Apaa, wizpurirpatish tpuxtaru tsiyatkish anoo mazinamaam zandkeezini; sumaseetstam pamaam punikatanicha. Waanari na nimun yusur pakchinaareeni, izuurishapa tsipachiniya, tárangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Apanllsha siyaa, zuraktischa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Itaru, nuwaatssha; Nuwaana siyashchee minam tputs shiy tamapari ashiritam ipuseeri wayachima. Nuwaanaatsi kuki kamaningi, tákchuri, uwsha anuritam ichingaroo kamanchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Itaru, kamanipanee kuk nda tputs payuku, nuwaanasha anoo tputsee wanichima, watam an tputs nuwamun suri tsiyatchuwa, Apanll nuwaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Itaru, tputs wáyangichirirsha natstampan nuwamun suri tsiyateeru, yuw nda nuw kamachtarangi anoo tsiyatkachu, nduntaatiya ashiru apanllputsimunsha waani sur tsiyateeru, kamankachu, anootssha tputs siysa pchangtsa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","22","Ashirucha, siysa ¿Kaapaniritaja kamanimapan át? ¿Zurumamshee tsiyatak? tángtsa. ¿Tamayareezich chiy anoo tputsich natstachich yuwaa nda Apanllee kuk itsinsaru átu anootsee? atinaareesa, kaapaniri mangishis yasangimasints. Wandaya uwsha, Na nimun minush zar ambpari maachi ashtachiya, Apanllimun sur atina, atinaariya, an nduniya tatsamkachu, ashiriya an tsiyatsis nda Apanll kamachtarangu anoo tsiyatarangiya. Mangutari waanaatsi ungirtamaam amb ashiru tsiyatarangiya. Itaru, siynaa anoo pakchus, mangishis punirustarintspa, Móysis waneeku Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Apanll waana Israelchichee, Nuw siyaam minam tputs ipuseeruri wayachintspa nuwaanaatsi kuki siyaam kamanimaama, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Móysissha Israelchichee tárangiya. Minumari tputs, In tputs yutaritcha, atinaari, itaru nda tsimbun, nduntaati ashiru tuchip anoo k'kuz nda waanand átu, an tsiyatsis ngichiztanda. Itaru, tputs tsimbun, nduntaati tuchip k'kuz waanand átu, zurkutanicha atini tákchu an k'kuz wapta tsiyatkiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Ashiriya, tputs waanariya tayutaritamapan mangutari ngicheeru, tputsee nambku, yuwamand mantsir patatarangu anumanda atinaariya ashiru, ");
INSERT INTO cbuNT_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","Apanllip pang' naangtsa, watam apanllpantam urkari, misha yaktatam urkari anush shaniykanawa. Kurakaw ndaturi shitungaru wandari tarawaztakuritssin, ");
INSERT INTO cbuNT_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","anush kuskachus, yakatsha urkar anoo ichingaru wanasiriri mashchiya. Wandaya kurakush nabati átu, tputsee yushindarangu, mangutari arangeem ngicheeru, nda tatsamooru tsiyatsis wapta átu, ");
INSERT INTO cbuNT_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ashiriya anoo tputsee putayarusin wanichinllinaya. Amuyaatsirisha tputsee kiyung yachamaam chinarangu ambitam sheersin kasachinllinaya. Ashkatssin, izuuru an ngichizipan tputs kuk pastachshaparee. ");
INSERT INTO cbuNT_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Ashiriya amb ashkus, tputs ichingarusin yasakchusin, kizpurparee punichinllinaya. Ndushapari ngichzee mangutari arangeem tsiyatchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Chakaatsimasaja tputs wanimaam taariya anoo kaapa natstayarus, naynirintspa; izuuru tatsamooru waneerus ksangtsa. Wambaz tputs tputsee pachakinaariya, siysa pachayaritamtis ksangtsa. Wambaz tputs waratkinaariya, wachoo tsseekchu, siysa wachoo tsseeyaritamtis ksangtsa. Wapaz tputs nasishish tuzimku, naseetsish kurumbtakchu, siysa anoo wanasseetstam kuwayaritamtis ksangtsa. Waanariya kuweetsis tputs chpakinaariya, siysa uwee chpayaritamtis kasangtsa. Waanariya siyaa tputs k'tseetsis chpakinaariya, siysat utsee chpayaritamtis ksangtsa, Móysis tárangiya. Ashiriya, na kamaneena yuwaa tputs mangutari ngichkana anoo Apanll kamachtamarini itsinsampatari kamanku anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","Móysissha Israelchichee tárangiya. Tputs kizaa, Izanlleemi átu, izuuru wizanlleem yamatariya. Itaru, anumun zapishsha minush zar napku, wizanllee taarash ndusha wanasir taaku, wazaranllsha kirakaa kasamaam tuyandachiya. Wizanlleem kirakaa panayaru, izuurumamari kizaa kapeetchiya. Ashkachu, kizsha piyamsha naachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","Yusur minumunsha kamuz kiz zaranllkachu, antaati an yutaritaja. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","Anumunsha, kamuz tsimbunarini wizanllee nda kis chinamaam zandku, kirakaa yusur kasapi átu tuyandayaru, kasachiya. Kizsha yusur piyam naachiya. Nduntaati ashiru, wazaranll tsimbunarinee kanatspayanlliya, ");
INSERT INTO cbuNT_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","kizsha yuw ichtakachuri yamarangu anumun yusur kayuspi atinaari anoo watsta, watam an kiz minpasha tputs wanutsee itsachtayanlluwa. An Apanlleem yutarita. Anoomcha nuw siyaa atina; Siysa yuwash Apanll waana siyaam tsapurunasee kapung kizpur wanasir panakchu anush taakchus, wanasiririsha taangtsa, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Apanll, Kizaa yamayarus, itaru kasarangis anootstam yusur yamarintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","Móysissha Israelchichee tárangiya. Tputs kizaa kaneeschiri yamayaru, an pachamaam tapazip naamaam watsta. Mishat, arap tarawaztamaam watsta. Mangutari pangusshumari washunand wizanllpatamari chinaksin, minumari masach tsindas mangutari taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","Mishat, tputssha siyaa tumashtakinaari, anumand siysa yuw minam kchitamaam payuku anoow tusheetsi pátumbchiree itutsintspa. ¿Maypataja uwsha kchitayach? Ndunnaa katungku, ¿tamareeja taach? ");
INSERT INTO cbuNT_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","Mishat, waanariya siyashuch Israelchich tputs yap nda chinaris amb saanpatatis tputsis ngutis tamapingayarus, m'chuchureemis itarawaztamaam ínakus; nduntaatiya ashiru, minoomsha tputs muchchureem tupaxanxakus an yutaritcha. Yuw tputs ashku anoo pachamaam waritariya. Amb sheerus, yutaritshishpanee tputs chingayarus, ksangtsa saanpatatis, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","Mishat, tputssha tsutashshee payuru, wanuts kucha kucha ashiru, anoo punimaam taariya. Itsinsampatari apanllpanee urkar, Leviyarinchichee kuk payuchinllinpa. Yuwartatam nuw kamachtarangi anuritam tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Mbizarintspa yuwaa Apanll izareetsini Mariya wanguytarangu, anumand, Arap waanitam taachpa, tárangu anootsi. Ijiptosh tsap siy shitungarangus, upusapsha Apanll Mariyaa tsutashishpa tutsutayaru kasarangiya. Mariyushsha wanuts tsutashish tsutarangu, anumand Apanllsha Mariyarinee arap waanitam taamaam zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","Mishat, waanariya shiyaa tputs maachiritaatsish Natumasamaam istanda, átu, shiysha, Ayu átush, itaru, uwsha nda shiyaa ngichamaam waana maachiri taarinaariya, anoo yáyaru, shiyaam panachtampa. Itaru, amb ashkachu, shiysha anush tputs pang' shaantari pshtuyarush, maachiritaa in yachima átush, yarinllpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Itaru, anootsiri wishchipiri kutangcha. Uwsha waanaa amuyari waanshoo pang' pshtuyaru, maachirita yáyaritam, shiyaam panakchu, anoo shiysha yángcha. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","13","Mishat, wandaya tputs kizpur pukiri anoomaya natumasamaam payumaam panakush, uwsha, upunlluree shiyaamsha yáyaru, Payungcha, tákchu, shiysha, Ayu tángcha. Itaru, zar tapeekchu yusur waamatam upunlluree tuwanpungcha, watam an tputs upunllur ndunariwa. Ashirinaparee, tputssha upunllurish iripungayaru, kis maachiya. Ambinaariya ashkus, tputs siyaa kis napchiya. Apanlleemtam kizpur wanasir ashiksa. Anoo Apanll kis napkiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","Mishat, pukir tputs kiyung kachiyku, shiysha aranginasha kiyung yacharinllpa. Shiyaam tarawaztaku, shiysha izuuru natamari zarimand tuwapangcha. Wanasir shiysha chinangcha tamamasaja tputs siyashuch yuwaptaatis taakis anootstaatiya. Nduntaati ashiru, tputs yuw arapich siyash tsapunis kusatarangana anutaatiya amb ashkusin, itaru siysa ashiritaa chinangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Waanari siyash tputs tarawaztakinaariya ashiru, siysa anoom tputs mikeerus, ndaturi zar puru, urkireem yuwamand tarawaztarangu anumand tawapangtsa, watam an tputs pukir kurikee waama kchitamaam zandkuwa. Nduniya amb ashkus, uwsha anumand Apanllee mashkachu, siysa kapung yutaritshishish pshtutssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","Mishat, yuwamand tputs wip mantsir patatarangu anumandsha wapareetssha pcharintspa. Nduntaati ashiru, yuwamand wapar mantsir patatarangu anumandsha wipaatssha pcharintstampa, nuw siyaa atashina. Yuwaatsimari tputs mantsir patatarangu anootsimari pchangtsa. Nllitaritamunsha tputs msangeerus kisatamaam watsta. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","Ashiri tputs arapich siyash kuskachu, anoo tayutaritamaam pakchiyam chinarintspa. Nlluraam mxaxzee, misha kizaa mashindootstam kiyung yacharintspa. Maachi mashindoom panakinaareesa, anumand siysa mashindoo wachirkuree yarintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Na siysa kaapaniri mangishis chinangantsa. Tputsee chinampatari nayaningtsa, atina. Napa, siy Ijiptosh tsap kiyung kachiykus taarangus, Apanllsha siyaa naynirangu, yusheeru, na piyamsha wayarangiya. Ashirucha, nuwsha siyaa; Yuwaa nuw kamachtarangi anoo tatsamoongtsa, atina. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","Mishat, tatsumareetsis pusakus, tirikoo minum puch pzupuztamarini pusamaam mbizakus, yusur anungaztam kanapeerus yarintspa. Anshuri ksangtsa. Arapich tputs siyash tsapunis washunand taakis anshitisin, nllurtam mxaxzeew, kizatam mashindoow waani anoo uwshtisin yachinllinpa. Ambinaari ashkachus, uru siyaam Apanll aranginashapari yuwaa patatkis anoo istachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Mishat, mzarshis olivos wanus pusakus, kaapa izuuru pizpatari pusayarus, ichingintspa. Yuwaa katuchkis anoo ksangtsa. Tputssha arapichshitisin, mishat mxaxzeewtamsin, kizatam mashindoowa anoo waani yachinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Mishat, mzarshish kizarunaa tatsumareetsis pusakus, ashpari puch ichingintspa; yuw katuchkis anoo ksangtsa. Waani tputs arapich, nllur mxaxzeewatamta, kizatam mashindu anshitisin waani pusachinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Na siysa mangishis kaapa wanasir chinangtsa. Yuwapur Ijiptosh tsap taarangis anpur siy kiyungutam kachiyarangsa. Ashirucha, nuwsha na siyaa waneekina. Yuwaa áti anoo tatsamooru tuminungtsa, Móysis Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","Mishat, tputs yutaritshishee patatkinaariya, anoo tputs kurakap machimaam waritariya. Kurakshitisin anoo tputs natstayarusin, yuwaa tputs wanasirimshi anoo kasachinllinaya. Itaru, yuwsha tputs yutaritshishpanee anootssha waneeyarusin kasachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Ashiri wandaya yuwaa yutarit patatarangu anoo tputs pzkoomamaamtaya waritaru, kuraksha kamachtakchu, putayarusin, tsapumun tupshirayarusin, kurak amuyari naparu pzkoochinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Itaru, yanaru 40 arangeem tputsee ngutis kasiru pzkoorintspa. Anoo yankinaareesa ashiru, tputssha kizpur kiyung wasurimum kachiykachu, tsiyantakchu, kapunguri pazikchu, arapshaparee tsap shitungeeru piyam naachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","Mishat, chineetsish wakaraa kiyung yacharintspa. Wakar tarawzupan tirikoo tuchuwtaku, nayintaru anoo wakaraa ship kukpatari kamuririntspa. Waani yuwash tarawaztaku anush katungachpa; pchindintspa, Móysis tárangiya. Ashiriya, na kamaneena yuwaa Apanll kamachtamari zapan tsiyatssee kamanku anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","Móysissha Israelchichee tárangiya. Tputssha wizanll wanind zoonllpa washunandari pangus taakinaareesinaya ashiru, zapishsha kiz wazaranll tsipakchu, wip ndunariri kasakchu, anoo kizaa mashindoo piyartach tputs yamamaam wanindaja. Itaru, anoo waantartatam wazaranllin zoonll kizaa yamamaam waritariya. Amb sheeru, zoonllinaam wip izapanimaam taachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Kizaatssha mashindoo zoonllina wizanll izuuru yamayakchu, ichtakachuri iparinakchu, anoo zoonllinatam sur yásamachiya. Amb ashkachu, zoonllin wanuts nda pastachiya. Urutamari Israelash taachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Itaru, waantari kamuz zoonllinaa wizanll nda yamamaam zandku, kizsha kurakap naayaru, tsiyatssee kamanchiya. Kurakashsha kuseeru; Antaati mashichi nuwaa yamamaam zandkeeja. Iparinayaruri, zuwanlltamti sur ísamapi, antaati ateeja. Waani kchitpaz ashiru iparinayaruri, Israelash tsap taap, ateeja, kiz táchiya kurakshu. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Kuraksha anoo tsiyatsis mazinakchu, kamuzaatssha kuruzchiya. Kuruzeeru, anootstam tsiyatsis kaapa yasamaam tsiyatchinllinaya. Tputssha yuw nda máshinllee zandku an; Zurampataricha nuw áti. Antaati nuw mashicheetsi yamamaam zandkeezi, tákchu, ");
INSERT INTO cbuNT_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","kuraksha ichingarusin kizaa napatarandsin, anush kizsha máshinllee saptur yusheeru, wáchushsha kawachta ipazamaam ashtachiya. Sheeru, kamuzaatssha máshinllee: Shiyaa kapung ipazamaam ashkina, watam shiy zuwanllineemish maachiri arangeem pzapanimaam nda zandakshawa, táchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Ashiriya amb ashkachu, anoo tputs ichingarusin maachirita yasachshapsinaya. In tputs sur Saptur Yushishcha, táchpasinaya ichingarusin yakat Israelchichiya, tárangiya. Ashiriya, na kamaneena yuwaa tputs zoonll tsipakchu anoo kiz mashindoo zoonllirintam yamamaam waritacha, Móysis tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","Móysissha Israelchichee tárangiya. Apanll siyaam tsapoo panakchu, siysa anush kuskachus, saamatarisha anoo tsap amuytayarus taatssa. Anshurisha izuuru taakchus, ");
INSERT INTO cbuNT_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ichingaru masach tatsumaris ichtakachuri kayanakchu, anoo pusayarus, tsumburshis pshtayarus, Apanlleemsha wayangtsa. Yap Apanll waanaatsi ungirtamaam ipuskachu anush wayayarus, Apanllee, Wappari, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Anushsha apanllpaneem urkar panangtsa. Sheerus, Apanllpat tsiyatangtsa. Na nuw Apaa, zurampatari kamankina. Shaana nuwaa yasartamtish. Na taariniya yuwash shiy sirútama iyaam zitaminarineetsi, Nuw siyaam tsapuneemis kapung panachintspa tárangish anshu. Apaa, wapparee. Na mzarini taariya, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Ashiriya, yuwaa tsumbush payurish anoo apanllpansha urkar yáyaru, uwsha Apanllish wasum ungirtamaam wayachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Ashiramchu, siysa Apanllee itsinsaru kamaningtsa. Sirútama iy zitaminarini pakchimtaatssin masatarusin, Aramarinchichini taarangana. Sheeru, Ijiptoshsha tsap naatarangsin, anush taaranganaya. Taar ashirangsin, kapung waanaatssin wanuts zapan izapaneerangana; kizpuritam taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Itaru, Ijiptoshsha tsap taakuni, iyaa anshuch tputs kiyung yacharanganaya. Iyaa muchchureem ínarangusin, putayarusin, kizpur waneeranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Amb ashiru taakuni, Apaa, shiyaatssha masharanginiya. Shiysha iyaa k'keetsini mazinarangsha. Parangitamtish yuwaa kiyung kachiykini anootsi. Anshuri tuxaramani kiyung kachiykuni taaranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Shiysha shaanpata wizpurirish wanasiritaatsiri tuyamandarangsha. ¿Antaati tputs anoo patarazinllinaja? Anshuchee tputs kapung tpuxtarangsha. Amb sheerush, shaana iyaa tashitungarangish. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Iyaam na wanasirimshishsha tsap wayarangsha. Na nish kindurtam, wakaratam mimir kung ashiru naantangatu, anushsha iyaam wayarangsha. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Ashirucha, shaana iyaam panarangush, iysha na in wanusee kaneeschiri yusiyrangu anootssha pusaranguni, nish yushindaranginiya shiyaama, tángtsa. Tsumbootssha Apanllish suma wayayarus, Apanlleetssha anshuri tutunlltayarus ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Anoomsha zar shambatshisheem wayangtsa. Sheerus, ichingarus saana iparitamtis, izanllitamtis, arapchiptatam tputs, Leviyarinchichinpatatam washunand shaniyeerus, yuwaa Apanll siyaam panaku anoo washunand katungeerus, shambatangtsa, Móysis Israelchichee tárangiya. Ashiriya, Móysis, Tatsumareetsis wanus kachiztakchuri kayanaku, anoo Apanlleem wayangtsa, tárangu anoo na kamaneena. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","Móysissha Israelchichee tárangiya. Tuchparini masach tatsamkachu, siysa wanusee dies pusakus, minumtam waanitam Apanlleem wayangtsa. Apanlleempa, átus, zurampatari wayakus, tputsee arapchee yuw siyash tsapunis kusarangsin taakana anoom, tputs Leviyarinchicheemtam, nlluraamtam mxaxzeemaw, kizaamatam mashindoomaw watungasheem panangcha. Uwshtisin yuwari zandkana anuri katungkusin taachinllinaya. Ashkachus, shiyashuch nda minamtiyam marizimun kiyung kachiychiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Amb ashkus, Apanllee itsinsampatari tsiyatangtsa. Apaa, na wanusee pusarangtana. Pusaranguri, shiyaam wayarangina yuw shiy iyaam kamachtarangish anootsi. Ichingaroom tputs Leviyarinchicheem, arapcheemtam, mxaxzeemaw, mashindoomaw watungash yuw wayarangi anoo tuchingeeruri panarangina. Ashiranguri, yuwaa shiy kamachtarangish anoo ichingaru tuminurangina. Nda pakchiyam k'keetsis kapeetarangina; nda mbizarangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","¿Antaati nuw Apaa, shiyaa tayutaritarangeezi? Maachi tsipareetstam wayarangeezi. Apaa, shiyaa kukish tatsamooru payurangina. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Ashiriya, Apaa, shiy kanindash kizpur wanasir taakush, anumandari shiy tputsireetsish Israelchichee istangcha. Tsapuneetstamtish ksutangcha. Watam shaana panarangshawa. Nish wakar mimir, kindurtam kung ashiru naantangatu anush kis taakaniya. Yuwaari sirútama iyaa zitaminarni tsiyatarangish anuritam tatsamoorangsha, tángtsa, Apanllee tsiyatkus, Móysis Israelchichee tputs tárangiya. Ashiriya, na kamaneena yuwaa, Tatsumareetsis dies tsumb pusakchus, minamtam tputseemsha panamaam wayangtsa, Móysis Israelchichee tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","Móysissha Israelchichee tárangiya. Apanllsha waana siyaa kamachtachiya. Na tuminungtsa yuwaa tsiyatsis mazinakis anootsi. Yuwaatstam kamachtarangi anootstamta kaapaniri mangishis chinayarus, izuuru tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Watam na in saana wanasiritaatsiri Apanllee kamanirangsawa. Saana Taarashipanee, Apaa, shiyaa iycha Aparini. Shiyash nungishish tachitamaam zandaktanicha. Yuwaa kamachtarangish anoo k'keetsis tuminuchpariniya. Izuurupari payuchiniya, tárangsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Ashiriya, Apanllsha waana siyaa; Na in siy Israelchichis saanasha tsapoo amuytatssa, tárangiya. Yuwaari sirútama Apanll waana tsiyatarangu, anuritam tatsamoorangiya. Ashiriya, siysa Apanllee kamachtamarini tatsamooru tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Apanll waana siyaa ichingaroom tsapurunas kasiru wayachiya. Siyamari ichingaroo wanasirimshish taatssa. Yuwaari waana tsiyatarangu anoo uru ambiritam ashiru kisshapari taatssa, watam Apanll waana siyaa tiptsireem ipusaranguwa, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Móysis Israelchichee, Siyaa Apanll waana zandarangu, tiptsireem ipusarangiya, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","Móysissha Israelchichee tputs, Siy zurampatartaya Apanllee chinakus, kamachtamarineetstam tuminkinaareesa, yuwaa áti anoo k'kuz payukinaareesa, Apanllsha waana ichingaroo tsapuranas kasiru siyaam wayachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Ambinaariya ashkachus, Apanll waana siyaam kapung istachintsa; taarashish wanasirimish siyaamsha zanganchiya. Siysa kis taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","Ichingarus wanasir yaktash taatssa. Mzarshitamtis wanasirinand tatsumaris kanungchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","Ipartamtis ichingarus pzapaneeyarus, wanasirinand taatssa. Chinitamtis wakararis, opeejaritamtis pzapanintantssa. Yuw maachi chinis chinukis an zapan pzapanichinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","Tirikuritamtis nda siyaam katungamaam pishtachiya. Uru katungats tatsamooru kapung siyaam taachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","Apanll siyaa wanasireem ínakchunts, ichingaru yuw tarawaztakis an uru wanasirinandari shitungku taachiya. Apanll waana siyaam kapung istachintsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","Kundararis siyaa pachapani atusin, zapantaa tputs turututut shitanusin, itaru siyaatssha pakchusin, waantatamtisin punikchusin, piyamsha suwatartachinllinaya. Apanllsha waana siyamari kasimaam istachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","Siy zurampatartanaariya Israelchichis Apanllee mangoonkus ashiru, waanasha Apanll siyaam taarasheemish kis taamaam wayachiya. Yuwaa tatsumkis anoo wanasirinandari pusakus taatssa. Yuw maachi ichingaru patatkis an wanasirinandari shitungchiya. Apanll waana siyaamsha tsapoo panakchunts, anush mapiyrus kis xarashish ndunshaparee taatssa, Móysis Israelchichee tputs tárangiya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee; Nuw siyaam kapung istachintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","Wandaya siy Israelchichis Apanllee kamachtamarini nda payukus, nduntam tuminkus, uru siyash kiyung kachiyshish kuschiya. Apanll waana waneeshshee zangankachu, kiyung kachiykus urutamari taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","Yaktash taakus, kiyung kachiykus waneeshishsha taatssa. Mzarshitamtis nda kxunku, mariz kayatatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","Tirikuritamtis siyaam pishtaku, maringakus, marizimun kiyung kachiyatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","Ipartamtis nda pzapaneekus, wipashartis taatssa. Chinitamtis wakararis, opeejaritamtis ndusha pzapanichinllinaya. Yuw maachi chinukis an ashpari marizimun tsipachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","Maachi siy yuw tarawaztakchis an ndusha wanasir shitungchiya. Apanll waneesh amb ashtachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","Apanll waana siyaa kiyung kachiyamaam wayakchu, kundararshitis siyashchee kurak putayarusin, piyamsha tsap yapsha nda siy pataris, zitaminarinitamtis nda patarana ambsha siyaa machchinllinaya. Ashkatssin, anushsha taakamchus, minootssha tputs apanllputsirini ungirtakus taatssa. Yuwaa apanllputsee maachi yasin, patumbcheetstam tinakana anush siysa tumineertamtis ungirtatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","Anshuchshitisin tputs siyaa kiyung yachachinllinaya. Siyaa minumtiyam anshuch tputs chinachazinllinaja, ndambaree. Anush siyaa ichingaru zar ipazaksin taaratartantssa, Apanllee kasakchinaareesa ashiru, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Móysis; Apanllee kuk nda payukus, kiyung kachiykus taatssa, Israelchichee tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Móysissha Israelchichee tárangiya. Wandaya siy kis taamaam zandkus, Apanllee chinangtsa. Wandaya siy kiyung kachiyshishush taamaam zandkus, saana yachangtsa. Apanllsha siyaa waneekchu, nllitaritap arap tsap pseertarus taakchus, anushsha saani mangishis chinachintar ashkus, ");
INSERT INTO cbuNT_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","mangishis ¡Mayaamaja Apanllee kuk kapeetaranginee! tátssa. Itaru, yusursha Apanllee mangooneeruni, zurampatarisha Apanllee kuk payuyani, tákchinaareesa, Apanllsha siyaa yusur kis napchintsa. Na nuw siyaa wasina waneekuri, Apanllee kuk payungtsa, atina. Itaru zapshitaatiya, saantatam yusur Apanllish tachitkachus, zuramarpatarsha kukoo payukchus, ipartamtis anuritam tuminkatssin, ");
INSERT INTO cbuNT_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","4","Apanllsha waana siyaa nayaniyaru, yusursha siyaa kis napchintsa. Siyaam yusur wanasirsha saanpeetam tsapunis wayachiya. Wandatiya siy masaritaateesa, pseertatarus, arapeew piyam tsap, piyam tsap ashiru nxakamutpeew naatambarangus, Apanll waana siyaa nachungayaru, ");
INSERT INTO cbuNT_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","siyaa yusur yanpuyaru, waptam wayachiya. Yapitam sirútama zitaminarinee tsapoo panarangu anshutam wayakchu, mapiyshtis taatssa. Sirútama zitaminaris pzapaneerangana anoo aranginasha kasiru pzapaneeyarus taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Amb ashkachus, siy Apanllshtis tiptsiris taatssa. Ayamsha siy Apanllee yusur mangoonkachus, Apanll waanaatsi suru siyash mangishis yandakpaz ashtachiya. Amb ashkachu, siysa Israelchichis uru wanasirshaparee taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Ashkachu, Apanllsha siyaa waneeshishpa kiyung yacharangu, anumashpatam waneeshish kundarareetsshitis wanichiya. Yuwamand an tputs siyaa natsaksin kiyung yacharangana anumandsha Apanll kizpur wanichiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Ashkachu, siysa yusur Apanllee kuk payutssa. Apanllee kamachtamarini yuwaa nuw nat siyaa waneeki anoo kis tuminutssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Ashiriya, Apanll waana siyaa arang istachintsa. Tarawaztakchus, anush pzapanimaam istachintsa; ipareemis, chineetstamtis, wakarareetstamtis, mzareetstamtis tatsumareetstamtis an ichingaru pzapanichiya. Yusur siyaa kizpur chinachiya; ¿tamaru sirútama siyaa zitaminaris chinaranga? ambitam uru siyaa ashtachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Wandaya siy Apanllee kuk payukus, kamachtamarinee yuwaa kirakash yandam taaru anoo izuuru yusur tatsamkachus, kaapaniri mangishis chinayarus, itsinsampatarisha chinakchus, urutamarishaparee kis taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","Apanll kamachtamarini na nuw siyaam tayaspatarangi an ¿antaatiya mbamaja? ¿Antaatiya pishum taareeja? nduni. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Mishat, ¿antaati an tsiyatsis kanindpeeja taar? Siysa, Tamangsani; ¿chakaja iyamand kamini amb íwar káreeru, tsiyatsis amb yáyaru, iyaamsha panach? ¡Iysha anoo yasayaruni, annaa tuminuchshapariniya? tápis. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Mishat, ¿antaatiya kung mar arachcheeja Apanll kamachtamarini taar? Siysa; ¿Chakaja iyamand kamini nee kungoo kapungoo kiteeru, arachich tsiyatsis amb yáyach? ¡Iyaamsha panakamchu, iysha anoo mazinakurini, yasayaruni, tuminchinee? tápis. Nduni. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Apanll kamachtamarini siyash watsiritari taariya. Saanshutari kukis, mangishitamtis taariya. Ashirucha, nuw siyaa atashina, An tsiyatsis siyamand nda arap taariya Apanllee kamachtamarini tuminumaama. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","Ashiriya, mazinangtsa. Mangishis chinangtsa. ¿Tamamaatseeja siy ipuschis taarasheemis? Wandaya taarashish wanasirimash yapani átus, Apanlleetsimari zurampatari chinangtsa. Wandaya taarasheetsis kanatsipi átus, Apanllee kamachtamarini ngatangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Yuwaa nuw kamachtayanlli anoo payukinaareesa, kaapaniri mangiptartis Apanllee chinakus, Apanllish wanung tachitkus, Apanllee kuk tatsamoosha tuminkus, kamachtamarineetsi payukus, ashkachinaareesa, uru kisshaparee taatssa. Ipareemis aranginasha pzapanitssa. Apanll waana siyaam kapung istachiya yuwash tsapoo siyaam panakchu anshuya. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Itaru, ndunnaa Apanllee kamachtamarini payukus, tputseetsimsha kuk kis mazinakus, apanllputseetsimsha tutunlltayarus, ungirtakchus, ");
INSERT INTO cbuNT_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","Apanllsha waana tsipatsimash wayakchu, siysa mikeerus tsipatssa. Ambinaariya ashkachus, ¿antaatiya zapaneeja masach yuwash siyaam Apanll tsapoo panakchu anush taachis? Kungoo Ortagoo kitkitaateesa, itaru Apanll waana siyaa kapeetchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Ashiriya, na in, Apanll nuwaa kuki mazinaru, mishat siysa nuwaatstam kuki mazinartamtis, nuw siyaa itsinsaru waneekuri atashina. Siysa mangishis itsinsaru chinayarus taangtsa, atina. Saana sangtsa. Taarashish urutamashee ipuskachinaareesa, kisshaparee taarashish wanasirimish taatssa. Itaru, Apanllee kasakchinaareesa, yashingupshaparee naatssa. Apanllish wanasirimshish tachitkachinaareesa, Apanllsha siyaa istakachu, mapiyshtis kis taatssa. Itaru, Yashingush tachitkachinaareesa, kiyungshaparee kachiykus tsipatsiptarus taatssa. Ashirucha, nuw siyaa amb shirintspa atashina. ");
INSERT INTO cbuNT_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Ashiriya, Apanllee chinangtsa. Kukoo payungtsa. Apap nuwaa ksari pangpanda átus, taangtsa. Watam Apanllimunari wizpurini taakaniwa. Wanasirinaari taakus, urutamariparee taatssa yuwash sirútama siyaam zitaminaris Apanll tsapoo Apramarineemi, Isaakarineemtam, Akoparineemtam, Nuw siyaam tsapuneemis kapung panachintspa, tárangu anshuya, Móysis tárangiya Israelchicheetsi. Ashiriya, na kamaneena yuwaa Apanll Israelchichee, Nuw siyaam ayamtaa yusur istachintspa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Móysis yusur Israelchichee tsiyatpi átu tushaneerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","Tushaneeyaru; Na ichingarus mazinangtsa. Na nuw kizpur wachinayana. Masachiri 120 taariya. Arapeew naamaam waritakshtazi. Apanll waana nuwaa; ¿Antaati shiy kung Ortag arachich naacheezish? ndambaree, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Itaru, yap naakchis amb, siyaatsinaa Israelchicheetsis Apanll uru ksutchiya. Kundarareetsis tpachingakchu, siysat Kanaanush tsap taatssa. Anush Josueyshatanda siyaa imachints. Yuwaari Apanll siyaa tárangu ambiritam ashtachiya. Uwsha kurak Josuey siyaam ksutamapaneem taachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Apanll waana arapchee tputs ichingaroo kapeetchiya. Sirútama kurakaa Sihona mang wipunashpatari Ogaa Amorrewshuchee tpachingarangu ambitam ashtachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Anoo tsap Apanll siyaamamarisha kasimaam wayachiya. Siysa yuwaatsimari Apanll kamachtaku anootsimarisha payungtsa. Yuwari nuw kamachtayanlli anuritam siysa tuminungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Amb ashkachus, kaapaniri kizpurtangtsa. Tputsee punirintspa. Kundararpatis waratkachus, Apanllsha siyaam ksutchiya. ¿Antaati pakchiyam siyaa kasacheeja? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Móysis tsiyatarangu, ichingarusin Israelchich tputs napatarandsin, Josueyaatssha kuruzeeru tsiyatarangiya. Josueyaa, shiysha kizpurtangcha, watam shiytanda nee tputsee yap sirútama siyaam zitaminaris Apanll tsapoo panachintspa tárangu amb machchish. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Apanll waana shiyaa machchiya. ¿Antaatiya shiyaa pakchiyam kasacheeja? ndambaree. Ashiriya, ¿shiysha mayaatseeja yutamashi punikush, shaanaatsi muxareem ínachish? Móysis Josueyaa tárangiya. Ashiriya, na kamaneena yuwaa Móysis Josueyaa Israelchicheem urkar ínarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Nuwsha Móysisi Apanllee kamachtamarini wanasir yandayaruri, apanllpaneemsha Leviyarinchicheem panarangina, yuwaamsha Apanllee kajonarini ksutkana anoomshita. Israelchicheem kurak panarangitamana. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Panakchuri waneerangina. 7 masach tatsamkachu, siysat apanllpanis Apanllee kamachtamarini natstata, natstata shingtsa. Anshutam masach zar shambatshisheem tatsamkachu, anush Israelchichis támburishis ichingarus washunand shaniyangtsa. Anushshat, yuwaa tputs tumashtarangu anoo, Zuwaa, na, waani tumashirish pastachpa, táchinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","Anush masach ichingarus Israelchichis Apanllish pang' shaniyangtsa yuwash Apanll waama ungirtamaam ipusarangu anshu. Shaniykachus, tputs ichingarusin mazinarsin, siysa nee kirakaa Apanllee kamachtamarini natstangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Ichingarusin tputs kamuzawatam, kizawatam, nllurawatam, arapcheewtam tputs washunandari shaniychinllinpa. Siysa apanllpanis kurakis Apanllee kamachtamarini natstakchus, uwshtisin mazinayarusin, tatsamooru yasayarusin, Apanllee kuk tatsamooru tuminchinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Siysa iparis, nduntaa Apanllee kamachtamarini mazintarusin, anoo k'kuz mazinakchusin, yasayarusin, anuritam payuchinllinaya. Ndatuma tsiparsin, Apanllee kuk urutamari payuchinllinaya. Ashkachinaareesa, yuwaa Apanll, Nuw siyaam Ortagaa kung arachich tsapuneemis panachintspa, tárangu, anshunaaparee siy urutamari taatssa, nuw Móysisi Israelchichee tárangina. Ashiriya, na kamaneena yuwaa nuw; Ichingarusin Israelchich tputs mazinarsin, anush Apanllee kamachtamarini natstangtsa, tárangi anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Apanllsha nuwaa; Na shiy wachinarangush, tsipanish anazayanllshacha. Ashiri shiysha Josueyaa kuruzeerush, anpa ipuneerush, nuwap pangi naangtsa. Nuw siyaam anush tsiyatsis kamanchintspa, tárangu, nuwsha, Ayu táyaruri, Josueypa ipuneeranlluri, Apanllip pang' naataranginiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Kuskamchuni, Apanllish pang' msas tamapari ashiru wachunung mzeetaru, Apanllsha waana tputsee yakarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Apanll Móysisaatsi; Na shiy musásirishapari tsipachsha. Ashkachush, yusur arapich tputs apanllputseetsshapari ungirtakchusin, nuwaatsshapari izuuru kasachinllinaya. Nuwaa kuki ichingarusin kapeetchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Itaru, amb ashkatssin, nuwsha kapung tsiyantakachuri, izuurumaamarisha kasachina. Pakchiyam anungaz tputs mangi mantsacheezi, ndambaree. Ashkachuri, kiyung kachiyshish wayachina. Urutamari kiyung kachiykusin, kizpur mang' mantsaksin, taachinllinaya. Ashkatssin, mangush chinaksin ¿tamakeezini iy kiyung kachiykinee? ¿Apanll iyaa watstamaripa kasarangiya? táchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Itaru, anush zar nuwsha waatssin izuuru kasachina yuwamand aship yutaritshishee apanllputsee chinarangana anumandaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Ashiriya, shiynaa yaseesshish yuwaa kamankachi anoo yandangcha. Anoo yaseesshish Israelchicheem tayaspatangcha. Uwshtisin anoo yaseeksin, ndusha mbizachinllinaya yuwaa nuw waneerangi anootsiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Sirútama zitaminarneetsi nuwaana nayniranguri, Nuw siyaam tsap panachintspa, táranguri, na anush tsap Israelchichee wayachina. An tsap kizpur wanasircha. Wakar mimir, kinduratam kung ashiru naantangatu anush taariya. Ashkachuri, uwshtisin anush katungkatssin, kapung tazazayarusin, wanuts kapunguchinllinaya. Itaru ashkitaatssin, nuwaatssha kuki ngateersin kapeetchinllinaya. ¿Antaati iy Apanlleezini tiptsirinee? táchpasa. Sheersin, apanllputseetsimsha ungirtaksin taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Anumandsha, yutaritshishimand siysa kizpur kiyung kachiyatssa. Ambi ashkachus, siysa yaseesish seengtsa mangeemis p'tsimaama. Maachiritamtis arangeem chinllinis nee yaseesshish yaseeksin, uru mangush chinachinllinaya. Watam sirútamasari ndatuma siyaam tsapuranasee panachuri, wasina nuw chinasheetsis yutaritamashee yasarangina yuwaa nuwaa kasachis anootsi, Apanll Móysisee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Ashiriya, Móysis natam yaseesshshee yandayaru, Israelchicheem yasamaam tayaspatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Josueyaatssha, Nomarineetsi wip, Apanll tsiyatssee kamanirangiya. Josueyaa, shiysha kizpurtangcha. Shiytanda nee tputsee Israelchichee machchish yap nuw tsapoo panachintspa tárangi ambi. Nuw shiyaa urutamari ksutchinllpa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Móysisarinshini tsiyatssee kirakash yandamaam iwaparamchu, ");
INSERT INTO cbuNT_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","Leviyarinchicheemsha Apanllee kajonarinee ksutamapaneem, ");
INSERT INTO cbuNT_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","Neewa, kirakaa Apanll kamachtamarini. Nee kirakaa yáyarush, Apanllish pang' Apanllinungiri kajonarini yandamaa wayangtsa. Ashkachus, tputsshtisin anoo pakchusin, Apanll zurku iyaa atiya. Iy uru yutaritshishee chinakaniya, táchpasiniya. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Nuw siyaa izuuru yasaktana. ¿Antaatiya siy izuuru Apanllee kuk payukeezis? Nuw kchitaati, nda Apanllee kuk payukus, nuw tsiparamchinashtazi, siy ¿Apanllee kuk payuchis? ");
INSERT INTO cbuNT_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Ashiriya, na in ichingarus shaniyangtsa. Yuwis kurakawis anis, ashparitis washunandari shaniyangints. Nuw wanasiritaatsiri waneekchuri, anoo mazinangtsa. Apanll yuw nee tsapurnasee kanindpatari tinarangu an mazinartam wanasiritaatsiri kamanchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Nuw siyaa yasaktana. Uru nuw tsiparamchuri, Apanllee kuk tayutaritatssa. Ashkachus, yuwaa Apanllish tachitkis anoo izuurupari kasatssa, yuwaa nuw siyaa Apanllee kuk payungtsa, tárangi anootsiya. Ambinaariya ashkachus, siyaam urutamaripari kiyung kachiyshish taachiya, yuwamand Apanllee kuk kapeetarangis anumandaya. Siyaa Apanll tsiyantakachu, kizpur wanichintsa, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena, nuw Móysis tsiyatssee iwatsparangi anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Ashiriya, Móysis yaseesshee tayaspatarangiya. Yuwash ichingarusin Israelchich washunandari shaneerana anush yaseesshee chtayaru, yuwamun iwatspakamchu anush kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","Na Apaa, shaana mazinangandama; watam shiy kanindaatstam, tsapurunaseetstam tinarangshawa. Siysa Israelchichis ichingarus kaapaniri nee mazinangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Na nuw tsiyatkachuri, sin sinaku zapan paratzatariya. Púranas tamapari ashiru pzeezakchu ichingarumun chirichir kachachtachiya, Ichingarumun mashar xuwattaru uru amb ashtachiya, nuw siyaam tsiyatkachurina. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Ashiri na nuw Apanllimun Taarashipanimun sur tsiyatkachuri siysa mazinangtsa. Apanll Taarashipan wizpur kapungcha. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Watam Apanll iyaa urutamari ichingaru zar ksutku taakiya. Ichingaru yuw waana ashirangu an wanasirinandaricha. ¿Antaati Apanll ngichtareeja? nduncha. Mishat, nda minumtaatsim tputs chinakiya. Ichingaroo tputs minumtaatsiripaz ashiru chinaku taakiya; watam uw itsinsampaniwa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Itaru, siysa Israelchichis tputsis yutarittischa. ¿Antaatiya k'kuzee payumaam yasareezis? Ashirucha, yuwaa tputs amb ashkana anoo Apanll ¿antaati Nuw ipartana, tácheeja? ndambaree, atiya. Apanlltaa siyaa tinarangunts, ashiritaa siysa waa kuk kapeetaksa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Ashiriya, yuwamand siyaam Apanll aship istayaranllu anumand pakchiyam wappari támaamayam nda zandaksa. Siyashuch pakchiyam nda wanasir chinamaam yasaksa, watam siyaa waana Apanll tinaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Ashiriya, na kaapaniri mangishish chinangantsa yuwaa Apanll sirútama tamayaranlleeja anootsi. ¿Wandaya anoo yasamaam nda waritakus? Ashiri apareetsshitis mashangtsa, nduntaatiya ashiru, siy maachiritaatsis kizpur wachina, pachireewatsis saanpata mashangtsa. Uwshapari siyaa ichingaru kamanchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Sirútama Aparich waamari kasiru, tputsee tsapuranasshuchee ipuseeru, piyam waanandaritam zangankachu, minootssha piyam waanandaritamsin zanganta, sheeru watsapuneemshitisin minumtawamaritamsin panambarangiya. Itaru, Israelchicheetsim kizpur chinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Apanll uru wasina iyaa Israelchicheetsini waama tiptsir ipusarangiya. Ashiri anchicheetssinaya ashiru, Nuwpari tputsirina, tárangiya Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Waana iyaa ksutarangiya. Yap kung ndunari ambtaa naataranguni, kambusur kizpur kambustarangitaa, zaritam kizpur zatarangu ksaneerangitaa, Itaru, Apanllsha uwish itakpaz ashirangiya. Anush iyaa wanasir tayaspatarangiya, Tputs wipaa kizaa kizpur chinaku tamatarparee ashiru, Apanll iyaa ksutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Kpurangamash maachi yungan wipaa purangamaam tayaspatapi átu, wipaa wixtamarimand yachamaam turpuyaru, Yusur waantatam, Naringapi átu, ushimun wipaa chipata sheeru, yusur waashtam wayataru, ambitam Apanll iyaa ksutku ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Apanll Taarashipan waana siyaa wanasir ksutarangiya. ¿Antaati apanllputs minumtiyam amb ashtar? Nda. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Itaru, Apanll wamari siyaa amb ashiru ichingarootsis wanasir ksutarangiya. Anush tsapuranas ichingaru maachi katungats wanus wanasirimshinand taariya. Kinduratam patumbchish wanasiritawaatsiri tsutarutariya. Siysa anoo yáyarus katungatssa. Olivoo yasina wayungun yachtamsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Wakararis pzapaneekchus, mimiree yáyarus, waakus taatssa. Kaaparaatstam, opeejaatstam karupana wanuts katungkus kis taatssa. Chinuz Basanamand tsap kizpureew wanasireew kuschu anootstam katungatssa. Tatsumartamtis tirikuris kizpur wanasir kxunkachu, wanusee pusatssa. Kizarunaatstam tatsumeerus, pusayarus, tiringeerus, wakunguree vinoom yáyarus, waakus, kizpur wanasir taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","Itaru, siy anush tsap taakchus, nutsis kapunguyarus, yunganteerus, mangis kis Apanllee ngatkus, wakar tamatarparee ashirus, Apanllee kata, kata ashikpaz ashitssa. ¡Maya! Kizpur yungantkachus, wakar ashirus nutsis kawapshishtarus taatssa. Ksataa taakus, katungkus, kurikpaneemtam kinakchus, Apanlleetsshapari ungirtamaam kasatssa. Apanlltaa siyaa tinarangu, tapachindarangitaa, ashiritaa siysa Apanllee niyratssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Siysa apanllputsee mantsirimshee ungirtakus, Apanllsha anumand kapung tsiyantakiya. Watam siyaa kizpur pachindku, Nuwaatsimari chinangasindama, atuwa, anumand siyaa wanichapantsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Wakarareetsis pachayarus, muchkus, yashingootsimari ungirtakus taatssa. Mangishis chinakus; In apanllputs kaneesichcha. ¿Nee apanllputsee antaati iy zitaminarani sirútama patarazinllinaja? táyarus, mapiyrus anootsimarisha apanllputsee ungirtakush taatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Nuw siyaa Israelchicheetsis atashina: Aparich waana siyaam taarasheemis wayarangitaa, kizpur wanasir ksutarangitaa, itaru siysa Apanllee kuk izuuru kasachpasa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Ashkachinaareesa, Apanllsha waana siyaa pakchu, wipaatstaa tsiyantayaru, nda kis napchiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Apanll kuk ateeja; Na nuw siyaa mangutarishti arapeetari napchima, Ashkachuri, ¿mayaja siyash tushiych? pangpani. Siy kizpur yutarittischa tputsis. Siy nllur mang' ndunari tamatarparee ashiris anoo ¿tamayareezich? ¿mangich tateechich? Pinascha. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Siysa mangishis piyari chinarangus, In watanacha iy Apanllirini, tárangus, apanllputseetssha ungirtarangis anumand nuwsha kapung siyaa tsiyantarangina, watam nuw siyaa pachindkinawa. Ashiriya, nllitaritaatssha tputs yuw nda nuwaa yasarana anootssha nuwaama tputsireemi ipuschina. Amb ashkachuri, siysa nuwaa pachindkus, anumand tsiyantachpasa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Nuw kizpur tsiyani musákuri, mangishi sumas tamapari ashiru muchkiya. An sumas tirookchuri, ashpari tsapoo, yasinawaatstam ichingaroo muchchiya. Tsapoo wanshucheewaatstam muchchiya. Macheewtam ichingaru paratungachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","Ashiriya, siyaam ichingaroomis kiyung yachamaam waneeshish zanganchintspa. Nuw tsiyani musákchuri, wasapaatspaz ashiru siyaam tiyanchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Marizimun tsipatssa. Kurapamuntam wanguytakus, tsipatssa. Tsutasheetstam tsipatsimash zanganchitamana. Ashkachuri, uru tputs tsipatsiptar ashtachinllinaya. Tumuzeetstam kázamshee zanganchitamana. Mkaatstam kasumashee zanganchitamana. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Kundararshitis sundarureetsis pachakchusin, ngootsish tamutamuru anootsimsha pangatssa. Yap nda chinaris amb pangishitis pshtuyarusin, siyaa pachachinllinaya. Kanungaseewaatstam, kamasinawaatstam, kizpur wachinawaatstam, kanxuri mimee mitkuritaa anootstam, pachachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","Nuw mangishi chinarangtana. Siyaa arap zangankachuri, saani arap pseertarus, ambiri pastatssa. Ashkachuri, ndusha nuw siyaa ayamtaati chinachintsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Itaru, nuw amb ashkachinaareena, kundararshapsa nuwaa mantsir stachinllinaya, atutana, Nuw siyaa, Watsta, tárangina. Iyamaricha kasirangini; iy watam kizpuriniwa, ashirupariniya. Iyamari tachiyaranginiya, táchpasinaya. Nuwaatstam; ¿Antaati Apanll waritareeja? Uw ¿tamaycheeja yuwaa iyamari kasirani anootsee? táchpasinaya kundararis nuwaatsiya. Ashirucha, nuw siyaa izuurina nda kapeetamaam zandkina, Apanll mang amb tárangiya siyaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","¡Siy Israelchichis mangsharitischa! ¿Tamasha Israelchichis nda kitsis mazinaksa? ¿Tamasha nda mangoonaksa? ");
INSERT INTO cbuNT_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Siy mangiptanaareesa Apanllee kuk payukus: Papcha. Apanll iyaa kizpur waneeruneepa, táchinaapsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Na mazinantsa, Sirú ¿tamarinaa siy minumtaatis sundaris minumtaa milo kundarareetsis kasirangsa? Mishat, ¿tsimbunandtaatis sundaris kundarareetsis 10 milootsinasha kasirangtamsawa? Apanllimun siy mangis taturangus, Apanllsha siyaa kizpur wanasir ksutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Kundararini yasaksincha, watam Apanll waana tiptseereem istakuwa. Apanllputssha nda uwaamin istakiya. ¿Uw apanllputsirini iyapa Apanllirini nda waritakuwa? ");
INSERT INTO cbuNT_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Watam iy kundararini taarash kizpur yutaritssincha. Sirútama tamaru tputs Sodomshuch misha Gomorshuchtam taarangana ambitam ashirusin taakanaya. Waanpatatin tayutaritkana. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Vinoo kizpur kanashayarusin, makpaz wasun ashiru anpa tputsee tayutaritkiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","Apanll waana ateeja: Yuw ashkana anoo ayamtaatiyam mbizcheezi. Maacheetsipaz wayayaruch ashiru, natumasamaam tputsee napkina. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Yuwash zar tatsamkachu, anush nuwshat siyamand tistakachuri, kundarareetsis wanichima. Amb ashkachuri, uwshtisin tsapush ashparitin paraat ashtachinllinaya. Anshuri mikeeruri ashparita kachingeeruri kasachima, átcha Apanll siyaa kundararis. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Siy Israelchichis wizpuris nduneekchu, Apanllsha waanaa siyaam tiptsireemaru tapachindachiya. Siyaatsinaa Apanll Taarashipan naynikchu istachapantsa. Yuwash siyashuch kurakaris ndunareekchu, sundaruritamtis ndunareekchu, anush Apanllsha siyaam istachiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Kundarareetsshitis Apanllsha, ¿Natuwa, apanllirisawa? Yuwamun siy mangis taturangus, ");
INSERT INTO cbuNT_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","wakarareetsis pachayarus, anpat ungirtarangis ¿anuwa? Apanllputsireemis vinootstam waayarangis. ¿An na yapinaaree, natuwa? ¿Mayaamsha nda an siyaam tapachindaka? Watam siy anumun mangis tatuksawa. ¿Nda siyaam istakantsa? Apanll kundarareetsis táchparee. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Ashiri siy nuwaa kuki mazinangtsa, Nuw minumaritana Apanlli. ¿Antaati min nuwamand kasiru apanll wanindaja? Nuwaana tputsee, tsipachpa tákchuri, tputs tsipakanaya. Waani in tputs taachpa, tákchuri, tputs urutamari wachinayaru taakiya. Nuwaana, tputsee in kiyung kachiyachpa, tákchuri, tputssha anuritam kiyung kachiykiya. Mishat, tputs kas yutakchu, anoom nuwaantatam yarkina. ¿Antaatiya nuw kuki minumtiyam pastamaam wanindaja? izuuru tatsamkiya, átcha Apanlli. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Nuw urutari sirútamasari taaranguri, ashiritam urutamaritam taachina. Nuwaana kuweetsi íwar paxayeeruri, ichingaru wizpurirpatarti zurampatari tsiyatchina. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","Ashiriya, mchitareetsi kurakurtaru anoo yáyaruri, wanasir iwitseeruri, anpat siyaa kundararis ashparita tpachingayaruri kasachima. Waanamand yutaritshishirini nuwsha kizpur wanichima. Yuwamand nuwaa kapung natsakana anumand nuwsha tpachingachima. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","K'chirpungarimuni ashchiri kuras xatangamchiya. Mchitarpashti ichingaroo tputs much turuyaruri, kasachina. Tputs ursir zapan xatachiya: putamawaatstam kayung, kurakawaatstam kayung, pachat, pachat ashtachina, yuwaa sirú kundartarangis anoo ichingaroo kiyung yachachima. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","Ashiriya, siynaa ichingarus tsapurnasshuchis Apanllchichis washunand Israelchichpat mangis ksangtsa. Yuwamand iy kundararini iyachchee tputs pacharangana anumand ashparita chingayaruri kasachima, watam Apanll waana atuwa. Amb ashkachu, ichingaroo tputs yutaritshishpanee ashpari kachingeeru, wanasirinandsha Israelash tsap taachinllinaya, Apanll átcha, Móysisi tárangiya. Ashiriya, na kamaneena yuwaa Móysis yaseesshee tayaspatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Ashiriya, Móysis Josueypat, Nomarinpatini wip ipuneersin, washunand yuwash Israelchich ashpartin tputs shaneerana anush yaseesshee ashchiri natstaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Natstayaru, ichingaroo Israelchichee; ");
INSERT INTO cbuNT_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","Ashiriya, na in zar tsiyatssee Apanllee kuk ichingarus mazinayarus, mangiptis chinangtsa. Ipareetstamtis tayaspatangtsa. Nee tsiyatsis wanasirimshee, Apanllee kamachtamarini urutamarisha payungtsa. ");
INSERT INTO cbuNT_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Mangutaritis iwaziri mazinakus, ¿ashinooja mangoonchis? Kitsiptis izuuru mazinangtsa. An Apanll kamachtamarini siyaam taarashishcha. Anoo tsiyatsis payukinaareesa ashiru, Kanaanash tsap urutamaripa zapan masach taatssa, yuwash Apanll siyaam Ortaga arachich panachintspa tárangu ambiya, Móysis Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Móysis Israelchichee yuwamunarisha iwatspakamchu, waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Móysisarini Apanllee kapung chinarangiya. Ashirucha, ndatuma tsiparu, ichingaroo tputs Israelchichee tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","Apanll kuk waana kamachtamarini Sinayamand káyashinu, sumaspaz ashiru Seirapsha tsap iyaa tuwaseeneerangiya. Sheeru, Paránapsha tsap iyaa machtarangu, iysha Meripa-Kadésash kusaranganiya. Wasundarurpa iyaa tapachindamaam machtarangiya. Waana kuk sumas ashiru uwish payuru, iyaa tiptsireem ínarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Apanll waanaatsi tiptsir kizpur chinakiya. Tputs Apanllee ungirtaksin, waanaatstamari tutunlltayaru, Apaa, istangandama átu, Apanllsha waama wamachtasheem wayakiya, Móysisarini Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Táyaru, Yuwash Israelchichini ichingaruni shaneerani anush Apanllee kuk kamachtamarinee panarangiya. Iy Israelchichini uru Apanllee kuk kis payumaam chinakaniya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Iyashuch kizpur kurak arang wanindaja. Anpur yaanandari wachinanandaritani shanee ashiranganiya. Itaru, iyashuch na kurakarini kizpur Apanllimarisha taariya. Watam na waana kuk iyaam kamachtaku, iy kurakarini kchitpaz ashiru iyaam tapachindakuwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","Shaneerani anush, Móysisarini Rubenchicheem nlluranur Apanllpa mashku, Apaa, shiyaa mashkina; Rubenchicheem nlluranur istangcha. Maachirit anchich urutamari taachpa. Anchich maachirit pakchimtaateesinaya taaksin, itaru shiysha ksutangcha, Apaa, Móysisarini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Ashiriya, Móysisarini Utaáchcheemsha Apanllpa masharangtamta: Apaa, shiysha Utaáchcheem maachiri istangcha. Shiyaa, Istangasindama, atusin, shiysha istakchus, Zoonllpa Israelchichpa uru kis taachinllinaya. Shiy Apaa, tuwizpurtangcha, undararpa waratkatssin waamaritin kasimaama, Móysisarini Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Móysisarini Leviyarinchicheemsha nlluranur Apanllpa tsiyatarangiya: Apaa, shaana Leviyarinchichee ipusarangsha shaanaatsi kukish kamanimaama. Sheerush, shaana wichee tsimbun Urim, mishat Tumim ashiru panarangsha anpa shiyaa chinashish yasamaama. Watam shiyaa nda kasaranganawa. Shaana Apaa, yap kung ndunari amb tputsireetsish apusap yacharangsha; ¿Kamapari nuwaanaatsi kuki payukeesinaya? átush, patumbich sur Masa, misha Meriba anush nuwaptatam kusaranguni, shiysha kungoo iyaam patumbchish ishitungarangsha. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Ishitungarangitaatish, tputs shiyaa yutaritam ínarangana. Ashirucha, Leviyarinchich tputs shiyaa kukish payurangusin, Waparee, wanireetstam, zuwanlleewatstam, wipaatstam chinarangitaatssin, itaru waanamandari yutaritshishirini pacharanganaya. Natsha shiyaa kukish payumaam kizpur zandkusin, aranginasha shiyaa mangoonaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Na in uwshtisin shiyaatsimarisha kukish kamankusin taakanaya Israelchicheem ichingarooma. Na shiyash pangish uwshtisin maachta kzammashee muchkanaya. Wakaraatstam, misha opeejaatstam yuwash patumbich anpaneemari wayama anush wayayarusin, shiyaam ungirtamaam muchkanaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","Apaa, shiyaa ungirtaksin, shiysha kis napangcha. Istangcha shaanaatsi kukish wanasir kamanimaama. Sheerush, undarareetsshitisin ichingaru shiyshat ushee tok tupta sheerush, pachayarush, ashpari ksangcha, yusur nda antam yaanaatsi támeeru tistamaama, Móysisarini Apanllee Leviyarinchicheem mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Móysisarini Benjaminchicheemsha nlluranur Apanllpa mashku: Apaa, shiy Benjaminchichee tputs kizpur chinaksha. Ashirucha, uwshtisin urutamari wanasir taachinllinaya. Shiyaatsimari chinakanaya. Watam shiysha urutamari ichingaru zar ksutkush taakshawa, aranginasha urutamari ksutkush taangcha, Móysisarini Apanllee mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Móysisarini Osiyarinchicheemsha nlluranur Apanllpa masharangiya: Apaa, shiysha Osiyarinichicheem nlluranur watsapuneem wanasirimish panangcha. Sheerush, sinaa tsapush zanganingcha. Tsapootstam kung waantsshuchee waakamaam zanganingcha. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","Ashkachush, tátsumarsha wanasir kxoonchiya. Uwshtisin ichingaru tsup wanasir pusachinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","Anootssha tsap watam shaana sirútamasari zitiminarneem panarangshawa. Ashiri anush tsap machish wanasirimshish uwshtisin urutamari taachinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Waashumarit watsapun katungats pzapaneeyaru tatsitku taachiya. Yasin wapar zapanimash pakich xiyaru anush shiy wizpurpatish taturungayarush, nuwash yakarangsha. Shiysha Apaa, shaana zandkush, kamaparee Osiyarinchicheem istatssha. Nee ichingaru tuminungcha, watam shaana Israelchicheem tapachindamaam Osiyaa ipusarangshawa. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Osiyarinchich tputs wakar wip karupanari tamatarpari ashirusin, waanaatsi ksutkusin, putiteew taachinllinaya. Wakar upapchir wits wazuraneew kátimapan misha waratamapan tamatarpari uru ashtachinllinaya. Ashirusin, undararee waratkatssin, watsapunish arap tashitungambeeru kasachinllinaya. Osiyarini wip Manaseschich, misha Efrayinchich zapan pzapaneeyarusin, waamaritin ichingaroo kasirsin taachinllinpa, Móysisarini Apanllpa mashku, Osiyarinchicheem nlluranur tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Móysisarini Sabulónaam, misha Isakaraamtam nlluranur Apanllpa mashku: Apaa, shiysha Sabulónaam, misha Isakaraamtam nlluranur kapung istangcha. Marumun wing taakamchusin, arachich mar boteerinshini xiksin, pangshuritaati taaksin, uru Apaa, shiyamun mang' shambatachinllipa. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Wamkuree zapan kuruzeersin, Israelchichpa shiyap pangish naayarusin, Shiyaam maachee zapan panayarusin, kis ungirtachinllinaya, Apanllee mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Móysisarini Gadchicheemsha nlluranur Apanllpa mashku: Apaa, Gadchich nlluranur urutamari shiyaa ungirtaksin taachinllinpa. Siyaamsha Gadchicheemis, Apanll tsapooneemis kapung panachiya. Ashiriya, Apanllee mangis kis, Wappari, tángtsa. Tumuz manginshuch tamatarpari ashirus tsapuneetsis pachindatssa. Tputs tamundakchu, siysa wanutsee izichta, izichta ashikpaz ashitssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Kanaanush tsap siy Israelchichpa washunand pshtutssa. Anush pshtukchus, siysat Israelchicheem undararee kasimaam istatssa. Kurakanandari anush tsap taamaam waritaktaata, Itaru, siysa anoo tsapuneemis kizpur wanasiree yátssa. Móysisarini Apanllee Gadchicheem tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Móysisarini Danchicheem nlluranur Apanllpa mashku: Apaa, Danchicheem nlluranur istangcha. Pzapaneekchusin, waani tsap Basanash taachinllinpa. Tumuz manginshuch wip tamapari ashirusin taachinllinaya. Apanllee mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Móysisarini Neftaliychicheemsha nlluranur mashku: Apaa, shiyaa kizpur chinachinllinaya. Ayamtaatiya nlluranureew urutamari shiyaa chinaksin taachinllinaya. Shiysha uwaam maacheetsi zapan istakush taatsha. Apaa, Neftaliychicheem watsapun yap zar puwachingaru maraa tuwshu ashchiri panangcha, Neftaliychicheem tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Móysisarini Aserchicheem nlluranur Apanllpa tsiyatarangu: Apaa, shiysha Aserchichee nlluranur kapung kasiru istangcha. Ashkachush, Akoparinchich wachinllin aranginasha kizpur taachinllinaya. Watam shiyaa Akoparinchich kizpur chinakanawa. Zapan olivoo wayungun payukchusin, anpatatam watsish kuchaku anoomaw taparchinllinaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Amb ashiru taakchusin, yaktarin washitungash wanasir mbamari ngusambpat kámanamaa anush taachinllinaya. Ashkatssin, urutamari ichingaru zar kizpur taachinllinaya, Móysisarini Aserchicheem mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","Ashiriya, nish ¿antaatiya minumtiyam tputs Israelchich Apanllpa tatsamooru wanindaja? Itaru, wamari Apanll kizpurcha. Msasish waanpata wizpuririni iyaam istamaam naanataranll ashkiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","An Apanll sirútama urutari taarangiya. Ashirucha, na in anumun iy mangini tatkuni, uwsha iyaa ksutkiya. Urutamari iyaa Apanll uwish payuku, siyaam wizpurireemis panakchu; siyamarisha kundarareetsis kasitssa. Siyamarisha ashpartaa pachatssa. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Amb ashkachus, anush tsap nlluranuris kisshapari mapiyrus taatssa. Mzarshitamtis kissha maachi tatsumim tirikuris, misha kizarunatam ashpari wanasir kxuneeru, kayanakchu anoo pusakus taatssa. Sinatam sinachiya tatsumimaris kizpur wanasir kxunamaamaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Apanll waana siyaam Israelchicheemis maachi wanasirimashpa istarangiya. ¿Antaatiya minumtiyam tputs nish tsapuranasish siy tamapsa ashiru wanindaja? Apanll Taarashipan waana siyaa tapachindarangu, na istakiya. Ksutkitamta; waamun wizpur siyamari kundarareetsis kasiksa. Kundararis kizpuritaa taaksin, siyaatssha puniksin, nda waritachinllinaya, Móysisarini Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Móysisarini Israelchichee, Ichingaroo tputs siyamaripa kizpur taatssa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Ashiriya, Móysisarini apusap tsap Mowabap naayaranllu, machi Nebumunsha káreeranllu, yuwamunari mach tutsipkamchu, sur Pisga; yakat Jerico anpatari tasasaru anumun xiyarangiya. Anumandarisha Apanll ichingaroo tsap yuwaa panachu anoo yámandarangiya. Yakat Galaadamand yáyaranllu, Danamun watsapun tutsiparu yámandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Anumunsha, ashchiritam watsapun Neftaliy, anumunsha Efrayina, anumunsha Manases anoo watsapun yámandaramchu, misha ashchiritam Utaá watsapuni anumand yáyaranllu, yuwamunari tspakatu kung Mar Mediterranew anumun tutsiparu yámandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Anumunsha tsap Negueb anoo ichingaru watsapun wazawpatari kung Ortagpatari, misha yakat Jerico watsapun wanasir watamusa anpatari, ashchiri, yuwamun yakat Sówar watsapun tspakatu anumunari ashchiri yámandarangiya. Yakat Jerico kizpur wanasirimuna, watam kuyan ashiru anush zapan taaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Ashiriya, aship ichingaru tsapuranas yámandaramchu anumun Apanll Móysisarinee; In tsapuranas watacha yuw sirútama zitaminarneetsi Apramarinee, misha Isaakarineetstam, misha Akoparineetstam nuw siyaam nlluranur tsapuranasee panachima tárangi anu. Nuwaana zandaranguri, shiyaa; Waani amuyari wachpatari pangap, táranguri, na shiyaam ashchiri yámandaranguri, shiysha anush tsap nduntaa taachush; itaru ashchiri tsapuranasee parangsha, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ashiriya, amb ashirangu, Móysisarini Apanll wamachtash anshurisha tsiparangiya. Tsap sur Mowabshu yuwartatam Apanll waana kamanirangu anuritam tatsamoorangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Amb ashirangu, anshurisha tsap Mowabash Apanll Móysisarinee mapurangiya tsap sur Bet-Peor anpatari tasasaru anshu. Yuwash mapurangu anush tsap na in minumtiyam nda tputs pakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Móysisarini masachirini 120 tatsamoochu anush tsiparangiya. Yuwamandari nllurtarangu anumandari matambish wanuts wanasir taarangiya; wachsha 'siniri taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Tsiparamchu, ichingarusin Israelchich tputs tanuksin, 30 zar mangutari taaranganaya tsap Mowabshu. Amb ashkusin, aship an zar mang' mantsaksin, tsiparingaz tanurangana. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Ashiriya, Josuey, Nomarini wipa, mang' kapung taarangiya. Móysisarinsha wanasir taamaam waneeyaru, waana uwi Josueyamun much wayarangu, Na shiysha tputsee machingcha, tárangiya. Ashirucha, Israelchich tputs anuritam Josueyaa kuk payuranganaya; tatsamooru tuminuranganaya. Yuwartatam Apanll Móysisarineetsi kamachtarangu anuritam tatsamooru payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Itaru ashiritaa, Israelchich tputs Móysisarini tamapari ashiru ndunarimunshita. Móysisarini Apanllpa wanasiritaatsiri tsiyatarana ashimaama. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Apanllee wizpur wanasirimshee yuwaa waana sirútama kamachtarangu; Ijiptosh tsap kurakaam parawarineemi tuyamandamaama. ");
INSERT INTO cbuNT_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Apanllee wizpur payurangu, anpa tputs tatsamaam pinasarangana. Wamari ichingaroom kasirangiya. Yuwamsheetsitam nda tputs patarana anumasheetstam ichingaroom Israelchich tputs parsin, Apanllee wizpur tuyamandarangiya. Sheeru, anumunarisha pastarangiya. Ashiriya, na kamaneena yuwaa Móysisarini tsiparamchu, anumun Josueysha Israelchichee tputs ksutarangu anootsi. Ashiriya, nuw Móysisi: wapparee, atina siyaatsi. Na kamaneena yuwaa Nuw Israelchichee Waneeruri, Tsiyatsis Tayusirangi anootsi.");
INSERT INTO cbuNT_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Apanll wamachtash Móysisarini tsiparamchu, anush Apanll Nomarineetssha wip Josueyaa, Móysisarineetsi tiptsir tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Na nuwaana tputsiri Móysisarini tsipayanlliya. Ashiriya, na shiyshat kurakaam kinangcha, sheerush tputsiriptish Israelchichpat, arachich kung Ortagaa kiteerus naangtsa, anoo tsap siyaamsha panachintspa. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Yuwaa sirútama Móysisarinee tsiyatarangi, anoo nuw k'keetsi tatsamchima. Siyaam tsapunis yap kungoo Ortaga arachich kitkachis anoo panachintspa. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Siyaam tsapunis tashtap apusap mach Libanu anumand yaru, mus Eufratis kapungumash taaru, anumun panachintspa. Ichingaru Hititshuchpatari watsapuni, mishat maramuntam wing, yap zar puku ambi. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ashkachuri, shiyaa ayamtaati tputs anoo patatchazinllinaja. Nuw shiyaam ksuchinllpa. Móysisarineetsi kapung nuw ksutarangi, shiyaamsha ashtachtamana, Ayamtaati shiyaa kasacheezi. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Itaru, shiysha kizpurtangcha. Shiyshat tputsireemish ichingaru Israelchicheem tsapu ipuseerush panangcha, Nuwshat yuwaa sirútama zitaminarneetsis tsiyatarangi anoo izuuru tatsamchima. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Nuw shiyaa minumari kamachtakina. Shiyshat kizpurtangcha. Nuwaa tputsiri, Móysisarinee wamachtash kukoo tatsamooru payungcha. Amb ashkush wanasir naatsha, yuwaa kamachtarangu anoo tuminuchsha. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Mishat, nuwaa kuki natstayarush, tputseem kamanimantar shingcha. Ichingaru zari, kaschiritam, psaantam kamaningcha. Shiyshat nuwaa kamachtashi yasamaamtamta. Amb ashkachinaareesha, uru shiy wanasir taachsha. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Anoom nuw shiyaa kamachtakina. Putiteem kinayarush, tsiyatangcha; kizpurtangcha. Punirinllpa. Mishat, sambaytarinllpa. Watam nuw shiyaam kuraki Apanlli ksutarinawa. Yaptam naakish ambtam nuw uru shiyaa ksutchima, tárangiya. Na kamaneena yuwaa Apanll Josueyaa kamachtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Josueysha yaktashchee ksutamapaneewa kamachtarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","Naayarus, ashpari yaktash tputsee kamachtashini, maachi ichingaru washunand, katungtsitam xanatamaama. Watam nimand tuchpash zar nee tsap shitungeeruch, kung Ortagaa arachichsha kiteeruch naatchiwa. Yap Apanll iyaam tsapoo panachu ambi. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Tárangu, Josueyarini Rubenchichee, mishat Gadchicheetstam, mishat Manaseschicheetstam chawap tputsee tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","Yuwari Apanll tiptsir Móysisarini tsiyatarangu anuri chinangtsa. Iyaa tsiyatku amaranga: Watatanda iyaam nee tsapu panayanllu, yuwash iy mapiyruni taachini anooma, táranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Ashiri izanllis, ipartamtis, mishat chinitamtis nishuri Ortaganungiri kung, Móysisarini tsapoo panarangu anshuri kamingangtsa. Itaru, siyaana ichingarus kamuzanuris kizpurtayarus, k'chirpunguris yáyarus, Ortagaa kung kiteerus, yap zuwanllis naayaranllina amb tachitayarus, zuwanlleemis istashinints, nda tputs kasimaama. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Tputs siyaa kasimaam zandkitaatiya, ashtaa kizpurtayarus, yuwaa Apanll tsapuneemis, Yuwash taachis anoom panachintspa, tárangu anoo, tpachindashinints, waani zuwanllis watsapuneemaritamsin yapana. Napa, siyaam tsapuneemis panarangu, anoo na payukis, uwshtisin ashtaptamsina. Ashiramchus, siyaana yusur tsapunpitamtis, yaptam Apanll tiptsir Móysisarini siyaam tsapunis kunguchich wing panarangu ambitam taakamchus kanaputssa, Josueyarini tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Uwshtisin, Zurkush átsha yuwaa kamachtakish anoo ngatkeezini. Ashiriya, yap átish amb naachinipa. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Shiyaa kukish payukaniya yuwaa kamachtakish anootsi. Sirútama Móysisarinee kuk payutarini ashiritam shiyaatssha kukish ashkitamaniya. Mishat, Móysisarineemi Apanll kapung ksutarangu, shiyaamsha Apanll ashtachtampa atiniya. ");
INSERT INTO cbuNT_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Mishat, wandaya yuwaa kamachtakish anoo, k'keetsish tputs nda payuksin, shiyshat tputsee pachayarus ksangtsa, tángcha. Mishat, nuw minumari atina shiyshat Josueyaa, kizpurtangcha; sambaytarinllpa, Rubenarinchich táranganaya. Ashiriya, na kamaneena yuwaa Josueyarini Rubenarinchichee tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Josueyshat wasundururee tsimbun tputs tsapoom naramaam, Sitimmand tsap zanganirangiya. Anshat wasundururee zangankachu: Natu, siy Jericoyap tsap naayarus narashinints, tárangu, uwshtisin anuritam naataranganaya. Ambshat kuskamchusin, Jericoyash kiz mshipan sur Rahab taaku, anush pang' pshtuyarusin maaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Itaru, anshuchshitisin tputs anoo yasarangusin, kurakaatssha Jericoyshuchee kamaniranganaya. Mang tputs tsimbun Israelchich, na zar psaan nish kuseenllinpa, iyaam tsapunni narkatssina, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","kuraksha: Natu kizaa Rahabaa kamanishinints. Yuw tputs pangishish, pakatssin kuseerana, anoo tshitungangi. ¿Mayaamsha ipishungaka? átcha, táshinints tárangu, uwshtisin anoo kamanirangsin, ");
INSERT INTO cbuNT_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","itaru, kizsha pishurangiya tputseetsi. Ashirucha, kamapshiku, Tputs nuwash pakatssin, kusamana kusarangsincha. Itaru, nuw nduntam yasarina. ¿An tputs yapchimasaja? ");
INSERT INTO cbuNT_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Tapitaranlluricha, ndaturi yaktaa washitungash kámanarsin, shitungeerandsin naatarangana. Nuw nduntam yasarina. ¿Yapimasaja naayanllinaya? Ashiri siysat kaapanapa. Naturitam káyarus tchitanantsa. Uru upusaripa kamatatssa, tárangiya. Mangu Rahab tamapingaku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Waantataa íwar pangusip wanupish iwaz tunaringayaru, yuwash yutee zap mapzamaam xanataru anush wantsush tapshtuyaru pishurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Kurakshat wasundurur káyarandsin, ngootsip yap Ortag kung maranxip kayapampatari kitkana amb tputsingaz nachungakatssin naataranganaya. Sundarsha shitungatssin, yusur yaktareetsini wach mbam shtandayarusin, kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Tputssha tsapoo naramapan ndaturi maaru, kizsha Rahab ambitam pangusip wanupish iwaz káreeru, tputsee: ");
INSERT INTO cbuNT_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","Nuw yasaktana: Yuwaa Apanll nee tsap siyaam tsapunis panarangu anootsi. Ashirucha, iyashuch ichingarusin kapung siyaa puniksin, punirsamunari tsiparpaz ashirusin, waanaatsi tapachindamaam pinasakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Ichingaru yashuch tputs yasakanaya, yuwaa siy Ijiptosh tsap shitungeeranllus, mus Chumbeepimashee siyaam kitamaam Apanll kungoo puzarangu anootsi. Mishat, yuwaatstam siy kurakaa tsimbunari, Sihonaa, mishat Ogaa ashiru, tiptsirpatari kung Ortaga arachich siyamari kachingarangis anootstam yasaktamaniya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Ashirucha, iyshat anoo yasakuni, kapung punikaniya. Iyashuch tputs ichingarusin siyapat waratamaam punikanaya. Watam Apanllimari wamari kasiru taaku, anumun mangis siy tatuksawa. Siyamaritcha Apanlliris kanindash kasiru taaku, mishat tsapurnaseetstam wamaritam kasiriya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Ashirucha, nuwshat siyaa naturitam yasamaam zandkina. Zurampatari nuwaa kamaningasindama. Ashiriya, siysat nuwaa maachiriti Apanllimun sur nayningasindama. Napangi nuw siyaa tapachindaranguri wanasir ksutarangi, ambtam shingasindama. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Apareetsi, atataatstam, wawareewaatstamti, mishat pamuneewaatstamti, ichingaru anchichee wachinllin, nayaningtsa. Pcharintspa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Uwshtisin, Ashiriya, iyshat zurampatari tsipampatartini tsiyatchinipa. Ngichkachinaareeniya, uru iy tsipachiniya. Itaru, shiyshat tputsee kamaninllpa yuwaa na tsiyateeni anootsi. Yuwash Apanll iyaam nee tsap panakchu, anush iyshat siyaa wanasir ksutchinipa. Yuwamand shiy na iyaa tapachindayanllish, anumand uru siysat kamungatssa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Rahabsha anush pangoom íwar tandapunuzimun iwaz pangurangiya. Ashirucha, anumandarisha arangimand pangus wach tputsee waskamun yaruwarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Ndatuma tsapush tputsee yaruwaru, chtaru wanasir waneerangiya. Musá nungipis naarintspa. Paptsa yuw sundar siyangaz nachungakatssin naanchina anin parunts. Natuma machip tsap naangints. Ambiri tuchip zar taamatssa. Itaru, sundar yuwash kanaputaramchusin, anush siysat nungiptamtis naatssa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Tamapingampanshitisin tputs, Yuwaa shiyapa wanasir tsiyateeni, anoo nda ngutani táchinipa uru zurampatari tuminchinipa, ichingaru yuwaatstam tárangish anootstamta. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Ashiriya, iy nish tsap kuskamchuni, shiyshat nee wanumaa chumbeepimashee neetsiri kanambitataw shingcha yuwanungirtatam wach iyaa yaruwayarish annungitamta. Mishat, apareetsish, aneereetstamtish, wawareetstamtish, ichingaru apareetstamtish maachiri shaanshutarisha pangish tushaneepcha. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Wandaya shiyaa kukish nda payuksin, shiyash pangish shitungeersin, ngootsipsha xiykchusin, uru waanamandaritssin tsipachinllinaya. Ashkatssin, iy nda yaantari ashchinipa. Wandaya yaashuch tputs shiyash pangish pshtuyarusin, tputsee pachakchusin, anush iy k'keetsini ngichkiniya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Mishat, na yuwaa tsiyateeni anoo, Shiy pakchiyam tputsee kamankinaareesha, uru iyshat k'keetsini yuwaa zurampatari shiyapa amb ashtachinipa tárangini, anoo izuritam watsta táchiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Itaru, kizsha: Nduni. Anuritam nuw chinachima tárangiya. Tsiyatam yuwaparamchusin, Ashiri naanamachima, táyarandsin, naataranganaya. Kizsha anuritam wanumaa chumbeepimashee wachunung kanambiptaru kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Anshitisin, ipishungampan machipsha naayarandsin, ambirisha tapisheersin, tuchip zar maaranganaya. Kuraksha wasundurur mangutari piyamari nachungtangat ashirangsin, nda chamayangaranganaya. Xapooyarandsin, yusur waptam yaktarinpini Jericoyap kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Sundar kanapuramchusin, anush yusur machimand karuweerandsin, yaptam naataranllina ambtam, kungoo kiteerandsin, watsapuniptam kanapeerandsin naataranganaya. Kuseeramchusin, Josueyash yuwaa pakeeshinana anoo ichingaru kamaniranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Watam Apanll anoo tsap yaam panaranguwa. Ashirucha anumand yasaksin, ichingarusin tputs yuw anush taakana anin, punirsamunari tsipakpaz ashkanaya, kamankusin táranganaya. Ashiriya, na kamaneena yuwaa Josuey wasundururee tsapoom naramaam zanganirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Putamshat, zar puturi Josuey ichingaru tiptsirpatari Israelchichpa Sitimmand tsap káyarandsin, Ortagamun kung kusaranganaya. Itaru, ndatuma kitarusin, anootsiritama shaniyaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Anootsirisha kutaksin, tuchip zar maaranganaya. Anush kurakshitisin ichingaru tsiyatssee kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Siysat Israelchichee wamachtash payungtsa. Apanllee kajonarini Leviychich apanllpanirini urkar yáyarusin, yap naakchinllina ambitam siysat tchitangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ambtanda ngoots chiy naachich watam siy amb ngoots nda minumtiyam patarsawa. Itaru, watsiri Apanllinung kajonarini káyamarintspa. Arapiri kuzizimun minum kilometor tamapari ashiru tchitangtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Josueysha tputsee, Chtaru Apanlleem mangeetsis yarangtsa. Watam pu zar Apanll waanaatsi wizpur tuyamandachuwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Apanllpaneetssha urkar: Siysat wasina imazayarus, kung Ortagaa arachich kitkachus, Apanllee kajonarini payutatssa, tárangiya. Apanllpanshitisin anuritam Apanllee kajonarini, yáyarandsin, wasina imazayarandsin naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Apanllsha Josueyaa, Ashiriya, na nuw shiyaam kapung istachinllpa. Ashkachuri, Israelchich tputs ichingarusin shiyaa wanasireem ínachinllinaya. Apanll Josueyaa kapung chinakiya. Móysisarineem kapung istarangu, na Josueyaamsha ashiritam istakiya, táchapsinaya shiyaatsiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ashiriya, na shiyshat apanllpanee urkar kamachtangcha; Nuwaa kajonarini kuyarus, kung Ortagap naangints. Kungumun wing kuseerus, ambiri kungup iriptara sheerus, apusanand kung xiyangtsa, tángi, Apanll Josueyaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Ashiriya, Josueysha Israelchichee: Naanints ningeema. Apanllee kuk mazinangints. Yuwaa Apanll tárangu anoo kamanchintspa. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Apanll siyaa yachamaam zandkiya. Itaru, watam Apanll waana ksutaruwa. Uru iyaam kapung istakchu, Kanaanshuchee, Hititshucheetstam, Hebewshucheetstam, Feresewshucheetstam, Gergesewshucheetstam, Amorrewshucheetstam, mishat Jebusewshucheetstam, wamari tpachingachiya. Anumun yasakchus, Apanll iyaa ksutariya, tátssa. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Apanllee kajonarini, yuwaa wamari tsapurunasee kasiru, anoo yáyarus, wasina imazayarus, kungoo Ortaga arachich kitatssa. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ashirucha, nuwshat siyaa atina. Ndatuma naachus, wasina Israelchichpatatis, minchich tputs minumtam, minchich tputs minumtam sheerus, washunand 12 tputs patumbchee kumpaneem ipusangints. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Ashiriya, apanllpan Apanllee kajonarini, tsapurunasee wamari kasiru taaku anoo yáyarusin, wats kungush kayapkamchusin, Apanllsha wizpur kungoo kámanakchu, kungsha yuw naantaru an anootsirisha zanayta ashtachiya. Ashkachu, kungsha apusash puzatara ashchiya, Josuey tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","16","Ashiriya, Israelchichshitisin anuritam, arachichshat kung Ortagaa kitkatssin, chtaru apanllpaneetsima urkar tuyamzaranganaya. Uwshtisin Apanllee kajonarini yáyarandsin, wasina imazaranganaya. Anpurshat zar, kung kizpur kumbiytspasamuna. Iwarzee anpur zar pusataranaya. Ashirucha, anpasaru zar apanllpanshitisin urkar Apanllee kajonarini kuyarandsin, kungumun wing napiwakamchusin, wats kungush kayapkamchu, kungootssha yuwaa naantaru anoo Apanll kámanarangu, anootsirishat kung zanayarangiya. Kung ambirisha tashtap yakat Adamnung, yuwash pangus Mbammash sur Saretán taarangu annungirishat, kayanuru, musaam kinarangiya. Yuwshat kung tuwash zaw ashirangu, anshat Mar Tsipari atana ambirishat kayanurangiya. Kungshat pseertarangu, apusashsha kung puzarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Anumun Josueyshat patumbchee 12 yáyaru, yuwash apanllpan urkar Apanllee kajonarini kursin xiyarangana, anush apusanand xanateeru kasarangiya. Anshat patumbich na wandaritam apusanand taakiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Watam Apanll waana Josueyaa kamachtaranguwa. Ashirucha, Josueyshat anuritam tiptsiree kamachtarangu, uwshtisin Josueyaa kuk payuranganaya. Sirútama Móysisarineetsi kuk payurangana ashiritam waatssha kuk payuranganaya. Ashiriya, apanllpanshitisin urkar Apanllee kajonarin kuyarusin, Ortagaa kung apusanand xiyarangsin, Israelchichshitisin anuritam mikamarshchiri arachich kitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Tputs ichingarusin arachich kitaramchusin, anumun iwaz apanllpanshitisin urkar yuw Apanllee kajonarini kurana anshitisin, kárirangtamsinaya. Sheersin, yusur tputsee arangeem imazaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Mishat, tapazpantamsin tputs, Rubenarinchich, Gadarinchichtam, anumun chawap Manasesarinchichtam, anoo kung kitarangtamsinaya. Anshitisin tputs tapazpanandaritssin wasina Israelchichee arangeem imazaranganaya. Watam sirútamasari Móysisarini anoo kamachtaku kasaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Ashirucha, anuritam chinarangusin naataranganaya. Anshat yakat Jericoynungiri watsiri kusarangsin, tapazeemarisha pshtumaam washunand 40 mil shaniyaranganaya. Sheersin, Apanlleetssha kajonarini ungirtaksin, shurangaktar ashirangsin, arangeem watandsap naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Anpurshat zar Apanll Josueyaa kis naparangiya. Ashirucha, Josueysha kizpur kurak tamapari ashiru taarangu, Israelchich kis naparangsin, kukoo kapung payuranganaya. Sirútama Móysisarineetsini kuk payurangana ambitam Josueyaatsshat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ndatuma apanllpan urupung káyarusin, Apanllsha Josueyaa; ");
INSERT INTO cbuNT_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Shiyshat apanllpanee urkar kamachtangi. Yuwis Apanllee kajonarini kuris anis mikeerus Ortagaa kung káringints, tángcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Josueyshat anuritam, Ashiri siysat Apanllee kajonarini kuris anis, káringints, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","apanllpanshitisin urkar anuritam urupung káriramchusin, yuwash tsap puzamuna anush yusur kung zaw ashirangu, sirú tamarangpari ashiritam kung yusur naantaramach ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Anpur Israelchich masach kaneeschishuri tsupsha minumtashuritam chungaam maats tushiychu, anush Ortagaa kung shitungeerandsin, yakat Jericoyapsha, yap zar yaku amb Guilgaalash tsap kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Josuey anushsha yuwaa Ortagash kung 12 patumbich yarangu anoo xanateeru kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Sheeru, Israelchicheetssha, Ayam iparis nee patumbchee pakchusin, uru saanaatsisha mashchinllinaya. ¿Mayaamaja nee patumbchee xanatarangana? tákchusin, ");
INSERT INTO cbuNT_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","siysat ipareetsis kamankus, Siyaam nlluranureemis mangis p'tsimaam ashiranganaya. Watam sirútama iyashuch Israelchich Ortagaa kung puzamun kitarangana. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Apanll waana, iyaam Israelchicheemani kung Ortagaa arachich kitpana átu kungoo puzarangu, anush iyashuch kitaranganaya. Sirútama iyashcheem Apanll Maree Chumbeepimashee wizpurpa puzarangu, anush iyshat kitarangani, ambitam Ortagaa kung ashirangiya. Anpurcha ayam nee patumbchee pakuni, nizpurisheemani atusin wayaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Anoo tputs yaktashcheew ichingaru tsapurnas yasaksin, Apanllimari kizpureeru ashirangiya, átangat ashkanaya. Ashiri siysat nlluranuris Apanllee kuk urutamari payungtamtsa, táyarus, ipareetsis ksangtsa, Josuey Israelchichee tárangiya. Ashiriya, na kamaneena yuwaa Josuey Israelchichee wanasir waneeyaru kasarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Anpurshat kurak Amorrewshucheew, Ortagash kung, yap zar puku amb taaranganaya. Kanaanshuchshitisin kurak mar Mediterranewnungiri watsiri, yap zar puku ambtam taaranganaya. Anshitisin yuwaa Apanll Ortagaa kung puzarangu, Israelchichsha kiteerana anoo mazinarangusin, kizpur puniranganaya. Ashirucha ashirangsin, Israelchichee tasasamaam izuuru puniranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Apanllsha Josueyaa: Ashiri shiyshat patumbchee k'chiroom tinayarush, anpat Israelchichee wayumshir tas yuwaa tsasa anoo ktsupangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Josueysha machish Aralotash apanllpaneetssha tputs kamachtarangu, anuritam patumbchee k'chiroom tinarangusin, anoo ashpari Israelchichee kamuzanur wayumshiree tas ktsuparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","5","Anpur nllurnureetsimshat wayumshiree tas ktsuparanganaya. Watam yuwanaarsin tapazeem waratamaam waritataru, Ijiptosh tsap wayumshiree tas ktsupamanand shitungaranganaya. Annaarsin apusari ngootsish wachinayarusin tsipambaranganaya. Itaru, yuwaatssha apus ngootsish naarsin, nllurtarangana anootsimsha wipaa wayumshir tas nda ktsuparanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Israelchich Ijiptoo tsap shitungatssin, ambiri apusap tsap mangutarishtisin masarsin xiytangat ashirangsin, Apanllee kuk ichingarusin kapeetaranganaya. Apanllsha anumand kapung tsiyantarangu, Ayamtaati siy Kanaanap tsap wanasirimship naacheezis. Sirútama zitaminareemis siyaam tsapunis yuwash katungats zapani, kinduratam, wakaratam mimir kung ashiru naantangatu anoo panachintspa, tárangitaati, itaru siynaa wachinis amb naacheezis. Uru nishuri apusari wachinayarus, tsipatssa, tárangiya. Ashirucha, wachinanaarsin, apusari 40 masach taarangsin, wipaa wayumshir tas nda ktsupuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Wachinanur pchingarangu, Josuey yuwaatsimsha, apus ngootsish nllurtarangana anootsimsha ashpari wayumshiree tas ktsuparangiya. Watam ndunnaa ashkusin, yap Apanll zitaminarineem watsapun panarangu, amb nda pshtuchinllinawa. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Anshat ashparitssin wayumshiree tas ktsupam iwatsparamchusin, wasur ksuku anoom mayungaksin, anshuri kanusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ashiriya, Apanllsha Josueyaa, Na ichingaru tputsireetsish wayumshir ktsuparangush, na nimunarisha siyapa ndusha pazinlliniya. Sirú Ijiptoshtaa tsap taarangsin, itaru na siyapashat washunand kisshat ipunatssa, tárangiya. Ashirucha, anumand anoo tsap waanshuchtisin kuk Guilgaala atusin yásamaranganaya. Nish tsap tputs paziree kapeeteenllinaya, atusin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Israelchich yuwamun Guilgaalash tsap kusarangana anumun 14 zar maatssin anush pukamchu zar, yuwaa Apanll iyaa Ijiptoo tsap tashitungarangu anoo chinamaam shambatshisheem wayayani, tárangusin, yakat Jericoyanungiri watsiri Apanllee shambatkusin, kis ungirtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Anuritam zar pangaatssha nda tputaru, mishat tirikootstam katungaranganaya. Putamsha zar Kanaanshucheetstamsha watungash katungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Apanllsha anpuritam zar ndushat katungtsee maná zanganirangiya. Watam Israelchich Kanaanshucheetsirishat watungash ichingaru masach katungaranganawa. Na kamaneena yuwaa Israelchich Guilgaalash tsap kusarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Minush zar, Josuey yaktash Jericoyash taaru, sundar ashiru wánungee machtar wazuran payuru xixeewu parangiya. Josueysha annung watsiri káyamayaru, masharangiya. Kaapa ¿chakaam shiy istakatush naatatsha? ¿Nduntaati ashiru iyaamazuwa kundararini istakatshawa? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Apanllsha, Nduni, amb tárinllpa. ¿Tamari nuw piyam, piyam ashtachee? Nuw Apanlltana kuraki. Nuw shiyaa kamachtamaam kusarangina, tárangu, Josueysha, Zuraktishcha, táyaru, much tsapush kizpur timuchta sheeru, ¿Mayaa shaana kamachtamaam zandaksha? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Apanllsha, Natu, spaturish yushungi, watam nee tsap wanasirimsheem wayayaniwa, tárangu, Josueyshat ayu tárangiya. Na kamaneena yuwaa Josuey Apanllpa tsiyatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Anpursha zar mang, yaktash Jericoyash tputs pshtumaam, mishat shitungamaamtam pinasamuna, watam izuuru wachoo mbamari shtandaranganaya. Israelchich tputs nda nish pshtumaama, atusin, ashiranganaya. Anshat yakat ashchiri tandapunuzpat kámanamuna. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Itaru, Apanllsha Josueyaa, Nuw siyaam kapung istachintspa, uru siyaam yaktaa Jericoyaa, kurakaatstam, wasundururpatari kuwishis tupanayarunts kasachintspa. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Shiyshat sundarurpatish Israelchichpat shurangayarus, yaktaa Jericoya ashchiri minumtash zar minum iturpita, putam minumtam iturpita shingtsa. Ambiri ashishtarus, washunand minum matayaru zar iturpingints. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Apanllpanshitisin urkar 7 tputs anshutam Apanllee kajonarini kuyarusin, imarchachinllinpa. Wakaraatssha wits 7 yachinllinpa. Sheersin, tsimbunash matayaru zar yaktaa iturpikchis anush apanllpanshitisin urkar wakarash wits pu pu táchinllinpa. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Tákchusin, ashiri siysat yuwari wakaraa wits mazinayachis anuritam kizpurtayarus, kapunguri zamangata shingtsa. Zamangayachus, uru yaktashsha watandpun pátangakchu, tsapuwash parat ashtachiya. Ashkachu, anuritam siysat yaktash teet, pshtutartata shingtsa. Tárangiya Apanll wasundurur Josueyaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Josueysha anuritam apanllpanee urkar kuruzeeru, Ashiri siysat apanllpannandis 7 washunand ipuneerus, Apanllee kajonarini yángints. Mishat, wakaratam wits yángints. Yáyarus, wasina imazangints. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Natu, siysat sundaris yaktaa iturpingints, yuwis tapazpanis anis. Wasina siy Apanllee kajonarini arangeem imazangints, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Tputsshitisin yuwaa Josuey kamachtayaru anooritam tuminurangsin, chtaru wakaraa wits pu pu támpanima 7 tputs, apanllpantam urkar wakaraa wits yáyarusin, imazaranganaya. Anumun Apanllee kajonarini kumpanshitisin tachitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Itaru, chtaru yuwamassin kizpur tapazee waratamaam yasarana anumassin apanllpanee urkar arangeem imazaranganaya. Apanllpanshitisin urkar 7 tputs washunand wakaraa wits, yarangusin, anumun Apanllee kajonarini kumpantamsin tachitaranganaya. Ashirangsin, itaru arang kuzizimun sundarutam tapazpantamsin tachitarangtamsinaya undarareem tapachindamaama. Amb sheerandsin, shurangayarandsin, yakat Jericoyap naatarangsin, yaktaa Jericoya iturpiranganaya. Anush apanllpanshitisin wakarash wits pu pu tárangusin, nda zanayaranganaya anuri ántar ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Itaru, Josueysha sundaroo, Musá siy zamangarintspa. Zamayarus marchangints. Na yuwash nuw, Natunaaree, tákchuri, anshunaa kizpurtayarus, kapunguri zamangangtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Ashiriya, Josuey Apanllpa kajonarini yaktaa minum iturpiyashinusin, yusur waptam taarashpitam maakamchusin kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","13","Putamsha, zar puturi Josuey chiyzayaru, apanllpanee urkar ipunpunar tputs tuchiyzayaru, yusur Apanllee kajonarini yamaam kamachtarangiya. Apanllpanshitisin urkar wakaraa wits pu pu támpanin 7 tputs wakaraa wits yáyarusin, Apanllee kajonarini kumpanee arangeem imazaranganaya. Itaru, nda arap kamingaranganaya. Mishat, nduntam musá pu pu táranganaya. Itaru, chtaru tapazpanima sundar, apanllpanee arangeem imazaranganaya. Mishat, tapazpantam sundar kuzizimun tachitarangtamsinaya. Wakaraa wits pu támpanshitisin nda zamaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ashirangsin, anpat tsimbunarinshitini yaktaa iturpiranganaya. Sheersin, yusur yaptam taarana ambtam kanapuranganaya. Ambiri putam zar aranginash, aranginash ashirangsin, arangtach minum matayaru zar iturpiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Putamsha tsimbunarinshitini matayaru zar tarasitaranlluri, káyarusin, yaktaa yusur marchaksin iturpiranganaya. Chtaru tamaranganaya ambitam ashirangsin, itaru anpat zar, tsimbunarnishitini matayaru yaktaa iturpiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Anushsha zar yusur apanllpan urkar wakarash wits tsimbunarinshitini matayaru pu pu tárangusin, Josueysha anuritam tiptsiree kamachtarangiya. Natunaari, ashparitis zamangayarus, tsiyatangints. Apanll waana iyaam nee yakat izuuru tpachingamaam panayanlliya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Nish yaktash maachi ashpari taaru anoo izuuru tpachingamaam waana Apanll ipuseeru, iyaam kamachtayaru kasarangiya. Itaru, nish kiz mshipan sur Rahab taaku anootsinaa pachacheezini. Mishat, yuwaatstam pangush maachirit shaneerana anootstam napangtsa. Antanda mang iyashchee tputs tsapoo naramapanee pangush pishurangu, anumandtam iyshat nayniyani. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Mishat, mangiptispa musá maacheetsi yaktash taaru anoo muntarintspa. Pakchiyam ptatintspa. Ashpari maachtawaa izuuru napangtsa. Watam Apanll waana ashpari maacheetsi kpitangtsa, táranguwa. Paptsa, maacheetsi pakcheetsiyam yakchinaareesa, uru saanaatstatam taarashis tayutaritatssa. Mishat, saanaatstatam Israelchicheetsis tayutaritatssa. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Itaru, oroomari, mishat orootam mburshimashiwa, an ichingaru yuw maachi ngusambaw mbammasheewa an ichingaru Apanlleemtam. Ashiri anoo pakchus, yáyarus wayangtsa, Apanllish pang' wayamaama, tángints tsiyatkus, Josuey tiptsiree tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","tputsshitisin anuritam zamangaranganaya. Wakarapanshat wits pu pu támpan, pu pu táyatssin, Israelchichshitin wakaraa mazinarangusin, uwshtisin anuritam kapunguri ashparitssin sundar zamangaranganaya. Amb tákchusin, tandapunuzsha iwatamarangu, izuuru paratzurangiya. Sheechu, anuritam sundarshitisin yaktash pshturanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Sheersin, ashpari tputsee k'chirpungpat pacharanganaya. Ichingaru kizaatstam, kanungaseetstam, kizpur wachinawaatstam, mishat chinuzeewaatstam, toroo tarawzupaneem wayakana anootstam, opeejaatstam, burrootstam, ichingaru ashpari, maachitpatawari izuuru tpachingayarusin kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Ashirangsin, Josueysha yuwaa sirú tsimbun tputs ipuseeru tsapoom naramaam kamachtayaru zanganirangu, anootstam yusur kamachtarangiya. Natu, yuwis nish parangis anis, kizap mshipanip pang' pshtuyarus napashinints. Ashpari maachiri anush taarana anpatari tshitungashinints. ¿Tamarinaa siyaa naynirangu, tapachindaranga? ambitam siysat shingints, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Tárangu, uwshtisin anuritam kizap mshipanip pang' teet ashirangsin, pangush pshtuyarusin, kizaa mshipanee sur Rahabaa, ichingaru waparpatari, wanirpatari, wayuchpatawari, mishat maachiritamsin anush taarana anpatari ichingaru yamayarandsin, Israelchichipsha taarash, piyam waanitam yuwash tsap wanasiri anush wayaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ashiramchusin, Israelchichshitisin yaktaa ashchiri tirooyarusin, ashpari maachi anush taaru anoo ichingaru mucheersin, kasaranganaya. Orootsimari, mishat ur mburshimashi, maachi yuw mbammasheew ngusambawa anootsim nda muchiranganaya. Anoo yáyarusin, Apanllish pang' wayaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Kizaatssha mshipanee sur Rahabaa nduntam pacharanganaya. Ashpari Rahabaa wamind naparanganaya. Watam an kiz, Josueyaa muchchur tsapoo naramapani pangush pishuranguwa. Ashirucha, Josueysha anumandtam uwshat tapachindarangiya. Amb ashirangu, Rahabchich wachinllin na wand Israelchichish watsapun taakanaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Anshat yakat Jericoyaa kapeetaramchusin, Josuey yusur Israelchichee wanasir waneerangiya. Paptsa. Siy yaktash Jericoyash pangeemis pangumaam chinarintspa. Tputs anush pangukchinaari, yusur yaktaa Jericoyaa tanischikchu, uru anoo tputs Apanll kizpur tsiyantachiya. Ashkachu, tputs anush pangoom patatkachu, uru wip iwaxiztam tsipachiya. Yaktamsha watandpun wach yusur kaneesich tinakchu, wip shipamunaatssha tsipachiya. Apanll waneekchu, wip ashpari pchingchiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Apanll Josueyaam kapung istarangu, nda xapoorangu, wamari kasirangiya. Ashirucha, Josueyaa tputs ichingarusin Kanaanshuch tsap yasarangusin, Josuey kizpurcha, táranganaya. Ashiriya, na kamaneena yuwaa Josuey yakta Jericoyaa tpachingarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","2","Josuey, mishat Israelchichtamsin mang yusur yakat Aíyaatssha kachingaranganaya. Sheersin, anumun yakat Gabawonshuchpasha tputs amikurtaranganaya. Anpurshat zar, Irusarinash yakat kurak Adonisedek sur taarangiya. Anshat kurak, yuwaa Josuey yaktaa Jericoya pachampat kachingarangana, anumun minootssha yakat Aíyaa kachingarangtamsina, anoo tsiyatsis mazinarangu kapung punirangiya. Sheeru, yuwaatssha Gabawonshuchpat kurak Israelchich amikurtarangusin, kapung Israelchicheem istamaam zandarangu, anootsshat yusur mazinarangu, aranginasha kizpur punirangiya. Watam Gabawon yakat kapunguwa. Aíya yakat kasiriya. Mishat, anumari yakat wanasiri ichingaroo kasiriya. Sundarshat anush kizpurinandari taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Ashirucha, kuraksha Adonisedek anoo tsiyatsis mazinarangu kapung puniku, kurakaam sur Hoham, minshucheem kurak Piram, minshucheem kurak Jafiyam, minshucheem kurak Debireemtam, zapan k'kuzee piyam zangata, zangata ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Anshat zanganku tárangiya, Naanints ningeem. Nuwaam istangasinda. Papcha; nuwaa Gabawonshuch mapukchinllinpa. Mang Josueypat amikurtarangusin, washunand ipuneenllinaya, mishat Israelchichtamsina, táyaru tsiyatssee zanganirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Ashirucha, uwshtisin anoo tsiyatsis mazinarangusin, zameetpat kurak Amorrewshuch tsap karanganaya. Irusarinshuch, Hebronshuch, Jarmutshuch, Lakisshuch, Eglonshuchtam. Ashirusin, washunandarisha yápandayarandsin, ashpari wasundururpat Gabawonshucheem pachakatssin naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ashirucha, Gabawonshuchshat kurak k'kuzee mikeeru zanganirangiya kurakaam Josueyaama. Anpurshat zar Josuey Guilgaalash yakat taarangiya. Amb Gabawonshuch tputs k'kuzee kapeetarangiya. ¿Tamaksha? Nuwaam mikeerush kuseerush istanda. Nuwaa ngatishpa, watam shiyapa kizpur amikuriniwa. Natu, tpachindanda. Papcha. Amorrewshuchinand kurak washunand yápandayarandsin, nuwangaz pachakatssin, na nish machish shaneeranaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ashiriya, Josueysha anuritam Guilgaalamand tsap káyarandsin, ashpari wasundurur kizpurinandari naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Apanllshat Josueyaa, Punirintspa. Nuw siyaam kapung istachintspa. Pachampanee tputs siyaam tuyamandachintspa. Nuwshat napuxtamash wayayaruri kasachima. Amb ashkachuri, siyaa nda pakchiyam tistachinllinaya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Anshat Josuey Guilgaalamand tsap káyarandsin, psaanpatari zar naataranganaya. Anushshat kusarangsin, Amorrewshuchee tputs pacharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Apanll waana tputsee tpuxtamash wayayaru kasarangiya. Ashirucha, Israelchichee parangusin, kapung punirustaranganaya. Amb ashirangsin, ndushat waritaranganaya. Anush Josueysha wasundururpat tputsee zapan Amorrewshuchee Gabawonash tsap pacharanganaya. Anumun yapshat suwayaranllina ambshat Betorunap ngoots tachitaranganaya. Ambiri Amorrewshuchee tachitarusin, pchakatarandsin, tsap Asekamun mishat Makedamun kasarangana. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Ashiriya, Amorrewshuch chawpitamsin Israelchichee puniksin, Betorunungiri tsap wazawapshat karuweersin, suwaranganaya. Apanllshat kachizamashee zanganirangu, wazawapshat zapan, kapunguw paratzurangu, tputsee zapannaashat pacharangiya. Israelchich sundar pachayarana anoo kánurinashat kachizamash pacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Apanll waana Amorrewshuchee tputs Israelchicheem tuyamandarangu, uwshtisin pacharanganaya. Josueyshat anush Apanllee tsiyatku, Apaa, zar musá putpa. Zaree yuwar wayangcha Gabawonpatari tsap tasasaru. Tsupeetstam Aiyalonpat tsap tándsapa tasasaru wayangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Josuey tárangu, Apanllshat anuritam zaree, tsupeetstam anootsiri tuxiykeerangiya. Ashirangu, zar tsuppatari anootsiri xiyarangu, nda pakchiyam karuwarangiya. Ashirucha amb ashirangu, Israelchich undararee minum zar tsindas tamapari ashiru pacharangusin, izuuru kachingaranganaya. Nee tsiyatsis tputs sur Jaser zurampatari yandarangiya. Anoo nuwshat na zurampatartatam yandakina. Mang zaree Apanll anootsiri kanindap tuxiykeerangu, nda pakchiyam karuwku, minum zar tamapari ashiru taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","¿Antaati sirútama anootsiri zar xiyaru, minumtiyam patareezinllinaja? Mishat, ¿ayamtaati nimun zapish ashtacheeja? Itaru, Apanll Josueyaamam kapung chinaku, amb sheerangiya. Mishat, watam Apanll Israelchicheem kapung istamaam zandaranguwa. Ashirucha, waani undararee kasipana átu, zaree anootsiri tuxiykeerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Amb ashirangsin, anumun Josuey ichingaru tiptsirpatari, mishat Israelchichtamsin, yusur waptam watsapuniptamsin Guilgaalap kanapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Yuwatamsin Amorrewshuch zameetpat kurak kusarangana, antamsin mang puniksin, suwayarandsin, tsap Makedash wach wantsush pshtuyarusin, wanaatssin tapishuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Zapish tputsshitisin mang wachush tputsee paranganaya. Ashirucha, Josueyaatsshat kamanirangsin, ");
INSERT INTO cbuNT_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Josueyshat yusur wasundururee kamachtarangiya. Natu, naayarus patumbich kapung turputeerus anpat wachoo mbamari shtandayarus ksashinints. Itaru, sheerus, izuuru ksarintspa. Ksutamapaneem tutsangayarus, ksangtsa nda shitungamaama. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Sheerus, siysat sundaris anootsiri k'xinintspa. Arang yap kundararis suwayaranllina amb tachiteerus pchashinints. Watsapunip kususinapa. Izuuru ashpari kchingangints; kparintspa. Watam Apanll waana siyaam, kundarareetsis pachamaam kamachtaranguwa, Josuey tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Amb ashirangsin, Josuey Israelchichpat izuuru Amorrewshuchee tpachingayarusin kasaranganaya. Zapan Amorrewshuchee tputs pacharanganaya. Pakchimshitisin yaktarinpini suwarangusin, izuuru yaktareetsini watandpun wach mbamari shtandayarusin kasaranganaya. Sheersin, nda pakchiyam shitungaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Itaru, Israelchichshitisin tputs nda tapazish tsiparanganaya. Ashparitisin tsas yusur Makedpitam tsap kanapuranganaya. Amb ashkana anumandari tputs yasaksin, Israelchichee mantsir tsiyatamaam puniranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Josuey yusur wasundururee kamachtarangiya. Ashiri natu, wachoo yusur tawateerus, zameetpatari kurak putayarus, ishitungangints, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Israelchichshitisin sundar anuritam wachoo tawateersin, ashpari kurakaa putayarusin ishitungaranganaya. Irusarinshuchee, Hebronshucheetstam, Jarmutshucheetstam, Lakisshucheetstam, Eglonshucheetstam ashpari kurak putaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Putayashinusin, Josueyashshat yushindaranganaya. Josueysha ashpari sundaroo kuruzeeru, sundarootsshat urkar kamachtarangiya. Natu, naanints. Nee kurakaa putayarus, tsapush kpitangints. Sheerus, wayarpunish ktsiptis katitarus ksangints, tárangu, sundarshitisin urkar ayu tárangusin, kurakaa tsapush kapeeteersin, tushineersin, wayarpunish katitangat ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Ashirangsin, Josueyshat yusur tsiyatarangu, Ashiri siysat kundararpatini waratamaam punirintspa. ¿Mayaamaja sambaytachich? Arang kizpurtayarus, nee kurakaa kiyung yachangints, watam waana siyaam nee kurakaa piy ashimaam kamachtaranguwa. Ashiri siysat anuritam tuminungints, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Natu pachayarus, wayarpunish wasikpa spuyarus, yuwar yasinamun kayxuyarus ksangints, Josuey tárangiya. Sundarshitisin pachayarusin, wayarpunish spuyarusin, minumtawari yasinamun yuwar kayxuyarusin, waani neetsiri zar pup atusin, anootsiri kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Zar pukamatshat Josuey wasundururee kamachtarangu, wasundururshitisin tsapush yusur yaruwayarusin, yuwashtam wach tapishurangana, anshutam tapshuyarusin kasaranganaya. Sheersin, yuwaptatam patumbich shtandarangana anpatatam yusur shtandaranganaya. Anoo nuw zurampatari atina, An patumbich na wandaritam taariya. Ashiriya, na kamaneena yuwaa Amorrewshuchee kurak Israelchich kachingarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Minushshat zar Josuey ashpari Israelchichee tputs kuruzeeru, Sekemash tsap shaniyaranganaya. Ichingaru wachinawaa, kurakawaatstam, kizpur kurak ksutamapan taakana anootstam, mishat tsipasaw kurak taarana anootstam ichingaru kuruzurangiya, Apanllee kuk ashparitani mazinapani átu ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Iyaana Apanllirini, Israelchichtamtis Apanlliris ateeja iyaatsi. Sirútama siy zitaminaris sur Terarini wip tsimbunari Apramarini, mishat Nahoratam ashirusin, kungumun Eufratisamun wing taarangana. Anin uru apanllputseetsim kis ungirtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Ashirangsin, itaru nuwshat Apramarineetsi Eufratisash kung ishitungarangina. Sheeruri, Kanaanapshat tsap zanganirangina. Kanaanashshat tsap kusarangu, nuwshat tsiyataranguri, nishurishat Kanaanash tsap piyamaw xikush taangcha, táranguri, anumun zapish wachinllinoomshat tuzapaneerangina. Itaru, ichtaru wipaam panarangina Isaakaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Apramarini Isaakaa iparinarangu, Isaakshat uwshat arang tsimbun iparinarangiya, Akop, mishat Esaw ashiru. Esawsha kanungarangu, arap minup tsap sur Seirap machip taakamchu naatarangiya. Akopshat wip ashpari Ijiptop tsap taakamchusin naatarangtamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Ashirangu, Akoparinchich wachinllin zapan Ijiptosh tsap pzapaneeranganaya. Sheersin, kiyung kachiykachinllina anoom ishitungamaam, Nuwshat Móysisarinee, zoonllpatari Aaronpat, zanganirangina. Ashiranguri, uwshtisin zapan Ijiptoshchee tputs pacharanganaya yuwamand siyaa zitaminaris pachindarangana anumanda. Amb sheeruri, siyaa zitaminaris nuw Ijiptosh tsap tashitungarangina. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Anshat siy zitaminaris Ijiptoo tsap shitungeerandsin, anungaz Ijiptoshuchsha sundar pachani atusin, kapaachush pshiyrshini tapazpanish kapaach tachitarangsin, Mar Chumbeepimashish kamataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Nuwaatsshat kuruzurangsin, Apaa, tapachindanda, tárangusin, Nuwshat tapish wayarangina Ijiptoshcheema. Ashiranguri, tapish nda pamaam waritarangusin, yuwash masatatarana anush nuwshat maraa zanganiranguri, mikeeru Ijiptoshchee kung purangiya. Amb ashirangu, ichingaru sundar kungush yangarangusin, tsiparanganaya. Siy yasaktamsa yuwaa nuw Ijiptoshchee waneerangi anootsi. Siyashuch Ijiptoo tsap shitungarangsin, zapan masach apusap tsap xitangat ashkusin taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Natshat, siy anuritam, yuwash nuw siyaam Amorrewshuchee watsapun itutseeri, zar yaku amb Ortagap panarangi amb xiksa. Amorrewshuch siyapat waratarangsin, nuwshat siyaam kapung istaranguri, siysat ashpari tputsee kachingarangus, na siysat anoo tsap amuytaksa, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Anumun, Mowabshuchshat kurak Balak, Siporarini wip, siyapat waratamaam zandkitaa, itaru uwshtisin siyaa puniranganaya. Ashirucha, puniksin minootsshat kurak, Beorarinee wip, Balamaa kuruzkanaya. Naani, ningeema. Nuwaam istanda. Israelchichee zutayarush, ashchiri tamantsayarush, ksangi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Itaru, nuwshat Balamaa waneeranguri, Papcha, Utaáshuchee mantsir tsiyatinllpa, táranguri, uwshat anuritam nuwaa kuki payurangu, nda siyaa mantsir tsiyatarangiya. Amb táranguri, nuw siyaa tapachindarangina. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Siysat aranginashat naatarangus, kungoo Ortagaa arachichshat kitarangsa. Ashirangus, Jericoyashshat tsap kusarangus, anshuchshitisin Amorrewshuch, Feresewshuch, Kanaanshuchtam, Hititshuchtam, Gergesewshuchtam, Hebewshuchtam, mishat Jebusewshuchtamsin, siyaa parangusin, pachamaam zandaranganaya. Itaru, nuwshat siyaam istaranguri, siyamari ashparitaa an yakat kasirangsa. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Siysat Amorrewshuchish tsimbun kurak taarangu anoo ashpari kachingarangsa. Itaru, siy nda saanamuntari wizpuriris mchitarpatis, tsaktsakarpatis, mishat k'chirpunguriptis nda pacharangsa. Anoo nuwcha ndatuma siy kundararshis kuschus, nuw wasina siyamun k'kuz mazinakchusin, waani pxachinllinpa aturi, tpuxtamash wayayaruri, kasarangina. Ashirucha, uwshtisin yuwaa kakchis anoo mazinarangusin, kapung pxataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Ashirangana anush, siysat kusarangus, nuwshat anoo tsap siyaamsha panarangina. Na siysat mapiyrus shamangarus kis taaksa. ¿Antaati siy saana tarawaztayarus pangurangeezis? nda. Urutari pangus yupamawa anush taaksa. Mishat, mzatseetstam nda mzarangsa. Tputsshuritam mazar mapiyrus kizarunaa, olivootstam kis katungkus taarsa, átcha Apanll iyaatsi, Josuey tputsee kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Táyaru, Ashiri siysat Apanllee kuk payungtsa. Apanllee ungirtamaam zurampatari chinangtsa. Sheerus, Apanllimunarisha mangis tatungtsa. Sirútama zitaminaris yuwapur Eufratisamun kung wing taarangana, mishat yuwapurutam Ijiptosh tsap taarangana, anpur apanllputseetsimari kis ungirtarangana. Ambtam siysat shirintspa. Apanlleetsimari kis ungirtangtsa. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Itaru, siysat Apanllimun mangis tatumaam ngatkinaareesa, ashiri saana ipusangtsa. ¿Tamamaatsim Apanll ungirtamaam zandaksa? Wandaya yuwaatstam sirútama zitaminaris Eufratisash kung, mishat nishuchtam Amorrewshuch apanllputsimun mang' taturangana, anumuntam siysat mangis tatumaam zandkus, ashiri shingtsa. Amb ashkachus, itaru nuwshat ashpaatsiri nuwachich maachiriti iynaa Apanllimunamari mangini tatchinipa, tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Tputsishtisin anoo mazinarangusin, Zuraktishcha. Ayamtaati Apanllee kasacheezini. Urutamari Apanlleetsimarisha ungirtakuni taachinipa. Apanllputseetssha izuuru kasachinipa. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Watam sirútama Ijiptoshuch iyashchee, mishat iyashcheetstam zitaminarini, muchchureem wayarangusin, kiyung yacharanganaya. Apanllshat yuwaa kiyung kachiykachinllina anoo parangu, wamari kchinamsheeru tapachindayaru, Ijiptosh tsap ishitungarangiya. Mishat, ashiritam, iyashuch yuwapur apusap tsap naatarangani amb Apanll ksutarangtamta. Araptaa tsap naataranguni, ngootsishsha zapantaa yaktawaa tushiyranguni, itaru xarashish ndunarimuna. Mapiyruni naataranganiya. Watam Apanllimari kizpuriwa. Ashirupa iyaa tapachindarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Apanll waana ngootsee iyaam tuyamandarangu, na nishshat Amorrewshuchish tsap kusaranganiya. Apanllsha Amorrewshuchee tputs ashpari kachingarangu, iyaamshat nee tsap panarangiya. Ashirucha, iyshat Apanllee kis ungitamaam zandkiniya. Watam Apanll minumari kizpur kurak iyaana Apanllirini taakuwa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Itaru, Josueysha. ¿Tamari siy Apanllee kuk tatsamchis? Pinascha izuuru Apanllish tachitamaama. ¿Apanll nitaati yutaritaja? Apanllimari kizpur wanasir taaku, tputsee mantsir taamaam kizpur pachindkiya. Siyashuchshat tputs apanllputsee nda kasamaam zandkana anoo Apanllsha kapunguri ngatkiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Apaz siy Apanllee ngateerus, yusur apanllputseetsha ungirtakachus, uru Apanllsha siyaa yutaritcha, táchparee. Táyaru, kapung tsiyantakachu, siyaa wanichiya. Siyaam kapungtaa istarangu, itaru siysat nda kukoo payukis anumand uru siyaa waniyaru, kasachiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Tputsshitisin, Nduni. ¿Tamari amb ashtachini? Uru Apanlleetsimarishapari chinakuni taachiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Josueysha, Saanati Apanlleetsimarishapa chinakuni taachiniya, táyanllis, tárangu. Tputsshitisin, Zuraksha, watam iyaana táyanlliniwa. Uru Apanlleetsimarishapa chinakuni taachiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Josueysha, Ashiri na nimunarisha yuwis apanllputsimun mangis tatkis anis izuurisha kpitangtsa yuwaatstam na wandari apanllputsee kuwishis payuris anootstamta. Sheerus, Apanllimunamarisha mangis yareerus tchitangtsa. Watam saana Israelchichis Apanllirisawa, tárangiya Josueyshita. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Tputsshitisin; Uru Apanlleetsimarisha iyaanaatsi kurakarini ungirtakuni taachinipa. Yuwaa kamachtaku anootsimarisha tuminchinipa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Anpur zar Josuey Sekemash yakat ichingarusin tputs shaniyeersin, mangooz minumarisha chinayarusin, Apanlleetsimarisha kuk wanasirimshee chinachinipa táyarusin, tsiyatssee zurmamshee yandayarusin kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Josuey waana Apanll kamachtarangu anoo kirakamun Apanllee kuk yandayaru kasarangiya. Sheeru anumun, patumbichsha kapung yáyarusin, yasinash puch Apanllinungiri pang' wayayarusin kasaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Sheersin, Josueysha, In patumbich urutamari neetsiri taachpa. Ayamtaati nee patumbchee pakchus, urutamari mangishis chinatssa yuwaa Apanll waana siyaam kamachtarangu anootsiya. Siysat Apanllee mangoonamaam kasakchus, neetssha patumbchee pakchus, uru mangishis chinakchus, ¡Maa xam! Iyaanati nee tsiyatsis zuramamshee, Apanlleetsimarisha chinachinipa, tárangini. Nee patumbchee nda mbizamaama atuni, wayarangini tátssa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Shaniyshishee iwatsparamchusin, Josuey, Na tatsameenlltanda. Taarashpitamtis kanapungtsa, tárangu, tputsshitisin anooritam watsapunip kanaputaranganaya. Ashiriya, na kamaneena yuwaa Josueyarini Israelchichee ashpari kuruzeeru, Apanlleetsimarisha chinachinipa, tárangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Anumun zapish Josueyarini 110 masachirini taaramchu anush tsiparangiya, waana Apanll tiptsiri, Nomarini wipa. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Tsiparamchu, wanpeetam watsapun, Timnat-seranap yap Efrayinarini watsapun kizpur mach taarangu amb tashtap Gaspeem tsap mapuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Josueyarini ndatuma tsipachu, Israelchich Apanlleetsimari kapung chinaranganaya. Anumun iwaz wandaritam Apanllee chinaranganaya. Watam wachinanur yuwaa Apanll aship Israelchicheem istarangu anoo paranganawa. Ashirucha, anuritam chinarangusin nda mbizaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Yuwapur Israelchich Ijiptoo tsap shitungarangana anpur mang Osiyarineetsi wanap yáyarandsin, yapshat sirútama Akoparini Hamorarinee wip Sekemaa watsapun kurikpa 100 watsapuneem paxanxarangu ambshat mapuranganaya. Ashirucha, Josueyarinchich tputs ichingarusin izuuru anoo tsap watsapuneemarisha ínayarusin, izuuru tsapuntaranganaya Josueyamanda. ");
INSERT INTO cbuNT_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Aaronarinshitini wip Eleasararini tsiparangu, waanpee wip Finesap watsapun machimun iwaz mapuranganaya. Yap Efrayinarini Finesaam watsapun panarangu ambi. Ashiriya, na kamaneena yuwaa Josueyarini tsiparangu wanapootsimsha waparinap watsapun mapurangana anootsi. Wapparee. Watamcha Josueyarini Kuku.");
INSERT INTO cbuNT_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Apanll wasundururee kamachtayaru, Guilgaalamand tsap káyaranllu, Bokimapsha Israelchichee kamankatu naatarangiya. Anushsha Apanll wasundurur kuseeramchu, Nuw siyaa Ijiptosh tsap tashitungarangina. Ashiri yuwaa sirútama siyaam tsap panachima tárangi, anoo na tatsamchima. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Itaru, siy anshuchpa tputs tsiyatintspa. Yuwaa muchimaam wayarangana anootstam pátangantsa, táranginawa. Itaru, siysa anoo ¿tamarangsa? Yuwaa nuw siyaa kamachtarangi anoo nda payurangsa. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Ashirucha, na in siyaa istacheezi. Anshuch tputs siyaa uru yutarit ínachapantsa. Mishat, waashchee apanllputsirini siysa tachitarus taatssa. Ndusha mapiyrush taatssa, ");
INSERT INTO cbuNT_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","6","ántaru, Apanll wasundurur tsiyatssee iwatsparamchu, Israelchichsha tputs anoo tsiyatsis mazinarangusin, kapung tanuranganaya. Ashirucha, anootssha tsap yásamaranganaya Bokima atusina. Anshutam Apanllee ungirtamaam wayaranganaya. Ashiriya, na kamaneena yuwaa Apanll Israelchichee waneerangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Josueyarini kchitama ichingarusin kurakawtamsin, misha Israelchich tputs ashparitin Apanllee kuk zurmamshee Apanllee wanasirimshirini yuwaa Israelchichee tputs istarangu anoo payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Josueyarini tsiparangu, 110 masachirini tatsamoochu. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Waanpeetam watsapuni Josueyarinee mapuranganaya. Watsapun sur Timnat-seraj anush wayaranganaya, yapeem zar charapungaratu puku ambi tsap sura Gasa yásamarangana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Wachinawshitisin Israelchich tputs yuw Josueypa ipuntarana anshitisin tsiparangitamsinanaya. Ashirucha, yuw mang kaneesichsha nlluranur nllurtarangana anshitisin nda yasaranganaya Apanllee zuramapaneetsi. Mishat, nduntam yasaranganaya yuwaa Apanll Israelchichee istarangu anootsi. Ashiriya, na kamaneena yuwaa Josueyarini tsipayaru waanshutari watsapun mapurangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","13","Israelchich tputs Apanllee ungirtamaam kasaranganaya yuwaa sirútama zitaminarini ungirtarangana anootsi. Yuwaatsitam waanaatsi Ijiptosh tsap ishitungarangu, anootstaa kasayarusin, minootssha apanllputs yuwaa anshuchiri tputs ungirtakana anootssha uwshtisin ungirtarangitamanaya, yuwaatssha tputs patumbich tinayarusin ungirtakana anootssha. In watacha Apanlliya, táranganaya. Anoo patumbchee sur Baalaa, misha sur Astartee anootseewsha ungirtaranganaya. Anoo ashirangsin, kapung yutaritshishish pshturanganaya. Anumandsha Apanll kapung tsiyantarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Ashirucha, Apanll kapung tsiyantayaru, Watsta. Waani undarar pshtuyaru, pachanll. Maachiritawaatstam waani yachinllinaya. Mishat, waani taarashee undarar tayutaritchiya. Waamun nda pakchiyam taxaramaam waritachinllinaya, Apanll wasundurur tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Ashirucha, waratamaam shitungatssin, Apanllsha anoo tputs nda kis naparangiya. Ichingarusin Israelchich yutarit shitungarangiya. Apanll waana kamanirangu anuritam tatsamoorangiya. Ashirangu, anootsshat Israelchich parangusin, kizpur kapung mang' mantsaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Apanllshat, waana yuwaa kiyung kachiykana anoo parangu, minum kurak wayarangiya tapachindamaama Israelchicheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Itaru ashirangitaa, uwshtisin anoo kurakaa kuk nda payuranganaya. Apanlleetstam kuk nduntam payuranganaya. Sirútama zitaminarini Apanllee kuk payurangitaatssin, kamachtamarineetstam tuminurangtaatssin, itaru uwshtisin nllurnur anoo kapeetaranganaya. Apanllputseetsimsha ungirtaranganaya; Apanllee kuk nda tuminaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Itaru, Apanllsha waana kurakaam wayarangu, anoom istarangiya. An kurak kchitama Apanll Israelchichee tapachindatariya undarar anshuchee kiyung nda yachamaama, watam kizpur nayniranguwa. Yuwaa kiyung kachiykana anoo parangu istarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Itaru ashirangitaa, kurak yuw ksutamapan taarangu an tsiparamchu, yusursha Israelchich yutaritshishee chinaranganaya. Taárash aranginasha waparimand kasiru yutarit taaranganaya. Zapan apanllputseetstam ungirtaranganaya. Taarshee sirapchee kasamaam nda zandaranganaya, yuwaa mantsir ashkana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Ashirucha, Apanllsha Israelchichee: Siy nuwaa kuki nda payurangsa. Yuwaa sirútama kamachtarangi anoo kapeetarangsa. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Anumand naturitana Kanaanshuchee tputs kapeetcheezi, yuwaa Josueyarini kasarangu anootsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Táyaru, Na nuwsha anoo tsapurunas ksutchima. ¿Tamapari Israelchich nuwaa kuki payuchinllinaya? Sirútama zitaminarni tamarangpasinaya ashtachinllinaya; izuuru nuwaa kuki payuchinllinaya, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Ashirucha, Apanll Kanaanshuchee nda kapeetarangiya, yuwaa tsap Josueyarini kapeetamaam xapoorangu anootsi. Itaru, Apanllsha waana zandeeru, anoo tsapu waani taachpa tárangiya. Ashiriya, na kamaneena yuwaa Israelchich tputs Apanllee kuk kapeetarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ehudarini tsiparamchu, anamunsha iwaz yusur Israelchich tputs yutaritshishish tachitaranganaya. Apanlleetstam kuk kapeetaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Ashirucha, Apanll kasarangiya. Waani kurak Jabin yuw Kanaanshuchee tsap ksutku an kiyung yachachinllinaya, Apanll tárangiya. An Jabin sundarumuncha urkari. Anuritam sur Sisaramuncha tsap sur Aroset-goyimash taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Ansha kurak Jabin kapaachoo pshiyrshini 900 payurangiya. Anpat Israelchichee kiyung yacharangiya. Washunand tsimbun chunga masach Israelchich tputs kiyung kachiyaranganaya. Apanllee kuk kapeetarangitaatssin waantatamsin, Apaa, istangandama, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Anpur zar Debora kurak Israelchicheem taarangiya. An Debor wazaranll sur Lapidotarini taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","An kurak uxinash kuyan waru tamapari ashiru anush puch uru kis kuxinxinaw ashtariya. Efrayinash tsap machimun uxinash taarangiya. Yakat Rama misha yakat Betela ashiru, anush apusash uxinasheem wayarangiya. Ashirucha, anoo parangusin, Israelchichsha amb naayarusin, tsiyatssee yartaranaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Minushsha zar Balakarineetsi Debor kuruzurangiya tsiyatpi átu. Balakaa Abinowamarincha wipaya, watsapunsha Kedes anush taarangiya. Ansha tputs Neftaliychichimuncha. Anootssha Debor tsiyatku, Shiyaa Apanll kamachtakiya tputsee tushaneemaama. Mach Taborshu tushaneengcha. 10 mil tputsi Neftaliychich, misha Sabulónchichitamta washunandari tushaneengcha, tárangiya Debora. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Itaru, ambinasha sundar urkar wasundururee kamachtakachu, Siyaa pachamaam zapan kuschinllinaya. Mishat, kapaachtam pshiyrshini zapantam kuschiya. Itaru, siysa anoo punirintspa. Siyaamana Apanll wizpurirnee panachiya. Siyaam tuwasineekpaz ashtachiya, Debor Balakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Balaksha: Waritacha naamaama. Itaru, shaanpata ipuneeruni. Wandaya shiy naamaam pinasakush, nuwsha nuwaanitana naamaam pinasaktana, Balaksha tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Ashiri Deborsha: Ayu, nuwapapari ipuneeruch naachchi. Itaru, shiyaa pakich yasamaam kamankina yuwaa Apanll Sisaraa kasicheeja, tárangu, Kizamaripari kasichiya, tárangu, anootsi Debor tárangiya. Táyarandsin, Balakpat naataranganaya Kedesap tsapu. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Anush kusaranganaya, yuwash sundar washunand 10 mil shaniyarangana anshu. Ashpisin ashpatam Sabulónchichimucha misha ashpatam Neftaliychichimuna. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Itaru, Kenchichimuncha Móysisarini ungsiri, Itaru, minushsha zar watsta átu shitungarangiya yuwash taarangu anootsi. Sheeranllu, naatarangiya tsap sur Kedes kayumanashta anush taarangiya watsapun Sinayimshu. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Ashiriya, Sisarsha k'kuzee kamanirangu, anoo Balaksha Abinowamarini wip mazinarangu, machimun karuwarangiya sura Taboramuna. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Sisarsha wasundurur zapan tushaneerangu, marcharanganaya. Kapaachurintam pshiyrshini 900 payuranganaya. Ashirucha, aship payurangusin, Aroset-goyima anumand káyashinusin, marachatarandsin, Kisunash tsap kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Ashiriya, Deborsha kurak Balakaa: Natunaa shiyshat sundarurish machingi. Uru naakchush, shiyaam Apanll istachparee. Na in zar shiyaam wanasiritaa Apanll tuyamandachiya, Debor Balakaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Balaksha: Ayu, táyaranllu, wasundurur chung mil machtarangiya. Machimand Taboramand karuweerandsin, naarsin, apussha chamayangarangusin, warataranganaya. Apanllsha Sisarshuchee wasundurur tamiroosinlltarangiya. Kapaachush pshiyrshini naaku, anootstam tamiroosinlltarangiya. Ashirucha, waanpatatamsin pachakaktangat ashiranganaya. Sisarshuchee Balaksha wasundurur napatarach ashiranganaya. Anoo Sisarsha parangu, kapaachurinimuni pshiyrshini karuwaranllu, watspatarisha iripurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Balakshitisin wasundurur tachitaranganaya sundarootsitam, misha kapaachimun pshiyrshini naakana anootstam, k'chirpungpat kayungata, kayungata shitangat ashiranganaya. Kiyung yacharanganaya. Anpur zar ichingarusin Sisarshuch wasundurur tsiparanganaya. Nda minumtiyam kamungarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Sisarsha suwayaranllu, Jaelapsha pang' Eberap wizanll kusarangiya, watam sirútama Jaelaa wazaranll wamkurimun uwaa Eberaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Ashirucha, anootssha ambinaa kiz parangu, Naani ningeema. Punirinllpa. Nuw shiyaa pishuchinllpa pangishi, tárangu, pishurangiya yuwash nda tputs pakana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Sisarsha kizaa: Nuwaam kungurish pananda. Waachima, tárangu, kizsha ayu táyaru, wakaraa mimir tipayaru panarangiya. Waaramchu, yusur wapitam tapishurangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Sisarsha kizaa: Shiynaa pangusinung washitungash ksutataw shingcha. Tputs nllitarit kuskachu, shiyaa, ¿Chak nish wantsush pangishish taara? tákchu, shiysha: Nish wanindaja, tángcha, tárangiya Sisara. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Táyaranllu, Sisar wapitam pangusish pshtuyaru, kanuskamchu, anshurisha kizpur maarangiya. Maaramchu anush kizsha martich, misha yasin taxumtam aship yáyaru, yuwash maaru anush apinlliri natu, maachkiree yasinpa tutsatseeru martichpasha taa ashirangu, yasinsha muchoo tshutarangiya; tsapuptari tstsarangiya. Amb sheeru, Sisararinee pacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Balakarinsha amb kuseeru, nachungakatan ashirangiya Sisarariningazi. Anootssha Jael parangu, Nuw shiyaam yámandachinllpa yuwangaz nachungakish anootsi, tárangu, Balakaa pangush yapshturangiya. Anush uwsha Sisaraa parangiya. Muchush yasinpat tstsam tsapuptari tshutaru tamuru parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Ashirucha anumunsha, Apanll kurakaa Jabina, Kanaanshuchee urkar, kapung tpazarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Israelchichshitisin Jabinaa kapung kiyung yacharangusin, izuuru wipunashpatari kachingaranganaya. Apanll kizpur Israelchichee ksutarangiya. Ashirucha, waamaritin kasiranganaya. Ashiriya, na kamaneena yuwaa Debora kurak Balakpat ipuneersin Sisaraa wasundururpatari ashpari chingarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Debora, misha Balakaa anpur Apanllee yaseeksin, ántar ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","Apaa, wapparee, tángtsa. Nish Israelchich tputs zapan tapazeem taariya. Pza, kundararpatini warateeni, táranguri, waanaatsi watsipun nda pachindarangsin, Ayu, tárangana. Ashirucha Apaa, wapparee, ashparitini atiniya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","Kurakis mazinantsa. Mishat, ksutamapanitamtis mazinangtamtsa. Nuw yaseekina Apanllee zurmapaneetsi; nuw yaseekina Apanlleetsi, yuwaa Israelchichee tapachindarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","5","Ashirucha, shiy Apaa, iyaa imachirangush, machip tsap Edomap wizpurireetsish tuyamandarangush, tsap kizpur mundaztarangiya. Mishat, machtatam kanindtam kizpur ishipurangitamta. Ashkachu anush, msassha, misha sinatam tsapush kizpur pantsatarangiya. Ashirangush, machsha sur Sinayi mundaztarangitamta. Apaa, shiyamun wizpurirish ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","7","Sirútama tputs sur Samagar taarangiya. Anatarini wipa yuwapur Jaelarini taarangu anpur zar ichingarusin ngootsish naamaam pinasamuna. Chapungsha ngoots shunllip naataranaya. Mishat, tarawzupantam tarawaztamaam pinasaranganaya. Ashirucha, nuwsha Debori Israelaa tapachindamaam kizpur chinarangina. Kiz wipaa ksutku tamatarpari ashtapi tárangina. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Apaa, shiy iyaa pachamaam kamachtarangush, yuwamand iy apanllputsee ungirtarangini anumand Iyaatssha zapan pacharanganaya. Sundar 40 mil taarangtaa, itaru waratamaam pinasaranginiya. Watam k'chirpungurini nduniwa. Kizpur kiyung kachiyaranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","Itaru, na in shiyaa Apaa, wapparee atiniya. Kurakamuntam Israelchichimun mangini ksakaniya. Yuwamand watsipunoo nda pachindarangsin, tapazip kuruzaranguri, kis naatarangana anumanda. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","11","Ashiri yuwamand ashirangani anumand ichingarus Israelchichis taakis anis, pukiritamtis, misha kurikpantamtis Apanllee ungirtayani, yuwamand iyaa Israelchicheetsini tapachindarangu anumanda. Ngusambpa tsireej tsireej tángtsa. Apanll iyamari kasimaam istarangiya, tángtsa. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","Israelchichsha tputs táranganaya. Natu Deboraa, támangi, chiyzangi. Yaseengi minum yaseesshshi Apanlleetsi, Balakaa Abinowamarinee wipaa, shiysha natu chiyzangi. Sheerush, tputsirish putamaw machingi, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","Israelchich tputs ichingarusin karuwaranganaya waratamaama. Yuwapa iy kizpurtanicha tárangana anpata. Ashiritam, Israelchichsha tputs shaniyaranganaya, yuwanandari Apanll ipusarangu annandari chiyzartaranganaya waratamaama undararpata. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Efrayinchich tputs ashpatam wazawash karuwaranganaya. Anumunsha Benjaminchichsha wasundurur zapantamsin tachitaranganaya. Makirchichsha kurakaw karuwarangtamsinaya. Mishat, Sabulónchich kupeernuw Deboraam ksutarangana, ántamsina. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","16","Mishat, Isaakarsha urkar Deborpa ipunaranganaya. Isaakarsha Balakaam istarangiya. Uwsha Balakamun ush tachitarangitamta wazawap karuwamaama. Itaru, Rubenchichsha opeejaatsimari ksutamaam chinaranganaya; nda tapazip naamaam zandaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Minchichshitisin tputs Ortagumun wing arachich Galaadash tsap taarangtamsinaya. Danarini, misha Aserarini ashpisin patusish ksutaranganaya ichingaroo boti. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Itaru, Sabulónchichsha, misha Neftaliychichi anshasin nda watsipunu pachindaranganaya. Mapiyrsin pachamap naataranganaya pachakaatssina. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","Ashiriya, kurakshitisin Tanakshuch káyashinusin, kung Meguidush sur naattusin, anumunsha Kanaanshuchsha kurakaw kusarangtamsinaya. Pachani táyarandsina. Itaru, yuwaa amb ashchinipa tárangana anoo nda minumtiyam tatsamooranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Yuwapur waratarangani anpur íwarpichtam kanindpich tsangach Aparich wizpur kapung an tuwasineerangiya, waratkachuni Sisaraa iyamari kasimaama. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Sirútama, yuwapur Sisarpat warataranguni, iyamari tachiteeranlluni, pachakatanuni, Kisunapsha tsap kusatan ashiranguni, Ichingaru ashpartaa kundarareetsini kachingaranganiya. Uru arangitamanasha nuw Debori sundaruripti marchakuri, Apanllpa wizpur kasichima, nuw tárangee. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","Sisarsha kapaachurini zapan shitungeeshinusin, shurangakatunusin, waxizup kapung kimarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","Ashiritaa, Meroshuchsha tputs Sisaraa nda tuxararanganaya. Ashirucha, Apanll wasundurur, Nuw Merosshuchee tputs wanichima, yuwamand nda pakchiyam Israelchichpatatin istamaam zandarangana anumanda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","Jaela Eberaa wizanll, ¿tamaru shiyaam Apanll istaranga? Shiyamari kasiksha. Ichingaroo kizaptatis yuwaptatis washunand taakis anpatatis ichingaroo shiyamari kasiksha. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","Sisar shiyash kusarangu, Kungurish pananda waapi, tárangu, shiysha wakar mimir ksaneeyarush panarangsha. Sisarsha anoo kis waarangiya. Sheeru, kanuskamchu, maashipsha naayaru, kis maarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Maaramchu, anush shiysha, izari Jael, yasin taxumtam kuwish mbazinungach yáyarush, martichootssha mbutsanungach yáyarush, anpa apinll naateerush, maachkiree taa ashirangush, yasinsha taxumtam tsapuptari tshutaru tstsarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Ashirangush, Sisarsha tsipakchu, tum tum tum ashishtaramach ashirangiya. Shaanshu kutsish tamuramchu kasarangsha. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","Sisarsha wanir pangusinung washitungash kizpur mangu mantsaku, napanapaw ngootsip ashirangu, Ipari ¿tamanlleeja? Mishat, ¿kapaachutam tapazpan tamanlleeja? átu, mangu kizpur mantsarangu, anoo muchchursha parangu, ");
INSERT INTO cbuNT_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","Mangish mantsarinllpa. ¿Ndusha waamaritin, ");
INSERT INTO cbuNT_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","kasirangusin, sundaroom kizaa panakana? Mishat, ¿ndusha kamisaatstam wanasirimshee Sisaraam panakana? Mishat, ¿paneerootstam wayarpunish kapchamaam panakana? Ashkupsinaya, kureeranaya, Sisar wanir muchchur tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","Ashiriya, Debora misha Balakaa ashpisin Apanllee yaseeksin, Apaa, shiy ¿tamaru iyaam istarangsha? Shiyapat wizpurirish kundarareetsini ashpari kachingaranganiya. Kundarareetsish Apaa, ashparit kchingangcha. Itaru, na Apaa, yuwamarisha shiyamun mang' tatkana anumarishtisin waani taachinllinaya, zar wachamuree tamarupa tuwasinitariya. Ashirusin tuwasineersin taachinllinaya, Debora misha Balakaa ashirusin Apanllee yaseeksin ántar ashiranganaya. Anumunsha yuwamun waratarangana anumun iwaz, ipunpunar chungarani (40) masach ashchiri tsap wanasirsha taaranganaya. Ashiriya, na yuwaa Israelchich Apanllpa wizpur undararee kachingarangana anoo kamaneena. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Israelchich anumun iwaz yusur yutaritshishee chinaranganaya. Apanllee kuk kapeetaranganaya. Anumandsha Apanll tsiyantayaru, Waani Madiyanshuch tputs kiyung yachaksin taachinllinaya. Ichingaru arangich kuwiz tsimbun matayaru (7) masach kiyung kachiykusin taachinllinpa, Apanll Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Ashirucha, Madiyanshuchsha Israelchichee kiyung yachakchusin, suwaranganaya. Machipsha, misha wachushtam pshtuyarusin, tapishuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Ashiriya, Israelchichee tátsumimar Madiyanshuch pakchusin, ashpari ichingtaranaya. Mishat, Amalekshuchtam, mishat yapchitam zar yaku ambchitamsin tputs kuseersin, ichingarusin kiyung yacharanganaya Israelchicheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","6","Ashpisin an tputs pshturanganaya Israelchichish watsapuni. Anush kuseersin, mzatseewaatstam tayutaritaranganaya. Mishat, chinuwaatstam opeejarineetstam, misha wakararneetstam, misha burrootstam ashpartaa ichingaranganaya. Nda minumtiyam amuyaam kasaranganaya. Zapan kusataranganaya kameechumuna. Kameechoo táchimaam nda wanindamuna. Aship mzatsish pchich taataru aship kameechumun kuxinarusin kusaranganaya. Aship kusarangsin, Israelchichee kiyung yachayaranganaya. Anpuritam zar, tsap Gasash ashiritam kiyung kachiyaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Ashirangsin, Israelchich Apanllee tsiyataranganaya. Apaa, shiysha iyaa ashpartaatssini tapachindangcha, yuwaa Madiyanshuch iyaa kiyung yachakana anootsi, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","Apanllsha minum tputs ipuseeru, zanganirangiya tapachindamaama. Apanll ipusamarni kamanku, Yuw siyaa Ijiptosh tsap kiyung kachiykus tapachindarangu antam, ningeem siyap zanganirangiya, nuwaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Nda siyaatsimari yuwaa Ijiptosh kiyung kachiykis nda anootsimari tapachindarangiya. Minpichcheewa tsap yuwawaa kiyung kachiykana anoowaatstam tapachindarangiya. Mishat, yuwaa Apanllee kuk payukana anuwa istarangiya. Yuwaatsshitisin nda waanaatsi kuk payuku anootsshitisin tpachingayaru, watsapunee yuwaamsha waanaatsi kuk payukana anoomsha panarangiya watsapuneema, Apanll ipusamarni kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Apanllsha, Nuw kuki itsinsampancha. Nuw siyaa apanllputsee yuwaa Amorrewshuch ungirtakana anoo siysa ungirtarintspa, táranguri, itaru siysa nuwaa kuki nda payurangsa. Izuuru kapeetarangsa, Apanll Israelchichee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Anumunsha Apanll wasundurur kuseeru, Ofrash tsap yasinash puch kuxinarangiya, yuwash Jowasarini kuxinku anshu. Jowasarini Abiyeserchichimuncha. Jowasarini Jedeyon wipamuncha. Ashirucha, yuwash kizarunaa tiringeersin, wakungarimarisha vinoom yátarana anush Jedeyonsha tirikurineetsi tapusku, kuxinxinaw ashirangiya, Madiyanshuch parundama átu. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Anushsha Apanllsha wasundurur Jedeyonaa yakarangu, Shiy Jedeyonaa, kizpurtishcha. Shiyamari tputsee kasichsha, watam Apanll shiyaa kizpur ksutkuwa, Apanll wasundurur Jedeyonaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Anoo Jedeyonaa mazinarangu, Xamachi, ichee. Na shiysha mazinanganlla; Ashiriya, ¿tamasha Apanll iyaa ksutka? Ashiri ¿na in kiyung kachiykini anoo nda istaka? misha ¿tamasha nda wizpurir yámandaka? ¿Sirú Ijiptosh tamarangpari nda ashka? ¿Tamarina sirútama iy zitaminarni kamanirangsin, Apanllee wanasirimshirini parangtanicha? táranganaya. Ashiriya, na in Apanll iyaa watstamariparee kasarangiya. Waani Madiyanshuch kiyung yachaksin taachinllinpa tárangparee, tárangiya Jedeyonaa Apanllee wasundururi. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Apanllsha wasundurur Jedeyonaa napeeru, Nduni shiypari Israelchichee tapachindachsha yuwaa Madiyanshuch kiyung yachakana anootsiya, watam shiy kizpurshawa. Shiynaa nuwamun mangish tatungandama. Nuw shiyaam istachinllpa, Apanll wasundurur Jedeyonaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Jedeyonsha Apanllee: Itaru, Apaa, nuw ¿tamayreezi Israelchichee tapachindaychee? Watam nuwachich tputs wanindaja; pakchimani taariniya. Itaru, Manaseschich tputs zapansincha. Mishat, nuw ichingarumand maachiriti tsapushtana. ¿Antaati nuw kizpureezi? tárangiya Jedeyonaa. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Apanllsha: Na mazinancha. Shiy ichingaroo kapeetamaam waritaksha. Nuwapa wizpuriri nuw shiyaam istachinllpa. Minumtaatspaz tputs kapeetkachush ashtachsha. Ichingaru Madiyanshuchee shiyamari kasichsha, Apanll Jedeyonaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Ashiriya, Jedeyonsha Apanllee wasundurur: Nuwamaritaya, Apanllpa wizpur kasichuri, ashiriya shiysha nuwaam Apanllee wizpur yámandangandama zurampatarta nuwaama, watam nuwaa átshawa. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Musá kanapinllpa. Nuwash ktungangimasi; xamachi. Nuwma maachi yátama shiyaam mbutamaama, átu, Apanllsha wasundurur: Ayu, neetsiri shiyaam kutachinllpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Táyaranllu, Jedeyon pangup naayaru, anush kusarangu, minum kaapar pacharangiya. Mishat, chung kil tirik wasipuraa pangaam ísimaam yarangiya yuwamash nda tputaru anumashi. Anumunsha, wanutsee tsumbush pshtarangiya. Sheeru, wakungureetssha ngusambash zawarangiya. Aship an yushindarangiya Apanlleema. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Anoo Apanllsha wasundurur: Natu in wanuts patumbchimun wayangi; pangatam wayangi. Sheerush, anumun iwaz wakungursha tuchumungi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Sheeru, anumunsha Apanllsha wasundurur tushuwshishpa 5 wanutsee, misha pangaatsitam tu ashirangu, anuritam patumbichsha kurarangiya. Ichingaru muchirangiya wanutseetsi misha pangatamta. Ashirangu, anumun Apanllsha wasundurur tsipta ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Ashkachu, anoo Jedeyonsha paru, ¿Tamaru Apanll wizpur ashka? tárangu, kapung punirangu, Aay, tárangiya. Anush tsiyatku, Apaa, tsipakchima, watam shiyaptari sundarurish tasaseeruni, tsiyataranganiwa, Jedeyon Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Itaru, Apanllsha: Watsta; punirinllpa. ¿Tamareeja shiy tsipachish? Itaru, nuw shiyaam wanasirimash panati aturi, kusarangina, Jedeyonaa Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Ashirucha, sheeru, anshuri Jedeyon Apanlleem muchimaam wayarangiya. Yuwash muchku anootssha Apanll wanasirimshirini átu yásamarangiya. Yuw Jedeyonarini Apanlleem muchimaam wayarangu an na wandari taariya Abiyeserash tsapu. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Anuritam psaan Apanll Jedeyonaa: Aparpish wakararni napashini yuw masachirini arangich kuwiz tsimbun matayaru taaru anu. Itaru, yuw napkush wanasiri wanuts kapungu an yamancha. Sheerush, yuw Baalaam ungirtamaam aparish wayarana anoo toropat pshiyreerush, izuuru kpitangcha. Mishat, yasinatam apanllputs Asera anootstam kpitangtamcha. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Sheerush, anumun shiysha nuwaam muchimaam wayangcha. Patumbich yáyrush, wanasir kayateerush, anumun nuwaa ungirtangcha. Anumunshat, wakararish yáyarush, yuwapat yasin apanllputsee kapeetarangish sur Aseraatsi anpat yasin wayayrush muchincha, Jedeyonaa Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Ashiriya, anuritam psaan Jedeyon chiyzayaru, wasundururee chung yamayaranllu, naatarangiya. Yuwartatam Apanll kamachtarangu anuritam tuminurangiya. Itaru, nda kaschir patatamaam zandarangiya. Maachiritawaatstam, wapareetstam, misha tputseetstam yuwapa taakana anpatatin punirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Putamsha puturi tputs yuw anshuchiri taakana anshatssin yuwaa Baalaam muchkana anoo kapeetam paranganaya. Mishat, anshuritam yasin apanllputsish xiyarangu anootstam kapeetamatam paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Anootssha parangusin, waanpatatin masharanganaya; ¿Nee chakaja ashtar? táranganaya. Zapan mashta, mashta ashishtar ashirangsin, zapish yasaranganaya. Jowastanda wip Jedeyon sheeru, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Tárangusin, Jowasarineetssha: Natu iparish yamashini. Naturi pachachinipa. ¿Mayaamsha yuwaa Baalaam muchimaam wayarangini anoo, misha yasinatam anush xiyarangu anootsitam kapeetaranguwa? táranganaya Jowasarineetsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Tárangusin, anoo Jowasarinshitini: Itaru, na mazinangantsa. ¿Antaatiya siy tapachindamaam Baalaam waritakis? ¿Baalpari iyaa tapachindachiya siy átis? Yuw tputs Baalaam tapachindamaam chinaku an tsipamaam waritakcha ndatuma zar taraseeru. Ashiriya, Baal Apanlliya ¿tamasha nda tapachindaka yuwaa Jedeyon kapeetarangu anootsee? Jowasarini tputsee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Yuwash ashirangu anush Jedeyonaa misha suru yásamaranganaya Jerobaala atusina, watam Jowasarini tamapari Baal Apanlliya ashiru waanaatsi tapachindachiya, yuwaa waanaatsi ungirtashini Jedeyon kapeetarangu anootsiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Ashirangu, anumandsha Madiyanshuch, mishat Amalekshuch, mishat yapich zar yaku ambchitamsin washunand shaniyeersin naataranganaya. Kungoo Ortagoo kiteerandsin, Israelchichish tsap washunand shaniyaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Ashiriya, Jedeyonaa Apanll wasundurur kizpur ksutarangu, uwsha Jedeyon kaaparash wits yáyaru, kapung puu puu tárangiya tputsee ashpari tushaneemaama Abiyesershucheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Sheeru, tputseetstam zanganirangiya tsiyatssee kamanimaama. Uwsha tputs tsiyatssee kamanirangiya Manasesshucheetsi. Uwshtisin ashparitin shaniyaranganaya. Minootssha tputs zanganirangitamta minupsha kamanimaama. Uwsha kamanirangitamta Aserarinchicheetsi, misha Sabulónarinchicheetsi, misha Neftaliyarinchicheetsi. Ashpisin an washunandarisha shaniyaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Jedeyonsha Apanllee: Ashiriya, ¿kamapari shiy nuwaa istacheesha? Shiyapa wizpurirish nuw Israelchichee tapachindacheena. Shiyapa ichtaru tsiyatarangani anuritanaariya chinakush, nuwaam kamapari shaanaatsi wizpurirish yámandachsha. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Ashiriya, nuw opeejaa pur punll ashiru anoo wayachima yuwash tirikoo turambateersin ipuskana anshu. ¿Tamapari pusha puturi napkaturi, in opeej pur kachachtam kungupa pangchina? Wishchipsha tsapush ashchiri puz taturpiru anoo pangchina, Pakchuri, ashiriya, Zurakcha, táchima. Israelchichee tapachindachpachee Apanllpa wizpuriya, táchima, Jedeyon tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Jedeyon yapiritam shingi tárangu anuritam tatsamoorangiya Apanlli. Ashiri, putam puturisha Jedeyon chiyzayaranllu, naatarangiya. Anushsha opeejaa pur yáyaru, napku, kizpur kachach parangiya. Uwsha anoo yurupshirangu kung chkur ashirangu, minum mangaw tatsitarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Anumunsha yusur, Jedeyon Apanllee: Na yusur minumarisha kamachtamaam zandkina shiyaatsi. Itaru, yuwaa áti anoo tsiyantarinllpa. Na nimun opeejaa pur izuuru puzangcha. Sheerush, wishchipsha timburanlliz ashchiri izuuru kachachtangcha, Jedeyon Apanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Apanllsha anuritam psaan tatsamoorangiya. Putam puturi yusur napku, opeej pur ashchiri kizpur puz ashirangiya. Itaru, wishchipsha ashchiri kizpur kachachtarangiya. Ashiriya, na kamaneena yuwaa Apanll Jedeyonaam waanaatsi wizpur wanasiritaatsiri yámandarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Ashiriya, Jedeyon yuw Jerobaala atusin yásamarangana an wasundurur ichingarusin psaan tarasitaranllu chiyzartaranganaya. Sheerandsin, naataranganaya tsangamaama. Tsap Harodshu anushsha kusaranganaya, Madiyanshuchshitisin anumand yap zar puku ambiyam tashtap wazawash shaniyaranganaya Morey kayumanashta yuw Jedeyon shaniyarangana anu. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Apanllsha Jedeyonaa, Na mazinancha. Shiy sundarurish zapancha. Ashpis Madiyanshuchpa waratkachus, shiyamari sundarurish kasikchu, Yanpatataricha wizpurirni kasirangini kundarareetsini, táchpasinaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Ashiriya, shiynaa Jedeyonaa, sundarureetsish ashpari tushaneeyarush, mashangcha; Yuw tputs puniku an kanapumaam pangup waritachpari, tángcha. Ashiriya, Jedeyonsha masharangu, sundar 22 mil wapitam kanapuranganaya. Chungamarisha mil naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Yusursha Apanll Jedeyonaa tsiyatarangiya. Wandaritam sundarurish zapani. Ashiriya, kungup waamaam machingi. Anush nuw natstachima. ¿Tamamaja shiyapa naachinllina? Mishat, ¿tamamazinllinaja nda naachinllina? anoo natstachima, Apanll Jedeyonaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Jedeyonsha ayu táyaranllu, kungup waamaam machtarangiya. Anushsha kungoo waaksin, Apanllsha ipusarangiya. Yuwanandari timucheersin, kungoo waakana annandari piyam tushaneengi. Mishat, yuwanandaritam uwish kungoo tipayrusin, tumuz waataru ashkana annandaritam piyam tushaneengi, Jedeyonaa Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Ashiriya, sundar 300 uwish kungoo tipayarusin, tumuz waaku tamatarpari ashiranganaya. Itaru, piyartachshitisin ichingarusin timucheersin, kungoo waaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Apanllsha Jedeyonaa, Ashiriya, natunaa waritacha. Nipat sundar 300 anpat nuw tapachindachima. Siyamari Madiyanshuchee uru kasitssa nuwapa wizpuriri. Itaru, piyartashsha waani kanapuchinllinpa waanpeetaw pangu, Apanll tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Ashiriya, Jedeyonsha piyartachee yuwaa kanapkachinllina anoo wakararni wits yaranganaya. Mishat, muritsaatstam pakchee yaranganaya. Sheeru, ashiriya kanapuntsa siyaa táyaru, waamarishtisin sundar 300 anpat shaniyaranganaya. Anumand Madiyanshuch arap wazawash shaniyarangtamsinaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Ashiriya, anuritam psaan Jedeyonaa Apanll, Natu chiyzayarush, Madiyanash pshtuyarush, pachangints. Uru nuw shiyaam istachinllpa siyamari kasimaama. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Itaru, wandaya shaanitari pshtumaam punikush, sundarurpatish taaru anpat ipuneerush, naatacha napashinints yuwash Madiyanshuch shaneerana anshu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Anush kuseerush, mazinancha yuwaa anshuch tsiyatkana anootsi. Anoo mazinakchush, ndushapa punichsha, Apanll Jedeyonaa tárangu, uwsha ayu táyaranllu, ipuneerandsin tputs sur Puraa anpat naataranganaya yuwash Madiyanshuch wasundurur tsangarana ambi. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Anush kusarangu, parangiya Madiyanshuch, misha Amalekshuch, misha yapchitamsin zar yaku ambchitamsin tputs washunand zapan masaru tsapoo tstsamari tstsaru ashpari pchich mzatsish taataru, ashpari an shaniyaranganaya. Mishat, kameechurintam zapan shanee ashirangiya; ashpari mazachi táchimaam pinasamuna. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Anushshat, Jedeyon kusarangu, mazinarangiya. Minum sundar chiyzayaru, wipunashee kamanirangiya, yuwaa pamasarangu anootsi. Maaranguri parangina. Minum pang' katungamaam yutarita anumash machimand káyashinu kuripungaktaranllu, iyamunsha pangini chamayangarangu, tpaw ashirangu, iysha pangini yupangarangiya, amb ashiru pamasarangina, sundar wipunashee kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Wipunashsha an yuw pamasarangish an ¿antaatiya min chinashish wanindaja? Minumaritcha. Israelchich Jowasarini wip Jedeyon, ancha ichingaru Madiyanshuchee waamari kasichiya iyashuch sundaru, watam uru Apanll Jedeyonshuchee sundar kapungpari ksutchiya iyamari kasimaama. Anoomcha shiy pamasarangish, sundar wipunashee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Ashiriya, anootssha Jedeyon mazinarangu yuwaa pamasarangaru anoo, misha yuwaatsitam ashtachu anootsitam yasarangu, uwsha Apanllee ungirtarangiya. Sheeranllu, Jedeyon wapitam kanapurangiya, yap sundar shaneerana ambitamta. Anushsha kusarangu, ashparita sundar, Natu chiyzangints. Na in zar Apanll iyaam wizpurirneetsi panachiya. Iyamaripari Madiyanshuchee kasichchee, Jedeyon wasundururee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Sheeru, Jedeyon sundaroo tuchip chawpishtarangiya, Minush ashpatam, minush ashpatam, minushsha ashpatam ashiru wayarangiya. Anumunsha ichingaroom wakaraa wits panarangiya. Mishat, muritsaatstam pakcheewaa kayatama anootstam kurimunazeewaa ichingaroom sundar panarangitamta. Anushsha muritsash tuzaz pshtayarusin, ashparitin tirooranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Jedeyonsha ashparita wasundurur, Na watsiritkachuni, Madiyanshuchish taárash mangiptis nuwaa napangasindama. Nuw tamakina siysa ambitam shingtsa. Nuwashutam tuminungtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Yuwartatam nuwaana, misha sundaruri ichingarusin puu puu tákchusin, anuritam siysa ashparitamtis kapung puu puu tángtamtsa. Táyarus, kapung jeey jeey táyarus, Apanllpa wizpuri, misha Jedeyonpatatam wizpuri natu taringsints, tángtsa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Jedeyonsha wasundururee 100 machirangiya. Sheeranllu, Madiyanash watsapun psaansha kusatan ashirangiya. Zarpantaatiya wachamureetseem pakchimshita, yuw sundar ichtaru tsangaru, anoo nllitaritaa sundar istamaam pakchimsha pishtaru anushsha ichingarusin, kapung puu puu táyarusin, muritsaatssha yuwaa tiroom payurutarana anootssha ashpari pátangaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Ashiritam minshitisin tsimbunisin chawpishtam piyam shaneeru, piyam shaneeru, ashirana anshitisin anuritam ambitam ashiranganaya. Yuw tuzazee tiroom payurutarana anoo mbazinungich íwar itsiraranganaya. Mishat, wakaraatssha wits mbutsanungich yaranganaya. Sheersin, kapung puu puu táyarusin, Jeey, jeey. Apanllpa wizpurirni, misha Jedeyonpatatam wizpurirni taringsints kaapanapa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Israelchich zamangarangusin, anumun pakich zamata ashiranganaya. Yuwashuri taturpeersin shaneeru, piyam shaneeru, ashirana anshoowarita. Anootsshat undarar Madiyanshuch sundar mazinarangusin, suwamaam iripumbaranll ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Itaru, Israelchich yusursha puu puu tárangusin, anush Apanllsha undararee Madiyanshuchee wasundurur tamiroosinlltarangiya. Waanpatatshitisin pachakaktangat ashiranganaya. Ashpatamsin suwaranganaya. Sheerandsin, ngoots sur Bet-sita amb naayarandsin, yapsha waantin watsapun Abel-Meholá tspakatu ambsha kusatan ashiranganaya, tsap sur Tabata watsiritanashta. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Ashiriya, Jedeyonsha sundaroo kuruzurangiya Neftaliychichee, misha Aserchichee, ichingaroo Manaseschicheetstam kuruzurangiya Madiyanshuchpa waratamaama. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Ashiriya, Jedeyonsha tputsish tsiyatssee kamachtarangiya ichingaroom tsap yuwash Efrayinchich taarangana anshucheema. Ansha tputs kamanku, Naanints ashparitis Madiyanshuchpa warateeni. Mishat, ashpatamtis Ortagoo kung ksutantsa anumand arangeem tuwash Bet-baramun katsiparu ksutantsa amb Madiyanshuch nda kitamaama, tsiyatssee kamanku tárangiya. Anootssha uwshtisin ichingarusin Efrayinchich kukoo payuranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Ashirangsin, anush pacharanganaya. Orebaatsi, misha Sebaatsi chingaranganaya, ashpari tsimbun kurak taarangu Madiyanshuchi anootsi. Orebaa pacharanganaya yuwash patumbich kapung machtaru kuxinaru anshu. Ashirucha, anumand anoo machee yásamaranganaya Orebaa atusina. Anumunsha Sebatsha pacharanganaya, yuwash kizarunaa kateersin wakungureetssha vinoom yátarana anshu. Ashirucha, anootssha kayatama yásamaranganaya Seba atusina. Sheersin, ichingaru Madiyanshuchee kachingaranganaya, Jedeyonsha Orebaa, misha Seba anoo much turuyaru, yáyranllu, naatarangiya. Wapitam yap kung Ortag arachich káyashinu ambitam naatarangiya. Ashiriya, na kamaneena yuwaa Madiyanshuchee kurak tsimbunari Israelchich chingarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Ashiriya, tputs Efrayinchichirini tsiyantaranganaya Jedeyonaatsi. Anush tsiyatkusin, ¿Mayaamsha shiy nda iyaa waratachtanitanda Madiyanshuchpata tárangsha? ¿Mayaamsha shiy nda iyaa kamanirangsha? táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Jedeyonsha, Na, siysa mazinantsa. Siyapa yuwapat waratarangis anpat táchkuch, ¿antaati tatsamooreeja? nduncha. Siy pakchimtaatiya waratarangus, itaru yuwaa iy waratarangani anoo arangeem kasiru waratarangsa. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Itaru, iysha Apanllpa wizpur warataranguni, putaranginiya Madiyanshuchee urkari. Orebaa, misha Seba anoo putayruni, pacharanginiya. Itaru, ¿tamaru iy ashkiniya? Iyaam Apanll kapung istarangiya, Jedeyon tárangiya. Anootssha tputs mazinarangusin, Efrayinchichirini Jedeyonaa kizpur tsiyantarangitaatssin, itaru chinarangshitisinaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Jedeyon, misha wasundurur 300 anpat naayaranllu, kungoo Ortagoo kitaranganaya. Ashirangsin, anush kizpur niziranganaya. Itaru ashiritaa, undararee aranginasha tachitaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Sheeranllu, tsap Sokotash kusaranganaya. Anushsha Jedeyon anshucheetssha tputs, Nuwaam katungats panangasinda. Sundarureemi martapi. Arap naaranguni, niziranganiya. Kurakaam Madiyanshucheem urkar Seba, misha Salmunaa anoom putapani atuni ashkiniya, tárangiya Jedeyonaa. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Sokotshuchsha kurak Jedeyonaa, ¿Mayaamshitaja katungtsee sundarureemish panachinee? Watam ndaturi putasawa, Sebaatsee misha Salmunaatsee, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Jedeyonsha kurakaa, Waritariya. Itaru, Apanllpa wizpur putachpariniya Sebaatsi, misha Salmunaatstamta. Putayachuri, yusursha ningitam kanapchiniya siyangzi. Anush kuskachuni, siyaa putayaruni, yasinpa wapar pizpatari taaru anpat pzkoochiniya, Jedeyon Sokotshuchee kurak tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Jedeyon piyamsha naatarangu, tsap sur Penuelpi. Anushsha kuseeramchu, anshucheetssha tputs yusursha katungtsee masharangiya wasundurureem martamaama. Anshuchshitisin nduntam katungtsee panamaam zandaranganaya. Sokotshuch kurak amarangpari ambitam tsiyataranganaya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Jedeyonsha, Waritariya. Na yuwangaz naayarani an iwapayachuni, nish yusur kuskachuni, na yuwaa kayateerus tsapupa íwar tuxiykeerangis anoo kapeeteeri kasachima, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Táyaranllu, naatarangiya. Anushsha Jedeyon undararee parangiya Sebaatsi misha Salmunaatsi, Sokotash tsapu. Anush shaneersin, wasundururpa washunand 15 mil yapchiptam zar yaku ambchitam kusarangana; sundar shanee ashiranganaya. Watam Israelchichi piyartacheetsimsha 121 mil pacharanganawa. Ashirucha, pakchimsha shanee ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Jedeyonsha anoo parangu, minushsha ngoots machip káreerachu naatarangiya. An ngoots yap zar yaku amb taarangiya. Anush naayarusin, kustaranaya tsap Nobshu, misha Jogbeyshu. Ashirucha, ambsha iturpiyashinu, yuwashsha mapiyrana anushsha pshtuyarusin, pacharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Ashirangsin, anush Seba misha Salmuna suwaranganaya. Ashirangtaatssin, itaru Jedeyonsha wasundururpa tachitaranganaya. Anush ashparita kamateersin, putaranganaya. Yuwash ashirangana anush Madiyanshuch zapan waanpatatamsin mamarparanganaya; misha kapung puniranganaya Israelchicheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Jedeyon pachamap kanapeeshinu, ngootsish naanatanusin, yap Eresa tsap naakana anush, ");
INSERT INTO cbuNT_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","kanungasee Sokotshuchee parangu putarangiya. Putayru, masharangiya kurakaa suru. Uwsha kanungassha ichingaru kurak 77 taaru anoo sur kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Ashiriya, Jedeyonsha anpataw Sokotshuchpa kurak tsiyatamaam naatarangiya. Anush kusarangu, Siy nuwaa tayutaritarangus, mantsir tsiyatarangus, misha nuwaamatam sundarureetsi katungtsee nda panarangsa, watam ndaturi kurakaa Sebaa misha Salmunaa putasawa, átus, ¿Mayaamaja siyaam mangutaritani katungtsee panachini? tárangsa. ¿Yuwaa tárangis anoo chinaris? Na in yuwaa tárangis anoo yushindaranginiya, tárangiya Jedeyonaa. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Táyaru, anumun Jedeyon Sokotshuchee kurak putayru, pzkoorangiya yuwapa yasin wapar taaru anpata. Sheeru kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Sheerandsin, minupsha ngoots kusarangiya. Anushsha yuwaa tsapupa kayateersin, íwar tuxiykeerangana anootssha kapeetarangiya. Ansha yupangayashinu, anshuchee tputs zapan pacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Sheeru, anumunsha Jedeyon Sebaa misha Salmunaa masharangiya. Yuw siy tputsee Taborash pacharangis ¿an chak ashiru parangsa? tárangiya. Sebsha, misha Salmunaa anshitisin, Shiy tamapari ashiru anoo pacharanginiya. Mishat, wamartam wanasireew kurak wip ashirusin paranginiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Anootssha Jedeyon mazinarangu, kapung tsiyatarangiya. Yuwaa siy pacharangis anoo nuwcha zuwanlli washunandari minumtashuri aneerni nllurtarangini anu, Apanll waana yasaritamta. Itaru, waanariya siy nda nuwaa zuwanlli pacharangus, watsta pachamaama táranginaareesa, ashiri nuwsha na in siyaa nduntam pachachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Tárangu, anumunsha Jedeyon wipaa putsisarineetsi sur Jeteraa, Natu in tsimbunari pachayarush ksangi, tárangu, wipsha Jeter nda pachamaam zandarangiya. Watam nlluraritawa, Ashirucha, punirangiya pachamaama. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Sebaa misha Salmunaa anshitisin Jedeyonaa, ¿Mayaamsha shiy kizpureesha nda shaana iyaa pachaksha? Natunaa nuwaa pachanda, táranganaya. Ashiriya, Jedeyonsha ayu tárangu, tsimbunari pacharangiya. Sheeru, anumunsha yuwaatssha Seba, Salmuna kameechurini wayarpunish wayarangash xanuxanuru anootssha tapurirangiya. Sheeru, waamatari yarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Ashirangu, anoo Israelchich Jedeyonaa parangusin, Shiynaa kurakaam kinangcha iyaam kurakarini. Mishat, shiyachchinandaripari kurakaam kinachinlliya, watam shiy iyaa tapachindarangshawa, yuwaa Madiyanshuch iyaa kiyung yacharangu anootsi, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Jedeyonsha anoo mazinarangu, Nduni. Na mazinantsa. Nuw tamareeja siyaam kurakaris kinachi, misha ipartamti kinamaam wanindaja. Itaru, minumamari kurak taariya yuw siyaa ksutchu an watacha Apanlliya, Jedeyon tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Itaru, nuw siyaa atina ichingarootsis, Yuw anichoo yarangis anumari panangasindama. Anootsimari nuw zandkina, tárangiya, watam anpur Madiyanshuch sundar ichingarusin anichoo oroo pazutaranaya yuw tputs ambchi an ichingarusin pazutaranaya urutamarita. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Ashiriya, Madiyanshuchshitisin ichingarusin, Ayu, neewa. Yuw yarangini anu, tárangusin, ngootsish chirik kapung muteersin, anumun ichingarusin yuwaa anich oroo yarangana anoo xanataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Ashirangsin, anoo Jedeyonsha 19 kilo yarangiya anichunandarita. Anumunsha panarangitamsinaya yuwaa sundaroo wayarangash yarangana anootsi. Mishat, chirikutam orpat tinamaa yuw kurakaw kamartarangana Madiyanshuchi anootsitam panaranganaya. Mishat, kameechootsitam xan yuwaa orpat tinam xanurangu anootsitam panaranganaya. Ashpari yuwaa yarangana anoo panaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Jedeyonsha oroo yuwaa yarangu anpat waanshusha taárash tsingashee tuwachimapan tinayaru, anootssha Israelchich tputs ungirtaranganaya ichingarusina. Ashirucha, amb ashirangsin, Apanlleemsha nda zurampatari chinaranganaya. Ichingarusin Israelchich, misha Jedeyonatam maachirit ashparitin Apanllee ungirtamaam kasaranganaya. Sheersin, tsingashimunamsha mang' taturanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Ashiriya, Jedeyon Madiyanshuchee waamaritin kasiranganaya. Nda pakchiyam uwshtisin anumand kisataranganaya. Anumunari tapaz pastarangiya. Sheersin, Jedeyon kchitama 40 masach wanasirsha taaranganaya anush tsapurunasi. Ashiriya, na kamaneena yuwaa Israelchich waamaritin Madiyanshuchee Apanllpa wizpur kasirangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Jedeyon waanpeetam watsapun taamchi átu naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","Anushsha wizanll zapan taarangu, wipsha 70 pzapaneerangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Itaru, minushsha tsap Sekemash wizanll taarangitamta. Anushsha kiz minum wip wanindarangiya sur Abimeleka. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Anumunsha, Jedeyon kizpur wachinarangu tsiparangiya. Tsiparamchu, mapuranganaya. Yuwashutam waparee Jowasarineetsi mapurangana anshutam mapuranganaya, tsap Ofrashu yuwashuri sirútama taarangana anshu. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Ashiriya, Jedeyonarini tsiparamchu anumun Israelchich yusur yutaritshishee chinaranganaya. Apanllputseetsimsha Baalaa apanllirineemani ínaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","Apanlleetssha wanasirimshee kasayarusin, yuwaa waanaatsi kapung istarangu undararee tapachindarangu anoo mbizaranganiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Jedeyon tputsee kapung istarangitaa, undararee kasirangitaa, ashiritaa Israelchich tputs nda pakchiyam chinamaam zandaranganaya. Ashirucha, Jedeyonaatssha maachirit niyrarangitamsinaya. Ashiriya, na kamaneena yuwaa Jedeyon tsiparamchu, yusur Israelchich yutaritshishee chinarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Ashiriya, Israelchich yusursha yutaritshishee payuranganaya. Apanllee kuk kapeetaranganaya. Ashirucha, anumand Apanllsha tsiyantarangu, Israelchichee waani Filistewshuch kiyung yachaksin, 40 masach taachinllinpa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Anpursha zar, minum tputs sur Manowa tsap Surash anush taarangiya. Ansha tputs Danarinchichimuna. Wizanllpa taaranganaya. Itaru, kizsha mipshimuna; nda iparinarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Ashirucha, anoo kiz Apanll wasundurur kuseeru, Nduntaatiya shiy iparinarangush mipshitaa taarangush, itaru taarashitish wanasir taarangsha. Ashirucha, na nimun mirichpasha; kamuzpari iparinachsha, Apanll wasundurur kizaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","5","Ashiri iparish yuwari nllurtakachu anuri apanllpaneem taachiya. Itaru, shiysha vinoo waamaam watsta. Mishat, waashee pakchiyam kshaam waamaam watsta. Mishat, katungtseetstam mantsamu katungamaam watsta. Mishat, nlluraatsitam muchoo ktireemaam watsta. Watam in nllur kanungkachu yuwaa Filistewshuch Israelchichee kiyung yachakana anoo tapachindachuwa, Apanll wasundurur kizaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Kizsha anoo mazinarangu, wazaranllee kamaniti átu, iripurangiya. Anushsha wazaranllee kamankamchu, Nuwash minum kamuz Apanll wasundurur ashiru kusarangiya. Yap nda chiynaari amb kusarangu, kapung punirustarangina. Mishat, nda surootsitam masharangina. Mishat, wandatam ambcha káyashini nda tárangiya. Itaru, Napakshiti. Ashchiri wanuts misha tashitam Apanllpaz wani ashiru parangina, wazaranllee kiz kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Itaru, yuwaa tsiyatku mazinarangi an nuwaatsimari, Uru shiy mirichpasha. Iparish kamuzpari wanindachsha, An nllur yuwamandari nllurtakachu anumandari apanllpaneempa taachiya. Anpatari wachinayaru, uru tsipachiya. Ashirucha, shiy vinoo na waamaam watsta. Mishat, yuwaa waashish kasha anootsitam waamaam watsta. Mishat, mantsamootstam katungamaam watsta, átcha, kiz kamanku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Ashiriya, anootssha kiz wazaranll sur Manowa an mazinarangu, Apanllpa masharangiya, Apaa, ¿shiy tamaru ashiksha? Yusursha yuwaa tputs zanganirangish anoo zanganingcha. Nuw yasamaam zandkina iyaa kamanimaama. In nllur nllurtakachu, ¿tamacheezini anooma? Manow Apanllee mashku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Apanllsha anoo mazinarangu, yusursha waanaatsi wasundurur zanganirangiya. Kiz waani mzatsish xiytu anush Apanll wasundurur yusur yakarangiya. Wazaranllsha ambiri pangusip taar ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Ashirucha, kizsha Apanllee wasundurur parangu, wazaranllip iripurangiya yamati átu. Anushsha, wazaranllish punirustaru iriptaranllu, Manowaa, yusursha tputsee parangina yuwaatsitam pakchi anootsitamta, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Ashiriya, Manowsha chiyzaranllu, yap wizanll Apanllee wasundurur pakeeru amb iripurangiya. Anush kusarangsin, anuritam Apanllee wasundurur paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Ashiriya, Manowsha Apanllee wasundurur, ¿Tamaycheezini yuw tárangish an zar tatsamkachu? ¿Tamayreezini nlluraa yanungachinee? Mishat, ¿arangeem tamaycheezinee? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Apanllsha wasundurur, Manowaa, Izanllish tuminuchpa yuwaa kamachtarangi anootsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Yuw tárangi an watacha, yuw waashish vinpat tinamaa anoo waamaam watsta. Mishat, katungtsitam vinpat ísima anootstam katungamaam watsta. Mishat, yuw waashish kasha an waamaam watsta. Mishat, katungtseetstam mantsamoo katungamaam watsta. Yuwari áti anuri tuminungtsa, Apanll wasundurur tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","16","Manowsha nda Apanllee wasundurur yasaru, Musápa. Neetsiritamapa. Nuwma minum kaapar pachayaruri, patatchima. Shiyapa katungpani, tárangu, Apanllsha wasundurur, Nuw shiyaam kutaktaateena, ¿tamayreezi nuw yuwaa patatirish anoo katungeechi? pinasaktana. Itaru, wandaya amb ashimaam zandkeesha, patumbchimun wayayarush, muchingi Apanlleema, Apanll wasundurur tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Ashiriya, Manowsha Apanllee wasundurur, ¿Shiy surish chaksha? Kamaningandama sureetsish. Iyshat anumand yasayaruni, shiyaa wappari táchinipa, yuwash shaana kamachtarangish anush zar tatsamkachu anshu, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Ashiriya, Apanllsha wasundurur, ¿Antaatiya nuwaa suri tputs minumtiyam yasamaam wanindaja? Ashiriya shiysha ¿Mayaamsha nuwaa suri mashaksha? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Ashiriya, Manowsha anoo mazinarangu, minum kaaparaa pachayaru, patumbchimun yuwamun wayayrusin, Apanllee ungirtatarana anumun uwsha wayayru, Apanlleem muchirangiya. Ashirangu, anush Apanll kizpur wanasirimsheerinee yuwamshee nda patarana anumashee tuyamandarangu paranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","21","Anushsha Manow wizanllpa napatarandsin, sumas patumbchish kurakataru, shtungataraa ashirangu, anushsha napkusin, Apanll wasundurur yuwash sumas kurakataru anush apusanand naanataratu, káriritarat ashirangiya kanindpi. Anootssha parangusin mangoonaranganaya. In tputs Apanllcha waniya, tárangusin, tutunlltayarusin, timuchta tsapumun char tuw ashiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Ashiriya, ashima parangusin, Manowsha wizanllee, Tsipachpachi, watam Apanllee paranginiwa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Itaru, wizanllsha, Nduni. ¿Tamareeja tsipachich? Ashiriya, Apanll waanariya iyaa pachamaam zandku, ashireeja kaaparaa Apanlleem muchirangani anoo kis naparangiya. Mishat, ¿nduntam waanaatsi wanasirimshirini yámandarang? Mishat, ¿nduntam iyaam tsiyatssee amb shingcha nlluraatsi átu kamanirang? Ashirucha, nuw, Iyaa kizpurpari chinakiya, atina, wizanll wazaranllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Anumunsha kiz wip wanindarangiya. Anootssha nllura yásamaranganaya Sansona. Ansha nllur kanungarangu, Apanllsha nlluraa wanasir ksutarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Minushsha zar Danarinshi taarish, yuwash shaniytarana anush tsap sur Suraa anumunsha. Istayarish shaniykusin, Apanllsha wasundurur anush kusarangu ksutarangiya Sansonaatsi. Ashiriya, na kamaneena yuwaa Apanll Sansonaa nllurtarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Sanson yaktap Timna amb naayaranllu, anushsha kuseeru, Filistewshuchee kiz pakeeru, yamapi átu tsiyatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Anumandsha yakat kanapeeshinu, wapareetssha kamanku, Apaa, yakat Timnash kizaa kamasina Filistewshuchee yamapi túri nuw tsiyatarangina. Ashiriya, apaa, shiysha ichingaru iwapangcha, yuwaam shaniyeeruni nuw kizaa yamachi anooma, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Ashiriya, waparsha wipaa, ¿Mayaamsha anshuchee kiz yamamaam zandaksha? watam anshuch tputs nda pakchiyam Apanllee kuk yasaranawa. ¿Mayaamsha nda yanpatataritana kiz nachungayarush yamaksha? Mishat, ¿mayamna nda Israelchich kiz yamaksha? táranganaya wipaatsi. Itaru, wipsha Sanson waparee ashiritaa tsiyatarangiya. Watam apaa, nuw anoo kiz kizpur zandkinawa. Ashiritaa naayarush, nuwaam izanlleemi mashashini, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Anoo waparsha nda yasaranganaya yuwaa Apanll waana amb ashtachpa tárangu anootsi. Nguti amb sheeruri, Filistewshuchee tamapingayruri pachachi, átu, ashirangiya. Anpursha zar Filistewshuch Israelchichee kiyung yacharanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Ashiriya, Sansonsha waparpa yakat Timnap amb naayarandsin, yakat kayumanasha anush Sanson piyamsha mzatsinung ktapeeranllu yuwash zapan kizarunaa tatsumirana annung naantachu, yap nda chinaru amb tumuz watarimash zamaam putarangiya Sansonaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Itaru, Apanllsha wasundurur Sansonaa ksutarangiya. Wizpureemsha kapung panarangu, tumuzee putayaru, uwpa isisangambeeru, kapeetarangiya; kaaparaatspaz wipa ashirangiya. Itaru, wapareetssha anoo nda kamanirangiya yuwaa tumuzee ashirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Sheeranllu anumun musásiritam kusarangiya yakat Timnashu. Sansonsha kizapa tsiyatati átu naatarangiya kizap pangu. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Anumunsha, minushsha zar kizaa yamakatu, wapitam Sanson naatarangiya. Minushsha ngoots naantachu, yapitam tumuzee pacharangu ambitam napkamchu, tumuz wanuts ashchiri kinduraamsha tsutaru, wakungur kapung taaru parangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Anootssha Sanson yáyaranllu, ngootsish naantachu, katungatach ashirangiya. Katucheeranllu, waparishsha kuskamchu, kinduraa panarangiya. Anoo waparsha yáyarusin katungarangtamanaya wizanllpata. Itaru, nda Sanson kamanirangiya yuwaa kinduraa tumuzish yarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Sansonsha wapar, misha waniritam kizap pang' naataranganaya. Anushsha kizash pang' Sanson michitamaam wayarangiya, watam anpur urutari kizaa tputs yamakchusin, michitamaam wayataranawa. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Anootssha Filistewshuch kanungas mazinarangusin, 30 tputs ipuneerandsin naataranganaya michitkatssina. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Anushsha, Sanson ashpartaa kanungas, Na nuw siyaa minum tsiyatsis pishummash kamanchintspa. Siysa nuwaa anucha atatasha tángasindama. Watam nish arangich tsimbun matayaru kuwiz zar michinuz taachuwa; anush kamaningasindama. Kamankachus, nuwsha siyaam ashparitamaritis minumtaw anis k'tunireemis wanasirimash panachintspa. Mishat, k'tunitam yuw michinzeem k'tuntatarich anumashtam ashparitamis tatsamooru panachintspa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Itaru, wandaya nda siy kamankus tsiyatssee pishummashee, ashiri siysa nuwaam k'tunireemi wanasirimash panangasindama. Mishat, k'tunitam michinzipan ashparitatam tatsamooru nuwaam panangasindama, tárangu; ashiriya, kanungasshitisin ashparitin, Natu tsiyatsis kamaningi. Iysha mazinchinipa, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Sansonsha kamanku, Kázamshish katungats shitungarangiya. Wizpurisha kam shitungarangiya, tárangiya. Anoo kanungasshitisin mazinarangusin, anumun tuchip zar tushiyramchu anush nda minumtiyam kamaniranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ashiriya, ipunpunarinisha zar kanungasshitisin Sansonaa wizanll, Natu. Zaranlleetsish kamaninda tángi, sheerush shiysha iyaa kamanimaama, yuwaa tsiyatsis pishummashshee kamanirangu anootsi. Nduniya amb ashkush, uru shiyaa misha apareetstamtish, misha maachiritaatstamtish ashparitaatssis tiruchiniya. Watam siy iyaa kuruzurangis an iyaatsimari k'tunireetsini yapani átus tárangsawa, táranganaya kanungasshitisina. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Ashiriya, Sansonsha wizanll wazaranllee tanuntaranllu, ¿Mayaamsha shiy tsiyatssee pishummashee kamanirangsha? Anootssha amikurshiti nuwaa kamanirangiya. Anoo yasaranguri, shiy nuwaa nda zandaksha. Mishat, nuwaa watsta átpasha. ¿Mayaamsha shiy nuwaa nda anoo tsiyatsis itsinsaru kamanirangsha? tárangiya wizanlli. Itaru, Sansonsha wizanllee, Na shiy kizish mazinanganlla. Nuw apareetstaati, misha aneereetstamti nda kamaniranguri, ashiri ¿tamashtaja shiyaatsinaashtaja kamanchi? wizanllee tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Itaru, wizanllsha ashiritaa, kizpur mang' mantsaku, tanutantar ashirangiya. Ashku anush zarsha kachingarangiya yuw michinzeem wayarangana anu. Ashiriya, anushsha wizanllee kamanirangiya yuwaa tsiyatssee pishummashee kamanirangu anootsi. Wizanllsha kanungasee ashparita kamanirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Ashiriya, kanungasshitisin anoo tsiyatsis mazinaranganaya, kuwiz arangich tsimbun matayaru anush zari. Anuritam zar ndaturi puru, Sansonap kamanini atusin naataranganaya. Anushsha kuseersin, Na tsiyatssee kamanchinipa yuwaa tsiyatssee pishurangish anootsi, tárangusin, Ashiri kindur arangeem kamari kasiru wanindaja. Mishat, tumuz watarimash arangeem wizpur maacheetsi kasiru wanindaja, kanungaseew táranganaya. Sansonsha, Wappari. Yuwamand izanlli siyaa kamaneeru, siysa nuwaa kamanirangis anumanda, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Ántaru, anuritam Apanllsha wasundurur Sansonaam wizpureem kapung panarangiya. Ashirangu, uwsha tsap Askalonap naayaru, anshuchee tputs 30 pachayaru, watunireetssha ashpari yarangiya. Sheeru, anoo k'tunee yuwaam tsiyatssee pishummashee Filistewshuch kanungas kamanirangana anoomshat ashpartam panarangiya. Sheeru kasarangiya. Sheeru, wapitam waparip watsapun Sanson kapung tsiyantayaru naatarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Itaru, Sanson wamkur Sansonaa wizanll waamatarisha wizanlleem yamarangiya. Ashiriya, na kamaneena yuwaa Sanson wizanllee kamingaru anush waparsha minoomsha kanungas panarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Anumunsha, minush zar Sanson yapitam kizaa yamapi átu tsiyatarangu ambitam pakatu, minum kaapar putayaranllu, naatarangiya. Anpursha zar ichingarusin Filistewshuch tputs tirikoo, misha kizarunaatstam pusaranganaya. Anpursha zar Sanson pangusish kusarangu, Musámachi nuwma izanllshimasi mash napchimasima, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Itaru, kizsha wapar, Nduni. Xamachi; na mazinanganlla. Nuw shiyaa watstamaripari ipareetsi kasarangiya túri, minumsha kanungas panarangina. Itaru ashirangtaateena, shiy ¿may mangishish chinaksha? ¿Nda minootssha munaa nllurarineetsi yamamaam zandkish? Anacha munaa putsisaa wanasirirni aranginasha kasiru wanasir taarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Ashiri Sansonsha, Na shiy yuwamand nuwaa ashirangis anumand nuw kapung tsiyantayana. Ashparitaatssis chingayruri kasachintspa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","5","Ashiriya, anuritam Sanson piyam naayaru, xupshee 300 putarangiya. Sheeru, xupshee tsimbunaw wanishpatatari kamurita, kamurita, kamurita sheeru, anumunsha tuzaz tirooyaru, mbamari kamtata, kamtata sheeru, piyam zanganta, piyam zanganta, piyam zanganta ashpari mzats ashirangiya. Ansha sumas matayarangu, ashpari mzatsi yuwaa tirikoo pusayrusin xanatarana, anoo misha ashpatam ndaturi pusarana anootsitam, misha kizarunaatstam, misha olivootstam tatsumma, ashpari sumas matayarangu, ashpari mzats kurarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Ashiri Filistewshuchsha tputs anoo parangusin yuwaa mzats kurarangu anoo, waanpatatshitisin, ¿Chakaja nee ashtar mzatsee tirootar? táta táta ashirangsin, tputssha Sanson tsiyantayru tiroorangu, yuwamand wizanllee yuwaa kamingaru anoo wapar minoomsha tputs panarangu anumanda ashirangiya, táranganaya. Ashirucha, anumand Filistewshuchsha kizaa yuwaa Sanson yamapi átu tsiyatarangu anoo putayrusin, wapareetstam putayrusin, sumaspa muchiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Sansonsha Filistewshuchee, Siy, Amb ashkuni wanasirpari, átpasa. Itaru, nuwnaa zurampatari, Apanll yasaritamta nuwaatsi, nda pakchiyam kanuschima. Izuuru siyaa ashpartaatssis kachingeeruri, kasachintspa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Ashiriya, anuritam kapung tsiyantarangu, tputsee anshuchee zapan pacharangiya. Sheeranllu, tsap Etamap naatarangiya. Anushsha apus yuwash patumbich wach kawaru anushsha pshtuyaru, anshurisha taarangiya. Ashiriya, na kamaneena yuwaa Sanson Filistewshuchee Apanllpa wizpur kisatarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Filistewshuchsha sundar pachani táyarandsin, Utaásh anush kuseersin, yakat Leyish pshturanganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Utaáchichsha tputs, ¿Mayamandsha iyaa pachamaam zandaksha? tárangusin, uwshtisin, Sansonaa putapani atuni, anungaz kusaranganiya. Yapitam iyachchee ashirangu ambitam sheeruni, kasapani atuni kusaranganiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Anoo tsiyatsis mazinarangusin, Utaáchich sundar tuchip mil káyarandsin, yuwaa Sanson wachush wantsush taaru anoo kamaniranganaya. Ashiriya, Sansonaatssha táranganaya. ¿Mayaamsha shiy xarashee wayambeerush iyaa tásingaksha? ¿Washa nda shiy yasarish? Iyaa Filistewshuch kiyung yachakana anootsee, tárangusin, itaru Sansonsha, Nuw ¿antaatiya msangareezi ashirangee? nduni. Yuwamandtam nuwaa tayutaritarangana anumandtam ashirangina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Ashiriya, Sansonaa, iy kusaranganiya. Shiyaa putayruni Filistewshucheem panapani atiniya, táranginiya. Itaru, Sansonsha, Ashiri siynaa nuwaa zurampatari Apanll waana paritam pcharispa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Ashiri uwshtisin, Nduni. Zurampataricha tini. ¿Tamareeja iynaa shiyaa pachachini? Putamari putayruni, Filistewshucheem panapani atuni atiniya, tárangusin, putaranganaya Sansonaatsi. Wasik kaneeschipa kamuriyrusin, wachush wantsush yusheerandsin machtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Ashiriya, yakat Leyi kayumatanusin, tputs zapan Filistewshuch zamamtarusin, anush kusatanusin, Apanllsha wasundurur Sansonaam wizpur kapung panarangiya. Uwsha chiyzata sheeru, yuwaa wasik kaneeschipa kamurirana wirootspaz kuchareetsi ashiru ishaparangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Ashiranllu, anumun piyamsha nap ashku, kapaach tsipar waneezat tamuru ndaturi puzaru zumbachitaruri anoo yarangu, anpashat waanappa tputsee Filistewshuchee zapan pacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Ashiriya sheeru, anumunsha tsiyatarangu, Nuw kapaachpa waneezat tputsee zapan pacharangina. Sheeruri, tsipareetssha piyam xanata, piyam xanata sheeruri kasarangina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Tsiyatam iwaparamchu, anumun kapaachoo waneezat kapeetarangiya. Ashirucha, anumand anoo tsap Ramat-Leyi táranganaya. Ansha tsiyatsis, Kapaach waneeztu atusin, yásamaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Ashiriya, ashirangu anush Sanson kapung sachitarangiya. Apanlleetssha, Apaa, shiy nuwaam kapungutaa wizpurireetsish panarangush, nuwamarita Filistewshuchee kasiranguri, itaru natsha, ¿Waani sachisimun tsipap átish? ¿Waani Filistewshuch putanll átish nuwaatsee? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Apanllsha anoo mazinarangu, tsap kawaru anush kung wir zaw ashirangu, anoo Sansonsha waarangiya. Sheeru anumun, mang' kizpurtarangiya. Ashirucha, anoo tsap, Inakuree yásamarangiya. Itaru, ansha tsiyatsis yuwaa tputs mashku anoo, Apanllsha kung wirimshee panakiya atusin yásamaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Ashiriya, anush Sanson 20 masach Israelchicheem urkar kinaru ksutarangiya. Yuwapur Filistewshuch anshuchee tputs ashchiri tsap kiyung yacharangu anpuru. Ashiriya, na kamaneena yuwaa Sanson Apanllpa wizpur waamari Filistewshuchee kasirangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Ashiriya, minushsha zar Sanson yakat Gasash pangati átu naayaranllu kusarangiya. Anush kuseeru, kizaatssha mshipanee pakeeru, anushsha pang' kizash maamchi átu pshturangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Ashiri anootssha Gasashuch tputs mazinarangusin, yuwaa Sanson kusarangu anoo tsangaranganaya. Yaktanung washitungash taaru annung ksutaranganaya. Ichingaru psaan tsangarutar ashiranganaya. Taraseekchu anush putayruni pachapani atusina Sansonaatsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Itaru, Sansonsha zarpantaatiya wachamuree psaan chiyzayaranllu naatarangiya. Yaktaa washitungash napkamchu, mbamari shtandam parangu, anoo uwsha putayru, ashchiri iwachirangiya. Yuwaptari yasin wachunung mbam pashuchku, misha yuwaptari patumbich yuchamawa anpari shtandashee putaru anpatari ashpari yáyranllu, kuktara sheeranllu, íwar machipsha Hebronap naatarangiya. Anpatari yakat maach tasasaru taaru ambshita. Ashiriya, na kamaneena yuwaa Sansonaa pachayani táyaritaatssin, itaru uwsha psaan shitungarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Anumunsha Sanson kizaa sur Dalilaa imbangartarangiya tsap sur Sorekshucheetsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ashiriya, Filistewshuchsha kurak kizap pangani atusin naataranganaya. Anushsha kuseersin, kizash pang' imbangareetsish, Sansonaa shiy tamapingangi. Apinlliri mashangi. Saanitarita wizpurireetsish ¿tamayreezini iy putayruni shiyaa kamurichini? Mishat, ¿maypataja kamuriyaruch iyamari kasichinee? Itaru, wandaya shiy itsinsaru yasaramchush, iyaa kamankachush, ashiriya iysha ichingaruni minumtawari tputs shiyaam minumta mil arangeem kasiru kurik panachiniya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Ashiriya, Sansonsha pakatu kuseeru, anoo wimbangarsha Dalil: ¿Tamayashtish wizpurirish kapung taara? ¿Tamayreezich shiyaa kamurichich? ¿Maypataja shiyaa kamuriychich, shiy anoo nda ishapchish? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Sansonsha kizaa, Wasik 7 kaneeschiri tashapeerush, yuw mbammashi anpat nuwaa kamurikchus, ndushapari nuw kizpurtachina. Piyartach tputs tamapari ashishaparina. Ndusha waritachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Ashiriya, anoo Filistewshuch kurak mazinarangusin, wasik 7 kaneeschiri mbammash tashapeersin, kizaam Dalilaam panaranganaya. Uwsha Dalil anpa wasik Sansonaa kamurirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Dalilsha tputsee waanshoo pang' pishuyru, Sansonaatssha, Papcha. Shiyangaz putayani atusin, Filistewshuch naanllinpa, tárangu, Sansonsha chiyzta sheeru, waskaatssha yuwaa mbamari kamtama anoo ichingaroo ishaparanllu, wir kuchar tamatarpari ashiru parat ashirangiya. Anootssha Filistewshuch yasamaam pinasaranganaya yuwaa wizpur kapung taaru anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Ashiri Dalilsha Sansonaa, ¿Mayaamsha shiy nuwaa mangutish tamapingayrush ngicheesha? Ashiriya, shiyaa ¿tamanda tinareeja mbamari kamurimaama? tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Sansonsha kizaa, Wasik kaneeschiri ashichpa wakaraam sareekana anpatanaari nuwaa kamurikchush, ndushapari kizpurtachina. Piyartach tputs ashishaparina. Nda waritachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Ashiriya, Dalilsha wasik washitan yáyru, anpat kamurim iwaparamchu, anush yusursha, Papcha Sansonaa, Filistewshuch shiyangaz putani atusin naanllinpa, tárangiya. Itaru, Filistewshuchsha tputs anshuri pangusish shanee ashiranganaya. Itaru, Sansonsha anoo mazinarangu, waska irootspaz zangamcheetsi ashiru itipurangiya, yuwaa kamurima anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Dalilsha yusursha Sansonaa, ¿Mayaamsha yusur shiy nuwaa ngutish ngichiksha? ¿Wandaritam arangeem ngichiksha? Shiycha amb ashkatisha. Zurampatari kamaninda. Kaapana ¿tamayrinaareezich shiyaa mbamari kamurichich? tárangu, Sansonsha wimbangaree, Mucheetsi 7 tapuseerush, washunand irupasha íseerush mbamari k'tayarush, anootssha iroo wazuran saruyarush, anoo yasinpa tsapush mbamari pashucheerush, annaa ndushapari kizpurtachina. Piyartach tputs ashishaparina. Nda waritachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Ashiriya, Sanson yuwash maaramchu anush Dalilsha muchoo irupa mbamari ktayaru, yuwaatssha ir ktam saruyaru anootssha tsapush yasinpa mbamari pashuchirangiya. Sheeru anumunsha, yusur, Sansonaa papcha. Shiyangaz Filistewshuch putani atusin naanllinpa, tárangu, Sansonsha chiyzta sheeru, yuwaa mbamari ktama anoo ashpari ishaparangiya. Sheeru, wanasirsha chiyzata ashirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Ashiriya, anoo Dalilsha parangu, kapung tsiyantarangiya. Shiy nuwaa mangutish chinaktana átish. Na nuwaa ¿wandaritam ngichiksha? Na nipa tuchparinshitini nuwaa tamapingayanllsha. Nda itsinsaru yuwaa wizpurirish kapung taaru anoo nda kamaniksha. Dalil tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Dalilsha Sansonaa ichingaru zar, ¿Mayshta? ¿Mayshta? ashirangu, Sansonaa kizpur tamundarangu, uwsha tsipamaam zandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Sanson yuwamun iwatspakamchu anumunsha wimbangaree Dalilaa zurampatarisha kamanirangiya, yuwaa wizpur kapung taaru anootsi. ¿Antaatiya nuwaa mucheetsi kturumaam wanindaja? Yuwamandaricha nllurtarangi anumandaritcha Apanll waana nuwaa ipusaranganda. Ashirucha, amb ashkashina. Itaru, na nuwaa nimun mucheetsi ktureernaareesha, ndushapari kizpurtachina. Piyartach tputs ashishaparina. Nda waritachina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Dalilsha anoo mazinarangu, Na kamapari Sanson zurampatartaya átu tárangu, tsiyatssee Filistewshucheem kurak zanganirangiya. Naanints. Yusurshta, tárangiya. Anootssha tsiyatsis Filistewshuch kurak mazinarangusin, yusursha kurik payurutarusin, tuwapamaam kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Dalil Sansonaa waanshoo wanumb naatuyaru, anshuri izutirangu, tputseetssha kamachtarangiya, muchoo ktireemaama. Ashiriya, tputssha muchoo mantsir kumaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Kizsha kapung tsiyatarangiya. Papcha Sansonaa. Filistewshuch shiyangaz naanllinpa putamaama, tárangu; Sansonsha tameeru, mangush chinaku yusursha nuwaanaatsi tapachindachima tárangitaa, itaru ndusha waritarangiya, waanaatsi tapachindamaama. Watam yuwamand muchoo kumarangana anumand Apanllsha watstamamari Sansonaa kasarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Ashirucha, Filistewshuch kurak putayrusin, kamurirangusin, wachootssha yursaranganaya, Sheersin, yakat Gasapsha machtaranganaya, kandinpat mbamari kamuriyarusin, tumanshishish tumaneersin, Natu tarawaztangi, táranganaya, yuwash tushiysh kayak kapaachpatari kamtayrusin, kapaachsha naanat iturpipit, iturpipit ashku, tirikoo wanus tokana anush, Natu shiysha nish tarawaztangi, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Ashiriya, anshuri tumanshishish taar ashku, zapish yusursha Sanson much kanungarangiya. Ashiriya, na kamaneena yuwaa Sansonaa putayrusin, kiyung yacharangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Filistewshuch kurak ashpartin shaniyaranganaya apanllputseem Dagonaam maachi muchpani atusina. Mishat, yuwamand iyamari kasiyruni, Sansonaa putayrani atusin, yaseesshee yaseeksin, apanllputsee ungirtaksin, Apanll iyaam wizpuree panarangu, iysha kundarareetsini Sansonaa iyamari kasiyruni, putaranginiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","25","Ashiriya, anush tputs kizpur mang' ksarangusin, Natu, Sanson tumanshishish yamashinints. Nee tuxiykeeyruni stapani, tárangusin, Sansonaa yamayashinusin, tuxiykeeranganaya apusananda. Sheeshtisin zapan tsiyateersin staranganaya. Anshuritatam yaseeranganaya. Tputs ashparitina apanllirineetsi; Sanson iyaa taarashini tayutaritarangtaa, iyachchee tputs zapan pacharangitaa, itaru iysha apanllirini iyaam wizpuree panarangu, na iyamarisha kasiyruni, Sansonaa kundarareetsini putaranginiya, yaseeksin táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Anootssha Sanson mazinarangu, yuwaa tputs zapan tayutaritarangana anoo, yuwaatssha sundar waanaatsi ksutaru anootssha, Nuwaam yámandanda, pangus wanupish pashuchuru annung wayanda. Nuwsha istachtama, tárangu, uwshtisin ayu táyarusin, patuzinazinung tuxiykiranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Anushsha pangusish tputs zapan kizatam, kamuzatam shaniyaranganaya. Mishat, Filistewshuchitam kurakaw ashparitin washunand tuchip mil tputs shaniyaranganaya. Ichingaru pangus íwarpatari ashchiri tatsitarangiya. Anush Sansonaa pakeersin, apanllirineetsi ungirtaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Ashiriya, Sansonsha Apanllee masharangiya, Apaa, shiyamari ichingaroo kasiksha. ¿Chakaja shiyapa waritach? nduncha. Na in nuwaam minumarisha istangandama. Filistewshuch nuwaa kcheetsi yursayrusin, zapan tsiyateersin nuwaa stakanaya. Ashiriya, shiy nuwaam istangandama. Wizpurireemi panangandama. Nuwsha yuwamand nuwaa ashirangana anumand kisatapi tina, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Ashiriya, táyaru anumun patuzinazee yuwaatsiri pangusee wanupish putaru anootsiri uw tsimbunari putarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Sheeru, anush kapung tsiyatarangiya. Naturi in zar tsipani Filistewshuchis nuwaptarta, tárangu, patuzinazee ishipurangiya. Ashirangu, pangussha ashchiri yupangarangu, tputsee Filistewshuchee kurakawaatstam ashparita pacharangiya. Yuwamun Sanson tsipakamchu anumun tputsee zapan pacharangiya. Yuwaa kchitama pachayaranllu anoo kasiru pacharangiya. ");
INSERT INTO cbuNT_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Ashiriya, zoonllshitisin, misha maachiritssin kusaranganaya Sansonaa wanuts tsiparee yaani táyarandsina. Anushsha kuseersin, Sansonaa wanuts yáyrandsin, wapitam kanapuranganaya. Sheersin, yuwashutam waparee Manowa mapurangana anshutam Sansonaa mapeersin kasaranganaya. Tsap sura Estavolshu. Ashiriya, anpur Sanson kchitama 20 masach Israelchicheem urkar kinaru taarangiya. Ashiriya, na kamaneena yuwaa Sansonaa kiyung yachakchusin, itaru uwsha Apanllpa wizpur kisatarangu anootsi. Wapparee. Na yuwaa Israelchich Kurakaam Tsipas Kinatarangana anoo kamaneena.");
INSERT INTO cbuNT_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Sirútama, Israelchich gobernurini mang nda kizpur kurak taarangiya. Ksutamapanim tapachindaku taaranganaya. Anpur zar anush tsap katungatssha pishtarangiya. Tputs kiyung marizimun kachiyaranganaya, watam katungats ashchiri tsap maringaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Min tputs, Utaáchich, Elimelek, Efratshuch tputs Biringush yakat taarangu, anshat ¿Mayaatsshita tputs katungeechinllina katungats ndunariwa? tárangu, wizanllee; Pza, Mowabap tsap naayani, watam ambsha katungats zapaniwa, tárangiya. Ashirucha, Elimelek wizanllpa anungaz naataranganaya. Wizanllsha sur Noemiy. Wipshat tsimbun Malón, mishat Kiliyón ashpisin Mowabapsha tsap naataranganaya. Anushshat kuseersin, taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ashiramchu, anumun zapish Elimelekarini tsiparangshita. Tsiparamchu, waanitarishtisin wizanll wipaptamarisha taaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Waanitarishtisin taar ashkusin, Malón mishat Kiliyón ashirusin, Mowabshuchee kiz yamaranganaya. Malón wizanll sur Orfamuna. Kiliyónshat wizanll sur Ruti. Itaru, Elimelekarini Mowabash tsap kusarangana anumun 10 masach tushiyramchu, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","anush wipshitisin tsiparanganaya. Wanirsha Noemiy waanitarisha taarangiya. Maachiritsharishta, wipasharit, mishat wazaranllshari ashiru taarangiya. Kizpur mxaxzimuna. Na kamaneena yuwaa Elimelek maachiri Mowabash tsap taarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Minushshat zar Noem k'kuzee mazinarangiya, yuwaa Apanll Israelchicheem tputs kapung chinarangu, iwarzee zapan panarangu anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ashirucha, Noem yusur yaptam sirú Utaáp tsap taarangu ambtam kanapumaam zandarangu, taarashee shitungeerandsin, umeen tsimbunari watsapunipsha naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Anshat ngootsish naarsin, apus Noem umeenaa tsimbunarta tsiyatarangiya. ¿Mayaamsha nuwash tachitamaam zandaksa? Saanpeetam pangipis aneerpitamtis kanapungtsa. Apanll uru shiyaam kapung istachiya. Watam siy nuwaa kapungutam chinarangsawa. Mishat, iparneetstamni siy kapung wanasir ksutarangsa. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Apanll siyaam istakachu, yusur kamuzamuntam zaranllitssa. Ashkachus, sirú taarangis ashiritam ksatam zaranllpatis ipunatssa. Ashiriya, na kasakchintspa, tárangu, umeenaa pachipeeru, ishambarangiya. Itaru, ndaturi naaru uwshtisin kapung umeenangaz tanurangusin, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Nduni, nuwaptatam tsapunpish naayani, tárangusin, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Noemsha, Nda. Ashtaa naangints. ¿Mayaamaja nuwash tachitchis? Watam na nuw kizpur wachinaranguri, ¿tamari yusur arang iparinachi? siyaam zaranllis anooma. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ashirucha, nuw siyaa, Pangiptamtis kanapungints, táshina. Mishat, nuw wachinayanlluri, ¿tamareeja zaranllchee? Siy nuwaam kutaktaateesa ashiru, mishat nataati psaan zaranlleeruri, iparinakchitaateena ashiru, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","siysat, Nllur kanungaramchu, zaranllpani átus, anoom kutakus, ¿ashinooja kanungach? Mishat, ¿tamareeja siy zaranllshari saanitari nlluramaam kutakus, taararutar ashtachis? Nda. Minumtiyam amb ashtareezich. ¿Nuw tamakimna? Siy mangis mantsakis anumand aranginasha mangi mantsakina, watam Apanll nuwaa: Waani kiyung kachiyku taachpa, táranguwa. Ashirucha, nuwshat anuritam na kiyung kachiykuri taakina, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","umeenshitisin yusur mang mantsarangusin tanuranganaya. Min umeen sur Orfa, Ashiri nuw naachima, tárangu, umeenaa ishambeeranllu naatarangiya. Itaru, Rutimarisha umeenaa nda kasamaam zandarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ashirucha, Noem Ruteetssha shiy kanapunlltamcha. Watam na ipunshish watsapuniptam, mishat apanllputsirinpitamni kanapeenlluwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Itaru, Rutsha: Nduni, nuwaa zanganiyshpa. ¿Mayaam nuwaa kamingamaam zandaksha? Yapimasaja shiy naakatsha ambtam nuwapa naayani. Yuwashtam shiy taakamchish anshutam nuw taachima. Shiy tsapuntakamchish anoo nuw tsapuntachtamna. Shiy Apanllirish anoo nuw Apanlliritamana. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Mishat, yuwashtam shiy tsipachish anshutam tsap nuw tsipachuri, nuwaa mapchinllinaya. Nuw shiyaa kasakchinaareena, Apanllshapa nuwaa kapung wanichindanaya. Yuwashuri shiy tsiparamchish anshuri nuw shiyaa mbizachima, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Noemsha anuritam ndushat arang tsiyatarangiya. Umeenpatarisha ipuneerandsin naataranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ashirucha, umeenpat tsimbunshitisin naayarandsin, ngootsish naantach ashkusin, Biringapshat tsap kusatan ashiranganaya. Anshat musásiri yaktash kuskamchusin, yaktashuchsha tputs parangusin, kapung punirustaranganaya. ¿Kiztisin chakshita? ¿Antaati in sur Noemiyaja? tárangusin, ");
INSERT INTO cbuNT_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","uwshat: Na nuwaa sureetsi Noemiyaa, tárispa, Watam amb átus, Mang' kisa, atuwa. Ashiri na nimun nuwaa sureetsi Mara tángshatssa. Watam Apanll kizpureeru, nuwaa mangeetsi mantsamash wayaranguwa. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Nuw nimand zaranllpati, mishat ipari tsimbunari naataranguri, itaru natshat, nuwaanitarisha minumarishti kanapeeshinina. Ashiriya, amb ashiranguri, ¿mayaamshitaja nuwaa suri Mang' kisa, táchich? watam Apanll nuwaa waana zandarangu, mangeetsi mantsamash wayaranguwa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Amb ashiru, Noem Mowabamand tsap shitungeeshinu, umeenpat Mowabshuchpat kiz Rutpat, Biringashsha tsap kusaranganaya. Tputs mazarish sebaadaa wanus pusakana anpasa. Na kamaneena yuwaa Noem umeenpat Rutpa Biringash tsap kusarangana anootsi. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Noem wazaranllin Elimelekarini maachirit sur Boos Biringush taarangiya. Anshat tputs kizpur kurikpanimuna. Kurakaatspaz ashirusin tputs kis chinarangana. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Minushshat zar Rut umeenaa Noemiya: Nuwma tputsip mazar pangatama. Amuyaa masheeri yuwaatsimari wanusee ipartukis anumari nuw yachima tátama, tárangu, Noemsha: Ashiri napashinsi, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Rutsha anuritam: Ashiri pangatama, táyaranllu, yuwash tarawzupan wanusee pusaksin, ipartuyaranllina anush uwshat kuseeramchu tapuyarangiya. Rut nduntaa yasaru, itaru pattuch ashiru, Elimelekarinshini maachiri Boosash mazar kusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Boossha pangumand Biringamand shitungeeranllu, mazaripshat pakatu, yap muchchur tarawaztaksin shaneerna ambshat naatarangiya. Anushshat mazarish kuskamchu, ashparta muchchuree tsiyatarangiya. Siyaa Apanll wanasir ksutkiya, tárangu: uwshtisin, Shiyaatssha Apanll kapungtam chinakiya, táranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Anush Boos kizaatssha Rutee parangu, tarawzupaneetsshat urkar masharangiya. ¿Yapichshita in kiz kamasina? tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Tarawzupanshat urkar, izarich, Mowabshuchcha. Noempat Mowabamand tsap kusaranganaya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nishsha, nuwash kuseeramchu, pusampan wanusee ipartuyaranllina anoo uwshat kuzizimun tapuyapi átu, nuwaa masharangiya. Ichingaru zar, puturi wanusingaz tapuyapi átu kuskiya. Naturitcha kanusku kuxinxinawsha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boossha Rutee kuruzeeru, Mazinancha, izaree. Nuw shiyaa táchinllpa: tputsish mazar maachtawa wanus psarinllpa. Pusamaam zandkush, nishuri pusangcha. Mishat, nishuri nuwapa m'chachuri ipunangcha. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","M'chachurishiriti tchitangcha. Yap wanusee pusakana ambitam naangcha. Na nuwshat tputsireetsi wanasir waneeyaruri, kasachima nda shiyaa tputs muntamaama. Mishat, sachitkacheesha, suwish kung taartanda yuw tipayarusin waayakana anu. Mapiyrush yáyarush waangcha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rutshat: Zuraktishcha, tárangu. Boosanung wats much tsapush kizpur timuchta sheeru, ¿Tamasha shiy, tunartaatish, nuwaa kapung chinaksha? Mishat, shiy nuwaa kis napaksha, tárangu, ");
INSERT INTO cbuNT_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boosshat: Yasakina yuwaa kuminish shiyaa ningeem macheetu anootsi. Watam shiy zaranllish tsiparangitaa, nda tsapunpish kanapumaam zandarangsha. Maachiritaatstaatish kasayaranllush, ningeem taakamchush naataransha, nduntaa iyapa yasarush. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Itaru, yuwamand shiy amb ashkish anumand uru Apanllsha shiyaam aranginasha istachiya. Israelchich Apanllirini taarashipancha, wamari iyaa taarasheetsini ksutkiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutshat: Zuraktishcha. Wappari yuwamand átish. Shiy nuwaa mangi p'tseeksha. Shiy tputsish wanasirtishcha. Nuwaa chinakush átsha, nduntaa nuw shiyash, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Anush katungtseemsha zar tatsamoorangu, Boossha Rutee: Naani izaree. Ningeem k'xinangi; katungpani, tárangu, Rutsha, Ayu átu, tarawzupannung washunand kuxineeramchu, Boossha katungtsee yáyaru, Ruteem panarangiya. Rutshat katungarangu, kapung tazazayaru, wand katungtsee katuchirangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Yusur Rut kanapeeshinu, wanusingaz tapuyaati átu, Boossha muchchuree kamachtarangiya. Rutee shiy pusangtamti taangtsa. Waani sebaada wanus pusaptam watsta, pchindintspa. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Mishat, yuwaa sebaada wanus xanatkus pataxkis anoo yarintspa. Izuuru ksangtsa. Waani Rutshat anoo pusap. Mishat, anoo kizaa muntarintspa, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ashirucha, Rutshat mapiyru Boosash mazar sebaada wanus pusarangu, zar tapitaranllu, kasarangiya. Sheeru, zapee tangateeru wachunandarisha 20 kilpari sebaadaa pusarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Sheeru, chipayaranllu, waptam Biringap kanapurangiya. Umeenashsha kuseeramchu, yuwaa wanusee pusarangu anoo yámandarangiya. Sheeru, yuwaatssha katungtsee katuchirangu anootsshat umeenaam Noemeem panarangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Noemsha anoo parangu, ¿Yapsha tarawaztayashinush, aship nee wanusee pusayashinsha? Yuwamand shiyaam tputs kapung istarangu anumand Apanllsha uru anoo tputsee kapungtam chinachiya, tárangiya. Rutsha yuwaa Boosash mazar tarawaztayashinu anoo, umeenaatssha kamanku, An tputs sur Booscha, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ashirucha, umeensha: Apanll uru anoo tputs kapung istachiya. An kamuz iyaa kapungpari chinakiya. Mishat, an tputs iycha zaranllini maachirita. Anoo yasakchu, uru iyaa aranginashapari ksutchiya, tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rutshat: Nuwaa táranlleeja; Arang tarawaztangi. Nishshuri nuwapa m'chachuri ipuneerush wanusee pusangcha. Iwariz kachingaramchu, anush kasatsha, nuwaa tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Tárangu, Noemsha: Yuw átish an nuwaam wanasircha ¿Amb shingsi? Anshuri Boosash mazar muchchurpat ipuneerush tarawaztangcha. Tputsip nllitaritap mazar naarinllpa. Tputs muntayanllpa, umeenaa Rutee waneeku tárangiya. ");
INSERT INTO cbuNT_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Rutshat anuritam Boospa muchchur ipuneeru anshuri mzats sebaada wanus, mishat tirikootstam wanus pusaku taarangiya. Yuwash iwariz kachingkachu anshutam kasachima átu, mapiyru wanusee pusakaktar ashtariya. Ambiri ashishtar ashku, umeenash taarangiya. Ashiriya, na kamaneena yuwaa Rut Boosash mazar sebaadaa wan