﻿USE sofia;
DROP TABLE IF EXISTS sofia.cbtNTpo_vpl;
CREATE TABLE cbtNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cbtNTpo_vpl WRITE;
INSERT INTO cbtNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yosë nani ma'sha acorinso sha'huichinquëma': Iráca co manta ya'huërinhuë'. Yosëíchin ya'huërin. Caniaritapon, pi'iro'të'ton acorin. Ina quëran isoro'panta', acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Naporo' isoro'paso', co ipora pochin nishátërarinhuë'. Ya'ipi marësáchin ninin, pa'pi anpotërin. Tashiri noyá i'copitërin. Naporo chachin Yosë ispiritonënso', i' aipi yanpo yanpónantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Naporo' Yosë tapon: “¡Tashinantërinso nii'sohuanchin huachi!” tënin. Topachina, nii'sohuantërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nii'sohuantërinso nóya nicaton, nisha acorin. Tashinta', nisha acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nii'sohuantërinsoso': “Tahuëri,” itërin. Tashinaonta': “Tashi',” itërin. Tashirahuaton tahuëriantahuachina, i'huaraya huarë' a'na tahuërira', nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ina quëran Yosë taantarin: “¡Niquë niquë i' ya'huëcaso marë' ya'copinamën ya'huë'in!” tënin. Topachina, inachachin ya'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Yosëri i' ya'copinamën nipachina, ina aipi i' ya'huërin. Inaanaquënta', i' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nani acohuachina, inápaquë ya'huërinsoso': “Pi'iro'të',” itërin. Tashiantarahuaton tahuëriantahuachina, i'huaraya huarë' cato tahuëri nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ina quëran Yosë taantarin: “¡Yaniro'pa' ya'nocaso marë' pi'iro'tëanaquë i' ya'huërinso', inaquëráchin niyonto'in!” tënin. Topachina, inachachin ya'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yaniro'paso': “no'pa',” itërin. I' niyontoninsoso': “marë,” itërin. Ya'ipi acorinsopita noyasáchin nisarin ni'nin. Ina nicaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yosë taantarin: “¡Nisha nisha sharo'sa papoina'! Nisha nisha panpatororo'santa nisha nisha ya'pirihuanpiso', papoina'. ¡Nisha nisha nararo'santa nisha nisha nitopisopita no'paquë papoina'!” tënin. Topachina, inachachin ya'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ina nohuanton nisha nisha sharo'sa', panpatororo'sa', nararo'sa', inapita isoro'paquë paporin. Acorinsopita nicaton: “¡Ma nóyacha acorahuë paya!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tashiantarahuaton tahuëriantahuachina, i'huaraya huarë' cara tahuëri nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ina quëran Yosë taantarin: “¡A'pininsopita pi'iro'tëquë ya'huë'in. Tahuëri, tashi a'pintacaso marë' ya'huë'in. Inapita a'pinpachina, tahuëri, tashi', nisha nisha acoarin. Naporahuaton yoquiro'sa', pi'ipiro'sa', inapitanta piyapiro'sa nitotapi huachi!” tënin. Topachina, inachachin ya'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tahuëri a'pinacaso marë' panca masho acorahuaton, tashinta a'pinacaso marë' hua'huishin miachin acorin. Tayoraro'santa acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Yosëri inapita isoro'pa' a'pintacaso marë' pi'iro'tëquë acorin. Tahuëri, tashi a'pintarin. Acorinsopita nicaton: “¡Ma nóyacha acorahuë paya!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Tashiantarahuaton tahuëriantahuachina, i'huaraya huarë' catapini tahuëri nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ina quëran Yosë taantarin: “¡Nisha nisha ma'sharo'sa i'quë ya'huëcaiso marë' ya'huë'in! Nisha nisha samiro'santa ya'huë'in. ¡Naporahuaton, nisha nisha inairaro'sa yanponacaiso marë' ya'huë'in!” tënin. Topachina, inachachin ya'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Panca ma'sharo'sa nisha nisha nipisopita, marëquë ya'huëcaiso marë' acorin. Nisha nisha samiro'santa', acorin. Anpiantëhuano'santa', acorin. Acorinsopita nicaton: “¡Ma nóyacha acorahuë paya!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","I'quë ya'huëcaiso nipisopita noya yonquirapiton iso pochin sha'huitërin: “¡Na'amiatatoma marëro'saquë ya'huëco'!” itërin. Naporahuaton anpiantëhuano'santa', sha'huitërin: “¡Na'amiatatoma canpitanta isoro'paquë ya'huëco'!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tashiantarahuaton tahuëriantahuachina, i'huaraya huarë' a'natërápo tahuëri nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ina quëran Yosë taantarin: “¡Nisha nisha ma'sharo'sa ya'huë'in! Tananquë ya'huëcaiso nipisopita, pë'tahuacaiso nipisopita, niohuaratacaiso nipisopita. ¡Inapita ya'huë'in!” tënin. Topachina, inachachin ya'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Inapita ma'sharo'sa', ya'ipi Yosëri acorin. Acorinsopita nicaton: “¡Ma nóyacha acorahuë paya!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Naporo tahuëri chachin tapon: “¡Iporaso huachi piyapi niahua'! Inaso canpoa pochachin nisarin. Chiníquën nanantaton, samiro'sa', anpiantëhuano'sa', inapita hua'anëntarin. Ma'sharo'sa pë'tahuacaiso nipisopita, tananquë ya'huëcaiso nipisopita, niohuaratërinsopita, ya'ipi inapitanta hua'anëntarin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yosëri piyapi acoapon, inaora pochachin acorin. A'nara quëmapi, a'nara sanapi. Inaíchin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Noya yonquirapiton iso pochin sha'huitërin: “Nóya ya'huëco'. Na'a hua'huasha ya'huëchinquëma'. Shiparimapita na'atona', ya'ipi parti ya'huë'ina'. Ya'ipi hua'anëntoco'. Samiro'sa', ma'sharo'sa', anpiantëhuano'sa', niohuaratërinsopita, inapita hua'anëntoco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Napotahuaton, itaantarin: “Ni'quë'. Nisha nisha sharo'sa apapotërahuë nitërinso capamaso marë'. Notohuaro' nisha nisha nararo'santa nitërinso ca'quë', iroquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma'sharo'sa', anpiantëhuano'sa', niohuaratërinsopita, inapitaso nipirinhuë', panpatoro acotërahuë capacaiso marë'” itërin. Napotohuachina, inachachin nipi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Naporo' Yosëri ya'ipi acorinsopita nicaton: “¡Ma nóyacha ya'ipi acorahuë paya!” tënin. Tashiantarahuaton tahuëriantahuachina, i'huaraya huarë' saota tahuëri nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Inapoaton Yosë: Isoro'pa', pi'iro'të', ya'ipi inaquëpita ya'huërinsopitarë chachin tënirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","3","Ya'ipi acorinsopita tënirahuaton, tahuëririnquë chinotërin. Napoaton, ina tahuëri noya ni'nin. Noya nicaton, chinoto tahuëri acorin. Napoaton piyapi pënënin: “Naporo tahuëri chinotatoma', casáchin yonquico,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ina pochin Yosë iráca: Isoro'pa', pi'iro'të', inapita acorin. Ya'ipi no'tëquën sha'huitaranquëma'. Sinioroso Yosë ni'ton, inapita ya'nan acoaponahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","co sharo'sa ya'huëyátërarinhuë'. Co panpatoronta papoyátërarinhuë'. Co o'nan tëranta acoyátërarinhuë'. Naporahuaton co insonta isoro'paquë sha'tacaso marë' ya'huëyátërarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Napoaponahuë', no'pa quëran chachin i'sha pipiton, së'cotërotárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Naporo' Sinioroso Yosë ni'ton, yaniro'pa' amocan quëran quëmapi ninin. Nani nisahuaton, nanpicaso marë' pihuinitërin. Inapotohuachina, niirahuaton nanpirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ina piquëran, Sinioroso noyápiachin nararo Itin itopiquë acorin. Inaso no'pa', Cortanii' quëran pi'i pipirinso parti quëparitërin. Inaquë ya'huëcaso marë' quëmapi nininso acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Naporahuaton, nisha nisha noyápiachin cashino'sa apapotërin. Yashi yashin ca'chináchin nitërinsopita apapotërin. Nararo huancánachin nanpirin nara apapotërin. Inaquë chachin a'nanta', apapotërin. Anitotacaso nara itopiso'. Ina ca'pachina', noya nininsopita nitotaponahuë', co noyahuë' nininsopitanta nitotapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Itinquë a'nara i' pipirin. Ya'ipi nararo asë'cotërotacaso marë' naporin. Ina quëran chachin catapini së'parai' pa'tërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ya'natiirinsoso', Pisonii' itopi. Inaso', Apira parti conimarin. Inaquë oro ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Inaquë oro ya'huërinso', noya noya ninin. Pimo yaquinta noya noya nininso ya'huërin. Nisha na'pinta ya'huërin, onisi itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ina quëran niantarinsonta', Quiconii' itopi. Inaso', ya'ipi Coso parti pa'tërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","A'nanta', Tiquirisii' itopi. Inaso', Asiria ninano pi'i ya'coninso parti quëran acorin. Ya'natomarinsoso nipirinhuë', Iopiratisii' itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Sinioroso Yosë ni'ton, Itin nararoquë quëmapi acorin. Inaquë sacataton a'paicaso marë' acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Naporo' iso pochin camairin: “Ya'ipi isopita nararo'sa nitërinso', noya ca'quë', iroquë', inapoquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Anitotacaso nara nitërinsoíchin, co nohuantërahuë capamaso'. Inaso ca'patan, noya nininso nitotaponahuë', co noyahuë' nininsonta nitotaran. Ama ina nitërinso ca'quësohuë'. Ina ca'patan, tëhuënchachin chiminaran,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ina quëran Sinioroso Yosë ni'ton, taantarin: “Quëmapi inaora ya'huëcaso', co noyahuë'. A'na nianta'i nipachin, inari noya catahuacaso marë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Ina quëran ya'ipi ma'sharo'sa', anpiantëhuano'sa', inapita no'pa quëran ninin huachi. Inapita nisahuaton, quëmapi quëshirin inari nininën acotacaso marë'. Pë'tahuaro'sa', anpiantëhuano'sa', ma'sharo'sa tananquë ya'huërinsopita, inapita nininën acotërin. Ma nininënsona acotohuachina, ina chachin ninihuanpi huachi. Napoaponahuë', co a'na ma'shari tëranta nanitërinhuë', quëmapi noya catahuacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Napohuachina, quëmapi noyá ahuë'ëtërin. Huë'ëso', a'nara nininpitën ocoitërin. Ocoitahuaton, anoyataantarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ina nininpitë quëran chachin sanapi ninin. Capayatohuachina, sanapi nininso a'notërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Quënanahuaton, quëmapi pa'yanin. Pa'yataton, tapon: “¡Isocha tëhuënchinso', ca pochachin Yosëri ninin! Cá quëran ninin ni'ton, sanapi itarahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Napoaton quëmapi sa'apachin, pa'pin, a'shin inapita patahuaton, sa'inë' nichinpitacaso ya'huërin. Catoya'pi nipirinahuë', a'naíchin pochin nipi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Quëmapiso sa'inë chachin noya ya'huërapi. Co a'moanaponaraihuë', co manta tapanpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sinioroso Yosë ni'ton, ya'ipi tananquë ma'sharo'sa ya'huërinsopita acorin. Ya'huanso nipirinhuë', a'napita ma'sharo'sa quëran yonqui yonquínahuan ninin. Sanapi yanonpintaton, paaparin nontacaso marë': —¿Tëhuënchachin ta'ma Yosë apiratërinquëma ya'ipi isopita nararo'sa nitërinso capamaso to? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","—Ya'ipi nitërinso', noya capa'huaiso'. A'naíchin huancánachin huanirinso', co Yosë nohuantërinhuë': “Ama ina nitërinso', ca'cosohuë'. Ama së'huacosohuë'. Ca'patama', tëhuënchachin chiminarama',” itërincoi Yosë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","—Co napoarinhuë'. Co chiminaramahuë'. Ca'patamaso', ya'ipi noya nininsopita, ya'ipi co noyahuë' nininsopitanta', nitotarama huachi. Inapita nitotatoma', Yosë pochachin nisarama'. Ina nitotaton, Yosë apiratërinquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ina natanaton, sanapiso nara nitërinso ni'sárin: Noyápiachin nicaton ca'chináchin cancantërin. “Ina ca'pato, ya'ipi nitotarahuë huachi,” tënin. Napoyan quëran, së'pashorahuaton ca'nin. So'ionta quëtohuachina, inanta ca'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Naporo chachin nisha yonquipi huachi: “I'nanpirashitë canposo pa'sárë',” niitopi. Ninapotatona', iquira huëron pipitopi. Inapoatona', nipa'shianatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","I'huanahuanquë huisontapaso', Yosëri nararoquë huëcapairinso natanpi. Natanahuatona', na'picaiso marë' ta'api. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Na'pitopirinahuë', inariso përarin: —Atan. ¿Insëquëta ya'huaran? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Natanahuaton, quëmapiso tapon: —Co'ta o'maranso' natanai. I'nanpirashitëcoi ni'toi, të'huatërainquën. Naporahuaton tapantatëinquën, na'pirai, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","—¡I'yan! ¿Onporahuatomata nitotapanamaso'? Nara a'naíchin nininso': “Ama isoso nitërinso ca'quësohuë',” itopiranquënhuë': ¡Nani ca'nan! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","—Iso sanapi quëtërancoso', quëtërinco ni'ton, ca'nahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Napotohuachina, sanapi ya'huërë' tahuërëtahuaton, itapon: —¿Onpoatonta naporanso'? itërin. —Ya'huan nonpintërinco ni'ton, ca'nahuë, tënin sanapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Naporo' Sinioroso Yosë ni'ton, ya'huan ya'huërë' tahuërëtahuaton, co huachi noya ya'huëcaso marëhuë' sha'huitërin: —Piyapi nonpintëranso marë' a'napita ma'sharo'sa quëran, pa'pi co noyahuë' ni'nanquën. Napoaton ipora quëran huarë' cancanën quëran no'pa' pa'taran. Inapoaton, chiminaquë huarë' nosorotaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ca nohuanto sanapi inimicotarinquën. Quëmarinta ina inimicotaran. Quëmá quëran pipipisopitanta', sanapi quëran pipipisopitarë' niinimicotapona'. A'na tahuëri sanapi quëran pipirinsoari minsëmiatarinquën. Napoaponahuë', quëmarinta chiníquën ina aparisitaran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ina quëran sanapi ya'huërë' itapon: —Co natërancoso marëhuë', hua'huanpatan pa'pi iquin quëran huaiaran. Napoaponahuë', so'yan ya'cariantaran. Naporahuaton, so'yan camaiinquënso ya'huërin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ina quëran quëmapinta itapon: —Sa'an natëton, nara nitërinso co capacasohuë nipirinhuë', ca'nan. Naporanso marë' ya'ipiro'pa' co huachi noyatacaso marëhuë' sha'huitarahuë. Napoaton nitapiarin. Pa'pi chiníquën sacataquë huarë' coshataran. Chiminaquë huarë' inapoaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Naporahuaton, nahuano'sa', shihuarino'sa', inapita na'con na'con papotapon huachi. Nisha nisha canomëro'sa', nararayaro'sa', inapita yoniton, capon. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Pa'pi chiníquën sacatahuarë' coshataran. Napoin quëran chiminaran huachi. No'pa quëran ninanquën ni'ton, no'pa chachin niantamaso ya'huërin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Atanso', sa'in nininën acotërin, Ipa itërin. Ina quëran ya'ipi piyapi na'acaiso ni'ton, ina pochin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Quëmapi sa'inë chachin a'mocaiso marë' ma'sha sha'huëtë quëran Yosëri nitërin. Ina quëtohuachina, a'moanpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Naporo chachin tënin: “Iporaso', piyapi canpoa pochachin nitotërin. Noya nininso nitotahuaton, co noyahuë' nininsonta nitotërin. Ni'quëna nanpirin nara nitërinsonta ca'pachin. Napohuachinso', nanpimiatarin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Napoaton Sinioroso Yosë ni'ton, noyápiachin nararo quëran quëmapi ocoirin. Ocoirahuaton, niquë acorin. Inaquë sacatacaso marë' acorin. No'paquë chachin sacatapon huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Piyapi ocoirahuaton, pi'i pipirin parti quëran a'paito anquëniro'sa acorin. Inapitaso', quiropino'sa itopi. Noyápiachin nararo a'paicaiso marë' acorin. Ina ya'carinta', sahuëni orotaton huënin huënintárin acorin. Ama incari tëranta nanpirin nara ya'caricaso marëhuë', a'pairapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Atan sa'in hua'huanpachina, quëmapia'huaya huairin. “Yosë catahuarinco ni'ton, quëmapia'huaya hua'huanahuë huachi,” ta'ton, nininën acotërin. Caino itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ina quëran hua'huaantarin. Quëmapi chachin huaiaantahuachina, Apiri itërin. Hui'napitohuachinara, Apiriso ohuicaro'sa pë'tahuarin. Cainoso nipirinhuë', imin camayo. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","A'na tahuëri cato chachin ofrenda quëcatona', Yosë chinotapi. Cainoso', sha'ninso quëran Yosë chinotacaso marë' quënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Apiriso nipirinhuë', ohuicanënpita ya'nan hua'huatopiso quënin. Amo amoshin nininsopita Yosë chinotaton tëpacaso marë' quënin. Yosëso Apiri nóya ni'nin. Ofrendanëonta nóya ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Cainoso nipirinhuë', co noyahuë' ni'nin. Ofrendanëonta co noyahuë' ni'nin. Ina marë' Cainoso', pa'pi no'huitërin. No'huitaton, aquinorárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ina nicaton, Siniorori itapon: “¿Onpoatonta no'huitaton aquinoráran? ¡Ama huachi no'huitëquësohuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Noya ninan naporini, noya cancanchitonhuë'. Nipirinhuë', co nohuantëranhuë' noya nicacaso ni'quëhuarë', co noyahuë' nisápaso marë' oshanën minsëarinquën. Ina nipirinhuë', noya nipatan, nanitëran ina minsëcaso',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Natanaponahuë', co yanatëtërinhuë'. A'na tahuëri iin itapon: —Huëquë iyara iminquë pa'a, itërin. Inaquë canconpachinara, iin ahuëaton, tëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Siniorori nitotaton, Caino itapon: —¡Ma'sona iyaya onporinso', sha'huitoco! itërin. Napotohuachina, Cainoso tapon: —Co nitotërahuë'. ¡Co ina a'pairápa'huaso ya'huërinhuë'! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Napotohuachina, Siniorori itapon: —¿Onpoatonta naporan? Iyaya tëpaton, pa'pi co noyahuë' ninan. Huënainën a'patëran ni'ton, co huachi noya ya'huëcamaso marëhuë' sha'huitaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Iya'hua tëparanso marë' pa'pi co noyahuë' ni'nanquën. Huënainënquë no'pa' asë'cotëtëran ni'ton, ocoiaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Iminaton, sha'topiranhuë tëranta', co huachi noyatarinhuë'. Co huachi ya'huëmia ya'huaponhuë', patë patë́rantapon. Co huachi sano cancantaranhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","—¡Ma'huantacha nisarahuë paya! Co ahuantochináchinhuë' ana'intaranco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ipora tahuëri iso ro'të quëran ocoiaranco. Co huachi ya'huëmia ya'huapohuë', patë patë́ranta'huaso ya'huërin. Co huachi sano cancanta'huaso ya'huaponhuë'. Co chinota'huanquënso tëranta nanitapohuë'. Napoaton inso tëranta quënanpachinco, tëpaponco tënahuë, itërin Cainori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","—Insosona tëpahuachinquën, inanta na'con na'con ana'intacaso ya'huërin. Canchisëro ana'intacaso ya'huërin, itërin Siniorori. Napotahuaton marca acotërin. Quënanpachina ama tëpacaiso marëhuë', inapotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ina quëran Caino pa'nin. Yosë quëran pipirahuaton, Noto parti ya'huëconin. Inaso no'pa', Itin quëran pi'i pipirinso parti quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caino sa'apachina, hui'nahuanin. Hui'nin nasitohuachina, Inoco itërin. Ina quëran Caino ninano ocoihuachina: “Inoco ninano',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inoco hui'nahuanpachina, Irato itërin. Iratonta hui'nahuanpachina, Miocairo itërin. Miocairo ya'huërë' hui'nahuanpachina, Mitosairo itërin. Mitosaironta hui'nahuanpachina, Namico itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Namicoso', cato sa'ahuanin. A'naso', Ata itopi. A'nanta', Sira itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ataso hua'huanpachina, Caparo itopi. Caparo shinpitaso' pë'tahuatona'piro'sa'. Napoaton në'mëtë pëiro'saquë ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Caparoso', a'nara iya'huain ya'huëtërin, Coparo itopiso'. Coparo shinpitaso', arpa míso pi'nipi. Nisha nisha pirinaonta míso pihuipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siraso nipirinhuë', hua'huanpachina, Toparo-caino itopi. Inaso', hua'na camayo ya'conin. Hua'namia nitotahuaton, sha'pi hua'nanta nitotërin. Toparo-cainoso', a'nara oshin ya'huëtërin, Naama itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","A'na tahuëri Namicoso', sa'inpita itapon: “Natanquë Ata. Quëmanta Sira, noya natanco sha'huichinquëma': A'na quëmapi tëparahuë pë'sharincoso marë'. Hui'napi nipirinhuë', ahuërincoso marë' napotërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Iin tëparinso marë' Caino tëpahuachinaso', canchisëro aquëtë Yosëri i'huërëtapon. Caso nipirinhuë', tëpatërahuëso marë' tëpahuachinaco, canchisë shonca canchisëro aquëtë i'huërëtacaiso ya'huërin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Oshaquëran Atan sa'in, hua'huaantahuachina, Sito itërin. “Cainori tëparinso ya'huërënamën Yosë quëtaantarinco,” ta'ton, ina pochin nininën acotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sitonta hui'nahuanpachina, Inosë itërin. Naporo quëran huarë' piyapiro'sa caniaritopi Yosë chinotatona', “Sinioro” itacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Atan shinpita napopiso sha'huichinquëma nitotoco'. Yosëri piyapi nipachina, inaora pochachin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Quëmapi, sanapi, nisahuaton, noya ya'huëcaiso marë' noya yonquirapiton sha'huitërin. Acorinso tahuëri chachin nohuitaton: “Isopitaso': ‘Piyapiro'sa',’ itarahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Atan pasa cara shonca pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Sito itopi. Inaso', pa'pin noyá quëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sito nasitërin piquëran Atanso', posa pasa pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ya'ipiya quëran Atanso', iscon pasa cara shonca pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sito pasa a'natërápo pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Inosë itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Inosë nasitërin piquëran Sitoso', posa pasa canchisë pi'i aquëtë ya'huaantarin. A'napita hui'nipitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ya'ipiya quëran Sitoso', iscon pasa shonca cato pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inosënta iscon shonca pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Cainan itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Cainan nasitërin piquëran Inosëso', posa pasa shonca a'natërápo pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ya'ipiya quëran Inosëso', iscon pasa a'natërápo pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainan canchisë shonca pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Maarariro itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maarariro nasitërin piquëran Cainanso', posa pasa catapini shonca pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ya'ipiya quëran Cainanso', iscon pasa shonca pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maarariro saota shonca a'natërápo pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Carito itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Carito nasitërin piquëran Maarariroso', posa pasa cara shonca pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ya'ipiya quëran Maarariroso', posa pasa iscon shonca a'natërápo pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Carito pasa saota shonca cato pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Inoco itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Inoco nasitërin piquëran Caritoso', posa pasa pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ya'ipiya quëran Caritoso', iscon pasa saota shonca cato pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inoco saota shonca a'natërápo pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Matosarino itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Inocoso', nani tahuëri Yosë chinotaton, ina nohuantërinsoráchin ninin. Matosarino nasitërin piquëran Inocoso', cara pasa pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ya'ipiya quëran Inocoso', cara pasa saota shonca a'natërápo pi'ipi ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inaso', Yosë nohuantërinsoráchin nininso marë' a'nanaya ayarin. Yosëri inápaquë quëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matosarino pasa posa shonca canchisë pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Namico itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Namico nasitërin piquëran Matosarinoso', canchisë pasa posa shonca cato pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ya'ipiya quëran Matosarinoso', iscon pasa saota shonca iscon pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Namico pasa posa shonca cato pi'ipitaso', a'nara hui'nin nasitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nasitohuachina, Noi itërin. “Siniorori piyapi co huachi noya ya'huëcaso marëhuë' sha'huitaton, ana'intërin. Napoaton isoro'pa' nitapirin. Pa'pi chiníquën sacataquë huarë' cosharo manë'. Iso hua'huashaso nipirinhuë', nanan anoyatatonpoa achinotarinpoa',” ta'ton, ina pochin nininën acotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noi nasitërin piquëran Namicoso', a'natërápo pasa iscon shonca a'natërápo pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ya'ipiya quëran Namicoso', canchisë pasa canchisë shonca canchisë pi'i icanin. Ina quëran chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noiso', a'natërápo pasa pi'ipitaquë huarë' hui'nin paninantërinso nasitërin. Ina quëran cato hui'ninpita ya'huëtaantarin. Hui'ninpitaso': Simo, Camo, Cahuito, inapita itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Piyapi'sa na'asahuatona', yanquëpi huachi. Itohua itohua ninanoro'sa ocoiatona ya'huërapi. Na'a hui'ninapita nano'sa ya'huëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Yosë hui'ninpitari ina nano'sa ni'sahuatona', pa'yatopi. Napoaton huayonatona huayonatona', costapiso mara'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Napoaponahuë', Siniorori co costatonhuë' tapon: “Co piyapi'sa ya'huëmiatápaiso ya'huërinhuë'. Piyapi ni'ton, chiminacaiso ya'huërin. Napoaton pasa cato shonca pi'ipira', nanpipona',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Yosë hui'ninpitari ina sanapiro'sa macatona', hui'nahuanpi. Hui'nahuanpachinara, panca piyapiro'sa ya'huërin huachi. Ina quëran inapitaso', iráca quëran huarë' hua'ano'sa nahuinpisopita ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Napoaponaraihuë', pa'pi co noyahuë' cancantopi. Co noyahuë' nicacaisoráchin yonquipi ni'ton, Yosëri co noyahuë' ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","7","Ina nicaton, sëtërin: “Ma'marëcha piyapi acorahuë paya. Ata'huanchi nipachin. Ya'ipi pë'tahuaro'sa', anpiantëhuano'sa', no'paquë niohuaratërinsopita, inapitarë chachin ata'huantarahuë huachi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Napoaponahuë', Noiso nóya ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noi naporinso sha'huichinquëma': Noiso Yosëíchin natëton, nóya ninin. Naporo tahuëri'sa inaíchin Yosë nohuantërinso ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Inaso', cara hui'ninpita quëmapisáchin ya'huëtërin: Simo, Camo, Cahuito, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Naporo' ya'ipi isoro'paquë ya'huëpisopita nitapicancanpi. Pa'pi co noyahuë' nicatona', ahuëtacaisoráchin cancantopi. Napopiso Yosëri ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ina nicaton, Noi itapon: “Ya'ipi piyapiro'sa ata'huantarahuë. Pa'pi co noyahuë' nipi ni'ton, piyapi'sa co huachi sano cancantopihuë'. Napoaton ya'ipiro'paquë ya'huëpisopita ata'huantarahuë huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Quëmaso nipirinhuë', panca nancha niquë'. Yaquihuan nara quëran nisahuaton, aipi quëran, acopo quëran, to'ni pochin nininquë to'níquëtëquë'. Patoanaro'santa acotëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nancha nipatan, iso pochin acoquë': Pasa cara shonca a'natërápo mitro naporopitërinso'. Cato shonca cato mitro miria pancanatërinso'. Shonca cara mitro miria inaparinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Naporahuaton, cara pa'cotë acotëquë'. Pëirapiranso ya'cari', miria mitro aquërinquë huintana acotëquë'. Ya'coananta', a'natëran acotëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","A'na tahuëri panca pacon a'paarahuë, ya'ipiro'pa' imotarin. Ya'ipi piyapiro'sa', ma'sharo'sa', inapita taquiitapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Quëmaro'coso nipirinhuë', anoyatarahuë ni'ton, nancha tënihuatan, sa'anë'quën chachin ya'conaran. Hui'nanpitanta', sa'inarë chachin ya'conapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Naporahuaton, ma'sharo'santa nisha nisha nipisopita quëran, a'nara quëmapi, a'nara sanapi yontonquë'. Inapitanta canpita pochin cha'ëcaiso marë' yontonquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Anpiantëhuano'sa', pë'tahuaro'sa', no'paquë niohuaratërinsopita, ya'ipi inapita catoya catoya ya'conapona'. Canpitarë chachin ya'huaantacaiso marë' ya'conapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Notohuaro' cosharo nisha nisha nininsopita ayontonahuaton nanchaquë po'moquë'. Canpita capacamaso nisahuaton, ma'sharo'santa capacaiso marë' po'moquë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Napotohuachina, Noiso' ya'ipi Yosëri camairinso chachin ninin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ina quëran Siniorori Noi itapon: “Ya'ipi ipora ya'huëpisopita a'porinaco. Quëmasáchin nohuantërahuëso ninan. Napoaton iporaso', sa'anë'quën chachin nanchaquë ya'conquë huachi. Hui'nanpitanta', sa'inarë chachin ya'coina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Chinotamacoso marë' ma'sharo'sa tëpacaiso nipisopitaso', canchisë quëmapi nisahuaton canchisë sanapi nanchaquë po'moquë'. Ya'huërë' co ina marë' nipisopitasohuë', a'nara quëmapi, a'nara sanapi inaíchin po'moquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nisha nisha anpiantëhuano'santa', nanchaquë po'moquë'. Canchisë hua'anën, canchisë sanapinën na'antacaiso marë' po'moquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Canchisë tahuëri quëran ca nohuanto o'nanapon. Catapini shonca tahuëri, tashirë chachin o'namiatapon. ¡Inapotato ya'ipi isoro'paquë acorahuësopita ata'huantarahuë!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noiso', ya'ipi Siniorori camairinso chachin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noi saota pasa pi'ipitaso', paconi isoro'pa' imotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Naporo inaso', sa'inë chachin nanchaquë ya'conin. Hui'ninpitanta sa'inarë chachin cha'ëcaiso marë' ya'conpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Yosë chinotacaso marë' ma'sharo'sa tëpacaiso nipisopitanta', Noirë chachin catoya catoya nanchaquë ya'conpi. A'nara quëmapi, a'nara sanapi ya'conpi. Co ina marë' nipisopitahuënta ya'conpi. Anpiantëhuano'sa', niohuaratërinsopita, inapitanta inapochachin ya'conpi. Yosëri sha'huitërinso chachin nipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yosëri sha'huitërinso chachin, canchisë tahuëri quëran paconi isoro'pa' imotarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Naporo' Noiso', saota pasa pi'i, cato yoqui, shonca canchisë tahuëritarin. Naporo chachin isoro'pa' huëncharoatë pochin ninin. Marënta acoporo ya'huërinso', pipimiatërin. Naporahuaton inapaquënta', i' ya'copinamën ya'huërinso nii'soatërin. Napohuachina, pa'pi i' isoro'paquë anotimarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Catapini shonca tahuëri tashirë chachin isoro'paquë o'namiatarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Naporo tahuëri chachin Noi sa'inë nanchaquë ya'conin. Hui'ninpitanta', Simo, Camo, Cahuito, inapitanta sa'inarë' sa'inarë' ya'conpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tananquë ma'sharo'sa ya'huërinsopita, pë'tahuaro'sa nipisopita, niohuaratërinsopita, anpiantëhuano'sa', inapitanta ya'conpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Yosë nohuanton, ma'sharo'sa catoya catoya nanchaquë ya'conpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nisha nisha nipisopita quëran, a'nara quëmapi, a'nara sanapi ya'conpi. Yosëri Noi camairinso chachin nipi. Nani ya'conpachinara, Siniorori chachin nancha ya'coananën oncorapirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Catapini shonca tahuëri o'nanárin. Pamatohuachina, nanchaso no'pa quëran yanponin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Pamaso' aquëtë chachin mëntaintararin, nanchaso nipirinhuë', noya yanponarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Pa'pi pacon pa'sahuaton, ina inápa motopiro'sa quëran huarë' imotërin. Inapita motopiro'sa imotahuaton, canchisë mitro aquëtë pantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Naporo' ya'ipi piyapiro'sa isoro'paquë ya'huëpisopita, taquiitopi. Anpiantëhuano'sa', pë'tahuaro'sa', tananquë ma'sharo'sa ya'huërinso', niohuaratërinsopita, inapitanta ta'huantopi. Ya'ipi nii o'huatona nanpipisopita, taquiitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Noisáchin cha'ërin. Panca nanchaquë ya'conpisopitarë', cha'ërin. A'napitaso nipirinhuë', ya'ipi ta'huantopi. Pë'tahuaro'sa', anpiantëhuano'sa', niohuaratërinsopita, inapitanta ya'ipi taquiitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pasa a'natërápo shonca tahuëri isoro'pa' iiri imotaton, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Naporo' Yosëri Noi, ya'ipi ma'sharo'sa nanchaquë ya'huëapisopita, inapita yacatahuarin. Ina nohuanton pacon huinquintacaso marë' ihuan pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Co'huara huinquinchátërasohuë', o'nan'ton më'tarin. Naporo' marë acoporo quëran pipirinso', nioncotërin. Inápaquë i' ya'copinamën nii'soatërinsonta inaporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pasa a'natërápo shonca tahuëri quëran, i' pi'piyan pi'piyan huinquintomarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Canchisë yoqui, shonca canchisë tahuëri quëran, Ararato motopiro'sa hui'nimotënquë nanchaso', ya'mitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Iscon yoqui nanirahuaton tahuëririnquë, motopiro'sa hui'nimotëna ya'nopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Inapita ya'nohuachinara, catapini shonca tahuëri quëran, Noiso nancha huintananën i'soatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Naporo' a'nara itatan a'parin. Inaso', itohua itohua yanpo yanpónantarin. I' huinquintacaso ninaton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ina piquëran, Noiso' i' huinquintërinso nitotacaso marë', nëpë ya'huërë' a'paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","A'papirinhuë', co intopa huënsëcasohuë ni'ton, yanpo yanpónantarin. Naporarin quëran, nanchaquë chachin huënantarin. Huëntahuachina, Noiri masahuaton po'moantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Canchisë tahuëri quëran, naquëranchin a'paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nëpëso pa'sahuaton, i'huarayasha huarë' huënantarin. Oripo nara së'para'huaya monoquënë chachin naquërahuaton quëntarin. Naporo' Noi, yaniromarinso nitotërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Canchisë tahuëri quëran naquëranchin nëpë a'paantapirinhuë', co huachi huëntarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noi saota pasa a'na pi'itapaso', ya'ipiro'pa' yaniromarin huachi. Caniaritërinso yoquiquë, ya'natiirinso tahuëri chachin, napopinchin nancha pëirapirinso oquirin. Naporo ya'ipiro'pa' yaniromarinso nocorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A'na yoqui, cato shonca canchisë tahuëri nanihuachina, ya'ipiro'pa' noyá yaniromarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Naporo chachin Yosëri Noi itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Iporaso huachi sa'anë'quën chachin nancha quëran pipiquë'. Hui'nanpitanta', sa'inarë chachin pipiina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ya'ipi ma'sharo'santa ocoiquë pa'ina'. Anpiantëhuano'sa', pë'tahuaro'sa', no'paquë niohuaratërinsopita, ya'ipi inapitanta pipiina'. Notohuaro' hua'huatatona', ya'ipiro'paquë yanquë'ina',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Napotohuachina, ya'ipi piyapi'sa cha'ëpiso pipipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ma'sharo'santa pipipi: Pë'tahuaro'sa', niohuaratërinsopita, anpiantëhuano'sa', inapitanta pipipi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nani pipihuachinara, Noiso a'nara artaro ninin. Yosë chinotacaso marë' ma'sharo'sa tëpacaiso nipisopita masahuaton, tëparin. Anpiantëhuano'santa', manin. A'naya a'naya nisha nisha nipisopita quëran tëparin. Tëparahuaton, Sinioro chinotacaso marë' artaro aipi ya'ipi ahuiquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ma'sharo'sa ahuiquitërinso pimóchin imërahuaton, Yosëri nóya ni'nin. Naporo' inaso tapon: “Hua'huatapona quëran huarë' piyapi'sa', co noyahuë' nicacaisoráchin cancantopi. Inaso niponahuë', co huachi ipora ana'intërahuëso pochin, isoro'pa' ana'intaantapohuë'. Co huachi ma'sharo'santa inapotapohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Isoro'paquë ya'huapona pochin, piyapi'sa noya sha'tapona'. Nitërinsonta macapona'. Huënocanta ya'huërahuaton, sëhuëonta ya'huapon. Pi'ipi tahuëri'santa nanirahuaton, o'napinta nanipon. Tahuëri, tashi', inapitanta ya'huapon,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Naporo' Noi, hui'ninpitarë chachin, Yosëri nóya yonquirapiton iso pochin sha'huitërin: “Na'a hui'nahuanatoma', ya'ipiro'paquë ya'huëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ya'ipi ma'sharo'sa', anpiantëhuano'sa', marëquë ya'huërinsopita, inapita hua'anëntarama'. Inapitaso të'huatarinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Carima ya'ipi inapita capamaso marë' quëtaranquëma'. Nisha nisha huërono'santa ca'co'. Ma'sona tëranta nayaramaso ca'co'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Huënaiso nipirinhuë', ama ca'cosohuë'. Ma'sha tëpahuatama', huënainën noyá inquitahuatoma', ca'co'. Huënainëni ananpirin ni'ton, ama inaso ca'cosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Canpita capiniso', co nitëpamaso ya'huërinhuë'. Tëpatohuatama', ana'inta'huanquëmaso ya'huërin. Ma'sharo'sarinta piyapi tëpahuachin, ana'intarahuë. Tëpatohuatama', a'naya a'nayanquëma tëhuënchachin ana'intaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Insosona piyapi tëpahuachin, a'nari i'huërëtarin. Cá pochachin nicamaso marë' acoranquëma'. Napoaton, co nitëpamaso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","¡Napoaponahuë', canpitaso na'a hui'nahuanatoma', ya'ipiro'paquë ya'huëco'!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ina quëran itaantarin: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ni'co'. Ipora canpitaro'co anoyatërahuëso', shiparimapitanta yonquiato, napotaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ya'ipi ma'sharo'santa yonquiato napotaranquëma': Anpiantëhuano'sa', pë'tahuaro'sa', tananquë ma'sharo'sa ya'huërinso', nisha nisha nipisopita nancha quëran pipipiso yonquiato, sha'huitaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ipora canpitaro'co anoyatato sha'huitëranquëmaso', co onporonta nishataponhuë'. Co huachi piyapi'sa', ma'sharo'sa', inapita pacon quëran ata'huantaantapohuë'. Co huachi paconi isoro'pa' ata'huantaantaponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Canpitarë'co nani anoyatomiatërahuë. Ma'sharo'sarë'conta', nani anoyatërahuë. Ina yonquicamaso marë' yahua'tanëhuë inápaquë acoarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Chitoro inápaquë ya'nohuachin, yahua'tanëhuënta ya'noarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Naporo' canpitaro'co anoyatato sha'huitëranquëmaso', yonquiarahuë. Ama huachi i' quëran, isoro'pa' ata'huaanta'huaso marëhuë', yonquiarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yahua'tan chitoroquë ya'nohuachin ni'sarahuë. Ina ni'pato, ya'ipi piyapi'sarë'co ya'ipi ma'sharo'sarë'co anoyatërahuëso', ayonquiarinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nani ina acorahuë ayonquiinpoaso marë'. Canpitarë'co anoyatërahuëso ayonquiarinpoa'. Ma'sharo'sarë'conta anoyatërahuëso ayonquiarinpoa',” itërin. Ina pochin Yosëri Noi sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noi hui'ninpita nancha quëran pipipisopita, iso nápo ya'huëpi: Simo, Camo, Cahuito, inapita. Camoso', a'nara hui'nin ya'huëtërin. Inaso', Canaan itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Caramiáchin Noi hui'ninpita nipirinahuë', inayaquëranchin isoro'paquë piyapi'sa na'antapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ina piquëran Noi iminaton, inaquë opasáchin shacaton, oparotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","A'na tahuëri Noi huino o'oton, no'pirin. No'piton, në'mëtë pëinën huáncana notataton, i'nanpirashitë quëhuëánin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Camoso', inaquë ya'conahuaton ni'pirinhuë', pa'pin no'piton huë'ësárin quënanconin. Quënanahuaton iinpita sha'huitapon pa'nin: “Tata no'piton i'nanpirashitë quëhuëánin ni'conahuë,” itërin. (Nani sha'huirahuëso chachin Camoso', Canaan pa'pin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ina natanahuatona', Simo, Cahuito, inapitaso a'nara a'mopiso mapi. Ina masahuatona', niimopitopi. Niimopitopiquëranchin, pinëna quëran ya'conatona', pa'pina imotopi. Niquë notëtopi ni'ton, co pa'pina ni'pihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noi nonatohuachina, hui'nin hua'hua nininsoari, napotërinso natantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Natantahuaton, Canaan itapon: “¡Tata tëhuërin ni'ton, pa'pi co noyahuë' nicatënquën co huachi noya ya'huëcamaso marëhuë' sha'huitaranquën! Yosë chiníquën ana'ichinquën. Ipora quëran huarë' iyaro'sa camaiáponquën. Shiparimapitanta inaporápona',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ina quëran taantarin: “Sinioroso', Yosënëhuë. Inari Simo noya nicaton noya ya'huëcaso marë' catahuain. Canaanso', Simo piyapinën niin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yosë nohuanton, Cahuito, pancana hua'anënchin. Simo ya'huërinquë noya ninicatona ya'huë'ina'. Canaanso', Cahuito piyapinën niin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pacon pa'ninso piquëran, Noiso' cara pasa a'natërápo shonca pi'ipi ya'huaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ya'ipiya quëran iscon pasa a'natërápo shonca pi'i icanin. Ina piquëran chiminin huachi. Ina pochin Noi ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iporaso', Simo, Camo, Cahuito, inapita shinpita napopiso sha'huichinquëma'. Pacon pa'ninso piquëran hui'nahuanatona na'antapiso', sha'huichinquëma'. Simo, Camo, Cahuito, inapitaso nani sha'huirahuëso chachin, Noi hui'ninpita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Cahuito hui'ninpitaso', isopita: Comiri, Macoco, Matai, Capano, Toparo, Misico, Tirasi, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Comiri hui'ninpitanta': Asiquinasi, Nipato, Tocarama, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Capano hui'ninpitanta': Inisi, Tarsis, Quitimo, Notanimo, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ina nápo Cahuito hui'ninpita, shinpita inapita ya'huëpi. Inapitaso', marë yonsano'sa parti, ya'huëpi. Inatohua ninanoro'sa ocoirahuatona', a'naya a'naya nacionënaquë, a'na huënton a'na huënton, nisha nisha ya'huëpi. Inahuara no'panënaquë ya'huëpi. Naporahuatona', inahuara nonpiso nananquë nonatona', ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Camo hui'ninpitanta isopita: Coso, Misiraimo, Oto, Canaan, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Coso hui'ninpitanta': Sipa, Apira, Sapota, Naama, Sapitica, inapita. Naama hui'ninpitanta': Sipa, Titan, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cososo', a'na hui'nin ya'huëtërin anta', inaso', Nimoroto itopi. Ina'ton chini chiníquën nanantaton, isoro'paquë hua'an ya'conin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimorotoso Siniorori catahuarin ni'ton, pa'pi míso inantërin. Napoaton piyapi'sa nonpachinara pa'yatopi napocaiso': “Siniorori Nimoroto catahuarin ni'ton, míso inantërin. Inapochachin quëmanta catahuainquën,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimoroto hua'anëntërinso no'paquë, ninanoro'sa panca panca nipisopita, isopita ya'huërin: Papiri, Irico, Acato, Carini, inapita. Inapita ninanoro'saso', Sinaro parti ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ina parti quëran Asoronta pipirahuaton, ninanoro'sa ocoirin: Ninihui, Niopoto-iri, Cara, inapita itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Naporahuaton, Nisin ninanonta ocoirin. Inaso', panca ninano'. Ninihui, Cara, inapita ninanoro'sa huáncana ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Misraimo shinpitaso': Notoro'sa', anamoro'sa', niapiro'sa', napotoro'sa', patrosoro'sa', casonoro'sa', capotoro'sa', inapita. Capotoro'sa quëran huiristino'sa pipipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaanso', paninan hui'nahuanpachina, Siton itërin. Ina quëran hui'nahuaantahuachina, Iti, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Canaan shinpitanta isopita: Quiposoro'sa', amororo'sa', quiriquiro'sa', iporo'sa', arasiro'sa', siniro'sa', arapatiro'sa', simariro'sa', amatiro'sa', inapita. Ina piquëran Canaan huëntono'sa niquë niquë yanquëëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Canano'sa no'pa' hua'anëntopiso', Quiraro parti huarë' icanin. Siton ninano quëraonta', Casa ninanoquë huarë' icanin. Naporahuaton, Sotoma, Comora, Atoma, Sipoin, inapita ninanoro'sataquëchin no'pa' mapi. Nasa ninanoquë huarë' no'pa' hua'anëntopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ina nápo Camo hui'ninpita, shinpita inapita ya'huëpi. A'naya a'naya nacionënaquë, a'na huënton a'na huënton, nisha nisha ya'huëpi. Inahuara no'panënaquë ya'huëpi. Naporahuatona', inahuara nonpiso nananquë nonatona', ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Cahuito iin mashonënso', Simo itopi. Inanta', hui'ninpita ya'huëtërin: Ipiri hui'ninpitaso', Simo shinpita nipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Simo hui'ninpita isopita ya'huëpi: Iramo, Asoro, Arapasato, Noto, Aramo, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramonta hui'ninpita isopita ya'huëpi: Osi, Ori, Quitiri, Masi, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arapasatonta', Saro pa'pin. Saronta', Ipiri pa'pin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ina quëran Ipirinta cato hui'ninpita ya'huëtërin: A'naso', Piriqui itopi. Naporo tahuëri'sa piyapi'sa itohua itohua yanquëëpi ni'ton, ina pochin ninihuanin. Iya'huainta Cotano itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Cotanoso', iso nápo hui'ninpita ya'huëtërin: Aromota, Siripi, Asaromapi, Quira, Atoramo, Osaro, Tiquira, Oparo, Apimairo, Sipa, Opiro, Apira, Copa, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Inapitaso Misa parti ya'huërahuatona', Sipari parti huarë' ya'huëpi. Ina partiso', motopiro'saráchin niconin. Cortanii' quëran, pi'i pipirinso parti ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ina nápo Simo hui'ninpita, shinpita, inapita ya'huëpi. A'naya a'naya nacionënaquë, a'na huënton a'na huënton, nisha nisha ya'huëpi. Inahuara no'panënaquë ya'huëpi. Naporahuatona', inahuara nonpiso nananquë nonatona', ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ina nápo Noi hui'ninpita quëran pipipi. Nisha nisha huënton nipisopita. Nisha nisha shimashonëna quëran pipitona', nisha nisha parti no'pa' hua'anëntopi. Pacon pa'ninso piquëran itohua itohua yanquëpi. Yanquërahuatona', nisha nisha naciono'sa isoro'paquë ya'huërinso ocoipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pacon piquëran notohuaro' piyapi'sa na'antapi. Naporo' ya'ipiya a'na nananquësáchin nonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Pi'i pipirinso parti quëran pipirahuatona', Sinaro parti canquipi. Inaso no'pa', noyápiro'tëchin ni'ton, inaquë ya'huëcaiso marë' quëparitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","A'na tahuëri inahua capini ninontatona', napopi: “Huëco pa'ahua', natëricho no'pa quëran nicatëhua', a'pëahua',” nitopi. Ina nisahuatona', natëricho quëran na'pi ya'huërënamën pëipi. Achinpitacaiso marënta', to'ni pochin nininquë achinpitopi. Siminto pochin nininso ya'huërënamën, inaquë achinpitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ina quëran ninontaantapi: “Huëco chiníquën cancantatëhua', ninano ocoia'ahua'. Ina nisahuatëhua', a'na torinta pi'iro'tëquë huarë' nincaninso niahua'. Inapoatëhua', sacóshin nahuinarihua'. Naporahuaton, co huachi itohua itohua yanquëcaso ya'huaponhuë',” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Napopirinahuë', Sinioroso o'marin. O'marahuaton ninano', tori, inapita nisapiso ni'quimarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ni'quimarahuaton, yonquirin: “Isopitaso inaquësáchin ya'huatona', ina nananquësáchin nonpi ni'ton, nani caniaritopi sacatacaiso'. Po'pachinara, co incari tëranta nanitarinhuë atananpitacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Napoaton acopitacaso marë', pa'matëhua nonpiso anishatahua'. Ama huachi ninatanacaiso marëhuë', napotahua',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Inapotaton, Siniorori piyapi'sa itohua itohua ayanquëërin. Ninano nisapisonta a'porahuatona', tananpitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Inaquë chachin Siniorori, ya'ipi piyapi'sa nonpiso anishatërin. Ina quëran chachin, ya'ipi isoro'paquë ayanquëërin. Napoaton ina ninanoso', Papiri itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Simo shinpita napopiso sha'huichinquëma'. Pacon pa'ninso piquëran cato pi'ipitapaso', Simo pasa pi'ipitarin. Naporo' a'nara hui'nin nasitërin. Nasitohuachina, Aropasa, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ina piquëran Simoso', a'natërápo pasa pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aropasa cara shonca a'natërápo pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Saro itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ina piquëran Aropasaso', catapini pasa cara pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Saro cara shonca pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Ipiri itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ina piquëran Saroso', catapini pasa cara pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ipiri cara shonca catapini pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Piriqui itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ina piquëran Ipiriso', catapini pasa cara shonca pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Piriqui cara shonca pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Nio itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ina piquëran Piriqui cato pasa iscon pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Nio cara shonca cato pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Siroco itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ina piquëran Nioso', cato pasa canchisë pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Siroco cara shonca pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Nacoro itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ina piquëran Sirocoso', cato pasa pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacoro cato shonca iscon pi'ipitaso', hui'nin nasitërin. Nasitohuachina, Tari itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ina piquëran Nacoroso', pasa shonca iscon pi'i aquëtë ya'huaantarin. A'napita hui'ninpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tari canchisë shonca pi'ipitaso', hui'nin paninantërinso nasitërin. Ina quëran cato hui'ninpita ya'huëtaantarin. Hui'ninpitaso': Apran, Nacoro, Aran, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","28","Sha'huitëranquëmaso chachin Tari hui'ninpitaso', isopita: Apran, Nacoro, Aran, inapita. Aran hui'ninso', Noto itopi. Aranso', Orë ninanoquë chiminin. Ina ninanoso', Cartia parti ya'huërin. Co'huara pa'pin chiminyátërasohuë', chiminin. Hua'huatërinso ninanoquë chachin naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Apranso', Sarai manin. Nacoronta', Mirica manin. Miricaso', Aran hui'nin. Inaso', a'nara caipayain ya'huëtërin, Isca itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraiso co hua'huana'pihuë ni'ton, co hua'huaninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tariso', Orë ninano quëran pipirin. Cartioro'sa ya'huërin quëran pipirahuaton, Canaan parti chinoton, pa'nin. Hui'nin Apran itopiso Sarairë chachin quëparin. Naporahuaton, shionta Noto itopiso quëparin. Pa'sapirinahuë', Aran ninanoquë canconpachinara, inaquë quëparitonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Inaquë ya'huëasoi', Tariso chiminin. Cato pasa a'natërápo pi'ipitaso chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","A'na tahuëri Siniorori Apran itapon: “Ya'huëran quëran pipimiatëquë'. Quëmopinënpita, tataparin ya'huërinso no'pa', inapita patëquë'. A'na no'pa' carinquën a'notaranquën. Inaquë ya'huëconquë huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","A'na tahuëri ca nohuanto, shiparinpita panca nacion ocoiapona'. Carinquën catahuamiataranquën. Inapotaranquën ni'ton, sacóshin nahuinaran. Naporahuaton, quëmá quëran a'napitanta catahuararahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Inpitasona noya nicatënën catahuahuachinën, carinta inapita inapotarahuë. Inpitasona co huachi noya ya'huëcamaso marëhuë' sha'huitohuachinën, carinta inapita napotarahuë. Quëmá quëran, ya'ipi piyapi'sa nisha nisha nipisopita catahuararahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","6","Apranso Yosëri sha'huitërinso chachin, Aran ninano quëran pipirin. Canaan parti paacaiso marë' pipirin. Canchisë shonca a'natërápo pi'ipitaso napoarin. Sa'inë chachin pa'nin. Sa'inso', Sarai itopi. Apin Noto itopisonta', quëparin. Ya'ipi ma'shanënapitarë chachin pa'pi. Piyapinënapitanta quëmapi'sa', sanapi'sa asacatacaiso marë' Aranquë pa'anpiso', quëpapi. Ya'ipi quiquipi. Canaan parti canconpachinara, Apranso piyapinënpitarë chachin ya'ipi ina no'pa' pa'tatona', pëntontopi. Siquimo ninanoquë huarë' canconpi. Inaquë panca insina nara ya'huërin. Ya'huëhuano'sa mamanshinëna moshapiquë ni'ton: “Mori insina,” itopi. Ina parti naporo canano'sa ya'huëapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Inaquë Siniorori, Apran ya'notahuaton, itërin: “Ya'ipi iso no'pa', shiparinpita quëtarahuë hua'anëntapona',” itërin. Naporo chachin Apran Sinioro chinotacaso marë' a'nara artaro ninin. Inaquë ya'notërin ni'ton, chinotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ina quëran motopiro'sa parti pa'pi. Ina motopiro'saso', Pitiri ninano quëran, pi'i pipirinso parti quëparitërin. Inaquë në'mëtë pëiro'sa otënpi ya'huëcaiso marë'. Pitiri ninanoso', pi'i ya'coninso parti acorahuatona', Ai ninanonta', pi'i pipirinso parti acopi. Ina huancánachin ya'huëipi. Inaquë naquëranchin Apran Sinioro chinotacaso marë' a'na ya'huërë' artaro niantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ina piquëran Apran piyapinënpitarë chachin paantapi. Oshaquëran pa'sápatona', Niquipi parti canconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Naporo tahuëri'sa ina parti panca tanarotopi. Napoaton Apran piyapinënpitarë chachin Iquipito parti yacapatacaiso marë' pa'pi. Ya'huëpiquë co manta capacaiso ya'huërinhuë' ni'ton, inatohua pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Iquipito no'paquë ya'caritohuachina Apranso', Sarai itapon: “Ni'quë', quëmaso tëhuënchachin noyápiroyanchinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Iquipitoro'sa ni'pachinën noyaponën nimara: ‘Isoso quëmapi, paso sanapi so'in,’ ta'tona', caso tëpaponaco. Quëmaso nipirinhuë', macainënquënso marë' co tëpaponënhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Napoaton ama quëma na'in quëran tëpainacoso marëhuë': ‘Isoso yo'yohuë,’ tëquë', topirahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Iquipito no'paquë Apran camahuachina, Iquipitoro'saso Sarai ni'sahuatona', pa'yatopi: “Ma noyápiroyanchincha paya,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Iquipito copirnoso', “huaraon” itopi. Ina catahuapisopita hua'ano'santa', Sarai ni'pi. Ni'sahuatona', noyápiroyanchin nininso hua'anëna sha'huitonpi. Natanahuaton huaraonso': “Quëshico,” tënin. Napoaton Saraiso', ina pëinënquë quëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai marë' huaraonso', Apran pa'pi payarin. Nani ma'sha topinan quëtërin. Ohuicaro'sa', ohuacaro'sa', camiyoro'sa', moraro'sa', inapita quëtërin. Naporahuaton piyapinënpita camaicaso marë' quëmapi'sa', sanapi'sa', quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Napoaponahuë', Sarai na'inin ni'ton, Yosëri huaraon ana'intërin. Sa'in, hui'ninpitarë chachin chiníquën canio quëran ana'intërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Napoaton Apran amataton, itapon: “¿Onpoatonta napotëranco? ¡Iso sanapi sa'an nipirinhuë', sha'huichitonco pora! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘Oshihuë’ tënanso marë', cari shimanahuë. ¡Ma'tana sa'an, macaton quëpaquë huachi!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Napotahuaton piyapinënpita camairin: “¡Apran, sa'inë chachin ocoico pa'in. Ma'shanënpitanta quëpa'in!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Apranso sa'inë chachin Iquipito quëran pipirin. Ma'shanënpitarë chachin Niquipi parti huënantatona ya'huëinantapi. Apin Noto itopisonta', inarë chachin huënantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Apranso', notohuaro' oro, prata, pë'tahuaro'sa', inapita ya'huëtaton pa'pi ma'huan. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Niquipi parti quëran oshaquëran pa'sápatona', Pitiri ninanoquë huarë' huënantapi. Ina quëran paantarahuatona', i'hua ya'huërinquë chachin ya'huëinantapi. Pitiri ninano', Ai ninano', inapita ninanoro'sa huáncana ya'huëinantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","I'hua artaro nininquë chachin, Sinioro chinotaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Notonta', apin pochachin pa'pi ma'huan. Notohuaro' ohuicaro'sa', ohuacaro'sa', inapita ya'huëtërin. Piyapinënpitanta na'a ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nipirinhuë', notohuaro' pë'tahua ya'huëtopi ni'ton, co huachi pasto nanirinhuë pë'tahuaro'sa capacaiso'. Napoaton co huachi nanitopihuë cato chachin inaquëráchin ya'huëcaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Apran pë'tahuanën a'paipisopita, Noto pë'tahuanën a'paipisopitarë', pasto niapiratatona yánino'huipi. Naporoso', canano'sa', huirisiro'sa', inapitanta inaquë chachin ya'huërapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Napoaton a'na tahuëri Aprani Noto itapon: “Canposo', quëmopinpo ninë'. Co canpo capini nino'huicaso ya'huërinhuë'. Co piyapinënpopitanta', nino'huicaiso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Niquë niquë nipachin, ya'huëa'a. Ni'quë'. No'paso panca ya'huërin. Insëquësona ya'huëcamaso marë' nohuantëranquë, quëma huayonquë'. Pë'natë parti huayonpatan, caso pëtëtë parti pa'sarahuë. Pëtëtë parti huayonpatan, caso pë'natë parti pa'sarahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Natanahuaton Notoso', motopia'hua quëran, Cortanii' yonsan noyarotomarinso nocorin. Sohuaro ninanoa'huaquë huarë' notërinso' icanin. Inaquëso', notohuaro' i' ya'huërin ni'ton, pa'pi noyaro'pa' ninin. Sinioro sha'tërinquë pochin ni'ton, Iquipito no'pa' pochin ninin. (Ina pochin iráca ina no'pa' nipirinhuë', co'huara Siniorori Sotoma, Comora, inapita ninanoro'sa ata'huanchátërasohuë', naporin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ina ni'sahuaton, Notoso ya'ipi ina no'pa' huayonin. Inaso no'pa', pi'i pipirinso parti ya'huërin. Inapoatona', Apran Notorë' nia'popi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Apranso', Canaan parti quëparitërin. Notoso', Cortanii' yonsan ninanoro'sa parti ya'huëconin. Sotoma ya'cariya ya'huëconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Inaquëso', ya'huëhuano'sa pa'pi co noyahuë' nipi. Inapoatona oshahuanpi ni'ton, Yosëri no'huípiro ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Noto pa'pachina, Siniorori Apran ya'notaton itapon: “Huaniran quëran ya'ipi parti notëtëquë': Pë'natë parti, pëtëtë parti, pi'i pipirinso parti, pi'i ya'coninso parti, ya'ipi inaquëpita notëton, noya ni'quë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ya'ipi no'pa' ni'nanso', carinquën hua'anëntacaso marë' quëtaranquën. Quëmari hua'anëntomiataran. Naporahuaton, shiparinpitarinta hua'anëntomiatapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ca nohuanto shiparinpita pa'pi notohuaro' na'amiatapona'. Mo'shi co pichicasohuë' ninin. Inapochachin shiparinpitanta co onpo pichicasohuë' na'apona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Iporaso', paaton ya'ipi iso no'pa' pa'tëquë'. Itohua itohua pa'tëquë'. Carinquën quëtaranquën ni'ton, inapotëquë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ina natanahuaton, Apranso piyapinënpitarë chachin në'mëtë pëiro'sa ótënpiso mapi. Masahuatona', insina nararoquë pa'pi. Inaquë pa'sahuatona', ya'huëconpi huachi. Ina nararoso', Mamiri itopisoari hua'anëntërin. Ipron ninano ya'cariya inaso'. Inaquë Apran Sinioro chinotacaso marë' a'na artaro niantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Naporo' Misopotamia parti: Sinaro ro'tëquë, Amarahuiro itopiso' copirno nisarin. Irasaro ro'tëquënta', Arioco itopiso copirno nisarin. Iran ro'tëquëso nipirinhuë', Quitaraomiro itopiso copirno nisarin. Coimo ro'tëquënta', Titaro itopiso copirno nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","3","Inapitaso', isopita a'natërápo copirnoro'sarë', niinimicotatona niahuërápi: Pira, Pirsa, Sinapo, Simipiri, inapita itopisoarë' niahuërápi. Piraso', Sotoma ninano copirno. Pirsanta Comora ninano copirno. Sinaposo nipirinhuë', Atoma ninano copirno. Simipirinta Sipoin ninano copirno. Pira ninanoa'hua copirnonta', inapita catahuarin. (Pira ninanoa'huaso', Soaro itopi anta'.) Inapitarë', a'natërápo copirnoro'sa', Sitin motopiana itopiquë, sontaronënapita yontonpi ahuëtacaiso marë'. Inaso motopiana, Chimirii' marë parti quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ina nápo copirnoro'sa chachin Quitaraomirori iráca canaton, shonca cato pi'ipi camairin. Napoaponahuë', ina pi'i niantarinquë a'natërápo copirnoro'saso napopináchin yonquiatona', Quitaraomiro yaahuëpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ina pi'i huëantarinquë Quitaraomiroso', cara copirno catahuarinsopitarë chachin, huëantarin. Asotaroto Carnain parti huë'sahuatona', nihuaimoro'sa canaipi. Ina quëran sosiro'sa ya'huërë', An ninanoquë ya'huëpisopita canaantapi. Imiro'santa', Sapi-quiritain ninanoquë canaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Orioro'santa Sëir motopiro'saquë canatona', Ir-paran ninanoquë huarë' imapi. Ina ninanoso', inotëro intonquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Quitaraomiroso cara copirno catahuarinsopitarë chachin tahuërëantarahuatona', In-mispa ninanoquë canquipi. Ina ninanoso', Catisë itopi anta'. Huëantapona pochin amaricoro'sa ya'huërinso parti tiquitëriapi. Naporahuaton amororo'santa', Asison-tamarquë ya'huëpisopita inapotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Naporiatona', Sitin motopianaquë canquipi huachi. Naporo' Sotoma, Comora, Atoma, Sipoin, Pira, inapita ninanoro'sa copirnonënaso', inaquë pa'mapi. Sontaronënapitarë chachin pa'mapi. Inaquë inapita a'natërápo copirnoro'saso', Quitaraomiro, catahuarinsopita, inapitarë' niahuëpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ya'ipi Sitin motopianaquë, notohuaro' to'ni pochin nininso' posoro'sa ya'huërin. Naporo' quira nipachinara, Sotoma, Comora, inapita copirnoro'sa', piyapinënapitarë chachin ta'api. Ta'apirinahuë', ina posoro'saquë anotopi. A'napita cara copirnoro'saso nipirinhuë', motopiro'sa ta'atopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Canatoro'saso', Sotoma, Comora inapita ninanoro'saquë ya'conpi. Inaquë ya'conatona', cosharo', ma'sharo'sa pa'ton nininsopita, inapita ya'ipi macatona quiquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sotomaquë, Apran apin Notonta', ya'huërin ni'ton, inanta quëpapi. Ya'ipi ma'shanënpitarë chachin quëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Napoaponahuë', a'nara quira quëran cha'ërahuaton, Apran sha'huitapon pa'nin. (Apranso', iprio piyapi itopi.) Naporo' inaso', Mamiriri hua'anëntërinso insina nararoquë ya'huërarin. Mamiriso', amoro piyapi. Iin mashonënpitaso': Aniri, Iscoro, inapita. Inapitaso' Apran payatona', catahuapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Apranso apin quëpapiso natantahuaton, piyapinënpita natëtono'sa nipiso huayonin. Inapitaso', pëinënquë chachin hua'huatatona so'sopiso'. Ayontonpachina, cara pasa shonca posa quëmapi'sa ya'ipiya quëran icanpi. Inapitarë', Apran pa'nin copirnoro'sa imacaso marë'. Tano ninanoa'huaquë huarë' imarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pa'sahuatona', inimicoro'sa quënanconpi. Yono tashi nisahuaso', ya'copirahuatona', ahuëpi. Copirnoro'sa canarahuatona', imapi. Opa ninanoquë huarë' imapi. Ina ninanoso', Tamasco ninano quëran norti parti quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Inapoatona', ya'ipi ma'sha quëpapiso' matopi. Notonta nicha'ërahuatona', ya'ipi ma'shanënpitanta quëpatopiso', mataantarin. Naporahuaton, na'a piyapiro'sa nicha'ërin. Sanapi'santa quëparapirinahuë', nicha'ërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Apranso' Quitaraomiro canarin. Cara copirno catahuarinsopitarë chachin canarin. Inapita canarahuaton huënantarin. Huëntaso', Sotoma copirnori nacapirin. Sapi motopianaquë nacapirin. Inaso', “copirno motopiana,” itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A'na copirnorinta', Apran nacapirin. Inaso', Miriquiso itopi. Sarimoquë copirno ya'conahuaton, corto hua'an nimantarin. Yosë chini chiníquën nanantërinso marë' sacatërin. Inaso Apran a'carahuaton, huinonta o'shitërin. Piyapinënpitanta', a'carin, o'shitërin, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Nani a'carahuaton, Miriquisori Apran iso pochin sha'huitërin: “Yosë chini chiníquën nanantërinso', catahuainquën. Inaso', pi'iro'të', isoro'pa', inapita acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","¡Ma noyacha Yosëso chini chiníquën nanantërin paya! itahua'. Ina nohuanton, inimiconënpita minsëran,” itërin. Naporo Aprani inimicoro'sa ma'sha matërinso', shonca quëran a'nara Miriquiso quëtërin. Inaso', diesmo itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ina piquëran Sotoma copirnori, Apran itapon: —Piyapi'sara' quëtoco, ya'huërë' ma'shaso', quëmari maquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Napotopirinhuë', Apraniso' itapon: —Yosë chini chiníquën nanantaton, pi'iro'të', isoro'pa', inapita acorin. Ina ni'sárinco ni'ton, co pi'shi tëranta', co sapatë nonin tëranta caora marë' macapohuë': “Cari, Apran ama'huanahuë.” Ama tëcamaso marëhuë', co macapohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Caso caora marë' co manta nohuantërahuë'. Piyapinëhuëpita ca'pisoíchin tëhuënchinso', nani matatë pochin nitëranquën. Naporahuaton, Aniri, Iscoro, Mamiri, inapitanta ahuëta'huaso', catahuarinaco. Inapita tëhuëchinso' ma'sha mapiso', onpopionta macacaiso ya'huërin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ina piquëran Siniorori, Apran ya'notërin. Co huë'ëponahuë', hua'narëso pochin nontërinso' natanin: —Apran, ama të'huaquësohuë', carinquën pa'poyaranquën. Panca acanamiataranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Napotopirinhuë', Apraniso' itapon: —Sinioro. Quëmaso Yosënquën. Panca acanamiatopirancohuënta', co hui'nahuë ya'huëtërincohuë' ni'ton, topinan quëran nisarin. Co a'naya tëranta hui'nahuë quëtërancohuë ni'ton, piyapinëhuë Irisëro itëraiso ya'huërëtaponco. Inaso Tamasco piyapi nipirinhuë', chiminpato ya'huërëtaponco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Siniororiso nipirinhuë', itapon: —Co ina ya'huërëtaponquënhuë'. Hui'nan chachin ya'huërëtaponquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Itahuaton, në'mëtë pëinën quëran ocoirin. Ocoirahuaton, sha'huitërin: —Pi'iro'të në'përahuaton, tayoraro'sa pichiquë'. Nanitohuatan pichiquë'. Ina nápo shiparinpita ya'huëtarinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Naporinso natanahuaton: “Yosë no'tëquën nontërinco,” tënin Apran. Naporinso marë' Siniorori nóya ni'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Napoaton itapon: —Caso Sinioroco. Orë ninano quëran ocoiranquën. Inaquëso cartiaro'sa ya'huërin. Iso no'pa' quëtaranquën hua'anëntomiatacaso marë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","—¿Onporahuatota hua'anëntomiata'huaso nitotapo? tënin Apran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","—A'nara ohuaca', a'nara capra, a'nara carniro, inapita cara pi'ipitopiso' quëshico. Naporahuaton, a'nara nëpë', a'nara pë'tahua nëpëa'hua', inapitanta quëshico, itërin Yosëri. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aprani, inapita ma'sharo'sa Yosë quëshirin. Tëparahuaton huancánachin nichatëra'piarin. Nichatërinsopita, cato panshinquë ya'carísha acorahuaton, anotëra'piarin. Inairaro'saso nipirinhuë', co nichatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ma'sha tëparinsopita, capita marë' tamëro'sa o'mapirinahuë', Apraniso a'parárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nani tashiahuachina, Apranso' noyá huë'ëtërin. A'nanaya pa'pi tashirori imotërin ni'ton, të'huatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Naporo' Siniorori itapon: —A'na tahuëri shiparinpita, nisharo'sataquë yacapatapona'. Inaquë piyapitatona', camaiyapona'. Aparisitapona'. Catapini pasa pi'i inapoapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Cariso nipirinhuë', aparisitërinsopita ana'intarahuë. Ina piquëran shiparinpita, noya cha'ëpona'. Ma'huano'sa pipipona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Quëmaso nipirinhuë', noyá mashoya nicama huarë' chiminapon. Co parisitaranhuë'. Inapoaton shimashonënpita quënancoanan. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Catapini shinpita huënton, ya'huërin piquëran, shiparinpita isëquë chachin huëntapona'. Amororo'sa co noyahuë' nipiso', co aquëtë huarë' nishátërarinhuë'. Napoaton naporo tahuëri'sa huarë' ana'intarahuë huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nani tashihuachina, a'nanaya orno conai' tomontárinso ya'norin. Naporahuaton, panca yanatëtë pochin pën orótahuaton, ma'sharo'sa nichatërinsopita huáncana, na'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Naporo tahuëri chachin, Sinioro Apranë anoyatërin. Anoyataton itapon: —Shiparinpita iso no'pa' quëtarahuë: Iquipito i' quëran huarë' Iopiratisii' pancai'pa', hua'anëntopiso naniarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Iporaso': Quiniro'sa', sinisëro'sa', catomono'sa', itiro'sa', huirisëro'sa', nihuaimoro'sa', amororo'sa', canano'sa', quiriquiro'sa', quiposoro'sa', inapitari iso no'pa' hua'anëntapi. Hua'anëntapirinahuë', quëma shiparinpita quëtarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai co hua'huana'pihuë ni'ton, co Apran hui'nahuaninhuë'. Napoaponahuë', Saraiso a'nara cosonanën ya'huëtërin. Inaso iquipitoron. Acara itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","A'na tahuëri Saraiso', so'in itapon: —Ni'quëchi, Sinioro co nohuantërinhuë ni'ton, co hua'huanahuë'. Napoaponahuë', cosonanëhuë acoanchinquën topirahuë. Tapona inaso', hua'huana'pi nisápirinhuë'. Hua'huanpachin cari masarahuë hua'huahuë pochachin nicacaso marë', itërin. Napotohuachina, Apranta nohuantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Naporo chachin Saraiso', Acara masahuaton, so'in acoantërin. Nani shonca pi'ipi Canaan parti ya'huapona pochin, napoapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Shiarahuaton Acaraso', cayorin huachi. Inaporahuaton, hua'anën nocanin. Nocanaton, co yanatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Naporo' Sarairi Apran itapon: —Quëma tëhuëran ni'ton, Acara nocaninco. Cari chachin acoantopiranquënhuë', iporaso' hua'huanaton, nocaninco huachi. Sinioro chachin inquënposona tëhuërëso' anitochinpo': Quëma tëhuëmaranquën, ca a'na napomaraco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Napotohuachina, Apraniso' itapon: —Ni'quë', cosonanënso', natëinquënso ya'huërin. Ma'sona nohuantëranso' nitëquë', itërin. Naporo quëran huarë' Saraiso', Acara pa'pi aparisitërin. Napoaton, inaso ta'arin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ta'apirinhuë', Sinioro anquëninëni inotëro parti quënanin. Shor iraquë i'sha pipirinso' ya'cari', quënanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Quënanahuaton, natanin: —Quëmaso' Acaranquën, nohuitëranquën. Sarai cosonanënquën. ¿Intoparanta huëcaton, intopata pa'saran? itërin. —Patronanëhuë Sarai itopiso' ta'ananpiarahuë, tënin Acara. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Naporo' Sinioro anquëninëni, itapon: —Naquëranchin patronanën paapantaquë'. Ma'sona camairinquënsopita, natëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Napotahuaton itaantarin: “Ca nohuanto, hua'huayátërahuë amiparinpita ya'huëtarinquën. Co pichicasohuë' na'apona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ipora cayoranso', quëmapia'huaya huaiyaran. Huaihuatan, Ismairo itëquë'. Co napion ancantaton na'nëranso', Sinioro nataninquën ni'ton, ina nininën acotëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mashotohuachin, tanan cahuario pa'pi notëraya pochin nisarin. Ya'ipiya inimicotarin. Inanta', ya'ipiya quëran, inimicotapona'. Quëmopinënpitari co quë'yapirinahuë', inahua notënanquë chachin ya'huapon,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Siniorori nontërin ni'ton, Acaraso' pa'yanënquë tapon: “¿Yosë chachin nontaporahuë co chiminahuë ti?” tënin. Ina yonquiaton, iso pochin Sinioro nohuitërin: “Nicatonco, catahuarincoso Yosë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Napoaton inaquë poso ya'huërinsonta', “Nanpiton, ni'sárincoso' posonën,” itopi. Ina pososo', Catisë ninano', Piriti ninano', inapita ninanoro'sari ahuancanapirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Acaraso' anquëni natërahuaton, patronanënquë chachin paantarin. Tahuëri nanihuachina huairin. Apran posa shonca saota pi'ipitaso', hui'nin nasitarin. Nasitohuachina, Ismairo itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Apran iscon shonca iscon pi'ipitaso', Siniorori ya'notahuaton, itapon: —Caso Yosëco, ya'ipi nanitaparahuë. Natëtonco, nohuantërahuësoráchin niquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Napohuatan, quëmarë'co anoyatarahuë. Ca nohuanto, hua'huayátërahuë shiparinpita ya'huëtarinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Naporo' Apranso', isonin. Isonin quëran, no'paquë huarë' monshomarin. Inapoaso Yosëri sha'huitaantarin: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Ni'quë', iso pochin quëmarë'co anoyatarahuë. Quëmá quëran na'a naciono'sa pipiarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Naporahuaton, co huachi Apran itaponënhuë'. Ipora quëran huarë' Apraan itaponën. Ca nohuanto na'a naciono'sa quëmá quëran pipipona ni'ton, ina pochin nohuitaponën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Carinquën catahuaranquën ni'ton, notohuaro' shiparinpita ya'huëtarinquën. A'naquën shiparinpita, copirno ya'conapona'. A'naquëonta', naciono'sa ocoiapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Quëmarë'co ipora nani anoyatërahuë. Shiparinpitarë'conta a'na tahuëri anoyatarahuë. Yosënënco ni'to, catahuaráponquën. Shiparinpitanta inapotápo. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ya'ipi Canaan no'pa' ipora ya'huëranquë, hua'anëntacaso marë' quëtaranquën. Shiparinpitanta iso no'pa chachin hua'anëntomiatapona'. Inapitanta', casáchin chinotaponaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Napotahuaton, taantarin: —Napoaponahuë', quëmarë'coso nani anoyatërahuë ni'ton, natëco. Inapochachin shiparinpitanta natëinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ina pochin canpitarë'co anoyatërahuë. Canpitanta anoyatërëhuaso yonquicamaso marë' ya'ipi quëmapinquëma', marcahuanamaso ya'huërin. Naporahuaton, ya'ipi shiparimapitanta inachachin natëina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Taparonëmaquë, sha'huëchin imorayatërinso', niyashitëtoco'. Inaporamaso', ayonquiarinquëma carë'quëma anoyatëramaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ipora quëran huarë' ya'ipi quëmapinquëma ninamasopita, nasitërin quëran posa tahuëritapaso', marcanën acotoco'. Hui'namanta', inapotoco'. Piyapinëma nisharo'sa pa'antëramasonta inapotoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ya'ipinquëma niacotacaso ya'huërin. Co a'naya tëranta topinan nicamaso ya'huërinhuë'. Inapohuatama', canpitarë'co anoyatërahuëso', nonëmaquë chachin chiminamaquë huarë' ya'huëápon. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nipirinhuë', insosona co marcanën niacotohuachinhuë', ya'huërama quëran ocoimiatoco'. Canpitarë'co anoyatërahuëso', co natërinhuë ni'ton, inapotoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Naporo chachin, Yosëri Apraan itaantarin: —Sa'aonta' Sarai itopiramahuë', co huachi inapochin nohuitaramahuë'. Ipora quëran huarë' Sara itapoma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Inanta noya nicato catahuararahuë ni'ton, hua'huanarin huachi. Tëhuënchachin cari noya nicato inapotarahuë. Na'a naciono'sa', ina quëran pipipona'. Ina quëran pipipisopita a'naquënso', copirno ya'conapona', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Napotohuachina, Apraanso isonin. Isonin quëran no'paquë huarë' monshorahuaton tëhuarin. Tëhuapon pochin yonquirin: “¡Pasa pi'ipitohuachinara, co huachi hui'nahuanpihuë'! ¡Saranta iscon shonca pi'ipitaton, co huachi onporonta nanitërinhuë hua'huanacaso'!” tënin yonquinënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Napoaton iso pochin Yosë nontërin: —¡Ma'cha Sinioro sha'huitërancoso chachin Ismairo catahuaranhuë paya! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Yosëriso nipirinhuë', itapon: —Sa'anquë chachin hui'nahuanaran ta'to, napotaranquën. Hui'nan nasitohuachin, Isaco itaran. Quëmarë'co anoyatërahuëso', inanta sha'huitarahuë. Sha'huitërahuëso chachin, shinpitanta catahuamiatarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismairo marënta nontërancoso', nani natananquën. Inanta catahuarahuë. Ca nohuanto na'a hui'ninpita ya'huëtapon. Ina quëran pipipisopita na'amiatapona'. Shonca cato hua'ano'sa nicacaiso' hui'nahuanapon. Ina shinpita quëran panca nacion pipipon. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Napoaponahuë' quëmaro'co anoyatato sha'huitëranquënsopitaso', Sara hua'huinquën nisarin. A'na pi'i quëran, ipora tahuëri'sa pochin, Isaco nasitapon, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Apraan nontërinso tonitahuaton, Yosëso ina quëran pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Naporo tahuëri chachin Apraanso', hui'nin Ismairo itërinso marca acotërin. Piyapinënpita pëinënquë chachin nasitopisonta', inapotërin. A'napitanta coriquinën quëran pa'aninso', acotërin. Ya'ipi quëmapi'sa Apraan pëinënquë ya'huëpisopita, marca niacotopi huachi. Yosë camaitërinso chachin nipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Apraan iscon shonca iscon pi'ipitaso', taparonën sha'huëchin yashitëtopi. Ismaironta shonca cara pi'ipitaso', inapotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Naporo tahuëri chachin ya'ipi quëmapi'sa nipisopita marca niacotopi. Apraan, Ismairo, inapita niacotopi. Piyapinënpitanta inapopi. A'naquën pëinënquë chachin nasitopi. A'naquënso', coriquinën quëran nisharo'sa pa'antërin. Ya'ipiya niacotopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Insina nararo', Mamiriri hua'anëntërinquë Apraan ya'huëarin. Inaquë niso', Siniorori, ya'notaantarin. Camotëchin pochin nisapaso' ya'notërin. Në'mëtë pëinën ya'coananënquë huënsaso', napoarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","3","Apraanso ni'pirinhuë', cara quëmapi ina notënanquë huaniapi quënanin. Quënanahuaton, a'naroáchin paaparin nontacaso marë'. Isonin quëran no'paquë huarë' monshorahuaton, itapon: —Sinioro, pi'pian yanontëranquën. Ama na'huëtocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Canpita topatama', nipa'morantëcamaso marë' piyapinëhuë i'sha quëshiinquëma'. Inapoatoma', nara tashinantërinquë, na'yapoma pochin, chinototaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ya'huërahuëtaquëchin na'huëarama ni'quëhuarë', ma'sha tëranta capamaso quëshiinquëma'. Ina quëran chiníquën cancantatoma', paantamaso marë', itërin. —Naporan ni'quëhuarë', inta nipachin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Napotohuachinara, Apraanso në'mëtë pëinënquë ya'conahuaton, Sara itapon: —Manorahuaton, cato shonca quiro pochin, noya noya tricoro'mo nininso' maquë'. Ina masahuaton, pan niquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Sa'in sha'huitahuaton, ta'arë'nachin ohuacaro'sa ya'huarinquë pa'nin. Noya noya nininso' toroa'hua huayonin. Huayonahuaton, a'nara piyapinën quëtërin. Quëtohuachina, inaso' tëparahuaton a'naroáchin capacaiso marë' anpirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ina a'capon pochin, ohuaca sho'shoi' atachirotopisonta', acotërin. Naporahuaton ohuaca sho'shoi' o'shitërin. Inapoaton, a'capon pochin ninararin pahuantohuachina acotacaso marë'. Ni'toro'sa nara tashinantërinquë coshatasoi naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nani coshatohuachinara, ni'toro'sari Apraan natanpi: —¿Sa'anpo huachi? itopi. —Ma'tana në'mëtë pëi acoana ya'huëarin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Naporo' a'nari itapon: —A'na pi'i quëran, nicaponquën huëantarahuë. Naporo' Sara hua'huanaton, hua'huin ipoarin huachi, itërin. Napoasoi Saraso', ya'ipi nonpiso' natanárin. Apraan pinën quëran, në'mëtë pëi acoana, ya'coana pirayan natanárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Apraan, Sara, inapitaso nani mashotopi. Saraso yaniton, co huachi onpo hua'huanchináchinhuë', ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ina yonquiaton, co huachi huina cacotatonhuë', tëhuarin huachi. Tëhuapon pochin, yonquirin: “Inaporahuë naporini, noya cancanchitohuë'. Napoaponahuë', catocoi chachin nani mashotërai ni'ton, co quiyaso inapoasocoihuë' ayapoi,” tënin yonquinënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Siniororiso nipirinhuë', Apraan itapon: —¡Sara co tëhuacasohuë nipirinhuë', tëhuarin! “Nani paiyaco” ta'ton, ¿co natëtërinhuë' hua'huanacaso ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¡Caso Sinioroco ni'to, ya'ipi nohuantërahuëso' nanitaparahuë nica'huaso'! A'na pi'i quëran, nicaponquën huëantarahuë. Naporo' Sara hua'huanaton, hua'huin ipoarin huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sinioro naporinso natanaton, të'huanënquë Saraso tapon: —Co tëhuarahuë', tënin. Napoaponahuë', Siniorori itapon: —Napopiranhuë', tëhuaranso' nitotërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nani coshatohuachinara, paantacaiso marë' ni'toro'saso' huanipi huachi. Sotoma ninanotaquëchin pa'sahuachinara, Apraani chi'yarin. Nontaton patacaso marë' chi'yarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","18","Papon pochin, Sinioroso' yonquiraarin. “Apraan quëran a'na tahuëri panca nacion pipiarin. Naporahuaton ina nacionso', chiníquën nanantarin. Napoaton ma'sona yaninahuëso', sha'huita'huaso ya'huërin. Nani sha'huitërahuë ya'ipi naciono'sa isoro'paquë ya'huërinsopita, ina quëran catahua'huaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nani ina huayonahuë hui'ninpita, shinpita, inapita noya pënënacaso marë'. A'chintërahuësopita natëtona', noya nicacaiso marë' pënënarin. Inapohuachin, sha'huitërahuëso chachin quëtarahuë huachi,” tënin yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Napoaton, Siniorori itapon: —Sotomaquë, Comoraquë, inaquëpita ya'huëpisopita, panca oshahuanpi. Inapoatona pa'pi co noyahuë' nahuinpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Napoaton inatohua pa'sarahuë. ¿Sha'huitërinacoso chachin ta'ma nisapi? ta'to, nitota'huaso marë' pa'sarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Cato ya'piso quëchitahuatona', Sotoma ninanoquë pa'pi. Apraanso nipirinhuë', Siniororë' ninontacaso marë' quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Napoaton ya'carirahuaton, natanin: —Tëhuëpisopitaso' no'tëquën chachin ata'huantamaso ya'huërin. Co tëhuëpisopitasohuë' nipirinhuë', co inapotamaso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tapona a'natërápo shonca ya'pi', co tëhuëpisopitasohuë' ninanoquë ya'huëpi. Ina nápo ya'huëpiso yonquiaton: ¿Co ninano nicha'ësaranhuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¡Ama Sinioro napoquësohuë'! ¡Tëhuëpisopita, co tëhuëpisopitahuë' co napopináchin oshahuanpiso pochin ana'intamaso ya'huërinhuë'! ¡Ama napoquësohuë'! ¡Quëmaso', noya noya coisë ya'ipi isoro'pa' marë' ninan ni'ton, no'tëquënáchin ana'intamaso ya'huërin! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Napotohuachina, Siniorori itapon: —A'natërápo shonca co tëhuëpisopitahuë', Sotoma ninanoquë ya'huëhuachin, inapita nosoroato ya'ipi ina ninanoquë ya'huëpisopita nicha'ësarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Apraaniso nipirinhuë', naquëranchin nontaantarin: —Quëmaso Yosënquën, caso topinan piyapico niporahuë', naquëranchin nontaanta'inquën. Ama ina marë' no'huicosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Catapini shonca a'natërápora' co tëhuëpisopitahuë' nanihuachina', a'natërápo pahuaninso' marëáchin, ¿ya'ipi Sotomaquë ya'huëpisopita, ata'huantapon ti? itërin. —Catapini shonca a'natërápo tëranta co tëhuëpisopitahuë' ya'huëhuachina', co ninano ata'huantarahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","—Tapona catapini shoncara', co tëhuëpisopitahuë' ya'huëpi, taantarin Apraan. —Ina napoya tëranta ya'huëhuachinaso', co ata'huantarahuë', tënin Yosë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Apraaniso nipirinhuë', naquëranchin Yosë nontaantarin: —Inachin inachin nontápiranquënhuë', ama ina marë' no'huicosohuë' topirahuë. Tapona cara shoncara' ya'huëpi, itërin. —Cara shoncaya tëranta ya'huëhuachina', co ata'huantarahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","—Tëhuënchachin caso Sinioro co natantonhuë pochin nontáranquën. Cato shoncara', co tëhuëpisopitahuë' ya'huëhuachina': ¿Onpoaranta'? itaantarin. —Cato shoncanta co tëhuëpisopitahuë' ya'huëhuachina', co ninano ata'huantarahuë', itërin Yosëri. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Apraani naquëranchin nontaantarin: —Iporaíchin Sinioro nontaantaranquën. Ina quëran co huachi apiponquënhuë ni'ton, ama no'huicosohuë'. Shoncaíchin co tëhuëpisopitahuë' quënanpatan: ¿Onpoaranta'? itërin. Napotohuachina, Siniorori itaantarin: —Shoncaya tëranta co tëhuëpisopitahuë' ya'huëhuachina', co ninano ata'huantarahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Apraan nontërinso toquitahuaton, Sinioroso pa'nin huachi. Apraaonta', në'mëtë pëinënquë'pa' panantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nani yatashirahuaso', cato anquëniro'saso Sotoma ninanoquë camapi. Ninano ya'coanaquë chachin Noto huënsaso', camapi. (Inaquë ya'huëhuano'sa niyontonpi ma'sha yonquiatona anoyatacaiso marë'.) Cato ya'pi canquipiso quënanahuaton, paaparin nontapon. Isonin quëran no'paquë huarë' monshorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Monshorin quëran itapon: —Caso siniororo'sa piyapinëma pochinco. Huëco pëinëhuëquë onpopionta huë'ëcamaso nohuantoco'. Inaquë nanitërama nipa'morantëcamaso'. Tashiraya yapa'patama paantaco', itërin. Napotopirinhuë', inapitaso co nohuantopihuë'. —Naporinchi paya. Napopiranhuë' co nohuantëraihuë'. Caniquë tëranta noya huë'ëpoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Napotopirinahuë', Notori naquëranchin naquëranchin sha'huitohuachina, napoin quëran pëinënquë pa'pi huachi. Canconpachinara, noya cosharo nitërin. Pan co ahuëpocatopinanhuë' anpitaton, inapitarë' acotohuachina, ni'toro'sa coshatopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Napoaponahuë', co'huara chinochátërasoihuë' ya'ipi ya'huëhuano'sari Noto pëinën tancapitopi. Hui'napiro'sa quëran, mashoro'saquë huarë' yamoipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Noto no'huitona', chiníquën nontiipi: —¡Quëmapi'sa pëinënquë canquipiso'! ¿Intopata ya'huapi? ¡Ocoiquë tëcari'i! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Naporo' Notoso' pëinën noyá oncotahuaton, inapita nontapon pipirin. —Ama iyaro'sa napocosohuë', pa'pi co noyahuë' yonquirama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Cato hui'nahuëpita nano'sa co quëmapiri së'huayátërarinsohuë', ya'huëtërinco. Inapita nipachin ocoichinquëma', nohuantëramaso' nitoco'. Isopita quëmapi'saso nipirinhuë', ama napotocosohuë'. Cari përarahuë pëinëhuëquë ya'conquipi ni'ton, napotaranquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Inapitariso nipirinhuë', itapona': —¡Po'shaquë quëmaso'! Nisha piyapinquën niponahuë', ¿yacamairancoi ti? ¡Iporaso huachi inapita quëran na'con na'con, quëma nitarainquën! itopi. Napotatona', Noto ahuërapi. Pëinën ya'coananta', yapaparapitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Napoaponahuë', ni'toro'sari Noto mapi. Masahuatona', acoana po'mopi. Napotatona', ya'coana oncotaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Naporo chachin piyapiro'sa aipiran nisapisopita, a'naroáchin asomarayapi huachi. Hui'napiro'sa quëran, mashoro'saquë huarë' ya'ipi somarayapi. Ina nipirinahuë tëranta', amiai huarë' ya'coana yonípi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Naporo' ni'toro'sari, Noto itapona': —¿Ya'huëtërinquën aquëtë huarë' quëmopiro'sa isëquë? Hui'nanpita quëmapi'sa', sanapi'sa', mi'sëro'sa nicacaiso nipisopita ya'ipi inapita, iso ninano quëran ocoiquë'. Ocoiaton áquë quëpaquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Iso ro'të ata'huantarai ni'ton, quëpaquë'. Iso ninanoquë pa'pi co noyahuë' nipiso', na'a piyapi'sari Sinioroquë sha'huirapipi. Napoaton, ata'huanta'huaiso marë' a'parincoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Napotohuachinara, Notoso mi'sënpita nicacaiso nipisopita sha'huitacaso marë' pa'nin: —¡Manóton huëco pa'ahua'! Iso ninano quëran pipia'ahua'. ¡Siniorori iso ninano ata'huantarin ni'ton, huëco pa'ahua'! itërin. Itopirinhuë', co natëpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nani tahuëri ya'cari nipachina, anquëniro'sari Noto itapona': —¡Pashi tëquë'! Sa'an, cato hui'nanpita, inapita masahuaton, iso ninano quëran ocoiquë huachi. Ninano ata'huantëraiquë, chimintama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Napotopirinahuë', Notoso' co manorinhuë' ni'ton, Yosëri nosoroaton, yanicha'ërin. Napoaton anquëniro'sari, sa'inë chachin maimirarin. Hui'ninpitanta maimirarahuatona', ninano quëran cha'ëcaiso marë' ocoipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ninano quëran nani pipihuachinara, a'na anquëniri itapon: —¡Cha'ëcamaso marë' manóton ta'aco'! Ama pinëma parti tahuërëcosohuë'. Pa'mia paco'. Ama ma'sha marë' tëranta iso motopianaquë chinicosohuë'. Cha'ëcaso nohuantohuatama', motopiro'sa parti ta'aco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Notoriso nipirinhuë', itapon: —¡Co Siniororo'sa topirahuë'! Tëhuënchachin canpitaso', na'con catahuaramaco huachi. Noyanquëma ni'ton, nicha'ëramaco. Napoaponahuë', motopiro'sa parti ta'aca'huaso', co nanitarahuë'. Huancopi ni'soi', ayaro' icantatoncoi tiquihuachincoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ni'co', pasëyáquë a'na ninanoa'huaya ya'huërin. Inaquë tëhuënchinso' noya paca'huaiso' topirahuë. Nohuantoco inaquë pa'i cha'ëca'huaiso marë'. ¿Co'ta inaso', co panca ninanoyahuë'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Napotohuachina a'na anquëniri itapon: —Nani natananquën nontërancoso'. Nohuantëranso chachin nisarahuë. Co ina ninanoso', ata'huantapohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Napoaponahuë', ¡manóton inatohua paco'! Inatohua canama huarë' Sotoma ninano ata'huantarai huachi. Napoaton ina ninanoso', Soaro itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nani tahuërihuachina Notoso', Soaro ninanoquë camarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Naporo' Siniorori, pën o'nan pochin a'paimarin. Sha'pi mo'shirë chachin, a'paimarin. Sotoma, Comora, inapita ninanoro'sa aipi a'paimarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Inapotaton, ata'huantërin. Ya'ipi inaquë ya'huëpisopitarë chachin ata'huantërin. Ina motopianaquë papotërinsopitanta', ya'ipi tiquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Noto sa'inso nipirinhuë', co Soaroquë camarinhuë'. Oshaquëran so'in imaquiáponahuë', pinën parti tahuërëhuachina, inaquë chachin yamora moto' taranaton, chiminin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Tashiramiachin Apraanso', i'huara Sinioro nontërintaquëchin pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ina quëran, Sotoma, Comora, inapita ninanoro'sa nocorin. Ya'ipi ina motopiananta nocomapirinhuë', ina ro'të quëran pa'pi huëhuëpiro conai pipirarin ni'nin. Panca orno quëran tomontërinso pochin, pipirarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ina pochin, ina motopianaquë ninanoro'sa Yosëri ata'huantërin. Noto yacapatërinso parti noyá ata'huantërin. Notoso nipirinhuë', co ata'huantërinhuë'. Apraan yonquiaton, cha'ëcaso marë' ina quëran ocoirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Inapita ninanoro'sa ta'huantopi piquëran, Notoso' të'huatërin. Të'huataton, Soaroquë ya'huëcaso co nohuantërinhuë'. Napoaton cato hui'ninpitarë chachin motopiro'sa parti, ya'huëcaiso marë' pa'pi. Inaquë a'na motopi naninquë, cara chachin ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","A'na tahuëri paya paya nininsoari, caia'huain, itapon: —Ni'quë caira. Ya'ipi parti sanapi'sa ya'huërinso', so'yatona hua'huanpi. Canposo nipirinhuë', isoporinquë quëmapi pahuanin quëran, co inapochináchinhuë' ninë'. Tataíchin mini nipirinhuë', nani inanta mashotarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Napoaton, huëquë pa'a o'shitatë tëpaita'a. Inapotatë', hua'huanpo ya'huëtiinposo marë' huë'ëpa'a, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Naporo tashi chachin pa'pina huino o'shitomiatopi. Nani ano'pihuachinara, paninanso' pa'pin quëhuënaparin. No'pirahuë ni'ton, co nataninhuë' hui'nini quëhuënaparinso'. Co pa'ninso tëranta nataninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tahuëriantarinquë paninanso', caya'huain itaantapon: —Ni'quë caira, achin tashi caso tata quëhuënaparahuë. Quëma ya'huërë' quëhuënapacaso marë' ipora tashinta ano'pianta'a. Inapoatë catonpo chachin tatanpo quëran tëranta hua'huasha ya'huëchinpo', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ninapotatona', naporo tashi naquëranchin pa'pina huino o'shitaantapi. Nani ano'pihuachinara, hua'hua nininso ya'huërë', pa'pin quëhuënaparin. No'pirahuë ni'ton, Notoso' co nataninhuë' hui'nini quëhuënaparinso'. Co pa'ninso tëranta', nataninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Inapoatona', cato chachin cayopi. Pa'pina quëran napopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Paninanso' huaihuachina, quëmapia'huaya huairin. Inaso', a'shini Moapo itërin. Iso quirica ninshitasoco huarë', ina ipora moaporo'sa ya'huërinso shimashonëna ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Hua'hua nininsonta huaihuachina, quëmapia'huaya chachin ya'huëtërin anta'. Inanta a'shini Pin-ami itërin. Iso quirica ninshitasoco huarë', ina ipora amono'sa ya'huërinso shimashonëna ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Apraanso', piyapinënpitarë chachin ya'huëapi quëran pipipi. Pipirahuatona', Niquipi parti paantapi. Quiraro ninanoquë canconahuatona', inaquë ya'huëcaiso marë' quëparitopi. Ina ninanoso', Catisë ninano quëran Shor parti ira pa'ninso' huáncana quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Apraanso inaquë ya'huapon pochin, Sara sa'in nipirinhuë': “Oshihuë,” toconin. Napoaton Quiraro copirno Apimirico itopisori yamanin. Camaitohuachina, macacaso marë' Sara quëpatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Napoaponahuë', naporo tashi chachin Yosëri huë'ënquë pënënin: “Quëmaso chiminaran. Sanapi mananso so'yahuan ni'ton, chiminamaso ya'huërin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Apimiricoso', co Sara ichihuë'ëshátërarinhuë'. Napoaton Sinioro itapon: “Sinioro co manta onporahuë ni'ton, co tëpaancoso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Co'ta Apraan chachin naporin: ‘Oshihuë,’ tënin. Saranta': ‘Yo'yohuë,’ tënin. Cato chachin napopi ni'ton, co nitotatohuë manahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Napotohuachina, Yosërinta huë'ënquë chachin a'paniantarin: “Tëhuënchachin co nitotatonhuë' naporan. Napoaton ca nohuanto co ichihuë'ëranhuë'. Carinquën ya'copiranquën ama oshahuanaton tëhuëtancoso marëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Iporaso nipirinhuë', so'in chachin quëtaantaquë'. Inaso pënëntona'pi ni'ton, quëma marë' nontarinco. Ama chiminamaso marëhuë', nontarinco. Co'so' quëtaantahuatanhuë', sa'an, hui'nanpita, inapitarë'quën chachin, ta'huantaran,” itërin huë'ënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tahuërianpitohuachina, Apimiricoso huënsëintarahuaton, piyapinënpita amatërin. Huë'pachinara, ya'ipi hua'narinso sha'huitërin. Natanahuatona', piyapinënpitaso pa'pi pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ina quëran Apraan amatahuaton, itapon: —¡Ma'huantacha nitapirancoihuë paya! ¡Caso co maquë tëranta tëhuëtëranquënhuë'! Quëmaso nipirinhuë', napotatoncoi panca yaaoshahuanpirancoihuë'. Ca aoshahuanatonco, quëmopinëhuëpita, piyapinëhuëpita, inapita, na'inchitonhuë'. ¡Co naporëhuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","11","¿Ma'ta yonquiaton, napotopirancohuë'? itërin. Napotohuachina, Apraani itapon: —Isëquëso', co manta Yosë natëpihuë'. Sa'ahuë matiinacoso marë' tëpaponaco caso', ta'to naporahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Naporahuaton Saraso', oshihuë anta'. Ina tataquëranchin nipiraihuë', mamahuëi quëranso', nisha ninai. Napoaton cari manahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Yosë chachin, tatahuë ya'huërin quëran pipicaso' camaihuachincora, sa'ahuë sha'huitërahuë: “Insëquë tëranta pa'nëhuaquë: ‘Inaso yo'yo masho,’ tëquë ta'a, itërahuë,” tënin Apraan. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ina natanahuaton, Apimiricoso sa'in quëtaantarin. Naporahuaton, ohuicaro'sa', ohuacaro'sa', inapita quëtërin. Piyapinënpita camaicaso marënta': Quëmapi'sa', sanapi'sa', inapita quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ina quëtahuaton, itërin: —Ni'quë iya, no'panëhuëso pancana, insëquëso costaranquë ya'huëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saranta', itapon: —Ni'quë imoya, yo'yo masho huaranca coriqui prata quëran nininso' quëtërahuë. Ya'ipiya quëran co tëhuëransohuë' nitotacaiso marë' ina nápo quëtarahuë. Co insonta pinoinquënso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ina quëran Apraan, Yosë nontërin Apimirico marë'. Ina sa'in, cosonanënpita, inapita marënta', Yosë nontërin. Nontohuachina, Yosëri anoyatërin. Naquëranchin hua'huasha ya'huëtaantacaiso marë' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Siniorori nani Apimirico ya'huërinquë, sanapi'sa ana'intopirinhuë'. Ama hua'huanacaiso marëhuë', Sara na'in quëran napotopirinhuë'. Napoaton Apraani Yosë nontërin inari anoyatacaso marë'. Napohuachina, Yosëri Apimirico sa'in, piyapinënpita sa'ina', inapita anoyatërin. Hua'huasha ya'huëtaantacaiso marë' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Sha'huitërinso chachin, Siniorori Sara catahuarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ina nohuanton napoin quëran cayorin huachi. Tahuëri nanihuachina, quëmapia'huaya huairin. Inaso', Apraan mashoya nicaquë huarë' hui'nahuaninso hua'huatërin. Yosëri sha'huitërinso tahuëri'sa chachin, hui'nin nasitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sa'inquë chachin hui'nahuaninso nasitohuachina, Isaco itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Yosë camaitërinso chachin posa tahuëritohuachina, marca acotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Apraan pasa pi'ipitaso', hui'nin Isaco itërinso', nasitarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Naporo' Sara yonquirin: “Yosë catahuarinco ni'ton, capa cancantato, tëhuarahuë. A'napitanta', hua'huanahuëso nitotohuachina', ya'ipiya quëran capa cancantatona tëhuapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Co hua'huana'picohuë ni'to, co inso tëranta Apraan nontaton: ‘Tëhuënchachin Saraquë hui'nahuanaran,’ co ichitonhuë'. Inaso nipirinhuë', máshoya niponahuë', hui'nahuanin huachi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isacoa'huaya oshaquëran so'sohuachina, a'shini a'potërin. A'potërinso tahuëri, capa cancantacaiso marë' Apraan panca pita ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Capa cancantapirinahuë', Saraso' co noyahuë' cancantërin. Cosona hua'huini Isaco monaton ya'nipitarin ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Napoaton Apraan sha'huitërin: “¡Cosonaso', hua'huinë chachin, a'paquë pa'in! Isacoso hua'huahuë chachin ni'ton, co nohuantërahuë' quëma ma'shanënpita cosona hua'huionta quëtacaso',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ina natanaton, Apraan panca sëtërin. Hui'nin ni'ton, sëtëyarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Sëtopirinhuë', Yosëri itërin: “Ama hui'napi marë' sëtëquësohuë'. Co cosonanën marë' tëranta sëtacaso ya'huërinhuë'. Ma'sona Sara nohuantërinso niquë'. Isaco quëran pipipisopita, noya noya catahuararahuë. Inapita mini yonquiato nani sha'huitëranquën nisapaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Cosona hua'huionta catahuarahuë. Ca nohuanto, shinpita panca nacion ocoiapona'. Hui'nan chachin anta ni'ton, catahuarahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tahuëririnquë tashiramiachin Apraanso', Acara quëtacaso marë' cosharo manin. A'nara sha'huëtë morsaquë i'sha ta'panahuaton, quëtërin. Hui'nionta Ismairo itërinso', a'paantërin quëpacaso marë'. Inahuaso pa'pachinara, Piirsipa inotëro parti chihuëatona', topinan pa'sápi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","I'sha sha'huëtë morsaquë ya'huërinso', ta'quipi. Ta'quihuachinara Acaraso', naraa'huaya tashinantërianaquë hua'huin acorahuaton, patërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Aquëmiachin pa'sahuaton, huënsëconin. Ama hua'huin chimininso nicacaso marëhuë', inaquë huënsëconin. Huënsëhuachina, hui'napiso na'nërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Yosëri, hui'napi na'nërinso' natanin. Napoaton Yosë anquëninëni, inápa quëran përasahuaton nontërin: “¿Ma'ta Acara onporan? ¡Ama pa'yanquësohuë'! Yosëri, hui'napi na'nërinso' natanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Manóton pa'sahuaton, macontaquë'. Ama patëquësohuë'. Ca nohuanto, hua'huan quëran panca nacion pipipon,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Naporo' Yosë nohuanton, Acara a'na posoquë i'sha quënanin. Inaquë pa'sahuaton, sha'huëtë morsaquë manin. Ina masahuaton, hua'huin o'shitonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Yosëri, hui'napi catahuarin ni'ton, nóya a'shinin. Paran inotëro parti ya'huëpi. Míso pë'chinantërin. Oshaquëran a'shini Iquipito sanapi yoniton, acoantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Naporo tahuëri'sa pochin Apimirico pa'nin Apraan nontapon. Huicororë' pa'nin. Inaso', Apimirico sontaronënpita camairinso'. Inaquë Apimiricori Apraan itapon: —Tëhuënchachin quëmaso' nani ma'sha nipatana, Yosë catahuarinquënso ni'nai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Napoaton isëquë chachin Yoscoarë' ta'ton sha'huitoco: Ama hui'nahuëpita, shihuëpita, ama ca tëranta', ma'sha onpotancoso marëhuë', sha'huitoco. Carinquënso nosoroatënquën co ma'sha onpotëranquënhuë'. Inapochachin quëmanta noya ni'coi. A'napita ya'huëhuano'santa', noya ni'camaso marë' Yoscoarë' ta'ton sha'huitoco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Napotohuachina Apraan tapon: —Yoscoarë' co ma'sha onpotaranquëmahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Napoaponahuë', Apraani itaantapon: —Carinquëmaso', noya yonquirapiranquëma'. Quëma piyapinënpitaso nipirinhuë', a'nara poso ihuaraiso matërinacoi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ina natanahuaton, Apimiricori itapon: —Co sha'huitërancohuë' ni'ton, ipora huarë' namaso natanahuë. Inpitaso inapotomarinquën. Co caso nitotërahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Napotohuachina, naporo tahuëri cato chachin, noya ninitona ya'huëcaiso marë' anoyatopi. Yoscoarë' ta'tona', anoyatopi. Ina quëran anoyatopiso yonquicaiso marë' Apraani ohuicaro'sa', ohuacaro'sa', inapita manin. Masahuaton Apimirico quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Naporahuaton canchisë ohuica nanoyan nipisopita huëntonën quëran nisha acoarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","30","Nisha acoaso', Apimiricori itapon: —¿Ma'marëta canchisë ohuicaro'sa nisha acoaran? itërin. —Isopita canchisë ohuica, quëtaranquën: “Tëhuënchachin Apraani ina poso ninin,” ta'camaso marë' quëtaranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Napoaton ina ro'tëso', Piirsipa itopi. Inaquë cato chachin Yoscoarë' ta'tona', anoyatopi ni'ton, ina pochin nohuitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Nani anoyatohuachina Apimiricoso', Huicororë chachin huiristino'sa no'panën parti paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nani pa'pachinara, Apraanso inaranchin Sinioro chinotërin. Inaso': “Yosë ya'huëmiatërinso',” itopi anta'. Inaquë chinotaton, a'nara tamarisco nara sha'nin. Nani sha'huirahuë chachin ina no'paso', Piirsipa itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Hua'qui Apraan huiristino'sa no'panënaquë, yacapatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ina piquëran Yosëri: “¿Tëhuënchachin ta'ma Apraan natërinco to?” ta'ton, tënicaso marë' përarin: —Apraan, itërin. —Ma'ta Sinioro ya'huëarahuë, tënin Apraan. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Naporo' Yosëri itapon: —Hui'nan Isaco itëranso', a'naíchin ni'ton, nosoromiatëran. Ina nipirinhuë', masahuaton Moria parti quëpaquë'. Inaquë canconpatan, a'na motopi a'notaranquën. Inaquë chinotancoso marë' ina tëparahuaton, ya'ipi ahuiquitëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tahuëririnquë Apraanso', tashiramiachin huënsëintarahuaton, tapatarin huachi. Ihuë Yosë chinotaton ahuiquitacaso marë' pë'shitërinso', moranënquë a'mitërin. Ina quëran hui'nin, cato piyapinënpita, inapita quëparin. Yosëri sha'huitërinquë pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Cara tahuëri quëran Apraanso', Yosëri sha'huitërinso' no'pa' notërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Naporo' piyapinënpita itapon: —Isëquë ninatacoi. Moranta isëquë patarahuë. Quiyaso' amasha aquëcha pa'sahuatoi, Yosë chinotarai. Nani chinotohuatoi o'mantarai, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ihuë Yosë chinotaton ahuiquitacaso', Isaco apitëntërin. Inaoranta cosoroa'hua, pë'to ra'pi, inapita manin. Ina quëran pa'pi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Papon pochin Isacori, Apraan itapon: —¡Tata! itërin. —¿Ma'ta conpaa'hua'? itërin pa'pini. —Ni'quë tata, nani ihuë ya'huërin. Pë'to ra'pinta ya'huërin. Carniroa'hua ya'ipi ahuiquitacaso marëso': ¿Intoparanta manë'? itërin Isacori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","—Yosë nohuanton conpa ya'huapon, itërin pa'pini. Ina quëran, paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yosëri sha'huitërinquë canconpachinara, Apraanso a'nara artaro ninin. Tënirahuaton, ina aipi ihuë acorin. Ina quëran hui'nin tonporahuaton, ihuë aipi acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Inaquë acorahuaton tëpacaso marë' cosoroa'hua manantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Naporo chachin Sinioro anquëninëni, inápa quëran përarin: —¡Apraan! ¡Apraan! itërin. —Ma'ta Sinioro ya'huëarahuë, itërin Apraani. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Sinioro anquëninëniso', itapon: —Ama hui'nan tëpaquësohuë'. Tëniponquën napotopiranquënhuë', iporaso' nani nitotërahuë. Ya'ipi cancanën quëran huarë' imaranco tënahuë. Hui'nan a'naíchin nipirinhuë', co apiratërancohuë ni'ton, nitotërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Naporo' Apraan tahuërërahuaton ni'pirinhuë', a'nara carniro quënanin. Yosë nohuanton pomonën quëran, nara'huaya së'paquënquë a'tënin. Ina masahuaton hui'nin ya'huërënamën tëparin. Inapotaton, Yosë chinotacaso marë' ya'ipi ahuiquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ina quëran Apraani ina ro'të aninihuanin. “Pahuantërinpoaso' Sinioro quëtërinpoaquë,” itërin. Napoaton, iporahuanta ina pochin nohuitapi. “Motopiquëso', pahuantërinpoasopita Sinioro quëtërinpoa',” topi nonatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","16","Sinioro anquëninëni, naquëranchin inápa quëran Apraan përaton itapon: —Sinioro naporin: “Ya'ipi cancanën quëran huarë' natëtonco, a'naíchin hui'nan nipirinhuë' co apiratërancohuë'. Inaporanso marë' noya ni'nanquën. Caso Yosëco ni'to, no'tëquën sha'huitaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Noya nicatënquën catahuamiataranquën. Ca nohuanto shiparinpita, tayoraro'sa nápo na'apona'. Marë yonsanquë inotëra'huaya nápo, na'amiatapona'. Naporahuaton, inapitaso inimiconëna minsëra'piapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Quëma natëranco ni'ton, ya'ipi isoro'paquë naciono'sa ya'huërinsopita, shiparinpita quëran catahuararahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nani Yosë chinotahuatona', Apraanso hui'ninë chachin piyapinënpita quëparitopiquë, pa'mantapi. Ina quëran ya'ipi chachin, Piirsipaquë panantapi. Inaquë Apraan hua'qui ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hua'quimiachin ya'huapona pochin, Apraanso natantërin. “Miricanta', Nacoro sa'in nininso', Sara pochachin hua'huanin anta',” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Paninanso', Os itopi. Ina quëran niantarinso', Pos itopi. Ina quëran a'nanta niantarinso', Quimoino itopi. (Quimoinonta hui'nahuanpachina, Aramo itopi.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Quimoino quëran nasitaantapi: Quisito, Aso, Piritasi, Itarapi, Pitoiro, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ina Pitoiro mini, Nipica pa'pin. Nacoroso', Apraan iya'huain. Ya'ipiya quëran Miricaso', posa hua'huinpita ya'huëtërin. Ina nápo Nacoroso', sa'inquë chachin hui'nahuanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naporahuaton a'na sa'inquënta hui'nahuanin. Ina sa'inso', Nioma itopi. Inaquë hui'nahuaninsopitaso': Tipa, Caamo, Taas, Maaca, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saraso', pasa cato shonca canchisë pi'i icanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ina quëran Quiria-arpa ninanoquë chiminin. Ina ninanoso', Ipron itopi anta'. Inaso Canaan parti ya'huërin. Sa'in chimininso marë' Apraanso', sëtaton, na'nërárin, ayanárin, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ina quëran, sa'inco' nonën patahuaton, ya'huëhuano'sa nontapon pa'nin. Ya'huëhuano'saso', itiro'sa itopi. Hua'ano'sa nipisopita niyontoyantopiquë, quënanconin. Inaquë nontahuaton itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Caso co ya'huëhuancohuë' niporahuë', yacaparanquëma'. Sa'ahuë chiminin ni'ton, chiminpatamara nipo'moramaso' no'pa' pa'antoco canta topirahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Napotohuachina, Iti hua'ano'sari itapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Natanquë sinioro sha'huichinquën. Yosë huayoninquën ni'ton, quëmaso' chiníquën nanantëran. Nipo'moraiso' no'pa' insosona noya noya ni'nanquë, sa'anco' po'moquë'. Co incoi tëranta apiratarainquënhuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","8","Napotohuachinara, Apraanso huanirahuaton, itiro'sa nontaantacaso marë' mónsho tënin: —Tëhuënchachin isoporinquë sa'ahuëco' po'moca'huaso nohuantohuatama', catahuaco. Canpitari ya'huërënamëhuë Sohuaro hui'nin Ipron itopiso', nontoco topirahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Maquipiraquë nanin ya'huërinso', pa'anchinco. Inaso no'panën intonquë ya'huërinso'. Onposona pa'tërinso' no'tëquën pahuërëtarahuë. Inapohuato, chiminpatoi nipo'moca'huaiso marë' isoporinquë ya'huëtarinco huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ipronta Iti piyapi. Inanta inaquë chachin nisarin ni'ton, a'napita hua'ano'sa natantonënquë inaora chachin Apraan sha'huitërin. Chiníquën nonin ninano ya'coanataquëchin, na'huëpisopitanta', natanacaiso marë': ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Ama sinioro napoquësohuë'. Topinan naninso quëtaranquën. Inainpichin no'pa' ya'huërinsonta', quëchinquën. A'napitanta natantonënquë sha'huitaranquën. Napoaton sa'anco' po'moquë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Napotopirinhuë', Apraanso ya'huëhuano'sa inachintopiso nitotaton, anoyatarin. Naquëranchin ya'huëhuano'sa ni'tonënquë mónsho taantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","A'napitanta natantonënquë, Ipron itaantapon: —Natanquë api nontaanta'inquën topirahuë. Onpopionta no'pa marë' pahuërë' maquë'. Naporo huarë' sa'ahuëco' po'moarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","—Noya sinioro pa'. Ina no'paso', catapini pasa coriqui prata quëran nininso' pa'tërin. Canpoaso ma'huaënpoa ni'tëhua', co inaíchin marë' aquëtë huarë' nonsápaso ya'huërinhuë'. Napoaton, po'mochanquë sa'anco huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Napohuachina, Apraanso ina nápo marë' anoyatërin. Ina quëran Iti hua'ano'sa ni'tonënquë, no'tëquën pahuërëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Inapoaton Apraani, Ipron no'panën Maquipiraquë ya'huërinso', pa'anin. Ina no'paso', insina nararo Mamiriri hua'anëntërin quëran, pi'i pipirinso parti quëparitërin. No'pa', nanin, nararo'sa inainpichin ya'huërinso', inapita Apraani hua'anëntërin huachi. Iti hua'ano'sari ya'ipiya quëran nitotopi. Ninano ya'coanataquëchin na'huëpisopitanta', nitotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nani anoyatahuaton Apraanso', Maquipira naninquë sa'inco' po'morin huachi. No'pa' pa'aninquë napotërin. Ina no'paso' sha'huirahuëso chachin, Mamiriri hua'anëntërinso no'pa quëran, pi'i pipirinso parti quëparitërin. Ina ro'tëso', Ipron itopi anta'. Canaan parti ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ina pochin Apraan, no'pa', nanin, inapita pa'anaton, hua'anëntërin. Itiro'sari, pa'antërin nipa'pitacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Apraan nani noyá mashotërin huachi. Nani ma'sha nininquë Siniorori catahuamiatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","A'na tahuëri, piyapinën masho masho nininso', përarin. Inari ya'ipi ma'shanënpita a'pairin. Huë'pachina itapon: —Natëancoso nitota'huaso marë', tonaroana së'huatoco. Së'huatatonco: “Sinioroso Yosë ni'ton, inápaquë hua'anëntaton, isoro'panta hua'anëntërin. Ina ni'sárinco ni'ton, no'tëquën natëaranquën. Co isoporinquë Canaan sanapi nininso', Isaco macacaso ya'huërinhuë',” itoco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Quëma chachin hua'huatërahuëso no'paquë paquë'. Inaquë pa'sahuaton, quëmopinëhuëpita quëran sanapi yonítëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Napotohuachina, piyapinëniso itapon: —Napopiranhuë', sanapi yonirahuëso co yaimaquintahuachincohuë': ¿Onpochita? ¿Hua'huatëranso parti hui'nan quëpamanta'i ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Napotohuachina, Apraani itapon: —¡Ama napoquësohuë'! ¡Co inaquë quëpamantacaso ya'huërinhuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Sinioroso' Yosë ni'ton, inápaquë hua'anëntërin. Nani ina sha'huitërinco iso no'pa' shihuëpitari hua'nëntacaso'. Iráca tatahuë ya'huërin no'pa quëran ocoirinco. Quëmopinëhuëpita ya'huërin parti quëran ocoirinco huachi. Ocoirahuatonco isëquë quëninco. Inari chachin anquëninën a'pararin catahuainquënso marë'. Ina nohuanton, sanapi nohuantarin isëquë huëcacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Sanapi isëquë huëcacaso co nohuantohuachinhuë', naporo huarë' Yoscoarë' tënanso co na'intarinquënhuë'. Nipirinhuë' ama onporonta inatohua hui'nahuë quëpaquësohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Napotohuachina, piyapinëni Apraan tonaroananën së'huatërin. Së'huatahuaton: “Yoscoarë', sha'huitërancoso chachin, nisarahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Itahuaton, tapatarin huachi. Hua'anën ma'shanënpita, pa'ton pa'ton nininsopita, huayonahuaton, nicanatacaso marë' tapararin. Shonca camiyoquë apë'pëtahuatona', Nacoro ninano itopiquë, pa'pi huachi. Inaso ninano', Misopotamia parti ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pa'sápatona', canconpi huachi. Ninano aipiran, yatashirahuaso canconpi. Naporo oraquë nano'sa i'sha macapona posoquë huë'sapi. Apraan piyapinënso' camiyoro'sa a'na poso pirayan achinotarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Naporahuaton inaquë chachin Yosë nontërin: “Ni'quë Sinioro, quëmaso Yosënquën. Hua'anëhuë Apraan, natërinquën. Hua'anëhuë nosoroaton catahuaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nano'sa i'sha macapona huëcasoi', iso poso pirayan ninatapo. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Insoso nanon: ‘Yonshanën chinohuaraquë', canta pi'piyan i'sha o'opainquën,’ itohuato: ‘O'oquë api, camiyonënpitanta machi o'oina',’ ichinco. Ina quëran piyapinën Isaco marë' sanapi huayonanso', nohuitarahuë. Ina pochin nitohuachinco: Tëhuënchachin hua'anëhuë Yosëri nosoroaton catahuarin, tosarahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Orarinso' co tiquiyátërasohuë', a'nara nanon yonsha pitënahuaton, huë'sarin ni'nin. Inaso nanon, Pitoiro hui'nin. Nipica itopi. (Pitoiroso', sha'huirahuëso chachin Nacoro hui'nin. Miricaquë hui'nahuaninso'. Nacoronta Apraan iya'huain.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nipicaso', noyápiroyanchin. Naporahuaton nanon, co quëmapiri së'huayátërarinhuë'. Canquirahuaton posoquë nohuaramarin. Yonshanën amëntaitërinso pitënahuaton, panantapirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Apraan piyapinëni ta'arahuaton, icantonin. Icantahuaton, itapon: —Canta apia'hua, yonshanën quëran pi'pian i'sha o'opainquën topirahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","—O'oquë api, itërin Nipicari. Napotahuaton, yonshanën chinohuararin. Inapoaton o'shitacaso marë' së'quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nani o'opachina, Nipicari itapon: —I'sha maantarahuato, camiyonënpitanta o'opiquë ta'panchi nohuantopiso' o'oina', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Itahuaton, a'naromarëáchin pë'tahuaro'sa o'opiquë, ta'panarin. Ya'ipi camiyoro'sa', o'ocai huarë' inaporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Inapoaso', Apraan piyapinënso' co manta taponahuë', topinan ni'sárin: “Tëhuënchachin Sinioro catahuarinco ni'ton, ¿co topinan iratomaracohuë ti?” tënin yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Camiyoro'sa nani o'opachinara, Apraan piyapinënso', oro quëran po'moitëra pochin nipiso' manin. Saota cramo pochin quë'ninso'. Ina masahuaton, Nipica nitëananënquë a'tëntërin. Naporahuaton cato a'sontanpa oro quëran nipiso', quëtërin. A'naya a'naya pasa na'con cramo quë'ninso', quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","25","Inapita quëtahuaton, natanin: —¿Ma'ninta quëmaso' tata? —Caso tatahuë Pitoiro. A'shinso', Mirica itopi. Tata pa'pinso' Nacoro itopi. —¿Ya'huërin canpita pëinëmaquë chinota'huaiso to? —Ya'huërin mini. Camiyoro'santa capacaiso ya'huërin, itërin Nipicari. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","27","Ina natanaton, Apraan piyapinënso isonin. Isonin quëran Yosë chinotaton itapon: “¡Ma noyacha Sinioroso paya! Inaso Yosë, hua'anëhuë Apraan natërinso'. Tëhuënchachin hua'anëhuë nosoroaton, noya catahuaantarin. ¡Quëmopinënpita pëinënquë huarë' no'tëquën quëninco!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nipicaso' ta'arë'nachin a'shin pëinënquë pa'nin. Inaquë ya'ipi naporinso sha'huiontarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Nipicaso' a'na yo'in mashonën ya'huëtërin. Inaso', Napano itopi. Po'moitëra pochin nininso' oshin quëtopiso' nicaparin. A'sontanparinsopitanta', nicaparin. Sha'huirinsonta natanahuaton, Apraan piyapinën yonicaso marë' posoquë ta'amarin. Ina pirayan, camiyonënpitarë chachin huaniárin quënamarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Inaquë nontaton itapon: —Huëquë api. Quëmaso' Sinioro noya catahuarinquën. ¡Co aipiran quëparitamaso ya'huërinhuë'! Nani pëi taparahuë canpita marë'. Camiyoro'santa huë'ëcaiso', nani taparahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Napotohuachina, pëiquë pantapi huachi. Inaquë Napanori pë'pëtoro'sa chinohuararahuaton, camiyoro'sa a'carin. Apraan piyapinën, ca'taninsopitarë chachin nipa'morantëcaiso marënta', i'sha quëshirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Cosharo acotohuachinara, Apraan piyapinënso' tapon: —Co'huara coshachátërapohuë', ma'marësona huë'nahuëso'ton, sha'huita'huanquëmaso ya'huërin, tënin. —Ina'ton nipachin sha'huitocoi, itërin Napanori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","—Caso Apraan piyapinënco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Siniorori hua'anëhuë catahuamiatërin ni'ton, pa'pi notohuaro' ma'sha ya'huëtërin: Ohuacaro'sa', ohuicaro'sa', inapita notohuaro' pë'tahuarin. Naporahuaton oro, prata inapita ya'huëtërin. Piyapinënpitanta quëmapi'sa', sanapi'sa', inapita ya'huëtërin. Camiyoro'sa', moraro'sa', inapitanta na'a pë'tahuarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Naporahuaton sa'in Sara itopisonta', a'naíchin hua'huanin. Paiya nicaponahuë', quëmapi hua'huanin. Inari iporaso', ya'ipi hua'anëhuë ma'shanënpita, hua'anëntapon huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Hua'anëhuë camairincoso', natëca'huaso marë' nani Yoscoarë' ta'to sha'huitërahuë. Naporo' napotërinco: “Co isoporinquë Canaan sanapi nininso', Isaco macacaso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tatahuëi quëran quëmopi ninaisopita ya'huëpiso parti tëhuënchinso' paquë'. Inaquë pa'sahuaton, huëntonëhuë quëran chachin sanapi hui'nahuë marë' matomaquë',” itërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Napotohuachincora, cari itërahuë: “Quëmaso' hua'anëhuënquën nipiranhuë' nonchinquën: Pa'pato, co'so' sanapi yaimaquintahuachincohuë' ¿Ma'ta onpo'i?” itërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Napotohuatora, sha'huitërinco: “Ni'quë', caso Sinioro iranën no'tëquën pa'tërahuë ni'ton, anquëninën a'pararin catahuainquënso marë'. Ina nohuanton, noya pa'sahuaton sanapi quënamaran. Tatahuëi quëran quëmopinëhuë hui'nin chachin, hui'nahuë marë' matomaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Quëmopinëhuë co hui'nin yaa'pantihuachinquënhuë', naporo huarëáchin Yoscoarë' tënanso', co na'intarinquënhuë',” itërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Napoaton huë'sápatoi, ipora tahuëri posoquë canquirai. Inaquë Yosë nontato napotërahuë: “Sinioro quëmaso Yosënquën. Hua'anëhuë Apraan chinotërinquën. Ni'quë Sinioro. Tëhuënchachin quëma catahuararanco noya huë'nahuë nipachinso', ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","44","iso poso pirayan nontaranquënso' natanco. Apira sha'huitohuatënquën inachachin niin tënahuë. Inso nanonsona, i'sha macapon o'marinso', cari natanpato: ‘Canta pi'piyan yonshanën quëran i'sha o'opainquën,’ ichi. Napotohuato: ‘O'oquë api. Camiyonënpitanta machi o'oina',’ ichinco. Ina quëran hua'anëhuë hui'nin marë' sanapi huayonanso', nohuitarahuë,” itërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Orarahuëso', co tiquiyátërasocohuë', Nipica o'marin ni'nahuë. I'sha macacaso marë' yonshanën pitënahuaton, posoquë o'marin. Paaparahuato: “Canta api i'sha quëtoco topirahuë,” itërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Napotohuatora, yonshanën a'naroáchin chinohuararahuaton, itaponco: “O'oquë api, camiyonënpitanta machi o'oina',” itahuatonco, o'shitërinco. Camiyoro'santa', o'shitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ina quëran cari natanahuë: “¿Ma'ninta quëmaso' tata?” itërahuë. “Caso tatahuë, Pitoiro. Inaso', Nacoro hui'nin. Miricaquëya hui'nahuaninso',” itërinco. Itohuachincora, a'nara po'moitëra pochin nininso' nitëananënquë a'tëntërahuë. Naporahuaton cato a'sontanpacaso quëtërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ina quëran isonahuato, Sinioro chinotërahuë: “¡Ma noyanquëncha quëmaso' Sinioro paya! Quëmaso Yosënquën, hua'anëhuë Apraan natërinquën. Noya quënanco ni'ton, no'tëquën canquirahuë. Hua'anëhuë hui'nin acoantacaso marë' quëmopinën hui'nin chachin quëpatarahuë,” itërahuë, Sinioro chinotato. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Iporaso huachi, sha'huitoco nitochi. ¿Tëhuënchachin hua'anëhuë nosoroapoma ti? Co'so' nohuantohuatamahuë', sha'huitoco inanta nitochi. Nani nitotohuato ma'sona nica'huaso' yonquiarahuë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Napotohuachina, Napano, Pitoiro, inapitari itopi: —Ya'ipi naporansopita Sinioro nohuanton naporin tënai. Napoaton, so'yachin nipachin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ma'tana Nipica ya'huëarin. Siniorori ina pochin nohuantërin ni'quëhuarë', quëpaquë'. Hua'anën hui'nin so'yachin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Napopiso natanahuaton, Apraan piyapinënso isonin. Isonahuaton, no'paquë huarë' monshomarin: “Yosparinquën Sinioro,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ina quëran notohuaro' ma'sha quëninsopita o'quirin. Oro quëran, prata quëran, ina quëranpita nipiso', Nipica nicanarin. A'mocasonta', pa'ton nininsopita quëtërin. A'shin, yo'in, inapitanta notohuaro' ma'sha pa'ton nininsopita quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Naporo huarë' Apraan piyapinën, ca'taninsopitarë chachin, coshatopi, o'opi, napopi. Naporahuatona naporo tashi inaquë chinotopi huachi. Tahuëririnquë capayatahuaton, Apraan piyapinënso Nipica pa'pin, yo'in inapita itapon: —Ipora tahuëri hua'anëhuë ya'huërinquë yapaantarahuë ta'a, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Napopirinhuë', Nipica yo'inso a'shinë chachin, itapona': —Shonca tahuëri tëranta nanon quëparichin. Ina piquëran noya imasarinquën huachi topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Itopirinahuë', Apraan piyapinënso napoantarin: —Ama aquëtë huarë' ahua'quicosohuë'. Yosë nohuanton, noya huëcato, co topinan iratërahuë'. Napoaton hua'anëhuë ya'huërinquë pananta'huaso ya'huërin tënahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Napohuachina, itaantapi: —Pa'ahua nipachin nanon përahua'. ¿Ma'tama ichinpoa pa'? topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nipica përasahuatona', natanpi: —¿Ipora tahuëri chachin nohuantëran iso quëmapi imacaso to? itopi. —Nohuantërahuë mini, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Napohuachina, Nipica pacacaso nohuantopi huachi. Ina aso'sorinso sanapinta', a'pantopi. Naporahuaton a'napitanta piyapinënpita, sanapi'sa nininso' a'pantopi. Apraan piyapinën, ca'taninsopita, inapitanta noya a'papi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Nani yapa'pachina, yo'ini nóya yonquirapiton iso pochin sha'huitërin: “Oshira, Yosë catahuainquën. Pa'pi nohuantërai, noya hua'huanaton, notohuaro' amiparinpita ya'huëtiinquënso'. Naporahuaton amiparinpitanta', Yosëri catahuain inimiconënapita minsëra'piaina',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nani nontohuachinara, Nipicaso piyapinënpitarë chachin, camiyoro'saquë ya'mitëahuatona', Apraan piyapinën imapi. Ina pochin Apraan piyapinën, Nipica matomarahuaton, huënantarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","63","Naporo' Isacoso', Niquipi parti ya'huëarin. “Nanpiton ni'sárincoso' poso,” itopiquë Yosë yonquiapon pa'nin quëran, huënantárin. Nani yatashirapaso', a'nanaya ni'pirinhuë', ni'toro'sa camiyonënapitarë chachin canquirapi ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Nipicanta', Isaco ni'sahuaton, camiyonën quëran nohuararin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Nohuararahuaton Apraan piyapinën natanin: —¿Inta pasoso' quëmapi canpoataquëchin huë'sarin? itërin. —Ina mini Isaco. Hua'anëhuë Apraan hui'nin, itërin. Ina natanahuaton, Nipicaso niimomototërinso' në'mëtëquë, nipa'shinayatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Canconpachinara, piyapinëni ya'ipi naporinso Isaco sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ina quëran Isacoso', a'shinco në'mëtë pëinënquë Nipica quëparin. Co hua'quiya quëranhuë' macaton, noya cancantërin. Pa'pi nosoromiatërin. A'shin marë' sëtápirinhuë', inapoaton noya cancantërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Apraanso', a'na sa'in ya'huëtaantarin. Inaso', Sitora itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Inaquënta hui'nahuaantarin. Inaquë hui'ninpitaso': Simiran, Cocosan, Mitan, Matian, Isopa, Soa, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Cocosan hui'ninpitaso': Sipa, Titan, inapita. Titan quëran pipipisopitaso': Asororo'sa', nitosoro'sa', niomoro'sa inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Matian hui'ninpitaso': Ipan, Ihuiri, Anoco, Apitan, Iritan inapita. Ya'ipi inapitaso', Sitora quëran pipipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Na'a hui'ninpita Apraan ya'huëtopirinhuë', Isacoráchin pochin ya'ipi ma'shanënpita, quëtërin. Sitoraquë, Acaraquë hui'nahuaninsopitaso', pi'piyan pi'piyan ma'sha nicanarin. Naporahuaton, nanpiso chachin niquë a'parin. Pi'i pipirinso parti ya'huëcaiso marë' a'parin. Co nohuantërinhuë' Isacorë' napopináchin ya'huëcaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Apraanso ya'ipiya quëran, pasa canchisë shonca a'natërápo pi'i icanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nani noyá mashoya nipachina, mashori quëparin. Chiminpachina, shimashonënpita, quënancontarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Hui'ninpita: Isaco, Ismairo, inapitari, pa'pitopi. Maquipira naninquë po'mopi. Maquipiraso', sha'huirahuëso chachin, insina nararo Mamiriri hua'anëntërin quëran, pi'i pipirinso parti quëparitërin. Soaro hui'nin Ipron itopisoari, ina no'paso' hua'anëntopirinhuë'. (Inapitaso' itiro'sa'.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ina no'pa chachin iráca Apraan nanpipon itiro'sa', pa'antërin. Inaquë inanta', sa'inco' Sara itopiso' pirayan, po'mopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Apraan chiminpachina, Yosëri Isaco, catahuamiatërin. Inaso Nipicarë chachin: “Nanpiton ni'sárincoso' poso,” itopiso' pirayan, ya'huërapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sha'huitëranquëmaso chachin, Apraan Acaraquëya hui'nahuanpachina, Ismairo itopi. Acaraso', iquipitoron. Sara piyapinën. Ismairo hui'ninpitaso', isopita: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Paninantërinso' Nipayo itërin. Ina piquëran niantapisopitaso': Sitaro, Atipiri, Mipisan, Misma, Toma, Masa, Atar, Tima, Quitoro, Nahui, Sitima inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ina nápo Ismairo hui'ninpita ya'huëpi. Shonca cato ya'ipiya quëran. A'naya a'naya no'panëna hua'anëntopiso', niapora'piapi. Ya'huëpisonta inapotopi. Naporahuaton, inapitaso inahuara inahuara huëntonënaquë, hua'an ya'conpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismairo pasa cara shonca canchisë pi'ipitaso' chiminin. Chiminpachina, pa'pitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismairo quëran pipipisopitaso', Apira parti, Shor parti, inapita partiro'sari ahuancanapirin. Inaquë, no'pa' macatona ya'huëpi. Iquipito notënanquë ya'huëpi. Ina partitaquëchin Iquipito quëran, Asiriaquë ira pa'ninso' na'huërin. Iinpitari, co nohuantopirinahuë', inaquë no'pa' macatona', ya'huëpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iporaso Isaco naporinso sha'huichinquëma': Inaso', Apraan hui'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Catapini shonca pi'ipitaso', sa'arin. Pitoiro hui'nin Nipica itopiso', manin. Inaso yo'in, Napano itopi. Inapitaso' arano'sa itopi. Patan-aran parti ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nipicaso', co nanitërinhuë hua'huanacaso'. Ina marë' Isaco Sinioro nontërin. Napohuachina, nontërinso' natanahuaton, catahuarin ni'ton, Nipica cayorin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Catopia'huaya cayoaton, yo'namënquë niahuërapi natanin. Napoaton yonquirin. “Hua'huahuëpita iporaquëranchin niahuërapi ni'quëhuarë': ¿Ma'marëta aquëtë huarë' nanpiiso'?” tënin. Inapochin yonquiaton, Siniorori anitotacaso marë' nontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Natanpachina, Siniorori itapon: “Catopia'huaya cayoran. Inapita shinpita quëran cato nacion pipipon. Cato huënton nicatona', niahuërápona'. Ipora shimashonëna co'huara nasichátëraponahuë', niahuëpiso pochin nicapona'. A'nara chini chiníquën nanantapon. Naporahuaton hua'hua nininsoari masho masho nininso camairápon,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Napoin quëran, Nipica huaicaso nanirin. Catopia'huaya huairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Quëchitërinsoso' quëhuashin aina'huatahuaton, ya'ipi anporotërin. Napoaton Isao itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ina pa'taso chachin, iionta', a'na imirin quëran Isao matocanahuaton, hua'huataantarin. Naporinso marë' inaso', Cacopo itopi. Isaco saota shonca pi'ipitaso', hui'ninpita nasitapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Catopia'huaro'sa noya so'sopi. Isaoso' hui'napitahuaton, ma'sha yonicaso pa'yatërin. Míso inantërin. Cacoposo nipirinhuë', co inaporinhuë'. Ya'huëpiquë pa'yatërin ya'huápaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaoso', pa'pini na'con na'con pa'yatërin. Inantërinso capaton, napotërin. Ya'huërë' Nipicaso', Cacopo na'con na'con pa'yatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","A'na tahuëri Cacopo shantë a'itarin. Inapoaso Isaonta', inantapon pa'nin quëran, pa'pi canotërin huënantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Cacopo a'itërinso ni'sahuaton itapon: —Nosoroco iya, tana yatëparinco caso'. Quëhuashin cosharo anpiranso', canta quëtoco ca'i, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Napotohuachina, Cacopori itapon: —Paninanquën ni'ton, na'con ya'huëtarinquën canacamaso'. Carinquën nipachin ya'huërëchinquën. Naporo huarë' iso cosharo quëtaranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Napotohuachina, Isaoso' tapon: —Ni'quë iyasha, tana caso yatëpararinco. Chiminpatoso', paninan ninahuëso marë' cana'huaso' ya'huëtërincosopita, topinan quëran nisarin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","—Yoscoarë' quëtaranquën itoco nipachin, itaantarin Cacopori. Napotohuachina, “Yoscoarë' quëtaranquën,” itërin. Inapoaton, Isaoso paninan nininso marë' canacaso ya'huëtërinsopita, co pa'yatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Naporo huarë' Cacopori, pan acotahuaton, shantë a'itërinsonta o'huintërin. Nani ca'sahuaton, o'osahuaton, Isaoso' pa'nin huachi. Paninan nininso marë' canacaso ya'huëtërinso', co manta pa'tërinhuë pochin nitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Naporo tahuëri'sa Isaco ya'huërinso parti panca tanarotopi. Apraan nanpiso tahuëri'sa napopiso pochin, ninin. Napoaton sa'in, piyapinënpita, inapitarë chachin Quiraro ninanoquë pa'pi. Huiristino copirno, Apimirico itopiso ya'huërinquë pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Inaquë Siniorori ya'notahuaton, itërin: “Ama Iquipitoquë pa'maquësohuë'. Insëquësona quëparitacaso', carinquën sha'huitaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ipora marëso', iso no'paquë ya'huëtaco'. Carinquën ca'tanatënquën catahuararanquën. Ya'ipi iso no'pa', carinquën quëtaranquën. Shiparinpitanta', ina chachin quëtarahuë. Tataparin Apraan nani sha'huitërahuë ni'ton, quëtaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ca nohuanto quëma shiparinpita, na'amiatapona'. Tayoraro'sa pi'iro'tëquë ya'huërinso nápo, ya'huapona'. Inapitari ya'ipi iso no'paro'sa hua'anëntapona'. Naporahuaton, ya'ipi isoro'paquë naciono'sa ya'huërinsopitanta', shiparinpita quëran catahuararahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Apraanso': Ya'ipi sha'huitërahuësopita, camairahuësopita, pënënahuësopita, a'chintërahuësopita, ya'ipi inapita natërin ni'ton, napoarahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Siniorori napotohuachina, Quiraro ninanoquë quëparitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ya'huëhuano'sari Nipica ni'sahuatona', so'in natanpachinara: “Sa'ahuë,” ta'caso nipirinhuë', të'huaton nonpinin: “Oshihuë,” tënin. “Nipica noyápiroyanchin ni'ton, ya'huëhuano'sari macapona'. Ya'huërë' caso tëpaponaco,” ta'ton naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Hua'qui quëran pochin Apimiricoso', huintananën quëran notëtarin. Notëtapirinhuë', Isacori Nipica apinorarin quënanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Naporo' amatahuaton: —¡Nipicaso', sa'an tënahuë! Ina niponahuë': ¿Onpoatonta', “oshihuë,” tënan? itërin. —“Ina na'intërinco tëpaponaco caso',” ta'to naporahuë, itërin Isacori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Napopirinhuë', Apimiricori itapon: —¡Co napochitoncoihuë pora! Onpichin sa'an inso ya'huëhuani tëranta', ichihuë'ërin. Ina marë' quiyaso' oshahuaintoihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Napotahuaton, piyapinënpita camairin: —Inquëma tëranta iso quëmapihuë nipon, sa'inhuë nipon së'huahuatama', tëhuënchachin chiminarama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ina pi'iquë Isaco inaquë iminapatërin. Sha'tohuachina, Yosëri catahuarin ni'ton, pa'pi notohuaro' nitërinso' manin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Notohuaro' ma'sha ya'huëtahuaton, pa'pi ma'huan quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Pa'pi notohuaro' ohuicaro'sa', ohuacaro'sa', piyapinënpita, inapita ya'huëtërin. Ina marë' huiristino'sari noyapatona', no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","17","Napoin quëran Apimiricori Isaco itapon: —Quëmaso' quiya quëran na'con na'con ma'huanan ni'ton, pipiquë huachi, itërin. Napotohuachina Isacoso', sa'in, piyapinënpita, pë'tahuanënpitarë chachin pa'pi. Quiraro motopianaquë, pa'sahuatona', inaquë quëparitopi. Iráca Apraan nanpipon, ina piyapinënpitari posoro'sa ihuapiso', huiristino'sari amëntarotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Inaquë ya'huëapona pochin, naquëranchin ina posoro'sa ihuaantararin. Iráca pa'pincori nanpipon ihuapisopita, inapotaantapi. Ina chiminpachina huiristino'sari, amëntarotopirinahuë', ina posoro'sa chachin ihuaantarin. Iráca pa'pincori ina posoro'sa nohuitërinso chachin, inarinta nohuitaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","A'na tahuëri Isaco piyapinënpitari motopianaquë a'na poso ihuarapi. Ihuarapirinahuë', no'pa quëran i' pipirinso' quënanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Napoaponahuë', Quiraro motopianaquë, huiristino'sa ohuicanëna a'paipisopita, no'huitopi. Isaco ohuicanënpita a'paipisopitarë', nino'huitona niahuëpi: “¡Iso i'shaso', quiyaquën!” Niitatona', niahuëpi. Napoaton Isacori, apoyatërin: “Niahuëyatopiso' poso,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ina piquëran piyapinënpitari, a'na ya'huërë' ihuaantapi. Ina marënta', naquëranchin niahuëantapi. Inanta', Isacori apoyataantarin: “Niinimicotopiso' poso,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isacoso', sa'in, piyapinënpita, pë'tahuanënpita, inapitarë chachin, áquë pa'pi huachi. Inaquë a'na poso ihuantapi. Ina marëso' co huachi niahuëpihuë' ni'ton: “Cha'ëpisopita, posonën,” itërin. “Ipora tëhuënchinso' Sinioro nicha'ërinpoa noya noya isëquë ya'huëcaso marë'” ta'ton, ina pochin ina poso nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ina quëran, Piirsipa parti paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Naporo tashi Siniorori ya'notahuaton itapon: “Caso Yosëco. Tataparin Apraan chinotërinco. Ama të'huaquësohuë'. Carinquën ca'tanatënquën catahuamiataranquën. Piyapinëhuë Apraan natërinco ni'ton, ca nohuanton shiparinpita na'amiatapon,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Napotohuachina Isacoso', a'nara artaro inaquë ninin. Ina nisahuaton, Sinioro chinotërin. Inaquë ya'huapona pochin piyapinënpitari a'na ya'huërë' poso ihuaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","A'na tahuëri Apimiricoso', Quiraro quëran Isaco nontapon huë'nin. Aosato, Huicoro, inapitari ca'tanin. Aosatoso', amiconën. Huicoroso nipirinhuë', capitan, sontaronënpita camairinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Canquihuachinara, Isacori itapon: —Canpitaso co quë'yatomacohuë', ya'huërama quëran ocoiramaco. ¿Ma'marëta iporaso' yaniantaramaco? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","—Tëhuënchachin quëmaso', Sinioro catahuamiatërinquën ni'nai. Napoaton yonquirai quëmarë'coi anoyata'huaiso'. Iso pochin anoyatahua': ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Quiyaso ya'huëraiquë, co ma'sha onpotërainquënhuë', noya nicatëinquën, noya quëran a'parainquën. Napoaton quëmanta', ama ma'sha onpotocoisohuë'. Yosë quëmaso' ipora noya nicatënquën catahuarinquën ni'ton, napotarainquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Napotohuachinara, naporo chachin Isacori panca pita nitërin ni'ton, coshatopi, o'opi, napopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tahuëririnquë tashiramiachin, huënsëantahuachinara itohuara capini: “Yoscoarë' noya nini'tëhua' ya'huarihua',” nitopi. Ina quëran, nani anoyatahuatona': “Pa'sarai huachi,” topachinara, Isacori itapon: “Osharan paco', Yosë catahuainquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Naporo tahuëri chachin, Isaco piyapinënpitari huë'sahuatona', sha'huitiipi: “Poso ihuaráraiso', nani i'sha quënanai,” itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Napotohuachinara, Apimiricorë anoyatatona': Yoscoarë' niitopiso', yonquiaton, ina pososo' aninihuanin, “Sipa” itërin. Napoaton ina ninanoso', ipora Iso quirica ninshitasoco huarënta' Piirsipa itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isao catapini shonca pi'ipitohuachina, Cotita manin. Inaso', Piiri itopiso' hui'nin. Piiriso', Iti piyapi. Ina piquëran Isaoso', a'na maantarin, Pasima itopiso'. Inaso', Iron hui'nin. Ironta Iti piyapi chachin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ina catoro'sa co Yosë imatonahuë', Isaco, Nipica inapita na'con asëtatona', aparisitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaco noyá mashotohuachina, pëtorayataton co huachi quënantërinhuë'. A'na tahuëri hui'nin paninan Isao itopiso' përarin. Huë'pachina: —Conpa, itërin. —Ma'ta tata ya'huarahuë, itërin Isaori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","—Ni'quë conpa, nani caso mashotërahuë. Payo chiminapo huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Napoaton pë'chinanën, shinërënënpita, inapita masahuaton ma'sha yoníquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Nani tëpahuatan, costarincoso chachin po'morahuaton, quëshico ca'i. Ina quëran noya ya'huëcamaso marë' sha'huitaranquën huachi. Co'huara chiminyátërasocohuë', inapochinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Napoaponahuë', Nipicanta Isao napotërinso natanarin. Napoaton ina tananquë paaso chachin, a'naroáchin Cacopo përaton sha'huitërin: —¡Natanquë hua'hua sha'huichinquën. Nani iya masho tatari napotërinso' natayatërahuë! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Ma'sha yoníquë'. Nani tëpahuatan, costarincoso chachin po'morahuaton, quëshico ca'i. Ina quëran Sinioro ni'tonënquë chachin noya ya'huëcamaso marë' sha'huitaranquën huachi. Co'huara chiminyátërasocohuë', inapochinquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Napoaton noya natanquë sha'huichinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pë'tahuaro'sa ya'huërinquë pa'sahuaton, cato chipoa'hua noya noyatopiso' macontarahuaton quëshico. Cari, tata masho costarinso chachin po'mochi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nani anpitohuato, quëmari quëpatëquë ca'in. Inapotohuatan, quëma noya ya'huëcamaso marë' sha'huitarinquën huachi. Co'huara chimiyantërasohuë', inapochinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","A'shini napotopirinhuë', Cacoporiso itapon: —Iyahuëso anporohuan. Caso nipirinhuë', tomapico. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tatahuë së'huahuachinco, nohuitarinco. Nohuitatonco: “Cacopo nonpintarinco,” topachin, co inapotatoncohuë' ama huachi noya ya'huëca'huaso marëhuë' sha'huitarinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Itopirinhuë', a'shini itapon: —Co huachi noya ya'huëcamaso marëhuë' sha'huitohuachinquën hua'hua, ca marë' niin. Quëmaso sha'huitëranquënso chachin nicaton, cato chipoa'hua quëshico, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Cacoposo', macontarahuaton a'shin quëshirin. Tëparahuaton, inari Isaco costarinso chachin, po'motërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Isao noya noya a'morinsopita në'mëtë pëinënquë taparinsonta', manin. Inaquë Cacopo a'moantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Naporahuaton, chipoa'hua sha'huëtë quëran, tanpaquënpita, cononën, inapita achinpitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Inapotahuaton, po'morinso sënanquë o'huintërin. O'huintahuaton, panë chachin pa'pin quëtacaso marë' hua'huin quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Cacoposo', pa'pin ya'huërinquë ya'conahuaton, nontoonin: —¡Tata! itërin. —Ya'huarahuë conpa. ¿Inso hui'nahuënquënta quëmaso'? itërin pa'pini. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","—Ca mini Isaoco, paninantërancoso'. Nani sha'huitërancoso' quëshiranquën. Huënsëaton tata, ma'sha inanahuëso', ca'quë'. Ina piquëran noya ya'huëca'huaso marë' sha'huitoco huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Napotohuachina, Isacori natanapon: —¿Onporahuatonta conpa a'naroáchin quënan quënanaranso'? itërin. —Sinioro chinotëranso', inaso Yosë ni'ton, catahuarinco quënana'huaso', itërin Cacopori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pa'piniso nipirinhuë', itaantarin: —Ya'carico nipachin së'huainquën. Tëhuënchachin Isaonquën ninanso yanitotërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Napotohuachina, pa'pini së'huacaso marë' ya'caririn. Së'huarahuaton, tapon: “Isao pochin tanpaquënso' niponahuë', Cacopo pochin nohuianantërahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Isao tanpaquën pochin anporohuaninso marë' co nohuitërinhuë'. Napoaponahuë' co'huara noya ya'huëcaso marë' sha'huichátërasohuë', naquëranchin nataantarin: —¿Tëhuënchachin quëma Isaonquën? itaantarin. —Inaco mini, itërin Cacopori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Napotohuachina, Isacori itapon: —Acotoco nipachin conpa inantëranso ca'i. Ina quëran nani coshatohuato, noya ya'huëcamaso marë' sha'huitaranquën huachi, itërin. Napotohuachina, Cacoposo' pa'pin capacaso acotërin. Huinonta quëshirin. Isacoso', noya coshatahuaton, o'orin, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Inaporahuaton hui'nin itapon: —Ya'cariatonco conpa apinoco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Cacopori pa'pin apinocaso marë' ya'caritohuachina, Isacori a'morinso huë'ëropinën imërin. Naporo' noya ya'huëcaso marë' iso pochin sha'huitërin: “Naporin ta'a, ina pochin mini huë'ëropitëran. Siniorori catahuahuachina imin noya noyatërin. Napohuachina pimoanahuaninso pochin quëmanta huë'ëropitëran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yosë nontërahuë ina nohuanton o'nan ya'huëchinquën. Sha'tohuatan noya noya nitacaso marë' ya'huëchinquën. A'napita nitërinso' mapi quëran, noya noya maquë quëmaso'. Notohuaro' trico nitërinso' maquë capamaso'. Notohuaro' huinonta ya'huëchinquën o'ocamaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hua'huayátërahuë piyapi'sa camaiquë'. Naciono'santa të'huatatënën natëinënquën. Iyaparinpitanta camaiquë'. Të'huatatënën inapitanta natëinënquën. No'huitënën co huachi noya ya'huëcamaso marëhuë' sha'huitohuachinën, Yosërinta inapotarin. Inpitasona noya ya'huëcaso marë' sha'huitohuachinën, Yosërinta inapotarin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isacori, Cacopo noya ya'huëcaso marë' sha'huitërinso', tonitërin. Tonitohuachina, inaso pa'pin ya'huërin quëran pipirin. Pipiso chachin, Isaonta inantapon pa'nin quëran huëntararin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Huëntarahuaton, inantërinso po'mointarin. Anpirahuaton, pa'pin quëpataton, itapon: —Huënsëquë tata, inantërahuëso po'motëranquën ca'quë'. Capaton noya ya'huëca'huaso marë' sha'huitoco huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Napotohuachina Isacori natanin: —¿Inquënta quëmaso'? itërin. —Ca mini Isaoco, paninatërancoso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Hui'nin natanahuaton, Isaco pa'pi pa'yantërin. Pa'yanaton ropa ropátarin quëran itapon: —¿Inta nipachin apípora inantërinso po'morahuaton, quëshirinco? Co quëma canquiyátërasënquënhuë quëshirinco ni'ton, nani ya'ipi ca'nahuë: “Isao mini,” ta'to, nani noya ya'huëcaso marë' sha'huitërahuë. Ipora inaso', noya noya ya'huapon huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Pa'pin naporinso natanahuaton, Isaoso co napion cancantaton na'nëmiatërin. Na'nëton pa'pin nontërin: —¡Canta tata, noya ya'huëca'huaso marë' sha'huitoco! itërin ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Itopirinhuë', pa'pini itapon: —Iyaa'hua huë'sahuaton nonpintiirinco ta'a. Quëma pochin ancantato, noya ya'huëcaso marë' sha'huitërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","—¡No'tën chachin inaso', Cacopo itopi paya! ¡Nani catoro monararinco! Paninan ninahuëso marë' ya'huëtiincoso nininso'ton, matërinco. Iporanta', tatahuë noya ya'huëca'huaso marë' sha'huitiincoso' mataantarinco. ¿Co'tama canta', pi'piyan tëranta noya ya'huëca'huaso marë' sha'huitaponcohuë' to? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Napotohuachina, Isacori itapon: —Ni'quë conpa: Nani Cacopo sha'huitërahuë camairápainquënso'. Ya'ipi quëmopinënpita camairápaso marë' nani sha'huitërahuë. Hua'huayátërahuë, trico, huino, inapita ya'huëtacaso marë' Yosë nontërahuë. Inasá tiquiantërahuë ni'ton, ¡quëma marëso' capa huachi ta'a! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Itopirinhuë', Isaoriso chiníquën nontaantarin: —¿Iyayáchin noya ya'huëcaso marë' sha'huitacaso ya'huërin ti? ¡Canta onpopionta inapotoco! itërin. Napotahuaton chiníquën na'nëantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","40","Napohuachina, Isacori itapon: “Quëmaso nipirinhuë', noyaro'pa' aquëtë ya'huaran. O'nan pahuaninquë ya'huëapon. Noya ya'huëcaso marë' ahuëtápamaso ya'huapon. Iya'hua camairáponquën. Napoaponahuë', chini chiníquën nipatan, iya'hua quëran, pipiaran huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Naporo quëran huarë' Isaori Cacopo pa'pi no'huirin huachi. Inasá pa'pini noya ya'huëcaso marë' sha'huitërin ni'ton, naporin. Napoaton yonquirárin: “Payo tata chiminapon. Ina chiminpachin, Cacopo tëpaarahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Isao napo yonquitërinso', Nipicaso nitotërin. Napoaton Cacopo amatahuaton, itapon: —Ni'quë hua'hua. Iya masho, napotëranso marë' yatëparinquën natantërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Napoaton noya natanco sha'huichinquën. A'naroáchin Aran ninanoquë ta'aquë'. Api masho Napano pëinënquë paquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Inaquë paaton, hua'quimiachin yacapaontaquë'. Iya masho no'huitërinso' sanoquë huarë', inaquë ya'huëcontaquë'. Co huachi quënanpachinquënhuë', napotëranso' naniantapon. Naporo' huënantamaso marë' amataranquën. Co nohuantërahuë' naporo chachin catonquëma chiminamaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ina quëran Nipicaso', Isaco nontapon pa'nin: —Iti sanapi'sa Isaori maninso' co noyahuë' nipi ni'ton, chiminchináchin cancantërahuë. Cacopo ya'huërë' ina sanapi chachin, iso Canaan ro'tëquë ya'huërinso maantahuachin, chimina'huaso noya noya nisarin, tënahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Nipicari napotohuachina, Isacori, Cacopo amatahuaton, noya nontërin. Co no'huirinhuë'. Noya ya'huëcaso marë' sha'huitaton itapon: “Yosë noya catahuainquën conpa,” itërin. Napotahuaton pënënin: “Ama iso Canaan no'paquë sanapi máquësohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Patan-aran parti tëhuënchinso' paquë'. Tata masho Pitoiro ya'huërinquë pa'sahuaton, api Napano hui'ninpita a'nara maquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yosë ya'ipi nanitaparinso' catahuainquën. Na'a hui'nanpita quëchinquën. Quëmá quëran na'a naciono'sa pipicaso marë' inapochinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yosëri Apraan noya ya'huëcaso marë' sha'huitërinso chachin, quëmanta quëchinquën. Quëma shiparinpitanta', inachachin quëchin. Iso no'pa' ipora yacapatërëhuaso', quëchinquëma'. Yosëri nani Apraan sha'huitërin ni'ton, quëtarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ina pochin Isacori Patan-aran parti Cacopo a'parin. Cacoposo' pa'sahuaton, Napano ya'huërinquë canconin. Nani sha'huirahuëso chachin inaso', Pitoiro hui'nin. Pitoiroso' Aran piyapi. Napanoso', Nipica yo'in miáchin. Nipicanta', Cacopo, Isao, inapita a'shina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isaoso', pa'pini, Cacopo noya ya'huëcaso marë' sha'huitërinso' ni'nin. Patan-aranquë sa'acaso marë' a'parinsonta', ni'nin. Naporahuaton, pa'pini noya ya'huëcaso marë' sha'huitapon pochin: “Ama Canaan sanapi máquësohuë',” itërinsonta natanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Pa'pini, a'shini, sha'huitërinso chachin Cacoponta', Patan-aranquë pa'ninso' ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Pa'pin inaporin ni'ton, Isaoso': “Canaan sanapiso', co tatahuë costarinhuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Napoaton, Ismairo nicapon pa'nin. Inaso', Apraan hui'nin. Inatohua paaton, Ismairo hui'nin Maarata itopiso' maantarin. Inaso', Nipayo oshia'huain. Nani cato Canaan sanapi macaponahuë', inanta maantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","11","Cacopo Piirsipa quëran pipirahuaton, Aran ira pa'tërin. I'huatohuachina, quëparitërin huë'ëton pacacaso marë'. A'nara na'pi masahuaton, motoantacaso marë' acorin. Ina motoantaton huë'ërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Naporo tashi huë'ëton, hua'narin: A'nara nanpënan no'paquë paquërahuaton, Yosë ya'huërinquë huarë' nincanin ni'nin. Ina nanpënanquë chachin, pancatë ni'ton, Yosë anquëninënpita a'naquën pantarapi, a'naquënso o'marapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Naporahuaton, Sinioro chachionta', ina pirayan huaniarin ni'nin. Inari nontaton, itapon: “Caso Sinioroco. Quëmaquën Tata masho, Apraan itopiso' chinotërinco. Tata parionta chinotërinco. Quëhuëntëranso' no'pa' quëtaranquën. Shiparinpitanta', iso no'pa chachin hua'anëntapona'. Isoso no'pa', Canaan itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ca nohuanto shiparinpita na'amiatapona'. Mo'shi pochin na'apona'. Norti parti, sor parti, pi'i pipirinso parti, pi'i ya'coniniso parti, ya'ipi inapita parti hua'anëntapona'. Quëmá quëran, ya'ipi piyapi'sa nisha nisha nipisopita catahuararahuë. Shiparinpita quëraonta inapotarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ni'quë'. Carinquën ca'tanaranquën. Intópanta pa'patan, carinquën a'paiaranquën. Carinquën chachin iso no'paquë quënantaranquën. Co onporonta pataranquënhuë', ya'ipi sha'huitëranquënso' naniquë huarë' catahuararanquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Cacoposo' capayatahuaton, yonquirin: “Tëhuënchachin Sinioro isëquë ya'huëapirinhuë', co caso nitotërahuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Napoaton, pa'pi pa'yanin. Pa'yanaton tapon: “Iso ro'tëso', Yosë chinotacaso marë' nóya. Isëquë chachin, Yosë pëinën ya'huërin. Naporahuaton ¡Yosë ya'huërinso ya'coananën!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tahuëririnquë Cacoposo', tashíramiachin capayatahuaton na'pi motoantërinso manin. Masahuaton, nohuitacaso marë' onë pochin ahuanirin. Naporahuaton ina aipi toma opotërin. Inapotahuaton, Yosë marë' acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Inaquë chachin iráca a'na ninano ya'huërin. Noso itopiso'. Ina pochin nohuitopirinahuë', Cacopori nisha nininën acotaton, Pitiri itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Inaquë Cacopori Yosë sha'huitaton itapon: “Quëma chachin ipora iratërahuëquë ca'tanco. Quëma nohuanton cosharo', a'moca'huaso', inapitanta ya'huëchinco. Naporahuaton quëma nohuanton tatahuë ya'huërinquë, noya huënanta'i. Inapo catahuahuatanco: ‘Sinioroíchin Yosënëhuë,’ ta'to, chinotaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iso na'pi onë pochin ahuanirahuësonta', quëma pëinën nisarin. Naporahuaton, ya'ipi quëtëranco quëran, pi'pian quëtáponquën. Shonca canahuato a'nara quëchinquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Cacopo pa'sápaton, pi'i pipirinso parti ya'huëpisopita ya'huërinquë canconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ninano ya'cari', a'na poso quënanconin. Ina pirayan cara huënton ohuicaro'sa i'sha o'shitacaiso marë' achinotapi. Ina pososo', pancatë na'piquë a'tantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ya'ipi ohuica huëntono'sa niyontonpachinara, a'paipisopitari naní quëran yamotahuatona', chi'huincapi. Ohuicanëna o'shitacaiso marë' inapopi. Nani o'opachinara, naquëranchin inaquë chachin a'tantaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Cacopori a'paipisopita natanin: —¿Intoparanta canpitaso iyaro'sa'? itërin. —Aran quëran quiyaso' ta'a, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","—¿Nohuitërama canpita Nacoro hui'nin, Napano itopiso' to? taantarin Cacopo. —Nohuitërai mini, itaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","—¿Noya ya'huëarin? itaantarin. —Noya mini ya'huarin, itopi. Napotahuatona': —¡Ma'tana hui'nin Naquira itopiso' huë'sarin! Ohuicanënpitarë chachin huë'sarin, itaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Naporo' Cacopo tapon: —Yono pi'i ya'huëarin ni'ton, pahuanarin ohuicaro'sa huë'ërinquë oncorapicaso'. ¿Onpoatonta co o'shitatoma pasto capacaiso marë' quëpaantaramahuë'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","—Co nanitëraihuë' inapoca'huaiso'. Ya'ipi ohuica huëntono'sa a'paipisopitarë chachin niyontonacaiso' ninarai. Naporo huarë' nanitërai na'pi chi'huincatahuatoi, ohuicaro'sa o'shita'huaiso', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","10","Inapita nontaso', Naquiraso' pa'pin ohuicanënpitarë chachin canquirin. Inari pa'pin ohuicanënpita a'paitërin. Ina ni'sahuaton, Cacoposo' a'naroáchin posoquë pa'nin. Pa'sahuaton, na'pitë masho chi'huincatërin. Chi'huincatahuaton, apin ohuicanënpita o'shitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ina quëran Naquira apinorahuaton: “I'huata oshi,” itërin. Napotahuaton, na'nërarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Cacopori sha'huitërin: “Caso quëmaquën tata, apihuëmiáchin. Quëmaquën a'shacha Nipica itëramaso hua'huinco ni'to, naporahuë,” tënin. Ina natanaton, Naquiraso ta'arë'nachin pa'pin sha'huitapon pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Cantonahuaton sha'huitërin: “A'shacha Nipica hua'huin, Cacopo itopiso' canquirin,” itërin. Ina natanahuaton, Napanoso ta'arë'nachin nicapon pa'nin. Quënanconahuaton apinorin. Apinorahuaton: “I'huata api,” itërin. Nontahuaton pëinënquë quëparin. Inaquë Cacopori ya'ipi naporinso apin sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Napanori natanahuaton itapon: “Quëmaso' tëhuënchachin quëmopinëhuënquën ninan,” itërin. Cacoposo' Napano pëinënquë a'na yoquira' nani yacapatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ina piquëran Napanori itapon: —Quëmopinëhuënquën nipiranhuë', co topinan asacata'huanquënso ya'huërinhuë'. Sha'huitoco onposo canacamaso nohuantëranso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Napanoso' cato hui'ninpita nano'sa ya'huëtërin: Paninanso' Nia itopi. Ina piquëran niantarinsoso', Naquira itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Niaso', noyápiachin ya'pirahuanin. Naquiraso nipirinhuë', noyápiroyanchin, co máquën tëranta tëhuërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Cacoposo' Naquira costaton, apin itapon: —Hui'nan hua'hua nininso', Naquira itëramaso nohuantërahuë. Ina marë' canchisë pi'ipi quëma marë' sacatarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Napotohuachina, Napanori itapon: —Naporan ni'quëhuarë', quëmari maquë nipachin. Nishaso quëtacaso', co noyahuë'. Yacapatonco sacatëquë nipachin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Inapoaton Cacoposo' Naquira marë' canchisë pi'ipi sacatërin. Hua'qui sacatopirinhuë', Naquira pa'pi nosoraoton, cara tahuëriíchin sacatërinso pochin cancantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nani canchisë pi'i sacatohuachina, Cacopori Napano itapon: —Acoantoco huachi hui'nan. Sha'huitëranquënso' nani nanirahuë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Napotohuachina Napanoso' ya'ipi ya'huërin pirayan ya'huëpisopita, amatërin. Cacopo sa'arinquë pita nicacaso marë' amatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Napoaponahuë' nani tashihuachina, Napanoso Naquira ya'huërënamën Niasa', Cacopo acoantërin. Inaso co nohuitatonhuë', ichihuë'ërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Naporahuaton Napanori, a'nara piyapinën sanapi nininso Nia nicanarin. Camaicaso marë' nicanarin. Inaso sanapi Siripa itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tahuëririnquë tashíramiachin Cacoposo', Nia ichihuë'ërinso ni'nin. Ni'sahuaton, pa'pi pa'yantërin. Napoaton Napano chiníquën nontërin: —¡Co napochitoncohuë pora! ¡Co'ta Naquira marë' nani sacatërahuë! ¡Nani nonpintëranco ni'sora! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","—Isëquëso api, co hua'hua nininso'ton, aso'yaraihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nia mananso marë' a'na simana pita nicacaso ya'huërinso', naniquë'. Ina nanihuatan, Naquira ya'huërë' acoantaranquën. Canchisë pi'i chachin ca marë' sacatacaso' nohuantohuatan, inapotaranquën, itërin Napanori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Napotohuachina, Cacopo nohuantërin. Nia maninso marë' simana pita imapiso nanihuachinara, Napanori, Naquira ya'huërë' acoantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Napanori, a'nara piyapinën sanapi nininso' camaicaso marë' Naquiranta nicanarin. Ina sanapiso' Pira itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Nani acoantohuachina, Cacoposo', Naquira ichihuë'ërin huachi. Inapoaton ina na'con na'con nosororin. Niaso nipirinhuë', co onpopinchin nosororinhuë'. Canchisë pi'ipi chachin Napano marë' sacataantacaso' niponahuë', nosororin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Cacoposo', Nia co onpopinchin nosororinhuë'. Ina nitotaton, Siniorori catahuarin hua'huanacaso marë'. Naquiraso nipirinhuë', ina nohuanton chachin, co nito hua'huaninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Niaso', cayorahuaton quëmapia'huaya huairin. Inaso', Nopino itërin. “Sinioro sëtërahuëso' nicaton, catahuarinco. Hua'huanahuë ni'ton, iporaso' so'yahuë nosoroaponco huachi,” ta'ton, ina pochin hua'huin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Naquëranchin, cayoantarahuaton, quëmapia'huaya huaiantarin. Inaso', Simion itërin. “Nocaninacoso' Sinioro natanin. Natanaton catahuarinco. Napoaton a'na hua'huasha quëtaantarinco,” ta'ton, ina pochin hua'huin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Naquëranchin cayoantarahuaton, quëmapi chachin hua'huantarin. Inaso', Nihui itërin. “Nani cara hua'huanahuë ni'ton, iporaso' so'yahuë na'con na'con chinpitaponco huachi,” ta'ton, ina pochin hua'huin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Niaso', naquëranchin cayoantarahuaton quëmapia'hua chachin huaiantarin. Inaso Cota itërin. “Iporaso' huachi, Sinioro pa'yatato chinotarahuë,” ta'ton ina pochin hua'huin nohuitërin. Nani catapini hua'huanahuaton, copi tënin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Naquira co nito hua'huanatonhuë', cainpain noyaparin. Napoaton so'in itapon: —Hua'huantoco canta'. Co'so' hua'huantohuatancohuë', chiminarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Cacoporiso nipirinhuë', no'huiton itapon: —¡Co caso Yosëcohuë'! Ina co nohuantërinhuë ni'ton, co hua'huananhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Napotohuachina, so'in itapon: —Ni'quë'. Piyapinëhuë Pira itërëhuaso', maquë topirahuë. Ina mapatan hua'huanpachin, cari masarahuë. Hua'huahuë chachin nicacaso marë' masarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Inapoaton, Naquirari piyapinën Pira itopiso', so'in acoantërin. Acoantohuachina, ichihuë'ërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Piraso', cayorahuaton quëmapia'huaya huairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Naporo' Naquira tapon: “Isoso hua'huasha, Tano itarahuë. Yosë nontërahuëso' natanatonco: ‘Tëhuënchachin quëmaso' noya ninan ni'ton, catahuaranquën huachi,’ itërinco. Napoaton a'nara hua'huasha quëtërinco,” tënin. Ina yonquiaton ina pochin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ina quëran Pira cayoantarahuaton, quëmapia'huaya chachin huaiantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Naporo' Naquira taantarin. “Iso hua'huashaso', Nipitari itarahuë. Na'con caipayarë'co nichinitërai, iporaso huachi nani minsërahuë,” ta'ton ina pochin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Nianta co huachi hua'huanacaso nanitërinhuë'. Napoaton piyapinën Siripa itopiso' Cacopo acoantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","11","Siripa ya'huërë' cayoaton hua'huanpachina, Niaso tapon: “ ‘¡Ma noyacha nisharahuë paya!’ tënahuë. Napoaton iso hua'huashaso', Caro itarahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ina piquëran Siripaso', a'na ya'huërë' hua'huaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Naporo' Niaso' tapon: “¡Ma noyacha ya'huërahuë paya! Iporaso ya'ipi sanapiro'sa': ‘¡Ma noyacha inaso ya'huërin paya!’ itaponaco ta'to, iso hua'huashanta', Asiri itarahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Trico macacaso tahuëri'sa', Nopino pa'sahuaton, mantracora huayo itopiso' quënanconin. Ina masahuaton, a'shin quëshimarin. Ina quënapataton Naquirari itapon: —Hua'huan mantracora huayo quëshirinquënso', quëtoco canta topirahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Napotopirinhuë', Niari itapon: —Ayon caira. ¡Ama napopitëraquësohuë'! ¡So'yahuë nani osërëtëranco! Hua'huahuë ya'huërë' mantracora huayo quëshirincosonta' ¿yaosërëtaantamaranco ti? itërin. —Ina quëtohuatanco, ipora tashi Cacopo quëmarë' huë'ëpon, itërin Naquirari. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tashi huarë' Cacopo pasto quëran huënantahuachina, Niari nacapirahuaton: —Hua'huahuë mantracora huayo quëshirincoso', nani Naquira quëtërahuë. Quëmaro'co ipora tashi huë'ëca'huaso marë' inaquë pahuërëtërahuë, itërin. Napotohuachina, naporo tashi Niaso', Cacopo huë'ëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Hua'huanacaso marë' orarinso Yosëri natanahuaton, catahuarin. Napoaton Niaso', a'natërápo hua'huinpita nicacaso' cayoantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nasitohuachina tapon: “Isoso' hua'huasha, Isacaro itarahuë. Camairahuëso sanapi so'yahuë acoantërahuë ni'ton, Yosë acanarinco,” ta'ton, ina pochin hua'huin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ina quëran Nia cayoantarahuaton, saota nicacaso' hua'huaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nasitohuachina taantarin: “Iso hua'huashaso', Saporono itarahuë. Noya nininso chachin Yosë nicararinco. Nani saota hua'huasha a'notërahuë ni'ton, iporaso' so'yahuë noya noya ni'sarinco,” ta'ton, ina pochin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Nitiquioninquë Niaso', sanapia'huaya hua'huanin. Nasitohuachina, Tina itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Naquiraso co hua'huana'pihuë ni'ton, na'con Yosë nontërin. Napohuachina, napoiyan quëran nosoroaton a'panirin. Ina nohuanton hua'huanin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Paninantërinso' huaihuachina, tapon: “Co hua'huana'picohuë' nicato tapanápirahuë'. Yosë chachin catahuarinco ni'ton, hua'huanato co huachi tapana'huaso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A'na ya'huërë' Sinioro quëtaanta'inco topirahuë,” ta'ton, Cosi itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Cosi nasitërin piquëran Cacoposo', Napano itapon: —Ya'huërahuëquë chachin yapanantapirahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Sa'ahuëpita, hui'nahuëpita, inapita quëtoco. Nani inapita marë' sacatërahuëso' nanirin. Quëma nitotëran onpo sacatërahuësona ni'ton, quëpai huachi topirahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Napotopirinhuë', Napanoriso' itapon: —Ama napoquësohuë api. Quëma yacaparanco ni'ton, Sinioro catahuarinco. Ani'tato, ina nitotërahuë. Napoaton quëparitëquë tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Sha'huitoco onposona canacamaso nohuantëranso'. Nápo chachin pahuërë'inquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Napotohuachina, Cacopori itapon: —Quëma marë' onpo sacatërahuëso', nani nitotëran. Pë'tahuanënpitanta noya a'pairahuëso', nani nitotëran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Co'huara huë'shátërapohuë', caraíchin ya'huëtërinquën. Iporaso nipirinhuë', pa'pi notohuaro' na'amiatërin. Huë'nahuë quëran huarë' Sinioro catahuarinquën. Iporaso huachi canta', caora marë' sacata'huaso' nanirin huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","—Caquë chachin sacataantacaso marë' ¿onpota pahuërë'inquën? taantarin Napano. —Ama coriqui pahuërëcosohuë'. Apira sha'huitaranquënso' nohuantohuatan, quëma marë' sacataantarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ipora tahuëri pë'tahuanënpita huëntonënquë pa'sarahuë. Pa'sahuato, yaráton carniroa'huaro'sa', niquë acoarahuë. Naporahuaton chipoa'huaro'santa ninshipiton nipiso', niquë acoarahuë. I'coapi nipisopitanta inapotarahuë. Inapita quëran pahuërë' quënana'huaso marë' napoarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Inapohuato, a'na tahuëri canarahuëso ni'quihuatan, no'tëquën sacatërahuëso nitotaran. Pë'tahuatërahuëquë, i'coapiro'sa', ninshipitono'sa inaporáchin chiporo'sa quënanaran. Naporahuaton, yaráton carniro'saráchin quënanaran. Nisha quënanpatanso', ihuaranquën ni'ton, naporin, itërin Cacopori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","—Noyapa'. Inapoa'a nipachin, tënin Napano. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Napoaponahuë', naporo tahuëri chachin inaso chiporo'sa hui'tonpi nipisopita, i'coapi nipisopita, nisha acorin. Chipo sanapi'santa ninshipiton, nipiso', inaquë acorin. I'coapiro'sa', máquënso tëranta huiritopisopita, inapitanta inaquë chachin acorin. Ya'ipi yaráton carniroa'huaro'santa', inapotërin. Inapotahuaton hui'ninpitari a'paicaiso marë' quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ina quëran, pë'tahuaro'sa huayoninsopitarë chachin Napanoso', Cacopo ya'huëarin quëran, cara tahuëri iratatë pa'në'pa', pa'pi. Cacoposo nipirinhuë', co manta taponahuë', a'napita ohuicaro'sa Napanonquën a'paitarin. A'paitapon pochin canacaso marë' isoporin: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nara së'paro'sa huara napapiráchin nanpi së'patërinso' pë'shitërin. Isopita nararo'sa së'paquën napotërin: Aramo, ni'to', tanpapi, inapita së'paquën manin. Masahuaton, hui'tona'piarin. Hui'toninsopitanta', i'shotëra'piarin. Acopo huiritërinso ya'nocaso marë', inapotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Ina quëran huararo'sa hui'tonanpinan nininso', pë'tahuaro'sa huëntonën notënanquë acorin. I'sha o'opiquë acorin. Inaquë pë'tahuaro'sa nito'quëpi ni'ton, naporin. Huararo'sa notërahuatona quëmapi nipisopita to'quëtopi. Inapohuachinara hui'ninpitaso': Hui'tontono'sa', ninshipitono'sa', i'coapiro'sa', inapita hua'huatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Naporo' Cacoposo', inapita nisha acorarin huachi. Inapotërinso', Napano pë'tahuanënpita yaratono'sa', hui'tontono'sa', inapita notënanquë acoonin. To'quëcaiso marë' acoonin. Inapoaton Cacoposo', Napano pë'tahua huëntonën quëran na'apisopita, inaora huëntonënquë acoaton ana'atarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Panca panca pë'tahuaro'sa nipisopita huënaitohuachinara, i'sha o'opiquë huararo'sa acorin. Nito'quëapona pochin huararo'sa notëcaiso marë' naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mashiraa'huaro'sa huënaitohuachinaraso', co huararo'sa acorinhuë'. Napoaton pi'pira'huaya nipisopitaso', Napano marë' ninin. Ya'huërë' panca pancaro'saso', inaoranquën ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Inapoaton inaso', pa'pi ma'huanin. Pa'pi notohuaro' ohuica ya'huëtahuaton, piyapinënpitanta quëmapi'sa', sanapi'sa', ya'huëtërin. Notohuaro' camiyoro'sa', moraro'sa', inapitanta ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ina quëran Cacoposo', mi'sënpitari pinorinso' natantërin: “Cacoposo' tata pë'tahuanënpita matahuaton, pa'pi ma'huanin,” topi natantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Naporahuaton Napanori chachinta', co huachi iráca pochin nitërinhuë' ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Naporo' Siniorori Cacopo itapon: “Tataparin, quëmopinënpita, inapita ya'huërinso parti panantaquë'. Carinquën ca'tanatënquën catahuaranquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ina natanaton, Naquira, Nia inapita pastoquë amatërin. Inaora ohuicanënpita a'pairinquë amatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Huë'pachinara, itapon: —Tataparima co huachi iráca pochin noya ni'nincohuë'. Yosëso nipirinhuë', ca'tanatonco catahuarinco. Inaso' tatahuëri chinotërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Canpitaso', nani nitotërama tata marë' chiníquën sacatërahuëso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Naporahuaton nonpintahuatonco co no'tëquën pahuërërincosohuënta', nitotërama'. Napoaponahuë', Yosë catahuarinco ni'ton, co aquëtë huarë' ihuarincohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A'na tahuëri tataso' tënin: “Ninshipitono'sa quëchinquën sacatëranso marë',” topachina, ya'ipi sanapi ninshipitonáchin hua'huanpi. A'na tahuërinta': “Hui'tontono'sa quëchinquën sacatëranso marë',” taantahuachinaso', hui'tontono'sáchin hua'huataantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Yosë nohuanton ina pochin tata pë'tahuanënpita hua'huatopi. Canpoanquën nicacaso marë' napopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","A'na tahuëri pë'tahuaro'sa huënaitaso', hua'narahuë. Chipo mashoro'sari, chipo sanapi'sa to'quësapi hua'narahuë. To'quëtona'piro'saso', a'naquënso hui'tonpiro'sa', a'naquënso ninshipitono'sa', a'naquëonta i'coapiro'sa', inapita quënanahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Naporo chachin Yosë anquëninën përarinco: “¡Cacopo!” itërinco. Itohuachincora: “Isëquë nisarahuë,” itërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Naporo' anquëni itërinco: “Noya ni'quë', ya'ipi chipo mashoro'sa', chipo sanapi'sa to'quëpisopita, hui'tonpiro'sa', ninshipitono'sa', i'coapiro'sa', inapitaráchin to'quërapi. Napano nonpintërinquënso nitotato, ni'nanso chachin a'ninquënta nicacaso marë' catahuaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ca mini Yosëco, iráca Pitiriquë ya'notëranquën. Inaquë na'pi tomaquë opotahuaton, chinotaancoso marë' acoran. Naporahuaton inaquë chachin casáchin chinotaancoso marë' sha'huitëranco. ¡Manóton huëquë pa'a! Iso no'pa quëran pipirahuaton, hua'huatëranso no'pa parti panantaquë',” itërinco, tënin Cacopo. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ina topachina, Naquira, Nia, inapitari itapon: —Quiyanta mini tata chiminpachin, co huachi ma'sha tëranta maca'huaiso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Naporahuaton ipora chachin nisharo'sa pochin tata ni'nincoi huachi. ¡Pa'anpitërarincoi ni'ton, quiya marë' pahuërëtaton ina nápo sacatëran! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","No'tëquën chachin Yosëri, tata ma'shanënpita, matahuaton, canpoa quëtërinpoa'. Inaso' canpoanquën, hua'huanpoapitanquën. Napoaton, ma'sona Yosë sha'huitërinquënso', niquë huachi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Sa'inpitari napotërin ni'ton, Cacoposo Canaan parti panantacaso yonquirin. Pa'pin ya'huërinso no'paquë paantacaso marë' tapatarin huachi. Napanoso' a'na parti ohuicanënpita ya'iapon pa'nin. Inaquë pa'ninso' Naquirari, pa'pin mamanshinënpita ihuarin. Ya'ipi quëmopinënpitarë chachin mosharinso', ihuarin. Cacoposo' sa'inpita, hui'ninpita, inapita, camiyoro'saquë a'mitërin. Pë'tahuanënpita, ma'shanënpita, ya'ipi inapita quiquirin. Ya'ipi inapitaso', Patan-aranquë sacataton canarinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Inapoaton Cacopori, Napano nonpintahuaton, co sha'huitaponahuë' huëshirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ya'ipi ma'shanënpitarë chachin Cacoposo', ta'arin. Co hua'quiya quëranhuë', Iopiratisiiquë pëntoitahuatona', Carata motopiro'sa parti, notëëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Cara tahuëri quëran Napanoso', Cacopo ta'arinso' nitotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","24","Ina nitotaton, quëmopinënpitarë chachin, imaquirin. Canchisë tahuëri quëran, Carata motopiro'sa parti canquipi. Napoaponahuë', naporo tashi Yosëri huë'ënquë ya'notaton itapon: “Natanquë Napano sha'huichinquën. Ni'quëna Cacopo no'huiton ma'sha onpototan. Tananpitëquë pa'in,” itërin. Tahuërianpitahuaton Napanoso', ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","piyapinënpitarë chachin Carata motopiro'saquë Cacopo nincantopi. Ina motopiro'saquë inanta', huëntonënë chachin chinotopi. Napanonta ina motopiro'saquë chinotaponahuë', co niquënanyátërapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Cacopo quënanahuaton, chiníquën nontërin: —¡Pa'pi co noyahuë' ninan! ¡Co nonpinchitoncohuë' pora! Ahuëtahuatë sanapi'sa manëso pochin hui'nahuëpita quëshiaranco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nonpintatonco, co sha'huitaponcorahuë' ta'aiaran. ¡Co naporëhuë'! Ya'huëranquë yapaantaranso sha'huitëranco naporini, noya ninontatëhua capa cancanchitërihuahuë'. Pita nicatëhua': Tonton, arpa, inapita pi'nipiquë ninonchitërihuahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hui'nahuëpita, shihuëpitanta', ichita'airan ni'ton, co apinoto nonta'huaso' quëtërancohuë'. ¡Co manta yonquirëhuë pochin ninan! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nohuantërahuë naporini, ma'shátërahuë ya'ipinquëma ana'inchitënquëmahuë'. Napoaponahuë', achin tashi chachin Yosë nontërinco. Inaso' tataparionta chinotërin. Huë'ëhuëquë ya'notatonco nontërinco: “Natanquë Napano sha'huichinquën. Ni'quëna Cacopo no'huiton ma'sha onpototan. Tananpitëquë pa'in,” itërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tataparin ya'huërinquë ya'nipishahuë yapantaton huë'saran ni'quëhuarë', ¡co mamanshinëhuëpitaso' ihuatonco quëitonhuë' pora! itërin Napanori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Napotohuachina, Cacopori Napano itapon: —Të'huatatënquën topinan huë'sarahuë: “Paanta'huaso sha'huitohuatoso', sa'ahuëpita osërëtamarinco,” ta'to, naporahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nipirinhuë', insosona tëranta mamanshinënpita matahuatënquën, quësahuachin, ¡chimiin! Ma'sona tëranta quëmaquën nininso' quësahuato, ya'ipi quëmopinënpoapita ni'tonënquë a'noquë'. Inapotaton quëpamantaquë', itërin. Napopirinhuë Cacoposo', Naquirari pa'pin mamanshinënpita ihuarinso', co nitotërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Naporo' Napanoso', mamanshinënpita yoniton patë patë́rantarin. Cacopo në'mëtë pëinënquë'ton ya'conin. Pipirahuaton, Cacopo cosonanënpita nininquë, ya'coantarin. Nianquën nininquënta ya'conaponahuë', co mamanshinënpita quënaninhuë'. Ina quëran pipirahuaton, Naquiranquën nininquë ya'huërë' ya'coantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Naquiraso' mamanshiro'sa masahuaton, po'orin. Camiyoquë huënsëcaiso marë' nitopisoanaquë po'orin. Inapotahuaton, ina aipi huënsëtërin. Pa'pinso' ya'ipi në'mëtë pëianaquë yonípirinhuë', co quënaninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Naquirari itapon: —Tata, co huanirahuëso marëhuë', ama no'huicosohuë'. Sanapicoi inachintëraiso tahuëri nanitërinco ni'ton, huënsëárahuë, itërin. Napanori mamanshinënpita yonisápirinhuë', co quënaninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Co quënanpachinahuë', Cacopo ya'huërë' no'huitaton Napano chiníquën nontërin. —¿Maquëta tëhuëtëranquën ni'nan? ¿Ma'ta onpoato oshahuanahuë ni'ton, co napion cancantaton imaquirancoso'? ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ya'ipi ma'shanëhuëpita o'quiaton yoniran. ¿Ma'ta quënaparanco quëmaquën nininso'? Ma'sona quënanpatan, a'ninquëchin, quëmopinënpita notënanquë acoquë'. Quëmopinëhuëpitarinta', ni'in. Inapita sha'huichinpoa' insosona no'tëquën noninso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Cato shonca pi'i quëma marë' sacatërahuë. Naporo' co a'na ohuica tëranta', co a'na chipo tëranta ana'huarinhuë'. Huëntonënpita quëran, co a'na carniro tëranta', capitëranquënhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ni'niro'sari pë'tahuanënpita tëpahuachinara, co onporo tëranta a'nota'huanquënso marë' quëshiranquënhuë'. Caoranquën masahuato, acoantarahuë. Tahuërihuë nipon, tashihuë nipon, ihuatohuachinanta', ca apahuërëtëranco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tahuëri nipachina pi'i acorinco, tashinta nipachina sëhuën acorinco. Pë'tahuaro'sa a'paito, huë'ëi natanahuë. Inapoato nohuantaso' parisitërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Cato shonca pi'i quëma marë' sacatato, ya'ipi inapita ahuantërahuë. Cato hui'nanpita marë' shonca catapini pi'ipi sacatërahuë. Pë'tahuanënpita marënta', saota pi'i sacatërahuë. Naporahuaton, apira apira pochin nisha nisha cana'huaso sha'huitëranco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Apraan chinotërinso catahuarinco. Tata Isaconta', inachachin chinotërin. Co'so' ina catahuarincohuë naporini, topinamiáchin ya'huërahuëquë a'pa'itoncohuë'. Yosëso nipirinhuë', parisitërahuëso' nitotërin. Chiníquën sacatato ma'sha ya'huëtërincosonta', nitotërin. Napoaton achin tashi pënëninquën, itërin Cacopori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Cacopori napotohuachina, Napanoso' tapon: —Isopita catoro'saso', hui'nahuëpita. Isopita hua'huaro'santa shihuëpita. Pë'tahua huëntono'santa', caquën. Ya'ipi isëquë ni'nanso', caquënáchin. Napoaponahuë', hui'nahuëpita catahua'huaso marë' ya'ipi quëchi nipachin. Shihuëpitanta quëchi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Napoaton huëquë pa'a Yoscoarë' niitatë anoyata'a. Catonpo chachin anoyatërëhuaso ayonquiinposo marë' inapoa'a, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Napotohuachina, Cacoponta', “Noyapa',” tëcaton, a'nara na'pi manin. Ina masahuaton, onë pochin ahuanirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Naporo' quëmopinënpita camairin: —¡Na'piro'sa yontonco'! itërin. Itohuachina, ya'ipiya quëran na'piro'sa yontonpi. A'mitë a'mitëtahuatona', panca imopi. Ina quëran, ya'ipiya coshatopi, na'piro'sa a'mitë a'mitëtopiso pirayan coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Napanoso' inaora nanamënquë, ina ro'të nohuitaton, “Quicaro Saatota,” itërin. Cacoporiso nipirinhuë', inaora nanamënquë ina ro'të chachin, Carata, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Naporo' Napano tapon: —Iso na'piro'sa imorëso', catonpo chachin ayonquiarinpo Yoscoarë' ta'të ipora tahuëri anoyatërëso'. Napoaton, ina no'paso' ipora huanta Carata, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Naporahuaton Mispa itopi anta': “Nipatohuatë, co huachi niquënanarihuë'. Napoaponahuë', Sinioro chachin ni'inpo'. Co insonta ya'huërëquë naporëso ni'pirinpohuë', Yosë chachin ni'inpo'. Napoaton ama hui'nahuëpita no'huiton aparisitëquësohuë'. Ama aquëtë chachin sanapi'sa maantaquësohuë'. Ina marë' Yoscoarë' ta'ton sha'huitoco,” itërin. Ina naporinso marë' ina pochin ina no'pa' nohuitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Napanoso' aquëtë chachin Cacopo sha'huitaantarin: —Ni'quë'. Na'pi imorahuëso ya'huëarin. Onë pochin na'pi ahuanirahuësonta ya'huarin. Ya'huërëhuaso huáncana inapita acorahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Inapita ayonquiarinpo ama quëmanta ma'sha onpotancoso marëhuë', isëquëran pëntonquësohuë'. Co ca tëranta ma'sha onpota'huanquënso marë' isëquëran pëntona'huaso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Canpo capini nanan ya'huëhuachin, Yosë chachin anitochinpo', inquënposona tëhuërëso'. Ina Yosë chachin quëmaquën tata masho Apraan, chinotërin. Caquën tata masho Nacoronta chinotërin. Inquënposo tëhuëhuatë', ina chachin ana'inchinpo', itërin. Napotohuachina, Cacoposo': “Caquën tata chinotërinso ni'sárinco ni'ton, co napoarahuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Inapoatona anoyatohuachinara, Cacoposo inaquë chachin Yosë chinotacaso marë' ma'sharo'sa tëparin. Nani Yosë chinotohuachinara, quëmopinënpita ichicoshatërin. Ya'ipiya coshatopi. Nani coshatohuachinara, inaquë chachin huë'ëantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tahuëririnquë tashíramiachin Napanoso' huënsëintarahuaton, hui'ninpita, shinpita, inapita apinora'piarin: “Yosë catahuainquëma noya paco',” itahuaton ya'huërinquë pa'mantarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","2","Napano piyapinënpitarë chachin pa'mantahuachina, Cacoponta piyapinënpitarë chachin paantarin. Paasoi Cacoposo', Yosë anquëninënpitari nacapirin. Inapita quënanahuaton, tapon: “Isopitaso', Yosë sontaronënpita huënton. Catahuainacoso marë' a'paimarinso',” tënin. Napoaton ina ro'tëso': Maanain, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","4","Naporo' Cacoposo', comisiono'sa Isao sha'huitacaiso marë' Sëir no'paquë a'parin: “Iya'hua huënantárin ni'ton, iso pochin nanan a'patiarinquën: ‘Ca iya masho huënantárahuë. Ma'sona quëma camaitëranso nisarahuë. Cato shonca pi'ipi api Napano ya'huërinquë yacapatërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Na'a ohuacaro'sa', moraro'sa', ohuicaro'sa', inapita ya'huëtërinco. Piyapinëhuëpitanta', quëmapi'sa', sanapi'sa', ya'huëtërinco. Iso nanan, a'pataranquën noya ninicatë ya'huëantacaso marë' tënin,’ itoco',” itërin. Napotahuaton a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Comisiono'sa huënantahuachinara, Cacopo sha'huitiintapi: —Iya masho Isao nicapoi a'parancoi ni'toi, pa'nai. Huë'saranso nitotaton, inaora chachin nacapiinquënso marë' huë'sarin. Catapini pasa quëmapi'sari imaquiarin, itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","8","Ina natanahuaton, Cacoposo pa'pi pa'yanin. Pa'yanaton yonquirárin. Yonquirárin quëran, piyapinënpita, ohuicanënpita, ohuacanënpita, camiyonënpita, inapita cato huënton acorin. “Iya mashori, a'na huënton ahuëhuachina', a'na huëntonso ta'ararin,” ta'ton naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ina quëran iin të'huataton, iso pochin Yosë nontërin: “Sinioro, quëmaso Yosënquën. Tata masho Apraan chinotërinquën. Tata Isaconta chinotërinquën. Quëma sha'huitëranco ni'ton, ya'huërahuëquë huë'sarahuë. Quëmopinëhuëpita ya'huërinquë huë'sarahuë. Naporahuaton: ‘Ca nohuanton noya pa'saran,’ itëranco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tëhuënchachin co noyacohuë' ni'to, co nosoroancoso' ya'huërinhuë'. Co no'tëquënáchin catahuaancoso ya'huëpirinhuë'. Iráca ya'huërahuë quëran pipipo, Cortaniiquë pëntoitërahuë. Naporo' co ma'sha tëranta quëparahuë. Pitananëhuëro'coáchin pa'nahuë. Napopirahuë', iporaso' cato huënton pochin hua'anëntërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","¡Nosoroatonco Sinioro iya masho Isao quëran, nicha'ëco! Nani huë'sarin ni'ton, ahuërahuatonco, sa'ahuëpita, hui'nahuëpitarë'co chachin niquitohuachinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nani quëma chachin, catahuancoso marë' a'ninquëchin sha'huitëranco. Naporahuaton, shihuëpitanta caquëran pipipisopita, inotëra'huaya pochin na'acaiso' sha'huitëranco. Marë yonsanquë inotërahuaya ya'huërinso', co pichicasohuë'. Ina pochin na'acaiso' nani sha'huitëranco,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Naporo tashi inaquë Cacopo huë'ërin. Tahuëririnquë capayatahuaton, ya'cariya ya'huërinsopita quëran, pëtahuaro'sa huayonin. Iin masho Isao nicanacaso marë' huayonin: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","Cato pasa chipo sanapi, cato shonca chipo, cato pasa ohuica, cato shonca carniro, cara shonca camiyo paya nasha huaipiso hua'huinpitarë chachin, catapini shonca ohuaca', shonca toroa'hua, cato shonca mora sanapi nininso', shonca mora quëmapi, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Inapita huayonahuaton, piyapinënpita quëtërin a'na huënton a'na huënton quëpacaiso marë'. Co'huara pa'shátërasoihuë', ma'sona nicacaisonta sha'huitërin: —Canpitaso quëchitoco'. A'na huënton'ton pa'in. Amasha aquëmiachin nipachin a'na ya'huërë', paanta'in. Ama napopináchin pacosohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","18","Quëchinamën huënton quëpana'pi sha'huitërin: —Iya masho Isao nacapiatënquën natanpachinquën: “¿Inta quëmaso' hua'anën? ¿Intohuata pa'saran? ¿Inquënta pë'tahuaro'sa quëpaaranso'?” itohuachinquën, quëmari iso pochin sha'huitëquë': “Isopita pë'tahuaro'saso', quëma marë' quësarahuë. Cacopo a'patiarinquën. Inaso', quëma piyapinën pochin cancantërin. Nani inanta piquëran huë'sarin,” itëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","A'napita huënton quëpana'piro'santa', sha'huitërin: —Canpitanta iya masho Isao quënanpatama', inachachin sha'huitoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nani sha'huitohuatama', napotaantaco': “Inaora chachinso', piquëran huë'sarin,” itoco', itërin. Isopochin yonquiaton Cacopo naporin: “Isopita pë'tahuaro'sa quëtato no'huirincoso asanoarahuë. Ina piquëran caora chachin ni'sarahuë. Tapona inapotërahuëso marë' inanta noya nontaantarinco,” tënin yonquinënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Inapoaton Isao quëtacaso'ton, aquëchitërin. Inaoraso nipirinhuë', huë'ëcaso marë' ya'huëarinquëranchin quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Napoaponahuë', naporo tashi chachin co'huara huë'ëshátërasoihuë', Cacoposo' huanirin. Huanirahuaton, cato sa'inpita, cato cosonanënpita, inapita ayontonin. Shonca a'na hui'ninpitanta inaquë chachin ayontonin. Ayontonahuaton Capocoi' pëntoinantaquëchin, apëntoitërin. Ya'ipi pë'tahuanënpita, ya'ipi ma'shanënpita, inapitarë chachin aquëtëran a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Cacoposo' inaora quëparitohuachina, a'nara quëmapi ya'norin. Inarë tahuërianpitaquë huarë' nohuantaso' nipanipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Napoaponahuë quëmapi ya'norinsoso', co Cacopo minsëcaso nanitërinhuë'. Co nanitatonhuë', Cacopo tonaransën, ahuëtërin. Catantën nipaquëtërintaquëchin ahuërin ni'ton, notohuëtërin. Nipanisoi napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Quëmapi ya'norinsoso', Cacopo itapon: —A'poco huachi, nani tahuëririarin, itërin. —Co'so' noya ya'huëca'huaso marë' sha'huitohuatancohuë', co a'poaranquënhuë', itërin inarinta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","—¿Ma'ninquënta quëmaso'? itaantarin quëmapiri. —Cacopo itërinaco, taantarin inanta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Naporo' ina quëmapiriso' itapon: —Co huachi Cacopo itarinënhuë'. Ipora quëran huarë' Israiro itarinën. Yosë chinitëran, piyapi'santa chinitëran. Chinitaton canatëran ni'ton, ina pochin nohuitarinën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","—Iporaso' quëmanta' nininën sha'huitoco, itërin Cacopori. Napotopirinhuë', inariso itapon: —Co quëmaso' nininëhuë natanancoso ya'huërinhuë', itërin. Ina quëran inaquë chachin Cacopo noya ya'huëcaso marë' sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Napoaton Cacoposo' ina ro'të aninihuanin: “Pinoiro,” itërin. “Isëquë chachin, Yosë nirayarahuë. Ina niponahuë' co chiminahuë',” ta'ton, ina pochin ina ro'të nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Pi'i pipiriahuaso', Pinoiro quëran huë'sarin huachi. Catantëntaquëchin, tonaransë notohuëtërin ni'ton, sonpariarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Napoaton iso quirica ninshitasoco huarënta Israiro shinpitaso', ma'sharo'sa catantënquë pancarin ipatë ya'huëtërinso', co ca'pihuë'. Inaquë Cacopo ahuëpi ni'ton, co ca'pihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Cacoposo', Isao catapini pasa quëmapi'sarë chachin huë'sarin ni'nin. Ina ni'sahuaton, cara huënton hui'ninpita acorin. Niataquë a'na huënton, Naquirataquë a'na huënton, cosonaro'sataquë, a'na huënton. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Cosonaro'sa'ton hua'huinpitarë chachin aquëchitërin. Ina quëran Nia hua'huinpitarë chachin ahuancanatërin. Naquiraso', Cosirë' piquëran acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Inaporahuaton, Cacoposo quëchitërin. Iin masho ya'cariapon pochin, canchisëro mosharin. Isonin quëran no'paquë huarë' monshorahuaton mosharin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Cacoposo' të'huaton naporin. Napopirinhuë Isaoriso', ta'aquirahuaton iin iporin. Iporahuaton, apinorin, naporin. Cato chachin noya ancantatona', nina'nëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ina quëran Isaoso', sanapi'sa', hua'huaro'sa inapita ni'nin. Ni'sahuaton iin natanin: —¿Isopita po'? ¿Inpitata? itërin. —Hui'nahuëpita ta'a. Yosë nohuanton ya'huërinso', tënin Cacopo. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Naporo' cosonaro'saso hua'huinpitarë chachin, Isao huëcapaipi. Ina notënanquë huë'sahuatona', isonpi. Isonpi quëran no'paquë huarë' monshorahuatona', moshaipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ina quëran Nia ya'huërë' hua'huinpitarë chachin, inapoantapi. Piquëran Cosiso', a'shinë chachin, huë'sahuatona', Isao notënanquë inahuanta inapoantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ina quëran Isaoso', Cacopo natanin: —¿Ma'marëta ina nápo pë'tahua huëntono'sa a'paransopita, nacapirimarahuë? itërin. —Noya ninicatë ya'huantacaso marë' a'patëranquënsopita, itërin Cacopori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","—Ama iya'hua napoquësohuë'. Canta ya'huëtërinco chachin. Co quëtaancoso ya'huërinhuë', itërin Isaori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Itopirinhuë', Cacoposo' taantarin: —Ama iya masho napoquësohuë'. Tëhuënchachin noya ninicatë ya'huantacaso nohuantohuatan, onpopionta maquë ta'a. Quëmaora chachin noya nontaantarancoso' nicato, Yosë chachin napotërincoso pochin cancantërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Yosë nohuanton ma'huanahuë, co manta pahuantërincohuë'. Napoaton, quëshiranquënsopita, onpopionta maquë', itërin. Napotápaton Isao anohuantërin. Ya'ipi a'patërinsopita manin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ina quëran Isao taantarin: —Noyapa'. Huëquë nipachin carinquën ca'tainquën pa'a, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Napotohuachina, Cacoporiso itapon: —Tëhuënchachin iya masho nosoroatonco napotëranco. Nipirinhuë' hui'nahuëpita hua'huaro'saráchin. Ohuicaro'sa', ohuacaro'sa', inapitanta nasha hua'huatopiso ya'huërin. Manon quëpahuatëso', a'na tahuëri marëáchin nanitërin, ohuica'huaro'sa taquicaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Noya quëmaso' pataquë topirahuë. Quiyaso nipirinhuë' oshaquëranchin pacapoi. Hua'huaro'sapitarë'coi, pë'tahuaro'sapitarë'coi oshaquëran pa'sarai. Co hua'quiya quëranhuë', Sëir parti cantoontapatënquën, inaquë niquënaantarihua huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","—Noyapa'. Naporan ni'quëhuarë', quëchitota'i nipachin. Nipirinhuë' ca'tainquënso marë' caraya piyapinëhuëpita pachi, itërin. Itopirinhuë', Cacoposo taantarin: —Ama iya napoquësohuë'. Noya quiyaora pa'sarai, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Napotohuachina, Isaoso piyapinënpitarë chachin Sëir parti paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Cacoposo nipirinhuë', Socoto parti pa'nin. Inaquë pëitacaiso marë' piyapinënpita camairin. Naporahuaton, pë'tahuanënpita na'icaiso marë' tanpora'huaro'sa anitërin. Napoaton, ina no'pa' “Socoto” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Inaquë hua'quimiachin ya'huërin. Ina quëran Cacoposo', ya'ipi huëntonënë chachin Siquimo ninano notënanquë pa'nin. Inaquë në'mëtë pëiro'sa otëantarin. Inapoaton Patan-aran quëran huë'ninso', Canaan no'paquë noya canquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Në'mëtë pëiro'sa ótënpiso' no'pa', Cacoposo' pasa coriqui marë' pa'anin. Ina no'paso', a'na quëmapi Amoro itopiso' hui'ninpitari hua'anëntopirinhuë', pa'antërin. Inaso', a'nara hui'nin ya'huëtërin, Siquimo itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ina piquëran Cacoposo', Yosë chinotacaso marë' a'nara artaro ninin. Ina nisahuaton aninihuanin: Ir Iroi Israiro, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Cacopo hui'nin Niaquëya ya'huëtërinso', Tina itopi. Ina nanontohuachina, a'na tahuëri Siquimo ninanoquë nanon capini nini'cai marë' pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Inaquë ni'so', Siquimori ni'sahuaton noyarin. Inaso', sha'huitëranquëmaso chachin Amoro hui'nin. Amoroso', hua'an ya'conin. Ipo piyapi ni'ton, ya'ipi iporo'sa hua'anëntërin. Siquimori Tina co nohuanchachinpirinhuë' ichihuë'ërahuaton, po'orin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Napoaponahuë', pa'pi nohuantërin. Napoaton Tinari nohuantacaso marë' ma'pitaso ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Naporo chachin Siquimoso' pa'pin itapon: —Paaton tata, Tina maca'huaso marë' pa'pin nontoonquë'. Quëmopinënpitanta nontoonquë'. Ina pa'pi nohuantërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Cacoposo' hui'nin po'opiso' nitotaponahuë', co manta tëninhuë'. Hui'ninpita pë'tahuaro'sa a'pairapi ni'ton, co manta tëninhuë'. Inapita canquiai huarë' sha'huitacaso' yonquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Siquimo pa'pinso' Cacopo nontacaso marë' pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Cacopo hui'ninpita huënantahuachinara, napopiso' natantopi. Natantahuatona', pa'pi no'huitopi. Siquimori oshina co mashátëraponahuë', ichihuë'ërin ni'ton, napopi: “Inapoaton inaso', israiro'sanpoa panca tëhuëtërinpoa'. ¡Co onporonta inapocaso ya'huërinhuë'!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amoroso nipirinhuë', inapita nontaton napotërin: —Hui'nahuë Siquimo itërahuëso', oshiparima pa'pi nohuantërin macacaso marë'. Onpopionta quëtoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Inapoatëhua', ya'huëa'ahua topirahuë. Napohuatëhua', quiyanta canpita hui'nama macapoi. Canpitanta', quiya hui'nahuëi masarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Isëquë quëparitatoma', quiyapitarë' ya'huëco'. Iso no'paquë ya'huatoma sacatoco'. Nohuantëramaso' pa'anco'. No'panta yapa'anpatama', pa'anco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siquimonta huanirahuaton, nonsarin huachi: —Tata napotërinquëmaso', nohuantoco ta'a. Onposo' natanpatamaco quëtaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Sanapi marë' pahuërëtërë quëran na'con na'con apahuërëtohuatamaco noya, co ma'shahuë'. Naporahuaton ma'sona nicana'huanquëmaso' natanpatamaconta', quëtaranquëma'. Onpopionta cari mai, topirahuë, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Napopirinhuë', inapitariso oshina na'inin ni'ton, i'huërëtacaiso marë' yamonapi. Napoaton Siquimoso' pa'pinë chachin noyasha nontatona itapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","—Noya nipirinhuë'. Co quiyaso' nanitëraihuë' co marcahuan quëmapi oshihuëi quëta'huaiso'. Quëtërai naporini, quiya marëso' pa'pi taparo niitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ya'ipinquëma quiya pochachin marcahuanama huarë' canpita naporamaso nisarai. Nohuantohuatama', ya'ipi quëmapinquëma marca niacotoco nipachin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Naporo huarë' tëhuënchinso', canpitanta hui'nahuëi masarama', quiyanta canpita hui'nama masarai. Inapohuatëhua a'na huëntoínchin pochin nisarëhua huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nipirinhuë', co'so' nohuantohuatamahuë', isëquëran pipiarai. Oshihuëinta macatoi, quëpaarai, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Napotohuachina Siquimoso' nohuantërin. Pa'pionta nohuantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","20","Cacopo hui'nin pa'pi nohuantaton Siquimoso', a'naroáchin natëtërin. Inaso', ya'ipi Amoro hui'ninpita quëran chini chiníquën nanantërin. Napoaton, pa'pinë chachin ninano ya'coanaquë pa'pi. Inaquë ya'huëhuano'sa niyontonpi, ma'sha yonquiatona anoyatacaiso marë'. Ya'huëhuano'sa niyontonpachinara, itapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Pasopitaso' noyaro'sa'. Pancana no'pa' ya'huëtërinpoa ni'ton, inapitanta yacapatënënpoa' pa'anapona'. Canpoanta nanitarihua inahua hui'ninpita macacaso'. Ya'huërë' inapitanta canpoa hui'nanpoa nanitapi macacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Napoaponahuë' inapoatëhua ya'huëcaso marë', ya'ipi quëmapinpoa marcahuanacaso' nohuantopi. Inahua napopiso chachin canpoanta nicacaso' nohuantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Inapohuatëhua', ya'ipi ya'huëtopiso canpoanquën nisarin. Pë'tahuanëna', ma'shanëna', ya'ipi inapita canpoanquën nisarin. Huëco nohuantoco inapoa'ahua'. Napohuatëhua', inapitaso canpoarë' ya'huëcaiso marë' quëparitapi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Siquimo pa'pinë chachin napopiso natanatona', nohuantopi. Napoaton ya'ipi quëmapi'sa chiníquëno'sa nipiso', marca niacotopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Niacotopi quëran cara tahuëritapaso', Cacopo hui'ninpita Siquimo ninanoquë pa'pi. Simion, Nihui, inapita itopiso' pa'pi. Inapitaso', Tina yo'inamiáchin nipi. Ya'huëhuano'sa marca niacotopiso', pa'pi iquitopi. Inapoasoi chachin pa'sahuatona', sahuëninënaquë ya'ipi quëmapi'sa tëpaconpi. Co noyachátërasoihuë' ahuëtopi ni'ton, co chinitopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Amoronta', Siquimorë chachin tëpapi. Inapotahuatona', Siquimo pëinën quëran Tina masahuatona', pa'pi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","A'napita iinpitanta canquirahuatona', ya'ipi quëmapi'sa nani tëpapi ni'ton, ninanoquë ma'sha ya'huërinso mamiatopi. Oshina Siquimori tapirinso marë', i'huërëtatona inapotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ya'ipi ohuicanëna', ohuacanëna', moranëna', inapita matopi. Ya'ipi ninanoquë ya'huërinso', aipiraonta ya'huërinso', mapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Pëiro'saquë ma'sha ya'huërinsopitanta', ya'ipi ihuatopi. Naporahuaton ya'ipi hua'huaro'sa', sanapi'sa', inapitanta masahuatona quëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Simion, Nihui, inapita huënantahuachinara, pa'pinari itapon: —Canpitaso napoatoma', sacai anoyata'huaso nitëramaco. Canano'sa', huirisëro'sa inapitaso', ya'huëhuano'sa'. Naporamaso natantohuachina', no'huiponaco caso huachi. Nihuëntonahuatona ahuëaponaco. Caso co na'ashahuë' piyapinëhuëpita ya'huëtërinco ni'ton, ya'ipinpoa tiquiaponënpoa', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Napotopirinhuë', inapitariso itaantapi: —¿Monshihuantë paya pochin oshihuë nitacaso' nohuantopiranhuë' ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Naporo' Yosëri Cacopo huë'ënquë ya'notaton, camairin: “Caso Yosëco. Iráca iya masho Isao ta'ananpisën ya'notëranquën. Pitiriquë paantaton, inaquë ya'huëconquë'. Inaquë canconpatan, chinotaancoso marë' a'nara artaro niquë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Napotohuachina Cacoposo', ya'ipi hui'ninpita, sa'inpita, piyapinënpita, inapita camairin: —Ya'ipi nisha nisha mamanshiro'sa chinotëramaso', a'poco'. A'poatoma quëshico pa'pitahua'. Naporahuaton amarahuatoma', noya nininso i'nanpiraco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Manóton Pitiriquë pa'ahua'. Inaquë Yosë chinota'huaso marë' artaro nica'huaso ya'huërin. Iráca nanan ya'huëtaponco, Yosëso na'con catahuarinco. Naporahuaton, itohua itohua pa'nahuëquë, ca'tanatonco catahuarinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Napotohuachina, nisha nisha mamanshinëna moshapiso quëshipi. Pë'tëhuëratëro'santa moshapiso quëshipi. Ya'ipi inapita Cacopori Siquimo ninano ya'cari', pa'pitërin. A'nara insina nara pirayan, pa'pitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pa'pachinara, Yosë nohuanton, nisha nisha ninanoro'saquë ya'huëpisopita pa'pi të'huapi. Napoatona co nanitopihuë' Cacopo hui'ninpita, imatona i'huërëtacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Cacoposo' huëntonënë chachin, pa'sápatona', Noso ninanoquë canconpi. (Ina ninanoso', Pitiri itopi anta', Canaan parti ya'huërin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Inaquë canconahuaton, artaro ninin huachi. Inaquë Yosë chinotërin ni'ton, ina ro'të aninihuanin: “Iri Pitiri” itërin. Iráca iin të'huataton ta'ananpihuachina, inaquë chachin Yosëri huë'ënquë ya'notërin ni'ton, napo nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nipica piyapinën Tipora itopisonta chiminpachina, inaquë chachin pa'pitopi. Insina nara pirayan pa'pitopi. Pitiri ninano ya'cariya, inapotopi. Cacopori inanta aninihuanin: “Na'nëi' insina,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Cacopo Patan-aran quëran huënantahuachina, Yosëri naquëranchin inaquë ya'notaantarin. Ya'notaton noya ya'huëcaso marë' sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","12","Iso pochin sha'huitërin: “Quëmaso' Cacopo itërinën. Co huachi ina pochin nohuitarinënquënhuë'. Ipora quëran huarë' Israiro itarinën,” itërin. Ina quëran nininën canpiatahuaton itaantapon: “Caso Yosëco, ya'ipi nanitaparahuë. Notohuaro' hui'nanpita ya'huëchinquën. Shiparinpitanta', hua'huayátërahuë ya'huë'ina'. Quëmá quëran, a'na nacion pipipon. Naporahuaton, shiparinpitanta na'a huëntono'sa nicapona'. A'naquën shiparinpita, copirno ya'conapona'. Tata masho Apraan, tataparin Isaco, inapita iso no'pa' ahua'anëntërahuë. Ina chachin quëmanta quëchinquën. Shiparinpitanta iso no'pa chachin hua'anëntapona',” itërin Yosëri. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Napotahuaton pa'pachina, Cacoposo' a'nara na'pi masahuaton onë pochin ahuanirin. Yosëri nontërintaquë chachin ahuanirin. Ina quëran toma', huino, inapitaquë opotahuaton, Yosë marë' acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Iráca nohuitërinso chachin ina ninanoso', Pitiri itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","17","Hua'quimiachin inaquë ya'huërapi quëran paantapi. Pa'sápatona', Iporata ninanoquë ya'caritopi huachi. Inaquë Naquiraso', pa'pi parisë quëran huaiton, co'chachin ninin. Napoaso ahuaitona'piri itapon: “Ama pa'yanquësohuë', quëmapi chachin huaiyantaran,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Napotopirinhuë', Naquiraso' yachiminin huachi. Nani yachiminahuaso', hua'huin nininën acotërin: Pin-oni itërin. Itopirinhuë', Cacoporiso', Mincamin itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Inapo chimintërin Naquira. Napoaton Iporata ira pirayan pa'pitopi. (Iporataso ipora marë', Pirin itopi.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Naquira pa'pitahuaton, po'oronën aipi Cacoposo' Panca ra'pi ahuanirin. Ina na'pi ahuanirin quëran, Naquira po'oronën nohuitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Inaporahuaton, Israiroso paantarin. Itiri tori aquëcha, ya'huaantacaiso marë' në'mëtë pëinëna ótëënpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Inaquë hua'quimiachin ya'huëpi. Inaquë chachin Nopinoso', pa'pin cosonanën Pira itopiso monshitaton, ichihuë'ërin. Ina natantahuaton, Israiroso pa'pi no'huitërin. Cacoposo' shonca cato hui'ninpita quëmapi'sa ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Niaquëya nipisopitaso' isopita: Paninanso' Nopino, ina quëran, Simion, Nihui, Cota, Isacaro, Saporono, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Naquiraquëya nipisopitanta isopita: Cosi, Mincamin, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Naquira piyapinën Pira itopisoquënta isopita: Tano, Nipitari, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Nia piyapinën Siripa itopiquënta', isopita: Caro, Asiri, inapita. Ina nápo Cacopo hui'ninpita ya'ipiya quëran ya'huëpi. Ya'ipi pochin Patan-aranquë nasitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","A'na tahuëri Cacoposo' pa'pin ya'huërinquë pa'nin. Inaso', Mamiriquë ya'huërin. Ina ninanoso' Arapa itopi anta'. Naporahuaton ina chachin Ipron itomantapi. Inaquë Apraan, Isaco, inapita ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Pasa posa shonca pi'ipitaso', Isaco chiminin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Noyá mashoya nicaquë huarë' chiminin. Chiminpachina, hui'ninpita Isao, Cacopo, inapitari nipa'pichantopiso' naninquë po'mopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Isao quëran pipipisopita sha'huichinquëma'. Inaso', Itomo itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","5","Isaoso' Canaan sanapi'sa manin: A'naso', Ata itopi. Inaso', Iron hui'nin. Ironta', Iti huënton piyapi. Inaquëya Isao hui'nahuanpachina, Iripasi itërin. A'na sa'ionta Aoripama itopi. Inaso', Ano hui'nin, Sipion shiin. Inaquëyanta hui'nahuanpachina, isopita: Quiosi, Caaran, Cori, inapita. Isaoso', Ismairo hui'nionta manin, Pasima itopiso'. Inaso', Nipayo oshia'huain. Inaquënta hui'nahuanpachina, Niohuiro, itërin. Ina nápo hui'ninpita Canaan parti ya'huëapon nasitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isaoso' Cacopo patahuaton, a'na parti ya'huapon pa'nin. Sa'inpita, hui'ninpita, yaipi inarë ya'huëpisopita quëparin. Pë'tahuanënpita, ma'shanënpita, inapita Canaan parti ya'huapon pochin canarinsonta', ya'ipi quiquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Cacoponta', napopin chachin ma'huanin ni'ton, co huachi nanitopihuë inaquësáchin ya'huëcaiso'. Pastonta pë'tahuanëna capacaiso co huachi nanipihuë ni'ton, nia'popi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Inapoaton, Isaoso Sëir motopiro'sa parti pa'nin ya'huapon. Sha'huitëranquëmaso chachin Inaso', Itomo itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ina nápo Isao hui'ninpita ya'huëtërin. Inaso', ya'ipi itomoro'sa shimashonën. Inapitaso', Sëir motopiro'sa parti ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Sha'huitëranquëmaso chachin, Isaoso Ataquëya hui'nahuaninso', Iripasi itërin. Ya'huërë' Pasimaquëya nininso', Niohuiro itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Iripasi hui'ninpitaso', isopita: Timan, Omaro, Sipo, Catan, Quinasi, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Inapitaso' Ata aminpita. Iripasiso', a'na cosonanën ya'huëtërin Timona itopi. Inaquëya hui'nahuanpachina, Amarico itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Niohuiro hui'nipitanta', isopita: Naato, Siran, Sama, Misa, inapita. Inapitanta Pasima aminpita. Pasimaso' sha'huitëranquëmaso chachin, Isao sa'in ninin anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aoripamaquënta', Isao hui'nahuaninsopitaso': Quiosi, Caaran, Cori, inapita. Aoripamaso', Ano hui'nin, naporahuaton Sipion shiin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","19","Isao shinpita huëntono'sa hua'anëntopisopitaso', isopita: Timan, Omaro, Sipo, Catan, Quinasi, Cori, Amarico, inapita. Sha'huitëranquëmaso chachin Isao paninanënso', Iripasi itopi. Ina hui'ninpitaso', Itomo no'paquë Isao shinpita huëntono'sa', hua'anëna ya'conpi. Ya'ipi inapita Ata aminpita. Niohuironta Isao hui'nin chachin ninin. Ina hui'ninpitanta', isopita: Naato, Siran, Sama, Misa, inapita. Inapitanta Itomo no'paquë Isao shinpita huëntono'sa', hua'anëna ya'conpi. Ya'ipi inapitaso', Pasima aminpita. Sha'huitëranquëmaso chachin Ano hui'nin Aoripama itopiso hua'huinpitanta', isopita: Quiosi, Caaran, Cori, inapita. Inapitanta Isao shinpita huëntono'sa hua'anëna ya'conpi. Ya'ipi ina hua'ano'sa', Isao shinpita. Isaoso', Itomo itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Co'huara Isao inaquë pa'shátëraponhuë', a'nara Or huënton piyapi Sëir itopiso'ton inaquë ya'huërin. Quëmopinënpitarë chachin ya'huërin. Ina hui'ninpitaso', isopita: Notan, Soparo, Sipion, Ano, Tison, Isëri, Tisan, inapita. Inapita'ton Itomo no'paquë Or huënton hua'ano'sa ya'conpi. Inapitaso' Sëir quëran pipipisopita ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Notan hui'ninpitaso', isopita: Orin, Iman, inapita. Notan oshinso', Timona itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Soparo hui'ninpitanta', isopita: Arapan, Manaato, Iparo, Sipo, Onan, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sipion hui'ninpitanta isopita: Aiya, Ano, inapita. Ina Ano chachin, inotëro parti pa'pin moranënpita a'pairin. Inapita a'paiaso', no'pa quëran i'sha pipirinsopita quënanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anoso', a'na hui'nin ya'huëtërin, Tison itërinso'. Naporahuaton, a'na hui'nin sanapi, ya'huëtërin. Sha'huitëranquëmaso chachin inaso', Aoripama itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Tisonta hui'ninpita isopita: Intan, Ispan, Itëran, Quiran, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Isëri hui'ninpitanta isopita: Piran, Saapan, Acano, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tisan hui'ninpitanta isopita: Osi, Aran, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Or huënton hua'ano'saso', isopita: Notan, Soparo, Sipion, Ano, Tison, Isëri, Tisan, inapita. Ina nápo Or huënton hua'ano'sa ya'huëpi. A'naya a'naya huëntonënaquë, hua'an ya'conpi. Sëir parti napopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","32","Co'huara israiro'sa copirno ya'huëchatërasoihuë', isopita'ton Itomo no'paquë copirno ya'conpi. Pira'ton ya'conin. Inaso', Pioro hui'nin. Tinapa ninanoquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ina chiminpachina, Sira hui'nin Copapo itopisori ya'huërëtërin. Inaso', Posora ninanoquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Inanta chiminpachina, Osamori ya'huërëtërin. Inaso', Timan parti ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Osamonta chiminpachina, Atatori ya'huërëtërin. Inaso', Pitato hui'nin. Apito ninanoquë ya'huërinso'. Inari matiano'sa', Moapo no'paquë ahuëaton canarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Atato ya'huërë' chiminpachina, Samarari ya'huërëtërin. Inaso', Masarica ninanoquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samaranta chiminpachina, Saonori ya'huërëtërin. Niopo ninanoquë ya'huërinso'. Inaso ninano', Iopiratisii' yonsanquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ina ya'huërë' chiminpachina, Paaro-ananori ya'huërëtërin. Inaso', Acaporo hui'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Paaro-ananonta chiminpachina, Atatori ya'huërëtërin. Inaso', Pao ninanoquë ya'huërin. Atato sa'inso', Miitapiri itopi. Inaso', Matiriti hui'nin, Misaapo shiin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Isonápo Isao quëran pipipisopita huëntono'sa ya'huërin: Ya'huëpiso no'panënanta', inachachin aninihuanpi: Timon, Arapa, Quitito, Aoripama, Iran, Pinon, Quinasi, Timan, Mipasar, Maquitiri, Iramo, inapita. Ina nápo Itomo huëntono'sa shimashonënpita ya'huërin. Inapitaso' Itomo no'paquë yanquëatona itohua itohua ya'huëpi. Isaoso', Itomo itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Cacoposo nipirinhuë', Canaan parti quëparitërin ya'huëcaso marë'. Pa'pinconta' inaquë chachin ya'huëaponahuë', co hua'quiyahuë' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Cacopo hui'ninpita naporinso sha'huichinquëma nitotoco'. Cosi shonca canchisë pi'ipitapon pochin, iinpitarë chachin pa'pin ohuicanënpita a'pairin. Pa'pin cosonanënpita: Pira, Siripa, inapita hua'huinpitarë' a'pairin. Iinpitaso co noyahuë' nipi ni'ton, Cosiso' pa'pinquë yásha'huirapirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Cacoposo' a'napita hui'ninpita quëran, Cosi na'con na'con nosororin. Nani másho nicaquë huarë', Cosiso hua'huatërin ni'ton, nosoromiatërin. Napoaton a'mocaso marë' noyápiachin nininso' nitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iinpitariso nipirinhuë', pa'pini ina na'con na'con nosororinso' nicatona', co quë'yapihuë'. Co quë'yatonaraihuë', co nanitopihuë' noya nontacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","A'na tashi Cosi hua'narin. Tahuëririnquë, iinpita sha'huitërin: —Natanco iyaro'sa hua'narahuëso sha'huichinquëma': Huë'ëhuëquë, iminquë ya'ipinpoa trico masarëhua'. Manëhuasonta tonporarëhua ni'nahuë. A'nanaya ca tonporahuësoso', huanirin. Canpita tonporamasoso nipirinhuë', ca tonporahuëso' mosharapi. Ya'ipi tahuitatona', monshopi quëran mosharapi, itërin. Ina natanahuatona', iinpitariso aquë aquëtë no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Napohuachina, inapitari itapon: —Hua'an ya'conpato iyahuëpita camaiyápo ¿tocomaranquën ti? ¡Catoro' quëma camaiyáponcoi! itopi. Hua'narinso marëpita na'con na'con no'huipi. Sha'huihuachina, co yainhuë' natanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ina piquëran Cosiso', hua'naantarin. Naporonta iinpita sha'huitaantarin: —Natanco iyaro'sa a'na hua'naantarahuëso sha'huitaanta'inquëma'. Hua'nato ni'pirahuë', pi'i, yoqui, shonca a'na tayoraro'sa', inapita monshorahuatona moshararinaco ni'nahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Cosi ina hua'narinso', pa'pin iinpita inapita sha'huitohuachina, pa'pini pënënaton itapon: —¿Ma'ta tapon inapochinpita hua'na hua'namantaranso'? Napoahuarë' mamaparin, iyaparinpita, ca chachionta' ¿a'na tahuëri moshaponquën ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Iinpitariso noyapatona', aquë aquëtë no'huirápi. Pa'pinso nipirinhuë', hui'nin naporinso na'con yonquirárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","A'na tahuëri Cosi iinpitaso', Siquimo ninano ya'cari pa'pi. Pa'pina ohuicanënpita, chiponënpita inapita quëpapi pasto yonitona a'cacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Naporo' pa'pini Cosi itapon: —Ni'quë conpa. Iya mashoro'sa Siquimo ya'cari ya'huëapi. Inaquë ohuicaro'sa', chiporo'sa', inapita a'pairapi. Paaton ni'contaquë topirahuë, itërin. —Noya tatapa'. Pa'i nipachin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","—Inta conpa. Pa'sahuaton iyamashoro'sa ni'contaquë'. Ohuicaro'sa', chiporo'sa', inapitanta onpoinsona nisapiso', nahuicontaquë'. Ina quëran huë'sahuaton, onpoapisona sha'huitiico canta nitochi, itërin. Cacoposo Ipron motopianaro'sa quëran, Cosi a'parin. Inaso pa'sápaton Siquimoquë canconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ina parti chihuëaton pa'sápirinhuë', a'na quëmapiri quënanahuaton itapon: —¿Ma'ta yonisaran? ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","—Iyahuëpita yonisárahuë ta'a. ¿Co pora nitotëranhuë' insëquësona pë'tahuanëna a'paiyapiso to? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","—Nani isëquëran pa'pi: “Totanquë pa'ahua',” niitapi pora, itërin. Cosiso pa'sápaton, Totan ninano ya'cariya iinpita quënanconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Inapitarinta', áquë quëran Cosi quënanpi. Quënanahuatona', co'huara ya'carichátërasohuë', tëpacaiso marë' a'naroáchin yonquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Inahua capini ninontopi: —¡Ni'co'. Hua'natona'pi huë'sarin! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Huëco tëpa'ahua'. Inapotatëhua poso yaninantëquë po'moa'ahua'. Ina quëran “pa'piniri ca'nin,” itahua'. Inapotohuatëhua', ¿naniinta'ma hua'narinsopita pa'? niitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nopinoso natanahuaton, Cosi pa'poyacaso marë' itapon: —Ama tëpa'ahuasohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Co tëpatacaso ya'huërinhuë'. Iso inotëroquë yaninantë poso nininquë të'yatoco'. Ama canpitariso' ma'sha onpotocosohuë', itërin. Iya'huain nanin quëran ocoirahuaton, pa'pinquë'pa' a'paantacaso yonquiaton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Cosiso iinpitataquë canconpachina, no'huitona noyápiachin a'morinso matopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Matahuatona yaninantë posoquë, të'yatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Inapotahuatona', coshatapi huachi. Coshatasoi ni'pirinahuë', a'na huëntona' Ismairo nicatono'sa', nioshirin huë'sapi. Carata parti quëran huë'sapi. Camiyonënaquë, pimo hua'sairo'sa', parsamo nimirio, pimo yaqui', inapita quësapi. Iquipitoquë pa'anapona', quëparapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Naporo' Cotaso iinpita itapon: —¡Iya'hua tëpahuatëhua', co manta canarihuahuë'! Naporahuaton inapotohuatëhua', nonpi nonpínantacaso' ya'huapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ama tëpa'ahuasohuë'. Ismairo nicatono'sa tëhuënchinso' pa'antahua'. No'huípiro mini nipirinhuë', co nishahuë'. Iyanpoa', tënin. Napohuachina, iinpitari: “¡Tëhuënchachinchi paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nicatono'sa inataquëchin na'huërahuachinara, iinpitari Cosi ocoipi. Yaninantë poso quëran ocoirahuatona', nicatono'sa pa'antopi. Cato shoncatë coriqui pahuërëtohuachinara, Iquipitoquë quëpapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nopinoso Cosi të'yatopiquë huënantahuachina, co huachi iin quënanquintarinhuë'. Pa'pi pa'yanaton a'morinso osharin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ina quëran iinpitataquë huënantarahuaton, itiintarin: —¡Iya'hua capa huachi! ¡Ma'huantacha caso nisarahuë paya! tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Naporo' iinpitaso', Cosi a'morinso masahuatona chipo tëpapiso' huënainënquë, asë'cotëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Inapotahuatona pa'pinaquë a'papi. Quëpana'piso' iso pochin pënënpi: “Iso a'mopiso quënanai. Noya ni'quë'. ¿Hui'nanquën a'na nimara ti?” itëquë', itahuatona a'papi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Cacoposo' nohuitahuaton, tapon: “¡Iso mini hui'nahuë a'morinso'!” tanan ni'niri napotërin ipora, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Napoapon pochin co napion cancantaton a'morinso nioshatërin. Naporahuaton, sa'catën nininso' sëtohuachinara a'mopiso', a'morin. Ina a'morin quëran hui'nin chimininso marë' hua'qui na'nërárin, ayanárin, naporárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ya'ipi hui'ninpitari achinicancanpirinahuë', inaso co nohuanchátërarinhuë', sëtërinso inquicaso'. Aquë aquëtë hui'nin marë' na'nëton, naporin: “Chimipiro'sa ya'huërinquë hui'nahuë quënanconta' huarë' sëtërahuëso' copi tapo,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ismairo nicatono'saso', Iquipitoquë camapi. Camahuachinara, Cosiso a'nara quëmapi Potihuaro itopiso', pa'antopi. Inaso', Iquipito copirnori catahuacaso marë' acorin. Capitan ya'conaton, copirno a'paipisopita sontaro'sa camairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Naporo tahuëri'sa Cotaso iinpita patahuaton, Atoran ninanoa'huaquë pa'nin. Inaquë a'na quëmapi Iro itopiso ya'huërin. Ina ya'huërinquë yacapatonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Inaquë yacapatapon pochin, a'nara nanon nohuitërin. Inaso', Soa itopiso' hui'nin. Soaso' Canaan piyapi. Cotari natanpachina, acoantopi. Inaquë hui'nahuanpachina, paninanën nasitërin. Ina nohuitaton, Iri itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Naquëranchin sa'in cayoantarin. Nasitohuachina, quëmapi chachin niantarin. Inaso', Onan itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Naquëranchin hua'huaantahuachina, quëmapi chachin niantarin. Inaso', Sira itërin. Quisipo ninanoquë Cota ya'huëaso', inaso nasitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iri hui'napitohuachina, pa'pini Tamara acoantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Acoantopirinhuë', Iri co noyahuë' nininso' co Sinioro costarinhuë ni'ton, ina nohuanton chiminin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Napohuachina, Cotari Onan ya'huërë' itapon: —Iya masho ayananpirinso sa'in, quëmari maquë'. Canpoaso inachintërëhua ni'ton, imoya macaton, inaquë hui'nahuanquë'. Hui'nahuanpatan, Iri quëran pipicaiso nipisopita quëmá quëran ya'huëtarin huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onanso' Tamara macaponahuë': “Hui'nahuanpato, hua'huaro'sa co caquën nisarinhuë'. Irico hui'ninpitaráchin pochin nisarin,” tënin yonquinënquë. Napoaton, Tamara tëcarihuachina, aipi a'paconin. Ama iinco ya'huërënamënpita, ina quëran ya'huëcaso marëhuë' naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan naporinso Sinioroso nitotaton, chiníquën no'huitërin. Napoaton inanta', ina nohuanton chimiantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Naporo' Cotaso', Tamara itapon: —Quëyoroantaran ni'quëhuarë', iporaso' tataparin ya'huërinquë paantaquë'. Hui'nahuë Sira itërahuëso hui'napitaquë huarë', inaquë ya'huëtaquë', itërin. Itaponahuë', co tëhuënchachin napotërinhuë'. Nonpintaton naporin: “Sira ya'huërë', iinpita pochachin chimiantahuachin,” ta'ton naporin. Napoaton Tamaraso', pa'pin ya'huërinquë pa'nin ya'huapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Cara pi'iquëran pochin Cota sa'in ya'huërë' chimiantarin. Inaso' sha'huitëranquëmaso chachin, Soa hui'nin. Chiminpachina, Cotaso sëtaton na'nërárin. Sëtërinso' inquihuachina, Tinato ninanoa'huaquë pa'nin. Ohuicanënpita ya'inapiro'sa inaquë ya'huëapi ni'ton, pa'nin nicapon. Amiconën Iro itopisorë' pa'nin. Iroso', Atoran piyapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","14","Tamaraso ina nitotaton, quëyoron a'morinso ocoirin. Inaporahuaton, nitaparin. Niimomototërinso' në'mëtëquë nipa'shinayatërin. Ama nohuitacaiso marëhuë' naporin. Inaporahuaton, Inain ninanoa'hua ya'cari', huënsëconin. Inaso' ninano', Tinato iraquë ya'huërin. Sira nani hui'napitopirinhuë', co acoantopihuë' ni'ton, shiin yanonpintërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Cotari quënanahuaton, nipa'shinayatërinso marë': “Isoso sanapi, monshihuantë',” tënin. Napoaton pëshonin ya'caricaso marë'. Co shiin nohuitatonhuë', itapon: —¿Canta quëmaro'co nii topirahuë? itërin. —¿Ma'ta nipachin pahuërëaponco? tënin sanapinta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","—Pë'tahuarahuësopita quëran, a'nara chipoa'hua a'patiaranquën, itaantarin Cotari. —Inta nipachin. Napoaponahuë', ma'sha tëranta quëmaquën nininso' patëquë'. Chipoa'hua a'patianco huarë', cari tapaarahuë, itërin sanapiri. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","—¿Ma'ta nipachin pachi? tënin Cota. —Sicho po'moitëranën pë'natëransoarë chachin, huaranën, inapita patëquë', itërin. Napotohuachina Cotaso', nataninsopita quëtërin. Inapoaton tëcarihuachina, naporo chachin hua'huantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ina quëran Tamaraso', pa'pin ya'huërinquë panantarin. Nipa'shinayatërinso' ocoirin. A'morinsonta ocoirahuaton, naquëranchin quëyoron a'morinso a'moantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ina quëran Cotariso', chipoa'hua a'patërin. Amiconën Irori quëpatërin. Sanapi acoantërinsopita ayantacaso marë' a'patopirinhuë', inariso co huachi quënanconinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Napohuachina, ya'huëhuano'sa natanin: —Monshihuantë sanapi Inain ira pirayan huënsëyantërinso': ¿Intohuata pa'nin? itërin. —Co isëquë monshihuantë sanapi ya'huërinhuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Napotohuachina, Cota ya'huërinquë huëantarahuaton, itiintarin: —Co'chi sanapi quënanconahuë paya. Ya'huëhuano'santa': “Co isëquë monshihuantë sanapi ya'huërinhuë',” itërinaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Napotohuachina, Cotari itapon: —Ma'ta pini. Noyatapon. Quëtërahuësopita yamapachin, main nipachin. Ina marë' nanan ocoihuatëhuaso', piyapi'sa tëhuaponënpoa'. Nanichi chipoa'huaya a'patochinpirahuë', co quëmari quënanconanhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Cara yoqui quëran pochin, Cota sha'huitapona huëcapaipi: —Shiparin Tamara itërëhuaso', monshihuanin. Napoaton iporaso' cayorin huachi, itopi. Natanahuaton Cotaso', no'huitaton yai tënin: —¡Ocoirahuatoma', a'pëco chimiin! tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ya'huëhuano'sari Tamara a'pëcaso marë' ocoirapirinahuë', inaso shiin nanan a'patërin: “Iso sicho po'moitëra pë'natërinsorë chachin nininso' hua'anën, napotërinco. Iso huaranta', inanquën chachin ni'ton, noya nicaton nohuitëquë',” itëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Cotaso', shiini a'patërinsopita nohuitahuaton, naporin: “Tëhuënchachin caso co noyahuë' ninahuë'. Co Sira acoantatohuë', tëhuërahuë. Inaso nipirinhuë', noya noya ninin,” tënin. Naporo quëran huarë' Cotaso', co huachi onporo tëranta shiin tëcariantarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamara huaicaso nanihuachina, catopia'huaya hua'huatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","29","Nasitapona napopi: A'na'ton imiria'huain ocoirin. Napohuachina ahuaitona'piri, quëhuan pi'shiquë, tonpotanpatërin. “Iso'ton hua'huacharin,” ta'ton, napotërin. Napopirinhuë', hua'huashaso tanpara'huain po'moantarin. Shiarahuaton a'naso', nasitochanin. Napoaton ahuaitona'piri nininën acotërin: Parisi itërin. “Ya'copirinquënso inquirahuaton, pipiran,” itahuaton, inapochin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Quëhuan pi'shiquë tonpotanpatërinsoso', ina piquëran hua'huatërin. Inaso' nohuitaton: Saro itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Sha'huitëranquëmaso chachin Cosiso', Ismairo nicatono'sari Iquipito no'paquë quëpapi. Inaquë a'nara Iquipito quëmapi Potihuaro itopiso' pa'antopi. Inaso', Iquipito copirnori catahuacaso marë' acorin. Capitan ya'conaton, copirno a'paipisopita sontaro'sa camairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Cosiso napotopirinahuë', Siniorori co naniantërinhuë'. Inari catahuarin ni'ton, hua'anën pëinënquë noya yonquiaton yacapatërin. Noya nicaton, noya ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Cosiso', Yosëri catahuarin. Hua'anëni ina nicaton: “Nani ma'sha Cosi nipachina, Yosëri catahuarin ni'ton, noya pipitërin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Napoaton pa'yatërin. Pa'yataton, acorin catahuacaso marë'. “Ma'pitasona ninahuëquë, quëma catahuaponco,” itërin. Naporahuaton, ya'ipi piyapinënpita camaiaton asacatacaso marë' acorin. Ya'ipi ma'shanënpitanta a'paicaso marë' acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ina acorin quëran huarë', Siniorori Potihuaro catahuamiatërin. Cosi noya nicaton, napotërin. Pëinënquënta ma'sha nipachina catahuarin. Iminënquënta sacatohuachina', sha'topiso' noya noyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Cosiri ya'ipi ma'shanënpita noya a'paitërin ni'ton, co huachi ma'marë tëranta yonquiárinhuë'. Topinan noya coshatárin huachi. Cosiso', noyapin noyapin ni'tomantarin ni'ton, ya'ipi quëran pa'yatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Napoaton co hua'quiya quëranhuë', hua'anën sa'ini ni'sárin quëran noyarin huachi. A'na tahuëri itapon: —Huëquë pa'a quëmaso' inapoquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Napotopirinhuë', Cosiso co pi'pisha tëranta nohuantërinhuë'. Napoaton itapon: —Ni'quë siyora, pi'pian sha'huichinquën topirahuë: Hua'anëhuë ya'ipi ya'huëtërinsopita a'paia'huaso marë' acorinco. Cari ya'ipi a'paiarahuë ni'ton, co ma'marë tëranta yonquiárinhuë'. Natërinco ni'ton, sano cancantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Chini chiníquën nanan quëtërinco iso pëiquë camaita'huaso marë'. Naporahuaton, hua'anëhuë co ma'sha tëranta apiratërincohuë'. Quëmasáchin tëhuënchinso' sa'inquën ni'ton, apiratërinco. Napoaton, co caso pi'pian tëranta nohuantërahuë' pa'pi co noyahuë' nininso' nicaca'huaso'. ¡Naporahuaton quëmarë'co ninahuë naporini, co Yosë natëtohuë', pa'pi oshahuaintohuë'! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Napotopirinhuë', sanapiriso Cosi ichiquëhuënacaso marë' nani tahuëri apisárin. Inaso napoaponahuë', co pi'pisha tëranta nohuantërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","12","A'na tahuëriso nipirinhuë', Cosi pëiquë sacatapon ya'conin. Naporo' co a'napita ya'huëasoihuë ni'ton, sanapiso Cosi so'huianarinso matërin. Inapotaton: —Huëquë pa'a quëmaso inapoquë', itërin. Napotopirinhuë', Cosiso niso'huianatërinso pa'coirahuaton, ta'arin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","15","Ina patërinso ni'sahuaton, sanapiso yanonpinin. Yanonpinaton chiníquën huiyo tënin. A'napita piyapinënpita përacaso marë' naporin. Huë'pachinara, itapon: —¡Ni'cochi iso'! So'yahuë a'nara iprio piyapi quëshiantërinpoa tapiinpoaso marë'. Ya'conahuaton masapirincohuë', canpita huëcacamaso marë' caso chiníquën huiyo tënahuë. Ina natanaton, ta'arë'nachin pipirin. ¡Niso'huianatërinsonta', patërin! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Piyapinënpita napotahuaton, Cosi niso'huianatërinso' taparin. So'in huëcaquë huarë' taparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","18","Ina huë'pachina, piyapinënpita sha'huitërinso chachin inanta sha'huitërin: —Iprio piyapi quënanso', patoananëhuëquë ya'conahuaton masapirincohuë'. Chiníquën huiyo topatora, a'porahuatonco ta'arin. Niso'huianatërinsonta', patërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","¡Inapotërinco piyapinën! itërin. Sa'ini sha'huitërinso' natanahuaton, Cosi hua'anënso pa'pi no'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Cosi macacaiso marë' piyapinënpita camairin. Nani mapachinara, tashinan pëiquë po'mopi. Copirno tëhuëtopisopita ya'huëapiquë po'mopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tashinan pëiquë po'mopirinahuë', Siniororiso' co Cosi naniantërinhuë'. Nosoroaton catahuaantarin ni'ton, tashinan pëi hua'ani, noya nicaton pa'yatërin: “Cosiso', nóya hui'napi,” ta'ton, noya ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Napoaton catahuacaso marë' acorin: “Quëmari a'napita prisoro'sa', a'paiaran,” itërin. Napoaton Cosi camaitërinsoráchin tashinan pëiquëso', prisoro'sa nipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Cosi camaitohuachina tashinan pëiquë, noyasáchin sacatopi. Napoaton tashinan pëi hua'anso', co huachi Cosi sacatërinso' ni'sárinhuë': “Siniorori chachin Cosiso catahuarin ni'ton, ma'sona nipachina, noya pipitërin” ta'ton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ina piquëran cato hua'ano'sari Iquipito copirno tëhuëtopi: A'naso', copirno huino o'shitona'piro'sa hua'an. A'nanta', ina marë chachin pan nina'piro'sa hua'an. Cato chachin copirno tëhuëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Napoaton copirnori inapita no'huirin. No'huiton tashinan pëiquëtacaiso' camaitërin. Napohuachina cato chachin inaquë po'mopi. Ina tashinan pëiso', copirno a'pairinsopita capitan pëinënquë ya'huërin. Cosi ya'huëarinquë chachin po'mopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Copirno a'pairinsopita capitaniso', Cosi itapon: “Isopita cato hua'ano'sa quëmari noya a'paiton, catahuaquë',” itërin. Inapotohuachina inapita hua'ano'saso', hua'qui inaquë ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","A'na tashiso nipirinhuë', cato hua'ano'sa chachin, hua'napi. A'naya a'naya hua'napiso', co inachachin tapon hua'napihuë', nisha nisha tapon hua'napi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tashíramiachin Cosiriso nicapon huë'pachina, sëtápi quënanquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Napoaton, cato chachin natanin: —¿Onpoatomata iporaso' pa'pi sëtëramaso pochin ya'norama'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","—Catocoi chachin hua'napiraihuë', co insonta ya'huërinhuë' ma'sona tapon hua'naraiso anitotiincoiso', itopi. —¡Yosë mini nanitërin ma'sona tapon hua'narësopita anitotiinpoaso'! Sha'huitoco hua'naramaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Napotohuachina o'shina'piro'sa hua'anso', hua'narinso Cosi sha'huitërin: —Huë'ëhuëquë a'nara opa ya'huë ni'nahuë, cara së'pahuaninso'. Nicasoco chachin, papo së'patarin. Papo së'patahuaton, yancotarin. Yancotërinquëranchin nitërinsopita cayarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ina pirayan canta', huaraon o'orinso' minënën së'quëato, huaniárahuë. Opa cayarinso masahuato, huaraon o'orinquë shi'shirahuë. Inapotahuato huaraon ihuëtërahuë. Ihuëtohuatora ma'parinco huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","13","Napotohuachina, Cosiri itapon: —Naporinchi paya. Ma'sona tapon hua'naranso sha'huichinquën: Cara së'pahuaninso', cara tahuëri tapon naporin. Cara tahuëriya quëran, huaraonso' quëma tëhuëranso' yonquiantarin. Nanan anoyatahuatënquën naquëranchin acoantarinquën ina marë' sacataantacaso'. Iráca naporanso chachin naquëranchin o'shitaantaran huachi. Ina tapon, ina pochin hua'naran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","15","Inapotohuachinquën, canta nosoroatonco yonquico. Ocoincoso marë' huaraon sha'huitëquë'. Iprioro'sa ya'huëpiquë caso ya'huëpirahuë', topinan quëran no'huitonaco pa'aninaco. Co manta onporahuë ni'ton, co tashinan pëiquë ya'huápa'huaso ya'huërinhuë'. Napoaton nosoroco canta', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","17","Napotohuachina, copirno marë' pan nina'piro'sa hua'anta': “Noyachi sha'huitërin paya,” ta'ton, hua'narinso Cosi sha'huitërin: —Canta nipirinhuë', iso pochin hua'narahuë: Cara ya'huiri pan acoinanquë pitëmotorahuato, huiríton pano'sa quëpárahuë. Ya'natontarinso acoinanquë, nisha nisha cashi cashin pano'sa copirno marë' ya'huërin. Napoaponahuë', inairaro'sa huë'sahuatona pitëmotorahuë quëran capitarinaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Napotohuachina, Cosiri itapon: —Cara pan acoinanso', cara tahuëri tapon naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Cara tahuëriya quëran, huaraonso' quëmanta tëhuëranso' yonquiantarin. Naporo chachin piyapinënpita camaiapon: “Noninquë huënquëconorahuatoma', naraquë pë'tënco chimi'in,” itapon. Inapotohuachinën, chanaro ca'tëro'sari noshanën capona', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Cara tahuëriya quëran, huaraon hua'huatërinso tahuëri nanirin. Naporo' ya'ipi catahuarinsopita hua'ano'sa ichicapacancanacaso marë', panca pita ninin. Ya'ipi përarinsopita ni'tonënquë huaraonso' camaitërin: “Cato hua'ano'sa chachin tashinan pëi quëran ocoico',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","O'shina'piro'sa hua'anso', naquëranchin asacataantarin. Napoaton naquëranchin iráca pochachin huaraon o'shitaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pan nina'piro'sa hua'anso nipirinhuë', huaraoni piyapinënpita camairin naraquë pë'tënacaiso marë': “Noninquë huënquëconorahuatoma', tëpaco',” itërin. Cosiri sha'huitërinso chachin nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","O'shina'piro'sa hua'aniso', Cosiri catahuacaso marë' sha'huitërinso', naniantërin. Inapoaton co catahuarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","O'shina'piro'sa hua'an, tashinan pëi quëran pipirinso' nani cato pi'ipitërin. Naporo' huaraon chachionta hua'narin. Niroi' yonsanquë huaniarin nihua'narin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A'nanaya ni'pirinhuë', canchisë ohuaca' Niroi' quëran pipirapi ni'nin. Pa'pi amoshináchin pipirapi. I' quëran pipirahuatona', shi'shinamatëro' huáncana coshatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ina quëran niantapirinhuë', canchisë chachin Niroi' quëran pipirapi ni'nin. Inapitaso' capa nishinahuën nansëyaráchin niconpi. Pipirahuatona i' yonsanquë a'napita ohuacaro'sa pirayan huanirapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nicaso chachin, inapitaso', amoshino'sa pashica ta'papi. Inapotatona', canchisë chachin pë'yaquë huarë' ca'miatopi. Naporo' huaraonso' capayatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Naquëranchin huë'ëantapirinhuë', hua'naantarin. Canchisë trico moto' noya noyatërinso' a'na nanquëáchin nitërin ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Inapita pirayan, canchisë chachin pipiantarin. Inapitaso' pi'iri ahuiquitërinso pochin ya'nopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Inapitanta noya noyatërinso nipisopita pashica ta'papi. Inapotatona pë'yaquë huarë' ca'miatopi. Naporo chachin huaraonso' capayataantarin. Capayatahuaton: “Co ipora topinan ina pochin hua'narahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tashiramiachin huaraonso' hua'narinso yonquiaton, co napion cancantërin. Napoaton piyapinënpita camairin ya'ipi Iquipito no'paquë ninotona'piro'sa huëcacaiso marë'. Quirica nitotoro'santa amatërin. Inapita huë'pachinara, hua'narinso' sha'huitërin. Sha'huitopirinhuë', co incari tëranta nanitërinhuë' ma'sona tapon hua'narinso sha'huitacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Naporo huarë' o'shitona'piro'sa hua'an Cosi yonquirin. Ina yonquiaton huaraon itapon: “Ipora huarë' yonquirahuë ma'sona i'hua chachin nica'huaso' nininso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Quëmaso' chiníquën nanantëran. Caso piyapinënco nipirahuë' sha'huitaranquën. Pan nina'piro'sa hua'anoco chachin, iráca no'huitoncoi tashinan pëiquë apo'motërancoi. Inaso' tashinan pëi', a'pairinënquënsopita capitan pëinënquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","A'na tashiso' catocoi chachin hua'narai. A'naya a'nayacoi nisha nisha tapon hua'narai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","13","Inaquë chachin quiyaro'coi a'nara iprio hui'napi ya'huëarin anta'. Inaso' ina capitani chachin, asacatacaso marë' pa'anin. Hua'naraiso sha'huitohuatëira, ma'sona tapon naporinso no'tëquën sha'huitërincoi. Sha'huitërincoiso chachin caso naquëranchin asacataantaranco. A'naso nipirinhuë', noninquë ahuënquëconotahuaton atëpatëran,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Inapo sha'huitohuachina, copirnoso Cosi macontacaso marë' piyapinën a'parin. A'naroáchin tashinan pëi quëran ocoipi. Cosiso niya'itahuaton, nitaparin. Noya nininso' a'mosahuaton, huaraon nicapon pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Canconpachina, huaraoni itapon: —Caso hua'napirahuë', co insonta nanitërinhuë' ma'sona tapon hua'narahuëso sha'huitiincoso'. Quëma tëhuënchinso' nitotëran, topi natantërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","—Co caora nohuanton nitotërahuë'. Quëma piyapinënco ni'to, Yosë chachin anitotohuachinco, sha'huitaranquën. Ma'sona noya nicacaso marë', sha'huitaranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Napotohuachina huaraoni itapon: —Huë'ëhuëquë Niroi' yonsanquë huaniárahuë hua'narahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Naporo chachin, canchisë ohuaca' pa'pi amoshináchin nipisopita, i' quëran pipirapi. Pipirahuatona shi'shinamatëroquë coshatapi ni'nahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ina quëran canchisë chachin pipiantapi niantarahuë. Capa nishinahuën nansëyaráchin pipirapi. ¡Co onporo tëranta ya'ipi Iquipitoquë ina pochin nipisopita ni'chinahuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nicasoco chachin, inapitaso', amoshino'sa pashica ta'papi. Inapotatona canchisë chachin, pë'yaquë huarë' ca'miatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pë'yaquë huarë' caponaraihuë', co manta ca'pisohuë pochin ya'nopi. Naporo capayatërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Huë'ëantapirahuë', naquëranchin hua'naantarahuë: Huë'ëhuëquë Canchisë trico moto' noya noyatërinso' a'na nanquëáchin nitërin ni'nahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Inapita pirayan, canchisë chachin pipiantarin. Inapitaso' pi'iri ahuiquitërinso pochin ya'nopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Inapitarinta noya noyatërinso nipisopita pashica ta'papi. Inapotatona pë'yaquë huarë' ca'miatopi ni'nahuë. Ninotona'piro'sa sha'huitopirahuë', co insonta nanitërinhuë' ma'sona tapon naporinso', sha'huitiinacoso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Napotohuachina, Cosiri huaraon itapon: —Caso quëma piyapinënco nipirahuë', sha'huitaranquën: Catoro hua'naranso', a'naíchin tapon hua'naran. Ina quëran Yosë chachin anitotërinquën ma'sona ina nicacaso' yonquirinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Canchisë ohuaca' noyápiachin nipisopita, canchisë pi'ipi tapon hua'naran. Canchisë trico moto' noyápiachin nipisopitanta', ina chachin tapon naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Canchisë ohuaca' capa nishinahuën nansëyaráchin nipisonta', hua'naran. Inapitaso', amoshino'sa piquëran pipipi. Inapitanta canchisë pi'ipi chachin tapon naporin. Ina pochachin noya noyatërinso' trico moto' pirayan, canchisë chachin papoantarin hua'naran. Pi'iri ahuiquitërinso pochin ya'nopisopitanta', ina chachin anitotërinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Napotëranquënso chachin mini nisarin. Piyapinënco nipirahuë', Yosë ma'sona yanininso nani sha'huitëranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yosë nohuanton canchisë pi'ipi iso Iquipito no'paquë nani ma'sha noya noyatapon. Co manta pahuanaponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Ina piquëranso nipirinhuë', canchisë pi'ipi chachin panca tanarotapi. Napoaton co huachi inso tëranta', Iquipito no'paquë noya ya'huërinso yonquiarinhuë'. Pa'pi pahuantomiatapi ni'ton, co huachi iso no'paquë noya ya'huaponahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Caso piyapinënco nipirahuë' sha'huitaranquën. Nani Yosë yonquirin inapocaso'. Naporahuaton co hua'quiya quëranhuë' naniarin. Napoaton ina nohuanton, catoro inachachin hua'naran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","34","Inapocaso ni'ton, a'nara quëmapi yonquínahuan ni'ton, noyá nitotërinso' yoníquë'. Ya'ipi iso no'panënquë ya'huëpisopita camaicaso marë' acoquë'. Naporahuaton, chirinchiro'sa acoquë' ya'ipi hua'anëntëranquë pa'ina'. Cosharo yontonacaiso marë' pa'ina'. Noya noyatacaiso' pi'ipiro'saquë yontoina'. A'natërápo costaro quëran, a'na costarora ma'pachina'. Ya'ipi Iquipito no'paquë inapo'ina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Naporo' pi'ipiro'saquë trico yontonpiso', niquë tapaina'. Quëma chachin anitotahuatënën, ninanoro'saquë tapaina'. Tanaro tahuëri'sa canquihuachina, capacaiso marë' inapo'ina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Inapohuachina', Iquipito no'paquë trico tapapinan ya'huapon. Canchisë pi'i tanarotacaiso canquihuachina, ina ca'sapi huachi. Ina capatona', ya'ipi iso no'paquë ya'huëpisopita co chiminaponahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Cosi yonquirinso natanahuatona', huaraonso hua'ano'sapitarë chachin: “¡Ma nóyacha yonquirin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Napoaton huaraonso' piyapinënpita itapon: —Iso quëmapiso', Yosë ispiritonëni chachin ya'coancantërin. Co onporonta a'na quëmapi iso pochin nininso' ina sacato nicacaso marë' quënanarihuahuë', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","40","Piyapinënpita napotahuaton, Cosi itapon: —Co a'na quëmapi quëmá quëran yonqui yonquínahuan ni'ton, noya noya nitotërinso ya'huërinhuë'. Yosë chachin ya'ipi inapita anitotërinquën. Napoaton carinquën acoaranquën pëinëhuëquë, ya'huërënamëhuë camaitacaso marë'. Ya'ipi piyapinëhuëpitanta natëinënquënso ya'huërin. Copirnoco ni'to, casáchin quëmá quëran chini chiníquën nanantarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ni'quë'. Ipora tahuëri carinquën acoaranquën ya'huërënamëhuë ya'ipi Iquipito no'pa' hua'anëntacaso marë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Napotahuaton huaraonso', imisirinquë sicho po'moitëranën po'morinso' ocoirin. Ina ocoirahuaton Cosi imisirinquë po'motërin. Inapotahuaton, piyapinënpita camairin: “Noya noya rino pi'shi quëran në'mëtë nipiso' a'motoco'. Naporahuaton, osëtë oro quëran nipiso', apë'pëconotoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ina quëran, toronanëhuëquë pa'patora, imaquirinso toronanquë ananpëco'. Inapotahuatoma', quëpaco'. Ina quëpasëma', piyapinëhuëpitari chiníquën sha'huiina': ‘¡Isonco'!’ tëra'ina',” itërin. Ina pochin copirnori Cosi acorin ya'ipi Iquipito no'paquë, camaitacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ina piquëran huaraoni Cosi itaantapon: —Ca mini copirnocoso nipirahuë', co inso tëranta iso no'paquë inaora nohuantërinso' nisarinhuë'. Naniyarin quëran huarë' ma'sona nicacaiso', quëma camaitaran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Copirnori, Cosi Iquipito nananquë nisha nininën acotërin: Sahuinato-paniya, itërin. Naporahuaton Potihuira hui'nin Asina itopiso' acoantërin. Potihuiraso', On ninanoquë corto hua'an ya'conin. Ina pochin Cosi, ya'ipi Iquipito no'pa' hua'anëntacaso marë' acopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Cosi cara shonca pi'ipitohuachina, Iquipito copirno marë' caniaritërin sacatacaso'. Nani acohuachina, huaraon nontahuaton caniaritërin ya'ipi Iquipito no'pa' pa'tacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Canchisë pi'ipi noya noyatacaiso' pi'ipiro'saquë, hua'huayátërahuë cosharo noyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Cosiri ya'ipi trico tapacaiso nininso', ma'patërin. Ma'pataton, ninanoro'saquë taparin. Canchisë pi'ipi naporin. Nani ninanoro'saquë trico taparin. Ina pirayan imino'saquë sha'pisopita mapiso', taparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Pa'pi notohuaro' trico Cosiri ayontonin. Marë yonsanquë inotëra'hua ya'huërinso pochin ayontonin. Pa'pi notohuaro' ni'ton, pichirápirinahuë', co onpo pichichináchinhuë' nipachina, tananpitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Co'huara tanarotacaiso caniarichátërasohuë', Cosiso cato hui'ninpita ya'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Paninanso' Manasisi itërin: “Yosë chachin parisitërahuëso', quëmopinëhuëpita, inapita ananiantërinco,” ta'ton, ina pochin hui'nin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ina quëran niantarinsoso', Iprain itërin. “Yosë nohuanton parisitërahuëso no'paquë chachin noya noya acorinco,” ta'ton ina pochin hui'nin nohuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Canchisë pi'ipi Iquipitoquë ma'sha noya noyatacaiso' pi'ipiro'sa', na'huërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Naporo' Cosi naporinso chachin, tanarotacaiso caniaritërin. Canchisë pi'ipi chachin naporin. Ya'ipi a'napita no'paro'saquënta', tanarotopi. Iquipitoquëráchin cosharo tapapinan ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Iquipito ya'huëhuano'santa cosharori pahuantohuachinara, huaraon paapapi. Trico natanacaiso marë' paapapi. Natanpachinara, huaraoni ya'ipi iquipitoro'sa itapon: “Paatoma', Cosi nontoonco'. Ma'sona itohuachinquëma', ina nico',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ya'ipi Iquipito no'paquë piyapi'sa tanarotacaiso caniaritohuachina, Cosiso chirinchiro'sa camairin: “Cosharo taparëhuaso pëiro'sa i'soatatoma', ya'huëhuano'sa pa'antoco',” itërin. Aquë aquëtë tanarotapi ni'ton, pa'antapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Naporahuaton ya'ipi parti quëran huë'sapi. Cosi trico taparinso' pa'antacaiso marë' Iquipitoquë huë'sapi. Co inso no'paquë tëranta', cosharo noyatërinhuë' ni'ton, naporapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iquipitoquë trico pa'anacaso ya'huërinso', Cacoponta' nataantërin. Ina natantahuaton, hui'ninpita itapon: “¡Co topinan nini'sápamaso ya'huërinhuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nani sha'huitërinaco Iquipito no'paquë trico pa'anacaso marë' ya'huërinso'. Napoaton inaquë pa'matoma', pa'amaco'. Ama tana tiquiinpoaso marëhuë' inapoco',” itërin ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Pa'pini napotohuachina, Cosi iinpitaso', shonca ya'pi trico pa'anapona Iquipitoquë pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mincaminso nipirinhuë', pa'pini co nohuantërinhuë' a'pacaso'. Inaso', Cosi iin miachin. Ina yo'nanquëranchin pipipiso'. “Pa'ninquë tapona ma'sha yaonpoápirinhuë',” ta'ton, co yaa'parinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Cacopo hui'ninpitaso', a'napita piyapi'sarë' pa'pi. Ya'ipi Canaan parti tanarotopi ni'ton, notohuaro' pa'mapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nani sha'huitëranquëmaso chachin Cosiso', huaraon ya'huërënamën ya'ipi Iquipitoquë camaitarin. Naporahuaton ina camaitohuachina, ya'ipi parti quëran huë'pisopita, trico pa'antapi. Iinpitanta camahuachinara, nontacaiso marë' isonpi quëran no'paquë huarë' monshorahuatona', moshaipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ipora quënanapon chachin Cosiso', iinpita nohuitërin. Nohuitaponahuë', co nohuitërinhuë pochin ninin. Napoaton no'huitatë pochin co yashinhuë' nontërin: —¿Canpita po'? ¿Intoparanta huë'nama'? itërin. —Canaan parti quëran, trico pa'anapoi o'marai, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Cosiriso iinpita nohuitërin. Inapitariso napoaponahuë', co ina nohuitopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Naporo' Cosiso', iráca hua'naton iinpita sha'huitërinso' yonquirin. Ina yonquiaton itapon: —Canpitaso', nëhuëtona'pirosanquëma tënahuë. No'panëhuëi insëquësona co noya a'paipinanhuë' ni'camaso marë' huë'nama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","11","—¡Co sinioro inacoihuë'! Quiyaso' quëma piyapinënpita pochin ninai. Tricoíchin pa'anapoi o'marai. Ina tataquëranchin ya'ipicoi ninai. Co onporo tëranta nëhuëtochinaihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","—Nonpiánama'. No'panëhuëi insëquësona co noya a'paipinanhuë' ni'camaso marë' huë'nama ipora, taantarin Cosiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Napotopirinhuë', inapitariso itapona': —Quiyaso' quëma piyapinënpita pochin ninai. Ya'ipiya quëran ina tataquëranchin, shonca catocoi ninai. Canaan parti ya'huërai. Hua'hua nininsoso', tatarë' quëparitërin. A'naso nipirinhuë', ayarin, itaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","15","—¡Nani napotëranquëma'! Canpitaso' nëhuëtona'piro'sanquëma tënahuë. Iyaparima hua'hua nininso quëcama huarë', no'tëquën nonamaso' nitotarahuë. Huaraon ya'huërin ni'ton, no'tëquën nontaranquëma'. Co ina quëpatamahuë', co onporonta isëquëran pipiaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","A'naquëma paaton maconta'in. A'napitanquëmaso nipirinhuë', tashinan pëi ya'contarama'. Ina huë'pachin, naporo huarë' naporamaso natëaranquëma'. Co'so' huë'pachinhuë', tëhuënchachin nëhuëtona'piro'sanquëma'. ¡Huaraon ya'huërin ni'ton, no'tëquën nontaranquëma'! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","18","Cara tahuëri Cosiri iinpita tashinan pëiquëtërin. Inapotopirinhuë', nontaantarin: —Canta Yosë të'huatërahuë. Iso pochin nipatama', co tëpaaranquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tëhuënchachin noya nina'piro'sanquëma nipatama', a'naquëma tashinan pëiquë quëparichin. A'napitanquëmaso nipirinhuë', quëmopinëma capacaiso marë' trico quëpatoma', panantaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ina quëran, no'tëquën nonamaso' nitota'huaso marë', iyaparima hua'hua nininso quëshimaco. Co'so' quëmahuatamahuë' tëhuënchachin chiminarama', itërin. Napotohuachina: “Noyapa',” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Napoaponahuë', inahua capini ninontopi: —Tëhuënchachin canpoaso' iráca pa'pi co noyahuë' ninëhua'. Iya'hua ma'sha onpotohuatëhuara, nosorochináchin nontopirinpoahuë', co nosororëhuahuë'. Co napion ancantërinso nicarihuarahuë', co tahuërëtërëhuahuë'. Napoaton iporaso' canpoanta', po'sarëhua huachi, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Napohuachinara, Nopinori itapon: —Co'ta carima': ¡Ama napotocosohuë'! itopiranquëmahuë', co natëramacohuë'. Napoaton iporaso' canpoanta', tëpatona'pi i'huërëtopiso pochin nitarinënpoa', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Inapitaso', Cosiri ya'ipi nataninso' co nitotopihuë'. Iquipito nanan quëráchin nontërin ni'ton, napopi. Nontohuachina, a'nari inahua nonpiquë ohuërërin ni'ton, co nitotopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Iinpita ninapotapiso natanahuaton, Cosiso amashamiachin pa'sahuaton, na'nërin. Na'nëi' cacotohuachina, huëantarin. Huë'sahuaton iinpita ni'tonënquë piyapinënpita camairin Simion macatona tonpocaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ina quëran camaitaantarin: “Costaronënaquë trico po'motoco'. Coriqui pahuërëtopisonta', inaquë chachin po'moantaco'. Naporahuaton, cosharo caracaiso marënta quëtoco',” itërin. Camairinso chachin piyapinënpita nipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Inapotohuachinara, moranënaquë triconëna a'mitahuatona', ya'huëpi'pa' panantapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Huë'ëcaiso nininquë canconpachinara, a'naso', moranën a'cacaso marë' costaronën i'shiritërin. Inapotopirinhuë', trico marë' coriqui pahuërëtërinso' quënanin. Ina quënanaton, pa'yanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Pa'yanaton, iinpita itapon: —Ni'cochi. ¡Trico marë' pahuërëtërahuëso', ayantaantarinaco! ¡Costaronëhuëquë chachin quënanahuë! itërin. Iinpitaso natanahuatona', pa'pi pa'yanpi. Pa'yanahuatona', inahua capini ninontapi: ¡Yosë ana'intarinpoa ni'ton, co pahuërëtaponahuë' trico quësarin! Nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ya'huëpiquë cancontahuachinara, ya'ipi napopiso pa'pina sha'huitopi: ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Iquipito no'pa' hua'anquë camahuatoira, co yashinyántërahuë' nontërincoi. “Canpitaso', nëhuëtona'piro'sanquëma ipora,” itërincoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","32","Napotopirincoihuë': “Co quiyaso' inacoihuë'. Co onporonta nëhuëtochinaihuë'. Ina tataquëranchin shonca catocoi ninai. Hua'hua nininso', Canaan parti tatarë' quëparitërin. A'naso nipirinhuë', ayarin,” itërai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","34","Napotohuatoira, itaantarincoi: “A'naquëma isëquë quëparichin. A'napitanquëmaso nipirinhuë', quëmopinëma capacaiso marë' trico quëpatoma', panantaco'. Napoaponahuë', iyaparima hua'hua nininso quëshimaco. Naporo huarë' co nëhuëtonapiro'sanquëmahuë ninamaso' nitotarahuë. Ina nitotohuato, iyaparima quëparitërinso' ocoitaranquëma'. Nisahuaton, noya huachi nanitarama iso no'paquë pa'anamaso',” itërincoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nani pa'pina sha'huitahuatona', trico ohuatopi. Ohuatohuachinara, Cosi iinpitaso', a'naya a'naya costaronënaquë, coriquinëna quënaantapi. Tanpanantëa'huayaquë ya'huëarin quënaantapi. Ina quënanatona', pa'pi pa'yanpi. Pa'pinanta pa'yanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Naporo' Cacopori itapon: —Canpitaso hui'nahuëpita tiquitaramaco. Cosi ayarin. Simionta capa. ¡Iporaso Mincanta yaquëpataantaramaco! ¡Ya'ipi inapita casa', ahuanta'huaso ya'huërin! itërin ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Naporo' Nopinori, pa'pin itapon: —Iya'hua a'pahuatan, cari tata a'paiarahuë. Co'so' quëshintahuatënquënhuë', cato hui'nahuëpita nininso', nanitëran tëpamaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Cacoposo nipirinhuë', tapon: —Hui'nahuëso', co onporo pa'sarinhuë'. Iin mashonën nani chiminin. Inaíchin ina yo'nanquëranchin nipiso' ya'huëarin. Pa'namaquë ina ya'huërë' ma'sha onpoantahuachin, caso mashoco, sëto tëpaponco huachi, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Canaan parti co manta capacaso ya'huërinhuë' ni'ton, aquë aquëtë tanarotapi. Napoaton i'hua Iquipitoquë trico pa'anpiso' pë'yapi. Pë'yahuachinara, Cacoposo' naquëranchin hui'ninpita camaiantarin: —Pa'mantatoma trico pa'amantaco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Napopirinhuë' Cotari itapon: —Co'ta tata hua'an napotërincoiso', nani sha'huitërainquën: “Co'so' iyaparima hua'hua nininso quëmahuatamahuë', ama o'macosohuë'. Ina quëmama huarë' tahuërëtaranquëma',” itërincoi. Iya'hua a'paantohuatancoi, naporo huarë' trico pa'antomarainquën. Co'so' a'paantohuatancoihuë', co pa'maaraihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","—¡Canpitaso pa'pi co noyahuë' acoramaco! ¿Ma'marë chachinta ina quëmapi sha'huitërama a'na iya'hua ya'huëtërinquëmaso'? itërin pa'pini. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","—Na'con natanincoi onpo ya'huëtërëhuasona nininso': “¿Nanpiárin tataparima'?” itahuatoncoi: “¿A'na iyaparimanta ya'huërin?” itomantarincoi. Napo natanpachincoira, topinan a'panitërai. ¡Co quiyaso' nitotëraihuë': “Iyaparima hua'hua nininso quëshimacoi,” itiincoiso'! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Naporo' Cotari pa'pin itaantarin: —Tëhuënchachin tata nanpicaso' nohuantohuatëhua', iya'hua a'paquë pa'i. Cari a'paiarahuë. A'paantohuatancoi a'naroáchin pa'sarai. Inapohuatëhua', co chiminarihuahuë'. Hui'napoapitanta', noya nanpiapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iya'hua pa'pachin, cari ni'sarahuë. Ma'sha onpohuachinso', ca ana'intoco huachi. Co'so' quëshintahuatënquënhuë', chiminaquë huarë' na'inarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","I'hua chachin napotasënquën a'pantërancoi naporini, ¡nani catoro pa'sahuatoi, huënanta'itoihuë'! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Napotohuachina, pa'pini itapon: —Co onpotacasohuë' ni'quëhuarë', isopoco nipachin: Hua'an nicanacamaso marë' iso no'paquë ma'sha noya noyatërinsopita costaronëmaquë quëpaco': Parsamo nimirio, ninoi', pimo hua'sai', pimo yaqui', tanpapi nitërinso', ni'to nitërinso', inapita pi'pian pi'pian po'motahuatoma', quëpaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Coriquinta', catoro' pa'anacaso nanirinso', quëpaco'. I'hua ayantërinquëmaso', inaora chachin quëtaantaco'. Tapona tëhuëatona', ayantërinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","¡Paco nipachin! Iya'hua quëparahuatoma', hua'an nimaantarico'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Yosë ya'ipi nanitaparinso' nontarahuë catahuainquëma'. Ina nohuanton hua'an nosoro'inquëma'. Simionta nosoroaton ocoi'in. Naporahuaton, Mincanta a'painta'in. ¡Canta co hui'nahuan mashoco pochin quëparita'huaso Yosë nohuantohuachin, inapo'i nipachin! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","16","Cacopo hui'ninpitaso', hua'an nicanacaiso nininsopita mapi. Ina masahuatona', coriquinta catoro pa'anacaso' nanirinso' mapi. Naporahuaton, Mincamin quëparahuatona', Iquipitoquë pa'pi huachi. Cosi ya'huërinquë camahuachinara, nontopi. Cosiso', Mincamin quëpiso quënanahuaton, piyapinën camairin: —Isopita pëinëhuëquë quëpaquë'. Naporahuaton a'nara ohuaca' tëparahuaton, anpiquë'. Ipora camotëchin nisahuaso', inapitaro'co coshatarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Napotohuachina, piyapinënso' ina inachachin ninin. Cosi iinpita ina pëinënquë quëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Napoaponahuë', inapitaso quëpasoi pa'yanpi. Pa'yanatona inahua capini ninontapi: —Nonpintahuatënënpoa', pëinënquë quësarinpoa'. I'hua coriqui ayantërinpoaso marë' quësarinpoa'. Masahuatënënpoa piyapinënpita pochin asacatarinënpoa'. Moranënpoapitarë chachin asacatarinënpoa', nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","21","Napoaton Cosi pëinënquë yaya'conpachinara, piyapinën itapona': —Pi'pian sinioro nonchinquën topiraihuë'. I'hua chachionta o'mapoi, tëhuënchachin trico pa'anapoi o'marai. Pa'anahuatoi panantápiraihuë', huancopi huë'ëconaiquë, costaronëhuëi i'shiritërai. I'shiritopiraihuë', coriqui pahuërëtëraiso' ya'ipi chachin costaronëhuëiquë quënanai. Napoaton quëtaanta'huanquëmaso marë' quëmantarai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Incariso acomara, co quiyaso nitotëraihuë'. A'na coriquinta ipora trico pa'antohuatëinquëma', pahuërëta'huaiso marë' quëmarai, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Napopirinahuë Cosi piyapinëniso': —Sano cancantoco'. Ama pa'yancosohuë'. Naporo' pahuërëtëramaso', nani manahuë. Yosë chinotëramaso nimara costaronëmaquë acotërinquëma'. Inachachin tataparimanta chinotërin, itërin. Napotahuaton, Simion tashinan pëi quëran ocoirahuaton quëshirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ina quëran, ya'ipi chachin Cosi pëinënquë po'morin. Inaquë i'sha nipa'morantëcaiso marë' quëtërin. Moranënapitanta', a'carin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Camotëchin Cosirë' coshatacaiso', nani nitotopi. Napoaton ninapona pochin, nicanacaiso marë' quëshipiso', taparapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Cosi canquihuachina, nicanacaiso marë' quëshipiso' quëtopi. Naporahuatona', isonpi quëran no'paquë huarë' monshorahuatona', moshapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Cosiri iinpita nontahuaton itapon: —I'hua o'mapoma': ¿Tatahuëi ya'huëarin itëramaco pora? ¿Noya ya'huëarin? ¿Nanpiarin ipora huanta ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Inapitaso' mónsho tahuatona': —Tatahuëiso', quëma piyapinën pochin ninin. Noya ya'huëarin. Ipora huanta nanpiárin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","30","Cosiso yonquitopirinhuë', Mincamin quënanin. Inaso iya'huain. Ina yo'nanquëranchin nipiso'. Ina tasatahuaton, natanin: —¿Isona: “Iya'hua a'na huëshirai” tënamaso ti? itahuaton, iin itapon: “¡Yosë chachin hua'hua catahuainquën!” itërin. Napotaso chachin iin ni'sahuaton, na'nëchináchin cancantërin. Napoaton a'naroáchin patoananënquë ya'conahuaton, na'nërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Na'nërinso' pa'cotohuachina, nipa'morayaton, pipiantarin. Pipirahuaton piyapinënpita camairin: “¡O'huinco huachi!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Cosiso', a'na misaquë nisha o'huintopi. Cacopo hui'ninpitanta a'na misaquë nisha o'huintopi. Iquipitoro'santa Cosirë' coshatopiso', a'na misaquë nisha o'huintopi anta'. Iquipitoro'saso', iprioro'sarë' coshatacaiso', na'in pochin ni'pi. Napoaton nisha coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Cosi iinpitaso', misaquë yahuënsëhuachinara, Cosiri a'naya a'naya sha'huitërin huënsëcaiso marë'. Paninan'ton, ahuënsërahuaton, ina quëran niantarinso' ahuënsërin. Inapotaton, huinshoin nininquë huarë' ahuënsërin. Napoaton: “Pi'ipinënpoa no'tëquën tantiarinpoa',” topi. Napoatona itohuara capini nini'pi. Nini'sahuatona', pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Cosiso inaora ca'ninso chachin, iinpitanta a'carin. Mincaminso nipirinhuë' o'huintohuachinara, a'napita iinpita quëran na'con na'con acotopi. Nani coshatohuachinara, napopináchin o'opi. Inapoatona capa cancantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nani ca'pachinara, o'opachinara, Cosiso piyapinën camairin: —Isopita quëmapi'sa costaronënaquë, trico amëntatëquë'. Naporahuaton coriquinëna pahuërëtopisonta', a'naya a'naya costaronënquë chachin acotaantaquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Minënëhuë prata quëran nininsonta', hua'hua nininso costaronënquë acotëquë'. Coriquinën, trico marë' pahuërëtërinso' pirayan acotëquë', itërin. Napotohuachina, piyapinënso' ina inachachin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tahuëririnquë pi'i pipirirahuaso Cosiso', iinpita nontahuaton a'parin. Napohuachina moranënapitarë chachin pa'pi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Ninano quëran pipitona iinpitaso co aquëyátërasoihuë', Cosiso piyapinën itapon: —Apira quëmapi'sa pa'piso', imaquë'. Cantonahuaton napotëquë': “¿Onpoatonta canpitaso nosoropirinënquëmahuë', co noyahuë' ninama'? Prata quëran minë nininso', hua'anëhuë o'oton ninorinso chachin ihuatërama'. ¡Pa'pi co noyahuëchi ninama paya!” itëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Cantonahuaton piyapinënso' Cosiri sha'huitërinso chachin itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Napotohuachina, inapitariso itaantapi: —¿Ihuatërama', itërancoi ti? ¡Co'chi quiyaso onporo tëranta', inapo'itoihuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","¿Co'ta Canan parti quëran huarë' coriqui costaronëhuëiquë quënanpatoira, quëshiantaranquën pora? ¿Onporahuatoita iporaso', pratahuë nipon, orohuë nipon, hua'anën pëinën quëran ihuachitoihuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Quiyaso' piyapinënpita pochincoi ninai. Incoi tëranta minë quënapahuatancoi, chimiin. Quiyanta', piyapinënpita pochin asacatocoi tënai, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Napotohuachina, Cosi piyapinënso' taantarin: —Noyapa'. Naporama ni'quëhuarë', inapochinquëma nipachin. Nipirinhuë', insosona minë quënaparahuësoíchin, piyapinëhuë nisarin. A'napitanquëmaso', co manta onpoaramahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Napotohuachina, a'naya a'naya costaronëna chinohuaratona', i'shiritapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","I'shiritohuachina yonisarin. Paninan nininso costaronën quëran caniaritahuaton, hua'hua nininso costaronënquë huarë', yonirin. Yonípachina, Mincamin costaronënquë quënanin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ina nicatona iinpitaso', pa'pi sëtahuatona a'moanpiso oshapi. Napohuachina, a'naya a'naya pë'pëtonëna moranënaquë a'mitahuatona', naquëranchin ninanoquë ayaimantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Cotaso', iinpitarë chachin Cosi pëinënquë canconpachina, inaso ya'huëarin quënamantapi. Quënanahuatona', isonpi quëran no'paquë huarë' monshorahuatona', moshaipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Moshasoi', Cosiso iinpita itapon: —¡Co'chi canpitaso yonquinahuano'sa pochinhuë ninama paya! ¡Caso chiníquën nanantërahuë ni'ton, nito ninorahuë! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Napotohuachina, Cotari itapon: —¡Tëhuënchachin co onpo a'pania'huainso nanitëraihuë'! ¡Co naporaihuë', co ta'cahuaiso ya'huërinhuë'! Oshahuanaiso', nani Yosë nitotërin. Ma'tana ya'huarai. Minënën maninsorë chachin asacatocoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Napotopirinahuë', Cosiriso itapon: —Co napoarinhuë'. Insosona minënëhuë quënapapisoíchin piyapinëhuë nisarin. A'napitanquëmaso', tatama ya'huërinquë noya panantaco'. Co insonta ma'sha onpotarinquëmahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Cosi napohuachina, Cotari amasha ya'carirahuaton, itapon: —Pi'piyan sinioro nonchinquën topirahuë. Yonquirahuëso no'tëquën sha'huichinquën. Quëmaso' huaraon pochachin chiníquën nanantëran. Napoaton ama no'huitonco ana'intaancoso marëhuë' napotaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","I'hua huë'naiquë, quëmaso natanancoi tatahuëi ya'huëtërincoiso'. A'na iyahuëinta ya'huëtërincoiso', natanancoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Quiyarinta naporo sha'huitëranquën: “Tatahuëi ya'huëtërincoi, nani máshoya,” itërainquën. A'na iya'huanta hui'napi ya'huëtërincoiso', sha'huitërainquën. Inaso', tatahuëi nani máshoya niso' hua'huatërin. Naporo chachin sha'huitëranquën tatahuëri na'con nosororinso'. Ina yo'nanquëranchin hua'huatopisopita cato ya'huëpirinahuë', a'naso ayarin ni'ton, inaíchin quëparitërin. Napoaton nosoromiatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Naporo' sha'huitërancoi nohuitamaso marë' quëca'huaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Napotohuatancoira, sha'huitërainquën: “Iya'huaso', co nanitërinhuë' pa'pin huëshicaso'. Huëshirin naporini, pa'pinso' sëtori tëpa'itonhuë',” itërainquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Napotopiranquënhuë': “Co'so' iya'hua quëpatamahuë', co onporonta tahuërëtaranquëmahuë',” itërancoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tatahuëitaquë canconpatoira, ya'ipi quëma napotërancoiso' sha'huitërai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","26","Hua'quimiachin quëran, tataso' camairincoi: “Pa'sahuatoma' trico pa'amantaco',” itopirincoihuë', quiyariso': “Co nanitëraihuë'. Iya'hua a'paantohuatancoi, naporo huarë' pa'sarai. Co'so' ina quëpahuatoihuë', co hua'an tahuërëtarincoihuë',” itërai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Napotohuatoira, tatahuëi sha'huitërincoi: “Canpita nitotërama sa'ahuëco' catoíchin hua'huaninso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","A'naso', ayarin. Napoaton naporo quëran huarë' co quënanchinahuë'. Pa'piniri ca'mara tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Iin ya'huërë' quëparamaquëya ma'sha onpohuachin, canpita tëhuëarama'. Canpita tëhuënëmaquë caso mashoco sëto tëpaponco huachi,” itërincoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Tatahuëso', iya'huarë' a'naíchin pochin nipi. Co'so' quiyarë' pantahuachinhuë', tatahuëso chiminapon. Quiya tëhuënëhuëiquë tata mashoyaso' sëtori tëpapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Co'huara huë'shamátërapoihuë' sha'huitërahuë: “Iya'hua a'paantohuatancoi, cari ni'sarahuë. Ma'sha onpohuachinso', ca ana'intoco huachi,” itërahuë. Naporahuaton napotomantarahuë: “Co'so' quëshintahuatënquënhuë', chiminaquë huarë' na'inarahuë,” itërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Napoaton nontaranquën natanco topirahuë. Ca iya'hua ya'huërënamën quëma piyapinën quëparichi tënahuë. Inaso iinpitarë', pananta'in. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Co'so' iya'hua pantahuachinso', co caso nanitërahuë tatahuëtaquë, pananta'huaso'. Tatahuë ma'sha onporinso', co yani'nahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ya'ipi piyapinënpita ni'tonënquë Cotari nontërinso tonitohuachina, Cosiso co huachi ahuantërinhuë'. Co huachi ahuantatonhuë', Iquipito nananquë chiníquën nonin: “¡Ya'ipinquëma pipico'!” itërin. Napotohuachina, ya'ipi piyapinënpita pipipi. Iinpitarëáchin nicaso', nohuitacaiso marë' sha'huirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Sha'huiton Cosiso', na'nëmiatarin huachi. Chiníquën na'nërin ni'ton, ya'ipi iquipitoro'sa nitotopi. Huaraon pëinënquë huarë' a'naquënso pa'sahuatona', sha'huitonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Naporo huarë' Cosiso', inahuara nanamënaquë iinpita nontërin: —¡Ca mini Cosico! ¿Nanpiárin iporahuanta tata? itërin. Napotopirinhuë', iinpitariso pa'pi të'huatatona', co nanitopihuë' nonacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Të'huatopirinahuë', Cosiriso itapon: —Ama iyaro'sa të'huatocosohuë', ya'caritoco', itërin. Naporo huarë' iinpitari ya'caririn. Ya'carihuachinara, itaantarin: —Ca mini iyaparimaco. ¿Co'ta iráca nicatono'sa Iquipitoquë huëcasoi pa'anamaco? ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Napotëramacoso marë' ama canpitaora nino'huicosohuë'. Co canpitaso yonquipiramahuë', Yosë chachin aquëchitiirinco. Notohuaro' piyapi'sa ananpicaso marë' aquëchitërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ipora huarë' iso no'paquë, cato pi'ipi nisarin tanarotopiso'. A'natërápo pi'i chachin, pahuanarin. Ina nápo pi'i sha'topirinahuënta', co manta nitërinso' macaponahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Napotëranquëmaso chachin nisarin. Yosëso nipirinhuë', aquëchitiirinco. Canpitanta shiparima ya'huëtiinquëmaso marë' naporin. Canpita chachinta', huëhuëpiro ninin quëran nicha'ëinquëmaso marë' aquëchitiirinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Inapocaso ni'ton, co canpita nohuanton isoporinquë huë'nahuë'. Yosë chachin a'parinco ni'ton, huë'nahuë. Ina nohuanton, huaraon ayonquina'pi nica'huaso marë' ya'conahuë. Ya'ipi ma'shanënpita a'paiato, piyapinënpitanta', camaica'huaso marë' ya'conahuë. Naporahuaton, ya'ipi Iquipitoquë huaraon ya'huërënamën hua'anënta'huaso marë' acorinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Manóton paantatoma', tata sha'huitonco': “Cosi ya'huëarin, iso pochin nanan a'patiarinquën: ‘Ya'ipi Iquipito no'paquë hua'anënta'huaso marë' Yosë acorinco. Manóton o'maton, ni'quimaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ya'ipi hui'nanpita, shia'huaro'sa', inapitarë chachin, o'maco'. Pë'tahuanëmapita, ma'shanëmapita, ya'ipi ya'huëtërinquëmaso', quiquiimaco'. O'mahuatama', Cosin parti acoaranquëma'. Inapohuatama', co aquëya quëranhuë' nini'sáparihua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Naro'pa huachi carima cosharo quëtáponquëma'. Ya'ipi huë'namaso nápo chachin co manta ichipahuantaranquëmahuë'. A'natërápo pi'ipi pahuanarin tanaro tahuëri'sa na'huëcaso ni'ton, napotápënquëma',’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Iya'huanta', canpitanta', ya'ipi naporahuëso', nani natanamaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Chiníquën nanantato Iquipitoquë hua'anëntërahuësonta', nani ni'nama'. Ya'ipi ni'namaso' tata sha'huitonco'. ¡Manóton paantatoma tata macontaco'!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Napotahuaton, iya'huain iporin. Ina iporin quëran na'nërin. Mincaminta', Cosi iporin quëran na'nërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ina quëran Cosiso', ya'ipi iinpita noya nontaton së'quërin. Inapitanta iporahuaton na'nërin. Ina piquëran inapitarinta co huachi të'huatatonahuë', noya nontopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Huaraon pëinënquënta', a'naroáchin nanan nincanin: “Cosi iinpita canquipi,” itopi. Ina natanahuaton, huaraonso catahuarinsopita hua'ano'sarë chachin noya cancantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Noya cancantaton huaraoniso', Cosi itapon: —Iyaro'sa sha'huitëquë', pë'tahuanënaquë trico a'mitahuatona', Canaan parti pananta'ina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Paantatona', pa'pina quëma'ina'. Ya'ipi quëmopinënpitarë chachin, o'ma'ina'. O'mahuachina', Iquipitoquë noya noya no'pa' nininso', cari quëtarahuë. Napoaton inapitaso', iso no'paquë ma'sha noya noyatërinsopita, capona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sa'ina', hui'nina', pa'pina', inapita quëmacaiso marë', camaiquë toronano'sa isëran quëpa'ina'. Sha'huitëquë a'naroáchin huë'ina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Naporahuaton, ama aquëtë ma'shanënapita yonqui'inasohuë'. Iquipitoquë ma'sha noya noya nininsopita, inapitari hua'anëntapona', itëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Napotohuachina, Cacopo hui'ninpitaso' ina inachachin nipi. Huaraon camaitërinso chachin, Cosiri toronano'sa quëtërin. Naporahuaton cosharo iraquë caracaisonta', quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","O'nanpiracaisonta', ya'ipi iinpita ananitëra'piarin. Mincaminso nipirinhuë', cara pasa coriqui prata quëran nininso' quëtahuaton, a'natërápo a'mocaso quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Pa'pionta', shonca moraquë, noya noya ma'sha Iquipitoquë ya'huërinso', a'patontarin. Naporahuaton shonca moraquë chachin, trico, pan, cosharo', inapita a'patontarin. O'mahuachina carimacaiso marë' a'patontarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pacacaiso marë' nontohuachinara, Cosiso iinpita itapon: —Osharan paco'. Amana iraquë nino'huíracosohuë', itërin. Napotohuachina pa'pi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Inapitaso', Iquipito quëran pipirahuatona', Canaan parti canconpi. Pa'pina ya'huërinquë chachin canconpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Pa'pina nontatona sha'huitopi: “¡Cosi nanpiárin tata! ¡Inari ya'ipi Iquipito no'pa' hua'anëntërin!” itopi. Ina natanahuaton, Cacoposo pa'yanënquë tachianantërin. Sha'huitopirinahuë', co natëtërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Napoaponahuë', Cosiri nanan a'patërinso natanin. Ina natanahuaton, toronano'sa quëpamacaiso marë' a'patontarinsonta', ni'nin. Naporo huarë' capa cancantomiatërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Capa cancantaton tapon: “¡Tëhuënchachin Cosi nanpiárin! Co'huara chimiantërasocohuë' pa'mato nimai,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Cacoposo' ya'ipi huëntonënë chachin pa'sarin. Ya'ipi ma'shanënpitarë' pa'sarin. Piirsipaquë canconpachinara, ma'sha tëparin. Tëparahuaton, pa'pinco' Yosë chinotërinso chachin chinotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Naporo tashi Yosëri hua'narëso pochin ya'notërin. Ya'notahuaton, nininën quëran përarin: “Cacopo” itërin. Napotohuachina, inariso itapon: —Ma'ta Sinioro ya'huarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","—Caso Yosëco. Tataparionta chinotërinco. Iquipitoquë pa'macaso marë' ama të'huaquësohuë'. Inaquë shiparinpita na'atona', panca nacion ocoiapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Canta quëmaro'co Iquipitoquë, pa'marahuë. Naporahuaton ca chachin, ina no'pa quëran shiparinpita ocoiarahuë. Inaquë chiminpatan, Cosi nocoarinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ina quëran Cacoposo', Piirsipa quëran paantarin. Hui'ninpitari toronanquë a'mitopi. Huaraoni quëpamacaiso marë' toronano'sa a'patontarinquë, inapotopi. Sa'ina', hui'nina', inapitanta a'mitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Cacoposo', hui'ninpitarë chachin pa'sarin. Hui'ninpitanta sa'ina hui'ninpitarë chachin pa'sapi. Ya'ipi inapitarë chachin pa'sápatona', Iquipito no'paquë huarë' camapi. Ya'ipi ma'shanënapitanta Canaan parti ya'huëtopiso', quiquipi. Pë'tahuanënapitanta', Ohuicaro'sa', ohuacaro'sa', chiporo'sa', inapitanta quiquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isopita, Cacopo quëran pipipisopita Iquipitoquë pa'mapi. Inapita chachin israiro'sa itopi anta': Paninantërinso', Nopino. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ina hui'ninpitaso': Anoco, Huaron, Isron, Caromi, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simion hui'ninpitanta', Quimoino, Camin, Ohuato, Caquin, Sohuaro, Saono, inapita. Saonoso', Canaan sanapiquë hui'nahuaninso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Nihui hui'ninpitanta', Coirison, Quiato, Mirari, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Cota hui'ninpitanta', Iri, Onan, Sira, Parisi, Saro, inapita. Iri, Onan, inapitaso', Canaan parti chachin chiminpiso', nani nitotërëhua'. Parisi hui'ninpitanta', Isron, Amoro, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacaro hui'ninpitanta', Toran, Popan, Copo, Simiron, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Saporono hui'ninpitanta', Siriti, Iron, Cariri, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ina nápo Cacopo hui'ninpita quëmapi'sa Niaquëya ya'huëpi. Sanapinta a'nara ya'huëtërin: Tina itërinso'. Inapitaso', Patan-aranquë ya'huapon hui'nahuaninsopita. Nia quëran pipipisopitaso', cara shonca cara ya'pi', sanapirë chachin icanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Caro hui'ninpitanta', Sipion, Aqui, Ispon, Soni, Iri, Aroti, Ariri, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asiri hui'ninpitanta', Imina, Isopa, Isopi, Piria, inapita. Oshinanta ya'huërin: Sira itopi. Piria hui'ninpitanta', Ipiri, Mariquiri, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Caro, Asiri, inapitanta Cacopo hui'ninpita Siripaquëya nipiso'. Ina quëran nipisopitaso', ya'ipiya quëran shonca saota ya'pi', icanpi. Siripaso' Napanori Nia catahuacaso marë' nicanarinso', nani nitotërëhua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Naquiranta Cacopo sa'in chachin ninin. Ina hua'huinpitanta', Cosi, Mincamin, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Cosiso', Asinaquë hui'nahuaninsopita: Manasisi, Iprain, inapita. Inapitaso', Iquipitoquë nasitopi. Asinanta', ayonquianta'inquëma'. Inaso', Potihuira hui'nin. Potihuiranta', On ninanoquë corto hua'an ya'conin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Mincamin hui'ninpitanta', Pira, Piquiri, Asipiri, Quëra, Namano, Iqui, Nosi, Mopimo, Opimo, Arato, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ina nápo Naquira quëran nipisopita ya'huëpi. Shonca catapini ya'pi ya'ipiya quëran icanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tanoso', a'naíchin hui'nahuanin: Osimo itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nipitari hui'ninpitanta': Casiiri, Coni, Quisiri, Sirimo, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tano, Nipitari inapitanta Cacopo hui'ninpita nipi. Inapitaso', Piraquëya nipiso'. Ina quëran nipisopitaso', ya'ipiya quëran canchisë ya'pi', icanpi. Piranta', Napanori Naquira catahuacaso marë' nicanarinso', nani nitotërëhua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","27","Iquipitoquë pa'mapisopita, saota shonca saota ya'pi icanpi. Ya'ipi inapitaso', Cacopo quëran pipipisopita. Hui'ninpita sa'inaso' co pichipihuë'. Cosi hui'ninpitaso' cato. Inapitaso' inaquë chachin nasitopi. Cacopo, Cosi, inapitarë' canchisë shonca ya'pi ya'ipiya quëran icanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Co'huara Cosin parti camayátërasoihuë', Cacoposo' Cota camairin: “Cosi sha'huitëquë huë'in, Cosin parti nacapi'inco,” itërin. Inaquë Cota paaso', Cacoposo ya'ipi huëntonënë chachin Cosinquë camapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Iin cantomarahuaton Cotaso', pa'pini nanan a'patërinso sha'huitërin. Sha'huitohuachina Cosiso', a'naroáchin piyapinënpita camairin toronanën tapacaiso marë'. Inaquë huënsërahuaton, Cotarë chachin pa'nin. Pa'sahuaton pa'pin quënanconpachina, iporin. Iporinquëranchin hua'qui na'nërárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Naporo' Cacopori, itapon: —Ayapiranhuë', quënaantaranquën ni'ton: ¡Iporaso' chiminpatonta noyatapon huachi tënahuë! tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pa'pin nani nontahuaton Cosiso', ya'ipi iinpita, quëmopinënpita inapita itapon: —Huaraon nicapo pa'sarahuë. Pa'sahuato itapo: Ya'ipi quëmopinëhuëpita Canaan parti ya'huëpirinahuë', yacapainacoso marë' o'mapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ohuacanënapita, ohuicanënapita, ya'ipi ma'shanënapita quiquiimapi. Inapitaso pë'tahuatona'piro'sa', itarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Napotohuato, huaraon përasarinquëma'. Përatënquëma' maquësona sacatëramaso' natanpachinquëma': “Quiyaso', shimashonëhuëipita pochachin, ohuica pë'tahuana'piro'sacoi,” itoco'. Napohuatama', Cosin partiquë ya'huapoma'. Iquipitoro'saso', ohuica pë'tahuana'piro'sarë', napopináchin ya'huëcaiso', na'in. Napohuatama', canpitaráchin inaquë ya'huapoma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Cosiso', pa'pin, iinpita, inapita nontahuaton huaraon sha'huitapon pa'nin: “Tatahuë, iyahuëpita, inapita Canaan parti quëran o'mapi. Ya'ipi ohuicanënapita, ohuacanënapita, ma'shanënapita, inapitarë chachin o'mapi. Nani Cosin parti niquipi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ina piquëran a'natërápo iinpita huayonin. Huayonahuaton, huaraoni nohuitacaso marë' quëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Naporo' inari natanin: —¿Maquëta canpitaso sacatërama'? itërin. —Quiyaso' quëma piyapinënpita pochincoi ninai. Shimashonëhuëipita pochachin ohuica pë'tahuatona'piro'sacoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Canaan parti ya'huëpiraihuë', na'con tanarotërai. Pastonta', ohuicaro'sa capacaiso', yanirin. Napoaton no'panënquë o'marai ya'huapoi. Yosë marë' nohuantëquë', Cosin parti ya'huë'i topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Napotohuachinara, huaraoniso' Cosi itapon: —Yacapainënquënso marë' tataparin, iyaparinpita, inapita o'mapi. Nani o'mapi ni'quëhuarë', ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ya'ipi Iquipito no'pa' hua'anëntërahuëquë, noya inapita ya'huëcaiso'. Cosin parti noya noya no'pa' ninin. Inaquë ya'huëcaiso marë' quëtëquë'. A'naquën quëmopinënpita pë'tahuatacaso' noyá nitotohuachina', caquën pë'tahuanëhuëpita, a'paicaiso marë' acoquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ina piquëran Cosiso', huaraon anohuitacaso marë' pa'pionta quëparin. Cantontahuaton Cacoposo', monsho tënin, nontacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Huaraoni ni'sahuaton natanin: —¿Onpo pi'ita ya'huëtërinquën? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","—Nani pasa cara shonca pi'ipi ya'huëtërinco. Co ya'huëmia ya'huëatohuë', patë patë́rantarahuë. Inapoato na'con parisitërahuë. Shimashonëhuëpitaso', na'con na'con tahuëri ni'pi. Co caso inapita icantapohuë' nimara tënahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Cacoposo nani huaraon nontahuaton, Cosirë chachin pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ina quëran Cosiso', Iquipitoquë noya noya no'pa' nininso' quëmopinënpita quëtërin. Huaraoni camairinso chachin ninin. Inapoatona Cacoposo' hui'ninpitarë chachin Namisi parti no'pahuanpi. Namisiso', Cosin itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Naporahuaton Cosiso', ya'ipi quëmopinënpita cosharo quëtárin. Panca huënton nininso' na'con na'con, quëtërin. Caraya nininso', pi'piyan quëtërin. Inapotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Co insëquë tëranta trico ya'huërinhuë'. Napoaton na'con na'con tanarotopi huachi. Canaan partiquënta', Iquipitoquënta', piyapiro'sa tanari tiquirarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Inaquëpita ya'huëpisopita, Cositaquë trico pa'anápirinahuë', nii'quianapi huachi. Ya'ipi coriqui trico marë' pahuërëtopiso', Cosiso yontonin. Yontonahuaton huaraon pëinënquë taparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Canano'sa', iquipitoro'sa', inapita coriquinëna i'quihuachinara, iquipitoro'saso', Cosi nontapona pa'pi: —¡Yosë marë' cosharo quëtocoi! Capa nii'quianarai huachi. Capa coriqui ni'ton, co huachi cosharo quëtohuatancoihuë', tana tëpaponcoi quiyaso'. Ina marë' quëmanta co huachi noya nisaranhuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","—¡Naporinchi paya! Capa coriquinëma ni'quëhuarë', pë'tahuanëmapita nipachin quëco'. Ina quëpatama', trico quëtarainquëma', itërin Cosiri. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Napotohuachina iquipitoro'saso', pë'tahuanëna quëshipi: Cahuarionëna', ohuicanëna', ohuacanëna', moranëna', inapita quëshipi. Inapita marë' naporo pi'iquë trico canpiatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ina pi'i na'huëanatopi. A'na pi'i maantarinquë naquëranchin iquipitoro'saso', Cosi paapantapi nontaantacaiso marë': —Nani quëma nitotëran capa coriqui ya'huëtërincoisohuë'. Ya'ipi pë'tahuanëhuëipitanta canpitanquën ninin. Co huachi ma'sha tëranta ya'huëtërincoihuë' pahuërëta'huaiso'. No'panëhuëíchin ya'huërin. Naporahuaton quiyanta ya'huëarai. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Quiyaora chachin nipachin, no'panëhuëirë'coi pa'ancoi. Ina ya'huërënamën trico quëtocoi. Inapohuatoi huaraon piyapinënpitacoi nisarai. Ina marë' no'panëhuëiquë chachin sacachi. Cosharo quëtohuatancoi, no'panëhuëiquë sacatarai ni'ton, co nitapiarinhuë'. ¡Taquihuatoiso', no'panëhuëinta' pantatarin. Inapohuatoi, quëmanta co manta canaponhuë'! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Napotohuachinara, Cosiso ya'ipi iquipitoro'sa no'panëna huaraon marë', pa'antëra'piarin. Co manta capacaisohuë ni'ton, no'panëna pa'ana'piapi. Inapopi ni'ton, ya'ipi Iquipito no'pa', huaraoni hua'anëntërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Naporahuaton ya'ipi Iquipito no'paquë iquipitoro'sa ya'huërinso', Cosiri pa'anaton piyapitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Corto hua'ano'sa no'panënáchin co Cosiri pa'antërinhuë'. Inapitaso' huaraoni topinan trico quëtárin ni'ton, co no'panëna pa'anacaiso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ina quëran Cosiri piyapi'sa itapon: —Iporaso', huaraon hua'anëntërinquëma huachi. No'panëmanta hua'anëntërin. Ma'tana ya'pirin ya'huëarin quëpatoma', sha'co'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Napoaponahuë', sha'namaso' nanitohuachin, a'natërápo costaro quëran a'na costarora huaraon quëtamaso ya'huërin. Catapini costaroso nipirinhuë', canpitaora marë' nisarin. Hui'namapita, yacaparinquëmasopita, inapitanta capacaiso marë' nisarin. Naporahuaton ina quëran chachin shacacamaso ya'huërin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Napotohuachina, inapitaso taantapi: —Noyapa'. Inapochin nisarai. Quëmaso noya piyapinquën ni'ton, tana tëpaincoiso nipirinhuë', nicha'ërancoi. ¡Huaraon nipachin piyapichincoi! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Inapoaton Cosi camaitërin ya'ipi Iquipito no'paquë piyapinënpita ma'sona nicacaiso'. Sha'topiso nanitohuachina, a'natërápo costaro quëran, a'nara huaraon quëtacaiso ya'huërin. Iso quirica ninshitasoco huarënta', ina camaitërinso', ipora huanta Iquipitoquëso ina chachin nisapi. Corto hua'ano'saso nipirinhuë', co huaraon marë' quëtacaiso ya'huërinhuë'. Inapita no'panënaso', co huaraoni pa'antërinhuë' ni'ton, co quëtopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israiro'saso', Iquipito no'paquë ya'huëapi huachi. Cosin parti no'pa' mapi. Inaquë ya'huëapona pochin na'amiatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Cacoposo shonca canchisë pi'ipi, Iquipitoquë ya'huëantarin. Ya'ipiya quëran pasa catapini shonca canchisë pi'i icanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A'na tahuëri Cacoposo', nani chiminacaso ya'caritërin ninatanin. Napoaton Cosi sha'huitacaso marë' a'nara a'parin. Huë'pachina, itapon: —Tëhuënchachin nosorohuatanco, nohuantërahuëso' niquë'. Ina yanipatanso', tonaroana së'huatoco. Së'huatatonco: “Yoscoarë' nohuantëranso' nisarahuë,” itoco'. ¡Caso chiminpato, ama Yosë marë' isëquë pa'pitocosohuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Shimashonëhuëpita quënancona'huaso tahuëri nanitohuachinco, Iquipito no'pa quëran quëpaco. Quëparahuatonco, inapita po'mopiquë, canta po'moontaco, itërin. —Noyapa'. Inapochinquën nipachin, itërin Cosiri. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","—Yoscoarë' inapochinquën itoco, itaantarin pa'pini. Napotohuachina, Cosiso': “Yoscoarë' inapotaranquën,” itërin. Ina natanaton, Cacoposo, pë'saranënquë huënsërin. Inaquë huënsërin quëran, “Yosparinquën,” ta'caso marë' mónsho tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ina piquëran miachin Cacoposo' caniorin. Napohuachina Cosi sha'huitopi. Ina natanahuaton, nicapon pa'nin. Hui'ninpitanta cato chachin quëparin. Manasisi, Iprain, inapita. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Cosiri nicapon huë'ninso sha'huitohuachinara, chiníquën cancantaton pë'saranënquë huënsërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","Cosiso', hui'ninpitarë chachin ya'coontarahuaton pa'pin nontoonin. Ina quëran Cacoposo' Cosi itapon: —Yosë ya'ipi nanitaparinso', Noso ninanoquë ya'notërinco. Inaso ninano', Canaan parti ya'huërin. Ya'notahuatonco, iso pochin noya ya'huëca'huaso marë' sha'huitërinco: “Ni'quë'. Ca nohuanto, notohuaro' hui'nanpita ya'huëtarinquën. Quëmá quëran pipipisopita, na'a naciono'sa ocoyapona'. Naporahuaton, inapita, iso no'pa' quëtarahuë. Inapitari hua'anëntomiatapona',” itërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Hui'nanpita Iprain, Manasisi, inapitaso co'huara yacapaponquën huë'shamátërasocohuë' ya'huëtërinquën. Inapitaso' caquën nicapona'. Napoatona', Yosë no'pa' hua'anënta'huaso sha'huitërincoso', hua'anëntapona'. Nopino, Simion, inapita pochin ni'tona', hua'anëntapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Inapita piquëran hui'nahuanpatan, quëmaoranquën nisapi huachi. Inapitaso' Iprain, Manasisi, inapita iya'huainpita nicapona'. Ina ni'tona iin mashonëna no'panëna quëran, inapitanta', no'pa' macapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Co topinan napotaranquënhuë'. Mamaparin co aquëtë hua'huaninso marëhuë', napotaranquën. Quëmanta nani nitotëran: Patan-aran quëran huënantasëhua', Canaan parti quëmaquën mama tëparëhua'. Iporata ninano ya'cariya nicasëhua', chiminin. Chiminpachina, inaquë chachin ira pirayan pa'pitërëhua'. (Ina ninanoso', ipora marë' Pirin itopi anta'.) ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ina ta'sochachin a'nanaya Cacoposo' tahuërëtahuaton ni'pirinhuë', Cosi hui'ninpita quënanin. Inapita quënanaton, hui'nin natanin: —¿Inpitata isopitaso'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","—Isopita mini hui'nahuëpita. Yosë nohuanton naro'pa' ya'huëtërincoso', itërin Cosiri. —Amashachin aya'carico. Noya ya'huëcaiso marë' sha'huichi, itaantarin Cacopori. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Cacoposo' noyá mashoya ni'ton, co huachi ina inahuë quënantërin. Napoaton Cosiri hui'ninpita aya'caririn. Napohuachinara, Cacoposo shinpita iporahuaton apinorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ina quëran Cosi itapon: —Co huachi onporo tëranta quënana'huanquënso' yonquipirahuë', Yosë nohuanton hui'nanpitanta quënanahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Pa'pin to'topitënquë hui'ninpita huënsëápirinahuë', Cosiri ahuanirin. Ahuanirahuaton, pa'pin notënanquë isonin. Isonin quëran no'paquë huarë' monshorin. Noya nicaton napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ina quëran cato hui'ninpita chachin manin. Iprainso', inchinanën quëran së'quërin. Ya'huërë' Manasisiso' ahuënanën quëran së'quërin. Inapo së'quërin quëran pa'pin aya'caririn. Napoaton Iprainso', shiin ahuënanën quëran acorin. Ya'huërë' Manansisiso', shiin inchinanën quëran acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Cacoposo nipirinhuë', tanpaquënpita chi'huaratahuaton, inchinanën quëran Iprain së'huamotorin. Manasisiso paninan nipirinhuë', ahuënanën quëran së'huamotorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Inaporahuaton Cosi noya ya'huëcaso marë' iso pochin sha'huitërin: “Shimashonëhuëpita Apraan, Isaco, inapita Yosë natëpi. Canta hua'huatërahuë quëran huarë' ina chachin noya a'pairinco. Ina Anquëninën chachin ya'ipi ma'sha onporahuë quëran, nicha'ërinco. Inari chachin isopita hui'napi'sa catahuain. Notohuaro' hui'ninpita ya'huëchina'. Hua'huayátërahuë, isoro'paquë na'aina'. Inapita nicatona piyapi'sa', yonqui'inaco. Tata Isaco, tata masho Apraan, inapitanta yonqui'ina',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Cosiso nipirinhuë', paninantërinso' ahuënan quëran shiini së'huamotorinso' ni'nin. Ina nicaton co noyahuë' cancantërin. Napoaton pa'pin inchinan imirin masahuaton, Iprain motën quëran chi'huincatërin. Chi'huincatahuaton Manasisi motënquë acotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Inapoapon pochin pa'pin itapon: —Co tata. ¡Ama inapoquësohuë'! Isocha paninanso'. Inchinan imira quëran, ina së'huamotoquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pa'pinso nipirinhuë', co nohuantërinhuë' inapocaso'. Napoaton itapon: —¡Naporin mini conpa, nani nitotërahuë! Manasisinta shinpita quëran panca nacion nisarin. Iyaa'huainso napoaponahuë', noya noya nicaton shinpita quëran na'con na'con naciono'sa pipiarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Naporo tahuëri chachin, Cacopori shinpita nóya yonquirapiton iso pochin sha'huitërin: —Israiro nacionquë ya'huëpisopita noya ya'huëcaiso marë' yasha'huitohuachina', canpita nininëma yonquiatona iso pochin sha'huitapona': “Yosë quëmanta catahuainquën. Iprain, Manasisi, inapita catahuarinso pochachin catahuainquën,” niitapona', itërin. Inapoaton, Cacoposo Iprain'ton acorin. Manasisiso nipirinhuë', piquëran acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ina quëran Cosi tahuërëtahuaton itapon: —Ni'quë'. Caso chiminapo huachi. Yosëso nipirinhuë', ya'huëmiataton catahuarinquëma'. Inari chachin shimashonëma no'panënquë quëpanantaponquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Quëmaso' ya'ipi iyaparinpita quëran, panca pancana no'pa' quëtëranquën. Siquimo motopi quëtëranquën. Inaso' no'pa', amororo'sa ahuëato osërëtërahuëso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nani shinpita noya ya'huëcaiso marë' sha'huitohuachina, Cacoposo' ya'ipi hui'ninpita amatërin. Huë'pachinara itapon: “Amasha ya'carico conparo'sa'. Ma'sona a'na tahuëri onpocamaso', carinquëma sha'huichinquëma natanco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Canpitaso hui'nahuëpitanquëma'. Caso Cacopoco niporahuë', Israiro itërinaco anta'. Carima sha'huitaranquëma ni'ton, natanco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","‘Quëmaso' Nopino, paninanquën. Chiníquën nisoco, ya'nan hui'nahuananquënso'. Chini chiníquën nanantaton, noya noya nicamaso' ninan. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Inapocamaso nipiranhuë', co huachi inapoaranhuë'. I' pa'pi chinii' nipachina, co onpo asanoirëhuë'. Ina pochachin nicaton cosonanëhuë monshitëran,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","‘Simion, Nihui, canpitaso, napopináchin cancantërama'. A'napita ma'sha onpotamaso marë' nisha nisha ohuararama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Niyontonamaquë, ama onporo tëranta ya'noisohuë'. No'huitatoma piyapi tëparama'. Co natantonquëmahuë' nicatoma', tororo'sa nishitëtëntëntërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tanan ni'niro'sa pochin no'huitërama'. Napopiramahuë', co onporonta inachachin nisápomahuë'. Carima ya'ipi Israiro nacionquë, ayanquëmiataranquëma',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","‘Quëmaso' Cota, iyaparinpita pa'yataponën. Inimiconënpita minsëra'piapon. Iyaparinpita quëran huarë' moshaponën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Quëmaso' conpa masho, Cota itëranquën. Pa'pinia'hua pochin chinimiatëran. Mapintahuaton pa'pini' pë'inihuachina, mónsho mónsho tërarinquëran quëhuënin huachi. Panca pa'pini' pochin ninan. ¡Pa'pini' chinotaso', co incari tëranta apisarinhuë'! Inapochachin quëmanta inimiconënpita nitaponën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Co inso tëranta hua'an quëran, quëmaso' Cota, ocoiarinënhuë'. Huara së'quëranso co insonta mataponënhuë'. Hua'anën chachin o'maquë huarë' co nanitapaponënhuë'. Ina o'mahuachin, ya'ipi naciono'sari natëpona huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Cotaso notohuaro' oparohuanaton, mora'huanënta', co apiratarinhuë'. Inaquë capacaso marë' a'sonpitërapon. Huinoquë chachin a'morinso pë'sapon. ¡Opa huayo no'huiquënquë chachin, inapotapon! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ya'pirinpitanta', huino quëran quëhua quëhuashin ninin. Natëquënpitanta', sho'shoi' quëran huiri huiríchin ninin,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","‘Quëmaso' Saporono, marë yonsan parti ya'huapon. Panca nancharo'sa nonshinanëna ya'huërinquë, ya'huëapon. No'panënso', Sitonquë huarë' naniarin,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","‘Quëmaso' Isacaro, chiníquën mora pochin nisaran. Pë'tahua pëiro'saquë pë'pëtëranquëranchin chinotaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","“¡Noyachi iso no'pa' paya! Yashi yashin chinochachináchin,” tëcapon. Co pahuërëpirinënhuë', noya cancantaton patron marë' sacataran,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","‘Quëmaso Tano, quëmaora huëntonënquë ya'huëpisopita catahuaran. Nanan ya'huëtohuachina', anoyatacaiso catahuaran. A'napita Israiro huëntono'sa pochachin nisaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ya'huan yaquëtëtërinso pochin nisaran. Inaso', ira pirayan yamorin quëtëtacaso marë'. Cahuario tocanën quëtëhuachina, piyapi ya'mitërinso', anotapon. Inapochachin quëmanta', inimicoro'sa nitaran,’ ” itërin Cacopori hui'ninpita nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ina quëran Cacoposo' Yosë nontaton tapon: “¡Sinioro, quëmaso' nicha'ësaranco tënahuë!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","A'napita hui'ninpitanta yonquiaton taantarin: “ ‘Quëmaso Caro, matararoro'sa huënton ya'contarinquën. Quëmariso napoaponahuë', nita'atahuaton imasaran,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","‘Quëmaso' Asiri, noya noya cosharo ya'huëtarinquën capacaso'. Copirnoro'sa ca'ninso pochin ca'sápon. Napoaton quëmari quëtohuatan inapitanta ca'sapi,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","‘Quëmaso' Nipitari, co camainënquënso costaponhuë'. Tanan yo, noyanpia'huaráchin hua'huinpitarë' pa'ninso pochin nisaran. Inapochachin quëmá quëran pipipisopitanta', na'a nisahuatona', noyanpia'huaráchin nicapona',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","‘Quëmaso Cosi, i'sha yonsanquë huayo huanirinso pochin ninan. Inaso' huayo pa'pi notohuaro' nitërin. Së'paquënpitanta', paira pa'tërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Pë'chinan camayoro'sa', no'huirinquën. No'huitënën pë'chinan shinërëquë yaohuaninën. Napotatënën, co noya quëran ya'huëchináchinhuë nitarinën. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Quëmaso nipirinhuë', chini chiníquën tanpatëran. Pë'chinanënquë inimicoro'sa të'yanantohuatan, co pacoitaranhuë'. Yosë imarahuëso', chini chiníquën nanantërin. ¡Ina catahuarinquën inimicoro'sa minsëaran! Sinioroso' ohuica hua'anën pochin ni'ton, a'pairinco. ¡Ina chachin quëmanta a'paiatënquën catahuarinquën! ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yosënëhuë chachin, catahuapënquën. Inaso', ya'ipi nanitapaton catahuapënquën. Ina nohuanton, o'nanpachina catahuainquën. Acoporonta i' ya'huërinso', ina nohuanton pipiton catahuainquën. Pë'tahuanëmapita, sanapinëmapita, inapitanta huaihuachina catahuain. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tata mashocoro'sa iráca, noya ya'huëca'huaso marë' sha'huitërinaco. Carinquënso', ipora noya noya sha'huitaranquën. Motopiro'sa ya'huërárinso ta'huantaquë huarë', Yosë catahuaráponquën. A'napita iyanpita quëran, noya noya nicatënquën huayonanquën. Napoaton së'huamotorahuatënquën quëma marë' Yosë nontërahuë,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","‘Quëmaso' Mincamin, pa'pi mapinton tanan ni'nira pochin nicapon. Tashiramiachin inaso mapintahuaton, ca'miatërin. Naporo' i'huanahuanquë chachin pë'sotërinsonta', a'napitari ca'papi. Inapochachin quëmanta', yaata'huantëransopita nitaran. Inapotahuaton ma'shanënanta', nipatomatapoma',’ ” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ina pochin Cacopo shonca cato hui'ninpita noya ya'huëcaiso marë' sha'huitërin. Inapita quëran shonca cato Israiro huëntono'sa pipipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","A'na tahuëri Cacoposo', hui'nipita camairin: “Co hua'quiya quëranhuë' chiminarahuë huachi. Chiminpato, shimashonëhuëpita pa'pitopiso pirayan po'moontaco. Iti huënton piyapi, Ipron itopisori, ina no'paso' hua'anëntopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Maquipiraquë nanin ya'huërinso yonquiato napotarahuë. Inaso', Canaan parti ya'huërin. Mamiri notënanquë ya'huërin. Ina no'pa' mini iráca tata mashoco Apraan nipa'pitacaiso marë' pa'anin. Ina pirayan no'pa' ya'huërinsorë chachin naporo Ipron pa'antërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Inaquë Sara, Apraan, inapita chiminpachinara ya'conpi. Tata Isaco, mama Nipica inapitanta inaquë chachin ya'conpi. Inaquë canta', sa'ahuë Nia itërahuëso ya'conin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ina no'paso' naninë chachin, Iti huënton piyapi'sa pa'antopi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Cacoposo' hui'ninpita camairinso tonitohuachina, pë'saranënquë quëhuëantarin. Quëhuënaso chachin, chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Pa'pin chiminpachina Cosiso', ina nonën iporin quëran na'nërin, apinorin, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ina quëran notoronënpita camairin pa'pinco' nonën tapacaiso'. Camaihuachina, ama chanatacaso marëhuë' taparapi. Pa'pincoso', Cacopo itahuatona', Israiro itopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Catapini shonca tahuëri quëran nonën tapapi huachi. Ina nápo tahuëri nohuantërin tapacaso marë' ni'ton, ina nápo tahuëri sacatopi. Iquipitoro'saso', canchisë shonca tahuëri Cacopo marë' sëtopiso' imapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Ina tahuëri'sa na'huëhuachina, Cosiso' huaraon catahuapisopita hua'ano'sa', nontërin: —Tëhuënchachin noya ni'patamaco, ca marë' huaraon nontoonco'. Naporin Cosi: “Co'huara tata chiminyátëraponhuë', camairinco Yoscoarë' ta'to natëca'huaso': ‘Nipa'pita'huaiso marë' taparahuëquë chachin, po'moontaco. Inaso', Canaan parti ya'huërin,’ itërinco. Quëtoco paato tatahuë pa'pitonta'i, topirahuë. Nani pa'pitontahuato, o'mantarahuë tënin,” itoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Sha'huitohuachinara, huaraoniso hua'ano'sa itapon: —Cosi sha'huitonco': “Paaton tataco', pa'pitontaquë'. Sha'huitërinquënso chachin nitontaquë',” itoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","Huaraoni napotohuachina, Cosiso', pa'pin pa'pitacaso marë' pa'nin. Ya'ipi copirno catahuapisopita hua'ano'sa pa'pi. Iinpitanta', quëmopinënpitarë chachin pa'pi. Cosin partiso', hua'huaro'saráchin pë'tahuaro'sa a'paicaiso marë' patopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sontaro'santa', a'naquën toronano'saquë, a'naquënso cahuarioro'saquë, Cosi ca'tanpi. Napoaton hua'huayátërahuë piyapi'sa pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pa'sápatona', Corin-a-atatiquë canconpi. Inaquë niyontonatona panca sëtopi. Inaquë Cosi pa'pin marë' canchisë tahuëri sëtërinso', naniantarin. (Corin-a-atatiso', trico to'norapiquë) Ina no'pa quëranso', Cortanii' pi'i ya'coninso parti acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Canano'sa inaquë ya'huëpisopitari, napopiso ni'pi. Ina ni'sahuatona', inahua capini ninontopi: “Iquipitoro'sa pa'piapona huëcatona', panca sëtapi,” topi. Napoaton ina no'paso', aninihuanpi: Apiri-misraimo, itopi. Iquipitoro'sa sëtopiquë, tapon naporin. Ina no'pa quëranso', Cortanii' pi'i ya'coninso parti acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Cacopo hui'ninpitaso', pa'pin nanpipon camaitërinso chachin ya'ipi nipi. Canaanquë quëpantarahuatona', Maquipiraquë nanin ya'huërinquë po'moontapi. Iti piyapi, Ipron itopisori, ina no'paso' hua'anëntopirinhuë', Apraani iráca nipa'pitacaiso marë' pa'antërin. Ina naninso no'parë chachin, Mamiri ya'huërin quëran, pi'i pipirinso parti quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nani pa'pin po'oroquë po'mohuachinara, Cosiso' iinpitarë chachin Iquipitoquë pa'mantapi. Ya'ipi ca'taninsopitanta', pa'mantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Cacopo chiminpachina Cosi iinpitaso', ina të'huatatona inahua capini ninontopi: “Iráca aparisitërëhuaso marë' tapona Cosi no'huitonpoa yai'huërëtápirinpoahuë',” niitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Ina yonquiatona', iso pochin nontacaiso marë' a'napita a'papi: “Co'huara tata chimiyantëraponhuë', camairincoi nonta'huainquënso': ‘Iyaparinpita aparisitopirinënquënhuë', co noyahuë' nicatona oshahuanpiso', Yosë marë' naniantëquë',’ itoco', itërincoi. Napoaton, quiyarionta nontarainquën nanan anoyataancoiso marë'. Quiyanta', tatanpoa chinotërinso Yosë chachin imarai ni'ton, inapotocoi,” itopi. Napo nontasoi', Cosiso na'nërarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Naporo chachin iinpitanta', canquipi. Canquihuachinara, isonpi quëran no'paquë huarë' monshorahuatona', moshaipi. Mosharahuatona', itopi: —Ma'tana iya, ya'huarai. Hua'anëntatoncoi yacamaihuatancoi, inapotocoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Napotopirinahuë', Cosiriso itapon: —Ama iyaro'sa pa'yancosohuë'. Caso piyapico ni'to, co nanitërahuë' Yosë ya'huërënamën pochin nica'huaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Canpitaso mini, ma'sha onpotamacoso yonquipiramahuë', Yosëso nipirinhuë', inaporamaso anoyatërin. Ama notohuaro' piyapi'sa taquicaiso marëhuë', inaporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Napoaton ama pa'yancosohuë'. Carinquëma cosharo quëtáponquëma'. Hui'namapitanta quëtapo. Naponontaton, Cosiso iinpita asanocancanin. Noyasha nontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Cosiso iinpitarë chachin, Iquipitoquë ya'huëhuantopi huachi. Inaso', pasa shonca pi'i icanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Hua'qui ya'huaton, Iprain hui'ninpita ni'nin. Inahuanta hui'nahuanpiso shi'ahuainpitaquë huarë', ni'nin. Naporahuaton Manasisi shiin Maquiri itopiso hui'ninpitanta', macaton aso'sorin. Ina marë' to'topitënquë ahuënsëra'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","A'na tahuëri Cosiso', iinpita itapon: “Co hua'quiya quëranhuë', chiminapo huachi. Napoaponahuë', Yosëso catahuainquëmaso marë' o'mararin. Iso no'pa quëran ocoiarinquëma'. Apraan, Isaco, Cacopo, inapita quëtacaso marë' sha'huitërinso no'paquë, quëpantarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ina quëran iinpita camairin: “Yoscoarë' ta'toma', nohuantërahuëso nitoco,” itërin. Napotohuachina: “Yoscoarë' nohuantëranso', nisarai,” itopi. Naporo' Cosiri itapon: “Tëhuënchachin Yosë o'mararin catahuainquëmaso marë'. Ina tahuëri nanihuachin, nansënëhuë isëquëran quëpanantamaso ya'huërin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Pasa shonca pi'ipitaso', Cosi Iquipitoquë chiminin. Chiminpachina, nonën ama chanatacaso marëhuë taparahuatona', a'na atahuaroquë po'mopi. Ina pochin Cacopo hui'ninpita nipi.");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Quisocristo nanamën sha'huitaranquëma'. Inaso' Yosë hui'nin. Iráca quëran huarë' Yosë yonquirin ina a'paimacaso marë'. Tapico chachin Quisocristo shimashonën. Apraanconta' shimashonën chachin. Ya'ipi shimashonënpita iráca ya'huëpiso' sha'huichinquëma', nitotoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iráca Apraan hui'nahuanpachina, Isaco itopi. Ina quëran Isaconta' hui'nahuanpachina, Cacopo itopi. Cacoposo' na'a hui'ninpita ya'huëtërin. A'naso' Cota itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Cotanta' hui'nahuanpachina, Parisë, Saro, inapita itopi. Tamara hua'huinpita inahuaso'. Ina quëran Parisë hui'nahuanpachina, Isromo itopi. Inanta' hui'nin ya'huëtohuachina, Aramo itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramonta' hui'nahuanpachina, Aminatapo itopi. Ina hui'nin Nasono itopi. Nasononta' hui'nahuanpachina, Sarëmon itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarëmon yasa'apachina, Nacapa manin. Hui'nin ya'huëtohuachina, Pooso itopi. Poososo' Rota macaton, hui'nahuanin. Opito itopi. Opitonta' hui'nahuanpachina, Quisi itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Quisinta' hui'nahuanpachina, Tapi itopi. Inaso' copirno ya'conin. Ina quëran Oriasëco' sa'in masahuaton, hui'nahuanin. Saromon itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromon hui'nin Nopoamo itopi. Ina hui'nin Apiasë itopi. Apiasënta' hui'nahuanpachina, Asa itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa hui'nin Cosahuato itopi. Cosahuatonta' hui'nahuanpachina, Coramo itopi. Ina hui'nin Osiasë itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiasënta' hui'nahuanpachina, Cotamo itopi. Ina hui'nin Acaso itopi. Acasonta' hui'nahuanpachina, Isiquiasë itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ina hui'nin Manasisë itopi. Inanta' hui'nahuanpachina, Amon itopi. Amon hui'nin Cosiasë itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ina hui'nin Quiconiasë itopi. Iinpitanta' ya'huërin. Naporo' cotioro'saso', inimicoro'sari Papironia quëran huëcatona', canaipi. Minsërahuatona', napopinchin ya'huëpi'pa' quëpapi asacatacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ina piquëran Quiconiasë hui'nahuanpachina, Saratiri itopi. Ina hui'nin Soropapiri itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Inanta' hui'nahuanpachina, Apioto itopi. Apioto hui'nin Iriaquimo itopi. Ina hui'nin Asoro itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoronta' hui'nahuanpachina, Satoco itopi. Satoco hui'nin Aquimo itopi. Ina hui'nin Irioto itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iriotonta' hui'nahuanpachina, Iriasaro itopi. Iriasaro hui'nin Matan itopi. Ina hui'nin Cacopo itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Cacoponta' hui'nahuanpachina, Cosi itopi. Cosi yasa'apachina, Maria manin. Ina hua'huinso' Quisoso, Cristo itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nani Quisocristo shimashonënpita sha'huitëranquëma'. Apraan quëran Tapi copirno ya'conaquë huarë' shonca catapini shimashonënpita ya'huëtërin. Ina quëran Papironiaquë quëpai huarë' shonca catapini shimashonënpita ninshitantaranquëma'. Ina quëran Quisocristo nasitaquë huarë', shonca catapini chachin shimashonënpita ninshitantaranquëma huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Apira Quisocristo nasitërinso' sha'huichinquëma', nitotoco'. Naporo tahuëri'sa' Cosiso', nani Maria nontërin macacaso marë'. Napoaponahuë' co'huara mashatërasohuë', Ispirito Santo nohuanton inaora cayorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Cosi nitotahuaton, pa'yanin. Noya quëmapi ni'ton, yonquiarin. “¿Ma'cha onpo'iya? Maria nani hua'hua ma'patërin. Co maca'huaso' ya'huërinhuë'. Co piyapi'sa' sha'huitarahuë', Maria tapanpachin. Coisëichin sha'huitahuato, co masarahuë',” ta'ton, yonquirárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huë'ëso', Yosë anquëninëni ya'notimarin nontacaso marë'. —Tashita Cosi. Carinquën nohuitëranquën. Quëmaso' Tapico' shinquën. Pi'pian sha'huitaponquën o'marahuë. Maria noya maquë'. Co quëmapiri së'huarinhuë'. Ispirito Santo nohuanton, inaora cayorin. Napoaton noya maquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Huaicaso' nanihuachin, quëmapia'huaya nasitapon. Nasitohuachin, Quisoso itëquë'. Piyapinënpita oshanëna' inquitaton, nicha'ësarin ni'ton, ina nininën acotëquë', itërin anquëniri. Itahuaton, panantarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iráca Yosë nohuanton, pënëntona'pi ninorin. Ninoton, Yosë quiricanënquë chachin ninshitërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“A'na tahuëri nanon inaora cayoapon. Co quëmapiri së'huapirinhuë', napoapon. Quëmapia'huaya huaihuachin, Imanino itapi,” tënin. Yosë chachin o'maton, yacaparinpoa', tapon naporin. Ina pochin nasitimahuachina, iráca ninopiso' nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cosiso' capayatahuaton, Sinioro anquëninën natëton, Maria manin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Macaponahuë', co ichihuë'ërinhuë'. Hua'huin nasitërin piquëran huarë' ichihuë'ërin. Quëmapia'huaya nasitohuachina, Quisoso itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Quisososo' Pirinquë nasitërin. Cotia parti chachin nasitërin. Naporo' Irotisëri inaquë hua'anëntërin. Ina quëran tayora nitotona'piro'sa' canquipi. Pi'i pipirinso parti quëran huë'pi. Canquihuachinara, Quirosarinquë, natantiipi: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—¿Insëquëta' nasha copirno nasitërin? Cotio copirno ya'conacaso' nani nasitërin ipora. Ya'huërai parti ya'huasocoi, nasha tayora ya'norinso' quënanai. Ina nicatoi: “Yosëri a'paimarinso' nasitërin huachi,” ta'toi, huë'nai ina chinotapoi, itëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ina natantahuaton, copirno Irotisë pa'yanin. Quirosarinquë ya'huëpisopitanta' pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Copirno pa'yanaton, cotio maistro'sa', corto hua'ano'sa', inapita amatërin. Amatahuaton, natanin. —¿Insëquëta' Cristo Yosëri a'paimarinso' nasitapon? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Cotia parti chachin nasitapon. Pirinquë nasitapon, itopi. Iráca pënëntona'pi ninoton, Yosë quiricanënquë ninshitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Cotiaquë a'na ninano' ya'huërin, Pirin itopiso'. Co panca ninanoyahuë' niponahuë', inaquë a'na copirno nasitapon. Na'a copirnoro'sa' Cotia parti ya'huëpirinahuë', inaso' chini chiníquën nanantapon. Ya'ipi piyapinëhuëpita israiro'sa' itopiso' hua'anëntapon,” tënin Yosë, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Copirnoso' natanahuaton, co a'ninquëchin yanatantërinhuë'. Po'oana quëran tayora nitotona'piro'sa' amatërin. Huë'pachinara, inaora quëparahuaton, nontërin: —¿Ma yoquiquëta' nasha tayora ya'norin? itërin. Sha'huitohuachinara, itantarin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","—Pirin'pa' nasha copirno nasitërin ipora. Inatohua' paatoma', noyá yoníco'. Hua'huasha quënanpatama', huënantatoma', sha'huitiintaco canta' paato chinochi, itërin nonpintaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ina natanahuatona', pa'pi huachi. Pa'sapirinahuë', a'nanaya tayora quënaantapi. Ya'huëpiquë ni'piso chachin inápaquë paaton, quëchitërarin. Hua'huasha yacapatërinquë chachin tayora chiniconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","11","Ina ni'sahuatona', pa'pi pa'yatopi. Capa cancantatona', pëiquë ya'conpi. Inaquë hua'huasha quënanconpi. A'shionta' ya'huarin, Maria itopiso'. Hua'huasha quënanahuatona', isonconahuatona', chinotopi. Ina quëran caposoa'huayanënapita i'soatahuatona', ma'sha pa'ton nininso' quëtopi. Oro, yonarin pochin pimóchin nininso', yaqui' pimóchin nininso' inapita quëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ina quëran tashi' huë'ësoi', Yosë nohuanton, hua'napi. —Ama copirno ya'huërinquë pantatoma', sha'huitocosohuë', itërin anquëniri. Napoaton a'na ira pa'tahuatona', ya'huëpi'pa' canconpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tayora nitotona'piro'sa' pa'pachinara, Yosë anquëninëni huë'ënquë Cosi ya'notahuaton itapon: —Copirno nani chinotërin hua'huasha tëpacaso marë'. Apira sontaro'sa' a'pararin ina yonicaiso marë'. Napoaton a'naroáchin ichita'aquë'. A'shinë chachin Iquipito'pa' quëpaquë'. Inaquë yacapatëquë'. Noya huënantacaso' nipachin, sha'huitantaranquën, itërin anquëniri. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Natanahuaton, a'naroáchin Cosi huënsëintarin. Tashi' nipirinhuë', hua'huasha quëparin. A'shinë chachin ichita'arahuaton, Iquipito'pa' pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Irotisë chiminaquë huarë' inaquë ya'huëpi. Iráca Yosë nohuanton, pënëntona'pi ninorin: “Hui'nahuë Iquipito'pa' yacapatopirinhuë', ina quëran ocoiarahuë,” tënin Yosë. Hui'nin chachin Iquipitoquë yacapatohuachina, ninorinso' nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Copirno Irotisëso' tayora nitotona'piro'sa' ninarápirinhuë', co ya'nopihuë'. “Nonpintërinaco ipora,” ta'ton, chiníquën no'huitërin. No'huitaton, sontaro'sa' Pirin'pa' a'parin quëmapia'huaro'sa' tëpacaiso marë'. “I'huá chachin tayora ya'norin ni'ton, co canopia'huaro'saráchin tëpacaso' ya'huërinhuë'. Cato' pi'ipitërinquë huarë' tëpaco',” itahuaton, a'parin. Sontaro'saso' pa'sahuatona', ya'ipi quëmapia'huaya Pirinquë ya'huërinsopita tiquipi. Ya'cariyanta' yonitona', cato' pi'ipitërinquë huarë' tëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Iráca ninoton, Yosë quiricanënquë Irimiasë ninshitërin: “Namaquë na'nërinso' natanpi. Naquira na'nërárin, ayanárin. Hua'huinpitaco' yonquiaton, na'nërarin. ‘Ama sëtëquësohuë',’ itopirinahuë', nani chiminpi ni'ton, sëtárin,” tënin. Iráca naporinso pochachin iporanta' hua'huaro'sa' tëpapi ni'ton, a'shina' na'nërápi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Naporo' Cosiso' Iquipitoquë yacapatarin. Irotisë chiminpachina, Yosë anquëninëni ya'notantarin. Hua'narinso pochin Cosiri quënanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Hua'huasha tëpana'pi nani chiminin ni'ton, israiro'sa' ya'huëpiquë panantaquë'. Hua'huasha a'shinë chachin quëpantaquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ina natanahuaton, natërin. Quisoso a'shinë chachin quëparahuaton, inatohua' panantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Canconahuaton, nanan natantërin. “Irotisë hui'nin ya'huërë' hua'anëntantarin. Ariquirao itopisoari pa'pin ya'huërëtërin,” topi, natantërin. Ina të'huataton, co nohuantërinhuë' inatohua' ya'huëcaso'. Naporahuaton, hua'nantarin. —Ama copirno ya'huërinquë chachin panantaquësohuë', itërin anquëniri. Ina natanahuaton, Cariria parti pa'nin ya'huëcaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Inatohua' a'na ninano' ya'huërin, Nasarito itopiso'. Inaquë ya'huërarin. Iráca pënëntona'piro'sa' ninopi. “Cristo huë'pachin, Nasarito piyapi itapona',” topi. Napoaton Yosë nohuanton, inaquë ya'huaton, hui'napitërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naporo' tahuëri'sa' Coansha Paotista pënëntarin. Cotia parti pancana inotëro' ya'huërin. Co inaquë piyapi'sa' ya'huëpihuë'. Inaquë ya'huaton, Yosë nanamën sha'huirarin. Na'a piyapi'sa' huë'pi natanapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Yosë hua'anëntiinpoaso' tahuëri nani ya'cariarinpoa'. Napoaton co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtantaco huachi, itarin. Nani tahuëri ina pochin pënënárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iráca Yosë nohuanton, Isaiasë ninorin. Ninshitaton, naporin: “Inotëro parti a'na quëmapi pënëntápon: ‘Sinioro o'macaso tahuëri naniriarin ni'ton, yonquico'. Ni'co'. Hua'an chiníquën nanantona'pi ni'ton, a'na parti yapa'pachina, comisionën a'parin ira tapatacaso marë'. Ira otëërin noya pa'tacaiso marë'. Inapochachin iporaso' cancanëma' anoyatoco' Sinioro o'main,’ tapon ina quëmapi, pënëntohuachin,” tënin. Coansha pënëntacaso' ninoton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Coanshaso' co noyápiachin a'morinhuë'. Ponira pochin a'morin, camiyo anporo quëran nipiso'. Sha'huëtë quëran nitonporin. Sëquërë pochin nininso' macaton, ca'nin. Ninoi' quënanpachina, irorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Inaquë na'a piyapi'sa' huë'pi natanacaiso marë'. Quirosarin quëran huë'pi. Ya'ipi Cotia parti quëran huëcatona', natanpi. Cortanii' ya'cariya quëraonta' huë'pi. A'naya a'naya huëcatona': —Tëhuënchachin co noyahuë' nicato, oshahuanahuë. Catahuaco Sinioro naporahuëso nanianchi, itopi Yosë nontatona'. Ina topachinara, Coanshari Cortaniiquë aporintërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ina quëran na'a parisioro'sa', satosioro'sa', inapitanta huë'pi. —Quiyanta' aporintocoi, itopirinahuë', Coansha co nohuantërinhuë': —¡Canpitaso' ya'huan pochin cancantatoma', yanonpinama'! “Yosë isoro'pa' ana'intohuachin, cha'ëpoi,” topiramahuë'. Co topinan cha'ësaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Co noyahuë' yonquiramasopita naniantatoma', noya nico huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama canpitaora ninonpintocosohuë'. “Apraan shinpitacoi ni'toi, Yosë piyapinënpitacoi,” ama tocosohuë'. Yosë nohuantërin naporini, iso na'piro'santa' Apraan shinpita atarantacaso' nanichitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nani Yosë yonquirin oshahuano'sa' ana'intacaso'. Ni'co'. Nararo'sa' co noya nitohuachinahuë', a'nërë'. Itëquënpitarë chachin ocoirahuatë', pënquë të'yatërë' huiquitacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Co noyahuë' yonquiramasopita naniantohuatama', i'quë aporintaranquëma'. Ca piquëranso nipirinhuë' a'na quëmapi huë'sarin. Inaso' chini chiníquën nanantërin. Caso' co pi'pian tëranta' ina pochin chiníquën nanantërahuë'. Co maquëyancohuë' ni'to, co sapatën quëpaca'huaso tëranta' nanitarahuë'. Inaso' huë'pachin, a'naquëma' Ispirito Santo aya'coancantarinquëma'. A'naquëmaso nipirinhuë' pënquë chiníquën ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cayarinso' manëso pochin nisarin. Arosë mapatëra, to'norarë'. Ina quëran pintiarahuatë', pëiquë acorë'. Sha'huëtënso nipirinhuë', pënquë ahuiquitërë'. Inaso' co onporonta' tacopiarinhuë', tënin Coansha. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ina quëran Quisoso Cariria quëran huë'nin. Cortaniquë canquirahuaton, Coansha nontërin aporintacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Napotopirinhuë', co nohuantërinhuë'. —¿Ma'marëta' napotiiranco? Co aporinta'huanquënso' ya'huërinhuë'. Quëma aporintoco tëhuënchinso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Napotopirinhuë', Quisosori itërin: —Yosë nohuantërin ni'ton, ya'ipi natëca'huaso' ya'huërin. Napoaton noya quëma aporintoco, itërin. Ina natanahuaton: —Noyahua', itahuaton, i'quë aporintërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ina quëran nonshiaso chachin a'naroáchin inápaquë pi'iro'të' ni'soatërin, ni'nin. Ispirito Santo nëpë pochin nohuaraimarahuaton, Quisoso ya'coancantomiatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naporo' inápa quëran Yosë noninso' natanpi. —Isoso' ca hui'nahuë chachin, na'con nosororahuëso'. Noya ni'nahuë, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ina quëran Ispirito Santori Quisoso quëparin inotëro parti sopairi tënicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Catapini shonca tahuëri tashirë chachin inaquë ya'huaponahuë', co manta' ca'ninhuë'. Ina piquëran tanarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Naporo' sopairi huëcapairin. —Tëhuënchachin Yosë hui'ninquën nipatan, iso na'piro'sa quëran cosharo' atarantëquë', itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Inca, co nohuantërahuë'. Yosë quiricanënquë pënëninpoa'. “Co cosharoriáchin piyapi ananpirinhuë'. Ya'ipi Yosë noninso' natëhuachin tëhuëchinso', nanpiarin,” tënin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ina quëran Quirosarin'pa' sopairi quëparin. Yosë chinotopiso pëi' a'canpiso aipi quëpantarahuaton, itërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Quëmaso' Yosë hui'ninquën nipatan, no'paquë niiquë'. Quiricanën quëran nani sha'huitërinquën. “Yosë anquëninënpita a'patimarinquën a'paiinquënso marë' ni'ton, co ma'sha onpoaranhuë'. Imirina quëran masarinënquën ama na'piquë tëranta' ya'quiamaso marëhuë',” tënin ni'ton, no'paquë niiquë' a'pai'inënquën, itërin sopairi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—Inca co nohuantërahuë'. Yosë quiricanënquë pënëninpoa'. “Ama Yosë tëniquësohuë'. Ama camaiquësohuë'. Ina nohuantërinsoáchin yonquicaso' ya'huërin,” tënin quiricanënquë, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ina quëran a'na motopi'pa' sopairi quëpantarin. Inatohua quëran ya'ipi ninanoro'sa', ma'shanënpita, inapita a'notërin. Noyápiachin nininsopita ya'ipiya quënanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Natëhuatanco, carinquën catahuaranquën, ya'ipi isopita hua'anëntapon. Isonahuaton, chinotoco chiníquën nanan quëchinquën huachi, itërin sopairi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Inca co nohuantërahuë'. Quëmaso' sopai hua'anquën. Patoco huachi. Yosë quiricanën quëran sha'huitërinpoa': “Sinioroíchin chinotëquë'. Inasáchin natëcaso' ya'huërin,” tënin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Napotohuachina, sopairi patërin. Patohuachina, anquëniro'sari huëcapaimarahuatona', nocomaimapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ina piquëran Coansha tashinan pëiquë po'mopi. Pënëntërinso marë' napotopi. Ina natanahuaton, Quisoso pa'nin Cariria parti. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Inatohua' pacaponahuë', co huachi Nasaritoquë ya'huërinhuë'. Sono' yonsanquë paaton, Capinaomoquë yacapatonin. Saporonoro'sa', nipitariro'sa', inapita iráca ya'huëpiquë yacapatonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iráca chachin Yosë nohuanton, Isaiasë ninorin. Ninshitaton, naporin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na'a piyapiro'sa' Cariria parti ya'huëpiso', imasapi. Inapitaso', Cortanii' aquëtëran ya'huëpi, marë Pancai' ya'cari'. Inaquë saporonoro'sa', nipitariro'sa', inapita ya'huëpi. Inaquë inpioro'santa' ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Inapitaso' co Yosë nohuitatonaraihuë', tashi pochin cancantopi. Chiminpachina', parisitomiatacaiso' ya'huëpirinhuë', Yosëri a'pintërinso pochin nanamën anitotarin noya cancantacaiso marë'. Tahuëri pochin a'pintarin huachi,” tënin iráca. Naporinso chachin Quisoso inatohua' paaton, a'chinarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Naporo quëran huarë' Quisosori pënënarin. —Iso tahuëri'sa' Yosë yahua'anëntarinquëma'. Napoaton ya'ipi co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtaantaco huachi, itëra'piarin pënënaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cariria sono' yonsanquë pa'sahuaton, cato' sami camayoro'sa' quënanconin. A'naso' Simon. Pitro itopi anta'. Iinso' Antërisë itopi. Ritinënapita të'yatapi sami macacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Huëco' iyaro'sa', imaquico a'chinchinquëma'. Sami manamaso pochachin piyapi'sa' masarama' Yosë imacaiso marë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Napotohuachina, ritinënapita patahuatona', Quisoso imasapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ina quëran amasha pa'sahuaton, catoya'pi quënancoantarin. Santiaco, Coansha inapita itopiso'. Pa'pinarë' potiquë huënsëatona', ritinënapita pasonapi. Pa'pinaso' Sipitio itopi. —Huëco' imaquico, itohuachina, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","potinëna', pa'pina' inapita patahuatona', Quisoso imasapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ya'ipi Cariria parti paaton, niyontonpiso pëiro'saquë pënëna'piarin. Noya nanan a'chinaton: “Yosë yahua'anëntërinquëma',” itëra'piarin. Naporahuaton, na'a cania'piro'sa' a'naroáchin anoyatërin. Nisha nisha caniori maninsopita anoyatëra'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ya'ipi Siria partinta', nahuinin ni'ton, notohuaro' cania'piro'sa' quëpi Quisosori anoyatacaso marë'. Nisha nisha canio inquitëra'piarin. A'naquëonta' sopairi ya'coancantërin ni'ton, co huachi inaora yonquirinso' yonquirinhuë'. Tocona'piro'sa', apiaro'sa inapitanta' quëpapi Quisosori anoyatacaso marë'. Quëpachinara, ya'ipi anoyatëra'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hua'huayatërahuë' piyapi'sari Quisoso imasapi huachi. Cariria quëran, Ticaporisë quëran, Quirosarin quëran, Cotia parti quëran, Cortanii' aquëtëran quëran, inaquëranpita huë'pi Quisoso natanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Ina quëran notohuaro' piyapi'sa' niyontonpi. Inapita quënanahuaton, Quisoso panënquë pa'sahuaton, huënsëconin. Imarinsopitari tancapitohuachinara, na'con a'chintárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Natanco iyaro'sa' a'chinchinquëma'. Yosë huëntonënquë yaya'conpatama', iso pochin cancantacaso' ya'huërin. ‘Caora co nanitërahuë' noya nica'huaso'. Catahuaco Sinioro,’ topatama', Yosë noya ni'sarinquëma' ni'ton, noya cancantarama'. Hua'anëntërinquë chachin aya'conarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sëtohuatama', Yosë achinicancanarinquëma'. Oshanëma' yonquiatoma', cancanëma quëran huarë' sëtohuatama', Yosë noya ni'sarinquëma'. Catahuarinquëma' noya cancantacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sano piyapi nipatama', Yosë noya ni'sarinquëma'. Naporahuaton, a'na tahuëri nasharo'paquë ya'huëmiatarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tanarëso pochin, yamororëso pochin cancantatoma', Yosë na'con nohuantoco'. Ina pochin cancantacasoáchin nohuantohuatama', noya ni'sarinquëma'. Catahuarinquëma' ina pochin cancantacamaso marë'. Sano cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A'napita nosorohuatama', Yosë nosoroarinquëma' canpitanta'. Noya cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ya'ipi cancanëma quëran imapatama', Yosë nohuitarama'. Naporahuaton, a'na tahuëri ina quënancontahuatama', noyá nohuitarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Isoro'paquë na'a piyapi'sa' nino'huipirinahuë', canpitari catahuaco' noya ninonchina'. Ina marë' Yosë noya ni'sarinquëma'. Hui'nin pochin cancantiarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yosë natëramaso marë' aparisitohuachinënquëma', Yosë noya ni'sarinquëma'. Hua'anëntërinquë chachin nani aya'coninquëma'. A'na tahuëri inápaquë ya'huëcontarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Imaramacoso marë' a'naquën no'huiarinënquëma', ahuëarinënquëma', pinosarinënquëma', nisha nisha nonpinapiarinënquëma'. Napotopirinënquëmahuë', ama sëtocosohuë'. Ina marë' Yosë noya ni'sarinquëma' ni'ton, nóya cancantoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Iracanta' Yosë piyapinënpita pënëntohuachinara, a'naquëni inapochachin no'huipi. Napoaton a'napita no'huihuachinënquëma', noya cancantoco'. Parisitëramaso marë' Yosë'pa' na'con acanaarinquëma'. Ina yonquiatoma', capa cancantoco',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ina quëran itantarin: “Canpitaso' iyaro'sa', yamora pochin nicatoma' a'napita catahuamaso' ya'huërin. Napoaponahuë', yamora chimipitë pochin nicatoma co a'napita catahuahuatamahuë', co huachi insonta natëarinquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Isoro'paquë ya'huëpisopita tashinanquë pa'nëso pochin nisapirinahuë', canpitari a'pintatë pochin nitarama'. Ni'co' iyaro'sa'. Ninano' panënquë ya'huëhuachina, ya'ipi piyapi'sari quënanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nanparionta' i'chinpihuatëra, co caconquë ocohuëtërëhuë'. A'ninquëchin acorë' pëi' acoana a'pinacaso marë'. Piyapi'sa' inaquë ya'huëhuachinara, noya quënantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Inapochachin canpitanta' a'pininso pochin nicatoma', noyasáchin nico'. A'napita nicatënënquëma': ‘Ma noya Tata Yosëri catahuarin ni'ton, noya nisapi,’ tosapi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ina quëran itaantarin: “Iráca Moisësë, pënëntona'piro'sa', inapita na'con pënëntopi. Pënëntatona', ninshitopi. Co ina naniantacaso' ya'huërinhuë', tënahuë. Ya'ipi inapita ninopiso' nanicaso marë' o'marahuë. Ma'sona tapon naporinsopita no'tëquën sha'huichinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tëhuënchachin itëranquëma'. Isoro'pa' ta'huantaquë huarë' Yosë quiricanën iráca ninshitopiso' ya'huápon. Co a'na hui'sharinso tëranta' topinan quëran ninshitopihuë'. Ya'ipi ninorinso' naniarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Napoaton pi'pian tëranta' co natëhuatamahuë', co Yosë noya ni'sarinquëmahuë'. Hua'anëntërinquë co acanarinquëmahuë'. Piyapi'sa' a'chintatoma': ‘Ama natëquësohuë',’ itohuatama', co noya a'chinaramahuë'. ‘Natëcaso' ya'huërin,’ itohuatama', noya a'chinarama'. Natëhuatama', Yosë noya ni'sarinquëma'. Hua'anëntërinquë acanamiatarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cotio maistro'sa', parisioro'sa', inapita Yosë quiricanën noya nitotaponaraihuë', co cancanëna quëran imapihuë'. Canpitanta' co ya'ipi cancanëma quëran huarë' imapatamahuë', co onporonta' Yosë hua'anëntërinquë ya'conaramahuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ina quëran itaantarin: “Iráca pënëntopiso' nani nitotërama'. Mashocoro'sa' iráca pënënpi. ‘Ama piyapi tëpacosohuë'. Tëpahuatama', hua'ano'sa' ana'intinquëmaso' ya'huërin,’ topirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Co tëpatërëso marëáchin ana'intinpoaso' ya'huërinhuë', tënahuë. A'na piyapi no'huihuatama', ana'intarinquëma'. Pinotohuatamanta', cotio ansiano'sa' ana'inchinquëma'. Cancanëma quëran huarë' no'huitoma', ‘Quëmaso' sopainquën,’ itohuatama', pënquë chachin parisitacaso' ya'huërin, tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Napoaton, iyaro'sa', a'naroáchin nanan anoyatacaso' ya'huërin. Yosë yachinotohuatama', yonquico'. Pi'pian tëranta' nanan ya'huëhuachin, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","a'naroáchin paatoma', anoyatoco'. Nani nanan anoyatohuatama', naporo huarë' Yosë pëinënquë paantaco'. Yosë chinotatoma' ma'sha yaquëtëramaso', quëtoco huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ni'co'. Nihuitëramaso marë' yaquëpahuachinënquëma', a'naroáchin nanan anoyatoco'. Co anoyatohuatamahuë', coisëquë quëparinënquëma'. Coisëquë quëpahuachinënquëma', sontaro'saquë yo'coaninënquëma', tashinan pëiquë po'moarinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Inaquë po'mohuachinënquëmaso', ya'ipiya pahuërëtaquë huarë' pipiarama',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ina quëran itantarin: “Isonta' iráca pënëntopiso'. ‘Sa'ama' ya'huëtohuachinquëma', ama monshihuancosohuë',’ tënin iráca, natantërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nipirinhuë', co monshihuanpiso marëáchin ana'intacaso' ya'huërinhuë', tënahuë. A'na sanapi cancanëna quëran noyahuachina', ina marënta' oshahuanapi. Nani monshitërinso pochin Yosëri ni'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Napoaton, ya'pirama quëran quënanamaso marë' co noyahuë' yonquihuatama', pa'pi co noyahuë' nisarama'. Ya'pirama' ocoirama' naporini, noya noya niitomahuë'. Somaraya nipomarahuë', co parisitopiquë pa'itomahuë'. Cato' quëran chachin noya ni'tapomarahuë' parisitopiquë të'yatohuachinënquëma', pa'pi co noyahuë' nisarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Imirama quëran pi'pian tëranta' co noyahuë' nipatama', oshahuanama'. Ninishitëimiratërama' naporini, noya noya niitomahuë'. Apia nipomarahuë', co parisitopiquë pa'itomahuë'. Imirama' nishitëramaso pochin cancantatoma', ya'ipi aoshahuaninquëmaso' a'poco',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ina quëran itaantarin: “Isonta' iráca pënëntopiso'. ‘A'na quëmapi sa'in yatë'yatohuachin, co topinan të'yatacaso' ya'huërinhuë'. Coisëquë paaton, quirica aninshichin: “Iso sanapi nani të'yatërahuë huachi,” ta'caso aninshichin. Ina quëran sanapi quëtacaso' ya'huërin,’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Caso nipirinhuë' nisha pënënanquëma'. Co sa'ama monshihuanpachinahuë', co onporonta' të'yatamaso' ya'huërinhuë', tënahuë. Topinan të'yatohuatama', oshahuanarama'. Ina sanapinta' so'yantahuachin, monshihuaninso pochin nisarin. Nasha so'ionta', monshin pochin nisarin. Co onporonta' të'yatacaso' ya'huërinhuë', tënahuë,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ina quëran itaantarin: “Isonta' shimashonëmapita iráca pënënpiso'. ‘Yoscoarë' no'tëquën nontaranquën, itohuatëra, no'tëquën nontacaso' ya'huërin, Yosë ana'intohuachinpoa'. Ina pochin nonpatëra, sha'huitëranso chachin nicacaso' ya'huërin,’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nipirinhuë', carinquëma' sha'huichinquëma'. No'tëquënáchin nonpatëra, co Yoscoarë' ta'caso' ya'huërinhuë'. Co onporonta' nonpinacaso' ya'huërinhuë', tënahuë. A'naquënso' yanonpinatona', tapona': ‘Pi'iro'të' ya'huërin ni'ton, no'tëquën nontëranquën,’ toconpi. ‘Ina pochin nontato, nonpintohuatëra, co Yosë ana'intarincohuë',’ topirinahuë'. Pi'iro'tënta' Yosëri ninin. Inaquë ya'huaton, ya'ipiya hua'anëntarin. Napoaton co ina pochin nonacaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A'naquëonta' tapona': ‘Isoro'pa' ya'huërin ni'ton, no'tëquën nontëranquën,’ topi. Yanonpinatona', napopirinahuë'. Isoro'panta' Yosëri ninin. Chini chiníquën nanantaton, isëquënta' hua'anëntërinpoa'. ‘Quirosarin ya'huërin ni'ton, no'tëquën nontëranquën,’ toconpi a'naquëonta'. A'na tahuëri inaquë Yosëri a'paimarinso' hua'anëntapon huachi. Napoaton co ina pochin nonacaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‘Moto' ya'huëtërinco ni'ton, no'tëquën nontëranquën,’ topi a'naquëonta' yanonpinatona'. Ama ina pochin noncosohuë'. Acatohuatamara, co nanitëramahuë' a'na ainëma tëranta' ayararintantacaso'. Yosëíchin nanitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma'sona tëranta' iyaro'sa' nonpatama', no'tëquënáchin nonco'. ‘Pa'sarahuë,’ topatama', paco'. ‘Co pa'sarahuë',’ topatama', ama pacosohuë'. No'tëquënáchin nonpatama', co Yoscoarë' ta'caso' ya'huërinhuë'. Pi'pisha tëranta' piyapi nonpintohuatama', sopai nohuanton napoarama', tënahuë,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ina quëran a'chintaantarin: “Isonta' iráca pënëntopiso'. ‘A'na piyapi a'nari ahuëaton, tapirayahuachin, coisëquë quëpaquë'. Inaquë no'tëquën i'huërëchin. Inanta' tapirayacaso' ya'huërin. Natëonta' nipantohuachin, coisëquë quëpaquë' i'huërëchin,’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Napopirinahuë', carima' sha'huichinquëma'. Co canpita capiniso' nii'huërëtacaso' ya'huërinhuë', tënahuë. Ma'sha onpotohuachinënquëma', ama no'huicosohuë'. Panpirayahuachinënquëma', ama manta' i'huërëtocosohuë'. Naquëranchin panpiantahuachinquëma', co naporo tëranta' no'huicaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A'naquën no'huitënquëma', coisëquë quëparinënquëma'. ‘A'moranso quëtoco,’ itohuachinënquëma', quëtoco'. Aipi a'moransonta' quëpatopirinënquëmahuë', co no'huicaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Inso tëranta' camaiatënquëma': ‘Pë'pëtonëhuë macaton, a'na quiromitro pochin quëpatoco,’ itohuachinquëma', ama no'huicosohuë'. ‘Noyahua'. Nohuantohuatan, cato' quiromitro quëpachinquën,’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","A'naquën: ‘Ma'sha quëtoco,’ itohuachinënquëma', ama apiratomahuë', quëtoco'. ‘Canta' ma'sha a'nanco, topirahuë',’ itohuachinënquëmanta', a'nanco'. Onpopionta' nosoroatë' catahuacaso' ya'huërin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ina quëran a'chintaantarin: “Isonta' iráca pënëntopiso'. ‘Canpita capini ninosoroco'. Inimiconëmapitaso nipirinhuë', co nosorocaso' ya'huërinhuë',’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nipirinhuë' carima' sha'huichinquëma'. Inimiconëmapitanta' iyaro'sa', nosoroco'. Aparisitopirinënquëmaonta', nosorocaso' ya'huërin. Inapita marënta' noya Yosë nontoco' inahuanta' catahuain. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Inapotohuatama', Yosë pochin cancantarama'. Inaso' ya'ipi piyapi'sa' nosororin. Ina nohuanton, pi'i, o'nan, inapita ya'huërin noya nanpicaso marë'. Co imarinsopita marëáchin pi'i a'pininhuë'. Noya nipisopita, oshahuano'santa', ya'ipiya a'pintërin. Naporahuaton, o'naonta' napopianachin acotërinpoa' ma'sha apapotacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nipayaramasopitaráchin nosorohuatama', co ina marë' Yosë acanaarinquëmahuë'. Copirno marë' coriqui ma'patona'piro'santa' nipayapisopita nosoropi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iyamaráchin noya nontohuatama', co noya noya ninamahuë'. Co Yosë nohuitopisopitahuënta' inahua capini noya ninontopi. Napoaton canpitaso' nisha piyapiro'santa' noya nontoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tata Yosë pochin cancantacaso' ya'huërin. Inaso noyasáchin ninin ni'ton, canpitanta' ina pochin cancantatoma', noyasáchin nico',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Naquëranchin Quisoso pënëntaantarin: “A'naquënso' piyapi'sari noya nicacaiso marë' noya Yosë imapisopita pochin ya'nopirinahuë', co tëhuënchachin cancanëna quëran huarë' Yosë yonquipihuë'. Ina pochin nipatama', co inápaquë Tata Yosë acanaarinquëmahuë'. Ama iyaro'sa' inapita pochin nicosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ma'sha sa'ahuaro'sa' quëtohuatama', ama a'ninquëchin quëtocosohuë'. A'naquën niyontonpiso pëiquë ya'conahuatona', coriqui sa'ahuaro'sa marë' quëtopirinahuë', a'ninquëchin quëtopi. ‘Ina marë' noya ni'sarinacoi,’ ta'tona', napopi. Cachiquënta' coriqui quëtopi piyapi'sari nicacaiso marë'. Co tëhuënchachin nosoroaponaraihuë', napopi. Piyapi'sariso' noya ni'pirinahuë', Yosëriso' co noyahuë' ni'nin. Co inápaquë acanaarinhuë', tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Canpitaso nipirinhuë', sa'ahuaro'sa' ma'sha quëtohuatama', ama a'ninquëchin quëtocosohuë'. Ama nipayaramaso tëranta' sha'huitocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Co piyapi'sa' nitotopirinahuë', Tata inápaquë ya'huërinso' ni'sarinquëma'. Ina acanaarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ina quëran itaantarin: “Yosë nontohuatama', ama nonpina'piro'sa pochin nicosohuë'. Inapitaso' niyontonpiso pëiquë huanirahuatona', na'con Yosë nontopirinahuë', co cancanëna quëran huarë' nontopihuë'. Cachiquënta' a'ninquëchin Yosë nontopirinahuë', piyapi'sari noya nicacaiso marë' napopi. Co tëhuënchachin Yosë yonquipihuë'. Piyapi'sari noya ni'pirinahuë', Yosëriso' co acanaarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Canpitaso nipirinhuë' Yosë yanontohuatama', canpitaoráchin onpopiyanquë tëranta' Yosë nontacaso' ya'huërin. Quëmaoraíchin Yosë nontëquë'. Co quënanpiranhuë', nataninquën. Co piyapi'sa' natanpirinënquënhuë', Yosëso' noya natanatënquën, acanaarinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yosë nontohuatama', ama inachin inachin nontocosohuë'. Co Yosë imapisopitahuë' ina pochin yonquipi. ‘Hua'qui' nontohuato, natanatonco catahuarinco,’ topirinahuë'. Co Yosë nohuitatonahuë', napopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ama inapita pochin cancantocohuë'. Co'huara Yosë nonchátërasënquëmahuë', ya'ipi pahuantërinquëmasopita nitotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Napoaton Yosë yanontohuatama', iso pochin nontoco': ‘Tata Yosë, quëmaso inápaquë ya'huaponahuë', natanancoi. Quëmasáchin noya noyanquën ni'ton, ya'ipi piyapi'sa' chinochinënquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chini chiníquën nanantëran ni'ton, ya'ipicoi natëiinquën. Inápaquë no'tëquën natërinënquënso pochachin catahuacoi quëma nohuantëransoráchin nii. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nani tahuëri catahuacoi cosharo' ya'huëchincoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Co noyahuë' nicatoi, oshahuanai. Nosoroatoncoi, oshanëhuëi inquitocoi. A'napita ma'sha onpotohuachincoi, nanan anoyatëraiso pochachin oshanëhuëi inquitatoncoi, anoyacancantocoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Co noyahuë' yonquihuatoi, catahuacoi a'naroáchin nanianchii. Catahuacoi ama sopai minsëincoisohuë'. Quëmasáchin hua'anëntarancoi. Ya'ipi nanitaparan. Ipora quëran huarë' ya'ipiya natëinënquën. Amen,’ itoco' Yosë nontohuatama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","A'naquën ma'sha onpotopirinquëmaonta', noya nontacaso' ya'huërin. Nanan anoyatohuatama', Tata Yosënta' canpita oshanëma' inquitarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Co nanan anoyatohuatamahuë', Yosënta' co oshanëma' inquitarinquëmahuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ina quëran itaantarin: “Ama nonpina'piro'sa pochin nicosohuë'. A'naquën Yosë nontacaso marë' ya'ipi tahuëri co manta' coshatërinhuë'. Naporahuaton, co nitapamantarinhuë'. Sëtërëso pochin ya'norin a'napita nitotacaiso marë'. Co cancanën quëran chinotaponahuë', a'napitari nicacaiso marë' naporin. Ni'pachinara: ‘Ma noya Yosë chinotërin,’ topi. Piyapi'sari noya ni'pirinahuë', co huachi Yosëri acanaarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Canpitaso nipirinhuë' Yosë nontacaso marë' co coshatohuatamahuë', ama piyapi'sa' sha'huitocosohuë'. Noya ihuiantahuatoma', nitapaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ama a'napita nitotacaiso marëhuë' inapoco'. Tata Yosëíchin nitotarin. Co quënanpirëhuahuë', ya'ipiya ni'sarinpoa'. Ina marë' inápaquë acanaarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ina quëran itaantarin: “Ama iyaro'sa' ma'sharáchin yonquicosohuë'. Ama na'con coriqui, ma'sha, inapita yontoncosohuë'. Isoro'paquë ya'ipi ma'sha a'naroáchin mocarin, chanatërin. No'soni pë'yarin. Chi'chirotërin. Ihuatëro'sa' ya'conatona', ihuarinënpoa'. Naporin. Napoaton, isoro'paquë ya'huërinsopita co ya'huëmiatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Inápaquë ya'huërinsopitaso nipirinhuë', ya'huëmiatarin. Yosë na'con yonquiatoma', noya nico'. Ina marë' na'con sacatoco' inápaquë acanamiachinquëma'. Inatohua' co manta' mocaponhuë'. Co no'soni pë'yaponhuë'. Co chi'chirotaponhuë'. Co ihuatëro'sa' ya'conatona' ihuaponënpoahuë'. Napoapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma'sharáchin nohuantohuatama', co Yosë yonquiaramahuë'. Nipirinhuë' Yosë na'con na'con nohuantohuatama', ina na'con na'con yonquiarama',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Ina quëran a'chintaantarin: “Ya'piranpo quëran ma'sha quënanë'. Co pëtorayatohuatërahuë', noya ni'tërë'. Nitapirayahuatëra, co manta' quënantërëhuë'. Canpitanta' ya'ipi cancanëma quëran Yosë yonquihuatama', tahuëri pochin cancantarama'. Nipirinhuë', ma'sharáchin yonquihuatama', tashi pochin cancantarama'. Nitapicancanpatama', aquë aquëtë co noyahuë' cancantarama huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ina quëran itaantarin: “A'na piyapi cato' patron ya'huëtohuachina, nisha nisha camaitopi ni'ton, co nanitërinhuë' cato chachin natëcaso'. A'naso' nohuantaton, noya natëarin. A'naso nipirinhuë' co onpopinchin nohuantatonhuë', co natëarinhuë'. Inapochachin canpitanta' coriquiráchin cancantohuatama', co nanitaramahuë' Yosë natëcamaso',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ina quëran itaantarin: “A'naquënso' ma'sharáchin yonquipi. Capacaiso', o'ocaiso', a'mocaiso', inasáchin yonquipi. ‘Nani ma'sha ya'huëtohuachinco, nóya ya'huarahuë huachi,’ topirinahuë'. Ama iyaro'sa' ina pochin cancantocosohuë'. Co capacaso marëáchin isoro'paquë acorinpoahuë'. A'mocasonta', co onpopinchin yonquicaso ya'huërinhuë'. Yosë na'con na'con yonquihuatëhua', catahuarinpoa noya ya'huëcaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ni'co'. Inairaro'sa' co manta' sha'pihuë'. Co ma'sha sha'piso' macatona', pëinënaquë acopihuë'. Napoaponahuë', Tata Yosëri catahuarin. Ina nohuanton, cosharo' quënanpi. ¡Canpitaso' inapita quëran noya noya ni'ninquëma'! ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Chiminacaso nanihuachin co napion ancantopiramahuë', co a'na tahuëri tëranta' nanitaramahuë' ana'huëcamaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nitapacamasonta', co aquëtë yonquicamaso ya'huërihuë'. Ni'co'. Yancoro'sa' topinan noya papotopi. Co sacatopihuë'. Co manta' a'mocaiso nipihuë'. Nipirinhuë', noyápiachin yancotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Iráca copirno Saromon nani ma'sha ya'huëtërin. ‘¡Ma noyápiachincha a'morin paya!’ topi. Yancoro'saso nipirinhuë', ina quëran noya noya ya'nopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pacatoro quëran huarë' Yosëri yonquirin. A'na tahuëríchin ya'huëpirinhuë', ahuipachina, ahuiquitërë huachi. Co hua'qui' ya'huëpirinhuë', Yosëri yonquirin. Ina nohuanton, noya papotërin. Canpitaso' ina quëran na'con na'con yonquirinquëma'. ¿Onpoatomata' nipachin, co natëramahuë'? ‘Yosë catahuarinco mini,’ ta'caso nipirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ama ma'sha yonquiatoma', pa'yancosohuë'. ‘¿Ma'cha ca'në'poya? ¿Ma'cha o'orë'poya? ¿Ma'cha a'morë'poya?’ ama tocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Co Yosë imapisopitahuë' ina pochin yonquipi. Ma'sharáchin yonquipi. Canpitaso nipirinhuë' tatanëma' inápaquë ya'huërinso' yonquirinquëma'. Ya'ipi pahuantërinquëmasopita nani nitotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Napoaton Yosë na'con na'con yonquico'. A'napitanta' catahuaco' hua'anëntërinquë ya'conacaiso marë'. Yosë nontoco' noyasáchin yonquicamaso marë'. Ina pochin cancantohuatama', catahuarinquëma'. Ina nohuanton, ma'sha pahuantërinquëmasopita ya'huëtarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Napoaton ama tashiraya ma'sha onpoamaso' yonquiatoma', pa'yancosohuë'. Tashirayanta' ma'sha onpohuatama', pa'yanacaso ya'huapon ni'ton, co ipora quëranchin ina yonquiatoma co napion ancantápamaso ya'huërinhuë',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Naquëranchin Quisoso pënëntaantarin. “Ama iyaro'sa' a'napita nocancosohuë'. ‘Paso' quëmapi co noyahuë',’ ama tocosohuë', Yosë ana'intochinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","A'napita pinopatama', Yosënta' co noyahuë' ni'sarinquëma'. Piyapi chiníquën nonapihuatama', Yosënta' chiníquën ana'intarinquëma'. Piyapi noya yonquirapihuatama', Yosënta' noya ni'sarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Co iyaparin nocanacaso ya'huërinhuë'. Inaso pi'pian co noyahuë' nipachin, mo'shiri ya'conayatërinso pochin ninin ni'ton, nocanan. Quëmanta' co noyahuë' ninan ni'ton, narasëratë' nani noyá ya'copirayarinquënso pochin nipiranhuë', naporan. Napoaton ‘carinquën noya nicatënquën mo'shi ocoichinquën,’ co itamaso ya'huërinhuë'. Napotohuatan, nonpinan. Narasëratë' niocoitëquë'. Ina quëran noya quënantaran. Naporo huarë' nanitaran iyaparin mo'shi ocoitacaso',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ina quëran itaantarin: “Isonta' a'chinchinquëma'. Ni'niro'sa', coshiro'sa', inapita co yonquipihuë'. Huirina'pi pa'ton nininso' co quëtacaso' ya'huërinhuë'. No'paquë acorama' naporini, i'nachitonahuë'. Ina quëran canpitanta' yaquëtëitënquëmahuë'. A'naquën piyapi'santa' ni'niro'sa pochin cancantopi ni'ton, Yosë nanamën a'chintohuatama', chiníquën no'huiarinënquëma'. Co pi'pisha tëranta' nohuantohuachinahuë', tananpitoco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ina quëran itaantarin: “Nani tahuëri Yosë nontoco' nata'inquëma'. Pahuantërinquëmaso' nipatama', quëtarinquëma'. Ma'sha yonirëso pochin cancantatoma', nontáco' catahuainquëma'. Ya'coana pi'nirëso pochin cancantatoma', nontoco' aya'coinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tëhuënchachin ma'sha nitohuatama', quëtarinquëma'. Hua'qui' ma'sha yonípatama', quënanarama'. Ya'coana pi'nirëso pochin nipatama', i'soatarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hui'nama' tanaton cosharo' natanpachinquëma', co na'pi quëtëramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sami nayahuachina', co ya'huan quëtaramahuë'. Sami quëtarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Canpitaso' co noyahuë' yonquiapomarahuë', hui'nama' nosororama'. Noya ma'sha quëtërama'. Yosëso' noya noya ni'ton, na'con na'con nosororinquëma'. Inápaquë ya'huaponahuë', hui'ninpita pochin ni'ninquëma'. Nontohuatama', noya nininso' quëtarinquëma'. Catahuarinquëma' noya cancantacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Noya ninosorocaso' ya'huërin. Canpitaso' nohuantërama' a'napita nosoroinënquëmaso'. Napoaton canpita nohuantëramaso chachin inapitanta' nosoroco'. Ninosoroatoma', nicatahuaco'. Yosë nohuanton, Moisësë, pënëntona'piro'sa', inapita na'con pënënpirinënquëmahuë', ninosorocaso' na'con na'con nohuantërin. Ninosorohuatama', noya imasarama', tënahuë,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Ina quëran itaantarin: “Ni'co'. Cato' ira ya'huërin. A'naso' pancana. Co sacaihuë' pa'tacaso' ni'ton, na'a piyapi'sa' ina pa'tapi. Ya'coanamënso' pancana nipirinhuë', ina pa'tohuatama', parisitopiquë paatoma', parisitomiatápoma'. A'na iraso nipirinhuë', sacai pochin pa'tacaso'. Ya'coanamënso' yamianasha'huaya. Caraíchin piyapi'sa' ina quënanpi. Inaquë ya'conpatama', nanpimiatarama'. Ina ira pa'toco'. Sacai' Yosë imacaso' niponahuë', chiníquën cancantatoma', imaco huachi,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ina quëran itaantarin: “Ni'cona iyaro'sa' nonpin nanan pënëntona'piro'sa' nonpintochinënquëma'. ‘Quiyanta' imarai,’ itopirinënquëmahuë', co cancanëna quëran imapihuë'. Tanan ni'ni' yamapintërinso pochin cancantatona', yatapicancaninquëma'. Co no'tëquën a'chinpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Napoaton noya yonquico'. Noya cancantohuachina', noya nisapi. Co noyahuë' cancantohuachina', co noyahuë' nisapi. Co no'tëquën a'chintarinënquëmahuë'. Ni'co'. Sharo'sa' nitërin quëran nohuitërëhua'. So'huanpiso', co misëra nitërinhuë'. ¡Shihuarionta' co quëpa nitërinhuë'! ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nara noya nipachina, noya nitërin. Co noyahuë' nipachina, co noya nitërinhuë', napoonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nitacaso' nara nipachina, inachachin noya nitërin. A'naso nipirinhuë', co nitacaso' narahuë' ni'ton, co onporonta' noya nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Co noya nitohuachinhuë', a'nëhuachinara pënquë ahuiquitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nitërin quëran nara nohuitërëhua'. Inapochachin a'china'piro'sa' nohuitarëhua'. Noya cancantohuachina', noya nisapi. Co noyahuë' cancantohuachina', co noyahuë' nisapi. Co no'tëquën a'chinapihuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ina quëran itaantarin: “Na'a piyapi'sa': ‘Sinioro, Sinioro,’ itopirinacohuë', a'naquën co cancanëna quëran imarinacohuë ni'ton, co Yosë hua'anëntërinquë ya'conapihuë'. Yosë natëpisopitaráchin inatohua' ya'huëcontapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ayaro' tahuëri nanihuachin, na'a piyapi'sa' nontaponaco: ‘Quëma nanamën Sinioro sha'huirai. Quisoso nanan quëtërincoi, ta'toi sopairo'sa' a'parai. Quëma pochin sacai' nininsopita ninai,’ itaponaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cariso nipirinhuë' itapo: ‘Yanonpintatomaco, napopiramahuë', co noyahuë' cancantërama'. Co piyapinëhuëpitanquëmahuë'. Co onporonta' imaramacohuë'. ¡Paco huachi!’ itapo,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ina quëran pënëntaantarin: “Na'aquëma' natanamacoso marë' huë'nama'. Natëhuatamaco, a'na quëmapi pochin nisarama'. Ina quëmapiso', natëricho quëran yapëirin. Yapëihuachina, noya yonquiaton, noya pëiaquë yonirin. Na'pitë' quënanahuaton, inaquë noya pëirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chiníquën o'nanpachina, panca ihuan pa'nin. Pamatohuachina, opotopirinhuë', co anotërinhuë'. Chinii' niponahuë', co të'yatërinhuë'. Panca ihuantaponahuë', na'pitëquë pëirin ni'ton, noya huanirin. Co të'yatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A'naquënso nipirinhuë' yapëihuachina, co noya yonquirinhuë'. ‘Inotëquë tëranta' pëi'i,’ ta'ton, inaquë pëipirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ina quëran panca o'nanin huachi. Pamatohuachina, chiniiri të'yatërin. Panca ihuantohuachina, pëi' a'naroáchin të'yatërin. Ya'ipi noyá quiquirin huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ya'ipi piyapi'sa' natanahuatona', pa'yanpi. “¡Ma noyacha a'chintërinpoa paya! ");
INSERT INTO cbtNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Co hua'anhuë' niponahuë', chiníquën nanantaton, a'chintërinpoa'. Co cotio maistro'saso' ina pochin a'chinpihuë',” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ina quëran panën quëran nohuaramahuachinara, na'a piyapi'sari imasapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pa'sapirinahuë', a'na cania'pi huë'nin, chana caniori maninso'. Nacapirahuaton, Quisoso nantëntaquë isonin quëran, itapon: —Nohuantohuatan Sinioro, quëma nanitëran anoyatancoso'. Anoyatoco topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Quisosori së'huarahuaton, itërin: —Nohuantërahuë mini, iyasha. ¡Noyatëquë huachi! itërin. Itohuachina, a'naroáchin noyatërin. Canio inquirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—Ama piyapi'sa' sha'huitëquësohuë'. Corto hua'an ya'huërinquë paaton, noyatëranso' a'notonquë' ni'inquën. Naporahuaton, ma'sona Moisësë sha'huirinso' quëpaquë' noyatëranso' nitotacaiso marë', itërin. Napotohuachina, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ina quëran Capinaomoquë paantarin. Canconpachina, a'na Noma capitani huëcapairahuaton: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Piyapinëhuë Sinioro chiníquën caniorin. Pëinëhuëquë quëhuënárin. Co huachi nanitërinhuë' iratacaso'. Pa'pi parisitarin, itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Noyapa', pa'sarahuë anoyatapo, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Quëmaso' Sinioro noya noyanquën. Co caso' quëma pochincohuë'. Co pëinëhuëquë huarë' huëcamaso' ya'huërinhuë'. Topinan camaiquë' noyachin, tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Caso' hua'anëhuë natërahuë. Capitanco ni'ton, sontaro'sa' natërinaco canta'. “Paquë',” itohuatëra, pa'nin. “Huëquë',” itohuatëra, huë'nin. Piyapinëhuëpitanta' camairahuë. “Sacatëquë',” itohuatëra, sacatarin. Inapochachin quëmanta' topinan camaihuatan, a'naroáchin piyapinëhuë noyatarin tënahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quisosori natanahuaton, pa'yatërin. Napoaton piyapi'sa' itapon: —¡Ma noyacha iso quëmapi natërinco paya! Nisha piyapi niponahuë', israiro'sa quëran noya noya natërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iporaso huachi nisha nisha parti quëran huë'sapi. Nisha piyapi'sa' niponaraihuë', imatona', Yosë hua'anëntërinquë ya'conapi. Inápaquë pa'pachina', Apraan, Isaco, Cacopo, inapita nohuitapi. Inapitarë' huënsëapi coshatacaiso marë'. Nóya ya'huërapi huachi, tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A'naquëmaso nipirinhuë', “Quiyanta' Yosë piyapinënpitacoi,” topiramahuë', co natëramahuë' ni'ton, co hua'anëntërinquë ya'conaramahuë'. Tashinanquë të'yatarinquëma'. Inaquë na'nëarama', chiníquën parisitarama huachi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ina quëran capitan itantarin: —¡Ya'huëranquë iyasha paantaquë'! Natëranco ni'ton, apiramiachin piyapinën noyatarin, itërin. Naporo chachin piyapinën noyatërin. Paantahuachina, sano quënanconin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ina quëran Pitro pëinënquë pa'pi. A'shatën chiníquën sapoton, quëhuënárin, quënanconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Quisosori maimirarahuaton, a'naroáchin anoyatërin. Co huachi saporinhuë'. Huanirahuaton, inari chachin a'carin, o'shitërin, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","I'huanahuanquë yatashirahuaso', na'a piyapi'sa' huëcatona', cania'piro'sa' quëpi Quisosori anoyatacaso marë'. A'naquën sopairi ya'coancantërin ni'ton, co inaora yonquirinso' yonquirinhuë'. Quisosori topinan noncharapirinhuë', sopairo'sa' pipipi. Ya'ipi cania'piro'sa' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iráca Isaiasë ninoton, ninshitërin. “Caniopirëhuahuë', anoyatarinpoa'. Canio inquitarinpoa',” tënin. Cania'piro'sa' anoyatohuachina, ninorinso' nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Notohuaro' piyapi'sa' niyontonpachinara, ca'tano'sanënpita itërin: —Poti maconco'. Aquëtëran pa'ahua', itapirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","a'na cotio maistrori nontiirin. —Canta' Maistro imainquën. Insëquësona pa'patan, canta' pa'i, topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—Sacai' imancoso' iyasha, tënahuë. Anashiro'sa', huë'ëshinantëna ya'huëtopi, inaquë huë'ëpi. Inairaro'santa' pë'pëtëna ya'huëtopi. Caso nipirinhuë' Yosë quëran quëmapico niporahuë', co pëi' ya'huëtërincohuë'. Pa'sápato, co ya'huëmiatërahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A'na imarinsoarinta' huëcapairahuaton, itiirin: —Canta' oshaquëran imamiachinquën, topirahuë', co apira nanitërahuë'. Tatahuë nani noyá mashotërin. Chiminpachin, cari pa'pitarahuë. Ina quëran imamiataranquën, itopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Quisosori itërin: —A'naquën co nohuantopihuë' imainacoso'. Chimipi pochin cancantopi. Inapitari pa'pichina'. Quëmaso nipirinhuë' ca na'con na'con yonquiatonco, imaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ina quëran Quisoso potiquë ya'conin. Ya'conpachina, ca'tano'sanënpitanta' ya'conpi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Paaquëya', a'nanaya panca ihuani manin. Panca sono' ni'ton, co'sacairi poti opoto opototahuaton, yamëntaitapirinhuë'. Ya'huërë Quisososo' huë'ë́rarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Napohuachina, ca'tano'sanënpitari ochinanpi. —¡Catahuacoi Sinioro! ¡Chimiitarihua' canpoaso'! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿Onpoatomata' të'huaramaso'? ¿Co noya natëyatëraramacohuë' ti? itërin. Ina quëran huënsëintarahuaton, ihuan a'parin. Sononta' nontërin. —Sanoquë', itohuachina, a'naroáchin co'sacai' sanoirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ina nicatona', ca'tano'sanënpita pa'yanpi. —¿Ma quëmapicha isoso' ni'ton, ihuan a'parin paya? Sononta' a'naroáchin asanoirin, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ina quëran aquëtëran canconpi. Inaso no'pa' Catara parti itopi. Inaquë cato' quëmapi ya'huëpi. Na'a sopairo'sari ya'coancantopi ni'ton, co huachi yonquipihuë'. Pa'pi hua'yantopi. Na'pi naninquë chimipiro'sa' po'mopiquë ya'huërapi. A'naroáchin yaahuëtopi ni'ton, co inataquëchin pa'pihuë'. Quisoso nonshihuachina, sopairo'sari ya'coancantërinsopita na'pi nanin quëran pipirahuatona', huë'sapi nacapirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Quisoso quënanahuatona', chiníquën nontapi. —Nohuitërainquën Sinioro. ¿Ma'ta' onpotaponcoi? Quëmaso' Yosë hui'ninquën ni'ton, co'huara ayaro' tahuëri naniyatërasohuë', ¿aparisitarancoi ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ina ya'cariya na'a coshiro'sa' ya'huërin. Huëntonën coshatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Inapita quënanahuatona', itaantapi: —Yaocoihuatancoi, coshiro'saquë tëranta' a'pacoi ya'coanta'ii, itantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Inta nipachin, inaquë paatoma' ya'conco', itohuachina, quëmapi'sa quëran pipirahuatona', coshiro'saquë ya'conconpi. Inaquë ya'conpachinara, coshiro'santa' hua'yantatona', a'naroáchin tahuan pa'topi. Panca sonoquë niitahuatona', inaquë chimiitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ina ni'sahuatona', a'paina'piro'saso' pa'yanpi. Pa'yanatona ninano'pa' ta'api. Inaquë ya'ipiya sha'huiconpi. —Sopairo'saso' quëmapi'sa quëran pipirahuatona', coshiro'saquë ya'conconpi. Napohuachinara, hua'yantatona', tahuan pa'topi. Ya'ipi chimiitopi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Natanahuatona', na'a piyapi'sa' huë'pi Quisoso nicacaiso marë'. Nani ni'pachinara, të'huatatona': —A'na parti paquë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Napotohuachinara, potiquë ya'coantarahuatona', aquëtëran pëntoantapi. Quisoso ninanonënquë chachin paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Inaquë catapini quëmapi'sari huëcatona', apia quëpi. Pë'sara'huaya pochin nininquë quëpi. Hua'qui' co nanitërinhuë' huanicaso', quëhuënárin. “Ma noya isopita natërinaco,” ta'ton, Quisosori cania'pi itërin: —¡Noya cancantëquë', apia'hua! Apiramiáchin quëma oshanën inquitaranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ina natanahuatona', cotio maistro'sa' yonquipi. “¿Ma quëmapita' isoso'? ‘Oshanën inquitaranquën,’ ta'ton, Yosë yaya'huërëtërin,” topi, yonquiatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Topinan yonquinëna quëran napoápirinahuë', Quisosori nitotaton. —¿Onpoatomata' co noyahuë' yonquirapiramaco? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Canpitaso naporama': “Piyapinpoa a'napita oshanën inquitacaso', co nanitërëhuahuë'. Apia camaiatë': ‘Huanirahuaton, noya paquë huachi,’ itacasonta' co nanitaparëhuahuë',” tënama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Caso nipirinhuë' Yosë quëran quëmapico ni'to, nanan quëtërinco piyapi'sa' oshanëna' inquita'huaso marë'. Canpitanta' ina nitotacamaso marë' iso apia anoyatarahuë, itërin. Ina quëran apia itantarin: —Huaniquë' apia'hua. Pë'sara'huaya masahuaton, ya'huëranquë paquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Itohuachina, a'naroáchin huanirahuaton, ya'huërin'pa' pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Piyapi'sa' ina nicatona', pa'yanpi. —¡Ma noyacha Yosëri catahuarin paya! Piyapi niponahuë' chiníquën nanan quëtërin paya, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ina quëran Quisoso paantarahuaton, Matio quënanconin. Coriqui Noma copirno marë' ma'patërinquë huënsëarin. Quisosori itapon: —Huëquë' iyasha imaco, itërin. Itohuachina, a'naroáchin huanirahuaton, imarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Naporo' tahuëri ina pëinënquë Quisoso ca'tano'sanënpitarë' coshatapatapi. Na'a piyapi'sa' huë'pi Quisosorë' coshatatona' nohuitacaiso marë'. A'naquënso' copirno marë' coriqui ma'patona'piro'sa'. A'naquëonta' oshahuano'sa' itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisioro'saso' ina ni'sahuatona', Quisoso ca'tano'sanënpita itonpi: —¿Onpoatonta' maistronëma' oshahuano'sapitarë' coshatarin? Copirno marë' coriqui ma'patona'piro'santa' co noyahuë' nipirinahuë', inapitarë' coshatarin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Natanahuaton, Quisosori itërin: —Isopitaso' tëhuënchachin nohuantopi imainacoso'. Ni'co'. Cania'piro'saso' notoro nohuantopi. Nipirinhuë', “Co caniorahuë',” topatëraso', co notoro nohuantërëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oshahuano'sa' pënëna'huaso marë' o'marahuë. “Co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtantaco',” itërahuë. A'napitaso': “Quiyaso' co oshahuancoihuë',” topiso marë' co na'con a'chintërahuë'. Paatoma', Yosë quiricanën noya nitotoco' no'tëquën yonquicamaquë. Inaquë iráca ninshitopi: “A'naquën topinan quëran chinotatonaco oshanëna marë' ma'sha tëpapirinahuë', co a'napita nosoropihuë'. Nosorotacaso' na'con na'con nohuantërahuë,” tënin Yosë, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ina quëran Coanshari a'chintërinsopita huëcatona', Quisoso nontiipi: —Quiyaso' a'na tahuëri co coshatatoihuë', Yosë nontarai. Parisioro'santa' inapopi. Quëma imarinënsopitaso nipirinhuë', noya coshatapi, o'osapi, inapopi. ¿Onpoatonta' co quiya pochin imarinënhuë'? itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","—Ca ya'huarahuë ni'ton, co sëtopihuë'. Ni'co'. Quëmapi sa'acaso marë' piyapi'sa' amatohuachina, capa cancantopi. Nipayarinsopita huë'pachinara, inapitarë' coshatatona', capa cancantapi. ¡Co sëtacaiso' ya'huërinhuë'! A'na tahuëriso nipirinhuë' inimiconënpitari huëcatona', sa'ana'pi masapi. Quëpatohuachina', co huachi coshatacaiso' yonquiapihuë'. Sëtapi huachi. Inapochachin canta' mapachinaco, imarinacosopita sëtapi. Sëtatona', co huachi coshatacaiso' yonquiatonahuë', Yosë nontápona', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ina quëran a'chintaantarin. —Ni'co'. A'morëso noyá mocahuachina, co nasha në'mëtëquë pa'pitërëhuë'. Nasha në'mëtëquë pa'pitërë' naporini, naquëranchin noshataton, aquëtë chachin napointonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sha'moronta' yonquico'. Huino sha'moro' nipachina, co sha'huëtë' morsa mocaro' nininquë ta'panëhuë'. Sa'potohuachina, a'naroáchin nopoitërin. Nopoitohuachina, huino chiniarë'. Morsanta' tapirë'. Sha'moro' huinoso' nasha morsaquë ta'panë'. Huino, morsanta' noya nisarin, tënin Quisoso. (Iráca inachitopiso' naniantatona', nasha nanan imacaso' ya'huërin, tapon naporin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","A'chinaquëya', a'na cotio hua'an huë'nin. Quisoso notënanquë isonquirin. —Hui'nahuë apira chiminin. Huëcaton, Sinioro, së'huaquiquë' nanpianta'in, topirahuë', itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","—Noyapa', tosahuaton inarë chachin pa'nin. Ca'tano'sanënpitanta' pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Paaquëya', a'na sanapiri imaquiarin. Hua'qui' panca huënai' a'parin. Nani shonca cato' pi'ipi co sanorinhuë'. Parisitárin. “A'morinso tëranta' së'huatohuato, anoyataponco,” ta'ton pinën quëran imaquiarin. Imaquiton, a'morinso' huirotëínchin së'huaquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Quisosori tahuërëtahuaton, sanapi quënanin. —Noya cancantëquë', imoya. Natëranco ni'ton, noyataran, itërin. Naporo chachin noyatërin. Huënai' no'narin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ina quëran hua'an pëinënquë canconpi. Na'a piyapi'sa' quënanconpi, na'nërápi, ayanápi. Quinatoro'santa' quënanconpi. Huinatacaiso marë' huë'pirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Quisosori itapon: —Ya'ipinquëma' pipico'. Co sanapia'hua chimininhuë'. Topinan huë'ësárin, itërin. —Co huë'ërinhuë'. Nani chiminin, itatona' tëhuapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ya'ipi piyapi'sa' aipiran a'parahuaton, acoana chimipi ya'huërinquë ya'conin. Maimirarahuaton, ananpitaantarin. A'naroáchin huanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Napohuachina, ya'ipi parti nanan nahuinin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ina quëran pipirahuaton pa'sapirinhuë', cato' somarayari imaquiapi. Co manta' quënantopihuë'. Quisoso imaratona', chiníquën nontapi. —¡Nosorocoi Sinioro! Quëmaso' Tapico' shinquën. Yosë a'paimarinquën ni'ton, nosoroatoncoi anoyatocoi, topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pëiquë canconahuatona', Quisoso ya'conin. Somarayaro'santa' ya'conpachinara, Quisosori itërin: —Cari nanitato anoyatërahuëso' ¿natërama' ipora ti? itërin. —Natërainquën mini Sinioro. Ya'ipiya nanitaparan tënai, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Napotohuachinara, së'huarayarahuaton, itërin: —Natëramaco ni'ton, apiramiáchin anoyataranquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Napotohuachina a'naroáchin quënantopi. —Anoyatëranquëmaso' iyaro'sa', ama insonta' sha'huitocosohuë', itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","pipirahuatona', na'a piyapi'sa' sha'huitëra'piapi. —Quisoso anoyarayatërincoi. Noya huachi quënantërai, itëra'piapi. Ya'ipi parti quëran natantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ina quëran pa'pachina, a'napitanta' canquipi. Në'huëya quëpi. Sopai nohuanton, co nanitërinhuë' nonacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Quisosori nosoroaton, sopai a'patërin. A'patohuachina, a'naroáchin noyatërin. Noya nonsarin huachi. Piyapi'sari ni'pachinara, pa'yanpi. —Co onporonta' iso pochin ni'chinëhuahuë'. Iráca quëran huarë' co insonta' isëquë naporinhuë', topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Parisioro'saso nipirinhuë', co yanatëpihuë'. —Sopai hua'ani catahuarin ni'ton, nanitërin sopairo'sa' a'pacaso', toconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ina quëran Quisoso pa'sápaton, nisha nisha ninanoro'saquë a'chintëra'piarin. Niyontonpiso pëiro'saquë noya nanan sha'huitëra'piarin. —Yosë yahua'anëntërinquëma', itëra'piarin. Insëquësona pa'pachina, ya'ipi cania'piro'sa' anoyatëra'piarin. Nisha nisha canio inquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Paaton, notohuaro' piyapi'sa' quënanin. Co Yosë yonquiatonahuë', co napion cancantopi. Ohuicaro'sa pochin inahuaso', co incari tëranta' a'pairinhuë'. “¿Incha catahuaincoi paya?” ta'tona', nisha nisha yonquipi. Napoaton Quisosori nosororin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nosoroaton, ca'tano'sanënpita itërin: —Notohuaro' piyapi'sa' ya'huëpirinahuë', co incariso tëranta' catahuarinhuë' Yosë hua'anëntërinquë ya'conacaiso marë'. Isoro'pa' panca imin pochin ninin. Cayarinso' manëso pochachin piyapi'sa' manë' Yosë imacaiso marë'. Notohuaro' piyapi'sa' ya'huaponaraihuë', caraíchin pënëntapi Yosë imacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Napoaton Yosë nontoco' a'napitanta' a'pa'in pënënchina'. Ina sha'huitërinpoa' a'chinacaso marë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Shonca cato' quëmapi'sa' Quisosori nani huayonin na'con na'con a'chintacaso marë'. Inapitaso', ca'tano'sanënpita itopi. Ayontonahuaton, chiníquën nanan quëtërin sopairo'sa' a'pacaiso marë'. Ina nohuanton, nisha nisha caniori maninsopitanta' anoyatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Shonca cato' acorin paatona' nanamën a'chinacaiso marë'. Simon'ton acorin. Pitro itopi anta'. Iionta' acorin, Antërisë itopiso'. Santiaco, Coansha, inapitanta' acorin. Sipitio hui'ninpita inahuaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pinipi, Partoromi, Tomasë, Tatio, inapitanta' nohuantaton, acorin. Mationta' coriqui Noma copirno marë' ma'patopirinhuë', acorin ca'tanacaso marë'. Arpio hui'nionta' acorin, Santiaco itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","A'na Simonta' acorin. Inaso', copirno no'huina'piro'sa' imapirinhuë', iporaso' Quisoso imasarin huachi. Cotasë Iscariotinta' acopirinhuë', a'na tahuëri inari sha'huirapiarinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nani shonca catoya'pi acohuachina, sha'huitërin: “Paatoma' iyaro'sa' noya pënëntoco'. Ama nisha piyapiro'sa' ya'huëpiquë pacosohuë'. Samaria ninanoro'saquënta' ama pacosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israiro'sa' a'chintonco'. Inapitaso', ohuicaro'sa' chihuëpiso pochin ni'tona', co Yosë yonquipihuë'. Napoaton pënënacaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Paatoma', a'chintoco': ‘Iso tahuëri'sa' Yosë hua'anëntarinpoa',’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cania'piro'sa' a'naroáchin anoyatoco'. Chimipiro'santa', ananpitaantaco'. Chana caniori maninsonta' quënanpatama', anoyatoco'. A'napitanta' sopairo'sari ya'coancantopi ni'ton, pa'pi hua'yantopi. Quënanpatama', sopairo'sa' a'patoco' piyapi'sa' noyachina'. Co manta' pahuërëtapomarahuë', Yosëso' inaora nohuanton, catahuarinquëma' ni'ton, ama pahuërë nitocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A'chinacamaso marë' pa'patama', ama manta' coriqui quëpacosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ama pë'pëto, pitana, sapatë', inapita quëpacosohuë'. Ama a'moramaso tëranta' cato' quëpacosohuë'. ‘Asacatohuatëra, a'cacaso' ya'huërin,’ topi. Napoaton a'chintohuatama', a'caarinënquëma', catahuaarinënquëma' ama ma'sha pahuantinquëmaso marëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nisha nisha ninanoquë a'chintoco'. Ninanoquë canconpatama', insosona noya natanpachinquëma', ina pëinënquë yacapaco'. Inaquë yacapatohuatama', inaquësáchin ya'huëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pëinënaquë ya'conpatama', ‘Yosë catahuainquëma',’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Noya nohuantohuachinënquëmaso', Yosëri catahuarin. Nipirinhuë', co noyahuë' nontohuachinënquëmaso', co Yosëri catahuarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Insëquësona pa'patama', ‘Ama isëquë huëcosohuë'. Co yanatanainquëmahuë',’ itohuachinënquëma', patoco'. Yapa'patama', pënënco'. ‘Nani sha'huitopiranquëmahuë'. Co nohuantëramahuë' ni'ton, canpitaora tëhuënëmaquë nina'intarama',’ itoco'. Ina quëran a'na parti paco huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tëhuënchachin itëranquëma'. Ayaro' tahuëri nanihuachin, inapitaso' chiníquën parisitapi. Iráca Sotomaro'sa', Comoraro'sa', inapita pa'pi co noyahuë' cancantopi ni'ton, Yosëri chiníquën ana'intërin. Co natërincosopitasohuë' nipirinhuë', chini chiníquën ana'intarin huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ina quëran itaantarin: “Ni'co' iyaro'sa'. Ohuicaro'sa' co nanitopihuë' nia'paicaiso'. A'naroáchin huëntonën ni'niro'sari mapi. A'chintohuatama', a'naquën piyapi'sa' ni'niro'sa pochin cancantatona', no'huiarinënquëma'. Napoaton noya yonquico'. No'huipirinënquëmaonta', ama no'huicosohuë'. Noya cancantatoma', sanoanan quëran nontoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ni'cona iyaro'sa', piyapi'sa' a'naroáchin ano'huitotama'. A'naquën no'huitënënquëma', masarinënquëma'. Mapachinënquëma', coisëquë quëpaarinënquëma'. Niyontonpiso pëiro'saquënta' huihuiarinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Imaramacoso marë' hua'ano'sa' ya'huërinquë sha'huirapiarinënquëma'. Copirnoro'saquënta' quëpaarinënquëma'. Ca nohuanto, inaquë quëpaarinënquëma' nanamëhuë sha'huitacamaso marë'. Inaquë nisha piyapiro'santa' a'chintarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Inaquëpita quëpahuachinënquëma', ama pa'yancosohuë'. ‘¿Ma'cha tono'poya?’ ama tocosohuë'. Naporo' Yosë anitotarinquëma' no'tëquën a'panitacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Co canpitaora yonquinëma quëran nonsaramahuë'. Ispirito Santo ayonquiarinquëma' noya nonacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","A'naquën imasarinaco. A'naquënso nipirinhuë' co nohuantarinacohuë' ni'ton, quëmopinënpita capini nino'huiapi. A'naquën iin chachin niponahuë', sha'huirapiarin tëpacaiso marë'. A'naquëonta' hui'nin niponahuë', imapachinco, pa'pini chachin sha'huirapiarin. A'naquëonta' a'shin chachin, pa'pin chachin niponahuë', imapachinaco, hui'ninpitari sha'huirapiapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Imaramaco ni'ton, na'a piyapi'sa' no'huiarinënquëma'. Nipirinhuë', co a'pohuatamacohuë', nicha'ësaranquëma huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aparisitohuachinënquëma', a'na ninanoquë paantaco'. Inaquënta' a'chiantaco'. Na'a ninanoro'sa' Cotia parti ya'huërin. Co ya'ipi ninanoro'saquë pa'shatërasënquëmahuë', canta' o'mantararahuë. Yosë quëran quëmapico ni'to, a'na tahuëri o'mantarahuë Yosë hua'anëntërinso' acoca'huaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ni'co'. Patron ya'huëhuachina, co piyapinënpitaso' chini chiníquën nanantërinhuë'. Canta' canpita maistronëmaco ni'ton, chini chiníquën nanantërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Napoaton no'huihuachinënquëma', co ina marë' sëtacaso' ya'huërinhuë'. Nani no'huirinaco canta'. ‘Sopainquën,’ itërinaco ni'ton, canpitanta ina pochachin nontarinënquëma',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ina quëran itantarin: “Piyapi'sa' no'huipirinënquëmahuë', ama iyaro'sa' të'huatocosohuë'. Iporaso' ma'sha noyá po'opinan pochin ni'ton, co insonta' nitotërinhuë'. A'na tahuëriso nipirinhuë' ya'ipiya nitotapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iporaso' co ya'ipi piyapi'sa' a'chintarahuë'. Carayanquëma tëranta' canpitaora quëparahuatënquëma', na'con a'chintaranquëma'. A'na tahuëriso nipirinhuë' ya'ipi piyapi a'ninquëchin sha'huitoco' nitochina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama piyapi'sa' të'huatocosohuë'. Tëpapirinënquëmaonta', co hua'yanëma' matarinënquëmahuë'. Yosë tëhuënchinso' të'huatacaso' ya'huërin, tënahuë. Ina nohuanton, chiminë'. Co noyahuë' nipachina', pënquë chachin a'paarin huachi. Inatohua' hua'yanënarë chachin parisitomiatapi huachi. Napoaton Yosë na'con na'con të'huatacaso' ya'huërin. Co piyapi'sa' të'huatacaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yosëso' a'pairinquëma'. Ni'co'. Inairaro'sa' co pa'tonhuë'. Cato nipirinhuë', a'na soroíchin pa'tërin. Napoaponahuë', co a'naya tëranta' Yosëri naniantërinhuë'. Co ina nohuantohuachinhuë', co chimininhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Canpoaso nipirinhuë' na'con na'con a'pairinpoa'. Ya'ipinpoa' a'naya a'nayanpoa' yonquirinpoa'. Ainënpoa' hua'huayátërahuë nipirinhuë', ya'ipiya pichirin. Napoaton ama të'huacosohuë'. Ni'sárinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Quisoso imarahuë,’ topatama', ayaro' tahuëri carinquëmanta' nohuantaranquëma'. ‘Imarinaco mini,’ itarahuë Tata Yosë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nipirinhuë', ‘a'porahuë huachi,’ topatamaso', carinquëmanta' a'poaranquëma'. ‘Co imarinacohuë',’ itarahuë Tata Yosë,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ina quëran pënëantarin: “ ‘Cristo o'mahuachin, ya'ipiya nohuantatona', noya ya'huapi,’ topiramahuë', co ya'ipiya nohuantarinacohuë' ni'ton, nino'huiapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ipora quëran huarë' a'na pëiquë ya'huëpisopita nisha nisha yonquiapi. A'na pëiquë pa'pin nohuantarin. Hui'ninso nipirinhuë' co nohuantarinhuë'. A'na pëiquënta' hui'nin nohuantarin. Pa'pinso nipirinhuë' co nohuantarinhuë'. Sanapi'santa' nisha nisha yonquiapi. A'shin co nohuantarinhuë'. Hua'huinso nipirinhuë' nohuantarin. A'shatën nohuantapirinhuë', notainso' co nohuantarinhuë'. Napoapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Imaramacoso marë' quëmopinëma chachin no'huiarinënquëma'. Co nishahuë' niponaraihuë', inimiconën pochin ni'sarinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yaimapatamaco, ca na'con na'con nosoroco. Tatama', mamama', hui'nama' inapita co onpopinchin nosorocaso' ya'huërinhuë'. Co na'con na'con nosorohuatamacohuë', co tëhuënchachin imaramacohuë' tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Imapatamaco, a'napita aparisitarinënquëma'. Yatëpapirinënquëmaonta', imamiatoco. Corosëquë chiníquën parisitërë'. Inapochachin canpitanta' imapatamaco, aparisitarinënquëma'. Co ahuantohuatamahuë', co tëhuënchachin imaramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noya nanpicamasoáchin yonquihuatama', topinan quëran nanpiarama'. Chiminpatama', parisitomiatarama'. Nipirinhuë', imaramacoso marë' aparisitohuachinënquëma', noya cancantoco'. Tëpapirinënquëmaonta', noya noya nanpimiatontarama',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ina quëran pënëantarin: “Insosona noya natanpachinquëma', noya natanarinaco canta'. Yosë a'paimarinco ni'ton, Yosë nanamën chachin imasapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","A'chinamaso marë' Yosë noya ni'sarinquëma'. Inápaquë acanaarinquëma'. A'naquën natanpachinënquëma', ‘Yosë nanamën chachin a'chintarinpoa',’ ta'tona', noya natanarinënquëma'. Ina marë' inapitanta' inápaquë canarapi. Tëhuënchachin noya piyapi'sa' catahuacaso' ya'huërin. ‘Yosë imarin ni'ton, noya quëmapi inaso',’ ta'toma', catahuaco'. Ina marë' Yosë acanaarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inso tëranta' imarincoso co chiníquën nanantopirinhuë', inanta' nosorocaso' ya'huërin. Imarincoso marë' i'sha tëranta' o'shitohuatama', inápaquë Yosë acanaarinquëma'. Tëhuënchachin noya i'huërëtarinquëma',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nani ca'tano'sanënpita sha'huitahuaton, a'chinacaso marë' pa'nin huachi. Nisha nisha ninanoquë pa'sahuaton, a'china'piarin. Pënëna'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Coansha Paotistaso nipirinhuë', naporo' tashinan pëiquë ya'huárin. Inaquë ya'ipi Quisoso naporinso' natantërin. Ina natantaton, cato' imarinsopita a'parin Quisoso natanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Canconpachinara, Quisoso natanatona': —Coansha Paotista a'parincoi ni'ton, natana'huainquënso marë' huë'nai. I'huá chachin inaso', na'con sha'huitërincoi. “A'na tahuëri Cristo o'mararin, Yosëri a'paimarinso',” itërincoi. ¿Quëmaso' inanquën nimara, ti? ¿Pahuanarin o'macaso' nica? Co nitotatoihuë', natanapoinquën huë'nai. Sha'huitocoi quiyanta' Coansha sha'huitoanta'ii, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Napotohuachinara, Quisosori itërin: —Nani ma'sha ni'nama', natanama'. Somaraya nininsopita huë'pachinara, ca nohuanto, ni'topi. Apiaro'santa' a'naroáchin anoyatërahuë. Noya iratopi ni'nama'. A'naquëonta' chana caniori maninsopita anoyatërahuë. Në'huëro'santa' ca nohuanto, noya natantopi. Chiminpisopitanta' ananpitaantarahuë. Notohuaro' piyapi'sa' co Yosë nohuitatonaraihuë', nosorotápirinahuë', iporaso huachi noya nanan a'chintarahuë natanama'. Paatoma', ya'ipiya Coansha sha'huitonco' no'tëquën nitochin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Insosona ya'ipi cancanëna quëran natëmiatohuachinaco, nóya cancantapi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ina natanahuatona', Coansha sha'huitapona' pa'pi. Nani pa'pachinara, Quisosori piyapi'sa' a'chintantarin. —Natanco iyaro'sa' Coansha yonquiato a'chinchinquëma'. I'hua inotëro parti ina nicapoma' pa'patamara, inaso Yosë marë chiníquën huanirin quënanconama'. Co piquira ihuani onororinso pochin niconinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Co inaso ma'huano'sa' pochin noyápiachin a'morinhuë'. Noyápiachin a'mopisopitaso', copirnoro'sa' pëinënaquë ya'huëpi. Coanshaso nipirinhuë', co nani ma'sha ya'huëtërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pënëntërinso' natanacamaso marë' pa'nama', tënahuë. Coansha tëhuënchachin nóya pënëntërin. Co topinan quëran pënëntërinhuë'. Yosëri chachin a'parin pënëntacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iráca quiricanënquë ninoton Yosëri hui'nin sha'huitërin. “Co'huara pa'shamátërasënquënhuë', comisionëhuë'ton a'pararahuë piyapi'sa' ayonquicaso marë',” itërin. Coansha ninoton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Iráca quëran huarë' na'a piyapi'sa' pënëntopirinahuë', Coansha Paotistaso' noya noya pënëntërin. Pënëntërinso' noya, nipirinhuë', inso tëranta' imapachinaco, noya noya nisarin. Yosë hua'anëntërinquë chachin ya'conarin huachi, tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Coansha pënëntërin quëran huarë' na'a piyapi'sa' huë'sapi natanacaiso marë'. A'naquënso nipirinhuë' co nohuantopihuë' Yosë hua'anëntërinquë ya'conacaiso'. Co nohuantatonaraihuë', nohuantopisopita aparisitopi. Chiníquën cancantopisopitaso nipirinhuë', onpopionta' ya'conapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iráca quëran huarë' Moisësë, pënëntona'piro'sa', inapita ninopi. ‘Yosë yahua'anëntërinpoa'. A'na tahuëri ina marë' acorinso' a'paimararin,’ topi. Coanshanta' ninotona', ninshitopi: ‘Co'huara Sinioro tahuërinën naniyatërasohuë', Iniasë huëantarin pënëntacaso marë',’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Napopiso chachin Coansha pënëntarin huachi. Iniasë pochin cancantaton, pënëntarin, tënahuë. Nohuantohuatama', natëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Huëratëhuanpatama', noya natanatomaco, yonquico'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Iporaso' piyapi'sa' nisha nisha yonquipi. Hua'huaro'sa pochin cancantopi. Hua'huaro'sa' cachiquë ya'nipihuachinara, a'naquën tapona': ‘Huëco' pita pochin ni'tëhua', ya'nipiahua',’ ta'tona', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","quinatapirinahuë', co a'napita nohuantopihuë' nansacaiso'. Ina quëran co nohuantohuachinarahuë', tantapona': ‘Inta nipachin, huëco' chimipi pa'pitopiso pochin ni'tëhua', ya'nipiahua',’ nitantapi. Na'nëpirinahuë', co a'napita nohuantopihuë' na'nëcaiso'. Inapochachin canpitanta' ipora nisha nisha yonquirama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Coansha Paotistaso' pënëntapon, co aquëtë' cosharo' yonquirinhuë'. Co noya coshatërinhuë'. Co pi'pian tëranta' huino o'orinhuë'. Napopirinhuë': ‘Inaso' Sopairi ahua'yantërin ni'ton naporin,’ tënama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Caso nipirinhuë', Yosë quëran quëmapico niporahuë' coshatërahuë, o'orahuë. Ina marë' pinoramaco canta'. ‘Quisoso coshatárin, o'opatárin. Oshahuano'sarë' nipayarin. Copirno marë' coriqui ma'patona'piro'sarënta' nipayarin,’ toconama'. Nisha nisha yonquiconama'. A'naquënso nipirinhuë' noya yonquiatona', Yosë natëapi huachi. No'tëquën pënënahuë ni'ton, no'tëquën yonquiapi huachi,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nisha nisha ninanoro'saquë nani pënëntërin. Inaquë na'a cania'piro'sa' a'naroáchin anoyatërin. Ya'huëhuano'saso' nicaponaraihuë', inachachin inachachin yonquiantapi. Co oshanëna' yaa'popihuë'. Napoaton chiníquën pënënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Corasinoquë ya'huëpisopita, Pitsaitaquë ya'huëpisopita, inapita yonquiaton, itapon: “¡Ma'huántacha canpitaso' nisarama paya! Na'con pënënpiranquëmahuë', co natëramacohuë'. Ina marë' parisitarama'. Na'con nitotopiramahuë', co yaimaramacohuë'. Tiroquë, Sitonquë, inaquëpitaso nipirinhuë' co pënëntërahuë'. Co inaquë cania'piro'sa' a'naroáchin anoyatërahuë'. Inaquë naporahuë naporini, oshanëna marë' sëchitonahuë'. Sa'catën nininso a'motona', huarianoquë nipashimotochitonahuë'. Co noyahuë' yonquipisopitanta', nanianchitonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Napoaton ayaro' tahuëri nanihuachin, canpitaso' Yosë chini chiníquën ana'intarinquëma'. Inapitaso' co onpopinchin ana'intarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capinaomoquë ya'huëramasopitanta' co no'tëquën yonquiramahuë'. ‘Noyacoi ni'toi, Yosë'pa' pa'sarai,’ ¿topiramahuë' ti? Co ina marë' inatohua' pa'saramahuë'. Parisitopiquë pa'miatarama huachi. Hua'qui' a'chintëranquëma'. Na'a cania'piro'sa' a'naroáchin anoyatërahuë. Nani nicapomarahuë', co yaimaramacohuë'. Sotomaquë naporahuë naporini, inapitaso natëitonacohuë'. Co oshanëna marë' Yosëri ata'huanchitonhuë'. Ipora huanta' ya'hua'itonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ayaro' tahuëri nanihuachin, canpitaso' chini chiníquën ana'intarinquëma'. Sotomaro'saso nipirinhuë', co onpopinchin ana'intarinhuë', tënahuë,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naporo' noya cancantaton, Yosë nontërin: “¡Ma noyacha Tata yonquiran paya! Quëmaso' chini chiníquën nanantëran. Inápaquë ya'huërinsopita, isoro'paquë ya'huërinsopita, ya'ipiya hua'anëntëran. A'naquën Tata nani ma'sha nitotaponaraihuë': ‘Quiyaora noya noya nitotarai,’ topiso marë', co nanamën anitotëranhuë'. Imarinacosopitaso nipirinhuë', co onpopinchin nitotaponaraihuë': ‘Catahuaco Sinioro co caora nanitërahuë',’ topachinara, quëma nanamën chachin anitotëran. Ina marë: ‘Yosparinquën,’ itëranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Quëmaora nohuanton Tata naporan,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ina quëran piyapi'sa' a'chintantarin. “Tata Yosë nohuanton, pënëntarahuë. Ya'ipi nanamën anitotërinco piyapi'sa' a'chintaca'huaso marë'. Hui'ninco ni'ton, inasáchin noya nohuitërinco. Inapochachin Tata Yosë nohuitërahuë. Casáchin noya nohuitërahuë. A'naquëonta' cari anohuitohuato, nohuitapi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Huëco' casáchin imaco catahuainquëma'. Isoro'paquë ma'sha onporama' ni'ton, sëtarama'. Naporahuaton, nisha nisha yanatëpiramahuë', co canpitaora nanitëramahuë' noya cancantacamaso'. Pë'pëto quëquën quëparamaso pochin ninatanama ni'ton, napion cancantërama'. Napoaton huëco' catahuainquëma' sano cancantacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Co carinquëma' nocananquëmahuë'. Sanoanan quëran pënënanquëma'. Casáchin natanco a'chinchinquëma'. Nani tahuëri catahuaranquëma' noya cancantacamaso marë'. Ina pochin imapatamaco, sano cancantarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ma'sona nicacaso sha'huitohuatënquëma', catahuaranquëma' noya nicacamaso'. Catahuaranquëma' ni'ton, co sacaihuë' imasaramaco huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A'na chinoto tahuëri nanihuachina, Quisoso ca'tano'sanënpitarë' pa'sapi. Tricoro' pëntontapi. Ca'tano'sanënpita tanatona', papona pochin a'naya a'naya trico moto maraapi. I'shorayarahuatona', ca'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ina ni'sahuatona parisioro'saso': —¡Ni'quë' Maistro! Chinoto tahuëri nipirinhuë', ca'tano'sanënpita tricoraya i'shorayapi, co ipora tahuëri pi'pisha tëranta' sacatacaso ya'huërinhuë'. Co Moisësë pënëntërinso' natëpihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Napotohuachinara, itërin: —Yosë quiricanën ¿co nontëramahuë' ti? Iráca Tapi tanahuachina, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yosë pëinënquë ya'conin. Inaquë ya'conahuaton, pan Yosë marë' acopiso' ca'nin. Ca'taninsopitanta' tanatona', ca'pi. Corto hua'ano'saráchin ina pan capacaiso nipirinhuë', Tapi ca'nin. Ca'pirinhuë', co ina marë' Yosëri ana'intërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Isonta' yonquico'. Nani chinoto tahuëri corto hua'ano'sa' Yosë pëinënquë sacatopi. Piyapi'sa' oshanëna marë' ohuicaro'sa' tëpapi. Sacatopirinahuë', co ina marë' oshahuanpihuë'. ¿Co inanta' nontëramahuë' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yosë pëinën noya nipirinhuë', caso' chini chiníquën nanantato, noya noya a'chintaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yosë chachin naporin: “Piyapi'sa' nosorocamaso' na'con na'con nohuantërahuë. Ma'sha oshanëma marë' tëparahuatoma ya'ipi ahuiquitamaso', co onpopinchin nohuantërahuë',” tënin quiricanënquë. Nontopiramahuë', co natantochináchinhuë' cancantërama'. No'tëquën yonquirama' naporini, co topinan quëran sha'huirapiitomahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yosë quëran quëmapico ni'to, chiníquën nanantërahuë. Chinoto tahuëri ma'sona noya nicacaso' sha'huichinquëma'. Co nicacasohuë nininsonta' sha'huichinquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ina quëran paantarahuaton, niyontonpiso pëiquë ya'conconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Inaquë a'na quëmapi quënanconin. A'na imirin tachitërin ni'ton, co pi'pisha tëranta' nanitërinhuë' së'quëtacaso'. “Ipora tahuëri co cania'piro'sa' anoyatacaso ya'huërinhuë',” ta'tona', parisioro'sari ni'sapi. Quisoso yasha'huirapitona', itapona': —Chinoto tahuëri nipirinhuë', ¿noya cania'piro'sa' anoyatacaso' ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—Ni'cochi iyaro'sa', ohuicaro'sa' pë'tahuahuatamara, a'naya tëranta' panca nanincatëquë anotohuachina, ocoirama'. Chinoto tahuëri nipirinhuë', masahuatoma', ocoirama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Piyapi'saso nipirinhuë' noya noya ni'ton, na'con na'con nosorocaso' ya'huërin. Napoaton chinoto tahuërinta' piyapi'sa' catahuacaso' ya'huërin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Napotahuaton, apia nontërin. —Imiran iyasha ihuëquë', itërin. Natëton ihuëpachina, a'naroáchin noyatërin. A'na imirin pochachin niantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ina nicatona parisioro'saso' pipipi. Pipirahuatona', Quisoso tëpacaiso marë' yonquipi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ina nitotaton, Quisoso a'na parti pa'nin. Na'a piyapi'sari imasarin. Cania'piro'sa' huë'pachinara, ya'ipiya anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","—Ama a'napita sha'huitocosohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iráca Quisoso ninoton, Isaiasë ninshitërin. Yosë yonquirinso chachin ninshitaton, naporin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iso quëmapi nani acorahuë nisha nisha piyapi'sa' nicha'ëcaso marë'. Noya natëarinco. Na'con nosoroato, nóya ni'nahuë. Ispiritonëhuë chachin aya'coancantarahuë. Nisha piyapiro'santa' no'tëquën a'chintahuaton, anoyacancantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Co no'huiarinhuë'. Co chiníquën nonsarinhuë'. Co cachiquë paaton, piyapi'sa' ano'huitarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A'naquën piquira yanopantërinso pochin nicatona', co huachi chiníquën cancantopihuë'. Inapitaso' achinicancanarin. Nanparin yatacopirinso pochin cancantatona', pi'pianchin Yosë shia'popi. Co inapitanta' no'huiarinhuë'. No'tëquën a'chintahuaton, na'a piyapi'sa' anoyacancantarin. Inapotaton, sopai minsëarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nisha nisha piyapi'sari natanahuatona': ‘Inasáchin nicha'ësarinpoa',’ tosapi huachi,” tënin Yosë quiricanënquë. Iráca Isaiasë ninorinso chachin nanirin ni'ton, Quisosori sanoanan quëran piyapi'sa' pënënarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ina quëran a'na quëmapi quëpi Quisosori anoyatacaso marë'. Sopairi ya'coancantërin ni'ton, co nanitërinhuë' nonacaso'. Co quënantacaso tëranta' nanitërinhuë'. Sopai a'parahuaton, a'naroáchin anoyatërin. Noya ni'tërin. Nonacasonta' nanitërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ina ni'sahuatona', piyapi'sa' pa'yanpi. “¡Ma'pitacha nanitaparin paya! Isoso' Tapico' shiin, ¿Yosëri a'paimarinso' nimara ti?” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisioro'sariso nipirinhuë', co natëpihuë': “Sopairo'sa' hua'an Piirsipo itopisoari catahuarin ni'ton, nanitaparin sopairo'sa' a'pacaso'. Co inari catahuarinhuë' naporini, co nanichitonhuë',” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Topinan yonquirapirinahuë', inaora yonquinën quëran Quisosori nitotaton, itërin: “Ni'co'. Ninanoquë ya'huëpisopita nino'huipi naporini, yanquë'itonahuë'. Co huachi inaquë ya'huë'itonahuë'. Huëntonënquë ya'huëpisopitanta' nino'huipi naporini, inapitanta' yanquë'itonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Inapochachin Satanasë sopairo'sarë' nino'huipi naporini, co huachi hua'an niitonhuë', co huachi piyapi'sa' hua'anëntacaso' nanichitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","‘Piirsipo catahuarinquën,’ itopiramacohuë', co no'tëquën yonquiramahuë'. Co ina catahuarincohuë'. A'naquën a'chintëramasoarinta' sopairo'sa' yaa'papi. Satanasë catahuarinco ni'quëhuarë', inapitanta' inari catahuarin. Inapita natanco' macariso' catahuarinso' sha'huichinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Caso nipirinhuë', Ispirito Santo catahuarinco sopairo'sa' a'paca'huaso'. Napoaton Yosë chachin a'paimarinco hua'anënta'huanquëmaso marë', tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Quëmapi chiníquën nipachina, pëinën noya a'pairin. Co insonta ya'conaton ma'shanën mataponhuë'. A'naso nipirinhuë' ina quëran chini chiníquën ni'ton, huëcapairahuaton minsëquirin. Tonporahuaton, ma'shanënpita quiquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Co imapatamacohuë', inimicotaramaco. Co catahuahuatamacohuë', sopai natëarama huachi. Piyapi'sa' anishacancantarama' ama Yosë imacaiso marëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Napoaton itaranquëma': Co noyahuë' nipatama', oshahuanarama'. Pinótohuatamanta oshahuanarama'. Oshanëma marë' sëtohuatama', Yosë oshanëma' inquitarinquëma'. Ya'ipi co noyahuë' ninamasopita inquitarinquëma'. Ispirito Santoíchin pinotoma' oshahuanpatama' tëhuënchinso', co inquitarinquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Caso' Yosë quëran quëmapico nipirahuë pinopatamaco, ina marë' oshahuanpiramahuë', oshanëma marë' sëtohuatama', inquitarinquëma'. Nipirinhuë', Ispirito Santo pinopatama', co oshanëma' inquitarinquëmahuë'. Co onporonta' inquitarinquëmahuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ina quëran itaantarin: “ ‘Nara noya nipachina, noya nitërin. Co noya nitohuachinahuë', napoonin,’ topi. Nitërin quëran nara nohuitërë'. Inapochachin piyapinpoanta' ninëhua'. Noya yonquihuatëhua', no'tëquën nonarihua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Canpitaso nipirinhuë', ya'huan pochin cancantatoma' yanonpinama'. Co noyahuë' yonquiatoma', co nanitëramahuë' noya nonacamaso'. Onpopinsona cancantëramaso', nonama quëran piyapi'sa anitotarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Noya cancantohuatëhua', noyasáchin nonarihua'. Co noyahuë' cancantohuatëhua', co noyahuë' nonarihua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Noya cancantohuatama', noya nonsarama'. Ayaro' tahuëri Yosë noya ni'sarinquëma'. Co noyahuë' cancantohuatama', co noyahuë' nonsarama'. Ina marë' ayaro' tahuëri ana'intarinquëma'. Ayaro' tahuëri nanihuachin, Yosë nontarinquëma'. Ya'ipi nonamasopitanta' aipitarinquëma'. A'naquëma' co noyahuë' nonpatama', ‘Co yonquiatohuë', naporahuë,’ itopiramahuë', ina marënta' ana'intarinquëma', tënahuë. Co noyahuë' cancantohuatama', no'tëquën ana'intarinquëma huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ina quëran parisioro'sa', cotio maistro'sa', inapita huë'pachinara, Quisoso nontiipi: —Yosë pochin niquë' ni'iinquën. Ina ni'patoi, natëarainquën, itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","—Canpitaso' co noyahuë' cancantërama'. Co pi'pisha tëranta' Yosë yanatëramahuë'. “Yosë pochin niquë' ni'iinquën,” itopiramacohuë', co Yosë nohuantërinhuë'. Isoíchin anitotarinquëma'. A'na tahuëri Conasë pochin nisarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iráca Conasë marëquë të'yaitohuachinara, panca sami pochin nininsoari mi'tërin. Cara tahuëri tashirë chachin inaquë ya'huapirinhuë'. Ina quëran Yosë nohuanton, cha'ërin. Inapochachin canta' Yosë quëran quëmapico ni'to, chiminpato, cara tahuëri tashirë chachin acoporo' ya'huaporahuë', cha'ësarahuë huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Conasë cha'ërahuaton, Ninihuiquë pa'nin. Inaquë pënëntohuachina, co noyahuë' yonquipisopita naniantopi. Napoaton ayaro' tahuëri inapita nontarinënquëma'. “¿Onpoatomata' co canpitaso' natëramahuë'?” itaponënquëma'. Caso' chiníquën nanantato, noya noya pënënpiranquëmahuë', co yanatëramacohuë'. Napoaton ayaro' tahuëri Yosë na'con ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Inapochachin iráca Saromon hua'anëntapon, copirno sanapi nininso' sor parti quëran huë'nin ina nontacaso marë'. “Ya'ipi nitotërin,” ta'ton, huë'nin natanapon. Napoaton ayaro' tahuëri ina atapanarinquëma'. Saromon quëran caso' na'con na'con nitotato, noya noya a'chintopiranquëmahuë', co yanatëramacohuë' ni'ton, Yosë chiníquën ana'intarinquëma', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ina quëran Quisosori a'chintaantarin. “A'na quëmapi sopairi ya'coancantopirinhuë', ina quëran pipirin. Pipihuachina, inotëro' parti pa'sárin. Insëquësona ya'huëcaso marë' yonisapirinhuë', co quënaninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Napoaton ina quëmapiquë chachin huëantarin. Inaso' co Yosë yonquiatonhuë', topinan ya'huárin quënanquiantarin. Noya ya'huëantachinachin ni'ton, sopairi yaya'coancantantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Napoaton paantarahuaton, canchisë sopairo'sa' maantarin. Aquë aquëtë' co noyahuë' nipisopita maantarin. Posa sopairo'sari chachin quëmapi ya'coancantantapi. Napoaton aquë aquëtë' co noyahuë' yonquirin huachi. Inapochachin ipora na'a piyapi'sa' sopai natëtona', co noyahuë' cancantopi. Ina quëran: ‘Co huachi sopai natëarahuë',’ taponaraihuë', co Yosë yonquiatonahuë', oshaquëran aquë aquëtë' co noyahuë' cancantaantapi huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Piyapi'sa' nontaso', a'shin, iinpita, inapita huë'pi. Quisoso yanontopirinahuë', na'a piyapi'sa' yamorapi ni'ton, co nanitopihuë' ya'conacaiso'. Aipiran huaniápirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","a'na quëmapiri sha'huitërin: —Ni'quë' Maistro. Mamaparin, iyaparinpita, inapita huëcatona', aipiran huanirapi. Yanontërinënquën, itërin, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Napotopirinhuë', Quisosoriso' itapon: —Mamahuë, iyahuëpita, inapita pochin ni'nahuësopita sha'huichinquën nitotëquë', itahuaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","imirin quëran tasatërin: —Isopita imarinaco ni'ton, iyahuëpita pochin nicato, nosororahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yosë natëpisopita iyahuëpita pochin ni'nahuë. Sanapi'santa' Yosë nanamën natëhuachina', oshihuëpita pochin ni'nahuë. Payaro'santa' Yosë imapachina', mamahuë pochin ni'nahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naporo' tahuëri pëi quëran pipirahuaton, sono' yonsanquë huënsëconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Inaquë notohuaro' piyapi'sa' niyontonpi natanacaiso marë'. Hua'huayatërahuë' tancapitohuachinara, potiquë ya'conahuaton, huënsëmarin. Ii' yonsánshaquë huarë' piyapi'sa' yamorapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nisha nisha pënënto nanan a'chintërin. Ma pochinsona nininsopita a'chintárin ayonquicaso marë'. A'chintaton, itapon: “A'na quëmapi sha'tapon pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tricoraya iminquë pa'sarayarin papotacaso marë'. Pa'sarayahuachina, a'naquën ya'pirin iraquë huarë' pa'sarayarin. Iraquë huarë' anotërin ni'ton, inairaro'sari huëcapairahuatona', pë'yaquipi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A'naquën ya'pirin na'piroquë pa'sarayarin, pi'pian pi'pian no'pa' ya'huërinquë. Shimënshin no'pa' ni'ton, shiarahuaton, papotopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pi'iri chiníquën pi'cahuachina, yaahuirin. Pi'pishara'huaya itëhuanin ni'ton, ahuirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A'naquën ya'pirionta' nahuanoquë pa'sarayarin. Inaquë papotopirinhuë', nahuano'sarinta' papotërin. A'shinahuatona', imotërin huachi. Napoaton co nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A'naquënso nipirinhuë' noyaro'paquë pa'sarayarin. Inaquë noya papotërin. A'shinpachina, sha'nin quëran na'con na'con nitërin. A'naquën cara shonca, cara shonca nitërin. A'naquën saota shonca, saota shonca nitërin. A'naquën pasa, pasa nitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Huëratëhuanpatama', noya natanatomaco, yonquico',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ina quëran ca'tano'sanënpitari ya'caritahuatona', natanpi. “¿Onpoatonta' Maistro piyapi'sa' a'chintohuatana, pënënto nanan quëran a'chintëran?” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","“Yosë hua'anëntërinso' co insonta' inaora yonquinën quëran nitotërinhuë'. Canpitaso' ya'ipiya a'chintaranquëma'. A'napitaso nipirinhuë' co ya'ipi a'chintarahuë'. Pënënto nanan quëransáchin a'chintarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Insosona noya natanpachinaco, Yosëri catahuarin noya yonquicaiso marë'. Na'con na'con nitotapi. A'napitaso nipirinhuë' co yanatëhuachinacohuë', Yosëri tananpitarin ni'ton, ya'ipiya naniantapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Napoaton inapita huë'pachinara, sacai pochin a'chintërahuë. Natanaponaraihuë', co natëapihuë'. Nicaponaraihuë', co yonquiapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iráca Isaiasëri ninoton, naporin: ‘Natanapomarahuë', co natëtaramahuë'. Nicapomarahuënta' co tëhuënchachin quënanaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Isopitaso' co natantochináchinhuë' cancantopi. Në'huëya pochin cancantatona', co yanatantopihuë'. Tanshirinso pochin cancantatona', co yaquënantopihuë'. Noya ni'pi naporini, quënanchitonahuë'. Noya natanpi naporini, cancanëna quëran nataintonahuë'. Co noyahuë' yonquipisopita naniantatona' imarinaco naporini, anoyacancanchitohuë',’ tënin Yosë iráca. Ipora huanta' na'a piyapi'sa' ina pochin cancantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Canpitaso nipirinhuë', ma noya Yosë catahuarinquëma' ni'ton noya ni'namaco. Noya natanamaco. Napoaton noya cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iráca quëran huarë' na'a pënëntona'piro'sa', noya piyapi'sa', inapita canpita ni'namasopita yani'pirinahuë', co ni'pihuë'. A'chintëranquëmasopitanta' yanatanpirinahuë', co natanpihuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ina quëran ca'tano'sanënpita a'chintaantarin. “Natanco iyaro'sa'. Sha'tona'pi sha'ninso pochin nininso' a'chintanta'inquëma' no'tëquën nitotacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tricoraya pa'sarayarëso pochin Yosë nanamën ya'ipi parti a'chintërë'. ‘Yosë yahua'anëntarinquëma',’ topachina, a'naquën piyapi'sa' ira pochin nipi. Nanamën natanpirinahuë', co yonquipihuë'. Inairaro'sari huëcapairahuatona', pë'yaquipiso pochin a'naroáchin sopai huë'nin. Huë'sahuaton, Yosë nanamën natanpiso' osërëtiirin. Ananiantërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A'naquën piyapi'saso nipirinhuë', na'piro pochin niconpi. Yosë nanamën natanahuatona', a'naroáchin pa'yatatona', natëpirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","co cancanëna quëran huarë' natëpihuë'. Co chiníquën cancantatonaraihuë', co natëmiatopihuë'. Ma'sha onpohuachinara, a'naroáchin yaa'popi. Imapiso marë' aparisitohuachinara, a'popi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A'naquën piyapi'santa' nahuano' ya'huërinso pochin niconpi. Yosë nanamën natanpachinara, yaimapirinahuë', ma'sharáchin yonquiatona', naniantopi. ‘Na'a coriqui, ma'sha, inapita ya'huëtohuachincoi, nóya cancantarai,’ topirinahuë', co ina quëran noya cancantacasohuë' nipirinhuë'. Napoaton nahuano'sari imotërinso pochin, ma'sharáchin yonquiatona', Yosë nanamën naniantopi. Co imamiatopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A'naquën piyapi'saso nipirinhuë', noyaro'pa pochin nipi. Yosë nanamën natanahuatona', cancanëna quëran huarë' natëpi. Cara shonca, cara shonca nitërinso pochin a'naquën noyamiáchin imapi. A'naquëonta' saota shonca, saota shonca nitërinso pochin noya imapi. A'naquëonta' pasa, pasa nitërinso pochin ya'ipi cancanëna quëran imatona', noya noya imapi huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ina quëran a'chintaantarin: “A'nanta' iyaro'sa', a'chintaanta'inquëma' Yosë hua'anëntërinso' nitotacamaso marë'. A'na patron iminpachina, noya trico sha'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ina quëran tashihuachina, huë'ësoi' inimico huë'nin. Huë'sahuaton, inaquë chachin pacatëro' trico pochin ya'norinso' sha'quirin anta'. Trico sha'ninso' huancanaya ina huancanaya sha'quirin. Nani sha'pachina, pa'nin. Co incari tëranta' ni'ninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Inanta' pichopitahuaton, tricorë' napopianachin ya'norin. Cato chachin a'shinaponahuë', pacatëroso' co nitërinhuë'. Naporo huarë' nohuitopi huachi. ‘Isoso' co tricohuë', pacatëro',’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ina ni'sahuatona', piyapinënpitari sha'huitonpi. ‘Noyarayasachin asha'topiranhuë', ¿onporahuatonta' ina huáncana ina huancánachin pacatëro' papotërin?’ itonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Inimiconëhuë naporin,’ itërin patronënari. Napohuachina, piyapinënpitari itapona': ‘Nohuantohuatan, paatoi hua'chi'i, topiraihuë',’ itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ama napotocosohuë'. Ipora hua'tohuatama', triconta' ocoiarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tananpitoco' cato chachin a'shiina'. Nani macacaso' nanihuachin, sacatoro'sa' sha'huitarahuë. Pacatëro'ton masahuatoma', tonpoco' pënquë ahuiquitacaso marë'. Ina quëran tricosachin masahuatoma', pëinëhuëquë acotoco huachi, itarahuë,’ tënin patron,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ina quëran itaantarin: “Yosë hua'anëntërinso' a'chintaanta'inquëma'. Mostasaraya pochin ninin. Inaso ya'pirin pi'pira'huaya niponahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","iminquë sha'patëra papotohuachina, panca ta'an ninin. Nani a'shinpachina, inairaro'sa' huëcatona', inaquë pëirin,” itërin. (Inapochachin caniaritapon, caraíchin piyapi Yosë imapirinahuë', a'na tahuëri notohuaro' piyapi'sa' Yosë imasapi.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","“Naquëranchin iyaro'sa' Yosë hua'anëntërinso' a'chintaanta'inquëma'. Pan ahuëpocatërinso pochin ninin anta'. A'na sanapi pan nipachina, cara shonca quiro pochin trico no'mo' manin. Masahuaton, pi'pian tëranta' pan ahuëpocatërinso' ayontohuachina, ya'ipiya së'cotaton, ahuëpocatërin huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Notohuaro' piyapi'sa' niyontonpachinara, na'a pënënto nanan sha'huitërin. Ma'pochinsona nininsoáchin sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iráca pënëntona'piri ninoton, ninshitërin. “Piyapi'sa' a'chintahuato, ma'pochinsona nininso' a'chintarahuë. Isoro'pa' ninin quëran huarë' co piyapi'sa' nitotopirinahuë', a'chintarahuë huachi,” tënin iráca ninoton. Naporinso chachin ina pochin Quisosori a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ina quëran piyapi'sa' patahuaton, pëiquë ya'conconin. Inaquë ca'tano'sanënpitari itapona': “Achin sacai' pochin pënënto nanan a'chintopirancoihuë'. Pacatëro' sha'piso' co nitotëraihuë'. ¿Ma'ta' tapon naporan? A'chintantacoi nitochii,” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Inta nipachin, a'chinchinquëma'. Patron asha'tërinso pochin piyapi'sa' a'chintërahuë. Yosë quëran quëmapico ni'to, nanamën a'china'huaso marë' o'marahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Isoro'pa' panca imin pochin ninin. Yosë hua'anëntërinquë ya'conpisopitaso' noya ya'pirin pochin nipi. Sopai natëpisopitaso nipirinhuë', pacatëro' pochin niconpi. Co noyahuë' cancantatona', sopai natëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Inimico pacatëro' sha'ninso pochin sopai chachin nohuanton, co noyahuë' nipi. Nitërinso' manëso pochachin ayaro' tahuëri naniriarin. Nanihuachin, anquëniro'sa' o'maapi piyapi'sa' macacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pacatëro' ahuiquitërëso pochin ayaro' tahuëri pënquë ana'intacaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anquëniro'sa' a'pahuato, ya'ipi co noyahuë' nipisopita ayontonapi huachi. Anishacancantona'piro'santa' masapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Inapita masahuatona', pënquë të'yatapi. Inaquë chiníquën parisitatona', na'nërápona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yosë natëpisopitaso nipirinhuë', nóya ni'sarin. Pi'i a'pininso pochin Yosë hua'anëntërinquë ya'noapi. Huëratëhuanpatama', noya natanatomaco, yonquico',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ina quëran itaantarin: “Isonta' a'chinchinquëma' Yosë hua'anëntërinso' nitotacamaso marë'. A'na quëmapi ya'huëpirinhuë'. A'na no'pa' pa'taton, oro pochin nininsopita quënanconin. Acoporo' ya'huëpirinhuë', quënanconin. Pa'yataton, imotantarahuaton, pa'nin huachi. Ya'ipi ma'shanënpita pa'anahuaton, coriqui canarin quëran, ina no'pa' pa'anconin huachi. ‘Quënanahuëso' noya nóya,’ ta'ton, ina na'con na'con nohuantërin,” tënin. (Inapochachin Yosë hua'anëntinquëmaso' na'con na'con nohuantoco', tapon naporin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ina quëran itaantarin: “A'nanta' a'chinchinquëma' Yosë hua'anëntërinso' nitotacamaso marë'. A'na quëmapi pa'sárin huiri na'pira'huayaro'sa' pa'ton nininso' yonicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A'na tahuëri noya noya nininso' quënanin huachi. Na'con pa'tërin ni'ton, ya'ipi ma'shanënpita pa'anahuaton coriqui canarin quëran pa'anconin. ‘Ina na'con na'con nohuantërahuë,’ ta'ton, pa'anin huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ina quëran itaantarin: “A'nanta' a'chintaanta'inquëma' Yosë hua'anëntërinso' nitotacamaso marë'. Sami manëso pochin ninin. Panca riti marëquë të'yatohuatëra, notohuaro' sami manë'. Nisha nisha manë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na'a sami ya'conpachina, yonsanquë oshirë'. Ina quëran sami camayoro'sa' huënsërahuatona', sami nisha nisha huayonapi. Noya sami i'mëquë po'morapi. Napoonin nininsopitaso nipirinhuë', të'yatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ayaro' tahuëri inapochachin nisarin. Anquëniro'sa' o'marahuatona', ya'ipi piyapi'sa' nisha nisha huayonapi. Yosë yonquipisopita noya acoapi. A'naquënso nipirinhuë', co noyahuë' cancantopi ni'ton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","pënquë të'yatapi. Inaquë chiníquën parisitatona', na'nërápona huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ina quëran ca'tano'sanënpita natanin: —Nani a'chintëranquëmaso' ¿nitotërama' ti? itërin. —Nani nitotërai, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","—Yosë quiricanën nani nitotarama'. Yosë hua'anëntërinso' a'chintëranquëma' ni'ton, pëi' hua'anën pochin nisarama'. Pëi' hua'anën noya nipachina, ya'ipi pëinënquë ya'huëpisopita noya nocomarin. Nani na'con a'chintëranquëma' Yosë nanamën a'chinacamaso marë'. Iráca ninshitopiso' nitotërama'. Naporahuaton, a'nanta' nashamiachin a'chintaranquëma'. Ya'ipiya nitotatoma', a'chintëra'piarama', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nani a'chintohuachina, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ya'huërinquë chachin paantarahuaton, niyontonpiso pëiquë a'chintarin. Piyapi'sa' natanahuatona', nisha nisha yonquiatona', ninontopi. —¡Ma'pítacha nitotërin paya! ¿Macariso' a'chintomara? Piyapi'sa' a'naroáchin anoyatërin. ¿Onporahuatoncha nani ma'sha nanitaparin nicaya? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hua'huatapon quëran huarë' nohuitërëhua'. Pa'pinso' nontëcamayo. A'shinso' Maria itopi. Iinpitanta' nohuitërëhua'. Santiaco, Cosi, Simon, Cotasë, inapita itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Oshinpitanta' isëquë ya'huarin. Co Quisoso chiníquën nanantërinhuë'. ¿Onporahuatonta' nipachin ina pochin nitotërin? nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Co natëtonaraihuë' tëhuapi. Napohuachinara, Quisosori itërin: —Iráca quëran huarë' napopi. “Ya'ipi piyapi'sari pënëntona'pi noya natanpi. Ninanonënquë ya'huëpisopitaso nipirinhuë', co noyahuë' natanpi. Co quëmopinënpitari tëranta' yanatëpihuë',” topi iráca. No'tëquën napopi, tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","“Co Yosë quëran o'marinhuë',” ta'tona', co cancanëna quëran huarë' natëpihuë' ni'ton, co na'a piyapi'sa' a'naroáchin anoyatërinhuë'. Caraíchin cania'piro'sa' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ya'ipi Quisoso naporinso' nahuinin. Cariria hua'an Irotisë itopisonta' natantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Ma'pitacha nanitapaton, cania'piro'sa' a'naroáchin anoyatërin paya. Coansha Paotistaco' nanpiantarinso' tënahuë,” itërin piyapinënpita nontaton. I'huamiáchin Coansha atëpataton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","I'hua chachin Coansha nanpiso', Irotisë co noyahuë' ninin. Iin sa'in osërëtaton, manin. Pinipi sa'in chachin osërëtërin, Irotiasa itopiso'. Napoaton Coansha Paotistari chiníquën pënënin. “Yosë co nohuantërinhuë' iyaparin sa'in osërëtaton macamaso',” itërin. Napotohuachina, chiníquën no'huitaton, sontaro'sa' camairin macacaiso marë'. Masahuatona', tashinan pëiquë po'mopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chiníquën no'huiton, yatëpapirinhuë', piyapi'sa' të'huatërin. “Yosëri chachin Coansha a'parin pënëinpoaso marë',” ta'tona', noya ni'pi. Inapita të'huataton, co atëpatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ina quëran hua'huatërinso' tahuëri nanihuachina, pita ninin. Na'a piyapi'sa' amatërin. Naporo' Irotiasa hua'huin ya'conahuaton, ya'ipi piyapi'sa' ni'tërantapaquë nansararin. Nanon nansarinso' ni'sahuaton, hua'ani pa'yatërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Ma'sona tëranta', apia'hua, nohuantohuatan, nico quëchinquën. Yoscoarë' quëchinquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Itohuachina, a'shin paahuarin. —¿Ma'ta' mama ma'pai? itoonin. —“Coansha anishitëconotahuaton, motën quëtoco,” itëquë', itërin a'shini. Manorahuaton, hua'an ya'huërinquë paantarin. —Coansha motën nohuantërahuë. Sënanquë acorahuaton, apiramiáchin quëtoco, itoonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Natanahuaton, hua'an sëtërin. “Coansha noya quëmapi,” ta'ton, co huachi yonquirinhuë' tëpacaso'. Co yatëpapirinhuë', “Ya'ipi piyapi'sa' nataninaco, Yoscoarë' itërahuë,” ta'ton, sontaro'sa' a'parin tëpacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pa'sahuatona', tashinan pëiquë nishitëconotonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Motën sënanquë acorahuatona', nanon quëtopi. Nanonta' a'shin quëtoonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Napotohuachinara, imarinsopita natantahuatona' huë'pi. Nonën quëparahuatona', pa'pitopi. Ina quëran Quisoso sha'huitonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Coansha tëpapiso' natantahuaton, Quisoso piyapi'sa' patërin. Potiquë ya'conahuaton, co piyapi ya'huërinquëhuë' pa'nin. Piyapi'sa' natantahuatona', imapi. Ira pa'tatona', inahua'ton canconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Quisososo canconahuaton nonshipirinhuë', notohuaro' piyapi'sa' quënanconin. Quënanconahuaton, na'con nosororin. Noya nontaton, ya'ipi cania'piro'sa' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","I'huararahuaso', ca'tano'sanënpitari itiipi: —Nani i'huarin. Co manta' isëquë ya'huërinhuë'. Piyapi'sa' a'paquë' ninanoro'saquë pa'ina'. Inaquë cosharo' pa'anatona' ca'ina', itopirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Co iyaro'sa' pacacaiso' ya'huërinhuë'. Canpitari a'caco', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Capa isëquë capacaso'. A'natërapoíchin pan, catoíchin sami, inaíchin ya'huëtërincoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Inaya tëranta' quëshico, itohuachina, quëshiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ina quëran piyapi'sa' sha'huitërin pastoquë huënsëcaiso marë'. Nani huënsëhuachinara, Quisosori a'natërapoya pan, catoya sami, inapita manin. Masahuaton, inápaquë në'pëtahuaton, Yosë nontërin. “Yosparinquën, Tata,” itahuaton, pan, sami, inapita së'panahuaton, ca'tano'sanënpita quëtërin. —Piyapi'sa' quëtonco' ca'ina', itohuachina, quëtëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ya'ipi piyapi'sa' coshatopi. Natëaquë huarë' coshatopi. Ina quëran pë'sotopiso' mapi. Shonca cato' i'më' mëntatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A'natërápo huaranca pochin quëmapi'sa' coshatopi. Sanapi'santa' hua'huinarë chachin coshatopi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ina quëran ca'tano'sanënpita sha'huitërin. “Potiquë ya'conahuatoma', aquëtëran paco'. Nani piyapi'sa' nontohuato, canta' pa'sarahuë,” itohuachina, pa'pi huachi. Ina quëran piyapi'sa' nontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nani nontohuachina, panënquë inaora pa'nin Yosë nontacaso marë'. Inaquë Yosë nontaso', tashitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ca'tano'sanënpitaso nipirinhuë', sono' huancanai' tashitopi. Ya'ipi tashi' maitopirinahuë', panca ihuan nacapiatona', co nanitopihuë' chiníquën paacaiso'. Poti opoto opototarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Co tahuëriyátërasohuë', Quisoso huë'sapirinhuë', co nitotopihuë'. I' aipi i'narahuaton, no'pa pochin pa'tarin. Poti ya'cariarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ca'tano'sanënpitari quënanpirinahuë'. Ii' aipi i'narinso' ni'sahuatona', pa'yanpi. “Hua'yan” ta'tona', “ëë” topi. Chiníquën pa'yanpirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","a'naroáchin Quisosori nontërin. —¡Co'ta ca huë'sarahuë. Ama pa'yancosohuë'! Chiníquën cancantoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ina natanahuaton, Pitrori itërin: —Quëma Sinioro ni'quëhuarë', sha'huitoco pa'i. Canta' i' pa'tato nacapi'inquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Noyapa', huëquë', itohuachina, Pitro poti quëran nohuaraitahuaton, ii' aipi huanirin. Quisosoíchin yonquiaton, amasha huancanaimiachin noya pa'sapirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ihuani chiníquën aco'sacaitërinso ni'sahuaton, të'huatërin. Napohuachina acopoi' pa'sapirinhuë': —¡Catahuaco Sinioro! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A'naroáchin Quisosori maimirarin. Oshirahuaton, ahuaniintarin: —Co ya'ipi cancanën quëran natërancohuë' ni'ton, acopoi' pa'sapiranhuë'. ¿Onpoatonta' co noya natërancohuë'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ina quëran potiquë quësahuaton, ichiya'conin. Ya'conpachina, a'naroáchin ihuan sanorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Napohuachina, na'con yonquipi. —Quëmaso' Sinioro tëhuënchachin Yosë hui'ninquën, ta'tona' chinotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ina quëran aquëtëran canconahuatona', Quinisariti parti nonshipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ya'huëhuano'sari nohuitahuatona', nanan a'papi. “Quisoso nani canquirin,” topachinara, na'a cania'piro'sa' quëpi anoyatacaso marë'. Nisha nisha parti quëran huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“Quëma a'moranso' huirotën tëranta' së'huatona', noyachina',” itopi. “Inta nipachin së'huaina',” topachina, së'huapi. Insoarisona së'huahuachina, a'naroáchin noyatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ina quëran a'naquën parisioro'sa', cotio maistro'sa', inapita Quirosarin quëran huë'pi Quisoso natanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Onpoatonta' ca'tano'sanënpita co quiya pochin nipihuë'? Iráca shimashonënpoa' inachintopiso' a'chintërinënpoa'. “Co'huara coshachatërasëmahuë', i'shaquë pi'pian niopoimiratoco' ama oshahuanacaso marëhuë',” topi iráca. Quëmaso nipirinhuë' co ina pochin nicacaso' a'chintëranhuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Napotohuachinara, Quisosori itërin: —¿Onpoatonta' canpitanta' shimashonënpoa' inachintërinso' natëtoma', co Yosë pënëntërinso' natëramahuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Quiricanën quëran pënëninpoa'. “Tatama', mamama', inapita noya nicatoma natëco',” tënin. Naporahuaton, “Inso tëranta pa'pina', a'shina' inapita co noyahuë yonquirapitona' no'huihuachina', tëpaco',” tënin Yosë iráca. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Canpitaso nipirinhuë' nisha a'chinama'. “Ma'sha ya'huëtërincoso' nani acorahuë Yosë quëta'huaso marë',” topatëra, co tatanpo' quëtacaso' ya'huërinhuë', toconama'. Napoaton tatama' ma'sha pahuantohuachinara, apiratatoma', co quëtëramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Co quëtacaso' ya'huërinhuë',” toconama'. Ina pochin a'chinatoma', co Yosë quiricanën natëramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Yosë imarai,” topiramahuë', co imaramahuë'. ¡Canpitaso' nonpintënquëma'! Iráca Isaiasë ninshitaton, no'tëquën ninorinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yosë naporin: “Isopita piyapi'sa' nanamëna quëran noya nontopirinacohuë', co cancanëna quëran imarinacohuë'. Co ca pochin cancantopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","‘Yosë pënëntërinso' a'chinarai,’ topirinahuë', inahuara yonquinëna quëran a'chinpi. Napoaton topinan quëran chinotërinaco,” tënin Yosë. Iráca Isaiasë ninshitaton naporin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ina quëran piyapi'sa' përasahuaton, a'chintërin. —Ya'ipinquëma' natanco no'tëquën yonquicamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Coshatërëso marë' co oshahuanëhuë'. Cancanënpoa quëran yonquirëso marë' oshahuanëhuaso'. Tëhuënchachin co noyahuë' nonpatëra, oshahuanë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ina quëran ca'tano'sanënpitari sha'huitiirin. —Achin Maistro pënënancoi ni'ton, parisioro'sa' no'huirinënquën, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","—Ama ina marë' pa'yancosohuë'. Oshaquëran Yosëri ana'intarin. Ni'co'. Ma'sha sha'patëra, co pacatëro' pa'ararëhuë'. Ocoirahuatë' të'yatërë'. Inapochachin co nanamën imapisopitahuë' Yosëri a'poarin. Inapitaso' somaraya pochin cancantopi. Somarayaso' co nanitërinhuë' a'na somaraya noya quëpacaso'. Quëparin naporini, cato chachin panca naninquë anochitonahuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","—Achin Maistro a'chintërancoiso', a'chintaantacoi quiyanta' no'tëquën nitochii, itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Co canpita tëranta' yonquiyátëramahuë' ti? Inta nipachin, a'chinchinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nani ma'sha ca'nëhuaso marë', co ina marë' oshahuanëhuahuë'. Co cosharo' cancanënpoaquë ya'coninhuë'. Chi'chirinamënpoaquë ya'conin. Ina quëran inquiantarëhua'. ¿Co ina nitotëramahuë' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Napoaponahuë', cancanëma quëran co noyahuë' yonquihuatamara, co noyahuë' nonama'. Ina marë' oshahuanama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Co noyahuë' yonquihuatamara, tëpatërama', nitëhuananpitërama', monshihuanacasoáchin yonquirama', ihuatërama', nonpintërama', pinotërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ina pochin cancantohuatamara, oshahuanamaso'. Co i'shaquë niopoimiratarihuarahuënta', coshatohuatëhuara, co ina marë' oshahuanëhuahuë'. Cancanënpoa quëran nóya yonquicaso' ya'huërin. Ina Yosë nohuantërin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ina quëran Cotia parti quëran pipirahuaton, Tiro, Siton, inapita parti pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Naporo' a'na Canaan sanapi inaquë ya'huërinsoari huëcapairahuaton, chiníquën itapon: —¡Nosoroco, Sinioro! Quëmaso' Tapico' shinquën ni'ton, Yosë chachin acorinquën piyapi'sa' catahuamaso marë' tënahuë. Hua'huahuë parisitárin. Sopairi ya'coancantaton, chiníquën aparisitarin. Inquitoco, topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Quisososo' co a'panitaponahuë' pa'sapirinhuë', sanapiriso' imaraton: —Nosoroco Sinioro, itë́rarin. Ina ni'sahuatona', ca'tano'sanënpitari pi'pian no'huipi. —Iso sanapi a'paquë' pa'in. Imaquitonpoa', pinatano' níriarin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Napotohuachinara, sanapi itërin: —Quëmaso' imoya nisha piyapinquën. Israiro'sa' catahua'huaso marë' Yosë a'parinco. Inahuaso Yosë piyapinënpita nipirinahuë', ohuica chihuërinso pochin nipi ni'ton, catahuarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sanapiso nipirinhuë', isonquirahuaton moshaquirin. —Nisha sanapico nipirahuë', canta' Sinioro catahuaco, topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Ni'quë' imoya. Hua'huaro'sa' a'cahuatëra, co cosharonën osërëtahuatë' ni'nira a'carëhuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Naporin mini Sinioro. Napoaponahuë', pi'pian tëranta' cosharo' atatohuachina, ni'nira'huayari capitërin ni'ton, quiyanta' catahuacoi, topirahuë', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—¡Ma noya imoya natëranco! Ya'ipi cancanën quëran huarë' natëranco ni'ton, hua'huan anoyachinquën, itërin. Napotohuachina, a'naroáchin hua'huin noyatërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ina quëran Cariria sono' yonsanquë pa'sahuaton, a'na panënquë pantarin. Inaquë huënsëconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Napohuachina, notohuaro' piyapi'sa' huë'pi. Nisha nisha caniori maninsopita quësapi. A'naquën sonpacha, a'naquën somaraya. Apiaro'sa', në'huëyaro'sa', inapita quësahuatona', Quisoso pirayan acoipi. Inaquë acoihuachinara, ya'ipimiachin anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Piyapi'sari ni'sahuatona', pa'yatopi. “Ni'co'. Në'huëyaro'sa' nonsapi. Apiaro'sa' nani noyatopi. Sonpacharo'sa' noya iratopi. Somarayaro'santa' noya quënantopi. ¡Ma noyacha Yosëso paya! ¡Ma noyacha ni'ton, piyapinënpitanpoa catahuarinpoa paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ina quëran ca'tano'sanënpita përasahuaton, itapon: —Piyapi'sa' nosororahuë. Nani cara tahuëri pochin natanarinaco ni'ton, co huachi manta' cosharo' ya'huëtopihuë' capacaiso'. Co topinan yaa'parahuë', tanari canahuachina', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—Pa'pi notohuaro' piyapi'sa' yamorapi. ¿Intohuacha cosharo' macatë' isonapo' piyapi a'carë nicaya? Co pëi' isëquë ya'huërinhuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Onpo panta' ya'huëtërinquëma'? itohuachina, —Canchisëíchin pan, caraíchin sami, inaíchin ya'huëtërincoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ina quëran piyapi'sa' sha'huitërin no'paquë huënsëcaiso marë'. Sha'huitohuachinara, huënsëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nani huënsëhuachinara, canchisë pan, sami, inapita masahuaton, Yosë nontërin. “Yosparinquën Tata,” itërin. Ina quëran së'panahuaton, ca'tano'sanënpita quëtërin piyapi'sa' quëtacaiso marë'. Ya'ipi quëtëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nani quëtohuachinara, ya'ipiya natëaquë huarë' coshatopi. Ina quëran pë'sotopiso' masahuatona', canshisë i'më' mëntatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Catapini huaranca quëmapi'sa pochin coshatopi. Sanapi'santa' hua'huinarë chachin coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ina quëran piyapi'sa' nontahuaton, potiquë ya'conin. Aquëtëran pëntonahuaton, Macatan parti canconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ina quëran parisioro'sa', satosioro'sa' inapita Quisoso nontacaiso marë' huë'pi. Nonpintatona', nontopi atëhuëcaiso marë'. “Yosë a'paimahuachinquën, sacai' nicacaso nininso' niquë'. Quiyanta' ina nicatoi, natëiinquën,” itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","“¿Onpoatomata' iyaro'sa' co no'tëquën yonquiramahuë'? Ni'co'. O'nan nitoninorama'. I'huanahuanquë noyapihuayanchin nipachina, ‘Tashiraya noyahuantapon,’ tënama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tashiramiachin chistro yaratohuachinaso', ‘Ipora tahuëri o'nanapon nimara,’ tënama'. Ina nitotapomarahuë', ¿onpoatomata' ipora chachin naporahuësopita co yonquiramahuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ipora ya'huëramasopita co noyahuë' cancantërama'. Nitëhuananpitopisopita pochin cancantatoma', co pi'pisha tëranta' Yosë yanatëramahuë'. ‘Sacai' nicacaso nininso' niquë' natëiinquën,’ itopiramacohuë', co Yosë nohuantërinhuë' ina pochin nica'huaso'. Isoíchin anitotarinquëma'. A'na tahuëri canpita nitotacamaso marë', Conasë pochin nisarahuë” itërin. Ina quëran patërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ca'tano'sanënpita sono aquëtëran pëntonpirinahuë', naniantopi pan quëpacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ina quëran Quisosori itërin: —Parisioro'sa', satosioro'sa' inapita, pan ahuëpocatërinso' pochin ya'huëtopi. Ama iyaro'sa' ina nohuantocosohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Natanahuatona', ca'tano'sanënpita capini ninontopi. —¿Onpoatonta' naporin? tënin a'naso'. —Ahuën. Capa pan. Co quënëhuahuë' ni'ton, napotërinpoa' nimara, tënin a'nanta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ninontopiso' nitotaton, Quisosori itërin: —¿Onpoatonta' “capa pan,” toconama'? Tëhuënchachin co noya natëyatëraramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A'chintápiranquëmahuë', ¿ipora huanta' co yonquiramahuë' ti? Yonquico' iyaro'sa'. I'hua chachin a'natërápo painchin nipirinhuë' a'natërápo huaranca piyapi ananitërahuë. ¿Ina naniantërama' ti? Naporo' pë'sotopiso' shonca cato' i'më' mëntatërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ina quëran canchisë painchin nipirinhuë', catapini huaranca quëmapi'sa' ananitërahuë. Naporo' canchisë i'më' pë'sotopiso' manama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Onpoatomata' co yonquiramahuë'? “Pan ahuëpocatërinso pochin ya'huëtopiso' ama nohuantocosohuë',” itohuatënquëmara, co cosharo' yonquiato naporahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naporo huarë' yonquipi huachi: “Co pan chachin yonquiaton, naporinhuë'. Parisioro'sa', satosioro'sa' inapita a'chinpiso' yonquiaton, pënëninpoa'. Pi'pisha pan ahuëpocatërinso' së'yonpachinara, a'naroáchin së'cotërin. Inapochachin inapitanta' co no'tëquën a'chinatonaraihuë', piyapi'sa' anishacancantopi, tapon napotërinpoa',” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ina quëran Sisaria Pinipo parti pa'pi. Inaquë ca'tano'sanënpita itapon: —Nani ma'sha nanitaparahuëso marë', ¿inpochinta' piyapi'sa' cancantërinaco? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Nisha nisha cancantiarinën: “Coansha Paotistaco' nanpiantarinso' ni'ton, naporin,” topi a'naquën. “Co inahuë'. Iniasëco' nanpiantamara,” topi a'naquëonta'. “Pënëntona'pi iráca chiminpirinhuë', nanpiantarinso' nimara, tomantatona', Irimiasë nimara,” topi a'napitanta', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Canpitapo'? ¿Incota tënama'? itërin. Itohuachina, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pitrori itërin: —Quëmaso' Cristo. Yosë hui'nin chachinquën. Ina nanpiton, a'paimarinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Ma noyacha iyasha Yosë catahuarinquën ni'ton, naporan. Napoaton noya cancantëran. Co quëmaora yonquinën quëran nitotëranhuë'. Tata Yosë chachin anitotërinquën. Quëmaso' Conasë hui'ninquën. Simon itopirinënquënhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","nasha nininën acochinquën. Pitro itaranquën. Ca nohuanto, na'pitëquë noya pëipiso pochin na'a piyapi'sa' a'chintaran imainacoso marë'. A'chintohuatan, huëntonëhuëquë aya'conarahuë. Oshaquëran na'asarama huachi. Co chimirin tëranta' minsëarinquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A'na tahuëri chiníquën nanan quëchinquën a'napita a'chintacamaso marë'. Yosë huëntonënquë ya'conacaiso' a'chintaran. Ya'coana niahuiquë i'soatërëso pochin piyapi'sa' catahuaran ya'conacaiso marë'. Ina quëran ma'sona noya nicacaiso' a'chintaran. Insosona co yanatëhuachinquënhuë', sha'huitëquë': “Tëhuënchachin co Yosë ya'huërin'pa' pa'saranhuë',” itëquë'. Yosërinta' inachachin sha'huitarin. A'naquënso nipirinhuë', noya natanpi quëran cha'ësapi huachi. Yosërinta' noya ni'sarin. Natërinaco ni'ton, oshanëna' Yosëri inquitarin. Napoaton huëntonënquë ya'conapi huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ina quëran ya'ipi ca'tano'sanënpita itapon: “Ca mini Cristoco. Yosë chachin acorinco piyapi'sa' nicha'ëca'huaso marë'. Ina nitotapomarahuë', ama iporaso' a'napita sha'huitocosohuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naporo quëran huarë' chiminacaso' ninoton, ca'tano'sanënpita sha'huitërin: —Quirosarinquë pa'pato, na'con parisita'huaso' ya'huërin. Cotio ansiano'sa', corto hua'ano'sa', cotio maistro'sa', inapita co huachi quë'yaarinacohuë'. Tëpaarinaco. Chiminaporahuë', cara tahuëri quëran Yosë ananpitaantarinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ina natanahuaton, a'naroáchin Pitrori amasha quëparahuaton, chiníquën pënënin: —¡Ama Sinioro napoquësohuë'! Ama Yosë nohuanchinsohuë', itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Quisosori tahuërëtahuaton, itërin. —¡Ta'tëquë' iyasha! Sopai nohuanton, napotëranco. ¿Yaanishacancantëranco ti? Co Yosë pochin yonquiranhuë'. Piyapinquën ni'ton, quëmaora nohuantëransoachin yonquiran, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ina quëran ya'ipi ca'tano'sanënpita itërin: —Yaimapatamaco, canpitaora nohuantëramaso' naniantatoma', Yosë nohuantërinsoráchin imaco'. Corosëquë chiníquën parisitërë'. Canpitanta' parisitapomarahuë', imamiatoco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Noya nanpicamasoáchin yonquihuatama', topinan quëran nanpiarama'. A'na tahuëri chiminpatama', parisitomiatarama'. Nipirinhuë', casáchin yonquihuatamaco, parisitapomarahuë' co topinan quëran nanpiaramahuë'. Yosë'pa' nanpimiatarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ya'ipi ma'sha isoro'paquë ya'huërinsopita canapiramahuë', co hua'yanëma' cha'ëpachinhuë' topinan quëran nisarin. ¡Onponta' pahuërëtapiramahuë', co huachi hua'yanëma' nanitarinhuë' cha'ëcaso'! ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yosë quëran quëmapico ni'to, a'na tahuëri o'mantararahuë. Tatahuë huënaratërinso pochin canta' huënaratarahuë. Anquëniro'sapitarë'co o'mantararahuë. Naporo' coisë pochin no'tëquën sha'huitarahuë huachi. Noya nipachina', noya acoarahuë. Co noyahuë' nipachina', ana'intarahuë huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tëhuënchachin isoro'pa' hua'anëntapo. A'naquëma' co'huara chimiyantërasënquëmahuë', hua'anëntarahuëso' ni'sarama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Saota tahuëri quëran Quisoso pa'nin motopi'pa'. Pitro, Santiaco, Coansha, inapitaráchin quëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Inapitari nicasoi', nisha pochin ya'norin. Ya'ipi ya'pirin pi'i pochin a'pinin. A'morinso' huënaráchin huënaráchin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A'nanaya Moisësë, Iniasë, inapita quënanpi. Iráca ayapirinahuë', Yosë nohuanton, ya'noantatona'. Quisosorë' ninontapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ina ni'sahuaton, Pitrori itërin: —¡Ma noya Sinioro isëquë huë'nëhua'! Nohuantohuatan, cara imënamëa'huaya nii, a'nara' quëma marë', a'nanta' Moisësë marë', a'nanta' Iniasë marë', topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nonaquëya', chitorori imotërin. Huënaráchin huënaráchin ninin. Chitoro' huáncana quëran Yosëri sha'huitërin: “Isoso' ca hui'nahuë, na'con nosororahuëso'. Nóya ni'nahuë. Ina noya natanco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ina natanahuatona', chiníquën pa'yanpi. Isonahuatona', nipa'copirayatopi. Monshoápirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Quisosori së'huaquirahuaton: —Ama huachi iyaro'sa' pa'yancosohuë'. Huaniantaco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Napotohuachina në'pëtintapirinahuë', Quisosoráchin quënanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ina quëran motopi quëran nohuaramapona pochin, Quisosori itërin: —Achin ni'namaso', ama insonta' sha'huitocosohuë'. Yosë quëran quëmapico ni'to, a'na tahuëri nanpiantarahuë. Naporo huarë' a'napita sha'huitoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","—Pi'pian Sinioro yanatanainquën. Maistro'sa' Yosë quiricanën a'chinpachinara, napopi: “Co'huara Cristo o'mayatërasohuë', Iniasë'ton huëantarin,” topi. ¿Onpoatonta' napopi? itërin ca'taninsopitari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—No'tëquën napopi. “Noya ayonquiantacaso marë' huëantapon,” tënin pënëntona'pi ninoton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Carimaso nipirinhuë' sha'huitaranquëma'. Nani mini huëantapirinhuë', co nohuitopihuë'. Co yanatëtonaraihuë', inahuara yonquinëna quëran no'huipi. Canta' Yosë quëran quëmapico nipirahuë', inapochachin aparisitarinaco, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Napotohuachina, ca'tano'sanënpita yonquipi huachi: “Tëhuënchachin i'hua Coansha Paotista pënëntërin. Iniasë pënëntërinso pochachin pënëntopirinhuë', co yanatëpihuë',” topi yonquiatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nani nohuaraimantahuachinara, na'a piyapi'sa' quënanquimarin. A'na quëmapiso' huë'sahuaton, isonquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Hui'nahuë Sinioro nosorotoco. Chiníquën parisitarin. Sopai nohuanton, no'paquë nitë'yatahuaton, sa'po sa'po niconin. Pacoro pacorotarin. A'na tahuëri pënquë anotërin. A'na tahuëri i'quë nitë'yaitërin. Naporárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ca'tano'sanënpita sha'huitato: “Sopai inquitoco',” itopirahuë', co nanitopihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","—¡Ma'huantacha ninama paya! Canpitaso' co Yosë natëramahuë'. Co natëtochináchinhuë' cancantërama'. Nani hua'qui' a'chintopiranquëmahuë', ¿onporo huarëta' yanatëramaco? itahuaton, —Hua'huasha quëshico, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Quëntahuachina, Quisosori sopai nontërin. “Iso hua'huasha tananpitëquë'. Pipimiatëquë huachi,” itohuachina, a'naroáchin sopai pipirin. Hua'huasha noyatërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ina quëran inaora ya'huaso', ca'tano'sanënpitari natanquirin. —¿Onpoatonta' Sinioro co quiyariso' nanitëraihuë' inquita'huaiso'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Co ya'ipi cancanëma quëran huarë' natëramacohuë' ni'ton, co nanitëramahuë'. Natëramaco naporini, catahuaitënquëmahuë'. Yosëso' ya'ipiya nanitaparin. Pi'pian tëranta' ina natëtoma', nontohuatama', catahuarinquëma'. Nani ma'sha nanitaparama'. “Yosë nohuanton, iso motopi ya'huinca'in,” tënama' naporini, ina nohuanton, ya'huincaitonhuë'. Inapochachin ya'ipi cancanëma quëran natëramaco naporini, sacai' nininso' catahuaitënquëmahuë'.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Isanpi sopaiso nipirinhuë' sacai' inquitacaso'. Ayono nicatë chiníquën Yosë nontaquë huarë', inquitërë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cariria parti papona pochin, Quisosori ca'tano'sanënpita sha'huitaantarin: —Yosë quëran quëmapico nipirahuë', piyapi'sa' masarinaco. Sha'huirapihuachinaco, masarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mapachinaco, tëpaarinaco. Chiminaporahuë', cara tahuëri quëran Yosë ananpitaantarinco huachi, itërin. Natanahuatona', pa'pi, sëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capinaomoquë canconpachinara, a'naquën Yosë pëinën marë' coriqui ma'patona'piro'sa' huë'pi. Huëcatona', Pitro itiipi: —Yosë chinotopiso pëi' tapacaso marë' ya'ipinpoa' pi'pian coriqui quëtacaso' ya'huërin. ¿Quëma maistronënso' co pahuërëtërinhuë' ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Pahuërëtërin mini, itërin Pitrori. Ina quëran pëiquë ya'conpachina, inaquë Quisoso quënanconin. Co'huara sha'huichátërasohuë', inari ninoton, itërin: —Pi'pian iyasha natainquën. Copirnoro'sa' coriqui nohuantohuachinara, ¿inpitata' ma'parin? ¿Quëmopinënpita quëran huarë' ma'parin to? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Co quëmopinënpitaso' ma'parinhuë'. Nisharo'saráchin ma'parin, itërin Pitrori. —No'tëquën naporan. Napoaton co hui'ninpitariso' quëtacaso' ya'huërinhuë'. Inapochachin Yosë pëinënquë nicacaso' ya'huërin. Co caso' quëta'huasohuë' nipirahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ama no'huitacaiso marëhuë' carinta' quëchi. Sono' yonsanquë pa'sahuaton, yo'natëquë'. Ya'nan ohuararanso' sami nanamënquë ni'quë'. Inaquë coriqui quënanaran. Masahuaton, quëtonquë'. Catoënpo marë' naniarin, itërin. Pitro pa'sahuaton, Quisoso ninorinso chachin quënanconin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ina quëran ya'ipi ca'tano'sanënpitari paahuarahuatona', Quisoso natanpi. —A'na tahuëri Yosë isoro'paquë hua'anëntohuachin, ¿insota' chini chiníquën nanantarin? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ina natanahuaton, a'na hua'huasha përasahuaton, huancánachin ahuanirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Natanco iyaro'sa' pi'pian a'chinchinquëma'. Co no'tëquën yonquiyátëraramahuë'. Hua'huasharo'sa' yonquico'. Co chiníquën nanan nohuantopihuë'. Co a'napita nocanpihuë'. Co inapita pochin cancantohuatamahuë', co onporonta' Yosë hua'anëntërinquë ya'conaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hua'an pochin cancantacamaso' naniantatoma', hua'huasha pochin sano cancantoco'. Ina quëran Yosë noya noya ni'sarinquëma huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Imaramaco ni'ton, ya'ipiya nicatahuacaso' ya'huërin. Hua'huaro'santa' nosorohuatama', canta' nosoroaramaco. Ya'ipi hua'huaro'sa pochin cancantopisopitanta', noya ni'co'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Hua'huasha natërincoso' anishacancantohuatama', Yosë chiníquën ana'intarinquëma'. A'naquëonta' imasapirinacohuë', co chiníquën cancanchatërapihuë'. Inapitanta' anishacancantohuatama', ana'intarinquëma'. Co'huara inapita anishacancanchatërapomahuë', marëquë chimiitërama' naporini, noya noya niitomahuë'. Pancara'piquë a'sonconotahuatënënquëma', të'yaitërinënquëma' naporini, co aquëtë' oshahuaintomahuë'. Piyapi anishacancantacaso', pa'pi co noyahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Isoro'paquë sacai' Yosë imacaso'. Nisha nisha ya'huërin piyapi'sa' anishacancantacaiso'. Ina marë' oshahuanpi. Anishacancantona'piso nipirinhuë', na'con na'con oshahuanin. Yosëri chiníquën ana'intarin ni'ton, ¡ma'huantacha nisarin paya! ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Napoaton imirama quëran, nantëma quëranhuë nipon co noyahuë' nipatama', oshahuanama'. Ninishitëimiratërama', ninishitërantëtërama', ninapotërama naporini, noya noya niitomahuë'. Tantoimira, tantorancha nipomarahuë', Yosë'pa' paatoma', co parisitopiquë pa'itomahuë'. Imirama', nantëma', inapita nishitëtëramaso pochin cancantatoma', ya'ipi aoshahuaninquëmaso' a'poco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ya'pirama quëran quënanamaso marë' co noyahuë' yonquihuatama', pa'pi co noyahuë' nisarama'. Ya'pirama' ocoirama' naporini, noya noya niitomahuë'. Somaraya nipomarahuë', co parisitopiquë pa'itomahuë'. Cato quëran chachin noya ni'tapomarahuë' parisitopiquë të'yatohuachinënquëma', pa'pi co noyahuë' nisarama',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ina quëran Quisosori itaantarin: “Ama a'na hua'huasha tëranta' nocancosohuë'. Inahuanta' Yosëri nosororin. Nani anquëniro'sa' sha'huitërin a'naya a'naya a'paicaiso marë'. Tata Yosë'pa' ya'huatona', Yosë nontapi.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na'a piyapi'sa' co noyahuë' cancantatona', chihuëpiso pochin nipi. Yosë quëran quëmapico ni'to, o'marahuë inapita nicha'ëca'huaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ni'co'. A'na quëmapi pasa ohuicaro'sa' pë'tahuarin. Ya'ipiya nosororin. Pastoquë coshatacaiso marë' quëparinquë a'naya tëranta' chihuëhuachina, yonípon pa'nin. A'napitaso' inaquëranchin patahuaton, hua'qui' yonisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Quënanahuaton, pa'yatarin. Iscon shonca iscon ohuicanënpita co chihuëpirinahuë', co inapitaráchin yonquirinhuë'. A'naíchin chihuërinso' quënanahuaton, na'con na'con pa'yatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Inapochachin Tata inápaquë ya'huërinso' nosororinquëma'. Hua'huaro'santa' nosororin. Co nohuantërinhuë' a'naya tëranta' parisitopiquë paacaiso',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ina quëran Quisosori pënëantarin. “Imapatamaco, iyaparima pochin ninicamaso' ya'huërin. A'naquën ma'sha onpotohuachinquën, quëmaora paaton, nanan anoyatëquë'. Ina quëran oshaquëran pënënquë' noya yonquianta'in. Noya natëhuachinquën, oshanën marë' tëhuënchachin sëtohuachin, noya cancantaantarin. Iyaparima pochin ninosoroantarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nipirinhuë', co yanatëhuachinquënhuë', a'na ya'pihuë nipon, catohuë nipon pënënanso natanacaiso marë' quëparahuaton, nontoantaquë'. Iyaro'sa' quëparansopitanta' noya nataina' ama pi'pian tëranta' nonpinacaso marëhuë'. Inapitarinta' pënëina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Co inapita tëranta' yanatëantahuachinhuë', ya'ipi imaramasopita niyontonpachina', ya'ipiya sha'huitëquë' inahuarinta' nanan anoyachina'. Inapitarinta' pënëantapirinahuë', co inapita tëranta' yanatantahuachinhuë', ama huachi iyama pochin ni'cosohuë'. Co imarinso pochinhuë nipon, Noma copirno marë' coriqui ma'patona'pi pochin nipon ni'co huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Oshahuanacaso' co yananiantohuachinhuë', sha'huitëquë': ‘Tëhuënchachin iyasha oshahuanan. Co naniantëranhuë' ni'ton, co Yosë inquitarinquënhuë',’ itëquë'. Yosërinta' inachachin napotapon. Nipirinhuë', oshanën marë' sëtaton Yosë yonquiantahuachin, noyatapon. ‘Oshanën iyasha Yosë inquitarinquën,’ itëquë'. Yosërinta' oshanën inquitaton, noya ni'sarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Catoyanquëma tëranta' napopianachin yonquiatoma Yosë nontohuatama', Yosë natanatënquëma', catahuarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chinotamacoso marë' niyontonpatama', canpitaro'co ya'huarahuë. Carayanquëma tëranta' niyontonpatama', canta' inaquë ya'huërarahuë,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ina quëran Pitrori itërin: —A'na iyahuë Sinioro ma'sha onpotohuachinco, nanan anoyachi, tënahuë. Nipirinhuë', naquëranchin naquëranchin ma'sha onpotohuachinco, ¿onpo onporota' nanan anoyachi? ¿Canchisëro' pochin nimara ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Co canchisëroichin nanan anoyatacaso' ya'huërinhuë'. Canchisë shonca canchisëro' anoyatoco', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ina quëran itaantarin: “Yosë hua'anëntërinso' a'chinchinquëma', natanco'. A'na hua'an naporinso pochin ninin. Na'a piyapinënpitari nihuirin ni'ton, a'naya a'naya amatërin natanacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Napohuachina, a'nara' quëntapi na'a huaranca nihuirinso'. Co apira pahuërëtochináchinhuë' nihuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","‘Hua'huayátërahuë nihuirinco ni'ton, co onporonta' nanitarinhuë' pahuërëincoso',’ ta'ton, inpriatonën itapon: ‘Iso quëmapi co nanitërinhuë' pahuërëincoso'. Chiminaquë huarënta' sacatopirinhuë', co onporonta' pahuërarincohuë'. Napoaton ya'ipi ma'shanënpita matonquë'. Ina quëran inaora chachionta' pa'anquë'. Sa'in, hui'ninpitarë chachin pa'anquë' pi'pian tëranta' cana'i,’ itërin hua'ani. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ina natanahuaton, nihuitona'pi chiníquën pa'yanin. Isonahuaton, nohuantaso' mosharin. ‘Nosoroco sinioro oshaquëran ya'ipiya pahuërë'inquën. Ama pa'ancoisohuë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Napotohuachina, hua'ani nosororin. Nosoroaton, ya'ipi nihuirinso' ayataton noya a'parin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nihuitona'piso nipirinhuë' pipirahuaton, a'na iin pi'pian nihuirinso' quënanconin. Pasa tahuëri sacatohuachina canarinsoichin nihuipirinhuë', maconorahuaton, chiníquën no'huirin. ‘Ya'ipi nihuirancoso' apiramiáchin pahuërëco huachi,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ina quëmapinta' isonahuaton, na'con mosharin. ‘Nosoroco iyasha oshaquëran ya'ipi pahuërëaranquën,’ itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","co pi'pian tëranta' nosororinhuë'. Tashinan pëiquë apo'motërin. ‘Pahuërëtaquë huarë' pipiin,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hua'an piyapinënpitaso' ina ni'sahuatona', no'huitopi. ‘¡Ma'huantacha ninin paya! Co pi'pian tëranta' nosororinhuë',’ ta'tona', hua'anëna ya'ipiya sha'huitonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ina natanahuaton, nihuitona'pi amataantarin. ‘¡Quëmaso' pa'pi co noyahuë' cancantëran! “Nosoroco,” itëranco ni'ton, hua'huayátërahuë nihuipirancohuë', ya'ipiya topinan ayatëranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Carinquën nosororanquënso pochachin a'na iyasha nosorocamaso nipirinhuë', ¿co pi'pian tëranta' nosororanhuë' ti?’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ina quëran chiníquën no'huiton, sontaro'sa' amatahuaton, tashinan pëiquë apo'motërin anta'. ‘Pahuërëinco huarë' chiníquën aparisitëquë',’ itërin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ina quëran itaantapon: —Inapochachin Tata Yosë na'con nosoroatënquëma', ya'ipi oshanëma' yainquitopirinquëmahuë', co canpita capini nanan anoyatohuatamahuë', co oshanëma' inquitarinquëmahuë'. Chiníquën parisitarama'. Ya'ipi cancanëma quëran huarë' nanan anoyatacaso' ya'huërin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nani a'chinahuaton, Cariria quëran pipirin. Cortanii' aquëtëran paaton, Cotia parti cancoantarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Notohuaro' piyapi'sari imasapi. Inaquë na'a cania'piro'sa' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ina quëran a'naquën parisioro'santa' huë'pi. Nonpintatona', atëhuëcaiso marë' nontiipi: —¿Noya ipora sa'anpo' të'yatacaso' ti? itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—¿Ma'ta' Yosë quiricanën quëran sha'huitërinpoa'? Iráca ya'nan piyapi nipon, catoíchin Yosëri ninin. A'na quëmapi, a'na sanapi, inaíchin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Napoaton quëmapi sa'apachina, pa'pin, a'shin, inapita patahuaton, sa'inë' nichinpitacaso' ya'huërin. Cato' piyapi nipirinhuë', a'naíchin pochin Yosëri ni'nin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Catoya'pi nipirinhuë', a'naíchin pochin ni'nin. Nani Yosëri asë'quërin ni'quëhuarë', co onporonta' sa'ama' të'yatacaso' ya'huërinhuë', tënahuë, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","—¿Onpoatonta' nipachin, iráca Moisësëso' pënëninpoa' sa'anpo' të'yatacaso'? “Sa'anpo' yatë'yatohuatëra, coisëquë aninshitahuatë', të'yatërë',” tënin, itopi parisioro'sari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Co të'yatacaso' pënëninquëmahuë'. Co natantochináchinhuë' cancantërama' ni'ton, napotërinquëma'. “Coisëquë ninshitaquë huarë' të'yatërë',” itopirinquëmahuë', ya'nan nipon quëran huarë' co Yosë nohuantërinhuë' sa'ama' të'yatacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Napoaton carinquëma' pënëinquëma'. Co sa'ama' monshihuanpirinhuë', të'yatohuatama', oshahuanama'. Ina quëran a'na sanapi mapatama', co inaso' sa'amahuë'. Monshitëramaso pochin Yosëri ni'nin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ina natanahuatona', ca'tano'sanënpitari itapona': —Ina pochin ni'quëhuarë', co noyahuë' sa'acaso' nimara, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—A'naquën mini Yosë nohuanton co sa'apihuë'. Na'con na'conso nipirinhuë' noya sa'acaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","A'naquën hua'huatapona quëran huarë' inachin co nanitopihuë' sa'acaiso'. A'naquëonta' a'napitari ma'sha onpotërin ni'ton, co huachi nanitopihuë'. A'naquëonta' na'con na'con Yosë marë' yasacatatona', co sa'apihuë'. Ina pochin nicacamaso' nohuantohuatama', inapoco', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ina quëran hua'huaro'sa' quëpi Quisosori së'huamotocaso marë'. Inapotahuaton, inapita marë' Yosë nontërin. Na'a hua'huaro'sa' quëntapirinahuë', ca'tano'sanënpitari co nohuantopihuë': —Ama napotocosohuë'. Quisoso apinama', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Quisososo nipirinhuë' tënin: —Tananpitoco' hua'huaro'santa' huë'ina'. Ama a'pacosohuë'. Hua'huaro'sa' a'naroáchin yaimarinaco. Inapita pochin cancantohuatama', Yosë hua'anëntërinquë ya'conarama', itahuaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","hua'huaro'sa' së'huamotorahuaton, Yosë nontërin noya ya'huëcaiso marë'. Nani Yosë nontohuachina, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ina quëran a'na quëmapiri huëcapairin. —¿Ma'ta' Maistro caso' nii nanpimiata'huaso marë'? Sha'huitoco canta' noya nii, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Ma'marëta' noya nininso' natananco? Yosëíchin noya noyaso'. Nanpimiatamaso' nohuantohuatan, pënëntërinso' natëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Insopitata' natëca'huaso' ya'huërin? itërin ma'huani. —“Ama piyapi tëpaquësohuë'. Nani sa'an ya'huëtohuachinquën, ama monshihuanquësohuë'. Ama ihuatëquësohuë'. Ama nonpinapiquësohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tata natëquë'. Mamanta' natëquë'. Quëmaora ninosororanso pochachin a'napitanta' nosoroquë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Hua'huatapo quëran huarë' inapita natërahuë. ¿Ma'ta' pahuantarinco nica'huaso'? itaantarin ma'huani. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Yosë pochachin cancantamaso' nohuantohuatan, ya'ipi ma'shanënpita pa'anconahuaton, coriqui canaranso' sa'ahuaro'sa' quëtëquë'. Ina quëran imaco huachi. Co huachi ma'sharáchin yonquihuatanhuë', inápaquë canamiataran, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ina natanahuaton, co huachi noya cancantërinhuë'. “Hua'huayátërahuë ma'sha ya'huëtërinco,” ta'ton, sëtërin. Sëtaton, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nani pa'pachina, ca'tano'sanënpita itërin: —Sacai quëran ma'huano'sa' Yosë hua'anëntërinquë ya'conapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ni'co' iyaro'sa'. Nahuan huëratën pi'pira'huaya naninën ya'huëtërin. Camiyoso panca masho ni'ton, sacai' inaquë ya'conacaso'. Ma'huano'saso' ina quëran saca sacai Yosë hua'anëntërinquë ya'conacaiso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ina natanahuatona', pa'yanpi. —Napoahuarë' ¿cha'ërë'po ta'ma a'naya tëranta nica? nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ya'ipiya notëërahuaton, itapon: —Co insonta' inaora nanitërinhuë' cha'ëcaso'. Yosëíchin nanitërin anoyacancantinquëmaso'. Ya'ipiya nanitaparin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","—Ni'quë' Maistro. Quiyaso' ya'ipi ma'shanëhuëi patahuatoi, imasarainquën. ¿Ma'ta' ina marë' canapoi? itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Tëhuënchachin iyaro'sa' canaarama'. Yosë quëran quëmapico ni'to, a'na tahuëri ya'ipiya anoyatarahuë. Naporo' noya noya ya'noato, hua'anëntacaso' shiraquë huënsëarahuë. Inaquë coisë pochin no'tëquën sha'huitarahuë. Canpitanta' acoaranquëma' ya'ipi israiro'sa' shonca cato' huënton chachin nininso' hua'anëntacamaso marë'. Shonca catonquëma' napoarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A'naquëma mini imamacoso marë' ma'shanëma' patarama'. Ina marë' Yosë acanaarinquëma'. A'naquëma' pëinëma', iyaparima', oshiparima', tataparima', mamaparima', sa'ama', hui'nama', no'panëma' inapita patarama' a'chinacaso marë'. Inapohuatama', a'naíchin marë' pasa aquëtë canarëso pochin quëtarinquëma'. Ina quëran a'na tahuëri Yosë'pa' nanpimiatarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","A'naquënso ipora chiníquën nanantopirinahuë', a'na tahuëri topinan piyapi pochin nisapi. A'naquënso nipirinhuë' ipora topinan piyapi pochin nicaponaraihuë', a'na tahuëri chiníquën nanantapi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Natanco iyaro'sa', Yosë hua'anëntërinso' a'chintaanta'inquëma'. A'na quëmapi ya'huërin, pancana no'pa' hua'anëntërinso'. Inaquë opasáchin sha'nin. Panca imin ya'huëtërin ni'ton, piyapi'sa' nohuantërin iminënquë asacatacaso marë'. Tashiramiachin pa'nin sacatoro'sa' yonípon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A'naquën quënanconahuaton: ‘Sacatoco',’ itohuachina, natanpi. ‘¿Onpo marëta' asacatarancoi?’ itohuachinara: ‘A'napita canapiso nápo' pahuërëaranquëma',’ itërin. ‘Noyahua'. Ina nápo marë' ni'quëhuarë', sacatarai,’ topachinara, iminënquë a'parin sacatacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ina quëran yono pi'iriahuaso', cachiquë paantarin a'na sacatoro'sa' yoniantacaso marë'. A'naquën quënancoantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Canpitanta' iminëhuëquë sacatoco' no'tëquën pahuërë'inquëma',’ itohuachina: ‘Noyahua'. Sacachii nipachin,’ ta'tona', inahuanta' paantapi sacatapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ina quëran camotëchin naquëranchin cachiquë paantarahuaton, a'napitanta' iminënquë a'parin sacatacaiso marë'. Tëhuërënahuaso', inapotaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","I'huaraya huarë' naquëranchin cachiquë paantarahuaton, quëmapi'sa' quënancoantarin. ‘¿Onpoatomata' topinan huaniarama'? ¿Ya'ipi tahuëri ipora co sacatëramahuë' pa'?’ itoonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Co sacachátëraraihuë'. Co inso tëranta' camairincoihuë' ni'toi, ninaarai,’ itopi. ‘Inta nipachin, canpitanta' iminëhuëquë sacatoco',’ itërin. A'na oraíchin pi'i ya'conacaso' nisapirinhuë', pa'pi sacatapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nani tashihuachina, hua'anëni inpriatonën sha'huitërin: ‘Ya'ipi sacatoro'sa' amatahuaton, pahuërëquë'. I'huaraya huarë' sacatërinsopita'ton pahuërëquë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A'na oraíchin sacatopirinahuë', huë'pachinara, ya'ipi tahuëri nanirinso' pahuërërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tashiramiachin sacatopisopita ina ni'sahuatona', yonquiapi: ‘Na'con na'con canpoaso' pahuërëarinpoa',’ ta'tona', huë'pirinahuë'. Ina nápo chachin pahuërërin anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Coriqui ma'pataponaraihuë', hua'anën no'huiconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Pasopitaso', a'na oraíchin sacatopi. Quiyaso nipirinhuë', ya'ipi tahuëri sacatërai. Tashiramiachin quëran huarë' pi'i pi'carincoi. Hua'qui' sacatopiraihuë', napopianachin pahuërërancoi. Co no'tëquën pahuërërancoihuë',’ itërin a'nari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Co'chi iyasha nonpintëranquëmahuë paya. Ina nápo coriqui marë' ya'ipi tahuëri sacatarai, itëramaco ni'ton, no'tëquën pahuërëranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Canaranso' masahuaton, paquë huachi. A'napitaso' co hua'qui' sacatopirinahuë', caora nohuanto, ya'ipi tahuëri nanirinso' pahuërërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Caoranquën coriqui ni'ton, onposona nohuantohuato, inanapo pahuërëta'huaso' ya'huërin. Inapita nosoroato, pahuërërahuëso marë' ¿no'huiramaco ti?’ itahuaton, a'parin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tëhuënchachin a'naquënso' ipora co piyapi'sari noya ni'pirinahuë', a'na tahuëri Yosëri nóya ni'sarin. A'naquënso nipirinhuë' ipora piyapi'sari noya ni'pirinahuë', a'na tahuëri co Yosëri noya ni'sarinhuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ina quëran Quirosarinquë paantapi. Papona pochin ca'tano'sanënpita amashamiachin quëparahuaton, inapitaráchin sha'huitantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Natanco iyaro'sa'. Quirosarinquë paantarëhua'. Inatohua' Yosë quëran quëmapico nipirahuë', sha'huirapiarinaco. Cotio hua'ano'sa', maistro'sa', inapita masahuatonaco: “Tëpacaso' ya'huërin,” tosapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ina tosahuatona', nisha piyapiro'sa' sha'huitapi aparisitinacoso marë'. Tëhuarahuatonaco, chiníquën huihuiarinaco. Huihuitonaco, pë'shaarinaco. Ina quëran corosëquë apatanantarinaco chimina'huaso marë'. Chiminaporahuë', cara tahuëri quëran nanpiantarahuë huachi, itaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ina quëran cato' ca'tano'sanënpita huë'pi Quisoso nontacaiso marë'. Sipitio hui'ninpita inahuaso'. A'shinë chachin huë'pi. A'shinso' isonahuaton: Pi'pian Sinioro nonchinquën, topiraihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Ma'ta' imoya nohuantëran? itërin Quisosori. —Hua'an ya'conpatan, hua'huahuëpita chiníquën nanan quëtëquë', topirahuë'. Quëma pirayan ahuënsëquë', a'nara' inchinan quëran, a'nanta' ahuënan quëran ahuënsëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Canpitaso' co ya'ipi nitochátëraramahuë' ni'ton, co no'tëquën yonquiramahuë'. Máin o'orëso pochin chiníquën parisitarahuë. Canpitanta' aparisitohuachinënquëma', ¿ahuantapoma' ti? itërin. —Ahuantarai, topi cato chachin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Imaramaco ni'ton, canpitanta' parisitapoma mini. Napoaponahuë', co caso' nanitërahuë' chiníquën nanan quëta'huanquëmaso'. Tata Yosëíchin nanitërinso'. Inari nohuantërinsopita acoarin. Nani inapita marë' taparin huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ina quëran oshaquëran a'napita ca'tano'sanënpitari natanpi. “Chini chiníquën nanantacaiso' ¿nohuantopi ti?” ta'tona', no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Quisososo nipirinhuë', ya'ipi ca'tano'sanënpita përasahuaton, pënënin: —Nisha piyapiro'sa' chiníquën nanantacaiso' pa'yatopi. Hua'ano'saso' chiníquën nanantatona', piyapinënpita no'huiana quëran camaipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Canpitaso nipirinhuë' ama inapita pochin cancantocosohuë'. Yosë huëntonënquë ya'conpatëra, co chiníquën nanantacaso' nohuantërëhuë'. Noya noya iyaro'sa' yanipatama', ya'ipi piyapi'sa' catahuaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Piyapinën pochin cancantoco'. Catahuacasoáchin yonquihuatama', Yosë noya noya ni'sarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Canta' Yosë quëran quëmapico niporahuë', co a'napita camaica'huaso marë' o'marahuë'. Piyapi'sa' catahuaca'huaso marë' o'marahuë. Chiminarahuë na'a piyapi'sa' nicha'ëca'huaso marë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Paantarahuatona', a'na ninanoquë canconpi, Quirico itopiso'. Ina quëran pipihuachina, notohuaro' piyapi'sari imasapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Cato' quëmapi'saso nipirinhuë', ira yonsanquë huënsëapi. Somaraya ni'tona', inaquë huënsërapi coriqui ma'patacaiso marë'. “Quisoso na'huërarin,” topachinara, chiníquën përapi. —¡Nosorocoi Sinioro! Quëmaso' Tapico' shinquën. Yosë a'paimarinquën ni'ton, nosorocoi quiyanta' topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A'naquëni natanahuatona', no'huipi: “Ta'toco',” itopirinahuë', aquëtë chachin chiníquën nontopi. —¡Onpopionta' Sinioro nosorocoi quiyanta' topiraihuë'! itantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Napotohuachinara, Quisososo chiniconahuaton: —Sha'huitoco' huë'ina', itërin. Huë'pachinara: —¿Ma'ta' iyaro'sa' onpochinquëma'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Anoyarayatocoi Sinioro quiyanta' ni'chii, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Itohuachinara, nosoroaton, së'huarayarin. A'naroáchin noya ni'topi. Inapotohuachina, Quisoso imapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nani Quirosarinquë ya'caritahuatona', Oriposë panënquë canconpi. Ina ya'cariya a'na ninano' ya'huërin, Pitipaqui itopiso'. Inaquë canconahuaton, cato' ca'tano'sanënpita sha'huitërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Paso' ninanoquë paco'. Pëi' ya'natimarinquë canconpatama', mora hua'huinë chachin a'sonpinan quënanconarama'. Hua'huinso', hui'napishin. Cato chachin i'quiritahuatoma', quëshico. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“¿Onpotaomata' i'quiritaramaso'?” itohuachinënquëma', “Siniorori nohuantërin. Apira isëquë acoquiantarai,” itoco'. “Quëpaquë' nipachin,” itohuachinënquëma', quëshico, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Iráca Yosë nohuanton pënëntona'piri ninshitaton tapon: “Quirosarinquë ya'huëpisopita sha'huitëquë': ‘Ni'co' iyaro'sa'. Hua'anëma' huë'sarin catahuainquëmaso marë', Yosë a'patimarinquëmaso'. Chiníquën nanantaponahuë', topinan piyapi pochin cancantaton, mora hui'napishin aipi huënsëriarin, itëquë',’ ” tënin. Iráca ninorinso chachin Quisoso mora aipi paacaso yonquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ca'tano'sanënpitaso pa'sahuatona', Quisosori camairinso chachin nipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I'quiritahuatona', cato chachin quëntapi. Mora aipi a'mopiso' huëtohuachinara, ina aipi Quisoso huënsërahuaton, pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na'a piyapi'sa' quëchitahuatona', a'mopiso' iraquë huëtopi. A'naquëonta' panpë mono pochin nininso' masahuatona', no'paquë huëtopi. Inaquë Quisoso pa'sarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A'naquën quëchitërapi. A'naquëonta' imasapi. Papona pochin chiníquën nonsapi: —¡Nicha'ëcoi Tata Yosë! ¡Ma noyacha Quisososo paya! Tapico shiin inaso'. ¡Quëmari chachin chiníquën nanan quëtëran! ¡Quëma nohuanton, israiro'sacoi hua'anëntarincoi! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Quirosarinquë canconpachina, ya'huëhuano'sa' pa'yanatona', noncaroapi. —¿Ma piyapita' isoso'? topachinara, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Co'ta Quisoso, Cariria parti ya'huërinso'. Nasarito quëran huëcaton, na'con pënëntërin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ina quëran Yosë chinotopiso pëiquë paaton, ya'conconin. Inaquë na'a nipa'antopisopita quënanconahuaton, a'parin. A'naquën coriqui nicanpiarapirinahuë', misanënapitanta' pitara'piarin. Nëpë' pa'aninsopitanta' a'paton, huënsëpiso' pitarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—Yosë quiricanën quëran pënëninpoa'. “Ca nohuanto, pëinëhuë ya'huërin piyapi'sa' nontinacoso marë',” tënin Yosë. Canpitaso nipirinhuë', ihuatëro'sa' ya'huëpiquë pochin nitërama', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ina quëran na'a cania'piro'sa' Yosë chinotopiso pëiquë ya'conpi Quisosori anoyatacaso marë'. A'naquën somaraya nininso'. A'naquëonta' apiaro'sa'. Inapita huë'pachinara, a'naroáchin anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Cotio maistro'sa', corto hua'ano'sa', inapitaso' ni'sápi. Hua'huaro'saso nipirinhuë' pa'yatatona', chiníquën nonsapi. “¡Ma noyacha Quisososo paya! Tapico' shiin inaso'. Yosë chachin a'patimarinpoaso',” tosapi. Ina natanahuatona', hua'ano'sari no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","No'huitona', Quisoso itopi: —Isopita napopiso' ¿co natananhuë' ti? itopi. —Natanahuë mini. No'tëquën nonsapi. Yosë quiricanënquë naporin: “Quëma nohuanton, hua'huaro'sa' nóya nonapiarinënquën. Sho'shopia'huaro'sa' niponaraihuë', ‘Ma noyanquëncha quëmaso paya,’ itarinënquën,” tënin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ina tosahuaton, Pitaniaquë pa'nin. Inaquë huë'ëpatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tashiramiachin ninanoquë paantapon pochin, Quisoso tanarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aquë quëran iquira nara quënanin, ira yonsanquë huanirinso'. “Inaya tëranta' nitërinso' ma'to ca'i,” ta'ton pa'pirinhuë'. Na'con monohuanaponahuë', co manta' nitërinhuë'. Ina ni'sahuaton: —Ama huachi iso nara nichinsohuë', tënin Quisoso. Napohuachina, nara a'naroáchin ahuirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ina ni'sahuatona', ca'tano'sanënpita pa'yanpi. —¿Onporahuatonta' Maistro, iso nara a'naroáchin ahuirin? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Tëhuënchachin Yosë ya'ipi nanitaparin. Ina nontohuatama', ya'ipi cancanëma quëran natëco'. “Co Yosë catahuarincohuë',” ama tocosohuë'. Ya'ipi cancanëma quëran ina natëhuatama', sacai' nininso' nanitaparama' canpitanta'. “Yosë nohuanton, iso motopi nichi'huincarahuaton marëquë niichin” tënama' naporini, ina nohuanton, inapo'itonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yosë nontohuatama', noya natëco'. “Tëhuënchachin Yosë catahuarinco,” topatama', na'con catahuarinquëma'. Ma'sona tëranta' nipatama', acotarinquëma', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ina quëran Yosë chinotopiso pëiquë paantarin piyapi'sa' a'chintantacaso marë'. A'chinaquëya', cotio ansiano'sa', corto hua'ano'sa', inapita huë'pi. —¿Onporahuatonta' chiníquën nanantaton, nipa'antopisopita a'paran? ¿Inta' nanan quëtërinquën ina pochin nicacaso'? Sha'huitocoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Inta nipachin, carinquëmanta' natainquëma'. Ina sha'huitohuatamaco, nanan quëtërincoso' sha'huitaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Incarita' Coansha nanan quëtërin piyapi'sa' aporintacaso marë'? ¿Yosëri nanan quëtërin, piyapi'sari nica? ¿Ma'ta' tënama' canpita? Sha'huitoco carinquëmanta' nanan quëtërincoso' sha'huichinquëma', itërin Quisosori. Natanahuatona', inahua capini ninontapi. —¿Ma'ta' itahua'? “Yosëri nanan quëtërin aporintacaso',” itohuatëhua', “¿Onpoatomata' nipachin co natëramahuë'?” itarinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nipirinhuë', “Co Yosëri nanan quëtërinhuë'. Piyapiri quëtërin,” itohuatëhua', na'a piyapi'sa' no'huiarinënpoa'. “Yosëri a'parin pënëntacaso marë',” topi ya'ipiya, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nani ninontohuachinara, Quisoso itapona': —Ahuën. Co quiyaso' nitotëraihuë'. ¿Incariso' Coansha nanan quëtomara? Co nitotëraihuë', toconpi. —I'yan, napoahuarë' co carinquëmanta' insosona nanan quëtërincoso' sha'huitaranquëmahuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ina quëran itaantarin: —Apira iyaro'sa' a'chintaanta'inquëma' yonquico'. A'na quëmapi ya'huërin opa sha'na'pi. Inaso', Cato' hui'nin ya'huëtërin. A'naso' sha'huitërin: “Ipora tahuëri, conpa, iminquë sacatonquë',” itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Inca tata, co yasacatërahuë',” itërin. Napotaponahuë', oshaquëran yonquiantarin. Noya cancantaton, sacatapon pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A'na hui'nionta' camairin iminquë sacatacaso'. “Noyahua'. Pa'i nipachin canta' sacachi,” itaponahuë', co pa'ninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Cato' hui'nin chachin sha'huitopirinhuë', ¿insoarita' natërinso'? itërin Quisosori. —Ya'nan camairinso' pa'pin natëton, sacatërin, itopi. —No'tëquën naporama'. A'naso' “Pa'i nipachin,” taponahuë', co pa'ninhuë'. Inapochachin copirno marë' coriqui ma'patona'piro'sa', monshihuana'piro'sa', inapita co noyahuë' yonquipirinahuë', iporaso' ina naniantahuatona', Yosë imasapi. Imatona', tëhuënchachin hua'anëntërinquë ya'conapi. Canpitaso nipirinhuë' co yaya'conamahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Coansha Paotista pënënpirinquëmahuë', co yanatëramahuë'. Noya cancantamaso marë' a'chintopirinquëmahuë', co yanatëramahuë'. Copirno marë' coriqui ma'patona'piro'sa', monshihuana'piro'sa', inapitaso nipirinhuë' a'naroáchin natëtona', noya cancantopi. Ina nicapomarahuë', co yonquiramahuë'. Co natëtochináchinhuë' cancantërama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ina quëran itaantarin: “A'nanta' pënënto nanan, a'chinchinquëma', natanco'. A'na quëmapi pancana imianatërin. Inaquë oparachin sha'nin. Nani pairapirahuaton, na'pi quëran nanpi ninin opa to'poitona' huino nicacaiso marë'. Naporahuaton, tori ninin. Inaquë piyapinën ya'huaton nocorarin ama ihuacaiso marëhuë'. Nani tiquihuachina, inpriatoro'sa' acorin a'paicaiso marë'. ‘Sacatëramaso marë' patoma nitërinso' canpitaoranquën marë' maco'. Patomachin canta' acotoco,’ itërin. Itahuaton, a'na parti pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ina quëran nani nitohuachina, aquë ya'huërin quëran piyapinënpita a'parin patoma nitërinso' ma'pacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A'papirinhuë', inpriatonënpitari masahuatona', ahuëpi. A'naso' tëpapi. A'nanta' na'piquë të'yaratona', tëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Naquëranchin hua'anëni a'napita a'paantarin. Na'a piyapinënpita a'paantapirinhuë', inachachin nitantapi. Ahuëantarahuatona', topinan a'paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ina quëran hua'anënso' yonquiantarin. ‘¿Ma'cha onpochiya? Na'aya'pi a'papirahuë', co manta' quëtopihuë'. Hui'nahuë chachin nipachin a'pa'i. Ina tëhuënchinso' natëapona' nimara,’ ta'ton, hui'nin chachin a'papirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ya'caritëraso', inpriatoro'sari quënanpi. ‘Ni'cochi. Hui'nin chachin huë'sarin huachi. Pa'pin chiminpachin, iso no'pa chachin hua'anëntapon. Huëco' tëpa'ahua' ya'ipi ma'shanënpita matahua',’ nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naporahuatona', hua'anën hui'nin mapi. Masahuatona', aipiran të'yatopi. Ina quëran tëpapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Napotohuachinara, ¿ma'ta' onpotintapon hua'anëni, hui'nin chachin tëpatopi ni'quëhuarë'?” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Pa'pi co noyahuë' nipi ni'ton, chiníquën no'huiton, a'naroáchin tëpapon. Ina quëran nasha inpriatoro'sa' acoantarin. Inapitaso' opa nitohuachin, no'tëquën quëtapi huachi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—Iráca Yosë quiricanënquë ninshitërinso' ¿co nontëramahuë' ti? Ninshitaton, naporin: “Na'pi quëran yapëihuachina, a'na na'pi quënanpirinahuë', pëina'piro'sa' co nohuantopihuë'. ‘Napoonin,’ ta'tona', të'yatopirinahuë'. Hua'anëni maantarahuaton, ‘Iso na'pi na'con na'con nohuantërahuë pëica'huaso marë',’ ta'ton, noya acoantarin. Yosëri chachin inapotërin. Napoaton ‘ma noya’ tënëhua',” tënin quiricanënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Napoaton itaranquëma', Yosë yahua'anëntopirinquëmahuë', co nohuantëramahuë' ni'ton, a'poarinquëma'. Nisha piyapiro'sa' piyapinënpita pochin ni'sarin. Inapitaso' noya natëapi.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ina na'pi i'patohuatëra, anotatë' ya'panë'. A'na tahuëriso nipirinhuë' ina na'piri chachin anoantohuachin, a'naquën ni'shariarin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Natanahuatona', cotio hua'ano'sa', parisioro'sa', inapita yonquipi. “Canpoa' chinotatonpoa' pënënarinpoa',” ta'tona', no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","No'huitona' tashinan pëiquë yapo'mopirinahuë', piyapi'sa' të'huatatona', co mapihuë'. Notohuaro' piyapi'sa' Quisoso noya natanpi. “Yosëri chachin acorin pënëinpoaso marë',” topi. Napoaton cotio hua'ano'sa' co nanitopihuë' Quisoso macacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ina quëran a'na pënënto nanan ya'huërë', sha'huitaantarin: “Yosë hua'anëntërinso' a'chintaanta'inquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","A'na copirno naporinso pochin ninin. Inaso', hua'huayátërahuë piyapi'sa' hua'anëntërin. Hui'nin yasa'apachina, panca pita nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Napoaton piyapinënpita a'parin piyapi'sa' sha'huitacaiso marë'. Sha'huitopirinahuë', co nohuantopihuë' huëcacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Copirnoso natanahuaton, a'napita piyapinënpita a'paantarin: ‘Sha'huitonco' manóton huë'ina'. Nani ohuacaro'sa' amoshin nipisopita atëpatërahuë capacaso marë'. Nani ya'ipi taparahuë. Huëco huachi ca'ahua', itonco',’ itahuaton a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pa'sahuatona', sha'huitaantapirinahuë'. ‘Co'chi nanitëraihuë paya,’ toconpi a'naya a'naya. A'naso' iminquë pa'nin. A'nanta' ma'sha pa'anapon pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A'naquëniso', piyapinënpita masahuatona ahuëpi. Inapotatona' tëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Copirnoso' natantahuaton, chiníquën no'huitërin. Sontaro'sa' a'parin ana'intacaiso marë'. Piyapinënpita tëpatopi ni'ton, inahuanta' sontaro'sari tëparin. Napotahuatona' pëinënapita ahuiquitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Piyapinënpita amatantarahuaton, sha'huitërin. ‘Pita marë' nani tapapirahuë'. Amatërahuësopitaso' co inashitopihuë' isëquë nicacaiso ni'ton, co huachi inapita yonquirahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","A'na ira a'na ira pa'tatoma', a'napita piyapi'sa' quënanpatama', sha'huitonco' huë'ina'. Inso tëranta' quënanpatama', sha'huitoco' huë'ina'. Hui'nahuë sa'acaso marë' noya pita nisarahuë,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Piyapinënpita pa'sahuatona', na'a piyapi'sa' sha'huitëra'piapi. Noya nipisopita, co noyahuë' nipisopitanta' sha'huitëra'piapi. Pita pëi' noyá ya'sotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ya'conahuaton copirnoso', a'naya a'naya noya nontërin. A'na quëmapiso nipirinhuë', co noya nitaparinhuë' pita pëiquë ya'conacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ina ni'sahuaton, copirnori itërin: ‘¿Onpoatonta' iyasha co noya nitapaponahuë' ya'conan?’ itërin. Napotopirinhuë', co manta' tëninhuë'. Tapanaton, ta'tárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","‘Iso quëmapi masahuatoma', tonpoco'. Pa'on, tanpaquën, inapita noyá tonpoco'. Nani tonporahuatoma', tashinanquë të'yatoco'. Inatohua' piyapi'sa' na'nërapi, chiníquën parisitapi huachi,’ itërin piyapinënpita. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Inapochachin notohuaro' piyapi'sa' Yosëri amatërin huëntonënquë ya'conacaiso marë'. Na'a natanpirinahuë', caraíchin huayonin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisioro'sa' natanahuatona', ninontopi. “Huëco' nonpintatëhua', nisha nisha natahuan'. Co no'tëquën a'panihuachinpoahuë', sha'huirapiahua',” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Napoaton a'naquën a'papi Quisoso natanacaiso marë'. Irotisë pa'yatopisopitanta' caraya pa'pi. Canconahuatona', noyásha nontonpi nonpintacaiso marë'. —Quëmaso' Maistro, noyanquën. Co onporonta' nonpinanhuë'. Yosë pënëninpoaso' no'tëquën a'chintërancoi. Piyapi'sa' no'huipirinënquëonta', co ina yonquiranhuë'. Co hua'an tëranta' të'huatëranhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Napoaton yanatanainquën. Noma copirnoso' nisha piyapi niponahuë', ya'ipinpoa' hua'anëntërinpoa'. Nani pi'ipi coriqui ma'painpoaso marë' comisionënpita a'parin. Huë'pachina, ¿noya ipora quëtacaso', ti? ¿Ma'ta' Yosë nohuantërin nica'huaiso'? Sha'huitocoi nitochii, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yanonpintopiso' nitotaton, Quisosori itërin: —¡Canpitaso' nonpintënquëma'! ¿Ma'marëta' yaatëhuëramaco? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Noma coriqui a'notoco ni'i, itërin. Napotohuachina, a'notopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Inta' isoso' nonanpiso'? itohuachina, —Noma copirno, itopi. —¿Inta' nininëonta' isëquë ninshitopi? itantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Noma copirno chachin, itopi. —Copirno coriquinën ni'quëhuarë', quëtantaco'. Naporahuaton, Yosë nininpoa' ni'ton, hua'anëntërinpoa'. Ya'ipi cancanëma quëran ina natëcaso' ya'huërin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Natanahuatona', pa'yanpi. “¡Ma noyacha a'panirinpoa paya!” ta'tona', patopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naporo' tahuëri a'napita cotio hua'ano'sa' huë'pi, satosioro'sa' itopiso'. Inapitaso' nisha a'chinpi. “Piyapinpoa' chiminpatëhua', co onporonta' nanpiantarihuahuë',” toconpi. Inapitanta' Quisoso yanonpintatona', huëcapaipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Iráca Maistro Moisësë pënëninpoa': “Quëmapi sa'aponahuë co hui'nin ya'huëyátërasohuë' sa'in ayananpihuachin, ina iini chachin imoroën maantacaso' ya'huërin. Hui'nahuanpachin, iinco' apoin inari ya'huërëtacaso marë'. Ina quëran mashotohuachin, ma'shanën, no'panën, inapita maantarin,” tënin Moisësë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Canchisë iyaro'sa' iráca ya'huërin. Paninanso' sa'apirinhuë'. Co hui'nin ya'huëyátërasohuë', sa'in ayananpirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ina iini chachin maantarin. Moisësë tëninso chachin manin. Inanta' co hui'nin ya'huëyátërasohuë', chimiantarin. A'na iionta' inapoantarin. Canchisë iinpita chachin inapoantapi. Co a'naya tëranta' hui'nina ya'huëchátërasohuë', ya'ipi taquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ina quëran sanapinta' chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Canchisë chachin ina sanapiáchin mapirinahuë', nanpiantacaso tahuëri nanihuachin, ¿inquën chachincha sa'in ninë'poya? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—Canpitaso' co no'tëquën yonquiramahuë'. Yosëso' chini chiníquën nanantopirinhuë', co nohuitëramahuë'. Quiricanëonta' co nitotëramahuë'. Napoaton co nanitëramahuë' no'tëquën yonquicamaso'. Yosëso' ya'ipiya nanitaparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chiminpisopita nanpiantahuachina', co huachi sa'asapihuë'. Sanapi'santa' co huachi so'yaapihuë'. Anquëniro'sa pochin nisapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chiminpisopita tëhuënchachin nanpiantarapi. Moisësë nontohuachina, Yosëri chachin sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Caso' Yosëco. Apraan chinotarinco. Isaco, Cacopo, inapitanta' chinotarinaco,” itërin. Cara chachin iráca chiminpirinahuë', naporin. Nanpipisopitaráchin Yosë chinotapi. Napoaton inapitanta' chiminpirinahuë', Yosë marëso nanpirápi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Piyapi'sa' ina natanahuatona', pa'yanpi. “¡Ma noyacha a'chintërinpoa paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Natanahuatona', parisioro'santa' niyontonpi. “Quisoso no'tëquën a'panitaton, satosioro'sa' atapanin ni'ton, co huachi yanatanpihuë',” ta'tona', niyontonpi ina nontantacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","A'na maistro iráca nanan noya nitotërinso' huë'sahuaton, Quisoso nontiirin atëhuëcaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Pi'pian Maistro yanatananquën. Yosë na'con pënëninpoa'. ¿Ma'ta' na'con na'con nohuantërin nicacaso'? itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—Inta nipachin sha'huichinquën. Yosëso' Sinioro ni'ton, hua'anëntërinpoa'. Ina na'con nosorocaso' ya'huërin. “Ya'ipi cancanëma quëran, ya'ipi hua'yanëma quëran, ya'ipi yonquinëma quëran, ya'ipi inaquëranpita nosoromiatoco',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ina na'con na'con nohuantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Isonta' Yosë nohuantërin: “Quëmaora ninosororanso pochachin a'napitanta' nosoroco',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moisësë, pënëntona'piro'sa', inapitaso' na'con pënëntopirinahuë', nosorocaso' na'con na'con nohuantopi. Napoaton nosorohuatama', Yosë yonquirinso chachin imasarama', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisioro'sa' nani niyontonpi ni'ton, Quisosorinta' natanarin no'tëquën ayonquicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Iráca Yosë quiricanënquë sha'huitërinpoa'. “A'na tahuëri a'na quëmapi acoarahuë piyapi'sa' nicha'ëcaso marë'. Inaso' Cristo itopiso',” tënin Yosë. ¿Inta' shiin inaso'? itërin Quisosori. —Tapico' shiin inaso', topi parisioro'sa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","—Naporinchi paya. Inaso nipirinhuë', iráca Ispirito Santo nohuanton, Tapiri chachin Cristo ninoton, ninshitërin: “Yosëri Sinioronëhuë sha'huitërin. ‘Inchinanëhuë quëran huënsëquë' inimiconënpita cari minsëchinquën,’ itërin Yosëri,” tënin Tapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Shia'huain niponahuë', Cristo yonquiaton, “Sinioronëhuë,” tënin. ¿Onpoatonta' naporin? itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Natanaponaraihuë', co manta' a'panitopihuë'. “Yosë hui'nin chachin ni'ton, Tapiri Cristo chinotërin,” ta'caiso nipirinhuë', co yanatëpihuë'. Napoaton naporo quëran huarë' tapanatona', co huachi nohuantopihuë' Quisoso natanacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ina quëran piyapi'sa' a'chintantarin. Ca'tano'sanënpitanta' natanapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tëhuënchachin iyaro'sa', cotio maistro'sa', parisioro'sa', inapita na'con a'chintatënënquëma': ‘Moisësë pënëninpoaso' no'tëquën a'chinchinquëma',’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yosë nanamën a'chintohuachinënquëma', noya natëco'. Nipirinhuë', ama inapita nonancosohuë'. Inahuaso' pënënpirinënquëmahuë', co cancanëna quëran imapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ni'co'. Panca pë'pëto quëpahuatëra, sacai' iratacaso'. Inapitaso' inapochachin a'chintërinënquëma'. Co Yosë quiricanënáchin a'chinpihuë'. Inahuara yonquinëna quëraonta' nisha nisha pënëntopi. Panca pë'pëto apë'pëtërëso pochin nitërinënquëma'. A'chintopirinënquëmahuë', inahuara chachionta' co natëpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pi'pian Yosë quiricanën ninshitahuatona', të'yainaquë achinpipi piyapi'sari nicacaiso marë'. Naporahuatona', naporopi a'mopi nohuitacaiso marë'. ‘Inapohuatëhua', piyapi'sa' noya ni'sarinënpoa',’ ta'tona', napopi. Napoaponaraihuë', co aquëtë' Yosë yonquipihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pita nipachina, huancánachin yahuënsëconpi. Niyontonpiso pëiquë ya'conpachinara, hua'ano'sapitarë' yahuënsëconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Cachiquë pa'pachinara, na'a piyapi'sari noya nontopi. ‘Huë'cama maistro,’ itohuachinara, pa'yatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Canpitaso nipirinhuë', ama maistro itiinëmaso nohuantocosohuë'. Ya'ipinquëma' iyama pochin nisarama'. Casáchin no'tëquën a'chintëranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ama a'na piyapi na'con na'con pa'yatocosohuë'. ‘Quëmaso' tata pochin ni'nanquën. Natëaranquën huachi,’ ama itocosohuë'. Yosëíchin natëcaso' ya'huërin. Inaso' tatanënpoa' inápaquë ya'huërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ama hua'an pochin chiníquën nanan nohuantocosohuë'. ‘Ca natëco,’ ama tocosohuë'. A'naíchin hua'an ya'huëtërinquëma', Cristo itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yosë huëntonënquë ya'conpatëra, co chiníquën nanantacaso' ya'huërinhuë'. Noya noya yanipatama', ya'ipi piyapi'sa' catahuaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","‘Caso' noya noyaco,’ topatama', Yosë atapanarinquëma'. Nipirinhuë', ‘Caora co nanitërahuë' noya nica'huaso'. Catahuaco Sinioro,’ topatama', Yosë catahuaarinquëma'. Noya noya acoarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ina quëran Quisosori cotio maistro'sa', parisioro'sa inapita pënënaton itapon: “Cotio maistro'sanquëma', parisioro'sanquëma', canpitaso nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! Co no'tëquën a'chinamahuë' ni'ton, Yosë iranën ya'copiatë pochin nitërama'. Co no'tëquën Yosë imatomahuë', co canpita tëranta' Yosë hua'anëntërinquë ya'conaramahuë'. A'napitanta' yaya'conpirinahuë', co catahuaramahuë' ya'conacaiso'. Canpita nonaninënquëma' ni'ton, inapitanta' co ya'conpihuë'.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Canpitaso nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! Quëyorono'sa' nonpintërama'. Noya nontapomarahuë', a'naya a'naya nonpintatoma', ma'shanënapita matërama'. Ina quëran niyontonpiso pëiquë ya'conpatamara, hua'qui' Yosë nontapomarahuë', co cancanëma quëran imaramahuë'. Ina marë' aquë aquëtë' ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Canpitaso' nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! Nisha piyapi'sa' a'chintacamaso marë' ira iratë́rantarama'. Aquë paatoma', a'naya a'naya a'chintërama' canpita pochin yonquicaiso marë'. Natëhuachinënquëma', aquë aquëtë' co noyahuë' cancantapi. Ya'ipinquëma' parisitopiquë pa'sarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ma'huantacha nisarama paya! A'napita yaa'chintopiramahuë', co no'tëquën yonquiatomahuë', somaraya pochin cancantërama'. Somaraya nininso' co pi'pian tëranta' nanitërinhuë' a'napita quëpacaso'. Inapochachin canpitaso' co Yosë nohuitatomahuë', co nanitëramahuë' a'napita a'chintacamaso'. ‘Yoscoarë' topatëra, no'tëquën nontacaso' ya'huërin,’ topi ya'ipi piyapi'sa'. Canpitaso nipirinhuë' nisha nisha tënama'. ‘Yosë chinotopiso pëi' ya'huërin ni'ton, no'tëquën nontaranquën,’ itopiramahuë', nonpinpatamanta', ‘Co ina marë' Yosë ana'intarinpoahuë',’ toconama'. ‘Yosë chinotopiso pëiquë oro ya'huërin ni'ton, no'tëquën nontaranquën, topatëra, naporo huarë' no'tëquën nontacaso' ya'huërin,’ topiramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Co no'tëquën yonquiramahuë'. Yosë chinotopiso pëi' mini oro quëran noya noya ninin. Oro inaquë ya'huërinso' co aquëtë' yonquicaso' ya'huërinhuë'. Co chinotopiso' pëiquë ya'huërinhuë' naporini, co Yosëri noya ni'itonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yosë chinotopiso pëiquë artaro ya'huërin. Inaquë ma'sha acopi Yosë chinotacaiso marë'. ‘Artaro ya'huërin ni'ton, no'tëquën nontaranquën,’ tapomarahuë', nonpinpatamanta', ‘Co ina marë' Yosë ana'intarinpoahuë',’ toconama'. ‘Ma'sha inaquë acopiso' ya'huërin ni'ton, no'tëquën nontaranquën, topatëra, naporo huarë' no'tëquën nontacaso' ya'huërin,’ topiramahuë'. Yanonpinatoma', naporama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Somaraya pochin cancantatoma', co no'tëquën yonquiramahuë'. Co ma'sha acopiso' aquëtë' yonquicaso' ya'huërinhuë'. Artaro mini ma'sha acopi quëran noya noya ninin. Artaroquë acopi ni'ton, Yosëri noya ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","‘Artaro ya'huërin ni'ton, no'tëquën nontaranquën,’ topatama', ya'ipi inaquë acopisopitanta' yonquicaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","‘Yosë chinotopiso pëi' ya'huërin ni'ton, no'tëquën nontaranquën,’ topatama', Yosë inaquë ya'huërinsonta' yonquicamaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Inapochachin ‘Pi'iro'të' ya'huërin ni'ton, no'tëquën nontaranquën,’ topatamanta', co pi'iro'tëáchin yonquicaso' ya'huërinhuë'. Yosë inaquë ya'huaton, hua'anëntarinpoa'. Inanta' yonquicamaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Canpitaso nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! ‘Nani ma'sha quëran, diesmo Yosë quëtacaso' ya'huërin,’ itërinpoa' Moisësë. Ina natëpiramahuë', nonpintënquëma' canpitaso'. Napoaton ma'sha sha'patamara, pi'pian quëtërama'. Ya'ipi cosharo apimotacaso marë' sha'nama' quëran huarë' diesmo quëtërama'. Inaso' noya nipirinhuë', Yosë na'con na'con nohuantërinsoso' naniantërama'. Co no'tëquën nonamahuë'. Co sa'ahuaro'sa' nosororamahuë'. Naporahuaton, co cancanëma quëran huarë' Yosë natëramahuë'. Ina marë' ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Somaraya pochin cancantatoma', co no'tëquën a'chinamahuë'. Ni'co'. Canpitaso' yao'opatamara, ama o'oso tëranta' o'ocamaso marëhuë' noyá panshairama'. Napoapomarahuë', camiyo a'naroáchin mi'tëramaso pochin ninama'. Yosë na'con na'con nohuantërinso', co natëramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Canpitaso' nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! Tëhuënchachin yanonpinama'. Ni'co'. A'naquën minë', sënan, inapita pa'mohuachinara, aipiáchin pa'mopi. Acoposo nipirinhuë', në'huënantëtërin. Inapochachin canpitaso' piyapi'sa' noya nicainënquëmasoachin yonquipiramahuë', acopo' cancanëma quëranso', co noya yonquiramahuë'. Nonpinatoma', yaihuatërama'. Ma'sharáchin nohuantatoma', co Yosë nohuantërinso' ninamahuë'. Ina marë' Yosë ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Canpitaso parisioro'sanquëma', somaraya pochin cancantërama'. ¿Onporahuatomacha co no'tëquën yonquiramahuë paya? Cancanëma'ton anoyatoco'. Ina quëran noya cancantatoma', noya nisarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Canpitaso' nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! Yosë quiricanën a'chinpiramahuë', yanonpinama'. Ni'co'. Chimipi na'pi naninquë po'mohuatëra, aipiran quëran huiríchinquë pashitërë'. Noyápiachin ya'nopirinhuë', acoposo' nansë, nosha chanatërinso', inapita co nishinahuën' nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Inapochachin canpitaso' ninama'. Piyapi'sa' noya nicatënënquëma': ‘Ma noya maistro'sa' Yosë natëpi,’ topirinahuë'. Acopo' cancanëma quëranso nonpinatoma', pa'pi co noyahuë' cancantërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Canpitaso' nonpintënquëma ni'ton, ¡ma'huantacha nisarama paya! Iráca Yosë piyapinënpita pënëntohuachinara, shimashonëmapitari no'huitona', tëpapi. Ipora canpitaso', pa'pitopiquë pëirapirama'. Noya quëmapi'santa pa'pitopiso', yancoro'sa' sharapirama'. Ama naniantacaso marëhuë' napotërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Inapotatoma' naporama': ‘Iráca chachin ya'huërai naporini, co quiyariso' tëpa'itoihuë',’ topiramahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","shimashonëma' quëpatoma', canpitanta' tëpatona'piro'sa pochin cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inapita pochin cancantatoma', co noyahuë' nisarama'. Na'con na'con oshahuanarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Ya'huan pochin cancantatoma', pa'pi co noyahuë' nisarama'! ¿Onporahuatomacha pën quëran cha'ërë'ponquëmaya? Co cha'ësaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Napoaton pënëntona'piro'sa' a'pataranquëma'. No'tëquën yonquina'piro'sa', a'china'piro'sa' inapita a'pataranquëma' a'chintinënquëmaso marë'. No'tëquën pënënaponënquëma' nipirinhuë', no'huiarama'. A'chintopirinënquëmahuë', a'naquën tëpaarama'. A'naquën niyontonpiso pëiquë chiníquën huihuiarama'. Nisha nisha ninanoquë imatoma', aparisitarama'. A'naquëonta' corosëquë patanantatoma', tëpaarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iráca quëran huarë' noya quëmapi'sa' pënëntopirinahuë', na'a tëpapi. Apiri'ton noya quëmapi nipirinhuë', iini tëparin. Ina piquëran a'naya a'naya noya pënëntopirinahuë', tëpara'piapi. Na'a pi'ipi napopi. Napoin quëran Sacariasë tëpapi anta'. Piriquiasë hui'nin inaso'. Yosë chinotopiso pëi i'iratëquë artaro ya'huërinso aquëcha tëpapi. Canpitaso' ina nitotapomarahuë', co natantochináchinhuë' cancantërama'. Napoaton Yosë chiníquën ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iráca quëran huarë' shimashonëmapita co noyahuë' cancantopi. Ipora canpitanta' inapita pochachin cancantarama' ni'ton, Yosë na'con ana'intarinquëma huachi, tënahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ina quëran taantarin: “¡Ya'ipi Quirosarinquë ya'huëramasopita yonquiatënquëma', chiníquën sëtërahuë! Na'a pënëntona'piro'sa' Yosë a'patërinquëma' pënëinënquëmaso marë'. A'papirinhuë', tëparama'. A'naquën na'piquë të'yaratoma', tëparama'. Ya'ipinquëma' nosoroatënquëma', na'aro' yacatahuapiranquëmahuë', co ca tëranta' nohuantëramacohuë'. Atari hua'huin to'cohuëtërinso pochin yapa'poyapiranquëmahuë', co nohuantëramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Napoaton Tata Yosë patarinquëma'. Chinotëramaso pëinta' patarin. Co huachi catahuaarinquëmahuë' ni'ton, noquitarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Canta', co huachi quënanaramacohuë'. O'manta'huaso' tahuëri huarë' quënaantaramaco. Naporo': ‘¡Ma noyanquëncha quëmaso paya! Sinioro chachin a'paimarinquën,’ itaramaco huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ina quëran Yosë chinotopiso pëi quëran pipihuachinara, ca'tano'sanënpitari itapona': —Ni'quë' Maistro. Ma noyápiachin Yosë chinotopiso pëi', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—Iporaso' ya'ipiya noyápiachin ni'piramahuë', a'na tahuëriso' ya'ipiya ohuatapi. Co a'na na'piya tëranta' niya'huiritarinhuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ina quëran Oriposë panënquë pa'sahuaton, inaquë huënsëconin. Ca'tano'sanënpitaráchin ya'huëpi. Inapitari huëcapairahuatona', itiipi: —¿Onporota' Maistro ohuatapi? Ayaro' tahuëri ya'caritohuachin, ¿ma'ta' onporahuachina' nitotapoi? ¿Onporota' o'mantararan? Inapita sha'huitocoi quiyanta' nitochii, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—Ni'cona iyaro'sa' nonpintochinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","A'naquën huëcapona'. “Caso' Cristoco. Yosë chachin a'paimarinco,” tosapi. Nonpintë' nipirinhuë', na'a piyapi'sari imasapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nisha nisha parti piyapi'sa' nino'huiapi. Niahuërahuatona', quira nisapi. Ina natanpatama', ama pa'yancosohuë'. Yosë nohuanton, naporapi. Napoaponahuë', co isoro'pa' ta'huanchátëraponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nisha nisha nananquë nonpisopita nino'huitona', quira nisapi. Copirnoro'sa capini nino'huitona', piyapinënpita camairapi quira nicacaiso marë'. Nisha nisha parti cosharo' pahuanpachin, tanari piyapi'sa' tiquirarin. Naporahuaton, a'na parti a'na parti ocohua pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ni'co'. Sanapi yahuaihuachina, iquitárin, co a'naroáchin huairinhuë'. Inapochachin ayaro' tahuëri ya'caritohuachin, piyapi'sa' parisitaponaraihuë', co isoro'pa' ta'huanchátëraponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Naporo' tahuëri'sa' co noya piyapi'sahuë' masarinënquëma'. Imaramacoso marë' aparisitarinënquëma'. Nisha nisha piyapi'sa' no'huiarinënquëma'. A'naquëma' tëpararinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Inapohuachina', na'a piyapi'sa' imasapirinacohuë', co ahuantatonaraihuë', Yosë naniantapi. Pipirahuatona', imarinacosopita no'huitona', sha'huirapirapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A'naquëonta' nonpin nanan pënëntapona'. Nonpinapirinahuë', na'a piyapi'sari natëtona', nonpin nanan imasapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Piyapi'sa' pa'pi co noyahuë' cancantatona', na'con na'con oshahuanapi. Co huachi ninosoroapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Canpitaso nipirinhuë' noya ahuantoco'. Co a'pohuatamacohuë', noya nicha'ësaranquëma huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yosë hua'anëntërinquë ya'conacaso' a'chintëranquëma'. Ina nanan chachin ya'ipi parti a'chinacaso' ya'huërin. Ya'ipi piyapi'sa' nitochina'. Ya'ipi parti a'chintohuachina', naporo' ayaro' tahuëri naniarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iráca Naniri ninoton, ninshitërin. ‘A'na tahuëri inimicoro'sa' Yosë pëinënquë ya'conahuatona', tapiapona'. Pa'pi co noyahuë' nitatona' inapotohuachina', co huachi inaquë Yosë chinotapihuë',’ tënin. No'tëquën ninorin ni'ton, ina quirica nontohuatama', noya yonquico'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Naniri ninorinso' nanihuachin, Cotia parti ya'huëramasopita motopi'pa' manóton ta'aco', chiníquën aparisitochinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pëinëma aipi ya'huëhuatama', ama ma'shanëmapita quëpacaso marë' ya'concosohuë'. A'naroáchin topinan ta'aco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iminëmaquë sacatasënquëma' nipachin, ama a'moramaso tëranta' maquintacosohuë'. Manóton ta'aco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Naporo' tahuëri'sa' cayorono'sa', sho'shopia'hua ya'huëtopiso', inapitaso' sacai quëran ta'arapi ni'ton, parisitapona'. ¡Ma'huantacha nisapi paya! ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yosë nontoco' ama o'nápiquë ta'acaso' ya'huë'insohuë'. O'napiquëhuë nipon, chinoto tahuërihuë nipon, saca sacai' ta'acaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ina quëran piyapi'sa' chini chiníquën parisitapi. Isoro'pa' ya'huërin quëran huarë' co ina pochin parisichátërapihuë'. Ina piquëraonta' co onporonta' ina pochin parisitantarapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yosë nohuanton, co hua'qui' aparisitapihuë'. Hua'qui' aparisitapi naporini, ya'ipi piyapi'sa' taqui'itonahuë'. Nipirinhuë', piyapinënpita nosoroaton, co nohuantërinhuë' hua'qui' aparisitacaiso'. Huayoninsopita nicha'ësarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Naporo' tahuëri'sa' nisha nisha sha'huitarinënquëma'. ‘¡Ni'cochi, Cristo nani huë'nin! Pasëquë ya'huarin,’ itohuachinënquëma', ama natëcosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Na'a nonpin nanan pënëntona'piro'sa' huëcapona'. ‘Caso' Cristoco’ tosapi a'naquën. ‘Caso' ninotona'pico,’ tosapi a'naquëonta'. Sacai' nininsopita nisapi piyapi'sa' nonpintacaiso marë'. Huayoninsopitanta' nonpintochinaichin nisapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nani sha'huitëranquëma' ama naporo tahuëri nonpintinënquëmaso marëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‘Huëco' inotëro parti pa'ahua'. Inatohua' Cristo ya'huarin,’ itohuachinënquëma', ama pacosohuë'. ‘Paso' pëiquë ya'huërarin,’ itohuachinënquëmanta', ama natëcosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yosë quëran quëmapico ni'to, a'na tahuëri o'mantararahuë. O'mantahuato, ya'ipi piyapi'sa' ni'sarinaco. O'cori' huënsha' topachina, ya'ipi parti a'pintërin. Inapochachin a'na tahuëri huënaráchin huënaráchin o'mantararahuë, ni'saramaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma'sharo'sa' chiminpachina, a'naroáchin tamëro'sari huëcapairin,” itërin Quisosori. (Cristo o'mantahuachin, ya'ipiya nitotapi, tapon naporin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nani parisitohuachina', pi'i tashiarin. Yoquinta' co huachi a'pinarinhuë'. Naporahuaton, na'a tayoraro'sa' anotarin. Ya'ipi inápaquë ya'huërinsopitanta' nacon nacontapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Naporo' o'mantararahuë. Yosë quëran quëmapico ni'to, inápa quëran o'mantararahuë huachi. Nisha nisha nananquë nonpisopita: ‘Ana'intarinpoa',’ ta'tona' pa'yanapi, na'nëapi, napoapi. Chiníquën nanantato, chitoro' huáncana o'mantararahuë, ni'sarinaco. Huënaráchin huënaráchin ya'noarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","O'mantarahuato, na'a anquëniro'sa' a'pararahuë. Panca tronpita pihuitona', ya'ipi parti pa'sapi huayonahuësopita ayontonacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Iquira nara papotërin quëran nitotoco'. Ta'amën monoantahuachina, ‘Nani o'napi naniriarin huachi,’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Inapochachin nani ma'sha onporahuachina', nitotarama'. ‘O'mantacaso' tahuëri naniriarin huachi,’ tosarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","No'tëquën sha'huitëranquëma'. Co'huara cotioro'sa' huënton ta'huanchatërasoihuë', nani ma'sha onporapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Isoro'pa' ta'huantarin. Pi'iro'tënta' ta'huantarin. Ca nanamëhuëso nipirinhuë' co onporonta' ta'huantarinhuë'. No'tëquën nonahuë ni'ton, ya'ipi sha'huitëranquëmaso chachin naniarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ma tahuërisona o'mantaca'huasoso nipirinhuë', co insonta' nitotërinhuë'. Anquëniro'santa' co nitotapihuë'. Yosë hui'ninco niporahuë', co ca tëranta' nitotërahuë'. Tata Yosëíchin nitotërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Iráca Noi nanpiso', na'a piyapi'sa' co Yosë natëpihuë'. Topinan ya'huëcaisoráchin cancantopi. Coshatápi, o'osápi, sa'asápi, hui'ninapitanta' aso'yarápi. Napoatona', co Yosë yonquipihuë'. Noiso nipirinhuë', Yosë natëton, panca nancha ninin. Nani tinihuachina, inaquë ya'conin. A'napitaso' co yonquipirinahuë', a'nanaya panca pama pa'sarin. Naporo' ya'ipiya chimiitopi huachi. Inapochachin canta' Yosë quëran quëmapico ni'to, a'nanaya o'mantararahuë. Na'a piyapi'sa' co yonquipirinacohuë', o'mantararahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naporo' cato' quëmapi'sa' ina iminquëáchin sacatapirinahuë', a'nara' quëpantarahuë. A'naso nipirinhuë' patarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cato' sanapi'sa' inaquëráchin shi'shi' pë'sanapirinahuë', a'nara' quëpantarahuë. A'naso nipirinhuë' patarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ama huë'ërëso pochin cancantatoma', naniantocosohuë'. Onporosona o'maca'huaso' tahuëri nanihuachin, co nitotaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ni'co'. Ihuatë' a'nanaya huë'pachina, pëiquë ya'conin. Hua'anën co nicasohuë', ma'sha ihuarin. Onporosona huëcacaso' nitotërin naporini, hua'anëni ninaitonhuë', co pëinënquë ya'conacaso' nanichitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Inapochachin canpitanta' ninatomaco, ya'huëco'. Hua'quihuato: ‘Co yao'marinhuë',’ ama tocosohuë'. Co nitotasënquëmahuë', a'nanaya o'mantararahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ina quëran itaantarin: “Ni'co', iyaro'sa'. O'maca'huaso' tahuëri a'na patron pochin nisarahuë. Inaso' aquë yapa'pachina, inpriatonën sha'huitërin. ‘Piyapinëhuëpita noya ni'quë'. Cosharo', ma'sha, inapita pahuantohuachina', quëtëra'piaquë',’ itahuaton, pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Inpriatoso' noya yonquihuachin, no'tëquën natëtarin. Patronëni huëcapaintahuachin, noya ni'sarin. Ina marë' noya cancantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Noya natërin ni'ton, acoarin ya'ipi ma'shanënpita a'paicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nipirinhuë', inpriatonën co noyahuë' cancantohuachin, tapon: ‘Patron hua'quirarin. Co a'naroáchin huënantaponhuë',’ ta'ton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","piyapinënpita ahuëapon. Pita nicacasoáchin cancantapon. No'pirápon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Napoaso', patronëni quënanquintapon. Co nitotasohuë', a'nanaya canquipon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Co natërinhuë' ni'ton, chiníquën ana'intarin. Nonpintëro'sa' ana'intopiso pochin nitapon. Inaquë co napion ancantaton, na'nërápon,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Naquëranchin Quisosori pënëantarin: “Yosë hua'anëntërinso' a'chintanta'inquëma', noya natanco. Hua'an sa'arinso pochin ninin. Inaso aquë quëran huë'sarin. Onporosona canquicaso' co nitotopihuë'. Tahuëri nanihuachina, sanapi nipayarinsopita ninarapi hua'an huëcacaso'. ‘Hua'qui quëran canquipon nimara,’ ta'tona', shonca nano'sa' nanparinënarë chachin ninarapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","A'natërápo sanapiíchin noya yonquipi. Quirosin pochin orotërinso' ta'pantatona', mëntaiquë huarë' quëpapi. Naporahuatona', a'naya a'naya potiriaquë quëpapi. A'natërápo sanapi'saso nipirinhuë' co yonquiatonahuë', co aquëtë' quëpapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hua'an hua'quirin ni'ton, tashitopi. Yahuë'ëtona', ya'ipimiáchin huë'ëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Huë'ësoi', yono tashi' a'nanaya chiníquën noninso' natanpi. ‘¡Ma'tana, huë'sarin huachi! ¡Huënsëco' pa'ahua' nacapia'ahua'!’ nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A'naroáchin shonca nano'sa chachin capayatahuatona', nanparinënapita taparapi noya orotacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Noya yonquirinsopitaso' ta'pantohuachinara, noya orotërin. A'napitaso nipirinhuë' i'chinpitopirinahuë', yatacopiconpi. Napohuachinara: ‘Ta'pantocoi quiyanta' i'chinpi'i. Nani quiyaso' tacopiarin,’ topirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Co'chi nanitëraihuë' ta'panta'huainquëmaso paya. Inapohuatoi, co huachi quiyanta' orotarinhuë'. Ya'ipinpoa' tacopianarihua'. Manóton paatoma', pa'anconco',’ itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Napotohuachinara, a'natërápo chachin manotona pa'pi quirosin pochin nininso' pa'anapona'. Pa'pirinahuë', co'huara huëntayátërasoihuë', hua'an canquirin. A'natërápo nano'sa' noya yonquirinsopitaso' imatona', pëiquë ya'conpi. Inaquë sa'acaso marë' pita nisapi. Nani ya'conpachinara, oncotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ina quëran co yonquirinsopitasohuë' huënantatona': ‘¡I'soatocoi sinioro quiyanta' ya'coin!’ itopirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hua'ani co nohuantërinhuë'. ‘Co canpitaso' piyapinëhuëpitanquëmahuë'. Co nohuitëranquëmahuë',’ ta'ton co aya'coninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Napoaton canpitanta' noya yonquiatoma', o'manta'huaso' tahuëri ninaco'. Onporoso' nanipon nimara, co nitotëramahuë'. Ni'cona patontatënquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ina quëran itaantarin: “Isonta' iyaro'sa' a'chinchinquëma' Yosë hua'anëntërinso' nitotamaso marë'. A'na quëmapi aquë yapa'sarinso pochin ninin. Yapa'pachina, inpriatonënpita amatërin camaicaso marë'. Huë'pachinara, itapon: ‘Aquë pa'pato, oshaquëran huënantarahuë. Inatohua' ya'huasoco, noya sacatoco'. Apira coriqui quëchinquëma' ina quëran na'con na'con canaca'huaso marë'. Ma'sha pa'anatoma', oshaquëran ana'atoco',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Itahuaton, a'naya a'naya quëtëra'piarin. Co napopianachin quëtërinhuë'. Nanitinpichin tantiaton, nisha nisha quëtërin. A'naso' a'natërápo huaranca coriqui oro quëran nininso' quëtërin. A'naso' cato huaranca quëtërin. A'nanta' huaranca quëtërin. Nani inpriatonënpita quëtahuaton, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A'natërápo huaranca ma'patona'piso' a'naroáchin natërin. Paaton, na'a ma'sha pa'anin. Ina quëran inapita pa'anaton, na'con na'con coriqui canarin. Nani tahuëri inapoaton, oshaquëran a'natërápo huaranca aquëtë' canaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Cato huaranca quëtërinsonta' noya sacatërin. Inanta' ma'sha pa'anahuaton, cato huaranca aquëtë' canantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Huaranca ma'parinsoso' nipirinhuë', co yanatërinhuë'. No'paquë ihuatahuaton, coriquinën pa'pitërin inaquë tapacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hua'qui quëran hua'anëna huënantarahuaton, inpriatonënpita amataantarin nontacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A'natërápo huaranca ma'patona'piso huë'sahuaton, coriqui a'notiirin. ‘Ni'quë' sinioro, a'natërápo huaranca quëtopirancohuë', ina quëran a'natërápo huaranca aquëtë' nani canarahuë,’ itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘¡Ma noyacha sacatëran paya! Natëranco ni'quëhuarë', chiníquën nanan quëchinquën na'con hua'anëntamaso marë'. Pëinëhuëquë huëquë', noya cancantahua',’ itërin hua'anëni. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ina quëran a'nanta' huë'nin: ‘Ni'quë' sinioro, cato huaranca quëtopirancohuë', nani cato huaranca aquëtë' canarahuë,’ itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘¡Ma noyacha quëmanta' sacatëran paya! Natëranco ni'quëhuarë', nanan quëchinquën na'con hua'anëntacaso marë'. Pëinëhuëquë huëquë', noya cancantahua',’ itërin inanta' hua'anëni. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Piquëran quëtërinsoso nipirinhuë', huë'sahuaton itiirin: ‘Quëmaso' sinioro co nosororancoihuë'. Co quëmaora shacaponahuë', nitërinso' manan. Co sacataponahuë', canaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Napoaton të'huatatënquën, co sacatërahuë'. Coriqui quëtërancoso' acoporoquë po'orahuë. Ma'tana ya'huarin,’ itahuaton, coriqui a'notërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Napotohuachina, co noya ni'ninhuë'. ‘Quëmaso' co noyanquënhuë'. Chiroton, co natërancohuë'. Co no'tëquën yonquiranhuë'. “Co sacataponahuë' canaran,” ¿itëranco ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Onpoatonta' nipachin, co bancoquë acoranhuë'? Inaquë acoran naporini, pi'pian tëranta' canaitohuë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ina quëran a'na piyapinën sha'huitërin. ‘Iso quëmapi topinan quëran coriqui quëtërahuë. Osërëtahuaton, paso' quëmapi na'con na'con canarinso', quëtëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Noya natërinco ni'ton, na'con na'con quëtantarahuë. Co manta' pahuantarinhuë'. A'naso nipirinhuë' co natërincohuë' ni'ton, pi'pian ya'huëtërinso tëranta' osërëtarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naporahuaton co noyahuë' ni'ton, aipiran tashinantërinquë të'yatoco'. Inatohua co napion ancantaton na'nërápon,’ tënin,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ina quëran itaantarin: “Yosë quëran quëmapico ni'to, a'na tahuëri o'mantararahuë hua'anënta'huaso marë'. Ya'ipi anquëniro'sapitarë'co chachin o'mantararahuë. Huënaráchin huënaráchin ya'norahuato, hua'anënta'huaso' shiraquë huënsëarahuë coisë pochin nica'huaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yosë nohuanton, nisha nisha nananquë nonpisopita niyontonapi. Niyontonpachina', pë'tahuatona'pi pochin nisarahuë. Ni'co'. Tahuëri nipachina, ohuicaro'sa', chiporo'sa' napopianachin pa'sapi coshatacaiso marë'. Inaquëráchin ya'huëpirinahuë', tashihuachina, nisha nisha acorin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ohuicaro'sa' inchinanën quëran acorahuaton, chiporo'saso' ahuënanën quëran acorin. Inapochachin canta' ya'ipi piyapi'sa' nisha nisha acoarahuë. Noya cancantopisopita inchinanëhuë quëran acoarahuë. Co noyahuë' cancantopisopitaso nipirinhuë', ahuënanëhuë quëran acoarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ina quëran inchinanëhuë quëran acorahuësopita itarahuë: ‘Ya'ipinquëma' huëcatoma', Yosë hua'anëntërinquë ya'conquico'. ¡Ma noyacha Tata Yosë nosororinquëma paya! Isoro'pa' ninin quëran huarë' yonquirinquëma' hua'anëntërinquë aya'coinquëmaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Canpitaso' noya nosororamaco. Tanahuatëra, a'caramaco. Yamorohuatëra, o'shitëramaco. Ya'huëramataquëchi na'huëpatëra, noya nontëramaco. Pëinëmaquë chachin aya'conamaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Capa a'moca'huaso' nipachina, quëtëramaco. Caniohuatëranta', huëcatoma', nosoroquiramaco. Tashinan pëiquë ya'huasoconta', ni'quiramaco. Napoaton huëco huachi, noya ya'hua'ahua',’ itarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Naporo' inapitaso' natanarinaco: ‘¿Onporota' Sinioro tanaran nicatëinquën, a'carainquën? ¿Onporota' yamororan ni'ton, o'shitërainquën? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Onporota' pëinëhuëiquë aya'conainquën? ¿Onporota' a'mocamaso' pahuantërinquën ni'ton, quëtërainquën? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Onporota' canioran ni'ton, nosoroquirainquën? ¿Onporota' tashinan pëiquë parisitëran, ni'conainquën? ¿Onpórochana napotërainquën nicaya? Co yonquiraihuë',’ itarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Co'ta, imarinacosopita parisitohuachinara, catahuarama'. Topinan piyapi'sa', sa'ahuaro'sa', inapita ma'sha pahuantohuachinara, quëtërama'. Imatomaco, a'napita catahuarama' ni'ton, canta' catahuaramacoso pochin ni'nahuë,’ itarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ahuënanëhuë quëran acorahuësopitaso nipirinhuë', sha'huitarahuë: ‘Ya'ipinquëma' paco huachi. Tata Yosë co noyahuë' ni'ninquëma' ni'ton, ana'intarinquëma huachi. Panca pën nani acorin sopairo'sa' ana'intacaso marë'. Inaquë pën co onporonta' tacopiarinhuë'. Inaquë paco' canpitanta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tanapirahuë', co a'caramacohuë'. Yamoropirahuë', co o'shitëramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ya'huëramataquëchin na'huëpatëra, co pëinëmaquë aya'conamacohuë'. Capa a'moca'huasonta' nipirinhuë', co quëtëramacohuë'. Caniopirahuë', co huëcatoma' nosororamacohuë'. Tashinan pëiquë ya'huëpirahuë', co ni'quiramacohuë',’ itarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ina quëran natanarinaco: ‘¿Onporota' Sinioro tanapiranhuë' co a'carainquënhuë'? ¿Onporota' yamoropiranhuë' co o'shitërainquënhuë'? ¿Onporota' co pëinëhuëiquë aya'conainquënhuë'? ¿Onporota' a'mocaso' pahuantopirinquënhuë', co quëtërainquënhuë'? ¿Onporota' caniopiranhuë' co nosororainquënhuë'? ¿Onporota' tashinan pëiquë parisitopiranhuë' co catahuarainquënhuë'? Co onporonta' ina pochin ni'nainquënhuë',’ itarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Co'ta imarinacosopita parisitopirinahuë', co catahuaramahuë'. Sa'ahuaro'sa' ma'sha pahuantopirinahuë', co quëtëramahuë'. Co inapita nosororamahuë' ni'ton, co canta' nosororamacohuë',’ itarahuë. Itahuato, a'pararahuë huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Parisitopiquë pa'sahuatona', inaquë ya'huëmiatapi huachi. Noya nipisopitaso nipirinhuë', Yosë pochin nanpimiatapi huachi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nani a'chintohuachina, ca'tano'sanënpita itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Cato' tahuëri pahuanarin Pascoa nanicaso', nani nitotërama'. Naporo' Yosë quëran quëmapico niporahuë', masarinaco. Masahuatonaco, corosëquë patanantarinaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ina quëran corto hua'ano'sa', cotio ansiano'sa', inapita Caihuasë pëinënquë niyontonpi. Inaso' corto hua'an, chini chiníquën nanantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","5","Inaquë niyontonahuatona', ninontapi Quisoso tëpacaiso marë'. —Ama pita tahuëri chachin maahuasohuë', piyapi'sa' no'huihuachinënpoa'. Quisoso pa'yatapi ni'ton, ahuëarinënpoa'. Napoaton po'oana quëran maahua', nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Quisososo nipirinhuë' Pitaniaquë pa'nin. Simon pëinënquë coshatapatarin. Ina Simon chana caniori mapirinhuë', anoyatërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Misaquë coshatasoi', a'nara' sanapi huë'nin. Potiria'huaya huirina'pi quëran nipiso' quënin. Inaquë pimo hua'sai' na'con pa'tërinso' ya'huërin. Quisoso nosoroaton, opomototërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ina nicatona ca'tano'sanënpitaso', no'huitopi. No'huitatona ninontopi. —¿Onpoatonta' iso hua'sai' pa'ton nipirinhuë' chiniarin? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pa'anin naporini, na'con coriqui canaton sa'ahuaro'sa' quëtacaso' ya'huëchitonhuë', nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Quisosori natanahuaton, itërin: —¿Ma'marëta' iso sanapi no'huirama'? Tananpitoco'. Na'con nosoroatonco, inapotërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nani tahuëri sa'ahuaro'saso' ya'huërapi. Caso nipirinhuë', co hua'quiyahuë' canpitaro'co ya'huarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Co'huara chimiyantërasocohuë', nosoroatonco, nonëhuë hua'saiquë opotërinco pa'pitinacoso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","No'tëquën itaranquëma'. Ya'ipi parti noya nanan sha'huihuachina', iso sanapi napotërincoso' sha'huirapi anta'. Co naniantapihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ina quëran, Cotasë Iscarioti pa'pi co noyahuë' yonquirin. Quisoso ca'tanaponahuë', yasha'huirapirin. Corto hua'ano'sa' ya'huërinquë pa'sahuaton, itoonin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Po'oana quëran Quisoso a'notohuatënquëma', ¿onpo coriquita' quëtaramaco? itërin. —Cara shonca coriqui prata quëran nininso' quëchinquën, itopi. Itohuachinara: —Noyahua'. Quëtoco nipachin a'nochinquëma', topachina, quëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naporo quëran huarë' Cotasë yonquirarin po'oana quëran a'nocaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascoa tahuëri nipachina, nisha pan ca'pi, co ahuëpocatopisohuë'. Ina tahuëri nanihuachina, ca'tano'sanënpitari huëcapaipi. —¿Intohuata' Maistro paatoi, Pascoa cosharo' nii capacaso marë'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Ninanoquë paco'. Inaquë a'na quëmapi quënanconarama'. Ina quënanconpatama', sha'huitoco'. “Maistro a'parincoi ni'ton, huë'nai. Naporin: ‘Yosë ninorinso' nani naniriarin ni'ton, quëma pëinënquë Pascoa cosharo' ca'tano'sanëhuëpitarë'co chachin coshatarai, tënin,’ itonco',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pa'pachinara, Quisosori sha'huitërinso chachin quënanconpi. Quëmapi quënanconahuatona', nontopi. Nani natanconpachinara, inaquë Pascoa cosharo' nipi capacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nani tashihuachina, Quisoso ca'tano'sanënpitarë chachin huë'pi. Huë'sahuatona', misaquë huënsëquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Coshatapona pochin itërin: —No'tëquën ipora itaranquëma'. Shonca catonquëma' ca'tanpiramacohuë', a'naquëma' sha'huirapiaramaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Natanahuatona', sëtopi. Sëtatona', a'naya a'nayari Quisoso natanpi. —¿Incoita' Sinioro, yasha'huirapirainquën? ¿Co cahuë' nimara ti? itopi a'naya a'nayari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Tëhuënchachin a'naquëma' yasha'huirapiramaco. Ina sënanquëráchin i'shiaton carë' caponahuë', yasha'huirapirinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yosë quiricanën quëran ninorincoso chachin chiminarahuë. Yasha'huirapirincoso nipirinhuë', ma'huantacha nicapon paya. Co nasitërinhuë' naporini, noya noya niitonhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Itohuachina, Cotasërinta' itërin: —¿Incoita' Maistro, yasha'huirapirainquën? ¿Co cahuë' nimara ti? itohuachina, —Quëma chachin mini, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Coshatasoi', pan masahuaton Yosë nontërin. “Yosparinquën, Sinioro” itahuaton, së'panin. Ina quëran ca'tano'sanënpita quëtërin. —Ca'co' iyaro'sa'. Ca nonëhuë pochin iso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Minënta' masahuaton, “Yosparinquën Sinioro,” itahuaton, inanta' quëtërin. —Ya'ipinquëma' o'oco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ca huënainëhuë pochin iso'. Huënainëhuë pa'sarin ni'ton, nasha quëran canpitarë' Yosë anoyatërinso' sha'huichinquëma' imacamaso marë'. Chiminarahuë na'a piyapi'sa' oshanëna' inquita'huaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Co huachi opai' o'oantarahuë'. Chiminarahuë huachi. A'na tahuëri Tata Yosë hua'anëntërinso' nanihuachin, canpitaro'co nasha pochin o'oantarahuë. Naporo' noya noya cancantarihua huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ina quëran Yosë cantanën cantarahuatona', pipipi. Pipirahuatona', Oriposë panënquë pa'pi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Inaquë Quisosori itërin: —Iráca quiricanënquë ninoton, Yosë naporin: “Ca nohuanto, a'paitona'pi tëpaapi. Tëpahuachina', ohuicanënpita yanquëërapi,” tënin. Inapochachin yatëpahuachinaco, ya'ipinquëma' co chiníquën cancantatomahuë', ta'ananpiaramaco. Ipora tashi chachin napoarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Chiminaporahuë', Yosë ananpitaantarinco. Ananpitaantahuachinco, ca'ton Cariria'pa' pa'sarahuë. Inatohua' niquënantarihua', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","—A'napita ta'ananpipirinënquëonta', co caso' ta'arahuë', tënin Pitro. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—No'tëquën iyasha, itëranquën. Ipora tashi chachin co'huara atari përashatërasohuë', cararo' nonpinapiaranco. “Co caso' Quisoso nohuitërahuë',” toconapon, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Co Sinioro napoarahuë'. Quëma imasaranquën ni'ton, yatëpapirinacohuënta' co onporonta' nonpinapiaranquënhuë', itaantarin Pitrori. Inachachin topi ya'ipiya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ina quëran, Quisimani nararo itopiquë canconpi. Inaquë ca'tano'sanënpita sha'huitërin. —Isëquë huënsëtaco'. Pasëyáquë pa'sarahuë Yosë nontapo, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Caraíchin ca'tano'sanën amashamiachin quëparin. Pitro, Sipitio hui'ninpita inapitaíchin quëparin. Naporo' sëtaton, co napion cancantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Pa'pi sëtërahuë. Chiminchináchin sëtërahuë. Isëquë huënsëtaco'. Ama huë'ëtomarahuë', ni'táco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Amashamiachin pa'sahuaton, isonconin. No'paquë huarë' monshomarahuaton, Yosë nontërin: “Quëma nohuantohuatan Tata, nicha'ëco ama ma'sha onpo'isohuë'. Main o'orëso pochin parisita'huaso' ya'huërin. Co parisita'huaso' nohuantopirahuë', quëma nohuantohuatan, noya, tënahuë. No'tëquën yanatëranquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ina quëran huënantapirinhuë', cara chachin huë'ësápi quënanquintarin. —Iya Pitro, ¿co a'na ora tëranta' nanitëramahuë' ni'tamaso' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ama huë'ëtomahuë', ni'táco'. Yosë nontoco' ama sopai minsëinquëmaso marëhuë'. Cancanëma quëranso mini Yosë yanatëpiramahuë', co canpitaora chiníquën cancantaramahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ina quëran paantarahuaton, Yosë nontaantarin. —Nohuantohuatan Tata, nicha'ëco ama ma'sha onpo'isohuë'. Nipirinhuë' co nohuantohuatanhuë', ma'sona yaonpotohuatanconta' noya, tënahuë. No'tëquën yanatëranquën, itaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ina quëran huënantapirinhuë', naquëranchin huë'ëantapi, quënanquinantarin. Huë'ëi' iquitatona', huë'ësápi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tananpitahuaton, paantarin. Paantarahuaton, inachachin Yosë itantarin. Nani cararo' inachachin Yosë nontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ina quëran huënantahuaton, itërin: —¿Ipora huanta' huë'ësarama' ti? Nani ora nanirin huachi. Yosë quëran quëmapico nipirahuë', sha'huirapiarinco oshahuano'sa' macainacoso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Huënsëco huachi pa'ahua'. Ni'co', sha'huirapirincoso' nani canquiarin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nontaso chachin, Cotasë canquirin. Inanta' Quisoso ca'tanaponahuë', yasha'huirapirin. Inarë' na'a piyapi'sa' huë'sapi, corto hua'ano'sa', cotio ansiano'sa', inapitari a'papisopita. Sahuëni, shonqui, inapita së'quërahuatona' huë'sapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Co'huara canshatërasoihuë', Cotasëri nani sha'huitërin Quisoso nohuitacaiso marë'. “Insosona apinohuato, ina Quisososo'. Máco huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ina quëran ya'yoranquirahuaton: —Tashita Maistro, itiirahuaton, apinorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—Ma'sona yaninanso' iyasha, manóton niquë', itërin Quisosori. Ina quëran piyapi'sari chiníquën masapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ca'tano'sanënpita inaquë huaniapi. A'nara' sahuëninën ocoirahuaton, corto hua'an inpriatonën ahuërin. Ahuëaton, nishitëhuëratëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Quisososo nipirinhuë' co nohuantërinhuë'. —Sahuëninën iyasha, po'moantaquë'. Hua'naquë tëpatohuatama', hua'na quëran chachin tëpainëmaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tatahuë nontërahuë naporini, shonca cato huaranca anquëniro'sa' a'patimaitoncohuë'. A'naroáchin catahuaitonacohuë'. ¿Co ina nitotëranhuë' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Napoaponahuë', co nohuantërahuë' cha'ëca'huaso'. Nicha'ërinaco naporini, co huachi ninorinacoso' naniitonhuë'. Yosë nohuanton, chiminarahuë, itërin ca'tano'sanënpita. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ina quëran piyapi'sa' itapon: —Sahuëni, shonqui, inapita së'quërahuatoma', huëcapairamaco. Tëpatona'pi pochin cancantatomaco, ¿yamanamaco ti? Co'tana nani tahuëri Yosë chinotopiso pëiquë huënsëato, a'chinárahuë. Nicapomaracohuë', co manamacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Napoaponahuë', Yosë nohuanton, iporaso' masaramaco. Quiricanën quëran ninorinacoso chachin masaramaco, itërin. Ina quëran ya'ipi ca'tano'sanënpitari ta'ananpipi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nani masahuatona', corto hua'an chini chiníquën nanantërinso' ya'huërinquë quëpapi, Caihuasë itopiso'. Inaquë cotio maistro'sa', ansiano'sa', inapita nani niyontonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitroso nipirinhuë', aquë quëran imaquiarin. I'iratëquë huarë' imaquirin. Pairaanaquë ya'conahuaton, ponisiaro'sapitarë' huënsëquirin. “¿Ma'ta' onpotapona'? Tëpapona' nimara,” ta'ton, ni'sárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Corto hua'ano'sa', cotio hua'ano'sa' inapitari yatëpapi ni'ton, a'naya a'naya yonípi Quisoso sha'huirapicaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na'a piyapi'sari nonpinapiponaraihuë', nisha nisha nonconpi. Napoyan quëran catoya'piri huë'sahuatona', sha'huirapipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—I'hua chachin Quisoso noninso' natanai. “Yosë chinotopiso pëi' ata'huantahuato, caora nanitërahuë anoyatanta'huaso'. Cara tahuëri quëran anoyatantarahuë,” toconin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Corto hua'an chini chiníquën nanantërinsoari huanirahuaton, Quisoso itapon: —¿Co manta' tënanhuë' ti? ¿Ma'ta' tapona' isopita nonapiarinënquën? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Quisososo nipirinhuë' co manta' tëninhuë', ta'tárin. Ina quëran corto hua'ani itantarin: —“Yosë ni'sárinco co nonpinahuë',” ta'ton, no'tëquën sha'huitocoi. ¿Quëmaso' Cristo, Yosë hui'ninquën chachin ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Ca mini inaco. Yosë quëran quëmapico ni'to, a'na tahuëri niantaramaco. Inápaquë pa'pato, Yosë inchinanën quëran ahuënsëarinco. Ina quëran chitoro' huancana o'mantararahuë niantaramaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Corto hua'anso natanahuaton, chiníquën no'huitërin. Inapoaton a'morinso osharin. —“¡Caso' Yosë hui'ninco,” toconin! Nani natanama'. Inaora chachin sha'huitërinpoa' ni'ton, co a'napita sha'huitinpoaso' nohuantarihuahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ma'ta' onpotahua' Quisoso? tënin. —Pa'pi co noya quëmapihuë' ni'ton, tëpacaso' ya'huërin, topi ya'ipiya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ina quëran ipirayatahuatona', ahuëpi. A'naquëninta' tonporayatahuatona', chiníquën panpirayapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—¿Inta' ahuërinquën? Quëmaso' Cristonquën nipatan, ninoton no'tëquën sha'huitocoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Napotasoi, Pitroso' i'iratëquë huënsëarin. A'na cosonari huë'sahuaton, itiirin. —Quëmanta' Quisoso Cariria quëran huë'ninso' ca'tanan, itopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—¿Ma quëmapita' napotaranso'? Co caso' ina nohuitërahuë', itërin. Ya'ipiya natanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ina quëran pa'sahuaton, ya'coanaquë huaniso', a'na cosonarinta' quënanquiantarin. Quënanahuaton, huanipapisopita itapon: —Iso quëmapi Quisoso Nasaritoquë ya'huërinso' ca'tanin anta', itaantapirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—¡Co'chi nohuitërahuë' paya! Yosë ni'sárinco, co nohuitërahuë', taantarin Pitro. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ina quëran hua'quimiachin nisahuaso', a'napitarinta' itaantapi: —Tëhuënchachin quëmanta' Quisoso ca'tanan. Cariria piyapi pochin nonan quëran nohuitërainquën, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—¡Co'chi iyaro'sa' paya! Yosë ni'sárinco, co cariso' nohuitërahuë'. Nonpintohuatënquëmaso', Yosë ana'inchinco, tënahuë, itërin. Naporo chachin atari përarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ina natanahuaton, Quisosori napotërinso' yonquirin: “Co'huara atari përashatërasohuë', cararo' nonpinapiaranco,” itërinco, ta'ton, aipiran pipirin. Inaquë chiníquën sëtaton, na'nërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tahuërianpitohuachina, ya'ipi corto hua'ano'sa', cotio ansiano'sa', inapita napopianachin yonquipi Quisoso atëpatacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ina quëran noyá tonporahuatona', Pirato ya'huërinquë quëpapi. Inaso' hua'an, Noma copirnori acorinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cotasëso' nani sha'huirapiponahuë', Quisoso tonpopinan quëpahuachinara, ni'sárin. Ina ni'sahuaton, yonquirin huachi. “Ma'tana tëpacaiso marë' quëparapi. ¿Onpoatocha sha'huirapirahuë paya?” ta'ton, sëtërin. Corto hua'ano'sa' ya'huëpiquë paantarahuaton, cara shonca coriqui prata quëran nininso' quëtopiso' yayo'coantapirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Co huachi iso coriqui nohuantërahuë'. Pa'pi co noyahuë' ninahuë. Quisoso nóya quëmapi nipirinhuë', sha'huirapirahuë. Ina marë' oshahuanahuë, itoonin. —¿Ma'marëta' ina sha'huitërancoi? Co quiyaso' ina yonquiraihuë'. Quëma naporanso', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Napotohuachinara, Yosë chinotopiso pëiquë chachin coriqui të'yatonahuaton, pipirin. Pa'sahuaton, nihuënquëconorahuaton, nitëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ina quëran corto hua'ano'saso' coriqui maantarahuatona': —Tëpacaiso marë' pahuërëtopiso' ni'ton, co Yosë marë' acocaso' ya'huërinhuë'. Inaquë acohuatëhua', co Yosë pënëntërinso' natëarihuahuë', ta'tona', co inaquë acopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","—Iso coriquiquë no'pa' pa'ahuan' nisha piyapi'sa' pa'pitacaso marë', topachinara: —Noyahua', topi ya'ipiya. Napoaton pa'sahuatona', ina coriquiquë no'pa' pa'anpi. “Tëshitona'pi no'panën,” itopiso' pa'anpi. Inaquë nisharo'sa chiminpachinara, pa'pitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Napoaton ipora huanta' ina po'oroso': “Huënai' No'pa',” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iráca Irimiasë ninoton, Yosë quiricanënquë ninshitërin. “Cara shonca coriqui prata quëran nininso' quëtapi. Ina nápo' cotioro'sa' nohuantopi ni'ton, quëtapi. Ina coriqui chachin maantarahuatona', ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tëshitona'pi no'panën pa'anapi. Yosë sha'huitërincoso chachin napoapi,” tënin, ninshitaton. Naporinso chachin ina nápo' coriqui masahuatona', no'pa' pa'anpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Quisososo' Pirato notënanquë huaniárin. —¿Quëmaso' cotioro'sa' copirnonquën ti? itërin Piratori. —Ca mini inaco, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Corto hua'ano'sa', cotio ansiano'sa', inapitari na'con nonpinapipirinahuë', co manta' tëninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","—Na'con nonapirinënquën, ¿co natananhuë' ti? itopirinhuë' Piratori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Co manta' tëninhuë'. Co pi'pisha tëranta' a'panitërinhuë'. “Ma quëmapita' isoso' ni'ton, co manta' yaa'panitërinhuë',” tënin Pirato yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nani Pascoa tahuëri Piratoso', a'nara' apina'pi tashinan pëi quëran ocoirin. Insosona piyapi'sari nohuantopiso' ocoirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tashinan pëiquë a'na apina'pi ya'huarin. Inaso' pa'pi co noyahuë'. Ya'ipi parti nahuiantërinso'. Parapasë itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Piyapi'sa' huë'pachinara, Piratori itërin: —Ipora Pascoaquënta' a'nara' apina'pi ocoianta'i, topirahuë'. ¿Insota' nohuantërama' ocoica'huaso'? Cato' ya'huapi. A'naso' Parapasë. A'nanta' Quisoso, Cristo itopiso'. ¿Insochachinta' nohuantërama' ocoica'huaso'? Canpita huayonco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","“Cotio hua'ano'sari co quë'yatonahuë', Quisoso mapi,” ta'ton, Piratori napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hua'an shiranënquë huënsëaso', sa'ininta' nanan a'patiirin Quisoso ocoicaso marë'. “Achin tashi' a'ninquëchin hua'narahuë. Quisoso hua'nato, chiníquën pa'yanahuë. Inaso' noya quëmapi. Co manta' onporinhuë' ni'ton, nicha'ëquë'. Co tëpacaso' ya'huërinhuë',” itërin sa'ini. Ina marënta' Piratori co yatëparinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Corto hua'ano'sa', cotio ansiano'sa', inapitaso nipirinhuë', a'naya a'naya piyapi'sa' sha'huitëra'piapi: —“Parapasë ocoirahuaton, Quisoso atëpatëquë',” itoco', itëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ina quëran Piratori natanin huachi. —¿Insochachinta' ocoi'i? itaantarin. Napotaantahuachina: —¡Parapasë ocoitocoi! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Ma'ta' onpochi nipachin Quisoso, Cristo itopiso'? itohuachina: —¡Corosëquë patanantëquë' chimi'in! tosapi ya'ipiya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Ma'marëta' tëpa'i? ¿Ma'ta' onporin? itopirinhuë', aquëtë chachin chiníquën itantapi: —¡Corosëquë patanantëquë' chimi'in! itaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Napotohuachinara, nisha yonquirin huachi. “Piyapi'sa' co yanatërinacohuë'. Chiníquën no'huitatona', yaahuërinaco,” ta'ton, co huachi yonquirinhuë' Quisoso ocoicaso'. Napoaton i'sha masahuaton, piyapi'sa' ni'tërantapaquë hui'sërin. —Iso quëmapiso' noya. Co manta' onporinhuë', tënahuë. Co ca nohuanto, tëpaapihuë'. Co ina marë' ana'intincoso' ya'huërinhuë'. Canpita yonquiramaso', itahuaton, hui'sërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Tëhuënchachin quiya yonquirai tëpaca'huaiso'. Yosë yaana'intohuachincoi, hui'nahuëipitarë'coi chachin ana'inchincoi, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Napohuachinara, Pirato camaitërin Parapasë ocoicaiso'. Quisososo nipirinhuë' chiníquën ahuihuitërin. Chiníquën huihuitona', pë'sha pë'shatopi. Nani huihuihuachinara, sha'huitërin corosëquë patanantacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sha'huitohuachina, Pirato pëinënquë quëpapi. Inaquë notohuaro' sontaro'sa' niyontonpi tëcariatona' tëhuacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ai'nanpiratahuatona', quëhuanën miachin hua'an a'morinso pochin nininso' a'motopi tëhuacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yancotënta' nahuan quëran nicatona', ayancotopi. Ina quëran tëhuacaiso marë napotopi: —Ma'tana huaranën maquë huachi, itatona', piquiranan asë'quëëpi. Naporahuatona' ina notënanquë isonpi: —Hua'qui tahuëri nanpiton cotioro'sa' hua'anëntëquë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ina quëran iraiquë ipitopi. Piquirananta' matantarahuatona', ahuëmotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Inapotatona', tëhuapi. Nani tëhuahuachinara, a'motopiso' ocoitahuatona', a'morinso chachin a'motantapi. Ina quëran corosëquë patanantacaiso marë' quëpapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ninano quëran pipirahuatona', a'na quëmapi nacapipi, Siriniquë ya'huërinso'. Simon itopi. Ina masahuatona', corosë Quisoso quëparinso' sontaro'sari apitëntopi. Inari quëpatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pa'sahuatona', panëa'hua Corocota, itopiquë canconpi. Corocotaso': “Nansë Moto',” tapon naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Inaquë canconahuatona', huino ma'sha pinshiinë' ayontahuatona', o'shitopirinahuë', pi'pisha pi'nirahuaton, co o'orinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ina quëran sontaro'sari corosëquë patanantopi. Nani patanantahuatona', ninontopi. “Huëco', nicanatëhua' Quisoso a'morinsopita maahua',” nitatona', ya'nipirapi. Naporahuatona', a'naya a'naya mapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nani masahuatona', inaquë huënsëapi nicacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Onporinso marësona tëparapisonta' ninshitopi. isoso' quisoso, cotioro'sa' copirno ta'caso', ninshitopi. Inapotahuatona', corosëquë chachin motën pëtëcha achinpitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ina pirayan cato' apiro'santa' patanantopi. Nisha patanantopi. A'nara' inchinan quëran, a'nanta' ahuënan quëran acopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Piyapi'sa' na'huëpona pochin, Quisoso tëcariatona', tëhuaconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—¿Nani ma'sha nanitaparan ti? I'hua naporan: “Yosë chinotopiso pëi' ata'huantohuato, cara tahuëri quëran anoyatantarahuë,” tënan. Inta nipachin cha'ëquë'. Yosë hui'ninquën chachin nipatan, corosë quëran nohuararahuaton cha'ëquë', itoonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Inapochachin corto hua'ano'sa', cotio maistro'sa', cotio ansiano'sa', inapitarinta' tëhuatona', itapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—A'napitaso' yanicha'ëponahuë', inaora chachinso' co nanitërinhuë' cha'ëcaso'. Israiro'sa' copirno nipachin, corosë quëran nohuarain nicatëhua' natëahua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Yosë hui'ninco chachin ni'ton, catahuarinco,” topirinhuë'. Yacatahuahuachin, apiramiáchin nicha'ëin, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ina pirayan patanantopisopitanta' Quisoso no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Camotëchin nisahuaso', ya'ipi parti tashirarin. I'huaraya huarë' yono tashi pochin nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naporo' Quisoso chiníquën nonin. Iri, Iri, ¿nama sapacatani? tënin. Inaora nananquë nonaton, naporin. “¿Onpoatonta' Tata patëranco?” tapon naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A'naquën huanipapisopita natanahuatona': —Iniasë përasamara, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A'naso' manorahuaton, pi'shiro pochin nininso' maconin. Ina masahuaton, huino áin nininso' asë'cotëtahuaton, piquirananquë achinpitërin. Achinpitahuaton, ihuëtërin o'ocaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A'napitariso nipirinhuë' itapona': —Tananpitëquë' nia'ahua'. Iniasëri o'maton nicha'ëpon nimara, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Quisososo nipirinhuë' chiníquën nonsahuaton, chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naporo' Yosë chinotopiso pëiquë tanontën në'mëtë' patonpiso' noshatërin. Inaora noshataton, catotë huarë' ninin. Inapa quëran no'paquë huarë' noshatomarin. Naporahuaton, panca ocohua pa'nin. Na'piro'sa' inaora nopaatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nopaatohuachina, a'naya a'naya pa'pitopiso' nii'soatërin. A'naquën Yosë imarinsopita iráca ayapirinahuë', nanpiantapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Quisoso nanpiantarinso' piquëran inapitanta' pa'pitopi quëran pipirahuatona', Quirosarinquë pa'sapi. Na'a piyapi'sari quënanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Quisoso chiminpachina, capitanso sontaronënpitarë chachin ni'sapi. Ocohua pa'ninso', na'piro'sa' nopaatërinso', inapita ni'sahuatona', pa'pi pa'yanpi. —Tëhuënchachin iso quëmapiso', Yosë hui'nin, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sanapi'sa' Cariria quëran huë'pisopitanta', aquë quëran notëërapi. Inapitaso' Quisoso imaquipi nocomacaiso marë'. Iporaso' chimininso' ni'sapi anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A'naso' Maria Mactarina itopiso'. A'nanta' Maria. Inaso' Santiaco, Cosi, inapita a'shin. A'nanta' Sipitio hui'ninpita a'shin. Inapitaso' aquë quëran notëërapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","I'huararapaso', a'na ma'huan Cosi itopiso huë'nin. Inaso', Arimatiaquë ya'huërin. Quisoso imarin anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pirato ya'huërinquë pa'nin Quisoso nonën natantacaso marë'. “Quëtoco cari quëpa'i,” itoonin. Napotohuachina, “Noyahua'. Quëpaquë' nipachin,” itahuaton, sontaro'sa' a'parin nonën anohuaratacaiso marë'. Anohuararahuatona', quëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nonën masahuaton, noya morinquë so'quëëtahuaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na'pi nanin nasha nininquë po'morin. Inaora marë' pa'anpirinhuë', inaquë po'morin. Ina quëran pancara'pi masho pitarahuatona', pa'copitopi. Pa'copitahuatona', patopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Mactarina, a'na Maria, inapitaso nipirinhuë' na'pi nanin notënanquë chachin huënsëapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tahuëririnquë chinoto tahuëri marë' nani tapahuachinara, corto hua'ano'sa', parisioro'sa', inapita niyontonahuatona', pa'pi Pirato nontacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Sinioro hua'an, Quisosocoso' nonpintë', tënai. Nani yonquirai. Co'huara chimiyantëraponhuë', piyapi'sa' sha'huitërin. “Tëpahuachinaco, cara tahuëri quëran nanpiantarahuë,” toconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Napoaton sontaro'sa' a'paquë' na'pi naninquë a'paicaiso marë'. Cara tahuëri chachin noya a'pai'ina', ama nonën quëpacaiso marëhuë'. Ca'taninsopitari quëpahuachina': “Nani nanpiantarin huachi,” toconapona'. Napohuachina', aquë aquëtë' piyapi'sa' nonpintapi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Inta nipachin, sontaro'sa' ya'huarin. Canpitari chachin paatoma', inapita quëpaco' noya ni'ina'. Ama piyapi'sari huëcatona' quëpacaiso marëhuë' inapo'ina', itërin Piratori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Napohuachina, pa'pi. Pancara'pi to'ni pochin nininquë noyá pa'pirapitopi. Napotahuatona', sontaro'sa' acopi. —Noya a'paico', itahuatona' patopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chinoto tahuëri piquëran Maria Mactarina, a'na Mariarë' naquëranchin paantapi po'mopiquë nicacaiso marë'. Tomio tahuëri tashíramiachin na'pi nanin'pa' pa'sapirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A'nanaya panca ocohua pa'nin. Sinioro anquëninëni inápa quëran o'marahuaton, pancara'pi pa'copitopiso' chi'huincarin. Chi'huincarahuaton, ina aipi huënsërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Huënaráchin huënaráchin o'cori pochin ya'norin. Huiríchin a'morin. Pi'shiro quëran huiri huiríchin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ina ni'sahuatona', sontaro'sa' pa'yanpi. Pa'pi të'huatopi. Ropa ropátahuatona', chimipi pochin no'paquë anotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ina quëran sanapi'santa' canquihuachinara, anquëniri itërin: —Ama pa'yancosohuë'. Quisoso corosëquë patanantopiso' yonisaramaso', nitotërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Co huachi isëquë ya'huërinhuë'. Sha'huitërinquëmaso chachin nani nanpiantarin. Huëco' ni'quirico' po'mopiquë. Capa huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Manóton paatoma', ca'tano'sanënpita sha'huitonco': “Nani nanpiantarin. Ina'ton Caririaquë pa'sarin. Inatohua' quënancoantarama',” itonco'. Nani sha'huitëranquëma', itërin anquëniri. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Natanahuatona', a'naroáchin na'pi nanin quëran pipipi. Pa'pi pa'yanpirinahuë'. Nóya cancantatona' ta'api ca'tano'sanënpita sha'huitacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pa'sapirinahuë', a'nanaya iraquë chachin Quisosori ya'notërin. —Huë'cama imoyaro'sa', itërin. Ina nohuitatona', ya'carionpi. Monshorahuatona', nantën iporantërahuatona', chinotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Ama huachi pa'yancosohuë'. Paatoma', iyahuëpita sha'huitonco' Cariria'pa' pa'ina'. Inatohua' quënancoantarinaco, itahuaton, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sanapi'sa' paasoi', sontaro'santa' ninanoquë pa'pi corto hua'ano'sa' sha'huitacaiso marë'. “Quisoso pa'pitopiquë noya ni'sapiraihuë', a'nanaya panca ocohua pa'nin. Naporo' anquëni ya'norahuaton, pancara'pi pa'copitopiso' chi'huincarin. Ni'piraihuë', Quisoso nonën capa huachi,” itonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ina quëran corto hua'ano'sa', cotio ansiano'sa' inapita niyontonahuatona', ninontápi. Nani ninontohuachinara, sontaro'sa' amatantarahuatona', na'con coriqui quëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Piyapi'sa' sha'huitoco': “Yono tashi' Quisoso ca'tano'sanënpita huë'pi. Huë'ësocoi, nonën quëpapi,” itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hua'anëma' natantaton ina marë' no'huihuachinquëma', quiyari anoyatarai ama ana'intinquëmaso marëhuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","—Noyahua'. Napo'i nipachin, tosahuatona', coriqui ma'patopi. Pa'sahuatona', piyapi'sa' nonpintopi. Cotio hua'ano'sari sha'huitopiso chachin nonpinpi. Ipora huanta' na'a cotioro'sa' ina nonpin nanan natëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ina quëran shonca a'na ca'tano'sanënpitaso' pa'pi Cariria'pa'. A'na panënquë pa'pi, Quisosori sha'huitërinquë chachin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Inaquë Quisoso quënanconahuatona', chinotopi. A'naquënso nipirinhuë' pi'pian co natërinhuë'. “Co inahuë' nimara,” topirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Quisosori ya'carirahuaton, itapon: —Tata Yosë nohuanton, chini chiníquën nanantërahuë. Inápaquë ya'huërinsopita, isoro'paquë ya'huërinsopita, ya'ipiya hua'anëntarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Napoaton canpita paatoma', ya'ipi piyapi'sa' a'chintoco'. Nisha nisha nananquë nonpisopita a'chintoco' imainaco. Insosona natëhuachinaco, i'quë aporintoco'. “Tata Yosë, Hui'nin, Ispirito Santo inapita nanan quëtërincoi ni'ton, aporintaranquën,” itahuatoma', aporintoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ina quëran ya'ipi sha'huitëranquëmaso' a'chintoco' natëinaco. Insëquësona pa'patama', carinquëma' ca'tanaranquëma'. Nani tahuëri catahuaranquëma'. Ayaro' tahuëri naniquë huarë' ca'tanaranquëma'. Co onporonta' pataranquëmahuë', itërin Quisosori. Nani huachi.");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Apira iyaro'sa', Quisocristo nanamën ninshitaranquëma'. Inaso' Yosë hui'nin chachin. Iráca isoro'paquë o'marin nicha'ëinpoaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaiasë pënëntona'pi ninoton Yosë quiricanënquë ninshitërinso chachin o'marin. Inaquë Yosëri hui'nin itapon: “Co'huara pa'shamátërasënquënhuë', comisionëhuë'ton a'pararahuë piyapi'sa' ayonquicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Inotëro parti ina quëmapi pënëntápon: ‘Ni'co' iyaro'sa'. Hua'an chiníquën nanantona'pi ni'ton, a'na parti yapa'pachina, comisionën a'parin ira tapatacaso marë'. Ira otëërin noya pa'tacaso marë'. Inapochachin iporaso' cancanëma' anoyatoco' Sinioro o'main,’ itarin,” tënin ninshitaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ninorinso chachin Coansha huë'nin pënëntacaso marë'. Inotëro' parti ya'huaton, piyapi'sa' pënënárin. “Co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtantaco' oshanëma' inquichinquëma'. Ina quëran aporihuanco',” itarin. Napotahuaton, na'a piyapi'sa' aporintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Inaquë notohuaro' piyapi'sa' huë'pi natanapona'. Quirosarin quëran huë'pi. Ya'ipi Cotia parti quëran huëcatona', natanapi. “Tëhuënchachin co noyahuë' nicatoi, oshahuanai. Catahuacoi Sinioro ina nanianchii,” topachinara, Cortaniquë Coanshari aporintërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Co inaso' noyápiachin a'morinhuë'. Ponira pochin camiyo anporo quëran nipiso' a'morin. Sha'huëtë quëran nitonporin. Sëquërë pochin nininso' macaton, inaya tëranta' ca'nin. Ninoi' quënanpachina, irorin. Piyapi'sa' pënënpachina, itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","“Ca piquëran a'na quëmapi huë'sarin chini chiníquën nanantërinso'. Caso' co pi'pian tëranta' ina pochin chiníquën nanantërahuë'. Co maquëyancohuë' ni'ton, co sapatën i'quirita'huaso tëranta' nanitarahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Caso' i'quë aporintëranquëma'. Inaso nipirinhuë' Ispirito Santo aya'coancantarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naporo tahuëri'sa' Quisoso Cariria parti quëran huë'nin. Nasaritoquë ya'huëpirinhuë', Coansha pënëntarinquë huë'nin. Huë'pachina, Coanshari Cortaniquë aporintërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ii' quëran nonshihuachina, a'naroáchin inápaquë pi'iro'të' ni'soatërin. Ispirito Santonta', nëpë pochin nohuaraimarin, ni'nin. Nohuaraimarahuaton, Quisoso ya'coancantomiatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Naporo' inápa quëran Yosëri itapon: “Quëmaso' hui'nahuënquën chachin ninan. Na'con nosoroatënquën, noya ni'nanquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ina quëran Ispirito Santori inotëro parti co piyapi ya'huërinquëhuë' a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Inatohua' catapini shonca tahuëri ya'huërin. Tanan ni'niro'sapitarë' ya'huërin. Sopai hua'aninta' huëcapairahuaton, tënirin. Sha'huitápirinhuë' ama Yosë natëcaso marëhuë'. “Inca, co nohuantërahuë',” tënin. Nani sopai pa'pachina, anquëniro'sari o'marahuatona', Quisoso nocomaimapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ina quëran Coansha tashinan pëiquë po'mopi. Ina natantahuaton, Quisoso pa'nin Cariria parti pënëntapon. Noya nanan Yosë noninso' sha'huirarin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Nani tahuëri nanirin huachi. Iso tahuëri'sa' Yosë yahua'anëntarinquëma'. Napoaton ya'ipi co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtantaco'. Naporahuaton noya nanan natëco' Yosë nicha'ëinquëma',” itërarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ina quëran Cariria sono' yonsanquë pa'sahuaton, cato' sami camayoro'sa' quënanconin. A'naso' Simon itopi. Iinë' riti të'yatapi sami macacaiso marë'. Iinso' Antërisë itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Huëco' iyaro'sa', ca imaco a'chinchinquema'. Sami manamaso pochachin piyapi'sa' masarama' Yosë imacaiso marë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Napotohuachina, ritinëna' patahuatona' Quisoso imapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Amashamiachin Santiaco, Coansha, inapitanta' quënancoantarin. Sipitio hui'ninpita inahuaso'. Pa'pinarë' potiquë huënsëatona', ritinëna' pasonapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","“Huëco' pa'ahua', ca imaco,” itohuachina, pa'pin, inpriatonënpita, inapita potiquë patahuatona', Quisoso imapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ina quëran Capinaomoquë canconpi. Chinoto tahuëri nanihuachina, cotioro'sa' niyontonpiso pëiquë ya'conin. Inaquë a'chinarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chiníquën nanantona'pi pochin a'chinarin. Co cotio maistro'sa pochin a'chininhuë'. Napoaton a'chininso' natanahuatona', piyapi'sa' pa'yanpi: “¡Ma'pitacha Quisoso nitotërin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naporo' a'nara' quëmapi inaquë ya'huërin. Sopairi ya'coancantaton, camairin ni'ton, pa'pi co noyahuë' yonquirin. Quisoso quënanahuaton, chiníquën nontërin. Sopairi chachin anonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Tananpitocoi! Quëmaso' Quisosonquën, Nasaritoquë ya'huëran. Nohuitërainquën. Yosë quëran o'maton noya ninan. ¿Ma'ta' quëma onpotaponcoi? ¿Ata'huantaponcoi ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Itohuachina, Quisosori itapon: —¡Ta'tëquë'! ¡Iso quëmapi quëran pipimiatëquë'! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Napotohuachina, quëmapi chiníquën apa'tanin. Naporahuaton chiníquën “yai” ta'so chachin, sopai pipirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ya'ipi piyapi'sa' pa'yanahuatona', ninontapi: —¿Ma'pítata' ni'sarëhuaso'? Quisososo' co a'napita pochin a'chininhuë'. Chini chiníquën nanantaton, sopairo'sa quëran huarë' camaihuachina, natëpi, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Shiarahuaton, Quisoso naporinso' ya'ipi Cariria parti nahuinin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ina quëran niyontonpiso pëi quëran pipirahuatona', Simon, Antërisë, inapita ya'huëpiquë pa'pi. Santiaco, Coansha, inapitanta' pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon a'shatën chiníquën sapoton, quëhuënárin ni'ton, Quisoso sha'huitopi. “A'shacha saporin ta'a,” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Inaquë paaparahuaton, maimirarahuaton, opatërin. Naporo chachin sapo otanotërin. Otanotahuaton, inari chachin a'carin, o'shitërin, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","I'huanahuanquë nani pi'i ya'conahuaso', na'a cania'piro'sa' quëpi. Sopairi ya'coancantërinsopitanta' quëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ya'ipi ya'huëhuano'santa', ninano' ya'coanaquë niyontonpi Quisoso nicacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Naporo' notohuaro' cania'piro'sa' anoyatërin. Nisha nisha caniori maninsopita anoyatërin. Na'aya'pi sopairo'sari ya'coancantërinsopitanta' inquitërin. Sano yonquipi huachi. Sopairo'sari ina nohuitatona', yasha'huipirinahuë', Quisoso co nohuantërinhuë' ni'ton, ta'topi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tahuëririnquë co'huara noya huënihuayantërasohuë', Quisoso huënsërahuaton ninano quëran pipirin. Co piyapi ya'huërinquëhuë' Yosë nontacaso marë' inaoraíchin pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simonso' capayatopirinhuë', co Quisoso quënanatonhuë', a'napitarë chachin pa'nin yonípon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Quisoso quënanconahuatona': —Notohuaro' piyapi'sa' yonisarinënquën, itopi. Itopirinahuë', Quisosori itërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—Huëco' iyaro'sa', a'na partinta' pa'ahua'. Ya'cariya ninanoro'saquë pa'ahua'. Inaquënta' pënënta'huaso' ya'huërin. Ina marë' Yosë a'paimarinco ni'ton, huë'sarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ina quëran ya'ipi Cariria parti pa'sahuaton, niyontonpiso pëiro'saquë pënëntëra'piarin. Naporahuaton, sopairo'sari ya'coancantërinsopita inquitëra'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Naporo' a'na quëmapi huë'nin, chana caniori maninso'. Quisoso huëcapairahuaton, isonquirin. Isonahuaton, itapon: —Nohuantohuatan, nanitëran anoyatancoso'. Anoyatoco topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Quisosori nosoroaton, së'huarin. —Nohuantërahuë mini iyasha. ¡Noyatëquë huachi! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Itohuachina, a'naroáchin canio inquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Naporo chachin Quisosori chiníquën pënënin. —¡Ama insonta' sha'huitëquësohuë'! Corto hua'ainchin sacatërinquë paaton, noyatëranso' a'notonquë' ni'inquën. Naporahuaton, Moisësë sha'huirinso' quëpaquë' noyatëranso' nitotacaiso marë', itërin. Ina quëran a'parin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Napotopirinhuë', papon pochin ya'ipi piyapi sha'huitëra'piarin. “Quisoso anoyatërinco,” itëra'piarin. Ya'ipi naporinso' nahuinin. Napoaton piyapi'sa' ni'tërantapaquë co huachi Quisoso iratërinhuë'. Co huachi nanitërinhuë' a'ninquëchin ninanoro'saquë pacacaso'. Co piyapi'sa' ya'huërinquëhuë' ya'huërárin. Ina niponahuë', ya'ipi parti quëran huë'pi nicapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cara tahuëri quëran pochin Capinaomoquë huëantarin. “Pëinënquë Quisoso ya'huarin,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Natantahuatona', notohuaro' piyapi'sa' niyontonpi. Pëi' ya'sotahuatona', ya'coana aquëtëran huarë' yamopi. Yosë nanamën sha'huirarin, natanapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Naporo chachin catapini quëmapi'sa' huëcatona', apia pë'sara'huayaquë quëshipi. Hua'qui' co nanitërinhuë' huanicaso', quëhuënárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Quisosoquë yaquëpapirinahuë', hua'huayátërahuë piyapi'sa' ni'ton, co nanitopihuë' ya'conacaiso'. Ya'shotopi. Napoaton pëi' nanpëtahuatona', a'canpiso pi'pian o'quirahuatona', pë'sara'huayarë chachin anohuaramapi. Quisoso pirayan acomapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Quisosori ni'sahuaton, “Ma noya isopita natërinaco,” ta'ton, apia itapon: —Oshanën apia'hua inquitaranquën huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A'naquën cotio maistro'sa' inaquë huënsëpisopitaso', cancanëna quëran yonquirápi: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ma quëmapita' isoso' Yosë yaya'huërëtërin? Co ínsonta' nanitërinhuë' oshanënpoa' inquitinpoaso'. Yosëíchin nanitërinso',” topi yonquiatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Topinan yonquirapirinahuë', yonquipiso nitotaton Quisosori itapon: —¿Onpoatomata' co noyahuë' yonquirapiramaco? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Canpitaso naporama': “Piyapinpoa a'napita oshanën inquitacaso', co nanitërëhuahuë'. Apia camaiatë': ‘Huaniquë' apia'hua. Pë'sara'huanën masahuaton, noya paquë huachi,’ itacasonta' co nanitaparëhuahuë',” tënama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Caso nipirinhuë' Yosë quëran quëmapico ni'to, nanan quëtërinco piyapi'sa' oshanëna' inquita'huaso marë'. Canpitanta' ina nitotacamaso marë' iso apia anoyatarahuë, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ina quëran apia itantarin: —¡Huaniquë' apia'hua! Pë'sara'huayanën masahuaton, ya'huëranquë paquë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Itohuachina, a'naroáchin noyatahuaton, huanirin. Pë'sara'huaya masahuaton, ya'huërinquë paantarin. Ina ni'sahuatona', piyapi'sa' pa'yanpi. —¡Ma noyacha Yosëso ni'ton, a'naroáchin anoyatërin paya! Co onporonta' ina pochin ni'chinëhuahuë', topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Naquëranchin panca sono' yonsanquë Quisoso paantarin. Inaquë hua'huayátërahuë piyapi'sa' huë'pachinara, a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ina quëran na'huëpon pochin, Nihui quënanconin. Arpio hui'nin inaso'. (Matio itopi anta'.) Coriqui Noma copirno marë' ma'patërinquë huënsëarin. Quisosori itapon: —Huëquë' iyasha imaco, itërin. Itohuachina, huanirahuaton Quisoso imasarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ina quëran pëinënquë Quisoso quëparin coshatacaso marë'. Ca'tano'sanënpitarë' coshatapatapi. Na'a piyapi'sa' huë'pi coshatatona' Quisoso nohuitacaiso marë'. A'naquën copirno marë' coriqui ma'patona'piro'sa'. A'napitanta' oshahuano'sa' itopiso'. Inahuanta' Quisoso yaimápi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A'naquëonta' cotio maistro'sa', parisioro'sa', inapitari ni'sahuatona', ca'tano'sanënpita natanpi: —¿Onpoatonta' maistronëma' oshahuano'sapitarë' coshatarin? Copirno marë' coriqui ma'patona'piro'santa' co noyahuë' nipirinahuë', inapitarë' coshatarin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Natanahuaton, Quisosori itapon: —Isopitaso' tëhuënchachin nohuantërinaco imainacoso'. Ni'co'. Cania'piro'saso' notoro nohuantopi. “Co caniorahuë',” topatëraso', co notoro nohuantërëhuë'. Inapochachin canta' oshahuano'sa' pënëna'huaso marë' o'marahuë. “Co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtantaco',” itërahuë. A'napitaso nipirinhuë': “Quiyaso' noyacoi,” topiso marë' co na'con a'chintërahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naporo' Coansha Paotista imapisopitaso ayonatona', Yosë nontapi. Parisio imapisopitanta' inapoapi. Napohuachinara, a'naquëni paaparahuatona', Quisoso natanpi: —Coansha imapisopitaso' ayonatona', Yosë nontapi. Inapochachin parisio imapisopitanta' nisapi. ¿Onpoatonta' imarinënsopitaso' co inapopihuë'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","—Ca ya'huarahuë ni'ton, co sëtopihuë'. Ni'co'. Quëmapi sa'acaso marë' piyapi'sa' amatohuachina, coshatatona', capa cancantopi. Nipayarinsopita huë'pachinara, coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A'na tahuëriso nipirinhuë' inimiconënpitari sa'ana'pi masapi. Quëpatohuachina', sëtapi huachi. Co huachi yonquiapihuë' coshatacaiso', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Itahuaton: “Ni'co'. A'morëso noyá mocahuachina, co nasha në'mëtëquë pa'pitërëhuë'. Nasha në'mëtëquë pa'pitërë' naporini, naquëranchin panca panca noshataanta'itonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sha'moronta' yonquico'. Huino sha'moro' nipachina, co sha'huëtë' morsa mocaro' nininquë ta'panëhuë'. Inaquë ta'panë' naporini, a'naroáchin nopoitaton, nichinia'itonhuë'. Naporahuaton morsanta' tapiitonhuë'. Napoaton sha'moro' huinoso' nasha morsaquë ta'panë'. Huino, morsanta' noya nisarin huachi,” itërin Quisosori. (Iráca inachintopiso' naniantatona', nasha nanan imacaso' ya'huërin, tapon napotërin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ina quëran a'na chinoto tahuëri nanihuachina, tricoro' Quisoso pëntontarin. Ca'tano'sanënpitaso papona pochin, a'naya a'naya trico moto maraapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ina nicatona parisioro'saso': —¡Ni'quë', Maistro! Chinoto tahuëri nipirinhuë', ca'tano'sanënpita tricoraya i'shorayarapi. Co ipora tahuëriso' pi'pisha tëranta' sacatacasohuë' nipirinhuë'. ¿Onpoatonta' co Moisësë pënëntërinso' natëpihuë'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","—Yosë quiricanën ¿co nontëramahuë' ti? Iráca Tapi tanahuachina, Yosë pëinënquë ya'conin. Apiataro corto hua'an ni'so' ya'conahuaton, pan Yosë marë' acopiso' ca'nin. Ca'taninsopitanta' quëtërin, ca'pi anta'. Corto hua'ano'sáchin ina pan capacaso nipirinhuë', co ina marë' Yosëri no'huirinhuë', itërin. Ina quëran itantarin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","—Piyapi'sa' nosoroaton, chinoto tahuëri acorin noya ya'huëcaiso marë'. Co tahuëri chinotacaso' na'con na'con yonquirinhuë'. Piyapi'sa' na'con na'con nosororin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yosë quëran caso quëmapico ni'to, chiníquën nanantërahuë. Ma'sona noya nicacaso' sha'huichinquëma'. Chinoto tahuëri ma'sona co nicacasonta' sha'huichinquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naquëranchin niyontonpiso pëiquë Quisoso ya'conconin. Inaquë apia quënanconin. Imirin tachitërin ni'ton, co nanitërinhuë' së'quëtacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","“Chinoto tahuëri anoyatomara,” ta'tona', parisioro'sari ni'sápi sha'huirapicaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naporo' apia itapon: —Huë'sahuaton, huancánachin huaniquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Inaquë nipachina, piyapi'sa' itapon: —Chinoto tahuëri noya nicacaso' ya'huërin. Co ahuëtacaso', co tëpatacaso', co inapita nicacaso' ya'huërinhuë'. Cania'pi tananpitohuatoso', co nosoroarahuë'. Nipirinhuë', nosoroato anoyata'huaso' ya'huërin, tënahuë caso'. ¿Ma'ta' tënama canpitaso'? itërin. Natanaponaraihuë', co manta' topihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Co a'panitohuachinarahuë', a'naya a'naya ni'sarin. Co natantochináchinhuë' cancantopi ni'ton, no'huirë pochin cancantaton, co noyahuë' ni'nin. “Co nosoropihuë',” ta'ton, pa'pi sëtërin. —Imiran iyasha ihuëquë', itërin. Ihuëhuachina, a'naroáchin noyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisioro'saso' no'huitatona', pipipi. Irotisë piyapinënpita quënanconahuatona', ninontopi Quisoso tëpacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Quisososo' panca sono' yonsanquë paantarin. Ca'tano'sanënpitarë' pa'nin. Na'a piyapi'sari imasapi. A'naquën Cariria parti quëran huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","A'naquëonta' Cotia parti quëran huë'pi. Quirosarin quëran, Itomia quëran, Cortanii' aquëtëran quëran, Tiro quëran, Siton quëran, ina quëranpita hua'huayátërahuë' huë'pi. Quisoso naporinso' natantahuatona', nicapona' huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Na'a piyapi'sa' nani anoyatërin ni'ton, ya'ipi cania'piro'sa' huë'sapi. Na'a piyapi'sa' ni'ton, ya'sëratërarahuatona', huë'sapi Quisoso së'huacaiso marë'. “Së'huahuato, anoyatarinco,” ta'tona', naporapi. Napoaton ca'tano'sanënpita itapon: “Poti amasha quëpaco' inaquë huënsëato a'chinchi. Notohuaro' piyapi ni'ton, ya'quëëtohuachinaco,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sopairo'sari ya'coancantërinsopitanta' huë'pi. Quisoso quënanahuatona', nocotapataquëchin isonquipi. —¡Quëmaso' Yosë hui'ninquën! itopi chiníquën nontatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Inariso nipirinhuë', chiníquën pënënin: “¡Ama piyapi'sa' anohuitocosohuë'!” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ina quëran Quisoso a'na motopia'huaquë paantarin. Nohuantërinsopita përapachina, paapapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na'a a'chintërinsopita ya'huëpirinahuë', shonca cato' quëmapi'sa' huayonahuaton, acorin. “Nani tahuëri iyaro'sa' ca'tanco a'chinchinquëma'. Ina quëran a'pararanquëma' piyapi'sa' pënënacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chiníquën nanan quëchinquëma' sopairo'sa' a'pacamaso marë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Shonca cato' ca'tano'sanënpita acorin. A'naso' Simon. Nisha nininën acotërin. Pitro itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiaco, Coansha, inapitanta' acorin. Sipitio hui'ninpita inahuaso'. Nisha nininën inapitanta' acotaantarin. Poaniquisë itërin. (“Huira pochin,” tapon napotërin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Antërisë, Pinipi, Partoromi, Matio, Tomasë, Tatio, inapitanta' acorin. A'nanta' Santiaco itopi. Arpio hui'nin inaso'. A'na Simonta' acorin. Iráca copirno no'huina'piro'sa' imapirinhuë', iporaso' Quisoso imasarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Cotasë Iscariotinta' acopirinhuë', a'na tahuëri inari sha'huirapiarinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ina quëran a'na pëiquë pa'pi. Naquëranchin notohuaro' piyapi'sari huëcapaiantapi ni'ton, co nanitopihuë' capacaiso tëranta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Quisoso quëmopinënpitari natantahuatona', “Nani hua'yantërin,” topi. Napoaton Quisoso quëpacaiso marë' huëcapaipirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cotio maistro'santa' Quirosarin quëran o'marahuatona', tapona': “Sopai hua'an Piirsipo itopisori ya'coancantërin ni'ton, nani ma'sha nanitaparin. Inari chiníquën nanan quëtërin sopairo'sa' a'pacaso marë',” toconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Quisososo nipirinhuë' piyapi'sa' përasahuaton, pënënto nanan sha'huitërin ayonquicaso marë'. “Sopairo'sa capini co onporonta nia'pacaiso ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ni'co'. Ninanoquë ya'huëpisopita nino'huipi naporini, yanquë'itonahuë'. Co huachi inaquë ya'huë'itonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Quëmopinëna capininta' nino'huipi naporini, inapitanta' yanquë'itonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Inapochachin Satanasë sopairo'sarë' nino'huipi naporini, co huachi hua'anëna niitonhuë'. Co huachi chiníquën nanan ya'huëchitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Quëmapi chiníquën nipachina, pëinën noya a'pairin. Co insonta' nanitërinhuë' ya'conaton ma'shanënpita matacaso'. A'nariso nipirinhuë' ina quëran chini chiníquën ni'ton, huëcapairahuaton minsëirin. Tonporahuaton, ma'shanënpita quiquitërin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Oshanëma marë' sëtohuatama', Yosë ya'ipi oshanëma' inquitarinquëma'. Pinopatama', inanta' inquitarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nipirinhuë', Ispirito Santo pinotoma' oshahuanpatama', ina oshanëmaso' co inquitarinquëmahuë'. Onpopionta' ana'intinquëmaso' ya'huërin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Sopairi ya'coancantërin,” topiso marë' Quisoso napopënëntërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ina quëran a'shin, iinpita, oshinpita, inapita canquiponaraihuë', co ya'conpihuë'. Aipiran huanirahuatona', Quisoso amatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Quisoso ahuancanapitona', tahuishin miáchin huënsëpisopitari sha'huitopi: —Ni'quë' Maistro. Mamaparin, iyaparinpita, oshiparinpita, inapita huëcatona', aipiran huanirapi. Yanontërinënquën, itopirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","—Mamahuë, iyahuëpita, oshihuëpita inapita pochin ni'nahuësopita sha'huichinquëma' nitotoco', itërin. Piyapi'sa' tahuishin miáchin huënsërantapaiso' ni'sarin quëran itantapon: —Isopita imarinaco ni'ton, iyahuëpita, oshihuëpita, mamahuë, inapita pochin nicato nosororahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yosë natëpisopita iyahuëpita pochin ni'nahuë. Sanapi'santa' Yosë nanamën natëhuachina', oshihuëpita pochin ni'nahuë. Payaro'santa' imapachinaco, mamahuë pochin ni'nahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Naquëranchin sono' yonsanquë Quisoso a'chiantararin. Inaquë notohuaro' piyapi'sa' niyontonpi natanacaiso marë'. Hua'huayatërahuë' tancapitohuachinara, potiquë ya'conahuaton, huënsëmarin. Inaquë yanponapirarin. Ya'huërë' piyapi'saso' ii' yonsanquë yamorapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nisha nisha pënënto nanan a'chintarin. Ma pochinsona Yosë nanamën nininso' ayonquicaso marë' a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","A'chintaton, itapon: “Natanco a'chinchinquëma'. A'na quëmapi sha'tapon pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na'a trico pa'sarayarin papotacaso marë'. Pa'sarayahuachina, a'naquën ya'pirin iraquë huarë' anotërin ni'ton, inairaro'sari huëcapairahuatona', pë'yaquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A'naquën ya'pirin na'piroquë pa'sarayarin, pi'pian pi'pian no'pa' ya'huërinquë. Inaquë, shiarahuaton, papotopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pi'iri chiníquën picahuachina, yaahuirin. Pi'pishara'huaya itëhuanin ni'ton, ahuirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A'naquën ya'pirionta' nahuanoquë pa'sarayarin. Inaquë papotopirinhuë', nahuano'santa' papotërin. Shia a'shinahuatona', imotërin. Napoaton co nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A'naquënso nipirinhuë' noyaro'paquë pa'sarayarin. Inaquë noya papotërin. A'shinpachina, sha'nin quëran na'con na'con nitërin. A'naquën ya'pirin cara shonca, cara shonca nitërin. A'naquëonta' saota shonca, saota shonca nitërin. A'naquënso' pasa, pasa nitochanin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Itahuaton: “Huëratëhuanpatama', noya natanatomaco, yonquico',” itaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Niyontonpisopita pa'pachinara, a'naquën imapisopita co pa'pihuë'. Shonca cato' ca'tano'sanënpitarë chachin co pa'pihuë'. “Apira a'chintërancoiso' co noya nitotëraihuë'. ¿Ma'ta' tapon naporan?” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Itohuachinara, Quisosori itapon: “Onpopinsona Yosë hua'anëntërinso' co a'napita nitotopihuë'. Co imarinacohuë' ni'ton, co nitotopirinahuë', canpitaso' carinquëma' a'chinchinquëma'. Yosë nanamën no'tëquën nitotacamaso marë' a'chinchinquëma'. A'napitaso nipirinhuë' pënënto nanan quëransáchin a'chintarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Inapitaso' co yanatërinacohuë' ni'ton, natanaponaraihuë', co natëtapihuë'. Ma'sona ninahuësonta' nicaponaraihuë', co yonquiapihuë'. Imarinaco naporini, oshanëna' inquitahuato anoyacancanchitohuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Naquëranchin Quisosori ca'tano'sanënpita itantapon: “Achin sha'huitëranquëmaso' ¿co nitotëramahuë' ti? Co inaya tëranta' nitotohuatamahuë', ¿onporahuatomacha ya'ipiya nitotërë'pënquëmaya? Carinquëma' nipachin anitochinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tricoraya pa'sarayarëso pochin Yosë nanamën ya'ipi parti a'chinë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A'naquën piyapi'sa' iraquë huarë' pa'sarayarinso pochin nipi. Yosë nanamën natanpirinahuë', a'naroáchin Satanasë huë'nin. Yosë nanamën natanpiso' osërëtiirin. Ama natëcaiso marëhuë' ananiantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","A'naquën piyapi'santa' na'piroquë pa'sarayarinso pochin nipi. Yosë nanamën natanahuatona', a'naroáchin pa'yatatona', natëpirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","co cancanëna quëran huarë' natëpihuë'. Co chiníquën cancantatonahuë', co natëmiatopihuë'. Yosë nanamën yaimapi ni'ton, a'napitari tëhuapi, no'huipi, napotopi. Napohuachinara, Yosë nanamën yaa'popi. Ma'sha onpohuachinara, a'naroáchin nanamën a'popi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A'naquën piyapi'santa' nahuanoquë pa'sarayarinso pochin nipi. Yosë nanamën natanpirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma'sharáchin yonquipi. ‘Na'a coriqui, ma'sha, inapita ya'huëtohuachincoi, noya cancantarai,’ topi. Napoaton nahuano'sari imotërinso pochin, nani ma'sha nohuantatona', Yosë nanamën naniantopi. Co imamiatopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A'naquënso nipirinhuë' noyaro'paquë pa'sarayarinso pochin nipi. Yosë nanamën noya natanpi. Natanahuatona', cancanëna quëran natëpi. Sharo'sa' nisha nisha nitërinso pochin natëtopi. A'naquën ya'pirin cara shonca, cara shonca nitërinso pochin noyamiachin imapi. A'naquëonta' saota shonca, saota shonca nitërinso pochin noya imapi. A'naquënso' pasa, pasa nitërinso pochin ya'ipi cancanëna quëran imatona', noya noya imapi huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Naquëranchin Quisosori itaantarin: “Ni'co' iyaro'sa'. Nanparin i'chinpihuatëra, ¿co i'mëanaquë po'morëhuë' pa'? Co pë'saraanaquë tëranta' acorëhuë'. Nanparin aconanquë acorë' noya a'pinacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iporaso' ma'sha noyá po'opinan pochin ni'ton, co insonta' nitotërinhuë'. A'na tahuëriso nipirinhuë' ya'ipiya nitotapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Huëratëhuanpatama', noya natanatomaco, yonquico',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ina quëran napotaantarin: “Natanpatama', noya yonquico'. Onpopinsona a'napita nitohuatama', inapochachin Yosënta' nitarinquëma'. Aquë aquëtë chachinhuë nipon quëtarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Noya natëhuatama', na'con na'con nitotarama'. A'naquënso nipirinhuë', ‘Nani nitotërahuë,’ topirinahuë', co yanatëpihuë'. Napoaton Yosëri tananpitarin. Inapotohuachina, pi'pian tëranta' nitotopiso', ya'ipiya naniantapi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ina quëran napotaantarin: “Yosë hua'anëntërinso' a'chinchinquëma'. Iminquë sha'tërëso pochin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sha'tërinso piquëran tashihuachina, hua'anën huë'ërin. Tahuërihuachina, huënsëantarin. Nani tahuëri naporárin. Oshaquëran sha'ninso' pichopitahuaton, papotërin. Onporohuatonso' papotërinso' co nitotërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sha'pachina, inaora nohuanton, no'pa quëran papotërin. Nani a'shinpachina, huënsharatërin. Nani huënsharatahuaton, nitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ya'pirin cayahuachina, nani noya macacaso' ni'ton, manin huachi,” tënin. (Inapochachin Yosë nanamën sha'huitohuatëhua', ina nohuanton, oshaquëran a'naquën natëtapi.) ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ina quëran sha'huitantarin: “¿Ma'pochinta' Yosë hua'anëntërinpoaso' ninin? ¿Ma quëranta' nanitërë' ina yonquicaso'? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostasaraya no'paquë sha'nëso pochin ninin. Mostasarayaso' hua'huishin. A'napita ya'pirin quëran pi'pi pi'pishara'huaya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pi'pira'huaya niponahuë', sha'patëra, panca panca papotërin. A'napita sharo'sa quëran panca panca ta'an ninin. Panca së'patohuachina, inairaro'sa' na'iyatona', inaquë pëipi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ina pochin Quisosori piyapi'sa' a'chintarin. Na'a pënënto nanano'sa quëran ayonquiarin. Natantiinpichin a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Napoaponahuë', pënënto nanan quëransáchin a'chintërin. Ina quëran ca'tano'sanënpitaráchin ya'huëhuachinara, oshaquëran a'chintantarin no'tëquën yonquicaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naporo' tahuëri chachin nani tashirarapaso', ca'tano'sanënpita itapon: —Sono aquëtëran pa'ahua', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nani piyapi'sa nontahuaton, Quisoso potiquë ya'comarin. Napohuachina, ca'tano'sanënpitarë chachin pa'pi. Naporo' a'napitanta' nisha potiro'saquë pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Paaquëya', panca ihuani manin. Co'sacairi poti opoto opototahuaton, nani yamëntairapirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ya'huërë Quisososo', huanconënquë motonan motoantahuaton, huë'ë́rarin. Ca'tano'sanënpitari ochinanpi: —¡Catahuacoi Maistro chimiitarihua'! ¿Co ina yonquiranhuë' ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Huanintarahuaton, ihuan a'parin. Sononta' camaiton: —¡Sanoquë'! ¡Copi tëquë huachi! itërin. Itohuachina, ihuan copitënin. A'naroáchin sanoirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—¿Onpoatomata' të'huataramaso'? ¿Co Yosë natëyatëraramahuë' ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pa'pi pa'yanahuatona', ninontopi: —¿Ma quëmapicha isoso' ni'ton, ihuan a'parin nicaya? Sononta' a'naroáchin asanoirin, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ina quëran, sono' aquëtëran Quirasa parti itopiquë canconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Quisoso nani nonshihuachina, a'na quëmapiri na'pi nanin quëran pipirahuaton, nacapirin. Sopairi ya'coancantërin ni'ton, co huachi noya yonquirinhuë'. Hua'yantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na'pi naninquë chimipiro'sa' po'mopiquë ya'huërin. Pa'pi chiníquën ni'ton, co catinaquë tëranta' nanitopihuë' tonpocaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Na'aro' catinaquë tanpaquën tonpotahuatona', pa'on tonpotopirinahuë', oshitërachinin. Co incariso tëranta' nanitërinhuë' minsëcaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nani tashi', nani tahuëri iratárin. Na'pi naninquë, motopiquë inaquëpita pa'sápaton, chiníquën yaitárin. Na'piquë nipë'sharárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Quisoso aquë quëran quënanahuaton, ta'aquirin. Quisoso nocotapataquë isonquirahuaton, mosharin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Napohuachina, Quisosori nosoroaton, a'naroáchin sopai nontërin. —¡Iso quëmapi quëran pipico huachi! itërin. Ina natanahuaton, sopairi chiníquën a'panirin. —¿Ma'ta' yaonpotarancoi? Quëmaso' Quisosonquën, Yosë hui'ninquën ni'ton, chini chiníquën nanantëran. Yosë marë' ama apira aparisitocoisohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Ma'ninquënta' quëmaso'? itërin Quisosori. —Na'acoi ni'toi, “na'a huaranca,” itërinacoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ama a'na parti a'pacoisohuë', tosapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ina ya'cariya notohuaro' coshiro'sa' panënquë coshatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","—A'pacoi coshiro'saquë tëranta' ya'coanta'ii, tosapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Inta nipachin, inaquë paatoma' ya'conconco', itërin. Itohuachina, sopairo'sa' pipirahuatona', coshiro'saquë ya'conconpi. Ina quëran ya'ipi coshiro'sa', cato huaranca pochin nipirinahuë', hua'yantatona' ta'api. Tahuan pa'tatona', sonoquë niitopi. Inapoatona', taquiitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Coshi a'paina'piro'saso' ni'sahuatona', ta'arë'nachin ninanoquë ya'huëpisopita sha'huitonpi. Ninano pirayan ya'huëpisopitanta' a'naya a'naya sha'huitëra'piapi. Natantahuatona', “¿Ma'ta' onpocaiso'?” ta'tona', pa'pi nicapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Quisosoquë canquirahuatona', quëmapi hua'qui' hua'yantërinso' quënanquipi. Nani a'moanaton, noya huënsërarin. Na'a sopairo'sari ya'coancantopirinahuë', noya yonquiantarin. Co huachi hua'yantërinhuë'. Napoaton pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","“Quisosori anoyatërin. Sopairo'sa' a'pahuachina, coshiro'saquë ya'conconpi. Inapohuachinara, tahuan pa'tahuatona', sonoquë taquiitopi huachi,” itopi ni'pisopitari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Natanahuatona', piyapi'sa' të'huatopi: “A'na parti paquë',” itopi Quisoso nontatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Quisoso potiquë ya'conaso', hua'yantërinsoari huëcapairahuaton, itapon: “Canta' imainquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Quisososo nipirinhuë' co nohuantërinhuë'. —Ya'huëranquë iyasha paantaquë'. Quëmopinënpita sha'huitonquë'. “Sinioro noyá anoyatërinco. Na'con nosororinco,” itëquë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Napotohuachina, pa'nin. Ticaporisë parti sha'huira'piarin. “Quisoso nóya anoyatërinco,” itëra'piarin. Natanahuatona', “¡Ma'pitacha sha'huirin paya! ¡Ma noya catahuarin!” topi ya'ipiya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Quisososo' pëntonquiantarahuaton, na'a piyapi'sa' quënanquirin. Sono' yonsanquë huëcapairahuatona', tancapitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Naporo' a'na cotio hua'an Cairo itopiso huë'nin. Inaso', niyontonpiso pëi' hua'an ya'conin. Quisoso quënanquirahuaton, nantën pirayan isonquirin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—¡Hui'nahuë Sinioro, chiminarin! Huëquë'. Së'huaquiton, anoyatoco, chiminpachin, itárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","—Inta nipachin, tosahuaton, imarin. Na'a piyapi'santa' imasapi ni'ton, Quisoso ya'quëëtërapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Paaquëya', a'na sanapiri imaquiarin, hua'qui' panca huënai' a'parinso'. Nani shonca cato' pi'ipi co sanorinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na'a notoro'sari nonënpirinahuë', na'con parisitárin. Nani ya'ipi coriquinën i'quiaponahuë', co manta' noyatërinhuë'. Aquëtë chachin nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Quisoso nahuininso' natantahuaton, pinën quëran imaquiarin. “A'morinso tëranta' së'huahuato, anoyatarinco,” ta'ton, piyapi'sa' ya'sëratërarahuaton, a'morinso' së'huatiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naporo' a'naroáchin huënai' no'narin. Canio quëran nani noyatërin ninatanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Quisososo' co quënanaponahuë', inaora nitotërin. “A'naso' natëtonco, së'huaquirinco. Ca nohuanto noyatërin,” ta'ton, a'naroáchin tahuërëtahuaton, natantërin: —¿Inta' a'morahuëso' së'huatërinco? tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—Ni'quëchi Maistro, notohuaro' piyapi'sa' ya'quëëtapirinënquënhuë', “¿Inta' së'huarinco?” ¿tënan ti? itërin ca'tano'sanënpitari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Itopirinahuë', Quisososo' a'naya a'naya ni'sarin. “¿Inta' së'huarinco?” ta'ton, ni'sárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Napohuachina, sanapiso' “Nani anoyatërinco,” ta'ton, ropa ropátërarin quëran Quisoso huëcapairin. Isonquirahuaton, no'tëquën sha'huitërin. “Hua'qui' caniorahuë ni'ton, së'huaranquën Sinioro. Së'huatënquën, a'naroáchin noyatërahuë huachi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Natëranco ni'ton, nani imoya, anoyatëranquën. Nani noyatëran ni'ton, noya paquë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ina nontaso chachin, Cairo pëinën quëran huë'sahuatona', sha'huitiipi. —Hui'nan nani chiminin huachi. ¿Ma'marëta' topinan quëran Maistro quësaran? itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Quisososo nipirinhuë' piyapi'sa' noninso' natanaponahuë', co ina yonquirinhuë'. —Ama iyasha pa'yanquësohuë'. Natëco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","“Ama a'napitaso' huë'inasohuë',” topachina, Pitro, Santiaco, Coansha, inapitaráchin pa'pi. Coanshaso' Santiaco iin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cairo pëinënquë canconahuatona', na'a piyapi natanconpi. Chiníquën na'nëtona', ayanápi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya'contarahuaton, inapita itapon: —¿Onpoatomata' na'nëtoma', noncaroaramaso'? Co sanapia'hua chimininhuë'. Huë'ësárin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Naporinso' natanahuatona', piyapi'sari tëhuapirinahuë'. Quisosoriso' inapita ocoirahuaton, pa'pin, a'shin, cara ca'tano'sanën, inapitaráchin quëparin. Sanapia'hua ya'huërinquë ya'concontarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Maimirarahuaton, inaora nananquë: —Tarita comi, itërin. “Huënsëquë' apia'hua,” tapon napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A'naroáchin sanapia'hua huënsërahuaton, huanirin. Nani shonca cato' pi'ipitërin ni'ton, noya iratërin. Ina ni'sahuatona', ya'ipi piyapi'sa' pa'pi pa'yanpi. “¡Ma'pítacha nitotaton, ananpitaantarin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Quisososo nipirinhuë', “Ama a'napita sha'huitocosohuë',” itahuaton, “Nanon a'caco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ina quëran pipirahuaton, ya'huërin'pa' paantarin. Ca'tano'sanënpitarinta' imapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chinoto tahuëri nanihuachina, niyontonpiso pëiquë a'chinarin. Na'a piyapi'sari natanahuatona', pa'yanpi. Pa'yanatona', inahua capini ninontapi: —¡Ma'pítacha Quisoso nitotërin paya! ¿Macariso' a'chintomara? Noya noya yonquirin. Piyapi'sa' a'naroáchin anoyatërin. ¿Onporahuatoncha nani ma'sha nanitaparin nicaya? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hua'huatapon quëran huarë' nohuitërëhua'. ¿Co'na nontëcamayo inaso'? A'shinso' Maria itopi. Iinpitanta' nohuitërëhua'. Santiaco, Cosi, Cotasë, Simon, inapita itopi. Oshinpitanta' isëquë canpoarë' ya'huarin. Co Quisoso chiníquën nanantërinhuë'. Canpoa pochachin inanta', ta'tona', “¡Macari natëapon!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Napohuachinara, Quisosori itapon: —Ya'ipi piyapi'sari pënëntona'pi noya natanpi. Ninanonënquë ya'huëpisopitariso nipirinhuë', co noyahuë' natanpi. Quëmopinënpita, huëntonënquë ya'huëpisopita, inapitanta' co noyahuë' ni'pi, topi iráca. No'tëquën napopi, tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Co cancanëna quëran huarë' natëpihuë' ni'ton, co nanitërinhuë' aquëtë huarë' Yosë pochin nicacaso'. Caraíchin cania'piro'sa' së'huarahuaton, anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","“¿Onpoatoncha isopita co yanatërinacohuë' nicaya?” tënin, yonquiapon. Ina quëran ya'cariya ninanoro'saquë pa'sahuaton, piyapi'sa' a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naporahuaton, shonca cato' ca'tano'sanënpita përasahuaton, sha'huitërin paatona' a'chinacaiso marë'. Catoya catoya a'parin. Chiníquën nanan quëtërin sopairo'sa' a'pacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Pa'patama', ama ma'sha quëpacosohuë'. Ama cosharo', pë'pëto, coriqui, inapita tëranta' quëpacosohuë'. Pitanaráchin quëpaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sapatë' po'morahuatoma', a'moramasorë'quëmaráchin paco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Inso pëiquësona yacapatohuatama', ina pëiquëráchin ya'huëco'. Ina ninano quëran pipiamaquë huarë' inaquë ya'huëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A'na ninanoquë ya'huëpisopita no'huitënënquëma': “Ama isëquë huëcosohuë'. Co yanatanainquëmahuë',” itohuachinënquëma', patoco'. Yapa'patama', pënënco': “Nani sha'huitopiranquëmahuë'. Co nohuantëramahuë' ni'quëhuarë' canpitaora tëhuënëmaquë nina'intarama',” itoco'. Tëhuënchachin Yosëri chiníquën ana'intarin huachi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ina quëran ca'tano'sanënpita pa'sahuatona', piyapi'sa' pënëna'piapi: “Ya'ipi co noyahuë' yonquiramasopita naniantatoma', Yosë chachin tahuërëtantaco huachi,” itëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Naporahuatona', na'a piyapi'sa' sopairo'sari ya'coancantërinso inquitopi. Na'a cania'piro'santa' tomaquë pashitatona', anoyatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ya'ipi Quisoso naporinso' nahuinin. Piyapi'sa' natanahuatona', nisha nisha yonquipi. Cariria hua'aonta' natantërin, Irotisë itopiso'. I'huamiáchin inari sontaronënpita camaiton, Coansha Paotista atëpatërin ni'ton, yonquiárin: “Ina quëmapiso' Coansha. I'hua chiminaponahuë', nanpiantarin. Napoaton nani ma'sha nanitaparin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","“Co inahuë'. Iniasë pënëntona'pi ipora,” topi a'naquëonta'. “Co inahuë'. Ninotona'pi iráca ya'huërinso' nimara,” topi a'naquëonta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Irotisëso nipirinhuë', co nisha nisha yonquirinhuë'. —Inaso' tëhuënchachin Coansha. Anishitëconotopirahuë', nanpiantarin, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","I'hua chachin Coansha nanpiso', Irotisë co noyahuë' ninin. Iin sa'in osërëtërin. Pinipi sa'in chachin osërëtaton, manin, Irotiasa itopiso'. Napoaton Coanshari chiníquën pënënin. “Co Yosë nohuantërinhuë' iyaparin sa'in osërëtaton macamaso',” itërin. Napotërinso marë' Irotiasaso' co quëyatonhuë', onpopionta yatëparin. Ina nohuanton hua'anso', sontaro'sa a'parin. Coansha macacaiso marë'. Masahuatona tashinan pëiquë po'mopi. Inapotahuatona, catinaquëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Irotisëriso' Coansha noya natanin. “Nóya quëmapi inaso'. Co oshahuanhuë',” ta'ton, co nohuantërinhuë' atëpatacaso'. Coanshari pënënpachina, nisha nisha yonquiaponahuë', noya natanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ina quëran hua'huatërinso' tahuëri nanihuachina, pita ninin. Na'a piyapi'sa' amatërin. Coisëro'sa', capitano'sa', ma'huano'sa' Caririaquë ya'huëpisopita, inapita amatërin. Naporo' tahuëri Irotiasa chinotërin Coansha atëpatacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Coshatasoi', hua'huin ya'conahuaton, nansararin. Nanon nansarinso' ni'sahuatona', ya'ipiya quëran pa'yatopi. Hua'an mashorinta' pa'yatërin. —Ma'sona nohuantëranso' apia'hua, nico quëchinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yoscoarë' quëchinquën. Ma'sona tëranta' nipatanco, quëtaranquën. Pancana no'pa' hua'anëntërahuë. Patomaquë huarë' quëtaranquën, itërin hua'ani na'aro nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Napotápachina, a'shin paahuarin. —¿Ma'ta' mama ma'pai? itoonin. —“Coansha nishitëconotahuaton, motën quëtoco,” itëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Manorahuaton, hua'an ya'huërinquë paantarin. —Coansha motën nohuantërahuë. Sënanquë acorahuaton, apiramiáchin quëtoco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ina natanahuaton, hua'an pa'pi sëtërin. Napoaponahuë', “Ya'ipi piyapi'sa' nataninaco, Yoscoarë' itërahuë,” ta'ton, co yanonpintërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ina quëran sontaro sha'huitahuaton, a'parin Coansha motën macacaso marë'. Inaso pa'sahuaton, tashinan pëiquë nishitëconotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sënanquë motën acorahuaton, nanon quëtërin. Nanonta' a'shin quëtonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Imarinsopitaso', natantahuatona huë'pi. Nonën quëparahuatona', pa'pitopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ina quëran ca'tano'sanënpita huëantarahuatona', Quisoso sha'huitiipi. “Nani a'chintëra'piarai. Cania'piro'santa' anoyatërai. Noya natanpi,” itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na'a piyapi'sa' huë'sapi Quisoso nicapona'. Ina quëran paantapi. A'napita ya'huërë' huëantapi, ina quëran paantapi. Naporápi ni'ton, Quisoso ca'tano'sanënpitarë chachin co capacaiso tëranta' nanitopihuë'. —Huëco' iyaro'sa'. Co piyapi ya'huërinquëhuë' pa'ahua'. Pi'pian chinotahua', itërin ca'tano'sanënpita. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Itohuachina, potiquë ya'conahuatona', pa'pi. Co piyapi ya'huërinquëhuë' pa'sapirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pa'pachinara, na'a piyapi'sari notëërapi. Quisoso nohuitahuatona', na'a paahuapi. Nisha nisha ninano quëran pa'pi. Ira pa'tatona', ta'arahuatona', inahua'ton canconpi. Co'huara Quisoso canshátërasohuë', canconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na'a piyapi'sa' yamorapi. Nonshirahuaton, Quisosori quënanconin. “Isopitaso' ohuicaro'sa' co macari a'pairinsohuë pochin nisapi,” ta'ton, nosororin. Nosoroaton, na'con a'chintaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nani i'huararahuaso', ca'tano'sanënpitari Quisoso huëcapairahuatona', itopi: —Nani Maistro i'huarin. Co manta' isëquë ya'huërinhuë' ni'ton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","piyapi'sa' a'paquë' pa'ina'. Isosha'huaya pëiro'sa' ya'huërin. Ninanoro'santa' co aquëyahuë'. Inatohua' cosharo' pa'anatona', ca'ina', itopirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Canpitari a'caco', itërin Quisosori. —Cato pasa tahuëri sacatatë' coriqui canarëso pochin nininquë pan pa'anahuatoi, ¿a'ca'ii ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Onpo panta' ya'huëtërinquëma'? Paatoma', ni'conco', itërin. Pa'sahuatona', ni'conpi. —A'natërapoya pan, catoyachin sami, inaíchin ya'huëtërincoi, itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Itohuachinara, piyapi'sa' sha'huitërin pastoquë huënsëcaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A'naquën a'natërápo shonca, a'natërápo shonca, a'naquën pasa, pasa huënsëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ina quëran a'natërapoya pan, catoya sami, inapita ma'parin. Inápaquë në'pëtahuaton, Yosë nontërin. “Yosparinquën, Tata,” itahuaton, pan së'panin. Ina quëran ca'tano'sanënpita quëtërin piyapi'sa' quëtacaiso marë'. Sami së'paninsonta' quëtëra'piapi. Inaíchin nipirinhuë', ya'ipi piyapi ananitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ya'ipi piyapi'sa' natëaquë huarë' coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ina quëran pan, sami, inapita pë'sotopiso' maantapi. Shonca cato' i'më' amëntatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A'natërápo huaranca quëmapi'sa' naporo' coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ina quëran ca'tano'sanënpita itapon: “Potiquë ya'conahuatoma', aquëtëran paco'. Apira canta' pa'sarahuë. Pitsaita'pa' pa'ahua',” itërin. Ca'tano'sanënpita nani pa'pachinara, piyapi'sa' nontarin ya'huëpi'pa' paacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nani nontohuachina, inaora pa'nin a'na motopia'huayaquë Yosë nontacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tashihuachina, ca'tano'sanënpitaso' potiquë pa'sapirinahuë', sono' huáncoanai' tashitopi. Quisososo' inaoraíchin quëparitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ca'tano'sanënpita ya'ipi tashi' maitopirinahuë'. Ihuan nacapiatona', co nanitopihuë' chiníquën pacacaiso'. Canotopi huachi. Ina ni'sahuaton, co tahuëriyátërasohuë', Quisoso pa'nin. I aipi i'narahuaton, no'pa pochin pa'tarin. Poti nani icantaponahuë', na'huëtatë pochin nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","I aipi pa'sarinso' quënanahuatona', pa'yanpi. “Hua'yan” ta'tona', “ëë” topirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ya'ipiya quëran ni'sahuatona', të'huatopi. Nipirinhuë', a'naroáchin Quisosori itërin: —Co'ta ca huë'sarahuë. Ama pa'yancosohuë'. Chiníquën cancantoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ina quëran potiquë ya'conapatërin. Ya'conpachina, ihuan sanorin huachi. Ca'tano'sanënpita pa'yanpi: “¿Onporahuatoncha nanitaparin nicaya?” topi yonquiatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nani pan ana'atërinso' nicaponaraihuë', co ina yonquipihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aquëtëran canconahuatona', Quinisariti parti nonshipi. Yonsanquë poti a'sonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nonshiaso chachin, a'naroáchin piyapi'sari Quisoso nohuitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Manorahuatona', ya'ipi ina parti pa'sahuatona', pëiro'saquë pa'pi. Na'a cania'piro'sa' pë'sara'huayaquë quëpi anoyatacaso marë'. “Pasëquë Quisoso ya'huarin,” itohuachinara, inaquë quëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Intohuaso tëranta' Quisoso pa'pachina, inatohua' cania'piro'sa' quëparapi. Nisha nisha ninanoquë pa'sarin. A'naquën pancana. A'naquën caraíchin piyapi ya'huëpirinhuë', insëquësona pa'pachina, cachiquë cania'piro'sa' acopi. “Quëma a'moranso' huirotën tëranta' së'huatona', noyachina',” tosapi. “Inta nipachin, së'huaina',” topachina, së'huapi. Insoarisona së'huahuachina', a'naroáchin noyatopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ina quëran a'naquën parisioro'sa', cotio maistro'sa', inapita Quirosarin quëran o'mapi Quisoso natanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","3","Quisoso ca'tano'sanënpita coshatasoi', quënanquipi. A'naquën co niopoimirataponaraihuë' coshatapi. Parisioro'saso' co'huara coshachatëraponahuë', pi'pian i'shaquë niopoimiratopi. Ya'ipi cotioro'sa' ina pochin yonquipi. “Co inapohuatëhuahuë', oshahuanarihua',” tëcatona' napopi. Shimashonëna' inachintopiso' ni'ton, inapopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mircatoquë pa'pi quëran yacoshatohuachinara, i'quë niopoimiratopi. Na'a nisha nisha inachintopisopita ya'huëtopi. Minëro'sa', i'sha ta'painano'sa', hua'na yonsharo'sa', pë'sararo'sa', inapita pa'mopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Napoaton parisioro'sa', cotio maistro'sa' inapitari Quisoso natanpi. —¿Onpoatonta' Maistro quëma a'chintëransopitaso', co niopoimirataponaraihuë' coshatapi? Shimashonënpoa' inachintopirinahuë', inahuaso' co napopihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","—Co no'tëquën iyaro'sa' yonquiramahuë'. “Yosë imarai,” topiramahuë', co imaramahuë'. Canpitaso' nonpintënquëma'. Iráca Yosë quiricanënquë Isaiasë no'tëquën ninorinquëma': “Isopita piyapi'saso' nanamëna quëran noya nontopirinacohuë', co cancanëna quëran imarinacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‘Yosë pënëntërinso' a'chinarai,’ topirinahuë', inahuara yonquipiso' nia'chintapi. Napoaton topinan quëran chinotërinaco,” tënin Yosë. Iráca Isaiasë ninshitaton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Inapochachin canpitanta' Yosë pënëninpoaso' naniantahuatoma', piyapi'sa' a'chinpiso' natërama huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Naquëranchin itantarin: —Tehuënchachin Yosë pënëntërinso' a'porama' shimashonëma' napopiso' natëcamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ni'co'. Moisësë iráca pënëntaton, naporin: “Tatama', mamama', inapita noya natëtoma', catahuaco'. Inso tëranta pa'pina', a'shina' inapita co noyahuë yonquirapitona' no'huihuachina', tëpaco',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Canpitaso nipirinhuë' nisha a'chinama'. A'chinatoma', naporama': “A'naquën nanitërin pa'pina', a'shina' apiratacaso'. ‘Ma'sha ya'huëtërincoso' nani acorahuë Yosë quëta'huaso marë',’ topatëra, co tatama', mamama' inapita quëtacaso' ya'huërinhuë',” toconama'. Napoaton tatama', mamama' inapita ma'sha pahuantohuachinara, apiratatoma', co quëtëramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“Co quëtacaso' ya'huërinhuë',” toconatoma', co catahuaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ina pochin nia'chintatoma', co Yosë quiricanën natëramahuë'. Hui'namapitanta' a'chintërama' inapochachin nicacaiso marë'. Inapochachin pochin na'con nisha nisha nia'chintërama', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naquëranchin piyapi'sa' përasahuaton, a'chintantarin. —Ya'ipinquëma' natanco no'tëquën yonquicamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Co manta' ma'sha ya'huërinhuë' nonënpoaquë ya'conahuaton, aoshahuaninpoaso'. Cancanënpoa quëran pipirinso' tëhuënchinso' aoshahuaninpoa'.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Huëratëhuanpatama', noya natanatomaco, yonquico', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nani a'chintohuachina, piyapi'sa' patahuaton, pëiquë ya'conconin. Ca'tano'sanënpitanta' ya'conpi. Nani ya'conpachinara: “Achin naporanso' co nitotëraihuë'. ¿Ma'ta' tapon naporan?” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","—¿Co canpita tëranta' nitochátëraramahuë' ti? Inta nipachin, a'chintanta'inquëma'. Nani ma'sha ca'nëhuaso marë' co ina marë' oshahuanëhuahuë'. Co cosharo' cancanënpoaquë ya'coninhuë'. Chi'chirinamënpoaquë ya'conin. Ina quëran inquiantarë'. Napoaton ya'ipi cosharo' noya capacaso'. Coshatërëhuaso marë' co oshahuanëhuahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ina quëran itaantarin: —Cancanëma quëran co noyahuë' yonquihuatamara, co noyahuë' ninama'. Ina marë' oshahuanama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Acopo' cancanëma quëran co noyahuë' yonquiramasopita pipirin. Co noyahuë' yonquihuatama', monshihuanama', ihuatërama', tëpatërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nitëhuananpitërama'. Pa'yatacasoráchin cancantërama'. A'napita ma'shanën noyaparama'. Co noyahuë' ninama'. Nonpinama'. Nisha nisha co noyahuë' ninamaso' co yaa'poramahuë'. Apirarama'. Pinotërama'. “Caso' co a'napita pochincohuë'. Noya noyaco,” toconama'. Co yonquinahuanhuë' ninama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Co noyahuë' yonquihuatamara, ina pochin ninama'. Ina marë' oshahuanama', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ina quëran pipirahuaton, nisha piyapi'sa' ya'huëpiquë pa'nin. Tiro, Siton, inapita ya'cariya paaton, a'na pëiquë ya'conconin. “Ama isëquë huë'nahuëso' a'napita sha'huitocosohuë',” itopirinhuë', a'naroáchin ya'ipi nahuinin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Inaquë a'na sanapi ya'huërin. Co cotio sanapihuë'. Nisha piyapi. Siropinisia parti hua'huatërin. Hua'huinso' parisitárin. Sopairi ya'coancantërin ni'ton, co inaora yonquirinso' yonquirinhuë'. Quisoso huë'ninso' natantahuaton, paaparin. Paaparahuaton, Quisoso nantën pirayan isonconin. —Hua'huahuë Sinioro parisitárin. Sopairi ya'coancantaton, chiníquën aparisitarin. Inquitoco, topirahuë', itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—Ni'quë' imoya. Hua'huaro'sa' a'cahuatëra, co cosharonën osërëtahuatë', ni'nira a'carëhuë'. Hua'huaro'sa'ton coshachin noya natëaquë huarë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Naporin mini Sinioro. Napoaponahuë', hua'huaro'sa' pi'pian tëranta' atatohuachinara, ni'niraro'sarinta' capitërin ni'ton, quiyanta' catahuacoi topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—¡Naporinchi paya! Ma noya natëranco ni'ton, ya'huëran'pa' paantaquë'. Nani sopai hua'huan quëran pipirin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sanapiso pëinënquë canconahuaton, hua'huin noya quëhuëánin quënanconin. Nani sopai pipirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Quisoso Tiro quëran pipirahuaton, Sitontaquëchin na'huërin. Ina quëran Ticaporisëquë canquirin. Inaso no'pa' Cariria sono yonsanquë ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Inaquë a'nara apia quëpi Quisosori anoyatacaso marë'. Noyá në'huërin. Naporahuaton, pa'pi icotë' ninin. “Iso quëmapi së'huaquë' noyachin topiraihuë',” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Napotohuachinara, apiaráchin amashamiachin quëparin. Quëparahuaton, imirin quëran icarahuëratërin. Ina quëran niipiimiratahuaton, nënërain së'huatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Inápaquë në'pëtahuaton, sëtërin quëran panca nii o'huarin. Ina quëran Yosë nontahuaton: “¡Ipata!” itërin. “¡Në'huëranso' inquiquë'!” tapon napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Naporo' në'huërinso' inquirin huachi. Nënërionta' noyatahuaton, noya nonin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Quisosori piyapi'sa' pënënin: “Ama a'napita sha'huitocosohuë',” itërin. Itopirinhuë', piyapi'saso' pa'sahuatona', sha'huira'piapi. Na'con na'con pënënpirinhuë', aquë aquëtë huarë' sha'huira'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","“¡Ma'pitacha Quisoso nitotërin paya! Në'huëro'sa' anoyatohuachina, noya natantopi huachi. Co nonpirinahuënta', a'naroáchin anoyatërin ni'ton, noya nonsapi. ¡Ya'ipichi noya ninin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naporo' tahuëri'sa' na'a piyapi'sa' niyontoantapi. Capa cosharo' nipachina, Quisosori ca'tano'sanënpita përarin. Huë'pachinara, itërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Piyapi'sa' nosororahuë. Nani cara tahuëri natanarinaco ni'ton, co huachi manta' cosharo' ya'huëtopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A'naquën áquë quëran huë'pi ni'ton, co topinan yaa'parahuë' tanari canahuachina', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Capa pëiro'sa' isëquë. Notohuaro' piyapi'sa' ya'huapi. ¿Onpotahuatëcha isonapo' piyapi a'carë paya? itopi ca'tano'sanënpitari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Napotohuachinara, Quisosori natanin: —¿Onpo panta' ya'huëtërinquëma'? itohuachina: —Canchisëyachin ya'huëtërincoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ina quëran piyapi'sa' sha'huitërin no'paquë huënsëcaiso'. Nani huënsëhuachinara, pan ma'patërin. “Yosparinquën, Tata,” itahuaton, pan së'panin huachi. Së'panahuaton, ca'tano'sanënpita quëtërin piyapi'sa' quëtacaiso marë'. Ya'ipi piyapi'sa' quëtëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Caraíchin saminta' ya'huëtopi. Ina marënta' “Yosparinquën Tata,” itahuaton, ca'tano'sanënpita sha'huitërin piyapi'sa' quëtacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nani quëtohuachinara, natëaquë huarë' coshatopi. Pë'sotopisonta' masahuatona', canchisë i'më' amëntatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Catapini huaranca piyapi'sa' pochin coshatopi. Nani coshatohuachinara, piyapi'sa' nontërin pacacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nani nontohuachina, potiquë ya'conin. Ca'tano'sanënpitarë' pa'sahuatona', Tarmanota parti chinpiconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Inaquë parisioro'sa' huë'sahuatona', Quisoso nontiipi atëhuëcaiso marë'. “Yosë a'paimahuachinquën, sacai' nininso' niquë' quiyanta' nicatëinquën natëiinquën,” itopirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chiníquën sëtaton, itapon: —¿Ma'marëta' yani'nama'? “Sacai' nininso' niquë' ni'iinquën,” itopiramacohuë', co Yosë nohuantërinhuë' a'nota'huanquëmaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ina quëran potiquë ya'coantarahuaton, aquëtëran paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pëntonpirinahuë', ca'tano'sanënpita naniantopi cosharo' quëpacaiso'. A'naíchin pan potiquë ya'huëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Quisosoriso nipirinhuë' pënënarin: —Ni'cona iyaro'sa'. Pan ahuëpocatërinso pochin parisioro'sa' ya'huëtopi. Irotisë imapisopitanta' ya'huëtopi. Ama iyaro'sa' ina nohuantocosohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Natanahuatona', ca'tano'sanënpita capini ninontapi. “Capa pan. Co ya'huëtërinpoahuë'. Napoaton naponontërinpoa',” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ninontopiso' nitotaton, Quisosori itapon: —¿Onpoatonta “capa pan,” toconama'? ¿A'chintápiranquëmahuë', co ipora huanta' yonquiyátëramahuë ti? ¿Co natantochináchinhuë' cancantërama' nica? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Noya natanapomarahuë', ¿onpoatomata' co yonquiramahuë'? Nicapomarahuë', ¿onpoatomata co natëtëramahuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","I'hua chachin a'natërapoíchin pan nipirinhuë', a'natërápo huaranca piyapi'sa' ananitërahuë. ¿Onpo i'mëta' naporo' pë'sotopiso' amëntatërama'? itërin. —Shonca cato' i'më', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Panso' canchisëíchin nipirinhuë', catapini huaranca piyapi ananitahuato, ¿onpo i'mëta' pë'sotopiso'? itaantarin. —Canchisë i'më', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Napoaton co pan yonquiato, pënënaranquëmaso', ¿Co nitochátëraramahuë' ti? itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ina quëran Pitsaitaquë chinpiconpi. Inaquë somaraya nininso' Quisosoquë quëpi. “Së'huaquë' Sinioro noyachin,” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Itohuachinara, maimirarahuaton, ninano aipiran quëparin. Iroiquë pashirayatërin. Nani së'huarayarahuaton: —¿Ma'ta' iyasha quënanan? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","—Piyapi ni'pirahuë', co a'ninquëchin ni'nahuë'. Pa'sapirinahuë', nararo'sa pochin ni'nahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Naquëranchin së'huarayantahuachina, noya ni'tërin. Nani noyatërin ni'ton, ya'ipi a'ninquëchin quënanin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","—Ya'huëran'pa' iyasha no'tëëquë'. Ama ninanoquë paquësohuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ina quëran Quisoso paantarahuaton, Sisaria Pinipi parti pa'sarin nisha nisha ninanoquë a'chinacaso marë'. Papon pochin, ca'tano'sanënpita itapon: —Nani ma'sha nanitaparahuë ni'to, ¿in pochinta piyapi'sa' cancantiarinaco? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Nisha nisha yonquirapirinënquën. “Coansha Paotistaco' nanpiantarinso' ni'ton, naporin,” topi a'naquën. “Co inahuë'. Iniasëco' nanpiantamara,” topi a'naquëonta'. “Ninotona'pi iráca chiminpirinhuë', nanpiantarinso' nimara,” topi a'napitanta', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Canpitaso nipirinhuë', ¿ma'ta' yonquirama'? itërin. —Quëmaso' Cristo, Yosë chachin a'paimarinquën, itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Ama ina a'napita sha'huitocosohuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Naporo quëra huarë' chiminacaso' ninoton, ca'tano'sanënpita sha'huitërin. —Yosë quëran quëmapico niporahuë', na'con parisita'huaso' ya'huërin. Cotio ansiano'sa', corto hua'ano'sa', cotio maistro'sa', inapita co huachi nohuantarinacohuë'. Tëpararinaco. Chiminaporahuë', cara tahuëri quëran nanpiantarahuë, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","No'tëquën sha'huitochinarin. Ina natanahuaton, Pitrori amashamiachin quëparahuaton: —¡Ama, Sinioro, napoquësohuë'! itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Quisososo nipirinhuë' tahuërërahuaton, ya'ipi ca'tano'sanënpita ni'sarin. —¡Ta'tëquë' iyasha! Sopai nohuanton, napotëranco. Co Yosë pochin yonquiranhuë'. Piyapinquën ni'ton, quëmaora nohuantëransoachin yonquiran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na'a piyapi'sa' ya'cariya huaniapi. —Amashamiachin huëco' iyaro'sa', a'chinchinquëma', itohuachina, huë'pi natanacaiso marë'. Ca'tano'sanënpitanta' natanapi. —Yaimapatamaco, canpitaora nohuantëramaso' naniantoco'. Yosë nohuantërinsoráchin imaco huachi. Corosëquë chiníquën parisitërë'. Inapochachin canpitanta' parisitapomarahuë', imamiatoco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Noya nanpicamasoráchin yonquihuatama', topinan quëran nanpiarama'. A'na tahuëri chiminpatama', parisitomiatarama'. Nipirinhuë', casáchin yonquihuatamaco, noya nanan a'chinamaso marë' parisitapomarahuë', co topinan quëran nanpiaramahuë'. Yosë'pa' nanpimiatarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ya'ipi ma'sha isoro'paquë canapiramahuë', co hua'yanëma' cha'ëpachinhuë', topinan quëran napoarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¡Onponta' pahuërëtapiramahuë', co huachi hua'yanëma' nanitarinhuë' cha'ëcaso'! ");
INSERT INTO cbtNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ipora tahuëri'sa' ya'huëpisopita co noyahuë' nipi. Nitëhuananpitopisopita pochin cancantopi. Tapayatomaco a'pohuatamaco, a'na tahuëri carimanta' tapayatënquëma', a'poaranquëma'. Nanamëhuë a'pohuatama', carimanta' o'mantahuato, a'poaranquëma'. Yosë quëran quëmapico ni'to, a'na tahuëri o'mantararahuë. Tatahuë pochin huënaratahuato, noya anquëniro'sapitaro'co o'mantararahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ina quëran itaantarin: —Tëhuënchachin iyaro'sa' Yosë isoro'pa' hua'anëntapon. Chiníquën nanantaton hua'anëntapon, ni'sarama'. A'naquëma' co'huara chimiyantërasënquëmahuë', ni'sarama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Saota tahuëri quëran Quisoso motopiquë pa'nin. Pitro, Santiaco, Coansha, inapitaráchin quëparin. Inapita nicasoi', nisha pochin ya'norin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A'morinso' huënaráchin huënaráchin ninin. Co inso tëranta' nanitërinhuë' pë'sainaton, ina pochin huiríchin acocaso'. Huiri huiríchin inaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A'nanaya Iniasë, Moisësë, inapita quënanpi. Iráca ayapirinahuë', Yosë nohuanton ya'noantapi. Quisosorë' ninontapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ina ni'sahuatona', Pitro, Santiaco, Coansha, cara chachin pa'yanpi. Na'con pa'yanaton, Pitrori itapon: —¡Ma noyacha Maistro isëquë huë'nëhua paya! Cara imënamëa'huaya nii, topirahuë', a'nara' quëma marë', a'nanta' Moisësë marë', a'nanta' Iniasë marë', itërin. Napoaponahuë', co yonquiatonhuë' naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naporo' chitorori imotërin. Chitoro' huáncana quëran Yosëri sha'huitërinso' natanpi. “Isoso' ca hui'nahuë, na'con nosororahuëso'. Ina natanco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Napotaso chachin ca'tano'sanënpitari ni'sapirinahuë', co a'napitaso' quënanpihuë'. Quisosoráchin quënanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Motopi quëran nohuaramapona pochin, Quisosori itërin: “Achin ni'namaso' ama insonta' sha'huitocosohuë'. Yosë quëran quëmapico ni'to, a'na tahuëri nanpiantarahuë. Naporo huarë' a'napita sha'huitoco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Napoaton co insonta' sha'huitopihuë'. Inahua capini ninontapi. “¿Onporahuatonta' nanpiantaponso'?” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Achin Iniasë quënanpi ni'ton, inanta' yonquiapi. —Pi'pian Sinioro yanatanainquën. Cotio maistro'sa' Yosë quiricanën a'chinpachinara, napopi: “Co'huara Cristo o'mayatërasohuë', Iniasë'ton huëantarin,” topi. ¿Onpoatonta' napopi? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","—No'tëquën napopi. “Yosë nanamën ayonquiantacaso marë' huëantapon,” tënin pënëntona'pi. Naporinso chachin. Nani mini huëantapirinhuë', co nohuitopihuë'. Co yanatanatonahuë', inahuara yonquinëna quëran no'huipi. Yosë quiricanënquë naporinso chachin nitopi. Canta' Yosë quëran quëmapico niporahuë', inapochachin no'huiarinaco. Aparisitarinaco. Yosë quiricanënquë iráca ninorin ni'ton, parisita'huaso' ya'huërin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ina quëran motopi quëran nohuaraimarahuatona', a'napita ca'tano'sanënpita quënanquimantapi. Cotio maistro'sarë' chiníquën ninontapi. Na'a piyapi'sa' yamorapi ni'quimapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Quisoso quënanahuatona' ya'ipiya quëran ta'arë'nachin nacapipi. Pa'yatatona: “I'huata Maistro,” itoonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ina quëran Quisosori natanin: —¿Ma'ta' ninontapiramahuë'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A'na quëmapiri itapon: —Hui'nahuë Maistro quënahuë, anoyatoco topirahuë'. Sopairi ya'coancantërin ni'ton, co huachi nanitërinhuë' nonacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Insëquësona sopairi mapachina, no'paquë nitë'yatahuaton, sa'po sa'po niconin. Ninaquërarahuaton, pacororárin. Ca'tano'sanënpita natanpirahuë' inquitacaiso marë', co nanitopihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—¡Ma'huantacha ninama paya! Canpitaso' co Yosë natëramahuë'. Co natantochináchinhuë' cancantërama'. Nani hua'qui' a'chintopiranquëmahuë', ¿onporo huarëta' yanatëramaco? Hua'huasha quëshico, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Napohuachina, quëshipi. Quisoso quënanahuaton, sopai no'huitaton, hua'huasha ahua'yantërin. No'paquë atatahuaton, asocoro asocorotarin. Sa'po sa'po niconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Onporo quëran huarëta' hui'nan naporin? itërin. —Hua'huatapon quëra huarë' naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na'aro' pënquë sopairi të'yatërin. I'quënta' të'yaitërin tëpacaso marë'. Nosorocoi, Sinioro. Nanitohuatan, anoyatëquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—“Nanitohuatan,” ¿itëranco ti? Yosë natëhuatëra, ya'ipiya nanitaparë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","—Tëhuënchachin Sinioro natëpiranquënhuë'. ¡Catahuaco noya noya natëinquën! itaantarin pa'pini. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na'a piyapi'sa' niyontonquirapi ni'sahuaton, a'naroáchin sopai itapon: —Quëmaso' sopainquën. Piyapi ya'coancantohuatana, anë'huëran. Napoaton carinquën napotaranquën. Iso hua'huasha quëran pipirahuaton, ama huachi onporonta' ya'coancantantaquësohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Napotohuachina, Sopai chiníquën “yai” tahuaton, hua'huasha ahua'yantaantarin. Inapotahuaton, chimipi pochin patërin. Napoaton: “Nani chiminin,” topirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Quisosori maimirarahuaton, opatohuachina, huanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ina quëran Quisososo' ca'tano'sanënpitarëachin pëiquë ya'conconpi. —¿Onpoatonta' Maistro quiyariso' co nanitëraihuë' inquita'huaiso'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Isanpi sopaiso', sacai' inquitacaso'. Chiníquën Yosë nontaquë huarë', inquitërë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ina quëran paantarahuatona', Cariria parti pa'sapi. “Ama huë'nahuëso' piyapi'sa sha'huitocosohuë',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ina quëran ca'tano'sanënpita a'chintaton, napotërin: —Yosë quëran quëmapico nipirahuë', piyapi'sa' masarinaco. Sha'huirapihuachinco, masarinaco. Mapachinaco, tëpararinaco. Chiminaporahuë', cara tahuëri quëran nanpiantarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Natanaponaraihuë', co natëtacaiso' nanitopihuë'. “¿Onpoatonta' ina pochin nontërinpoa'?” topi yonquinëna quëran. Naporahuaton të'huatatona', co nohuantopihuë' natanacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ina quëran Capinaomoquë canconpi. Pëiquë ya'conpachinara, ca'tano'sanënpita itapon: —¿Ma'ta' iraquë huëcapoma pochin ninontëriarama'? itohuachina, ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","co manta' topihuë'. “¿Inquënpoacha ipora chini chiníquën nanantarihua nicaya?” nitopi ni'ton, co yasha'huitopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Napoaton inaquë huënsërahuaton: —Huëco' iyaro'sa' shonca catonquëma chachin natanquico pënëinquëma'. Inquëmasona' chini chiníquën nanantamaso' nohuantohuatama', topinan piyapi pochin cancantatoma', ya'ipi piyapi'sa' catahuaco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ina quëran hua'huasha maimirarahuaton, huancánachin ahuanirin. Ina iporahuaton, ca'tano'sanënpita itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ca imaramaco ni'ton, hua'huasha tëranta' nosorohuatama', nosoroaramaco canta'. Nosorohuatamaco, co casáchin nosoroaramacohuë'. Yosënta' nosoroarama'. Inaso' isoro'paquë a'paimarinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A'na tahuëri Coanshari itapon: —A'na quëmapi, Maistro, ni'nai. “Quisoso nanan quëtërinco,” ta'ton, sopairo'sa' a'pararin. Inaso nipirinhuë', co quiya pochin imarinquënhuë' ni'ton, co nohuantëraihuë'. “Ama inapotëquësohuë',” itërai, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Tananpitoco' iyaro'sa'. “Quisoso nanan quëtërinco,” ta'ton piyapi anoyatohuachina, inaso' noya. Co sha'huirapiincoso' nanitaponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Insosona co inimicotohuachinpoahuë', catahuarinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Caso Cristoco. Imaramacoso marë' piyapi catahuahuachinquëma', Yosë nitotërin. I'sha tëranta' o'shitohuachinënquëma', ina marë' a'na tahuëri acanaarin. Tëhuënchachin noya i'huërëtarin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ina quëran itaantarin: “Hua'huasha natërincoso' anishacancantohuatama', Yosë chiníquën ana'intarinquëma'. A'naquëonta' imasapirinacohuë', co chiníquën cancanchatërapihuë'. Inapitanta' anishacancantohuatama', Yosë ana'intarinquëma'. Co'huara inapita anishacancanchatërapomahuë', pancara'piquë a'sonconotahuatënënquëma', marëquë të'yaitërinënquëma' naporini, noya noya niitomahuë'. Piyapi anishacancantacaso', pa'pi co noyahuë' tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma'sona tëranta' iyaro'sa' anishacancantohuachinquëma', a'poco'. Iso pochin yonquico'. A'na imirama quëran co noyahuë' nipatama', oshahuanama'. Ninishitëimiratërama' naporini, tantoimiraya nipomarahuë', Yosë'pa' pa'itomahuë'. Cato imirarë'quëma chachin parisitopiquë pa'patamaso', pa'pi co noyahuë' nisarama'. Inaquëso' pën co onporonta' tacopiarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nantëma' ya'huëtërinquëma' iratacaso marë'. Nipirinhuë', ma'sona marë tëranta' co noyahuë' yonquiatoma', iratohuatama', na'con oshahuanama'. Ninishitërantëtërama' naporini, noya noya niitonhuë'. Tantorantë' nipomarahuë', Yosë'pa' pa'itomahuë'. Catorantërë'quëma chachin parisitopiquë pa'patamaso', pa'pi co noyahuë' niitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ya'piramanta' ya'huëtërinquëma' noya ni'tacaso marë'. Nipirinhuë', ya'pirama quëran quënanatoma' co noyahuë' yonquihuatama', oshahuanarama'. Ya'pirama' ocoirama' naporini, a'na quëran somaraya nipomarahuë', Yosë hua'anëntërinquë pa'itomahuë'. Cato quëran chachin ni'tapomarahuë', parisitopiquë të'yatohuachinquëma', pa'pi co noyahuë' nisarama'. Ma'sona tëranta' anishacancantohuachinquëma', a'naroáchin naniantoco' ama parisitopiquë paacamaso marëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Inaquë chiníquën parisitápoma'. Co shonaro'sa tëranta' chiminaponhuë'. Pën co onporonta' tacopirarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pënquë ahuiquitërëso pochin Yosëri ya'ipi piyapi'sa' tëniarin noya noya cancantacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yamora noya acashicaso' niponahuë', chiminpachina co huachi noyatërinhuë'. Canpitaso nipirinhuë', yamora cosharo' noya acashirinso pochin nico'. Noya nini'toma', ya'huëco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capinaomo quëran pipirahuaton, Cotia parti paantarin. Naporahuaton, Cortanii' aquëtëran pa'nin. Inaquë naquëranchin na'a piyapi'sari huëcapaipi. Quisosori a'chintantarin. Nani tahuëri huë'pachinara, noya a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisioro'santa' Quisoso ya'carirahuatona', atëhuëcaiso marë' natanquipi: —¿Noya ipora sa'anpo' të'yatacaso' ti? itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Ma'ta' iráca Moisësë pënëntërin? itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—“Sa'anpo' yatë'yatohuatëra, coisëquë aninshitërë': ‘Nani sa'ahuë të'yatarahuë,’ ta'caso' aninshitërë'. Ina quëran noya të'yatacaso huachi,” tënin Moisësë, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Co të'yatacaso' pënëninquëmahuë'. Canpitaso' co natantochináchinhuë' cancantërama' ni'ton, Moisësë napopënëninquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Napoaponahuë' ya'nan piyapi nicapon, cato' piyapiíchin Yosëri ninin. A'na quëmapi, a'na sanapi, inaíchin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Napoaton quëmapi sa'apachin, pa'pin, a'shin, inapita patahuaton, sa'inë' nichinpitacaso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Cato' piyapi nipirinhuë', a'naíchin pochin nipi. Catoya'pi nipirinhuë', a'naíchin pochin Yosëri ni'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nani Yosëri asë'quërin ni'quëhuarë', co onporonta' sa'ama' të'yatamaso' ya'huërinhuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nani pëiquë ya'conpachina, naquëranchin ca'tano'sanënpitari itapona': —Achin naporanso' a'chintantacoi nitochii, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","—Sa'ama' të'yatatoma', a'na sanapi mapatama', inaso' co sa'ama chachinhuë' ni'ton, monshitëramaso pochin Yosëri ni'nin. Ina marë' oshahuanarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Inapochachin sanapi'santa', so'in ta'ananpirahuaton, a'na quëmapi so'yatohuachin, inaso' co so'inhuë'. Monshin pochin Yosëri ni'sarin. Ina marë' oshahuanarin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ina quëran hua'huaro'sa' quëpi Quisosori së'huamotocaso marë'. Inapotahuaton, inapita marë' Yosë nontërin. Hua'huaro'sa' quëpisopita ca'tano'sanënpitari yaa'papirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ina ni'sahuaton, Quisosori co noyahuë' ni'nin. —Tananpitoco' iyaro'sa' hua'huaro'santa' huë'ina'. Ama a'pacosohuë'. Hua'huaro'sa pochin cancantopisopita Yosë hua'anëntërinquë ya'conapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tëhuënchachin carinquëma' itaranquëma', hua'huaro'sa' a'naroáchin yaimarinaco. Co'so' inapita pochin cancantohuatamahuë', co onporonta' Yosë hua'anëntërinquë ya'conaramahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ina quëran hua'huaro'sa' iporin. Së'huamotorahuaton, inapita marë' Yosë nontërin noya ya'huëcaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ina quëran Quisoso yapaantarapirinhuë'. A'nara quëmapi ta'aquirahuaton, isonquirin. —Quëmaso' Maistro noyanquën. ¿Ma'ta' caso' onpo'i nanpimiata'huaso marë'? Sha'huitoco canta' noya nii, itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Ma'marëta' “Quëmaso' noyanquën” itëranco? Yosëíchin noyaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Iráca pënëntërinso' nani nitotëran. “Ama piyapi tëpacosohuë'. Ama nitëhuananpitocosohuë'. Ama ihuatocosohuë'. Ama ninonpinapicosohuë'. Ama nonpincosohuë'. Tatama' natëco'. Mamamanta' natëco',” tënin Yosë pënëntaton, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Co manta' Maistro onporahuë'. Hua'huatapo quëran huarë' ya'ipi inapita natërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ina natanahuaton, nirayarin. “Tëhuënchachin noya yonquirin,” ta'ton nosororin. —Isonta' iyasha Yosë nohuantërin ta'a. Paquë'. Ya'ipi ma'shanënpita pa'anahuaton, coriqui canaranso' sa'ahuaro'sa' quëtëquë'. Ina quëran huëquë' imaco huachi. Inapohuatan, a'na tahuëri Yosë'pa' canamiataran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ina natanahuaton, co huachi noyahuë' cancantërin. “Hua'huayatërahuë' ma'sha ya'huëtërinco,” ta'ton sëtërin. Sëtaton, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ina quëran Quisosori ca'tano'sanënpita ni'sahuaton, itapon: —Pa'pi sacai ma'huano'sa' Yosë hua'anëntërinquë ya'conacaiso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ina natanahuatona': “¡Ma'pitacha naporin paya!” nitopi ca'tano'sanënpita. —Tëhuënchachin iyaro'sa' ma'sharáchin yonquihuatëra, sacai' Yosë hua'anëntërinquë ya'conacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni'co'. Nahuan huëratën pi'pira'huaya naninën ya'huëtërin. Camiyoso panca masho ni'ton, co pi'pisha tëranta' nanitërinhuë' inaquë ya'conacaso'. Ina quëran saca sacai' ma'huano'saso' Yosë hua'anëntërinquë ya'conacaiso', itaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ina natanahuatona', pa'yanpi: —Napoahuarë', ¿incha nica cha'ërë'poya? nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ya'ipiya notëërahuaton, Quisosori itapon: —Co insonta' inaora nanitërinhuë' cha'ëcaso'. Yosëíchin nanitërin anoyacancantinquëmaso'. Ya'ipiya nanitaparin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—Ni'quë' Maistro. Quiyaso' nani ya'ipi ma'shanëhuëi huëshirahuatoi, imarainquën, itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Tëhuënchachin iyaro'sa' imamacoso marë' nani ma'sha patohuatama', na'con na'con Yosë catahuarinquëma', tënahuë. A'naquëma' mini nanamëhuë a'chinacamaso marë' co huachi ya'huëmiataramahuë'. A'naquëma' pëinëma', iyaparima', oshiparima', tatama', mamama', hui'nama', no'panëma', inapita patërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ca imamacoso marë' napohuatama', Yosë na'con na'con quëtantarinquëma'. Isoro'paquë chachin pasaro' aquëtë pochin pëiro'sa', iyaro'sa', oshiro'sa', mamaro'sa', hua'huaro'sa', no'paro'sa' inapita quëtarinquëma'. Noya cancantarama'. Napoaponahuë', aparisitarinënquëma anta'. A'na tahuëriso huachi Yosë'pa' nanpimiatarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A'naquën ipora chiníquën nanantopirinahuë', a'na tahuëri topinan piyapi pochin nisapi. A'naquënso nipirinhuë', ipora topinan piyapi pochin nicaponahuë', a'na tahuëri chiníquën nanantapi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ina quëran ira pa'tahuatona', Quirosarin'pa' paantarapi ni'ton, ca'tano'sanënpita pa'yanpi. Imapisopitanta' të'huatopi. Quisososo nipirinhuë', quëchitërarin. Naquëranchin ca'tano'sanënpita amashamiachin quëparahuaton, ma'sona onpocaso' sha'huitaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Noya iyaro'sa' natanco'. Iporaso' Quirosarin'pa' pa'sarëhua'. Inatohua' nani ma'sha onpotarinaco. Yosë quëran quëmapico nipirahuë', inaquë sha'huirapiarinaco. Corto hua'ano'sa', cotio maistro'sa', inapita masahuatonaco, ‘Tëpacaso' ya'huërin,’ tosapi. Ina tosahuatona', nisha piyapi'saquë yo'coaninaco tëpainacoso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Inapita tëhuarahuatonaco, ipitarinaco. Chiníquën huihuiarinaco, pë'shararinaco. Ina quëran tëpararinaco. Chiminaporahuë', cara tahuëri quëran nanpiantarahuë,” itantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ina quëran Santiaco, Coansha, inapita Quisoso huëcapaipi. Sipitio hui'ninpita inahuaso'. —Pi'pian Maistro natainquën, topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Ma'ta' iyaro'sa' nohuantërama'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—A'na tahuëri noya noya hua'anëntaran. Hua'an ya'conpatan, chiníquën nanan quëtocoi. A'naso' quëma inchinan quëran ahuënsëquë', a'nanta' ahuënan quëran ahuënsëquë', topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Canpitaso' co no'tëquën yonquiátëraramahuë'. Co ya'ipi nitochátëraramahuë'. Chiníquën iyaro'sa' parisitarahuë. Main o'orëso pochin pa'pi parisitarahuë. I'quë ya'coitërëso pochin aparisitarinaco. Canpitanta' aparisitohuachinënquëma', ¿ahuantapoma' ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ahuantarai, itopi cato chachin. —¡Naporinchi paya! Ca pochin mini canpitanta' main o'orëso pochin parisitarama'. I'quë ya'coitërëso pochin parisitarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Napoaponahuë', co caso' nanitërahuë' chiníquën nanan quëta'huanquëmaso'. Tata Yosëíchin nanitërinso'. Inari nohuantërinsopita inchinanëhuë quëran ahuënsëarin. Nani inapita marë' taparin huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chiníquën nanan nohuantopiso' natanahuatona', a'napitariso' no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Quisososo nipirinhuë', ya'ipi ca'tano'sanënpita përasahuaton, pënënin. —Co Yosë imapisopitahuë' chiníquën nanantacaiso' pa'yatopi. Hua'an ya'conpachinara, chiníquën nanantatona', yacamaitopi. Piyapinënpitanta' aparisitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Canpitaso nipirinhuë', ama inapita pochin cancantocosohuë'. Yosë hua'anëntërinquë ya'conpatëra, co chiníquën nanantacaso' nohuantërëhuë'. Noya noya yanipatama', ya'ipi piyapi'sa' catahuaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Topinan piyapi pochin cancantoco'. Catahuacasoáchin yonquihuatama', Yosë noya nicatënquëma', chiníquën nanan quëtarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Canta' Yosë quëran quëmapico niporahuë', co a'napita camaica'huaso marë' o'marahuë'. Piyapi'sa' catahuaca'huaso marë' o'marahuë. Chiminarahuë na'a piyapi'sa' nicha'ëca'huaso marë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ina quëran paantarahuatona', Quiricoquë canconpi. Ca'tano'sanënpitarë chachin pipihuachinara, na'a piyapi'sarinta' imasapi. Naporo' a'na somaraya ira yonsanquë huënsëarin quënanconpi. Timio hui'nin ni'ton, Partimio itopi. Somaraya ni'ton, nani tahuëri coriqui topinan ma'patárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Quisoso Nasaritoquë ya'huërinso' huë'sarin,” topi, natantërin. Ina natantaton: —¡Nosoroco Sinioro! Quëmaso' Tapico' shinquën ni'ton, nosoroco canta', itërin chiníquën nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A'napitari natanahuatona', no'huipi. —Ta'tëquë', itopirinahuë', aquë aquëtë chachin chiníquën nontantarin. —¡Nosoroco canta'! Quëmaso' Tapico' shinquën ni'ton, onpopionta' nosoroco, itantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Quisososo' natanahuaton, chiniconin: —Sha'huitoco' huë'in, itërin. Napotohuachina, sha'huitopi. —Noya cancantëquë' iyasha. Nani përarinquën ni'ton, Quisoso nontiiquë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A'morinso' të'yatahuaton, a'naroáchin Quisosoquë pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—¿Ma'ta' iyasha, onpochinquën? itërin Quisosori. —Anoyarayatoco Maistro canta' noya ni'tanta'i, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Inta nipachin, noya paquë'. Natëranco ni'ton, carinquën anoyataranquën, itërin. Napotohuachina, noya ni'tërin. Noyatahuaton, Quisoso imarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Quirosarinquë ya'caritohuachinara, Pitipaqui'pa' canconpi. Ina ya'cariya Pitania ya'huërin anta'. Oriposë panënquë canconahuaton, cato' ca'tano'sanën sha'huitahuaton, a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Paso' ninanoquë paco'. Canconpatama', a'nara' mora hui'napishin a'sonpinan quënanconarama'. Co incari tëranta' huënsëchátërarinhuë'. I'quiritahuatoma', quëshico. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“¿Onpotaomata' i'quiritarama'?” itohuachinënquëma': “Siniorori nohuantërin. Apira isëquë acoquiantarai,” itoco', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pa'sahuatona', mora a'sonpinan ya'coanaquë quënanconpi. Cachi yonsanquë huanirarin. Quënanahuatona', i'quiritonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","—¿Onpotaomata' moraso' i'quiritarama'? itopi inaquë ni'sapisopitari. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","“Siniorori nohuantërin,” itohuachina: “Inta nipachin, quëpaquë',” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Napotohuachinara, Quisosoquë quëpi. A'mopiso' masahuatona', mora aipi huëtopi. Nani huëtohuachinara, ina aipi Quisoso huënsërahuaton, pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na'a piyapi'sa' quëchitahuatona', cachiquë a'mopiso' huëtapi. A'napitanta', panpë mono pochin nininsopita nishitëtahuatona', no'paquë huëtërantapi. Inataquëchin Quisoso pa'sarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Piyapi'sa' quëchitërapi. A'naquëonta' Quisoso imasapi. Ya'ipi piyapiri pa'yatatona', chiníquën nonsapi. —¡Nicha'ëcoi Tata Yosë! ¡Ma noyacha Quisososo paya! Tapico' shiin inaso'. ¡Quëmari chachin chiníquën nanan quëtëran! ¡Quëma nohuanton, israiro'sacoi hua'anëntarincoi! tosapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Quirosarinquë canconahuaton, Yosë chinotopiso pëiquë no'tëërin. Ya'ipi ma'sha inaquë ni'sárin. Nani i'huarin ni'ton, pipiantarin. Shonca cato' ca'tano'sanënpitarë chachin Pitania'pa' pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tahuëririnquë Pitania quëran huënantarahuaton, Quisoso tanarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aquëran iquira nara quënanin. Na'a monohuanin ni'ton: “Inaya tëranta' nitërinso' ca'i,” ta'ton, paahuapirinhuë', co manta' nitërinhuë'. Monoquënachin quënanconin. Co tahuërinën naniyatërarinhuë' ni'ton, co nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","—Ama huachi iso nara nichinsohuë'. Co huachi insoari tëranta' nitërinso' caponhuë', tënin Quisoso. Ca'tano'sanënpitarinta' natanapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ina quëran Quirosarinquë canconpi. Yosë chinotopiso pëiquë ya'conahuatona', na'a nipa'antopisopita quënanconpi. Quisosori quënanconahuaton, co noyahuë' ni'nin. Napoaton a'parin. A'naquën inaquë coriqui nicanpiarapirinahuë', misanënpita pitaton, ohuërëtëra'piarin. Nëpë' pa'anpisopitanta' a'parahuaton, huënsëpiquë të'yatërin. Ina quëran ya'ipi piyapi'sa' pënënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","“Ama nisha nisha ma'sha Yosë pëinënquë quëntacosohuë',” tënin. Ina quëran a'chintaton, itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","—Yosë quiricanënquë ninshitërinpoa'. “Ca nohuanto, pëinëhuë ya'huë'in nontiinacoso marë'. Ya'ipi piyapi'sa' nisha nisha nananquë nonpisopita nontiinacoso marëáchin acotëranquëma',” tënin Yosë. Canpitaso nipirinhuë', ihuatëro'sa' ya'huëpiquë pochin atarantërama', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","“¡Ma'pitacha nitotërin paya!” topi ya'ipi piyapi'sa'. Napoaton corto hua'ano'sa', cotio maistro'sa', inapitanta natanahuatona', të'huatopi. “Ya'ipi piyapi'sari yaimapi,” ta'tona', Quisoso tëpacaiso' chinotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yatashirahuaso', Quisososo' ca'tano'sanënpitarë chachin ninano quëran pipiantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tahuëririnquë tashiramiachin huënantarahuatona', iquira nara ni'quiantapirinahuë', nani ahuirin. Itën quëran huarë' ahuirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ina ni'sahuaton, Pitro yonquirin. —Ni'quëchi Maistro. Iquira nara i'huara sha'huitëranso' nani ahuirin huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Ya'ipi cancanëma quëran Yosë natëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Inaso', ya'ipi nanitaparin. Ina nontohuatama', chiníquën natëco': “Co Yosë catahuarincohuë',” ama tocosohuë'. Ya'ipi cancanëma quëran ina natëhuatama', catahuarinquëma'. “Yosë nohuanton, iso motopi marëquë nichi'huincain,” tënama' naporini, ina nohuanton nichi'huincaitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Napoaton Yosë nontatoma' ma'sona nipatama', natëco'. “Tëhuënchachin Yosë catahuarinco,” topatama', catahuaarinquëma' tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Noya cancantatoma', Yosë nontoco'. A'na piyapi ma'sona tëranta' onpotohuachinquëma', canpitarinta' pi'pian tëranta' no'huihuatama', ina naniantoco'. Ya'ipi cancanëma quëran huarë' nanan anoyatoco' Tata Yosë oshanëma' inquichinquëma'.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Co nanan anoyatohuatamahuë', Tata Yosënta' co oshanëma' inquitarinquëmahuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ina quëran Quirosarinquë huëantapi. Yosë chinotopiso pëiquë ya'concoantahuachina, cotio ansiano'sa', corto hua'ano'sa', cotio maistro'sa' inapitari huëcapaipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Onporahuatonta' chiníquën nanantaton, nipa'antopisopita a'paran? ¿Inta' nanan quëtërinquën ina pochin nicacamaso'? Sha'huitocoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Inta nipachin, carinquëmanta' natainquëma'. Ina sha'huitohuatamaco, insosona nanan quëtërincoso' sha'huitaranquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Incarita' Coansha nanan quëtërin piyapi'sa' aporintacaso marë'? ¿Yosëri nanan quëtëca, piyapi'sari nica? ¿Ma'ta' tënama' canpita? Sha'huitoco carinquëmanta' nanan quëtërincoso' sha'huichinquëma', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Natanahuatona', inahua capini nisha nisha ninontapi. “¿Ma'ta' itahua'? ‘Yosëri nanan quëtërin,’ itohuatëhua', a'paniarinpoa'. ‘¿Onpoatomata' nipachin co ina natëramahuë'?’ itarinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nipirinhuë', ‘Co Yosëri nanan quëtërinhuë'. Piyapiri quëtërin,’ itohuatëhua', na'a piyapi'sa' no'huiarinënpoa'. ‘Yosëri Coansha a'parin pënëntacaso',’ topi ya'ipi piyapi,” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nani ninontohuachinara, Quisoso itapona': —Ahuën. Co quiyaso' nitotëraihuë'. ¿Incariso' Coansha nanan quëtomara? Co nitotëraihuë' ta'a, toconpi. —Noyapa'. Napoahuarë', co carinquëmanta' insosona nanan quëtërincoso' sha'huitaranquëmahuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ina quëran Quisosori pënënto nanan sha'huitaantarin: “A'na quëmapi pancana iminaton, oparotërin. Nani pairapirahuaton, na'pi quëran nanpi ninin opa to'poitona', huino nicacaiso marë'. Naporahuaton, na'pi quëran chachin tori ninin. Inaquë piyapinën ya'huaton, nocorarin ama ihuacaiso marëhuë'. Nani tiquihuachina, inpriatoro'sa' acorin a'paicaiso marë'. ‘Sacatëramaso marë' nitërinso' patomachin canpitaora marë' maco'. Patomachin canta' acotoco,’ itërin. Itahuaton, a'na parti pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nitërinso' nani cayahuachina, piyapinën a'parin patoma nitërinso' ma'pacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A'papirinhuë', inpriatonënpitari masahuatona', ahuëpi. Ahuërahuatona', topinan a'paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naquëranchin hua'anëni a'na piyapinën a'paantapirinhuë', inanta' motën pë'shatahuatona', chiníquën no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ina quëran a'nanta' a'paantapirinhuë', inaso' huachi tëpapi. Ina quëran na'a a'paantapirinhuë', a'naquën ahuëpi, a'naquën tëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Napotohuachinara, hua'anëni yonquiantarin. ‘¿Ma'cha onpochiya? Na'aya'pi a'papirahuë', co manta' quëtopihuë'. Hui'nahuë na'con nosoropirahuë', ina huachi a'paarahuë. Ina tëhuënchinso' natëpona' nimara,’ ta'ton, hui'nin chachin a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Inpriatonënpitaso nipirinhuë', hui'nin quënanahuatona' ninontopi. ‘Paso' hui'napi a'na tahuëri pa'pin chiminpachin, ya'ipi hua'anëntarin huachi. Huëco' tëpa'ahua'. Ya'ipi ma'shanënpita canpoari matahua',’ nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Naporahuatona', hui'nin masahuatona', tëpapi. Aipiran të'yatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pa'pin natantohuachin, ¿ma'ta' onpotintapon hui'nin chachin tëpatopi ni'quëhuarë'? Chiníquën no'huiton, inpriatonënpita tëpapon. Ina quëran nasha inpriatoro'sa' acoantapon, tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iráca Yosë nohuanton, ninorin. Quiricanënquë ninshitërinso' ¿co nontëramahuë' ti? Ninshitaton, naporin: ‘Na'pi quëran yapëihuachina, a'na na'pi ya'huëpirinhuë', sacatoro'sari co nohuantopihuë'. “Napoonin,” ta'tona', të'yatopirinahuë'. Hua'anëni maantarahuaton: Iso na'pi mini na'con na'con nohuantërahuë pëica'huaso marë', ta'ton, noya acoantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yosë chachin naporin. Napoaton ¡Ma noyacha inaso' ninin paya! tënëhua',’ tënin quiricanënquë,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Natanahuatona', cotio hua'ano'sari chiníquën no'huipi. “Chinotatonpoa' pënënarinpoa',” ta'tona' Quisoso yamapirinahuë' tashinan pëiquë po'mocaiso marë'. Piyapi'sa' niyontonpisopita të'huatatona', co mapihuë'. Patopi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ina quëran hua'ano'sari yonquipi Quisoso nonpintacaiso marë'. Napoaton a'naquën parisioro'sa' a'papi. Caraíchin Irotisë imarinsopitanta' a'papi. Yapa'pachinara, itapona': “Paatoma', nisha nisha natanco'. Co no'tëquën a'panihuachinquëmahuë', sha'huirapiahua',” itatona', a'papi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Canconahuatona', noyásha nontonpi nonpintacaiso marë'. —No'tëquën Maistro nontërancoi. Co piyapi'sa' pa'yatiinënquënso marë' a'chinanhuë'. Co hua'an tëranta' të'huatëranhuë'. Yosë nohuantërinso' no'tëquën a'chintërancoi. Napoaton yanatanainquën. Noma copirno nisha piyapi niponahuë', ya'ipinpoa' hua'anëntërinpoa'. Coriqui ma'painpoaso marë' comisionën a'parin. Huë'pachin, ¿noya ipora quëtacaso' ti? ¿Ma'ta' Yosë nohuantërin nica'huaiso'? Sha'huitocoi nitochii, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yanonpintopiso' nitotaton, Quisosori itërin: —¡Canpitaso' nonpintënquëma'! ¿Ma'marëta' yaatëhuëramaco? Noma coriqui quëshico ni'i, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Napotohuachina, quëtopi. —¿Inta' isoso' nonanpiso'? itohuachina, —Noma copirno, itopi. —¿Inta' nininëonta' isëquë ninshitopi? itantarin. —Noma copirno chachin, itantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Copirno ma'shanën ni'quëhuarë' inachachin quëtantaco'. Naporahuaton, Yosëso nininpoa' ni'ton, hua'anëntërinpoa'. Ya'ipi cancanëma quëran ina natëcaso' ya'huërin, itërin. Natanahuatona', pa'yanpi. “¡Ma noyacha a'panirinpoa paya!” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ina quëran a'napita cotio hua'ano'sa' ya'huërë' huë'pi, satosioro'sa' itopiso'. Inapitaso' nisha a'chinpi. “Piyapinpoa' chiminpatëhua', co onporonta' nanpiantarihuahuë',” toconpi. Inahuanta' Quisoso yanonpintatona', iráca napopiso' sha'huitiipi: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Iráca, Maistro, Moisësë ninshitërin pënëinpoaso marë'. “Quëmapi sa'aponahuë co hui'nin ya'huëyátërasohuë' sa'in ayananpihuachin, ina iini chachin imoroën maantacaso' ya'huërin. Hui'nahuanpachin, iinco' apoin inari ya'huërëtacaso marë'. Ina quëran mashotohuachin, ma'shanën, no'panën, inapita masarin,” tënin Moisësë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Canchisë iyaro'sa' ya'huërin. Paninanso' sa'apirinhuë'. Co hui'nin ya'huëyátërasohuë', sa'in ayananpirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ina iini chachin maantarin. Moisësë tëninso chachin manin. Inanta' co hui'nin ya'huëyátërasohuë', chimiantarin. A'na iionta' inapoantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Canchisë iinpita chachin inapoantapi. Co a'naya tëranta' hui'nin ya'huëyátërasohuë', ya'ipi taquipi. Ina quëran sanapinta' chiminin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Canchisë iinpita chachin nani mapirinahuë', nanpiantacaso tahuëri nanihuachin, ¿inquën chachincha sa'in ninë'poya? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—¡Canpitaso' co no'tëquën yonquiramahuë'! Yosëso' chini chiníquën nanantopirinhuë', co nohuitëramahuë'. Quiricanëonta' nontapomarahuë', co cancanëma quëran natëramahuë'. Napoaton co nanitëramahuë' no'tëquën yonquicamaso'. Yosë ya'ipi nanitaparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chiminpisopita nanpiantahuachina', co huachi sa'aponahuë'. Sanapi'santa' co huachi so'yaponahuë'. Anquëniro'sa pochachin nisapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chiminpisopita tëhuënchachin nanpiantarapi. ¿Co'na ina Moisësë ninshitërinquë nontëramahuë'? Sarsa nara'huaya orotarinso' nicaso', Yosëri nontërin. “Caso' Yosëco. Apraan chinotarinco. Isaco, Cacopo, inapitanta' chinotarinaco,” itërin Yosëri. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nanpirëhuasopitaráchin Yosë chinotarëhua'. Napoaton Apraan, Isaco, Cacopo, inapita nani chiminpirinahuë', nanpiantarapi. Canpitaso' co no'tëquën yonquiramahuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Satosioro'sarë' ninontasoi', a'na cotio maistro huë'nin. Natanahuaton: “Ma noyacha Quisososo' nitotërin paya,” ta'ton, itapon: —Yosë na'con pënëninpoa'. ¿Ma'ta' na'con na'con nohuantërin natëcaso'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Inta nipachin iyasha a'chinchinquën. Yosë quiricanën quëran chachin sha'huitërinpoa'. “Ya'ipi israiro'sanquëma', natanco'. Yosëíchin hua'anëntërinpoa'. Inasáchin natërëhuaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ina na'con na'con nosorocaso' ya'huërin. Ya'ipi cancanëma quëran, ya'ipi hua'yanëma quëran, ya'ipi yonquinëma quëran, ya'ipi chinirama quëran, ya'ipi inaquëranpita nosoromiatoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Isonta' Yosë nohuantërin: Quëmaora ninosororanso pochachin a'napitanta' nosoroco',” tënin. Nosorotacaso' na'con na'con nohuantërin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Tëhuënchachin Maistro no'tëquën nonan. A'naíchin Yosë ya'huërin. Co a'na ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ya'ipi cancanënpoa quëran, ya'ipi yonquinënpoa quëran, ya'ipi chinirëhua quëran, ya'ipi inaquëranpita nosoromiatacaso' ya'huërin. Naporahuaton, canpoara ninosororëso pochachin a'napitanta' nosorocaso' ya'huërin. Iráca Moisësë pënëninpoa'. “Yosë yachinotohuatama', oshanëma marë' ma'sha tëpatoma', ahuiquitoco',” itërinpoa'. Inapopirëhuahuë', co Yosë nosorohuatëhuahuë', co piyapi'santa' nosorohuatëhuahuë', Yosëso' co onpopinchin noya ni'sarinpoahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","—No'tëquën iyasha yonquiran ni'ton, pi'pian pahuantarinquën Yosë hua'anëntërinquë ya'conacaso', itërin Quisosori. Ina quëran ya'ipi piyapi'sa' tapanatona', co huachi nohuantopihuë' nataantacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ina quëran Yosë chinotopiso pëiquë Quisosori piyapi'sa' a'chintaantarin. —Iráca quiricanën quëran Yosë tapon: “A'na tahuëri a'na quëmapi acoarahuë piyapi'sa' nicha'ëcaso marë'. Inaso' Cristo,” tënin. Cotio maistro'saso' a'chinpachinara, “Cristoso' Tapi shia'huain,” topi. ¿Onpoatonta' naporin? Ina iyaro'sa' yonquico'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Iráca Ispirito Santo nohuanton, Tapi chachin ninshitërin. Cristo ninoton, naporin: Yosëri Sinioronëhuë sha'huitërin. “Inchinanëhuë quëran huënsëquë' inimiconënpita cari minsëchinquën,” itërin Yosëri, tënin Tapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Shia'huain niponahuë', Cristo yonquiaton, “Sinioronëhuë,” tënin Tapi. Piyapi chachin nipirinhuë', Tapiri chinotërin. ¿Onpoatonta' naporin? itërin Quisosori. “Yosë hui'nin chachin ni'ton, naporin,” ta'caiso nipirinhuë', co manta' topihuë'. Notohuaro' piyapi'sa' niyontonpisopitaso nipirinhuë', nóya natanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ina quëran Quisosori a'chintaantarin. “Ni'cona cotio maistro'sa' nonpintochinënquëma'. A'naquën naporopi a'mopi piyapi'sari nohuitacaiso marë'. Ina pochin a'mosahuatona', cachiquë pa'pachinara, na'a piyapi'sari noya nontopi. ‘Huë'cama maistro,’ itohuachinara, pa'yatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Cotioro'sa' niyontonpiso pëiquë ya'conpachinara, hua'ano'sapitarë' yahuënsëconpi. Pita nipachinara, huancánachin yahuënsëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Noya nonaponaraihuë', a'naya a'naya quëyorono'sa' nonpintatona', ma'shanënapita matopi. Ama noninacaiso marëhuë' hua'qui' Yosë nontopirinahuë', co cancanëna quëran natëpihuë'. Ina marë' aquë aquëtë' Yosëri ana'intarin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ina quëran coriqui cacon notënanquë Quisoso huënsërin. Piyapi'sa' ni'sárin. Notohuaro' piyapi'sa' huë'sahuatona', coriqui Yosë marë' inaquë po'moquirapi. Na'a ma'huano'saso' na'con coriqui po'morapirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ina quëran a'nara quëyoron huë'nin, sa'ahua nininso'. Catotëra'huayaíchin coriqui po'moquirin, pi'pira'huaya pa'tërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ca'tano'sanënpita përasahuaton, Quisosori itapon: —No'tëquën itëranquëma'. Na'a piyapi'sa' na'con coriqui po'morapirinahuë', iso quëyoronso', na'con na'con po'moquirin, tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ma'huano'saso' na'a coriquihuanatona', ya'sotopiso' acopi. Iso sanapiso nipirinhuë', pi'pian ya'huëcharinso tëranta' tiquirin. Co huachi ya'huëtërinhuë'. Napoaton na'con na'con Yosë quëtërin, tënahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ina quëran Yosë chinotopiso pëi quëran pipihuachinara, a'na ca'tano'sanëni itapon: —Ni'quë' Maistro. Ma noyápiachin pëipiso'. Pancara'pi quëran nipi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—Iporaso' noyápiachin ni'piramahuë', a'na tahuëri ya'ipi ohuatapi. Co a'na na'piya tëranta' niya'huiritarinhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ina quëran Oriposë panënquë pa'sahuaton, inaquë huënsëconin. Ca'tano'sanënpitaráchin ya'huëapi. Aquë quëran Yosë chinotopiso pëi' notëërapi. Pitro, Santiaco, Coansha, Antërisë, inapitari itapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“¿Onporota' Maistro ohuatapi? Ya'ipi yata'huantohuachina', ¿onporahuachinata' nitotapoi? Sha'huitocoi quiyanta' nitochii,” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","“Ni'cona iyaro'sa' nonpintochinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A'naquën huëcapona', ‘Caso' Cristoco. Yosë chachin a'parinco,’ tëcapona'. Nonpintë' nipirinhuë', na'a piyapi'sari imapona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nisha nisha parti piyapi'sa' nino'huiapi. Niahuëatona', quira nisapi. Ina natantohuatama', ama pa'yancosohuë'. Tëhuënchachin nisha nisha parti naporapi. Napoaponahuë', co isoro'pa' ta'huanchátëraponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nisha nisha nananquë nonpisopita nino'huitona' quira nisapi. Copirnoro'sa capini nino'huitona', piyapinënpita camairapi quira nicacaiso marë'. A'na parti a'na parti ocohua pa'sarin. Cosharo' pahuanpachin, tanari tiquirarin. Ni'co'. Sanapi yahuaihuachina, iquitárin, co a'naroáchin huairinhuë'. Inapochachin ayaro' tahuëri ya'caritohuachina, na'con parisitapirinahuë', co isoro'pa' ta'huanchátëraponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ni'cona canpitanta' naniantotamaco. A'na tahuëri masarinënquëma'. Imaramacoso marë' coisëquë sha'huirapiarinënquëma'. Cotio niyontonpiso pëiro'saquë huihuiarinënquëma'. Imaramaco ni'ton, chirinchi hua'ano'sa' ya'huërinquënta' sha'huirapiarinënquëma'. Ca nohuanto, inaquë quëpaarinënquëma' nanamëhuë sha'huitacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Co'huara isoro'pa' ta'huanchatërasohuë', noya nanan ya'ipi piyapi'sa' sha'huitacaso' ya'huërin. Nisha nisha nananquë nonpisopita nataina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mapachinënquëma', ‘¿Ma'cha tono'pocoya?’ ama tocosohuë'. Coisë'pa' quëpahuachinënquëma', naporo' Yosë catahuaarinquëma' noya nonacamaso marë'. Co canpitaora nonsaramahuë'. Ispirito Santo ayonquiarinquëma' noya nonacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naporo' tahuëri'sa' nisha nisha yonquiapi. A'naquën imasarinaco. A'naquënso nipirinhuë' co nohuantarinacohuë' ni'ton, quëmopinënpita capini nino'huiapi. A'naquën iin chachin niponahuë', sha'huirapiarin tëpacaiso marë'. A'naquën hui'ninpita imapachinaco, pa'pini chachin sha'huirapiarin. A'naquën a'shinhuë nipon, pa'pinhuë nipon, imapachinaco, hui'ninpitari chachin sha'huirapiapi tëpacaiso marë' ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Imaramaco ni'ton, ya'ipi piyapi'sa' no'huiarinënquëma'. Napoaponahuë', chiminaquë huarë' imamiatohuatamaco, cha'ësarama huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A'na tahuëri inimicoro'sa' Yosë pëinënquë ya'conahuatona', pa'pi co noyahuë' nisapi ni'ton, tapiapona', co huachi inaquë Yosë chinotapihuë'. (Ina quirica nontohuatama', noya yonquico'.) Ina ni'patama', naporo' ta'aco'. Cotia parti ya'huëhuatama', motopi'pa' ta'aco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pëinëma' a'canamaso' aipi ya'huëhuatama', ama ma'shanëmapita quëpacaso marë' ya'concosohuë'. A'naroáchin topinan paco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iminëmaquë sacatasënquëma' nipachin, ama a'moramaso tëranta' maquintacosohuë'. Manóton ta'aco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naporo tahuëri'sa' cayorono'sa', sho'shopia'hua ya'huëtopiso', inapita parisitapona'. ¡Ma'huantacha nicapona paya! ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yosë nontoco' ama o'napi tahuëri inapocamaso' ya'huë'insohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Naporo' tahuëri'sa' piyapi'sa' chini chiníquën parisitapi. Isoro'pa' ninin quëran huarë' co ina pochin parisichátërapihuë'. Ina piquëraonta' co onporonta' ina pochin parisitaantarapihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yosë nohuanton, co hua'qui' aparisitapihuë'. Hua'qui' aparisitapi naporini, ya'ipi piyapi'sa' taqui'itonahuë'. Nipirinhuë', piyapinënpita nosoroaton, co nohuantërinhuë' hua'qui' aparisitacaiso'. Huayoninsopita nicha'ësarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Naporo' tahuëri'sa' nisha nisha sha'huitarinënquëma'. ‘¡Ni'cochi, Cristo nani huë'nin!’ tosapi. A'napitanta' tapona': ‘¡Ni'cochi, pasëquë ya'huarin!’ tosapi. Napotohuachinënquëma', ama natëcosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Na'a nonpin nanan pënëntona'piro'sa huëcapona'. ‘Caso' Cristoco,’ tëcapona' a'naquën. ‘Caso' ninotona'pico,’ tosapi a'naquëonta'. Sacai' nininso' nisapi piyapi'sa' nonpintacaiso marë'. Ni'sahuatona': ‘Ma'pitacha nitotërin paya. ¿Yosë quëran o'mamara, ti?’ ta'tona', na'a piyapi'sari imasapi. Yosëri huayoninsopita quëran huarë' nonpintochinaichin nisapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Canpitaso nipirinhuë' ni'cona nonpintochinënquëma'. Nani sha'huitëranquëma' ama naporo' tahuëri'sa' nonpintinënquëmaso marëhuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ina tosahuaton taantarin: “Ina quëran iyaro'sa' nani chiníquën parisitohuachina', pi'i tashiarin. Yoquinta' co huachi a'pinarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Naporahuaton, na'a tayoraro'santa' anotarin. Ya'ipi inápaquë ya'huërinsopitanta' nacon nacontapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naporo' ya'ipi piyapi'sa' ni'sarinaco. Yosë quëran quëmapico ni'to, chitoro' huancana o'mantararahuë. Chiníquën nanantato, huënaráchin huënaráchin ya'noarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O'mantahuato, anquëniro'sa' a'pararahuë Yosëri huayoninsopita ya'ipi parti quëran ayontonacaiso marë'. Pa'sahuatona', nisha nisha parti quëran huarë' ayontonapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iquira nara papotërin quëran, iyaro'sa', nitotoco'. Ta'amënquë monoantahuachina, ‘Nani o'napi naniriarin huachi,’ topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Inapochachin nani ma'sha onporahuachina, nitotarama'. ‘O'mantacaso' tahuëri naniriarin huachi,’ tosarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No'tëquën sha'huitëranquëma'. Co'huara cotioro'sa' huënton ta'huanchatërasoihuë', nani ma'sha onporapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Isoro'pa' ta'huantarin. Pi'iro'tënta' ta'huantarin. Ca nonahuëso nipirinhuë', co onporonta' ta'huantarinhuë'. No'tëquën nonahuë ni'ton, ya'ipi sha'huitëranquëmaso chachin naniarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Onporosona o'mantaca'huaso' tahuëri nanihuachin, co insonta' nitotërinhuë'. Co anquëniro'sa tëranta' nitotapihuë'. Yosë hui'ninco niporahuë', co ca tëranta' nitotërahuë'. Tata Yosëíchin nitotërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Napoaton ama huë'ërëso pochin cancantatoma', naniantocosohuë'. Onporosona o'mantaca'huaso' tahuëri nanihuachin, co nitotaramahuë'. Yosë nontatoma', ninaco. Noya yonquiatoma', ya'huëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A'na quëmapi aquë yapa'ninso pochin nisarin. Yapa'pachina, inpriatonënpita camairin. A'naya a'naya sha'huitërin ma'sona nicacaiso marë'. Ya'coana to'shitona'pinta' sha'huitaton: ‘Pëi' noya ni'quë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Onporosona pëi' hua'anën huënantacaso' co nitotopihuë'. ‘I'huaraya huarë' huëcapon nimara. Yonotashi' a'na' huëcapon nimara. Atari përasahuaso', huëcapon nimara. Tashíramiachin huëcapon nimara,’ topi. Inapochachin canpitanta' o'manta'huaso tahuëri co nitotatomahuë', nináco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ni'cona a'nanaya o'mato, huë'ësënquëma' quënanquimatënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nani a'chintëranquëma huachi. Ya'ipi piyapi'sa' nitochina'. ‘Ama huë'ërëso pochin cancantatomarahuë', ninaco,’ itarahuë ya'ipi piyapi'sa',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cato' tahuëri pahuanarin Pascoa nanicaso'. Naporo' Yosëri iráca nicha'ërinso' yonquiatona', coshatapi. Pan co huëpocatërinsohuë' ca'sapi. Pascoa naniriahuachina, cotio hua'ano'sa', cotio maistro'sa', inapitari chinotapi onporahuatonsona Quisoso macacaiso marë'. Nonpintatona', yatëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Ama niyontonpiso tahuëri'sa chachin maahuasohuë', piyapi'sa' no'huihuachinënpoa'. Quisoso pa'yatapi ni'ton, ahuëarinënpoa', topi a'naquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Quisososo' Pitaniaquë pa'nin. Simon pëinënquë coshatapatarin. Inaso' chana caniori mapirinhuë', anoyatërinso'. Misaquë coshatasoi', a'nara sanapi huë'nin. Potiria'huaya nishana'pi quëran nipiso' quënin. Inaquë pimo hua'sai' na'con pa'tërinso' ya'huërin. Potiria'huaya oparahuaton, Quisoso motënquë hua'sai' opomototërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A'naquën no'huitatona', inahua capini ninontapi. —¿Onpoatonta' iso hua'sai' pa'ton nipirinhuë' chiniarin? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pa'anin naporini, cara pasa tahuëri marë' pahuërëtopiso pochin coriqui canaitonhuë'. Sa'ahuaro'sa' quëtacaso' ya'huëchitonhuë', nitopi. Ina pochin yonquiatona', sanapi no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Quisosoriso nipirinhuë', itapon: —¿Ma'marëta' iso sanapi no'huirama'? Tananpitoco'. Na'con nosoroatonco, inapotërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nani tahuëri sa'ahuaro'saso' isëquë ya'huërapi. Nohuantohuatama', nosoroarama'. Napoaponahuë', caso' co hua'qui' canpitaro'co ya'huarahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iso sanapiso' cancanën quëran noya yonquiaton, inapotërinco. Co'huara chimiyantërasocohuë', nosoroatonco, nonëhuë hua'saiquë opotërinco pa'pitinacoso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","No'tëquën itaranquëma'. Insëquësona noya nanan sha'huihuachina', iso sanapi napotërincoso' sha'huirapi anta'. Co naniantapihuë', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Shonca catoya'piri Quisoso ca'tanpirinahuë', a'nara' corto hua'ano'saquë pa'nin sha'huirapicaso marë'. Inaso' Cotasë Iscarioti itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Natanahuatona', pa'yatopi: “Ina marë' coriqui quëchinquën,” itopi. Ina quëran Cotasë yonquirarin po'oana quëran Quisoso a'nocaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascoa nanihuachina, nisha pan ca'pi, co huëpocatërinsohuë'. Naporo' tahuëri chachin carniroa'hua iráca tëpapiso pochin tëpaantapi capatona' yonquicaiso marë'. Nani pi'ipiquë cotioro'sa' naporápi ni'ton, ca'tano'sanënpitari Quisoso itapona': —¿Intohuata' Maistro paatoi Pascoa cosharo' nii capacaso marë'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Napotohuachinara, cato' ca'tano'sanënpita nontërin: —Ninanoquë paco'. Inaquë a'na quëmapi nacapiarama'. Yonquë i'sha chi'yatarin. Ina imaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pëiquë ya'conconpachin, pëi' hua'anën natanconco'. “¿Insëquëta' patoana ya'huërin Pascoa cosharo' capa'huaiso'?” tënin Maistro, itonco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Napotohuatama', panca patoana inápaquë nininso' a'notarinquëma'. Inaquë misa, huënsënan, inapita ya'huërarin coshatacaso marë'. Nani taparin huachi. Inaquë cosharo' nico' canpoa' capacaso marë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pa'sahuatona', ninanoquë canconpi. Quisosori sha'huitërinso chachin quënanconpi. Inaquë Pascoa cosharo' nipi capacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nani tashiro'porapaso', Quisoso shonca cato' ca'tano'sanënpitarë chachin huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Misaquë coshatasoi', Quisosori itapon: —No'tëquën iyaro'sa' itëranquëma'. A'naquëma' carë' coshatapomarahuë', sha'huirapiaramaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Natanahuatona', sëtopi. Sëtatona', a'naya a'nayari Quisoso natanpi. —¿Incoita' Sinioro yasha'huirapirainquën? ¿Co cahuë' nimara ti? topi a'naya a'naya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Shonca catonquëma' ca'tanapomaracohuë', a'naquëma' yasha'huirapiramaco. Ina sënanquëráchin i'shiaton carë' caponahuë', yasha'huirapirinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yosë quiricanënquë ninorincoso chachin chiminarahuë. Yosë quëran quëmapico niporahuë', chiminarahuë. Napoaponahuë', quëmapi yasha'huirapirincoso' ma'huantacha nicapon paya. Co nasitërinhuë' naporini, noya noya niitonhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Coshatasoi', pan masahuaton, Yosë nontërin. “Yosparinquën Tata,” itahuaton, së'panin. Ina quëran, ca'tano'sanënpita quëtëra'piarin. —Ca'co' iyaro'sa'. Ca nonëhuë pochin iso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Minëa'huanta' masahuaton, “Yosparinquën Tata,” itahuaton, inanta' quëtërin. Quëtohuachina, ya'ipi o'opi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Ca huënainëhuë pochin iso'. Huënainëhuë pa'sarin ni'ton, nasha quëran canpitarë' Yosë anoyatërinso' sha'huichinquëma' imacamaso marë'. Chiminarahuë na'a piyapi'sa' oshanëna' inquita'huaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No'tëquën itaranquëma'. Ipora quëran huarë' co huachi opai' o'oantarahuë'. Chiminarahuë huachi. A'na tahuëri Yosë hua'anëntërinso' nanihuachin, nasha pochin nininso' o'oantarahuë. Naporo' noya noya cancantarihua', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nani Yosë cantanën cantarahuatona', Oriposë panënquë pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Inaquë Quisosori itapon: —Tëhuënchachin ya'ipinquëma' ta'ananpiaramaco. Iráca quiricanënquë ninoton, Yosë naporin. “Ca nohuanto, pë'tahuatona'pi tëpaapi. Tëpahuachina', ohuicanënpita yanquëërapi,” tënin. Ipora tashi chachin napoarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Chiminaporahuë', Yosë ananpitaantarinco. Ananpitaantahuachinco, ca'ton Cariria'pa' pa'sarahuë. Inatohua' niquënantarihua', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","—A'napita ta'ananpipirinënquëonta', co caso' ta'arahuë', itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—No'tëquën iyasha itaranquën. Ipora tashi chachin co'huara atari catoro' përashatërasohuë', cararo' nonpinapiaranco. “Co caso' Quisoso nohuitërahuë',” toconapon, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Quëma imasaranquën ni'ton, yatëpapirinacohuënta', co onporonta' nonpinapiaranquënhuë', itërin Pitrori. Inachachin topi ya'ipiya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ina quëran nararoquë canconpi, Quisimani itopiquë. —Isëquë iyaro'sa' huënsëtaco'. Yosë nontëri'i, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitro, Santiaco, Coansha, inapitaíchin amashamiachin quëparin. Naporo' sëtaton, co napion cancantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Pa'pi sëtërahuë. Chiminchináchin sëtërahuë. Isëquë huënsëtaco'. Ama huë'ëtomarahuë', ni'táco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Amashamiachin pa'sahuaton, isonconahuaton, no'paquë huarë' monshomarin. Inaquë Yosë nontarin. “Quëma nohuantohuatan Tata, nicha'ëco ama ma'sha onpo'isohuë'. Main o'orëso pochin parisita'huaso' ya'huërin. Co parisita'huaso' nohuantaporahuë', quëma nohuantohuatan, ma'sona yaonpotohuatanconta' noya, tënahuë. No'tëquën yanatëranquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ina quëran huënantapirinhuë', cara chachin huë'ësápi quënanquintarin. —¿Onpoatoncha iya Simon, huë'ësaran paya? ¿Co a'na ora tëranta' nanitëranhuë' ni'tamaso' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ama huë'ëtomahuë', ni'táco'. Yosë nontáco' ama sopai minsëinquëmaso marëhuë'. Cancanëma quëran Yosë yanatëpiramahuë', co canpitaora chiníquën cancantëramahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naquëranchin paantarahuaton, Yosë nontantarin. Inachachin itantarahuaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","huënantapirinhuë', naquëranchin huë'ëantapi quënanquinantarin. Huë'ëi' iquitatona', huë'ësápi. Tapanatona', co nanitopihuë' ma'sha ta'caiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Naquëranchin paantarahuaton, Yosë nontantarin. Ina quëran huënantarahuaton, ca'tano'sanënpita itapon: —¿Ipora huanta' huë'ësarama' ti? Nani huachi. Nani ora nanirin. Yosë quëran quëmapico nipirahuë', sha'huirapiarinco oshahuano'sa' macainacoso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Huënsëco' pa'ahua'. Ni'co'. Sha'huirapiarincoso' nani canquiarin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nonaso chachin, Cotasë canquirin. Inanta' Quisoso ca'tanaponahuë', sha'huirapiarin macacaiso marë'. Notohuaro piyapi'sari imaquiapi. Corto hua'ano'sa', cotio maistro'sa', ansiano'sa', inapitari a'papisopita. Sahuëni, shonqui, inapita së'quëërahuatona', huë'sapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Co'huara canshátërasoihuë', Cotasëri nani sha'huitërin Quisoso nohuitacaiso marë'. “Apinorahuë quëran Quisoso nohuitatoma', maco'. Noyá tonporahuatoma' quëpaco', ta'ahuachin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Canquirahuaton, Quisoso ya'yoranquirin. Ina quëran: —Tashita Maistro itahuaton, apinoirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ina quëran Quisoso chiníquën masapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A'naso nipirinhuë' sahuëninën ocoirahuaton, corto hua'an inpriatonën ahuërin. Inapotaton, nishitëhuëratëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Quisosori piyapi'sa' itapon: —Sahuëni, shonqui, inapita së'quëërahuatoma', huëcapairamaco. Matararo pochin cancantatomaco, ¿yamanamaco ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Co'tana nani tahuëriya Yosë pëinënquë ya'huëato, a'chinárahuë. Nicapomaracohuë', co manamacohuë'. Napoaponahuë', Yosë quiricanën quëran ninorinacoso chachin masaramaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ina quëran ya'ipi ca'tano'sanënpitari ta'ananpipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A'na hui'napiso' sahuanasaquëáchin niso'quëëtahuaton Quisoso imasapirinhuë', mapi. Mapirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sahuanasáchin matohuachinara, i'nanpirapi ta'arin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nani Quisoso masahuatona', corto hua'an chini chiníquën nanantërinso' ya'huërinquë quëpapi. Inaquë ya'ipi corto hua'ano'sa', ansiano'sa', cotio maistro'sa', inapita nani niyontonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitroso nipirinhuë', aquë quëran imaquiarin. Corto hua'an i'iratë' pairapirinquë huarë' imaquirin. Inaquë ya'conahuaton, ponisiaro'sapitarë' huënsëaton, napëntarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ya'ipi hua'ano'sari yatëpapi ni'ton, a'naya a'naya Quisoso nonpinapicaiso marë' yonípirinahuë', co quënanpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na'a nonpinapiaponaraihuë', nisha nisha nonconpi. Co inachachin nonpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A'naquën huanirahuatona', tapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—I'hua chachin Quisoso naporin, natanai. “Yosë pëinën piyapi'sari nipiso' ata'huantahuato, cara tahuëri quëran anoyatantarahuë. Co piyapi'sari nipisohuë' acoantarahuë,” toconin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Napoaponahuë', co inahua tëranta' inachachin nonpihuë'. Nisha nisha nonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Corto hua'an chini chiníquën nanantërinsoari huanirahuaton, Quisoso itapon: —¿Ma'ta' ta'tona' isopita nonapirinënquën? ¿Co manta' tënanhuë' ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Quisososo nipirinhuë', co manta' tëninhuë'. Ta'tárin. Napohuachina, naquëranchin nataantarin: —¿Quëmaso' Cristo, Yosë hui'ninquën chachin ti? itaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Ca mini inaco. A'na tahuëri ni'saramaco. Yosë quëran quëmapico ni'to, Yosë chiníquën nanantaton, inchinan quëran ahuënsëarinco. Ina quëran chitoro' huáncana o'mantararahuë niantaramaco, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ina natanahuaton Corto hua'anso, chiníquën no'huitërin. A'morinso osharahuaton tapon: —“¡Caso' Yosë hui'ninco,” toconin! Nani natanëhua'. Co huachi a'napitari sha'huirapicaiso' nohuantarihuahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nani huachi Yosë yaya'huërëtërinso' natanëhua'. ¿Ma'ta' onpotahua' Quisoso? tënin. —Pa'pi co noya quëmapihuë' ni'ton, tëpacaso' ya'huërin, topi ya'ipiya. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Naporahuatona', Quisoso ipitopi. Tonporayatahuatona', chiníquën panpirayapi. —Quëmaso' Cristonquën nipatan, ninoton no'tëquën sha'huitocoi. ¿Inta' ahuërinquën? itoonpi. Ponisiaro'sarinta' chiníquën ahuërayapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pitroso i'iratëquë ya'huëápirinhuë', a'na sanapi huë'nin. Corto hua'an cosonanën inaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitro napëntaquëya', inari ni'nin. Noya ni'sahuaton: —Co'ta quëmanta' Quisoso Nasaritoquë ya'huërinso' ca'tanan, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—¿Ma quëmapita' napotëranso'? Co caso' ina quëmapi nohuitërahuë', itërin. Ina quëran pipirahuaton, paira ya'coanaquë pa'nin. Naporo' atari përarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naquëranchin sanapiri quënaantarin. Quënanahuaton, huanipapisopita itapon: —Iso quëmapi Quisoso ca'tanin anta', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—¡Co'chi nohuitërahuë paya! itaantarin. Ina quëran a'napitarinta' itaantapona': —Quëmanta' Cariria piyapi pochin nonan ni'quëhuarë', Quisoso ca'tanan ipora, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—¡Co'chi nohuitërahuë paya! Yosë ni'sárinco, co cariso' nohuitërahuë'. Nonpintohuatënquëmaso', Yosë ana'intarinco, itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naporo chachin atari përaantarin. Atari natanahuaton, Quisosori napotërinso' Pitro yonquirin: “Co'huara atari catoro' përashatërasohuë', cararo' nonpinapiaranco,” itërinco, ta'ton chiníquën sëtërin. Sëtaton, na'nërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tahuërianpitohuachinara, ya'ipi cotio ansiano'sa', cotio maistro'sa', corto hua'ano'sa', inapita niyontonahuatona', ninontopi. Ina quëran Quisoso tonporahuatona', Pirato ya'huërinquë quëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—¿Quëmaso' cotioro'sa' copirnonquën ti? itërin Piratori. —Inaco mini, tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ina quëran corto hua'ano'sari na'con nonpinapipirinahuë', co manta' tëninhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","—Nani ma'sha sha'huirapipirinënquënhuë', ¿co manta' tënanhuë' ti? itaantarin Piratori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Quisososo nipirinhuë', co manta' tëninhuë'. Napohuachina: “Ma quëmapita' isoso' ni'ton, co manta' tëninhuë',” tënin Pirato yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nani Pascoa tahuëri a'nara apina'pi tashinan pëi quëran ocoirin noya pipicaso marë'. Pita tahuëri ni'ton, Noma hua'an napotërin. Insosona piyapi'sari nohuantopiso' ocoirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tashinan pëiquë copirno no'huipisopita ya'huëpi. Copirno piyapinënpita tëpapi ni'ton, tashinan pëiquë po'mopi. A'nara' Parapasë itopiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Piyapi'sa' huë'sahuatona', Pirato nontiipi. —Ipora Pascoaquënta' apina'pi ocoitaantacoi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—¿Inta' ocoichinquëma'? Copirnonëma' ocoichinquëma' topirahuë', itërin Piratori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Corto hua'ano'sari apiratona', Quisoso nani mapi. Ina nitotaton, Piratori naponontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Napoaponahuë', corto hua'ano'sari a'naya a'naya piyapi'sa' sha'huitëra'piapi. —“Co Quisososo' nohuantëraihuë'. Parapasë ocoitocoi,” itoco', itëra'piapi. Napoaton: —Parapasë ocoitocoi, tosapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—¿Ma'ta' nipachin Quisoso onpochi: “Inaso' copirnonëhuëi,” tënamaso'? itërin Piratori. Napotohuachina: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—¡Corosëquë patanantëquë' chimiin! itapi chiníquën nontatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Ma'marëta' tëpa'i? ¿Ma'ta' onporinso'? itopirinhuë', aquëtë chachin chiníquën itaantapi: —¡Corosëquë patanantëquë' chimiin! itaantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ina natanahuaton, ama piyapi'sari no'huicaiso marëhuë' Parapasë ocoitërin. Quisososo nipirinhuë', chiníquën ahuihuitërin. Chiníquën huihuitona', pë'sha pë'shatopi. Ina quëran sha'huitërin corosëquë patanantacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ina quëran sontaro'sari Pirato pëinënquë quëpapi. Pairaanaquë ichiya'conahuatona', ya'ipi sontaro'sa' amatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nani niyontonpachinara, quëhuanën miachin hua'an a'morinso pochin a'motopi tëhuacaiso marë'. Yancotënta' nahuan quëran nicatona', ayancotopi: ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—¡Hua'qui tahuëri nicaton cotioro'sa' hua'anëntëquë'! itoonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Piquirananquë ahuëmotopi. Ahuërahuatona', ipitopi. Isonahuatona', nito mosharapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Inapotatona', tëhuapi. Ina quëran quëhuanën a'motopiso ocoitahuatona', inaora a'morinso chachin a'motaantapi. Inapotahuatona', corosëquë patanantacaiso marë' quëpapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pa'sapirinahuë', a'na quëmapi Sirini parti hua'huatërinso' nacapipi. Iminën quëran huëntararin. Simon itopi. Inaso', cato' hui'ninpita ya'huëtërin, Aricantro, Nopo, inapita itopiso'. Simon nacapirahuatona', sontaro'sari Quisoso corosënën apitëntopi inari quëpatacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pantarahuatona', panëa'huayaquë canconpi huachi, Corocota itopiquë. Corocotaso': “Nansë Moto',” tapon naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Huino tanparo nimirio ayontahuatona', yao'shitopirinahuë', co o'orinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ina quëran sontaro'sari corosëquë patanantopi. Nani patanantohuachinara', “Huëco', nicanatëhua', Quisoso a'morinso' maahua',” nitatona' ya'nipirapi. Nicanatona', a'naya a'naya mapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yono pi'irirahuaso', corosëquë patanantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Onporinso marësona tëparapiso' nani ninshitopi. isoso' cotioro'sa' copirno ta'caso ninshitopi. Motën pëtëcha achinpitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Quisoso pirayan cato' apiro'santa' patanantopi. A'nara' inchinan quëran, a'nanta' ahuënan quëran acopi.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iráca Yosë quiricanënquë ninorin. “Apiro'sapitarë' acorapi,” tënin. Naporinso chachin inapitarë' acopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Piyapi'sa' na'huëpona pochin Quisoso tëcariatona', tëhuapi. —“Yosë pëinën ata'huantohuato, cara tahuëri quëran anoyatantarahuë,” tënan pora. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Inta nipachin, corosë quëran nohuararahuaton, cha'ëquë', itoonpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Inapochachin corto hua'ano'sa', cotio maistro'sa', inapitanta' Quisoso tëhuatona', itapona': —A'napitaso' nicha'ëponahuë', inaora cha'ëcasoso' co nanitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Caso' Cristoco, israiro'sa' copirnoco,” toconin. Inta nipachin, corosë quëran nohuarain nicatëhua' natëahua', nitopi. Ina pirayan patanantopisopitanta' Quisoso no'huipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Camotëchin nisahuaso', ya'ipi parti tashirin. I'huaraya huarë' yono tashi pochin ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Naporo' Quisoso chiníquën nonin. “Iroi iroi ¿nama sapacatani?” tënin. Inaora nananquë nonaton, naporin. “¿Onpoatonta' Tata patëranco?” tapon naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","A'naquën huanipapisopitari natanahuatona': —Natanco'. Iniasë përasamara, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A'na quëmapiso' manorahuaton, pi'shiro pochin nininso' maconin. Main huino asë'cotëtërin. Nara'huayaquë achinpitahuaton, inápaquë ihuëtërin o'ocaso marë'. —Tananpitëquë'. Corosë quëran anohuaracaso marë', Iniasë huë'samara, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ina quëran Quisososo' chiníquën nonsahuaton, chiminin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naporo' Yosë chinotopiso pëiquë tanontën në'mëtë' patonpiso' noshatërin. Inaora noshataton, catotë huarë' ninin. Inapa quëran no'paquë huarë' noshatomarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Onporahuatonsona Quisoso chimininso' capitani ni'sahuaton: —Tëhuënchachin iso quëmapi Yosë hui'nin, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sanapi'santa' aquë quëran notëërapi. A'nara' Maria Mactarina, a'naso' Saroma, a'nanta' Maria. Inaso' Cosi, Santiaco, inapita a'shina'. Santiacoso' hua'hua nimarinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Quisoso Caririaquë ni'so', imatona', nocomapiso'. A'napita sanapi'santa' Quisoso notëërapi. I'huamiáchin Quisoso Quirosarinquë huë'pachina, inapitarinta' imaquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ina tashiraya chinoto tahuëri ni'ton, cotioro'sa' tapatapi chinotacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","I'huararahuaso', Cosi huë'nin. Inaso' Arimatiaquë ya'huërinso'. Cotio hua'an niponahuë', noya Yosë chinotarin. “A'na tahuëri Yosë o'mararin hua'anëntiinpoaso marë',” tënin yonquiaton. Napoaton co të'huatatonhuë', Piratoquë pa'nin Quisoso nonën ma'patacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","“Co chimiyántëramarahuë',” ta'ton, capitan amatahuaton, natantërin. “¿Nani Quisoso chiminin?” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Nani mini chiminin,” itërin capitani. Napotohuachina, Cosi itapon: “Nonën quëpaquë' nipachin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Morin nani pa'anin ni'ton, corosë quëran nonën anohuarahuatona', quëpapi. So'pinahuatona', na'pi naninquë po'mopi. Ina quëran pancara'pi masho pi'napirahuatona', pa'copitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Mactarina, a'na Maria (Cosi a'shin nininso'), inapitari ni'sapi. Insëquësona Quisoso acopiso' ni'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chinoto tahuëri piquëran Maria Mactarina, Saroma, a'na Maria (Santiaco a'shin nininso'), inapita hua'sai' pa'anpi Quisoso nonën pashitonacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tomio tahuëri tashiramiachin pi'i nëhuëcharirahuaso', na'pi nanin'pa' pa'sapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Inahua capini ninontërapi. —Pancara'piquë nanin pa'copitopi pora. ¿Incha iporaso' chi'huincatërë'ponpoya? nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Canconahuatona', notëëpirinahuë', na'pi panca nipirinhuë', nani chi'huincapi ni'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na'pi naninquë ya'conahuatona', hui'napi pochin nininso' ni'pi. Huiríchin a'morahuaton, inchinan quëran huënsëarin. Ni'sahuatona', pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pa'yanasoi', inari itërin: —Ama pa'yancosohuë'. Quisoso Nasaritoquë ya'huërinso' yonisapiramahuë', co huachi isëquë ya'huërinhuë'. Corosëquë chiminaponahuë', nani nanpiantarin. Huëco' po'mopiquë ni'quirico'. Capa huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Napoaton paatoma', ca'tano'sanënpita sha'huitonco'. Pitronta' sha'huitonco' nitochin. “Quisoso'ton nani pa'sarin Cariria'pa'. I'hua sha'huitërinquëmaso chachin pa'sarin. Inatohua' quënancoantarama',” itonco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pipirahuatona', na'pi nanin quëran ta'api. Pa'pi pa'yanahuatona', ropa ropátërapi. Co manta' topihuë'. Pa'yanatona', co piyapi'sa' sha'huitopihuë'.  ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tomio tahuëri tashiramiachin Quisoso nanpiantarin. Nanpiantarahuaton, Maria Mactarina'ton ya'notërin. Ina sanapi iráca canchisë sopairo'sari ya'coancantopirinahuë', nani Quisosori inquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nani ni'pachina, pa'nin imapisopita sha'huitacaso marë'. Inapitaso' sëtatona', na'nëapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“¡Quisoso nani nanpiantarin! Cari ni'nahuë,” itopirinhuë', co natëpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ina piquëran cato' imapisopitanta' ninano quëran pipiapi. Paaquëya', Quisosori nisha pochin ya'notërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nani nohuitahuatona', ca'tano'sanënpita sha'huitoantapirinahuë', co inapita tëranta' natëpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ina quëran shonca a'nara ca'tano'sanënpita misaquë coshatasoi', Quisosori ya'notiirin. “¿Onpoatomata', iyaro'sa', co natëtëramahuë'? Co natantochináchinhuë' cancantërama nica. ‘Quisoso nani nanpiantarin. Cari ni'nahuë,’ itopirinënquëmahuë', co natëtëramahuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ina quëran itaantarin: “Ya'ipi parti, iyaro'sa', paco'. Ya'ipi piyapi'sa' noya nanan carinquëma' sha'huitëranquëmaso' sha'huitoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Insosona noya nanan natëhuachina', cha'ësapi. Aporihuanahuatona', imapachinaco, cha'ësapi huachi. Co nanamëhuë natëhuachinahuë', Yosëri ana'intarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Natëhuatama', nani ma'sha nisarama' piyapi'sa' nitotacaiso marë'. Chiníquën nanan quëchinquëma' sopairo'sa' a'pacamaso marë'. Nisha nisha nananquë nonsarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ya'huan mapatama', co manta' onpotarinquëmahuë'. Sonimaonta' nipirinhuë' o'opatama', co chiminaramahuë'. Cania'piro'sa' topinan së'huahuatama', noyatapona',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nani ca'tano'sanënpita nontohuachina, inápaquë Sinioro Quisoso panantarin. Yosëri quëpantarahuaton, inchinanën quëran ahuënsërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ina quëran ca'tano'sanënpita pa'sahuatona', Quisoso nanamën sha'huirapi. Siniorori chachin catahuarin ni'ton, ya'ipi parti sha'huira'piapi. Yosë nohuanton, piyapi a'naroáchin anoyatopi. Nani ma'sha nanitapapi ayonquicaiso marë'. Ina ni'sahuatona', “No'tëquën nontërinpoa',” topi ya'ipi piyapi'sa'. Nani huachi.");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Quisocristo isoro'paquë o'maton, nóya ninin. Na'a piyapi'sari ina naporinso' nani ninshitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ca'tano'sanënpitaso' iráca quëran huarë' imatona', naporinso' ni'pi. Nani ya'ipi no'tëquën sha'huitërinacoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Canta' ya'ipi nanamën nitotërahuë. Hua'qui' natanato, nani noyá nitotërahuë. Napoaton, iya Tiohuiro ninshichinquën, tënahuë. Quëmaso' pa'pi noya piyapinquën ni'ton, ninshitaranquën. Ya'nan nininso quëran huarë' ya'ipiya ninshitaranquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na'a piyapi'sa' nani sha'huitopirinënquënhuë', iporaso' carionta' ninshitaranquën no'tëquën nitotamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Iráca Irotisë Cotia parti hua'anëntaso', a'na corto hua'an ya'huërin, Sacariasë itopiso'. Ina huëntoa'huanënso', Apiasë huëntoa'hua, itopi. Sa'inso' Isapira itopi. Inanta' Aaron shiin, iráca corto hua'an ya'coninso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cato chachin noya Yosë imapi. Ya'ipi pënëntërinso' no'tëquën natëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sa'inso nipirinhuë' co hua'huana'pihuë'. Co a'naya tëranta' hua'huin ya'huëtërinhuë'. Nani paiya. So'ionta' nani mashoya. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A'na tahuëri Sacariasë huëntoa'huanën Yosë chinotopiso pëiquë pa'pi sirihuitacaiso marë'. Naporo' tahuëri sirihuitacaiso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Cotioro'sa' inachintopiso' imatona', Sacariasë huayonpi yonarin pochin nininso' a'pëcaso marë'. Acohuana ya'conahuaton, pimóton nininso' a'përin Yosë yonquicaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A'pëso', na'a piyapi'sa' aipiran huanirahuatona', Yosë nontapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Naporo' acohuana Sinioro anquëninëni ya'notimarin. Misa'huaya inchinan quëran huanitimarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anquëni quënanahuaton, pa'yanin. Pa'pi të'huarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anquëniriso nipirinhuë' noya nontërin. —Ama pa'yanquësohuë'. Quëmaso' Sacariasënquën, nohuitëranquën. Hua'qui' hui'nahuanacaso' nohuantopiranhuë'. Ina marë' Yosë nontëranso' nataninquën. Sa'an hua'huanarin. Huaihuachin, nininën cari sha'huitaranquënso' acotëquë'. Coansha itëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nasitohuachin, noya cancantaran. Na'a piyapi'sari pa'yatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Inaso' nóya quëmapi nipon. Yosëri catahuaarin ni'ton, noya noya nisarin. Naporahuaton, co pi'pian tëranta' main o'oponhuë'. Co'huara nasichátëraponhuë', Ispirito Santori ya'coancantarin. Inasáchin natëarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mashotohuachin, pënëntapon. Pënëntohuachin, na'a israiro'sa' Yosë yonquiantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iráca Iniasë pënëntërinso pochin nóya pënëntarin. Ina pochin chiníquën nanantarin inanta'. Sinioro yao'mahuachin, pënëntapon. Pënëntohuachin, quëmapi'sa' hui'ninpitarë' noya ninontantapona'. Iporaso' a'naquën co Yosë natëpirinahuë'. Ina natanahuatona', no'tëquën yonquiapona'. Inari a'chintohuachin, Sinioro nohuantapona huachi, itërin anquëniri. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—Caso' mashoyaco. Sa'ahuënta' nani paiya. ¿Inaporo'pocoita'ma nica? ¿Onporahuatota' no'tëquën nitochi? tënin Sacariasë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—Caso' Capirico. Yosë ya'huërin quëran o'marahuë. Ina a'paimarinco nonta'huanquënso marë'. Noya nanan sha'huitopiranquënhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Co natërancohuë' ni'quëhuarë', hua'qui' co nonsaranhuë'. Hui'nan nasitaquë huarë' co nonacamaso' nanitaranhuë'. Napoaponahuë', no'tëquën nontëranquën. Hui'nahuanaran. Tahuërinën nanihuachin, sa'an huaiarin, itërin anquëniri. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Piyapi'saso nipirinhuë' Sacariasë ninatona': “¿Onpoatonta' hua'quiarin?” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ina quëran acohuana quëran pipipirinhuë', co huachi nanitërinhuë' nonacaso'. Imirin quëran anquitaponahuë', co nanitërinhuë' piyapi'sa' nontacaso'. “Acohuana ya'conin quëran, Yosë nohuanton, hua'narëso pochin quënamara,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nani Yosë chinotopiso pëiquë sirihuitohuachina, Sacariasëso' ya'huërin'pa' paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ina quëran co hua'quiya quëranhuë' sa'in cayorin huachi. A'natërápo yoqui pochin co intoaso' pa'ninhuë'. Pëinënquë ya'huárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ma noyacha Yosë catahuarinco ni'ton, hua'huanarahuë paya. Ina nohuanton, co huachi tapan ya'huëtarincohuë',” tënin yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nani saota yoquitohuachina, naquëranchin anquëni isoro'paquë o'mantarin, Capiri itopiso'. Nasaritoquë Yosëri a'paimarin, Cariria parti ya'huërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Inaquë a'nara nanon ya'huërin, Maria itopiso'. Cosiri nani nontërin macacaso marë'. Tata masho Tapi shiin inaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anquëni o'marahuaton, Maria itapon: —I'huata Maria. Sinioro noya ni'ninquën. Ina chachin catahuarinquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ina natanahuaton, Maria pa'yanin: “¿Ma'marëta' napotërincoso'?” tënin yonquinënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","—Ama Maria, pa'yanquësohuë'. Yosë noya ni'ninquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Natanco sha'huichinquën. Quëmaso' hua'huanaran. Quëmapia'huaya huaihuatan, Quisoso itëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Mashotohuachin, chiníquën nanantarin. Inaso' Yosë hui'nin. Yosë nohuanton, copirno ya'conarin. Iráca Tata masho Tapi israiro'sa' noya hua'anëntopirinhuë'. Ina quëran chiminin. Iporaso nipirinhuë' hua'huani hua'anëntomiatarin. Co onporonta' pipirarinhuë', itërin anquëniri. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—¿Onporahuatota' hua'huanapo? Co caso' quëmapi së'huayátërarincohuë', itërin Mariari. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Ispirito Santo nohuanton, quëmaora hua'huanaran. Yosë topinan yonquiarapirinquënhuë', cayoaran. Napoaton hua'huan, Yosë hui'nin chachin nisarin. Co pi'pisha tëranta' oshahuanaponhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ni'quë'. Quëmopinën Isapira itopiso' paiya niponahuë', Yosë nohuanton nani cayorin. Co hua'huana'pihuë' niponahuë', nani saota yoquitarin. Quëmapia'huaya huaipon. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yosë ya'ipi nanitaparin, itërin anquëniri. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Inta nipachin. Yosëíchin caso' natëarahuë. Ina nohuanton, hua'huahuë ya'huë'in nipachin, tënin Maria. Napotohuachina, anquëni pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ina quëran manorahuaton, Mariaso' Cotia motopiro'sa parti pa'nin quëmopinën nicapon. Inaquë canconahuaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sacariasë pëinënquë ya'conconin. Isapira quënanconahuaton, —I'huata a'shacha, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ina natanahuaton, hua'huin yo'namënquë to'mo to'mótarin. Isapiranta' nóya cancantërin. Ispirito Santori noyá ya'coancantërin ni'ton, ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","pa'yataton, chiníquën itapon: —I'huata hua'huata'hua. ¡Ma noya Yosë catahuarinquën! A'napita sanapi'sa quëran noya noya ni'ninquën. Hua'huaonta' noya noya ni'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Inaso' ya'ipiya hua'anëntarinpoa'. Co caso' chiníquën nanantopirahuë', ¡ma noyacha ina a'shinquën nipiranhuë', nicaponco huë'nan paya! ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quëma nontohuatancora, a'naroáchin hua'huahuënta' yo'namëhuëquë to'mo to'mótarin. Noya cancantaton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Yosë no'tëquën nontërinco,” tënanso marë' inaso' noya ni'ninquën. Sha'huitërinquënso chachin acotarinquën, itërin Isapirari. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ina quëran Maria tapon: “Ma noyacha Tata Yosëso paya, tënahuë canta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Anoyacancantërinco ni'ton, nóya cancantërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Topinan piyapico nipirahuë', yonquirinco. Ipora quëran huarë' na'a piyapi'sa' nohuitarinaco. ‘Ma noyacha Yosëri catahuarin paya,’ tosapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yosëso' ya'ipi nanitaparin. Inaso' nóya catahuarinco. Noya noya ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iráca chinotopisopitanta' nosororin. Ipora huanta' ina chinotohuatëhua', nosoroarinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Chiníquën nanantaton, nani ma'sha ninin. Nocantopisopita atapanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Copirnoro'santa' co noyahuë' nipachinara, ocoirin. Topinan piyapi'sa' ya'huërë' noya acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pahuantërinsopita catahuarin nóya ya'huëcaiso marë'. Ma'huano'saso nipirinhuë', topinan a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israiro'sa' na'con catahuarin. Piyapinënpita ni'ton, nosororin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Iráca Apraan nontaton, ‘Nosororanquën. Quëma shiparinpitanta' nosoroato, catahuaarahuë,’ itërin Yosëri. Ina yonquiaton, ipora catahuarinpoa huachi,” tënin Maria. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Cara yoqui pochin inaquë yacapatërin. Ina quëran ya'huërin'pa' paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isapira nani tahuërinën nanihuachina, huairin. Quëmapia'huaya huairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Quëmopinënpita, ya'cariya ya'huëpisopita, inapita natantopi. “¡Ma noya Yosëri catahuarin ni'ton, noya huairin! ta'tona',” nóya cancantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hua'huasha posa tahuëritohuachina, marca yaacotopi. “Niapoquë'. Sacariasë itëquë',” itopi a'naquëni. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A'shinso nipirinhuë', co nohuantërinhuë'. —Coansha itarai, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Ama nisha nininën acotëquësohuë'. Quëmopinënáchin apoquë'. Ina noya, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ina quëran pa'pin ipora huanta' në'huë ni'ton, imirin quëran tasatopi nininën nitotacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pa'pinso' quirica ma'patahuaton, ninshitërin. “Coansha itarahuë,” tënin ninshitaton. Ina nicatona': “¡Ma'pitacha yonquirin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Naporo' në'huërinso' inquirahuaton, a'naroáchin noantarin huachi. “¡Ma noyacha Tata Yosëso' ni'ton, catahuarinco paya!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ina ni'sahuatona', piyapi'sa' pa'yanpi. Ya'ipi Cotia parti nanan nahuinin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ina natanatona', yonquiapi. “¿Ma'ta' onpoapon iso hua'huasha ni'ton, ipora quëranchin Yosëri na'con na'con catahuararin?” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ina quëran Ispirito Santori noyá ya'coancantohuachina, Sacariasënta' tapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Ma noyacha Tata Yosëso' hua'anëntërinpoa paya! Piyapinënpitanpoa' yonquiatonpoa', nicha'ësarinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ina nohuanton, Tata masho Tapi shiin chachin nicha'ësarinpoa'. Inaso' chini chiníquën nanantapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iráca quëran huarë' pënëntona'piro'sa' ninopi. Yosë nohuanton, sha'huitërinënpoa': ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘A'na tahuëri nicha'ësaranquëma'. Co huachi inimicoro'sa' minsëarinënquëmahuë'. No'huipirinënquëmahuë', nicha'ësaranquëma',’ tënin Yosë, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iráca shimashonënpoapita nosoroaton, naporin. Ipora huanta' nosororinpoa'. Sha'huitërinso' co Yosëri naniantërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tata masho Apraan sha'huitërinso' yonquirárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Napoaton nicha'ësarinpoa'. Co huachi inimiconënpoapita' minsëarinënpoahuë'. Ina quëran co të'huatatëhuahuë', Yosë chinotarihua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ina pochin cancantatëhua', inasáchin chinotarihua'. Chiminaquë huarë' nóya nisarihua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Quëmanta', conpa, Yosë a'paarinquën piyapinënpita pënënacaso marë'. Sinioro isoro'paquë yao'marin ni'ton, pënëntaran piyapi'sari natëcaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yosë piyapinënpita itapon: ‘Oshanëma' inquitatënquëma', Sinioro anoyacancantarinquëma',’ itaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yosë nosoroatonpoa', inápa quëran a'pintimarinpoa'. Pi'i a'pintërinpoaso pochin no'tëquën anitotërinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tashinan pochin cancantopirëhuahuë', a'pintatë pochin nitarinpoa' noya nanpicaso marë'. Anoyacancantohuachinpoa', sano cancantarihua',” tënin Sacariasë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ina quëran hui'ninso' so'sorahuaton, hui'napitarin huachi. Yosë yonquiarin ni'ton, chiníquën cancantarin. Inotëro parti ya'huëárin. Ina quëran oshaquëran Yosëri sha'huitërin israiro'sa' pënënacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Naporo' tahuëri'sa' Noma copirno nanan a'parin, Aocosto itopiso'. Ya'ipi parti a'parin. “Ya'ipinquëma' paco'. Quiricaquë nininëma' niacotoco',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Naporo huarë' ya'ipi piyapi'sa' pichirapi. Sirinioso' Siria parti hua'anëntohuachina, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Natanahuatona', ya'ipi piyapi'sa' pa'pi nininëna' niacotacaiso marë'. Hua'huatopiso' ninanonënaquë pa'pi. Nisha nisha pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cosiso' Cariria parti ya'huërin. Nasaritoquë ya'huëpirinhuë', ina quëran pipirahuaton, Cotia parti pa'nin. Inaquë canconahuaton, Pirin'pa' pa'nin. Iráca Tata masho Tapi inaquë hua'huatërin. Ina shiin ni'ton, inaquë pa'nin nininën niacotacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mariarë chachin pa'nin. Nani ina macacaso marë' nontaponahuë', Yosë nohuanton, inaora cayorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nani naniarin huaicaso' ni'ton, inatohua' ni'so', huairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Paninan huairin, quëmapia'huaya. Në'mëtërinquë so'quëëtahuaton, nona'huayaquë acorin, ohuaca coshatërinquë. Huë'ëcaiso' pëi' nani ya'sotopi ni'ton, co inaquë huë'ëpatërinhuë'. Napoaton nona'huayaquë hua'huin acorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Naporo' tashi' ohuica pë'tahuana'piro'sa' pastoquë ya'huërapi. Pirin ya'cariya ya'huërapi. Tashirë chachin ohuicanënapita a'pairapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Inaquë ni'soi', a'nanaya Sinioro anquëninëni ya'notimarin. Huënaráchin huënaráchin a'pintimarin. Yosë pochin a'pinin. Anquëni quënanahuatona', quëmapi'sa' pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anquëniriso' itapon: “¡Ama pa'yancosohuë'! Noya nanan sha'huichinquëma' ya'ipi piyapi'sa' noya cancantacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ipora tashi' a'nara quëmapia'huaya Pirinquë nasitërin. Inaso' Cristo, Yosëri a'paimarinso'. Sinioro ni'ton, chinotacaso' ya'huërin. Nani o'marin piyapi'sa' cancanëna' anoyatacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inaquë pa'patama', hua'huishin quënanconarama'. Në'mëtërinquë so'quëëtahuatona', ohuaca coshatërinquë acopi. Ina quëran nohuitarama',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ina quëran a'naroáchin na'a anquëniro'sari ya'notantapi. Yosë chinotatona', itapona': ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Ma noyacha Yosëso paya! Inápaquë ya'huaponahuë', piyapinquëma' yonquirinquëma'. Cancantatoma ina yanatëramasopitaso' sano cancantarama',” itopi anquëniro'sari. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nani inápaquë panantahuachinara, pë'tahuatona'piro'sa' ninontopi. —Pirin'pa' pa'ahua' nipachin. Sinioro anitotërinpoaso' nia'ahua', nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Manorahuatona', pa'pi. Canconahuatona', hua'huasha, Maria, Cosi, inapita quënanconpi. Hua'huasha ohuaca coshatërinquë quëhuëánin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nani ni'sahuatona', na'a piyapi'sa' sha'huitëra'piapi. “Quëmapia'huaya nani nasitërin. Inaso' Cristo, Yosëri a'paimarinso'. Anquëni sha'huitiimarincoi,” itëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Natanahuatona', “Ma'pítacha itërinpoa' paya,” topi ya'ipi piyapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaso nipirinhuë' naporinso' na'con yonquirárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ina quëran pë'tahuatona'piro'sa' paantapi. “Ma'pítacha natanëhua paya. Ma'pítacha ni'nëhua paya. Anquëniro'sa' itërinpoaso chachin quënanëhua'. ¡Ma noyacha Tata Yosëso paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hua'huasha posa tahuëritohuachina, marca acotopi. Naporo' nininën acotopi huachi. Quisoso itopi. Co'huara Maria hua'huayantërasohuë', anquëniri sha'huitërin ina nininën acocaso' ni'ton, napotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisësë iráca pënëntërin: “Sanapi huaihuachin, a'na yoqui pochin nina'in. Ina quëran Yosë chinotopiso pëiquë ya'coanta'in,” tënin. Cotioro'sa' napopiso chachin a'na yoqui pochin nanihuachina, Maria, Cosi inapitaso Quirosarin'pa' paantapi pënëntërinso' natëcaso marë'. Naporo' hua'huin Yosë chinotopiso pëiquë quëpapi inaquë Yosë nontacaiso marë'. “Iso hua'huasha, Sinioro, noya a'paiquë' quëma piyapinën niin,” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","“Paninanso' quëmapi nipachin, Yosë piyapinën ninin,” tënin Moisësë iráca pënëntaton. Napoaton ina pochin nontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naporo' cato' nëpëhuë nipon, cato' pë'tahua nëpëa'huahuë nipon atëpatopi Yosë chinotacaiso marë'. Inanta' Moisësë pënëntërin ni'ton, inapopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Quirosarinquë chachin a'na quëmapi ya'huërin, Simion itopiso'. Nóya quëmapi inaso'. Nani tahuëri Yosë chinotërin. “A'na tahuëri Yosë nicha'ësarinpoa',” ta'ton, Cristo a'paimacaso' ninarárin. Ispirito Santori noyá ya'coancantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ina nohuanton, Simion nani ninorin. “Siniorori a'paimarinso' nohuitapo. Co'huara chimiyantërapohuë', Cristo o'mararin, ni'sarahuë,” tënin yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Naporo' tahuëri Ispirito Santo nohuanton, Yosë chinotopiso pëiquë pa'nin anta'. Cosinta' sa'inë chachin inaquë nisapi. Pënëntopiso' natëtona', inaquë Quisosoa'huaya quëpapi ni'ton, Simioni quënanconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hua'huasha quënanahuaton, Simion nóya cancantërin. Iporahuaton, Yosë nontërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“¡Ma noyanquëncha quëmaso', Sinioro, ni'ton, a'paimaranso' nani anohuitëranco paya! Napoaton noya ipora caso' chimiin, tënahuë. Sha'huitërancoso chachin nanirin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iso hua'huasha nani ni'nahuë. Nicha'ëincoiso marë' a'paimaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ya'ipi piyapi'sa' yonquiaton, a'paimaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nisha nisha nananquë nonpisopita a'pintarin no'tëquën yonquicaiso marë'. Israiro'santa' catahuaarin. Piyapinënpita ni'ton, noya noya acorarin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ina natanahuaton, “¡Ma'pítacha naporin paya!” tënin Cosi. Marianta' inachachin yonquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","—Yosë noya a'painquëma', itërin Simioni. Ina quëran a'shin itantapon: —Hua'huan mashotohuachin, ya'ipi israiro'sa' pënënarin. Natanahuatona', a'naquën natëtona', noya cancantapi. A'naquënso nipirinhuë' co nohuantapihuë' ni'ton, anotërëso pochin nisapi. Yosë nohuitacaiso marë' no'tëquën pënëntapirinhuë', chiníquën no'huiapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Inahuara cancanëna quëran nisha nisha yonquiapirinahuë', inari a'ninquëchin anitotarin. Hua'huan no'huihuachina', quëmaso' chiníquën sëtaran. Sahuëniquë ohuaninënposo pochin sëto ya'coancantarinquën huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A'na sanapinta' inaquë ya'huërin, Ana itopiso'. Inaso' Panino hui'nin, Asirë huëntonquë ya'huërinso'. Yosë nohuanton, nitoninorin. Nani paiya. Nanon nipon, a'na quëmapiri manin. Canchisë pi'ipiachin niquëpasoi', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","so'ini ayananpirin ni'ton, nani hua'qui' quëyoronin. Nani posa shonca catapini pi'ipitërin. Yosë chinotopiso pëiquë ya'huëmiatërin. Tahuërirë chachin, tashirë chachin Yosë chinotërin. Apira apira Yosë yonquirin. Co cosharo' yonquiatonhuë', Yosë nontárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naporo' inanta' huëcaton, Quisosoa'huaya ni'nin. Noya cancantaton, Yosë nontërin. —Iso hua'huasha nasitërinso marë': “Yosparinquën Sinioro,” itëranquën, tënin. Ina quëran Yosë imapisopita sha'huitërin. —Yosë nohuanton, a'paimarinso' nani nasitërin. Inaso' nicha'ësarinpoa', itërin. Na'a Quirosarinquë ya'huëpisopita ina ninarapi ni'ton, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ya'ipi iráca pënëntërinso' nani natëhuachinara, Cosiso sa'inë chachin Cariria parti paantarin. Nasaritoquë ya'huantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Quisoso so'sorahuaton, chinirarin. Nóya yonquirin. Yosëri na'con catahuarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nani Pascoa tahuëri a'shin, pa'pin, inapita Quirosarinquë pantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Quisoso shonca cato' pi'ipitohuachina, naquëranchin pantapi cotio niyontonpiso tahuëri na'huëcaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nani na'huëhuachinara, ya'huëpi'pa' pa'mantapirinahuë', Quisososo' co pa'marinhuë'. Hui'napi niponahuë', inaquë inaora quëparitërin. A'shinso' co nitotërinhuë'. Cosinta' co nitotërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Na'a piyapi'sa' pa'sapi ni'ton, “Nisha huë'sarin,” ta'tona', a'na tahuërira' iratopirinahuë'. I'huanahuanquë Quisoso yonisápirinahuë', co quënanpihuë'. Quëmopinënpita, nohuitopisopita, inapita natanpirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","co quënanpachinarahuë', yonicaiso marë' inatohua chachin paantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cara tahuëri quëran Yosë chinotopiso pëiquë quënanpi huachi. Maistro'sa' a'chinpiquë huënsërahuaton, a'chinpiso' natanarin. Natanahuaton, natantaantarin anta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na'a piyapi'sa' natanpi. “Ma noyacha yonquirin paya. Nóya a'panitërin,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Inaquë quënanahuatona', a'shinso' pa'yanin. —¿Onpoatonta' hua'hua napotërancoi? Ni'quë'. Pa'yanatoi, cara tahuëri yonisápirainquënhuë', ipora huarë' quënanainquën huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿Onpoatonta' yonisápiramacohuë'? Tatahuë pëinënquë ya'huëca'huaso' ¿co nitotëramahuë' ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Natanaponahuë', ma'sona tapon naporinso' co nitotopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ina quëran pipihuachina, a'shin, pa'pin inapitarë' Nasaritoquë paantarin. Inaquë paaton, a'shin, pa'pin, inapita noya natërin huachi. Naporinso' a'shini cancanën quëran yonquirárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naporahuaton, Quisoso hui'napitarin huachi. Noya noya yonquirin. Yosëri noya ni'nin. Piyapi'sarinta' noya ni'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Naporo tahuëri'sa' Tipirio itopiso', Noma copirno ya'conin. Nani shonca a'natërápo pi'ipi hua'anëntarin. Ponsio Piratonta' Cotia parti hua'anëntarin. Irotisëso', Cariria parti hua'anëntarin. Iin Pinipi itopisonta', Itoria parti, Traconiti parti, inapita parti hua'anëntarin. Nisaniasëso' nipirinhuë', Apirinia parti hua'anëntarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasë, Caihuasë, inapita corto hua'an chini chiníquën nanantërinso' ya'conpi. Naporo' Coansha pënëntarin. Sacariasë hui'nin inaso'. Inotëro' parti ya'huaso', Yosëri sha'huitërin paaton pënëntacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Napoaton ya'ipi Cortanii' parti pa'taton, pënëntárin. —Co noyahuë' yonquiramasopita naniantatoma', Yosë tahuërëtantaco' oshanëma' inquichinquëma'. Ina quëran aporintaranquëma', itëra'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iráca Isaiasë ninorin. Ninshitaton, naporin: “Inotëro parti a'na quëmapi pënëntápon. ‘Sinioro o'macaso' tahuëri yonquico'. Ni'co'. Hua'an chiníquën nanantona'pi ni'ton, a'na parti yapa'pachina, comisionën a'parin ira tapatacaso marë'. Ira otëërin noya pa'tacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iconantëro'sa' amëntarotarin. Panëno'sa' taparoarin. Co'shoninsopita otëarin. Tomashin acoarin. Ira noya tapahuachina, hua'an pa'nin huachi. Inapochachin iporaso' co noyahuë' yonquiramasopita naniantatoma', cancanëma' anoyatoco' Sinioro o'main. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya'ipi piyapinpoa' nicha'ëinpoaso marë' o'mararin,’ tapon ina quëmapi pënëntohuachin,” tënin Isaiasë iráca ninoton. Naporinso chachin Coansha pënëntarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A'naquën aporihuanacaiso marë' huë'pirinahuë', Coanshariso', co yaaporintërinhuë': —Canpitaso' ya'huan pochin cancantatoma', yanonpinama'. “Yosë isoro'pa' ana'intohuachin, cha'ëpoi quiyanta',” ¿topiramahuë ti? Topinan aporihuanpatama', co cha'ësaramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Co noyahuë' yonquiramasopita naniantatoma', noya nico'. Ama ninonpintocosohuë'. “Quiyaso' Apraan shinpitacoi ni'toi, Yosë piyapinënpitacoi,” ama tocosohuë'. Yosë nohuantërin naporini, iso na'piro'santa' Apraan shinpita atarantacaso' nanichitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nani Yosë yonquirin oshahuano'sa' ana'intacaso'. Ni'co'. Nararo'sa' co noya nitohuachinahuë', nicosotërë'. Nicosotahuatë', pënquë të'yatërë' huiquitacaso marë'. Inapochachin canpitanta' co noyahuë' nipatama', chiníquën ana'intarinquëma', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Ma'ta' onpo'ii nipachin? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Piyapi'sa ma'shari pahuantohuachina, ama apiratocosohuë'. Cato' a'mocamaso ya'huëtohuachinquëma', a'nara' quëtoco' a'mo'in. Tanahuachina', a'caco' ca'in, itërin Coanshari. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A'napitanta' aporihuanacaiso marë' huë'pi. Inapitaso' coriqui copirno marë' ma'patona'piro'sa'. —¿Ma'ta' maistro quiyaso' onpo'ii? itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—No'tëquën coriqui ma'patoco'. Ama nonpinatoma', na'con na'con ma'patocosohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sontaro'santa' huë'pi. —¿Ma'ta' quiyanta' onpo'ii? itiipi. —Ama piyapi ahuëatoma', coriqui matocosohuë'. Ama canacaso marë' nonpinapicosohuë'. Nani pahuërëhuachinquëma', ama na'con na'con nohuantocosohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Piyapi'saso' yonquirapirinahuë'. “¡Ma noyacha Coanshaso' pënëntërin paya! Inaso' Cristo nimara. Nicha'ëinpoaso marë' ¿Yosëri a'paimamara ti?” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ina natanahuaton, Coanshari itërin: —Aporintëranquëma mini nipirinhuë', co caso' Cristocohuë'. Ca piquëran inaso' huë'sarin. Inaso chini chiníquën nanantërin. Caso' co pi'pisha tëranta' ina pochin chiníquën nanantërahuë'. Co maquëyancohuë' ni'ton, co sapatën i'quirita'huaso tëranta' nanitarahuë'. Inaso' huë'pachin, a'naquëma' Ispirito Santo aya'coancantarinquëma'. A'naquëmaso nipirinhuë', pënquë chiníquën ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cayarinso' manëso pochin nisarin. Arosë mapatëra, to'norarë'. Ina quëran pintiarahuatë', pëiquë acorë'. Sha'huëtënso nipirinhuë' pënquë ahuiquitërë'. Inapochachin ana'intohuachinquëma', co onporonta' pën tacopiarinhuë', tënin Coansha. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nani tahuëri ina pochin piyapi'sa' pënënárin. Yosë nanamën a'chintárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Irotisënta' hua'an nipirinhuë' pënënin. “Quëmaso' pa'pi co noyahuë' ninan. Naporahuaton, iyaparin sa'in osërëtaton, manan. Pinipi sa'in chachin manan. Irotiasa itopiso'. Ina marë' oshahuanan,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Napotohuachina, Irotisëso' aquë aquëtë' co noyahuë' yonquiaton, Coansha tashinan pëiquë apo'motërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Co'huara apo'mochatërasohuë', Coanshari piyapi'sa' aporintahuachina, Quisosonta' huë'nin aporihuanacaso marë'. Nani aporihuanahuaton, Yosë nontërin. Nontaso', pi'iro'të' ni'soatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ispirito Santo nëpë pochin nohuaraimarahuaton, Quisoso ya'coancantomiatërin. Naporo' inápa quëran Yosëri itërin: —Quëmaso' hui'nahuënquën chachin ninan. Na'con nosoroatënquën, nóya ni'nanquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ya'nan pënëntapon, Quisoso cara shonca pi'ipitërin. Cosi hui'nin, topirinahuë'. Cosi pa'pinso' Iri itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Iri pa'pinta' Matato itopi. Ina pa'pinso' Nihui itopi. Nihui pa'pinta' Miriqui itopi. Ina pa'pinso' Cana itopi. Cana pa'pinta' Cosi itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Cosi pa'pinso' Matatiasë itopi. Ina pa'pinta' Amosë itopi. Amosë pa'pinso' Naomo itopi. Ina pa'pinta' Isiri itopi. Isiri pa'pinso' Nacai itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ina pa'pinta' Maato itopi. Maato pa'pinso' Matatiasë itopi. Ina pa'pinta' Simi itopi. Simi pa'pinso' Cosico itopi. Ina pa'pinta' Cota itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Cota pa'pinso' Coanan itopi. Ina pa'pinta' Nisa itopi. Nisa pa'pinso' Soropapiro itopi. Ina pa'pinta' Saratiro itopi. Ina pa'pinso' Niri itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri pa'pinta' Miriqui itopi. Miriqui pa'pinso' Ati itopi. Ina pa'pinta' Cosamo itopi. Cosamo pa'pinso' Irmatamo itopi. Ina pa'pinta' Iri itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iri pa'pinso' Cosoi itopi. Ina pa'pinta' Irisiro itopi. Ina pa'pinso' Corimo itopi. Ina pa'pinta' Matato itopi. Ina pa'pinso' Nihui itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nihui pa'pinta' Simion itopi. Ina pa'pinso' Cota itopi. Ina pa'pinta' Cosi itopi. Cosi pa'pinso' Conamo itopi. Ina pa'pinta' Iriaquimo itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ina pa'pinso' Miria itopi. Ina pa'pinta' Mina itopi. Ina pa'pinso' Matata itopi. Ina pa'pinta' Natano itopi. Ina pa'pinso' Tapi itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tapi pa'pinta' Quisi itopi. Ina pa'pinso' Opito itopi. Ina pa'pinta' Pooso itopi. Ina pa'pinso' Sara itopi. Sara pa'pinta' Nasono itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasono pa'pinso' Aminatapo itopi. Ina pa'pinta' Atamino itopi. Ina pa'pinso Arni itopi. Arni pa'pinta' Isromo itopi. Isromo pa'pinso' Parisë itopi. Ina pa'pinta' Cota itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ina pa'pinso' Cacopo itopi. Cacopo pa'pinta' Isaco itopi. Isaco pa'pinso' Apraan itopi. Apraan pa'pinta' Tari itopi. Ina pa'pinso' Nacoro itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacoro pa'pinso' Siroco itopi. Ina pa'pinta' Nacao itopi. Nacao pa'pinso' Parico itopi. Ina pa'pinta' Ipiri itopi. Ipiri pa'pinso' Sara itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ina pa'pinta' Cainano itopi. Cainano pa'pinso' Arapasato itopi. Ina pa'pinta' Simo itopi. Simo pa'pinso' Noi itopi. Noi pa'pinta' Namico itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Namico pa'pinso' Matosarino itopi. Ina pa'pinta' Inoco itopi. Inoco pa'pinso' Carito itopi. Ina pa'pinta' Marariro itopi. Ina pa'pinso' Cainano itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ina pa'pinta' Inosë itopi. Inosë pa'pinso' Sito itopi. Ina pa'pinta' Atan itopi. Atanso' Yosëri ninin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Quisoso Cortani quëran pipirahuaton, huëantarin. Ispirito Santori noyá ya'coancantërin. Inasáchin natërin. Naporo' ina nohuanton, inotëro parti pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Inaquë catapini shonca tahuëri ya'huërarin. Naporo' sopairi huëcapairahuaton, sha'huitopirinhuë' ama Yosë natëcaso marëhuë'. Catapini shonca tahuëri ya'huaponahuë', co manta' ca'ninhuë'. Ina piquëran tanarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tanahuachina, sopairi itërin: —Tëhuënchachin Yosë hui'ninquën nipatan, iso na'pi cosharo' atarantëquë', itopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—Inca co nohuantërahuë'. Yosë quiricanënquë pënëninpoa': “Co cosharoriáchin piyapi ananpirinhuë'. Ya'ipi Yosë nanamën natëhuachin tëhuënchinso' nanpiarin,” tënin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ina quëran a'na motopi'pa' sopairi quëparin. Ya'ipi ninanoro'sa', ma'shanënpita, inapita a'notërin. A'naroáchin noyápiachin nininsopita, ya'ipi quënanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Ya'ipi isopita hua'anëntato, carinquën quëchinquën inapita hua'anëntamaso marë'. Chiníquën nanan quëchinquën. Insosona nohuantërahuëso' nanitërahuë quëta'huaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isonahuaton, chinotohuatanco, catahuaaranquën ya'ipiya hua'anëntamaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—Inca co nohuantërahuë'. Yosë quiricanënquë sha'huitërinpoa'. “Sinioroíchin chinotëquë'. Inasáchin natëcaso' ya'huërin. Inaso' hua'anëntërinpoa',” tënin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ina quëran Quirosarin'pa' quëpaantarin. Yosë chinotopiso pëi a'canpiquë huarë' quëparahuaton: —Tëhuënchachin Yosë hui'ninquën nipatan, no'paquë niiquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Quiricanënquë nani sha'huitërinquën: “Yosë, anquëninënpita a'patimarinquën, co ma'sha onpoaranhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Imirina quëran masarinënquën ama na'piquë tëranta' ya'quiamaso marëhuë',” tënin ni'ton, no'paquë niiquë' a'painënquën, itërin sopairi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","—Inca co nohuantërahuë'. Yosë quiricanënquë pënëninpoa'. “Ama Yosë tëniquësohuë'. Ama camaiquësohuë'. Ina nohuantërinsoáchin yonquicaso' ya'huërin,” tënin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nani hua'qui' sopairi sha'huitopirinhuë', co yanatërinhuë'. Napoaton patërin. “A'na tahuëri minsëapo nimara,” ta'ton, pa'nin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ina quëran Cariria parti Quisoso paantarin. Ispirito Santori noyá ya'coancantërin ni'ton, catahuarin nóya nicacaso'. Ya'ipi naporinso' nahuinin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nisha nisha niyontonpiso pëiquë a'china'piarin. A'chinpachina: “Ma noyacha yonquirin paya,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ina quëran Nasaritoquë paantarin. Inaquë so'sorin. Chinoto tahuëri nanihuachina, niyontonpiso pëiquë pa'nin. Nani simana inaquë pa'nin ni'ton, naporo' paantarin. Inaquë ya'conahuaton, Yosë quiricanën nontacaso marë' huanirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaiasë pënëntërinso' quirica quëtohuachina, manin. Oporinahuaton, nontërin natanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Sinioro ispiritonën ya'coancantërinco ni'ton, noya catahuarinco. Na'a piyapi'sa' co Yosë nohuitatonahuë', nosorotopi. Napoaton Yosë acorinco noya nanan a'chinta'huaso marë'. Sopairi minsëpirinhuë', ocoiarahuë noya yonquicaiso marë'. Somaraya nininsopita anoyatarahuë. Parisitapisopita nicha'ësarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ipora tahuëri'sa' Yosë nosoroatënquëma', nicha'ësarinquëma huachi, tënahuë. Ina sha'huica'huaso marë' acorinco,” tënin Isaiasë, itërin quirica nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Quirica so'nanahuaton, niyontonpiso' pëiquë catahuatona'pi quëtaantarin. Ina quëran huënsëhuachina, ya'ipi inaquë ya'huëpisopitari ni'sápi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","—Tëhuënchachin iyaro'sa' iráca Isaiasë ninorincoso chachin, Yosë a'paimarinco nicha'ëca'huanquëmaso marë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ya'ipiya natantapi. “Ma'pítacha nitotaton, naporin paya. Nóya a'chintërinpoa',” ta'tona': —¿Co'na iso' Cosi hui'ninhuë'? topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ina quëran Quisosori itaantarin: —Iráca quëran huarë' napopi: “Nitoanoyatohuatan, quëma'ton nianoyatëquë' ni'ii,” topi. Ina pochin canpitanta' yonquirama' tënahuë. “Capinaomoquë na'a cania'piro'sa' a'naroáchin anoyatëran ni'quëhuarë', isëquënta' anoyatëquë' ni'ii,” itaramaco, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ina quëran itaantarin: —Co yanatëtomacohuë', napotëramaco. Ni'co'. Pënëntona'pi pënëntohuachina, nisha nisha parti noya natanpi. Ninanonënquë ya'huëpisopitariso nipirinhuë', co noya natanpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tëhuënchachin iráca Iniasë pënëntona'pi nanpipon, cara pi'ipi miria co pi'pian tëranta' o'naninhuë'. Ya'ipi parti tanarotopi. Naporo' na'a quëyorono'sa' Israiroquë ya'huëpirinahuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","co Yosëri catahuarinhuë'. A'na quëyoronso nipirinhuë' Saripitaquë ya'huërin, Siton parti ya'huërinso'. Nisha sanapi niponahuë', Yosëri catahuarin. Inaquë Iniasë a'parin cosharonën ana'atacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Irisio pënëntona'pinta' nanpiso', na'a chana caniori maninsopita Israiro no'paquë ya'huëpirinahuë', co a'naya tëranta' anoyatërinhuë'. Namanoso' Siria piyapi niponahuë', Yosë nohuanton, anoyatërin. A'naroáchin canio inquirin, tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ina natanahuatona', ya'ipi piyapi'sa' chiníquën no'huitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Manorahuatona', ninano quëran quëpapi. Ina yonsanquë tahuan ya'huërin. Inatohua' quëpapi të'yatacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yatë'yatopirinahuë', Quisososo' huancánachin paaton, noya cha'ërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ina quëran Cariria parti paantarin. Capinaomoquë paaton, chinoto tahuëri a'chiantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chiníquën nanantona'pi pochin a'chinarin ni'ton, natanahuatona', pa'yanpi. “Ma noyacha a'chintërinpoa paya,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Niyontonpiso pëiquë chachin a'na quëmapi ya'huërin. Sopairi ya'coancantërin ni'ton, pa'pi co noyahuë' yonquirin. Quisoso quënanahuaton, chiníquën nontërin. Sopairi chachin ichinonin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Tananpitocoi! ¿Ma'ta' onpotaponcoi? ¿Ata'huantaponcoi ti? Nohuitërainquën. Quëmaso' Quisosonquën, Nasaritoquë ya'huëran. Yosë quëran o'maton, noya noya ninan, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Itohuachina, Quisosori itërin: —¡Ta'tëquë'! Iso quëmapi quëran pipimiatëquë', itërin. Sopaiso' quëmapi no'paquë të'yatahuaton, pipirin. Co manta' onpotërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ya'ipi piyapi'sa' nicatona', pa'yanpi. —¡Ma'pítacha Quisoso nitotërin paya! Chiníquën nanantaton, sopairo'sa' ocoirin. Camaihuachina pipipi, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Quisoso naporinso', ya'ipi parti nahuinin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ina quëran niyontonpiso pëi quëran pipirahuaton, Simon pëinënquë pa'nin. Simon a'shatën chiníquën saporin ni'ton, Quisoso sha'huitopi. “A'shacha chiníquën saporin ta'a. Quëmari anoyatëquë' topiraihuë',” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inaquë paaparahuaton, sapo a'naroáchin inquitërin. Noyatërin huachi. Nani noyatahuaton, inari chachin a'carin, o'shitërin, napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","I'huanahuanquë pi'i yaya'conahuaso', na'a cania'piro'sa' nisha nisha caniori maninsopita Quisoso quëshipi. Napohuachinara, a'naya a'naya së'huarahuaton, ya'ipiya anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sopairi ya'coancantërinsopitanta' quëntapi. Quisosori nontohuachina, sopairo'sa' pipipi. Yapipihuachina', chiníquën nontapi. —Quëmaso' Yosë hui'ninquën, itopi. Yosëri a'paimarinso' nitotatona', napotopi. Napoaton Quisosori itapon: “Ta'tëquë'. Ama insonta' sha'huitëquësohuë',” itohuachina, ta'topi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tahuëririnquë tashiramiachin Quisoso huënsërahuaton, pa'nin. Ninano quëran pipirahuaton, co piyapi ya'huërinquëhuë' pa'pirinhuë'. Na'a piyapi'sa' ina yonípona' pa'pi. Quënanahuatona', “Ama paquësohuë'. Isëquë ya'huaton, a'chintocoi,” itopirinahuë', co nohuantërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","—Nisha nisha ninanoro'saquë paca'huaso' ya'huërin. Inaquënta' Yosë nanamën a'chinchi hua'anëntërinquë ya'coina'. Ina marë' Yosë a'paimarinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ina quëran ya'ipi cotioro'sa' ya'huërin parti pa'sahuaton, niyontonpiso pëiro'saquë a'chinarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ina quëran Quisoso Quinisariti sono' yonsanquë a'chinarin. Na'a piyapi'sa' yamorapi. Yosë nanamën natanacaiso marë' huë'pi. Chiníquën ya'quëëtopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Napotohuachinara, cato' poti ni'nin, yonsanquë oshipiso'. Hua'anënpitaso' nonshirahuatona', ritinëna pa'moapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A'na potiso' Simonquën. Inaquë ya'conahuaton, “Amasha paquë',” itërin. Itohuachina, amasha pa'nin. Inaquë huënsërahuaton, piyapi'sa' a'chintaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nani a'chinpachina, Simon itapon: —Huëquë' iyasha, amasha anpoquë pa'ahua'. Inaquë ritinëma të'yatoco' sami macamaquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Capa sami Maistro. Ya'ipi tashi' të'yatopiraihuë', co manta' manaihuë'. Nipirinhuë', quëma sha'huitëranco ni'quëhuarë', naquëranchin të'yatanta'i, itërin Simoni. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ina quëran të'yatohuachinara, notohuaro' sami mapi. Hua'huayatërahuë' ni'ton, riti yaoquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Amiconënpita a'na potiquë ya'huërinso' imirin quëran anquitërin huëcatona' catahuacaiso marë'. Napotohuachinara, huë'pi. Cato' potiquë chachin sami amëntatopi. Napohuachinara, yayancominapipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Ina nápo' sami ma'ton, Simon Pitro pa'yanin. Quisoso nantën pirayan isonahuaton, itërin: —¡Ma'pítacha Sinioro nanitaparan paya! Caso' oshahuanco ni'to, co ya'cariancoso' ya'huërinhuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Amiconënpitanta' pa'yanpi, Santiaco, Coansha inapita itopiso'. Sipitio hui'ninpita inahuaso'. Ina quëran Simon nontaton, Quisosori itapon: —Ama iyasha pa'yanquësohuë'. Nani catahuaranquën sami macamaso'. Ipora quëran huarëso nipirinhuë', catahuaranquën piyapi'sa' macamaso marë'. Inapitanta' imainacoso marë' masaran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ina quëran nonshirahuatona', ma'shanënapita patahuatona', Quisoso imapi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ina quëran a'na ninanoquë paantapi. Inaquë a'na quëmapi ya'huërin, chana caniori maninso'. Noshinën noyá pë'yatërin. Quisoso nantën pirayan isonahuaton, itapon: —Nohuantohuatan Sinioro, nanitëran anoyatancoso'. Anoyatoco topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Quisosori së'huarahuaton, itapon: —Nohuantërahuë mini. Apiramiáchin anoyataranquën, itërin. Itohuachina, a'naroáchin canio inquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","—Ama iyasha piyapi'sa' sha'huitëquësohuë'. Corto hua'ainchin sacatërinquë paaton, noyatëranso' a'notonquë' ni'inquën. Naporahuaton, ofrenda Moisësë camaitërinso' quëpaquë' noyatëranso' nitotacaiso marë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Napotopirinhuë', ya'ipi parti nahuinin. Ina quëran hua'huayátërahuë' piyapi'sa' huë'pi Quisoso natanacaiso marë'. Cania'piro'santa' huë'pi anoyatacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Quisososo nipirinhuë', apira apira piyapi'sa' patërin. Co piyapi ya'huërinquëhuë' pa'nin Yosë nontacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A'na tahuëri Quisoso a'chinaso', parisioro'sa', cotio maistro'sa', inapitanta' inaquë chachin huënsëapi. Inapitaso nisha nisha ninano quëran huë'pi. Cariria parti quëran, Cotia parti quëran, Quirosarin quëran, ina quëranpita huë'pi. Nani a'chintohuachina, cania'piro'sa' anoyatërin. Yosëri catahuarin ni'ton, na'a cania'piro'sa' a'naroáchin anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ina quëran catapini quëmapi'sa huëcatona', apia pë'sara'huaya pochin nininquë quëpi. Hua'qui' co nanitërinhuë' huanicaso', quëhuëánin. Quisoso ya'huëarinquë yapo'mopirinahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hua'huayatërahuë' piyapi'sa' ya'sopi ni'ton, co nanitopihuë' ya'conacaiso'. Napoaton pëi' nanpëtahuatona', a'canpiso' pi'pian o'quirahuatona', pë'sara'huayarë chachin anohuaramapi. Huancanachin Quisoso pirayan acomapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Ma noya isopita natërinaco,” ta'ton, Quisosori apia itapon: —Oshanën apia'hua inquitaranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ina natanahuatona', cotio maistro'sa', parisioro'sa', inapita yonquipi. “¿Ma quëmapita' isoso'? Yosë yaya'huërëtërin. Co insonta' nanitërinhuë' oshanënpoa' inquitinpoaso'. Yosëíchin nanitërinso',” topi yonquiatona'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Topinan yonquiarapirinahuë', inaora yonquinën quëran Quisoso nitotërin. —¿Onpoatomata' co noyahuë' yonquirapiramaco? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Canpitaso naporama': “Piyapinpoa a'napita oshanën inquitacaso', co nanitërëhuahuë'. Apia camaiatë': ‘Huanirahuaton, noya paquë',’ itacasonta' co nanitaparëhuahuë',” tënama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Caso nipirinhuë', Yosë quëran quëmapico ni'to, nanan quëtërinco piyapi'sa' oshanëna' inquita'huaso marë'. Canpitanta' ina nitotacamaso marë' iso apia anoyatarahuë, tënin. Ina quëran apia itantapon: —Huaniquë', apia'hua. Pë'sara'huaya masahuaton, ya'huëranquë paquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Itohuachina, a'naroáchin huanirin. Ya'ipi piyapi'sari ni'pi. “¡Ma noyacha Yosëso' ni'ton, anoyatërinco paya!” tënin. Pë'sara'huayanën masahuaton, ya'huërinquë pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ina nicatona' piyapi'saso' pa'yanpi. —Ma noyacha Yosëri catahuarin ni'ton, a'naroáchin anoyatërin paya. Ma'pítacha ipora ni'nëhua paya, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ina quëran Quisoso paantarahuaton, a'na quëmapi quënanconin, Nihui itopiso'. (Inachachin Matio itopi anta'.) Coriqui Noma copirno marë' ma'patona'pi inaso'. Coriqui ma'patërinquë huënsëarin. —Huëquë' iyasha imaco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Napotohuachina, a'naroáchin huanirin. Ma'shanënpita patahuaton, Quisoso imarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ina quëran na'a amiconënpita amatërin pëinënquë coshatacaiso marë'. Quisoso nohuitacaiso marë' amatërin. Na'a copirno marë' coriqui ma'patona'piro'santa' huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ca'tano'sa' inaquë ni'sahuatona', cotio maistro'sa', parisioro'sa', inapitari no'huipi. No'huitona' itapona': —¿Onpoatomata' oshahuano'sarë'quëma' coshatarama', o'opatarama', naporama'? Coriqui ma'patona'piro'santa' co noyahuë' nipirinahuë', inapitarë'quëma' coshatarama', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Natanahuaton, Quisosori itërin: —Isopitaso' tëhuënchachin nohuantërinaco imainacoso'. Ni'co'. Cania'piro'sa' notoro nohuantopi. “Co caniorahuë',” topatëra, co notoro nohuantërëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Oshahuano'sa' pënëna'huaso marë' o'marahuë. “Co noyahuë' yonquiramasopita naniantatoma', Yosë tahuërëtantaco',” itërahuë. A'napitaso': “Quiyaso' noyacoi,” topiso marë' co na'con a'chintërahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ina quëran piyapi'sari itaantapi: —Coansha imarinsopitaso', co coshatatonaraihuë' Yosë nontapi. Parisio imarinsopitanta', inapochachin nipi. Quëma imarinënsopitaso nipirinhuë', noya coshatapi, o'osapi, naporapi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","—Ca ya'huarahuë ni'ton, co sëtopihuë'. Ni'co'. Quëmapi sa'acaso marë' piyapi'sa' amatohuachina, capa cancantopi. Nipayarinsopita huë'pachina', noya coshatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","A'na tahuëriso nipirinhuë' inimiconënpitari huëcatona', sa'ana'pi masapi. Quëpatohuachina', co huachi coshatacaiso' yonquiatonahuë' sëtapi. Inapochachin canta' mapachinaco, imarinacosopita sëtapona'. Sëtatona' co huachi coshatacaiso' yonquiatonahuë', Yosë nontápona', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ina quëran pënënto nanan a'chintaantarin. —Ni'co'. A'moramaso irácaya nininso' noshatohuachina, co nasha a'morëso yanorëhuë' pa'pitacaso marë'. Nasha a'morëso yanohuatëra, tapirë'. Naporahuaton, nasha në'mëtëquë pa'pitohuatëra, co inashitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Huino sha'moronta' yonquico'. Sha'moro' nipachina, co sha'huëtë' morsa mocaro' nininquë ta'panëhuë'. Sa'potohuachina, a'naroáchin nopoitërin. Nopoitohuachina, huino chiniarë'. Morsanta' tapirë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sha'moro' huinoso' nasha morsaquë ta'panë'. Huino, morsanta' noya nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Huino hua'qui' acopiso' o'opachinara, co nasha nipiso' nayapihuë'. “Hua'qui' acopiso' noya noya,” topi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A'na chinoto tahuëri nanihuachina, Quisoso ca'tano'sanënpitarë' pa'sarin. Tricoro' pëntontapona pochin, ca'tano'sanënpita a'naya a'naya trico moto maraapi. I'shorayarahuatona', caraapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisioro'sari ni'sahuatona', itopi: —¿Onpoatomata' chinoto tahuëri nipirinhuë' tricoraya i'shorayarama'? Co ipora tahuëri sacatacasohuë' nipirinhuë'. ¿Onpoatomata' Moisësë pënëntërinso' co natëramahuë'? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Itohuachinara, Quisosori itërin: —Yosë quiricanën ¿co nontëramahuë' ti? Iráca Tapi tanahuachina, Yosë pëinënquë ya'conahuaton, pan Yosë marë' acopiso' ca'nin. Ca'taninsopitanta' tanapi ni'ton, quëtërin, ca'pi anta'. Corto hua'ano'saráchin ina pan capacaiso nipirinhuë', Tapiso' ca'nin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ina quëran itantarin: —Yosë quëran quëmapico ni'to, chiníquën nanantërahuë. Ma'sona chinoto tahuëri noya nicacaso' sha'huichinquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ina quëran chinoto tahuëri naniantahuachina, niyontonpiso pëiquë paantahuaton, Yosë nanamën a'chiantarin. Inaquë a'na quëmapi ya'huërin. Inchinan imirin tachitërin ni'ton, co nanitërinhuë' së'quëtacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","“Chinoto tahuëri nipirinhuë', Quisosori anoyatapon nimara,” ta'tona', cotio maistro'sa', parisioro'sa', inapitari ni'sápi sha'huirapicaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Topinan yonquiarapirinahuë', Quisosori ninorin. Napoaton apia itërin: —Huë'sahuaton huancánachin huaniquë', itërin. Napotohuachina, huanirahuaton, inaquë pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Inaquë huanihuachina, Quisosori cotio maistro'sa', parisioro'sa', inapita itërin: —Chinoto tahuëri noya nicacaso' ya'huërin. Ahuëtacaso', tëpatacaso', co inapita nicacaso' ya'huërinhuë'. Cania'pi tananpitohuatoso', co nosoroarahuë'. Napoaton anoyatacaso' ya'huërin, tënahuë caso'. ¿Ma'ta' canpitaso' tënama'? itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Napotopirinhuë', co manta' topihuë'. Co a'panitohuachinarahuë', a'naya a'naya ni'sarin quëran apia itërin: —Imiran iyasha ihuëquë', itërin. Natëton, ihuëhuachina, a'naroáchin noyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ina marë' ni'sapisopitari chiníquën no'huitona', inahuara capini ninontopi onporahuatonsona Quisoso ma'sha onpotacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ina quëran Quisoso a'na motopia'huaquë paantarin Yosë nontacaso marë'. Ya'ipi tashi' Yosë nontárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tahuërihuachina, imarinsopita përarin. Huë'pachinara, shonca cato' acorin na'con na'con a'chintacaso marë'. “A'chinacaso marë' a'parahuësopita itaranquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A'naso' Simon. Nisha nininën acotërin. Pitro itërin. Iionta' acorin, Antërisë itopiso'. Santiaco, Coansha, Pinipi, Partoromi, ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matio, Tomasë, inapitanta' acorin. A'na Santiaconta' acorin. Arpio hui'nin inaso'. A'nanta' Simon itopi. Inaso' copirno no'huina'piro'sa' imapirinhuë', iporaso' Quisoso imasarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ina quëran cato' Cotasë acorin. A'naso' Santiaco hui'nin. A'nanta' Cotasë Iscarioti. Inanta' Quisosori acopirinhuë', a'na tahuëri sha'huirapiapon. Inapita Quisosori acorin ca'tanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Inapitarë' nohuaraimarahuaton, pastoquë huanirin. Na'a imarinsopita inaquë ya'huapi. Notohuaro' piyapi'santa' huë'pi Quisoso natanacaiso marë'. Quirosarin quëran huë'pi. Ya'ipi Cotia parti quëran huë'pi. Marë yonsan quëraonta' huë'pi. Tiro, Siton, inapita ya'cariya ya'huëpisopitanta' huëcatona', noya natanpi. Cania'piro'santa' quëpi anoyatacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A'naquëonta' sopairi ya'coancantërin ni'ton, parisitápirinahuë', inapitanta' anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ya'ipiya Quisoso së'huacaiso' nohuantopi. Së'huahuachinara, ina nohuanton, a'naroáchin noyatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ina quëran ca'tano'sanënpita notëërahuaton, a'chintërin: “Canpitaso' co na'a ma'sha ya'huëtopirinquëmahuë', Yosë noya ni'sarinquëma'. Catahuarinquëma' noya cancantacamaso'. Hua'anëntërinquë chachin aya'conarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Iporaso' tanapomarahuë', Yosë'pa' co onporonta' tanararamahuë'. Sano cancantarama'. Isoro'paquë na'nëpiramahuë', inapaquëso' capa cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yosë quëran quëmapico ni'to, imaramaco. Imaramacoso marë' a'naquën no'huiarinënquëma'. Co huachi quë'yarinënquëmahuë'. Pinosarinënquëma'. Nonpinapiarinënquëma'. Napotopirinënquëmahuë', ama sëtocosohuë'. Ina marë' Yosë noya ni'sarinquëma ni'ton, nóya cancantoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iráca Yosë piyapinënpita pënëntohuachinara, shimashonëmapitari inapochachin no'huipi. Napoaton a'napita no'huihuachinënquëma', noya cancantoco'. Parisitëramaso marë' Yosë'pa' na'con canaarama'. Ina yonquiatoma', capa cancantoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A'naquëmaso' nani ma'sha ya'huëtopirinquëmahuë', ¡ma'huantacha nisarama paya! ‘Noya cancantarëhua',’ topiramahuë', Yosëso' co noya ni'sarinquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Iporaso' noya coshatapiramahuë', ¡ma'huantacha nisarama paya! A'na tahuëriso' co manta' ya'huëtarinquëmahuë'. Iporaso' capa cancantapiramahuë', ¡ma'huantacha nisarama paya! A'na tahuëriso' sëtatoma', na'nëarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Noyasáchin nontinënquëmaso' pa'yatohuatama', ¡ma'huantacha nisarama paya! Iráca nonpin nanan pënëntona'piro'sa pënëntohuachinara, shimashonëmapitari pa'yatopi. Inapochachin iporanta' a'naquëma' niantarama'. Yosëso nipirinhuë' ana'intarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ina quëran itaantarin: “Carinquëma' iyaro'sa', pënëinquëma' natanco. Ya'ipi piyapi'sa' nosorocaso' ya'huërin, tënahuë. Inimiconëmapitanta' nosoroco'. No'huipirinënquëmaonta', ama i'huërëtocosohuë'. Catahuaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pinopirinënquëmaonta', noya nontoco'. Co quë'yapirinënquëmaonta', ama no'huicosohuë'. Yosë nontoco' inahuanta' catahuain. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Panpirayahuachinquën, ama manta' i'huërëtëquësohuë'. Naquëranchin panpiantahuachinquën, co naporo tëranta' no'huicaso' ya'huërinhuë'. A'moranso' matohuachinquën, tananpitëquë' quëpa'in. Aipi a'moransonta quëpatohuachinquën, ama no'huiquësohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","‘Ma'sha quëtoco,’ itohuachinquën, ama apiraquësohuë'. Quëpatohuachinquën, ama ma'pataantaquësohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Noya ninosorocaso' ya'huërin. Canpita nohuantërama' a'napita nosoro'inquëmaso'. Napoaton canpita nohuantëramaso chachin a'napitanta' nosoroco'. Ninosoroatoma', nicatahuaco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Amiconëmapitaráchin nosorohuatama', co noya noya nisaramahuë'. Oshahuano'sa tëranta' inahua capini ninosoropi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Noya nontërinquëmasopitaráchin catahuahuatama', co noya noya nisaramahuë'. Oshahuano'sa tëranta' inahua capini nicatahuapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No'tëquën pahuërëtopisopitarachin coriqui a'nanpatama', co noya noya nisaramahuë'. Oshahuano'sa tëranta' inahua capini nia'nanpi. ‘Oshaquëran niquëtanta'a,’ ta'tona', nia'nanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Canpitaso nipirinhuë' inimiconëmanta' nosoroco'. Inapitanta' catahuaco'. Piyapi'sa' pahuantohuachina', coriqui a'nanco'. ‘Co i'huërëtaponcohuë' nimara,’ tapomarahuënta', a'nanco'. Ina pochin nipatama', Yosë'pa' na'con canaarama'. Yosë pochachin cancantarama'. Inaso' ya'ipi piyapi'sa' nosoroaton, catahuarin. Oshahuano'santa' nosororin. Co ‘Yosparinquën,’ itopirinahuë', catahuarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tata Yosëri ya'ipi piyapi'sa' nosororin. Inapochachin canpitanta' a'napita nosoroco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ina quëran itaantarin: “Ama iyaro'sa' a'napita nocancosohuë'. ‘Caso' noya piyapico. Paso' piyapi co noyahuë' ni'ton, ana'intacaso' ya'huërin,’ topi a'naquën. Ama ina pochin noncosohuë', Yosë ana'intochinquëma'. A'napita pinotoma' sha'huirapihuatama', Yosënta' inapochachin sha'huirapitënquëma', ana'intarinquëma'. A'napita ma'sha onpotohuachinquëma', nanan anoyatoco'. Canpitanta' oshanëma' Yosë inquichinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ama a'napita apiratocosohuë'. Ma'sha quëtoco'. Ina marë' canpitanta' Yosë acanaarinquëma'. Co manta' nonpintarinquëmahuë'. Piyapi'sa' nosoroatoma' catahuahuatama', Yosënta' na'con na'con catahuarinquëma'. Apirahuatama', canpitanta' co Yosë catahuarinquëmahuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ina quëran pënënto nanan sha'huitërin yonquicaiso marë': “Somaraya nipachina, co nanitërinhuë a'na somaraya nininso' quëpacaso'. Quëparin naporini, cato chachin panca naninquë anochitonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maistroso' noya noya nitotaton, a'napita a'chintërin. Natanpisopitaso' co na'con na'con nitotopihuë'. Nani ya'ipi a'chintohuachina, maistronëna pochin nisapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Co iyaparin nocanacaso ya'huërinhuë'. Inaso pi'pian co noyahuë' nipachin, mo'shiri ya'conayatërinso pochin ninin ni'ton, nocanan. Quëmanta' co noyahuë' ninan ni'ton, narasëratë' nani noyá ya'copirayarinquënso pochin nipiranhuë', naporan. Napoaton ‘carinquën noya nicatënquën mo'shi ocoichinquën,’ co itamaso ya'huërinhuë'. Napotohuatan, nonpinan. Narasëratë' niocoitëquë'. Ina quëran noya quënantaran. Naporo huarë' nanitaran iyaparin mo'shi ocoitacaso',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ina quëran itantarin: “Nara co noyahuë' nipachina, napoonin nitërin. Noya naraso nipirinhuë' noya nitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nitërin quëran nara nohuitërë'. So'huanpiso' co misëra nitërinhuë'. Shihuarionta' co quëpa nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Inapochachin piyapi'sa' nipi. Noya yonquihuachinara, noya nipi. Co noyahuë' yonquihuachinara, co noyahuë' nipi. Ma'sona yonquihuachinara, ina chachin nonpi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ina quëran itantarin: “A'naquëma' ‘Sinioro, Sinioro,’ itapomaracohuë', ¿onpoatonta' co natëramacohuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na'aquëma' natanamacoso marë' huë'nama'. Natëhuatamaco, a'na quëmapi pochin nisarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Inaso', natëricho quëran yapëirin. Yapëihuachina, noya yonquiaton, noya pëiaquë yonirin. Na'pitë' quënanahuaton, na'pitëquë chachin natëricho quëran pëirin. Pamatohuachina, opotopirinhuë', co anotërinhuë'. Chinii' niponahuë', co yatë'yatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A'naquënso nipirinhuë' yapëihuachina, co noya yonquirinhuë'. ‘Inotëquë tëranta' pëi'i,’ ta'ton, inaquë pëirin. Ina quëran pamatohuachina, chiniiri a'naroáchin të'yatërin. Ya'ipi noyá quiquirin. Inapochachin topinan natanpatamaco, co natëhuatamacohuë', co cha'ësaramahuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Piyapi'sa' a'chintahuaton, Quisoso Capinaomoquë pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Inaquë a'na Noma capitan ya'huërin. A'na piyapinën chiníquën canioton, yachiminin. Hua'anëni noya nosororin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quisoso canquirinso' natantahuaton, cotio ansiano'sa' amatërin. “Paatoma', Quisoso sha'huitonco' huë'in piyapinëhuë anoyachinco,” itahuaton, a'parin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Inapitaso Quisosoquë canconahuatona', itapona': —Paso' capitan amatërinquën. Inaso' nisha piyapi niponahuë', nóya quëmapi. Nosororinpoa'. Inaora coriquinën quëran niyontona'huaiso pëi' ninin Yosë yonquica'huaiso marë'. Napoaton huëquë' piyapinën anoyatëquë', chiminpachin, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Ina natanahuaton, inapitarë' pa'nin. Capitan pëinënquë ya'caritërahuaso', amiconënpitari nacapipi. Capitani a'parin Quisoso nontacaiso marë'. “Capitan nanan a'patërinquënso' sha'huichinquën. Naporin: ‘Caso' Sinioro nontaponquën yapa'pirahuë'. Tapanato, co pa'nahuë'. Co caso' quëma pochin noyacohuë'. Co pëinëhuëquë tëranta' ya'conamaso' ya'huërinhuë'. Topinan camaiquë' piyapinëhuë noyachin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Canta' hua'anëhuë natërahuë. Capitanco ni'to, sontaro'sa' camaihuatëra, natërinaco. “Paco',” itohuatëra, pa'pi. “Huëco',” itohuatëra, huë'pi. Piyapinëhuëpitanta' camairahuë. “Sacatoco',” itohuatëra, sacatopi. Napoaton natëranquën,’ tënin capitan,” itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Quisoso natanahuaton, pa'yatërin. Ina quëran tahuërëtahuaton, piyapi'sa' itapon: —¡Ma noya ina quëmapi natërinco paya! Nisha piyapi niponahuë', israiro'sa quëran noya noya natërinco. Napoaton ca nohuanto, apiramiachin piyapinën noyatarin, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Napotohuachina, capitan amiconënpita ayancoantapi. Cania'pi nani noyatërin quënanconpi huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ina quëran Quisoso Nainquë ca'tano'sanënpitarë' pa'nin. Na'a piyapi'sari imasapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ninano ya'coanaquë ya'caritërahuaso', na'a ya'huëhuano'sa nacapipi. Chimipi pa'pitacaiso marë' quësapi. Hui'napi niponahuë', a'shin ayananpirin. A'shini imasarin. Inaíchin hua'huin nipirinhuë', chiminin. So'ionta' iráca ayarin ni'ton, sa'ahua paiya inaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ina quënanahuaton, Quisosori nosororin. —Ama imoya na'nëquësohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Napotahuaton, chimipi acopiquë së'huaconin. Së'huarahuachina, quëparapisopita huanipi. Napohuachina, chimipi itapon: —Huënsëquë' apia'hua, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Napotohuachina, nanpiantarahuaton huënsërin. Ina quëran nonsarin. Quisosori a'shin itapon: “Ya'huëranquë imoya quëpaantaquë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ina nicatona', ya'ipi piyapi'sa' pa'yanpi. —¡Ma noyacha Tata Yosëso paya! Ma noya quëmapi a'patimarinpoa' pënëinpoaso marë'. Nani ma'sha nanitaparin, topi. Ina quëran taantapi: —Yosë co naniantërinpoahuë'. Catahuarinpoa huachi, topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ananpitaantarinso' ya'ipi Cotia parti nahuinin. Ya'ipiya natantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Coansha imarinsopitaso', Quisoso naporinso' sha'huitonpi. Inaso' natanahuaton, yonquiárin. “Quisososo' Yosëri a'paimarinso' nimara. ¿Pahuanarin o'macaso' nica?” ta'ton, cato' imarinsopita a'parin Quisoso natanacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Paatona quënanconpachinara, itapona': —Coansha Paotista a'pairincoi natana'huainquënso marë'. ¿Quëmaso' Cristonquën? ¿Pahuanarin inaso' o'macaso' nica? Co nitotëraihuë'. Sha'huitocoi quiyanta' nitochii, itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naporo chachin na'a cania'piro'sa' ya'huapi, nisha nisha caniori maninsopita. Quisosori a'naroáchin anoyatërin. Sopairo'sari ahua'yantërinsopitanta' huë'pachinara, sopairo'sa' a'patërin. Naporahuaton, ina nohuanton, somaraya nininsopitanta' ni'topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","—Ni'co' iyaro'sa'. Ca nohuanto, somaraya nininsopita ni'topi. Apiaro'santa' a'naroáchin anoyatërahuë. Noya iratopi. Chana caniori maninsopitanta' anoyatërahuë. Në'huëro'santa' në'huëpiso' inquitërahuë. Chiminpisopita ananpitaantarahuë. Notohuaro' piyapi'sa' co Yosë nohuitatonaraihuë' nosorotápirinahuë', noya nanan a'chintarahuë. Ya'ipi nani ni'nama', nani natanama'. Paatoma', Coansha sha'huitonco' no'tëquën nitochin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ya'ipi cancanëma quëran natëhuatamaco, noya cancantarama'. Co nisha nisha yonquiamacoso' ya'huërinhuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ina natanahuatona', Coansha sha'huitapona' pa'pi. Nani paantahuachinara, Quisoso a'chiantarin. “Coansha yonquiato a'chinchinquëma'. I'hua inotëro parti ina nicapoma' pa'patamara, inaso Yosë marë chiníquën huanirin quënanconama'. Co piquira ihuani onororinso pochin niconinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Co inaso ma'huano'sa pochin noyápiachin a'morinhuë'. Noyápiachin a'mopisopita, capa cancantacaisoráchin cancantopisopita, inapitaso' copirno pëiro'saquë ya'huëpi. Coanshaso nipirinhuë' co ina pochin nininhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pënëntërinso' natanacaso marë' pa'nama'. Coansha tëhuënchachin nóya pënëntërin. Co topinan quëran pënëntërinhuë'. Yosëri chachin a'parin pënëntacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iráca quiricanënquë ninorin: ‘Co'huara a'pamayátërasënquënhuë', comisionëhuë a'pararahuë. Paaton, pënëntapon noya natanainënquënso marë',’ itërin Yosëri hui'nin nontaton. Coansha ninoton, naporin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iráca quëran huarë' na'a piyapi'sa' pënëntopirinahuë', Coanshaso' noya noya pënëntërin. Inaso noya pënëntopirinhuë', inso tëranta' imapachinaco, ina quëran noya noya nisarin. Yosë hua'anëntërinquë chachin ya'conarin, tënahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nani na'a piyapi'sari Coansha noya natanpi. Copirno marë' coriqui ma'patona'piro'santa' “Yosë noninso' no'tëquën pënëninpoa',” ta'tona', aporihuanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisioro'saso nipirinhuë', co nohuantopihuë' Yosë nanamën natëcaiso'. Coansha no'tëquën pënëntopirinhuë', topinan quëran natanpi. Napoaton co aporihuanpihuë'. Cotio maistro'sarinta' co yanatëpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Naquëranchin Quisoso taantarin: “Iporaso' piyapi'sa' nisha nisha yonquipi. ¿Ma pochinta' niconpi? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hua'huaro'sa pochin cancantopi, tënahuë. Hua'huaro'sa' cachiquë ya'nipihuachinara', a'naquën tapona': ‘Huëco' pita pochin nicatëhua' ya'nipiahua',’ ta'tona', quinatopirinahuë', co a'napitaso' nohuantopihuë' nansacaiso'. Ina quëran tantapona': ‘Inta nipachin, huëco', chimipi pa'pitopiso pochin nicatëhua' ya'nipiahua',’ nitantapi. A'naquën sëtatona' na'nërápirinahuë', co a'napitaso' nohuantopihuë' na'nëcaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Inapochachin ipora nisha nisha yonquirama'. Coansha Paotistaso' huëcapon, co aquëtë' cosharo' yonquirinhuë'. Co pi'pian tëranta' huino o'orinhuë'. Napopirinhuë', ‘Sopai nohuanton, naporin,’ toconama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ina quëran caso' Yosë quëran quëmapico ni'to, coshatërahuë, o'orahuë. Ina marë' pinoramaco. ‘Quisoso coshatárin. O'opatárin. Oshahuano'sarë' nipayarin,’ toconama'. Nisha nisha yonquiconama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A'naquënso nipirinhuë', noya yonquiatona', Yosë natëapi. Pënëntërahuëso' natanahuatona', no'tëquën yonquiapi huachi,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ina quëran a'na parisio quëmapiri Quisoso amatërin. “Pëinëhuëquë huëquë' coshatahua',” itërin. Itohuachina, pa'nin. Pëinënquë ya'conconahuaton, misaquë huënsëconin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A'na sanapi natantahuaton, inaquë huë'nin. Inaso' oshahuana'pi itopiso'. Pimo hua'sai' potiria'huaquë quënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Quisoso ya'yoranconahuaton, oshanën marë' sëtaton na'nërin. Na'nëhuachina, na'nëinën quëran Quisoso nantëquën shipitërin. Ainën quëran amirantërahuaton, apinorantërin. Ina quëran pimo hua'saiquë pashirantëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ina ni'sahuaton, pëi' hua'anëni co noyahuë' ni'nin. Inaora yonquinën quëran yonquirarin. “Quisoso pënëntona'pi naporini, iso sanapi nohuichitonhuë'. Oshahuan ni'ton, co së'huacaso' nohuanchitonhuë',” tënin yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yonquirinso' nitotaton, Quisosori itërin: —Iya Simon, pi'pian yasha'huitëranquën, itërin. —Inta Maistro sha'huitoco, itërin inarinta. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Cato' quëmapi ya'huëpirinhuë'. Cato chachin patron nihuipi. A'naso' a'natërápo pasa tahuëri canarëso' nihuitërin. A'nanta' a'natërápo shonca tahuëri canarësoíchin nihuitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Capa coriqui pahuërëtacaso' ni'ton, cato chachin nihuitopiso' ayatërin. Topinan ayatërin. ¿Insoarita' patronën na'con na'con nosoroarin? ¿Ma'ta' quëma yonquiran? itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Na'con na'con ayatërinsoari na'con na'con nosoroarin, topirahuë', tënin. —Ina mini. No'tëquën yonquiran, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ina tosahuaton, sanapi tahuërëtahuaton, Simon itërin: —Iso sanapi ni'quë'. Quëma pëinënquë ya'conpirahuë', co inachintërëhuaso' ninanhuë'. Co i'sha tëranta' quëtërancohuë' nipa'morantëcaso marë'. Iso sanapiso nipirinhuë' na'nëinën quëran pa'morantërinco. Ainën quëran amirantërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Canquipirahuë', co apinorancohuë'. Iso sanapiso nipirinhuë' apinorantërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni'toro'sa' huë'pachina, noya hua'saiquë pashimototacaso' ya'huëpirinhuë', quëmaso' co pashimototërancohuë'. Iso sanapiso nipirinhuë' nóya nicatonco, pimo hua'saiquë pashirantëtërinco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tëhuënchachin na'con oshahuanpirinhuë', oshanën inquitarahuë. Napoaton na'con na'con nosororinco, tënahuë. A'naquënso nipirinhuë', “Co aquëtë' oshahuanahuë',” ta'tona', co onpopinchin nosororinacohuë', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ina quëran sanapi itapon: —Oshanën imoya inquitëranquën huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A'napitaso' natanahuatona', ninontopi. —¿Ma quëmapita' isoso'? ¿Oshanëna quëran huarë' inquitacaso' nanitërin ti? nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Quisososo nipirinhuë' sanapi itantapon: —Natëranco ni'ton, Yosë nicha'ërinquën. Noya paquë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ina quëran nisha nisha ninanoquë Quisoso pa'nin a'chinapon. A'naquën pancana, a'naquën co pancanayahuë' niponahuë', inaquënta' paaton, noya nanan a'chinarin. “Yosë yahua'anëntërinquëma',” itëra'piarin. Shonca cato' ca'tano'sanënpitari imasapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A'naquën sanapi'santa' imasapi, canio quëran anoyatërinsopita. A'napitanta' sopairo'sari ya'coancantohuachinara hua'yantopirinahuë', nani anoyatërin. A'naso' Maria Mactarina itopi. Canchisë sopairo'sari ya'coancantopirinahuë', Quisosori inquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Coananta' imarin. Cosa sa'in inaso'. So'inso' ya'ipi Irotisë ma'shanënpita a'pairin. Sosananta' imarin. Inapita imatona', inahuara coriquinëna quëran cosharo' pa'anpi Quisoso, ca'tano'sanënpita, inapita coshatacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nisha nisha ninano quëran huë'pi Quisoso natanacaiso marë'. Notohuaro' niyontonpachinara, pënënto nanan sha'huitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—A'na quëmapi sha'tapon pa'nin. Tricoraya iminquë pa'sarayarin papotacaso marë'. Pa'sarayahuachina, a'naquën iraquë huarë' anotërin. Inaquë piyapi'sa' iratatona', i'natopi. Inairaro'santa' huë'sahuatona', pë'yaquipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A'naquën ya'pirinso' na'piroquë anotërin. Inaquë papotopirinhuë', shimënshin no'pa' ni'ton, ahuirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A'naquëonta' nahuanoquë anotërin. Inaquë papotopirinhuë', nahuano'santa' papotërin. A'shinahuatona, imotërin. Napoaton co nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A'naquënso nipirinhuë' noyaro'paquë anotërin. Inaquë noya papotërin. A'shinpachina, sha'nin quëran na'con na'con nitaton, pasa, pasa nitërin, itërin. Ina quëran taantarin: —Huëratëhuanpatama', noya natanatomaco, yonquico', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Napotohuachina, ca'tano'sanënpitari itapona': “Achin Maistro naporanso', co nitotëraihuë'. ¿Ma'ta' tapon naporan?” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Yosë hua'anëntërinso' co a'napita nitotopihuë'. Canpitaso nipirinhuë' ya'ipiya a'chinchinquëma' Yosë nanamën no'tëquën nitotacamaso marë'. A'napitaso nipirinhuë' co ya'ipiya a'chintarahuë'. Pënënto nananquësáchin a'chintarahuë ni'ton, natanaponaraihuë', co nitotapihuë'. Ma'sona ninahuësonta' nicaponaraihuë', co yonquiapihuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ina quëran itaantarin: “Achin naporahuëso' iyaro'sa', a'chintanta'inquëma' nitotoco'. Yosë nanamën a'chinpatëhua', tricoraya pa'sarayapiso pochin ninëhua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A'naquën piyapi'sa' ira pochin nipi. Yosë nanamën natanpirinahuë'. Inairaro'sari huëcapairinso pochin a'naroáchin sopai huë'nin. Yosë nanamën natanpiso' osërëtiirin. Ama natëcaiso marëhuë' ananiantërin. Natëpi naporini, Yosëri cancanëna' anoyachitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A'naquëonta' na'piro pochin nipi. Yosë nanamën natanahuatona', a'naroáchin pa'yatatona', natëpirinahuë'. Co chiníquën cancantatonahuë', co natëmiatopihuë'. Ma'sha onpohuachinara, Yosë a'popi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A'naquëonta' nahuano'sa' ya'huërinquë pochin nipi. Yosë nanamën natanpirinahuë'. Isoro'paráchin yonquiatona', co nanamën yonquipihuë'. Coriquiráchin cancantopi. Nipa'yatacasoáchin yonquirapi. Nahuano'sari imotërinso pochin ma'sharáchin yonquiatona', Yosë nanamën naniantopi. Co huachi natëpihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A'naquën piyapi'saso nipirinhuë' noyaro'pa pochin nipi. Yosë nanamën noya natanpi. Natanahuatona', noya cancantatona', natëtopi. No'tëquën yonquiatona', natëmiatopi. Ma'sha onpoaponaraihuë', co a'popihuë'. Ya'ipi cancanëna quëran imatona' noya noya nisapi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ina quëran a'chintaantarin: “Nanparin i'chinpihuatëra, co i'mëanaquë po'morëhuë'. Co pë'saraanaquë acorëhuë'. Nanparin aconanquë acorë' noya a'pinacaso marë'. Piyapi'sa' huë'pachinara, noya quënantopi. Inapochachin Yosë nanamën sha'huitahua' a'napitanta' nitochina'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iporaso' ma'sha noyá po'opinan pochin ni'ton, co insonta' nitotërinhuë'. A'na tahuëriso nipirinhuë' ya'ipiya nitotapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Napoaton noya natanco'. Noya natëhuatama', na'con na'con nitotarama. A'naquënso nipirinhuë', ‘Nani nitotërahuë,’ topirinahuë', co yanatëpihuë' ni'ton, pi'pian tëranta' nitotopiso' Yosëri ananiantarin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ina quëran Quisoso a'shin, iinpita, inapita huë'pi. Quisoso yanontopirinahuë', na'a piyapi'sa' yamopi ni'ton, co nanitopihuë' ya'conacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Napoaton a'naquëni sha'huitërin. —Ni'quë' Maistro. Mamaparin, iyaparinpita, inapita huëcatona', aipiran huaniapi. Yanontërinënquën, itopirinahuë', Quisososo' tapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","—Yosë natëpisopita iyahuëpita pochin ni'nahuë. Sanapi'santa' Yosë nanamën natëhuachina', mamahuë pochin ni'nahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ina quëran a'na tahuëri ca'tano'sanënpita itapon: —Aquëtëran pa'ahua', itërin. Potiquë ya'conahuatona', pëntonapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","24","Quisososo' nipirinhuë', huanconënquë huë'ë́rarin. Paaquëya', panca ihuani manin. Co'sacairi potinën opoto opototahuaton nani yamëntaitapirinhuë', ca'tano'sanënpitari pa'yanatona', ochinanpi. —¡Maistro, Maistro, chimiitarihua'! Catahuacoi, itopi. Quisososo' huënsërahuaton, ihuan a'parin. Sononta' panca co'sacaitapirinhuë', asanoirin. A'naroáchin copitënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—¿Onpoatomata' co natëramacohuë? itërin. Inapitaso nipirinhuë' pa'yanatona', ninontapi. —¿Ma quëmapicha isoso' ni'ton, ihuan a'parin nicaya? Sononta' a'naroáchin asanoirin, nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ina quëran Cariria sono' aquëtëran canconpi, Quirasa parti itopiquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Quisoso nonshiconpachina, a'na quëmapiri nacapirin, na'a sopairo'sari ya'coancantërinso'. Ya'coancantopi ni'ton, co huachi yonquirinhuë'. Hua'qui' co manta' a'morinhuë'. Co huachi pëiquë ya'huërinhuë'. Na'pi naninquë chimipiro'sa' po'mopiquë ya'huárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Na'pochuachina catinaquë tanpaquën tonporahuatona', pa'onta' tonpotopirinahuë', oshitërachinin. Sopai nohuanton, co piyapi ya'huërinquëhuë' ta'antarin. Quisoso quënanahuaton, nantëntaquë isonquirahuaton, monshorarin. Napohuachina, Quisosori nosoroaton, a'naroáchin sopai itërin: —Iso quëmapi quëran pipico huachi, itërin. Ina natanahuaton, chiníquën nonin. —¿Ma'ta' yaonpotarancoi? Quëmaso' Quisosonquën. Yosë hui'ninquën. Yosë marë' ama aparisitocoisohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—¿Ma'ninquënta' quëmaso'? itërin. —Na'a huaranca itërinacoi, topi. Hua'huayatërahuë' sopairo'sari ya'coancantopi ni'ton, ina pochin ninihuanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","“Ama parisitopiquë a'pacoisohuë',” itantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ina ya'cariya na'a coshiro'sa' ya'huërin. Panënquë coshatapi. “Coshiro'saquë tëranta' a'pacoi ya'coanta'ii,” itantapi. “Inta nipachin, inaquë ya'conco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Itohuachina, quëmapi quëran pipirahuatona', coshiro'saquë ya'conconpi. Inaquë ya'conpachinara, coshiro'santa' hua'yantatona', a'naroáchin tahuan pa'topi. Panca sonoquë niitatona', inaquë chimiitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ina ni'sahuatona', coshi a'paina'piro'saso' ta'api. Ninanoquë canconahuatona', sha'huiconpi. Ninano pirayan ya'huëpisopitanta' a'naya a'naya sha'huitëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Natanahuatona', “¿ma'ta' onpocaiso'?” ta'tona', pa'pi nicapona'. Canquirahuatona', quëmapi hua'qui' hua'yantërinso' quënanquipi. Iporaso' Quisoso ya'cariya huënsëarin. Nani a'moanahuaton, noya yonquirin huachi. Co huachi hua'yantërinhuë'. Ina nicatona', pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","“Quisosori anoyatërin. Sopairo'sa' a'patahuaton, anoyatërin huachi. Co huachi hua'yantërinhuë',” topi ni'pisopitari. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Natanahuatona', ya'huëhuano'saso' pa'pi të'huatopi. Të'huatatona', Quisoso itopi: “A'na parti paquë,” itopi. Itohuachinara, potiquë ya'coantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yapa'pachina, quëmapi achin hua'yantërinsori itërin: “Canta' imainquën, topirahuë',” itërin. —Ama huëquësohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ya'huëranquë paantaton, piyapi'sa' sha'huitonquë': “Yosë noyá anoyatërinco,” itëquë', itërin Quisosori. Napotohuachina, pa'nin. Ya'ipi ninanonënquë sha'huitëra'piarin. “Quisoso noyá anoyatërinco,” itëra'piarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Quisoso aquëtëran pëntoantarahuaton, na'a piyapi'sa' quënanconin. Inaquë ninarapi ni'ton, canconpachina nóya nontopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naporo' a'na cotio hua'an cairo itopiso huë'nin. Inaso' niyontonpiso pëi' hua'an ya'conin. Quisoso quënanquirahuaton, nantën pirayan isonquirin. “A'naroáchin Sinioro pëinëhuëquë huëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hui'nahuë yachiminarin,” itiirin. A'naíchin hui'nin ya'huëtërinso' chiníquën caniorin. Shonca cato' pi'ipitërin. Napotohuachina, inarë' pa'nin. Na'a piyapi'sari imasapi ni'ton, Quisoso ya'quëëtërapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Paaquëya', a'na sanapiri imaquiarin. Hua'qui' panca huënai' a'parárin. Nani shonca cato' pi'ipi co sanorinhuë'. Na'a notoro'sari nonënpirinahuë'. Ya'ipi coriqui i'quiaponahuë', co manta' noyatërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Quisoso pinën quëran huëcaton, a'morinso' huirotëínchin së'huaquirin. Së'huahuachina, a'naroáchin huënai' no'narin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—¿Inta' së'huarinco? tënin Quisoso. “Co carinquënso' së'huaranquënhuë',” topi ya'ipiya. —Ni'quëchi Maistro, notohuaro' piyapi'sa' ya'quëëtapirinënquënhuë': “¿Inta' së'huarincoso'?” ¿tënan ti? itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—A'naso' natëtonco, së'huarinco. Së'huahuachincora, nitotërahuë. Ca nohuanto, noyatërin, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","“Nani nitotërin,” ta'ton, sanapi huë'nin. Pa'yanaton, ropa ropátëriarin. Isonquirahuaton, Quisoso itapon: “Hua'qui' caniorahuë ni'ton, së'huaranquën Sinioro. Së'huahuatënquëra, a'naroáchin noyatërahuë,” tënin. Ya'ipi piyapi'sa' natanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Natëranco ni'ton, nani imoya anoyatëranquën. Noya paquë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Quisoso nonaquëya', a'na quëmapi Cairo pëinën quëran huë'nin. —Hui'nan nani chiminin. Ama huachi Maistro apiquësohuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Quisososo' natanaponahuë', itapon: —Ama iyasha pa'yanquësohuë'. Natëco, hui'nan noyachin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pëinënquë canconahuaton, ya'conconin. Pa'pin, a'shin, Pitro, Coansha, Santiaco, inapitaíchin quëparin. “Ama a'napitaso' huë'inasohuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na'a piyapi'sa' na'nëtona', ayanápi. —Ama na'nëcosohuë'. Co sanapia'hua chimininhuë'. Huë'ësárin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","—Co huë'ërinhuë'. Nani chiminin huachi, itatona', tëhuapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Quisososo nipirinhuë' sanapia'hua maimirarahuaton: —Huënsëquë', apia'hua, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A'naroáchin nanpiantarahuaton, huanirin. “Nanon a'caco',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A'shin, pa'pin, inapita pa'yanpi. “Ma'pitacha nitotaton, ananpitaantaran paya,” itopirinahuë', “Ama a'napita sha'huitocosohuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Shonca cato' quëmapi'sa' Quisosori nani huayonin na'con na'con a'chintacaso marë'. Ca'tano'sanënpita itopi. Ayontonahuaton, chiníquën nanan quëtërin sopairo'sa' a'pacaiso marë'. Ina nohuanton, nisha nisha caniori maninsopitanta' anoyatapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","“Paatoma' iyaro'sa', piyapi'sa' a'chintonco'. ‘Yosë yahua'anëntarinquëma'. Huëntonënquë ya'conpatama', noya catahuarinquëma',’ itoco'. Cania'piro'santa' anoyatoco'. Carinquëma catahuaranquëma' anoyatacamaso marë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Pa'patama', ama manta' quëpacosohuë'. Pitana, pë'pëto, pan, coriqui, inapita ama quëpacosohuë'. Ama a'moramaso tëranta' cato' quëpacosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inso pëiquësona yacapatohuatama', ina pëiquëráchin ya'huëco'. Ina ninano quëran pipiamaquë huarë' inaquë ya'huëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A'na ninanoquë pa'patama', “Ama isëquë huëcosohuë'. Co yanatanainquëmahuë',” itohuachinënquëma', patoco'. Yapa'patama', pënënco'. “Nani sha'huitopirainquëmahuë'. Co nohuantëramahuë' ni'ton, canpitaora tëhuënëmaquë nina'intarama',” itoco'. Ina quëran a'na parti paco', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ina quëran ca'tano'sanënpitari pa'sahuatona', noya nanan a'china'piapi. Nisha nisha ninanoquë pënëna'piapi. Na'a cania'piro'sa' anoyatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Napopiso' ya'ipi parti nahuinin. Cariria hua'an Irotisë itopisonta' natantërin. Natantahuaton, nisha nisha yonquirin. “¿Inta' Quisososo'?” itohuachinara, “Coansha Paotista nanpiantarinso' nimara,” topi a'naquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","“Co inahuë'. Iniasë ya'noantarinso' nimara,” topi a'naquëonta'. “Co inahuë'. A'na pënëntona'pi iráca chiminpirinhuë', nanpiantarinso' ipora,” topi a'napitanta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ina natanaton, hua'ani itërin: —Cari Coanshaso' atëpatërahuë, nishitëconotopi. Ina quëmapiso nipirinhuë', nani ma'sha nanitaparin, natantërahuë. ¿Inta' inaso' nimara? Canta' nohuichi, ta'ton ya'nipishahuë yani'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ca'tano'sanënpita huëantarahuatona', Quisoso sha'huitiipi. “Nani a'chinai. Cania'piro'santa' anoyatërai,” itiipi. Napotohuachinara: “Huëco' iyaro'sa' canpoara pa'ahua',” itërin Quisosori. Itohuachina, Pitsaitaquë pa'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na'a piyapi'sari natanahuatona', imapi. Canquihuachinara, Quisosori noya nontërin. Yosë hua'anëntërinquë ya'conacaiso' a'chintarin. Nani a'chintahuaton, cania'piro'sa' a'naroáchin anoyatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nani i'huararahuaso', ca'tano'sanënpitari itiipi: —Nani i'huarin. Co manta' isëquë ya'huërinhuë'. Piyapi'sa' a'paquë' pa'ina'. Isoshara'huaya ninanoro'sa', pëiro'sa', inapita ya'huërin. Inaquë cosharo' pa'anatona', ca'ina'. Naporahuatona', inaquë huë'ëpachina', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Canpitari a'caco', itërin Quisosori. —Capa isëquë capacaso'. A'natërapoya pan, catoya sami, inaíchin ya'huëtërincoi. Notohuaro piyapi'sa' ya'huërin. Quiya pa'anahuatoi, ¿ina nápo' ya'pi a'ca'ii ti? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A'natërápo huaranca pochin quëmapi'sa' ya'huëpi ni'ton, napopi. Ina quëran ca'tano'sanënpita itërin: —Piyapi'sa' sha'huitoco' huënsë'ina'. A'natërápo shonca, a'natërápo shonca pochin huënsë'ina', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sha'huitohuachinara, ya'ipiya huënsëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nani huënsëhuachinara, Quisosori a'natërapoya pan, catoya sami, inapita ma'patërin. Inápaquë në'pëtahuaton, Yosë nontërin: “Yosparinquën, Tata,” itahuaton, pan, sami, inapita së'panahuaton, ca'tano'sanënpita quëtërin. “Piyapi'sa' quëtonco' ca'ina',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Quëtohuachinara, ya'ipi piyapi'sa' coshatopi. Natëaquëhuarë' coshatopi. Ina quëran ca'tano'sanënpitari pë'sotopiso' masahuatona', shonca cato' i'më' amëntatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A'na tahuëri Quisoso inaora pa'nin Yosë nontacaso marë'. Ca'tano'sanënpitaráchin inaquë ya'huëpi. Nani Yosë nontohuachina, Quisosori itërin: —Nani ma'sha nanitaparahuë ni'to, ¿in pochinta' piyapi'sa' cancantiarinaco? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—“Coansha Paotistaco' nanpiantarinso',” topi a'naquën. “Co inahuë'. Tata Iniasëco' nanpiantarinso',” topi a'naquëonta'. “Co inahuë'. A'na pënëntona'pi iráca chiminpirinhuë', nanpiantarinso' nimara,” topi a'napitanta', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Canpitaso nipirinhuë' ¿ma'ta' yonquirama'? itërin Quisosori. —Quëmaso' Cristo, Yosë a'paimarinquënso', itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitrori napotopirinhuë': “Ama inaso' ipora a'napita sha'huitocosohuë',” itahuaton, sha'huitërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Yosë quëran quëmapico niporahuë', na'con parisita'huaso' ya'huërin. Cotio ansiano'sa', corto hua'ano'sa', cotio maistro'sa', inapita co huachi quë'yaponacohuë'. Tëpararinaco. Napoaponahuë', cara tahuëri quëran Yosë ananpitaantarinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ina quëran piyapi'sa' pënëantarin. —Yaimapatamaco, canpitaora nohuantëramaso' naniantoco'. Yosë nohuantërinsoráchin imaco huachi. Corosëquë chiníquën parisitërë'. Canpitanta' parisitapomarahuë', nani tahuëri imamiatoco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Noya nanpicamasoáchin yonquihuatama', topinan quëran nanpiarama'. A'na tahuëri chiminatoma', parisitomiatarama'. Nipirinhuë', casáchin yonquihuatamaco, parisitapomarahuë', co topinan quëran nanpiaramahuë'. Yosë'pa' nanpimiatarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ya'ipi ma'sha isoro'paquë canapiramahuë', co hua'yanëma' cha'ëpachinhuë', co canamiataramahuë'. ¡Onponta' pahuërëtapiramahuë', co huachi hua'yanëma' nanitarinhuë' cha'ëcaso'! ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Imapatamaco, tëhuaponënquëma'. Tapayatomaco a'pohuatamaco, a'na tahuëri carinquëmanta' a'poaranquëma'. Nanamëhuë a'pohuatama', carinquëmanta' o'mantahuato, a'poaranquëma'. Yosë quëran quëmapico ni'to, o'mantararahuë. Tata huënaratërinso pochin canta' huënaratarahuë. Noya anquëniro'sapitaro'co o'mantararahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No'tëquën itaranquëma'. Yosë isoro'pa' hua'anëntapon. A'naquëma' co'huara chimiantërasënquëmahuë', hua'anëntërinso' ni'sarama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Posa tahuëri quëran Quisoso motopiquë pa'nin. Pitro, Coansha, Santiaco, inapitaráchin quëparahuaton, Yosë nontacaso marë' pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yosë nontaso', nisha pochin ya'norin. A'morinsonta' huënaráchin huënaráchin ninin. Huiri huiríchin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","A'nanaya Moisësë, Iniasë, inapita ya'nopi. Inahuanta' huënaráchin huënaráchin nipi. Quisosorë' ninontapi. “Quirosarinquë pa'pato, tëpararinaco,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ca'tano'sanënpitaso nipirinhuë' huë'ëi' iquitatona', yahuë'ëpirinahuë'. Capayatantahuachinara, Quisoso huënaráchin nininso' quënanpi. Moisësë, Iniasë, inapitanta' quënanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Inapitaso' yapanantahuachinara, Pitrori itapon: —¡Ma noyacha Maistro isëquë huë'nëhua paya! Cara imënamëa'huaya nii, a'nara' quëma marë', a'nanta' Moisësë marë', a'nanta' Iniasë marë', topirahuë', itërin. Co yonquiatonhuë', napotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Napotaquëya', chitorori imotërin. Ya'ipiya imotërin ni'ton, pa'yanpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chitoro' huancana quëran Yosëri nontërinso' natanpi. “Isoso' hui'nahuë huayonahuëso'. Ina natanco',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nani nontohuachina, ni'sápirinahuë', co a'napita quënanpihuë'. Quisosoráchin quënanpi. Ina yonquiatona', co manta' topihuë'. Nani ni'pirinahuë', naporo tahuëri'sa' co insonta' sha'huitopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tahuëririnquë motopi quëran nohuaraimantarahuatona', na'a piyapi'sa' quënanquimapi. Quisoso yonípona' huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A'nariso' nontiirin. —Huëquë' Maistro, hui'nahuë nitiico. Inaíchin hui'nahuë nipirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","a'nanaya sopairi ya'coancantohuachina, “yai” tosahuaton no'paquë nitë'yatërin. Sa'po sa'po niconin. Pacororárin. Napoin quëran sopairi patohuachina, pa'pi iquirorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ca'tano'sanënpita nontato: “Sopai inquitoco',” itopirahuë', co nanitopihuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","—¡Ma'huantacha ninama paya! Canpitaso' co Yosë natëramahuë'. Co natantochináchinhuë' cancantërama'. Nani hua'qui' a'chintopiranquëmahuë', ¿onporo huarëta' yanatëramaco? tënahuë. Hui'nan quëshico, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Inaquë quëntapirinhuë', no'paquë sopairi ataatantarin. Apacoroantarin. Quisosori ni'sahuaton, sopai itërin: “Hua'huasha tananpitëquë'. Pipimiatëquë huachi,” itërin. A'naroáchin sopai pipirin. Hua'huasha noyatërin huachi. “Pëinënquë iyasha quëpantaquë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ya'ipi piyapi'sari nicatona', pa'yanpi. “¡Ma noyacha Yosëri catahuarin ni'ton, sopai a'parin paya!” topi. Ya'ipi piyapi'sari pa'yanatona', anoyatërinso' yonquirápirinahuë', ca'tano'sanënpita itantarin: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Noya natanco iyaro'sa'. Yosë quëran quëmapico niporahuë', a'na tahuëri sha'huirapihuachinco, piyapi'sa' masarinaco. Ina yonquiráco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Natanaponaraihuë', co nanitopihuë' natëtacaiso'. “¿Onpoatonta' ina pochin nontërinpoa'?” topi yonquinëna quëran. Naporahuaton, të'huatatona' co nohuantopihuë' natanacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ina quëran ca'tano'sanënpita capini ninontatona', “¿Inquënpoacha chini chiníquën nanantërë'pëhuaya?” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Co natanaponahuë', inaora yonquinën quëran Quisoso nitotërin. Napoaton hua'huasha maimirarahuaton, ya'cariya ahuanirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Ama chiníquën nanantacamaso' yonquicosohuë'. Imaramaco ni'ton, hua'huasha nosorohuatama', nosoroaramaco canta'. Nosorohuatamaco, co casáchin nosoroaramacohuë'. Yosënta' nosoroarama'. Inaso' isoro'paquë a'paimarinco. Hua'huaro'sa pochin cancantopisopita Yosëri noya noya ni'nin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A'na tahuëri Coanshari itapon: —A'na quëmapi Maistro ni'nai. “Quisoso nanan quëtërinco,” ta'ton sopairo'sa' a'pararin. Inaso nipirinhuë', co quiya pochin imarinquënhuë' ni'ton, co nohuantëraihuë'. “Ama inapoquësohuë',” itërai, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Tananpitoco' sopai a'pa'in. Insosona co inimicotohuachinpoahuë', catahuarinpoa', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nani ya'caritëriarin Quisoso inápaquë panantacaso'. Napoaton “Onpopionta' Quirosarinquë pa'sarahuë huachi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yapaaton, catoya'pi a'parin. “Paso' ninanoquë pa'i, topirahuë'. Paatoma', natantonco' huë'ëpataquëhua',” itërin Quisosori. Inaquë Samaria piyapi'sa' ya'huëpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Natanahuatona', co Quisoso huëcacaso' nohuantopihuë'. Quirosarinquë pa'sarin ni'ton, co nohuantopihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ina marë' Santiaco, Coansha, inapita no'huitopi. —¿Ma'ta' Sinioro onpochii? Yosë nonchii inápa quëran pën a'paimaton isopita ahuiquichin topiraihuë', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tahuërëtahuaton: —Ama iyaro'sa' napocosohuë'. Tananpitoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ina quëran a'na ninanoquë paantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Papona pochin a'na quëmapiri nontiirin: —Canta' Sinioro imainquën. Insëquësona pa'patan, canta' pa'i, topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—Sacai' imancoso', tënahuë. Ma'sha tananquë ya'huërinsopita huë'ëshinantëna ya'huëtopi huë'ëcaiso marë'. Inairanta' pë'pëtën ya'huëtërin. Caso nipirinhuë' Yosë quëran quëmapico niporahuë', co pëi' ya'huëtërincohuë'. Pa'sápato, co ya'huëmiatërahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A'nanta' huë'pachina: —Imaquico, itopirinhuë'. —Oshaquëran Sinioro imainquën. Tatahuë nani noyá mashotërin. Chiminpachin, cari pa'pitarahuë. Ina quëran imainquën, topirahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—A'naquën co nohuantopihuë' imainacoso'. Chimipi pochin cancantopi. Inapitari pa'pichina', tënahuë. Quëmaso nipirinhuë', ca na'con na'con yonquiatonco Yosë yahua'anëntërinpoaso' sha'huiquë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A'na quëmapinta' huëcaton: —A'na tahuëri Sinioro imasaranquën, topirahuë'. Ipora quëmopinëhuëpita nontëri'i. Nani nontohuato imainquën, itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Quisosori itërin: —Ama iyasha, nisha nisha yonquiquësohuë'. Ni'quë'. A'nëtohuatëra, noya nicatë' ahuëhuatëra, no'tëquën ahuërë'. Niquë notëtahuatë' ahuëhuatëraso', co noya ahuërëhuë'. Inapochachin nisha nisha yonquihuatama', co nanitaramahuë' Yosë hua'anëntërinso' no'tëquën imacamaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ina quëran a'napitanta' sha'huitërin pënëntacaiso'. Canchisë shonca cato' quëmapi'sa' huayonahuaton, catoya catoya a'parin. Nisha nisha ninanoquë a'parin. Oshaquëran ina ninanoro'saquë chachin pa'sarin ni'ton, inapita'ton a'parin pënëntacaiso marë'. Yapa'pachinara itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Tëhuënchachin iyaro'sa', isoro'pa' panca imin pochin ninin. Cayarinso' manëso pochachin piyapi'sa' manë' Yosë imacaiso marë'. Na'a piyapi'sa' ya'huëpirinahuë', caraíchin pënëntarin. Napoaton Yosë nontoco' a'napitanta' a'pa'in pënënchina'. Inaso' ya'ipiya hua'anëntarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Iporaso' a'paranquëma'. Ni'co'. Carniroa'huaro'sa' co nanitopihuë' nia'paicaiso'. A'naroáchin tanan ni'niro'sari manin. A'naquën piyapi'sa' ni'niro'sa pochin cancantatona', no'huiponënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pa'patama', ama manta' quëpacosohuë'. Pë'pëto, coriqui, sapatë co inapita tëranta' quëpacaso' ya'huërinhuë'. Piyapi'sa' nacapihuatama', ama hua'qui' nontocosohuë'. Manóton paco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","A'na pëiquë canconpatama', hua'anën nontoco': ‘I'huata iya. Yosë catahuainquëma',’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Noya nontohuachinënquëma', Yosëri catahuaarin mini. Co'so' noya nontohuachinënquëmahuë', co Yosëri catahuaarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nohuantohuachinënquëma', ina pëinënquë yacahuaco'. A'cahuachinënquëma', ca'co'. O'shitohuachinënquëma', o'oco'. A'chintarama' ni'ton, topinan ca'co'. Ama nisha nisha pëiquë yaca yacapatë́rantacosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","A'na ninanoquë pa'patama', noya nontohuachinënquëma', inaquë a'chintoco'. Ma'sona a'cahuachinënquëma', ca'co'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cania'piro'sa' inaquë ya'huëhuachina', anoyatoco'. ‘Iso tahuëri'sa' Yosë yahua'anëntarinquëma',’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A'naquën piyapi'saso nipirinhuë' co nohuantarinënquëmahuë'. Ina ninanoquë canconpatama', cachiquë paatoma', pënëntoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nani sha'huitopirainquëmahuë'. Co nohuantëramahuë' ni'ton, canpitaora tëhuënëmaquë nina'intarama'. Co natëpiramahuë', Yosëso' yahua'anëntarinquëma',’ itoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ayaro' tahuëri nanihuachin, inapitaso' chiníquën parisitapi, tënahuë. Iráca Sotomaro'saso' pa'pi co noyahuë' nipi ni'ton, Yosëri chiníquën ana'intërin. Co natërinacosopitaso nipirinhuë', chini chiníquën ana'intarin huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ina quëran Quisoso taantarin: “Corasinoquë, Pitsaitaquë inaquëpita ya'huëramaso', ¡ma'huantacha nisarama paya! Na'con pënënpiranquëmahuë', co natëramacohuë'. Ina marë' parisitarama'. Tiroquë, Sitonquë, inaquëpitaso nipirinhuë' co pënëntërahuë'. Co inaquë cania'piro'sa' a'naroáchin anoyatërahuë'. Inaquë naporahuë naporini, oshanëna marë' sëtatona', sa'catën nininso' a'moitonahuë'. Huarianoquënta nipa'samototatona' co noyahuë' yonquipisopita nanianchitonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Napoaton iyaro'sa' ayaro' tahuëri nanihuachin, Yosë chini chiníquën ana'intarinquëma'. Tiroquëso', Sitonquëso', co onpopinchin ana'intarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capinaomoquë ya'huëramasopitanta' co no'tëquën yonquiramahuë'. ‘Noyacoi ni'toi, Yosë'pa' pa'sarai, ¿topiramahuë' ti? Co inatohua' pa'saramahuë'. Parisitopiquë tëhuënchinso' pa'miatarama huachi,’ tënahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ina quëran yaa'parinsopita itaantarin: “Iporaso' pënëntacamaso marë' a'pararanquëma'. Ca ya'huërënamëhuë pënëntarama'. Noya natanpachinquëma', natanarinaco canta'. Co'so' nohuantohuachinënquëmahuë', co canta' nohuantarinacohuë'. Co nohuantohuachinacohuë', co Yosënta' nohuantapihuë',” itërin Quisosori. Itohuachina, pa'pi huachi. Nisha nisha ninanoquë pënëntëra'piapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nani pënëntohuachinara, canchisë shonca catoya'pi chachin nóya cancantatona', Quisosoquë huëantapi. —Sopairo'santa' Sinioro nontërai. “Quisoso nanan quëtërincoi ni'ton, a'parainquën,” itohuatëira, pipipi, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Napotohuachinara, Quisosori itërin; —Sopai hua'an chachin iráca inápaquë ya'huëpirinhuë', Yosëri të'yatërin. O'cori pochin a'naroáchin anotërinso' ni'nahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nani nanan quëtëranquëma' canpitanta' sopai minsëcamaso marë'. Ca yonquiatomaco, sopairo'sa' nontohuatama', patarinquëma'. Ya'huan, yonpinca inapita i'natohuatama', co manta' onpotarinquëmahuë'. Ya'huan yaquëtërinposo pochin sopainta' yaacorinquëma'. Canpitariso nipirinhuë' minsëarama'. Co manta' nanitarinhuë' minsëinquëmaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sopairo'sa' a'papiramahuë', ama ina marëáchin noya cancantocosohuë'. Imaramaco ni'ton, Yosë'pa' pa'sarama'. Inatohua' nininëma' nani ninshitërinquëma'. Ina marë' tëhuënchinso' nóya cancantoco', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naporo' Ispirito Santo nohuanton, Quisoso nóya cancantërin. Noya cancantaton, Yosë nontarin. “Ma noyacha, Tata, yonquiran paya. Quëmaso' chini chiníquën nanantëran. Inápaquë, isoro'paquë, ya'ipi parti hua'anëntaran. Quëma nohuanton, a'naquën nani ma'sha nitotaponaraihuë', co nanamën nitotopihuë'. ‘Quiyaora noya noya nitotarai,’ topiso marë', co nanamën anitotëranhuë'. Imarinacosopitaso nipirinhuë' catahuaran. ‘Catahuaco Sinioro co caora nanitërahuë',’ itohuachinën, quëma nanamën chachin anitotëran. Ina marë' Tata, ‘Yosparinquën,’ itëranquën,” tënin, Yosë nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ina quëran a'parinsopita itantarin. “Tata Yosë nohuanton, chiníquën nanantërahuë. Ya'ipi nanamën anitotërinco piyapi'sa' a'chinta'huaso marë'. Hui'ninco ni'to, tatahuësáchin noyá nohuitërinco. Inapochachin canta' Tata Yosë nohuitërahuë. Casáchin noyá nohuitërahuë. A'naquën piyapi'santa' caora nohuanto, anohuitërahuë. Inapitanta' Yosë nohuitapi huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nani a'chintohuachina, ca'tano'sanënpita amasha quëparahuaton, sha'huitërin: “Isoro'paquë o'mato, nani ma'sha ninahuë. Ma noya Yosë nosororinquëma' ni'ton, ni'nama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iráca quëran huarë' na'a copirnoro'sa', pënëntona'piro'sa', inapita ni'namasopita yani'pirinahuë', co ni'pihuë'. A'chintëranquëmasopitanta' yanatanpirinahuë', co natanpihuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ina quëran a'na maistro iráca nanan noya nitotërinso' huanirahuaton, Quisoso tënicaso marë' itapon: —¿Ma'ta' Maistro onpo'i nanpimiata'huaso marë'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—Iráca Yosë quiricanën quëran ninshitaton, pënëninpoa'. ¿Ma'ta' tënin? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—“Tata Yosë hua'anëntërinpoa'. Ina nosoroco'. Ya'ipi cancanëma quëran, ya'ipi hua'yanëma quëran, ya'ipi chinirama quëran, ya'ipi yonquinëma quëran, ya'ipi inaquëranpita nosoromiatoco'. Isonta' Yosë nohuantërin: Quëmaora ninosororanso pochachin a'napitanta' nosoroco',” tënin, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—No'tëquën naporan. Ina pochin nipatan, Yosë pochin cancantaton, nanpimiataran huachi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","—Ina nitotaporahuë', ¿ma'ta' onpo'i? ¿Inpitaquë huarëta' nosoro'i? itaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","—Inta nipachin a'chinchinquën. A'na cotio quëmapi Quirosarinquë ya'huërin. A'na tahuëri Quiricoquë pa'sapirinhuë'. Paaso', tëpatoro'sari mapi. Ahuëatona', ihuapi. Ai'nanpiratopi. Yachimiánin patopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ina quëran cotio corto hua'an ina ira chachin pa'tapirinhuë'. Quëmapi quënanconaponahuë', pëshonanpirahuaton na'huëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ina piquëran a'na quëmapinta' pa'sarin. Inaso' Nihui huënton quëmapi ni'ton, corto hua'an catahuarinso'. Inarinta' quënanconaponahuë', inapotaantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ina quëran Samaria quëmapirinta' quënancoantarin. Inaso' nisha quëmapi niponahuë', nosororin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ya'cariconahuaton, catahuarin. Pë'shapiso' tomaquë, huinoquë, inaquëpita pashitërin. Inapotahuaton tonpotërin. Ina quëran inaora moranënquë acorahuaton, huë'ëpatacaso pëiquë quëparin. Inaquë a'pairin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tahuëririnquë catotë' coriqui prata quëran nininso' pëi' hua'anën quëtërin. “Paso' ninanoquë pa'sarahuë. Quëmari a'paiquë'. Coriqui pahuanpachin, quëmaora coriquinën castaquë'. Huënantahuato, i'huërëchinquën,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ni'quë' iyasha. Caraya'piri ahuëpiso' quënanconpi. ¿Insoarita' iin pochin nosororin? itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Nisha piyapiri nosororinso', tënin. —Ina mini. Paaton, quëmarinta' inapochachin nosoroquë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ina quëran paantahuaton, a'na ninanoquë canconin. Inaquë Marta ya'huërin: —Huëquë' Sinioro ni'quicoi, itohuachina, ya'conapatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martaso' cain ya'huëtërin, Maria itopiso'. Quisoso huë'pachina, ya'cariya huënsëquirin. A'chininso' noya natanarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martaso nipirinhuë' cosharo nicaton sacatárin. Nisha nisha yonquiaton, Quisoso huëcapairin: —Caihuë Sinioro topinan huënsëárin. Caora cosharo' nisarahuë. Sha'huitëquë' catahuainco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Imoya. Nisha nisha ma'sha yonquiaton, co noya cancantëranhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Casáchin natancoso' na'con na'con nohuantërahuë. Mariaso' natanatonco, noya noya nisarin. Na'con yonquirinco ni'ton, noya cancantomiatarin tënahuë, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A'na tahuëri Quisoso Yosë nontárin. Nani nontohuachina, ca'tano'sanëni itërin: —A'chintocoi Sinioro Yosë nonta'huaiso'. Coanshaso' imarinsopita a'chintërin. Quiyanta' a'chintocoi nitochii, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","—Inta nipachin a'chinchinquëma'. Yosë yanontohuatama', iso pochin nontoco': “Tata Yosë, quëmasáchin noya noyanquën ni'ton, ya'ipi piyapi'sa' chinochinënquën. Chini chiníquën nanantëran ni'ton, ya'ipicoi natëiinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nani tahuëri catahuacoi cosharo' ya'huëchincoi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Co noyahuë' nicatoi, oshahuanai. Nosoroatoncoi, oshanëhuëi inquitocoi. A'napita ma'sha onpotohuachincoi, nanan anoyatëraiso pochachin oshanëhuëi inquitatoncoi anoyacancantocoi. Co noyahuë' yonquihuatoi, catahuacoi a'naroáchin nanianchii,” itoco', Yosë nontohuatama', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ina quëran a'chintantarin. —Ni'co' iyaro'sa'. Ni'toro'sa' huë'pachinara, capa a'cacaso' nipachina, a'na piyapi pëinënquë pa'në'. Yono tashi' nipirinhuë', ma'sha nitonë'. “Cara pan quëtoco iyasha. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nipayaraiso' huë'pirinhuë', co manta' a'ca'huaso' ya'huëtërincohuë',” tënë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yono tashi' ni'ton, co nohuantaponhuë' nimara. “Paquë' iyasha. Nani ya'coana oncotërahuë. Hui'nahuëpitanta' huë'ësápi. Co nanitërahuë' quëta'huanquënso',” tapon nimara. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nipayarinso' niponahuë', co nohuantopirionta', naquëranchin naquëranchin nitantahuachina, huënsëintarahuaton, quëtapon. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Napoaton Yosë na'con nontoco'. Pahuantërinquëmaso' nipatama', quëtarinquëma'. Ma'sha yonirëso pochin cancantatoma', nontáco' catahuainquëma'. Ya'coana pi'nirëso pochin cancantatoma', nontoco' aya'coinquëma' ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tëhuënchachin ma'sha nitohuatama', quëtarinquëma'. Hua'qui' ma'sha yonípatama', quënanarama'. Ya'coana pi'nirëso pochin nipatama', i'soatarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Hui'nama' tanaton, ‘Sami nayarahuë,’ itohuachinquëma', co ya'huan quëtaramahuë'. Co insonta' nohuantërinhuë' hui'nin inapotacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ataricayonta' natanpachinquëma', co yonpinca quëtaramahuë'. Noya cosharo' quëtarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Canpitaso' co noyahuë' yonquiapomarahuë', hui'nama' nosororama'. Noya ma'sha quëtërama'. Yosëso' noya noya ni'ton, na'con na'con nosororinquëma'. Inápaquë ya'huaponahuë', hui'ninpita pochin ni'ninquëma'. Nontohuatama', ‘Ispirito Santo aya'coancantoco,’ itohuatama', aya'coancantarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ina quëran a'na quëmapi huë'nin. Sopairi ya'coancantërin ni'ton, co nanitërinhuë' nonacaso'. Quisosori quënanahuaton, sopai a'patërin. Nani a'patohuachina, noya nonin huachi. Piyapi'sari nicatona', pa'yanpi. “¡Ma noyacha ni'ton, a'naroáchin sopai a'parin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A'naquënso nipirinhuë' nisha yonquipi. “Sopairo'sa' hua'anën Piirsipo itopisoari catahuarin ni'ton, nanitaparin sopai a'pacaso',” toconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A'napitarinta' Quisoso itapona': “Yosë pochin niquë' ni'iinquën,” itonpi. Tënicaiso marë' napotopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","18","Quisososo nipirinhuë' yonquipiso' nitotaton, itërin: “Co Satanasë catahuarincohuë' sopairo'sa' a'paca'huaso'. Inaso' sopairo'sa' hua'anën ni'ton, co sopairo'sa' no'huirinhuë'. Nino'huipi naporini, co huachi hua'anëna nicacaso nanichitonhuë'. Ni'co'. Ninanoquë ya'huëpisopita nino'huipi naporini, yanquë'itonahuë'. Quëmopinëna capininta' nino'huipi naporini, yanquë'itonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A'naquën a'chintëramasoarinta' sopairo'sa' yaa'papi. Piirsipo catahuarinco tënama' ni'quëhuarë', inapitanta' inari catahuarin. Napoaton inapita natanpatama', co no'tëquën yonquiatomahuë' naporamaso sha'huitarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Caso nipirinhuë', Yosë catahuarinco sopairo'sa' a'paca'huaso'. Ina nohuanton, a'parahuë. Napoaton Yosë chachin a'paimarinco hua'anënta'huanquëmaso marë', tënahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Quëmapi chiníquën nipachina, pëinën noya a'pairin. Sahuëni, shonqui, inapita ya'huëtërin ni'ton, co insonta' nanitërinhuë' ma'shanënpita ihuacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A'naso nipirinhuë' ina quëran chini chiníquën ni'ton, huëcapairahuaton minsërin. Sahuëni, shonqui, inapita matahuaton, ma'shanënpitanta' quiquitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Insosona co imapachincohuë', inimicotarinco. Co catahuahuachincohuë', piyapi'sa' anishacancantarin ama Yosë imacaiso marëhuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Naquëranchin a'chiantaton, itaantapon: “A'na quëmapi ya'huërin. Sopairi ya'coancantopirinhuë', ina quëran pipirin. Pipihuachina, inotëro parti pa'sárin. Insëquësona ya'huëcaso marë' yonisapirinhuë', co quënaninhuë'. Napoaton ina quëmapiquë chachin huëantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Inaso' co Yosë yonquiatonhuë', topinan ya'huárin quënanquiantarin. Noya ya'huëantachinachin ni'ton, yaya'coancantantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Napoaton paantarahuaton, canchisë sopairo'sa' aquë aquëtë' co noyahuë' nipisopita maantarin. Posa sopairo'sari chachin quëmapi ya'coancantantapi. Inaquë ya'huápi. Quëmapi aquë aquëtë' co noyahuë' yonquirin huachi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na'a piyapi'sa' natanapi. A'na sanapiso' natanahuaton, itërin: —Ma noya a'chintërancoi. Mamaparinquën hua'huarinquën ni'ton, ma noya Yosëri ni'nin. ¡Aso'sorinquën ni'ton, nóya cancanchin! tënahuë, tënin chiníquën nonaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Inaso napopirinhuë', Quisosori itapon: —Yosë nanamën natanahuatona natëpisopita tëhuënchinso', noya noya cancantapona' tënahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na'con na'con piyapi'sa' huë'pachinara, itantarin: “Iporaso' na'a piyapi'sa' co noyahuë' yonquipi. ‘Yosë pochin niquë' ni'iinquën. Ina ni'patoi natëarainquën,’ itopirinacohuë', co Yosë nohuantërinhuë' ina pochin nica'huaso'. Isoíchin anitotaranquëma'. A'na tahuëri Conasë naporinso pochin nisarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ninihuiquë ya'huëpisopita co noyahuë' nipachinara, Yosëri a'parin pënënacaso marë'. Canta' Yosë quëran quëmapico ni'to, pënënaranquëma' Yosë ayonquianta'huanquëmaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Ayaro' tahuëri nanihuachin, Ninihuiquë ya'huëpisopita sha'huirapiarinënquëma'. ‘Conasë pënënpachincoi, oshanëhuëi marë' sëtërai. Ina naniantatoi, Yosë yonquirai. Canpitaso nipirinhuë' noya noya nininso' natanpiramahuë', co natëtëramahuë'. Napoaton na'con na'con oshahuanama',’ itarinënquëma'. Inapochachin Saromon hua'anëntohuachina, Sor parti quëran sanapi copirno huë'nin ina natanacaso marë'. ‘Ya'ipi nitotërin,’ ta'ton, natanapon huë'nin. Napoaton ayaro' tahuëri inanta' atapanarinquëma'. Saromon quëran caso' na'con na'con nitotopirahuë', co yanatëramacohuë'. ‘Ina marë' na'con na'con oshahuanama',’ itarinënquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nanparin i'chinpihuatëra, co ma'sha acohuana po'orëhuë'. Co i'mëanaquë po'morëhuë'. Nanparin aconanquë acorë'. Ina quëran piyapi'sa' huë'pachina', noya quënantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ya'piranpo' nanparin pochin ninin. Ina quëran ma'sha quënanë'. Noya ya'piranpo' nipachina, noya quënantërë'. Ya'piranpo' co noyahuë' nipachina, co noya quënantërëhuë'. Inapochachin noya yonquihuatëra, noya cancantërë'. Co noyahuë' yonquihuatëra, tashi pochin cancantërë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Napoaton, ni'cona tashi pochin cancantotama'. No'tëquën a'chintopiranquëmahuë', co noya natanpatamahuë', tashi pochin cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Noyasáchin yonquihuatama', co tashi pochin cancantaramahuë'. Nanparin noya orotërinso pochin nisarama'. Noyápiachin cancantarama',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nani a'chintohuachina, a'na Parisiori amatërin coshatacaso marë'. Ina pëinënquë pa'sahuaton, coshatacaso marë' huënsërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parisioro'saso' yacoshatohuachinara, i'shaquë pi'pian niopoimiratopi. “Inapohuatëhua', oshanënpoa' inquiarëhua',” topi. Quisososo nipirinhuë' yacoshatohuachina, co ina pochin nininhuë'. Ina marë' pëi' hua'anën pa'yanin. “¿Onpoatonta' topinan coshatarin?” ta'ton, yonquirarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yonquirinso' Quisosori ninoton, itërin: —Canpitaso' aipi quënanamasoráchin yonquipiramahuë', Yosëso' acopo' cancanëma quëran yonquiramasopita ni'nin. Ni'co'. A'naquën minë', sënan, inapita pa'mohuachinara, pinënáchin pa'mopipi. Acoposo nipirinhuë' në'huënantëtërin. Inapochachin canpitaso' cancanëma quëran co noyahuë' yonquirama'. Piyapi'sa' nonpintatoma', yaihuarama'. Pa'pi co noyahuë' cancantërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Co no'tëquën yonquiramahuë'. Co nonënpoáchin Yosë acotërinpoahuë'. Cancanënpoanta' acotërinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Cancanëma quëran huarë' sa'ahuaro'sa' catahuaco'. Nosorohuatama', noyápiachin cancantarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Parisioro'sanquëma', ¡ma'huantacha canpitaso' nisarama paya! ‘Nani ma'sha canarëhua quëran, diesmo Yosë quëtacaso' ya'huërin,’ itërinpoa' Moisësë. Ina natëpiramahuë', co noya ninamahuë'. Nani ma'sha sha'nama quëran, diesmo quëtërama'. Ya'ipi cosharo' apimotacaso marë' sha'namaso manama quëran huarë', diesmo quëtërama'. Napoaponahuë', co Yosë nosororamahuë'. Piyapi'santa' yanonpintërama'. Ina marë' Yosë ana'intarinquëma'. Diesmo Yosë quëtacaso' noya nipirinhuë', nosorocaso' na'con na'con nohuantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Parisioro'sanquëma', ¡ma'huantacha canpitaso' nisarama paya! Niyontonpiso pëiquënta' piyapi'sa' nocanama'. Hua'ano'sapitarë'quëma' yahuënsëconama'. ‘Ma noyacha canpitaso' nitotërama',’ itohuachinënquëmara, pa'yatërama'. Cachiquë pa'patamara: ‘Huë'cama maistro,’ itohuachinënquëmara, pa'yatërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ma'huantacha canpitaso' nisarama paya! Chimipi pa'pitopiso pochin niconama'. Co corosë acotohuachinarahuë', acopo' co nishinahuën' nisarinso co nitotatonaraihuë', piyapi'sari i'natopi,” itërin Quisosori parisioro'sa' nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A'na cotio maistrori natanahuaton, no'huirin. —Ina pochin pënëntaton Maistro, quiyanta' anatantarancoi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Napotohuachina, cotio maistro'santa' pënënaton, itapon: —¡Ma'huantacha canpitanta' nisarama paya! Na'con piyapi'sa' pënënpiramahuë', nani ma'sha natëcaiso' sha'huitërama' ni'ton, panca pë'pëtërëso pochin ninatanpi. A'chintopiramahuë', co pi'pisha tëranta' catahuaramahuë' natëcaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Iráca pënëntona'piro'sa' pënëntopirinahuë', canpita shimashonëmapitari co natëtonaraihuë', tëpapi. Canpitanta' pa'pitopiso' pëirapipiramahuë', co natëramahuë'. Ina marë' canpitanta' Yosë ana'intarinquëma' ni'ton, ¡ma'huantacha nisarama paya! ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Shimashonëma pochin cancantatoma', inapitari tëpatona pa'pitopiso', canpitari topinan quëran pëirapirama'. Co natëramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yosë no'tëquën ninorinquëma'. Iráca chachin naporin: ‘Na'a quëmapi'sa' a'pararahuë pënëinënquëmaso marë'. A'chintapirinënquëmahuë', no'huitoma', ahuëarama'. A'naquën tëpaarama',’ itërinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Isoro'pa' ninin quëran huarë' noya quëmapi'sa' pënëntopirinahuë', na'a tëpapi. Apiri'ton noya quëmapi nipirinhuë', iini tëparin. Ina piquëran a'naya a'naya noya pënëntopirinahuë', tëpara'piapi. Na'a pi'ipi napopi. Napoin quëran Sacariasë tëpapi anta'. Yosë chinotopiso pëiquë chachin tëpapi. Canpitaso nipirinhuë' ina nitotapomarahuë', co natantochináchinhuë' cancantërama'. Napoaton Yosë na'con na'con ana'intarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ma'huantacha cotio maistro'sanquëma' nisarama paya! Niahui osërëtërëso pochin co Yosë nanamën no'tëquën a'chintëramahuë' ni'ton, piyapi'sa' co Yosë nohuitopihuë'. Co canpita tëranta' Yosë huëntonënquë ya'conamahuë'. A'napitanta' yaya'conpirinahuë', co nohuantëramahuë'. Ina marë' Yosë ana'intarinquëma',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nani tonitohuachina, parisioro'sa', cotio maistro'sa', inapitaso' chiníquën no'huitopi. No'huitatona', nisha nisha Quisoso natanpi atëhuëcaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","“Co no'tëquën nonpachinhuë', sha'huirapiahua',” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hua'huayatërahuë' piyapi'sa' niyontonpi Quisoso natanacaiso marë'. Na'a huaranca yamorapi ni'ton, niya'quëtapi. Ca'tano'sanënpita a'chintaton, itapon: “Tëhuënchachin iyaro'sa', parisioro'sa' yanonpinpi. Napoaton a'chinpiso', pan ahuëpocatërinso pochin niconaton a'naroáchin piyapi'sa' yanonpintopi. Ni'cona nonpintochinënquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A'naquën po'oana quëran ma'sha nipi. Ma'sha po'orëso pochin nipirinahuënta', a'na tahuëriso' ya'ipi piyapi'sari nitotapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tashi' napopiramahuë', naporamaso' tahuëri anitotapi. Pëi' acoana nisacarotopiramahuë', a'na tahuëriso', naporamaso' a'ninquëchin sha'huitapi. Ya'ipi piyapi'sa' nitotapi huachi,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ina quëran itaantarin: “Ama iyaro'sa', piyapi'sa' të'huatocosohuë'. Tëpapirinënquëmaonta', co hua'yanëma' matarinënquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yosë tëhuënchinso' të'huatacaso' ya'huërin, tënahuë. Co noyahuë' nipatama', Yosë hua'yanëma' matahuatënquëma', parisitopiquë a'pamiatarinquëma'. Napoaton ina na'con na'con të'huatoco'. Co piyapi'sa' të'huatacaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Yosëso' a'pairinquëma'. Ni'co'. Inairaro'sa' co pa'tonhuë'. A'natërápo nipirinhuë', catotë' coriquia'huaíchin pa'tërin. Napoaponahuë', co a'naya tëranta' Yosëri naniantërinhuë'. Canpitaso' na'con na'con yonquirinquëma'. Noya noya a'pairinquëma'. Noyá nohuitërinquëma'. Ainëma' hua'huayátërahuë nipirinhuë', ya'ipi pichirin. Napoaton ama të'huacosohuë'. Ni'sárinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ina quëran taantarin: “Tëhuënchachin iyaro'sa', ‘Quisoso imarahuë,’ topatama', ayaro' tahuëri canta' nohuantaranquëma'. ‘Imarinco mini,’ itarahuë Yosë'pa'. Anquëniro'santa' natanapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nipirinhuë', Yosë quëran quëmapico nipirahuë' a'pohuatamaco, carinquëmanta' a'poaranquëma'. ‘Co nohuitërinacohuë',’ itarahuë. Anquëniro'santa' natanapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","A'naquën no'huitonaco, pinorinaco. Ina quëran oshanëna marë' sëtohuachina', Yosëri oshanëna' inquitarin. Nipirinhuë' Ispirito Santo pinotona' oshahuanpiso', co onporonta' inquitarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A'na tahuëri mapachinënquëma', cotio niyontonpiso pëiquë quëpaarinënquëma'. Hua'ano'sa', coisëro'sa', inapitaquë sha'huirapihuachinënquëma', ‘¿Ma'cha tono'pocoya?’ ama tocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Naporo' Ispirito Santo catahuaarinquëma' noya a'panitacamaso',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na'a piyapi'sa' natanasoi', a'nari huëcapairin. —Maistro, tatahuë nani chiminin. Nani ma'sha ya'huëtopirinhuë', patërin. Iyahuëso' nipirinhuë' apiratërinco. Co nohuantërinhuë' patomatiincoso'. Sha'huitëquë' patomachinco, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Co coisë pochin nica'huaso' ya'huërinhuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Napotahuaton, ya'ipiya pënënin. —Ama iyaro'sa' ma'sha canacamasoáchin yonquicosohuë'. Co nani ma'sha ya'huëtinquëma' huarë' noya nanpiaramahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Itahuaton, a'na pënënto nanan sha'huitërin. “Ni'co'. A'na ma'huan ya'huërin. Iminënquë sha'pachina, hua'huayátërahuë nitërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Napoaton ya'ipi pëinënpita ya'sotërin huachi. ‘¿Insëquëcha ma'sha aco'iya?’ ta'ton, yonquiárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yonquihuachina, tapon: ‘Pëiro'sa' i'quitahuato, a'na pëiro'sa' niantarahuë. Panca panca nisarahuë. Inaquë ya'ipi ma'shanëhuëpita acoarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na'a ma'sha ya'huëtërinco. Co apípora nohuantarahuë'. Co huachi sacatarahuë'. Noya coshatápo. Noya o'opo. Capa cancantato, nóya ya'huápo,’ tënin yonquinën quëran. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Napopirinhuë', Yosëri itërin: ‘Quëmaso' co manta' yonquiranhuë'. Ipora tashi chachin ca nohuanto, chiminaran. Nani ma'sha canapiranhuë', ya'ipiya pataran ni'ton, a'napitari mapon,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Canpitanta' nani ma'sha canapomarahuë', co Yosë yonquihuatamahuë', ina ma'huan pochin nisarama'. Co manta' ya'huëtomiatarinquëmahuë'. Co Yosë'pa' canamiataramahuë',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ina quëran ca'tano'sanënpita itapon: “A'naquën ma'sharáchin yonquipi. Capacaiso', o'ocaiso', a'mocaiso', inasáchin yonquipi. ‘Nani ma'sha ya'huëtohuachinco, nóya ya'huarahuë,’ topirinahuë' yonquinëna quëran. Ama iyaro'sa' ina pochin cancantocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yosë chachin ananpirinpoa'. Nonënpoa' quëtërinpoa'. Co capacaso marëáchin isoro'paquë acorinpoahuë'. Noyápiachin a'mocasonta' co onpopinchin yonquicaso' ya'huërinhuë'. Yosë na'con na'con yonquihuatëhua', catahuarinpoa' noya ya'huëcaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ni'co'. Inairaro'sa' co sha'topihuë'. Co cayarinso' sënapihuë'. Cosharo' tapacaso marë' co pëi' ya'huëtopirinahuë', Yosëri catahuarin. Ina nohuanton, cosharo' ya'huëtopi. Canpitaso' inapita quëran na'con na'con nosororinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ama nisha nisha yonquiatoma', napion cancantocosohuë'. Chiminacaso' nanihuachin, co huachi a'na ora tëranta' nanpicaso' ya'huërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Canpitaora co manta' nanitapapiramahuë'. Yosë nohuanton, noya ya'huërama'. Napoaton sano yonquiatoma', ya'huëco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ni'co'. Yancoro'sa' co sacatopihuë'. Co manta' a'mocaso nipihuë'. Nipirinhuë', noyápiachin yancotopi. Iráca copirno Saromon nani ma'sha ya'huëtërin. ‘Ma noyápiachincha a'morin paya,’ topi. Yancoro'saso' napoaponahuë', ina quëran noya noya ya'nopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pacatoro quëran huarë' Yosëri yonquirin. A'na tahuëriíchin ya'huëpirinhuë', ahuihuachina, ahuiquitërë'. Co hua'qui' ya'huëpirinhuë', Yosëri yonquirin. Ina nohuanton, noya papotërin. Canpitaso' ina quëran na'con na'con yonquirinquëma'. Ina nohuanton, a'mocamasonta' ya'huëtarinquëma'. ¿Onpoatomata' nipachin co natëramahuë'? ‘Yosë catahuarinco mini,’ ta'caso nipirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ama ma'sha yonquiatoma', pa'yancosohuë'. ‘¿Ma'cha ca'në'poya? ¿Ma'cha o'orë'poya?’ ama tocosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Co Yosë imapisopitahuë' ina pochin yonquipi. Ma'sharáchin yonquipi. Canpitaso nipirinhuë', tatanëma' inápaquë ya'huërinso' yonquirinquëma'. Ya'ipi pahuantërinquëmasopita nitotërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Napoaton Yosë na'con na'con yonquico'. A'napitanta' catahuaco' hua'anëntërinquë ya'conacaiso marë'. Ina pochin cancantohuatama', Yosë catahuarinquëma'. Ina nohuanton, ma'sha pahuantërinquëmasopita ya'huëtarinquëma',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Naquëranchin itaantarin: —Ama iyaro'sa' pa'yancosohuë'. Ohuica pë'tahuana'pi pochin nicato a'paiaranquëma'. Caraichinquëma' nipomarahuë', Yosë noya ni'ninquëma'. Hua'anëntërinquë chachin aya'coninquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ama na'con ma'sha yontoncosohuë'. Ma'sha ya'huëtohuachinquëma', pa'anahuatoma', sa'ahuaro'sa' quëtoco'. Inapotohuatama', Yosë acanaarinquëma'. Isoro'paquë ma'sha a'naroáchin mocarin. Ihuarinënpoa'. Ma'shari a'quirin. Inapaquëso nipirinhuë' Yosë acanahuachinpoa', ya'huëtomiatarinpoa'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma'sharáchin nohuantohuatama', co Yosë yonquiaramahuë'. Nipirinhuë', Yosë na'con nohuantohuatama', ina na'con na'con yonquiarama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ina quëran taantarin: “Noya yonquiatoma', capayatërëso pochin cancantoco'. Ni'co'. A'na patron sa'acaso marë' pa'nin. Onporosona huënantacaso' co piyapinënpita nitotopihuë'. Napoaton noya nitaparahuatona', nanparin i'chinpirahuatona', ninarapi. Canquiton, onconan pi'nihuachina, a'naroáchin i'soatacaiso' ya'huërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Piyapinënpita ninarapi quënanquintahuachina, hua'anëni nóya ni'sarin. Inari chachin nitaparahuaton, cosharo' acotarin piyapinënpita capacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yono tashihuë nipon, tahuëri ya'carihuë nipon, huënantarin. Co huë'ëponaraihuë' ninarapi quënanquintahuachina, noya ni'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Isonta' yonquico': Ihuatë' a'nanaya huëcaton, pëiquë ya'conin. Hua'anën co nicasohuë', ma'sha ihuarin. Onporosona huëcacaso' nitotërin naporini, hua'anëni ninaitonhuë', co ma'shanënpita ihuaitonhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yosë quëran quëmapico ni'to, canpitanta' ninatomaco, ya'huëco'. Hua'quihuato: ‘Co a'naroáchin o'mantararinhuë',’ tosapi a'naquën. Co nitotasënquëmahuë', a'nanaya o'mantararahuë,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Napohuachina, Pitrori natanin: —¿Ya'ipi piyapi'sa' Sinioro pënënaran? ¿Quiyasáchin nica? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Napotohuachina: “Ni'co' iyaro'sa'. O'maca'huaso tahuëri a'na patron pochin nisarahuë. Inaso' aquë yapa'pachina, inpriatonën noya natërinso' sha'huitërin. ‘Piyapinëhuëpita noya ni'quë'. Cosharo', ma'sha, inapita pahuantohuachina', quëtëra'piraquë',’ itahuaton pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Inpriatoso' noya yonquihuachin, no'tëquën natërin. Patronëni huëcapaintahuachina, noya ni'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Noya natërin ni'ton, acoarin ya'ipi ma'shanënpita a'paicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nipirinhuë', inpriatonën nisha cancantohuachin, tapon: ‘Patron hua'quirarin. Co a'naroáchin huëntaponhuë',’ ta'ton, piyapinënpita ahuëapon. Cosonanënpitanta' ahuëapon. Pita nicacasoáchin cancantapon. No'pirápon. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Napoaso', a'nanaya patronëni quënanquiantapon. Co nitotasohuë', a'nanaya canquipon. Co natërinhuë' ni'ton, ocoirahuaton, chiníquën ana'intarin. Co natëtono'sahuëpitarë chachin ana'intarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A'na piyapinënso' patronëni sha'huitopirinhuë', co yonquirinhuë'. Noya nitotaponahuë', co natërinhuë'. Co ma'shanënpita noya tapatërinhuë' ni'ton, chini chiníquën ahuihuitarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A'naso nipirinhuë' co nitotërinhuë'. Co noyahuë' nipachina, co onpopinchin ahuihuitarinhuë'. Inapochachin canpitanta' na'con a'chintëranquëma' ni'ton, noya natëco'. Na'con nitotohuatama', noya noya natëcaso' ya'huërin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","“Tëhuënchachin, iyaro'sa', pën matohuachina, a'naroáchin huiquitërin. Inapochachin piyapi'sa' a'chintohuato, nisha nisha yonquiapi. Na'a piyapi'sa' no'huiarinaco. Caso' chiníquën parisita'huaso' ya'huërin. Ina yonquiato, sëtërahuë. A'naroáchin nipachin napochinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","‘Cristo o'mahuachin, ya'ipiya nohuantatona', noya ya'huapona',’ ¿topiramahuë' ti? Co ya'ipiya nohuantarinacohuë'. Pënënpato, nisha nisha yonquiapi. A'naquën nohuantarinaco. A'naquënso nipirinhuë', co nohuantarinacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ipora quëran huarë' a'na pëiquë ya'huëpisopita nisha nisha yonquiapi. Catoya'pi nohuantarinaco, caraya'piso nipirinhuë' co nohuantarinacohuë' ni'ton, nino'huiapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A'na pëiquë pa'pin nohuantarinco. Hui'ninso nipirinhuë' co nohuantarincohuë'. A'na pëiquënta' hui'nin nohuantarinco. Pa'pinso nipirinhuë' co nohuantarincohuë'. Sanapi'santa' nisha nisha yonquiapi. A'shin nimara co nohuantarincohuë'. Hua'huinso nipirinhuë' nohuantarinco. A'shatën nohuantarinco. Notainso nipirinhuë' co nohuantarincohuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ina quëran ya'ipi piyapi'sa' a'chintantaton, itapon: “No'tëquën, iyaro'sa', yonquico'. Pi'i ya'coninso parti tashirotohuachina: ‘O'nanapon,’ tënama'. Ina quëran o'nanin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sor parti quëran chiníquën ihuantohuachina, ‘Huënoca ya'huëapon,’ tënama'. Naporo' huënocatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Canpitaso' nonpintënquëma'. O'nan, sëhuën, inapita noya ninopiramahuë', ¿onpoatonta' ipora chachin naporahuësopita co yonquiramahuë'?” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Onpoatomata' canpitaora cancanëma quëran co no'tëquën yonquiramahuë'? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni'co'. Nihuitëranso marë' yaquëpahuachinënquën, a'naroáchin nanan anoyatëquë'. Co anoyatohuatanhuë', coisëquë quëpaarinënquën. Coisëquë quëpahuachinënquën, sontaroquë yo'coaninënquën ni'ton, tashinan pëiquë po'moarinënquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inaquë po'mohuachinënquën, ya'ipiya pahuërëtaquë huarë' pipiaran,” tënin Quisoso. (Inapochachin canpitanta' co noyahuë' nipatama', a'naroáchin nanan anoyatoco', Yosë ana'intochinquëma'.) ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Naporo' a'naquën huë'sahuatona', Quisoso sha'huitiipi: “Caririaro'sa' Yosë pëinënquë chinotatona', ma'sha tëparapirinahuë', Piratori sontaro'sa' a'parin tëpacaiso marë'. Inaquë chachin tëpapi,” itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","“A'napita caririaro'sa quëran na'con na'con oshahuanpi ni'ton, Yosë nohuanton, ¿tëpapi, topiramahuë' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Co inapita na'con na'con oshahuanpihuë'. Canpitanta' co noyahuë' yonquirama'. Co ina naniantohuatamahuë', ana'intarinquëma'. Chiminatoma', parisitomiatarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","5","Siroiquënta' a'na tori anotaton, shonca posa ya'pi tëparin: ‘Inapitanta' na'con na'con oshahuanpi,’ ¿topiramahuë' ti? Co naporinhuë', tënahuë caso'. Na'a piyapi'sa' Quirosarinquë inachachin oshahuanpi. Canpitanta' co noyahuë' yonquirama'. Co ina naniantohuatamahuë', chiminatoma', parisitomiatarama',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ina quëran iso pënënto nanan sha'huitërin: “A'na quëmapi iminënquë iquira naranta' sha'nin. Papotahuaton a'shinaponahuë', hua'qui' co nitërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ina quëran inpriatonën itërin: ‘Iso huayo napoonin. Nani a'shinaponahuë', cara pi'ipi co manta' nitërinhuë'. A'nëquë'. ¿Ma'marëta' topinan huanirin?’ itopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Ama sinioro ipora a'nëquësohuë'. A'na pi'ipira' tananpitëquë'. Iso pi'ipi noya pacarapiarahuë. Apono acotarahuë noya nitacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iso pi'ipi nitapon nimara. Co nitohuachinhuë', sha'huitoco a'nëchinquën,’ itërin inpriatonëni,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Chinoto tahuëri nanihuachina, niyontonpiso pëiquë pa'sahuaton, piyapi'sa' a'chintarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Inaquë a'na sanapi quënanconin, apia nininso'. Sopai nohuanton, nani shonca posa pi'ipi monconpirin. Co nanitërinhuë' no'tëpicaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Quisosori quënanahuaton, përarin. Huëcapaihuachina: —Nani imoya noyatëran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Së'huapihuachina, a'naroáchin no'tëquën huanirin. “¡Ma noyacha Yosëso' ni'ton, anoyatërinco paya!” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Niyontonpiso pëi' hua'anso nipirinhuë', no'huitërin. Chinoto tahuëri anoyatërin ni'ton, naporin. Napoaton piyapi'sa' itapon: —Saota tahuëri sacatacaso' ya'huërin. Naporo' huëco' anoyatinquëmaso marë'. Chinoto tahuëriso' co noyahuë' anoyatacaso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Quisosori natanahuaton, itapon: —Canpitaso' nonpintënquëma'. Co no'tëquën yonquiramahuë'. Ohuaca', mora, inapita pë'tahuahuatama', chinoto tahuërinta' i'quiritërama'. I'sha ya'huërinquë quëparahuatoma', o'shitërama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iso sanapiso nipirinhuë' Yosë piyapinën niponahuë', hua'qui' parisitërin. Nani shonca posa pi'ipi Satanasëri aparisitopirinhuë', ipora huarë' nicha'ërahuë. Chinoto tahuërinta' anoyatacaso' ya'huërin tënahuë. ¿Ma'ta' canpitaso' yonquirama'? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Natanahuatona', inimiconënpitaso' tapanpi. A'napitariso nipirinhuë', pa'yatopi: “¡Ma noyacha Quisoso nanitaparin paya!” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","“¿Ma pochinta' Yosë hua'anëntërinso'? topiramahuë'. A'na pënënto nanan sha'huitanta'inquëma' canpitanta' nitotacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostasaraya pochin ninin. Ya'pirin hua'huishin niponahuë', iminquë sha'patëra, panca ta'an ninin. Nani a'shinpachina, inairaro'sa' huëcatona', inaquë pëirin,” tënin. (Inapochachin ya'nan nipon, caraíchin piyapi Yosë imapirinahuë', a'na tahuëri hua'huayátërahuë imasapi huachi.) ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ina quëran itantarin: “¿Ma pochinta' Yosë hua'anëntërinso'? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pan ahuëpocatërinso pochin ninin anta'. A'na sanapi pan nipachina, cato shonca quiro pochin trico no'mo' manin. Masahuaton, pi'pian tëranta' pan ahuëpocatërinso' ayontohuachina, ya'ipiya së'cotërin, pan huëpocatërin huachi,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ina quëran nisha nisha ninanoquë pa'sahuaton, a'chintëra'piarin. Quirosarinquë huarë' pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A'chintohuachina, a'na quëmapiri itapon: —¿Onpo piyapita' cha'ëpona'? ¿Caraíchin nimara ti? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Yosë huëntonën pëi pochin ninin. Ya'coananënso' yamianasha. Na'a piyapi'saso' yaya'conpirinahuë', co noyahuë' cancantatona', co nanitopihuë' ya'conacaiso'. Canpitaso nipirinhuë' ipora chachin ya'conacamaso' nohuantoco'. Ama hua'quicosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A'na tahuëri hua'anëni ya'coananën oncotarin huachi. Naporo huarë' aipiran huanirahuatoma', yaya'conpiramahuë'. “I'soatocoi Sinioro,” tosapiramahuë', co nohuantarinhuë'. “Co nohuitëranquëmahuë'. Co canpitaso' piyapinëhuëpitanquëmahuë',” itarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Co'ta nohuitërancoi. Quëmaro'coi coshatërai, o'orai. Quiyataquë a'chinan,” tosapiramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Co' mini nohuitëranquëmahuë'. Co noyahuë' ninama' ni'ton, co piyapinëhuëpitanquëmahuë'. Paco huachi,” itahuatënquëma', a'paarinquëma'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Parisitopiquë pa'sahuatoma', na'nëarama', chiníquën parisitarama'. Apraan, Isaco, Cacopo, pënëntona'piro'sa', inapita Yosë hua'anëntërinquë ya'huërapi, ni'sarama'. Canpitaso nipirinhuë' co ya'conamahuë' ni'ton, sëtarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nisha nisha parti quëran huëcatona', Yosë ya'huërinquë ya'conapi. Inaquë noya coshatërëso pochin nóya ya'huërapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A'naquënso' ipora co piyapi'sari noya ni'pirinahuë', a'na tahuëri Yosëri nóya ni'sarin. A'naquënso nipirinhuë' ipora piyapi'sari noya ni'pirinahuë', a'na tahuëri co Yosëri noya ni'sarinhuë', itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naporo' a'naquën parisioro'sa' Quisosoquë huë'pi. —A'naroáchin ta'aquë'. Irotisë yatëparinquën, itiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","—Inca. Co yapa'nahuë'. Irotisëso' pa'pi nonpintë'. Paaton, sha'huitonquë'. Nani Yosë sha'huitërinco ma'sha nica'huaso'. Iporaso' ina natëto, sopairo'sa' a'parahuë. Na'a cania'piro'sa' anoyatarahuë. Cara tahuëríchin pochin pahuanarin tiquia'huaso'. Ina sha'huitonquë' nitochin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Inaso napotopirahuë', ipora tahuëri chachin pipito tashira aquëtëran Quirosarinquë nincana'huaso' ya'huërin. Iráca quëran huarë' na'a piyapi'sa' inaquë pënëntopirinahuë', tëpapi. Inaquë canta', tëpainacoso ya'huërin, tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ina quëran itantarin: “¡Ya'ipi Quirosarinquë ya'huëramasopita yonquiatënquëma', chiníquën sëtërahuë! Na'a pënëntona'piro'sa' Yosë a'patërinquëma' pënëinënquëmaso marë'. A'papirinhuë', tëparama'. A'naquën na'piquë të'yaratoma', tëparama'. Ya'ipinquëma' nosoroatënquëma', na'aro' yacatahuapiranquëmahuë', co ca tëranta' nohuantëramacohuë'. Atari hua'huin to'cohuëtërinso pochin yapa'poyapiranquëmahuë', co nohuantëramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Napoaton Tata Yosë patarinquëma'. Co huachi catahuararinquëmahuë'. Co huachi quënanaramacohuë'. O'manta'huaso' tahuëri huarë' quënantaramaco. Naporo': ‘¡Ma noyanquëncha quëmaso paya! Sinioro chachin a'paimarinquën,’ itaramaco,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A'na hua'ani Quisoso amatërin coshatapacaso marë'. Parisio quëmapi inaso'. Amatohuachina, inaquë pa'nin. Chinoto tahuëri ni'ton, a'napitarinta' ni'sapi sha'huirapicaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naporo' a'na cania'pi Quisosoquë huë'nin, panca pomatërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Cotio maistro'sa', parisioro'sa', inapita notëërahuaton, Quisosori itërin: —¿Noya chinoto tahuëri cania'pi anoyatacaso' ti? ¿Ma'ta' tënama' canpita? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Natanahuatona', ta'tápi. Co manta' topihuë'. Co a'panitohuachinaraihuë', cania'pi së'huarahuaton, a'naroáchin anoyatërin. —Noya paquë huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ina quëran piyapi'sa' pënëantarin. —¡Hui'nama' posoquë pa'itohuachina, chinoto tahuëri nipirinhuë', a'naroáchin ocoirama'! Mora tëranta' pa'itohuachina, ocoirama'. ¿Co ocoiramahuë' nica? itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Parisioro'saso nipirinhuë' tapanatona', co nanitopihuë' a'panitacaiso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yacoshatohuachinara, na'a piyapi'sa' hua'an pirayan yahuënsëpi. “Hua'an pirayan huënsëhuato, chiníquën nanantona'pi pochin ni'sarinaco,” ta'tona', inaquë huënsëconpi. Ina ni'sahuaton, Quisosori itërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Natanco iyaro'sa' pi'pian pënëinquëma'. Quëmapi yasa'apachina, nipayarinsopita amatërin coshatapacaiso marë'. Inaquë amatohuachinquën, ama hua'ano'sa pirayan huënsëquësohuë'. Tapona' a'na quëmapi chini chiníquën nanantërinso' huë'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Huë'pachin, hua'an itarinquën: “Po'shaquë', iso quëmapi huënsë'in. Pasëquë tëranta' huënsëconquë',” itohuachinquën, tapanaran. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Napoaton amatohuachinquën, co'inquë huënsëquë'. Hua'an huë'pachin, noya nontarinquën. “Huëquë' iyasha, isëquë noya huënsëiquë',” itohuachinquën, ya'ipi piyapi'sa' noya ni'sarinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Inapochachin “Caso' noya noyaco,” topatama', Yosë atapanarinquëma'. Nipirinhuë', sano piyapi nipatama', Yosë noya noya acoarinquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ina quëran pëi' hua'anën pënënaton, itantarin: —Ca'painënquënso marë' piyapi amatohuatan, ama quëmopinënpita, amiconënpita, inapitaráchin amatëquësohuë'. Ma'huano'sa' amatohuatan, inapitanta' amataantahuachinënquën, i'huërëtarinënquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sa'ahuaro'sa', apiaro'sa', sonpacharo'sa', somaraya nininsopita, inapitanta' nosoroaton, amatëquë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ina quëran noya cancantaran. Inapitaso' co nanitopihuë' amatanta'inënquënso'. Co i'huërëtopirinënquënhuë', Yosëso' i'huërëtarinquën. Noya ninan ni'ton, ayaro' tahuëri ananpitaantahuachinquën, acanaarinquën huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Inaquë coshatasoi', a'naso' natanahuaton, Quisoso itapon: —Yosë chachin hua'anëntohuachinpoa', nóya coshatarihua'. Noya noya cancantarihua', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Napotohuachina, pënënto nanan sha'huitërin. —A'na quëmapiri na'a piyapi'sa' amatërin ca'pacaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tahuëri nanihuachina, inpriatonën a'parin sha'huitantacaso marë'. “Huëco huachi. Nani cosharo' taparin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nani amatopirinhuë', co huachi nohuantopihuë'. “Co'chi nanitëraihuë paya,” toconpi a'naya a'naya. “No'pa' pa'anahuëso' nicapo pa'sarahuë. Napoaton co nanitërahuë',” tënin a'na'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Shonca toro pa'anahuë asacata'huaso marë'. Inapita tënipo pa'sarahuë. Napoaton co ipora nanitërahuë',” tënin a'nanta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“I'huara sa'arahuë. Napoaton co canta' nanitërahuë',” tënin a'nanta'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Napotohuachinara, inpriatoso ayanahuaton hua'anën sha'huitiirin. “Co huachi nohuantopihuë',” itërin. Natanahuaton, no'huitërin. “Manóton paantaquë'. Cachiquë tëranta' paaton, piyapi maconquë'. Sa'ahuaro'sa', apiaro'sa', somaraya nininsopita, sonpacharo'sa' inapita maconquë',” itërin. Itohuachina, pa'sahuaton, macontarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Huënantarahuaton, sha'huitiantarin. “Nani maconpirahuë'. Ipora huanta' pahuanarin piyapi'sa' nanicaso',” tënin inpriatonën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ninano quëran pipirahuaton, macoantaquë'. Nisha nisha ira pa'taton, sha'huitonquë' huë'ina'. Imino'saquë huarë' paaton, maconquë'. Na'a piyapi'sa' nohuantërahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya'nan amatërahuësopitaso', co huachi ca'painacoso' nohuantërahuë' ni'ton, inapoco',” itërin hua'ani, tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ina quëran Quisoso paantarin. Na'a piyapi'sari imasapirinahuë', tahuërëtahuaton, itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yaimapatamaco, ca na'con na'con nosoroco. Tatama', mamama', inapita co onpopinchin nosorocaso' ya'huërinhuë'. Sa'ama', hui'nama', iyaparima', oshiparima', inapitanta' co onpopinchin nosorocaso' ya'huërinhuë'. Canpitaora nohuantëramasonta' naniantatoma', casáchin imaco huachi. Co na'con na'con nosorohuatamacohuë', co tëhuënchachin imaramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Imapatamaco, a'napita aparisitarinënquëma'. Yatëpapirinënquëmaonta', imamiatoco. Corosëquë chiníquën parisitërë'. Inapochachin canpitanta' imapatamaco, aparisitarinënquëma'. Co ahuantohuatamahuë', co tëhuënchachin imaramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ni'co' iyaro'sa'. A'na quëmapi panca tori yanipachin, co a'naroáchin nininhuë'. Ya'ipi pa'tërinso'ton yonquirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ina quëran coriquinën nanihuachina, pëiarin huachi. Co coriquinën nanihuachinhuë', co pëirinhuë'. Patomaíchin a'canin naporini, a'napitari tëhuaitonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ni'co'. Panca yapëipirinhuë', co nanitërinhuë' a'canacaso',’ ichitonahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Isonta' yonquico'. A'na copirno ya'huërin, shonca huaranca sontaro'sa' camairinso'. Inimiconënso nipirinhuë', cato shonca huaranca sontaro'sa' camairin. Ina napo' huë'pachinara, co a'naroáchin ahuëapon pa'sarinhuë': ‘Sacai' minsëcaso',’ ta'ton, yonquirárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Co nanitochináchinhuë' nipachina, comisionën a'parin nanan anoyatacaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Inapochachin pënënanquëma'. Sacai' imamancoso', tënahuë. Napoaton noya yonquiatoma', imaco. Casáchin yonquihuatamaco, tëhuënchachin noya imasaramaco,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Ina quëran taantarin: “Yamora noya acashicaso' niponahuë', chiminpachinaso co huachi cashirinhuë' ni'ton, co huachi ma'marë tëranta noyatërinhuë'. Topinan të'yatërë'. Huëratëhuanpatama', noya natanatomaco, yonquico',” itërin Quisosori. (Canpitanta' co noya cancantohuatamahuë', co Yosë nohuantarinquëmahuë' tapon naporin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nisha nisha piyapi'sa' huë'pi Quisoso natanacaiso marë'. Copirno marë' coriqui ma'patona'piro'sa', oshahuano'sa' itopiso', inapitanta' huë'pi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ina ni'sahuatona', parisioro'sa', cotio maistro'sa', inapitari no'huipi. —¿Onpoatonta' Quisoso oshahuano'sa' pa'yatërin? Inapitarë' coshatarin, co napocasohuë' nipirinhuë', toconpi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ina natanahuaton, Quisosori iso pënënto nanan sha'huitërin ayonquicaiso marë': ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“A'na quëmapi pasa ohuicaro'sa' pë'tahuaton, ya'ipiya nosororin. A'naya tëranta' chihuëhuachina, yonípon pa'sarin. A'napitaso' pastoquëranchin patahuaton, hua'qui' yonisarin. Quënanaquë huarë' yonisárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Quënanahuaton, pa'yatërin. Pitënahuaton, quëmantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pëinënquë canquiantahuachina, nipayarinsopita, ya'cariya ya'huëpisopita, inapita sha'huitërin. ‘Ohuicanëhuë chihuëpirinhuë', quënanahuë. Ina marë' nóya cancantahua',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Inapochachin Yosë ni'ninpoa'. Noya piyapi ya'huëhuachin, Yosëri noya ni'sarin. Nipirinhuë', oshahuano'santa' nosororin. A'naya tëranta' co noyahuë' yonquirinso' naniantohuachin, Yosë ya'huërinquënta' capa cancantomiatapi,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ina quëran iso pënënto nanan sha'huitantarin: “A'na sanapi shonca coriqui prata quëran nininso' ya'huëtopirinhuë', a'nara' ayatërin. Nanparin i'chinpitahuaton, noyá huitëtërin. Quënanaquë huarë' yonisárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Quënanahuaton, nipayarinsopita, ya'cariya ya'huëpisopita, inapita sha'huitërin. ‘Coriquinëhuë ayatopirahuë', quënanahuë. Ina marë' noya cancantahua',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Inapochachin a'na piyapi tëranta' co noyahuë' yonquirinsopita naniantohuachin, anquëniro'santa' noya cancantapi,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ina quëran Quisosori itaantarin: “A'na quëmapi cato' hui'ninpita ya'huëtopirinhuë', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","hua'hua nininsoari pa'pin itërin: ‘A'na tahuëri ya'ipi ma'shanënpita iyahuëro'co patomatarancoi. Caso nipirinhuë' apira nohuantërahuë. Ipora tata quëtochanco, topirahuë',’ itërin. Itohuachina, patoma ma'shanënpita quëtërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cara tahuëri quëran pochin hua'hua nininso' yapipirin. Ya'ipi ma'shanënpita pa'anahuaton, coriqui canarinso' masahuaton, aquë pa'nin. Inaquë no'pirárin, nansarárin, monshihuanárin. Na'a coriqui quëparinso' i'quirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nani ya'ipi i'quihuachina, inaquëso' tanarotopi ni'ton, co manta' capacaso' ya'huërinhuë'. Inanta' tanarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Napoaton a'na patronquë pa'nin. ‘Canta' sacachi, topirahuë',’ itërin. ‘Noyahua'. Sacatëquë' nipachin,’ itahuaton, pastoquë a'parin coshinënpita a'paicaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Inaquë paaton, coshiro'sa' a'cararin. Tanaton, coshi ca'ninso' tëranta' nayapirinhuë', co incari quëtërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ina quëran yonquirin. ‘¡Ma'huántacha ninahuë paya! Tata piyapinënpitaso' noya coshatapi. Caso nipirinhuë' tana yatëparinco ta'a. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Paato, tatahuë nonchi: “Co noyahuë' tata ninahuë. Nonpintëranquën. Co Yosë natëtohuë', oshahuanahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Co noyahuë' ninahuëso marë' co huachi hui'nan pochin cancantancoso' ya'huërinhuë'. Piyapinën pochin tëranta' ni'co,” ichi,’ tënin yonquinënquë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ina quëran pa'pin ya'huërin'pa' paantarin. Ya'caritëriahuaso', aquë quëran pa'pini quënanin. Quënanahuaton, na'con nosoroaton, ta'aparin. Iporahuaton, apinorin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Co noyahuë' ninahuë, tata. Nonpintëranquën. Co Yosë natëtohuë', oshahuanahuë. Co noyahuë' ninahuëso marë' co huachi hui'nan pochin cancantancoso' ya'huërinhuë',’ itërin pa'pin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Napotopirinhuë', pa'piniso' na'con nosororin. Piyapinënpita camairin. ‘Manóton paatoma', noyápiachin nininso' maconahuatoma', a'motoco'. Po'moitëranta' noyápiachin nininso' po'motoco'. Sapatënta' matonquë' po'moin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ina quëran toroa'hua amoshin nininso' ma'toma', tëpaco' ca'ahua'. Capa cancantatëhua', pita niahua'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iso hui'nahuë chiminin pochin niponahuë', iporaso' ya'noantarin. Ayatë pochin nipirinhuë', iporaso' niantarahuë,’ itërin. Ina quëran pita nisapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Paninanso nipirinhuë', iminquë sacatërin quëran huëntararin. Pëiquë ya'caritëriahuaso', mosica pi'nirapiso natanin. Nansatona', capa cancantapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Natanahuaton, piyapinën përarin: ‘¿Onpoatonta' pita nisapi?’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Co'ta iya'hua huënantarin. Noya canquintarin ni'ton, tatari pa'yatërin. Toroa'hua amoshin nininso' atëpatërin capacaso marë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ina natanahuaton, no'huitërin. No'huitaton, co yaya'coninhuë'. Pa'pini pipirahuaton, itërin: ‘Huëquë' conpa capa cancantahua',’ itopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","‘Inca tata. Na'a pi'ipi quëma marë' chiníquën sacatërahuë. Sha'huitohuatancora, ya'ipiya natëranquën. Napoaponahuë', co caso' chipo tëranta' quëtërancohuë' amiconëhuëpita amatahuato capa cancanta'huaiso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iso hui'nanso nipirinhuë', aquë paaton no'piárin. Monshihuanárin. Coriquinën quëtopiranhuë', ya'ipi i'quirin. Ina quëran huënantahuachina, quëmari nosoroaton, pa'yatëran. Toroa'hua amoshin nininso' atëpatëran coshatacaiso marë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Napotohuachina, pa'pini itërin: ‘Nosororanquën mini conpa. Quëmaso' co ya'huincaranhuë'. Ya'ipi ma'shanëhuëpita quëchinquën. Ya'ipiya quëmaquën nisarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iya'huaso nipirinhuë', nani huënantarin. Chimininso pochin niponahuë', ya'noantarin. Ayatërëso pochin nitopirëhuahuë', niantarëhua'. Ina marë' noya cancantacaso' ya'huërin,’ itërin pa'pini,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ina quëran ca'tano'sanënpita a'chintantaton, itapon: “A'na ma'huan ya'huërin. Inpriatonën chiníquën nanan quëtërin piyapinënpita camaicaso marë'. Inari asacatërin. Chiníquën nanantaton, nihuipiso' ninshitërin. Inaso nipirinhuë', nonpintaton, inaora marë' coriqui masarin ni'ton, sha'huirapipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma'huanso' natantahuaton, amatërin. ‘Quëmaso' nonpintaranco natantërahuë. Coriqui quëtëranquënso' quëmaora marë' manan ni'quëhuarë', ocoiaranquën. Ya'ipi nihuirinacoso' ninshitoco nitochi,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Inpriatonënso' pipirahuaton, yonquirarin. ‘¿Ma'cha onpo'i nicaya? Hua'anëhuë ocoiarinco. Co nanitërahuë' chiníquën sacata'huaso'. Naporahuaton, tapanato, co nohuantërahuë' coriqui topinan ma'pata'huaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na'a quëmapi'sa' hua'anëhuë nihuipi. Iporaso' inapita catahuarahuë. Ina quëran hua'anëhuë ocoihuachinco, inahuanta' catahuarinaco nanpica'huaso marë',’ tënin yonquiaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naporahuaton, co'huara hua'ani ocoiyatërasohuë', nihuitopisopita amatërin. A'naya a'naya huë'pi. A'naso' huë'pachina, natanin. ‘¿Onpota' hua'an nihuiran?’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Pasa rata toma' ma'parahuë ni'ton, ina nápo' nihuirahuë,’ itohuachina, ‘Inta nipachin, nihuitëranso quirica masahuaton, a'natërápo shoncaíchin ninshitantaquë',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ina quëran a'nanta' huë'nin. Huë'pachina, ‘¿Onpota' quëmanta' nihuitëran?’ itërin. ‘Trico ma'parahuë ni'ton, pasa costaro marë' nihuirahuë,’ tënin. ‘Inta nipachin, Posa shoncaíchin ninshitantaquë',’ itërin. Inapotëra'piaton, na'a amiconënpita catahuarin ama na'con pahuërëtacaiso marëhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hua'ani natantahuaton, amataantarin. ‘Naquëranchin nonpintantaranco. Nipirinhuë', “ma noyacha yonquiran paya,” tënahuë,’ itërin hua'anëni. Ni'co' iyaro'sa'. Na'a piyapi'sa' co noyahuë' nipisopita noya yonquipi inaora canacaiso marë'. A'naquëmaso nipirinhuë', imapiramacohuë', co onpopinchin yonquiramahuë' noya nicacamaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Coriqui ya'huëtohuachinquëma', ama canpitaoráchin i'quicosohuë'. A'napita pahuantohuachina', quëtoco'. Inapohuatama', Yosë'pa' noya ni'sarinquëma'. Chiminpatama', Yosë inápaquë quëpantarinquëma'. Coriquinëma' patopiramahuë', inatohua' noya noya ya'huëcontarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ni'co' iyaro'sa'. Hua'anëma' sha'huitohuachinquëma', natëcamaso' ya'huërin. Pi'pian tëranta' sha'huitopirinquëmahuë', natëhuatama', noya ni'sarinquëma'. Chini chiníquën nanan quëtarinquëma'. Co'so' natëhuatamahuë', co chiníquën nanan quëtarinquëmahuë'. ‘Nonpintarinco,’ ta'ton, co huachi natëarinquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ya'ipi coriquinëma' canpitaora marë' i'quihuatama', co insonta' inápaquë acanarinquëmahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iporaso' Yosë nohuanton, ma'sha, coriqui, inapita ya'huëtarinquëma'. A'naninquëmaso pochin quëtërinquëma'. Topinan quëran i'quihuatama', co manta' Yosë'pa' canamiataramahuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Cato' patron camaihuachinquëma', co nanitëramahuë' cato chachin natëcamaso'. A'naso' nohuantatoma', noya natëarama'. A'naso nipirinhuë' co onpopinchin nohuantatomahuë' co natëaramahuë'. Inapochachin canacamasoáchin yonquihuatama', co nanitaramahuë' Yosë natëcamaso'. Coriquiráchin cancantohuatama', co Yosë natëaramahuë',” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisioro'sa' coriquiráchin cancantopi. Napoaton Quisoso a'chininso' natanahuatona', tëhuapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tëhuapirinahuë', Quisosori itërin: “Canpitaso' Yosë imaramaso pochin nipomarahuë', co tëhuënchachin imaramahuë'. Nonpinama'. Yonquiramaso chachin Yosë nitotërin. Piyapi'sa' noya ni'pirinënquëmahuë'. Cancanëma quëranso yanonpinama' ni'ton, Yosë co pi'pian tëranta' noya ni'sarinquëmahuë',” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ina quëran tantarin: “Iráca Moisësë, pënëntona'piro'sa', inapita pënëntopi nani ma'sha natëcaso'. Ina quëran Coansha Paotista huë'pachina, noya nanan sha'huirin Yosë hua'anëntërinquë ya'conacaiso marë'. Yaya'conpisopitaso' chiníquën cancantatona', ya'conapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Quiricanën quëran Yosë no'tëquën pënëninpoa'. Isoro'pa', pi'iro'të', inapita ta'huantapirinahuë', ya'ipi Yosë nanamënso' ya'huëmiatápon. Co a'na hui'sharinso tëranta' topinan quëran ninshitopihuë' ni'ton, ya'ipi naniarin,” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ina quëran Quisosori pënëantarin: “Co sa'ama' të'yatamaso' ya'huërinhuë'. Noya nichinpitacaso' ya'huërin. Napoaton sa'ama' të'yatatoma', a'na sanapi maantahuatama', oshahuanarama'. Monshihuaninso pochin Yosë ni'sarinquëma'. Insosona ina sanapi so'ini të'yatërinso chachin maantahuachina, inanta' monshihuaninso pochin Yosëri ni'sarin,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ina quëran itaantapon: “A'na ma'huan ya'huërin. Nani ma'sha ya'huëtërin. Morin pa'ton nininso' a'morin. Noyápiachin a'moton, nani tahuëri pita pochin nicaton, nóya coshatërin. Co manta' pahuantërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","A'na quëmapinta' inaquë ya'huërin, sa'ahua nininso'. Nasaro itopi. Apia ni'ton, co nanitërinhuë' sacatacaso'. Ma'sha topinan ma'pataton, nanpirin. Ma'huan pëinën aipiran acopi. Ya'coanaquë huënsëarin. Tanaton, ma'huan pë'sotërinso tëranta' nayapirinhuë', co manta' quëtopihuë'. Ta'taráchin niconin ni'ton, ni'niraro'sari huëcatona', irotiipi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Napoin quëran Nasaro chiminin huachi. Chiminpachina, Yosë'pa' anquëniro'sari quëparin. Apraan pantarinquë chachin pantarin. Ina quëran ma'huaonta' chimininpachina, pa'pitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Parisitopiquë paaton, parisitárin. Në'përahuaton, aquë quëran Nasaro quënanin. Tata Apraanë' ya'huëarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Napoaton chiníquën përarin: ‘¡Tata Apraan, nosoroco canta'! Pënquë parisitárahuë. Nasaro a'patimaco i'sha pi'pian tëranta' api'nichinco,’ itopirinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Co'chi nanitërahuë paya. Ni'quë'. Quëmaso' nanpipon, nani ma'sha ya'huëtopirinquënhuë', inasáchin yonquiran ni'ton, iporaso' parisitáran. Nasaroso nipirinhuë' nanpipon, parisitápirinhuë', iporaso' noya ya'huarin huachi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naporahuaton, Yosë'pa' pa'patëra, co onporonta' pipirëhuë'. Inapochachin parisitopiquënta' pa'patëra, co onporonta' Yosë'pa' pa'nëhuë'. Panca tahuan ya'copitërinso pochin ni'ton, co nanitërëhuë' pëntonacaso',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Napotopirinhuë', itantarin: ‘A'natërápo iyahuëpita ipora ya'huërapi. Nasaro a'paquë' tatahuë pëinënquë iyahuëpita pënënacaso marë'. Caso' parisitápato, co nohuantërahuë' isëquë huëcacaiso',’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Napotohuachina, Apraani itërin: ‘Co'ta Yosë quiricanën ya'huëtopi. Inaquë Moisësë, pënëntona'piro'sa', inapita ninshitopi nontatona' nitotacaiso marë'. Inapita natëina',’ itërin Apraani. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Nani nontaponaraihuë', co natëpihuë'. Nipirinhuë', chimininso' nanpiantahuaton, pënënconpachin, natëpona' nimara. Co noyahuë' yonquipisopita naniantatona', Yosë tahuërëtantapona' nimara, topirahuë',’ tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Co Yosë quiricanën natëhuachinahuë', chimininsonta' nanpiantapirinhuë', co onporonta' natëapihuë',’ itërin Apraani,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ina quëran ca'tano'sanënpita pënëantarin. “Nisha nisha ma'sha ya'huërin anishacancantiinpoaso'. Nipirinhuë', anishacancantona'piso' pa'pi co noyahuë' ni'ton, ¡ma'huantacha nisarin paya! Ina marë' Yosëri chiníquën ana'intarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Co'huara hua'huaro'sa tëranta' anishacancanchátërasohuë', marëquë chimiitërin naporini, noya noya niitonhuë'. Pancara'piquë a'sonconotahuatona', të'yaitopi naporini, co aquëtë' oshahuaintonhuë'. A'naquënta' imasapirinacohuë', co chiníquën cancanchatërapihuë'. Hua'huaro'sa' pochin cancantopi. Inapita anishacancantohuachina', Yosëri ana'intarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Napoaton, ni'cona a'napita anishacancantotama'. A'na piyapi ma'sha onpotohuachinquëma', pënënco'. Naporinso marë' sëtohuachina, nanan anoyatoco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A'na tahuërimarëáchin canchisëro' napotopirinquëmahuë', canchisëro chachin: ‘Co noyahuë' ninahuë ni'ton, sëtërahuë,’ itohuachinquëma', nanan anoyataantaco'. Co onporonta' no'huicaso' ya'huërinhuë',” tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ina quëran ca'tano'sanënpitari itopi: —Catahuacoi Sinioro, Yosë noya noya natë'i, itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Mostasa ya'pirin hua'huishin ninin. Ina pochin pi'pian tëranta' Yosë natëtoma', nontohuatama', noya catahuarinquëma'. “Yosë nohuanton, iso nara no'pa quëran pipirahuaton, marëquë pa'in,” tënama' naporini, pa'itonhuë'. “Yosë no'tëquën nontërinco,” topatama', sacai' nininso' nanitaparama', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ina quëran itantarin: “Patron ya'huëhuachina, piyapinën camairin. Camaihuachina, iminënquë sacatërin. Pë'tahuanënpitanta' a'pairin. Nani sacatohuachina, imin quëran huënantahuachina, patroni a'naroáchin a'carin, ¿topiramahuë' ti? ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Co naporinhuë'. Patron'ton yacoshatërin. Napoaton piyapinën sha'huitërin. ‘Cosharo' niquë'. Ina quëran nitaparahuaton, o'huintoco ca'i. Nani coshatohuato, o'shitoco,’ itërin. Nani coshatohuachina, naporo huarë' piyapinënso' coshatërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Piyapinën camairin ni'ton, natërin. ‘Ma noyanquën ni'ton, natëranco. Ina marë' “Yosparinquën,” ’ co itërinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Canpitanta' iyaro'sa', Yosë sha'huitohuachinquëma', natëco'. Nani natëhuatama': ‘Topinan piyapinënpoa' ni'tëhua', natërëhua',’ nitoco'. Ya'ipiya natëcamaso' ya'huërin,” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ina quëran Cariria parti na'huëtahuaton, Quirosarinquë pa'sarin. Samaria yonsan ya'cariya pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Inaquë paaton, a'na ninanoquë canconin. Canconpachina, shonca quëmapi'sa' chana caniori maninsopita quënanconin. Inapitaso' aquëmiáchin huanirahuatona', ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","chiníquën nontopi: —¡Quiyanta' Maistro nosoroatoncoi anoyatocoi topiraihuë'! itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Napotohuachinara, ni'sahuaton, itapon: —Paatoma' corto hua'an noyatëramaso a'notonco', itërin. Napotohuachina, pa'pi. Paasoi', a'nanaya canio inquipi. Noyatopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A'nara': “Nani noyatërahuë,” ta'ton, ayanquintarin. Iratapon pochin “¡Ma noyacha Yosëso' ni'ton, anoyatërinco paya!” tosarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Quisosoquë huënantahuaton, nantëntaquëchin isonquirin. Isonquirahuaton, “Yosparinquën, Sinioro,” itërin. Samaria piyapi inaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","—Shonca ya'pi anoyatopirahuë', a'naíchin huënantahuaton, “Yosparinquën,” itërinco. Inaso' nisha piyapi niponahuë', Yosë yonquirin. A'napitaso nipirinhuë' co “Yosparinquën,” itërinacohuë', tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ina quëran itantarin: —Huanirahuaton iyasha, noya paquë. Yosë natëran ni'ton, noyatomiatëran huachi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ina quëran Parisioro'sari huëcapairahuatona', itapona': —¿Onporota' Yosë isoro'paquë hua'anëntarin? itopi. —Yosë hua'anëntohuachin iyaro'sa', co a'ninquëchin ya'noarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Isëquë ya'huarin,” co taponahuë'. “Pasëquë ya'huarin,” co taponahuë'. Yosë hua'anëntohuachinquëma', ya'coancantarinquëma', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ina quëran ca'tano'sanënpita itantarin: —A'na tahuëri iyaro'sa', panantarahuë. Naporo' nohuantaramaco. Yosë quëran quëmapico ni'to, o'mantararahuë. “Manóton o'manta'in,” tosapiramahuë', co naporo' quënanaramacohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A'naquën yanonpintarinënquëma'. “Nani o'mantarin. Pasëquë ya'huarin,” itarinënquëma' a'naquën. “Patoro'pa' ya'huarin, quiyaso' nitotërai,” itarinënquëma' a'naquëonta'. Ina pochin nontohuachinënquëma', ama natëcosohuë'. Ama inapita imacosohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","A'nanaya o'mantararahuë. O'cori' huënsha' topachina, ya'ipi parti a'pintërin. Inapochachin a'na tahuëri ya'ipi piyapi'sa' ni'sarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iporaso nipirinhuë' chiníquën parisita'huaso' ya'huërin. Na'a piyapi'sa' co nohuantarinacohuë'. No'huiarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Iráca Noi pënëntopirinhuë', co natëpihuë'. Co natëtonahuë', topinan ya'huëcaisoráchin cancantopi. Coshatapi, o'osapi, sa'asapi, hui'ninpitanta' aso'yapi. Napoatona', co manta' Yosë yonquipihuë'. Noiso nipirinhuë', Yosë natëton panca nancha ninin. Nani tinihuachina, inaquë ya'conin. A'napitaso' co yonquipirinahuë', a'nanaya panca pacon pa'sarin huachi. Naporo' ya'ipiya chimiitopi. Inapochachin piyapi'sa' topinan ya'huasoi', a'nanaya o'mantararahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Notonta' iráca Sotomaquë ya'huëpirinhuë'. Inaquë a'napitaso' topinan ya'huatona', coshatápi, o'osápi, nipa'antápi, ma'sha sha'sapi, pëiapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Napoápirinahuë', Noto pipihuachina, naporo tahuëri chachin Yosë nohuanton, inápa quëran pën a'paimarin. A'nanaya ta'huantopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Inapochachin canta' a'na tahuëri Yosë quëran quëmapico ni'to, ya'noantarahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ina tahuëri nanihuachin, co ma'shanëmapita yonquicaso' ya'huaponhuë'. Pëinëma aipi ya'huëhuatama', ama ma'sha macacaso marë tëranta' ya'concosohuë'. A'naroáchin ta'aco'. Iminquë ya'huëhuatama', ama pëinëmaquë paantacosohuë'. Topinan paco'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Iráca Noto sa'in ma'shanënpita yonquiaton, co a'naroáchin ta'arinhuë'. Napoaton co cha'ërinhuë'. Ina yonquico'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Noya nanpicamasoáchin yonquihuatama', topinan quëran nanpiarama'. Chiminpatama', parisitomiatarama'. Nipirinhuë', casáchin yonquihuatamaco, tëpapirinënquëmaonta', noya noya nanpimiatontarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","O'mantahuato, naporo' tashi' cato' piyapi ina pë'saraquëáchin huë'ësapirinahuë', a'nara' imarinco ni'ton, anquëniri inápaquë quëpantararin. A'naso nipirinhuë' patarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cato sanapi shi'shi' pë'sanapirinhuë', a'nara' quëpantararin. A'naso nipirinhuë' patarin.  ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cato quëmapi ina iminquëáchin sacatapirinahuë', a'nara' quëpantararin, a'nara' patarin,” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—¿Insëquëta' Sinioro napoapi? itopi. —Ma'sharo'sa' chiminpachina, tamëro'sari huëcapaipi, itërin. (O'mantahuachin, ya'ipiya nitotapi, tapon naporin.) ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","“Chiníquën cancantatë', apira apira Yosë nontacaso' ya'huërin,” ta'ton, pënënto nanan sha'huitantarin ama amitona' a'pocaiso marëhuë'. A'chintaton, itapon: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“A'na ninanoquë a'na coisë ya'huërin. Co manta' Yosë të'huatërinhuë'. Piyapi'santa' co nosororinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ina ninanoquë chachin a'na quëyoron ya'huëpirinhuë', inimiconëni na'con ihuarin. Napoaton coisëquë pa'nin. ‘Paso' quëmapi ihuarinco. Sha'huitëquë' quëtanta'inco. Ana'intëquë',’ itopirinhuë', co nohuantërinhuë' catahuacaso'. Nani tahuëri paantahuaton, inachachin inachachin itantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hua'qui' coisëri co natëpirinhuë', napoin quëran ami ami natanin. ‘Co' mini Yosë të'huatërahuë'. Piyapi'santa' co nosororahuë. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Iso quëyoronso nipirinhuë' apininco. Apira apira huëcapaihuachincora, pinatanahuë. Co huachi ahuantërahuë'. Napoaton inimiconën ana'intarahuë,’ tënin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ni'co'. Coisë co noyahuë' niponahuë', napoin quëran quëyoron catahuarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¡Yosëso nipirinhuë' nóya ni'ton, huayoninsopita na'con catahuarin! A'napitari aparisitohuachina', Yosëri no'tëquën ana'intarin. Tahuërirë chachin, tashirë chachin ina nontopi ni'ton, catahuaarin. Co naniantarinhuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tahuëri nanihuachin, a'naroáchin ana'intarin. Napoaponahuë' o'mantahuato, ¿na'a ya'pita'ma' natëarinaco quënaimapo to?” itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A'naquën piyapi'sa' ya'huëpirinahuë'. “Quiyasáchin no'tëquën Yosë natërai. A'napitaso' co quiya pochin natëpihuë',” toconpi. Napopirinahuë', inapita pënënacaso marë' Quisosori itërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Cato' quëmapi Yosë chinotopiso pëiquë Yosë nontacaso marë' pa'pi. A'naso' parisio. A'nanta' coriqui copirno marë' ma'patërinso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisioso' huanirahuaton, sacaronquë Yosë nontërin: ‘Tata Yosë, yanontëranquën. Caso' noyaco. Ina marë' noya ni'nanco ni'ton: “Yosparinquën,” itëranquën. Co a'napita pochincohuë'. Co ihuatërahuë'. Co nonpinahuë'. Co monshihuanahuë'. Paso' quëmapi co noyahuë'. Caso nipirinhuë' co ina pochincohuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nani simana catoro' ayonarahuë. Ya'ipi canarahuë quëran, diesmo quëma marë' acorahuë,’ itërin Yosë nontaton. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A'naso nipirinhuë' co ya'caritërinhuë'. Tapanaton, monshoárin. Oshanën marë' sëtërin. ‘Tata Yosë, caso' oshahuanco. Nosoroatonco, oshanëhuë inquitoco,’ itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ina oshanën inquitaton, Yosëri noya ni'nin. Parisioso nipirinhuë', co noyahuë' ni'nin. A'napita nocanpatama', a'na tahuëri Yosë atapanarinquëma'. Nipirinhuë': ‘Caora co nanitërahuë' noya nica'huaso'. Catahuaco Sinioro,’ topatama', noya acoarinquëma',” tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ina quëran hua'huaro'sa' quëpi Quisosori së'huamotocaso marë'. Së'huamotorahuaton, inapita marë' Yosë nontërin. Hua'huaro'sa' quëpisopita ca'tano'sanënpitari yaa'papirinahuë'. —Ama napotocosohuë'. Quisoso apinama', itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Quisosoriso nipirinhuë' itërin: —Tananpitoco' hua'huaro'santa' huë'ina'. Ama a'pacosohuë'. Hua'huaro'sa pochin cancantohuatama', Yosë hua'anëntërinquë ya'conarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tëhuënchachin itëranquëma'. Hua'huaro'sa' a'naroáchin yaimarinaco. Co'so' inapita pochin cancantohuatamahuë', co Yosë hua'anëntërinquë ya'conaramahuë', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ina quëran a'na hua'ani Quisoso huëcapairin. —Quëmaso' Maistro noyanquën, tënahuë. ¿Ma'ta' caso' nii nanpimiata'huaso marë'? Sha'huitoco canta' noya nii, itiirin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿Ma'marëta' “Quëmaso' noyanquën” itëranco? Yosëíchin noyaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iráca pënëntërinso' nitotëran. “Ama sa'an tëhuananpitëquësohuë'. Ama piyapi tëpaquësohuë'. Ama ihuatëquësohuë'. Ama nonpinapiquësohuë'. Tata natëquë'. Mamanta' natëquë',” tënin Yosë iráca pënëntaton, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Hua'huatapo quëran huarë' ya'ipi inapita natërahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ina natanahuaton, Quisosori itantarin: —Isonta' Yosë nohuantërin. Paaton, ya'ipi ma'shanënpita pa'anconquë'. Coriqui canaranso' sa'ahuaro'sa' quëtonquë'. Ina quëran imaquico. Inapotohuatan, Yosë'pa' na'con canamiataran, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ina natanahuaton, co huachi noya cancantërinhuë'. “Hua'huayátërahuë ma'sha ya'huëtërinco,” ta'ton, sëtërin. Sëtaton, pa'nin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Napohuachina, Quisosori itërin: —Sacai quëran ma'huano'sa' Yosë hua'anëntërinquë ya'conapi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ni'co' iyaro'sa'. Nahuan huëratën pi'pira'huaya naninën ya'huëtërin. Camiyo panca masho ni'ton, sacai' inaquë ya'conacaso'. Ina quëran saca sacai' ma'huano'sa' Yosë hua'anëntërinquë ya'conacaiso', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ina natanahuatona', pa'yanpi. —¿Incha nica cha'ërë'poya? itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Co insonta' inaora nanitërinhuë' cha'ëcaso'. Yosëíchin nanitërin anoyacancantinquëmaso'. Ya'ipi nanitaparin, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","—Ni'quë' Sinioro, quiyaso' ya'ipi ma'shanëhuëi patahuatoi, imasarainquën, itërin Pitrori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Tëhuënchachin iyaro'sa', nani ma'sha patohuatama', na'con na'con Yosë catahuarinquëma', tënahuë. A'naquëma' Yosë hua'anëntërinso' a'chinacamaso marë' pëinëma', sa'ama', iyaparima', tatama', mamama', hui'nama', inapita patarama'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ca marë' patohuatama', ipora chachin Yosë na'con na'con quëtantarinquëma'. Ina quëran a'na tahuëri Yosë'pa' nanpimiatarama huachi, itërin Quisosori. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ina quëran ca'tano'sanënpita amashamiachin quëparahuaton, itantarin: “Iporaso', Quirosarinquë paantarëhua'. Inatohua' ya'huasëhua', Yosë quëran quëmapico nipirahuë', nani ma'sha onpotarinaco. Pënëntona'piro'sa' iráca ninshitopiso chachin napotarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hua'ano'sa' masahuatonaco, nisha piyapi'saquë yo'coaninaco. Tëhuaarinaco, no'huiarinaco, ipitarinaco. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chiníquën huihuirahuatonaco, tëpararinaco. Napoaponahuë', cara tahuëriya quëran nanpiantarahuë,” itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Natanaponaraihuë', co nitotopihuë'. Ma'sona tapon naporinso' co yonquipihuë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ina quëran Quiricoquë ya'caritohuachina, a'na quëmapi quënanconin. Ira yonsanquë huënsëarin. Somaraya ni'ton, nani tahuëri inaquë huënsëaton, coriqui topinan ma'patárin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na'a piyapi'sa' iratapi, natanaton: “¿Inta' huë'sarin?” topachina, ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Quisoso Nasaritoquë ya'huërinso' huë'sarin,” itopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ina natanahuaton, chiníquën nontërin: —¡Nosoroco Sinioro! Quëmaso' Tapico' shinquën. Yosë a'paimarinquën ni'ton, nosoroco canta', itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A'naquën quëchitopisopitari natanahuatona', no'huipi. “Ta'tëquë',” itopirinahuë', aquëtë chachin chiníquën nontërin. —Nosoroco Sinioro. Quëmaso' Tapico' shinquën. Onpopionta' catahuaco, itantarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Quisososo' chiniconahuaton, camaitërin quëcacaiso'. Quëshihuachinara: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ma'ta' iyasha onpochinquën? itërin. —Anoyarayatoco Sinioro canta' ni'chi, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Noyapa'. Natëranco ni'ton, anoyarayataranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Itohuachina, a'naroáchin noya ni'tërin. “¡Ma noyacha Yosëso' ni'ton, anoyarayatërinco paya!” ta'ton, Quisoso imarin. Piyapi'santa' pa'yatatona', “Ma noyacha Yosëso' ni'ton, anoyarayatërin paya,” topi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Quiricoquë canconahuaton, ninano huáncana pa'sarin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Inaquë a'na ma'huan ya'huërin. Saquio itopiso'. Inaso', coriqui copirno marë' ma'patona'piro'sa' hua'anën ni'ton, chiníquën nanantërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Quisoso inaquë huë'pachina, na'a piyapi'sari yamotërapi. Saquionta': “Canta' Quisoso nohuichi,” ta'ton, huë'pirinhuë'. Mo'copiya ni'ton, co nanitërinhuë' quënanacaso'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Napoaton ta'arë'nachin piyapi'sa' na'huëtërahuaton, naraquë nanpëconin. “Isëquëchin Quisoso huë'sarin,” ta'ton, inaquë huënsëarin Quisoso nococaso marë'. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quisososo' inaquë canconahuaton, në'pëconin. —Iya Saquio, manóton nohuaraquë'. Ipora tahuëri quëma pëinënquë yacahuaranquën, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Napotohuachina, manorahuaton, nohuaraimarin. Pa'yataton, “Noya Maistro. Huëquë' ni'quico,” itërin. Ina quëran pëinënquë quëparin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Piyapi'sari quënanahuatona', ninontapi. “¿Onpoatonta' oshahuan pëinënquë yacahuatonin?” nitopi. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saquioso nipirinhuë' Quisoso a'chininso' natanahuaton, noya natërin. Napoaton itapon: —Nani ma'sha Sinioro ya'huëtërinco. Ipora patoma sa'ahuaro'sa' quëtarahuë. Iráca a'naya a'naya nonpintato, ihuarahuëso' na'con na'con quëtantarahuë. A'na marëíchin nipirinhuë', catapini quëtantarahuë, itërin. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Itohuachina, Quisosori itërin: —Ipora tahuëri Yosë nicha'ërinquën. Sa'an, hui'nanpita, inapitanta' nicha'ërin. Apraan shinquën ni'ton, nicha'ërinquën. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na'a piyapi'sa' co Yosë natëtonahuë', chihuëpi pochin nipi. Inapita yonica'huaso marë' o'marahuë. Cancanëna' anoyacancanta'huaso marë' o'marahuë, tënin Quisoso. ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na'a piyapi'sa' natanapi. Paatona', Quirosarinquë ya'caritërapi. “Ipora tahuëri'sa' Yosë hua'anëntarinpoa huachi,” topi. Napoaton Quisosori a'na pënënto nanan sha'huitërin: ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“A'na quëmapi aquë pa'sarin hua'an ya'conacaso marë'. Yapa'pachina, piyapinënpita nontërin: ‘Inatohua' pa'pato, copirno chiníquën nanan quëtarinco naro'pa' hua'anënta'huaso marë'. Oshaquëran chiníquën nanan quëtohuachinco, huënantarahuë,’ tosahuaton, ");
INSERT INTO cbtNTpo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","shonca inpriatonën amatërin. Huë'pachinara, a'naya a'naya coriqui quëtërin. Napopináchin quëtëra'piarin. ‘Iporaso' aquë pa'sarahuë. Iso coriqui quëchinquëma' ma'sha pa'anatoma', na'con na'con ca