﻿USE sofia;
DROP TABLE IF EXISTS sofia.cbsNT_vpl;
CREATE TABLE cbsNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cbsNT_vpl WRITE;
INSERT INTO cbsNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abrahamnen baba inun Davidin baba Jesucriston xenipabukidi matu yuinun ninkaidakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamnen bake betsadan, Isaac inikiaki. Isaacun bake betsadan, Jacob inikiaki. Jacobun bakebudan, Judá inun jawen betsabu inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judán bakebudan, Fares inun Zérah inibukiaki, jatun ewan kenadan, Tamardan. Faresin bake betsadan, Hesrón inikiaki. Hesrónen bake betsadan, Aram inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramin bake betsadan, Aminadab inikiaki. Aminadabin bake betsadan, Nahasón inikiaki. Nahasónen bake betsadan, Salmón inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónen Rahab ainwantan bakewa jatun bake betsadan, Booz inikiaki. Boozin Rut ainwantan bakewa jatun bake betsadan, Obed inikiaki. Obedin bake betsadan, Jesé inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesén bake betsadan, xanen ibu David inikiaki. Janua Urías mawaken Davidin Uríasin ain bixun bakewa jawen bake betsa Salomón inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónen bake betsadan, Roboam inikiaki. Roboamin bake betsadan, Abías inikiaki. Abíasin bake betsadan, Asá inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asán bake betsadan, Josafat inikiaki. Josafatin bake betsadan, Joram inikiaki. Joramin bake betsadan, Ozías inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozíasin bake betsadan, Jotam inikiaki. Jotamin bake betsadan, Acaz inikiaki. Acazin bake betsadan, Ezequías inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasin bake betsadan, Manasés inikiaki. Manasésin bake betsadan, Amón inikiaki. Amónen bake betsadan, Josías inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Januxun nawabun Israelnabu jatu dayamakatsi achixun Babilonia anu jatu iyunibu Josíasin bakebudan, Jeconías inun jawen betsabu inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Janua Babilonia anu jiweabun Jeconíasin bake betsadan, Salatiel inikiaki. Salatielin bake betsadan, Zorobabel inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelin bake betsadan, Abiud inikiaki. Abiudin bake betsadan, Eliaquim inikiaki. Eliaquimnen bake betsadan, Azor inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorin bake betsadan, Sadoc inikiaki. Sadocin bake betsadan, Aquim inikiaki. Aquimin bake betsadan, Eliud inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudin bake betsadan, Eleazar inikiaki. Eleazarin bake betsadan, Matán inikiaki. Matánen bake betsadan, Jacob inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobun bake betsadan, Marían bene José inikiaki. Janua Marían bake betsadan, Jesús inikiaki, kenakin Mesías Cristo nun amisdan. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Janua Abraham anua jatun ibuwen pakea 14 xenipabu jiwekubidanaibutian janua David kainikiaki. Jaska inun, David anuadi ana jatun ibuwen pakea 14 xenipabu jiweabutian nawabun jatu achitan dayamanun, iwanan, Babilonia anu jatu iyunibukiaki. Janua jatu iyunibu anuadi ana jatun ibuwen pakea 14 xenipabu jiweabu anudi Mesías Cristo kainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo kain eskanikiaki. Matu yuinun ninkakanwen. Janua María ainwankatsi ikin jawen epa Josén yukaima bimadiamaken Diosun Yushin Pepatun juni bake naneima Marían unanyan, ");
INSERT INTO cbsNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","janua María ma tuya jawenabun ninkatan José yuiabu María ana ainwankatsi ikamabia juni pepakin jaska yuda dasibi bebun Maríakidi chanikin dake wakatsi ikama jabe yubakaima june jenexanun, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","shinankubaini uxa namaya Diosun nai tsuman yuikin: “Joséen, miadan, min Davidin babaki. Mia yuinun ninkaidawe. Diosun Yushin Pepatun María bake naneimawen taea jawen datei jawa dakeama ainwanxanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ja juni bake kaintan ewatan jawenabu Dioski pechia chakabumisbu jau jatun ana Dios chibanunbun jatu medabewaxanaiwen taexun kenakin: ‘Jesús’, waxanwen”, aka Josén jaska ninkatan shinanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Jaska Jesús kaintan bebunkidi jaskanunbadiai jawen jancha yuixunika Isaías Diosun yuikin: “Uian. Junin chutadiama chipashan bake bima juni bake kaian kenakin: ‘Dios nukube jiweaki’, axankanikiki, hebreo janchawen, ‘Emanuel’, wakinan”, aka ninkatan keneniken jabias jaska dasibi bebunkidi inunbadiai chanini Diosun xabakabi jatu unanmaniki, jaska jawen jancha yuixunika kenemani keska menekinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","José uxa bestentan jaska nai tsuman yuixu jawen jancha chibankin Josén María bikin ainwantan jabe dadatamebiaxun chutadiamaken jawen bake kaian Josén kenakin: “Jesúski”, anikiaki, nai tsuman yuima keska wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Herodes Judea anu xanen ibuaya Belén anua Jesús kainken janua bishi unanikabun bishi bena taxnia uintan chaikea badi juai estekidia bekubidani Herodesin maewan Jerusalén anu jikitushitan jatu yukabaunkin: —¿Judiobun xanen ibu bena kainmadan, janimen? jawen unanti bishi bena taxnia bechitan kenwanun ika nun juaidan— ikin jatu yuka keyubaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","janua Jerusalén anuabun dasibi ninkai dateaibun xanen ibu Herodesin ninkadiatan shinain: “Ea binuxanimenkain”, ika datekin ");
INSERT INTO cbsNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","tapinun ixun Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbu jatu kenaxun yukakin: “Diosun Katua Mesíasdan, ¿jania kainxanimenkain?” jatu wa yuinametan ");
INSERT INTO cbsNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","jatun xanen ibu yuikin: —Jawen jancha yuixunika Miqueas Diosun yuini ninkawe: ‘Belénmaan, Judea mae pakea anu min mae jatiumabiaken mia anua xanen ibu kayabi kainxanikiki, enabu Israelbu mekexanaidan’, akin yuia keneniki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodesin ninkatan jatu nichian buaibun janua badi juai estekidia bishi unanikabu beshianbu jabudi june kenaxun jatu yukakin: “¿Jatian bishi bena taxnia man bechibidanimamen?” jatu wa natian ma bechibidanimaxun Herodes yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ninkatan jatu bepadankin yuikin: —Belén anu buxun yuka ikin ja bake bechitan kenwantan eadi yui betankanwen, eadi kaxun en kenwain kanunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","ninkabaini Belénkidi bukin bishi bena uinmabu ana taxnia chaxakaini jatu bebun kai uin benimajaidabainkin chibanbainaibun janu ja bake jiwea mamaki niti ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ja jiwe anu jikikain ja bake jawen ewa Maríabe bechitushitan kenwain ja bebun danti iki beti itan benitan ja bau bekanxu bepenxun oro mane inun ja kuaxunti ininipa inun jawen puxati dau ininipa inankuintan ");
INSERT INTO cbsNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","jaska watan bua uxa namaibun Diosun nai tsuman jatu yuikin: “Xanen ibu Herodes anu ana chintunbainyamakanwen”, jatu wa jawaida bestentan bai betsawen inun bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bishi unanikabu ma inun buabun jabiatiandi José uxa namaya Diosun nai tsuman yuikin: “Joséen, jawaida bestenwen. Xanen ibu Herodesin bakeishta detenun, iwanan, jatu benamayuikiki. Jawaida bestentan ja bake jawen ewabe iyukin Egipto anu jatu paxawaditanwen. ‘Iwewe’, iwanan, en mia yuidiama jabiadi jiweyuxanwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","jawaida bestentan meshu medan ja bakeishta jawen ewabe paxawakin chaijaida iyukin atimas Egipto anu jikimaima xanen ibu Herodes mawadiamaken jadia dayai jiweyunikiaki. Jawen jancha yuixunika Oseas Diosun yuikin: “Egipto anua en juni bake en kenaxanaii”, aka ninkatan keneniken jaska dasibi bebunkidi inunbadiai chanini Diosun xabakabi jatu amaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Janua Herodes bishi unanikabun padanbainshinabu ana beabumaken Herodesin unantan sinatajaidakin jaska bishi unanikabun yuibainshina juni bake badi dabeyadiabuma inun badi dabeyabu jau dasibi jatu detekin tenantanunbun jawenabu soldadobu yunua Belén inun ja dapi jiwebaunabu anu buxun detekin tenankin keyunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Bebunkidi jawen jancha yuixunika Jeremías Diosun yuikin: “Jerusalén kema mae betsa Ramá anua Jacobun ain Raquelin baba ainbuaibu jatun bakebu jatu deten keyunshinabu manui sain ikaibu ninkakin tsuan jatu nesewatidubuma iki kaikiki”, aka ninkatan keneniki. Jaska keneni nakushkin soldadobun jatun bakebu deten keyunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Janua Herodes ma mawashinken Egipto anua José uxa namaya Diosun nai tsuma ana juxun yuikin: “Joséen, janun bestenwen. Jabun ja bake detenun ika ikimabudan, ma mawashinabuki. Janu Israelbun maiwan anu ja bake jawen ewabe ana jawendi iyudiwe”, aka ");
INSERT INTO cbsNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José bestentan María jawen bake Jesúsbe iyui Israelbun maiwan anu jikia ");
INSERT INTO cbsNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","januxun betsabun yuikin: “Herodesin bake Arquelao xanen ibuikiki”, akabu Josén ninkatan datei Judea anu kadiama janua ana uxa namaya Diosun nai tsuman nemakin yuia bestentan Judea anu ana kama Galilea mai pakea anu mae betsa jatiuma Nazaret anu jikitan janu jiweyunibukiaki. Ja mae anu iyukinan, bebunkidi Diosun jancha yuixunikabun Jesúskidi kenekin: ‘Nazaret anuaki’, axanaibu jakidi kenenibu menekin jadi iyuimaxun jiwetanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","5","Bebunkidijaida jawen jancha yuixunika Isaías Diosun yuimakin: “Janu tsua jiweabumanuxun beaibu jui kushipawen chanikin jatu yuikin: ‘Nukun Xanen Ibu nai anua matuki bayui ma kemaikiki. Matun juintinin shinan pewadikanwen, bai kayatapia keska wakinan’ ”, ani keska wakin Nashimanika Juan junixun Judea anu tsua janu jiweabumanu camello dani sanpu tima sawea inun bichi nanexeketi sawea inun jawen piti pe bexmas chanpu inun ni medanua buna bata aki jiwexun jadixun jatu yusinkin taewai bana ninkatan Jerusalén anua inun Judea anua inun Jordán jene kexa jiweabun ninkanun ika bebidan bebidanaibu jatu yusinkin: “Dios nenu xanen ibui ma kemaikiki. Dioskidi shinanma man chakabumis jenedikanwen”, jatu wakubainai ");
INSERT INTO cbsNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","jabun ikunwankin jatun chakabu Juanki chanikin jatun chakabu jenekatsi ikin shinan betsa waibu jawen unanti wakin Jordán jene anu Juanen jatu nashimapakeaya ");
INSERT INTO cbsNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","8","janua Juanen jau ea nashimanun ika saduceobu inun fariseobu bebidan bebidanaibu jatu yuikin: “Matudan man padananbuki, dunun jatu pimis keskabudan. Man jaska keska matuki Dios sinatakin matu kupijaidaxanaiwen taea matun shinan betsa wakanwen. Jaskatan matun chakabu man ma bextekea xabakabi man ea uinmaya en matu nashimaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jamen matumebi ibubis kenkin man shinanmis: ‘Nukun xenipabu Abraham Diosbe jaibunameniwen taea nun jawen bababu nuku kupiama ixanikiki’, ikin, ana shinanyamakanwen. Jakia Abrahamnen bababu dasibi matu yamawakin keyutan na mishki manibauna Diosun damiwakin Abrahamnen bababu benawaxuntiduki. ");
INSERT INTO cbsNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jaskaken matu yuinun ninkakanwen. Ji tibi bimi pepa jayama dedatan man kuamis keska wakin bestibu Diosun matu kupixanikiki. Jamen tsuabuda Abrahamnen baba kayabibun jawen yusian jau chibankubainunbunwen. Jakia man jaska wamaken matu kupinun, iwanan, duewen matu deda keska watan chi anu matu udenun, ixun manaikiki”, ");
INSERT INTO cbsNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","iwanan, “Eanan, jawen unanmati wakin jenewen besti en matu nashimakubainaii. Jakia juni betsadan, kushipajaida ea binuan chipu juxanikiki. Jawen tsumapan jawen daya axunmis keska wakin en jawen jawaumajaidatun ean medabewakin en duawatidumaki, jawen bichi tae mexpun tsitsaukain en pekaxuntidumadan. Jakia matu pepawakin Diosun Yushin Pepa matu inantan bika matu tenemakin matun chakabu yamawaxanikiki, chiwen jawada chakabu bechipaiama kua keska wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ja inun, xekiwan bimi ta keyuxun pepa adutan jawen xepa kuamisbu keska wakin dasibi jawenabuma danankin jawa chi nukaisma anu udenxun kuanun, iwanan, manayubainikiki”, akin Nashimanika Juanen jatu yuikubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Janua Galilea anua Jesús ewatan Juanen jau ea nashimanun ika Jordán Jene kexa anu kaxun Juan yuka ");
INSERT INTO cbsNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","nemanun, iwanan, yuikin: —Mian ea binuxun min ea nashimatibia ¿jaskai eanu min juxumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesúsun yuikin: —Ea jaska wama ea nashimawe, Diosun nuku yununiwen taexunan— aka —Jaskakenan, peki— ikain, Juanen Jesús nashimakin ");
INSERT INTO cbsNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","meneaya nexekei mapekekainaya nai baxnei Diosun Yushin Pepa deiwan itsakidan jamamaki butuai Jesúsun uianyan ");
INSERT INTO cbsNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","yudabu ninkamai nai anua jui taxnikin yuikin: “Nadan, en bakeki. En bechipaijaidaii, en Katuadan”, anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jabiatiandi jau diablo Satanásan unanti wanun, iwanan, janu tsua jiweabumanu Diosun Yushin Pepatun Jesús nimakin iyua ");
INSERT INTO cbsNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","jadia 40 xaba inun 40 meshu Jesúsun jawa piama bunijaidaya ");
INSERT INTO cbsNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","diablo Satanás jaki nukutan unanti wanun ixun yuikin: —¿Jaska min Diosun bakemenkain? Min buniaidan, na mishki mania damiwakin misi watan piwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesúsun kemakin: —Jaska Diosun jancha kenenibudan, ninkawe. “Piti besti pidan, yudabu pei jiwetidubumaki. Jakia Diosun jancha yuini ninkatan chibain yudabu pei jiwetidubuki”, aniwen taexun ja jaska min ea yunuaidan, en akamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","januxun Jerusalén anudi iyuxun Templo jiwe keyatapa mamaki mapematan jabe nixun ");
INSERT INTO cbsNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Satanásan ana yuikin: —Jaska Diosun jancha kenenibudan, miandi ninkawe: ‘Jau mia mekenunbun jawen nai tsumabu Diosun yunuxanikiki. Mishkiki min jutekepanan min kawanai mia mekesuxankanikiki’, aniwen taea jaska min Diosun bake kayamenkain mia uinun nenua ea uinmai main ishchuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ana Satanás nemakin Jesúsun yuikin: —Jaska kenenibu min dama ea yuiai chanimabiaken ana betsa entsedi mia yuinun ninkawe: “Matun mekenika yushin Dios unanti wayamakanwen”, iwanan, kenekin yusindianiwen taexun min ea ana yunuaidan, en ikamaki, ishchuidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","jawen jenekin mati keyatapajaida anudi Jesús iyuxun mai jidabi anu maewan jawendua tibi inun jawen xanen ibubu diablo Satanásan jawaida uinmakin jawen damiwati kushipawen uinmakin keyutan ");
INSERT INTO cbsNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jesús yuikin: —Eki mesei danti ixun kenwankin min ea xanen ibu waya na dasibi en mia uinmaxudan, en mia jatu xanen ibu wamakubainxanaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ana nemakin Jesúsun yuikin: —Jaska Diosun jancha kenenibu ana ninkawe: “Matun mekenika yushin Dios besti duawakin kenwankubainxankanwen, yushin betsaki meseamadan”, aniwen taexun ja min jaska yuiaidan, en mia akamaki. Satanásaan, kadiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","januxun Satanásan jeneyubainaya Diosun nai tsumabu bexun Jesús medabewakin duawanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Janua xanen ibu Herodesin Nashimanika Juan jatu bichimashina banabimabu Jesúsun ninkatan Galilea mai pakea anu chintunkaini ");
INSERT INTO cbsNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret anu kai bashikuama janua mai pakea dabe anu Jacobun bake Zabulón inun Neftalí jatun bababu xukuabu namakis ian kexa mae betsa Cafarnaúm anu ka janus jiwekidankidanpauniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Januxun jawen jancha yuixunika Isaías Diosun yuikin: “Zabulón maewan anu inun Neftalí maewan pakea anu ianenwan kexa anu Jordán jene kexa betsaudi Galilea anu janu nawabu nukunabuma jiwebaunabu anuxun bin ewapa chaxajaida keska ea jawa unanbuman uinxankanikiki. Ja inun, meshu medan punu nuka mawa keska jiweabu jatu medabewai bin dekua chaxajaida keska ixanikiki”, aka ninkatan keneniki. Jaska yuini keskai Jesús Cafarnaúm anu jiwekidankidanpauniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Januxun Jesúsun yusinkin taewakin jatu yuikin: —Nukun Xanen Ibu nai anua matuki bayui ma kemaikiki. Man Dioskidi chakabumis jenetan shinan betsa watan janu bekanwen— jatu wakubainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Janua Galilea ianenwan kexa Jesúsun ketankubainkin baka nexenika dabe Simón, jawen kena betsa Pedro, inun jawen betsa Andrésin jatun xaxunxun jisin punteaibu jatu bechitan ");
INSERT INTO cbsNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","kenatan jatu yuikin: —Ea chibankubainkanwen. Ana baka nexeama jakia man baka nexemis keska wakin yudabu en matu ichawamaxanaii, jau ea ikunwanxanunbunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","januxun jatun xaxu inun jatun jisin jatun jaibu betsa yunu keyutan jawaida jenebaini Jesúsbe buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","janua jatube ana ketanbaini kakin Santiago inun jawen betsa Juan jatun epa Zebedeobetan xaxu namaki tsauxun jatun jisin kexekin junuaibu bechitan Santiago inun Juanki nukuxun jatu yuidiakin: “Ea chibankubainkanwen”, jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","jawaida jatun xaxu jatun epaki jenebainkin Simón inun Andrésbetan Jesús chibanbainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Janua Galilea anuxun yusinkubaunkin mae tibi jatun ichati jiwe anuxun kakape Dios xanen ibui ma kemaikidi jatu yusinkin isin betsa betsapa teneaibu jatu xuxawakin kayawakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","janua Siria mai pakea jidabi anuxun Jesúsun jatu xuxawai kakaibu ninkatan isin betsa betsapa teneaibu inun, yushin chakabuyabu inun, yuda chakabu saki saki ikaibu inun, yuda babubu nuitapaibu jatu iwebidanbidanaibu Jesúsun jatu xuxawakin kayawapakeaya ");
INSERT INTO cbsNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilea anuabu inun, Decápolis anuabu inun, Jerusalén anuabu inun, Judea anuabu inun, Jordán jene kexa betsaudi este badi juaikidia bei jatuki dasitan yudan kaian ichapabun Jesús chibankin uinkubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jatibu jachun buaibu uinkin mati anu mapekea makenku anu tsauken janua jawen tsumabudi ja dapi tsauabun ja yudan kaianendi chibanbain ninkai maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesúsun jatu yusinkin taewakin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Benimatidubukidi matu yuinun ninkakanwen. Tsuabuda kenkubainsbuma Dios xanen ibukin jatu duawaxanaiwen taea benimapaketi shinain benimakubainkanikiki, manaidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Ja inun, tsuabunda jatun juinti nishma kaxakatsis ikaibuwen taexun Diosun jatu shinan chankanwan benimapaketi shinain benimakubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Ja inun, tsuabuda shinan pepaya keinsbuma Diosun mae pepa jatu yubani jatu yunuxanai shinain benimakubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Ja inun, tsuabuda jawada pepa besti bechipai chakayamai jawen nuijaidaiwen manakukin Diosun jatu yaniwama keska waxanaiwen taea benimapaketi shinain benimakubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Ja inun, tsuabuda nuikipabuwen Dios nuidiaxanaiwen taea benimapaketi shinain benimakubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Ja inun, tsuabuda shinan xunpin pepa jaya jabun Dios uin jiwexanaibuwen taea benimapaketi shinain benimakubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Ja inun, tsuabuda duapa unanuma jatube jiwekatsi yuda betsabu sinataibu jatu daewamisbu Diosun jawen bakebu wakin jatu kenamiswen taea benimapaketi shinain benimakubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Ja inun, tsuabunda Diosun jancha shinankin chibainbu jatu ichakawabiabu chintuinsbumawen taea Dios xanen ibuai anu janus xukukatsi ikin shinain benimakubainkanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","jaki chiti ikabudi yuikin: —Ja inun, tsuabunda man ea chibainbuwen taexun matu usankin ichakawakin matukidi chanichakakin matu danainbu matun benimapaketi shinain man benimapakediaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Janua Diosun jancha yuixunikabu ichakawanibu keska wakin matudi ichakawaibu nai anuxun Diosun matu duawaxanaiwen taea jawa dateama shinan chankankubainxankanwen— itan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Jamen matudan, jawawenda Dios benimawati yudan kaian man yusintidudan, Diosun jau jatu mekexanun man jawen meketi tewe bata keskaki. Tewewenan, jawen nami chaputimawatiki. Man ma nami teweya wabia ja tewe payukui jawen bata keyu kaken tsuan ana mekekin bata watidumaki. Man jaska keskaibu tewe batauma jemaintin putabu jaki paimisbu keska man itidubuki, uindaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Jamen betsadan, ekidi man jatu yusinxanaidan, man xaba keskaki. Janu mae betsa mati mamaki jiwe junetidubuma keska wakin en matu yusiainwen juneama jatu xabakabi yusinkubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ja inun, bin dekutan bau naman junekin tsauinsbumaki. Jakia janu dasibibun uiainbu chaxamis anu manaundi tsauntiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bin chaxamis keskai jawa juneama medabenain jiwekubainxankanwen, matun jancha ninkakin man pepaibu shinankin jabundi jau Epa Dios kenwanxanunbunan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ana jatu yusinkin: —Eanan, Diosun jancha yuixunikabubetan jaska Moisin yusinikidi nemanun ika en juamaki. Jaska ekidi shinanyamakanwen. Jatun jancha bextenun ika en juama jakia Diosun jancha chanima kayabi xabakabi matu yusinun ika en juniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Chanima nai anua inun mai keyudiamaken Diosun jancha yuixunikabubetan jaska Moisin jatu yusini jancha chanimadan, ean en matu yuiaidan, jawa tsuan nemakin inun jawa betsa wama jancha tibi menepakexanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jakia tsuabunda yusian betsa bikama maewaxun jawenabu jatu yusianyan Dios jatuwen benimama ixanikiki. Jamen tsuabunda Diosun jancha ninka kayabitan jawenabu jabias jancha betsa maewama yusiainbu Dios jatuwen benimajaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Jaskawen taea Dios benimawakatsi iki fariseobu inun Diosun jancha kenenibu yusinananmisbu jiwekubainaibu keska ikama pe jiwekin Dios benimawakin man jatu binuama nai anu Dios xanen ibuai anu matudi man jikitidubumaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ana jatu yuikin: —Moisin nukun xenipabu yusinkin: “Sinatakin juni betsa deteyamakanwen. Jaskabiaken juni betsaki sinatakin man deteken xanen ibubu ichaxun jaska jadi unantan jau kupixanunbunwen”, axun keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jawen jancha chanimaki. Ana jabiasdi matu yusinun ninkakanwen. Tsuada yuda betsaki sinatakin detekatsi ikin man shinankubainaiwen taexun Diosun matu kupixanikiki, matun shinan chakabuwenan. Ja inun, tsuada yuda betsaki sinatakin ichakin: “Min unainsmapaki”, ikubainmisbu jau xanen ibubun kupixanunbunwen. Jamen ana yuda betsaki sinata chakayamakin chitekin: “Min jawa unanmajaidaki”, ikubainmisbu chi jawa nukaisma anu Diosun udenkatsi manakubainikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jaskaken januxun Dios kenwanti chi tapu anu matun inankuin man buai jaki kematan uatian kanekin yuda betsa man chakabuwashina shinantan ");
INSERT INTO cbsNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jawen Dios daewati man buai jabianu janayutan kaxun daewakin ana jaki nukutan ana jabe janchai pekanwen. Jaska watani ana juxun jawada man Dios inankatsis ikaiwen man ana kenwantidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Jaska inun, yuda betsa man dibijaidawen taexun ja man dibiatun nawa xanen ibu anu matu iyuaya jau xanen ibun jawen policiabu matu bichimayamanun ja man dibia jawawenda daewakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Man daewabainama matu bichiabu man paka keyuama chanima man jaskatan kaintidumaki. Jabiaskadi wakin ea jaibuwatan Epa Dios daewadiakubainkanwen, matun chakabuwen jau matu kupiyamaxanunan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ana jatu yuikin: —Jaska inun, betsadan, Moisin nukun xenipabu ana yusinkin: “Juni betsan ain chutanyamakanwen”, axun keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jawen jancha chanimaki. Ana jabiasdi matu yusinun ninkakanwen. Tsuanda ainbu kawanai uin jawen kemukin chutakatsis ikin shinainan, ma chuta keskaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jaskawen taea min bedu betsawen jawada uin min kemuai bedu betsa tseka keskatan jawada shinankin min chakabuwai jawaida jenekubainkanwen. Min bedu dabeyadan, janu chi nukaisma anu matu puta pemajaidaki. Jakia bedu bestichai keskaya Diosbe jiwei kai peki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ja inun, min meken betsawen min chakabuwai min meken betsa mextekea keskatan jawada min mekenen min chakabuwai jawaida jenediakubainkanwen. Min meken dabeyadan, janu chi nukaisma anu mia puta pemajaidaki. Jakia meken bestichai keskaya Diosbe jiwei kai peki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ana jatu yuikin: —Moisin nukun xenipabu ana yusinkin: “Tsuanda matun ain jenekatsi ikin jawen taexun ainbu jeneti kene jau inankubainxanunbunwen”, axun keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Janua juni betsan jawen ain juni betsabe chutanameamabiaken jenekatsis ikin jawen ain jawamabiaken jenebainadan, janua ainbu jaska shinanmabiaken ja junin ma putabaina januxun ja junin chakabuwen taea janu ainbu jawen benen chakabumaikiki, bene betsa benayatikidi shinanmakinan. Janu ainbu jawen benen ma jenebainima juni betsan ja ainbu jabe biakanantan jabe chutanamei pebiaidan, juni betsan ainbe chutanamei keskaikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Jaska inun, betsadan, Moisin nukun xenipabu ana yusinkin: “Jawadakidi yubakakin yuikin: ‘En yubakai en akamaken jau Diosun ea kupixanunwen’, ikama padanma Dios benimawakin axunkubainxankanwen”, axun matu kenexuniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jaska yusinbianiken eanan, en matu betsa yusiaiin. Jawada betsa tibi datan aki yubakayamakubainxankanwen. Eskaidan, nai datan akin shinain jawen yubakayamaxankanwen, Diosdi jadi jiwea inun jaki tsaudiakidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Maidi shinain jawendi yubakayamaxankanwen, na maikidan, Diosun jawen tae kenyankidan. Ja inun, maewan Jerusalén shinain jawendi yubakayamaxankanwen, janudi xanen ibujaida jiweakidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ja inun, matumebi matun buxkakidi datan akin shinain jawendi yubakayamaxankanwen, man jaska waxun matun bu meshupa bestichai maewakin man juxupawatidumakidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jaskaken man yubakatiduma shinankin chanima yuikinan: “Jaa, en atiduki”, ikasmai: “Jamaki. En atidumaki”, iki janchakin besti yuikubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ana jatu yusinkin: —Moisin nukun xenipabu ana yusinkin: “Miki sinatakin mia detekin min bedu kasmai min xeta kasmai jadatuda matu chakabuwabu xanen ibu min yuia jabianudi manakukin jau mia jatu kupixunxanunwen”, axun keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jawen jancha peki. Ana jabia keskadi ja binua matu yusinun ninkakanwen. Tsuada miki sinatakin yusiudi mia ispais aka jabebis sinatakin kupiyamakanwen. “Uke betsadi ea awe”, ika dabekexunai keskakin shinankubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ja inun, min tsuada dibia xanen ibu anu mia iyua pakaxun min bixanun min sanpu jau biyunun xanen ibun mia yunua inanyuwe. “Pakaxun jau bixanun dakukuti biantidubumaki”, akin Moisin yunubianiken xanen ibun mia yunua min dakukutidi yaushiyamawe. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ja inun, tsuada xanen ibukin yunukin kilómetro bestichai anu jawen mabu mia bumaya buxunkin janu mia yuia binumabain ana kilómetro betsa anu man buxuntiduki, sinatamadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ja inun, yuda betsa nuitapai jawa jayama min mabu biyukatsi mia yuka yaushiama inanyukubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ana jatu yuikin: —Jaska inun, betsadan, matun yusinanbun Diosun jancha matu yusinkin yuikin: “Matunabuwen besti nuikubainkanwen, nawabu matuki sinatamisbu bechipaiamadan”, akin matu yusinmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jakia eanan, jancha betsawen en matu yusiaiin. Matuki sinataibu jatuki sinatama jatuwen nuikubainxankanwen. Ja inun, matu ichaibu inun matu ichakawaibu jatu dananma medabewakin jau Diosun jatu duawanun yukaxunkubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jakia jaska matun Epa nai anuatun yuda pepabu inun yuda chakabubuwen nuikin jatu badi chaxamaxunmis inun ui imaxunmis keska wakin matudi yuda dasibibuwen nuikin man jatu medabewakubainaiwen taexun jabun uinkin man Diosun bakebu unanxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jamen gobierno pei bixunikabu chakabubiai duanamemisbu keskakin tsuabunda matu duawaibu jatube besti man duanameaya matuwen Epa Dios benimamaki, jawa manakuti pepa matu inanmadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ja inun, ikunwain betsabu bechitan jabube besti janchakin yuda betsabu danain ikunwanbuma jabiaskadiamisbuwen taexun pepakin man jatu binuamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jaskaken matun Epa Dios pepa nuikipa keskai matudi pepai dasibibube nuidiakubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ana jatu yuikin: —Yuda betsabu man medabewai jau matu uin bestikin kenwanunbun jaskayamakubainxankanwen. Jakia yudabun bedubi besti man jatu medabewakin duawamiskenan, Epa Dios nai anuatun jawa ana betsa matu manakuama ixanikiki, kenwanmadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jaskaken nuitapaibu man medabewaidan, tsua jatu banabimakin xabakabi jatu uinmakin pawayamakubainxankanwen. Jakia jabu bepadamemisbun nuitapaibu jatu medabewakin jau yudabun ea kenwanunbun, iwanan, ichati jiwe anuxun inun bai namakixun jawada jatu inankin xabakabi wamisbudan, yudabun manakuti ma jayabuki. Jaskawen taexun chanima kenmisbu Diosun ana jatu kenwanma ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nuitapaibu medabewakin tsua yuiyamakubainxankanwen, min jaibujaida yuikin unanmamadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","June pepa aki pepakubainxankanwen. Jawada june man jatu axunmis matun Epa Diosun unankin ana manakuti pepa matu tibi inanxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ana jatu yuikin: —Ja inun, betsadan, ja jatunmebi kenmisbun ichati jiwe anu kasmai jemaintin anu nixun jau ea ninkakin kenwanunbun ika jui kushipawen Dios kenwanmisbuki. Jaska waibu Diosun bechipaiama yudabun besti jatu bechipaimisbuwen taea matudan, jaskayamakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jakia matunan, Dios dayuikatsis iki janu tsua niama anu ka june jabe janchakubainxankanwen. Man jaskai Epa Diosun dasibi june unainwen taexun ninkatan pepawen matu manakuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ja inun, matu Diosbe janchaidan, jau Diosun ea ninkanun, ika jabias jancha jawenchains yuiyamakubainxankanwen, jaska Dios ikunwanbuman amisbu keska wamadan, jamen janchawainan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jawa man jayama man yukakatsis ikai man yukadiama matun Epa Diosun unainwen taexun jas shinankin jawenchains yukayamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eska watiki, dayuikinan: —Nukun Epa nai anuatuun, min kena medibidan, mia duawakin jau mia kenwankubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nai anuxun min yunua jaska chibanmisbu keska wakin nenuxundi dasibibundi jau min shinan besti chibankubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ja inun, nuku mekekin na jabiatian nun piyunun jaska min shinainwen piti nuku inanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ja inun, nuku chakabuwaibu jatu jakimawakin jatun chakabu nun ana jaska shinanmawen taexun nun mia chakabuwai buaxuntan ana jaskakidi nuku shinanmayamawe. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nuku mekekin jawen chakabuti tibi nuku kainmaxunyamawe. Ja inun, jawada chakabu tibi nuku nemaxundiakubainwen, atiki— atan ");
INSERT INTO cbsNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ana jatu yusinkin: —Yuda betsan matu chakabuwashina jaki sinatabiatan jawaida jabe daekubainkanwen, ana jas shinanmadan. Man jaskaibu matun chakabudi Diosun matu buaxuntan ana shinanma idiaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jamen yuda betsabun matu ichakawabu ja shinankin man pewamaken matun Epa Diosun matun chakabudi buama ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Matu samakeidan, besu atimapatan iyamakubainkanwen, jabu bepadamei kenmisbu samakei amua mapumisbu keskamadan. Jabu bepadamei kenmisbu jatun besu atimapa uinkin ma samakeaibu jau ea unanunbun ika jaska mapumisbuki. Chanima yudabun uinkin jatu kenwainbu jawen besti jatun manakuti bimisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Jakia Dios shinain man samakeai jau tsuan matu unanyamanun bechukitan buexekei pekubainxankanwen. Samakei man jaskai matun Epa Diosun dasibi june unaintun man ikai uinkubainkin kenwankin matu manakuxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ana jatu yuikin: —Na mai anuxun juni ichapabu jiwexun mabuwen kemukin ichawamisbuki. Jakia matunan, mabuwen kemukin ichawayamaxankanwen. Jawada bikin man ichawa jawen masanen pesa pesa akin inun nakaxan pidiatiduki, matu benunkinan. Ja inun, junibu yumetsubun matun jiwe anu jikitan matun mabu dasibi man adu pewabiaken matu bianbaintidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jaskaken yuda betsabu ikaibu keskakin kemukin mabu ichawama Epa Dios besti benimawakubainxankanwen. Man jaskakubainmisbuwen taexun Diosun matu manakukin jawada jawen masanen pesa pesa aisma inun juni yumetsubun mia bianbaintidubumawen matu duawaxanikiki, jiwekuinmakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tsuabuda jawen jiweti mabuwen kasmai Dioskidi shinain man Dios jiwexunaidan, jabiadidi matun shinanen man nuiai jayaki, nai anu kasmai mai anudan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Ja inun, matun yuda anudan, matun bedudan, bin chaxa keskaki. Jaskakidi matu yusinun ninkakanwen. Matun beduwen man uinmiski. Matun shinanwen matun yuda pepa jaya kemuama man xabakabi meke pewaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jakia bedu chakabuya jaska shinan chakabu jaya kemukin uinchakakin man kanemiski. Ja inun, Diosun shinain unanbiakin tsuanda shinan pewama kanei chakabujaidamisbuki. Matudan, jaskayamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Ja inun, jadatuda dayadun jawen xanen ibu dabe dayaxunkin ja dabe medabewatidumaki, betsa bechipaikin chibankin betsa bechipaima danankin ninkamadan. Jabiaskadi wakin pei inun Diosdi chibankin ja dabe jaska waxun man duawatidumaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ana jatu yuikin: —Eska bestiwen taea matunmebi man jamapaiwen dabanan imisbukidi matu yusinun ninkakanwen. Jiwe bestia pepakunkainun ika piti pi inun tadi sawenun ika jawen dabanan iyamakubainxankanwen. Jiwea jayaidan, pitiwen besti nun itidubumaki. Yuda jayaidan, tadi sawe bestinun ika nun itidubumadiki. Jaskaken ja dabewen taea nun jiwenun Diosun nuku jiwea inanma iniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Uinkanwen, peiyabukididan. Nai anu peiyabunan, jabun jawa banama inun jawa bimi tsekatan jabun piti aduti jayamabiaken matun Epa Dios nai anuatun jatu pimakubainmiski. Jaskaken Diosun matu bechipaikin peiyabu matu binumakubainmiski, medabewakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ja inun, tsuabuda ibubis nuikin jawen mabu inun jawen piti shinainwen taexun jawen jiwea ana chaipawatidumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Jaskai tadiwen taea shinain man jawen dabanan imisbumen? Uinkanwen. Ja jua yumei ewamisbukidi shinankanwen. Jua dayakin tadi timaisbumabia jua jawendua tuemisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jua jaskabiamisken nukun xenipabu xanen ibu Salomón mabujaidayatun jawen tadi jawendua kadujaida sawexun jawenduakin jua binuama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jakia ni maxu juaya sepashinxun kuamisbuki. Diosun jua jawenduawamistun ja jua binumakin Dios matuwen nuikin matu tadi sawematiduki, man ikun bexmas wabiayadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Jaskaken yuda dasibibu mai jidabi anuabu piti inun tadiwen kemukin benakubaunmisbuki. Jakia matudan, man betsaki. Matun Epa Dios nai anuatun matu unainwen taea ja piti inun tadi man bikatsis imisdan, ana jas shinain jawen dabanan iyamakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jakia jawada Diosun bechipaiai chibankin ja dukun Dios xanen ibuwakin shinankubainxankanwen. Man jaska wai ja kachu jawen jiweti piti inun tadi man jayakunkainxanaii, Diosun matu medabewadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jaskaken meshukidi min jawada waxanaiwen dabanan iki dateyamakubainxankanwen. Jakia xaba tibi jawanda mia itimaska wai taxnikunkainmis shinankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ana jatu yuikin: —Tsuada ja akin chitekin unanti wayamaxankanwen. Man jatu jaska wamaken Diosundi jabiaskadi wakin matu chitekin ja akamadi ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jamen jatuwen nuiama chitekin man jatu ja amisken jabiaskadi wakin Diosun ja man janchai ja imiswen Diosun matu ja akin chitediaxanikiki. Ja inun, jabias shinanwendi min jatu unanti wamiswen Diosun matudi unanti waxanikiki, kaneamadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jaskakin ikunwain betsa pewakin medabewanun, iwanan, jawen jamapai tude jawen beduki jikia min bikatsis ikaidan, mina anu ja dukun ja ji ewapa min jaya min shinanmamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ji jidabiwen betimanabia jawa shinanma yuikin: “Jani min ji pese beduki ikadan, ¿mia bipa?” akin kanekin man yuimiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jakia bemakis bepadamei janchamisbuun, matudi chakabubia betsan chakabuai uinkin man ja amiski. Man ji jidabi betimanabia tsekaxun puta keska watan matun juinti medanua matun chakabu ewapa putatan ana kaneama medabenankin ji pese min jaibun bedu anua bia keska wakin juni betsan chakabu bexmas jayadi medabewakin man yusintiduki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Jaska inun, jawada pepa Diosuna kaman puben man inantidumaki, jawen unanti watan matu keyutiduwen taexunan. Jabiaskadi wakin ina yawa puben man mabu pepa inantidumadiki, chakabuwakin jau matu pema pema akanyamanunan. Jabiaskadi wakin tsuabunda Diosun jancha dananjaidamistun jau matu deteyamanunbun jatu ana yusinyamakubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","ana jatu yuikin: —Jaska inun, betsadan, tsuanda Dios yukakin ea akadan, jawen jawada inanmiski. Tsuanda jawada benakin Dios yukadan, jaki nukumamiski. Tsuanda jawada bi jikinun ixun Dios kenadan, bepenxunmiski. Jaskaken shinanchakama Dios ea akadan, betsaki. Jawada min yuka mia axuntiduki. Benakin jawada min yuka mia bechimaxanikiki. Jawada bi jabe janchanun ixun min kena mia bepenxunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Ja inun, matun baken misi matu ea aka jaki dakekin mishki man inainsmaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ja inun, baka matu ea aka jaki dakekin dunu man inainsmadiki, jatuwen nuikinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jaskaken matun shinan pepamabia matun bakebu man duawamis man unaiin. Jamen tsuanda Epa Dios nai anua ea akin man yukadan, jawada pepa yaushiama matu inantidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jaska inun, betsadan, tsuada miwen nuikin jau mia medabewaxanunbun matun dukun jaska shinankin uinmakin jatu medabewakubainxankanwen, jaska wai nuikipakin man kaneamakidan. Jabias shinanwen Diosun jancha yuixunikabubetan Moisin jatu yusinidan, jaki dasi watan na jabias yununi jakimama shinain man jatube medabenankunkainxanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","ana jatu yuikin: —Chi nukaismakidi kaidan, janu jikiti xui inun jawen kati bai jaxpa keska jawen kai bikamawen taea yushin chakabun bai bechipai yudan kaian ichapa jawen bumisbuki. Jamen jiwekuiankidi kaidan, janu jikiti xui inun jawen kati bai jashu bika keskawen taea ja bai benakubaini atimas nukutan yuda eskadabes jawen bumisbuki. Matudan, ja bai jashuki nukutan jawen bukin ea chibankubainkanwen— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Ja inun, betsadan, ja padanananmisbu pepa keskakin Dioskidi yusinbiakin jawen juinti inu puben keskan chani jancha matu yusiainbu ana ninkama jatu uindakubainkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nishi muxaya anua uva bimi man tsekaismaki. Ja inun, isne muxa anua higuera bimi batapa man tsekaismadiki. Jabiaskadi wakin jaskai jiwemisbu pepaibu inun chakabuaibu uinkin ja padanananmisbu man unanxanaii, jaskai jiwemisbu uinkinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ja inun, ji pepa bimiai chakabu ikama pepa bestimiski. Jamen ji chakabu bimiai pepamadi chakabu besti idiamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Janua ji bimiuma tibi dedatan kuamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jaskaken jadatuda bimi chakabu jaya keskatun tsuabuda yusin pewakin jatu medabewabuma unantan danankin jatu ninkayamakubainxankanwen— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Ja inun, tsuabunda jatun kexa bestiwen ea kenakin: “Xanen Ibuun, Xanen Ibuun”, ea wabiakin jaska shinainsbumadan, jabun en Epan jancha chibanma nai anu nukube jiweama ixankanikiki. Jakia en Epa nai anuatun jawada yununi inun bechipaiai chibankin akubainmisbu besti nukube jiwexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na jaska en matu yuiai keska enabu kayabi jatu ichawanun ika en ana juaya ichapabun ea yuikin: “Xanen Ibuun, Xanen Ibuun, mikidi yusinkubainkin min kena kushipawen yuikin yushin chakabu nichinkin dami atimaska betsa betsapa nun mia axunkubainmiski. Nukudi katudiwe”, ea akaibu ");
INSERT INTO cbsNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","jatu yuikin: “Padananain chani chakakin man chakabuwamiski. Man enabumaki. Tudi budikanwen”, en jatu waxanaii— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jakia jabun en jancha ninkakin akubainxanaibukidi miyuiwen matu yusinun ninkakanwen. Tsuanda jiwe wakatsi ikin mai basanbainkin uke medan mishkiki pesaxun jaki mishki tsamabidankin jiwe waimaken ");
INSERT INTO cbsNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","janua ui ika bai matajaidabidankin jawen jiwe achia ja jiwe mishkiki tsamianwen taea niwewanen tsibusketiduma keska jawen daya benuama ja juni unanepaki. En jancha ninkamisbu jaska keskaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jamen jawada en yuiai danankin chibainsbumakidi matu yuinun ninkakanwen. Tsuanda jiwe wanun, iwanan, mashi anu basankin kini chai wama bexantu besti watan mishki tsamabidankin jabebis watan jiwe waimaken ");
INSERT INTO cbsNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","janua ui ika bai matajaidakin jawen jiwe achia mishkiki tsamianmawen taea jawaida niwewan bekin tsibuskea di ika keskakin jawen daya benujaidamisbuki. Jaska dayamisbu keska patapabuki, en jancha danainbudan— akin jatu yusinkin jancha meneai ");
INSERT INTO cbsNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","ninkai “Betsabun Diosun jancha nuku yusinmisbu keskamaki. Jakia xanen ibu kushipa keskakin nuku yusinbikain!”, iki Jesúsun jatu yuiai ninkai e iake iakenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Janua Jesúsun jatu jancha wakin menetan mati anua butukidanaya yudan kaianen chibanbidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","juni yudaki chamini jabias baiwen Jesús juaiki nukutan ja bebun danti ixun yuikin: —Yusinaan, ea kayawakatsis ikin min ea kayawatiduki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","jawen chamiwen mesekin danankin tsuan mekatsi ismabiaken Jesús jawen dabanan ikin mexunkain mekin yuikin: —En mia xuxawakin kayawaii— akaya jawen chami sakada iki daxnukui keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesúsun nemakin yuikin: —En mia yuiai ninkaidawe. Jawada en mia axukidi tsua yuiyamayukubaintanwen. Ja dukunan, Diosbe nukunabu janchaxunika anu min yuda min ma kayaxu jatu uinmatanwen. Jaska min ma kayaxu jau jabun mikidi unanunbun jabiaskadi inankuin Moisin yununi jatu anu buditanwen. Min jaska buaya min ma kayaxu jabun mia unanxankanikiki— abainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Janua Jesús Cafarnaúm mae anu jikiaya ea anun, iwanan, romano capitán Jesúski nukuxun ");
INSERT INTO cbsNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","yuikin: —Yusinaan, en dayadu isin tene chakayamai ma babua ana benitiduma nuitapajaidaikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesúsun yuikin: —Jaskakenan, en mia xuxawaxuin katiduki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ana capitánen shinantan yuikin: —Yusinaan, min ea binua en jawamaki. En jiwe anu kama min kushipa besti yunuwe, jau en dayadu ea xuxaxununan. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ja inun, jatun ea yunumisdan, en xanen ibu jayaki. Eandi soldadobu yunui en xanen ibumiski. Betsa yunukin: “Kawe”, en wa kamiski. Betsa yuikin: “Juwe”, en wa jumiski. En dayadudi yunukin: “Ea axunwen”, en wa amiski— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesúsun ninkai e itan ja jachun beaibu jatu yuikin: —Na jaska nawa capitánen ea ikunjaidawai nukunabu Israelbun ikunwainbu jaska keska en jatuki nukudiamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eanan, chanima en matu yuiaii. Dios xanen ibukin mai jidabi anua badi juaikidia inun badi jikiaikidia ikunwainbu dasibibu jatu ichawatan duawakin Abraham inun Isaac inun Jacobetan jatu pimaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jakia nukunabu Diosun yubabiani jawen jancha chibankin ikunwanbumaken jatu danantan janua kaxai xeta yenx yenx imisbu meshujaida medan jatu udenxanikiki— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesús nasaukekauan capitán yuikin: —Jaska min ea ikunwainwen taexun en mia axunxuki. Min jiwe anu kadiwe— akaya jabiatiandi jawen jiwe anua jawen dayadu xuxanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Janua jawen jiwe anu Simón Pedron Jesús iyua kai jikitan jabianudi jawen dais ainbu yuna daka uintushikin ");
INSERT INTO cbsNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús jawen nuikin metsunxun yuna xuxawa benikidan duawakin bawaxun jatu pimaya ");
INSERT INTO cbsNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","janua ma badi kai meshuaya ja mae anu jiwea akeakeabun yushin chakabu jayabu inun isin betsa betsapa teneaibu Jesús anu iweabu yushin chakabu kainmakin isin teneaibu dasibi xuxawanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Diosun jancha yuixunika Isaíasin yuikin: “Diosun Katuatun nun isin teneai mainwankin nuku xuxawaxanikiki”, akin jatu bebunkidi yuini Jesúsun jabiaskadi wakin jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Xaba betsatian januxun dasibi jatu xuxawashina tsaubaunxun daketapawaibu uinkin jawen tsumabu Jesúsun yuikin: —Ian kexa betsaudi juindukuin nun bununbun matun xaxu pewakanwen— jatu wa pewaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Diosun jancha kenenibu yusinananmis betsa juxun Jesús yuikin: —Yusinaan, janida min kai anu en mia chibankatsis ikaii. ¿Mibe kapa?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","jawen shinan unanun, iwanan, Jesúsun yuikin: —Kaman inu jawen kini jayaki. Peiyabu jawen na jayabuki. Jakia matun Juchi Kayabi Iyua ean en jatu yusinkubaunai janu uxati jiwe en jayamaki. ¿En ikai keskai min idiatidumen?— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","jaki chiti ika betsandi Jesús yuikin: —Xanen Ibuun, ea jeneyuwe, ja dukun en epa mawa maiwatan en mia chipu chibanxanaidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","nemakin Jesúsun yuikin: —Jaskamaki. Jabun ea chibanbuma mawa keskabun min epa mawa mia maiwaxuntidubuki. Jakia mianan, na jabiatian tapin ebe kawe— abaini ");
INSERT INTO cbsNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","janua jawen tsumabube xaxun inatan tu abaini kaya ");
INSERT INTO cbsNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ianenwan besusi pukeaibun Jesús ma bika xaxu chixukidi daka uxaken janua niwe kushipajaida bekin jene buspu tsaubidankin xaxu jene matawa ma jiki kemaya ");
INSERT INTO cbsNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","datei Jesús anus ichaxun datekin bestenwankin yuikin: —Yusinaan, yusinaan, menan nuku medabewadiwe, jiki nun jasatidukidan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","bestentan jatu yuikin: —¿Jaskai man dateai? ¿Man ea ikun kayabiwadiamamen?— itan benikauan niwewan inun ianenwan buspu tsaubidanai nemakin: —Nesewe. Peswe— aka niwe main neseaya ianenwandi bechuduni maianyan ");
INSERT INTO cbsNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","e itan jawen tsumabu yuinamekin: —Na junidan, ¿jawa junimen? min atidumakidan. Niwe inun ianenwanendi ninkaikikidan— ibaini bui ");
INSERT INTO cbsNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","janua kai ianenwan kexa betsaudi mai pakea Gadara anu keti itan Jesús bututan mapekekainaya janua juni dabe yushin chakabu jayabu janu mawabu maiwamisbu anu besti jiwea pubenjaidaken jatuwen datei tsuan dunkebainsma maiwati anua kainbidani Jesúski nukuaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","yushin chakabun jatu bis imakin yuimakin: —Jesúsuun, min Diosun bake nun unaiin. Nukudan, ¿min nuku jaska wai? Janu kupiaitian idiamabiaken ¿unanti wakin min nuku kupi juai?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ja mati anuxun ina yawa ichapabun pikin mai mixexaibu ");
INSERT INTO cbsNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","yushin chakabun uintan Jesús yukakin: —Min nuku kainmakin nichiainan, ua ina yawa anu nuku nichinwen, ja medan nun jikinunan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesúsun jatu yuikin: —Peki. Jadi butankanwen— jatu wa ja juni dabe anua yushin chakabubu kainbaini ina yawa medan jikibainaibun ja ina yawa datei mawa keyatapa butei nidi ibaini ianki pukui keyutan jasai keyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","jaskai uintan ja ina yawa mekenikabu datei kushibaini mae anu buxun juni dabe yushin chakabu jayabu jaskaxu jatuki chania akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","janua ja mae anua yuda ichapa kainbidan jaskaxu uinun ika Jesús anu bexun ina yawa jasai keyukanxu uintan datekin Jesús nichinkin yuikin: —Nukun mae anua kadiwe— anibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jaska wabu jawen tsumabube Jesús xaxun nanetan ana chintunkaini ianenwan pukebaini jawen mae Cafarnaúm anu jiki keti ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ma ana Jesús jua ninkatan juni yuda babuni jawen dakatiki daka jawen jaibuaibun bakebidan datantan: “Jesúsun xuxawatiduki”, iwanan, shinainbun ikunwainbu Jesúsun unankin juni yuda babuni yuikin: —Dateyamawe. Min chakabuwen Diosun mia kupikatsis ibiakin man ea ikunwainwen taexun jau ana shinanyamanun en mia buaxunaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Diosun jancha kenenibu yusinananmisbun ninkatan Jesúski sinatai yuinamei: “Ja juni chakabuki. Nuku padain Dios keskakatsis ikikiki. Diosun besti jawen chakabu buatiduki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tsuan Jesús yuiamabia jatun shinan unankin Jesúsun jatu yukakin: —Matunan, ¿jaskakin man shinan chakai ikai? ");
INSERT INTO cbsNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jadatu bikamamen, jawen chakabu buaxunadaka, jawen yuda beniadaka? ");
INSERT INTO cbsNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja dabe bikaken Diosun besti atiduwen taexun ¿jaskakin man shinanchakai? En matun Juchi Kayabi Iyua na mai anua ea en jawen kushipa jayatun jawen chakabu en buaxuntidu man unanun en akai uinkanwen— iwanan, juni yuda babuni kaya wakin yuikin: —Benitan min dakati iabaini min jiwe anu kadiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","jawaida yuda damesteni kayatan benikauan jawen dakati bitan iabainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mapubaunxun uin datekin yuikin: —Jabaa! tsuan jaska waismaki. Jakia Dios pepajaidatun na juni ma kayawaxuki— iwanan, uinkin Dios kenwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Janua kainkaini januxun Roma gobierno pei bixunti jiwe anu en Mateo tsaua Jesúsun ea bechitan yuikin: —En mia tapinmai: “Ea chibankubainwen”, ea wa benitan dasibi jene keyubain chiban taewabain ");
INSERT INTO cbsNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","en jiwe anu iyuxun jatu pimanun, iwanan, Roma pei bixunmisbu inun Diosun jancha kenenibu yusinananmisbu jatu ninkaisbuma en jaibuaibu ichawaxun Jesúsbetan nun piaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","fariseobun uinkin Jesúsun tsumabu yukakin: —¿Jaskakin matun yusinan pei bixunmisbu chakabubu inun nukun jancha ninkaisbumabetan pimenkain? Chakabuki— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesúsun ninkatan jatu chitekin yuikin: —“En peki”, iwanan, shinainbu anu juni dauya kaismaki. Jakia isin teneaibu anu besti juni dauya kenabu kamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Diosun Oseas yuinidan, ¿man uindiamamen? Matu yuinun ninkaidakanwen: ‘Ea benimawanun ixun chaxuwan kuakin menu keyuaiwen besti akama yudabuwen nuikin jau ea benimawakubainunbunwen’, aka ninkatan Oseasin keneniki. Jaskaken “En chakabuki”, iwanan, shinainbu jatun juinti pewakin en jatu medabewa shinan betsa watan jau Dios ikunwanunbun en juniki, juni dauya keskaidan. Jakia “En chakabumaki”, ikin shinainbu jatu medabewatanun ika en juamaki— jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Janunkain xaba betsatian Nashimanika Juanki chiti ikabu Jesús anu bexun yukakin: —Nuku inun fariseobuki chiti ikabu nukun chakabuwen taea nukunmebi ichakanikai samakei nun piama uxayumiski. ¿Jaskai miki chiti ikabu samakeisbumamen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesúsun jatu yuikin: —Juni ainyain nawaibu anu jawen jaibuaibu paxkadiama manunamei jatunmebi piama ichakanikatidubumaki. Jakia jatu xunubaini kaken manui jawen jaibuaibu samakei piama ipaketidubuki. Ea iyuabun jabiaskadiai ewen nui en jaibuaibun piama idiaxankanikiki— iwanan, ana jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—En yusianan, tadi bena chukadiama keskaki. Matu yusinun ninkakanwen. Tadi xeni baxnekea tadi bena tuax chukadiamawen tadi xeni tsamian patsa estei ana baxnekemiski. Jamen matun yusianan, tadi xeni baxnekea keskaki. En yusianwen tsamian keska wakin matun yusian en pewatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ana jabiaskadi keskawen matu yusinun ninkakanwen. Bichi bishtu xeniki uva jene bena buspudiama manekin mata waxun denex mestenwan jamebi katsai buspui bichi bishtu xeni pexemiski, vino bena inun bichi xeni benuidan. Jabiaskadi wakin en yusian bena matun shinan xeni en jusitidumaki, benukinan— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","janua janchai menediamaken judio xanen ibu betsa Jesús bechibidani juxun ja bebun danti ixun yuikin: —En ainbu bake mawakatsis ikikiki. Ebe kaxun uinkin jau xuxanun ea mexuniyuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús benitan kaya nun jawen tsumabudi nun jabe buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","janua ainbu jimi baxneni ja isin tenei ma 12 año kabia jawa neseisma badi betsa tukama ikunkainmis nuitapakin Jesús chibankin shinankin: “Jawen tadi kexa besti mea en xuxatiduki”, iki Jesúsun pechiudi chibanbaini kakin jawen tadi kexa besti metsa jawaida jawen jimi maianyan ");
INSERT INTO cbsNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús niti itan nasaukekaun uinkin ja ainbu yuikin: —Ainbuun, min ea ikunwanyan en mia xuxawaxuki. Ana isin teneama unanuma kai pediwe— aka jabiatiandi ana jimi ikama kaya ");
INSERT INTO cbsNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","jaska wabaini buaibun judio xanen ibun jiwe anu icha yudan kaian kaxai sain iki biski ikaibun jikikainkin jatiditun tepe dewe mawaibu Jesúsun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","jatu yuikin: —¿Jaskai eiskaun kaxai man biski ikanai? Jawen bakedan, mawa kayabiamaki. Uxa bestia ikikiki. Unu taxniyukanwen— jatu waya: “Jawen yuda ma mawaki”, ixun ichapabun Jesús uinkin usainbu ");
INSERT INTO cbsNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","jatu nichian buaibun janu ainbu dakanu Jesús jikikain chipash metsuan ana jiwei benikaunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Januxun ja maewan anuxun Jesúsun jaska washina dasibibu chaniaibu ninka keyunibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Janua xanen ibu Jairon jiwe anua kainkainaya juni bekun dabetan chibankin jancha kushipawen yuikin: —Davidin babaan, nukuwen nuiwe— akubainabu ");
INSERT INTO cbsNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","janua Jesús jiwe betsa medan jikiaya juni bekun dabe jaki nukuabu Jesúsun jatu yukakin: —En matu xuxawatidudan, ¿man ea ikunwain?— jatu wa —Jaa. Xanen ibuun, nun mia ikunwaiin— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","januxun Jesúsun jatu bemepitan yuikin: —Jaska shinankin man ea ikunwainan, man xuxaii— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","jawaida bepexetan uiainbun Jesúsun jatu nema chakayamakin yuikin: —En matu jaska waxudan, tsua yuiyama mapuyukanwen— jatu wabia ");
INSERT INTO cbsNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","buxun jaska Jesúsun jatu xuxawaxu dasibi jatuki chanibaunkin kakapa waibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","jabiatiandi juni juyu yushin chakabu jaya Jesús anu juni betsabun iweaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús jawen nuikin yushin chakabu kainma kaya janchai taeaya ja dapi mapubidankin uin e itan yuikin: —Israelbun jaska nun uiain keska tsuan aismaki. Ja juni pejaidaki— akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","jatun jancha bechipaiama fariseobun jatu yuikin: —Na junidan, yushin chakabu xanen ibun kushipa jayaki. Jaska bestiwen taexun yushin chakabu jatu kainmaikiki— ikea iakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","janua jatu jaska wabaini kakin Galilea anu mae ewapabu inun mae jatiubuma anuxun jatun ichati jiwe anuxun yusinkin Dios xanen ibuaikidi kakape yusinkin isin betsa betsapa teneaibu xuxawakubaunkin ");
INSERT INTO cbsNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","yudan kaian uin jatuwen nuijaidakin jabu chaxuwan uinikauma keskabuwen taea jatuwen dabanan ikin ");
INSERT INTO cbsNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","nun jawen tsumabu nuku yuikin: —En tsumabun en jancha ikunwankin chibanmisbun jatu yusian akeakebaunaibun ichapabun ea ikunwanxankanikiki. Jaskaken chanima Diosun bai anu miban midima ma jushin keyui keska dakaki. Jakia jawen dayakapabu eskadabeswen taexun ana dayakapabu ichapa jau yununun bai ibu Dios ana yukakanwen, jawen yunu tsekakin ichawaxunai keska wakin yudabu jau jawen jancha jatu yusinbaunxanunbunan— nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Januxun nun jawen 12 tsumabu Jesúsun nuku ichawaxun jawen yushin chakabu kainmati kushipa inun jawen isin betsa betsapa teneaibu xuxawati kushipa nuku yununiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nun jawen 12 kushipayabun nukun kenadan: Simón jawen kena betsa Pedro inun, jawen betsa Andrés inun, Zebedeon bake dabe Santiago inun, jawen betsa Juan inun, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe inun, Bartolomé inun, Tomás inun, nawan pei bixunika Mateo ea inun, Alfeon bake Santiago inun, Tadeo inun, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón betsan nawabu bechipaisma inun, Judas Iscariote jatun Jesús jatu chipu achimaxanai nun jati inibuki, Jesúsun tsuma kushipayabudan. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nuku jaska watan januxun nun jawen 12 tsuma kushipayabu Jesúsun nichinkin nuku yuikin: —Nawabun mae anu buama inun Samaria mai pakea janu jiweabu anudi buyuama ");
INSERT INTO cbsNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","jakia Israelbu chaxuwan benua keskabu anu besti buxun ");
INSERT INTO cbsNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","jatu yuikin: “Diosun Katua xanen ibui ma kemaikiki”, akin jatu yusinkubauntankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jaska wakin isin teneaibu xuxawakin mawabu bestenwankin yudaki chaminibu kayawakin yushin chakabu jayabu kainmakin akubauntankanwen. Na kushipa jawa pakama man bixuwen taea jabiaskadi wakin jabias kushipawen jatu medabewakin jawen jatun jamapai jatu yukayamakubauntankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kaidan, man eskabaintanunbun matu yuinun ninkakanwen. Mais butankanwen, jawa buamadan. Oro pei jexe inun, plata pei jexe inun, cobre pei jexe buama, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kapankan buama sanpu betsa buama, matun bichi tae betsa buama, jawen mestenti betsa buyamatankanwen. Jakia man jaskakainaya dayakapabu pimamisbu keska wakin matu pimadiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Janua mae betsa anu jikitan juni duapa yukai ikii jaki nukutan jawen jiwe anu matu iyua janu kaxun jawen mae anua kadiama ja juni duapatun jiwe anu jiweyuxun jawen mae anuxun yusinyuxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Janua jiwetan jikikainkin eska yuixankanwen: “Unanuma jiwekanwen, Diosun jancha nun matu bexuainan”, jatu waxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Januxun matu beyawaibunan, matun jancha pepa jatu yusinxankanwen. Januxun matu beyawakin Diosun jancha ninkaibu jau Diosun jatu unanuma jiwemakin duawakubainxanun yunuxankanwen. Jakia januxun matu beyawabumakenan, matun jancha pepa jatu anu jamen benuyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ja inun, janixunda matu danankin ninkakatsi ikabumaken jatu unanti wakin janua kainbainkin matun tae anua mai kudu jatuki tabainxankanwen, jau jabiaskasi jiwenunbunan, jawa unanmadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Chanima en matu yuiaii. Janu Diosun yudabu dasibi jatu kupiaitian jaska Sodoma inun Gomorra ja maewan dabe chiwen Diosun jatu kupikin jaska wani binumakin jabun matu dananibu Diosun jatu kupijaidaxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ana nuku yuikin: —Eskawen taexun en matu yuiai ninkaidakanwen. Kaman inu pubenbu anu man en 12 tsumabu chaxuwan pepa nichian keska wakin en matu yunuaii, man en tsumabu ewen taea matuki sinataibu anudan. Jaskawen taea dunu tsuan padantiduma unanepai inun deiwan pepa keskakin tsua sintamayamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Man en kakapekidi jatu yusianwen taexun ikunwanbuman matu kupinun, iwanan, jatun mae xanen ibu anu matu iyuxankanikiki. Ja inun, jatun ichati jiwe anuxun ekidi man jatu yusiainbu betsabun matu kusha kusha axankanikiki. Uindaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jakia en kakape ikunwankin man ea chibainbuwen taexun tsuabunda matu achixun xanen ibu kushipabu anu matu iyuabu en yusiankidi xanen ibu betsa betsapaki inun judiobuma nawa betsabuki ekidi man chanidiaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jakia achixun xanen ibu kushipabu anu matu iyuabu jawada man yuitidukidi Diosun Yushin Pepatun matu unanmaxanikiki. Jaskaken jawa dateama ¿Jadakidi yuixanpa? ikin bebunkidi shinanyamakubainxankanwen, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","matunmebi man janchamaken matun Epa Diosun Yushin Pepatun medabewakin matu janchamaxanikikidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ja inun, yuda betsan janubi jawen betsabun ea ikunwainbu jatu achima akeakediaxankanikiki, jau jatu tenanunbunan. Jabiaskadi wakin jatun ibubun janubi jawen bakebu jatu achimadiaxankanikiki. Ja inun, jabiaskadi wakin bakebu jatun ibubuki sinatakin jatun ibubun ea ikunwainbu jatu achimaxun jatu tenanmadiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ekidi jaska yuibaunkin man ea chibainbuwen taexun yudabun matu danain midima matuki sinataxankanikiki. Tsuabuda matu keskakin ea chibain jeneisbumadi en jatu mekediakubainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jakia mae betsa anuxun matu ichakawaibun janua kainbaini mae betsa anudi kaxun jatu yusinkubaunxankanwen. Israelbun mae tibi anu nati ikin man jatu yusin keyudiamaken chanima matun Juchi Kayabi Iyua en xanen ibui taexanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ja inun, jatun tsumabun jawen yusinan binuntidubumaki. Ja inun, jawen dayadun jawen xanen ibu binuntidumadiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jaskawen taea jawen tsumabudan, jatun yusinan jancha chibain jau jabiaskadi keska ikubainunbunwen. Jabiaskadiai dayadubu jatun xanen ibun yunua ninkai jau jatun xanen ibu keska idiakubainunbunwen. Jaskaken en matun yusinan ea kenakin: “Yushin chakabu xanen ibu Beelzebúki”, ea wamisbuwen taexun en yusian man chibankubainmisbuwen taexun matudi kenakin: “Beelzebún enabuki”, akin matukidi yuikin chitediaxankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ana nuku yuikin: —Jabun matu ichakawaibudan, jawada jabu bepadametan june akubainmisbudan, Diosun dasibi xabakabi jatu uinmaxanaiwen taea jatuki dateyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jakia jawada en matu besti yuiai juneama xabakanxun jatu yuibaunxankanwen. Ja inun, dintu medan jikitan jawen beputi bepua keska watan jamapai june en matu yuimis jemaintin anuxun jancha kushipawen xabakabi jatu yuixankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ja inun, tsuabunda matun yuda besti tenantidubuwen dateyamaxankanwen, tenanxun matu ana ichakawapaketidubumakidan. Jaki besti mesei man datekubainunbun matu yuinun ninkakanwen. Tsuanda matun yushin tenantan chi nukaismanu jawen kushipawen matu yunutidu bestiki mesei datekubainkanwen, Dioskidan. Chanima en matu yuiaidan, ja bestiki datei mesekubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jaska inun, isa mishtin dabe pei jexe bestichaiwen bitidubuki, kadumadan. Jaska wabiamisbun isa tibi tanai Dios jakimaismaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Jamen matun bu dasibi midimabiaken Diosun ma tana keyumistun isa mishtin ichapa bechipaibiakin Diosun isa mishtin binumakin matu bechipaijaidamiski. Jaskaken jawaki dateyamakubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ana nuku yuikin: —Tsuabunda ea ikunwain dakeama ea datan akin yudabu jatu yuikin: “En Jesúsunaki”, iki eki janchakubainmisbu en Epa Dios nai anube janchakin: “Jadan, enabuki”, akin en jatu yuixunxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jakia tsuabunda ea chibanma en janchaki dakei: “En Jesús ikunwanmaki”, iki eki janchakubainmisbudan, eadi en Epa nai anuabe janchai: “Nadan, enabumaki”, akin en jatu janchaxunamadi ixanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ana nuku yusinkin: —Mai anuxun yudabu unanuma jiwemanun ika en juni dabanen ¿man shinainmenkain? Jaskamaki. Jatu paxkatan jatu bika tenemanun ika en juniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","En jatu jaska waya juni bake jawen epabe sinatadabexankanikiki. Ja inun, ainbu bake jawen ewabe sinatadabediaxankanikiki. Ja inun, jawen babawan jawen yayabe jabiaskadiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ewen taea jawenabube dananain sinatanamexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","38","Jawen ibubu inun jawen bakebu bechipaijaidakin ea bechipai bexmas wamisdan, enabumaki. Ja inun, tsuabunda ea chibankatsi iki bika tenei eki jawa dakeama: “En jabe mawakatsi ikaii”, ikin yuiabumadan, jabu enabumadiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jamen tsuabunda jatunmebi mekei: “En mawakatsi ikamaki”, ikin shinanmisbudan, eauma mawaxankanikiki. Jakia ea ikunwankin en kakape yuikin ea chibainwen taexun tenanbu ebe jiwekuinxankanikikii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ana nuku yuikin: —Jaska inun, en matu nichian man kaken tsuanda matun jancha ninkakin matu beya wakin eadi beya wakin jaibu waxankanikiki. Tsuabunda ea jaibu wakin jatun ea yununidi jaibu wadiaxankanikiki, jawen jancha ninkakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Diosun jancha yuixunikatun yuiai jawen jancha ninkakin beya wanixun jabun Diosun jancha akaibun manakuti pepa bixankanikiki. Diosun jancha ikunwankin juni pepa beya wanixun juni pepan manakuti pepadi bixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ja inun, eki chiti iki bexmasbiabun jatu unpax matsipa yukabu ea chibanmisbuwen taexun jatuwen nuikin unpax jatu amakubainmisbu chanima jawen kupiti pepa bixankanikiki— nuku aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Januxun nun jawen 12 tsuma kushipayabu yusin menetan Jesúsun nuku nichian nun kaya mae betsa betsapa anuadi jabia dapikeadi jatu yusindiakubaunaya ");
INSERT INTO cbsNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Nashimanika Juan bichiti jiwe anu bichimabu jiwexun jaska Jesucriston akubainaikidi banabimatantanabu Juanen ninkatan jawen tsuma jatida kenaxun yunukin: —Jesús anu buxun: “Mekenika Cristo Diosun nukun xenipabu yubani ja juxanaidan, ¿min jabiamen? ¿Betsa daka nun manai?” akin ea yukaxuntankanwen— jatu wa buxun yukabu ");
INSERT INTO cbsNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesúsun jatu yuikin: —Jawada uinkin man ninkakubainaidan, jaska Juanki chaniditankanwen, eskaibukididan. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bekun inun bexuxbun uiainbu inun, jaska mapuisbuma mapuaibu inun, jabu bichiki dasibi chami betsaniki dakemisbu main sakada iki keyuaibu inun, patabun ninkakin keyuaibu inun, mawa ana besteainbu inun, jabu nuitapaibun jatun paxati kakape ninkatan benimaibudan, jaska Juan yuitankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tsuanda ea ikunwain jawa jawen shinan chakabui chintuinsmadan, chanima benimaxankanikiki!— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan anu buaibun ja dapi mapubaunabu Jesúsun Juankidi jatu yui taewakin: —Janu tsua jiweabuma anuadan, ¿jawa man uintantanimamen? Tawa pei niwen bubi bubi wai keska wakin ¿junin jawen shinan betsa betsapa maewa akeakeimamenkain? ");
INSERT INTO cbsNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Jaskamen? ¿Jaskamadaka? ¿Jaskada jakidi kaiain man uintantanimamen? ¿Junin tadi pepa sawea daka? Tadi pepa sawea mabu akunjaidayabu jatun xanen ibun jiwe jawendua anu besti jiwea ikaibu man uintiduki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jaskakenan, ¿jawa man uintantanimamen? ¿Diosun jancha yuixunikamenkain? Jaki. Juanan, chanima Diosun jancha yuixunikaki. Ja inun, yuixunika betsabu Diosun yununi Juanen ma jatu binuaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ja inun, Diosun jawen bake nichinkatsi Juankidi yuikin: ‘Ninkawe. Janu min kaxanun jau pewai kanun en jancha yuixunika betsa bebunkidi en yunuxanaii, en mia nichindiamadan’, akin jakidi jawen kaka kenenibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Chanima en matu yuiaii. Yuda dasibibun Dios dayaxunkin tsuan Juan binuama ibianibun janu Epa Dios xanen ibuaitian ikunwainbu jaki dasiabu bexmasjaidabiabun Juan binuxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Nashimanika Juan judiama matun ichati jiwe tibi anuxun Moisin yusian inun Diosun jancha yuixunikabun yusinpauni matu yusin bestikubainimabuki. Jakia Juan juxun Dios xanen ibuxanaikidi bebunkidi jawen kaka pepa yusinkubainaya juni pubenen detekatsis ikin Dios xanen ibuxanai ewamamakin bextenun ika ikanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","15","Man pabinkiyabuki. Ninkatan jakimayamaxankanwen. Diosun jancha yuixunika Elías jau ana juxanun Diosun yubani Juanan, jabiaki. Man ikunwankatsi ikaidan, jawen jancha ikunwankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Nukunabu na jabiatian jiweabunan, ¿jaskada shinankanimenkain? Matu yuinun ninkakanwen. Mae namakis jemaintin anu beyuskin jatun ibubu imis mawai bake mishtinbu xuku dabea tsauxun xuku betsan yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tepe dewe nun mawabiaya benimai man nawamaki. Janua nun kaxei ikaskin nun nuiti nawa mawabiaya man kaxamadiki”, jatu wabu jawawenda beyusti unanbuma keskabuki, nukunabudan. Matun shinan chankanti jubiaken man benimamaki. Jamen matun chakabu shinain kaxakatsi ikama man shinan betsa waismaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jabiaskadiai ja dukun Nashimanika Juan juxun matu yusinkubainkin misi pepa piama vino paepa akama matube beyusamaken jakidi janchakin: “Yushin chakabu jayaki”, iwanan, man yuia akeakeimaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Janua eadi matun Juchi Kayabi Iyua juxun misi pepa pikin vino paepa aki en matube nawabiakunkainaya ea yuankin: “Uinwen. Pikeki. Paenkin romano pei bixunika chakabubu inun yuda chakabu betsabu jaibu wamiski”, ikin man eadi yuanmiski. Jamen nuku dabe nun pepabiaken Diosunabu kayabibu besti unanepakin jabun nukun yusian ninkatan nuku chibankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Januxun Jesúsun jatu yusinkin taewaimanu mae betsa betsapa anuxun yudabu uinmakin dami atimaska jatu waxunbia jawa jatun shinan betsa wama ikimabukidi yudan kaian Jesúsun jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Corazín inun Betsaida anu man jiweabu matun chakabu jenetan man shinan betsa wakatsi ikamadan, man nuitapajaidaxankanaii. Jakia Corazín inun Betsaida anuxun jawen unanti dami kushipa betsa betsapa en matu uinmakubainima keska Tiro inun Sidón anu jiweabundi jabiaskadi uintan jatun chakabu jenenun, iwanan, juinti nishmajaidatan saku wati tadi bexa xeni sawetan chi mapuwen mapu tukutan jatun shinan betsa watan Dios ikunwankeanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jaskawen taexun janu kupiaitian ja nawabu Tiro inun Sidón anu jiweabu jatu kupi midinkin Corazín inun Betsaida anu jiweabudi shinan betsa wabuma Diosun jatu kupijaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ja inun, Cafarnaúm anu jiweabun man shinankin: “Nun pepabuwen taexun Diosun nuku kenwanxanikiki”, ibiakin man ea ikunwanbumawen taexun janu chi nukaisma anu Diosun matu yunuxanikiki. Jakia Cafarnaúm anuxun jawen unanti dami kushipa betsa betsapa en matu uinmakubainima keska Sodoma anu jiweabutiandi jaskadi uintan jatun chakabu jenenibunan, jatun bababudi nuku dapi jiwekeankanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jaskawen taexun janu kupiaitian ja nawabu Sodoma anu jiwenibu jatu kupi midinkin Cafarnaúm anu jiweabu shinan betsa wabuma Diosun jatu kupijaidaxanikiki, jaska Sodoma ani keska binumakinan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","janua Jesús shinan chankain benimakin yuikin: —Epaan, nai inun mai jidabi minaski. Min duapa jancha ja unanepai kenmisbu min jatu unanmama jabu keinsbuma besti min jatu unanmakubainaiwen taexun en mia kenwaiin— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","—Epaan, chanima jaska wakatsi mekenixun min ma jatu unanmaii— itan yuda betsabu mapuxun ninkaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesúsun jatu yuikin: —En Epan jawen kushipa dasibi ea yununidan, tsuan en jawen bake ea unanbumaki. Jakia en Epan besti ea unan keyuikiki. Jakia tsuan en Epa unanmadiki. Ea jawen baken besti en Epa en unan keyudiaii. Jakia jabun ea chibainbu en Epa en jatu unanmamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tsuabunda xankama ia inun daya chakayamai keskai man punu nukabudan, en matu juindukunmakin medabewanun ea anu bekanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ja inun, ina awa dabeki ji tekixkunxun jawada xankama bumabu bika dayabiai medabenain punu nukaisbumaki. Jabiaskadiai eadan, duapakin matu medabewakin ina awa ji tekixkundabea medabenanmisbu keskai man ea chibanyan en kushipawen en matu medabewakubainxanaii, man bika tenebiaya matu juindukunmakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Janua ebe ji tekixkundabea keskaxun jawada bikajaida ana tenejaidama ebe medabenain nun xankapa aka wabaintidubuki— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jatianda ana juindukunti sábado betsatian xekiwan bai namakis manan baiwen nun jawen tsumabu Jesúsbe bukin xekiwan bimi tsekaxun dashukidi axun bunikin nun pikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","fariseobun nuku chibankin uinkin Jesús ja akin: —Uinwen. Juindukunti sábadotian dayakin Diosun Moisés nuku nemani min tsumabun kanekanikiki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesúsun jatu kemakin: —Bunikin jawada nukun xenipabu pepa Davidin jawen jaibuaibubetan anidan, ¿man uinsmamen? Matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dios kenwanti tadi jiwe medan David jikixun Diosun Moisés yusiniwen taexun Diosbe nukunabu janchaxunikabun besti pitibiaken jawen Dios kenwanti misi Davidin bixun pitan jawen jaibuaibudi pimadianiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ja inun, Diosbe nukunabu janchaxunikabu juindukunti tibi Dios kenwanti Templo anu dayakubainkin kaneabumakidi Diosun Moisés kenetimani ¿man shinanmamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","8","Jamen en kushipawen Templo en binuaiwen taexun juindukuntitian jaska jau akubainunbun jawen yunuti inun jawen nemati en jatu yunudiatiduki. En matun Juchi Kayabi Iyua jaska kushipa en jayaki. Diosun jancha yuixunika Oseas Diosun yuimakin: “Yuda betsabuwen nuikanwen, ea kenwankin chaxuwan kuakin menuai bestiwenmadan”, aka jatu kenexuniki. Matun juinti medan na jancha shinankin na junibun kaneabuma unankin man jawa yuiama ikeanxuki— jatu abainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jabias juindukunti sábadotian jabia baiwen kai mae betsa anu jikitan jatun ichati jiwe medan jikixun Jesúsun jatu yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","jabianudi juni meken meyushki jatube icha tsauken jawen yusian danankin fariseobun Jesús yuanun, iwanan, yukakin: —Juindukuntitianan, Moisin nuku kenexuni chibankinan, ¿juni isin teneai xuxawatimen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesúsun jatu kemakin: —Matunan, juindukuntitianbiaken matun chaxuwan unpax biti kini medan kauani pukua jawaida kain nexekin man dayadiamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Juindukuntitian matun inawen nuikin man medabewabiamisken Diosun matu binumakin yudabuwen nuijaidakin jabiatiandi jatu medabewamiski. Jaskaken juindukuntitian tsuanda xuxawai dayabiakin kaneamaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","juni meken meyushki yuikin: —Min meken meshanwen— aka meshanyan jawen meken betsa keskai ma mepekei peaya ");
INSERT INTO cbsNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","jaska waxu fariseobun uin jaki sinatai kainbaini jaska waxun Jesús tenantimen ika yuinamei yubakai taenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Januxun jatun shinan unantan Jesús kainkainaya yudan kaianen chibainbun isin teneaibu ichapa Jesúsun jatu xuxawakin ");
INSERT INTO cbsNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mae betsa betsapa anu jau tsuki chaniyamanunbun jatu nemakubainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jabiaskadi bebunkidi Jesúskidi jawen jancha yuixunika Isaías Diosun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘En tsuma en katunidan, en bechipaiai ea benimawamiski. En Yushin Pepa en yunua medabewaya pepakidi en tsumapan yudabu xukuabu tibi yuibaunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jancha kushipawen juni betsa ja akama mae tibi anuxun jawen jui kunyan ikai ninkabuma ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Chakabu maemakin binudiama yudabuwen nuikin tawa yushtu senkeama keska wakin juinti babubu dananma ixanikiki, bin paji ibubis nukabiai nukama keskadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Januxun chakabu binuaya nawa xukua betsa betsapabun ikunwankin en tsuma manaxankanikiki’, aka ninkatan keneniki. Jaska jakidi keneni menekin Jesúsun yusinkin jatu xuxawakubainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jabianuxundi yushin chakabun juni bexux wakin juyu wani Jesús anu iweabu jawen yushin chakabu nichinkin Jesúsun xuxawa januxun uin pewai janchaya ");
INSERT INTO cbsNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","yudan kaianen uin: —Jabaa! Yuu! Davidin baba mekenika Diosun nukun xenipabu yubani jabiamenkain. Jamadaka— ikeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","jakia fariseobun jatun jancha ninkakin yuikin: —Jaskamaki. Na junidan, yushin chakabu xanen ibu Beelzebún kushipa jayaki. Jaska bestiwen taexun yushin chakabu jatu kainmaikiki— jatu waibun ");
INSERT INTO cbsNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","jatun shinanen kaneaibu unankin Jesúsun jatu yuikin: —Mae betsa anu jatunmebi paxkatan detenamei jatunmebi debui keyumisbuki. Ja inun, yudabu xuku betsa paxkatan jatunmebi debui yamai keyudiatidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jabiaskadi wakin Satanásan jawenabu junibu anua kainma jatun yuda punu nukai babui keyukeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jamen, eanan, Beelzebún kushipawen en yushin chakabu kainmaya ¿tsuan kushipawen matun tsumabun yushin chakabu kainmamisbumen? ");
INSERT INTO cbsNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jamen chanima Diosun kushipawen ean en yushin chakabu kainmamiswen taea Dios xanen ibui matu anu ma juaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Jaska man kanejaidai matu yuinun ninkakanwen. Tsuanda juni kushipatun jiwe anu jikitan yumetsunun, iwanan, jawen tae inun jawen meken dukun neatan jawen mabu yumetsutidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jaskaken tsuabunda ea jaibuwama ea nemamisbuki. Ja inun, tsuabunda yuda betsabu ea chibanmama jau ea ikunwanyamanunbun jatu nemamisbuki, jamakidi shinanmakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jaskaken matu yusinun ninkakanwen. Yudabun chakabu betsa betsapawakin chakabudi yuimisbu Diosun jatun chakabu buaxunkin jakimawatiduki. Jakia matu keskatun tsuabunda jawen Yushin Pepa danankin yuankubainaibudan, jatu buaxuntaskama ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jamen tsuabunda en matun Juchi Kayabi Iyua ea yuanbiaibun Diosun jatun chakabu buaxuntiduki. Jakia tsuabunda Diosun Yushin Pepa yuainbu jatun chakabu Diosun buama shinanunbadikiki, natian inun badi jawen jeneatianan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Ji pepa bimiai jawen bimi chakabuismaki. Jamen ji chakabu bimiai jawen bimi pepaismadiki. Jaskawen taexun jawen bimi tibiwen ji man unanmiski. Eanan, en pe yusinkubainmiswen taexun Satanásan kushipa en jayamaki. Jakia Diosun kushipa en jaya en pepaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jakia matudan, man padanan dunubuaibuki. Matun juinti chakabuken jaska shinankin kainmai janchakin jawada pepa yuiama chakabu besti man yuikubainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jamen tsuabuda duapa juinti pepaya jawa chakabu yuiama jancha pepawens janchamisbuki. Ja inun, yudabu jawen juinti medan shinan chakabu jaya janchakin chakabus yuikin kainmamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Matu yuinun ninkakanwen. Janu unanti waxanaitian: “Jancha jadi yuitimawen min yuipaunidan, jaskakenan ea yui pewawe”, akin yudabu bestibu tibi Diosun jatu yukaxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","fariseobu ana yuikin: —Jamen matun jancha tibi shinankin Diosun matu unanti waxanikiki, “Min pemenkain, min chakabumenkain”, akin Diosun unantan matu kupixanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","jatu jaska wai ninkatan januxun fariseobu inun Diosun jancha kenenibu yusinananmisbun Jesús yuikin: —Yusinaan, nun uinun naiudia jaska tsuan dami atimaska kainmaisma nuku axunwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesúsun jatu kemakin: —Nukunabu na jabiatian jiweabudan, man chakabuki. Jamapai Dios anua unanti tsuan atiduma uinkatsi man ea yukabiamisdan, Diosun Jonás bakawan xeamashina ana kainma jiwenidan, jaska keska besti Diosun matu uinmakin matu axundiaxanikiki. Shinankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nínive anu kaxun jau jatu yusintanun Jonás yunua ninkama jadi kama mae betsa anu paxai kai ianenwan medan pukuabu jasapanan bakawan ewapatun xeashina xaba dabe inun besti meshu jabiatidi kaya mashin mapeketan bakawan janan Jonás besteniki. Eadan, matun Juchi Kayabi Iyua jabiaskadiai mawa mai anu daka xaba dabe inun besti meshu jabiatidi ka en ana bestendiaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jaska inun, Nínive maewan anu jiweabu Jonásin Dioskidi jatu yusian ninkakin jatun shinan betsa wanibuki. Jaskawen taexun janu kupiaitian Nínive anu jiwenibun matu ja axankanikiki. Ja inun, en Jonás binujaidabiaken tsuan man ea ninkakin matun shinan betsa wakatsi ikamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jaska inun, betsadan, nawa ainbu xanen ibu surkidi chaijaida Sabá maiwan anu jiwea nukun xenipabu Salomónen jancha unanepa ninkatanun ika juniki. Salomón en binujaidabiaken man ea ninkakatsi ikabumawen taexun janu matu kupiaitian ja nawa ainbu xanen ibun matu ja achakayamaxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","jatukidi Jesúsun miyui betsawen ana jatu yuikin: —Juni betsa anua yushin chakabu kainma kai juindukunkatsi iki janu unpax jayama anu kakunkaunkin jani juindukunti pepa bechiama shinankin: ");
INSERT INTO cbsNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“En janu jiwea en kainkidanshina anu en ana chintunkainaii”, ikaini kaxun ja yuda medan jiwe xaka matsua keska jawa jayama bechitan ");
INSERT INTO cbsNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","kaxun ana 7 yushin betsa chakabujaida jatube dasikidan, ja dukuntun ja yuda ichakawakin midinwaima ana binumakin pikujaidamisbuki. Jaska keskadiai natian na yudabu jatun shinan pewabumawen taea jiwe chakakubainaibu chipu Diosun jatu kupijaidaxanikiki— akin ");
INSERT INTO cbsNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesúsun jatu yusin menediama janchaya janua jawen ewa inun jawen betsabu bea Jesúski jaska kematima jemaintin mapuxun juni betsan jau yuixuntanun jawen ewan yunua ");
INSERT INTO cbsNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","kaxun Jesús yuikin: —Min ewa inun min betsabun unu jemaintinxun mibe janchanun ixun mia kenakanikiaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesúsun kemakin jatun yui ka yuikin: —¿Tsuamen, en ewa inun en betsabudan?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","nun jawen tsumabu nuku metukin yuikin: —Na jabiabuki, en ewa inun en betsabudan. ");
INSERT INTO cbsNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ja inun, Diosun jancha tsuabunda ninkatan ikunwankin axunmisbudan, jabiabu en betsabu inun en puibu inun en ewabudiki— jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jabias xabatian Jesús jiwetanua kainkaini ianenwan kexa anu ka tsauken ");
INSERT INTO cbsNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","yuda ichapabu Jesús anu bebidan bebidani jaki ichabu jatu yusinun ika xaxun ina tsauxun ian kexa mapustunun mapuabu ");
INSERT INTO cbsNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","jancha junea betsa betsapawen yusinkin jatu yuikin: —Juni betsa jawen bai anu xekiwan jexe sa aki kaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","sa akubaina jexe betsa janu kati bai namaki nidi aka peiyabu bexun keyu xeabun ");
INSERT INTO cbsNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","jexe betsa mishki ewapabu mania anu mai eskadabes bemanchimea anu kauanadan, jawaida pexei benekaunaya ");
INSERT INTO cbsNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","badi jui kukin jawen tapun bemakis bewexekea kua utsi xanamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ja inun, jexe betsa muxa jukundiamanu nidi aka xekiwan beneai muxa jukunkin yabua jaskatan bimitidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jakia jexe betsa mai pepa anu nidi aka benei bimi ichapajaida jayamiski, betsa 100 jexeyaidan, betsadi 60 jexeyaidan, betsa 30 jexeyaidan— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Man pabinkiyabunan, ninkatan jakimayamaxankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","janua nun jawen tsumabu besti Jesúski xukutan jaska miyuiwen jatu yusiain nun yuka ");
INSERT INTO cbsNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","nuku yuikin: —Matudan, jaskai Dios xanen ibumiskidi Diosun jawen pepa juneni xabakabi man en tsumabu matu yusinkin unanmaikiki. Jakia jabudan, en jatu jaska unanmamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jakia tsuabunda en jancha besti ninkakin chibainbu ichapa en ana jatu xabakabi yusinkubainxanaii. Jamen tsuabunda eskadabes ninkabiakin ea chibainsbuma ja eskadabes en jatu mebinxanaii, jakimawakinan— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","—Na yudabun uinbiai uianbumaki. Ninkabiai ninkabumaki, jabu jawaumawen taexun miyui junea bestiwen en jatuki chanikunkainaii— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","—Jaskai buaibuwen taexun bebunkidi jawen jancha yuixunika Isaías jatukidi Diosun yuimakin: ‘Jabun jancha ichapa ninkabiakubainmisbu jawa unanma ixankanikiki. Ichapa uinbiakubainmisbu jawa uinsma keska ixankanikiki. Jau uinyamanunbun jatun bedu bekua keskabuki. Jau ninkayamanunbun jatun pabinki pabepukua keskabuki. Na yudabu buxka kushibun jawa tapinkatsis ikabumaki. Jau en jatu medabewakin xuxawapanan ea danain ea anu bekatsis ikabumaki’, aka ninkatan nuku kenexuniki. Jabias jatukidi keneni keskai na yudabun uianma inun ninka pewabumadiki— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","—Na jaska yuinidan, man matun akaii, matun beduwen uinkin inun matun pabinkiwen ninkai natian man benimaidan. Chanima nukun xenipabu Diosun jancha yuixunikabu inun yudabu pepabun ea uinpaibiakin ea uianma inibuki. Ja inun, na man ea uiainan, ea uinkatsi ibiakin ea uianma inibuki. Ja inun, jabias man ninkaidan, ea ninkapaibiakin ea ninkamadi inibuki— akin ");
INSERT INTO cbsNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Jaskawen taexun jexe sa aka miyuiwen en jatu yusinxudan, matu xabakabi yuinun ninkaidakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jexekidi yuiadan, Dios xanen ibuaikidi yusinti janchaki. Ja jexe janu kati bai anu nidi akadan, yudabun Dioskidi jancha ninkakin shinanbiaibun jamakidia Satanás juxun jawen jancha pepa jatun juinti anua mebinmiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ja inun, jexe betsa mishki ewapabu mania anu mai eskadabes bemanchimea anu nidi akadan, tsuanda Diosun jancha ninkakin taewai benimabiaya ");
INSERT INTO cbsNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","shinan pewamawen taexun jawen jiwepanan Diosun jancha dananmakin jatu bika wakin jawen jamapaiwen jatu ichakawabu tenei jawawen jaskatima ja uintan ana jawendi chintunbainmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jamapai jawen jiweawens kemui jeneama jawens besti nuichakayamakin Diosun jancha ninkabiakin ana tapinkatsi ikama mabuwens besti kemui pepaisbumaki, jaskatun yabua jancha pepa chibanma yudabu miban bimiuma keskabuidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jakia jexe betsa mai pepa anu banadan, Diosun jancha ninkai pepakunkainkin yuda betsabu yusinkin jatu ikunwanmamisbudan, ja mai pepa anu jexe bana benei ewai bimiyatan 100 jexeyai inun, 60 jexeyai inun, 30 jexeyamis keskabuki— nuku aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Januxun ana betsatian miyui betsawen yudan kaian Jesúsun yusinkin: —Dios xanen ibui jaskamiskidi ana betsa matu yusinun ninkakanwen. Juni betsa jawen bai anu kaxun xekiwan jexe pepa banabaini kaken ");
INSERT INTO cbsNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","dasibi uxabun janua jaki sinatamis juxun jexe chakabu jabe jusikin sa abainken ");
INSERT INTO cbsNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","janua xekiwan jukunshina ma bimi taeai uinkin miban chakabu jabe benediai jusia bechitan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","janua jawen tsumabu bai anu buxun ja miban uinbain bai ibu yuikin: “Min bai anu xekiwan pepa min banatanima anudan, ¿jaskai miban chakabudi jusia yumeimenkain?” akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","bai ibuan jatu yuikin: “Eki sinatamistun ea ichakawakin atanimaki”, jatu wa, jawen tsumabun yuikin: “Ja miban chakabudan, ¿jau yumeyamanun betse betse atanpa?” akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","jatu nemakin: “Jamaki. Ja miban chakabu jusia betsekin xekiwandi man betsediatidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jau jabiaska jabe yumeyunun meyamayukanwen. Ja dabe jusia ewai janu jushiaintian tsekakin en jatu yunua ja miban chakabu dukun mextexun neatan manchianbu en kuaxanaii. Januxun en xekiwan bimi pepa mextekin ichawadiatan en dayadubun ea aduxunxankanikiki”, jatu waniki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","ana miyui betsawen jatu yusinkin: —Dios xanen ibui jaskamiskidi miyui betsa ninkakanwen. Junin jawen bai anu mostaza jexe jawen miban tibi banaima anua jatube ja mostaza jexe pexeishtajaidabia ewakin miban betsa binumai punyan ewapabushina jawen mebiki peiyabu tsaua jaki juindukunmisbuki. Dios xanen ibuidan jaska keskaki— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ana miyui betsawen jatu yusinkin: —Misi wakatsi ainbun xekiwan dudu midima kencha ewapa puchinin kesunxun jawen xaxawati eskadabes unpaxki nemustan jawen xaxawati xekiwan dudu kapan dasibi buspukidankin xaxawamiski. Dios xanen ibuidan, jaska keskadiki. Ja dukun juni betsan Diosun jancha ikunwain pepakunkainkin jawenabu yusian akeakeaya unanxubida midimabun ikunwantidubuki— jatu aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Ja xanen ibutan jaska janchanunbadiaikidi jawen jancha yuixunika Diosun yuikin: ‘Mai jidabi en damiwani anua jawada ean junenixun en jatu unanmaisma miyui betsa betsapawen yusinkin en jatu kainmaxunxanaii’, aka ninkatan nuku kenexuniki. Jabias Diosun yuini keska wakin miyui betsa betsapawen Jesúsun yudabu yusinkin jawa miyuimawen yuiama miyui bestiwen jatu yusin chanikunkainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Januxun Jesúsun yudan kaian yusinkin menetan jatu jenebaini jiwe betsan jikiaya janua nun jawen tsumabu jaki ichaxun yukakin: —Miban chakabu jusiakidi min jatu yusinxudan, xabakabi nuku yuiwe— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesúsun nuku yuikin: —Ja miban pepa sa akadan, en matun Juchi Kayabi Iyuaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Baidan, mai jidabiki. Jexe pepadan, jabun Diosun jancha ninkakin pewamisbudan, jabu enabuki. Jakia jexe chakabudan, jabun en jancha ninkama Satanásan jancha besti chibanmisbudan, jawenabuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ja inun, ja jaki sinatakin jexe chakabu sa axunmisdan, Satanáski. Ja inun, janu tsekatitian ixanaidan, ma mai jidabi keyuikiki. Ja jaskaitian mai anua jau yudabu bimi tseka keska wanunbun en nai tsumabu en jatu yunuxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Jamen ja miban chakabu mextekin ichawadan, mai jidabi anuxun yudabun chakabuwakubainmisbu inun yuda betsabun jawa unanma jabun yusinkin jatu dasibi ichakawamisbudan, ea en matun Juchi Kayabi Iyuatun en nai tsumabu en jatu yunua jabun ja yuda chakabu ichawaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","chi nukaisma anu jatu udean janu jiwei peama kaxai xeta yenx yenx akubainxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jakia jabun Diosun jancha pepa ninkakubainmisbudan, en jatu katua janu en Epan jiwe anu nukube jiwei badi keskai chaxai ikibi ixankanikiki. Man pabinkiyabunan, ninkatan jakimayamakanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ana miyui betsawen nuku yuikin: —Tsuanda juni betsan bai anu pei midima adukin maiwani june benamabia juni betsan pukinxun bechitan ibu wakatsi ikin jawaida ana jabianudi achimatan benimajaidakin pei june bikatsis ikin jawen mabu dasibi peiwen taexun jatu inan keyutan june yumetsukatsi ikama jawaida bai ibu anu kaxun jawen peiwen bai ibu watan ja pei maiwanibu bitiduki. Dios xanen ibuidan, pei midima adunibu junea keskaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Jamen Dios xanen ibui jaskamiskidi betsadan, ninkakanwen. Mabu inanananikan perla chudi mane jawenduabu benabaunkin atimas ja mane jawendua jawa chakabuma bestichai kadujaida bechitan jawen kemukin bikatsis ikin jawen mabu dasibi jatu inan keyutan ja pei bixunwen taexun ja perla jawendua jawenas wakin biniki. Dios min xanen ibu waidan, jawada mabu min jayadan, ana jawen nuiama jenetan ja mabu betsa binun ixun ja besti min jawen nuiai keskaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ana nuku yuikin: —Dios xanen ibui jaskamiskidi ana betsadan, ninkakanwen. Juni betsabun ianenwan anu jisin ewapa puntebaunxun baka betsa betsapa jikia ");
INSERT INTO cbsNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","jisin mataken ninibidan mashi anu mapematan janu tsauxun katukin baka ewapa piti pepabus kukiki nanekin jawen chudi chakabu putamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Janu badi jawen jeneaitianan, jabiaskadi wakin Diosun nai tsumabu bexun yuda pepabube yuda chakabu jusia unantan jatu katukin paxkatan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","chakabubu janu chi nukaisma anu jatu putaxankanikiki, janua jiwei peama jaska nun tenetiduma tenei kaxai jau xeta yenx yenx inunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na eska miyuiwen en matu yusianan, ¿man ninkai?— nuku wa —Jaa, nun ninkaii— nun akeakea ");
INSERT INTO cbsNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ana nuku yuikin: —Jawen jiwe anuxun juni betsan jawen mabu betsa tibi adutan mekea unainkiki, mabu bena inun xenidan. Jaska tibi adumiswen taexun jawada mabu pepa bena inun xeni ja dabe kainmamis keska wakin Dios xanen ibuaikidi en yusian bena inun yusian xeni katukubainkin eadi chibankin ea ikunwandiatan Diosun jancha kenenibu yusinananmisbun jatu pe yusindiatidubuki— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","miyuiwen nuku yusin keyutan janua kainkaini ");
INSERT INTO cbsNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jesús janua yumeni anu kai nun jabe jikishinken ma jatu yusin beyamis jatun ichati jiwe anuxun Jesúsun jatu yusindianun ika jikixun jatu yusin taewaya jatu yusian ninkai jaska yusinanainsbumawen e itan yuinamei: —Na junidan, ¿janixun jaska tsuan jawen kushipa tapinmashinamen, ja atimaska nun atiduma aki unanepajaidaidan? ");
INSERT INTO cbsNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nadan, ¿ji mabu wanikatun bakemamen? Jawen ewadan, Maríaki. Jawen betsabudan, Santiago inun, José inun, Simón inun, Judaski. ");
INSERT INTO cbsNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jawen puibudan, nenu nukube jiwediabuki. Jaskatan ¿janixun ja mesti jaska jawaida tapin keyushinamen?— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","jawen jancha bechipaiama ikunwanbumaken Jesúsun jatu yuikin: —Diosun jancha yuixunika juxun yudabu jatu yusianyan betsa betsapabun ninkakin duawaibun jakia jawen mae anu kaxun jawenabudi jatu yusindia jabun jawen jancha danainbun jabiatiandi jawen jiwe anuabun danandiamisbuki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","januxun jawen yusian bechipaiama jawa ikunwankatsi ikabuma danainbun jawen unanmati dami atimaska ichapa Jesúsun jatu axunkin uinmama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Janua Jesúskidi yuia akeakeaibu Galilea anuxun xanen ibu Herodesin ninkatan ");
INSERT INTO cbsNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","jawen tsumabu yuikin: —Jaskakenan, Nashimanika Juan mawa ana bestenshinxun jawen kushipa jatu uinmakin atimaska dami jawa nun atiduma jatu uinmaikiki— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Janua badi betsatian Jesúskidi Herodesin ninkadiamaken Nashimanika Juan mawani matu yuinun ninkakanwen. Herodesin jawen betsa Filipon ain Herodías mebinmaken Juanen Herodes ja akin yuikin: —¿Jaskakin min betsan ain mebintan min ainwainmamen? Jaskatimajaidaki. Ainwanyamawe— akubainaya jawen ainin janchawen taexun xanen ibu Herodesin jawen soldadobu Juan achimaxun mane dispiwen jatu menexmatan bichiti jiwe medan jatu bichimaima janu Juan jiweken ");
INSERT INTO cbsNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","januxun Herodesin Juan tenankatsis ibiai: “Nashimanika Juanan, Diosun jancha yuixunikaki”, iwanan, yuia akeakeaibuki datekunkainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","janua jawen badi janu kaini taxniaya jabube xanen ibubu betsa pimakatsi jatu ia ichabu bebun anua Herodíasin bake chipash nawaxunkin xanen ibu Herodes inun jatube icha benimawaya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","jaskai uinkin xanen ibun jawen aniwa yuikin: —Min ea jaskaxunayadan, chanima jawada min ea yuka en mia inanxanaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","janua chipash kainkaini kaxun jawen ewa Herodías yukakin: —Ewaan, ¿jawa yukaxanpa?— aka jawen ewan yuikin: —Na jabiatian Nashimanika Juanen buxka yukatanwen— aka kaxun xanen ibu Herodes yuikin: —Nashimanika Juanen buxka ea inanwen, sapa kenchakidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","jawen juinti metexekei punu nukatan Nashimanika Juan tenankatsi ikamabia ja jatu pimaibu bebunxun jawen aniwa ma yubai ninkakanxunwen taexun jawen yuba binumakatsi ikama ");
INSERT INTO cbsNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","jakimamadi ja soldado bichiabu jatun jatu tenanmis xanen ibun yunukin: —Juanen buxka textexun ea bexuntanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","soldado kaxun bichiti jiwe medanua Juan textetan jawen buxka sapa kenchaki nanebidan bexun ja chipash inan ja chipashan jawen ewa inanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Janua Juan ma tenanbu jawen tsumabun ninkatan bexun jawen yuda yuka itan bibain maiwatan jaska wabaini buxun chipu Jesúski chaninibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Januxun Juan jaska washinabu Jesús banabimabu ninkatan nun jawen tsumabu nuku yuikin: —Janu tsua jiweabuma anu benanta juindukuin buyunankanwen— nuku wa janua Jesús nukubes xaxuwen kai janu tsua jiweabuma anu Jesús kai yudabu tsuan jatu yuiamabia ninkabaini chibain jatun mae anua main buaibun Jesús jikidiama jabu dukun jikia maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús keti itan butukainkin yudan kaian uin jatuwen nuijaidakin jatunabu isin teneaibu janu iyuabu jatu xuxawaxunpakeaya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","janua ma badi kai meshukidanaya nun jawen tsumabu Jesús anu buxun yuikin: —Ma badi kaikiki. Nenu tsua jiweabumaki. Na yudan kaianen jania pitidubumaki. Ja mae udama tibi anua jau misi bitan pitan jaskadabaintanunbun jatu nichindiwe— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesúsun nuku kemakin: —Jatu nichianma matun jatu pimakanwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","nun jawen tsumabun yuikin: —Misi meken besti inun baka dabe besti nun jayaki. Jati nun jatu pima damaki— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","nuku yunukin: —Jabiaska ea bexunkanwen— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","januxun yudan kaian yunukin: —Ja basiki xukua akeakea tsaukanwen— jatu wa manibaunaibun Jesúsun ja misi meken besti inun baka dabe tsumaxun naiudi teskanxun uinkin pitikidi Dios kenwantan misi inun baka tunke tunke apakekin nuku inankin yunua ja yudan kaian inanbaunkin nun jatu keyua ");
INSERT INTO cbsNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","dasibibun yani wai benimai pepeaibun janua ja misi meken besti inun baka dabe jatu paxkaxuna 5,000 junibun pikanxu jawa jatun ain inun jatun bakebu tanama ja piti texe wakanxu ichawakin 12 kuki nun jawen tsumabun matawanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","23","Janua bebunkidi nukun dukun ianenwan nun pukei kanun nun jawen tsumabu xaxuwen nuku yunua nun kaya yudan kaiandi jatu nichinbaini mati anu ka Diosbe janchai meshu medan Jesús ja mesti niken ");
INSERT INTO cbsNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ianenwan namakis ma bui nun nunuabun niwewan besukidia bekin ian buspu tsaubidankin xaxu tsakama tsakama akaya unanxubida nun kaya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ma pena kemaya Jesús nukuki nukuyui ian bepaikidanaya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","jaskakidanai uin e itan datei jancha kushipawen yuikin: —Yushinki!— nun ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesúsun nuku yuikin: —En eaki. Ewen dateyamakanwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedron yuikin: —Yusinaan, min miamenkain, en miki nukui kanun: “Ian bemaki juwe”, ea wawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesúsun yuikin: —Jani nedi juwe— aka Pedro xaxu anua butukaini ianenwan bemaki kai Jesúski kemayupanan ");
INSERT INTO cbsNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ja niwewanen ianenwan bechuduainki mesei datei jikikainkin jawaida yuikin: —Yusinaan, ea nexewe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","jawaida Jesúsun metsunxun nexetan yuikin: —¿Jaskai min dateai? En mia ian bepaimatidu ikunwanbiai ¿min jadakidi shinan buxkenxumen?— atan ");
INSERT INTO cbsNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pedrobe xaxun inaya niwewan ian bechudunwain maianyan ");
INSERT INTO cbsNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","janua ja xaxun nun tsauabu Jesús naman danti itan kenwankin yuikin: —Chanima min Diosun bakeki— nun ikaini ");
INSERT INTO cbsNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ianenwan pukei nun besusi kapaya niwen jamakidi nuku bukin xutua mae betsa Genesaret anu keti itan ");
INSERT INTO cbsNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","nun butubainaibun yudan kaianen Jesús unantan jatuki chanibaunaibun mae kesua anua kushibidankin jatunabu isin teneaibu iwekin janu Jesús anu jatu iweabu ");
INSERT INTO cbsNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","jau Jesúsun tadi metsanun, iwanan, Jesús jatu ea axuanbu jawen tadi kexa ja isin teneaibun metsatan dasibi main kaya akeakenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Janua betsatian Jerusalénkidia bai beshianbu fariseobu inun Diosun jancha kenenibu yusinananmis betsabu Jesúski nukuxun uinkin yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Nukun xenipabun beya chibankin pidiama nun mepanui taemiski. ¿Jaskakin min tsumabun nukun xenipabun beya chibanma mepanuama pikanimenkain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","jaska waibu Jesúsun jatudi yukakin: —Matunan, matun beya chibankin Diosun yununi betsa watan ¿jaskakin man ana chibainsbumamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jaska Diosun yuini matu yuikin shinanmanun ninkakanwen. “Matun epa inun matun ewa medabewakin jatu duawakubainxankanwen. Jakia matun ibubu man jatu ichakawaya jau matu tenanxanunbunwen”, akin yunubianiken ");
INSERT INTO cbsNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","jakia matundi juni betsa yusinchakakin: “Matun ibubu jawadawen medabewati mabu man jaya man jaki tanabia Templo anu inankuinkatsi man butidu man shinantiduki. Tsuan matu ana bikawatidubumaki”, iwanan, jatu yusinmisxun ");
INSERT INTO cbsNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ana jatu yusinkin jau jatun ibubu ana jatu duawakin medabewayamanunbun pepaibu jaska nemakin man jatu bextekubainmiski. Jaska wakin Diosun yununi danankin matun beya betsa betsapa besti man chibankubainaii— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","—Bebunkidi Isaías man bepadamenikabukidi Diosun yuimakin: ");
INSERT INTO cbsNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na yudabunan, jatun janchawen ea kenwanbiakin jatun juintiwen ea shinainsbumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ja inun, ichatan jawa ea kenwankin pewaisbumaki. Jakia junibun yunuawen besti jatu yusinkubainmisbuki’, aka jawen jancha yuixunika Isaíasin ninkatan nuku kenexuniki— jatu atan ");
INSERT INTO cbsNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","januxun Jesúsun yudan kaiandi kenakin jatu ichawaxun yusinkin: —Na jaskaibukidi matu yusinun ninkatan tapinkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jawada yudabun piabu jawa jatu chakabuwaismaki. Jakia yudabun juinti medanua jawada jancha chakabu shinain anua taxnikin jatun jatu chakabuwamiski, Dios sinatamakinan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","janua nun jawen tsumabun shinanbidan Jesús dapi nitan nemakin: —Ja fariseobu min jatu yusiain ninkatan mia ninkama miki sinataibudan, ¿min uianmamen?— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesúsun nukudi yuikin: —Tsuabunda ea inun en Epa ikunwanma nukun jancha danainbu en Epandi jatu danandiaxanikiki, miban tsuan banama jamebi jukuinma tachayabis betsea keska wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jau shinan inunbunwen. Juni bekunman juni betsa jabe bekun iyupai jadakidi iyuai unanma jabia dabe mikin maebain di idabemisbuki. Ja bepadameaibu jaska keskabuki, jabun tsua medabewatidumadan. Jaskaken jawa jatu yuiyamakanwen— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedron Jesús yuikin: —Na min pitikidi jatu yusinxudan, xabakabi nuku yuiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesúsun nuku yuikin: —Matundi, ¿man ninkakin pewadiabumamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Xabakabi matu yusinun ninkakanwen. Jawada yudabun piabu jatun shinanki naneama jawa jatun shinan chakabuwatidumaki. Jakia jawada piabu jatun jatuki nanea puiabu kainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jakia jatun shinan medanua jawada chakabu jaya jawen chakabumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Janua eska yudabu jaya jatun shinan uke medan aduabu chakabu shinankin xabakabi taxnimamisbuki, eska tibi shinan medanua xabakabi kainkinan, juni betsaki yubakatan tenankinan, juni betsan ain chutankinan, xebi jayabu chutabaunkinan, yumetsuidan, chani chakaidan, yuda betsa ja akinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jaska tibi yudabun shinan anua taxnikin jatu chakabuwamiski, Dios sinatamakinan Jakia fariseobun beya chibanma mepanuama pikin Dios sinatamatidubumaki— nuku aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Janua Jesús kainkaini mae dabe Tiro inun Sidón dapi kaken ");
INSERT INTO cbsNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","janua judiobuma Cananawa ainbu betsan Jesús bechitan chibain kakin unanxubima juu akin kenakin: —Yusinaan, min Davidin babaki. Ewen dabanan ikin en ainbu bake yushin chakabun ea bika tenemainkikiki. Ea kainmaxunyuwe— akubidanaya ");
INSERT INTO cbsNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesúsun ninkabiai jawa yuiama kai tini tini ikainaya januxun nun jawen tsumabun yunukin: —Juu ikin nuku mese wabidanikiki. Nichinwen, jau kanunan— akin nun yuikubaina ");
INSERT INTO cbsNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","atimas Jesús niti itan ainbu yuikin: —Israelbu chaxuwan benuabu keska besti en jatu yusinkubainun Diosun ea yununiki. En mia medabewatidumaki— abia ninkama ");
INSERT INTO cbsNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","jukidan ja bebun danti itan yuikin: —Xanen ibuun, ea jaska wama ea medabewawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesúsun yuikin: —Israelbun piti bianxun kaman anu putatimaki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ainbun jantsidi ana yuikin: —Jeen. Jabiaskaki. Xanen Ibuun, en kaman keskaki. Israelbun tapukixun piabu jawen pese kamanen mitumisbuki. Jaska keskadi wakin en bake medanua yushin chakabu ea kainmaxunyuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ninkatan Jesúsun yuikin: —En jaska yuiai ikunwankin min pe yuiaii. Jaskaken min bake anua yushin chakabu ma kainkainxuki. Uinditanwen— akaya jabiatiandi jawen bake medanua yushin chakabu kainkainaya kayanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jaska wabidani janua iaketankidani Jesús kainkidani Galilea ianenwan ketanbidankin binubaini mati anu mapekea tsauken ");
INSERT INTO cbsNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","janu tsaua shinanbidani yudan kaianen jawenabu isin teneaibu jau Jesúsun jatu xuxawaxunun tidibu inun, bekunbu inun, chantui tsedesnibu inun, juyubu inun, isin betsa betsapa teneaibu iwexun ja dapi jatu janabu xuxawai ");
INSERT INTO cbsNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","uinkin ja juyunibu janchaibu uinkin chantui tsedesnibu ni peaibu uinkin bekunibun uiainbu uin jabaa iake iakekin Israelbun mekenika Dios kenwankin taewakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","jabianuxun nun jawen tsumabu Jesúsun kenaxun nuku yuikin: —Ma xaba dabe inun besti ea ninkakin jabun piti ma keyuabuwen taea en jatuwen nuiaii. Jatun jiwe anu piti mais en jatu nichian bui bai puchinin punu nukai babui unanyamastidubuki— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—Janu tsua jiweabumanua jania piti bixun jati junibu nun jatu pimatidumaki— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesúsun nuku yukakin: —¿Jati misi man jayamen?— nuku wa —Siete misi inun baka pishta eskadabes nun jayaki— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","januxun Jesúsun ja yudan kaian yunukin: —Ja main tsaubaunkanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ja siete misi inun bakadi bixun Dios kenwantan misi tunkepakekin bakadi tekepakekin nun jawen tsumabu nuku inanpakea ja yudan kaian nun inan akeakebauna ");
INSERT INTO cbsNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","januxun dasibibun yaniwai benimai pepeaibun 4,000 junibu besti tanakin jatun ainbuaibu inun jatun bakebu nun tanama januxun ja pikanxu jatun texe ichawakin siete kuki nun matawaya ");
INSERT INTO cbsNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesúsun jatu yunukin: —Ma en kai inun budikanwen— jatu wabaini janua nun jawen tsumabubes xaxun inatan kai Magadán mai pakea anu nun kaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ana betsatian fariseobu inun saduceobu bexun Jesús unanti wanun, ikin padankin yukakin: —Dios anua jawen unanti dami nuku axunwen, min jawen kushipa jaya nun uinunan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","jatun shinanen kaneaibu unankin Jesúsun jatu yuikin: —Ma badi jikiaya matun yuikin: “Ikis nai tashipaki. Meshukidi penai badi pejaidaxanikiki”, man imiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Janua penayadi yuikin: “Ikis nai tashipa ma nai kuin meshu meshuikiki. Natian ui bekatsis ikikiki”, ikin jaska ui inun niwe bemis unanbiakin janu jawen chakabu kupititian ma kemai en matu yusin chakayamabiakubaina ¿jawen unanmati man uintidumamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nukunabu na jabiatian jiweabudan, man chakabuki. Jamapai Dios anua unanti tsuan atiduma uinkatsi man ea yukabiamisdan, Diosun Jonás bakawan xeamabiashinxun ana jiwemakin kainmanidan, jaska keska besti Diosun matu uinmakin matu axundiaxanikiki. Shinankanwen— jatu watan jenebaini ");
INSERT INTO cbsNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ianenwan kexa betsaudi jabe kakin nun jawen tsumabu jabe kakin misi buama nun jakimakainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesúsun nuku yuikin: —Shinaindakanwen. Fariseobu inun saduceobun misi xaxawati meseki. Uindaxankanwen— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","shinan pewama nun jawen tsumabu yuinamei: —Nun misi beama ixuken nuku jaska yuikiki— nun ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesúsun nukun shinan unankin yuikin: —¿Jaskai: “Nun misi beama ixuken nuku jaska yuikiki”, man ikai? Man ea uinbiakin man ea ikunwan chakaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jawada en matu yusian ninkakin ¿man tapindiamamen? Ja 5 misi tunkepakexun 5,000 junibu en jatu pimashina inun jawen texe ichawakin jati kuki man matawashina, ¿man shinanmamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ja inun, 7 misi tunkepakexun 4,000 junibu en jatu pimadiashina inun jawen texe ichawakin jati kuki man matawashina, ¿man shinanmadimen? ¿Man daka shinain? ");
INSERT INTO cbsNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jaskai fariseobu inun saduceobun misi xaxawatikidi janchai ¿jaskai jatun misi kayabikidi en janchamabiaken man shinan chakai?— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","januxun fariseobu inun saduceobun misi xaxawatikidi yuikin jabun yusinkin kanemisbukidi nuku nemaxu atimas tapintan nun shinankubainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Janua Jesús nun jawen tsumabube kai ja mae pakea Cesarea Filipo anu jikitan nuku yukakin: —Yudabunan, en matun Juchi Kayabi Iyuadan, ¿en tsua ea yuimisbumen?— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Betsabun yuikinan: “Nashimanika Juan ana bestenshinaki”, mia wakanikiaki. Betsabundi yuikin: “Elías ana besteinmaki”, mia wadiakanikiaki. Betsabundi yuikin: “Diosun jancha yuixunika Jeremías kasmai jawen jancha yuixunika betsa daka”, akin mikidi yuimisbukiaki— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Jamen matun shinankinan, ¿man tsua ea wamismen?— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedron kemakin: —Miadan, Epa Dios jiweatun bake min nukun mekenika Mesías Cristoki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesúsun yuikin: —Simón Jonásin bakeen, en jaken juni betsan mia yuiamabia en Epa nai anuatun mia unanmakin mia duawaikiki. Benimadiwe. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ean mia kenakinan, mia Pedro wakin mishki kushipa keska en mia waii. Min jaska janchakin yuixuwen taexun yudabu minwendi ichapa en jatu ikunwanmaxanaii. Yuda mema mawatidubiaken Satanásan datemakin ea ikunwainbu maematidumaki, jatu nemakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jaska inun, ikunwainbu min jatu mekekubainxanun naiudia kushipa en mia yunuxanaii. Nenuxun yusinkin min jawada nemaya Epa Diosundi nemaxanikiki. Jawada nenuxun min nemamaken Epa Diosundi nemama ixanikiki— atan, ");
INSERT INTO cbsNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesúsun nuku nemakin: —En Mesías Cristoki tsua banabimayamayuxankanwen— itan, ");
INSERT INTO cbsNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","janua Jerusalén anu ka jaska waxanaibu nuku yusinkin taewakin: —Eki sinatakin ea ichakawakin judio xanen ibubu inun, Diosbe nukunabu janchaxunikabu inun, Diosun jancha kenenibu yusinananmisbun ea danankin ichakawakin ea jatu tenanmabu xaba dabe inun bestitian en ana bestenxanaii— akin ");
INSERT INTO cbsNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","nuku xabakabi yuiaya Pedron ja mesti paxkabain nemakin yuikin: —Xanen Ibuun, jaskamaki. Diosun mia jaska yunuama iniki. Jau tsuan mia tenanyamaxanunbunwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús jawen tsumabukidi nasauketan uinkin Pedro nemakin yuikin: —Satanásan shinanwen min ea teawakatsis ikai ana jadi jaskayamawe. Jawada Diosun uiain keska min uianmaki, eska shinankinan, jaska yudabun uinmis keskawen min ea nemaidan— abain ");
INSERT INTO cbsNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","janua Jesúsun nun jawen tsumabu nuku yuikin: —Tsuada eki chiti ikatsis ikidan, jaska jamebi shinanmis jakimatan: “En jabe mawatiduki”, ikin jau ea chibankubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ja inun, tsuanda jatun jiwea ibubis mekekatsi ikamadan, jau benununbunwen. Jatun jiwea ewen benubiashinabudan, ea anua ana jiwekuian bixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Jamen tsuanda mabu midimawen kemu bestikin ichawaxun ea ikunwankin chibanma jatunmebi jatun jiwekuian benuxankanikiki, eauma mawaidan. Ja inun, jatun jiwea pakatan tsuan ana bitidumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jamen en matun Juchi Kayabi Iyuadan, en Epan kushipaya Xanen Ibui jawen nai tsumabube ana juxun tsuabunda ea chibain jiwei pemisbu inun chakabumisbu jabu tibi en jatu manakuxanaii, pepa inun chakabuwenan— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","—Chanima en matu yuiai ninkakanwen. Na jabia man ebe mapuabudan, man betsa betsapa mawadiamaken en matun Juchi Kayabi Iyua en matu Xanen Ibui taexunai man uinxanaii— nuku aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Janua 6 día binuaya Pedro inun Santiago inun Santiagon betsa Juan Jesúsun jatu dapaxkabainkin iyui kai mati keyatapajaida jatube mapeketan ");
INSERT INTO cbsNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","janua Jesús dami jawen besu dami badi keskai chaxai jawen tadi juxupajaidai xaba keskai juxu punte punte ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moisés inun Elías Jesúsbe janchai uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","jawa unanma Pedron Jesús yuikin: —Yusinaan, nun nenu juadan, pejaidaki. ¿Pean xubu dabe inun besti matu waxunpa, betsa mina inun, betsa Moisésna inun, betsadi Elíasinadan?— ");
INSERT INTO cbsNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","akaya januxun nai kuin juxu mayabidankin jatu achiaya nai kuin anuxun jui taxnikin jatu yuikin: —Na en bake en Katunidan, en bechipaijaidaii. Jawen en benimajaidaii. Ninkaidakubainkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","jawen tsumabun ninkai datejaidai main beua maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús jatu dapi juxun jatu mekin yuikin: —Ana dateama benidikanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","benitan bedu bedu ikin uin janu tsua niama Jesús besti nia uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","janua mati keyatapa anua butebidankin Jesúsun jatu nemakin yuikin: —En matun Juchi Kayabi Iyua mawa en ana matu bestenxundiamaken na eska man uinxudan, tsua yuiyamayuxankanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ana Jesús yukakin: —Diosun jancha kenenibu yusinananmisbun yusinkin: “Nukun mekenan Cristo judiama bebunkidi Elías ana juxanikiki”, ikidan, ¿jaskai imisbumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","jatu kemakin: —Chanima Elías bebunkidi ana juxun dasibi benawakin pewakin taewaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Janunkain chanima en matu yuiaii. Elías ma ja dukun juyama unanma danankin jawen jawada wakatsis ikin Elías akimabuki. Jabiaskadi wakin en matun Juchi Kayabi Iyua jabun eadi danankin ichakawakin ea achitan jatu ea nuitapawamadiaxankanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","janua Elíaskidi Jesúsun jatu yuiama jakia Nashimanika Juankidi junea janchawen jatu yuia jawen tsuma dabe inun bestitun atimas shinanbidanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Janua Pedro inun, Santiago inun, Juan Jesúsbe jui janu yudan kaianki nukutushiaya jabianudi juni betsa jukidan Jesús bebun danti ixun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","16","—Xanen ibuun, en juni bake yushinin duxku imakin nuitapawakin chi anu napukin jenen pukumisken min tsumabu anu en iwebia jaska waxun tsuan ea kainmaxuntidumaki. En bakewen nuikin ea xuxawaxunwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesúsun mapuabu jatu yuikin: —Ikunwainsbuma inun chakabubuun, ¿jatiki matu medabewai ana en matube jiweyuxanai? Nedi iwekanwen, ja bakedan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","iwea Jesúsun yushin chakabu kainma kaya jakimamadi jawen bake kayai xuxaya ");
INSERT INTO cbsNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","chipu januxun nun jawen tsumabun Jesús paxkabain yukakin: —¿Jaskakin ja yushin chakabu nukun nun kainmatiduma ixumen?— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jesúsun nuku yuikin: —Ea ikun kayabijaidawadiama man atiduma ixuki. Chanima jancha en matu yuiai ninkakanwen. Mostaza jawen jexe pexeishtabia banabu ewai ji ewapamiski. Jabiaskadi wakin ea ikun pishtawabiakin en kushipa shinankin na mati yuikin: “Nenua maei betsa anu katanwen”, man wa matu ninkatan ja mati maetiduki. Jamen ea ikun kayabi wakin dasibi man jaska atidubuki— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","janua dasibi nun jawen tsumabu jabe kai Galilea anu nun jabe kakunkaunaya Jesúsun nuku yuikin: —Ea en matun Juchi Kayabi Iyuadan, tsuanda ea jatu achima ");
INSERT INTO cbsNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ea tenanbu xaba dabe inun bestitian en ana bestenxanaii— nuku wa jaska chaniai ninkatan nun nuijaidaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ana kai jawen mae Cafarnaúm anu nun jawen tsumabu Jesúsun nuku iyuken Templo pei bixunikabun Jesús bechibaini kaxun Pedro yukakin: —Matun yusinanan, ¿jawen Templo mekekin pewati pei badi betsa tibi pakakubainmismen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedron jatu yuikin: —Jaa. Pakamiski— jatu watan kai jiwetan jikiaya Pedron shinan unankin Jesúsun ja dukuntun jancha wakin: —¿Jawen gobierno medabewati pei ichawakin xanen ibu kushipabun tsuabu dukun yukamisbumen, jawenabumenkain, nawabudaka? ¿Jaskada min shinain, Simóon?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedron yuikin: —Nawabu jatu amamisbuki— akaya januxun Jesúsun yuikin: —Chanima xanen ibun jatun yunuaitun pakaisbumaki. Jabiaskadi wakin nun Diosunabun nun pakatidumabiaken ");
INSERT INTO cbsNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","nukuki jau sinatayamanunbun xeamatiwen ianenwan anu xeamakin baka ja dukun min bia jabexutan pei jexe bestichai bechitan bixun Templo jawen pewati pei mina inun ena daken buxun jawen jatu pakatanwen— aka kaxun jaska Jesúsun yunua ninkabain bitanxun Pedron jatu pakanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jabias xabatiandi nun jawen tsumabu Jesúski ichaxun yukakin: —Mibe xanen ibukin jadatutun nun jatu binuxanimenkain, nuku yuiwe— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","januxun nuku yusinun, iwanan, bakeishta kena juai namakis nichinxun ");
INSERT INTO cbsNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nuku yuikin: —Chanima en matu yuiaii. Bake mishtinbun jawa dateama ea ikunwain chintunkatsi ikama ea chibankubaintidubuki. Tsuabuda jaska keskadiakin jawa keanma ea ikunwankin chibanmadan, nai anu man ebe jiwei xanen ibutidumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jakia tsuada juni ewabia na bakeishta keskai ibubis keanma jatu medabewa bestikubainmisbu ebe xanen ibukin betsabu man binuxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ja inun, ea duawanun, iwanan, na bakeishta keska wakin tsuada en kenaya juai ea ikin akawakin man duawatiduki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ana nuku yuikin: —Tsuabunda jawada Diosun nemamis inun yunumis chibanma chakabu wamisbun bake mishtinbun ea ikunwain jatu padankin chakabu jatu ama akeakediamisbudan, jaskawen taexun Diosun jatu kupijaidaxanaiwen taea jawen xekiwan deneti mishki ewapa nexaxun teumatan ianenwan medan pukua jasadan, jawen kupiti bexmas mekeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ja inun, jamapai betsa betsapawen kemukin yudabun chakabuwamisbuki. Jakia tsuabunda enabun Diosun yunumis inun nemamis shinanbiaibun juinti babubu padankin jatu chakabu ama akeakemisbu jabudi Diosun jatu kupia nuitapajaidaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jaskaken matun meken kasmai matun taewen jawada man chakabuwakubainai matun meken kasmai matun tae mextea keska watan jawaida jenekubainkanwen. Man meken dabeya inun man tae dabeyaken janu chi nukaisma anu matu udean pemajaidaki. Jakia meken bestichaiya inun tae bestichaiya Diosbe jiwei kai peki. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja inun, matun bedu betsawen jawada uinkin man chakabuwakubainai bedu betsa tseka keskatan jawada man chakabuwai jawaida jenekubainkanwen. Man bedu dabeyaken janu chi nukaisma anu matu udean pemajaidaki. Jakia bedu bestichaiya Diosbe jiwei kai peki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ana nuku yusinkin: —Na bakeishtan ea ikunwain keskabu jawa keinsbumadan, Diosun nai tsumabun jatu mekei en Epabe beisinain jabe janchakin jatu medabewamisbuwen taexun jawa jatu ichakawakin dananyamakubainkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","14","—Miyuiwen matu yusinun ninkakanwen. Tsuada 100 chaxuwan jaya bestichai benua 99 besti basi mati anu mapuken jeneyubain bestichai benua man benamisbuki. ¿Chanimamen? Jaskaken ja 99 benuabumawen benimabiakin atimas ja bestichai benua bechitan man jawen benimajaidamiski. Jabiaskadi wakin matun Epa nai anuatun jawa bestichai bakeishtan ea ikunwain benukatsi ikamaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ana nuku yusinkin: —Ea ikunwain betsan kanekin mia chakabuwa jabes janchai pekin jadakidida mia chakabuwaxu jau unanun yuiwe. Mia ninkaya min jabe jaibunamexanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jakia mia ninkamaken januxun ea ikunwain bestichai kasmai dabe jatu kenatan jadidi mia chakabuwashina jabias janchadi jatudi banabimatan jatun mia chakabuwashina anu jatu iyuwe, jau jabundi mia medabewanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Januxun jatun janchadi ninkamaken matun ichati jiwe anu iyuxun jatudi banabimadiawe. Januxun jabun pewakin yusianbudi binu keyukin ninkamaken jaskawen taexun ikunwanbuma inun gobierno pei bixunika chakabuwen meseisma keska wakin jatu danankubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Chanima en matu yuiaii. Nenuxun ikunwainbu yusinkin man jawada nemaya Epa Diosundi nemaxanikiki. Jawada nenuxun man nemaxunamaken Epa Diosundi nemama idiaxunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Ja inun, ikunwainbu dabe kasmai dabe inun besti ichabu en kenawen janchakin yukaibu en kushipawen en jatube nashui ika ikunkainxanaii. Jabiaskadi wakin matu dabetundi jabias shinankin jawada pepas Dios man ea aka matu axunxanikiki— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","jawen jancha ninkatan Pedron Jesús yukakin: —Yusinaan, mia ikunwain betsan ea chakabuwaya ¿jatiki jawen chakabu jakimawaxanpa? ¿Metutikidaka?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesúsun nemakin: —Jaskamaki. Metutiki bestimaki. Jakia min chakabu Diosun mia tanaismaki. Jaskawen taexun jawen chakabu tanama jakimawakunkainxanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","24","miyuiwen jabiaskadi nuku dasibi yusinkin: —Dios xanen ibui jaskamiskidi matu yusinun ninkakanwen. Xanen ibujaida jawen tsumabun dibiabu pewanun, ixun jawen tsuma betsabu yunukin: “Ea dibiabu ea ixuntankanwen”, jatu wa juni betsan ichapajaida dibia iwexunabu ");
INSERT INTO cbsNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ja jawen tsumapan dibijaida jawawen pakatidumaken ja xanen ibun jawen tsuma betsabu yunukin: “Na ea dibijaida jawawen ea pakatimaki. Jaskaken jawada ea dibia jau jawen ea pakakin keyunun jawen jawada inun, na juni inun, jawen ain inun, jawen bakebu jatuwen pei bikatsi jatu inankanwen, jau juni betsa dayaxununbunan”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ja dibia jaska wai ninkatan jawen xanen ibu naman danti ixun nemakin: “Xanen ibuun, ea jaska wama ewen nuiyuwe, chipu unanxubida en mia pakakin keyukubainxanaidan”, aka ");
INSERT INTO cbsNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","jaska wa ninkatan janua jawen xanen ibu jawen nuikin: “Dasibi min ea dibia en jakimai ana ea pakayamaxanwen. Ana jawen nuiama inun kadiwe”, aka ");
INSERT INTO cbsNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","janua kain kaini kakin jawen xanen ibun tsuma betsa jaki nukutan eskadabes dibibia jawen pei binun ixun tetsunxun yuikin: “Min ea dibiadan, ikis ea pakadiwe”, axun jenea ");
INSERT INTO cbsNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ja naman danti ixun nemakin: “Jawaida ikis jawawen en mia pakatidumaki. Ewen nuikin manayuwe, chipu unanxubida en mia pakaxanaidan”, abia ");
INSERT INTO cbsNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","jawa ninkama bichiti jiwe anu iyukin policiabu jatu bichimaniki, januxun ja dibia pakamaken kaintidumawakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jaska wai jawen xanen ibun tsuma betsabun uin jawen nuijaidakain jatun xanen ibu anu buxun ja junin jaska waxu dasibi yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","januxun jatun xanen ibun jawen tsumabu yunukin jatu yuikin: “En tsumapan ea dibia en jakimabiaxu ja jatun jaska waxudan, ea ixuntankanwen”, jatu wa ixuntanabu yuikin: “Min juni chakabujaidaki. Ichapajaida min ea dibibiaxun ea ea akin min ea nema miwen nuikin dasibi min ea dibia en mia jakimaxunxuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jaska shinantan en mia jakimaxu keskai miadi en tsuma betsan mia jatida dibia min jakimatishadaxuki”, atan ");
INSERT INTO cbsNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","jawen xanen ibu jaki sinatajaidakin bichiti jiwe medan jadi jau bichitanunbun yununiki, jau jadixun ja dibijaidatun jau pakakin keyuxanunan. ");
INSERT INTO cbsNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Matu man jaska keskadiai ikunwain betsan mia chakabuwa jawen nuikin jau ewen nuinun, iwanan, mia yuibiaken miadi jawen nuiama min jakimamaken ja xanen ibu keskai en Epa Dios nai anua matuwendi nuiama ixanikiki, matun chakabu buamadan— nuku aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Januxun Jesúsun nuku yusin menetan Galilea anua kainkaini kai Jordán jene kexa betsaudia este badi juaikidia Judea mai pakea jatiuma anu nun jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jesúski yudan kaian ichakin isin teneaibu iweaibu jatu kayawakin jatu xuxawaxunpakeaya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","januxun fariseobu jatiditun Jesús unanti watan jaki bepadamenun ika jaki kematan yukakin: —Jawen jamapaiwen taexunan, ¿juninan, jawen ain jenetimen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Jesúsun jatu yuikin: —Diosun jancha Moisin nukun xenipabu yusinxun kenenidan, ¿man uinsmamen? Matu yuinun ninkakanwen. Diosun damiwakin taewakinan, juni inun ainbu damiwaniki. Januxun Diosun Moisés yudabu jatu yusinmakin yuikin: “Junin ainbu ainwankatsi jawen ibubu dapaxkabaini ka ainyantan jawen ainbe ketaxameawen taea ana yuda dabema jabias yuda bestichai keska jiwetidubuki”, aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaskaken Diosun juni inun jawen ain yuda bestichai keska jatu wa junin jawen ain dapaxkabainkin jenetimajaidaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","januxun fariseobun Jesús ana yukakin: —Jamen Moisin nukun xenipabu yusinkinan: “¿Jaskakin animen, tsuanda jawen ain jenekatsi ikin jabe itimaskatanan, jawen taexun ainbu jeneti kene inankin: ‘En mia ana ainwanmaki’, iwanan, kene inantan jau taxnibainxanunbunwen”, akinan, jaskakin jaska jatu axunimen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesúsun ana jatu yuikin: —Matun xenipabu juinti kushiken Moisin jaska jatu yununiki. Jakia Diosun dasibi damiwakin taewatanan, jaska yunuama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Chanima en matu yuiaii. Jamapai shadabu chani ninkatan sinatakin jawen ain jenetidubumaki. Jamen jenetan kainkain ainbu betsa ainwainan, ibubis chakabumisbuki. Jakia tsuanda jawen ainin juni betsa chutamabiatan yuiama padanyanan, jawen ainan jenetiduki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","nun jawen tsumabun Jesús yuikin: —Juni ainyantan jau ana jeneyamaxanunbun Diosun nemaniwen taeadan, ainbu biama chutauma unanuma jiwea pepamenkaintsa— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesúsun nuku yuikin: —Chanimaki. Jakia juni dasibibu jaska jiwetidubumabiaken jabu Diosun katuxun medabewakin jaska yunumis bestibu jaskai jiwetidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Juni bestibu jubuxkuma kaian ewatan chutatidubumaki. Ja inun, juni bestibu jubuxkuya kaian ewai esclavo dayaduwakin jubuxku biabu chutatidubumadiki. Jakia juni bestibu jubuxkuya kaian ewatan Diosun jancha yusin besti dayakin chutaisbumadiki. Tsuabuda jaska jiwetidubudan, jau jiwekubainunbunwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","januxun mamepipakekin jau Dios yukaxunun Jesús anu jatun bakebu jabun iweaibu nun jatu nemanun ika ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","uinkin Jesúsun nuku yuikin: —Jatun bake mishtinbu ea anu iweaibu jatu nemayamakanwen. Dios xanen ibuaitianan, na bake mishtinbu eki dateabuma keskabu besti Dioski dasixankanikiki— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","bake mishtinbu mamepipakekin Diosun jau unanuma duawanun jatu dasibi yukaxuntan janua kainkainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","janua bedunan betsa mabu inun bai midimaya Jesús anu kaxun yukakin: —Yusinaan, ¿mia yukapa? Jiwea kayabi bikinan, ¿jawa pepa akubainkin en jiwea kayabi en bitidumen? Ea yuiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesúsun yuikin: —¿Jaskakin pepatikidi min ea yukai? Dios besti pepaki, ¿min unanmamen? Jakia jiwei ikibi ikatsidan, Diosun yunuti inun jawen nemati chibankin jeneyamaxanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","bedunantun Jesús yuikin: —¿Jadatumen?— aka —Juni betsaki sinatakin tenantimaki. Ainbu min ainma chutatimaki. Yumetsutimaki. Juni betsaki chani chakatimaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Matun ibubu duawakubaintiki. Jaska inun, min jabube jiweabu duawadiakubainkanwen, ibubis nui man mekemis keskaidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","bedunantun ana yuikin: —Na dasibi min ea yuiaidan, bakeishtatun tapinixun en jeneismaki. ¿Jawa betsa Diosun yununi en adiamamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesúsun ana yuikin: —Min ea pe yuiaii. Na besti min shinandiamaki. Mia yuinun ninkawe. Nai anua Diosun manakuti pepa bikatsis ikin min jawada dasibi jaya jatu inan keyutan ja pei min bishian ja nuitapaibu inankuintan chintuanma ebe kakin ea chibankubainxanwen. Min jaskakunkainaiwen taexun jiwekuian kayabi min bixanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","januxun bedunan mabu ichapa jayatun Jesúsun jaska yuiai ninkai jawen mabuwen taea pes juinti nishmai keyutan ana jawa yuiama kaya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","24","Jesúsun nuku yuikin: —Chanima en matu yuiaii. Ja yuinaka ewapa camellodan, ja xumux jawen chixuiki jawen yuda kainmakinan, tsuan atidumaki. Jakia jaska keska bikadan, juni mabu ichapayadan, jawen mabu besti shinain jawen nuikin jatun shinan betsa wama Dioski chiti itidubumaki— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","—Jabaa!— iki yuinamei: —Jaskakenan, ¿tsuabu Diosun nuku mekekin paxawakin jiwematidumen?— nun ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","nukuwen nuikin Jesúsun ana yuikin: —Dateyamakanwen. Yudabun jaska watidubumajaidabiaken Dios nuikipatun dasibi matu axuntiduki— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedron yuikin: —Yusinaan, nukunan, mia chibankatsi ikinan, jawada nun jaya dasibi bashikin keyubidan nun ma mia chibanpakeaii. Nun jaskakidanimadan, ¿nun jawa jayaxanai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesúsun ana nuku yuikin: —Chanima en matu yuiaii. Badi jawen jenei keyuaitian en Epan dasibi benawaya en jabe xanen ibuaya chintuanma man en 12 tsumabun ea chibankubainmisbu ebe xanen ibukin Israelin 12 bakebu xukua akeakeabu man unanti wanun badiaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jaska inun, tsuabunda ea chibankin Diosun jancha kakape yusintanun ixun dasibi jatun jiwe jenekin jatun betsabu inun jatun puibu xununbainkin jatun ibubu xununkin jatun bakebu bashikin jatun bai jenekin keyubain yusinkubainmisbuwen taexun na jabiatian Diosun ana jatu manakukin duawamisxun jaska uatian jiweshinawenma Diosun pepawen jatu manakujaidakin jaska tanatidubuma jatu ichawamakubainshinxun janu ma badi keyuaitian jiwea kayabi jatu inanxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jaska inun, yuda ichapabu na jabiatian kenkin yunumisbudan, Diosun jatu kenwanma ixanikiki. Jakia betsabu na jabiatiandi jawa kenkin yunuisbumadan, Diosun jatu kenwankin xanen ibujaidawaxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ana nuku yuikin: —Dios xanen ibui jaskamiskidi ana matu yusinun ninkakanwen. Dios xanen ibuidan, bai ibuan dayakapabu katutan jatu yunupakemis keskaki. Penai taeaya jawen bai anu jau uva tsekaxuntanunbun dayakapabu katuxun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","yuikin: “Man ea dayaxuni ka badi kai jikiaya xaba jidabi daya pei en matu inaiin”, iwanan, dayakapabu jawen bai anu jatu yunua buabun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","janua ma badi chikeyaya jawen mae namakis jemaintin anu juni betsabun jawawama uinkin ");
INSERT INTO cbsNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","jatu yunukin: “Matundi en bai anu en bimi ea tsekaxuntankanwen, badi kai jikiaya en matu paka pewaidan”, jatu wa buabun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","janua bai ibu ana badi manananbi taxnikaun juni betsabu jatu yunua buabun ana badi nai puchinin dakaken juni betsabudi jatu yunua buabun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","janua ma badi jiki kemaya ana jawen mae namakis jemaintin anu kaxun juni betsabun jawawama uinkin jatu yukakin: “¿Jawai badi chaitanai man dayama ibaiai?” jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","jabundi yuikin: “Tsuan nuku jawa yunuama nun ikaii”, akabu bai ibuan jatu yunukin: “Matudi en bai anu kaxun en bimi ea tsekaxuntankanwen, ma badi jikiaya en matu paka pewaidan”, jatu wa buabun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","janua ma meshu beaya bai ibun dayaibu uinika yunukin: “Ea dayaxuntankanxu jatu kenaxun jabianus kesua pei ea jatu inan akeakeaxuntanwen. Ja dama bukanxu ja dukun jatu paka taewabainkin ja jabu dukun buabu jawen jenekin jatu pakakin keyutanwen”, aka kaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ja dama bukanxu jabu dukun kenaxun xaba jidabi daya pei jatu inankin keyutan ");
INSERT INTO cbsNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","janua ja badi nai puchinin dakaken dayai buabu jatu kenaxun jabianus kesua pei jatu pakatan janua ja badi manananbi dayai buabu jatu kenaxun jabianus kesua pei jatu pakatan janua ja badi chikeyaya dayai buabu jatu kenaxun jabianus kesua pei jatu pakatan janua jabu dukun buabu bekin shinain: “Ja jatu pakai binumakin nuku inainmenkaintsa”, ibiaibun jabianus kesua pei binuama jabias jatu inandiaya ");
INSERT INTO cbsNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","jabun pei bitan bai ibuki sinatakin ja akin ");
INSERT INTO cbsNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","yuikin: “Badin nuku kua niskain xaba jidabi nuku besti dayai nun nuitapabaixuken ¿jaskakin ja dama bubiakanxu daya eskadabesbiakanxuken nuku itsawakin xaba jidabi daya pei min jatu pakaxumen?” akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","bai ibuan jatu bestichai yuikin: “Jatixun kesua ma bebunkidi en mia yuba en mia pakaxuki, mia padanmadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Ana eki sinatama en mia pakaxuya kadiwe. Jakia na dama bukanxu matu itsai xaba jidabi daya pei en jatu inanxudan, jawa chakabumaki. Ja pei man jawen nuiaidan, matunamaki. Enaki. Jameen en jatu duawaya ¿min daka en peiwen nui ikai?” aniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jaskawen taexun yudabu babuaibun shinan pepakin ea dananma en jancha chibankin taewaibu pepawen en jatu mekexanaii. Jakia badi ichapa en jancha chibain ikunwanmisbu ja kachukea jabu keskadi en jatu mekekubainxanaii— nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Janua Jerusalén baikidi nun kaya yudan kaian nukubedi buaibun januxun Jesúsun nun jawen 12 tsumabu besti kenaxun tadi paxkabain nuku yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalén anu na jabiatian nun kaidan, man unaiin. Januxun en matun Juchi Kayabi Iyua Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbu tsuanda ea jatu achima ");
INSERT INTO cbsNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jabun ea tenankatsis ikin nawa betsabu ea jatu yunuabu jabun ea kaxe wakin ea kusha kusha akin cruzki mastaxun ea tenanxankanikiki. Ea tenanbu janua mawa xaba dabe inun besti kaya en ana bestenxanaii— nuku waken ");
INSERT INTO cbsNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","chipu Zebedeon bake Santiago inun Juan jatun ewabe kai Jesús besti niaki nukutan jatu jancha waxunun ika ja bebun danti itushiaya ");
INSERT INTO cbsNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesúsun yukakin: —¿Mia jawa medabewapa?— aka jatun ewan jatu yuixunkin: —Min nukun xanen ibuaitianan, na en bake dabe jau mibe xanen ibuxanun min inaitian betsa min yusiudi inun betsa min yusmaudi ea jatu katubain tsaumaxunxanwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","jawen bake dabe uinkin Jesúsun jatu yuikin: —Man jaska ea yukaidan, man unandiamaki. Jawada en tenexanaidan, ¿man idiatidumen?— jatu wa —Nun idiatiduki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesúsun ana jatu yuikin: —Chanima ea ichakawaibu en isin tenexanai keska man idiaxanaii. Jakia en yusiudi inun en yusmaudi tsauntan tsua ebe xanen ibuxanaidan, ibubis en yunutidumaki. En Epa Diosun jatu katunidan, jabudan, ebe ixankanikiki, xanen ibuidan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","janua Santiago inun Juan jaska yuka ikaibu nun jawen 10 tsuma betsabun ninkai nun jatuki sinataya ");
INSERT INTO cbsNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","januxun nun jawen tsumabu betsabu ana nuku xuku watan yuikin: —Jaska nawa xanen ibubun jawenabu ja akin jatu mese wabetanan kushipawen jatu yunumisbu man unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jakia matubunan, jaska shinanyamakubainkanwen. Matu anua tsuada xanen ibukatsis ikinan, jau dasibi matu medabewakin duawakubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jabiaskadiai tsuada xanen ibukatsis ikidan, dasibibun tsuma jau idiakubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jamen ea iki juidan, en matun Juchi Kayabi Iyuabiadan, jau ea duawanunbun ika en juamaki. Jakia matu debuxunkin yuda ichapabu benuabu mexpamatan matu jiwemanun ika en juniki— nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Janua Jericó maewan anu nun jawen tsumabube Jesús jikia ibai nun jabe kainkainaya yudan kainen nuku chibainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","janu bai kaya kexa juni bekun dabe tsauabu Jesús juai juni betsa chaniaibu ninkatan januxun jabun unanxubima yuikin: —Davidin baba Xanen Ibuun, nukuwen nuiwe— akubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ichapabun nemapaibiabu ana unanxubimajaida yuikin: —Davidin baba Xanen Ibuun, min miamenkain, nukuwen nuiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","janua Jesús niti itan juni bekun dabe kena beaibu jatu yukakin: —¿Jawa matu medabewapa?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ja dabetun yuikin: —Xanen Ibuun, ana nun uinun nuku bepexwe ika nun ikaii— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús jatuwen nuikin jatun bedu mekin jatu bepexa jawaida uinkin pewatan Jesús chibanbaini nukube bunibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Janua Jesús Jerusalén anu kai Betfagé anu kemai Olivos Mati tetanbaini Jesús niti itan jawen tsuma dabe ");
INSERT INTO cbsNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","jatu yunukin: —Ja mae besuudi kayanbis buxun burro yuxan tsua jaki katsaumediama jawen bakebe nexea bechitan tepetan ja dabe beyutankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja inun, tsuanda matu yukakin: “¿Jawakatsi man tepebainai?” matu wa yuikin: “Nukun Xanen Ibun nuku yunua nun bixunyuaii, samama jabianudi nuku bemaikikidan”, jatu watankanwen— jatu wa buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","januxun bebunkidi jawen jancha yuixunika Zacarías Diosun yuikin: “Jerusalén anu jiweabu yuikin: ‘Uinkanwen. Matun Xanen Ibu pepa keinsma burro bake kamaki tsaua jikixanikiki’, jatu yuiwe”, aka ninkatan Zacaríasin yuitan keneniki. Jaska yuini menei inun ika jawen tsuma dabe Jesúsun yunua ");
INSERT INTO cbsNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ja dabe kaxun jaska Jesúsun jatu yuia jabiaskadi wakin ");
INSERT INTO cbsNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","burro bakeya bexuanbu nukun bemakia tadi pekatan nun kabekanxuna Jesús jaki inatan katsaumekainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","janua yuda ichapabia jatiditun jatun bemakia tadi bai namaki nabekanbainunbun betsabundi xenpan mextexun jabiaskadi wabainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","jabu bebuaibu inun jachun beaibun benimachakayamabainkin jui kushipawen jawenchains yuibainkin: —Aichu! Aichu! Diosun kushipaya juaidan, benimawakin duawanankanwen. Yavé Dios dasibi binuatun kushipaya nuku mekei juikiki, nukun xenipabu David ipauni keska jawen baba xanen ibujaidaidan. Kenwanankanwen— akubaini bui ");
INSERT INTO cbsNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","janu Jerusalén anu Jesús jikiaya jaskakubainaibu ninkatan uinun ika bei: —Nadan, ¿tsuamen?— ibidan ibidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesúsbe bukin jatu yuikin: —Diosun jancha yuixunika Jesúski. Galilea mai pakeanua jawen mae Nazaretki— jatu akubainaibun, ");
INSERT INTO cbsNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","janua Templo jemaintin kenekauanu Jesús jikikainkin jawen Dios daewati inabu kuamisbu chaxuwan inun, ina awa inun, deiwan inananainbu inun biaibu jatu nichinkin pei janua bianananmisbun tapu nadabekin deiwan inanmisbun jawen kenedi nadabediakin ");
INSERT INTO cbsNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","jatu ja akin yuikin: —Jawen Templokidi jawen jancha yuixunika Isaías Diosun kenemani matu yuinun ninkakanwen. “En jiwedan, janua ebe janchakin ea kenwanxankanikiki”, ibianiken na jiwe jemaintin xabatudu anua man yumetsun jiwe wamisbuki— jatu wakin jatu nichinkin taxnimakin keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","janua ja Templo jemaintin anu bekunbu inun kistsedesnibu Jesús anu iweabu jatu kaya waya ");
INSERT INTO cbsNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbun jaska jawen unanmati damiwai uinkin inun jabianuxundi bake mishtinbun kenwankin: “Davidin baba pepajaidaki”, iki shan shanki ikaibun ninkadiai jaki sinatakin ");
INSERT INTO cbsNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesús yukakin: —¿Mia jaska waibudan, min ninkai?— akabu Jesúsun jatu yuikin: —Jaa. Jabia en ninkaii. Diosun jancha yuixunikabun jaska ekidi kenenibudan, ¿man uindiamamen? Salmoskidi matu yuinun ninkakanwen: ‘Min pepajaidawen taexun bake mishtinbu inun chuchu akaibun mia kenwanxankanikiki’, aka matu kenexuniki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","januxun jatu jenebaini Jerusalén anua kainkaini Betania anu uxatanun ika nun kaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Uxashini bestenkaini Betania anua ana Jerusalénkidi Jesús kai bunikainkin ");
INSERT INTO cbsNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ji betsa higuera benanta tupan bai kexa nia bechitan jawen bimi jayamenkain uintanun ika kaxun jawa bimi jayama jawen peis besti uinkin Jesúsun ji bimiuma yupukin yuikin: —Jau tsuan min bimi ana piyamaxanunbun ana bimitaskayamaxanwen— akaya jaskabiama e iskaun jawen pei nidi iki xanaya ");
INSERT INTO cbsNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","nun jawen tsumabun uin jabaa! iwanan, Jesús yukakin: —¿Jaskai ja ji jawaida xanaimenkain?— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesúsun nuku yuikin: —Chanima en matu yuiaii. Man jadatutunda ea ikunwain shinan dabeyama na ji en axu keska wakin na mati yuikin: “Matipaan, mimebi tsekekain ianenwan medan pukutanwen”, man waya Diosun jaska yunuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ja inun, Diosun kushipa unain shinan dabeyama jabe janchakin yukakubainkanwen. Man jaska wai matu medabewaxanikiki— nuku abaini ");
INSERT INTO cbsNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","janua Templo jemaintin anu jikixun Jesúsun yuda ichapabu kakape yuikin jatu yusianyan Diosbe nukunabu janchaxunika xanen ibubu inun xanen ibu betsabun Jesús nemanun ika bexun yukakin: —Na min eska waidan, ¿tsuan jawen kushipa mia yunuimawen min aki ikai? ¿Tsuan jawen kushipa mia inainmamen, min jaska wanunan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesúsun jatu kemakin: —Entsedi en matu yukai matun dukun ea yui taewakanwen, man ea yuiaya jawada man ea yukai en matu yuidiai ninkakanxunan— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Nashimanika Juan jau jatu nashimanun yunukinan, ¿tsuan kaya yunuyama man shinain, Diosundaka, junibundaka? Ea dukun yuikanwen— jatu wa janua jabudi june yuinamekin: —“Diosun yunuyamaki”, nun wadan, “¿Jaskakin Juanen jancha man ikunwanma ikimamen?” iwanan, nuku kunyan atiduki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jamen Diosun Juan yunuyama yuda midimabun ikunwainbuwen taea jabuki datekin yuikin: “Junibun yunuyamaki”, nun wapanan nun jaska yuitidumaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","jabun Jesús yuikin: —Nun unanmaki— akabu Jesúsun jatu yuidiakin: —Jaskakenan tsuanda jawen kushipawen ea yunuimadan, eandi en matu yuiamaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","jabias xanen ibubu dake wanun, iwanan, Jesúsun miyuiwen ana jatu yuikin: —Juni betsa juni bake dabeyakidi yusintan matu yukanun ninkakanwen— ixun, jatu yuikin: —Jawen bake betsa yunukin: “Epaan, ikis en bai anu dayakin en uva bimi ea tsekaxuntanwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","jawen baken yuikin: “En dayakatsi ikamaki”, ibia janua shinan betsatan bai anu ka dayajaidaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Januxun jawen bake betsa jawen epan bechitan jadi yunukin yuikin: “Miandi en bai anu dayakin en bimi ea tsekaxuntanwen”, aka jawen baken yuikin: “Peki. Ia, en kaii”, ibia kama ikimaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Jaskakenan, ¿matu yukapa? ¿Jadatutun jawen epan yunua ninkatan axuinmamen?— jatu wa —Ja ja dukun yunuimatun ninkakin axuntanimaki— akabu Jesúsun jatu yuikin: —Eskatian chanima en matu yuiaii. Nashimanika Juan taxnimaxun jaskai jiwei peti matu yusinbia jawa matun shinan betsa watan man ikunwanma ikimabuki. Jakia ja gobierno pei bixunika chakabubu inun ainbu jininipabun Juanen jancha ninkakin ikunwainbu uinbiakin matun man shinan betsa wama ikubainshinabuki. Jabiaskadiai natian nawa pei bixunikabu inun ainbu jininipabu Diosun jancha en yusiain jabun ninkaibu Diosun jawenabu jatu waikiki, matu binukinan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ana jatu yuikin: —Miyui betsawen matu ana yusinun ninkakanwen. Xanen ibu betsan bai waxun uva bimi batapa banatan mishkiwen dakenbaunkin keyutan janua jaki uva tsiniti watan januxun dasibi uinbaunti jiwe pishta keyatapa watan januxun jau bimi dabukun ea inanxanunbun, iwanan, juni betsa dayakapabube jabube yubakatan ibu keska wakin inanyubaini chai kaimaken ");
INSERT INTO cbsNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","janu ma kani tsekatitian ikaya bai ibuan jawena dabukun jau yukatan bixuntanun, iwanan, jawen tsuma betsabu yunua buabu ");
INSERT INTO cbsNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","jabun jawena inankatsi ikama uva bimi mekeabun jawen tsumabu betsa achixun kusha kusha atan betsa debu watan betsa mishkiwen tsaka tsaka atan jawa inanma nichianbu ");
INSERT INTO cbsNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","januxun bai ibuan ana jawen tsuma betsabu yunudia buabun jabun uva mekexunabun jawen tsuma tibi buabu jabiaskas jatu wabu mais bebidan bebidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","januxun tsua ana yunutima jawen bake bechipaijaidabiakin atimas yunukin shinankin: “En bake en yunua ka jaki mesekin en bimi ea inantidubuki”, iwanan, yunua ka ");
INSERT INTO cbsNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","jawen bake jatuki kemai kai bechitan yuinamei: “Bai ibu mawashinken na jawen baken jawen bai tibi inun jawen jiwe tibi dasibi jawenawayuikiki. Na bai nukunas nun wanun tenanankanwen”, ixun ");
INSERT INTO cbsNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","juai achixun bai kene anua kainmaxun tenanshinabuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesúsun jatu yukakin: —¿Jawenabu jaskawanshinabunan, ja bai ibu juxun jaskada jatu waxanimenkain?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","jabundi Jesús yuikin: —Bai ibu juxun ja dayakapabu chakabubu jawa jatuwen nuiama jawenabubetan jatu tenantan januxun dayakapa betsabu yunukin jau jabun en bimi dabukun ea inanxanunbun, iwanan, yunutiduki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesúsun ana jatu yuikin: —Diosun jancha kenenibu ¿yuikin man uinsmamen? Matu ana yusinun ninkakanwen: ‘Jiwe wanikabun mishki dananbiaibun jabias mishki Diosun bixun dexun makedex wakin jawen kene mestenwan keska wakin nuku uinmakin jabaa! imakin nuku jadakidi shinantima waxanikiki’, axun keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jaska keneni keska wakin matun xenipabu Diosun katubianixun man jawenabubiatun shinanma man danananyan januxun yuda betsabundi ninkakatsi ikaibu Diosun katutan jatu jabe xanen ibumaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ja inun, betsadan, tsuada ja mishkiki sinatakin ea maemanun ika mishki mamaki kauana teke teke ika keska itiduki. Jakia ja mishki jadatukida kauani jaki tin ikin chushakin mishpu waxanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Diosbe nukunabu janchaxunika xanen ibubu inun fariseobun na miyuiwen jabukidi yusiain ninkatan ");
INSERT INTO cbsNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jesús achikatsis ibiai yudan kaianen: “Jesús Diosun jancha yuixunikaki”, ikaibuki datekin jawa achiyuabumaken ");
INSERT INTO cbsNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","januxun Jesúsun miyui betsawen ana jatu yusinkin: ");
INSERT INTO cbsNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jaskai Dios xanen ibumiskidi ana matu yusinun ninkakanwen. Xanen ibujaidatun jawen juni bake ainyanwankatsi jawenabu xanen ibu betsa betsapa jau jabe nawai besi benunbun, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","jawen tsumabun jau jatu itanunbun jatu yunua buxun jatu yuibiatanabu beabumaken ");
INSERT INTO cbsNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ana jawen tsuma betsabu yunukin: “En jatu ikatsis ikaidan, eska ea yuixuntankanwen: ‘Nukun tsumapan ina awa inun jawen yuinaka ina tibi xuadanwan detexun ma matu bawakin xui pewaxunabuki. Jaskaken jawen bakebe nawai bekanwen’, ea jatu waxuntankanwen”, jatu wa bui jatuki chanikubaunbiabu ");
INSERT INTO cbsNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","jawa bekatsi ikama betsa jawen bai anu katanun betsa jawen mabu jiwe anu dayai kaken ");
INSERT INTO cbsNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","januxun jatiditun xanen ibun tsumabu achixun ichakawakin betsabu jatu tenainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","janua xanen ibu sinatajaidakin jau jawen soldadobun ja sinatapabu tenantan jatun mae tibi jau kuabauntanunbun jatu yunutan ");
INSERT INTO cbsNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","januxun jawen tsuma betsabu yuikin: “Janu nawati ma dasibi pewabuki. Jakia en jatu chanimashina chakabui beabumaken en ana jatu ikatsi ikamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jaskaken ja bai puchinin jiwekubainabu anu bui jatuki nukuxun jau nawai benunbun jatu yuidiatankanwen”, jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","bui bai tanabaini jatuki nukuaibu tibi jatu yuikubainkin chakabubu inun pepabu jatu kenatan jatube ichai jiwe teke xaka betsa anu junin kaian texke ikabun ");
INSERT INTO cbsNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","janua jatun xanen ibujaida juxun jikikain nawaibu uinkin juni betsa jaya nawati tadi danankin saweama bechitan ");
INSERT INTO cbsNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","yuikin: “Baa, en tadi jaya nawati ¿jaskakin min saweama jikiamen?” aka dakei jawa janchamaken ");
INSERT INTO cbsNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","januxun xanen ibun ja jabun jatu piti inainbu jatu yuikin: “Na juni chakabu junexkin menextan bukin janu meshujaida medan udentankanwen, jau jadi jiwea bika tenei kaxai xeta yenx yenx axanunan”, jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dios xanen ibuaitianan, jabiaskadi waxanikiki. Ichapabu Diosun jatu kenabiapakeaya ichapamatun ninkatan ikunwainbu ja jawenawakin jatu katumiski— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","janua fariseobu Jesúsun jatu jaska yuia ninkatan bua: “Jawawen taexun jaska waxun Jesús padantan Romano xanen ibu anuxun nun chitetidumenkain”, ika yubakatan ");
INSERT INTO cbsNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","januxun jatuki chiti ika betsabu inun xanen ibu Herodeski chiti ika betsabudi jau Jesús unanti watanunbun jatu yunuabu Jesús anu buxun yuikin: —Yusinaan, juni betsabu miki sinatabiaibun jawa jatuki dakekin jabu daewama chanima jancha besti yusinkin jaska wakin Dios chibantidubu besti min xabakabi jatu yusinkubainmis nun unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jaskawen taexunan, ¿jaskada min shinainmenkain mia yukapa? Ja Romano xanen ibu Césarn nuku pei yukamisdan, ¿jaska wananxanpa? ¿Pakananxanpa? ¿Pakatimadaka?— aki ");
INSERT INTO cbsNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","jaki bepadameaibu Jesúsun unankin jatu yuikin: —¿Bepadamenikabuun, jancha pewen man ea bepadanun ika ikanai? ");
INSERT INTO cbsNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jawen gobierno impuesto pakati pei jexe betsa ea uinmakanwen— jatu wa jawen pakamisbu pei jexe betsa bexun tsumaxun uinmabu ");
INSERT INTO cbsNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","uinkin Jesúsun jatu yukakin: —Nadan, ¿tsuan besu inun tsuan kena neamen? Ea yuikanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","jabun yuikin: —Romano xanen ibu Césarnaki— akabu januxun Jesúsundi jatu yuikin: —Césarnawen taexun matun xanen ibu César duawakin jawen gobierno dayaxunmisbu pei jatu inanxunkubainkanwen. Jakia Diosdi duawakin jawen yusian chibankin jawada bechipaiai axundiakubainkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ninkai e itan: —Nun jaska waxun padantidumaki— itan jenebaini dabekebainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","janua saduceobu judiobu paxka betsa: “Ja mawabu jawen yuda tsua ana besteinsmaki”, imisbu Jesús anu jabudi bexun yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Yusinaan, Moisin yusinkin: “Juni betsa ainyanbia juni bakewadiama mawaken janua jawen betsan ain janubi ainwantan juni bakewaxuntiki, jawen betsa mawaimatun kena dabikin jawena waxunkinan”, nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jaskakidi ja jawen 7 betsabukidi mia yuinun ninkawe. Ja dukun iyuatun ainbu betsa ainwanxun juni bakewadiama mawaken ");
INSERT INTO cbsNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ja kachukeatun jawen betsan jabias ainwanxun juni bake wadiamadi mawaken ana ja kachukeatun jawen betsan ain jabiadi ainwandiatan juni bake wadiamadi mawaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Janua ja 7 jawen jenekin jabias ainbudi bixun jabu tibitun jawa juni bake wabuma mawai keyuabun janua jawen jenei ainbu juni bake biamas mawadianiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ja jaskanibudan, mawabu ana besteainbutian ¿ja ainbu bestichai ja juni 7bun ainwanibudan, jadatutun kaya ana ja ainbu bixanimenkain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesúsun jatu kemakin: —Matunan, Diosun jancha kenenibu unanma jawen kushipa man unanmadiki. Jaska wakin man kanemiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Xabakabi matu shinanmanun ninkakanwen. Mawanibu ana bestenxanaibutianan, jawa ana ainyain inun ana beneyai ikama ixankanikiki. Jadia Diosun nai tsumabu keska beneuma inun ainyuma jiwexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Mawakubainaibu bestein ana jiwexanaibukidi matu shinanmanun ninkakanwen. Ji maxu kua jede ji ikai anuxun Diosun Moisés jancha wakin: “Eadan, natian en Abrahamnen mekenikaki. En Isaacun mekenikaki. En Jacobun mekenikadiki”, ikai ninkayamaxun Moisin kenenidan, ¿man uinkin yuismamen? Diosdan, mawabunamaki. Jakia jiweabunaki. Jaskaken Abraham inun Isaac inun Jacob jatun yushin jiweabuki. Chipu ana yuda bena Diosun jatu inanxanai shinanma man kanejaidamiski— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesús saduceobube yuinameai yudan kaianen ninkabaikin Jesús jaskakidi yukabu jatu yui pewaxukidi ninkai “Jabaa!” ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","januxun saduceobun Jesús yukabu jatu yusinkin jatun bepadanti jancha jatu nesewawen taea jawa ana yuiama mapuabun janua fariseobundi ninkatan jabudi icha yubakanametan ");
INSERT INTO cbsNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","jabundi unanti wanun ika yuinamebidan Jesús anu buxun jabu betsa Diosun jancha kenenibu yusinananmis betsan unanti wanun iwanan, yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Yusinaan, ¿jadatu yunua kushipa binua Moisin nuku kenexuniwen besti nun chibainwen taexun Diosun nuku mekekubaintidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesúsun yuikin: —Na eska yununi betsa betsapa tibi dasibi binujaidadan, na janchaki ninkawe. “Yavé min Mekenika Dios duawakin bechipaikin min juinti jidabiwen inun, min yushin jidabiwen inun, min shinan jidabiwen chibankin duawakubainwen”, ani ");
INSERT INTO cbsNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","chibankin na eska bestiwen min Dios benimajaida wakubaintiduki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ja inun, ana ja kachu yunua betsadan, jabiaska dabeski. Ninkawe: “Min jabube jiweabu duawadiakubainkanwen, ibubis man nui mekemis keskaidan”, ");
INSERT INTO cbsNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ani ja dabe chibain man jaki chiti imiswen taea dasibi Diosun yunua Moisin keneni inun Diosun jancha yuixunikabun kenenibu jaki tsamia keskawen taea ja chibankin dasibi man shinandiatidubuki— atan ");
INSERT INTO cbsNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","janu Templo jemaintin anu fariseobu icha budiabumaken ");
INSERT INTO cbsNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesúsun jatu yukakin: —Nukun Mekenika Mesías Cristokididan, ¿jaskada jakidi man shinanmismen? ¿Tsuan babamen?— jatu wa jabun yuikin: —Davidin baba ixanikiaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesúsun ana jatu yuikin: —Diosun Yushin Pepatun David yusian ninkatan ¿jaskakin jawen Mekenika Mesías Xanen Ibu wanimen? Matu yuinun ninkakanwen. Davidin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Dios Mekenikatun en Xanen Ibu Mesías yuikin: ‘Miki sinataibu en jatu maemadiama manai en yusiudi tsauyuwe’ ”, aniki. Jaska watan keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Mesías en xanen ibuki”, Davidin abianiken ¿jaskatan jawen xanen ibu janubi jawen baba itidumen? Ea yuikanwen— akin jatu unantimaska wa ");
INSERT INTO cbsNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","januxun tsuan jawa ana jancha betsa yuitiduamajaida dakekin jawen bepadankin yukatiwen ana jawenchains jawa yukama nesea mapuabun ");
INSERT INTO cbsNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","januxun judio xanen ibubun ninkadiaibun Jesúsun yuda ichapabu inun jawen tsumabu ana nuku yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Diosun jancha kenenibu yusinananmisbu inun fariseobun Moisin jancha keneni matu yusinkin chanima jancha kaneama matu yuimisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaska matu yusinmisbu jatun jancha pe chibankin jakia jatunmebi kein bepadamemisbudan, ja jatu mawayamakubainkanwen. Pe matu yuibiatan ibubis kanekubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jaskawen taexun jabunan, xankamajaida matu iama keska wakin yusian tsuan chibantiduma matu yusinbiakin jabias yusian jabundi chibantidubumaki, jaska matu yusiainbu keska jiwekin matu uinmamadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ja inun, “Diosun jancha en chibanjaidai uinkin dasibibun jau ea kenwanunbun”, ika tadi chaipa dauya panan pananyan sawetan Diosun jancha kene bichi bau pishtaki nanea bichiwen nexea betunku anu sawekin netantan punti anudi netandiatan jau ea uinunbun ika jatu kenwanmai mapumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ja inun, pi ichaxun xanen ibu dapixun pinun, iwanan, benamisbuki. Ja inun, janu ichati jiwe anu jikikain jaki tsauti pepa janu dasibibun jatu uintidubu anu tsaukatsis imisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ja inun, bai xexa tibi mapua mabu inanananmisbu anuxun: “Yusinaan, akin jau ea duawanunbun”, ika mapumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jakia matudan, jabu ikai keska iyamaxankanwen. Yudabu kenamakinan, jakia matun yusinanan bestichaiki. Ja ikunwain man jawen betsabu inun jawen puibu bestiki. Jaskawen taexun “Yusinaan”, akin jau matu kenayamaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ja inun, mai anu jiweabu binu keyua nai anu medabenan Yushin Epa Dios bestichai jiwea man jayawen taexun juni betsa Dios itsa wakin: “Epaan”, akin kenayamakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ja inun, Diosun Katua Cristo ja besti matun tapinmanikaki. Jaskawen taexun: “Tapinmanikaan”, akin jau matu kenayamanunbun Dioskidi yusinkin jatu mikidi kenwanmayamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Jakia tsuada natian keanma Diosun jatu duawakin xanen ibujaidawaxanikiki. Ja inun, tsuada natian ibubis kein xanen ibukatsis imisbu Diosun jatu dake wakin ana xanen ibu wama ixanikiki. Jaskawen taea matudan, tsuada keanma duapakin dasibi man jatu medabewakubainmiswen taeadan, man xanen ibu ixanaii— akin nuku yuitan ");
INSERT INTO cbsNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","nasaukei dabeketan betsabudi metukin yuikin: —Diosun jancha kenenibu yusinananmisbu inun fariseobu man bepadamebuun, man peidawa! Diosun jancha jawen jiweti unanbiai ninka pewama tsuabuda Dios xanen ibuai anu jikikatsi ikaibu man jatu nemamiski. Matudi man jikitidumabia jabu betsabu jikipananbun man jatu nemakubainaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Janua matudan, Diosun jancha kenenibu yusinananmisbu inun fariseobu man bepadamebuun, main bukin ianenwan pukebaini buxun nawa betsa matu keska judio wanun ixun jatun shinan betsa wamakin jatu ikunwanmanun, iwanan, matun beya midima man jatu tapinmakin matun chakabu man jatu binumaibuwen taexun Diosun jatu kupijaidakin chi medan jatu udean jiwechakaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Janua matudan, matu bekun keskatun jatu yusinchakakin yuikin: “Chanima Templo Diosun shinanmis keska wakin en mia padanmaki, akin tsuada yubabiatan jawen yuba akama jawen nuiama peki”, akin man jatu yusinmiski. Jakia “Jawen Templo medanua oro pei Diosun shinanmis keska wakin en mia padanmaki, akin tsuada jaska yubatan jawen yuba jau anunwen. Jawen yuba jancha akamadan, chakabujaidaki”, akin man jatu yusinmiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Man bekun keskabu inun man unainsmapabuki. ¿Jadatu Diosun bechipaimismen? ¿Peimen? ¿Jawen Templodaka? Matu yuinun ninkaidakanwen. Jawen Templo anuxun yudabun Dios kenwanmisbuwen taea jabun pei shinanma jawen kenwanti Templo besti shinankin Diosun bechipaimiski— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Jamen ana betsa jatu yusinkinan: “Chanima jawen kenwanti chi tapu Diosun shinanmis keska wakin chani chakakin en mia padanmaki, akin tsuada yubabiatan chipu padananainan, man jawen nuiama peki”, akin man jatu yuimiski. Jakia: “Jawen kenwanti chi tapu anu inan kuin betsa betsapa Diosbe nukunabu janchaxunikabun manchintan jatu kuaxunmisbudan, Diosun shinanmis keska wakin chani chakakin en mia padanmaki, akin tsuada jaska yubatan jawen yuba jau anunwen. Jakia yuba jancha akamadan, chakabujaidaki”, akin man jatu yusindiamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bekun keska unainsmapabuun, ¿jadatu Diosun bechipaimismen? ¿Inankuin mania bestimenkain? ¿Januxun kuakin Dios benimawamisbu tapudaka? ");
INSERT INTO cbsNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Matu yuinun ninkakanwen. Tsuada jawen kenwanti chi tapukidi yubakakin jawen inankuinkidi dasibi man yubakadiamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ja inun, tsuada Templokidi yubakai Dios janu jiweakidi man yubakadiamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ja inun, tsuada naikidi yubakai janu Dios jiwea inun Diosun dasibi mekei tsaua xanen ibumiskidi man yubakadiamisbuki. Bepadamei man jaskamiswen taexun Diosun matu kupiaitian man nuitapajaidaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Diosun jancha kenenibu yusinananmisbu inun fariseobu man bepadamemisbuun, man peidawa! Matun piti niswati tibi ichawaxun meken dabeti manchinwantan Diosbe nukunabu janchaxunika manchin betsa inanbiakubainmis jaska Diosun jancha Moisin yusini man shinanma jawada jawen pepawati inun jawen nuiti inun jawen jancha betsa watima yunubianiken matubu jawen jiwekin man jatu uinmaismaki, kanekinan. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bekun keska unainsmapakin matunabun chakabu pexepishta shiu tiubiaken uinkin man jatu yusinmiski, jatu pewanun, iwananan. Jakia matun chakabu ewapa camello tiubiaken matun chakabu jawa shinanma man jawa uin e itan jeneismaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","Diosun jancha kenenibu yusinananmisbu inun fariseobu man bepadamebuun, man peidawa! Matun beya chibankin matun kencha tibi bemakis besti dachukin man napan pewamisbuki. Jakia bepadamekin yumetsui yaushikin jamapai chakabu tibi wai matun shinan man pewaisbumaki. Fariseobu bekun keskabuun, ja dukun matun shinan chakabu uke medanua pewakin taewakanwen, matun kencha tibi man bemakisa dachukin man amis keska wakinan. Jaskatan man jiwei pekunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Janua matudan, Diosun jancha kenenibu yusinananmisbu inun fariseobu bepadamemisbuun, junibun pewakin janu mawabu maiwamisbu mishki tanpe jawendua wanun, iwanan, bemakis juxupawen dapuxmisbuki. Jakia uke medan xau inun nami chapui pisi maiai mania tsuan meisbuma ");
INSERT INTO cbsNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","keskai matudi bepadamekin yudabu uinmai bemakis jawendua bestitan padananankin matun shinan chakabu man jenekin pewaisbumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Janua matudan, Diosun jancha kenenibu yusinananmisbu inun fariseobu bepadamemisbuun, Diosun jancha yuixunikabu inun yuda pepa betsabu mawanibun januxun ana jawen xau adukatsi maiwati tanpe pepa waxun jawen shinanmati jawendua wakin man dami waxun netanbaunmiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ja inun, matun yuikin: “Nukun xenipabun Diosun jancha yuixunikabu tenanibu nukudi jiwexun nukun xenipabu nun jatu medabewama ikeanaii”, man imiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jawa unanmabia yuikin: “En xenipabun Diosun jancha yuixunikabu tenanibuki”, man imiski, jawa dakeamadan. Jaskaken man detenan bababuki, jatu keskadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Matun xenipabun chakabuwakin taewanibuwen taexun man jabun bababun jabiaskadi wakin jatu menexunxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jamen matudan, man padanan dunu pianan keskabuwen taexun Diosun matu kupijaidakin chi medan matu udean man jawawen taea paxatidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jaskawen taexun matu medabewanun ixun ea ikunwain Diosun jancha yuixunika inun unanepabu inun yusinananmis pepabu jau yusin benunbun en yunuxanaii. En jaska wabiaken matun jatu danankin betsabu tenankin bestibu cruzki jatu mastamakin betsabu matun ichati jiwe medanxun kusha kusha akin mae tibi anuxun man jatu ichakawakin bika tenemaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Man jatu jaska waxanaibuwen taexun bebunkidi matun xenipabun Adánen bake betsa Abel juni pepa tenanixun januxun juni pepa betsabu jatuki sinatakin tenankubidankin jawen jenekin Berequíasin bake Zacarías na jabia Templo jemaintin anu chi tapu dapikea tenanibuwen taexun matudi Diosun kupixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Chanima en matu yuiaii. Matun xenipabun jatu tenanibu keska shinankin jabun chakabuwen taexun na jabiatian Israelbu dasibi matube jiweabu Diosun jatudi kupixanikiki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","yudabu uinbaunkin Jesúsun jatu yuikin: —Jerusalén anu jiweabuun, Jerusalén anu jiweabuun, Diosun jancha yuixunikabu inun jawen jancha jatu bana bexunpakeaibu Diosun jatu yunubiaya jatu danankin jatu tenankin matun xenipabun anibu keska wakin mishkiwen man jatu tsaka tsaka amisbuki. Takadan jawen bake nuxamis keska wakin eandi matu medabewakin matu mekenun ika en jubianiken jaska shinanma ea danankin man ea jawa ninkamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Uinkanwen. Matun mae matun mesti man mekenun Diosun matu jenexanikiki, ana Jerusalén mekeamadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jakia janu en ana juaitian: “Yavé Diosun kushipaya juaidan”, ikin man yuidiamadan, man ana ea uinyuama ixankanaii— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","janua Jesús Templo jemaintin anua kainkainaya nun jawen tsumabu jaki nukubainkin yuikin: “Na Dios kenwanti Templodan, jabi jawendua benibin!” nun ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","nuku yuikin: —Chanimaki. Na mishki jiwe ewapa jawendua wanibu man uiainan, jawenduabia jabianu mishki betsa ana matsama dasibi ja mishki jiwe tekekin pudekin keyuxankanikiki— nuku wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olivos Mati anu mapeketan Jesús tadi ka tsauken nun jawen tsumabun june yukakin: —Ja mishki jiwe tekekin pudekin keyuxanaibu min nuku yuixudan, ¿mia yukapa? ¿min ma mai jidabi jawen jenei keyuaitian min ana juaxanai kemai taeai jaskai nun unantidumenkain? Nuku yuiwe— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","8","nuku yuikin: —En ka en ana judiamaken eskai nuitapai taexanaibu Diosun yununi eskaxankanikiki. Xabakabi matu yuinun ninkakanwen. En kani ma en janu jua kemaya juni betsa betsapa bexun yuikin: “En Diosun Katua Mesías Cristoki”, iwanan, yuda ichapabu jatu padanxankanikiki. Jau tsuabuda jaskadiakidan matu padanyamaxanunbun uindaxankanwen. Ja inun, yudabu nuitapai taeaitianan, nawabu nawa betsabube detenamei inun tsakanamea akeakeaibu mai pacha sakua akeakeaya bunijaidai nuitapaibun isin betsa betsapa tenea akeakexankanikiki. Jakia tsakanamea akeakeaibukidi bana ninkai datei meseyamaxankanwen, na jaskaidan, isin betsa beai mekin man uinxanai keska bebunkidi xabakabi en matu banabimaidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Januxun man ea ikunwainbuwen taexun matu ichakawakin matu bestibu tibi tenankin mai jidabi anuxun ewen taea matuki sinatakin matu dananxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Matu jaska waibutian ichapabun ea chibain bexteketan januxun ikunwainbu betsabu danankin jatu achima akeakexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Janu jaskaibutian juni ichapabu bexun yuikin: “Diosun jancha matu yusinun ea ninkakanwen”, ikin chani chakakin yuda ichapabu jatu padanxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ja inun, ikunwainbu ichapabu nawabun jatu ichakawachakayamaibun ikunwain betsabu ana bechipainamei nuiama ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Matu jaska wabiaibun tsuanda ea chibankin jeneisma jatu mekekin en jatu paxawaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja inun, betsadan, nawa dasibibun jau ekidi unanunbun en ana judiamaken yudabu mania akeakeabu dasibibu tsuabunda en kakapekidi jabun jatu yusinkubaunxankanikiki. Nawa xukua tibibun jau kakape ekidi ninkanunbun jatu yusinkin menetanaibuns en ana juxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jaska man unanxanun ja Dios danantan chakabu kenwainbukidi Diosun jawen jancha yuixunika Daniel yuia ninkatan bebunkidi keneni matu yusinun ninkakanwen— iwanan, ea en Mateon matu kenexunai tsuanda na jancha uinkin tapinkanwen, eska Jesúsun ana yuikubainkin: —Danielin jaska waken Templo jemaintin anu jaska Diosun dananmis ja dami itsa taxnia nia bechitan ");
INSERT INTO cbsNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ja Judea anuxun ikunwainbu ja mati keyatapa anu jau paxaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ja inun, betsabu na mai bawa jiwe sapa xeni manaundi maniabudan, butuxun jawen jamapai bikatsis ibiakin jau jawen jiwe anu jikiama jau jawaida paxadiaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ja inun, ikunwain ja bai anu dayaibudan, meshu medan jawen dakukuti bikatsis ibiai jau ana chintunbidanama jau jabiadiadi paxadiaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jamen ja yumainbutianan, tuyabu inun ja chuchu amamisbudan, nuitapajaidaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Jaska inun, Diosun mai damiwani anua yumainbutian jaskaxanai anu tsuan jaska tenediama inun ana teneama ixanai tenei dasibibu nuitapa chakayamaxankanikiki. Jaskaxanaiwen taea jau uitian inun juindukuntitian man paxayamaxanunbun Dios ea akin yukakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja jaskaibutian Diosun jawa nemakin tsua paxawatidumabia ma jawenabu jatu katuniwen taexun jatuwen nuikin jau dasibibu debui keyuyamaxanunbun yumainbutian Diosun badi ana chai wama chaima xekaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","25","Jabiatiandi juni betsabu juxun jatu padankin yuikin: “Eadan, Diosun ea yunua en jawen jancha yuixunikaki. Ea ninkaidakanwen”, ikaibun betsabundi yuikin: “Eadan, Diosun Mesías Cristo matu anu ana en juxuki”, ikaibu betsabun ninkatan jatu yuikin: “Uian. Nuku anu Cristo ma juxukiaki”, ikaibu ninkatan ana betsabun yuikin: “Uian. Janu ma juxukiaki, Cristodan”, ikaibun januxun jabun jamapai betsa betsapa yuda betsabun atidubuma jabun akin yuda ichapa padankin Diosun jawena wakin jatu katudiani padankatsis idiaxankanikiki. Jaskaibu ninkatan ikunwankin man kaneyamaxanunbun bebunkidi xabakabi ja padanananxanaibukidi en matu besuunbi bana bimai ninkakanwen ");
INSERT INTO cbsNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaskaken padanun, iwanan, matu yuikin: “Uian. Unu janu tsua jiweabumanu Cristo ma juaki”, ikaibun buyamaxankanwen. Ja inun, matu padanun, iwanan, matu yuikin: “Uian. Cristodan, nenu dintu medan juneaki”, ikaibu jawa ikunwanyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jakia en matun Juchi Kayabi Iyua en ana eskakidanxanai matu yuinun ninkakanwen. Jawaida uke bukun kana bedi iki bakamis keskatan en ana juai dasibibun ea uinxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Janu yuda mawa daka pisi mayai xeten xetebidan janu ichai nuyabaunmis keskai ixankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","januxun nuku yusinkin menediama ana nuku yuikin: —Yumain keyuaibu binukainaya nai anua dasibi betsa betsapaxanikiki. Badi ana pexeama nukai taeaya uxedi ana chaxama meshuaya bishi nidi iki keyui dasibi nai taka taka iki chuduanyan ");
INSERT INTO cbsNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","nai anua jaskai yudabun uin mai jidabi anua datejaidai kaxai keyubaunaibun en matun Juchi Kayabi Iyua xanen ibui kushipajaidai chaxajaida nai anua nai kuin medanua en juai uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Diosun jawen nai tsumabu yunua jawen trompeta chaan akin jawen katuabu mai jidabi anu manibaunabu jatu ichawaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jaskaken higuera jiwen man unantidubukidi miyuiwen ana matu yusinun ninkakanwen. Ji mebi jawen pei petakatan metubistan peiyai uinkin ma badi kemai man unanmis keskai ");
INSERT INTO cbsNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","jawada en matu yuixu bechitan en samama juai man unanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jaska inun, yudabu dasibi jiwebaunabu yamadiabuma chanima dasibi en matu yuixu jaskai taexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jakia jabiaskadiai nai anua inun mai anua Diosun damiwani jabu keyuxankanikiki. Jakia en janchawen bebunkidi en matu yusiainan, binuama menepakexanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Janua jawatianda en ana juxanai tsuan unanmaki. Diosun nai tsumabun unanma inun ea Diosun baken en jawa unanmadiki. Jakia Epa Dios ja bestitun unainkiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jaska inun, Noé jiweken chakabui jiwekubainibu keskadiaibun matun Juchi Kayabi Iyua en ana chintunkidanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Eskanibuki. Jawen nunutiwen Noé jikidiamaken yudabun pikin mabex aki ainyankin jatun bakebu beneyawakin Dioskidi jawa shinanma jiwekubainaibu Diosun yunua Noén chibain jawenabubes jawen nunuti menetan jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","jenen jatu achiaya Diosun yunua ninkaisbuma jatunmebi debui jasai keyunibuki. Jabiaskadiai matun Juchi Kayabi Iyua en juai yudan kaianen ea shinankin manabumaken en jatu jaskadi wakin kupixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ja inun, na jabiatian bai anu juni dabe dayaibu betsan ea chibanmis iyukin betsan ea chibainsma Diosun nai tsuman jenebainxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ja inun, ainbu dabetan deneaibu betsan ea chibanmis iyukin betsan ea chibainsma jenediabainxanikiki. Jaska wakin Diosun nai tsumabun bestibu jatu katuxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jaskaken jatianda en ana juxanai man unanmabia jawa chikishama ea manakakin jeneyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ja inun, chanima jatiada yumetsu juai bebunkidi unankin jiwe ibun bextekatsi manatiduki, jau jikiyamanunan. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaska keskadiai jatianda en matun Juchi Kayabi Iyua en ana juxanai tsuan unanmaken matunan, matun jiwea pewakin keyutan ea manakubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","januxun nuku shinanmakin nun jawen tsumabu nuku ana yusinkin: —Xanen ibu chai kakin jawen tsuma unanepa yunubainmiskidi matu yuinun ninkakanwen. Jawen tsuma betsabu pimakin jau jawen jiwe mekexunkubainun jatun xanen ibun jawen tsuma unanepa yunubainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Janua xanen ibu ana chintunkidan jaska yunubainima axunkubainaya ja xanen ibu jaki nukutushitan benimajaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Chanima ja xanen ibun jawen tsuma dasibi jawen jamapai mekemaxanikiki, jawen jiwe inun, jawen bai betsa betsapa inun, jawen inabu inun, jawen tsumabu betsadan. ");
INSERT INTO cbsNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jakia jawen tsuma shinan pema ja xanen ibun yunubainima shinanchakakin yuikin: “En xanen ibu yane juamaki. Uatian jui kaimenkain”, iki ");
INSERT INTO cbsNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dayanika betsabu juni inun ainbu ichakawai inun nawachakayamai paenkin ");
INSERT INTO cbsNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","jatian jawen xanen ibu juai shinankin manama xanen ibu jui jikitushitan ");
INSERT INTO cbsNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","manaka chakabube kupijaidaxanikiki, bepadamemisbubetan jau bika tenejaidai kaxai xeta yenx yenx anunan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","januxun miyui betsawen nuku ana yusinkin yuikin: —Dios xanen ibui jaskaxanaikidi matu ana yusinun ninkakanwen. Chipashbu meken dabetibun jatun bin dekutan jatun jaibu beneyai anu jaki jabe nukui kakatsi jawen bene juai jaki nukutan iyuxunun ika bai puchinin jaki nukui ka maniabu keskanu Dios xanen ibuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Janua ja chipash meken besti bebunkidi unanepakin jatun bin dekua inun netsuai ana maneti bishtu betsa jayabun janua ja chipash betsa meken besti unanepama jatun bin dekua besti netsua jawa ana maneti jayabumaken ");
INSERT INTO cbsNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","janua ja juni jatuki nukuti washina binuaya manachakayamashinaibun ja chipash meken dabeti uxabun ");
INSERT INTO cbsNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","atimas juni ja manaibu yamenapun juai tsuanda ninkatan jatu bestenwankin unanxubima yuikin: “Jawen bene man manaidan, ma juikiki. Iyuxunditankanwen”, jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","dasibi bestenbaun jatun bin ma nuka kemai bin jene manenun, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ja chipash meken besti unainsmapabun ja bebunkidi unanepabu jatu ea akin yuikin: “Jau nukun bin nukayamadianun matun bin jene nuku tusaxunyukanwen”, jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","jakia ja chipash unanepabun jatu yuikin: “Jaskamaki. Matuna nun matu manexunken nukunadi netsui nukatiduki. Jaskakenan, buxun janua bin jene inanmisbu anua bitankanwen, matuna ibubisdan”, jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ja unaismapabun bin jene bi jamakidi buabun jatumaki jatun jaibun bene juai ja chipash unanepabun itani jua jabe nawai jikiabun januxun beputi ma bepuabun ");
INSERT INTO cbsNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","janua ja kachu ja chipash unanepama bexun jatu kenakin yuikin: “Xanen ibuun, nun mibe jikiai nuku bepenxunwen”, akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","jatu yuikin: “Jaskamaki. Man ea manakakin pewama ixuki. Man tsuabumenkain, en matu unanmaki”, jatu waxanikiki— nuku watan, ");
INSERT INTO cbsNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—Na miyuidan, ¿jaska man ninkaxumen? En matun Juchi Kayabi Iyua jatianda en ana juxanai tsuan man unanmawen taea tsuada ebe jiwekatsi iki unanepai jawa chikishama pepakunkaini Diosbe janchakin ea manakin uindakubainxankanwen— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","januxun miyui betsawen Jesúsun nuku ana yusinkin: —Dios xanen ibui jaskaxanaikidi betsa matu ana yuinun ninkakanwen. Dios xanen ibuidan, juni chai ka keska ixanikiki. Juni betsa mai pakea betsa anu katanun, iwanan, jawen tsumabu kenaxun jau jawen taea dayanunbun jawen pei tanaxun paxkatan jatu inanyukin ");
INSERT INTO cbsNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","jawen tsuma unanepa betsa jawen pei ja dukun inankin pei jexe ichapa 5,000 inantan ja kachu unanepa bexmas pei jexe ichapadi 2,000 inandiatan janua jawen tsuma betsa unanepa midin 1,000 inandiatan chai kashinken ");
INSERT INTO cbsNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ja unanepa 5,000 inanbainshina jawa chikishama dayai inananankin ana 5,000 jawen xanen ibu bixunkubainkin ichawaxunaya ");
INSERT INTO cbsNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ja unanepa bexmas 2,000 inanbainshinadi jabiaskadi dayaxunkin ana 2,000 jawen xanen ibu bixunkubainkin ichawaxunaya ");
INSERT INTO cbsNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","jakia ja 1,000 besti inanbainshinadi chikishi jawa dayaxunkatsi ikama june mai pukinxun janu jawen xanen ibun pei adukin bepukin pewaxunshinken ");
INSERT INTO cbsNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","janua jatun xanen ibu badi ichapa jiwetani juxun jawen tsumabu jawen pei inanbaini: “En pei ea jaskawanyamabumenkain uinun”, iwanan, jatubetan pewakatsi jatu kena ");
INSERT INTO cbsNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ja 5,000 inanbainyama ja dukun juxun pei ichawaxunkubainshina bexun inankin yuikin: “Xanen ibuun, 5,000 min ea inanbainyamadan, inananankin ana 5,000 en mia bixunkubainshinadan, naki”, akin 10,000 inanyan ");
INSERT INTO cbsNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","jawen xanen ibun yuikin: “Min en tsuma pejaida kaneismaki. Eskadabes en mia yunubiabaini inananankin jawa benuama min pe mekekin kaneama ishianwen taexun ana daya ichapa en mia yunuxanaii. Jaskawen taea natian ebe benimachakayamadiwe”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","janua ja 2,000 inanbainyamadi ja kachu jikixun pei ichawaxunkubainshina bexun jantsidi inandiakin yuikin: “Xanen ibuun, 2,000 min ea inanbainyamadan, inananankin ana 2,000 en mia bixunkubainshinadan, naki”, akin 4,000 inanyan ");
INSERT INTO cbsNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","jawen xanen ibun jadi yuikin: “Min en tsuma pejaida kaneismadiki. Eskadabes en mia yunubiabainyama inananankin jawa kaneama min pe mekekubainshinawen taexun ana daya ichapa en mia yunuxanaii. Jaskawen taea natian ebe benimachakayamadiwe”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","janua ja 1,000 inanbainyama jadi jawen jenei jikixun jawen xanen ibu yuikin: “Xanen ibuun, naki, min peidan. Miwen datekin min pei benukatsi ikama bibaini kaxun mai pukinxun en mia aduxunyamaki. Dayakin jawa miban banamabia min ichawamiski. Janua jexe sa akamabia min ichawadiamiski. Min juni meseken miwen datekin min pei en mia aduxunyamaki”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","januxun xanen ibun yuikin: “Min en tsuma chakabu chikishchakamaki. Chanima dayakin jawa miban banaumabia en ichawamiski. Ja inun, jexe sa akamabia en ichawadiamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ja unantan ¿jaskakin banco anu cuenta watan inananankin en pei min ea aduxunama iyamamen, ibubis juxun en pei xekekunkainai en biyui kanunan?” atan ");
INSERT INTO cbsNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","jawen tsuma betsabu mapuabu jatu yuikin: “Ja chikishin pei ja 1,000 mebintan ja 10,000 jaya inankanwen”, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ana jatu yuikin: “Tsuada na en tsuma pepa keskatun jawada jaya pe mekea unantan ichapa jayawen manakukin ana ichapa en inanxanaii, binumakinan. Jakia tsuada na en tsuma chikish keskatun jawada jaya pe mekeama ja eskadabes jaya unantan en mebinxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jaskawen taexun meshujaida anu janua bika tenei kaxai xeta yenx yenx axanaibu anu na en tsuma chakabu udentankanwen”, jatu waniki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","na miyuiwen nuku ana yusin pewakin: —En matun Juchi Kayabi Iyua Xanen Ibu chaxajaida jui en nai tsumabube juxun yudabu jancha betsa betsapa tibi xukuabu unanti watanun ika Xanen Ibun tsauti pepaki en tsauken ");
INSERT INTO cbsNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","en nai tsumabun ea jatu ichawaxunkin keyuxunxankanikiki. Januxun jaska chaxuwan mekenikan jawen chaxuwan paxkamis keska wakin dasibi enabu chaxuwan kayabi keskabu en yusiudi jatu ichawatan ja enabuma chaxuwan kayabi keskabuma en yusmaudi en jatu ichawadiaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Janua en xanen ibujaidatun enabu en yusiudi en jatu nichian mapuabu jatu yuikin: “En Epan mai damiwakin taewakin matu jabe jiwemakatsi matu katunixun natian matu ma kenaikiki. Jabe jiwedi bekanwen, matu duawai benimaikikidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Matunan, en buniaya man ea pimaniki. En unpax manuaya man ea unpax amaniki. En chaikea jua jani en uxatima yumanyan ea jawa unanmabia janu uxati ea inankin man ea duawaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","En tadiumaken man ea tadi betsa inaniki. En isin teneaya man eki bakin man ea shinan chankanwaniki. En bichiti jiwe medan niken ka man eki bakin man ea shinan chankanwaniki”, en jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","januxun jabundi ea kemakin: “Xanen Ibuun, jaskamaki. Min buniaidan, ¿janixun mia uinkin nun mia pimanimen? Min unpax manuaidan, ¿jatian nun mia amanimen? ");
INSERT INTO cbsNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mia unanmabia duawakinan, ¿jatian janu uxati nun mia yununimen? Min tadiumaken ¿jatian nun mia tadi betsa inanimen? ");
INSERT INTO cbsNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Min isin teneaidan, ¿jatian nun mia uinkin nun mia shinan chankanwanimen? Min bichiti jiwe medan nikenan, ¿jatian nun miki bai kaxun nun mia shinan chankanwanimen?” ea wabu ");
INSERT INTO cbsNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","eandi jatu yuikin: “Chanima en matu yuiaii. Na dasibi en betsabu inun en puibudan, jawaumabubiaken nuikin man jatu medabewakubainmiski. Jatu jaska wakin chanima eadi man ea duawakubainmiski”, iwanan, jawen yusiudiabu yui keyutan ");
INSERT INTO cbsNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","januxun jawen yusmaudiabu mapuabudi yuikin: “Matu man chakabubudan, man enabumaki. Tudi budikanwen. Jaskawen taea matunamabia janu chi nukaisma anu diablo Satanás inun jawen nai tsuma chakabubube yumankin tenekubainxanaibu anu matudi budikanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Matubunan, en buniaya man ea pimama iniki. En unpax manuaya man ea amama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","En chaikea jua jani uxatima yumanyan janu uxati ea yunukin man ea duawama iniki. En tadiuma yumanyan man ea tadi betsa inanma iniki. En isin tenei yumanyan ea uin man eki bama iniki. En bichiti jiwe medan nia yumanyan man eki bamadi iniki”, en jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","jabundi ea yuikin: “Xanen Ibuun, jania min jaskaya ¿jatian mia medabewakin nun mia duawama inimen?” ea wabu ");
INSERT INTO cbsNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","eandi jatu yuikin: “Chanima en matu yuiaii. Na dasibi en betsabu inun en puibu jawa jayamabiabuwen nuiama ewendi man nuiama ikubainyamabuki”, en jatu waxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Januxun ja yuda chakabubu jatu kupikin chi medan jatu yumanwankin enabu pepabu besti jatun pepawen manakukin ebe en jatu jiwekuinmaxanaii, ikibi imakinan— nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Januxun nun jawen tsumabu jaska dasibi Jesúsun nuku yusin menetan nuku ana betsa yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ja Pascuatianan, Egipto anuxun Diosun yunua debuwanika nai tsuman nawan bakebu tenankin nukun xenipabu dunkebaini shinanmatitianan, uxa dabe ma kemai misi xaxama nun pimis man unaiin. Jaska inun, en matun Juchi Kayabi Iyua ea tenanun ixun cruzki ea mastakatsi ikin samama ea achitan ea jatu inankatsis ikanikiki— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","jabiatiandi Diosbe nukunabu janchaxunika xanen ibubu inun judio mae xanen ibu betsabu bui Diosbe nukunabu janchaxunika xanen ibujaida Caifásin jiwe anu dasitan icha ");
INSERT INTO cbsNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","jaska waxun Jesús bepadantan tenantima yubakaibu ");
INSERT INTO cbsNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","betsan jatu nemakin yuikin: —Pascua nawaibutian meyamayuxankanwen, nukunabu nukuki sinatai bedukubauntidubukidan, betsatian nun atidumenkainan— jatu wa jaska shinainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jerusalén chaima Betania anuxun Simón yudaki chamini Jesúsun kaya waimatun jawen jiwetanxun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús pimaya ainbu betsan nenkati bishtu juxupaki xeni inin jas kadujaida bexun tesketan Jesúsun buxkaki mauka jaki jababainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","nun jawen tsumabu jatiditun inin mayai xetekin uin jaki sinatai yuinamei: —¿Jaska wakin ja xeni kadujaida jamen chakawakin maukaxumen? ");
INSERT INTO cbsNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jatu inanxun jawen pei midima bitan nuitapaibu medabewatibin!— iki ainbuki nun ja ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","nun jaskaibu Jesúsun ninkatan nuku yuikin: —Na ainbun ea duawai ¿jaskai man jadi janchai? ");
INSERT INTO cbsNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nuitapaibu matube jiweabu man jatu duawapaketiduki. Jakia eadan, jawenchains man ea duawapaketidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jaskaken eki xeni ininipa maukakin na ainbun en mawadiama bebunkidi en yuda ea pewaxuki, jau jawama ea maiwashadaxanunbunan— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","—Xabakabi chanima en matu yuiaii. Mai jidabi anuxun kakape ekidi chanibaunkin na ainbun ea axu shinankin yuidiabaunxankanikiki, tsua jau jakimayamaxanunbunan— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","janua Jesúsun 12 tsumabu betsa paxkakain Judas Iscariote Diosbe nukunabu janchaxunika xanen ibubube yubakanun ika kaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jatu yukakin: —Jesús en matu achimayadan, ¿jati pei man ea inantidumen?— jatu wa jabu benimakaun jabun 30 pei jexe plata kadujaida inanbu ");
INSERT INTO cbsNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","jatube jaskatani jui nukuki ana nukutan: “¿Jatian janixun Jesús en jatu achimatidumen?” ikin shinankubainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ja badi Pascua besi taemisbutian jabianudi misi xaxama pikubainmisbutian ikaya, januxun nun jawen tsuma betsabun Jesús yukakin: —¿Jani kaxun nawakin badi kaya piti bawakin mia pewaxuntanpa?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesúsun jawen tsuma dabe nichinkin yuikin: —Bui Jerusalén anu jikitan ja juni betsa nun unain anu jawen jiwe anu kaxun yuikin eska watankanwen: “Nukun yusinan nuku yuixudan, ¿mia yuipa? Ma en mawa kemaxun min jiwe anuxun Pascuatian nawakin shinanmati piti en tsumabubetan pinun ika juikiaki. ¿Janixun bawakin pewaxunpa?” akin ea yuixuntankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","jawen tsumabu kainbaini Jerusalén maewan anu jikitan jaska Jesúsun jatu yuixu jiwe ibu yukatan januxun nawakin Pascua piti bawa menetan chintunbaina ");
INSERT INTO cbsNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ibai ma badi kai meshuaya Jesús nun jawen 12 tsumabube kai jikitan tapu anuxun nun jatubetan piaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jesúsun nuku yuikin: —Chanima en matu yuiaii. Jadatutunda man ea jatu achimai kaii— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","nuku jaska wai ninkatan nun jawen tsumabu juinti nishmai keyutan yukakin: —Xanen ibuun, ¿jabia en eamen?— nun iaketanyan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesúsun nuku yuikin: —Na jabias kenchaki ebetan misi pukuxun man piaitunan, jatun ea jatu achimai kaikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jaska ekidi kenenibu chibain matun Juchi Kayabi Iyua en jaskai mawai kaii. Jakia ja junin ea jatu achimai kaidan, pemajaidaki! Jaskaken ja juni kaianma inidan, pepakeanaii— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesús jatu achimai kabiakatsi Judasin bepadankin yukakin: —Yusinaan, ¿jabia en eamenkaintsa?— aka Jesúsun yuikin: —Jawaikika! Jabiadi min yuiaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","nun piaibun Jesúsun misi betsa tsumaxun Dios kushipa yukatan tunketan inankin nuku yuikin: —Na misi betsadan, en nami keskaki. Bibaunkin pikanwen— nuku wa tude betsa bitan metex atankin nun pibaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","januxun kencha vino mata tsumaxun Dios kenwandiatan nuku inankin yuikin: —Yuda ichapa medabewakin jatun chakabu Dios jatu buamai en mawaya en jimi ea ikunwainbu jatu dasibi jabaxunxanikiki. Na vino en jimi keskaki, jawen en yubakai bena shinanmatidan, akanwen— nuku wa bitan tusa nun nuxabaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—Chanima en matu yuiaii. En Epa Diosbe xanen ibui en ana judiama na uva vino en ana matubetan ayuama ixanaii. Abaunkanwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","jabianuadi Salmos Davidin keneni betsa betsapa nukun juiwen nawai menetan janua ma Judasin nuku paxkabainken Olivos Mati anu nuku iyuxun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesúsun nuku ana yuikin: —Jawen jancha yuixunika ekidi Diosun yuikin: “Chaxuwan jatun mekenika en tenanyan jawen chaxuwan datei paxai keyuxankanikiki”, aka ninkatan keneniken na jabia meshutian jabiaskadiai matu dasibibun ea shinanma man ea jenebaini paxadiaii, chaxuwan keskaidan. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jakia ea tenanbiabu ana bestentan janu matuki nukunun ika bebunkidi Galilea anu en matu kaxunxanaii— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedron yuikin: —Miwen datei dasibi paxai keyuaibun eanan, en mia jawa jenekin putamaki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesúsun Pedro yuikin: —Jaskamaki. Chanima en mia yuiaii. Na jabia meshu medan takada keudiamaken: “En ja unanmaki”, iki dabe inun bestiki eki dakekin min yui kaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ninkamas jancha kushipawen Pedron ana yuikin: —Jaskamaki. En mibe mawabiai kai jaskai en miki dakeamaki— ikaya nun jawen tsuma dasibibun shinanma jabiaskasdi nun yuidianibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Janua Jesús nun jawen tsumabube kai miban xuku betsa jawen kena Getsemaní mishkiwen kenenibu anu jikitan nuku yuikin: —Nenu jabianu tsauyukanwen, en Diosbe janchai kaidan— ikainkin ");
INSERT INTO cbsNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedro inun Zebedeon bake dabe Santiago inun Juan besti iyui kai punu nuka jawenchains juinti metexekei niti itan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","jatu yuikin: —En yudawen mawakin en matu xunubainxanai shinain en punu nukajaidaki. Na jabianuxun uxama ea manakanwen— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","janua kai chaima ka beua maiki beti ixun Dios yukakin: —En Epa Diosuun, jamapai dasibi min atidu en unaiin. Jau ea tenanyamanunbun min jatu nematidubia jaska en shinainwen akama min shinan bestiwen ea axanwen— atan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","janua jawen tsuma dabe inun besti anu chintunkidan uxabuki nukutan jatu datekin Pedro yuikin: —¿Jawai man uxamen? ¿Uxama hora bestichai bedu mestenwantan man ea manatidumamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chanima matun shinan pebia matun yuda babuwen taea man punu nukaya matuki chakabu jikia man kaneyamanunbun Diosun jau matu medabewanun uxama jabe janchakanwen— jatu awani ");
INSERT INTO cbsNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ana Diosbe janchai kaxun yuikin: —En Epa Diosuun, en yumanyamanun ea unanti wakin min jenekatsi ikamadan, peki. Min shinanen besti ea axanwen— atan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ana jua ma uxa paen jatu achia uxabuki nuku wani ");
INSERT INTO cbsNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","jawa jatu yuiama ana chintunkain Diosbe janchai kaxun jabias jancha yuitan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","janua jawen tsumabu anu ana juxun jatu yuikin: —¿Jaskaida man uxa ninkama uxa bestia man juindukunsi ikanai? Uinkanwen. En Diosun bake matun Juchi Kayabi Iyua juni chakabubun ea achi bei ma kemakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Benidikanwen, nun kanunan. Ea jatu achimai jatube ma juikiki— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús jancha menediamaken Diosbe nukunabu janchaxunika xanen ibubu inun mae xanen ibubu betsabun jatu yunua juni ichapa nupe chaipayabu inun kushati jiyabube Jesúsun 12 tsuma betsa Judas Iscarioten jatu iwekin ");
INSERT INTO cbsNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasin bebunkidi jatu yubakin yuikin: —Ja en tantsu akaidan, jaki. Achixun iyukanwen— jatu abidanxuwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Iscariote Jesúski nukutushikin yuikin: —Yusinaan, en miki nukuyuaii— iwanan, tantsu akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesúsun yuikin: —Peki, en jaibuun. Ea jaska wanun ika min jatube yubakakidanaidan, ea jatu amadiwe— akaya —Jakiaki. Akanwen— ibain achiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesúsun tsuma betsan jatu mepanmanun ika nashui ikain jawen nupe chaipa sitan Diosbe nukunabu janchaxunika xanen ibujaidatun tsuma mapexpaikin maebain paxteaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesúsun jawen tsuma nemakin: —Ana jatu meama min nupe ana jawendi usunwen. Tsuabuda nupe chaipawen detenameaibu jabiawendi mawaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na ea eska waibu en Epan jau ea medabewanun en yukaya samama jawen nai tsumabu 12,000 ea medabewamai jawaida nidi ibidan ea axuntidubu ¿min unanmamen? ");
INSERT INTO cbsNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jakia Diosun jaska waya jawen jancha yuixunikabun ekidi keneama inibudan, ea jaska wabuma ikeankanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","mapuabu uinkin jatu yuikin: —Uatian xaba tibi Templo jemaintin anuxun en matu yusinkubainai man ea xabakabi achiama ikubainshinabuki. ¿Jaskai natian meshu medan yumetsu achimisbu shinain jawen deteti nupe chaipaya inun jawen kushati jiya man bekanxumen? ");
INSERT INTO cbsNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Eskawen taea man ikaii. Diosun jancha bebunkidi ekidi kenenibu jaska yuiniwen taexun man ea achiaii— jatu waya janua dasibi nun jawen tsumabu datekin Jesús besti jenebaini paxai nun junei keyubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","janua achitan iyukin Diosbe nukunabu janchaxunika xanen ibujaida Caifásin jiwe anu janu mae yununika xanen ibu betsabu inun, Diosun jancha kenenibu yusinananmisbu jabu dasibibu jabu dukun bua icha maniabu anu Jesús iyukin janu bichiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","janua Pedro datei benanta kakin chibankubaina Caifásin jiwe jemaintin mishki kenebaunibu anu jikidiatan ¿jaska wakanimenkain? uinun ika Templo mekenikabube tsauxun uianyan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","januxun Diosbe nukunabu janchaxunika xanen ibubu inun Junta Supremabu dasibi ichaxun Jesús jau tenanunbun jakidi chakabujaida yuiaibuwen chani jancha ikun keska watan jawen unanti watan tenankatsi benai maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","juni betsa betsapabun jakidi chani chitebiakin jakia juni dabetun jabias chani yuiabumaken atimas juni dabedi jaki chani chakakin ");
INSERT INTO cbsNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yuikin: —Nukun ninkakinan, Jesúsun eska yuiai nun ninkashinaki. Matu yuinun: “Na mishki Templo junibun anidan, tekekin pudekin keyutan uxa dabe inun besti kaya junibun akamaken ana en benixanaii”, ikai nun ninkashinaki— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","jaska waibu ninkabaikin Diosbe nukunabu janchaxunika xanen ibujaida Caifás namakis dasibube tsaua benitan nixun Jesús yukakin: —Na junibun mikidi chakabu yuiaibudan, ¿miadan, jaskai min jatube kemanameamamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús pes jawa yuiama niken Diosbe nukunabu janchaxunika xanen ibujaidatun ana yuikin: —Dios jiweatun mia ninkaya jau min chani chakayamanun en mia yunuai, chanima nuku yuiwe. ¿Jabia min miamen ikaidan, min Diosun bake nukun mekenan Mesías Cristodan?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsun yuikin: —Jabiadi min yuiaii. Jamen ean en mia yuiaidan, en Epa Dios kushipajaidatun yusiudi en tsaua matun Juchi Kayabi Iyua nai kuinwen en juai man ea uinxanaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Diosbe nukunabu janchaxunika xanen ibujaida jaki sinatajaidakin jawen sanpu tadi ushnitan yuikin: —Dios ichaikiki. Ana jatida janchai en ninkakatsi ikamaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na jaska janchayadan, ¿jaskada jakidi man shinain?— jatu wa jabun yuikin: —Dios ma ichawen taexun jau tenanunbunwen— iake iaketan ");
INSERT INTO cbsNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ichakawakin taewakin betsabun besuki kemu michukin kushaibun betsabundi tanpais akin ");
INSERT INTO cbsNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kaxe wakin yuikin: —Min Diosun Mesías Cristodan, ¿tsuan mia kushaimenkain? unantan nuku yuiwe— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","janua jemaintin anu Pedro tsaua xanen ibu dayaxunmis ainbu betsan bechitan yuikin: —Miadan, Jesús Galilea anuabe min nimiski. En mia unaiin— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedron padankin jabube ichabu bebunxun yuikin: —Jaskamaki. Ja min jadi yuiaidan, en ja unanmaki— abaini ");
INSERT INTO cbsNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","janu jemaintin kenekauana jikiti xui anu ka niken ainbu betsandi janu nia uinkin jatu yuikin: —Ja junidan, Jesús Nazaret anuabe nimiski— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","januxun Pedron ana jatu yuikin: —Jaskamaki. Diosun ea kupitiduwen taea en chani chakamaki. Ja junidan, en ja unanmaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","janua jabianu manixun betsabundi Pedro uindiakin jaki kemaxun yuikin: —Chanima Galilea anuabu min jawen janchaki. Min Jesúsun tsuma betsaki. Jadi man janchamisbin nun mia ninkai— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","januxun Pedron jatu ana padankin yuikin: —Ja juni man yuiaidan, en ja unanmajaidaki. En chani chakayadan, jau Diosun ea kupinunwen— jatu waya jakimamadi takada keuai ");
INSERT INTO cbsNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ninkatan jaska Jesúsun Pedro yuikin: “Dabe inun bestiki: ‘En ja unanmaki’, akin takada keudiama min yuixanaii”, abidana Pedron shinain taxnikain kaxa chakayamanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Janua penaya Diosbe nukunabu janchaxunika xanen ibubu inun judio xanen ibu betsabu icha jaska wakin Jesús tenantikidi yubakaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesús menexxun romano xanen ibu Pilato anu iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasin jatu achimabidana Jesús tenankatsi ikaibu uinkin unankin shinain jawen nuikin ja 30 pei jexe Diosbe nukunabu janchaxunika xanen ibubu inun xanen ibu betsabun inanshinabu ana jatu inanun, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","jatu yuikin: —Jesús juni pepabiaken jau man tenanun chakabu shinankin en matu achimashinaki. Na pei man ea inanshinadan, en ana jaska jayakatsi ikamaki— jatu wa jawen pei ana bikatsi ikama jabun Judas yuikin: —Min chakabushina nun jawen nuiamaki. Min nuku jaska wamashinadan, minaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","janua juinti nishmajaidai keyutan janu Templo jikiti xui xexekaian nitan ja pei jexe putakin sa atan kainkaini ka dispiwen tenexeketan dunua mawanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ja pei jexe sa abaina Diosbe nukunabu janchaxunika xanen ibubun tupitan yuinamei: —Na peiwen juni achishinxun nun jatu tenanmai kaiwen taexun Dios kenwankin janu inankuinti bauki nun jaska jaki nanetidumaki, ja pei jimiwen iduma keskadan— itan ");
INSERT INTO cbsNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","¿jawen jawa jaska wananxanpa? ika yuinamei yubakakin shinantan Jerusalén anu bai bea mawabu medibi janu jatu maiwati wanun, iwanan, mai kenti wanikan bai ja 30 pei jexewen bikin ibu wanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jaska wanibu na jabiatiandi kenakin: “Jimi Baiki”, nun wamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Jaska Diosun jancha yuixunika Jeremíasin bebunkidi jatu yuikin: “Jabun 30 pei jexe bixun mai kenti wanikan bai bikin jaska Israelbun jawen kadu yubashina jawen pakakin ibu waxankanikiki, akin Diosun ea yuia en matu yuixuki”, jatu waxun keneniki. Jabiaskadi kaneama menekin Judasin peiwen bai bikin ibu wanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Janua romano xanen ibu Pilato anu Jesús iyuabu kainkidan tsauxun yukakin: —¿Miadan, min judio xanen ibubu binu keyuamen?— aka Jesúsun yuikin: —Jawaikika! Jabiadi min ea yuiaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Diosbe nukunabu janchaxunika xanen ibubu inun xanen ibu betsabun jakidi yuikin chani tibi chiteaibun Jesúsun jawa yuiama niken ");
INSERT INTO cbsNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilaton ana yukakin: —Ja mikidi betsa betsapa chakabu yuiaibudan, ¿min jawa ninkamamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesúsun jawa jancha betsa yuiama niken: —Jabaa! ¿Jaskai janchamamen? —itan Pilato jadakidi shinantimawa ");
INSERT INTO cbsNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","romano soldadobun jatu achixun bichimabu badi tibi ja Pascua nawaibutian jau bestichai taxninun ja romano xanen ibu Pilaton beyawen taexun maen katuaya jatu kainmaxunpakemisken ");
INSERT INTO cbsNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","jabiatiandi juni betsa detenameti unan keyuai Barrabás achixun bichimabun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","janua Diosbe nukunabu janchaxunika xanen ibubu Jesúski chani chakai jaki sinatakin jaska waxun maematima maemanun ixun iyuabu Pilaton unankin mae anua dasibi ichabu jatu yukakin: —¿Jadatu man bechipaiai, ja en matu taxnimaxunaidan? ¿Barrabásmenkain? ¿Jesús Diosun Katua Mesías kenamisbudaka?— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","janu Pilato gobernador tsauti anu tsaudiaken jawen ainen jancha bumakin yuikin: —Jesúswen taea en nama chakashinaii. Jaskawen taexun ja juni pepa jawa jatubetans jakidi chakabu yuikin jawa yunuyamawe— aka juxun jawen tsumapan yuixunbiaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pilato ninkamama june Diosbe nukunabu janchaxunika xanen ibubu inun xanen ibu betsabun yudan kaian Jesúski jatu sinatajaidamakin yunukin: —Barrabás jau nuku taxnimaxuntan Jesús jau jatu tenanmanun yunukanwen— jatu waibu mae anuabun ninkaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilaton ana jatu yukakin: —Ja juni dabedan, ¿jadatu man bechipaiai? jawa meama ja en matu taxnimaxunaidan— jatu wa jabundi Pilato yuikin: —Barrabás nuku axunwen— iake iakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaton ana jatu yukakin: —Jesús Mesías Cristo kenamisbudan, ¿jadan, jaska wapa?— jatu wa dasibibun yuikin: —Cruzki nuku mastaxunwen— iake iakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ana Pilaton jatu yukakin: —¿Natunan, jawa chakabuwashinamen?— jatu wa ana unanxubima jancha kushipawen yuikin: —Cruzki nuku mastaxunwen— jawenchains ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilaton jancha jawa ninkama ana keketikubainaibun jabun shinan jatu mae wamatiduma Pilaton unankin jatu unanti wanun, iwanan, jawen soldado yunua unpax bexuan yudan kaianen bedubi mepanukin jatu yuikin: —Na juni pepa en jatu tenanmakatsi ikama matu unanmanun ika en mepanuaii. Matun man jaska yunuai bestiwen taea mawatiduki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ja yuda dasibibun yuikin: —Peki. Nuku inun nukun bakebun nun yunuaiwen besti jau mawanunwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","januxun Pilaton jatu daewakin Barrabás jatu taxnimaxuntan Jesús jatu kusha kusha amatan jau jiki mastatanunbun jawen soldadobu yunua ");
INSERT INTO cbsNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","januxun xanen ibu Pilaton jiwe ewapa jemaintin anu soldadobun Jesús iyuxun soldado jabus jaki xukui kexebauntan ");
INSERT INTO cbsNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","januxun Jesúsun tadi pekatan kaxe wakin xanen ibun bemakia tadi tashijaida Jesús sawematan ");
INSERT INTO cbsNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","janua muxa maiti waxun maimatan jawen meken yusiudi ji sidi jawen xanen ibun mestenti keska tsumamatan janua jaki kaxei ja bebun danti itan yuikin: —Judio xanen ibu kayabidan, min miaki— atan atankin ");
INSERT INTO cbsNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","jaki kemu michukin jabias ji sidiwen tsumamabuwen makush makush atan ");
INSERT INTO cbsNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","kaxe wai jaki beyusi keyutan bemakia tadi tashijaida pekatan jawen tadi kayabis sawemabainkin cruzki mastanun, iwanan, jaki mastai kanun, iwanan, cruz iamatan xadamabainkin iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","janua juni betsa Simón jawen mae Cirene anua juaiki nukuxun Jesúsun cruz jau iaxunyubainun soldabobun yunua iaxunbainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota anu Jesús jadi iyukin mapematan, jaska yuidan, Buxka Xau Mati anudan, ");
INSERT INTO cbsNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","vino isin nemati dau muka jusia amabu metan danankin akamaken ");
INSERT INTO cbsNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","januxun cruz bexuki Jesús mastaxun nichintan januxun soldadobun jawen beyustiwen maemanankin jawen tadi paxkanun iwanan: “¿Tsuan dukun jawen tadi bimenkain? Akanwen”, ikin Jesúsun tadi paxkakin menetan ");
INSERT INTO cbsNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","janua jau mawanun Jesús kexea tsauxun uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","jabiatiandi jawen unanti ji bexa tuaxki kenekin: “Nadan, judiobun Xanen Ibu Jesúski”, Pilaton aka buxun Jesús mamaki mastadiabun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","jabianudi jabe juni yumetsu dabedi cruz dabeki mastaxun betsa jawen yusiudi nichinxun betsa jawen yusmaudi akabun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","janua juni betsabun ichakin dainbaini budi budi ikin ");
INSERT INTO cbsNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yuikin: —Uinwen. “Dios kenwanti mishki Templo tekekin pudekin keyutan xaba dabe inun besti kaya en ana benixanaii”, min ishianki. Min ja kushipa jayadan, jaska min Diosun bakemenkain ja cruz anua mimebi paxai butudiwe, mawamadan— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Diosbe nukunabu janchaxunika xanen ibubu inun, Diosun jancha kenenibu yusinananmisbu inun, judio xanen ibu betsabudi Jesúski kaxekin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","43","—Juni betsabu medabewabiamis jamebi paxatidumaki. Jaskakenan, jaska Israelbun Xanen Ibu Cristo kayamenkain cruz anua butuai uinkin na jabiatian nun ikunwantiduki. Dios ikunwain jakidi janchakunkainshinaki. Natiandi Dios benimakin jau medabewanunwen, paxawakinan, jaska waya nukundi nun ikunwainan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","juni yumetsu dabe jabe mastabundi Jesús ichadianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Janua badi manananbibiaken badi nuka meshua itsa daka manaibun ma badi nai puchinin dakaken bepenakainaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","jabiatiandi Jesúsun jui kushipawen yuikin: —Elí, Elí, ¿lemá sabactani?— ikidan juni kuin janchadan, “En Diosuun, en Diosuun, ¿jaskakin min ea jeneamen?” ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ja naman jatidi mapuxun betsabun ninkatan yuikin: —Ninkakanwen, Diosun jancha yuixunika Elías kenaikikidan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","janua ja naman mapuabu betsa kushikidan janu jawen tsiniti vino muka pu atan tawaki ustanxun bexun amanun, iwanan, sananxunaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","betsabun nemakin yuikin: —Jaska wama jeneyuwe, Elíasin butekin paxawayuimenkainan— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","janua Jesús ana unanxubima bis itan mawaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","jabiatiandi Templo medan tadi dintu wakin kebenibu jamebi manaundia dis iki keyuaya mai pacha sakuaya mishkipanwan bepunibu maei dabekeaya ");
INSERT INTO cbsNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","janua janu maiwati tanpe xabakabiaya jabun Dios ikunwain mawanibu Diosun jatu bestenwan ");
INSERT INTO cbsNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús bestendiamawen taea jabu dukun kainbaini Jerusalén ja mae medibi anu jikiabu januxun yuda ichapabun jatu uinibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Janua romano capitán inun jabun Jesús mekekin mai pacha sakui betsa betsai uin datejaidakin yuikin: —Chanima kayaki. Na junidan, Diosun bakeki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","janua ainbuaibun Galilea anuxun duawakin Jesús chibanmisbu María Magdalena inun Santiago inun Josén ewa María betsa inun Zebedeon juni bake dabetan ewadi Jesús mawai jabu benanta nixun uindianibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Janua ma badi kaya judio betsa mabu pai paimaya jawen kena José Arimatea anua kainitun Jesús ikunwankin chibankubainshinatun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ana jawaki dateama Pilato anu kaxun Jesús maiwakatsi jawen yuda yuka jau Josén butetan butanun Pilaton jaska yunua ");
INSERT INTO cbsNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","kaxun Josén jawenabubetan butetan tadi juxupawen dayabutan buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ainbu dabetan jatu chibainbun jawen yuda bakebainkin bukin jawen bai neki mishki kini bena jatu amaima anu Jesús datantan mishki beputi ewapawen beputan buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","jabianudi María Magdalena inun María betsa maiwati tanpe anu ja bebun niti ika tsauxun dasibi uinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","maiwashinabu judiobun juindukuntitian Diosbe nukunabu janchaxunika xanen ibubu inun fariseobu Pilato anu jabe janchanun ika bua ichaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","yuikin: —Xanen ibuun, ja juni chani chakakin mawadiama janchai nun ninkamisdan: “Mawa xaba dabe inun besti kaya en ana bestenxanaii”, ishian nuku yuishinabu nun shinaiin. ");
INSERT INTO cbsNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jaskawen taexun xaba dabe inun besti binudiama maiwashinabu jau kexexun meke pewanunbun min soldadobu yunuwe. Min jatu jaska wamamaken meshu medan jawen tsumabu bexun jawen yuda june tsekabain butan chipu yudan kaian yuikin: “Nukun Xanen Ibu ma nuku bestenxun kainshinaki”, iwanan, dasibibu jatu padantidubuki. Jaska wakin jawen chani jancha jatu pikumatidubuki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaton jatu yuikin: —Na soldadobu man jayaki. Matudi maiwashinabu anu jatube buxun jatu pewamatankanwen, jau jaska yumetsuyamanunbunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","buxun jawen beputi mishkiki juni betsan bepean unanti shadawakin jawen unanti dispiki tsamintan puntekin bewexetan jau mekekin uinunbun soldadobu yunukin kexematan benibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Janua ma sábado juindukunti binukainaya penai taeaya domingotian María Magdalena inun María betsa maiwashinabu anu buxun ");
INSERT INTO cbsNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","uiainbun mai pacha sakuaya jabiatiandi Diosun nai tsuma maiwati tanpe anu butuxun mishkiwen bepushinabu bepentan jamamaki tsaua ");
INSERT INTO cbsNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","jawen yuda kana bakai keska chaxai jawen tadi juxupajaida juxu punte punte ikai ");
INSERT INTO cbsNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","soldadobun uin datei saki saki iki tin ika mawa keska tsistibainbaina maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","januxun nai tsuman ainbu dabe beabu yuikin: —Jesús mastashinabu man benai jua en unaiin. Dateyamakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jaska bebunkidi matu yuishina keskai ma bestenkainaki. Ana nenumaki. Janu datanshinabu jikixun uin ");
INSERT INTO cbsNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","bekanwen. Uinbaini buxun jawaida na jancha jawen tsumabuki chanikin: “Jesús mawashinadan, ma bestenkainaki. Matu bebunkidi Galilea anu kaxuinkiki. Jadia matube ana ichai benai kaikiki. Jadi buxun uinditankanwen”, akin jawen tsumabu jatu yuiditankanwen. Jaska bestiki, en jancha matu bexuanki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ainbu dabe maiwati tanpe anua uintan datei taxnibaini benimachakayamai kushibaini jawen tsumabu yui buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesús jatuki nukui jatu bechankametan jatu jancha wa ainbu dabe jaki nukuxun Jesús kenwain danti ixun jawen tae jutsundabeabu ");
INSERT INTO cbsNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesúsun jatu yuikin: —Dateyamakanwen. En betsabu jau Galilea anu bununbun ea jatu yuixunditankanwen. Jadixun jabundi ea uin bukanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ainbu dabe buaibun Jesús maiwashinabu soldadobun kexeabu jatidi Jerusalén anu buxun jaska uinkanxu Diosbe nukunabu janchaxunika xanen ibubuki chaniaibun ");
INSERT INTO cbsNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","janua jabu xanen ibu betsabube janchai bua jaska wakin yudan kaian padantidubu yubakatan soldadobu pei midima inankin ");
INSERT INTO cbsNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","jatu yuikin: —Jadi man jatu yuikubaintanun matu yuinun ninkakanwen: “Meshu medan nun uxaken jawen tsumabu bexun jawen yuda yumetsubainabuki”, ");
INSERT INTO cbsNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","man ikaya Pilaton jaska ninkatan jau matu kupiyamaxanun nuku nun jabe janchakin nun matu yui pewaxunxanaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","januxun soldadobun pei bitan jaska jatu yuixukidi jabu chania akeakenibu na jabiatiandi judiobun jabiaskadi jatu yuikubainmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Janua nun jawen 11 tsumabu Galilea anu mati betsa anu jaska Jesúsun nuku yunushina anu kaxun ");
INSERT INTO cbsNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús bechitan ikunwain ja bebun danti itan kenwainbun jatiditun shinan chankanma kenwanma juinti kushikin kenwanbumaken ");
INSERT INTO cbsNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús nukuki kematan nuku jancha wakin yuikin: —Jawen kushipa ea inankin jawada nai anua inun jawada mai anua mekekin en yunukubainxanun En Epan ea Xanen Ibu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaskawen taexun matu yununun ninkakanwen. Kakunkaunkin dasibi en matu yusinmis nawa betsa betsapa xukuabu tibi yusindiakin en tsumabu ea jatu waxunkubainxankanwen. Januxun ea ikunwankin jawenabu jau jatu unanti wamanunbun Epa Dios inun ea jawen bake inun jawen Yushin Pepa kena dayuikin jatu nashimakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jatu jaska wakin jaska en matu yusinmis jau jabundi chibanunbun dasibi jatu yusian akeakexankanwen. Man jatu jaska waya eadan, janu na mai jidabi anu badi keyudiamatian dasibi man ea ikunwainbube dasitan badi tibi en matu medabewapakexanaii— nuku waniki. Jatiski, nukun Xanen Ibukidi en jancha chanimadan. Mateo");
INSERT INTO cbsNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja dukun bebunkidi Diosun jawen bake Jesús Mesíaskidi jatu yubani jaska jawen kakape taxnimakin taewani matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","“Naiudixun Diosun jawen bake yuikin: Min kadiama mia bebun en jancha yuixunika jau mikidi bebunkidi chanixanun en mia yunuxunxanaii. Jatun janu tsua jiweabumanuxun jui kushipawen jatu yuikin: ‘Nukun Xanen Ibu nai anua matuki bayui ma kemaikiki. Matun juintinin shinan pewadikanwen, bai kayatapia keska wakinan’, jatu wakin mia jatu yuixunxanikiki”, ayama Diosun jawen jancha yuixunika betsakidi jaska yuini chipu Isaíasdi jaska Diosun yuia ninkatan jawen jancha yuixunika Isaíasin keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Janua jaska yuini keskai jadi tsua jiweabumanu Nashimanika Juan kaima jiwea taxnitushitan jatu yuikin: “Matun shinan betsa watan matun chakabu Diosun jau matu buaxunxanun ninkatan jawada chakabuwen man benua jiwea jenedikanwen. Matun shinan maewatan man ea uinmaya en matu nashimaxanaii”, iwanan, jatu yusinkubainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea mai pakeanu jiweabu inun Jerusalén maewan anu jiweabu dasibi bexun Juanen jatu yusiain ninkakin jabun ikunwankin jatun chakabu Juanki chanikin jatun chakabu jenekatsi ikin shinan betsa waibu jawen unanti wakin Jordán jene anuxun Juanen jatu nashimapakekubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Janua Juanen tadi inun jawen pitikidi matu yuinun ninkakanwen. Camello dani sanpu tima sawea inun, bichi nanexeketi sawea inun, jawen piti pe bexmas chanpu inun ni medanua buna batapa aki jiwekunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Januxun yudan kaian jatu banabimakin: —Xanen ibu kushipajaida betsan ea binuan ea kachu dama juxanikiki. Jaskawen taexun mawaida en kushipa jayamatun kakain en jawen jawaumajaidatun jawen bichi tae mexpun tsitsauxun pekaxunkin akawakin en duawatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jamen eanan, jenewen besti en matu nashimakubainaii. Jakia jatunan, Diosun Yushin Pepawen matu unanti wakubainxanikiki, nashima keska wakinan— akin Juanen jatu yuikubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja jaskaitian Jesús jawen mae Nazaret Galilea mai pakeanua kainkidani Juan anu ka Jordán jene anuxun Juanen nashimakin meneaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","nexekei mapekekidankin Jesúsun uianyan nai udia Diosun Yushin Pepa deiwan keska jamamaki butuaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","nai udixun Diosun yuikin: —Miadan, min en bakeki. En mia bechipaikin katunidan, en miwen benimajaidaii— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Janua jadi tsua jiweabuma benanta yuinaka mese piananbu anu Diosun Yushin Pepatun Jesús iyushina ");
INSERT INTO cbsNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","40 día Satanásan Jesús padanun, iwanan, unanti wa akeakeaya kakunkaunkin Jesúsun Satanás maemakubaunaya Diosun nai tsumabun medabewakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Januxun bichiti jiwe anu Juan ma bichishinabun Galilea mai pakeanu kaxun Diosun kakapekidi Jesúsun jatu yusinkin ");
INSERT INTO cbsNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","taewakin: —Na jabiatian Dios ma nenu xanen ibuikiki. Jaskaken man Dioskidi chakabumis jenetan en kakape ekidi ikunwankubainkanwen— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Janua kai Galilea ianenwan kexa Jesúsun ketankubaini kakin baka nexenika dabe Simón inun jawen betsa Andrésin jatun jisin ewapa punteaibu jatu bechixun ");
INSERT INTO cbsNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesúsun jatu katukin yuikin: —Ea chibankanxun matun daya jenekanwen. Man jaska dayamisbudan, ana baka nexeama jakia man baka nexemis keska wakin yudabu en matu ichawamaxanaii, jau ea ikunwanxanunbunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","januxun jatun xaxu inun jatun jisin jatun jaibu betsa yunu keyutan jawaida jenebaini Jesúsbe buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","janua Jesús ana ketankubainkin Zebedeon bakebu Santiago inun Juanen xaxunxun jatun jisin tadas ika junukin kexeaibu bechixun ");
INSERT INTO cbsNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesúsun jatudi katukin yuikin: —Ea chibankubainkanwen— jatu wa ninkatan jabianu jatun ibu Zebedeobe xaxu namaki jabun medabewamisbube bashibaini Jesús chibain budianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jatu jaska wabaina Jesúsbe bui mae betsa Cafarnaúm anu jikishinabun sábado juindukuntitian janu ichamisbu anu Jesús jikixun jatu yusiain ");
INSERT INTO cbsNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Diosun jancha kenenibu jabun jatu yusinkin shinan chankanwainsma keskama Jesús xanen ibu kayabi kushipakin jatu yuiai yudabun ninkai e itan: “¿Jaskamen?” iki benimakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","jabianudi juni yushin chakabuya tsaua yushinen unanxubima bis imakin ");
INSERT INTO cbsNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yuimakin: —Jesús Nazaret anuaan, ¿jaskai nuku anu min juxumen? ¿Nun yushin chakabu nuku yamawanun ika min juadaka? En mia unaiin, min Diosun bake pepa medibidan— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","yushin chakabu Jesúsun nemakin yuikin: —Janua jaskama nesetan ja juni anua kaindikaintanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ja juni anua yushin chakabu kainkainkin unanxubimajaida sai imatan mai pusamatan duxku imatan kainkainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","dasibibun uin —Jabaa!— ike ikei yuinamekin yuikin: —Nadan, yusian betsa jayaki. Xanen ibu keska kushipajaidaki. Jawen jancha paepaki, yushin chakabu xunska yunua ninkai jawen datei kainkanikikidan— itan ");
INSERT INTO cbsNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","samama bui jakidi jatu banabimai chania akeakeaibun Galilea mai pakeanuxun Jesúskidi kakaibu dasibibun ninkabaunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Janu ichamisbu jiwe anua Jesús kainkaini Simón inun Andrésin jiwe anu Santiago inun Juanbe buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simónen dais ainbu yuna tenei daka anu jikitan jaska isin teneaikidi jabun Jesús yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","jaki kemaxun metsunxun benitushia jawen yuna damaintan benimakin jatu duawakin bawaxun jatu pimaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","janua ma badi kai meshuaya dasibi ja mae anu jiweabu Simón inun Andrésin jiwe anu ichai bekin dasibi isin teneaibu inun yushin chakabu jayabu Jesús anu iweaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","isin betsa betsapa teneaibu ichapa xuxawakin yushin chakabu ichapayadi yudabu anua kainmapakenikiaki. Jaska wakin yushin ichapatun Jesús unainbuwen taexun Jesúsun jatu janchamamakin nemapakenikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Janua uxashini ma penabiai meshuyuken Jesús butukaina mae dapi benanta Diosbe janchai ka jabe janchaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón bestenkauan jawen jaibuaibubetan Jesús benabaunkin ");
INSERT INTO cbsNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","atimas jaki nukutan yuikin: —Dasibibun mia benakanikiki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesúsun jatu yuikin: —Diosun jancha yusinbaunun ika en kainkidanshinaki. Jaskawen taea mae betsa udama janudi yusin budinankanwen— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilea mai pakea dasibi anu kakunkaunkin janu Diosun jancha ninkakatsis iki janu ichamisbu jatun jiwe tibi anuxun kakape yusinkin yushin chakabu yudabu anua kainmakubaunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Janua juni jawen yudaki chami betsani Jesúski nukutan danti ixun yuikin: —Ea kayawakatsis ikin min ea kayawatiduki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","jawen chamiwen datekin danankin tsuan metsakatsi isbumabiaken Jesús jawen dabanan ikin mexunkain mekin yuikin: —En mia kaya waii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","jawen chami sakada iki daxnukui keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesúsun nichinkin nemakin: ");
INSERT INTO cbsNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—En mia yuiai ninkaidawe. Jawada en mia axukidi tsua yuiyamayukubaintanwen. Jadi dukun kakin Diosbe nukunabu janchaxunika min yuda min ma kayaxu uinmatanwen. Jaska min ma kayaxu jau dasibibun mikidi unanunbun jawen jatu bepadanbainkin jabiaskadi inankuin Moisin yununi jatu anu buditanwen. Min jaska buaya min kayaxu jabun unanxankanikiki— abia ");
INSERT INTO cbsNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ninkama kaxun jaska Jesúsun axunxu juneama tsuabudaki nukua akeakekaini dasibibuki chaniaya xabakabi jamapai mae anu Jesús ana jikitiduma jadi tsua jiweabumanu besti niaketanaya mae tibi anuxun yudabun Jesús uinun ika “¿Janimen?” iki yuka ibidan ibidani jaki ichanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Janua uxa eskadabes jawen mae Cafarnaúm anu Jesús katani jikiaya banabitan yuinamei: “Ma ana nenu juxukiaki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","yuda ichapabu janu bei jaki xukui ana jani maputima jemaintin anu ika kai bestuabu ana jadakidi tukuama mapuabun Diosun jancha jiwe uke medanxun Jesúsun jatu yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","juni yuda babuni jawen baketiki daka juni dabe inun dabetun Jesús anu jawen dakatiki bakebidan ");
INSERT INTO cbsNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","janu yudan kaian xukuabuwen taea jaska watan bichibain Jesús uinmatima mai bawa jiwe sapa xeni mamaki inabain jawen dakatiki janu butenun, iwanan, janu bexpa wakin pudenkin xui watan janu ja juni yuda babuni Jesús anu buteaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","jaska jatun shinan ikunjaidawaibu unankin juni yuda babuni Jesúsun yuikin: —Dateyamawe. Min chakabuwen Diosun mia kupikatsis ibiakin man ea ikunwainwen taexun jau ana shinanyamanun en mia buaxunaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","januxun Diosun jancha kenenibu yusinananmisbu bestibu tsauxun shinankin: ");
INSERT INTO cbsNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ja juni chakabuki. Nuku padain Dios keskakatsi ikikiki. Diosun besti jawen chakabu buatiduki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","10","januxun tsuan Jesús yuiamabia jatun shinan unankin Jesúsun jatu yuikin: —Matunan, ¿jaskakin man shinan chakai ikai? ¿Jadatu bikamamen, jawen chakabu buaxunadaka? ¿Jawen yuda beniadaka? Ja dabe bikaken Diosun besti atiduwen taexun ¿jaskakin man shinanchakai? En matun Juchi Kayabi Iyua na mai anua ea en jawen kushipa jayatun jawen chakabu en buaxuntidu man unanun en akai uinkanwen— iwanan, juni yuda babuni kaya wakin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Benitan min dakati bui min jiwe anu inun kadiwe— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","jawen yuda damestentan benikauan jawen dakati bitan iabainaya mapubaunabun uinkin yuikin: —Jabaa! Tsuan jaska waismaki. Jakia Dios pepajaidatun na juni ma kayawaxuki— iwanan, Dios kenwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Janua ana ianenwan kexa anu Jesús ka jaki yudan kaian ichabu jatu yusinbai ");
INSERT INTO cbsNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","janua kakin Cafarnaúm anuxun Romabun gobierno pei bixunmisbu jiwe anu Alfeon bake Leví jawen kena betsa Mateo tsaua Jesúsun bechitushitan yuikin: —Ea chibankubainwen— aka Leví benitan chibankin taewabainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","16","janua chipu Jesús inun jawen tsumabun Levín jiwe anuxun piaibun jabianudi Roma xanen ibu pei bixunmisbu ichapa inun jabun fariseobun yusian ninkaisbuma ichapabun Jesúsun tsumabu jabubetan pidiaibun Diosun jancha kenenibu yusinananmis fariseobun Jesúsun jabubetan piai uinkin jawen tsumabu yukakin: —¿Jaskakin matun yusinan pei bixunikabu inun ja juni chakabun nuku ninkaisbumabetan pimenkain? Chakabuki— ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesúsun jatun jancha ninkatan jatu yuikin: —“En peki”, iwanan, shinainbu anu juni dauya kaismaki. Jakia isin teneaibu anu besti juni dauya kenabu kamiski. Jaskaken “En chakabuki”, iwanan, shinainbu jatun juinti pewakin medabewatanun ika en juxuki, juni dauya keskaidan. Jakia “En chakabumaki”, iwanan, shinainbu jatu medabewatanun ika en juamaki— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Janua Nashimanika Juanki chiti ikabu inun fariseobuki chiti ikabudi samakeaibun juni betsabu Jesús anu kaxun yukakin yuikin: —Juanki chiti ikabu inun fariseobuki chiti ikabu jatun chakabuwen taea jatunmebi ichakanikai samakekin jabun jawa piyuisbumaki. ¿Jamen jaskai miki chiti ikabu samakeama pikubainmisbumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesúsun jatu yuikin: —Juni ainyain nawaibu anu jawen jaibuaibu paxkadiabuma piama jatunmebi ichakanikatidubumaki. Jakia jatu xunubaini kaken manui jawen jaibuaibu samakekin piama iyutidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jabiaskadi wakin ea achixun iyuaibun ewen nui en jaibuaibun piama idiaxankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ana yusinkubainkin yuikin: —En yusianan, tadi bena chukadiama keskaki. Matu yusinun ninkakanwen. Tadi xeni baxnekea tadi bena tuax chukadiamawen tadi xeni tsamian patsa estei ana baxnekemiski. Jamen matun yusianan, tadi xeni baxnekea keskaki. En yusianwen tsamian keska wakin matun yusian en pewatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ana jabiaskadi keskawen matu yusinun ninkakanwen. Bichi bishtu xeniki uva jene bena buspudiama manekin mata waxun denex mestenwan jamebi katsai buspui bichi bishtu xeni pexemiski, vino bena inun bichi xeni benuidan. Jabiaskadi wakin en yusian bena matun shinan xeni en jusitidumaki, benukinan— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Januxun ana sábado juindukunti betsatian xekiwan banaimabu anu manan baiwen kakin jawen tsumabu Jesúsbe bukin xekiwan bimi tsekaxun pikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","fariseobun jatu uinkin Jesús yukakin: —¿Jawai juindukunti sábadotian dayakanimenkain? Dayakin Diosun Moisés nuku nemamani min tsumabun kanekanikiki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesúsundi jatu yuikin: —Bunikin jawada nukun xenipabu pepa Davidin jawen jaibuaibubetan anidan, ¿man uinsmamen? ");
INSERT INTO cbsNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Matu yuinun ninkakanwen. Abiatar Diosbe nukunabu janchaxunika xanen ibuaya Dios kenwanti tadi jiwe medan David jikixun ja medibi misi Dios uinmakin janakubainaibu Diosbe nukunabu janchaxunika jabun besti pitibiaken jawen Dios kenwanti misi David bunikin bixun pitan jawa dateama jawen jaibuaibudi pimadianiki. Jaska wabiaya Dios jaki sinatama iniki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","jabianuxundi Jesúsun ana jatu yuikin: —Juindukuntiwen yudabu bikawanun, iwanan, Diosun juindukunti wama iniki. Jakia jatu medabewanun, iwanan, juindukunti wakin Diosun yudabu axuniwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","en matun Juchi Kayabi Iyuatunan, juindukuntitian jamapai betsa betsapa en atiduki— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Janua ana ichati jiwe medan Jesús jikiaya juni meken meyushki jadi jatube jikia tsauken ");
INSERT INTO cbsNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","januxun jabun jawen yusian danankin Jesús chitenun, iwanan, juindukuntitian ja juni mepeai uinun, ixun manai maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","juni meken meyushki bechitan Jesúsun yuikin: —Benikidan ja maniabu namakis niwe— aka benia niken ");
INSERT INTO cbsNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ja dapi maniabu jatu yukakin: —Moisin jancha pepa chibankin juindukuntitianan, ¿jaska watimen? ¿Pewakin medabewatidaka? ¿Chakabuwakin ichakawatidaka? ¿Jawen jiwea meketidaka? ¿Jawen jiwea yamawatidaka?— jatu wa jabun jawa yuiama manixun ");
INSERT INTO cbsNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","yuinamea akeakekin jatun shinan bikawaibun Jesús ninkakatsis ikabumaken janua Jesús sinatai juinti nishmaxun jatu uinkin keyutan ja juni meken meyushki yuikin: —Min meken meshanwen— aka meshanyan jawen meken ma mepekei peaya ");
INSERT INTO cbsNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","fariseobu kain keyubaina judio xanen ibu Herodeski chiti ikabube icha jaska waxun Jesús tenantimen ika yuinamei yubakai taenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Janua Jesús jawen tsumabube ian kexa anu kaya yudan kaian Galilea anuabun jatu chibainbun ");
INSERT INTO cbsNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","januxun jamapai betsa betsapa Jesúsun akai ninkabidanbidanaibun uintanun ika bei, Judea anua bei, Jerusalén anuadi bei, Idumea anuadi bei, Jordán jene kexa betsaudiadi bei, Tiro inun Sidón anuadi beake beakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","12","isin teneaibu ichapa xuxawashinken jabundi jawenabu isin teneaibudi iwekin Jesús mematanun ika bei jaki ichai keyuabun jabianudi yushin chakabu yuda medan jiwexun Jesús uintan ja yuda Jesús anu danti imatan jancha kushipawen yuimakin: —Miadan, min Diosun bake kayabiki— ibidan ibidanaibu jatu janchamamakin: —Janua ekidi jaska janchama kainkanwen— jatu wapakekin Jesúsun yushin chakabu jatu nichiainwen taea ana jaki ichai texke ikaibu uinkin jatu dapaxkabainun, iwanan, jawen tsumabu yunukin: —En xaxun inai ea xutukanxun xaxu pewai bukanwen— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","15","Xaba betsatian mananan mati anu mapekexun Jesúsun jaki chiti ikabu betsabu kenakin: —Ea anu bekanwen— jatu wa bei jaki ichaibu 12 juni besti katukin yuikin: —Matu yusinun tapin ebe bukubainkanwen. Kakape ekidi man jatu yuikubainxanunbun jancha kushipawen yunutishada wakin en matu yunuaii, man en kushipayabu wakin matu kenakinan. Jaska bitan isin teneaibu man jatu xuxawakubainxanunbun inun, yushin chakabu jayabu man jatu kainmadiakubainxanunbun en matu yunuaii— akin ");
INSERT INTO cbsNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ja 12 junibu katukin Simón, kena betsa wakin Pedro watan ");
INSERT INTO cbsNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeon bake dabe Santiago inun jawen betsa Juanbe ana jatu kena betsa wakin Boagnerges, juni kuin janchadan, Kana Tin Ikainkainmis Keskatun Bakebudan, jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés inun, Felipe inun, Bartolomé inun Mateo, jawen kena betsa Leví, inun Tomás inun, Alfeon bake Santiago inun, Tadeo inun Simón, ja Roma anua xanen ibubu jatu danankin jatu nichinkatsis imis ");
INSERT INTO cbsNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","inun, Judas Iscariote, jatun Jesús chipu jatu achimaxanaidan, jati katunikiaki, Jesúsun tsumabudan. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Janua jatu jaska wabidani jawen tsumabube jiwe betsanu Jesús jikiken ana yudan kaian jaki ichabu janixun Jesús inun jawen tsumabun pitidubumaken ");
INSERT INTO cbsNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús jaskai jawen ewa inun jawen betsabun ninkatan yuinamei: —Unainsmapai tidumai ikikiki. Inun bukanwen— ibidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","janua Jerusalén anua Diosun jancha kenenibu yusinananmisbun uinkin Jesúskidi yuikin: —Na junidan, yushin chakabu xanen ibu Beelzebún kushipa jayaki. Jaska bestiwen taexun yushin chakabu jatu kainmaikiki— ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ninkatan Jesúsun jatu ichawaxun eska miyuiwen jatu yuikin: —Satanásan ibubis jawen yuda Satanás kainmatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Miyuiwen matu yusinun ninkakanwen. Mae betsa anua nawabu jatunmebi paxkatan detenamei jatun yuda debui keyumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jaska inun, yudabu jawenabuyas paxkatan jatunmebi duanameama sinatai jiwea petidubumadiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jaskaken Satanásan jawenabu kainma jawen yuda punu nukai babui keyukeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jabiaskadi wakin tsuanda juni kushipatun jiwe anu jikitan yumetsunun, iwanan, jawen tae inun jawen meken dukun neatan jawen mabu yumetsutidubuki. Jamen eanan, jaska keskadi wakin Satanás maemakin jawen kushipa mebintan en binutiduki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Diosun jancha kenenibu yusinananmisbun yuikin: “Min yushin chakabu jaya iki ikaii”, akaibuwen taexun Jesúsun jabu yuikin: —Chanima en matu yuiai ea ninkakanwen. Yudabun jabun chakabu betsa betsapa inun jabu Dioski xechakamisbu Diosun jatu jakimawakin jatun chakabu jatu buaxuntiduki, pewakinan. Jakia matu keskakin tsuanda jawen Yushin Pepa danain jaki xechakamisbu jatun chakabu jatu buaxuntaskama ixanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesúsun jatu yusinkin keyudiamaken jemaintin anu jawen ewa inun jawen betsabu jabe janchanun, iwanan: —Jesús ea yuixunkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ja dapi tsaubaunxun Jesús yuikin: —Min ewa inun min betsabun unu jemaintinxun mibe janchanun ixun mia kenakanikiaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesúsun jatu yukakin: —¿Tsuabumen, en ewa inun en betsabudan?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ja dapi tsauabu uinbaunkin jatu yuikin: —Na jabia ea dapi manixun ea ninkaibudan, jabiabu en ewa kayabibu inun en betsa kayabibu inun en pui kayabibuki, na jabiabudan. ");
INSERT INTO cbsNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ja inun, Diosun jancha tsuabunda ninkatan ikunwankin jabun chibanbainkin axuainbudan, jabiabu en betsabu inun, en puibu inun, en ewabudiki— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","2","Ianenwan kexa anuxun Jesúsun ana jatu yusinkin taewaya yuda ichapabun ninkanun ika beabu ianenwan kexa anu dasibi tsauxun ninkaibun ian kexa xaxu namaki Jesús tsauxun miyui betsa betsapawen jamapaikidi jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Miyuiwen matu yusinun ninkakanwen. Juni betsa jawen bai anu xekiwan jexe sa aki kaxun ");
INSERT INTO cbsNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","sa akubaina jexe betsa janu kati bai namaki nidi aka peiyabu bexun keyu xeabun ");
INSERT INTO cbsNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","jexe betsa mishki ewapabu mania anu mai eskadabes bemanchimea anu kauanadan, jawaida pexei benekaunaya ");
INSERT INTO cbsNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","badi jui kukin jawen tapun bemakis bewexekea kua utsi xanamiski. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ja inun, jexe betsa muxa jukundiamanu nidi aka xekiwan beneai muxa jukunkin yabua jaskatan bimitidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jakia jexe betsa mai pepa anu nidi aka benei bimi ichapajaida jayamiski, jexe betsa yumetan 30 jexeyai inun, jexe betsa yumetan 60 jexeyai inun, jexe betsa yumetan 100 jexeyaidan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ana jatu yuikin: —Man pabinkiyabuki. Ninkatan jakimayamaxankanwen— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Janunkain yudan kaianen ma Jesús jenebainabun ja mesti tsauken jawen 12 tsumabu inun jaki chiti ika betsabun jaska miyuiwen jatu yusinxu yukabu— ");
INSERT INTO cbsNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesúsun jatu yuikin: —Matudan, jaskai Dios xanen ibumiskidi Diosun jawen pepa juneni xabakabi man en tsumabu matu yusinkin unanmaikiki. Jakia jabun Diosun jancha ninka bestiaibu miyuiwens besti en jatuki chanikunkainaii, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","jabun chakabu Diosun jatu buaxunkatsi ikamawen taexun ninkabiakubainkin jau xabakabi ninkayamanunbun inun uinbiakubainkin jau jatun chakabu bexteketan Dios ikunwanyamanunbunan— akin ");
INSERT INTO cbsNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","—¿Jaska jancha juneawens en jatu yusinxudan, man ninkama ixumen? ¿Dasibi miyuiwen en matu yusianan, man daka tapinkin ninkama ikubainkanai?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ana jatu yuikin: —Miyui jexe nidi akakidi matu xabakabi yusinun ninkakanwen. Juni betsan Diosun jancha kenenibu yusinananmisdan, jexe sa aka keskaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ja jexe betsa jawen kati bai namaki nidi ikadan, yudabun Diosun jancha ninkabiaibun jamakidia Satanás juxun jawen jancha pepa ninkatanais mebinmiski, jakimawakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ja inun, jexe betsa mishki ewapabu mania anu mai eskadabes bemanchimea anu nidi akadan, tsuanda Diosun jancha ninkakin taewai benimabiaya ");
INSERT INTO cbsNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","shinan pewamawen taexun jawen jiwepanan Diosun jancha dananmakin jatu bika wakin jawen jamapaiwen jatu ichakawabu tenei jawawen jaskatima ja uintan ana jawendi chintunbainmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ja inun, jexe betsa muxa jukundiamanu nidi akadan, yuda betsabun Diosun jancha chiban taewabiai ");
INSERT INTO cbsNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","jamapai jawen jiweawens kemui jeneama jawens besti nuichakayamakin Diosun jancha ninkabiakin ana tapinkatsi ikama mabuwens besti kemui icha bestiwanun ika pepaisbumaki, jaskatun yabua jancha pepa chibanma yudabu miban bimiuma keskabuidan. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jaska inun, jexe betsa mai pepa anu sa akadan, Diosun jancha ninkaxun yuda betsabu jatu yusinkin ikunwanmamisbuki, mai pepa anu jexe nidi aka ewai benei bimiai betsa 30 jexeyai keska inun, betsa 60 jexeyai keska inun, betsa 100 jexeyai keskadan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesúsun ana jatu yusinkin: —Bin dekutan ji bau medan junetima inun tapu naman tsauntima man unaiin. Jakia bin dekuxun jau jawenabu jikikin uinshadanunbun manaundi tsaunmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaskaken jawada en matu yusinkubainai yuda betsabu jatu yusinkin juneyamakubainxankanwen. Jaska inun, jamapai tibi junekin man jatu axuanmadan, dasibi Diosun jatu xabakabi waxunkin keyuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jaskaken man pabinkiyabunan, na jancha ninkatan jakimayamakubainkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","januxun ana jatu yusinkin: —Man yuda betsa medabewakin pewamis jabiaskadi wakin Diosun matu manakukin pepawendi man amis keskama ana matu binumaxanikiki. Januxun man jatu medabewachakamis jabiaskadi wakin Diosun matu inanchakadiakin manakukin pemawendi matu kupixanikiki, nuitapawakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jaska inun, tsuabunda en jancha besti ninkakin chibainbu ichapa en ana jatu xabakabi yusinkubainxanaii. Jamen tsuabunda eskadabes ninkabiakin ea chibainsbuma ja eskadabes en jatu mebinxanaii, jakimawakinan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","jaska keskai na mai anua Dios xanen ibumiskidi Jesúsun ana jatu yuikin: —Dios xanen ibuidan, eskamiski, matu yusinun ninkakanwen. Junin xekiwan banatanima ");
INSERT INTO cbsNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","uianmas uxa ichapa binutan janua xekiwan jukuin yumei ewamiski. Jaskai yumeai ja junin unanmabiaken ");
INSERT INTO cbsNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","main yunu benemakin ja dukun jawen pei kainmakin ewa wakubauna ja kachu jawen taxudi kain ewatan janua juatan bimiai beduyai kanimiski. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Janua chushiaya ibuan tsekakin mextekin ichawamiski. Jaska keskadi wakin Dios ikunwainbu ichawadiaxankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ana Jesúsun jatu yuikin: —Dios xanen ibu jaska keskamiskidi miyui betsawen ana matu yusinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Miban betsa mostaza jexe pexeishtajaidabia ");
INSERT INTO cbsNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","mai anu bana bestibiabu ewakin miban betsa tibi binumiski. Jaska inun, jawen punyan ewapashinaki peiyabu jaki juindukuin utamisbuki. Dios xanen ibuidan, jaska keskadiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","yuda dasibibu jancha junea miyuiwens Jesúsun jatu yusinkin jawada ninkatidubu jatu yuia akeakeaya januxun jawen tsumabun jawa xabakabi unankin tapindiabumaken miyuiwens jatu yusinshina januxun jawen tsumabu Jesúsun jatu yui tapinmakin jatu xabakabi yuinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Janua badi kai meshuaya jawen tsumabu Jesúsun yuikin: —Ianenwan kexa betsaudi buyanankanwen— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","januxun yudan kaian xunubaini Jesús jawen tsumabube xaxun inatan xutubaini buaibun janua xaxu betsawen chibain jabe budiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","janua niwewan kushipajaida besubainaibukidia bekin jene buspu tsaubidankin xaxu jene mata waya ");
INSERT INTO cbsNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús jawen tedatametiki xaxu chixukidi daka uxaken jawen tsumabu datekin bestenwantan yuikin: —Yusinaan, nun jikiaidan, ¿min nukuwen dabanan ikamamen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","janua Jesús bestenkauan benitan niwewan kushipa inun ianenwan nemakin: —Peswe. Nesewe— aka niwewan main neseaya ianenwandi buspu tsaubidanai main neseaya ");
INSERT INTO cbsNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesúsun jatu yuikin: —¿Jaskai man dateai? Ea shinainan, man dateama ikeanaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","e iki dateyabi yuinamekin: —Na junidan, ¿jawa junimen? min atidumakidan, niwe inun ianenwanendi ninkakanikikidan— ibaini bui ");
INSERT INTO cbsNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","janua ianenwan kexa betsaudi Gerasa mai pakeanu Jesús kai keti itan ");
INSERT INTO cbsNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","xaxu anua bututan jawen tsumabube mapekekainaya janu mawabu maiwamisbu anu juni yushin chakabu jaya Jesús bechitan juaya ");
INSERT INTO cbsNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","ja juni yushin chakabu jaya jawawen jaska watima mane dispiwen nexakin mestenwanbiakubainabu jawenchains mane dispi nasakin tesaya jawen tae tanexkin inun jawen meken menexbiabu dasibi pekakin ja mane dispi tesakin chudi mishtinwankin keyuaya ana jaska waxun tsuan nematidumadan, ");
INSERT INTO cbsNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","janua meshu medan inun badidi nia sai ikin mawabu maiwamisbu anu inun mati anua sai idiai inun mishki maniaki ibubis tin tin iki dachakamemisken ");
INSERT INTO cbsNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","jakia Jesús chai juai bechibidani kushi chakayamakidan ja dapi danti ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","9","Jesúsun yuikin: —Yushin chakabuun, ja juni anua kainwen— atan yukakin: —¿Jadakidi min kena ikai?— aka yuikin: —En kenadan, “Ichapajaida En Jayaki”, en yushin midimayadan— iwanan, sai ikin jancha kushipawen yuikin: —Jesúsuun, min Dios kushipajaidatun bakedan, en unaiin. Diosun nuku uianyan nukudan, kupikin nuku nuitapawayamawe!— itan sai ikin ");
INSERT INTO cbsNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ana yushin chakabun Jesús ea akin yuikin: —Nun nanta kakatsi ikamaki. Nuku nanta nichinyamawe— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ja mati anuxun ina yawa ichapabun piaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","yushin chakabun uintan ea akin yuikin: —Ja ina yawa anu nuku nichinwen, ja medan nun jikinunan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","januxun Jesúsun jadi jatu yunua ja juni anua kainbaini ina yawa medan jikibainaibun ja ina yawa 2,000 datei mawa keyatapa butei nidi ibaini ianki pukui jasai keyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","janua ja ina yawa mekenikabu datei kushibainkin mae tibi anu jiweabu inun bai puchinin jiweabu jatu banabima akeakebainaibun yuda ichapabun ninkatan uin beaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","janu Jesúski nukuxun ichapajaida ja juni yushin chakabu jaya ikunkidanshina ma tadi sawea ana unainsmapa keskama janu Jesúsbe tsaua ana jaska dabanen ikin datekin ja juni jaskaxu jabun uintan jatu yuikin ja yushin chakabu ina yawa medan jikibainxu chaniaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ninkatan ja mae anuabun mesekin Jesús nichinkin: —Nukun mae anua kadiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","janua Jesús xaxun naneaya janua ja juni yushin chakabu kainmaxutun Jesús ea akin yuikin: —¿Mibe kapa?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","nemakin yuikin: —Ebe kayamawe. Jakia minabu anu kaxun jaska Dios miwen nuikin yushin chakabu mia kainmaxu minabu yuiditanwen, jau miwen benimadinunbunan— abaini kaya ");
INSERT INTO cbsNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","januxun ja juni yushin chakabu jaya Jesúsun kainmabaina kaxun nawa betsabun mae Decápolis yuiadan, juni kuin janchadan, Mae Meken Dabeti anu kaxun ja juni jaska Jesúsun duajaidawakin ja yushin chakabu kainmabainxu jatuki chanikunkainaya ninkai dasibi benimai Jabaa! iki keyunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Janua Jesús ianenwan kexa betsaudi katani ana jawendi chintunkidani jui keti ikaya janua ian kexa anu yudan kaian Jesús uinun ika bei ichabidanbidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","janua janu ichati jiwe mekemis xanen ibu betsa jawen kena Jairon Jesús bechibidani juxun danti ixun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ea akin yuikin: —En bake ainbu mawakatsis ikikiki. Ebe kaxun en jiwe anuxun uinkin jau xuxanun ea mexuniyuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","janua Jesús jabe kaya yudan kaiandi jabedi bukin Jesús nashui akin texke abainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","janua ainbu jimi baxneni ja isin tenei ma 12 año kabia jawa neseisma badi betsa tukama ikunkainmis ");
INSERT INTO cbsNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","janua nuitapaya juni dauyabun jau ea xuxawanun, iwanan, jawen pei dasibi putakin keyubia jawa maianma ikunkaini jakia ana pikujaidakin ");
INSERT INTO cbsNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Jesúskidi janchakin yuiaibu ninkatan ja yudan kaian supu ibaini jabe buaibu anu ja ainbu isin teneya chipu kakin: “Jawen tadi kexa besti mea en xuxatiduki”, iwanan, shinanbaini kakin nashui ikain Jesúsun tadi kexa metsatushia ");
INSERT INTO cbsNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","jawaida jawen jimi nesei maintan: “Ma en xuxaxubiin!” iwanan, shinanyan ");
INSERT INTO cbsNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","jawen kushipa kainkain tsuada ma xuxaxu Jesúsun unankin yudan kaian jachun beaibu uinbaunkin Jesús niti itan jatu yukakin: —¿Tsuan man en tadi metsaxumen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","januxun jawen tsumabun yuikin: —Na yuda ichapa bei miki supu ibidankin mia akanikiki. Tsuan mia axu nun unanmaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","jatun Jesús metsaxu ainbu uinun ika nasaukekauanaya ");
INSERT INTO cbsNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ainbun unain datei saki saki ikin jawada Jesúsun axu unain ja bebun danti itan xabakabi Jesúski chaniaya ");
INSERT INTO cbsNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesúsun yuikin: —Ainbuun, min ea ikunwanyan en mia xuxawaxuki. Ana isin teneama unanuma kai pediwe— ");
INSERT INTO cbsNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","aki niken janua Jairon jiwe anua jawen tsumabu bexun Jairo yuikin: —Min bakedan, ma mawaxuki. Ana juni yusinan daketapa wayamawe— akin ");
INSERT INTO cbsNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","yuiaibu Jesúsun ninkakin Jairo yuikin: —Dateama ea besti ikunwankubainwen— abaini kakin ");
INSERT INTO cbsNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","janua Pedro inun Santiago inun jawen betsa Juan besti Jesúsun jatu iyukin ");
INSERT INTO cbsNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairon jiwe anu jabe buaibun janua jancha biski ikaibu ninkakin yuda ichapa kaxai sain iki bau bau ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","janua Jesús jatu anu jikikain yuikin: —¿Jaskai e iskaun kaxai man biski ikanai? Jawen bake mawa kayabiamaki. Uxaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","januxun Jesúsun jaska yuiai yuda ichapabun usanbaunaibun januxun Jesúsun jabu kainmatan jawen epa inun jawen ewa inun jawen tsumabu jabe buabube ja ainbu bake janu daka anu dintu medan jikikain ");
INSERT INTO cbsNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","metsunxun yuikin: —Talitá, cum— iwanan, nukun janchadan —Chipashaan, beniwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","jawaida ja chipash 12 badiya benikaunaya jawen ibubu inun jawen tsumabu e itan yuikin: “Jabaa!” ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","januxun Jesúsun jatu nemakin jau tsuki chaniyamayununbun ana yuikin: —Matun bake pimakanwen— jatu wabainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Janua Jesús jadi katani ana jawen mae janua yumeni anu jawen tsumabube jikishinabun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","sábado juindukuntitian janu judiobu ichamisbu anuxun jatu yusinkin taewaya juni ichapabun ninkai e itan Jabaa! iki yuinamei: —¿Na junidan, janixun jaska tsuan jawen kushipa tapinshinamen, ja atimaska nun atiduma aki unanepajaidaidan?— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—Jakia nadan, ji mabu wanikaki. Jawen ewadan, María inun, jawen betsabudan, Santiago inun, José inun, Judas inun, Simónki. Janua jawen puibudan, nenu nukube jiwediabuki— itan ikunwanma danainbun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesúsun jatu yuikin: —Diosun jancha yuixunika juxun yudabu jatu yusianyan betsa betsapabun ninkakin duawaibun jakia jawen mae anu kaxun jawenabudi jatu yusindia jabun jawen jancha danainbun jabiatiandi jawen jiwe anuabu inun jawenabu betsabun danandiamisbuki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","januxun isin teneaibu eskadabes jatu mekin jatu xuxawatan jawada atimaska Jesúsun ana jatu axunkin jatu uinmama ");
INSERT INTO cbsNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","jaska jatuwen nuikin yusinbia jabun ikunwanbumawen taea juinti nishmai e inikiaki. Mae udama jiweabu tibi besti anu kakunkaunkin Jesúsun jatu yusinkubauntani juxun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","januxun jawen 12 kushipayabu kenaxun yushin chakabu kainmati kushipa jatu yunukin juni dabe tibi yunua akeakekin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Kaidan, man eska baintanunbun matu yuinun ninkakanwen. Mais butankanwen, jawa buamadan. Jakia matun mestenti besti man butiduki. Ja inun, misi inun, kapankan inun, jaki pei aduti buyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Matun tae pewetametia inun sanpu ma saweaya besti bukanwen, ana betsa buamadan— akin ");
INSERT INTO cbsNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ana jatu yuikin: —Kadan, jiwe bestichai mae tibi anu jiweyuxun yusinkubaintankanwen. Januxun yusinkin menetan mae betsa anudi maekubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jaska inun, janixunda matu danankin ninkakatsi ikabumaken Dios jatuki sinatai unanti wakin janua kainbainkin matun tae anua mai kudu jatuki tabainxankanwen, jau jabiaskasi maninunbunan, jawa unanmadan— jatu wa ninkatan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","janua jawen tsumabu buake buakexun dabe tibi kaxun jatu yusin taewakin: —Dioskidi man chakabumis jenetan matun shinan betsa wadikanwen— jatu wakin ");
INSERT INTO cbsNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","yushin chakabu kainmakin kaya wakubainkin isin teneaibu xeniwen dapuxkin jatun isin mainwankubaunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Janua jawada Jesúskidi chania akeakeaibu xanen ibu Herodesin ninkatan jawen tsumabu yuikin: —Nashimanika Juan mawashina ana bestenshinxun jawen kushipa Jesúski maewa jatun jawen kushipawen atimaska jawa nun atiduma Jesúsun jatu uinmaikiki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","januxun juni betsan jawen shinanen yuikin: —Ja Jesúsdan, Elías ana jushianki. Elías ikibikain— ikaya betsandi yuikin: —Ja Diosun jancha yuixunika nukun xenipabube jiwepauni betsaki, ja Jesúsdan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodesin jatu ninkatan yuikin: —Jabaa! Juan en jatu yunua texteimabudan, ma bestenshinamenkain— inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodesin eska shinankin anidan, matu yuinun ninkakanwen. Badi betsatian Herodesin jawen betsa Filipon ain Herodías mebinmaken Juanen nemakin yuikin: —¿Jaskakin min betsan ain mebintan min ainwainmamen? Jaskatimajaidaki. Ainwanyamawe— akubainaya atimas jawen ainkidi shinain jenekatsi ikama nuikin xanen ibu Herodesin jawen policiabu yunua Juan achixun mane dispiwen menextan bichiti jiwe medan bichiabun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","xanen ibun ain Herodías Juanki sinatakin jatu tenanmanun ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","jakia Herodesin jaska Juan juni pepa unankin jawen ain nemakubainkin dasibi jawen yusian ninkabiakubainkin jawen shinan pewadiama ikunkainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","janua jawen badi janu kaini taxniaya januxun jatu beyusmakin nawamakatsis ikin jabu jatubetan yunumisbu inun, soldadobu xanen ibubu inun, Galilea anu pei ichapayabu jawen jiwe anu jatu ichawaxun jatu pimaya Herodíasin jawen bene padankin Juan jatu tenanmakatsis ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodíasin bake chipash jatu nawaxunkin xanen ibu Herodes inun ja jatu pimakin ichawa jatu benimawaya Herodesin jawen aniwa yuikin: —Jawada min ea yuka en mia inanxanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","yubakin ana yuikin: —Jawada betsa betsapa min ea yuka nukun mai pakea namakis paxkaxun en mia yunutiduki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ninkatan chipash nawai mainkaini kaxun jawen ewa Herodías yukakin: —Ewaan, ¿jawa yukatanpa?— aka jawen ewan yunukin: —Nashimanika Juan jatu textemaxun jau mia jatu bemaxunun ja ea atanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","jawen epa xanen ibu Herodes anu jawaida ana jikikain yuikin: —Na jabiatian Nashimanika Juanen buxka ea inandiwe, sapa kenchakidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","jawen juinti metexekei punu nukatan Nashimanika Juan tenankatsi ikamabia ja jatu pimaibu bebunxun jawen aniwa ma yubai ninkakanxunwen taexun jawen yuba binumakatsi ikama ");
INSERT INTO cbsNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","jakimamadi ja soldado bichiti jiwe anu jau katanun xanen ibun yunukin: —Juanen buxka textexun ea bexuntanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","soldado kaxun bichiti jiwe medanua Juan textetan jawen buxka sapa kenchaki nanebidan bexun ja chipash inan ja chipashan jawen ewa inanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jaska wakin Juan tenankanxu jawen tsumabun ninkatan bexun jatu yukatan jawen yuda bibain maiwati anu maiwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Janua jawen kushipayabu yunua butani Jesúski ana jaki dasitan jaska wakubauntanshinabu Jesúski chania akeakei meneabun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","yudan kaian Jesúski ichabu janixun jawen tsumabun pitidubumaken Jesúsun jatu yuikin: —Benanta jatu dapaxkabain jadia juindukunyunun bukanwen— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","janua Jesús jawen tsumabubes xaxun inatan kai janu tsua jiweabumanu buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","jakia Jesúsun jatu jenebaini kakin mae tibi dunkebainai uin Jesús dunkenanain bechibaini chibain kushibaini mae bestibu tibi anuabudi bui Jesús jikidiama jabu dukun bebunkidi jikia maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús xaxuwen kai keti itan xaxu anua butukainkin yudan kaian uin jatuwen nuijaidakin jabu chaxuwan uinikauma keskabuwen taea jatuwen dabanan ikin jatu yusin taewaxun betsa betsapawen jatu yusinbaiaya ");
INSERT INTO cbsNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","janua ma badi kaya jawen tsumabu Jesús dapi buxun yuikin: —Ma badi kaikiki. Nenu tsua jiweabumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Na yudan kaianen jabun jania pitidubumaki. Ja mae udama tibi anua jau misi bixun pitan jau jaskadabaintanunbun jatu nichindiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesúsun jatu kemakin nemakin: —Jaska jatu wama, matun jatu pimakanwen— jatu wa januxun jawen tsumabun yuikin: —¿200 día nun dayai peiwen jatu misi bixuntanpa, jau pinunbunan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesúsun jatu yukakin: —¿Jati misi man jayamenkain? Uintankanwen— jatu wa buxun uintanxun yuikin: —Meken besti misi inun baka dabe besti nun jayaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","januxun jawen tsumabu Jesúsun yunukin: —Jatu ichawa akeakekanwen. Ja basiki jau tsaununbun jatu yunukanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","jatu yunuabu jatidi xuku betsai 100 inun jatidi xuku betsai 50 mania akeakebaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesúsun ja misi meken besti inun baka dabe tsumaxun naiudi teskanxun uinkin pitikidi Dios kenwantan misi tunke tunke apakekin jawen tsumabu inankin jatu yunua ja yudan kaian inanbaunaibun januxun baka dabedi jatu inan jadi jatu inan keyuabu ");
INSERT INTO cbsNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","dasibibun yani wai benimai pepeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","janua ja misi meken besti inun baka dabe ja dabe jatu paxkaxuna 5,000 junibun pikin texe wakanxu ichawakin 12 kuki jawen tsumabun mata wanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Janua nuku dukun bebunkidi ianenwan pukei Betsaidaudi nun jawen tsumabu kanun xaxuwen nuku yunua nun kaya yudan kaiandi jatu nichinbaini mati anu ka Diosbe janchanun ika ka Jesús ja mesti niken ");
INSERT INTO cbsNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","meshu medan jawen tsumabu ianenwan namakis bui nunubainaibun Jesús ja mesti main nixun uiainyan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","jawen tsumabun xaxu tuein bikaibun niwewan bekin xaxu chixtekidi butan butanaya ma pena kemaya Jesús jatuki nukuyui ian bemaki bepaikidankin jatu dainbaini ");
INSERT INTO cbsNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ja ian bemaki kaya uin yushin dabanen sai iki ");
INSERT INTO cbsNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","dateaibun Jesúsun jatu janchawakin: —En eaki. Ewen dateyamakanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","janua jawen tsumabuki xaxun inaya niwewanen ian bechudunwain maianyan jabu jadakidi shinantima jatu wa Jabaa! iake iakekin ");
INSERT INTO cbsNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesúsun jaska jatu misi pimai uinbiabidankanxu jawa jatun shinan xabakabidiabuma jaska tapindiabuma inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Janua ianenwan pukei besusi bupananbun niwen jamakidi jatu bukin xutua mae betsa Genesaret anu keti itan jatun xaxu nexatan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","janua butubainaibu yudan kaianen Jesús unantan ");
INSERT INTO cbsNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","mae kesua anua kushibidankin isin teneaibu jatun baketiki bakebidankin Jesús anu jatu iweabu ");
INSERT INTO cbsNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","janunkain mae udama tibi anua inun bai puchinin jiweabu anua isin teneaibudi bai tanamabidankin januxun jau Jesúsun tadi metsanun, iwanan, jatu Jesús ea axuanbu jawen tadi kexa ja isin teneaibun metsatan dasibi main kaya akeakenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Fariseobu inun judiobu dasibibun jatun xenipabun beyakidi matu yusinun ninkakanwen. Jabun xenipabun beya tibi chibankin fariseobu inun judiobu dasibibun pidiama mepanui taemisbuki, chakabu nemaidan. Jaska inun, piti bitani jui jikitan jawen beyawen taea jatu meuxkeabu mepanukubainmisbuki. Jaska inun, jatun xenipabun beya betsa betsapa chibankin jatun kencha dachukin jatun shumu napankin jatun mane kencha dachukin jatun dakati unpaxwen bewash bewash atan tede amisbuki. Jaska jatun xenipabun beya chibankin akeakekubainmisbuki. Jaska wamisbuwen taea fariseobu inun Diosun jancha kenenibu yusinananmisbu Jerusalén anua beshianbu Jesúski kemaxun uinkin jaska jatun xenipabun beya chibanma Jesúsun tsumabun pidiama mepanuabuma piaibu uinkin jatu yuankin ");
INSERT INTO cbsNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jesús yukakin: —¿Jaskakin min tsumabun nukun xenipabun beya chibanma mepanuma pikanimenkain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Jesúsun jatu yuikin: —Man yusinmis keska akama man bepadamemisbukidi chanima bebunkidi Diosun matukidi yuikin: ‘Na yudabunan, jatun janchawen ea kenwanbiakin jatun juintiwen ea shinainsbumaki. Ja inun, ichatan jawa ea kenwankin pewaisbumaki. Jakia junibun yunuawen besti jatu yusinkubainmisbuki’, aka jawen jancha yuixunika Isaíasin ninkatan keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jaska waniwen taea Diosun yunua shinankin chibanma yudabun beya besti man chibanmisbuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ana jatu yuikin: —Matun beya betsa betsapa besti chibankin jakia Diosun yununi shinanbiakin man akin pewaismaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Eska Moisin yununi ana matu shinanmanun ninkakanwen: “Matun epa inun matun ewa medabewakin jatu duawakubainkanwen. Jakia matun ibubu man jatu ichakawaya jau matun xanen ibubun matu tenanxanunbunwen”, abianiken ");
INSERT INTO cbsNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","jaska shinanma matumebi ibubis matun jancha watan jatu yusinkin: “Matun ibubu jawadawen medabewati mabu man jaya man jaki tanabia Templo anu inankuinkatsi man butidu man shinantiduki. Tsuan matu ana bikawatidubumaki”, akin man jatu yunuchakamiski, nemakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jaska wakin jatu nemakin man jaska wakubainaibu tsuan ana matu yunu yunu atidubumaki, matun ibubu man medabewanunbunan, akin man jatu yunumiski. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaska wakin matumebi ibubis beya betsa chibanti matuna watan Diosun yununi jancha man jatu jakimawamiski, yunuti betsa betsapa jatu maewaxuankea akekinan, jau ja chibanunbunan— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","16","ana Jesúsun yudan kaian kenaxun jatu yuikin: —Man pabinkiyabuki. Matu yusinun ninkakin peidawakanwen. Piti tibi yudabun piabu jawa jatu jawen chakabuwaismaki. Jakia yudabun juinti medanua besti jawada chakabu taxnikin Dios jatu dananmamiski, yudabuki sinatamakinan— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","janua Jesúsun yudan kaian jenebaini jawen tsumabube jiwetan jikiaibun ja miyuiwen jatu yusinxukidi ana jawen tsumabun yukabu ");
INSERT INTO cbsNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Jesúsun jatu yuikin: —¿Matundi man ninkakin tapindiabumamen? Xabakabi matu yusinun ninkakanwen. Piti shadabu yudabun piabu jatun shinan medan naneama jawa jatun shinan chakabuwatidumaki. Jakia piti shadabu piabu jatun jatuki naneabu puiyabu kainmiski— iwanan —Jaskaken piti shadabun jawa jatu chakabuwatidumaki— jatu anikiaki. Jaskawen taea jawada piti shadabu pikin nukun puku anu nun nanemisdan, pekiaki. Jadan, jatun Dios sintamaismaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jaskawen taexun Jesúsun ana jatu yuikin: —Yudabun shinan medanua jawada chakabu jayabu taxnikinan, jaskatun jatu chakabuwamiski, Dios sinatamakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Jaska inun, eska yudabu jaya jatun shinan uke medan aduabu chakabu shinankin xabakabi taxnimamisbuki. Eska tibi xabakabi shinanwen kainkinan, kemukin jamapai tibi xebi jayabu chutabaunmisbuki. Ja inun, yumetsumisbuki. Ja inun, yuda betsaki yubakatan tenanmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ja inun, ainyan inun beneyabia betsabe chutanamemisbuki. Ja inun, yuda betsan mabuwen kemumisbuki. Ja inun, chakabu betsa betsapa wamisbuki. Ja inun, yuda betsa padanmisbuki. Ja inun, jatun yudawen jawada pae tibi aki paein chakabumisbuki. Ja inun, yuda betsa jawen jiwea keskama jatu uin juni betsa jaska jayatidumawen nui jatuwen bika tenemisbuki. Ja inun, chani chakabaunmisbuki. Ja inun, ibubis shinain kein: “En pepaki”, imisbuki. Ja inun, yuda betsawen nuikin duawakin medabewaisbumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jaska tibi yudabun shinan anua taxnikin jatu chakabuwamiski, Dios sinatamakinan— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Janua Jesús kainkidani Tiro mae pakea anu junekain jikipanan tsuanda unainbun jiwe betsa anu jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","janua judiobuma Sirofenicianawa ainbu jawen bake yushin chakabuya Jesúskidi chaniaibun ninkabidani Jesúski nukuxun danti itan yuikin: —En ainbu bake yushin chakabu jayaki. Ea kainmaxuin kawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesúsun yuikin: —Israelbun piti bixun kaman anu putama ja dukun jau jawen bababun yaniwayununbun metidubumaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","jawen jancha ninkatan Jesús ana yuikin: —Jeen. Yusinaan, nun kaman keskaki. Israelbun besti tapukixun piabun jawen pese kamanen pimisbuki. Jaska keskadi wakin en bakedi min ea kainmaxuntiduki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","jaska ikunwain unankin Jesúsun yuikin: —Min pe yuiaya en mia medabewaxuki. Jaskawen taea min bake anua ma yushin chakabu kainkainxuki. Uinditanwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","kaxun jawen jiwe anu jikitan ja ainbu bake ma yushin chakabu kainma pes daka uintushinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Janua Jesús Tiro mae pakeanu chintuntani Sidón dunkeatain Decápolis kesua anu Galilea ianenwan kexa anu jikiken ");
INSERT INTO cbsNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","janua juni betsa patani inun juyuni Jesús anu iyuxun ea axunkin: —Min mekenwen jaki mepitan nuku xuxawaxunwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ja isin teneai tadi ja mesti metsunbain Jesúsun iyuxun jawen metutinin pamistubukuntan jaxpa watan jawen kemu jamichutan ");
INSERT INTO cbsNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","naiudi besutan juinsinakin yuikin: —Efatá!— iwanan, nukun janchawen yuikin: —Jau pabepemenunwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","jawen pabinki dabe ma pabepemea inun jawen janadi ma janpekea ma jancha kayabiaya ");
INSERT INTO cbsNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesúsun jatu anu ana iyuxun jatu nemakin: —Tsua yuiyamayutankanwen— jatu wabia kaxun yudabu betsa betsapa jatu banabima akeakeabu ");
INSERT INTO cbsNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","e itan Jabaa! Yuu! ikin yuikin: —Jesúsun jamapai betsa betsapa pepa atiduki, patanibu ninkamakin inun juyunibudi janchamaikikidan— inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Januxun ana xaba betsatian yudan kaian Jesúsun jatu yusinkubainaya ma xaba dabe inun besti kaya jatun piti ma keyuabu jania pitibumaken Jesúsun jawen tsumabu kenaxun yuikin: —Ma xaba dabe inun besti ea ninkakin jatun piti ma keyuabuwen taea en jatuwen nuiaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jatun jiwe anu piti mais en jatu nichian bui bai puchinin anua punu nukai babui unanyamastidubuki, betsabu chaikea beshianbudan— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","jawen tsumabun Jesús yuikin: —Nenu tsua jiweabumaki. Jania piti bixun nun jatu pimatidumabin— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesúsun jatu yukakin: —¿Jati misi man jayamen?— jatu wa —Sieteki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","januxun Jesúsun ja yudan kaian yuikin: —Ja main tsaubaunkanwen— jatu watan ja siete misi bixun Dios kenwantan tunke tunke akai jawen tsumabun bibainbainkin ja yudan kaian jatu inan akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","janua baka eskadabesdi jaya Jesúsun bixun Dios kenwandiatan tekepakediakin jawen tsumabu inan jabun jatu inankin mebesa ");
INSERT INTO cbsNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","januxun dasibibun yaniwai benimai pepeaibun ja pikanxu piti texea ichawakin siete kuki matawabun ");
INSERT INTO cbsNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","janua 4,000 yudabun pikin keyuabun Jesúsun jatu yunukin: —En ma kai buditankanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","janua jawen tsumabubes xaxun nanetan bui Dalmanuta mai pakeakidi bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Janua fariseobu Jesús anu bexun jabe ja inun, iwanan, unanti wakin yuikin: —Dios anua jawen unanti dami nuku axunwen, min jawen kushipa jaya nun uinunan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús juinti nishmaxun jatu yuikin: —¿Jaskakin jawada Diosun besti damiwatidu uinun ixun man ea yukai? Chanima en matu yuiai ninkakanwen. Jamapai betsa uinmakin en ana matu axuntaskamaki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","januxun jatu jenebaini xaxun nanetan ana chintunkaini ianenwan kexa betsaudi jawen tsumabu jatu iyua ");
INSERT INTO cbsNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","janua bui misi jakimabaini jawa piti buama misi bestichaiya besti xaxun buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesúsun bebunkidi jatu banabimakin yuikin: —Fariseobu inun xanen ibu Herodesin misi xaxa wati meseki. Uindakubainkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","jatu jaska wa jamakidi shinain jawen tsumabu yuinamei: —Nun misi beama ixuken nuku jaska nemaikiki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","jaskakidi yuinamei janchaibu unantan Jesúsun jatu yuikin: —¿Jaskai buxka kushikin man ninkadiabumamen? ¿Jaskai: “Nun misi beama ixuken jaska nuku yusinkiki”, iki man yuinamekanai? ");
INSERT INTO cbsNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Man beduyabia jawada en matu axuain man uin pewama ikunkainaii. Man pabinkiyabia jawada en matu yusiain man ninka pewama idiakunkainaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eska uinbiaidan, misi meken besti tunkepakexun 5,000 junin kaian en jatu pimadan, ¿jati kuki jawen texe man ichawashinamen, ja pitidan?— jatu wa —Doce kain— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Janua betsadan, siete misi tunkepakexun 4,000 en jatu pimadan, texe wabudan, ¿jati kuki man matawashinamen?— jatu wa —Siete kain— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","januxun Jesúsun jatu yuikin: —Matunan, ¿jaskakin man tapindiabumamen?— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","janua bui mae betsa Betsaida anu jikiabun juni bekuni jau xuxawanun Jesús anu iwexun ea axunkin: —Jaki bemepiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","juni bekun metsunbainkin benanta iyuxun jawen beduki kemu michuxun bemepitan metseketan yukakin: —¿Jaskada min uiain?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","bepexe midintan yuikin: —Junibu uinbiakin ji mapua keska buanaibu en jatu uiaiin— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús ana jawen beduki mepia janunkain ma xuxa xabakabi dasibi uinkin pewaya ");
INSERT INTO cbsNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesúsun jawen jiwetan nichinkin yuikin: —Na mae anu ana jadi kama min jiwe anu inun kadiwe— abainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Janua Jesús jawen tsumabube kai Filipon mae Cesarea chaima anu ana bai tanabainkin jawen tsumabu yukakin: —Yudabunan, ¿en tsua ekidi yuimisbumen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","jawen tsuma betsan yuikin: —Betsabun mikidi yuikinan: “Nashimanika Juan ana bestenshinaki”, mia wakanikiaki. Betsabundi yuikin: “Elías ana jushianki”, mia wadiakanikiaki. Betsabundi yuikin: “Diosun jancha yuixunika betsa ana besteinmaki”, mia wadiamisbukiaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","januxun Jesúsun jabudi yukakin: —Jamen matun shinankinan, ¿man tsua ea yuimismen?— jatu waya januxun Pedron jatu yuixunkin: —Miadan, min nukun mekenika Mesías Cristoki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesúsun jatu nemakin: —En Mesías Cristoki tsua banabimayamayuxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesúsun ana jatu yuikin: —Diosun bake en matun Juchi Kayabi Iyuadan, ea nuitapawaxankanikiki. Eki sinatakin ea ichakawakin mae xanen ibubu inun, Diosbe nukunabu janchaxunika xanen ibubu inun, Diosun jancha kenenibu yusinananmisbundi ea danankin ea jatu tenanmabu dabe inun besti xaba kaya en ana bestenxanaii— akin ");
INSERT INTO cbsNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","jaska wakin jatu xabakabi yuiai ninkatan Pedron Jesús ja mesti paxkabain nemakin yuikin: —Min jaskatidumaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús jawen tsumabukidi nasauketan uinkin Pedro nemakin yuikin: —Satanásan shinanwen min ea nemaii. Ana jadi jaskayamawe. Jawada Diosun uiain keska min uianmaki, eska shinankinan, jaska yudabun uinmis keskawen min ea nemaidan— atan ");
INSERT INTO cbsNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","januxun Jesúsun jawen tsumabu inun yudabu jabe buaibu kenaxun yuikin: —Tsuabuda eki chiti ikatsis ikidan, jamebi jaska shinanmis jakimatan: “Bika tenei en jawen taea mawatiduki”, ikin jau ea chibankubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jamen tsuabunda shinain: “En mawakatsi ikamaki”, iki jatunmebi mekeaibudan, eauma mawakin jatun jiwea benuxankanikiki. Jakia ea ikunwankin en kakape yusinkin ea chibainwen taexun tenanbiabu jatun jiwea benuama jiwekuinxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jaska inun, jaskati dabanen yudabun shinanma mai anua mabuwen inun jamapai tibiwen kemukin ichawai jiwemisbudan, jabudi eauma mawai benuxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ja inun, jawada inananankin jawen jiwea pakatan jawen jiwekuinti tsuan bitidubumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jaska inun, tsuabuda na yudabu chakabu bebunua eki inun en janchaki dakemisbudan, en Epan kushipaya jawen nai tsuma pepabube jua jabiaskadiai en jatuki dakediaxanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ana jatu yuikin: —Chanima en matu yuiai ninkakanwen. Na jabia man ebe mapuabudan, betsabu man mawadiamaken Dios Xanen Ibui taei kushipajaidai man uinxanaii— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Janua ana 6 día binuaya Pedro inun, Santiago inun, Juan Jesúsun katubainkin jatu iyui kakin mati keyatapajaida mapeketan janua jatu bebun Jesús dami ");
INSERT INTO cbsNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","jawen tadi juxupajaidai chaxajaidai tsuan tadi patsakin juxupa wakin jaska waisma keskai ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","jaskaya jabianudi Elías inun Moisés Jesúsbe janchai uin ");
INSERT INTO cbsNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","datejaidaibun jadakidi shinantima Pedron Jesús yuikin: —Yusinaan, nun nenu juadan pejaidaki. ¿Pean xubu dabe inun besti matu waxunpa, betsa mina inun, betsa Moisésna inun betsadi Elíasinadan?— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","janua samama nai kuin bekin jatu bepuaya nai anua jui taxnikin yuikin: —Nadan, en bakeki. En bechipaijaidaii. Ninkaidakubainkanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","samama bedu bedu ikin uin ja jabe mapukanxu ana niama Jesús besti nia uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","janua mati keyatapa butebidankin Jesúsun jatu yuikin: —En matun Juchi Kayabi Iyua matu mawaxuntan en ana matu bestenxundiamaken jawada na jaska man uinxudan, tsua yuiyamayuxankanwen— ");
INSERT INTO cbsNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","jatu wa tsua yuiama jatunmebi yuinamekin: “Mawatan ana bestenxanaidan, ¿jaskadamen?” ixun ");
INSERT INTO cbsNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ana jawen tsumabun Jesús yukakin: —Yusinanbun jatu yusinkin Diosun jancha kenenibuwen jatu yuikin: “Nukun mekenan Cristo judiama bebunkidi Elías juxanikiki”, ikidan, ¿jaskai imisbumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","jatu kemakin: —Chanima Elías bebunkidi ana juxun dasibi benawakin pewakin taewaimaki. Ja dikabi, Diosun jancha yuixunikabun kenekin: “Diosun bake jatun Juchi Kayabi Iyuadan, jabun danankin ichakawabu nuitapaxanikiki”, adianibuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jakia eanan, en matu yuiaii. Elíasdan, chanima ja dukun juimaxun jatu yusianyan danankin Elías Diosun jancha yuixunika ichakawakin jaskadaxanaikidi Diosun jancha yuixunikabun bebunkidi jakidi kenenibu akin jabiaskadi wakin ichakawaimabuki— jatu abidani ");
INSERT INTO cbsNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","janua Jesús jawen tsuma betsabuki nukunun ika jui janu yudan kaian jawen tsumabuki icha Diosun jancha kenenibu yusinananmisbube jatube icha yuinamea akeakeaibu Jesúsun uinkubidanaya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús juai dasibibun uin benimajaidai kushibaini jaki nukuxun yukakin: —¿Min ma juai?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","januxun Jesúsun jatu yukakin: —¿Jawai Diosun jancha kenenibu yusinananmisbube jadakidi man janchawen yuinamei ikai?— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ninkatan juni betsan yuikin: —Yusinaan, en juni bake yushin chakabun juyu wani en mia anu iwexuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ja yushin chakabun achixun duxku imakin tin imatan mai pusama daxka daxka iki bakuxyai xeta yenx yenx iki bakux kebus iki chadish chadish imakin jaska wakin babu wakubainmiski. Jaskamisken: “Jau yushin chakabu ea kainmaxununbun ika”, min tsumabu en jatu shinanbiabidana tsuan jawa ea kainmaxuntidubumaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","mapuabu Jesúsun jatu yuikin: —Ikunwainsbumaan, ¿jatiki matu medabewai ana en matube jiweyuxanai? Nedi iwekanwen, ja bakedan— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","iweaibun yushin chakabun Jesús bechitan ja juni bake ana duxku ima main tin itan taka taka iki kemu bus bus ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesúsun jawen epa yukakin: —¿Jatian bedukui taenimen?— aka jawen epan yuikin: —Bakeishta iki taeniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ja yushin chakabun tenanun, iwanan, jawenchains chi medan napukin inun jene medandi pukumiski— atan —Jamapai min atiduwen taexun ¿en bake min ea xuxawaxuntidumen? Nukuwen nuikin min atidudan, ea medabewawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesúsun yuikin: —En mia medabewatidudan, ¿min shinanmamen? Min ea ikunwanyan jamapai betsa betsapa en mia axuntiduki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","jawaida jawen epan unanxubima yuikin: —En mia ikunwaiin. Ana en ikunjaidawanun uinmakin ea medabewawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","yudan kaian ichabidanbidanaibun uinkin Jesúsun yushin chakabu yuikin: —Yushin pata wakin inun juyu wamistuun, ja juni bake medanua kaindikaintanwen. Chintunkidan ana jaki jikiyamaxanwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","yushinin bis imatan ana duxku imabaini kainkainaya ja juni bake mawa keska dakaken ichapabun yuikin: “Ma mawaki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","januxun Jesúsun metsunxun benia benikauan niken ");
INSERT INTO cbsNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","janua Jesús jiwetan jikiaya jawen tsumabus jabe jikibain ana yukakin: —¿Jaskakin ja yushin chakabu nukun nun kainmatiduma ixumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesúsun jatu kemakin yuikin: —Na eska yushin chakabu kainmakinan, Dios dayuikin ea a bestikubainkin man kainmatiduki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","janua Jesús jawen tsumabu besti tadi iyuxun yusinun ika yudabu uinmama jatube june kai Galilea napaibaini kakin jatu yusinkin: —En matun Juchi Kayabi Iyuadan, tsuanda ea jatu achima ea tenanbu xaba dabe inun bestitian en ana bestenxanaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","jaska jatu yuiai jawen tsumabun jawa ninkamajaida jawa yuiai dabanen datekin Jesús ana jawa yukama inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Janua Cafarnaúm maewanu bei jiwetan jikiabun Jesúsun jatu yukakin: —Bai tanabidanidan, ¿jawakidi man yuinamekubidankanxumen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","bai tanabidani janchai yuinamekubidani: —Jesúsbe xanen ibukin ¿nukunan, jadatubun betsabu nun matu binunxanimenkain? ¿Eamenkain?— iki yuinamekanxu dakei jawa yuiama pes maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús tsauxun jawen 12 tsumabu kenaxun yuikin: —Jadatuda man xanen ibu pepa ikatsis ikaidan, ja dukun yuda dasibibu medabewakin jatuwen nuikin jabun tsuma keska ikubainkin jau jatu duawakubainunbunwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","januxun bakeishta betsa jawen tsumabu nashui abidan iwexun ikuxun jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ea duawanun, iwanan, na bakeishta keska wakin tsuada en kenaya juaidan, ikin ea akawakin man duawatiduki. Jabiaskadi wakin ea besti duawama jatun ea yununi Diosdi jabun duawaxankanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juanen Jesús yuikin: —Yusinaan, juni betsan min kena kushipa paewen yushin chakabu kainmai nun uinbidanshinaki. Nukubetan mia chibanmaken nun nemakin nun bextepaibia nuku ninkama ishianki. Jadi nun nemashinadan, ¿pemen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesúsun jatu yuikin: —Nemakin man jatu bextetidumaki. Tsuada nukuki sinatamadan, nuku medabewaikiki. Jawada atimaska yudabun atidubuma en kena kushipawen abiakin samama ekidi chakabu yuitidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ja inun, tsuada nukuki sinatamadan, nuku medabewaikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ja inun, man ea ikunwainbuwen taexun jamapai tibiwen matu duawakin unpax amai keskawen matuwen dabanan ikin matu inainbudan, chanima Diosun jatu duawaxanikiki, pepawen manakukinan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","jabias bake ikuxun ana jawen jatu shinanmakin yusinkin: —Tsuabunda jawada Diosun nemamis inun yunumis chibanma chakabu wamisbun bake mishtinbun ea ikunwain jatu padankin chakabu jatu ama akeakediamisbudan, jaskawen taexun Diosun jatu kupijaidaxanaiwen taea jawen xekiwan deneti mishki ewapa nexaxun teumatan ianenwan medan pukua jasadan, jawen kupiti bexmas mekeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Jaska man ikatsi ikamadan, jawanda matu chakabuwamis bextekekin jawaida jenedikubainkanwen. Janua min meken betsa kasmai min tae betsa kasmai min bedu betsa kasmai jadatuwenda mia chakabuwamis ja mextekea keskakin jamapai chakabu man imis inun man amis tibi jawaida bextekei jenetiki. Min meken dabeya kasmai min tae dabeya kasmai min bedu dabeyadan, janu chi nukaisma anu inun janu nami xena debuisma anu chi medan mia puta pemajaidaki. Jakia min meken bestichaiya inun min tae bestichaiya inun min bedu bestichaiyadan, Dios anu niti ikama min jiwenunbadiai pejaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chi keskawen man ikunwainbu tibi chuxakin akawakin matu bika tenemaxankanikiki. Matu jaska wabiabu Diosun jawen kushipawen matu mekea man kushipaxanaii, tewen nami mekemis keskaidan. ");
INSERT INTO cbsNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tewedan, nami chaputima wati inun nami meketibia payukui keyumiski. Matubunan, Diosun jancha man unainbuwen taexun matunabu yusiin man tewe batawen meketi keskabuki. Jakia jaskai tewe jawen bata keyu bumis ana meketiduma keskama Diosun jancha ninkakin pewatan ea chibainbube medabenain unanuma jiwekubainxankanwen— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Janua Cafarnaúm anua kainkaini kai Jordán jene kexa betsaudi estekidi Judea mai pakea anu jikia yudan kaian ana jaki ichaibu jaskabidanaibu jatu yusinmis keskaibu Jesúsun ana jatu yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","januxun fariseobu jatiditun Jesús unanti watan jaki bepadamenun ika jaki kematan yukakin: —Juninan, ¿jawen ainan jenetimen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesúsun jatudi yukakin: —Moisinan, ¿jaskada nukun xenipabu yusinkin yununimen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","jabundi yuikin: —Moisin yusianan, ainbu jenekatsi ikinan, jawen jeneti unaki kenexun inantan jenebaintiki, ani nun uinmiski— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","januxun Jesúsun fariseobu jatu yuikin: —Chanimaki. Matu keska matun xenipabu juinti kushiken jaska Moisin jatu yununiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jakia Diosun dasibi damiwakin taewakinan, juni inun ainbu jau ja dabe ketaxamenunbun, iwanan, Diosun jatu damiwaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jaskaken jawen ibubu dapaxkabain juni ainyantan jawen ainbe ketaxameawen taea ");
INSERT INTO cbsNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ana yuda dabema jabias yuda bestichai keska jiwetidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Janua Diosun juni inun jawen ain yuda bestichai keska jatu wa junin jawen ain dapaxkabainkin jenetimajaidaki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","janua Jesús jawen tsumabube jiwetan jikia maniabun jaska jatu yusinxu ana yukabu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesúsun jatu yuikin: —Tsuabuda jawen ain jenetan ainbu betsa ainwankinan, jawen ain xeni danankin Diosun yununidi danain chakabumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jaska inun, ainbun jawen bene jenetan juni betsa benewakinan, jawen bene xeni danankin Diosun yununidi danain chakabudiamisbuki— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Janua jatun bakebu jau ea Jesúsun mexunkin unanuma waxunun, iwanan, janu iwebidanbidanaibu jawen tsumabun jatu nemaya ");
INSERT INTO cbsNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Jesúsun uin jawen tsumabuki sinatakin jatu yuikin: —Jatun bakebu ea anu iweaibu jatu nemayamakanwen. Dios xanen ibuaitianan, na bake mishtinbu eki dateabuma keskabu besti Dioski dasixankanikiki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","januxun bake mishtinbu ikuxun mamepixun duawakin bestibu jatu yuikin: —Dios miwen nuikin mia bechipaiaya unanuma yumei pekanwen— jatu wa akeakenikiaki, Jesúsunan. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Janua Jesús ana kainkainaya juni betsa kushikidan jaki nukutan ja bebun danti itan yukakin: —Yusinan pepaan, ¿Mia yukapa? Jiwea kayabi bikinan, ¿jaska kayatan en bitidumen? Ea yuiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsun yuikin: —¿Jaskakin ea kenakin: “Pepaan”, min ea wai? Dios bestiki, pepadan, ¿min unanmamen? ");
INSERT INTO cbsNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mianan, Diosun yunuti inun jawen nematidan, ¿min unanmamen? Eska yuinidan: “Ainbu min ainma chutatimaki. Juni betsaki sinatakin tenantimaki. Yumetsutimaki. Juni betsaki chanichakatimaki. Padananantimaki. Ja inun, min epa inun min ewa duawakubaintiki”— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ja juni mabuyatun Jesús yuikin: —Chanimaki. Dasibi Diosun yunuti inun jawen nemati jaskadan, en ma unan keyuaii. Bakeishtatun tapinixun en chibankubainmiski— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesúsun uin jawen nuikin ana yuikin: —Min pe ea yuiaii. Na besti min shinandiamaki. Mia yuinun ninkawe. Nai anua Diosun manakuti pepa bikatsis ikin min jawada dasibi min jaya jatu inan keyutan ja pei min bishian ja nuitapaibu inankuintan chintuanma ebe kakin ea chibankubainxanwen. Min jaskakunkainaiwen taexun jiwekuian min bixanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesúsun jaska yuia ninkai jawen mabu ichapawen nui juinti nishmai keyutan ana jawa yuiama benikainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesúsun jatu uinbaunkin jawen tsumabu yuikin: —Juni mabujaidayadan, Dios xanen ibuai anu jikinun ikaidan, bikajaidaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","jawen tsumabun jawen jancha ninkai Jabaa! ikaibun Jesúsun ana jatu yuikin: —Chanimaki. Ja yuinaka ewapa camellodan, ja xumux jawen chixuiki jawen yuda kainmakinan, tsuan atidumaki. Jakia jaska keska bikadan, juni mabu ichapayadan, jawen mabu besti shinain jawen nuikin jatun shinan betsa wama Dioski chiti itidubumaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","jawen jancha ninkatan pes juinti nishmaxun yuikin: Jabaa! iki yuinamekin: —Jaskakenan, ¿tsua Diosun nuku mekekin paxawakin jiwematidumen?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","jatu tibi uinbaunkin yuikin: —Tsuada yudabun matu jaska waxuntidubumabiaken Diosun besti dasibi matu axuntiduki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedron yuikin: —Yusinaan, nukunan, mia chibankatsi ikinan, jawada nun jaya dasibi bashikin keyubidanimaxun nun ma mia chibanpakeaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesúsun ana jatu yuikin: —Chanima en matu yuiai ninkakanwen. Jadatutunda ea chibankin Diosun jancha kakape yusintanun ixun jawen mae jenekin jawen betsabu inun, jawen puibu inun, jawen epa inun, jawen ewa inun, jawen bakebu inun, jawen bai jenekin keyubainken ");
INSERT INTO cbsNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tsuabunda jamapaiwen jatu bika tenemabiaibun na jabiatian Diosun jatun pepawen manakujaidakin ana jiwe betsa inankin, betsabu inankin, puibu inankin, ewabu inankin, bakebu inankin, bai inankin jatu jaska waxunxanikiki. Jatu jaska wanixun nai anu jatu jabe jiwemaxanikiki, ikibi imakinan. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ja inun, yuda ichapabu na jabiatian kenkin yunumisbudan, Diosun jatu kenwanma ixanikiki. Jakia betsabu na jabiatiandi jawa kenkin yunuisbumadan, Diosun jatu kenwankin xanen ibujaidawaxanikiki— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Janua Jerusalén bai tanabainaibun Jesús bebukainaya jaki chiti ikabu jachun bui supuibaini jadia Jesúski jaki sinatamisbu anu kaya jawen tsumabun jaska shinain yuinamekubainaibun yudan kaian jatube bui dateyabi chibainbun januxun Jesúsun jawen 12 tsumabu besti kenaxun jatu tadi iyuxun jaska wakin ichakawaxanaibu ana jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Jerusalén anu na jabiatian nun kaidan, man unaiin. Januxun Diosun bake en matun Juchi Kayabi Iyua Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbu jabu tsuanda jatu ea achimaxanikiki. Jabun ea tenankatsis ikin nawa betsabu ea jatu inanbu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","jabu eki kaxekin eki kemu michukin ea kusha kusha axun ea tenanbu xaba dabe inun besti kaya en ana bestenxanaii— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Janua Zebedeon juni bake dabe Santiago inun Juan Jesús dapi kaxun yukakin: —Yusinaan, nun mia jaskakidi yukaidan, nuku axanwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Man jawa ea yukai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","jabun Jesús ana yuikin: —Min xanen ibu kushipai pepaya mibe nun xanen ibudianun mibe nuku tsaumaxanwen, betsa min yusiudi inun betsa min yusmaudidan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesúsun jatu kemakin: —Jaska man ea ea akaidan, shinankin man ninkadiabumaki. Jawada en ixanai keskadan, ¿man idiatidumen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Nun idiatiduki— akabu Jesúsun ana jatu yuikin: —Chanima ea ichakawaibu en isin tenexanai keska man tenediaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jakia en yusiudi inun en yusmaudi man ebe xanen ibutidudan, en matu yunutidumaki. Jakia en Epa Diosun jatu katunidan, ebe xanen ibuxankanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","janua Santiago inun Juan jaska yuka ikaibu Jesúsun tsuma betsa meken dabetibun ninkai jatuki sinataibun ");
INSERT INTO cbsNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","januxun Jesúsun jawen tsumabu keyu ichawaxun jatu yuikin: —Jaska nawa xanen ibubun jawenabu ja akin mese wabetanan kushipawen jatu yunukin jatun tsumabu jawen kushipa jatu uinmakin jatu babu watan yunumisbu man unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jakia matubunan, jaska shinanyamakubainkanwen. Matu anua tsuada xanen ibukatsis ikinan, jau dasibi matu medabewakin duawakubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jabiaskadiai tsuada xanen ibukatsis ikidan, dasibibun tsuma jau idiakubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jamen ea iki juidan, en matun Juchi Kayabi Iyuabiadan, jau ea duawanunbun ika en juamaki. Jakia matu debuxunkin yuda ichapabu benuabu mexpamatan matu jiwemanun ika en juniki— jatu abaini ");
INSERT INTO cbsNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Janua Jericó maewan anu Jesús jawen tsumabube jikia ibai janua Jesús kainkaini yudan kaian inun jawen tsumabube kaya janu bai kexa anu Timeon juni bake Bartimeo bekun tsauxun pei jatu yukamistun ");
INSERT INTO cbsNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús Nazaret anua yumeni yui jakidi janchabainaibu ninkatan unanxubima jawenchains yuikin: —Davidin babaan, ewen nuiwe— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ichapabun nemabiabu ana unanxubimajaida yuikin: —Davidin baba Jesúsuun, ewen nuiwe— abaunbaunaya ");
INSERT INTO cbsNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús niti itan junibu jatu yuikin: —Kenakanwen— jatu wa januxun juni bekun kenakin yuikin: —Mia kenaikiki. Shinan chankain benidikidanwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","jawen yabukuti peputakatan jawaida benikidan Jesúski nukua ");
INSERT INTO cbsNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesúsun yukakin: —¿Mia jawa medabewapa?— aka juni bekunman yuikin: —Xanen ibuun, ana en uinun ea bepexwe ika en ikaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesúsun yuikin: —Ana uindiwe, min ea ikunwainwen taea xuxatan inun kadiwe— aka samama Bartimeo bepexetan Jesús chibanbainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","janua Jesús Jerusalén anu kai Betfagé inun Betania ja mae dabe anu kemai Olivos Mati tetanbainkin jawen tsumabu dabe yunukin: ");
INSERT INTO cbsNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Ja mae besuudi kayanbis buxun burro nexea tsua jaki katsaumediama bechitan tepetan beyutankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jaska inun, tsuanda matu yukakin: “¿Jawakatsi man tepeai?” matu wa yuikin: “Nukun Xanen Ibun biyukatsis ikikiki. Samama jabianudi nuku bemaxanikiki”, atankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ja dabe buxun jiwe beputi dapi burro nexea bai namaki nia bechitan tepeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","jabianudi manixun yukakin: —¿Jaskakin burro man tepeai?— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","januxun Jesúsun jaska jatu yuixukidi yuiabu: —Peki. Buxunyutankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","tepetan januxun jatun bemakia tadi burro kamaki kabekanbain Jesús anu buxuanbu Jesús jaki inatan katsaumekainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ichapabun jatun bemakia tadi bai namaki nabekanbainaibun janua ana betsabundi xenpan mextexun jabiaskadi wakin nabekanxundiabainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","bebubainaibu inun chipu beaibun jui kushipawen jawenchains yuibainkin: —Aichu! Aichu! Ja Diosun kushipaya juaidan, benimawakin duawanankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nukun xenipabu David ipauni keska xanen ibujaidai juikiki. Dios kenwanxunankanwen— akubaini bui ");
INSERT INTO cbsNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","janu Jerusalén anu jikixun januxun Dios kenwanmisbu Templo jemaintin anudi Jesús jikidiaxun janua jawen jamapai dasibi uinbaunkin keyutan janua ma badi kaya kainkaini jawen 12 tsumabube Betania anu bua ");
INSERT INTO cbsNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","uxashini xaba betsatian meshukidi Betania anua bunikainkin ");
INSERT INTO cbsNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ji betsa higuera benanta tupan nia Jesúsun bechitan jaska bimiyamenkain uintanun ika kaxun jawa bimi jayama jawen peijaida besti uinkin janu bimimistian idiamaken ");
INSERT INTO cbsNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","januxun Jesúsun ji bimiuma yupukin: —Jau tsuan taska min bimi ana piyamaxanunbunwen— akai jawen tsumabun ninkabaini buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","janua Jerusalén anu Jesús ana jikitushitan janu Templo jemaintin kenekauanu jikikain januxun jawen Dios daewati inabu chaxuwan inun, ina awa inun, deiwan inananainbu inun biaibu jatu nichinkin taewakin pei bianananmisbun tapu nadabekin deiwan inanmisbun kenedi nadabediakin keyutan ");
INSERT INTO cbsNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","janu jawen jemaintin kapukekin jau jawada iabaunyamanunbun jatu nemaxun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ana xanen ibubu jatu chitekin yuikin: —Jawen Templokidi jawen jancha yuixunika Isaías Diosun kenemani matu yuinun ninkakanwen: “En jiwedan, janua yuda betsa betsapabu ebe janchakin ea kenwanxankanikiki”, ibianiken na jemaintin xabatudu anua matubu padananankin yumetsun jiwe man wamisbuki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","jawen jancha ninkai Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbun shinankin jabiadi yudan kaianen jawen jancha ikunwainbuwen taea jaki sinatai Jesúsun yusinkin jatu binutidu shinain jaki datei jaskatan tenantimen ika yubakai taeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ma meshuaya Jesús jawen tsumabube Jerusalén anua kainbainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","janua meshukidi ana bai tanabainkin ja ji bimiuma anu ana dainbainkin jawen tacha inun jawen ibu ma xanashinken ");
INSERT INTO cbsNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jesúsun jaska yuiai ninkashinxun Pedron shinankin Jesús yuikin: —Uian. Yusinaan, ja ji bimiuma min yupushinadan, ma xanashinabin— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsun jatu kemakin: —“Diosun jamapai atiduki”, ikunwankanwen— itan ");
INSERT INTO cbsNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","—Chanima en matu yuiaii. Na mati tsuanda yuikin: “Matipaan, mimebi tsekekain ianenwan medan pukutanwen”, akin man shinan dabewen shinanwen akama man ikunwankin jadi yuiaiwen taea Dios matuwen dabanan ikin matu axunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaskati en matu yuiaii. Diosbe janchakin: “En jaska bikatsis ikaii”, ikin yuikubainkanwen. Man shinan dabeyamaken jaska Diosun matu yunuaya man bixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jaska inun, Dios dayui jabe janchakin tsuanda jawada matu chakabuwashina jaki sinatabiatan jawaida jabe daekubainkanwen, ana jas shinanmadan. Man jaskaibu matun chakabudi Diosun matu buaxuntan ana shinanma idiaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jamen yuda betsabun matu ichakawabu man jatube daenameamaken Dios nai anuatun matun chakabudi matu buaxunamadi ixanikiki— jatu abidani ");
INSERT INTO cbsNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","janua Jesús inun jawen tsumabu Jerusalén anu ana chintunkidan jikitan janu Templo jemaintin anu Jesús jikixun uiantani niken Diosbe nukunabu janchaxunika xanen ibubu inun, Diosun jancha kenenibu yusinananmisbu inun, mae xanen ibu betsabu ja dapi buxun ");
INSERT INTO cbsNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","yukakin: —Na min eska waidan, ¿tsuan jawen kushipa mia yunuimawen min aki ikai? ¿Tsuan jawen kushipa mia inainmamen, min jaska wanunan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsun jatu kemakin: —Entsedi en matu yukai matun dukun ea yui taewakanwen, man ea yuiaya jawada man ea yukai en matu yuidiai ninkakanxunan. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nashimanika Juan jau jatu nashimanun yunukinan, ¿tsuan kaya yunuyama man shinain, Diosundaka, junibundaka? Ea dukun yuikanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","janua jabudi june yuinamekin: —“Diosun yunuyamaki”, nun wadan, “¿Jaskakin Juanen jancha man ikunwanma ikimamen?” iwanan, nuku kunyan atiduki. ");
INSERT INTO cbsNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jamen yuda midimabun Diosun Juan yunuyamakidi jabun ikunwainbuwen taea jabuki datekin yuikin: “Junibun yunuyamaki”, nun wapanan nun jaska yuitidubuki— itan ");
INSERT INTO cbsNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","jabun Jesús yuikin: —Nun unanmaki— akabu Jesúsun jatu yuidiakin: —Jaskakenan, tsuanda jawen kushipawen ea yunuimadan, eandi en matu yuiamaki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","jabianuxundi miyuiwen Jesúsun xanen ibubu jatu yusinkin: —Juni betsan bai waxun uva bimi batapa banatan mishkiwen dakenbaunkin keyutan janua jaki uva tsiniti watan januxun dasibi uinbaunti jiwe pishta keyatapa watan januxun jau bimi dabukun ea inanxanunbun, iwanan, juni betsa dayakapabube jabube yubakatan ibu keska wakin yunuyubaini chai kaimaken ");
INSERT INTO cbsNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","janu ma kani tsekatitian ikaya bai ibuan jawena dabukun jau yukatan ea bixuntanun, iwanan, jawen tsuma betsa yunua ka ");
INSERT INTO cbsNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","jabun jawena inankatsi ikama uva bimi mekeabun achixun kusha kusha axun jawa inanma mais kaya ");
INSERT INTO cbsNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","januxun bai ibuan ana jawen tsuma betsa yunudia ka kunyan axun makushkin mapextan nichindiabu kadiaken ");
INSERT INTO cbsNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","januxun bai ibuan ana jawen tsuma betsa yunua ka tenanbun januxun betsa betsapadi yunua buabu jatu kusha kusha akin jatidi tenanbun ");
INSERT INTO cbsNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","jatu jaska tibi wabia jabun inanbumaken jawen bake bestichai bechipaijaidai ja besti niti itanaya jakidi shinankin: “En bake en yunua kaya jaki mesekin en bimi ea ja inanxuntidubumenkain”, iwanan, yunua ka ");
INSERT INTO cbsNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","jawen bake jatuki kemai kai bechitan yuinamei: “Bai ibu mawashinken na jawen baken jawen bai tibi inun jawen jiwe tibi dasibi jawenawayuikiki. Na bai nukunas nun wanun tenanankanwen”, ixun ");
INSERT INTO cbsNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","achixun tenantan bai tsisumen putanibuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—¿Jaskakenan, ja bai ibuan jaskada jatu waxanimenkain? Matu yuinun ninkakanwen. Bai ibu jawenabube juxun bai anu dayamisbu jatu tenantan januxun juni betsabu jawen bai anu jau dayaxununbun jatu yunuxanikiki— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—¿Diosun jancha kenenibu uinkin man yuismamen? Matu ana shinanmanun ninkakanwen: ‘Jiwe wanikabun mishki dananbiaibun jabias mishki Diosun bixun dexun makedex wakin jawen kene mestenwan keska wakin ");
INSERT INTO cbsNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","nuku uinmakin jabaa! imakin nuku jadakidi shinantima waxanikiki’, jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","na miyuiwen jatu ja akin chiteai unankin xanen ibubun Jesús achikatsis ibiai yudan kaianki mesekin jawa meama jeneyunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Januxun Jesús jaska waxun tenantima jawen padantan romano xanen ibu ja amakatsi ikin judio xanen ibubun fariseobu inun Herodeski chiti ika betsabu Jesús anu jatu yunuabu ");
INSERT INTO cbsNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","jaki bepadamebain yuikin: —Yusinaan, yuda betsabu miki sinatabiaya jawa jatuki dateama chanima jancha besti yusinkin jaska wakin Dios chibantidubu besti min jatu xabakabi yusinkubainaidan, nun unaiin. Jaskawen taexunan, ¿jaskada min shinainmenkain mia yukapa? Ja Romano xanen ibu Césarn nuku pei yukamisdan, ¿jaska wananxanpa? ¿Pakananxanpa? ¿Pakatimadaka?— akaibu ");
INSERT INTO cbsNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús jawen bepadankin jamakidi yuimatan ichakawatidubu unankin jatu yuikin: —¿Jaskadawen man ea unanti wakin bepadanun ika ikanai? Jawen gobierno impuesto pakati pei jexe betsa ea uinmakanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","betsa bexun inanbu uinkin Jesúsun jatu yukakin: —Nadan, ¿tsuan besu inun tsuan kena neamen? Ea yuikanwen— jatu wa jabun yuikin: —Romano xanen ibu Césarnaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesúsundi jatu yuikin: —Césarnawen taexun matun xanen ibu César duawakin jawen gobierno dayaxunmisbu pei jatu inanxunkubainkanwen. Jakia Diosdi duawakin jawen yusian chibankin jawada bechipaiai axundiakubainkanwen— jatu waya —Nun jaska waxun padantidumaki— iki e itan ana jawa yuitima buaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","janua saduceobu judiobu paxka betsa: “Ja mawabu jawen yuda tsua ana besteinsmaki”, imisbu Jesús anu jabudi bexun yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yusinaan, Moisin yusinkin: “Juni betsa ainyan juni bakewadiama mawaken janua jawen betsan ain janubi ainwantan juni bakewaxuntiki, jawen betsa mawaimatun kena dabikinan”, nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jaskakidi ja jawen 7 betsabukidi mia yuinun ninkawe. Ja dukun iyuatun ainbu betsa ainwanxun juni bakewadiama mawaken ");
INSERT INTO cbsNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ja kachukeatun jawen betsan jabias ainbu ainwanxun juni bake wadiamadi mawaken ana ja kachukeatun jawen betsan ain jabiadi ainwandiatan juni bake wadiamadi mawaniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Janua ja 7 jawen jenekin jabias ainbudi bixun jabu tibitun jawa juni bake bawabuma mawai keyuabun janua jawen jenei ainbu juni bake biamas mawadianiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ja jaskanibudan, mawabu ana besteainbutianan, ¿ja ainbu bestichai ja juni 7bun ainwanibudan, jadatutun kaya ana ja ainbu bixanimenkain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesúsun jatu kemakin: —Matunan, Diosun jancha kenenibu unanma jawen kushipa man unanmadiki. Jaskakin man kanemiski. Xabakabi matu shinanmanun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mawanibu ana bestenxanaibutianan, jawa ana ainyain inun ana beneyai ikama ixankanikiki. Janua Diosun nai tsumabu keska beneuma inun ainyuma jiwexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mawakubainaibu bestein ana jiwexanaibukidi matu yusinun ninkakanwen. Ji maxu kua jede ji ji ikai anuxun Diosun Moisés jancha wakin: “Eadan, natian en Abrahamnen mekenikaki. En Isaacun mekenikaki. En Jacobun mekenikadiki”, ikai ninkayamaxun Moisin kenenidan, ¿man uinkin yuismamen? ");
INSERT INTO cbsNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Diosdan, mawabunamaki. Jakia jiweabunaki. Jaskaken Abraham inun Isaac inun Jacob jatun yushin jiweabuki. Chipu ana yuda bena Diosun jatu inanxanai shinanma man kanejaidamiski— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesús saduceobube yuinameai ninkabaikin Jesús jaskakidi yukabu jatu yui pewaxukidi unain Diosun jancha kenenibu yusinananmis betsa Jesúski kemaxun unanti wanun ixun yukakin: —¿Jadatu yunua kushipa binua Moisin nuku kenexuniwen besti nun chibainwen taexun Diosun nuku mekekubaintidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesúsun yuikin: —Na eska yununi betsa betsapa tibi dasibi binujaidadan, eskaki. Ninkakanwen: “Israelbuun, nukun Xanen Ibu Dios ja besti ikibi ini jiwepakeikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jaskaken nukun Xanen Ibu Dios duajaidawakin bechipaikin jawen nuikin matun juinti inun, matun yushin dasibiwen inun, matun shinan dasibiwen inun, dasibi matun kushipawen jeneama akubainkanwen.” Min jaska tibiwen shinankin akaidan, ja yunua betsa dasibi binujaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ja kachu yunua betsadan, jabe ketaxnidan, ninkawe: “Min jabube jiweabu duawadiakubainkanwen, ibubis man nui mekemis keska wakinan”, akin yuini ja yunuti dabe chibain man jaki chiti ikaiwen taea matuwen Dios benimaxanikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Diosun jancha kenenibu yusinananmistun Jesús yuikin: —Yusinaan, min yusianan, peki. Chanima min yui kayabiaii. Nun bechipaijaidaii. Chanima Epa Dios bestitun nuku mekekubaintiduki, betsan nuku mekeamadan. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jaska inun, nukun juinti inun, nukun yushin dasibiwen inun, nukun shinan dasibiwen inun, dasibi nukun kushipawen Epa Dios duawai jaska nukunmebi nun nuimis keskai yuda betsabu tibiwen nun nuiaiwen taexun Diosun nuku bechipaijaidaikiki. Jamen jaskama jatida yuinaka detexun kuakin Dios nun inankuinmis inun jatida inankuinti betsa betsapa Dios kenwanti jiwe anu nun bumisdan, jawama keska Diosun shinanmiski— akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Diosun jancha pe ninkakin yuiai Jesúsun yuikin: —Dios xanen ibuaiki min ma jaki dasi kemaki— aka ana tsuan jawa yukama mapuabun ");
INSERT INTO cbsNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","jabianuxundi Templo jemaintin anuxun Jesúsun jatu bepuxumakin yukakin: —Diosun jancha kenenibu yusinananmisbun matu yusinkin: “Cristodan, Davidin baba ixanikiki”, ikin ¿jaskakin matu jaska yusinmisbumen? ");
INSERT INTO cbsNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Matu yuinun ninkakanwen. Diosun Yushin Pepatun David yusian kenenitun matu yuikin: Dios mekenikatun en Xanen Ibu Mesías yuikin: “Miki sinataibu en jatu maemadiama manai en yusiudi tsauyuwe”, aniki. Jaska watan keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jakia: “Mesías en xanen ibuki”, Davidin abianiken ¿jaskatan jawen xanen ibu janubi jawen baba itidumen? Ea yuikanwen— akin xanen ibubu shinanmaya yuda midimabun Jesúsun jancha ninkai benimai tse ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","jabianuxuns Jesúsun ana jatu yusinkin: —Diosun jancha kenenibu yusinananmisbudan, jatu uindakanwen. Jatun tadi chaipa jawendua sawea mae jemaintin ewapa plaza anu en kauanai ea bechipaikin ea kenwankin jau jancha pewen ea duawanunbun ika mapumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jaska inun, janu ichati jiwe anu jikikain jaki tsauti pepa janu dasibibun jatu uintidubu anu tsaukatsis imisbuki. Ja inun, ichatan pinun, iwanan, janu xanen ibubu dakai baxti ixun pimisbu benadiamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jaska inun, ainbun bene ma mawakin xununiken jawen jamapai pepayabi jawen jiwe mebinun itan ainbu bepadankin jakidi pe shinanmanikapai Diosbe janchai chaipajaidamisbuki. Jaskamisbuwen taexun Diosun jatu unanti watan kupiadan, yumanjaidaxankanikiki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesúsun jatu yusin meneaya nuitapaibu jawen medabewati inankuin pei janu mistumisbu anu bau bebun tsauxun Jesúsun uianyan yuda pei midima jayabun ichapa mistubidanbidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ainbu beneumadi nuitapai juxun pei jexe dabe jawa damajaida mistuaya Jesúsun uintan ");
INSERT INTO cbsNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","jawen tsumabu kenaxun jatu yuikin: —Eskaki, matu xabakabi yuinun. Ja junibu pei ichapayabun jatun pei paxkaxun texe besti inankuinkanxuki. Jakia ja ainbu nuitapaitun dasibi jawen jawada biti pei inankin keyuxuki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Januxun Templo jiwe jemaintin anua jawen tsumabube Jesús kainkainaya jawen tsuma betsan yuikin: —Yusinaan, uinwen. Na Templo jiwe wakin mishki tsama akeakenibudan, jabi jawendua benibin!— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesúsun yuikin: —Chanimaki. Na dasibi jiwe ewapa wanibu jawendua man uiainan, jawenduajaidaki. Jaskabiaken ja mishki jiwe tekekin pudekin keyuxankanikiki, mishki betsa ana matsanbaunabumadan— jatu abaini ");
INSERT INTO cbsNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","janua bui Olivos Mati anu mapeketan Templo bebun tsauabun Pedro inun Santiago inun Juan inun Andrésin Jesús june yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ja mishki jiwe tekei pudekei keyuxanai min nuku yuixudan, ¿mia yukapa? ¿Ma kemai taei jaskai nun unantidumenkain? Nuku yuiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","8","Jesúsun jatu yuikin: —En ka en ana judiamaken eskai nuitapai taexanaibu Diosun yununi eskaxankanikiki. Xabakabi matu yuinun ninkakanwen. En kani ma en janu jua kemaya juni betsa betsapa bexun yuikin: “En Diosun Katua Mesías Cristoki”, iwanan, yuda ichapabu jatu padanxankanikiki. Jau tsuabunda jaska wakin matu padanyamaxanunbun uindaxankanwen. Ja inun, yudabu nuitapai taeaitianan, nawabu nawa betsabube detenamei inun tsakanamea akeakeaibu mai pacha sakua akeakeaya bunijaidai nuitapaibun isin betsa betsapa tenea akeakexankanikiki. Jakia tsakanamea akeakeaibukidi bana ninkai datei meseyamaxankanwen, na jaskaidan, isin betsa beai mekin man uinxanai keska bebunkidi xabakabi en matu banabimaidan. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","11","Jakia matu dukun taewakin betsabun matu kupinun, iwanan, jatun mae xanen ibu anu matu iyuxankanikiki. Ja inun, ichati jiwe anuxun ekidi man jatu yusiainbu betsabun matu kusha kusha axankanikiki. Uindaxankanwen. Jakia en kakape ikunwankin man ea chibainbuwen taexun tsuabunda matu achixun xanen ibu kushipabu anu matu iyuabu jawada man yuitidu Diosun Yushin Pepatun matu yuimaxanikiki. Jaskaken jawa dateama: “¿Jadakidi yuixanpa?” ikin bebunkidi shinanyamaxankanwen, jawen Yushin Pepatun matu jaska medabewaya en yusiankidi xanen ibu betsa betsapabuki man chanixanaidan. En ana judiamaken chanima yudabu mania akeakeabu dasibibu tsuabunda en kakapekidi ea ikunwankin jatu yusinbaunxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ja inun, yuda betsan janubi jawen betsabun ea ikunwainbu jatu achima akeakediaxankanikiki, jau jatu tenanunbunan. Jabiaskadi wakin jatun ibubun janubi jawen bakebu jatu achimadiaxankanikiki. Ja inun, jabiaskadi wakin bakebu jatun ibubuki sinatakin jatun ibubun ea ikunwainbu jatu achimaxun jatu tenanmadiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ekidi jaska yuibaunkin man ea chibainbuwen taexun yudabun matu danain midima matuki sinataxankanikiki. Matu jaska wabiaibun tsuada ea chibankin jeneisma jatu mekekin en jatu paxamaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jaskaken ja ichakanikakidi Diosun Daniel yuia keneni tsuanda ja yuikin unanmisdan, ja ichakanika taxnia Templo medan nia man bechiaya ja Judea anuabu mati keyatapa anu jau paxaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ja inun, betsabu na mai bawa jiwe sapa xeni manaundi maniabudan, butuxun jawen jamapai bikatsis ibiakin jau jawen jiwe anu jikiama jau jawaida paxadiaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ja inun, ikunwain ja bai anu dayaibudan, meshu medan jawen bemakia tadi kextupa bikatsis ibiai jau ana chintunkidanama jau jabiadiadi paxadiaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jamen ja yumainbutianan, tuyabu inun ja chuchu amamisbudan, jatu peidawaxankanwan. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Jaska inun, Diosun mai damiwani anua yumanxanaibudan, tsuan jaska tenediama inun ana teneama ixanai tenei dasibibu nuitapachakayamaxankanikiki. Jaskaxanaiwen taea uitian man jaska teneyamaxanunbun Dios ea akin yukakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja jaskaibutian Xanen Ibu Diosun jawa nemakin tsua paxawatidumabia ma jawenabu jatu katuniwen taexun jatuwen nuikin jau dasibibu debui keyuyamaxanunbun yumainbutian Diosun badi ana chai wama chaima xekaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","23","Jabiatiandi juni betsabu juxun matu padankin yuikin: “Eadan, Diosun ea yunua en jawen jancha yuixunikaki. Ea ninkaidakanwen”, ikaibun betsabundi yuikin: “Diosun Mesías Cristo, eadan, matu anu en ana juxuki”, ikaibu betsabun ninkatan jatu yuikin: “Uian. Nuku anu Cristo ma juxukiaki”, ikaibun ana betsabun yuikin: “Uian. Janu ma juxukiaki, Cristodan”, ikaibun januxun jabun jamapai betsa betsapa juni betsabun atiduma jabun akin yuda ichapa padankin Diosun jawena wakin jatu katudiani padankatsis idiaxankanikiki. Jaskaibu ninkatan ikunwankin man kaneyamaxanunbun bebunkidi xabakabi ja padanananxanaibukidi en matu besuunbi banabimai ninkakanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","ana jatu yusinkin: —Yumain keyuaibu binukainaya nai anua dasibi betsa betsapaxanikiki. Badi ana pexeama nukai taeaya uxedi ana chaxama meshuaya bishi nidi iki keyui dasibi nai taka taka iki chuduanyan ");
INSERT INTO cbsNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","en matun Juchi Kayabi Iyua xanen ibui kushipajaidai chaxajaida nai anua nai kuin medanua en juai uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Diosun jawen nai tsumabu yunua jawen katuabu mai jidabi kesua anu manibaunabu jatu ichawaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jaskaken ji higuerawen man unantiduwen miyuiwen matu yusinun ninkakanwen. Ji pei petakatan chipu metubistan peiai uinkin ma badi kemai man unanmis keskai ");
INSERT INTO cbsNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","jawada en matu yuixu bechitan en samama ana juai man unantidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jaska inun, yudabu dasibi jiwebaunabu yamadiabuma chanima dasibi en matu yuixu jaskai taexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jakia jabiaskadiai nai anua inun mai anua Diosun damiwani jabu keyuxankanikiki. Jakia en janchawen bebunkidi en matu yusiainan, binuama menepakexanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Janua jawatianda en ana juxanai tsuan unanmaki. Diosun nai tsumabun unanma inun ea Diosun baken en jawa unanmadiki. Jakia Epa Dios ja bestitun unainkiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jaskaken tsuan jawa unanmawen taea matubudan, jawa chikishama pepakunkaini Diosbe janchakin ea manakin jatianda jaskaxanai uindakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jaska inun, juni chai kakin jawen tsumabu jawen daya tibi jawen jiwe anu yunua akeaketan jiwe beputi kexemis yunutan bumisbu keska wakin en matu yunubainkin akawaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jawa chikishama ea manakaxankanwen. Jawa badida jiwe ibu jumis keskai eadi en ana juxanai man unanmadiki. Meshui taeayamenkain. Yamenapunmenkain. Takada keui taeayamenkain. Meshukidimenkain. ");
INSERT INTO cbsNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jaskaken jawaidakidan uxabu keska en matu bechiama ixanun ");
INSERT INTO cbsNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","en matu yuiai jakimama uindakubainxankanwen, jabiaskadiai dasibibuki en jatuki chanidiaidan— jatu anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ja Pascuatianan, Egipto anuxun Diosun yunua debuwanika nai tsuman nawan bakebu tenankin nukun xenipabu dunkebaini shinanmatitianan, uxa dabe ma kemai misi xaxama nun pimis ma kemaya Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbun Jesús june padanxun achitan tenanun ika yubakaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","jakia betsabun jatu yuikin: —Nukunabu nawaibutian meyamayuxankanwen, jawen taea bedukubauntidubukidan— inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Chipu Betania anuxun Simón yudaki chamini Jesúsun kaya waimatun jiwetanxun Jesús pimaya ainbu betsan nenkati bishtu juxupaki xeni inin pepa kadujaida bexun tesketan Jesúsun buxkaki mauka jaki jababainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ja jabetan piaibu jatiditun inin mayai xetekin uin jaki sinatai yuinamekin yuikin: —¿Jaska wakin ja xeni kadujaida jamen chakawakin maukaxumen? ");
INSERT INTO cbsNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jatu inanxun 300 xaba daya pei bitan nuitapaibu medabewatibin!— ika ainbuki ja ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","jaki jaskaibu Jesúsun jatu nemakin: —¿Na ainbun ea duawai jaskakin man dakewai? ");
INSERT INTO cbsNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nuitapai matube jiweabu medabewakin man jatu duawapaketidubuki. Jakia eadan, jawenchains man ea duawapaketidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jaskaken eki xeni ininipa maukakin na ainbun en mawadiama bebunkidi en yuda ea pewaxuki, jau jawama ea maiwashadaxanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jakia chanima en matu yuiaii. Mai jidabi anuxun kakape ekidi chanibaunkin na ainbun ea axu shinankin yuidiabaunxankanikiki, tsua jau jakimayamaxanunbunan— jatu wai ninkashinabun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","janua Jesúsun 12 tsumabu betsa Judas Iscariote Diosbe nukunabu janchaxunika xanen ibubube janchai ka jaska wakin Jesús jatu achimatidu Judas jatube yubakai ");
INSERT INTO cbsNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ninkai shinan chankankin pei inankatsi yubabu chintunkidankin “¿Jatian janixun en Jesús jatu achimatidumen?” ikin shinankubidanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ja badi Pascua besi taemisbutian ja dukun chaxuwan bake tesenxun taewamisbutian jabianudi misi xaxama pikubainmisbutian jawen tsumabun Jesús yukakin: —¿Jani kaxun Pascuatian badi kaya piti bawakin mia pewaxuntanpa?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","januxun jawen tsuma dabe yunukin yuikin: —Bui Jerusalén anu jikitan jabianua juni betsan unpax shumuwan iabainaiki nukutan chibanbaintankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Man chibanbaina janu jikiai uintan ja jiwe ibu yukakin eska watankanwen: “Nukun yusinan nuku yunuxudan, ¿mia yukapa? ¿Jadatu dintu anuxun badi kaya en tsumabubetan nukun shinanmati Pascua piti pipa?” man wa ");
INSERT INTO cbsNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","januxun dintu ewapa manaundi ma pewa matu uinma januxun nukun piti bawakin pewatankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","jawen tsumabu kainbaini Jerusalén anu jikitan jaska Jesúsun jatu yuixu keska ja juniki nukutan chibanbaini jabe kaxun jiwe ibu yukatan januxun Pascua nawakin piti bawakin menetan buxun jatu itani ");
INSERT INTO cbsNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","badi kai meshuaya Jesús jawen 12 tsumabube kai jikitan ");
INSERT INTO cbsNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","tapu anuxun jabetan piaibun Jesúsun jatu yuikin: —Chanima en matu yuiaii. Na jabiatian ebetan man piaibunan, jadatutunda man ea jatu achimai kaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","jatu jaska wai ninkatan juinti nishmai keyutan yukakin: —¿Jabia en eamen?— iaketainbun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ana Jesúsun jatu yuikin: —Man en 12 tsumabun jabias kenchaki man misi pukuxun piaibunan, man bestichaitun ea jatu achimai kaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jaskawen taea jaska ekidi kenenibu chibain matun Juchi Kayabi Iyua en jaskai mawaxanaii. Jakia ja junin ea jatu achimai kaidan, pemajaidaki! Jaskaken ja juni kaianma inidan, pepakeanaii— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","piti betsa keyudiabumaken Jesúsun misi betsa tsumaxun Dios kushipa yukatan tunketan inankin nuku yuikin: —Na misi betsadan, en nami keskaki. Pikanwen— ");
INSERT INTO cbsNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","januxun kencha vino mata tsumaxun Dios kenwandiatan jatu inanbauna uva bimi vino abaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","jatu yuikin: —Yuda ichapabu medabewai mawakin en jimi en jatu jabaxunxanaii. Na vinonan, en jimi keskaki, jawen yubaka bena shinanmatidan. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chanima en matu yuiaii. En Epa Diosbe xanen ibui en ana judiama na uva vino en ana matubetan ayuama ixanaii. Abaunkanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","jabianuadi Salmos Davidin keneni betsa betsapa jatun juiwen nawai menetan janua Judasin jatu paxkabainken Olivos Mati anu jatu iyuxun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesúsun jatu yuikin: —Jawen jancha yuixunika ekidi Diosun yuikin: “Chaxuwan jatun mekenika en tenanyan jawen chaxuwan datei paxai keyuxankanikiki”, aka ninkatan keneniken na jabiatian jabiaskadiai matu dasibibun ea shinanma man ea jenebaini paxadiakanaii, chaxuwan keskaidan. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jakia ea tenanbiabu ana bestentan janu matuki nukunun ika bebunkidi Galilea anu en matu kaxunxanaii— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedron yuikin: —Miwen datei dasibi paxai keyuaibun, eanan, en mia jawa jenekin putamaki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesúsun Pedro yuikin: —Jaskamaki. Chanima en mia yuiaii. Na jabia meshu medan takada keu dabediamaken: “En ja unanmaki”, iki dabe inun bestiki min eki dakekin yui kaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ana unanxubima Pedron yuikin: —Jaskamaki. En mibe mawabiai kai jaskai en miki dakeamaki— ikaya dasibibundi jabiaskasdi yui janchai keyutan ");
INSERT INTO cbsNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Janua Jesús jawen tsumabube kai miban xuku betsa jawen kena Getsemaní mishkiwen kenenibu anu jikitan jatu yuikin: —Nenu jabianu tsauyukanwen, en Diosbe janchai kaidan— ikainkin ");
INSERT INTO cbsNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pedro inun Santiago inun Juan besti iyui kai punu nuka jawenchains juinti metexekei niti itan ");
INSERT INTO cbsNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","jabudi yuikin: —En yudawen mawakin en matu xunubainxanai shinain en punu nukajaidaki. Na jabianuxun uxama ea manakanwen— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","janua kai benanta kakain main beui beti ixun Diosbe janchakin yuka jeneama yuikin: —En Epa Diosuun, jamapai dasibi min atidu en unaiin. Ea jaska waibu minaki. En mawayamanun min nematidubia en shinain keskawen ea akama min shinanen besti ea axanwen— atan ");
INSERT INTO cbsNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","janua jawen tsuma dabe inun besti anu chintunkidan uxabuki nukutan jatu datekin Pedro yuikin: —Simóneen, ¿min uxamen? ¿Jaskai hora bestichai bedu mestenwantan man ea manatidumamen? ");
INSERT INTO cbsNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chanima matun shinan pebia matun yuda babuwen taea man punu nukaya matuki chakabu jikia man kaneyamanunbun Diosun jau matu medabewanun uxama jabe janchakanwen— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ana jabianudi Diosbe janchai kaxun jabias jancha yuitani ");
INSERT INTO cbsNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ana jua ma uxa paen jatu achia uxabuki nukutan ana jatu bestenwan jawa jancha yuitima maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ana Diosbe janchatani juxun jatu yuikin: —¿Jaskaida man uxa ninkama uxa bestia man juindukunsi ikanai? Uinkanwen. En Diosun bake matun Juchi Kayabi Iyua juni chakabubun ea achi bei ma kemakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ma ea jatu achimai juikiki. Benidikanwen, nun bununbunan— jatu wabidani jatuki dasitushitan jatu yui ");
INSERT INTO cbsNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús jancha menediamaken Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbu inun mae xanen ibubu betsabun jatu yunua juni ichapa nupe chaipayabu inun kushati jiyabube Jesúsun 12 tsuma betsa Judas jatube jukin ");
INSERT INTO cbsNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesúski nukuyukin Judas Iscarioten bebunkidi jatu yubakin yuikin: —Ja en tantsu akaidan, jaki. Achixun iyukanwen— jatu abidanxuwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Iscarioten Jesús bechitushitan jaki nukuxun yuikin: —Yusinaan, en miki nukuyuaii— iwanan, tantsu akaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","“Jakiaki, akanwen”, ibain achiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesúsun tsuma betsan jatu mepanmanun ika nashui ikain jawen nupe chaipa sitan Diosbe nukunabu janchaxunika xanen ibujaidatun tsuma mapexpaikin maebain paxteaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Jesúsun jawen tsuma nematan ma jaki nukuabu Jesúsun jatu yuikin: —Uatian xaba tibi Templo jemaintin anuxun en matu yusinkubainai man ea xabakabi achiama ikubainshinabuki. ¿Jaskai natian meshu medan yumetsu achimisbu shinain jawen deteti nupe chaipaya inun jawen kushati jiya man bekanxumen? Jamen man ea akamaki. Diosun jancha kenekin bebunkidi ekidi yuini jaska menekin man ea achiaii— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","janua dasibi jawen tsumabu datekin Jesús besti jenebaini paxai junei keyubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","bedunan betsa tadi juxupa bestiwen yabukua ja paxama Jesús chibain policiabu betsan achipaikin ");
INSERT INTO cbsNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","jawen tadi besti tsumaya mepamai jawen tadi pekabaini tadiuma paxai junekainiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Janua Diosbe nukunabu janchaxunika xanen ibubu dasibi inun, mae yununika xanen ibubu betsabu inun, Diosun jancha kenenibu yusinananmisbu jabu dasibibu janu Diosbe nukunabu janchaxunika xanen ibujaida Caifásin jiwe anu jabu dukun bua icha maniabu anu Jesús iyukin janu bichiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","janua Pedro datekin benantaxun uinkubaini ka xanen ibun jiwe jemaintin anu Templo mekenikabube tsaua chin yukin june uianyan ");
INSERT INTO cbsNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","januxun Diosbe nukunabu janchaxunika xanen ibubu inun Junta Supremabu dasibi ichaxun Jesús jau tenanunbun jakidi chakabujaida yuiaibuwen chani jancha ikun keska watan jawen unanti watan tenankatsi benai maniabun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","juni betsa betsapabun jakidi chani chitebiakin jakia juni dabetun jabias chani yuiabumaken ");
INSERT INTO cbsNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","jaskaibun betsabudi benitan chani jakidi chitekin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nukun ninkakinan, Jesúsun eska yuiai nun ninkashinaki. Matu yuinun: “Na Dios kenwanti mishki Templo junibun anidan, tekekin pudekin keyutan uxa dabe inun besti kaya junibun akamaken ana en benixanaii”, ikai nun ninkashinaki— jatu wa akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","jabun jabias chani chakabu jakidi yuiyabuma ninkai jaska waxun kupitima shinainbun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","jaska waibu ninkatan Diosbe nukunabu janchaxunika xanen ibujaida Caifás namakis dasibube tsaua benitan nixun Jesús yukakin: —Na junibun mikidi chakabu yuiaibudan, ¿miadan, jaskai min jatube kemanameamamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús pes jawa yuiama niken Diosbe nukunabu janchaxunika xanen ibujaidatun ana yukakin: —¿Jabia min miamen ikaidan, min Diosun bake nukun mekenan Mesías Cristodan?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Jaa. Jaska min ekidi yuiaidan, en jaki. Epa Dios kushipajaidatun jawen yusiudi en tsaua matun Juchi Kayabi Iyua nai kuinwen en juai man ea uinxanaii— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","ninkatan Diosbe nukunabu janchaxunika xanen ibujaida Caifás jaki sinatajaidakin jawen sanpu ushnitan yuikin: —Dios ichaikiki. Ana jatida janchai en ninkakatsi ikamaki. Na jaska jadi janchayadan, ¿jaskada jakidi man shinain?— akin jatu yuka: —Dios ma ichaxuki. Jau tenan menunwen— iake iakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","januxun ichakawakin taewakin jaki kemu michukin jawen bedu beputan kaxe wakin kushakin yukakin: —¿Tsuan mia kushaimenkain? Unantan nuku yuiwe— akubainaibun januxun Dios kenwanti Templo mekenikabundi bepas bepas akaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","janua jemaintin anu Templo mekenikabube Pedro chin yuaya Caifásin tsuma ainbu betsan bechitan yuikin: —Miadan, Jesús Nazaret anuabe min nimiski. En mia unaiin— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedron padankin yuikin: —En ja unanmaki, ja jaska min jakidi janchaidan— itan janu jemaintin kene jikiti xui anu ka niken takada keui taeaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","janua ja ainbun ana Pedro bechitan janu maniabu yuikin: —Na junidan, Jesúsun tsuma betsaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedron ana jatu yuikin: —Jaskamaki— ikaya jabianudi mapuxun Pedro uinkin yuikin: —Chanima min Jesúsun tsuma betsa en unaiin. Galilea anua min jancha en ninkaii— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedron jatu yuikin: —Ja juni man jakidi janchaidan, en ja unanmaki. En chani chakayadan, jau Diosun ea kupinunwen— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","jakimamadi ja kachu takada keuai ninkatan jaska Jesúsun yuikin: “Takada dabeki keudiama dabe inun bestiki: ‘En ja unanmaki’, iki min eki dakei kaii”, abidana shinantan Pedro kaxa chakayamanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ma penaya Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbu inun mae xanen ibubu Junta Suprema jidabi ichaxun jaska wakin Jesús tenantikidi yubakatan Jesús menexxun romano xanen ibu Pilato anuxun chitenun ixun iyuabu ");
INSERT INTO cbsNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaton Jesús yukakin: —¿Miadan, min judio xanen ibubu binu keyuamen?— aka Jesúsun yuikin: —Jawaikika! Jabiadi min ea yuiaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Diosbe nukunabu janchaxunika xanen ibu betsa betsapabun jakidi chani yuikin chiteaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaton ana Jesús yukakin: —Ja mikidi betsa betsapa chakabu yuiaibudan, ¿min jawa jatu yuiamamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesúsun jawa yuiama niken: “¿Jaskai janchamamen?” itan Pilaton jadakidi shinantima tsauken ");
INSERT INTO cbsNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","romano soldadobun jatu achixun bichimabu badi tibi ja Pascua nawaibutian jau bestichai taxninun ja romano xanen ibu Pilaton beyawen taexun maen katuaya jatu kainmaxunpakemisken ");
INSERT INTO cbsNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","jabiatiandi juni betsa jawen kena Barrabás juni betsabube detenamekin jatun xanen ibu detepaikin jatubetan juni betsa tenainmaken jabun achixun bichimabun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","janua yudan kaian Pilato anu ana bexun yuikin: —Nawaibutian juni betsa badi tibi min nuku taxnimaxunmis keska wakin natiandi juni betsa nuku kainmaxunwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Diosbe nukunabu janchaxunika xanen ibubu Jesúski chani chakai jaki sinatakin jaska waxun maematima maemanun ixun iyuabu Pilaton unankin yudan kaian yukakin: —¿Judiobun xanen ibu kayabi Jesús jawa wama matu nichinxunpa?— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Diosbe nukunabu janchaxunika xanen ibubun yudan kaian ana Jesúski sinatajaidamakin jatu dasibidi sinatamakin keyukin: —Jau Barrabás nuku kainmaxunun yuikanwen— jatu waibun yudan kaianen jabiaskadi yuiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaton ana jatu yukakin: —Ja juni: “En judiobun xanen ibuki”, iki kenamisdan, ¿matu jaska waxunpa?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","jancha kushipawen ana yuikin: —Cruzki nuku mastaxunwen— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ana Pilaton jatu yukakin: —¿Natunan, jawa chakabuwashinamen?— jatu waya ana unanxubima jancha kushipawen yuikin: —Cruzki nuku mastaxunwen —aki jawenchains ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","jaskaibun Pilaton yudan kaian daewakin Barrabás jatu kainmaxuntan Jesús jatu kakush kakush amatan jau cruzki jatu mastaxuntanunbun jatu yunua ");
INSERT INTO cbsNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","januxun xanen ibu Pilaton jiwe ewapa jemaintin anu soldadobun Jesús iyuxun soldado jabus jaki xukui ichatan ");
INSERT INTO cbsNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","xanen ibun bemakia tadi chaipa tashijaida Jesús sawemaxun muxa maiti waxun maimatan ");
INSERT INTO cbsNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","unanxubima jancha kushipawen kaxe wakin yuikin: —Judio xanen ibu kayabidan, min miaki— akin jawenchains yuibetanan ");
INSERT INTO cbsNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ji sidiwen makush makush atan jaki kemu michutantankin jaki danti itan jancha pepawen yuixunikapaikin kaxe wakin ");
INSERT INTO cbsNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","keyutan bemakia tadi chaipa tashijaida pekatan jawen tadi kayabis Jesús sawemaxun cruzki mastakatsi kainmabainaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","janua juni betsa Simón jawen mae Cirene anua jawen bakebu Alejandro inun Rufodan, bai anu dayatani jui jatuki nukutan Jesúsun cruz jau iaxunyubainun soldabobun yunua iaxunbainaya ");
INSERT INTO cbsNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota anu Jesús jadi iyukin mapematan, jaska yuiadan, Buxka Xau Mati anudan, ");
INSERT INTO cbsNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","uva vino jene isin nemati dau muka jusia amapayabu danankin akamaken ");
INSERT INTO cbsNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","ma badi jui nai puchinin dakaken Jesúsun tadi peka keyutan mastaxun cruzki nichintan soldadobun shinankin yuikin: —¿Tsuan jawen tadi tibi biainmenkain? Akanwen— ixun jawen beyusti putapakekin jawen tadi paxkatan ");
INSERT INTO cbsNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","jawen taexun jatu tenanmai unanti ji bexa tuaxki kenekin: “Judiobun Xanen Ibujaidaki”, aka bexun Jesús mamaki ja ji tuaxki kenea mastadiaxun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","29","jabianudi jabe juni yumetsu dabedi cruz dabeki mastaxun betsa jawen yusiudi nichinxun betsa jawen yusmaudi nichindiabu junibun dainbainkin budi budi ikin yuikin: —Uinwen. “Dios kenwanti mishki Templo tekekin pudekin keyutan xaba dabe inun besti kaya en ana benixanaii”, min ishianki. ");
INSERT INTO cbsNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Min ja kushipa jayadan, ja cruz anua mimebi paxai butudiwe, mawamadan— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Diosbe nukunabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbundi Jesús kaxe wadiai yuinamekin: —Juni betsabu medabewabiamis jamebi paxatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jaskakenan, jaska Israelbun Xanen Ibu Cristo kayamenkain cruz anua butuai uinkin na jabiatian nun ikunwantiduki— ikaibun ja jaska waibu ninkatan juni yumetsu dabe jabe mastadiabudi jancha chakabukin Jesús yuandiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","janua badi manananbibiaken badi nuka meshua itsa daka manaibun ma badi nai puchinin dakaken bepenakainaya jabiatiandi Jesúsun jui kushipawen yuikin: —Eloí, Eloí, ¿lemá sabactani?— ikidan juni kuin janchadan, “En Diosuun, en Diosuun, ¿jaskakin min ea jeneamen?” ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ja naman jatidi mapuxun betsabun ninkatan yuikin: —Ninkakanwen, Diosun jancha yuixunika Elías kenaikikidan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","janua ja naman mapuabu betsa kushikidan janu jawen tsiniti vino muka pu atan tawaki ustanxun bexun amanun, iwanan, sananxunkin shinankin yuikin: —En daka manakayuti Elíasin buteyui juimenkain— itan niken ");
INSERT INTO cbsNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","janua Jesús ana unanxubima bis itan mawaya ");
INSERT INTO cbsNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Templo medan tadi dintu wakin kebenibu jamebi manaundia dis iki keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","soldado romano capitán Jesúsun besuudi nixun uinkin Jesús bis itan mawaya yuikin: —Chanima kayaki. Na junidan, Diosun bakeki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","janua ainbuaibu Galilea anuabun Jesús Galilea anu ka jabun duawakin chibanmisbun uiainbun jatubetan uindiaibudan, Josén betsa maxku Santiago ja dabetun ewa María inun, Salomé inun, María Magdalenan jabun benantaxun uiainbun janua ainbu betsa betsapabu Jerusalén anu Jesúsbe beshianbundi jatubetan Jesús mawai uinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Janua ma badi kaya jabiatiandi judiobu sábadotian juindukunkatsi bebunkidi piti pewamisbuken ");
INSERT INTO cbsNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","janua judio Junta Supremabube jatube xanen ibumis betsa José Arimatea anua kainitun Cristo Xanen Ibuxanai manakubainshina jawa dateama Pilato anu kaxun Jesús maiwakatsi jawen yuda yuka ");
INSERT INTO cbsNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato e itan yukakin: —¿Ma jawaida jaskatan mawaxumen?— ixun soldado capitán kenaxun yukakin: —¿Jesúsdan, jatian ma mawaxumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","capitánen uinxu ja badi mawaxu yuia Pilaton ninkatan jawen yuda José yunua kaxun ");
INSERT INTO cbsNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","47","tadi juxupa chaipa bixun Jesúsun yuda jawenabubetan butexun tadiwen dayabutan bukin janu maiwati mishki kini waimabu anu datainbu María Magdalena inun Josén ewa Marían uiainbun mishki beputi ewapawen bepunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma sábado juindukunti binushinken María Magdalena inun, Santiagon ewa María inun, Salomén jatibun Jesúsun yuda jawen dapuxkatsi xeni ininti bitanshina ");
INSERT INTO cbsNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","janua penayajaida domingotian maiwati anu bui ma badi kainyuaya ");
INSERT INTO cbsNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","yuinamekunkainkin: —Ja mishki beputi ewapadan, ¿tsuan nuku bepenxunkin tadanxuntidumen?— ikubaini ");
INSERT INTO cbsNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","jakidi besukainkin uinkin ja mishki ewapawen bepushinabu ma jamaudi tadanmea bechitan ");
INSERT INTO cbsNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ja maiwati kini medan jikitan uinkin jabianudi juni bedunan tadi juxupa chaipa sawea yusiudi tsaua uin e ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","jatu yuikin: —Jesús mastashinabu man benai jua en unaiin. Dateyamakanwen. Jaska bebunkidi matu yuishina keskai ma bestenkainaki. Ana nenumaki. Janu datanshinabu jikixun uinbaini ");
INSERT INTO cbsNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","buxun Pedro inun jawen tsuma betsabu menan jatu yuiditankanwen: “Jadan, matu bebunkidi Galilea anu kaxuinkiki. Jadia matube ana ichai benai kaikiki, jaska matu yuishina keskaidan”— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ainbuaibun ninkatan maiwati kini anua kainkaini saki saki iki kushibidani dateyabi bekin jatu dainkubidankin tsua yuiama benibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Penayajaida domingotian Jesús bestenkaini jatuki nukutanun ika kai ja dukun María Magdalena ja 7 yushin chakabu jaya kainmayamaki nukua ");
INSERT INTO cbsNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","janua benimakaini jatu banabimai kakin jabun Jesús chibanmisbu pes mania Jesús manui kaxaibuki nukuxun ");
INSERT INTO cbsNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","jaska Jesús jiwea uinbain jatu yuia jawa ikunwanma ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","janua Jesúsun tsumabu dabe bai tanabainaibu jaska uinmisbu keskama jatuki Jesús nukua uinbidani ");
INSERT INTO cbsNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","bexun jabun chibanmisbu ichapabu jatu banabima ninkatan jabun janchadi jawa ikunwanma idiaibun ");
INSERT INTO cbsNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","janua Jesús jawen 11 tsumabun pi maniabuki nukua uin juinti kushikin Jesús bestean uinbidan jatuki chanibiabu jawa jatu ikunwanma ibayaibun Jesúsun jatu ja atan ");
INSERT INTO cbsNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","jatu yunukin: —Mai jidabi anu bukin Diosun kakape ekidi dasibibu jatu yusinkubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jabun ea ikunwain jenewen man jatu nashimaya en jatu mekexanaii. Jakia jabun ea ikunwankin shinan betsa wabuma en jatu kupixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jaska inun, tsuabunda ea ikunwain jaskakubainxanaibu matu yuinun ninkakanwen. En kushipa jayaxun en kenawen taexun yushin chakabu kainmaxankanikiki. Ja inun, jancha bena tapindiamawen janchaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ja inun, dunu pianan meabu jawa jatu piama ixanai inun, jawada mawati dau jatu amabiabu aka jawa jatu chakabuwatan tenema ixankanikiki. Ja inun, isin teneaibu jatu meabu xuxaxankanikiki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Xanen Ibu Jesús jatube janchai meneaya januxun Diosun nai anu ainitan jawen yusiudi tsaumaya ");
INSERT INTO cbsNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","janua Jesúsun tsumabu kainbaini bukin mae tibi anu yusinkubaunaibun nukun Xanen Ibu Jesúsun jatu medabewakin jawen kushipawen jawada unanti dami atimaska chanima jatu uinmakubainibukiaki. Marcos");
INSERT INTO cbsNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Xanen ibu Teófiloon, en mia kene bumai uinwen. Jaska Jesúsun yusinkin taewani anua jawen tsuma kayabibun uian akeakenibu inun Jesúsun jawada jatun bedubi uinkubainima Diosun jatu katua jabun jawen kushipayabu jau chanikubainxanunbun jabun nuku yusianbu juni betsabun jabiaskadi bebunkidi unankin pewatan nuku kenexunimabuki. Jakia jawen tsumabun yusinmiskidi miandi min ninkaima: “Chanimaki”, eandi jabikaskadi shinankin en mia kenexunai min unankubainxanun jaskani Jesúskidi dasibi yuka iki nati itan eandi ninkakin pewatan en mia kene bumaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","7","Judea mai pakea jatiuma anu Herodes jatun xanen ibu ikunkainaya jabiatiandi jawenabu Diosbe janchaxunika Abíasin enabu xuku betsa anua jawen kena Zacarías jiwekunkainikiaki. Janua jawen ainin kena Isabel Aarónen babadi yuxabujaidakin bake biama jawen benedi anibujaidatun bakewanun ixun shinankubainkin Diosun jancha chibankin jawen yunuti inun jawen nemati kaneabumaken jatuwen Dios benimakunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Janua janu Dios kenwanti Templo anu Abíasin enabu betsabube Zacarías uxe bestichai dayakin ");
INSERT INTO cbsNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Templo anu jikixun jau ininti jatu kuaxuntanun jatun beya chibankin jatun kena tibi kenetan ja una tude bitan jawen kena bechitan Zacarías katuabu ");
INSERT INTO cbsNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","jikixun chi tsistuki jawen Dios kenwanti ininti dau Zacaríasin jatu kuaxunaya jemaintin anuxun yuda ichapabu ichaxun Dios kenwain danti ika maniabun ");
INSERT INTO cbsNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","januxun ininti kuati chi tapu yusiudia Diosun nai tsuma damia nia ");
INSERT INTO cbsNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacaríasin uin e itan en jaskai iki datejaidaya ");
INSERT INTO cbsNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","16","januxun nai tsuman yuikin: —Zacaríasiin, dateyamawe. Jawada min yukai ninkamisxun Diosun mia axunxanikiki. Min ain Isabel yuxabubiatun bake bima juni bake kainxanikiki. Kaiyaintian min benimaya minabudi benimaxankanikiki. Kenakinan: “Juanki”, axanwen. Januxun minabu Israelbu chakabubiakubainaibun Juan kainixun jatu yusinkin nukun medabenan yushin Dioskidi yuda ichapabu chibanmaya benimajaidaxankanikiki. Nanei taea Diosun Yushin Pepatun kushipa wakubainkin jeneama uva jene vino inun jene paepa tibi akama min baken Dios benimawakin minabu Yavé Dios anu ana jatu chintunwanxanikiki, jatu chibanmakinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jaska inun, min bake Juanenan, Diosun kushipaya jawen Yushinyan bebun nixun jaska Elíasin Diosun jancha yuixunikatun ani keska wakin jatun ibubu jabun bakebu ana danananain sintanameama inun ja patapakin ninkaisbuma jau jabundi Dios chibanunbun min bake Juanen yudabu jatun Xanen Ibu juai manamakin jatu shinan betsa wamaxanikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","jawen jancha ninkabiatan shinankin Zacaríasin nai tsuma yukakin: —Ma en anibuaki. En ain yuxabudiki. ¿Jaska waxun min jancha chanima en unantidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","nai tsuman yuikin: —Eadan, en Gabrielki, nai tsuma xanen ibudan. Diosbe beisinain en janchamiski. En mibe janchanun na kakape Diosun ea yunuxuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jakia en jancha min ikunwanmawen taea min bake kaindiama juyu min jiweyukunkainxanaii. Na en mia yuiaidan, Diosun akatsis ikin axanikiki— atan kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","jaskai nishma dakaken Templo jemaintin anuxun manakin jawenabu yuinamekin yuikin: “Jawa dakiai ikikiki, taxniamabin!”, iki maniabun ");
INSERT INTO cbsNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","atimas taxnitan jaska waxun jatu jancha watimaken jabun unanbaunkin jakidi yuikin: —Jaskakenan, ¿Templo dintu medanuxun namai keskakin Dios anua uinxumenkain?— ikaibun jawen meken bestiwen jatu unanmatan jabiaska janchama jatube dayakunkainkin ");
INSERT INTO cbsNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Templo anua jatun daya uxe nichintan Zacarías inun kaxun ");
INSERT INTO cbsNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","jawen ain bakewa tuyaima 5 uxe besti jawenabube janchakatsi ikama Isabel jawen jiwe anus jiwekunkainkin shinankin: ");
INSERT INTO cbsNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“En bake bitidumawen taexun jau ana enabun ea dake wayamaxanunbun Diosun ea bechipaikin ea medabewaikiki”, ika benimakunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Isabel tuya 6 uxe kaya chipash jawen kena María chutanamei pesediama jawen epan beneyawakatsi jatun xenipabu xanen ibujaida Davidin baba José yubakin ibu waimaken januxun Diosun jawen nai tsuma Gabriel jau kakape María yuinun Galilea mai pakea namakis mae betsa Nazaret anu yunua ");
INSERT INTO cbsNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","damitan jawen dintu medan jikixun Gabrielin María yuikin: —En miki baiyuaii. Yavé Dios miwen benimajaidakin mia bechipaikiki— atushia ");
INSERT INTO cbsNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","jawen jancha ninkai e itan Marían shinankin: “¿Jaskakin ea jaska yuimenkain?” ixun shinanyan ");
INSERT INTO cbsNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","31","nai tsuman ana yuikin: —Maríaan, ewen dateyamawe. Miwen dabanan Dios benimajaidaiwen taexun juni bake mia bimakin miki nanexanikiki. Chipu kaian kenakin: “Jesúski”, axanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jamen Xanen Ibu kushipajaidakunkainaya jabun yuikin: “Yushin kushipa jatu binuatun bakeki”, iwanan, kenakubainxankanikiki. Ja inun, jaska matun xenipabu xanen ibu David xanen ibu ini keskai ");
INSERT INTO cbsNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Diosun yunua min bake Jesús Jacobun bababun Xanen Ibu ipaxanikiki, niti ikama ikibi ikidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marían yukakin: —En chutanamei pesediamabia ¿jaskatan en bake nanetidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","jawen nuikin nai tsuman ana yuikin: —Kushipa jatu binuatun jawen kushipawen jawen Yushin Pepa yunua mikia dami naneima kainmaxun jatun Dios chibanyan: “Jadan, medibi Diosun bakeki”, ixun kenakubainxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Jamen betsadan, minabu Isabel ma yuxabubia ma juni bake bimaki. “Jaskatun bake bismaki”, iwanan, yuanbiakubainmisbu jamapai shadabu Diosun atiduwen taea ikis uxe meken buxka ka pustuki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marían yuikin: —Peki. Jaska min ea yuiaidan, jau shinanxun ea anunwen. Diosun tsumadan, en eaki— aka ninkatan kainkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gabrielin María jancha wawanshinken Judea mai pakea mawa mati matipa anu mae jatiumanua María jawaida bai ka ");
INSERT INTO cbsNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacaríasin jiwe anu jikitan Marían Isabel yuikin: —Ewaan, miki bakin en mia uinyuaii— atushiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabelin María ninkaya jawen pustu medanua jawen bake tukuaya Diosun Yushin Pepatun kushipa waya ");
INSERT INTO cbsNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","benimakin Isabelin unanxubima bis iki eai itan yuikin: —Diosun mia bechipaikin ainbu betsabu binumakin mia inun min bake naneshinxun mia jabe duajaida waikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","44","Min ea kena min jancha en ninkaya en bakedi benimajaidai en pustu medanua tukuxuki. En jawayaidaken Diosun ea duawaya en Xanen Ibun ewa min eki bayuaii. Jaskaken en benimajaidaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jaska inun, jawada Diosun mia axunxanai mia yuishina min ikunwainwen taea min benimajaidaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","48","januxun Maríandi yuikin: “En jawen tsuma bexmasjaidabiaken Diosun ea shinankin ea katushinaki. Jaska inun, dasibibun shinankin: ‘Diosun María shinan chankanwanmiski’, iwanan, ekidi yuikubainxanaibuwen taea en mekenan Dios kushipawen taea juinti benimakin en Xanen Ibu Dios en kenwaiin. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","50","Ja inun, duawai jawen kushipaki mesemisbuwen nuikunkaini shinan pepa kushipa jatu binukin keyuatun ea duajaida washinaki, jawen kena medibi pepatunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","53","Jaska inun, ibubis yubakatan keinsbuma jatu xanen ibu wakin betsabu nuitapai buniaibu piti pepa jatu yani wamakin mabu ichapayabu nuitapawakin meken bestia mais jatu nichinmiski. Jaska inun, ibubis keainbu ichakawakin jatu juinti nishma wakin ibubis xanen ibui kushipamisbu jatu mintanuma wakin Diosun jawen kushipa uinmakin jatu unanmaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Janunkain jaska nukun xenipabu Abraham inun jawen bababukidi yubaxuni shinain nukuwen nuikin nun jawen tsumabu Diosun ana nuku medabewakin taewani jeneama nuku axunkubainikiki”, ishian ");
INSERT INTO cbsNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","janu María bayui niti ikama jabe jiwexun uxe dabe inun besti nichintan janua María inun kanikiaki, jawen jiwe anu chintunkainidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Janua Isabelin bake bima ewai pustujaidatan juni bake kainken ");
INSERT INTO cbsNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","59","ja dapi jiweabu inun jawenabun Dios Isabelwen nuikin medabewaya ma bake kaian jabun ninkatan benimashianbun janua kainshina 8 xabatian ibu dabetan jawenabu kena uinun ika bexun jaska jatun xenipabun yununi chibankin jawen jina kubichi mextexuntan jawen epa Zacarías dabipananbun ");
INSERT INTO cbsNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","jawen ewan jatu nemakin yuikin: —Jaskamaki. Jawen kenadan, “Juan” wakanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","jabun Isabel yuikin: —¿Jaskakin jadi min kenai? Min benen enabun kenadan, jadi jayabumaki— ikeaketan ");
INSERT INTO cbsNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","januxun jadakidida jau kenanun jawen epa juyuwen taexun mekenen besti yukabu ");
INSERT INTO cbsNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","mekenendi jaki keneti jau bexununbun jatu yunua bexuanbu Zacaríasin kenekin: “Jawen kenadan Juanki”, jatu wa uin e itan “Jadidikiaki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","jaskatanaibuns Zacarías jawaida ana janchakin Dios kenwanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Januxun ja dapi jiweabu dasibi e iki: “Jabaa!” ishinxun janu mai pakea Judea mati matipanu jiweabu anu jaskashina jatuki chanibaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","jaskaibu dasibibun ninkakin unain jaskakenan: “Diosun ja bake yumewaidan, jaskadada ixanikika”, iki ja bakekidi janchanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Juanen epa Zacarías Yushin Pepatun kushipa wa janchakin Dios kenwain Dios janchaxunkin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“En Xanen Ibu pepa Israelitabun Diosuun, min ma minabu medabewakin jatu pekakin akawai jushianwen taexun en mia kenwaiin. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Min tsuma Davidin baba betsa kushipajaida mekenan kayabi nuku anu min ma nuku nichinxunshinaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nukun xenipabu jatu yubai jakidi jabias min jancha yuinxunika medibi tibi min jatu janchamapaunidan, ");
INSERT INTO cbsNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","jawen taexun nukuki sinatamisbu inun, dasibi nuku dananmisbu min jatu jawen maemakin nuku paxawatiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Jaska bebunkidi nukun xenipabu jawawen jatu jaska wati nuii jatuwen yubakai jatukidi jancha medibi wai min janchapaunidan, jakimama min shinaiin. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jaska jawen kanetima wai nukun xenipabu Abraham min jabe yubakani natian min ma ana nuku shinankin bechipaiaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ana tsua dateyabi nun jiwetidubuma inun nukuki sinatamisbu min jatu nuku daewaxunaki. Jawama nun mia dayaxuni ");
INSERT INTO cbsNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","jaska chanima pepawen bestiwen medibitan nukun jiwea jidabiwen mia bebun nun pe nikatsis ikaii, itan ");
INSERT INTO cbsNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","janua epaan, miadan, ‘Dios dasibi binu keyuatun yuixunikaki’, iwanan, mia kenaxankanikiki. Janu nukun Xanen Ibu Mesías juxanai bebunkidi jawen bai min jatu pewamaxunxanaii, ");
INSERT INTO cbsNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","jau jawenabun jatun chakabuwen taea Dioski mesekin jatun shinan chakabu jenetan Dios buamatan jau meketi jiwea jatu inanxanunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nukun Dios nuikipa chakamatun nuku bechipaikin nai anua jawen bake xaba badi bena keska nuku butexunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yudabu jatun chakabuwen taea atimapanu mawai benui bupananbun meshu ten ikai anua bin chaxa watan nuku inan keska wakin nun jabu jiweyuabu nun jawen unanuma jiwei kai nuku yusinxanikiki”, iniken ");
INSERT INTO cbsNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zacaríasin bake Juan ewai Diosbe jaibunamejaidai unanepai jawenabu Israelbu yusindiama jadi tsua jiweabumanu jiwekunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Janua ja jaskaitian romano xanen ibujaida César Auguston jawen maiwan kesua jidabi anuxun juni tibitun kena netankin jau tanaxanunbun jawen tsuma betsa betsapabu yununikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Januxun tsuan jaska tanakin taewadiama Siria mai pakea anu romano xanen ibu bexmas Quirinio xanen ibuaya romano xanen ibujaida César Augusto ja dukuntun jau jawenabu tananunbun xanen ibu bexmas dasibibu jatu yunuimawen taea ");
INSERT INTO cbsNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","jau tananunbun jatun xenipabun mae tibi anua besti ichai buaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José jawen mae Nazaret mai pakea jatiuma betsa Galilea anu jiwebia Davidin babawen taea ");
INSERT INTO cbsNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josén jawen kena jatu netanmanun ika jawen xenipabu Davidin mae Belén, Judea mai pakea anu kakin María José bimakatsi ibuama bestimabu dadatamea tuyaima iyui jabe kai jikia ");
INSERT INTO cbsNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Belén anu jiwe pakatan uxati ma keyubia texke ikabun jani itima ina jiwe anu José inun María ikabun janua Marían juni bake iyua kaian dachutan yabuxun burro pimati ji xantu wanibuki basi nawatan datanxun uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","jabiatiandi Belén dapixun jabun ina chaxu mekemisbun basi xukua anuxun meshu medan uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Diosun nai tsuma damia Diosun kushipawen chaxajaida jatu dapi nia chaxuwan mekemisbun uin datejaidaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","nai tsuman jatu yuikin: —Dateyamakanwen. Matunabu jawen benimai keyuxanaibu en matuki chanikin kakapepa bexunxuki, ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Matun xenipabu xanen ibujaida Davidin mae Belén anu jaska Diosun yubani matun medabenan Xanen Ibu ma kaianki, Cristo Mesíasdan. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Janu benabaunkin ina jiwe anu yabuxun burro pimati ji xantu wanibuki datanbu man bechi katiduki. Jaska bechitan en jancha chanima man unanxanaii— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","jakimamadi nai tsuma midimajaida damibidan jabetan Dios kenwain nawakin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mai anuxun tsuabunda jabun Dios chibankin duawamisbu Dios kushipajaidatun jau jatu unanuma jiwemanunwen. Jaskaken dasibibun Dios kushipa nai anua jau kenwandianunbunwen”, jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","nai anu ana buaibun benimai yuinamekin yuikin: —Jabaa! Jaska Diosun nuku yuixudan, Belén anu benakin uinun bukanwen— itan ");
INSERT INTO cbsNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","jawaidabaini Belén anu jikitan benabaunkin atimas ina jiwe medan José inun María inun jawen bake burro pimati ji xantu wanibuki datanbu ");
INSERT INTO cbsNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","bechitan jaska nai tsuman bakeishtakidi jatu yuia ninkabidana jatunmebi chaniaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","20","jaska Diosun nai tsuman jatu yuixu ninkabidan uinwani chanima jabiaska uinkanxu chaxuwan mekenikabu chintunbainkin Dios kenwankubainaibun dasibibun jaska jabun yuikubainaibu yuda betsabun ninkai e itan shinain: “¿Jawa yui ikanimenkain?” ikaibun janua Marían jaska wanaibu jawen juinti medans shinan jeneama inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Janua 8 día ka manashinxun jawen xenipabu Abrahamnen ani keska wakin jawen jina kubichi mextekin jatu bimatan María bake nanediama jabias kena Diosun nai tsuman yuimakidi shinankin Josén Maríabetan kenakin Jesús wabun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisin yunukin bake kainma naxuxatan besti jau ichati jiwe anu jikixanunbunwen, ani jaska chibain María bake kainma ma naxuxai pea janu jawen ibu dabetan ja bake Jerusalén anu jatun Xanen Ibu Dios jawenawamanun ixun iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ja dukun bebunkidi Dios janchai “Juni bake ja dukun kaianan, enaki”, ikai Moisin ninkatan keneni jaska chibankin jawenawamatanun, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","iyukin ja inantan ana jawena wakatsi ikin jaska Diosun yununi keska wakin deiwan dabe ja menuxunti buaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","jabiatiandi juni betsa pepajaida Dios kenwankin kaneisma jawen kena Simeón Jerusalén anu jiwexun Diosun Israelbu dasibi ana medabewakin jatu pekakin akawaxani yubani Simeón manakakubainshina jawen Yushin Pepa jaya jatun medabewakin unanmaya ");
INSERT INTO cbsNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mesías Diosun yunuxanai uindiama jau debuyamaxanun Diosun Yushin Pepatun yubaimaken ");
INSERT INTO cbsNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","januxun Templo jemaintin anu Diosun Yushin Pepatun Simeón yunua ka tsauken jaska Moisin yusini jawen juni bake bianananun ixun ibubun iyui jemaintin anu jikiaya januxun Diosun Yushin Pepatun Simeón yusinkin jadatuda bake jabun medabenan jau unanun ixun unanma ");
INSERT INTO cbsNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","benimakain María Jesús mebintan ikuxun Ibu Dios kenwankin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Xanen Ibu kushipatuun, natian ea duawakin jaska min ea yubaima min ma akaki. Jaskawen taea jawa dateama unanuma benima paewen en mawaxanai ea ana nemayamaxanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na bakewen yudabu paxawakin min mekexanai en ma uiaiin, ");
INSERT INTO cbsNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","jawen taexun na bakewen dasibi jiwebaunabu min xanen ibuai jawen min jatu unanmaxanaidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jadan, bin ewapa chaxa keska nawa betsa betsapabun uinkin minabu Israelbu min kushipawen min jatu duawai uindiaxankanikiki”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","jaska wai ninkai José inun María e idabeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","januxun Simeónen jatu yuikin: —Diosun jau matu duawakubainxanunwen— iwanan, María besti yuikin: —Na bakedan, jawen yuda Israelbu unanti wakatsi Diosun katuniki. Jawen yusian ninkatan jatiditun shinan betsa watan chibainbun inun jatiditun shinan betsa wama danankubainxankanikiki. Min bake danankin nupe kenujaidawen min juinti chachia keska wakin mia yumanwankin mia nuitapawaxankanikiki— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Jamen betsadan, Israelin bake Aserin baba betsakidi mia yuinun ninkawe. Penuelin ainbu bake Ana chipash beneyaima 7 badi besti jabe jiwea jawen bene mawaniken janua beneuma 84 badi jiwekunkaini Diosun jawen jancha yunua jawenabu jatu yuixunmis Dioski mesei samakekin jau jawenabu medabewanun ika jawen kenwanti Templo jemaintin anua kaianma jatu Dios yukaxunkubainmis ");
INSERT INTO cbsNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","José inun Maríaki nukutan jadi benimakin Dios kenwantan jaska Diosun Jerusalénkidi yubani dasibibun manaibu Anan uinwanshinxun Jesúskidi jatu yuikin kaka wakubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Januxun juni bake ja dukun kaian jau jaska wai bununbun Moisin kenekin yununi chibankin menetan Galilea jawen mae Nazaret anu chintunwankin ana jawendi Josén jatu iyuima ");
INSERT INTO cbsNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","jadia Jesús ewai jawen yuda kushipai unanepaya Dios jawen benimakin duawakubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jaska inun, Pascuatian Egipto anuxun jatun juni bakebu tenanma jatun xenipabu Diosun nai tsuman jatu dunkebaini shinain besinun ika badi tibi Jerusalén anu Jesúsun ibubu bupakemisbun ");
INSERT INTO cbsNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","janua ma Jesús 12 badiyaken jawen ibubu jatun beya chibain buaibu jabiatiandi Jesús jatube kai taeshina ");
INSERT INTO cbsNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","jawen ibubu besi keyutan jawen mae anu jatube jiwemisbube José inun María chintunbidanaibun janu Jerusalén anu Jesús besti bashikua ibuan unanma benadiama shinankin: “Jabe bedunanbube juikiki”, itan, José inun Marían shinanyabi kai ma xaba jidabi chai buxun badi kaya Jesús jawenabu anu benakin nati atan ");
INSERT INTO cbsNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","jawenabu anu inun jawen mae anu jiweabu anua jawa bechiama benakin keyutan janu uxashini Jerusalén anu benanun ika chintunkainshina ");
INSERT INTO cbsNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","janua 3 día ibubun benakubaunkin atimas Templo jemaintin anu jaki nukutushikin Diosun jancha kenenibu yusinananmisbube tsauxun jatu ninkakin Jesúsun jatu yukai jatube janchanamekunkainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesús unanepai ninkakin jabun ja yukaibu tibi yui pewaiwen taea dasibibun ninkai: “Jabaa! ¿Tsuan juni bake bedunan unanepamen?” iki jabube maniabu anu ");
INSERT INTO cbsNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","atimas jawen ibubu jaki nukui e itan jawen ewa Marían yuikin: —Kukaan, ¿jaskakin min nuku jaska washinamen? Ea inun min epa miwen nui chakayamai datekin nun mia benakin mae nati ashianki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesúsun jatu yuikin: —¿Jaskakin man ea benabaunai? ¿En Epan jiwe anua ma en jatube yuinametidu man shinanmamen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","jawa jatu yuiai dabanen ikin ninkabumaken ");
INSERT INTO cbsNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","janua kainmabaini jawen ibu dabebe Nazaret anu chintunbainima jadia Jesús yumei ninkanikai jawen ibubun jancha tapinkubainaya ibu Marían juinti medans Jesús jaskai jakimama shinanxunkubainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","janua jawen yuda ewai jawen shinan unanepaya Dios inun jawenabu jawen benimakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Janua badi ichapa kaya romano xanen ibujaida betsa Tiberio César ma 15 badi xanen ibukin dasibi jatu yunukubainaya Judea anu Poncio Pilato romano xanen ibu bexmasaya Galilea anudi jawen tsuma Herodes romanoma xanen ibu bexmasdiaya Iturea inun Traconítide anudi jawen tsuma Herodesin betsa Filipo xanen ibu bexmasdiaya Abilene anudi jawen tsuma Lisanias xanen ibu bexmasdiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ja jaskaibun Jerusalén anuadi judiobu Anás inun Caifás Diosbe jawenabu janchaxunika xanen ibujaida dabe inibukiaki. Ja jaskaibu betsatian Zacaríasin bake Juan janu tsua jiweabumanua ewaima jiwea Diosun yunua ");
INSERT INTO cbsNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","taxnikidan Jordán jene ketankubaunkin jiweabu tibi jatu yusin taewakin yudabu yuikin: “Matun shinan betsa watan matun chakabu Diosun jau matu buaxunxanun ninkatan jawada chakabuwen man benua jiwea jenedikanwen. Matun shinan maewatan man ea uinmaya en matu nashimaxanaii”, iwanan, jatu yusinkubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jaska Diosun jancha yuixunika Isaíasin jakidi kenekin yuini keska axuin Juan jaskanikiaki: “Jadi tsua jiweabumanua jui kushipawen chanikin jatu yuikin: ‘Nukun Xanen Ibu nai anua matuki bayui ma kemaikiki. Matun juintinin shinan pewadikanwen, bai kayatapia keska wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Napaku tibi buakin mata waxun mati tibidi pewakin panpa waxun xantu xantupadi keyu buakin panpa waxun jawen bai pewaxuna keska wakin jatun jiwea pewatan ");
INSERT INTO cbsNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","januxun Diosun medabewati jua dasibibun uinxankanikiki’ ”, akin jaska yuini keska wakin Juanen akin jatun chakabu Diosun jau ana shinanyamakubainxanun chakabu jenekin jatun shinan betsa watan jawenabu jawen unanmati Juan yukakin: “Ea nashimawe”, jau ea anunbun ixun Juanen jatu yusinkubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","8","Janua Juanen jau ea nashimanun ika bebidan bebidanaibu jatu yuikin: —Matudan man padananan dunu pianamemis keskabuki. Man jaska keska matuki Dios sinatakin matu kupijaidaxanaiwen taea matun shinan betsa wakanwen. Jaska waxun matun chakabu man ma bextekea xabakabi man ea uinmaya en matu nashimaxanaii. Jamen jaskama ibubis kein shinan betsa wakatsi ikama: “Nukun xenipabu Abraham Diosbe jaibunameniwen taea nun jawen bababu nuku kupiama ixanikiki”, ikin, ana shinanyamakanwen. Jakia Abrahamnen bababu dasibi matu yamawakin keyutan na mishki manibauna Diosun damiwakin Abrahamnen bababu benawaxuntiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jaskaken matu yuinun ninkakanwen. Ji tibi bimi pepa jayama dedatan man kuamis keska wakin bestibu Diosun matu kupixanikiki. Jamen tsuabuda Abrahamnen baba kayabibun jawen yusian jau chibankubainunbunwen. Jakia man jaska wamaken matu kupinun, iwanan, duewen matu deda keska watan chi anu matu udenun ixun manaikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","januxun yudabun Juan jaskai ninkatan yuka ikin: —Jaskakenan, Dios daewakinan, ¿jaska waxanpa?— akeakeabu ");
INSERT INTO cbsNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanen jatu yuikin: —Dios daewakinan, min tadi dabeyadan, ja nuitapai tadiuma man betsa inantiduki. Ja inun, min pitiyadan, yuda betsa piti jayama man betsa inantiduki— iwanan, jatu yuikubainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","jabun romano gobierno pei bixunmisbudi jau eadi nashimanun ika bexun yukakin: —Yusinaan, ¿nukukain, nun jaskatidumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanen jabudi yuikin: —Gobierno pei bixunkin man ichawaxunmisdan, janu kesua besti xanen ibun matu yunua bixunkubainxankanwen, ana jatu padanmadan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","januxundi soldadobundi yukakin: —Nukukain, yusinaan, shinan betsa watan mia unanmakatsidan, ¿nun jaskaxanai?— akabu Juanen jabudi yuikin: —Matudan, matun shinanen ichakanikakin jatun jamapai mebinyamakubainxankanwen. Ja inun, chani chakakin yuda betsan pei padantan mebinyamakanwen. Jakia matun daya pei besti bi benimakubainxankanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ninkatan ichapabu jawen janchawen benimakin jabun medabenan manakin Juankidi shinain yuka iki yuinamekin: “Diosun yubani nukun Mesías Cristodan, ¿jamenkain?” ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","jaskaibu Juanen jatun shinan unankin dasibi jatu nemakin yuikin: —Chanima, eanan jawen matu unanmati wakin jenewen besti en matu nashimakubainaii. Jakia ja man jakidi shinainan, kushipajaidatun ea binuan chipu juikiki. Kushipajaida mesetun ea binujaidawen taexun en jawen jawaumajaidatun jaska waxun jawen bichi tae mexpun pekakin medabewakin jawen dayadu itsakin kushipa midintun en axuntidumaki. Jakia jatun matu pepawakin Diosun Yushin Pepa matu inantan bika matu tenemakin matun chakabu buakin yamawa keska waxanikiki, jawada chakabu bechipaiama chiwen kua keska wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jaska inun, xekiwan bimi ta keyuxun pepa aduti anu adutan jawen xepa man kuamis keska wakin dasibi jawenabuma danankin jawa chi nukaisma anu udenxun kuanun, iwanan, manakubainikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","januxun jancha ichapawen jatu nemakin yusinkin jatun shinan jatu betsa wamakin kakape Juanen jatu yusinkubainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","januxun judiobun xanen ibu Herodesin jawen betsa Filipon ain Herodías mebinshina inun chakabu betsa betsapa wakubainai ninkakubainkin uintan yudabu jakidi yuishinxun Juanen nemakin jawen chakabu jenemanun, iwanan, betsabun ninkaibun Juanen Herodes nemakin ja ashianwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes jaki sinatakin Juan jau ana jakidi janchayamanun, iwanan, jawen soldadobu jatu bichimanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan bichidiabuma yuda ichapabu nashimakubainkin Jesúsdi Juanen nashima jawen Epa Diosbe janchaya nai baxnei ");
INSERT INTO cbsNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Diosun Yushin Pepa deiwan keska jui jamamaki butuaya nai anuxun jawen Epan yuikin: —Miadan, min en bakeki. En mia bechipaijaidakin katunidan, en miwen benimajaidaii— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jabiatiandi Jesús 30 badiya jawen Epa Dios dayaxunkin taewaya Josén yumewaimawen taexun yudabun yuikin: “Jesúsun epadan, Joséki”, iwanan, yuikubainibukiaki. Jawen xenipabukidi mia yuinun ninkawe. Josén epadan, Elíkiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elín epadan, Matat inikiaki. Matatin epadan, Leví inikiaki. Levín epadan, Melquí inikiaki. Melquín epadan, Janai inikiaki. Janain epadan, José inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josén epadan, Matatías inikiaki. Matatíasin epadan, Amós inikiaki. Amósin epadan, Nahúm inikiaki. Nahúmnen epadan, Eslí inikiaki. Eslín epadan, Nagai inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagain epadan, Máhat inikiaki. Máhatin epadan, Matatías inikiaki. Matatíasin epadan, Semeí inikiaki. Semeín epadan, Josec inikiaki. Josecin epadan, Joiadá inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joiadán epadan, Johanán inikiaki. Johanánen epadan, Resá inikiaki. Resán epadan, Zorobabel inikiaki. Zorobabelin epadan, Salatiel inikiaki. Salatielin epadan, Nerí inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerín epadan, Melquí inikiaki. Melquín epadan, Adí inikiaki. Adín epadan, Cosam inikiaki. Cosamnen epadan, Elmadam inikiaki. Elmadamnen epadan, Er inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erin epadan, Josué inikiaki. Josuén epadan, Eliézer inikiaki. Eliézerin epadan, Jorim inikiaki. Jorimnen epadan, Matat inikiaki. Matatin epadan, Leví inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levín epadan, Simeón inikiaki. Simeónen epadan, Judá inikiaki. Judán epadan, José inikiaki. Josén epadan, Jonam inikiaki. Jonamnen epadan, Eliaquim inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimnen epadan, Meleá inikiaki. Meleán epadan, Mená inikiaki. Menán epadan, Matatá inikiaki. Matatán epadan, Natán inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánen epadan, David inikiaki. Davidin epadan, Jesé inikiaki. Jesén epadan, Obed inikiaki. Obedin epadan, Booz inikiaki. Boozin epadan, Sélah inikiaki. Sélahn epadan, Nahasón inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasónen epadan, Aminadab inikiaki. Aminadabin epadan, Admín inikiaki. Admínen epadan, Arní inikiaki. Arnín epadan, Hesrón inikiaki. Hesrónen epadan Fares inikiaki. Faresin epadan, Judá inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judán epadan, Jacob inikiaki. Jacobun epadan, Isaac inikiaki. Isaacun epadan, Abraham inikiaki Abrahamnen epadan, Térah inikiaki. Térahn epadan, Nahor inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahorin epadan, Serug inikiaki. Serugin epadan, Ragau inikiaki. Ragaun epadan, Péleg inikiaki. Pélegin epadan, Éber inikiaki. Éberin epadan, Sélah inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélahn epadan, Cainán inikiaki. Cainánen epadan, Arfaxad inikiaki. Arfaxadin epadan, Sem inikiaki. Semin epadan, Noé inikiaki. Noén epadan, Lámec inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lámecin epadan, Matusalén inikiaki. Matusalénen epadan, Henoc inikiaki Henocin epadan Jéred inikiaki. Jéredin epadan Mahalaleel inikiaki. Mahalaleelin epadan, Cainán inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánen epadan, Enós inikiaki. Enósin epadan, Set inikiaki. Setin epadan, Adán inikiaki. Adánen epadan, Dios inikiaki. Jaskaken Jesús juni kayabi idianiki, nuku keskadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Janua Juanen Jesús nashimaya Diosun jawen Yushin Pepawen kushipajaida wa jene Jordán anua Jesús kai janu tsua jiweabumanu Diosun Yushin Pepatun Jesús iyushina kauanaya yushin chakabu xanen ibu diablon padankin kanemanun ikaya janua 40 día janu jiwexun jawa piama binukainaya jaskakainaya Jesús bunijaidai ");
INSERT INTO cbsNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","uinkin unanti wanun, iwanan, yushin chakabu diablon Jesús yunukin: —¿Jaska min Diosun bakemenkain? Na mishki damiwakin misi wawe, min buniai ja pixunan— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","januxun Jesúsun nemakin: —Jaskakidi Diosun jancha kenenibudan, ninkawe. “Piti besti shinain yudabu jawens jiwetidubumaki. Jakia Diosun jancha yuini ninkakin chibain yudabu pei jiwetidubuki”, aniki— iwanan —Jaskawen taexun ja min ea yunuaidan, en akamaki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","jaska ninkatan januxun mati keyatapajaida anu yushin chakabu diablon Jesús iyuxun mai jidabi anu mai pakea jawendua tibi inun jawen damiwati kushipawen jawaida xabakabi uinmakin ");
INSERT INTO cbsNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","yuikin: —Na mai jidabi mai pakea tibi anu inun jawen xanen ibubu dasibi mebinixun en mekeawen taexun tsuada en kushipa inankatsi en jaska wamiswen taexun jau mia kenwanxanunbun en mia jatu xanen ibu wamatiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jaskawen taexun eki mesei danti ixun ea kenwankin min ea xanen ibu waya dasibi mia inantan en mia jatu mekemakubainxanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesúsun ana nemakin: —Na Diosun jancha kenenidan, ana ninkawe. ‘Matun medabenan Yavé Dios ja besti duawakin kenwankubainkanwen, yushin betsa ninkamadan’, aniki. Jaska keneniwen taexun ja min jaska yuiaidan, en mia akamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","januxun Jerusalén anudi iyuxun Templo keyatapa mamaki nichinxun diablon ana yuikin: —Na Diosun jancha kenenidan, miandi ninkawe. ‘Jau mia mekekubainunbun jawen nai tsumabu Diosun yunuxanikiki. Mishkiki min jutekepanan min kauanai mia mekesuxankanikiki’, aniwen taea jaska min Diosun bake kayamenkain ea uinmai nenua ishchuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ana nemakin Jesúsun yuikin: —Jaska kenenibu min dama yuiai chanimabiaken ana betsa entsedi mia yuinun ninkawe. ‘Matun Yavé Dios unanti wayamakanwen’, akin kenekin yusindianiki. Jaskawen taexun min ea ana yunuaidan, en ikamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ana jawawen padankin unanti watima janu tsua jiweabumanu ana iyuxun chipu ana padankatsi Jesús diablon jeneyubainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","janua Galilea anu kaxun mae tibi anu jatun ichati jiwe anu jikia akeakekin Diosun Yushin Pepatun kushipa jayawen taexun Jesúsun jatu yusiain ninkai jakidi janchakin dasibibun kenwankubaunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jaskakunkauntani janua yumei ewaima Nazaret anudi ka jaskai jatube ichai beyamis juindukuntitian janu ichamisbu jiwe anu jatube jikia Diosun jancha kenenibu yuixunun ika Jesús benia niken ");
INSERT INTO cbsNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Diosun jancha yuixunika Isaíasin keneni jancha una inanbu chudetan jakidi jancha kenenibu bechitan jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Nuitapaibu kakape en jatu yusinun Diosun ea katuniwen taea jawen Yushin Pepa en jayaki. Januxun juinti nishmabu jatu benimawakin yuda betsan jatu tsuma wa jenemakin bekun keskabu bepexa keska wakin jatu yusin pewakin jatu ichakawaibu nemakin Dios benimawatikidi dasibibu en jatu unanmakubainxanun Diosun ea yununiki”, jatu watan keneni jancha yuikin keyuxun ");
INSERT INTO cbsNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ana sebitan una mekenika inan mebintan aduaya ana jatukidi besua tsaua manibaunxun beis chakayamaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesúsun jatu yusinkin taewakin: —Jaskakidi Isaíasin keneni en matu yuixunai man ninkaxudan, nukunabu medabewakin na jabiatian Diosun ma meneikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","unanepakin jancha pewen jatu yusiain ninkai e itan jawen jancha bechipaibiakin shinain: “Nadan, nukunabuki, Josén bakeki. ¿Janixun jaska tapintanshinxun nuku yuimenkain?” iki yuinamebaunaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesúsun ana jatu yuikin: —Man ea itimaska kaya wai en uiaiin. Unanepa janchawen man ea yuikin: “Min juni dauyakiaki. Mimebi xuxakin min kushipa nuku uinmawe”, ea akin, “Cafarnaúm anuxun jawen unanmati dami kushipa min jatu uinmashinakiaki. Min ashian keska wakin na min mae anuxundi nuku axundiawe, nun uinunan”, akin man ea yuitidubuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ana jatu yusinkin: —Chanima Diosun jancha yuixunikadan, jawenabun jawen mae anuxun ninkakatsi ikama dananmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jaska inun, Diosun jancha yuixunika Elías jiweken badi dabe inun besti namakis ui ikamaken pitiuma nukun xenipabu nuitapajaidaibun ainbu jawen bene ma mawayama midimabudi yumankubainibu man ninkamiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Jaskabiaibun nukun xenipabu Israelbu beneuma nuitapaibu jau Elíasin dasibi jatu medabewanun Diosun yunuama iniki. Jakia maewan Sidón dapi mae betsa Sarepta anu nawa ainbu beneuma nuitapai jiwea besti jau medabewanun Diosun Elías yunukin nichiniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jaska inun, Diosun jancha yuixunika Eliseo jiweatiandi jatidi nukunabun chami buisma teneaibun nukun xenipabu jatuki dakekin danainbu Eliseon jatu xuxawamadi iniki. Jakia Siria anua nawa betsa jawen kena Naamán Eliseo anu Diosun yunua ja besti xuxawaniki— akin ");
INSERT INTO cbsNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","nawabukidi jatu yuiai ninkai dasibi ichati jiwe anu ichabu jatu jaska wai ninkatan jaki sinatajaidakin ");
INSERT INTO cbsNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","kainmabainkin Jesús tsumaxun ninikubainkin jatun mae mawa keyatapa mamakixun januxun xutunun, iwanan, iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","janua Diosun kushipawen ichabu namakisa kakin jatu mepanmabaini jawen mae jenebainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Janua Galilea mai pakea anu Nazaret jenebaini mae betsa Cafarnaúm anu jikishinxun sábado tibi jatun ichati jiwe anuxun jatu yusinkubainkin ");
INSERT INTO cbsNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","xanen ibu kayabi kushipakin jatu yuiai yudabun ninkai e itan: “¿Jaskamen?” iki benimakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","jabianudi juni yushin chakabuya tsaua yushinen bis imakin unanxubima yuimakin: ");
INSERT INTO cbsNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús Nazaret anuaan, ¿jaskai nuku anu min juxumen? ¿Nun yushin chakabu nuku yamawanun ika min juadaka? En mia unaiin, min Diosun bake pepa medibidan— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","yushin chakabu Jesúsun nemakin yuikin: —Janua jaskama nesetan ja juni anua kaindikaintanwen— aka yushin chakabu juni medanua kainkainkin jawa wama mai pusamabainai uin dasibibu ");
INSERT INTO cbsNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","datei: —Jabaa!— ike ikei yuinamekin yuikin: —Nadan, yusian betsa jayaki. Xanen ibu keska kushipajaidaki. Jawen jancha paepaki, yushin chakabu xunska yunua ninkai jawen datei kainkanikikidan— itan ");
INSERT INTO cbsNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","janua bui jakidi chania akeakeaibu dasibi janu jiwea akeakeabun Jesúsun jaska wai ninkanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ja juni medanua yushin chakabu nichintan jatun ichati jiwe anua kaya Simón Pedron jawen jiwe anu Jesús iyua Simón Pedron dais ainbu yuna chakayama daka ninkatushitan jawen isin jau mainwanun jakidi Jesús yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","janu dakanu Jesús kaxun jawen yuna nemaxuna damaintan benikain jabiatiandi jatu duawakin bawaxun jatu pimaya ");
INSERT INTO cbsNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","jaska waxu ninkabaikin janua ma badi kai meshuaya dasibi ja mae anu jiwea akeakeabun dasibi isin betsa betsapa teneaibu Jesús anu iweabu Jesúsun jabu tibi mekin xuxawakin kaya wapakekin ");
INSERT INTO cbsNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ja isin betsa betsapa teneaibu anua yushin chakabu nichian kainkainkin unanxubima jancha kushipawen yuikin: —Miadan, min Diosun bakeki— akin yuikin Diosun Mesías Cristo unainbuwen taexun jau jadidi janchakin ana yuiyamanunbun Jesúsun jatu janchamamakin nemapakekin yushin chakabu kainmapakenikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Janua uxashini ma pena kemaya Jesús butukaina mae dapi benanta ja mesti ka benabaunkin jawen jaibuaibun bechitan jaki nukuxun yuikin: —Dasibitun mia benakanikiki. Nenua ana kayamawe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesúsun jatu nemakin yuikin: —En Epa xanen ibuaikidi en jatu yusinkubaunun ea yununiki. Jaskakenan, mae betsa betsapa anu en yusindiai katiduki— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Israelbun mae tibi anu Jesús kakunkaunkin janu Diosun jancha ninkakatsis iki janu judiobu ichamisbu tibi anuxun jatu yusian akeakenikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jatu yusinkubauntani Galilea ianenwan ketankubaini kakin jawen kena betsa ian Genesaret anu niti ixun jatu yusianyan Diosun jancha ninka pewakatsis iki jaki midima ichakin texke akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","xaxu ewapa dabe xaka mashin keti axun baka nexenikabun jatun jisin chukaibu Jesúsun uinkubaini ");
INSERT INTO cbsNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","kakain Simón Pedron xaxuki inatan jau ana ja kachu xekanunbun yunua jawen betsabetan jawen jisin jawaida nexetan jawen xaxu ja kachu xekakin nuntanxunabu ja namaki tsauxun kexa mapubaunabu Jesúsun jatu yusinpakekin ");
INSERT INTO cbsNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","keyutan Simón yuikin: —Ana ja kachu nuajaidanu xekaxun januxun baka bikin nexekatsi matun jisin pukubaunkanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónen yuikin: —Yusinaan, yame chai tanakin nun pukujaidabia nun jawa biama ishiaiin. Jakia jaska min nuku yunuai en anun kain— ixun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","nuajaida anu xekatan jawen jisin jawen betsabetan pukubaunabu baka midima jikia ninibidanabu xankamajaida jatun jisin tadas iki taeaya ");
INSERT INTO cbsNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","xaxu betsa anu jawen jaibuaibu jabe dayamisbu jau medabewai benunbun jatu meken bea bea aka jawaidabidan medabewakin jatun xaxu dabe baka mata wabu xaxu jikikatsis ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","baka midima nexekanxuwen taea Simón Pedro inun jabe dayamisbu inun Zebedeon bakebu jawen jaibu betsabu Santiago inun Juan e e iki dateaibun Simón danti itan Jesús yuikin: —Yusinaan, en juni chakabuki. Ea anua butukaini ea jenebaini kadiwe— abia Jesúsun yuikin: —Eki dateyamawe. Na ikis min baka nexexu keska wakin yudabu min ea jatu ichawaxunxanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","jatun xaxu dabe keti atan janu jawenabube xaxu inun jisin bakayabi bashibainkin tapinkatsis ikin Jesús chibain jabe bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Janua chipu betsatian mae betsa anu Jesús kaken juni bichiki dasibi chami betsani Jesúski nukutan ja bebun dankui sapakain di itan beuxun ea akin: —Yusinaan, ea kayawakatsis ikin min ea kayawatiduki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","jawen chamiwen datekin danankin tsuan metsakin meisbumabiaken Jesús jawen dabanan iki mexunkain mekin yuikin: —Jaa. En mia kayawaii— aka jawen chami sakada iki daxnukui keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesúsun nichinkin nemakin: —En mia yuiai ninkaidawe. Jawada en mia axukidi tsua yuiyamayukubaintanwen. Jadi dukun kakin Diosbe nukunabu janchaxunika min yuda min ma kayaxu uinmatanwen. Jaska min ma kayaxu jau dasibibun mikidi unanunbun jawen jatu bepadanbainkin jabiaskadi inankuin Moisin yununi jatu anu buditanwen. Min jaska buaya min kayaxu jabun unanxankanikiki— abaini kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","yuda betsabun Jesúsun jaska wakin akaikidi chanibaunaibu ninkatan jawen jancha ninkakatsis iki inun jau jatu xuxawanun badi tibi Jesús anu bebidan bebidanaibu jatu xuxawapakei ");
INSERT INTO cbsNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","janua jawen Epabe besti janchanun ika jatu paxkabain janu tsua jiweabumanu kakunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Janua ana xaba betsatian Galilea inun, Judea mae betsa betsapa anua inun, Jerusalén anuadi beshinxun Jesúsun yusiain ninkai tsauabun jabianudi Moisin jancha chibanjaidanika fariseobu inun Moisin jancha yusinananmisbu jiwe medan ichaxun Diosun xuxawati kushipayatun Jesúsun jatu yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","jau Jesúsun xuxawanun, iwanan, juni yuda babuni jaki isin teneaibu butiki datantan jawen jaibuaibun Jesús anu bakebidani ");
INSERT INTO cbsNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","janu yudan kaian xukuabuwen taea jaska watan bichibain Jesús uinmatima mai bawa jiwe sapa xeni mamaki inabain jawen dakatiki janu butenun, iwanan, janu bexpa wakin pudenkin xui watan janu ja juni yuda babuni Jesús anu buteaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","jaska jatun shinan ikunjaidawaibu unankin juni yuda babuni Jesúsun yuikin: —Dateyamawe. Min chakabuwen Diosun mia kupikatsis ibiakin man ea ikunwainwen taexun jau Diosun ana shinanyamanun en mia buaxunaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Moisin jancha jatu yusinmisbu inun fariseobun ninkatan Jesúski sinatai june yuinamei: “Ja juni chakabuki. Dasibi nuku padain Dios keskakatsi ikikiki. Diosun besti jawen chakabu buatiduki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","januxun tsuan Jesús yuiamabia jatun shinan unankin Jesúsun jatu yukakin: —Matunan, ¿jaskakin man shinan chakai ikai? ");
INSERT INTO cbsNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jadatu bikamamen, jawen chakabu buaxunadaka, jawen yuda beniadaka? Ja dabe bikaken Diosun besti atiduwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","¿jaskakin man shinan chakai? En matun Juchi Kayabi Iyua na mai anua ea en jawen kushipa jayatun jawen chakabu en buaxuntidu man unanun en akai uinkanwen— iwanan, juni yuda babuni kaya wakin yuikin: —Benitan mia jaki bakebidankanxu bui min jiwe anu kadiwe— akin ");
INSERT INTO cbsNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","jawaida kayawa benikauan jawen dakati bitan buaya mapubaunabun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","date paeyabi yuikin: —Jabaa! Tsuan jaska waismaki. Jakia Dios pepajaida kushipatun na juni ma kayawaxuki. Natian jaska nun uinsma nuku uinmaikikidan— iwanan, Dios kenwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Janua kainkaini janu bai kexa anu januxun Roma gobierno pei bixunmisbun jiwe anu Leví tsaua Jesúsun bechitushitan yuikin: —Ea chibankubainwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví benitan dasibi jenebainkin chibankin taewai jabe kashinxun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","jawen jiwe anuxun Jesúswen benimakin piti midima jatu pewamatan xanen ibu pei bixuin padanananmisbu inun jawen jaibu betsa betsapabu jatu ichawa Leví inun Jesúsbetan piaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Diosun yunuti inun jawen nemati yusinananmisbu inun fariseobun Jesúsun jatubetan piai uinkin yuankin jaki chiti ikabu yukakin: —¿Jaskakin matun yusinan pei bixunika chakabubu inun nuku ninkaisbumabetan pimenkain? Chakabujaidabubin!— ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesúsun jatun jancha ninkatan jatu yuikin: —“En peki”, iwanan, shinainbu anu juni dauya kaismaki. Jakia isin teneaibu anu besti juni dauya kenabu kamiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jaskaken: “En chakabuki”, iwanan, shinainbu jatun juinti pewakin en jatu medabewa shinan betsa watan jau Dios ikunwanunbun en juniki, juni dauya keskaidan. Jakia: “En chakabumaki”, ikin shinainbu jatu medabewatanun ika en juamaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","januxun ana betsan Jesús jatu yukaxunkin: —Nashimanika Juanki chiti ikabu inun fariseobuki chiti ikabun jatun chakabuwen taea jatunmebi ichakanikai samakechakayamakin Dios kenwankin jawen kushipa yuka chakayamakin jawa piyuisbumaki. ¿Jaskai miki chiti ikabu samakeama badi betsa tukanma pikin nexukubainmisbumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesúsun jatu yuikin: —Juni ainyain nawaibu anu jawen jaibuaibu paxkadiabuma piama jatunmebi ichakanikatidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jakia jatu xununbaini ma jatu dapaxkabaini kaken manukin jawen jaibuaibu samakekin piama itidubuki. Jaska keska kainkin en jatu xununbaina ewen nui en jaibuaibun piama samakexankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ana jatu yusinpakekin miyuiwen yuikin: —En yusianan, tadi bena estediama keskaki. Matu yusinun ninkakanwen. Tadi xeni baxnekea tadi bena tuax estediama mextexun jawen tadi xeni tsamian patsa estei ana baxnekei pikumiski. Jamen matun yusianan, tadi xeni baxnekea keskaki. En yusianwen tsamian keska wakin matun yusian en pewatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Ana jabiaskadi keskawen matu yusinun ninkakanwen. Bichi bishtu xeniki uva jene bena buspudiama manekin mata waxun denex mestenwan jamebi katsai buspui bichi bishtu xeni pexemiski, vino bena inun bichi xeni benuidan. Jabiaskadi wakin en yusian bena matun shinan xeni en jusitidumaki, benukinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jamen vino xeni ma beya wanixun vino bena pepabiaken akatsi ikabuma keska wakin matun beya xeni bechipaikin matun shinan bena wakatsi ikama en yusian bena man danaiin— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Januxun ana juindukunti sábado betsatian xekiwan bai namakis manan baiwen bukin jaki chiti ikabu Jesúsbe bukin xekiwan bimi tsekaxun daxukidi axun pikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","fariseobu jabudi jatube kakin jatu uinkin Jesúski chiti ikabu jatu yukakin: —¿Jawai juindukunti sábadotian man dayai? Sábadotian dayakin Diosun Moisés nuku nemani chibanma man kaneaii— jatu waibu ");
INSERT INTO cbsNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesúsun jatu yuikin: —Bunikin jawada nukun xenipabu pepa Davidin jawen jaibuaibubetan anidan, ¿man uinsmamen? Diosun janchadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Matu yuinun ninkakanwen. Dios kenwanti tadi jiwe medan David jikixun Diosun Moisés yusiniwen taexun Diosbe nukunabu janchaxunikabun besti pitibiaken jawen Dios kenwanti misi Davidin bixun pitan jawen jaibuaibudi pimanikiaki. Jaska wabiaya Dios jaki sinatama iniki, kaneamawen taeadan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","—Jaskaken juindukunti sábadotiandi matun Juchi Kayabi Iyua xanen ibukin en yunuaiwen taea eki chiti ikabundi bunikin pikin kaneabumadiki— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chipu ana sábado betsatian mae betsa anu kaxun jatun ichati jiwe medan jikixun Jesúsun jatu yusianyan jabianudi juni meken yusiudi meyushkini jatube tsauken ");
INSERT INTO cbsNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","januxun jabun jawen yusian danankin Jesús yuanun, iwanan, juindukunti sábadotian ja juni mepeai uinun, ixun, jaska wai uintan unanti watan ja anun ika manai tsauxun ");
INSERT INTO cbsNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","jaskaibu Jesúsun jatun shinan unankin juni meken meyushkini yuikin: —Benikidan ja maniabu namakis niwe— aka jawenabu maniabu namakis benia niken ");
INSERT INTO cbsNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","januxun fariseobu inun Mosésin jancha jatu yusinmisbu Jesúsun jatu yuikin: —En matu yukai jaskadamenkain, ea yuikanwen. Moisin jancha pepa chibankin juindukunti sábadotianan, ¿jaska watimen? ¿pewakin medabewatimen? ¿chakabuwatidaka? ¿yuda betsan jiweadan, paxawakin meketimen? ¿nuitapawakin yamawatidaka?— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","jatun jancha manakin Jesúsun uinbaunaya jawa yuiabumaken juni meken meyushkini nia Jesúsun ana yuikin: —Min meken meshanwen— aka meshanyan jawen meken ma mepekei peaya ");
INSERT INTO cbsNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","uin fariseobu inun yusinananmisbu jaki sinatakin jaska waxun Jesús nematimen ika june yuinamei jaki yubakai taenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Janua xaba betsa badi kaya Jesús ja mesti kai mati mapetan uxama Diosbe janchashini ");
INSERT INTO cbsNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","penaya jaki chiti ikabu dasibi jatu kena beabu 12 besti katutan jatu kenakin: “Man en kushipayabuki”, jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja 12 junibun kena mia yuinun ninkawe. Simón kena betsa wakin Pedro wani inun, jawen betsa Andrés inun, Santiago inun, Juan inun, Felipe inun, Bartolomé inun, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo inun, Tomás inun, Alfeon bake Santiago inun, romano nawabu nichinkatsis imis Simón inun, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagon bake Judas inun, Judas betsa Iscariote anua yumeni chipu jatun Jesús jatu achimaxanaidan, jati Jesúsun katunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","19","Januxun 12 junibu katutan jatu iwei bututan mawa tenanman panpanuxun jaki chiti ikabu Jesúsun yusinun ika tsauken jabianudi jabun chibainbu inun midima yudabu Judea anua inun, Jerusalén anua inun, ianenwan kexa betsa Tiro inun Sidón anua jawen jancha ninkatanun ika bekin isin teneaibu jatu kayawamakatsi iweshinabu jaki dasiabu isin teneaibu xuxawakin yushin chakabun jatu nuitapawai kainmakin jawen kushipa janua kainkin Jesúsun jatu kayawaya uin bechipaikin Jesús mekatsis ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","jatu xuxawakin menetan jaki chiti ikabu besti beiskin jatu jancha wakin: —Tsuabuda yumain matunmebi man kenkunkainama Dios xanen ibukin matu mekekubainxanaiwen taea man benimakunkainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ja inun, tsuabuda jawada pepa besti bechipai chakayamai jawen nuijaidaiwen kupikin Diosun jatu yaniwama keska waxanaiwen taea benimapaketi shinain benimakubainkanikiki. Ja inun, tsuabunda matun chakabu shinain juinti nishma man kaxakatsis imisbuwen taexun Diosun matun juinti shinan chankanwan man benimakunkainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ja inun, matun Juchi Kayabi Iyua tsuabunda man ea chibainbuwen taexun jabun matuki ejen iki danain matu ichakin jatun ichati jiwe anu man ana jikiyamanun matu nemakin matu danainbun man benimakunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jaska inun, Diosun jancha yuixunikabu ichakawanibu keska wakin matudi ichakawaibu nai anuxun Diosun matu duawaxanaiwen taea jawa dateama shinan chankankubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","mapuabudi yuikin: —Jamen matudan, mabuwen jiwei kein “En mabu midima jayaki”, iki tsuabuda natian man jawen benimaii. Jakia uatian man nuitapaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ja inun, tsuabuda yaushikin piti yani bestiwatan man benimakubainaibu ana tsuan matu medabewakin matu duawabuma buni tenei man nuitapajaidaxanaii. Ja inun, natian tsuabunda Dios shinanma matun jamapai besti shinain man usanmis ana jaskama matun juinti nishma kaxai man nuitapajaidaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tsuada ibubis jawawenda jawenduakin dasibibu jatu bechipaimakin man jatu kenwanmatidudan, uindaxankanwen, mesekidan. Jabun Dios yuixunikapaiaibun jatu padan paepawa matun xenipabun jatu kenwanpaunibu keska iyamaxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ana jatu yusinkin: —Man ea ninkaibu matu yusinun ninkakanwen. Matuki sinataibu jatuki sinatama jatuwen nuikubainkanwen. Ja inun, matu danainbu jatu bebis danananma jatu duawakubainkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ja inun, tsuabunda matu ichakawai matuki sinataibun jatu bebis manakunama jau Diosun jatu medabewanun jatu Dios yukaxunkubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ja inun, tsuada miki sinatakin mia detekin ispais aka jabebis sinatai kupinameama: “Uke betsadi ea awe”, ika dabekexunai keskakin shinankubainxankanwen. Ja inun, tsuada min dibiawen taexun min dakukuti tadi mia biankin buaya min tadi manankidiadi yaushiyama jadi inanyuxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jamen tsuada nuitapai juxun min jawada mia yuka medabewakin inanyukubainxankanwen. Jamen betsadan, tsuanda min jawada bushinxun ibu wakin mia ana inankatsi ikamaken jas shinain jaki sinatayamakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jamen betsadan, tsuada miwen nuikin jau mia medabewaxanunbun matun dukun jaska shinankin uinmakin jatu medabewakubainxankanwen, jaska wai nuikipakin man kaneamakidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jaska inun, Diosun jancha danain chakabumisbu jabiaskadiai duanamemisbuki. Jaskaken matudi matun jaibubes man duanamei man jawa binunananmaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ja inun, juni chakabu jabetan chakabu wamisbube nui medabenankubainmisbuki. Jaskaken matudi pepabuwen nui jabu besti medabewai ma pepamadiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jamen betsadan, juni chakabubu duanamekin betsan jawen jaibun jamapai buxun jawaida ana bexunmiswen taexun duawakin jawen jamapai ana yuka inanyukatsis imisbuki. Jaskaken matudi duanamei pepabiai tsuanda matun jamapai jawaida ana matu bexunmis besti man inanmiski, ana manakuti pepa bikatsi shinanmadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jakia pepakatsis ikidan, eskatiki. Matuki sinataibuwen nuikin jatu duawankin matun pepa jatu uinmakubainkanwen. Jaskawen taexun tsuabunda min jamapai biwanshinxun mia ana bexunmisbu besti ana ja shinanma mia yane bexuinsbumadi jatu inandiakin yuda dasibibu jatu duawakubainxankanwen. Jaska wakin man jatu binumamisken matun pepawen Dios dasibi binuatun matu manakuxanikiki, jawen bakebu matu wakinan. Janunkain jabun Dios kenwainsbuma inun juni chakabububiaken betsa betsapa inankin Diosun jatu duawamiswen taea ");
INSERT INTO cbsNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","matun Epa Dios nuikipa keskai nuikipadiakubainkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesúsun ana jatu yusinkin yuikin: —Tsuada ja akin chitekin unanti wayamakanwen. Man jatu jaska wamaken Diosundi jabiaskadi wakin matu chitekin ja akamadi ixanikiki. Ja inun, tsuada jatu dake wayamakanwen. Man jatu dake waismaken Diosundi matu dake wama ixanikiki. Ja inun, tsuabunda matu chakabuwaibu ja shinanma jatu jakimawakin buawe. Man jaska waya Diosundi matun chakabu matu buaxunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ja inun, jawada man jaya paxkaxun juni betsa inankubainkanwen. Jaska wai man yaushiamaken Diosdi matuki yaushiama jabiaskadi matu waxanikiki. Tsuanda man xeki inankin tana pewatan sakuki deukin yaushiama tsinki tsinki akin mata waxun man jatu inanmis keska wakin jabias shinanwendi Diosun matu manakuxanikiki— atan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesúsun miyui betsa tibiwen jatu yusinkin yuikubainkin: —Juni bekunman juni betsa jabe bekun iyupai jadakidi iyuai unanma jabia dabe mikin maebain di idabemisbuki. Jaska keskai matun shinan pewakin mae wadiama jawa jatu yusinkin man pewatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ja inun, jawen tsumabun jatun yusinan binutidubumaki. Jakia jatun yusinan jatu tapinmakubainaya jatun yusinan keska itidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jaskai ikunwain betsa pewakin medabewanun, iwanan, jamapai pese jawen beduki jikia min bikatsis ibiai mina dukun ji ewapa min uianmamen? Ji jidabiwen betimanabia jawa shinanma yuikin: “Uian. Min ji pese beduki ikadan, ¿mia bipa?” akin min yuimiski, kanekinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jakia bemakis bepadamei janchamisbuun, matudi chakabubia betsa chakabuai uinkin man ja amiski. Man ji jidabi betimana tsekaxun puta keska wakin matun juinti medanua matun chakabu ewapa putatan ana kaneama medabewakin ji pese min jaibun bedu anua bia keska wakin juni betsan chakabu bexmas jayadi man medabewakin yusintiduki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ana miyui betsawen Jesúsun jatu yusinkin yuikin: —Ji pepa bimiai jawen bimi chakabuismaki. Jakia ji chakabu bimiai jawen bimi pepaismadiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jaskawen taexun jawen bimi tibiwen ji man unanti wamisbuki. Mae muxa anua higo bimi man tsekaismaki. Ja inun, isne anua uva bimi man tsekaismadiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jabiaska keskadi tsuabuda duapabu juinti pepaya jancha pepawens janchamisbuki. Jamen tsuabuda duapa juinti pepa jaya jawa chakabu jayama yui jancha pepawens janchamisbuki. Ja inun, tsuabuda jatun juinti medan shinan chakabu mata janchakin chakabu yuikin kainmamisbuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesúsun jatu yusinkubainkin yuikin: —Xanen Ibuun, Xanen Ibuun, akin man ea kenabiamis ¿jaskakin en matu yusian man aismamen? ");
INSERT INTO cbsNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","En jancha ikunwankin ea chibanun, iwanan, jawada en yuai akubainxanaibukidi matu yusinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tsuanda mishki jiwe wakatsi ikin jene kexa mai basankin uke medan mishkiki pesaxun ja mamaki mishki tsamabidankin jiwe wadan, en yuiai akubainmisbudan, ja jiwe wanika keskabu ixankanikiki. Janua bai matajaidabidankin jawen jiwe achia ja jiwe mishkiki tsamiawen taea jawa takax iki tsibusketidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jamen jawada en yuiai ea danankin akama ixanaibukidi matu yuinun ninkakanwen. Tsuanda mishki jiwe wanun, iwanan, jene kexa mai basankin kini keyatapawama bexantu bestiwatan mishki tsamabidankin jabebis watan jiwe wadan, ea danainbudan, ja jiwe wanikabia unainsmapabu keskaki. Janua bai matajaidabidankin jawen jiwe achia mishkiki tsamiamawen taea jawaida tsibukei di imiski. ¿Jadatu man jaskamenkain? Uindakanwen— akin Jesúsun jatu yusinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Januxun jatu yusin menetan Cafarnaúm anu Jesús chintuntani jikiken ");
INSERT INTO cbsNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","janua jabianudi romano soldado xanen ibu capitánen dayadu isin tenei mawakatsis ikai bechipaijaidakin ");
INSERT INTO cbsNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesús ma jua ninkatan jau xuxawaxunyunun judio xanen ibu anibubu nichinkin Jesús chanimakin jatu yunua ");
INSERT INTO cbsNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Jesús anu buxun jau xuxawaxuin kanun ea akin yuixunkin: —Capitán juni duapaki. Nukun ichati jiwe nuku jatu amaxunyamaki. Ja inun, nukunabu bechipaijaidadiamiswen taexun medabewakin jawenadi xuxawaxuin kawe— akeakeabu ");
INSERT INTO cbsNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","jatun jancha ninkatan jatube kai ma jawen jiweki kemai kaya jau yuixununbun soldado capitánen jawen jaibuaibudi yunua Jesús juaiki nukuxun capitán yuixunkin: —Xanen Ibuun, en jaibu capitánen jancha en mia yuiai ninkawe. Ewen dabanan en jiwe anu juyamawe. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","En pe bexmasjaidawen taea mianu en kama ixuki. Jaskaken en tsuma jau xuxanun min jancha besti yunukin ea xuxawaxunwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ja inun, jatun ea yunumisdan, eadi en xanen ibu jayaki. Eandi soldadobu yunui en xanen ibudiamiski. Betsa yunukin: “Kawe”, en wa kamiski. Betsa yuikin: “Juwe”, en wa jumiski. En dayadudi yunukin: “Awe”, en wa amiski. Jakia min ea binuawen taexun min jancha bestiwen min xuxawatiduki, en unanan— akin capitán jancha yuixuna ");
INSERT INTO cbsNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesúsun jawen jancha ninkatan soldado capitán ikunjaidawaiwen taea Jesús e itan yudan kaianen chibain jachun beaibukidi nasauketan jatu yuikin: —Jaska na nawa xanen ibun ea ikunjaidawai keska nukunabu Israelbu en jaska jatu uindiamaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","jawen jaibuaibu soldado capitánen jiwe anu chintunbain jawen dayadu ma xuxaxuna uinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","12","Jesúsun jaska wabaini jawen 12 tsumabu kushipayabu inun, jaki chiti ikabu inun, yudan kaianen chibain jabe bukin mae betsa jawen kena Nainkidi kai kemaya ainbu jawen bene mawayamatun jawen bake bestichai mawaxuna maiwanun, iwanan, juni dabetan baketiki beaibu jawenabu jachun bei jawen ewabe kaxakubidanaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús jaki nukutan jawen ewa nuitapaiwen nuikin yuikin: —Kaxama nesewe— atan ");
INSERT INTO cbsNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","bedunan mawa beaibuki Jesús kemaxun jawen baketi besti tsumaya niti itan tsumabun mawa yuikin: —Bedunaan, en mia yuiai bestenwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","mawa jawen tadiwen yabukin mestenjaida wabu jaska peketima bestenkauan natsaua janchai taeaya jawen ewa benimawatan jawen bake nichinxuna iyuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jesúsun jaska wai uin jaska uinsbuma jawen datei mesejaidakin: —Jabaa! Nuku anu Diosun jancha yuixunika pepajaida ma ana taxnishinaki. Jawenabu duawai Dios ana bayuxuki— ikin Dios kenwankubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","jaska Jesúsun axu ninkabain Judea mai pakeanuabu inun mae betsa betsapa anuabundi yuiaibu bana ninka akeakenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nashimanika Juan bichiti jiwe anu jiwea jaska Jesúsun akubainaikidi jawen tsumabu Juanki chanikubainaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ninkatan jawen tsumabu dabe kenaxun jatu yunukin: —Jesús anu kaxun: “Mekenika Diosun nukun xenipabu yubani chanima juxanaidan, ¿min jabiamen? ¿Betsa daka nun manai?” akin ea yukaxuntankanwen— iwanan, jatu yunua ");
INSERT INTO cbsNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","buxun isin betsa betsapa teneaibu xuxawakin yushin chakabu betsa betsapa kainmakin bekun inun bexuxbu uinmakin Jesúsun jatu kaya wapakeaya Nashimanika Juanki chiti ika dabe Jesús anu kaxun jaska wai bechitan atimas jaki nukutan betsan yuikin: —Mianu Nashimanika Juanen nuku yunushinaki. Mekenan Diosun nukun xenipabu yubani chanima juxanaidan, ¿min jabiamen? ¿Min jamadaka? ¿Betsa daka nun manayuai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ja dabe shinanmakin Jesúsun yuikin: —Jawada uinkin man ninkakubainaidan, jaska Juanki chaniditankanwen, eskaibudan. Bekun inun bexuxbun uiainbu inun, jaska mapuisbuma mapuaibu inun, jabu bichiki dasibi chami betsani jaki dakemisbu main sakada iki keyuaibu inun, patabun ninkakin keyuaibu inun, mawa ana besteainbu inun, jabu yumainbu jatun paxati kakape ninkatan benimaibudan, jaska Juan yuitankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tsuanda ea ikunwain jawen shinan chakabui chintuinsmadan, chanima benimaxankanikiki!— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanen jatu yunushina iwani ana chintunbainabun ja dapi mapubaunabu Jesúsun Juankidi jatu yui taewakin: —Janu tsua jiweabumanuadan, ¿jawa man uintantanimamen? Tawa pei niwen bubi bubi wai keska wakin ¿junin jawen shinan betsa betsapa maewa akeakeimamenkain? ");
INSERT INTO cbsNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Jaskamen? ¿Jaskamadaka? ¿Jaskada jakidi kaiain man uintantanimamen? ¿Junin tadi pepa sawea daka? Tadi pepa sawea benimai beyusidan, mabu akunjaidayabu jatun xanen ibun jiwe jawendua anu besti jiwea ikaibu man uintidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jaskakenan, ¿jawa man uintantanimamen? ¿Diosun jancha yuixunikamenkain? Jaki. Juanan, chanima Diosun jancha yuixunikaki. Ja inun, yuixunika betsabu Diosun yununi Juanen ma jatu binuaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ja inun, Diosun jawen bake nichinkatsi Juankidi yuikin: ‘Ninkawe. Janu min kaxanun jau pewai kanun en jancha yuixunika betsa bebunkidi en yunuxanaii, en mia nichindiamadan’, akin jakidi jawen kaka kenenibuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chanima en matu yuiaii. Yuda dasibibun Dios dayaxunkin tsuan Juan binuama ibianibun janu Epa Dios xanen ibuaitian ikunwainbu jaki dasiabu bexmasjaidabiabun Juan binuxankanikiki— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesúsun jancha ninkakin jabun Nashimanika Juanen jancha ninkatan shinan betsa waibu jawen unanti wakin Juanen jatu nashimaimawen taexun yudan kaian inun romanon xanen ibu pei bixunikabun yuikin: “Chanimaki. Jawada Diosun akaidan pepaki”, iwanan, shinan akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","jakia judio fariseobu inun Diosun jancha kenenibu yusinananmisbun Juanen jancha ninkama inun jawen unanti nashimati danainmabuwen taexun Diosun jabudi duawapanan danainmabun ");
INSERT INTO cbsNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesúsun ana jabianudi jatu yuikin: —Nukunabudan, ¿jaskada shinain imisbumenkain? Matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mae namakis jemaintin anu beyuskin jatun ibubu imis mawai bake mishtinbu xuku dabea tsauxun xuku betsan yuikin: “Tepe dewe nun mawabiaya benimai man nawamaki. Janua nun kaxei ikaskin nun nuiti nawa mawabiaya man kaxamaki”, jatu wabu jawawenda beyusti unanbuma keskabuki, nukunabudan. Matun shinan chankanti jubiaken man benimamaki. Jamen matun chakabu shinain kaxakatsi ikama man shinan betsa waismaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Eskaki, matu yuinun ninkakanwen. Ja dukun Nashimanika Juan juxun matu yusinkubainkin misi pepa piama vino paepa akama matube beyusamaken jakidi janchakin: “Yushin chakabu jayaki”, iwanan, man yuia akeakeimaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Janua eadi matun Juchi Kayabi Iyua juxun misi pepa pikin vino paepa aki en matube nawabiakunkainaya ea yuankin: “Uinwen. Pikeki. Paenkin romano pei bixunika chakabubu inun yuda chakabu betsabu jaibu wamiski”, ikin man eadi yuanmiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Jamen nuku dabe nun pepabiaken Diosunabu kayabibu besti unanepakin jabun nukun yusian ninkatan nuku chibankanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","januxun fariseo betsa jawen kena Simón jawen jiwe anuxun Jesús pimakatsi chanima jawen jiwe anu Jesús ka pikatsi ixkexkanan dakai baxti ibaunxun piaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","jabia mae anuadi ainbu jininipan Jesúsun piai ninkatan xeni jene ininipa kadujaida nenkati juxupa bishtuki bexun ");
INSERT INTO cbsNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","june Jesúsun tae dapi danti itan jawen chakabu shinain juinti nishmajaida june kaxakin jawen beun jene besti Jesúsun tae pechiki tuis tuis axun jawen bu chaipawen jutekede atan jawen tae petsu petsu akin keyutan xeni jenewen jawen tae cha akaya Jesúsun unanbiakin uianmaken ");
INSERT INTO cbsNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jesús jatun iatun uintan Jesúskidi shinankin: “Dios nuku yuixunika kayabitunan ja ainbun jawen tae meaidan ainbu chakabukunkainmis unankeanaii”, ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesúsun jawen shinan unantan medabewakin yuikin: —Simóon, ¿jawada mia yuipa?— aka fariseon yuikin: —Ea yuiwe, yusinaan— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","miyuiwen Jesúsun yuikin: —Juni dabetan juni betsa anua pei biyuimabu dibiabuki. Betsan 500 xaba daya pei dibiken betsandi 50 dibiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ja dabetun jania pei bixun pakatidubumaken juni betsan ja dabe pei inanyuima dibiabu jatuwen nuikin ja dabetun dibia jatu kenatan jakimashinaki, ana shinanmadan. Jaskaken ja dabetanan, ¿jadatutun ja jatun pei inanyuima bechipaijaidaimenkain, betsa binunkinan?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","fariseon yuikin: —En shinanan, ja midima jakimawashinatun bechipaijaidaikiki— aka —Chanimaki. Min yui kayabiaii— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús nasauketan ainbu uinkin Simón yuikin: —Na ainbun ea duawaidan, ¿min uiain?— iwanan —Min jiwetan en jikiai jaska wamisbu keska wakin juchukiti unpax min ea tsaunxunama ibiaxuken na ainbun jawen beunwen ea juchuxun jawen buwendi en tae ea jutekede axuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ja inun, ea beya wakin min ea tantsu akamaken mia anu jikia en dakaken na ainbun besti ea beya wakin en tae petsu petsu akin jeneamaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ja inun, ea beya wakin xeni teipa ininjaidawen en bu min ea macha akamaken xeni jene ininjaidawen jatun en tae cha axuki, ea beya wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaskaken ewen nuikin ea bechipaijaidaiwen taexun jawen chakabu midimabiaken ma en buaxuna min unantiduki. Jamen tsuanda chakabu eskadabes nun buaxuna mawaida ea inun en Epa shinankin midinwanmisbuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ainbudi yuikin: —Epa Dios en mia daewaxunxuki, min chakabu mia buaxuntan jau ana shinanyamanunan— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","jabube jatu iabun piaibun ninkatan baxexen yuinamei: —Nadan, ¿jawa juni ikimenkain? yudabun chakabu xunska buaxuntidudan— iwanan, yuia akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","jaskabiabun ainbu Jesúsun ana yuikin: —Min ea ikunwainwen taexun min chakabu min ma bextekei pexuki. Ana jawa dakei dateama unanuma inun kadiwe— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Janua ana betsatian jaska pepawen inun chakabuwen kupi Dios nenu ana xanen ibuxanaikidi mae ewapa betsa betsapa inun mae jatiubuma anuxun Jesúsun jatu yusinkubaunaya jawen 12 tsuma kushipayabun tapin jabe bukubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","ja dikabi ainbu betsa betsapa isin teneaibu xuxawakin yushin chakabu kainmakin Jesúsun jatu medabewakin xuxawaimaken jatun peiwendi Jesús inun jawen tsumabu medabewakubaini María Magdalena anua Jesúsun 7 yushin chakabu kainmaima inun, Susana inun, xanen ibu Herodes yunuxunmis Cuzan ain Juana inun, ainbu betsa betsapabudi Jesús anu butan butankin medabewakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","mae betsa betsapa anua bei Jesús uinkin jawen jancha ninkanun ika ichabidanbidanaibun yudan kaian jaki dasi ichabu Jesúsun jawen jancha juneawen jatu miyuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Juni betsan jawen bai anu xekiwan sa aki kaxun sa akaya jexe betsa kati bai namaki kauana yudabun pema pema akaibu deiwan juxun xea keyuabun janua xekiwan jukuanmaken ");
INSERT INTO cbsNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","jexe betsa mishki ewapabu mania anu mai eskadabes bemanchimea anu bana pexei benekaunaya mai eskadabesken badi jui kukin mai tsusinwan jawen tapun bemakis bewexekea xanai utsimiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ja inun, jexe betsa muxa jukundiama anu nidi ika jukuainki muxan buexekin yabua bimitidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jakia jexe betsa mai pepa anu nidi aka benei bimi ichapajaida jayamiski, betsa 100 jexeyaidan— iwanan, unanxubima yuikin: —Man pabinkiyabuki. Ninkatan jakimayamaxankanwen— jatu wabainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","jawen tsumabu besti Jesúski dasixun jaska miyuiwen jatu yusinxu yukabu ");
INSERT INTO cbsNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","jatu yuikin: —Matudan, jaskai Dios xanen ibumiskidi Diosun jawen pepa juneni xabakabi man en tsumabu matu yusinkin unanmaikiki. Jakia jabun Diosun jancha ninka bestiaibu miyuiwens besti en jatuki chanikunkainaii, uinbiakin jau uin pewayamanunbun inun ninkabiakin jau ninka pewayamanunbunan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Man en tsumabudan, jexe sa akakidi miyui matu xabakabi yuinun ninkaidakanwen. Jexedan, Dioskidi yusinti janchaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jexe betsa janu kati bai anu kauanadan, yudabun Diosun jancha ninkabiaibun jamakidia diablo Satanás juxun jawen jancha pepa jawen juintiki banai mebinmiski, jau ikunwain mekeyamaxanunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ja inun, jexe betsa mishki ewapabu mania anu mai eskadabes bemanchimea anu nidi akadan, tsuanda Diosun jancha ninkakin taewai benimabiaya shinan pewamawen taexun jawen jiwepanan Diosun jancha dananmakin jatu bika wakin jawen jamapaiwen jatu ichakawabu tenei jawawen jaskatima ja uintan ana jawendi chintunbainmisbuki, jatun tacha ichapama keskawen taeadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja inun, jexe betsa muxa anu nidi ikadan, jabun Diosun jancha bechipaibiai jatun jiweawen nui inun mabu betsa betsapawen kemu chakayamai jayakatsis ikin jatun jatu yabua Diosun jancha ninkabiai tapinkatsi ikama unanxubida jenekubainmisbuki, yudabu miban bimiuma keskabuidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jakia jexe betsa mai pepa anu banadan, Diosun jancha pepa tapintan juinti shinan chankankin jeneama mestentan chibankubainkin januxun yuda betsabu yusinkin jatu ikunwanmamisbuki, mai pepa anu jexe sa aka ewai benei pamis keskaidan— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","janua yudan kaian anu ana kaxun Jesúsun miyui betsawen ana jatu yusinkin: —Bin dekutan jamapaiwen bepukin junetima inun tapu naman tsauntima man unaiin. Jakia bin dekuxun jau jawenabu jikikin uinshadanunbun manaundi tsaunmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaskaken jawada en matu yusinkubainai yuda betsabu jatu yusinkin juneyamakubainxankanwen. Jaska inun, jawada junekin man jatu yusianma inun jawada june ibubis man ikaidan, dasibi Diosun jatu xabakabi waxunkin keyuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jaskawen taexunan, ninka peidawakanwen. Jakia tsuabunda en jancha besti ninkakin chibainbu ichapa en ana jatu xabakabi yusinkubainxanaii. Jamen tsuabunda ea chiban kayabismabia: “En ikunwaiin”, ikin jaska besti shinanmis ja eskadabes en jatu mebinxanaii, jakimawakinan— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesúsun jatu yusinkin menediamaken yudan kaian texke ikabuwen taea jawen ewa inun jawen betsabu bea Jesúski jaska kematima ");
INSERT INTO cbsNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","juni betsa yunua yuia akeakebainabu atimas jawen ewa juni betsan Jesús yuixunkin: —Min ewa inun min betsabun unu jemaintinxun mibe janchanun ixun mia kenakanikiaki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","jatu yusinkin Jesúsun yuikin: —Diosun jancha ninkakin akubainmisbudan, jabiabu enabu kayabiki, en ewabu inun, en puibu inun, en betsabudan— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ana betsatian Jesúsun jawen tsumabu jatu yuikin: —Ianenwan besusi pukei kexa betsaudi buyunankanwen— jatu wa jawen tsumabube xaxun inatan xutubaini buaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","janua ianenwan besusi pukeaibun Jesús ma bika xaxu chixukidi daka uxaken janua niwe kushipajaida besubainaibukidia jene buspu tsaubidankin xaxu jene mata wa ma jiki kemaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","datei Jesús anus ichaxun bestenwankin yuikin: —Yusinaan, yusinaan, nun jikiaii— akin bestenwanbu Jesús bestenkauan benitan niwewan inun ianenwan buspu tsaubidanai yuikin: —Nesewe. Peswe— aka niwe main neseaya ianenwandi buspu tsaubidanai main pesaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesúsun jawen tsumabu yuikin: —¿Man jawawen datei ikai, ea shinanmadan?— jatu wa e iki keyutan yuinamekin yuikin: —Jabaa! Na junidan, ¿jawa junimen? min atidumakidan. Niwe inun ianenwanendi ninkakanikikidan— ibaini bui ");
INSERT INTO cbsNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilea ianenwan kexa betsaudi Gerasa mai pakeanu Jesús kai atimas keti itan ");
INSERT INTO cbsNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","xaxu anua butui jatube mapekekainaya janua juni betsa yushin chakabuya unainsmapa tadiuma jiwetan jiweisma janu mawabu maiwamisbu anu besti jiwekunkainmis natian jawenabun mane dispiwen nexabiakubainmisbu yushin chakabun kushipa wa mane dispi nasamis jabun unainsmapa watan janu jiweabumanu iyumis Jesús juai bechibidani kushikidan unantan bis ikidan Jesús naman danti iken ja juni anua yushin chakabu Jesúsun yunukin taewa janua jancha kushipawen yushinen juni unainsmapa yuimakin: —Jesúsuun, min Dios kushipajaidatun bakedan, en mia unaiin. En mia yukai nukudan, kupikin nuku nuitapawayamawe!— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesúsun yukakin: —¿Jadakidi min kena ikai?— aka yushin chakabu ichapa ma juniki jikinibuwen taexun yushinen juni janchama Jesús yuikin: —En kenadan, “Ichapajaida En Jayaki”, en yushin midimayadan— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","janu kupiti mai kini uke medanjaida anu Jesúsun jau jatu yunuyamanun yushin chakabun Jesús nematan ");
INSERT INTO cbsNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ja mati anuxun ina yawa ichapabun pikin mai mixexaibu yushin chakabun bechitan Jesús ea akin yuikin: —Ja ina yawa anu nuku yunuwe, ja medan nun jikinunan— akabu janua Jesúsun jadi jatu yunua ");
INSERT INTO cbsNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ja juni anua kainbaini ina yawa medan jikibainaibun ja ina yawa midima datei mawa butei nidi ibaini ianki pukui dasibi jasai keyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","janua ja ina yawa mekemisbu datei kushibainkin jaskaxu jatun mae anu jiweabu inun bai puchinin jiweabu jatu banabima akekeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","yudan kaianen uin beaibu janu Jesúski nukuxun ja juni: “Yushin chakabu ichapa en jayaki”, ixu ma tadi sawea ana unainsmapa keskama janu Jesúsbe tsaua ana jaska ikunkainshina keska dabanen ikin shinain dateaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","jabun Jesúsun jaska wai uinbaina jatu yui kakaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","janu Gerasa anuabu datekin Jesús nichinkin: —Nukun mae anu ana mapekeama kadiwe— akeakeabu janua Jesúsun jatun jancha ninkatan kai xaxun inai kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ja juni yushin chakabu kainmaxutun Jesús ea akin: —En mibe kaii— aka nemakin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ebe kayamawe. Jakia minabun jiwe anu kaxun jaska Dios miwen nuikin min yushin chakabubu mia kainmaxu minabu yuiditanwen, jau miwen benimadinunbunan— abaini kaya ja junin jaska Jesúsun yushin chakabu midimajaida kainmaxunbainshina jatu yuikubaunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Janua Jesús ianenwan kexa betsaudia chintuntani ana jawendi jui keti ikaya yudan kaianen manajaidaibun Jesús juai bechitan jawen benimai ii jaki ichabu ");
INSERT INTO cbsNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","ichati jiwe anuxun yunumis xanen ibu betsa Jairon Jesús bechitan jukidan ja bebun di iki beutan ea akin yuikin: —En ainbu bake bestichaiyaki, 12 badiyadan. Ma eskatian ea isin tenexuni mawakatsis ikaya miki chani en juxuki. Ebe kaxun uinkin ea xuxawaxunyuwe— atushia janua jaska Jesúsun ninkatan jawen jiwe anu jabe kaya ja yudan kaian ichapabundi itimaska wai supu ibainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","janua ainbu jimi baxneni ja isin tenei ma 12 año kabia jawa neseisma badi betsa tukama ikunkainmisken janua nuitapaya juni dauyan mainwankin xuxawapaibiabu jawen pei dasibi putakin keyubia jawa maianma ikunkainkin yudan kaianbetan Jesús chibain ");
INSERT INTO cbsNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ja ichun kakin jawen tadi kexa metsaya jawaida jawen jimi bextekei maianyan ");
INSERT INTO cbsNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","jaska jawen kushipawen tsuada xuxawa Jesúsun unankin yudan kaian jachun beaibu niti itan uinbaunkin jatu yukakin: —¿Tsuan man en tadi metsaxumen?— jatu wa —Tsuan mia metsamaki— akaibun Pedro inun Jesúsun tsuma betsabun yuikin: —Yusinaan, na yudan kaian bei michun supu ibidankin mia aki ikanikiki. ¿Jaskakin nuku yukakin: “¿Tsuan man en tadi metsai?” min nuku wai ikai?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesúsun jatu yuikin: —Tsuanda ea metsaya chanima en kushipa kainkainkin xuxawaxu en unaiin— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ainbu datei saki saki ikin jani junetima jawada Jesúsun axunxu unain jaki kematan ja bebun danti itan xabakabi ichapabun bedubi Jesúski chaniaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesúsun yuikin: —Ainbuun, min ea ikunwanyan en mia xuxawaxuki. Ana isin teneama unanuma kai pediwe— ");
INSERT INTO cbsNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","aki niken jabiatiandi xanen ibu Jairon jiwe anua jawen tsuma betsa juxun Jairo yuikin: —Min bakedan, ma mawaxuki. Ana juni yusinan daketapa wayamawe— akai ");
INSERT INTO cbsNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesúsun jawen tsumapan Jairo jawada yuiai ninkatan Jairo yuikin: —Dateyamawe. Ea besti min ea ikunwanyan min bake xuxaikiki— abaini ");
INSERT INTO cbsNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","bui Jairon jiwe anu jikikainkin ja mapuabu jau jikiyamanunbun jatu nemakin niti atan Pedro inun Santiago inun Juan inun chipashan ibu dabe jatu jikimakin ");
INSERT INTO cbsNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","junin kaian kaxai sain iki bau bau ikaibu jatu yuikin: —¿Jaskai e iskaun kaxai man biski ikanai? Jawen bakedan mawa kayabiamaki. Uxa bestia ikikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","yuda ichapabun: “Ma mawaki”, iwanan, uintan Jesúsun jaska yuiai ninkatan usainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","januxun Jesúsun chipash metsunxun unanxubima yuikin: —Chipashaan, en mia yuiai beniwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ana bestein samama benikaunaya januxun jau pimanunbun Jesúsun jatu yunuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","jawen ibu dabe benimai e ikaibun jaska Jesúsun axunxu jau tsua yuiyamayununbun jatu nemanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Januxun Jesúsun jawen 12 tsumabu kenaxun jatu ichawatan yushin chakabu betsa betsapa kainmati kushipa inun isin teneaibu jawen xuxawati kushipa jatu inantan ");
INSERT INTO cbsNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","nichinkin yuikin: —Jaska Dios xanen ibuxanaikidi yusinkubaunkin isin teneaibu man xuxawatanun en matu yunuyuaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kaidan, man eskakanintanun matu yuinun ninkakanwen. Mais butankanwen, jawa buamadan. Mestenti betsa inun, kapankan inun, misi inun, pei matun chinexeketiki usua inun, sanpu betsa buyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jaska inun, mae tibi anu buxun yusin jiwe bestichai anu jiweyuxankanwen. Januxun yusinkin menetan mae betsa anudi bukubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jaska inun, janixunda matu danankin ninkakatsi ikabumaken Dios jatuki sinatai unanti wakin janua kainbainkin matun tae anua mai kudu jatuki tabainxankanwen, jau jabiaskasi maninunbunan, jawa unanmadan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","mae tibi anu buake buakexun jaska Dios xanen ibuxanaikidi jatu yusinkin isin teneaibu xuxawakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","janu judiobun xanen ibu Herodesin Jesúsun jawada akeakeaikidi ninkaya betsabun yuikin: —Juan tenanbiashinabu ma ana besteanmenkain— ikaibun betsabundi yuikin: —Elías Diosun jancha yuixunika kabiani jawen yushin damimamenkain— idiaibun betsabundi yuikin: —Nukun xenipabu Diosun jancha yuixunika betsa mawanidan, ma ana besteinmamenkain— ikeakeaibu Herodesin ninkaxun shinain: “¿Jadatu chanima kayabimen?” iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","yuikin: —Juan jau textenunbun ean en jatu yunuimaki. Jaskaken ja Jesúskidi yuiaibudan, ¿tsuamen?— iwanan, Jesús uinun ixun manakubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Janua jawen 12 kushipayabun Jesús anu chintunbidan jaska washinabu Jesúski chani meneabun Jesúsun jawen tsumabu janu tsua jiweabuma Betsaida dapi anu jatu iyuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","yudan kaianen unantan Jesús chibainbu jawa jatuki sinatama jatu ikin pewaxun Dios xanen ibuxanaikidi yusinkin isin betsa betsapa teneaibu xuxawabaiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ma badi kaya jawen 12 tsumabu jawen kushipawen yununikabu Jesús dapi bea ichaxun yuikin: —Ma badi kaikiki. Nenu tsua jiweabumaki. Na yudan kaianen jabun jania pitidubumaki. Jau pitan juindukundi bununbun mae udama anu jatu nichindiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","15","Jesúsun jatu nemakin yuikin: —Jaska jatu wama, matun jatu pimakanwen— jatu wa 5,000 junibu mapuabuwen taea e itan Jesús yuikin: —Meken besti misi inun baka dabe besti nun jayaki. ¿Nun daka jatu piti bixuin kai?— akabu Jesúsun jawen 12 tsumabu yuikin: —Ja basiki 50 tibi xuku akeakea jau tsaununbun jatu yunukanwen— iwanan, Jesúsun jatu yunua jawen tsumabun jatu tsaumakin keyuken ");
INSERT INTO cbsNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","januxun Jesúsun ja misi meken besti inun baka dabe tsumaxun naiudi teskanxun uinkin pitikidi Dios kenwantan misi inun baka tunke tunke apakekin jawen tsumabu inankin jatu yunua ja yudan kaian inanbaunkin keyuabun ");
INSERT INTO cbsNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","dasibibun yaniwai benimai pepeaibun janua ja misi meken besti inun baka dabe 5,000ti junibun pikin texe wabu ichawakin 12 kuki mata wanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Janua betsatian janu tsua jayamanu Jesús jawen tsumabube ka Diosbe janchai menetan Jesúsun jawen tsumabu yukakin: —Yudabunan, ¿en tsua ekidi yuimisbumen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","jabun yuikin: —Betsabun yuikinan: “Nashimanika Juan ana bestenshinaki”, mia wakanikiaki. Betsabundi yuikin: “Diosun jancha yuixunika Elías ana jushianki”, mia wadiakanikiaki. Betsabundi yuikin: “Diosun jancha yuixunika betsa ana besteinmaki”, mia wamisbukiaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","januxun Jesúsun jabudi yukakin: —Jamen matun shinankinan, ¿en tsua man ea wamismen?— jatu wa Pedron yuikin: —Miadan, Diosun yubani min nukun Mesías Cristoki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","januxun Jesúsun jatu nemakin: —En Mesías Cristoki tsua banabimayamayuxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ana jawen tsumabu jatu yusinkin yuikin: —Diosun bake matun Juchi Kayabi Iyuadan, eki sinatakin ea ichakawakin nukun xanen ibubu inun Diosbe nukunabu janchaxunika xanen ibubu inun yusinananmisbun ea danankin ea jatu tenanmabu mawa xaba dabe inun besti kaya en ana bestenxanaii— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","januxun yudan kaian jatu ichawaxun jatu yusinkin yuikin: —Tsuabunda ea chibankatsis iki ibubis jawenakidi jaska shinanmis jau ana jaska shinanyamakubainunbunwen. Jaska inun, “Bika tenei Jesúswen jawa dakeama ja keskai en jabe mawatiduki”, jau ikubainunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jamen tsuabuda jatunmebi mekei: “En mawakatsi ikamaki”, ikin shinanmisbudan, eauma mawaxankanikiki. Jakia ea ikunwankin en kakape yuikin ea chibainwen taexun tenanbu ebe jiwekuinxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ja inun, mabu midimawen kemukin ichawaxun ea ikunwankin chibanbuma jatunmebi jatun jiwekuian benuxankanikiki, eauma mawakinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jaskaken tsuabuda eki inun en janchaki dakemisbudan, en Epan kushipaya jawen nai tsuma pepabube jua jabiaskadiai en jatuki dakediaxanaii— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Chanima en matu yuiai ninkakanwen. Betsabu na jabia man mapuabudan, man mawadiamaken Dios kushipajaidai xanen ibui taeai man uinxanaii— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Janua janchashina 8 día xaba kasmai jatida kaya Pedro inun Santiago inun Juan Jesúsun jatu iyui kai Diosbe janchanun ika kakin mati keyatapajaida jatube mapeketan ");
INSERT INTO cbsNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","janua Jesús Diosbe janchaya ma besu betsai damia jawen tadi juxupajaidai chaxa chaxa ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Elías inun Moisés jabiaskadiai ja dabedi chaxajaida punte punte iki mapuxun jaska Jerusalén anua Jesús mawaxanai yui jabe janchaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro inun Santiago inun Juan yuda datsupe ika uxakatsis ibia uxama Jesús inun ja dabe jabe mapuabu uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ja dabetan Jesús ma dapaxkabainaibun xabakabi shinanma Pedron Jesús yuikin: —Yusinaan, nun nenu juadan, pejaidaki. ¿Pean xubu dabe inun besti matu waxunpa, betsa mina inun, betsa Moisésna inun betsadi Elíasinadan?— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","35","janua nai kuin bekin jatu bepuaya dateaibun nai kuin anuxun jatu yuikin: —Na en bake en Katunidan, ninkaidakubainkanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","jakimamadi samama bedu bedu ikin Jesús besti nia uinibukiaki. Januxun jaska june uinbidanimaxun tsua yuiyama iyukubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mati anua Jesús damia uintan jabianu niti ika jatube uxashini penaya butubidanaibun Jesúski dasitanun ika yudan kaian jaki nukui buaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","januxun juni betsa jatu nashui ikaina nixun jui kushipawen unanxubima Jesús yuikin: —Yusinaan, en juni bake bestichaiyaki. Ea uinxunwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yushinin achixun bis bis imakin duxku imakin kemu bus bus imakin ichakawakin jeneismaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jaskamisken: “Jau yushin chakabu ea kainmaxununbun ika”, min tsumabu en jatu shinanbiabidana tsuan jawa ea kainmaxuntidubumaki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesúsun mapuabu dasibi yuikin: —Ikunwainsbuma inun chakabubuun, ¿jatiki matu medabewai ana en matube jiweyuxanai?— iwanan, ja juni yuikin: —Min bake uinun nedi iwewe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","iweaya yushin chakabun Jesús bechitan ja juni bake duxku imakin main tin imatan taka taka imaya Jesúsun uinkin yushin kunyan akin kainmaxuntan jawen epa yunuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Diosun pepa kushipawen Jesúsun jatu uinmakubainaiwen taea dasibi e iki Jabaa! ike ikeaibun janua Jabaa! iki mapuabun jawen tsumabu besti Jesúsun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Eska en matu yuiai ninkatan jakimayamaxankanwen. Ea en matun Juchi Kayabi Iyuadan, tsuanda ea jatu achimaxanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","jaska Jesúsun jatu yuixu jau ninkayamanunbun Diosun jatu nemaiwen taexun jawa ninkamajaida jawa yuiai dabanen datekin Jesús jawa ana yukama inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Janua Jesúsun tsumabu yuinamei: —Jesúsbe xanen ibukin ¿nukunan, jadatubun betsabu nun matu binunxanimenkain? ¿Eamenkain?— ibidankanxu ");
INSERT INTO cbsNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","unantan jatu yusinun, iwanan, bakeishta betsa ixun ");
INSERT INTO cbsNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","jatu yuikin: —Ea duawanun, iwanan, na bakeishta keska wakin tsuada en kenaya juaidan, ikin ea akawakin man duawatiduki. Jabiaskadi wakin ea besti duawama jatun ea yununi Diosdi jabun duawaxankanikiki. Jaskaken tsuada jawa shinanma keanma dasibibu medabewakin ja kenmisbu jatu binuxankanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","januxun Juanen Jesús yuikin: —Yusinaan, juni betsan min kena kushipa paewen yushin chakabu kainmai nun uinbidanshinaki. Nukubetan mia chibanmaken nun nemakin bextepaibia nuku ninkama ishianki. Jaska wakin nun nemashinadan, ¿pemen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesúsun Juan yuikin: —Nemakin man jatu bextetidumaki. Tsuada nukuki sinatamadan, nuku medabewaikiki— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Janua jawen Epa anu Jesús kaxanai kemaya dateama Jerusalén anu kai taekin ");
INSERT INTO cbsNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","janu uxati jiwe jau unanti watanunbun jawen jancha yuixunika bebunkidi jatu yunua bui Samarianawabun mae anu jikixun yukabu ");
INSERT INTO cbsNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jerusalén anu Jesús kaiwen taea janu jau uxayamanunbun jatu danankanxu chanitushiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Santiago inun Juanen ninkaxun Jesús yuikin: —Yusinaan, jaska Elíasin ani keska wakin ¿nai anua chi kauankin jau Diosun ja mae jatu yamawakin keyunun Dios yukapa?— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús sinaxun jatu kunyan akin nemabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mae betsa anu uxanun ika bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ana Jerusalénkidi bui bai tanabainaibun juni betsan Jesús yuikin: —Yusinaan, janida min kai en mia chibankatsis ikaii. ¿Mibe kapa?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","jawen juinti pepamenkain, unanun, iwanan, Jesúsun yuikin: —Kaman inu jawen kini jayaki. Peiyabu jawen na jayabuki. Jakia matun Juchi Kayabi Iyua ean en yusinkubainmiswen taea janu uxati jiwe en jayamaki. ¿Ea keskai min jiwekunkaintidumen?— akin ");
INSERT INTO cbsNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","juni betsadi Jesúsun yuikin: —Tapinkin ea chibankubainwen— aka —Xanen Ibuun, ea jeneyuwe, ja dukun en epa mawa maiwatan en mia chipu chibanxanaidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","nemakin Jesúsun yuikin: —Jaskamaki. Ikunwanma mawa keskabun min epa maiwatidubuki. Jakia mianan, na jabiatian ebe kai taekin Dios xanen ibuxanaikidi yusinkubainxanwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","januxun betsandi Jesús yuikin: —Yusinaan, eandi en mia chibankatsi ¿ja dukun en jiweanua enabuki chaniyutanpa?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","nemakin Jesúsun yuikin: —Tsuabunda ea chibanbiakin jawen shinan dabewen unudi shinain inun unudi uiainan, jaska Dios xanen ibuxanai pe dayaxuntidubumaki— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Januxun mae tibi anu janu Jesús chipu kaxanai anu jau bebunkidi yusintanunbun 72 juni jaki chiti ikabu katuxun juni dabe tibi jatu yunua akeakekin ");
INSERT INTO cbsNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","jatu yuikin: —En tsumabun en jancha ikunwankin chibanmisbun jatu yusian akeakebaunaibun ichapabun ea ikunwanxankanikiki. Jaskaken chanima Diosun bai anu miban midima ma jushin keyui keska dakaki. Jakia jawen dayakapabu eskadabeswen taexun ana dayakapabu ichapa jau yununun bai ibu Dios ana yukakanwen, jawen yunu tsekakin ichawaxunai keska wakin yudabu jau jawen jancha jatu yusinbaununbunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eanan, kaman inu pubenbu anu chaxuwan bake yunua keska wakin man en tsuma pepabu matuki sinataxanaibu anu en matu yunuai yusinditankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Man jaskabaintanunbun matu yusinun ninkakanwen. Mais butankanwen. Jaki mabu aduti kapankan buama jaki pei aduti matun chinexeketiki usua nuxatiya buama inun matun bichi tae betsa buyamakanwen. Jaska inun, bai tanabaini tsukida nukutan jabe janchai niti ikama dainbainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ja inun, mae anu jikitan tsuanuda jiweyukatsi iki jatun jiwe anu jikitan jatu yuikin: “Diosun jau matu unanuma jiwemakubainunwen”, jatu axankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Man jaska wa yuda duapa janu jiweabu matun janchawen benimaxankanikiki. Jakia yuda duapa janu jiweama matun jancha danainbun matun duapa jancha ana jatu mebinbainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ja inun, jani mae anuxunda matu beya waibu anu janu jiweyuxankanwen. Dayakapabu pakamisbu keska wakin matu pimakin mabex amakin jawada matu inanbu jabianuxundi piyuxankanwen, jiwe betsa tibi anua piti benabaunamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Janida mae anu man jikia matu beya waibu anuxun jawada piti matu inanbu piyuxankanwen, dananmadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ja inun, jabianu jiweabu isin teneaibu xuxawakin jatu yusinkin: “Dios xanen ibui nenu ma kemaikiki”, akin jatu yuikubaunxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jakia janida mae anu jikitan man jatu yusian danainbu jatun bai namakixun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Dios matuki sinatai man unanun matun jemaintin anua matun mai mishpudi buama nun jutakai jushukidi ikainaii. Jakia matu duawayui Dios xanen ibui ma kemabiaya jawen jancha man danain uindaxankanwen”, akin jatu yuixankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jamen betsadan, janu Diosun yudabu dasibi jatu kupiaitian jaska Sodoma chiwen Diosun jatu kupikin jaska wani binumakin jabun matu dananibu Diosun jatu kupijaidaxanikiki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","jatidi betsabu mapuabu ana jatu yuikin: —Corazín inun Betsaida anu man jiweabu matun chakabu jenetan man shinan betsa wakatsi ikamadan, man nuitapajaidaxankanaii. Jakia Corazín inun Betsaida anuxun jawen unanti dami kushipa betsa betsapa en matu uinmakubainima keska Tiro inun Sidón anu jiweabundi jabiaskadi uintan jatun chakabu jenenun, iwanan, juinti nishmajaidatan saku wati tadi bexa xeni sawetan chi mapuwen mapu tukutan jatun shinan betsa watan Dios ikunwankeanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jaskawen taexun janu kupiaitian ja nawabu Tiro inun Sidón anu jiweabu jatu kupi midinkin Corazín inun Betsaida anu man jiweabudi shinan betsa wabuma Diosun jatu kupijaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ja inun, Cafarnaúm anu jiweabun man shinankin: “Nun pepabuwen taexun Diosun nuku kenwanxanikiki”, ibiakin man ea ikunwanbumawen taexun janu chi nukaisma anu Diosun matu yunuxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","jabun chibainbu betsabu yuikin: —Tsuabuda en jancha man jatu yusianyan matu ninkakin eadi ninkaxankanikiki. Jamen tsuabunda matun jancha danankin enadi danandiaxankanikiki. Ja inun, ea danankin jatun ea yununidi danandiaxankanikiki— jatu watan nichian bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesúsun jatu yunuima yusinkin jatu xuxawakubauntani shinan chankanyanbi benimajaidakubidani jikibidanbidani ja 72 junibu Jesús anu ichai keyutan yuikin: —Yusinaan, isin teneaibu xuxawakin min kushipawen inun min kenawen taexun yushin chakabundi nun yunua ninkatan kaindiakubainshinabuki. Jaska watani jui nun benimajaidakunkidanaii— akeakeabu ");
INSERT INTO cbsNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesúsun jatu yuikin: —Yushin chakabubu man jatu kainmakubaunaibun Satanás kushipabiaken Diosun jawen kushipa mebian nai anua kana bakai mai anu tin ikai keskai Satanás babutan kauanai en uinshinaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ninkakanwen. En kushipa en matu inankin yunuimaki, jau tsuan matu meyamakubainxanunbunan. Dunuki man paia matu pia jawa man isin tenetidumaki. Ja inun, nibuki man paia matu pia jawa man isin tenetidumadiki. Ja inun, Satanásan binukin matu jawa maematidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jaska man washina peki. Jaskabia yushin man kainmashinawen besti benimayamakanwen. Jakia nai anu Diosbe man jiwexanaibu Diosun matun kena tibi ma keneniwen taea jaska bestiwen benimakubainkanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","januxun Diosun Yushin Pepatun Jesús benimawakin shinan chankanwan Jesúsun kenwankin yuikin: —Epaan, nai inun mai jidabi minaski. Min duapa jancha ja unanepai kenmisbu min jatu unanmama jabu keinsbuma besti min jatu unanmakubainaiwen taexun en mia kenwaiin— atan ");
INSERT INTO cbsNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","mapubaunabu yuikin: —En Epan jawen kushipa dasibi ea yununidan, tsuan en jawen bake ea unanbumaki. Jakia en Epan besti ea unan keyuikiki. Jakia tsuan en Epa unanmadiki. Ea jawen baken besti en Epa en unan keyudiaii. Jakia jabun ea chibainbu en Epa en jatu unanmamiski— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","jawen tsumabukidi dabekexun jatu besti yuikin: —Matu yuinun ninkakanwen. Ea en matun medabenan man uiainan, nukun xenipabu Diosun jancha yuixunikabu inun xanen ibubun uinpaibiakin ea uianma inibuki. Ja inun, na man ea uiainan, uinkatsi ibiakin ea uianma inibuki. Ja inun, jabias man ninkaidan, ninkapaibiakin ea ninkamadi inibuki. Jaskaken jabias man uiainan, tsuabunda uindiai benimakanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","mapuxun ninkaibun Moisin keneni yusinananmistun Jesús unanti wanun ika benikauan yukakin: —Yusinaan, jiwea kayabi bikatsi ikin Dios benimawakin ¿jaska waxanpa?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesúsundi yukakin: —Moisin kenenidan uinkin ¿jawa min yuimismen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","yusinmistun Jesús yuikin: —Eska nuku kenexuniki: “Matun shinan jidabiwen inun, matun kushipa jidabiwen inun, matun yuda jidabiwen matun Xanen Ibu Dios duawakubainkanwen. Ja inun, min jabube jiweabu duawadiakubainkanwen, ibubis man nui mekemis keskaidan”, nuku waniki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesúsun yuikin: —Min pe yuiaii. Jaska min yuiai keska akubaini Dios anu min jiwea kayabi ixanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ibubis penun ixun Jesús yukakin: —En jabube jiweadan, ¿tsuabumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","unanmakin miyuiwen Jesúsun yuikin: —Jerusalén anua juni betsa kai Jericó bai tanabainai juni yumetsubun jawen mabu binun, iwanan, kusha kusha axun dasibi jawen mabu biantan jenebainabun shinanea dakaken ");
INSERT INTO cbsNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","janua Diosbe nukunabu janchaxunika betsa jawa shinanma jui jabias bai tanabidankin juni kushabainabu daka bechitan jawen nui jaki kemakatsi ikama benantaxun besti uintan dunkebainken ");
INSERT INTO cbsNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","janua Dios kenwanti jiwe anuxun jatu medabewai dayamis Levín baba betsa jabias baiwendi jukin bechitan jawen nuiamadi dunkediabainken ");
INSERT INTO cbsNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ja Samarianawabube danananain man dakekenanmis betsa jabias baiwen jukin matunabu betsa kushabainabu daka bechitushitan jawen dabanan iki niti itan ");
INSERT INTO cbsNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ja juni detebainabu jawen nui jaki kematan jawen dete piti xeniwen inun vinowen dapuxxun neatan jawen burroki katsauntan janu chaikea bei uxamisbu anu iyuxun duawakin mekeshini ");
INSERT INTO cbsNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","penaya kakin jawen pei aduti saku anua pei ewapa dabe bixun jiwe ibu inankin yuikin: “En ma kai na juni ea duawaxunkubainxanwen. Na pei keyuken ana kauankin jawen texe ana en mia pakayuxanaii”, abainimaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Diosun jancha kenenibu yusinananmis Jesúsun yukakin: —Ja juni dabe inun bestidan, ¿ja juni kushabainabu jadatu jawen nuikin jabube jiwea keskakin duawaimamen? Min shinanan, ea yuiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","yusinmistun Jesús yuikin: —Ja juni jawen nuimaki— aka januxun Jesúsun yuikin: —Miadi jabiaskadi ikunkainwen— abaini ");
INSERT INTO cbsNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","janua ana jawen tsumabube kakunkaini mae betsa anu Jesús jikiaya ainbu betsa Martan jawen jiwe anu iwana ");
INSERT INTO cbsNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","januxun jawenabu yusianyan jawen betsa María Jesúsun tae dapi tsauxun ninkaya ");
INSERT INTO cbsNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martan piti ichapa bawai ja mesti bikakin jaskawen dabanan Jesús yuikin: —Xanen Ibuun, mia pimanun ika en mesti bawai en daya chakayamaya en betsan ea medabewamaki. Jaskaken ewen nuikin ea yunuxunwen, jau ea medabewanunan— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesúsun Marta nemakin yuikin: —Martaan, Martaan, dayakin piti nuku bawaxunkin min jiwe nuku pewaxuni pebiai min juinti ma sinaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ea duawaidan, jaskatimaki. Jakia Marían en yusian ninkakin ea duawai tsuan nematidumaki— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ana betsatian Jesús ka Diosbe janchai meneaya jawen tsuma betsan ea akin yukakin: —Xanen Ibuun, jaska Juanen jaki chiti ikabu yusinma keska wakin Diosbe janchai jadakidi itimenkain nuku yusinwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesúsun jatu yuikin: —Diosbe janchakin yuikinan eska watiki: ‘Epaan, min kena medibidan, mia duawakin jau mia kenwankubainunbunwen. Nai anua xanen ibukin min yunua jaska chibanmisbu keska wakin nenuxundi nun mia chibankatsis ikaibu min shinan besti nuku chibanmakin nuku medabewakubainwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ja inun, nuku mekekin na jabiatian jaska min nuku axuain nun piyunun piti nuku inankubainwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ja inun, tsuabunda nuku chakabuwaibu jatu jakimawakin jatun chakabu nun ana jaska shinanmawen taexun nun mia chakabuwai buaxuntan ana jaskakidi nuku shinanmayamawe. Ja inun, nun kaneyamanunbun jawada nun jawen kemumis kainyain nuku nemaxunkubainwen’, atiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","miyuiwen ana jatu xabakabi yusinkin: —Matubudan, man jaibu tibiyaki. Yamenapun min jaibun jiwe anu kaxun kenakin: “Xexei, xexei, ¿min uxamen?” min wa “¿Jawamen?” ikaya “Nukun jaibu eki bai juxu en jawa pimatimaki. Misi dabe inun besti ea inanyuwe”, min wa ");
INSERT INTO cbsNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","jawen jiwe medanxun mia nemakin yuikin: “Ma en bakebube inakin beputi en bexeaki. Jaska butukain en mia inantimaki. Ea chikish wama kadiwe”, mia wabia ");
INSERT INTO cbsNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","min jawen jaibuwen taea chikishkin mia inankatsi ikama ibiaya ninkamas daketapa wakin min yuka jeneamawen taexun butuxun jawada min bikatsis ikai mia inantiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Jaska wakin tsuanda Dios yukakin ea akadan, jawen jawada inanmiski. Tsuanda jawada benakin Dios yukadan, jaki nukumamiski. Tsuanda jawada bi jikinun ixun Dios kenadan, bepenxunmiski. Jawada min yuka mia axuntiduki. Benakin jawada min yuka mia bechimaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ja inun, betsadan, min baken baka mia ea aka jaki dakekin dunu man inainsmaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ja inun, takada bachi mia ea aka jaki dakekin nibu man inainsmadiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jaskaken man pepamabia matun bakebu man duawamis man unaiin. Jamen jaska binumakin Epa Dios nai anuatun man tsuabunda yukai ninkatan jawen Yushin Pepa matu inanmiski— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana betsatian yushin chakabun juni betsa juyu wayama Jesúsun nichian kainkainaya juni ana janchai taeaya yudan kaianen uin yuinamei: “Jabaa! Nadan, juni kushipa pejaidaki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","jakia jatiditun yuikin: —Na junidan, yushin chakabu xanen ibu Beelzebún kushipa jayaki. Jaska bestiwen taexun yushin chakabu jatu kainmaikiki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","betsabun Jesús unanti wanun, ixun Jesús yuikin: —Dios anua jawen unanti dami nuku axunwen, min jawen kushipa jaya nun uinunan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","jatun shinanen kaneaibu unankin Jesúsun jatu yuikin: —Mae betsa anu jatunmebi paxkatan detenamei jatunmebi debui keyumisbuki. Ja inun, jabias yudabu paxkai jatunmebi jenenamei yamai keyudiatidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jabiaskadi wakin Satanásan jawenabu yudabu anua kainma jawen yuda punu nukai babui keyukeanaii. Ja inun, Beelzebún kushipa en jaya jawenabu en kainmama ikeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jamen eanan, Beelzebún kushipawen en yushin chakabu kainmaya matun tsumabunan, ¿tsuan kushipawen yushin chakabu kainmakanimenkain? Jaskaken man kanejaidai jabun matu chitekin ja axanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jamen chanima Diosun kushipawen ean en yushin chakabu kainmamiswen taea Dios matuki bai ma juaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jaskakin man kanejaidai matu yuinun ninkakanwen. Juni kushipa jawen pia inun jawen kushatiyatun jawen mae pe mekeaya tsua jikikain yumetsutidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jakia juni betsa ja binuan juxun maemakin jawen yuda junekin mekemis inun jawen pia inun jawen kushati mebinxun jawen jamapai ibu watan jawen jaibuaibu inanbaunmiski. Eanan, Beelzebú binukin jawen kushipa jatuwen dayai mebintan ena en watiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","En jaskaken tsuanda ea jaibuwama ea nemaikiki. Ja inun, tsuanda juni betsabu ea chibanmama jatu eki dakemamisbuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","miyui betsawen jatu yuikin: —Juni betsa anua yushin chakabu kainma kai juindukunkatsi iki janu unpax jayama anu kakunkaunkin janu juindukunti pepa bechiama shinankin: ");
INSERT INTO cbsNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“En janu jiwea en kainkidanshina anu en ana chintunkainaii”, ikaini kaxun ja yuda medan jiwe xaka matsua keska jawa jayama bechitan ");
INSERT INTO cbsNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","kaxun ana 7 yushin betsa chakabujaida jatube dasikidan, ja dukuntun ja yuda ichakawakin midinwaima ana binumakin pikujaidamisbuki— ikin ");
INSERT INTO cbsNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesúsun jatu yuikin menediama yudan kaian nashui ixun jancha kushipawen ainbun yuikin: —Min ewa mia kainxun mia chuchu amaniwen taea benimajaidaikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesúsun ainbu yuikin: —Chanima jabiaskaki. Jakia tsuabunda Diosun jancha ninkakin chibanmisbun en ewa binui ana benimajaidakanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","janua ana jaki yudan kaian ichabidanbidani mapubaunaibun Jesúsun jatu yuikin: —Nukunabu na jabiatian man jiweabudan, man chakabuki. Jamapai Dios anua unanti tsuan atiduma uinkatsi man ea yukabiamisdan, Diosun Jonás bakawan xeamashina ana kainma jiwenidan, jaska keska besti Diosun matu uinmakin matu axundiaxanikiki. Shinankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nínive maewan anu kaxun jau jatu yusintanun Diosun Jonás yunua ninkama mae betsa anu paxai xaxuwen kai ianenwan medan jasa bakawan ewapatun xea xaba dabe inun besti ka janan Jonás ana besteanwen taexun Nínive anuabun unankin jatun shinan betsa watan Dios kenwanibukiaki. Jamen eadan, matun Juchi Kayabi Iyua mawa en jabiaskadiaya bestibu man ea ikunwanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jaska inun, betsadan, nawa ainbu xanen ibu surkidi chaijaida Sabá maiwan anu jiwea nukun xenipabu Salomónen jancha unanepa ninkatanun ika juniki. Salomón en binujaidabiaken man ea ninkakatsi ikabumawen taexun janu matu kupiaitian ja nawa ainbu xanen ibun matu ja achakayamaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ja inun, Nínive anuabu Jonásin Dioskidi jatu yusian ninkakin jatun shinan betsa watan Dios ikunwanibuki. Jamen eanan, en Jonás binujaidabiaken tsuan man ea ninkakin matun shinan man betsa wakatsi ikamawen taexun janu kupiaitian Nínive anu jiwenibundi matu ja adiaxankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ana jatu yusinkin: —Bin dekuxun june anu tsauinsbuma inun ji bauwen achimaisbumaki. Jakia jikikin jau uinunbun dekuxun manaundi tsaunmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jaska keskadi matun yuda anudan, matun bedudan, bin chaxa keskaki. Jaskakidi matu yusinun ninkakanwen. Matun beduwen man uinmiski. Matun shinanwen matun yuda pepa jaya kemuama man xabakabi meke pewaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jakia man bin jayadan, man meshu medan jiwea keskatidubumaki. Uindakubainkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jamen tsuabuda Diosun mekea bin chaxa keskawen chakabuuma man pe besti shinanxanaii, kaneamadan— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","janua Jesús janchai meneaya fariseo betsan pimakatsi jawen jiwe anu iyua Jesús jikikain tapu dapi tsauxun piaya ");
INSERT INTO cbsNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","fariseon uin metsayamas katan yuikin: —Nukun xenipabun beya chibankin ¿pidiama min mepanuamamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesúsun yuikin: —Fariseobun man shinanmiskidi mia yuinun ninkawe. Matun beya chibankin matun kencha tibi bemakis besti dachukin man napan pewamisbuki. Jakia yumetsukin jamapai chakabuwatan uke medanua matun shinan man pewaisbumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Man unainsmapabuki. Bemakia jawada man uintidu chukakin man pewabiamis matun juinti uke medan chakabubiaken man unainsmaki. Matun meken man uintidu inun jawada uke medan man jaya jabias Diosun damiwaniki. Shinaindakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ja inun, ja dukun matun shinan pewatan Dios duawakatsi ikin yaushiama nuitapaibu inankuin man pepakunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fariseobuun, man peidawa! Matunan, man kanekubainmisbuki. Matun piti nis wati ichawaxun maspu meken dabeti waxun bestichai Dios kenwanti jiwe anu dayanikabu medabewakin man jatu inankuinmiski. Jaska pewabiai jaska Diosun jancha Moisin yusini man shinanma jawada jawen pepawati inun jawen nuiti inun jawen jancha betsa watima yunubianiken matubu jawen jiwekin man jatu uinmaismaki, kanekinan. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Fariseobuun, matudan, matun ichati jiwe anu jikikain jaki tsauti pepa janu dasibibun matu uintidubu anu man tsaukatsis imisbuki. Ja inun, bai tanai nia jau ea duawanunbun, ika kemutapa man nimiski. Man jaskaya Dios matuki sinatamis man nuitapaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Matudan, man bepadamemisbuki. Matunabu yusin chakakin jatu padankin man jatu kanemakubainmisbuki, tsuada mawa nitimabiaken maiwanibu unanma jamamaki jaki paia keskakinan— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","jawen janchaki sinatakin Moisin keneni yusinananmis betsan Jesús yuikin: —Jabaa! Yusinaan, jaska yuikin nukudi min nuku chiteaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesúsun yuikin: —Moisin jancha yusinananmisbuun, matudan, fariseobu keskai matudi man peidawa! Xankamajaida matunabu iama keska wakin yusian tsuan chibantidubuma man jatu yusinbiakin jaska man jatu yusinmis ibubis chibanma janua man jatu medabewaismadiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Matudan, man dakeisbumaki. Matun xenipabun Diosun jancha yuixunikabun yusiainbu danankin jatu tenanxun maiwanibu jaska besti shinankin matun xenipabun ani medabewakin matundi jabias jawen shinanti jiwe jawendua besti man wamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jaskawen taexun Dios unanepatun yuikin: ‘Ea jatu yuixunikabu inun en tsuma kushipayabun jau jatu yusinunbun en jatu yunupakea jatu danankin betsabu tenankin betsabu ichakawakin jatu nichinxankanikiki’, iniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Matun xenipabun jatu dananpauni keska shinankin Diosun jancha yuixunikabu man danandiamisbuki, na jabiatianan. Jabias shinanwen Diosun matu manakudiaxanikiki. Jaskawen taexun mai damiwakin taewani anua jatun Adánen bake Abel tenani inun Dios kenwanti chi tapu inun jawen kenwanti Templo namakisxun Diosun jancha yuixunika Zacarías detenibu inun dasibibun Diosun jancha yuixunika betsa tibi matun xenipabun tenanpaunibuwen taea ja shinanwen Dios jakimamawen taexun na jabiatian jiweabube man keainbu Diosun matu kupijaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Diosun jancha kenenibu yusinananmisbuun, man peidawa! Diosun jancha jawen jiweti unanbiai ninka pewama tsuabuda Dios xanen ibuai anu jikikatsi ikaibu man jatu nemamiski. Matudi man jikitidumabia jabu betsabu jikipananbun man jatu nemakubainaii— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","yusinananmisbu inun fariseobun jawen jancha ninkai Jesúski sinatakin ibubis kanemanun iwanan, padanpaikin jawen yusiankidi jaikaimas jamapai yukanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Januxun Jesús jaska waibun ana midimajaida jaki ichabu jani ni pexun ninkatidubumabia ninkaibun Jesúsun jaki chiti ikabus dukun yusin taewakin yuikin: —Fariseobu yusinanain bepadamemisbu misi xaxa wati keskabuki. Jatun yusian matuki jikitan matu kanematiduki. Jatun yusian uindakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jawada jabun june akubainmisbudan, ana juneama xabakabi dasibibun unanxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Januxun jawada dasibibun yui meshu medan nua keska junea janchamisbu xaba keska anuxun ana juneama xabakabi ninkaxankanikiki. Ja inun, dintu medan jikitan beputi beputan jamapai junexun yuimisbu jemaintin anua jancha kushipawen chaniai keska ninkaxankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ana betsa jaki chiti ikabu yuikin: —En jaibuaibuun, ana matu yuinun ninkakanwen. Tsuabunda matun yuda besti tenantidubuwen dateyamakanwen, tenanxun matu ana ichakawapaketidubumakidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jakia jaki besti mesei man datekubainunbun matu yuinun ninkakanwen. Tsuanda matun jiwea tenantan chi nukaismanu jawen kushipawen matu yunutidu bestiki mesei datekubainkanwen, Dioskidan. Chanima en matu yuiaidan, ja bestiki datei mesekubainkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Jaska inun, isa mishtin meken besti bikin pei jexe pishta dabeswen bitidubuki, kadumadan. Jabiaskabiaken isa tibi tanai Dios jakimaismaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jamen matun bu dasibi midimabiaken Diosun ma tana keyumistun isa mishtin ichapa bechipaibiakin Diosun isa mishtin binumakin matu bechipaijaidamiski. Jaskaken jawaki dateyamakubainkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ana jatu yusinkin: —Tsuabunda ea ikunwain dakeama ea datan akin yudabu jatu yuikin: “En Jesúsunaki”, ikubainmisbu eandi Diosun nai tsumabu bebun nixun mekekin: “Nadan, enabuki”, akin en jatu yuixunxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jakia tsuabunda ea chibanma en janchaki dakei: “En Jesús ikunwanmaki”, eki ikubainmisbudan, eadi Diosun nai tsumabu bebunxun: “Nadan, enabumaki”, akin en jatu janchaxunamadi ixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jamen tsuabunda en matun Juchi Kayabi Iyua ea yuanbiaibun Diosun jatun chakabu buaxuntiduki. Jamen betsadan, tsuabunda Diosun Yushin Pepa yuainbu jatun chakabu Diosun buaismaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jaska inun, matuki sinatakin jau matu kupinunbun jatun ichati jiwe anu kasmai xanen ibu betsa anu kasmai matu iyuxun jatun xanen ibubu anu matu nichianbu: “¿Jadakidi yuixanpa?” iki dateyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Matu jaska waibu jabiatian matu janchamakin Diosun Yushin Pepatun matu unanmakin jaska matu janchamaxanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","januxun mapuabu anuxun juni betsan jau Jesúsun ea medabewanun ixun yuikin: —Yusinaan, en ibu mawashinken en juchin jawen mabu ea paxkaxunamaki. Jau ea paxkaxunun ea yuixunwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","nemakin Jesúsun yuikin: —En matun xanen ibumaki. Jaska watan en matu paxkaxuntidumaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","yudan kaian yuikin: —Man mabuwen kemuaidan, matu yuinun ninkakanwen. Man mabuyabia jatun matu jiwematidumawen taea jamapai mabu shadabu besti bechipai ja jayanun ika man kemukunkainaidan, uindakanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","januxun jaskakidi miyuiwen jatu yusinkin —Juni betsa mabu midimayatun jawen bai anu yunu betsa betsapa waxun ichawatan ");
INSERT INTO cbsNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","jawen shinanen shinankin: “En xekiwan midima en jani adutidumaki. ¿Jaska waxanpa?” iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“En shinanan, en xekiwan aduti betsa betsapa apakin keyutan ana janu aduti jiwe ewapa wakin janu en xekiwan inun en mabu en aduxanaii”. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jaska watan jamebi shinankin yuikin: “Ma janu en mabu inun en piti ichapa aduti en jayaki. Jaskaken ana dayama juindukunkin piti ichapa pikin mabex aki benimakunkaini badi ichapa en jiwexanaii”, ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","januxun Diosun yuikin: “Jaskamaki. Jaska min yuiaidan, min unanmajaidaki. Na jabia meshu medan min mawaya ja min mabu min pewakin keyuxudan, tsuabunda paxkaxankanikiki”, akin yuitiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ja juni keskakin tsuabunda jamebi mabu ichawakin yaushikin Dios jaibuwama Dios bebunua nuitapaikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","januxun Jesúsun jawen tsumabu besti ana yuikin: —Eska bestiwen taea matunmebi man jamapaiwen dabanan imisbukidi matu yusinun ninkakanwen. Jiwe bestia pepakunkainun ika piti pi inun tadi sawenun ika jawen dabanan iyamakubainxankanwen. Jiwea jayaidan, pitiwen besti man itidubumaki. Yuda jayaidan, tadi sawe bestinun ika man itidubumadiki. Jaskaken ja dabewen taea man jiwenun Diosun matu jiwea inanma iniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jamen Diosun matu mekekubainmistun matu damiwatan matu jiwemakin chanima piti inun matun tadi matu inankubainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ja inun, nai anu peiyabukidi matu shinanmanun ninkakanwen. Jabun jawa miban banama inun jawa bimi tsekaisbuma inun jabun piti aduti jayabumabiaken Diosun jatu pimakubainmiski. Jaskaken Diosun matu bechipaikin peiyabu matu binumakubainikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ja inun, tsuabuda ibubis nuikin jawen mabu inun jawen piti shinainwen taexun jawen jiwea ana chaipawatidumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Min jaska bestitidumawen taea jawada betsa betsapa inun ika jawen dabanan iyamakubainkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Jaskatan jua tuemis shinankanwen. Jawa dayakin tuduaismabia jawenduai tuemiski. Jakia nukun xenipabu xanen ibu Salomón mabujaidayatun jawen tadi jawendua sawexun jawenduakin jua tuemis binuama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jakia ni maxu juaya sepashinxun kuamisbuki. Diosun jua jawenduawamistun ja jua binumakin Dios matuwen nuikin matu tadi sawematiduki, man ikun bexmas wabiayadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Jaskaken yuda dasibibu mai jidabi anuabu piti inun tadiwen kemukin benakubaunmisbuki. Jakia matudan, man betsaki. Matun Epan matu unainwen taea ja piti inun tadi man bikatsis imisdan, ana jas shinain jawen dabanan iyamakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jakia jawada Diosun bechipaiai chibankin ja dukun Dios xanen ibuwakin shinankubainxankanwen. Man jaska wai ja kachu jawen jiweti piti inun tadi man jayakunkainxanaii, Diosun matu medabewadan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesúsun jawen tsumabu yusinkubainkin yuikin: —En matu mekeawen taea man en chaxuwan keskabuki. Ja inun, man ikunwainbu ichapamabiaken matun Epa Diosun jawenabu matu watan jabe matu jiwemakubainxanikiki. Jaskawen taea jawawen dateyamakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Matun mabu jawada ma jayawen nuiama matun mabu betsawen pei bitan jawen nuitapaibu medabewakubainxankanwen. Jamen ja pei matun kapankanki man adua yumetsubun bibaintidubuki. Ja inun, jawen masanen pesa pesa atiduki. Jakia matun pei yaushiama man inanananmisbu pewen matu kupikin nai anua jawa chapui keyuisma Diosun matu inanxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jamen tsuabuda jawen jiweti mabuwen kasmai Dioskidi shinain man Dios jiwexunaidan, jabiadidi matun shinanen man nuiai jayaki, nai anu kasmai mai anudan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesúsun jatu yusinkubainkin ana yuikin: —Tadi pekadiama inun bin nukawadiama keskaxun man ea manakubainxanun bebunkidi matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jawen jaibu ainyain anu jiwe ibu nawai ka jawen tsumapan manaya juxun jikinun ixun kenaya jawen beputi xui jawaida bepenxunxanun ika uxama manai keskakubainkanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Janunkain ¿jatian juimenkainan? yamenapun kasmai takada keui taeaya kasmai jiwe ibu jukin jawen tsuma uxabuma bechitushiaya jawen tsumabu benimajaidaxankanikiki. Januxun chanima jiwe ibun jawen tsumabu duawakin jau jabetan pinunbun jatu baxti imatan jatu pimaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ja inun, chanima jatiada yumetsu juai bebunkidi unankin jiwe ibun bextekatsi manatiduki, jau jikiyamanunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaska keskadiai jatianda en matun Juchi Kayabi Iyua en ana juxanai tsuan unanmaken matunan, matun jiwea pewakin keyutan ea manakubainxankanwen— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","januxun Pedron Jesús yukakin yuikin: —Yusinaan, na miyuiwen min nuku yusiainan, ¿nukuna bestimen? ¿dasibitunadaka?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesúsun yuikin: —Eska keskaki. Xanen ibu betsa chai kakin jawen tsuma unanepa yunubainmiskidi matu yuinun ninkakanwen. Jawen tsuma betsabu pimakin jau jawen jiwe mekexunkubainun jatun xanen ibun jawen tsuma unanepa yunubainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Janua xanen ibu ana chintunkidan jaska yunubainima axunkubainaya ja xanen ibu jaki nukutushitan benimajaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chanima ja xanen ibun jawen tsuma dasibi jawen jamapai mekemaxanikiki, jawen jiwe inun, jawen bai betsa betsapa inun, jawen inabu inun, jawen tsumabu betsadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jakia jawen tsuma shinan pema yunubainima shinan chakakin yuikin: “En xanen ibu yane juamaki. Jatiada juxanikiki”, iki dayanika betsabu juni inun ainbu ichakawai nawachakayamai paenkin ");
INSERT INTO cbsNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jatian juai manama ja xanen ibu jikitushitan jawen yunua axuanmawen taexun manaka chakabube kupijaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jaskaken tsuabunda jawen xanen ibun daya unan keyubiakin jaska bechipaiai akama inun chibanmawen taexun jatu kupijaidaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jakia betsadan, xanen ibun yunuama kaken jawen shinan jaska bechipaiai unanma kanemisbu ja mawaida jatu kupiama ixanikiki. Januxun tsuada Diosun jancha ichapa inanshina jawen taexun jawen daya ichapadi yukaxanikiki. Tsuada Diosun ichapa mekemamis jani jaska wamis ichapadi yukadiakubainxanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesúsun ana jawen tsumabu yusinkin yuikin: —Ea ikunwainbu inun ea ikunwanbuma jawen unanti wakin jatu paxkakin unanti wanun ika en juniki. Jaskaken ewen taea jau paxkanunbun en manayuaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jaskaken Diosun ea unanti wakin jatu ea tenanmakin ea nuitapawaxanaibu manai en yumanyuaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Man shinanan, mai anuxun unanuma matu jiwematanun ika en juni dabanen ¿man shinainmenkain? Jaskamaki. Yudabu paxkanun ika en juniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jaskaken na jabiatian taewakin jiwe betsa anuxun jau ea chibanunbun jawenabu meken besti paxkakin dabe kasmai dabe inun bestibun ea ikunwainbu dabe kasmai dabe inun bestibun ea ikunwanbuma en jatu paxka akeakekubainaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","En jatu jaska waya ewen taea juni bake jawen epabe sinatanamexankanikiki. Ja inun, ainbu bake jawen ewabe sinatanamexankanikiki. Ja inun, jawen babawan jawen yayabe jabiaskadiaxankanikiki. Jatu jaska wakin en jatu paxka akeakekubainxanaii— jatu watan, ");
INSERT INTO cbsNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","januxun mapuabu Jesúsun jatu dasibi yuikin: —Badi kaikidi meshu meshuai uinkin: “Ui bekatsis ikikiki”, ikin uinkin man yuimiski, kaneamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ja inun, surkidia niwe bei xunku ikai uinkin: “Ikis badi kujaidayuikiki”, ikin man yuidiamiski, kaneamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bepadamemisbuun, jaska ui inun niwe bemis unanbiamisxun janu chakabu betsa betsapa kaiankeakeai uinbiakin ¿jaskai man jiwea matu kupixanai man unanmamen?— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Jaskai matunmebi unanbiakin ¿jawada pepa man pewaismamen? ");
INSERT INTO cbsNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jaska inun, yuda betsa man dibijaidawen taexun ja man dibiatun nawa xanen ibu anu matu iyuaya jau xanen ibun jawen policiabu matu bichimayamanun ja man dibia jawawenda daewakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Man daewabainama matu bichiabu man paka keyuama chanima man jaskatan kaintidumaki. Jabiaskadi wakin ea jaibuwatan Epa Dios daewadiakubainkanwen, matun chakabuwen jau matu kupiyamaxanunan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","januxun jabiatiandi juni betsan Jesús yuikin: —Uatian min mai pakea jatiuma Galilea anuabu Templo jemaintin anuxun kenwankin jatun chaxuwan tesenxun kuakin menupananbun xanen ibu Pilaton jawen soldadobu yunua machatuwen jatu detekin jatun jimi chaxuwan jimi yabi jusishinabukiaki. ¿Jaskakin Pilaton jatu jaska washinamen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesúsun jatun shinan pewakin jatu yuikin: —Man shinanan, ja junibu tenanshinabudan, jatunabu Galilea anu jiweabu jabun chakabujaida wakin jawenabu binuanwen taexun jatu kupishina dabanen man shinainmen ikaitsa. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jaskamaki. Jamen matundi matun shinan man betsa wama man jabiaskadiai mawaxanaii, Diosun matu kupiaitianan. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ja inun, ¿ana betsa matu yukapa? Jerusalén anu mishki jiwe keyatapa jawen kena Siloé januxun uinbaunti jiwe pudekekidan 18 junibu ja naman mapuabu tenanidan, chakabuwakin juni betsabu Jerusalén anu jiweabu jatun chakabuwen jatu binuawen taexun kupini ¿man jaska shinandiamismenkain? ");
INSERT INTO cbsNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jaskamadiki. Jamen matundi matun shinan man betsa wama man jabiaskadiaxanaii, niti ikama nuitapakunkainidan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","januxun jabias yusian Jesúsun miyuiwen ana jatu yusinkin —Juni betsan jawen bai nemaki higuera ji banayamakidi matu yuinun ninkakanwen. ¿Bimi jayamenkain? ixun uin ka jawa jayama uintantanmis ");
INSERT INTO cbsNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","jawen dayanikaki nukuxun yunukin: “Uian. Dabe inun besti badi ka na higuera ji anu bimi en jamen benabidanbidanmiski. Bimiumasken ea dedaxunwen, jamen uinbain niakidan”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","jawen tsumapan nemakin yuikin: “Ana badi bestichai manayuwe. Mai pukinkin mishpu bitan ina awa pui jusitan en mia tamanchinxunyuxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","En jaska wa bimiyaxanimenkain. Bimiyamasken en mia dedaxunxanaidan”— akin yuinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mae betsa anuxun juindukuntitian jatun ichati jiwe anuxun Jesúsun jatu yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","jabianudi ainbu betsa yushin chakabun ichakawakin kaku wani 18 badi kabia kawenikitidumajaida jatube tsaua ");
INSERT INTO cbsNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Jesúsun uinkin kenaxun ainbu yuikin: —Ainbuun, min ma xuxaki, min isin tenenidan— akin kamepiaya jawaida kawenikitan januxun Dios kenwankin taewaya ");
INSERT INTO cbsNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","janua juindukuntitian Jesúsun jaska wai uinkin shinain jatun ichati jiwe xanen ibu sinaxun jawenabu ichabu yuikin: —Semana tibi 6 xaba nun dayamiski. Jau matu xuxawanun dayatian besti bekanwen, juindukuntitian xuxai juamadan— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","januxun Jesúsun jatu chitekin yuikin: —Min jaska shinain keska minabubetan shinain man bepadamemisbuki. Juindukuntitianbiaken matubun matun ina awa inun matun burro jawen nuikin tepebain man jatu unpax amamiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jabiaskadi wakin na ainbu matu keska Abrahamnen babadi 18 badi ka Satanásan kanexkin isin tenemani jawen nuikin juindukuntitian en kaya wakin burro tepea keska waxudan, ¿chakabumen?— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","jabu jaki sinataibu jatu chitea dake chakayamai jawa yuiama maniabun yuda ichapabun Jesúsun betsa betsapa pepa dasibi waiwen taea benimai keyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesúsun jatu ana yusinkin yuikin: —Dios xanen ibui jaskamiskidi ");
INSERT INTO cbsNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","miyuiwen matu yusinun ninkakanwen. Junin jawen bai anu mostaza jexe pexeishtabia banaima yumei ewai ewapashina jawen mebiki peiyabun jaki juindukuin utamisbuki. Dios xanen ibuidan, jaska keskaki. Ja dukun juni betsan Diosun jancha ikunwankin jawenabu yusian akeakeaya jawen yusian ninkakin bechipaikin chibanmisbuki, ichapabunan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","miyui betsawen ana jatu yuikin: —Dios xanen ibui jaska keskamiskidi ana matu yusinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Misi wakatsi ainbun xekiwan dudu midimabiaken kencha ewapaki puchinin kesunxun jawen xaxa wati eskadabes unpaxwen nemuskin kapan dasibi buspukidankin xaxa wamiski. Dios xanen ibuidan, jaska keskaki. Ja dukun juni betsan Diosun jancha ikunwain pepakunkainkin jawenabu yusian akeakeaya unanxubida midimabun ikunwantidubuki— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén baiwen kakin mae tibi anuxun Jesúsun jatu yusinkubainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","juni betsan Jesús yukakin: —Xanen ibuun, janu min xanen ibuayadan, ¿eskadabes besti min jatu mekexanai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Jaa. Chanimaki. Ea chibankatsis iki menan shinan mestenwantan janu jikiti xui jashu anu jikikanwen, chipu ichapa jikikatsis ibiai jikitubuma ixankanikiki. Jaska en matu yuiaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eskaki, matu yuinun ninkaidakanwen. Ikis en jancha ikunwankin man ea chibantiduki. Jakia en Epan mae jikiti xui ma en bepuken tsuabuda jikinun, iwanan, kene pechiudi nixun kenakin yuikin: “Xanen ibuun, nuku bepenxunwen”, man wa matu nemakin yuikin: “¿Man jania ikimenkain? En matu unanmabin!”, matu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tsuanda yuikin: “Mibetan nun piniki. Nukun mae anuxun min yusiniki”, man wa ");
INSERT INTO cbsNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","januxun matu yuikin: “Man enabumaki. ¿Man jania ikimenkain? En ma matu yuixuki. Chakabuwakin matun shinan man betsa waismaki. Nenua budikanwen”, en matu waxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Januxun matun xenipabu Abraham inun jawen bake Isaac inun jawen baba Jacob inun Diosun jancha yuixunika dasibi Diosun mae anu dasiabu uin chai matu udenibuwen taea jatu uin jaska man mapeketidubumawen taea xeta yenx yenx iki man kaxakunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ja inun, Dios xanen ibukin mai jidabi anua nortekidia inun, surkidia inun, estekidia inun, oestekidia ikunwainbu dasibi dasia tsauxun pixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jaskawen taea na jabiatian tsuabuda jabu xanen ibuisbumadan, jabu dukun xanen ibu ixankanikiki. Ja inun, na jabiatian tsuabuda xanen ibumisbudan, mawaida ana xanen ibuama ixankanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","jabiatiandi fariseobun Jesús datekin mese wanun ika bexun yuikin: —Xanen ibu Herodesin mia detekatsis ikikiaki. Nenua janida paxadiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesúsun jatu yuikin: —Uian. Ikis inun meshukidi yushin betsa betsapa kainmakin isin teneaibu xuxawakin en yusinkubainaii. Jaska watan ua betsatian en daya en keyuxanaidan, en jaskayukunkainaii. Kaxun ja kaman inu keska padanan yuiditankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ana jatu yuikin: —Diosun jancha yuixunikabu Jerusalén anua debumisbuwen taea eadi jabiadidi en kaii. Ikis inun, meshukidi inun, meshukidi betsatian en daya en menei kaiwen taea matun shinanwen janu en niti itidumaki— ikin, ");
INSERT INTO cbsNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Jerusalén anu jiweabuun, Jerusalén anu jiweabuun, Diosun jancha yuixunikabu inun jawen jancha jatu bana bexunpakeaibu Diosun jatu yunubiaya danankin jatu tenankin matun xenipabun ani keska wakin mishkiwen man jatu tsaka tsaka amisbuki. Takadan jawen bake nuxamis keska wakin eandi matu medabewakin matu mekenun ika en jubianiken jaska shinanma ea danankin man ea jawa ninkamaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Uinkanwen. Matun mae matun mesti man mekenun Diosun matu jenexanikiki, ana Jerusalén mekeamadan. Jakia janu en ana juaitian: “Yavé Diosun kushipaya juaidan”, ikin man yuidiamadan, man ana ea uinyuama ixankanaii— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ana juindukunti betsatian fariseo xanen ibun jiwe anuxun Jesúsun jabetan piaya fariseo betsabun uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesúsun besuudi juni betsa jawen yuda jene ichai xaxaima tenei tsauawen taexun ");
INSERT INTO cbsNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Moisin keneni yusinananmisbu inun fariseobu unanti wakin Jesúsun jatu yukakin: —Jaska Diosun Moisés yusini chibankinan, ¿juindukuntitian xuxawati yununimen? ¿Yunuama inidaka? Ea yuikanwen— ");
INSERT INTO cbsNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","jatu wabia pes jawa yuiama maniabun juni jawen yuda jene ichai xaxaima tsaua metsunxun xuxawatan nichian kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","fariseobu Jesúsun ana jatu yuikin: —¿Matubunan, juindukuntitianbiaken min bake kasmai min ina awa unpax biti kini medan kauana uinsama jawaida kain min nexeismamen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","jatu xabakabi chiteawen taea jawa yuiamabumaken ");
INSERT INTO cbsNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","janua fariseobun jiwe anuxun jatu pimakatsi jatu ia betsabu binunun ika xanen ibu dapi baxti ikatsis ikaibu uinkin Jesúsun jatu yusinkin: ");
INSERT INTO cbsNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ja ainyankin nawa wai anu min jua pinun ika xanen ibu dapi baxti iyamakanwen. Jamen mia dukun xanen ibu dapi min baxti iken xanen ibu betsa mia binua juken ");
INSERT INTO cbsNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","jiwe ibuan mia yunukin: “Janu ikama uani iwe. Jau betsa janu inun ukedi xekexunwen”, akin mia mebinkiki. Mia jaska wa dakejaidai benikain jawen jenei baxti ixun min pixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jakia mia kayabis iwanxun jawen jenei man baxti ika dakaken jiwe ibun mia uinkin yuikin: “Baa, ja xanen ibu dapi ikiyuwe”, iwanan, mia yunuikiki. Mia jaska watan mibetan piaibu mikidi jatu pe shinanmaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jabiaskadi wakin tsuada ibubis kenmis Diosun dake waxanikiki. Jakia tsuada ibubis keinsma Diosun kenwanxanikiki. Ninkaidakanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","jiwe ibun pimabiaxu jadi Jesúsun yuikin: —Min duapawen kupikin jau mia chipu pimadiaxanunbun pimakin min jaibuaibu inun, min betsabu inun, minabu betsa inun, mabuya mia dapi jiweabu besti jatu iyamakubainxanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jakia nuitapaibu jatu ixun pimakin jawaumabu inun yuda babunibu inun, pakebu inun, bekunbu medabewakin min jatu duawaya ");
INSERT INTO cbsNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","jaska waxun mia ixun jabundi mia pimatidubumawen taexun pepabu mawa ana besteaintian min pepawen Epa Diosun mia manakua min benimaxanaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","jaska wai dakaxun ninkabaikin betsan Jesúsbetan pikin Jesús yuikin: —Dios xanen ibuaitianan, chanima tsuabunda jabetan pidan, jabe benimajaidaxankanikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","januxun Jesúsun miyuiwen yuikin: —Juni betsan nawakin piti wakatsis ikin ichapabu yubashina ");
INSERT INTO cbsNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ma janu pia kemaitian jawen tsuma yuikin: “Jatu yuibauntanwen, jau ikis bedinunbunan”, iwanan, yunua yuikubaunaya ");
INSERT INTO cbsNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","dasibibu bepadamekin ja dukuntun yuikin: “Bai wakatsi juni betsan bai en bianxuki. En ja uinyuikai en jabetan piyuamaki, ea yuixunyutanwen”, ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ja kachu betsandi yuikin: “Jawen dayati ina awa meken dabeti en dama bixuki. Jatu unanun, ixun iyunun ika en jabetan piyuamaki, ixuki, akin ea yuixuntanwen”, ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","januxun betsandi yuikin: “En dama ainyanxuki. Jaskawen taea en yudanwanyuai ea yuixunyutanwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ninkatani chintunkidan jawen xanen ibu jaskakanxu dasibi yuia sinatakin ana jawen tsuma yunukin: “Nukun mae anu jiweabu bai jatiubuma inun bai ewapabuwen benabaunkin nuitapaibu inun, yuda babunibu inun, nia chakabubu inun, bekunbu jatu itanwen, jau ebetan pi benunbunan”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","kaxun jatu itankin jawen xanen ibu yuikin: “Min ea yunua en abiaxu min nawati dintu medan ichai texke idiabumaki. ¿Jaska wapa?” aka ");
INSERT INTO cbsNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“En jiwe anu jau ichai texke iki benunbun nukun mae dapi jiweabu daya jayabiabun jatu bikawakin jatu ea ixuntanwen, jau piyui benunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chanima jabu dukun en yubashinabun en piti piabumaki”, akin jawen tsuma yuiniki. Dios xanen ibunun badiaitianan, Diosun jabiaskadi waxanikiki— akin Jesúsun jatu yusinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Januxun yuda ichapabun jawen jancha tapinkin chibainbu dabekekauan Jesúsun jatu yusinkin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tsuada eki chiti ikatsis ikinan, jau ea dukun bechipaikin chibankubainxanunbunwen. Jamen ja dukun jawen ibubu inun, jawen ain inun, jawen bakebu inun, jawen betsabu inun, jawen puibu bechipaikin jeneama inun, jawen jiwea bechipaikin jeneamadi ea bechipaikin binumamadan, en tsuma itudumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ja inun, tsuabunda ea chibanun ibiai ewen bika tenekatsi ikamadan, en tsuma itidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jamen betsan ea chibankatsi ikinan, man eska shinantiduki. Matun bai nemaki janu mapekea nixun uinbaunti keyatapa wakatsis ikin, ¿en pei damenkain? iwanan, jawen kadu tanakin man shinanmiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jakia man jaska wama janu mapekea nixun uinbaunti min taewaima min keyutidumawen taexun juni betsan mia usankin ");
INSERT INTO cbsNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yuikin: “Jaska jawen kadu shinandiamabia ja unainsmapatun ja dukun janu mapekea nixun uinbaunti taewaima jaska waxun menetidumaki”, mia watidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","32","Jamen betsadan, jaki sinatakin nawa xanen ibu betsan 20,000 soldadobu iweai nemakatsi jawen soldadobu yunudiama shinankin yuikin: “¿En 10,000 soldadobun jawen 20,000 soldadobu maematidumen?” ixun atidubuma unantan ja dapi bediabuma jaska wakin daewatidu jau yukatanunbun jawen tsumabu yunumiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaska keskadi wakin tsuabunda matun jamapai tibi ana shinanma jawada dasibi man jaya ana jawen nuiama bestibu man eki chiti ikubaintidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Jamen betsadan, tewekidi matu yuinun ninkakanwen. Tewe jawen nue wa peki. Jakia jawen bata keyu ka paismaken ana jaska waxun jawen min miban min pewatidubumawen taexun putamisbuki. Bestibu man jaskatiduki. Uindaxankanwen. Man pabinkiyabunan, ninkaidakanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","gobierno pei bixunika ichapabu inun yuda betsabu kaka chakamisbu ichapabundi Jesúsun jancha ninkanun ika jaki xukuabu ");
INSERT INTO cbsNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","uinkin Moisin keneni chibanjaidamis fariseobu inun Diosun jancha kenenibu yusinananmisbun Jesús yuain yuinamekin yuikin: —Ja juninan, yuda chakabun Moisin keneni chibainsbuma beya wakin jatubetan pikiki— ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","jaska yuainbu jatun shinan unantan miyuiwen Jesúsun jatu yusinkin: ");
INSERT INTO cbsNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Tsuada man 100 chaxuwan jayatun bestichai benua ja 99 bai anu mapuken bestichai benua man benamiski. ¿Chanimamen? ");
INSERT INTO cbsNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Atimas ja benua bechitushitan benimakin iabidani ");
INSERT INTO cbsNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","min jiwe anu jikitan min jaibuaibu inun mia dapi jiweabu kenakin ichawaxun jatu yuikin: “En chaxuwan benuadan, ma en bechitanaii. Jaskawen taea ebe benimajaidakanwen”, akin man jatu yuimiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chanima jabiaskadi imisbu en matu yuiaii. 99 yuda ichapabun ea ikunwain pepakubainmisbuwen taea nai anu jabu Diosbe jiweabu benimabiamisbun jakia bestichai benua keska chakabui jiwekunkainmistun jawen chakabu jenetan jawen shinan betsa waken jawen benimai chakayamai shinan chankanjaidamisbuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesúsun ana jatu yusinkin —Ainbu 10 pei jexe kadujaida jaya bestichai pakea benanun, iwanan, bin dekuxun jawen jiwe medan unanxubida matsukin bechidiama matsu jeneismaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Janua atimas bechitan jawen jaibuaibu inun ja dapi jiweabu jatu kenakin ichawaxun yuikin: “En pei jexe en benushina en bechixuwen taea ebe benimajaidadikanwen”, akin man jatu yuimiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chanima jabiaskadi en matu yuaii. Yuda bestichaitun jawen chakabu atimas jenetan jawen shinan betsa watan ikunwanyan Diosun nai tsumabu benimamisbuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesúsun ana jatu yusinkubainkin yuikin: —Juni betsa juni bake dabeyakidi en matu yuiai ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jawen bake maxkun yuikin: “Epaan, min mawadiamabia jatiada min mawaken jawada enaxanaidan, paxkaxun menan ea inandiwe”, aka shinantan yuikin: “Peki. En mia axuntiduki”, iwanan, jawen jamapai dasibi jawen bake dabe paxkaxun jawen bake maxku jawena inanshina ");
INSERT INTO cbsNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","uxa eskadabes ka chipu jawen bake maxkun pei binun, iwanan, jawen mabu jatu inankin keyubaini ja pei bishianyan chai kai mai pakea betsa anu kaxun jawen pei mekeama jawada betsa betsapawen kemukaunkin jawaida puta keyutan ");
INSERT INTO cbsNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","jawen pei yamaken ja mai pakeanuabu buni taeaibun jawen bake maxku bunidiakin ");
INSERT INTO cbsNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","januxun daya benabaunkin nawa xanen ibu tsuma wanun, iwanan, daya yuka jawen bai anu ina yawa mapua jau mekenun yunua ");
INSERT INTO cbsNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ja ina yawa pimakin jawen piti yani wapanan tsuan jawa inanma ");
INSERT INTO cbsNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","januxun xabakabi shinan pewakin yuikin: “En epan jiwe anuxun jawen dayadubun piti piabu texe jayabiaken nenua buni en mawatiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jaskaken nenua chintunkain jikixun yuikin: ‘Epaan, Diosun yunua ninkama ichai miadi ichakawai en chakabukaintanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kanekin en mia xunubainima jaskawen taexun ana min bakewakin ea kenama min dayadu betsa ea wawe’, akin en yuixanaii”, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","nawa jenebaini jawenabu anu chintunkaini jawen epan jiweki kemadiamabiaken chaike jawen epan bechibaini jawen nui kushikaini jaki nukutan benimajaidakin ikuxun tantsu tantsu akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","jawen bake maxkun yuikin: “Epaan, Diosun yunua ninkama ichai miadi ichakawabaini en chakabu kaintanaii. Kanekin en mia xunubainima jaskawen taexun ana min bakewakin ea kenayamawe”, abia ");
INSERT INTO cbsNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ninkama jawen epan jawen dayadubu yunukin yuikin: “Tadi pepa jawaida bitanxun sawemakanwen. Ja inun, meichikiti sawematan bichi tae sawemadiakanwen”, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","“Na en bake mawaima keska ma ana bestean keskaki. Benuima nun ma jaki nukuawen taexun ina awa bake xuajaida bitanxun textexun ja naiti piti ichapadi bawakanwen, pi nun jabe benimanunbunan”, jatu wa jawen jancha ninkai jabe benimajaidai nawai taeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","jaskaibun jawen bake iyua bai anu dayatani jui jawen jiwe dapi kemakin nawaibu ninkakubidankin ");
INSERT INTO cbsNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","jawen dayadu betsa kenaxun “¿Jaskai e iskaun beyusi nawai ikanimenkain?” ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","jawen dayadun yuikin: “Min betsa maxku chintunkidani jawa isin teneama jikixuwen taea benimakin ina awa bake xua jau bawaxununbun min epan jatu yunua detetan bawaxun pi min epabe ma benimai beyusi nawakanikiki”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","janua sinatai jiwetan jikikatsi ikamaken jawen epan daewanun ika taxnixun jancha wa ");
INSERT INTO cbsNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","jakia jawen epa nemakin yuikin: “Eskai en sinatai mia yuinun ninkawe. Badi ichapa mia dayaxunkin min jancha en ninkakubainmiski, jawa kaneamadan. En jaskabiaken en jaibuaibube jaya beyusi en nawai benimanun chaxuwan bake babupa min ea detexuinsmaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jakia ja min bake maxkun ainbu jininipabubetan min pei puta keyutani mais jubiaken nukun ina awa bake xua min jamen bawaxunxuki. Jaska watimaki”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","daewanun, iwanan, jawen epan yuikin: “Epaan, min en bake iyuadan, min ebe jiwekunkainmiski. Dasibi en jaya minaski. ");
INSERT INTO cbsNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jaskabiaken min betsa maxku mawa keska ishian ma ana jiwea keskaki. Uatian benushina ikis nun ma bechiawen taea benimai nun beyusi nawai pejaidaii”— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","januxun fariseobun ninkadiaibun Jesúsun jawen tsumabu uinkin jabudi yusinkin: —Juni betsa mabujaidaya inun bai ichapaya jabu dasibi mekexunika dayaxunmiskidi matu yuinun ninkakanwen. Jawen dayaxunikatun kanekin jawen jamapai tibi pe mekexunamaken jaki chaniabu ninkaxun ");
INSERT INTO cbsNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","jawen tsumapan kenaxun yuikin: “Mikidi yuiaibu en ninkaidan, ¿chanimamen? En pei inun en mabu min ubisita wamiskiaki. Jaskaken jaska nuku dibiabu cuenta tibi pewaxun ea inantan ana ea dayaxunama janida kaindikaintanxanwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","jawen mabu mekexunikatun shinankin: “En tsumapan ea nichiainan, ¿jaskaxanpa? En yuda ma en babu bai anu pukin en dayatidumaki. Ja inun, jamapai jatu ea abauni en daketapakauntidumaki, pei ea ikidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jaskakenan, en tsuma dibiabun jiwe anu en ka jau ea medabewakin jaibuwaxanunbun jaska wakin en jatu jaibu watidu en jatukidi shinaiin”, itan ");
INSERT INTO cbsNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","jawen tsuma dibiabu tibi bestibu kenaxun ja dukun jua bichitan yukakin: “En tsumadan, ¿jati jawen jawa min dibiamen?” aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ja dibiatun yuikin: “Jawen piti xeni 100 bidón en dibiaki”, aka jawen mabu mekexunikatun jaibuwakin yuikin: “Jaki min dibia una cuenta bitani nenu tsauxun ana bena wakin jawaida na jabiatian 50 bidón besti kenediwe, min dibia xeni ana shinanmadan”, aka kainkainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","januxun ja kachu juadi yukakin: “En tsumadan, ¿Jati jawen jawa min dibiamen?” aka, “Xekiwan 1,000 saku en dibiaki”, aka: “Jaki min dibia una cuenta bixun ana bena wakin 800 besti kenediwe, min dibia xeni ana shinanmadan”, akin kainma kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","dibiabu tibi jabiaskas jatu waken jawen tsumapan jawen aka jaki chaniaibu unantan jaska nuitapatiduma jaskai jaibuyai jiwexanai unantan jawen mabu mekenika chakabubia unanepawen taexun kenwaniki. Chanima mabuwen kemukin inananain jawen nuiama unanepatan Diosunabuman jaska wai jiwekin jabun Dios ninkaibu jatu binumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jaskawen taexun mabuya man jaskakubainxanunbun matu yusinun ninkakanwen. Mabuwen kemua mesebiaken ja mabu man jayawen medabenankin yudabu jaibuwakin man beyawatidudan, yudabube inananain pepaxankanwen. Matun mabu keyuaya janua man ea chibankin jaska jatu axunmiswen taea Dios matuwen benimakin nai anu jiweti kayabi inankin matu manakuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ja inun, tsuabuda mabu eskadabes jaya pe mekemisdan, mabu ichapadi jayakin ichapadi pe meketidubuki. Jamen tsuabunda mabu eskadabes pe mekeismadan, ichapadi pe meketidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jaskaken mai anua mabuwen kemukin man pe meketidumaken Diosun daya pepajaida matu yunuamadi ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ja inun, yuda betsan mabu man pe mekexuntidumaken jawada Diosun matu yubani matu inanmadi ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ja inun, jadatuda dayadun jawen xanen ibu dabe dayaxunkin medabewatidumaki, betsa bechipaikin chibankin betsa bechipaima danankin ninkamadan. Jabiaskadi wakin pei inun Diosdi shinankin ja dabe jaska waxun man duawatidumaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","fariseobu peiwen kemukin bechipaimisbun Jesúsun yusian ninkakin kaxe wakin usainbu ");
INSERT INTO cbsNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesúsun jatu yuikin: —Matudan, bemakis pepakin junibu padankin man jatu kenwanmamiski. Jakia Diosun matun shinan unanmiski. Ja inun, kenkin jawada yudabun bechipaiai Diosun dananmiski— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesúsun jatu yuikubainkin: —Jamen Nashimanika Juan judiama matun ichati jiwe tibi anuxun Moisin yusini inun Diosun jancha yuixunikabun yusinpauni yusinkubainkin Juanki tekiwanibuki. Januxun Juanen kaka pepa Dios xanen ibuxanaikidi chaniaya ichapabun bechipaijaidai janu jikinun ika naxukunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jabiaskabiaken Diosun yusini dainbainai keska wakin tsuan betsa watidumaki. Nai inun mai yamaxanai bikama keskaki. Jakia dasibi Diosun Moisés yusian keneni jawa betsa texe wama menexanikiki, tsuan betsa watidumajaidawen taeadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jaskaken Diosun Moisés yusian eskaki. Tsuanda jawen ain jenetan ainbu betsa bikinan, Diosun jancha kanei chakabumisbuki. Ja inun, ainbu jawen benen jenebaina juni betsan ainwainan, ja juni betsadi jawen chakabudiaikiki, jaska Diosun Moisés yusian keneni kaneidan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","januxun Jesúsun jawen yusinti betsawen jatu yusinkin yuikin: —Juni betsa mabujaidaya inun bai ichapayatun xanen ibukin tadi pepas sawekin pei ichapa putaxun jawen jaibuaibus pimai jatube beyusi nawai benimakunkainiki, jawen shinan betsa wamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jamen juni betsa nuitapai chaminitun Dios ikunwain jawen kena Lázaro jawauma juni mabujaidayatun jemaintin kene xui xexekaian jawenabun janatantanmisbu ");
INSERT INTO cbsNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","piti texe xanen ibun putai pikin yani wanun ika dakaken kaman bexun jawen chami dataxkubainmisbu ");
INSERT INTO cbsNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","janua Lázaro nuitapai mawa jawen xenipabu Abraham anu jau pepa besti jiwenun Diosun nai tsumabun jawen yushin iyuabu janua jatianda ja mabujaidayadi mawa jawenabun maiwabu ");
INSERT INTO cbsNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","janu mawabu bumisbu anu juni mabujaidayaima nuitapai yumankin uinbaunkin chaikea Abrahamnen Lázaro duawai bechitan ");
INSERT INTO cbsNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","sai ikin yuikin: “Epa Abrahamneen, ewen nuiwe. Chi jede anua en yumaiin. Unpax metsabidan jau en jana ea matsi wayunun Lázaro ea yunuxunwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamnen yuikin: “Baa, eskaki shinanwen. Min jiweadan, jawa bika teneama mabujaidaya min jiwekunkainimaki. Min jaskaya Lázarodan, nuitapakin isin chakabu besti tenei jiwekunkainimaki. Jakia natian Lázaro Diosun duawakin mia kupiaiwen taea min nuitapaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jaskaken miaudia ea anu jau tsua juyamanun inun ea anua mia anu jau tsua kayamanun na kini keyatapajaida waxun Diosun nemaniki”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","mabujaidayaimatun yuikin: “Jaskakenan Epaan, en mia yukaii. En meken bestiti betsayaki. Nenu en yumain anu jau jabudi beyamaxanunbun en epabe jiweabu jau jatuki chanitanun Lázaro ea yunuxunwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamnen ana yuikin: “Moisin yusian inun Diosun jancha yuixunikabun yusian kenenibu minabu jayawen taexun jatun yusian jau tapinunbunwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","mabujaidayaimatun yuikin: “Epa Abrahamneen, chanimaki. Enabu Diosun jancha jayabia tapinsbumaki. Jakia juni mawa ana bestenkain jatuki chania jatun shinan betsa watidubuki”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ana nemakin Abrahamnen yuikin: “Moisin yusian chanima inun Diosun jancha yuixunikabun jatu yusini jawa ninkaisbumawen taexun juni mawa ana bestenkaini kaxun minabu jatu yusinbia jawa ninkamadi itidubuki”, akin Abrahamnen nemaimaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Januxun Jesúsun jaki chiti ikabu besti yusinkin yuikin: —Tsuanda jaska shinanmabiaken yuda betsan jawada chakabu memakin mia beya wamanun, iwanan, jaska Diosun yunumis inun nemamis matu amakin chakabuwamisbuki. Jakia tsuabunda enabu juinti babubu padankin jatu chakabuwamamis jabudi Diosun jatu kupia nuitapajaidaxanaiwen taea jawen xekiwan deneti mishki ewapa nexaxun teumatan ianenwan medan pukua jasadan, jawen kupiti bexmas mekeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jaskaken chakabuwakin man kanekatsi ikamadan, uindakanwen. Jamen ea ikunwain betsan kanekin mia chakabuwa dakeama kaxun xabakabi chitekin dakewawe. Min jancha pewen jawen chakabu min jakimawa jawen shinan betsa waya jawen chakabu ana shinanyamawe. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jabias xabatian tsuanda 7ki mia chakabuwaxu jabiatikidi mia yuikin: “En ana kanexuki. Ana en jaskayamaxanun en chakabu ana shinanyamawe, nun ana sinatadabeyamanunan”, mia waya jabiatidiki jawen chakabu ana jabetan shinantimaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","jawen tsuma kushipayabun Jesús ea akin yuikin: —Nun mia ikunwanbiaya ana ikunjaidawati kushipa nuku inanwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","januxun Jesúsun jatu yuikin: —Man ea ikunwainan, mostaza jexe pexeishta keska man jayaki. Jaska keska jayabun na ji yunukin: “Nenua min tacha betsekekain unu ian nemaki ni maewe”, man aka matu ninkatan itiduki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ana jatu yusinkin: —Tsuada man dayaduya matun bai udutani kasmai matun chaxuwan inun ina awa matu mekexunbai jukidan jiwetan jikiai man yuikin: “Tsauxun pidiyuwe”, akin ¿man yuimismen? ");
INSERT INTO cbsNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Man jaska waismaki. Yuikin: “Badi kaya nun pinun bawa taewawe, ea dukun en piaya chipu min tadi betsa sawetan miandi min piaidan”, akin matun dayadu man pe yunumiski. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jaska yunua jawen tsumapan ninkakin pe akubainaiwen taexun jawen xanen ibun jawen tsuma: “Peki”, aismaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Matudan man jabiaskadi keskaki. Jaskaken jawada Diosun matu yunua atan ibubis keanma yuikin: “En xanen ibun ea yunuas besti en akubainaii. En jawen tsuma bestiki”, ikin jawada matu yunua ja besti shinankin axunkin ja dukun menexunkubainkanwen, jawa chikishamadan— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Janua betsatian Jesús Jerusalénkidi kakunkaini Samaria mai pakea inun Galilea mai pakea ja dabe namakis anu kai ");
INSERT INTO cbsNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","mae betsa anu jikiaya 10 junibu yudaki chaminibun Jesús bechitan benanta mapuxun ");
INSERT INTO cbsNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","jancha kushipawen yuikin: —Jesús yusinaan, nukuwen nuiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús jatuwen nuikin uinkin jatu yunukin: —Jerusalén anu buxun Diosbe nukunabu janchaxunikabu matun yuda uinmaditankanwen— jatu wa jawen jancha ikunwanbaini dabekebaini bukin jatun yudaki chamini ma xuxa ana chami jayama uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","jabu bestichaitun jawen yudaki chamini ma xuxa uintan dabekekidan jui kushipawen Dios kenwain ");
INSERT INTO cbsNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesúsunabuma Samarianawabia Jesúsun besuudi danti iki beti ixun kenwanyan ");
INSERT INTO cbsNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesúsun yuikin: —10 juni chaminibu en xuxawaxuki. ¿Chanimamen? ¿Janimen, ja 9 juni Israelbudan?— ikin ");
INSERT INTO cbsNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","—Na nawan besti Dios kenwain chintunkidanxuki. Jawen tapinkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","nawa danti ika yuikin: —Benitan inun kadiwe. Min ea ikunwainwen taea min xuxaxuki— anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Januxun fariseobun Dios xanen ibui ana juxanaikidi yukabu Jesúsun jatu yuikin: —Dios xanen ibuaidan, ikis beduwen man uintidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ja inun, tsuanda yuikin: “Uinwen. Dios xanen ibui naki”, ikasmai: “Uinwen. Unuki”, ikin yuiama ixankanikiki. Chanima en matu yuiaii. Dios xanen ibuidan, ikis matube dasia niaki, taeidan— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","januxun jawen tsumabu beiskin yuikin: —Eadan, matun Juchi Kayabi Iyua ea uinbianixun ana ea uinkatsis ibiakin man yane ana ea uianma ixankanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Man jaskaya matu padankin yuikin: “Nenu ma juaki, Cristodan”, ikasmai, “Unu ma juaki”, ikaibu ninkabiatan jadi jatu chibanyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jakia en matun Juchi Kayabi Iyua en ana eskakidanxanai matu yuinun ninkakanwen. Jawaida uke bukun kana bedi iki bakamis keskatan en ana juai dasibibun ea uinxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","En jaskadiama ja dukun na jabiatian ea danankin yudabun bikajaida ea tenemakin ea nuitapawayuxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jaska inun, Noé jiweken chakabui jiwekubainibu keskadiaibun matun Juchi Kayabi Iyua en ana chintunkidanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eskanibuki. Jawen nunutiwen Noé jikidiamaken yudabun pikin mabex aki ainyankin jatun bakebu beneyawakin Dioskidi jawa shinanma jiwekubainaibu Diosun yunua Noén chibain jawenabubes jawen nunuti menetan jikiaya jenen jatu achiaya Diosun yunua ninkaisbuma jatumebi debui jasai keyunibuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Jaska inun, jabiaskadiai Lot jatube jiwediaken chakabuwakubainmisbu Diosun jatu kupikin yamawani ana matu shinanmanun ninkakanwen. Jabun pikin mabex akin mabu bikin mabu inananankin bai waxun banakin jiwe wakubaini Dioski jawa dateama jiwekubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot juni pepa jawen mae Sodoma anua Diosun paxa watan nai anua chi inun azufre ui keskai nidi ikin Sodomanawabu jatu yamawaniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jabiaskadiai matun Juchi Kayabi Iyua en juai yudan kaianen ea shinankin manabumaken en jatu jabiaskadi wakin kupixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—En jatu jaska waxanaitian na mai bawa jiwe sapa xeni manaundi maniabudan, butuxun jawen jamapai bikatsis ibiakin jau jawen jiwe anu jikiama jau jawaida paxaxanunbunwen. Ja inun, ikunwain ja bai anu dayaibudan, meshu medan jatun bemakia tadi kextupa bikatsis ibiai jau ana chintunkidanama jau jabiadiadi paxadiaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jamen betsadan, eskaniki. Shinankanwen. Lotin ain Sodoma anua jabe paxabiai jawen mabuwen nui jaskaimenkain uinun ika nasaukeai Diosun jabiadi damiwakin tewe wanidan, man jaskadiatiduki. Uindaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jaskaken tsuabunda jawen jiwea yaushikin benuxankanikiki. Jakia tsuabuda ewen taea mawanun ika jawen jiweawen nuiama mawabudan, jawen jiwea benuama jiwekuinxankanikiki, niti ikamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","36","Ja inun, betsadan, meshu medan jabias dakatiki dabe uxabu betsan ea chibanmis iyukin betsan ea chibainsma Diosun nai tsuman jenebainxanikiki. Ja inun, ainbu dabetan deneaibu betsan ea chibanmis iyukin betsan ea chibainsma jenediabainxanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","jaska yuiai jawen tsumabun ninkatan yukakin: —Xanen Ibuun, dasibi min nuku yuiaidan, ¿jania jaskaxanimenkain?— akabu junea janchawen ana jatu yuikin: —Janu yuda mawa daka pisi mayai xeten xetebidan janu ichai nuyabaunmis keskai ixankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","januxun jawen tsumabun Dios kushipa yukai jau punu nukayamaxanunbun miyuiwen Jesúsun jatu yusinkin ");
INSERT INTO cbsNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","yuikin: —Mae betsa anu juez jiwexun Dioski meseama juni betsan jancha ninkaismadi ");
INSERT INTO cbsNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","jabias mae anua yuxabu jawen bene ma mawayama jau ea medabewanun ika juez anu kaxun yuikin: “Juni betsan ea ichakawakin padainkiki. Medabewakin ea pewaxunwen”, abidan abidankin chikish waya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ja dukun jawen jancha ninkama ikunkainkin januxun atimas shinankin: “Yudabuwen nuiama Dioski en meseamabia ");
INSERT INTO cbsNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","natun ea daketapa wabidan wabidanaiwen taexun en nemaxuni kaii. En jaska waxunamaken jukidan jukidankin ea punu nukawatiduki”, ixun medabewaniki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ana Jesúsun jatu yuikin: —Ja juez chakabun jaska wamisbun ");
INSERT INTO cbsNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","jamen Diosun nuku medabewakin jabun matu chakabuwakatsi ikaibu nemaidan, jawen shinan betsajaidaki. Jawen katuabu Diosun matu medabewakin badidi inun meshu medan man ea atan manaibu ninkatan manama jawaida jatu nemakin matu pewaxunmiski. Jaskawen taea ea matun Juchi Kayabi Iyua en ana juaitian jabun ea ikunwankin jenekubainabuma ¿en jatu bechitushixanimenkain?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","janua ichapa mapuxun ninkaibukidi jabu jatidi ibubis kenkin shinain bepadamei: “Ea besti en pepaki. Jakia betsabudan, jaskaisbumaki”, ikin jatu dananmisbu Jesúsun ana miyui betsawen jatu yusinkin jatu dabinwankin yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Templo jemaintin anu juni dabe Diosbe janchai bua mapuabukidi matu yuinun ninkakanwen. Ja juni dabedan, betsa Moisin yusian inun jawen xenipabu betsabun yusian chibanjaidamis fariseoki. Ja inun, betsadan, Romanawa xanen ibu pei bixunikaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jaskakain fariseo nia naiudi besuxun Dios dayuikin: “Diosuun, yuda betsabu keskama en pewen taexun en mia kenwaiin. Yumetsumisbu inun, padanananmisbu inun, chutanamebaunmisbu inun, ja pei bixunika chakabu en jatu keskamaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ja inun, semana tibi xaba dabe mia kenwain en samakemiski. Ja inun, jamapai dayakin bixun meken dabeti paxkatan bestichai min kenwanti jiwe mekenikabu en inankuinmiski”, iki ibubis keanyan ");
INSERT INTO cbsNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","janua ja Romanawa xanen ibu pei bixunika jawa keanma benanta nidiaxun jawa naiudi besuama dakei aitin iki xutidin xutidin ikin yuikin: “Diosuun, min jancha en kanemisbiaken ewen nuikin en chakabu ea buaxunwen”, ");
INSERT INTO cbsNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","abaini inun kaya Dios jawen nuikin jawen chakabu buaxunkin pewaxunimaki. Jakia fariseon jancha ninkama Diosun jawa buaxunama ikimaki. Jaskaken tsuabuda ibubis kenmis Diosun dake waxanikiki. Jakia tsuabuda keinsma Diosun duawaxanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","janua jatun bake mishtinbu Jesús anu iwekin jau ea mamepikin uinxunkin Dios ea duawamaxunun, iwanan, jabun jatun bake iwebidanbidanaibu Jesúski chiti ikabun uinkin jatu nemaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","nantaxun jatu jaska waibu Jesúsun jatu kenaxun yuikin: —Jatun bake mishtinbu ea anu iweaibu jatu nemayamakanwen. Dios xanen ibuaitianan, na bake mishtinbu eki dateabuma keskabu besti Dioski dasixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chanima en matu yuaii. Bake mishtinbun jawen ibu bechipaimis keska wakin Epa Dios bechipaiabuma Dios xanen ibuaitian jaki dasiama ixankanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","januxun xanen ibu betsan Jesús yukakin yuikin: —Yusinan pepaan, ¿mia yukapa? Jiwea kayabi bikinan, ¿jaska kayatan en bitidumen? Ea yuiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesúsun yuikin: —¿Jaskakin ea kenakin: “Pepaan”, min ea wai? Dios bestiki, pepadan, ¿min unanmamen? ");
INSERT INTO cbsNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mianan, Diosun yunuti inun jawen nemati min ma unaiinan: “Ainbu min ainma chutatimaki. Sinatakin yuda betsa tenantimaki. Yumetsutimaki. Yuda betsaki chanichakatimaki. Padananantimaki. Ja inun, min epa inun min ewa jatu duawakubaintiki”— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","jaska wa ana xanen Ibun Jesús yuikin: —Jaa. Dasibi Diosun yunuti inun jawen nemati bakeishtatun tapinixun jeneama en chibankubainmiski— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ninkatan Jesúsun uin jawen nuikin ana yuikin: —Min pe ea yuiaii. Na besti min shinandiamaki. Mia yuinun ninkawe. Nai anua Diosun manakuti pepa bikatsis ikin min jawada dasibi min jaya jatu inan keyutan ja pei min bishian ja nuitapaibu inankuintan chintuanma ebe kakin ea chibankubainxanwen. Min jaskakunkainaiwen taexun jiwekuian min bixanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","jakia juni mabujaidayatun Jesúsun jaska yuiai ninkai pes juinti nishmai keyutan ana jawa yuiama jawen mabuwen nuiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Jesúsun uinkin ana yuikin: —Ja yuinaka ewapa camellodan, ja xumux jawen chixuiki jawen yuda kainmakinan, tsuan atidumaki. Jakia jaska keska bikadan, juni mabu ichapayadan, jawen mabu besti shinain jawen nuikin jatun shinan betsa wama Dioski chiti itidubumaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","januxun jabun Jesúsun jancha ninkatan yukakin: —Jaskakenan, ¿tsua Diosun nuku mekekin paxawakin jiwematidumen?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús jatuwen nuikin yuikin: —Dateyamakanwen. Yudabun jaska watidubumajaidabiaken Diosun besti matun shinan matu betsa wamatan dasibi matuwen nuikin matu axuntiduki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedron yuikin: —Xanen ibuun, nukunan, mia chibankatsi ikinan, nukun jawada nun jaya dasibi bashikin keyubidanimaxun nun ma mia chibanpakeaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesúsun ana jatu shinanmakin yuikin: —Chanima en matu yuiai ninkakanwen. Tsuabunda ea chibankin Diosun jancha kakape yusintanun, ixun matun jiwe xununkin matun ibubu xununkin matun betsabu bashibainkin matun ain xununyubainkin matun bakebu bashikin keyuyubainxanaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na jabiatiandi dayaibu Diosun pepawen matu duawakin manakukubainshinxun jabiaskadi wakin nai anudi matu jabe jiwekuinmaxanikiki, ikibi imakinan— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","januxun jawen 12 tsumabu besti jatu kenaxun Jesúsun jatu tadi iyuxun yuikin: —Jerusalén anu nun ma mapekei kaidan, man unaiin. Nun janua jaskaxanaikidi matu yuinun ninkakanwen. Diosun jancha yuixunikabun ea matun Juchi Kayabi Iyuakidi ekidi kenenibu menekin ea axankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Januxun eki sinatakin ea achixun nawabu anu ea iyuxun inanbu jabun ea chitekin ichakawakin eki kaxekin eki kemu michukin ");
INSERT INTO cbsNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ea kusha kusha axun ea tenanbu xaba dabe inun besti kaya en ana bestenxanaii— jatu wabia ");
INSERT INTO cbsNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","jawen 12 tsumabun jawen jancha ninkabiakin jawa jatu yuiai dabanen jawa xabakabi ninka pewatiduma ibainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","janua Jerusalénkidi kai maewan betsa Jericó anu kemaya bai kexa juni bekun tsauxun pei jatu ea akin ninkaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","yuda ichapabun dainbainaibu ninkatan yuka ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","betsabun yuikin: —Jesús Nazaret anua kauani ikikiki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","jancha kushipawen yuikin: —Davidin babaan, ewen nuiwe— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","bebubainkin nemapaibiabu ninkama unanxubima jatu binumakin yuikin: —Davidin baba Jesúsuun, ewen nuiwe— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús niti itan junibu jatu yunukin: —Iwekanwen— jatu wa iweabu chaimaxun yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mia jaska wapa?— aka juni bekunman yuikin: —Xanen Ibuun, ana en uinun ea bepexwe ika en ikaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","xuxawakin Jesúsun yuikin: —Ana uindiwe, min ea ikunwainwen taea min xuxaidan— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","jawaida bepexetan Dios kenwankin Jesús chibanbainaya ichapabundi Jesúsun jaska wai uintan dasibibun Dios kenwanbainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","janua Jericó baiwen Jesús jikikaini mae kapukekainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","jabianudi juni betsa mabujaidayatun Roma pei bixunikabu jatun xanen ibu jawen kena Zaqueon ");
INSERT INTO cbsNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesús uinkatsis ibiaya juni ichapabube Jesús kaya Zaqueo juni chanpaishtatun jaska waxun uintima ");
INSERT INTO cbsNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jesús uinun ika bebui kushikain jiwen ina tsauken ");
INSERT INTO cbsNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús jukin manaundi uinkin Zaqueo bechitan yuikin: —Zaqueoon, min jiwe anu en uxai kakatsis ikaii. Menan butudiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","janua jawaida butukidan benimakin jawen jiwe anu Jesús inun jawen tsumabu itan iyuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","jaska wabainai dasibibun uintan Jesús yuankin: “Juni chakabu anu uxai kaxuki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","januxun Jesúsun jancha ninkakin jawen shinan betsa watan Zaqueo benitan Jesús yuikin: —Xanen Ibuun, en jatu jaska waxanai ninkawe. En mabu inun en pei tanatan dabukun ja nuitapaibu en jatu inanbauntidu en shinaiin. Ja inun, tsuabuda jatu padanxun jatun jamapai en bianmis dabe inun dabeki en ana jawendi en jatu inanxanaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Jesúsun yuikin: —Eadan, matun Juchi Kayabi Iyuatun juni chakabu benua keska benabaunkin medabewanun ika en juniki. Na jabiatian na jiwe anu matun mekenan ma matu anu jikixuki. Jaskawen taea min shinan betsa waya Diosun minabube mia mekekubainxanikiki. Jaska Abrahamnen ikunwanpauni keskakin ikunwain min ma Abrahamnen baba kayabiki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","yuda ichapabun Jesúsun yusiain ninkakubainkin shinankin: “Jerusalén anu kematan nawabu nichintan Dios samama xanen ibujaidai kaimenkain”, iwanan, yuiaibuwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","jabun shinan Jesúsun unantan jatu pewanun, ixun miyuiwen jatu yusinkin: —Xanen ibu bexmasbiaken jau mae ichapa xanen ibujaidaxanun, iwanan, xanen ibu kushipa binuatun kena ka ja xanen ibu bexmas katanima matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chai mae betsa anu kadiama jawen 10 dayaxunikabu kenaxun pei jexe ichapajaida ja tibi jatu inan akeaketan jatu yunubainkin: “En judiama na en peiwenan, jamapai tibi bitan jawen inananankin ana binumaxankanwen”, jatu watan chai kaimaken ");
INSERT INTO cbsNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","januxun jawen maewan anuxun jawenabun ja xanen ibu bexmas danankin bechipaiabumawen taexun jawenabu betsabu yunukin yuikin: “Xanen ibujaida binuatun jiwe anu kaxun ja juni jau nukun xanen ibu iyamaxanun yuitankanwen”, jatu wa buimaxun jaki nukutan yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","jabun danankin jaska jakidi yuibiaibun ja xanen ibujaida binuatun ja juni jawenabun bechipaiabumabiaken jau jabun xanen ibu inun jatu katuxunshinken chintunkidan jikixun ja jawen 10 dayanikabu kenaxun ja pei jatu inanbainimakidi jatu yukakin: “¿Jati man ana ea ichawaxunshinamen?”, iwanan, bestibu tibi jatubetan pewanun, iwanan, jatu kena ");
INSERT INTO cbsNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ja dukun juxun yuikin: “Xanen ibuun, min pei jexe ichapa inananankin ana midimajaida 10tiki binumakin en mia ichawaxunshinaki”, aka ");
INSERT INTO cbsNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","jawen xanen ibun yuikin: “Pejaidaki. Min en dayanika pepaki. Eskadabes min pe mekeshinawen taea mia manakukin 10 mae jati mekei ea xanen ibuxunyuwe”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ja kachu jawen dayaxunika betsa juxun yuikin: “Xanen ibuun, min pei jexe ichapa inananankin ana 5tiki binumakin ichapa en mia ichawaxunshinaki”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","jadi yuikin: “Jaskakenan, miandi 5 mae jati mekei ea xanen ibuxunyuwe”, adiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","janua jawen dayanika betsadi danas inanbainima juxun yuikin: “Xanen ibuun, naki, min peidan. Benukatsi ikama dakutan en mia aduxunimaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Min juni meseken miwen datekin min pei benukatsi ikama tadi tuaxwen yabutan en mia aduxunimaki. Dayakin jawa miban banamabia min ichawamiski. Janua jexe sa akamabia min ichawadiamiski”, akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","januxun xanen ibun yuikin: “Min en dayadu chakabu chikish chakamaki. Chanima dayakin jawa miban banaumabia en ichawamiski. Ja inun, jexe sa akamabia en ichawadiamiski. Ja unantan ");
INSERT INTO cbsNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿jaskakin banco anu cuenta watan inananankin en pei min ea aduxunama ikimamen, janua ibubis juxun en pei xekei ana jaki ichashina en biyuxanunan?” atan ");
INSERT INTO cbsNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","jawen dayadu betsabu mapuabu jatu yuikin: “Ja chikishin pei mebintan ja 10tiki binumashina ana ichawamakanwen”, iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","jabun jatun xanen ibu yuikin: “Ma 10 binujaida jayaki. ¿Jaskakin min ana pei inain?” aka ");
INSERT INTO cbsNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","xanen ibun jatu yuikin: “Tsuada na en dayadu pepa keskatun jawada jaya pe mekea unantan ichapa jayabiaken manakukin ana ichapajaida en inanxanaii, binumakinan. Jakia tsuada na en dayadu chikish keskatun jawada jaya pe mekeama ja eskadabes jaya unantan en mebinxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ja inun, jabu eki sinatakin jau jatun xanen ibu en iyamaxanun, jabun ea bechipaiama danainmabudan, itanxun en besuubi jatu tenankanwen”, jatu akimakiaki— Jesúsun jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","januxun jatu jaska yusinbaini kaya yuda ichapabun Jesús chibanbainaibun Jesús Jerusalénkidi ana kai ");
INSERT INTO cbsNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé inun Betania ja mae dabe anu kemai Olivos Mati tetanbainkin jawen tsuma dabe yunukin ");
INSERT INTO cbsNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuikin: —Ja mae besuudi kayanbis buxun burro nexea tsua jaki katsaumediama bechitan tepetan beyutankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ja inun, tsuanda matu yukakin yuikin: “¿Jawakatsi man tepeai?” matu wa yuikin: “Nukun xanen ibun biyukatsis ikikiki”, atankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ja dabe buxun burro nexea bai namaki nia bechitan tepeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","jabianudi burro ibubu manixun jatu yukakin: —¿Jaskakin man burro tepeai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","jabun yuikin: —Nukun Xanen Ibun biyukatsis ikikiki— akabu —Peki. Buxunditankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","tepetan januxun jatun bemakia tadi burro kamaki kabekanbain Jesús anu butan Jesús jaki tsauanbu ");
INSERT INTO cbsNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","katsaumekainaya jatun bemakia tadi bai namaki nabekanbainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos Mati butebidani jaki chiti ika ichapabun Jesús chibankin Jesúsun atimaska betsa betsapa wai uinkubidanshinabuwen taea benimakin jui kushipawen Dios kenwain nawakin ");
INSERT INTO cbsNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yuibainkin: —Aichu! Aichu! Ja Xanen Ibu Diosun kena kushipaya juaidan, benimakin kenwanankanwen. Naiudia unanuma jiwea inun kushipa binu keyua unankin jau kenwanunbunwen— ikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","jabianudi fariseobu jatube bui sinataibun betsan Jesús jatu yuixunkin: —Yusinaan, miki chiti ikabu jaskaibudan, jatu nemawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesúsun jatu yuikin: —Chanima eki chiti ikabu neseaibun na mishkipan ea kenwain sai itidubuki— jatu wabaini ");
INSERT INTO cbsNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalénki kemakin uinkubaini ja maewan Jerusalén anu jiweabuwen nui kaxakin ");
INSERT INTO cbsNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yuikin: —Jawen Dios daewati man ea unanyan matu kupiama ikeanxankanikiki. Jakia natian ikunwanbumawen taexun junea keskaken shinankin man ana uintidubumaki. Man peidawa! ");
INSERT INTO cbsNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Jaskaken Dios matu anu bai juai man jawa ikunwanmawen taea matuki sinatamisbun matu ichakawakin matu nuitapawakin matun mae dapi mai kene keyatapa wabaunkin matu keben keyutan man ana kaintiduma watan matuki sinataibun matun maewan mishki kene nidi akin keyukin matu inun matun bakebu detekin matun mae yamawaxankanikiki, jawa texe wamadan— ikunkaini Jerusalén anu jikitan ");
INSERT INTO cbsNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","janua janu Dios kenwanti Templo jemaintin kenekauna anu jikikainkin januxun jawen Dios daewati ina janubia inananainbu jatu nichinkin ");
INSERT INTO cbsNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","yuikin: —Jawen Templokidi jawen jancha yuixunika Isaías kenemani matu yuinun ninkakanwen: “En jiwedan, janua ebe janchakin ea kenwanxankanikiki”, Dios ibianiken na jiwe xabatududan, janua matu padananankin yumetsun jiwe man wamisbuki— iaketankin jatu nichin keyutan ");
INSERT INTO cbsNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","januxun xaba tibi Templo jemaintin anuxun Jesúsun jatu yusinkubainaya Diosbe nukunabu janchaxunikabu xanen ibubu inun, Diosun jancha kenenibu yusinananmisbu inun, judiobu xanen ibu betsa betsapabun Jesús jaska datanai detenun ika yuinamebiakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","yuda ichapabun Jesúsun yusiain bechipaikin ninkajaidaibuwen taexun jaska waxun tenantima bika tenenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Januxun xaba betsatian Templo jemaintin anuxun Jesúsun yuda ichapabu kakape yuikin jatu yusianyan Diosbe jawenabu janchaxunika xanen ibubu inun, Diosun jancha kenenibu yusinananmisbu inun mae xanen ibu bexmasbun Jesús nemanun ika jaki kemaxun ");
INSERT INTO cbsNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","jabun yukakin: —Na min eska waidan, ¿tsuan jawen kushipa mia yunuimawen min aki ikai? ¿Tsuan jawen kushipa mia inainmamen, min jaska wanunan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesúsun jatu kemakin: —Entsedi en matu yukai ea yuikanwen— itan ");
INSERT INTO cbsNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","—Nashimanika Juanen jau jatu nashimanun yunukinan, ¿tsuan kaya yunuyama man shinain, Diosdaka, junibudaka? Ea dukun yuikanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","janua jabudi june yuinamekin: —“Diosun yunuyamaki”, nun wadan, “¿Jaskakin Juanen jancha man ikunwanma ikimamen?” iwanan, nuku kunyan atiduki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jamen yuda midimabun Diosun Juan yunuyamakidi jabun ikunwainbuwen taea jabuki datekin yuikin: “Junibun yunuyamaki”, nun ikaya mishkiwen nuku tsaka tsaka akin nuku tenantidubuki— itan ");
INSERT INTO cbsNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","januxun jabun Jesús yuikin: —Tsuanda Juan yunuyama nun unanmaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesúsun jatu yuidiakin —Jaskakenan, tsuanda jawen kushipawen ea yunuimadan, eandi en matu yuiamaki— jatu watan, ");
INSERT INTO cbsNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","januxun yuda ichapabun Jesús ninkanun ika beabu miyuiwen Jesúsun ana jatu yusinkin: —Juni betsan bai waxun uva bimi batapa banatan jau bimi dabukun ea inanxanunbun, iwanan, juni betsa dayakapabube jabube yubakatan ibu keska wakin inanyubaini chai kaimaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","janu ma kani tsekatitian ikaya bai ibuan jawena dabukun jau yukatan ea bixuntanun, iwanan, jawen tsuma betsa yunua ka jabun jawena inankatsi ikama uva bimi mekeabun achixun kusha kusha axun jawa inanma mais nichianbu kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","januxun bai ibuan ana jawen tsuma betsa yunudia ka jadi inanxunkatsi ikamadi jabun kunyan akin kusha kusha adiatan jawa inanma mais nichindiabu kaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","janua bai ibuan jawen tsuma betsa yunua ka jabiaskadi wakin deda deda atan kene pechiudi putabu isin tenei kaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","atimas bai ibuan shinankin: “¿Jawa jaska waxanpa?”, itan “Jaskakenan en juni bake en bechipaijaidai en yunua ka jaki mesekin en bimi dabukun ea inanxankanimenkain”, iwanan, shinantan nichian kai ");
INSERT INTO cbsNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","jawen bake jatuki kemai kai bechitan yuinamei: “Bai ibu mawashinken na jawen baken jawen bai tibi inun jawen jiwe tibi dasibi jawenawayuikiki. Na bai nukunas nun wanun tenanankanwen”, ixun ");
INSERT INTO cbsNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","achibain bai nekixun tenanbun ¿jaska washinabun ja bai ibuan jaskada jatu waxanimenkain? Matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bai ibu kaxun jatu kupidiakin dayakapabu jatu tenan keyutan januxun dayakapa betsabu jawen bai jatu yunuxanikiki— jatu wai ninkai e itan yuikin: —Jau jatu jaska wayamaxanunwen— ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesúsun jatu beiskin yuikin: —Ja Diosun jancha Isaíasin kenenidan, ¿jaskada jakidi man shinanmismen?, eska yuinidan: ‘Jiwe wanikabun mishki dananbiaibun jabias mishki Diosun bixun dexun makedex wakin jawen kene mestenwan keska wakin nuku duawakin nuku axunxanikiki’, anidan. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Eskaki, ninkakanwen. Tsuada ja mishkiki sinatakin ea maemanun ika mishki mamaki kauana teke teke ika itiduki. Jakia ja mishki jadatukida kauani jaki tin ikin chushakin mishpu waxanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","januxun Diosbe jawenabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbun Jesúsun dayakapabu chakabubukidi miyuiwen jatukidi janchai jabun ninkakin unantan jaskaitian Jesús achikatsis ibiai yudan kaianki datekin jawa meama mapuxun uinkin ");
INSERT INTO cbsNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","jaskawen unanti watan chitetan romano xanen ibu Pilato anu ja amakatsi Jesús padanun ixun juni betsabu Jesúsun unandiama judiobun jatu yunukin jau juni pepa itsakin jabun unanti watan Jesús yukakin yuimakatsi nawa xanen ibu jau achimaxanun yunuabu ");
INSERT INTO cbsNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jesús anu buxun padanpaikin yuikin: —Yusinaan, junibun jatu kenwanmamisbu keskama chanima jancha besti yusinkin jaska wakin Dios chibantidubu besti min xabakabi jatu yusinkubainmis nun unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jaskawen taexunan, ¿jaskada min shinainmenkain mia yukapa? Ja romano xanen ibu Césarn nuku pei yukamisdan, ¿jaska wananxanpa? ¿Pakananxanpa? ¿Pakatimadaka?— aki ");
INSERT INTO cbsNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","jaki bepadamebainabu Jesúsun unankin jatu yuikin: —¿Jaskakin man ea padankatsis ikanai? ");
INSERT INTO cbsNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Jawen gobierno impuesto pakati pei jexe betsa ea uinmakanwen— jatu wa bexuanbu uinkin Jesúsun jatu yukakin: —Nadan, ¿tsuan besu inun tsuan kena neamen? Ea yuikanwen— jatu wa jabun yuikin: —Romano xanen ibu Césarnaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesúsun jatu yuikin: —Césarnawen taexun matun xanen ibu César duawakin jawen gobierno dayaxunmisbu pei jatu inanxunkubainkanwen. Jakia Diosdi duawakin jawen yusian chibankin jawada bechipaiai axundiakubainkanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","yudan kaianen ninkaya jabun achikatsis ikin unanti wabiabu jaska waxun padankin kanematima nawabun ninkatan min atidumaya Jesúsun janchawen e itan jaska watima pes mapuabun ");
INSERT INTO cbsNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","janua saduceobu judiobu paxka betsa: “Ja mawabu jawen yuda tsua ana besteinsmaki”, imisbu Jesús anu jabudi bexun yukakin: ");
INSERT INTO cbsNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Yusinaan, Moisin nuku kenexuntanan, eska nuku bashixunbainiki: “Juni betsa ainyantan juni bakeyadiama mawaken janua jawen betsan ain janubi ainwantan juni bakewaxuntiki, jawen betsa mawaimatun kena dabikinan”, nuku waniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jaskakidi ja jawen 7 betsabukidi mia yuinun ninkawe. Ja dukun iyuatun ainbu betsa ainwanxun juni bakewadiama mawaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ja kachukeatun jawen betsan jabias ainbu ainwanxun juni bake wadiamadi mawaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ana ja kachukeatun jawen betsan ain jabiadi ainwandiatan juni bake wadiamadi mawaken janua ja 7 jawen jenekin jabias ainbudi bixun jabu tibibun jawa juni bake bawabuma mawai keyuabun ");
INSERT INTO cbsNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","janua jawen jenei ainbu juni bake biamas mawadianiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ja jaskanibudan, mawabu ana besteainbutianan, ¿ja ainbu bestichai ja juni 7bun ainwanibudan, jadatutun kaya ana ja ainbu bixanimenkain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesúsun jatu kemakin: —Na jabiatian beneyai inun ainyain man jiweabuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jakia Diosunabu kayabi ana jatu unanti wakin besten waintianan, jabe jiwei jau benimai jiwenunbun Diosun junibu inun ainbu jatu bestenwanan, jadia ana ainyain inun beneyama ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Janua Diosunabu kayabi ana besteanbuwen taea Diosun nai tsumabu keska beneuma inun ainyuma jiwexankanikiki, ana mawamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mawakubainaibu ana bestenxanaibukidi Moisin yusini matu yuinun ninkakanwen. Ji maxu kua jede ji ikai anuxun mawanibu ana jatu bestenwain kakatsi ikin Diosun Moisés yuia kenekinan, eska waniki: “Eadan, natian en Abrahamnen mekenikaki. En Isaacun mekenikaki. En Jacobun mekenikadiki”, ikai ninkayamaxun Moisin kenenidan, ¿man uinkin yuismamen? ");
INSERT INTO cbsNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Diosdan, mawabunamaki. Jakia jiweabunaki. Jaskaken Abraham inun Isaac inun Jacob jatun yushin jiweabuki. Chipu ana yuda bena Diosun jatu inanxanai shinanma man kanejaidamiski— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","janua Diosun jancha Moisés yusian keneni yusinananmis betsabun Jesús yuikin: —Yusinaan, min pe jatu yuixuki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","januxun tsuan ana jawa betsa yukabumaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ja unanepabu jabu mapuabu Jesúsun jatu bepuxumakin yukakin: —Diosun jancha kenenibu yusinananmisbun matu yusinkin yuikin: “Mesías Cristodan, Davidin baba ixanikiki”, ikin ¿jaskakin matu jaska yusinmisbumen? ");
INSERT INTO cbsNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Nukun xenipabu pepa Davidin Salmos anu keneni matu yuinun ninkakanwen: ‘Dios kushipa dasibi binuatun en xanen ibu Mesías yuikin: Miki sinataibu en jatu maemadiama manai en yusiudi tsauyuwe’, aniki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Mesías en xanen ibuki”, Davidin abianiken ¿jaskatan jawen xanen ibu janubi jawen baba itidumen? Ea yuikanwen— jatu wa jawa yuiabumaken ");
INSERT INTO cbsNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","yudan kaianen Jesús ninkadiaibun jawen tsumabu Jesúsun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Diosun jancha kenenibu yusinananmisbudan, jatu uindakanwen. Jatun tadi chaipa jawendua sawea mae jemaintin ewapa plaza anu en kauanai ea bechipaikin ea kenwankin jau jancha pewen ea duawanunbun ika mapumisbuki. Jaska inun, janu ichati jiwe anu jikikain jaki tsauti pepa janu dasibibun jatu uintidubu anu tsaukatsis imisbuki. Ja inun, ichatan pinun, iwanan, janu xanen ibubu dakai baxti ixun pimisbu benadiamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jaska inun, ainbu jawen benen xununitun jawen jiwe bianun, ixun, ainbu padain bepadani Diosbe janchai chaipajaidakubainmisbuki. Jaskamisbuwen taexun jabu Diosun jatu kupijaidaxanikikiki— itan ");
INSERT INTO cbsNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Templo jemaintin anu tsauxun Jesúsun uianyan pei ichapayabun ja jakia nuitapaibu medabewati bauki inankuin nanekin mistubainbainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ja jaska waibu uianyan ainbu beneumadi nuitapabiai juxun pei jexe dabe jawa damajaida nanekin mistuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesúsun jawen tsumabu yuikin: —Chanima na beneuma nuitapaitun jawen pei inankuin nanekin dasibi pei ichapayabu jatu binumakin keyuxuki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Eskaki, matu xabakabi yuinun. Ja junibu pei ichapayabun jatun pei paxkaxun texe besti inankuinkanxuki. Jakia ja ainbu nuitapaitun dasibi jawen jawada biti pei inankin keyuxuki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","janua jemaintin anu mapuxun Templo inun ja mishkipanwanwen jiwe wakin jawenduawanibu inun inankuinti jamapai shadabuwen dau wanibu uin jawen tsumabu bestibu jakidi janchaibu ninkakin Jesúsun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Na jiwe man uiainan, jawenduabia jabianu mishki betsa ana matsanmanama dasibi ja mishki jiwe tekekin pudekin keyuxankanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","jawen tsumabun yukakin: —Yusinaan, ja mishki jiwe tekei pudekei keyuxanai min nuku yuixudan, ¿mia yukapa? ¿Ma janu kema taei jaskai nun unantidumenkain? Nuku yuiwe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesúsun jatu yuikin: —En ana judiamaken jaskai nuitapai taexanaibu Diosun yuini eskaxankanikiki. Xabakabi matu yuinun ninkakanwen. Ma en janu jua kemaya juni betsabu bexun yuikin: “En Diosun Mesías Cristoki. Ea ninkakanwen”, ikaibun betsabundi yuikin: “Cristo dama juikiki. Matu uinmanun ea chibankanwen”, iwanan, yuiaibu jatu ninkayamaxankanwen, jau matu padanyamanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ja inun, yudabu nuitapai taeaitianan, detenamei kakaibu ninkabiai e iki jawa dateyamaxankanwen, jaskaibutian en juamakidan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ana jatu yuikin: —Ja yudabu nuitapaibutianan, nawa betsa betsapa nawa betsabube detenameaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","mai pacha sakua akeakeaya piti jayama buni teneaibun isin betsa betsapa mae tibi anuxun tenea akeakeaibun nai anua jawen unanti mese jaska taxnisma uiainbun janu en judiama ixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jakia na dasibi eskaxanai idiamaken man ea chibankubainaibuwen taexun matu ichakawakin matu achitan ichati jiwe anu matu yunuabu januxun bichiti jiwe anu matu bichitan xanen ibu betsa betsapa anu matu iyuabu jabun betsabu matu ekidi yuimaxankanikiki, man ea chibainbuwen taexunan. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Matu jaska wabiabu kakape ekidi man jatu yuixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Man jaskaibu ean matu medabewakin jancha pe yuiti shada en matu inan jawen unanepakin ja matuki sinataibun ninkakin jawa ekidi chakabu yuiama inun matu nematidubuma ixankanikiki. Jaskaken jawa dateama “¿Jadakidi yuixanpa?” ikin bebunkidi shinanyamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Ja inun, ea chibankin man ekidi yusinkubainaibu yuda midimabun matu danain janubi matun ibubu inun matun betsabu inun matun puibu inun matunabu betsabu inun matun jaibuaibun matu danankin jabun nawabu matu achimaxun betsabu matu jatidi tenanmaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Matu jaska wabiaibun Dios matu jakimamajaida ixanikiki. Matu jaska waibuwen nuiyamaxanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ja inun, tsuabunda ea chibain chintuanmawen taexun janu kupititian en matu piskumaxanaii, matu kupiamadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ana betsadan, nawa soldadobu Jerusalén mae kexebaunabu uinkin jawaida jatu yamawaxanaibu man unanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Ja inun, Diosun jancha yuixunikabun Diosun Jerusalén kupixanaikidi kenenibu samama keyunun badiyuai unain Judea anuabu mati keyatapa anu jau paxaxanunbunwen. Ja inun, Jerusalén anuabu jau taxnidiabainxanunbunwen. Ja inun, bai anu dayaibu jatun jiwe anu ana beama jau paxadiaxanunbunwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nukun maewan jidabi anuabu yumainbutianan Dios danainbu jatuki sinatakin Diosun jatu kupiaya betsa betsapa teneaibun tuyabu inun ja jatun bake chuchu amamisbudan, nuitapajaidaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ja inun, detenamekin nupe chaipawen betsabu detekin jatidi tenantan betsabu achixun tsuma waxun mai pakea betsa betsapa anu jatu iyuaibun Diosun nawa kushipabu jatu nemakin yamawadiama jabun Jerusalén anuabu ichakawaxankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","Jesúsun jatu yuikubainkin —Januxun Diosun badi inun uxe inun bishi betsa betsapa taxnimatanaya mai anu nawa xukua tibi jiwea akeabu jaskai tsuan ninkaisma betsajaidai ianenwan tunkax ikaiwen date paepai unanyamasi jawa dabanen ninkai mese chakayamaibun jabiatiandi nai anua betsa betsapai nai chuduankin taka taka akaya ja yudabun shinain: “Ma nuku yamawaikiki”, ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja jaskaibun en matun Juchi Kayabi Iyua xanen ibui kushipajaidai chaxajaida nai anua nai kuin medanua en juai uinxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jaskai taeaya man jawawen ana jawa teneama samama en matu pepawen jiwemayuai unantan benimajaidai naiudi teskantan uinkin ea bechixankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","miyuiwen jawen unanti jatu yusinkin: —Jiwen man unantidubukidi matu yusinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ja ji mebi jawen pei petakatan ana pei bena jui metubistan peiai uinkin ma badi kemai man unanmis ");
INSERT INTO cbsNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","keskai jawada en matu yuixu ikai bechitan en samama xanen ibui juai man unanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ja inun, yudabu dasibi jiwebaunabu yamadiabuma chanima dasibi en matu yuixu jaskai taexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jakia jabiaskadiai nai anua inun mai anua Diosun damiwani jabu keyuxankanikiki. Jakia en janchawen bebunkidi en matu yusiainan, binuama menepakexanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Jaska tibi kainxanaiwen taea matun juintinin kemu betsa betsapa mekin kaneama uindaxankanwen. Jawada chakabu aki juinti kushiyamaxankanwen. Eskaidan, paeanwen inun jawada matumebi man jaska shinainwens besti dabanan iki juinti nishmayamakubainxankanwen. Man jaskai jiweabun yudabu mai jidabi anu en jatu unanti watanun ika juaya bidun medan jikitan kebenmana keskama Diosunabu man paxaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jamen matunan, en jancha chibankin jeneama Diosbe badi tibi janchakubainxankanwen. Jaska mese tibi taxnixanai binutan man ma pewen taea janu matun Juchi Kayabi Iyua en matuki nukuaitian ea bebun man mapuxankanaii— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Januxun badidi Templo jemaintin anuxun Jesúsun jatu yusinkubaini meshu medan tibi Jerusalén anua kainkaini Olivos Mati anu uxatantanaya ");
INSERT INTO cbsNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jesúsun jancha ninkanun ika yudan kaian penaya bestentan Templo jemaintin anu jaki nukui ichabidanbidanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ja Pascuatianan, Egipto anuxun Diosun yunua debuwanika nai tsuman nawan bakebu tenankin judiobun xenipabu dunkebaini shinanmatitianan, uxa dabe ma kemai misi xaxama pimisbu ma kemaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","jawenabu Diosbe janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbun jaska waxun Jesús padanxun june achitan tenankatsi yubakai yuinamei yuda ichapabun Jesús ninkamisbuki ika mesei dateaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","janua Jesúsun 12 tsumabu betsa Judas Iscariote Satanás jawen juintiki jikia jawen jaibuaibu dapaxkabain ");
INSERT INTO cbsNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Diosbe jawenabu janchaxunikabu xanen ibubu inun jabun Templo mekenika xanen ibubube janchai kaxun jaska watan Jesús jatu achimaxanun ika jatube yubakaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","jabu benimakin yuikin: “Nun mia pei inanxanaii”, akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas jukin “¿Jatian janixun en Jesús jatu june achimatidumen?” ikin shinankin taewabidanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ja badi Pascua besi taemisbutian ja dukun chaxuwan bake tesenxun taewamisbutian jabianudi misi xaxama pikubainmisbutian ");
INSERT INTO cbsNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesúsun Pedro inun Juan nichinkin yuikin: —Ja Pascua shinanti nukun piti pewatankanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","yukakin: —¿Jani kaxun bawakin pewatanpa?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesúsun jatu yuikin: —Bui Jerusalén mae anu jikitan jabianudi juni betsan unpax shumuwanki iabidanai jaki nukutan chibanbaintankanwen. Man chibanbaina janu jikiai uintan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ja jiwe ibu yukakin eska watankanwen: “Nukun yusinan nuku yuixudan, ¿mia yukapa? ¿Jadatu dintu anuxun en tsumabubetan nukun Pascua shinanmati piti pipa?” man wa ");
INSERT INTO cbsNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","januxun dintu ewapa manaundi ma pewa matu uinma januxun nukun piti bawakin pewayutankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","jawen tsuma dabe kainbaini Jerusalén mae anu jikitan jaska Jesúsun jatu yuixu keska ja juniki nukutan chibanbaini jabe kaxun jiwe ibu yukatan januxun Pascua besikin piti bawa menetan butani ");
INSERT INTO cbsNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","badi kai meshuaya Jesús jawen 12 tsuma kushipayabube jui jikitan tapu dapi dakai baxti ibainbainxun piaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesúsun jatu yuikin: —En mawadiama na Pascua shinanti matubetan pikatsis ikin en manakakubainshinaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chanima Dios danainbu juxun en yamawakin keyudiama en ana jabiaskadi piama ixanaii. Jakia Dios xabakabi xanen ibuaya en matubetan ana pixanaii— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","jawen Pascua piti keyukin jawen kencha tsumaxun Dios kenwantan yuikin: —Chanima en matu yuiaii. En Epa Diosbe xanen ibui en ana judiama na uva vino en ana matubetan ayuama ixanaii. Abaunkanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pascua piti jawen jenekin jatu pima keyutan januxun shinanmati bena wakin misi betsa bixun Dios kenwantan namakis tunketan jatu inankin yuikin: —Na misidan, en matu mawaxunxanai shinanti en yuda keskaki. Ea shinanbetanan man pixanai ikis pikin taewakanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","bitan tudexun pikubaunaibun jabiaskadi wakin kencha vino mata tsumaxun yuikin: —Yuda ichapabu matu medabewai mawakin en jimi en matu jabaxunxanaii. Na vino en jimi keskaki. Jawen yubaka bena shinanmatiki. Ea shinanbetanan, man axanai ikis akin taewabaunkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ana jatu yuikin: —Jamen matu bestichaitun na man ebetan piaibunan man ea jatu achimai kaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jaska ekidi kenenibudan, matun Juchi Kayabi Iyua en jaskai mawaxanaii. Jakia ja junin ea jatu achimai kaidan, peidaxanwan!— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","yuinamei yuka idabebaunkin yuikin: —¿Eamen, en jatu amaxanaitsa? —iake iakei keyutan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","janua jawen tsumabu yuinamekin yuikin: “¿Jesúsbe xanen ibui jadatu kaya nun binunanain kai?” ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesúsun ninkatan jatu shinan betsa wamakin yuikin: —Nawa xukua tibi xanen ibubun jawenabu jatu bika tenemakin yunu chakayamabiakin jawenabu jatu kenwanmakin yuimakin: “Min xanen ibu pepaki”, jatu amamisbu, ichakawabia pepawanikapainun ikadan. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jakia matunan, jaska jatu wayamaxankanwen. Jatu keskama eska shinankubainxankanwen, matubunan. Tsuada juni ewabia bedunan jawa yuiama yunuabu besti chibankin amisbu keskakin matunabu betsabu man binuxanaii. Ja inun, tsuanda jatu yunubiakin matunabu betsabu jatu duawakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Eska yudabun uinkin shinanmisbuki. Na baxti ika dakaxun pimisbu xanen ibuki. Jamen jatun jatu pimakin duawaidan, xanen ibumaki, iwanan, shinanmisbuki. Jamen eanan, matu anuxun matu tapinmanun ixun en matu bestibu duawakin uinmakubainaii. Jaska keskakin jadatutunda ea chibankin betsabu man binuai man unantiduki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ana jatu yuikin: —Nukunabun ea unanti wakin betsa betsapa ea tenemabiaibun man ea jeneama ikunkainaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Jaska man bika tenekubainshinawen taexun ebetan pikin jawen xanen ibu jaki tsauti ea dapi tsauxun Israelin 12 bakebun baba xukuabu tibi jau man jatu unanti watan mekexanunbun jaska en Epan ea yunua en jabe xanen ibumis keskakin ebe en matu xanen ibumaxanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simón Pedro besti Jesúsun yuikin: —Simóon, Simóon, jawena matu wakatsis ikin xekiwan xaka tamisbu keska wakin matu unanti wanun, iwanan, Satanásan Epa Dios ma yukashinaki. Uindawe. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jabiaskabiaken ea chibain jau min juinti babuyamanun eandi Epa Dios ma en mia yukaxunshinaki. Mia jaska wa kanebiatan ana ea chiban taewakin ikunwain betsabu jau chintunyamanunbun jatu kushipa wakin medabewakubainxanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Pedron shinan pewama yuikin: —Yusinaan, jaskamaki. Mibe kai bichiti jiwe anu ka kasmai janu min mawai anu en mibe kaii, jawa dateamadan— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","jaska waya Jesúsun nemakin: —Pedroon, min jaskamaki. Na jabia meshu medan pena kemaya takada keudiama yuikin: “En ja unanmaki”, iki chanima dabe inun bestiki min eki dakekin yui kaii— atan, ");
INSERT INTO cbsNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","januxun Jesúsun jawen tsumabu yunua butanimabu jatu yukakin: —Man yusintanunbun peiuma inun kapankaunma inun tae pewetametia benauma en matu nichian man katanimadan, ¿jawa man yupaimamen?— jatu wa jabu kemakin: —Jaskamajaidaki. Dasibi nun jayaimaki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesúsun ana jatu yuikin: —Natianan, matu ana nichinti en betsa waii. Tsuada man pei jaya buxankanwen. Tsuada man piti jaya buxankanwen. Tsuada man jawen detenameti jayamadan, matun dakukuti betsa inananantan jawen detenameti bixankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na eska en matuki chaniaidan, jaska ea wakin binumama menexanaibu Isaíasin kenekin yuikin: “Juni chakabu yuibaunxankanikiki”, ani chanima ekidi keneni dasibi betsa texewama ea axankanikiki, ewen menekinan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","jawen tsumabun yuikin: —Xanen Ibuun, nun ma dabe jayaki, jawen detenametidan— aka jatu yuikin: —Peki. Ana jadakidi matu yuitimaki —Jesúsun jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jerusalén anua kainkainkin jawen tsumabu iyui janu kamis anu Olivos Mati mapetan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","januxun jatu yuikin: —Matuki chakabu jikiaya man kaneyamanunbun Diosun jau matu medabewanun uxama jabe janchakanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","jatu jenebaini kai tsuanda jatixun tin ikimenkain ixun mishki tude putabu kai tin imistixun Jesús ka danti itan jawen Epa yukakin ");
INSERT INTO cbsNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","yuikin: —Epaan, jamapai dasibi min atidu en unaiin. En mawayamanun min nematidubia en shinain keska ea akama min shinanen besti ea axanwen— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ja jaskaitian nai anua Diosun nai tsuma taxnitan medabewakin kushipa watushiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","janu bika tenechakayamai mestean daka anua niskanjaidai jimi keska tuis tuis ikin mai mecha watan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Diosbe janchai menetan benikidan jawen tsumabuki nukuyuxun juinti nishmajaidatan uxabu bechitan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesúsun jatu yuikin: —¿Jaskai man uxamen? Bestentan chakabu juaya man kaneyamanun Diosbe janchakin jau matu medabewanun yukakanwen— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús jawen tsumabube jancha menediama juni ichapabube Judas jui jatu bebuxunkidani Jesúski nukutushitan tantsu akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesúsun yuikin: —Judasiin, jawen bechipaiti tantsu akaiwen unanmakin min Juchi Kayabi Iyua ¿min ea jatu achimai?— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesúsbe mapuabun jaskabidanabu unankin yukakin: —Xanen ibuun, ¿na eskabidankanxudan, machatuwen jatu detekin nemapa?— ikain ");
INSERT INTO cbsNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","betsan jawenabu Diosbe janchaxunikabu xanen ibujaidatun tsuma jawen pabinki yusiudia maebain mepexpaikin paxteaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesúsun nemakin jatu yuikin: —Min ma axuki. Jatu jaska wayamakanwen— iwanan, jawen pabinki paxtea tin ika bixun patsankin Jesúsun xuxawatan ");
INSERT INTO cbsNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","jawenabu Diosbe janchaxunikabu xanen ibubu inun jatun Templo mekenika xanen ibubu inun mae xanen ibu bexmasbun Jesús achinun ika beabu Jesúsun jatu chitekin yuikin: —Xaba tibi januxun Templo jemaintin anuxun en matu yusinkubainai man ea achiama ikunkainshinaki. ¿Jaskai natian yumetsu achimisbu shinain jawen deteti nupe chaipaya inun jawen kushati jiya man bekanxumen? Natian chanima chakabu dayaya ja medabewamai man ea achinun ika bekanxuki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ninkamas Jesús achixun jawenabu Diosbe janchaxunika xanen ibujaidatun jiwe anu iyuaibun Pedro datekin benanta chipu kakin chibankubaina ");
INSERT INTO cbsNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","janu xanen ibun jemaintin chi ketian yui tsaubaunabube Pedro jatube tsaua june yuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","janua ainbu dayadu juxun Pedro chin yuai uin kayati watan jatu yuikin: —Na juni matube tsauadan, jawen tsuma betsaki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedron padankin yuikin: —Ainbuun, jamaki. En ja unanmaki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","jakimamadi betsandi bechixun yuikin: —Miadan, min jabia jatube uinanmandi— aka Pedron ana yuikin: —Jaskamaki. Eadan, en jamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","janua jakimatsais katan Pedro metukin juni betsan unanxubima mapuabu yuikin: —Chanima na junidan, jabe nimiski. Jabia Galilea anuabu jancha nun ninkaii— ikai ");
INSERT INTO cbsNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ninkatan Pedro datekin yuikin: —Ja jadi min jaska yuiaidan, en unanmaki— ikaya ja jaskaitian takada keuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesús nasaukekauan Pedro uianyan jaska Jesúsun Pedro yuia: “Takada keudiama yuikin: ‘En ja unanmaki’, ikin chanima dabe inun bestiki min eki dakei padanananxanaii”, aka jaska shinain ");
INSERT INTO cbsNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","janua Pedro taxnikain kaxachakayamaya ");
INSERT INTO cbsNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","jabianuxundi jabun Jesús achibidan ichakawakin besu beputan kaxe wakin kusha kusha akin yuikin: —¿Tsuan mia kushaimenkain? Unantan nuku yuiwe— akubainkin ");
INSERT INTO cbsNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","betsa betsapa yuikin ichakawashinkin ");
INSERT INTO cbsNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","janua badi chi pexeaya mae yununika xanen ibubu inun Diosbe jawenabu janchaxunika xanen ibubu inun, Diosun jancha kenenibu yusinananmisbu na Junta Suprema ichabu anu Jesús jatu iyuxunabu ");
INSERT INTO cbsNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","jabun yukakin: —¿Jabia min miamenkain, nukun Mesías Cristodan? Menan nuku yuidiwe— akabu Jesúsun jatu yuikin: —“Chanima en jaki”, iwanan, en matu yuibia man ea ikunwantidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ja inun, jawada eandi en matu yukabia man ea yuitidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jabiaskabiaken en matu yuiai ninkakanwen. Na jabiatian man ea tenanbia Dios kushipajaida dasibi binuatun yusiudi en tsaua en matun Juchi Kayabi Iyua en jabe xanen ibukunkainxanaii— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ninkatan dasibibun yukakin: —Jaskakenan, ¿jabia min Diosun bakedaka ikai?— akabu Jesúsun jatu yuikin: —Ibubis matumebi jabiadi man yuiaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","janua jaki sinatai jabudi yuinamei: —Jawen kexawen Dios ichai jamebi chakabuikiki. Jaskai nun ninkaiwen taexun jau tenanunbunwen— itan yuinametan ");
INSERT INTO cbsNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","xanen ibu dasibibun jaska wakin unanti wakin menetan janua benibainkin romano gobernador Pilato anu Jesús iyuxun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","jakidi chitekin Pilato yuikin: —Na juninan, chakabu betsa betsapa jatu yusinkin nukunabu itimaska wakin jatu padainkiki. “Min xanen ibu César jau pei inanyamanunbun nukunabu jatu nemamiski”. Jabiadi “En Xanen Ibu Mesías Cristoki”, imiskiaki— akin jakidi yuiaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaton ninkakin Jesús uinkin yukakin: —¿Miadan, min judio xanen ibubu binu keyuamen?— aka Jesúsun yuikin: —Jawaikika! Jabiadi min ea yuiaii— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","januxun judiobu Diosbe jawenabu janchaxunika xanen ibubu inun yudan kaian Pilaton jatu yuikin: —Jawa chakabu akamaki. Jawawen taexun kupiti jayamaki— jatu wabia ");
INSERT INTO cbsNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pilaton jancha ninkama jawenchains unanxubima yuikin: —Judea anuxun jatu yusian akeakekin jatu itimaska wamiski. Galilea anuxun taewaima nenuxundi jatu yusindiaikiki— akaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","jaska yuiaibu Pilaton ninkatan jatu yukakin: “Aa, ja junidan, ¿Galilea anuadaka?” ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Jaa, Galilea anuaki”, akabu Pilaton tapintan ja Galilea xanen ibu Herodes na jabia mae Jerusalén anu bai jushinken jawen soldadobu yunukin xanen ibu Herodes anu Pilaton Jesús jatu yunua iyuabu ");
INSERT INTO cbsNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","jaska Jesúsun jamapai damiwakin betsa betsapa wai kakai Herodesin ninkamis jaska jawen bedubi dami betsa axuain uinun ixun manajaidamis atimas Jesús uin xanen ibu Herodes benimajaidakin ");
INSERT INTO cbsNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","jaska wamis keska yuka chakayamabiaya Jesúsun jawa yuiamajaidaken ");
INSERT INTO cbsNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","jabianudi Diosbe jawenabu janchaxunika xanen ibubu inun Diosun jancha kenenibu yusinananmisbun Herodes yuidiakin jakidi Jesús chitekin ja akeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jesúsun jawa ja yukaikidi jatube janchama kutaxna niken jawen soldadobubetan Herodesin Jesús ichakawakin kaxe wakin betsa betsapa watan xanen ibu keska wakin sanpu jawendua sawematan jawawen jaska watima ana jawendi Herodesin Pilato anu Jesús yunua iyuabu ");
INSERT INTO cbsNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","romano xanen ibu Pilato inun judio xanen ibu Herodes uatian sinatanamebianibu na jabiatian daenamei jaibunamei taenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato anu Jesús ana chintuanbidanabu uinkin Diosbe jawenabu janchaxunika xanen ibubu inun mae xanen ibubu inun yudan kaian Pilaton jatu ichawaxun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yuikin: —Na juni ana ea anu iwexun matunabu padankin jatu itimaska wamis yuikin man chitexuki. Jakia dasibi man uianyan Jesús yukakin unanti wakin jawa chakabuwakin meshina en bechiamaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Januxundi jau Herodesin unanti watan jaskada wanun, iwanan, en yunua unanti wakin jawa chakabuwashina bechiamadi ea anu Herodesin ana yunuxuki. Jawa jaskashinawen taexun jau tenanunbun en yunutidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jaskaken kusha kusha a bestitan jau jawama kanun en jatu yunuaii— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","badi tibi Pascua besiaibutian romano soldadobun jatu achixun bichimabu jau bestichai taxnimanunbun yudabun katua romano xanen ibun jatu kainmaxunpakemisken jabiatiandi juni betsa Barrabás juni betsabube detenamekin jatun xanen ibu detepaikin jatubetan juni betsabu tenanken jabube achixun bichimabun ja shinankin januxun yudan kaianen unanxubima yuikin: —Jau Jesús tenanunbun yunuwe. Jaska watan Barrabás kainmatan nuku nichinxunwen— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesúswen nuikin jawa wama nichinkatsis ikin ana jatu yuikin: —Jaskamaki. ¿Matun xanen ibu Jesús matu kainmaxunpa?— jatu wabia ");
INSERT INTO cbsNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ninkakatsi ikama unanxubimajaida ana yunukin: —Cruzki jatu mastamawe! Cruzki jatu mastamawe!— akeakeabu ");
INSERT INTO cbsNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaton ana jatu nemanun, iwanan, yuikin: —¿Jawa chakabuwashinamen? Jau tenanunbun unanti wakin jawada chakabuwashina en bechiamaki. Jatu kusha kusha ama bestitan en jenekatsis ikaii, jau jawama kanunan— jatu wabia ");
INSERT INTO cbsNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ninkamas yuda ichapabun unanxubima ana yuikin: —Cruzki nuku mastaxunwen— akin jaska shinainbu keska jau jatu axunun yunukin jeneabumaken ");
INSERT INTO cbsNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","atimas jaska shinainbu keska jau jatu axununbun jawen soldadobu Pilaton yunutan ja juni Barrabás detenameawen taexun bichimabu yudabun katua kainmatan januxun Jesús jau mastatanunbun jatu yununikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Januxun romano soldadobun cruz Jesús jaki mastanun, iwanan, iamabainkin iyukin juni betsa Simón Cirene anua ewani Jerusalén anu jikiai achixun jau Jesúsun cruz iaxunbainun yunuabu Jesús bebuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","yuda ichapabun Jesús chibanbainaibun ainbuaibu jawen nui kaxai bis ikubainaibu ");
INSERT INTO cbsNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","31","Jesúsun jatu uinkin yuikin: —Jerusalén anua ainbuaibuun, ewen nui kaxayamakanwen. Jakia janu nuitapaibutian nenuabun yuikin: “Ainbun jabun bake bisbuma besti benimaxankanikiki”, ikaibun januxun yuda ichapabun jabun chakabuwen datekin mawa yuikin: “Nukuki matekei di ikin nuku junewe”, axankanikiki. Jaska inun, ea en jawa wama nibiaken ea ichakawakanikiki. Jamen jabun ea ichakawaibu Diosun jabudi ichakawa chakayamadiakin jatu kupijaidaxanikiki. Jaskawen taea ana ewen nui kaxama matumebi inun matun bakebuwen taea nui kaxakanwen— jatu wabainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","janua juni yumetsu dabe Jesúsbe tenanun, iwanan, iyui ");
INSERT INTO cbsNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Buxka Xau Mati anu mapematan Jesús cruzki mastatan januxun juni yumetsu dabedi jabianudi jabe mastakin betsa jawen yusiudi betsa jawen yusmaudi mastaxun nichinkin ");
INSERT INTO cbsNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","meneabun soldadobukidi Jesúsun yuikin: —Epaan, ea jaska waibudan, jawa jatu kupiyamawe, jawa unanma iki ikanikikidan— ikaya januxun soldadobun jawen beyustiwen maemanankin jawen tadi paxkanun iwanan: “¿Tsuan dukun jawen tadi bimenkain? Akanwen”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","jabianudi xanen ibubu inun yuda ichapabun uinkin kaxe wakin yuikin: —Juni betsabu medabewamiski. Jamebidi jau paxadianunwen. Jaska Diosun Katua Mesías kayamenkain cruz anua na jabiatian butuai uinkin nun ikunwantiduki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","38","ji bexa sapaki kenekin: “Nadan, judiobun xanen ibujaidaki”, akin kenea Jesús mamaki mastaxun soldadobun chaima ja dapixun kaxe wakin vino jene muka amapaikin yuikin: —¿Min judio xanen ibu kayabimenkain? Nuku unanmai mimebi paxai butudikaintanwen— adiaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","janua yumetsu dabe jabe mastabudi betsa jancha chakabukin yuankin: —¿Min Diosun Mesías Cristomenkain? Mimebi bututan nukudi butediwe, nun paxanunan— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","janua betsan kunyan akin nemakin yuikin: —Nukunan, nun chakabuwashinawen taexun achixun ichakawakin nuku tenankanikiki. Jakia na juni pepatun jawa chakabuwaismabiaken ichakawakin nukube tenandiakanikiki. ¿Dioski meseama na juni pepa min jatubetans jaska wai? Ana jaska yuiyamawe— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","jawen chakabuwen datekin Jesús yuikin: —Jesúsuun, min xanen ibui taeaitianan, ewen nui ea jakimayamaxanwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesúsun yuikin: —Chanima en mia yuiaii. Min shinan betsa waiwen taea na jabiatian pe besti anu ebe ka min jiwepakexanaii— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","janua badi manananbibiaken badi nuka meshua itsa daka manaibun ma badi kai nai puchinin dakaken bepenakainaya Templo medan dintu wakin ja tadiwen kebenibu jamebi manaundia namakis dis iki keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","janua Jesús bis ikin yuikin: —Epaan, mia anu en yushin en nichiain ea mekewe— akin jaska yuitan mawaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","januxun romano soldado capitán Jesús jaskai uintan Dios kenwankin yuikin: —Chanima na juni chakabumaki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ja dapi yudan kaian mapubaunabun jaskaxu dasibibun uin jawen nui juinti nishmai xutidin xutidin ibainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","janua jatidi Jesúsun jaibuaibu inun ainbuaibu Galilea anua jabe beshianbudi benanta nixun jaskai uinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","54","Janua ma badi kaya jabiatiandi judiobu juindukunkatsi bebunkidi piti pewakin dasibi menea badi jikiaya ana dayatidubumawen taea janu Judea anua José jawen mae Arimatea anua ewai yumeni, juni pepa inun duapatun Dios xanen ibuxanaitian manakin judio xanen ibubiakin jau Jesús tenanunbun xanen ibu betsabube Junta Suprema jatube ja yubakama ishian José romano xanen ibu Pilato anu kaxun Jesús maiwatanun ixun jawen yuda yukai kaxun yuka yunua ma juindukunti kemaiwen taea jawaida kaxun cruz anua jawen jaibubetan Jesúsun yuda jatu butemaxun tadi chaipa juxupawen dayabutan buxun maiwati mishki tanpe bena kini waimabu anu janu yuda betsa datandiabuma anu Josén jawen jaibuaibubetan Jesúsun yuda datantan mishki ewapawen bepubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","janua ainbuaibu Galilea anua Jesúsbe beshianbun Jesúsun yuda buaibu chibanbaini maiwati tanpe inun jaska Jesúsun yuda datantan bepubainaibu uintan ");
INSERT INTO cbsNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","jadia Jerusalén anu chintunbain jatun jiwe anu jikixun xeni ininipa pepa inun jawen dapuxti dau betsa jawen yuda taxka wakin chaputima wati dau pewakin meneabun ma badi jikiaya juindukuntianken jaska Diosun Moisés yununi shinain ainbuaibu juindukunkin manabaishina ");
INSERT INTO cbsNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","janua ma juindukunti binushinken domingotian penamajaida maiwati tanpe anu bukatsi jawen dapuxti xeni ma pewashinabu buaibun ainbu betsabudi jatu chibain jatube bui ");
INSERT INTO cbsNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kematan ja mishki beputi ewapajaida tsuanda ma tadanbu bechitan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","jikikain Xanen Ibu Jesúsun yuda jawa bechiama ");
INSERT INTO cbsNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","jani tsuan jaskada washina unanma janua e iki keyutan uiainbun jabianudi jawaida juni dabe jatu bebun taxnia tadi juxupa chaxajaida sawea bechitan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","jaska uin datejaidai main beui beti ikaibun juni dabetan jatu yuikin: —¿Jaskakin maiwati medan juni jiwea man benakanai? ");
INSERT INTO cbsNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Nenumaki. Ma bestenkainaki. Galilea anuxun matu yusinkin yuikin: “Eadan, Matun Juchi Kayabi Iyua juni chakabun ea achixun jiki ea mastabu mawa xaba dabe inun besti kaya en ana bestenxanaii, jaska Diosun yubanidan”, akin matu yusinkin yuimadan, ¿man shinanmamen? Shinankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","jaska Jesúsun jatu yuima chanima shinantan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","maiwati tanpe anua kainbaini María Magdalena inun, Juana inun, Santiagon ewa María inun, ainbu betsabu jabun kaka buxun Jesúsun 11 tsuma kushipabu inun jabun Jesús chibanmis betsabu jaska uinkanxu jatu yuibiabu ");
INSERT INTO cbsNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","jatun jancha jawa ikunwanma: “Jaskatandun jaskanun jumei ikanikanikiki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","janua Pedro jadi chaniaibun ninkatan: “Eandi uintanun”, ika taxnikaini maiwati tanpe anu kushikain uinun ika kakui denikain uke medan uinkin jawen yabushinabu tadi jamaudi daka uintan jaska uin e iki teku itan Pedron jaskashina shinain shinanyabi kaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","janua Jerusalén anua bui 11 kilómetro mae betsa jawen kena Emaús anu jabias xabatian Jesúsun tsuma betsabu dabe bui ");
INSERT INTO cbsNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","jaska wa akeaketan tenanshinabu bestenkainakidi janchai ");
INSERT INTO cbsNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","yuinamekubainaibun jabiatiandi Jesús jatu ichun taxnitan kakin jatu chibain kai jatuki nukukainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","jau unanyamanunbun Diosun jatun bedu betsa wa ");
INSERT INTO cbsNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","januxun Jesúsun jatu yukakin: —Bai tanabidanidan, ¿jawa yui man ikubainkanai?— jatu wakin ana jatu nui chipea nuiyabi buaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","januxun jabu betsa Cleofásin yuikin: —Jerusalén anua jaska dasibi washinabu dasibibun unankanikiki. Jerusalén anu bai jubiashina ¿jaskakin mian besti min jaska uianma ishianmen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","januxun jatu yukakin: —¿Jaskashinamen? Ea yuiwe— aka ana yuikin: —Jesús Nazaret anua ewani ichakawakin eskaya tenanshinabuki. Mia yuinun ninkawe. Diosun jancha yuixunika pepajaida eskakin Dios inun yuda ichapabu jawen aka uinmakin daya duapa inun jancha kushipai unanepai ");
INSERT INTO cbsNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","pepajaidabiaken jau tenanunbun Diosbe nukunabu janchaxunika xanen ibubu inun nukun mae xanen ibu betsabun nawabu anu Jesús yunuabu cruzki jatu mastamabu mawashinaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ja inun, Jesúsun nawabu nichinkin Israelbu nuku pe mekekin Dios nuku daewaxunxanai dabanen nun jamen dasibi manakakubainshinaki. Ja inun, ma xaba dabe inun besti binubiakainaya nun jawa uindiamaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Jaska inun, nukubetan jabun Jesús chibandiamisbu ainbuaibu penamajaida maiwati tanpe anu buxun Jesúsun yuda jawa uianma nai tsuma dabe jatu bechankamea nia uiainbu jatu yuikin: “Jesús jiweaki”, jatu wa bexunkiaki. Jaska nuku yuiabu datei nuku dateabu e itan nun ninkaki. ");
INSERT INTO cbsNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jaska nukuki chaniaibun nukun jaibu betsabudi maiwati tanpe anu buxun jaska ainbuaibun yuixu keska uinkin jawa Jesús uianma idiakanxukiaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","janua Jesúsbe janchai unandiabuma Jesúsun jatu yuikin: —Diosun jancha yuixunikabun medabenan Mesías Cristokidi kenenibu unanbiakin unanxubida ikun bexmas wakin shinan pewadiama man kaneaii. ");
INSERT INTO cbsNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nukun medabenan Mesías xanen ibudiama jau jaskai yumain kanun Epa Diosun yununiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Diosun Moisés yusian keneniwen jatu yusin taewakin Diosun jancha yuixunikabu dasibibun yusian janchawendi Jesúsun jatu yusinkin jatu unanmakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaúski kemai buaibun jatu binubainai dabanen ");
INSERT INTO cbsNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","nemakin yuikin: —Ma badi kai meshuikiki. Jabianu nukube niti iyuwe— akabu ninkatan jabianu jatube bashikui niti itan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","jabianuxun jatubetan pinun ika baxti itan misi bixun piti jayabuwen taexun Dios kenwantan tunkexun jatu inanyan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","jabiatiandi Diosun jatun bedu ana betsa waya Jesús uinkin unantanaibuns samama ana damikainaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ja dabetan shinain yuinamekin: —Bai tanabidankin Diosun jancha yuixunikabun yusini nuku unanmakin nuku yusianyan nun juinti shinan chankankunkidanxuki, ¿chanimamen?— iki yuinametan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ma meshubiaken ana janu ikatsi ikama benibidani Jerusalén anu jawaida chintunbain Jesúsun 11 tsuma kushipayabu inun jatube jawen tsumabu betsabu ichabu anu jatu anu jikitushitan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","januxun jabu ichapabu yuikin: —Chanima ma besteanki, nukun Xanen Ibudan, ja Simón Pedroki nukukin uinmaxudan— iwanan, yui jatuki chaniaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","januxun jaska Jesús unandiamabia bai tanabainkin Jesúsun ja dabe jatube kakin yusinxu yuitan januxun misi tunkexun jatu inain anu atimas xabakabi uinbidan jatu yuiaibun ");
INSERT INTO cbsNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","jaskaxu yui menediama janchan wainbun Jesús jawaida dami nashui itan jatu jancha wakin yuikin: —¿Jaska man unanumamen? Ma en juaki. Dateyamakanwen— jatu wabia ");
INSERT INTO cbsNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","datekin shinankin yuikin: “Nadan, ¿yushinmenkain?” ikin uinkin shinainbun ");
INSERT INTO cbsNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesúsun ana jatu yuikin: —¿Jaskai mesei datei man e ikanai? ¿Man juinti kushimen?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","jawen meken inun jawen tae jatu uinmakin yuikin: —En tae inun en meken uinkanwen, jabia en eakidan. Nami inun xau en jaya keska yushin jayaismaki. Mekin ea unankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","shinan chankanbiai bika tenekin ikunjaidawadiabumawen taexun Jesúsun ana jatu yukakin: —¿Piti man jayamen? Ea inankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","baka xui inanbu ");
INSERT INTO cbsNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","jatun bedubi pitan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","yuikin: —“Moisin yusini jancha inun Diosun jancha yuixunika betsabun yusini jancha inun Davidin jawen nawakin kenwanti jancha Salmoswen Dios yubakaniki, jau dasibi jaskaxanunan”, iwanan, yuinibu en mawadiama matu anuxun jabiaskadi matu yusinkin dasibi ekidi na kenenibu bebunkidi en matu yuikubainimaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ja kenenibu una jau ninka pewanunbun ");
INSERT INTO cbsNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","jatu yuikin: —Ekidi kenenibu matu yuinun ninkakanwen. Diosun Katua Mesías medabenan yumantan mawa xaba dabe inun besti kaya ana bestenxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jaskawen taexun jawen kushipawen jatu yusinxankanikiki, jau jatun chakabu Dioskidi chakabumisbu jau jenetan jabun shinan betsa waibu Diosun buaxunxanikikiki. Nawa xukua tibi ninkaxanaibu yuini matun Jerusalén anuxun taewakin ");
INSERT INTO cbsNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","na kakape ekidi chanibaunxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jaska en Epan ea yununi keska wakin eandi en matudi yunuaii. Diosun jawen janchati kushipa datetima en matu yunuxanai binun ika na jabia Jerusalén anu jiweyuxun manakayukanwen. Diosun jawen kushipa nai anua matu inan bitan nawa dasibibu yusinkin taewaxankanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","jaskakunkainkin xaba betsatian Jerusalén anua kainkaini Betania anu Jesús kakin jawen tsumabu iyuxun jawen meken sananxun jau Diosun jatu duawakubainxanun jatu yukaxunaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","jabu jenemabainkin nai anu jawen Epan ainiaya ");
INSERT INTO cbsNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","jatu jenebainai uin jawen tsumabun teskanbainbainxun Jesús kenwantan benimajaidai Jerusalén anu ana chintunbidan ");
INSERT INTO cbsNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Diosun kushipa manakakin xaba tibi jawen Templo anuxun Dios kenwankubainibukiaki. Jatiski, Teófiloon, na kakape en mia kene keyuxunxudan. Lucas");
INSERT INTO cbsNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bawakin taewadiama Diosun Shinain Janchati Epa Diosbe jiwea jabiaska dabes Dios ipaunibukiaki, niti ikamadan. Jakidi matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","3","Bai taei yuda jayadiama jabias jawen Shinain Janchati Diosbe yubakatan jabetan dasibi damiwakin keyunikiaki. Dasibi damiwakin jabe paxkama jiwea jauma Diosun jawa wadiama jakia jawen Shinain Janchatibetan dasibi betsa betsapa damiwanun ixun damiwakin keyunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jaska inun, jawen Shinain Janchati xaba keskatun chanima jancha jiwekuiankidi jatu shinanmai ");
INSERT INTO cbsNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","jubiaken chakabu shinankin yudabu meshu medan nia keskabun chanima jancha ninkakatsi ikama ja xaba jiwemanika bextekin nemanun ibiakin atidubuma inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Janua jawen Shinain Janchatin yusinkin taewadiama juni betsa jawen kena Juan Diosun yunua ");
INSERT INTO cbsNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","jawen Shinain Janchatikidi jau dasibibun ninkakin ikunwanxanunbun bebunkidi jatu yui juniki, Juanan. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jaskawen taea Juanan, Diosun Shinain Janchatimaki. Jakia ja chanima jancha jakidi jau jatu yusinyunun Diosun Juan yununiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Januxun xaba keskatun jiwekuiankidi yusin jatu unanmai ");
INSERT INTO cbsNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","mai damiwani anu jua jatube jiwea jawen yusian jabun jawen jancha ninkama jatu jawenawakin damiwabiani Diosun Shinain Janchati midimabun unanma inibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jaska inun, Diosun Shinain Janchati jawenabu anu juken jabia jawenabundi jawen jancha ninkama jabun beya wama danainbun ");
INSERT INTO cbsNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","jakia jatiditun jawen jancha ninkatan ikunwankin beya waibun Diosun Shinain Janchatin jau Diosun bakebu ixanunbun jawen kushipa jatu inankin jatu duawakin taewaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jaska inun, Diosun jawen bakebu jatu pepa wakinan, chutakin akama inun yudabun shinanwen akama jakia Diosun jawen kushipawen besti jawen bakebu wakin jatu jiwekuinmakin taewaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Janua jawen Shinain Janchati yuda kayabi jayanun ika ainbu medanu naneima kaian Diosun bake bestichai ewatan nuku anua yumetan ewani jiwea jawen Epa Dios itsa kushipa duapajaida nun uinpauniki, nuikipa jaya inun chani chakatima jancha jayadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jaska inun, jawen Shinain Janchati Juanen Jesús unantan Juan ninkai beabu jancha kushipawen jatu yuikin: —“Ja dukun jiweniwen taea ea kachu kainbiaimaxun ea binuyuxanikiki, xanen ibujaidakinan”, akin jaskakidi en matu yuikubainaii— akin Jesúskidi Juan janchaxunkunkainiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Diosun dasibi pepa nuku inantiduwen taea nukuwen nuikin nuku tibi jawen aka kushipa tibi betsa betsapa nuku inan akeakemiski, chakabu katumamadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jaskawen taexun bebunkidi Diosun Moiséswen jawen jancha nun ja chibanun nuku yununiki. Jakia chanima jancha jaya inun jawen nui bechipainameti kayabi juidan, janua nun binun Jesucristowen taea besti juaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ja inun, natian tsuabunda Dios uinakamabiaken jawen bake bestichai Diosbe janchanameai Dios ja keskajaidadi jawen Epabe ketaxamexun xabakabi jatun besti Dioskidi nuku unanmakubainiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jaska Nashimanika Juanen Jesúskidi jatu unanmani en matu yuiai ninkakanwen. Jerusalén anuabun Juan kakaya judio mae xanen ibubun jau Juan yuka tapintanunbun Diosbe nukunabu janchaxunikabu inun Jacobun bake Levín baba betsabu jabu yunuabu Nashimanika Juan anu bexun jatun xanen ibubu yukaxunkin: —¿Miadan, min tsuamen? ¿Min Mesías Cristomen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","jatu padanma yuikin: —En ea Mesías Cristomaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—Min tsuadaka, Dios janchaxunika Elías kanidan, ¿min jamen?— akabu —En jamadiki— jatu wa —“Diosun jancha yuixunika kushipa ea keska juxanikiki”, akin Moisin yuinidan, ¿min jamenkain?— akabu —En jamadiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Jabun nuku yunushinabu jadi nun jatu yuitanun, miadan, min tsuamenkain nuku yuiwe, mikidi nuku yunushinabu nun jatu yuitanunan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","januxun Nashimanika Juanen jatu yuikin: —Jaskakidi Dios janchaxunika Isaíasin keneni keskadan: “Janu tsua jiweabumanuxun jancha kushipawen jatu yuikin: ‘Nukun Xanen Ibu nai anua matuki bayui ma kemaikiki. Matun juintinin shinan pewadikanwen, bai kayatapia keska wakinan’ ”, akin kenenidan, en jaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","janu jau Juanbe janchatanunbun fariseobun jatu yunushinabun ana yuikin: —Min Mesías Cristomadaka. Min Elíasmadaka. Min Diosun jancha yuixunika betsamadaka. ¿Jaskakenan, jawawen taexun daka min jatu nashimakubaini ikai, miki chiti ikabu jatu wakinan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","januxun Jesúskidi Juanen jatu yuikin: —Chanima jenewen besti en jatu nashimakubainaii. Jamen ea dukun en kainbianiken ja juni betsa matube jiwebia man unandiamadan, jawen kushipawen ea binujaidaki. Jaskawen taea eadan, jawen tsumapan jawen daya axunmis keska wakin en jawen jawaumajaidatun ean medabewakin jawen bichi tae mexpun tsitsauxun en pekaxuntidumaki— ikin ");
INSERT INTO cbsNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jordán jene kexa betsaudi Betania anuxun Juanen jatu nashimakubaini jadia jaska janchakin yuikubainiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Janua uxashini bestentan maniabun Jesús juai chaima bechitan metukin Juanen jatu yuikin: —Uinkanwen. Dios daewakin jatun chaxuwan bake menumisbu keska wai yudabu dasibibun chakabu jatun jatu buaxunkin Dios nuku daewaxunti ma juikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jakidi jabias matu yuinun, ninkakanwen: “Ja dukun jiweni ea kachu kainbianixun ea binuxanikiki, xanen ibujaidakinan”, iwanan, en matu yuishinaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","34","Ja inun, man Israelbun ja juni unankin man shinan betsa waxanunbun matu unanmakin jenewen nashimakin en matu taewaimaki, ja juni eandi en unandiamabiadan. Jakia ea yununitun ea xabakabi yuikin: “Ja juniki Yushin Pepa jaki butua jaki matsaume min uinxanaidan, jabiatundi Yushin Pepawen jatu nashimaxanikiki”, ea washinken chanima ja juniki nai anua deiwan keska Diosun Yushin butua ja juni mamaki bashikuai en uinmaki. Jaskawen taexun: “Ja juni Diosun Bakeki”, akin en matu yuiaii— akin Nashimanika Juanen jatu yuitan ");
INSERT INTO cbsNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","janua ana uxashini Nashimanika Juan jawen tsumabu betsa dabebe nixun ");
INSERT INTO cbsNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús kauanai uinkin nuku yuikin: —Uinkanwen. Jatun Dios sinatai daewanikaki, chaxuwan bake menumisbu keskadan— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ninkatan ja dabe nun Juanen tsumabia Jesús chibanbaintanun ika shinain nun kaya ");
INSERT INTO cbsNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","niti itan dabekekaun nuku uinkin yukakin: —¿Man jawa benayuai?— nuku wa —Yusinaan, ¿min jani jiwea ikai?— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Ebe kaxun uin bukanwen!— nuku wa jabe kai janu jiwea anu nun jabe jikia ma 4:00 badi jikitushitan nun jabe janchaya ");
INSERT INTO cbsNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Nashimanika Juanen jancha ninkatan Andrésin Jesús chibanbaina jabe janchatan jawaida jawen betsa Simón Pedro yuinun ika benabaunkin bechitan yuikin: —Mesías Cristoki nun nukuxuki. Min tsidi uin kawe— itan ");
INSERT INTO cbsNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","januxun Jesús anu Andrésin Simón iyua januxun Jesúsun uinkin dais butan butankin yuikin: —Miadan, min Juanen bakeki. Min Simónbiaken en mia kena dabeya waii. Cefas wakin mia kenaxankanikiki— aniki. Cefasdan, nawan janchawenan, Pedroki. Pedrodan juni kuin janchawenan, Mishki Ewapaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ana uxashini Galilea mae pakea anu Jesús kanun ika yubakashina kai Felipeki nukutan Jesúsun yuikin: —Tapin ebe kakunkainwen— aka —Peki— ikaini ");
INSERT INTO cbsNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ja Felipen maedan, Betsaidadan, jabianudi Pedro inun Andrés jiwediaken Galilea anu nun Jesúsbe kai nun jikiken ");
INSERT INTO cbsNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipen jawen jaibu Natanael benakin jawen jiwe anu kaxun yuikin: —Baa, mia yuinun, ea ninkawe. Jakidi Moisin inun Diosun jancha yuixunikabun kenenibudan, nun ma jaki nukushinaki, Josén bake Jesúsdan. Jawen mae Nazaretki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelin yuikin: —Ja mae Nazaret anua tsua duapa taxnitidumaki— aka —Ebe kaxun ibubis uinkin unanyuwe— atan iwea ");
INSERT INTO cbsNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael Felipebe juai uinkin Jesúsun nuku yuikin: —Uinkanwen, ja Israelin baba kayabitun tsua jatu padainsmadan— nuku wai ");
INSERT INTO cbsNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","jawen jancha ninkabidan Natanaelin Jesús yukakin: —¿Jaskakin janixun ea uinmisxun min ea unain?— aka Jesúsun Nataniel yuikin: —Felipen mia kenadiama miban higuera ji naman tsauxun min shinain en mia unanxuki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ikunwankin yuikin: —Yusinaan, chanima min Diosun bake kayabiki, Israelbun xanen ibu dasibi binuadan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","51","Jesúsun ana yuikin: —“Miban higuera naman tsauxun min shinain en mia unanxuki”, akin en mia yuiaiwen taexun min ea ikunwaiin. Ana pepa betsa shadabu en binumai min ea uinxanaii— iwanan, ana yuikin: —Chanima en matu yuiaii. Nai bepemanai anua en matun Juchi Kayabi Iyua ea anu Diosun nai tsumabu inabainbaini butubidanbidanaibu uinkin Diosun kushipa man uinxanaii— akin nuku yuiniki, Jesúsunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jesúsun ja dukun damiwakin taewani matu yuinun ninkakanwen. Ana uxashini Caná mae Galilea anu ainyain nawaibu anu jatu medabewai Jesúsun ewa juken ");
INSERT INTO cbsNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","nun Jesúsun tsumabu Jesúsbe nukudi iabu ");
INSERT INTO cbsNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","uva vino akin netsuaibun jawen ewan ja dukuntun unankin Jesús yuikin: —Kukaan, vino ma netsuabuki. Ana jatu bena waxunwen— aka Jesúsun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ewaan, mia inun eanan jaskas nun shinanmaki. Diosun ea jatu unanmaxanaidan, idiamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","jawen ewan ja jabun jatu pimai yuikin: —Matu yunuayadan, axunkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dios pexuni pidiama judiobu jaki mepanumisbuwen taea dintu betsa anu mishki shumuwan 50 kasmai 70 litro unpax mata wati tiubus 6 shumuwan xaka sedea ");
INSERT INTO cbsNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesúsun uinkin jatu yuikin: —Ja 6 mishki shumuwan tibiki unpax manekin mata wakanwen— jatu wa shumuwan tibi mata wakin bupakemaibun: ");
INSERT INTO cbsNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Jesúsun ana jatu yunukin: —Natianan, kenchawen beaishtabain ja jatun jatu besimai xanen ibu anu buxuntankanwen, jau menunan— jatu wa ma damia unankin ja dayakapabu betsan beatan buxuanbu jaskatan unpax damixu unanma ja jatun jatu besimai xanen ibun metan jania bekanxu unanma ja xanen ibun juni ainyain kenaxun ");
INSERT INTO cbsNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yuikin: —Nawai taekin jabu dukun vino pepa jatu ama netsui bechantu bestia benimaibun ana pe bexmas jatu amamisbuki. Jakia mianan, pepajaida aduxun ikis min jatu taxnimaxunaii— aka jatu inanbaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","jaska wakin Caná Galilea anuxun dami atimaska taewakin Jesúsun jawen kushipa nuku uinmakin taewaya jawen tsumabun eskadabes ikunwankin nun taewaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Januxun jatu jaska waxuntan Cafarnaúm anu jawen ewa inun jawen betsabube Jesúsbe nun bai kashian jiweyuabun ");
INSERT INTO cbsNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","janua Pascuatian janu nai tsuman detekin debu wanikatun nukun xenipabu dunkebaini shinain besinun ika judiobu mae tibi anua ma bea kemaibun Jerusalén anu Jesúsbetan nun uin ka ");
INSERT INTO cbsNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","januxun Templo jemaintin anuxun ina awa inun, chaxuwan inun, deiwanwen Dios kenwankin menu keyuti juni betsabu inananainbu inun pei biananain tsauabu Jesúsun bechitushitan ");
INSERT INTO cbsNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","16","jaska waibu jatu uinkin bechipaiama bichi kapikunkin mayatan jabu inayabu jatu kusha kusha atankin Templo jemaintin anuadi jatu nichin keyukin janua pei biananainbudi jatun tapu nadabekin pei jexe jatu sa akankin deiwan inananainbu yuikin: —Matun inabu inun matun mabu dasibiya nenua taxnidibainkanwen. En Epa Diosun jiwedan, janua ana jamapai inanananyamakanwen— jatu wa datei kaiin xadakabainbainaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesúsun jaska wai uinkin jaska nukun xenipabu Davidin Jesúskidi yuikin: “Dios kenwanti jiwewen taea jawa dateama naxukui sinatakin en yaushixanaii”, akin keneni atimas nun shinanyan ");
INSERT INTO cbsNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","judio xanen ibubu bexun Jesús yukakin: —¿Min jaska waxudan, pemen? Ja kushipawen min jatu akaidan, jawen nun mia unanti wanun jawada dami atimaska wakin nuku axunwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","junea janchawen jatu yuikin: —Na mishki jiwe man tekekin keyuadan, xaba dabe inun besti kaya ana en benixanaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","jaska janchaiwen taexun mishki jiwe shinankin xanen ibubun Jesús ja akin yuikin: —46 año dayakunkainkin na Templo menediabumaki. ¿Jaska watan xaba dabe inun besti min ana benikin bena watidumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","jakia jawen yuda jiwe keskakidi Jesúsun shinaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Janua Jesús mawa ana bestenshinken: “Xaba dabe inun besti kaya ana en benixanaii”, jatu wani nun shinainwen taexun jakidi jaska tibi kenenibu inun Jesúsun nuku yusinidi shinankin nun ikunwaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Janua Jerusalén anu jabias Pascuatian dami atimaska wakin jawen kushipa Jesúsun jatu unanmaiwen taexun yuda ichapabun uinkin ikunwankin taewaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","jakia jaska yudabun jakidi shinankin jawada akaiwen besti benimaibu Jesúsun jawa jatu unanmayuama yudabun shinan mesten jayabuma dasibi jatu unainwen taea: “En Mesías Cristoki”, ikin bebunkidi xabakabi Jesúsun jatu unanmayuama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Janua judiobun ichati jiwe xanen ibu betsa fariseo Nicodemo meshu medan june Jesúsbe janchai kaxun yuikin: —Yusinaan, Diosun mia medabewamadan, min dami atimaska atidumaki. Jaskakenan, Dios anua yusinanan, min miaki, en unanan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesúsun ana yuikin: —Chanima en mia yuiaii. Tsuada ana kain benama Dios xanen ibuai anu ka jiwetidumaki. Jakia ana kain benatan Dios xanen ibuaibe jiwexankanikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemon Jesús ninkama ana yukakin: —¿Jaskai yuda ewabia jaskatan ana kaintidumen? ¿Jawen ewan baken nantiki nanetan ana jaska jikikaintani ana kaintidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","januxun Jesúsun yuikin: —Jaskamaki. Chanima en mia yuiai ninkawe. Yuda kayabi medanua kaianan, yuda kayabi ikubainmisbuki. Ja inun, Yushin Pepatun kain benamatan jatuki jikitan jatu yaushikin mekekubainmiski. Ja inun, jene inun Yushin Pepawen nashiabumadan, Dios xanen ibuaiki man nukutidubumaki. Jakia ja dabewen pepakubainaibu jaki man dasitidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jaskaken: “Jau dasibibu ana kain benanunbunwen”, iwanan, akin en mia yuia shinain: “¿Jaskada betsajaidamen?” iki jabaa! iyamawe. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jaska inun, niwe jaikaimas xunku iki danka imiski. Jakia jawen jui ninkakin janiada juai inun janida kai min unanmaki. Yushin Pepatun tsuada yuda betsa bena waidan, jaska keskadiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemon ninkai tapianmajaida ana yukakin: —¿Jaskatidumen, na jaska min yuiaidan?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Israelbu yusinbiamis ¿jaskakin en mia yuiai min ninkamamen, tapinbainamadan?— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Chanima en mia yuiaii. Eskaki, mia yuinun ninkawe. Nukun uinkin inun tapinmisxun Nashimanika Juan inun ean nun matu yusinmiski. Jakia nukun jancha danankin nukukidi xabakabi man shinanbumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jaskaken yudabukidi en matu yuikubainai en jancha man ikunwanbumawen taexun Dios anua jamapaikidi en matu yuiaidi man ikunwantidubumadiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jaska inun, Dioskidi unantanun ika Dios anu tsua inatidumaki. Jakia eadan, matun Juchi Kayabi Iyuatun matu unanmai Dios anua jua en taxniniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Jaska inun, Diosun nukun xenipabu yusinkin unanti wamanikidi mia shinanmanun ninkawe. Janu tsua jiweabuma anu Moisin jatu iyuima janus nukun xenipabu jiwea akeakeakin jawen jancha ninkabumaken Diosun jatu kupinun, iwanan, dunu midima ichawaxun jatu pima isin teneaibun Diosun Moisés yunua mane damiwakin dunu itsa waxun jiki netanxun nichian tsuanda uinkin ikunwain xuxanibuki. Jabiaskadi wakin Diosun ea yubani keyukin jiki matun Juchi Kayabi Iyua ea mastanxun ea benitan ea nichinxankanikiki. Jaskawen taexun tsuabunda ea ikunwankin shinain ebe jiwexankanikiki, niti ikamadan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jesúsun ana Nicodemo shinanmakin yuikin: —Yuda betsa betsapa dasibi jiwebaunabuwen nuijaidakin Diosun eska shinantan ea jawen bake bestichai yununkin taxnimaniwen taexun tsuabunda ea ikunwankin jawen jiwea kayabi benutima bitan mawa kayabiama Diosbe jiwekuinxankanikiki, ikibi ikidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Januxun jau ewen taexun yudabu jatu kupixanun, iwanan, Diosun ea jawen bake bestichai ea taxnimama iniki. Jakia Dios daewakin jau ewen dabanan matun chakabu buaxunkubainxanun, iwanan, Diosun ea jawen bake bestichai taxnimaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jaskaken tsuanda Diosun bake ikunwainbu Diosun kupiamaki. Jakia tsuanda jawen bake bestichai ikunwanmawen taexun Diosun jatu danantan kupixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Yudabu jamapai chakabuwen kemui bechipaikin jenekatsi ikama Diosun jancha xaba keska dananmisbuki. Januxun jatun shinan chakabuwen taexun Diosun jatu kupinun, iwanan, jawen jancha xaba keska yunukin taxnimaniki. Jaskawen taexun tsuan jawa ninkama jawen bake danankin chakabuwen besti kemumisbu Diosun jatu kupijaidaxanikiki, niti ikamadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jakia tsuabunda Diosun jancha xaba keska ea ninkatan betsabu unanmakin jancha chanima yusinkubainmisbun jabun Diosun shinain keska chibankin ea ikunwanmisbuki— aniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jerusalén anua jancha menetan Jesús nukube Judea mai pakea anu kaxun nuku yusianyan betsabun Jesús janchai ikunwankin taewaibu nun jatu nashimakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","janu jaskaitiandi Juan achixun bichidiabuma janu Jordán jene netsuisma anuxun mae betsa Salim dapi Enón anuxun Nashimanika Juanen jancha ninkanun ika beabu jabun jawen yusian ninkatan jatun shinan betsa wakin ikunwainbu jatu nashimadiakubainaya: ");
INSERT INTO cbsNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","“Ja beya unpaxwen chukikin Dios xabakabi uinmai nun pepamiski”, ikin shinain judio yusinan betsabe Juanen tsuma betsabu jatun beyawen taea ja iki yuinamei menetan ");
INSERT INTO cbsNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juan yuinun ika jawen tsumabu buxun yuikin: —Yusinaan, Jordán jene kexa betsaudixun nuku yusinkin jakidi min nuku kenwainmatunan, jatundi dasibi jawenabu wakin jatu nashimaya ninkatan bechibain jadi chibankanikiki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juanen jatu yuikin: —Juni betsa Diosun yunuama xanen ibu kayabi itidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jerusalén anua bexun ea yukaibu xabakabi chanima jatu yuikin: “Eadan, en Cristo Mesíasmaki. Jamen eadan, bebunkidi jakidi en chaninun Diosun ea yununiki”, akin en jatu yuiai man ninkaimadan, shinankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ja inun, junin chipash bitan ainwanan, ja besti jawen beneki. Jakia jawen bene benimai jawen ainbe janchai ninkatan jawen jaibuaibudi benimachakayamamisbu keskai eandi Jesús jaskai ninkatan en benimajaidadiaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jaska inun, jawen kushipawen ea binuin Jesús kushipaya janua eadan, en kushipa bextekei en bexmasaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","32","ana jabias shinanwen Juanen jatu yuikin: —Tsuada mai anua baadan, mai anu jiwexun jaska dasibi mai anuadi tapin janchamisbuki. Jakia ja junidan, Dios anua taxninixun yudabu dasibi binukin Dios anua ninkakin uintan jaska chanibiaya tsuan jawa ninkama danankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jakia tsuabunda jawen bake dananma “Dios chani chakaismaki”, ikin jawen jancha mestenwanmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Januxun jawen bake yunukin jawen Yushin Pepa keyuisma inankubainmiswen taexun Diosun bake ja yununitun jawen jancha yuimiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Epa Diosun jawen bake bechipaikin jau dasibi ibuai xanen ibuxanun jawen kushipa dasibi inaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jaska inun, tsuabunda jawen bake ikunwankin chibainbu jiwekuinxankanikiki, ikibi ikidan. Jakia jawen bake danankin ikunwanbuma jatu danandiakin Dios jaki sinatakin jiwekuinmama jatu kupikubainxanikiki, jiwe chakamakinan— iniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Juan binunkin Jesúsun yuda ichapa jaki chiti ikabu wakin jatun jatu nashimamabiaken nun jawen tsumabun jatu nashimapakebiaya ichati jiwe xanen ibu fariseobun ninkai jaki sinataibu Jesúsun ninkatan jatube ja ikatsi ikama ");
INSERT INTO cbsNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","jaska ninkabaini nukubetan Judea jenebaini Galilea anu ana kai Samaria mai pakea dunkemisbu ana janu kama dainbainkin napaibainun ika kai ");
INSERT INTO cbsNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","maewan betsa Sicar dapi Jacobun jawen bai jawen bake José yununi anu unpax bana kini anua dispiwen biti Jacobun jatu pukinmaniki kemai ma badi manananbi kemaya jin iki unpax bana kini dapi Jesús tsauken ");
INSERT INTO cbsNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sicar maewan anua piti bixuin nun kaken Samarianawa ainbu betsa juxun unpax biai Jesúsun yukakin: —Min unpax biaidan, ea amawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","judiobu Samarianawabube janchaisbumawen taea e itan ainbun yuikin: —En Samarianawaki. Miadan, min judioki. ¿Jaskakin min ea unpax ea akai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesúsun yuikin: —Jawada Diosun mia inankatsi ikai inun tsuanda mia unpax yukai unankin min ea yuka unpax netsuisma en mia inankeanxuki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","12","ainbundi yuikin: —Xanen ibuun, na unpax kini pukinkinan, nukun xenipabu Jacobun anixun jawen bakebu inun jawen inabubetan apaunibudan, nuku jenexunbainiki. Jaska nuku axunbainiwen taexun nukun xenipabu Jacob kushipadan, ¿min binuanmen? Ja dikabi na kini keyatapajaidaki. Shumu inun dispi chaipa min jayamaki. Unpax netsuismadan, ¿jania jawawen bitan min ea inantidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Tsuabunda na unpax kini anua biwanxun atan jawenchains tetsusinkin ana manuxankanikiki— iwanan, jancha juneawen ana yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—Jakia tsuabunda unpax en inain atanan, ana tetsusini manuama ixankanikiki. Jabu tibi medan chacha unpax netsuisma keskatun jatu jiwekuinmaxanikiki, ikibi imakinan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ainbun ninkabiakin Diosun Yushin Pepakidi janchai unanma ana yukakin: —Xanen ibuun, ana tetsusini unpax manuama en ana unpax bi bika tenekidankidanyamaxanun ja unpax netsuisma min ea yuiaidan, menan ea inandiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Peki. Jaskakenan ja dukun min bene iyutanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—En bene jayamaki— aka —“En bene jayamaki”, ikin min chanima yuiaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ja dukun 5 min beneyabiakunkainmis natian juni betsabe min jiweadan, chanima min bene kayabimaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ninkai e iki teku iki juinti metexeketan yuikin: —Xanen ibuun, min Diosun jancha yuixunika en mia ninkaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na mati anuxun nukun xenipabun Dios kenwankin taewapaunibuwen taexun nun Samaritanobun jabianuxundi nun kenwandiamisbuki. Jakia: “Jerusalén anuxun besti jau Dios kenwanunbunwen”, ikin man judiobun yuimiski. ¿Jadatu kenwanti kayabi pemenkain? ea yuiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Ainbuun, ea ninkaidawe. Na mati inun Jerusalén anu kama jani ana kama man Epa Dios kenwanxanai ma kemaikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jakia unandiamabia Epa Dios man kenwanmiski. Jamen nun judiobu anu Dios medabenan juxanaiwen taexun unankin kaneama nun Dios kenwan kayabimiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Diosdan, yushinki, yuda kayabimadan. Jaska inun, jawen Yushin Pepatun jatu medabewakin shinanmaya Diosun yuini chanima unankin ikunwan kayabixanaibun Epa Dios duawakin kenwanxankanikiki, benimawakinan. Jaskawen taea na jabiatian ma jaska Diosun bechipai chanima man kenwankin taewaxanai ma taeikiki, Epa Diosun jawen Yushin Pepatun medabewayadan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ainbun yuikin: —En unaiin, ja Mesías Cristo juxun dasibi nuku unanmaxanaidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesúsun yuikin: —Na jabia en mibe janchaidan, en jabiaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","jaska watanayas nun jawen tsumabu nidi itushikin Jesús ainbube janchai bextetushi e itan: —¿Jaskai ainbube janchaimenkain? ¿Jawa yukai jabe janchai ixumen?— ikin nun yukatidububia nun jawa yukabumaken ");
INSERT INTO cbsNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","ainbu jawen shumu jenebaini jawen mae anu kaxun yudabu yuikin: —Ebe kaxun uin bukanwen. Dasibi en ipauni ea yui keyuxuki, Mesías Cristomenkainan— jatu wa jawen jancha ikunwankin ninkabidani ");
INSERT INTO cbsNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","jatun mae anua dasibi Jesús anu bei natsekebidani taeaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ja jaskaibun nun jawen tsumabun Jesús yuikin: —Yusinaan, nun mia piti bixuntanxudan, menan pidiwe— nun akanwan ");
INSERT INTO cbsNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Piti betsa man unandiama en jayaki— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","yuinamei: —Janixun juni betsan piti bexun ¿pima ikimenkain?— nun ikaya ");
INSERT INTO cbsNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesúsun nuku ana yuikin: —Jatun ea yununitun shinan en jayawen taea jawen daya keyui en kushipamiski, yani wa keskaidan ");
INSERT INTO cbsNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—iwanan, ana nuku yuikin: —Matun bai man banashina uinkin yuikin: “Ana uxe dabe inun dabe ka bimi jushian nun tsekaxanaii”, iwanan, man shinanbiaya ana matu yusinun ninkakanwen. Diosun bai kaiskin uinkanwen. Ma janu ikunwainbu ichawati peki. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tsuabunda jatu ichawakin jawen manakuti pepa bikanikiki, jatun jiwea ikibi ika bikinan. Jaskaken tsuabunda miban bana bimi jushiain jatu tseka keska waibudan, jabudi benimakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jaska inun, juni betsan banaima juni betsadi juxun tsekamiski, iwanan, nun yuimisdan, chanima janchaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jaska inun, janiada dayakin Diosun jancha banaimabu ikunwainbu man ichawa bestinunbun en matu yunuxanaii. Jaska inun, betsabu dayai taeimabun natiandi matundi jawa bika teneama ichawa bestikin man keyuxanaii, jatube benimakinan— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","januxun ainbun jatu yuiaiwen taexun jawen mae anuxun Samarianawabu ichapabun ikunwain Jesús anu ");
INSERT INTO cbsNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","bexun uinkin yuikin: —Nukuki bayuwe— akabu januxun Jesúsun yusin uxa dabei jatu anu bashikua ");
INSERT INTO cbsNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","jawen jancha ana ichapabun ikunwankin taewakin ");
INSERT INTO cbsNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ainbu yuikin: —Ja dukun min jancha besti ninkatan mia chibanbaini kaxun nun uinshinaki. Janua chanima kayabi ibubis nukunmebi jawen janchadi ninkatan Jesúsun yudabu dasibi Mekenika Mesías Cristodan, natian nun ikunwaiin— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","januxun: “Diosun jancha yuixunikadan, jawen mae anuxun yusianyan jawenabuns kenwainsbumaki”, imisxun Jesúsun jamebi jatu kenwanmakatsi ikama uxa dabetan janua ana kai ");
INSERT INTO cbsNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea mae pakea anu jikia Jerusalén anu Pascua nawai besiaibutian jabun uin kaxun Jesúsun dami atimaska akai uinshinabuwen taexun ikin pewa wani jaki benimajaidakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","januxun Caná mae Galilea anuxun unpax dami waimanu Jesús ana chintunkain jikiaya jabiatiandi Herodesin ja dayaxunmis xanen ibu betsan mae Cafarnaúm anua jawen juni bake isin teneaya ");
INSERT INTO cbsNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesús Judea anua Galilea anu ana chintunkidan jikiai ninkatan janu kaxun uinkin ea akin yuikin: —Yusinaan, en juni bake mawakatsis ikikiki. En jiwe anu ebe kaxun ea xuxawaxunyuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesúsun yuikin: —Matunan, jawen unanmati dami atimaska en akai uianma man ea daki ikunwanbumaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","jawen bakewen nuimanun, iwanan, Jesús daewakin yuikin: —Xanen ibuun, jaskamaki. Janun en bake mawanun jawaida ea xuxawaxuin kawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","jawen nuikin Jesúsundi yuikin: —Nenua chintunkaini min jiwe anu kadiwe, min bakedan, mawama jiweakidan— aka ja junin Jesúsun jancha ikunwanbaini jawen jiwekidi kai ");
INSERT INTO cbsNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","janida bai puchinin uxashini jawen jiwekidi kaya unudiadi jawen tsumabu bei jaki nukuxun yuikin: —Min bakedan, ma ana jiweaki— atushiabu ");
INSERT INTO cbsNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ninkatan jatu yukakin: —¿Jatian jaskai xuxai taeshinamen?— jatu wa —Uatian ma badi kapukeaya a la 1:00 jawen yuna mainshinaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","jabianudi: “Min bake mawama ana jiweaki”, Jesúsun ashian jabiaskadi nakushxunaibuwen taea jikitushitan jatu yuia jawenabubetans Jesús ikunwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na jaska ana ja kachu juni bake xuxawakinan, tsuan jaska watiduma Jesúsun akinan, Judea anua chintunkidan Galilea anu jikitushishinxun ana jabianuxundi jaska waniki, jawen unanmati dami ja kachu ana akinan. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Galilea anuxun Jesúsun juni bake xuxawaima ana betsatian Jerusalén anuxun judiobun jatun beya betsa chibain besi nawaibu anu Jesús ana chintunkaini kakin ");
INSERT INTO cbsNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","4","januxun Jerusalén mae mishkiwen kenebaunibu janu jikiti xui jawen kenadan, Chaxuwan Kaintidan, ja dapi janu unpax uke medan jabai anu mishki pukinibu anu unpax tsaua jawen kenadan, Betzatádan, janu utai juindukunmisbu anu 5 utati anu bekunbu inun, tidibu inun, meyushkibu inun, isin betsa betsapa tenei maniabu anu mishki pukinibu unpax mata nai tsuman shubimaya: “Ea dukun ka en pukua en xuxatiduki”, iki maniabu anu ");
INSERT INTO cbsNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","juni betsa 38 año badi ka jawen yuda babuni ");
INSERT INTO cbsNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","daka Jesúsun bechitushitan badi ichapa ka isin teneai unankin yukakin: —¿Min yuda xuxai min ana kushipakatsis ikai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Jaa, Xanen Ibuun. Jakia nai tsumapan jene shubimai anu tsuan ea bakebain pukutimaken en unanxubida kaya isin teneai betsan ea maemai binukain jabu dukun pukukubainmisbuki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","jawen nuikin xuxawanun, iwanan, Jesúsun yuikin: —Jaskakenan, benitan min dakati iabaini kadiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","jawaida jawen yuda dakushi kayatan benikauan sábado juindukuntitian dayatimabiaken jabiatiandi jawen dakati iabainaiwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","judio xanen ibubun yukakin: —¿Jaskakin juindukuntitian min dakati iabainkin Moisin nuku nemani min chibanma kaneai?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Ea xuxawaxutun yunukin: “Min dakati iabaini kadiwe”, ea wa en kai ikaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Tsuan mia jaska yunuxumen?— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","janu ichabu anu Jesús jawaida nashui ikawen taexun jatun xuxawaxu unanma jadakidi jawa jatu yuitima nibai kaken ");
INSERT INTO cbsNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","chipu Jesús Templo jemaintin anu jaki ana nukuxun yuikin: —Uinwen, ikis en ma mia xuxawaxuki. Jaskaken chakabu shinankin Diosun jancha ana kaneyamaxanwen, min ana jamapai betsa kaneaidan, jawada chakabujaidawen min ana pikutidukidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ja juni jaska wa kaxun judio xanen ibubu jatu yuikin: —Na en xuxaxu man ea yukadan, Jesúsun ea akakiaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","juindukuntitian Jesúsun xuxawawen taea jaki sinatakin judio xanen ibubun Jesús danankin yuainbun ");
INSERT INTO cbsNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","jatun jancha ninkatan Jesúsun jatu yuikin: —En Epa Diosun jatu medabewai dayakunkainmiski. Eadi jabiaskadiai en dayadiakunkainaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ninkatan june judio xanen ibubu yuinamei: —Sábado juindukuntitian yununi kaneai bestimaki. Chakabu betsa wadiai jamebi Dios keskakatsis ikin yuikin: “Dios en Epaki”, ikin yuidiaikiki— ikaiwen taea jaki sinatajaidakin Jesús tenankatsis ichakayamaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesúsun ana jatu yuikin: —Chanima en matu yuiaii. Diosun baken jawen shinanen besti jaska atidumaki. Jakia jamapai shadabu Epa Diosun akai uinkin jabiaskadi wakin jawen bakendi adiatiduki. Jaskaken Epa Diosun shinanen ea jawen baken en adiaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jaska inun, Epa Diosun jawen bake bechipaikin dasibi akin uinmamiski. Jaska inun, ana kushipajaidawen dami atimaska betsa betsapa jawen bakewen matu uinmaya uin man e ikunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jaska inun, en Epa Diosun mawabu jiwemamiski. Jabiaskadi wakin jawen bakendi tsuabuda katutan jatu jiwekuinmadiatiduki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Jaskawen taexun tsuada Epa Diosun unanti waismaki. Jakia jau dasibibu jawen baken jatu unanti waxanun jawen kushipa inani jayaki. Jaskawen taexun jabias Dios kenwanmisbu keska wakin jawen bakedi jau kenwanxanunbunan. Tsuabunda jawen bake ma yununi kenwanbumadan jaskatan jawen Epadi kenwan kayabitidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Chanima en matu yuikubainaii. Tsuanda ea ninka pewai jawen jiwea chakabukidi kai bexteketan jatun ea yununidi ikunwain jiwekuinkanikiki, ikisdan. Bikawen unanti wama mawa kayabi tenemama jiwekuiainbu chakabuwen nun kupiama ixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","26","Chanima ana en matu yuiaii. En Epa Diosun jawen jiwemati kushipa jamebi jayatun jabias ea inaniki. Jaskaken janu badi jawen jeneaitian mawabun en jui ninkatan bestein ana jiwexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","En matun Juchi Kayabi Iyuawen taexun dasibi unanti kushipa en Epa Diosun ea yunudianiki, ean en jatu unanti wa akeakexanunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na jaska jancha en matu yuiai ninkatan e iyamakanwen. Jaskaxanai matu yuinun ninkakanwen. Mawanibu dasibi en jui kushipawen en jatu kena ninkatan ");
INSERT INTO cbsNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mai anua janida jatu maiwanibu taxnibidanxankanikiki. Pepabu jiwekuiainbun jabu chakabumisbu ana bestenbiatan ana jawendi kai bika tenejaidai ikibi ixankanikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesúsun xanen ibubu jatu ninkamakubainkin yuikin: —Eadan, ibubis e iskaun en shinanen en ikamaki. Jakia jaska en Epa Diosun ea yunuai besti ninkatan en akubainaii. Jaska jawen pepa ea katumaidan, en jaska shinainwen en akama jakia jaska en Epan ea yununitun bechipaiai jaska yunuaya unanti wakin en axunkubainaii, kaneamadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Emebi en keanyanan, en jancha chani ikeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jakia tsuabunda ekidi unanti watan ea kenwainan, jawen janchadan, pepaki, jaska unainan. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nashimanika Juan Mesíaskidi man yukatanima chanima jakidi matu yuimaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jau tsuabunda man ea kenwanxanunbun, iwanan, en jaskakidi shinanmaki. Jakia janu kupiaitian Diosun jau matu kupiyamaxanun na kaka pepa en matu yuiai ninkatan man benuama ixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jaska inun, Juan bin ewapa dekua ji ikin chaxawa keskaxun matu yusiain ninkai uxe eskadabes jawen yusian bechipai man benimakunkainimaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jamen Epa Diosun ea yununidan, jawen kushipawen dami atimaska wakin en matu uinmaiwen taexun man ea unanti wakin tapintidubuki, Diosun ea yununidan. Jaskaken ekidi jawen unanmati jancha Juanen matu yusinmaki. Jakia eanan, atimaska betsa betsapa wakin jaska Juanen aisma akin en binuaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ja inun, Dios man uianma inun jawen jui man ninkaismabiaken jabiatundi ea yununitun ea unankin jawen jancha jatu kenemani anuxun ekidi jatu yuini man uinkubainmiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Jakia matu anu Epa Diosun ea yununi man ea uinkin ikunwanmawen taea jabiaskadi wakin jawen jancha uinkin shinain ja chibain man jawen jiweabumadiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jaskaken matunan, ja chibain jiwei ikibi iti jancha kenenibu bechinun, iwanan, Diosun jancha yuixunikabun kenenibu anua man benakubainmiski. Jakia jabias kenewen ekidi yuinibu uinbiakinan, ");
INSERT INTO cbsNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","jaskawen taea matun ea ikunwantan jiwekuinkatsi ikama man ea danaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Jawada pepa ekidi yuiaibu besti en ninkakatsi ikamaki, yudabun janchawenan. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jamen eanan, en matu unaiin, Dios nuimis keska jayama man ikunkainaidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Epa Diosun kushipaya en jubianiken shinan betsatan man ea ninkamaki. Jakia juni betsa jamebi kenkin yuiai ninkakin man chibanmiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jaska inun, matumebi ibubis man yudabu kenwanma bestikatsis imiski, ja besti Dios jatu kenwanmamadan. Jaskawen taexun man ea ikunwantidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jaska inun, Dios bebun nixun en matu ja axanai shinanyamakanwen. Jakia matun yusinan pejaida Moisés man ikunwain jatundi matu ja axanai shinain jakimayamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ja inun, Moisin ekidi keneniwen taexun Moisin jancha ikunwankin man ea ikunwandiakeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jakia jaska jatun keneni ikunwankin man chibanmadan, en janchadi man ikunwantidubumadiki— jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Janua jaskakainkin Pascuatian judiobu besikin pixanaibu ma kemaya Galilea Ianenwan, jawen kena betsa Tiberias Ianenwan anu Jesús nun jawen tsumabube pukexun jatu xuxawakin Jesúsun jawen unanmati dami atimaska betsa betsapa wai uinshinxun ana uinkatsis iki main bukin midimabun nuku chibainbun mati mapebain tsaua nukube janchabaikin ");
INSERT INTO cbsNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","yudabu ichapabun chibanbidanabu uinkin jawada akatsi unanbiakin Felipe unanti wakin Jesúsun yukakin: —Nabun jau pinunbun, ¿jania nun jatu misi bixuntidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","shinanma Felipen yuikin: —Bestibu tibitun jau misi eskadabe pinunbun 200 día nukun daya peidan, damaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","jaskai ninkatan jawen tsuma betsa Andrésin, Simón Pedron betsan, yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—5 misi inun 2 bakaishta juni baken nuku inantidukiaki. Jakia jatibun na misi eskadabes pikin jawa yani watidubumaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesúsun jatu yuikin: —Ja basiki jau tsuabaununbun jatu yunukanwen— nuku wa nun jatu yunua basi mamaki tsaui 5,000 junibu tsauabun ");
INSERT INTO cbsNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ja juni bake anua Jesúsun misi bitan Dios kenwantan misi tunkepakekin nuku inan ja tsauabu nun jatu inanbaunaya jabiaskadi wakin ja baka bitan tekepakekin nuku inandiaya nun jatu inan jati pikatsis ikin bitan ");
INSERT INTO cbsNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","pikin januxun yani wai pepeaibun Jesúsun jawen tsumabu nuku yunukin: —Ja piti texe waibu jau chakawayamanunbun ichawabaunkanwen— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ichawakin ja 5 misi pikin texeawabu 12 kuki nun mata waken ");
INSERT INTO cbsNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","jawen unanmati dami Jesúsun jatu axunxuwen taea uin yuinamei: —Chanima Diosun jancha yuixunika kayabiki, jaska Moisin yuinidan, ja junidan, jabiaki— ikubaunkin ");
INSERT INTO cbsNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","badikis xanen ibu wadinun, iwanan, achixun iyupananbu unantan jatu paxkabaini ana jawendi mati keyatapa mapebaini ja mesti jadi paxaxun shinanyui kaya ");
INSERT INTO cbsNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ma badi jikiaya nun jawen tsumabu ianenwan kexa anu butukin Jesús nun xununbidana judiamaken ");
INSERT INTO cbsNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","xaxun inatan Cafarnaúm anu nun kai besusi pukenun ika nun kai taeaya meshujaidaken Jesús chintundiama ");
INSERT INTO cbsNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","niwenwan bekin ian buspu tsaubidanbidankin jatu teawa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","jaimanwen tuenshini ma chaiskabui 5 kasmai 6 kilómetro nunuxun Jesús ian bepaikidanai uin nun datejaidaya ");
INSERT INTO cbsNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","nuku yuikin: —En eaki. Ewen dateyamakanwen— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ninkatan benimakin yuikin: —Nukube xaxun inayuwe— nun wa xaxun Jesús inaya niwewanen xaxu tsuma maianyan jawaida kain nun keti iniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Uxashini penaya ja yudabu ian kexa betsaudiabun shinain: —Jabia besti xaxuwen jawen tsumabun Jesús iyuama bushianbuki, xaxu betsa jayamabiakenan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","ja jaskaibun maewan betsa Tiberias anua xaxu betsawen bei januxun Jesúsun Dios kenwantan jatu pimashina anu keti itan Jesús inun jawen tsumabu jatu benakubidani jawa jatu bechiama ana jawendi butubidani jatun xaxuki inatan: “Cafarnaúm anu kashianmenkain. Jadi benanun bukanwen”, itan jaudi bui ");
INSERT INTO cbsNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ianenwan pukebaini kexa betsaudia janu ichati jiwe anu jatube ichanua Jesús bechitushitan jabun yukakin: —Yusinaan, ¿jatian min nekedi pukeshinamen? Ukedia nun mia benabidanaidan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesúsun jatu yuikin: —Man unanti wakin kayatapinun dami jaskabiama wakin en matu axuain uinshina ja tapinkin man shinanmawen taea jakia misi pikin yani washinxun jaskas pinun ixun man ea benai bei ikanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","¿Jaskai piti chapumiswen besti kemui man mapua ikanai? Jakia en Epa Diosun ea kushipa waniwen taexun jawen kushipa en matu inanxanai ja bestiwen kemui mapukanwen, jawen jiwekuin ikibi itidan. Jaskawen taexun jabia jawen unanmati wakin Epa Diosun ea matun Juchi Kayabi Iyua ea waniki, yunukinan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","jabun ninka pewama Jesús yukakin: —Diosun yunua axunkin chibankinan, ¿nun jaska wakin benimawakin taewatidumen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesúsun ana jatu yuikin: —Dios benimawakinan, jatun ea yununi besti ikunwankanwen, en eakidan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","betsabun ninkama ana yukakin: —Min Dios anuadan, nuku ikunwanmakatsidan, ¿jawa jawen unanmati min nuku axunkin kayati wamatidumen, nun mia jawen taexun ikunwanunbunan? Nukun yusinan Moiséskidi mia yuinun ninkawe. Janu tsua jiweabumanu nukun xenipabu jatu iyuyama jadi jiweabun Dios anua maná dudu butea pikubaunibuki. Jaska wanibu kenekin: “Pimakin nai anua Moisin misi jatu pimakubaunpauniki”, iniken damiwakin ¿Moisés min binua ikai?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Chanima nai anua misi butunidan, ja Moiséskidi man yuiaidan, jatun jatu pimama iniki. Jakia en Epa Diosun jatu pimakubaunpauniki. Jakia ikis nai anua jabiaskadi wakin misi kayabi en Epa Diosun matu inankatsis idiaikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ja misi Diosun yudabu dasibi inankatsi ikaidan, ja nai anua butunitun jatu dasibi jiwekuinmatiduki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","jawen jancha ninkabuma ana yukakin: —Xanen ibuun, jaskakenan na misidan, jawenchains nuku pimapakexanwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesúsun ana jatu yuikin: —Jiwekuinmati misidan, jabia en eaki. Tsuabunda ea ninkakin shinan betsa watan eki chiti ikaibu en jatun yushin kushipa wa ana buniama keska ixankanikiki. Ja inun, tsuabunda ea ikunwankin en jancha ninkakubainaibu en jatu shinan chankanwan ana unpax manui tetsusinama keska ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jaska en matu yuiai keska en akai uinbiashinxun man ea ikunwanbumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Jakia ea yununitun shinanen aki en juniki, emebi en shinanen aki juamadan. Jaskaken tsuabuda katuxun Epa Diosun ea anu jatu pexukin ekidi yunua ikunwankin ea jaibuwakubainxankanikiki. Ja inun, ea ikunwainbu en jatu danantaskama ixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ea yununitun shinanwen akinan, tsuabuda ea anu yununi jawen jeneai xabatian jatu benuama jatu bestenwankin en jatu taxnimaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dasibibun Diosun bake shinankubainkin ikunwain jiwekuian ma jayabuwen taexun jawen jeneai xabatian en jatu bestenwanxanaii, jaska en Epan shinain yubakani keska menexunkinan— jatu wakin ");
INSERT INTO cbsNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Dios anua misi butunidan, en eaki”, iki daketapai itsakin jatu yuiaiwen taea judio xanen ibubu june Jesúski ja ikin yuain ");
INSERT INTO cbsNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yuinamei: —Na junidan, Josén bakeki, Jesúsdan. Jawen ibu dabedan, nukun uinbuki. ¿Jaskai: “Dios anua en butuniki”, iki daketapaimenkain? —iake iakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","jatun shinan unantan Jesúsun jatu yuikin: —Matunan, jadi janchakin ana ea yuanyamakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","45","Epa Diosun ea yununitun jatu kenamadan, ea jaibuwatidubumaki. Jakia jatu kena ea ikunwainbu jawen jeneai xabatian en jatu bestenwanxanaii. Diosun jancha Isaíasin keneni matu yuinun ninkakanwen: ‘Diosun dasibi jatu yusinkin mextanmaxanikiki’, aniki. Jaskawen taexun tsuanda Diosun jancha ninkakin tapinkubainmisxunan, ea jaibuwakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Epa Dios tsuan man uinsmaki. Jakia Dios anua besti taxninitun Epa Dios uiniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","Jiwekuinmati misidan, jabia en eaki. Chanima tsuabunda ea ikunwain jiwekuinkanikiki, ikibi ikidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ja inun, janu tsua jiweabumanuxun Dios anua misi matun xenipabun pibiakubaini atimas bika tenei mawanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jakia misi nai anua butunikidi en janchaii. Na misi pikubaini ana mawatidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nai anua butuni misi jiweadan, jabia en eaki. Tsuabunda na misi jiwea pikubaini jiwepakexankanikiki, ikibi ikidan. Na misi en jatu inanxanaidan, en yuda kayabiki. Jaskawen taea na mai anu yudabu xukuabu tibi jawen jiwetidubuwen taexun en yuda kayabi en jatu inanxanaii— akin junea janchawen jatu yuiaya ");
INSERT INTO cbsNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ninkama e itan judio xanen ibubu jancha tibiwen yuinamei ja ikaibun: —¿Jaskakin nun pinun jawen nami nuku inantidumen? Juni kuinen namidan, nun pitaskatidumaki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","jabun shinan unankin Jesúsun ana jatu yuikin: —Chanima matu yuinun ninkaidakanwen. Matun Juchi Kayabi Iyuatun nami piama inun en jimi akamadan, man jiwekuian jayatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jakia tsuabunda en nami pikin en jimi aki jiwekuinxankanikiki, ikibi ikidan. Ja inun, jawen jenea xabatian en jatu bestenwankin taxnimaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jaska inun, en namidan, piti kayabiki. Ja inun, en jimidan, nuxuti kayabiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tsuabunda en nami pi inun en jimi akidan, ebe jiweaibun eadi jatube dasitan en jiwekunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jaska inun, Epa Dios jiwei ikibi ikatun ea yununiwen taea jawen kushipawen en jiwekunkainaii. Jabiaskadiai tsuabunda ea pi en kushipawen jiwekubainxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nai anua misi butunikidi en janchaii. Matun xenipabu jiwekin ja misi pikubauni mawanibu keskamaki, na misi en matu yuiaidan. Na misi pikubaini jiwekubainxankanikiki, ikibi ikidan— jatu wakin ");
INSERT INTO cbsNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Cafarnaúm anu janu ichati jiwe anuxun Jesúsun jaska jatu yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","jawen jancha ninkatan Jesúski chiti ikabu ichapabu yuinamei: —Na jaska yuiaidan, bikaki. Tsuan jaska chibankin axuntidumaki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","jabu yuananainbu unankin Jesúsun jatu yukakin: —¿En janchan matu dakewakin dananmaimenkain? ");
INSERT INTO cbsNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Janua en juni anu jawendi en matun Juchi Kayabi Iyua en ana kai uinkin man shinan betsa waxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Xabakabi matu yusinun ninkakanwen. En yushinin jatu jiwemaxanikiki. Jamen yudabun janchawenan, jawa jatu jiwemakin kushipa watidumajaidaki. En jancha en matu yuiaidan, en yushin keskaki. Man ikunwanyan en janchan matu jiwekuinmaikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","yusinkin taewabidanxuwen jawen jancha ikunwanbuma inun tsuanda achimaxanai unainwen taexun Jesúsun ana yuikin: —Jamen matunan, betsa betsapabun man ea ikunwanbumaki. Jaskaken: “Epa Diosun matu kenama man ea ikunwantidubumaki”, akin en matu yuixuki— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","jaskawen taexun Jesúski chiti imisbu ichapabu niti iki bashikutan Jesúsbe ana buama ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","jakia nun jawen 12 tsumabu nun paxkabainabumaken Jesúsun nuku yuikin: —¿Matundi man ea jenekatsi ikimenkain?— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Simón Pedron yuikin: —Xanen Ibuun, mia jenebain tsua mia keska nun chibantidumaki. Jiwekuinmati jancha min nuku yusinmiski. Diosun bake medibi pepadan, jabia min mia nun unaiin— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesúsun nuku yuikin: —Eanan, en matu katubiayama bestichai yushin chakabu man jayaki— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","nun jawen 12 tsumabu betsan Jesús jatu achimaxanaiwen taea Simón Iscarioten bake Judaskidi shinankin jaska nukukidi janchaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Januxun judio xanen ibubun Jesús detekatsi ikin benaibuwen taea Judea anu ana kakatsi ikama Galilea anu besti mae tibi anu kakunkaunkin jatu uinkin yusinkubaunaya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ja uxetian ni pei mextetan peantan judiobun xenipabu uxakubaunpaunibu jawen shinanti beya nawai pi besixanaibu ma kemaya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","jawen betsabun ikunwankin kayatiwadiabumabia Jesús yunukin: —Nenu janus kesu kesu isama Judea anu besiaibu anu kaxun uintanwen, kaxun jadixun min damiwai miki chiti ikabu ichaxun uin jabaa! iki jau yuu! ixanunbunan. Tsuada xabakabi xanen ibukatsi ikinan jawen pepa june akin jamapai aisbumaki. Jaskaken min akaidan, pepakiaki. Jerusalén anuabu jadixundi dasibi jaska min damiwamis xabakabi jatu uinmaditanwen, mianan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","7","Jesúsun jatu yuikin: —Jaska en ixanaidan, kemadiamaki. Matudan, tsuan matu jawa dananbuma jamapaiaibutian man katiduki. Jakia eanan, jatun chakabukidi xabakabi en jatu yuiaiwen taexun eki sinatakin ea danankanikiki. Jaskawen taea en daya en menediamawen taea en kayutidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","9","Jaskaken en jatu uinmaxanai kemadiamaken matube en kamaki. Matun mesti uintankanwen— jatu wa buaibun Galilea anu Jesús bashikui niti iken ");
INSERT INTO cbsNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","nawai besiaibu anu jawen betsabu bushianbun Jesúsun tsua banabimama jadi jatu ichun kai Jerusalén medan june jikiken ");
INSERT INTO cbsNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","nawai taeaibun Jesús benakin judio xanen ibubun jatu yukakubauni: —¿Jania man uiain, ja juni Jesúsdan?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","yudan kaian Jesúskidi janchai yuinamei betsa betsapabun jakidi yuikin: —Jadan, juni chakabuma pepaki— akaibun betsabundi yuikin: —Jaskamaki. Juni pemaki. Nukunabu padanmiskiaki— adiaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","jaskabiakin tsua ninkamama jabu judio xanen ibubuki datei Jesúskidi june janchanameakeakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","uxa dabe inun besti kaya napundiama nawaibu jatixunbukuns namakis Templo jemaintin anu Jesús ka tsauxun ichabu jatu yusinkin taewaya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","xanen ibubun uin e itan jaki sinatai yuinamei: —¿Jaskatan jaska yusian unanjaidai ikimenkain, nukubetan kene tapinsmabiadan?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","jaska janchaibu unankin Jesúsun jatu yuikin: —Na en yusiain man ninkaidan, enamaki. Ea jatun yununitun shinanwen en matu yusin ikaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tsuabunda Diosun shinan akatsi ikinan en akai unantan jaska chanimamenkain ikin na en yusiain: “Dios anua juimenkain, en ibubis en shinanen ikimenkain”, man unantidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jamen juni betsa ibubis jatu kenwanmakatsi ikidan, yusinan pepai jawenduamisbuki. Jakia jatun ea yununi en matu kenwanmakatsis ikaiwen taea chakabuuma pepa besti yui en chani chakamaki. Jaskawen taexun tsuan ja yusiankidi ekidi metutidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Chanima Diosun jancha Moisin matu yusinbiani mestenwantan matun juintinin Diosun jancha tsuan man chibainsbumaki. Jaskawen taexun jaska shinanma man ea detekatsis ikanaii— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ja dapi mapuxun betsan yuikin: —Min yushin chakabu jayaki. ¿Min jaska shinainan, tsuan mia tenankatsis ikimenkain?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ninkabiai jabe janchama xanen ibubu Jesúsun ana yuikin: —Sábado juindukuntitian juni bestichai xuxawakin en medabewaima matuki chanimabu jaska shinain man eki sinataibu en unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Jakia Moisin nuku yusinkin yuikin: “Jawen Dios unanmati wakin matun juni bake 8 xaba kaya jawen jina kubichi bikubainxankanwen”, akin nuku yununiki. Janunkain ja jina kubichi bikin Moisin taewama nukun xenipabu Abrahamnen dukun bikin taewani Moisin shinankin jabiaskadi nuku yununiki. Jaskaken juindukuntitianbiaken kaneama jina kubichi man bidiamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Janua Moisin jancha man kanekatsi ikamawen taea juindukuntitianbiaken matun juni bake kainshina jina kubichi bi matudi man dayakubainmisbuki. Jabiaskadi keska wakin juindukuntitiandi juni betsa jawen yuda jidabi en xuxawaimawen taexun jaska shinain eki sinatakin man chakabu ekidi tanaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jaskaken jawada bemakia uintan shinain jawaida janchayamakubainkanwen. Jakia jawada man unanti wakatsi ikaidan, jawa kaneama uin pejaidawatan pe shinankin unanti watan ikubainkanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","januxun Jesúsun yusiain Jerusalén anu jiwemisbun ninkatan yuinamei: —Ja junidan, detekatsis ikin benakubaunaibudan, ¿jabiamen? ");
INSERT INTO cbsNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Un unu nashui ika yusin janchaidan, jawa tsuan nemama uinanmandi! ¿Nukun Xanen Ibubunan, “Mesías Cristoki”, iwanan, shinankanimenkain? ");
INSERT INTO cbsNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jakia Mesías Cristo juxanaidan, jadakidiada juxanai tsuan nun unanmaki. Jaskaken janua Jesús juni nukun nun unainwen taea Mesías Cristo itidumaki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Templo jemaintin anuxun yusinkin jaska jabu janchaikidi shinain janchaibu ninkatan jancha kushipawen Jesúsun jatu shinanmakin: —Matunan, ea unankin janua en yumediani man unandiaii. Emebi en shinanen ibubis en juamaki. Jakia padananainsmatun ea yununidan, matunan, man ja unanmaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jakia ean ibubis jatun ea yununi anua en taxnikidaniwen taexun en ja unaiin— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","janua jaskaiwen taexun achinun ixun shinanbiaibun janu mawaxanai kemadiamawen taexun tsuan meabuma iniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Janua jakidi jaskabiaibu ichapabun ikunwain yuinamei: —Mesías Cristo juxun dami ichapa nuku waxunxanaikidi nuku yusinmisbu na junin jaska nuku yusinmisbu keska waikiki. ¿Chipu Mesías Cristo juxun na junin akai binutidumamenkain? Nun shinanan, atidumaki— iki ");
INSERT INTO cbsNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jesúskidi yuiaibu fariseobun ninkabain Diosbe nukunabu janchaxunika xanen ibubu anu buxun jabube yubakatan jau Jesús achitanunbun jabun Templo mekemisbu betsabu jatu yunuabun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","januxun mapuabu Jesúsun ana jatu yuikin: —Jaskaida ea wayamakanwen, uxa eskadabes besti matube en iyuaidan. Janua jatun ea yununi anu en ana chintunxanaidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jaskaken matunan, janida en kai anu man unanmabia ea benakin ea bechiama man ixanaii, man jadi katidumawen taeadan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","jaskai ninkai judio xanen ibubu yuinamei yuka iki: —¿Jani ka nun bechiama itidu chani ikimenkain, jadan? ¿Nukunabu nawabube chai jiwebaunabu anu kaxanun ika shinain ikimenkaintsa? ¿Griegonawabun Dios unanbumanu yusintanun ika ikimenkain? ");
INSERT INTO cbsNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na jaska yuiaidan, jaskada shinain ikimenkain: “Janida en kai anu man unanmabia ea benakin ea bechiama man ixanaii, man jadi katidumawen taeadan”, ikai nun ninkaidan— ikin shinanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nawai keyui jawen jenei ma xaba dabe inun besti kaya nawai besi beshian ma kakatsi keyui dasibi ichajaidabun Jesús benikauan jancha kushipawen jatu yuikin: —Unpax manujaidai man tetsusinaidan, eanu bexun aki bekanwen, ea ikunwankinan. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jabiaskadi Diosun jancha keneni keska wakin tsuanda ea ikunwain jawen juinti medanua jiwekuinmati jene jabai netsuama ixanikiki, jatu kushipa waidan— jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jaska nuku yuikinan, Diosun Yushin Pepakidi nuku yuiniki. Januxun Jesús ikunwainbu jawen kushipa Diosun inanun ikaya Jesús mawa bestean jawen Epanu kadiamaken Diosun Yushin Pepa nuku inanyuama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Januxun jatiditun Jesúsun jancha ninka pewatan yuikin: —Chanima na junidan, Diosun jancha yuixunikakidi Moisin nuku yuinidan, jaki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","betsabundi yuikin: —Mesías Cristodan, jaki— akaya betsabundi yuikin: —Jamaki. Galilea anua Diosun Mesías Cristo taxniama ixanai nuku yusinmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Janua taxnikidanxanaidan, “Davidin mae Belén anua Davidin babadan, Cristo Mesías ixanikiki”, akin nuku kenexuniki. Jaskakenan Jesúsdan, Diosun Mesíasmaki— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesúsun jatun jancha ninkatan jawen taea Jesúskidi shinan betsa betsapawaibuwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","jatiditun achibain bichibupananbun tsuan jawa meabumaken ");
INSERT INTO cbsNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","janu fariseobu inun Diosbe nukunabu janchaxunika xanen ibubu ichaxun Jesús anu jatu yunua Templo mekenikabu jabun Jesús iweama mais beaibun xanen ibubu betsan jatu yukakin: —¿Jaskakin Jesús achi biai kaxun man iweama ixumen?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","mekenika betsan yuikin: —Jaska ja juni janchai peaya juni betsadi janchakin nematidumaki, chakabu jatu yuiamawen taexunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","januxun fariseobun jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Jabi man unainsmapabenibin, matudi padainkikidan! Nuku nun xanen ibubu inun nun fariseobunan, nun jawa ikunwanmaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jakia Moisin jancha unanbumawen taea ja yudabudan, ibubis yupukunain ikanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","janua fariseo betsa Nicodemo Jesús anu ka jabe janchatanimatun jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jawen jancha ninkadiama jawada dayai nun uindiamabia Moisin janchawen taexun: “Juni chakabuki”, akin nun kupitidumaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nicodemoki sinatakin yuikin: —Galilea anua unainsmapabu keska shinanyamawe. Diosun jancha kenenibu una anua uintan Galilea anua Diosun jancha yuixunika taxniama ixanai min unanxanaii— itan ");
INSERT INTO cbsNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","jenebaini jatun jiwe anu inun buake buakenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Olivos Mati anu ka jadi uxashini penaya Templo jemaintin anu Jesús ana ka tsauken jaki ichabidanbidanaibu yudabu jatu yusinkin taewatanaya ");
INSERT INTO cbsNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ainbu betsa beneyabia juni jawen benemabe chutanameai chitetan achixun Diosun jancha kenenibu yusinananmisbu inun fariseobun iwexun mapubaunabu namakis ainbu nashui akin Jesúsun besuudi nichintan ");
INSERT INTO cbsNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","yuikin: —Yusinaan, na ainbunan, chakabukin juni betsa chutamaya achiabu mianu nun iwexuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ainbu jaskaxukenan: “Mishkiwen tsaka tsaka akin jau tenanunbunwen”, akin Moisin nukun xenipabu yununiki. Jaska wanikenan, ¿mianan, jaskada jakidi min yunuai?— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ja akatsi unanti wakin yukabu jakia jatun bepadameti jancha unain janchama tinixun Jesúsun metutiwen mai kenekin taewaya ");
INSERT INTO cbsNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","jaki sinatakin ana jabias yukadanwanbu bewenikitan jatu yuikin: —Tsuada Dioskidi chakabu man jayamatun ja dukuntun mishkiwen tsakakin taewadikanwen— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ana tinixun ana mekenen mai keneaya ");
INSERT INTO cbsNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesúsun jancha ninkatan jabun iwea bestibu bui anibubu bui taei chipu jatidi bukin ichabu namakis ainbu nichianbu besti jenebainabu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ana beweninatan Jesúsun ainbu yukakin: —Ainbuun, jabun mia tenanun, iwanan, iweabudan, ¿jania? ¿Tsuan mia tsakama ixumen, kupikinan?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Xanen ibuun, tsuan ea jaska wamabin!— aka —Peki. Jau mia kupinunbun, iwanan, eandi en yunuamaki. Jakia ana chintunkidan chakabukunkainama ixun inun kadiwe— aka ainbu kaya ");
INSERT INTO cbsNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Templo jemaintin anuxun Jesúsun yudabu uinkin mapuabu jatu yuikin: —Eadan, mai jidabi en bin chaxajaida keskaki, jatu tapinmanikadan. Tsuabunda ea ninkatan chibainbudan, ja binki nukui jiwea bena jayakanikiki. Jaskawen taea jawa meshu medan ana biunma niama keska ixankanikiki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","janua fariseobun jaskai ninkai jaki sinatakin yuikin: —Mimebi kein min pepaidan, jawa kushipa min jayamaki— akaibu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Emebi en dayuikibiakin janua en juni inun janu en kaxanai en unainwen taea en dayuikiaidan, jadan, kushipaki. Jakia janua en juni inun janu en kaxanai man unanbumawen taexun man kaneaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yudabun shinanmiswen man ea unanti waii. Jakia eanan, jaskawen en matu unanti wamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jakia jaska en Epan ea yununibetan shinankin chanima en mesti en akamaki, jawa kaneama ean unanti wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Januxun Diosun Moisés yuia matu kenexunidan, ja uinkin jawada jakidi juni dabe jabias jancha chaniaibu jawen jancha man ikunwantiduki, chanimakenan. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jaskaken emebi ekidi en pe yuiaii. En jaskaya en Epa jatun ea yununidi jabiaskadi ekidi pe yuikiki. Ja nuku dabetan jabiaskas chanikin nun yuitiduki, jau man nuku ikunwanunbunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—Min Epa mikidi chaniai nun ninkanun, ¿jani min Epadan?— akabu Jesúsun jatu kemakin: —Matunan, man ea unanmaki. En Epa man unanmadiki. Ea unankin en Epadi man unankeanaii— akin ");
INSERT INTO cbsNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Templo jemaintin anuxun na jaska yusinkinan, bau jaki nuitapaibu inankuinkin pei mistumisbu dapixun Jesúsun yusianyan janu mawaxanai kemadiamawen taexun tsuan mekin achiyuama inibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jabianuxundi Jesúsun mapuabu jatu ana yuikin: —Ea en janida kakenan, ea benai matun chakabuwen taea man mawaxanaii. Janu en kaxanai anu man katidumaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ninkai judio xanen ibubu yuinamei: —Ja jaska yuiaidan, jamebi tenanmepai ikimenkain: “Ja en janu kaxanai anu man katidumaki”, ikaidan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesúsun ana jatu yuikin: —Matudan, man nenuabu bestiki. Jakia eadan, en manaundiaki. Jaskawen taea mai anua besti man baki. Jakia eadan, na mai anua en bamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jaskaken matu yuikin: “Matun chakabu jakimama man mawaxanaii”, akin en matu yuixuki. Ninkakanwen. Chanima en jiwei ikibi ini man ea ikunwankatsi ikama matun chakabuwen besti man mawaxanaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","e itan betsabun yukakin: —Miadan, ¿min tsua iki ikai? —akeakeabu —¿Jaskai jamendaka en matu jancha chakawai ikai? Jabia en matu yuikin taewaxuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","En matukidi ichapa unanti wakin en yuitidubia jatun ea yununitun chanima jancha ea yuia ninkatan jabiaskadi yudabu en yuikubainaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","jawen Epa Dioskidi Jesúsun yuiai jawen jancha ninkabiai jawa tapianbumaken ");
INSERT INTO cbsNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","jaskawen taexun Jesúsun ana jatu yuikin: —Matunan, matun Juchi Kayabi Iyua ea binikin benimaxun janu man ea unanxanaii. Natianan, jaska en shinainwen en akamaki. Jakia jaska en Epan ea yusini besti en yuimiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja inun, ea yununi eskatian ebeken jamapai betsa betsapa wakin bechipaimakin en benimawamiswen taexun en Epan ea besti jenebainamaki— ");
INSERT INTO cbsNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","jatu wai xanen ibu ichapabun ikunwankin taewaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","januxun ja xanen ibubun ikunwankin taewaibu Jesúsun jatu unanti wanun ixun jatu yuikin: —Tsuabunda en jancha ninkatan chanima uke medan mestenwantan man chintuanmadan, man en tsuma kayabi itidubuki. Jaskawen taexun chanima jancha unankin man tapianyan chakabun matu ana tsuma wama ixanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","jabun kemakin yuikin: —Nukudan, nun Abrahamnen bababuki. Nukun yuda tsuma wabiaxun nukun shinan tsuan nuku biantidumaki. Jaskaken ¿jaskakin: “Matu ana tsuan tsuma wama ixanikiki”, ikin min nuku yuiai?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","36","Jesúsun ana jatu yuikin: —Chanima en matu yuiaii. Diosun jancha kanekin dasibibun chakabu shinainbu jatun chakabun jatu yabumiski, jawen dayadu keska wakinan. Jaska inun, juni betsan juni betsa bikin jawen dayadu waimakenan, ana jawenabube jiwetiduma shinankin nichinmisbuki. Jakia juni betsan bakedan, jawen bake kayabi jani nichianma jabe ikunkainmiski. Jaskaken eanan, jaska keska wakin Diosun juni bake kayabitun matun jawada chakabu man dibia keska jakimawakin en matu mekeaya chakabun matu ana yabutidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","38","Jakia en jancha ninkama man Abrahamnen bababubia eki sinatakin man jatiditun ea detekatsis ikaii. Ea janchaidan, en Epan jawada akai uintan en matu yuimiski. Jakia matunan, matun ibuan akai uinkin ninkatan man mawamiski— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Jamaki. Diosun katuni Abrahamnen bababudan, nun nukuki— ikaibun Jesúsun ana jatu yuikin: —Matu chanima man Abrahamnen bababudan, jaska Abrahamnen ani man adiakeanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Jakia Dios anua ninkatan chanima jancha en matu yuibia danankin man ea detepai ikaii. Diosun jancha chanima Abrahamnen ninkatan man ikai keska ikama iniki, danainan. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jaskaken matunan, matun ibuan amis keska shinain man ikaii— jatu wa jaki sinatakin yuikin: —Nukudan, nun jusi bakemaki. Nukun ibu kayabi bestichaidan, nun jayaki, Diosdan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Dios anua en juniwen taexun Dios matun ibu kayabikenan, jaska shinankin man ea bechipaidiakeanaii. Eadan, en shinanen aki en juamaki. Jakia jawen shinanen Diosun ea yununi aki matube jiwei en juniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jaskakin man ea ninkakin pewakatsi ikabumamen? Matu yuinun ninkakanwen. En janchadan, pata keskatun en jancha man tapin pewabumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Man jaskawen taeadan, matun ibudan, diablo Satanáski. Jaska shinain keska axunkin man bechipaimamiski. Jaska inun, bai taeni anua diablo Satanás puben detenan kain taeni ikunkainmiski. Ja inun, chanima jancha jayamawen taea chani chakakunkaindiamiski. Ja inun, chani chakanikawen taea chanin epaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jakia chanima jancha en matu yuibia man ikunwankatsi ikabumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jadatutun bedubi en jawa chakabu akai man ea uinshinxun ea chitetidumen? Eanan, en chanima jancha yuibiaya ¿jaskakin man ea ikunwanma chitekubainkanai? ");
INSERT INTO cbsNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jaska inun, Diosunabun Diosun jancha ninkamisbuki. Jakia man Diosunabumawen taexun man ninkakatsi ikabumaki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","januxun judio xanen ibubun Jesús yuikin: —Chanima nun mia yuiaidan, yushin chakabu jaya dikabia min Samarianawaki, unainsmapadan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesúsun jatu kemakin yuikin: —En jawa yushin chakabu jayamaki. En Epa en kenwanbiaya man ea danaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Emebi en keanmaki. Jaska inun, “Ea kenwankanwen”, iwanan, en matu yuiamaki. Jakia jatun matu unanti waxanaitun matu ea kenwanmakatsis ikikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jaskaken jabun en jancha ninkakin jeneama mawabia mawa kayabiama ixankanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","janua jabu Jesúski sinatakin yuikin: —Chanima min yushin chakabu jayaki. Nukun xenipabu pepa Abraham inun Dios janchaxunika dasibibudi mawakubainibuki. Jakia: “Tsuanda en jancha ninkai mawama ixankanikiki”, ikin min yuiaidan, ¿xanen ibukin min jatu binunkin keyua iki ikai? ¿Miadan min tsua iki ikai, jaska shinain ibubis keinan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","—Emebi en keainan, pemaki. Jakia en Epan ea kenwanmiski. Unanmabia: “Nukun Dioski”, ikin en Epakidi man yuimiski. “Eadi en Dios unanmaki”, iki en chani chakakeanaii, matu keskaidan. Jakia en Epa Dios unankin jawen yunua en chibanmiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yudabube jiwei en juai uinkatsi manakai ikunwain matun xenipabu Abraham benimaniki. Atimas ea uintan shinan chankain benimajaidaniki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ninkai e itan yuikin: —Min anibui 50 badi kadiamabia, ¿jaskatan nukun xenipabu Abraham min uinimen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Chanima en matu yuiaii. Abraham jayadiama ea dukun en ikibi ini en ikunkainaii— jatu waiwen taexun ");
INSERT INTO cbsNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","detekatsi ikin mishki biake biaketan tsakapananbun mapubaunabu anu junei nashui itan Templo anua kainkaini ");
INSERT INTO cbsNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","janua sábado juindukuntitian Jesúsbe kainkaini kakin mae anu kenebaunibu janu jikiti xui kexa juni bekun kaini tsauxun buanaibu pei jatu ea aki tsaua binubainkin bechitan ");
INSERT INTO cbsNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","nun jawen tsuma betsan Jesús yukakin: —Yusinaan, ¿jaskai na juni bekun kainimen? ¿Kaindiamaken tsuan Dioskidi chakabuwanimen? ¿Jawen ibubun animenkain? ¿Jamebi inidaka?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Jaskamaki. Jamebi Dioskidi chakabuwamaki. Jawen ibubundi chakabuwabumadiki. Jakia ikis Diosun pepawati kushipa yuda dasibibu en uinmatiduwen taea jabiaska bekun kainiki— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","—Na mai anu yudabube jiwea en bin chaxajaida keskaki, jatu unanmanikadan. Jaska en xaba jayawen taea jatun ea yununitun daya axundinankanwen. Ea xaba keska ma en kaken chakabu juaya ana tsua dayatidumaki, meshu beai keskayadan— ");
INSERT INTO cbsNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","nuku watan main kemu michuxun pupus watan jawen juni bekun bepuxkin ");
INSERT INTO cbsNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","yuikin: —Siloé janu unpax uke medan jabai anu mishki pukinibu anu unpax tsaua anu ka bechukitanwen— akadan, nukun janchawen Siloé yuiadan, ‘Jadi yunuaki’, Jesúsun jancha ninkakin ikunwain benikaini ka bechukia bepexetan uinbaini inun kaken ");
INSERT INTO cbsNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","janua ja dapi jiweabu inun jabun pei ea ikai uinmisbun yuka idabekin: —Ja juni bekun tsauxun jatun jatu pei ea amisdan, ¿na junidan, jabiamen?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","betsabun yuikin: —Jaa, jabiaki— ikeakeaibun januxun betsabundi uinkin yuikin: —Jamaki. Ja itsaki— ikaibun ibubis juni bekun bepexeatun jatu yuikin: —Jabia en eaki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","januxun yukakin: —¿Jaskatan min ma bepexeamen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","jatu yuikin: —Ja juni kenakin Jesús waibun pupus watan ea bepuxxun: “Siloe anu bechukitanwen”, ea wa ka en bechukia bepexetan en uin taewabidanxuki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","yukakin: —¿Jania ja junidan?— akabu jatu yuikin: —En unanmaki. Janida niaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","januxun sábado juindukuntitian Jesúsun pupus watan xuxawabainshinawen taexun fariseobu anu juni bekun xuxashina iyuxun jatu yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","fariseobun yukakin: —Min bekunidan, ¿jaskatan min ma bepexeshinamen?— akabu —Pupuswen Jesúsun ea bepuxa bechukitan en uin taewashinaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","jatidi fariseobun jaska shinanbumawen taea betsabu yuinamei: —Moisin nuku yusini chibain jaki meseama sábado juindukuanma dayamisdan, ja juni Dios anuamaki— ikaibun jakia betsabudi yuinamei: —Jawen unanmati dami atimaska akinan, juni chakabun jaska watidumaki— iki fariseobu jatun shinan dabe wai paxkatan ");
INSERT INTO cbsNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","juni xuxashina ana yukakin: —Min bedu mia xuxawashinawen taexunan jakidi ¿jawa min yuiai?— akabu —Ja junidan, Diosun jancha yuixunikaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","jawen ibubu yukadiama ja juni bekun kaini ma uin pewaiwen taexun judiobun ikunwankatsi ikama jenetan januxun jawen ibubu kenabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","beabu januxun judio xanen ibubun jawen ibu dabe jatu yukakin: —¿Nadan, min bakemen? ¿Chanima bekun kaini man yuimismen? ¿Jaskatan ma uinmenkain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","jawen ibubun kemakin jatu yuikin: —Na junidan, nukun juni bakeki. Bekun kainidan, nun unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jakia jaskatan ma uinshina nun unanmaki. Tsuanda xuxawakin uinmashina nun unanmadiki. Jabi yukakanwen, juni ewakidan, jamebi jaskashina jau matu yuinunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","bebunkidi yuinamei: —Tsuanda yuikin: “Jesúsdan, Mesíaski”, ikaibu judiobu xanen ibubun ninkatan jatun ichati jiwe anu jau ana ichayamanunbun jatu nichinkatsi yubakashinabuwen taea unain jatuki datekin jawen ibubun yuikin: —Juni ewaki. Ja yukakanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","janua ana yuinametan xuxawashina ana kenaxun yuikin: —Chani chakamajaida Diosun besuubi nuku yuiwe. Nukun nun uiainan, ja junidan chakabuki, Diosun jancha chibanmadan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","januxun ana jatu yuikin: —Juni chakabumenkain, en unanmaki. En bekunbiaken ikis ea uinmashina ja besti en unaiin— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ana jawenchains yukakin: —¿Mia jaska kaya washina min ikai uinmakinan, mia jawawen uinmashinamen?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—¿Jaskakin man ea ana yukai? Dama en matu yuixuki. ¿En jancha man ninkamamen? ¿Matundi daka man chibanun ika ikanai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","kunyan akin jancha kushipawen yuikin: —Min jawen tsumaki. Nukunan nun Moisés chibanpakeaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dios Moisésbe janchaniki. Jakia ja juni janiada kainkidanimadan, nun unanmaki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Man ea peidawawa, ja juni janiada taxnia man unanmadan. Jaskabia en bedu ea bepexshinken en pe uiaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Juni chakabun Dios ea akaidan, Diosun ninkaismaki. Jakia Dioski datekin jawen jancha ikunwankin yukai Diosun ninkamiski, nun unanan. ");
INSERT INTO cbsNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bai taei anua bekun kaian bepexnidan, nun jaska ninkaismaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Diosun yunuama jaska watidumaki. Jaskaken Diosun Jesús medabewashinaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","janunkain ana sinatajaidakin yuikin: —Mia bekun chakabujaida min kainiwen taexun min nuku yusintidumaki. Kadiwe— atan jau ana jatube ichayamaxanun nematan nichinibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Janu ichati jiwe anuxun bepexshina nichianbu ka Jesúsun ninkatan benabauni jaki nukutan yukakin: —Min Juchi Kayabi Iyua Diosun Katuadan, ¿min ikunwain?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Xanen ibuun, en Juchi Kayabi Iyua en ikunwantidudan, ¿tsuamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesúsun ana yuikin: —Min uin jabe janchaidan, en jabiaki— aka kenwain Jesús naman danti ixun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Xanen Ibuun, en mia ikunwaiin— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesúsun ana yuikin: —Diosun jatu unanti waiwen taea yudabube en jiwekunkainaii. Tsuabunda uinsbuman bexpexexun jau uinxanunbun inun natian tsuabunda shinankin uinbiai bekun keska jau ixanunbun en juniki— ikai ");
INSERT INTO cbsNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","fariseo betsabun jabetan ninkatan Jesús yukakin: —¿Nun uianma nun bekun keska min nuku shinain?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesúsun jatu yuikin: —Diosun yusian unandiama matun chakabuwen man kaneama ikeanaii. Jakia yuikin: “Nun Dios unaiin”, ikin jawa ninkama man kaneaii— jatu watan, ");
INSERT INTO cbsNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ana Jesúsun jatu yuikin: —Chanima en matu yuiai ninkakanwen. Tsuada chaxuwan meketi xuiwen jikiama jamaudi jawen keneki inakain butumisdan, yumetsubuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jakia janu jikiti xui kayabi bepenxuni jikimisdan, chaxuwan mekenika kayabiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jamen kene xui mekenikatun chaxuwan uinkin bepenxuna jawen ibuan chaxuwan tibi jawen kenawen kenapakea jawen jui ninkatan kainbidanaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","jawenas kainmakin dasibi kenakin keyubainkin bepuaya jawen jui ninkabainkin chibanmisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Januxun juni betsan jatu iyunun ixun jatu kenadiabaina jawen jui ninkama chibanma paxai jamakidi bumisbuki— akin ");
INSERT INTO cbsNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","chaxuwan miyuikidi jancha juneawen Jesúsun jatu yuikin jatu yusinpaia tsuan ninkabumajaidawen taexun ");
INSERT INTO cbsNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","judio xanen ibubu Jesúsun ana jatu yuikin: —Chanima en matu yuiaii. Janu chaxuwan jikiti xuidan, jabia en eaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","En judiama jabu dukun bea dasibibu en kenawen padananankubainmisbudan, yumetsu keskabuken chaxuwan pepabun jatun jancha ninkama ikubainibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jakia janu jikiti xuidan, en eaki. Tsuada eanu jikiaibu en jatu mekekubainxanaii, Diosunabu jatu wakinan. Chaxuwan meke pejaidawakin jatu bichitan kainmakin basi pepa pimakin en jatu ama keska wakubainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Juni ichakanikaidan, yumetsukin detekin yamawai padananain bemisbuki. Jakia jatu jiwekuinmai ikibi imaidan, en ea juniki, unanuma ichapa jatu inankin yaushiama jatu kushipa waidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Eadan, en matun mekenan pepaki. Mekenan pepatunan jawen chaxuwan mekei yaushi mawaxuntiduki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jakia dayadun pei binun ika dayakin chaxuwan mekexunaya janua kaman inu pubenen chaxuwan pinun ika juaya bechitan jawenamawen taea chaxuwanki pechitan jenebaini paxaya inawan bestibu achiken jatidi paxai benumisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Janua dayadu chaxuwanwen nuiama pei besti binun ika mese juaya paxamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Jaska inun, En Epan ea unanun eandi en Epa en unain keska wakin enabu chaxuwan keskabu en jatu unanyan jabundi ea unankanikiki. Jaskaken en mekenan pepawen taea enabu chaxuwan keskabu en jatu mawaxuntiduki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nenu besti enabumaki, na chaxuwan kene anuadan. Jakia chaxuwan betsabudi Diosun ea ma yununiki. Israelbumabiaken jatudi en mekekubainxanaii. En jui ninkaibu chaxuwan xukua bestichai mekenika bestichaiya keska Israelbun ea ikunwainbube Diosun enabu dasibi ea iwexunxankanikiki, jatuki dasi wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jaska inun, jawen mawati kushipa inun jawen bestenti kushipa en Epan ea yununi en jayaki. Ana bestenkatsi en jiwea yaushiama en mawaxanaiwen taea en Epan ea bechipai ewen nuikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jaskaken tsuan ea debu watidumaki. Jakia ikatsis iki ibubis en shinanen en debutiduki. Mawakin en jiwea en jeneshina en ana bitiduki, ja kushipa en Epan ea yununiwen taeadan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesúsun jancha ninkatan judio xanen ibubun shinan dabe wai paxkakin ");
INSERT INTO cbsNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","betsabun yuikin: —Yushin chakabu jaya patapaki. ¿Jaskakin nun ninkakubaini ikanai?— jatu waibun ");
INSERT INTO cbsNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","betsabundi yuikin: —Yushin chakabu jayatun pepa jancha yuitidumaki. Yushin chakabuyatunan, bekun xuxawatidumadiki. Jaskawen taea Jesús juni pepaki— ibaini buaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","janua uitian Jerusalén anu Dios kenwanti Templo pewanibu shinain besi nawaibutian Templo jemaintin kexa anu janu utai juindukuin tsauti chaipa jawen kena Salomón anu Jesús kai ");
INSERT INTO cbsNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","xanen ibubun bebuntexun yukakin: —Jatixuinda nun ana jamen bika teneyamanun menan jawa kushi xabakabi nuku yuidiwe, jabia min nukun Mesías Cristomenkainan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesúsun jatu kemakin yuikin: —Matunan, en matu yuia man ea ikunwanma ikimaki. En Epan kushipawen jawada pepa xabakabi en amiswen taexun en tsuamenkain man ea unantiduki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jakia man en chaxuwanmawen taexun man ea jawa ikunwainsmaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","En chaxuwanen ea unankin en jui ninkakin ea chibanbainaibu eandi en jatu unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eki chiti ikabu benuama en jatu jiwekuinmakubainxanaii. Padanxun tsuan jatu ea mebianma ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ja inun, tsuabuda en Epa kushipa dasibi binuatun jabu ea yunua jatuwen nuikin en jatu mekejaidakubainai tsuan ea jatu mebintidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ea inun en Epa Dios ja dabe nun bestichai keskaki, dapaxkanaismadan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","mishki tunkuwen tsakanun ixun judio xanen ibubun bitanaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","jatuki dateama Jesúsun ana jatu yuikin: —Epa Dios anua dami midima pepa en matu uinmamiski. ¿Jadatu damiwen taexun man ea tsakanun ika ikanai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Pepawen taexun nun mia tsakamaki. Jakia juni bestibia mimebi min janchawen: “En Dioski”, ikin min Dios ichaiwen taexun nun mia aki ikaii— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ana jatu yuikin: —Manakanwen. En Dios ichamaki. Diosun jancha yuixunikatun kenekin: “Ja idabeaibu pewanika jatu wakin Diosun jawen jancha jatu yunukin yuikin: ‘Man jatu medabewakubainaidan, man diosbuki’, ikin Diosun jatu yuiniki”, akin jatu kenexuniki, na kenedan, nun unankanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jaskawen taexun man danantidubumaki. Jaskaken jawen jancha jatu yunukin “Man diosbuki”, akin nixun ");
INSERT INTO cbsNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Diosun ea medibi waxun yudabu anu ea yununidan, ean yuikin: “En Diosun bakeki”, en ikaiwen taexun: “Min Dios ichaii”, ikin ea chitekin man kaneaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jamen en Epan pepawai keska en akamakenan, en jancha ikunwanyamakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jakia en Epan pepawai keska en akai en jancha man ikunwanma ibiakin en Epan kushipawen en dami pepawai ikunwankanwen. Ja dami ikunwankin en Epa ebe imis inun en jabedi imis man unantidubuki— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ana achipananbun Jesús paxai ");
INSERT INTO cbsNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jordán Jene pukei januxun Nashimanika Juanen jatu nashimakin taewani anu nun jabe kaken ");
INSERT INTO cbsNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ana midima jadi yudan kaian jaki xukuabu jatu yusian yuinamei: —Juanen damiwamabia dasibi Jesúskidi nuku yuishinadan, chanimaki— ikin ");
INSERT INTO cbsNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","jadixun ichapabun Jesús ikunwanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Janua shinan Betania anuxun Marían chipu xeni ininipawen Xanen Ibu Jesúsun tae peukaxun jawen buwen tede axanai anu jawen betsa María inun Martabe jatun pui Lázaro jiwea janua isin teneaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","jau Jesús yuixuntanunbun jawen pui dabetan jatu yunua buxun Jesús jatu yuixunkin: —Xanen Ibuun, min jaibu min bechipaiaidan, isin teneikiki. Nukube kaxun uin kawe— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesúsun ninkatan nun jawen tsumabu nuku yuikin: —Ja isinmanan tenankin debu wamaki. Jakia Dios inun jawen baken kushipa jatu uinmaxanun ika isin teneikiki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","María inun Marta inun jatun pui Lázaro bechipaijaidabiai ");
INSERT INTO cbsNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázaro isin teneai yuiabu ninkatan kayuama ana uxa dabei Jesús bashikushinxun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","nun jawen tsumabu nuku ana yuikin: —Judea anu ana bunankanwen— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Yusinaan, judio xanen ibubun dama jadixun mishki tunkuwen mia tsakapai ishianbuki. ¿Jaskai jadidi min ana kakatsi ikai?— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","nuku yuikin: —Xaba tibidan, 12 hora jayaki. Badidi xabatian tsuada kai uin pewabaini tsua juti itidumaki, na en mai anu xaba chaxa jayawen taeadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jakia tsuada meshu medan biunma kaidan, juti itidubuki, eauma kai keskadan— ");
INSERT INTO cbsNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","itan, —Nukun jaibu Lázaro ma uxaki. Datekin en bestenwain kaii— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Xanen Ibuun, ja juindukuin uxadan, mawama mainkiki. Kayamawe— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lázaro mawakidi Jesúsun nuku yuibia unanma uxa bestiakidi nun shinaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jaska nun shinain unantan xabakabi Jesúsun nuku yuikin: —Lázarodan, ma mawashinaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","En jadimaken ishinken en benimaii. Jaskadan peki, matunadan, ana xabakabi en matu ikunwanmai kaidan. Eki sinatabiaibu anua Lázaro uinun bukanwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","jaskaya nun jawen 12 tsuma kushipaya betsa Tomás tsupibu baken nuku yuikin: —Kawe. Jadia jabe mawadinun bukanwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","jaska ninkatan Jesúsbe nun kaya Betania dapixun: “Uxa dabe inun dabe ka Lázaro maiwashinabuki”, akin nuku yuiabu Jerusalén chaima kilómetro dabe inun besti anua judio xanen ibubu ichapa bexun jatun pui mawashinken Marta inun María kaxaibu jatuwen nuikin daewakin jatu nese wai beabun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús juai bana ninkatan Martan itanun ika kai Jesúski nukui kaya Maríandi jawa ninkama jiwetan jiweken ");
INSERT INTO cbsNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","jaki nukuxun Martan Jesús yuikin: —Xanen Ibuun, min nenukenan, en pui mawama ikeanshinaki. Jamapai shadabu min Dios ea akai ninkatan mia medabewakin mia axunmiski, en unanan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesúsun yuikin: —Min puidan, ana jiwexanikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","januxun Martan yuikin: —Chanima jabiaskaki. Badi jawen jeneaitian mawabu Diosun yuda dasibi bestenwanxanaitian ana jiwexanai en unanaiin— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","januxun Jesúsun ana yuikin: —Bestenwankin jiwemanikadan, jabia en eaki. Tsuabunda ea ikunwain mawabia ana jiwexankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jabu dasibi jiweyuxun ea ikunwain mawataskama ixankanikiki. ¿Na en mia yuiaidan, min ikunwain?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Jeen, Xanen Ibuun, min Cristo Mesíaski. Jawen bake yudabube jau jiweyuxanun Diosun yubanidan, jabia min miaki, en unanan. En mia ikunwaiin— atan ");
INSERT INTO cbsNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","janua Marta jawen jiwe anu chintunkidan jawen betsa María june yuikin: —Nukun Yusinan ma juaki. Mia kenaikiki. Kayuwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Marían ninkatan benikaini jawen betsa Martabe kainkainaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","jawen mae anu jikidiama jabianuadi Marta jaki nukuxu anuxun Jesúsun manaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","judio xanen ibubun María daewai bea jawen jiwetan jabe maniabun Marían jawa jatu yuiama benikaini jawen betsabe jawaida buaibun jatu uintan shinain: —Mishki tanpe anua kaxai kaikiki— ikin chibainbun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesúski nukutan juinti nishma ja naman danti ixun Marían yuikin: —Xanen Ibuun, min nenukenan, en pui mawama ikeanshinaki— atan ");
INSERT INTO cbsNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","judio xanen ibubube María kaxai bis ikaibun Jesúsun jaskaibu uin jatuwen uke medan nuijaidai jatube kaxakatsis ikin ");
INSERT INTO cbsNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","jatu yukakin: —¿Jani man datanshinamen?— jatu wa —Xanen Ibuun, uinun kawe— abainabu ");
INSERT INTO cbsNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús kaxakainaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","xanen ibubun uin yuinamei: —Uinwen, bechipaidiaikikidan— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","jakia xanen ibu betsabu yuinamediai: —Juni bekun xuxawabiashina jau Lázaro mawayamanun xuxawati shadashina jawawen jaska watima damapaikiki— abainaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús jatube kai kaxakunkainaya ana nui pae tsekekidani kakin mishki tanpe medan datantan mishki ewapawen bepushinabu anu kematan ");
INSERT INTO cbsNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Bepenkanwen— jatu wa nemakin Lázaron pui Martan yuikin: —Xanen Ibuun, jamaki. Meyamananwen. Ma xaba dabe inun dabe ka chapui pisi mayaikiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesúsun kemakin yuikin: —Ewen dateyamawe. “Ikunwankin Diosun kushipa min uiaiin”, akin en mia dama yuibidanxudan, shinanwen— akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","januxun mishki ewapawen bepushinabu bepenxunabu Jesúsun uintan naiudi teskanxun yuikin: —Epaan, min ea ninkaiwen taexun en mia pepawaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","En mia yuka ninkatan min ea medabewakubainmiski. Min ea yununidan, na ebe mapubaunabun jau ea uinkin ikunwanunbun xabakabi en mia yukaii— itan, ");
INSERT INTO cbsNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","jui kushipawen kenakin: —Lázaroon, jadi dakama taxniyuwe!— akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","mawa tadiwen yabu kextu wakin sebikin utsi waxun jawen besudi beyabubiashinabu ana jiwei bestentan kainkidanaya Jesúsun jatu yunukin: —Jawen yabu dapekanwen, jau kanunan— jatu wa dapeabu jaskai Lázaro ana bestentan jiweniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jatun bedubi Jesúsun jaska waiwen taexun judio xanen ibu ichapabu Maríabe bexun Lázaro mawashina Jesúsun ana jiwemai uinkin: “Jesús Diosun bakeki”, ikin ikunwainbun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","jakia xanen ibu betsabun jaska waxu ikunwankatsi ikama fariseobu anu buxun jaska Jesúsun axu jatuki chaniabu ");
INSERT INTO cbsNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","janua Diosbe nukunabu janchaxunika xanen ibubu inun fariseobu Junta Suprema kena jatube ichatan Jesúski datei yuinamei: —Ja juninan, jatu unanti wamakin dami tsuan jaska watiduma ichapa waikiki. ¿Nun jaska watidumen? ");
INSERT INTO cbsNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nun nemama nuku jenekin keyutan dasibibun ikunwain jaki chiti iki keyutidubuki. Jaskaibun romano xanen ibubun jatun soldadobu midima bexun nukun Templo inun nukunabuya nuku yamawaxankanikiki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","jakia na jabia baditian Diosbe nukunabu janchaxunika xanen ibujaida Caifásin jatu ninkatan yuikin: —Matunan, man jawa unanmaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nukunabu jau paxkai sa iyamaxanunbun juni bestichai nukunabu mawaxunaya man pepakunkainxanai man jaska shinanmaki— jatu wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jaska yubakaibu shinanmakinan, ibubis Caifásin shinanma jakia na jabia baditian Diosbe nukunabu janchaxunika xanen ibujaidawen taexun: “Jesús judiobu mawaxuntiduki”, akin Diosun Caifás jatu yuimaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na jaska yunuidan, jabu bestikidi ikama jakia Diosun bakebu paxka jiwea akeakeabu jabun ikunwainbu dasibi ichawaxanun ika medabewai Jesús nuku mawaxunxanai ");
INSERT INTO cbsNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifásin jaska jatu yuiaiwen taexun judio xanen ibubun Jesús tenanun ika yubakai taenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Judio xanen ibubu jaki jaskaibu janua Jesús xabakabi ana niama jatu anua kainkaini mae betsa Efraín anu janu jiweabuma dapi nuku iyuxun uxa ichapakin Jesúsun nuku besti yusianyan ");
INSERT INTO cbsNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pascua judiobu nawai besimisbutian ma kemaya nawai taediama jatun beya chibain jau Dios ana jatuki sinatayamanun Dios daewai ibubis pepakatsi iki mae jatiubuma anua Jerusalén anu yudabu midima bexun ");
INSERT INTO cbsNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Jesúsun yusiain ninkakatsi ikin benabaunaibun Diosbe nukunabu janchaxunika xanen ibubu inun fariseobun Jesús achitan bichinun, iwanan, jatu yunushinxun jatu yuikin: —Jesús janiada bechitan nuku yuikanwen— ikaibuwen taea mae betsa betsapa anua beshianbu Templo jemaintin anua yuinamei: —¿Jesúskidi jawa min shinain? ¿Juimenkain? ¿Juamadaka?— ibaunbaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ja Pascua nawai besi ana 6 día ma ika kemaibun Jerusalén dapi Betania anu nukube Jesús ka Jesúsun Lázaro bestenwainma ana jiweawen taexun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","jawen shinan chankankin jabun Jesús duawakin badi kaya piti midima nuku bawaxunabu tapu chanpa anu Lázaro inun jawen jaibuaibu Jesúsbe daka baxti ixun piaibun Martan piti betsa betsapa bebidan bebidanaya ");
INSERT INTO cbsNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","januxun Marían xeni jene ininipa jawen xankama 300 gramo kesua jawen kena nardo jas kadujaida bexun Jesúsun taeki jukakin tae peuka dasibi jiwe napua iki inin shiamayaya jawen bu chaipawen tede akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","nun jawen tsuma betsa Judas Iscarioten chipu Jesús jatu achimaxanaitun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Jaskakin jatu inantan 300 xaba daya peiti biamamen? Ja peiwen nuitapaibu medabewati shadabin!— ibiai ");
INSERT INTO cbsNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ja nuitapaibuwen nuiamadi jakia jatun nukun pei nukun kapankanki nun mekemabia eskadabe bi yumetsubiakunkaini ");
INSERT INTO cbsNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Judasin jaska yuiai ninkatan Jesúsun yuikin: —Ana jadi yuiyamawe, na eki tanaxun aduimaxun en mawa chaputima wakin bebunkidi duawakin ea puxaxukidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nuitapaibu matube jiweabu man jatu duawapaketiduki. Jakia eadan, jawenchains man ea duawapaketidumaki— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","janua Jesús Betania anu jua judio xanen ibubun ninkatan Jesús besti uinun ikama Lázaro bestenwainmadi jabe uinun ika beabun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","jakia Lázaro ana bestenwainmawen taexun xanen ibu ichapabun jatu jenebain Jesúsun jancha ninkakin ikunwanun ika paxkabainaibuwen taea datei Diosbe nukunabu janchaxunika xanen ibubu yubakai: —Lázaro dikabi tenantiki— ika yubakanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Jesús uxashini bestenkaini Jerusalénki kemai juai banabitan Pascuatian nawai besi beshian yudabu midimabun Jesús kenwanbainkin xenpan pei mextexun sanan sanan axunkubainkin jancha kushipawen yuibainkin: —Dios nukuwen nuikin nuku medabewamiski. Diosun kushipaya juai kenwanankanwen, nun Israelbun Xanen Ibu kayabikidan— iki jaki nukui buaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","januxun Diosun jancha yuixunikan yuikin: “Jerusalén anuabuun, matun xanen ibu jawa keanma burro bake kamaki katsaumea juxanikiki. Dateama uinxankanwen”, jatu watan kenenidan, jabiaskadiai burro bake Jesúsun bechitan jaki katsaumekaini kai Jerusalén jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","januxun ja dukun Jesús jaskai nun jawen tsumabun nun jawa ninkakin pewama iniki. Jakia chipu Diosun Jesús bestenwainmaken shinankin jaska dasibi ikima ja kenenibu inun kenwankubidanshinabu shinankin atimas jakidi nun ninkaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jabiatiandi Lázaro mawashina Jesúsun kenakin bestenwain uinmabun yudan kaian jabu jatuki chanikin jatu yuibaunbaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","jawen jatu unanmati dami wakin bestenwanshiankidi ninkatan Jesúski nukutani beaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","fariseobun jabun ikunwanma uin yuinamei: —Uinkanwen, nun jawawen ana jatu bepadanxun itimakidan. Dasibibun ikunwanbaini jaki dasikanikikidan— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","judiobubetan nawabu xuku betsa griegobun Dios kenwain jatube besi nawai Jerusalén anu beshianbu ");
INSERT INTO cbsNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Felipen mae Betsaida Galilea mai pakea anua griegonawabu jaki nukuxun yukakin: —Xanen ibuun, nun Jesúsbe janchakatsis ikaii— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","jatu bashiyubaini kaxun Andrés yuitan ja dabe kaxun jaskaibu Jesús yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús juxun jatu yuikin: —Matun Juchi Kayabi Iyua Diosun jatu ea kenwanmakatsis ikaidan, ma kemaikiki, ikisdan. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chanima en matu yuiaii. Jexe mai medan banama jawa bimitidumaki. Jakia mai uke medan bana jawen nami chapui dami jukuin yumetan bimijaidamiski. Eadan, en jaska keskayuaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jamen tsuabunda jawen jiwea ibubis bechipai yaushidan, ibubis benuxankanikiki. Jakia tsuabuda jawen jiwea jawa yaushi nuiama ekidi ma shinan pewa ana jiwekuinxankanikiki, ikibi ikidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tsuabunda ea duawakatsi ikinan, jau ea chibankubainunbunwen. Januxun ea chibankin ea duawaibudan, ebe jiwediaxankanikiki. Jaskawen taexun tsuabuda en Epa Diosun jatu duawaya janu en jiwexanai anu ebe idiaxankanikiki, jabun ea duawamisbudan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","jaskai nun ninkaya Jesúsun jawen Epa yuikin: —Ikis jawenchains juinti metexekei en punu nishmajaidaii. ¿Jawa yuipa?— itan —Epaan, na en yuda jatu mepamatan en paxanun ea nichinwen, akin en mia yuitidubia jakia jabiaskatanun ika en juai min ea yubaniki— atan ");
INSERT INTO cbsNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ana yuikin: —Epaan, ewen taexun dasibibun jau mia kenwanxanunbunwen— akaya janua nai anua Diosun jui taxniaiwen yuikin: —En shinanwen min ma abiakubainaya ana jabiaskadi wakin en kena ana kushipa wakin miwen en ana jatu kenwanmakatsis ikaii— akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","yudabu mapubaunxun ninkatan yuinamei: —Tin ikainkainimenkain— ikaibun jatiditun yuidiakin: —Diosun nai tsuma janchaimenkain— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","jaskaibu ninkatan Jesúsun jatu yuikin: —Na jui taxniai man ninkaxudan, ea medabewanun ika jancha taxniamaki. Jakia matu medabewanun ika jancha taxnixuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na jabiatian yudabu unanti wakin diablo Satanás yudabu dasibibuwen xanen ibumis mebintan en udenxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mai anuxun ea binikin sanankin nichinmabun jaskawen taexun dasibibu ninia keska wakin ea anu en jatu iwexanaii, jau ichapabun ea ikunwanunbunan— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","jaskai cruzkia mawaxanai jatube nukuki chanikin unanmaya ");
INSERT INTO cbsNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","januxun mapubaunabu betsan yuikin: —Diosun jancha kenenibu anua uinkin nun manakamisdan, “Mesías Cristo jua matube jiwepakexanikiki”, akin kenenibukenan jaskakin: “Nukun Juchi Kayabi Iyua Mesías binikin sanankin nichinxankanikiki”, ikin ¿min jaska nuku yuixumen? ¿Jaskakenan, tsuamen, nukun Juchi Kayabi Iyuadan?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesúsun ana jatu yuikin: —Ana uxa eskadabesi Dioskidi unanmanika xaba keskadan, matube jiweyuikiki. Jaskayuaya na jancha ninkai jiweyukanwen. Jamen bin nukawa keskai ma en kaken tsuabunda unandiabuma meshun achia keskai janida baiwen kai bai unanma man mextantidubumaki. Unaindakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ja xaba man ebe ketaxamekatsis ikidan, man xaba jayayuaki. Ja xaba man jaya ninkatan ea ikunwankanwen— jatu watan junetan nukube kainkainiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Januxun jawen unanmati dami atimaska Jesúsun jatu uinmakin axunbiakubaina jawa ikunwanma inibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jaska wanunbadiaibukidi Diosun jancha yuixunika Isaíasin yuikin: “Yavé Diosuun, yudabu min kushipa min jatu uinmakubainmiski. Jakia nukun jancha tsuan ikunwanbumaki”, aniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Jaska inun, Isaíasin yuikin: “Jau uin pewayamanunbun inun jau shinan pewayamanunbun Diosun jatun bedu bekun keska wakin jatun juinti kushi waikiki. Jaskawen taexun Diosun yuikin: ‘Jatun shinan betsa watan ea ikunwainbu en jatu xuxawakeanaii’ ”, akin Diosun jancha ikunwantidubumakidi Isaíasin keneniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Januxun Isaíasin namai keskakin Jesúsun kushipa uintan jakidi chanikin jatu kenexuniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isaíasin jaska keneniken judio xanen ibu ichapabun Jesús ikunwainbun inun xanen ibujaida binuabu jatidibundi ikunwanbiai: “Jau nukun ichati anua taxnimakin nuku nichinyamaxanunbun”, ika fariseobuki datekin yuda ichapabun Jesús ikunwainkidi xabakabi yuiama iyunibukiaki, ");
INSERT INTO cbsNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jesús shinanbiakin jawenabu kenwanmayukatsis ikin Dioskidi bexmas kenwankin dateyabi shinankinan. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Januxun jancha kushipawen Jesúsun nuku yuikin: —Tsuabunda ea ikunwankin ea besti ikunwanma jakia en Epa jatun ea yununidi ikunwankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jabiaskadi wakin ea uinkin jatun ea yununidi unandiakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yudabu mai anua jatu ikunwanmatanun ika xaba keska en juniwen taea tsuabunda ea ikunwain meshu medan jadi jiweama keska ixankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jakia yudabu kupinun ika juama jatu medabewanun ika en juniwen taexun en jancha ninkabiakin tsuabunda chibanmaken ikis en jatu kupiamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jakia en jancha danankin bechipaiabuma jabuna kupiti ma jayaki. Xaba jawen jenea unantitian en janchawen taexun Diosun jabu jatu kupixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Eanan, en shinanen en matu yusianmaki. Jakia Epa Diosun ea yununitun ea yunua yusinkin en matu yuimiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ean en Epan jancha en unainan, jadan jiwea keyutima jayaki. Jaskawen taexun en matu yuiaii, jaska en Epan ea yunukin yuinidan— akin nuku xabakabi yuiniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua nawai meshukidi ixanaitian yudabu jenebaini jawen Epa Diosbe ana dasi kaxanai ma kemai Jesúsun unain na mai anua jabun ikunwainbu bechipai jatuwen nuikunkaini jaska bestiwenma jakia nun jawenabuwen taea nuiyabis mawakin nuku uinmaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Januxun badi kaya meshu medan Jesúsbetan nun piaya jabiatiandi Judas Iscarioten Jesús jatu achimaxanai diablo Satanásan Judas shinanmaya ");
INSERT INTO cbsNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","mai jidabi anua dasibi Epa Diosun Jesús xanen ibumakatsi yununi Dios anua juni ana jawendi chintun kainxanai Jesúsun unain ");
INSERT INTO cbsNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","nukubetan pibiai pia jenetan benikauan jawen sanpu tadi pekatan jawen datekede iti chaipa bitan chiabukukin tadankin mestenwantan ");
INSERT INTO cbsNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","januxun kencha ewapaki unpax juxketan nun jawen tsumabu nuku juchukin taewakin jawen datekede itiwen nuku jutekede akubauni ");
INSERT INTO cbsNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedroki kematan anun ikaya nemakin yuikin: —Xanen Ibuun, min en yusinanki. ¿Jaska wakin min ea juchunun ika ikai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Ikis en matu akai min unanmaki. Jakia chipu min unanxanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedron ana yuikin: —Duawakin ea juchuwe, iwanan, en mia yunuamaki— aka Jesúsun nemakin: —En mia juchuamadan, min enabu kayabi itudumaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedron yuikin: —Jaskakenan, Xanen Ibuun, ea juchu bestiama ea mechukin ea buchudiawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesúsun kemakin: —Tsuabuda dama nashitani juidan, jawen tae besti jau ana juchuki bestinunbunwen. Jaskadan, man ana detsismaki. Jaska keskai en janchawen taea besti man pepaki, mawaida dasibimadan— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Judasin jatu achimaxanai unankin jaska nuku yuiniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Januxun nuku juchuxun jutekede akin menetan jawen datekede iti pekatan jawen sanpu tadi chaipa ana sawetan ana daka baxti ixun nukubetan pikin nuku ana yuikin: —¿En dama matu axudan, shinankin man unain? ");
INSERT INTO cbsNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Chanima ea kenakin: “Yusinaan inun Xanen Ibuun”, akin man ea kenamisdan, jabia en eaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ea en matun Yusinan inun matun Xanen Ibubiatun en matu juchukin duawakin en matu uinmaxu keska wakin matudi duanamei juchukinain keskakubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na ean eska wakinan, jabiaskadi wakin man axanunbun en matu bebunkidi uinmaxuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chanima en matu yuiai ninkakanwen. Dayakapan jawen tsuma binuinsmaki. Jaska inun, tsuada yunua jawen yunua axunkin binuinsmadiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na jaska en matu yuiai tsuabunda ninkatan jawen jiwekin jabun aki benimakubainxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na jaska janchaidan, matu dasibikidi en janchamaki. Ean en matu katunixun en unaiin. Jamen ekidi Diosun jancha yuixunikatun ea dayuikin: “Ebetan pibiakin ea detenun ixun shinainkiki”, ini keskai jaska ekidi kenenibu yuiaiwen taea chanima matu bestichaitun man ea jabiaskadi wakatsis ikaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ea en inidan, man ikunwanxanunbun jaska ea waxanaibu bebunkidi en matu banabimai chaniaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chanima tsuada en kenaya en yunua ka jabun jatun jancha ninkakin ikunwankin jatu duawakin eadi jabiaskadi wakin jatun ea yununidi jabiaskadi waxankanikiki— nuku wai ");
INSERT INTO cbsNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","janua Jesús jawen juinti metexekei nishmajaidakin xabakabi ana nuku yuikin: —Chanima jadatuda bestichaitun man ea jatu achimai kaii— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","nuku jawen tsumabu betsakidi janchai unanma e itan nun beisina akeakeaya ");
INSERT INTO cbsNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesúsun ea bechipaijaidaiwen taea en pekachu Jesús baxti ika dakaxun piai ");
INSERT INTO cbsNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro en beisa jawen metutiwen Jesús ea yukamakin: —¿Tsukidi janchaimenkain? Yukawe— ea wa ");
INSERT INTO cbsNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","dabekekauan texkitan Jesús yukakin: —Xanen Ibuun, ¿tsuamen?— en wa ");
INSERT INTO cbsNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","baxexendi Jesúsun ea besti yuikin: —Misi pukuxun en inainan, jaki— ea watan misi bixun tewe inun yuchi mutsaki pukutan Simónen bake Judas Iscariote inan ");
INSERT INTO cbsNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","piaya Satanás Judasin shinan medan ma jikiawen taexun Jesúsun Judas yuikin: —Min jaska shinainan, jawaida aditanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","ninkatan jawa yuiama jawaida kainkaini meshu medan janida Judas kaken jaska wakin Judas Jesúsun yunua kaken nukubetan pi unanbumabia betsan shinain yuinamei: “Judas pei mekenikadan, ‘Nawakin piti ana bitanwen’, akin Jesúsun yunuxuki”, iake iakeaibun betsandi shinankin: “ ‘Nuitapaibu peiwen jatu medabewatanwen’, akin Jesúsun yunuxuki”, iake iakediakin shinainbun ");
INSERT INTO cbsNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","janua Judas kainkainken Jesúsun nuku yuikin: —En jatun Juchi Kayabi Iyua en kushipa jayaki, jawen taexun natian Diosun ea jatu unanmaidan. Jaskawen taexun Diosun kushipa en jatu unanmaii. En jatun Juchi Kayabi Iyua Diosun jatu unanmaikiki, ewenan. Jaskaken jau unanunbun manama jawaida akikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","—En bake kayabibuun, ana jatixuinda en matube niamaki. Jakia uxa eskadabes ka ea benakin man ea bechiama ixanaii. Jaska judio xanen ibubu en yuishina keskadan, en matudi yuiai ea ninkakanwen. Janu en kai anu man katidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jaskawen taexun jawen yunuti jancha bena en matu bashixunkin yunubainaii. Jaska matuwen en nuiai keskaidan, jabiaskadiai matubus nui duanamepakediaxankanwen. Jaskai shinananain man nuibukuain ");
INSERT INTO cbsNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","matu uinkin man jaskai en tsumabu kayabi dasibibun matu unankubainxankanikiki— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","januxun Simón Pedron Jesús yukakin: —Xanen Ibuun, ¿min jani kai?— aka —Janu en kai anudan, ikis min ea chibantidumaki. Jakia chipu min ea chibanxanaii— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedron ana yuikin: —Xanen Ibuun, ¿jaskakin en mia chibantidumamen, ikisdan? Eadan, en mia mawaxuntiduki, miwenan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesúsun Pedro ana yuikin: —¿Chanima min ea mawaxuntidumen?— iwanan, —Jaskamajaidaki. Chanima en mia yuiai ninkawe. Penadiama takada keui taediama eki dakekin: “Ja junidan, en ja unanmaki”, iki dabe inun bestiki eki dakekin min yui kaii— akin ");
INSERT INTO cbsNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","nukudi Jesúsun yuikin: —Na jaska en chaniayadan, juinti metexei dateyamakanwen. Dios ikunwankin eadi ikunwankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","En Epa Diosun jiwe anu teke xaka ichapa jayaki. Jawen jiwe jaska jayamaken en matu yuiama ikeanaii. Jaskaken janu jiwei man niti ikama ixanun en matu pewaxuin kaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Janu matudi ka en jiweai anu man idiatiduwen taea kaxun bebunkidi en matu pewaxuin kaxanaii. Ana juxun en matu iyuxanaii, janu nun jiwenunbunan— itan ");
INSERT INTO cbsNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","—Matunan man unaiin, ja baiwen en kaidan— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomásin yukakin: —Xanen Ibuun, janu min kaxanaidan, nun unanmaki. ¿Jaskatan jawen kati bai nun unanxanai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesúsun kemakin: —Jawen kati bai inun jawen chanima unanti inun jawen jiwekuintidan, jabia en eaki. Ea besti ikunwankin chibain Epa Dios anu man jikitidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jaska inun, man ea unanti wakubainaidan, en Epa Diosdi man unankubainaii. Natian ea tapinkubainkin Epa Diosdi man uindiakubainaii— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ninkatan Felipen yukakin: —Xanen Ibuun, Epa Diosdan nuku uinmawe. Uintan nun mia ana bikawamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Felipeen, jatixun en matube jiwebiakunkainai ¿min ea unandiamamen? Chanima ea uinkin Epa Diosdi man uiaiin. ¿Jaskakin: “Epa Dios nuku uinmawe”, akin min ea yukai? ");
INSERT INTO cbsNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Epa Dios inun ea, nun dasiadan, ¿min shinanmamen? En shinanen akin en matu yuismaki. Jakia Epa Dios ebe ketaxamexun ea yunukin jawen daya ea amamiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Epa Dios inun ea nun dasiadan, ikunwankanwen. Jaska en jancha besti ninkatan man ikunwantidumadan, en dami matu unanti wamakin atimaska en amiswen taexun ikunwankanwen, nun dasiadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chanima en matu yuiai ninkakanwen. Tsuabunda ea ikunwankin en jaska amis man adiakubainxanaii. Ja inun, en Epa Dios anu en kaxanaiwen taexun en kushipayabun ea medabewakin jatu ikunwanmakin dami atimaska ewapa wakin ea binuxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","En kenawen taexun tsuabunda jamapai Epa Dios man yuka en jawen baken en matu axunxanaii, en Epan kushipa matu uinmakinan. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jamapai tibi en kenawen man ea yuka en matu axunxanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ana nuku yuikubainkin: —Chanima man ea bechipaiaidan, jaska en matu yusinkin yunumis shinankin en jancha man chibankubainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Man jaska wakubainaya en matu yukaxuna Medabenan Bena betsa Diosun matu anu yunuxanikiki, jau matube jiwei ikibi ipaxanunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Medabenan Benadan, jawen Yushin Chanima Unanmanikaki. Mai anu yudabun jawa unanbuman inun uianbuman Medabenan Bena ikunwankin jaibuwatidubumaki. Jakia natian matu dapi jiwea chipu matube uke medan jiwexanaiwen taexun Diosun Yushin Chanima Unanmanika man ma unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jaskawen taexun eanan, bashikin bake ibuuma keska wakin en matu jenebainamaki. Jakia ana matube iki en ana chintunkidanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mawaida jatixuinda yudabun ea uianma ixankanikiki. Jakia matunan, man ana ea uinyuxanaii. Ja inun, en ana matu jiwexunaiwen taea matudi man jiwediakunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ja xabatian jaskakain en Epaki en dasia man unanyan janua matuki ana nukui en matuki dasidiatan en matube nipakexanai man unanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jaskaken tsuabunda en yusian ninkakin chibankubainkin ea unanmai chanima ea bechipaikubainxankanikiki. Jaska inun, tsuabunda ea bechipaiaibun en Epa Diosundi jatu bechipaidiaxanikiki. Jaskaibu xabakabi en jatu unanmaxanaii, jabun chanima ea bechipaiaibudan— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas betsan yukakin: —Xanen Ibuun, ¿jaskakin yudabu dasibi uinmama min nuku besti ana uinmaxanai?— akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesúsun kemakin: —Tsuabunda ea bechipaikinan, en yusian jancha chibankanikiki. En Epan jatu bechipaiaya ea inun en Epa jua nun jatuwen jiwexanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jakia tsuabunda ea bechipaiabumadan, en yusian jancha chibanbumaki. Na jancha en matu yusian man ninkakubainaidan, enamaki. En Epa jatun ea yununitun janchaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Natian matube jiwexun en matu yusinyukubainaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jakia jawen Yushin Pepa matun Mekenan Bena en kenaya en Epa Diosun yunua juxun jaska en matu yusinkubainmis dasibi en matu yuiai ana xabakabi matu shinanmakubainxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","En janchawen datei matun juinti nishmayamakanwen. Diosun unanuma jawen uke medanu unanumati en matu inaiin. Jaska yudabu jatun shinanwen jiwekin unanumai jiwemisbu keska matu inanma jakia Dios anua daewanika kayabi unanuma en matuki bashiaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ka matu anu en ana juxanaii”, ikin en yuiai man ma ea ninkaxuki. Janua Epa Dios xanen ibun ea binuawen taea janu en kaxanaii. En Epa anu en kaxanai man ninkaiwen taea man benimakeanaii, chanima ea bechipai kayabidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na eska bebunkidi en matu yuiai chipu ikai uinkin en matu jancha wai shinankin man ea ikunwanxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Jakia mai anu yudabu yununika diablo Satanás ma juaiwen taea ana jatixuinda en matube janchamaki. Satanásan ea mei ewen kushipatidumabiaken jau shinanxun ea jaska wayununwen, chanima Epa Dios bechipaikin jaska ea yunua en axunmis yudabu en jatu uinmai kaidan. Jaskaki. Benidikanwen, nenua nun bununbunan— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","nun benibaunaibu nuku ana yuikin: —Ana betsa matu yusinun ninkayukanwen. Eadan, en uva bana nia jawen taxu kayabiki. En Epadan, miban ibuan mekekin meudumiski. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jatidi mebi tibi bimi jayamaken mextexun putamiski. Jakia jawen mebi tibi bimiyamis ana bimijaida wakin jawen ibuan bumextekin pewamiski, jau ana katakutan bimijaidanunan. Ea ikunwainbu en Epa Diosun jabiaskadi waxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","En jancha en matu yusiain man ikunwainwen taea man ma shinan betsa jaya man ma xunpinjaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jakia jawen taxu anua jawen mebi betsa meskea ana jaska bimitidumaki. Jabiaskadi wakin ea jenebainkin man Dios benimawatidumaki. Jaskaken en matu putama keska wakin eadi putayamaxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Eadan, en miban taxu keskaki. Matudan, man jawen mebi keskabuki. Ebe jaibunamekin bimi ichapaya keskakin man Dios benimawatiduki. Eauma man jawayatidumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ea jaibuwama ewen pechiadan, jawen mebi bimiuma mextetan putaima badin xana washina ichawaxun kua keska wakin Diosun chi anu jatu udenxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Janua matudan, ebe ketaxamexun en jancha shinankin unanjaidai jakimama chibankubainkin jawada bikatsis ikin man Dios yuka matu axunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jaskai duapanankin Diosun kushipa man jatu kenwanmaidan, bimi ichapayai keskakin chanima en tsumabu kayabi xabakabi man ixankanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Eanan en matu bechipaiaii, jaska en Epan ea bechipaikin akai keska wakinan. Jaskawen taea ea putapakeyamaxankanwen, en nui man jayawen taeadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jawen jancha en chibanyan ea bechipaikin en Epan ea putaismaki. Jaska keskadi wakin en yunua jancha man chibanyan matu bechipaikin en matu putamadi ixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Shinan chankain man ebe benimajaidanunbun jawen benimati jancha en matu yuiaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","14","Tsuada jawen jaibuaibuwen nuikin bechipaikin jatu medabewai mawaxunai tsuan jaskakin ana betsan binutidumaki. En jancha man chibankubainai man en jaibuki. Eskaki, en matu yunuaidan. En matuwen nuikin bechipaimiski. Jaska chibankin betsabuwen nui bechipainamekubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jamen betsadan, jawen dayakidi jawen dayadubu xanen ibun jatu xabakabi tapinmaismaki. Jakia dasibi en Epan ea yuia en matu unanmaiwen taexun yunubiakin en dayadu wakin matu kenama en jaibuwakin en matu kenaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Man ea katuama ean en matu katuniki. Jaskawen taexun en matu yunuaii. Kaxun jatu yusinkin man bimi ichapa wai keska wakin en tsumabu jatu wakin jau chintunyamanunbun jatu kushipa wakubainxankanwen. Jaska wakin en kenayaxun Epa Dios jamapai tibi man yuka matu axunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na jaska en matu yunuai keska wakinan, jabun ea ikunwain betsabube jatuwen nui bechipainamekubainxankanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","19","ana betsa nuku yuikin: —Jabun shinain keska man shinanyan ea ikunwanbuman matu bechipaikeanaii. Jakia ikunwanbuma anua en matu katuni jabun shinain keska man ana shinanmawen taexun ea dukun dananshinxun matudi danandiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","En matu yuixudan, shinaindakanwen: “Dayakapan jawen tsuma binuismaki”, akin en matu yuixuki. Jaskaken ea ichakawanixun jabiabundi matudi ichakawaxankanikiki. Jakia betsabundi en jancha ninkanixun matun janchadi ninkakin adiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jatun ea yununi jabun unanbumawen taexun na jaska tibi matu wakinan, man ea chibainbuwen taexun matu axankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","En yusin jua janchamaken jabu na mai anu jiweabun ibubis shinain: “En pepaki”, itidububia eskatian ana jaska waxun jatun chakabu ibubis juntantidubumaki, mekeidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jaska inun, ea danankinan, en Epa Diosdi danandiakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ja inun, jatu anuxun en jawa jatu jaska waxuanma chakabu shinanma ikeankanaii. Jakia tsuan jaska jatu anuxun jaska waxuinsmabiaken Diosun kushipa jatun bedubi en ma jatu uinmabia uinbiakin ea inun en Epa danankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jaskaken Diosun jancha yuixunikan yuikin: ‘Jawamawen taexun ichakawakin ea dananibuki’, iwanan, keneni keska menekin ea danankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Januxun matudi danainbun en Epa anua mekenan betsa matu anu en yunua janua Yushin Chanima Unanmanika juxun ekidi matu unanmai ea janchaxunxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ja inun, matudi en taxnikidanai anua tapin man ebe ikunkidanshinadan, man ekidi janchai chaninikabudiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ana betsa nuku yuikin: —Chipu jabun matu ichakawabu man ekidi jakimama shinan betsa wama man chintunyamaxanun bebunkidi en matu yuiai ninkaidakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Janu ichati jiwe anuxun matu danankin nichinkin nukunabu matuki dakemaxankanikiki. Ja inun, betsabun shinain: “Nun Dios medabewaii”, ikin tsuabuda matu betsa betsapa detekin ");
INSERT INTO cbsNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","en Epa Dios unanma eadi unanbumawen taexun matu jawa unanma ichakawaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Matu jaska waibuaibu en matu yuini matu shinanmai buaibuwen taexun bebunkidi en matu yuiaii. —Matube bebunkidi nibiaxun jaska xabakabi en matu yuiama iyuniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Jakia natianan, jatun ea yununi anu en samama kaiwen taexun ikis en matu yuixuki. En matu yuia ninkatan matumebi shinain juinti nishmaxun: “¿Jani min kaxanai?” man ea wamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jakia chanima en matu yuiai ninkakanwen. En matu kaxuanmakenan, Mekenan Bena matu anu jutidumaki. Jakia kaxun Mekenan Bena matu anu en yunuxanaii. Jaskawen taea en kayadan, matudan, man pepakunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ja Mekenan Bena juxunan, yudabu mai anuabu xabakabi Dioskidi chakabuwamisbu inun, jabun Dioskidi chakabuwama pepa wamisbuma inun, tsuabuda Diosun unanti watan kupixanai jatu unanmaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","¿Tsuabumen, Dioskidi chakabumisbudan? Jabun ea ikunwanbumadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","¿Tsuamen, Dioskidi chakabu jayamadan? En eaki, en Epa anu en kaken man ana ea uianma ixanaidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","¿Tsua axanimenkain, Diosun unanti waxun kupikinan? Na yudabu mai jidabi anu maniabu jatu xanen ibuxunmis ma unanti wanixun kupixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ana jancha ichapa en matu yusinkubainpanan jati man tsuma keyutidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jakia chipu Yushin Chanima Unanmanika juxun chanima dasibi matu yusinkin mextanmaxanikiki. Jawen shinanen janchama jakia ekidi dasibi ninkatan jawada ixanaidi matu xabakabi unanmaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ja Yushin Chanima Unanmanika jamebi juama en kushipa bitan matu unanmakin inankin matu kushipa waxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dasibi en Epa jayadan, enadiki. Jaskawen taea: “Yushin Chanima Unanmanika ena bitan matu unanmaxanikiki”, akin en matu yuixuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Jaskaida jatixuinda ka en jadi i iyamaki. Jakia samamajaida nun ana uinananxankanaii— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","mawa ana bestenxanaikidi janchai nun unanma yuinamei: —¿Jawa nuku yuikatsi ikimenkain? “Ana eskadabes ea uianma janunkain ana uxa eskadabes kaya man ea ana uinxanaii”, ikai inun: “Dios anu en kaxanaiwen taeadan”, ikin ¿jaskada nuku yui ixumen? ");
INSERT INTO cbsNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Ana uxa eskadabesdan”, ¿jawamen? Jadakidi daki yui ikikika!— nun ike ikeaya ");
INSERT INTO cbsNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nun yukapaia unankin nuku yuikin: —En janchawen taea man yuinameaidan, ");
INSERT INTO cbsNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","chanima en matu yuiaii. En mawaken ea manui kaxai man juinti nishmaken jabun ea ikunwanbuma benimajaidaxankanikiki. Jakia matudan, en mawaken matun juinti nui jenetan man benimajaidaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jaska inun, ainbu tuya bake kainkatsi punu nukai shinan chankainsmaki. Jakia kaintan: “Peki”, ika benimai isin jakimamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jabiaskadiai ikis man punu nukaki. Jakia en ana juaya man benimajaidaya matun benima pae tsuan matu mebintidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jabiatiandi ea uinkin man ea jawa yukama ixanaii. Jakia en Epa Dios man yuka ewen taexun matu medabewaxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ea ikunwankin taewabianixun en kenawen taexun man Dios yukadiamajaidaki. Na jabiatian en kenawen taexun Dios yukakin taewadikanwen. Jaska wakin man yuka matu axuan man benimaxanaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","januxun ana nuku yusinkin: —Jancha junea miyuiwen en matu yusinkubidanshinaki. Jakia ana jancha juneawen yusianma janu xabakabi en matu unanmaxanai ma kemaikiki. Jaskakainshinxun en Epa Dioskidi janu xabakabi kayabi en matuki chanixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jabiatiandi Dios en ana matu yukaxunama ixanaii. Janu matumebi ibubis en kenawen taexun man yukakubainxanaii, ");
INSERT INTO cbsNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","en Epa Dios matuwen nuikin bechipaiaiwen taexunan. Dios anua en juni ikunwankin man ea bechipaiaiwen taexun Epa Dios matuwen nuikin matu bechipaidiaikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jamen en Epa Diosun besuudia kainkidani na mai anu yudabube jiwenun ika en juni jaska ea yununi menetan natian ana jawendi kakin na yudabu en jenebainaii— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","januxun jawen tsuma betsan yuikin: —Chanima na jabiatian xabakabi nuku yui ana miyui jancha juneawen min janchamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Janunkain chanima mikidi nun unaiin. Nun mia yukadiama unankin nukun shinan min unain inun jamapai tibi min unainwen taexun Dios anua min junidan, nun ikunwaiin. Jaskawen taea min Diosun bake kayabiken tsuan nun ana mia yukai bika teneamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","jaska waya Jesúsun nuku ana yuikin: —¿Natian janu man ma ea ikunwain? ");
INSERT INTO cbsNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Man ea jaska wabiai janu man datei paxaidan, ma kemakanikiki. Uindakanwen, janu dasibi sa ikin man bestibu ea dapaxkabainkin man ea jenebiabaina eadan, en emestimaki. En Epa ebe ketaxamexun ea jeneamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ea jaibuwai eki dasia man dateama unanuma jiwexanun na jancha en matu yuixuki. Mai anuxun ea ikunwanbuman matu ichakawadiaibun dateyamaxankanwen, en ma jatu maemakin binuniwen taeadan— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","janua naiudi teskanxun uinkin nuku ninkamakin yuikin: —Epaan, janu min ea yubanidan, januki. En min bake mawai medabewakin ewen min kushipa jatu uinmawe, jatu en mia kenwanmaxanunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mai jidabi anua jawen yudabu dasibi yunuti kushipa min bake min ea inaniwen min jatu katuni en jatu jiwekuinmaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Min mia besti Dioski, chanimadan. Jesucristo Mesías min yununidan, en ea bestiki. Nuku unantan na jiwekuinyanwen jiwexankanikiki, ikibi ikidan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yudabu anu en mia dayaxunun min ea nichini mia axunkin keyukin mia duawakin en mia jatu kenwanmakubainshinaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Epaan, eskatianan, mai nun damiwadiama min besuunbia en xanen ibui taeaitian en chaxakapa jawendua jayani keska jabias ea inanxanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yudabu dasibi anua jatu katuxun min ea yunua min Dios kushipa dasibi binu keyua nuikipakidi en mia jatu unanmakubainshinaki. Jaska inun, mina katuxun min ea jatu inanidan, min jancha ninkamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Min jancha min ea yununi ma en jatu yusianki. Jaskawen taexun dasibi en jancha minadan, ma tapianbuki. Chanima min ea yunua mianua en juni unankin ikunwan chakayamakanikiki. Jaskawen taexun min kushipa inun min yusinti mianua juai unankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","Jamen enabudan, en mibe jatu janchaxunaii. Jakia ea ikunwanbumakidi en mibe jatu janchaxunamaki. Ja inun, mina watan min ea yununidan, jadan minabuki. Jaskawen taea dasibi enadan, minaki. Janua minadan, enadiki. En kushipa jatu medanua uinxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Natianan, ma mia anu en mibe iki kaii. Na mai anu en ana jatube jiwekunkainamaki. Jakia enabudan, na mai anu jatube jiweyukubainkanikiki. Jaskawen taexun Epa medibi pepa bestituun, min kena kushipawen ea jatu mekexunxanwen, ja kena kushipa min ea inaniwenan, nun paxkama keskadiai jau jabudi paxkamadi idiakubainxanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na enabudan, mai anua jatube jiwexun min kena kushipa min ea inaniwen chakabu nemakin en jatu mekekubidanshinaki, jawa jatu benuamadan. Judas besti jaska jakidi kenenibu keska aki ma benuni iki kaxuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mianu kakatsi en benimajaidaii. En jatu putabaindiama jau jabun ea ninkakin jabias en benimai keskai jau idianunbun en mibe janchaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mikidi en jaibuaibu en jatu yusianyan jabun shinan betsa wai pepaibu jabun ea dananmisbun ea jatube dananmisbuki, nun yudabun shinan keska jayamakenan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jabiaskabiaken: “Ikunwanbuma anua jatu dapaxkamabainwen”, iwanan, en mia yukamaki. Jakia jau diablo Satanásan jatu padanyamaxanun jatu nemaxunkin mekexanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ja inun, na mai anua Dios ikunwanbuma en jatu keskamawen taea ea ikunwainbudi jatube jiwebia jabu keskamadiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Min jancha chanima kayabiki. Ja chanima janchawen min medibiki. Min jancha jaskawen taexun jatu medibi wawe, jabun min jancha chanima chibanxanaibudan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jaska inun, na mai anu mia unanbuma anu min ea yununi keska wakin en jaibuaibu jabiaskadi wakin na mai anuadi en jatu yunudiaii, jau mikidi jatu yusinkubainxanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jatuwen taea ea dukun iki en jatu medibixunxanaii. Jaskawen taea chanima jabudi jau min jancha chanima kayabiwen medibidianunbunan, jawa kanetimadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na en jaibuaibu besti shinankin jabukidi besti en mia yukaxunamaki. Jakia jabun jatun jancha kakape ninkatan ea ikunwanxanaibudi en mia jatu yukaxunaii, min jabudi mekekubainxanunan. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Jaskai mia inun ea dasia nun bestichai keska jiwea jabudi nukuki dasiabu jabiaskadi wakin min jatu medabewaxanun en mia jatu yukaxunaii. Min jatu jaska wa jabu xukuxun ea ikunwainbu mai jidabi anu min ea yununi unantidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jaska mia inun ea dasinixun nun jabiaskas shinanmis keska wakin enabu jabiaskadi min jatu shinanmaxanun, iwanan, min kushipa min ea yununi en ma jatu yunuaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mia inun ea nun dasiniken jabubedi en dasiaya jabu yuda bestichai keska jau ixanunbun en mia jatu yukaxunaii. Jaskaibu mai jidabi anuabun jatu uinkin min ea yununi inun jaska wakin min ea bechipaimis jabudi min bechipaidiaidan, jabun unantidubuki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Epaan, mai damiwakin taewadiama min ea bechipaikin ea chaxakapa jawenduawakin taewani min jabiaskadi ea wai jau ebe jiwekin uinxanunbun jabu min ea yununi ebe jatu jiwemaxanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Epaan, min kaneismaki. Mai jidabi anu yuda jiweabun mia unanbumabiaken ean, en mia unaiin. Na ebe mapuabun min ea yununi unankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jaska inun, mikidi min kushipa binu keyua en jatu unanmapakeaiwen taexun ana mikidi en jatu unanmakin jeneyamaxanun min ea bechipaimis keskai jau jabudi bechipainamei jeneama ixanunbunwen, nuikipaidan. Jaska jayabuwen taea ea en jatu anua kainkainama ixanaii— itan ");
INSERT INTO cbsNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Diosbe nuku janchaxuni menetan januxun nuku kainmabainkin paxku debu jawen kena Cedrón Jesúsun nuku pukemabaini janu miban xukua mishkiwen kenenibu anu ukemedan nun jabe jikiken ");
INSERT INTO cbsNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","janu Jesúsbe nun ichakunkainmis anu jabianu nun ana ichaken janu Judasin unanjaidai ");
INSERT INTO cbsNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","jadi jatu iyui Diosbe nukunabu janchaxunika xanen ibubu inun fariseobubetan jatu yunuabu jatidi Templo mekenikabu inun romano soldadobu xuku betsa Judasin jatu iyua jatun detetiya mesebaini bin dekutan chaxa dakabainaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús achi beaibu dasibi ma unainwen taea nuku bebun Jesús nitan jatu yukakin: —¿Man tsua benai bekanai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","jabun achi beaibun betsan Jesús kemakin: —Jesús Nazaret anuadan— akaya Jesúsun ana yuikin: —Jabia en eaki— jatu waya Judasin jatu achimai kai jawaidakain ma jabe niken ");
INSERT INTO cbsNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","jaskai Jesús janchai ninkatan chixtekidi xekibaini di ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesúsun ana jatu yukakin: —¿Tsuadaka man benai bei ikanai?— jatu wa ana jabiaskadi jabun yuikin: —Jesús Nazaret anuadan— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—“Jabia en eaki”, akin en ma matu yuixuki. Man ea besti benaiwen taexun en jaibuaibu jatu meyamakanwen, jau bununbunan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","bebunkidi Jesúsun yuikin: “Epaan, min ea yununi en tsua jatu benuamaki”, akin Jesúsun yuixuwen taexun: “En jaibuaibu meyamakanwen”, akin Jesúsun jatu nemaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Januxun Simón Pedron jawen nupe chaipa sitan Diosbe nukunabu janchaxunika xanen ibujaidatun tsuma Malco mapexpaikin maebain pabinki yusiudia paxteaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","nemakin Jesúsun Pedro yuikin: —Ana jatu meama min nupe ana jawendi usunwen. En Epan jaska ea yununi jabiaskadi wakin ea yumanwankanikiki. Ea yaushiyamawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","januxun jatun xanen ibu capitánbetan romano soldadobu inun Templo mekenikabun Jesús achixun menextan ");
INSERT INTO cbsNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","iyukin ja dukun jatun xanen ibu Anásin jiwe anu iyuabun jawen dais Caifás na badi bestichai Diosbe nukunabu janchaxunika xanen ibujaidatun ");
INSERT INTO cbsNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","bebunkidi judiobu jatu yuikin: “Nukunabu jau paxkai sa iyamaxanunbun juni bestichai nukunabu mawaxunaya man pepakunkainxanaii”, akin jatu yuimanudan, ");
INSERT INTO cbsNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús iyuaibun Simón Pedro inun ean june chipu kakin nun Jesús chibankubaini xanen ibu Anásin enabun ea unainbuwen taea janu ichamisbu dintu anu Jesúsbe en jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","jakia Pedro unanbumawen taexun nemakin niti akabu jikiama bai kexa Pedro niken janua jemaintin kene janu jikiti xui anu ana kaxun xui mekenika ainbu yukaxuntan Pedro en bichiaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","xui mekenika ainbun Pedro yukakin: —Ja junin tsuma betsadan, ¿jabia min miamen?— aka —Eadan, en jamaki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","janua ma matsi beaya janu dayamisbu inun Templo mekemisbun jemaintin chi keti watan yui mapubaunabu jatube nashui ika Pedrodi yuaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","januxun Diosbe nukunabu janchaxunika xanen ibujaida ikunkainima ma taxnima anu Anásin jiwe anu bichiabu jawen tsumabukidi inun jawen yusiankidi Jesús yuka taewa ");
INSERT INTO cbsNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesúsun kemakin: —Ninkaibun en janchakunkainmiski. Janu ichati jiwe tibi inun Templo jemaintin anuxun nukunabu ichamisbu anuxun xabakabi dasibibun bedubi en jatu yusinmiski, june jatu yusianmadan. ");
INSERT INTO cbsNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ea yukama jabun en jancha ninkamisbu jatu yukawe. Jawada en jatu yusinmis unanjaidakanikiki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","jadi Jesúsun kemaya Templo mekenika betsa Jesús dapi nixun meken pechiudi kepais akin yuikin: —Nukun xanen ibujaida jaska yuiyamawe— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesúsun yuikin: —En yui chakayadan, ea unanmawe. Jakia en pe yuibiaya ¿jaskakin e iskaun min ea deteai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","janchawen binutiduma unantan Anásin jatu yunua Jesús menexekea jabiaska Diosbe nukunabu janchaxunikajaida binua Caifás anudi iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ja jaska waibun Pedro jatube chin yui nashui ika yuaya betsabun yukakin: —¿Min jamamen, ja junin tsuma betsadan?— abaunabu Pedron jatu padankin yuikin: —En jamaki. En eamabin!— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","januxun xanen ibujaida binuatun tsuma betsa Pedron patsanka jawenabundi Pedro yukakin: —¿Miban xuku anuxunan, Jesúsbedan, en mia uianma ikidanxumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedron ana jadi padankin: —En jamaki— itanayas jawaida jabiatiandi takada keui taeaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","januxun Caifásin Jesús yukakin keyutan penaya romano xanen ibu Pilaton jiwe ewapa anu Jesús jau iyutanunbun romano soldadobu yunuaya judio xanen ibubun shinain: “Nawan jemaintin anu jikia Moisin nuku yusiniwen taea nawan detsiswen chakabutan ana Pascua nawai besikin en pitidumaki”, iki pepai nawayukatsi jikiabuma ");
INSERT INTO cbsNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","jaskaibun jatun beya unantan jatu anu Pilato kaintan jatu jancha wakin yukakin: —Na juninan, ¿jawa chakabu ashian man jakidi yuiai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Juni chakabumakenan, mianu nun iweama ikeanaii. Unanti watan nuku kupixunwen— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatondi jatu yuikin: —Iyuxun jaska matun xenipabun matu yusinpauni keska wakin matumebi unanti watan kupitankanwen— jatu wa judio xanen ibubun yuikin: —Nun tenanpanan min nuku nemamiski. Jau tenanunbun mian besti min yunutiduki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","jaska wakin tenanxanaibu Jesúsun nuku yuishinadan, unanmabia jabiaskadi jatu amaya ");
INSERT INTO cbsNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ninkatan jawen kene medan ana jikixun Pilaton Jesús kenaxun yukakin: —¿Miadan, min judio xanen ibubu binu keyuamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesúsundi yukakin: —¿Mimebi min ea yukai? ¿Juni betsan mia ekidi yunuadaka min ea yukai ikai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","e itan Pilaton yuikin: —Eadan, en judiomaki, jaska min ea yuipananan. Minabu judiobu inun min xanen ibubu Diosbe janchanikabun mia ea inankanxuki. ¿Min jawa chakabu meshinamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","kemakin: —Eadan, en Xanen Ibu kayabiki. Mia yuinun ninkawe. Nenua junibu xanen ibumisbu keskai en xanen ibuamaki. Jakia en kushipadan, na nenu mai anua yudabun shinain jiweabu keskamaki. Jakia na, mai anua en xanen ibuaya judiobun ea achixun mia anu ea iweyamanunbun en tsumabu ewen taea nemakanai jatube detenamekeankanxuki. Jaskaken eadan, en Xanen Ibu kayabiki, nenuamadan. En jawa chakabu jayamaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","januxun Pilaton ana yuikin: —Jaskakenan, chanima min xanen ibu kayabidaka— aka Jesúsun ana yuikin: —Min jaska jadi yuiaidan, en Xanen Ibu kayabiki. Jaskanun ika yudabube jiwei en taxnikidaniki, jatu chanima kayabi mextanmaidan. Tsuabunda chanima jancha bechipaikin en jancha ninkamisbuki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","romano xanen ibu Pilaton yuikin: —Chanima janchadan, ¿jawamen?— itan jaska wa janu judio xanen ibubun manaibu anu ana kainkidan Pilaton jatu yuikin: —Ja juni en unanti waxudan, jawa chakabu jayamaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pascuatian badi tibi juni bestichai jawa wama en matu nichinxunmis keska wakin, ¿judio xanen ibu kayabi Jesús jawa wama matu nichinxunpa?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","dasibibun jui kushipawen yunukin: —Ja nuku axuanma ja juni betsa Barrabás yumetsubiaken nuku ja kainmaxunwen— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilaton ninkawanxun jatu yunua bichi kushatiwen Jesús kusha kusha atan ");
INSERT INTO cbsNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","kaxe wakin romano soldadobun nishi muxaya maiti waxun Jesús maimaxun xanen ibun bemakia tadi tashijaida sawematan ");
INSERT INTO cbsNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","bestibu Jesúsun besuudi nixun kaxe wakin yuikin: —Judio xanen ibu kayabidan, min miaki— iwanan, jawen besuki bepaistantanaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ana kaintan judio xanen ibubu yuikin: —Jesúsun jawa jatun chakabu wama ishian en matu unanmakin kainmai uinkanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","muxa maiti inun tadi pauti tashipa meshu duakabi sawemabu jawen besu jimin iduma Jesús kainkidanaya Pilaton tenankatsi ikama ana jatu yuikin: —Na juni man iwexudan, uinkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","uinkin Diosbe nukunabu janchaxunika xanen ibubu inun Templo mekenikabun jui kushipawen Pilato yuikin: —Cruzki mastawe! Cruzki mastawe!— akeakeabu jaska waxun atidubuma unanbiakin Pilaton jatu kaxe wakin ana yuikin: —Jawa chakabu jayamaki. Matunmebi iyuxun aditankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Diosbe nukunabu janchaxunika xanen ibubun yuikin: —Chani chakai: “En Diosun bakeki”, imiski. Diosun jancha Mosésin nuku kenexuni nun jayaki. Jaskawen taexun Dios yuankin kanemiswen taea nun yunuaiwen taeadan, jau mawanunwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","jaska yuiaibu ninkatan Pilato ana datekin ");
INSERT INTO cbsNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","jawen kene medan ana chintuanbain Jesús iyuxun yukakin: —¿Min janiamen?— aka Jesúsun ana jawa yuiamaken ");
INSERT INTO cbsNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","jaki sinatakin Pilaton ana yuikin: —¿Min ea ana jancha wamamen? En kushipawen jawa wama en mia nichintidu inun en kushipawendi en mia jatu mastamatidu, ¿min unanmamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","jaska yuiai ninkatan atimas Jesúsun kemakin: —Diosun dasibi damiwanitun mia kushipa yunuama ekidi min kushipa jayama ikeanaii. Jaskaken jabun ea achixun mianu yunuxun ea nichianbunan, jabun chakabudan, mina binuabuki, Dios sinatamakinan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","jaska wa ninkatan Pilato taxnikidan Jesús jawa wama nichinun ikaya judio xanen ibubun jui kushipawen Pilato ana yuikin: —Tsuada xanen ibu kayabi ikatsis ikin min xanen ibu kayabi César danankin jawen kushipa mebinpai imiski. Jawa wama Jesús min nichiainan, min Césarn jaibumaki— akubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","janu Pascua meshukidi ixanaitian ma badi manananbi kaya jaskaibu Pilaton ninkatan Jesús taxnimabidan mishki buyakin kedan wanibu jawen kena hebreo janchawen kenakin Gabatá januxun yunuti anu tsauxun kaxe janchawen judio xanen ibubun jatu yuikin: —Nadan, matun xanen ibu kayabiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","jaki sinatakin jancha kushipawen yuikin: —Tenandiwe! Tenandiwe, cruzki jatu mastanmatanan!— ikubainaibun Pilaton ana jatu yukakin: —¿Jaskakin matun xanen ibu kayabi jatu mastamapa?— jatu wa Diosbe nukunabu janchaxunika xanen ibubun yuikin: —Nukudan, nun xanen ibu betsa jayamaki! César besti nukun xanen ibu kayabiki. Jatu mastamadiwe!— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","jatun janchawen taexun Jesús jatu mastamakin romano xanen ibu Pilaton jawen soldadobu yunua iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","januxun jaki mastakatsi cruz Jesús iamatan xadamabainkin Jerusalén uke medanua kainmabainkin ja mati jawen kena Buxka Xau Mati anu mapematan, hebreo janchawenan, Gólgota anudan, ");
INSERT INTO cbsNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","20","januxun jawen tadi pekaxun cruzki mastaxun: “Nazaret anua Jesús judiobun xanen ibu kayabiki”, iwanan, Pilaton jancha dabe inun besti ji bexa sapaki hebreo janchawen inun, griego janchawen, inun romano jancha latinwen kenetan jatu buma Jesúsun buxka mamaki cruzki ja mamaki mastaxun netanbu romano soldado betsabundi juni yumetsu dabedi mastaxun betsa yusiudi nichinxun betsa yusmaudi nichintan Jesús namakis wabu Jerusalén dapikea bukin Pilaton jancha Jesúsun buxka mamaki netan judio ichapabun uinbainbainkin ");
INSERT INTO cbsNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","jaska wabu uinbain Diosbe nukunabu janchaxunika xanen ibubu Pilato anu buxun yuikin: —Jadi min kenexun jatu netanmatidumaki: “Judiobun xanen ibujaidaki”, akinan. Jakia jaska ibubis yuimis keska jatu kene betsa waxunwen, eska wakinan: “Eadan, en judiobun xanen ibu kayabiki”, imiskididan— akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaton jatu nemakin: —Jawada en ma keneadan, jau jabiaska kene nenunwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","cruzki Jesús nichinxun soldado dabe inun dabetan Jesúsun tadi tibi jabu tibibun paxkatan jakia jawen sanpu chaipa jidabi kexemawen taea ");
INSERT INTO cbsNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","yuinamei: —Paxkakin chakabuwayamanankanwen. ¿Tsuan bimenkain? jawen beyusti jexe putakin tsadin tsadin akin putanankanwen— iwanan, jaska bebunkidi Diosun jancha anu kenekin: “En tadi paxkakin en sanpu bikin jawen beyusti putaxankanikiki”, akin yuini unanmabia jaska kenenibu soldadobun jabiaskadi wanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jaska waibun Jesús mastabu dapi jawen ewa inun, jawen ewa betsa Cleofásin ain María inun, María Magdalena inun, ea nun nia ");
INSERT INTO cbsNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","27","jawen ewa inun ea uinkin ekidi Jesúsun yuikin: —Ewaan, ja mia dapi niadan, min bakewawe— iwanan, ea bechipaijaidamisxun eadi yuikin: —Baa, ikis en ibu min ewa ea waxunwen. Ea uindaxunkubainxanwen— ea wa en jiwe anu iyuimaxun en medabewapauniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesúsun jaska nuku yuitan dasibi jawen Epa Diosbe yubakani keyuai unain Diosun jancha anu jaska jakidi keneni menei Jesúsun jui kushipawen yuikin: —Ma unpax manui en tetsusinaki— ikai ");
INSERT INTO cbsNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ninkatan jabun kenpuki uva vino muka mata tsaua jaki tsinitiki pu atan tawaki ustanxun Jesúsun kexa anu sananxunabu ");
INSERT INTO cbsNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tsu akin keyutan jui kushipawen Jesúsun yuikin: —Dasibi en ma keyuaki— itan bekua tinian mawakin jawen Yushin ibu anu nichiniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Janua judio xanen ibubu yuinamei: “Meshukidi sábado janu medibijaida Pascua nawatitianki. Cruzki jatun yuda mapuabu sábadotian nun jenetidumaki, Dios jau nukuki sinatayamaxanunan. Jatun yuda jau jawaida butenunbun Pilato yununun bukanwen”, ika buxun Pilato yuikin: “Cruz anua jatun yuda jawaida butetiki. Jau jawaida mawanunbun jatun kishi jau kishtekenunbun jatu yunuwe”, akabu ");
INSERT INTO cbsNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilaton jabiaskadi shinankin jatu yunua soldadobu buxun ja dukun juni yumetsu dabe Jesúsbe mastabu kishtekedabetan ");
INSERT INTO cbsNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","janua Jesúski kemaxun ma mawa uintan jawen kishi tekeabuma ");
INSERT INTO cbsNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","jabiaskabiaken soldado betsan jashinwen Jesús pishipe akabu janua jakimamadi jimi jawen jene jusia jabaya ");
INSERT INTO cbsNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","jakia bebunkidi Diosun jancha keneni anu yuikin: “Jawen xau tekeama ixankanikiki”, anibu inun, kene betsa anuxun yuikin: “Tsuada chachiabu jawenabun uinxankanikiki”, iwanan, kenenibudan, unanmabia jabiaskadi keneni menekin adianibuki. Matundi man ikunwanxanunbun jawada ibubis en uini en matu yuiaii. En uiniwen taea en jancha chanimaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Januxun juni betsa José jawen mae Arimatea judio xanen ibubuki datekin june Jesús ikunwanshinatun Jesús mawa unandiai jakia natian ana dateama Jesúsun yuda maiwakin janatanun ika kaxun Pilato ea akin yuka jawen yuda yunua José jawen tsumabube kaxun Jesúsun yuda cruz anua butexunabu ");
INSERT INTO cbsNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ja dikabi meshu medan Jesúsbe janchatanyama Nicodemon jawen tsumabubetan 30 kilo mirra inun áloe ininti teipa jusia bea José jawen tsumabube kaxun ");
INSERT INTO cbsNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","jaska judiobun yuda mawa maiwakin pewamisbu keska wakin Jesúsun yuda dapuxyabi yabukubainkin ininti teipawen dapuxkubainkin tadi juxupawen yabukin keyutan ");
INSERT INTO cbsNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","42","badi jiki ma juindukunti kemaya jin jin ikin janu Jesús mastakanxu dapi miban xukua naman janu yuda mawa datanti mishki tanpe kini bena waimabu janu yuda mawa datandiabuma anu jawaida ja medan janakin mistutan mishki ewapa beputiwen beputan inun bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Janua Jesús mawashina ana besteni matu yuinun ninkakanwen. Juindukuntitian Jesúsun yuda mishki tanpe medan dakaken uxa dabea penai taei penadiama meshuken domingotian taeaya Jesús maiwakin janashinabu anua jatube María Magdalena kakin tanpe bepemana uintan Jesúsun yuda jayama uinbidani ");
INSERT INTO cbsNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pedro inun ea anu kushi chakayamakidan nuku yuikin: —Nukun Xanen Ibun yuda janidaki nuku buanbuki. Janida datanbu nun unanmaki— nuku wa ");
INSERT INTO cbsNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ninkatan Jesús maiwashinabu anu Pedrobe kai ");
INSERT INTO cbsNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","kushidabekainkin ea dukun binukain tanpeki ");
INSERT INTO cbsNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","kemaxun dankukain tanpe medan uinkin jawen yabushinabu besti daka bechitan en jikidiamaken ");
INSERT INTO cbsNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ea ichun chipu Simón Pedro jui ja dukundi jikixun jawen yabushinabu uinkin ");
INSERT INTO cbsNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","jawen buyabushinabu sebi pewaxun ja kachu datan uindiaya ");
INSERT INTO cbsNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","9","janua eadi jikixun jawen yuda yama uintan: “Mesías Cristo mawa ana bestenxanikiki”, iwanan, Diosun jancha una medan kenebianibu nun ninka pewadiamabia: “En Xanen Ibu Jesús ma bestenkainamenkain”, ikin ikunwankin en shinaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jaskakain uintani nun ana chintunkidaniki, janu nun jiwe anudan. ");
INSERT INTO cbsNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Jakia María Magdalena katani ana chintunkidan jua mishki tanpe kexa nia kaxai jeneama nixun ana uinun ika dankukain tanpe medan uinkin ");
INSERT INTO cbsNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nai tsuma dabe tadi juxupa sawea janu Jesús datanshinabu anu jadidi bupinshinabukidi betsa tsaua jadidi taxkunwanshinabukidi betsa tsaudia jatu bechitanaya ");
INSERT INTO cbsNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","januxun nai tsuma dabetan yukakin: —Ainbuun, ¿jaskai min kaxai?— akabu —En Xanen Ibun yuda janidaki ea buanbuki. Janida datanbu en unanma benai en kaxai ikaii— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","nasaukekauan uinbiakin tsua nia dabanen unanma Jesús bechia ");
INSERT INTO cbsNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","januxun Jesúsundi yukakin: —Ainbuun, ¿jaskai e iskaun janu jua min kaxai ikai? ¿Tsua min benai ikai?— aka miban taudumis ikai dabanen Marían shinankin yuikin: —En Xanen Ibun yuda buxun jani min ea datananxumenkain ea yuiwe, en buaidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesúsun yuikin: —Maríaan— aka jawaida dabeketan benimajaidakin hebreo janchawen yuikin: —Rabuni!— akin nukun janchawen kenakinan: —En Yusinaan— iwanan, ikua ");
INSERT INTO cbsNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesúsun nemakin: —En Epa anu kadiama uatian en matube jiwemis keskai en ana matube itidumaki. Ea tsumakin ea bashiyamawe— iwanan, —En betsabu anu kaxun en mia yuixu jatu yuiditanwen. Matu medabewai en Epa anu dasinun ika en kaxanaii. En Epadan, jabia matun Epadiki. En Dios mekenikadan, jabia matun Dios mekenikadiki— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María Magdalena kaxun Xanen Ibu Jesús ana jiwea uintanxu jadi Jesúsun axu nun jawen tsumabu nuku yuia nun ninkaken ");
INSERT INTO cbsNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","jabias domingo meshu medan Tomás nukubemaken jiwe medan ichatan judio xanen ibubuki datekin beputi nun bexekin keyuken Jesús jikikain damitushitan nuku nashui ika nixun nuku jancha wakin: —¿Jaska man unanumamen? Ma en juai dateyamakanwen— nuku watan ");
INSERT INTO cbsNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","januxun nuku jaska watan jawen meken xui inun jawen jashi xui nuku uinmaya nukun Xanen Ibu ana uin nun benimajaidaya ");
INSERT INTO cbsNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ana nuku yuikin: —¿Jaska man unanumamen? En matu juxuanki. Datetima kushipa en matu bashixunaii. Jaska inun, jaska en Epa Diosun ea nichinkin yununi keska wakin en matu nichinkin yunudiaii— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","kushipa wakin nukukidi kunchunkain kushu atan nuku yuikin: —Yushin Pepa jayadikanwen. Jaskatan tsuabuda Dioskidi jabu chakabu jaya man jakimawaken Diosundi jatun chakabu jatu buaxunxanikiki. Jakia jatun chakabu man jakimawamaken Diosundi jatun chakabu jatu buaxunama ixanikiki— nuku watan janidaki ana dami kainken ");
INSERT INTO cbsNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","25","Jesúsun 12 tsuma kushipaya betsa Tomás tsupibu bakeken jawen kenamisbu nun xukua anu Jesús jua nun uinshinken jabiatiandi nukube ikama ishinken meshukidi juai betsan Tomás nun yuikin: —Nukun Xanen Ibu jiwea nun uinshinaii— nun akeakea nuku ikunwanma yuikin: —Jawen meken anu mastashinabu xui en uianma jabianudi en metuti en mistuama chachishinabu jawen jashi xui en mekenwen en mekin mistuama Jesús ana jiwea en ikunwantidumaki— nuku washinken ");
INSERT INTO cbsNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ana 8 día kaya Tomásbe ichaxun ana nun xui bepukin keyuken Jesús ana jikitan nuku bebun damia nashui ika nixun yuikin: —¿Jaska man unanumamen? Ana en juai ewen dateyamakanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomás jabis yuikin: —Ikis ea uindiwe. En meken xui mewe. Meken sananbain en jashi xui mistudiyuwe. Ana ikunwanbuma keskama en jiwea ea ikunwanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","uintans damapaikin Tomásin yuikin: —Chanima min en Xanen Ibuki, en mekenan yushin Diosdan!— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—Ea uintans min ea ikunwaiin. Jakia jabun ea uianma en jashi xui uianmabia ea ikunwanxanaibudan, Diosun jatu duajaida waya benimakubainxankanikiki— akai nun ninkaya ana jabiaskadiai damikainiki. ");
INSERT INTO cbsNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","31","Chanima ana jawen unanti dami ichapa Jesúsun nukun bedubi abiakubainiken dasibi en matu kenexunamaki. Jakia dasibi man uianmabia en jancha keneai uinkin ninkakin unantan: “Jesús Mesías Cristoki, Diosun bake kayabidan”, akin Jesúswen taea man jiwei ikibi ixanai man ikunwanxanunbun en matu kenexunaii. ");
INSERT INTO cbsNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jerusalén anua Jesúsun nuku bechimai janchashina ana Galilea Ianenwan jawen kena betsa Tiberias Ianenwan kexa anu nun jawen tsumabu nun ka Jesúsun eska wakin nuku uinmani matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Galilea anu nun ka Simón Pedro inun, Tomás ‘Tsupibu bakeen’, akin nun kenamis inun, Natanael jawen mae Caná Galilea anua inun, nun Zebedeon bakebu ea inun en betsa Santiago inun, ana Jesúsun tsuma dabe betsa nun icha mapuabun ");
INSERT INTO cbsNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedron nuku yuikin: —En baka nexei kaii— ikaya —Nun mibe kaii— abaini jabe kai jawen xaxu ewapawen nanetan jabe kaxun jawen jisin ewapa puntebiashinkin nun jawa baka biamajaida ishianyan ");
INSERT INTO cbsNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ma penakidanaya Jesús ian kexa nia uinbiakin tsua nia dabanen nun unanmaken ");
INSERT INTO cbsNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","jui kushipawen Jesúsun nuku yukakin: —Bakebuun, ¿bakadan, man jayamen?— nuku wa nukun kemakin: —Nun jawa biamajaidaki— nun wa ");
INSERT INTO cbsNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Ja xaxu yusiudi jisin ana puntekanwen, jaudixun man biaidan— nuku wa jaska nuku yunuxudi nun puntebauna ninibidankin baka dasibi nuku nexema jaska waxun xaxun nun nanetimaken ");
INSERT INTO cbsNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","en ea Jesúsun bechipaijaidamistun Pedro yuikin: —Nukun Xanen Ibu daki ikikiki— en wa Simón Pedro jawaida ninkatan tadi pekaxun jisin punteshinai jawaida sawekin kedun atan ishchui pukutan nunakainaya ");
INSERT INTO cbsNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","jakia 100 metro besti xaxuwen kakin jisin baka mata xadabaini nun jawen tsuma betsabu keti itan ");
INSERT INTO cbsNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","xaxu anua butukainkin chi dekenen besti baka xuiai inun misi mania nun uianyan ");
INSERT INTO cbsNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","januxun Jesúsun nuku yunukin: —Ja baka man bixudan, nedi eskadabe bekanwen— nuku waya ");
INSERT INTO cbsNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","janua Simón Pedro kakain xaxun inatan jisinman baka ichapa bia ninikin xadabidankin mashin mapema 153 jati baka ewapabu nanea jisin baxnekeamaken ");
INSERT INTO cbsNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","13","Jesúsun ana nuku yuikin: —Piyui bekanwen— nuku wa nuku baka nexemaxunwen taea: “Nukun Xanen Ibuki”, ikin unantan: “¿Min tsuamen?” iwanan, nun yukama misi inun baka xuia bixun nuku inan keyutan ");
INSERT INTO cbsNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","jaskai mawashina ana bestenkainshinxun Jesús nukuki dabe inun bestiki nukukin nuku uinmaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Januxun pikin nun meneaya Jesúsun Simón Pedro yukakin: —Juanen bake Simóneen, ea ninkawe. Nabun ea bechipaiaibun miandi ea bechipaikin jatu binunun, ixun, min yuishinadan, ¿jabiaskas min shinain?— aka —Xanen Ibuun, en mia bechipaiaidan, min unaiin— aka —Jabiaskadi wakin enabu chaxuwan bake keskabu jatu ea mekexunkubainxanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ana Pedro yukakin: —Juanen bake Simóneen, ¿min ea bechipai kayai?— aka —Jaa, en mia bechipaiaidan, min ea unaiin— aka —Jabiaskadi wakin ea ikunwainbu chaxuwan keskabu ea jatu mekexunkubainxanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ana jawen jenekin Pedro yukakin: —Juanen bake Simóneen, ¿min ea bechipaijaidai?— aka dabe inun bestiki jabias yukaiwen taea Pedro juinti nishmai punu nukatan bechipaiaiwen taexun yuikin: —Xanen Ibuun, en shinan dasibi unankin en mia bechipaijaidaidan, min unaiin— aka —Jabiaskadi wakin enabu chaxuwan keska jatu yusinkin jatu ea mekexuindakubainxanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","19","Jesúsun Pedro ana yuikin: —Chanima en mia yuiai ninkawe. Bedunan kushipakin tadi sawetan janida kaidan, min ma itishadashinaki. Jakia min anibu meshan dakaken juni betsan mia tadi sawemakin janu min kakatsi ikamabiaken mia iyuxankanikiki. Jabiaskabiaken ea ninkatan ea chibanpakewe, ikisdan— akin jaskatan Pedro mawakin Dios jatu kenwanmaxanai jau ninka pewanun Jesúsun yuiai nun ninkaniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Jesúsun jancha ninka keyutan dabekekaun ea Jesúsun bechipaijaidakubainmis badi kaya pi dakaxun en yukakin: —Xanen Ibuun, ¿tsuan mia akimenkain, jatu achimakinan?— en washina jawen pechiudia en juai Pedro dabekekaun ea uinkin Jesús yukakin: —Xanen Ibuun, ja junidan, ¿jaska wadiaxankanimenkain?— aka ");
INSERT INTO cbsNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesúsun kemakin: —Xanen ibui en ana judiamakenan Juan jiwea mawamas ixanai keska en shinain jawen dabanan iyamawe. Mianan, jaska en mia yunumis besti akubainkin ea chibanpakexanwen —akin Jesúsun Pedro yuiniki. ");
INSERT INTO cbsNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jaska bestibianiken ikunwainbu ekidi yuinamei: “Jawen tsuma Juan Jesúsun bechipaijaidanidan, mawamas ixanikiki”, ikin ekidi kaka akeakenibuki. Jakia: “Mawama ixanikiki”, akin Jesúsun ekidi yuiama jakia: “Xanen ibui en ana judiamaken Juan jiwea mawamas ixanai keska en shinain jawen dabanan iyamawe”, akin Jesúsun Pedro yuibianikenan. ");
INSERT INTO cbsNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","25","Ana midima Jesúsun akubaini dasibi nun kene keyuadan, jati una mai jidabi anuxun meketidubumaki. Jakia Dioskidi Jesúsun nuku unanmai uinkin ninkakin dasibi en tapiniwen taexun en jancha chanimawen ean ibubis en matu kenexunxudan, jatixuki. Juan");
INSERT INTO cbsNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","En jaibu pepa Teófiloon, ja dukun una en mia kenexun bumaimadan, ja dukun Jesúsun jatu yusinkin axunkin taewabidanimadan, jaska dasibi jakidi en mia kenexun bumaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nai anu kadiama Yushin Pepaki dasia nixun jawen tsumabu kushipayabu yusinkin jau jaska katuxun chanima akubainxanunbun jatu yunuyabis xaba betsatian nai anu inakainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Janua ma mawabiashina besteinmaxun jawen yuda kayabi ana xabakabi jatu kayatiwamakin jau unantijaidawanunbun xaba 40 día jatu uinmakin jaskai Dios nuku xanen ibuxunxanaikidi jatu jancha wakubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Janua Jesús jawen kushipayabube niyuxun jau Jerusalén anua kainbainyamayuxanunbun jatu nemakin yuikin: —Jaska Epa Diosun matu yubani en matu yuishinadan, jau matu inankin yunuxanun nenua kaianma jabianuxuns manayuxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Chanima Juanen jenewen dukun jatu nashimakubainyamaki. Jakia eanan, jabiaskadi wakin samama duakabi Diosun Yushin Pepawen en matu nashimaxanaii, matu unanti wamakinan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","januxun jatube ichabu betsan Jesús yukakin: —Xanen Ibuun, ¿na jabiatianan, nawabu nichintan nukunabu Israelbu ana jatu pewakin kushipa wai min jatun xanen ibui taei kai?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesúsun jatu kemakin: —Jatianda ibubis jawen kushipawen Epa Diosun jaska waxanaidan, matunamaki, man unantidubumadan. Jatun besti unainkiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jaska man jawen unantidudan, jawen Yushin Pepa matu anu juaya jawen kushipa bitan Jerusalén anuxun inun Judea mai pakea inun Samaria mai pakea ja dabe jidabi anuxun inun chaijaida mai kesua anu jiwebaunabu anu bukubaunkin ekidi man jatuki chanikunkainyuxanaii— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ninkakin uiainbun Jesús jaskabiama nai anu Diosun ainikin duntanbainai nai kuin bekin bepukin juneaya ana uianbumaken ");
INSERT INTO cbsNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús jaska kainkin jatu jenebainai uin naiudi teskanxun uinkin jenediabumaken juni dabe sanpu juxupa sawea damia jatu bebun nitushitan ");
INSERT INTO cbsNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","jatu yuikin: —Galilea anuabuun, ¿jaskakin man naiudi uiain? Na jabias Jesús matu anua nai anu Diosun ainiaidan, jaskakainai man dama uinxu keskadiai ana jabiaskadiakidanxanikiki, jaudiadidan— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","janua Olivos Mati anua Jesúsun tsuma kushipayabu Jerusalén anu ana chintunbidani kilómetro bestichai jatixun yununi besti anu juindukuntitian katani ");
INSERT INTO cbsNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","jaskabidani ja mae anu jikitan janu ikabu jiwe keyatapa dintu medan mapekenibukiaki, Pedrodan, Juanan, Santiagodan, Andrésdan, Felipedan, Tomásdan, Bartolomédan, Mateodan, Alfeon bake Santiagodan, Simón Celote jatun nawabu nichinkatsis imisdan, Santiagon bake Judasdan. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jabu jaskabidanima ja dintu anu ichai Jesúsun betsabu inun, jawen ewa María inun, ainbuaibu jabun ikunwainbu jatube ichaxun xaba tibi jau Diosun jatu medabewanun yukakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ja xaba tibi jaskakubainkin xaba betsatian 120 ikunwainbu jatube icha maniabu Pedron jatu yuinun ika benitan jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—En betsabu inun en puibuun, jaska bebunkidi Judaskidi Diosun Yushin Pepatun David yuia kenenidan, jabias Judasin akin meneimaki. Jaska wanikidi akin chanima jatun jatu iyuxun Jesús jatu achimaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jamen Judasdan, ja dukun Jesúsun nukube katuxun nukube daya inandiayamaki— ikimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jaska Judasin chakabu shinankin jawen Xanen Ibu jatu achimashina ja pei pakabu jawen chakabuwen taexun bishianwen taexun juni betsan bai tude bitan janua Judas ibubis ikidan, manaundia maikidi besukidan tin iki pupexekei puku jadas iki keyutan mawanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalén anu jiweabun ninkatan ja bai kenakin: “Hacéldamaki”, akin kenakinan, jatun janchawen yuiadan: “Jimi baiki”, anibu kenamisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chanima Salmos una medan Judaskidi Davidin bebunkidi yuikin: ‘Jawen mae jenebainaya ana tsua janu jiweama ixanikiki’, ani inun: ‘Jawen daya jenebaina juni betsan jau ibu waxanunwen’, aniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","—Jaska Davidin kenenikidi shinanankanwen. Nukubetan Jesús chibanmisbun na junibu nun jatube paxkaisma Xanen Ibu Jesús nun chibaintian nukube ikubidanshinabu nun jayaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juanen Jesús nashimai uintan ikunwanbidanibu inun nai anu Jesús inai jabun uinshinabu jau jabu betsa nukuki dasitan jadi jau jaska Jesús mawa bestenkainima jau nukube jakidi chanikunkainxanun betsa katunankanwen— Pedron jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","januxun juni dabe José Barsabás jawen kena betsa Justo inun Matías katutan ");
INSERT INTO cbsNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","jabun eska Dios jatu yukaxunkin: —Xanen Ibu Diosuun, dasibibun shinan min unainwen taexun na juni dabe pepa jadatuda min katuai nuku uinmawen, ");
INSERT INTO cbsNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","jau Judasin jawen chakabuwen taexun jawen kushipa daya benutan janu nuitapai kaken jau jawen daya kushipa betsan binunan— atan ");
INSERT INTO cbsNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","unankatsis ikin jawen unantiwen katukatsi unanti watan putabu Matías unanti wabu kaianyan ja katuabu Jesúsun 11 tsuma kushipayabuki Matías dasitan jatube ikunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Janua ana betsatian judiobu Pentecostés nawai besiaibun Jesús ikunwainbu dasibi janus ichabun ");
INSERT INTO cbsNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","jawaida nai anua jawen bana niwe kushipa bei danka imis keska xunku ibidani janu maniabu anu kedun kedun ikin ");
INSERT INTO cbsNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","jaskakin Jesús ikunwainbu tibi chi jede keska xawa akeakei jatu mamaki madatamea ji ibauni jatuki jikia akeakeaya ");
INSERT INTO cbsNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","jaskakin dasibi jatu achimakin keyuaya jaska janchatidubumabiaken nawa betsa betsapabun jancha tibiwen Diosun Yushin Pepatun yuimakin jatu janchamakin taewaya ");
INSERT INTO cbsNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","mai pakea betsa betsapa anua judiobu Jerusalén anu jiwei benibu jiweabun jabu pepakin Diosun jancha chibankin menekin jeneisbuma ");
INSERT INTO cbsNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","jawen bana ninkabidani janu midima ichaxun ikunwainbu anu jancha betsa betsapawen janchabaunaibun jadakidi shinantima jatu wa akeakeabu juni tibitun mai kesua anua jabun janchawen janchaibu ninkai jaskawen janchaisbuma ninkai ");
INSERT INTO cbsNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","jaskakainmaibu ninkai e iki teku iake iakei janchanamebaunkin yuikin: —Nadan, ¿Galilea anuabumamen, na jaska dasibi janchabaunkanaidan? ");
INSERT INTO cbsNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nukun jancha tibiwen janchabaunaibubin! ¿Nun ninkai? ¿Jaskai ja junibu jaska janchakanimenkain? ");
INSERT INTO cbsNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Na nun nukubudan, Partia anuabu inun, Media anubu inun, Elam anuabu inun, Mesopotamia anuabu inun, Judea anuabu inun, Capadocia anuabu inun, Ponto anuabu inun, mai pakea Asia anuabu inun, ");
INSERT INTO cbsNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia anuabu inun, Panfilia anubu inun, Egipto anuabu inun, Libia mai pakea Cirene dapi anuabu inun, Roma anuabu inun, ");
INSERT INTO cbsNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","betsa judio kainibu inun, betsabun judiobun beya chibanmisbu inun, Creta anuabu inun, Arabia anuabu beimabu nukun jancha tibiwen Diosun kushipawen e imatikidi yuiaibu nun jatu ninkaii— iake iakeaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","jaskaibu jatu ninkatan dasibi jadakidi shinantima e iki keyutan yuka iki: —Na eska chanii janchaibudan, ¿jawamen?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","jakia juni betsabun jawa shinanmadi jatu kaxe wakin ikaibukidi jatu yuikin: —Paean daki janchai ikanikika!— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","janua Jesúsun 11 tsuma kushipaya betsabube Pedron jatun jancha ninkai benia nixun jui kushipawen jatu yuikin: —Judiobu inun dasibi Jerusalén anu jiweabuun, eska en matu yuiai ninka peidawakanwen, jaska man ninkai janchaidan. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na yudabudan, paeanbumaki, jaska man shinankin ikunwain keskamadan. Jaskai e iskaun badi keyadiamabiaken 9:00 badi paentidubumaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jakia natian jaska taxniai ninkakin man uiainan, jaska bebunkidi Dios yubakanixun akikiki. Jawen jancha yuixunika Joel Diosun jatu yuimakin: ");
INSERT INTO cbsNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dios chanii: ‘Ma badi jawen jenei kaya en Yushin Pepa yudabu anu en jatu yunua jatuki dasiken matun juni bakebu inun matun ainbu bakebun ekidi yusiainbun bedunanbu uxa keskaxun dami betsa betsapa uiainbun anibubu uxa ekidi namadiaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jabiatiandi en tsumabu junibu inun ainbu en Yushin en jatu inan ekidi yusinbaunxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jaska inun, nai anua jawen e imai kushipa wakin mai anuadi dami betsa betsapadi en waxanaii. Jimi jabamakinan, chi wakinan, basnun bai kua jawen kuin keska wakin en jatu uinmaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","En bake kushipajaidai chaxakapai xanen ibui jua kemadiamaken xaba betsa betsapaxanikiki. Ja jaskaitian badi ana chaxama meshu wakin inun uxe ana chaxamadi jimi keska ixanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Januxun tsuabunda: En Xanen Ibu Yavé Dios kushipaki, ikin ea yuiaibu jabu besti paxakin jatun jiwea ikibi ika bixankanikiki’, aka Joelin yusintan nuku kenexuniki, iwanan, Pedron ana jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—Israelbuun, en matu yuiai ea ninkakanwen. Matunan, man unanjaidaii. Jesús Nazaret anua jua Diosun kushipa watan jawen e imati inun jawen unanti wamakin dami itimaska tsuan atiduma wamakin jawen kushipa matu uinmakin Diosun ama akeakekin xabakabi matu uinmakubainimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jaska yubakani Diosun ja juniwen abainai shinanma jaska wai bextenun, iwanan, matun jawen bake danankin jaki yubakatan jatu achimatan tenanmanun, iwanan, juni chakabu man jatu mastamaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jakia mawabiaken Jesús Diosun ana bestenwainmaki, mawamamistun isin tenemakin bashitidubia jawen jiwea yabutiduma binumakinan. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jamen xanen ibujaida Davidin Jesús iki kaikidi yuikin: ‘En xanen ibun ea mekekin en yusiudi jawen kushipawen ea medabewai en uinkubainaya jawa tsuan ea maematan binuntidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jaskawen taea juinti shinan chankain benimai nawakin kenwankin jeneama en jiwea dasibiwen ikunwain jawa dateama en ikunkainxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mawabu janu dasibi bumisbu anu ka min medibi min tsumapan yuda maiwati tanpe anu jau dakai chapuyamaxanun min nemaxanaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jaska watan janu jiwekuin kati bai ea unanmatan mia anu jiwemakin min ea benimawakubainxanaii’, akin nuku kenexuniki— iwanan, ana Pedron jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","—En betsabu inun en puibuun, nukun xenipabu kayabi Davidkidi chanima xabakabi matu yuinun ea ninkakanwen. David mawa janu maiwakin jawen yuda jananibu nun uinmiski. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Jabias David Diosun jancha yuixunika jawen yudakidi jamebi janchama jakia jawen baba betsa kaindiamakidi Diosun yubakin xanen ibujaida ixanai unanmakin yuimaniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Diosun jancha yuixunika David bebunkidi Diosun shinanmakin Mesíaskidi janchamakin jatu yuimakin: “Mesías Cristo mawa jawen yuda chapuama inun mawabu anu jawen yuda bashiama ana bestenwanxanikiki”, ika jakidi janchaniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jamen Diosun jaskakidi janchamanidan, ja Jesús mawa bestenwanshina chanima ibubis dasibibun nun uinkubainshina nun unankanaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Januxun ana bestenwantan Dios jau jabe xanen ibunun, iwanan, jawen yusiudi tsauntan jaska yubakani jawen Yushin Pepa jawen Epan Jesús inan jatun nuku inan akeakekin nuku kushipa waikiki, na jabia ninkakin man uiainan. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jaska inun, Davidkidima tsuada nai anu kaxanaikidi jabias Davidin jamebi yuikin: ‘Diosun en xanen ibu yuikin: En yusiudi tsauyuwe. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Janu miki sinataibu en mia yamawaxundiama ebe xanen ibukin manayuwe’, aka jatu yusintan nuku kenexuniki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","—Israelbu dasibibuun, chanima matu xabakabi shinanmanun ea ninkakanwen. Ja jabias Jesús cruz anu man jatu mastamaimadan, Diosun bestenwantan nukun Xanen Ibu kayabi nuku waxuinmaki, jawen Mesías Cristodan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","janu jatube ichabun ninkai ¿jaskatimen? ika jatun juinti nishmajaidai bika tenekin shinankin Pedro inun Jesúsun tsuma kushipaya betsabu jatu yukakin: —Betsabuun, ¿jaskatan nun jaskatidumen?— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedron jatu kemakin: —Dios man chibankatsis ikaidan, matun chakabu jenetan matun shinan betsa watan Dios anu bedikanwen. Jaska watan man Jesucristo ikunwainwen taexun jawen kenawen matu tibi nun matu nashimaya matun chakabu buatan jawen Yushin Pepa Diosun matu inan man bixanaidan. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nukuna bestimaki. Jaska Dios yubakani ma akikiki. Matu dasibibu inun matun bakebu inun chaijaida manibaunabu nukun Xanen Ibu Dios jaska matukidi yubakaidan, dasibi matukidi iniki. Jaskawen taexun jatida jawenabu wakin katukin kenakatsis ikikiki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ana jancha ichapawen Jesús mekenankidi xabakabi yusin pewatan Pedron jatu yusinkin yuikin: —Ja yudabu jiwe chakabu anua paxadikanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","januxun ja xabatian jawen jancha ninkakin ikunwankin shinan betsa waibu 3,000 yudabu nashimabu jati ana jatubetan ikunwain jatuki dasinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Januxun Jesúsun kushipayabun jatu yusiainbu jabun jatun yusian tapinkin chintuanma jawada jatun jamapai paxkai medabenain inun, ichaxun jatubetan Jesús jatu mawaxunima shinankin misi pikin inun, jabubetan Dios kushipa yukakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jabiatiandi Jesúsun tsuma kushipayabun Diosun jatuwen dami atimaska ichapa akin jawen unanmati betsa betsapa akaibun dasibi Jerusalén anu jiweabu e iki jabaa ikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ikunwainbu dasibi paxkama medabenain jatun jamapai yaushiama inananankin ");
INSERT INTO cbsNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","betsabu mabuyabu inun baiyabun jawen pei bikatsi juni betsabu inantan jawen pei bitan ikunwainbu nuitapaibu jawa jayama pei jatu paxkaxunkin medabewakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Janua xaba tibi Templo jemaintin anuxun kushipa yukakin jiwe anuxundi ichaxun jawa chintuanma shinan chankanbetanan jatubetan pikin Jesús jatu mawaxunima shinanmati misi pikin ");
INSERT INTO cbsNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dios kenwainbun dasibibun jatukidi pe shinankubainaibun xaba tibi betsabun Jesús ikunwain yuda kaian ichai jatuki dasiaibu Diosun jawenabu jatu wakin kenakubainikiaki, jabu jiwei mekekatsi ikaibudan. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Janua xaba betsatian ma 3:00 badiken judiobun Dios yukamisbutian Pedro inun Juan Templo anu buaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","jabianudi juni betsa chantu kainitun jau jatu pei ea anun, iwanan, xaba tibi Templo jemaintin mishki kene jikiti xui jawen kena Hermosa, nukun janchawen yuia Jawendua anu jawenabun iyuxun tsauntantanmisbu ");
INSERT INTO cbsNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro inun Juan jikinun ika buaibun juni chantun jatu uinkin yukakin: —Ewen nuikin ea pei inankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","jabun uinkin dais keyutan Pedron yuikin: —Nedi nuku uinwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","“Ea pei inankanikiki”, ixun bedi ikama jatu uianyan ");
INSERT INTO cbsNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","januxun Pedron ana yuikin: —En peiumaki. Jakia en ja jayadan, en mia inaiin. Diosun kushipa en jayawen taexun en mia xuxawatiduki. Jesucristo Nazaret anuatun kena kushipawen taea benitan nidiwe— atan ");
INSERT INTO cbsNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedron jawen meken yusiudiawen metsunxun benia jawen tae inun jawen jupuxku jawaida mestein jukushitan ");
INSERT INTO cbsNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","janua ja juni chantuni beni ishchui ti itan ni taekaini Pedro inun Juanbe Templo jemaintin anu jikikaini ishchui ti ti ikainkin Dios kenwankin taewabainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","dasibibun uiainbun nikainkin Dios kenwanbainai ");
INSERT INTO cbsNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","jabun uin e iki datekin ¿jaskai jaskaxumen? ikin: —Ja junin jatun Templo jemaintin jikiti xui jawen kena Jawendua anu tsauxun pei jatu ea amis ma xuxa unain jabia ikikiki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ja juni chantu kaini ma xuxawabu Pedro inun Juan jatu dapaxkama jatube niken dasibi yudabu kushibidan uin e ibidan ibidani Templo jemaintin kexa janu badi utati jawen kena Salomón anu jatuki dasi ichabidanbidanaibu ");
INSERT INTO cbsNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","jaskaibun Pedron jatu uinkin yuikin: —Israelbuun, ¿jaskai nuku uin man e ikanai? ¿Na juni nun xuxawaxu benitan nia uinkin nukun kushipawen nun axu man shinainmenkain? ¿Dios keskakin nun juni pepajaidawen taexun nun xuxawaxu man daka shinain? ");
INSERT INTO cbsNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nun jaskamaki. Matu yuinun ninkakanwen. Jabias nukun xenipabu Abraham inun, Isaac inun, Jacobun Dios kenwanpaunibun na juni ma xuxawaxuki. Ja inun, jawen bake bechipaijaidakin Diosun nukuwen taexun kenjaidawabiamisken danankin matubu jaki sinatakin achixun nawa xanen ibujaida anu man iyua januxun Pilaton shinan pewatan tenankatsi ikama nichinpanan man nemaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Januxun matundi Pilato yukakin Jesús juni pepatun jawa chakabuwaisma jau taxnimanun Pilato yunuama ja juni chakabu besti medabewakin man yuka matu jawa waxuanma nichinxunimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jaska wakin jatun nuku jiwekuinmaxanai man jatu tenanmabia mawa Diosun ana nuku bestenwanxuinma nukubun uinkubainimaxun nun unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jaskawen taexun Jesús ikunwankin jawen kushipawen na juni man uinmis jawen yuda jidabi kushipa wakin nun ma xuxawaxuki, jaska dasibitun man uiainan— iwanan, ana jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Enabuun, Jesús ikunwankatsi ikama jawen kushipa unankin kayati wakin tapindiamabia matun xanen ibububetan ja juni unanma man tenainma chanima en unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ja man jaska waimakididan, bebunkidi Diosun jawen jancha yuixunika dasibibu jakidi chanikin nukunabu yuikin: “Jawen Mesíasdan, nuitapatan mawaxanikiki”, anidan, jaska yuini keska wakin Diosun ma jatu menemaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaska shinanma Dios man chibankatsis ikaidan, matun chakabu jenetan matun shinan betsa watan Dios anu bedikanwen, jau matun chakabu matu buaxununan. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Diosun matu jawen daewakin pepawakin benimawakatsis ikin jawen bake Mesías Cristo bebunkidi katutan matu yubaniki, jau man jaki dasixanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Janua natianan, Jesúsdan, naiudi kayuimaki. Jaudixun Diosun mai anuabu jawen jatu pewamakin keyumakin manakamayuikiki, jaska jawen jancha yuixunika medibibu jiwexun nuku kenexunpaunibu keska wamayukinan. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Janua Moisésdi jakidi nukun xenipabu jatu yuidiakin: “Jawen jancha yuixunika ea keska matu anua matun Yavé Diosun kainmaxanikiki. Jaska matu yunuai ninkatan chibankubainxankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jakia jawenabu bababun tsuabunda Diosun jancha yuixunika Mesías ninkakatsi ikabuma Diosun kupikin jatu yamawaxanikiki, ana jawenabuma wakinan”, aniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Moisés besti jaska jakidi chaniama jakia jawen jancha yuixunika tibi Diosun jatu yuimakin Samuelwen taewakin jaska Diosun jawen bake yunuxanaikidi yusiin jabudi chanikubainibuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jaska inun, matu jenekatsi ikama Diosun jawen jancha yuixunikabu janchamai jabuwen Dios matuki yubakaniki. Jaskawen taexun matun xenipabu Diosun yubai nukun xenipabu Abrahambe Dios janchakin matu jeneama inunbadiaikidi yuikin: “Min baba betsawen taexun min bababu inun dasibi nawa betsa betsapabu xukua tibibu en jatu pepawadiaxanaii”, aniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jaskawen taexun Diosun jawen bake bestenwainmaxun man jawenabu dukun matukidi pe shinankin matu duawakin taewaikiki, matun chakabu jenetan man shinan betsa wanunbunan— jatu wai ");
INSERT INTO cbsNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro inun Juanen yuda ichapabu jatu yusinkin menediabumaken Diosbe jawenabu janchaxunikabu inun, Templo mekemisbu xanen ibu inun, saduceobu bexun ");
INSERT INTO cbsNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro inun Juanen yudabu yusinkin Jesús mawa ana bestenkainima jatu unanmai ninkatan jatuki sinatabain ");
INSERT INTO cbsNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","jatu achixun ma badi kaya bichiti jiwe anu jatu bichitan: “Meshukidi besti jatu yukatiki”, ibainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ja jaskaibutian ichapabun jabun Pedron jancha ninkakin kakapewen taexun Jesús ikunwankin taewaibu jatu tanakin ainbu tanama junibu besti 5,000 tananibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Janua uxashini Jerusalén anu judio xanen ibubu inun, mae xanen ibubu inun, Diosun jancha kenenibu yusinananmisbu Jerusalén anu ichabun ");
INSERT INTO cbsNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","jabianudi judio xanen ibujaida binua Anás inun, Caifás inun, Juan inun, Alejandro inun, Diosbe jawenabu janchaxunika xanen ibubun enabu dasibi jatibu ichaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro inun Juan jau iwenunbun jatu yunua iweabu jatu namakis nichintan yukakin: —¿Tsuan kushipawen inun tsuan kenawen na juni man xuxawashinamen?— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Diosun Yushin Pepatun Pedro kushipa wa jatu kemakin: —En xanen ibubuun, ");
INSERT INTO cbsNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","juni nuitapai isin teneai pewakin nun xuxawashinakidi tapinkatsi ikin man nuku yukai ikaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jaskakenan, matu inun dasibi Israelbun man ninkaya matu shinanmanun ninkakanwen. Jabias Jesucristo Nazaret anua jaki sinatakin jiki man jatu mastama mawa Diosun ana bestenwainma ikunwankin jawen kushipa bestiwen na juni dasibibun man uiain nun xuxawashinaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús Diosun jaska keska waimakidi matu xabakabi wanun ea ninkakanwen. Man jiwe wanikabun mishki dananbiaibun jabias mishki keska Diosun bixun dexun makedex wakin kene jawen mestenwankin akawaimaki, ja jabias Jesúsdan. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ja inun, jawa tsua betsawen nun meketi jayamakiaki. Mai jidabi anuxun jawa juni betsawen Diosun jawen nuku mekekin paxawati jayamadikiaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","janua Pedro inun Juan jawa dateama kushipai xanen ibubun uianbun bedubi Jesúskidi xabakabi jatu yusiainbu xanen ibubun ninkatan ja junibu unanepabuma inun escuela anuxun jawa tapinsbumabia pewen jatu jancha waibuwen taea unain e itan jakia Jesús jatube nixun jatu yusinkubainima shinantan ");
INSERT INTO cbsNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ja juni xuxawashinabu jatube niawen taea jaska waxun jatu jaska watima naxukukin ");
INSERT INTO cbsNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","januxun janu ichabu anua jatun mekenikabu jatu nichinmatan jabu besti yubakai yuinamea akeakekin ");
INSERT INTO cbsNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","yuikin: —Na Jerusalén anu jiweabun dami atimaska wakin xuxawashinabu dasibibun unankanikiki. ¿Nun jatu jaska wai, na juni dabedan? “Jabun akamaki”, ikin nun jatu padanmatidumaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jakia na jaska Jesúskidi chanikubainaibudan, dasibibu jau ana jatu ninkamakin ikunwanmayamanunbun jatu bextekin nesewanankanwen, jau unudi ana Jesúskidi tsua yusintaskayamaxanunbunan— itan ");
INSERT INTO cbsNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","januxun ana jatu kenaxun jatu yunukin: —Jesúskidi ana janchakin jawen kenawen jatu yusinyamaxankanwen— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro inun Juanen jatu ninkasama jatu kemakin: —Dasibi nun amis Diosun unainwen taea ¿jadatu chibain pemen? ¿Matun jancha ninkaimenkain? ¿Diosun jancha ninkaidaka? Jaskaken matumebi unanti wakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Eskawen taea nun ikai matu yuinun ninkakanwen. Jawada uinkin nun ninkakubidanima jakimama jatu yusinkin nun jenetidumaki— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","jaska xuxawashinabuwen taexun yudan kaianen Dios kenwainbu xanen ibubun uinkin jabuwen datekin jawa chakabuwama ishianbu jaska waxun jatu kupitima jancha kushipa bestiwen ana jatu nematan nichinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ja juni chantu kaini ma 40 badi binubiaken kaya wakin damiwakin akawanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Janua Pedro inun Juan jatu jawa wama jatu kainmabu kainbain jatun jaibuaibuki nukutushitan jatube ichatan dasibi Diosbe jawenabu janchaxunika xanen ibubu inun mae xanen ibubun jatu jaska wakanxu jatuki chaniaibu ");
INSERT INTO cbsNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","jaska jatu wakanxukidi ninkatan dasibibun Dios kenwankin yukakin: —Nukun Epa Diosuun, nai inun, mai inun ianenwan, inun dasibi janu jiweabu min damiwani nun unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jaska inun, min Yushin Pepawen min tsuma nukun xenipabu xanen ibujaida David yuimakin: ‘¿Jaskai jamenmens jawa shinanma ja yudabu yubaka besumai jaskai jamen ja iki janchanwankanimenkain, jawa shinanmadan? ");
INSERT INTO cbsNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mai kesua anua inun mae tibi anua xanen ibubu kushipabu icha yubakai Xanen Ibu Dios inun jawen Katua Mesías danain jaki sinataxankanikiki’, iki janchanidan, ");
INSERT INTO cbsNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Chanima na jabiatian xanen ibu Herodes Antipas inun Poncio Pilato na mae anu nawa betsabube inun Israelbube icha min tsuma Jesús medibi min katuni Mesías min yununi min kenwanmis jaki sinatakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jaska dasibi bebunkidi min jakidi yubakani jau jaska wai bununbun min yuinidan, chanima jaska keskadan, jabunan, ma akimabuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nukun Xanen Ibuun, natianan, jabun nuku mese mesewaibu min uiaiin. Jaskawen taexun nun min tsumabu jawa datea min baken kakape nun xabakabi chanikunkaunun nuku yunuwe. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Min kushipa paewen isin teneaibu xuxawakin dami atimaska tsuan atiduma min tsuma medibi Jesús min waniwen jawen kushipawen nuku amakin nuku jatu uinmakubainwen— akin ");
INSERT INTO cbsNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Diosbe janchai meneaibun jabiatiandi janu ichabu anu pacha sakuaya Diosun Yushin Pepatun jatu dasibi achikin kushipa wakin keyua januxun ana dateama Diosun kakape jawenabu jatu yuikubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jabun Jesús ikunwainbu midimabun jatun shinan jabiaskas shinanwen shinain jabun mabu tibi yui: “Ena bestiki”, ikama jakia dasibibun mekubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Januxun Jesúsun kushipayabun jaska Xanen Ibu Jesús bestenkainima jawen kushipa unankin jatuki chanikubainaibu ikunwainbu dasibi Diosun jatu duajaidawakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","jabu baiyabu inun jiweyabun jabu jawa nuitapabuman juni betsa inantan jawen taexun pei bitan ja pei ");
INSERT INTO cbsNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","jau jatu inanunbun Jesúsun kushipayabu jatu inankubainaibu ja betsabu jawa jayama jau jawen binunbun bestibu tibi jatu paxkaxunkubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jaskanibu betsakidi mia yuinun ninkawe. Janua Levín baba betsa natukan Chipre anua kaini jawen kena Josén jatubetan ikunwanyan Jesúsun kushipayabun kena betsa wakin Bernabé wanibukiaki, nukun janchawen kenadan: “Shinan chankanwanika bakeki”, akinan. ");
INSERT INTO cbsNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ja junin jawen bai jaya juni betsa inantan jawen taexun pei bitan bexun Jesúsun kushipayabu jatu inanikiaki, jawen jau ikunwainbu betsabu jatu medabewanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ja jaskaibutian juni betsa jawen kena Ananías inun jawen ain Safiran jatun bai juni betsa inantan jawen taexun pei bitan ");
INSERT INTO cbsNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","jawen ainbe yubakatan paxkaxun dabukun jawena wakin adutan jatidi Jesúsun kushipayabu anu buxun inanyan ");
INSERT INTO cbsNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","januxun Pedron yuikin: —Ananíasiin, min bai inantan pei bitan paxkaxun dabukun adutan ¿jaskakin Satanásan mia chakabuwamaya nuku yui Diosun Yushin Pepaki min chani chakai? ");
INSERT INTO cbsNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Min bai min jatu inandiama minayuxuki. Ja inun, pei mia inanbu minadiayuxuki. Jakia min pei min paxkaxun nuku inankin min nuku padainan, min nuku akamaki. Min Dios padanun ika ikaii. ¿Jawai eiskidan min jaskatushiai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías jaska yuiai ninkatan tin itan mawaya jaskai ninkatan dasibibu dateaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","janua bedunan dabe juxun jawen yuda yabutan buxun maiwai buabun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","jakimamadi 3 hora binuaya Ananíasin ainin jaskaxu ninkadiama jatun jiwe anu jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedron yukakin: —Matun bai inantan ¿jati pei besti man bixu min benen ea inanxumen?— aka Safiran kemakin: —Jeen, jabiati besti jawen kaduki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedron yuikin: —¿Jaskai Diosun Yushin Pepa padankatsis iki man yubakadabekanxumen? Min bene padananainwen taea ma mawa maiwatani bekanikiki. Min miadi mawaya mia maiwadiai bukanikiki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","jabiatiandi jawaida jadi mawai Pedron tae naman di ikaya janua ja jawen bene maiwatani bedunan dabe jikitan jawen ain ma mawadia bechitan jawen yuda jadi buxun jawen bene dapi maiwadianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Janua ikunwainbu ichapabu inun dasibibun jaskaxu kakaibu ninkatan date paepanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Diosun jawen kushipa jatu yunua Jesúsun kushipayabun yudan kaian medabewakin dami atimaska jaikaimas betsa betsapa akaibun jatu bana ninkatan jatube ichai bebidan bebidanaibun janu Templo jemaintin anu janu badi kuaya utamisbu jawen kena Salomón anu ikunwainbu betsabu jatuki dasi ichakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Janua jatiditun jatun yusian ninkai ichakatsi ikabumabia jakia dasibibun ikunwainbukidi pe shinan bestikubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jaskabiaibun ana midimabun jatubetan jatun Xanen Ibu ikunwain juni ichapa inun ainbu ichapa jatuki dasikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","janua betsadan, tsuabunda jatunabu isin teneaibu jawen dakatiki iwexun bai kexa janu Pedro juai anu shinankin jau ja kauankin jawen yuda baka utawen jau xuxawaxunun isin teneaibu janakubainabu Pedro janu kakin ja isin teneaibu bestibu jatu xuxawakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","janua ja dikabi janu Jerusalén dapi jiwebaunabun jatun yudabu isin teneaibu inun yushin chakabun betsa betsapawen jatu nuitapawamis jabu Jesúsun kushipayabu anu jatu iwediabidanbidanaibu dasibibun ea akaibu jabudi jatu xuxawakin keyudianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ja jatu jaska waibutian Diosbe jawenabu janchaxunika xanen ibujaida inun saduceo jabun chibanmisbu jabianuxundi Jesúsun kushipayabu jatu uin jatun kushipawen kemubiai jatuki sinatakin ");
INSERT INTO cbsNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Templo mekenikabu jatu yunua achitan jatun mae meketi jiwe medan jatu bichiabun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","januxun meshu medan Diosun nai tsuma juxun jabun mekeabu jatu unanmamatan bichiti jiwe beputi bepentan jatu kainmatan yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Nenua en matu kainma buxunan, ja Templo jemaintin anu jikitan januxun Diosun kakape jiwekuinmati jancha dasibi jatu yusinditankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","jaska jatu yuia ninkabain penaya Templo jemaintin anu buxun jatu yusinkin taewaibun jabiatiandi ma kainbainabu unanmabia Diosbe jawenabu janchaxunika xanen ibujaida jawenabube ichatan Israelbu xanen ibu betsa betsapabu Junta Suprema dasibi jatu ichawaxun jatun meketi jiwe anua Jesúsun kushipayabu jatu bichishinabu jau itanunbun jatun mekenikabu yunuabu ");
INSERT INTO cbsNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","buxun meketi jiwe anu jikixun ma kainbainabu jawa jatuki nukuama benatan chintunbain ja kaka jatu ");
INSERT INTO cbsNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","yuikin: —Janu meketi jiwe anu nun jikia beputi tibi bepui pea policiabun pe mekeabu uintan jatu iwenun, ixun jawen jikiti beputi bepentan ana tsua ja medan jayama nun uintanaii— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","jatu jaska yuiabu ninkatan Templo mekenikabu xanen ibu inun Diosbe jawenabu janchaxunika xanen ibubu yuka iki: “¿Jaskashinabumen?” iki jawa shinantima yuinameaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ja jaskaibutian jaskadapananbun juni betsan jatu uinbidan jikixun jatu yuikin: —Ja junibu man jatu bichishinadan, un unu Templo jemaintin anuxun ma jatu yusinkanikiki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","janua mekenika xanen ibu jawen tsumabube buxun ana jatu itanun ika kaxun yudan kaianki datei: “Nuku mankanwen tsaka tsaka akana”, ika jawa jatu meama ");
INSERT INTO cbsNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Junta Suprema anu jatu iwexun jatu bebun nichintushiabu Diosbe jawenabu janchaxunika xanen ibujaidatun jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ja juni akimabukidi man jatu yusiainbu nun matu nemajaidabiashina nukun jancha jawa ninkama ¿jaskakin Jerusalén anuabu jatu ichawakin man ja junikidi yusinkin jeneamamen? Jaska wakin ja juni nukukidi yuikin: “Man jatu tenanmaimaki”, akin man nuku jawen taexun yuankin man nuku jatu dake wamakubainaii— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","jaskaibun Pedro inun Jesúsun kushipaya betsabun jatu kemakin: —Jaska Diosun shinain nun chibanun nuku yunumis nun akatsis ikaii. Junibun yunuawen taea nun bexteketidubumaki— iki ");
INSERT INTO cbsNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ana jancha chichibainkin yuikin: —Jesús cruzki man jatu mastamaxun jatu tenanmabia ja jabias Dios nukun xenipabun kenwanpaunibu jabiatundi tenanbu nuku bestenwanxuinmaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Diosun jaska watan nai anu ainitan jawen yusiudi nuku tsaunxunimaken ja nukun mekenan inun nukun yusinan nun ma jayaki. Jaskawen taea nun Israelbu xukua tibi tsuabunda nukun chakabu jenetan Dios anu chintuin nun shinan betsaibu nuku jawenabu wakin Diosun nukun chakabu buatan ana shinanmaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na jaskadan, Diosun jaska waima nukun besti nun unaiin. Ja dikabi Diosun Yushin Pepatun unandiaikiki, jaska jabun nun chibainbu Diosun nuku inainmadan— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","jatu jaska waibu ninkatan jatu bechipaiama jatuki sinatajaidakin jatu detekatsis ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","janua jabianudi Diosun jancha kenenibu yusinananmis juni betsa fariseo dasibibun ninkakin jakidi pe shinanmisbu jawen kena Gamaliel jatube xanen ibubu janu ichabu anudi jatube tsaua benikaun policiabun jau Jesúsun kushipayabu jatu kainmayununbun jatu yunua iyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","januxun Gamalielin jabube xanen ibubu jatu yuikin: —Israelbuun, na junibu kupikatsis ikin man jaska waidan, shinankin uindakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Eskaki, matu yuinun ninkakanwen. Juni betsa Teudas xanen ibunun, ixun jatu binunun ikin nukunabu padanyan 400 junibun jawen jancha ninkakin chibain jaki xukuabu soldadobun achixun ja juni deteabun jabun chibainbu datei dasibi paxai sa iki keyunibukiaki, janu bextekei keyuidan. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Janua chipu César Auguston jawenabu jau jatu tananunbun yunua tanaibutian juni betsa Galilea anua Judas xanen ibudianun, ika Romanobu nemanun ika mentsisipakaunkin jatu yusianyan ichapabun jawen jancha ninkakin chibainbun ja Judasdi soldadobun achixun tenandiaibun dasibi jabun chibainbu paxai sa iki keyudianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaskawen taexun matu shinanmakin yuinun ninkakanwen. Ja junibudan, jatu meyamayukanwen. Jabun jatun yusian ibubis ikaibudan, jamen jawama binuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jakia Diosun jatu yunua ikaibudan, man jawa jatu nematidumaki. Chanima jabun Diosun jancha kayabi yusiainbu jatu nemakin man binutidumaki. Dios nemanun ika man jaskatidumaki. Jaskaken shinankin uindakanwen— jatu wa jawen yusian chibankin pe ninkatan: ");
INSERT INTO cbsNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","—Peki— iakeaketan Jesúsun kushipayabu jatu ana kenaxun ichakawakin ji sidiwen jatu kusha kusha ama bestitan ana jau Jesúskidi jatu yusinyamaxanunbun ja akin jatu nemajaida bestitan jatu nichinkin jeneabu ");
INSERT INTO cbsNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","xanen ibubun besuudia Jesúsun kushipayabu kainbaini yuinamei: “Jawen bake Jesucriston kakapekidi nun yusianyan Diosun jawen nuku unanti watan nuku duawakatsi jatu yunua jabuwen datei nun bextekenun nuku akanikiki”, iki benimabaini bushinxun ");
INSERT INTO cbsNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","jatu yusinkin jawa jeneama Templo jemaintin anuxun inun jiwe betsa betsapa anuxun xaba betsa tukuma Mesías Jesucristokidi kaka pepakidi jatu tapinmakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ja badi jaskaibutiandi midimabun ana ikunwain jatuki dasii ichakubainaibun jabianudi judiobubia jatun jancha griego janchawen besti janchamisbun ja jatubetandi ikunwain judiobuns jancha hebreowen besti jabu janchamisbu jatube ja ikin yuikin: —Dasibibun nun Jesús matubetan ikunwanbiaibun xaba tibi nuku pimakin nukun ainbu beneuma enaumabu piti nexexunkinan, man jatu paxka pewaxunabumaki. Matunabu hebreobu besti piti ichapa jatu nexexun inankin nukunabu griego janchawen nun janchamis ja nukun ainbu beneumabu piti eskadabes nexexun jatu inankin man jatu nuitapawakubainaii. Jaskadan, chakabuki— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","jaskaibu jatu yuiabu ninkatan ja 12 Jesúsun kushipayabun dasibi ikunwainbu jatu ichawaxun jatu yuikin: —Nukun nun matu piti paxkaxunkin mekexuna bestidan, nukunadan, pemaki. Ja dikabi matu jaska besti wakin Diosun jancha yusinkin nun jenea pemadiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaskakenan, en betsabu inun en puibuun, jau juni betsabun piti matu paxkaxunkin inankin pewakubainunbun 7 juni shinanyan inun unanepabu Diosun Yushin Pepatun kushipayabu jau jabun matu paxka pewaxununbun benakin katuxun ja daya jatu yunukanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jakia nukubunan, Diosbe janchakin jeneama januxun jawen jancha pepa matu inun betsabu yusinkin nun jenetidumaki— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","jaska jatu yuiabu ninkatan dasibitun jabias shinanwantan januxun jatu katukin juni shinanyan inun unanepabu Diosun Yushin Pepatun kushipayabu katukin jati anibukiaki. Esteban inun, Felipe inun, Prócoro inun, Nicanor inun, Timón inun, Pármenas inun, nawa betsa Antioquía maewan anu jiwexun judiobun beya tapini Nicolás jati jatu katubain ");
INSERT INTO cbsNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jesúsun kushipayabu anu jatu iyuabu januxun jatu unanti wakin mamepixun Dios jatu yukaxunkin jatun medabewanikabu jatu wanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Januxun Diosun jancha Jesúskidi kakape jatu yusinpakekubainaibun jatun jancha ninkakin Jerusalén anuxun ikunwain ichai pakubainaibun ja jaskaibun jabiatiandi Diosbe jawenabu janchaxunika ichapabundi Jesús ikunwandianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Diosun duawakin kushipa paeya wakin pepawanikidi mia yuinun ninkawe. Jawenabun bedubi Estebanen dami tsuan atiduma atimaska wakin jatu uinmakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","janua ichati jiwe jawen kena “Esclavo Tsumawanibu Ana Tsumauma” janu betsabu ichamisbu inun, juni betsadi mae Cirene anuabu inun, maewan Alejandría anuabu inun, Cilicia mai pakea anuabu inun, mai pakea Asia anuabu jabu Estebanbe ja iki yuinameaya ");
INSERT INTO cbsNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Diosun Yushin Pepatun Esteban unanepa wakubainaiwen taexun tsuan Esteban maemakin janchawen binuntidubumaken ");
INSERT INTO cbsNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","jawawen jaska watima jaki yubakatan jabu betsan juni betsabu pakakin yuikin: —Nukun xanen ibubu padankin eska jatu yuitankanwen: “Ja Jesúskidi yusinmis Estebanen jancha chakabu yuikin Moisés inun Dios dayuikin yuainkiki”, atankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","jatu jaska wabu buxun juni ichapabu yuikin mae xanen ibubu inun Diosun jancha kenenibu yusinananmisbuki chani chakakin jabu jatu sinatamabun yudan kaian ja iki bedukui itimaskabainkin januxun Esteban achitanxun xanen ibubu dasibi Junta Suprema anu iyuxun ");
INSERT INTO cbsNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","januxun jau Estebankidi chani chakatanunbun padan jancha katutan juni betsabu jatu padanmakin yuimakin: —Na juninan, nukun Templokidi inun Moisin nuku yusini janchakidi yuain janchai jeneama nun ninkaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Jesús Nazaret anuatun Templo yamawatan nukun beya betsa betsapa Moisin nuku yusini betsa waxanikiki”, ikai nun ninkadiakubainaii— jatu wabu ");
INSERT INTO cbsNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","janua xanen ibubuns Junta Suprema anu tsauxun Esteban nia uinkin jawan ikama jawen besu xabakabijaida Diosun nai tsuman besu keska beisnibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jaska uintan januxun Diosbe jawenabu janchaxunika xanen ibu binuatun Esteban yukakin: —Na jaska mikidi yuiaibudan, ¿chanimamen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ninkaibun Estebanen jatun yukai kemakin: —En xanen ibubu inun enabuun, matu yuinun ninkakanwen. Mesopotamia mai pakea anu nukun xenipabu Abraham Harán maewan anu kadiama bebunkidi nukun Epa Dios kushipa pepatun yubakin unanmakin janu jiwexanai anu ");
INSERT INTO cbsNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","yunukin yuikin: “Min mai inun minabu jenebaini mai bena en mia uinmaxanai anu jadi kaxanwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","janua Abraham kainkainkin Caldea jenebaini Harán anu kainma dakayuken janua jawen epa ma mawaimaken januxun na jabia mai man janu jiwea anu Diosun Abraham iwexun ");
INSERT INTO cbsNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","janu jawen mae ibubis bitan janu jiwepaketidumabiaken Abraham bebunkidi yubakin bakeyadiamabiaken jau janu jawen bababu janu jiwexanunbun jatu inanti jatuki tanamanikiaki, Abraham mawaken jawen bababu patan ibu wakin jau bixanunbun yubakinan. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","7","Januxun ana yubakin: “Mai kesua betsa anu min bababu jatube jiwei buimabu jadixun nawabun jabun esclavo dayadu jatu waxun 400 año jatu dayamakin jatu ichakawakubainaibu atimas en jatu kupiaya min bababu jadia kainbidani bexun na mai en mia yubai anu jiwexun ea kenwankubainxankanikiki”, ayamaxun januxun Abraham jawen yubaka shinanmati wakin Diosun yunukin: “Dasibi minabun juni bake tibi kaian jawen jina kubichi mextekin bikubainxanwen”, aka ");
INSERT INTO cbsNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","jabe janchakin ninkayamaxun jawen juni bake Isaac kaian 8 día xabatian jawen jina kubichi binikiaki, jaska yubani taewakinan. Janua jawen bake Isaac bakeyatandi jawen bake Jacob bidianikiaki. Janua Jacob, jawen kena betsa Israel, jawen 12 juni bakebu kaian jabiaskadi wakin jatu bidiakubainikiaki. Ja 12 juni bakebu jabu tibi anua nun jabia jawen bababuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Janua ja nukun xenipabu Israelin juni bake betsa José jawen betsabun danain jaki sinatakin jau tsuma wabain Egipto mai pakea anu iyutanunbun jawen taexun pei bikin nawa betsabu inanbu iyuyamabu jadixun Diosun duawakin José medabewaya ");
INSERT INTO cbsNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","jabu anuxun bika tenebiaya Diosun nemakin unanepa wakin Egipto xanen ibujaida Faraón bechipaimaya jawen xanen ibu betsa wamakin José xanen ibu wakin jawen mai jidabi inun jawen jiwe jawendua ewapa mekei jau dasibi xanen ibuxunun yununiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Janua Egipto anua José xanen ibuaya Egipto mai pakea anu inun Canaán mai pakea anu dasibi ana yunu beneamaken Israelin bakebu nukun xenipabu nuitapai jawa pitibumaken ");
INSERT INTO cbsNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","janua Egipto anu xekiwan jaya chaniaibu Israelin ninkatan jau jawen bakebun nukun xenipabun jadi buxun jau piti bikin taewatanunbun jatu yunua butanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ana ja kachu betsatian buni chakayamakin ana piti bitanun ika buabun januxun Josén jatu unanmakin jancha wakin yuikin: “En matun betsa Joséki”, akin jatu unanmaya Egipto xanen ibu Faraónen ninkatan: “¿José jawa nawamen?” itan shinanshinken ");
INSERT INTO cbsNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","chipu betsatian José xanen ibuwen taexun jau jawen epa inun dasibi jawenabu jau ixuntanunbun jatu yunua jawenabu 75 ixuntankin Egipto anu iwenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","16","Jaskawen taea Jacob, jawen kena betsa Israel, Egipto anu kaima jiwea janua mawa janu maiwati tanpe Hamorin bakebun jawen juchi Abraham peiwen inanibu Siquem anu jawen yuda buxun maiwanibukiaki. Israelin bakebu inun jawen baba ichapabudi Egipto anuadi mawakubainibukiaki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Estebanen judio xanen ibubu jatu yuikubainkin ana yuikin: —Abrahamnen bababu, Israelbudan, Canaán anu ana jatu chintunmakatsi Diosun yubani ja baditian ma jatu taxnimabainkatsi iki kemaya Israelbu Egipto anu jiwea pai ichai midimakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","janua Egiptonawa xanen ibu bena Faraón ikimaxun jaska wakin Josén Faraónen enabu jatu medabewakubaini unanma ");
INSERT INTO cbsNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ja xanen ibu Faraón benatun nukun xenipabu padankin jatu ichakawakin jatun juni bake dama kaiainbu jau tenanunbun jatu yunukin jatu putamakubainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ja jatu jaska waibutian Moisés kaian jawenduajaida pishtaken bechipaijaidakin jawen ibubun jiwe anuxun june ewa wakin uxe dabe inun besti junexun yumewai ");
INSERT INTO cbsNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ana jaska waxun junetima datekin jau mawanun jene kexa basi anu chichanki jene jikitima wakin buiwen pepuxtan nanetan nuntantan xununbidana Egipto xanen ibun ainbu baken bechixun nexewanimaxun jawen bake keska wakin yumewakin ");
INSERT INTO cbsNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","jaska wabainimaxun Egiptonawa unanepatun Moisés yusinkin unanepawakin tapinmakubainabu janchapai juni kushipakin jaska yunuabu jatu axunkubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ma janu Moisés 40 badiyatun jawenabu Israelbu shinankin uinbaunun ika baii kaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","januxun Egiptonawan Israelbu betsa ichakawakin kushai uinkin jawenabu medabewanun ika kaxun nemakin jatun ichakawai tenanxunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Januxun Moisin shinankin: “En kushipaiwen Diosun ea medabewaya enabu Israelbu jatu medabewakin Egipto anua jatu paxawatan unanuma en jatu jiwemaxanaii”, ibiaya jakidi jaska jawenabun shinanma inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Janua meshukidi betsatian Moisés ana kaxun jawenabu Israelbu dabe ana detenameaibuki nukutan daewakin jatu nemanun ikain jatu yuikin: “Matu dabe man yuda betsamaki. ¿Jaskai man detenamei ikanai?” jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ja jatun jawenabu deteaitun Moisés tu akin xututan yuikin: “Min nuku uinun ¿tsuan mia xanen ibu wakin nukun pewanika mia washinamen, nuku anudan? ");
INSERT INTO cbsNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Egiptonawa deteshinxun min eadi jabiaskadi wanun ika ikai, tenankinan?” aka ");
INSERT INTO cbsNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","jaska wa ninkatan datei chai kai Moisés paxai mae betsa Madián nawabu anu jadi kani jadia nawa keskai jiwexun ainbu bitan juni bake dabe wanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Jadi madianawabu anu 40 año Moisés ma jatube jiwea binukainaya Mati Sinaí janu tsua jiweabumanu Moisés kaxun uianyan ji maxu kui menui keskai jede ji ji ikai anu Diosun nai tsuma nia ");
INSERT INTO cbsNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","uin e itan namai keskakin xabakabi ana uin pewanun ika kemai ja dapi kaya Diosun yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Eadan, en matun xenipabun mekenika Dioski, Abraham inun, Isaac inun, Jacobun mekenika Diosdan”, akai ninkai Moisés datei saki saki ikin jadi uinkatsi ikamaken ");
INSERT INTO cbsNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","januxun Yavé Diosun ana yuikin: “Na min nia anu en nidiaki. Jaskawen taea na mae medibi meseki. Min bichi tae pekayuwe”, aka jutsekexunaya ");
INSERT INTO cbsNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ana yuikin: “Enabu Egipto anuxun bika tene chakayamai sain iki kaxai jawawen jaskatima ikaibu chanima xabakabi en uinmis jatu medabewanun ika en butuxuki. Uinwen. Jaskawen taexun Egipto anu jadi en mia yunukatsis ikaii”, akin Diosun Moisés yuinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Uatian ja jabias Moisés danankin jawenabun yuikin: “Min nuku uinun ¿tsuan mia xanen ibu wakin nukun pewanika mia washinamen, nuku anudan?” abianibu jabias Moisés xanen ibu wakin jatun medabenan wakin jawenabu medabewamakatsi ja nai tsuma ji maxu kui menui keska jede ji ji ikai anua janchamakin Diosun Moisés yununikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Diosun Moisés jaska waimaken Moisin nukun xenipabu Egipto anua jatu kainmabainkatsi ikin egiptonawabu anuxun jatu dami betsa betsapa waxuntan janua jatu iyukin ja Ianenwan Tashipa jau pukebainunbun damiwakin jene bai wakin jatu paxkaxuntan janu tsua jiweabuma anu nukun xenipabu Egipto anua jatu iyuimaxun 40 año dami betsa betsapa jatu unanti wamakeatanikiaki, Moisin jatu taxnimabainixunan. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Januxun jabias Moisin Israelbu jatu yuikin: “Jawen jancha en matu yusinun Diosun ea katuni keska wakin jabia matunabu anuadi Dios yuixunika betsa kushipa ea keska matu anu yunuxanikiki”, anikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaska inun, janu tsua jiweabuma anu ja jabias Moisin nukun xenipabu jatu ichawabainimaxun janua ka Mati Sinaí anua Diosun nai tsumabe janchakin jaska jiwea kayabi nun bixanai Diosun jancha ninkatani nukun xenipabukidi chanikidankidanikiaki, Moisésdan. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Jaska jatu yusinkin unanmabiakubaina nukun xenipabun chibankatsi ikama Egipto anu ana chintunkatsis ikin Moisés danankin ");
INSERT INTO cbsNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","jawen betsa Aarón yuikin: “Egipto anua nuku iwebiaima Moisés Mati Sinaí anu kaima ana juamaki. Jaskaima nun unanmaki. Jaskakenan, yushin betsa dami wakin ja kenwanti nuku axunwen, jau jatun nuku yunukin iyukubainxanunan”, akabu ");
INSERT INTO cbsNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","januxun mane damiwakin ina awa bake itsa jatu waxunshina kenwankin chaxuwan bake detexun kua keyui jatunmebi jatun mekenen ashianwen taea jaki besikin duawai benimajaidanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jaskaibuwen taea Dios Israelbuki sinatakin nai anua bishi besti jau kenwanunbun ja jatuwen nuiai bextenibukiaki. Jaskakubidanibukidi jawen jancha yuixunika Amós Diosun janchamakin yuima: ‘Israelbuun, janu tsua jiweabuma anu 40 año jiwexun ina awa inun chaxuwan bake detexun kua keyubiakin eadan, ea kenwankin man jawa ea inankin ea kenwanma ikubidanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Eunbia jaskatimabiaken yushin betsa jawen kena Moloc man damiwaima kenwankin jawen kenwanti tadi jiwe putakatsi ikama iaxun bekubidankin yushin betsa jawen kena Refán kenwankin jawen bishi kenwanti ibubis damiwaimaxundi jadi man kenwankubainibuki. Jaska wakin man chakabuwakubainibuwen taexun matu kupinun, iwanan, matun mai anua chaijaida matu nichinkin nawabun mai kesua betsa Babilonia anu en matu yunuxanaii’, aka kenexuniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Jakia janu tsua jiweabuma anu nukun xenipabu buaketankinan, Diosun jawen jatu yubakin shinanmati tadi inun bichi jiwe jatu amaima jayanibuki, jaska Moisés Diosun uinmakin yunuima keska jatu amaimadan. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Januxun nukun xenipabun ja tadi inun bichi jiwe mekekubainaibun Josué jatun xanen ibutan nawa betsa betsapabu jatube detenamemaya Diosun jatu medabewakin jatun mae tibi mebinkin jatu nichinmatan jatu ibu wamaya ja tadi inun bichi jiwe Diosun jatu amani pekaxun iatan bekubidanibukiaki. Jaskaibutian ja jiwe bebunxun Dios kenwankubainibukiaki. Jabias jiwe jayayuken David jatun xanen ibu idiakunkainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Janua David xanen ibukin Dios benimawakubainaiwen taexun ana duawanun, iwanan, Jacob jawen kena betsa Israel jawenabun Dioski nukuti kayabi mishki jiwe jawendua waxunxanun, iwanan, Davidin yukabia Diosun nemayunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Jakia Davidin bake Salomón xanen ibudiatan jatun Templo mishki jiwe Dios jatu amaxuniki, ");
INSERT INTO cbsNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","janu junibun jiwe wabu anu ja Dios dasibi binu keyua jiwetidumabiakenan. Jabiaskadi Yavé Diosun jawen jancha yuixunika janchamakin: ");
INSERT INTO cbsNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Nai anudan, en xanen ibui janu tsaua inun en tae janu maiki en tapakea maiki paiaki. Eanan, dasibi en damiwaniwen taexun ea juindukunmanun, iwanan, ¿jaska waxun tsuan ea jawa jiwe waxuntidubumen? Tsuan ea jawa jiwe waxuntidumaki’, aka kenexuniki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Estebanen Junta Suprema ana jatu yuikubainkin: —Dasibi kushipa Dios jaya mesebiaken matun xenipabu ipaunibu keskai matubudan, matun besu inun, matun juinti inun, matun pabinki kushiken Diosun Yushin Pepatun matu yusinbiakubainaya man ninkaisbumaki, nawabun Dios unanbuma keskadan. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jaska inun, Diosun Katua pepa juxanai Diosun jancha yuixunikabun bebunkidi jakidi chanibiakubainaibun jawa ninkakatsi ikama matun xenipabun jatu dasibi danankin jatu ichakawakin detekubainibuki, jatu tenankinan. Janua natian Diosun Katua juni jawa kaneisma jakidi matu yuinibu ma nuku anu juni shinanma nawabu achimatan man ja juni pepa Jesús jatu tenanmadiaimaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diosun jancha jawen nai tsumabun nukun xenipabu yusini jaya tapinbiakin man chibainsbumaki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","jaska shadabu jatukidi xanen ibubu chiteai ninkatan Estebanki sinata chakayamai bene bene iki xeta yenx yenx akaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","jakia Diosun Yushin Pepatun Esteban medabewakin kushipa waya naiudi teskanxun uinkin Dios chaxa kushipajaida anu jawen yusiudi Jesús nia uintan ");
INSERT INTO cbsNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","dateama jatu ana yuikin: —Uinkanwen. Teskantan nai bepemana anua Diosun yusiudi nukun Juchi Kayabi Iyua Jesús nia en uiaiin— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","jabun jawen jancha ana ninkakatsi ikama pabepukui keyubain jakidi kushi biski ibain achitan ");
INSERT INTO cbsNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","59","mae anua taxnimakin xadabain jabu Estebanki chani chakaibun ja dukuntun tsakanun itan jatun tadi chaipa pekatan juni betsa jawen kena Saulo mekematan ichapabubetan mankanwen tsaka tsaka akaibun Estebanen Jesús yuikin: —Xanen ibu Jesúsuun, menan en yushin ea jadi bidiwe!— atan ");
INSERT INTO cbsNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","janua danti ika dakaxun bis ikin jui kushipawen ana yuikin: —Xanen Ibuun, na ea chakabuwaibuwen taexun jatu kupiyamaxanwen— atan di iki mawanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Januxun Esteban jau tenanunbun Saulon jabiaskadi shinanyan anibukiaki. Jabias xabatian Jerusalén anuxun Jesús ikunwainbu jabun ikunwanbuman jatuki sinatakin ichakawa chakayamakin taewaibun Judea mai pakea anu inun Samaria mai pakea anudi Jesús ikunwainbu dasibi paxai sa ibainaibun jabu Jesúsun kushipayabu besti kaianma inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Janua tsuabuda juni duapabu Estebanwen nui jaya kaxabetanan maiwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ja jatu jaska waibutian Saulo jawen jaibuaibubetan Jesús ikunwainbu ichakawakin jatun jiwe tibi anu jikixun juni inun ainbu ichapa paxadiabuma jatu achixun kainmakin jatu xadabainbainkin bichiti jiwe medan jatu bichimakin jabun Jesús ikunwainbu jakimawanun, iwanan, Saulon Jesús ikunwainbu yamawakin keyupai inikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Janua jabu Jerusalén anua paxai kainbainimaxun janida mae tibi anu jikixun Diosun Mesías Cristo mekenan jawen kakapekidi jatu yuikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","medabenan betsa Felipe mae ewapa betsa Samaria anu kaxun Mesías Cristokidi jatuki chanikin taewakin ");
INSERT INTO cbsNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","januxun jaska tsuan atiduma dami atimaska betsa betsapa jatu axuain uinkin ja yudabu ichaxun Felipen jancha dasibibun ninkajaidaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","yushin chakabun yuda betsa betsapabu jatu nuitapawamis Felipen jatu xuxawakin kainma ja yushin chakabu bis iki taxnibainaibun jatu kaya wakin yuda betsabudi babunibu inun biyuxkinibu jatu kaya waya ");
INSERT INTO cbsNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ja mae anuxun Felipen jatu jaska waxunai uin jawen shinan chankain benimajaidanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jamen betsadan, Felipen jatu yusin kadiamaken juni betsa Simón ja mae Samaria anuxun jawen mukawen unankin jawen jatu xuun akin yudabu padain kein xanen ibukin jatu mesewamistun ");
INSERT INTO cbsNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","badi ichapa jawen mukawen jatu padankubainaiwen taexun jakidi yuda dasibi xanen ibubu inun jatube jiweabu dasibibun chibankin kenwain jakidi yuinamekin: —Simónan, Diosun kushipa ichapa jayaki— ikin jawen jancha ninkakin axunpakemisbun ");
INSERT INTO cbsNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","jakia Dios xanen ibuaikidi inun Jesucriston kakapekidi Felipen jatu yuiai ninkatan ana Simón ninkama juni ichapabu inun ainbu ichapabundi Jesús ikunwainbu Felipen jatu nashimaya ");
INSERT INTO cbsNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","januxun Simónen dikabi ikunwanyan nashima Felipebe kakunkaunkin jaska tsuan atiduma dami atimaska betsa betsapa akai uin Simón e ikunkainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","januxun jaska jabun Samaria anuxun Diosun kakape Jesúskidi jancha ikunwankin ma chibainbun jaska kakaibu Jerusalén anuxun ninkatan Jesúsun kushipayabun jau Pedro inun Juanen jatu medabewatanunbun jatu jadi nichianbu buabun ");
INSERT INTO cbsNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","tsuabunda Jesús ikunwainbu Felipen bebunkidi jawenabu unanti wamakin Xanen Ibu Jesúsun kenawen jatu nashimashina jabu betsa Diosun Yushin Pepatun jatu achidiamaken jaska jatu wabu bushinxun ja Samaria anuxun ikunwanshinabu jatukidi Pedro inun Juanen Dios jau jawen Yushin Pepa binunbun jatu yukaxuntan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","januxun jawen Yushin Pepa achimakin jatu mamepixun jatu yukaxunaya ja Yushin Pepatun jatu medabewai jatuki jikia akeakenikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Januxun Jesúsun kushipayabun ikunwainbu jatu mamepiaya Diosun Yushin Pepa jatuki jikiai Simónen uin: “Eandi ja kushipa peiwen binun”, iwanan, Pedro inun Juan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","yuikin: —Na jaska kushipa eadi en jayanun ea inankanwen, man jatu akai keska wakin yuda betsabudi mamepixun Diosun Yushin Pepa en jatu jikimaxununan, na pei ichapa en matu inainan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","januxun Pedron kemakin: —Diosun kushipa inankuinki. Peiwen taexun min bikatsis ikaiwen taea min peiya janu chiwen ikunwanbuma Diosun jatu kupixanai anu min katiduki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jaska inun, mianan, min shinan chakai Diosun unainwen taexun jawen kushipa min bitidumajaidaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Ean jaska en mia unaiin. Jaska yushin chakabun muka min bini min jenediamaken mia medanxun ja min chakabun mia nexayuaki. Jakia shinan betsa watan min chakabu min putaya jau Diosun mia buaxunun min yuka min chakabu mia buaxuntidumenkain— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simónen kemakin: —Chanima en kanejaidaxuki. Ea Dios yukaxunkanwen, jau jaska min ea yuiai keska wakin ea kupiyamaxanunan— iki jaska chaniaya jau Diosun jawen chakabu buaxunun yukaxuntan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","jabianuxundi Diosun jancha yusinkin kakape Jesúskidi jatu yusin menetan Jerusalénkidi ana chintunbidankin mae betsa betsapa Samaria mai pakea anuxun Jesúskidi jatu yusinkubidani Jerusalénkidi chintunbaini bui jikinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","28","Ja jaska wawanshinabutian Diosun nai tsuma betsan Felipe yunukin yuikin: —Benitan Jerusalén anua kai surkidi ja bai tanabaini Gazakidi kawen katanwen— aka Felipe benitan kai janu tsua jiweabuma anu bai tanabainaya bai namaki Etiopianawa ainbu xanen ibujaidatun tsuma juni jawen pei mekexunikatun Jerusalén anuxun Dios kenwantani jawen mae anu ana chintunkaini caballo dabetan tadanbainaiki nawa ina tsauxun Diosun jancha Isaíasin keneni yuikubidanai bechitan uianyan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Diosun Yushin Pepatun Felipe yuikin: —Kakain jaki kemai nukutanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","jaska ninkatan jawaida kain jaki nukuaya Diosun jancha yuixunika Isaíasin keneni yuiai ninkakin Felipen yukakin: —Ja kene min yuikubidanaidan, ¿min ninkai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopianawan ninkatan kemakin: —Jaskatan tsuan ea jakidi yusin pewai en ninkatidumaki. ¿Mian min unainmenkain? Ebe inatan kakin ea tapinmabainwen— aka —Peki— itan inatan jabe tsaukainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","jabias kene yuixu Etiopianawan ana Felipe yuixunkin yuikin: ‘Chaxuwan detenikatun detenun, iwanan, iyumis keska wakin tsuan nemama iniki. Ja inun, chaxuwan bake dani damexteabu chaxuwan jawan ikama pesmis keskai jawa yuiama iniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Januxun ichakawakin nuitapawabu jawa yuiamaken tsua jawen nuikin medabewamadi iniki. Jaska wakin bakeuma tenanbu tsuan janixun jawen bababukidi jakidi janchatidubumaki, jaska wakin jawen jiwea mebinkin mai anua mexa keska wakinan’, akin yuixuntan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Felipe yukakin: —¿Tsukidi ja Diosun jancha yuixunikatun kenenimen? ¿Ibubiskidimenkain? ¿Juni betsakididaka? Menan ea yuidiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipen unanmakin Diosun jancha dama yuixudan, jawen yusin taewakin kakape Jesúskidi Etiopianawa tapinmakin ninkamakubaina ");
INSERT INTO cbsNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","ma jatixunda ka ianki kemakin jaska Felipen dama yusinxu Etiopianawan yuikin: —Uian. Ma min ea yuikubidanai en ikunwainwen taexun ¿ana en jawamamen, na jene anu min ea nashimatidudan?— atan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","jatun caballo tadanmabainai jau niti anun jawen tsuma yunua niti amaya butudabekain jenen pukutan Felipen xanen ibu nashimakin menetan ");
INSERT INTO cbsNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","jene anua nexekedabebidanaibun januxun Diosun Yushin Pepatun Felipe dami wabainkin yamawabainaya ja xanen ibun Felipe ana uianma jawen tadanbaintiki inatan ja kaikidi kai benimajaidakainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","janua Felipe Yushin Pepatun iyuxun mae betsa Azoto anu butea janua mae tibi anu jikiakeakekainkin Diosun Katua Jesús mekenankidi kakape jatu yuikubaini atimas maewan betsa Cesarea anu jikinikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Janua jabiatiandi Xanen Ibu Jesús ikunwainbuki pubenkin Saulon jatu ichakawakin tenankin jenediama jaskawen taea Diosbe jawenabu janchaxunika xanen ibujaida jatu binua anu Saulo kaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","jaska shinain yuikin: “Damasco anu kaxun ja Bai Bena Jesúskidi jatu tapinmaibu juni inun ainbu achitan Jerusalén anu en jatu iwekatsis ikaii, nenu jatu bichinun, iwananan. Jaskaken min kushipaya kanun, iwanan, en mia yukai juaii. Ea kushipa wakin Damasco maewan anua janu nukunabu ichamisbu jiwe anu en kaken jau xanen ibubun ea medabewaxanunbun min kushipa jatu yunuwe, en buaidan”, aka: “Peki”, ixun kenexuntan jaya yunua ");
INSERT INTO cbsNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","janua Saulo jaska wa kai Damasco bai tanabaini ma kemaya nai anua bin kushipajaida pexekidan Saulo dachaxaya ");
INSERT INTO cbsNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","janua Saulo main di ikaya jui taxnikin yuikin: —Sauloon, Sauloon, ¿jaskakin min ea jatu ichakanwain?— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulon dateyabi yukakin: —Xanen ibuun, ¿min tsua ikai?— aka januxun ja jui taxniaitun Saulo ana yuikin: —Jabia ea ikunwainbu min ea jatu ichakanwainan, en eaki, Jesúsdan. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Benikaini kai Damasco anu kaditanwen, jadixun min jaskakunkainxanai tsuanda mia yuixanikikidan— akaya ");
INSERT INTO cbsNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ja junibu Saulobe buaibun jawen jui ninkabiai tsua uianma datejaidaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","janua Saulo main daka benikauan ma bepexebia jawa uintidumaken ja jabe buaibun metsunxun Damasco anu Saulo iyuabu ");
INSERT INTO cbsNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","jaskakainshina jadia ma xaba dabe inun besti kaya jawa uianma datekin Saulon jawa piama jawa nuxuamaken ");
INSERT INTO cbsNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ja Damasco mae anu jiwexun Jesús ikunwain betsa jawen kena Ananías nama keskaiwen uianyan Xanen Ibu Jesús juxun ja bebunxun kenakin yuikin: —Ananíasiin— aka kemakin: —Xanen Ibuun, en nenuki. ¿Min jawa ea yuiai?— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xanen Ibu Jesúsun yuikin: —Benikaini kakin ja bai jawen kena Kayatapia anu kaxun Judasin jiwe anu jikitan janua juni betsa Tarso anua kaini jushian jawen kena Saulo yuka itanwen, Diosbe janchaikikidan. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Namai keskawen juni jawen kena Ananías jikitan mamepixun jau ana uin benawanun, medabewai ma uinxuki— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananíasin ninkatan Jesús yuikin: —Xanen Ibuun, Jerusalén anuxun minabu medibi min jatu wai ja junin mia jatu ichakanwanmiskidi ichapabun jakidi janchakin chakabu ea yuimisbuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jatu jaska wakubaini Diosbe nukunabu janchaxunika xanen ibubun kushipaya beshianbukiaki. Nun jabun min kenawen taexun Dios yukaibu dasibi nukudi nenua achitan Jerusalén anu nuku iyuxun bichinun ika jushiankiaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","jaska yuibiaya Xanen Ibu Jesúsun ana yuikin: —Jen iyamai dateama katanwen. Ja juni kaindiama en katunitun ekidi chanikin nawa xukua betsa betsapabu jatu yusinkin inun, jatun xanen ibubu yusindiakin inun, Israelbudi ea jatu yusindiaxunkubainxanikiki, ");
INSERT INTO cbsNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ea chibainwen taea jaskai nuitapakunkainxanai en unanmaxanaidan— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ninkabaini Ananías kai janu Saulo ika anu jikikain mamepitan yuikin: —Sauloon, Jesús ikunwain ma min nukun betsaki. Min bai tanabidanai jabias Xanen Ibu Jesús miki nukushinatun jau min bedu min ana uin pewanun inun jawen Yushin Pepatun jau mia achitan kushipa wanun mia anu Jesúsun ea yunuxuki— akaya ");
INSERT INTO cbsNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","19","jakimamadi jawaida Saulon bedu anua baka xaka keska nidi ikaya ana uin pewatan benikain ma jatubetan Jesús ikunwanyan nashimatan iyuxun pimabu ana kushipatan uxa eskadabes Damasco anua ikunwainbube jiweyunikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Janu jatube jiweyuxun janu judiobu ichamisbu betsa betsapa anuxun Saulon jatu yusin taewakubaunkin: —Jesúsdan, Diosun bake kayabiki— akin jatu yuikubainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","dasibibun ninkai e iki yuinamei: —Na juninan, Jerusalén anuxun ikunwainbu jatu ichakawamisxun nenudi juxun nun jabun Jesúsun kenawen taexun nun Dios yukaibu nukudi jabiaskadi wakin nuku achixun Jerusalén anu Diosbe nukunabu janchaxunika xanen ibubu anu nuku iyunun ika jushianan, ¿ja junidan, jamamen?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","janua Saulo ana jawa dateama Diosun kushipawen xabakabi judiobu Damasco anu jiweabu jatu yusinkubainkin: “Jesús Diosun Katua Mesíaski”, akin Diosun jancha kenenibuwen jatu unanmakubainaya janua judiobun uin e iki jakidi jadakidi shinantima ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","uxa ichapa jatu yusinkubainaya judio xanen ibubu Sauloki sinatakin detekatsis iki jakidi janchai yubakashinabun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulon ninkatan unanyan janu kainkainai achinun ika yubakashinabu badidi inun meshu medan ja maewan mishki kenebaunibu jikiti xui anu manakakin kexeabun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","janua jatun mae anu mishkiwen kenekin keyatapa wanibu janu uinti xui anu Saulon jabu jatu yusian Jesús ikunwain jaki chiti ikaibu betsabun meshu medan Saulo kuki ewapaki nanetan buteabu ja mae anua kainkaini paxanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Janua paxai kai Jerusalén anu ana jikishina janixunda Jesús ikunwain betsabube ichanun ika dasipanan jaska jatu ichakawa chakayamakubainshinawen taea dasibibu jaki mesei ikunwanma ikai dabanen shinain: “Jesús ikunwanmabia Saulon nuku bepadantan anun ika ikimenkaintsa”, ika jaki dateaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","jakidi mesebiaibun Bernabén Saulo Jesúsun kushipayabu anu iyuxun jatu unanti wamakin yuixunkin: —Ana jaki meseyamakanwen. Damascokidi kakin nukun jaibu Saulon Xanen Ibu Jesús uin jabe janchaimaki. Januxun Jesús ikunwantan jawen kushipawen Damasco anuxun jawa dateama Jesúskidi jatu dasibi yusinbaunshinaki— jatu wakin jatu beya wamakin tapinmashinawen taea ");
INSERT INTO cbsNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","janu jatu anu niti iyushina jaskai jiweyuxun Jerusalén anu Jesúsun kushipayabube jiwea jawa dateama nukun Xanen Ibukidi yusiin Saulo jatube janchakunkainkin ");
INSERT INTO cbsNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","judiobu griego janchawen janchamisbube jatube janchai yuinamekin jatu yusianyan jawen yusian danain jaki sinatakin tenanun ika yubakaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","jakidi jaska shinainbun ikunwainbu betsabun june ninkaxun Saulo medabewanun, iwanan, ianenwan kexa Cesarea anu iyushinxun jadixun jawen mae Tarso anu niwe xaxu ewapawen nichinkin yununibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ja jaskaibutian ikunwainbu Judea mai pakea anuabu inun, Galilea mai pakea anuabu inun, Samaria mai pakea anuabu ichakawakin ana tsuan jatu meabuma unanuma jawama jiwei janua ikunwainbu kushipai Dios kushipaki meseaibun jawen Yushin Pepatun jatu medabewaya ana ichapabun ikunwain midimabu jatuki dasikubaini jiwenibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Januxun Pedron ikunwainbu jatuki bakin jatu yusin kakunkaunkin mae betsa Lida anu jiweabu anudi Diosun enabu medibi anu jatuki bai jikixun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","janua juni betsa jawen kena Eneas jawen yuda babuniwen taea ma 8 año kabia benisma dakasa Pedron bechitan ");
INSERT INTO cbsNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","yuikin: —Eneasiin, Jesucriston mia kaya waikiki. Benitan ja min jaki dakamis pewadiwe— aka jawaida Eneas benitan jawen yuda damestentan nikaunaya ");
INSERT INTO cbsNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ja mae dabe Lida inun Sarón anu jiweabun ja juni Pedron kaya washina uinkin Xanen Ibu Jesúskidi ninkakin dasibibun shinan betsa wanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ja badi jaskaitian mae betsa chaima Jope anuxun ainbu betsan Jesús ikunwain jawen kena Tabitá, griego janchawen jawen kena Dorcasdan, ainbu duapatun jawauma nuitapaibu jatuwen dabanan ikin jatu medabewakubainmis ");
INSERT INTO cbsNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","e iskaun jawaida isin bitan mawaken jawen yuda dachuxun manaundi jiwe keyatapa dintu anu iabain mapemaxun datantanabun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ja mae udama Lida anuxun Pedron jatu yusiain Jope anuabun ikunwainbun ninkatan jau jabun ja yuixuntanunbun juni dabe nichinkin jatun jancha jatu yuikin: —Pedro yuikinan, eska watankanwen: “Menaan, jawaidakiaki. Jope anu judiwe”, atankanwen— jatu wa buxun yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","janua Pedro iyuabu jatube kai jikitanaya janua Pedro ana uke medan iyukin janu yuda mawa datanbu anu jikimaibun ja ainbu beneuma nuitapaibun kexebauna kaxakin Dorcas jiwexun jatu tadi waxunmis Pedro uinmai ana kaxa chakayamaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","jatuwen nuikin dasibi jatu kainmatan danti ixun Dios yukaxuntan ainbu mawa beiskin yuikin: —Tabitáan, benidikidanwen— aka bepexetan Pedro uintan tsauaya ");
INSERT INTO cbsNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedron metsunxun benitan januxun ainbu beneuma nuitapaibu inun ikunwainbu betsabu jatu kena bexun ma ainbu ana jiwema uiainbun ");
INSERT INTO cbsNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","dasibi Jope maewan anu jiweabun Pedron jaska washina ninkashinxun ichapabun Xanen Ibu Jesús ikunwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jatu jaska waxunshina janu jatun ina awa bichi payukin pewamis jawen kena Simónen jiwe anu jiweyuxun Pedron jatu yusinyukubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea maewan anuxun Romano capitán jawen kena Cornelio inikidi mia yuinun ninkawe. Jawen 100 soldadobu xukuaya jatu kenamisbudan, Italiano wamisbu ");
INSERT INTO cbsNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ja juni pepa enayamistun jawen jiwe anu jatube jiweabubetans Dios kenwankubainikiaki, januxun judiobu nuitapaibuwen nuikin medabewanun, iwanan, jatu pei inanxuni inun Diosbe janchai jeneismadan. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Janua xaba betsatian ma badi kai 3:00 badi dakaken nama keska uianyan Diosun nai tsuma betsa jawen dintu medan jikikainkin xabakabi Cornelio uinmabain yuikin: —Cornelioon— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","jakidi besuxun uin datejaidakin yukakin: —Xanen ibuun, ¿jawamen?— aka januxun nai tsuman yuikin: —Dios kenwankin min dayuimis inun jaska dasibi nuitapai jawa jayabuma min jatu medabewamis Diosun ninkatan ma miwen benimaikiki. Jaskawen taexun mia yuinun ninkawe. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ja mae Jope anu tsuada yunudiwe, jau Simón Pedro mia ixuntanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ja Simón betsan jatun bichi pewakin pukumistun jiwe anu ianenwan kexa dapi Simón Pedro jabe jiwea jaki nukui bukanikiki— abaini ");
INSERT INTO cbsNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ja nai tsuma jabe janchatan kaken jawen tsuma dabe inun soldado betsan Dios kenjaidawadiakin Cornelion jancha ninkaxunmis jatu kenaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","dasibi jaska nai tsuman yuixu jatuki chanitan jatu nichian badi kabiaya Jopekidi bui ");
INSERT INTO cbsNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","janua bai puchinin uxashini ana bui ma Jope kemai ma badi manananbi jikidiama bui bai tanayubainaibun jabiatiandi Pedro Diosbe janchanun ika mai bawa jiwe sapa xeni anu mapeketan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","bunikin pinun ika ibiaya jatun bawamistun dama pewaxunaya uxa nama keskakin Pedron uinkin ");
INSERT INTO cbsNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","nai bepenmanakainai uianyan tadi ewapa kexema ja dabe inun dabe dexun tibi dispiwen nexabauna mai anu Pedro bebun buteaya ");
INSERT INTO cbsNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ja tadiki uke medan yuinaka tae dabe inun dabeya inun, main xadamisbu, inun peiyabu mata judiobun pisbuma Pedron uianyan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","januxun nai anua jui taxnikin Pedro yuikin: —Pedroon, benitan jadatuda ja yuinaka min uiain betsa detexun piwe— aka ninkatan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedron nemakin yuikin: —Xanen ibuun, ea jaska wayamawe. Nukun xenipabun beya chibankin yuinaka betsa betsapa atimapa jaska nun pitidumajaida Moisin nuku nemani en pismajaidaki— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ana jawen jui taxnimakin yuikin: —Diosun jawada dasibi na mia pewaxunxuwen taexun ana: “Diosun mia nemamis”, yuikin ana dananyamawe— atan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ana dabeki jabiaskadi Pedro yuikin nemaya jawaida ja tadi ewapa nai anu ana jawendi ainibainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedron dama jaska uinxuwen taea “¿Jaskada ea yui ixumen?” ika shinain jawen dabanan nuijaidaya janua Cornelio anua bea Simónen jiwe yuka ikubidani jawen jiwe anu kematan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","unanxubima yuka ikin: —Na jiwe anudan, ¿Simón Pedro jiweamen?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ja kenaibu ninkama Pedron jaska uinxu unanun ika shinan jenediamaken Diosun Yushin Pepatun yuikin: —Uinwen. Juni dabe inun bestitun mia benakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","En jatu yunushinawen taea benikain bututan jawawen nuiama jatube katanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro bututan Cornelion jatu yunushina Pedron jatu yuikin: —Ja man benaidan, en eaki. ¿Jawa wanun ixun man ea benai?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","jabun Pedro yuikin: —Nukun xanen ibu capitán jawen kena Cornelion nuku yunushina mia anu nun juxuki. Juni duapa pepatun Dios kenwandiamiski. Jaskawen taexun judiobu dasibibun bechipaikin jakidi pe shinanmisbuki. Januxun jau min jancha ninkaxanun Diosun nai tsuma betsan yunua ninkashinxun jawen jiwe anu min kanun mia kenaikiki— akabu ");
INSERT INTO cbsNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","jabianu Simónen jiwe anu Pedron jatu bashia janu jatube uxashini penaya Pedro jatube kaya ikunwainbu betsabu ja Jope anu jiweabun Pedro banawabainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","jatube kai ana bai puchinin uxashini bui ma Cesarea anu jikitan buaibun Cornelion jawenabus inun jawen jaibu jabe duanamemisbu jatu ixun jawen jiwe anu jatu ichawaxun jatubetan Pedro manaya ");
INSERT INTO cbsNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","jawen jiwe anu Pedro jikinun ika kaya Cornelion itanun ika kainkain kenwain Cornelio ja bebun danti itan mepia dakaken ");
INSERT INTO cbsNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","januxun Pedron nemakin metsuntan benikin yuikin: —Eki jaskama benidiwe. En jawamaki, mia keskadi junidan— atan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","janua jabe nia janchadabetan janua jawen jiwetan bichibaina jawen dintu ewapa medan yuda ichapa janu ichabu anu jatuki nukutushitan ");
INSERT INTO cbsNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedron jatu yuikin: —Nun judiobu nukun xenipabun beya chibain judiobumabe nun ichatidumajaida inun matun jiwe anu nun jikitidumajaidadi man unaiin. Nun jaskabiamisken en ana matu dananyamanun Diosun ea unanmakin yusinshinawen taexun ");
INSERT INTO cbsNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","min ea kenashinken jawa matu ana danain mesei teai niti ikama mia anu en juxuki. Jaskanun ixun min ea kenashinamenkain ea yuidiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelion kemakin: —Ma xaba dabe inun dabetian ka na jabia baditiandi 3:00 badiken en jiwe anua samakekin en Dios kushipa ea akaya en besuudia Diosun nai tsuma betsa tadi juxupa chaxajaida sawea nixun ");
INSERT INTO cbsNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ea yuikin: “Cornelioon, min Diosbe janchakin dayuimis inun jaska dasibi nuitapaibu min medabewamis Diosun uinkin shinankubainmisxun ma miwen benimaikiki. Jaskawen taexun mia yuinun ninkawe. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ja mae Jope anu tsuada yunuwe, jau Simón Pedro mia ixuntanunan. Ja Simón betsan jatun bichi pukukin pewamistun jiwe anu ianenwan kexa dapi Simón Pedro jabe jiwea jaki nukui bukanikiki”, ea wa ");
INSERT INTO cbsNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","jau mia itanunbun jawaida en jatu yunua bushinxun mia iweabu chanima nukuwen nuikin min nuku pewabidanxuki. Jaskawen taea natian Diosun nuku uianyan jawen jancha ninkanun ika nun ma ichaki. Jawada min Diosun mia yunua min jatu yusinmis nukundi nun ninkakatsis ikai nuku yusindiwe— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","januxun Cornelion jiwe anu ichabu Pedron jatu yusinkin taewakin yuikin: —Natianan, chanima mai jidabi anu xukuabu tibi nuku damiwanidan, nun jabiaskas xabakabi ea ma uinmashinaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Na mai anu jiwebaunabu tsuabunda Dios ninkai jaki mesekin chiban pewaibu Diosun jawa jatu danainsma ea yusinshina na jabiatian en ma tapiaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Jamen dasibibun Xanen Ibu Jesucristonan, Israelbu anu dukun jau jabu yusinun Diosun yununiki. Januxun tsuabunda jawen janchawen unanuma jiwetidubukidi Jesús juxun jatu yusinkubainyamaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Januxun ja dukunan, Nashimanika Juanen Diosun jancha jatu yusianyan ninkatan jatun chakabu jenetan jawenabu unanti wamaibu Juanen jatu nashimakubainaya Jesúsun Galilea anuxundi yusin taewakin Judea mai pakea anu yusinkubaunaikidi kakaibu chanima man ninkayamaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Januxun Jesús Nazaret anua jawen Yushin Pepatun kushipawen Diosun Jesús kushipajaidawa ja medanua medabenankunkainaya jabu diablo Satanásan ichakawakin isin betsa betsapa jatu tenemamis nuitapaibu Jesúsun jatu xuxawakin pewakin jatu medabewakubainyama man unandiaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jaskadan, nukunan, ibubis nun uinkubidanyamaki. Janua Jerusalén anuxun inun mae betsa betsapa Judea mai pakea anuxun Jesúsun jaska wakubainai achixun cruzki mastaxun tenanyamabuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Janua xaba dabe inun bestitian Diosun ana bestenwanshina janua Jesús nuku ana uinmakin ");
INSERT INTO cbsNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ana yuda ichapabu jatu uinmama jatibu Diosun bebunkidi ma nuku katuni besti ana nukuki nukutan nuku uinmayamaki, mawa ana bestenshinakidi nun jatukidi chanikubainxanunbunan. Ja Jesús mawa ana bestenkainshina jiweadan, ana jabetan pikin nun jabetan nuxukubainyamaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Janua badi jawen jeneaitian jaska yuda dasibi mawabu tibi inun jiweabu tibi Jesús xanen ibukin jatu unanti waxanai nun jatu yusinkubainxanunbun Jesús jabitun nuku yunubainyamaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jaska inun, uatian jabias Jesúskidi Diosun jancha yuixunika dasibibun bebunkidi jatu yusinkin: “Diosun Mesías tsuabunda ikunwainbu jawen taexun jabun chakabu Diosun jatu buaxununbadikiki”— akin ");
INSERT INTO cbsNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedron jatu yusin janchai jenediamaken janua ja jabun jawen jancha ninkaibu anu Diosun Yushin Pepa jatuki jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","nawan jancha betsa betsapa tsuan jatu yusindiamawen janchai taekin Dios kenwainbu ja ikunwainbu Jope anua Pedrobe bekanxu jatu ninkai: “Jabaa! Jabu judiobumabiaken Diosun jatu jaska janchamakin jawen Yushin Pepa jabudi ma jatu inanxuki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","judiobu jabe bekanxu Pedron jatu yuikin: —Na judiobuma jaskaibudan, “Na yudabu jatu nashimayamananwen”, iki nemai nun itidumaki. Nuku keskadi wakin Diosun jawen Yushin Pepa ma jatu inanxuki— itan, ");
INSERT INTO cbsNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","dasibi Jesucristo jabun ikunwankanxu jau jawen kenawen taexun jatu nashimanunbun Pedron jatu yunua jatu nashimanibukiaki. Januxun Pedro ea akin jau uxa eskadabes jatube jiweyunun bashiyunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Janua nawan mae anuxun judiobumabiabun Jesúskidi Diosun jancha ninkatan ikunwanshinabun kakaibu Judea anuxun Jesúsun kushipayabu inun ikunwain betsabun ninkashinabun ");
INSERT INTO cbsNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","janua Pedro Jerusalén anu chintunkidani jikishinken ikunwainbu betsa betsapabun judiobun beya bechipaijaidamisbu jaki ja ikin chitekin ");
INSERT INTO cbsNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","yukakin: —¿Jaskai judiobuma anu jatu uin kaxun min jatubetan pishianmen, nukun beya ana chibanma kanekinan?— akabu ");
INSERT INTO cbsNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","januxun Pedron jatu kemakin jaska iki taekainshina dasibi jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ja mae Jope anua Diosbe janchai uxa namai keskakin en uianyan nai bepenmanaya tadi kexema ewapa dabe inun dabe dexun tibi dispiwen nexabauna ea anu buteaya ");
INSERT INTO cbsNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","jabia tadiki uke medan yuinaka tae dabe inun dabeya betsa piananbu inun, main xadamisbu inun, peiyabu mata judiobun pisbuma en uianyan ");
INSERT INTO cbsNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","januxun nai anua jui taxnikin ea yuikin: “Pedroon, benitan jadatuda ja yuinaka min uiain betsa detexun piwe”, ea waya ");
INSERT INTO cbsNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ean kemakin: “Xanen ibuun, ea jaska wayamawe. Nukun xenipabun beya chibankin yuinaka betsa betsapa atimapa jaska nun pitidumajaida Moisin nuku nemani en pismajaidaki”, en aka ");
INSERT INTO cbsNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","januxun nai anua jawen jui taxnikin ana ea jancha wakin shinan tapinmakin ea yuikin: “Diosun jawada dasibi na mia pewaxunxuwen taexun ana: ‘Diosun mia nemamis’ yuikin ana dananyamawe”, ea watan ");
INSERT INTO cbsNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ana dabeki jabiaskadi ea yuikin nemaya ana jawendi naiudi ana ainikin buaya ");
INSERT INTO cbsNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","en jaska uianyan juni dabe inun bestitun Cesarea anuxun jatu yunua beshinxun en janu ikanu ea benaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","januxun Diosun Yushin Pepatun ea yunua jawa teama en jatube kaya na 6 nukubetan Jesús ikunwainbu ebe mapuabu ebe budiatanshinabuki. Jatube kai nawan jiwe anu nun jikiaya ");
INSERT INTO cbsNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","januxun nawan nuku yuikin: “En jiwe anu en jiweken Diosun nai tsuma betsa juxun ea yuikin: ‘Ja mae Jope anu tsuada yunuwe, jau Simón Pedro mia ixuntanunan. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ja juni juxun kakape min jawen paxaxanai mia inun minabuya mia yusinxanikiki’, ea wa en mia kenashinaki”, ea waya ");
INSERT INTO cbsNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","januxun Jesúskidi kakape en jatu yusin taewaya Diosun Yushin Pepa ja dukun nuku anu juyama keskai jabu anudi juxun jatuki dasikin jatu achishinaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Januxun jatu jaska waya jaska bebunkidi nukun Xanen Ibun nuku yuibaini en shinanshinaki: “Chanima Nashimanika Juanen jenewen jatu nashimakubainshinaki. Jakia Diosun Yushin Pepatun matu nashima keska wakin matu kushipa waxanikiki”, akin Jesúsun nuku yuibaini ikai en uinshinaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Januxun nukun Xanen Ibu Jesucristo nun ikunwanyan jawen kushipa nuku inanyama keska wakin ja nawabundi ikunwainbu Diosun jabiaskadi waya ean jaska waxun Dios en nematiduma ishianki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Diosun jatu jaska washina Jerusalén anua ikunwainbun ninkatan ana Pedro ja akama nesetan Dios kenwankin yuikin: —Judiobuma dikabiwen nuikin jatu shinan betsa wamakin chanima Diosun jatu jiwekuian inandiaikiki, ikibi imakinan. Pejaidaki— anibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ja xabatian Esteban tenantan jabiatiandi dasibi Jesús ikunwainbudi jatu ichakawai bedukubaunaibuwen taea datei Fenicia mai pakea anu inun, Chipre natukan anu inun, Antioquía maewan anu paxai buimaxun judiobuma yusianma jatunabu judiobu besti Jesúskidi kakape jatu yusiainbun ");
INSERT INTO cbsNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","jakia ja jaskaibun ikunwain betsabu Chipre anuabu inun Cirene mai pakea anuabu Antioquía anu buxun griegobudi Diosun kakape Xanen Ibu Jesúskidi jatu yusindianibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Janua jabu Diosun Yushin Pepatun jatu kushipa waya jatun yusianwen taexun griegobu ichapabun jatun shinan xeni jenetan jiwea bena nukun Xanen Ibu Jesúskidi ikunwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Janua Antioquía anuxun judiobuman ikunwainbukidi Jerusalén anuxun ikunwainbun jatu ninkatan Bernabén jau jatu medabewatanun yunuabu ");
INSERT INTO cbsNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé kai jikishinxun jabu Diosun jatu duawakin jatu kushipa wakin pepawai uin benimajaidakin jatu ana yusin pewakin jau dasibi jawa chakabuyabi jusiama nukun Xanen Ibu Jesús ikunwain chintuanma chibankubainkin apakenunbun jatu yusiain ");
INSERT INTO cbsNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé juni pepa duapa Jesús ikunjaidawamis Diosun Yushin Pepatun kushipa jayaken jawen yusian ninkai ichapabu nukun Xanen Ibuki dasikubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jatu jaska watan tsube medabetima: “Jau Saulon ea medabewayunun”, ika Bernabé Tarso anu benai kashian ");
INSERT INTO cbsNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sauloki nukutan Antioquía anu iyui jabe jadi kaimaxun jatu yusinkin año bestichai nichinkin yuda ichapabu kaka pepa Jesucristokidi jatu yusinkubainaibun ja mae anuxun nawabun Jesús ikunwainbu jatukidi shinankin kenakin: “Nabudan, jabun Cristo chibainbuki”, iwanan, jatu kena taewanibukiaki, nawan janchawen kenakinan, “Cristiano”, jatu wakinan. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ja jaskaibutian Diosun jancha yuixunika betsabu Jerusalénkidia Antioquía anu buxun ");
INSERT INTO cbsNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","betsa jawen kena Agabo ikunwainbu ichabu anu jatu yuinun ika benixun Diosun Yushin Pepatun medabewakin janchamaya bebunkidi jaskaxanai jatu yuikin: “Mai jidabi anu piti jayama dasibibu bunijaidaxankanikiki”, jatu wayama Roma maiwan anua Claudio xanen ibujaidaya jaska Agabon jatu bebunkidi yuiyama jaskanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jaskaibun Judea anuxun ikunwain nuitapaibu jatu medabewanun, ixun, yuinametan jatu pei ichawaxunkin pei ichapayabun ichapa inankin eskadabes jayabun eskadabes inankin jatu ichawaxuntan janua ");
INSERT INTO cbsNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Judea anuxun ikunwainbu mekenikabu jau pei jatu jabun inantanunbun Antioquía anuxun ikunwainbun Bernabé inun Saulo katutan yununibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ja jaskaibu jabiatiandi xanen ibu Herodesin ikunwainbu betsabu jatu ichakawakin taewakin ");
INSERT INTO cbsNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","soldadobu jatu yunua Juanen betsa Santiago nupe chaipawen detekin tenanshinabun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","jaska waibu judio xanen ibubun uinkin bechipaishinabun Herodesin unantan judiobun misi xaxama besikin pimisbutian Pedrodi jatu achimaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","bichiti jiwe medan Jerusalén anu jatu bichimatan jabu tibibun jau mekekin kexebainunbun soldadobu 4 xuku tibi jabu 4 soldadobun jabuan jau mekenunbun jatu yunutan shinankin: “Judiobu Pascua nawai besi keyuaibun Pedro unanti waxun en jatu tenanxundiaxanaii, judio xanen ibubu benimawakinan”, ishinken ");
INSERT INTO cbsNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedro kene medan bichishinabu jatu kexe pejaidawamabun janua ikunwainbu jawen nuikin jau taxnimanun jakidi Diosbe janchakin yuka chakayamaxunkin jeneabumaken ");
INSERT INTO cbsNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","janua Pedro bichixun uxanshinkin penaya yudan kaianen bedubi uiainbun Herodesin Pedro unanti watan tenankatsi ikin manaya janua Pedro soldado dabebe mane dispi chiwetameyawen jabe menexekea mekea jabe uxabun, janua dabedi kini jawen beputi kexexun uinjaidaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","janua bichiti jiwe medan Diosun nai tsuma damii jikii chaxai xabakain bichiti dintu medan xaba wa nitan nai tsuman Pedro uxa bestenwankin tima tima aka bestein tekuitanai yuikin: —Menaan, jawaida benidiwe— akaya ja Pedro mane dispi soldadobube menexekea jawaida jamebi chudekei nidi ikaya ");
INSERT INTO cbsNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","nai tsuman ana yuikin: —Min nanexeketi sawetan min bichi tae sawediwe— aka Pedron jaska waya nai tsuman ana yuikin: —Min tadi bemakia peyabukutan ea chibanbidanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","jachun kakin chibanbainkin shinain: “¿En jaskai? ¿En chanima ma bestean daka kai ikai? ¿Na ea nai tsuman eska waidan, en daka uxa namai ikai?”, ixun shinanbaini ");
INSERT INTO cbsNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ja dukun soldado betsa dainbaini ana betsandi kexea ja kachu daindiabaini kai bichiti jiwe jawen jenea beputi anu mane beputi kushipawen bepuabuki kemaya jamebi bepenmanaya janua kainkaini taxnidabetan bai tanabainkin nai tsuman ja besti jenebaina ");
INSERT INTO cbsNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","januxun Pedron shinan kayatiwakin unantan: —Herodes inun judio xanen ibubun dasibi ea jaska wakatsi ikaibu nemanun, iwanan, chanima en Xanen Ibun jawen nai tsuma yunua juxun ea taxnimaxu shinankin en unaiin— itan, ");
INSERT INTO cbsNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","jaska shinanbaini Juan Marcosin ewa Marían jiwe anu ikunwain midimabu ichaxun Dios jakidi yukaxunaibu anu Pedro kaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","jiwe jemaintin kenenibu janu jikiti xui beputi tsan tsan akaya Marían tsuma ainbu jawen kena Rode: —¿Tsua ikimenkain?— ika kainkain uin kaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedron jui ninkatan benimajaidai bepenxunyuama kushikain uke medan jiwetan jikixun jatu yuikin: —Pedrodan, ua ma beputi kexa nia en ninkatanaii— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","jawen jancha ikunwanma jabundi yuikin: —Jamabiaken min jumei ikaii— akabu —En chaninwain ikai dabanen man ikaii. Jaskamaki— ikaya jabun ana yuikin: —Jamaki. ¿Jatun mekea jawen nai tsuma min ninkatanamen ikai?— ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedron jatu kenakin tsan tsan akin jeneamaken janua bepenxun bechitan uin e iki teku iki keyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","januxun jikitan jawen mekenen jatu nemakin jatu jancha nesematan jaska jawen Xanen Ibuan bichiti jiwe anua taxnimakin paxawaxu jatu yuitan ana yuikin: —Jaskatan en kainxu Santiago inun ikunwainbu betsabu ea jatu yuixunxankanwen— jatu watan janua june kainkaini mae betsa anu iduyui kaken ");
INSERT INTO cbsNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","janua ma penai xabaya Pedro jaskatan kainkaina unanma bepuxui bichiti jiwe anua soldado uinikabu jaskatima datejaidaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","januxun jawen soldadobu betsa Herodesin yunua benabaunkin Pedro bechiabumaken ja soldadobun Pedro mekeshinaibun Herodesin jatu yuka jawa yuitidubumaken jatun jancha bechipaiamajaida ja jabun meke chakashina soldadobu kupikin jau tenanunbun soldado betsabudi yunutan janua Judea jenebaini kai Cesarea anu Herodes jiwei kanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Janua Tiro anuabu inun Sidón anuabuki Herodes jatuki sinataya Tiro inun Sidón yudabun piti Herodesin maiwan anua bimisbuwen taexun xanen ibu Herodes daewakatsis iki jabe xanen ibu bexmas Herodes medabewamis Blasto anu bexun jau jatu medabewakin daewamaxanun jaibu watan yukashinabu ");
INSERT INTO cbsNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","janua xaba betsatian Herodesin jatu jancha wakatsi jatu kenashina bea xanen ibu betsabudi bedia icha maniabun jatun besuudi Herodesin ichati tadi jawenduajaida sawea januxun yunumis anu tsauxun jawen jancha jatu yuikin taewaya ");
INSERT INTO cbsNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","januxun junibun jabun jawen jancha ninkakin bechipaikin unanxubima yuikin kenwankin: —Na Herodes janchaidan, juni keskamaki. Dios betsa keskai janchaikiki— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodesin jaska waibu unankin ninkabiakin jatu jawa nemama jatundi Dios kenwankatsi ikamawen taexun jawaida Diosun nai tsuman Herodes kupikin isin tenemaya nami xenan kaianen pia mawanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Jaskashinken Diosun Mesías Cristo mekenankidi mae betsa betsapa tibi jiweabu anu jatu yuikubainaibun ninkakin ana ichapabun Jesús ikunwankubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","janua Antioquía anua ja pei jatu ichawaxuntan buxun Jerusalén anu Jesús ikunwainbu mekenikabu jatu inantan jadixundi jatubetan Jesúskidi jatu yusinkubainkin keyutan chintunkidankin Juan Marcos Antioquía anu iwei Bernabé inun Saulo bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía anuxun ikunwain ichaibu jabun jatu yusiainan, eska jayanibukiaki, Diosun jancha mextanmanikabu inun jabun kakape Jesúskidi jancha yusinananmisbu betsa betsapabudan. Jatun kenadan, Bernabé inun, Simón jawen kena betsa Meshupa inun, Cirene anua juni betsa Lucio inun, Galilea xanen ibu Herodesbe ewani Menahem inun, Saulo inibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Janua ana xaba betsatian jabu ichatan samakekin Dios kenwainbun Diosun Yushin Pepatun jatu yuikin: —Bernabé inun Saulo daya betsa ma en jatu kenani en jatu yunukatsis ikaya jau dayatanunbun medibi jatu nichinkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","januxun samakeyabi jau Diosun jatu mekekubainxanun jabun jatu yunuaibun yukaxuntan jau dayatanunbun medibi wakin mamepixun jatu nichianbu ");
INSERT INTO cbsNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","januxun Diosun Yushin Pepatun Bernabé inun Saulo Antioquía anua nichinkin yunua jatun medabewanika Juan Marcos iyui ianenwan maikidi kexa anu mae betsa Seleucia anu jikitan natukan ewapa jawen kena Chipre anu kakatsi pakatan niwe xaxu ewapawen inatan besusi pukei kai ");
INSERT INTO cbsNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","mae betsa Salamina bai butuatun keti itan janu jikishinxun janu judiobu ichamisbu tibi anuxun Diosun Mesías Cristo mekenankidi jatu yusin taewatan jatu yusinkubauni ");
INSERT INTO cbsNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","janua natukan mae tibi anu Bernabé inun Saulo uin bukubaini atimas ja natukan xanen ibun mae jawen kena Pafos anu jikiabu janu judio betsa jawen kena Barjesús, jawen griego kenadan, Elimas, juni mukayai chani chakai: “Diosun jancha yuixunika nikapai en jawen kushipayaki”, ikin jatu padanmis ");
INSERT INTO cbsNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","janu romano xanen ibu Sergio Paulobe ja juni mukaya ja dayaxunmis jiweken ja xanen ibu unanepa shinan pepayatun Bernabé inun Saulokidi kakaibu ninkatan Diosun kakape Jesúskidi jancha ninkakatsis ikin jau jatu ixuntanunbun yunua jatu iweabu bexun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","januxun jatu yuikin taewaibun romano xanen ibun Jesús ikunwain nemanun ika juni mukayatun Bernabé inun Saulokidi janchai daketapakin jatu ja akaya ");
INSERT INTO cbsNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","jakia Saulo, jawen kena betsa Pablo, Diosun Yushin Pepatun kushipayatun bedi ikama beisjaidakin ");
INSERT INTO cbsNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","juni mukaya yuikin: —Diablo Satanásan bakeen, padananain chani chakai dasibi pepaki min sinatamiski. ¿Jaskai Yavé Dioskidi chani chakai Dioskidi bai min nuku yuxtu wamakatsis ikai? ");
INSERT INTO cbsNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Min jaskaiwen taexun natian Yavé Diosun mia kupikin badi chaxa min uinyamanun mia bekunwanyuikiki— akaya jawaida meshun bepua jawa uianma janua: “¿Tsuan ea metsunbainimenkain?” iki meshan atanikiaki, ma bekunwanan. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jaskai uintan inun Jesúskidi yusiain pepa ma jatu ninkatan: “Jabaa!”, ikin romano xanen ibu Sergio Paulon Xanen Ibu Jesús ikunwanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Janua Pablo jawen jaibuaibube Pafos anua niwe xaxu ewapaki inabaini ianenwan besusi pukei mai pakea betsa Panfilia anu kai mae Perge anu keti iki kai buaibun januxun Juan Marcosin jatu jenebaini Jerusalén anu ana chintunkidanaya ");
INSERT INTO cbsNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","janua Perge mae anu niti ikama bui mai pakea betsa Pisidia kapukebaini maewan betsa Antioquía anu jikishinabun janua juindukunti sábadotian janu judiobu ichamisbu anu jikia jatube tsauabun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","januxun Moisin keneni inun Diosun jancha yuixunikabun kenenibu una anua yusinkin jatu yui menetan jabun yusinmisbu xanen ibubun Pablo inun Bernabé yuikin: —En betsabuun, ¿man jawa nuku yusintanun ika jushianmenkain? Yudabu benimawakin ikis nuku yuidikanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","janua Pablo benitan jau pesnunbun jawen meken sanantan jatu yuikin: —Israelbu inun dasibi nawabu jabu man Diosun kushipaki mesemisbuun, matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jabias Yavé Diosun nukun xenipabu katunixun jabiatundi Egipto anu jatu iwenixun nawabu keska jiwemakin jadixun jatu pajaidawa janu jiwekubainaibun januxun jawen kushipawendi nawabu nematan ja mai anua jatu tsekabidankin ");
INSERT INTO cbsNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","janu tsua jiweabuma anu jatu iweimaxun iake iakemakin 40 año nichinkin Dios bikawabiabu jawa jatu dananma jatu mekekubainikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Januxun mai pakea betsa Canaán anu 7 nawa xukua tibi jatu mebinmakin jatu yamawamatan ja mai nukun xenipabu ibuwani ");
INSERT INTO cbsNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ja jabu jaska wakubidankin 450 año nichiin bikanibukiaki. Jau jatu medabewayunun mekenikabu besti wakin Diosun jabu yunukubainmis jawen jenea Dios janchaxunika Samuelin jatu mekediaya ");
INSERT INTO cbsNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","januxun jabuan jau jatun mai jidabi mekenun juni jatun xanen ibujaidawanun ika Dios ea akaibun Benjamínen baba Quisin bake Saúl Diosun katuxun yunua xanen ibukin 40 año nichianyan ");
INSERT INTO cbsNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","januxun Saúlon Dios ana pe chibanmawen taexun ana Diosun medabewama jawen kushipa mebintan januxun Jesén bake David jau ja mai jidabi xanen ibunun, iwanan, kenwankin Diosun yuikin: “Davidin jaska en akatsi ikai akin ea benimawamistun en jancha chibankin jatun Israelbu pe mekekubainxanikiki”, jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jaska yubakanixun Davidin bababu anua betsan Israelbu dasibi jau jatu medabewakin jatun chakabu buaxuntan mekexanun— iwanan —yuini natian Diosun Jesús yunuyamaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Janua Jesúsun jatu yusindiamaken Nashimanika Juanen ja dukuntun jawen kaka pepakidi Israelbu jatu yusinkin yuikin: “Matun shinan betsa watan Dioskidi man chakabumis jenedikanwen. Man jaskaya en matu nashimaxanaii”, jatu wakubaini ");
INSERT INTO cbsNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ma jawen daya menei kauankin Juanen ana jatu yuikin: “Ja matun medabenan Diosun yunuxanai yuinibudan, ¿en, eamen man ea shinain? En jamaki. Jakia xanen ibu kushipajaidatun ea binuan chipu juxanikiki. Jaskawen taea eadan, jawen tsumapan jawen daya axunmis keska wakin en jawen jawaumajaidatun ean medabewakin en duawatidumaki, jawen bichi tae mexpun tsitauxun en pekaxuntidumadan”, jatu waniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abrahamnen bababu enabu inun dasibi nawabu man Diosun kushipaki datemisbuun, nukun chakabuwen taexun jau Diosun nuku kupiyamaxanun jawen bakekidi kakape nukunaki. Matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Juindukunti sábado tibitian janu ichamisbu anuxun Diosun jancha yuixunikabun kenenibu jatu yuimisbu inun jabuan jatu yuibiamisbun jawa tapianma Jerusalén anuabu inun jatun xanen ibubun shinankin jawa unanma Jesús jau tenanunbun, iwanan, dananibuki, jaska jawen jancha yuixunikabun bebunkidi yuini keska wakin menekinan. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Januxun jawawen taexun tenantidubumabia jaska watima jau tenanunbun romano xanen ibu Pilato yunuabu ");
INSERT INTO cbsNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pilaton jawen soldadobu yunua jaska bebunkidi jakidi kenenibu keska wakin cruzki mastaxun tenanbu januxun jawen yuda butetan buxun maiwanibuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jakia Jesús tenanshinabu Diosun ana jiwemakin bestenwanken ");
INSERT INTO cbsNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesús Galilea anua kaya Jerusalén anu jabe buimabu jatu uinmai xaba ichapa jawenchains Jesús jatuki nukukidankidanaiwen taea ma jiwea unantan jabuan natian Jesúskidi yudabu jatu yusinkubainkanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na jabias kaka pepa beshinxun nun matu yuiaidan, Diosun nukun xenipabu yubanidan, ");
INSERT INTO cbsNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nuku ma axuinmaki, nun jawen bababu anudan. Jaska bebunkidi jawen shinanmati wakin xanen ibujaida bena Diosun katua tibi jau xanen ibui taenun jawenabun yunua jawen tsauti anu ainikubainibuki. Jaska keskadi wakin Diosun jawen bake kayabi katua juni Salmos 2 anua yuiai keska wakin yuikin: “Min en bakedan, natian en jiwea mia inankin en mia yunuaii”, anidan, nuku ma axuinmaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Diosun ma bebunkidi yui chaniniwen taexun jawen yuda chaputimawakin ana bestenwaniki. Jaska bebunkidi jawen janchawen pewakin yuikin: “Jawa kaneama David en yubani keska chanima en matu waxanaii”. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jaska inun, Davidin Salmos kene betsa anudi man jaya yuikin: “Mai anua jau jawen yuda chapuyamanun min tsuma pepa bechipaijaidakin min jeneama ixanaii”, abiani ");
INSERT INTO cbsNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","chanima Diosun David yunua xanen ibukin jawenabu medabewakubaini atimas mawa maiwabu jawen xenipabuki nukutan jawen yuda beniama chapuni natian man unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jakia Jesús mawa Diosun bestenwantan jawen yuda ana jawa chaputimawaniki— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","—Enabuun, Moisin nuku kenexuniwen nukun chakabu buakin nukun shinan shadabu pewatidumaki. Jakia Jesúswen taexun Diosun jau matun chakabu matu buaxunxanun unankin ja chibankanwen. Januxun tsuabunda Jesús jabun ikunwainbu Diosun jatun chakabu buaxunkin jatu pepawakin keyuxanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jaska Diosun jancha yuixunikabun kenenibu keskai ibubis matun chakabuwen man Dios kupimatiduki. Uindakanwen, jaska kenenibu keska wakin: ");
INSERT INTO cbsNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Matunan, uindakanwen. Diosun atimaska betsa betsapa akubainikidi matuki chanibiaibun ninkabiakin danain Dioski kaxei xechakakin man ikunwankatsi ikamaki’, atan nuku kenexunibuki— jatu watan ");
INSERT INTO cbsNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","janua janu judiobu ichamisbu jiwe anuxun jatu jancha menetan Pablo inun Bernabé jatube kainbainaibun Pablon jancha ana ninkakatsis ikin yudabun yukakin: “Juindukunti sábado betsatian janu nun ichamis anuxun jabiaskadi nuku ana yusinxanwen”, akaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","januxun judiobu ichapabu inun nawabun judiobun beya chibanmis ichapabundi Jesúskidi kakape jancha ikunwankin Pablo inun Bernabé ninkakubainaibu chintuanma jau pepawen Dios benimawakubainxanunbun jatu yusinibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Janua ana sábado betsatian Jesúskidi kaka pepa jancha ninkanun ika ja maewan anua keyu bebiai jatidi niti ikabun jabu beabun kakape nukun Xanen Ibukidi ninkaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","janua judio xanen ibubun jaskaibu uinkatsi ikama Pablon jatu jaska wai bechipaiama jaki sinatakin ja ichabu xabakabi jatu ja akin: “Chani chakakin matu padainkiki”, ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","janua Pablo inun Bernabé jawa dateama dasibibun ninkaibun judio xanen ibubu jaskaibu jatu kemakin: —Diosun kakape jawen bakekidi man judiobu dukun nun matu yusin taewanun Diosun nuku yunukin nichinbiaimaken nun matu yusiain nukun yusian danankin jawen pepai jiweibi jiweti man bikakatsi ikabumaki. Man jaskaya matu jenebain nawabu judiobuma anu nun jatu yusin kaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Jamen bebunkidi nukukidi Yavé Diosun Isaías janchamakin yuini ninkakanwen: ‘Nawa betsa betsapa chaijaida jiweakeakeabu jaskai jiwekuintidubu min jatu yusinkubaunxanun mia yunukin en mia bin keska waii, jau min jancha xabakabi mai jidabi anuxun ninkaxanunbunan’, akaya Isaíasin ninkatan nuku kenexuniki— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","januxun jatu jaska wai ninkatan judiobuman ninkai shinan chankain benimakin yuikin: —Diosun kakape pejaidaki— ikaibu dasibi jabu Diosun katuxun jiwekuian jatu inanxanai jabuan Jesús ikunwanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jaskabiaibun Diosun jancha nukun Xanen Ibukidi ja mai pakea anu nati ikin jatu yusinkubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pablo inun Bernabén jancha judio xanen ibubun danankin jau jatu nichinunbun, iwanan, ainbuaibu pepa inun juni xanen ibubu jatunabubetan chani chakakin jatu sinatamatan januxun Pablo inun Bernabé jatun mai pakea anua jatu putamaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","jatu jaska wabu Pablo inun Bernabén jau jawa unanma jabiaskasi jiwekubainxanunbun jatu unanti wakin Antioquía anuabuki jatun bichi tae pekatan jatuki mai mishpu tabaini mae betsa jawen kena Iconio anu bunibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jakia jabun Jesús ikunwainbu Antioquía anuabu Diosun Yushin Pepatun jatu medabewaya benimajaidakubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio anu Pablo inun Bernabé bushian janu judiobu ichamisbu anu jatube jikitan Jesús mekenan bestikidi xabakabi jaska ninkaisbuma jatu pe yusinkin mextanmaibun judiobu ichapabu inun judiobuma ichapabundi ninkakin ikunwainbun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","januxun ja judio betsabun jatun jancha danankin nawabuki chani chakakin Jesús ikunwainbuki shinan chakakin jatukidi chakabu yuibaunaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","jatu jaska wabiabu Jesúsun kushipayabu Pablo inun Bernabé jabube xaba ichapa jiweyuxun nukun Xanen Ibuki chiti itan jawa dateama Jesúskidi chani chakama jawen janchawen jatu axunkin jaska Dios nuikipakidi chanikin jatu unanmaya, januxun Diosun jatu medabewakin kushipa wakin dami atimaska betsa betsapa jatu axunkin uinmaya ");
INSERT INTO cbsNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iconio anu jiweabu yudabu paxkatan jatiditun judiobun jancha ninkakin Jesúsun kushipayabu Pablo inun Bernabé danainbun betsabu jatiditundi jabun jatu ninkakin ikunwainbun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","janua nawabu inun judiobu mae xanen ibubube jatube yubakatan nuitapawakin ichakawakin mankanwen jatu tsakanun ikaibu ");
INSERT INTO cbsNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","januxun Pablo inun Bernabén banabitan paxai mae Listra inun Derbe inun mae betsa betsapa Licaonia mai pakea anu buxun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","jadixundi Diosun jancha kakape jawen bake Jesúskidi jatu yusindiaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ja mae Listra anu juni betsa tae dabe chakabu jabiaska kaini jawa jaska nisma tsauxun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablon yusiain ninkajaidaya: “Ja junin ikunwanyan en kaya watiduki”, ikin jawen shinan uinjaidatan ");
INSERT INTO cbsNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pablon jui kushipawen yuikin: —Ja min tae min jabiaska kainidan, benidiwe— aka ja juni daxka iki ishchutan ti itan nikaunaya ");
INSERT INTO cbsNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","yudan kaianen Pablon jaska wai uinkin kenwain jatun Licaonia jancha kushipawen yuinamei: —Nai anua na yushin dabe junikidan nuku anu damitan butushinabuki. Pejaidaki— ikin ");
INSERT INTO cbsNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé metukin yuikin: —Jadan, nukun mekenika yushin Zeuski— akin Pablo metudiakin: —Ja jatun nuku jancha waidan, nukun mekenika yushin Hermeski— akaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ja Zeusbe jawenabu janchaxunikatun jawen kenwanti jiwe mae jikiti anua ina awa bene dabe juawen dauwabu bexun jawenabubetan Pablo inun Bernabé ja yushin dabe kenwankin benimawanun, iwanan, detetan kuakin jawen kenwanun ikaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","jaska waxunaibu uinkin tapintan ja Jesúsun kushipaya dabetan yudabu jatu kenwanmakatsi ikama jatun tadi ushnitan yudabu nashui ikain nemakin jui kushipawen griegon janchawen jatu yuikin: ");
INSERT INTO cbsNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Junibuun, ¿jawakin man nuku jaska wai? Nuku jaska wayamakanwen. Nukudan, matu keskadi nun jabias juniki. Ja yushin dabe man kenwanmistun matu jawa waxuntidumaki. Jaskawen taexun man kenwanmis jenetan Dios jiweatun nai inun, mai jidabi inun, ianenwan dasibi inun, janu jiweabu dasibi damiwani matun shinan betsa watan man kenwankubainxanunbun jakidi jawen bakekidi kakape matu yusintanun ika nun jushianki. ");
INSERT INTO cbsNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","U unu badi betsatian mai jidabi anu yuda betsa betsapabun jatun shinanens jawada chibankubainaibu Diosun jatu beduwens uinyukubainbiakin ");
INSERT INTO cbsNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","jawa matu jeneama jaska pepawamiswen xabakabi naiudia ui matu imaxunkin miban man banaima matu pe benemaxunkin man piaibu matu yaniwamakin betsa betsapawen matu benimawakubainmiski. Jaskawen taexun Dios jiwea besti kenwankubainkanwen— iwanan, ");
INSERT INTO cbsNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","jatu jaska wabia ninkamas ina awa bene detexun yushin dabe benimawati kuaxunyupananbun betsa betsa wakin jatu bexteaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ja jatu jaska waibun judiobu Antioquía anua inun Iconio anuabu bexun Pablo inun Bernabékidi chani chakakin yudabu padankin jatu shinan betsa wamatan jatu itimaska wamabaunkin Pablo besti bechixun mankanwen tsaka tsaka akabu Pablo di ikaya: “Ma mawaki”, ixun chaka udenmisbu anu xadabain udentanabu dakaken ");
INSERT INTO cbsNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","janua ikunwainbu ichaxun Pablo kebaunxun uiainbun Pablo bestein benitan june ja mae anu jikia jabianu uxashini janua bestentan Bernabébe mae betsa Derbe anu kaxun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","jadixundi Diosun jancha jawen bakekidi kakape jatu yusian januxun Derbe anuxun jatun jancha bechipaikin ichapabun ninkakin ikunwainbun jadia chintunkidani Listra inun, Iconio inun, Antioquía anu bekubidankin ");
INSERT INTO cbsNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","mae tibi anuxun jau jabun jatu yusinxanunbun ikunwainbu yusinkin jatu mestenwankin yuikin: —Eskaki, ninkakanwen. Dios xanen ibuaiki nun dasixanaibu nuku ichakawakubainxankanikiki. Jabiaskaki. Jabiaskabiaken jawa datei chintuanma Jesús ikunwanpakexankanwen— akin menetan ");
INSERT INTO cbsNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","janu ikunwainbu ichamisbu tibi anua mekenikabu jatu katutan jatube samakekin Dios dayuikin jabun Jesús ikunwainbu jau nukun Xanen Ibu Jesúsun jatu medabewakubainxanun Pablo inun Bernabén kushipa jatu yukaxunkubidanibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Janua bei mai pakea betsa Pisidia kapukebidani mai pakea betsa Panfilia anu jikishinxun ");
INSERT INTO cbsNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","januxun mae betsa Perge anuxun Jesúskidi kakape jatu yusintan janua mae betsa Atalía anu jikishina ");
INSERT INTO cbsNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","janua Antioquía anuxun jau yusintanunbun Dios jatuwen nuiai anu jadi jatu yunuimabu anu bukubaunkin Jesúskidi jatu yusinkubauntani menebidani janua niwe xaxuki nanetan Antioquía anu chintunbidani ");
INSERT INTO cbsNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","keti itan mapekeshinabun januxundi Jesús ikunwainbube ichaxun bukubauni jaskatanshinabu inun jabu judiobuman jau jabundi Jesús ikunwanunbun natian Diosun jatu kenaya xabakabi jaska jatu yusinkubauntanshinabu dasibi jatuki chanitan ");
INSERT INTO cbsNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","jabianu jatube bashikuyuima Pablo inun Bernabé uxe ichapa ikunwainbu jatu yusiin jiweyuaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","jabiatiandi jabun Jesús ikunwain judiobu betsa Moisin yusian chibankin bechipaijaidamisbu Judea anua Antioquía anu bushinxun Jesús ikunwainbu jabundi jatu yusinkin: “Judiobuman tsuabunda man nukubetan Jesús ikunwainbudan, Moisin nuku yununi beya jabun jina kubichi biabumadan, Diosun jatu meketidumaki”, iki jatukidi janchaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","januxun Pablo inun Bernabén jaska jatu yusiainbu danain jatube yuinamei ja ichakayamai itimaskaibun jaska bechipaiama atimas ikunwainbu ichatan Pablo inun Bernabé inun ikunwain betsabu katuxun jau jaska yusian jusiaibu pewakin Jesúsun kushipaya betsabu inun mekenikabu Jerusalén anuabubetan pewai jau jatube janchatanunbun jatu yunukin ");
INSERT INTO cbsNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","nichianbu bui Fenicia mai pakea inun Samaria mai pakeakidi bukin judiobuman jaska jatun shinan chakabu jenetan Jesús chibanshinabukidi jatuki chanikubainaibun mae tibi anuxun ikunwainbun jaska washinabukidi jabun kaka ninkai benima chakayamakubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","janua Pablo inun Bernabé inun jatube buaibu Jerusalén anu jikiabu Jesúsun kushipayabu inun, mekenikabu inun, dasibi Jesús ikunwainbu betsabun jatu i pewatan jatube ichabu Diosun jatu medabewaya judiobuma Jesúskidi jatu yusianyan jabundi ikunwankubainshinabukidi Pablo inun Bernabébe jatuki chaniaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","jatu jaska yuiaibun judio xuku betsa fariseobun Moisin jancha chibanjaidabiamisbun ma jatidibun Jesús ikunwankin chibainbu betsa benikauan jatu yuikin: —Man jaskakidi jatu yuiaidan, nawabu Jesús man jatu ikunwanmaibudan, jaska Diosun Abraham yununi keska jau jatun jina kubichi binunbun jatu yunukanwen. Ja inun, Moisin nukun xenipabu yununi beya jau chibandianunbun jatu yunudiakubainkanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","jaskai ninkatan ja beyakidi jatu jusimapaiabu ja unanepabu Jesúsun kushipayabu inun mekenikabu besti pewanun ika ana ichatan ");
INSERT INTO cbsNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","jaikaimas shinan betsa betsapaibu Simón Pedron jatu ninka keyutan atimas jadi benitan jatu yuikin: —En betsabu inun en puibuun, Diosun kakape jawen bake Jesúskidi judiobumandi jau ikunwanunbun matu anua Diosun ea katuxun ea yunuxun ea jatu yusinmayama man unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ja romano xanen ibu Cornelion jiwe anuxun en jatu yusianyan jabun Jesús ikunwainbu Diosun dasibi nukun shinan unanmistun ja judiobumadi jawenabu wakin ikunwanmakin nuku keskadi wakin kushipa wakin jawen Yushin Pepa jatu inankin jatu achimayamaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nukunan, nun Jesús ikunwainbu Diosun nukun juinti pepawamis keska wakin jabundi Jesús ikunwainbu Diosun jawa jatu dananma jawa nuku paxkakin betsa wama jabiaskas shinan jatube nuku waikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jaskawen taexun ja Moisin nukun xenipabu yusini beya jabun chibantiduma ipaunibuki. Jabiaskadi nun Israelbun nun chibantidubumadiki. ¿Jaskakin Diosun jatu jaska wamabiaken matu Dios keskakin judiobuman Jesús ikunwainbu man jatu yunuai? Jatu jaska wayamakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Natian nuku inun jabukidi shinananankanwen. Nukubun nun ikunwain mekea jayadan, jawama jamenjaida nun ikanaii. Jaska keskadi wakin jabu judiobumadi jabias nun ikai keskadi wakin nukun Xanen Ibu Jesúsun jabu duawaikiki, jawen pepawenan— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","janua dasibibun jaska ninkai pes nesei keyutan ana jawa yui janchabumaken januxun Bernabé inun Pablo Diosun jatu medabewaya judiobuma anuxun dami atimaska betsa betsapa jatu uinmakubainimakidi jatu yuikin ");
INSERT INTO cbsNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","meneaya Jesúsun betsa Santiagon ichabu jantsidi jatu yuikin: —En betsabu inun en puibuun, eandi matu yuinun ninkakanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jesús ikunwainbu Diosun jawenabu jatu wadiakin medabewani jau nukube ikubainxanunbun jaska bebunkidi tatesmakin Diosun judiobumadi katuyama Simónen ma nuku yuixuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eanan, jabiaskadi bebunkidi Diosun jancha yuixunikabun kenenibu en jaska shinaiin, Diosun jancha jaska yuiaidan: ");
INSERT INTO cbsNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Israelbu kupitan ana juxun David xanen ibu ini keska wakin jawen baba betsa medabewakin kushipa wakin ja jiwe di ini keskabu en ana jatu benixanaii. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","En jatu jaska waya nawa xukuabu tibibu inun tsuabunda en Yavé Diosun kenayabun ea yukai jabun ea benatidubuki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Jaska bebunkidijaida en Yavé Dios janchakin jatu yubaidan, chanima en jatu axununbadiaii’, ikai ninkatan nuku kenexuniki— iwanan ");
INSERT INTO cbsNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","—Jaskawen taexun nun shinanunbun matu yuinun ninkakanwen. Judiobuman jatun shinan chakabu jenetan Jesús ikunwankin Dios chibainbu jaska nun judiobu nukun beya chibain nun jiwemis yunukin jatu bikawayamanankanwen. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","Jakia badi ichapa ma jadi judiobu judiobuman mae tibi anuxun juindukunti tibitian jaska Moisin jatu kenexuni jatu yusin jatube beyamisbuwen taexun jau judiobuman judiobu jawaida jau bedabin dabeyamanunbun na besti nemakin jatu kenexunankanwen, eska besti jatu bextekinan. Yushin dami betsa kenwankin nami inanmisbu jau piyamanunbun inun, jabu ainyankinan, jaska Moisin jatu nemani jau chibanunbun inun, yuinaka tenexabu mawa jau piyamanun inun, yuinaka jimi jau ayamanunbun jaska besti jatu nemakin kenexun judiobuma dasibi anu bumanankanwen— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","januxun Jesúsun kushipayabu inun mekenikabu inun ikunwain dasibibun Santiagon jancha ninkakin bechipaitan Antioquía anu Pablo inun Bernabébe jau butanunbun jabubetan ikunwainbu anua juni dabe unanepa Judas jawen kena betsa Barsabás inun Silas katutan ");
INSERT INTO cbsNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","jatu bumakatsi jatu kenexunkin: “Nun Jesúsun kushipayabu inun mekenikabu nun matubetan ikunwainbunan, nun matu kene bumai uinkin ninkaxankanwen. Judiobuma man Antioquía maewan anu jiweabu inun, Siria inun, Cilicia mai pakea anu jiweabun nukubetan Jesús man ikunwainbu nun matu shinaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jaskaken nenuadi nukunabu nun jatu yunuamabia buimaxun jatun beyakidi matu yusinkin matu itimaska waibu nun ninkashinaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jaskawen taexun nukun nun matu medabewanun ixun jabias shinan ichawatan nukubun nun shinan peken jau jabundi jaskakidi matu medabewaxanunbun ixun nuku anuadi juni dabe katutan nukun jaibu Bernabé inun Pablobe nun jabube nichiaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nukun jaibu Bernabé inun Pablon jatun jiwea yaushiama bikajaida mesebiaken nukun Xanen Ibu Jesucristo dayaxunkin yusinkubainmis man unaiin. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jabu nun matu anu yunuai jaska nun matukidi shinain Judas inun Silas jikitan matu xabakabi yusin pewaxankanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Jakia jaska man judiobumandi Jesús ikunwain unanuma man jiwenunbun Diosun Yushin Pepatun nuku shinanmaya ana nukun beyakidi jawa betsa matu yunuama na besti nun matu nemai ninkakanwen, man judiobube bedabinandabeyamanunbunan. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yushin dami betsa kenwankin nami inanmisbu ana piyamakubainxankanwen. Ja inun, yuinaka tenexabu piyamadiaxankanwen. Ja inun, yuinaka jimi ayamadiaxankanwen. Ja inun, ainyankinan, jaska Moisin nuku nemani ja chibandiakubainxankanwen. Jaska besti man mekeadan, jawa chakabuma man pe besti jiwexankanaii. Jau Diosun matu pe mekekubainunwen”, jatu waxuntan ");
INSERT INTO cbsNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","jabu butanunbun keneya jatu nichinkin yunu pewabu Antioquía anu jikishinxun ikunwainbu ichawaxun kene jatu inanbu ");
INSERT INTO cbsNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","januxun ikunwainbun ja kene bitan yuii jatuwen nuikin jatu daewaibu ninkai benimaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jesúsun kushipayakin Judas inun Silasin Diosun jancha pe jatu mextamamiswen taexun ikunwainbu jatu medabewakin jatu benimawaya ikunwainbun jabun jancha bechipaijaidaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","januxun jau jatu yusinyununbun uxe ichapama bashimaxun ma buaibun ja jabun jatu yunuimabu anu jabu jiwei peabu jau jatu yuitanunbun, iwanan, unanuma jau butanunbun jatu nichian buaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","janua Pablo inun Bernabé Antioquía anua ana kama niti iki bashikuyuimaxun ikunwainbu betsabubetan kakape Jesúskidi yudan kaian jatu yusinpakekubainibukiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Janua Antioquía anu uxa ichapa Pablo jiweyukin Bernabéki chanikin: —Janu Jesúskidi nun yusinkubauntanima anu ikunwainbu jaskadamenkain ana jatu uinkubainanwen— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabén kemakin: —Kakinan, ¿Juan Marcos nun ana iyutidumen?— aka ");
INSERT INTO cbsNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","bebunkidi jatubetan yusin ka Panfilia anuxun jatu xunubidankin jenebidanimawen taexun Pablon ana iyukatsi ikamaken ");
INSERT INTO cbsNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","janua jawen taea iyunun ika jabe kunyan idabetan paxkai jenenamedabetan Bernabén Marcos iyui Chipre anu niwe xaxuwen inatan kaya ");
INSERT INTO cbsNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","jaska wabainaya Pablon jawena medibis shinantan Silas iyukatsis ikin katutan ikunwainbuki chaniaya jabun yuikin: —Man jaska kainaidan, peki. Man jatu yusin kaya nukun Xanen Ibu matuwen nuikin jau matu medabewakubainunwen— akin jatu nichinkin yunuabu janua kainbaini main bui ");
INSERT INTO cbsNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria inun Cilicia mai pakea kapukekubainkin Jesús ikunwainbu ichati jiwe tibi anuxun jatu yusinkin jatu benimawakubauni kai ");
INSERT INTO cbsNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","janua Pablo inun Silas kakunkainkin Derbe inun Listra ja mae dabe anu yusin Listra anua Jesús ikunwain betsa jawen kena Timoteoki nukunibukiaki. Jawen ewa judio ainbun Jesús ikunwanyan jawen epa griegonawan Jesús ikunwanmaken ");
INSERT INTO cbsNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","janua ikunwainbu Listra inun Iconio anuxun Timoteon Jesús ikunwain pe jiwekunkainmiskidi chaniaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablon ninkatan jau ea medabewai ebe kanun, ixun jawen epa judiomabiaken jawen ewa judiowen taexun jau judiobun Timoteo dananyamaxanunbun jawen bedabintidubuken jatun beya chibankin jawen jina kubichi Pablon jatu mextemanikiaki. ");
INSERT INTO cbsNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Janua bukubainkin judiobu inun judiobuman Jesús ikunwainbu mae tibi anua jau jatun beyakidi yusiin bikanameyamakubainunbun Jesúsun kushipayabu inun mekenikabu Jerusalén anuxun jatu nemakin kenexunimabu jatu yusiin chanikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","janua ikunwainbun jaska ninkatan jatun shinan pewakin mestenwankubainaibun yuda betsabundi Jesús ikunwain xaba tibi ana ichapabu jatuki dasikubainaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","mai pakea betsa Asia anu Pablo inun, Silas inun, Timoteo Jesúskidi jatu yusin jadi bunun ikaibun Diosun Yushin Pepatun jatu nemaya mai pakea dabe Frigia inun Galacia anuabu jatu yusiin kapukebauni ");
INSERT INTO cbsNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","mai pakea betsa Misia kemai Bitinia mai pakea betsa anu jikinun ixun shinanyan Jesúsun Yushinin jatu ana nemaken ");
INSERT INTO cbsNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","janua Misia kapukei bai chai tanabaini mae betsa ianenwan kexa anu bei butubidani Tróade anu jikiabun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","jabianudi en Lucas en jatuki nukuken meshu medan Pablo uxa namaya juni betsa Macedonia anua damia nixun Pablo yuikin: “Macedonia anudi juxun nuku medabewayuwe”, ikai ");
INSERT INTO cbsNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ninkatan bestenxun ja namapan uinxu nuku yuiaya Macedonia anuxun Jesúskidi kakape nun jatu yusin kanun Diosun nuku yunuai unantan nukun mabu pewashintan ");
INSERT INTO cbsNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","janua Tróade anua penaya niwe xaxu ibu peiwen pakatan nanekaini natukan jawen kena Samotracia anu kayanbis kai pukei janu keti itan janu uxashini ana bestenkaini meshukidi jabias xaxuwendi pukei mai pakea betsa Macedonia anu mae betsa Neápolis anu jiki keti itan ");
INSERT INTO cbsNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","janua mananan mapekekaini romano mae ewapa mae tibi binua chaima Filipos anu nun jikishina jawa wadiama janu uxa eskadabestan ");
INSERT INTO cbsNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","janu judiobu ichamisbu jiwe jayamaken sábado juindukuntitian mae anua kainkaini jene kexaxun Dios kenwankin januxun Dios kushipa yukamisbu anu kai ainbus ichamisbuki nukutushitan jatube tsauxun Diosun Katua Jesús mekenankidi nun jatu yusinkin taewaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ja ainbuaibu icha betsan Dios kenwanmis jawen kena Lidia mae betsa Tiatira anua junixun tadi pepa bixun tashi jushinipa wamis nukun Xanen Ibun medabewakin ninka pewamakin jawen shinan betsa wamaya Pablon janchawen Jesús Lidian ikunwanyan ");
INSERT INTO cbsNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","januxun jabubetan jawen jiwetanxun ikunwainbuwen taexun unantan nun jatu nashimakin keyua Lidian nuku yuikin: —Chanima nukun Xanen Ibu Jesús en ikunwain man ea shinainan, en jiwe anu iyui bekanwen— akin nuku ea akin ana nuku ena wanun ikaya —Peki— itan jadi ka nun jabe jiweyuniki. ");
INSERT INTO cbsNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Janua xaba betsatian janu Diosbe janchamisbu anu ana Diosbe janchanun ika nun kaya chipash yushinin bebunkidi unanmamisken ja chipash juni betsabun tsumapan jatu unanxunkin jawen tsumabu pei midima jatu bixunmisken chaima jaki nukutan nun dainbainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","nuku chibanbainkin metubainkin mapuabu dasibi unanxubima jui kushipawen jatu yuikin: —Ja junibudan, Dios kushipa dasibi binua jawen tsumabun ja dayaxunkanikiki. Janu kupiaitian tsuanda matu nemaxuntidu jawen chanima paxati bai matu unanmakanikiki— akin ");
INSERT INTO cbsNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","xaba tibi jawenchains bestikima nukukidi yui janchakunkainaya Pablon jaska ninkai ma bika tenexun dabeketan ja chipashki yushin jikini yuikin: —Jesucriston kushipawen en mia yunuai ja chipash anua kaindiwe— aka jaska was ja yushinin jawaida jenebainaya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ana ja chipash yushinyankin pei ana jatu bixuntiduma jawen tsumabun ana jawawen jaskatima unantan Pablo inun Silaski sinatakin achibainkin jatun mae namakis jemaintin anu jatun xanen ibubu bebun iyukin xadabain ");
INSERT INTO cbsNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","januxun xanen ibu yununikabun besuudi jatu nichintan yuikin: —Na judiobunan, nukun mae anuxun yusinkin jadakidi shinantimawakin dasibibu nuku itimaska wakanikiki. ");
INSERT INTO cbsNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Jatun beya jaska jiwemisbu nuku yusiainbu nun romanobun nun chibanbaintidubumaki, jaska nuku yusinun ika ikaibudan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","januxun yudan kaian mapubaunabundi jaska ninkai sinatai jabundi jatu chiteaibun jatukidi jaskaibuwen taexun jatun xanen ibu yununikabun jau jatun tadi pekatan ji sidiwen jau jatu kusha kusha anunbun jatu yunuabu ");
INSERT INTO cbsNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","jabun jatu kusha kusha achakayamatan bichiti jiwe anu jatu bichimatan mekenikatun uin pewakin jau mekejaidanun yunubidanabu ");
INSERT INTO cbsNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ninkatan ana dintu uke medanjaida Pablo inun Silas mistuxun jau jaska paxayamanunbun ji xui dabeyawen jatun tae bitaux adabetan mekeken ");
INSERT INTO cbsNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ja jaska wabu jabias meshu yamenapun Dios dayuikin Pablo inun Silasin jawen kenwanti Dioskidi nawaibun ja jabu dukun jatu bichimabun jatu ninkaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","jaskabiama e iskaun jawaida pacha sakui mishki bichiti jiwe wanibu takax takax akaya ja jaska waya beputi tibi jamebi bepenmanai keyuaya juni tibi mane dispiwen menexekeabu jamebi chudekei nidi iki keyuaya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","janua mekenika bestenkauan beputi tibi ma bepenmana uintan shinain: “E jee! Min jaskati kemain. Dasibi ma kainbaini paxabubin! Ibubisbin en mawai!”, itan jawen nupe chaipa sitan ibubis tenukuyupanan ");
INSERT INTO cbsNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","jawaida Pablon jui kushipawen yuikin: —Mimebi ibubis chakabuyamawe. Nuku dasibi nun jani kamaki— ikaya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","januxun jawen tsumabu bin yukatan Pablo inun Silaski datei saki saki iki kushikain kenwain jatu naman danti itan ");
INSERT INTO cbsNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","januxun kainmatan jatu yukakin: —Xanen ibubuun, janu kupiaitian en Dios daewakatsis ikaii. ¿Jaskapa, jau ea mekexanunan?— jatu wa ");
INSERT INTO cbsNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","januxun jabun kemakin: —Xanen Ibu Jesús ikunwanwen. Mia inun min jiwe anu mibe jiweabubetans man jaska waya Diosun matu mekekubainxanikiki, kupiamadan— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","jawaida bichiti jiwe mekenika inun dasibi jabe jiweabu nukun Xanen Ibu mekenankidi jatu yusiain ");
INSERT INTO cbsNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ninkatan meshubiaken jatu kushshinabu su ika jene jabaibu jawaida unpaxwen jatu chukatan januxun jabe jiweabubetans Jesús mekenan ikunwankanxuwen taexun Pablo inun Silasin jatu nashimabu ");
INSERT INTO cbsNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","janua jabe jiweabubetan Dios ikunwanbaini benimajaidabainkin jatun jiwe anu jatu iyuxun jatu pimashinaibun ");
INSERT INTO cbsNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","janua penaya xanen ibu yununikabun jatun tsumabu jatu jancha bumakin yuikin: —Ja juni dabe achiabu man jatu bichishinabudan, ana jatu jawa wama jau kainunbun yuitankanwen— akabu buxun bichiti jiwe mekenika yuiabu ");
INSERT INTO cbsNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","januxun Pablo yuikin: —En matu jawa wama kainmanun xanen ibubun ea yunukanxukiaki. Jaskaken unanuma budikanwen— jatu waya ");
INSERT INTO cbsNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","jakia Pablo kaintan xa