﻿USE sofia;
DROP TABLE IF EXISTS sofia.cbiNTpo_vpl;
CREATE TABLE cbiNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cbiNTpo_vpl WRITE;
INSERT INTO cbiNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Naa tiba jutyunu uwanun, Dios tiba deke' faawaandu, selu bain, tu bain dekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tsenñu tu naa ti muuteba jutyu', tsaa juwan juruu ju' yapijurunami, tsenmin lamaa tene ne juuwaami. Tsanandala Diosa' Espírituya pi kai'tala ne neintsumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tsenñu Dios: Danguisa, tinmalan, dandakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Tsangue' dangueñu Dios yuj urañu katatu, dishkejtsa bain, danda bain junuu tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tsejtu Dios dandanuya “mandala” mumu pumi, tsenmin dishkejtsanuya “kepe” mumu pumi. Tsanguiñu juntsa ajke' malunu kepe bain, mandala bain tiya' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Bene Dios manen tsandimi: Pitalan manbela aa ba'kara jusa, tsenmalaa pi maali maali develanutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tsanditu Dios manbela tsamantsa aa ba'kara kemi, tsenñu juntsa aa ba'kara pi develekemi. Tsenñu manbaateya juntsa aa ba'kara pandainsha shuwanmala, kamanbaateya kai'sha deshuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tsenñu juntsa aa ba'karanu “selu” mumu pumi. Tsanguiñu entsaba pai malunu kepe bain, mandala bain tiya' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Tsenñu Dios tsandimi: Selu pandainsha pumu piya manbelaa wakudisa, tsenmalaa ejke tena faanutsu, timi. Tsandiñu ya naati pañuba juntsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tsejtu Dios ejke tenanuya “tu” mumu pumi, tsenmin selu pandainsha wa'dimu pinuya “lamaa” mumu pumi. Tsejtu kumuinchi ura deeñu katatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dios tsandimi: Tunu ti kiya'baasa de-awasa: naa fikenuu ñi iimu chi juula bain, naa pu'chi juula bain, timi. Tsandiñu Dios naatiñuba juntsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tsenñu tunu naa ti kiya juula bain awala, naa fikenuu ñi kuwakemu chi juula bain, naa pu'chi juula bain awala. Tsanguetu Dios juntsa ura deeñu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tsanguiñu entsaba pen malunu kepe bain, mandala bain tiya' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Tsenñu Dios tsandimi: Selusha ñillu cha'jelei detiyasa tsai' tusha dangaapunu, tsenmalaa mandala bain tiya', kepe bain tiya tiyainutsu, tsenmin selusha chumu ñillu jumulan naamaa ma malu tiyañu bain, naamaa ma añu tiyañu bain, naamaa bale malu chayañu bain mijakaanu detsuve, timi. Tsandiñu Dios naatiñu bain juntsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tsejtu Dios pai ñillu kemi: mandala dangaamu ñillunuya daran danmu kemi, tsenmala kepe dangaanu ñillunuya mikaka danguikemu kemi. Tsenmin naa makara juula bain dekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Tsejtu Dios juntsa ñillulanu selu kai'sha deke' chujtimi, tsenmalaa naa mandala bain, naa kepe bain tusha danbu', naa kepe bain jayu ñillu jusa tyatu, tsenmin mandala bain danbusa tyatu. Tsanguetu Dios juntsa ura deeñu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Tsanguiñu entsaba taapai malunu kepe bain, mandala bain tiya' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Tsejtu bene Dios tsandimi: Pisha pumu animaala bain pure' tiya deisa, tsenmin naa tusha jeke' nemu pishkula bain dejusa tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Entsanguitaa Dios pisha pumu aa alla bain dekemi, tsenmin pi tainsha nemu animaala bain naaju'baasa deke', naa pishkula bain naaju'baasa dekemi. Entsangue' dya' Dios ura deeñu katatu, juntsa animaalanu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","mika ura' idei titu entsandimi: Pure' na kike' lamaa tyuwakidei; tsenmin naa tusha bain pishku pure' seraidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tsanguiñu entsaba man malunu kepe bain, mandala bain tiya' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Tsejtu Dios manen tsandimi: Tu kuraa animaa de-awasa tenve, naa chachilla' miyandinu animaa juula bain, naa jeenbaasha chumu ajara animaa juula bain, tsenmin naa tunu ajkachi shilla' neimu animaa juula bain de-awasa tenve, timi. Tsandiñu Dios naatiñuba juntsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tsejtu Dios entsa animaalanu naaju'baasa deketu, ura deeñu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tsejtu umaa Dios tsandimi: Umaya lala naadejuñuba tsaa chachi ke' kujtedaa, tsenmalaa ya naa pisha pumu allalanu bain, naa pishkulanu bain, naa chachi miyandinuu animaalanu bain, naa jeenbaasha chumu ajara animaalanu bain, naa tutala shilla' neimu animaalanu bain mandanguen chunutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tsejtu Dios, ya naaju'ba juntsa keraa chachi ke' kujtemi. Tsejtu unbee ruku bain, supu bain kikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tsejtu Dios yalanu: Mika ura' idei, titu tsandimi: Na demiyandi' pure' serai' entsa tu tyuwai seradei, tsenmin naa pisha pumu allalanu bain, naa pishkulanu bain, naa naaju animaalanu bain, naa tusha ajkachi shilla' neimu animaalanu bain ñulla mandanguen chudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Tsejtu bene yalanu tsandimi: Ñi fainuu iimu kaa chi juula bain, kayu naa vee pu'chi juula bain iya ñullanu kuwantsuyu, tsenmalaa ñulla pu'chitala puka ka' finudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tsaaren jeenbaasha chumu animaalanu bain, tusha ajkachi shilla' neimu animaalanu bain, naa pishkulanu bain naaju tape'baasa yaichi fikenuu detiwaayu, timi. Tsandiñu uwain juntsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tsejtu Dios kumuinchi entsangue deketu ura deeñu katami. Tsanguiñu entsaba mandishmain malunu kepe bain, mandala bain tiya' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Entsaitaa naa selu bain, naa tu bain, tsenmin naa selusha tiba katawamula bain, naa tusha tiba katawamula bain millai ila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dios entsangue taawasha deke' dyatu, umaa mandishpai malusha lekami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tsejtu Dios entsa mandishpai malunu mika ura' isa titu, bale malu kure' shuikemi, matyu juntsa malunaa tiba deke' faawaatu leka' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Entsa kuindaa, naa-itaa selu bain, naa tu bain de-i' faamu deeñuba juntsa kuindave. Yavé Dios naa selu bain, naa tu bain dekiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","kayu naa ti kiya juuba chutyumi, tsenmin naa ti tape juu bain kayu falendyumi, matyu Yavé Dios kayu shuwa jakaakaindyuñu' mitya, tsenmin muba taawasha kikenuu dejutyuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tsaanun tu tainshaa pi fale' kumuinchi tu ajta ajtakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yavé Dios chachi ketu tu llujpepechiren ke', ya' kijkapanu juipu', aama pu' kujtemuwaami. Tsenñaa umaa chachi tiya' chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tsejtu bene Yavé Dios pajlanu pasha Edén mumu puu vijtya main ke' chujtitu, jungaa ya' keñu chachinu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tsejtu naaju chi'baasa awakare', uukerai katawamu tire', famu puka imu tene awakaami. Tsejtu juntsa vijtya kejtala naa chuwaanu tiremu chi bain, naa main main tyee keñu urañu bain, tyee keñu urajtuñu bain mijakaakaa kemu chi bain awakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edénnu pijula main fale' jitu, juntsa vijpala pi ajkemu jumi, ma pijularen taapai pala ma velaa pijula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ajke' pala jumuya Pisón mumumi; entsa pi uru tsunu Havilá tusha yatemu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Entsa tenatalaa naa kayu ura uru bain, naa chi pillu aindyayaa bain, naa unise mumu shupuka bain kataamumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Tsenmala kama pijuu palaya Guihón mumumi, Cus tinu tusha yatemu pijula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tsenmala kama pijuu palaya Tigris pi mumumi, Asur pebulu pajlanu pasha pumu pi. Tsenmala entsaba kumuinchibi taapai pijuu pala jumuya Éufrates mumumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tsejtu Yavé Dios, cha' rukunu Edén vijpaasha pu', tiba dewajke' washkisa tyatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yavé Dios entsangue uudenguemi cha' rukunu: Vijtyasha naaju chinu puka ka' findenñuba ka' finuu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","tsaaren main main tyee keñu urañu bain, tyee keñu urajtuñu bain mijakaamu chinu namu pukaya ka' fityude; ñu naama juntsa puka ka' fi' bain, uwain peyanbera inu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tsejtu bene Yavé Dios tsandimi: Unbee rukun maali juu tsanashu juntsaa urajtuve. Tsa' mitya main ti bain yaba bulu ura' kivetekenuunu kenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Tsejtu Yavé Dios tu llujpenuren kumuinchi animaa juula bain, naa pishku juula bain dekemuwaatu, umaa cha' ruku' junga deta'mi, mumu pukaanu. Tsenñu cha' ruku naajulanuba mumu depukemi, naa cha' miyanuu animaalanu bain, naa pishkulanu bain, naa jeendaa chumu ajara animaalanu bain. Tsejtu naake mumu puñuba juntsai shuwala. Tsaaren juntsa animaala, maliiba cha' rukunu bulu ura' kivetekenuu faatyula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tsenñu Yavé Dios cha' rukunu tengan jutyungue kaskare', ya kasu'tsunu uwanu ma vi'chi kalaami. Tsanguetu ya' allachiren junu vi'chi kalaanunu mandu'kaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tsejtu juntsa vi'chinun Yavé Dios ma shinbu ketu, cha' rukunu taji' keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tsenñu cha' ruku katatu tsandimi: ¡Entsaya uwain in allaren jumin, in taku bain jumin juve! “Supu shinbu” mumu junu tsuve, matyu Dios unbee rukunaa kalaañu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tsa' mityaa unbee rukuya ya' apanu bain, ya' amanu bain shuike' ji', ya' shinbuba buudi' chunu tsuve; tsai' yala main juuñuu tiyainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tsejtu naa unbee ruku bain, naa ya' shinbu bain cha'tene juularen, ne tsa deeyu tya' yujtyatyu jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yavéchi, matyu Dioschi imu jeendaa nemu ajaa animaalanu pensanguiñuya piñee kayu bibumi. Tsa' mitya supu shinbunu tsandimi: ¿Tsejtu Dios ñullanu vijpalanu chudenashu juntsa chinu puka namulaa, naaju bain fityudei, tii? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tsenñu supu shinbu pakatu: Lalaya naaju chinu puka ka' findenñuba ka' finuu dejuyu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tsaaren vijtya kejtaa chunashu juntsa chinuya Dios lalanu naa ta'kabainguityudei tiñu' mitya, ka' finu dejutyuyu, matyu tsanguishu juntsaa peyanu dejuve tiñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tsenñu supu shinbunu piñi tsandimi: Anbudave, ñulla peyan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Matyu Diosya naama ñulla juntsa chinu puka deka' fi' bain ñulla' kapuka dedanware', naaju urañu bain, naaju urajtuñu bain demija', Dios tsaa tiyanu dejuñuba mi' mityaa tsandive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tsenñu supu shinbu juntsa chinu namu puka ne keranchiya uu finuuve tya' mujkere', aseetaju tiyachi tya' mitya, fi'kera tyami. Tsejtu manbuka walla' chiti' fitu, ya' rukunu bain kuñu, ya bain fimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tsenmalan juntsa uwanu yala' kapuka dedanguiñu, naa yala pallu tsaa cha'tene ju deju'ba kayu narai mija' yujtyala. Tsejtu iguera tapee deka' detyundyu' tele' juntsachi dishukila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tsejtu bene unbee ruku bain, ya' shinbu bain kependu' ishuwa juyinu uratala Yavé Dios vijtyasha nentsuñuba demeetu, chi kejtsapala yangachi tene ji' pantsudila, matyu Yavé Dios yalanu katatyusa tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tsenñuren unbee rukunu Yavé Dios tsandimi: ¿Nuka naanayu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tsenñu cha' ruku pakatu tsandimi: Ñu vijpalasha nentsuñu meetu, cha'tene ju' mityaa, jeetenñu pantsudiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tsenñu Dios tsandimi: ¿Tsen maa ñunu cha'tene juuve tin? ¿Tsaaya, ñunu fityude tyeesu juntsa chinu namu pukaa ka' fii? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tsenñu cha' ruku tsandimi: Ñu iba chunu ti' kuwakishu juntsa shinbu inu juntsa puka kuwañaa fiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tsenñu supu shinbunu Yavé Dios tsandimi: ¿Nenñaa tsanguiyu? timi. Tsandiñu juntsa shinbu: Inu piñi anbutiñun, juntsa puka tsangue' fikeeñuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tsenñu piñinu Yavé Dios tsandimi: Ñu' juntsanguen mitya, mika firu' inu tsuve, ñu' chungamaya kumuinchi animaatala ñaa firu' i' taaju imu junu tsuve. Entsa malu ajkeshaa shilla' nenchi tene neinu tsuve, tsenmin ñu' chungamaya malumere tu llujpee fin chunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tsenmin ñunu cha' shinbuba veta' veta' kundaa juu tirenu tsuyu, tsenmin naa ñunu sera' jimula bain, naa entsa shinbunu sera' jimula bain naa-uwanuba tsaren kundaa juu chunu detsuve. Tsa' mitya yanu sera' jimu ñu' mishunu ijchaa teenu tsuve. Ñuya ya' nenbujkuwanaa lluidi' finu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tsejtu cha' shinbunu entsandimi: Navi' nakandu taaju' iinuke tirenu tsuyu; nakanu uwanu kityandaa ñu' kaillanu kanu tsuve. Ñu' rukunu meneste jujuunu tsuve, tsenmala yaa ñunu mandanguen chunu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tsenmin unbee rukunu bain entsandimi: Ñu' shinbunu meedi', juntsa chinu imu puka fityude tiñun fiñu' mitya, ñu' kuipa' mityaren entsa tu mika firu' juu junu tsuve. Tsa' mitya ñu' chungamaya tsamantsa daran taawasha ketaa tyeeba wajke' de-iwaatu ka' fin chunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tunu naa puchi bain, naa pu chuu tape bain awanu detsuve, tsenmin jeenbaasha chumu kiya juula bain ñu fin chunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tsa' mitya taawasha ketu llashkapa chipinbee netaa panda fin chunu tsuve, ñun peya' tu mandi'mujchiya, matyu turen ñu chachi tiyamu' mitya, turen mandinu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tsejtu juntsa cha' ruku Adán ya' shinbunu Eva mumu pumi, matyu yaa kumuinchi chachillachi ya' amañu' mitya. Eva titu “chumu” titundive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yavé Dios, unbee rukunu bain, ya' shinbunu bain animaa kika jali deke' kuwa' pandemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tsejtu tsandimi: Umaa chachi bain lala tsaa ma tiyaive, matyu naaju urañu bain, naaju urajtuñu bain mi' mitya. Tsa' mitya naa chuwaanu tiremu chinu bain ta-ere' puka ka' fimiya, naa-uwanuba tsana chunu tiya'ba inu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tsejtu Yavé Dios, cha' rukunu Edén vijtyasha mangalaatu, yanu ke' kujteñu tunuren taawasha kenu pukemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tsejtu chachinu mangalare' dyatu, vijpalanu uidi' pensanguiñuya pajlanu pasha, anjee keraalanu dewashkaami, tsenmin ma peeniya, ñi llu'waraaya, juntsa miñunu nutsa kelushaba lu'tetintsunu pumi, tsenmalaa chuwaawaa kemu chisha muba kalen ji'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Cha' ruku ya' shinbu Evaba chuñu, entsa navi' Caínnu nakami. Tsejtu tsandimi: Yavé kuñuya na main unbeena miyayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tsejtu bene Caín' benna, Abelnu, na mangami. Tsenñu Abelya uveja washke' awakaamu tiyami, tsenmala Caínya tunu buikiya wajke' awakaamu tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tsanguen dechuturen, ma malu Caín yachi tiba wajke' awakare' iwaañu puka Yavénu mantsa taji' ufeenda keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tsenñu Abel bain ajke' nakayamu uveja kayu naraa jumu tute' ju'ke' Yavénu keewaami. Tsenñu Yavé yuj sundya' keemi Abelnu bain, naa ya' ju'ke' keewaanu ufeendanu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tsaaren naa Caínnu bain, naa ya' keewaañu ufeendanu bain mutya' keetyumi. Tsenñu' mitya Caín tsamantsai ajaavitu, naa kajuuba devera' laimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Tsenñu Yavé tsandimi: ¿Ti' mityaa ajaavitu iyu, naa kajuruba devera' juu ma neintsumi? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","¿Uwain ñu ura' keñuya iya mutyan jutyuwa? Tsaaren ñu tsanguityuñu' mitya, umaa ujcha jumuren ñunu mandanguenu keenave. Tsaanuren ñaa juntsa ujchanu puinuu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ma malu, Caín ya' benna Abelba pami. Tsejtu jeenbaasha ji' yai tene punalan Caín ya' benna Abelnu tsaa tutekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tsanguiñu Caínnu Yavé pake'meetu: ¿Ñu' benna Abel nuka naanain? timi. Tsandiñu Caín pakatu: Iyaa mijtuyu, ne iyaa in bennanu washkemaaba juumiñu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Tsenñu Yavé tsandimi: ¿Nenñunguiyu tsanguemi? Entsa tusha ñu' benna' asa shajaakaakishu juntsan inu naakeñu urañuba ke' kuwaka ti' pakakeñunguentsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tsa' mitya, ñu firu' iwaraa jude, matyu ñu' bennanu tute' asa kushkakaakishu juntsa tuya ñunu ura' ikare' puiten jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tsaju' naamika tinu taawasha keñu bain, puka juntsai ma-i'nu detsuve. Tsenmin naa-uwanuba lekayajturen entsa tunu nedandaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tsandiñu Caín pakatu Yavénu tsandimi: Inu tsamantsangue taaju ikaanujtuuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ñu umaa inu entsa tunu kelaakeñu' mitya, ñu putyuinsha baasha naa-uwanuba lekai'mujchi nedandaanu tsuyu. Tsaita nentsunmalaa mun inu kata'ba tu'nu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tsandiñuren Yavé manbakatu tsandimi: Tsa jutyuve. Mun ñunu tute' bain, yalaa kayu mandishpai bijee taaju iinuu kuipa manganu detsuve, timi. Tsejtu Caínnu Yavé ma señas chujtimi, mun kata'ba tutei'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tsenñu Caín Yavéba kuinda ketu Yavé' ajuunu lu' jimi, tsai' Nod tusha ji' chumi, Edénnu pensanguiñuya pajlanu deechusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caín ya' shinbunu ka' chu' tsaiñu, entsa navi', nakatu Henocnu faawaami. Tsejtu Caín ma pebulu kentsu' mitya, Henoc mumu pumi, matyu ya' na naaju mumuñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henocya, Irad' ya' apa tiyanmala Iradya, Mehujael' ya' apa tiyamuwaami. Mehujaelya, Metusael' ya' apa tiyanmala Metusaelya, Lámec' ya' apa timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lámec pai shinbu miyandimuwaami: mainya Adá mumunmala, kamainya Silá mumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adáya Jabalnu nakami, tsenñu entsaa ajke' bijee yapayatala chudi' animaa awakaakaa kemu juwaañu, veela bain bene tsaren kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tsenñu Jabal bain ma naatala Jubal mumu puu miyandimi, tsenñu entsa Jubalya beesanguendu pakaakaa kentsumi sitara bain, naa pujkuna bain ajke' bijee ke' pakaamuwaami, tsenñu bene veela bain tsaren kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siláya, Tubal-caínnu nakami, tsenñu entsaa naa brunsetala bain, naa ura jerutala bain taawasha ke' tiba kiikemuwaami. Tsenñu Tubal-caínchi ma tsujki juwaami, ya' mumu Naamá. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ma malu, Lámec ya' pai shinbulanu Adánu bain, Silánu bain tsandimi: Ura' meedidei in patintsaashu juntsanu: Ma cha' ruku inu lastema kishu juntsaa, iya tu'nu tsuyu; ma unna inu kai'shu juntsaa, iya tu'nu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tsa' mitya uwain mun Caínnu tu'mulanaa, mandishpai bijee kayu taaju iwaanu jushu juntsaa, mun inu tu'mulaa kayu 77 bijee taaju iwaranuu kuipa vinu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adán manen ya' shinbuba matsumi, tsenñu ya' shinbu na mavi' mangatu, Set mumu pumi, tsejtu tsandimi: Dios manen kama na manguve, Caín tutekisu juntsa Abel' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Tsenñu Set bain na main miyanditu, Enós mumu pumi. Tsenñaa umaa Diosa' mumunu pakatu, Yavé tiitin chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Enaa Adán' paandela naa-i sera' dejiñuba juntsa pillave. Dios chachi ke' kujtetu, ya kerake ke' kujte', ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","unbee ruku bain, supu bain kikemi, tsangue' Dios yalanu ura' dejusa ti' pami. Tsejtu yalanu ke' kujtenu malunu Dios tsandimi: “Chachi” mumu junu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adán 130 añu juunu uwanu na mamiyanditu, Set mumu pumi, tsenmin entsa kaana ya' apa keraami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set nakayañu, Adán kayu 800 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tsejtu kumuinchibi 930 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set 105 añu juunu uwanu na miyandimi Enósnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enós nakayañu, Set kayu 807 añu yapa manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tsejtu kumuinchibi 912 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enósya 90 añu juunu uwanaa Cainánnu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Cainán nakayañu, Enós kayu 815 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tsejtu kumuinchibi 905 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainánya 70 añu juunu uwanu na miyandimi Mahalalelnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel nakayañu, Cainán kayu 840 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tsejtu kumuinchibi 910 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalelya 65 añu juunu uwanu na miyandimi Jérednu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jéred nakayañu, Mahalalel kayu 830 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tsejtu kumuinchibi 895 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jéredya 162 añu juunu uwanu na miyandimi Henocnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Henoc nakayañu, Jéred kayu 800 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tsejtu kumuinchibi 962 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henocya 65 añu juunu uwanu na miyandimi Matusalénnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tsejtu Henoc, naa-uwanuba Dios naaken chusa tyañuba tsanguen chumi. Tsejtu Henoc, ya' na Matusalén kayañu, 300 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tsejtu kumuinchibi 365 añu chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henocya naa-uwanuba Dios naaken chusa tyañuba tsanguen chumuñu, Dios yanu ka' jiñu, tsaa ma malu piyanchi ne iimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalénya 187 añu juunu uwanu na miyandimi Lámecnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lámec kayañu Matusalén kayu 782 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tsejtu kumuinchibi 969 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lámecya 182 añu juunu uwanu na main miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Tsejtu Noé mumu pumi, entsanditu: Yavé tunu firu' iwaraa tireñu, lala daran taawasha ketaa tiba wajke' awakaanuu dejuyu; tsaanuren entsa kaana jayu ma lekakaanu juve, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Tsejtu Lámec, ya' na Noé nakayañu, kayu 595 añu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tsejtu kumuinchibi 777 añu chumi; tsai ruku' chunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noéya yumaa 500 añu ma juunu uwanaa na miyandimuwaami Semnu bain, Camnu bain, Jafetnu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Chachilla entsa tunu chutu pure' seraindu, naa pannala bain tsaren serala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tsenñu cha' rukula' na'mala nara deeñu' mitya, Diosa' nala naaju kayu ura deeñu bain, mi'ke' juntsalanu supunga' yala' shinbu tire tirekila. Tsa' mitya naajulanu kandya' bain ne kakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tsenñu Yavé tsandimi: Cha' ruku naa-uwanuba te' peyatyumujchi ne tsanasa tendyuve; yaa ne chachiren juñu' mitya, 120 añun chudinuke tirenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tsa' mitya aa kasta chachi tusha defaalaya Diosa' nala cha' na'malanu supu deka' na dekiñaa faala. Tsaaren naa bene bain faala. Tsejtu juntsalaa kaspee tinbunu daj ruku jumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Entsa tusha chumu chachilla mika firu' ken dechu', naa-uwanu bain firu' kiikenu pensan judeeñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yavé katatu, chachillanu entsa tusha ke' chujtin jutyuunuba kikeeñuve tya', veta' pensa mantu yuj llakindyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tsejtu tsandimi: In keñu chachillanu entsa tunu tsaa demanbirekenu tsuyu, tsenmin kumuinchi animaa chachi miyanuu judeeshu juntsalanu bain, naa ajkachi shilla' neimu animaalanu bain, naa pishkulanu bain demanbirekenu tsuyu, matyu ke' chujtin jutyuunuba kikeeñuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tsaaren Noéya Yavéchi ura' katawami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Entsaa Noé' kuindave. Noéya yuj ura' rukuwaami, naa-uwanuba Diosnu meenguemu. Tsa' mitya ya' chunu tinbunuya, yaa Dios naaken chusa tyamuñuba tsanguen chumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé pen na miyandimuwaami: Semnu bain, Camnu bain, Jafetnu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dioschiya tu urajtu kuraa tiyaimi, chachilla urajtu tene ken chu', tituba ne kikendetsuñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tsejtu kumuinchi entsa tusha chumula urajtu tene tiya deiñu' mitya, entsa tusha tsamantsa ujcha landetsuñu katatu, Dios ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","tsandimi Noénu: Chachillanu depirekenu tsuyu. Yala' kuipa' mityan entsa tusha tsamantsa tituba kiken ne chudenave. Tsa' mitya, yalanu depireke', kayu vera entsa tusha tiba chudenashu juntsalanu bain depirekenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tsa' mitya pillu laimu chi mi'ke' ka', baaku main ke', suku puja'tee kide, tsangue' naa juusha bain, naa avindala bain ba'dindalaya amuyachi tene kide pi vin jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Matyu iya ñunu naake aawa kide tiñuba juntsaaya kide: bare' mityaya 300 tyabulu, tsenmala bungunchiya 50 tyabulu, tsenmin katyu' mityaya 30 tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tsenmin pen dijki pude, tsenmin mishbui' lunu ma tyabulu faatanainshaya ma kaa juukapaa pude ke'laalaadinunu, tsenmin luluinu juukapa bain main pude ma kelusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Entsa tusha pi bu'ware', kumuinchi entsa tu' chumulanu depirekenu tsuyu, naa nuka bain. Tsa' mitya kumuinchi entsa tunu chudenashu juntsalaya millai peyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tsaaren ñubaa veta' veta' uraa kenu tsuyu. Tsa' mitya baakunu vi', ñu' shinbunu bain, ñu' nalanu bain, naa ñu' suyalanu bain miya' vide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tsenmin tusha kataamu kumuinchi animaalanu bain, main llupu ka', main supu kake', baakusha vimishtide, yai bain ñuba bulu livee inudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tsa' mitya vee vee animaala pallu pallu baakusha ñuba vinu dejuve; naa pishkula bain, naa tusha nemu animaala bain, naa ajkachi shilla' neimu animaala bain, tsejtaa mantsala peyai'mujchi laranudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tsenmin titi famuñu bain juntsa vee vee deka' uukaade, tsenmee naa ñulla chachilla bain, naa animaala bain fikenuu tananudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Tsenñu Dios naake mandangueñuba Noé kumuinchi juntsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Tsejtu bene Noénu Yavé tsandimi: Kumuinchi entsa tinbunu chumu chachiitala pensangue' keeñuya, ñuren main iya naaken chusa tyañuba tsanguen chumu juuve. Tsa' mitya ñu' bululaba baakusha bulu vide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tsenmin kumuinchi animaala Dioschiya ura kuramulanuya, llupu bain mandishpallu, supu bain mandishpallu ka' vinu juve, tsaaren Dioschi urajtu kuraa animaalanuya llupu bain main, supu bain main kakide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Tsenmin vee vee pishkulanu bain supu mandishpallu kamin, naa llupu bain mandishpallu kaminguide, tsanguenmalaa yai bain entsa tusha piyai'mujchi chunudetsu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","matyu mandishpai malu insha 40 malu, 40 kepe shuwa jakaanu tsuyu, tsangue' entsa tunu kumuinchi in keñu chumulanu depirekenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tsenñu Yavé naake mandangueñuba Noé kumuinchi juntsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tsejtu tunu debu'waakenu tinbunu Noé 600 añu juuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tsenñu umaa Noé baakusha vimi, naa ya' shinbu bain, ya' nala bain, naa ya' suyala bain, tsejtaa pi bu'ñu yala livee inu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Tsejtu naaju animaalaba, Dioschi ura kuramula bain, naa Dioschi urajtu kuramula bain, naa jekikemula bain, naa ajkachi shilla' neimula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","pallu pallu Noéba baakusha bulu vila, llupu bain, supu bain, Dios naake mandangueñuba juntsaitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tsenñu mandishpai malusha umaa tunu pi bu'dundami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé 600 añu, ma chu'chaya, 17 malu juunu malunu, pi tainsharen tsaa tu deleetse'ke' pi defalekemi, naa kai'sha selusha bain pi deseetse'kike' jaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tsejtu tusha 40 malu, 40 kepe shuwa jami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tsenñu juntsai' shuwa janu malunun Noé bain, naa ya' shinbu bain, naa ya' nala Sem bain, Cam bain, Jafet bain, naa ya' suyala bain baakusha vila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tsenñu naaju animaala bain yaiba bulu vila, naa ajara animaa juula bain, naa cha' miyanuu animaa juula bain, naa ajkachi shilla' neimu animaa juula bain, naa naaju pishkula bain, matyu tiba jekachi neimulaya kumuinchi vila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Tsa' mitya naaju animaala bain Noéba pallu pallu baakusha vila, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","matyu Noénu Dios naake uudengueñuba juntsaitu, vee vee animaala llupu bain, supu bain viila. Tsenñu bene Dios juukapa llu'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Shuwa pure-i', 40 malu ja' dyami. Tsenñu pi bukenmalan, baaku tunu tsutun unguikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tsejtu piya kayu buke' lunchi ne iintsunmala baaku bain unguenchi ne kikentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tsa' mitya pi tsamantsangue bukenchiren tusha aa katyu kuyi chumulanu bain tsaa debukikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tsejtu naa kuyila bain debukiketu, kayu 15 tyabulu jungue buke' dyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Juntsaiñaa tusha chumu chachilla millai peyala, naa pishkula bain, naa cha' miyanuu animaala bain, naa ajara animaala bain, naa ajkachi tunu shilla' neimu animaala bain millai peyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Matyu entsa tunu naajulaba ishin chumulaya depeyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Juntsaiñu Noé, yaba bulu pumulaban laraimi, tsenmala mantsalaya, naa chachilla bain, naa cha' miyanuu animaala bain, naa pishkula bain, naa ajkachi shilla' neimu animaala bain depeyaila, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","matyu tunu 150 malu pi bukaa tsanañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tsaaren Diosya naa Noénu bain, naa yaba bulu baakusha pumu jeen animaalanu bain, naa cha' miyanuu animaalanu bain pashindyumi. Tsejtu ishuwa tusha juyikaañu pi umaa mangandundami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tsenñu naa pi tainsha tu leetse'ke' pi faanu juru bain demallukikemi, tsejtu naa kai'sha selusha leetseta juru bain demallu'ñu, umaa shuwa bain mandyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tsenñu umaa pi jayu jayu mangantsumi. Tsejtu shuwa jadunda' dya'ka' pi demangainshabi 150 malu wanbimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tsejtu mandishpai chu'chaya insha, 17 malusha juntsa baaku Ararat kuyitala tsui ejkemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tsenñun pi manganchi ne kikentsuñu' mitya, paitya chu'chaya insha, ajke' malunu aa katyu kuyilaya yumaa mangatawantsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tsenñu bene 40 malusha, Noé baakunu ke'laadinu juukapa juuke', ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ma kuerbu tyaike' je'ware' eemi; tsenñu kuerbuya tu me-ejkenbera keenatu nukaba ne je'danda kes neintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tsenñu bene Noé palumanaa mandyaike' eemi, yumaa pi mangantsuñuba mijanu tyatu; ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","tsenñuren pi bu'nañu' mitya paluma baakusharen miimi nukaba chudi' lekakenuu tena katai'tu. Tsenñu Noé tyaapa usake' manchujtikaatu, baaku juusha manga' pumi palumanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tsejtu Noé mandishpai malu kayu mangueeditu, manen palumanu mandyaike' eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tsenñu yumaa ma deyapijuru' kakinsha paluma, ya' fi'papanu ulibu chi tape majkaaya miimi. Tsaiñaa Noé, naa tu yumaa demafalentsuñuba mijami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tsejtu mandishpai malu kayu mangueeditu manen palumanu me-eemi; tsenñuren paluma umaa maatyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tsenñu Noé yumaa 601 añu juunu malunaa tu deme-ejkemi. Tsejtu juntsa añu ajke' malunu Noé baaku mishbui'sha juuke' ke-eetu, tu deme-ejkee katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tsa' mitya kasa añu manchañu, ma chu'chaya, 27 malusha yumaa narai deme-ejkemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tsenñu Noénu Dios tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ñu bain, ñu' shinbu bain, ñu' nala bain, naa ñu' suyala bain maludei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tsenmin kumuinchi ñuba bulu pumu animaalanu, naa pishkulanu bain, naa cha' miyanuu animaalanu bain, naa ajkachi shilla' neimu animaalanu bain demangalaade, yai bain entsa tunu nukaba deji', na miyandi' deseengue', entsa tunu pure' serainudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tsenñu Noé ya' shinbuba, naa ya' nala bain, naa ya' suyala bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","naa animaala bain millai malula; naa cha' miyanuu animaala bain, naa ajara animaala bain, naa ajkachi shilla' neimu animaala bain, naa jekachi neimu animaala bain ma bulu, ma bulu malula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tsejtu bene Noé, ufeenda tsure' ju'kenunu main kemi Yavénu ufeenda keewaanu, tsangue' Dioschi ura kuraa animaalanu bain, naa Dioschi ura kuraa pishkulanu bain kaminguetu, detute' ju'ke' Diosnu keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Tsenñu Yavé juntsa jupe tsamantsa aindyu' ishkaputu tsandimi: Naa-uwanuba cha' ruku' kuipa' mityan entsa tunu firu' isa ti' manban jui'yu, naa chachiya nei'ba unnamiren firu' kenu pensan judeeñuba. Tsenmin naa animaalanu bain challa naake dekike' pire'ba tsa manguen jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tsa' mitya entsa tu naa-uwanuba de-i' piyaindyuya, naa kiya wajnu tinbu bain, naa pu' inu tinbu bain, naa lujaa tennu tinbu bain, naa ishtennu tinbu bain junu tsuve; tsenmin naa shu tinbu bain, naa shu tinbu jutyu bain junu tsuve, tsenmin naa kepe bain, naa mandala bain junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dios, Noénu bain, naa ya' nalanu bain mika ura' de-isa ti' entsandimi: Pure' na miyandiyai', tunu yallui seradei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Naaju animaala bain ñullanu yuj jeemunu detsuve. Tsenmin kumuinchi animaalanu, naa kai'sha, naa tusha, naa pisha pumulanu bain, ñullaa uudenguentsunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tsenmin ti animaalanu bain ñulla finuu dejuve, matyu iya ñullanu ti buikiyalanu bain naake kuwa'ba entsa animaalanu bain finu juntsangue kuwantsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tsaaren ñulla allanu asa erei'mujchiya finu dejutyuve, asaa chuwaamuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Naa chachilla bain, naa animaala bain chachinu tute' asa shajaakaren mitya, yalanu kuipa faawaanu tsuyu. Tsenmin mun chachi tute'ba main main juntsa chachi' mitya kavitu inu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mun vee chachinu tute' bain, ya bain vee rukuchi tutanu tsuve, matyu chachiya Dios naajuñuba ya keraaya imuwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tsaaren ñullaya na pure' miyandiyai', nuka bain tyuwai seradei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tsejtu Dios, Noénu bain, naa ya' nalanu bain entsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Challa ñullanu bain, naa ñullanu sera' jimulanu bain veta' veta' tsanguedaa tintsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Tsenmin kumuinchi animaa baakusha pu' mala' ñuiba chudenashu juntsalanu bain, naa pishkulanu bain, naa cha' miyanuu animaalanu bain, naa ajara animaalanu bain, matyu kumuinchi tunu chumu animaalanuya tsaren tsanguenbera kenu tsuyu tintsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Tsa' mitya iya ñullanu naakenu pa' bain jaiba vera' manban jutyuyu: Umaa naa-uwanuba shuwa pure' jakaake', pi bu'ware' chachillanu bain, naa animaalanu bain demanbiren jutyuyu. Tsenmin shuwa tsamantsai maja' entsa tu manbirekenuuya naa-uwanuba majun jutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Tsejtu Dios tsandimi: Iya ñullanu bain, naa naaju animaalanu bain pi bu'ware' manbiren jutyuyu tyeeshu juntsa ñuiba veta' veta' tsanguedaa ti' keewaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Iya ñivijchatala arku iris tingaayu, matyu juntsaa iya entsa tuba veta' veta' tsanguedaa tiñu keewara junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tsa' mitya iya naa-uwanu tusha ñivijcha pajteñu ñivijchatala in arku iris fale' tindiñuba ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","iya ñullanu bain, naa animaalanu bain veta' veta' naakenu pamuwa ju'ba juntsa mandenganu tsuyu. Tsejtu umaa shuwa pure' jakaake' demanbirenu jutyuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tsaju' naa-uwanu arku iris ñivijchatala tinna kata' bain, naa-uwanu' mityaba veta' veta' naa naakenu pa', naa in chachillanu bain, naa kumuinchi entsa tunu chumu animaalanu bain manbiren jutyu ju'ba mandenganu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tsaju' entsa palaaya iya entsa tunu chumulanu veta' veta' naa naakenu pañuba juntsa keewara juve, timi. Tsejtu Dios juntsaaya pami Noénu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé' nala baakusha pu' malumula Sem bain, Cam bain, Jafet bain juula. Camya, Canaán' ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Entsa pemalaa Noé' nala jumuwaala. Tsenñu entsalanu sera' jimulaa kumuinchi entsa tunu chachi demasera' chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Tsenmala Noéya tunu buikiya wajken chumuwaatu, yaa ajke' uva vijtya ke' awakaamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tsejtu umaa ma malu Noé binu kushtu tsaa viñaimi, tsai' ya' yapayanu chipa kejtala cha'tene juu tya'pu' kasu'tsunami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Tsenñu Canaánchi ya' apa jumu, Cam, ya' apanu cha'tene juu tsuna katamin, avindala malu', ya' vejan pai naatalalanu kuinda kijiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tsenñu Sem, Jafetba jali ka', yala' palanu llatikare' ji' ya' apanu juntsachi vikaala. Tsejtu yalaa ya' apanu cha'tene juu katan detyatyu' mitya, benga' mitya vee mujtu ke-eraa tene jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tsenñu Noé viña' tsu' mandengatu mijami ya' kayi na yanu tyee kiñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tsejtu tsandimi: ¡Dioschi firu' isa Canaán! ¡Matyu ya' naatalala' tiba kiikemu chachiitala yaa kayu balejtu kuraa chachi junu tsuve! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tsejtu bene kayu patu tsandimi: Yavé, Sem' Diosya, mika urave tikayasa, tsenmala Canaánya Semchi tiba kiikemu chachi jusa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tsenmin Dios, Jafetnu bain aawa tiwaasa; tsenmin Sem' chunu tunuren ya bain chusa, tsenmala Canaánya yachi tiba kiikemu chachi jusa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pi bu'dunda' dyañu, bene Noé kayu 350 añu manchumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tsejtu kumuinchibi 950 añu juunu uwanu peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Pi bu'ware' dyañu, Noé' nala, Sem bain, Cam bain, Jafet bain na demiyandiñu, entsai sera' jila: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Entsalaa Jafet' nala deeve: Gómer bain, Magog bain, Madai bain, Javán bain, Tubal bain, Mésec bain, naa Tirás bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Entsalaa Gómer' nawaala: Asquenaz bain, Rifat bain, naa Togarmá bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Tsenmala Javán' nalaa Elisá bain, Tarsis bain, Quitim bain, naa Rodanim bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Entsalaa Jafetnu sera' jimu detiya' ma bululu chachilla vee vee ma uñichi uuden juu chumu detiya' lamaa keetala chumuwaala, tsenmin ma bulumee ma palaachi tene patimu chachilla debuudi', yala' tunu ma bululu paande i' chuchudimuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cam' nalaya Cus bain, Misraim bain, Fut bain, naa Canaán bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Tsenmala Cus' nalaya Sebá bain, Havilá bain, Sabtá bain, Raamá bain, naa Sabtecá bain. Tsenmala Raamá' nalaya Sebá bain, tsenmin Dedán bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cusya, entsa tunu mu' mityaba ajke' kayu daj ruku tiya' chumu Nimrodchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrod ura' yavi' jeen aingamu tiyamuwaami. Tsenñaa yanu laapu' patu entsandimu deeve: Ya bain yavi' jeen aingamu, matyu Nimrod tsaave, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ya uñi tiya' ajke' uudenguen chunu pebululaya entsaa juntsawaala: Babel bain, Érec bain, Acad bain, tsenmin Calné bain Sinar tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Tsenmin entsa tu tenasha chu' malutaa Asiriasha ji' pebulu dekemi: naa Nínive bain, naa Rehobot-ir bain, naa Quélah pebulu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","tsenmin Resen aa pebulu bain kemi, matyu Nínive bain, Quélah bain chunu kejtaa tenatala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraimnaa desera' jila Ludnu sera' jimu chachilla bain, naa Anamnu sera' jimu chachilla bain, naa Lehabnu sera' jimu chachilla bain, naa Naftuhínu sera' jimu chachilla bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","naa Patrusnu sera' jimu chachilla bain, naa Casluhínu sera' jimu chachilla bain, tsenmin Caftornu sera' jimu chachilla bain. Tsenmala Casluhínu sera' jimu chachillanaa Filisteasha chumu chachilla sera' jimuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Tsenmala Canaánya Sidónnu ajke' na miyandimi, tsejtu bene Hetnu bain miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Tsenmala Canaánnu seralaa naa Jebús pebulunu chumu chachilla bain, naa Amor chachilla bain, naa Gerges chachilla bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","naa Heve chachilla bain, naa Arac chachilla bain, naa Sin chachilla bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","naa Arvad chachilla bain, naa Semar chachilla bain, tsenmin Hamat chachilla bain serala. Tsejtu bene kumuinchi Canaánnu bulu paande seramula na'baasa devela' jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Canaánnu sera' jimu chachilla' tuya bare' tsetanchi ne kikemi. Tsa' mitya Guerar tu deechusha, Sidón pebulubi jumin Gaza pebulubi juumi, tsenmin Sodoma pebulu, naa Gomorra, naa Admá, naa Seboím pebulu deechusha bain jumin, Lesa pebulubi jingue bare' tse'kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Camnu sera' jimu chachilla ma bululu chachilla vee vee ma uñichi uuden juu chumu detiya', naa tu bain ma paande bulumeemee ka' dechu', main main naati vera' pamu deju'ba tsa tsai chumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafetchi ya' uñaku Sem bain na miyandimuwaami. Kumuinchi Éber' nalaa Semnu sera' jimu chachilla deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Entsalaa Sem' na jumuwaala: Elam bain, Asur bain, Arfaxad bain, Lud bain, naa Aram bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Tsenmala Aram' nalaya Us bain, Hul bain, Guéter bain, naa Mas mumu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxadya Sélahchi ya' apa tiyamuwaami, tsenmala Sélahya, Éberchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Tsenñu bene Éber bain pai na miyandimuwaami: mainya Péleg mumuwaami, matyu ya' tinbunu chumu chachilla develadeiñu' mitya (hebreo palaachiya Péleg titu, “veenu” titundive), tsenmala Péleg' bennaya Joctán mumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán' nalaya Almodad bain, Sélef bain, Hasar-mávet bain, Jérah bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram bain, Uzal bain, Diclá bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal bain, Abimael bain, Sebá bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir bain, Havilá bain, tsenmin Jobab bain. Kumuinchi entsala Joctán' na tene juwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tsejtu Mesábi tu miyalan, Sefar detiñu, matyu pajlainsha kuyi tene junainsha tu jina bare' tanamuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Semnu sera' jimu chachilla ma uñichin uuden juu chumu detiya', naa tu bain ma paande bulumeemee ka' dechu', main main naati vera' pamu deju'ba tsa tsai chumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Entsalaa Noé' nalanu sera' jimu bulu paande jumuwaala, matyu ya' nalanu main main desera' ji' ma tenana chumula. Tsangue' Dios pi bu'ware' dyañu, bene Noé' nalanu sera' jitaa naa nukaba desera' ji' ma bulumeemee ma uñichin uuden juu chumu chachilla detiya' chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kaspeleya kumuinchi chachilla ma palaachin patimu juwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tsejtu yala pajlanu pasha dechuturen delu' jitu, Sinar tusha ma jatsuwa tena dekatatu, junu dekajdi' tsai chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tsejtu ma malu yaitala tsandila: Tu lepaa ke', ñinbaasha pu' puulawaadaa, tila. Tsa deke' shupukaa putyumujchi tu lepaa pula, tsenmala tyakakaantsumiya amuyaa pula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tsejtu bene tsandila: ¡Dewa'di', ma pebulu kidaa! Tsangue' selusha tapa'kayaa ya bain main aa katyu kidaa. Tsanguishu juntsaa daj ruku keengayanu detsuyu, tsenmin tsanguishu juntsaa, entsa tunu na'baasa shajara' nenu dejui'yu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tsenñu Yavé paja' keemi cha' rukula' kenu pebulunu bain, naa aa katyu yanu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","tsejtu entsandimi: Yala ma bulu chachi judeeve, tsenmin ma palaachiren patimu ne judeeve. Tsa deju' mityaa entsa taawasha depeepuñuve. Tsejtu yala ti kendya'ba kenuu dejuñu muba dya'kawaakenuu dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tsaañu' mitya lala pajtya', yala' palaa tsaa detujlekaakidaa, tsenmalaa yaitala aseetangui'nudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Entsanguitaa Yavé tusha na'baasa deshajara' eekemi chachillanu. Tsenñaa yala juntsa pebulunu taawasha mantyui tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tsa' mitya juntsa tenanaa Yavé kumuinchi tusha chumula' palaa detujlekaake', naa nuka tenashaba devela' eekemuwaami. Tsenñu' mityaa juntsa pebulu Babel mumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Entsalaa Semnu sera' jimu chachilla deeve. Shuwa pure-i' pi bu'ware' dyañu pai añu insha, Sem 100 añu juunu uwanu ya' na Arfaxad nakayamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfaxad nakayañu, Sem 500 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad 35 añu juunu uwanu ya' na Sélah nakayamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sélah nakayañu Arfaxad 403 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sélah 30 añu juunu uwanu ya' na Éber nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Éber nakayañu, Sélah 403 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Éber 34 añu juunu uwanu ya' na Péleg nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Péleg nakayañu, Éber 430 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg 30 añu juunu uwanu ya' na Reú nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reú nakayañu, Péleg 209 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reú 32 añu juunu uwanu ya' na Serug nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug nakayañu, Reú 207 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug 30 añu juunu uwanu ya' na Nahor nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor nakayañu, Serug 200 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor 29 añu juunu uwanu ya' na Térah nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Térah nakayañu Nahor 119 añu kayu manchutu, naa unbeenala bain, naa supu na'mala bain kayu miyandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térah 70 añu tiyañu, ya' nala Abram bain, Nahor bain, Harán bain nakayala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Entsalaa Térahnu sera' jimu chachilla deeve: Térahya naa Abramchi bain, naa Nahorchi bain, naa Haránchi bain ya' apawaami. Tsenmala Haránya Lot' ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tsejturen Haránya ya' apa Térah kayu peyaindyuren ajke' peyami, ya' nakayanu tena Caldeasha, tsandityu' bain, Babilonia tusha, Ur tenanuren. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramya Sarainu supungami, tsenmala Nahorya Milcánu supungami. Entsa Milcáya Harán' na'mawaami, Iscá' uñama. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tsaaren Saraiya na miyandinu jutyuwaami, navityu shinbu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térahya Babilonia tusha, Ur pebulunu lu' jimi, Canaán tusha jinu, tsejtu yaba ya' na Abramnu bain, naa Harán' nanu, tsandityu'ba, ya' paña Lotnu bain, naa ya' suya Sarainu bain miya' jimi. Tsaaren Harán pebulunu jiimin, junu tsai chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tsejtu Térah junu Harán pebulunu peyami 205 añu juunu uwanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma malu Abramnu Yavé tsandimi: In keewaanu juuwaashu juntsa tusha jinu, naa ñu' tu bain, naa ñu' paandelanu bain, naa ñu' apa' yanu bain shuike' jide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ñunu sera' jimu chachillanaa aa bulu chachi tiwaanu tsuyu, tsenmin ñunuya mika ura' ikare' naaju chachillachiba dekeraa ruku tiwaanu tsuyu, tsenmala naa veela bain ñu' mityaren inchi mika ura' inu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mun ñunu inchi mika ura' jusa detiñuba, i bain yalanu mika ura' ikaanu tsuyu, tsenmin mun ñunu inchi firu' isa tya' depañuba, i bain yalanu firu' ikaanu tsuyu; tsenmin ñu' mityaren kumuinchi entsa tu' chumu chachillanu iya mika ura' de-ikaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tsenñu Yavé naake uudenguiñuba Abram juntsaitu, Harán pebulunu Lotba lu' jimi. Tsejtu Canaán tusha jinu lu' jindu, Abram 75 añu juuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram, ya' shinbu Sarainu bain, ya' apiña Lotnu bain, tsenmin naa kumuinchi ya ti taju' bain detakikemi, tsenmin Harán pebulunu ya' chachi miyandiñu jumulanu bain demiya' jiimi. Tsejtu Canaán tusha devijitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram juntsa tenatala depullai' Siquem pebulubi vijitu, Dioschin juu ma ensina chi ya' mumu Moré chi chunubi jimi. Tsenñu juntsa tinbunu Canaánnu sera' jimu chachilla juntsa tenatala chumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Tsenñu Yavé junu Abramnu katawatu tsandimi: Entsa tu ñunu sera' jimulanu kuwanu tsuyu, timi. Tsenñu Abram Dioschi ufeenda tsure' ju'kenunu main ke' chujtimi, junaa yanu katawañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Tsejtu bene Betel pebulunu pensanguiñuya pajlanu pasha kuyinbenainsha jimi. Tsejtu junu kajdi' tsumi. Ya' kajdi' chunu tenanu keeñu Betel pebuluya pajvinshaa tiyami, tsenmala Ai pebuluya pajlainshaa tiyami. Tsejtu Abram ya' chunu tenanu bain ufeenda tsure' ju'kenunu kamain mantu, Yavé' mumunu pakami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tsejtu bene jayu jayu jinchin tiba den chutyu Négueb tusha jintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Juntsa tinbutala juntsa tu tenasha tiba pure' yamuj tiyaiñu ti fin tsaa tiyaila, tsenñu Abram Egiptosha jimi jayu tinbu' mitya chunu, matyu ya' chunu tenanuya ti fin tsaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tsejtu yumaa Egiptosha devijindu, Abram ya' shinbu Sarainu tsandimi: Uwain, ñu uukeraa shinbuñuba miyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tsa' mitya Egipto' chulla nei'ba ñunu katamin: Entsa shinbuya juntsa ruku' shinbuñuve, tinu dejuve. Tsejtu inuya detute', ñunuya ka' jiinu ju' bain tsainu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tsa' mitya iya tiba in jutyu, matyu ñu' mityaren tutan jutyu, yala tsa detinmalaya in tsujkiyu tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tsenñu Abram Egiptobi vijinmalan, uwain Egipto' chulla, juntsa shinbunu tsamantsa uukeraañu katala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tsenñu Egipto' rei, tsandityu'ba faraón tiitinu' balela bain katala, tsejtu faraónnu ji' wainla, juntsa shinbu mika uukerave, titu. Tsejtu bene Sarainu faraón' chunu yasha ta'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tsejtu faraón, Sarai' mityan Abramnu tiba uraanuu dekemi. Tsangue' naa uveja juula bain, naa wagara juula bain, naa yachi tiba kiikemu chachilla juula bain, naa buru juula bain, naa kameyu juula bain demekikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tsenñuren Sarai' mityan Yavéya faraónnu bain, naa ya' chachillanu bain pure' diipeya eeke' taaju de-iware' puitemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tsenñu faraón, Abramnu ya' junga mikatu tsandimi: ¿Nenñunguiyu inu entsanguemi? ¿Nenñaa inu entsa shinbu ñu' shinbuñuba wandi'tuuyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ñuya ñu' tsujkive tiwa, tsejtu naa in shinbu tireñuba tirekaakenu kive. Tsaañu bain, challa ñu' shinbunu manga' miide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tsejtu faraón ya' suutadulanu uudenguetu, Abramnu bain, ya' shinbunu bain, tsenmin ya ti tañu bain kumuinchi juntsalaba Egiptosha me-e'laadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram ya' shinbuba, naa yachi tiba tanañu jumula bain demanga' Egiptonu malu' miitu, manen tiba den chutyu Négueb tusha miimi. Tsenñu ya' apiña Lot bain yaibaren miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram yuj tarukumi, naa animaala bain, naa lushi kenu jeru bain, naa uru bain pure' ta' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Tiba den chutyu Négueb tusha chutu jayu jayu miinchiren Betel pebulu deechusha miimi, tsejtu junu malu' miitu, ya' uma ajke' jitu viji' chunu tenabiren miimi, Betel pebulu, Ai pebuluba chunu kejtaa tenatala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Junaa Yavéchi ufeenda tsure' ju'kenunu main ke' chujtimuwaami. Tsejtu junu Yavé' mumunu manbakami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Naa Lot bain ya' apiku Abram tsaaya, naa uveja juula, naa wagaa juula, naa yaba bulu nemu chachilla bain pure' miyaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tsa deju', yala' chuinshaya naake' kumuinchi animaalanu millangue awakaren tsaala, tsenmin mu bain tiba pure' tandene jude' mitya, naake' bulu chun tsaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tsa' mitya Abram' wagaa washkemu chachilla, Lot' wagaa washkemu chachillaba vingue vinguekila. Tsenmin juntsa tinbunu naa Canaánnu sera' jimula bain, naa Fereznu sera' jimula bain jundalan chumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tsenñu Abram ma malu Lotnu tsandimi: Iya ñubaya paande deeyu. Tsa' mitya laatala peletu juu urajtuve, naa ñu' wagaa washkemu chachilla bain, in wagaa washkemu chachillaba peletu kiikentsuñu urajtuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ñu naaju tu mujñuba kanu kumuinchi junga jatsanave. Tsa' mitya iba velasa tenve. Ñu jalandyasha jinmalaya, iyaa urandyasha jinu tsuyu; tsaaren ñu urandyasha jinmalaya, iyaa jalandyasha jinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tsenñu Lot Jordán pisha ke-eetu tsamantsa aa jatsuwa juu Sóar kaa pebulu deechusha tsaa pi puu jina' Yavé' Eden vijtyanu keekiñuna kata-eemi, matyu Egipto keraawaami. (Tsaawaamiya kayu Yavé, naa Sodoma pebulunu bain, naa Gomorra pebulunu bain dekike' pirendyunu uwanaa tsaawaami.) ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tsejtu Lot kumuinchi juntsa Jordán aa jatsuwaa mi'ke' katu, ya' punu tenanu pensangue' keeñuya, pajlanu deechushaa jimi. Entsaitaa Abram Lotba vela' jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Tsenñu Abramya Canaán tusha chunu shuwanmala, Lotya jatsuwasha chumu pebulutala chunu jimi, Sodoma pebulu keesha, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","tsaaren junga chumu chachillaya firu' kiikemu deju', Yavénu ujcha lan chuchunamu jula; juntsanainshaa Lot ji' chuimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tsenñu Lot Abramnu vela' jiñu, bene Yavé tsandimi Abramnu: Aanu ñu' chunu tenanu ñu naana'ba ura' ke-eekide nurtesha bain, sursha bain, pajlainsha bain, naa pajvinsha bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Iya kumuinchi ñu kata-eekintsushu juntsa tu ñunu dekuwanu tsuyu, tsenmala naa-uwanuba ñu' tu ju', naa bene ñunu sera' jimulachi bain junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tsenmin ñunu sera' jimu chachillanu ñiipeeba juñu seenguen tsanguenu tsuyu. Tsa' mitya, naajunga ñiipeeba mikanu jutyushu, naa ñunu sera' jimu chachilla bain mi'nu jutyui seranu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","¡Tsa' mitya kujpa' jide! Tsai' entsa tu, naaju bareñu bain, naaju bunguñu bain, deneide; iya ñunu kuwanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tsenñu Abram, ya' yapaya demangatu, Mamré mumu ruku' ensina chi chunu tenashaa yapaya ke' manchuimi, Hebrón pebulu keesha. Tsejtu junaa Yavénu balengure' keewaanu, ufeenda tsure' ju'kenunu main ke' chujtimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Jumaa tinbunu Sinar pebuluchi rei chumu Amrafel bain, naa Elasar pebuluchi rei chumu Arioc bain, naa Elam pebuluchi rei chumu Quedorlaómer bain, naa Goím pebuluchi rei chumu Tidal bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","mantsa rei chumulanu vinguila: Sodoma rei Beranu bain, Gomorra rei Birsánu bain, Admá pebulu rei Sinabnu bain, Seboím pebulu rei Semébernu bain, tsenmin Bela tityumee, Sóar tiitinu pebulu reinu bain kundaa vinguela. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tsenñu entsa man reila yala' suutadulanu Sidim jatsuwanu dewakukaala, Pemu tinu lamaa juinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Rei Quedorlaómerya juntsa man reilanu 12 añu benga' tyullaa tanamuwaami. Tsaaren 13 añushaya juntsa man reila de-ajaatse'tuware', vinguenu tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Tsenñu juntsa masku añuchi rei Quedorlaómer, naa yaba buunamu reila bain, Astarot Carnaim tusha jila, tsejtu junu Refanu sera' jimu chachillanu vingue' puila. Bene Ham tusha Zuznu sera' jimu chachillanu bain puila, tsenmala Emnu sera' jimu chachillanuya Savé-quiriataim tusha vingue' puila, tsenmin Hornu sera' jimu chachillanu bain Seír kuyisha debenga' tyuli' tsaa tiba den chutyu keesha El-parán tena jingue bendaakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tsai' Quedorlaómer yaba nemulaba miindu, En-mispat tityumee, Cadés tiitinu tenanu vijila. Tsejtu Amalecnu sera' jimu chachilla' chundala miindu yalanu debenga' tyulikila, tsenmin tsaren kila Hasesón-tamar tusha chumu Amornu sera' jimu chachillanu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Tsenñu Sodomanu chumu rei bain, naa Gomorranu chumu rei bain, naa Admánu chumu rei bain, naa Seboímnu chumu rei bain, naa Belanu, tsandityu' bain, Sóarnu chumu rei bain, Sidim jatsuwasha jila. Tsejtu junu entsa man reila, naa Elam pebuluchi rei Quedorlaómernu bain, naa Goím pebuluchi rei Tidalnu bain, naa Sinar pebuluchi rei Amrafelnu bain, tsenmin Elasar pebuluchi rei Ariocnu bain, entsa taapai reilanu vinguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Juntsa Sidim jatsuwatala maalin tujuru juja'tenami. Tsenñu Sodoma rei bain, Gomorra rei bain nepiyandu, juntsa jurutala devi' pantsudila, tsenmala mantsa reilaya kuyitala tene nepiyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tsejtu puimulaya Sodoma pebulunu bain, naa Gomorra pebulunu bain ti tadeeñuba dekake', naa yala' fintsumi uukara bain dekake', junu demalu' miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tsejtu Sodoma pebulunaa, Abram' apiña Lot bain chumuwaañu' mitya, yanu bain ka' peesu chachi juu tireke' tsaa ya ti tañu bain juntsalaba deka' jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tsenñu ma unbere peyai'mujchi livee i' nepimu, hebreo chachi tiitinu ruku Abramnu, matyu Mamré tinu ruku Amornu sera' jimu chachi' ensina chi paasha chuñu' mitya, junga jitu dewanditimi. Mamréya, Escolchi bain, Anerchi bain naatalawaami; yalaa Abramba veta' veta' balelave'nu ti' tsai shuwamuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tsenñu Abram ya' apiña peesu chachi juu kayañuba mijatu, yaba chu' awamula tiba kenu mijakaralanu tene 318 ruku mi'ke' katu, juntsa reilanu Dan pebulu nurtesha jingue bendaa kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tsejtu dekepeñu Abram yachi tiba kiikemu chachillaba juntsa reilanu vinguiji', ya' chachillanu mantsa mantsa devela' eetu, mijaindetyu ke' mijakaake', debenga' tyuli', Damasco pebulunu pensanguenmalaya nurtesha chumu Hobá pebulubi jingue bendaakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Tsanguetu juntsa reila' tiba deka' jiñu jumula demanchipakila. Tsanguitaa Abram ya' apiña Lotnu livee kemi, tsenmin kumuinchi ya ti tawaañuba juntsala bain demangake', naa supulanu bain, tsenmin kayu vee chachillanu bain deliveekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram, Quedorlaómernu bain, naa yaba buunamu reilanu bain depulla' miintsuñu, Sodoma pebulunu rei pumu ruku Abramba katawanu ti', Savé tinu jatsuwasha ji' keenami, challa Reichi tinu jatsuwasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tsenñu Salem pebuluchi rei jumu Melquisedec pan bain, binu bain kala' kumi, yaa aa kai'sha chumu Dioschi chachilla' mitya Diosnu kalen jimu ruku juwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tsejtu Melquisedec, Abramnu Dioschi mika ura' isa ti' patu, entsandimi: Naa selu bain, naa tu bain kemu aa kai'sha chumu Dios, Abramnu mika ura' ikaasa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tsenmin aa kai'sha chumu Dios yuj urave tikayasa, ñunu ñu' kundaalanu ñu' tyaapanu kuwa' puikare' mitya, timi. Tsenñu Abram Melquisedecnu, reilanu machi'ke' tiba demangañu jumu paitya pela vele' manbaate kumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tsenñu bene Sodoma pebulu rei, Abramnu tsandimi: Kumuinchi livee kikishu juntsa chachillanuya inu demanguwaka, tsaaren yala ti taawa deeñuba juntsaya deka' shuwade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tsenñuren Abram tsandimi: Aa kai'sha chumu Diosnu paka' uwain tsanguenbera kenu tsuyu ti', in tyaapa usake' naa selu bain, naa tu bain kemu Yavénu entsandintsuyu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Naa jilu juuñu bain, naa sandaliachi ma chuwa juuñu bain, naa ñuchi ti juuñu bain kan jutyuyu tintsuyu, tsenmalaa ñu: In mityaa tsai' taruku tiyave, ti'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tsenmin iyaa tiba kan jutyuyu, tsaaren in chachilla yumaa fidekishu juntsaya naake' manguwan tsaayu. Tsaaren iba bulu jimula Aner bain, Escol bain, naa Mamré bain, yalaa yala' mityaya tyeeba kanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Tsejtu bene entsa-i' puiñu Abramnu Yavé kipin tsa-i' katawatu entsandimi: Abram, jeetyatyude, iyaa ñunu la'kamu juyu. Tsa' mitya ñu' kakenuushu juntsa, tsamantsa aawa junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tsenñu Abram pakatu tsandimi: Bale Ruku Yavé, ñuya mive naa iya na miyajtuñu bain. Tsaaba ¿tyeenguenaa in kakenu juuwaashu juntsa balenu jun? Ñuya naa maliba inu na kuwaindyuñu, in miyanu chachi Eliézer, Damasco pebulu chachee, inchi tiba tañu jumula demandashuwamu tiyanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tsenñu Yavé manbakatu tsandimi: Juntsa rukaa ñuchi tiba tañu jumula demandashuwanu jutyuve. Ura ñu' na jumaa ñuchi tiba tañu jumula demandashuwamu junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Tsejtu Abramnu Yavé avindala miya' luitu, tsandimi: Selusha ke'laakide, tsejtu ñuren mi'nuu jutuya kumuinchi makara mi'de. Uwain ñunu sera' jimu chachilla bain juntsai seranu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Tsenñu Yavé naatiñuba Abram keenguemi. Tsenñaa Yavé, ya naakesa tyañuba tsanguen chumu kuremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tsejtu Yavé tsandimi: Iyaa ñunu Babilonia tusha, Ur pebulubi churen, entsa tu kuwanu kalare' jamu Yavéyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tsenñu Abram tsandimi: Bale Ruku Yavé, ¿nejtaa entsa tu uwain inchi tiyanuuñuba iya entsai mijanu juwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tsenñu Dios tsandimi: Ma wagaa bain, ma supu chibu bain, naa llupu uveja bain main taade, tsaaren main main pen añu juundene; tsenmin wa'pupu bain main, naa paluma kaana bain main taade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tsenñu Abram kumuinchi entsa animaala Diosa' junga tajimi; tsejtu main main kejtaa dechilike', manba manba kaju'talake tsuumi. Tsaaren pishkulanuya chilindyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Tsenñu juntsa pemu tsumu animaalanu, pete fimu pishkula pajtya pajtyaila, tsenñuren Abram majukaakaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tsejtu dekependu' kakensha Abram tsamantsa kasandya' kasmi. Tsenñu wajtunuren, ya' keetala yapijurui paijñu, Abram yuj jeetyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tsenñu Yavé tsandimi: Ñu mijasa tenve, naa ñunu sera' jimu chachilla bene vee tusha deji' chu', yaichi manda-i' taawasha kemu chachi juu detiya', firu' in dechu', 400 añu tsaa chunu deeñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tsaaren naaju chachillaa ñullanu yaichi manda-i' taawasha kemu chachi detireñuba, juntsalanu iya taaju iware' puitenu tsuyu, tsenmala bene ñunu sera' jimula demalivee-i', junu tiba pure' taa malu' miinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tsaaren ñuya derukutu tiba jutyu, nejuu chu' peya', ñu' tinbu rukulaba manbuudiinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tsenmala juntsa 400 añu insha ñunu sera' jimula entsa tunu bene maanu detsuve. Tsaaren ñunu entsa tu kayu kuwaindyumiya, chaiba Amornu sera' jimu chachilla firu' deke' juntsan mitya tu chipainuu kendetyuñu' mityaa tsaayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tsejtu yumaa pajta dishu' viñu deyajuruinu uwanu ma piyama ñivijcha butyutintsu kataamin, naa ñinbuchu bain main unsururuu katawami; tsai' junu chillaa tsumu animaala' kejtala dapulla pullaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tsejtu juntsa malunun Abramnu Yavé yaba veta' veta' tsanguedaa titu, entsandimi: Entsa tu bene ñunu sera' jimu chachillanu kuwanu tsuyu, matyu Egipto pibi kuwamin, Éufrates aa pibi jingue kuwanu tsuyu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ura pañuya Quennu sera' jimu chachilla' tu bain, naa Queniznu sera' jimu chachilla' tu bain, naa Cadmonnu sera' jimu chachilla' tu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","naa Hetnu sera' jimu chachilla' tu bain, naa Fereznu sera' jimu chachilla' tu bain, naa Refanu sera' jimu chachilla' tu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","naa Amornu sera' jimu chachilla' tu bain, naa Canaánnu sera' jimu chachilla' tu bain, naa Gergesnu sera' jimu chachilla' tu bain, naa Jebúsnu chumu chachilla' tu bain dekuwanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, ya' ruku Abramnu naka' kuwakenuu jutyumi, tsaaren Egiptosha chumu shinbu yachi manda-imu, ya' mumu Agarnu miyawaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tsejtu Sarai Abramnu tsandimi: Yavéya inu navikareindyuñu' mitya, inchi manda-imu shinbu Agarba tsude; ñu yaba tsainmalaya, iya ya' mityaa na miyandikeenaaba jukeemeete, timi. Tsenñu Abram, Sarai tsandiñu, meenguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tsenñu Sarai, yachi manda-i-iimu Egipto cha' shinbu Agarnu ka', tsaa Abramba tyushtekemi. Entsaimiya Abram Canaán tusha yumaa paitya añu chuntsaa juntsaa puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Tsenñu Abram Agarnu ka' yaba tsuñu, Agar navimi. Tsejtu Agar naviimiren yanu mandanguemu shinbu Sarainu, yuj jatsa' kure' keendundami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tsenñu Sarai Abramnu tsandimi: Agar inu jatsa' kure' keekeekiñuba juntsaya ñu' kuipave. Iyaa yanu ñuchi kama shinbu juu tirenu kuwayu, tsaanun challa entsai' navimee yaa kayu inu pullayu tyatyaive. Tsa' mitya Yavéya mijasa naa ñaa kuipañu bain, naa iyaa kuipañu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tsenñu Abram pakatu tsandimi: Ñu' mandanguenu shinbunuya ñu naakenu tenñuba tsanguide, timi. Tsenñu Sarai pure' firu' kiikiñu, tsaa Agar nepiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tsenñu Yavé' anjee tiba den chutyuin tenasha Sur mumu tena jinu miñu keesha, tu tainsha pi fale' pusu tiyamu kelunu Agarnu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Tsejtu tsandimi: Saraichi manda-imu shinbu Agar, ¿nukaa pu' jandu iyu, tsenmin nukaa jindu iyu? timi. Tsenñu Agar pakatu: Inu mandanguemu shinbu Sarainu nepiya' nendu iyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tsenñu Yavé' anjee tsandimi: Ñunu mandanguemu shinbu' junga miide, tsejtu ya naa naatiñu bain kumuinchi meenguide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Tsenmin Yavé' anjee kayu tsandimi: Bene ñunu sera' jimu chachillanu bain pure' seewaakenu tsuyu. Tsangue' muba demi'nu jutyungaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tsenmin ñu napu' mitya nakanu tsuve, tsejtu Ismael mumaa pude, Yavéya ñu llakingues neñuba meeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tsenmin Ismaelya jeendala wajkujtu buru juuñuu junu tsuve, tsenmin naajulanu bain maaliren vinguenu tsuve, tsenmala veela bain ya maali juunuren vinguenu detsuve, tsenmin naa mutyaindetyu bain ya' naatalala' ajuushaa yapaya ke' chunu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tsejtu Agarnu Yavé papatiñu, ya bain Yavénu mumu putu entsandimi: Ñuya inu keenamu Diosve, timi. Tsejtu: “¿Uwain inu keekeenamunu katatunguiwa?” tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tsa' mityaa naa juntsa pusunu bain “Chu' inu keenamu' pusu” mumu pumi. Tsenñu juntsa pusu Cadés bain, naa Béred bain chunu kejtaa tenashaa jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tsenñu Agar, Abramnu na main ka' kuwañu, Ismael mumu pumi Abram. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Tsenñu Ismael nakayanu tinbunu Abram 86 añu juuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram 99 añu juunu uwanu Yavé yanu katawatu tsandimi: Iyaa tiba kekaanuu jumu Diosyu. Tsa' mitya in ajuushaya, ñu' chungama tiba deechu' juu chude. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tsenmala iya ñuba veta' veta' naakenu pa'ba tsangue', ñunu bene sera' jimu chachillanu pure' seewaakenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Tsenñu Abram, Dios kayu yanu pa' jintsuren teledi' ya' llashkapa tunu tapa'kanbera waikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Tsenñu Dios tsandimi: Entsaa iya ñuba veta' veta' tsanguedaa tiñu jumuve: ñuya main main ma uñichi uuden juu vee vee chachi chumula' apa junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tsenmin umaa Abram mumu jutyunu tsuve. Challaya ñu' mumu Abrahamya majunu tsuve, matyu iya ñunu main main ma uñichi uuden juu pure' vee vee chachi chumula' apa tirenuuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tsenmin ñunu bene sera' jimu chachillanu pure' serawaakenu tsuyu; naa vee vee chachi chumula bain ñunu tene sera' ji', mantsala rei miyaa bain tiyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Iya ñuba veta' veta' tsanguedaa ti', naa ñunu sera' jimu chachillanu bain bene tsaren kenu tsuyu tiñu jumuya entsaa juntsave: Iyaa ñu' Dios junu tsuyu, naa ñunu bene sera' jimulachi bain iren naa-uwanuba yala' Dios junu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ñunu bain, naa ñunu sera' jimulanu bain, challa ñu' chunashu juntsa Canaán tu dekuwanu tsuyu naa-uwanuba ñuichi junutsu, tsenmala iyaa ñulla' Dios junu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Tsenmin Dios, Abrahamnu kayu patu tsandimi: Tsaaren ñu bain, naa ñunu sera' jimula bain, kayu jungajte sera' jimula bain, iba veta' veta' naakenu pa'ba juntsanu naa-uwanuba meenguidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tsenmin umaa kumuinchi ñulla unbee rukulaya Dioschi deeve ti' señas junu detsuve; juntsaa iya ñuiba veta' veta' tsanguenu tsuyu ti' pañu keewara junu tsuve. Tsaañu' mitya kumuinchi ñulla, naa ñullanu sera' jimulanu bain tsarenguenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tsa' mitya ñulla llu kika dedaakanmalaa, iya ñuiba veta' veta' tyeenguenu pamuñuba juntsaa keewara junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Uma ajkeshaa ñuitala naajulaba unbeena na dekayanmalaya mandishpen malu insha Dioschive ti' juntsangue' señas kiikenu dejuve, naa ñulla' kaillanu bain, naa ñulla' yasha nakayamu kaillanu bain, naa vee chachilla ñuichi manda-inu ati'kayamulanu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tsa' mitya ñu' yasha nakayamulanu bain, naa ñu' lushinchi ati'kañu manda-imu chachillanu bain munuba laakaatyumujchi tsaandene kenu juve. Tsenmalaa iya ñullanu veta' veta' tsanguedaa tiñu keewara jumu ñulla' allanu naa-uwanuba ñulla' chungamaya tsananu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tsaaren mun Dioschi kuranu ti' señas jutyuya, ñulla' kejtsapala juka'laranu tsuve, yaa iya ñuiba veta' veta' tsanguedaa tiñu palaanu meenguityun mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Tsejtu Abrahamnu Dios entsa bain tsandimi: Ñu' shinbu umaa Sarai mumu jutyunu tsuve. Challaa ya' mumu Sara junu tsuve, Sara titu “rei' na'ma” titundive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yanu ura' ikaanu tsuyu, tsejtu Saranu na main kakare' ñunu kuwanu tsuyu. Tsenmala yaa vee vee chumu chachilla' ama junu tsuve. Tsenmin juntsalanu sera' jimulanaa rei bain tiya' chuchudinu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tsenñu Abraham ya' llashkapa tunu tapa'kanbera waike' entsangue pensanguetu uukami: “¿Tsejtu ma unbere 100 añu ma juuba, na miyandi' ya' apa tiyanu juchunga? ¿Tsenmin Sara bain 90 añu ma juuba nakachunga?” tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tsejtu Diosnu tsandimi: ¡Tsaaba juñuya Ismaelya ñuchi ura' in chusa! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tsenñu Abrahamnu Dios pakatu tsandimi: Iya patyeeshu juntsaa ñu' shinbu Saraa ñunu na main ka' kuwanu juve titundiyu, tsenmala ñu Isaac mumu punu tsuve. Tsejtu iya veta' veta' tsanguedaa tyeeshu juntsa yabaa tsangue' jinu tsuyu, tsenmee naa yanu bene sera' jimu chachillanu bain veta' veta' ñuiba naakenu pa'ba naa-uwanuba tsangues jintsunu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tsenmin Ismaelnu bain ura' ikaanu tsuyu, ñu' pañu palaanu mere' mitya. Tsejtu na pure' miyandiwaakenu tsuyu, tsangue' naa yanu sera' jimu chachillanu bain pure' seenguikaakenu tsuyu. Ismaelya 12 uñilachi ya' apa junu tsuve, tsenmin yanu ma aa bulu chachilla' apa tirenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tsaaren iya veta' veta' tsanguedaa tiñu jumuya Isaacbaa tsanguenu tsuyu, ñunu masku añusha entsa malutala Sara naka' kuwakenu juushu juntsa naba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Tsejtu Abrahamba Dios dekuindake' dyatu, junu malu' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tsenñu Dios yanu naake uudenguiñuba tsanguetu juntsa malunun Abraham ya' na Ismaelnu Dioschi señas kemi, tsenmin naa yachi tiba kiikemu chachilla ya' yanu nakayamulanu bain, naa ya' lushinchi ati'kayamu chachillanu bain, matyu kumuinchi ya' yanu chumu unbee rukulanuya señas dekikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham 99 añu juunu uwanaa Dioschi señas imi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tsenmala ya' na Ismaelya 13 añu juunu uwanaa señas imi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tsa' mitya ma malunun Abraham bain, naa ya' na Ismael bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","naa ya' yanu kumuinchi unbee ruku chumula, matyu yachi tiba kiikemu chachilla ya' yanu nakayamula bain, naa ya' lushinchi vee chachillanu ati'kañu kayamula bain Dioschi señas ila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahamnu Yavé katawami, Mamré mumu cha' ruku' ensina chi paasha, Abraham ya' yapaya juukapanu chunanu uwanu, matyu pajta katyu ura iinutala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham mishu jeeke' ke-eetu pen ruku ya' ajuusha uyudena katami. Tsejtu katamin yalanu mikanu kujpaimi. Tsai' teledi' llashkapa tunu tapa'kanbera waiketu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","tsandimi: In bale ruku, iya ñuchi tiba kiikemu ruku ura' katawañuya, tsantsaya te' miityude tinu tenve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ñullaren tsaa demutyañuya pi jayu taakaanu tsuyu ñulla neepa manbitsaanudetsu, tsai' jayu entsa chi faapanbelesha lekanudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tsaaren ñulla entsa ñuichi tiba kiikemu ruku' chuinsha depuijañu' mitya, ñulla kayu ajkesha miji'mujchin jayu mandeelanudetsu iya ka tyeeba fikenuuñuba taanu tsuyu, timi. Tsenñu yala tsandila: Tsaaya tsanguiñuba urave, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tsejtu Abraham ya' yapayasha mavitu, Saranu tsandimi: ¡Apain! mika 20 kiluya, pan kenu ura' llujpe tene ka', pan te' kide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tsejtu Abraham yangachi wagaa panbasha ji', llupu wagaa kayu nakululuu mi'ke' ka', yachi manda-i' yanu washkemu chachinu kuwami. Tsenñu entsa ruku wajtunun jeke akaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tsejtu Abraham wagaa alla akara katu, naa kitsu bain, naa chu'pi bain ka' taji' yalanu kuwami. Tsejtu yala juntsa chi panbelenu panda findetsun kayu ti demenestendyañuba ka' kuwa kuwakenu junga yala' keesha kalen uyunami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tsejtu juntsa yaa nemu rukula bene Abrahamnu pake'meetu tsandila: ¿Ñu' shinbu Sara nuka naanatun? tila. Tsenñu Abraham pakatu: Junga yapayasha putun tsaave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tsenñu ma ruku tsandimi: Ma añu insha manen yaa janu tsuyu, tsenmala juntsa tinbunaa ñu' shinbu yumaa na main miyanu tsuve, timi. Tsenñu Sara juntsa tsandimu ruku' benesha yapaya juukapasha puturen kumuinchi naati kuinda kendetsuñuba meenami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Tsaaren Abraham bain, naa Sara bain yumaa pure' rukuula, tsenmin Saraya shinbunchin naa asa bain yumaa mangueewaatyu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tsa' mitya Sara entsandyatu dus uukami: “¿Naa itaa ka iya mallee naka' sunbechaanga, challa naa in ruku bain, naa i bain tsamantsa ruku deju'ba?” tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tsenñu Abrahamnu Yavé tsandimi: ¿Nenñundi Sara yumaa deshinbuuya na mallee kanu jutuuwa tya' uukantsumi? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Tsejtu ¿Yavéchi tiiñuba ken jutyuu juñanga? Masku añuchi juntsainu tsuve tiñu tinbutala manen maanu tsuyu, tsenmala Sara yumaa na main miyanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Yavé entsandiñu, Sara meetu, jeetyami, tsejtu anbukuinda ketu entsandimi: Iyaa uukabandindyuyu, timi. Tsenñu Yavé tsandimi: Tsa jutyuve, uwain ñu uukave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tsejtu bene panda fi' demangujtu juntsa rukula Sodoma jijiinu deechushaa ke-eedi' jindetsuñu Abraham me-eesuukiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","18","Tsenñu Yavé entsangue pensanguemi: “¿Abrahamnaa tsamantsa pude aa bulu chachilla tiyanu deeñu' mitya, tsenmin ya' mityaa kumuinchi chachilla Dioschi ura' inu deeñu' mitya, yanu wandinjui'tuuwa, iya naakenu ju'ba? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tsenmin yaa, ya' kaillanu bain, naa yanu bene sera' jimu chachillanu bain in uuden jumula mijakare', tsenmin tyee ura' deechu' juñu bain juntsaa kikaanutsu iya yanaa mi'ke' kayu, tsenmalaa iya tsanguenu juyu tyeeshu juntsa bain kumuinchi tsainutsu.” ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tsejtu Yavé tsandimi: Sodoma pebulu' chulla bain, naa Gomorra pebulu' chulla bain firu' kenchiya tsamantsa dajka deeve tiidetive. Tsa' mitya yala' kenu ujchaya tsamantsa urajtu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tsaañu' mitya challa junga jindu iyu. Yala' ujcha tsamantsa urajtu juñu, inu naati pa' paka pakadekiñuba junga jitaa uwain tsaañuba mijanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pai ruku yaba nemulaya Sodoma pebulusha jila, tsenñu Abrahamya Yavé' ajuunun uina shuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Tsejtu Yavé' junga kayu kalen jiitu, entsandi pake'meemi: ¿Kuipajtulanu bain, kuipalaba bulu dekike' pirenujtuuyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Tsandenna juntsa pebulunu kuipajtu chachilla mika manchungaa dechuñuba, juntsa 50 chachilla' mitya juuñuba livee kityu' tsaa dekike' pirenujtuuyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tsenmin kuipajtu chachillanu, kuipa juu chachillaba bulu detu'nu pensaa jutyumee tenve ñuya, yala buluren firu' kiikemuñungue ke' puitenu. ¡Juntsaa tsangueñu urajtuve! ¿Tsejtu ñaa kumuinchi entsa tunu kavitu kemu bale ruku jutyuu? ¿Tsejtu kuipa jutyu chachilla' mitya naakeñu urañuba juntsa ken jui'tuuyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tsenñu Yavé tsandimi: Uwain Sodoma pebulunu tiba kuipajtu chachilla manchungaa dechuñu katashu juntsaa, yala' mityaren kumuinchi junu chumulanu tibanguen jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tsenñu Abraham manbatu tsandimi: Naa ñu Dios juñu, iyaa ne chachi juju', ñunu tsandinu jutyuñuba, tsandintsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tsandenna ¿kuipajtula 50 chachi tiyanu manda faataa juñuba, juntsa manda faata jumula' mityaba, kumuinchi pebulu dekike' pirenujtuuyu? timi. Tsenñu Yavé tsandimi: Uwain taapaichunga mandaaba kuipajtu katashu juntsaa, dekike' piren jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tsandenna kuipajtu chachilla 40 ne judeeñaa ¿naa kenu juyu? timi Abraham. Tsenñu Yavé tsandimi: Juntsa 40 chachilla' mityan pebulu dekike' piren jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tsenñu Abraham u'ta manditu tsandimi: Juntsanun patintsuñu inu ajaavityuka. Tsandenna penchungaren kuipajtu kataakitaa, ¿naa kenu juyu? timi. Tsenñu Yavé tsa mandimi: Naa 30 judeeñu bain, juntsa pebulunu dekike' piren jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Tsenñu Abraham kayu pa' jindu tsandimi: In Bale Ruku, naa ñunu entsandintsun jutyuñuba tsandintsuyu, tsandenna kuipajtu chachilla mika mancha'luraaba kataakishu juntsaa, ¿naa kenu juyu? timi. Tsenñu Yavé manbakatu tsandimi: Juntsa 20 chachilla' mityan pebulunu dekike' piren jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Tsenñun Abraham kayu pa' jindu tsandimi: Tsantsaya, in Bale Ruku, inu ajaavityuka, tsaaren entsan manbatinu tenve, tsenmin bulla manban jui'yu. ¿Tyee kenu juyu, tsandenna paityaaba kataakishu juntsaa? timi. Tsenñu Yavé tsandimi: Naa juntsa paitya' mitya bain, juntsa pebulunu dekike' piren jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Tsenñu Yavé Abrahamba depa' dyamiren yanu shuike' miiñu, Abraham ya' yapayasha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Yumaa ma dekependu' kakensha, juntsa pai anjeela Sodoma pebulusha vijila. Tsenñu Lot, pebulu vinu juukapasha cha' waku wakudinu tenanu chunatu, yalanu katamin, kujpa' jiimi, yalanu mikanu. Tsejtu teledi', llashkapa tusha tapa'kanbera waiketu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","tsandimi: Tsantsaya iya ñuichi tiba kiikemu ruku' yasha, entsa kepe kasnu vijadei. Tsenmin jungaa neepa bain manbitsaadei, tsa-i' ayu kepenenee miidei ñulla nuka jinu tsainduba, timi. Tsenñuren yala tsandila: Tsaave tennaren, lalaya chachilla' den nenu tenatalaa uma kepe tsudi' puinu detsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tsenñuren, Lot ya' yashaa miya' jinu ti' patintsuñu, yanu bendaake' jila. Tsejtu yasha dejiñu, Lot panda uu finuke ke' kuwa', naa pujkikaantsumi putyu pan bain ke' kuñu, juntsa yaajimu rukula fila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tsejtu kayu naa tsuba indetyuren kumuinchi junu Sodoma pebulunu chumu unbee rukulaya tsaa juntsa yanu yatai uidijila, mikaka unnaalabi julan kayu rukulabi jiin wa'dijila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Tsejtu Lotnu ui'nbashiitu entsandila: ¿Nuka naadenain ñu' yasha uma kepe jadeishu juntsa rukula? ¡Avindala kalaade! Lalanu yaiba tsunu tenve, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tsenñu Lot yaiba panu faatu, ya' benesha juukapa narake mallu'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Tsejtu tsandimi: In keranu rukula, tsantsaya entsa rukulanu tsamantsa firuuya kenu kityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Iya pai na'ma miyayu naajulanuba tsa-i' kerajtulanu tene. Yalanaa kalarenmala ñulla ti kendenñuba tsanguidei, tsaaren entsa rukulanuya tibanguityudei, yalaa in junga yaajamu chachi deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tsenñu yala tsandila: ¡Aanu baka' mijiide! ¿Ñuya vee mujtu chumu rukuren engu ja' chumee lalanu uudenguemu bale ruku tiyanu kikeechunga? ¡Tsaashu juntsaa challa ñunaa kayu yalanuba pullake firu' kenu detsuyu! tila. Tsandimin Lotnu jeke firu' kenu kedundalan, juukapa keesha dejiila leetyui-eenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tsenñuren juntsa yaanemu pai rukula tyaapa deta-ere' Lotnu manga' ya' ya juusha manbuke', juukapa mallukikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tsanguemin kumuinchi avindaa uinamulanu, naa kaa unnalanu bain, naa kayu rukulanu bain tsaa kapuka dedishpajtekaadekiñu, ya juukapa mi'ketindun katai'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Tsejtu juntsa yaanemu rukula Lotnu tsandila: ¿Enu kayu paande miyayu? Ñu' nalanu bain, ñu' na'malanu bain, naa ñu' kiyalanu bain, tsenmin munaa entsa pebulunu kayu paande miya'ba delumishti' enu nunbai jide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Entsa tenanu dekike' pirenu detsuyu, matyu naa-uwanuba entsa tenatala chumu chachilla firu' kiidekiñu kuinda Yavé mijatindu lalanu dekike' pirenu eeñu' mitya, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tsenñu Lot, ya' kiya tiyainuu jumulanu keejitu tsandimi: ¡Te' kujpa', entsa pebulunu lu' jidei! ¡Yavé entsa pebulunu dekike' pirenu juve! timi. Tsenñuren ya' kiya tiyainuu jumula, Lotya ne aike' pandundive tyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tsenñu yumaa ma dechayaintsuñu anjeela Lotnu entsandila: ¡Apain kujpa', ñu' shinbunu bain, naa ñu' pai na'malanu bain enu demanga' miide, lala entsa pebulunu dekike' pirendetsunmala ñui bain ika' taaju ki'nudetsu! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tsenñuren Lot te' lu'jinu kendyuñu, anjeela tsaa ya' tyaapanu ka' taluila, naa ya' shinbunu bain, naa ya' na'malanu bain demanga' tsaa pebulu avindaa mandaluila, Yavé yalanu tenbityañu' mitya livee kenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tsejtu pebulu avindaa demalutu, ma anjee tsandimi: ¡Yangachi ji' livee ide! Tsaaren benesha jayuuba mangue-eetyude; entsa jatsuwa tenanu nutalaba jaiba uidikatyude. Ñuren peyandendyuñuya kuyishaa jide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Tsenñuren Lot tsandimi: Bale Ruku, iya ñuchi tiba kiikemu chachinu ñu ura' ju' inu livee ke' pure' uraa kikentsuve. ¡Tsaaren jungaa jindendyuve! Kuyishaya jin jutyuyu, naa ma tsandaa jintsu bain Dioschi taaju i' puiwara inu tapa'kajanmalaya pekeya'ba ikeenu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tsaaren enu baanatyununu kaa pebulu juu main chuve. Inu juntsa kaa pebulushaa nepiya' ji' livee ikaaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tsandiñu anjee manbakatu: Ñu naatiñu bain tsanguenu tsuyu. Tsa' mitya entsa ñu manbatishu juntsa bain tsaren mangue' kaa pebulunuya dekike' piren jui'yu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","tsaaren challaren ¡apain! te' jide; ñuren juntsa pebulusha te' jindyuya kayu tiba kenu jutyuyu, timi. (Tsa' mityaa juntsa pebulu Sóar mumu vimi, matyu “añuñuu” titu.) ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tsejtu yumaa dechayaintsaa, Lot Sóar pebulusha tyuina jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tsenñu Yavéren naa Sodoma pebulunu bain, naa Gomorra pebulunu bain ñillu asufeeba juuya shuwa pajten tsangue' ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","juntsa keetala chumu pebululanuya, jundala chumu chachillanu bain millangaami, tsenmin juntsa jatsuwatala awamu buikiyalanu bain millangue ju'kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tsenñun Lot' shinbu ma uidika' benesha mangue-eemi, tsenmin tsaa tyayu tene tiya-i', cha' muute jui shuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Juntsa ayunchi Abraham kepenene kujpa' jimi, ya nunbanaa Yavéba kuinda ke'ba juntsa tenanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Tsejtu Sodoma deechusha bain, Gomorra deechusha bain, tsenmin kumuinchi juntsa aa jatsuwatala bain ke-eetu tsaa tusha ñivijcharen luintsu kataakemi, matyu ñillu tsamantsangue llu'kandu ñivijcha e'laren tsanguentsu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Dios entsanguitaa Lot' chunu jatsuwasha chumu pebululanu millangaami, tsaaren Abrahamnu mandenga' mityaa, Lotnuya mangalaami deju'kike' pirenu tenasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Bene Lot Sóar pebulunu chunu jeetyatu, ya' pai na'malaba kuyi tenashaa ji' chuimi. Tsejtu yala pema tujuushaa chumu tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ma malu ya' ave na'ma kayi na'manu tsandimi: Lala' apa yumaa derukuintsuve, tsenmin kumuinchi entsa tenashaya lalanu ka' chudinuu jumula ma unbereba dechutyuve, matyu naaju chachillaba tsaimu deeñu laa bain tsainu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tsa' mitya yanu viñaware', yaba detsu', yachi na miyandi', ya' mityaa maseradaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tsejtu juntsa keperen ya' apanu binu dekushkare' viñawaatu, ave na'ma yaba tsumi; tsenñuren ya' apaa mijaba i'mi, ne ti uwanaa ya' na'ma yaba tsaiñu bain, ne ti uwanaa mangujñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tsejtu ayunchi ya' uñama ya' miyanu tsandimi: Iya kepe apaba tsaiyu, tsa' mitya uma kepe bain ma viñawaadaa, matyu ñu bain yaba tsunutsu. ¡Tsaitaa lala yachi na miyandi' ya' mitya maseradaa! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tsejtu juntsa kepe bain ya' apanu binu demanguwa' maviñawaatu kayi na'ma bain yaba tsaimi, tsenñuren ya' apaa manen mijaba i'mi, ne ti uwanaa ya' na'ma yaba tsaiñu bain, ne ti uwanaa mangujpañu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Juntsaitaa Lotchi pai na'mala na vila, ya' apachiren. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Tsejtu ya' uñama unbeena miyanditu, Moab mumu pumi. Tsenñu juntsaa challa Moab chachillachi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tsenmala kayi na'ma bain unbeenaren miyanditu, Ben-amí mumu pumi. Tsenñu entsaa challa Amón chachillachi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham ya' chunu tenanu malu' miitu, Négueb tusha miimi. Tsejtu junu Cadés pebulu bain, Sur pebulu bain chunu kejtaa tenatala chudimi. Tsejtu bene, junu vee mujtu chu' jamu chachi juu Guerar pebulubi chutu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ya' shinbu Saranu ya' tsujkive tiitimi. Tsenñu Guerar pebulunu chumu rei Abimélec, Saranu taadei, ti' mandanguemi ya' shinbu tirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tsenñuren juntsa kepe Abimélecnu Dios kipibi tsandimi: Unbee miya shinbunun manga' mitya, ñu peyanun jutyunave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tsenñuren, juntsa rei kayu juntsa shinbuba tsuindyu' mitya tsandimi: Bale Ruku, ¿ñu inu, in chachillaba tu'nu pensaa, lala tiba firu' kindetyuba? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahamren inu juntsa shinbu ya' tsujkive tingayu, tsenmala ya bain uwain ya' kayaa tingayu. Tsa' mitya iya naa tsangue' supu manganu ke' bain, tiba firu' pensajtu tsangue' mitya tiba urajtuuya kendyuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tsenñu kipibi Dios tsandimi: Iya miyu naa ñu tsangue' bain tiba firu' kenu pensajtu tsanguiñuba. Tsaañu' mityaa iya ñunu juntsa shinbuba tyushtenu kindyuyu, ñu inu ujcha lan jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tsa' mitya challa juntsa rukunu ya' shinbu mangude; yaa in mitya pamu rukuve. Tsenmalaa ya ñu peyatyusa tyatu inu u'tandinu tsuve, tsaaren ñu manguwai'shu juntsaa, ñu bain, naa ñu' chachilla bain uwain peyanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tsejtu ayunchi Abimélec kepenene kujpatu, kumuinchi yachi tiba kiikemu chachillanu demikatu, ya ti kipi'ba dekuinda kemi. Tsenñu yala, rei tsandiñu meenatu, yuj jeetyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Tsejtu bene Abimélec, Abrahamnu janu mandanguetu tsandimi: ¿Tyee lalanu ketunguiyu? ¿Tyee ke' ñunu firu' dekiñaa, naa inu bain, naa in chachillanu bain tsamantsa ujcha lawaanuu ketunguiyu? Juntsaaya ki'nutsumive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Naake pensanguetaa entsanguiyu? timi Abimélec, Abrahamnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tsenñu Abraham tsandimi: In pensaya entsa tenasha Diosnu meenguityu deeve tenñundiwayu tsandimi, tsandi'shu juntsaya in shinbu' mityan inu tu'nu dejuve tenñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tsaaren ura uwaindiyu yaa in tsujkive; ya in apa' na'mave, naa in amachee ya' na'ma jutyuñuba, tsenñu i yaba buudi' chuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tsejtu Dios inu in apa' yanu lu' ji' vee mujtu jide ti' uudenguiñu, nunbatalaba nenu lu' jindu, in shinbu Saranu naaju pebulutala viji'ba iya ya' kayave, tide titu tsandiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tsenñu Abimélec Abrahamnu ya' shinbu Saranu manguwatu, naa uveja juula, naa wagaa juula, naa tiba kiikemu chachilla unbee rukula bain, supula bain demekikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Tsejtu tsandimi: Keekide, entsa in turen tsanave. Nunbatalaa ñuchi kayu urañuba mi'ke' ka' chude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tsejtu Saranuya tsandimi: Ñu' kayanu 1.000 lepa lushi jeru kuwayu. Tsenmalaa kumuinchi ñuiba bulu pudenashu juntsala ñunu firu' panu deke'ba yala' firu' panu pensa manbashiinudetsu. Tsa' mitya muba ñunu firu' panu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Tsenñu Abraham Diosba kuinda keñu, Abimélecnu bain, naa ya' shinbunu bain Dios ura' mandiremi. Tsenmin yachi manda-imu shinbulanu bain de-ura' mandiremi nakanudetsu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","matyu Sara' mityaren, Yavé tsaa Abimélec' yanu chumu shinbulanuya maliba navinu jutyungue shuikeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yavé Saranu tyee tsanguenbera kentsuyu timuwa ju'ba, uwain tsangue ura' kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tsenñu Sara navi', na main ka' kumi Abraham yumaa derukuunuren. Tsejtu Dios naaju tinbutalaa tsainu tsuve tiñu bain juntsa tinbutalaa tsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Tsenñu Abraham Sara' ka' kuñu nanu Isaac mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tsejtu nakayañu mandishpen malu insha Dioschi señas kemi, Dios naake uudenguemuwaañuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham 100 añu juunu uwanaa Isaac nakayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tsenñu Sara entsandimi: Diosya inu sunden uukakaave. Tsa' mitya mun iya na main miyandiñu demija' bain sundya' iba bulu uukanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Maa iya Abrahamnu naka' kunu juve tya' pensa dekiñanga? Tsaanuren iya na main ka' kuwayu, yumaa derukuuñu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kaana yumaa awañu chuchu tyaikikaala. Tsejtu chuchu tyaikikaanu malunu Abraham tsamantsangue chachi wa'kare' fandangu kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tsaaren Egiptosha chumu shinbu Agar' na, matyu Abrahamnu ka' kuwañu na jumu, Isaacnu firu ti' uukapuntsu katami Sara. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tsejtu Sara, Abraham' junga jitu tsandimi: ¡Manda-i' taawasha kemu shinbunu ya' naba me-eede! ¡Entsa manda-i' taawasha kemu shinbu' naya in naba, ñu ti tañuba juntsa bulu deveenu jutyuve! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tsandiñu, Abraham tsamantsai vera' tyami, Ismael bain ya' nañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tsenñu Dios tsandimi: Juntsa na' mitya bain, naa ñu' manda-imu shinbu' mitya bain pensandyatyude. Tsa' mitya Sara naatiñu bain tsanguide, matyu Isaacnu sera' jimulaa uwain ñunu sera' jamu kuranu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tsenmin ñuchi manda-imu shinbu' nanu bain, iya seewaanu tsuyu, ya bain ñu' nañu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tsejtu ayunchi dishkepenene Abraham Agarnu pan kuwamin, animaa kika buusa bain pi puu kuwaminguemi. Tsangue' ya' beenbushusha pandekemi, tsenmin ya' nanu bain mangumingue': Miide, ti' me-eemi. Tsenñu juntsa shinbu nuka jindu'ba mijtu ne jiindu tiba den chutyun tena Beersebasha nentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tsejtu animaa kikanu pumu pi de-iiñu, tsaa ya' nanu da'chichii panbeenu tsureke' ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ya bain vee mujtu, junu baanatyununu ji' chudimi, ya peyantsu keenandyai'tu. Tsejtu ya' ama chudi' chunatu waawaandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Tsenñu juntsa kaana bain waañu, Dios selusharen meemi; tsenñu Diosa' anjee Agarnu paputu tsandimi: ¿Tyeengues nendu iyu, Agar? Jeetyatyude, ñu' na challa naana' waañu bain Dios meeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tsa' mitya ñu' nanu mangaide, tsejtu ya' tyaapanu tyaikityude, matyu iya yanu tsamantsangue seewaakaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tsejtu Agarnu Dios main pi pusu katakaañu, ji' animaa kikanu pi tyuwa mangue' Ismaelnu pi kushkaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Tsejtu Dios juntsa nanu ura' kemishtintsuñu, awa' tiba den chutyu Parán tusha chumi, tsenmin arku bain yavi' tya'kemu tiyami. Tsenñu bene ya' ama, main Egiptosha chumu na'manu supungakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Juntsa tinbutala, Abimélec Abrahamba kuinda kenu jimi. Tsenñu ya' suutadu ama Ficol bain yaba bulu jimi. Tsejtu Abimélec Abrahamnu tsandimi: Ñu ti keñu bain Diosya kemishtimuñu bain mideeyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tsa' mitya, challa enuren naa inu bain, naa in kaillanu bain, naa inu bene sera' jimu chachillanu bain firu' ken jutyuyu ti', Diosnu paka' uwain tsanguenbera kentsuyu tide. Tsenmin iya naake ñunu ura' keñuba ñu bain tsanguenu tsuyu ti', Diosnu tsandide, tsenmin challa ñu' chunashu juntsa tenasha chumulanu bain tsanguenu tsuyu ti', Diosnu paka' uwain tsanguenbera kentsuyu tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Tsenñu Abraham pakatu: Diosnu paka' uwain tsanguenbera kentsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tsejtu junuren Abraham Abimélecnu jayu jatsandya' pami, matyu Abimélecchi tiba kiikemu chachilla yanu ma pusu machi'kemuwa deeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tsenñu Abimélec tsandimi: Maa ñullanu tsanguiñuba mijtuyu, naa ñu bain inu wandindyuve. Entsa kuindaya challaa mijayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tsenñu Abraham uveja bain kamin, naa wagaa bain kamingue', Abimélecnu kuwami; tsejtu juntsa malunun yala pallu veta' veta' ura' kenu ti' ma tsai shuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Tsejtu Abraham ya' uveja puinsha supu uveja kailla mandishpallu veekami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Tsanguiñu Abimélec pake'meetu: ¿Tyeenguenaa entsa mandishpai uveja veekalaatunguiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Tsenñu Abraham tsandimi: Entsa mandishpai uveja kuwakenu juuwashu juntsaya, uwain iyaa entsa pusu kemuñuba mijakaanaa tsaave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tsa' mityaa juntsa tenanu Beerseba mumu vimuwaami, junaa entsa pai rukula Diosnu paka' tsanguenbera kentsuyu detiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tsa' mitya veta' veta' tsanguedaa ti' depa' dyamin, Abimélec, ya' suutadula' ama Ficolba yala' tu Filisteasha miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Tsejtu junu Beersebanu Abraham, ma chi ya' mumu tamarisku chi wajtu, Yavé' mumunu pakami, naa-uwanuba tsanamu Diosnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Tsejtu Abraham Filistea tusha pure' tinbu chunami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bene entsai' depuiñu, Dios uwain Abraham yanu ura' keenguemuñuba mijanu tyatu, Abrahamnu ya' mumunu pañu, pakatu: Enu entsanayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tsenñu Dios tsandimi: Main juushu juntsa nanu, matyu ñu' tsamantsa estennu na Isaacnu ka', Moria tusha jide. Tsejtu junu jitu, iya ma kuyi keewaanmala, juntsa kuyisha yanu tute' ju'ke' inu keewaaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tsenñu ayunchi Abraham dishkepenene kujpa' ya' burunu chudi' jintsumi ura' dekemi; tsangue' ju'kenu te bain paamingue' Dios tsandiñu tenasha jimi ya' na Isaacba, tsenmin yachi tiba kiikemu chachillanu bain pallu miya' jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tsejtu pen malusha, Abraham baasharen juntsa tenanu kata-eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tsejtu yachi tiba kiikemu chachillanu tsandimi: Ñullaa enu buruba keenadei. Tsenmala iyaa, in naba kayu ajkesha ji', Diosnu balengure' keeware', bene maanu detsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tsejtu Abraham ju'kenu te katu Isaac' beenbushusha pandekemi; tsangue' yaa kuchillu bain, ñinguma bain kake', umaa yala pallu ajkesha jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tsenñu Isaac Abrahamnu pake'meetu: ¡Apa! timi. Tsenñu Abraham pakatu: ¿Tyee mujken, apa? timi. Tsenñu Isaac tsandimi: Enu te bain, ñi bain takendetsuyu, tsaaren ¿tute' ju'ke' keewaantsumi llupu kaa uvejaa naanain? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Tsenñu Abraham tsandimi: Diosya tute' ju'kenu llupu kaa uveja keewaanu tsuve, apa, timi. Tsejtu ajkesha bulu jintsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tsaindu naaju tenanaa Dios tsandiñu bain Abraham junu jimiren, Dioschi ufeenda tsure' ju'kenunu main kemi. Tsangue' te bain detsure', bene ya' na Isaacnu tele', tsaa juntsa shupu' jandala llatikaami te jandala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Tsejtu umaa kuchillu kake', ya' nanu tute' ju'ke' Diosnu keewaanu kentsuñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yavé' anjee selusharen paputu: ¡Abraham! ¡Abraham! timi. Tsenñu ya pakatu: Enu entsanayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tsenñu anjee tsandimi: Ñu' nanu tiba kityude, matyu yumaa mijayu naa ñuya Diosnu jeetya' meenguemuñuba, ñuya ñu' na main juuñu bain kun jutyuu ki'ñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tsenñu Abraham majeeke' keetu llupu uveja main, kaa chi alinu ya' kachu pukakare' uina katami; tsejtu ji' juntsa uvejaa katu, juntsaa Isaac' mitya tute' ju'ke' Diosnu keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tsejtu bene Abraham juntsa tenanu, “Yavéya menesteju kumuve” mumu pumi. Tsa' mityaa naa entsa piikenu uranu bain, “Kuyisha Yavéya menesteju kumuve”, tiitila juntsa tenanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tsejtu bene bain Yavé' anjee kama bijee selusharen Abrahamnu manbaputu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","tsandimi: Yavé entsandive: Ñuchi na main juuñu bain inu kun jutyuu kityu' entsangueñu' mitya, iya maaliren tsanguenbera kenu tsuyu ti' entsandintsuyu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ñunu mika ura' ikaanu tsuyu. Tsenmin ñunu bene sera' jimu chachillanu bain pure' seewaakenu tsuyu, selusha makara chun tsangue tirenu tsuyu, tsenmin lamaa pi keetala ñiipe tsun tsangue seewaanu tsuyu. Tsenmin yalaa yala' kundaalanu pulla' ka' uudenguen chunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tsenmin ñu inu meenguen mityaren kumuinchi entsa tunu chumu chachillaya, ñunu sera' jimula' mityaren inchi ura' i-iinu detsuve, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tsenñu Abraham bene yachi tiba kiikemu chachilla' punu tenasha miitu, kumuinchi bulu Beersebasha miila. Tsai' Abraham junu manchumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Entsai' depuiñu kayu bene Abraham kuinda mijami, naa ya' naatala Nahornu, Milcá bain mantsa naka' kuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ajke' na kayamiya Usya kayami, bene ya' naatala Buz, tsenmala kayu bene Quemuelya nakayami. Quemuelya Aram' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Tsenñu bene bain na mangayala Quésed bain, Hazó bain, Pildás bain, Idlaf bain, naa Betuel bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Tsenñu entsa Betuelya Rebecachi ya' apa tiyamuwaami. Tsa' mitya entsa mandishpen nalaa Abraham' naatala Nahornu Milcá ka' kuñu na juwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Tsenmin naa Nahorchi kama miyandinu shinbu Reumánu bain entsangue nakakaami: Tebanu bain, Gáhamnu bain, Tahasnu bain, tsenmin Maacánu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara 127 añu chumuwaami, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","tsejtu Quiriat-arbá tityumee, Hebrón pebulu tiitinunu peyami, Canaán tusha. Tsenñu Abraham, Sara peyañu waatu, yuj llakindya' chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Tsejtu bene ya' shinbu' ujkun bulu tsuinsha puturen, mafale', Hetnu sera' jimu paandela' chuinsha jitu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Iya vee mujtu tusha chumu ju'ba, ñuiba bulu chuyu. Tsaaren inu bain cha' depeñu mennu tu main miyandikaakai. In shinbunu mennu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tsenñu Hetnu sera' jimu chachilla pakatu tsandila: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","¡Rukui, ñu lalanu meedide! Ñuya lala' jundalaya Dioschi mi'ke' kaya bale rukuve. Tsa' mitya laachi cha' depeñu mennu tujuu naaju kayu urañuba juntsanu ñu' shinbunu mende. Muba laatalaya, cha' depeñu mennu tujuu espanu dejutyuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tsenñu Abraham mangujpa' uidi' Hetnu sera' jimu paandela' ajuusha teledi', ya' llashkapa tunu tapa'kanbera waiketu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","entsandimi: Uwain ñui bain enu in shinbunu menñu urave tenñuya, in mitya Sóhar' na Efrónnu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ji', ya' tu kapasha Macpelá, tujuu ai'ka tiidei. Tsenmala iya juntsa tu nan baleñuba paanguenu tsuyu. Tsanguetaa i bain entsa tenanu tu miyandi' cha' depeñu mennu tujuu ñulla' kejtsapala miyandinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Tsenñu Hetnu sera' jimu chachi Efrón bain junu kejtsapala putu, naa ya' paandela bain, naa pebulu vinu juukapasha pumu chachilla bain, ya naatiñuba demeesa tyatu Abrahamnu entsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","¡Tsa jutyuve, rukui! Iya ñunu juntsa tu bain, naa junu tujuu jumu bain ne kuwakenu tsuyu. Tsa' mitya iba manbelaa chumu chachilla bain demeenave naa iya ñunu uwain mekentsuñuba. Junu ñu' shinbunu mende, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tsenñu manen Abraham junu chumula' ajuusha wayuke' keewaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kumuinchi chachilla demeenaren Efrónnu pakatu entsandimi: ¡Tsantsaya ñu inu meedika tenve! Juntsa tu' mitya lushi kade ti' u'tandinu tenve, tsenmalaa bene iya junu in shinbunu mennu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tsenñu Efrón manbakatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Rukui, meedika: Juntsa tu 400 lepa lushi jeru baleve. Tsaaren ne juntsa' mityaya vinbatyudaa. Tsa' mitya ñu' shinbunu junu mende, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tsenñu Abraham, Efrón naake pa'ñuba kuwanu shuwatu, Hetnu sera' jimu chachilla dekeenaren, 400 siklu, tsandityu' bain, 4.4 kilu lushi jeru lepa tene kalare' paanguemi, naake yangaataa juntsangue adyu' yangaamu deeñuba juntsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Entsanguiñaa Efrón' tu, Macpelá tenasha jumu tu, matyu Mamré chi chumu tusha jumunu pensanguiñuya pajlanu pasha, naa junu ujkun tujuu jumu bain, naa chi bain juntsa tusha chumulaya ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abrahamchi tene tiyala. Entsangue' depuiñu naa Hetnu sera' jimu chachilla bain, naa junu pebulu juukapasha pumula bain tsanguindetsu narana keenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Entsangue' depuitu, bene Abraham ya' shinbunu menmi, Macpelá tusha jumu tujuunu, matyu Mamré chi chunu tunu pensanguiñuya pajlanu pasha, tsandityu'ba Hebrónsha Canaán tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Juntsanguitaa Hetnu sera' jimu chachilla' tu bain, naa junu tujuu jumu bain Abraham ati'kami, tsejtaa chachilla depeyanmala mene menekenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham yumaa pure' rukuumi, tsenmin Yavé yanu tinuba ura' de-ikare' puitemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Tsejtu ma malu Abraham, yachi manda-i' taawasha kemu chachinu, matyu ya ti tañuba kumuinchi washna' keenamu kayu ruku chumunu mikatu tsandimi: Tsantsaya ñu' tyaapa in enbu panbeesha pukide, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","tsejtu in na Isaacnu, enu in chunaashu juntsa Canaán tusha chumu supulanuya kakaan jutyuyu ti', naa selu bain, naa tu bain kemu Yavé Diosnu paka' tsanguikarenbera kikaan jutyuyu tika. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tsejtu in tushaa ji', jungaa Isaacchi in bulu paande na'malanu ma supu mi'ke' kaide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tsenñu yachi manda-i' taawasha kemu ruku pakatu tsandimi: Tsandenna juntsa na'ma iba jandyai'shu juntsaa, ¿tyeenguenujtuuwa? ¿Ñu' nanaa junga ñu' chudi' janu tusha ta'nujtuuwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tsenñu Abraham tsandimi: ¡Tsa jutyuve, in nanuya junga miya' jityude! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Matyu Yavé, selusha chumu Dios, inu in apa' yanu kalaamu Dios, in paandela' tusha inu kalaamu Dios, entsa tu inu sera' jimu chachillanaa kuwanu tsuyu ti' uwain tsanguenbera kenu tsuyu ti' pamu Dios, ñu' ajuusha main anjee eenu tsuve, in nachi ma supu kakaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tsandenna supu na'maa ñuba jandyai'shu juntsaa, ñu Diosnu paka' tsanguenbera kentsuyu tishu juntsa, nejuu mandiyainu tsuve naa taatyuñu bain, ¡tsaaren ti' mityaba in nanuya jungaa ta'tyude! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tsenñu yachi tiba kiikemu chachi, yanu uudenguemu ruku Abraham' enbu panbeesha tyaapa ta'pu' taditu, Abraham naati pañuba Diosnu paka' uwain tsanguenbera kenu tsuyu ti' pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tsejtu yanu uudenguemu rukuchi tiba uukeraa bale jumula deka' jitu, paitya kameyu ka' ji', umaa Nahor pebulusha jimi, Mesopotamiasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tsejtu bene malutala tiba kiikemu chachi yumaa dekependu' kakensha juntsa pebulu avindala vijimi, matyu supula pi kas neneinu uwatala, tsejtu pi pusu kelunu kameyulanu detelengaakaake' ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","umaa Diosba kuinda ketu entsandimi: Yavé, inu uudenguemu ruku Abraham' Dios, uma malu inu ura' puiwaaka, tsenmin inu uudenguemu rukunu bain ura' puiwaanu kikaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Iya challa entsa pusu kelunu entsanayu, tsenñu enu chumu pannala pi kalaaja' mijin juunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tsenmala challa iya naaju na'manu: Tsantsaya, ñu' tupiyama pajtede, inu pi kushnu tenve, tinmala, Kujchide, ti', naa ñu' kameyulanu bain pi kuwanu tsuyu, ti' pakamu na'ma ju'ba, juntsaa ñuchi tiba kiikemu chachi Isaacchi mi'ke' kañu na'ma jusa. Tsenmalaa iya mijanu tsuyu naa inu uudenguemu rukunu ñu yuj ura' kentsuñuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tsejtu juntsandi' Diosba kuinda ketu kayu dekindyuren, ma na'ma ya' palanu tupiyama chuu jantsu katami. Juntsa panna Rebecami, Betuel' na'ma. Betuelya Milcáchi bain, Nahorchi bain ya' na jumi; Nahorya Abraham' naatalawaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Tsenñu Rebeca yuj uukerami, tsenmin naajulanuba tsa-i' kerajtu jumi; naaju unbeelaba yaba tsudi' kerajtula. Tsejtu pi pususha vitu ya' tupiyamanu pi tyuwake' yumaa maluntsumi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","tsenñu Abrahamchi manda-imu chachi yangachi ji' mi'na jitu entsandimi: Tsantsaya, ñu' tupiyamanu pi jayu kuwaka; kushnu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Tsenñu pakatu: Ruku, kushde, timi. Tsejtu ya' tupiyama jeke pajte' ya' tyaapachi yaitadi' kushkaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Tsenñu Abrahamchi manda-imu chachi pi kujchi' dyañu, Rebeca entsandimi: Ñu' kameyulachi bain pi kalaanu tsuyu, tsenmala yala naake mutya'ba tyubanbera kushnudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tsejtu animaa pi kushnutsumi, kule keraanu jeke ya' tupiyamanu pumu pi deyuuputu, pususha mavi' malatintsumi, kumuinchi animaala pi kujchinbera. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tsenñu juntsa na'ma tsaita nentsuñu Abrahamchi manda-imu chachiya pabandi'mujchi ne keenami, yanu uwain Yavé ura' kemishtiñuba mijanu tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tsejtu kameyula pi dekujchi' dyañu, juntsa ruku ma uru suutes mandishmain gramu adyu kuwami juntsa na'manu. Tsejtu tyaapanu eenguintsumi bain uru tene juu, mika 100 gramuya ma pulla adyu tene, pallu kuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Tsejtu tsandimi: ¿Ñu mu' na'mayu? ti' pake'meemi. Tsanditu: ¿Ñu' apa' yasha, naa in chachillachi bain, naa inchi bain uma kepe junga tsudi' puinuu junu jun? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Tsenñu entsandi pakami: Iya Betuel' na'mayu, matyu Milcáchi bain, naa Nahorchi bain ya' paña. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Tsenmin lala' yashaya ñu uma kepe tsudi' puinuu junu juve, tsenmin kameyulachi tsuinsha bain, naa panda bain detanayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tsenñu Abrahamchi manda-imu chachi teledi' Yavénu aawa kure' keewaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","entsandimi: ¡Inu uudenguemu Abraham' Dios Yavéya yuj urave tikayasa, naa inu uudenguemu rukunu bain kidanda jutyu' tenbitya' ura' ju', naa inu bain ya' paandela' junga jiinuke kikaren mitya! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tsenñu Rebeca ya' ama' yasha yangachi mijiimi, kumuinchi naa naa-i puiñuba kuinda kenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeca main kaya miyawaami, ya' mumu Labán. Tsejtu Labán, ya' tsujki naa suutes bain, naa tyaapanu eenguintsumi bain taaya miiñu katatu, tsenmin Rebeca juntsa rukunu laapu' patu naatiñu bain kuinda kentsu meena' mitya, Labán pususha yangachi jiimi juntsa rukunu mi'kenu. Tsejtu Abrahamchi manda-imu chachi junu pusu kelunuren kameyulaba bulu de-uina, Labán kata' yanu kalen mi'na jitu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","entsandimi: Yavéchi ura' imu ruku, engu jidaa. ¡Nejtaa ñu enu avindalaa shuwanu juyu, naa ñuichi yasha tsudinuu bain, naa kameyulachi tsuinsha bain ba'kaawashuba! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tsenñu Abrahamchi manda-imu chachi yala' yasha jiñu, Labánya kameyulanu buli delanbu' pajte' kameyulanu panda kuwa', yala' tsuinsha ishtape bain detsuumi. Tsejtu bene yaichi pi taji' kumi, tsenmalaa naa Abrahamchi manda-imu chachi bain, naa yaba bulu nemu chachilla bain yala' neepa demanbitsaasa tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tsejtu bene panda bain fisa tya' dechujti' kuñu, Abrahamchi manda-imu chachi entsandimi: Iya ñullanu ti kuinda kenaa ju'ba kayu kuinda ki'mujchiya panda fin jui'yu, timi. Tsenñu Labán: Tsaaya pade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tsenñu entsandi pami: Iya Abrahamchi manda-imu chachiyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yavéya inu uudenguemu rukunu tiba pure' uraa ikaakive, tsangue' taruku tiwaave: tsejtu naa uveja juula bain, naa wagaa juula bain, naa lushi jeru juula bain, naa uru juula bain, naa yachi tiba kiikemu chachilla, supula bain, unbee rukula bain, naa kameyu juula bain, naa buru juula bain dekuwave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tsenmala ya' shinbu Sara bain yumaa deshinbuuren na main ka' kuve, tsenñu inu uudenguemu ruku yachi kumuinchi ti ta'ba ya' nanu tene demanguwakive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tsejtu inu uudenguemu ruku, inu Diosnu paka' tsanguenbera kenu tsuyu tikaatu entsandiwa: In na Isaacnu, enu in chunaashu juntsa Canaán tusha chumu supulanuya kakaatyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Matyu in apa' paandela' jungaa jitu, in paande supulanaa in nachi main supu mi'ke' kade, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tsenñu inu uudenguemu rukunu entsandiwayu: ¿Tsen, juntsa na'ma iba jandyai'shu juntsaa, naa kenujtuuwa? tiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tsenñu ya inu tsandiwa: Iya Yavé inu naakesa tyañuba tsangues nemuyu. Yaa ya' anjee ñuba eenu tsuve, ñunu tiba ura' ikaakaanu. Tsa' mitya in apa' paandela' na'malanu ñu in nachi supunganu jide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tsaaren in paandela ya' na'malanu kuwandetyai'shu juntsaa, ñu Diosnu paka' inu tsanguenbera kenu tsuyu tiñu, nejuu mandiyainu juve naa tsangui'ñu bain, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Tsenñu iya, uma pi pusu kelunu jatu, inu uudenguemu Abraham' Dios Yavéba kuinda ketu entsandiyu: Uwain ñuren inu ura' nekare' iya tyeenguenaa nentsuñuba juntsaikaandenmalaya, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","challa iya pi pusu kelunu uinanu uwanu entsaa puiwaasa tenve: naaju na'maa pi kalaanu jañu bain, iya patu: Tsantsaya, ñu' tupiyamanu pumu pi jayu kushkaaka, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","tinmala, pakatu: Kujchide, ti', naa ñu' kameyulanu bain pi kunu tsuyu, ti' pakamu na'ma ju'ba, juntsaa ñuchi manda-imu chachi Isaacchi mi'ke' kañu na'ma jusa, tiyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tsejtu kayu Diosba pensachi kuinda dekindyuren Rebeca ya' palanu tupiyama chuu jantsu katayu. Tsejtu pususha vi' pi kalaañu entsandiyu: Tsantsaya, pi kuwaka, tiyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tsenmalan ya' tupiyama jeke pajtetu inu tsandive: Kushde, naa ñu' kameyulanu bain pi kuwanu tsuyu, tive. Tsejtu naa inu bain, naa in kameyulanu bain pi kuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Tsenñu bene pake'meetu: ¿Ñu mu' na'mayu? tiyu. Tsenñu pakatu: Iya Milcáchi bain, naa Nahorchi bain ya' na juushu juntsa Betuel' na'mayu, tive. Tsenñu iya suutes kijkapanu pumin, naa tyaapanu eenguintsumi bain pallu kuwa' ya' tyaapatala puyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tsejtu teledi' Yavénu aawa kure' keewaayu; tsenmin inu uudenguemu Abraham' Dios Yavénu tsamantsa yuj urave ti' payu, matyu inu ura' miñunu taja', inu uudenguemu ruku' nachi ya' naatala' pañanu kakaanu eeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tsa' mitya challa ñullaren inu uudenguemu rukuba ura' kiikenu deju' padanda deki'shu juntsaa wainkai, naa juntsaasa pensa dejutyu' bain wainkai, tsenmala iyaa mijanu tsuyu nukaa miinu ju' bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tsenñu Labán Betuelba pakatu tsandila: Kumuinchi entsa judeeshu juntsa Yavé tene tsanguikaañu' mitya, lalaya naatin tsa deeyu, naa ne urave tinu bain, naa urajtuve tinu bain dejutyuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Tsa' mitya Rebeca enu entsanave; ka' miide. Tsenmala ñunu uudenguemu ruku' na' shinbu jusa, tsai' Yavé naakesa tyañuba tsaasa, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tsenñu Abrahamchi manda-imu chachi tsa detiñu meemin, tsaa teledi' llashkapa tunu tapa'kanbera wayu'kami, Yavénu aawa kure' keewaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tsejtu bene naa tiba lushi jeruchi dekeñu juu bain, naa uruchi dekeñu juu bain, naa jali juu bain kalare' Rebecanu kuwami. Tsenmin Rebeca' kayanu bain, naa ya' amanu bain tiba naraa dekalare' kuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tsejtu bene Abrahamchi manda-imu chachi yaba bulu jimulaba panda fila, tsai' kepe junu tsudi' puila. Tsejtu ayunchi kepenene dekujtu, Abrahamchi manda-imu chachi tsandimi: Tsantsaya inu uudenguemu ruku' yasha me-eekai, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tsenñuren Rebeca' kaya ya' amaba tsandila: Entsa panna kayu laaba paitya malutalaa manchusa, tsejtaa bene ñuba jinu tsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tsenñu Abrahamchi manda-imu chachi tsandimi: Inu kajkaatyukai. Iya tyeengues nentsuñu bain Yavé ura' tsanguikare' puiteñu' mitya, tsantsaya daatadityumujchi inu uudenguemu ruku' yasha me-eekai, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tsenñu yala tsandila: Tsaayaa, pannanaa mika' pake'meedaa, matyu yaa naatiñu meenu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tsejtu Rebecanu mika' pake'meetu tsandila: ¿Entsa rukuba jinu tenguen? tila. Tsenñu pakatu: Jinu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tsenñu Rebecanu bain, tsenmin yanu naa-uwanuba washi washikemu shinbunu bain bulu eela. Tsenmin Abrahamchi manda-i' washkemu chachinu bain, naa yaba bulu nemulanu bain me-eela. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Tsejtu Rebecanu Dioschi ura' isa titu entsandila: Lala' tsujki, ¡tsamantsa pure' chachillachi ama jude! ¡Tsenmin ñunu bene sera' jimu chachilla yala' kundaalanu pulla' ka' uudenguen chumu detiyasa! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tsenñu Rebeca yachi manda-imu shinbulaba, kameyunu delu' chudi', Abrahamchi manda-imu chachinu bendaa jila. Entsaitaa Abrahamchi manda-imu chachi, Rebecanu ka' junu malu' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tsenñu Isaac Négueb tenasha chutu, ma pi pusu “Chu' inu keenamu” mumu pususha pu' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tsejtu kependu' kainsha nenu lumi ya' yapaya keetala. Tsaintsunu uwanu kameyu kalen jandetsu kata-eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tsenmala Rebeca bain kata-eemi, tsejtu Isaacnu katamin, kameyunu pajtyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Tsejtu Abrahamchi manda-imu chachinu pake'meetu: ¿Mun juntsa unbere jeenbaatala lala' junga jaintsushu juntsa? timi. Tsenñu Abrahamchi tiba kiikemu chachi: Inu uudenguemu ruku Isaacve, timi. Tsenmalan Rebeca dukenu jali ka', ya' kajuunu dukikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tsenñu Abrahamchi manda-imu chachi Isaacnu dekuindakikemi naa naake' maja' bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tsenñu bene Isaac ya' yapayasha miya' vimi, matyu kaspeleya ya' ama Sara' yapayanun yachi tireñu yapayasha. Tsejtu yaba tyushdi' ya' shinbu tiretu, Isaac Rebecanu yuj estyami. Entsaitaa ya' ama peyañu tsamantsa llakinguen chuturen llaki piremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham vee supu mangami, Queturánu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Tsejtu juntsa shinbuba keñu ya' nalaya entsaa juntsawaala: Zimrán, Jocsán, Medán, Madián, Isbac, tsenmin Súah bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Tsenñu Jocsánya, naa Sebáchi bain, naa Dedánchi bain ya' apa tiyamuwaami. Tsenmala Dedánnu sera' jimu chachillaa, naa Asurnu bain, naa Letusnu bain, naa Leumnu bain sera' jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Tsenmala Madián' nalaya, Efá bain, Éfer bain, Hanoc bain, Abidá bain, naa Eldaá bain. Kumuinchi entsalaa Queturánu sera' jimu chachilla juwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Tsaanuren Abraham ti deta'ba Isaacnu tene demanguwa' shuikikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tsejtu Abraham yachi vejan miyandinu shinbulaba keñu nalanuya mantsa tiiñuba mekanchi tene ne kikemi, tsejtu Abraham kayu peyai'mujchin juntsalanu pajlanu pasha devele' eekemi, matyu ya' na Isaacba bulu chui'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham kumuinchibi 175 añu chumi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","tsejtu tichiba dilui'mujchiren, matyu rukunchin ne peyaimi. Tsai' peyatu ya' tinbu rukulaba manbuudiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tsenñu ya' nala, Isaac, Ismaelba, Macpelá tusha tujuru juñu' mitya junu menla, matyu Mamré pajlanu kapasha, ura pañuya, kaspele Hetnu sera' jimu chachi, Sóhar' na Efrónchi jumu tusha menla. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Entsa tunaa Abraham Hetnu sera' jimu paandelanu ati'kamuwaami. Tsejtu junaa Abrahamnu menla, ya' shinbu Sara' mennanu kelunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Tsai' Abraham peyañu, Isaacnu Dios mika ura' deke' puitemi. Tsenñu Isaacya “Chu' inu keenamu” tinu pusu kelunu chumu tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Entsalaa Egiptosha chumu na'ma Agar, Sarachi manda-imu shinbunu Abraham nakiñu Ismael' nala deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Tsenñu naa-i defaañuba tsandipañuya entsalaa juntsawaala: ya' ajke' naya Nebaiot, tsenmala bene Quedar faami, bene Adbeel faami, bene Mibsam faami, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","tsenmala bene Mismá bain, Dumá bain, Masá bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar bain, Temá bain, Jetur bain, Nafís bain, naa Quedmá bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Entsalaa Ismaelchi 12 nala' mumu deeve, tsenmin entsa mumuren pula naa yala' tutala bain, naa yala' kajdi' chundala bain. Tsenmin entsala main main ya' chachillachiya bale ruku tene tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael 137 añu juunu uwanu peyami, tsai' ya' tinbu rukulaba manbuudiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tsenñu yanu sera' jimu chachilla, Havilá tena bain, naa Sur tena bain junu kejtaa tenashaa chula, Egipto tu ajuusha, Asiria tusha jijiinu miñu deechusha. Tsejtu junu chula, yala' paandela tsaa mutyaindetyuren. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Entsaa Abraham' na Isaac' kuindave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac 40 añu juunu uwanaa Rebecanu ka' chumi, Betuel' na'ma, Labán' tsujkinu. Entsa chachilla Aramnu sera' jimu chachi jula, matyu Padán-aram tusha chumula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebecaya navityu jumi, tsenñu Isaac Diosnu pakatu navikaasa tya' papatiñu, Yavé pañu meetu Rebecanu navikaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tsenñu ya' ajkasha puturen pai nala yaatala yuj bulla kiidekiñu: “¿Nenñaa inaa entsaa i' puindu in?” tyami. Tsejtu Yavénu pake'meejiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yavé pakatu tsandimi: Main main ma uñichin uuden juu vee vee bulu chachi tiyanuu jumula ñu' ajkasha pallu depuve, tsenmin kayu nakayai'mujchin vinguikeñuu kendetsuve pai bulu chachi tiyanuu jumula. Mainya kamainnu kayu pulla pudenu tsuve, tsaaren avenjaa kayichi manda-in chunu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tsejtu Rebecachi nakanu malu tiyañu, na pallu kami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Tsenñu ajke' faamuya achuwa ñingalalaami, tsenmin bulu kuraa ju pure' chuumi, tsenñu juntsanu Esaú mumu pula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tsenñu bene ya' naatala faami, matyu Esaú' nenbujkuwanu ma tyaapachi taju, tsenñu juntsanu Jacob mumu pula. Isaac yumaa 60 añu juunu uwanaa Rebeca nakami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kailla de-awatu, Esaúya jeendaa nemu chachi tiyami, tsejtu jeendaa ne' yavi' aingamu tiyami; tsenmala Jacobya, nejuu paviya jutyu jumi, tsenmin yapayatala shuwanu ajchuu ne juumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaacya Esaúnaa kayu estyamu jumi, ya jeendaa ji' ainga' maañu alla finu ajchu' mitya, tsenmala Rebecaya Jacobnaa kayu estyamu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ma malu Jacob panda kikenu uwanu, Esaú jeenbaasha pu' tyubaa ju' panda mujka miitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Jacobnu entsandimi: Aantsa ungalala luguu tanashu juntsa, tsantsaya jayu kuwaka, matyu pandachi peyaintsuyu, timi. (Tsa' mityaa Esaúnu Edom mumu bain pula, matyu “ungalala” titu.) ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tsenñu Jacob pakatu: Ñu avenju na jutu, naa naa-i uraa inu juñuba, juntsabaa vetedaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Tsenñu Esaú entsandimi: Keekika, iya pandachi ma peyaintsuyu. Tsa' mitya iya avenju na jutu, naa naa-i uraa inu juñuba juntsa balejtunchi ma juuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tsandiñu Jacob entsandimi: Tsaaya, challaren Diosnu paka' uwain tsanguenbera kenu tsuyu tide, timi. Tsenñu Esaú Diosnu paka' uwain tsanguenbera kenu tsuyu titu, ya avenju na jutu, naa naa-i uraa inu ju'ba juntsa Jacobchi tirekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tsenñu Jacob Esaúnu pan bain, naa mulu luguu bain kuwami. Tsenñu Esaú naa panda bain, naa pi bain kujchi' dyatu, mangujpa' tsaa ne mijiimi, matyu ya avenju na ju'ba, juntsanu baleve tya' pensangui'mujchi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Juntsa tinbunu, kumuinchi juntsa tusha tiba pure' yamuj tiyaimi. Kaspele Abraham chuumala bain tsaimuwaami. Tsenñu' mitya Isaac Guerar tusha jimi, matyu Filisteasha rei Abimélec' chuinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tsenñu junu Yavé yanu katawatu tsandimi: Egiptoshaya jityude. Tsejtu iya nunbanu chude tiñuba junu tsanade, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","tsaaren challaya entsa tenanun chude. Iya ñubaren chunu tsuyu, tsenmin ñunu bain, naa ñunu sera' jimu chachillanu bain tichiba ura' de-ikaanu tsuyu, matyu kumuinchi entsa tu kuwanu ju' mitya. Tsanguetaa iya ñu' apa Abrahamnu naati' tsanguenbera kenu tsuyu timu ju'ba tsanguenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Tsenmin ñunu sera' jimu chachillanu bain pure' seewaakenu tsuyu, matyu makara selusha chun tsangue deseewaanu tsuyu, tsangue' kumuinchi entsa tu dekuwanu tsuyu. Tsenmin kumuinchi tu' chumu chachilla bain ñunu sera' jimu chachilla' mityaren, Dioschi ura' i-iinu detsuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","matyu Abrahamya inu meedi', naa in uudennu bain, naa in mandaju palaanu bain, naa in leinu bain, naa in mijakaranu bain tsa tsangue meengueñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac Guerar tunu chunu shuwami, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","tsenñu junu chulla Rebeca maa juñuba Isaacnu depake'meeñu, Isaac jeetyanchiren ya' shinbuve tityumujchi, ya' tsujkive timi. Matyu Rebeca uukeraañu' mitya, ya' mityaren tute'ba kichu deeve pensangue' mityaa tsandimi Isaac. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Juntsa tusha chutu pure' malu pullaintsula, tsejtu tsa denaren ma malu Abimélec, yasha pu' keepudinu juukapanu keepunatu, Isaac ya' shinbu Rebecanu estipuntsu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tsejtu Abimélec, Isaacnu mikatu tsandimi: Entsa uwain ñu' shinbu juñuve, tsaanuba ¿nenñaa ñu' tsujkive titundiyu? timi. Tsenñu Isaac pakatu: Inu ya' mityaren tute'banguichu deeve pensanguetaa tsandiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tsenñu Abimélec entsandimi: ¿Nenñaa lalanu entsanguetunguiyu? Muuñuba entsa pebulu' chulla yaba tsudi'ba deiñuya, ñu lalanu ujcha lakaachuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tsejtu Abimélec kumuinchi ya' chachillanu entsandi uudenguemi: Mun entsa rukunu bain, naa ya' shinbunu bain bulla dekishu juntsaa, tutanbera inu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Juntsa añunu Isaac junu buikiya wajtu pure' iwaake' kami, matyu Yavé yanu uraa ikaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tsenñu taruku tiya-i', naa tiba pure' tandiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tsejtu yachi naa uveja juula bain, naa wagaa juula bain, naa manda-i' washkemu chachi juula bain pureela, tsenñu Filisteasha chumu chachilla kishtya' keekeekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kaspele ya' apa Abraham chuumala, Abrahamchi manda-imu chachilla tu vijchi' pi pusu kemuwaala; tsenñuren bene Filisteasha chumula kumuinchi pi pusulanu tsaa tu tene manbuke' mallukikemuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bene Abimélec Isaacnu tsandimi: Enu malu' miide, matyu ñaa lalanuba kayu pullai taruku ju' pude tiyave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tsenñu Isaac malu' miitu Guerar jatsuwabi kajdiji' dyatu, junaa manchunu shuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tsejtu pi pusu demajuukemi, kaspele ya' apa chuumala dejuukiñuren, bene ya peyanmala Filisteasha chumu chachilla demallu'ñu pusulanu. Tsanguetu ya' apa kaspele naaju mumu pumuwaañuba juntsa mumuren demanbumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Tsejtu ma malu Isaacchi tiba kiikemu chachilla, jatsuwasha pusu vijchindu, tu tainsha pi faamu katala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tsenñuren Guerar jatsuwasha uveja washken pumula, Isaacchi uveja washkemulaba vinguila, juntsa piya yaichive titu. Tsenñaa Isaac juntsa pusunu “Esek” mumu pumi, Esek titu vinguenu titundive, matyu juntsa pusu' mityaren devingueñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bene bain yachi manda-imu chachilla manen vee pusu mavijchila, tsenñu juntsa pusu' mitya bain demavinguiñu, juntsa pusunuya “Sitna” mumu pumi Isaac; Sitna titu kundaa titundive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Tsenñu Isaac junu malu' baasha miitu, jungaa vee pusu mavijchimi. Tsenñu umaa juntsa pusu' mityaya demavingui'ñu' mitya “Rehobot” mumu pumi, aa bungu tena titu, Yavéya challa entsa aa bungu tenanu lalanu muba bulla jutyu kayu awaiñuu i' jintsunu tireve, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Tsejtu Isaac junu malu' miitu Beersebasha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tsenñu juntsa kepe Yavé yanu katawatu tsandimi: Iyaa ñu' apa Abraham' Diosyu. Jeetyatyude, iya ñuba bulu juyu. Iya inchi tiba kiikemu Abraham' mityaren ñunu ura' ikaanu tsuyu, tsenmin ñunu sera' jimu chachillanu bain pure' seewaakikaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tsenñu Isaac junu ufeenda tsure' ju'kenunu main ketu, Yavé' mumunu pakami. Tsejtu junaa kajdi' yapaya ke' manchuñu, yachi tiba kiikemu chachilla ma pusu kenu vijchila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ma malu Abimélec Guerar tusha chutun, Isaac' chuinsha jimi Isaacba kuinda kenu. Tsenñu yanu ule ulendimu Ahuzat bain, naa ya' suutadula' ama Ficol bain yaba bulu jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tsenñu Isaac tsandimi: Ñulla inu mujtyuñaa, ñulla' tusha churen inu deme-e'laasuba, ¿tyeenguenaa inu ja' keetu deiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Tsenñu yala pakatu tsandila: Lalaya uwain Yavé ñuba buunañuba demijayu. Tsaañu' mitya lalaya ñuba veta' veta' ura' ken chudaa tinu pensa dekiyu. Tsa' mitya lala ñuba Diosnu paka' tsanguenbera kenu jumiya entsaayaa kenu dejuyu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ñu bain lalanu tiba firu' ken jutyu, naa laa bain ñunu tiba bulla kenu dejutyu. Lalaya naa-uwanuba ñunu ura' dekiyu, naa ñunu lala' junga me-e'laandu bain, ura' ne me-eedekiwayu, tsenmala challa ñunu Yavé mika ura' ikaantsuñuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tsenñu Isaac yala' mitya panda deke' tsamantsangue fandangu keñu, yala panda fi' kujchila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tsejtu ayunchi kepenene dekujpa', veta' veta' uwain tsanguenu deti', Diosnu paka' tsanguenbera kentsuyu tila. Tsejtu bene Isaac yalanu deme-eendu, yaatala tiba bulla jutyu ura' dechunu ti' me-eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tsenñu juntsa malunun yachi manda-i' washkemu chachilla yala' vijchintsunu pusunu pi dekatayu ti', uraa kuinda kejila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tsenñu Isaac juntsa pusunu Sebá mumu pumi, “veta' veta' Diosnu tsa detiñu” tena titu. Tsenñu entsa piikenu uwanu bain juntsa pebulu Beerseba mumumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú 40 añu juunu uwanu Juditnu supunga' chumi, Hetnu sera' jimu chachi Beerí' na'manu. Tsenmin Basematnu bain supunga' chumi, entsa bain Hetnu sera' jimu chachi Elón' na'manu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tsenñu entsa pai shinbulaa naa Isaacnu bain, naa Rebecanu bain mika taaju' pensanguikaren chukaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac pure' rukuunchiren ya' kapuka tsaa dejuwala' pajteke' tiba katatyui tiyami. Tsejtu ma malu ya' kasna Esaúnu mikatu entsandimi: ¡Apa! timi. Tsenñu Esaú: Enu jayu, tikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tsenñu Isaac entsandimi: Iya yumaa pure' rukuuyu, tsejtu naama peya'ba jei peyanuuren tsanayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tsa' mitya ñu' arku bain, ya' tsuta bain kake' jeenbaasha jisa tenve, ka ti animaañuba inchi kanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Tsejtu bene inchi uu finuke luguu ke', inu naaju mujmuñuba juntsangue ke' taja' kuwaka, iya finutsu. Tsenmala ñunu Dioschi ura' isa ti' panu tsuyu, kayu peyai'mujchiren, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Tsenñu Rebeca meenami naa Isaac Esaúnu tsandintsuñuba. Tsejtu Esaú jeenbaasha ya' apachi tyeeba mi'kenu jiinmalaren, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca ya' na Jacobnu mikatu entsandimi: Ñu' apa ñu' naatala Esaúba kuinda kentsu challaren merake' dyaiyu, tsenñu entsandingayu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ti animaañuba tute' maade, tsangue' inchi uu finuke luguu kide, iya finutsu, tsenmala iya ñunu Yavé' ajuushan Dioschi ura' isa ti' panu tsuyu, kayu peyai'mujchiren, tingayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tsa' mitya, apa, ura' meedide in palaanu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Chibu punu veetasha ji' pai chibu kailla kayu ura tene kala' taade; tsenmala iya ñu' apachi uu finuke luguu kenu tsuyu, matyu naaju ya mutyamuuñuba juntsanguenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tsenmala ñaa ya' junga tajinu tsuve ya finutsu. Tsanguenmalaa ya kayu peyai'mujchiren ñunu Dios ura' kisa ti' pa'nu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tsenñu Jacob ya' amanu tsandimi: Tsaaren in naatalaya ya' bulu pijunbeeñuba, iyaa tsa jutyuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tsa' mitya, apa inu ta'kashu juntsaa, naa iya anbukentsuñuba mijanu tsuve; tsejtu Diosnu inu ura' kisa ti' pa'tyumujchi, firu' iinuuya pa'nu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tsenñu ya' ama tsandimi: Naa ñu' apa tsandi' Dioschi firu' isa tya' pañuba, inaa tsaisa. Tsa' mitya ñuya iya naatiñuba juntsangue' pai chibu kailla kaide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tsenñu Jacob jitu pai chibu kailla ka' taja' ya' amanu kuwañu, ya' ama uu finuke luguu ketu, Isaac naaju mutyamuñuba juntsangue kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Tsejtu bene ya' uñaku Esaúchi yasha uukare' tanañu jali, kayu ura jumaa kalare' ya' benna Jacobnu pandemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Tsanguetu bene kaa chibu kika jumulaa Jacob' tyaapatala bain, naa kutu tyullatala bain dedishukaami, matyu ju chutyundalaya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tsejtu naa juntsa luguu bain, naa ya' keñu pan bain kuwa' eemi ya' apanu taji' kuwanutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Tsenñu Jacob ya' apa' puinsha vitu: ¡Apa! timi. Tsenñu Isaac pakatu: Enu entsanayu. ¿Ñu mujtuuyu, apa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tsenñu Jacob pakatu: Iya ñu' ajke' na, Esaúyu. Iya yumaa ñu naakenu mandangueñuba tsanguiyu. Tsa' mitya kujpa' chudi' in ka' taañu animaa panda fide, tsejtu Diosnu inu ura' kisa ti' pa'de, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tsenñu Isaac pake'meetu: Tsen ¿naa kitaa ura jeke katatunguiyu, apa? timi. Tsenñu Jacob pakatu: Ñu' Dios Yavé inu jeke katakaañu' mityaa tsanguiyu, tikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tsenñu Isaac tsandimi: Kalen ja-i' inu ta'kakaaka, naa uwain ñu in na Esaúñuba mijanu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tsenñu Jacob ya' apa' junga kalen jiiñu, Isaac ta'keetu tsandimi: Pamiya Jacob pan tsandituren, tyaapaya uwain Esaú' tyaapa deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tsejtu keengatyumi, ya' pejpelaya pijun juutu, ya' naatala Esaúchi kera deeñu' mitya. Tsejtu Dioschi ura' isa tinundiyandu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","manbake'meetu entsa mandimi: ¿Uwain ñu in na Esaúyu? timi. Tsenñu: Jeen, iya Esaúyu, tikami Jacob. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tsenñu ya' apa tsandimi: Tsaaya, apa, ñu' jeendaa ji' kañu alla taade fichi, tsejtu iya ñunu Dios ura' kisa ti' pa'nu tsuyu, timi. Tsenñu ya' apanu Jacob panda kuwatu, binu bain taji' kuwañu, Isaac panda fi', binu bain kujchimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tsejtu bene tsandimi: Apa, engu kalen ja-i' inu estikika, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tsenñu Jacob esti' kalen mi'najiñu, Isaac ya' jali aindyu ishkatu, entsandi pa' Dioschi ura' isa timi: Uwain, entsaya in na' aindyuve, Dioschi ura' iwara jeenbala aindyu jun tsaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Diosya selusha pumu shuwa ñuchi jakaakasa, ñu' pu' wajkala bain ura' de-isa, naa trigu juula bain, naa uva juula bain pure' ideisa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Pure' chachilla ñuchi tiba kiikemu dejusa; tsandityu'ba, naaju chachilla bain ñu' ajuusha deteedisa. Ñu' paandelanu bain uudenguen chude; ¡Yala ñu' ajuusha deteedisa! Mun ñunu Dioschi firu' isa deti'ba, yalaa firu' de-isa; tsenmin mun ñunu Dioschi ura' isa deti'ba, yalaa ura' de-isa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Tsejtu Isaac Jacobnu Dioschi ura' isa ti' depa' dyañu, Jacob ya' apa' chuinsha pu' malun iinmalaren, Esaú jeendaa pu' maami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Tsejtu ya bain uu finuke luguu ke', ya' apa' junga tajitu entsandimi: Apa, umaa kujpa', ñu' na' jeendaa ji' aingañu alla fide, tsejtu inu Dioschi ura' ikaaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tsenñu Isaac pake'meetu: ¿Ñu mujtuuyu? timi. Tsenñu: Iya ñu' ajke' na Esaúyu, tikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tsandiñu Isaac wapanbashiimi, tsai' depi'shikendu tsandimi: Tsaaya, ¿maa jeendaa ji' ainga' maja' inu juntsa alla luguu taja' kutunguen? Tsenñu iya ñu kayu majaindyuren yumaa tiba defi'keeyu, tsenmin yanaa Dios ura' kisa ti' pa'yu. Tsa' mitya challa yaa yumaa Dioschi ura' inu tirave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tsenñu Esaú ya' apa tsandiñu meenatu, pure' llakindya' ware' ui'tu entsandimi: ¡Diosnu pa' inu bain ura' kisa tide, apa! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tsenñu Isaac tsandimi: Yumaa ñu' benna ja' inu anbuda keranguikaañuve, tsejtu yaa Dioschi ura' inutsumi ñuchi jumunun kakeñunguive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tsenñu pakatu: ¡Mikan Jacob mumu depuñuve, timi Esaú, matyu yumaa pai bijee inu entsanguentsuve! Ajke' bijeenuya in avenju na deechu jumaa inu chipakeñunguive, tsenmala umaya Dioschi ura' inu jumu bain yaren mangave, timi. Tsejtu bene ya' apanu entsandimi: ¿Dioschi kayu vera ura' inutsumi juuya inchiba laakarendyuyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Tsenñu Isaac pakatu tsandimi: Iya Jacobnu naa ñunu bain uudenguenu tirekiyu, tsenmin kumuinchi ya' paandelanu bain yachi tiba kiikemu chachi juu tene detireyu, naa trigu bain, naa binu bain pure' iwaakisa tiyu. Tsa' mitya ¿challa ñu' mityaya tyeenguenuu juwa, apa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Tsenñu Esaú patindu entsandimi: ¿Tsejtu ma bijeeren Dioschi ura' isa ti' patinuu jujuu, apa? ¡Diosnu, inu bain ura' kisa ti' pa'de! timi. Tsejtu manen uti' mawaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tsenñu ya' apa Isaac tsandimi: Ura tu chutyuinsha baasha chunu tsuve, naa selusha bain shuwa pajatyuinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ñu' peeniyachee vinguen chunu tsuve, ñu' naatalachi taawasha kiikemu tiyanu tsuve. Tsaaren ñu bene tsanguen chutu vera' tyamiya, yachi uuden ma-in chutyu tiyanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tsenñu jumalan Esaú tsaa Jacobnu kerandyatyuu tiyaimi, matyu ya' apa yanaa Dios ura' kisa ti' pa'ñu' mitya, tsejtu entsangue pensanguiikemi: “Wajtunuren apa peyanmalaya llakinguenu detsuyu; tsaaren tsaa depuimiya in naatala Jacobnu tu'nu tsuyu”, tyatyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tsenñuren naa ya' avenju na Esaú ti kenu pensanguentsuñuba Rebecanu dewainñu mijatu, ya' kayi na Jacobnu mikatu entsandimi: Ñu' uñaku Esaú ñunu tute' vejmi' mannu tyantsuñuba mijade. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tsa' mitya, apa, inu meedika, challaren Harán pebulusha nepiyade, in naatala Labán' yasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tsejtu junga tsanade, ñu' naatala ajara de-ishpuitendyuya, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","tsenmin ñu yanu naakiñuba juntsan mitya vejmi' manguen jutyuu tiyanbera junga tsanade. Tsenmala ñu maanu ura tiyanmala bene iya mawainnu tsuyu, ¡matyu ma malunun ñullanu pallu depirekindendyuve! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Bene Rebeca Isaacnu entsandimi: Jaiba ura' chukeetyuve, Hetnu sera' jimu paande na'malanu Esaú supunga' chudishu juntsala' mityaren. Tsa' mitya Jacob bain entsa Hetnu sera' jimu paande na'mala enu Canaán tunu chumu naadejuñuba juntsaalanu supunga' chushu juntsaa, iya peñuba ne uraave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tsenñu Isaac Jacobnu mika', manen Dioschi ura' isa titu entsangue uudenguemi: Entsa Canaán tunu chumulanuya jaiba supungatyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tsa' mitya Padán-aram tushaa jide, ñu' aa-apa Betuel' yasha, tsai' jungaa ñu' ajchiyu Labán' na'malanu mallee supungade. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Matyu tiba kekaanuu jumu Dios ñunu tiba ura' ikaasa, tsenmin ñunu sera' jimulanu bain pure' seewaake', main main ma uñichi uuden juu vee vee bulu chachi chumulanu deseewaasa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tsenmin ñunu bain, naa ñunu sera' jimu chachillanu bain, Dios naati' Abrahamnu ura' ikaanu tsuyu timuwa ju'ba ñullanu bain tsanguisa. Tsenmala challa ñu vee mujtu chumu chachi juu chunashu juntsa tunu ñuichi tirenudetsu, matyu Diosya Abrahamnu kunu pamuwaañu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Entsanguetaa Isaac Jacobnu Padán-aramsha eemi. Tsenñu Jacob Labán' yasha jinu jimi, matyu Aramnu sera' jimu chachi Betuel' na' junga, tsenmin Labánya Rebeca' kayami, matyu Jacobchi bain, naa Esaúchi bain ya' ama' kaya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú mijami naa Isaac Jacobnaa ura' isa ti' Diosnu pa' Padán-aram tushaa ji', jungaa supungade ti' eeñu bain. Tsenmin mijami naa ya' apa, Jacobnu Dioschi ura' isa ti' pa'tu, Canaán tusha chumulanuya munuba supungatyude tiñu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","tsenñu Jacob ya' apala naadetiñuba juntsanu meenguitaa, Padán-aramsha jiñu bain mijami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tsenñaa Esaú mijami naa ya' apaya, Canaán tusha chumu supulanu mutyatyuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tsenñu Esaú, Abraham' na Ismael' junga jiimi, tsai' ya' na'ma Mahalatnu supu mangakemi, Nebaiot naatalanu, yaa yumaa Canaán tusha chumu supula bain miyawaaren. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob Beerseba pebulunu lu' jitu Harán pebulusha jintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tsejtu manbela jitu, junaa kepe tsudi' puinu tiyami, yumaa pajtaya viñu' mitya. Tsejtu juntsa tenanu tsumu shupukaa main katu, ya' mishkai'sha daatsureke' tsudi' kasmi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Tsai' kipitu, ma llapi juuyaa tunu uinamin tsaa selusha tapa'kayana uina katami. Tsenñu juntsa llapinu Diosa' anjeelaa vija' malu maluintsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tsenmin naa Yavénu bain ya' kelunu uyuna katami. Tsenñu entsandimi: Iyaa Yavéyu, matyu ñu' aa-apa Abraham' Dios, naa ñu' apa Isaacchi bain ya' Diosyu. Iyaa ñunu bain, naa ñunu sera' jimu chachillanu bain, entsa ñu' tsunashu juntsa tu dekuwanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ñunu sera' jimulaa tu llujpepe juuñuu pureinu detsuve, tsejtu naa nurtesha bain, naa sursha bain, naa pajlainsha bain, naa pajvinsha bain seetse'ke' jiinu detsuve. Tsenmin kumuinchi entsa tunu chumu chachillaya ñu' mitya bain, naa ñunu sera' jimu chachilla' mitya bain, Dioschi ura' i-iinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Iyaa ñuba bulu chunu tsuyu. Ñu nuka jiñuba iyaa ñunu keena' washkenu tsuyu, tsenmin entsa tusha manen majamishtinu tsuyu. Tsa' mitya ñunu naati'ba juntsa tsangui'mujchiya maali tiren jutyuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tsenñu Jacob kipi' mandengatu, entsangue pensanguemi: “Uwain entsa tenanu Yavé punuren, iya mijaindyuwañuve”, tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tsejtu yuj balengure' jeetyatu entsangue pensanguemi: “Entsa tenasha Dioschin juu tenañuve; enu Diosa' ya chuñuve, tsenmin selusha lunu juukapañuve”, tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tsejtu Jacob ayunchi dishkepenene kujpatu, ya' mishkai'sha daatsuuñu shupukaa ka' llu'pu' uikaami. Tsejtu mandenga mandengakenu tiretu, juntsa shupu' jandala ulibu puka muli yuutsungaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tsejtu Jacob, naa kaspeleya juntsa tenanu ma pebulu Luz mumu puu chumuwaañuba, ya' mumu maveteke', Betel, tsandityu'ba “Diosa' chununu” mumu manbumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tsejtu Jacob junu Diosnu paka' uwain tsanguenbera kenu tsuyu titu entsandimi: Uwain Dios iba bulu ne' tiba jutyu washke' miya' ne', naa ti fikenuu bain, naa jali bain kuwa', ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tiba jutyu uraren in apa' yasha miikaashu juntsaa, uwain Yavé in Dios junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tsa' mitya entsa ka' llu'pu' uikaañu shupukaa, mandenga mandengakentsumi tiya', Diosa' chununu junu tsuve. Tsenmin Dios, naa-uwanuba ñu inu ti kuñu bain, juntsanu paitya pela vele' tsure', ma pela tsumuya ñunu kuwa kuwakenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob kayu miñu ajkesha jitu, pajlainsha chulla' tusha vijimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Tsejtu panbasha ma pusu katami. Tsenñu juntsa pusu keetala uveja pen bulu juna vela' tsudi' lekantsula, matyu juntsa pusunaa animaala pi kushmu de' mitya. Tsenñu juntsa pusu juukapanu ma shupuka aawa di'nami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tsejtu uveja washkemula kumuinchi uvejala junu dewakukaataa, juntsa shupuka manga mangakemula, tsangue' uvejalanu pi kuwanu. Tsejtu bene manen juntsa pusunu shupukachi mallu'mu jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Tsenñu Jacob uveja washkemulanu pake'meetu tsandimi: Rukula, ¿ñulla nuka chumu deeyu? timi. Tsenñu yala pakatu: Lalaya Harán pebulusha chumu deeyu, tikala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tsa detiñu pake'meetu: ¿Ñulla Nahor' paña Labánnu kera dejuu? timi. Tsenñu yala pakatu: Lalaya kera deeyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tsenñu Jacob manbatu: ¿Tiba jutyu ura chun? timi. Tsenñu uveja washkemula: Jeen, ura chuve, tila. Tsanditu: Enu entsaintsuve ya' na'ma Raquel ya' uvejalaba jantsumi, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tsenñu Jacob tsandimi: Chaiba aa maluñu' mitya, uveja mallu'nu ura jutyuve. ¿Nenñaa piren kushkareke' manen tape mafikaajinu dejui'yu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tsenñu yala tsandila: Kayu kumuinchi uvejala tajaindetyuya, tsenmin uveja washkemula bain deja' juntsa pusu juukapanu di'namu shupuka demanga' uvejalanu pi kushkaatyumujchiya, tsanguenu dejutyuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tsejtu Jacob yaiba tsandin uinan, Raquel ya' apa' uvejalaba junga jimi, yaa juntsa uvejalanu washkemu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tsenñu Jacob nei'ba ya' ajchiyu Labán' uvejalaba Raquelnu jañu katamiren, tsaa pusu juukapasha ji' junu shupuka di'namu juruke' juntsa uvejalanu pi kushkaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Tsejtu bene Raquelnu ura' chude ti' estitu sundenganchin ne warendimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tsejtu Raquelnu Jacob, yaa Labán' ajchiñayu, tsenmin Rebeca' nayu, tinmalaren, Raquel yangachi mijiimi, ya' apanu kuinda kenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tsenñu Labán, Jacob, ya' tsujki' nave detiñu meemiren, ya' yasha miya' jinu, tsaa yangachi jiimi, tsa' ji' katatu angue', ura' jusa ti' estitu, ya' yasha miya' jimi. Tsejtu bene Jacob ya naa naa-i' bain millandi kuinda kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Tsenñu Labán entsandimi: Uwain ñu in paande' mitya, in asaren juve, timi. Tsejtu Jacob Labánba ma chu'chaya chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Tsenñu bene Labán Jacobnu entsandimi: Ñu in paandeyu titu, ñuchi tiba katyumujchiren inchi taawasha ken jutyuve. Tsaju' ñu' taawasha' mitya nan kuwasa tenñuba wainka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tsaaren Labán pai na'ma miyawaami: avenjuya Lía mumunmala, kayiya Raquel mumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Líaya bibu' kapukajtumi, tsaanuren Raquelya neepabi uukeraa lumin, tsaa mishusha lun uukerami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tsenñu Jacobya Raquelnu mutya' mitya, entsandi pakami: Ñu' kayi na'ma Raquel' mitya mandishpai añu taawasha kenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Tsenñu Labán pakatu tsandimi: Ñunaa kuwañu uranu juve, vee chachillanaa kuwatyumujchi. Tsa' mitya iba chude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tsejtu Jacob Raquel' mitya mandishpai añu taawasha kemi, tsanguiñuren yachi juntsa tinbu jei depulla' dyami, Raquelnu tsamantsa mutyantsuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tsejtu mandishpai añu umaa tiyañu, Jacob Labánnu tsandimi: In shinbu tiyanuu jumunu inu kuwaka, yanu supunganu tenve, yumaa ya' mitya iya naake taawasha kenu ti' pamuwaañuba juntsa malu yumaa tiyave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tsenñu Labán kumuinchi ya' ya keetala chumulanuya demikakemi, supunganu fandangu ketu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tsejturen Labán kepe Líanaa ka' Jacob' junga ta'mi, tsenñu Jacob yaba tsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Tsanguetu Labán, yachi tiba kiikemu na'ma Zilpánu Líanu me'mi, matyu yanu tyeeba kive'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tsenñu ayunchi Jacob mijami Líabaa detsuuñuba, tsejtu Labánnu ajaa ti' ura' pake'meetu tsandimi: ¿Inu tyeenguetunguiyu? ¿Iya ñuba Raquel' mityaa taawasha kindyuwa? Tsaashu juntsaa ¿nenñaa inu anbukitunguiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tsenñu Labán tsandimi: Enuya lalaa kayu ave na'ma unbee kayaindyuya, kayi na'manaa unbee kakaatyuwa deeyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tsa' mitya Líanu ka' chuñu mandishpai malu dekide, tsenmalaa Raquelnu bain kuwanu tsuyu, ñu manen iba kama mandishpai añu taawasha mannu ti' pashu juntsaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Tsenñu Jacob: Tsaaya tsanguiñu urave, timi. Tsenñu Líanu ka' chuñu mandishpai malu depuiñu, Labán Raquelnu bain Jacobnu kuwami ya' shinbu tirenutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Tsanguetu Labán, yachi tiba kiikemu na'ma Bilhánu Raquelnu me'mi, yanu tyeeba kive'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tsenñu Jacob Raquelba bain tyushami, tsejtu yanaa Líanuba kayu pullai estyami. Tsejtu manen Labánchi kama mandishpai añu taawasha manmi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jacob, Líanu jayun mutyaimuñuba Yavé keenatu, Líanuya na miyandiwaami, tsaaren Raquelya navinu jutyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Tsenñu Lía navi' nakatu, Rubén mumu pumi (hebreo palaachiya: “Keekidei, ma kaana”, titu), entsanditu: Yavéya iya llakindyañuba katave; tsa' mitya challa in ruku inu estyanu juve, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Bene Lía kama na mangami, tsejtu Simeón mumu pumi (hebreo palaachiya, “meenu” titiñuu bain juve titu). Tsejtu tsandimi: Yavéya inu jayun mutyaimuñuba meeñuve. Tsa' mitya manen na main manguve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tsejtu bene kama bijee na mangatu, Leví mumu pumi, (hebreo palaachiya “buudinu” titiñuu juve titu), entsandi' mitya: Challa in ruku inaa kayu mi'dinu juve, yumaa yanu pen na ka' kuñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tsejtu Lía bene bain kama na mamiyanditu, juntsanu Judá mumu pumi (hebreo palaachiya Judá palaa, “yuj urave” titiñuu juve titu), entsandi' mitya: Umaa entsa bijeenuya Yavénu yuj urave tintsuyu, titu. Entsaitu Lía bene umaa na mangatyui tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquel, Jacobnu naka' kutyuumin, ya' uñamanu ne kishtyaimi, tsejtu ya' rukunu entsandimi: Inu navikaaka; vikaatyushu juntsaa yujkanchin peyanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tsenñu Jacob yanu ajaa ti' patu entsandimi: ¿Tsejtu iyaa Dios juu? Diosyaa ñunu navikarendyuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tsenñu Raquel tsandimi: Tsaashu juntsaa, inchi tiba kiikemu na'ma Bilhánu ka' yaba tsude; tsenmala ya nakanmalaya, juntsanu in na juuñuu tirenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Entsanditu Raquel yachi tiba kiikemu na'ma Bilhánu tsaa Jacobnu kuwakemi, yachi kama miyandinu shinbu tirekitu. Tsenñu Jacob Bilhába tsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tsenñu Bilhá, Jacobnu na main ka' kuwañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raquel tsandimi: Entsa kaana Dan mumunu tsuve, (hebreo palaachiya, “deechu' kenu” titiñuu juve titu), entsandi' mitya: Dios i yaba kuinda keñu mere', tyee keñu urañuba juntsangue' inu na main kuwañu' mitya, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tsenñu bene bain Bilhá, Jacobnu kama na manga' kuñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquel tsandimi: Entsa kaanaya Neftalí mumunu tsuve, (hebreo palaachiya, “vinguenu” titiñuu juve titu), entsandi' mitya: In uñamaba veta' veta' vinguikeñunguendun, iyaa puiyu, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tsenmala Lía bain yumaa na mangatyu tiyatu, yachi tiba kiikemu na'ma Zilpánu tsaa Jacobnu kuwakemi, yachi kama miyandinu shinbu tirekitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Tsenñu Zilpá, Jacobnu na main ka' kuwañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lía tsandimi: ¡Mika urave! Tsa' mitya entsa kaanaa Gad mumunu tsuve, (hebreo palaachiya “ura' iñuve” titiñuu juve titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tsejtu bene bain Zilpá kama na Jacobnu manga' kumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tsenñu manen Lía tsandimi: ¡Yuj sundenve! Challaa supula inu yuj sundyaa tinu detsuve. Tsa' mitya entsa kaanaya Aser mumunu tsuve, (hebreo palaachiya, “sundennu” titiñuu juve titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Trigu inu tinbutala, ma malu Rubén jeenbaasha jimi. Tsejtu junga, finu puka ya' mumu mandraguras katami, tsejtu ya' ama Líachi ta'mi. Tsenñu Raquel juntsa puka katatu, Líanu tsandimi: Inuba mallee ñu' na' ka' taañu mandraguras puka kuwaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tsenñu Lía pakatu tsandimi: ¿Ñaa inu in ruku machi'ketu tiba kendyuyu tenguee? ¿Tsenmin challa in na' ka' maañu mandraguras puka bain chi'kenu tendyuka? timi. Tsenñu Raquel: Ñu' na' mandraguras puka inu kuwashu juntsaa, uma kepe Jacob ñuba tsunu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tsenñu kepenusha Jacob jeenbaasha pu' maantsu, Lía yanu katanu lutu tsandimi: Umaa ñu iba tsunu tsuve, in na' mandraguras puka Raquelnu kuwatu tsai deshuwa' mitya, timi. Tsenñu Jacob juntsa kepe Líaba tsumi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","tsenñu Lía na mavi' mangami, ya Diosba kuinda keñu, Dios meeñu' mitya, tsejtu umaa juntsaba Jacobchi man na seenguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tsejtu Lía tsandimi: Entsa kaanaa Isacar mumunu tsuve, (hebreo palaachiya “ne kuwanu” titiñuu juve titu), iya in rukunu inchi manda-imu na'manu kuwan mitya Dios inu mekikiñunguive, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tsejtu bene Lía manen Jacobnu na manga' kuwatu, umaa entsaba yachi mandishmain na kami, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","tsejtu tsandimi: Dios inu naraa me've. Tsa' mitya challa in ruku inu kayu estyanu juve, yumaa mandishmain na ka' kuwañu' mitya. Tsa' mitya entsa kaanaya Zabulón mumunu tsuve, (hebreo palaachiya “me'nu” titiñuu juve titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tsejtu bene Lía supu na'maa katu, juntsanu Dina mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tsenñu Dios, Raquelnu bain mandengami yaba kuinda kemuwaañu. Tsai' juntsanguetu na miyandinu tirekaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tsenñu Raquel yachi ajke' na miyanditu tsandimi: Umaa Dios inu nakatyu' yujpen chuñuba umaa manbaishwaave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Tsejtu juntsa kaananu José mumu pumi (hebreo palaachiya, “kayu kunu” titiñuu juve titu), entsandi' mitya: Inu kayu na miyandikaasa, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raquel, Josénu nakañu, bene Jacob Labánnu tsandimi: Inu in tusha me-eeka. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Tsa' mitya in shinbulanu bain, naa in kaillanu bain iba tiba jutyu me-eeka, yala' mityaa iya ñuchi taawasha kiyu. Tsa' mitya mandyaike' me-eeka. Tsenmin ñuya mive iya ñuba naake taawasha keñuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tsenñu Labán pakatu tsandimi: Tsantsaya iba chudisa tenve. Ñuren tsandisa tyañuya entsandinu tenve: Yavéya inu ñu' mityaren ura' ikaantsuñuba mijayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tsa' mitya ñu' taawasha kikenuushu juntsa' mitya nan kuwasa tenñuba inu wainka, tsenmala iya juntsangue kuwanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Tsenñu Jacob tsandimi: Ñuya nara mive iya ñu' mitya naake taawasha keñu bain, naa ñu' animaalanu naake washkeñaa kayu ura' detiyañu bain; ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","iya kayu engu jaindyuya ñuchi animaa jayun juuwa deeve, tsaaren challa pure' sera deive, matyu iya engu jainmalan Yavé ñunu mika ura' ikaañu' mitya. Tsa' mitya ¿naamaa iba in bululachin juu taawasha kenujtuuwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Tsenñu Labán manen: ¿Ñu' taawasha kikenuushu juntsa' mitya nan kuwasa tenguen? timi. Tsenñu Jacob manbakatu: Tiba kuwatyuka. Tsaaren iya tyee panu juñuba ñu juntsanguenu tiyashu juntsaa, ñu' animaalanu mawashkenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Uma ñu' animaa puinsha jinu tsuyu, tsejtu kumuinchi uvejalanu bain, naa chibu pe'pe'jaraalanu bain, tsenmin uveja yapijtutuulanu bain deveekanu tsuyu. Tsejtu juntsalaa in taawasha' mitya kuwakiñuu junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tsenmalaa ñu mandinbu in kañu animaalanu ja' keetu, uwain iya ura' kemu ruku firu' ketyuñuve tyanu tsuve. Tsa' mitya in uveja paasha naaju chibu pe'pe'jaraa jutyula bain, naa uveja pababaa jutyula bain in junga depushu juntsaa, ñunu taanguiñaa tsaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Tsenñu Labán: Tsaaya urave, ñu naatiñu bain tsaasa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tsandituren juntsa malunun Labán tsaa kumuinchi llupu chibu piichililija'teelanu bain, naa pababaa puja'teelanu bain dekakemi, tsenmin kumuinchi supu chibu pe'pe'jaraalanu bain, naa pababa puja'teelanu bain, naa ne fibaba jayu puja'teelanu bain dekakemi, tsenmin uveja pababaalanu bain dekake', ya' nalanu washkidei ti' kuwakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tsejtu bene, pen malu nainsha baasha juntsa animaalaba Jacob' pununu baajiimi. Tsaaren Labán' vejan animaalanu Jacobya washi washikentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tsejtu Jacob alamu chi ali bain, naa almendru chi ali bain, naa kastañu chi ali bain daaka', fibaba pilla juja'tengue dellashmi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Tsanguetu bene juntsa cha'li dellajchaaya animaa puinsha, yala' pi kujchi kujchikenu juusha uikaami, matyu junaa unbee rukula supulanu nakaapupu dekiñu' mitya. Tsa' mitya juntsa cha'li ajuutala tsa tsa dekiñu, yala' kailla piichililii bain, naa pe'pe'jaraa bain fale falekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Tsenmala Jacob vela' kalaalaakemi juntsa uvejalanu; tsanguetu Jacob Labán' animaalanu tinu bain piichililiitala bain, naa ne pababaalanu bain tsaanu tene keekaakaakemi. Entsanguetaa yachi bain maali animaala demiyandimi, matyu Labán' animaalanu mantsa vela' kalaalaaketu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tsejtu naa-uwanu dera' animaa juulaa tsa tsaindetsuñuba Jacob junu juntsa cha'li uikaakaakemi nunbanu pi kushmu deeñu bain, tsenmalaa animaala tsanguenu uwanu juntsa cha'linu kataataakenudetsu; ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","tsaaren animaala ejkee dejashu juntsaa, cha'li uikaatyu jujuumi. Tsa' mitya ejkekee animaalaya Labánchi tene detiyanmala, kayu dera' juu animaalaya Jacobchi tene tiya tiyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Entsanguitaa Jacob mika taruku tiyami, naa uveja juula bain, naa chibu juula bain, naa tiba kiikemu chachilla, unbee rukula bain, supula bain, naa kameyula bain, naa burula bain pure' miyandiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bene Jacob mijami naa Labán' nalaya, yanu kumuinchi junu yala' apachi jumunu tene dekake' juntsachin taruku ne tiyaive, tis nendetsuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Tsenmin Jacob mijami, naa Labán bain yumaa yanu kaspele naajuwa ju'ba juntsaa jutyu detiyaintsuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tsenñu Jacobnu Yavé tsandimi: Ñu' apa' tusha, ñu' paandela chudenashu junga miide; iya miimishtinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tsenñu Jacob, Raquelnu bain, Líanu bain jeenbaasha ya' animaa washkensha janu mandanguemi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","tsejtu tsandimi: Naa ñulla' apa inu kaspele naajuwa ju'ba yumaa juntsaa jutyu tiyaiñuba mijayu; tsenñuren in apala' Diosya naa-uwanuba inu kemishtintsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tsaaren ñulla nara mideeve naa iya ñulla' apachi pudengura taawasha ken chumuñuba; ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","tsaanuren yaa inu anbukikeñunguiike', naa in taawasha' mitya inu kuwandu bain wajtunun jeke vera' mangui manguikive. Naa tsanguiñu bain, Diosya tiba yanu inu firu' kekarendyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tsa' mityaa naa-uwanu: Umaa pe'pe'jaraa animaalaa ñu' taawasha' mitya kuwanu tsuyu, tiñuba, supu animaala nakamee pe'pe'jaraa tene kamu deeve. Tsenmala naa-uwanu: Umaa piichililija'tee animaalaa ñu' taawasha' mitya kuwanu tsuyu, tiñuba, kumuinchi supu animaala nakamee piichililiindene kamu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Entsanguitaa Dios ñulla' apa' animaa dechi'ke' inu kuwave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Tsaaren ma malu, supu animaala de-asanu uwanu kipiyu, tsenñu kipibi unbee ruku animaala supu animaalanu na pumula piichililii bain, naa pe'pe'jaraa bain tsaandene juju deewa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tsenñu tsai' kipiñu, Diosa' anjee inu in mumunu pawa, tsenñu iya: Enu entsanayu, tikawayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Tsenñu anjee inu entsandiwa: Ura' keekide, tsejtu katanu tsuve, unbee rukula supulanu na pumula piichililii bain, naa pe'pe'jaraa bain tsaayaa tsa tsa dekive, tsaanuren Labán ñunu naakintsuñuba mija' mityanguiyu tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iyaa ñunu Betel tenabi katawamu Diosyu, ñu shupukanu muli tsure' uwain tsanguenbera kenu tsuyu ti' panu tenanu katawamu Dios. Tsa' mitya entsa tenanu mangujpa' miide, tsai' ñu' nakayanu tusha miide, tiwa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tsenñu Raquel Líaba entsandi pakala: Lalaya yumaa apa' yasha tiba laachi tirekenuu tajtu tiya deiyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","¡Tsenmin lalanu vee chachi dejuñu ken tsangue', naa atyanchi bain lalanu atikeñunguive, tsenmin ñu lala' mitya paanguiñu taawasha' mitya bain yaa mujmuusu kive! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Naa tsanguiñuba ti bain Dios lala' apanu ñuchi detirenu chipakishu juntsaya laachi tene juuve, naa lala' kaillachi bain. Tsa' mitya Dios ñunu naatiñuba tsanguide, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Tsejtu Jacob ya' apa Isaac' chunu Canaán tusha miinu ura' demanguikemi. Tsangue' ya' kaillanu bain, naa ya' shinbulanu bain, kameyu jandala de-e'lare' chujtimi, Padán-aram tusha taawasha ke' kañu animaalaba demanga' miinu ketu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tsenñu Labán ya' uvejalanu ju dedaanu vee tenasha jimuwaañu, Raquel tsaa ya' apa' chi dyusla, ya' paandelachi jumuwaañu tanamunu tsaa taranguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Entsaitaa Jacob: Mijintsuyu, ti' waintyu' miitu, Aramnu sera' jimu chachi Labánnu anbukemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tsai' kumuinchi ya ti taju'ba juntsalaba nepiya' miimi. Tsejtu wajturen Éufrates pinu mandapulla', ajkesha Galaad kuyi tenasha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Bene pen malu insha Labánnu Jacob nepiya' miive, ti' wainla. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tsenmalan Labán bendaa kenu ya' paandelaba lu' jiimi, tsejtu mandishpai malu insha Galaad kuyi tenasha mami'na jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tsenñuren Dios juntsa kepe, Aramnu sera' jimu chachi Labánnu kipibi katawatu tsandimi: Inu meedika; Jacobnu na'baasa panu kityude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labán Jacobnu Galaad kuyibi mami'najimi, junaa Jacob kajdiñu' mitya. Tsejtu Labán bain ya' paandelaba juntsa butyunuren kajdijimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Tsejtu Jacobnu ajaa ti' patu entsandimi: ¿Nenñaa inu anbukiyu? ¡In na'malanu vingue' pulla' peesu chacheeba ka' tajan tsaiñuve! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Nenñaa inu anbuke', tiba pai'mujchi nepiya' maayu? Mijaiba ituya, tsamantsa sunden depuimishti', naa chiki chiki juu bain depakare', naa arpachi juu bain beesa dekikare'ba tsangue' me-eechuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tsenmin naa in na'malanu bain, naa in pañalanu bain miindetsuñu ne estikaanungui've. ¡Matyu yuj iiñuu ne kikeñuve! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Iya ñullanu na'baasa kenu tenñuya tsangue'banguichuyu; tsaanuren kepe ñu' apa' Dios inu patu tsandingayu: Inu meedika; Jacobnu na'baasa panu kityude, tingayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tsaaren ñu' apa' yasha miji'kera tenñu mala' maamiba, ¿nenñaa chi dyus jumula inchi taanguetunguiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tsenñu Jacob Labánnu pakatu tsandimi: Iya jeetenñuuyu ñunu waintyumi. Iya tsandinmalan derancheeba ñu' na'malanu machi'ke'ba kichuve pensangue' mityaa tsaayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tsaaren mun enu pudenashu juntsala ñu' chi dyus jumula tanañu katashu juntsaa ¡matyu peyasa! Ñu' paandela bain, naa in paandela bain dekeenave. Tsa' mitya wainka i ñuchi tyeeba tanañuya, tsangue' manga' miide, timi. Tsaaren Jacobya mijtumi, Raquelyaa juntsa chi dyus jumula taanguiñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tsenñu Labán Jacob' yapayasha vi' keemi, tsejtu bene Lía' yapayasha bain vi' keetu, juntsa pallu manda-imu shinbula' yapayasha bain vi' keetun katai'mi. Tsejtu bene Raquel' yapayasha bain vimi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","tsenñuren Raquel juntsa chi dyus jumula katu, pishkali keraanu tsaa puke', kameyu jandala tsure' chuntsumi kelunu yangare' juntsa jandala chudiñumi. Tsenñu Labán juntsa yapayanu demityaketuren katai'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tsenñu Raquel tsandimi: Apa, naa iya ñu' ajuunu kujpai'ñu bain ajaavityude, tsaaren supulanaa naa-imuwa deeñuba juntsa ju', asa mangueewara' mityaa tsaayu, timi. Tsa' mitya Labán juntsa chi dyus jumula mi'ketun mangatai'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tsenñu Jacob ajaaviitu, Labánnu entsandimi: ¿Iya tyee urajtu kiwa? ¿Iya ti ujchaa keñaa tsamantsandya' inu bendaa ketunguiyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kumuinchi inchi ti juñuba detyashi' kerakive. ¿Tsejtu ñu' yasha tsumu juuya tyee katayu? ¡Enu ñu' paandela' ajuunu bain, naa in paandela' ajuunu bain tsungaade, tsenmala yalaa panu detsuve, maa ura' pantsuñuba! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tsenmin ñuba kumuinchi entsa 20 añu taawasha kikeeshu juntsa tinbutala naa-uwanuba ñu' uveja, naa supu chibu juula bain nashuikindetyuve; tsenmin ñu' uveja paasha pumulanu ne main juuñu bain tute' fibanguindyuyu; ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","tsenmin naa-uwanuba ne jeen animaa, ñu' animaalanu detu'ñu bain ne taja' keewarekebanguindyuyu, juntsan mitya iya in uvejaren manbu manbukiwayu; tsenmin naa mandala bain, naa kepe bain ñu' animaalanu tara dekiñuba, ñu inaa manbaki manbakikemuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mandalaa lujaranchin naa-in tsandentsu punamuwaayu, tsenmala kepe bain ishanchiren naa-in tsandentsu punamuyu. ¡Tsaju' kasujturen pulla pullaimuwaayu! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ñu' yanu ñuba 20 añu chuyu, tsejtu ñu' pai na'mala' mityaren ñu' uudenchi 14 añu taawasha kiyu; tsenmin in tanaashu juntsa animaa demiyandinu bain, ñu' animaa kejtsapala mandishmain añu taawasha kiyu, tsanguiñun ñuya inu in taawasha' mitya kuwanduba wajtutalan jeke vera' mandire mandirekiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tsa' mitya Abrahamchi bain, naa in apa Isaacchi bain aawa kure' keewaawaakenu Diosren iba jui'ñuya, uwaindiyu ñu inu tyanjuu me-eekichuve. Tsaanuren Diosya iya llakindyañuba keena', naa in tyaapa' taawasha keñutala bain keenañuve. Tsa' mityaa kepe in mitya bale-i' ñunu nepañuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tsenñu Labán Jacobnu pakatu tsandimi: Entsa na'malaa in na'mala deeve; naa entsa pañala bain in pañala deeve; naa entsa uvejala bain in uvejala deeve. ¡Tsaju' kumuinchi enu tanashu juntsa inchi tene judeeve! Tsaaren ¿iya challa in na'malanu laapu' pañu bain, naa yala' demiyandiñu kaillanu laapu' pañu bain, yala' mitya tyee kitaa uraa kenu juwa? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Engu jade, ñuba veta' veta' ura' kedaa ti' tsanguenu tiyasai, tsenmala lala palluutala naakenu ti' deshuwañuba lalanu tsa tsanguen chunu mandengaapumu junutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tsenñu Jacob ma shupuka ka', tyutya juuñuu uyukaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Tsejtu ya' paandelanu tsandimi: ¡Shupuka deka' junu wa'kaadei! timi. Tsenñu kumuinchi yala shupuka deka' wa'kaatu, shupuka tenen ma aa butyuke dewa'kare' juntsa shupu' aa butyu wa'kara kelunu panda fila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Tsenñu Labán juntsa tenanu ya' palaachi Jegar Sahadutá timi, (matyu Aramnu sera' jimula' palaachiya “uwain tsa dekive ti' wa'kara aa butyu” titu). Tsenñu Jacob bain ya' palaachi Galaad timi, (matyu hebreo palaachiya “uwain tsa dekive ti' keewara” titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Tsenñu Labán tsandimi: Uma, entsa shupu' aa butyu jumu uwain lala palluutala tsa tsanguenu deshuwañuba, mandengaapupu kenu junu tsuve, timi. Tsa' mityaa junu Galaad mumu vimi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","tsenmin Mispá mumu bain vimi, (hebreo palaachiya entsa palaa, “washna' keenanunu” titu), Labán entsandiñu' mitya: Lala pallu jumula devela' miinmala, lalanu muba keenatyu tiyañuba Yavéya lalanu keenanu juve, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tsandenna ñu in na'malanu na'baasa keñu bain, naa yala dejuñun vee supu mangakeñuba, lalanu muba dekeenai'ñu bain, Diosyaa keena' kuipa punu juñuba tengaya jude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Tsanditu Labán Jacobnu kayu tsandimi: Keekide, iya ñuba tyee kenu pa'ba tsanguenu ti' shupu' butyu wakukaawashu juntsa bain, naa tyutya keraa uyukaawashu juntsa bain enu entsanave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Entsaa lala ñuba veta' veta' naakenu depañuba juntsa keewara junu tsuve, tsenmalaa mu bain enu dapulla' ji' laatala firu' kiiken jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Tsa' mitya entsa ajkeshaya mun firu' kenu tya' dapuiñuba, ñu' aa-apa Abrahamchi bain, naa in aa-apa Nahorchi bain jumu dyusla kavitu dekisa, timi. Tsenñu Jacob ya' apa Isaac' aawa kure' keewaawaakenu Diosnu paka' uwain tsanguenbera kenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Tsejtu bene juntsa kuyisha animaa tute' ju'ke' Diosnu keewaami. Tsanguetu bene ya' paandelanu mikami panda finu. Tsejtu kumuinchi panda fi' juntsa kepe kuyinu kasla. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tsejtu ayunchi dishkepenene, Labán kujpatu ya' pañalanu bain, naa ya' na'malanu bain de-esti', yalanu tichiba ura' dejusa ti' depa', bene ya' tusha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Tsenñu Jacobya kayu ajkesha miintsuñu, Diosa' anjeela fale' katawala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Tsenñu Jacob yalanu katatu, entsandimi: Enuya Diosa' kajdi' chununuve, timi. Tsejtu junu Mahanaim mumu pumi (hebreo palaachiya “kajdi' pai bulu wa'na' chunu tena” titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Tsejtu bene Jacob, ya' naatala Esaúnu ya maantsuyu, ti' wainnu, Edom tu Seírsha kuinda eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Tsejtu: In bale ruku Esaúnu entsandidei: Ñuchi tiba kiikemu, ñu' benna Jacob lalanu entsandinu eeve: Kumuinchi entsa tinbutala Labánba chuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tsejtu naa wagaa juula bain, naa buru juula bain, naa uveja juula bain, naa tiba kiikemu chachilla unbee rukula bain, naa supula bain taantsuyu. Tsejtu entsa kuinda iya ñuchi taawasha kemu ruku ñunu mijakaanu eentsuyu, ñuchi firu' katawan jutyu, tive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tsejtu wainnu jimula miitu, Jacobnu tsandila: Ñu' naatalanu kuinda kenu dejiyu, tsenñu ya bain ñuba mangatanu titu, 400 unberelaba yumaa engu jantsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tsa detiñu meetu, Jacob yuj jeetyatu, ti ken tsandya', mika pensa shuwami. Tsejtu yaba bulu jimu chachillanu pai bulu ma velekemi, naa uvejalanu bain, naa wagaalanu bain, naa kameyulanu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","matyu entsangue pensanguetu: “Esaú ja' manbaate jimulanu vinguiñu bain, vejanlaya nepinu dejuve”, tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tsejtu bene Diosba entsandi kuinda kemi: Yavé, in aa-apa Abraham' Dios, naa in apa Isaacchi bain Dios, ñuya inu in tusha in paandela' junga miide, ti', jungaa tiba ura' dema-ikaanu tsuyu, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Naa tsandimuwaañu bain, iya ñuchi tiba ura' iinuu chachi jutyuyu; tsaanuren ñuya iya ñuchi tiba kiikemu chachinu tsamantsangue ura' washke', naakenu ti'ba tsanguive. Tsejtu iya entsa Jordán pi pulla' jinu uwanuya ka tiba tajtu, in tyutyan cha'liren taaya dapuimuwaayu, tsaaren challaya pai bulu chachi velekenuuya tiyayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","¡Tsa' mitya, tsantsaya inu in naatala Esaú' tyaapanu livee kika! Matyu engu ja', naa inu bain, naa supulanu bain, naa kaillanu bain detutekichuve tendu yuj jeetenve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ñuya entsandimuwaave: Ñunu tiba ura' de-ikare', bene ñunu sera' jimulanu bain lamaa ñiipe tsun tsangue seeware', naake' miken tsangue tiwaanu juyu timuwaave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tsejtu juntsa kepe Jacob junu kastu, ya kumuinchi ti ta'ba mekikenuu jumu demi'ke' kakemi ya' naatala Esaúnu me'nu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Tsejtu supu chibu 200 kamin, llupu chibu 20 kamin, supu uveja 200 kamin, llupu uveja 20 kamin, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 supu kameyu challan nakakemu ya' kaillaba kamin, supu wagara 40 kamin, llupu wagaa paitya kamin, supu buru 20 kamin, tsenmin llupu buru bain paitya kaminguemi, me'nu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Tsejtu bene yachi tiba kiikemu chachillanu, ma bulu animaameemee devele' kuwatu entsandimi: Ñulla ajkesha jidei, tsejtu ma bulu animaamee jayu jayu baka' tajiidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Tsejtu ajke' jimunu eendu tsandimi: In naatala Esaúba katatu, ya ñunu: ¿Maa ñunu uudenguemu ruku jun? ti' pake'meetu; ¿Nukaa jindu iyu? titu: ¿Ñu' tajiintsushu juntsa animaala bain muchiden? ti' pake'meenmala, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","entsandi pakade: Ñuchi tiba kiikemu Jacobchive, tsejtu inu mandanguemu ruku Esaúchi erentsuve. Tsaaren naa ya bain lala' bendala jantsuve, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tsejtu juntsa kelunu bendaa jimunu bain, naa kayu ya' benesha jimulanu bain, tsenmin kumuinchi juntsa animaa ta'mulanu bain Esaúnu katatu, tsaandene padei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tsenmin: Ñuchi tiba kiikemu Jacob bain, lala' bendala jantsuve, tidei, timi. Jacobya entsangue pensanguetaa tsanguentsumi: “Naa ya ajarañuba, i yanu ajkesha me'nu eekentsaashu juntsachi ma ishpuitekare', benee i bain yaba mangatawanmalaa inu ura' mamika'ba kenuumeete”, tyataa tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tsejtu mekikenuu jumulaya ajkesha de-eetu, yaa ya' kajdi' tsununu tsana shuwami, junu kepe puinu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Juntsa keperen Jacob mangujpa', tsaa ya' pai shinbulanu, naa ya' shinbulachi manda-imu pai shinbulanu bain, naa ya' 11 kailla jumulanu bain dekake', Jaboc pijulanu dapuimishtikemi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","tsenmin kumuinchi ya ti ta'ba demanbuitekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tsejtu Jacob maali shuwaiñu, ma unbere fale' yaba vinguenanan tsaa chayaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tsejtu juntsa ruku Jacobnu puityuumiren, tsaa Jacob' peja'chinu jayu ma daran ta'kikemi. Tsenñu juntsa rukuba vinguentsuren junu Jacobnu mujkiijiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tsenñu juntsa ruku tsandimi: Mandyallakika, yumaa ma dechayaintsuve, timi. Tsenñu Jacob tsandimi: Inu Dioschi ura' ikarendyuya mandyaiken jutyuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tsenñu juntsa ruku: ¿Ti mumuyu? ti' pake'meemi. Tsenñu: Iya Jacob mumuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tsenñu juntsa ruku tsandimi: Umaa Jacob mumu majun jutyuve. Ñu' mumuya Israelya ma junu tsuve, Diosba vinguemin, naa cha' rukulanu bain vingueturen puiñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tsenñu Jacob bain: Umaa ñu bain ti mumu'ba wainka, ti' pake'meemi. Tsenñu juntsa ruku pakatu: ¿Tyeenguenaa in mumu mijanu tenguen? timi. Tsejtu bene juntsa ruku junuren Jacobnu Dioschi ura' isa ti' pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tsenñu Jacob juntsa tenanu Penuel mumu pumi (hebreo palaachiya, “Diosa' kajuru” titu), matyu entsanditu: Diosba kaju'talake katayu, tsejturen peyaiba indyuyu, ti' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tsejtu Jacob Penuel tenanu demanbullaintsunu uwanu pajta faami; tsejturen Jacob janga' terai miintsumi, ya' peja'chi kitya' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tsa' mityaa naa chai bain, Israelnu sera' jimulaya peja'chi allanu chitya chityanguemu wa'chuwaya fityu deeve, juntsa tenanaa Jacob daran imuwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Umaa Jacob, Esaú 400 unbere miyaa jantsu katamiren, Líanu bain, Raquelnu bain, manda-imu shinbu pallu jumulanu bain tsaa kaillanu develekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Tsejtu manda-imu shinbulanuya ya' kaillaba ajke' uyukaami, bene Líanu bain ya' kaillabaren uikaami, tsejtu kayu bene Raquelnu, Joséba uyukaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tsejtu bene yala' ajkesha ji', teledi' mandishpai bijee ya' llashkapa tusha tyuikanbera waikemi, ya' uñaku kalen jingama. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tsenñu Esaú ya' naatala' junga yangachi ji', tsaa kutunu tyaapa pilunbuke angue' uidi' estikemi. Tsejtu sundyanchin tsaa pallu dewaandila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tsejtu bene Esaú jeeke' keetu, naa supulanu bain, naa kaillanu bain kata' pake'meetu tsandimi: ¿Entsala ñuba nemulaa mujtuden? timi. Tsenñu: Ñuchi tiba kiikemu chachinu, Dios inu me'ñu kailla deeve, tikami Jacob. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tsenñu manda-imu shinbula ya' kaillaba dekalen ji' yai bain, teledi' llashkapa tusha tyuikanbera waike' dyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tsenñu bene Lía bain ya' kaillaba jitu, yai bain tsarenguila. Tsenñu umaa José Raquelba jitu yai bain juntsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Tsenñu Esaú pake'meetu: ¿Tyeenguetaa kumuinchi juntsa animaala iya mindala jandu katakeeshu juntsa de-eeyu? timi. Tsenñu Jacob pakatu: Ñu, in bale rukuchi firu' katawan jutyu tenñaa tsanguiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tsenñu Esaú manbakatu: Tsa jutyuve, naatala, i bain mika miyayu. Tsa' mitya ñuchi tadide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tsenñuren Jacob entsandimi: Tsantsaya, uwain iya ñuchi firu' katawaindyuñuya, juntsa me'ñu animaala kade, inchiya ñuba mangatatu Diosba kataakiñuuve, ñu inu mika ura' mamikañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tsantsaya juntsa me'nu tajaiwaashu juntsa kade. Diosya inu taruku tiwaañu, ti bain detadiyayu, timi. Tsejtu Jacob patintsuñu, pulla'bi Esaú: Tsaaya kanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Tsejtu tsandimi: Tsaaren enu malu' miidaa. Iya ñuba bulu miinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tsenñu Jacob pakatu tsandimi: Uñaku, ñuya mive naa kaillaya dijeru' neneinu dejutyuñuba, tsenmin naa uvejalanu bain, naa wagaalanu bain, naa yala' kaillanu bain washkenu menesteyu; yalanu yuj detyubawaashu juntsaa, ma malunun naa uvejala bain, chibula bain millai peyanuu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tsa' mitya entsa ñuchi tiba kiikemu chachinu ma ajñaa kayu uranu juve; tsenmala iya ka jayu jayu, in ajkesha jiindetsushu juntsa animaala naa-i dejiñuba yaiba bulu majainu tsuyu, tsenmin kailla naa-i demaañuba yaiba bulu ne majaitu ñuba Seír tenasha manbuudinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tsenñu Esaú tsandimi: Tsaiñuba urave, tsaaren iba bulu jamulanu mallee ñuiba shuikenu tsuyu, timi. Tsenñu Jacob pakatu: Menestejtuyu, ñu inu ajarajtuñuba juntsan mijaitun mikave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tsenñu juntsa malunun Esaú Seír tusha miinu miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tsenmala Jacobya Sucot jatsuwasha jitu, junaa yachi ya ke', naa animaalachi bain yapaya kemi. Tsenñaa junu Sucot mumumi (hebreo palaachiya, “cha'li deka' tsaa dekus-eraa yapaya” titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob Padán-aram tusha pu', Canaán tusha miji', Siquem pebulu bejkundaa manchuitu, tiba jutyu ura miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tsejtu 100 lepa lushinchi Hamor' nalanu tu ati'kami, matyu Siquemchi ya' apanu, tsejtu junu ya' kajdi' chununu ya' chunu tena manguikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tsejtu junu ufeenda tsure' ju'kenunu main ketu, El-elohé-israel mumu pumi (hebreo palaachiya, “Diosya, Israel' Diosve” titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lía Jacobnu naka' kuwañu na'ma Dina, juntsa tenanu chumu pannala' junga yaa jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tsenñu juntsa tenanu chumu bale ruku Hevenu sera' jimu chachi Hamor' na Siquem katatu, tsaa deranchi tsudimi juntsa na'maba, tsangue' tsaimishtimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tsangueturen juntsa na'manu tsamantsa mutyatu, yanu bain juntsa na'ma mutya' keekenuuya kiike' estyakutyanu mitya mityakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tsejtu Siquem ya' apa Hamornu tsandimi: Ya' apala' junga ji' entsa na'manu pa'de. Yanu supunganu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Naa Jacobya ya' na'ma Dinanu Siquem deranchi tsaiñuba mijaturen, ya' nala jeenbasha ya' animaalaba depuñu' mitya, majaindetyuya tiba paviiki'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Siquemchi ya' apa Hamor, Jacob' junga ji' keemi, yaba kuinda kenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tsenñu Jacob' nala jeenbaasha putun demaatu, tyee iñuba mijala, tsejtu tsamantsai ajaavila, matyu Siquemya Jacob' na'maba tsutu, Israelnu balejtu kurekeñuuya ke', naatenñuba, tsanguen jutyuunuren tsangueñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tsenñuren Hamor yaiba kuinda ketu tsandimi: In na Siquem Dinanu tsamantsa estyave. Tsa' mitya tsantsaya, yanu supungudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tsai' lala' paande tiyadei. Tsaishu juntsaa lala ñulla' na'malanu supunganuu tiyanu dejuyu, tsenmala ñui bain lala' na'malanu supunganuu tiyanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tsejtu laaba chudei. Matyu entsa tenanuya ñuichi chunu ainatyuve. Tsa' mitya enu dechu', ti kenu tenñuba deke', atin chu', naa tu bain ati'kadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Tsenñu Siquem bain, Dina' apanu, naa ya' naatalalanu bain tsandimi: Iya ñuichi ura' katawañuya inu kuwakai ti' u'tandinu tenve. Tsa' mitya ti inu depa'ñu bain kuwanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Matyu veela naake pa'muwa deeñuba juntsanu pullandi depake', naa ñulla inu lushi bain, naa kayu tiba pure' pakidekiñu bain kuwanu tsuyu; inchiya nejuuve, tsaaren juntsa na'manu inu supungukai, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tsenñuren Siquemya Dinanu tsaa deranchi tsaimishtiñu' mitya, Jacob' nala Hamornu bain, naa ya' nanu bain anbutitun ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","entsandila: Ma unbere Dioschi señas jutyunuya, lalaya lala' tsujkinu kunu dejutyuyu, matyu tsanguishu juntsaya, laachiya tsamantsai yujpeyanuu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tsa' mitya lala tsaa, kumuinchi unbeenalaya Dioschi señas indene iishu juntsaa, uwain tsanguenu dejuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tsaishu juntsaa, uwain ñulla lala' na'malanu supunganu dejuve, tsenmala laa bain ñulla' na'malanu supunganu dejuyu. Tsai' ñuiba dechudi' ma bulu chachi juu tiyainu detsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tsaaren ñulla lala tsandi depañun, Dioschi señas de-ityushu juntsaa, enu malu' miji' lala' tsujkinu mandakikenu detsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tsenñu Hamor bain, naa ya' na bain, yala naadetiñu bain tsaaya uraa tyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tsejtu Siquem, matyu keedi'mujchi juntsanguenu shuwami, Jacob' na'manu tsamantsai mutya' mitya. Tsenmin Siquemya, ya' buluutala kayu bale chachi jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tsenñu Hamor, ya' na Siquemba pebulu vinu juukapasha jila, yala' wa'di' kuinda kendala, tsejtu junu juntsa pebulu' chullanu entsandila: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Entsa rukula laaba ura' chachi deeve, tsa' mitya laaba bulu dechusa. Tsejtu yai bain entsa tenanu tyeeba ke' atin dechusa, matyu tuya yala nuka chundetyañuba purenañu' mitya; tsenmala lala yala' na'malanu supunganuu dejuyu. Tsenmala naa yai bain lala' na'malanu supunganuu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tsaaren laaba ma bulu chachi juu tiyanu shuwalaya, kumuinchi lala unbee rukulaya Dioschi señas de-i', yala naakemuwa deeñuba juntsa dekiñaa, laaba chunu shuwanu depave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tsenñu lala tsanguenu depashu juntsaa, kumuinchi yala ti detañu bain, naa animaala bain laachi tiyanu dejuve, tsa' mitya lala uwain Dioschi señas inuu jukeeve tinun judeeyu, tsenmalaren yala laaba chunu dejuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tsenñu kumuinchi juntsa pebulunu chumu unbee rukula, matyu suutadu jiinuu añu juulaya, naa Hamor bain, ya' na Siquem bain naadetiñuba: Uwain tsaaya tsanguiñu urave, tila, tsejtu kumuinchi tsaa Dioschi señas de-ikutikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tsejtu juntsa rukula Dioschi señas de-itu kayu kiya ma-ujtuwarendetyuren, Jacob' nala, Simeón bain, Leví bain, matyu Dina' kayala, pen malu insha pebulusha dejitu, tsanguendenaa tya' pensaba jutyu dechuren, peeniya taa ji', kumuinchi unbee rukulanu detutekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tsenmin Hamornu bain, naa ya' na Siquemnu bain detute', bene Dinanu Siquem' yasha mangalaaji' mijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tsenñu Jacob' nala kayu vejanla bain deji', peya' tsumulanu dekata' jitu, yaichi tiba tañu jumulaya millangue kala, yala' tsujkinu tsangue' dekuñu vejmi' demantu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tsejtu naa uveja juula, naa wagaa juula, naa buru juula bain dekake' mijiila, matyu pebulusha ti dekata' bain, naa jeenbaasha ti dekata' bain dekake' mijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Tsenmin yatala bain ti kata'ba detaranguila, tsangue' kaillanu bain, naa shinbulanu bain deranchi deka' mijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tsenñu Jacob, Simeónnu bain, Levínu bain entsandimi: Ñulla inu firu' shuikikaadekive. Tsa dekiñu ñulla' kuipa' mityan inu Canaánnu sera' jimu chachilla bain, naa Fereznu sera' jimu chachilla bain kundaa tyanu dejuve. Tsenmala iya aa chachi miyajtuñu' mitya, yala debuudishu juntsaa inu vingue' pulla', inu in chachillaba bulu millangaanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tsenñu yala entsandi pakala: ¿Tsejtu Siquemya lala' tsujkinu na'baasa tsa tsaimu shinbu juuñungue kiikenu juu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Tsenñu Jacobnu Dios tsandimi: Ñu' buli ura' demangue' Betelsha miji' machude. Tsejtu juntsa tenanu ufeenda tsure' ju'kenunu main kide, matyu ñu' naatala Esaúchi nepiyantsuñu katawamu Dioschi, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tsenñu Jacob ya' paandelanu bain, naa yaba bulu nemulanu bain demikatu tsandimi: Ñulla' jundala chi dyus juu tadenashu juntsala avindala kalaadei. Tsangue' pipe', jali bain vera demanbana', Dioschi ura' kuraa mandiyadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tsejtu Betelsha te' miidaa, iya jungaa Dioschi ufeenda tsure' ju'kenunu main kenu tsuyu, yaa iya ti ken tsaa nentsumuwaañu bain inu kemishti', naa iya nuka nentsuñu bain ibaren bulu nemu Diosve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tsenñu yala Jacobnu kumuinchi tanañu chi dyusla bain, naa pungui-erara juula bain dekuwakila, tsenñu Jacob ensina mumu chi panbeesha demenekemi Siquem pebulu keesha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tsenñu yala malu' miindetsuñu, kumuinchi jundala pebulu kalen chumulanuya Dios jeetyainuke detiremi. Tsenñaa Jacob' nalanu bendaa ki'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tsenñu Jacob, kumuinchi ya' chachillaba Luz pebulu tityumee Betel tiitinu pebulunu vijila, Canaán tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Tsejtu Jacob junu ufeenda tsure' ju'kenunu main kemi. Tsangue' juntsa tenanu El-betel mumu pumi (hebreo palaachiya, “Betelsha chumu Dios” titu), matyu junaa ya' naatalachi nepiyantsunu uwanu, Dios yanu katawamuwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tsenmin Rebecanu washkemu shinbu Débora junu peyañu, ensina chi mumu panbeesha menla, Betel keesha. Tsejtu juntsa tenanu “Waanu Ensina Chi” mumu pula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jacob Padán-aram tusha pu' miiñu, Dios yanu mangatawa', ura' ikaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","entsandimi: Ñuya Jacob mumuve, tsaaren tsaa mamumun jutyuve; entsa ajkeshaa ñu' mumu Israelya junu tsuve, timi. Tsejtu Jacobnu Dios mumu mavete' dyatu, bene ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","entsandimi: Iyaa tiba kekaanuu jumu Diosyu. Pure' na miyandiyaide, ñunu sera' jimu chachilla bain pure' juunu detsuve. Ñunaa ma aa bulu chachilla defale' kayu jungajte vee vee uñichi uuden juu chumu chachilla faanu detsuve, tsenmin bene mantsala ñunu sera' jimu chachillaren naa rei bain tiyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Iya Abrahamnu bain, naa Isaacnu bain kuwakeeshu juntsa turen naa ñunu bain kuwanu tsuyu, tsenmin benee ñunu sera' jimulanu bain kuwanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Tsejtu Dios, Jacobba kuinda kenu tenanu baka' miiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob juntsa tenanu ma shupuka ka' tsaa llu'pu' uyukaatu, yatyutya juuñunguemi, junu Dios yaba kuinda kenu tenanu. Tsangue' Dioschin juu tiretu binu bain yuutsure' keeware', naa ulibu muli bain yuutsuumi juntsa shupukanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Tsejtu Dios yanu junaa pamuwaañu, Jacob juntsa tenanu Betel mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Tsejtu bene Betelnu demalu' miitu, Efrata tenasha kayu maviji'mujchin, Raquel na mangatu tsamantsa taaju kendaa na mangami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tsenñu ya naaken tsandyantsunu uwanu, nakakaamu shinbu tsandimi: Jeetyatyude, entsa bain unbeenaren faanu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tsenñu ya penundiyandu, aa-ishi' patu Ben-oní mumu pumi juntsa kaananu (“in kityanu na” titu); tsenñuren ya' apaya Benjamín mumu pumi (hebreo palaachiya “in urandya na” titu). ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Entsaitaa Raquel peyañu, Efrata jinu miñusha menla, challa Belén jumubi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tsenñu Jacob juntsa ujkun tujuunu shupu' tyutya main uikaami, tsenñu chaiba entsa piikenu tinbunun juntsa tyutyaa junu Raquel mennañuba tengakaamu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Tsejtu Israel kayu ajkesha jitu, Éder aa katyu yatyutya ajkesha mangajdiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tsejtu Israel juntsa tenanu miitu tsai manchuñu, Rubén ya' apachi kama miyandinu shinbu Bilhába tsaa tsudimi. Tsenñu ya' apa mijatu mika ajaatyami. Jacob' nala 12 jumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Líaba miyandiñu nalaya, entsaa juntsala deeve: ya' ajke' na Rubén bain, bene Simeón bain, Leví bain, Judá bain, Isacar bain, naa Zabulón bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Tsenmala Raquelba miyandiñu nalaya entsalaa juntsa deeve: José bain, tsenmin Benjamín bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Tsenmala Bilhába, matyu Raquelchi manda-imu shinbuba miyandiñu nalaya entsalaa juntsa deeve: Dan bain, Neftalí bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Tsenmala Zilpába, matyu Líachi manda-imu shinbuba miyandiñu nalaya entsalaa juntsa deeve: Gad bain, Aser bain. Kumuinchi entsalaa Jacob' nala deeve, matyu Padán-aram tusha nakayamula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob, ya' apa Isaacnu Mamré mumu ruku' ensina chi chunu tenasha, Arbá tiitinu pebulu keesha, tsandityu' bain, Hebrón tiitinu pebulusha miji' mangueemi, junaa Abraham bain, Isaac bain vee tusha chumu juu ji' chuinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Tsenñu 180 añu juunu uwanu peyami Isaac. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Tsai' yumaa derukuunu uwanu peya' ya' tinbu rukulaba manbuudiimi, tsenñu ya' nala Esaú Jacobba menla. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Entsalaa Esaú tityumee, matyu Edom tiitinu rukunu sera' jimu chachilla deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú Canaánnu sera' jimu chachilla' na'malanaa supungamuwaami: Hetnu sera' jimu chachi Elón' na'ma Adánu bain, Hevenu sera' jimu chachi Sibón' paña Aná' na'ma Oholibamánu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","tsenmin Ismael' na'ma, matyu Nebaiot' tsujki Basematnu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Elifazyaa, Adá Esaúnu ka' kuñu nami; tsenmala Basematyaa Reuelnu nakami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Tsenmala Oholibamáya, Jeúsnu bain, Jaalamnu bain, Corénu bain nakami. Entsalaa Esaú' nala, Canaán tusha nakayamula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú, naa ya' shinbulanu bain, naa ya' kaillanu bain, naa yaba chumulanu bain dekake' vee tenasha mijiimi, matyu ya' naatala Jacobnu vela' jitu. Tsejtu kumuinchi Canaánnu chu' demiyandiñu animaala bain, naa tiba detadiñu jumula bain detajiimi, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","matyu yala pai naatala jumula pure' animaa tandiya deitu bulu chunu jutyui detiyatu, tsenmin kumuinchi animaalanu tape fikaanu dekenmala yala' chunu tu bain tse'kityuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tsenñaa Esaú tityumee Edom tiitinu unbere Seír kuyi tenasha ji' chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Entsalaa Esaúnu, tsandityumee, Edomnu sera' jimu chachilla deeve, matyu Seír kuyi tenasha chumula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Entsalaa Esaú' nala' mumu deeve: Adába keñu na Elifaz bain, naa Basematba keñu na Reuel bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Tsenmala entsalaa Elifaz' na jumuwaala: Temán bain, Omar bain, Sefó bain, Gatam bain, naa Quenaz bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Tsenmin Elifazchi kama miyandinu shinbu Timnába vera na mamiyandimuwaami; tsenñu entsaa Amalecnu nakami. Tsa' mitya entsalaa Esaú' shinbu Adánu sera' jimula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Tsenmala Reuel' nalaya entsalaa juntsa deeve: Náhat bain, Zérah bain, Samá bain, naa Mizá bain. Tsa' mitya entsalaa Esaú' shinbu Basematnu sera' jimula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Tsenmala Esaú' shinbu Oholibamá' naka' kuñuya entsalaa jumuwaala: Jeús bain, Jaalam bain, naa Coré bain. Entsa Oholibamá shinbu Aná' na'mawaami, matyu Sibón' paña. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaúnu sera' jimu bale ruku tiyamulaya entsalaa jumuwaala: Esaúchi ajke' na Elifaznu sera' jimu bale ruku tiyamulaya entsalaa juwaala: Temán bain, Omar bain, Sefó bain, Quenaz bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré bain, Gatam bain, naa Amalec bain. Tsa' mitya entsalaa Elifaznu sera' jimu bale ruku tiyamula deeve, Edom tusha, tsenmin kumuinchi entsalaa Adánu sera' jimula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Tsenmala Esaú' na Reuelnu sera' jimu bale ruku tiyamulaya entsalaa juntsala deeve: Náhat bain, Zérah bain, Samá bain, naa Mizá bain. Tsa' mitya entsalaa Reuelnu sera' jimu bale ruku tiyamuwaala Edom tusha, tsenmin kumuinchi entsalaa Esaú' shinbu Basematnu sera' jimula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Tsenmala Aná' na'ma, Esaú' shinbu Oholibamánu sera' jimu bale ruku tiyamulaya entsalaa juntsala deeve: Jeús bain, Jaalam bain, naa Coré bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Tsa' mitya kumuinchi entsalaa Esaú, tsandityumee Edomnu sera' jimu bale ruku tiyamula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Tsenmala juntsa tusha chumula, Hor chachi Seírnu sera' jimulaya entsalaa juntsa deeve: Lotán bain, Sobal bain, Sibón bain, Aná bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón bain, Éser bain, naa Disán bain; entsalaa Hor chachi Seírnu sera' jimu bale ruku tiyamula deeve Edom tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotán' nalaya entsalaa juntsa deeve: Horí bain, Hemam bain. Tsenmala Timnáya Lotán' tsujkiwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Tsenmala Sobal' nalaya entsalaa juntsa deeve: Alván bain, Manáhat bain, Ebal bain, Sefó bain, naa Onam bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Tsenmala Sibón' nalaya entsaa juntsa deeve: Aiá bain, Aná bain. Tsenmala entsa Anáya tiba den chutyu tenasha, ya' apa Sibónchi buru washkendu, tu tainsha pi faamu katamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Tsenmala Anáya main unbeena Disónnu miyandi', main supu na'ma Oholibamánu miyandimuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Tsenmala Disón' nalaya entsalaa juntsa deeve: Hemdán bain, Esbán bain, Itrán bain, naa Querán bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Tsenmala Éser' nalaya entsalaa juntsa deeve: Bilhán bain, Zaaván bain, naa Acán bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tsenmala Disán' nalaya entsalaa juntsa deeve: Us bain, Arán bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hor chachinu sera' jimula' bale ruku tiyamula entsalaa juntsa deeve: Lotán bain, Sobal bain, Sibón bain, Aná bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón bain, Éser bain, naa Disán bain. Tsa' mitya entsalaa Hor chachinu sera' jimula' bale ruku tiyamuwaala, matyu ma bulu chachimeemee, Seír tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Entsalaa Edom tusha rei tiyamuwaala Israel chachilla kayu rei tajtunu uwanu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor' na, Bela, Edom tusha rei tiyamuwaami Dinhaba mumu pebulunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tsejtu Bela peyañu, ya' mitya Zérah' na Jobabya rei mavimi, Bosrá pebulusha chumu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tsenmala Jobab peyanmala ya' mitya Husamya rei mavimi, Temán tusha chumu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tsenmala Husam peyanmalaya, ya' mitya Bedad' na Hadadya rei mavi' washkemi, Avit pebulusha chumu. Entsa Hadadya, Madiánnu, Moab jeenbaasha vingue' puimuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tsenmala Hadad peyañu ya' mitya Samláya rei mavi' washkemi, Masrecá pebulusha chumu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tsenmala Samlá peyañu, ya' mitya Saúlya rei mandi' washkemi, matyu pi keesha chumu pebulu Rehobotnu chumu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl peyañu, ya' mitya Acbor' na, Baal-hanánya, rei mandi' washkemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tsenmala Baal-hanán peyañu Hadadya rei mandi' washkemi, Pau pebulusha chumu. Hadad' shinbu Mehetabel mumuwaami, matyu Matred' na'ma, tsenmin Mezaab' paña. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Tsenmala entsalaa Esaúnu sera' jimu paande chachilla' mumu deeve, matyu main main ya' bulu chachimee, naa tenatala pañu bain, naa mumutala pañu bain: Timná bain, Alvá bain, Jetet bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamá bain, Elá bain, Pinón bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenaz bain, Temán bain, Mibsar bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel bain, naa Iram bain. Tsenmala Esaúren, naa Edom mumu bain juwaami. Tsa' mitya entsalaa Edom tusha balen chachi tiyamuwaala, matyu main main naaju tenanu chumuwa' bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob Canaán tusha manchumi, jungaa kaspele ya' apa vee tusha chumu juu ji' chumuwaañu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Entsa kuindaa Jacob' nala' kuindave: José 17 añu juunu uwatala, ya' naatalalaba bulu uveja washkive'muwaami. Tsaaren entsa naatalala ya' apachi vejan shinbula' na juwaala. Ya' amala' mumuya mainya Bilhá, kamainya Zilpá. Tsa tsaindu, José ya' naatalala firu' kiikemu deeve ti', ya' apanu wandi wanditimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Tsaaren Israelya, Josénaa kayu vejan nalanuba pullai estyamu jumi, matyu Joséya ya' apa Israel yumaa derukuunu uwanaa kayamuwaañu' mitya. Tsejtu Israel bareree jali, balenchi jali naraa pumi' kumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tsenñu ya' naatalala naa ya' apa, kayu Josénaa yalanuba pullai estyamuñuba demijatu, Josénu yuj tyutya tyutyaila. Tsa' mitya Josénu tenbitya' pabandityu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ma bijee José kipiyu titu, ya' naatalalanu kuinda kemi. Tsenñu ya' naatalalaa Josénu kayu ne tyutyaila, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","José yalanu entsandiñu: Inu meedikai, iya naa-i kipi'ba ñullanu kuinda kenu tsuyu. Entsai kipiyu: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Lala kumuinchi trigu paasha trigu tele' ejkewaanu kendetsuwayu. Tsenñu wajtunun inchiya trigu tela maali kujpa' uidiwa. Tsenmala, ñuichiya in junga dewayu' jadeiwa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tsenñu ya' naatalala pakatu tsandila: Tsaashu juntsaa, ¿ñaa lala' uñi tiya' lalanu mandanguen chunuutundiyu tsandimi? tila. Tsejtu ya juntsai kipiñu' mitya bain, tsenmin ya naati wandi' papatiñu' mitya bain yanu kayu ne ajaatyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bene bain José manguipitu ya' naatalalanu entsandi mawainmi: ¡Meenadei! entsai kipiyu: naa pajta bain, naa kepe pajta bain, naa 11 makarala bain, in junga kalen ja' wayu'ka wayu'kakendetsu kipiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tsejtu José ya naa-i kipi'ba ya' apanu bain, naa ya' naatalalanu bain kuinda keñu, ya' apa ajaa ti' patu entsandimi: ¿Naati patundiyu aantsai kipiyu timi? Tsejtu, ¿naa iya bain, naa ñu' ama bain, naa ñu' naatalala bain, ñu' ajuusha ja' teedinu dejuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tsenñu ya' naatalalaya dekishtyañuren, ya' apaya, ¿naa-itaa tsai kipiñanga? tya' pensa jujuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ma malu José' naatalala Siquemsha jila, ya' apa' uvejalanu ishtape mi'ke' fikaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tsai' dejiñu Josénu ya' apa Israel tsandimi: Ñu' naatalala uveja washkendu Siquemsha depuve; yalanu ji' keede, timi. Tsenñu José pakatu: Tsaashu juntsaa, ji' keenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tsenñu ya' apa tsandimi: Tsaaya, ñu' naatalala bain, naa uvejala bain naadenañuba kere' kuinda manjaka, timi. Tsejtu Israel, ya' na Josénu Hebrón kujtu jatsuwasha chutun Siquemsha eemi. Tsenñu José Siquembi jitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ya' naatalalanu jeendala mi'kes netinduren kataindyumi. Tsaita nentsuñu, ma unbere katatu entsandi pake'meemi: ¿Tyee mi'kes nendu iyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Tsenñu José pakatu: In naatalalanu mi'kes nendu iyu. Ñaa mi'ba jutuya yala nukaa uveja washken depuñuba inu wainka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tsandiñu juntsa ruku pakatu tsandimi: Enuya yumaa demalu' miive, tsaaren Dotánsha miinu tindetsu meenayu, timi. Tsenñu José ya' naatalalanu jungan mi'kiitu Dotánsha mangatajimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tsenñu ya' naatalala Josénu baasha jantsu dekata-eetu, yanu naaketaa anbuke' ka' tu'nu deju'ba yaitala tsandi depa' dyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tsejtu yaitala entsandila: ¡Ke-eekidei, kipimu jantsuve! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kipimu janmalaya tute' pi tujuusha pukedaa, tsejturen jeenbaasha chumu firu animaa fikeñuve tidaa; tsenmala asu, ya naa-i kipiñuba juntsaa-i' puiñu meenu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tsenñu Rubén entsa detiñu meetu, Josénu livee kenu tyatu, Rubén ya' naatalalanu tsandimi: Ura tutenchiya kityu', ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","asa shajaakaanu kityudaa, matyu tiba den chutyu tenasha jumu pi tujuusha yanu tiba ta'ki'mujchi pukeñun, tsananu tsuve, timi. Tsaaren Rubén entsandimiya ya' naatalanu livee kenu tyataa tsandimi, tsangue' bene ya' apa' junga me-e'lare' me-eenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tsenñu José yala' junbi jinmalaren ya' naatalala deka', ya' uukeraa aabare pana' jiñu jali tsaa chipadeke', ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Josénu tiba putyunu tujuusha pukila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tsanguetu panda finu chula. Tsa denaren manbaate Ismaelnu sera' jimu chachilla, tsandityu'ba, Madiánnu sera' jimu chachilla, Galaadsha pu' jimulanu, kameyunu naa pindyupi bain, balsamu tinu chi pillu bain, mira tinu chi pillu bain puu Egiptosha takendu jindetsu katala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tsenñu Judá ya' naatalalanu entsandimi: Lala tiba kakeñuuya kenu dejutyuyu lala' naatalanu tute', anbukuinda ne kikituya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tsa' mitya Joséya ura lala' naatalaren juñu' mitya, tuteñuya urajtuve. Matyu tu'tyumujchin Ismaelnu sera' jimu chachillanu atikiñaa uranu juve, timi. Tsandiñu, ya' naatalala bain tsanguiñu urave tyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tsejtu Madiánnu sera' jimu bui atis nemu chachilla junu pullandetsunmalan ya' naatalala Josénu tujuusha pumunu demangalare' Madiánnu sera' jimu chachillanu atikila. Tsejtu 20 lepa lushi jeruchi ai'la. Entsa dekiñaa Josénu Egiptosha take' jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tsenñun bene Rubén maja' tujuusha miji' mangueeturen, ya' naatala Josénu putyu katatu mika llakindyami, tsejtu llakindya' keewaatu ya' jali kiyuuchitikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Tsejtu ya' naatalala' junga miitu tsandimi: ¡Juntsa kaana putyuve! ¿Iya challa tyee kenujtuuwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tsandiñu yala José' jali deka', main kaa chibu tute', tsaa juntsa asa mai'tekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tsanguitu bene ya' apa' junga deme-ere' entsandi kuinda eela: Jali entsaa dekatayu. Keekide mu' jalin; ¿ñu' na' jali jutyun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tsenñu ya' apa, naa José' jaliñuba mangueengatu: ¡Uwain, entsa in na' jalive! ¡Firu ti aa animaañuba fiñuve! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tsejtu Jacob llakindya' ya' jali kiyuuchitiketu, cha' depeñu llakingue' pannu jali panake', ya' na' mitya pure' malu llakinguen chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tsenñu ya' nala bain, naa ya' na'mala bain dewa'di' ya' apanu masundyawaanu dekiñuba, ya' apa masundyanu tyai'tu, ya' nanu pensandyatu kayu ne waawaandimi. Tsejtu, ya' apa entsa entsandimi: In peyangama llakinguen chunu tsuyu. I bain peyataa in naba pemula' chuinsha manbuudiinu tsuyu, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tsenmala Madiánnu sera' jimu chachillaya Egiptobi devijitu, Josénu ma ruku Potifar mumunu ma-atikila. Tsaaren Potifarya Egipto' rei, tsandityu'ba faraón' keenu mi'namu chachi jumi, ura patiñuya, washna' keenamu suutadula' ama jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Juntsa tinbutala, Judá ya' naatalalanu vela' jitu, Adulam pebulusha chumu, ma unbere Hirá mumu ruku' junga ji' chuimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tsejtu junu ma unbere Canaánsha chumu Súa mumu ruku' na'manu keemijami, tsejtu yanaa supunga' tyushami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Tsenñu juntsa shinbu navi' kañu, Er mumu pula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tsejtu manen navi' mangatu, Onán mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Bene bain navi' mangatu, juntsanuya Selá mumu pumi. Tsaaren Judá Quezib pebulunu chunu uwanaa entsa nanuya mangami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Bene Judá, ya' ajke' na, Ernu ma na'ma Tamar mumunu supungakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tsaaren Erya Yavé' ajuusha urajtu kiikeñu' mitya, tsaa Yavé peyakaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tsenñu Judá, ya' na Onánnu entsandimi: Ñu' naatala' biyuda shinbunu mangade, tsejtu ñu ya' apipi jutu yanu naakenuu juñuba tsanguide; tsejtaa ñu' naatala' mitya sera' jikaanu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tsenñu Onánya naa ya' na fale' bain, ajke' jumuya ura ya' na juuñuu kuran jutyuñuba mi' mitya, naa-uwanu ya' uñaku' biyuda shinbuba tsudi' bain napunu kityu jujuumi, matyu ya' mityaya ya' uñaku millanu sera' jimu chachi dejutyusa tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Tsenñu Onán tsa tsanguitu Yavéchiya ajaatyainuu kiikeñu' mitya, yanu bain Yavé peyawaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tsenñu Judá ya' suyanu entsandimi: Ñu' apa' yasha miji', biyuda shinbu juuren chude, in na Selá kayu musuindyuya, timi. Tsaaren Judá juntsandimiya ya' na Selá bain, ya' uñakula naadeiñuba juntsa-i' peyachuve pensanguitaa tsandimi. Tsenñu Tamar ya' apa' yasha miji' machuimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bene pure' tinbu pullantsuñu, Judá' shinbu, Súa' na'ma bain peyami. Tsai' peyañu, Judá llakinguen chuturen puitetu, Timnat pebulusha jimi, matyu ya' uvejalanu ju daamula' puinsha. Tsenñu Adulam pebulusha chumu ruku, yachi ura' keranu chachi jumu Hirá, yaba bulu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tsenñu Tamar ya' anchapa Timnatsha ya' uvejalanu ju daanu jintsuve detiñu kuinda mijatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","biyudala' pannu jali manbekike', kajuru du'kentsumi jalichi dukike', jalichi ya' bulunu depijtekemi, muba yanu keengan jutyu. Tsejtu Timnat jinu miñusha chumu Enaim pebulu vinu juukapasha ji' chudimi. Tsaaren Tamar entsanguemiya, yumaa Selá de-aawañuren, yanu ya' shinbu mandirenu manguwaindyuñuba mijataa tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tsenñu Judá yanu katatu, matyu munuba na'baasa tsa tsaimu shinbuve pensanguemi, naa ya' kajuuba dedukaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tsejtu umaa yanu kalen jitu, naa ya' suyañuba mijtu' mitya entsandimi: ¿Inu ñuba tsumishtinuuyu? timi. Tsenñu pakatu: ¿Iya ñuba tsun mitya inu tyee kunuuyu? tikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Tsenñu Judá pakatu: In animaa paasha pumu chibu kaanaa main kuwanu tsuyu, timi. Tsenñu manbakatu: Tsaaya urave, tsaaren tsanguen mitya main inu tiiñuba ñuchi kuwanu juve, kayu chibu inu kuwanu erendyuya tananu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Tsenñu Judá pakatu: Tsen ¿tyee shuikisa tenguen? timi. Tsenñu manbakatu: Muute chujtintsumi kutunu yangaanu chuwaba puu kuwaka, naa tyaapanu tanashu juntsa tyutyan cha'li bain kuwaka, timi. Tsenñu Judá juntsa dekuwatu umaa yaba tsumi, tsejtu na ma pukemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tsenñu bene Tamar miitu ya' kajuunu dishkentsumi jali mangatu, biyudala' pannu jali manbanakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Tsejtu bene Judá yachi ura' keranu Adulam pebulusha chumu chachiba juntsa chibu kaana eemi juntsa shinbunu kuwanutsu, tsejtaa ya' kuñu deme-eesa tyatu, tsenñuren yachi ura' keranu ruku juntsa shinbunu mangatai'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tsejtu junu chumu rukulanu depake'meetu tsandimi: ¿Nuka naanain juntsa munuba tsa tsaimu shinbu Enaim pebulu miñu keesha katawamu? timi. Tsenñu depakatu: Enuya munuba tsa tsaimu shinbuya maliba dechutyuve, tikala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tsenñu juntsa ruku Judá' puinsha miitu tsandimi: Iya juntsa shinbunu mangatai'yu, tsenmin juntsa tenanu chumu rukula bain, junuya munuba tsa tsaimu shinbu juulaya maliba chutyuve, detingayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tsenñu Judá pakatu: Tsaaya iya yanu kuwakeesu juntsa tsai tashuwañuba urave, tsenmalaa lalanu uukapui'nudetsu, tsaaren ne iyaa juntsa chibu kaana erendyuuba jui'yu, ñunu eeñuren ñu juntsa shinbunu katai'mujchi maave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tsejtu bene pen chu'chaya insha, Judánu entsandita jila: Ñu' suya Tamar vee rukulaba matsuñuve, tsai' ma naviiñuve, tila. Tsenñu Judá entsandimi: ¡Tsaaya dekalare' ma jupekidei! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tsenñu yumaa kalaanu ma jiindetsuñu, Tamar ya' anchapanu, entsandidei ti' mandanguemi: Entsa muchiñuba juntsa rukaa inu napuve. Asu tejan keekide entsa muute chujtintsumi ya' chuwaba, naa entsa tyutyan cha'li bain muchiñuba ura' keekide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tsenñu Judá juntsa demangueengatu tsandimi: Naa ya entsangue' firu' keñuba, iyaa kayu firu' kikeeñuve, in na Selánu yanu supu mangutyu' mitya, timi. Tsejtu naa-uwanuba juntsa shinbuba matsui'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tsejtu Tamar nakanu tinbu jañu nakatu, pai na kami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na defaanu uwanu, mainya ya' tyaapa avindala ajke' uslaami. Tsenñu nakakaamu shinbu juntsa tyaapanu ungalalaa kaa chuwa tsaa teepukemi, tsejtu tsandimi: Entsaa ajke' faave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tsenñuren juntsa kaana ya' tyaapa mamu'kakaakenmala, ya' naatalaa ajke' faami. Tsenñu nakakaamu shinbu juntsanu Fares mumu pumi ajke' faamunu (hebreo palaachiya “faapumu” titu), matyu entsanditu: Naa itaa juuke' faatu iyu, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Tsenñu benee kama kaana faami, matyu tyaapanu ungalala kaa chuwa teevimu kaana, tsenñu juntsanu Zérah mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josénu Egiptosha detajiñu, ma ruku Potifar mumaa Ismaelnu sera' jimu chachillanu ati'kami. Potifarya faraón' keenu mi'namu bale ruku jumi, ura patiñuya yaa washna' keenamu suutadula' ama jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tsaaren Yavéya Josénu keena' mitya, tiba ura' kekaantsumi Egiptobi yanu uudenguemu ruku' yanu chungama. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Tsenñu yanu uudenguemu ruku bain mijami naa Yavéya Josénu tinu bain ura' kikaantsuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tsenñu yanu uudenguemu ruku Josénu ura' tya' keekeekitu, ya' kelunu mi'namu bale ruku tirekemi. Tsejtu Potifar ya kumuinchi ti taju' bain Josénu tene washkenu dekuwakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tsenñu Potifar naamaa juntsangue' Josénu ya' kelunu mi'namu bale ruku tireñuba, José' mityaren Potifarnu Yavé mika ura' ikaami, tsejtu ya' yanu bain, naa ya' taawasha kenu jeenbaasha bain tsaren ura' de-ikaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tsejtu Potifarya ti taawasha kemu ju'ba Josénu tene washkenu dekuwake' mitya, taawashatalaya naa-ichunga tya' pensajtu ju', panda finun pensaa jujuumi. Joséya dee chachi ju', uukera' musu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tsenñu Josénu uudenguemu ruku' shinbu, mutya' keekeekitu, Josénu ma malu entsandimi: ¡Iba tsude! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tsenñu Joséya tsaindyatyu' pakatu: ¡Tsandityuka! Inu uudenguemu rukuya kumuinchi ya ti taju'ba inu tene washkenu tiretu, iya entsa yanu chushu juntsaya tyee intsuñanga tya' pensajtu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Entsa yanuya main kayu inu pulla bale ruku juu uudenguemuya chutyuve. Tsejtu inu uudenguemu rukuya tiba in tyaapanu tene washkenu shuikive, tsaaren ñunuya in tyaapanu shuikindyuve, ñuya ya' shinbuñu' mitya. Tsaanuba, ¿nenñaa iya tsangue' Diosnu kundaa ke' ujcha lamunga? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tsenñu naa juntsa shinbu Josénu malumee tsaimishtinu papatiñuba, Joséya ya' palaanu meenguityu jujuumi, tsenmin naa yanu kalen jade tiñu bain tsaindyatyu jujuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tsainduren José ma malu yasha mavimi ya' taawasha mannu, tsenñu juntsa yasha taawasha kemula muba dechutyuñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","juntsa shinbu José' jalinu kakijitu: ¡Iba tsude! timi. Tsandiñu, José wapana' deengue' mafaatu, ya' jalin juntsa shinbunu tai shuwakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tsenñu José daran mafaañu, juntsa shinbu ya' jalin tai shuwa'ba mija' mitya, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","juntsa shinbu ya' yasha taawasha kemulanu mika' kuinda ketu, entsandimi: Entsa hebreo chachinu ka' jañu, challa lalanu uukapukiñunguive. Iba tsunu tya', in junga ma vijaiñuren iya daran watiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","wapana' malutu ya' jali shuike' maluive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tsanditu, juntsa shinbu José' jali uukare' tanami ya' ruku maañu keewaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tsejtu, ya' rukunu entsandi kuinda kemi: Manda-i' taawasha kemu hebreo chachi ñu ka' jaisu juntsa in sukusha vi' firu' kenu kive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tsenñuren iya daran watiñu, wapana' jeke mafaatu ya' jali enu shuike' maluive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tsa' mitya: Ñuchi manda-i' taawasha kemu chachi inu entsanguive, tiñu, yanu uudenguemu ruku meetu yuj ajaatyami, ya' shinbu tsandi' kuinda keñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tsenñu yanu uudenguemu ruku, Josénu kakare' peesu puimi rei' chachilla' peesu puinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tsenñu naamika José juntsa-i' peesu puñu bain, Yavéya yanu ura' kikaantsuñu' mitya, peesusha pumu chachillanu uudenguemu bale ruku, Josénu ura' tya' keekeekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tsejtu peesu pumula' bale rukuya, Josénaa junu peesu pumuutala washkemu bale ruku tiremi. Tsenñu junga tyee kiikenuu dejuñu bain yandene uudenguiikemu tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tsejtu junu bale ruku pumuya, Josénaa bale ruku tire' peesu pumulanu keena' uudenguemu tire' mitya, yaa tiba mangueres netyu jujuumi, matyu Yavéya Joséba ju' titala bain ura' kekare' jintsuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","José entsai' peesu punu uwanu, Egipto reichi binu kiikemula' bale ruku bain, naa reichi pan kiikemula' bale ruku bain yanu uudenguemu rukunu firu' dekiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","faraón ajaatyatu, juntsa pai bale rukulanu ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","peesu depumi, washna' keekeenamu suutadula' ama' yasha, matyu José bain punu peesu yasharen. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tsenñu peesu pumulanu washna' keekeenamu suutadula' amaya Josénaa washke' keekeenanu uudenguemi entsa rukulanu. Tsenñu yala junga peesusha jayee wadepula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Tsanaturen entsa pai rukula reichi binu kikare' taji' kumu bain, reichi pan kiikemu ruku bain, main main kipila mangueperen. Tsenmin main main yala' kipiñu naaju' tsaañuba vee vee aseetanguekaanu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Juntsa kepenene José yala' junga ji' keeñu yuj llaki jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tsenñu José yalanu pake'meetu tsandimi: ¿Nenñu deeyu uma yuj llakindyañu' kajuru jula? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tsenñu yala pakatu: Lala uma naa-i kipi' bain mijanu tenñuba, munu kuinda ke' wandikutin tsa deetu deeyu, tila. Tsenñu José pakatu: ¿Mu bain naa-i dekipiñuba Dioschee aseetangue' panutsumi jutyuu? Tsaaya inu kuinda kikai naa-i dekipiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tsenñu binu kikare' faraónnu taji' kuwa kuwakemu bale ruku naa-i kipi'ba Josénu entsandi kuinda kemi: Kipibi uva chuwa main katañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","jei awamin pen pala vi' llullu kemin, ya' llullu jumula uva tyundyu tene tiyaimin jei lluve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tsaiñu, iya uva katu, chuyi' bejte' basunu pu' faraón' tyaapanu taji' kuwayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Tsenñu José tsandimi: Ñu' kipiñuya entsandi aseetanguikarave: pen ali juushu juntsaya pen malu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Pen malu insha faraón ñunu livee ke' manen mishu mangujte', ñu' kaspee taawasha kinsha manbunu tsuve, tsenmala ñu kaspele naakentsumuwa ju'ba faraónnu tsa manguentsunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tsejtu ñunu demangalaañu miji', ñu junga ura' manbumiya inu mandengaka, tsejtu in mitya tsantsaya faraónnu pade inu peesu mangalaanutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Iyaa hebreo chachilla' tusha tara' jamuyu, tsenñuren iya enu peesu viinuu firu' kindyun peesu depuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tsenñu faraónchi pan kiikemu bale ruku bain Josénu meenatu naa-i kipiñuba aseetangue' uraanuuya pañu' mitya, ya bain kuinda ketu entsandimi: I bain, kipibi pen kaa pishkalisha fibaba pan tene in mishpukasha chujti' tanayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tsenñu kayu kai'sha llai'namu kaa pishkalishaya faraónchi pure' vee vee pingala pan juu depunuren, pishkula in mishbui'sha deja' pishkalisha pan pumunun fifidekive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Tsandiñu, José pakatu tsandimi: Ñu' kipiñuya entsandi aseetanguikarave: pen kaa pishkali pan juushu juntsaya pen malu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Pen malusha faraón ñu' mishu daakakare', ñu' bulu cha'linu tu'pu' uikaanu juve. Tsenmala pishkulaa deja' ñu' alla finu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tsenñu pen malu insha faraónchi ya' nakayanu malu machañu, fandangu kemi ya' taawasha kemu chachillaba. Tsangue' demikatu, faraón uudengue', naa binu kekare' taji' kuwa kuwakemu bale rukunu bain, naa pan kiikemu bale rukunu bain peesu demangalaanu eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tsejtu binu kikare' kuwa kuwakemu bale rukunuya ya' kaspee taawasha kiikensha manbumi. Tsenñu juntsa ruku ya kaspele naakentsumuwa ju'ba tsa manguentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tsangueturen, pan kiikemu bale rukunuya chisha yangaakaakemi, matyu José naati aseetangue' pañuba juntsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tsaaren, binu kikare' faraónnu kuwa kuwakemu bale rukuya pashiitu, Josénu mandengai'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Pai añu puinu tinbunu, ma bijee faraón kipimi. Tsenñu faraón kipibi, Nilo pi kelunu uyunaren, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","pisha mandishpai wagara faala naraa nakululuu tene. Tsejtu ñañi chundala ishtape fifikentsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tsa denaren yala' benesha bain mandishpai wagara ejkekee firuundene defaatu, pi kelunu uyudila ajke' faamula' keesha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tsanatun, ¡entsa ejkekee firuu wagaalaya juntsa naraa nakululuu wagaalanu defikila! Tsenmalan faraón mandengakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tsejturen manen kasu' manguipiñu, umaa ma trigu lura narai awamin, mandishpai ali vi' trigu tene nandiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tsenmala bene bain mandishpai ali mafaala pajlanu deechusha jamu ishuwachi dejuya' ejke jupeendene. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tsenmin entsa ejke ali trigu jumula naraa trigu aa ali jumulanu defikila. Tsenñu faraón mandengatu mijami naa kipibi tsaiñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tsejtu ayunchi kepenene yuj pensandyami. Tsandyatu, kumuinchi Egipto' chumu mirukulanu demikatu, faraón kuinda kemi ya naa-i kipi'ba. Tsenñuren naa-i kipitaa tsaiñuba muba aseetangui'tu waintyula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tsenñu binu kikare' faraónnu kuwa kuwakemula' bale ruku, faraónnu entsandimi: Naa iya pashiitu mandengatyu' firu' kikeñuu kendu bain challaa mandengayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ñu kaspele, ñuchi tiba kiikemu rukulanu ajaatyatu, naa pan kiikemu bale rukunu bain, naa inu bain peesu pumuwaave peesu pumulanu washna' keekeenamula' bale ruku' yasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tsenñu ya bain, i bain manguepe dekipiwayu. Tsejtu vee vee dekipiwayu, tsenmin main main naa-i depikitaa tsaiñuba aseetanguenuu juwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tsenñu washna' keenamula' bale rukuchi manda-i' taawasha kemu main hebreo musu laaba puwa. Tsejtu juntsa musu lala naa naa-i dekipiñuba main main aseetangue' kuinda kiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tsenñu ya naati pañu bain juntsa deiyu. Tsejtu iya engu taawasha manjañun, mainya tuta' yangaraive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tsenñu faraón ya' chachillanu Josénu peesusha mangalaanu uudenguiñu, jei mangalaajila. Tsejtu José malutu, tyaipu mangue', jali vera manbana', faraón' ajuusha jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Tsenñu faraón tsandimi: Iya kipiñuren muba aseetangue' wainnu deki've, tsaaren ñuya naa-i dekipiñuba aseetangue' wainmuve detiñu mijayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tsenñu José pakatu tsandimi: Iya maali aseetangue' tsanguityu juyu; Diosya ñu naa-i kipitaa tsaiñuba wandi' ñuchi uraanuu mijakaanu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tsenñu Josénu faraón patu tsandimi: Iya kipibi Nilo pi kelunu uyunayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tsanaren pisha mandishpai wagara naraa nakululuu tene defale' ñañi chundala ishtape findetsuwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tsadenan juntsala' bendala mandishpai wagara demafaave mafiruu ejkekee tene. Tsaaren naa-uwanuba Egiptosha juntsaa firuu wagaraya kata' kerajtuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tsejtu juntsa ejkekee firuu wagaala juntsa ajke' faamu mandishpai wagaa nakululuu jumulanu defidekiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tsaaren juntsangue' defituren, maliiba jayu aawa' mangueraindetyu', kaspele naaju ejkeke deju'ba juntsaaren ne judeewa. Juntsai kipitu mandengayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Tsejtu manen kasu' manguipiñu, umaa mandishpai ali trigu tene narai de-awave ma lura juunuren. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tsenñu bene yala' benesha mandishpai trigu ali pajlanu deechusha jamu ishuwachi dejuya' ejke jupeendene de-awave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tsejtu entsa ejkekee ali jumula aa ali naraa jumulanu defidekiwa. Entsai kipitaa mirukulanu iya entsandi kuinda keñuren, maliiba aseeta dekityu' inu dewandi've naa-i kipitaa tsaiñuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tsenñu José faraónnu pakatu tsandimi: Ñu pai bijee kipiiñushu juntsa main juuren tsaave. Dios wajturen tyee kenu ju'ba ñunu mijakaatunguiñuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mandishpai wagara naraashu juntsala mandishpai añu juve ti' keewarave. Tsenmala mandishpai trigu ali naraashu juntsala bain tsaren mandishpai añu juve ti' keewarave. Tsaju' juntsa kipiñu jumula main juuren tsaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tsenmala mandishpai wagara ejkekee firuu jumula bendala faamula bain, mandishpai añu juve ti' keewarave. Tsenmala mandishpai ali ejke jupe deeve tishu juntsala bain mandishpai añu tiba yamuj inu juve ti' keewarave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tsa' mitya iya ñunu naati pañuba, Dios bene juntsanguenu tsuyu ti' ñunu keewaatunguiñuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kumuinchi Egipto tusha mandishpai añu' mityaya pure' bui tinbu juu tiyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tsejturen bene mandishpai añu' mityaya tiba yamuj juu tiyanu tsuve. Tsainmala naa Egiptosha tiba bui tinbu i' puimuwaañuba mandengan dejutyuve. Entsa yamujka tinbu nuka bain tiba finutsumu millangue dekikaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Juntsa-i' aa yamuj tiyanmala, naajulaba kaspele bui tinbu i' puimuwaañuba jaiba mandengai'nu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tsejtu ñunu juntsaren pai bijee kipikaamiya, Diosya ura uwain tsanguenbera kenu ju', wajturen tsanguenu jutaa tsanguiñuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tsa' mitya ñu, faraón, main bibu' aseeta juunu mi'ke' kade, tsangue' yanu Egipto tunu washna' keenakaanu tireñu urave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tsejtu ñu entsanguide: uñi detire' naa nukaba de-eetu chachilla ti de-iware' kañu bain man pela veekare' ma pela kalare' ñuchi wa'kaakaa kikaade, matyu juntsa mandishpai añu tiba inu tinbu pullaindyuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tsejtu kumuinchi juntsa finutsumi jumula juntsa mandishpai añu tiba de-inu tinbunu deka' pebulutala de-uukare', faraón' tyaapasha puite' washkikaade, bene chachilla finudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tsenmala entsa fikenuu jumula uukara' tsananu tsuve juntsa mandishpai añu yamuj tinbu janmala chachilla finudetsu, matyu Egiptosha chumula pandachi yamuj detiya' peyan jutyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","José entsandiñu, faraón bain, naa ya' kelunu mi'na' tiba kiikemu chachilla bain pensangue' keetu, uraa tyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tsenñu faraón yachi tiba kiikemu chachillanu entsandimi: ¿Veelaba entsaa Diosa' espirituchi kivetaa chachi katawanu jun? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tsejtu Josénu tsandimi: Ñu tsaa bibu' pensa juu, tsenmin tsamantsa aseeta juuya dejutyuve, matyu Diosya ñunu entsaa mijakaanu tireñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ñaa in chunu yanu bale ruku mandiyanu juve. Tsenmala kumuinchi in chachilla ñu' uudennu tene meedinu detsuve. Tsaaren iyaa rei' mitya iren ñunu kayu pullaa bale ruku chunanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tsanditu: Iya ñunu kumuinchi entsa Egipto tusha washkemu uñi tirentsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tsejtu faraón, ya' muute chujtintsumi suutes kalaatu, José' tyamishunu pukemi. Tsanguemin balela' pannu ura linu jali pangaanu uudenguikemi, tsenmin kutunu panantsumi bain uru tene juu pandekaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Tsanguetu bene ya' kelunu jijiimu naraa karu kawalluchi ju'llaa jumunu e'lare' eekemi. Tsenñu ya' chachilla ajkesha utis jijiitu, chachillanu entsa entsandila: Ya' ajuusha teedi' balengure' keewaadei, tiitila. Entsaitaa José kumuinchi Egiptochi uñi tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tsenñu faraón bene entsandimi: Iyaa faraónyu, tsaaren muba ñunu uuden pa'tyumujchiya Egipto' chulla tiba kenu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tsejtu faraón Josénu vee mumu manbutu Egipto palaachi Safenat-panéah timi. Tsenmin, Josénu faraón supungumi On pebulubi chumu, pajtanu dyus kure' balenguumishtimu ruku Potifera' na'ma, Asenatnu. Tsenñu José kumuinchi Egipto tusha bale ruku tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José 30 añu juunu uwanaa faraónchi taawasha kemu tiyami. Tsejtu José nukaba lu' ji' deneimi Egiptosha. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Juntsa mandishpai añunu tiba pure' bui tinbu tiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tsenñu José juntsa bui tinbu jañu kumuinchi tiba imula mandishpai añunu deka' wa'kaatu nutsa pebulusha kalen juñuba junga taji' tsutsungaakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","José juntsangue', bui inu tinbu jañu deka' wa'kaatu, finutsumi trigu pure' kake' fera ñiipe tsun tsangue deka' wa'kaami, tsejtu tsamantsangue wa'kaatu naake' miken tsai tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kayu yamuj tinbu jaindyuren, José ya' shinbu Asenatba pai na miyandimi. Asenatya On pebulubi chumu, pajtanu dyus kure' balenguumishtimu ruku Potifera' na'ma juwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Tsejtu José ajke' nanuya Manasés mumu pumi, Dios yanu naa taaju ke' puiñuba demanbashware', naa ya' paandela' mitya bain pensandyawaatyuve titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Tsenmin ya' bene nanuya Efraín mumu pumi, Diosya ya' taaju-i' puinu tunuren tiba yaichi uraanuu dekikare', naa na bain miyandiwaave, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tsenñu Egiptosha yumaa mandishpai añuya bui tinbu de-i' puiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","umaa mandishpai añu yamuj tinbu tene jumu bain tiyami, José naati pamuwaañuba juntsaitu. Tsenñu naa nuka bain ti fin tsai tiyala. Tsaaren Egiptoshaya tiba fikenuu jumula tsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tsenñu bene Egipto' chulla ti fin tsai tiyatu, faraón' junga ji' panda pa' jila. Tsenñu faraón kumuinchi Egiptosha chullanu tsandimi: José' jungaa ji' dekeetu, ya naatiñuba tsanguidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tsejtu naa nuka bain ti fin tsaa tiya deiñu, José nuka nuka fikenuu buli uukara' tsuñuba majuuke' atintsumi Egipto' chullanu, matyu nukaba kayu yamujka ne tiyaintsuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tsenñu naa nuka tu' chulla bain ti fin tsandyatu Egiptosha buli ati'kanu José' junga jijiila, matyu nuka bain tiba fikenuu tsutyuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob Egiptoshaya fikenuu tsuñu mijatu ya' nalanu tsandimi: ¿Tyeenguendaa ñulla veta' veta' ne keedenayu? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Egiptoshaya fikenuu tsuve detishu, jungaa ji' ati'kaidei, laaba tyee fitaa chukeenuumiñu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tsenñu José' naatalala paityalaya Egiptosha jila finutsumi ati'kainu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tsa deiñun Jacobya ya' kayi na, José' benna, Benjamínnuya eetyumi, tyeeba urajtu ichuve tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tsenñu Israel' nala veelaba debuudi' jila fikenuu ati'kainu, matyu naa nukaba Canaán tusha yamuj detiyaiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joséya juntsa tusha uñi ju' mitya, tiba fikenuu jumula ya tene naajulanu bain ai'mu jumi. Tsenñu ya' naatalala ya' ajuusha dejitu, yala' llashkapa tusha tyuikanbera waike' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tsenñu José ya' naatalalanu katatu mangueengami, tsejturen kerajtu chacheeba ju' yalanu pake'mere' daran pan tsanditu entsandimi: ¿Ñulla nuka chumaa jatu deiyu? timi. Tsenñu yala pakatu: Canaán tushaa dejayu fikenuu ati'kanu jatu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Tsaaren naa Joséya ya' naatalalanu mangueengañu bain, ya' naatalalaya yanu mangueengaindyula. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tsenñu José mandengami kaspele yalanu kipi kipiitu naa-itaa tsaimuwa ju'ba. Tsejtu yalanu entsandimi: Entsa tutala nunbatalaa washajtuñuba ñulla jundala vinguija' kanu keentsures nemu chachi deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tsenñu yala pakatu: Tsa jutyuve, ruku. Lala ñuchi tiba kiikemu chachillaya fikenuu ati'kanu jatu deiyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Lalaya kumuinchi ma apa' naren dejuyu, tsenmin ura' chachi deeyu; ñuchi tiba kiikemu chachillaya firu' kenu keentsures nemu dejutyuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tsenñu José tsandimi: ¡Ñulla anbutindetsuve! Entsa tutala nunbatalaa washajtuñuba ñulla jundala vinguija' kanu keentsures nemu chachi deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tsenñu yala pakatu: Lala ñuchi tiba kiikemu chachillaya 12 naatala dejuyu, ma apachi tene. Tsenmin Canaán tusha chumu deeyu. Tsaaren ma naatala kayiya lala' apaba shuwave, tsenmala mainya laaba chutyuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tsenñu José manbatu: Ñulla uwain vinguija' kanu keentsures nemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tsa' mitya uwain anbukuinda kindetyuñu bain mijanu tsuyu: faraónnu paka' uwain tsanguenbera kenu ti', ñulla kayi naatalanu taatyumujchiya maliba malu' mijin dejutyuve tintsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tsa' mitya main miji' mangaidei ñulla' kayi naatalanu. Tsenmala mantsalaa enu peesusha shuwanu dejuve, uwain ura' depañuba mijanu. Tsa jutyushu juntsaa, uwaindiyu faraón chuve ti' yanu paka' ñulla uwain vinguija' kanu keentsures nemu chachi deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tsejtu José yalanu pen malu peesusha pu' tadimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tsejtu pen malusha José yalanu tsandimi: Iya Diosnu meenguemuyu. Tsa' mitya entsanguishu juntsaa tutatyu' livee inu detsuve: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ma naatala peesusha shuikike', mantsalaya demiji' ñulla' bululachi fikenuu manda'dei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tsejtu bene ñulla' kayi naatalanu taadei. Tsa dekishu juntsaa ura' depañuba mijanu tsuyu. Tsa deki'shu juntsaa peyanu detsuve, timi. Tsandiñu yala tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tsejturen yai tene veta' veta' tsandila: Uwain lala' bennanu yuj firu' jumuwa deeyu: ¡Tsanguityukai! tiñuba meranguityu', taaju ikaamuwa deeyu. Tsa' mityaa laa bain challa entsangue taaju manguendetsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tsenñu Rubén pakatu: Iya tsandiwayu: Juntsa kaananu firu' kityudei, tiñuba, demeedi'su. Challa laa bain taaju kenu dejuyu juntsan mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tsaaren yalaa mijtula naa José yala' palaanu aseeta juñuba, matyu José yaiba kuinda kendu Egipto palaachi panmala, vee rukaa aseetangue' hebreo palaachi manba manbatintsuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tsenñu José vee mujtu baka' miji' ware', manen yala' puinsha miitu yaiba manbami, tsejtu yala dekeenaren Simeónnu kakaami peesu punu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tsanguetu bene José ya' chachillanu uudengue' ya' naatalala' kustaasha trigu tyuwake depu', naa yala' paangueñu lushi bain yalanu main main yala' kustaasha demanbu' me-ere', naa yaichi miñusha panda fintsumi bain kuwa' me-eedei, timi. Tsenñu ya' chachilla tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tsenñu fifikenutsumi pumu kustaa yala' burunu demayangare' miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tsai' miindu tsunu tenanu detsundu ma ruku ya' burunu panda fikaanu kustaa yachi juukemi. Tsejtu kustaa juukapanu ya' lushi puna mangatatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ya' naatalalanu tsandimi: ¡Keejadei! Inu lushi manguwadekiñuve. Enu entsanave in kustaanu, timi. Tsejtu kumuinchi yala tsamantsa wapana' dejullukendu veta' veta' entsa entsandila: ¿Dios lalanu tyee ketunguiñu tsanguemi? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Tsejtu Canaán tusha miitu, yala tyee i' demaji' bain yala' apa Jacobnu tsangue dekuindaketu, tsandila: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Juntsa tusha chumu uñi lalanu yuj ajaatya' patu: Ñulla vinguija' kanu keentsures nemu deeve, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tsandiñu, lala tsa detiyu: Ura' chachi tene judeeyu; tsenmin lalaya vinguija' kanu keentsures nemu bain dejutyuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Lalaya 12 naatala juwa deeyu ma apachi tene. Tsaaren ma naatalaya laaba chutyuve. Tsenmala main kayi bennaya Canaán tusha lala' apaba shuwave, detiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tsenñu ya entsandiwa: Uwain ñulla ura chachi deeñuba mijanu tsuyu. Ma naatala iba shuike', mantsalaya demiji' ñulla' bululachi finutsumu manda'dei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tsaaren ñulla' kayi naatalanu taadei. Tsa deishu juntsaa ñulla uwain vinguija' kanu keentsures nemu chachi dejutyu', deechu' kiikemaa dejuñuba mijanu tsuyu. Tsa dekishu juntsaa ñulla' naatalanu livee kenu tsuyu, tsenmala bene ñulla entsa tusha buli ati'kas neneinu detsuve, tiwa, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tsejtu yala, ya' apanu tsandi kuinda ketu, kustaa manduukendu kustaameemee kaa buusanu yala' lushi puundene katala. Tsejtu kaa buusatala lushi puu dekatatu, yala bain, naa yala' apa bain wapanla. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tsenñu ya' apa Jacob tsandimi: Ñulla inu na miyajtu shuikikendetsuve. Joséya yumaa kataatyuve, Simeón bain. Tsenmala challa Benjamínnu bain tajinu dejuve. Entsainmala inchi tene urajtu jujuuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tsenñu Rubén ya' apanu tsandimi: Benjamínnu eede. Iyaa ya' mitya mijanu tsuyu. Iya ñunu mandaja' kutyunmalaya, in pai kaillanu tu'de, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tsandiñu, Jacob pakatu tsandimi: In na ñuiba jin jutyuve; Joséya peyañu, challa yaren main juuve. Miñutala jindu tyeeba iñuba ñullaa kuipanu detsuve, iya ruku llakindyanchin peyañu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Canaán tusha kayu yamuj tiya' ne jiintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tsaintsuñu yala Egiptosha taañu finutsumi defiketu, Jacob ya' nalanu tsandimi: Manen demiji' laachi finutsumi ma-ati'kaidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tsenñu Judá tsandimi: Juntsa rukuya entsandiwa: Ñulla' kayi naatalanu demiya' taatyushu juntsaa, ñullanu mijapetse ken jui'yu, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tsa' mitya ñu' kayi nanu eeñuya finutsumi miji' ma-ati'kainu deeyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tsaaren ñu' kayi nanu laaba eetyushu juntsaa jikeyan jutyuve. Juntsa rukuya entsandiwa: Ñulla' kayi naatalanu demiya' taatyushu juntsaa, ñullanu mijapetse ken jui'yu, tiwa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tsenñu Israel entsandimi: ¿Ñulla tyeenguenaa tsa deti', juntsa rukunu ñulla kayi naatala miya deeyu ti' dewainyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tsenñu ya' nala entsandila: Tsaaren yaa lala nan naatala dejuñuba mijanu ti', naa lala' bululanu bain depake'meetu entsandiwa: ¿Ñulla' apa chaiba chuu? ¿Vee naatala mamiya dejuu? tiitiwa. Tsenñaa lala dekuindakiwayu ya titi pake'meeñuba. Tsa' mitya ¿nejtaa lala mijanu dejuwa naa lala' kayi naatalanu miya' jadei ti' panuuñuba? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Tsenñu Judá ya' apa Israelnu entsandimi: Ñu' nanu iba eede, tsenmalaa lala lu' jinu detsuyu, tsejtaa laa bain, ñu bain, naa lala' kailla bain pandachi peyan dejutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iyaa ya' mitya mijanu tsuyu; tyee iñuba inaa paka. Iya mamiya' maatyushu juntsaa, naa-uwanuba in chungamaya kuipa junu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tsandin keenai'tuya yumaa pai bijee ji'ba maantsuchu deeyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tsenñu ya' apa pakatu: Naaken tsaa jukeeñu' mitya, entsanguidei: juntsa rukunu kuwanu ñulla' kustaanu tiba entsa tusha kayu ura awamu take' kuwadei, naa balsamu tinu chi pillu bain jayu, mishki bain jayu, pindyupi bain, mira tinu chi pillu bain, nues bain, naa almendra bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Naa kustaanu puu majaishu juntsa lushi bain mandaji' kudei, ya' chachilla tujletaaba tsanguelaa tenve. Tsenmin vera ma ati'kanu lushi bain juntsangue manda'dei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tsejtu ñulla' bennanu Egiptosha miya' ji' juntsa rukunu keewaadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Matyu tiba kekaanuu jumu Dios juntsa rukunu ñulla' mitya tenbityakare' Simeónnu bain, Benjamínnu bain livee kikaasa. Naa iya in nalanu dechipainuu juñu bain chipanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tsenñu Jacob' nala Egiptosha demiitu, uñinu kuntsumi ta'min, lushi bain pai bijee juuñungue detake', naa Benjamínnu bain miya' jila. Tsejtu José' junga jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tsenñu José, ya' naatalala Benjamínnu demiya' jiñu katatu ya' yasha uudenguemu bale rukunu tsandimi: Entsa rukulanu in yasha miya' jide, tsejtu ma animaa tute' panda kidei. Yala uma pajta katyu urasha iba bulu chudi' panda finu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tsenñu juntsa ruku José naake uudenguiñuba tsanguetu, juntsa rukulanu José' yasha demiya' jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tsenñu yalanu José' yashaa takendetsuñu wapanandu, entsa entsandila: Ajke' bijeenu lala' kustaasha lushi manbu' kuwadekisu juntsa' mitya lalanu kuipa faawaanaa engu detaave, tsejtaa lalanu deka', naa lala' burunu bain deka', yachi manda-i' taawasha kemu chachi detirenu, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tsejtu ya juukapa kalen dejitu, José' yasha uudenguemu bale rukunu tsandila: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Rukui, lala kaspele dejatu finutsumee ati'kanu dejayu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","tsejtu tsunu tenabi demiji' kajditaa lala' kustaa dejuukiñu, main main lala' kustaa juukapasha lala' lushi naake ati'ka' depaangueñuba tsana manbuñu dekatawayu. Tsejtu lala juntsa lushi tsai demandaayu manguwanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tsenmin laachi finutsumu vera manganu bain kayu lushi demandaayu. Tsa' mitya lalaya mijdetuyu maa lala' kustaasha lushi depuñu bain, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tsenñu juntsa bale ruku entsandimi: ¡Pensandyatyudei! ¡Jeetyatyudei! Ñuichi bain Dios, naa ñulla' apachi bain Dios jumaa juntsa lushi kuwatunguive tsangue' ñulla' kustaasha pumi. Iya ñulla' paanguiñu lushiya kamuwaayu, timi. Tsejtu juntsa bale ruku, Simeónnu peesu pumunu mangalaaji' ya' naatalala' junga mandajimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tsanguetu, kumuinchi yalanu José' yasha demiya' jitu neepa manbitsaanu pi bain dekuwatu, naa yala' burunu bain panda fikaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tsenñu yala Josénu tyee me'nu detaji'ba ura' deke' keenala, matyu yala pajta katyu urabi Joséba bulu chudi' panda finu ju'ba demija' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tsejtu José ya' yasha miiñu, yala tyee yanu me'nu taji'ba dekuwatu, ya' ajuusha deteedi' yala' llashkapa tusha tyuikanbera waike' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tsenñu José yalanu pake'meetu tsandimi: ¿Naaju dechuyu? ¿Ñulla kaspele ñu' apa chuve detisu, juntsa kaa ruku chaiba ura chuna? ti' pake'meemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Tsenñu yala teledi' depakatu: Lala' apa, ñuchi tiba kiikemu ruku, chaiba ura chuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tsenñu José ura ya' naatala Benjamínnu katatu, masku naatalalanu pake'meetu: ¿Entsaa ñulla' benna, ñulla kaspele padetisu juntsa kaanaa? timi. Tsanditu: Dios ñunu ura' ikaasa, in na, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","José entsandipatu, ya' bennanu keetu, yuj llakindya' waandinu tyatu, sukusha jei mavi' jungaa waami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tsejtu bene jayu llakindya puitetu kajuru manbitsale' mafaatu ya' chachillanu: ¡Panda chujtidei! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tsandiñu, Joséchiya vee mujtu chujti' kuwala, tsenmin Jacob' nalachi bain vee mujtu chujti' kuwala; naa junu Egipto' chulla José' junga fimulanu bain vee mujtu chujti' kuwala. Matyu Egiptosha chullachiya hebreo chachillaba bulu chudi' panda fishu juntsaa urajtu kurainuu juwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tsenñu José ya' naatalalanu naake uudengue' chujtikaañu bain juntsai chula. Tsejtu yala naa-i kayamuwa deju' bain ya' naatala tene shilii chula. Tsenñu yala keraipashi' veta' veta' ne keenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Tsejtu Joséya ti findu bain juntsaa yalanu mangukaami, tsaaren Benjamínnuya kayu aa kuwami, man chachi fikenuke kuwami. Tsanguemin binu bain bulu dekushtu yuj sunden puila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","José entsangue' dyatu ya' yasha uudenguemu bale rukunu tsandimi: Entsa rukula' kustaanu fifikenutsumi tyuwa tyuwake pu' kude, yala pude' mijinbera. Tsenmin yala' ati'ka' paanguiñu lushi bain yala' kustaameemee manbu' me-eede. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tsanguetun kayi naatala' kustaanuya lushi jeruchi kiñu in basu pude ya' paangue' trigu ati'kañu lushiba, timi. Tsenñu juntsa ruku, José naake mandangueñuba tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tsejtu dedanguentsuñu, José ya' naatalalanu: Miidei, ti' me-eemi. Tsenñu ya' naatalala miila yala' buruba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tsejtu juntsa pebulunu malu' miitu kayu baa mijindetyuren, José ya' keenu mi'namu bale chachinu entsandimi: Juntsa rukulanu bendaake' mangatatu, tsandide: ¿Nenñaa ñullanu uñi ura' keñu bain, ñullaya firu' deke', ya' bale basu taangue' maatu deiyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Inu uudenguemu rukuya juntsa basuchee kushmuve, tsenmin tyee inuu juñuba mija' panu juntsaa menestenguemuve. Tsa' mitya ñulla tsanguetu yuj firu' dekiñuve, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tsenñu juntsa rukunu José naati pa' eeñuba mami'diji' mangataitu tsandi pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tsandiñu yala entsandi pakala: ¿Nendiyu tsandimi? Lala ñuchi tiba kiikemu chachillaya juntsaayaa ki'chu deeyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Lala' kustaanu lushi pujiñu dekatataaba, Canaán tubi putun manguwanu maamuwa deeyu. ¿Tsaaba, nejtaa challa naa lushi jeru juuñu bain, naa uru juuñu bain, ñullanu uudenguemu ruku' yasha tsumu lala taanguenu dejuwa? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tsa' mitya ñuchi tiba kiikemu chachillanu maa juntsa basu tanañu katawañuba, juntsa peyasa. Tsenmala lala vejanlaya ñuchi manda-i' taawasha kemu chachi tiyakeenu juve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Tsenñu juntsa bale ruku tsandimi: Ñulla naati depañu bain tsainu juve. Tsaaren mun juntsa basu tana katawañuba, juntsaa inchi manda-i' taawasha kemu chachi tiyanu tsuve. Tsenmala vejanlaya tiba jutyu liveeju miinu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tsandinmalan main main yala' kustaa tusha jeke depajte' chujti' juukila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Tsenñu juntsa bale ruku yala' kustaameemee mi'ke' jiimi. Ajke' mi'kemiya avenju naatala' kustaanu mi'ke' jimin, kayi naatalabi jingue mi'kemi. Tsanguetu kayi naatala Benjamín' kustaanaa basu pu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tsenmalan ya' naatalala llakindya' keewaatu yala' pananu jali dekiyuuchitikila. Tsejtu main main yala' burunu buli demayangare' José' chunu pebulusha miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Tsejtu Judá ya' naatalalaba José' yasha demiitu, José yasha churen miila, tsejtu ya' ajuusha telededi' yala' llashkapa tusha tyuikanbera dewaike' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Tsenñu José tsandimi: ¿Tyee ketu dekiyu entsanguila? ¿Ñulla mijdetuu ma ruku i tsaaya mija' pamuuñuba? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tsenñu Judá pakatu tsandimi: ¿Naa titaa ñunu pakanaanga? ¿Naa titaa kuipajdetuyu tinaanga? Yumaa Diosya katakaave naa lala kuipa deeñuba. Tsa' mitya naa laa bain, naa ñu' basu puu katawamu bain buluren ñuchi manda-i' taawasha kemu chachilla tiya deiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tsenñu José tsandimi: Tsa jutyuve, basu puu katawamuren inchi manda-i' taawasha kemu chachi tiyainu tsuve. Mantsalaya tiba jutyun ñulla' apa' junga yasha miinu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tsenñu Judá Josénu kalen jitu, tsandimi: Iya ñuchi tiba kiikemu chachi ñu' ajuusha uidi' panu tenve. Tsantsaya inu ajaatyatyuka, ñuya faraón naajuñuba tsaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Uwain ñu, in bale rukuya, lala ñuchi tiba kiikemu chachillanu pake'meetu: ¿Apa miya deeyu? ¿Naa kayu vee naatala bain jun? tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tsenñu lala ñunu tsa detiwayu: Apa main ruku miya deeyu, tsenmin apa derukuinsha faamu na bain main lala' naatala unna miya deeyu, detiwayu. Tsenmin juntsa nanaa in apa kayu estyamuve, matyu ma shinbunu pai na miyandimuwaañuren, mainya yumaa peyañu, yaren main juuñu' mitya, detiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tsenñu ñuchi tiba kiikemu chachillanu ñu: Juntsa kaananu miya' jadei, katanu tenve, tiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","lala tsa detiwayu: Entsa kaananu ya' apa ba'kikaren dyatyuve. Tsaanuren deveeshu juntsaa ya' apa pensandyatu peyanu juve, detiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tsandiñuren, ñuya ñuchi tiba kiikemu chachillanu tsandiwa: Juntsa kaanaban jaindetyuya mamikan jutyuyu, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tsandiñu miitu, ñuchi tiba kiikemu, lala' apanu, ñu naatiñuba tsangue dekuindakiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Tsandiñuren bene apaya: Finutsumi miji' jayu ma-ati'kaidei, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tsandiñu lala entsa detiwayu: Lala' kayi naatalaban ji'mujchiya miikeyan jutyuve. Laa tene mijiishu juntsaya juntsa uñinu katawan jutyuve, detiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tsenñu ñuchi tiba kiikemu, in apa, tsandiwa: Ñulla mideeve in shinbu milla pai naren miyandiyaimuwaañuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Tsaaren mainyaa inu ba'ke' jiñu mangataindyuyu. Uwain jeendala firu animaaba bijchuu fimee tenve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tsenñuren ñulla in na veranu bain inu veeka' ji' tyeeba de-iwaashu juntsaa, ñulla kuipalanu dejuve entsa kaa ruku llakindyanchin peyañuba, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Tsa' mitya ñuchi tiba kiikemu, in apa, juntsa kaana' mityaa chaiba chuve, tsaanun lala juntsa kaanaba miityushu juntsaya, juntsa kaananu ya' apa yuj estyamu' mitya, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","apa llakindyanchin peyanu juve, juntsa kaananu katai'tu. Tsa' mitya ñuchi tiba kiikemu lala' apa peyañuba, lala ñuchi tiba kiikemulaa kuipalanu dejuyu, titu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","iya ñuchi tiba kiikemu ruku, in apanu entsandiwayu: Iya juntsa kaananu mamiya' maatyushu juntsaya naa-uwanuba kuipa junu tsuyu, tiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tsa' mitya tsantsaya inaa juntsa kaana' mitya ñuchi manda-i' taawasha kemu chachi juu tiwaasa tenve. Tsejtu juntsa kaananuya me-eede ya' naatalalaba miinutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Matyu entsa kaanaban miityumujchiya in apa' junga miji' apa llakinguentsu katandendyuve, timi Judá. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tsenñu José, ya mu ju'ba wainnu tya' naaken tsandyandu, kumuinchi ya' taawasha kemu chachillanu: ¡Enu demaluidei! timi. Tsandiñu, ya' taawasha kemu chachilla junu demaludeiñu, José ya' naatalalanu mangueengakutimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tsejtu José daran waañu' mitya, junu chumu Egipto chachilla demerekila, naa faraón' yasha chumula bain mijala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Tsejtu José ya' naatalalanu tsandimi: Iya Joséyu. ¿In apa chaiba chuna? timi. Tsandiñu, ya' naatalala wapananchin pakai'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tsenñu José tsandimi: In junga kalen jaidei, timi. Tsenñu, kalen dejiñu, tsandimi: Iya ñulla' naatala Joséyu. Ñulla inu de-ai'ñu Egiptosha taamuwa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tsaaren challa llakindyanu kityudei, naa ñuitala ajaatya bain ityudei. Ñulla inu de-ai'ñu bain, Diosya inu engu ajke' eetunguive chachillanu livee kikaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Challa yumaa pai añu puive yamuj tiyañuren, tsaaren kayu man añu faatave yamuj janu. Tsa' mitya naake buikiya dewajñu bain awai'nu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tsaaren Diosya inu entsa tusha eeve finutsumi uukare' ñullanu livee kikaanu tiretu, entsanguetaa pure' chachillanu livee kenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tsa' mitya ñullaa tsangue' inu entsa tusha erendetyuve; Diosya inu eeve. Diosya inu faraónnu mijakares neneimu tire', kumuinchi ya' tananutsumi bain uudenguen chunu tire', naa ya' yasha bain, naa kumuinchi Egiptosha bain uudenguen chunu uñi tireve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tsa' mitya apain apa' junga miitu, tsandidei: Ñu' na José entsandive: Diosya inu kumuinchi Egipto tusha uñi puve, apain inu ja' keejaka. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tsejtu Gosen tushaa chuja', in keesha kalen chunu juve ñu bain, ñu' nala bain, ñu' pañala bain, kumuinchi animaala bain, tsenmin kumuinchi ti taju'ba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Tsa deinmalaa naa ñunu bain, naa ñu' bululanu bain, naa ñuba chumulanu bain tyee menesteñuba dekuwan chukaanu tsuyu, chaiba yamuj tinbu tene man añu tiyanuu juñu' mitya, tsenmalaa tiba yamujka juu chui'nudetsu, tidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Challa ñui bain, naa in naatala Benjamín bain demeenave iren entsandintsuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tsa' mitya apanu miitu, entsa kuinda kidei: Iya Egiptosha bale ruku puñu, naake kata' miji' bain apanu tsandi kuinda ke' dijeru' miya' jadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tsejtu José ya' naatala Benjamínnu amangue' waami. Tsenñu ya' naatala Benjamín bain ya' naatala Josénu amanatun waami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Tsejtu bene José ya' naatalalanu de-estitu amangue' waami. Tsangue' dyañu, ya' naatalala yaba kuinda kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","José' naatalala dejañuba faraón' yasha mijala. Tsenñu faraón ya' kelunu mi'na' tiba kiikemulaba sundyala José' naatalala' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tsejtu Josénu faraón tsandimi: Ñu' naatalalanu tsandide: Finutsumi deka' ñulla' burunu depande' Canaán tusha miidei, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","tsejtu ñu' apanu bain, ya' bululanu bain taadei. Tsenmala iya kayu ura tu jumulaa kuwanu tsuyu, tsenmin Egipto tusha finutsumi uukeraa bain dekuwanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tsenmin ñuya yala enu Egiptobiren kawalluchi ju'lla' jimu karu jumula deka' taji' yala' shinbulanu bain, naa yala' kaillanu bain, naa ñulla' apanu bain miya' janudetsu, ka' jinu uudenguide. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tsenmin ñulla ti tana' deshuikendu bain juntsala' mityaya pensandyatyudei, matyu kumuinchi Egiptonu kayu naraa jumulaa iya dekuwanu tsuyu, tive, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tsenñu faraón naa naakide tiñuba José juntsangue', naa kawalluchi ju'lla' jiimu karu bain dekuwa', naa mindala finu panda bain dekuwa' me-eeñu, Israel' nala juntsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tsenmin yalanu main main kasa jali manbannu kuwami. Tsanguetun Benjamínnuya lepa lushi jeru bain 300 kumin, jali bain manda kuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tsejtu ya' apachiya paitya burunu buli tene pande' eemi junga Egiptosha tiba ura jumu tene. Tsenmin kayu paitya burunu bain trigu tene pande' ere', naa pan juula bain, naa kayu tiba finutsumila bain de-eemi, ya' apa jandu miñutala fis janutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tsejtu, José ya' naatalala miindetsuñu, tsandimi: Jundaa miindu miñutalaaba vingues demiidaa, timi. Tsenñu ya' naatalala miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tsejtu Egiptobi malu' miimin, Canaán tubi mavijila, ya' apa' chuinbi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Tsejtu ya' apanu dekuindaketu: ¡José chaiba chuve! ¡Egiptosha yaa uñi puve! tila. Tsenñu ya' apa tsa detiñu meenatu, naatin tsandyamin, matyu ti ken tsandyami, yala tsa detiñu uwain tsaave tyatyu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tsejtu yala José naati pañuba tsandi kuinda ketu, naa kawalluchi ju'lla' jimu karu bain eeve ti' dekeewaañu, pa'piyatu yuj sundyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tsenñu Israel tsandimi: In na José uwain chaiba chuñuve, kayu peyai'mujchin, ya' junga ji' keenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tsejtu Israel kumuinchi ya ti ta'ba juntsalaba lu' jitu Beersebabi vijimi, tsejtu junu animaa tute' ju'ke' keewaami ya' apa Isaac' aawa kure' keewaanu Diosnu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Juntsa kepe Israelnu kipibi katawaiñu-itu, Dios ya' mumunu pa' entsandimi: ¡Jacob! ¡Jacob! timi. Tsenñu Jacob pakatu: Enu puyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tsenñu Dios tsandimi: Iyaa Diosyu, ñu' apa' Dios. Egiptosha jinu jeetyatyude. Iya ñullanu juntsa tushaa aa bulu chachi detiwaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Iya ñuba Egiptosha jinu tsuyu. Tsejtu ñunu sera' jimulanu iren bene junu mangalarenbera ke' Canaán tusha mandaanu tsuyu. Tsenmin naa ñu peyañu bain, Joséya ñu' kelunu pu', ñu' kapuka du'kaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Tsejtu bene Jacob Beerseba tenanu malu' miintsuñu, ya' nala, naa ya' apanu bain, naa yala' kaillanu bain, naa yala' shinbulanu bain, kawalluchi ju'lla' jiimu karu jumulanu deka' pukila, faraón jadei ti' eeñu karunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tsejtu Jacob kumuinchi yanu sera' jimulaba Egiptosha jimi, tsejtu naa yala' wagaa bain, naa yala' uveja bain, tsenmin ya Canaán tusha tyee demiyandimu ju'ba juntsala bain detakikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Tsenñu kumuinchi ya' nala bain, naa ya' na'mala bain, naa ya' pañala bain, naa supu na'ma pañala bain yaba jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Entsalaa Egiptosha jimu Israel nala' mumu deeve, ura patiñuya, Jacob bain, naa yanu sera' jimula bain: Jacobchi ya' ajke' naya Rubén. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubén' nalaya: Hanoc bain, Falú bain, Hesrón bain, Carmí bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeón' nalaya: Jemuel bain, Jamín bain, Óhad bain, Jaquín bain, Sóhar bain, naa Canaán tusha chumu shinbu' na Saúl bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leví' nalaya: Guersón bain, Quehat bain, naa Merarí bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judá' nalaya: Er bain, Onán bain, Selá bain, Fares bain, naa Zérah bain (tsaaren Er, Onánbaya yumaa peyamuwaala Canaán tusharen). Fares' nalaya: Hesrón bain, Hamul bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacar' nalaya: Tolá bain, Puvá bain, Job bain, naa Simrón bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulón' nalaya: Séred bain, Elón bain, naa Jahleel bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Kumuinchi entsa nalanaa Lía Padán-arambi Jacobnu naka' kumuwaami, naa ya' na'ma Dinanu bain. Tsa' mitya Líanu sera' jimu chachillaya kumuinchibi 33 chachi jumuwaala, matyu unbee rukulanu bain, naa supulanu bain demikaju. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad' nalaya: Sefón bain, Haguí bain, Esbón bain, Suní bain, Erí bain, Arodí bain, naa Arelí bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser' nalaya: Imná bain, Isvá bain, Isví bain, Beriá bain, naa yala' tsujki Sérah bain. Beriá' nalaya: Héber bain, Malquiel bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Entsalaa Zilpá Jacobnu ka' kuñu nala deeve. Tsaaren Zilpáya Labánchi manda-imu shinbuwaanuren, Labánya ya' na'ma Líanu kumuwaami. Tsa' mitya Zilpánu sera' jimu chachillaya kumuinchibi 16 chachi jumuwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Raquel' nala, matyu Jacob' shinbu' nalaya: José bain, Benjamín bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José, Asenatba keñu nalaya entsalaa jumuwaala: Manasés bain, Efraín bain, Egiptonu nakayamula. Asenatya On pebulunu chumu pajtanu dyus kure' balenguumishtimu ruku Potifera' na'mawaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamín' nalaya: Bela bain, Béquer bain, Asbel bain, Guerá bain, Naamán bain, Ehi bain, Ros bain, Mupim bain, Hupim bain, naa Ard bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Entsalaa Raquel, Jacobba keñu sera' jimu jula, matyu kumuinchibi 14 chachi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan' naya: Husim. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Tsenmala Neftalí' nalaya: Jahseel bain, Guní bain, Jezer bain, naa Silem bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Entsalaa Bilhá Jacobnu ka' kuñu nala deeve. Bilháya Labánchi manda-imu shinbuwaanuren, Labánya ya' na'ma Raquelnu kumuwaami. Tsa' mitya Bilhánu sera' jimu chachilla kumuinchibiya mandishpai chachi juwaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Entsalaa Jacobba Egiptosha jimula deeve, ura yanu sera' jimu nalaba juuya kumuinchibi 66 chachi juwaala, tsaaren Jacob' nala' shinbulanuya mikajturen. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José Egiptobi pai na miyandimuwaami. Tsa' mitya Egiptobi jilaya 70 chachi jila Jacob' bulula tene. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tsejtu Jacob, Judánu ajke' eemi José' junga, tsenmalaa keeji' Joséba buluuya Gosensha Jacobnu keejisa tyatu. Tsejtu Gosensha dejiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José ya' chachillanu karu ura' dekikaami ya' apa' junga ji' keenu. Tsejtu ya' apa' junga jitu amangue' pure' waandimi ya' apanu amanamujchi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Tsenñu Josénu ya' apa Israel tsandimi: Umaya ñu chuñuba mangata' mitya, naa peya'ba urayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tsejtu José ya' naatalalanu bain, naa ya' apa' bululanu bain tsandimi: Faraón' junga miinu tsuyu; tsejtu entsandinu tsuyu: In naatalala bain, naa in apa' bulula bain Canaán tusha chumularen iba chunu millai dejave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tsejtu yala' taawashaya uveja washke', wagara bain awakaamu de' mitya, naa yala' uveja juula bain, naa wagara juula bain, tsenmin ti ta'ba detajadeive, tinu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tsa' mitya faraón ñullanu mika' pake'meetu: ¿Ti taawashaa kemu deeyu? tiñu bain: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Lala ñuchi tiba kiikemu chachillaya naa-uwanuba animaa washkemu deeyu, lala' kaspee apala bain animaa washkemuwa deeñu' mitya, tidei. Tsa detishu juntsaa ñulla Gosen tusha chunu detsuve. Matyu engu chullaya uveja washkemulaba bulu chunanu tyatyu deeñu' mitya, timi José. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","José faraón' junga ji' kuinda kiitu, tsandimi: In apa, in naatalalaba Canaán tusha chumula yumaa Gosen tusha dejave. Tsejtu yala' uveja juula, naa wagara juula, tsenmin kumuinchi yala ti taju'ba detajadeive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tsejtu José ya' naatalalanu manda miya' ji' faraónnu keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tsenñu José' naatalalanu faraón pake'meetu tsandimi: ¿Ñulla ti taawashaa kemu deeyu? timi. Tsenñu yala pakatu: Lala, ñuchi tiba kiikemu chachillaya, lala' tinbu aa-apala bain naajuwa deeñuba tsa deju' uvejaa washkemu deeyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Lala, ñuchi tiba kiikemulaya, Canaán tusha pure' yamuj juuñu, tsenmin naa uvejala bain nuka ishtape fin tsa deeñu entsa tusha jayu tinbu' mitya chunu dejayu. Ñu tsantsaya lala ñuchi tiba kiikemu chachillanu entsa Gosen tusha chukaaka, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tsenñu faraón tsandimi Josénu: Ñu' apa, ñu' naatalalaba ñu' junga dejañu' mitya, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ñu Gosen tu kuwade, nunbanu Egiptosha kayu uu chunnañu bain. Tsaaren yala mallee vejan washkemu chachillanu uudenguen chunuu dejuñuya, in chachillanu wagara washkekaanu pude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Tsejtu José ya' apa Jacobnu bain miya' jimi faraón' junga keewaanu. Tsenñu Jacob junga jitu, faraónnu: Dioschi ura' isa tenve, ti' pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tsenñu Jacobnu faraón pake'meetu: ¿Nan añu juyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Tsenñu Jacob pakatu: Yumaa 130 añu juyu, matyu nukaba chudi' vee mujtu malu' miji' chuchudindu. Tsaaren in kaspee apala tsai wanchuindyuyu. Tsa' mitya jayun chudinduren naa ura' chukeyaba indyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tsejtu Jacob faraónnu Dioschi ura' isa ti', malu' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Tsenñu José ya' apanu bain, ya' naatalalanu bain Egipto tusha, Gosensha, tsandityu'ba Ramsés tenanu kayu uu chununainshaa tu kuwami. Tsejtu faraón naa naakide tiñuba José tsanguemi. Entsanguiñaa ya' apa ya' naatalalaba taawasha kenu tu tadila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tsenmin José ya' apanu bain, ya' naatalalanu bain main main kailla nan miya deeñuba finutsumi kuwa kuwakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tsenñu nukaba finutsumi jutyuñu, Egipto' chulla bain, naa Canaán' chulla bain kayu aa yamuj inchi ma-iintsuñu, mantsa dedesmee-iintsula panda fi'tu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Naa Egipto' chulla bain, naa Canaán' chulla bain finutsumi ati'ka' lushi paangui paanguidekiñu, José lushi dekatu faraón' chunu yabi de-uukaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tsenñu kumuinchi Egipto' chulla bain, naa Canaánsha chulla bain lushi ma dekiketu, José' junga jitu tsandila: Ñu lalanu panda kuwaka. Tsangui'shu juntsaa lalanu ñu' ajuusha pekeyanu tsuve, lushi jutyu tichi ati'kan tsa de' mitya, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tsa detiñu, José tsandimi: Ñulla lushi tajdetushu juntsaya, ñulla' animaa taadei. Tsenmala finutsumichi vete vetekenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tsenñu Egipto' chulla yala' kawallu juula, uveja juula, wagara juula, buru juula bain José' junga detaañu, José juntsaa ma añu de-ingamaya finutsumichi vete vetekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tsaaren juntsa añu puiñu, masku añusha manen José' junga miitu tsandila: Naa lushi bain dekideke', naa lala' animaala bain challa ñuchi tene judeeñu, lala tiba tajdetu' tichi ati'ka' fin tsa deeyu, matyu lalaren ju', lala' tu bain, juntsaren juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tsa' mitya ñu lalanu bain ati'kaka, naa lala' tu bain. Tsanguetaa lalanu fikenuu kuwaka lala peyai'nudetsu. Tsenmalaya lala faraónchi tiba kiikemu chachi tiyainu detsuyu. Tsenmin ñu lalanu wajnutsumu kiya bain kuwaka, lala' tunu tibangui'mujchi tsanakaan jutyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Entsanguetaa José Egiptosha tu jumula faraónchi de-ati'kakemi, matyu Egipto' chulla panda mutyanchiren tu millangue de-atiñu. Tsenñaa kumuinchi tu faraónchi tene tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tsejtu Egiptosha chumu chachilla naajulaba faraónchi taawasha ke' kumu tene tiyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tsaaren José vejanlanuya tu de-ati'kaketuren, pajtanu dyus kure' balenguumishtimu rukula' chunu tenanun ati'kaindyuumi. Matyu yalanuya faraón naa-uwanuba finutsumi kuwa kuwakeñu' mitya yala' tuya atindyula, faraón yalanu panda kuntsuñu fin dechu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Tsejtu José Egipto' chullanu tsandimi: Umaa ñulla bain, naa ñulla' tu bain faraónchi deeve, iya ñullanu yachi de-ati'kañu' mitya. Enu wajnutsumi kiya entsanave; wajdei. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tsaaren bui tinbu tiyanmala kamiya, man pela vele', faraónnu bain ma pela kuwa kuwakidei. Tsenmala taapai pela laramulaya ñuichi wajkentsumi bain, ñuichi bain, ñulla' kaillachi bain, tsenmin kumuinchi ñulla' yasha chumulachi bain finutsumi junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tsenñu yala pakatu tsandila: Ñuya lalanu tenbitya' la'ka' livee keñu' mitya, challa faraónchi tiba kiikemu chachi deeyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","José entsanguitaa kumuinchi Egipto' chullanu yala' taawashanu bui tinbu janmala kamiya, man pela vele' ma pela tsumuya faraónnu kuwa kuwakenu shuikemi kumuinchi Egipto' chullanu. Tsenñu naa entsa piikenu uwanu bain Egiptobi juntsa uudenren jumi. Tsaaren pajtanu dyus kure' balenguumishtimu rukulaya tsanguindyula, yala' tuya faraónchi tiyaindyuwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tsejtu jumaa tinbunu Jacob' bulula Egiptobi dechu', tu bain deka', Gosen tusha chumu detiya', junu pure' seraila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob Egiptobi 17 añu chumi. Tsejtu kumuinchibi 147 añu chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tsejtu ma malu Israel peyanundiyandu, ya' na Josénu mika' patu tsandimi: Ñuchi uwain iya ura' katawamuwaañuya, iya ñunu tyee kisa ti' pa'ñu bain, ñu' tyaapa in enbu pandainsha ta'pu' taditu, uwain tsanguenbera kenu tsuyu tide. Tsantsaya inu Egiptosha mentyukai. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Iya enu Egiptonu peyanmala mandake' miitu, in apala' mennainshaa menjikai, timi. Tsandiñu José: Tsanguenu tsuyu, tikami ya' apanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tsenñu ya' apa manbatu: ¡Diosnu paka' uwain tsanguenbera kenu tsuyu, tika! timi. Tsenñu José: Diosnu paka' uwain tsanguenbera kenu tsuyu, tiñu, ya' apa Israel ya' tsunjuusharen mishu wayuke' Diosnu aawa kure' keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tsai' depuitu, bene José ya' apa dilu tsuve detiñu mijatu, ya' apa' junga ya' kaillanu miya' jimi Manasésnu bain, Efraínnu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tsenñu ya' apa Jacobnu, José ja' keeve detiñu mijatu, Israel deela' chunu jutyuren deengue' kujpa' chumi ya' tsunjuunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Tsejtu Josénu tsandimi: Luz tinu pebulubi Canaán tusha, tiba kekaanuu jumu Dios inu katawatu mika yachi ura' ikaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","tsandiwa: Iya ñunu na pure' seenguikaakenu tsuyu, tsenmala ñunu sera' jimulaa vee vee bulu chachi tiyanu detsuve. Tsenmin entsa tu ñullanu kuwanu tsuyu naa-uwanuba ñuichi junutsu, tiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tsanditu, Jacob entsandimi: Iya kayu ñu' junga Egiptosha jaindyu nakayamu nala Efraín bain, Manasés bain, juntsala in na juu kuranu detsuve, matyu Rubén, Simeónba in na jutu naadejuñuba juntsaanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tsa' mitya vera na mangayamulaa ñuchi junu detsuve. Tsaaren juntsa bene faamula, entsa pai kaillachi naatala jumulaya, yai bain bene juntsala' mityaren inchi tyeeba tadiyanuu junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Iya Padán-aram tusha pu' Canaán tusha miintsu, ñu' ama Raquel, matyu Efrata pebulu maangumakaantsu ma peyaimuwaave. Tsejtu challa Efrata tityumee Belén pebulu tiitinu jinu miñusha menmuwaayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tsandinduren Israel José' kaillanu katatu tsandimi: ¿Entsala mujtuden? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Tsenñu José pakatu tsandimi: Entsalaa Dios inu enu Egiptonu miyandikaañu kailla deeve, timi. Tsenñu ya' apa tsandimi: Tsantsaya in junga kayu kalen eekide yalanu; Dios ura' de-ikaasa ti' pa'nu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel pure' rukuuñu, ya' kapuka bain yumaa katatyu tiyaintsula. Tsejtu narake katatyu juñu, José ya' kaillanu ya' apa' junga kalen de-eemi, tsenñu ya' apa kaillanu esti' tsaa amanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Tsejtu bene Josénu tsandimi: Iya yumaa ñunu mangatanu pensajtuwaayu, tsaanuren Diosya manen mangatakaave, tsenmin ñu' kaillanu bain katakaaminguive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tsenñu José ya' apa' enbu kejtala depuren ya' kaillanu manga', ya' apa' ajuunu teedi', ya' llashkapa tusha tyuikanbera waikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Tsejtu bene ya' pai kaillanu mangatu, Efraínnaa urandyachi ka', Manasésnaa jalandyachi kakemi, tsangue' ya' apa' junga kalen manda'mi. Tsanguiñu Efraínya Israel' jalandyasha tiyanmala, Manasésya Israel' urandyasha tiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tsenñuren Israel ya' tyaapa us-eetu, Efraín' mishushaa ya' urandyaapa llai'kaami, matyu kayi nanu, tsenmin ya' jalandyaapaa Manasés' mishunu llai'kaami, naa yaa avenjuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tsanguitu Josénu Dioschi ura' isa titu entsandimi: In apala, naa Abraham bain, Isaac bain meenguenu Dios, naa inu bain nakayañu washkemin chaiba miya' nemu Dios, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","tsenmin inu ti urajtutalaba livee kemu anjee juuñuu Diosya entsa kaillanu ura' ikaade. Tsenmin entsa kailla' mityan naa in mumunu bain, naa in apala Abrahamnu bain, Isaacnu bain demandengasa; tsenmin entsa tunu pure' sera deisa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tsenñu José jaiba ura' tyai'mi, ya' apaya Efraín' mishunaa urandyaapa llai'kaañu' mitya. Tsejtu ya' apa' tyaapanu kake', Efraín' mishunu manbajte', Manasés' mishpukanaa mallai'kaanu kemi ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","entsanditu: ¡Tsa jutyuve, apa! ¡Entsaa avenju nave! ¡Ya' mishunaa ñu' urandya tsuude! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tsenñu ya' apa tsanguindyai'tu tsandimi: ¡Iya miyu! apa, iya miyu. Naa tsaañuba, ya bain ma aa bulu chachi tiyanu tsuve. Tsaaren, ya' bennaa kayu yanu pulla tiyanu tsuve, tsenmin yanu sera' jimulaa main main ma uñichi uuden juu vee vee bulu chumu chachilla pure' serainu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tsejtu juntsa malunun Jacob yalanu Dioschi ura' de-isa ti' pa'tu, entsandimi: Israel chachillaya, ñulla' mumunaa paka', Dioschi ura' isa ti' pa'tu entsandinu detsuve: Efraínnu bain, naa Manasésnu bain Dios naakemu'ba juntsanguisa, tiitinu detsuve, timi. Entsanguitaa Israel Efraínnu ajke' na juuñungue tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tsejtu bene Josénu tsandimi: Iya yumaa penundiyantsuyu, tsaaren Diosya ñuibaren junu tsuve. Tsa' mitya ñullanu ñulla' tinbu rukula' tusha manen manda'nu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Iya ñunaa kayu ñu' naatalalanuba pullake kuwa', Amornu sera' jimu chachillanu peeniyachi bain, arkuchi bain vingue' kañu butyu kujtusha tu jumulanu ñunu main kuwantsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob kumuinchi ya' nalanu mikatu tsandimi: Kalen jaidei, tsenmala ajkesha tyee inuuñuba wainnu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","In nala, wakudidei, tsai' ñulla' apa Israel pantsu meedidei: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubén, ñaa in avenju na juve, ñaa in dera, in ajke' keñu na juve, ñaa kayu balenguramu juve, ñaa kayu pude juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tsaaren naake' daatadin tsaa pi deenchuwa juuñu ju' mitya, tichiba ajke' jumu juu kuran jutyuve, matyu inchi kama miyandinu shinbuba tsaitu, ñu' apa' tsuinsha lu', inu balejtu kuraanuu keñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón, Levíba naatala deeve; tsaaren yala' vinguenu jeruchiya na'baasa firu' kenu tirekemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","¡Yala' dus wa'di' kuinda kensha jayuuba puu mujtyuve! Yalan ajaavinu uwatalaya chachi tu'muwa deeve, tsenmin ne tsanguichuyu tya' dajtyamiya taawasha kemu wagaa nenbujkuwa wa'chuwa daaviimuwa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mika ajaatya', tsamantsangue firu' kemuwa deeñu, Diosya tsa mangaatyusa. Tsa' mitya entsa Israel chachilla' kejtsapala, iya na'baasa de-erekenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judá, ñu' naatalala ñunaa yuj urave tinu detsuve. Ñu' kundaalanu pulla', ti kendya'ba tsa tsanguenu tsuve, tsenmin ñu' naatalalaren ñu' ajuusha teedinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","¡Ñu, in na Judáya! leun kaana juuñuuve, naa-uwanu alla ka' fi' bain, tsaa palu'kake', tunu tsu' lekamu leun tsaave. ¿Maa ñunu bulla kechunga leun ju' tsun tsanamunu? ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tsenmin naa mu bain Judánu bale ruku jutyungue tirenuu dejutyuve, tsa jutyu'ba, juntsa balen rukula' tyutyan cha'li tanamu jaindyuya, ya' tyaapanu bale keengayanu tyutyan cha'li tanashu juntsa muba machi'ken dejutyuve, tsenmala naaju chachilla bain yanu meedinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Uva chitalaren ya' buru teetsure' uikaanu tsuve; tsenmin ya' jali bain binuchi tene manbipunu tsuve, ¡matyu uva puka pichi! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ya' kapukaya, binunuba kayu pulla yapijtutuve; ya' tejkuya chu'pinuba kayu pulla fibave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulónya, lamaa pi keetalaa chunu tsuve, baaku vija' u-udinu pebulu junu detsuve. Tsenmin ñu' tuya Sidón pebulu jingue bare' tse'kenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacarya bui pana' nemu dera animaa juuñuuve, pai kelu buli yangaraa juuñuu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tu naraañu kata', uu lekantsunuu katatu, yaren ya' beenbushu wayu'ka' buli pana', veelachi uuden i' taawasha kemu tiyaiñuive. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Danya balen chachi tiya', ya' chachillanu washkenu tsuve, matyu Israelnu sera' jimu masku bulu paande naadejuñuba juntsaa. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Danya fimu piñi minguelunu tsumu juuñuunu tsuve, matyu kawallunu nenbuupijpukanu fi', junu chuu jimu chachillanu lupajtemu junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡Yavé, inu livee kika tenna keenayu! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadnuya, ma aa bulu suutadu vinguenu detsuve, tsenmala yaa suutadula' beneshaa ja' kenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser' tuya anbu' fikenuu awakaakaa kenu tsuve, tsenmin reiren fikenutsumi panda keraa junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalíya mana juuñuuve, maali nejuu chumuve, tsenmin naraa kailla miyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joséya pi kelunu chi chumu jun tsaave, puka pure' iimu, tsai' naa ya' pala jumula bain veetanu tyaka' luimuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Arku tya'kemulaya tyutya', yala' tsuta tyatyu tyatyudekive, tsangue' naa-uwanuba bulla kitindetsu; ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","tsaanuren Joséya dera pejpe tave. Jacob' tsamantsa pude Dios kivetentsuñu, Israelnu deendanamu shupuka juuñuuchi, matyu Israelnu washkemu Dios kivetentsuñu, ya' arku denguijtyuna tanave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","¡Ñu' apa' Dios ñunu kivetenu tsuve, tiba kekaanuu jumu Dios ñunu mika ura' ikaanu tsuve! ¡Kai'sha selu jumuchi bain ñunu Dios ura' ikaanu tsuve! ¡Lamaa pi tainsha jumuchi bain ñunu Dios ura' ikaanu tsuve! ¡Dios ñunu pure' sera' jikaakenu tsuve! ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ñu' apa tsandi' ñunu Dioschi ura' isa ti' pakaya jumaa, naa-uwanuba tsanamu aa kuyi jumula naake Dioschi ura' ikaamu deeñuba juntsalanuba pullake Dioschi ura' isa ti' pakave. Yumaa tinbu chumu kuyila naa-uwanuba tsanangama entsa Dioschi ura' ikara pañu José' mishunu tsanamu jusa, matyu ya' naatalaatala yaa mi'ke' kayamunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamínya jelekenu ajara jeengucha juuñuuve, kepenene yachi tutamunu defi', kepenusha juntsa laramu deveemu juve, timi Jacob. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Entsalaa Israelnu 12 bulu sera' jimu chachilla deeve, tsenmin entsaaya ya' apa ya' nalanu Dioschi ura' de-isa timi, main main naake Dioschi ura' inuu dejuñuba tsanditu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Bene entsandi pami ya' nalanu: Peyanu kalenayu. Iya peyanmala inu tinbu rukula' mennanu tenasha menkai, Hetnu sera' jimu chachi Efrón rukunu ati'kañu tunu tujuru juushu junu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Entsa ati'kaya tu, Canaán tusha Macpelá jeendala Mamré bejkundala juve. Junaa in aa-apa Abraham ati'kamuwaave Efrón ruku' tunu, junu ya' bululanu ujkun mene menekenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Junaa Abrahamnu bain, ya' shinbu Saranu bain menmuwa deeve. Tsenmin junuren in apa Isaacnu bain, ya' shinbu Rebecanu bain menmuwa deeve, naa in shinbu Líanu bain junun menyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Juntsa tu bain, naa junu tujuru jumu bain Hetnu sera' jimu chachillanaa ati'kayave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tsejtu Jacob ya' nalanu entsandi depa' dyatu, ya' tsunjuusha ya' neepa manchi'lareke' peyami, tsejtu ya' tinbu rukulaba manbuudiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tsenñu José ya' apa' bulunu amangue' ware' estimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Tsejtu bene yachi taawasha kiikentsumu chachillanu, dilu ura' mandiremulanu ya' apa' bulu peten jutyungue kekaanu uudenguiñu, juntsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Tsejtu pemunu peten jutyungue tirenu 40 malu wanbimu deeñu, 40 malu ila. Tsenñu Egipto' chulla 70 malu' mitya llakingue' waala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tsejtu 70 malu puiñu, José tsandimi faraón' keetala chu' taawasha kemu chachillanu: Ñulla' ajuusha iya ura' katawamuñuya, ñulla tsantsaya in mitya faraónnu ji' padei: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","In apa penundiyandu inu Diosnu paka' tsanguenbera kenu tsuyu tikaamuwaave entsanditu: Iya peyanu kalenayu. Iya peyanmala in vijchiñu tujuubi menjika Canaán tusha, timuwaave. Tsa' mitya inu tsantsaya Canaán tusha in apanu menjinu eeka. Tsejtu maanu tsuyu, tive José, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Tsenñu faraón entsandi kuinda eemi: Tsaashu juntsaa, ji' mende. Ñu' apa naatimuwaañaa, ñu Diosnu paka' tsanguenbera kenu tsuyu timuwaa ju'ba tsanguide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tsenñu José ya' apanu mennu jiñu, kumuinchi faraón' chachilla bain, faraón' keenu mi'namu bale rukula bain, Egiptonu chumu bale rukula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Jacob' bulula bain, José' bulula bain, naa ya' naatalala bain millai jila. Tsejtu kaillanuren animaalaba Gosen tusha shuikikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tsenmin kawalluchi juyaa nemu karu jumula bain, naa kawallunu chuu nemula bain jila. Tsa' mitya Joséba pure' jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tsai' jindu Goren-ha-atad tenabi Jordán pi pajlanu deechusha dejitu, junaa wa'di' tsamantsangue llakindya' keewaala. Tsejtu José junaa kumuinchi yaba jimulaba ya' apa' mitya mandishpai malu llakingue' keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tsenñu junga Canaán tusha chumula Egipto' chullanu tsamantsangue llakinguendetsuñu katatu tsandila: Egipto' chulla cha' pemunu tsamantsangue llaki dekive, tila. Tsejtu junu Jordán pi pajlanu deechusha Abel-misraim mumu pula, Egipto' chulla llakinguenu tena titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tsejtu Jacob' nala ya' apa naati pa'muwaañu bain tsanguenu, ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Canaán tusha mandake' ji' menla, Mamré pajlanu pasha jumu Macpelá jeendala tujuunu, junaa ya' aa-apa Abraham Hetnu sera' jimu chachi Efrónnu tu ati'kamuwaañu, tsejtaa chachi depeyanmala juntsa tenanu mene menekenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bene José ya' apanu dementu Egiptosha millai miila, ya' naatalala bain, naa kumuinchi yaba menve'jimula bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jacob peyañu' mitya, José' naatalala yaitala entsandila: ¿Lalanu José ajara'ba jutuya, lala kaspele yanu naake firu' kemu deeñuba juntsangue mangui'chunga? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tsejtu ya' naatalala Josénu entsandi kuinda eela: Ñu' apa kayu peyai'mujchiren: ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Josénu entsandidei, tive: Uwain ñu' naatalala ñunu firu' ke' ujcha lamuwa deeñu bain, tsantsaya tiba firu' keñu jutyu kurede, timuwaave. Tsa' mitya lala ñu' apa' Dioschi tiba kiikemu chachilla firu' kemuwa deeñuba, tsantsaya lalanu tiba firu' kemu jutyu kurekai tenve, tila. Tsejtu juntsa kuinda wandimula tsandi' pandetsuñu, José waandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tsenñu bene ya' naatalalaren José' ajuusha deji' yala' llashkapa tusha tyuikanbera dewaike' keewaatu tsandila: Enu entsa denayu. Challa ñuchi manda-i' taawasha kemu chachi deeyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tsenñu José ya' naatalalanu tsandimi: Jeetyatyudei, iyaa Dios jutyuyu ñullanu taaju kikaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Uwain ñullaya inu juntsangue' firu' kenu pensanguemuwa deeñu bain, Diosya tsangue' ura' ne kikareke', challa naaju katandetsuñuba juntsaaya kikare' pure' chachillanu livee kikaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tsa' mitya, jeetyatyudei; iya ñulla' menestengama fikenuu kuwantsunu tsuyu, naa ñulla' kaillanu bain, timi. José tsandi' tenbitya' pañu, ya' naatalala masundyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José bain, ya' apa milla' bulula bain Egiptobi chudi' jintsumuwaala. Tsejtu José 110 añu chumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tsejtu José Efraín' tyuipañalanu bain katami. Naa Manasés' nalanu bain, naa Manasés' na Maquir' nalanu bain nejandala ka' esti estikemuwaami, ya' na juuñuu dekuretu. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bene José ma malu ya' paandelanu tsandimi: Yumaa peyanu kalenayu, tsaaren Diosya ñullanu kivete', entsa tunu mangalare' manda'nu tsuve. Tsangue' Abrahamnu bain, Isaacnu bain, naa Jacobnu bain, uwain kuwanbera kenu tsuyu tinu tusha mandajinu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tsejtu José Israelnu sera' jimulanu: Diosnu paka' tsanguenbera kenu tsuyu, tidei, titu tsandimi: Uwain Dios ñullanu la'kave'janu tsuve. Tsanditu José: Ñulla miindu in taku bain manda'dei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tsejtu José 110 añubi peyañu, peten jutyungue deke' ujkungulenu pu' tsuula Egiptobi.");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Entsalaa Jacobba Egiptobi bulu vijimu ya' nala, main main yala' bululaba jimula' mumu deeve: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén bain, Simeón bain, Leví bain, Judá bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar bain, Zabulón bain, Benjamín bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan bain, Neftalí bain, Gad bain, naa Aser bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tsejtu kumuinchibi Jacobnu sera' jimu paandela 70 chachi jula. Joséya yumaa Egiptobi chumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Bene José bain, naa ya' naatalala bain, matyu juntsa tinbunu awamulaya millai peyala, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","tsaaren Israel chachilla na pure' miyaawa de' mitya, pure' serade-i', tsamantsai pude tiya', juntsa tusha yala tene tyuwanala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Tsenñu bene, Egiptonu veraa rei mandiya' chumi, tsaaren entsa reiya Josénu kerajtuwaami, tsejtu ya' chachillanu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Keekidei, Israel chachillaa kayu pure' judeju', lalanuba pulla pude deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tsa' mitya kayu sera' jindejutyu tyeeba bibu' keñaa urave, mandinbu vinguikenuuba faañu bain, yala lala' kundaalaba debuudi', lalanu kundaa dekishu juntsaa, entsa tunu malu' miji'ba inu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tsejtaa Egipto' chulla, taawasha kikare' keenamu rukula delare', Israel chachillanu tsamantsa taaju' taawasha kekaala. Tsejtu faraón' chachillachi finutsumi bain, naa tiba meneste imu uukaanu, Pitón pebulu bain, naa Ramsés pebulu bain kekaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tsaaren yala tsangue' kayu firu' kendetsunmalaa, Israel chachillaya kayu sera' ne jiindetsuñu' mitya, Egipto' chulla tsamantsa jeetyantsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Tsejtu Egipto' chulla, Israel chachillanu manda-i' taawasha kemu juu detire', tsamantsangue dera' taawasha kikaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tsangue' taaju taawasha tene kikaakaaketu ura' chujtityuu ma juula, tu lepa tyakakaantsumi kekare'kerake, naa tu lepa kikare'kerake, tsenmin jeenbaasha kekenuu taawashanu bain yalanu tene kikaakila. Tsejtu Israel chachillanu mandangue' taawasha dekikare' tsamantsa firu' kiikentsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Tsenmin Egipto rei, hebreo chachilla' shinbulanu nakakaamulanu, matyu Sifránu bain, Puánu bain entsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Naa-uwanu hebreo cha' shinbulanu nakakare' bain ura' keekidei, tsejtu unbeena deenmalaa, tu'dei, tsaaren supu na'ma deeshu juntsaa, tu'tyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tsenñuren nakakaamu shinbulaya Diosnu balengure' jeetyatu, Egipto rei naakidei tiñuba juntsangui'tu, naa unbeena dekañu bain, tu'tyu' tsa tsangaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tsenñu Egipto rei juntsa shinbulanu mikatu: ¿Nenñaa unbeena kaillanuba tu'tyu juju deeyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tsenñu nakakaamu shinbula faraónnu pakatu: Hebreo cha' shinbulaya, Egipto cha' shinbula tsaa dejutyu', kayu dera de' mitya, nakakaamula kayu jindetyuren, nakakadekiñu' mityaa tsa deeyu, tikala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Entsaitaa Israel chachilla tsamantsa seranchi ne iindetsu', kayu pude tiya' jintsula. Tsenmin Dios naa nakakaamu shinbula bain yanu balengure' jeetyataa tsa dekiñu' mitya, yalanu pure' na miyandiwaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tsenmala faraónya kumuinchi ya' chachillanu entsandimi: Kumuinchi hebreo unbeena kayamulanuya Nilo pisha kepu' piredei, tsaaren supu na'malanuya chujtidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ma unbere, Levínu sera' jimu chachiitala supunga' chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Bene entsa shinbu navi' mangami. Tsenñu juntsa kaana naraañu, juntsa shinbu pen chu'chaya pantsuraa ma tadimi; ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","tsejturen kayu bene pantsure' tananu jutyuu tiyaitu, ñañi keraachi keñu jumu kubi main katu, ya' jurutalaya amuya keraachi bain, naa ura amuyachi bain dedikakaakemi pi vin jutyu. Tsanguetu kaananu kubinu puke', Nilo pi keesha ñañi chundala taji' ungaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tsenñu juntsa kaana' tsujki, tyee iñuba mijanu, baatala ji' keenami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Bene faraón' na'ma pisha pipenu vimi. Tsenñu yachi uuden imu pannalaya pi keetala nendetsuren, ñañi chunu pi keetala kubi kata-eetu, yachi uuden imu ma pannanu ka' taanu eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Tsenñu kubi juuke' keetu, junu ma kaana warendin punañu, faraón' na'ma kata' tenbityatu tsandimi: ¡Entsaya hebreo chachilla' kaanave! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tsenñu juntsa kaana' tsujki faraón' na'manu tsandimi: ¿Ñuchiba uranu jun, aantsa kaananu ñu' mitya washke' awakaanutsu ma hebreo cha' shinbunu mikañu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Tsenñu faraón' na'ma pakatu: Tsaaya kaide, timi. Tsenñu juntsa na'ma, juntsa kaanachi ura ya' amanaa mikaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Tsenñu faraón' na'ma tsandimi: Entsa kaananu ka' washke' awakaade, tsenmala iya ñu' tsanguiñu taawasha' mitya lushi kuwanu tsuyu, timi. Tsenñu juntsa kaana' ya' ama ka' taji' awakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tsejtu bene juntsa kaana yumaa de-awañu, ya' ama, faraón' na'manu mandaji' kuwami. Tsenñu ya' na juuñungue tiretu, Moisés mumu pumi, matyu: “Iya pishaa kalaayu”, ti' mumu putu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moisés yumaa de-aawatu, ma malu ya' bulu chachilla' junga yaaji' keemi. Tsejtu naa yala tsamantsangue dera' taawasha kendetsuñuba katami, tsaita nenu uwanu main Egipto chachi ya' bulu hebreo chachinu bandentsu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tsejtu nukaba deke-ere' mi'ketun, munuba jundala katai'tu, Egipto chachinu tsaa tuteke', ñiipesha menakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Tsejtu ayunchi bain malu' miitu, pai hebreo chachilla yaitala vinguendetsu katami, tsejtu yaitala vingue' veranu katintsumunu pake'meetu: ¿Nenñaa ñu' bulu chachinuba tsangue' katindunguiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Tsenñu juntsa hebreo chachi pakatu: ¿Tsen, maa ñunu lalanu kavitu kemu bale ruku juu detiren? ¿Tsejtu Egipto chachinu naake' tute'ba inu bain tsanguenu tenguee? timi. Tsandiñu Moisés meetu yuj jeetyami, matyu juntsa Egipto chachinu tuteñuba yumaa demijataa tsandiñuba aseetanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Tsenñu faraón nei'ba Moisés Egipto chachinu tu'ñuba mijamiren, mi'ke' tu'kaanu kemi; tsenñuren Moisés nepiya' jitu, Madián tusha chuimi. Tsai' jindu main pi pusu keesha lekanu chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Madiánsha chachilla' mitya Diosnu kalen jimu ruku Reuel, mandishpai na'ma miyami. Tsenñu jumala juntsa na'mala pususha jila animaa pi kujchinu kule keraanu pi tyuke', ya' apa' uvejalanu bain, chibulanu bain kushkaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Tsenñuren uveja washkemu rukula mantsa dejitu, junu manguetakikila juntsa na'malanu. Tsenñu Moisés junga ji' yala' mitya balelave'tu, uvejalanu bain, chibulanu bain pi dekushkaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Tsenñu juntsa na'mala yala' apa' junga demiiñu, yala' apa yalanu pake'meetu tsandimi: ¿Naa-itu deiyu uma malu ura jei maala? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Tsenñu yala pakatu: Lalanu uveja washkemula firu' dekenu keñun, main Egiptosha chumu chachee la'katu, yaren pi bain kalare', lala' uvejalanu bain, chibulanu bain dekushkaañu' mityaa tsa deiyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tsenñu Reuel tsandimi: ¿Tsen, juntsa ruku nuka naanain? ¿Nenñaa maali deshuikiyu? ¡Miji' mikaidei, ja' panda finutsu! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisés juntsaitaa Reuel' yanu chunu shuwami. Tsenñu bene Reuel ya' na'ma Séforanu, Moisésnu supungumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Tsenñu bene entsa shinbu na main kañu, Moisés, Guersón mumu pumi (hebreo palaachiya Guersón, “vee tusha chu' jamu” tinu palaaba manbarejuu ui'kangumaami), matyu: Iya juntsa vee tushaya kerajtun chachi juu nemuwaayu, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bene pure' añu pulla' jinsha, Egipto rei peyami. Tsenñuren Israel chachillaya manda-i' taawasha kemu chachi juuren dechu' taaju kendu Diosnu paka' la'kave'ka tin chula. Tsenñu Dios yanu u'tandi' depakañuba meetu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ya naa Abrahamnu bain, naa Isaacnu bain, naa Jacobnu bain naati' veta' veta' tsanguedaa timuwa ju'ba mandengatu, yala' pakayanu meengue' juntsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tsejtu Dios Israel chachillanu keetu, yala naa-in dechuñuba mijapetse kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisésya, Madián tusha chachilla' mitya Diosnu kalen jimu ruku, ya' anchapa Jetróchi uveja juula bain, chibu juula bain washkemu' mitya, ma malu tiba den chutyuin tena dapulla' jimishtitu, Diosa' kuyi tinu Horebbi jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tsenñu junu Yavé' anjee, main da'chichii kejtala, ñi unwatinsha uina' katawami. Tsenñu Moisés tejangueetu, naa juntsa da'chisha ñi llukendun, ikaindyuñuba katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tsejtu “¡Tyee indaa ne tsaatun!” tya', nejtaa da'chi ikaindyuñuba ura' mijanu tyatu, kayu kalen ji' keenu tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tsenñu Moisés ura' keenu tya' junga kalen jintsuñu, Yavé katatu, juntsa da'chibiren yanu patu: ¡Moisés! ¡Moisés! timi. Tsenñu Moisés pakatu: Enu entsanayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Tsenñu Dios tsandimi: Kalen jatyude, matyu ñu' uinashu juntsa tuya inchin juu tu juñu' mitya, ñu' sandalia kalaakide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Tsejtu kayu pa' jindu: Iyaa ñu' apa' Diosyu. Iyaa naa Abrahamchi bain, naa Isaacchi bain, naa Jacobchi bain, yala' Diosyu, timi. Tsandiñu Moisés meetu, ya' kajuru dukikemi, matyu Diosnu keenu jeetya' mitya, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","tsenñu Yavé kayu pa' jindu tsandimi: Egiptosha chumu in chachilla naa-i taaju indetsuñuba narana keenamuyu. Tsenmin yalanu taawasha kekaamula firu' dekiñu naati u'tandindetsuñu bain meemeekiyu, tsenmin yala naake taaju kendetsuñu bain iya miyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tsa' mityaa iya, Egipto chachilla' tyaapanu yalanu livee kenu pajayu. Tsangue' yalanu juntsa tunu mangalare', tsamantsa aawa, mika aa ura tusha manda'nu tsuyu, naa chu'pi bain, naa mishki bain pi ju' shilla' jin tsainu tusha, matyu Canaánnu sera' jimula bain, Hetnu sera' jimula bain, Amornu sera' jimula bain, Fereznu sera' jimula bain, Hevenu sera' jimula bain, naa Jebúsnu chumula bain, chunu tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Matyu Israel chachilla u'tandindetsuñu iya meeyu, tsenmin naa Egipto chachilla yalanu firu' kiikendetsuñu bain katayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tsa' mitya miide, ñunaa faraón' junga me-eenu tsuyu, tsenmalaa ñu Egiptobi inchi Israel chachillanu mangalaajinutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tsenñu Moisés Diosnu tsandimi: ¿Tsen iya muwa faraón' ajuusha ji', Israel chachillanu Egipto tubi mangalare' maanu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Tsenñu Dios pakatu: Iyaa ñuba bulu nenu tsuyu, tsenmin entsaa iya ñunu eeñu keewara junu tsuve: Ñu in chachillanu Egiptonu mangalaatu, entsa kuyinaa kumuinchi ñulla inu aawa kure' keewaanu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Tsenñu Moisés pakatu: Tsejtu iya Israel chachilla' junga jitu: Ñulla' tinbu rukula' Dios inu eeve, tinmala, yala tsandenna: ¿Tsen, juntsa ti mumun? detinmala, ¿iya naati pakanujtuuwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Tsenñu Dios pakatu: Iyaa juntsa jumuyu, tide. Tsenmin Israel chachillanu entsandide: Iya juntsayu timu inu ñulla' junga eeve, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Tsejtu Dios kayu Moisésnu pa' jindu tsandimi: Israel chachillanu entsa bain tsandide: Yavé, ñulla' tinbu rukula' Dios, matyu Abrahamchi bain, naa Isaacchi bain, naa Jacobchi bain Dios jumaa inu eeve, tide. Tsaju', entsaa naa-uwanuba tsanamu in mumu junu tsuve, tsenmin entsa mumunaa naa-uwanuba naa ñu' nala bain, naa ñunu bene sera' jimu paandela bain paka pakakenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Tsa' mitya ji' Israel bale rukulanu dewa'kaatu tsandide: Yavé, ñulla' tinbu rukula' Dios, matyu Abrahamchi bain, Isaacchi bain, naa Jacobchi bain jumu Dios, inu katawatu entsandive: Ñullanu keetaditu, naa ñulla Egiptobi naa-i firu' indetsuñu bain katayu, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tsenmin entsa bain tsandive: Ñulla Egiptobi taaju indetsuñuba livee kenu tsuyu. Tsangue' naa Canaánnu sera' jimula bain, Hetnu sera' jimula bain, Amornu sera' jimula bain, Fereznu sera' jimula bain, Hevenu sera' jimula bain, naa Jebúsnu chumula bain chunu tusha ta'nu tsuyu; jungaa naa chu'pi bain, naa mishki bain pi ju' shilla' jin tsainu tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Tsandinmala Israel bale rukula ñunu meenguenu detsuve; tsenmala ñu yaiba bulu Egipto reinu ji' keejitu entsandide: Yavé, hebreo chachilla' Dios, lalanu katawañu, lala' Dios Yavénu animaa tute' keewaajinu lalanu tiba den chutyuinsha pen malu neepachi jikaaka, tide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Tsaaren naa tsandiñu bain, Egipto reinu deranchi kindyuya ñullanu eren jutyuñu bain iya yumaa nara miyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tsaaren iya in pudee keeware', Egipto tusha peyainuu jumula deke' keeware' keenbashinguekaanu tsuyu, tsanguenmala faraónren ñullanu me-e'laanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Tsenmin Egipto chachillanu, ñulla miinu uwanu ura' tya' keekenuke tirenu tsuyu, tsenmalaa ñulla malu' miindu tyanjuu miji'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tsaju' supula main main ya' ya keetaa chumu supulanu bain, naa juntsalaba bulu chumu shinbulanu bain, yala' yasha lushi kenu jeruchi tyeeba keñu juula bain, naa uruchi keñu juula bain, naa naraa jali juula bain kuwaka ti' pa'dei. Tsejtu juntsachee naa ñulla unbeena kaillanu juu bain, naa supu na'malanu juu bain pandenu dejuve. Ñulla entsanguitaa, Egipto chachilla ti detañu bain, tsaa tiba dechipake' mijiinu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Tsenñu Moisés patu: Muba inu keenguen dejutyuve, naa in palaanu bain meedin dejutyuve, tsaju' inu entsandinu dejuve: Yavé ñunu katawaindyuve, tinu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Tsenñu Yavé pake'meetu: ¿Ñu' tyaapanu tyee tanayu? timi. Tsenñu Moisés pakatu: Ma tyutyan cha'llee tanayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Tsenñu Yavé: Tusha tyatyukide, timi. Tsandiñu Moisés tusha tya'kenmalan juntsa tyutyan cha'liren tsaa piñi tiyaimi. Tsenmalan Moisés jei nepiya' baka' jiimi, piñinu jeetyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Tsenñu Yavé tsandimi: Ñu' tyaapa ta-ere', ya' nepelesha kakide, timi. Tsenñu Moisés ta-ere' manganmalan, juntsa piñi tsaa tyutyan cha'li ne mandiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Entsaimiya naa Abrahamchi bain, Isaacchi bain, naa Jacobchi bain jumu, Yavé, ñulla' tinbu rukula' Dios, ñunu katawañuba keenguikaanaa entsaa juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Tsejtu Yavé kayu tsandimi: Ñu' tyaapa tenbapusha ta'pukide, timi. Tsenñu Moisés tsangue' mangalaatu ya' tyaapa manbityu bishpee tene juu, fibabaa mangalaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Tsenñu Dios tsandimi: Ñu' tyaapa manen tenbapusha manda'pukide, timi. Tsenñu Moisés tsangue' mangalaanmala, ya' tyaapa tiba jutyu' ya' bulu naaju tiba jui'ñuba juntsaa mangalaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Tsenñu bene Dios tsandimi: Tsandenna iyaa tsanguekaantsuve tyainuu jumu ajke' bijee ke' keewarachiya dekeengui'shu juntsaa, bene ke' keewarachiya keenguenu detsuve; ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","tsaaren entsa pai bijee ke' keewara jumulanun maliba dekeengui'shu juntsaa, Nilo pisha pi kalare' tunu yuutyatyukide. Tsenmala pi nei'ba tunu tyuikanmalan asa tiyainu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Tsenñu Moisés Yavénu tsandimi: Tsaaren, Bale Ruku, iya ura' shili panu mijtu unbere ju', ne challa ñu iba ñuchi manda-imu chachiba pantsuñaa tsaiba indyuyu, iya kaspeleren tsa ju', ura' shili panu mijtuwaayu. Tsenmin naa-uwanu pañu bain demu'mu' pakeyakeyaive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Tsenñu Yavé tsandimi: Tsejtu ¿maa chachillanu fi'paki kemu jun? ¿Maa mainnuya pamu tiretun, kamainnuya patyu tiremun? Tsenmin ¿maa mainnuya katamu tiretun, kamainnuya katatyu tiremu jun, naa merajtu bain tiremun? ¿Iya, Yavéya, juntsa tsanguikaamu jutyuwa? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tsa' mitya, jide, iya ñuba punu tsuyu ñu' panu uwanu, tsenmin ñu tyee panu juñu bain iyaa mijakare' tsandikaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tsenñu Moisés kayu pandu tsandimi: Tsantsaya, Bale Ruku, ¿Nenñaa veelanaa erei'tundiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tsenñu Yavé, Moisésnu ajaatyatu, tsandimi: ¿Levínu sera' jimu ruku, ñu' uñaku Aarónnu ñu miyajtuu? Yaa ura' shili pamu rukuñuba iya miyu. Tsenmin ya ñunu mami'kenu la' jantsuve, tsejtu ñunu mangatamiya mika sundyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tsa' mitya yabaa pa', naa naatinuu juñu bain dewainde; tsenmala iyaa ñulla' panu uwanu ñuibaren bulu pu', naa naakenuu dejuñu bain wandi wanditinu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Tsaju' ñaa iya juuñundi' Aarónnu panu tsuve, tsenmala Aarónya ñu naatiñuba juntsa kuinda chachillanu mawainnu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tsa' mitya entsa tyutyan cha'li ta'de; entsachee iyaa tsanguekaantsuve tyainuu jumula deke' keewaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Tsenñu Moisés ya' anchapa Jetró' yasha miitu, tsandimi: In paande chachilla chudenashu junga Egiptosha miinu tenve, naa chaiba dechuñuba mijanu, timi. Tsenñu Jetró tsandimi: Tsaaya miide, tiba jutyu ura' miide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moisés kayu Madián tusha malu' mijindyuren, Yavé yanu tsandimi: Egiptosha miide, ñunu tu'nu tyamula yumaa millai depeyave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tsenñu Moisés ya' shinbunu bain, ya' nalanu bain manga', buru jandala dechujti' Egiptosha miintsumi. Tsejtu ya' tyaapanu Diosa' pudee keewara tyutyan cha'li tajintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tsenñu Yavé tsandimi: Egiptosha jitu, faraón' ajuusha tiba juntsa keenbashiinuu jumula dekenu tirekeeshu juntsa deke' keewaade. Tsaaren iyaa, yanu meedin jutyungue tirenu tsuyu, tsenmalaa Israel chachillanu me-e'larei'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tsenmala ñuya faraónnu entsandide: Yavé entsandive: Israel chachillaa inchi ajke' na juu kurave. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Iya ñunu yumaa pa', in nanu me-e'laade tiyu inu aawa kure' keewaajinutsu; tsenñuren ñu me-erendyai'ñu' mitya, iya ñuchi ajke' unbeena kayamunu tu'nu tsuyu, tive, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Moisés ya' bululaba miñusha jindu kepe tsudi' pullantsunu tenanu, Yavé fale' katawatu Moisésnu tu'keraimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tsenñu Séfora main shupu' kuchillu katu, juntsachi ya' kaananu llu kika daakakemi; tsejtu juntsachi Moisés' neepanu ta'katu tsandimi: Uwain ñu in rukuya asa shajaakaamu rukuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tsenñu Yavé Moisésnu tu'tyu' me-eemi, matyu Séfora, ya' na' llu kika daaka' juntsachi ta'ka' mityaa, Moisésnu: In rukuya asa shajaakaamu rukuve, tiñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Tsaaren, Yavé Moisés' uñaku Aarónnu: Tiba den chutyuin tenasha ji', ñu' benna Moisésba mangatajide, timuwaami. Tsenñu Aarón jitu, Diosa' kuyi tinu Horebbi Moisésnu mangatajimi. Tsejtu junu esti', ura' chusa ti' pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Tsenñu Moisés, Aarónnu millandi kuinda kemi, yanu Yavé naatide tiñu bain, tsenmin tiba Diosyaa tsanguekaantsuve tyainuu ke' keewara jumula bain kide tiñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Tsejtu bene yala pallu, Moisés Aarónba bulu Egiptosha miitu, Israel chachilla' balelaba wa'dila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Tsejtu Moisésnu Yavé naatiñuba Aarón millandi kuinda ke', naa tiba ke' keewara jumula bain chachilla' ajuusha deke' keewaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Tsenñu chachilla keenguila. Tsejtu naa Yavé yala naa-i taaju indetsuñu bain keenañuba mijatu, Israel chachilla teedi', Yavénu aawa kure' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Tsejtu yala pallu, Moisés Aarónba, faraón' junga jitu tsandila: Israel chachilla' Dios Yavé entsandive: In chachillanu tiba den chutyuin tenasha eede, tsenmala yala junbi fandangu ke', inu aawa kure' keewaanudetsu, tive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tsenñuren faraón pakatu: Tsen, ¿Yavé maa juñaa, iya yanu meengue' Israel chachillanu me-eenu juwa? Juntsa Yavénu naa keraba jui'yu, tsenmin Israel chachillanu bain me-eren jui'yu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tsenñu yala tsandila: Hebreo chachilla' Dios lalanu fale' katawave, tsenñu' mitya lalanu tiba den chutyuin tenasha, pen malunainsha neepachi jikaasa tenve, lala' Dios Yavénu animaa tute' keewaanudetsu; tsangui'shu juntsaa lalanu naa peyacheeba, naa peeniyacheeba ke' tuten jutyuumiñu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tsenñu Egipto rei tsandimi: Moisés, Aarón, ¿ñulla nenñaa chachilla taawasha kendetsuba bulla kes nendudeiyu? ¡Miji', ñulla' taawasha mandei! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tsejtu faraón entsa bain tsandimi: Challa entsa tusha Israel chachilla puredenanmalaa, ¿ñulla yalanu taawasha ken jutyu tirenu dejuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tsanditu juntsa malunun faraón, naa taawasha kikare' keenamu rukulanu bain, naa kaa balelanu bain entsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Israel chachillanu kaspeleya yala tu lepa kenudetsu ejke jaki kuwa kuwakemu deju'ba, umaa mangutyudei. ¡Yalaren ejke jaki demi'kiisa! ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","¡Tsenmin kaspele naake tu lepa kiikemuwa deeñuba tsa tsangue kikaantsu', maliba faata kikaatyudei! Yala yuj landyamu de' mitya detive: ¡Lala' Diosnu animaa tute' keewaajisai! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tsaañu' mitya juntsa chachillanu kayu daran taawasha ne kikaakidei; tsenmalaa naa-uwanuba taawasha kidyatyu', juntsa anbuda palaanu meedi'nudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Tsenñu taawasha kikare' keenamu rukula bain, naa kaa balela bain defale' ji' kumuinchi chachillanu entsandita jila: Faraón ñullanu ejke tape mangutyudei, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Tsa' mitya challa ñullaren nuka juntsa tape tsuñuba ji' mi'ke' ka' taanu dejuve. Tsaaren ñulla tsanguenu deju' mityaa jayun kikenu dejutyu', kaspele naakemuwa deju' bain juntsangue tu lepa kentsunu dejuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tsenñu Israel chachilla kumuinchi Egipto tusha na'baasa devela' jiila, buikiya ejke tape mi'kenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tsaaren, taawasha kekare' keenamu rukula entsandiitila: Kaspele ñullanu ejke tape dekuñu, naake tu lepa kiikemu deju' bain, malumere juntsangue kiikidei, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Tsejtu faraónchi taawasha kikare' keenamu rukula, kaa bale tira' washna' keekeenamu Israel chachillanu bandentsula entsa entsanditu: ¿Nejtaa uma bain, naa kishi bain ñulla kaspele tu lepa naake kiikemu deju'ba juntsangue mantyu juju deeyu? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Tsenñu kaa bale pumu Israel chachilla faraón' junga ajaa ti' wainnu jitu tsandila: ¿Nenñaa ñuchi manda-imu chachillanuba entsanguendunguiyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Lalanu naa ejke tapeba mangutyumujchiren, kaspele tu lepa naake seran kiikemu deeñu bain juntsangue manbake manbake dekive, tsenmin lalanu naa ta'kenchi bain kiidekive. Tsaju' ejke tape mangutyu' mitya entsaya ñu' chachilla' kuipave, tsaanuren lalanaa kuipa pu' ta'kindetsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tsenñuren faraón entsandi pakami: Ñulla yuj landyamu de' mitya detive: ¡Yavénu animaa tute' keewaajisai! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡Tsa' mitya jei taawasha manjidei! Naa ejke tape demangutyuñu bain, kaspele tu lepa naake seran kemu deju'ba juntsangue kiikenu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Tsenñu Israel chachi kaa bale pumula naaken tsandyala, kaspele tu lepa naake seran kemu deju'ba chai bain juntsangue seran kentsunu dejuve tiñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Tsejtu yala faraónba dekuindake' malutu, Moisésnu bain Aarónnu bain katala, yalanu washidena. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Tsejtu tsandila: Ñulla tyee dekiñuba Yavé juntsan mitya taaju puitesa, matyu naa lalanu faraón bain, naa bale chachilla bain na'baasa dekiñuba ñullaa kuipa de' mitya. Ñullaren yala' tyaapanu peeniya chungaapukeñuu dekive lalanu tu'nudetsu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tsenñu Moisés, Yavéba kuinda ketu tsandimi: Bale Ruku, ¿nenñaa entsa chachillanu firu' taaju kekaandunguiyu? ¿Tyeenguenaa inu jakaatunguiyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Naamaa iya, ñu' mitya ti' faraónnu pañuba, juntsa ajkeshaya ñu' chachillanu kayu firu' ke' ne jiintsuve, tsenñuren ñuya tibanguindyuve yalanu livee kenu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Tsenñu Yavé Moisésnu pakatu: Iya faraónnu naakenu juñuba umaa katanu tsuve, matyu yanu deranchi kenmalaa ya' tunu me-e'laanuu ju' mitya; tsenmin juntsaren jujutyu', yaren ñullanu miidei ti' me-e'laranchi kikenu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dios Moisésnu manbatu tsandimi: Iyaa Yavéyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Iyaa Abrahamnu bain, Isaacnu bain, naa Jacobnu bain katawatu, tiba kekaanuu jumu Dios juuya katawamuyu, tsaaren Yavé mumu juuchiya yalanu katawaindyuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Tsenmin yaiba veta' veta' entsanguedaa ti' payu, Canaán tu yalanu kuwanbera kenu tsuyu ti' pawayu, yala kaspele ma bijee vee tusha chumu chachi juu dechunu tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Tsenmin Israel chachillanu Egipto' chulla deranchi taawasha kikaandetsuñu, yaichi manda-i' taawasha kendu u'tandindetsuñu meeyu, tsejtu iya yaiba veta' veta' tyee kenu pamu ju'ba mandengayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Tsa' mitya Israel chachillanu entsandiide: Iya, Yavé, naa challa ñulla manda-i' taawasha kemu chachi deju', Egipto' chullachi tsamantsa taaju taawasha kendetsuñu bain, tsa manguen chun jutyu livee kenu tsuyu. Umaa in pudee keewaanu tsuyu, naake deechu' kemu ju'ba tsangue' ñullanu livee ke' mangatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Tsanguetu ñullanu in chachi tire', iyaa ñulla' Dios junu tsuyu. Tsenmalaa mijanu detsuve naa iya, Yavé, ñulla' Dios, ñulla Egipto' chullachi tsamantsa taaju' taawasha kikarandetsuba livee kemu juñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Tsenmin naa Abrahamnu bain, naa Isaacnu bain, naa Jacobnu bain kuwanbera kenu tsuyu tinu tusha tajinu tsuyu. Tsangue' juntsa tu ñullanu kuwanu tsuyu. Iyaa Yavéyu, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Tsenñu Moisés kumuinchi tsandi manbami Israel chachillanu, tsenñuren yala meengui'la, manda-i' taawasha ke', tsamantsa taaju' kendu ti ken tsandyandetsu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Tsenñu Yavé, Moisésnu patu: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Egipto reinu, tsandityu'ba faraónnu, Israel chachillanu Egipto tunu me-e'lare' me-eede, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tsenñu Moisés Yavénu pakatu: Naa Israel chachillaba inu meenguindetyuba, ¿nejtaa kayu faraónya inu meenguenu jun, ka iyaa ura' shili panu ma mijtuunuba? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tsenñuren Yavé, Moisésnu bain, Aarónnu bain patu, Israel chachillanu bain, faraónnu bain wainnu eemi, tsenmalaa Egipto tunu Israel chachilla malunudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Entsalaa ya' apala keñu desera' ji' bale chachi tiyamula deeve. Israelchi ajke' na, Rubénchi ya' nalaya: Hanoc bain, Falú bain, Hesrón bain, tsenmin Carmí bain. Tsaju' entsalaa Rubénnu sera' jimu bulu paande deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeón' nalaya: Jemuel bain, Jamín bain, Óhad bain, Jaquín bain, Sóhar bain, tsenmin Saúl bain. Tsaaren Saúlya Canaánnu sera' jimu shinbu' nawaami. Tsaju' entsalaa Simeónnu sera' jimu bulu paande deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leví' nalaya: Guersón bain, Quehat bain, tsenmin Merarí bain. Levíya 137 añu chumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Guersón' nala, yala naa-i dekaya' jiñuba juntsanguiñuya: Libní bain, Simí bain, naa yalanu sera' jimula bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Quehat' nalaya: Amram bain, Ishar bain, Hebrón bain, tsenmin Uziel bain. Quehat 133 añu chumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarí' nalaya: Mahli bain, tsenmin Musí bain. Tsaju' entsalaa Levínu sera' jimu paande deeve, naa-i dekayañuba tsa tsangue kiñuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramya ya' uñuku Jocabednu ka' chumi, tsenñaa Aarónnu bain, Moisésnu bain nakami. Amram 137 añu chumuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ishar' nalaya: Coré bain, Néfeg bain, tsenmin Zicrí bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziel' nalaya: Misael bain, Elsafán bain, tsenmin Sitrí bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarónya, Aminadab' na'ma Elisebanaa ka' chumi, Nahasón' tsujkinu. Entsa shinbu' nalaya: Nadab bain, Abihú bain, Eleazar bain, tsenmin Itamar bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Tsenmala Coré' nalaya: Asir bain, Elcaná bain, tsenmin Abiasaf bain. Tsaju' entsalaa Corénu sera' jimu bulu paande deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aarón' na Eleazarya, Futiel' na'manu ka' chumi. Tsenñaa Fineesnu nakami. Tsaju' entsalaa Levínu sera' jimu bulu paande deeve, matyu bale ruku tiyamula, yala naa-i desera' jiñuba tsa tsangue mi'ñuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Tsaju' entsa Aarónnaa, tsenmin entsa Moisésnaa, Yavé pa' Israel chachillanu Egiptonu mangalare', suutadulaaba dejuñu ma bululu uyun tsaa demiya' miji', vee mujtu manda'dei, tinu jumula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Tsenmin entsa Aarón, Moisésbaa, faraónba kuinda kemuwaala, Egiptonu Israel chachillanu mangalaanu titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Yavé, Moisésba Egiptobi naamaa kuinda ke'ba juntsa malunu ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","entsandimi: Iyaa Yavéyu. Iya ñunu naati papatiñuba faraónnu juntsandi manbade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tsenñuren Moisés Yavénu pakatu: Tsaaren iyaa ura' shili panu mijtuyu. Tsaanuba, ¿nejtaa faraón inu meenguenu jun? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Tsenñu Moisésnu Yavé patu tsandimi: Ñunu in mityaa faraón' ajuusha tyeeba kikaanu tsuyu, tsenmala ñu' uñaku Aarónya ñu' mitya panu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tsaju' iya ñunu tyee pade tiñuba juntsaa Aarónnu ñu dewainmu junu tsuve, tsenmala Aarónya faraónba panu tsuve, Israel chachillanu ya' tunu me-e'laade titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tsaaren iya faraónnu jaiba meedin jutyungue tirenu tsuyu, tsejtaa iyaa tsanguekaantsuve tyainuu bain, keenbashiinuu ke' keewara bain Egiptonu pure' kikenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Tsenñuren faraón ñullanu jaiba meenguen jutyuve, tsaaren iyaa in pudeechi Egiptonu tituba deke' keeware', naake deechu' kemu ju'ba tsangue deke', in chachillanu suutadulaaba dejuñu ma bululu uyun tsaa junu mangalaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Tsejtu iya tsangue' Egiptonu in pudee keeware', junu Israel chachillanu mangalarenmalaya, uwain iyaa Yavé juñuba Egipto' chulla mijanu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Tsenñu Moisés Aarónba, Yavé naakide tiñuba kumuinchi tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Juntsa tinbutala Moisés 80 añu juuwaami, tsenmala Aarónya 83 añu juuwaami, faraónba kuinda kenu tinbunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yavé, Moisésnu bain, Aarónnu bain tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Tsandenna, faraón, ñullanu tyeeba kata' kerajtunu juu ke' keewaaka tinmalaya, ñu Aarónnu: Ñu' tyutyan cha'li ka', faraón' ajuusha tyatyukide, tide, tsenmalan uu jeetyanuu piñi tiyainu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tsenñu Moisés, Aarónba faraón' junga jitu, Yavé yalanu tyee kide tiñuba tsanguetu, faraón, ya' bale chachillaba punu ajuusha Aarón tyutyan cha'li tusha tyatyukemi, tsenmalan tsaa uu jeetyanuu piñi tiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Tsenñu faraón bain ya' mirukulanu demikañu, yai bain yala' pudeechi tsaren kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tsejtu yai bain main main yala' tyutyan cha'li tusha detya'kiñu, yaichi bain main main uu jeetyanuu piñi tiyaila. Tsenñuren Aarón' tyutyan cha'li piñi tiyamuya juntsa mirukula' tyutyan cha'li piñi tiyamulanu tsaa defikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Juntsaiñu keenaturen faraón meedin jutyuu jutu, jaiba meengui'mi, matyu Yavé naatiñuba juntsaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Bene Moisésnu Yavé tsandimi: Faraón meenguityu tiyaitu, Israel chachillanu jaiba me-eenu tyatyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tsaaren ayu kepenene ñu yanu keejitu, piñi tiyamu tyutyan cha'li bain tajide. Tsejtu yanu pi keeshaa keena' ya pisha vinmala ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","junu entsandide: Yavé, hebreo chachilla' Dios, inu eeve ñunu entsandinu: In chachillanu tiba den chutyuin tenasha eede, tsenmala yala deji', inu aawa kure' keewaanudetsu. Tsenñuren ñuya chaiba meenguindyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tsenñu' mitya Yavé entsandive: Ñu umaa mijanu tsuve naa iyaa uwain Yavé juñuba, tive. Tsaju', iya challa entsa in tyaapanu tanaashu juntsa tyutyan cha'lichi Nilo pinu vilinmalan pi asa tene tiyainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Tsenmala kumuinchi alla millai peyanu detsuve, tsenmin juntsa pi tsamantsa pudyunguenmala Egipto' chulla juntsa pi kushnu chiyandyanu detsuve, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Tsejtu Yavé Moisésnu tsandimi: Reinu entsa kuinda waintu, Aarónnu entsandide: Ñu' tyutyan cha'li ka', ñu' tyaapa Egipto chachilla' pinu usakide, tsanguetaa naa pisha, naa pijulasha, naa pi pususha, naa yala' uukara pitala bain, tsenmin kumuinchi pi pundalaya asa tene tirekenu, tsenmalaa chi juuchi bain, naa shupuka juuchi bain pi pukenuu ke' pi pundalaya asa tene tiyainudetsu, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tsenñu Moisés Aarónba Yavé naakide tiñuba tsanguila. Tsejtu faraón ya' bale chachillaba dekeenaren, ya' tyutyan cha'li yali', juntsachi pinu vilikemi, tsenmalan kumuinchi pi asa tene tiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tsenñu alla millai peyala. Naa pi bain tsamantsangue pudyungueñu, Egipto' chulla naake' kujchin tsaala. Tsaju' kumuinchi Egipto tusha nukaba asa tene tiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Tsaaren Egipto mirukula bain yala' pudeechi tsaren kila, tsenñu faraón meenguityu jutu, Moisésnu bain, naa Aarónnu bain meengui'mi, matyu Yavé naatiñuba juntsaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Tsejtu faraón ya' chunu yasha tsaa ne mijiimi, juntsaive tya' mijapetse ki'mujchi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tsenñu kumuinchi Egipto' chulla Nilo pi keetala pusu dekikila, ura pi kalaanu, ura pishaya naake' kujchin tsaa juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yavé Nilo pinu juntsanguiñu, yumaa mandishpai malu puiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","manen Moisésnu Yavé entsandimi: Faraónnu mangueejitu, Yavé entsandive, tide: In chachillanu me-eede, tsenmala yala ji', inu aawa kure' keewaanudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tsaaren ñu tsangui'shu juntsaa, ñu' tusha patata tene ereke' ñullanu taaju de-iwaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Pisha patata tene tyuwainu tsuve, tsejtu defale' ñu' yasha deji', naa kasnu sukusha bain, naa ñu' tsunjuusha bain, naa ñu' bale chachilla' yasha bain, naa ñu' chachilla' yasha bain, naa pan akaanu urnusha bain, naa pan bejta puntsumisha bain vinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tsaju' patatala ñu' jandaa yangue'kera, naa ñu' bale chachilla' jandaa yangue'kera, naa kumuinchi ñu' chachillanu bain yannu detsuve, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Tsejtu Yavé Moisésnu manbatu: Aarónnu ya' tyutyan cha'li, naa pisha bain, naa pijulatala bain, naa pi pusutala bain usakide, tide, tsenmala jundala patata defale' Egipto tusha tyuwai janudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tsenñu Aarón juntsanguiñu, patata pure' faledeke', Egipto tusha tyuwaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tsenñu mirukula bain yala' pudeechi tsaren ketu, yai bain Egipto tusha patata pure' mikakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tsenñu faraón, Moisésnu bain, Aarónnu bain mikatu tsandimi: Yavénu pa', naa in junga bain, naa in chachilla' junga bain patata demanbirekide, tidei, tsenmala iya ñu' chachillanu me-eenu tsuyu, animaa tute' Yavénu keewaajinudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Tsenñu Moisés faraónnu tsandimi: Tsen, ¿naamaa pasa tenguen tsenmalaa naa ñu' junga bain, naa ñu' bale chachilla' junga bain, naa ñu' chachilla' junga bain patata manbui'nudetsu, tsejtu Nilo pishan pudinudetsu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tsenñu faraón: Ayuren tsanguisa tenve, tiñu, Moisés pakatu: Uwain ñu naati pa'ñuba tsainu tsuve, tsenmalaa muba Yavé, lala' Dios tsaa dejutyuñuba ñu mijanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Tsejtu kumuinchi patata ñu' yasha bain, naa ñu' bale chachilla' yasha bain, naa ñu' chachilla' yasha bain patata demangataatyu' pishan pudinu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tsenñu Moisés, Aarónba faraón' chunu yanu demalu' miitu, bene Moisés, Yavéba kuinda ketu, faraón' junga eeñu patata deme-eesa ti' pa'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Tsenñu Moisés naati pa'ñuba Yavé juntsanguiñu, kumuinchi patatala, naa yasha bain, naa ya keetala cha' neinsha bain, naa jeenbaasha bain pumula tsaa millai peyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tsenñu chachilla patata pemula deka' wa'kaañu, nukaba pe'tyayanguintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tsaaren faraón tiba bulla jutyu mandiyaimin, Moisésnu bain, Aarónnu bain meenguindyatyui tiyami, Yavé naatiñuba juntsaitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Tsenñu Yavé, Moisésnu manbatu: Aarónnu tsandide, ya' tyutyan cha'li usake' juntsachi tu ñiyuyulanu vilikide, tide, juntsa tu ñiyuyu Egipto tusha tsaa juju tene tiyainudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tsenñu yala tsanguitu, Aarón ya' tyutyan cha'li yali' tu ñiyuyulanu vilinmalaren, kumuinchi Egipto tushaya tsaa juju tene faleke', naa chachillanu bain, naa animaalanu bain fifikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tsenñu mirukula bain yala' pudeechi juju faawaanu keturen, naaken tsaala, tsanguendetsuren chachillanu bain, naa animaalanu bain juju fifikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Juntsaiñu mirukula faraónnu tsandila: ¡Uwain entsaa Diosyaa tsanguiñuve! tila. Tsenñuren faraón meenguityu jutu, yalanu meengui'mi, matyu Yavé naajunu tsuve timuwaañuba juntsaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Tsenñu Yavé manen Moisésnu tsandimi: Dishkepenene kujpa', faraón ayu kepenene pisha vinmala ji' katawatu entsandide: Yavé entsandive: In chachillanu eede, tsenmala yala inu aawa kure' keewaajinudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tsaaren ñu yalanu mandyaike' me-eetyushu juntsaa, iya ñu' junga bain, naa ñu' bale chachilla' junga bain, naa ñu' chachilla' junga bain, naa yala' yasha bain vitutu tene eekenu tsuyu. Tsenñu kumuinchi Egipto chachilla' yatalaya vitutu pureinu detsuve, naa tutala bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tsaaren tsaa puinu uwanu Gosen tusha, in chachilla' chunu tushaya tsaa iwaanu jutyuyu, tsenmalaa ñu mijanutsu, naa iya, Yavé, entsa tunu chuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tsenmin in chachillanuya ñu' chachillaba manbarejuu taaju iwaanu jutyuyu. Tsaaren entsaya ayu malunaa tsaa i' puinu tsuve, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Tsenñu Yavé naati'ba juntsanguiñu, vitutu naa faraón' yasha bain, naa ya' chachilla' yasha bain tsaa pureila; tsejtu kumuinchi juntsa tenashaya vitutu tene tyuwaimi. Tsejtu juntsa tushaya tituba dekikentsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tsenñu faraón Moisésnu bain, Aarónnu bain mikatu tsandimi: Ñulla' Diosnu animaa tute' keewaajidei, tsaaren entsa Egipto tunuya lui'mujchin tsanguidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tsenñu Moisés tsandimi: Tsanguenu dejutyuyu, lala Yavénu kuwanu animaa judeeshu juntsalaya, Egipto' chullachiya tsangue' tu'nu animaa dejutyu', yalanu kentsure kenuu juñu, lalanu tsanguentsu dekatashu juntsaa, shupukachi tya'kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tsaañu' mityaa tiba den chutyuin tenasha pen malu neepachi jitu, jungaa lala' Dios Yavénu animaa tute' keewaanu detsuyu, ya naakesa tyañuba juntsanguetu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tsenñu faraón tsandimi: Iya ñullanu, ñulla' Dios Yavénu animaa tute' keewaanudetsu me-e'lare' eenu tsuyu tiba den chutyuin tenasha, tsaaren yuj bare' jinu dejutyuve. Tsenmin in mitya bain Diosnu pakadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Tsenñu Moisés tsandimi: Challa nei'ba enu malu' miimin Yavénu naa ñu' junga bain, naa ñu' bale chachilla' junga bain, naa ñu' chachilla' junga bain ayu malu kumuinchi juntsa vitutulanu demanbirekide tinu tsuyu, tsaaren manen ñu lalanu anbuti' tiba den chutyunu tenasha Yavénu kuwanu animaa tute' keewaajikaanu jutyu' lala' chachillanu me-eren jutyuyu tityusa tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Tsejtu Moisés faraón' yasha pu' mafaamin, Yavéba kuinda kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Tsenñu Yavé, Moisés yanu naati pa'ñuba juntsanguiñu, kumuinchi vitutu, naa faraón' junga pumula bain, naa ya' bale chachilla' junga pumula bain, naa ya' chachilla' junga pumula bain demijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Tsenñuren manen faraón meenguindyatyui tiyatu, Israel chachillanu me-eetyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Tsenñu Yavé, Moisésnu tsandimi: Faraón' junga ji' keejide, tsejtu tsandide: Yavé, hebreo chachilla' Dios, entsandive: In chachillanu mandyaike' eede inu aawa kure' keewaajinudetsu, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Entsandiñuren eetyu' ne daata daatadishu juntsaa, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Yavé ya' pudeechi, jeenbaasha pumu ñu' animaalanu tsamantsaa peya eenu tsuve, tsenñu naa kawallu, naa buru, naa kameyu, naa wagaa, naa uveja, naa chibu juula bain tsamantsai peyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Tsaaren Yavé, Israel chachilla' animaalanuya, Egipto chachilla' animaalanu naakenu ju'ba tsanguen jutyuve, tsenñu Israel chachillachiya ma animaaba peyan dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Tsejtu Yavé naamaa tsanguenu ju'ba waintu: Iya, Yavé, ayu malunaa entsa tsanguenu tsuyu, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Tsejtu ayunchi Yavé tsanguiñu kumuinchi Egipto chulla' animaalaya peyadundala, tsenñuren Israel chachilla' animaalaya maliba peyaindyula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Tsenñu faraón, Israel chachilla' junga ji' keenu eetu, uwain naa ma animaaba peyaindetyuñuba mijami. Tsejturen faraón meenguityu jutu, Israel chachillanu erei'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Tsenñu Yavé, Moisésnu bain, Aarónnu bain entsandimi: Ñinbelesha ji', tyaapachi ñijuingui kalare', faraón' ajuusha jitu, Moisés kai'sha kelaakisa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Tsenmala juntsa ñijuingui ñiyuyui tiya', kumuinchi Egiptosha tsaa dejeke' jiinu tsuve, tsejtu kumuinchi Egiptonu chumu chachillanu bain, naa yala' animaalanu bain bishpee tene iwaakenu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tsenñu Moisés, Aarónba ñinbeesha ñijuingui dekatu, faraón' junga jila. Tsejtu Moisés juntsa ñijuingui kai'sha tya'kelaanmalan, naa chachilla bain, naa animaala bain, tsaa bishpee tene iila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Tsejtu entsa bijeenuya mirukula Moisésnu vej vej kikai'la yai bain kumuinchi Egipto' chulla naadejuñu bain juntsa deju' bishpee tene jude' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tsaaren Yavé faraónnu meedin jutyungue tiwaañu, naa Moisésnu bain, naa Aarónnu bain meengui'mi, matyu Yavé, Moisésnu naajunu tsuve timuwaañuba juntsaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tsenñu Yavé Moisésnu tsandimi: Ayu dishkepenene kujpa', faraón' junga jitu, entsandide: Yavé, hebreo chachilla' Dios entsandive: In chachillanu mandyaike' eede, yala inu aawa kure' keewaanudetsu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","matyu tsangui'shu juntsaa, umaa entsa bijeenuya kumuinchi peya, naa ñunu bain, naa ñu' bale chachillanu bain, naa ñu' chachillanu bain de-eekenu tsuyu, tsenmalaa ñu mijanutsu, naa muba veelaya entsa tunu iya tsaa dechui'ñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Iya ñunu bain, naa ñu' chachillanu bain in tyaapa uske' tsamantsaa peya ere' firu keñuya yumaa millaichu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tsaanuren ñunu in pudee katasa tenñaa, tsenmin kumuinchi entsa tunu iya naaju'ba keemijakutinu tenñu' mityaa, chaiba chujti' tanayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Naa tsaañu bain, ñuya chaiba meenguindyu', in chachillanu me-erendyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tsaaren ayuya entsa uwatala isha puka tene shuwa pure' jaiñungue pajtekaanu tsuyu, tsenñu Egipto tusha naa-uwanuba tsaa ityu'ba, tsaa i' puinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tsa' mitya kumuinchi ñu' animaalanu jeenbaasha pumulanuya tiba innatyuinsha depukaade, matyu juntsa isha puka kumuinchilanu paijnu tsuve, naa chachillanu bain, naa animaalanu bain, tsejtu avindaa depu', ya juusha putyulanuya detutekenu tsuve, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Tsenñu faraón' bale chachilla mantsalaya Yavé tsandi' wainñu demija' jeetyatu, yaichi manda-i' taawasha kemu chachillanu bain, naa yala' animaalanu bain ya pandainsha tene jeke manbula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Tsenñuren mantsalaya ka anbudaa tyatu, avindaa ne tsangaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Tsenñu Yavé, Moisésnu tsandimi: Ñu' tyaapa selusha usakide, tsenmala kumuinchi Egiptosha isha puka tene shuwa keraaya naa chachillanu bain, naa animaalanu bain, naa Egipto tutala chi chumulanu bain depaijnutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tsenñu Moisés ya' tyutyan cha'li selusha usakenmalan, Yavé kuidya pakare', pi'kikaakaakemin, isha puka tene tusha shuwa pajten tsanguemi. Tsejtu kumuinchi Egipto tushaya Yavé isha puka depajtekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tsenñu dyai'mujchi naa isha puka bain, naa kuidya pidya bain isha pukaba buluu pajtya pajtyaila, tsejtu tsamantsa daran depaijtu, Egipto tushaya naa-uwanuba tsaityun umaa tsai' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tsejtu juntsa isha pukaren shuwa pajtyan tsaitu, Egipto tu jeenbaasha ti dechuñuba tsaa millangaami: naa chachillanu bain, naa animaalanu bain, naa kumuinchi tape chumulanu bain, naa chi chumulanu bain yala' ali demujkii balikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tsaaren naa Egipto tu kuraa tsa i' bain, Gosen tusha, Israel chachilla' chuinshaya, naa ma isha pukaba pajtyaindyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tsenñu faraón Moisésnu bain, Aarónnu bain janu mandanguitu tsandimi: Uwain iya ujcha layu, iyaa in chachillaba kuipa deeyu, Yavéya tiba kuipajtuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tsa' mitya Yavénu, naa kuidyanu bain, naa isha puka pajamunu bain mandyawaade ti' pa'dei; yumaa mika ikandetsuyu, tsenmala iyaa ñullanu umaa daatadityu' me-eenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Tsenñu Moisés tsandimi: Nei'ba pebulunu malu' miimin, in tyaapa uske' Yavéba kuinda kenu tsuyu. Tsenñu naa isha puka bain manbajtyan jutyuve, tsenmin kuidya bain manban jutyuve, tsenmalaa ñu mijanu tsuve naa entsa tuya Yavéchiñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tsaanuren naa ñu bain, naa ñu' bale chachilla bain chaiba Dios Yavénu jelajdetuñuba iya nara miyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tsenñu naa linu vijpala bain, naa sebada vijpala bain, tsaa millai mushala, matyu sebadaya yumaa ñi depuunmala, linuya yumaa llullu dejuularen tsaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tsenñuren trigu, sentenubaya tiba indyula, entsalaya kayu benee seepumu de' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Tsejtu Moisés, faraónba dekuindake' pebulu kapasha malutu, ya' tyaapa usake' Yavéba kuinda kemi. Tsenmalan kuidya bain, naa isha puka bain mandya', naa shuwa bain maatyui manbimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tsenñu faraón umaa naa shuwa bain, naa isha puka bain manbajatyui tiya', naa kuidya bain manbatyui tiyanmalan, manen ujcha malami, tsejtu ya bain, naa ya' bale chachilla bain meenguindyatyui tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Tsejtu faraón meenguityu jutu, Israel chachillanu me-eetyumi, matyu Yavé, Moisésnu patu, naajunu tsuve timuwaañuba juntsaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yavé, Moisésnu tsandimi: Faraónnu miji' keejide. Iya yanu bain, naa ya' bale chachillanu bain meedin jutyungue tireyu, tsejtaa yala' kejtsapala Diosyaa tsanguekaantsuve tyainuu jumula deke' keewaanu ju' mitya, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","tsenmalaa ñu bene naa ñu' nalanu bain, naa ñu' pañalanu bain, iya Egipto' chullanu naake deke' balenguutyuñu bain, naa iyaa tsanguekaantsuve tyainuu juula bain deke' keewaamuñuba ñu wandinuu junu tsuve. Tsanguenmalaa ñulla mijanu detsuve naa iyaa Yavéñu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Tsenñu Moisés, Aarónba faraón' junga ji' keetu tsandila: Hebreo chachilla' Dios Yavé entsandive: ¿Naamaa ñu in ajuusha balengurajtuyu tyanujtuuyu? In chachillanu mandyaike' eede yala inu aawa kure' keewaajinudetsu; ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","matyu tsandiñuren ñu meetyu' yalanu me-eetyushu juntsaa, ayuren ñu' tusha ishu pure' mikakenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tsenñu ishularen pureitu tsaa tu kataatyui paijnu detsuve. Tsejtu isha puka paja' demushaketyuushu juntsa jayu laramulanuya millangue finu detsuve, tsenmin kumuinchi jeenbaasha chumu chitala bain tape millangue finu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Tsenmin naa ñu' yasha bain, naa ñu' bale chachilla' yasha bain, naa kumuinchi Egipto chachilla' yatala bain tyuwainu detsuve. ¡Tsejtu naa ñu' apala bain, naa ñu' aa-apala bain chunu tinbunu naa-uwanuba tsaintsu kata' kerajtunu ju', naa chai bain tsaintsu kataatyu juuya i' puinu tsuve! timi. Tsejtu Moisés depa' dyatu, faraón' yasha putun yate' malumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tsenñu faraón' bale chachilla tsandila: ¿Naama jina entsa unbere lalanu tiba tajtungue tirenuu kentsunujtun? Tsamantsa bale ruku faraón, ¿nenñaa entsa chachillanu yala' Dios Yavénu aawa kure' keewaajinudetsu me-eetyumi? Ñuya chaiba mijaindyu'ba jumee tenve naa Egipto tuya tsaa tituba de-iintsuñuba, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tsenñu faraón, Moisésnu bain, Aarónnu bain mamikatu tsandimi: Ji' ñulla' Dios Yavénu aawa kure' keewaadei. Tsaaren mumu jinu ju' bain inu wainkai, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Tsenñu Moisés pakatu: Lalaya naa lala' kailla bain, derukuula bain, naa unbeenala bain, supu na'mala bain, millai jinu detsuyu, tsenmin naa lala' uveja, lala' chibu, naa lala' wagaa juula bain millai jinu detsuve, matyu lala Yavéchi tsamantsaa fandangu kenu deju' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tsenñu faraón tsandimi: ¡Ñulla naake firu' kenu tyandetsuñuba ma narai katawave! ¿Ka, Yavé ñullanu bulu miya' jichuve pensa dejuu, tsenmin i bain ñullanu ñu' kaillaba bulu de-eechuve pensa dejuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ne tsaindetsuyu pensaa kityudei, matyu ñulla unbee rukulan ji-i', Yavénu aawa kure' keewaadei, tsanguenu tyandetsu' mitya, timi. Tsanditu faraón, junu yalanu ajaa ke' mangalaakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tsenñu Yavé, Moisésnu entsandimi: Ñu' tyaapa Egiptosha usakide, tsenmala ishu pure' ja-i', kumuinchi entsa tu tenasha chi chumulanuya millangaanu detsuve, isha puka pajatun dekityuushu juntsa chi laramulanuya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tsenñu Moisés ya' tyutyan cha'li Egiptosha usakemi, tsenmalan Yavé pajta lainbi ishuwa juyikaañu, naa mandala bain, naa kepe bain juyitintsumi. Tsenñu ayunchi, juntsa ishuwa juyintsumuren ishu pure' tajaimi, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","tsenñu Egipto tusha tsamantsaila, matyu naa-uwanuba tsaintsu kerajtula, tsenmin naa-uwanuba tsama-intsu kataan jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Juntsaitu tsamantsai deja' dishke' naa tuba kataatyui jala, tsejtu isha puka ja' dyañu laramu chi chumulanu bain, naa finu pukalanu bain tsaa defikila. Tsanguetu Egipto tusha tape juu chumulanuya millangare', naa jeenbaasha bain, naa chitala bain lushkatataa kataamulanuya millangaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tsenñu faraón manen Moisésnu bain, Aarónnu bain jeke demamikatu tsandimi: Ñulla' Dios Yavénu bain, ñullanu bain ujcha layu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","tsaaren entsa bijee' mityaya inu ujcha demanbitsale', in mitya ñulla' Dios Yavéba kuinda kiidei, tsenmalaa entsa jelekenuu firu' peya tsantsaya lalanu manbaka' me-eenutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tsenñu Moisés faraón' yasha pu' mafaamin, Yavéba kuinda kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Tsenñu Yavé juntsa ishuwanu masmi' majuyikaakenmalan, tsaa pajta vinsha la', pajta lainsha majuyike', juntsa ishulanu Ungalala lamaasha tene detaji' kepukemi. Tsanguiñu Egiptosha naa ma ishuba mangatarai'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tsenñuren Yavé manen faraónnu meedin jutyungue tiwaañu, Israel chachillanu me-eetyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Tsenñu Yavé, Moisésnu tsandimi: Ñu' tyaapa selusha usakide, tsenmalan kumuinchi Egipto tusha dishpaijñu, tsamantsai yapijuru' tiya' ta'kakenuu tiyainu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Tsenñu Moisés ya' tyaapa kai'sha uskenmalan, kumuinchi Egipto tusha tsamantsai dishpaijmi, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","tsenñu pen malu tsaiñu, naa mu bain ya' keetala chumunu katanu jutyuu tiyaila, tsenmin naa ne kujpa' neinu bain jutyula. Tsaaren Israel chachilla' chuinshaya dishpajtyaindyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tsenñu faraón manen Moisésnu maanu mandanguitu tsandimi: Yavénu aawa kure' keewaanu jitu, naa ñulla' shinbulanu bain, ñulla' kaillanu bain ta'dei, tsaaren kumuinchi uvejalanu bain, chibulanu bain, naa wagaalanu bain enu shuikidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Tsandiñuren Moisés pakatu: Tsaaren, lala' Dios Yavéchi tute' keewaanu animaa bain, ju'ke' keewaanu animaa bain meneste jukeeñu' mitya, lalanu lala' animaalanu bain tajikaanuu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tsaju' lala' animaala bain laabaren bulu jinu detsuve. Maliiba shuwan dejutyuve, lala' Dios Yavénu aawa kure' keewaanu entsa animaalanaa mi'ke' kanu deju' mitya, tsenmin lala kayu ji'mujchiya mijdetuyu naaju animaalaa tute' ju'ke' Yavénu keewaanu deju'ba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tsenñu Yavé faraónnu meedin jutyungue tiwaañu, Israel chachillanu me-eetyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Tsenmin faraón, Moisésnu tsandimi: ¡Enu malu' miide, tsejtu jundaa inu maja' mangueejadaa; matyu uwaindiyu, ñu naama in junga maja' keeja'ba peyanbera inu tsuve! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Tsenñu Moisés pakatu: Ura' pave, naa-uwanuba ñu' ajuusha maja' mangatawan jutyuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Moisésnu Yavé patu tsandimi: Umaa entsa peyaren me-eekenu tsuyu, naa faraónnu bain, naa kumuinchi Egipto' chullanu bain. Tsejtu juntsangue' dyanmalaya, faraón ñullanu ne me-eenchin kikityu', yaren ñullanu me-eenu demajuka'laanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tsaaren challa Israel chachillanu, naa unbee rukulanu bain, naa supulanu bain yala' ya keetaa chumu chachillanu, naa uruchi tyeeba dekeñu juula bain, naa lushi kenu jeruchi tyeeba dekeñu juula bain depa'dei, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Tsejtu Yavé Egipto' chulla, Israel chachillanu ura' tyainuke tiremi. Tsenmin naa faraón' bale chachilla bain, naa kumuinchi Egipto' chulla bain, Moisésnuya tsamantsa daj rukuve kuremu jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tsenñu Moisés faraónnu entsandimi: Yavé entsandive: Kejtaa kepe iinutala kumuinchi Egipto tusha dapuinu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Tsenmala kumuinchi Egipto' chumu chachillachi, ajke' unbeenalaya peyandene inu detsuve; faraón, ñu' ajke' na peyamin, manda-i' taawasha ke' shupukachi tyeeba ili ilikemu shinbula' ajke' nabi jii peyanu detsuve. Tsenmin naa animaalachi ajke' llupu kayamula bain millai peyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kumuinchi Egipto tushaya llakindya' wati watitintsunu detsuve, matyu naa-uwanuba juntsaa ityuwaaju', naa bene bain juntsaaya ma-i'nu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tsenmin Yavé naa Egipto chachillanu bain, naa Israel chachillanu bain vera' vera' kemu juñuba ñulla mijanudetsu, Israel chachillanu juu bain, naa yala' animaalanu juu bain tyeeba iñu, ne kucha juuba patintsu meren dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Tsenmalaa kumuinchi ñu' bale chachilla inu ja' keeja' teleditu: Ñu bain, naa kumuinchi ñuba buunamu chachilla bain te' malu' miidei, tinu detsuve. Tsejtu juntsandindetyuya kayu mijin jui'yu, timi. Tsejtu Moisés, faraón' junga putu, ajara mafaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Tsenñu Moisésnu Yavé tsandimi: Faraón ñullanu jaiba meenguityuve; juntsaanmalaa iya Egiptosha kayu tiba keenbashiinuu jumula deke' keewaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Tsenñu Moisés bain, naa Aarón bain kumuinchi juntsaa tiba keenbashiinuu jumula faraón' ajuusha deke' keewaala, tsenñu Yavéren tsangue' meedin jutyungue tireñu' mitya, faraón Egiptonu me-e'lare' me-eetyumi Israel chachillanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yavé, Egipto tusha naa Moisésnu bain, Aarónnu bain kuinda ketu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Entsa chu'chayaa ñuichi kayu balengurentsumi junu tsuve, matyu entsa chu'chayaa añunu ajke' peepumu chu'chaya junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kumuinchi Israel chachillanu entsandidei: Entsa chu'chayanu paitya malu inmala, kumuinchi ñulla ma yanu bulu chumula' apameemee llupu kaa uveja, tsa jutyu'ba, ma kaa chibu kanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tsaaren juntsa bulula ka jayun judeju' juntsa animaanu millangue finu dejui'shu juntsaa, ya' ya keetala kayu kalen chumuba depa' vele' fidei, tsejtu nan chachi deju'ba tsangue veenu dejuve main main naake finu deju'ba. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Juntsa animaa ma añu juu, llupu, naraa titalaba yujkajtu junu juve; uveja jui'shu juntsaa, chibu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Tsejtu entsa chu'chayanu 14 malubi jina tananu dejuve, tsejtu juntsa malunu deyaju'kainsha kumuinchi Israel chachilla animaa tu'nu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Tsejtu juntsa animaa asa katu nunbatsa yanu juntsa animaa finu deju' bain, ya juukapanu pai cha'li uinamulanu bain, naa tin-era cha'linu bain asa munguidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Tsenmin juntsa keperen alla ñisha mi'kare' akaraaya, pujkikarentsumi putyu panba finu dejuve, tsenmin saa tapebaa finu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Naa ma petseba sanaaya fityudei, tsenmin pichi ne akaraa bain fityudei. Matyu kumuinchi animaa, naa ya' mishu bain, ya' neepa bain, naa ya' peshili juula bain kumuinchi ñisha tene mi'kara' akaraaya finu dejuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","tsenmin naa tiba ayunchi mafinu ti' laakaren dejutyuve. Tsaju' tyeeba jayu larashu juntsaa dejupekidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tsa' mitya ñulla avindaa pumu jali yumaa panaju, naa sandalia bain depuu, tsenmin naa tyutyan cha'li bain tyaapanu taaya, animaa alla jeke fidei, matyu juntsa malunuya hebreo chachilla, Egiptonu delivee-i' malu' miinu malu ju', inchi Dapulla' livee kiñu fandangu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Iya juntsa kepe Egiptosha fale' denenu tsuyu, tsejtu kumuinchi Egipto' chumu chachilla' ajke' unbeena kayamulanuya detutekenu tsuyu, naa animaalachi ajke' kaya llupu jumulanu bain tsaren kenu tsuyu, tsejtu kumuinchi Egiptosha dyus kuraa chumulanu taaju de-ikaanu tsuyu. Iya Yavéndiyu tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Juntsa asaya ñulla naaju yanaa dechuñuba junaa dechuve ti' keewaanaa junu tsuve. Tsenmalaa iya Egipto' chullanu detu'nu uwanu ñullaya maliba peyan dejutyuve, matyu iya juntsa asa mula katamiya tsaa ne dapullainu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Entsa malunaa ñulla naa-uwanuba mandenga' inchi fandangu kiikenu dejuve. Tsejtu entsaa jumulaa naa ñullanu sera' jimula bain naa-uwanuba tsa tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mandishpai malutala pan bain fintsumiya pujkikarentsumi putyu pan tene finu dejuve. Tsa' mitya ajke' malunuren ñulla' yasha pan pujkikarentsumi kepunu dejuve. Tsaanun mallee juntsa mandishpai malutalan pujkikarentsumi puu pan fishu juntsaa, Israel chachilla' kejtsapala juka'larainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tsa' mitya ajke' malunu bain, naa de-insha, mandishpai malunu bain, inchin juu wa'dinu malu kurenu dejuve. Juntsa pai malunuya ti taawashaba ken dejutyuve, matyu panda kenu taawashan kityumujchiya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Tsaju' naa-uwanuba entsa malutala tene pujkikarentsumi putyu pan fifikenu fandangu kiikenu dejuve, matyu juntsa malunaa kumuinchi ñullanu Egiptosha dechuren suutadula ma bululu uyun tsaa mangala' miimuñu' mitya. Tsejtu entsaa jumulaa naa ñullanu sera' jimula bain naa-uwanuba tsa tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Tsejtu ajke' chu'chayanu, 14 malu iñu, juntsa malunu yaju'kainsha pujkikarentsumi putyu pan fimin, juntsa chu'chayanun 21 malu tiyañu, juntsa yaju'kainsha jingue pujkikarentsumi putyu pan fintsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Juntsa mandishpai malu' mityaya ñulla' yasha pujkikaantsumi tsun jutyuve, matyu mun pujkikaraa pan fi' bain Israel chachilla' kejtsapala chun jutyu juka'laranu tsuve, naa vee tusha chumu chachi juju' bain, naa Israel chachi juju' bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tsa' mitya tiba pujkikarentsumi puuyaa fityudei. Kumuinchi ñulla' yatalaya pujkikarentsumi putyu pan tene fifikenu dejuve, naa nuka dechu' bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Tsenñu Moisés kumuinchi Israel chachilla' bale rukulanu demikatu tsandimi: Ñulla' paandemeemee llupu kaa uveja, tsa jutyu'ba chibu kaana main mi'ke' kadei, tsangue' tute' Dapulla' livee kiñu fandangu kidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Tsenmin juntsa asa shullanu kakidei, tsangue' bene isupu chi kaa ali ka', juntsa asachi ajtake', ya juukapanu cha'li uinamulanu bain, naa tin-era cha'linu bain munguidei. Tsejtu ñulla muba avindala faanu dejutyuve kayu danguindyuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tsenmalaa Yavé Egipto' chullanu tu'nu jindu, ya juukapatala pai cha'li uinamulanu bain, naa tin-era cha'linu bain asa katashu juntsaa, juntsa yanuya ne dapullainu tsuve. Tsejtaa Yavé ñulla' yashaya eepukaan jutyuve tutes nemunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Tsa' mitya naa ñui bain, naa ñullanu sera' jimula bain, naa-uwanuba tsa tsanguen chunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tsejtu ñulla, Yavé tsanguenbera kenu tsuyu ti' kuwakenu juushu juntsa tusha vi-i' bain, naa-uwanuba entsa fandangu tsa tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tsenmala ñulla' kailla pake'meetu: ¿Nenñaa entsa fandangu kemuj den? detinmalaya, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ñulla entsandi pakanu dejuve: Entsa animaanu Dapulla' livee kiñu fandanguchi tu'miya, Yavéchi ti' tu'tu dekiyu, ya Egipto' chullanu detu'nu uwanu Israel chachilla' chunu yatalaya tsaa ne dapulla-i', lala' paandelanuya livee kemuve ti' mandenganu, tinu dejuve, timi. Tsandiñu demeetu, kumuinchi chachilla teedi' Yavénu aawa kure' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Tsejtu bene miitu, Yavé naa Moisésnu bain, Aarónnu bain naatiñuba Israel chachilla juntsangue kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Tsejtu kejtaa kepe Yavé, kumuinchi Egipto' chumu chachilla' ajke' unbeena kayamulanuya detutekemi, matyu faraón' ajke' nanu tu'min, naa peesu pumula' ajke' nalanu bain detuteke', naa animaalachi llupu ajke' nalanu bain detutekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tsenñu faraón bain, naa ya' bale chachilla bain, naa kumuinchi Egipto' chulla bain juntsa kepe dekujpa', dellakindya' vishkiriila. Tsaju' Egipto' chulla' yashaya nukaba pemu tsutyuuya jutyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tsenñu juntsa keperen faraón, Moisésnu bain, Aarónnu bain mikatu tsandimi: Enu delu' ji', ñulla Israel chachilla in chachillanu ba'ke' dejisa tenve. Tsejtu Yavénu naakenu deti'ba umaa ji' juntsanguiidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tsenmin naa ñulla' uvejala bain, chibula bain, naa ñulla' wagaala bain, naa buru juula bain demanga' miidei. Tsejtu naa inu bain Dioschi ura' isa ti' pa'dei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tsejtu Egipto' chulla, Israel chachillanu te' malunu kikaala, entsa entsandindu: Te' demalui'shu juntsaa, depekeenu juve, tiitindu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tsenñu Israel chachilla naa pan kenu umaa bejtaa pumu bain kayu pujkindyuren deka', pan bejta puntsumiba tsaa yala' jalichi debaingue' nanakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Tsenmin Moisés naakidei tiñuba tsanguitu, Egipto' chullanu naa tiba uruchi keñu juula bain, naa lushi kenu jeruchi keñu juula bain, naa jali juula bain pa'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Tsenñu Yavé, Egipto' chullanu ura' tyainuke kikaañu' mitya, Israel chachilla titi depa'ñu bain tsa tsangue kuwala; tsenñaa Israel chachilla Egipto' chullanu tsaa tiba dechipake' mijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel chachilla Ramsés tunu demalu' miitu, Sucotshaa jila. Tsejtu naa supulanu bain, naa kaillanu bain mikajtu, matyu suutadu jiinuu unbee rukulanun mikaaren 600.000 ma juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tsenmin yaiba naaju chachilla bain pure' mijiila, tsenmin naa uveja juula bain, chibu juula bain, naa wagaa juula bain, naa vee animaa wagaa keraala bain pure' mandakikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tsenmin yalanu Egipto' chullaren manguelarenchi ma kidekiñu, naa panda kikenuu tinbuba dekatatyu' mitya, yaichi pan kenu bejta' tsura kayu pujkindyu jumaa tajindetsu' mitya juntsaa akaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel chachilla Egiptobi 430 añu chumuwaala, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","tsejtu 430 añu chunu malu tiyañu, juntsa malunuren Yavé' ma bululu suutadu juuñuu jumula Egipto tusha millai malu' miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Juntsa kepe, Yavé yalanu Egipto tusha mangalarendu washna' keenami. Tsenñu' mityaa Israel chachillanu bene sera' jimula bain naa-uwanuba añumee juntsa kepeya keekeena' Yavénu balengure' washi washinanuu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yavé naa Moisésnu bain, Aarónnu bain entsandimi: Dapulla' livee kiñu fandanguchi entsaaya kiikenu dejuve. Israel chachi jutyulaya mu bain juntsa animaa tuta allanu finu dejutyuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","tsaaren manda-i' taawasha kemu ruku lushinchi ati'kañu chumuya finuu juve, ya bain llu kika daakaya' inchi señas juwaashu juntsaa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tsaju' vee tusha chumu chachi junu ñulla' tusha ne punbullaindu bain, naa vee chachi junu lushinchi taawasha ken chumu juu bain, juntsa animaa tuta alla finu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Tsenmin ma ya juushan fikenu dejuve, tsaju' naa ma petseba avindala talun dejutyuve, tsenmin naa ma takuba dyai-eren dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kumuinchi Israel chachilla tsaandene kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tsandenna main vee tusha chumun ñulla' junga chutu, ya bain Dapulla' livee kiñu fandangu inchi tsanguive'nu tyashu juntsaa, ya bain, naa kumuinchi ya' bulula unbee rukulaya llu kika daakanu dejuve. Tsanguishu juntsaa tsanguive'nuu tiyanu dejuve, tsejtu juntsaimiya umaa ya bain juntsa tusha nakayamu Israel chachi juuñuu tiyainu tsuve. Tsaaren mu bain llu kika daakayajtulaya animaa alla fivetenuu dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tsa' mitya naa ñuichi bain, naa vee tusha chumu ñuiba chumulachi bain, juntsa leiren junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tsenñu Israel chachilla Yavé pa' Moisésnu bain, Aarónnu bain naatiñuba juntsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Tsejtu Yavé juntsa malunuren Israel chachillanu Egipto tusha, suutadulaaba dejuñu ma bululu uyun tsaa demangalaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Moisésnu Yavé manbatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Ajke' kayamu unbeenalanuya inchin juu tene tirede, matyu naajulaba Israel chachillachi ajke' kayamu naya inchi tene judeeñu' mitya, tsenmin naa animaalachi llupu ajke' kayamu nala bain tsaren juñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Tsenñu Moisés chachillanu tsandimi: Entsa malu mandenga mandengakidei, entsa malunaa Yavé ya' pudeechi ke', ñulla Egiptonu manda-i' taawasha kemu juu dechuñun mangalaañu. Tsa' mitya entsa malunuya pujkikarentsumi puu panya fityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ñulla entsa malunu, Abib chu'chayanu, malundetsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tsejtu Yavé ñulla' tinbu rukulanu kuwanbera kenu tsuyu tinu tusha, matyu naa Canaánnu sera' jimula bain, Hetnu sera' jimula bain, Amornu sera' jimula bain, Hevenu sera' jimula bain, naa Jebúsnu chumu chachilla bain chuinsha, junga naa chu'pi bain, mishki bain pi ju' shilla' jintsainu tusha ñullanu tajinmalaya, entsa chu'chayanu fandangu kiikenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mandishpai malutala pan bain fintsumiya pujkikarentsumi putyu tene fifikenu dejuve, tsenmin mandishpai malu tiyanu malunuya Yavéchi fandangu kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tsaju' juntsa mandishpai malutala pan bain fintsumiya pujkikarentsumi putyu pan tene fifikenu dejuve. Juntsa malutalaya tiba pujkikaraa juulaya tanan dejutyuve, tsenmin pujkikaantsumi juula bain nukaba tanan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Juntsa malu chayanmala ñulla' kaillanu entsandinu dejuve: Entsanguilaya lala Egiptonu demalañu, lalanu Yavé tyee kemuwaañu bain mandenganaa tsa tsa dekiyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Tsaju' entsaa keñu jumulaa ñulla' tyaapanu, tsa jutyu'ba, llashkapanu mayiiñuu junu tsuve, tsenmalaa Yavé' leinu mandenga' papatinudetsu, matyu Yavé ya' tsamantsaa pudeechee Egiptosha depuren ñullanu mangalaañu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tsa' mitya naa-uwanu bain añumee entsaa fandangu kiikenu dejuve, tsanguenu malu janmala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Tsejtu Yavé ñunu bain, naa ñulla' tinbu rukulanu bain kuwanbera kenu tsuyu timu ju' Canaánnu sera' jimula' tusha ñullanu taji' de-eepunmalaya, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ñuichi ajke' kaya unbeenalanuya Yavéchin juu tene tirenu dejuve, tsenmin animaalanu bain ajke' kailla llupu kayamulanuya tsaren kenu dejuve, matyu juntsalaya Yavéchi tene judeeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tsaaren buru kaana ajke' kayamu llupunuya, uvejabaa, tsanguityu'ba, chibubaa vete' tute' keewaanu dejuve, tsaaren mavetei'shu juntsaa, kutu dyaityuinu dejuve. Tsenmin ñuichi ajke' unbeena kayamunu ñuichi mandirenuya, main main jumula' mitya Yavénu ufeenda kuwanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tsandenna bene ñu' kailla pake'meetu: ¿Entsa tyeenguitaa tsa dekiyu? tinmalaya, ñulla entsandi pakanu dejuve: Yavé lalanu Egipto tusha manda-i' taawasha kemu chachi juu dechuñuren, ya' pudeechi ke' mangalaamuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tsejtu faraón meedindyatyu tiya-i' lalanu me-e'laatyuñu, Yavé kumuinchi Egipto' chumu chachillachi ajke' kaya unbee nalanuya detutekive, tsenmin naa animaalachi ajke' kaya llupu jumulanu bain tsaren kemuwaave. Tsenñu' mityaa naaju animaalachiba ajke' kaya nalanuya tute', Yavénu ufeenda keewaawaa dekiyu, tsanguetaa laachi ajke' kaya nalanu livee kikeñungue' manganu, tidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Tsa' mitya entsaa keñu jumulaa ñulla' tyaapanu, tsa jutyu'ba, llashkapanu mayiiñuu ju', ñuichi mandengantsumi junu tsuve, Yavé ya' pudeechee lalanu Egiptosha depuren mangalaañu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faraón Israel chachillanu me-e'lare' eeñu, Dios Filistea tusha chumu chachilla' miñushaya miya' jindyumi, naamika juntsa miñushaa kayu deechu' ju' dape' juñu bain, tsaaren tsaamiya Israel chachilla vinguikenuuba faañu bain devinguityu' Egiptosha miinu pensa ne kikenu dejuñu' mityaa tsaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tsejtaa tiba den chutyuin tenasha yatekikaami Ungalala lamaa jinu miñusha miya' jiitu. Tsa' mitya Israel chachilla, Egiptonu demalutu, vinguenun jutyuu suutadulaaba ju' ma bululu uyun tsaaya malu' miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Tsejtu Moisés, naa José milla' ujkundaku bain demangalare' manda'mi, matyu José kayu peyai'mujchin Israelnu sera' jimu chachillanu Diosnu paka' tsanguenbera kenu detsuyu tikaatu, José entsandimuwaañu: Uwaindiyu Dios ja' ñullanu la'kanu tsuve; juntsainmala ñulla miintsumiya in ujkundaku mangalare' miidei, timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israel chachilla Sucot tunu demalu' miitu, Etam tushaa miji' kajdiila, tiba den chutyuin tena peepunubi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yavé yala' ajkesha jijiindu, mandalaya ñivish lura juunaa miñu keeware' jijiimi, tsenmala kepeya ñi lura juunaa miñu dangare' jijiimi, tsenmalaa naa mandala bain, kepe bain jinudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tsaju' naa-uwanuba yalanu baka' miityumujchi mandalaya ñivish lura juuya miya' jijiinmala, kepeya ñi lura juuya yala' ajkesha jijiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Moisésnu Yavé tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Israel chachillanu, naa-i deechu' jindu bain vera' miji' Pi-hahirot deechushaa matsujidei tide, Migdolsha pu' lamaasha jinu jin tsaindu kejtaa tenatala, matyu Baal-sefón deechutala. Tsejtu juntsa tena deechunaa yapaya dekisa lamaa pi kelunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Tsenmalaa faraón entsangue pensanguenu tsuve: Israel chachilla nuka jindu'ba mijtu ma judeetu, tiba den chutyuin tenasha dapuinu dejui'tu, na'baasa ne neindetsuve, tyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Tsaaren iya faraónnu meedin jutyungue tiware', ñullanu bendaa kikaanu tsuyu; tsanguetaa naa ya' mitya bain, naa ya' suutadula' mitya bain iya tsamantsaa ju'ba dekeewaanu tsuyu, tsenmalaa Egipto' chulla mijanu dejuve naa iyaa Yavé juñu bain, timi. Tsenñu Yavé naatiñu bain Israel chachilla juntsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tsaindetsun Egipto reinu Israel chachilla yumaa demalu' nepiya' miindetsuve ti' wainla. Tsenñu faraón bain, naa ya' balela bain jeke vera' pensa demanmin entsandila: Tsen, ¿tyeenguitaa lala Israel chachillanu me-ere', laachi taawasha ken jutyuu tiretu dekiwa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tsenmalan faraón ya' vinguenu kawalluchi ju'lla' jimu karu ura' dekikaatu, ya' suutadulanu bain demiya' jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Tsejtu Egiptonu kayu ura karu tene 600 mi'ke' kamingue', kayu kumuinchi karu jumula bain dekami; junu miya' jimu bale suutadula bain pundene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Tsaaren Yavé, faraónnu meedin jutyungue tiware', Israel chachillanu bendaa kenuke kikaami, naamika Israel chachilla depulla' sundyaa miindetsuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Faraónya kumuinchi ya' suutadulaba, naa karuchi juula bain, naa kawallunu chuu vinguemu juula bain delu' jitu, Israel chachillanu bendaa kiila, tsejtu lamaa pi keebi demi'na jila, Baal-sefón deechusha Pi-hahirot keebi, yala junu kajdi' yapaya deke' chuñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tsenñu Israel chachilla naa faraón, ya' chachillaba yala' junga yumaa jandetsuñuba mijatu yuj jeetyala, tsejtu Yavénu kemishtika ti' pakala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Tsejtu Moisésnu entsandila: Tsen ¿Egiptosha ujkun mennu tu jui'ñaa, lalanu junga mangalare' maja', engu tiba den chutyuin tenashaa detu'kaanu kendunguiyu? ¿Nenñaa lalanu entsanguetunguiyu? ¿Nenñaa lalanu Egiptosha mangalaayu? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tsaañu' mityaa lalaya ñunu Egiptobi entsa entsa detiwayu: Lalanu bulla kityuka, lalanuya Egipto' chullachi taawasha kentsunu tenve detiwayu, matyu manda-i' taawasha kiikendaa kayu uranuu juñuve, ne tsai maja', engu tiba den chutyuin tenasha peyanuu jushu juntsaa, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tsenñu Moisés pakatu tsandimi: Jeetyatyudei. Nejuudei, naaketaa Yavé lalanu livee kenu juñuba ura' keenadei, matyu ñulla uma Egipto' chullanu kataakindetsushu juntsalanu mangatan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tsa' mitya ñullaya ne juju' pensandyatyudei; Yavéya ñulla' mitya vinguenu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Tsenñu Moisésnu Yavé tsandimi: ¿Nenñaa inaa la'kave'ka ti' pakayu? ¡Israel chachillanu kayu ajkeshaa jidei tide! ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tsenmala ñuya, ñu' tyutyan cha'li yali', ñu' tyaapa usakide, tsangue' lamaanu pai pela jungue veede, tsenmala Israel chachilla ejke tenanu dapuinudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tsenmala iya Egipto' chullanu meedin jutyungue tire', ñullanu bendaa kikaanu tsuyu; tsanguetu faraón' mitya bain, ya' suutadula' mitya bain, yachi vinguenu karula' mitya bain, naa yachi kawallunu chuu vinguemu chachilla' mitya bain iya tsamantsaa ju'ba tsangue dekeewaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Juntsangue' iya faraón' mitya bain, ya' vinguenu karula' mitya bain, naa yachi kawallunu chuu vinguemu chachilla' mitya bain, iya naa tsamantsaa ju'ba keewarenmalaya, Egipto' chulla naa iyaa Yavé juñu bain mijanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Tsenñu juntsa uwanun Diosa' anjee bain, naa ñivish lura bain, Israel chachilla' ajkesha puu jimularen, tsaa yala' benesha maviila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Tsejtu juntsa ñivish luraya, Egipto' chulla benesha jandetsuñu, Israel chachillaba deba'nanu kejtala viimi. Tsejtu juntsa ñivijcha Egipto' chullachiya pababaa ju' aa dishma juu tiyaiñuba, Israel chachillachiya danjurunami. Tsa' mityaa Egipto' chulla kumuinchi juntsa kepe bain Israel chachillanu mi'diji'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tsenñu Moisés ya' tyaapa lamaasha uskemi. Tsanguiñu Yavé pajta lanu deechusha, juntsa kepe ishuwa tsamantsangue jui-eekaami, tsangue' lamaanu tsaa pai pela jungue vele' ejke tena tirekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Tsenñu Israel chachilla lamaa ejke tenanu dapuila, piren aa veeta keraa kelush kelush, main urandyasha, kamain jalandyasha vela' uyudena kejtaa pullaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Tsenñu faraón' suutadula bain bendaa jila; kumuinchi kawallunu chuu vinguenu jimula bain, naa karula bain Israel chachilla' bendaa jiintsula lamaa ejke tena kejtala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tsenñu dechandu'sha Yavé ñivish luraren, ñi lura bain jumu ñivijchasha putu, faraón' suutadulanu ke-eetu tsaa na'baasa de-ikaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tsanguetu karuu pijpukala bain demushakaakeñu, te' jinu jui'la. Tsenñu Egipto' chulla entsandila: ¡Yavé, Israel chachillabaa ju', lalanu, Egipto' chullanuya kundaa vinguentsuñu' mitya, nepiyadaa! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tsenñu Moisésnu Yavé patu tsandimi: Ñu' tyaapa lamaasha usakide, tsenmala pi demanbuudi' Egipto' chullanu, naa yala' karulanu bain, naa kawallunu chuu jimulanu bain pi tsaa dewalakenutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tsenñu Moisés lamaasha ya' tyaapa uskenmalan, dedanguinsha umaa pi naanamu ju'ba juntsai mandiyami. Tsenñu Egipto' chulla manepindun tsaa pitandala puna' tengakila. Yavé juntsanguitaa Egipto suutadulanu lamaasha dechukakaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tsejtu pi naanamu'ba juntsai manditu, Israel chachillanu bendaa kenu lamaasha vimulanu bain, naa karuulanu bain, naa kawallunu chuu vinguenu jimulanu bain, matyu kumuinchi suutadulanu dechukakaakeñu, faraón' suutadula maliba laraindyula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tsaanuren Israel chachillaya lamaa kejtalaren ejke tenanu tutu dapuiñula, piren aa veeta keraa kelush kelush main urandyasha, kamain jalandyasha vela' uyudenañu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Juntsa malunu Yavé Israel chachillanu, Egipto chulla' tyaapanu livee kemi, tsenñu Israel chachilla Egipto' chulla pipiyamulanu lamaa pi keetala pemu udena katala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tsenñu Israel chachilla, Yavé Egipto' chullanu pudeechi tiba tsamantsaa deke' keewaañu katatu, Yavénu balengure' jeetyala, tsejtu yanu keenguemu detiya', naa yachi manda-imu chachi Moisésnu bain tsaren balengure' meenguemu tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tsenñu Moisés bain, naa Israel chachilla bain Yavénu beesanguitu entsandila: Yavénu beesanguenu tenve; tsamantsaa keewara jumu tsai keengayave; naa kawallunu bain, naa kawallunu chuu vingues jimu chachillanu bain tsaa lamaasha dekepukive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yavéya inu dera kumuve; yanu iya beesanguenu tsuyu; yaa inu livee kemu tiyave; yaa in Diosve; yanu balenguunu tsuyu; yaa in apa' Diosve; yanaa aawa kurenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yavé vinguenchi tsamantsaa juve. Ya' mumuya Yavé. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Yavé faraón' karulanu bain, naa suutadulanu bain lamaasha dechukakaakive. Tsenñu miya' jimu bale suutadula tsamantsa dajka jumula Ungalala tinu lamaasha depipiya deive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tsamantsa aasha lamaaren pi tainsha pu' tadive; shupukaaba ju' chukan tsa dekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yavé, ñu' tsamantsa pude urandyaapanguive entsangue' ñunu kundaa kemulanu millangaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ñu' tsamantsaa pudeechi delandyuli keñungue' tadive, ñunu kundaa kemulanuya; ñu' ajararen ñi ju', yalanu ejke ishtapeeba dejuñu ikakaren tsanguive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ñu ajaatya' juipu-eeñu, pi yaitala dewa'di' pisundaren aa veeta juuñui uidinmala, tsamantsa aasha lamaaren pi kejtala pului deelave. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kundaa chachillaya entsa detive: Bendaa ji' mi'diitu, ti tadeeñuba dechipake' veenu detsuyu; peeniya kalare' in tyaapachi detutekenu tsuyu, detive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tsaaren Yavé, ñuya juipu-eetu, lamaa pi tainsha pukive, tsenñu pisunda paasha pulumaaba ju' chukan tsa dekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yavé, ¿naaju dyus kuramulaa ñu tsaa dejun? ¿Naajulaa ñu tsaa, tsamantsa pude, munuba pullamu, ti kike'ba tsamantsa jeetyainuu, tsenmin yuj keenbashiinuu bain kemu dejun? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ñu' tyaapa uske' pudee keewaanmala, tuya tsaa yalanu llukikive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ñuya lalanu estyamu' mitya, ñu' livee ke' manganu chachillanuya naa-i jinuu juñuba keewares jintsuve. Ñu' pudeechi ñuchin juu tenasha eepunu tajintsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Vee vee bulu i' chumu chachilla mere' dejullukenu detsuve, Filistea chachilla bain wapannu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edomsha chumu bale rukulaya tiba kenu jutyu' naaken tsai tiyanu detsuve. Tsenmala Moabsha chumu balelaya jelanchin dejullukentsunu detsuve. Tsenmala Canaánsha chumulaya pensa dajkajtu tiyainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Yavé, ñunuya tsamantsa jeetyanu dejuve, naajulaba ñunuya wapana' jelanchin shupuka juuñuu jullujtu tiyainu detsuve, ñuchi tirenu chachilla kayu pullaindetyuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yavé, ñaa yalanu kuwakenuushu juntsa kuyisha taji' chukaanu juve, ñu' chunu tena mi'ke' kakiñushu junga, ñuren ke' chujtiñu, ñu' pupunanu yapayasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yavé, ñaa naa-uwanuba rei ju' washke' jintsunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Faraónchi kawallu jumula, naa karu juula bain, naa kawallunu chuu ne' vinguemu juula bain lamaasha devinmalaren Yavé yalanu pi dewalakikaami. Tsaaren Israel chachillaya lamaa kejtalaren ejke tunu dapuila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Tsenñu Aarón' tsujki, Diosa' mitya pamu shinbu María, kaa kununu main ka' beesanguiñu, vejan shinbula bain kaa kununu dekatu, beelanguisai ya' bendala jila pakaasai jindu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","tsenñu María entsangue beesanguemi: Yavénu beesanguidei, yaa tsamantsaa ju'ba tsai keewarave, naa kawallunu bain, naa kawallunu chuu jimulanu bain lamaasha dechukakaaketu, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés Israel chachillanu Ungalala tinu lamaanu debaka' miya' jiñu, yala tiba den chutyu Sur tinu tenashaa jila, tsejtu pen malu nenduren jaiba pi katai'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tsejtu Mará tenabi dejitu, junu pumu pi kushnu jui'la, saañu' mitya. Tsenñaa junu Mará mumu pula, saave titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tsejtu junu chachilla Moisésnu vera' tya' na'baasa padundatu entsandi pake'meela: ¿Lala tyee kushnuj deewa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tsenñu Moisés, Yavénu paka' pañu, Yavé chi dape keewaami. Tsenñu Moisés juntsa chi dape ka' pisha pukenmalan pi sajtu tiyaimi. Tsejtu Yavé yala naa naaken chunuu dejuñuba mijanu ke' kere' junu lei kuwatu ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","tsandimi: Iyaa ñulla' Dios Yavéyu. Ñulla in palaa mere', iya naaju deechu' juuya kisa tyañuba tsa deke', iya naakide tiñuba demeengue', naa in lei jumula bain naatiñuba juntsanu tsangue demeenguishu juntsaa, iya kaspele Egipto' chullanu naake peya de-ere'ba ñullanuya tsanguen jutyuyu. Iyaa Yavé, ñullanu diluuñuu jutyungue ura' demandiremu juyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Tsejtu bene Israel chachilla junu putu, Elim tenasha jila. Tsenñu junu tu tainsha faamu pi tene 12 jumi, tsenmin 70 kuku chi keraa bain chula. Tsenñu junu tiba bulla jutyu kajdila kuku chi keraa faapanbeetala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kumuinchi Israel chachilla Elim tenabi demalu' miitu, tiba den chutyu Sin tenashaa jila. Entsa Sin tena, Elim tena Sinaí tenaba pensanguiñuya, kejtaa tenatala chunami. Yala Egiptonu demalu' miitu entsaba pai chu'chaya jumunu 15 malunaa jundala pula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Tsejtu junu tiba den chutyuin tenasha nendu, kumuinchi Israel chachilla Moisésnu bain, naa Aarónnu bain vera' tya' na'baasa paviikedundala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Tsejtu tsandila: Yavé lalanu Egiptoshaa peyakaañuba ne uraanuren tsanguiñuve. Jungaya ai piyama ajuusha dechu', panda fi', naa pan bain tyubanbera fifiken chumuwa deeyu, tsaanuren ñullaya entsai' tiba den chutyuin tenasha detaja', kumuinchi lalanu tsamantsa yapeware' pandachi tu'nu kendetsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tsenñu Moisésnu Yavé tsandimi: Tsaaya ñuichi selusharen pan pajtenu tsuyu. Tsenmala chachilla malumere delu' mi'ke' ka', juntsa malunu naa-i fanuu juñuba juntsaren kakenu dejuve. Entsanguitaa mijanu tsuyu, iya naakidei tiñuba tsanguemu deeñu bain, naa tsanguityu deeñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Tsaaren mandishmain malunuya ma malunu naake kamu deju'ba tsanguiñu bain, panda dekenmalaya pai malu fikenuu tiyañu katanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tsenñu Moisés bain, Aarón bain kumuinchi Israel chachillanu entsandila: Entsa kependu'kainsha ñulla mijanu dejuve, naa uwain Yavéya ñullanu Egiptosha dechuren mangalaamuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Tsejtu kepenene, Yavé' tsamantsaa keewara jumu katanu detsuve, ñulla yanu vera' tya' papadetiñuba yaa mere' mitya. Tsaaren ¿lalaya mu deewa ñulla lalanaa vera' tya' panuu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Tsejtu Moisés kayu pa' jindu tsandimi: Entsa kependu'kainsha Yavé ñullanu alla kuwanu tsuve finudetsu, tsejtu kepeneneya panya tyubanbera kuwanu tsuve, naa ñulla yanu vera' tya' papadetiñuba mere' mitya. Tsejtu ¿lala mu deewa, ñulla lalanaa tsandinuu? Ñulla entsanditu ne lalanu pabandindetyuve, Yavénaa kundaa pandetsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Tsejtu Moisés bene Aarónnu tsandimi: Kumuinchi Israel chachillanu Yavé' ajuusha dejasa tide, matyu Yavé naa yanu vera' tya' pandetsuñuba meeñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Tsejtu Aarón juntsandi' kumuinchi Israel chachillanu pantsuren, yala tiba den chutyuin tenasha ke-eetu, Yavé' tsamantsaa keewara jumu ñivijchasha faañu katala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Tsenñu Yavé Moisésnu patu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Naa Israel chachilla vera' tya' papadetiñuba meeyu. Ñu yalanu patu entsandide: Kependu'kainshaya allaa finu detsuve, tsaaren kepeneneya panyaa tyubanbera finu detsuve. Tsejtaa mijanu dejuve naa iya, Yavéya, uwain ñulla' Diosñuba, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tsenñu juntsa kependu'kainsharen kuinbichu keraa deji', yala' kajdi' yapaya deke' chuinsha tyuwai jila. Tsenmala kepeneneya pi kulili mai'chayii tiya' kataami yala' tsunchanu kelu kelu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tsejtu juntsa pi kulili deme-ejlanmalaya, tu jandala tsaa kaa paki jui ejlami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tsenñu Israel chachilla dekatatu, tyee juñuba mijdetu' mitya, yai tene patu: ¿Entsa tijtun? tiitila. Tsenñu Moisés tsandimi: Entsaa Yavé ñullanu kuwañu finutsumu panve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tsenmin ñullanu entsaa kidei tive: Main main naa naake finuu deju'ba tsa tsangue kadei, tsenmin yapayasha bain nan dechuñuba juntsalachi bain kadei. Tsa' mitya ma chachimeemee jumulachi ka' pai litru jungue kakidei, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Tsenñu Israel chachilla tsanguitu, mantsalaya kayu aa dekanmala, mantsalaya jayu jayun kakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Tsaaren litrunu demidingue' keenmalaya, naa aa kamulachi bain laraiba indyu, naa jayun kakemulachi bain faata-iiba indyumi. Matyu main main naake meneste deeñuba tsa tsai tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Tsenñu bene Moisés tsandimi: Mu bain ayunchi finu ti' laakaanu kityudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tsenñuren mantsalaya Moisés naatiñuba demeengui'tu, ayunchi finu titu jayu delaakaañu, mallu deviila, tsenmin pudyunguemi. Tsenñu Moisés juntsa chachillanu ajaatyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tsejtu kepenenemee naa naake finuu deju'ba juntsan kakila, tsenmala kai'ñu laramunuya pajta lu'min demanbi'waawaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Tsaaren mandishmain malunuya, pai malu fikenungue kala, ura pañuya ma chachimee taapai litru. Tsenñu yaatala bale pumu rukula Moisésnu tsa dekive ti' kuinda kiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Tsenñu Moisés tsandimi: Yavéren entsanguidei tive: Ayu saaduma lekanu malu ju', inu balenguunu maluve. Tsa' mitya ti akaanu deju'ba akaadei, tyee teengaanu ju'ba teengaadei, tsejtu tyee delaakare'ba ayunchi mafinu uukaadei, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Tsenñu Moisés naatiñuba juntsa dekitu, laramuya ayunchi mafinu delaakaañuren, naa mallu bain vindyu', naa pudyunguibangui'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Tsenñu Moisés tsandimi: Juntsa umaa fidei. Uma saaduma lekanu malu ju', Yavénu balengure' keewaanu maluve. Uma malunuya finutsumi avindala tiba katan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tsa' mitya mandishmain maluya panda kaji' fifikituren, mandishpai maluya saaduma lekanu maluñu' mitya, tiba katanu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tsenñuren mantsalaya mandishpai malunuren te'kanu tya', delu' mi'kituren, tiba katai'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Tsenñu Yavé, Moisésnu tsandimi: ¿Naama jina iya ñullanu naa naakidei tiñuba juntsalanu meengui'mujchi jintsunuj deeyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tengaya judei naa iya ñullanu saaduma ma maluya lekanu malu kuwañuba. Tsa' mityaa mandishmain malunuya pai malu jungue panda finu kuwayu. Tsaju' mandishpai malunuya muba yanu lu' jityu', yasha tsananu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tsenñaa mandishpai malunuya chachilla lekala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel chachilla juntsa yala' te'ka te'kakenu pandanu maná mumu pula. Juntsa fibabaa ju', silantru ñi keraami, tsenmin pan kaa paki mishkiba juuñu pingalami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Bene Moisés tsandimi: Yavé entsaaya kidei tive: pai litru maná ka' detyuketu, ñullanu sera' jimu chachillanu keewaanu uukaadei, tsenmalaa iya ñullanu Egiptosha mangalaatu, ñulla tiba den chutyuin tenasha nendetsu ti pandaa kuwamuñuba keemijanudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Tsejtu Moisés, Aarónnuya entsandimi: Aa basu ka' maná pai litruuñuba putu Yavé' ajuusha chujtiide, tsangue' ñullanu sera' jimulachi uukaanu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tsenñu Yavé Moisésnu naatimuwaañuba Aarón tsanguitu, bene juntsa aa basu, Yavé chachillanu veta' veta' tsanguedaa tiñu keewara babuusha pu' Diosa' lei pilla shupu' ta'pa ajuusha tsuumi, tsenmalaa uukaraa tsananutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Tsejtu Israel chachilla 40 añu' mitya maná panda fin chula, chachilla' chunu tusha jingama, tsandityu'ba Canaán tu kapasha tyuinajingama. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ma efa 22 litru juñu, paitya pela vele' tsuukeñunguenmalaa, ma gumer tiyamu juve, ura pañuya, pai litru.) ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kumuinchi Israel chachilla tiba den chutyu Sin tenanu putun, malu' miila, tenameemee kajdi' jijiindu, Yavé naakidei tiñuba tsa tsaitu. Tsejtu Refidim tenanu kajdiila, tsaaren junu pi putyumi yala kushnudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tsejtu Moisésnu ajaa patu tsandila: Lala pi kujchinudetsu kuwanbera kenu dejuve, ti' bulla pala. Tsenñu Moisés tsandimi: ¿Nenñaa inaa tsandi' pandu detiyu? ¿Nenñaa ne tsandi' Yavénu tyee kichunga tenna pandu detiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tsenñuren chachilla tsamantsai pi mutyandetsu' mitya, Moisésnu vera' tya' patu entsandiitila: ¿Nenñaa lalanu Egiptosha depuren mangalare' taja', naa lala' kaillanu bain, naa lala' animaalanu bain pichi detutendunguiyu? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tsenñu Moisés Yavénu tsandimi: ¿Entsa chachillanu tyee kenujtuuwa? Matyu entsa chachillaya inu shupukachi tya'kenun jutyuu judeeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Tsenñu Moisésnu Yavé tsandimi: Israel chachilla' junga jitu, junu bale ruku pumulanu mantsa ka', miya' jide, tsenmin Nilo pisha vilikisu juntsa tyutyan cha'li bain ta'de, tsejtu ajkesha jidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tsenmala iyaa junga Horeb lanba' kuyisha keenanu tsuyu. Ñu junga jitu juntsa tyutyan cha'lichi lanbakinu ma villa kide, tsenmala junu pi faanu tsuve chachilla kushnudetsu, timi. Tsenñu Moisés, Israel bale rukula dekeenaren tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Tsejtu juntsa tenanu Masá mumu pumi, Yavénu tyeeba kekaanu tya' patu: ¿Yavé laaba putun tsajuu? tiitimuwa deeñu. Tsenmin Meribá mumu bain pumi, Israel chachilla pi pa'tu ajaatya' pamuwa deeñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Israel chachilla Refidimsha depuñu, Amalec chachilla ji' vinguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tsenñu Moisés Josuénu tsandimi: Mantsa rukulanu mi'ke' ka', Amalec chachillaba vinguiide, tsenmala iyaa ayu kuyisha lu', Diosa' tyutyan cha'li in tyaapanu taa uinanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tsenñu Josué, Moisés naatiñuba meenguetu, Amalec chachillanu vinguenu lu' jimi. Tsaindetsun Moisés bain, Aarón bain, Hur bain kuyisha lula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tsejtu Moisés ya' tyaapa kai'sha ustananmalaya, Israel chachillaa pulla pullaila, tsaaren Moisés ya' tyaapa manbajtenmalaya Amalec chachillaa manbulla pullaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tsaaren Moiséschi ya' tyaapa tyuba tyubaiñu' mitya, ma shupuka ka', ya' keesha taji' detsuuñu, juntsa jandala chudiñu, Aarón, Hurba Moisés' tyaapanu kelush kelush kake' yaitadila. Juntsanguiñaa Moisés ya' tyaapa us-eraa tanami pajta dedishu' vingama. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tsanguiñaa Josué, Amalec chachillanu peeniyachi vingue' pure' tuteke' puimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Tsejtu Yavé Moisésnu tsandimi: Entsa juushu juntsa, kiikanu depiike' tsuude, bene mandenga mandengakentsumi junudetsu. Tsenmin Josuénu entsandi' narati meewaade: Amalec chachillanu muba tengan jutyungue demanbirenu tsuyu, tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Bene Moisés ufeenda tsure' ju'kenunu main ketu, “Yavé inu miya' jimu Bale Rukuve”, ti' mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Tsejtu tsandimi: Amalec chachilla Yavé' pudeenu kundaa ken mitya, Yavé Amalecnu sera' jimu chachillanu naa-uwanuba vinguentsunu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Madiánsha, chachilla' mitya Diosnu kalen jimu ruku, Moisés' anchapa Jetró mijami naa Yavé, Moisés' mitya bain, naa Israel chachilla' mitya bain titi dekiñuba, tsenmin naaketaa Egiptosha depuren yalanu mangalaañuba mijami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moisés ya' shinbu Séforanu shuike' jimuwaañu, ya' anchapa Jetró Séforanu mamika' chumuwaami, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","tsenmin ya' pai kailla jumulanu bain manga' chumuwaami. Mainnuya Guersón mumu pumuwaami, entsanditu: Iya vee tushaya kerajtun chachi juu nemuwaayu, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Tsenmala kamainnuya Eliézer mumu pumuwaami, entsanditu: Inu faraón tu'nu juñuba, in apala' Diosya livee kive, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moisés tiba den chutyuinsha, Diosa' kuyi keesha kajna' chuñu, ya' anchapa Jetró, Moisés' shinbunu bain, naa ya' pai kaillanu bain miyaa jitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Moisésnu entsandi kuinda eemi: Iya, ñu' anchapa Jetró, ñu' junga jantsuyu ñu' shinbunu bain, naa ñu' pai kaillanu bain miyaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Tsenñu Moisés ya' anchapanu tyuita'nu lutu, ya' ajuusha teledi', yanu bain estitu, bene: ¿Naaju dechuyu? ti' patu, ya' yapayasha mikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Tsejtu Moisés ya' anchapanu millangue kuinda kemi Yavé, faraónnu tyee keñu bain, tsenmin Israel chachillanu la'kave'tu, Egipto' chullanu tyee dekiñu bain, tsenmin miñutala majandetsu bain ti taaju juu dekatañuba, Yavé naake livee ke' taji tajiiñuba dewanditimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Tsenñu ya' anchapa Jetró yuj sundyami Yavéya Israel chachillanu mika ura' ke', Egipto' chulla' tyaapanu livee keñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Tsejtu Jetró tsandimi: Yavé mika ura' kiñuve, yaa Israel chachilla Egiptosha dechu', faraónchi taawasha ke' delandyullaa chumuwa deeñuba livee ketu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Tsenmin umaa mijayu naa Yavéya naaju dyus jumulanuba kayu pulla pudee tañuba, matyu firu' ken chumu chachillanuya taaju iware', yala' tyaapasha depuren, mangalare' maañu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Tsejtu bene Moisés' anchapa Jetró, animaa tute' ju'ke' Diosnu keewaami, tsenmin kayu animaa tute' Diosnu dekeewaami; tsejtu bene Aarón bain, kumuinchi Israel bale rukula bain Moisés' anchapaba panda fiila Diosa' ajuusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Juntsa ayunchi Moisés chuditu, Israel chachilla ti peletu detañuba kavitu ke' matse'kare' kuwa kuwakentsumi. Tsenñu chachilla kepenene jilan, tsaa kependu'kainsha jinbera ji' keekeenala, yaichi ura tiyanmala Moisés' ajuusha ji' panu keenatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Tsenñu ya' anchapa Jetró, Moisés chachilla' mitya naa naakentsuñuba kata' uutu tsandimi: ¿Nenñaa ñu maali juuba entsa taawasha kendunguiyu? Chachilla ñunu ja' keetu kepenene jamin, tsaa kependu'kainsha jinbera keekeedenave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Tsenñu Moisés tsandimi: Entsa chachilla in junga jamiya, Diosnu pake'meenaa tsa tsadeive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tsejtu yai tene peletu tanatu, ura' mantse'kaanu jui'taa, inu keejamu deeve, tsenmalaa iyaa ura' mantse'kaamuyu; tsejtu Diosa' lei naajuñuba keemijakare', ya naakesa tyañuba juntsa bain wandi wanditintsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tsenñu Moisés' anchapa Jetró tsandimi: Ura' kendu bain, ñu naa naakendaa mantse'kaamu juñuba juntsaa urajtaaba jumeete, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","matyu ñu bain, naa ñu' junga jamu chachilla bain tyubamin inu dejuve. Ñuchi maaliya mika tse'ken jutyuu taawasha ju', ñuchi taaju juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","In palaanu jayu meedide, ñunu ulenu tenve, tsenmala Dios bain ñunu kemishtisa. Ñuya kumuinchi chachilla' mitya, Diosa' ajuusha pupunanuuya juve, tsangue' ti depañuba juntsa peletu jumulaa Diosba kuinda ke' mijakaamu ne juude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Tsenmin chachillanu lei demijakare', naa titi minu dejuñu bain, naa naaken chunuu dejuñuba juntsala bain demijakaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tsejtu entsanguide: naajulaa Diosnu balengure', jeetya', ura' kemu deju', naajulaa jaiba anbutityu deju', naa firu' juu ke', taruku tiyanu pensa bain jutyu deeñuba, juntsaalanaa mi'ke' ka', bale chachi detirede. Tsejtu mantsalanuya 1000 chachi washkaanu bale detirede, tsenmin junun 100 chachi mavele', juntsalachi bain ma bale ruku pude, tsenmin junun 50 chachi mavele' juntsalachi bain kama bale ruku pude, tsenmin junun paitya chachi mavele', juntsalachi bain kama bale ruku pude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tsenmala yalaa malumere chachillanu kaa peletu juulanuya kavitu ke' mantse'karen chunu detsuve, tsejtu yaichi mantse'kaanu' jutyuu peletunuya ñunaa taanu detsuve. Tsanguishu juntsaa kayu jayun taaju kikentsunu tsuve, matyu yala tsanguitaa ñunu kivetentsunu dejuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ñu entsanguishu juntsaa, tsenmin ñunu Dios tsanguikaañuya, benga' tyullaiñuu ityu' jintsunu tsuve, tsenmala chachillaya yasha yuj sunden miinu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Tsenñu Moisés ya' anchapa naatiñuba meenguitu, kumuinchi juntsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Tsejtu Moisés Israel chachillanu kayu naajulaa aseetaju' kenu deeñuba juntsalanu demi'ke' ka' bale chachi detiremi. Tsanguetu mantsa 1000 chachi washnanu tiware', mantsa 100 chachi washnanu tiware', mantsa 50 washnanu tiware', mantsa paitya chachi washnanu tiwaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tsenñu yalaa naa-uwanuba chachilla ti peletu tadediñu bain kavitu ke' mantse'karen chula, tsejtu yalaya mantse'kaanu' jutyuu peletunuya Moisés' jungaa taji tajiila, tsaaren yalaren mantse'kaanuu kaa peletunuya yalaren kiikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Bene Moisés ya' anchapanu ura' chude ti' me-eeñu, ya' tusha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israel chachilla, yala ti malunaa Egiptosha demalu' miji'ba, pai chu'chaya puiñu, juntsa malunuren tiba den chutyu Sinaí tenasha tyuinajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Tsejtu Refidim tenanu demalu' miitu, tiba den chutyu Sinaí tenabi jitu, Israel chachilla junu kajdi' chula, kuyi ajuusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Tsenñu Moisés juntsa kuyinu lumi Yavéba katawanu. Tsenñu Yavé juntsa kuyisha pu', yanu paputu tsandimi: Jacobnu sera' jimu chachillanu, matyu Israel chachillanu, entsandide: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ñulla, iya Egipto' chullanu naakeñu bain dekatave, tsenmin naaketaa ñullanu engu in puinsha miya' jañu bain mideeve, ñullaa jullayu ja'chinu chudi' jan tsa deive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tsa' mitya ñulla tiba demeengue', iba veta' veta' naakenu pa'ba tsa tsanguen dechushu juntsaa, vejan chachillaba ñullaa kayu in estennu chachi junu detsuve, matyu kumuinchi tuya inchi tene juuñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Tsejtu ñullaa chachilla' mitya inu kalen jamula tene deju', inchin juu tene junu detsuve. Kumuinchi entsa palaaya Israel chachillanu dewainde, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Tsenñu Moisés miitu, Yavé yanu naatide tiñu bain bale rukulanu mika' dewainmi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Tsenñu Israel chachilla manbarejuu pakakitu: Yavé naatiñuba tiba tsanguenu detsuyu, tila. Tsenñu Moisés chachilla naadetiñu bain Yavénu tsangue mangüindakiiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yavé tsandimi: Ura' meedika, iya ñu' ajuusha ma ñivijcha yapijbuluu kejtsapalaa katawanu tsuyu, tsenmalaa iya ñuba kuinda kentsu chachilla meelaya, ñu naatiñuba naa-uwanuba keenguinu detsuve, timi. Tsejtu Moisés chachilla naadetiñuba Yavénu juntsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Tsenñu Yavé Moisésnu tsandimi: Chachilla' junga miitu, uma bain, ayu bain inchin juu demandikare', naa yala' jali bain demanbipukaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Tsaju' ma-ayu sekuwa juu keenadei, matyu ma-ayuya kumuinchi chachilla dekeenan, iya, Yavé, Sinaí kuyisha pajanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Entsa kuyi keetala señas pude, tsenmalaa juntsa señasnu pulla' ji'nudetsu. Tsenmin tsandide, juntsa kuyinu lunu kityudei, naa kalen jinu bain kityudei, tsandiñun mallee kalen dejishu juntsaa peyanbera inu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tsaaren mun señasnu dapulla' kuipa viñuba, juntsanu ne muba tyaapachi tu'nu dejutyu', shupukachi tene, tsa jutyu'ba, tsutachi tene tya'ke' tu'nu dejuve, naa chachi tsaiñu bain, naa animaa tsaiñu bain; tsaju' tutenbera kenu deju', tu'tyumujchiya tsangaanu dejutyuve. Tsaaren bene tyujtyu bare' ui'kakayaa tene meejanmalaya, chachilla kuyisha lunuu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Tsenñu Moisés manbajatu, chachillanu mijakare' sekuwanguikaami Diosnu aawa kure' keewaanudetsu. Tsenñu chachilla yala' jali demanbipuñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Moisés chachillanu tsandimi: Ma-ayu malunchiya sekuwa juu keenadei, tsenmin ñulla' supulaba tsaityudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tsenñu umaa pen malu iñu, juntsa chanu malunchi tsaa kuidya pa' pidya pidyakemi dedanguinsha, tsenñu ma ñivishbulu bain tsaa yapijbuluu viyadijami juntsa kuyinu. Tsenmin naa tyujtyu bain tsamantsa daran ui'kaya meejañu, junga kajna' chumu chachilla tsamantsai wapana' dejullukentsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Tsenñu Moisés chachillanu yala' kajdi' chununu de-e'lare' ji', Diosba katawanu jila, tsejtu kuyi lunu kujtu keesha kajdiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tsenñu Sinaí kuyisha ñivijcha lutintsumi, junaa Yavé ñi bulu juunu paja' puñu' mitya. Tsenñu ñivijcha tsamantsai luntsu', aa ñinbelenu keekiñuumi. Juntsa kuyi jumuya tsamantsanguentsu' depi'shikentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tsenmala tyujtyu pakara bain kayu daran meejaita ne jiintsumi. Tsenñu Moisés pañu, Dios pakatu, kuidya pan tsa tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Tsejtu Yavé Sinaí kuyinu kayu katyuusha paijtu, Moisésnu junga lade tiñu, Moisés junga lumi, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","tsenñu Yavé tsandimi: Manbajtya' chachillanu wainde, tsenmalaa yala señas juushu juntsanu dedapulla' inu katanu tya', tsamantsai peyai'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Tsenmin naa chachilla' mitya inu kalen jimu rukula bain inu kalen jinuya, inchin juu mandiyanu dejuve; tsa deityuñu, iya tutenmala depeyasa tendyuve, timi Yavé. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Tsenñu Moisés Yavénu pakatu: Chachillaya entsa Sinaí kuyinu lanu ken dejutyuve, matyu kuyisha puiten jutyu ti', ñuren wandi', entsandive: Kuyi keetala señas pu', inchin juu kurede, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Tsenñun Yavé tsandimi: Manbaijde; tsejtu Aarónbaa malade. Tsaaren chachilla' mitya inu kalen jimu rukula bain, naa ne chachilla bain juntsa señasnu puinu dejutyuve in punu kuyisha lanu, ne tsa deiñu yalanu tituba kenu tendyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Tsenñu Moisés mavitu, yanu Yavé naatiñuba chachillanu tsandi dewainmi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tsejtu Dios kumuinchi entsa palaaya pa' entsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Iyaa Yavé, ñulla' Diosyu; iyaa ñullanu Egiptosha dechuren mangalaamuyu, naa ñulla yaichi manda-i' taawasha kemuwa deeñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ñulla inun ma Dios juu tadeju', vee dyus juuya tajtudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Naa ti muuteba deke' chujtityu', naa selusha chumula kerake bain, naa tusha chumula kerake bain, naa tu pandainsha jumu lamaasha pumula kerake' chujtinu bain kityu', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ne juntsalanu teedi' aawa kure' keewaanu bain kityudei, matyu iyaa Yavé, ñulla' Dios ju' tsamantsa selandyamuyu. Tsejtu inu tyutyamu apalaa firu' kemu deeñuba yala' mityaren, yala' kaillanu bain, naa yala' pañalanu bain, naa yala' tyuipañalanu bain taaju depuiwaamuyu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","tsaaren mun inu estya', iya naakide tiñuba ura' meengue' tsanguemulanuya 1000 bijee sera' jinsha bain estya' ura' kemuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Naa inu, Yavénu, ñulla' Diosa' mumunu bain na'baasa pakan chutyudei, matyu naajulaa tsandi' na'baasa pakan dechuñuba, iya taaju iwaatyumujchiya puitetyu juyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Saaduma lekanu malunu tengaya jujuude, tsejtaa inchin juu malu kurenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mandishmain malu taawasha ke', titi kenuu ju'ba dekide, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","tsaaren mandishpai malunuya saaduma lekanu malu ju', inu, ñulla' Dios Yavénu balengure' keewaanu malu juve. Tsaañu' mitya juntsa malunuya ti taawashaba kityude, naa ñulla' kailla bain, naa ñuichi manda-i' taawasha kemula bain, naa ñulla' animaala bain, naa vee tusha chumu ñuiba bulu chumula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","matyu iya, Yavé, mandishmain malunaa naa selu bain, naa tu bain, naa lamaa bain, tsenmin tiba katawamu judeeshu juntsala bain deketu, saaduma mandishpai malunu lekayu. Tsejtaa iya juntsa malunu yuj ura kurave ti', inchin juu tireyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ñulla' apanu bain, ñulla' amanu bain balengure' ura' keewaadei, tsejtaa iya, ñulla' Dios Yavé, kuwanu tusha ñulla aa chu' jintsunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Chachiitala tu'tyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Vee matsaityude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Taanguityude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Anbuti' veelanu firu' kikaakenuu kityude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Veela' yanu ñuchin tsaasa tya' keetyude, naa ya' shinbunu bain ñuchin tsaasa tya' keetyude, naa yachi manda-i' taawasha kemulanu bain, naa yachi taawasha kemu wagaranu bain, naa ya' burunu bain, naa kayu vera tiba jumulanu bain ñuchin tsaasa tya' mujkeetyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kumuinchi Israel chachilla kuidya pa' pidya pidya kentsuñu bain, naa tyujtyunu daran depakaañu mera bain, naa Sinaí kuyisha tsamantsa ñivijcha jelekenguentsu bain tsana keenala, tsejtu dejeetya' mitya juntsa keesha kalen ji'mujchi baasha ne ke-eenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Tsejtu Moisésnu tsandila: Ñaa lalanu panmala ñu naatiñuba tsanguenu detsuyu, tsaaren Diosya lalanu patyusa; ya panmala depekeya'ba ikeemive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Tsenñu Moisés pakatu: Jeetyatyudei, Diosya lala naadejuñuba ke' keenaa jave, tsenmalaa naa-uwanuba yanu dejeetya', ujcha latintsun dejutyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tsejtu chachillaya jelanchin baatala ke-eedenaren, Moisésya juntsa yapij bulu ñivijchasha kalen jimi, Diosa' puinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Moisésnu Yavé patu tsandimi: Israel chachillanu tsandide: Ñulla demeeve naa iya selusha puturen ñuiba pañu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Tsaju' ñulla naa uruchi juu bain, naa lushi kenu jeruchi juu dyus muute bain ke' juntsanaa inu aawa kure' keewaren tsanguenu kityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ufeenda tsure' ju'kenunu tuchee kidei, tsejtu junaa animaa tute' ju'ke' keewaanu dejuve, naa uveja juula bain, chibu juula bain, wagara juula bain, tsangue' iba ura' mandiyanu. Tsejtu nutalaa iya ñullanu tsangue' inu mandengakaanu ju'ba, junu iya ja', ñullanu ura' de-iwaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tsaaren shupukachi tene tsangue' ufeenda tsure' ju'kenunu dekishu juntsaa, tichiba kutajtu shupukachee kidei, matyu tsanguenu shupuka kuta deeshu juntsaa inchi urajtu kuranu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tsenmin inchi ufeenda tsure' ju'kenunuya lla'tenachi juu lunu dejutyuve, junu lundu ñulla' bulunu cha'tene junutala keewaanuu dejuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Entsa lei jumulaa manda-i' taawasha kemu chachi miya rukulanu mijakaanu juve: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Main hebreo chachinaa manda-i' taawasha kemu juu ati'kashu juntsaa, mandishmain añuya ñuchi manda-i' taawasha ken chunu tsuve, tsaaren mandishpai añu peepunmalaya liveeju tiyanu tsuve, ñunu tiba juntsan mitya paangui'mujchin. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Tsejtu ya maali juuya jamuwaashu juntsaa, maali juuren miinu tsuve, tsaaren ya' shinbubaaba jamuwaashu juntsaa, ya' shinbuba miinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Tsaaren yanu mandanguemu ruku supu kuwañu, ne naaba miyandishu juntsaa, livee i' malundu ya' shinbunu bain, naa ya' kaillanu bain yanu mandanguen chumu rukunu tene kuwa', maali juuya miinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Tsaaren naa livee i' bain, ya' shinbunu bain, naa ya' kaillanu bain, naa yanu mandanguen chumu rukunu bain estyamu ju' mijinbai'shu juntsaa, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","yanu mandanguen chumu ruku Diosa' ajuusha taji', juukapanu mityan uyukare', tsanguityu' bain, juukapa cha'linu mityan uyukaatu, tyeeba ishpapaachi pungui fataa tsu'nu tsuve. Tsanguishu juntsaa entsa manda-i' taawasha ken chumu ruku naa-uwanuba yachi junu tsuve, peyai'mujchiya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Tsenmala mun ya' na'malanu manda-i' taawasha kemu chachi tirenu ati'banguishu juntsaa, ne unbeenala tsaa livee inu añu janmala livee i' lunu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tsaaren yanu mandanguen chumu ruku ya' shinbu tirenu ti' ati'katuren, mutyatyu', ya' shinbu tirei'shu juntsaa, mun livee kenu tyañuba juntsan mitya paanguekaanu tsuve. Tsaju' juntsa na'manu mutyatyu' kentsure' mitya, vee tusha chumu chachillanuya ai'nu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Tsaaren juntsa na'manu ya' nanu supungushu juntsaa, ya' na'maaba juñu washken tsanguenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Tsaaren yanu supu miyaren kama shinbu mangashu juntsaa, ajke' shinbunu ne panda jayun kuwakenu jutyu', jali bain ka' kutyuu jun jutyuve, tsenmin veranaa ura ya' shinbuve ti' ya' deechu chi'kenu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tsaaren naa jali bain, naa panda bain kutyu, tsenmin ne ya' shinbu juñu naaken chunuu juñuba tsanguindyushu juntsaa, tiba paangui'mujchin entsa shinbu livee i' manchunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Mun veranu wande' tute' bain, tsanguemu ruku tutanbera inu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tsaaren tu'nu kindyun, inchin tsainuu ju' tsaishu juntsaa, iya Dios, bene ñunu wainnu tsuyu, nukaa nepiya' ji' kavitu inu chunuu juñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tsaaren keranu chachiitalan ajaavi' tu'nu tya' tu'shu juntsaa, mami'ke', naa inchi ufeenda tsure' ju'kensha pantsunañu bain, manga' tutanbera inu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Tsenmala mun ne ya' apanu, ne ya' amanu ajaranchi ke' wandekishu juntsaa tutanbera inu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Tsenmala mun ma chachinu deranchi ka' tajitu, naa atike' bain, naa yaren tana' bain, tsanguemu tutanbera inu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Tsenmala mun ñu' apanu bain, tsa jutyu'ba, ñu' amanu inchi firu' isa ti' bain tutanbera isa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Tsenmala mun vinguikendu naa shupukacheeba, naa katyacheeba kike' daa-eeñu, peyai'mujchi ne dilu-i', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","bene entsa ruku ura' mandi' mangujpa' cha'lichi ne tyutyaa neneintsushu juntsaa, mun tsanguemu ju'ba entsaya tiba in jutyuve, tsaaren ya' ura' mandingama washkekaantsunu juve, tsenmin tibangui'mujchi ne tsananu malu' mitya bain lushi paanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Tsenmala mun yachi manda-i' taawasha kemu chachinu chi dapecheeba ke' tute'banguishu juntsaa, juntsa kuipa' mitya kavitu i' taaju inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Tsaaren ma malu, pai malu juuñuba machutaa peyashu juntsaa kuipa lan jutyuve, matyu juntsa manda-i' taawasha kemu chachi yachi juwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Tsandenna pai rukula vinguendun ma shinbu na puunu deta'kiñu, na shuiketuren juntsa shinbu ura' ne juushu juntsaa, tsangue' kuipa vimu ruku tapamu shinbu' ruku naatiñuba muuta paanguenu tsuve, matyu kavitu kemu bale rukula naake paanguenuu juve detiñuba juntsa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Tsaaren juntsa shinbu peyashu juntsaa, tsanguemu ruku bain tutanbera inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Tsa' mityaa kapuka putyuu tiyashu juntsaa, tsanguemu bain kapuka putyuu tiyanu tsuve; tejku kalarashu juntsaa, ya bain tsaren inu tsuve; tyaapa putyuu tiyashu juntsaa, ya bain tsaren inu tsuve; neepa putyuu tiyashu juntsaa, ya bain tsaren inu tsuve; ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","jupeshu juntsaa, ya bain tsaren inu tsuve; wanashu juntsaa, ya bain tsaren inu tsuve; daran ishu juntsaa, ya bain tsaren inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Mun yachi manda-i' taawasha kemu chachinu ne kapukatalaaba ta'ke' mushakiñu ma kapukachin kataraa tiyaishu juntsaa, tsangue' ya' kapukanu ta'ke' mushken mitya liveeju me-e'laanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Naa ya' tejkunu ta'ke' dyaivili' bain, tsangue' ya' tejkunu ta'ke' dyai-eren mitya liveeju me-e'laanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Tsandenna ma wagara chachinu tyuli' tutekishu juntsaa, juntsa wagaranu shupukachi tene tya'ke' tu'nu dejuve, tsaaren juntsa alla finu dejutyuve, tsenmala animaa miya rukuya ti kuipaba jutyu tiyanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Tsaaren juntsa wagaa ne tsa tsanguimutaa tsangue' tu'shu juntsaa, animaanu shupukachi tene tya'ke' tu'nu dejuve, tsenmin animaa miya rukunu tutenbera kenuu dejuve, naa tsanguimuñuba miren, meenguityu' ne tsangare' tanamushu juntsaa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Tsaaren tu'nu detyatyu', muuta paanguenu ne tiredeke', nan paanguenu detireñuba, tutan jutyu paanguenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Tsenmin entsaaren junu juve, naa unbee nanu tsanguiñu bain, naa supu na'manu tsanguiñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Tsenmala wagara, manda-i' taawasha kemu chachinaaba tsanguishu juntsaa, wagara miya ruku manda-i' taawasha kemu' miyan rukunu 30 paki lushi paanguenu juve, tsenmin juntsa wagaranu shupukachi tene tya'ke' tu'nu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Tsenmala mun pusu juukaraa tanañu, naa ne umaa jurukendun tichiba du'kaatyu' ne tsangaañu, junu wagara juuñuba, naa buru juuñuba pususha lupajtya' peyashu juntsaa, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","juntsa pusu ke' tanamu ruku animaa' mitya paanguenu juve, tsangue' juntsa pemu animaa yachi ne tirekenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Tsenmala ma wagara kachuchi tyuli', veela' wagaranu tu'shu juntsaa, tu'mu wagaranu ati', juntsa lushi peyamu animaa miya rukuba velekenu juve, tsenmin pemu wagara alla bain tsaren ke' veenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tsaaren juntsa wagara tsa tsanguemuñuba mideenuren, animaa miya ruku nejuu ne tanamuwaañaa tsangue' tu'shu juntsaa, tu'mu wagaa miya ruku, vee wagaraa mangunu juve wagara tuta' kuwamu rukunu. Tsenmala juntsa pemu wagaraya tu'mu wagaa miya rukuchi tiyanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Tsenmala mallee wagara juu, uveja juu, naa chibu juuñuba taanguetu, naa tuteke' bain, naa atike' bain tsanguishu juntsaa, ma wagara' mityaren man wagara manguwanu juve, tsenmala ma uveja' mitya bain, naa ma chibu' mitya bain, taapallu taapallu manguwanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Tsenmala main taamu ruku, yasha juuke' vindu katawatu, ticheeba ika' peyashu juntsaa, mun tsanguemu ju'ba kuipa lan jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Tsaaren mandalaren tsangue' tu'shu juntsaa, tu'mu kuipa faanu tsuve. Taamu rukuya ya' taanguiñu' mitya manbaanguenuu junu tsuve, tsaaren manbaanguenu lushi tajtushu juntsaa, yaa atyanu tsuve, tsangue' juntsa lushinchi manbaanguenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Tsaaren taanguenu animaanu kayu tutendyuren tana kata' demangashu juntsaa, ya nan ka'ba tsaandene pai bijee manguwanu tsuve, naa wagara juuñu bain, buru juñu bain, uveja juuñu bain, naa chibu juuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Tsenmala mun ya' animaa tape fisa tyatu, ya' panbasha, naa ne ya' uva chunu vijtyasha eekeñuren, juntsa animaa veela' tushaa ji' buikiya fishu juntsaa, yachi kayu ura jumulaa manbaangue', yachi tape wajka manguwake, naa ne yachi uva vijpala manguwakenu ju' bain tsanguenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Tsenmala mun ñi tyawaakeñu jupe' jitu, trigu ka' wa'kara tsumu jupekiñu bain, naa kangumaalanu jupekiñu bain, naa kumuinchi wajka dejupekiñu bain, tsanguemu ruku ñi naake deju'ke' jiñuba millangue paanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Tsenmala ma ruku, ya' keranu chachinu naa lushiiñuba, naa tyeeba balen juuñuba uukaanu kuwañu, ya' yasha tsuren detaanguiñu, juntsa taanguemu ruku katawa'ba ishu juntsaa, tyee ka' bain pai bijee kayu manguwanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tsaaren taamu ruku tsanguetun jaiba katawaindyushu juntsaa, uukaade ti' kuwañu ya miya rukunaa in ajuusha ta'nu dejuve, tsejtaa ya kaindyuñu bain, naa ya bain kaveteñuba mijanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Tsenmala mun naa wagara juuñu bain, buru juuñu bain, uveja juuñu bain, chibu juuñu bain, jali juuñu bain, naa ka tyeeba juuñuba, veela depireñu ka'banguiñuren, main vee ruku: Entsaa inchive, ti' manba'shu juntsaa, entsalanu in ajuusha tajinu dejuve. Tsenmala naaju anbutintsu' kuipa vi'ba, tsaandene pai bijee manbaanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Tsenmala main munaaba naa buru juu, wagara juu, uveja juu, chibu juu, naa vee animaa juuñuba uukaanu kuwañu tanaren ne peyaiñu bain, ne tapaiñu bain, tsenmin muba kataindetyun tarai'ba ishu juntsaa, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","juntsa ka' tanamu ruku inu paka', uwain yaa tsanguendyuyu ti' wainnu juve. Tsenmala animaa miya ruku ya' palaanu tsaave tya' meenguenu tsuve, tsenmala tanamu ruku paanguen jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Tsaaren ya' tyaapasha puren animaa detaanguishu juntsaa, animaa miya rukunu yaa paanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Tsaaren juntsa animaa ajaa animaachee fa'ba ishu juntsaa, ya' fanbuchu ka' taji' keewaanu juve juntsan mitya paanguen jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Tsenmala ma animaa veelachi pake' tanaren, juntsa animaa tyeeba i' tapaiñu bain, naa peyaiñu bain, animaa miya ruku keenatyu tsaishu juntsaa, mun pake' tanamu ju'ba juntsan mitya paanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Tsaaren animaa miya ruku keenaren tsaishu juntsaa paanguen jutyuve. Tsenmala juntsa animaa lushinchi pake' tanashu juntsaa, naanchi pake' tana'ba juntsan paajuunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Tsenmala mun ma panna munuba tsaityunuren firu' kenu tya', ali'pu', yaba tsaishu juntsaa, supungatu naake paanguemu deeñuba ya' apanu tsangue paanguenu juve, tsenmin yanun supunganuu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tsaaren juntsa na'ma' apa kuwanu tyai'ñu bain, supungatu naake paanguemu deeñuba, juntsa na'manu tsanguemu chachee ya' apalanu paanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Naajulaa mishinbu deeñuba juntsalanu tutei'mujchi shuikenu kityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Tsenmala mun ma animaaba tsaishu juntsaa, tutanbera inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Tsenmala mun inun animaa tute' keewaakenuunuren, vejan dyuslanaa keewaashu juntsaa tutanbera inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Vee tusha ja' chumu chachillanu ura' kityu' firu ken chutyudei; ñui bain kaspeleya vee tusha chumu chachi juuya Egiptosha chumuwa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Naa biyuda shinbulanu bain, naa apa miyajtu kaillanu bain firu' ken chutyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ñulla yalanu firu' ken dechuñu, yala inu depakanmala iya uwain mere', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ñulla' junga ajara jamiya peeniyachi vingue' ñullanu tu'nu tsuyu, tsenmala umaa ñulla' shinbulaa biyuda deshuwa, ñulla' kaillaa apa miyajtu shuwainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Tsandenna ñulla in chachiitala main ñunu pure ruku lushi bene manguwanu ti' pa'ñu kuwashu juntsaa, lushi kuwa' manga mangakemula naakemu deeñuba tsanguen chutyu', juntsan mitya ti' kayu aa manganu kityude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Tsejtu lushi pake' kan mitya, uwain mangunu tsuyu ti' keewaatu, palanu viyanu jalleeba kunmalaya, pajta kayu vindyuren manguwainu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","matyu juntsa jaliren tana' ishtyatu vikenu jali juñu' mitya. ¿Tsaaren ñu mangutyushu juntsaa, ya tinaa tsunu jun? Tsejtu ya inu pakashu juntsaa, iya meetu la'kanu jinu tsuyu, iya tenbityamu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Naa-uwanuba inu, Diosnu, kentsure' patyude, naa ñu' chachilla' bale ruku pumunu bain inchi firu' isa ti' patyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Naa-uwanu ñu' wajñu buikiya de-iñu ka' bain, keedityumujchi inchi ufeenda taanu juve, naa binu juula bain, naa ulibu muli juula bain. Tsenmin ñu' ajke' nanuya inu kuwanu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","tsenmin naa wagaachi bain, uvejachi bain, naa chibuchi bain ajke' faamu llupu kailla jumulanuya inu taanu juve; nakayañu mandishpai malu indyuya, ya' amaba tsananu juve, tsaaren mandishpen malu inmalaya inu kuwanu taanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ñullaya inchin juu chachi junu dejuve. Jeendaa animaa ñulla' animaanu fiñuba, juntsa fanbuchu alla fityu', kuchanu ne kuwakidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Naa-uwanuba anbukuinda wandis netyude, naa firu' kes nemu kuipa tañu bain, bale rukula' ajuusha ne ya' mitya ura' kekaanu anbukuinda ke' patyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Firu' kenu tyamulaa aa deju' ti dekiñuba ñu bain tsanguivete' firu' kemishtityude. Naa-uwanu kavitu ke' mantse'kaanu depa', ñunu bain depakaañuba mantsala firu' kekaanu tya' naadetiñuba tsandive'tyude; uraaya kive'de. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tsenmin kavitu kendu bain, ne pure chachi deeñu' mityaa, yalanu kemishtichi tenñu, veranu firu' kikenuu kityude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Naa ñu' kundaa rukuchi wagara juu, tsa jutyu'ba, buru juu piyañu kataake' bain, yanu manguwade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tsandenna ñunu tyutyamu' animaa buli puita llai'karatu tsuji' pandainsha ma punañu katamiya, jandala tsumu buli mangave'tyuu jutyude, naa ñunu tyutyamu chachi' animaa juñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ne pure chachi deeñaa, deechu tajdetu kure' firu' kavitu kityude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Anbutitun na'baasa depañun, juntsanu meengue' ti kuipaba tajtu rukunun tutanuu kuipa putyude, matyu kuipa ta rukunuya kuipa tajtu kurenu jutyuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Main firu' kenduren yachi uraa kisa tya', ñunu tyeeba kuwañuba katyude. Tsanguikutishu juntsaa deechu' kavitu kityu tiyainu juve, tsejtu kuipa tajtulanaa kuipa juu faaware'ba tsanguenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Vee tusha chumu ja' ñuiba chumulanu firu' ken chutyudei, kaspele ñui bain ñulla' tu jutyu Egiptosha chumuwaatu, naa-indu chumuwa deju'ba mide' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Mandishmain añuya tyeeba wajke' ka' fin chude, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","tsaaren mandishpai añu tiyanmalaya juntsa añunuya taawasha mantyu' tsangaade maali imunu pure chachilla ka' finudetsu, tsenmala tsa dekiñu lara'ba iñuya ti jeen animaa bain finudetsu. Tsenmin naa uva vijtyalanu bain, naa ulibu vijtyalanu bain tsaren kide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Mandishmain maluya ti taawashaba kide, tsaaren mandishpai malunuya lekade, tsenmalaa naa ñuchi taawasha kemu wagara bain, buru bain lekanudetsu, tsenmin naa ñuchi manda-i' taawasha kemu chachilla bain, naa vee tusha ja' chumu taawasha kemu chachilla bain leka' dera manganudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Tsa' mitya iya ñullanu naatiñuba tsa tsangue meenguidei, tsejtu naa-uwanuba ñulla' fi'pakichiya vee dyuslanu pakan chutyudei, tsaju' yala' mumunu depatyusa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Añumee pen bijee inu balengure' keewaanu fandangu kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ajke' kemiya pujkikarentsumi putyu pan fifikenu fandangu kenu dejuve iya ñullanu naakidei tiñuba tsanguetu. Mandishpai malu' mitya fandangu kenu dejuve, tsejtu pan bain fintsumiya pujkikarentsumi putyu juuya fifikidei. Entsa fandangu kemiya Abib chu'chayanu naaju malutalaa tsanguenuu juñuba kenu dejuve, juntsa chu'chayanaa Egiptosha chutun mala' maamuwa de' mitya. Tsaju', ne mun inu ja' keeja' bain tiba tajtuuya jan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Kama fandangu jumiya, ñulla vijpaasha trigu wajñu deseepu' iñu ajke' kataa fandangu kenu dejuve. Tsenmala kama fandangu bain jumiya ma añu de-insha ñulla' wajka kiya kumuinchi puka de-i' puiñu ka' dyataa fandangu kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kumuinchi unbee rukulaya ma añunu entsa pen fandangu jumulanu Bale Ruku' ajuusha, matyu in ajuusha jijiinu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Naa-uwanu animaa tute' keeware'ba, ya' asa, pujkikarentsumi puu panba buungare' keewaanu jutyuve. Ya' muli bain ayunchi laakaatyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ti buikiya iñu bain, ajke' katu kayu ura tene ka', in yasha, matyu ñu' Dios, Yavé' yasha taji tajiinu dejuve. Chibu kaillanu ya' ama' chu'pichi akaatyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Inu meedikai, iya ñulla' ajuusha in anjee main eenu tsuyu ñulla' jingura ñullanu washkenutsu, tsenmin iya ñuichi yumaa deke' tanañu tenasha miya' jinutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Yanu keeminchaa jutyudei; ya naatiñuba meenguidei; pañu meetyu jutyudei, yaa in mitya tsanguis nendu, ñulla' kundaa keñu jumula manbitsaanuu jutyuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tsaaren uwain yanu meedi', iya naatiñuba tsanguishu juntsaa, ñulla' kundaalaba kundara junu tsuyu, tsejtu mun ñullanu tyeeba kenu dekiñu bain, iyaa yalanu tsa mannu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","In anjee ñulla' ajkesha puu jimishtitu, Amornu sera' jimula' chuinsha bain, Hetnu sera' jimula' chuinsha bain, Fereznu sera' jimula' chuinsha bain, Canaánnu sera' jimula' chuinsha bain, Hevenu sera' jimula' chuinsha bain, Jebúsnu chumula' chuinsha bain miya' jinu tsuve, tsenmala entsa chachillanu millangaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ñullaya yala naakemu deeñuba tsanguityu', yala' chi dyuslanu teedityudei, naa aawa kure' keewaanu bain kityudei; tsa jutyu', yala' chi dyuslanu demushake', naa yala' aawa kure' keewaanu shupukalanu bain tsaa desenaa-eekidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Tsaaren inu, ñulla' Dios Yavénu, aawa kure' keewaawaakidei. Tsenmala iya ñulla' panda bain, naa kushnu pi bain ura' ikaanu tsuyu. Diipeya juu bain ñulla' junga pukaan jutyuyu, ñullanu diluwaren jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tsenmin naa supula bain na shuikenu dejutyu', naa navityuu bain jun dejutyuve. Tsenmin te' peyan jutyu tire', pure' malu chukaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Naajulanu bain ñulla' ajuushaya jeetyainuke tirenu tsuyu, ñulla naaju pebulutala deviñuba ti ken tsaa detirenu tsuyu, tsenmin ñulla' kundaala ñullanu dekatamin nepiyainuu tirenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ñulla nuka pulla' jindetsuñu bain ñulla' ajkesha tyeeba yalanu jeetyawaakenuu eenu tsuyu, tsenñu naa Hevenu sera' jimu chachilla bain, naa Canaánnu sera' jimu chachilla bain, naa Hetnu sera' jimu chachilla bain dejeetya' nepiyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tsaaren ma añunuren yalanu dekelaakenu jutyuyu, tsenmalaa muba chutyuu detiyanmala, tusha jeenbala firuu tiyai'nutsu, naa jeenbaasha chumu animaala bain desera' ñullanu firu' ki'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Matyu ñulla' chuinsha jayu jayu manguelaaken tsunu tsuyu, ñulla na deka' sera' main main tu dekanbera. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ñulla' tu yumaa señas depuu tanayu. Entsaave: Ungalala tinu lamaabi jumin Filistea tusha chumula' lamaabi juve, tsenmin tiba den chutyuin tenabi jumin, Éufrates pibi juve. Iya ñullanaa jundaa chumu chachillanu ñulla' tyaapanu kuwanu tsuyu, tsenmala ñulla' ajuusha juka'laanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ñulla entsa chachillaba buudi' veta' veta' ura' ken chunu tiyatyudei, naa yala' dyuslaba bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Tsenmin entsa chachillanu ñulla' tusha tsangaanu kityudei, matyu yala ñullanu mandinbu yala' dyusnu teedi' aawa dekure' keewaakaañu, inu kundaa ke' ujcha dela' tyu'lekaraiñuu in jutyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Tsejtu Yavé, Moisésnu tsandimi: Aarónnu bain, Nadabnu bain, Abihúnu bain, tsenmin Israel bale rukulanu mandishpaichungaa miya' lade, tsejtu in junga kalen jai'mujchi baatalaren deteedi' aawa kure' keewaakai. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Tsaaren ñuren in junga kalen jainu juve; vejan lamulaya kalen janu dejutyuve; naajula bain enguya lanu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tsenñu Moisés miitu, yanu Yavé naati', tsa tsanguidei tiñuba chachillanu dekuindakiñu, kumuinchi pakatu entsandila: Tsaaya, Yavé naatiñuba ti bain millangue kenu detsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tsenñu Moisés Yavé naatiñuba millangue depiikemi. Tsejtu ayunchi dishkepenene kujpatu, kuyi peepunu tenanu ufeenda tsure' ju'kenunu main kemi, tsejtu Dioschin juu shupuka tene 12 uikaami, Israel' nala nan dejuñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Tsejtu Moisés bene Israel chachilla' unnalanu pañu, Yavéchi animaa detute' ju'ke' keewaala, tsenmin Diosba ura' mandinu bain llupu kaa wagara detute' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Tsejtu Moisés animaa asa dekatu, ma tsandaa asaya shullanu deka' putu, ma tsandaaya ufeenda tsure' ju'kenu jandala deshaja' tya'kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Tsejtu bene, veta' veta' tsanguedaa ti' pilla kiika katu, kumuinchi chachilla' ajuusha lenmi, tsenñu yala entsandila: Tsaaya, Yavé naatiñuba tiba tsangue ke' meenguenu detsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Tsenñu Moisés asa shulla katu chachillanu deshaja' tya'ketu tsandimi: Entsa asaa Yavé ñuiba veta' veta' tsanguedaa tiñu keewara asave, matyu kumuinchi entsa tsanguenu tsuyu ti' pañu juntsa keewarave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Tsejtu Moisés bain, Aarón bain, Nadab bain, Abihú bain, tsenmin Israel bale rukula bain mandishpaichungaya kuyisha lula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Tsejtu junga Israel chachilla' Diosnu katala, tsenñu ya' neepa panbeesha tsamantsa pi'kelana' bale shupuka safiru tene tsure' keekiñunami, tsenmin lushjuru ju' selusha ke'laakeñuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tsejturen Dios Israel chachilla' bale rukulanu tiba firu' kendyuñu, peyaindyula. Tsenñu yala Diosnu dekata', panda fimin, pi bain kushminguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Tsenñu Yavé Moisésnu tsandimi: In punaashu juntsa kuyisha lade, tsejtu inu junu keenaka; iya ñunu shupu' ta'pa kuwanu tsuyu, junaa naa lei bain, tsenmin naaken chunuu dejuñuba juntsa bain depillave, Israel chachillanu mijakaanutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Tsenñu Moisés kujpatu, yanu tiba kivetes nemu Josuéba jimi, tsejtu Moisés Diosa' kuyisha lumi, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","tsaaren bale rukulanuya entsandimi: Lala majanbera ñulla enu keenakai. Aarón bain, Hur bain enu ñuiba shuwanu detsuve. Ti peletu juu dekata' bain yalanaa padei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moisés entsandi' dyatu kuyisha luntsuñu, juntsa kuyisha ñivijcha tsaa dukikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Tsenñu juntsa kuyinu Yavé' tsamantsaa keewara jumu ja' pudiñu, mandishmain maluya tsaa Sinaí kuyi ñivijchan juruu tsanami. Tsejtu mandishpai malu insha Dios ñivijchasha puturen Moisésnu mikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tsenñu Israel chachilla Yavéchi tsamantsaa keewara jumunu millangue ju'kemu ñillu juuya juntsa kuyi kai'sha katalaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tsenñu Moisés juntsa ñivish bulunu dishu' vi', kayu kuyi kai'sha luimi. Kuyisha kumuinchibi 40 malu 40 kepe pudimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Tsenñu Yavé, Moisésnu patu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Israel chachillanu inchi tyeeba ufeenda kuwanu kadei tide, tsenmalaa yala mu bain main main tyee kuwandya'ba yala' pensachi tsa tsangue kuwanudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Entsaa kanu dejuve: Uru bain, lushi kenu jeru bain, brunse bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","lushmurara jilu bain, yamurara jilu bain, ungalala jilu bain, ura linu jilu bain, chibu ju bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","llupu uveja kika ungalalaa tiwara bain, naa pi animaa kika kayu naraa juula bain, naa akasia chi bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ñillu chakaanu ulibu muli juula bain, naa inchin juu tirendu menestenguentsumi mulinu punu aindyu juula bain, naa ju'ke' aindyunguikaantsumi kenu aindyu juula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","naa unise shupuka juula bain, naa chachilla' mitya inu kalen jimula' aa bale rukuchi tyaapa putyuu juwali jumu efud tinu jalinu mai'tentsumi bale shupukala bain, naa efud jandala tenbapunu teenu jai pakinu mai'tentsumi bale shupukala bain kanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Tsenmin in pupunanu yapaya bain main kidei, tsenmala Israel chachilla' kejtsapala iya chunutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tsaaren iya chudinu juuwashu juntsa yapaya bain, tsenmin juntsa yapayasha tiba tsumula bain, iya naaju juu dekeewaanuuñuba juntsangue kide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Tsenmin ma babuu bain akasia chichi kikaade, barenchiya pai tyabulu, kama kejtaa tyabulu, tsenmin bungunchi bain, naa katyunchi bain ma tyabulu kama kejtaa tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Naa juusha bain, naa avindala bain uru tene pi'wara' mai'ta', uruchiren chuwa pijtekaran tsaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tsenmin uru pi'ware' taapai tuti bain kikare', neepameemee eengaakaade; pai neepa kelusha pai tuti eengare', masku pai neepa kelusha bain pai tuti eengaakikaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tsenmin shulintsumi cha'li bain akasia chichi ju', uruchi tene mai'taanu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","tsejtu kelu kelu pumu tutilanu pudei, tsangue' juntsanu ka' yali' taji tajiinu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Juntsa cha'li tutitala pumiya mangalaalaakenu dejutyu', tsangaanuuya dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tsenmin lei pillaa kuwakenu juuwashu juntsaa babuu juusha pude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Entsanu du'kaanu ta'pa uruchi tene ju', barenchiya pai tyabulu kama kejtaa tyabulu, tsenmin bungunchiya ma tyabulu kama kejtaa tyabulu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tsenmin du'namu ta'panu, ja'chi puu muute juundene pallu ju', maatilluchin urunu tsangue deke' kapash kapash chujtyaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tsejtu du'kaanu ta'panu ja'chi puu muute ju', mainya masku kapasha, kamainya kama kapasha junu dejuve, tsaju' juntsa du'namu ta'pa ja'chi puu muute jumulaba main juunu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","juntsala yala' ja'chi ja'warana', ta'pa jandala dishkenu dejuve. Tsejtu kaju'talana', yala' kajuuya du'namu ta'pasha keepunanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tsejtu iya kuwanu juuwashu juntsa lei pilla juntsa juusha putu, juntsa babuunu du'namu ta'pa pude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Iya juntsa du'namu ta'pa kai'talaa ñuba katawanu tsuyu, tsejtu iya chachillanu veta' veta' tsanguedaa tiñu keewara babuu jandala, entsa ja'chi puu muute judeeshu juntsala' kejtalaa ñunu Israel chachillanu tyee kisa tinu ju'ba mijakaakaa kenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Tyeeba tsuunu ta'pa llaijkara akasia chi ta'pachi main kikaade, barenchiya pai tyabulu, bungunchiya ma tyabulu, katyunchiya ma tyabulu kama kejtaa tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tsejtu uru tene pi'wara' mai'taju' kelutala uruchiren chuwa pijtekaran tsaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tsenmin kelutala mai'tenu pakiya taapai tyamishu bunguu pu', juntsa jandala uruchiren chuwa pijtekaran tsaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tsenmin uru tuti bain taapallu ju', kelush kelush taapai neepa jumulanu eraanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Tsaju' tuti jumula kuyi kalen kalen jui vinu dejuve, tsejtu entsa tutinaa cha'li ñali' tyeeba tsuunu ta'pa llaijkara yali' taji tajiinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Juntsa tyeeba tsuunu ta'pa llaijkara tajintsumi ya' tutilanu ñalinu cha'li, akasia chichee ju', uruchi tene mai'taanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tsenmin ya' palatu juula bain, aa kuchara juula bain, aa shulla muute juula bain, naa chachilla inu dekeewaañu binu puntsumi kaa shulla muute juula bain uruchi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Naa-uwanuba in ajuusha keewara pan, tyeeba tsuunu ta'pa llaijkara jandala tene tsutsungaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Naa ñillu chujtintsumi usja'tee aa lanpara bain uruchi tene kikaade, tsejtu mainnuren naa ya' uinainsha bain, naa ya' bulu bain, naa ya' kupa juula bain, naa ya' llullu tyuinanu basu bain, naa ya' llullu tape juuñuu bain junuren tsangue dekikare', maatilluchi tene vili' millangue juntsa muute dekikaade, petse petse tyuipui'mujchiren. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kelumeemee pen tyaapa juu tiyanmala, kumuinchibi pai kelubiya mandishmain tyaapa tiyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Entsa mandishmain tyaapa tiyamulanu main main pen basu pu', almendru llullu keraa ju', llullu tyuinanu basu bain, llullu ya' tape bain puunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Tsenmala aa lanpaa luraren taapai basu punu juve; almendru llullu keraa ju', llullu tyuinanu basu bain, llullu ya' tape bain puunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Tsejtu pai tyaapa tyuidinu panbeemeemee llullu tyuinanu basu pundene juunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tsejtu naa llullu tyuinanu basu bain, naa ñillu chujtinu tyaapala bain tyuipuñu' jutyu', ñillu chujtintsumi usja'tee jumu aa lanpara ma bulu juunu juve. Juntsa ñillu chujti' chakaantsumiya uruchi tene juju' maatilluchee villa' junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Tsenmin lanpaa bain mandishpallu junu tsuve, tsejtu naake chujtiñaa ajkesha dan-eekenu juñuba tsangue chujtide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tsenmin ya' michanu majtadimu bain, naa ya' kaa palatu juula bain uruchi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ñillu chujti' chakaantsumi bain, naa junu tiba meneste imula bain dekenu, uru tene 33 kilu meneste junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tsaju' ñunu kuyisha keewaañu naadejuñu kata'ba juntsangue kikaade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Dios kayu pa' jindu Moisésnu tsandimi: In pupunanu yapaya kikaade, tsejtu daayadimu jali turekaraa ura linuchi tene paitya kikaade. Juntsa daayadimu jali jumula lushmuraraa jiluchi bain, yamuraraa jiluchi bain, naa ungalalaa jiluchi bain juunu dejuve, tsenmin juntsa jalinu ja'chi puu muute pallu narake tsejtekaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kumuinchi entsa daayadimu jali jumula paree bareemin, paree bunguunu dejuve; barenchiya 28 tyabulu, tsenmala bungunchiya taapai tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Daayadimu jali mandaya kapash kapash pumaa ju' main juju', kama manda jumula bain tsaren junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tsenmin entsa daayadimu jali ajke' manda tyuipu jumula ma kelusha ya' kapatala lushmuraraa jai tuti jungue ke' chujtyaanu juve. Tsenmin, kama daayadimu jali tyuipu jumula bain tsaren junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tsa' mitya daayadimu jali ajke' manda tyuipu jumu ma kelusha bain, naa kama daayadimu tyuipu jumu kama kelusha bain main main 50 jai tuti punu deju', tutiitala kaju'talai tiya tiyainu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tsenmin daayadimu jalitala tyuipu' kakaanu beru bain uruchi tene 50 junu juve, tsangue' tyuipunmala in pupunanu yapaya ma jali juu tiyainutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Tsenmin chibu juchi keñu jali tene 11 junu juve, juntsachi in pupunanu yapaya vikaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kumuinchi entsa 11 vikaanu jali jumula barenchi bain, naa bungunchi bain paree juunu dejuve: barenchiya 30 tyabulu, tsenmin bungunchiya taapai tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tsejtu vikaanu jali manda jumula dula' depuma', naa vikaanu jali mandishmain laramula bain tsaren junu dejuve; tsaju' vikaanu jali mandishmain buunamushaya main yapaya ajuusha tiya' dyajpiikakaraanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tsejtu vikaanu jali ajke' manda tyuipu jumula ma kelushaya 50 jai tuti pu', kama vikaanu tyuipu jumu kama kelusha bain 50 jai tuti punu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tsenmin beru bain brunsechi tene 50 ju', tutiitala kakaraanu juve, tsenmalaa yapaya ma jalichin vikaraañui tiyanutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Tsaaren vikaanu jali kayu aabungu' tiya' mitya, main kapasha vimuya ma tsandaa lara' dyajpii pajtya' in pupunanu yapaya benesha eradinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Tsaju' entsa vidimu jaliya linu jalinu kelush kelush ma tyabulu pullaa bare' mitya, in pupunanu yapayanu bare' mitya viyadinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tsenmin in pupunanu yapayanu entsaba pema vidimuya, llupu uveja kika ungalalaa tiwarachi tene juunu juve, tsenmala juntsa jandala yapaya mishbui'sha vikaantsumiya pi animaa kika kayu naraa jumulachi tene juunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Tsenmin in pupunanu yapayasha uikaanuya akasia chi ta'pa tene juunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ma ta'pameemee paitya tyabulu barenu dejuve, tsenmin bungunchiya ma tyabulu kama kejtaa tyabulu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Entsa ta'pala mainya pai kajti pu', kamainya pai juru juunu juve yaitala tyulla tyullainudetsu. Tsaju' in pupunanu yapayasha vimu ta'pala naajula bain tsaandene junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Sur pashaya 20 ta'pa punu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","tsejtu entsa 20 ta'palanu deendanamu paki jumulaya 40 ju', lushi kenu jeruchi tene juunu dejuve. Ta'pameemee pai kajti puu deju', panbeesha deendanamu pai paki juru jumulanu ya' kajti vinu dejuve. Ta'pameemee tsaandene junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Naa kama pasha bain, ura pañuya, in pupunanu yapaya nurte pasha bain, 20 ta'pa pu', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ta'pameemee deendanamu paki pallu pallu punu ju', 40 junu juve; juntsala lushi kenu jeruchi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Tsenmala pajvinu pashaya, ura pañuya, in pupunanu yapaya beneshaya mandishmain ta'pa punu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","tsenmin benesha, pai mutu jumunu uinamu bain pai ta'pa, pai ta'pa buungaraanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Entsa ta'pa pallu pallu uikara' jimula pelesha pareju mityana', kai'sha bain tutichi dula' mityananu detsuve. Tsaju' benesha pai mutunu uinamu ta'pala tsaandene junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Tsaju' mandishpen ta'pa junmala juntsa panbeesha deendanamu paki jumulaya lushi kenu jeruchi tene ju', kumuinchibi 16 paki junu dejuve, matyu ta'pameemee deendanamu paki pallu pallu vinu jutu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Tsenmin in pupunanu yapaya ma kelusha ta'pa deengaanu punu bain akasia cha'li tene manda junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Tsenmin masku keesha ta'pa deengaanu bain man cha'li, naa benesha pajta vinsha ta'pa deengaanu bain man cha'li junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Tsenmala ma lura kejtala kapash kapash dapuimuya ta'pa kejtaa katyutala puntsumi junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kumuinchi ta'pala uruchi tene mai'taa ju', naa tutila bain uruchi tene juunu dejuve; tsenmin tutinu vi' jiinuu cha'li jumula bain uruchi tene mai'taanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tsa' mitya in yapaya jumula iya kuyisha naaju keewaamuñuba juntsangue kikaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Tsenmin daayadimu ma jali turekaraa ura linuchi kikare', lushmuraraa jiluchi bain, yamuraraa jiluchi bain, ungalalaa jiluchi bain jungue kikaade. Tsejtu juntsa jalinu ja'chi puu muute jumula narake tsejtekaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Entsa daayadimu jali akasia chichi keñu taapai yatyutya uinamu luratala uru beruchi yangaantsumi junu juve. Entsa yatyutya jumula bain uruchi tene mai'taanu dejuve. Yatyutyameemee lushi kenu jeruchi keñu panbeesha deendanamu ma paki jumulanu uinanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tsejtu umaa daayadimu jali berutala yangaakaade, tsejtu juntsa beneshaa iya chachillanu veta' veta' tsanguedaa tiñu keewara babuu tsuukaade. Entsanguenmalaa pai suku juu tiyanu tsuve; ma sukuya chachilla' mitya inu kalen jimula' vinu suku, tsenmala kama sukuya inchin juu jumu suku junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tsejtu bene babuunu ta'pa dukaade, inchin juu jumu sukusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tyeeba tsuunu ta'pa llaijkaraya daayadimu jali avindala chujtikide, ura pañuya, in pupunanu yapaya nurte pasha, tsenmala ñillu chujtinu aa lanparaya surshaa chujti', tyeeba tsuunu ta'pa llaijkaraba aju'talake chujtide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Tsenmala yapaya juukapanuya daayadimu ma jali turekaraa ura linuchi kikare', lushmuraraa jiluchi bain, yamuraraa jiluchi bain, ungalalaa jiluchi bain jungue kikaade, tsangue' jiluchi ti muuteeba narake tsejtenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tsenmin daayadimu jali yangaanu bain akasia chichi man yatyutya kikare', uruchi tene mai'tekaanu juve, naa beru bain uruchiren junu dejuve, tsenmin man yatyutyanu panbeesha deendanamu paki jumulaya brunsechi tene depi'ware' kikaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Dios kayu pa' jindu Moisésnu tsandimi: Akasia chichi tene ufeenda tsure' ju'kenunu main kikaade, barenchi bain, naa bungunchi bain man tyabulu ju', taapai kelu jumula tsaandene junu juve. Tsenmala katyunchiya pen tyabulu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Tsenmin taapai mutunu, taapai kachu muute ju', tyuipujtu' main juunu juve. Tsejtu brunsechi tene mai'taanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tiba ufeenda tsure' ju'kensha talantsumi tsumulaya brunsechi tene juunu dejuve: naa ñijuingui puntsumi bain, naa pala juula bain, naa shulla muute juula bain, naa animaa alla baindekaanu jeru bain, naa ñinbuka puntsumi juu bain brunsechi tene junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tsenmin brunsechin main waaku ju', ya' mututala brunse tutichi taapai mutunu mai'taanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tsejtu ufeenda tsure' ju'kenunu ya' jurusha, kejtaa deechutala kajti usnanu panbeesha entsa waaku tsuunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tsenmin entsa ufeenda tsure' ju'kentsumichi cha'li lura akasia chichi tene pallu ke', brunsechi tene mai'tenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Entsa chi lura jumula juntsa tutinu ñalla' vinu dejuve; ura pañuya, ufeenda tsure' ju'kenunu pai kelusha pu' yali' tajintsumi junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ufeenda tsure' ju'kenunu chi tene juu ju' juruunu juve, matyu ñu kuyisha naaju katañuba juntsaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Tsenmin in pupunanu yapaya kelu kelu cha' neneinsha kikaade. Sur pasha daalu'tekaanu jali jumu turekaraa ura linuchee junu juve, bare' mitya tene 100 tyabulu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ya' yatyutyala 20 junu juve, tsenmala yatyutyanu panbeesha deendanamu paki jumula bain 20 ju', brunsechi tene juunu dejuve. Tsenmala ya' beru juula bain, naa ya' tuti juula bain lushi kenu jeruchi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Tsenmin nurte pasha daalu'tekaanu jali jumu bain baren mitya 100 tyabulu junu tsuve; junu yatyutya bain 20 ju', naa yatyutya jumulanu panbeesha deendanamu brunsechi keñu paki bain 20 junu dejuve, tsenmin yatyutya beru jumula bain, naa ya' tuti jumula bain lushi kenu jeruchi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Tsenmala pajta vinu deechusha cha' neneinsha daalu'tekaanu jaliya bungu' mitya 50 tyabulu junu juve. Junu uinamu yatyutyala paitya ju', naa yatyutya panbeesha deendanamu paki jumula bain paitya junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Tsenmala pajta lanu pasha cha' neneinu ajuusha bain 50 tyabulu bungunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Tsenmala juukapa kelusha daalu'tekaanu jaliya 15 tyabulu bungunu juve, tsenmin yatyutya bain pema, naa yatyutyanu panbeesha deendanamu paki bain pema junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Tsenmala masku kelusha daalu'tekaanu jali jumu bain 15 tyabulu bungunu juve, tsenmin yatyutya bain pema, naa yatyutyanu panbeesha deendanamu paki bain pema junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Tsenmala cha' neneinsha vinu juukapanu daayadimu jaliya 20 tyabulu bungu yananu tsuve, tsaaren entsa daayadimu jali turekaraa ura linu jiluchi bain, lushmurara jiluchi bain, yamurara jiluchi bain, ungalala jiluchi bain ti muuteba narake tsejtenu juve. Junu ya' yatyutyaya taapallu, naa yatyutyanu panbeesha deendanamu paki bain taapallu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Cha' neneinu tenasha uinamu yatyutyalaya naa tuti bain, beru bain lushi kenu jeruchi tene juu puunu dejuve, tsenmala yatyutya panbeesha deendanamu paki jumulaya brunsechi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Tsaju' cha' neneinu tena barenchiya 100 tyabulu ju', bungunchi 50 tyabulu junu tsuve, kelumeemee. Daalu'tekaanu jali turekaraa ura linuchi jumu katyunchi man tyabulu junu tsuve. Tsenmala yatyutyanu panbeesha deendanamu paki jumulaya brunsechi tene juunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tsaju' in yapaya jumula chuinsha tiba meneste imula bain, naa in pupunanu yapayanu deengaanu jeru lura jumula bain, naa cha' neneinsha chuwa chi'kare' deengaanu jeru lura jumula bain brunsechi tene juunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Israel chachillanu, ulibu muli kayu ura taadei tide, ñillunu naa-uwanuba dandaa tananu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Tsenmala Aarónya ya' nalaba lanpaanu naakentsunu juñuba tsanguentsunu dejuve, tsenmalaa daayadimu jali avindala babuu chunu keesha iba wa'dinu yapayasha kepengama dannamin, chayangama in ajuusha dannanutsu. Tsa' mitya entsaa jumulaa Israel chachilla bain, naa yalanu bene sera' jimula bain naa-uwanuba tsa tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Dios kayu pa' jindu Moisésnu tsandimi: Ñu' uñaku Aarónnu bain, naa ya' nala Nadabnu bain, Abihúnu bain, Eleazarnu bain, naa Itamarnu bain ñu' junga demikade, tsenmalaa yala chachilla' mitya inu kalen jimu detiya' in yapayasha taawasha kemu junudetsu, Israel chachilla' kejtsapala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ñu' uñaku Aarónchi juntsa taawasha kendu pananutsumi balenchi jali ke', narake kide balengurenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Tsejtu iya naaju rukulanaa juntsa kikenuu tireñu kata'ba, ñu juntsalanu pade yala Aarónchi jali kenudetsu, tsenmalaa ya inchi chachilla' mitya inu kalen jimu ruku juu tiyanutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Entsaa jali jumulaa kenu dejuve: tenbapunu teenu jai paki bain, efud bain, avindaa pannu jali bain, muute deke' chujtyaa bareree tainsha pumu jali bain, naa mishusha pujchinu linu jali bain, tsenmin ajpeendee chuwa bain. Tsejtu ñu' uñaku Aarónchi bain, naa ya' nalachi bain jali kenu dejuve, tsenmalaa juntsachi chachilla' mitya inu kalen jimu in chachi junudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Tsejtu mun entsa jali kemu deju'ba uru jilu bain, lushmurara jilu bain, yamurara jilu bain, ungalala jilu bain, naa ura linu jilu bain menestenguenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Efud jali kentsumiya, uru jiluchi bain, lushmurara jiluchi bain, yamurara jiluchi bain, ungalala jiluchi bain, tsenmin turekaraa ura linu jiluchi bain narake tsejtenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Tsenmin efudnu pala deechu kapameemee jai pakichi yaatala teepu' kakaakenuu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Tsenmala efud jandala deendanamu jimu ajpeendee chuwaya efudba main juunu tsuve, tsenmin entsa bain uru jiluchi bain, lushmurara jiluchi bain, yamurara jiluchi bain, ungalala jiluchi bain, tsenmin turekaraa ura linu jiluchi bain junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tsejtu bene unise shupuka pallu katu, Israelchi ya' nala' mumu junu piikekaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Tsejtu yala naa-i pajtya' awamu deeñuba tsa tsai pilla', avenjula' mumu ajke' pillanu juve. Tsejtu ma shupukanuya mandishmain mumu ajke' pilla', kama shupukanu kama mandishmain mumu pillaanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Entsa shupukalanu mumu piikilaya urunu taawasha kiikemulaa tsanguenu dejuve, tsejtu naaketaa muute punu tsu'kantsumi kemu deju'ba tsanguenu dejuve. Tsejtu entsa pai shupukala Israel' nala' mumu pillaa jumula uruchi keñu mai'tenu pakinu nara mai'tanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Entsa shupukala efudnu pumu, pala kai'sha jimu jai pakinu mai'taanu dejuve naa-uwanuba Israel' nalanu mandenga mandengakenu. Entsanguitaa Aarón ya' palanu yala' mumu viyaa ji' in ajuusha taji tajiinu tsuve mandenga mandengakenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tsenmin mai'tenu paki jumula uruchi junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Tsenmin kuunduupi keraa bain uruchi tene pallu kikare', mai'tenu pakinu deengare' kelu kelu pukaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Tsenmala kavitu kenutsumi tenbapunu teenu jai paki narake kikaatu, efud naajuñuba tsangue kikaanu juve. Juntsa kendu bain, uru jiluchi bain, lushmurara jiluchi bain, yamurara jiluchi bain, naa ungalala jiluchi bain, naa turekaraa ura linu jiluchi bain kekaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tsenmin pai paki jungue dyajlla' buungara' junu juve, barenchi bain, naa bungunchi bain pareju juu, 22 sentimetru juu tene junu juve kelumeemee. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tsenmin naraa bale shupukachi tene taapai shili ju mai'tanu juve. Ajke' shilinuya sarduniu bain, tupasiu bain, tsenmin esmeralda bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Tsenmala entsaba pai shilinuya: turkesa bain, safiru bain, tsenmin jade shupuka bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Tsenmala entsaba pen shilinuya: jasintu bain, agata bain, tsenmin amatista shupuka bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Tsenmala entsaba taapai shilishaya: krisulitu bain, unise bain, tsenmin jaspe shupuka bain. Entsa bale shupukala uruchi keñu mai'tenu paki jumulanu chujtyaa tene junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Entsala 12 shupuka junu dejuve, matyu Israelchi ya' nala 12 dejuñu' mitya. Tsaju' Israelnu 12 sera' jimula' mumu ma shupukameemee ma mumu pilla' chujtya' muute chujtintsumi juuñuu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tsenmala tenbapunu teenu jai pakinuya kaa kuunduupi keraa uruchi tene ju', chuwa turan tsaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tsenmin uru tuti bain pallu ju', tenbapunu teenu jai paki kai'sha kapash kapash puntsumi junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tsejtu uru kuunduupi jumuya tenbapunu teenu jai paki kai'sha kapash kapash pumu tutilanu kakaantsumi junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Tsenmin kuunduupi keraa tene pallu jumula' pai kapa, palanu mai'namu jai pakinu juntsa uru deengaranu kakaade, tsaju' efudnu ajkesha pumu jai pakinu kakaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tsenmin uruchiren kayu vee tuti pallu mangaatu, tenbapunu teenu jai pakinu pele kapasha pukaade, ura pañuya, efud keesha jumunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Tsenmin kama pai tuti uru tene juu mangaatu, entsalaya efudnu pumu jai paki ajkesha pukaade, panbeesha punnu kelunu, efudnu ajpeendee chuwa punu jayu katyunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Entsanguishu juntsaa tenbapunu teenu jai pakinu pumu tuti efudnu pumu tutiba, main lushmuraraa chuwachee kakaanu dejuve; tsenmalaa tenbapunu teenu jai paki efudnu pumu ajpeendee chuwa kai'tala tiyainu tsuve, yaitala baka' ji'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Entsanguitaa Aarón kavitu kenutsumi tenbapunu teenu jai paki panaa chachilla' mitya inu kalen jimula' vinu sukusha vinmala, naa ya' tenbaputala bain Israelchi ya' nala' mumu pillaa jinmala, iya naa-uwanuba yalanu mandenga mandengakenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tsenmin kavitu kenutsumi tenbapunu teenu jai pakinu naa Urim bain, naa Tumim bain pukaade, tsenmala Aarón in ajuusha jamiya ya' tenbapunu puu jajainutsu. Tsejtu juntsa deechu' kikaamu ya' tenbapunu mayii in junga jajainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Tsenmala avindaa pannu jaliya lushmurara jiluchi tene dekide. Juntsa jandalaa efud jimu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Tsaaren kejtalaya juruunu juve mishpuka vinutsu. Tsejtu chiipunu keetala jayu dyajpiikakaade, wagaa kikachi naake jali ke' tenbapunu dishkaamu deeñuba tsanguikaatu, tsenmalaa kiyuuji'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Tsejtu belu' kaya pele kapa kapaya tsururu puka kerake detsejtekare' uukerake kikaade, lushmuraraa jiluchi bain, naa yamuraraa jiluchi bain, naa ungalalaa jiluchi bain deketu, tsenmin naa uru kaa kanbana juula bain yangaatselu kikaade entsa kapatala, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ura pañuya, uru kaa kanbana eengaamiya, tsururu puka keraaya juntsa keenu puja'teke tsejtekaade, tsejtu kamain uru kaa kanbana eengaamiya, tsururu puka keraaya tsejtekare' tsaandene kekaanu juve kumuinchi juntsa jali belu' kaya kapatala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aarón chachilla' mitya inu kalen jimu ruku juu taawasha kentsumiya entsa kapa tinu jali pananu tsuve, tsenmalaa chachilla' mitya inu kalen jimula' vinu sukusha vi', in ajuusha jaiñu bain, naa fale' majaintsu bain kanbanan keenbarai neneinutsu, tsejtaa Aarón peyan jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Tsenmin junu uruchi tene pinbakikii paki ke' muute puntsuminu naake piikemu deju'ba juntsanguitu: “Yavéchin juu rukuve”, pilla junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tsenmin juntsa pinbakiki, mishusha pujchinu jalinu llashkapasha mai'tekaade main lushmuraraa kaa chuwachi teleketu, tsenmalaa jei pajtyai'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Entsanguitaa entsa pinbakiki Aarón' llashkapanu naa-uwanuba tsananu juve, tsenmalaa Israel chachilla inchin juu ufeenda keewaanutala ti ujcha ladeiñuba Aarónya kuipa taji tajiinu tsuve. Tsaju' juntsa pinbakiki lepa puu jijiinu tsuve, tsenmalaa iya juntsa ufeenda jumula mutyanutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Aarónchi muute deke' chujtyaa bareree tainsha pumu jali ura linuchi tene ju', naa mishunu pujchinu jali bain ura linuchiren junu tsuve. Tsenmin ajpeendee chuwa bain tyeeba narake tsejtenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Tsenmala Aarón' nalachiya bareree tainsha pumu jali ju', naa ajpeendee chuwa bain, naa mishusha pujchinu jali bain naraa ju', yalanu balengurekaantsumi junu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Entsanguitaa naa ñu' uñaku Aarónnu bain, naa ya' nalanu bain jali deke' pandenu juve, tsejtu bene yala' mishusha muli yuutsuude, tsanguetaa yalanu tsanguenu taawasha kuwa', chachilla' mitya inu kalen jimu ruku inchin juu detirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tsenmin yaichi tainsha punu wara bain linuchi tene ju', ajpelenu dishdimiren enbubi jingue dishdinuu junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarónya ya' nalaba entsa wara puu junu deju', naa iba wa'dinu yapayasha viindu bain, tsa jutyu'ba, in yapaya chuinsha vi', ufeenda tsure' ju'kensha kalen jiindu bain puu viviinu detsuve. Tsejtaa naa-uwanuba tsaandene kiikenu detsuve, ujcha la' peyan jutyu. Tsa' mitya entsaa jumulaa naa ya bain, naa yanu sera' jimula bain naa-uwanuba tsa tsanguen chunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Dios kayu pa' jindu, Moisésnu tsandimi: Chachilla' mitya inu kalen jimu rukulanu inchin juu detirenu jushu juntsaa entsanguenu juve: llupu kaa wagara main ka', naa llupu uveja bain tiba yujkajtu naraa tene pallu kade, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","tsejtu pan kenu kayu ura trigu llujpe katu, da'pukakaa pan ke', naa mulichi yandaa pan bain ke' akaade. Juntsala pujkikarentsumi putyu tene junu dejuve, tsenmin pan kaa paki bain pujkikarentsumi putyu tene ke' muli mulangue' akaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tsejtu ma pishkalinu puke' in pupunanu yapayasha ta'de, naa llupu kaa wagara bain, naa llupu uveja pallu jumula bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Tsejtu bene Aarónnu bain, naa ya' nalanu bain, iba wa'dinu yapayasha tajitu, yalanu pitsaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tsejtu bene chachilla' mitya inu kalen jimula' pannu jali katu, Aarónnu juntsa jali pandede, naa bareree tainsha punu jali bain, avindaa pannu jali bain, efud bain, naa ya' tenbapunu teenu jai paki bain. Tsejtu efudnu pumu ya' ajpeendee chuwachi deengaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tsejtu mishusha pujchinu jali bain tele', naa ya' llashkapanu bain juntsa uru pinbakikii jumu teeka' eede chachilla' mitya inu kalen jimula naajuwa deeñuba juntsangue' inchin juu tirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tsejtu inchin juu tirendu menestenguentsumi muli katu, chachilla' mitya inu kalen jimu ruku tirede, Aarónnu juntsa muli ya' mishusha yuutsuutu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Naa ya' nalanu bain mikatu, bareree tainsha punu jali pande' eede. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Tsejtu naa Aarónnu bain, naa ya' nalanu bain ajpeendee chuwachi ura' teede, tsenmin naa mishpukasha pujchinu jali bain ura' teekade. Entsanguitaa naa-uwanuba tsa tsanguemu chachi detirenu juve. Tsenmalaya naa-uwanuba yala tsa tsanguen chunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Tsejtu bene, iba wa'dinu yapaya juukapasha llupu kaa wagara tajide, tsenmala Aarón bain, naa ya' nala bain animaa mishpukanu tyaapachi ta'ka' tadinudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Tsejtu junu in ajuunu, iba wa'dinu yapaya juukapanu juntsa animaa tu'de. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tsanguetu animaa asa katu, ufeenda tsure' ju'kenunu kachu muute usnamulanu tyamishuchi munguide, tsenmin laramu asaya ufeenda tsure' ju'kenu kelunu yuutsuude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tsejtu peshilitala bain, naa ajpatala bain, naa reñuñutala muli mai'namu bain, naa reñuñula bain dekatu, ufeenda tsure' ju'kenunu tsure' ju'kide; ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","tsaaren animaa alla bain, naa ya' kika bain, naa ya' pe bain, kajna' dechunu avindalaa ju'kiide, matyu chachilla' mitya inu kalen jimula' ujcha' mityaa tsangue' ju'kentsu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tsenmin llupu uveja pallu jumulanu main katu, Aarónnu bain, ya' nalanu bain animaa mishunu tyaapachi ta'kakare' ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","tu'de. Tsejtu ufeenda tsure' ju'kenunu kumuinchi ya' kelu kelu asa tya'kide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tsanguetu bene animaa petse petse jungue dedaatu, ya' peshili juula bain, naa ya' neepa juula bain pitsaade, tsejtu alla petse petse juu ya' mishuba tsuinsha bulu tsuude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tsejtu ufeenda tsure' ju'kenu jandala juntsa millangue ju'ke' keewaade, in mityaa tsangue' inchi mika ura' aindyu ishkakaanu tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Tsejtu bene llupu uveja kamain mangatu, juntsanu bain Aarón ya' nalaba animaa mishunu ta'ka' tadedisa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tsenmala animaa tu'de, tsejtu asa jayu katu, Aarónnu bain, naa ya' nalanu bain yala' urandya punguinu pele mutusha bain, naa urandya aa tyamishunu bain, naa urandya aa nemishunu bain munguide. Tsejtu laramu asaya ufeenda tsure' ju'kenunu kelu kelu detya'kide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Tsejtu ufeenda tsure' ju'kenu jandala tyatyumu asa bain, naa inchin juu tirendu menestenguentsumi muli bain jayu katu, Aarónnu bain, naa ya' jalitala bain tya'kide, tsenmin naa ya' nalanu bain, naa yala' jalinu bain tsaren kide. Entsanguenmalaa Aarón bain, naa ya' nala bain, naa yala' jali bain inchin juu tene tiyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tsejtu bene llupu uvejanu ya' muli kade: naa nepelesha chumu muli bain, naa peshilitala mai'namu muli juula bain, naa ajpatala muli mai'namu bain, naa pai reñuñu bain, naa reñuñutala muli mai'namu bain, naa urandya enbu alla bain kade, chachilla' mitya inu kalen jimu rukulanu inchin juu tiwarendu menestenguentsumi animaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tsenmin pujkikaantsumi putyu pan, in ajuusha pishkalinu pumula kalaade: da'pukakaa pan bain main, naa mulichi yandaa jumu pan bain main, naa pan kaa paki bain main katu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Aarón' tyaapanu bain, naa ya' nala' tyaapanu bain kumuinchi entsa detsuunu juve, tsejtu yalanu in ajuusha ufeenda yali' keewaakaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Tsejtu bene yala' tyaapanu demangatu, in ajuusha ura' aindyu ishkakaanu ufeenda tsure' ju'kenunu ajke' animaa ju'ke' keewara jandala deju'kide. Entsa ufeendaya in mitya ju'ke' keewara juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Tsenmin Aarónnu inchin juu chachi tirendu menestenguentsumi llupu uveja tenbapu katu, in ajuusha ufeenda yali' keewaade. Tsenñu juntsa alla petsee ñuchi junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tsejtu chachilla' mitya inu kalen jimu detiwaandu menestenguentsumi llupu uveja tute' keewara allanu pai petse vele' tadide. Entsa alla jumula, mainya tenbapu alla ufeenda yali' keewara jumaa juntsave, tsenmala kamainya enbu alla vee mujtu vele' tsuuñu jumaa juntsave. Tsaju' tenbapu allaya Aarónchi junmala, enbu allaya ya' nalachi junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Tsejtu entsa alla jumulaa Israel chachilla, yala iba ura' mandinu animaa tute' keewaantsumiya Aarónnu bain, naa ya' nalanu bain naa-uwanuba kuwanu dejuve. Tsaju' entsaa jumulaa naa-uwanuba tsaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Tsenmala Aarón' pananu jali inchin juu jumulanuya, yanu sera' jimu chachillaa manganu dejuve ya peyanmala, tsaaren yala chachilla' mitya inu kalen jimu ruku tiyandaa, juntsaa taawasha kenu uuden kandu pananu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Tsaju' Aarónnu sera' jimu ruku chachilla' mitya inu kalen jimula' aa bale ruku mandiya' Aarón naaken chumuwaañuba tsanguen chu', iba wa'dinu yapayasha taawasha mannu vimiya mandishpai malu' mitya entsa jali panaa tsananu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Tsejtu bene inchin juu tirekaandu menestenguentsumi llupu uveja alla katu, inchin juu tenasha taji' alla akaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Tsenmala Aarón, ya' nalaba juntsa alla bain, naa pishkalinu pumu pan bain iba wa'dinu yapaya vinu juukapasha finu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Tsaju' entsa alla bain, pan bain finuu dejuve, matyu yala inchin juu detira', naa chachilla' mitya inu kalen jimu ruku bain tiyanu uwanu, yala' ujcha manbitsaanu keewaramuwaañu' mitya. Tsaaren entsa panda, vee chachi juulaya finu dejutyuve, inchin juu dejuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Tsenmala naa alla bain, naa pan juu bain ayunchi fikenui larañuba, jupenchi kikenu dejuve. Tsaju' juntsa panda inchin juu juñu' mitya, mu bain defityusa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Tsa' mitya iya naatiñuba Aarónnu bain, naa ya' nalanu bain tsanguide. Tsejtu yalanu bale chachi tirendu, mandishpai malu tsaandene kide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Malumere llupu kaa wagara main tute' keewaawaakide, yala' ujcha' mitya manbitsalanudetsu; tsenmin naa ufeenda tsure' ju'kenunu bain inchi ura' kuraa mandirenu menestenguentsumi muli yuutsuude, inchin juu tirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Tsaju' mandishpai maluya ufeenda tsure' ju'kenunu ujcha' mitya animaa tute' keewaanu juve; entsanguenmalaa ufeenda tsure' ju'kenunu inchin juu tiyanu tsuve. Tsenñu tyee juntsanu tyuika' bain inchin juu tiya tiyainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Naa-uwanu bain malumere llupu kaa uveja ma añu juu tene pallu tute' ufeenda tsure' ju'kenunu jupe jupekenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tsejtu mainya kepenene ju'ke' keeware', kamainya kependu'kainsha ju'ke' keewaakenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ajke' kaa uveja ju'kentsumiya pan kenu llujpe kayu ura tene pai kilu ka', ulibu muli bain kayu ura tene ma litru ka' yande' keewaanu juve, tsenmin ma litru binu bain ka' yuutsure' ufeenda juu keewaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tsejtu kependu'kainsha kama llupu kaa uveja keewaandu bain, naa pan kenu llujpe bain, naa binu bain yuutsure' keeware' kepenene naake'ba tsaren mannu juve inu ura' tyawaanu aindyu ishkakaanu ju'ke' keewaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Tsaju' entsa inu keewaanu tute' ju'kenu ufeendalaa naa ñulla bain, naa ñullanu sera' jimula bain in ajuusha naa-uwanuba tsanguentsunu dejuve, iba wa'dinu yapaya juukapasha; matyu iya junaa ñuba katawa' kuinda kiikenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tsejtu junaa iya Israel chachillaba katawanu tsuyu, tsenmala juntsa tenaya inchi tsamantsaa keewara jumu' mityan inchin juu jujuunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Tsejtu iba wa'dinu yapaya bain, naa ufeenda tsure' ju'kenunu bain inchin juu detirenu tsuyu, tsenmin naa Aarónnu bain, naa ya' nalanu bain inchin juu detirenu tsuyu yala inchi chachilla' mitya inu kalen jimu ruku deeñu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Tsenmin iya Israel chachilla' kejtsapala chutu, yala' Dios junu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Tsenmalaa yala mijanu dejuve naa iyaa, Yavé, yala' Dios, yaiba bulu chunaa yala Egiptosha dechuren mangalaamuñuba. Iyaa Yavé, yala' Diosyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Dios kayu pa' jindu, Moisésnu tsandimi: Tsenmin naa aindyunguikaantsumi ju'kenunu bain akasia chichi kikaade, juntsa aindyu jupe jupekenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Bare' mitya bain, naa bungu' mitya bain tsaren bareenu juve; kelumeemee ma tyabulu, tsenmala katyunchiya pai tyabulu junu juve, tsenmala aindyunguikaanu tsure' keewaanunu musnamu kachulaya tyuipujtu' ma chi lurachin dejuunu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tsejtu aindyunguikaantsumi ju'kenunu ya' jandala bain, naa taapai kelu jumula bain, naa kachula bain uruchi tene narai mai'tanu dejuve. Tsenmin ya' kuyitala uruchiren chuwa pijtekaran tsaju' mai'tanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tsenmin junu uru chuwa mai'ta panbeenu, uru tuti pu' pai kelusha main main puunu juve, tsejtaa junu pai tuti jumulanu pai cha'li jumula main main ñalla' pu' juntsanu ka' yali' taji tajiinu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Juntsa cha'li jumula akasia chichee ju', uruchi tene mai'taanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tsejtu bene, daayadimu jali yananu ajuusha, matyu babuu tsunu ajuusha, tsandityu'ba, babuunu dukaanu ta'pa ajuusha, iya ñuba katawanu juuwashu juntsa ajuusha entsa aindyunguikaantsumi ju'kenunu taji' tsuude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Naa-uwanuba kepenenemee lanpaa sekuwanguenu uwanu Aarón ju'ke' aindyunguikaantsumi ju'kenunu aindyunguikaantsumi jupe jupekenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Tsenmin kependu'kainsha lanpaa chakaanu uwanu bain maju'kenu juve. Tsaju' ñullanu sera' jimula naa-uwanu bain tsa tsanguentsunu dejuve in ajuusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Entsa aindyunguikaantsumi ju'kenunu deechu' ki'mujchin aindyunguikaantsumi ju'kenu jutyuve, naa animaa tute' ju'ke' keewara juu bain, naa pan kenu llujpe juu bain, naa binu juu bain entsanu yuutsure' ufeenda keewaanu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aarón ujcha' mitya tute' keewara animaa asa katu, añumee ma bijee juntsa asa tavi' aindyunguikaantsumi ju'kenu kachu jandala mungue' inchin juu mandirenu tsuve. Tsenñu entsa aindyunguikaantsumi ju'kenunu inchin juu jujuunu tsuve. Tsaju' ñullanu sera' jimula bain naa-uwanuba ma añumee tsa tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yavé manen Moisésnu patu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Israel chachilla nan dejuñuba mi'nu uwanu, yala main main yala' chun mitya inu tyeeba kuwanu dejuve, tsejtaa entsa nan dejuñuba mike' keenu tyan mityan depeyainuu peya jui'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Naajula bain mi'nu uwanu mikamulaya inu lushi kuwanu dejuve, lushi kenu jeru tene man gramu, tsandityu'ba, paitya jera, in pupunanu yapayasha naake adyu' yangaamu deeñuba tsangue' keñuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Naajula bain 20 añu juu ajkesha mikamulaya inu tsa tsangue lushi kuwanu dejuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","tsejtu tutan jutyu ñulla' chun mitya inu lushi kuwatu, naa tarukula bain, naa purela bain tsaren kuwa', mu bain man gramu tene kuwanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tsa' mitya Israel chachilla tutan jutyu yala' chun mitya kuwanu lushi katu, iba wa'dinu yapayasha tyeeba kenu kuwade, tsejtaa tutan jutyu yala' chun mitya kuwamu deeñuba iya Israel chachillanu tenga tengakenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Tsejtu Yavé manen Moisésnu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Brunsechi aa paila main kikaade, naa ya' chujtintsumi bain brunsechiren, junaa tyaapa bain, naa neepa bain pitsaanudetsu. Tsejtu ufeenda tsure' ju'kenunu, iba wa'dinu yapayaba pensangue', kejtaa tenatala chujtike', pi pukenu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","tsenmala Aarón bain, naa ya' nala bain junu pi kalare', yala' tyaapa bain, neepa bain pitsaanudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tsejtu naa-uwanu iba wa'dinu yapayasha vi-i' bain pitsaatsaakenu detsuve; tsenmin naa-uwanu ufeenda tsure' ju'kensha kalen ji', in ajuusha ju'kenu ji-i' bain tsaren kiikenu detsuve. Entsanguiikishu juntsaa peyan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Tsa' mitya yala peyan dejutyu, naa-uwanuba neepa bain, tyaapa bain manbitsaatsaa kenu dejuve. Entsaa jumulaa naa-uwanuba Aarón bain, naa yanu sera' jimula bain tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yavé, Moisésnu manbatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Kayu aindyu jumula ñuren demi'ke' kade: kayu ura mira mandishmain kilu, kanela pen kilu, ñañi keraa aindyu bain pen kilu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","tsenmin kasiaya mandishmain kilu kade, in pupunanu yapayasha naake adyu' yangaamu deeñuba tsanguitu, tsenmin ulibu muli bain pen litru medya kade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Tsejtu entsangue dekamee inchin juu tirendu menestenguentsumi muli kide, pindyupi kiikemula naaketaa kemu deeñuba tsanguitu. Entsaa inchin juu tirendu menestenguentsumi muli junu tsuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","tsejtu entsachee iba wa'dinu yapayanu bain, naa iya chachillanu veta' veta' tsanguedaa tiñu keewara babuunu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","naa tyeeba tsuunu ta'pa llaijkaranu bain, naa junu tiba talantsumi jumulanu bain, naa ñillu chujtintsumi usja'tee jumu aa lanpara yachi junu tiba meneste-imulanu bain, naa aindyunguikaantsumi ju'kenunu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","naa ufeenda tsure' ju'kenunu yachi junu tiba meneste imulanu bain, naa brunsechi aa pailanu bain, tsenmin ya' chujtintsuminu bain yuutsuude. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tsanguitaa inchin juu tene detirenu tsuve; tsenmala tyee juntsanu tyuikake' bain inchin juu tene tiya tiyainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Tsenmin juntsa muli naa Aarónnu bain, naa ya' nalanu bain yuutsuude, tsejtaa inchin juu detire' chachilla' mitya inu kalen jimu ruku detirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tsenmin Israel chachillanu entsandide: Entsa muli jumaa inchin juu tirendu menestenguentsumi muli junu tsuve, naa kumuinchi ñullanu sera' jimulachi bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tsaju' entsa muli, ne na'baasa rukulanu juu yuutsuutyude, tsenmin ne vee muli bain entsangue mangue' tadityude. Entsa muliya inchin juu kurave; tsaañu' mitya inchin juu kure' talan chudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Tsaaren mulaa entsangue muli demanshu juntsaa, tsanguityu'ba, ne na'baasa chachinu yuutsuushu juntsaa, Israel chachi jutyu kura' juka'laranu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Moisésnu Yavé manbatu tsandimi: Entsa aindyu jumula bain paree tsa tsangue kade: estakte bain, anbar bain, galbanu bain, tsenmin aindyu chi pillu tene juu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tsangue' tyayuba yandetu, pindyupi kemula naake buute' yandemu deeñuba juntsangue' ju'ke' aindyunguikaantsumi tene jungue kide, tsenmala inchin juu junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tsejtu mantsaya ñiyuyuke iitu, babuu chunu ajuusha tsuude, iya chachillaba wa'dinu keesha, ura pañuya, iya ñuba katawainu juuwashu junga. Entsa ju'ke' aindyunguikaantsumi jumu kayu ñuichi tsamantsa bale ju' inchin juu junu tsuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","tsaju' ñui bain menestenguenu tya' vera juntsa keraa mantyudei. Entsa ju'ke' aindyunguikaantsumiya inchin juu ju', ñuichiya jaiba kanu jutyu juve, inchin juu jutu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Tsaanuren mulaa juntsangue mangue' yachi menestenguenu kishu juntsaa, ya' chunu pebulu kejtsapala juka'laranu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Manen Moisésnu Yavé tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Judánu sera' jimulanu Hur' paña, Urí' na, Besalelnaa mi'ke' kayu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","tsejtu yanu ne chachillaya ken jutyuu juu kenu bain, naa aseetaju pensa bain, naa minu pensa bain kuwa', maalin pensachi ti bain uukeraa kiikenu tireyu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","tsenmalaa ti kenuu juñuba tsangue muute deke', naa uruchi bain, naa lushi kenu jeruchi bain, naa brunsechi bain ti taawashaba kiikenutsu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","tsenmin yaa naake kenuu juñuba dejuli', naa bale shupuka pukenuu juñuba punu tsuve, tsenmin naa ta'pachi bain taawasha ke', ti juula bain kiikenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tsenmin yanu kivetenuya Dannu sera' jimu, Ahisamac' na, Oholiabnaa puyu. Tsenmin kumuinchi tsaatala taawasha kemu rukulanu kayu jungajte bibu' pensa kuwayu, iya naakide ti' kikaañuba tsangue kenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Entsaa kenu dejuve: in yapaya jumula bain, iya chachillanu veta' veta' tsanguedaa tiñu keewara babuu bain, juntsa babuunu du'namu ta'pa bain, naa tiba in yapayasha meneste-imu juula: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","naa tyeeba tsuunu ta'pa llaijkara bain, naa junu tiba meneste-imula bain, naa uruchi tene juu ñillu chujtintsumi usja'tee jumu aa lanpara bain, junu tiba meneste-imula bain, naa aindyunguikaantsumi ju'kenunu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","naa ufeenda tsure' ju'kenunu bain, naa junu tiba meneste-imula bain, naa brunsechi keñu aa paila bain, naa ya' chujtintsumi bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","naa detsejte' keñu jali jumula, inchin juu jumu chachilla' mitya inu kalen jimu Aarónchi pananu jali bain, naa ya' nalachi chachilla' mitya inu kalen jimula' kenu taawasha kendu pannu jali bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","naa inchin juu tirendu menestenguentsumi muli bain, naa ju'ke' aindyunguikaantsumi chachilla' mitya inu kalen jimula' vinu sukusha ju'kentsumi bain kenu dejuve. Tsa' mitya iya naakide tiñuba yalaa kumuinchi tsangue kenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Moisésnu Yavé manbatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Israel chachillanu patu entsandide: Iyaa tsangue' saaduma lekanu malu tireñu jumunuya ñulla bain, naa ñullanu sera' jimula bain naa-uwanuba lekanu dejuve. Entsaa iya Yavéve ti' keewara juve, tsaju' entsaa kiikendetsunmalaa naa iya, Yavéya, ñullanu inchi mi'ke' kañuba mijanudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Saaduma lekanu maluya ñuichi inchin juu malu junu tsuve, tsaañu' mitya balenguunu dejuve. Tsaaren mun juntsa malunu balenguutyu' lekatyuñuba juntsa tutanbera inu tsuve. Tsenmin mun juntsa malunu taawasha ke'ba, Israel chachi jutyu kura' juka'laranu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mandishmain maluya taawasha kenuu dejuve, tsaaren mandishpai malu tiyanmalaya saaduma lekanu malu ju', inu balengure' keewaanu malu junu tsuve. Tsaju' mun lekanu malunu taawasha ke'ba tutanbera inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Tsa' mitya iya chachillanu veta' veta' naakenu pañuba juntsangue' saaduma lekanu malunu Israel chachilla inchin juu malu kure', balenguunu dejuve. Tsaju' yalanu sera' jimu chachillaya naa-uwanuba tsanguentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Entsanguii dekishu juntsaa, iya Israel chachillaba naakenu juñuba tsanguenu mandengakara jujuunu tsuve, matyu iya mandishmain malunu naa selu bain, naa tu bain dekitu, mandishpai malunuya lekañu' mitya, timi Yavé. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Tsejtu Moisésnu Sinaí kuyisha Dios depa' dyatu, ya' tyamishuchin pai shupu' ta'panu depiike' ya naaken chudei ti'ba juntsa depillaa kuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Tsejtu Moisés kuyisha lutun te' manbajaindyuñu, Israel chachilla Aarón' junga jitu tsandila: Kujpa', lalanu dyus muute ke' kunun tsaave, tsenmalaa ajkesha miya' miinutsu, matyu lalanu Egiptosha mangalaamu Moisés tyee iñuba mijakeetyuñu' mitya, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Tsenñu Aarón pakatu: Tsaaya, ñulla' shinbulanu bain, naa ñulla' na'malanu bain, naa unbee nalanu bain uru pun-erara pumulanu delaakare' taja' inu kuwakai, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tsenñu kumuinchi uru pun-erara pumulaya delare' Aarónnu taji' kuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tsenñu katu uru depi'ware', urunu taawasha kiikenu jeruchi ma wagaa muute kemi. Tsenñu chachilla tsandila: Israel chachilla, entsaa ñulla Egiptosha dechuren mangalare' maamu dyusve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Tsenñu Aarón chachilla naa-indetsuñuba keetu, wagaa muute ajuusha ufeenda tsure' ju'kenunu main ke' chujti' ui'tu, tsandimi: Ayu maluya, Yavé' mitya fandangu kidaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tsejtu juntsa ayunchi dishkepenene dekujtu, animaa tute' ju'ke' keewaala, tsenmin naa ufeenda juula bain keewaala Diosba ura' mandiyanu. Tsejtu bene chachilla dechudi' panda fi', kujchila, tsanguetu bene na'baasa sunden puinu kujpala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Tsenñu Moisésnu Yavé tsandimi: Manbajtyaide, ñu Egiptosha mangalaakishu juntsa chachilla firu' juu detiya deive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Iya naaken chudei tiñuba juntsanu jei demanbashñuve, tsejtu uru tene depi'ware', ma wagaa muute ketu, juntsanaa aawa kure' dekeeware', naa animaa juula bain detute' keeware' entsandindetsuve: Israel chachilla, entsaa ñulla Egiptosha dechuren mangalare' maamu dyusve, tiidetive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Tsenmin Moisésnu Yavé kayu pandu tsandimi: Entsa chachilla naadejuñuba iya keekeenayu, tsenñu uwain jaiba pañu meetyu chachi deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Tsa' mitya umaya tsamantsa ajaa tenñu yalanu millangaanu juñu, inu daatadinu kityuka. Tsaaren ñunuya tsamantsangue chachi deseewaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tsenñu Moisés, ya' Dios Yavénu ya' ajara jayu mandya'kasa tya' patu tsandimi: Yavé, ¿nenñaa ñu' chachilla Egiptosha dechuñuren ñu' pudeechi ke' mangalara jumulanuba, tsamantsa ajaatya' firu' kenujtuuyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ñu tsanguishu juntsaa, Egipto' chulla entsandinu dejuve: Diosya entsa chachillanu butyu tenasha detu'nu ju' mityaa mangalaañuve, matyu tsangue' detute' pirenu ju' mityaa tsanguiñuve, tinu dejuve. Tsaju' ñu ajaa tenñaa chachillanu firu' kenu pensa kendu bain, juntsa pensaya manbirede. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ñunu meengue' ñuchi tiba kiikemu chachilla, Abrahamnu bain, Isaacnu bain, naa Israelnu bain mandengakide. Ñuren maali paka' tsanguenbera kenu tsuyu titu, yalanu entsandimuwaave: Ñullanu sera' jimu chachillanu tsamantsangue seeware', selusha makara chun tsangue seenguikaanu tsuyu, tsenmin ñullanu sera' jimulanu naaju tu jumulaa kuwanu pamuwa ju'ba juntsa tu dekuwanu tsuyu, tsenmala yalaa deka' naa-uwanuba yaichi juu tananu dejuve, timuwaave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Tsenñu Yavé, naa ya' chachillanu firu' kenu pensa pa'ba, tsanguen jutyu mashuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Tsenñu Moisés kuyisha puturen manbajantsumi pai shupu' ta'panu Dios naaken chudei tiñuba juntsa palaa kelush kelush pillaa jumula taju. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Juntsa shupu' ta'pa Diosren kemi, tsenmin yaren junu depiikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Chachilla jutindetsuñu Josué meetu Moisésnu tsandimi: Vinguenu uranu chachilla naati ui'mu deeñuba kajna' chuinsha juntsandindetsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Tsenñun Moisés tsandimi: Vingue' puitu beesanguiñu bain jutyu, naa bensa-i' dellakintse'tuwara beesa bain jutyuve; entsaya vee beesave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tsejtu Moisés yala' kajna' chunu tenasha kalen miitu, naa uru wagaa bain, tsenmin chachilla bain beelangue' tsanguindetsu kata' ajaatyatu, ya' tyaapanu Diosa' lei pilla shupuka taa jinduren tusha deleetyatyukemi, kuyi demavitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Tsenmin juntsa uru wagaa ka', tsaa ñichi dejupeketu, ñiyuyuke de-ili', pisha deshajara' kepu', juntsa pi Israel chachillanu kushkaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Tsejtu Moisés, Aarónnu bain tsandimi: ¿Entsa chachilla ñunu tyee dekiñaa, ñu yalanu tsamantsangue ujcha lawaatunguiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Tsenñu Aarón pakatu: Bale ruku, inu tsamantsai ajaatyatyuka, ñuya mive naa entsa chachillaya firu' kenu pensan judeeñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Yala inu entsa detiwa: Lalanu dyus muute ke' kunun tsaave, tsenmalaa ajkesha miya' miinutsu, matyu lalanu Egiptosha mangalaamu Moisés tyee iñuba mijakeetyuñu' mitya, detiwa. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Tsenñu yalanu tsandiwayu: Tsaaya, mun uru detana'ba inu kuwakai, tiwayu. Tsenñu inu uru dekuwañu, ñinbaasha kepuñu, ¡entsa wagaa muute faave! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Tsenñu Aarónren tsanguikaañu, Israel chachilla na'baasa ne kikendetsu', naa yala' kundaalachi bain na'baasa depakaya' uukaviinuu judeeñu Moisés katatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","yala' kajna' chunu tena viviinsha uiditu entsandi ui'mi: ¡Mun Yavéba debuuna' bain iba buudijadei! timi. Tsenñu Levínu sera' jimu chachillaya kumuinchi yaba tene buudila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Tsenñu Moisés yalanu tsandimi: Yavé, Israel chachilla' Dios entsandive: Ñulla main main peeniya deka', veela pudenashu junga miji', kajna' chunu tena viviinu kapash kapash dapuitu, naa ñulla' naatala deeñu bain, naa ñuichi ura' keranu chachi deeñu bain, naa ñulla' yapaya keetala chumu deeñu bain, unbee nalanuya tu'dei, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tsenñu Levínu sera' jimu chachilla Moisés naakidei tiñuba tsa dekiñu, juntsa malunu 3.000 unbee rukulaa peyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Tsenñu chachillanu Moisés tsandimi: Ñullanu uma Yavé yachi tiba kiikenu tirenu mi'ke' kave; yaa ñullanu yachi ura' de-ikaave, matyu naa ñulla' kailla deeñu bain, naa ñulla' naatala deeñu bain, kundaa dekiñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Juntsa ayunchi chachillanu Moisés tsandimi: Ñulla tsamantsaa ujcha delave. Tsaañu bain, manen kuyisha Yavé' puinsha malunu tsuyu, tsejtaa tsanguekaanuutuya ñulla' ujcha' mitya manbitsaakaanu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tsejtu manen Moisés, Yavé' puinsha malutu tsandimi: Uwain entsa chachilla, uruchin dyus muute dekitu tsamantsaa ujcha delave. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Tsaañu' mitya ñuya yala' ujcha manbitsaade ti' u'tandinu tenve; tsaaren ñu yalanu ujcha manbitsaatyushu juntsaa, in mumu ñu' kiikanu piike' tanashu juntsanu mamushkide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Tsenñun Yavé tsandimi: Naajulaa inu ujcha delañuba, juntsalanun in kiikanu mamushakenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tsa' mitya miitu, iya nukaa juntsa chachillanu miya' jide tiñuba, junga miya' jide. In anjee ñunu miya' jinu tsuve. Tsenmin yalanu taaju iwaanu malu janmalaya, iya yala' ujcha' mitya taaju de-iwaanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tsejtu Yavé chachillanu taaju depuiwaami, Aarónnu tsangue' wagaa muute dekikaañu, juntsan mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yavé manen Moisésnu tsandimi: Entsa tenanu malu' miide, Egiptosha mangalaañu chachillaba. Tsejtu iya Abrahamnu bain, Isaacnu bain, naa Jacobnu bain, yalanu sera' jimu chachillanu naaju tu jumaa kuwanbera kenu tsuyu ti' pamuwaañuba junga miya' jide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Iya ma anjee ñulla' junga ajkesha eenu tsuyu ñullanu miya' jinutsu. Tsenmin iren junga Canaánnu sera' jimulanu bain, Amornu sera' jimulanu bain, Hetnu sera' jimulanu bain, Fereznu sera' jimulanu bain, Hevenu sera' jimulanu bain, naa Jebúsnu chumulanu bain dejuka'laanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Tsejtu tu naranainsha, naa chu'pi bain, naa mishki bain pi ju' pilla' jin tsainsha jidei. Tsaaren iya ñuiba bulu jin jutyuyu, iya ñuiba bulu ne jiinduya, ñulla pañu meetyu chachi deeñu' mitya, kayu junga jindetyun detuta'ba inu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Tsenñu kumuinchi chachilla entsandiñu demeetu, yuj daran kuipa pu' pañu' mitya pure' llakindyaila. Tsejtu muba unnanguindetyu', uruuñuba panaindyula, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yavé Moisésnu entsandiñu' mitya: Israel chachillanu entsandide: Ñulla pañu meetyu chachi deeve. Ñuiba jayu' mityaaba bulu puna'bananuutuya, ñullanu millangaanu juyu. Tsa' mitya ñulla' pudeeshu juntsa uru dekalaadei, tsenmala mijanu tsuyu ñullanu naakenu ju'ba, tiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tsenñu Horeb kuyibi Israel chachilla unnangue' uru juu manbanan jutyu shuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisés yapaya katu, yala' kajdi' yapaya ke' chunu avindala chujti jijiimi, tsejtu Diosba wa'dinu yapaya mumu pumi. Tsenñu mun Yavénu pake'meenu tya'ba, juntsa yapayasha ji' pake'meemeekila, yala' kajdi' yapaya ke' chunu avindalaa chuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Tsejtu naa-uwanu Moisés Diosba wa'dinu yapayasha jintsuñuba, kumuinchi chachilla dekujpa' yala' yapaya juukapa ajuusha uyu uyudila, ya kayu vindyuya keena de-uinatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tsenmala Moisés juntsa yapayasha vinmalan ñivish lura pajtya', juntsa juukapasha dishdiji dishdijiimi, tsenmala Yavé Moisésba papatintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tsenmala ñivish lura pajtya' yapaya juukapanu dishdijinmala, naaju chachilla bain main main yala' yapaya juukapasha tele teledila, Diosnu aawa kure' keewaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yavéya Moisésba ne chachilla ura' keraatala naa-i kaju'talai uiditaa kuinda kemu deeñuba tsangue kuinda kiikemi. Tsejtu Moisés kuinda dekemin yala' yapaya ke' chuinsha miji mijiimi. Tsaaren Moisésnu tiba kive'mu Nun' na, Josuéya, naa-uwanuba Diosba wa'dinu yapaya juusha tsa tsanami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés Yavénu tsandimi: Ñuya inu entsa chachillanu miya' jimishtide tive, tsejturen munaa iba bulu eenu ju'ba juntsaya wandindyuve. Tsenmin ñuya inu ura' kerayu timu ju', ñu' ajuusha mika ura' katawamu rukuve, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Tsaaren uwain tsaaba juñuya, ñu tyee kenu ju'ba inu mijakaaka, tsenmalaa iya ñunu ura' keengue' jintsu', ñuchi ura' katawantsunu. Tengaya jude naa entsa chachilla ñu' chachi deeñuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Tsenñu Yavé pakatu: Iren ñuba bulu jintsunu tsuyu; tsejtu ñunu tiba bulla jutyu chunu tirenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Tsenñu Moisés pakatu: Tsejtu ñuren lalanu miya' jin jutyushu juntsaa, enu mangala' me-eetyuka. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Matyu ñuren lalanu miya' jin jutyushu juntsaa, ¿nejtaa mijakeenu jun naa ñuchi ura' katawa' jinduba? Ñu miya' jintsushu juntsaa, naa ñu' chachilla bain, naa i bain kayu vejan chachillaba uwain vera' deju'ba mijanu dejuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Tsenñu Yavé pakatu: Ñu entsandishu juntsa bain uwain tsanguenu tsuyu, ñunu iya ura' kera' mitya, tsenmin ñuya inchi ura' katawamu rukuñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Tsenñu Moisés patu: Tsaaya, ñu' tsamantsaa jumu inu keewaaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Tsenñu Yavé tsandimi: Iya naaju ura ju'ba juntsaa jumu kumuinchi ñu' ajuusha puitenu tsuyu, tsenmin ñu' ajuusha in mumu Yavénu pakanu tsuyu. Iya munu tenbi keenu tenñuba tsanguenu tsuyu, tsenmin munu lastema' keenu tenñuba tsanguenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Tsaaren uwaindiyu, in kajuuya katan jutyuve, matyu mu bain in kajuu katashu juntsaa, chun jutyuñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tsejtu Yavé entsa bain tsandimi: Keekide enu in kelunu ma tena juve; kujpatu, entsa shupu' jandala uidide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Inchi tsamantsaa keewara jumu puinmala ñunu shupu' dijkinu pukenu tsuyu, tsejtu in tyaapachi dishu' tadinu tsuyu iya pullanbera. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Tsejtu dishu'tadinu tyaapa bene manganmalaya in beenbushun kataaketu, in ajuuya katan jutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Tsejtu Moisésnu Yavé tsandimi: Kasa shupuka pinbakikii kaspele naaju deeñuba ñu juntsangue demangu'de; tsenmala ajke' shupu' lepa, ñu' leetya'keñu jumulanu naaju pillawaañuba juntsaren manbiikenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Tsenmin Sinaí kuyisha ayu kepenene malunu ura' dekide, tsejtu kuyisha kayu aa katyu tenasha lu' inu katawade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Muba ñuba bulu lanu dejutyuve, mu bain entsa kuyisha pundejutyuve; tsenmin naa uveja juula bain, naa chibu juula bain, naa wagaa juula bain kuyi ajuusha tape fin punu dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Tsenñu Moisés pai shupu' ta'pa kaspele naaju deeñuba juntsangue demangu'mi. Tsejtu juntsa ayunchi dishkepenene kujpatu, shupu' ta'pa deka' Sinaí kuyisha malumi, Yavé naakide tiñuba tsaitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Tsenñu Yavé ñivish luranu pajatu junu Moisésba bulu pumi, tsejtu maalin ya' mumunu pa', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Moisés' ajuusha daran palaachi pasai puitu tsandimi: Yavé, Yavé, ura Dios, tenbityamu, jei kidandai paijtyu Dios, munuba estyamu, anbukityu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","naa-uwanu' mityaba estya' jintsumu Dios, naa firu' dekiñu bain, naa kundaa dekiñu bain, tsenmin ujcha dekiñu bain, manbitsaamu juve. Tsejturen firu' kemulanuya taaju iwarei'mujchiya puitetyu Diosve. Tsaju' ya' apala' ujcha' mityan taaju de-iwaamuve, naa ya' nalanu bain, naa ya' pañalanu bain, naa ya' tyuipañalanu bain, naa ya' tyuipaña' nalanu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tsenñu Moisés teledi' ya' mishu tusha tapa'kanbera jeke waike' aawa kure' keewaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","tsandimi: Bale Ruku, uwain iya ñuchi ura' katawamu juñuya, lala' kejtsapala pu', lalanu miya' jimishtika. Uwain entsa chachilla jaiba pañu meetyu deeve, tsaaren lala ti firu' kiidekiñu bain, ti ujcha kiidekiñu bain manbitsaade, tsejtu lalanu ñu' chachilla juu tireka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Tsejtu Yavé tsandimi: In palaanu ura' meedidei: Iya uma ñu' chachillaba veta' veta' ura' kenu tsuyu. Naaju chachillanu bain nuka tushaba keenbashiinuu ki'nu jumu ñullanu ke' keewaanu tsuyu. Tsenmala kumuinchi chachilla ñuiba chumulaya iya naakenuu juñuba keemijanu detsuve. Matyu tsamantsa jeetyainuu jumu ñulla' kejtsapala dekenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Iya uma ñullanu naatiñuba tsa tsanguidei, tsenmala iya naa Amornu sera' jimulanu bain, Canaánnu sera' jimulanu bain, Hetnu sera' jimulanu bain, Fereznu sera' jimulanu bain, Hevenu sera' jimulanu bain, tsenmin Jebúsnu chumulanu bain ñulla' kejtsapala dejuka'lare' eenu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Pashkayajtu dechu' ñulla' viinu deeshu junga chumulaba, ti bain veta' veta' ura' kenu ti' tsanguenu tiyatyudei, tsenmalaa yala tyee kemu deju'ba ñullanu tsangue' firu' kikaakenuu jui'nudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Tsa jutyu', ñulla yaichi ufeenda tsure' ju'kenunu bain, naa shupukachi keñu dyus muute juu uinamulanu bain, tsenmin yala' dyus Asheráchin juu chi chumulanu bain desenaa-eekidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Naaju dyus jumulanuba teedi' aawa kure' keewaatyudei, matyu iya tsamantsa selandyamu ju', in mumuren selandyamu Dios mumuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Entsa tenasha chumulabaya tiba veta' veta' ura' kiiken chunu tiyatyudei, tsandenna yala yala' dyus jumulanu balenguunu dejinmala, ñui bain yaiba bulu jijiinuba junu dejuve, tsenmin yala' dyus jumulanu tyeeba detute' keewara alla bain defimishtinmala, ñui bain yaiba buudi' fi'banguenuu dejuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","tsa jutyu'ba, yala naa yala' na'ma judeeñu bain, ñulla' nalaba debuute' chujtinmalaya, juntsa na'mala yala' dyus jumulanu aawa dekure' keewaajinmala, ñu' nala bain yala' dyus jumulanu deteedi' aawa kure' keeware' ujcha lalainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Naa-uwanuba ne ti jeruuñuba depi'ware', juntsanaa dyus kityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Pujkikarentsumi putyu pan fifikenu fandangu kenu dejuve iya ñullanu naakidei tiñuba tsanguetu. Mandishpai malu' mitya fandangu kenu dejuve, tsejtu pan bain fintsumiya pujkikarentsumi putyu juuya fifikidei. Entsa fandangu kemiya Abib chu'chayanu naaju malutalaa tsanguenuu juñuba kenu dejuve, juntsa chu'chayanaa Egiptosha chutun mala' maamuwa de' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ñuichi ajke' llupu kailla jumulaya inchi junu detsuve, naa wagaa kailla juula bain, uveja kailla juula bain, naa chibu kailla juula bain inchi junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tsaaren buru kaana ajke' kayamu llupunuya, uvejabaa, tsanguityu'ba, chibubaa vete' tute' keewaanu dejuve, tsaaren mavetei'shu juntsaa, kutu dyaityuinu dejuve. Tsenmin ñuichi ajke' na unbeena kayamunu ñuichi mandirenuya, main main jumula' mitya inu ufeenda kuwanu dejuve. Tsaju', ne mun inu ja' keeja' bain tiba tajtuuya jan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Mandishmain maluya taawasha kidei, tsaaren mandishpai malu tinmalaya lekadei, naa tyeeba wajkikendu bain, naa pu' tinbu iñu kakendu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Tsenmin Semana tinu fandangu bain kidei, ura pañuya, trigu de-iñu ajke' kandu bain, naa añu de-insha puka de-i' puiñu kandu bain fandangu kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Kumuinchi unbee rukulaya ma añunu entsa pen fandangu jumulanu in ajuusha, matyu Bale Ruku Yavé, Israel chachilla' Diosa' ajuusha jijiinu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Tsaju' vejan chachillanuya ñulla' chundala dejuka'lare' eetu, ñulla' tu kayu aawa tiwaanu tsuyu. Tsenmalaa naa ñulla in ajuusha, matyu Yavé, ñulla' Diosa' ajuusha, ma añunu entsa pen bijee dejiñuba, ñulla' tu mujkere' manganu tyan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Naa-uwanu animaa tute' keeware'ba, ya' asa, pujkikarentsumi puu panba buungare' keewaanu jutyuve. Tsenmin naa Dapulla' livee kiñu fandanguchi finu animaa larañu bain, ne ayunchi mafinu laakaanu kityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ti buikiya iñu bain, ajke' katu kayu ura tene ka', in yasha, matyu ñu' Dios, Yavé' yasha taji tajiinu dejuve. Chibu kaillanu ya' ama' chu'pichi akaatyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Moisésnu Yavé manbatu tsandimi: Entsa pa' puiñu palaa piikide, matyu entsalaa naa ñuba bain, naa Israel chachillaba bain iya veta' veta' tsanguedaa ti' pañu palaa deeñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Tsenñu Moisés junu Yavéba 40 malu, 40 kepe pumi tiba fityumujchi, naa pi bain kujchityumujchi. Tsejtu junaa shupu' pakinu veta' veta' tsanguedaa tiñu palaa piikemi, ura pañuya, Dios naaken chudei ti'ba juntsa paitya jumula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Tsejtu bene Moisés Sinaí kuyinu manbajtya' miintsumi, Dios naaken chudei tiñuba pai shupu' ta'panu juntsa pillaa taju; tsejturen ya Yavéba kuinda keñu' mityaa ya' kajuu pidyaañuren ya mijaindyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Tsenñu Aarón bain, naa Israel chachilla bain Moisés' kajuu pidyaañu dekata' yuj jeetyatu, jaiba yanu kalen ji'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tsenñuren Moisés yalanu ya' keesha mikañu, Aarón bain, naa kumuinchi balela bain Moisés' junga kalen dejiñu, Moisés yaiba kuinda kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Tsenñu bene kumuinchi Israel chachilla bain kalen dejiñu, Moisés kuinda kemi, yanu Sinaí kuyisha Yavé chachillanu titi kidei tiñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Tsejtu bene yaiba dekuindake' dyatu, ya' kajuunu ma jali viyakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Naa-uwanu Moisés, Yavé' puinsha ji' yaba kuinda kenu vintsu' bain ya' kajuunu vinamu jali manga mangakemi, tsejtu malataa maviya maviyakemi. Juntsai' malataa Israel chachillanu Yavé tyee kidei tiñuba wandi wanditimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Moisés malañu Israel chachilla ya' kajuu pidyaa dekatanmalaya, Moisés ya' kajuunu jali mavike mavikekemi. Tsejtu Yavéba kuinda kenu mavintsumee ya' kajuunu vinamu jali manga mangakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moisés kumuinchi Israel chachillanu dewa'kaatu tsandimi: Yavé inu entsanguikaade, tive: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mandishmain maluya taawasha kenu dejuve; tsaaren mandishpai malu tinmalaya Dioschin juu malu junu juve, tsaju' juntsa saaduma malunuya leka', Yavénu balengure' keewaanu malu junu tsuve. Mun juntsa malunu taawasha ke'ba tutanbera inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ñulla nuka dechu' bain, saaduma lekanu malunuya naa ñiba juikaanu dejutyuve, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés manen kumuinchi Israel chachillanu manbatu tsandimi: Yavé entsaaya kidei tive: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Yavénu kuwanu ufeenda wa'kaadei. Mun maalin kuwanu tya', ya' tenbukasharen tsanguiñu uraa tyashu juntsaa, naa uru juuñu bain, lushi kenu jeru juuñu bain, brunse juuñu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","naa lushmurara jilu juuñu bain, yamurara jilu juuñu bain, ungalala jilu juuñu bain, ura linu jilu juuñu bain, naa chibu ju juuñu bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","naa llupu uveja kika ungalalaa tiwara bain, naa pi animaa kika kayu naraa juula bain, naa akasia chi bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","naa ñillu chakaanu ulibu muli juula bain, naa Dioschin juu tirendu menestenguentsumi mulinu punu aindyu juula bain, naa ju'ke' aindyunguikaantsumi kenu aindyu juula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","naa unise shupuka juula bain, naa chachilla' mitya Diosnu kalen jimula' aa bale rukuchi tyaapa putyuu juwali jumu efud tinu jalinu mai'tentsumi bale shupukala bain, naa efud jandala tenbapunu teenu jai pakinu mai'tentsumi bale shupukala bain kanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Mun tyeeba narake kenu milaya deja', Yavé tyee kidei tiñuba millangue ke', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Diosa' pupunanu yapaya kidei: Diosa' pupunanu yapaya juusha pumu linu jali bain, naa yapayanu vikaantsumi ju jali bain, naa juntsanu vikaantsumi kika bain, naa beru juula bain, naa ta'pa juula bain, naa ta'pa deengaanu cha'li juula bain, naa yatyutya juula bain, naa yatyutyanu panbeesha deendanamu paki juula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","naa babuu bain, naa babuu yali' tanenu cha'li juula bain, naa ya' ta'pa bain, naa yanu daayadimu jali bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","naa tyeeba tsuunu ta'pa llaijkara bain, naa yachi yali' nentsumi cha'li bain, naa junu tiba tsumula bain, Diosa' ajuusha keewara pan bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","naa dangaanu ñillu chujtintsumi usja'tee jumu aa lanpara bain, naa yachi junu tiba meneste-imula bain, naa ya' lanpaa juula bain, naa lanpaa muli juula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","naa aindyunguikaantsumi ju'kenunu bain, naa yachi yali' tanenu cha'li juula bain, naa Dioschin juu tirendu menestenguentsumi muli bain, naa ju'ke' aindyunguikaantsumi bain, naa Diosa' pupunanu yapaya juukapanu daayadimu jali bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","naa ufeenda tsure' ju'kenunu bain, naa yachi brunse waaku bain, naa yachi yali' tanenu cha'li bain, naa junu tiba meneste-iimula bain, naa brunsechi jumu aa paila bain, naa ya' chujtintsumi bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","naa cha' neneinsha daalu'tekaanu jali juula bain, naa ya' yatyutya juula bain, naa yatyutyanu panbeesha deendanamu paki juula bain, naa junga cha' neneinu vinu juukapasha daayadimu jali bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","naa Diosa' pupunanu yapaya chi'kare' deengaanu jeru lura juula bain, naa cha' neneinsha chi'kare' deengaanu jeru lura juula bain, naa juntsa jeru lura juulanu teepunu chuwa juula bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","naa Diosa' pupunanu yapayasha vi' pannu detsejte' kiñu jali juula: chachilla' mitya Diosnu kalen jimu ruku Aarónchi pannu jali Dioschin juu jumu bain, naa ya' nala' pannu jali juula bain kenu dejuve chachilla' mitya Diosnu kalen jimu taawasha kenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kumuinchi Israel chachilla Moisésnu meena' miila, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","tsejtu bene mantsalaya uwain yala' pensashan Yavénu tyeeba kuwanu tya', ura' pensalaya demiji', Dioschi titi menesteñuba juntsa tajila, tsenmalaa Diosba wa'dinu yapaya bain, naa junga tiba meneste imula bain, naa Dioschin juu jali juula bain dekenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Tsejtu naa supula bain, naa unbee rukula bain yai tenen tsanguenu tyatu Yavéchi kuwanu, naa putsejta juula bain, pungui-erara juula bain, suutes juula bain, tuti juula bain, naa tiba uruchi keñu juula bain detajiila. Tsejtu kumuinchi juntsala uru detaji' Yavéchi kuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tsejtu naajulaa lushmurara jilu juu, naa yamurara jilu juu, naa ungalala jilu juu, naa ura linu jilu juu, naa chibu ju juu, naa llupu uveja kika ungalalaa tiwara juu, naa pi animaa kika kayu naraa juu tanamula bain taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tsenmala mantsalaya lushi kenu jeru juu, naa brunse juu tanamulaya Yavéchi kuwanu taji tajiila, tsenmala akasia chi tanamulaya juntsaa taji tajiila, juntsachi titi kenuu juñuba kenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tsenmala supula tyaapachi narake ture' kenu milaya, lushmuraraa jilu juu bain, yamuraraa jilu juu bain, ungalalaa jilu juu bain, naa ura linu jilu juu bain ture' taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Tsenmala mantsa supula bain kenu mideju' tsanguenu tyamulaya chibu ju deture' taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Tsenmala ma bulu chachimee washi washiken chumu bale rukulaya, unise bale shupuka bain, naa kayu vera bale shupuka bain taji tajiila, tsejtaa chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku' efudnu bain, naa tenbapunu teenu jai pakinu bain mai'tenu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","tsenmin naa Dioschin juu tirendu menestenguentsumi mulinu punu aindyu bain, naa ju'ke' aindyunguikaantsumi kenu bain tajila, tsenmin ulibu muli naa ñillu chakaantsumi tirenu bain, naa chachilla' mitya Diosnu kalen jimulanu Dioschin juu tiremu yuutsuuntsumi muli kenu bain taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tsaju' naa supula bain, naa unbee rukula bain uwain tsanguive'nu tya', Moisésnu Yavé naatiñuba juntsa kumuinchi tsai de-isa tyamulaya yai tenen Yavéchi tyee kunu ju'ba taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Tsenñu Moisés Israel chachillanu tsandimi: Ñuiba mijadei, Judánu sera' jimulanu Hur' paña, Urí' na, Besalelnaa Yavé mi'ke' kave, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","tsejtu yanu ne chachillaya ken jutyuu juu kenu bain, naa aseetaju pensa bain, naa minu pensa bain kuwave, ya maaliren pensachi ti bain uukeraa kiikenutsu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","tsenmalaa ti kenuu juñuba tsangue muute deke', naa uruchi bain, naa lushi kenu jeruchi bain, naa brunsechi bain ti taawashaba kiikenutsu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","tsenmin yaa naake kenuu juñuba dale', naa bale shupuka pukenuu juñuba punu tsuve, tsenmin naa ta'pachi bain taawasha ke', naa ti juula bain naraa kiikenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Tsenmin naa veela de-aseetandyai'ñu mijakaakenuu pensa naa yanu bain, naa Dannu sera' jimu Ahisamac' na Oholiabnu bain kuwave, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","tsenmin yalanu ti taawasha bain naakenuu juñuba tsangue kiikenu pensa kuwave, tsenmalaa naa tyeeba ke' chujtikenuu juñu bain, tsenmin naake kenuu juñuba muute bain kenudetsu, tsenmin naa lushmuraraa jiluchi bain, yamuraraa jiluchi bain, ungalalaa jiluchi bain, naa ura linuchi bain tiba narake' chujtindya'ba kenudetsu, tsenmin tsejte' ti muuteba kiikenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Tsa' mitya naa Besalel bain, naa Oholiab bain, naa kayu veela juntsaa taawasha narake ken chunu mila bain, Yavéren tsangue' aseetaju tireñu kenuu jumulaya, Diosa' yapaya juinsha titi kenuu juve ti' Yavé pañuba juntsa tsa tsangue kenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés naa Besalelnu bain, naa Oholiabnu bain, naa kayu veela juntsaa taawasha narake ken chunu milanu bain, Yavéren tsangue' aseetaju tireñu kenuu jumulanuya, yala' pensashan tsanguenu tyamulanuya demikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tsejtu Moisés, chachilla Dioschi tiba detaañu katu yalanu kuwami, tsenmalaa yala Diosa' pupunanu yapaya chuinsha aawa kure' keewaanu titi meneste inuu juñuba juntsa kenudetsu. Tsenñu Israel chachilla yai tenen kuwanu tya' kepenenemee Dioschi kayu taji tajiindetsuñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Diosa' pupunanu yapaya chuinsha titi meneste inuu juñuba juntsa taawasha ken pumula yala' taawasha detyaike' jitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Moisésnu entsandita jila: Chaiba chachilla tiba pure' tajaindetsuñu' mitya, Yavé titi kide tiñuba juntsa ma dekikiñuba larainu juve, tita jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Tsenñu Moisés kumuinchi chachillanu waingaatu tsandimi: Naa supula bain, naa unbee rukula bain tiba mandaatyudei Diosa' pupunanu yapaya chuinsha titi menesteñuba juntsa kenu, timi. Tsenñaa chachilla tiba kuwanu taji tajiindun dya'kala, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","matyu yumaa titi meneste juñuba juntsa dekikiñu bain larainuna tsuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Entsaa taawasha kenu kayu aseeta julaya, Diosa' pupunanu yapayaa kila. Tsejtu turekaraa ura linuchi tene daayadimu jali paitya kila, naa lushmuraraa jiluchi bain, naa yamuraraa jiluchi bain, tsenmin ungalalaa jiluchi bain, tsejtu juntsa jalinu ja'chi puu muute narake ke' tyaapachi depumi' chujtila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kumuinchi entsa daayadimu jali jumula paree bare ju', paree bunguke kila; barenchiya 28 tyabulu, tsenmala bungunchiya taapai tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Tsejtu daayadimu jali manda jumunuya kapash kapash pumi' main jungue tirela, tsenmin kama manda jumulanu bain tsaren kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Tsejtu entsa daayadimu jali ajke' manda tyuipu jumulanuya ma kelusha ya' kapatala lushmuraraa chuwachi tuti jungue ke' jijiila; tsenmin kama daayadimu jali tyuipu jumulanu bain tsaren kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Tsejtu daayadimu jali ajke' manda tyuipu jumulanu ma kelusha bain, naa kama daayadimu tyuipu jumulanu kama kelusha bain main main 50 jai tuti kila, matyu tutiitala kaju'talai tiyanudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Tsenmin daayadimu jaliitala tyuipu' kakaanu beru bain uruchi tene 50 kila, tsangue' tyuipunmala Diosa' pupunanu yapaya ma jali jui tiyanutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Tsenmin daayadimu jali chibu juchi tene 11 kila, juntsachi Diosa' pupunanu yapaya vikaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kumuinchi entsa 11 daayadimu jali jumula barenchi bain, naa bungunchi bain baree juula: barenchiya 30 tyabulu, tsenmin bungunchiya taapai tyabulu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Tsejtu daayadimu jali manda jumula dula' depumi', naa daayadimu jali mandishmain laramulanu bain tsaren kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Tsejtu daayadimu jali ajke' manda tyuipu jumulanu ma kelushaya 50 tuti kila, tsenmin kama daayadimu tyuipu jumulanu kama kelusha bain 50 jai tuti kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Tsenmin brunsechi tene 50 beru kila, juntsachee chibu juchi keñu vikaanu jali jumulanu main jungue tirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Tsenmin Diosa' pupunanu yapayanu vikaanu, llupu uveja kika ungalalaa tiwarachi tene kila, tsenmin juntsa jandala yapaya mishbui'sha vikaantsumiya pi animaa kika kayu naraa jumulachi tene kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Tsejtu Diosa' pupunanu yapayasha uikaanu akasia chi ta'pa tene kalaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ma ta'pamee paitya tyabulu barela, tsenmin bungunchiya ma tyabulu kama kejtaa tyabulu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Tsenmin entsa ta'palanu mainnuya pai kajti larala, tsenmala kama ta'panuya pai juru jungue lare' yaitala tyulla tyullakaanu jumi. Tsangue' Diosa' pupunanu yapayanu naaju ta'palanuba tsaandene kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Sur pasha uikaanuya 20 ta'pa kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Tsejtu ta'pa panbeesha deendanamu tsumulaya lushi kenu jeruchi tene 40 paki kila. Ma ta'pa uinanu panbeemeemee deendanamu paki pallu pallu pula, ma ta'papa pai kajti lara deeñu, kajtimeemee llu'pu' uikaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Tsenmin Diosa' pupunanu yapayanu kama kapasha, ura pañuya, nurte pasha uikaanu bain 20 ta'pa ke', ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","naa ta'pa panbeesha deendanamu paki bain lushi kenu jeruchi tene 40 kila, ma ta'pa panbeemeemee pai paki punu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Tsenmin Diosa' pupunanu yapaya benesha uikaanuya, ura pañuya pajta vinu pasha uikaanuya, mandishmain ta'pa kila, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","tsenmin juntsa kelusharen pai mutu jumunu pai ta'papa uikaanu ju', pallu pallu pukenu kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Entsa ta'pa pallu pallu uikara' jimula, pelesha pareju mityana', kai'sha bain tutichi dula' mityanala. Tsaju' benesha pai mutunu uinamu ta'pala juntsaandene jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Tsaju' mandishpen ta'pa junmala juntsa panbeesha deendanamu paki jumulaya lushi kenu jeruchi tene ju' kumuinchibi 16 paki jumi, matyu ta'pameemee deendanamu paki pallu pallu vinu jutu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ta'pa deengaanu akasia cha'li tene manda kila, Diosa' pupunanu yapaya kelusha punu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Tsenmin masku keesha ta'pa deengaanu bain man cha'li, naa benesha pajta vinsha ta'pa deengaanu bain man cha'li kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Tsenmala ma lura kejtala kapash kapash dapuimuya ta'pa kejtaa katyutala pukila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tsejtu kumuinchi ta'palanu uruchi tene mai'tekila, naa tutila bain uruchi tene kila, tsenmin naa tutinu vi' jiinuu cha'li jumulanu bain uru tene mai'tekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Tsenmin daayadimu ma jali turekaraa ura linuchi ke', lushmuraraa jiluchi bain, yamuraraa jiluchi bain, ungalalaa jiluchi bain dekemi, tsejtu juntsa jalinu ja'chi puu muute jumula narake deke' tyaapachi pumi' chujtimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Tsejtu bene uruchiren beru kiketu taapai yatyutyala akasiachi keñu uinamu luratala beru pu' daayadimu jali yangaala. Entsa yatyutya jumula bain uruchi tene mai'taala. Yatyutyameemee lushi kenu jeruchi keñu panbeesha deendanamu ma paki jumulanu uinala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Tsenmin naa Diosa' pupunanu yapaya juukapanu daayadimu jali bain turekaraa ura linuchi deke', lushmuraraa jiluchi bain, yamuraraa jiluchi bain, ungalalaa jiluchi bain kila. Tsejtu juntsanu bain tyaapachi tyeeba narake depumi' chujtila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Tsenmin yatyutya bain manda ke' beru puu tene kila; tsejtu yatyutya panbeesha deendanamu man paki jumula brunsechi tene kila. Tsanguetu yatyutya mijkushaya uruchi tene mai'tela, naa ya' tuti jumula bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Tsenmin Besalel akasia chichi babuu ketu, barenchiya pai tyabulu kama kejtaa tyabulu, bungunchiya ma tyabulu kama kejtaa tyabulu, tsenmin katyunchi bain ma tyabulu kama kejtaa tyabulu juu kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Tsejtu naa juusha bain, naa avindala bain uru tene pi'ware' mai'teke', kelutalaya uruchiren chuwa pijtekaren tsangue' mai'temi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Tsenmin uru pi'ware', taapai tuti bain kemi, babuuchi taapai neepa jumulanu eengaanu, pai neepa kelusha pai tuti eengare', masku pai neepa kelusha pai tuti eengaakenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Tsenmin akasia chi tene, yali' tanenu cha'li ketu, uruchi tene mai'tekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Tsejtu babuunu kelu kelu pumu tutilanu putu yali' tajiinuke tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Tsenmin ma ta'pa bain du'kaanu uruchi tene kemi, barenchiya pai tyabulu kama kejtaa tyabulu, bungunchiya ma tyabulu kama kejtaa tyabulu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Tsenmin du'namu ta'panu, ja'chi puu muute juundene pallu ke', kapash kapash maatilluchin urunu tsangue muute dekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Tsejtu du'kaanu ta'panu ja'chi puu muute deke' mainya, masku kapasha, kamainya kama kapasha juumi, tsejtu juntsa du'namu ta'pa ja'chi puu muute jumulaba main juumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Tsejtu yala' ja'chiya ja'warana' du'namu ta'pa jandala dishuna chula. Tsejtu yaitala kaju'talanatun kajuuya du'namu ta'pasha keepuna chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Besalel akasia chichi, tyeeba tsuunu ta'pa llaijkara bain main kemi, barenchiya pai tyabulu, bungunchiya ma tyabulu, tsenmin katyunchiya ma tyabulu kama kejtaa tyabulu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Tsejtu uru pi'ware' juntsachi tene mai'teke', kelutalaya uruchiren chuwa pijtekaren tsangue' mai'temi, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","tsangue' kelutala mai'tenu paki taapai tyamishu bungu ke' pumi. Tsenmin juntsa jandala uruchiren chuwa pijtekaren tsangue' mai'temi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Tsenmin uru tene pi'ware' taapai tuti ke', kelush kelush taapai neepa jumulanu eengare' ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","tuti jumula kuyi kalen kalen jungue pumi, tsejtaa entsa tuti jumulanu cha'li ñali', tyeeba tsuunu ta'pa llaijkara jumunu yali' taji tajiinu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Juntsa tyeeba tsuunu ta'pa llaijkara tajintsumi ya' tutinu ñalinu cha'li, akasia chee ka' ketu juntsa cha'linu uru tene mai'tekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Tsenmin ta'pa llaijkara jandala tiba meneste inu tsumula bain uruchi tene juula: naa palatu juula bain, naa aa kuchara juula bain, naa aa shulla muute juula bain, tsenmin naa chachilla Diosnu dekeewaañu binu puntsumi kaa shulla muute juula bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Tsenmin Besalel, naa ñillu chujtintsumi usja'tee jumu aa lanpara bain uruchi tene kike', mainnuren naa ya' uinainsha bain, naa ya' bulu jumu bain, naa ya' kupa juula bain, naa ya' llullu tyuinanu basu bain, naa ya' llullu tape juuñuu bain junuren tsangue deke', maatilluchi tene vili' millangue juntsa muute dekemi, petse petse tyuipui'mujchiren. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Juntsa ñillu chujtintsumi usja'tee jumu aa lanparanu kelumeemee pen tyaapa falaju', kumuinchibi pai kelubiya mandishmain tyaapa pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Entsa mandishmain tyaapa jumula main main pen basu pu', almendru llullu keraa ju', llullu tyuinanu basu bain, llullu ya' tape bain puumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Tsenmala aa lanpaa luraren taapai basu pu', almendru llullu keraju', llullu tyuinanu basu bain, llullu ya' tape bain puumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Tsejtu pai tyaapa tyuidinu panbeemeemee llullu tyuinanu basu puundene juumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Tsejtu naa llullu tyuinanu basu bain, naa ñillu chujtinu tyaapala bain tyuipuñu' jutyu' ma bulu juumi. Juntsa ñillu chujti' chakaantsumiya uruchi tene juju' maatilluchi tene villa' jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Tsenmin naa junu chujtintsumi mandishpai lanpaa jumula bain, naa michanu majtadimu jeru juula bain, naa ya' kaa palatu juula bain uruchi tene dekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Entsa ñillu chujtintsumi usja'tee jumu aa lanpara bain, naa junu tiba meneste-imula bain dekenu, kumuinchibi 33 kilu uru tene menestenguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Tsenmin Besalel aindyunguikaantsumi ju'kenunu bain kemi akasia chichi. Naa barenchi bain, bungunchi bain ma tyabulu juju' paree juumi, tsenmin katyunchiya pai tyabulu jumi. Tsejtu junu kachu muute usnamula, aindyunguikaanu tsure' ju'kenunuba jaiba tyuipujtu' main juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Tsangue' dyatu naa jandala bain, naa ya' kachulanu bain, naa kelutala bain uruchi tene mai'tekemi, tsenmin kelutalaya uruchiren chuwa pijtekaren tsangue' mai'temi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Tsenmin junu uru chuwa mai'ta panbeenu, uru tuti pu' pai kelusha main main pumi, tsejtaa junu pai tuti jumulanu pai cha'li jumula main main pu' juntsanu ka' yali' taji tajiinu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Juntsa cha'li jumula akasia chichee ke' uru tene mai'tekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Tsenmin Besalel naa Dioschin juu tirendu menestenguentsumi muli bain, naa ju'ke' aindyunguikaantsumi tene juu bain ke', aindyu kemi, matyu pindyupi kemula naakemu deeñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besalel ufeenda tsure' ju'kenunu bain akasia chichi tene kemi. Naa barenchi bain, bungunchi bain man tyabulu ju', taapai kelu jumula tsaandene juumi. Tsenmala katyunchiya pen tyabulu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Tsejtu junu taapai mutu jumunu, taapai kachu muute kemi, tsaaren tyuipujtu' main juumi. Tsenmin brunsechi tene mai'taami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Tsenmin tiba ufeenda tsure' ju'kensha talantsumi tsumulaya brunsechi tene kemi: naa ju'pe puntsumi bain, naa pala bain, naa shulla muute juula bain, naa animaa alla baindekaanu jeru bain, naa ñinbuka puntsumi juu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Tsenmin brunsechiren waaku ketu, ufeenda tsure' ju'kenunu ya' jurusha, kejtaa deechutala kajti usnanu panbeesha tsuukemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tsenmin brunse pi'ware' taapai tuti bain kemi, ya' mututala brunse waakunu punu, tsejtaa yainu cha'li pu' tajiinuke tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Tsenmin entsa ufeenda tsure' ju'kentsumichi cha'li lura ketu akasia chichi tene ke', brunse tene mai'tekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Tsanguetu ufeenda tsure' ju'kenunu kelush kelush pumu tutitala juntsa cha'li depuite' yali' tajiinu kemi. Tsejtu ufeenda tsure' ju'kenunu juruke kemi ta'pachi tene. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Diosba wa'dinu yapaya vinu juukapasha taawasha kemu supula, yaichi brunsenu kere' yala' kajuru katanu brunsechee Besalel aa paila main kemi, naa ya' chujtintsumi bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Naa cha' neneinsha bain Besalel kemi. Tsejtu sur pasha cha' neneinsha daalu'tekaanu jaliya turekaraa ura linuchee ju', bare' mitya tene 100 tyabulu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Tsenmala 20 yatyutyala bain, naa yatyutya panbeesha deendanamu 20 pakila bain brunsechi tene juumi, tsenmin ya' beru juula bain, naa ya' tutila bain lushi kenu jeruchi tene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Nurte pasha daalu'tekaanu jaliya baren mitya 100 tyabulu jumi; junu ya' yatyutyala bain 20 jumi, tsenmin ya' yatyutya panbeesha deendanamu 20 paki jumula bain brunsechi tene juula, tsenmin yatyutya beru jumula bain, naa tutila bain lushi kenu jeruchi tene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Tsenmala pajta vinu pasha daalu'tekaanu jaliya 50 tyabulu bunguu yanami. Junu uinamu yatyutyala paitya jumi, naa yatyutya panbeesha deendanamu paki bain paitya jula. Tsenmala yatyutya beru juula bain, naa tuti juula bain juntsalaya lushi kenu jeruchi tene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Tsenmala pajta lanu pasha, tsandityu'ba, vinu juukapasha daalu'tekaanu jaliya 50 tyabulu bunguu yanami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Tsenmala juukapa kelusha daalu'tekaanu jaliya 15 tyabulu ju bungu yanami, tsenmin yatyutya bain pema, naa yatyutyanu panbeesha deendanamu paki bain pema jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Tsenmala masku kelusha cha' neneinsha daalu'tekaanu jali jumu bain 15 tyabulu bungu ju', naa yatyutya bain pema, naa yatyutyanu panbeesha deendanamu paki bain pema jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Junu cha' neneinsha kelu kelu pumu daalu'tekaanu jali jumula naajulaba turekaraa ura linuchi keñu tene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Yatyutya panbeesha deendanamu paki jumulaya brunsechi tene juula, tsenmala yatyutya beru juula bain, naa ya' tuti juula bain juntsalaya lushi kenu jeruchi tene juula, tsenmala yatyutya mijkushaya lushi kenu jeruchi tene mai'taami. Tsaju' naaju yatyutyala bain cha' neneinsha uinamulaya lushi kenu jeruchi keñu tuti tene puula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Cha' neneinsha vinu juukapasha daalu'tekaanu jali jumulaya narake ura' muute deke' puma' chujtya', lushmuraraa jiluchi bain, yamuraraa jiluchi bain, naa ungalalaa jiluchi bain, naa turekaraa ura linu jiluchi bain juumi. Barenchiya 20 tyabulu barela, tsenmin katyunchiya man tyabulu jula, matyu cha' neneinsha daalu'tekaanu jali naadejuñuba juntsaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Junu taapai yatyutya pumula bain, naa yatyutya panbeesha deendanamu paki taapallu jumula bain brunsechi tene juula; tsenmala ya' beru juula bain, naa ya' tuti juula bain juntsalaya lushi kenu jeruchi tene juula; tsenmin yatyutya mijkusha bain lushi kenu jeruchi tene mai'taala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Naa Diosa' pupunanu yapaya chi'kaanu jeru lura jumula bain, naa cha' neneinsha chuwa chi'kare' deengaanu jeru lura jumula bain brunsechi tene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Moisésren tsanguide tiñu, chachilla' mitya Diosnu kalen jimu Aarón' na Itamar, Levínu sera' jimu chachillanu tsanguidei ti', Diosa' pupunanu yapaya, tsandityu'ba, Dios tsandipañu keewara yapaya kenu jeru naa-i meneste iñuba piikikaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Tsaju' Moisésnu Yavé naakide tiñuba, Urí' na, tsenmin Hur' paña jumu, Judánu sera' jimu ruku Besalel kumuinchi tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Dannu sera' jimu ruku Ahisamac' na, Oholiabya entsaa taawasha kemishtimi, yaa jerutala taawasha kiikemu' mitya, tsenmin naa naake kenuu juñuba muute dekemumin, naa lushmuraraa jiluchi bain, naa yamuraraa jiluchi bain, naa ungalalaa jiluchi bain, naa ura linu jiluchi bain pumi', muute juu bain detsejmu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Diosa' pupunanu yapaya kenu meneste iñu uruya, Diosnu kuwa uruchi tene kikila. Tsejtu kumuinchibi 965 kilu, 30 gramu menestenguila, Diosa' pupunanu yapayasha naake adyu' yangaamu deeñuba tsanguitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Tsenmala lushi kenu jeru chachilla dekuwañu katu 3.319 kilu, 525 gramu kala, Diosa' pupunanu yapayasha naake adyu' yangaamu deeñuba tsanguitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Chachilla nan dejuñuba mijanu mike' keeñu mikamu chachilla 20 añu ajkesha juulaya kumuinchibi, 603.550 chachi jula, tsejtu main main man gramu medya lushi kenu jeru kuwa kuwakila, Diosa' pupunanu yapayasha naake adyu' yangaamu deeñuba tsanguiñuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tsenmala Diosa' pupunanu yapaya yatyutya panbeesha deendanamu paki kenu bain, naa Diosa' pupunanu yapayanu kejtala pai suku jungue daayadimu jalinu tyuilaatanamu yatyutya panbeesha deendanamu paki bain dekenuya, 3.300 kilu menestenguila lushi kenu jeru tene. Tsejtu yatyutya panbeesha deendanamu paki deketu, lushi kenu jeru tene depi'ware' panbeesha deendanamu paki 100 kila, ma pakimeemee 33 kilu menestenguiiketu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kumuinchi chachilla lushi kenu jeru tene entsangue dekuñu, Besalel katu panbeesha deendanamu paki dekiñu, lushi kenu jeru 19 kilu, 525 gramu laramuchiya, naa yatyutyatala pumu beru bain deke', tsenmin yatyutya mijkutala bain demai'tetu, naa tuti juula bain dekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tsenmala chachilla brunseya 2.336 kilu, 400 gramu kuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Tsejtu juntsa brunsechee Diosba wa'dinu yapaya juukapanu uinamu yatyutyanu panbeesha deendanamu paki bain, naa ufeenda tsure' ju'kenunu bain, naa junu waaku pumu bain, tsenmin ufeenda tsure' ju'kensha tiba meneste imula bain brunsechi tene kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Tsenmin cha' neneinu kelutala uinamu yatyutya panbeesha deendanamu paki jumula bain, naa cha' neneinsha vinu juukapanu uinamu yatyutya panbeesha deendanamu paki jumula bain, naa Diosa' pupunanu yapaya kelutala bain, naa cha' neneinsha kelutala chi'kare' deengaanu jeru lura jumula bain brunsechi tene kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Diosa' pupunanu yapayasha vindu pannu naraa jali tsejte' ketu, naa lushmuraraa jiluchi bain, naa yamuraraa jiluchi bain, naa ungalalaa jiluchi bain kila. Tsenmin naa Aarónchi Dioschin juu pannu jali bain kila, Moisésnu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Tsenmin efud kenuya, uru jilu bain, lushmuraraa jilu bain, yamuraraa jilu bain, ungalalaa jilu bain, naa turekaraa ura linu jilu bain menestenguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Tsejtu urunuren maatilluchi tene pinbakikingue deviitu, juntsanu jilu juuñungue dewane' tsejtela, naa lushmuraraa jiluchi bain, yamuraraa jiluchi bain, ungalalaa jiluchi bain, tsenmin ura linu jiluchi bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Tsejtu efudnu kapash kapash pai jai paki pula juntsachi teepu' kakaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Tsenmin juntsa efudnu jandala deendanamu ajpeendee chuwa bain tsaren ju' efudba main jungue deke', uru jilu bain, lushmurara jilu bain, yamurara jilu bain, ungalala jilu bain, naa turekaraa ura linu jilu bain menestenguila, Moisésnu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Tsenmala unise bale shupukala Israel' nala' mumu pillaa jumulaya uruchi keñu mai'tenu paki jumulanu chujtyaa tene judeju', muute ke' chujtintsuminu naake piikemu deeñuba juntsaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Tsejtu bene Besalel, efudnu pumu jai pakinu demai'tekemi Israel' nala' mumu puu, tsejtaa yalanu mandenga mandengakenu, matyu Moisésnu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Tsenmala tenbapunu teenu jai paki bain, efud naaju naraañuba juntsangue', uru jilu bain, lushmuraraa jilu bain, yamuraraa jilu bain, ungalalaa jilu bain, naa turekaraa ura linu jilu bain menestenguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Entsa kenu pai paki jungue dyajli' buungare' kemi, tsaju' naa barenchi bain, bungunchi bain paree juju' ma kelu kelu 22 sentimetru jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Tsenmin ya' jandalaya taapai shili bale shupuka tene viyami; ajke' shilinuya ma sarduniu, ma tupasiu, ma esmeralda pumi; ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","entsaba pai shilinuya turkesa bain, safiru bain, jade shupuka bain pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Tsenmala entsaba pen shilinuya ma jasintu bain, ma agata bain, ma amatista bain pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Tsenmala entsaba taapai shilinuya ma krisulitu bain, ma unise bain, tsenmin ma jaspe shupuka bain pumi. Entsa bale shupukala uruchi keñu mai'tenu paki jumulanu chujtyaa tene juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kumuinchibi 12 shupuka jula, matyu Israelchi ya' nala 12 juwa deeñu. Tsaju' Israelnu 12 sera' jimula' mumu ma shupukameemee ma mumu pilla' chujtya' muute chujtintsumi juuñuu pilla' chujtyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Entsa tenbapunu teenu jai pakinuya kaa kuunduupi keraa uruchi tene ke', chuwa turen tsangue' chujtikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Tsenmin chujtintsumi uru paki bain pallu ke', naa uru tuti bain pallu ke', tenbapunu teenu jai paki kai'sha juntsa tutila kapash kapash mai'tela. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Tsenmin uru kuunduupi ken tsangue', tenbapunu teenu jai paki kai'sha kapash kapash pumu tutilanu kakaakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Tsejtu uru kuunduupi keraa tene pallu jumula' pai kapa, pala jai pakinu mai'namu uru pakinu kakaakila, matyu efudnu ajkesha pumu uru pakinu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Tsenmin uruchiren kayu vee tuti pallu mantu, tenbapunu teenu jai pakinu pele kapasha pula, ura pañuya, efud keesha jumunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Tsenmin kama pai tuti uru tene juu manla, tsejtu entsala efudnu jai paki punu ajkeshaa pula, panbeesha punnu kelunu, efudnu ajpeendee chuwa punu jayu katyunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Tsanguitu tenbapunu teenu jai pakinu pumu tuti efudnu pumu tutiba, main lushmuraraa chuwachi kakaakila; tsenmalaa tenbapunu teenu jai paki, efudnu pumu ajpeendee chuwa kai'tala tiyainutsu, yaitala baka' ji'nutsu. Tsejtu Moisésnu Yavé naakide tiñuba juntsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Tsenmala avindaa pannu jaliya lushmuraraa jiluchi tene detsejte' kemi. Juntsa jandalaa efud jimu jumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Tsejtu kejtaa jurunu ya' kuyitalaya belu'kake' wagaa kikachi naake jali ke' tenbapunu dishkaamu deeñuba tsanguemi, kiyuu jin jutyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Tsenmin pelesha juntsa belu' kaya kapatala naa lushmuraraa jiluchi bain, naa yamuraraa jiluchi bain, naa ungalalaa jiluchi bain, naa turekaraa ura linuchi bain tsururu kerake detsejtemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Tsenmin kaa kanbana juula bain uruchi tene deke', tsururu keraa puka detsejteñu jumulaba belu' kaya kapatala jala jala yangaakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Tsejtu yaichi taawasha kendu pannu avindaa jali jumunu tsururu keraa puka tsejtemin, junu ma kaa kanbana yangaakaakila belu' kaya kapatala, matyu Moisésnu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Tsenmin Aarónchi bareree tainsha punu jali bain, naa ya' nalachi bareree tainsha punu jali bain ura linu jiluchi tene kikila jali tsejmu chachilla. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Tsenmin naa mishunu pujchintsumi naraa jumu Aarónchi puntsumi bain, naa ya' nalachi puntsumi bain ura linuchi tene kikila, tsaaren tainsha punu wara jumulaya linu turekaraa ura linuchi tene kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Tsenmin ajpeendee chuwa bain turekaraa ura linuchi bain, naa lushmuraraa jiluchi bain, naa yamuraraa jiluchi bain, naa ungalalaa jiluchi bain kila, tsejtu tsa tsanguemu chachilla muute deke' chujti' narakila. Tsejtu Moisésnu Yavé naakide tiñuba tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Tsenmin uruchiren pinbakikii paki ke', muute puntsuminu naake piikemu deju'ba juntsanguitu: “Yavéchin juu rukuve”, piikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Tsejtu bene juntsanu lushmuraraa chuwa pula, tsangue' kai'tala ya' mishunu tela pakinu kakaanu. Tsejtu Moisésnu Yavé naakide tiñuba tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Entsanguitaa Diosa' pupunanu yapaya, tsandityu'ba, Diosba wa'dinu yapaya kila. Tsaju' Israel chachilla, Moisésnu Yavé kumuinchi naakide tiñuba tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Tsejtu Diosa' pupunanu yapaya deketu, Moisésnu taji' kuwala, naa Diosa' pupunanu yapaya linu jali bain, chibu ju jali bain, naa kayu vera tiba jumula: beru juula, ta'pa juula, ta'pa deengaanu cha'li juula, yatyutya juula, yatyutya panbeesha deendanamu paki juula, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","llupu uveja kika ungalalake tireñu vikaantsumi juula, pi animaa kayu naraa kika juula, babuunu daayadimu jali juula, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Dios chachillanu veta' veta' tsanguedaa tiñu keewara babuu bain, naa juntsanu yali' tajintsumi cha'li juula, naa babuu du'kaanu ta'pa bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tyeeba tsuunu ta'pa llaijkara bain, junu tiba meneste imula bain, Diosa' ajuusha keewara pan juula, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ñillu chujtintsumi usja'tee aa lanpara uruchi tene juu jumu bain, ya' lanpaa juula, junu tiba meneste imu juula, dangaanu ya' muli bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","uruchi keñu aindyunguikaantsumi ju'kenunu bain, Dioschin juu tirendu menestenguentsumi muli bain, ju'ke' aindyunguikaantsumi bain, Diosa' pupunanu yapaya juukapasha daayadimu jali juula, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","brunsechi keñu ufeenda tsure' ju'kenunu bain, brunsechi keñu ya' waaku bain, yali' tajintsumi cha'li juula, junu tiba meneste imu juula, aa paila bain, ya' chujtintsumi bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","cha' neneinsha daalu'tekaanu jali juula, yatyutya juula, yatyutya panbeesha deendanamu paki juula, cha' neneinsha vinu juukapasha daayadimu jali juula, ya' chuwa juula, chuwa chi'kare' deengaanu jeru lura juula, tiba Diosa' pupunanu yapayasha meneste imu juula, tsandityu'ba, Diosba wa'dinu yapayasha meneste imu juula, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","naa Diosa' pupunanu yapayasha vi' pannu detsejte' kiñu jali juula: chachilla' mitya Diosnu kalen jimu ruku Aarónchi pannu jali Dioschin juu jumu bain, naa ya' nala' pannu jali juula bain taji' kuwala chachilla' mitya Diosnu kalen jimula' taawasha kenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Tsejtu Israel chachilla, Moisésnu Yavé kumuinchi naakide tiñuba tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Tsenñu Yavé naakide tiñuba chachilla ma juntsangue dekiñu Moisés keetu, yalanu Dios ura' de-ikaasa timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Moisésnu Yavé manbatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Ajke' chu'chayachi, ajke' malunu, in pupunanu yapaya, tsandityu'ba, iba wa'dinu yapaya, dekujte' chujtinu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tsejtu iya chachillanu veta' veta' tsanguedaa tiñu keewara babuu juntsa yapaya juusha punu juve, tsejtu daayadimu jali juntsanu dishu' yangaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tsenmin naa tyeeba tsuunu ta'pa llaijkara bain junga tavi', ura' dekide; naa ñillu chujtintsumi usja'tee jumu aa lanpara bain jungaren tavi', ura' dekide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Tsenmin aindyunguikaantsumi ju'kenunu uruchi keñu jumuya, veta' veta' tsanguedaa tiñu keewara babuu ajuusha chujtide, tsenmin in pupunanu yapaya vinusha daayadimu jali bain yangaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Tsenmin bene in pupunanu yapaya, tsandityu'ba, iba wa'dinu yapaya juukapa ajuusha, animaa tsure' ju'kenunu jumu tavi' chujtide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tsejtu aa paila jumu ufeenda tsure' ju'kenunu, iba wa'dinu yapayaba pensangue', kejtaa tenatala chujtikide, tsangue' pi pukide. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tsenmee naa cha' neneinsha bain kenu de-uikare' chi'kaatu, junga vinsha daayadimu jali bain yangaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Tsejtu bene inchin juu tirendu menestenguentsumi muli katu, in pupunanu yapayanu yuutsuude, tsenmin tyee junga detsuñuba juntsa jandala bain. Entsanguitaa kumuinchi junga tiba tsumulanu inchin juu tene detirenu tsuve. Tsenmalaa inchin juu tena tiyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tsenmin inchin juu tirendu menestenguentsumi muli, ufeenda tsure' ju'kenunu bain, naa tiba juntsa jandala tsumulanu bain yuutsuude. Tsanguenmalaa ufeenda tsure' ju'kenunu tsamantsa inchin juu tiyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tsenmin naa aa pailanu bain, naa ya' chujtintsuminu bain juntsa muli yuutsuude, tsejtaa inchin juu detirenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Tsanguetu bene Aarónnu bain, naa ya' nalanu bain, iba wa'dinu yapaya juukapasha tajitu depitsaade. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Tsangue' inchin juu jumu jali Aarónnu pandede, tsejtu bene ya' jandala muli yuutsuude, tsanguetaa chachilla' mitya inu kalen jimu rukunu inchin juu tirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tsejtu bene ya' nalanu bain demikatu, yalanu bain juntsa bareree tainsha punu jali pandede. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tsejtu yalanu bain muli yuutsuude, Aarónnu naakenu ju'ba juntsaju, tsenmalaa yai bain chachilla' mitya inu kalen jimula inchin juu tiyanudetsu. Entsangue' yalanu juntsa muli yuutsuunmalaa, naa-uwanuba inchi chachilla' mitya inu kalen jimula junu detsuve, naa yalanu sera' jimula bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Tsenñu Moisés Yavé yanu kumuinchi naakide tiñuba tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tsejtu Egiptosha demalu' miiñu ma añu depulla' kama añu manbeepunu chu'chayanu, ajke' malunu Diosa' pupunanu yapaya kujta' chujtyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Tsejtu Moisés, Diosa' pupunanu yapaya uikaanu, naa ya' yatyutya panbeesha deendanamu paki juula bain, naa ya' ta'pa juula bain, naa ya' ta'pa deengaanu cha'li juula bain, ya' yatyutya juula bain depu' uikaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Tsejtu Diosa' pupunanu yapaya juusha pumu linu jali chi'kare', naa juntsa jandala yapayanu vikaantsumi ju jali bain chi'kare', naa juntsanu vikaantsumi kika juula bain devikaami, yanu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Tsejtu bene Moisés, Dios naaken chudei tiñuba juntsa pilla shupuka ta'pa katu, babuu juusha pumi; tsejtu juntsa babuunu bain ya' yali' nentsumi cha'li bain kelutala deputu, naa ya' ta'pa bain jandala tsuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Tsanguetu Diosa' pupunanu yapaya jurusha tavitu, daayadimu jali babuunu dishu' yangaami, yanu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Tsejtu tyeeba tsuunu ta'pa llaijkara katu, Diosba wa'dinu yapayasha tavi' nurte pasha tsuumi, tsaaren juntsa babuunu daayanamu jali avindaa pasha tsurekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Tsejtu juntsa tyeeba tsuunu ta'pa llaijkara jandala, Yavénu keewara pan ura' ke' detsuumi, yanu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Tsenmin naa ñillu chujtintsumi usja'tee jumu aa lanpara bain tavi' Diosba wa'dinu yapayasha chujtimi, tyeeba tsuunu ta'pa llaijkara chunu ajuu, masku kelusha, sur pasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Tsanguetu Yavé' ajuusha lanpaa ura' deke' chujtimi, yanu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Tsenmin uruchi keñu aindyunguikaantsumi ju'kenunu bain Diosba wa'dinu yapaya jurusha tavi' chujtimi, babuunu daayanamu jali ajuusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Tsejtu aindyunguikaantsumi ju'kemi, yanu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Tsejtu bene Moisés Diosa' pupunanu yapaya vinu juukapasha daayadimu jali yangaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Tsanguetu bene ufeenda tsure' ju'kenunu jumu bain Diosa' pupunanu yapaya vinu juukapa keesha, tsandityu'ba, Diosba wa'dinu yapaya keesha chujtimi; tsejtu animaa tute', juntsa jandala ju'ke' keewaami, tsenmin naa pan kenu llujpe juu bain tsure' ju'ke' Diosnu ufeenda keewaami, yanu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Tsejtu aa pailanu Diosba wa'dinu yapaya jumu, tsenmin ufeenda tsure' ju'kenunu chumuba pensangue' keeñuya, juntsa kejtaa tenabi chujti' pi tyuwake pumi, pitsaatsaa kenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Tsenñu junaa naa Moisés bain, naa Aarón bain, naa ya' nala bain pi kalare' naa tyaapa bain, neepa bain pitsaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tsejtu naa Diosba wa'dinu yapayasha vindu bain, naa ufeenda tsure' ju'kensha kalen jindu bain pitsaatsaa kila, Moisésnu Yavé naakide tiñuba tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Tsejtu bene Moisés cha' neneinusha kenu, ufeenda tsure' ju'kenu kelutala, matyu Diosa' pupunanu yapaya kelu kelu, yatyutya de-uikare' daalu'tekaanu jali bain dechi'kaami, tsejtu cha' neneinu vinu juukapasha bain daayadimu jali yangaami. Entsanguitaa Moisés ya' taawasha deke' dyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tsenñu ñivish lura paijtu, Diosba wa'dinu yapayanu dishukemi. Tsejtu Yavé' tsamantsaa keewara jumu ya' pupunanu yapayanu tsaa yalluimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Tsenñu Moisés naa-i' Diosba wa'dinu yapayasha vin tsaa tiyaimi, matyu ñivish lura paja' tsaa dishukeñu, Yavé' tsamantsaa keewara jumu ya' pupunanu yapayasha yalluiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israel chachilla yala' nengamaya, naa-uwanu Diosa' pupunanu yapayasha juntsa ñivish lura malu' miiñuba, yala' buli manga' bendaa miji mijiila, ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","tsaaren juntsa ñivijcha malu' mijindyushu juntsaa, yai bain tsa tsanala, tsejtu juntsa ñivijcha malu' mijinbera keekeenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tsaju' naa-uwanuba Israel chachilla' jingamaya, Yavé' ñivijcha Diosa' pupunanu yapaya kai'tala tsa tsanami, naa mandala bain, naa kepe bain. Tsaaren kepeya juntsa ñivijcha ñillu chakaraa tiya tiyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo' tyui aa-apa millala, naa rei Davidnu bain, naa Abrahamnu bain sera' jimula entsalaa juntsa deeve: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham na deke' faawaañu, naa ya' kailla bain na deke' faawaañu, naa ya' pañala bain na deke' faawaañu, naa ya' tyuipañala bain na deke' faawaañu, kayu 14 bijee jingue na deke' faawaanshaa David faami. Entsalaa juntsa deeve: Abrahamya Isaacchi ya' apa tiyamuwaami. Tsenmala Isaac Jacobchi ya' apa tiyanmala, Jacobya Judáchi bain, naa kayu ya' vejan naatalalachi bain ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judáya Tamarba, Faresnu bain, Zérahnu bain na miyandila. Fares, Hesrónchi ya' apa tiyanmala, Hesrónya Aramchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, Aminadabchi ya' apa tiyanmala, Aminadabya Nahasónchi ya' apa tiyamuwaami. Tsenmala Nahasónya Salmónchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ya' shinbu Rahabba Booznu na miyandila. Boozya ya' shinbu Rutba Obednu na miyandila. Tsenmala Obedya Jeséchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tsenmala Jeséya rei Davidchi ya' apa tiyamuwaami. (Tsenmala Davidnu sera' jimu nala bain, paña defaaware'kera, tyuipaña defaaware'kera kendu, 14 bijee jingue nakakare' jinshaa Babiloniasha peesu dekaya' jinu tinbu jamuwaami.) Tsenmala rei Davidya, Salomónchi ya' apa tiyamuwaami, Urías' shinbu tiyamuba keñu na. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónya Roboamchi ya' apa tiyanmala, Roboamya Abíaschi ya' apa tiyamuwaami. Tsenmala Abíasya Asáchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asáya Josafatchi ya' apa tiyanmala, Josafatya Joramchi ya' apa tiyamuwaami. Tsenmala Joramya Ozíaschi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozíasya Jotamchi ya' apa tiyanmala, Jotamya Acazchi ya' apa tiyamuwaami. Tsenmala Acazya Ezequíaschi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasya Manaséschi ya' apa tiyanmala, Manasésya Amónchi ya' apa tiyamuwaami. Tsenmala Amónya Josíaschi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasya naa Jeconíaschi bain, naa kayu vejan unbeena naatalalachi bain ya' apa tiyamuwaami; Israel chachilla peesu kaya' Babiloniasha detakanu tinbunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloniasha peesu dekaya' chudi' puitu, jungajte na dekakare' paña mafaaware' jijiindu, 14 bijee jingue na mangakaanshaa Jesús nakayami. Entsalaa juntsa deeve: Jeconías, Salatielchi ya' apa tiyanmala, Salatielya Zorobabelchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, Abihudchi ya' apa tiyanmala, Abihudya Eliaquimchi ya' apa tiyamuwaami. Tsenmala Eliaquimya Azorchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, Sadocchi ya' apa tiyanmala, Sadocya Aquimchi ya' apa tiyamuwaami. Tsenmala Aquimya Eliudchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, Eleazarchi ya' apa tiyanmala, Eleazarya Matánchi ya' apa tiyamuwaami. Tsenmala Matánya Jacobchi ya' apa tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tsenmala Jacobya, María' ruku tiyamu Joséchi ya' apa tiyamuwaami. Tsenmala María, matyu Dioschi Mi'ke' Kayamu tiitinu ruku Jesúschi ya' ama tiyamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Entsaitaa Abrahamnu desera' ji' rei David nakayainshabi seratu, 14 bijee maserala. Tsenmin Davidnu demasera' jimin Babiloniasha peesu dekaya' takanu tinbu jinbera, kama 14 bijee maserala. Tsenmala Babiloniasha peesu dekaya' takanu tinbu pulla' demasera' jimin, Dioschi Mi'ke' Kayamu janu tinbubi jingue pensanguenmalaya, manen 14 bijee maserala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Uwain Jesucristoya entsaitaa nakayave: María, Jesúschi ya' ama, Josénu kayanu palaa juwaami. Tsaaren kayu ya' rukuba bulu chui'mujchin na ma puu katawami. Juntsa na pumiya Espíritu Santo tsanguikaañaa tsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tsai' na ma puuñu, Joséya Dios naakesa tyañuba tsanguen chumu' mitya, Maríanu yujpewaandyai'tu, chachillanu na'baasa tsaa kuinda ki'mujchin dus ne mavelainu kemi ya' shinbu tinutsuminu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tsejtu umaa tsai' mavelanu pensanguiñun, kipibi Bale Rukuchi ma anjee Josénu katawatu tsandimi: José, rei Davidnu sera' jimu ruku, Maríanu ñu' shinbu tirenu pensandyatyude; challa na puushu juntsa Espíritu Santochee tsai' navi' chuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tsa' mitya María nakanu tsuve. Tsai' nakanmala juntsa nanu Jesús mumu pude, yaa ya' chachillanu livee kenu juñu' mitya. Tsanguenmalaa ya' chachilla ujcha delañu, juntsa kuipa' mitya livee kenu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kumuinchi entsaa puimiya, Bale Ruku bene tsaa puinu tsuve ti', ya' mitya pamu rukunu naati pakaamuwaañu bain tsaa puitaa tsaimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Naaju unbeelanuba tsa-i' kerajtu pannaren navi' kanu tsuve. Tsenmala juntsanu “Emanuel” mumu punu detsuve. Entsandishu juntsaa, “Dios laaba bulu chuve”, titu. Tsa' mitya entsaa kuinda puitaa tsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tsenñu José entsai kipi' dyatu, Maríanu ya' shinbu tiremi, Bale Ruku' anjee naati pañuba tsanguitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tsejtu ya' shinbuba tsuindyumi, kayu nakaindyuya. Tsenñu José juntsa nanu Jesús mumu pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Rei Herodes chunu tinbunu, Judea tusha Belén pebulunu Jesús nakayami. Tsenñu pajlanu pasha chumu, makaratala keetadi' mija mijaimu rukula, Jerusalén pebulusha jitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","tsandila: ¿Challan kayaimu judíola' rei naanain? Lala pajlainsha juntsa wainmu makara dekatatu, yanu balengure' teedinaa dejayu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tsa detiñu meetu rei Herodes nara tyai'mi, naa Jerusalénnu chumu chachilla bain naajulaba nara tyai'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tsejtu Herodes, chachilla' mitya Diosnu kalen jimula' bale rukulanu bain millangue dewa'kare', naa Moisés' wandya lei mashturulanu bain dewa'kaake', nukaa Dioschi Mi'ke' Kayamu nakayanuu juñuba pake'meemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tsenñu juntsa rukula pakatu: Judea tusha Belén pebulunaa nakayanu juve, tila, Diosa' mitya pamu ruku entsangue piikemuwaañu' mitya: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judá tusha chumu, ñu Belén pebulu, vee mujtu aa pebulu chumulaba buute' pensangue' keeñu, ne balejtuu pebulu jutyuve; matyu ñu' junuren main bale chachi fale', kumuinchi in Israel chachillanu washkenu juñu' mitya, ti' pillave, tila bale rukula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsenñu Herodes juntsa aseetaju rukulanu dus demika' pake'meetu, naamaa ura juntsa makara faañuba mijami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tsejtu bene yalanu Belénsha eendu tsandimi: Ji' ura' depake'mera', juntsa kaananu kata' maja' inuba kuinda kikai, i bain ji' balengure' teedinu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Rei tsandiñu umaa aseetaju rukula jila. Tsenñu yalanu fale' katawamu makara yala' ajkesha puu miya' jinduren, nunbanu kaana chuñuba juntsa deechu jiimiren dyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tsenñu aseetaju rukula, makara tsai' dyañu katatu mika sundyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tsejtu ya juusha devitu, nanu katala ya' ama Maríaba. Tsejtu tsana kata' balengure' deteeditu, yala' babuu dejuuke', uru bain, aindyu chi pillu bain, naa bulutala munguentsumi mira pindyu bain me'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsaaren juntsa aseetaju rukula, Herodes' chuinshaya manbuityudei, tiñu dekipitu, vee mujtu miñushaa miila yala' yasha miindu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aseetaju rukula yala' yasha demiiñu, Bale Rukuchi ma anjee Josénu kipibi tsandimi: Nanu ya' amaba ka' Egiptosha nepimishtide, tsejtu i mawandindyuya junga tsanade, matyu Herodes entsa nanu mi'ke' tu'nu kenuuñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Anjee tsandiñu, José kujtu, nanu bain, ya' amanu bain ka' tsaa keperen Egiptosha nepimishtikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tsejtu junga ji' chudi' tsanala Herodes peyangama. Entsaa puimiya, Bale Ruku bene tsaa puinu tsuve ti', ya' mitya pamu rukunu naati pakaamuwaañu bain tsaa puitaa tsaimi: In na Egiptobi pu mamikayu, timuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Juntsa aseetaju rukula kuinda demantyuñu' mitya, yaichi anbutikayaiyu tyatu, Herodes daran ajaatyami. Tsejtu kumuinchi unbeena kailla pai añu pullajtulanuya detu'kaakenu mandangue', Belénnu chumu kaa kaillanu bain, naa juntsa keesha kaa pebulutala chumu kaa kaillanu bain detu'kaakemi, juntsa aseetaju rukula tsantsa avenju juunu juve detiñu, juntsaalanu tene. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tsaaren entsaa puimiya, Diosa' mitya pamu ruku Jeremías entsandimuwaañu, tsaa puitaa tsaimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramásha main u'tandi' llakinbeyai' vishkiindintsu meejave. Juntsa tsandintsumiya Raquelya ya' nala' mitya tsandintsuve. Yumaa ya' nala depeya' tsudenañu, waredyai'taa tsandintsuve, timuwaañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bene Herodes peyañu, Bale Rukuchi ma anjee Egiptosha Josénu kipibi katawatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nanu tu'nu tyamula yumaa depeya deiñu' mitya, nanu ya' amaba manga' Israel tusha mamiya' miide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tsandiñu José, nanu ya' amaba manga' Israel tusha miya' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tsaaren Arquelaoya ya' apa Herodes' mitya Judeanu uñi manchuñu mijatu, José junga miinu jeetyami. Tsejtu kipibi Dioschi mijakaratu Galilea tushaa miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tsejtu junga Galileasha mavijitu, Nazaret pebulubi chumi. Junu chuimiya kaspee tinbunu Diosa' mitya pamu rukula, Jesús Nazaretsha chumu tikayanu tsuve timuwa deeñu, tsaa puitaa tsaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Juntsa malutala Juan Mungaamu Judeasha tiba den chutyuin tenasha katawa' Diosa' kuinda ke' ule' nepas nendu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","tsa tsandimi: Diosnu rei juu tananu malu kalen jave. Tsa' mitya veta' pensa demangue' Diosnu meenguidei, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juannu laapu' pataa Diosa' mitya pamu ruku Isaías entsangue piikemuwaami: Tiba den chutyuin tenasha main entsandintsuve: Bale Ruku' janu miñu sekuwangue' tsuudei, ñulla' tenbukasha ya' miñu ura' mantse'kaadei, tintsuve, timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanya kameyu juchi keñu jallee panami, ya' ajpelenuya kika ajpeendee chuwaa telami, tsenmala ya' finu pandaya dendu-ishu jeendaa mishkibaa juwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tsenñu Jerusalénsha chulla bain, naa Judea tusha chulla bain, naa Jordán pi keetala chumula bain Juannu meenanu jijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tsai' yala' ujcha' mitya veta' pensa demanguenmalaya, Juan yalanu, Jordán pisha mungaakaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tsanguentsu naa fariseola bain, naa saduceo chachilla bain mungaakutinu pure' jijideiñu Juan katatu tsandimi: Ñulla piñi juuñuu anbutimu chachillanuba, ¿maa ñulla Dioschi taaju i' puinu kaledenashuba, engu jataa livee inu juve tiñaa dejayu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Veta' pensa mangue', veelachiba uwain entsala Bale Ruku' miñusha demaañuve tenna keewaadei, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ne ñui tene, “Lalaya Abrahamnu sera' jamu deeyu” tya', daj pensaa keewaatyudei. Matyu uwaindiyu Diosren tsanguendyatuya, naa entsa shupukanu bain Abrahamnu sera' jimu chachi juula bain tirenuu juve. Tsa' mitya tsandyatyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chi tuumu jacha, telelebi ma tulekemu jacha yumaa tyayaa ma tsunave. Tsaju' naaju chi bain ura' puka ityuya dedala' ñinbaasha keviimu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Uwain iyaa, ñullanu veta' pensa mangue' Diosnu meenguidei, titu, pichi ne mungaakentsuyu, tsaaren bene in benesha jamuya ñullanu Espíritu Santochi bain, tsenmin ñichi bain mamungaakenu tsuve. Yaa inu pulla pudeve; tsaañu' mitya iya tiba juñu' jutyunchin naa ya' sandalia juuba taji' ne kuwa kenuba jutyuuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Juntsa jamu rukuya trigu wa'kare' te'kamu jun tsaa ju', trigu ñi ya' chiba devela' kalaanu, tyami puja'tee pala ya' tyaapasha tanave. Tsangue' devela' kalaamiya trigu tsurensha uukare', ya' kuyaa naa-uwanuba manbetyu ñinbaasha kepu' ikakaanu tsuve, ti' laapu' pami Juan. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús Galileasha puturen, Jordán pisha jimi Juan' junga, tsai' yachi mungaranu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsenñu Juan umanbeleya tsanguindyai'tu: Iyaa ñuchi mungaranuu juñuba, ñaa inchi mungaranu jatu iyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsenñu Jesús tsandimi: Tsaaren Dios tsaa mutyañu' mitya, challaya tsanguenuu juve, timi. Tsandiñu Juan Jesúsnu mungaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tsenñu Jesús mungaratu pisha pu' maluinmalan, selu juruke tse'ke' Diosa' Espíritu ya' mishkai'tala paluma pajan tsaintsu' katawami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tsenmalan selusha main entsandiñu meejami: Entsaa in estyanu Nave. Ya' mitya yuj sundenve, tiñu meejami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesúsnu Dyabulu ujcha lawaanu ke'keesa tyatu, Espíritu Santo bene Jesúsnu tiba den chutyuin tenasha miya' jiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tsenñu Jesús 40 malu, 40 kepe panda fajtu puitu, umaa panda mutyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsenñu Dyabulu ujcha lawaanu tya' mitya kalen jitu tsandimi: Ñu uwain Diosa' Natuya, entsa shupukanu pan tiyade tide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tsandiñu Jesús pakatu tsandimi: Diosa' Kiikanu entsa pillave: Chachilla panda findun chunanu dejutyuve, naa Diosa' pañu ya' fi'pakisha faamu palaachi bain chunuu dejuve, tive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsenñu Dyabulu, Jesúsnu Dioschin juu jumu pebulu Jerusalénshaa bene miya' jimi. Tsejtu aa elesha mishbui'sha kayu katyu tenabi miya' lu-i' uikaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tsandimi: Ñu uwain Diosa' Natuya tusha yanbude, matyu Diosa' Kiikanuya entsandive: Dios ya' anjeelanu ñunu washkekaanu eenu tsuve, tsenmala ñunu anjeela yallachi jiinu detsuve, ñu' neepa tusha tyuika' shupukachi tapan jutyu, ti' pillave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tsandiñu Jesús bain tsandimi: Diosa' Kiikanu entsa bain tsandive: Ñu' Bale Ruku Diosnuya ti ken tsangue tirenu kityude, ti' pillave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tsejtu pulla'bi Dyabulu Jesúsnu aa kuyisha miya' luitu, tu kuraa, tsenmin naa tiba uukeraa jumu dekeewaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","tsandimi: Kumuinchi entsa keewarekeeshu juntsa ñunu dekuwanu tsuyu, ñu in ajuusha teledi', inu aawa kureshu juntsaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tsenñu Jesús tsandimi: ¡Manbaka' mijiide, Satanás! matyu Diosa' Kiikanu tsandive: Ñu' Bale Ruku Diosnuren aawa kure' keewaake', yachiren tiba kiikemu juude, ti' pillave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tsenñu Dyabulu manbaka' miiñu, mantsa anjee deji' Jesúsnu washkentsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juannu peesu depuñu kuinda mijatu, Jesús Galilea tusha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tsejturen Nazaretnu chui'mujchi Cafarnaúmsha, aa pusu keebi chumu kaa pebulunaa chuimi, naa Zabulónnu sera' jimu paandela bain, naa Neftalínu sera' jimu paandela bain chunu tusha. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tsaaren entsaa puimiya, Diosa' mitya pamu Isaías entsainu tsuve ti' pamuwaañu tsaa puitaa tsaimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón tu, Neftalí tu bain, Jordán pi bejkusha, pajvinu pasha jumu tu, matyu lamaa pi keesha jumu tu, ñu, Galilea, judío chachi jutyula' chunu tu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dishkejtsa chunañunamu chachillaren umaa ñillu kataakiñu dekive. Matyu jelekenu uu jeetyannainsha chunañunamula' jungaba ma ñillu dandakeñunguive, timuwaañu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús juntsai' Cafarnaúmsha ji' chutu: Diosnu rei juu tananu malu kalenave; veta' pensa demangue' Diosnu meenguidei, ti' kuinda mijakares neneimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea aa pusu pi keetala nendu pai naatala katami, mainya Simón, tsandityu'ba, Pedro tinu ruku; tsenmala kamainya Andrés mumu. Yala ainguemu de' mitya, ataaya pisha tya'kikendetsu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tsejtu Jesús tsandimi: In bendala jadei, tsenmala iya ñullanu, chachillanaa alla kan tsanguemu ruku detirenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsandinmalan yala' ataaya junu deshuike', ya' disipulu tiyanu ya' bendaa jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsejtu kayu ajkesha jindu kama pai naatala, matyu Zebedeo' nalanu bain katami: Santiagonu bain, Juannu bain. Tsenñu yala ya' apaba kaa baakusha waaku ura' kikendetsuren, Jesús yalanu mikañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yala' apanu bain, naa yala' kaa baaku bain deshuike', ya' bendala jei jila ya' disipulu tiyanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús chachi waku wakudinu yatala mijakare' pas nendu kumuinchi Galilea deneintsumi, Diosnu rei juu tananu mika ura kuinda mijakares nendu. Tsejtu ti diipeya juu tadeeñu bain, naa ti kiyanchi dilu deeñu bain ura' mandires neneintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tsenñu kumuinchi Siria tusha, Jesús naakes nentsuñuba kuinda demijatu, matyu ne tichi diluju' llakinguen dechu'ba, junu detajiñu, naa ne diipeyachi juu, ne kiyanchi juu, naa dyabulu puu chumulanu bain, naa des-iimulanu bain, naa dedeelaa chumulanu bain taji tajideiñu, Jesús ura' mandire' me-ee-eekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tsenñu Galileasha chumula bain, Decápolissha chumula bain, naa Jerusalénsha chumula bain, naa Judeasha chumula bain, naa Jordán pi pajlanu pasha chumula bain, pure' chachi Jesúsnu sure neneintsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chachilla pure' judeeñu katatu Jesús butyusha lu' chudimi. Tsenñu junu lu' chuñu ya' disipulula ya' keesha dewa'dijiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","chachillanu entsandi pa' mijakaami: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Naajulaa pensasha maaliya tibanguenu jutyuuyu tenna ju', uwain Diosnu meneste juyu tyamulaya, Dioschi ura' imu deeve, Dios yala' rei juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Naajulaa llakinguen dechu' bain, Dioschi ura' imu deeve, Dios yalanu masundyawaanu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Naajulaa maali yala' pensasha tiba daj pensajtu dechu'ba Dioschi ura' imu deeve, yalaa entsa tu kanu deju' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Naajulaa Dios naakesa tyañuba tsanguen chunu tyanchin tsanguenu ajchundyan chumulaya, Dioschi ura' imu deeve, yala naakenu tyañuba Dios tsanguikaanu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Naajula bain munuba tenbityamulaya Dioschi ura' imu deeve, Dios bain yalanu tenbitya' keenu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Naajulaa ti ujchaba jutyu Dioschin juu dechu'ba Dioschi ura' imu deeve, yalaa Diosnu katanu deju' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Naajulaa naa ti peletu falekenu kiñu bain tsaa faakaanu kityulaya Dioschi ura' imu deeve, Dios yalanu ya' na detirenu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Naajulaa Dios naakesa tyañuba tsangues nendetsu bendaa ke' tituba dekiñu, taaju pulla pulla de-i'ba Dioschi ura' imu deeyu tyanu dejuve, Dios yala' rei juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ñulla in mityan chachillachi tituba dekura', tituba de-i', na'baasa anbukuinda in dechumiya, Dioschi ura' imu deeyu tyanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mika sundya' ura' judei, selusha tsamantsa balen juu kanu deju' mitya; naa kaspele ñulla jutyunu tinbunu bain Diosa' mitya pamu rukulanu tsangue firu' ken chumuwa deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ñulla keranguen chumu chachillaya entsa tusha chumu chachillachi tyayu juuñu deeve. Tsaaren tyayu pijtu tiyashu juntsaa, ¿naa keñaa pi' mandiyanuu jun? Tsejtu naa tichiba balejtu tiyaiñu miñusha dekepunmala naaju chachillaba demenaa tere' nenu tyayu ne tiyainu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ñullaa veelachiya ñillu juuñu deeve. Ma pebulu aa kuyisha ma chunamuya naa-i' pantsudin tsaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tsenmin ne ñillu chakare' bain piyama panbeesha dishu' chujtinu chakaratyuve, matyu katyunandala chujtyaimuve, tsenmalaa kumuinchi yasha chullanu dannutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tsa' mitya ñulla, ti kike' bain vee chachillachiya ñillu juuñuu danjurui nenu kidei, tsenmalaa ñulla ti bain ura' dekiñu katatu, yai bain selusha chumu ñulla' Apanu urave tya' balengure' panudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iya Moisés' wandya lei manbirenu jave tyatyudei, naa kaspee tinbunu Diosa' mitya pamu rukula' mijakaranu bain manbashwaanu jaindyuyu; matyu iya juntsa leinu naatiñuba tsanguenaa jayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Uwaindiyu selu bain, tu bain de-i' piyaindyuya, naa kaa atyutyuu letaraba mamushan jutyuve, lei bale pilla palaa naa-i' puinuu juñuba tsaa depullaindyuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tsa' mitya mun naamika kaa lei juuñu bain, Moisés' wandya leinu mainnu meedityushu juntsaa, tsenmin veelanu bain meedimijakaatyushu juntsaa, Dios ya' rei juinsha ji' bain, jui'ñuba ne uraa chachi junu tsuve. Tsaaren mun meengue' naakenuu juñuba veelanu bain tsangue mijakaashu juntsaya, Dios ya' rei juinsha mika aawa' keranu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Uwaindiyu, Dios naakesa tyañuba ñulla tsanguen chu', naa Moisés' wandya lei mashturulanu bain, naa fariseolanu bain kayu pullake tsanguen chui'shu juntsaya, Diosnu ñulla' rei juu tananu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ñulla' tinbu chachillanu entsandimuwa deeñu ñulla mideeve: Chachiitala tu'tyude; mun tute' bain kavitu i' kuipa vinu dejuve, tiñu mideeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naa tsaa mideeñu bain, ñullanu entsandinu tenve: mun ñulla naatalaatalan kundaa detiyashu juntsaa, tsaren kavitu i' kuipa vinu detsuve. Tsenmala mun kentsure' pamuya kayu aa bale rukulachi kavitu inu tsuve, tsenmin mun tituba pa' na'baasa dekurekishu juntsaa, ñi jelekenu kensha keviinuu chachi tiyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tsa' mitya aa eleshasha ufeenda tsure' ju'kenunu ñu ufeenda kunu ta'tu, ñuchi naatala jumun main ñuba kundarave tya' mandengamiya, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ufeenda ju'kenu keesha ñu' ufeenda tsurekiken miji', ñuchi naatalaren ñunu kundaa tyamuba ajke' ura' manba' mantse'kaade. Tsanguitaa ufeenda tsure' ju'kenusha miji' ñu' ufeenda keewaanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tsenmala mun ñunu kavitu kenu tyaiñuba, kayu kavitu kemu bale ruku' ajuusha tajindyuren, apain yaba ura' pa' mantse'kaade; tsanguityunmalaya ñunu bale ruku' tyaapanu kuwanmala, entsa bain chaita rukula' tyaapanu kuwanmalaya ñunu peesu punu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Uwaindiyu ñu tsanguityu' peesu vimiya, ñunu lushi naake depa'ñuba juntsa millangue kuwai'mujchiya malun jutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Vee matsaityude, ti' pamuwa deeñuba ñulla mera' kera deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tsaanuren iyaa ñullanu entsandinu tsuyu: Mun vee shinbulanu mujkera ke' bain ya' pensashaya yumaa vee matsaive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tsa' mitya ñu' urandya kapuka' mityaa ujcha lalaishu juntsaa, kala' kepude; tsanguishu juntsaa ñu' bulunu juntsaren kevi-i', kumuinchi ñu' buluya tsaa ñi jelekenu kensha dekeviin jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tsenmin ñu' urandyaapa' mityaa ujcha lalaishu juntsaa, juntsa bain daaka' kepude; tsanguishu juntsaa, ñu' bulunu juntsaren kevi-i', kumuinchi ñu' buluya tsaa ñi jelekenu kensha dekeviin jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tsenmin kaspelen tsandimu deeve: Mun lu'tsa' shinbunu mavelashu juntsaa, mavelayu ti' keengaya kiika main tsangue piike' kuwanu juve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naa tsaañu bain, iyaa entsandinu tenve: Ma ruku ya' shinbunu, ne vee matsaiba indyuren mavelashu juntsaa, vee matsaisa tya' mavelaiñuu juuve. Tsenmala mun mavelamu shinbuba manchu' bain vee matsaimu chachi tiyaa juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tsenmin kaspee tinbunuren yumaa rukulanu entsandimu deeve: Diosa' mitya uwain tsanguenbera kenu timiya, tsanguenbera kenuu juve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tsaanuren iyaa ñullanu tsandinu tenve: uwain tsanguenbera kentsuyu tityudei, tsandityunchi ma juudei. Tsaju' naa-uwanuba kai'sha selusha depaka' uwain tsanguenbera kentsuyu ti' patyudei; seluya Diosa' bale chunu chunbullave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tsenmin tunu bain paka', uwain tsanguenbera kentsuyu, tityudei. Juntsaya Diosa' neepa teetanainshave. Naa Jerusalénnu bain paka' uwain tsanguenbera kentsuyu tityudei. Juntsa pebuluya aa bale Rei' chunu pebuluve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naa ñulla' mishpukanu bain paka', uwain tsanguenbera kentsuyu, tityudei, ñullaya naake' naa ma achuwa juuñuba ne pababake, ne fibabake tirekenuuba dejutyu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Matyu ñu naati pañuba, juntsaa jusa: Tsanguenu, timiya, tsanguide, tsenmin: Tsanguen jutyu, timiya, tsanguityude. Tsaju' tyeeba puite' pashu juntsaa, Dyabulaa tsandikaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ñulla kaspee tinbunu entsandindetsu meemuwa deeve: Ne kapukanu daran ke' musha dekiñu bain, naa tejkutala daran ke' musha dekiñu bain, ñui bain juntsangue mannuu dejuve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tsaaren iyaa ñullanu tsandinu tenve: firu' dekiñu vejmi' mantyudei; tsanguityu' ne mun urandya mashpelenu kidekiñu bain, masku pasha bain kikutide. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tsenmin mulaa kavitu ke' ñu' pannu jali chi'kenu padetiñu bain, ne tsaikuti', naa ñu' avindaa pumu jali bain paviiki'mujchi ne kuwakide. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tsenmin ñunu mulaa uudengue' buli 1.000 saka bare' ta'nu dejikaañu bain, 2.000 saka bare' jingue take' kuwade. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mun ñunu tyeeba pakikeñu bain kuwade. Tsenmin ñunu tyeeba mangunu ti' pakikeñu bain, kuwandyatyuu jutyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Naa entsa bain ñulla mera' kera deeve: Ñuba kalen chumu chachinu estyade, tsejturen ñu' kundaa chachinuya tyutyade, tiñu mera' kera deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tsaañu bain iyaa ñullanu entsandinu tenve: ñulla' kundaalanu estyadei, naa ñullanu firu' kenu bendaa nemula' mitya bain Diosba kuinda kiikidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsanguen dechumiya, selusha chumu Apachi ñulla uwain ya' nala deju'ba tsangue keewaanu dejuve, matyu yaa naa ura chachilla Dios naakesa tyañuba tsanguen chumulachi bain, naa firu' chachilla Dios naakesa tyañuba tsanguen chutyulachi bain pajta faawaamuve, tsenmin naa shuwa bain tsaren jakaamuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tsejtu ñullanu estyamulanun ñui bain estyaishu juntsaa, ¿tyee juntsan mitya kachu deeyu tenguen? Naa deechu' mitya lushi kamu rukula bain juntsaaya kemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tsa' mitya lu'tsa' keranu chachiitalan ura' kuinda juu nedeishu juntsaa, ¿tyee veela tsangui'nu juu dekiyu tenguen? Naa Diosnu keranguityu chachilla bain juntsaaya kemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tsa' mitya ñulla' Apa kai'sha chumu naajunga, tiba deechu' kemu ju', ura' ruku jushu, ñui bain juntsaadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ñulla tyee uraa ke' bain, ne veelachi tsai katawachi tenñu tsanguen chutyudei. Ñulla tsanguen dechunmalaya ñulla' Apa kai'sha chumu tiba uraa kuwa' sunbewaan jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tsa' mitya tiba meneste juu chachillanu tyee uraa kike' bain, tsa jutyuren tsaañungue keewaamu chachilla tsaaya, veela demijatu yala' mitya ura' depasa tyanchiren, chachi waku wakudinsha wandis ne'kerake, naa pebulu miñutala wandis ne'kerakemu deeshu, ñui bain ne juntsangue' munuba mijakares nenu kityudei. Uwaindiyu naajulan tsangue' bain yalaya juntsan mitya tyee kakenuu juñu bain yumaa kakeñunguenu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tsa' mitya tiba meneste juu chachillanu ñu tyee uraa ke'ba munuba waintyude, naa kayu ñuchi ura' keranu chachinuba waintyude. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Matyu dus ne tsangue' pullaide. Tsenmala ñu' Apa, naa ñu dus tsanguiñuba keena' mitya, yaa ñunu juntsan mitya tyeeba uraa kunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ñulla Diosba kuinda kemiya tsa jutyuren tsaañungue keewaamu chachilla tsaa jutyudei. Yalaya chachi waku wakudinu yatala uidi' Diosba kuinda kikena' bain, naa miñu mututala veela dekatasa tya' uidi' Diosba kuinda kikena' bain tsanguenu ajchu deeve. Uwaindiyu ne tsangues nedeishu juntsaa, bene tyee uraa kanu deju'ba yumaa kakiñu dekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tsaaren ñuya, naa-uwanu Diosba kuinda kenu tenñu bain, ñu' sukusha vi' llukike' ñu' Apaba dus kuinda kide. Tsenmala ñu' Apa ñu dus tsanguentsu keena' mitya, bene tyeeba uraa kuwanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tsenmin ñullaya Diosba kuinda kendu bain, Diosnu keranguityu chachilla tsaaya, junun papatinmalaa Dios kayu ura' meenu juve tyatu, pa' puinu palaanun manba manbatimu deesu, ñui bain tsarendinu kityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tsaju' ñullaya yala naadejuñu bain tsa jutyudei, matyu ñulla' Apa kai'sha chumuya ñulla kayu pakindetyun, titi meneste deeñuba yumaa mive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tsa' mitya ñullaya entsandi pa' Diosba kuinda kidei: Lala' Apa, selusha kai'sha chumu, ñuren main juu, tsamantsa aawa Dios juñuba, muba demija' tsaa dekeewaasa. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ñu' chachillachi rei tiyade. Selusha ñu naajusa tya' tsanguiñu bain, entsa tusha bain tsaren jusa. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Uma bain lala' fintsumu keeware' jintsuka. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lala' ujcha' mitya manbitsaaka, tsenmin laa bain naake lalanu firu' kemulanu veta' veta' ura' mandimu deeñu bain tsanguide. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Lala ujcha lainuu juubillaya tsangaatyuka; tsangaatyu', urajtutala livee kika, tidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tsandi' dyatu, Jesús tsandimi: Ñullanu firu' kemulanu, ñulla juntsan mitya ti kuipaba faawaan jutyu ti' ñulla yaiba ura' demandinmalaya, kai'sha chumu ñulla' Apa bain tsarengue' ñullanu ujcha' mitya manbitsaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tsaaren ñullanu firu' kemulanu juntsan mitya kuipa faawaren jutyuyu ti'shu juntsaa, ñulla' Apa bain ñulla' ujcha jumula' mitya ñullanu manbitsaan jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ñullaya Diosnu pensangue' panda fityumiya tsa jutyuren tsaañungue keewaamu chachilla tsaaya, Diosnu pensangue' panda findetyuve tyakaanu, llaki kajuru' la-i' chudimu deesu, ñullaa tsainu kityudei. Uwaindiyu mun tsangue' bain yalaya juntsan mitya tyee uraa kanu deju'ba yumaa kakeñunguenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tsa' mitya ñuya naa-uwanu Diosnu pensangue' panda fityu ju' bain kajuru pitsale', achuwa bain kikade, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tsenmalaa mu bain ñu Diosnu pensangue' panda findyuñuba mijai'nudetsu. Matyu ñu' Aparen mijainu tsuve yaa ñunu dus keena' mitya, tsejtu juntsan mitya ñunu ñu' Apa tyeeba uraa kunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Entsa tusha tiba pure' tadi' uukaanu kityudei, enguya naa buuma defi' mushkikena' bain, naa mantsa depiyaina' bain, naa taamulachi detaraina' bain tsainshave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tsanguityu' selu kai'shaa tiba detadi' uukaanu kidei; jungaa naa buumaba mushkityu, naa tiba piyatyu, tsenmin naa taamula bain putyu' taangui'nushave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Matyu ñu nunbanaa ñuchi tiba balen juu jumula detsure' tana'ba, ñu' pensa bain junbiren chi'kare' tananu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kapukaa buluchi lanpara juuñuuve; tsa' mitya ñu' kapuka urashu juntsaa, tiba ura tene ñu kenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tsaaren ñu' kapuka urajtushu juntsaa, ñuchi yapijurunañuu juunu tsuve. Tsa' mitya ñillu juuñuu dannamu kapukan ma yapijurunashu juntsaa, ¡ura tiba dannatyuinshaa naaju yapijuruchunga! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mu bain, yanu uudenguemu ruku pallu miyashu juntsaa, juntsa pallulachi paree taawasha ken jutyuve; matyu mainchiya taawasha ura' ke' bain, kamainchiya ura' ken jutyuve; tsa jutyu'ba mainnuya estya' bain, kamainnuya nejuu junu juve. Tsa' mitya Dioschi tiba kiikemu chachi juturen, lushinu bain mutya', tiba detadinu kiikenu jun jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tsa' mitya iya ñullanu tsandinu tenve: Umaa tyee finuj deewa, tyee kujchinuj deewa, tsenmin ti jallee pannuj deewa tya' pensanguen chutyudei. Tsejtu lala chu' jintsuñaa, ¿fintsuminu kayu pulla balejtuu?, tsenmin ¿lala' bulaa naa pannu jalinuba kayu pulla balejtuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jekachi nemu pishkulanu keekidei. Yalaa ti vijpalaba miyajdetuve, naa ti pukaba te'katyu deeve, tsenmin yalaya depuulanmala deka' uukaansha bain tsuutyu deeve, tsaanun yalanuya selusha chumu ñulla' Apaa panda fikaamuve. Tsejtu ¿ñullaa kayu pishkulanuba pulla balejdetuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tsaaren naajula bain pure' pensanguike'ba ¿naa ketaa juntsa uranu peyanuu ju' bain, jayu yapa machunuu tiyanu juyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tsaaba, ¿nejtaa ñullanu jalinaa yuj teja teja-in? Jeendala llullu chumula naa-i awamu deeñuba keekidei. Yalaa taawasha kityu deju', naa jali bain tsejte' pantyu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tsa deeñu bain, uwaindiyu naa rei Salomón bain tsamantsa uukeraa jalin panaken chumuwa ju'ba, llullu naaju uukeraawa deeñuba tsangue pantyuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tsaju' juntsa ishtapeya jeenbaasha chu', bene ne ikakaraimu juñuren Dios juntsangue pandemushu juntsaa, ¿kayu ñulla chachillanaa uukerake pandei'chunga?, ñulla ura' keranguityu chachilla. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tsa' mitya, ¿umaa tyee finuj deewa? ¿tyee kujchinuj deewa? ¿ti jallee pannuj deewa? tya' pensandyan chutyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Matyu Diosnu keranguityu chachillaa entsaatala aa pensanguen chumu deeve. Tsaanuren selusha chumu ñulla' Apaya ñulla titi meneste deeñuba mive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tsa' mitya Dios rei ju', naakesa tyañu bain juntsanaa kayu aa menesteju keewaadei. Tsanguetaa bene kumuinchi entsa ñulla meneste judeeshu juntsa bain kanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsaju' ayu malu' mityaya naajuchunga tya' pensandyan chutyudei, matyu ayu maluya maaliren tinaaba pensanguikenuu faanu tsuve. Naaju malu bain maaliren mika pensanguikenuu peletu faawaamuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Munu bain tsa deeve ti' kuipa putyudei, Dios bain ñullanu masmi' tsangui'nutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ñulla veelanu naake kuipa pu' depañuba, Dios bain ñullanu tsaren mannu tsuve, tsenmin veelanu naadekiñuba, Dios bain ñullanu juntsangue mannu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tsejtu, ¿nenñaa ñu' naatala' kapukanu kaa ujtupen punamunaa kata'ba, ñu' kapukanu aa tepulla ma punañuu jumunaa katatyu jutuuyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tsaju', ¿nejtaa ñu' naatala' kapukanu, ujtupen punamunaa mangalaanu panu juyu, ñu' kapukanuya aa tepulla ma punañuu jumunaa katatyumujchiba? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ñu, tsa jutyuren tsaañungue keewaamu chachi! Ñu' kapukanu aa tepulla pumaa ajke' mangalaade, tsejtaa ñu' naatala' kapukanu bain ura' kera' ujtupe pumu mangalaanuu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ti bain Dioschin kuraa jumulaya kuchanu kuwatyudei, tsandenna ñullanaa ja' dedaafike'banguenu dejuve. Naa balenchi pi'kelaa vi juula bain ku'chinu keputyudei, na'baasa demenaa terekenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Diosnu pa'dei, tsenmala Dios kuwanu tsuve; mi'kidei, mi'kishu juntsaa katanu detsuve; juukapasha paijidei, tsenmala juukenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Matyu mun pa'mulaya kamu deeve; mun mi'kemulaya katamu deeve; tsenmin juukapasha paijimulanuya juukemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tsejtu ñulla mallee lu'tsa' na pan pakenmala, ¿shupukaa kunu juyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tsanguityu'ba, pi alla pakenmala, ¿piñee kunu juyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tsa' mitya ñulla, kayu firu' chachillaaba ñulla' kaillanu tiba uraa kumu deeshu juntsaa, ¡ñulla' Apa kai'sha chumaa kayu naaju uraa kuwai'chunga, mun yanu depa'ñuba! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tsa' mitya ñullanu veela naadekesa tenñuba, ñui bain yalanu juntsanguen chudei, tsaju' naa Moisés' wandya lei bain, naa Diosa' mitya pamu rukula bain ura patiñuya entsaa depa' shuikive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Diosba ura' chunuya kaa bungu juukapa juuñuunaa vi' jidei, matyu tupiya' neiñuu ikaamu miñuya aa bunguve, tsenmin naraa uu nenuu miñu juve. Tsenñu jungaa pure' chachilla vi' jimu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tsaaren livee insha miya' jimu juukapaya kaa bunguu ju', miñu bain taaju' neinuu miñu juve; tsaañu' mitya, juntsa miñunu jimulaya jayun judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Anbutitun Diosa' mitya pamu deeyu timulachi chi'kayan jutyu pashkayajtu keetanadei; yalaya keranchiya uveja juuñuu katawaturen, tsaa firu jeengucha juuñuuren tsa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tsaañu ñulla yala tyee kiikemu deeñuba juntsanu keetadituren keenganu dejuve. Asu tsaatyuka, pu chinuya uva puka ityuve, naa igu puka bain maali awamu pijchuwatala ityuve, ne juntsaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Naaju chi bain uraya, ura puka kumuve. Tsaaren chi urajtuya, urajtu puka kumuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Main ura chiya mushaa puka kun jutyuve, naa urajtu chi bain uraa pukaya kun jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tsaju' naaju chee ura puka ityu ju' bain juntsaya tula' ñisha keviimuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Entsaañu' mityaa, anbutitun Diosa' mitya pamu deeyu timulanu bain yala tyee kiikemu deeñuba juntsanu keetaditun, urajtu cheeba deju', musha puka kuwan tsanguemu deeñuba ñulla keenganu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mu bain inu: Bale Ruku, Bale Ruku, tiitimu deju' mityaa, Diosnu yala' rei juu tananu dejutyuve; tsa jutyu', naajulaa selusha chumu in Apa naakesa tyañuba tsanguen dechu'ba, juntsalan yala' rei juu tananuu juunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tsa' mitya tiba kavitu dekenu malunaa pure' chachilla inu entsandiitinu detsuve: Bale Ruku, Bale Ruku, ñunu pakataa ñu' palaa veelanu mijakaamuwa deeyu, tsenmin ñunu pakataa naaju dyabululanu bain majuka'laamuwa deeyu, tsenmin ñunu pakataa naa tiba tsamantsaa ke' keewara juu bain kiikemuwa deeyu, tinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tsa tsa detinmala iya yalanu: Jayuuba kerajtuyu, ñullanu kerandendyuve, firu' ken chumu chachilla miji de-ii, tinu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tsa' mitya mun in palaa mere' iya naatiñuba tsangue meenguemushu juntsaa, ma ruku mika shili pensa ju' lanba' butyu jandala ya kemu ruku juuñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tsenñu naa shuwa bain, pillu bain, naa ajaa ishuwa bain ja' juntsa yanu daran juyiñu bain bujityu juve, matyu lanba' butyu jandala nara wajpu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tsaaren mun in palaa meeturen, iya naatiñuba juntsanguen chutyuya, ma ruku shili pensa jutyu' ñiipesha ya kemu juuñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsenñu naa shuwa bain, pillu bain, naa ajaa ishuwa bain jadeinmalan ya' ya desenaa ji' bujiiñu, ¡matyu tsaa tenbiyaimi! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tsejtu Jesús kumuinchi entsandi depa' dyañu, naake mijakaataa tsandiñuba chachilla mika meenbaishla, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ne Moisés' wandya lei mashturula naake mijakaamu deeñuba tsanguityu', yaa uwain tsandinuu ju' mijakaakaa keñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús butyusha putun manbajtya' miiñu, chachilla pure' surekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tsaindetsu ma ruku manbityu bishpee tene juu ya' ajuunu telenajitu: Rukui, ñuren tsanguenu tenñuya, inu ura' mandireka; iya mijayu, ñu in dilu peya manbirenuu juñuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsandiñu, Jesús tyaapachi ta'katu tsandimi: Uwain tsanguenu tenve. ¡Ura' mandiyade! timi. Tsandinmalan bishpee tene juu ruku jeke ya' bishpee demanbiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tsenñu Jesús tsandimi: Munuba entsa kuinda kityude, tsaaren chachilla' mitya Diosnu kalen jimu rukula' jungaa ji' keekutide. Tsejtu juntsan mitya Moisés tyee kenu dejuve timuñuba juntsaa ke' ufeenda taji' kuwade, tsejtaa diluren ura' mandiyayu ti' keewaanmala veela bain ñu uwain ura' mandiyañuba mijanudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Cafarnaúmsha vijiñu, main romano suutadu ama kalen jitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","tsandimi: Bale ruku, in yasha inchi taawasha kemu chachinu diluu ma tanayu. Dedeelaa ju', juikenu jutyu', kitya' ma u'tandin tsunamuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tsandiñu, Jesús: Tsaaya ji', ura' mandirenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsenñu suutadu ama pakatu tsandimi: Bale ruku, iyaa ti baleba jutyu chachi' mitya naake' ñunu in yasha mikan tsaayu. Matyu ñu uudengue' patiñun mikanu juve, tsenmala inchi taawasha kemu chachi ura' mandiyanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Naa i bain tsaren veelachi uuden imuyu; tsaaren i bain in suutadulanuya uudenguemuyu. Matyu iya mainnu: Jide tinmalaya, jimuve; naa veranu bain: Jade tinmalaya, jamuve. Tsenmin naa inchi manda-i' taawasha kemunu bain: Tyeeba kide tiñu bain, kemuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Entsa ruku tsandiñu, Jesús meenbaishtu, ya' bendaa nemulanu tsandimi: Uwaindiyu Israel chachillanu naa munu bain entsa ruku naake keenguemuñuba yanu pullangue inu keenguemu juunuya maliba kataindyuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tsa' mitya uwaindiyu pajlainsha chulla bain, naa pajvinsha chulla bain Dios rei ju' chuinsha pure' viitu, Abrahamba, Isaacba, Jacobba manbelaa chudi' panda finu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tsenmala Diosnu yala' rei tananuu jumu chachillaa avindala tsamantsa yapijurunainsha dekevi' ware', naa tejkuba pakaantsunu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsejtu Jesús suutadu amanu tsandimi: Miide, ñu naakesa tya' pensanguiñuba Dios tsanguenu tsuve, timi. Tsandinmalan dilu tsumu jei ura' mandiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús Pedro' yasha jitu, entsa ya' anchamanu dilu' penguma juu tsuna katajimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsejtu Jesús ya' tyaapanu ta'kakenmalan penguma ishanbajtekemi. Tsenmin juntsa shinbu mangujpa' yanu tyeeba ke' kudundaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dekependu' kainsha Jesús' junga, dyabuluchi ikayaa chachillanu pure' tajiila. Tsa deiñu yaa ma palaachiren juntsa bu'chullalanu demajuka'lare' me-eemi, tsenmin naaju dilulanu bain millangue ura' mandiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Entsaa puimiya, Diosa' mitya pamu Isaías tsainu tsuve ti' pamuwaañu, tsaa puitaa tsaimi, entsandimuwaañu: Lala pulujtu chachi deeñu' mitya, yaa kumuinchi lala' dii peya deka' miive, ti' pillañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Chachi pure de-i' yanu yatai de-uidiñu, Jesús aa pusu bejkusha tyakakaakutinu pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tsenñu Moisés' wandya lei mashturu main jitu Jesúsnu tsandimi: Mashturu, ñu nuka jijiiñuba inu bain jinu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tsenñu Jesús pakatu: Naa jeengucha juula bain yaichi vi' tsutsudinu tujuu tadeeve, naa pishku juula bain yaichi yatape tadeeve, tsaanuren Chachi Tiya' Nakayamuya naa nuka bain mishpuka llai'kare' tsuunuba ma tajtuuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsenñu ya' disipulu bain main tsandimi: Rukui, tsaashu juntsaa, in apanu ajke' menjinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tsandiñu Jesús pakatu: In bendalaa jade, junga keepele kityude; inu keranguityu chachillaya yumaa peyaiñuu dechu' mitya, yaitala demensa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsanditu Jesús baakusha viñu, ya' disipulula bain ya' bendala bulu vi' jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tsai' jindetsu, ne tsainu tsuve tyaba indetyun, pisunda ishuwaba jelekingue' baakunu pitansha pupukentsumi. Tsaintsuren Jesúsya kasu'tsunami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsenñu ya' disipulula yanu mandengaajitu tsandila: ¡Bale Ruku, lalanu livee kika! ¡Lala ma baiviindetsuyu! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tsa detiñu Jesús yalanu tsandimi: ¿Nejtaa ñullanu tsamantsa jeetenguen? ¡Nejdeeyu ñulla ura' keenguenu mijtula! timi. Tsandi' dya' uiditu ishuwanu bain, lamaanu bain ajaa tiñu, nejui mandiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tsanguiñu juntsa rukula yuj dekeenbaishtu yaitala tsandila: ¿Entsa naaju rukuñaa, naa ishuwa bain, pisunda bain yanu meenguemutu den? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús juntsa aa pusu bejkusha Gadara tusha tyakañu, pai chachi, dyabulu puu jumula ujkun mennu lanba' tujuutala chumula defale' yanu kalen jila. Entsala tsamantsa firu' kiikemu deeñu' mitya, mu bain juntsa miñu keetalaya puinu jutyu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tsejtu juntsala entsandi ui'la: ¡Diosa' Na, lalanu jaiba bulla kijatyuka! ¿Umanbelen lalanu taaju kikaachi tenñu iyu tsai' jami? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tsandindetsunu tenanu naa baanatyuinsha pure' ku'chi panda fiken uidenañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","juntsa dyabulula Jesúsnu tsandila: Entsa rukulanu puren, ñu lalanu majuka'laashu juntsaa, juntsa ku'chilanaa manbuiteka, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tsa detiñu Jesús pakatu: Tsaaya tsaidei, tiñu, juntsa firu' bu'chullala chachillanu demalu' miji' ku'chisha tene mavideinmalan, ku'chila tsaa yangachi tene ji' lanba' kujtusha deyanbu' aa pususha depajtya' chukakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tsenñu ku'chi washkemu chachilla denepiya' pebulusha miitu, tyee iñu bain, tsenmin juntsa dyabulu puu chachilla bain tyee de-iñu bain dewanditila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsejtu tsaa kuinda dekiñu, juntsa pebulu' chulla kumuinchi demijatu, Jesús' junga deji' katatu, juntsa tenanu malu' miide, ti' u'tandila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Entsai' depuitu Jesús baakusha mavi' bejkusha mandyaka' ya' chunu pebulusha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsenñu Jesús' junga main dedeelaa wandunu tsuu tajila. Tsai' tajimula Jesúsnu mika dekeranguiñuba mijatu, Jesús dii rukunu tsandimi: Sunden jude, kaana, ñu' ujcha demanbitsalave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsandiñu Moisés' wandya lei mashturula mantsa yala' pensashaa: “Entsa rukaa Diosnu kentsure' pantsuve”, pensanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tsenñu Jesús, yala naatyandetsuñuba mijatu tsandimi: ¿Nejdeeyu ñulla tsamantsa firu' pensala? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Entsa rukunu: Ñu' ujcha' mitya manbitsalave, tityumujchi: Mangujpa' miide, tiñu bain tsaren jutyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Matyu ñulla naa Chachi Tiya' Nakayamuya entsa tusha chachilla' keñu ujcha manbitsaanuu juñu bain keewaanu tsuyu, titu, dedeelaa tsumu dii rukunu tsandimi: Mangujpa', ñu' wandu manga', ñu' yasha miide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsandiñu dilu dedeelaa tsumu ruku mangujpa' ya' yasha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Entsanguiñu chachilla dekeenatu tsamantsai dekeenbashi' Diosnu yuj ura' kemu rukuve tila, chachillanuba tsamantsa juntsaa kenu tireñuba dekata' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús tsangue' miindu ma ruku Mateo detiñu, buli tajimulanu Roma uñichi deechu' mitya lushi kamu jutu, lushi kainsha chuna katatu: In bendala ja' in disipulu tiyade, timi. Tsandiñu, Mateo kujpa' ya' bendala jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsenñu Jesús panda findu yasha chunañu, bui tanemulanu Roma uñichi deechu' mitya lushi kamula bain, naa vejan ujcha lan kuramu chachilla bain pure' jade-i', Jesúsba manbelaa ya' disipululaba bulu chula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tsa deiñu, fariseola keenatu, ya' disipululanu entsandila: ¿Nenñungue ñulla' mashturuya Roma uñichi deechu' mitya lushi kamu chachillabaa bulu chudi', naa vejan ujcha lamu chachillanu bain tsaren bulu chumishti' yaiba bulu panda fintsumi? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tsa detiñu Jesús meetu tsandimi: Tiba dilujtu chachillaya dilulanu ura' mandiremulanu menestejdetuve, tsaaren dilulaya meneste deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tsa' mitya miitu entsa palaa naatitaa tsandiñuba aseetanguidei: Tenbityamu chachee dejusa tenve; ne animaa tute' ju'ke' inu keewaanun dejutyusa tenve. Matyu iyaa Dios naakesa tyañuba tsanguen chumu chachillanu mikanu jaindyuyu; iyaa ujcha lamu chachillanaa mikanu jayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Mungaamu' disipulula Jesús' junga jitu tsandila: Laa bain, naa fariseola bain Diosnu pensangue' panda fityu juju deeñuba, ¿nejtaa ñu' disipululaya tsanguityutu den? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tsenñu Jesús pakatu: ¿Matsunu fandangu kendu, matsumu ruku yaiba bulu puren padena apala llaki juu punu dejun? ¡Tsa jutyuve! Bene uwain inu, matsumu ruku juuñuunu manga' miinu tinbu janu tsuve; tsenmalaa umaa uwain Diosnu pensangue' panda fi'nu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kayu laapu' patu, tsandimi: Mu bain uinbu jalinu kasa jai petse mangaaputyu deeve, matyu kasa jaliya buru' kayajtu' mitya, mangaapunmala buru' kamin, uinbu jalinu kayu aa kiyuu-eekenu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tsenmin mu bain kasa binuya, uinbu binu puntsumi ki' buusanu putyu deeve, kasa binuya uinbu ki' buusanu kiyuu tse'ware' desejiinmala, binu bain, naa ki' buusa bain dekeviinuu juñu. Tsa' mitya kasa binuya kasa ki' buusanu punmalaa, naa binu bain, naa ki' buusa bain tsaren tiba ityu' tsananu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsejtu Jesús tsandin puren, judíola' bale ruku main ji' ya' ajuusha teleditu: In na'ma challan peyaiñu jayu, tsaaren ñuren ja' ñu' tyaapachi yanu ta'kashu juntsaa, mangujnu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsenñu Jesús kujpa' ya' disipululaba juntsa ruku' bendaa jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tsaindetsun ma shinbu asa senduwaraa dilu chuturen 12 añu ma iintsumu shinbu Jesús' benesha ji' ya' jai kapanu ta'kakemi, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","matyu maaliya entsangue pensanguiiketu: “Ya' jai kapanu ta'kakituren ura' mandiyanu juyu”, tyatyaitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tsenñu Jesús benesha mangue-ere' katatu tsandimi: Puluke pensanguide, kaa na'ma; uwain ñu tsainu tsuve tya' kerangue' mityaa ura' mandiyave, timi. Tsandinmalan juntsa shinbu jei ura' mandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tsenñu Jesús juntsa bale ruku' yasha jitu, peyañu fandangu kiikemula dewa'na kata', naa chachilla bain ware' vishkiindindetsu katajitu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Enu demalu' mijii, kaa na'ma peyai'mujchi kasu'tsutun tsanave, timi. Tsandiñu, chachillaya ne uukapundila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tsa detiñun chachillanu avindala deme-e'laañu, Jesús juusha vitu, juntsa pemu kaa na'ma' tyaapanu kakenmalan mangujpaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Entsanguiñu, juntsa tushaya naa nukaba juntsa kuinda demijaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús tsangue' malu' miintsuñu, pai ruku kapuka putyula ya' bendala entsandi' ui'sai jila: ¡Rei Davidnu sera' jamu Na, lalanu tenbityaka! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tsejtu Jesús yasha viñu, juntsa pai ruku kapuka putyula ya' junga deviñu, Jesús tsandimi: ¿Iya ura' mandirenuu juve tenñaa tsa de-ii? tiñu; Ruku, ñuya tsanguenuu juve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsenñu Jesús yala' kapukatala deta'katu tsandimi: “Uwain tsanguenu tsuve”, tya', naake dekeenguiñu bain juntsaisa tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsanguiñu yala katamu tiyala. Tsenñu Jesús yalanu uudenguetu tsandimi: Entsanguiñu naa munu bain waintyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jesús tsandiñun, junu demalu' miimin, juntsa tusha chumu chachillanu, nuka bain Jesús tsanguiñu kuinda deseranguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kapuka putyula katamu detiya' malu' miinu uranu, ma ruku dyabulu puu ju' papatyunu Jesús' junga tajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tsenñu Jesús, juntsa dyabulunu mavelekenmalan papatyu ruku pamu tiyami. Tsanguiñu chachilla mika keenbashindu: Naa-uwanuba Israel chachiitalaya main entsanguiñu kata' kerajtuwa deeyu, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tsenñuren fariseolaya entsa entsandila: Entsa rukunu dyabulu uñi tsanguikaañaa dyabulu me-e'laalaakive, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús naaju pebulutala bain, naa kaa pebulutala bain ne', yala' waku wakudinu yatala ne', Diosnu rei juu tananu jumu mika ura kuinda mijakare' wandis neneimi. Tsejtu naa ti diipeya juu tadeeñu bain, naa ti kiyanchi dilu deeñu bain ura' mandires neneimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tsaindu chachilla tsamantsa waku wakudediñu Jesús katatu yuj tenbityami, yalanu muba washikenuu chachi miyajtu deju', uveja juuñuu tyubaa deju', u'taita nenedeiñu katatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsejtu ya' disipululanu, Jesús laapu' patu tsandimi: Uwaindiyu finu puka imuya pureeve, tsaaren te'kamulaya jayun judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsa' mitya ñulla entsa pu' vijtya miya rukunu pa', te'kamu chachilla eede ti', pa'dei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tsejtu Jesús ya' 12 disipululanu demikatu, Dioschi urajtu kuraa tiremu bu'chullalanu deme-e'laanu tiremin, naa ti diipeya jumulanu bain ura' manguenuu tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Entsalaa juntsa 12 unbere, Jesús' mitya kuinda kenu lara' eramu rukula deeve: ajke' jumiya, Simón titun, Pedro tiitinu ruku bain, ya' naatala Andrés bain, Zebedeo' pai nala Santiago bain, Juan bain; ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe bain, Bartolomé bain, Tomás bain, naa romano uñichi deechu' mitya lushi kamu Mateo bain, Alfeo' na Santiago bain, Tadeo bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","naa Simón, Diosa' lei naajuñuba tsa deki'ñu selandyamu tinu ruku bain, tsenmin Jesúsnu kundaalanu wandi' kakaamu ruku Judas Iscariote bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús entsa 12 disipululanu eendu titi kenuu dejuñuba entsandi dewandi' eemi: Judío chachi jutyula' jungaya ji' netyudei, tsenmin naa Samaria pebulutala bain vi' netyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jimiya Israel chachilla, uveja juuñuu washkemu chachi miyajtu deju' tupiyaañuu nemula' jungaa jidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Junga ji' kuinda ke' wandi', Diosnu rei juu tananu malu yumaa kalen jave tiitidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dilulanu ura' mandire', naa pemulanu bain mangujte', naa manbityu bishpeechi diluulanu bain ura' mandire', naa chachillanu dyabulu punañu bain majuka'lare' me-ee-eekidei. Tsejtu ñulla tiba paangui'mujchin tsangues nenu tiramu de' mitya, yalanu bain ura' demandire' me-ere'ba tiba katyudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lushi ta'tyudei, ne uru juu, ne plata juu, ne kubre juu lushi juuñu bain, ñulla' buusasha ka' pu' tajityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jalichi kiñu buusanu tiba mindala fikenuu puu tajityudei, naa vera manbanakenuu jali bain, naa sandalia juu bain, naa tyu'ke' nenu cha'li juu bain jayuuba ta'tyudei, matyu naaju taawasha kemu chachilla bain yala' taawasha' mitya panda finuu junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Naaju pebulutala ji-i' bain, naa kaa pebulutala ji-i' bain, naaju ruku' junaa kajdiñu urañu kajdi' bain, juntsa pebulunu malu' miityumujchiya junun tsanadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tsaju' juntsa yasha vindu junu chumulanu: ¡Ura' dejusa! tidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tsenñu junu chumu chachilla ura deenmalaya, yalanu tiba bulla jutyu dejusa tya' ñulla depañu tsainu tsuve. Tsaaren yala ura' iinuu chachi dejui'shu juntsaya, ñulla yalanu ura' dejusa tya' depañuba tsa-in jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tsenmin tsandenna ñullanu yasha naa mikandyaba de-ityu', naa ñulla' kuindanu bain meedin detyatyunmalaya, ne yasha manbajtya' mijiindu, ne pebulunu malu' mijiindu bain, ñulla' neepanu ujtupe demangasha'pukidei, tsanguitaa Dioschi urajtu chachi dekure' keewaanu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Uwaindiyu Dioschi kavitu dekenu malunaa juntsa pebulu' chulla, Sodoma pebulunu bain, Gomorra pebulunu bain chumu chachilla naake taaju ke' puinu deeñuba, juntsalanu kayu pullai taaju ke' puinu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ñullanu ne uvejaaba dejuñu, jeengucha kejtsapala eren tsanguentsuyu; tsa' mitya piñi tsaa bibu' juturen, jungajte vejmi' tiba firu' kityu paluma jun tsaadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tsaju' chachilla' kejtsapala wajlatyudei, ñullanu ka', jundaa chumu bale rukulanu kuwa'kera, naa yala' waku wakudinu yatalaba bande' kera kenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Naa in mityaren ñullanu uñila' junga taji'kerake, reila' junga taji'kerake' bain tsa tsanguenu detsuve. Tsa dekenmalaya yala' ajuusha bain, naa judío chachi jutyula' ajuusha bain ñulla iya maa juñu bain wandi' papatinuu junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tsangue' ñullanu, bale rukula' ajuutala detakenmala, ne tyee pakeechunga, naati pakeechunga tya' pensandyatyudei, matyu ñuichi panu ura janmala naati panuu juñuba Diosya ñullanu tsandikaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Matyu pa' bain ñullaa panu dejutyuve, ñulla' Apa' Espíritu ñullanu pumaa panu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tsaa malutalaa naatalaatala de-ajaavi' bale rukulanu dekuwa' tu'kaanu detsuve; naa ya' apala bain ya' nalanu tu'kaanu detsuve, naa ya' nala bain ya' apalanu ajaavi' tu'kaanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","In mityaren kumuinchi chachilla ñullanu tyutyanu detsuve, tsaaren naa tsa deiñu bain mun de-inbera tujlei'mujchi naake ura' kerangue' jintsu'ba tsaa jintsushu juntsaa livee inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Naa-uwanu ma pebulunu firu' kenu bendaa dekiñuba, vee mujtu pebulusha nepiya' miji mijiidei. Matyu uwaindiyu ñulla Israel pebulu jumulanu deneba indetyuren, Chachi Tiya' Nakayamu maanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Naaju disipulu bain ya' mashturunu pullaa jutyuve, naa manda-i' taawasha kemu chachi bain, muba yanu uudenguemunu pullaa jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ma disipuluya ya' mashturu naajuñuba ya bain juntsai tiyatun mikave tyanuu juve, yanu puinu pensangui'mujchi; naa manda-i' taawasha kemu chachi bain yanu uudenguemu naajuñuba ya bain juntsai tiyatun mikave tyanuu juve, ne yanu kayu puinu pensangui'mujchi. ¿Matyu yasha uudenguen chumu rukunaaba dyabulu uñi Beelzebúve timuwa deeshu juntsaa, ka ya' yanu chumulanaa kayu naa timu deenga? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tsaañu' mitya chachillanaa jeetyatyudei. Tyee dus uukaraañuu ju' bain katawan jutyuuya jutyuve, naa tiba pantsuraañu ju' bain mijakeyan jutyuuya dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iya tyee pa' dishkejtsa pan tsandiñu bain, ñulla manbamiya dedanguiñu manban tsandidei, tsenmin iya punguinu dus pan tsandiñu bain, ñullaa ya mututala uidi' daran padei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cha' buluya tu'turen, aamaya tu'nu jutyulanuya jeetyatyudei. Ura jeetyamiya, bulu bain, naa aama bain ñi jelekenu kensha eepukenuu jumu Diosnaa jeetyadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Ma kaa paki lushi juuchin pai kaa pishku ai'mu deetyuka? Naa tsaañu bain, ñulla' Aparen entsa pishkulanu tsa deisa tyai'shu juntsaya, maliba peya' tusha pajtyatyu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tsenmala ñullanu laapu' panmalaya, naa ñulla' mishpukasha chumu achuwanu bain nan dechuñuba Diosya main main demikaa tanave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tsa' mitya jeetyatyudei, ñullaya pishku pure' wakukare' pensanguiñuba kayu juntsa pishkulanu pulla bale deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mun inu keenguemu ju', chachilla' ajuusha in chachiyu timunuya, i bain in Apa selusha chumu' ajuusha, ya' mitya pa', in chachive tinu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tsaaren mun inu keenguemu ju' bain chachilla' ajuusha in chachi jutyuyu timunuya, i bain in Apa selusha chumu' ajuusha ya' mitya pa' in chachi jutyuve tinu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Iya entsa tusha jatu tiba bulla jutyu chukaanu jave tyatyudei; iya tiba bulla jutyu chukaanu jatyu', peletu faawaakaanaa jayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Matyu iya jamiya ya' nala ya' apalaba peletu faaware'kerake, ya' na'mala ya' amalaba peletu faaware'kerake, tsenmin suyala ya' anchamalaba peletu faaware'kerakikaanaa jayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tsa' mitya muchi bain ya' kundara jumiya ya' paandelaren junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mun ya' apanu, ne ya' amanu juu kayu inu pullai estyamuya in chachi tiyanuu jutyuve; tsenmin mun ya' nanu, ne ya' na'manu juu kayu inu pullai estyamuya in chachi tiyanuu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tsenmin mun in mitya tuta'ba tutainuu juu ya' kuusa nanakiñungue' in bendaa jatyulaya in chachi tiyanuu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mun ya' chungamaya maali balengurenu tyashu juntsaa uwain naa-uwanuba tsana chuntsumi katan jutyuve; tsaaren mun in mityan ya' chungama maali balenguutyushu juntsaa naa-uwanuba tsana chuntsumi katanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mun ñullanu sunden mikamuya, naa inu bain sunden mikantsuve. Tsenmin mun inu sunden mika' bain naa inu eemunu bain sunden mikantsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mun Diosa' mitya pamu rukunu, matyu Diosa' mitya pamuve tya', sunden mikamuya, Diosa' mitya pamu rukunu tyee naraa kuwa' sunbewaañuba, mikamu bain tsaren juntsa naraa ka' sunbenu tsuve. Tsenmala mun, Dios naakesa tyañuba tsanguemu rukunu, Dios naakesa tyañuba tsanguemu rukuve tya' sunden mikamuya, juntsanu tyee naraa kuwa' sunbewaañuba, mikamu bain tsaren juntsa naraa ka' sunbenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tsenmin mun in chachi mika tenbiyaa juñu bain, in disipuluve tya', ma basu pi ishpiiñuba kumuya, uwaindiyu tsanguen mitya bene tyeeba uraa kanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús entsandi depa', ya' 12 disipululanu titi kenuu juñu bain dewandi' junu malu' miitu, jundaa chumu pebulutala Diosa' mika ura kuinda mijakares nenu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tsenñu Juan Mungaamu peesu puturen, Dioschi Mi'ke' Kayamu naakes neneintsuñuba mijatu, mantsa ya' disipululanu eemi ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yanu pake'meenu, naa uwain yaa Livee kemu entsa tusha jainuu jushu juntsañu bain, naa veranaa kayu keenanuu juñu bain mijanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tsenñu Jesús pakatu: Miitu Juannu ñulla naake kata' bain, naake mere' bain, tsandi kuinda mandei: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","naa kapuka putyula bain katamu detiyave, naa ura' netyula bain ura' demandiyave, naa manbityu bishpeechi dilula bain ura' demandiyave, naa pungui merajtula bain meemu detiyave, naa pemula bain demangujve, tsenmin lastemaa chumulanu bain Diosa' mika ura kuinda mijakaandetsuve, tidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tsenmin mun iya tsanguiñu kataataake'ba in mitya kundaa tyatyu ju' bain, juntsaya Dioschi ura' imuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan' disipulula miindetsu, Jesús Juannu laapu' pa' chachillanu kuinda ketu tsandimi: ¿Ñulla tiba den chutyuin tenasha jitu ti katanaa dejiyu? ¿Ñañi ishuwachi balla' juya juyaintsu katanaa dejii? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsa jutyushu juntsaa, ¿tyee katanu dejiyu? ¿Ma ruku balenchi jali panaanu katanaa dejii? Ñulla mideeve balenchi jali panaalaya reila' yatalaa chumu deeñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tsaaya, ¿tyee katanaa dejiyu? ¿Diosa' mitya pamu ma rukunu katanaa dejii? Tsaave, uwain tsa deive, Diosa' mitya pamu rukunu katanaa dejive, tsangues nemu rukuutalaa kayu pullaa jumunu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juannu laapu' pataa Diosa' Kiikanu entsa pillave: In mitya wainmu rukunu main ñu' ajkesha erentsuyu, tsenmalaa ñu tyeengues nenuuñuba tsanguenu peepu' tsuunutsu, ti' pillave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Uwaindiyu naaju chachillaba Juan Mungaamunu kayu pullaa dejutyuve, tsaaren Diosnu yala' rei juu tanamulachiya kayu balejtu ruku juuñuulaa Juannu pulla deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan Mungaamu jañu peepumin, chaikama, Diosnu rei juu tananu tinbu, apain tsai tiyasa tya', mantsa chachilla deranchi tsaa tirenu kenchin judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Matyu Diosa' mitya pamu rukula naajula bain, naa Moisés' wandya lei bain, kayu Juan engu jaindyuya Dios ya' chachillachi rei tiya' washke' mandanguenu juñu tinbu naajunuuñuba juntsaatala tene wandinchin juuwa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iya entsandinmala ñulla tsaave tyanu deju' bain, naa tsa jutyuve tyanu deju' bain, ñullaa mijadei: Juanya, Diosa' mitya pamu ruku Elías majainu juushu juntsa ruku juuñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Tsa' mitya mun pungui pu'ba ura' meedi' aseetanguidei! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Challa chumu chachillanu tibaa laapu' panu juwa? Matyu cha' den neneindala kailla dewa'di' aikendu yaitala entsandi papatimu juuñu deeve: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Naa pujkuna depakaañuba, ñulla beela dekityuwa; naa llaki beesa dekiñu bain, ñullaa dewaatyuwa, timu kailla juuñu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Matyu ñullaya Juan Mungaamu ja' nendu Diosnu pensangue' panda fityu junmala, naa binu bain kushtyu junmala, ñullaya: Entsa ruku dyabulu puu rukuve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tsenmala bene Chachi Tiya' Nakayamu jamiya, yaa panda fimu ju', naa binu bain kujchimu junmala: Entsa rukuya panda janbeendu, vin ruku, matyu romano uñichi deechu' mitya lushi kamulaba ura' keranu ruku, tsenmin ujcha lan chumu chachillaba bulu nemuve, tiidetive. Tsaaren titi i' pullantsuñuba juntsanu keetaa naa Dios tsamantsa aseetaju' keewara juñuba aseeta imuve, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tsejtu tiba tsamantsaa ke' keewara jumula aa deke' keewaanu pebulutala chumu chachillanu Jesús ajaa ti' pami, yala veta' pensa mantyu' Diosnu meenguindetyuñu. Tsejtu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Corazínnu chumu chachilla bain, Betsaidanu chumu chachilla bain! Ñulla mika taaju i' puinu dejuve. Matyu judío chachi jutyula' chunu Tiro pebulunu bain, Sidón pebulunu bain tiba tsamantsaa ke' keewara jumula deke' keewaañuya, yalaya kaspelen veta' pensa mangue' Diosnu demeengue', llakingue' keewaanu paba jali depana', naa ju'pe juula bain mishusha detsure'banguichu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tsaaren uwaindiyu, kavitu dekenu malunu Sidónnu chulla bain, naa Tironu chulla bain ñulla naake taaju kenuu dejuñuba tsangue taaju kenu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tsenmala ñulla Cafarnaúm' chullaya, ¿Selusha e'laraichu deeyu pensa dejuu? Tsa jutyuve, ñullaya pemula' pupunanu tena aa tujuushaa kevinu detsuve. Matyu Sodomanu chumu chachillanaa, ñulla' ajuusha tiba tsamantsaa jumula deke' keewaañuya, juntsa pebulu chaiba chu'ba nachuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tsaaren uwaindiyu, kavitu dekenu malunu Sodoma' chullaya ñulla naake taaju kenuu dejuñuba tsangue taaju kenu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Juntsa malutala Jesús entsandimi: Apa, selusha chumulachi bain, tusha chumulachi bain Bale Ruku, ñu yuj urave, entsa judeeshu juntsala aseetaju chachillanaa tsaa keewaatyumujchi, ne chachillanaa tsaa keeware' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Uwain tsaave Apa, ñuren tsaisa tyañuya tsaive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ti bain in tyaapanu tene in Apa dekuwakive. Mu bain ya' Nanu ura' kerajdetuve; ya' Aparen ura' keraave. Mu bain ya' Apanu ura' kerajdetuve, ya' Naren ura' keraave, tsenmin naajulanaa ya' Na, ya' Apanu dekeemijasa tyañuba, juntsalan ya' Apanu keemijainuu judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Naajula bain Moisés' wandya lei mashturula naadetiñuba tsa tsanguenu ke' tyubaa nemu chachillaya in junga jadei, tsenmala iya ñullanu lekakaanu tsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tu junlemu wagara naajun mishunu cha'li teepu' chachilla miya' jiñu tu junle' jimushu juntsaañu i', ñui bain iya ti naaju kisa tyañuba juntsaa ke' inchin manda-iimu tiyaidei; tsai' iya aa ura ruku juñu, tsenmin mika tenbipu ruku juñuba in mityaa juntsai mijadei. Tsejtaa iya naakesa tyañuba tsanguen dechushu juntsaa, ñulla' pensasha tiba jutyu ura' chunu dejuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","matyu iya tyee kiikenu uudengueñuba juntsalaya li'pu' jutyu', uu tsanguenuu dejuñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Saaduma lekanu malunu, ma malu, Jesús ya' disipululaba vijtya jundala pulla' jintsumi. Tsenñu ya' disipulula panda mutyatu, trigu dedyaika' ya' ñi fidundala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tsenñu tsanguindetsu fariseola keenatu Jesúsnu tsandila: ¡Ñuba keekide, ñu' disipulula saaduma lekanu malunuya ken jutyuu kendetsuve! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsenñu Jesús tsandimi: ¿Ñulla lengue' kerajdetuu ma bijee rei David yaba bulu nemulaba panda demutyatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Diosa' yasha vi' Diosnu keewara pan tsumunu, muba finu jutyu ju', chachilla' mitya Diosnu kalen jimu rukulan fikenuu pannun ka' fimu deeñuba? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tsenmin, ¿ñulla Moisés' wandya leinu lengue' kerajdetuu, chachilla' mitya Diosnu kalen jimu rukula saaduma lekanu malunun aa eleshasha taawasha ke' bain ujcha latyu deeñuba? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tsaaren uwaindiyu naa aa eleshanuba pullaa enu main puve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ñullaya Dios entsandinu palaanu aseetanguindetyuñuve: Tenbityamu chachee dejusa tenve; ne animaa tute' ju'ke' inu keewaanun dejutyusa tenve, ti' pillashu juntsanu. Ñulla uwain aseetangui'banguemutuya entsala ti urajtu juuba kindetyuñu' mitya, ujcha delave ti' pai'chu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Matyu uwaindiyu Chachi Tiya' Nakayamuya, saaduma lekanu malutalan tyeenguenu tya'ba tsanguenuu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús junu malu' miitu, chachilla' waku wakudinu yashaa vimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tsenñu junu ma ruku ma tyaapa yujka dedeelaa puñu, Jesúsnu naake' kuipa pun tsandyanchin entsandi pake'meela: ¿Saaduma lekanu malunuba dilulanu ura' mandirenuu juñanga? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tsenñu Jesús tsandimi: ¿Tsandenna ñuichi ma uveja, saaduma lekanu malunun tsaa tujuusha ma lupajtyaiñu, jaiba mangalaajin jutyu dejuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Tsaju' chachee kayu uvejanuba pulla baleve! Tsa' mitya naa saaduma lekanu maluñu bain, chachilla' mitya uraa kenuushu juntsaa tsanguiñu urave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tsejtu Jesús juntsa rukunu: Ñu' tyaapa usakide, tiñu, uskitu kama tyaapa naajuñuba juntsai ura' malami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tsenñu fariseo chachilla junu demalu' miitu, Jesúsnu tyee kitaa tu'kaakeechunga ti' paviikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsenñu fariseo chachilla tsandindetsuñuba Jesús mija' junu malu' miiñu, chachilla pure' surekila. Tsa deiñu, Jesús naaju dilulanuba millangue ura' mandire mandirekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tsejtu ya mu ju' tyee kiike' bain cha' kejtsapala tsaa kuinda kityudei ti' papatimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tsaaren entsaa puimiya Diosa' mitya pamu ruku Isaías naatimuwaañuba tsaa puinaa tsaimi, entsandimuwaañu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Enu entsanave inchi taawasha kemu ruku; yanaa mi'ke' kayu; yaa in estyanu chachive; ya' mityan tsamantsa sundyamu juyu. Iya yanu in Espíritu kuwanu tsuyu, tsenmala nukaba inchi tyee urañuba juntsa mijakares nenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Vinbas nen jutyuve, ne ui'sai neneinu bain jutyuve, naa muba miñutala ya' palaa meren dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ñañi juuñuu dedyaivilla' tsuraañuu chachillanu kayu dedyaivilikeñungue' tsuunu jutyuve; tsenmin ñillu manbenundiyandu ñivijcha jayun e'laakentsumu juuñuu chachillanu bain tsaa manberekiñuu ken jutyuve, chachiitala nukaba veta' veta' ura' iinuu tene kikara' pullaindyuya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tsenmala nuka chulla bain yachi tene ura' inu pensangue', yanun keradinu detsuve, ti' pillave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ma ruku dyabulu puu ju', katatyumin, papatyumin jumunu Jesús' junga tajila. Tsenñu Jesús ura' mandiretu pamu tire', naa katanchi bain katamu tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tsanguiñu chachilla mika keenbashindu, ¿Entsa rukaa rei Davidnu sera' jamu Na ju', engu jainu juushu juntsañanga? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsandindetsuñu, fariseo chachilla demeenatu tsandila: Entsa rukunu dyabulu uñi Beelzebú tsanguikaañaa dyabulu me-e'laalaakive, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tsenñu Jesús fariseola ti pensaa kendetsuñuba mi' mitya entsandimi: Ma reichi uuden juu chumu chachiitalaren kundaa juja'tee ne chudenashu juntsaa, millainu detsuve; tsenmala ma pebulu juju' bain, naa ma yaa chundala juju' bain, kundaa juu ne chudenamiya, entsa chachilla tiba deela' dechutyu' tsanan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tsa' mitya naa Satanásnu laapu' pañu bain, yaatalaren majuka'laantsushu juntsaa, ya maalin ne devela' jiintsu' mitya, ¿naa ketaa ya' chachillanu uudenguen chu' jintsunuu junu jun? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ñullaya inu Beelzebúya dyabulu majuka'laakaantsuve, tiidetive. Tsaaba juñuya, ¿ñullanu bendaa nemulanuya maa dyabulu majuka'laanuu tiremutun? Entsaañu' mityaa naa ñulla tujla deeñuba yalaren entsangue keewaandetsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tsaaren iya Diosa' Espírituchee dyabulu majuka'laamushu juntsaa, Diosnu rei juu tananu malu yumaa jave ti' keewara jutaa tsaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Naa ketaa dee ruku' chunu yanu main vi' yachi tiba taanguenuu jun, juntsa rukunu ajke' tele' tsuutyumujchiba? Tele' tsuutaa tiba taanguenuu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mun iba bulu jutyushu juntsaya inu kundaa juve, tsenmin mun iba bulu Diosa' mitya te'kakeñuu kityushu juntsaa, ne seetyatyu kiñunguentsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tsa' mityandiyu Diosya munuba naa yala' ujcha' mitya bain, naa kentsure' pañu' mitya bain ujcha demanbitsaanu tsuve; tsaaren mun Espíritu Santonun kentsure' pashu juntsaa, Dios juntsan mityaya ujcha manbitsalen jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tsenmin mun Chachi Tiya' Nakayamunu firu' pati' bain, juntsa ujcha' mityaya Dioschi manbitsalanuu juve; tsaaren mun Espíritu Santonu firu' pati' bain, juntsa ujcha' mityaya Dioschi manbitsalanuu jutyuve, naa entsa tusha chunu uwanu bain, naa bene jainu juushu juntsa tinbunu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ura chiya puka bain ura imuve; tsaaren chi urajtushu juntsaa puka bain urajtu imuve, tsaju' naaju chinu bain ya' pukanu keekitun ne mijakeyaimuve. Tsa' mitya inu bain cheeba juñu kere' mijan tsaidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ñulla, piñi juuñuu chachilla! ¿Ñullaren urajtu chachi deeba, naa titaa uraa panu deeyu tenguen? Matyu ñulla' tenbukasha tyuwanamu pensaa fi'pakisha lamu palaa juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ura' chachiya tiba uraa tene pamuve, yanu ura' pensaa puñu' mitya. Tsenmala firu' chachiya tiba urajtu juu tene pamuve, yanu firu' pensaa puñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tsaaren uwaindiyu kavitu dekenu malunuya mu bain pensangui'mujchi naati na'baasa pan chumu deju'ba juntsan mitya tsa tsai kavitu inu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Matyu ñu' pañu palaa' mityan kavitu i' kuipa viina' bain, naa kuipa vin jutyuu ju' bain tsainu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tsenñu mantsala Moisés' wandya lei mashturula bain, naa fariseo chachilla bain Jesúsnu tsandila: Mashturu, lalanu uwain ñunu Diosyaa tsanguekaantsuve tyainuu jumu ke' keewaaka, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tsenñu Jesús tsandimi: ¡Firu' chachilla, Diosnu keenguindandaa chachilla! ¿Diosyaa tsanguekaantsuve tyainuu jumu ke' keewara main ke' keewaaka tikeechunga? Ne jungajte tsaa ke' keewaranu jutyuve, Diosa' mitya pamu ruku Jonás naa-imuwaañuba yanu ke' keewararen mikave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Matyu Jonás naa-inga aa alla ajkasha pen malu, pen kepe pumuwaasu, Chachi Tiya' Nakayamu bain tu tainsha pen malu, pen kepe punu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive' chullaya kavitu dekenu malunu mangujpa' challa chumu chachillanu kavitu ke' kuipa punu detsuve, matyu yalaya Jonás ti kuindaa kiiñuba meelaren veta' pensa demangue' Diosnu meenguemuwa de' mitya. Tsenmin challa enu main pumiya Jonásnu kayu pulla balee puve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tsenmin naa Sursha chumu reina milla bain kavitu dekenu malunu mangujpa' challa chumu chachillanu kavitu ke' kuipa punu tsuve, yaa tsamantsa baasha chumuren ja', rei Salomón' tsamantsa aseetaju' keewara kuinda meenu jamuwa' mitya. Tsaaren challa enu pumiya Salomón' chunu tinbunu i'nu jumu kayu aawa puve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Dioschi urajtu kuraa tiremu bu'chulla ma rukunu malu' miitu ejke tenatala lekanu mi'kes nenduren, katatyu' nuka leka chun tsandyamin ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pensanguetu: “In mala' maanu yanuren miinu tsuyu”, tyamuve. Tsa-i' ya' malu' miiñu chachi' junga mijinmala muba dechutyu, nara mangasha ya juuñuu ju', de-uuna mangatajimuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsejtu malu' miji' mandishpai bu'chulla kayu yanu pulla firu' jumulanu tene manga' maja', juntsa rukunu tsaa millai devinmalaya, kaspele naajuwa ju'ba juntsanu pullai firu' tiyanu tsuve. Matyu juntsaaya i' puinu tsuve challa chumu firu' chachillanu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús tsandi' chachillanu kayu pantsuren, ya' ama bain, ya' naatalala bain jila, yaba kuinda kenu tyatu. Tsejtun juushaa vityu' avindala uidediñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","main Jesúsnu tsandimi: Ñu' ama bain, ñu' naatalala bain ñuba kuinda kenu tyatu avindala de-uinave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tsenñu yanu tsandi' wainmu rukunu Jesús tsandimi: ¿Maa in aman? tsenmin ¿naajulaa in naatalala dejun? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tsanditu tyaapa usake', ya' disipululanu keewaatu tsandimi: Entsalaa in ama deeve, entsalaa in naatalala deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Matyu naajulaa selusha chumu in Apa naakesa tyañuba tsanguen dechu'ba juntsalaa in naatalala deeve, tsenmin in ama deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesús juntsa malunun yasha fale' ji', Galilea aa pusu pi keesha ji' chuimi kuinda mijakaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsenñu chachilla pure' wakudediñu, Jesús ma baakunu lu' chudimi, tsenmala chachillaya pi keesha tsanala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsenñu Jesús, chachilla tyee ken chumu deeñuba tsaatala tene laapu' pa' kuinda ketu, titalaba pure' patimi. Tsejtu entsandimi: Ma ruku ñi waakenu fale' jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tsai' waakiñu mantsa ñiya miñutala depaijñu, pishku ji' tsaa defidekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tsenmala mantsa ñiya tu aa tsutyu shupu' tsundala paijla, tsejtu tu aa bebe' tsutyuñu' mitya jeke shu'kila, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","tsenñuren pajta fale' de-ejbiyu' kakaakenmalan, telele aa erajtu de' mitya tsaa de-ejkeila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tsenmala mantsa ñiya puchi chundalaa paijmi, tsenñu puchi de-awalan juntsa kiyalanu depijteke' ura' awakaatyula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tsaaren manbaateya ura tunu paijmi, tsejtu mika ura' imi. Ma kuyamee 30 ñi kuwake, 60 ñi kuwake, naa 100 ñi kuwakena' bain tsa tsaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Tsa' mitya mun pungui pu'ba ura' meedi' aseetanguidei! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsenñu ya' disipulula Jesús' keesha dejitu: ¿Nenñaa yalanu chachilla tyee kiiken chumu deeñuba juntsaanu tene laapu' papatitundiyu? ti' pake'meela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tsenñu Jesús pakatu: Diosnu rei juu tananu deeñu, tyee ju' pantsunañuu juñu bain ñullanuya dekeewaakive, tsaaren yalanuya tsanguindyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Matyu tsaanu aseetanguemunuya Dios kayu aseetanguikaanu tsuve, tsenmala kayu ura' aseetanguenu tsuve; tsaaren aseetanguityunuya naa jayun aseeta juuñu bain, aseetanguen jutyungue shuikenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsa' mityaa yalanu chachilla tyee kiiken chumu deeñuba juntsaanu tene laapu' papatiyu; matyu yalaya naa kere'ba katatyu deju, naa meena'ba meetyu deju, tsenmin naa aseetanguibainguityu deeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yala tsa deenmalaa Diosa' mitya pamu Isaías naatimuwaañuba tsaa puindu ive. Ya entsandimuwaave: Naa mika mere'ba, aseetangui'nu detsuve, naa mika kere'ba, keengai'nu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Matyu entsa chachillaya yala' pensasha tiba pukaakandyatyu tiya deive, yala' pungui dellukike', naa kapuka bain chayijtu judeeve, tsenmee katan jutyu, meen jutyu, naa aseetanguibainguen jutyu, tsenmin inu keenguityu', inchi livee-ibain in jutyu, timuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tsaaren ñullaya Dioschi ura' imu deeve, ñullaya katamu kapukaa depu', naa pungui bain meemu juuyaa depu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Uwaindiyu pure' chachilla, Diosa' mitya pamu rukula bain, Dios naakesa tyañuba tsanguemu chachilla bain mika katanu tyaturen katatyuwa deeve ñulla' kataakindetsushu juntsa; tsenmin naamika mera' kera tya'ba, meetyuwa deeve ñulla merekendetsushu juntsa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Meedidei, ñi waakemu chachinu laapu' patyeeshu juntsa kuinda, naati' tsandi'ba wainnu tsuyu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mantsa chachilla Diosnu rei juu tananu kuinda meeturen aseetanguityu jumiya, miñutala ñi paijmu juuñu deeve. Tsenñu Dyabulu jamin, tenbukasha juntsa ñi wajkaañuu kuindanu demanbashwaakemu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tsenmala shupu' tsundala paijmu ñiya entsaaya juve: Diosa' kuinda meemin jeke sunden meenguemulaa juntsaañu deeve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","tsejturen chi ju'ba telele aa erajtu juuñu de' mitya, naa-uwanu Diosa' palaa' mitya taaju de-i' bain, tsa jutyu'ba, naa-uwanu firu' kenu bendaa dekiñu wapanai' bain, mangueenguityui tiyamula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tsenmala kaa puchi chundala ñi paijmuya, entsaaya juve: Diosa' kuinda ura' meeturen, entsa tusha tiba kiiken chunutala tene aa pensaa deju', tiba balen juu detadinu tyanu pensachi anbutikayaiñuu i', Dioschi ura' kuindanuya aawakaatyu' puka iwaañunguityu', ne manbashiimulaa juntsaañu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tsaaren ura tunu ñi paijmuya, entsaaya juve: Diosa' kuinda mere' aseetanguemulaa juntsala deeve. Tsangue' puka iiñungue' ma kuyamee 30 ñi kuwake, 60 ñi kuwake, naa 100 ñi kuwakena' bain tsanguemulaa juntsaañu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús manen laapu' pa' chachillanu kuinda mantu tsandimi: Diosnu rei juu tananu juñu pensanguiñuya, ma ruku ya' vijpaasha ura kiya wajkikiñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tsanguiñun manguepe muba dekasu'tsudena, yanu kundaa tyamu ruku jatu, trigu wajkatala firu' ishtape tene demawajkike' mijiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tsenñu bene trigu kiya awa' ya' ñi defalenmala, naa firu' ishtape bain tsaren awala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsenñu juntsa rukuchi manda-i' taawasha kemu chachilla dekata' jitu yanu tsandila: Ruku, juntsa vijpaasha ñu ura kiya tene dewajsuba, ¿naa itaa firu' ishtape bain awatu de-in? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tsenñu vijtya miya ruku tsandimi: Mulaa inu kundaa tyamulaa tsa dekiñuve, timi. Tsenñu yachi taawasha kemu rukula tsandila: Tsaaya, ¿juntsa firu' ishtape muyi' dekepuisa tenguen? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tsenñuren vijtya miya ruku tsandimi: Tsa jutyuve, muityuñaa urave, tsandenna firu' ishtape muyindun naa trigu kiya bain muinaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Matyu tsangaadei: kayu trigu kanu ura jaindyuya bulu de-awasa. Trigu kanu ura tiyanmalaa, trigu kamu rukula jatu urajtu kiyalanaa ajke' dete'ka', tyundyu deke' ju'kenu tsuunu detsuve, tsejtu benee trigu deka' inchi uukaanu tsurensha punu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús kamain laapu' paa kuinda mantu tsandimi: Diosnu rei juu tananu juñu pensanguiñuya, ma ruku ya' vijpaasha mustasa ñi wajkikiñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Entsa ñiya naaju wajnu ñitalaba kayu pulla añuñuve; tsaaren entsa ñi awashu juntsaa, veeta juusha awaimuutalaya naajulanuba kayu pullai aa chimuve. Tsejtu vee chi tsai aa chinmalaya, pishkula ja' ya' alitala yatape ke' tsutsungaamu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tsejtu kamain laapu' paa kuinda mantu tsandimi: Diosnu rei juu tananu juñu pensanguiñuya, ma shinbu pan kendu pen bateya pan kenu llujpe tana' pujkikaanutsumu pu' yande' depujkikaakeñuuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús, ti bain chachilla tyee ken chumu deeñuba juntsaanu tene laapu' pa' mijakaakaa kemi. Tsa' mitya tinuba laapu' patyumujchiya mijakaatyu jujuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tsaaren tsa tsandimiya, Diosa' mitya pamu ruku entsandimuwaañu tsaa puinaa tsaimi: Chachilla tyee kemu deeñuba juntsaanu tene laapu' panu tsuyu; matyu entsa tu dekenu tinbunu wandyajtumin, chaikama tsaa pantsunañunashu juntsa dewainnu tsuyu, timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsejtu Jesús chachillanu deme-eetu yasha mavimi. Tsenñu ya' disipulula kalen jitu, vijpaasha awamu firu' ishtapenu laapu' patu naati' tsandiñuba mijanu pake'meela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tsenñu Jesús tsandimi: Vijpaasha ura kiya wajkemu rukuya, Chachi Tiya' Nakayamaa juntsave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tsenmala vijpalaya chachilla' chunu tu juuñuuve. Ura kiya jumulaya, Diosnu yala' rei juu tanamula deeve, tsenmala firu' ishtapeya Dyabuluchi manda-imu chachilla deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Vijpaasha firu' kiya wajkemu kundaa tyamu rukuya Dyabulaa juntsave. Tsenmala puka denandiñu te'kanu maluya depinu tinbu jumaa juntsave. Tsenmin puka denandiñu te'kamulaya anjeelaa juntsa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tsaju' naa-inga firu' ishtapeya dewa'kara' jupeishu, depinu malunu bain tsaren inu detsuve Dyabuluchi manda-imu chachillaya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chachi Tiya' Nakayamu ya' anjeelanu eenu tsuve, tsejtaa Dios rei ju' chuinsha, naajulaa veelanu ujcha kikaren depuñu bain, naa firu' kemu chachillanu bain devela' kalaanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tsangue' juntsa chachillanu ñi unsurunanu urnusha dekepunmalaya, deware' naa tejkuba depakaakentsunu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tsenmala Dios naakesa tyañuba tsanguen chumulaya, yala' Apa Dios rei ju' chuinsha pajta keraa pi'kelaa chunanu detsuve. ¡Tsa' mitya mun pungui pu'ba meedi' aseetanguidei! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús tsandimi: Diosnu rei juu tananu juñu pensanguiñuya, tusha mennamu lushi juuñuuve. Ma ruku tusha mennamu lushi kata' kalaaturen, manen juntsa tunuren manbantsure' sunden miji', ti ta' bain de-atike', juntsa lushi mennanu tu ati'kakeñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tsenmin Diosnu rei juu tananu juñu pensanguiñuya, main tiba ati'kas ne' ma-atin chuchunamu ruku, kayu bale perla vi puka mi'kes nemu juuñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tsejtu bene katamiya, miji' ti ta'ba de-atike' juntsa perla vi puka ati'kakeñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tsenmin Diosnu rei juu tananu juñu pensanguiñuya, ma waaku pisha tya'ke' ti alla'baasa kakeñuu juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tsangue' alla ma pure' tela deiñu, ainguemula tsalasha deju'li', chudi' dete'lare' ura allaya pishkalinu depu', urajtu allaya demanguepumu deesu, juntsaañuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tsa' mitya depinu malunu bain entsaanu tsuve: anjeela defale' ja' Dios naakesa tyañuba tsanguen chumu chachillanu, firu' chachillaba veekanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tsanguetu juntsa firu' chachillanu ñi unsurunanu urnusha dekepunmalaya deware', naa tejkuba depakaa kentsunu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsejtu Jesús tsandimi: ¿Kumuinchi iya patyeeshu juntsa de-aseetanguiyu? timi. Tsenñu ya' disipulula pakatu: Uwain de-aseetanguiyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsenmin Jesús entsa bain tsandimi: Diosnu rei juu tananu juñu naajuñuba, Moisés' wandya lei mashturu entsai dekeemijashu juntsaya, ma ruku ya' yanu, yachi tiba balee uukaañu pumulanu ti juu bain kasa mangalare, yumaa jumu mangalaakiñuu juuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús tsandi' laapu' paa kuinda juu tene ke' dyatu, junu malu' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tsai' ya' tusha miji', jundala cha' waku wakudinu yatala ji' chachillanu mijakaakaa keñu, mika keenbashindu tsa tsandila: ¿Entsa ruku naa-itaa tsamantsai mijatu-in? ¿Naa ketungue tiba tsamantsaa ke' keewara juula bain ma kiikemi? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Entsaya, kaapinderu taawasha kemu ruku' na jutyuu? ¿María ya' ama jutyuu? ¿Santiago bain, José bain, Simón bain, Judas bain ya' naatalala dejutyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ya' tsujkila dejutyuu laaba endala bulu chudenashu juntsala? ¿Tsaaba, naa-itaa tsai mijatu-in? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsejtu yaichiya, Jesús tyeeba ju' tyu'lekaamu jun tsaañu' mitya, yanu jaiba kerangui'la. Tsenñu Jesús tsandimi: Diosa' mitya pamula vee mujtu nenduya balenguramu deeve, tsaaren ya' chunu tusha bain, naa ya' chunu yasha bain chumu chachillachiya balenguratyu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tsejtu junuya tiba tsamantsaa ke' keewara jumula aa ki'mi, chachilla yanu keenguityu deeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tsangues nenu tinbutala Galileasha chumu uñi Herodes, chachilla Jesúsnu laapu' patu naa naadetiñu bain kuinda meemeekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsejtu ya' chachillanu tsandimi: Chachilla patindetsushu juntsa rukuya Juan Mungaamu peyaishu juntsave, mangujpatu. Tsa' mityaa naa tiba tsamantsaa ke' keewara juula bain kenuu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Entsa Herodesya Juannu peesu kakare' jeru chuwachi teleke' peesu pumuwaami, ya' naatala Filipo' shinbu Herodías' mityaren, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","matyu Juan, Herodesnu entsa entsandimuwaañu: Juntsanu ñu' shinbu juu tanañu urajtuve, tiitimuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tsenñu Herodes Juannu tu'nu tyaturen chachillanu jeetyami, matyu mu bain Juanya Diosa' mitya pamu rukuve tya tyadeiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsenñuren Herodes' nakayanu malu manchañu fandangu kendetsuñu, Herodías' na'ma junu wa'namula' ajuusha beelanguemi. Tsejtu Herodeschi yuj sundyanu' keñu, sundenganchiren ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","juntsa na'manu ti pa'ñuba Diosnu paka' tsanguenbera kenu tsuyu ti' ma tsandimuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsenñu juntsa na'ma ya' ama Herodías paviñu, Herodesnu tsandimuwaami: Juan Mungaamu' mishpukaa palatunu puu taja' inu enu kuwaka, timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tsenñu rei Herodes mika llakindyami, tsejturen tsanguenbera kenu tsuyu ti', tsanguityushu juntsaa yanu Dios taaju puitesa ti' ma pati' mityaa, tsenmin junu pumu chachilla' ajuusharen ma tsandi' mitya, naati pa'ñuba tsanguikaamuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tsejtu peesusha Juan' mishpuka daakakaanu uudenguemuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tsangue' juntsa mishpuka palatunu puuya detaja', juntsa na'manu kuwañu, ya' amanu kuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsenñu Juan' disipulula deji', ya' ujkun bulu ka' demenjitu, bene Jesúsnu wainjila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsaa kuinda mijatu, Jesús baakunu vi' junu lu' jiimi, muba den netyuinsha maali punu. Tsenñun chachilla demijatu, yai bain yala' pebulutala delu' ji' tutu surekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tsenñu Jesús ya' jinu baakusha pu' tusha lutu, chachilla tsamantsadena katatu yuj tenbityami. Tsejtu juntsa kejtsapala dilu pumulanuya ura' demandirekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsenñu yumaa dekependu' kantsuñu, ya' disipulula Jesús' keesha jitu tsandila: Yumaa ma dekependu' kakentsuve; entsa tenashaa muba den nei'nu tenave. Tsa' mitya chachillanu deme-eenu kide, kaa pebulutalaaba deji' tyeeba ati'ka' finudetsu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tsa detiñun Jesús entsandimi: Ti' mityaba yala miinu dejutyuve; ñullaa yalanu panda kuwadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tsenñu yala pakatu: ¡Enuya lala pan, ka manda ta', allaya pallu tadenayu! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tsenñu Jesús tsandimi: Tsaaya, engu inu taja' kuwakai, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tsejtu chachillanu ishtapetala dechungaakaatu, bene ya' tyaapachi man pan bain, pai alla bain kaketu, kai'sha ke'laadi', Diosnu yuj urave titu, pan dedaaka', ya' disipululanu kuwañu, yalaa junu pumu chachillanu veela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tsenñu kumuinchi chachilla panda tyubanbera defiñu laramu mande'kakitun, 12 kubi jungue mande'kala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Panda fimula unbee rukulan juuren 5.000 chachi ma fikeñunguila, naa supulanu bain, naa kaillanu bain mikajturen. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsanguemin Jesús ya' disipulula bejkusha ajke' demandyakasa tyatu, baakusha jeke deme-eepu' me-eemi. Tsaindetsuren yaa junu wa'namu chachillanu deme-eren pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesús tsangue' chachillanu deme-eetu, kuyisha lumi maalindala Diosba kuinda kenu. Tsejtu ya junga maali puren kepemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tsejtu yaa tsananmala, ya' disipulula' miinu baakuya yumaa aa pusu pi kejtala lui miintsumi, tsejtu ishuwa yalanu masmi' juyikentsuñu' mitya pisundachi banvillasai miintsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dechanusha kayu dedanguenu jutyunu uwanu Jesús pi jandalaren yala' junga miintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tsenñu ya' disipulula pinu ma neintsu dekata-eetu, wapana' dejeetya' ui'tu, ¡Ujmu jee! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tsa detiñu Jesús jeti entsandimi: Puluke pensanguidei; iyaa tsaintsuyu. Jeetyatyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsenñu Pedro pakatu: Bale Ruku, uwain ñutuya, inuba ñu' junga pi jandala mikaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tsenñu Jesús: Tsaaya jade, timi. Tsandiñu Pedro baakunu pajtya' pi jandala Jesús' junga jintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tsaaren ishuwa daran juyintsuñuba mijaimiren jeetyaimi, tsenmin tsaa chukanu kikentsumin entsandi wapan pami: ¡Bale Ruku, inu la'kaka! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tsandinmalan Jesús, Pedro' tyaapanu jeke kami, tsejtu tsandimi: ¡Ura' keranguityu unbere! ¿Nenñaa uwain tsaañanga tyatu iyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tsejtu yala baakusha demavinmalaren ishuwa mandyaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tsenñu baakusha pumula Jesús' ajuusha teledenaji', aawa kure' keewaatu tsandila: Uwain ñuya Diosa' Nave, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tsejtu juntsa aa pusunu detyaka' Genesaret tusha jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tsenñu junu chumu chachilla naa Jesúsñuba dekeengala, tsejtu nuka tenasha bain juntsa kuinda demijatu, naaju dilulanu bain Jesús' junga taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tsejtu jayuya ka naa jai kapanuuñuba ta'kakutide ti' u'ta u'tandila. Tsanditu naajula bain ta'kamulaya ura' mandiya mandiyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mantsa fariseo chachilla, Moisés' wandya lei mashturulaba Jerusalénsha pu' jamula Jesús' junga kalen jitu, tsandila: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Nejtaa ñu' disipululaya lala' tinbu rukula naaken chumuwa deeñuba tsangues jinu deeshuba tsanguityutu den? Matyu panda finundiyandu tsanguenuu juñu, tyaapa manbitsaanuu junuren, tsanguibangui'mujchi panda fifidekive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tsa detiñu Jesús tsandimi: ¿Nenñaa ñui bain, tinbunu chumu ñulla' aa-apala naaken chumuwa deeñuba juntsanu keetadinchiren Dios naa naakidei tiñuba tsanguityu juju deeyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosya entsandive: Ñu' apanu bain, ñu' amanu bain balengure' ura' keewaade; tsenmin, Mun ñu' apanu bain, tsa jutyu'ba, ñu' amanu inchi firu' isa ti' bain tutanbera isa, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tsaanuren ñullaya, naa mu bain ya' apalanu entsandinuu juve timu deeve: Naake' ñullanu tiiñuba kuwa' ura' kemishtin tsaayu, matyu kumuinchi iya ti ta' bain tsaa Diosnu tene dekuwakiyu, tinuu juve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tsa' mitya mun tsanguendyai'shu juntsaa ya' apalanu tyeeba kuwa' ura' kivetekenuu jutyuve, timu deeve. Tsandimu de' mityaa tinbunu chumu ñulla' aa-apala naaken chumuwa deeñuba juntsanu keetadinchiren ñulla Diosa' uudennu kuindajtu tiredekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tsa jutyuren tsaañungue keewaamu chachilla! Mikan ura' pamuwaañuve Diosa' mitya pamu ruku Isaías ñullanu laapu' pa' entsanditu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Entsa chachilla yala' fi'pakichiya inu balengurendu bain, yala' tenbukashaya inu pensaba jutyularen tsa tsa dekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tsenmin tsangui'ñuba uraanun inu aawa kure' keewaawaadekive, matyu yala' mijakaraya chachilla naa naakidei tiñuba juntsanun ne mijakaakendetsu' mitya, ti' pillave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsejtu bene Jesús chachillanu demikaketu tsandimi: Entsanu meedi' aseetanguidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tyee fi'pa' juusha vi-i' bain ti' mityaba chachillanu Dioschi urajtu tiretyuve, tsaaren tyee fi'pa' juusha la-i' bain, juntsaya Dioschi urajtu tiremuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tsenñu ya' disipulula Jesús' junga kalen jitu entsandi pake'meela: ¿Ñu tsandiñu, fariseo chachilla kentsura' mika de-ajaatyañuba mijayu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tsa detiñu Jesús tsandimi: Selusha chumu in Apa wajki'ñu kiya jumulaya tsaa teleleba muyainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paviikityudei, yai bain kapuka putyu juuñuuren, kapuka putyulanu miya' neneimu chachi juuñu deeve. Tsa' mitya kapuka putyuutalan tsai' miya' nendetsushu juntsaa, ti tujuubillaaba buluren lupaijnu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsenñu Jesúsnu Pedro tsandimi: Fariseolanu naati pa' tsandi'ba lalanu aseetanguikaaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tsandiñu Jesús pakatu: ¿Tsaaya, ñui bain naa chaikamaba aseetanguenu dejutyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Jaiba aseeta ityuu, fi'pakisha ti vi-i' bain, ajkasha ji', bene mangueviimuñu bain? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tsaaren fi'pakisha, matyu cha' pensasha tyee fale'ba, juntsaya chachillanu Dioschi urajtu tiremuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","matyu cha' tenbukashaa firu' pensa faamuve, naa cha' tutekenu pensa bain, naa vee matsainu pensa bain, naa na'baasa yuj tsa tsainu pensa bain, naa taanguenu pensa bain, naa anbukuinda kenu pensa bain, tsenmin naa kentsure' panu pensa bain faamuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tsa' mitya entsa judeeshu juntsalaa chachillanu Dioschi urajtu tiremu deeve; tsaaren ne tsa tsanguenuu juñun tsanguityu', chachilla tyaapa manbitsalei'mujchi panda fitaa, Dioschi urajtu tiyatyu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús junu malu' miji', Tiro pebulu bain, naa Sidón pebulu bain chunu tusha jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tsenñu main Canaán cha' shinbu jundala chumu ui'sai jindu tsandimi yanu: Bale Ruku, rei Davidnu sera' jamu Na, inu tenbityaka; in na'ma dyabulu ma puutu mika taaju ken chuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tsandintsuren Jesús tiba pakai'ñu, ya' disipulula yanu kalen ji' entsandila: Lala' benesha ma ui'nbashii jantsuve; tsa' mitya, tyee mutyañu bain tsangue' me-eede, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsenñu Jesús tsandimi: Israel chachilla uveja juuñuu tupiyaa neindetsushu juntsala' mityaa inu Dios eeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tsandiñuren juntsa shinbu ya' ajuusha telenajitu: ¡Bale Ruku, inu kive'ka! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tsenñu Jesús laapu' patu tsandimi: Judío chachi jutyulanuya naake' ajke' la'kan tsaayu. Ñunu ajke' la'kashu juntsaa, kaillanu pan chi'ke' kuchalanu juntsa pan kuwakiñuuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tsenñu juntsa shinbu pakatu: Uwain tsaave, Bale Ruku, tsaaren naa kuchala bain ya' miyan ruku panda findu chipasha ya' llujpe pajteñu, yai bain fimu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsandiñu Jesús tsandimi: Shinbu, tsamantsa uwain tsaave tya' keenguemuñuve. Tsa' mitya ñu tyee mutyañuba tsainu tsuve, timi. Tsenñu Jesús tsandinmalan ya' na'ma juntsa uranu ura' mandiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús junu malu' miji', Galilea aa pusu keesha jitu, bene kuyisha lu' chudimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsenñu ya' puinsha chachi pure' wakudila. Tsejtu mantsa ura' nenu jutyuulanu take'kerake, kapuka putyuulanu take'kerake, titalaba yujkaalanu take'kerake, papatyuulanu take'kerake, kayu naa tichiba diluulanu bain pure' takike' Jesús' ajuusha detsuuñu, ura' demandiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tsenñu naa papatyula bain demanba'kera, naa titalaba yujkaala bain ura' mandiya'kera, naa ura' netyula bain ura' dene'kera, naa kapuka putyula bain katandetsu keekeenatu, junu pumu chachilla yuj keenbashintsula. Tsejtu Israel chachilla' keenguenu Diosnu tsamantsa urave ti' papatila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ya' disipululanu mikatu tsandimi: Entsa chachillanu yuj tenbitenve, yala enu iba yumaa pen malu depu', tiba fikenuu detanatyuñu. Tsaju' yalanu panda fikarei'mujchiya yala' yasha me-erendendyuve, tsandenna mindala desmee-i'ba in jutyuulañu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tsenñu ya' disipulula Jesúsnu tsandila: ¿Tsaaren engu muba chutyuinshaba nuka panda katataa tsamantsa chachi pure denashuba millangue fikaanbera katanu dejuwa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsa detiñu Jesús tsandimi: ¿Tsen, ñulla pan nan detanayu? timi. Tsenñu yala pakatu: Pan mandishpallu ta', kaa alla bain jayu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsenñu Jesús chachillanu tutala dechukaatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ya' tyaapachi mandishpai pan ka', alla bain kake', juntsan mitya Diosnu yuj urave titu, dedale', ya' disipululanu kuwañu, yalaa chachillanu veela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tsenñu kumuinchi tyubanbera defiñu, panda llujpe shajaanamu mande'kaketuren, mandishpai pishkali jungue mande'kala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Panda fimula, unbee rukulanun mikaaren, 4.000 chachi ma juula, naa supulanu bain, kaillanu bain mikajturen. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tsejtu Jesús chachillanu deme-eetu, baakunu mavi', Magadán tusha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo chachilla, saduceo chachillaba Jesús' junga dejitu, Jesúsnu tyeeba kikare' kuipa lawaanu tyanchiren, uwain Dioschi mandaju jamutuya, Diosyaa tsanguekaantsuve tyainuu jumu ke' keewara yalanu main ke' keewaaka tita jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tsa detiñu Jesús tsandimi: Kependu'kainsha selu ungalalananmalaya ñulla: Mika uukera' malu chanu juve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tsenmin kepenene selu yapijuru tya' ungalalanashu juntsaa, ñullaya: Umaa ura' malu jun jutyuve, tiitimu deeve. Tsa' mitya selu naanañu bain ñulla juntsanuya nara keemi deeshuba, ¿nejtaa entsa tinbutala tiba i' pulla pulladeishu juntsanuya kera' jaiba aseeta inu ityun? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Ñulla, firu' chachilla, Diosnu keenguindandaa chachilla! ¿Diosyaa tsanguekaantsuve tyainuu jumu main ke' keewaaka tikeechunga? Ne jungajte tsaa ke' keewaranu jutyuve, Jonás naa-imuwaañuba yanu ke' keewararen mikave, timi. Tsandindu Jesús yalanu shuike' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Disipulula aa pusu bejkusha detyakaturen, pan ma pashi' jideiñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús tsandimi: Pashkatyudei fariseola' pan pujkikaantsumi llujpepenu bain, naa saduceola' pan pujkikaantsumi llujpepenu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsenñu ya' disipulula yai tene paviikendu: Lala pan detaatyuñu' mityandive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tsandindetsuñu Jesús mijatu tsandimi: ¿Nendetiyu ñui tene tsandi' pan taakeetyuñuve ti' paviyaala? Ñulla ura' keranguityu chachi deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Chaikama aseetanguindetyuu? ¿Tsenmin man pan juunuren 5.000 unbee rukulanu ma kuwakeesu mandejatyuu? ¿Tsanguiñu laramu llujpe tene mande'katu nan kubi manga'ba tejatyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Tsenmin mandishpai pan juunuren, 4.000 unbee rukulanu ma kuwakeesu juntsanu bain mandejatyuu? ¿Junu bain nan pishkali mande'ka'ba tejatyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nejtaa ñulla jaiba aseetanguenu dejutyuyu iya ura pannu laapu' paindyu', fariseola bain, saduceola bain tyee mijakaamu deeñuba juntsachee tujle' chi'kayanu ityudei tintsuñuba? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tsenñaa umaa aseetanguila Jesúsya ura pan pujkikaantsumuchee tujle' chi'kayatyudei ti'mujchi, yaa pamiya fariseo chachilla, saduceo chachillaba tyee mijakaamu deeñuba juntsachee tujle' chi'kayatyudei ti' tsandintsuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús, Cesarea Filipo pebulu keetala jitu, ya' disipululanu pake'meetu tsandimi: ¿Chachillaya, Chachi Tiya' Nakayamunu muve, tiidetin? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsenñu tsandila: Mantsa chachillaya Juan Mungaamu millave tiidetive, tsenmala veelaya Elías millave detinmala, kayu vejanlaya Jeremías millave ti'kerake', tsandityumee, Diosa' mitya pamu ruku main vera jumuve, tiidetive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsenñu Jesús pakatu: Tsen, ¿ñullaa inu muve detiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsenñu Simón Pedro tsandimi: Ñaa Dioschi Mi'ke' Kayamuve, ñaa naa-uwanuba chumu Diosa' Nave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsenñu Jesús tsandimi: Jonás' na, ñu Simón, Dioschi ura' imuve. Ñunu naaju chachillaba tsandi' wandindetyuve, matyu in Apa selusha chumaa ñunu tsaa aseetanguikaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tsenñu' mitya i bain ñuya, Pedro, shupukave, tintsuyu; tsenmin entsa shupuka jandalaa inu keranguemu bulu chachillanu ya juuñungue ke' chujtinu tsuyu; tsenmala pemula' pupunanu tenasha firu' jumu bain tiba kenu jutyuve yalanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dios rei ju' chuinsha llavi iya ñunu kuwanu tsuyu. Ñu entsa tusha telekiñunguishu juntsaya, selusha bain yumaa telaañuu juñaa tsanguenu tsuve; tsenmin ñu entsa tusha malandekiñunguishu juntsaya, selusha yumaa malandaa juñaa tsanguenu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tsejtu Jesús ya' disipululanu naa yaa Dioschi Mi'ke' Kayamu ju'ba, vee chachillanu tsandi' waingaatyumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesús tsandi' dyatu, juntsa ajkeshaya ya' disipululanu Jerusalénsha jinbera inu juyu ti' kuinda kemi. Tsai' junga jiñu judío bale rukula bain, chachilla' mitya Diosnu kalen jimula' bale rukula bain, Moisés' wandya lei mashturula bain inu pure' taaju iwaakenu dejuve. Tsenmin detu'ñuren, pen malusha mangujtanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsenñu Pedro Jesúsnu vee mujtu miya' jiitu entsandi nepami: ¡Bale Ruku, ñunu Dios tsaa ikaatyusa, ñunuya ne tsaa inu jutyuve! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tsenñu Jesús Pedronu kerai shuwatu tsandimi: ¡Inu vela' mijiide, Satanás! inu tsangue' tyu'lekaakiñunguentsuve. Ñuya Dios naake pensangue' keemuñuba juntsanguityu', chachilla naake pensangue' keemu deeñuba juntsangue pensanguemuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tsejtu Jesús ya' disipululanu tsandimi: Mun in bendaa nenu tenñuba maali balenguutyu', in mitya tuta'ba tutainuu juu, tu'vinu kuusa nanakiñungue', in bendaa nenu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Matyu mun ya' chungamaya maali balengurenu tyashu juntsaa uwain naa-uwanuba tsana chuntsumi katan jutyuve; tsaaren in mityan ya' chungama maali balenguutyushu juntsaa naa-uwanuba tsana chuntsumi katanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Matyu ¿tyee balenu jun, mu bain entsa tusha tiba detaditun, naa-uwanuba tsana chun jutyuu jushu juntsaa? Tsenmin, ¿tyee paanguitaa chunuu junu jun? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Matyu Chachi Tiya' Nakayamuya ya' Apa tsaa, rei juuñuu tsamantsaa ju', ya' anjeelaba maanu tsuve, tsejtu main main tyee kiiken chumu deeñuba juntsan mitya tsa tsangue deke' jinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Uwaindiyu mantsa enu pumula Chachi Tiya' Nakayamu rei juu majantsu katai'mujchiya peyan dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mandishmain malu puiñu, Jesús, Pedronu bain, pai naatala jumula Santiagonu bain, Juannu bain mikake', vee mujtu ma aa kuyisha miya' luimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tsejtu yala keedenaren Jesús vera' tiyanchi iimi. Ya' kajuuya pajta tsangue pi'kenmala, ya' jaliya pajta lu'puñu chakala' ken tsangue' fibaba tene iimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tsainmalan tinbunu chumu rukula Moisés bain, Elías bain Jesúsba kuinda kendu' katawala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsenñu Pedro tsandimi: Bale Ruku, lala enu yuj ura' pukeeñuve; ñuren tsaa mutyañuya enu pen yapaya ke' chujtinu tsuyu, ñuchi main, Moiséschi main, Elíaschi bain main, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsejtu Pedro tsandintsun, ma ñivijcha pi'kelaa ji', tsaa yalanu ñivish panbeesha pukiñu, junu palaa meejatu tsandimi: Entsaa in estyanu Nave. Ya' mitya yuj sundenve. Yanu meedidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Entsandiñu demeetu, ya' disipulula jelanchin yala' kajuru tusha tyullai teedila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsenñu Jesús yalanu kalen ji-i' ta'katu entsandimi: Mangujpaidei, jeetyatyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tsandiñu demangue-eetu, veelanuya mangatai'mujchi Jesúsnun maali uyuna kataakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tsejtu kuyisha pu' demanbajandu Jesús ya' disipululanu tsandimi: Entsa kataadekishu juntsa, Chachi Tiya' Nakayamu peya' mangujtaindyuya munuba waintyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsenñu Jesúsnu ya' disipulula entsandi pake'meela: ¿Nenñaa leichi mashturulaya Dioschi Mi'ke' Kayamu jaindyuren, Elíasya ajke' maanu tsuve tiidetin? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tsenñu Jesús tsandimi: Uwain Elíasya ajke' maanu tsuve, tsejtu tyee ura' demannuu juñuba juntsa deechu' demannu tsuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","tsaaren uwaindiyu, Elíasya yumaa maañuren yanu dekeengatyu', yala naakendya'ba ne kikemuwa deeve. Tsaju' naa Chachi Tiya' Nakayamu bain yala' tyaapanun tsaren taaju ke' puinu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Entsandiñaa umaa ya' disipulula aseetanguila naa Juan Mungaamunaa tsandintsuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yala kuyisha pu' demanbaja' chachilla' puinsha demiiñu, Jesús' junga ma ruku kalen ji', ya' ajuusha teleditu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","entsandimi: Bale ruku, in nanu tenbityade, des-imu nave. Tsejtu mika taaju ken chuve; pure' bijee yaren ñisha vityumiya, pisha pajtya pajtyaive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ñu' disipulula' junga taja' keewaañuren, yalaa ura' demandiretyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tsenñu Jesús tsandimi: ¡Keranguityu chachilla, ñulla firu' chachilla! ¿Naama jina ñuiba tsananujtuuwa? ¿Naama jina iya ñullanu puulan chunujtuuwa? Juntsa kaananu in junga taadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tsejtu Jesús juntsa dyabulunu nepa' me-e'laanmalan, juntsa kaana jei ura' mandiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsenñu ya' disipulula bene yalaren puna', Jesúsnu pake'meetu tsandila: ¿Nejtaa lalaya juntsa dyabulunu me-e'laatyutu deewa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tsenñu Jesús tsandimi: Ñulla uwain tsaave tya' ura' keenguityu chachi de' mityaa me-e'laanu dejutyuve. Uwaindiyu, ñulla' keenguenu pensa mustasa ñi tsantsaa juushu juntsaa, entsa kuyinu: Enu lu' ji', vee mujtu shilla' ji-ii, detiñuba, uwain entsa kuyi shilla' jinu tsuve. Matyu ti bain ñuichi in jutyuuya jun jutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tsejtu Jesús ya' disipululaba Galilea tusha wa'natu tsandimi: Chachi Tiya' Nakayamu chachilla' tyaapasha kuwanu tsuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","tsenmala tu'nu detsuve, tsenñuren pen malusha mangujtanu tsuve, timi. Entsaa kuinda keñu, ya' disipulula yuj llakindyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús ya' disipululaba Cafarnaúmsha jiñu, aa eleshachi lushi kamula Pedronu kalen jitu tsandila: ¿Ñu' mashturuya aa eleshachi deechu' mitya kaya lushi paanguityuu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tsa detiñu Pedro, ya' mashturu paanguemuve, tikami. Tsejtu bene Pedro yasha viñu, kayu muba paindetyun Jesúsya ajke' patu tsandimi: Simón, ¿ñuya naa tiyu? Entsa tusha chumu reila ¿munaa deechu' mitya lushi kamu den? ¿Ya' uudenguen chunu tusha chumu chachillanaa kamu den? ¿Vee mujtu chumu chachilla tyeeba ai'nu jamulanaa kamu den? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tsandiñu Pedro pakatu: Vee mujtu chumu chachilla tyeeba ai'nu jamulanaa kamu deeve, tikami. Tsenñu Jesús tsandimi: Tsa' mitya ya' uudenguen chunu tunu chumu chachillaya deechu' mitya paanguityu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tsaaren munuba ura' kindetyuve tikaan jutyu aa pususha ji', venguu puitu, ajke' kayamu allanu ya' fi' juusha manbaki lushi puu katatu, juntsa lushee ka' in mitya bain, ñu' mitya bain taji' paanguide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Juntsa malutalan ya' disipulula Jesúsnu kalen jitu tsandila: ¿Diosnu yala' rei juu tanamuutala, maa kayu bale rukun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsenñu Jesús ma kaananu mika', yala' kejtala uikaakitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tsandimi: Uwaindiyu ñulla veta' pensa demangue' kailla juuñuu demandi'shu juntsaa, Diosnu yala' rei juu tananu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tsa' mitya entsa kaana tsaa, ti baleyu pensaba jutyu jumaa uwain kayu bale chachive Dios rei ju' chuinsha. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tsenmin mun in mitya entsa kaana juuñuu tiba baleyu pensaba jutyu chachinu mikake' bain inu mikakeñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tsenmin inu keranguemu kailla juuñuu chachillanu ujchaaba delawaashu juntsaya, matyu ujcha lawaanuu jumu kayu tsanguindyuren, ili ilikenu aa shupuka kutunu teevi' lamaa aa shasha keviiñaa yachi kayu uraaba junu juve. Matyu uwain juntsangue' ujcha lawaamu chachillaya ili ilikenu aa shupuka kutunu teevi' lamaa aa shasha kevi' pipimulanuba kayu pullake taaju kenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Chachilla' mitya mika pensandenve, naa-uwanuba ujcha lainuu tene katawaintsuñu' mitya. Uwain naa-uwanuba tsaanu tsuve. Tsaaren naaju chachillaba veelanu ujcha lawaakenuuya dekityusa, tsanguikaamu tsamantsa taaju i' puinu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tsaju' ne ñu' tyaapa' mityaa, tsa jutyu'ba ñu' neepa' mityaa ujcha lashu juntsaa, ñu' bulunu daaka' kepude. Matyu tyaapa bain pallu puu, neepa bain pallu puuya naa-uwanuba manbetyu ñinbaasha kevinu ju'ba, ma tyaapa puu, ma neepa puuya, naa-uwanuba Diosba ura' chuinsha viñu uranu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tsenmin ñu' kapuka' mityaa ujcha lalaishu juntsaa, ñu' bulunu kala' kepude. Matyu pai kapuka puuya ñi jelekenu kensha kevinu ju'ba, ma kapuka puuya, naa-uwanuba Diosba ura' chuinsha viñu uranu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Tsa' mitya kailla juuñuu chachillanu jayuuba balejtu kuretyudei. Matyu uwaindiyu selushaya entsala' anjeela kai'sha in apa' kajuru naa-uwanuba katantsumu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Ñuichiya naajun? Tsandenna ma ruku 100 uveja miyanuren, main piyañu, ¿juntsa 99 uvejalanuya kuyisha deshuikike', piyamunu mami'kenu jin jutyun? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tsejtu uwaindiyu mangata'banguishu juntsaya, juntsa piyamu uveja' mityaa 99 uveja jumulanuba kayu pullai sundyanu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Entsaañu' mityaa, selusha chumu ñulla' Apa bain kailla juuñuulanu maliba depiyatyusa tyave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ñu' naatala ñunu tyeeba firu' kenmalaya, yanu mi'ke', yaba maalindala pa', uwain firu' kikeeñuve pensanguikaade. Tsejtu ñu pañu, uwain tsaave tya' meedishu juntsaa, ñu' naatalanu veta' pensa mangare' ura' mandiretunguive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tsaaren ñu' naatala ñunu meedindyai'shu juntsaa, matyu main, naa pai chacheeba miya' jide, yala pallu, tsa jutyu'ba pen chachi juuyaa, ñulla naadeti' detse'kaañuba meenamu junudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tsenñuren naa yalanu bain meedityunmalaya, kerangue' waku wakudimu chachillanu kuinda kide; tsenmala naa yalanu bain ma meedityuunmalaya, umaa Diosnu keranguityu chachi, tsa jutyu'ba, romano uñichi deechu' mitya lushi kamu ruku juuñungue kurede. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Uwaindiyu ñulla entsa tusha telekiñu dekishu juntsaya, selusha bain yumaa telaañuu juñaa tsanguenu detsuve; tsenmin ñulla entsa tusha malandekiñu dekishu juntsaya, selusha yumaa malandaañuu juñaa tsanguenu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tsenmin entsa bain tsandinu tenve: Entsa tusha ñulla palluuñuba tsandi pa'nu ti' ma tsai deshuwa', in Apanu tyeeba kisa tya' depa'shu juntsaa, selusha kai'sha chumu in Apa tsanguikaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Matyu nuka ne pallu juu, ne pema juu, in mityaren wa'di' depushu juntsaya, i bain yala' kejtsapalaren punu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsenñu Pedro Jesús' junga kalen ji' pake'meetu tsandimi: Bale Ruku, in naatala inu firu' kiñu, ¿iya nan bijee yanu juntsan mitya kuipa faawaren jutyutuuwa? ¿Mandishpai bijee tsaanujtuuwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tsenñu Jesús tsandimi: Ne mandishpai bijeeren tsanguide tinu jutyuyu, matyu mandishpai bijee tenen 70 bijee tsanguenu juve; ura pañuya, naa-uwanuba mi'tyumujchi, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Matyu Diosnu rei juu tananu juñu pensanguiñuya, ma rei, ya' keetala mi'namu bale chachilla lushi deneenañu mangakiñuu juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tsejtu juntsa rei tsangue' lushi mangantsuñu, ya' ajuusha main tsamantsana neenamunu tajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tsenñu juntsa ruku tsamantsana neenatu, naake'ba manbaanguenu jutyuñu' mitya, yanu mandanguemu ruku rei, naa ya' shinbunu bain, naa ya' kaillanu bain veelachi manda-i' taawasha kemu chachi juu ai'nu tirekemi, tsenmin ya ti tañu bain de-atikenu tiremi, tsangue' neenan mitya manganu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Rei tsandiñu, ya' keenu mi'namu bale chachi, rei' ajuusha teledi' u'tanditu tsandimi: Iya te' mangüi'ñuba inu ajaatyatyuka, tsenmala demanbaanguenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tsenñu rei yanu tenbityatu, neenan mitya mangutyuka ti', ne me-eekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tsangue' me-eeñuren, reinu mi'namu ruku junu malu' miitu, main yaba bulu taawasha kemu ruku, yanu lushi jayu neenamunu katami. Tsejtu kutunu kake' ma jadiwaakendu, entsandimi: ¡Inu neenañu lushi manbaanguika! tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsenñu yaba bulu taawasha kemu ruku ya' ajuusha teledi' u'tandindu: Inu ajaatyatyuka te' mangüi'ñuba, tsenmala manbaanguenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tsandiñun juntsa ruku meedityu', tsaa peesu pukenu uudenguemi yanu neenañu lushi demanbaanguinbera. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tsenñu juntsa ruku tsanguiñu, yaba bulu reinu mi'namu bale chachilla uutyai'tu, rei' junga deji', ya naakiñuba tsandi wainjila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tsenñu rei juntsa rukunu mikatu tsandimi: ¡Firu' chachi! Ñu u'tandiñaa naamika pure' nelunañu bain, inu mangutyuka tiwayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tsa' mitya iya ñunu naa-i tenbityañuba, ¿ñu bain ñuba bulu taawasha kemuutala tsaanuu jui'taa tsajuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsejtu rei tsamantsai ajaatyatu, faaterulanu bandemu chachillanu kuwakemi, yanu kumuinchi neenañu lushi demanguwanbera bandenudetsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús tsandi' dyatu tsandimi: Tsa' mitya in Apa selusha chumu bain ñullanu tsarenguenu tsuve, ñulla main main ñulla' naatalalanu ura ñulla' tenbukasharen veta' veta' kuipa faawaren jutyu demandi'shu juntsaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús tsandi depa' dyatu, Galilea tusha malu' miji' Judea tusha jimi, Jordán pinu pensanguiñuya, masku pasha, pajta faanu pasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsenñu junga pure' chachilla bendaa jideiñu, dilulanu ura' demandiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tsenñu mantsa fariseola Jesúsnu naati vera' pakakare' kuipa pun tsandyanchin, yanu kalen deji' entsandila: ¿Ti' mityaañuba kuipa puke' ma ruku ya' shinbunu mavelanuu jun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tsenñu Jesús pakatu tsandimi: ¿Ñulla Diosa' Kiikanu lengue' kerajdetuu, chachi deke' faawaanu tinbunu Dios kemiya unbee ruku bain, supu bain kikemuwaañuba? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tsanguitu Dios tsandimuwaave: Tsa' mityaa unbee rukuya ya' apanu bain, ya' amanu bain shuike' ji', ya' shinbuba buudi' chunu tsuve; tsai' yala main juuñuu tiyainu detsuve, timuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsenmee yala pai chachi juuñuu dejutyu', main juunu detsuve. Tsa' mitya Dioschiren tsaa ma buuta' chujtyaabillaya, mu bain maveenu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsenñu fariseola tsandila: ¿Tsaaya, nejtaa unbee rukula, supulanu mavelave tinu kiika piike' kuwashu juntsaya, Moisésya mavelanu dejuve timuwaatun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tsenñu Jesús tsandimi: Matyu ñulla meedityu, pañu meetyu chachi deeñu' mityaa, Moisésya tsangue' ñulla' shinbulanu mavelanuu kikaamuwaave; tsaaren chachi deke' faawaanu tinbutalaya tsa jutyuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tsaaren iya tsandintsuyu: ne ya' shinbu vee matsaiba indyuren ya' ruku mavela' miji', vee shinbuba machushu juntsaa, juntsa rukaa vee matsainu ujcha lantsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tsenñu ya' disipulula tsandila: Tsaaya, unbee rukula supulaba tsaa ne juunuushu juntsaa, supunga' chui'ñaa urave, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tsenñu Jesús pakatu: Ñulla padetishu juntsa palaanu kumuinchi chachilla tsandyanu dejutyuve, matyu naajulanaa Dios tsandyakaañuba juntsalan tsandyainuu judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Matyu mantsa chachillaya nakayamin supunga' chun jutyuu nakayaimu deeve; tsenmala mantsalaya supunganu deeñu bain, chachiitalaren tyeeba ke' supungan jutyungue tiremu deeve; tsenmala mantsalaya Diosnu ya' rei juu tanan mityaren supungan jutyu tiya' maali dechuve. Tsa' mitya mun tsaa chunuu jutuya tsaa dechusa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsandiñu, Jesús' ajuusha mantsa kaillanu tajila, ya' tyaapachi mishunu ta'ka', yala' mitya Diosba kuinda kisa detyatu. Tsenñun ya' disipululaya kaillanu tajimulanu ajaa tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tsenñu Jesús tsandimi: Kailla in junga janudetsu daatadityudei, matyu Diosnu yala' rei juu tanamulaya entsa kailla tsaalaa dejuñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tsejtu ya' tyaapachi kailla' mishpukatala deta'ka' Dioschi ura' de-isa ti' dyatu, junu malu' vee mujtu miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma ruku Jesúsnu keejitu tsandimi: Mashturu, ¿tyee uraa kitaa naa-uwanuba Diosba ura' chunuu juwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tsenñu Jesús tsandimi: ¿Nendiyu tyee urañuba juntsaatalaa inu pake'meentsumi? Uraya mainren juuve. Tsaaren ñuren naa-uwanuba Diosba ura' chunu tenñuya, ya naa naakide tiñuba tsanguen chude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tsenñu juntsa ruku, ¿Dioschi naaju uudenlaa juntsa den? timi. Tsandiñu Jesús tsandimi: Chachiitala tu'tyude, vee matsaityude, taanguityude, anbuti' veelanu kuipa punu kityude, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ñu' apanu bain, naa ñu' amanu bain balengure' ura' keewaade, tsenmin ñu maali naa-i estyamu ju'ba ñuba kalen chumu chachinu bain juntsai estyade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tsenñu juntsa nakun ruku pakatu: Kumuinchi juntsa naatiñuba tsanguen chumuyu. ¿Tyee kayu vera kenuu juwa? ti' pake'meemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tsenñu Jesús tsandimi: Ñuren kuipajtu ma narai tindenñuya, ñu ti ta' bain de-atike' purelanu kuwade. Tsanguishu juntsaa kai'sha tiba tsamantsa balee jumula tadinu tsuve. Tsangue' in disipulu tiya' in bendala jade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsejtu Jesús tsandiñu meetu, juntsa nakun ruku yuj llakindya' miimi, mika taruku' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsenñu Jesús ya' disipululanu tsandimi: Uwaindiyu tarukulachiya Diosnu yala' rei juu tananu mika li'puve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tsenmin manen tsandintsuyu: main tarukuchi Diosnu ya' rei juu tananu mika li'punchiren, ma kameyu ityu kapukanu pullainuuba juñuya, juntsa kameyu kayu ura' ne dapullaichuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsenñu ya' disipuluba Jesús tsandiñu demere' mika meenbashtu tsandila: Tsaashu juntsaa, ¿maa livee inuu juchunga? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tsenñu Jesús yalanu ke-eetu tsandimi: Chachillaya naake' tiba tsa tsangue kenuu dejutyuñuba, Dioschiya tiba in jutyuuya jutyu', imu tene judeeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsandiñu Pedro tsandimi: Lalaya ti taawa ju' bain millangue deshuike' ñu' bendaa dejayu. ¿Juntsan mitya laachiya tyee junujtun? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tsenñu Jesús tsandimi: Uwaindiyu kumuinchi tiba kasa tene mannu malu janmala, matyu Chachi Tiya' Nakayamu rei juu tsamantsaa ya' chunu chunbullanu chunu tinbunu, ñulla in bendaa jamulaya 12 chunjuu reila' chuchudinu chunjuunu shilii dechu', Israel chachilla 12 sera' jimu paandelanu kavitu kenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tsenmin mun in chachi ju' in mityaren ne ya' ya shuikike, naatalalanu shuikike, apalanu shuikike, ya' nalanu shuikike, ne tu taju' bain tsaa juntsa deshuikike' in bendala jamuya, juntsan mitya ti bain 100 bijee yapa mangandene kenu tsuve, tsai' naa-uwanuba Diosba ura' chunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tsaaren challa pure' chachilla balen chachi judeeshu juntsalaa, bene ne chachi juu mandinu detsuve, tsenmala challa pure' chachilla ne chachi judeeshu juntsalaa bene balen chachi juu mandinu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Diosnu rei juu tananu juñu pensanguiñuya, uva vijtya miya ruku dishkepenene fale', taawasha kikaanu chachi mi'kes neiñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tsejtu umaa demi'ke' katu, taawasha kemula ma malunu naake kamuwa deeñuba tsangue paanguenu ti' tsai shuwatu, ya' uva vijpaasha taawasha kenu eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsejtu manen kepenene mandishtaapai ura insha mafaatu, buli ati atikinsha veela tiba ki'mujchi ne uidena katatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","tsandimi: Ñui bain in uva vijpaasha taawasha kiidei. Naake paanguenuu juñuba tsangue paanguenu tsuyu, timi. Tsenñu yala taawasha kenu jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsejtu manen pajta katyu uranu bain, naa kepenusha pen ura insha bain mafaatu tsarenguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tsenmin naa kepenusha, man ura iinutala mafaatu bain, kayu veela tibangui'mujchi ne uidenañu katatu tsandimi: ¿Nen denayu tibangui'mujchi enu ma malu entsanala? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tsenñu yala tsandila: Muba lalanu taawasha kikaanu kaindetyuñu' mitya denayu, tila. Tsenñu entsandimi: Tsaaya, ñui bain in uva vijpaasha taawasha kiidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tsenñu umaa dekependu' kañu uva vijtya miya ruku taawasha kekaren keenamu rukunu mikatu tsandimi: Taawasha kemulanu mikatu main main paanguide, tsaaren bene videishu juntsalanaa ajke' paangue', ajke' vimulanaa bene paanguikide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tsejtu kepenusha man ura iinutala taawasha kenu vimula lushi kanu dejiñu, main main ma malu' mitya taawasha dekiñu paanguen tsanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsenñu ajke' taawasha kenu vimula dejitu, yalaa kayu lushi aa kachu deeyu tyaturen, yai bain ma malu taawasha' mitya nan kumu deeñuba juntsan kakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tsenñu ajke' taawasha kenu vimula lushi tsantsa paanguikeñu dekatu, uva vijtya miya rukunu vera' tya' depaviikendu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tsandila: Entsa bene taawasha kenu videishu juntsa chachillaya ma ura taawasha kidekiñun, tsaren ma paanguikaakive, naa lalaya pajta jelekinguentsu ma malu taawasha ma kidekiñu bain, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tsandindetsuñu uva vijtya miya ruku mainnu tsandimi: Ura' keranu chachi, iyaa ñunu tiba firu' juu kendyuyu. ¿Ma malu taawasha' mitya nan kanuu juñuba iya ñuba tsandi paindyuwa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tsa' mitya ñu' lushi ka' miide; iren entsa bene videishu juntsalanu bain ñunu naake paangue'ba tsanguenu tenshu juntsaya juntsaa inchive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿In lushinuya ti ken denñuba tsanguenuu jutyuwa? Tsa jutyu'ba ¿iya veelanu puita urañu yalanu kishtenguee? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tsa' mitya challa ne chachi juuñuulaa, bene bale chachi juuñuu mandinu detsuve; tsenmala challa bale chachi juuñuulaa bene ne chachi juuñuu mandinu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalén jinu miñusha jindu ya' 12 disipululanu yai tene mikakitu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ñulla mideeve challa Jerusalénsha jikeentsuñu bain. Chachi Tiya' Nakayamuya junga chachilla' mitya Diosnu kalen jimu bale rukula' tyaapasha bain, leichi mashturula' tyaapasha bain kuwanu tsuve, tsenmala yanu kavitu ke' tutainuu kuipa punu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tsejtu judío chachi jutyula' tyaapasha dekuwanmala, yala uukapu'kera, debande'kerake', kuusanu tu'pu' tu'nu detsuve, tsenñuren peñu pen malu insha mangujtanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo' shinbu ya' nalaba buluu Jesús' junga kalen ji', ya' ajuusha teledi' tyeeba pa'ñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús pakatu: ¿Tyee mujken? timi. Tsenñu juntsa shinbu tsandimi: Ñu rei ju' chuinsha, ñu' keesha in nalanu mainnu urandyasha chujti', kamainnu jalandyasha chujtikisa tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tsandiñu Jesús tsandimi: Ñulla inu tyee pakendu'ba mijdetuve. ¿Iya wajtun tsamantsa taaju ke' pullainu juuwashu juntsa, ne tyeeba juñu kujchin tsanguenu juñu, ñui bain kushnuu dejuu? timi. Tsenñu yala pakatu: Tsanguenu dejuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tsenñu Jesús tsandimi: Uwain ñui bain, i tsamantsa taaju ke' puinu juuwashu juntsa i' puinu dejuve, tsaaren urandyasha, ne jalandyasha chudinu pakidekishu juntsanuya iyaa naaken tsaayu; juntsaya in Apachiren yumaa develaañuu juuve yaa munu kuwandya'ba tsanguenuu juñu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tsenñu vejan paitya disipulula tsandiñu demeetu, entsa pai naatalalanu ajaatyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tsenñu Jesús demikatu tsandimi: Ñulla mideeve naa judío jutyu bale chachillaya yaichi manda-imu chachillanu naake firu' kendya'ba tsanguen chumu deeñuba, tsenmin judío jutyu aa bale rukulaya, chachillanu menaa tyullaa tanamu deeñu bain ñulla mideeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tsaaren ñuitalaa tsaanu dejutyuve. Tsa jutyu' mun ñuitala kayu bale tiyachi tenñuba, vejanlachi taawasha kemu chachee junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tsenmala mun ñuitala balen chachi tiyachi tenñu bain, ñuichi taawasha kemu chachi junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Matyu naa-inga Chachi Tiya' Nakayamu bain entsa tusha jatu, ne yachi tiba ke', yanu dewashkisa tya' jatyumujchi, yaa muchiba tiba uraanuu ke' kuwanaa jashu, tsenmin pure' chachillanu la'kanu yaa tutanu jashu, ñui bain tsaren dejusa tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yala Jericó pebulunu demalu' miiñu, Jesúsnu chachilla pure' surekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tsaindetsu pai ruku kapuka putyula miñu kelunu chunatu, Jesús junu puintsuve detiñu demere' uti' patu entsandila: ¡Bale Ruku, rei Davidnu sera' jamu Na, lalanu tenbityaka! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tsandindetsuñu, chachillaya mandyasa ti' de-ajaatiñun, yala kayu uti', entsa entsandila: ¡Bale Ruku, Davidnu sera' jamu Na, lalanu tenbityaka! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tsenñu Jesús uidikatu, yalanu mika' pake'meetu tsandimi: ¿Ñulla' mitya tyeenguisa tenguen? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tsandiñu yala pakatu: Bale Ruku, lalanu katamu tiyanu tenve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tsenñu Jesús tenbitya' yala' kapukanu ta'kanmalan, kapuka putyu rukula juntsa uwanun katamu detiya' Jesúsnu bendaa jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yumaa Jerusalén pebulu kalen jitu, matyu Ulibu chi chunu kuyi keetala Betfagé kaa pebulubi dejitu, Jesús ya' disipululanu pallu eemi ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","entsanditu: Bejku pasha, engu ke-eenashu juntsa kaa pebulusha jidei, tsejtu junu supu buru teetsunanmala, ya' kaana bain ya' kelunu uyuna katanu detsuve, tsejtu langa' engu taadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tsandenna mulaa depake'meenmalaya: Bale Ruku menesteve, tsaaren wajturen mangunu tsuve, tidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Entsaa puimiya kaspele Diosa' mitya pamu ruku naatimuwaañuba tsaa puinaa tsaimi, entsandimuwaañu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén, tsandityumee Sión tinu pebulunu chumu chachillanu entsandidei: ¡Keekidei enu, ñulla' junga jantsuve ñulla' rei, ma burunu tiba daj keewarajtu, llupu kaa burunu chuu jantsuve, buli pande' ee-eekenu animaa kaana jandala!, ti' pillañu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tsenñu ya' disipulula dejitu, Jesús naakidei tiñuba tsanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tsejtu supu buru ya' kaanaba deka' taji', yala' jandala jali vikaala. Tsa dekiñu Jesús jandala lu' chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tsenñu purenamu chachilla, mantsalaya yala' jali miñutala delakare'kera, tsenmala mantsalaya chi ali dedaaka' miñutala tsure'kerakentsula, balengure' keewaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tsejtu tsamantsa chachilla ya' ajkesha jimula bain, naa benesha jimula bain entsandi' ui'nbashiila: ¡Rei Davidnu sera' jamu Naya, yuj sunden jusa! ¡Dioschi ura' imuve, Bale Ruku' mitya jamuya! ¡Kai'sha selusha bain yuj sunden jusa! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tsenñu Jesús Jerusalénbi vijiñu, kumuinchi chachilla jupaijtu, entsa entsandila: ¿Mujtun entsaa? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tsenñu purenamu chachilla entsa entsandila: Entsaya Diosa' mitya pamu Jesúsve, Galilea tusha Nazaret pebulubi chumu, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús aa elesha chunu veeta juusha vitu, junu ufeenda kuntsumi atin pumu chachillanu bain, naa junu ati'kan pumu chachillanu bain tsaa demajuka'laake', naa lushi maveten chundala bain, naa paluma atin chundala bain debuityuleekitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","tsandimi: Diosa' Kiikanu entsandive: In yaa Diosba kuinda kenu ya junu tsuve, tive, tsaanuren ñullaya entsa yanu taamula' vi' pantsudinu tujuu tiredekiñuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsenñu juntsa aa elesha chunu veeta juusha, Jesús' junga naa kapuka putyula bain, naa ura' netyula bain dejiñu, ura' demandiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsangue' Jesús tsamantsa keenbashiinuu ke' keewara kiikiñu, tsenmin naa kailla bain aa elesha chunu veeta juusha: ¡Rei Davidnu sera' jamu Naya yuj sunden jusa! ti' ui'nbashi deeñu, chachilla' mitya Diosnu kalen jimula' bale rukula bain, naa leichi mashturula bain ajaatyatu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesúsnu tsandila: ¿Kailla entsandindetsu ñuya merendyuu? tila. Tsenñu Jesús pakatu: Narana meenayu, tsejtu ¿ñullaa Diosa' Kiikanu juntsanu laapu' patu entsandimuñu lengue' kerajdetuu? Entsandive: Kaa kailla' beesachi bain, naa chuchu fikemu kailla' beesachi bain juntsalachee tsamantsa ura rukuve tikayanu juve, ti' pillave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tsejtu yalanu shuike', pebulunu malu' miji', Betaniasha ji' tsun chayami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kepenene Jerusalénsha miindu Jesús panda mutyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsejtu igu chi main miñu keesha chu kata', puka kanu tya' kalen jituren, tiba natyu jakin puu kataakemi. Tsejtu juntsa igu chinu tsandimi: Naa-uwanuba puka ma-i'keemee, timi. Tsandiñu me-ejkeimi juntsa igu chi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tsaiñu dekatatu, ya' disipulula yuj keenbaishtu Jesúsnu tsandila: ¿Nejtaa entsa igu chi jei me-ejketu in? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tsenñu Jesús tsandimi: Uwaindiyu ne tsaichunga tya' pensandandajtu ju' Diosnu uwain tsaave tya' keenguemu chachi deeshu juntsaa, entsa igu chinu iya naakeñuba ñulla juntsan kikenu dejutyuve; kayu vera bain ke', naa ne entsa kuyinu: Aanu lu' ji' lamaasha pajtyaide tiñu bain, uwain tsainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tsaju' ñulla ti pakike' bain uwain tsaave tya' Diosba kuinda ke' depakenmalaya tsa tsaikaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Entsangue' dyatu, Jesús aa elesha chunu veeta juusha vi' chachillanu mijakaren puñu, chachilla' mitya Diosnu kalen jimula' bale rukula, judío bale rukulaba ya' junga kalen jitu entsandi pake'meela: ¿Ti' mityaa entsangues nentsuyu? ¿Maa ñunu aantsangues nekaantsun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tsenñu Jesús bain tsandimi: I bain ñullanu ma pake'mera kenu tsuyu; tsenñu ñulla depakanmalaa, i bain wainnu tsuyu maa inu entsangues nekaantsuñu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Maa Juannu ere' mungares nenu tireñanga? ¿Diosya tsanguiñanga? ¿Chachillaa tsa dekiñanga? timi. Tsenñu yaitala veta' veta' paviikendu tsandila: Lala naati' Juan Diosa' uudenchee tsangues nemuve tin tsa deeyu. Tsandishu juntsaa: ¿Nenñaa yanu keranguityuwa deeyu? tinu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tsenmin lala naati' chachilla' uudenchee tsangues nemuve tin tsa deeyu. Matyu Juannuya naaju chachilla bain Diosa' mitya pamu rukuve tyamu de' mitya, lala tsa detishu juntsaa firu' kenu dejuve, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsejtu Jesúsnu pakatu: Lalaya Juan mu' uudenchee tsaita nemuwaañuba mijdetuyu, tila. Tsa detiñu Jesús bain tsandimi: Tsaashu juntsaa, i bain ñullanu wandin jutyuyu, maa inu entsangues nekaantsuñu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tsejtu Jesús yalanu pake'meetu tsandimi: ¿Naajuin ñuichiya entsa kuinda? Ma ruku pai na miyami. Tsejtu ajke' nanu kalen jitu tsandimi: Apa, uma malu ñu in uva vijpaasha ji' taawasha kiide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tsenñun ya' na pakatu: ¡Inaa jindendyuve! titun, bene veta' pensa mantu, taawasha kenu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ya' apa bene kama nanu bain tsandita jimi. Tsenñu juntsaya: Apa, jinu tsuyu, titun jityumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tsa' mitya ¿naajaa ya' apa naakesa tyañuba tsanguitunguen juntsa pallulanu? timi. Tsenñu yala pakatu: Ajke' na jumaa tsanguiñuve, tila. Tsa detiñu Jesús tsandimi: Uwaindiyu romano uñichi deechu' mitya lushi kamula bain, naa mu'baasa tsu tsudimu shinbula bain, yalaa Diosnu yala' rei juu tananu detsuve, ñullaya rei juu tananu dejutyuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Matyu Juan Mungaamuya naake ura' ken chunuu juñuba tsangue dekeemijakares neñun, ñullaya dekeenguityuñuba, romano uñichi deechu' mitya lushi kamula bain, naa mu'baasa tsu tsudimu shinbula bain yalaya dekeenguive. Tsejtu yala tsangue' keenguendetsuñu, ñulla ma entsangue kataturen, ne veta' pensa mangue' keranguee kiba dekityuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kama laapu' kuindanu meedidei: Ma ruku, pure' vijtya miyaa ruku, ma uva vijtya kemi. Tsejtu veeta bain ke', nunbanaa binu kiikenu ju'ba juntsa bain ke', naa washna' keekeenanu aa katyu ya bain dekemi. Tsanguitu vijtya miya ruku, mantsa taawasha kemulanu medya washkare' baasha ma jiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tsejtu puka de-i' dekanu tinbu iñu, yachi taawasha kemu chachillanu yachiya manganu uudengue' eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tsenñuren vijtyanu medya washna' taawasha kemu rukula, juntsa ruku' taawasha kemu chachillanu dekatu, mainnuya debandekila, tsenmin kamainnuya ma tutekila, tsenmin kayu veranuya shupukachi ma dekikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsa dekiñu, vijtya miya ruku yachi taawasha kemu chachillanu, ajke' bijeenu naake eemu ju'ba juntsanu kayu pullake me-eemi, tsenñuren manen tsarenguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tsejtu umaa pulla'bi ura ya' nanun ma erekemi, ya' pensaya: “In nanuya balengure' jeetyanu dejuve”, tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tsenñuren vijtya medya taawasha kemula ya' nanu katalan yai tene entsandila: Entsaa ya' apa peyanmala, yachi tiba mandashuwanuu jumuve. ¡Yanu tuteke', lalaa kumuinchi entsa detashuwadaa! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsanditu juntsa nanu ka', vijpala jutyuinsha vee mujtu takike' tsaa tutekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tsenñu uva vijtya miya ruku maatu, ¿juntsa chachillanu, tyeenguenu juve tenguen ñullanuya? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tsenñu yala tsandila: Juntsa firu' kemu chachillanu tenbiputyu detutekenu juve, tsangue' ya' uva vijtyaya veelanu, matyu puka inmala kamin, yanu naake mangunuu juñu bain, naa-uwanu mangunuu juñu bain jeke tsa tsangue mangunuulanaa medya manguwanu juve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tsenñu Jesús tsandimi: ¿Tsejtu ñullaa Diosa' Kiikanu entsa pillañu lengue' kerajdetuu? Entsandive: Ya kemula' kepu shupukaa kayu deenamishtimu shupuka tiyaive. Juntsaya Bale Rukaa tsanguiñu' mitya, kumuinchi sunden keenbashindetsuyu, ti' pillave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tsa' mityandiyu, ñulla Diosnu rei juu tananu dejuñuba ne vijtyaaba juñu ñullanu machi'ken tsangue', naajulaa puka iwaren tsanguenuu dejuñuba, juntsalanaa mangunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tsenmin shupukanu pensangue' panmalaya, mun shupu' jandala pajtyai' bain de-ijchaa pajtyainu tsuve, tsenmala munaa juntsa shupuka paijñu bain, tsaa de-ijchaa jiinu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsenñu chachilla' mitya Diosnu kalen jimula' balela bain, naa fariseo chachilla bain, Jesús tsandi', laapu' paa kuinda tene kiiketu, yalanaa meeware' pa' tsandiñuba aseetanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tsejtu Jesúsnu peesu kanu tyaturen, junu pumu chachillanu jeetyala, matyu junu pumu chachillaya, Jesúsya Diosa' mitya pamu rukuve tya tyadeiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús, chachilla' mitya Diosnu kalen jimula' bale rukulanu bain, fariseolanu bain laapu' kuinda juu mantu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Diosnu rei juu tananu juñu pensanguiñuya, ma rei ya' nachi matsunu fandangu kikiñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tsejtu yachi taawasha kemu chachillanu uudenguitu, bulu puve'nu mikaya chachillanu mamijakaanu eemi. Tsenñun yala pundyai'tu jityula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tsenñu manen yachi taawasha kemu chachillanu uudengue' mamijakares nenu me-eemi entsanditu: Bulu puve'nu janu judeeshu juntsa chachillanu entsandidei: Yumaa panda deke' keenayu, naa wagaa juula bain, naa kayu vee animaa nakululuu juula bain detuteke' teengare' keenayu. Tsa' mitya kumuinchi yumaa dekike' keenayu; fandangu jadei, tive, tidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tsejtu tsandi' ma eekiñu bain, jandetyai'tu, mainya taawasha kenu jinmala, kamainya tyeenguitaa lushi laren chumu ju'ba tsanguenu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tsenmala kayu veelaya reichi taawasha kemu chachillanu deka' bande' tutekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tsenñu rei pure' ajaavi-i', ya' suutadulanu ere' detu'kaakemi bande' tu'mu chachillanu, tsangue' naa yala' chunu pebulu bain deju'kikaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsejtu rei mantsa yachi taawasha kemu chachillanu tsandimi: Matsunu fandangu kendu panda finu yumaa dejuu ma chunaren, bulu puve'nu jainuu chachilla tsai' ja' bulu punuu jutyuwa deeñuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tsa' mitya chachi den pulla pullainu miñutala deji', munu kata'ba entsa fandangu panda five'nu mikadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tsenñu reichi taawasha kemu chachilla miñusha deji', naa ura chachillanu bain, naa firu' chachillanu bain wa'kaadekiñu, bulu puve'nu jamu chachilla ya tyuwai wa'dila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tsa deiñu rei, fandangu bulu puve'nu jamu chachillanu keenu vitu, ma ruku fandangu neneinu jali panajtu jiñu kata' kerai shuwatu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","tsandimi: Ruku, ¿naa itaa fandangu neneinu jali panajtuba ñu engu vijatu iyu? timi. Tsandiñu, jaiba pakai'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsenñu tiba veles neneimu ya' chachillanu rei tsandimi: Entsa rukunu tyaapa bain, neepa bain teleke' avindala tsamantsa yapijurunainsha kelaakidei, timi. Tsanditu Jesús tsandimi: Junu ware' naa tejku bain depakaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Matyu mikayamulaya pure' judeeve, tsaaren ura te'laramulaya jayun judeeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsenñu fariseo chachillaya miji' yai tene pensanguenchin juula, tyeenguitaa Jesúsnu tujle' pakare' kuipa vichunga tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tsejtu yaiba buunamu chachillanu bain, Herodes rei juñuba uraa tyamu chachillanu bain buluu Jesús' junga eela, entsandidei titu: Mashturu, mideeyu ñuya anbutityu rukuñuba, matyu chachillanu Dios naaken chusa tyamuñuba anbuda jutyu tsangue mijakares nemu rukuve, chachilla tyeendichudeenga tya' pensandyatyu, tsenmin chachilla kapukachi naa-i dekatawañuba ne tsaanaa tejanguera' tsa deeve tyatyu rukuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tsa' mitya ¿ñuya naa tinu juyu? ¿Tsanguenuu jun, tsanguenuu jutyun, romanolachi kayu aa uñinu deechu' mitya lushi kuwa kuwakenu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tsenñu Jesús yala firu' pensa juuya tsandis nendetsuñuba mijatu tsandimi: Tsa jutyuren tsaañungue keewaamu chachilla, ¿ñulla inu kuipa katanu tenguee? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Deechu' mitya kuwa kuwakenu lushi inu keewaakai, timi. Tsenñu ma paki lushi dekeewaañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús tsandimi: ¿Entsa kajuu muute juushu juntsa, naa enu pillaashu juntsa mumu bain, muchin? ti' pake'meemi yalanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tsenñu yala: Entsaya romanola' kayu aa uñichive, tila. Tsa detiñu Jesús tsandimi: Tsaashu juntsaa, romanola' kayu aa uñichiya yanu kuwadei, tsenmin Dioschiya Diosnu kuwadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsandi pakañu demeetu ti pan tsai shuwa' yanu shuike' miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tsenñu juntsa malunun mantsa saduceo chachilla, matyu pemulaya mangujtan jutyu deeve timu de' mitya, Jesús' junga jitu entsandila: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mashturu, Moisésya entsangue mijakaamuwaave: Main supungatun, ya' shinbunu nakakarei'mujchin peyashu juntsaa, ya' naatalaa juntsa biyuda shinbunu manga', pemu milla' mitya na seenguikaanu juve, timuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tsenñu ma bijee lala' jundala unbeena naatala tenen mandishpai naatala ma juula. Tsejtu ajke' jumu supungaturen nakakarei'mujchi peyañu' mitya, junu ya' kelunu jumu, ya' bennaa juntsa shinbunu mangami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tsejturen ya bain tsaren imi, naa ya' kelunu jumu naatala bain tsaren imi, tsejtu kumuinchi juntsa mandishpai naatalala millai peyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsai' ma depeyadeiñu, umaa entsa shinbu bain bene peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tsa' mitya, pemula demangujnu uwanuya, matyu kumuinchin supu tire' chumuwa deeñu' mitya, ¿naaju naatalachee ura ya' shinbu junu jun, juntsa mandishpai naatala jumulachi? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tsenñu Jesús tsandimi: Ñullaya naa Diosa' Kiikanu bain, naa Dios tiba tsamantsaa kemuñu bain kerajdetu' mitya, tujlanchi ma judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pemula mangujnu malunuya demangujpa' supu manganu bain, unbee mangayainu bain dejutyuve, matyu kai'sha chumu anjeela naadejuñuba juntsaaya chunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tsenmin pemula mangujpanu dejuñu kuindanu laapu' panmalaya, ¿Diosren entsandiñu lengue' kerajdetuu ñulla? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","¿Iyaa Abrahamchi bain, naa Isaacchi bain, naa Jacobchi bain yala' Diosyu, timuñuba lentyuwa dejuu? Yaa pemula' Dios jutyuve, chumula' Diosve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesús tsandi mijakare' pañu chachilla demeenatu mika meenbashi' ti pan tsaa meranala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tsejtu saduceo chachillanu, Jesús tsandi' ma pa'piwaakive detiñu fariseola mijatu wa'dila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tsenñu yaatala main Moisés' wandya lei mashturu tujle' pakakare' kuipa punu tyatu, entsandi pake'meemi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Mashturu, ¿leinu naaju uudenya kayu balen? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tsandiñu Jesús tsandimi: Ñu' Bale Ruku Diosnu mika estyade, ñu' tenbukachi, ñu' aamachi, ñu' pensachi, kumuinchi ñu' pudengura estyade. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Entsa uudenya kayu baleve, tsenmin entsaa ajke' jumu uudenve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tsenmin entsa keraa, entsa uudennu mi'namu bain, entsaa juntsave: Maali naa-i estyamu ju'ba ñuba kalen chumu chachinu bain juntsai estyade, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tsa' mitya naa Moisés' wandya lei jumula bain, naa Diosa' mitya pamu rukula bain, entsa pai uuden jumulanu tene laapu' pamu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo chachilla kayu dewa'naren, Jesús yalanu pake'meetu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tsandimi: ¿Ñullaa Dioschi Mi'ke' Kayamunu naa detiyu? ¿Munaa sera' jatu-in? ti' pake'meemi. Tsenñu yala pakatu: Rei Davidnaa sera' jamu nave, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsenñu Jesús tsandimi: Tsaanuba, ¿nenñaa, Espíritu Santo tsandikaañu, David Dioschi Mi'ke' Kayamunu patu, Bale Ruku timuwaatun? Matyu David entsandimuwaave: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bale Ruku Dios in Bale Rukunu tsandive: In urandyasha chudide, kayu iya ñu' kundaalanu depuitu ñu' neepa teetanainsha detsurendyuya, timuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tsaaren Davidren Dioschi Mi'ke' Kayamunu Bale Ruku tiitimuwaanuba, ¿nejtaa yanu sera' jamu nanu jun? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tsandiñu mu bain naati' ne pakakenuba jui'la, tsejtu umaa juntsa malu ajkeshaya, manbake'meenu tyatyui tiyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús tsandi' dyatu, junu meenamu chachillanu bain, ya' disipululanu bain ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","tsandimi: Leichi mashturulaa, fariseo chachillaba Moisés' wandya lei naatiñuba wandi wanditinuu jumula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tsa' mitya yala naadetiñuba ñulla meengue', titi depañuba tsa tsanguidei, tsaaren yala tyee kemu deeñuba juntsaya kityudei, matyu yalaya palaachiya tsandi' bain, kenchiya tsangue kityu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Veelanuya tsamantsa adyu naa-i' tajin tsaa nandekiñuu kemularen, yalaya ta've'nu ne tyamishuchin juuñuba ta'katyu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yala ti kike' bain chachilla dekeesa tya' ne kiikemu deeve. Tsenmin ballalla kaa pute keraa bain kayu aawa' kike' Diosa' Palaa pilla kiika petse pu', yala' llashkapanu bain, naa tyaapatala bain teepu teepukemu deeve. Tsenmin Diosnu ura' keenguemu chachi deeyu tya' keewaatu, jai mututala eenguenu jai petsela bain shushui teleke' aabare' eengaakaakemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fandangu ke' panda finu uwanu bain kayu ura chunjuuya mi'kemu deeve, naa cha' waku wakudinu yatala bain kayu balela' chuchudinutalaa chunu ajchundyamu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tsenmin cha' den neneindala bain yalanu aawa kure', ura' jusa tiidetisa tyamu deeve, tsenmin yalanu: Mashturu, tiidetisa tyamu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tsaaren ñullaya ne ñullanu, “Mashturu”, detisa tyatyudei; ñullaya naajulaba naatala tene judeeve, tsenmin ma mashturun miya deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tsenmin ñulla naaju chachillanu bain: Apa, ti' patyudei; ñullaya kai'sha chumu ma Apan miya deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tsenmin ne ñullanu, “Mijakare' wainmu ruku” detisa tyatyudei, matyu Dioschi Mi'ke' Kayamuren ñuichi main Mijakare' wainmu ruku juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tsaju' mun ñuitala kayu aawayu tya'ba vejanlachi taawasha kemu chachi junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Matyu mun kayu mu' mityaba yaa aawa juchi tya'ba balejtu kura' uukavinu tsuve; tsenmala mun tiba daj keewaatyu chachi ju'ba aawa kuranu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Ñulla leichi mashturula bain, fariseo chachilla bain, tsa jutyuren tsaañungue keewaamu chachilla, mika taaju i' puinu dejuve! Ñullaya veelanu Diosnu yala' rei juu tanan jutyu daatadimu deeve. Tsenmin ñullan Diosnu rei juu tananu dejutyu', naa veela yala' rei juu tananu kemulanu bain tsanguikaatyu chachi deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ñulla leichi mashturula bain, fariseo chachilla bain, tsa jutyuren tsaañungue keewaamu chachilla, ñulla mika taaju i' puinu dejuve! Ñulla naaju' bain tsaa chachi tirenu, main mityakenuuren, nuka bain deji' katamiya, juntsanu ñullanuba pai bijee pullake ñi jelekenu kensha viinuu chachi tiremu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ñulla kapuka puñu jutyuuren veelanu miya' neneimu chachilla, mika taaju i' puinu dejuve! Ñullaya tsandimu deeve: Diosa' pupunanu ya' mityaa mun Diosa' mumunu paka' uwain tsanguenbera kenu tsuyu tituren tsangui'ñu bain, tiba jutyuve timu deeve. Tsaaren Diosa' pupunanu yanu pumu uru' mityaa, Diosa' mumunu paka' uwain tsanguenu timiya, tsanguenbera kenuu juve timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ñulla pensa tajtu chachilla! ¡Kapuka putyu chachilla! ¿Tyee kayu balenu jun? ¿Uru jumuu? tsa jutyu'ba, ¿juntsa urunu Dioschin juu tirekaamu ya' pupunanu yaa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tsenmin ñulla entsa bain tsandimu deeve: Mun ufeenda tsure' ju'kenunu' mityaa Diosa' mumunu paka' uwain tsanguenbera kenu tsuyu tituren, tsangui'ñu bain ne juuve timu deeve; tsaaren ufeenda tsure' ju'kenunu tsuramu ufeenda' mityaa Diosa' mumunu paka' uwain tsanguenbera kenu timiya, uwain tsanguenbera kenu juve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ñulla kapuka putyu chachilla! ¿Tyee kayu balenu jun? ¿Ufeenda jumuu? Tsa jutyu'ba, ¿Juntsa ufeendanu Dioschin juu tirekaamu ju'kentsumi jumuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tsaju' mun ufeenda tsure' ju'kenunu' mityaa Diosa' mumunu paka' uwain tsanguenbera kenu tsuyu ti' bain, ufeenda tsure' ju'kenunun patindyuve, juntsa ufeenda tsure' ju'kenunu ti tsuñuba kumuinchi delaapu' pantsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tsenmin mun Diosa' pupunanu ya jumu' mityaa paka' uwain tsanguenbera kenu tsuyu ti' bain, Diosa' pupunanu yanun laapu' patindyuve, maa junu chumuñuba juntsanu bain laapu' pantsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tsenmin mun selu' mitya Diosa' mumunu paka' uwain tsanguenbera kenu tsuyu ti' bain, Dios chudi' uudenguenu ya' chunbulla' mitya bain tsandiñuu ju', naa juntsa chunbullanu chumu' mitya bain tsarendiñuu juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ñulla Moisés' wandya lei mashturula bain, fariseo chachilla bain, tsa jutyuren tsaañungue keewaamu chachilla, ñulla mika taaju i' puinu dejuve! Aindyu mentanu bain, anisnu bain, naa kuminunu bain paitya pela vele' Diosnu manbaate kuwa kuwakemu deeve, tsejturen kayu bale lei uuden jumulanaa keeminchaa juju deeve, entsa judeeshu juntsalanu: Dios naakesa tyañuba tsanguenu jumunu bain, munu bain tenbityanu jumunu bain, tsenmin Diosnu uwain tsaave tya' keenguenutala bain. Tsa' mitya, ura pañuya entsaaya kiikenuu dejuve, naa ñulla' kiikendetsushu juntsala bain tsaren kidyai'mujchi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ñulla kapuka putyuren veelanu miya' nemula! ¡Dioschi urajtu kuran jutyu tyatu, te'laanu shi'shullachi ke' kaa atyutyu shiyayanuya pinu te'laaturen, jelekenuu kameyu juuñuulanuya te'laatyumujchi tsaa puite puitekemu deeve! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ñulla leichi mashturula bain, fariseo chachilla bain, tsa jutyuren tsaañungue keewaamu chachilla, ñulla mika taaju i' puinu dejuve! Naa shullanu bain, palatunu bain avindalan manbitsalekemu chachi deeve; tsaju' juushaya manbitsalajtu tiba detaangue' tyuwake pu' tanañu denave, tsenmin kayu tiba mutya' demi'ke' ka' tyuken tsa tsa dekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Kapuka putyu fariseo chachilla! shulla juushaa ajke' manbitsaadei, tsenmalaa avindala bain manbitsala katawanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ñulla leichi mashturula bain, fariseo chachilla bain, tsa jutyuren tsaañungue keewaamu chachilla, ñulla mika taaju i' puinu dejuve! Ujkun mennainsha keraa avindalaya fibabanchi juu narai katawamu chachi deeve, tsaaren tainshaya Dioschi urajtu kurekaamu ujkun taku tene juu tiba depetee tene juuñu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tsaañuu deju' mityaa, ñulla chachillachiya Dios naakesa tyañuba tsanguen chumu juuñuu katawaturen, tainshaya tsa jutyuren tsaañungue keewaamu deju', tituba firu' pensa tene tyuwaa chachi deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ñulla leichi mashturula bain, fariseo chachilla bain, tsa jutyuren tsaañungue keewaamu chachilla, ñulla mika taaju i' puinu dejuve! Ñullaya Diosa' mitya pamu rukula' ujkun mennanutala ura' mangue' kasa mangui manguikemu deeve, tsenmin Dios naakesa tyañuba tsanguen chumulanu mandenganu titu, muute deke' chujtyatala bain nara mangue' chujti chujtikemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tsenmin entsa entsandimu deeve: Lala' tinbu rukula' tinbunun laa bain chumaaba jutuya, tsangue' yala Diosa' mitya pamu rukulanu tutendetsu bain tuteve'tyuchu deeyu, tiitimu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Entsandi' mityaa, ñui tenen wandindetsuve naa Diosa' mitya pamu rukulanu tute tutekemu chachillanu sera' jamu deju', ñui bain juntsaaren kendetsu' bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tsa deju', ¡ñulla juntsaaren deju' mitya, ñulla' aa-apala tyee ke' depeepuñuba, tsangue' jijiintsudei, Dios nutala jingue tsanguikarengamaya! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Piñi chachilla! ¡Piñi tsaa chachillanu sera' jamula! ¿Tyeenguitaa ñi jelekenu kensha vi'chu deeyu tenguen? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Entsanu ura' meedidei: iya ñulla' junga naa Diosa' mitya pamu rukulanu bain, naa tsamantsa aseetaju chachillanu bain, naa leichi mashturulanu bain eenu tsuyu. Tsenñuren ñulla mantsalanuya tute'kera, kuusanu tu'pu'kera, vejanlanuya cha' waku wakudinu yatala debande'kera, naa pebulumeemee bain firu' kenu deketakes ne'ba tsa tsainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ñulla tsanguimee, ti kuipaba jutyu chachi peya' asa shajaa-eemula' mitya ñulla tene kuipa kakenu detsuve, matyu Dios naakesa tyañuba tsanguemu ruku Abelnu tuten mitya kuipa kamin, Diosa' pupunanu ya jumuba, ufeenda tsure' ju'kenunuba pensanguenmala, juntsa kejtaa tenatala ñulla judíola detu'ñu pemu Berequías' na Zacarías' mitya kuipa kakijanu detsuve. Tsenmalaa naa ñulla kuipa judeeñuba entsai keengaya junu tsuve, naa Diosa' mitya pamu rukulanu bain, tsamantsa aseetaju rukulanu bain, lei mashturulanu bain eeñu ñulla detutenmala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Uwaindiyu, ñulla challa chumu chachillanu tene kumuinchi juntsa kuipa' mitya taaju dejainu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ñulla, Jerusalénsha chumu chachilla, naa Diosa' mitya pamu rukulanu bain tu'mu chachilla, naa Dioschi eramu chachillanu bain shupuka' kiikemu chachilla! Iya ñullanu pure' bijee walla' ama naakemun ya' kaillanu ja'chi pandansha tene pukemushu, i bain tsanguenu keñun ñulla tsa de-ikutityuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ura' meedidei, tsa' mitya Dios ñulla' yanu shuike' baka' miinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Matyu ñullanu tsandinu tsuyu, entsa ajkeshaa inu mangatan dejutyuve, ñullan bene: Bale Ruku' mitya jamuya Dioschi ura' imuve, ti'mujchiya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús aa eleshasha puturen malu' yumaa miintsu, ya' disipulula ya' keesha jitu, juntsa aa elesha yatala naaju dejuñuba Jesúsnu keeware' keenbashinguekaanu kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tsenñu Jesús tsandimi: ¿Kumuinchi entsa naajuñuba katandetsutyuika? Uwaindiyu entsa aa elesha naa tsaju' bain, desenaaji-i', naa ma shupukaba dijkii tsutyui senaa-eranu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tsejtu bene Ulibu chi chunu kuyisha dejitu, Jesús chudiñu, ya' disipululan juu ya' keesha kalen jitu entsandi pake'meela: Lalanu wainka, ¿naamaa juntsaa de-i' pullantsunu jun? Ñu rei juuñuu maja' entsa challa chudenaashu juntsa tinbu de-inu juñu, ¿tyee intsuñaa tsaa aseetanguenu dejuwa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tsenñu Jesús tsandimi: Ñulla muchiba tujle' keenguikaran jutyu jaiba pashkatyudei, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","matyu iya jutyuren Dioschi Mi'ke' Kayamuyu timula pureinu detsuve, tsai' anbukuinda keturen pure' chachillanu keranguikaanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ñulla endala juu bain, naa baasha juu bain suutadutala vinguendetsuve tiñu mere mereke' bain wapantyudei, matyu juntsaa-i' puintsunu ju' mityaa tsainu tsuve, tsaaren ne tsaiñu bain, kayu de-inu maluya jun jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Matyu manbaate chachilla, kamanbaate chachillaba devingue'kera; manbaate tu' chulla, kamanbaate tu' chullaba vingue'kerakenu detsuve. Tsenmin nutsa tenasha bain panda yamuj tiya'kerakena' bain, naa kala ke'kerake' bain tsa tsanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tsaaren kumuinchi tsaa de-i' pullandu bain, ti ju'ba umaa taaju peepukendun tsainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Juntsa tinbutalaa in mityaren ñullanu bale rukula' tyaapasha kuwa', firu' dekikare' detu'kare'kerake, naa mu bain ñullanu detyutya'kerakenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tsenmala pure' chachilla keenguityu demandiya', veta' veta' wandi' firu' kenu dekakare', naa veta' veta' detyutyai bain inu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anbutitun Diosa' mitya pamuyu tita neneimula bain pure' faleke' anbuti' pure' chachillanu keranguikaanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tsenmin tiba firu' kenchi tene juu detiyainmala, pure' chachilla estya estyainu pensa jutyu tiyainu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Naa tsaintsu bain, mun de-inbera tujlei'mujchi naake ura' kerangue' jintsu'ba tsaa jintsushu juntsaa livee inu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tsenmala Diosnu rei juu tananu mika ura kuinda nutsa tushaba dewandidetiñu, naaju chachilla bain demija deinmalaya, umaa de-inu malu janu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tsa' mitya, tiba chutyu yajchin jungue demushkemu, uu tyutyanuu jumu, Dioschin juu tenanu ja'pu katamiya, matyu Diosa' mitya pamu ruku Daniel tsandi wainmuwaañu juntsainmalaya (mun naa-uwanu cha' ajuusha entsa lengue' bain pensangue' keekide), ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mun Judea tusha puna' bain kuyisha nepidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tsenmala mun ya kai'sha leka lekakinsha puna' bain tusha manbajtya' nepinu, tyeeba manganu tya' ya juusha mavityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tsenmala mun jeenbaasha puna' bain ne jalleeba manganu tya', yasha miinu pensanguityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Juntsa malutala naaju shinbula napuu dechu' bain, naa chu'fimu kailla miyaa dechu' bain, mika taaju kenu detsuve! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tsa' mitya ñulla tsai' denepinu tinbu ne shu tinbu juuchi, ne saaduma lekanu malu juuchi tsaityusa ti', Diosba kuinda ke' papatidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Matyu juntsa malutala tsamantsangue taaju kenu detsuve, tsenñu entsa tu dekenu tinbutala bain, naa ne chai tinbutala bain, naa kayu bene bain juntsai taaju in jutyuuya i' puinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tsai' tsamantsa taaju ke' puinu tinbu jumunu Diosren dape' kakaatyuñuya, muba livee in dejutyuve, tsaanuren Dios yachi mi'ke' kayamu chachilla' mityaren juntsa tsai' tsamantsa taaju i' puinu tinbu dape' kakaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tsa' mitya juntsa malutala mulaa ñullanu: ¡Keekidei, Dioschi Mi'ke' Kayamu enu entsanave! tsandityu'ba, ¡Keekidei, junu juntsanave! detiñuba keenguityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Matyu Dioschi Mi'ke' Kaya jutyuren juntsayu tis nemula bain, naa Diosa' mitya pamu jutyularen juntsayu tis nemula bain janu detsuve. Tsejtu Diosyaa tsanguekaantsuve tyainuu bain deke' keeware', naa tsamantsa keenbashinguekaanuu jumu bain deke' keeware' chachillanu anbuda keranguikaanu detsuve, tsenmin yalan tsanguenuu jutuya naa Dioschi mi'ke' kaya chachillanu bain anbuti' keranguikaanu kenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kayu tsa indyuren ñullanu yumaa dewainyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tsa' mitya ñullanu: ¡Keedidei! ¡Dioschi Mi'ke' Kayamu junga tiba den chutyuinsha puve! detiñuba, jaiba jityudei. Tsenmin naa: ¡Keedidei! ¡Junga pantsunave! detiñu bain, jaiba keenguityudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Matyu kuidya pi'kitu naakemunga pajta lainsha pi'kemin, pajta vinsha jingue pi'kemuusu, Chachi Tiya' Nakayamu maanu uwanuya juntsaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Matyu nuka pete tsuñuba, jungaa petyutyu wa'dimu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tsangue' tsamantsa taaju deke' puinu malutalaren pajta yapijuru' kanu tsuve, naa kepe pajta bain dandajtui tiyanu tsuve, naa makara juula bain kai'sha tyaike' pajanu detsuve, tsenmala kumuinchi selu bain tsaa depi'shikenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tsenmala Chachi Tiya' Nakayamu selusha maantsuñu tyeeba ke' keewara katawanmalaya, entsa tusha kumuinchi vee vee sera' jimu paandela tsamantsa jeetyanchin waanu detsuve. Tsejtu Chachi Tiya' Nakayamu ñivish jandala ya' pudeechi tsamantsa pi'juruu majaintsu kataanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsenmala Chachi Tiya' Nakayamuya juipunu tyujtyu daran juipukaatu ya' anjeelanu ere', yachi mi'ke' kaya chachillanuya tu kuraa dete'kakare' wa'kaanu eenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Matyu igu chinu keetadi' mijan tsaidei: Naa-uwanu ma igu chi ya' ali denakulu'kake' ya' jaki demashu'jele kentsuñu bain, yumaa shu tinbu jutyu mandinu kaleintsuñuba mijamu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Entsa bain tsaren juñu' mitya, kumuinchi entsaa de-i' pullantsu katashu juntsaa mijanu dejuve juntsainu kalenatu yumaa juukapanu punañu bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Uwaindiyu entsa tinbunu chumu chachilla kayu peyaindetyuren kumuinchi entsaa de-i' puinu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Naa selu bain, naa tu bain millai' de-i' puiñuba, iya naatiñu bain juntsalaya uwain tsainbera inu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tsaaren ne ti malunaa tsainuuñu bain, ne ti uranaa tsainuuñu bain juntsaya muba mijdetuve, naa selusha chumu anjeela bain, naa ya' Na bain mijtuve, ya' Aparen miive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Matyu Noé' chunu tinbunu naa-imuwaañuba, Chachi Tiya' Nakayamu' maanu tinbunu bain tsaren junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Juntsa tinbutala kayu shuwa jelekenui' pi debukindyuya, chachilla panda fi'kera, kujchi'kera, supunga'kera, tsenmin matsu'kera kentsumuwa deeve, kayu Noé baakusha vindyunu malunuya, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","tsejtu naa mijaba indetyuren, shuwa jelekenui' pi buke' tsaa deka' jiimuwaave. Tsa' mitya Chachi Tiya' Nakayamu' maanu malunu bain tsaren junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Juntsa malunu pai ruku jeendaa nentsu'ba, mainren kaya' jiinmala, kamainya shuwanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tsenmala pai shinbu tyeeba iliken depu' bain, mainya kaya' jiñuba, kamainya shuwanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tsa' mitya uwain naamaa ñulla' Bale Ruku maanuu juñuba mijdetu' mitya pashkayajtu keenadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tsaaren entsaya mijadei: ya miya ruku, kepe ti uratalaa taamu januuñuba mituya juntsa uratala kastyu' washina' keenatu, taamunu eepukaatyu' taanguikaan jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tsa' mitya ñui bain jinun jutyuna' keenadei, matyu Chachi Tiya' Nakayamuya ñulla maanu juve pensaba dejutyunu uwanu majainu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kidanda jutyu, tyee keñaa urañu bain tsa tsanguemunu, yanu uudenguemu ruku ya' yanu washkare' yachi taawasha kemu chachillanu panda finu ura tiyanmalaya, panda kuwa kuwakenu shuike' jiñu jun tsaadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tsenmala yanu uudenguemu ruku naati' jiñuba yachi taawasha kemu chachi tsanguentsu mangatawamuya mika sunden junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Uwaindiyu juntsa chachinu, yanu uudenguemu ruku ti taju' bain yanu tene dewashkenu tirenu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tsaaren juntsa yachi taawasha kemu chachi firu' ju', ya' pensasha: “Inu uudenguemu ruku te' majan jutyuve”, tya', ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yaba bulu taawasha kive'mu chachillanu defiru' kedundai', vin rukulaba buudi', panda fi', naa ishkalaba kujchiken ne chunatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","naa keenabanatyunu malunu, tsenmin majan jutyuve tyanu uranu yanu uudenguemu ruku maamiya ");
INSERT INTO cbiNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tsa jutyuren tsaañungue keewaamu chachilla' puinsha ereke', tsamantsangue taaju kikaanu tsuve. Tsenmala jungaa ware' naa tejkuba depakaa kentsunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Diosnu rei juu tananu juñu pensanguiñuya, paitya pannala ulibu mulichi chakaraa ñillu deka' supunganuu jumu ruku jantsu mikajiiñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tsejtu man pannalaya ti kenduba tejan kerei'mujchi kemu panna deenmala, kama man pannalaya ti ke'ba tejan keetu tene kemu jula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tsejtu ti kenduba tejangueetyu pannalaya yala' ñillu dekaturen, de-iñu manbunu muliya tajtu jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tsa deiñuren, ti kenduba tejangueetu tene kemu pannalaya yala' ñillu kamin, de-iñu manbunu muli bain ma lemeta ka' jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsejtu supunganuu jumu ruku te' jaindyuñu' mitya, kasandyatu tsaa dekasuila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tsa denaren kejtaa kepe iinutala: ¡Supunganuu jumu ruku yumaa jantsuve; fale' yanu dekajii! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tsa detiñu juntsa pannala demangujpa' yala' ñillu ka' jinun jutyungaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tsejtu ti kenduba tejangueetyu pannalaya, ti kenduba tejangueetu tene kemu pannalanu tsandila: Lala' ñillu ma demanbeyaintsuve; ñulla' taañu muli jayu kuwakai, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tsa detiñun ti kenduba tejangueetu tene kemu pannala entsandi pakala: Naake' kuwan tsaa keeve; kuwashu juntsaa, ñuichi bain tse'ken jutyu, naa laachi bain tse'ken jutyuve. Tsa' mitya nuka ai'mu deeñuba jungaa ati'kaidei, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tsa detiñu juntsa pannala tendasha muli ati'kanu dejinmalan, supunganuu jumu ruku jañu, ti kenduba tejangueetu tene kemu pannalaya yaba bulu fandangusha vila. Tsai' videinmalaren ya juukapa llukikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsenñu muli ati'kanu jimu pannala bene demaatu: Rukui, tsantsaya ya juukapa majuukide, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tsa tsa detiñu entsandikami: Uwaindiyu iya ñullanu kerajtuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tsandi' dyatu Jesús tsandimi: Tsa' mitya ti maluchee, tsenmin ti urachee Dioschi Mi'ke' Kayamu maanuuñu bain mijdetu' mitya, pashkatyu' keenadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Matyu Dios ya' chachillachi rei tiya' washke' mandanguenu juñu pensanguiñuya, ma ruku vee mujtu lu' jindu yachi taawasha ken chumu chachillanu demika', naa lushi bain washkidei ti' kuwakiñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tsejtu mainnuya 5.000 paki lushi kuwa', kamainnuya 2.000 paki lushi kuwa', tsenmin kayu veranuya 1.000 paki lushi kuwakemi, matyu juntsa lushinchi main main naa naake talanu deeñuba tsangue dekera' kuwatu, tsejtu baasha jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tsenñu 5.000 paki lushi kamu rukuya, nei'ba kamin juntsachi jeke taawasha ke' kama 5.000 malaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tsenmala 2.000 paki lushi kamu ruku bain tsarenguetu, ya bain kama 2.000 paki lushi malaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tsaaren 1.000 paki lushi kakemu rukuya yanu uudenguemu ruku' lushi kamin tsaa tujuru ke' ne menekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tsenñu bene pure' tinbu puiñu yalanu uudenguemu ruku maatu, lushinchi tyee dekiñuba mijanu tyatu, yaiba bulu demanguere' keemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsenñu 5.000 paki lushi kamu ajke' jitu, kama 5.000 paki lushi bain tai ji', yanu uudenguemunu tsandimi: Rukui, ñu inu 5.000 paki lushi kuwañu, iya kama 5.000 paki lushi malaayu. Enu mangade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tsenñu yanu uudenguen chumu ruku tsandimi: Yuj ura' kiñuve, kidanda kityu ruku. Naa jayu juuñu bain kidanda kityu' ura' keñu' mitya, kayu pure' juunaa mawashkaanu tsuyu. Tsa' mitya iya nenñaa sundyañu bain iba bulu sundyade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsenmala naa 2.000 paki lushi kakemu ruku bain bene jitu tsandimi: Rukui, ñu inu 2.000 paki lushi kuwañu, iya kama 2.000 paki lushi malaayu. Enu mangade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsenñu yanu uudenguen chumu ruku tsandimi: Yuj ura' kiñuve, kidanda kityu ruku. Naa jayun juuñu bain kidanda kityu' ura' keñu' mitya, kayu pure' juunaa mawashkaanu tsuyu. Tsa' mitya iya nenñaa sundyañu bain iba bulu sundyade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tsaaren 1.000 paki lushi kakemu ruku jamiya, yanu uudenguemu rukunu entsandimi: Rukui, naa ñuya tsamantsa feete' uudenguen chumu ruku juñuba iya entsa kerayu, ñuya tiba wajtyumujchiba puka kamu juve, tsenmin tiba waakityundala bain te'kamu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsaañu' mitya, inu jeetenñu, ñu' lushi ka' jitu, tusha ne menakaayu. Enu entsanave ñu' lushi; mangade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tsenñu yanu uudenguemu ruku tsandimi: ¡Ñu firu' chachi, lamu! Tsejtu iya, naa wajtyundala bain puka de-isa tyatyaimu ju', naa waakityundala bain te'kanu tyatyaimu rukuñuba uwain mishu juntsaa, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","lushi uukaanu yasha in lushi ta'tuya, i entsai' maanmala seeware'ba manguchuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsejtu jundaa pumu chachillanu tsandimi: 1.000 paki lushi demachi'ke', 10.000 paki lushi tanashu juntsanaa mangudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsejtu tsandimi: Mu bain tsaanu aseeta julanuya Dios kayu aseetanguekarenmala mika ura' aseetanguenu detsuve; tsaaren aseeta jutyulanuya naa jayu aseeta judeeñu bain, aseetanguen jutyungue shuikenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tsa' mitya jui'ñuba ne uraa chachinuya, avindala tsamantsa yapijurunainsha ka' kelaadei. Jungaa deware' naa tejkuba depakaa kentsunu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Chachi Tiya' Nakayamu ya' keetala tsamantsa pi'kelaa yataa, ya' anjeelaba maatu, tsamantsaa rei juuñuu ya' chunjuunu chunu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tsenmala nukaba chumu chachilla kumuinchi ya' ajuusha dewa'kara deinmala, main main devela' kalaanu tsuve, matyu animaa washkemu ruku tsaaya uvejalanu chibulaba devela' kalaren tsanguenu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tsejtu uveja juuñuulanuya ya' urandyasha ere', tsenmin chibu juuñuulanuya ya' jalandyasha eeketu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Rei ya' urandyasha pumulanuya entsandinu tsuve: ¡In Apachi ura' imu chachillaya, jadei! Tsejtu Dios rei ju' chuinsha umaa entsa tu dekenu tinbunun ñullanu kuwanu dejuu tanamuwaañu ñuichi tirenu juntsa kadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Matyu ñullaya i panda iintsuñu bain panda kumuwa deeve; pi iintsuñu bain pi kumuwa deeve; kerajtunu chachi juu jañu bain inu mikamuwa deeve; ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","naa jali tajtuu neintsuñu bain inu jali kumuwa deeve; diluu tsunañu bain in junga ja' keemuwa deeve; naa peesu punañu bain inu ja' keemuwa deeve, tinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tsandinmala, Dios naakesa tyañuba tsanguen chumu chachilla entsandi pake'meenu detsuve: Bale Ruku, ¿naamaa ñu panda ii nentsuñu, lala panda kumuwa deewa? ¿Naamaa pi ii nentsuñu ñunu pi kumuwa deewa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Naamaa kerajtunu chachi juu jañuren ñunu mikamuwa deewa? ¿Naamaa jali tajtuu nentsuñu ñunu jali kumuwa deewa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Naamaa diluu tsuñu, tsa jutyu'ba, peesu puñu lala ñunu ja' keemuwa deewa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","detinmala, Rei entsandinu tsuve: In naatala kayu baleñu' jutyuu jumunu tyee ura' juu deke' bain, uwaindiyu ñulla juntsanguitu inu tsanguiñuuve, tinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tsanditu bene Rei ya' jalandyasha uinamulanuya entsandinu tsuve: ¡Ñulla kavitu i' kuipa viinuu chachillaya, inu baka' mijiidei! Dyabulu ya' anjeelaba vinutsumi ke' chujtya naa-uwanuba manbetyu ñinbaasha vijidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Matyu ñullaya i panda iintsuba panda kutyuwa deeve; pi iintsuba pi kutyuwa deeve; ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kerajtunu chachi juu nentsuba inu mikalaatyuwa deeve; jali tajtuu nentsuba inu jali kutyuwa deeve; diluu tsuna bain, naa peesu puna bain inu ja' keetyuwa deeve, tinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tsenmala yala entsandi pake'meenu detsuve: Bale Ruku, ¿naamaa ñu panda ii nentsu, pi ii nentsu, ne kerajtunu chachi juu nentsu, ne jali tajtuu nentsu, ne diluu tsuna, ne peesu puna bain, lala ñunu tiba ke' kutyuwa deewa? tinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tsa detinmala, Rei entsandinu tsuve: Ñulla naa-uwanaa main tiba baleñu' jutyuu chachinu tyeeba uraa kityu ju' bain ura uwaindiyu ñulla juntsaatu inaa tsangui'ñuuve, tinu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tsa' mitya entsaa chachillaya naa-uwanuba taaju ken chuinsha jinu detsuve, tsenmala Dios naakesa tyañuba tsanguen chumu chachillaya naa-uwanuba yaba ura' chunu ya' junga jinu detsuve, tinu tsuve, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús ya' disipululanu tsandi depa' dyatu entsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Entsa pai malusha Dapulla' livee kiñu fandangu juñuba ñulla mideeve. Juntsa malunaa Chachi Tiya' Nakayamu balela' tyaapasha kuwa' kuusanu tu'vi' peyanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Juntsa malutala naa chachilla' mitya Diosnu kalen jimula' bale rukula bain, tsenmin judío bale rukula bain wa'diila, chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku Caifás' yasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tsejtu naaketaa bibu' deke' Jesúsnu kuipa faawaatu ka' tu'nuu deju'ba juntsaatala kuinda kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tsejturen entsa entsandila: Tsaaren entsa fandangu malutalaya tsanguityudaa, chachilla demija' tituba firu ki'nudetsu, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betaniasha pumi, manbityu bishpee chuu tiitinu ruku Simón' yasha. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tsenñu ma shinbu alabastru lemetanu tsamantsa bale pindyupi tyuwaa taji', Jesús panda finsha chunañu, juntsa pindyupi ya' mishpukanu yuutsungaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tsanguiñu keenatu ya' disipulula ajaa tse'tuwaatu entsandila: ¿Nenñungue ne tsangue' pindyupi dekepukemi? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Matyu ati'banguituya, tsamantsa balenchi ke', juntsa lushi purelanu kuwa'banguinuuba tsanguemi, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tsenñu Jesús mijatu entsandimi: ¿Ti' mityaa bulla pandu detiyu entsa shinbunu? Inu challa entsanguitu mika ura' kive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Matyu purelanuya naa-uwanuba ñulla' kejtsapalaren tananu detsuve, tsaaren inuya ñulla' kejtsapala naa-uwanuba tsana tanan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Entsa shinbu tsangue' in bulunu pindyupi yuutsuutu, iya menanuu juñu, mennun jutyungue pindyupi mungue' tsuukiñunguive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Uwaindiyu nuka tusha Diosa' mika ura kuinda wandi' mijakaadekiñu bain, entsa shinbu tyee kiñuba juntsa kuinda bain tsaren dekiñu mere' yanu mandenga mandengakenu detsuve, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","12 disipulu jumulanu, main Judas Iscariote detiñu, chachilla' mitya Diosnu kalen jimula' bale rukulanu keejitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tsandimi: ¿Iya ñullanu Jesúsnu kakaanmala, tyee inu kunu dejuyu? timi. Tsandiñu yala 30 paki lushi kuwanu shuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsa dekinmalan juntsa ajkeshaya Judas naaketaa Jesúsnu kakaanu ju'ba, tsaa mi'kes nenchi tene iimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fandangu ajke' malunchi pujkikarajtu pan fifikenu malunu, ura patiñuya, llupu kaa uveja tute tutekenu Dapulla' livee kiñu fandanguchi, Jesúsnu ya' disipulula kalen jitu tsandila: ¿Dapulla' livee kiñu fandanguchi finu panda, ñuchi nukaa kenu dejuwa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tsenñu Jesús pakatu tsandimi: Pebulusha defaajitu, iya challa ñullanu patinu juuwashu juntsa ruku' yasha jitu tsandidei: Mashturu tsandive: Yumaa inchi ura kalenave; ñu' yashaa ja', in disipululaba Dapulla' livee kiñu fandangu panda finu tsuyu, tive, tidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tsenñu Jesús naatiñuba tsanguitu, ya' disipulula panda kila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tsejtu dekependu' kañu Jesús ya' 12 disipululaba panda finsha chudi' ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","findu tsandimi: Uwaindiyu ñulla main inu firu' kekaanu wandi' peesu kakaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tsandiñu, ya' disipulula mika dellakindyatu, Jesúsnu main main entsandi pake'meela: Bale Ruku, ¿iyaa tsanguenu juwa? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsenñu Jesús tsandimi: Firu' kekaanu wandi' inu kakaanu jumuya in finu pandasharen ta'pu' fimaa juntsave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chachi Tiya' Nakayamuya Diosa' Kiikanu naatiñuba uwain juntsai' puinu tsuve, ¡tsaaren Chachi Tiya' Nakayamunu firu' kekaanu wandi' kakaanuu jumu rukuya mika taaju i' puinu tsuve! Matyu tsanguinaaba jutuya, na kayatyuwaañaa kayu yachi uraaba junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsenñu tsangue' firu' kekaanu wandi' kakaanuu jumu Judas bain Jesúsnu pake'meetu: Mashturu, ¿iyaa tsanguenu juwa? timi. Tsenñu: Ñaa tsandive, ti' pakami Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsangue' panda findu, Jesús pan kake', juntsan mitya Diosnu yuj urave ti' dedale', ya' disipululanu kuwatu tsandimi: Ka' fidei, entsa pan in buluve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsejtu bene binu pumu basu bain ka', juntsan mitya Diosnu yuj urave titu, ya' disipululanu kumi entsanditu: Kumuinchi ñulla entsa kushdei, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","matyu entsaa Dios chachillaba veta' veta' tsanguedaa tiñu jumu in asave, matyu pure' chachillanu ujcha manbitsaanu see-eranu jumu asa. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Uwaindiyu entsa binu ne jungajte kujchi kujchiki'mujchi, in Apa rei ju' chuinsha kasa binu ñuiba mangujchikenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Salmo beesa deke' dyatu, Ulibu chi chunu kuyisha jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tsejtu Jesús tsandimi: Entsa kepe ñulla in mityaren tyu'lekiñungue' ura' keenguityui tiyanu detsuve, matyu Diosa' Kiikanuren entsandive: Uveja washkemu rukunu ta'kenu tsuyu, tsenmala uvejala tsaa na'baasa jiinu detsuve, ti' pillave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tsaaren iya peya' Dioschi mangujtatu, ñulla kayu mijindetyuren, iyaa Galileasha ajke' miji' punu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tsenñu Pedro tsandimi: Naamika kumuinchi vejanlaya, ñunu keenguindandaa pensa detiyañu bain, iyaa tsa-in jutyuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tsenñu Jesús tsandimi: Uwaindiyu entsa kepe kayu wallapa utindyun, ñu inu kerajtuyu ti', pen bijee tsandinu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tsandiñu Pedro entsandimi: ¡Naamika ñuba bulu peyainuu juñuba, iyaa ñunu kerajtuyu tin jui'yu! timi. Tsenñu naaju disipulula bain tsarendila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsejtu bene Jesús yaiba Getsemaní tinu tenabi dejitu, ya' disipululanu tsandimi: Enu chudidei, iyaa aangu Diosba kuinda kenu jintsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tsejtu Pedronu bain, Zebedeo' pai nalanu bain miya' jitu, mika llakintse'tuware' ti ken tsandyatu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tsandimi: In tenbukasha tsamantsa llakindenganchin peyainui llakindenve. Ñullaya enu shuwa', kastyumujchi iba buluren keenadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsanditu Jesús kayu ajkesha ji' teledi' ya' llashkapa tusha tyuikangue waike' ya' Apaba kuinda ketu tsandimi: In Apa, tsanguenuuba jutuya, entsa tsamantsa taaju i' pullainu juuwashu juntsanu tsaa iwaatyuka, livee kika, Apa; tsaaren iya naaju mutyañuba juntsaaya kityu', ñu naakenu tenñuba juntsaaya kide, Apa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsejtu bene ya' disipulula' puinsha miji' dekasu'tsudena katatu, Pedronu tsandimi: ¿Naa ma ura juuñuba kastyumujchi iba bulu keenanu jutyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kastyumujchi dekeena' Diosba kuinda kiikidei, tsenmalaa ujcha lainuu pensa jai'nutsu. Ñulla tiba ura' kiikenu pensaya judeeve, tsaaren juntsa pensa jaiba derajtuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kama bijee baka' miji' Diosba kuinda mantu entsandimi: In Apa, iya entsa tsamantsa taaju i' puinu juuwashu juntsanu, iya tsa-inbera inuu jushu juntsaya, ñuchi tyee kiñaa urañu bain tsanguika, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsejtu manen ya' disipulula' puinsha miitu, matyu kasandyanchin kapuka chainguenu jutyuu ma jude' mitya kasu'tsudena mangatami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsejtu tsa dena mashuike' miitu entsaba pen bijee Diosba kuinda kemi, tsejtu kaspele naati'ba juntsaren manbami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsai' ya' disipulula' junga miitu tsandimi: ¿Chaiba ñullaa kasu'tsu' lekandetsuu? Yumaa Chachi Tiya' Nakayamu ujcha lamu chachilla' tyaapasha kuwanu ura jave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mangujdei miidaa, inu firu' kekaanu wandi' kakaamu yumaa jantsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús tsandi' kayu pantsuren, Judas, ya' 12 disipululanu ya bain main jumu pure' chachilla miyaa faajimi, mantsalaya peeniya taa, tsenmala mantsalaya cha'li taa jila. Yalaya chachilla' mitya Diosnu kalen jimu bale rukula' era bain, judío bale rukula' era bain jimu chachillaa tsaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tsaaren Jesúsnu firu' kekaanu wandi' kakaamu ruku Judas, yaba bulu jimulanu entsanguenu tsuyu timuwaami: Iya munaa estiñu bain, juntsaa juntsanu juve; tsa' mitya juntsanaa peesu kadei, timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsandimu' mitya, Jesús' junga jei kalen jitu entsandimi: Mashturu, ¿naanayu? timi. Tsandimin Jesúsnu estikemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tsenñu Jesús tsandimi: Inchi ura' keranu chachi, ñu tyeenguenu ja'ba tsanguide, timi. Tsandinmalan veela pumula Jesúsnu kalen ji' peesu kakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tsa dekiñu junu Jesúsba bulu pumu main peeniya kalare', chachilla' mitya Diosnu kalen jimula' kayu aa bale rukuchi manda-i' taawasha kemu chachinu tsaa pungui daapukemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsenñu Jesús tsandimi: Ñu' peeniya manbukide, matyu mun peeniyachi vingue' bain peeniyachi peyamu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","In Apanu tsanguide ti' pa'ñuya ¿challaren 12 pullangue, tsamantsa anjee bulu tenen in mitya vinguikaanu eren jutyuve tenguen, ñunaa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Tsaaren tsangui'banguishu juntsaya, Diosa' Kiikanu tsaa i' puinuu juve ti' pillaashu juntsa, naa-itaa tsaa puimunga? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tsejtu Jesús juntsa manbaate nemu chachillanu tsandimi: ¿Nenñu deiyu ne iya taamu rukaaba juñu kanu jan tsa-i' peeniya juula, cha'li juula bain taa ma jaila? Iyaa malumere aa eleshasha chudi' chachillanu mijakaren pupuna bain, ñullaa inu peesu katyuwa deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tsaaren kumuinchi entsaa puimiya Diosa' mitya pamu rukula tsaa puinu tsuve ti' piikemuwa deeñu, tsaa puindu ive, timi. Tsenmalan Jesús' disipulula juntsa uranu yanu maali pungue shuike' denepiya' jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tsangue' Jesúsnu peesu kamula chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku Caifás' jungaa tajila, leichi mashturula bain, bale rukula bain dewa'nainbi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tsenñu Pedro baatala suree jitu, chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku' ya veeta juusha vi', aa elesha washkemu chachillaba bulu ne chunami, Jesúsnu tsangue' ka' detajitu, tyee dekiñuba mijachi tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tsenñu chachilla' mitya Diosnu kalen jimula' bale rukula bain, naa kumuinchi kavitu kenchi kayu aa bale rukula bain anbutituren tsaave ti' Jesúsnu kuipa faawaanu mi'kenchin juula tsangue' Jesúsnu tu'kaakenuu kuipa punu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tsejturen anbukuinda ketun uwain tsandive timu chachilla ma pure' wakukaatu bain, ti kuipaba katai'la. Tsaaren ma de-iinsha pallu faatu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","entsandila: Entsa ruku entsandiwa: Iya Diosa' pupunanu ya desenaa-eeturen, pen malu insha juntsangue mannu tsuyu, tiwa, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsenñu chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku kujpa' uiditu Jesúsnu tsandimi: ¿Tiba pakakenuu jutyuu? ¿Ti naaju deti entsandi' ñunu kuipa pu' pantsula? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tsandiñuren Jesús pakai'ñu, chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku tsandimi: ¡Uwain ñu Dioschi Mi'ke' Kayamu, Diosa' Na ju' bain, chumu Diosa' mumunu paka' uwain tsaañundiyu ti' lalanu wainka! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tsenñu Jesús tsandimi: Ñaa tsandive. Entsa bain ñullanu tsandinu tenve: Entsa ajkeshaya Chachi Tiya' Nakayamunu tsamantsa pude Diosa' urandyasha chuna katanu detsuve, tsenmin ñivish jandala majaintsu ñulla katanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsandinmalan chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku Diosnu firu' pave ti' keewaanu ya' jali kiyuuchitike' entsandimi: Diosnu kentsure' ma pative. ¿Tyeenguenaa kayu uwain ma tsandive tiitimu chachilla mi'kenu dejuwa? Ñullaren challa enu tsandi' Diosnu kentsure' pañuba demeenave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Naa detiyu ñullaa? timi. Tsenñu yala pakatu: Tsaave, tutainuu kuipa ma juuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsandilaren kajuutala inbi dekitsure', dekati', naa kajuutala pinballachi bain deke' ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","entsa entsandila: Ñu, Dioschi Mi'ke' Kayamuya, challa maa tsangue' ñunu keñuba wainka, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsanguindetsu, Pedroya ya kelunu avindaa baisha chudi' chunaren yasha taawasha kemu panna main yanu kalen jitu tsandimi: ¿Ñu bain Galileasha chumu Jesúsba bulu neneimutyuika? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsandiñu muba demeenaren, tsa jutyuve ti', Pedro entsandimi: Ñu ti pantsuñuba mijtuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsejtu bene ya juukapa keesha jiñu, yasha taawasha kemu kama panna katatu, junu pumu chachillanu tsandimi: Entsa ruku, Nazaretsha chumu Jesúsba nentsuwa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tsenñu manen Pedro tsa jutyuve ti', Diosa' mumunu paka' ura uwain tsa jutyuve titu tsandimi: Iyaa juntsa rukunu kerajtuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tsenñu wajtutalan jundala pumu chachilla bain Pedro' junga kalen dejitu tsandila: Naati' tsa jutyuve tinuba jutyuve, uwain ñu bain yaiba nemuve; ñu' palaanun ne mijaikeeve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsa detiñu Pedro Diosa' mumunu paka', tsa jutyuve ti' jungajte tsandi', matyu anbutishu juntsaa, yanu Dios firu' kisa ti' entsandimi: Iyaa juntsa rukunu kerajtuyu, timi. Tsandinmalan juntsa uranu wallapa main ui'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsenñu Pedro mandengami yanu Jesús entsandi pamuwaañu: Kayu wallapa utindyuren, inu kerajtuyu ti', pen bijee ñu tsandinu tsuve, timuwaañu. Tsejtu Pedro junu malu' miji' avindala lutu mika llakindya' waami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yumaa dechañu chachilla' mitya Diosnu kalen jimula' balela bain kumuinchi, naa judío bale rukula bain, naati depataa Jesúsnu tu'kaanu ju'ba tsai shuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsejtu Jesúsnu telaa romanola' uñi Pilato' junga taji' kuwala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesúsnu firu' kekaanu wandi' kakaamu Judas, tsangue' kakaañu ma tutekenu dejuñuba mijatu, tsanguityuuba jui'wañaa tya' pensa mantu, ya' kañu 30 paki lushi jumu chachilla' mitya Diosnu kalen jimula' balelanu bain, naa judío balelanu bain mandaji' kuimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tsejtu tsandimi: Ti kuipaba jutyu rukunun tsangue' kakare' ma tu'kaakentsu' mitya, pure' ujcha laiyu, timi. Tsandiñu yala tsandila: Tsaañu bain laachiya nejuuve. Juntsaa ñaa mijanu tsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tsenñu Judas juntsa lushi aa elesha ura juusha detya'kepuke' miitu, maali kutunu chuwa pu' eedi' peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chachilla' mitya Diosnu kalen jimula' bale rukula juntsa lushi mande'katu tsandila: Entsa lushi pemula' asa mayiiñuuve. Tsa' mitya naake' ufeenda lushi pupukinsha pun tsaa keeve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsandi' dyatu, Tu piyama kenu tena mumu puu tu jumaa ati'kanu shuwala juntsa lushinchi, tsejtaa vee mujtu chulla ja' nendu depeyanmala, mene menekenu tena tirenu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tsa' mityaa juntsa ati'kaya tu entsa piikenu tinbunun As tu mumuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Entsaiñaa Diosa' mitya pamu Jeremías naatimuwaañuba tsaa puimi; entsandimuwaami: Israel chachillaren juntsanu tsantsa balengureke' tsangue deshuikiñu jumu 30 paki lushi dekave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tsangue' juntsa lushinchi tu piyama kenu tu tena de-ati'kave, Bale Ruku inu juntsanguenu uudenguiñu tsanguetu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús uñi' ajuusha takami, tsenñu uñi entsandi pake'meemi: ¿Ñaa judíola' reiyu? timi. Tsenñu Jesús pakatu: Ñaa tsandintsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tsenmin naa chachilla' mitya Diosnu kalen jimula' bale rukula bain, naa judío bale rukula bain Jesúsnu kuipa pu' papatindetsun, yalanu jaiba pakatyu jujuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tsenñu, Pilato tsandimi: ¿Ñunu kuipa pu' tituba pandetsuba ñuya merendyuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tsenñun Jesús naa manbalaaba pakai'ñu, uñi mika keenbashi' dyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naa-uwanu bain romanola' uñiya Dapulla tinu fandangu kenu malunchi, naaju peesu pumunaa chachilla livee ke' me-e'laasa detiñuba, juntsanu livee ke' me-e'laalaakemumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Juntsa tinbunu naa muchiba dekeraa main daj ruku peesu pumi, ya' mumu Jesús Barrabás. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsejtu chachilla dewa'diñu, Pilato tsandimi: ¿Munaa mandyaike' me-eenu juwa? ¿Jesús Barrabásnuu? ¿Jesús, Dioschi Mi'ke' Kayamu tiitidetishu juntsanuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tsaaren Jesucristonu tsangue' ya' junga deta'tu, kishtyanchin ne tsa dekiñuba mija' mityaa tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tsejtu Pilato kavitu kensha tsandin churen, ya' shinbu entsandi kuinda eemi: Aantsa rukunu tibanguityude, ti kuipaba jutyuve, matyu ya' mityaren iya kepe tsamantsa firu' kipinchi tene i' chayayu, tita-eemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tsandiñuren chachilla' mitya Diosnu kalen jimula' bale rukula, judío bale rukulaba junu wa'namu chachillanu, matyu Barrabásnaa mandyaikikare', Jesúsnaa tu'kaanu pa'nu pensa ma dekikaakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsenñu manen uñi pake'meetu tsandimi: ¿Entsa pallu jumulanu naajunaa mandyaike' me-eesa pensa deeyu? timi. Tsenñu yala pakatu: Barrabásnaa mandyaike' me-eede, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsenñu Pilato tsandimi: Tsaaya, ¿Jesús, Dioschi Mi'ke' Kayamu tiidetishu juntsanuya, tyeenguenujtuuwa? timi. Tsenñu kumuinchi pakatu entsandila: ¡Kuusanu tu'vi' tutasa! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tsa detiñu Pilato tsandimi: Tsen, ¿tyee firu' ken entsa ruku? timi. Tsandiñuren chachilla ui'tun kayu utindi' entsa entsandila: ¡Kuusanu tu'vi' tutasa! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tsenñu Pilato ne tsandindu tiba inu' jui'ñu, tsenmin chachilla kayu tituba ke' ne jiindetsuñu' mitya, pi taakaatu, muba dekeenaren ya' tyaapa manbitsaandu tsandimi: Tsangue' entsa rukunu detu'ñu bain, iyaa ti kuipaba kan jutyuyu; ñullaa kuipanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsandiñu kumuinchi chachilla pakatu tsandila: Naa entsangue' tu'kare'ba, kuipa juñuya laa bain, naa lalanu sera' jamu kailla bain kuipanu detsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tsenñu Pilato yala naadetiñuba tsanguitu, Barrabásnu me-e'lare', Jesúsnuya aste kikare', kuusanu tu'pu' tu'nu uudenguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsenñu uñi' suutadula Jesúsnu katu romano uñi' yasha tajitu, kumuinchi suutadulanu Jesús' keesha demika' wakukaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tsejtu ya' pana jaliya debe'tu main yamuraraa jallee vikaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tsejtu pu chuwa tene desala' puke' ma mishmunderu ke' pu'kaala ya' mishunu. Tsenmin ya' urandyaapasha tsuta juuñuu ñañi cha'li main chungaapula. Tsejtu firu ke' uukapu' ya' ajuusha teledi' entsa entsandila: Ura' chude, judíola' rei, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tsandi' inbi dekitsure', yanu kuñu ñañi tsutachi mishutala vili vilikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsangue' firu ke', de-uukapu' dyatu, yanu vikaañu yamurara jali demanbeke', ya' jallee manbande', kuusanu tu'punu tajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tsejtu junu demalu' miindu Cirenesha chumu Simónnu dekatatu, Jesúsnu tu'punu kuusa deranchi nande' eekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tsejtu ma tena, Gólgota tishu juntsaa, Ujkun Mishu tena tinunu dejitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jesúsnu sangalaba yandaa binu dekuñu, kujchi' keetu, kujchindyai'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tsejtu suutadula kuusanu detu'pu' uikaatu, Jesús' jali munaa tyulla lunuuñuba tsa tsangue deke' veela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tsangue' dyatu juntsa keesha chuna' washnala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tsejtu ti' mityaa tsai' tutañuba mijakaanu, ta'panu piikike' Jesús' mishkai'sha mai'tela; tsenñu junu entsa pillami: Entsa Jesúsve, Judíola' Rei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tsenmin uñila' uudennu meedityu' chachillanu masmi' kemishti kemishtikemu chachillanu bain pallu kuusanu tu'pu' uikaala, mainnuya Jesús' urandya keesha, kamainnuya ya' jalandya keesha tu'pu' uikaakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tsenñu jundala pulla' jijiimula, Jesúsnu kentsure' depa' balejtu kure' yala' mishpuka lu'tesai jijiitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","entsa entsandila: Diosa' pupunanu yanu desene' pen malunuren jeke vera mannuuyu timu rukuya, ¡maali livee ide! ¡Ura Diosa' Natuya, aantsa kuusanu manbaijde! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tsenñu naa chachilla' mitya Diosnu kalen jimula' bale rukula bain, naa Moisés' wandya lei mashturula bain, naa judío balela bain, tsaren firu' pantsula entsanditu: ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Veelanuya livee keturen maaliya livee inu jutyuve. Ya Israel chachilla' reituya, ¡challaren kuusanu manbaijsa, tsenmala yanu keenguenu detsuyu! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yaa uwain Diosya tsanguemuve tya' yanu keenguemuñu' mitya, challa Diosren yanu estyamutuya livee kisa; matyu entsaa, ¿yaa Diosa' Nayu timu jutyuu? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tsenmala naa Jesúsba kuusanu tu'vimu chachilla bain tsarendi' kentsure' papatila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pajta katyu uratala tu kuraa dishpajtya' tsaa tsanatu, kepenusha pen ura inshaa madanguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tsenñu entsa ura juutala Jesús daran uti' entsandimi: Elí, Elí, ¿lemá sabactani? timi; tsandishu juntsaa, Dios, in Dios, ¿nenñunguiyu inu maali tirekemi? titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tsenñu mantsa junu pumula tsandiñu demeetu entsandila: Entsaya Diosa' mitya pamu ruku Elíasnu mikandundive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tsenmalan main yangachi jei ji', shivi binunu kuwa keraachi tsu'pu' kushkakaaketu, ñañi cha'linu llu'puke', Jesús' junga uslaami kujchisa tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tsenñun veelaya entsa entsandila: ¡Tsanguityude, keenadaa, Elías la'kaja'ba iñu meedaa! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tsenñu Jesús manen daran ma-uti' dyamin, ya' aama Diosnu kuwa' peyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tsenmala juntsa uwanun aa elesha ura juusha, Dioschin juu jumu sukunu daayanamu aa jali kai'sha kiyuu tse'kemin tusha pajanbera kiyuutse'ke' tsaa manba manba-iimi. Tsenmin naa tu bain dejulluke', aa shupuka jelekenuula bain deleetsetakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tsenñu naa ujkun tujuula bain demajuru deiñu, Diosnu keenguen chumu peyamulaya pure' mangujtaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tsejtu Jesús peya' mangujtañu, juntsala yala' ujkun tujuusha demafale' Dioschin juu Jerusalén pebulusha demiiñu, pure' chachilla yalanu mangataakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tsenñu tsangue' kala kiñu, tsenmin naa ti bain de-i' puiñu keenatu, Jesúsnu washna' keenamu suutadula' ama ya' chachillaba tsamantsai wapanandu entsandila: ¡Uwain entsaya Diosa' Nawaañuve! tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Junu supula bain pure' puna' baatala ne ke-eenala. Juntsala Galileabi Jesúsnu bendala deja' Jesúschi tiiñuba kivete kivetekemu shinbulaa tsanala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Juntsa shinbula' kejtsapala María Magdalena bain, naa Santiagochi, tsenmin Joséchi bain yala' ama jumu María bain, tsenmin Zebedeo' nala' ama bain junu pula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yumaa dekependu' kainsha main taruku jimi, Arimateasha chumu José, matyu ya bain Jesús' disipulu jumu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Juntsa ruku Pilato' junga ji', Jesús' ujkun bulu pa'ñu, Pilato kuwakaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tsenñu José katu tiba mayijtu naraa linu manbaalichi pijteke' ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ya' kasa ujkun tujuu, lanbakisha vishkaraa ujkun tujuusha pukiimi. Tsanguitu ujkun tujuu juukapanu aa shupuka di'kaakare' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tsanguendetsu junu ujkun tujuu juukapa bejtala María Magdalena, kama Maríaba chudi' chunala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Juntsa ayunchi, lekanu malunu, chachilla' mitya Diosnu kalen jimula' bale rukula, fariseo chachillaba Pilatonu keejitu ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","entsandila: Ruku, lala demandengayu juntsa anbumu ruku kayu peyai'mujchi chuumala: Pen malusha mangujnu tsuyu, timuwaañuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsa' mitya juntsa pen malu pullaindyuya ujkun tujuusha suutadu washkaade. Tsandenna ya' disipulularen ya' ujkun bulu mangalaaji': ¡Mangujñuve! ti'bandinu dejuve chachillanu. Tsangui'ba dekenmalaa, entsa bene' anbukuindaa, ajke' anbukuindanuba pullake kayu na'baasa detirenu juve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsa detiñu Pilato tsandimi: Enu ma bulu suutadu entsa denave; ka' ji', ñullaren ma ji-i', juntsa ujkun tujuunu naake washkaanuu juñuba tsanguiidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tsenñu yala dejitu, juntsa ujkun juukapanu di'namu shupukanu dejuikaañuba mijanu señas putu, suutadulanu washkaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Saaduma lekanu malu depuiñu, juntsa ayunchi, duminguma, semana ajke' malunu defijurukinsha María Magdalena, kama Maríaba juntsa ujkun tujuusha keenu jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsaaren Bale Rukuchi ma anjee selusha pajañu, tsamantsa daran kala kemi. Tsai' anjee pajatu, ujkun tujuusha ji', junu di'namu aa shupuka vee mujtu mandyulere' junu jandala chudiñumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Juntsa anjee kuidya pi'keñu keekiñuumi, tsenmin ya' jaliya aa kuyitala tsumu isha pukanu keekiñuu fikujchuchuumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tsenñu junu uinamu suutadulaya jelanchin dejulluke', matyu pemu tsun tsaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anjee juntsa shinbulanu tsandimi: Jeetyatyudei, iya miyu naa ñullaya kuusanu tu'vi' peyaishu juntsa Jesúsnu mi'kes nendetsuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yaa enu putyuve; naatimuwa ju'ba juntsa-i' yumaa mangujtave. ¡Jade-ii, yanu tsuununu ja' keekidei! ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tsa' mitya jei demiji' ya' disipululanu yumaa mangujta' yaa ajkesha puu, Galileasha ajke' miinu tsuve; jungaa mangatanu detsuve, detii. Entsaa iya ñullanu wainnu ju' mityandiyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tsenñu juntsa shinbula junu ujkun mennanunu jei demalu' miila. Tsejtu naa wapanaa deju' bain, tsaren sundyandetsu' mitya, jei demiji', juntsa kuinda manjintsula ya' disipululanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsai' miindetsun, Jesús yalanu fale' katawatu ura' dejusa timi. Tsenñu yala Jesús' neepanu amangue', deteedi' Jesúsnu aawa kure' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tsa deiñu Jesús tsandimi: Jeetyatyudei, inu keranguemu in naatalalanu Galileashaa ji', jungaa inu mangatanu detsuve, tidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tsa-i' juntsa shinbula miindetsun, ujkun tujuunu washnamu mantsa suutadula bain pebulusha demiitu, titi-i' puiñuba chachilla' mitya Diosnu kalen jimula' bale rukulanu tsandi kuinda kiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsenñu chachilla' mitya Diosnu kalen jimula' bale rukula, judíola' balelaba wa'dila, tyee kenu ju'ba mijanu. Tsejtu juntsa suutadulanu lushi pure' kuwakila, ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","entsandidei titu: Lala kasu'tsunu uwanu ya' disipulula kepe deja' ya' ujkun bulu tsaa tara dekive, detii. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tsenmin tsandenna entsa kuinda uñi' jungaaba chujiñu bain, lalaa mijanu detsuyu naakenu ju'ba, tsaaren ñullanuya tiba ikaren dejutyuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tsenñu juntsa suutadula lushi dekatu, yalanu naati depañuba tsandila. Tsenñaa naa entsa piikenu uwanu bain juntsa suutadula' anbukuindaa judío chachiitala ken chuchunala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tsenñu 11 disipulula Galileasha jila, Jesús nutsa kuyishaa jidei timuuñuba junga. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tsejtu Jesúsnu demangatatu, naa mantsalaya Jesúsren tsaañanga tya tyaindu bain, teedi' aawa kure' keewaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tsenñu Jesús yala' keesha jitu tsandimi: Diosya inu naa selusha bain, naa tusha bain tsaren de-uudenguen chunuu tireve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsa' mitya nukaba deji' naaju chachillanu bain in disipulu tiredei, in Apa' mitya bain, ya' Na' mitya bain, naa Espíritu Santo' mitya bain mungaakaakendu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsenmin iya ñullanu tyee ken chudei tiñuba juntsa meenguenu mijakaadei. Tsenmala iyaa, malumere entsa tu de-inbera ñuibaren bulu punu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Entsa kiikanaa Dioschi Mi'ke' Kayamu Na Jesús, naa-itaa ya' mika ura kuinda peepu' jiñuba wandyave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Diosa' mitya pamu ruku Isaías entsangue piikemuwaave: In mitya wainmu rukunu main ñu' ajkesha erentsuyu, tsenmalaa ñu tyeengues nenuuñuba tsanguenu peepu' tsuunutsu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tiba den chutyuin tenasha main entsandintsuve: Bale Ruku' janu miñu sekuwangue' tsuudei, ñulla' tenbukasha ya' miñu ura' mantse'kaadei, tintsuve, timuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tsenñu Isaías naatimuwaañuba juntsaitu, Juan Mungaamu tiba den chutyuin tenasha faatu, chachillanu: Veta' pensa demangue' Diosnu meengue' mungaradei, tsenmala Dios ñulla' ujcha pitsaanu tsuve, tis neneimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsenñu naa Judea tusha nutalaba chulla bain, naa Jerusalén pebulunu chulla bain Juannu meenanu pure' jijiila. Tsejtu yala' ujcha' mitya veta' pensa demanguenmalaya, Juan, Jordán pisha mungaakaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanya kameyu juchi keñu jallee panami, ya' ajpelenuya kika ajpeendee chuwaa telami, tsenmin dendu-ishu bain, jeendaa mishki bain juntsaalaa fimumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tsejtu entsandi kuinda kes neneimi: Bene main in benesha jamuya kayu inu pulla pude janu tsuve; tsenñu iya tsamantsa balejtunchin, naa waike' ya' sandalia chuwan juuñuba ne malanbu' kuwakenuba jutyuuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iyaa ñullanu pichi ne mungaakiyu, tsaaren juntsa rukuya ñullanu Espíritu Santaa kuwa' juntsachi mungaakeñuu kenu tsuve, tis neneimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juntsa malutala, Jesús, Galilea tusha, Nazaret pebulubi pu' lu' jitu, Juanchi Jordán pisha mungarami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tsejtu Jesús pisha pu' malundu selu jurudintsu katami, tsenmin Espíritu Santonu bain wa'pupu keraa ya' mishusha pajaintsu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tsenmalan kai'sha entsandiñu meejami: Ñaa in estyanu Nave, ñu' mitya yuj sundenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Entsai' puiñu, Espíritu Santo, Jesúsnu tsaa tiba den chutyuin tenasha miya' jiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tsenñu junga 40 malu tsanami, tsanaren Satanás yanu ujcha lawaanu kiikemi. Junga ajara animaala' kejtsapalan tsanami; tsenñuren anjeela Jesúsnu washkentsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juannu peesu deka' puñu, bene Jesús Diosa' mika ura kuinda kisai Galilea tusha jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tsejtu entsa entsandimi: Livee inu tinbu yumaa jave, tsenmin Diosnu rei juu tananu malu bain yumaa kalenave. Tsa' mitya veta' pensa demangue' ya' mika ura kuindanu meenguen chudei, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galilea aa pusu pi keetala puindu Simónnu bain, ya' naatala Andrésnu bain katami. Tsenñu yala ainguemu de' mitya, waaku pisha pajtekendetsu katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tsenñu Jesús tsandimi: In bendala jadei, tsenmala iya ñullanu, chachillanaa alla kan tsanguemu ruku detirenu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsandinmalan yala' waaku junu deshuike', ya' disipulu tiyanu ya' bendaa jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsejtu Jesús, kayu ajkesha jindu, Zebedeo' nalanu, matyu Santiagonu bain, ya' benna Juannu bain, kaa baakusha yala' waaku ura' manguiken pudena katami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsejtu nei'ba Jesús yalanu mikanmalan, kaa baakunu yala' apa Zebedeonu, junu taawasha kiveten pumulaban pungue shuike' Jesúsnu bendaa jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Cafarnaúm pebulubi vijila, tsejtu saaduma lekanu malu chayañu, Jesús chachilla' waku wakudinu yasha vitu Diosa' kuinda mijakaantsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tsenñu chachilla mika meenbashintsula, matyu yaa Moisés' wandya lei mashturula naake mijakaamu deeñuba tsanguityu', uwain tsandinuu ju' mijakaakaa keñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsenñu junu cha' waku wakudinu yanu, main Dioschi urajtu kuraa tiremu bu'chulla puu chachi pumi, tsejtu entsandi watimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¿Nazaretsha chumu Jesús, tyeenguenaa lalanu bulla kenu jatu iyu? ¿Lalanu dekike' pirenaa jatu iyu? Iyaa miyu ñu muñu bain. Ñuya Dioschin juu jumu chachive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsenñu Jesús nepatu tsandimi: ¡Patyude, aantsa rukunu malude! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsenñu Dioschi urajtu kuraa tiremu bu'chulla juntsa rukunu tsaa depi'shikaake', jelekenuti daran wati' maluimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tsenñu kumuinchi chachilla dewapana', veta' veta' pake'meran juutu entsa entsandila: ¿Tyee indu in enu? Muba Diosa' palaa ne tsangue mijakaatyunuren, entsaya uwain tsanguenuu tira' mijakaantsumin, naa Dioschi urajtu kuraa tiremu bu'chullalanu bain maludei tinmala meengue' malu maludeive, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tsenñu wajtutalaren, kumuinchi Galilea tusha chumula Jesús tyee kiikeñuba demijaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsejtu cha' waku wakudinu yasha pu' demalu' miitu, Jesús bain, Santiago bain, Juan bain, Simón Pedro' yasha jila. Tsenñu junu Andrés bain chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tsai' jiñu Simón Pedro' anchama penguma jupee tsunjuusha tsunami. Tsenñu tsanaa ti' Jesúsnu dewainñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús juntsa shinbunu kalen jitu, ya' tyaapanu kake' mangujtekemi, tsenmalan penguma ishanbajtekemi. Tsenmin yasha jimulanu tyeeba ke' kudundaimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yumaa dekependu' ka' pajta viñu, kumuinchi dilulanu bain, naa dyabulu puu chachillanu bain, Jesús' junga tajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tsenñu kumuinchi juntsa pebulunu chumu chachilla, ya juukapasha dewakudila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tsenñu Jesús, tichi diluu judeeñu bain purenamulanu ura' demandirekemi, tsenmin chachillanu dyabulu pumulanu bain pure' me-e'laakemi, tsejtu juntsa dyabululanu jaiba pakaatyu jujuumi, yalaya ya muñu bain mideeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dechayan mitya, jayu yapijuunaren Jesús kujpatu pebulu avindala lu' jimi, tsai' muba den netyuin tenasha ji' Diosba kuinda kentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tsenñu Simón Pedro, Jesúsba bulu nemu rukulaba Jesúsnu mami'kenu jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tsa-i' mangatatu tsandila: Mu bain ñunu mi'kenchin judeeve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsa detiñu Jesús tsandimi: Vee mujtu kalen chunu pebulusha bain jidaa, junga bain tsaren Diosa' kuinda mijakaanu menesteyu, matyu iyaa tsangues nenaa ja' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsejtu Jesús Galilea tushaya millai nemi, nunbatala cha' waku wakudinu ya dejuñuba jundala Diosa' kuinda mijakares neneindu, tsejtu chachillanu dyabulu depunmalaya me-e'lares neneimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ma unbere manbityu bishpeechi diluu jumu, Jesús' junga telenajitu, tsandimi: Ñuren tsanguenu tenñuya, inu ura' mandireka; iya mijayu, ñu in dilu peya manbirenuu juñuba, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsandiñu Jesús, juntsa rukunu tenbityatu, ya' tyaapachi ta'katu tsandimi: Uwain tsanguenu tenve. ¡Ura' mandiyade! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsandi' dyanmalan manbityu bishpee jei manbimi juntsa dii rukunu, tsenmalan narai mandiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tsenñu Jesús tsangue' juntsa rukunu me-eendu, ule' ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","entsanguide timi: Entsa iishu juntsa munuba waintyu', chachilla' mitya Diosnu kalen jimu rukula' jungaa ji' wainde. Tsejtu juntsan mitya Moisés tyee kenu dejuve timuwaañuba juntsaa ke' Dioschi ura' kuraa mandiyayu ti' keewaanu ufeenda taji' kuwade, tsejtaa diluren ura' mandiyayu ti' keewaanmala, veela bain ñu uwain ura' mandiyañuba mijanudetsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsandiñuren juntsa rukuya tyee i'ba munu'baasa dekuindakikemi. Tsenñu' mitya Jesús umaa naaju pebulutalaba chachilla dekeenaya vi' nenu jutyuu tiyaimi, tsejtu chachilla den chutyuin pebulu kapashaa neneimi, tsenñun nuka chumu chachilla bain ya' junga pure' jijiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesús tsaita nendu jayaa ma piyaitu manen Cafarnaúm pebulusha mavimi. Tsenñu nei'ba junu yasha manbuve detiñu kuinda mijalan, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","chachilla pure' wakudi' naa ya juukapashaba yallu de-i' muba jinu' jutyungue tirela. Tsa deiñu Jesús Diosa' kuinda mijakaantsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsejtu tsanguenu uwanu main dedeelaa rukunu taapai unbere kayu veelaba wandunu yallaa tajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tsaaren chachi puredenañu' mitya, naa-i' Jesús' uinanbi jin tsaatu, pakikii ya mishbui'sha delu', Jesús' uinanu deechunu fataapu', junu juntsa dii rukunu wandunu tsuu pajtekila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tsenñu Jesús, juntsa rukula yanu uwain dekeranguiñuba mija' mitya, juntsa dii rukunu tsandimi: Kaana, ñu' ujcha demanbitsalave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tsenñu junu Moisés' wandya lei mashturula mantsa chuna' dekeenatu, Jesús juntsandiñu entsangue pensanguila: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Entsa unbere, ¿tyeenditundin ne tsandimi? Ya' palaaya Diosnu kentsure' pantsuve, Diosren ujcha' mitya manbitsaakenuu juunuba, ¿naajutaa vera bain tsanguenuu juñaa tsanditundin?” tya' pensanguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsenñu Jesús, yala naatyandetsuñuba mijatu tsandimi: ¿Nenñaa ñulla' tenbukasha aantsangue pensa kendetsuyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Entsa dedeelaa dii rukunu: Ñu' ujcha' mitya manbitsalave, tityumujchi: Mangujpa' ñu' wandu manga' miide, tiñu bain tsaren jutyuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tsaaren uwain naa Chachi Tiya' Nakayamuya entsa tusha chachilla' keñu ujcha manbitsaanuu juñu bain ñulla mijanudetsu, titu, dedeelaa tsumu dii rukunu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ñunu tsandintsuyu: Mangujpa' ñu' wandu manga' ñu' yasha miide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsandinmalan, juntsa dii ruku jei mangujpa' ya' wandu manga' muba dekeenan junu malu' miimi. Tsenñu kumuinchi keenbashii deshuwa', Diosnu yuj ura' kemu rukuve ti' entsa entsandila: Naa-uwanuba entsaa intsuya kerajtuwa deeyu, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bene Jesús manen pusu pi keesha miimi. Tsenñu chachilla ya' keesha pure' jijideiñu, yalanu mijakaakaa kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tsejtu Jesús tsaita nendu, Alfeo' na Levínu, buli tajimulanu Roma uñichi deechu' mitya lushi kainsha chuna katatu tsandimi: In bendala ja' in disipulu tiyade, timi. Tsandinmalan Leví kujpa' Jesúsba bulu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsejtu Jesús ma bijee Leví' yasha ya' disipululaba panda fintsuñu, naa romano uñichi deechu' mitya lushi kamula bain, naa veela ujcha lan kuramu chachilla bain puredena' Jesúsba bulu chudi' panda fintsula, matyu yanu bendaa nemula pure' jude' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsenñu mantsa fariseola, matyu Moisés' wandya lei mashturula, Jesús naa romano uñichi deechu' mitya lushi kamulaba bain, naa veela ujcha lan kuramu chachillaba bain bulu chudi' panda fintsuñu dekatatu, ya' disipululanu entsandi pake'meela: ¿Nejtaa ñulla' mashturuya deechu' mitya lushi kamu rukulaba bain, naa ujcha lan chumu chachillaba bain buudi' panda findunguen? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsa detiñu Jesús meetu, tsandimi: Tiba dilujtu chachillaya dilulanu ura' mandiremulanu menestejdetuve, tsaaren dilulaya meneste deeve. Tsaju' iyaa Dios naakesa tyañuba tsanguen chumu chachillanu mikanu jaindyuyu; iyaa ujcha lamu chachillanaa mikanu jayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma bijee, naa Juan Mungaamu' disipulula bain, naa fariseola' disipulula bain Diosnu pensangue' panda findyula, tsenñu mantsa chachilla Jesús' keesha jitu, entsandi pake'meela: Juan' disipulula bain, naa fariseola' disipulula bain Diosnu pensangue' panda findetyuñuba, ¿nejtaa ñu' disipululaya tsanguindyutu den? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tsenñu Jesús tsandimi: ¿Matsunu fandangu kendetsu, junu bulu puve'nu mikayamu chachilla, matsumu ruku yaiba bulu puba Diosnu pensanguiike' panda fityuñu uran? Uwaindiyu matsumu ruku yaiba bulu puya tsanguenu dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tsaaren uwaindiyu mandinbu matsumu rukunu manga' miinu malu janu tsuve; tsenmalaa uwain juntsa malunu Diosnu pensangue' panda fityunu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsejtu ya' mijakaanutala manbatu tsandimi: Mu bain uinbu jalinu kasa jai petse mangaaputyu deeve, matyu kasa jaliya buru' kayajtu' mitya mangaapunmala buru' kamin, uinbu jalinu kayu aa kiyuu-eekenu juñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsenmin uinbu ki' buusanu bain kasa binu vityuve, matyu kasa binuya feetenchin juntsa uinbu ki' buusanu defataa eeke' buusa demusha' kevinmala, naa binu bain desejiinu juve. Tsa' mitya kasa binuya kasa ki' buusanaa punuu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma malu saaduma lekanu malunu Jesús ya' disipululaba vijpaatala pulla' jintsumi. Tsenñu ya' disipulula jundaa puindu trigu ñi ka' fisai jintsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsanguendetsu fariseola kata' Jesúsnu pake'meetu: ¿Nenñaa ñu' disipulula, saaduma lekanu malunuya tiba ken jutyuu junuba tsanguendu deken? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tsenñu Jesús tsandimi: ¿Ñullaa lengue' kerajdetuu, ma bijee David ya' chachillaba nendu tsaa panda dekike' ti fin tsandyatu tyeenguemuwa deeñu bain? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Juntsa tinbunu Abiatarya chachilla' mitya Diosnu kalen jimula' kayu aa bale ruku juwaañuba, David Diosa' yasha vi' Diosnu keewara pan tsumu ka', yaba bulu nemu chachillaba fimuwa deeve, naa chachilla' mitya Diosnu kalen jimu rukulan fikenuu pan juñu bain. Naa tsanguemuñu bain yanuya kuipa putyuwa deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tsandi' kayu pandu tsandimi: Saaduma lekanu malu juushu juntsaya chachillachee ju', lekanu maluchee chachilla ne tsai' uuden in chunu dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tsa' mitya Chachi Tiya' Nakayamuya, naa saaduma lekanu malunu bain tyeenguenu tya'ba tsanguenuu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús, manen cha' waku wakudinu yasha mavimi, tsenñu junu ma ruku mandyaapa yujka dedeelaa pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tsenñu mantsala naati' Jesúsnu kuipa pun tsandyamu chachilla dus keetanala, tsejtaa saaduma lekanu malunuren juntsa rukunu ura' manguenmalaya kuipa faawaanu detya' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsenñu Jesús, mandyaapa yujka dedeelaa rukunu: Aanu kejtala kujpa' uidide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tsejtu veelanu entsandi pake'meemi: ¿Saaduma lekanu malunu tyee keñaa uranu jun? ¿Uraaya kenuu jun? Tsa jutyu'ba, ¿urajtu juuya kenuu jun? ¿Chachillanu livee kenuuya jun? Tsa jutyu'ba, ¿peyawaakenuuya jun? timi. Tsandiñuren muba yanu depakai'ñu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús ya' keetala uinamu chachillanu ajaatya' keemi, tsejturen mika pensandyami, yala' tenbukashaya firu' deju' aseetanguenu detyatyuñu' mitya. Tsejtu juntsa dii rukunu entsandimi: Ñu' tyaapa usakide, timi. Tsandiñu juntsa ruku ya' tyaapa uskenmalan tsaa narai mandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsanguiñu keena' fariseola demalu' miitu, Herodes rei juñuba uraa tyamu chachillabaa debuudi', Jesúsnu tyee kitaa tu'kaakeechunga ti' paviikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús ya' disipululaba Galilea pusu pi keesha jila, tsenñu chachilla pure' bendaa jiila, naa Galileasha chulla bain, naa Judeasha chulla bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","naa Jerusalén' chulla bain, naa Idumea' chulla bain, naa Jordán pi bejkusha chulla bain, naa Tiro pebulu kelutala chulla bain, tsenmin Sidón pebulu kelutala chulla bain, Jesús tyee tsamantsaa kiikeñuba demijatu pure' jiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsenñu Jesús ya' disipululanu ma kaa baaku yachi sekuwangue' keenanu uudenguemi, pure' jiimu chachilla yanu menaa tyuli'ba kichudee tyatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","matyu Jesús, dilu purenamulanu ura' demandireñu' mitya, naaju dilula bain yanu tene ta'kanu dekeena', menaatyuinu kiidekiñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tsenñu chachillanu pumu Dioschi urajtu kuraa tiremu bu'chullala Jesúsnu katamiya tsaa ya' ajuusha teledi' watitu entsa entsandila: ¡Ñuya Diosa' Nave! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tsa tsa detiñu Jesús ya mu ju' tyee kiike' bain kumuinchi demeenaya tsandityudei ti' nepa nepatimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsangue' dyatu Jesús bene kuyisha lumi, tsejtu naaju chachillanaa yachi uraa tya'ba, juntsalanu demikami, tsejtu junga ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","wa'namu chachillanu 12 unbere mi'ke' katu, juntsa rukulanu entsangue mumu pumi: Jesús' mitya kuinda kenu lara' eramu rukula mumu pumi, tsenmalaa naa-uwanuba yaba bulu dene', naa Diosa' kuinda bain demijakares nesa tyatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tsejtu juntsalanu naa dyabululanu bain deme-e'laanuu tiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Entsalaa juntsa 12 ruku mi'ke' kayamula deeve: mainya Simón, tsaanuren Jesúsya Pedro mumu manbumi, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeo' nalaya: Santiago bain, Juan bain, entsalanuya Boanerges mumu manbumi, kuidya juuñuu rukula titu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","tsenmin Andrés bain, Felipe bain, Bartolomé bain, Mateo bain, Tomás bain, naa Alfeo' na Santiago bain, Tadeo bain, naa Simón, Diosa' lei naajuñuba tsa deki'ñu selandyamu tinu ruku bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tsenmin Jesúsnu kundaalanu wandi' kakaamu ruku Judas Iscariote bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsejtu bene Jesús yasha miiñu, chachilla manen pure' wakudedi' yanu bain, naa ya' disipululanu bain panda fikaanu kityu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tsenñu Jesús' paandela mija' dejitu, naa Jesús merendyuba deranchi manga' mijiinuu jiila, matyu Jesús yujtaa ma iiñuve, tiititu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tsenmala Jerusalénsha pu' jimu leichi mashturula bain entsandintsula: Entsa rukunu dyabulu uñi Beelzebú tsanguikaañaa dyabulu me-e'laalaakive, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsenñu Jesús yalanu mikatu entsangue laapu' kuinda kemi: Naake' Satanás maalin majuka'laanu juu jutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tsaju' naa ma reichi uuden juu chumu chachilla bain yai tene kundaa detiya' velaa ne chudenashu juntsaa tsanan dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tsenmin naa ma rukunu laapu' pañu bain, naa ya' shinbu bain, naa ya' kailla bain, tsaa yaitala kundaa devi' veladeishu juntsaa, naana chunuu juñuba tsa denatyu' tsaa de-iinu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsa' mitya naa Satanás bain maalin kundaa tiya' tsaa develaishu juntsaa, tsanatyu' de-i' piyainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tsenmin kayu Dyabulunu laapu' patu tsandimi: Dee ruku' chunu yanuya muba vi' yachi tiba taanguenuu dejutyuve, juntsa rukunu ajke' tele' tsuutyumujchiya; tsanguitaa tiba taanguenuu dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Uwaindiyu Diosya munuba yala' ujcha' mitya bain, naa kentsure' padetiñu bain juntsa ujcha' mityaya demanbitsaanu juve; ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tsaaren Espíritu Santonu kentsure' pamunuya naa-uwanuba juntsa ujcha manbitsalan jutyuu juve, tsaju' naa-uwanuba kuipa junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús entsandimiya yanu leichi mashturula Dioschi urajtu kuraa tiremu bu'chulla puuve detiñu' mityaa, tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús tsandin punu uwanu ya' ama bain, ya' naatalala bain jila, tsejturen ya juushaa vityu' avindala ne uinala Jesúsnu lasa tya' veelanu mikakaakitu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsenñu Jesús' keetala chumu chachilla tsandila: Ñu' ama bain, ñu' naatalala bain deja' avindala depu' ñunu mi'kes nendetsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tsa detiñu Jesús entsandi pakami: ¿Maa in aman, tsenmin naajulaa in naatalala den? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsanditu ya' keetala chumulanaa kere' patu tsandimi: Entsalaa in ama bain, in naatalala bain jumula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Matyu naajulaa Dios naakesa tyañuba tsanguen dechu'ba juntsalaa in naatalala bain, in ama bain dejuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús manen chachillanu pusu pi keesha mamijakaren pumi. Tsenñu chachilla pure' wakudediñu, Jesús junga unamu kaa baakunu vi' chudi' mijakaantsumi, tsenmala junu wa'namu chachillaya pi keetala wa'na' ya' kuinda meenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsenñu Jesús, chachilla tyee ken chumu deeñuba tsaanu tene laapu' kuinda kiiketu, pure' mijakaakentsumi. Tsejtu mijakaandu tsa tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Entsa kuinda meedidei: Ma ruku ñi waakenu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tsejtu waakiñu mantsa ñiya, cha' neneinu miñutala pajtyañu, pishku jatu tsaa defikila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tsenmala mantsa ñiya tu aa tsutyu shupu' tsundala paijla, tsejtu tu aa bebe' tsutyuñu' mitya jeke shu'kila, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","tsenñuren pajta fale' de-ejbiyu' kakaakenmalan, telele aa erajtu de' mitya tsaa de-ejkeila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tsenmala mantsa ñiya puchi chundalaa paijmi, tsenñu puchi de-awalan juntsa kiyalanu depijteke' ura' awakaatyuñu puka i'la. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tsaaren mantsa ñiya ura tunu paijmi, tsejtu uukerai awa' puka ila; ma kuyamee 30 ñi kuwake, 60 ñi kuwake, naa 100 ñi kuwakena' bain tsa tsaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tsandi' dyatu Jesús tsandimi: ¡Mun pungui pu'ba ura' meedi' aseetanguidei! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bene, chachilla demiiñu, Jesúsnu kayu kalen uinamu chachilla ya' 12 disipululaba bulu pake'meetu: ¿Juntsa laapu' kuinda juu kikishu juntsa naake aseetanguikaanuu jutun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tsenñu Jesús tsandimi: Diosnu rei juu tananu deeñu tyee ju' pantsunañuu juñu bain ñullanuya tsaa dekeewaakive, tsaaren vee chachillanuya tsanguityumujchi laapu' kuinda juuchi tene mijakaakentsuve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tsenmalaa Diosa' Kiikanu naatiñuba juntsa ju', naa mika kere'ba, ura' keengai'nudetsu, naa mika mere'ba aseetangui'nudetsu, tsenmalaa veta' pensa demantyu' Diosnu dekeenguityunmala, Dios bain yala' ujcha' mitya manbitsalei'nutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsejtu Jesús tsandimi: ¿Ñulla, entsa laapu' kuinda juushu juntsanu aseetanguindetyuu? Tsaashu juntsaa, ¿nejtaa kayu vera laapu' kuinda jumulanu aseetanguenuj deeyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ñi waakemuya, Diosa' palaa mijakares nemu ruku juuñuuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tsenmala mantsa chachillaa miñutala ñi paijmu juuñu deeve: Diosa' palaa demeeñuren, Satanás ja' yala' tenbukasha uukaañu kuinda demachipa kenmalan tsaa millai manbaishmula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tsenmala mantsala shupu' tsundala paijmu ñi juuñuulaya, Diosa' palaa demere' sunden meeditun, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","chi ju'ba telele aa erajtu juuñu de' mitya, naa-uwanu Diosa' palaa' mitya taaju de-i' bain, tsa jutyu'ba, naa-uwanu firu' kenu bendaa dekiñu wapanai' bain, mangueenguityui tiyamula deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tsenmala mantsalaya puchi chundala paijmu ñi juuñuu chachillaya, Diosa' palaa demeeturen, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","entsa tusha tiba kiiken chunutala tene aa pensaa deju', tiba balen juu detadinu tyanu pensachi anbutikayaiñuu i', tiba dekachi tya' pensanguiikentsu', Dioschi ura' kuindanuya aawakaatyu' puka iwaañunguityu', ne manbashiimulaa juntsaañu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tsaaren mantsala Diosa' palaa meemiren ura' meenguemu chachillaya ñi ura tusha pajtya' puka in tsaimula deeve. Tsejtu juntsa ñi juuñuu yai bain, mantsalaya kuyamee 30 ñi kuwake, 60 ñi kuwake, naa 100 ñi kuwakena' bain tsanguemulaa juntsaañu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tsejtu Jesús entsa bain tsandimi: ¿Ma lanpara chakaatu piyama panbeesha pukinaa chakaramun? Tsanguityumee, ¿tsunjuu pandainsha chujtikenaa chakaramun? Uwain tsaityuve, chakaamiya kai'tala dejtelanu chujti' millangue dangaanaa chakaramuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tsaren juve, ne ti pantsunañuna' bain bene katawan jutyuuya jutyuve, tsenmin ne ti dus minuu juula bain bene mijakeyan jutyuuya dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mun pungui pu'ba entsanu meedi' aseetanguidei, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tsejtu entsa bain tsandimi: Meedenashu juntsa kuindanu ura' meedidei: Ura' meedityushu juntsaa, ura' aseetanguenu dejutyuve; tsaaren ñulla ura' meedishu juntsaya, kayu narake aseetanguenu dejuve. Narake meemulanuya Dios kayu ura' aseetanguikaanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Matyu mun talanuya kayu aa mangunu tsuve, tsaaren mun tajtulanuya naa jayun tadeeñu bain, demachipake' tiba tajtungaanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús entsa bain tsandimi: Diosnu rei juu tananu juñu pensanguiñuya, ma ruku tunu ñi wajkenmala juntsa ñi tyee imuwaañu bain juntsaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ñiya maaliren shu'ke' awamuve, naa wajmu rukuya kepe ne kasu'tsuna bain, naa mandala ne keenañu bain; matyu wajmu rukuya naa-i' awañu bain mijaindyuren ne de-awaimuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tuya maaliren ñinu shu'kikare' awakaamuve, puka bain nangaakaamuve; ajke' faamiya tapee faamuve, benee ya' papa, tsenmin kayu benee ya' papanu ñi bain detiya' nandimuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tsenmala umaa ñi puula' kanu ura detiyanmalaya te'kamu deeve, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Entsa bain Jesús tsandimi: ¿Diosnu rei juu tananu juñu tinaa laapu' uwain juntsaave ti' kuinda kenu dejuwa? ¿Ti juubaa laapu' kuinda ke' mi'te' keenu dejuwa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ura patiñuya, mustasa ñi tunu wajñu naa-i shu'ke' awa' jimuñuba juntsaave. Uwain mustasa ñiya wajnu ñiitala kayu añuñu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tsaaren dewajkenmala awamiya entsa chi jumaa veeta juusha awamuutalaya kayu aa chi awamuve, tsejtu naa ya' ali jumula bain aawa' detiyanmalaya ya' faapanbeesha pishku deja' yatape kiikemu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Entsanguitaa Jesús Diosa' kuinda ketu laapu' kuinda juuchi tene pure' mijakaakaa kemi, matyu naatiñaa chachilla aseetanguenuu dejuñuba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tsa' mitya meenamu chachillanu ti mijakaakenu tya' bain laapu' kuinda juu tene ke' mijakaakaa kemi, naa ya' disipululanuya juntsa laapu' kuinda ketu naati' tsandi'ba bene wandi wanditi' bain. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Juntsa malunuren dekependu' kainsha, Jesús ya' disipululanu tsandimi: Entsa pusu bejkusha tyakadaa, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsenñu ya' disipulula junu wa'namu chachillanu deshuike', Jesús naajuñuba juntsaanun demiya' ji' baakunu jimishtila. Tsenñu kayu vee kaa baakula bain yala' bendaa jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsai' jindetsu, ishuwa daran juyi', naa pisunda bain jelekenu pure' la-i' tsaa kaa baakunu pi depukentsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tsaintsun Jesúsya baaku pekasha bishpui jandala kasu' tsunami. Tsenñu yanu mandengaajitu tsandila: ¡Mashturu, lala baivinundiyandetsuyu! ¿Tsaintsuba, ñuchiya ne jujuu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsenñu Jesús mandenga' kujpatu ishuwanu bain, aa pusunu bain tsandimi: ¡Dya'ka', nejui mandiyadei! timi. Tsandiñu, ishuwa mandyanmalan kumuinchi aa pusu nejui mandiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tsangue' dyatu, bene Jesús ya' disipululanu tsandimi: ¿Nejtaa ñullanu tsamantsa jeetenguen? ¿Chaikama ñulla pulu' kera dejutyuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsenñu dewapana' yaitala veta' veta' pake'meenchin juutu entsa entsandila: ¿Entsa naaju rukuñaa, naa ishuwa bain, naa aa pusu bain ya naatiñuba meenguetu deken? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tsejtu Jesús juntsa aa pusu bejkusha ya' disipululaba tyakatu, Gerasa tusha jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tsai' detyakatu, nei'ba Jesús baakusha pu' tusha luinmalan, ma ruku Dioschi urajtu kuraa tiremu bu'chulla puu jumu ujkun mennainsha pu' fale', Jesús' junga kalen jimi, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ya junga ujkun mennainshaa chumu' mitya. Tsaaren mu bain juntsa rukunu naa jeru chuwachi juu bain teetsure' tadinu jutyu jujuula, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","matyu pure' bijee jeru chuwachi, naa tyaapasha bain, naa neepasha bain narake deteeñuba, tsaa dedaa-ee-eekiñu' mitya, mu bain naake' tele' tsangaanuba jutyu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tsenñu naa-uwanuba, naa mandala bain, naa kepe bain ujkun mennandala ne'kera, naa kuyitala bain lu' utis neneimi, tsenmin maaliren shupukachi bain dewanaa chi'ka chi'kakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tsaaren Jesúsnuya baatala kata-eekemiren tsaa yangachi ji' Jesús' neepasha teledi' ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","entsandi ui'mi: ¡Jesús, aa kai'sha chumu Diosa' Na, inu bulla kijatyuka! ¡Tsantsaya Diosa' mitya inu taaju iware' puiwaatyuka! timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Juntsa ruku entsandi pamiya, Jesús yanu ajke' patu: ¡Dioschi urajtu kuraa tiremu bu'chulla, entsa unberenu mandyaike' malu' miide! tiñu' mityaa tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsejtu Jesús juntsa rukunu entsandi pake'meemi: Ñu, ¿ti mumuyu? timi. Tsenñu juntsa ruku: Iya Sera mumuyu, lalaya tsamantsa sera deju' mityaa, tsaa mumu deeyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tsejtu Jesúsnu entsa tenanuya yalanu manguelare' me-eetyukai titu, u'ta u'tandila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tsejtu junu yala' keesha ma kuyi keetala, ku'chi pure' puna' panda fin de-uinañu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","juntsa dyabulula u'tandindu tsandila: Ku'chilanaa lalanu me-eepuka, tsenmala lala yalanaa vi' machunu detsuyu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tsa detiñu Jesús tsaikaañu, juntsala Dioschi urajtu kuraa tiremu bu'chullala cha' rukunu demalu' miitu tsaa ku'chilanu tene maviila. Tsenñu kumuinchibi mika 2.000 ku'chi jumula tsaa yangachi tene ji' lanba' kujtusha depajtya' pisha dechukakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tsenñu ku'chi washkemu chachilla denepiya' miji', pebulusha bain, naa jeendaa chumu chachillanu bain tyee iñuba dekuindakiila. Tsenñu tyee iñu detiñanga tyatu chachilla keenu jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tsejtu Jesús' puinbi dejitu, dyabulu pure' puu unbere ura' mandiya' tiba jutyu jali manbanaa chuna katajila. Tsejtu chachilla jeetyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tsenñu naa-itaa juntsa dyabulu pumu unbere ura' mandiñu bain, tsenmin ku'chilanu bain tyee iñuba, keenamulaya juntsandi wainla veelanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsenñu junu chumu chachilla, Jesúsnu, juntsa tenanu malu' vee mujtu miide, ti' papatila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tsa detiñu, Jesús baakusha mavimi miinu, tsenñu dyabulu puu jumuren ura' mandiyamu ruku yanu bulu miya' jika ti' pami, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","tsenñuren Jesús meetyu' entsandimi: Ñu' yashaa miji', ñu' paandelanu Bale Ruku ñu' mitya tyeenguiñu bain, ñunu naa-i tenbitya' ura' manñu bain, miji' juntsa kuinda kide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsandiñu juntsa ruku miitu, Jesús yanu tyee kiñuba Decápolisnu chumu pebululanuya, tsaa dekuindakes neimi; tsenñu kumuinchi chachilla mika meenbaishla. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús baakusha mavi' pusu bejkusha mandyakajiñu chachilla pure' mawakudila. Tsenñu yaa pi keesha punami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsananu uwanu, cha' waku wakudinu yasha bale pumu ruku Jairo mumu ji', Jesúsnu katamin tsaa ya' neepasha teledi' ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","u'tandi' entsandimi: In na'ma ma peyaintsuve; tsantsaya ja' ñu' tyaapachi ta'kade, tsenmala ura' mandiya' chunutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tsandiñu, Jesús juntsa ruku' bendaa jintsumi, tsenñu vee chachilla bain pure' jiindu ya' keetala ujkijtuu jiintsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tsenñu ma shinbu asa senduwaraa dilu chuturen 12 añu ma iintsumu shinbu bain chachilla' kejtsapala pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Juntsa shinbu naa dilu ura' mandiremula' junga bain neneindu, tsenmin naa ya' tananu lushi bain dekike'ba ura' mandiyaba indyu' mika taaju ken chu' kayu ne firu' iintsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tsenñu juntsa shinbu, Jesús tyeengues neneiñuba kuinda mijatu, ya' junga ji' cha' kejtsapalan bulu jindu, Jesús' benesha mi'na ji' ya' jalinu ta'kakemi, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ya' pensaya: “Ya' jalinu ta'kaketun ura' mandiyanu tsuyu”, tya' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tsejtu uwain tsaimi, jai kapanu ta'kakemin asa jaa tsanamuren tsaa mandyawaakemi, tsejtu juntsa shinbu umaa dii peya ya' bulunu manbireyu tyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsenñu Jesús, ya' bulunu pudee lu' jiñu mijatu, chachilla' janu benesha mangue-ere' pake'meetu: ¿Maa in jalinu ta'kan? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tsenñu ya' disipulula tsandila: Tsen, ñunu kelush kelush ujkijtuu ma jaindetsushuba, ¿naa titundiyu: Maa inu ta'kan? timi, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsa detiñuren Jesús, ya' keetala kalen uinamu chachillanu kerentsumi, maa yanu tsangue' ta'kañuba mijanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsenñu juntsa shinbu yanu tyee iñuba narai mija' mitya, jelanchin dejullukendu, Jesús' ajuubi telena jitu naa-in chumuwa ju'ba millandi kuinda kemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tsenñu Jesús tsandimi: Kaa na'ma, ñu uwain tsainu tsuyu tya' keengue' mityaa, ura' mandiyañuve. Tiba bulla jutyu miide; yumaa ñu' dii peya ura' mandiyave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús juntsa shinbunu kayu pa' jintsuren, cha' waku wakudinu yasha bale pumu ruku' yasha pu' jamula entsandila juntsa bale rukunu: Ñu' na'ma yumaa peyave. ¿Tsa' mitya tyeenguinaa mashturunu kayu bulla kentsunu juyu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tsenñu Jesús yalanu meetu, cha' waku wakudinu yasha bale pumu rukunu tsandimi: Jeetyatyude, inu uwain tsanguenu tsuve tya' keranguide, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsejtu Jesús juntsa rukuba jindu, veelanuya miya' jityumujchi Pedronu bain, Santiagonu bain, Santiago' benna Juannu juntsalanun miya' jiimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsai' cha' waku wakudinu yasha bale pumu ruku' yasha dejitu, chachilla wati' ware' fidyatindetsu katajila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tsejtu Jesús ya juusha vitu chachillanu tsandimi: ¿Nendetiyu ware' tsamantsa fidyatintsula? Juntsa na'ma peyai'mujchi, ne kasu'tsunave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesús tsandiñu junu pumu chachillaya ne uukapundila. Tsenñu Jesús millangue avindala deme-e'laatu pemu kaa na'ma' tsuinsha vindu, ya' apalanu bain, yaba bulu miya' jiñu chachillanu bain juntsalaban viimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsai' vitu juntsa kaa na'ma' tyaapanu kaketu tsandimi: Talita kun, timi; tsandishu juntsaa: Kaa na'ma, ñunu mangujpade tintsuyu, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jesús tsandinmalan, juntsa kaa na'ma, 12 añu juu jumu, mangujpa' manedundaimi. Tsenñu kumuinchi chachilla yuj keenbaishla. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tsenñu Jesús juntsa chachillanu tsandimi: Tyee iñuba jayuuba munuba kuinda kityudei, ti' patu, bene juntsa kaa na'manu panda mafikaadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús junu pu' miitu, ya' awanu pebulusha miintsuñu, ya' disipulula bain yaba bulu jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tsejtu saaduma lekanu malu chayañu, cha' waku wakudinu yasha vi' Diosa' palaa mijakaantsumi. Tsenñu junu wa'na' meenamu chachilla mika meenbashindu tsa tsandila: ¿Tsen, entsa unberee nukaa tsaa demijatundin? ¿Maa yanu tsaa aseetaju pensa kuñanga? ¿Tsenmin naa ketaa tiba tsamantsaa ke' keewara juula bain kiiketunguen? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Entsa María' na, kaapinderu taawasha kemu ruku jutyuu, naa Santiagochi bain, Joséchi bain, Judaschi bain, naa Simónchi bain ya' naatala jutyuu? ¿Tsenmala naa ya' tsujkila bain lala' pebulunun dechutyuu? tiitila. Tsanditu Jesúsnu jayuuba ya' kuindanu meenguityu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsa deeñu, Jesús tsandimi: Diosa' mitya pamu rukula vee mujtu nenduya balenguramu deeve, tsaaren ya' chunu tusha bain, naa ya' bulula' kejtsapala bain, naa ya' chunu yasha bain chumu chachillachiya balenguratyu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsejtu Jesús, junuya tiba tsamantsaa ke' keewara jumula ke' keewarendyu'ba, dilulanuya ya' tyaapachi ta'ka' mallee ura' mandiremi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tsejtu Jesús mika keenbashi' puimi, junu chumu chachilla yanu jaiba dekerangui'ñu' mitya. Jesús, Nazaret keetala kaa pebulu chumulanu Diosa' palaa mijakares neneimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsejtu bene yachi 12 disipululanu demikatu pallu pallu vele', nukaba de-eekemi, Dioschi urajtu kuraa tiremu bu'chullalanu me-e'laanuu bain detiretu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tsejtu mindala menestenguikenuu juulaya ti bain ta'tyudei tituren, tyutyan cha'liya main ta'dei, timi. Tsa' mitya ti buusa juu bain, naa pan juu bain, naa lushi juu bain, jayuuba ta'tyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tsaaren sandalia juuya pu' jidei tituren, bene manbannu vera jali juuya ta'nu mandangui'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tsejtu tsandimi: Naaju yanu viji' bain juntsa pebulunu malu' miji'mujchiya juntsa yanun chudei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tsaaren nukaaba ñullanu demikatyu', naa meedinu tya bain de-i'shu juntsaa, junu malu' miidei, tsai' malu' miindu ñulla' neepanu mai'dimu ujtupe demangasha'pukidei, tsanguetaa Dioschi urajtu chachi dekure' taaju inu detsuve ti' keewaanu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsenñu ya' disipulula delu' jitu Jesús' mitya kuinda wandis neneila: Veta' pensa demangue' Diosnu meranguidei, tiititu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tsejtu naa dyabululanu bain pure' me-e'laakes ne', naa dilulanu bain muli yuutsure' pure' ura' mangues neila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chachilla Jesúsnu laapu' patu naa naadetiñu bain rei Herodes kuinda meemeekemi, matyu Jesús' kuinda nukaba den meejantsuñu' mitya. Tsenñu mantsa chachillaya: Entsaya Juan Mungaamu millaa mangujñuve, tsa' mityaa naa tiba tsamantsaa ke' keewara juu bain ke' keewaawaakive, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tsenmala veelaya: Entsaya Diosa' mitya pamu ruku Elíasve, tiitila. Tsenmala kayu veelaya: Kaspee tinbunu Diosa' mitya pamu rukula jun tsaave, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tsa tsa detiñu, Herodes meetu tsa tsandimi: Juntsaya Juanve, iya mishu daapukare' tu'kaakeeshu juntsa ruku, challa mangujtu iñuve, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Matyu Herodesya, Herodías' mityan Juannu peesu kakare' jeru chuwachi teetsuukaakemuwaami. Tsaaren Herodesya ya' naatala Filipo' shinbu jumu Herodíasnun, tsaa ya' shinbu mandirekemuwaami, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","tsenñaa Juan, reinu tsa tsandimuwaami: Ñu' naatala' shinbunun ñu' shinbu majuu tananu jutyuve, tiitimuwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tsenñu' mityaa juntsa shinbu Juannu ajaatya' tu'nu tyaturen, naake' tuten tsaa jujuuwaami, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","matyu reiya Juannu jeemuwaami, yaa Dios naakesa tyañuba tsanguen chumu ruku juñu, naa Dioschin juu chachi juuñuba mi' mitya, tsenmin yanu tiba ikaan jutyu yaa washi washikemuwaami. Tsejtu Juan ule' pañu meenamiya ti ken tsai tiya tiyaimu ju' bain, meenanchiya meenanu ajchuu juwaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsejturen Herodías naake' tuten tsa tsandyantsuren, rei ya' nakayanu malu manchañu ya' balen chachillanu bain, naa suutadu amalanu bain, naa Galileasha chumu kayu bale chachillanu bain demikake' panda fikaantsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tsenñu tsangue' panda findetsuñu, Herodías' na'ma vi' junu panda fimula' ajuusha beelanguemi. Tsai' beelanguiñu rei yuj sundyami, naa yaba bulu chudi' panda fimula bain yuj sundyala. Tsai' sundyatu rei juntsa na'manu tsandimi: Ñu ti mujñuba inu pa'ka, tsenmala iya kuwanu tsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tsejtu Diosnu paka' uwain tsanguenbera kenu tsuyu ti': Ñu ti pa'ñuba kuwanu tsuyu, titu, in chachillanu ma tsandaaya washkenu tirenu tsuyu, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsandiñu juntsa na'ma junu malu' miitu ya' amanu, ¿Tyee pa'nu juwa? tita jimi. Tsenñu ya' ama tsandikami: Juan Mungaamu' mishpukaa pa'de, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsandiñu juntsa na'ma rei' junga te' mijiitu tsandimi: Juan Mungaamu' mishpukaa challaren palatunu puu kuwasa tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tsandiñu rei yuj llakindyami; tsejturen, ya' mikañu jamu chachilla' ajuunuren, Diosnu paka' tsanguenbera kenu tsuyu ti' mityaa, naati' tsanguen jutyuyu tin tsaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tsa' mitya ma suutadunu jeke Juan' mishpuka taade ti' eemi. Tsenñu juntsa suutadu peesusha ji' Juannu mishu daaka' ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma palatunu puu taji' juntsa pannanu kuwami, tsenñu ya' amanu kuwami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juntsaiñu Juan' disipulula kuinda demijatu junga ji' Juan' ujkun bulu manga' menjila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús' mitya kuinda kenu lara' eramu rukula Jesúsba demawa'dijitu, titi dekes ne' bain, tyee demijakares ne' bain wainla. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tsenñu Jesús yalanu tsandimi: Muba bulla kennatyuinsha mi'ke' jayu lekanu jidaa, timi. Matyu yala nuka dejiñu bain chachilla bendala sureita ne' naa pandaba fikaanu kityu juju deeñu' mityaa, Jesús tsandimi ya' disipululanu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsandi' mitya Jesús ya' disipululaba kaa baakunu vi' yai tene juu muba bulla kennatyuinsha jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tsa-i' jindetsu pure' chachilla keenatu keengala, tsejtu nuka pebulu' chulla bain delu' jei dejitu, yala' jinu tenasha yalaa ajke' ji' keenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús ya' jinu baakusha pu' tusha lutu, chachilla tsamantsadena katatu yuj tenbityami, matyu uvejaaba deju' washkes neneimu ruku miyajtu juuñu deeñu' mitya. Tsejtu ti bain pure' mijakaakemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jesús tsanguentsuren yumaa dekependu' kakentsuñu, ya' disipulula Jesúsnu kalen jitu tsandila: Entsa tenaa tiba den chutyuin tenanuren yumaa ma kepeindetsuyu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tsa' mitya kumuinchi entsa chachillanu deme-eenu kide, tsenmala yala endaa kalen chunu yatala deji', tsaityu' bain kalen chun pebulutalaaba deji' tiiñuba ka' finudetsu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tsenñu Jesús tsandimi: Ñullaa yalanu panda kuwadei, timi. Tsenñu yala tsandila: ¿Tsen naa ketaa lala yalanu millangue fikaanbera pan kanu dejuwa? Entsa panda fikaraya, ma añu tingumake taawasha kikeñuu balenu juve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tsenñu Jesús tsandimi: ¿Nan pan detanayu? Ji' keekidei, timi. Tsandiñu yala ji' keetu: Pan manda, alla pallu tadenayu, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsa detiñu kumuinchi chachillanu jayu jayu debuute' lushkatata ishtapetala dechudikaadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tsenñu 100 chachi buudi' chudina' bain, 50 chachi buudi' chudina' bain tsa tsaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tsenñu Jesús ya' tyaapachi pan bain manda ka', alla bain pallu kakitu, kai'sha ke'laadi' Diosnu yuj urave titu, pan dedaaka' ya' disipululanu kuwami, kumuinchi chachillanu veenudetsu. Tsejtu allanu bain tsarenguemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsenñu kumuinchi chachilla tyubanbera fila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tsejtu naa pan llujpe laramula bain, naa alla llujpe laramula bain mande'katu, 12 kubi ma seranguila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tsaaren junu panda fimula unbee rukulan juuren 5.000 ma juula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsangue' depuitu Jesús ya' disipululanu baakusha dema-eepumi juntsa pusu bejkusha Betsaida pebulu pi keesha yalaa ajke' demanbuisa tyatu; tsaindetsuren yaa junu wa'namu chachillanu deme-eren pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tsangue' chachillanu deme-ere' dyatu kuyisha Diosba kuinda kenu jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsejtu yumaa dekependu'kanu uwatala, ya' disipulula' miinu baakuya yumaa juntsa pusu pi kejtala miintsun, Jesúsya tusha shuwa' maali pumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tsanatu Jesús ya' disipulula miindetsu ishuwa masmi' juyintsuñu, yanmula yuj taaju' kendetsuñuba kata-eemi. Tsejtu dechanusha Jesús pi jandalaren sake' yala' junga miji' tsaa ne dapullanchi iintsuñuimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tsenñu ya' disipulula pinu ma neintsu dekata-eetu, ujmaaba tsaintsumee tya' dewatitila, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yala katandene kideke' dewapana' mitya. Tsenñu Jesús yalanu jeti entsandi-eemi: Puluke pensanguidei, iyaa tsaintsuyu. Jeetyatyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsejtu Jesús tsa-i' baakusha maviñu, ishuwa mandyami. Tsenñu ya' disipululaya yuj keenbashintsula, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","matyu yalaa naake' aseetanguen tsa deju', kaspele bain pan jayun juunuren tsamantsangue seewaañuba aseetanguindetyu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Juntsa-i' aa pusu bejkusha detyakatu Genesaret tushaa tyuinajila, tsejtu yala' baaku deteetsure' lula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tsenñu nei'ba tusha delunmalan chachilla Jesúsnu mangueengala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tsejtu Jesús nuka puve detiñu mija' bain kumuinchi jundaa chumu chachillaya Jesús' puinsha, dilulanu wandunu tsuu taji tajiila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tsejtu nuka Jesús jiiñu bain, naa kaa pebulusha jiiñu bain, naa aa pebulusha jiiñu bain, naa jeenbaatala jiiñu bain miñutala dilulanu taji' tsutsungaala. Tsejtu Jesúsnu ka naa jai kapanuuñuba ta'kakutide ti' u'ta u'tandila. Tsanditu naajula bain ta'kamulaya ura' mandiya mandiyaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseo chachilla, leichi mashturulaba Jerusalénsha pu' jitu, Jesús' junga kalen jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsejtu Jesús' disipulula mantsala panda ka' fifikendetsu keenatu, ura' dekityuve ti' pala, yalaya kayu panda fi'mujchin yala' leichiya naake tyaapa manbitsaanuu juñuba tsa deki'ñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Matyu fariseo chachillaya naa kumuinchi judíola bain, yala' tinbu rukula tyeenguemuwa deeñu bain, yai bain tsaren kendetsu' mityaa; naake tyaapa ura' manbitsaanuu juñuba tsangui'mujchiya panda fityu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tsenmin naa tyeeba ati'kakenu bui atinsha ji' majai' bain, naake tyaapa manbitsaanu juñuba tsangue tyaapa manbitsaatyumujchiya panda fityu jujuula. Tsenmin tinbunu ya' aa-apala tyee kayu vera juu kemuwa deeñu bain yai bain tsa tsangue', naa basu juula bain, naa pi pukenuu juula bain, naa tiba pukenuu jeru basu juula bain, naa tsudi' panda fikenuu juulanu bain naake manbitsaanu juñuba tsanguemu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsanguemu de' mityaa, fariseo chachilla, leichi mashturulaba Jesúsnu pake'meetu: ¿Nenñu den ñu' disipululaya lala' tinbu rukula naakemuwa deeñu bain juntsanguityu deju' naa-uwanu panda finundiyandu bain tyaapa manbitsaatyumujchin panda fifikitu deken? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tsenñu Jesús yalanu tsandimi: Mikan Diosa' mitya pamu Isaías, ura' pamuwaañuve, ñulla tsa jutyuren tsaañungue keewaamu chachillanu laapu' patu, yaa entsangue piikemuwaave: Entsa chachilla yala' fi'pakichiya inu balengurendu bain, yala' tenbukashaya inu pensaba jutyularen tsa tsa dekive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tsenmin tsangui'ñuba uraanun inu aawa kure' keewaawaadekive, matyu yala' mijakaraya chachilla naa naakidei tiñuba juntsanun ne mijakaakendetsu' mitya, ti' pillave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Matyu ñullaya tinbu chachilla tyeenguen chumuwa deeñuba juntsanun aa keetadi' jiinchin Dios naa naakidei tiñuba juntsanuya manbashi deiñuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tsejtu kayu entsa bain tsandimi: Ñullaya tinbu rukula naaken chumuwa deeñuba tsangues jinu tyanchiren Dios naa naakidei tiñuba juntsanuya pashanchi judeeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Matyu Moisés entsandimuwaave: Ñu' apanu bain, ñu' amanu bain balengure' ura' keewaade, tsenmin, Mun ñu' apanu bain, tsa jutyu'ba, ñu' amanu inchi firu' isa ti' bain tutanbera isa, timuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tsaanuren ñullaya, ma unbere ya' apanu bain, naa ya' amanu bain, entsandinuu bain juve timu deeve: Naake' ñullanu tiiñuba kuwa' ura' kemishtin tsaayu, matyu kumuinchi iya ti ta' bain tsaa Diosnu tene dekuwakiyu, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tsenmin mun tsandiñu bain, ñullaa entsandimu deeve: Ñuya juntsandi' mitya, tsanguendyai'shu juntsaa, ñu' apalanu tyeeba kuwa' ura' kivetekenuu jutyuve, timu deeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ñulla entsandimu de' mityaa, Diosa' uudennuya tiba jutyungue tiremu deju', tinbu rukula tyeenguen chumuwa deeñu bain juntsaaya mijakares jijiindetsuve. Tsenmin kayu vera juntsa keraala bain aa kiidekive, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tsanditu bene Jesús chachillanu demikaketu tsandimi: Kumuinchi meedi' aseetanguidei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fi'pa' juusha ti vi-i' bain juntsaya chachillanu Dioschi urajtu juu tiretyuve, tsaaren tyee fi'pa' juusha la-i' bain juntsaya Dioschi urajtu tiremuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsejtu bene Jesús chachillanu ba'ke' miji' yasha maviñu ya' disipulula, juntsa laapu' kuinda ketu tyee mijakare' tsandiñuba mijanu pake'meela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tsenñu Jesús yalanu tsandimi: ¿Tsejtu naa ñui bain aseetanguindetyuu? ¿Ti bain avindala pu' ajkasha vimuya chachillanu Dioschi urajtu tiretyuñuba jaiba aseetangui'tu deeyu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Matyu tiba avindala pu' vimuya tenbukasha vi'mujchi peshusha ne ji-i', bene avindala manguelaraimu' mitya, juntsaya chachillanu Dioschi firu' tiretyuve, timi. Tsejtu Jesús tsandimiya, kumuinchi tiba famuya urandene judeeve titaa tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tsejtu entsa bain tsandimi: Tsaaren tyee cha' pensasha fale'ba juntsaya chachillanu Dioschi urajtu tiremuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Matyu cha' tenbukashaa urajtu pensa faamuve: naa na'baasa tsa tsainu pensa bain, naa taanguenu pensa bain, naa cha' tu'nu pensa bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naa vee matsainu pensa bain, naa tiba aa tadichi tyanu pensa bain, naa firu' kiikenu pensa bain, naa anbukuinda keranguikaanu pensa bain, naa tituba kes nenu ajchuu pensa bain, naa veelanu kishtyan chunu pensa bain, naa na'baasa kentsure' panu pensa bain, naa firu' uukapu' dajpanu pensa bain, tsenmin naa ti kenduba pensangue' kityu pensa bain faamuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tsa' mitya kumuinchi entsaa urajtu jumulaa cha' pensa tainsha defale', chachillanu Dioschi urajtu tiremu deeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús junu malu' miitu Tiro pebulu bain, naa Sidón pebulu bain chunu tusha jimi. Tsejtu ma yanu vijitu, muba mijaindetyu dus punachi tyaturen, naa-i' pantsudin tsaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tsenñu junu ma shinbu ya' na'ma Dioschi urajtu kuraa tiremu bu'chulla puunu miyaa jumu wajtunun naa Jesús junu puñuba kuinda mija' mitya, Jesús' junga ji' ya' neepasha telenajimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tsaaren juntsa shinbu judío chachi jutyumi, ura pañuya, Sirofenicia cha' bulu paande shinbumi. Tsejtu juntsa shinbu Jesúsnu u'tandita ji', tsantsaya ya' na'manu dyabulu pumu me-e'laade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsenñu Jesús laapu' patu tsandimi: Kayu keenade, judío chachillanaa ajke' la'kanu tsuyu. Judío chachi jutyulanuya naake' ajke' la'kan tsaayu. Ñunu ajke' la'kashu juntsaa, kaillanu pan chi'ke' kuchalanu juntsa pan kuwakiñuuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tsenñu juntsa shinbu tsandikami: Tsaave, Bale Ruku, tsaaren naa tsaañu bain, kuchala bain kailla pan llujpe panda finu panbeesha depajtenmalaya fimu deeve, tikami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tsandi pakañu Jesús tsandimi: Ñu aantsandi ura' paka' mitya, tiba jutyu miide, ñu' na'manu pumu dyabulu yumaa malu' miive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsenñu juntsa shinbu ya' yasha miitu, ya' na'manu tsunjuusha tsuna mangatajimi, tsenñu yumaa dyabulu malu' miiñumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro tusha malu' miitu, Sidón tusha pulla', naa Decápolis tusha chumu pebulutala bain dedapullaitu Galilea pususha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tsenñu ya' puinsha, main pungui putyu, naa ura' pabaindityu rukunu tajila, tsejtu: Tsantsaya ñu' tyaapachi ta'kade, ti' u'tandita jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsa deiñu Jesús juntsa rukunu kake', chachillanu vela' ji-i', juntsa ruku' punguisha ya' tyamishuchi ta'pukitu, ñijkashaya ya' inbi mai'tekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsejtu selusha ke'laadi', aa ishi ketu juntsa rukunu tsandimi: Efatá, timi, tsandishu juntsaa: “Jurudide”, titu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tsandinmalan juntsa ruku' pungui narake meemu tiya', naa ya' ñijka bain dedeeshiñaaren narati ura' pamu tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús tsanguitu kumuinchi junu wa'namu chachillanu, tyee iñuba naa munu bain kuinda kityudei, timi. Tsandiñuren yalaa, Jesús waintyudei ti' panmalaa kayu veelanu wandi wanditila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tsejtu mika keenbashi' naaken tsa tsandyatu entsa entsandila: Tiba uraa tene kiikive entsa ruku. ¡Naa pungui putyu deeñu bain mameeware'kera, papatyu deeñu bain manbakare'kera kerakive! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Manen ma malu chachilla pure' mawakudedi', ti fin tsaa ma pudenañu, Jesús ya' disipululanu mikatu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Entsa chachilla enu iba yumaa pen malu depu', tiba fikenuu detanatyuñu yalanu yuj tenbitenve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tsaju' yala panda fajdetunuren iya yalanu yasha deme-eeshu juntsaa, mindalaaba dedesmee-inu dejuve, mantsalaya baasha chullan ja' depu' mitya, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tsenñu ya' disipulula pakatu: ¿Tsen engu tiba den chutyuin tenashaba nuka pan kataa entsa chachillanu fikaanu dejuwa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tsa detiñu Jesús pake'meetu: ¿Ñulla nan pan detanayu? timi. Tsenñu yala: Mandishpai pan juuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsenñu Jesús, chachillanu tutala dechudei titu, mandishpai pan ka' Diosnu yuj urave titu, pan dedaaka' ya' disipululanu kuwami, veenudetsu. Tsenñu yalaa kumuinchi junu wa'namu chachillanu veles nela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naa alla bain jayu detanañu, Jesús juntsa' mitya bain Diosnu yuj urave titu, bene deveekaami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsenñu kumuinchi chachilla tyubanbera defiñu laramu mande'katuren mandishpai pishkali jungue mande'kala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsenñu panda fimula mika 4.000 chachillaa ma juula. Tsejtu bene Jesús chachillanu deme-eetu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ya' disipululaba kaa baakusha demavi' Dalmanuta tusha jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseola Jesús' junga deji' kuinda ketu veta' veta' depatila. Tsejtu Jesúsnu tyeeba ke' kuipa lainuu kisa tyanchiren, uwain Dioschi era' jamutuya, Diosyaa tsanguekaantsuve tyainuu jumu yalanu main ke' keewaaka, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tsa detiñu Jesús aa ishi ke' patu tsandimi: ¿Nenñaa entsa chachilla Diosyaa tsanguekaantsuve tyainuu jumu ke' keewaaka titu detin? Uwaindiyu entsa chachillanuya Diosyaa tsanguekaantsuve tyainuu jumu ke' keewara maliba jun jutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús tsandi' yalanu mashuike' miitu, baakusha mavi' pusu bejkusha miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tsai' miindu ya' disipulula tyeeba fikenuu jumu pashi' jideitu, pan mainren baakusha taa punala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tsenñu Jesús ya' disipululanu entsandi ule' pami: Pashkatyudei fariseola' pan pujkikaantsumi llujpepenu bain, naa Herodes' pan pujkikaantsumi llujpepenu bain, ti' ule' pami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tsenñu ya' disipulula yai tene pasai jindu, uwain pan tajindetyuñu' mityaa tsandive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsenñu Jesús mijatu tsandimi: ¿Nendetiyu tsandi' pan taakeetyuñuve ti' paviyaala? ¿Naa chai bain aseetanguindetyuu? ¿Ñulla' pensa naake' aseetanguen tsaa ma judejuu? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Kapuka pu' bain katanu dejutyuu? ¿Pungui pu' bain meenu dejutyuu? ¿Ñullanu jaiba mandejatyuu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","naa pan mandan juunuren, iya 5.000 chachillanu panda fikaamuwaañuba? Tsenñu ya' llujpeperen ¿nan kubi mande'kamuwa deeyu? timi. Tsenñu yala pakatu: 12 kubi, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tsenmala mandishpai pan jumunu 4.000 chachillanu deveeñuya, ¿nan kubi mande'kamuwa deeyu? mandimi. Tsenñu yala: Mandishpai kubi, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsa detiñu Jesús tsandimi: ¿Iyaa ura pan pujkikaamunu pai'mujchi, fariseola tyee mijakaamu deeñuba juntsanaa pantsuñuba chaiba aseetanguindetyuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús ya' disipululaba Betsaida pebulubi jiñu, ma ruku kapuka putyunu ta'la, tsejtu Jesúsnu tsantsaya tyaapachi ta'kade ti' u'tandila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tsenñu, Jesús kapu' putyu rukunu tyaapanu kake' pebulu kapasha miya' jiitu, kapukanu inbi munguike' ya' tyaapachi kapukanu ta'kakitu: ¿Tyeeba katawan? ti' pake'meemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tsenñu juntsa ruku jayu katandu tsandimi: Chachillanu katawave, tsaaren chi keraa ma nenedeive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsandiñu Jesús manen juntsa ruku' kapukanu ya' tyaapachi manda'kañu, umaa narake danware' ura' tiya', tinuba narake katamu tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsenñu Jesús juntsa rukunu ya' yasha me-eendu entsandimi: Pebulusha mavityude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Junu demalu' miitu, Jesús, ya' disipululaba, Cesarea Filipo pebulu keetala nenu jila. Tsai' jindu mindala Jesús ya' disipululanu pake'meetu: ¿Chachillaya inu, muve tiidetin? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tsandiñu yala tsandikala: Mantsalaya, ñunu Juan Mungaamu millave tiidetive, tsenmala veelaya Elíasve tiidetive, tsenmala vejanlaya kaspee tinbunu Diosa' mitya pamu rukula, main maatu iñuve tiidetive, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tsenñu Jesús tsandimi: ¿Tsen ñullaa inu muve detiyu? ti' manbake'meemi. Tsenñu Pedro pakatu: Ñuya Dioschi Mi'ke' Kayamuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsandiñu Jesús: Entsa kuinda munuba waintyudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús umaa wandi' mijakaatu, Chachi Tiya' Nakayamu pure' taaju i' pullainuuya juve. Tsejtu naa judíola' bale rukulachi bain, naa chachilla' mitya Diosnu kalen jimula' bale chachillachi bain, naa Moisés' wandya lei mashturulachi bain, Chachi Tiya' Nakayamu mutyan kerai'nu tsuve. Tsejtu tu'nu detsuve, tsenñuren pen malu insha mangujtanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús tsandi' ura' aseetanguikare' pañu, Jesúsnu Pedro vee mujtu miya' jiitu: ¿Nenñundiyu tsandimi? ti', Jesúsnu nepami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tsandiñu Jesús ya' disipulula' junga mangue-eetu Pedronu entsandi nepami: ¡Inu vela' mijiide, Satanás! Ñuya Dios naake pensangue' keemuñuba juntsanguityu', chachilla naake pensangue' keemu deeñuba juntsangue pensanguemuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tsejtu bene Jesús chachillanu bain, ya' disipululanu bain, ya' junga demikatu tsandimi: Mun in bendaa janu tenñuba maali balenguutyu', in mitya tuta'ba tutainuu juu, tu'vinu kuusa nanakiñungue', in bendaa janu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Matyu mun ya' chungama maali balengurenu tyashu juntsaa uwain naa-uwanuba tsana chuntsumi katan jutyuve; tsaaren in mitya bain, naa Diosa' mika ura kuinda' mitya bain ya' chungama maali balenguutyushu juntsaa naa-uwanuba tsana chuntsumi katanu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Matyu ¿tyee balenu jun, mu bain entsa tusha tiba detaditun, naa-uwanuba tsana chun jutyuu jushu juntsaa? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tsenmin, ¿tyee paanguitaa chunuu junu jun? ");
INSERT INTO cbiNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Matyu mun in mitya bain, naa entsa livee inu kuinda' mitya bain, Diosnu keenguindandaa ujcha lamu entsa chachilla' ajuusha deyujtyañuba, tsaren Chachi Tiya' Nakayamu bain ya' Apa' tiba tsamantsaa jumuchi maatu, tsenmin Dioschin juu anjeela' kejtsapala puu maatu, ya bain ya' mitya yujtyanu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tsejtu Jesús entsa bain tsandimi: Uwaindiyu mantsa enu pumu chachilla Dios rei juu tsamantsa pude tiyantsu katai'mujchiya peyan dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bene mandishmain malu puiñu, Jesús, Pedronu bain, Santiagonu bain, Juannu bain mikake', vee mujtu ma aa kuyisha miya' luimi. Tsejtu yala dekeenaren tsaa Jesús vera' lanchi iimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ya' jaliya pajta lu'puñu chakala' ken tsangue' fibaba tene iimi, tsaitu entsa tushaya muba naamika manbipu' bain, tsangue fiba' tiwaan jutyui fiba' tiyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tsaiñu kaspee tinbunu chumu rukula Elías bain, Moisés bain Jesúsba kuinda kendu' katawala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsenñu Pedro, Jesúsnu tsandimi: ¡Mashturu! enu ura' pukeeñuve. Tsa' mitya lala pen kaa yapaya kenu detsuyu, ñuchi main, Moiséschi main, Elíaschi bain main, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yala wapanandene judeju' ti pan tsandya' mityaa, Pedro tsandimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsenñu juntsa uwanu ma ñivish bulu paja' yalanu dishukijañu, juntsa ñivish bulusha palaa main meejatu tsandimi: Entsaa in estyanu Nave; yanu meedidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsenñu juntsa uwanu yala' junga mangue-eetu, veelanuya mangatai'mujchi Jesúsnun maali uyuna mangataakila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsejtu kuyisha pu' mavijandu, Jesús ya' disipululanu: Tyee i' puiñu dekata'ba kayu Chachi Tiya' Nakayamu peya' mangujtaindyuya, munuba kuinda kityudei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tsandiñu' mitya yaitala: ¿Tsen naa titundin, “peyaturen mangujtanmala” timi? ti' papatindun, munuba waintyu' yaitalaren mii shuwaila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bene Jesúsnu entsandi pake'meela: ¿Nenñaa Moisés' wandya lei mashturulaya, Dioschi Mi'ke' Kayamu kayu jaindyuren, Elíasya ajke' maanu juve tiidetin? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tsa detiñu Jesús tsandimi: Uwain tsaave. Elíasya ajke' maanu tsuve, tsejtu yaa tiba ura' demannu tsuve. ¿Tsaaren Diosa' Kiikanu, Chachi Tiya' Nakayamunu laapu' patu naa tinga? Entsandive: pure' taaju i' pullainu tsuve, naa tyuten dekeraa bain inu tsuve, tive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tsaaren iyaa yumaa Elías maave tinu tsuyu. Tsenñu ya maañu yanu naakenu dejuve ti' pillañuba juntsaa deke' naakenu tya'ba tsa dekive, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kuyisha pu' demavija' vejan disipulula' wa'nainbi demiitu, chachilla pure' wakudena' yalanu yatana de-uina katajila. Tsenñu leichi mashturula bain mantsa deputu, disipululaba veta' veta' pantsula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsenñu kumuinchi chachilla Jesúsnu katalan wapanbashii deshuwa', ya' junga jei deji': ¿Ura chuyu? tita, jila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tsenñu Jesús yalanu pake'meetu: ¿Ti' mityaa veta' veta' pandu detin? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsenñu junu wa'namu chachi main pakatu tsandimi: Mashturu, in kaananu main firu' bu'chulla punatu tsaa papatyungue tireñu ñu' junga taayu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Entsa kaananu nuka neintsu juntsa firu' bu'chulla firu' manguike' bain, tusha tya'pukare' tsaa fi'pakisha chinbijpu delaakaake', naa tejkuba depakaakena' bain tsa tsanguikare', tsaa dentsutetee jullujtu tsutsungaave. Tsenñu ñu' disipululanu: Tsantsaya juntsa firu' bu'chullanu me-e'laadei, tiñun tsa deeve, me-e'laanu jui'la, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tsenñu Jesús tsandimi: ¡Keranguityu chachilla! ¿Naama jina ñuiba tsananujtuuwa? ¿Naama jina iya ñullanu puulan chunujtuuwa? titu: Juntsa kaananu engu taadei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsandiñu juntsa kaananu ya' ajuusha ta'la. Tsenñu juntsa firu' bu'chulla Jesúsnu kataakemiren, kaananu defiru' pi'shikaaketu, tusha tya'pukaake', fi'pakisha chinbijpunbee lu'teken tsunguekaantsumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tsenñu Jesús juntsa kaana' apanu pake'meetu: ¿Nan tinbu intsun entsaa i-iiñu? timi. Tsandiñu ya' apa pakatu: Kayiimalaren tsaimuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tsenmin pure' bijee juntsa firu' bu'chulla, naa ñinbaasha bain, naa pisha bain tya'pukaamuve tu'nu tyatu. Tsa' mitya tyeebanguenuutuya, lalanu tenbitya' tsantsaya la'kave'ka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tsenñu Jesús tsandimi: ¿Nejtaa, “Tyeebanguenuutuya”, titundiyu? Kumuinchi ura' keenguemulachiya, Diosya tiba dekenuu juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsenñu juntsa kaana' ya' apa entsandi daran pami: ¡Iya keenguiyu! Tsaaren inu kayu keenguikaaka, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsenñu kayu chachilla ne wakudijandetsuñu, Dioschi urajtu kuraa tiremu bu'chullanu Jesús entsandi ajaa timi: Papatyungue shuike', naa pungui bain putyungue shuikemu bu'chulla, entsa kaananu malu' miji', naa-uwanuba mavityude tintsuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsandiñu juntsa bu'chulla wati', kaananu desmee ma-iwaake' malu' miiñu, juiki'mujchi pemu tsun tsaimi. Tsenñu junu keenamu chachilla: Uwain umaa peyañuve, tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tsenñuren, Jesús tyaapanu kake' mangujteñu, juntsa kaana mangujpa' uidimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bene Jesús yasha maviñu ya' disipululan juu Jesúsnu pake'meetu: ¿Nejtaa lalaya juntsa firu' bu'chullanu me-e'laatyutu deewa? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tsenñu Jesús tsandimi: Entsa bu'chullalanuya, Diosba kuinda ketindun me-e'laakenuu judeeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Junu demalu' miitu, Galilea tusha depulla' miila. Tsejturen muba demijatyusa tyami Jesús, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","matyu ya' disipululanu mijakares miintsu' mitya. Tsejtu entsa entsandimi: Chachi Tiya' Nakayamu, chachilla' tyaapasha kuwanu tsuve, tsenmala yala tu'nu detsuve. Tsenñuren pen malu insha mangujnu tsuve, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tsa tsandiñun tyeendi' tsandiñuba ya' disipulula aseetanguityu jula, tsejtu pake'meenu tyatun, jeetyatu pake'meetyu jujuula. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cafarnaúm pebulusha demiji' ya juusha demavitu, Jesús ya' disipululanu pake'meemi: ¿Ñulla mindala maandu tyee ñui tene pasai maatu deiyu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tsandiñuren muba pakai'la, matyu yalaa, yaitala maa kayu baleñanga ti' mindala pasai demaja' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsa deeñu Jesús chudi', juntsa 12 jumulanu demikatu tsandimi: Mun, kayu aa bale chachi junu tya' bain, balejtuyu pensangue', vejanlachi taawasha kemu chachee junu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsanditu bene Jesús ma kaananu ka', ya' disipulula' kejtsapala uikaake', ya' tyaapachi amanguitu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Mun in mitya, entsa kaana juuñuulanu mika' bain inaa mikantsuve, tsenmin mun inu mikake' bain, maa inu entsa tusha eeñuba juntsa rukunaa mikantsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan tsandimi: Mashturu, lalaya ma ruku, ñu' mitya ti' dyabulu me-e'laalaakentsu dekatayu, tsaaren laaba bulu nemu jutyuñu' mitya: Tsa mantyude, ti' depayu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsenñu Jesús tsandimi: Tsanguityude ti' patyudei; mun tiba tsamantsaa ke' keewara juu in mitya ke' keewaake' bain bene inu firu' patinuuya dejutyuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Matyu mun lalanu kundaa kityulaya, laaba buunataa tsaanu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tsenmin mun ñulla Dioschi Mi'ke' Kayamu' chachi dejuñu' mityaa ma basu pi juuñuba dekuwashu juntsaa, uwaindiyu tsanguen mitya bene tyeeba uraa kanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mun, inu keranguemu kailla juuñuu chachillanu ujcha delawaashu juntsaa, matyu ujcha lawaanuu jumu tsanguindyuren ili ilikenu aa shupuka kutunu teevi' lamaasha keviiñaa yachi kayu uraaba junu juve. Matyu tsangue' ujcha lawaamu chachillaya ili ilikenu aa shupuka kutunu teevi' lamaasha kevi' pipimulanuba pullake taaju kenu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tsandenna ñu' tyaapa' mityaa ujcha lalaishu juntsaa, daakakide; mandyaapa putyuuya naa-uwanuba Diosba ura' chuinsha viiñu kayu uranu juve, matyu naa-uwanuba ñi jelekenu ke' manbetyuinsha pai tyaapa puuya keviinu ju'ba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tsenmin ñu' neepa' mityaa ujcha lalaishu juntsaa, daakakide; ma neepa puuya naa-uwanuba Diosba ura' chuinsha viñu kayu uranu juve, tsaa pai neepa puuya ñi jelekenu kensha keviinu ju'ba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Tsenmin ñu' kapuka' mityaa ujcha lalaishu juntsaa, kala' kepude, ma kapuka puuya, Diosnu ya' rei juu tananu kayu uranu juve; tsaa pai kapuka puuya naa-uwanuba mallu bain peyatyuinsha, tsenmin naa ñi bain jelekenu ke' manbeyatyuinsha keviinu ju'ba. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Matyu uwaindiyu, naajulaba ñichi tene Dioschi ura' kuraa tiyanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tyayuya urave, tsaaren tyayu pijtu tiyashu juntsaa, ¿naa keñaa pi' mandiyanuu jun? Ñui bain tyayu juuñuu ura judei, tsaju' muba ñuitala tiba bulla jutyu ura' chudei, timi Jesús. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús Cafarnaúm pebulunu malu' Judea tusha miji', naa pajta lanu Jordán pasha bain miimi. Tsenñu junga bain chachilla pure' wakudediñu, yalanu mamijakaami, matyu naa-uwanuba tsai' dewa'dinmala ya tsa tsanguemu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsejtu tsanguentsun mantsa fariseola Jesús' junga kalen jitu, naati vera' pakakare' kuipa pun tsandyanchin entsandila: ¿Ma ruku ya' shinbunu mavelanuu jun? ti' pake'meela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsenñu Jesús tsandimi: ¿Tsen Moisésya ñullanu tyee kidei tin? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tsenñu yala tsandila: Moisésya, ma ruku ya' shinbunu mavelayu ti' keengaya kiika piikishu juntsaa mavelanuu tiremuwaave, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsenñu Jesús tsandimi: Moisés tsangue lei piikemiya ñulla pañu meetyu chachi deeñu' mityaa tsanguive. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tsaaren Dios entsa tusha ajke' chachi dekenu tinbunuya, unbee ruku bain, supu bain kikemuwaave. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tsa' mityaa unbee rukuya ya' apanu bain, ya' amanu bain shuike' ji', ya' shinbuba buudi' chunu juve, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tsai' yala main juuñuu tiyainu detsuve, timuwaave. Tsenmee yala pai chachi juuñuu dejutyu' main juunu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tsa' mitya Dioschiren tsaa ma buuta' chujtyaabillaya, mu bain maveenu dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yasha demiji' machutu ya' disipulula juntsa kuindanun manbake'meela. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tsenñu Jesús tsandimi: Mun ya' shinbunu mavela' vee shinbuba machushu juntsaa, vee matsa-i' ya' ajke' shinbunu ujcha lantsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsenmala ma shinbu bain ya' rukunu mavela' miji' vee rukuba machushu juntsaa, vee matsaintsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mantsa kaillanu Jesús ta'kasa tyatu, ya' ajuusha tajila. Tsaindetsu ya' disipulula katatu, kaillanu tajimulanu ajaa tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tsenñu Jesús kata' ajaa titu tsandimi: Kailla in junga janudetsu, daatadityudei, matyu Diosnu yala' rei juu tanamulaya entsa kailla tsaalaa dejuñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Uwaindiyu, mun Diosnu rei juu kure' kailla tsaa yanu meenguemu jui'shu juntsaa, naa-uwanuba Diosnu yala' rei juu tanan dejutyuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsejtu Jesús tsanditu, kaillanu deka' angue' tyaapachi deta'ka', Dioschi ura' de-isa timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús yumaa malu' miinundiyantsu, ma ruku yangachi ji-i' ya' ajuusha teleditu entsandi pake'meemi: Ura ruku mashturu, ¿naa kenu juwa naa-uwanuba Diosba ura' chunuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tsenñu Jesús tsandimi: ¿Nenñundiyu inu, “ura rukui”, timi? Ura jumiya, Diosren main ura ruku juuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dios naa naakidei tiñuba ñu mive: chachiitala tu'tyude; vee matsaityude; taanguetyude; anbuti' veelanu kuipa putyude; anbuti' chi'kityude; naa ñu' apanu bain, ñu' amanu bain balengure' ura' keewaren chude, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tsenñu juntsa ruku tsandimi: Mashturu, iya kaa musuumalaren kumuinchi juntsa demeenguen chumuyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tsenñu Jesús juntsa rukunu tenbitya' keetu tsandimi: Tsaaren chaiba ñuchi main tyeeba kenuu juve: miji' ñu ti ta'ba millangue de-ati', juntsa lushi purelanu veede. Tsanguishu juntsaa, ñu selusha tsamantsa balen juu tadinu tsuve. Tsangue' maatu inu keengue' in bendala jade, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesús tsandiñu, juntsa ruku mika taruku' mitya, yuj llakindya' miimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsenñu Jesús ya' keetala dekere' yatetu, ya' disipululanu tsandimi: Tarukulachiya Diosnu yala' rei juu tananu mika li'pu' juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tsandiñu ya' disipulula mere' yuj demeenbashñu Jesús tsa mandimi: In kailla, Diosnu rei juu tananu mika li'puve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Main tarukuchi Diosnu ya' rei juu tananu mika li'punchiren, ma kameyu ityu kapukanu pullainuuba juñuya, juntsa kameyu kayu ura' ne dapullaichuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsandiñu ya' disipulula kayu demeenbashtu yaitala entsa entsandila: Tsaashu juntsaa, ¿maa livee inuu juchunga? tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tsa detiñu Jesús yalanu ke-erai shuwatu tsandimi: Uwain tsaave, chachillaya livee inu ti kike'ba tsainu dejutyuve, tsaaren Dioschiya tsa jutyuve, yachiya tiba imu tene judeeve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsandiñu Jesúsnu Pedro tsandimi: Lalaya ti taawa deju' bain millangue deshuike' ñu' bendaa jamu deeyu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tsenñu Jesús tsandimi: Uwaindiyu mun in mityaren, naa Diosa' mika ura kuinda' mitya bain; ya' ya shuikike, ya' naatalalanu shuikike, ya' amanu shuikike, ya' apanu shuikike, ya' kaillanu shuikike, ya' tu shuikike' bain, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","juntsa tsanguemula entsa tunu chumujchiren tsaandene 100 bijee yapa manganu detsuve, naa ya juuñu bain, naatala judeeñu bain, ama juula bain, na juula bain, naa tu juuñu bain tsa tsangue manganu detsuve, naa firu' kenu suraa deneñu taaju de-i' bain. Tsejtu kayu ajkeshaya naa-uwanuba Diosba ura' chunuuya junu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Challa pure' chachilla balen chachi judeeshu juntsalaa, bene ne chachi juu mandinu detsuve, tsenmala challa pure' chachilla ne chachi judeeshu juntsalaa bene balen chachi juu mandinu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalénsha jindu, Jesúsya ya' disipulula' ajkesha puu jintsumi. Tsenñu ya' disipulula dekeenbashi' wapanaa jiintsula, naa veela ya' bendaa jimula bain jeetyantsula. Tsenñu Jesús manen ya' 12 disipululanu vee mujtu vela' mamikakitu, tyee inuu ju' bain yalanu mawaintu tsandimi: ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ñulla mideeve, naa challa Jerusalénsha jindu bain. Chachi Tiya' Nakayamu juntsa pebulunu chachilla' mitya Diosnu kalen jimu bale rukula' tyaapasha bain, naa leichi mashturula' tyaapasha bain kuwanu tsuve. Tsenmala yanu kavitu ke', tutainuu kuipa depu', judío chachi jutyulanu kuwanu detsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tsenmala yala firu' pa'kera, uukapu'kera, inbi kitsure'kera, debanvili'kerakenu detsuve, tsenmin tu'nu detsuve. Tsa dekiñuren pen malu insha Chachi Tiya' Nakayamu mangujnu tsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeo' nala, Santiago bain, Juan bain, Jesús' junga kalen jitu entsandila: Mashturu, lala ñunu tyee depa'ñuba juntsanguisa tenve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tsa detiñu Jesús tsandimi: ¿Ñulla' mitya tyee kenu juwa? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsenñu yala tsandila: Ñu' tsamantsaa uudenguen chuinsha, lalanu bain ñu' keesha bulu mandanguen chunu, mainnu urandyasha chujti', kamainnu jalandyasha chujtikisa tenve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsenñu Jesús tsandimi: Ñulla inu tyee pakendu'ba mijdetuve. Tsejtu ¿iya wajtun tsamantsa taaju ke' pullainu juuwashu juntsanu ñui bain tsangue' puinuu dejuu? ¿Tsenmin taaju kinchee mungaraiñuinu juuwashu juntsanu bain, ñui bain tsainuu dejuu? timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsenñu yala tsandila: Laa bain tsai' taaju i' pullanuu dejuyu, tila. Tsa detiñu Jesús tsandimi: Uwain ñulla iya naa-i taaju iñuba, ñui bain tsai' pulla'ba inu dejuve, tsenmin taaju kenchi mungaraiñuinu bain tsai' pulla'ba inu dejuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tsaaren ñulla urandyasha, ne jalandyasha chudinu pakidekishu juntsaya iyaa tsanguikaanuu jutyuyu, juntsaya munaa kuwa' chukaanuu juñuba Dioschin yumaa tsangue tira' uukaraa juve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tsenñu vejan paitya disipulula tsandiñu demeetu, Santiagonu bain, Juannu bain ajaatyala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsenñu Jesús yalanu demikatu tsandimi: Ñulla mideeve naajulaa judío jutyu bale chachi keengaya deju' bain, yaichi manda-imu chachillanu naake firu' kendya'ba tsanguen chumu deeñuba, tsenmin judío jutyu aa bale rukulaya, chachillanu menaa tyullaa tanamu deeñu bain mideeve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tsaaren ñuitalaa tsaanu dejutyuve. Tsa jutyu' mun ñuitala kayu bale tiyachi tenñuba, vejanlachi taawasha kemu chachee junu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tsenmala mun ñuitala balen chachi tiyachi tenñu bain, kumuinchilachi taawasha kemu chachi junu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Matyu naa-inga Chachi Tiya' Nakayamu bain entsa tusha jatu, ne yachi tiba ke', yanu dewashkisa tya' jatyumujchi, yaa muchiba tiba uraanuu ke' kuwanaa jashu, tsenmin pure' chachillanu la'kanu yaa tutanu jave, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericó pebulubi vijitu, Jesús ya' disipululaba malu' miintsu, kayu veela bain yanu pure' suree malu' miinu uwanu, main kapuka putyu ruku, lushi paken chuchunamu ruku Bartimeo, matyu Timeo' na, minguelunu chunatu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","naa Nazaretsha chumu Jesús junu puintsuñuba meetu, daran palaachi entsandimi: Jesús, Rei Davidnu sera' jamu Na, inu tenbityaka, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tsenñu pure' chachilla juntsa rukunu mandyasa ti' de-ajaatiñun, yaa kayu ne daran papati': Davidnu sera' jamu Na, inu tenbityaka, tiitimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsenñu Jesús uidikatu: Mikadei, timi. Tsandiñu kapu' putyu rukunu mikaitu: Sunden kujpade, ñunu mikantsuve, tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tsenñu kapuka putyu ruku ya' palanu vinamu jali tsungue tya'kemin, jei kujpatu Jesús' junga kalen jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tsenñu Jesús entsandi pake'meemi: ¿Ñu' mitya tyeenguisa tenguen? timi. Tsandiñu kapuka putyu ruku pakatu: Mashturu, katamu tiyanu tenve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tsenñu Jesús tsandimi: Miide, ñu uwain tsainu juyu tya' keengue' mityaa ura' mandiyave, timi. Tsandinmalan juntsa ruku jei katamu tiyami, tsejtu Jesús kayu ajkesha jintsuñu' mitya, ya bain bendaa jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yumaa Jerusalén kalenatu, Betfagé kaa pebulunu bain, Betania kaa pebulunu bain kalen jindu, Ulibu chi chunu kuyi keesha putu, Jesús ya' disipululanu pallu eemi ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","entsanditu: Lala' ajuusha katawaishu juntsa kaa pebulusha jidei, tsejtu junu vinusha, naa muba kayu chudi' kerajtunu buru kaana main teetsuraa uina katajinu detsuve. Tsejtu langa' taadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tsaaren tsandenna mulaa ñullanu: ¿Tyeenguenaa dekiyu? tinmalaya: Bale Ruku menesteve, tsaaren wajturen mangunu detsuyu, tidei, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsandiñu ya' disipulula jitu, ma kaa buru cha' neneinu miñunu, ya juukapanu teetsuna katajila, tsejtu langala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tsenñu jundaa pumu chachilla pake'meetu: ¿Tyeenguinaa buru langandetsuyu? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsenñu yalanu Jesús naati pakadei tiñuba juntsandi depakañu, tajikaala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tsejtu Jesús' junga buru deta'tu, yala' palanu viya viyakenu jali buru jandala delakaañu, Jesús lu' chumi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tsenñu pure' chachilla yala' jali tene Jesús' jinu miñunu lakaakaakila, tsenmala veelaya jeenbaatala chi ali deka' miñunu tsure tsurekila balengure' keewaatu. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tsejtu naa ajkesha jintsumula bain, naa benesha jimula bain entsandi utis jijiintsula: ¡Yuj sunden jusa! Bale Ruku' mitya jamuya mika ura' imuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lala' tinbu ruku rei David' Dios mika urave, yaa ya' chachillanu washke' uudenguen chunu ju' mitya. ¡Aa kai'sha chumu Dios yuj sunden jusa! tiitila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús Jerusalénsha vijitu aa eleshashaa jimi. Tsejtu juntsa aa eleshanu nukaba demi'dangue' dyatu, yumaa dekependu' kakentsuñu' mitya, ya' 12 disipululaba Betania pebulusha miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Juntsa ayunchi Betania pebulubi pu' malu' miindu Jesús panda mutyami. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tsejtu baatala main igu chi sunden awantsuñu' juu kata-eetu, kalen ji' keemi puka na'ba namee tyatu. Tsejturen inu tinbu jutyuñu' mitya, puka natyuñu, taperen kataakitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","juntsa igu chinu tsandimi: Mu bain ñunu imu puka naa-uwanuba demanga' fityusa, timi. Tsejtu tsandi' pañu ya' disipulula meenala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalénsha demaatu, Jesús aa elesha chunu veeta juusha mavimi. Tsai' mavitu junga ufeenda kuntsumi atin pumu chachillanu bain, naa junu ati'kan pumu chachillanu bain tsaa demajuka'laakemi, tsejtu naa lushi maveten chundala bain, naa paluma atin chundala bain tsaa debuityui eekemi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tsejtu munu bain juntsa aa elesha keetalaya ne tyeeba taaya pulla' nenu uudengui'mi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsejtu, bene entsandi mijakare' pami: Diosa' Kiikanu entsa pillave: In yaa, naaju chachilla bain Diosba kuinda kenu ya junu tsuve, ti' pillave. Tsaanuren ñullaya entsa yanu taamula' vi' pantsudinu tujuu tiredekiñuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Entsandiñu demeenatu, chachilla' mitya Diosnu kalen jimula' bale rukula bain, naa Moisés' wandya lei mashturula bain, Jesúsnu tu'nu pensanguitu yai tene paviikila, matyu kumuinchi chachillaya Jesús' mijakaañu kuindanu tene mera meradediñu naaken tsandya' jeetyandetsu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yumaa dekependu'kañu Jesús ya' disipulaba juntsa pebulunu malu' miila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ayunchi kepenene, puka natyu igu chi keetala manbuindu telelebi jii de-ejkee chuna katala. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsejtu nenñaa tsai' ejkeñuba, Pedro mandengatu Jesúsnu tsandimi: Mashturu, keekide, ñu Dioschi firu' isa ti' patisu juntsa igu chi tsaa ejkeiñuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tsenñu Jesús tsandimi: Diosnu ura' keengue' uwain tsaave tyadei. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Uwaindiyu mun entsa kuyinu: Aanu shilla' ji' tsaa lamaasha pajtyaide, ti' bain, ¿uwain tsaichunga? tyai'mujchi, naatiñuba tsainu tsuve tya' keenguishu juntsaa uwain tsainu tsuve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tsa' mityandiyu ñulla tyee Diosba kuinda ke' pake' bain, uwain yumaa kayu pensaa judei; tsangue pensanguishu juntsaa uwain kanu detsuve, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tsenmin Diosba kuinda kentsumiya ñu veelaba peletu juuba jushu juntsaa, yaiba veta' veta' ura' juu mandiyadei, tsenmalaa selusha kai'sha chumu ñulla' Apa bain ñulla' ujcha' mitya manbitsaanutsu, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsejtu bene Jerusalénsha demiji' Jesús aa elesha chunu veeta juusha nenu uwanu, chachilla' mitya Diosnu kalen jimula' bale rukula bain, Moisés' wandya lei mashturula bain, tsenmin judío bale rukula bain kalen jitu, ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","yanu entsandi pake'meela: ¿Ti' mityaa entsangues nentsuyu? ¿Maa ñunu aantsangues nekaantsun? tila. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Tsa detiñu Jesús tsandimi: ¿Maa Juannu ere' mungares nenu tireñanga? ¿Diosya tsanguiñanga? ¿Chachillaa tsa dekiñanga? Inu pakakai, tsenmalaa i bain ñullanu wainnu tsuyu, maa inu entsangues nekaantsuñu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsenñu yaitala veta' veta' paviikendu tsandila: Lala naati' Juanya Diosa' uudenchee tsangues nemuve tin tsa deeyu. Tsandishu juntsaa: ¿Nenñaa yanu keranguityuwa deeyu? tinu juve. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tsenmin naati' chachilla' uudenchee tsangues neve tin tsa deeyu, tiitila. Matyu tsandinu jeetyala, kumuinchi chachillaya Juanya uwain Diosa' mitya pamu rukuve tyamu deeñu' mitya. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsejtu Jesúsnu pakatu tsandila: Lalaya Juan mu' uudenchee tsaita nemuwaañuba mijdetuyu, tila. Tsa detiñu Jesús bain tsandimi: Tsaashu juntsaa, i bain ñullanu wandin jutyuyu, maa inu entsangues nekaantsuñu bain, timi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús kayu pa' jindu entsa tusha tyee imuñuba juntsaatala laapu' patu tsandimi: Ma bijee ma unbere uva vijtya kemi; tsejtu vijtya kelu kelu tsaa veeta ke' lu'tekemi, tsenmin binu ke' faawaanunu bain ke', naa vijpalanu washna' keekeenanu aa katyu ya bain main kemi, tsejtu taawasha kemu chachillanu medya washkare' vee mujtu lu' jimi. ");
INSERT INTO cbiNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsejtu uva pu' vijpaasha puka de-i' kanu tinbu jañu, ya' chachinu main eemi, yachi nan junuuñuba juntsa deme-eesa tyatu. ");
INSERT INTO 