﻿USE sofia;
DROP TABLE IF EXISTS sofia.cbcNT_vpl;
CREATE TABLE cbcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cbcNT_vpl WRITE;
INSERT INTO cbcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo ati yepapʉ cʉ̃ caátiãnajẽrẽ ati tutipʉ marĩ tʉ̃goroa. Mai, caãnijʉ̃goro cʉ̃ ñicʉ̃jãã ãnana wãmerĩrẽ mʉjãã quetibʉjʉgʉ yʉ átiya. Jesucristo pʉame David, bairi Abraham ãnacʉ̃ pãrãmi majũ caãnacʉ̃ ãmi. Atore bairo ãñupã: ");
INSERT INTO cbcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham macʉ̃cʉsupi Isaac cawãmecʉcʉre. Isaac pʉame cabero macʉ̃cʉsupi Jacob cawãmecʉcʉre. Jacob pʉame cabero macʉ̃cʉsupi Judá cawãmecʉcʉre, cʉ̃ bairã mena. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá pʉame cabero pũnaacʉsupi Fares, bairi Zara cawãmecʉcʉ mena. Na paco, Tamar wãmecʉsupo. Tunu bairoa Fares pʉame cabero macʉ̃cʉsupi Esrom cawãmecʉcʉre. Esrom pʉame cabero macʉ̃cʉsupi Aram cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram pʉame cabero macʉ̃cʉsupi Aminadab cawãmecʉcʉre. Aminadab pʉame cabero macʉ̃cʉsupi Naasón cawãmecʉcʉre. Naasón pʉame cabero macʉ̃cʉsupi Salmón cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón pʉame cabero macʉ̃cʉsupi Booz cawãmecʉcʉre. Cʉ̃ paco, Rahab wãmecʉsupo. Tunu bairoa Booz pʉame cabero macʉ̃cʉsupi Obed cawãmecʉcʉre. Cʉ̃ paco, Rut wãmecʉsupo. Tunu bairoa Obed pʉame cabero macʉ̃cʉsupi Isaí cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí pʉame cabero macʉ̃cʉsupi David, Israel yepa macããna quetiupaʉ rey caãnipaʉre. Bairo David cʉ̃ã cabero macʉ̃cʉsupi Salomón cawãmecʉcʉre. Cʉ̃ paco ãnacõ pʉame Urías ãnacʉ̃ nʉmo ãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tunu bairoa Salomón pʉame cabero macʉ̃cʉsupi Roboam cawãmecʉcʉre. Roboam pʉame cabero macʉ̃cʉsupi Abías cawãmecʉcʉre. Abías pʉame cabero macʉ̃cʉsupi Asa cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa pʉame cabero macʉ̃cʉsupi Josafat cawãmecʉcʉre. Josafat pʉame cabero macʉ̃cʉsupi Joram cawãmecʉcʉre. Joram pʉame cabero macʉ̃cʉsupi Uzías cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías pʉame cabero macʉ̃cʉsupi Jotam cawãmecʉcʉre. Jotam pʉame cabero macʉ̃cʉsupi Acaz cawãmecʉcʉre. Acaz pʉame cabero macʉ̃cʉsupi Ezequías cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías pʉame cabero macʉ̃cʉsupi Manasés cawãmecʉcʉre. Manasés pʉame cabero macʉ̃cʉsupi Amon cawãmecʉcʉre. Amon pʉame cabero macʉ̃cʉsupi Josías cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías pʉame cabero macʉ̃cʉsupi Jeconías, cʉ̃ bairã menarẽ. Ti yʉteare marĩ ñicʉ̃jãã Israel yepa macããnarẽ na ñejoyupa aperopʉ Babilonia yepapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bairi yua, Jeconías pʉame na cawiyoro bero tunu etaʉpʉ, macʉ̃cʉsupi tunu Salatiel cawãmecʉcʉre. Salatiel pʉame cabero macʉ̃cʉsupi Zorobabel cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel pʉame cabero macʉ̃cʉsupi Abiud cawãmecʉcʉre. Abiud pʉame cabero macʉ̃cʉsupi Eliaquim cawãmecʉcʉre. Eliaquim pʉame cabero macʉ̃cʉsupi Azor cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor pʉame cabero macʉ̃cʉsupi Sadoc cawãmecʉcʉre. Sadoc pʉame cabero macʉ̃cʉsupi Aquim cawãmecʉcʉre. Aquim pʉame cabero macʉ̃cʉsupi Eliud cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud pʉame cabero macʉ̃cʉsupi Eleazar cawãmecʉcʉre. Eleazar pʉame cabero macʉ̃cʉsupi Matán cawãmecʉcʉre. Matán pʉame cabero macʉ̃cʉsupi Jacob cawãmecʉcʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob pʉame cabero macʉ̃cʉsupi yua José cawãmecʉcʉre. José pʉame María manapʉ ãñupĩ. Bairi yua, María pʉame Jesús paco caãnacõ ãmo. Dios cʉ̃ cajoricʉ Mesías marĩ caĩ, Jesús paco majũ ãcõ baiwõ María. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bairi bairo cõñaata, Abraham ãnacʉ̃ berore pʉga wãmo peti rʉpore baparicãnacã pẽnirõ cãnacã tutiri bero macããcʉ̃ ãñupĩ David. Tunu bairoa David ãnacʉ̃ berore pʉga wãmo peti rʉpore baparicãnacã pẽnirõ cãnacã tutiri bero caátó majũ israelita majãrẽ na ñejoyupa Babiloniapʉ. To Babiloniapʉ israelita majãrẽ na cañejoricaro berore tunu pʉga wãmo peti rʉpore baparicãnacã pẽnirõ cãnacã tutiri capetiro bero macããcʉ̃ majũ ãñupĩ yua Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ãmerẽ, mʉjããrẽ yʉ quetibʉjʉgʉ Jesucristo cʉ̃ cabuiarique quetire. Bairo baiyupa: Jesús paco María pʉame José mena cawãmojiyapao ãñupõ. Mai, cʉ̃ mena cõ caãniparo jʉ̃goyepʉa, merẽ bairirupaʉ ãñupõ. Mai, Espíritu Santo, Dios Yeri majũ cʉ̃ camasĩrĩjẽ jʉ̃gori bairo baiyupo María. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José pʉame masĩẽsupʉ Espíritu Santo bairo cʉ̃ caátiatajere. “Roro átiatacomo,” ĩ tʉ̃goñañupʉ̃ cʉ̃ yeripʉ. Baipʉa, nipetiro camasã na caĩñajoro cõ tutigaesupʉ. Cariape caãcʉ̃ ãnirĩ caroaro tʉ̃goñañupʉ̃. “Cõ yarã jetore, ‘Cõrẽ yʉ boetiya,’ ñigʉ yasioroa,” ĩ tʉ̃goñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bairo cʉ̃ caĩtʉ̃goñarõ bero caãnimiatacʉ̃ãrẽ, ñami caãno qũẽguericaropʉ Dios cʉ̃ cajoʉ, ángel majũ buiaetayupʉ. Cʉ̃ pʉame bairo qũĩñupʉ̃: “José, David ãnacʉ̃ pãrãmi, tʉ̃goñarĩqũẽ paieticõãña María menarẽ. Rorije áperiyamo. Cõ macʉ̃ caãnipaʉ Espíritu Santo cʉ̃ camasĩrĩjẽ jʉ̃gori cabuiapaʉ niñami. Torecʉ, ‘Cõrẽ cõ yʉ boetiya,’ ĩ tʉ̃goñaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tunu bairoa cõ macʉ̃ cʉ̃ cabuiaro, ‘Jesús’ cʉ̃ mʉ wãmetigʉ. Tore bairo wãmecʉtigʉmi, cabero bʉtiácʉ́ cʉ̃ yarã na carorije wapare canetõõpaʉ ãnirĩ. Bairi ‘Jesús’ cʉ̃ mʉ wãmetigʉ,” qũĩñupʉ̃ ángel Josére, qũẽguerica tutipʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Profeta majõcʉ jʉ̃gori Dios cʉ̃ caĩjʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiyupa. Mai, atore bairo ĩ quetibʉjʉyupi Dios profeta majõcʉre tirʉ̃mʉpʉre: ");
INSERT INTO cbcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Jĩcãõ carõmio, caʉ̃mʉ mena caãmeo nimiocʉ̃ã, macʉ̃cʉtigomo. Yʉ camasĩrĩjẽ jʉ̃gori macʉ̃cʉtigomo. Cʉ̃, cõ macʉ̃ pʉame ‘Emanuel’ wãmecʉtigʉmi,” ĩ quetibʉjʉyupi profetare. (Emanuel ĩgaro ĩña: “Dios marĩ mena ãnicõãñami.”) ");
INSERT INTO cbcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cabero José pʉame cãniwãcãrĩ bero, ángel cʉ̃rẽ cʉ̃ caátirotirore bairo ásupʉ. María mena wãmo jiyayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bairo wãmoyijamicʉ̃ã, cõ mena ãmeñupʉ̃, cõ macʉ̃, Jesús cawãmecʉtipaʉ cʉ̃ cabuiaparo jʉ̃goye mai. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bairo cabairo bero yua, Jesús buiayupi Belén cawãmecʉti macãpʉ, Judea yepapʉ. Rey Herodes cawãmecʉcʉ majũ quetiupaʉ cʉ̃ caãni yʉteare buiayupi. Bairo cʉ̃ cabuiaro bero, cabʉtoa camasĩrã ñocõãrẽ caĩñacõñamasĩrĩ majã ti yepapʉ etayuparã. Muipʉ cʉ̃ cawãmʉatópʉ caatíatana etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bairo eta yua, atore bairo na ĩ jẽniñañuparã: —¿Noo cʉ̃ ãniñati mʉjãã, judío majã, quetiupaʉ rey caãnipaʉ cabuiatacʉ? Cʉ̃ yaʉ ñocõrẽ jãã ĩñajoapʉ. Ñocõ pʉame muipʉ cʉ̃ cawãmʉatópʉ buiatuaetami. Bairi cʉ̃ãcãrẽ qũĩroagarã jãã atíapʉ —na ĩ quetibʉjʉyuparã cabʉtoa camasĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bairo na caĩquetibʉjʉro tʉ̃go, quetiupaʉ rey Herodes pʉame tʉ̃go acʉacoasupʉ. To Jerusalén macããna cʉ̃ã nipetirã tʉ̃go acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bairo Herodes pʉame tʉ̃goacʉari yua, na piijoyupʉ sacerdote majã quetiuparãrẽ, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã cʉ̃ãrẽ. Bairo na caneñaetaro ĩña yua, atore bairo na ĩ jẽniñañupʉ̃: —¿Dope bairo na ĩ quetibʉjʉyupari marĩ ñicʉ̃jãã, Mesías cawãmecʉcʉ cʉ̃ cabuiapeere? ¿Cʉ̃ pʉame noopʉ cʉ̃ buiagayupari? —na ĩ jẽniñañupʉ̃ Herodes cʉ̃ capiijoatanarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bairo cʉ̃ caĩrõ tʉ̃go yua, na pʉame qũĩñuparã: —Belén na caĩrĩ macãpʉ Judea yepapʉ buiagayupʉ Mesías. Dios yaye quetire woaturica tutipʉ atore bairo ĩ woatuyupi profeta Dios cʉ̃rẽ cʉ̃ caĩquetibʉjʉrijere: ");
INSERT INTO cbcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mʉjãã, Judea yepa, Belén na caĩrĩ macã macããna ʉseanirĩ ãña. Capairi macã macããna mee nimirãcʉ̃ã, caãni macã majũ macããna mʉjãã ãniña. Mʉjãã mena macããcʉ̃ jĩcãʉ̃ quetibʉjʉ masĩgʉmi. Yʉ yarã, Israel yepa macããnarẽ na quetibʉjʉ masĩgʉmi,’ ĩ woatuyupi profeta Dios cʉ̃rẽ cʉ̃ caĩquetibʉjʉrijere —qũĩ quetibʉjʉyuparã Herodere cʉ̃ capiijoatana pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cabero yua, Herodes pʉame yasioro na piijoyupʉ cabʉtoa camasĩrã muipʉ cʉ̃ cawãmʉatópʉ caatíatanarẽ. Bairo yasioro na piijori yua, cʉ̃ ñocõ cabuiatíatacʉ na caĩñajʉ̃goatajere na jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bairo tiere cʉ̃rẽ na caquetibʉjʉyaparoro, Herodes pʉame Belẽpʉ na joyupʉ. Atore bairo na ĩ joyupʉ: —Topʉ ánája. Cʉ̃, cawĩmaʉacarẽ mʉjãã macãwã. Bairo cʉ̃ mʉjãã cabocaata, yʉ mʉjãã quetibʉjʉjowa. Yʉ cʉ̃ã, cʉ̃ ñiroaʉ ágʉ —na ĩtomiñupʉ̃ Herodes cabʉtoa camasĩrĩ majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bairo cʉ̃ caĩrõ tʉ̃go, “Jaʉ” qũĩñuparã. Bairi Belẽpʉ acoásúparã cabʉtoa camasĩrã pʉame. Bairo na caátó, ñocõ na caĩñajoatacʉ pʉame tunu buiatuayupʉ. Na riape baujʉ̃goyecʉsupʉ. Cawĩmaʉaca cʉ̃ caãni wii buipʉ bauetayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bairo ñocõ cʉ̃ cabairo ĩña, cabʉtoa camasĩrã bʉtioro ʉseaniñuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bairo ti wii Jesús cʉ̃ caãni wiipʉre etarã yua, jããñuparã. Bairo jããetarã, Jesure cʉ̃ paco María mena qũĩñañuparã. Bairo Jesure qũĩña yua, rʉpopaturi mena etanumurĩ qũĩroayuparã. Bairo áti yaparo, na rocapataarire pããñuparã. Na yaye apeyere cʉ̃ nuniñuparã. Bairi orore, werea ũnierẽ, bairi caroaro cajutiñurĩjẽ ũnie cʉ̃ãrẽ cʉ̃ nuniñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cabero qũẽguerica tutipʉ na quetibʉjʉyupʉ Dios Herodes roro cʉ̃ caátigarijere. Bairi cabʉtoa camasĩrã pʉame apewãpʉ tunucoásúparã, na ya macã tunu áná yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bairo cabʉtoa camasĩrã na catunuátó bero, marĩ Quetiupaʉ cʉ̃ cajoʉ ángel buiaetayupʉ tunu. José cʉ̃ cacãnirõ qũẽguerica tutipʉ cʉ̃tʉ buiaetayupʉ. Atore bairo qũĩñupʉ̃ ángel Josére: —José, wãcãña. Herodes, cawĩmaʉacarẽ cʉ̃ pajĩãrocacõãgʉ, mʉjããrẽ macãʉ̃ átiyami. Bairi cawĩmaʉ, cʉ̃ paco mena cʉ̃ jʉ̃gorutiácʉ́ja Egipto yepapʉ. Topʉ mʉjãã ãnicõãwã. Cabero mʉjãã yʉ quetibʉjʉgʉ tunu —qũĩñupʉ̃ ángel Josére. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bairo ángel cʉ̃ caĩrõ tʉ̃go, cʉ̃ caĩrõrẽ bairo baiyupʉ José. Ti ñamia Jesuaca, bairi cʉ̃ paco mena cʉ̃ neásúpʉ Egipto yepapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Topʉre eta, yoaro ãnicõãñuparã. Herodes cʉ̃ cariatato beropʉ tunucoásúparã na ya yepapʉ tunu. Profetare marĩ Quetiupaʉ cʉ̃ caĩjʉ̃goyetiricarore bairo baietaro baiyuparo. Atore bairo mai ĩ quetibʉjʉyupi Dios profetare tirʉ̃mʉpʉ: “Yʉ macʉ̃ Egiptopʉ caãniatacʉre cʉ̃ yʉ piitunuojogʉ,” ĩ quetibʉjʉyayupi Dios profetare. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mai, Herodes pʉame cabʉtoa camasĩrã cʉ̃ cabairotirore bairo na cabaieto tʉ̃goʉ yua, bʉtioro asiajãñuñupʉ̃. Bairi cʉ̃ ʉ̃mʉarẽ na joyupʉ Belén macãpʉ, nipetiro cawĩmarã caʉ̃mʉa pʉga cʉ̃ma cacʉ̃gorã, na bairã cʉ̃ãrẽ na capajĩãrepeyoparore bairo ĩ. Belén macãtʉ macããna cʉ̃ãrẽ tore bairo na pajĩãrepeyocõãrotiyupʉ. Cabʉtoa camasĩrã na caquetibʉjʉriquei jʉ̃gori, “Pʉga cʉ̃ma cacʉ̃goʉ ãcʉ̃mi cʉ̃ãcã,” ĩ tʉ̃goñarĩ bairo na átirotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Profeta Jeremías cawãmecʉcʉ cʉ̃ caĩwoatuyaricarore bairo baiyuparo: ");
INSERT INTO cbcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá cawãmecʉti yepapʉre otiawajarique ocajogaro bʉtioro majũ. Raquel nigomo roro yapapuarique mena caotio, cõ pũnaa na cariapetiro ĩñarĩ yua. Bairi, ‘Roro otiecoa. Roro mʉ cabairije netõcoagaro,’ cõ na caĩrĩjẽrẽ tʉ̃gogaetigomo. Oticõã ninucũgomo,” ĩ quetibʉjʉ woatuyayupi Jeremías ãnacʉ̃ cabaipeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cabero Herodes pʉame riacoásúpʉ. Bairo cʉ̃ cariaro ĩña, ángel pʉame Josére cʉ̃ buiaetayupʉ tunu. Egipto yepapʉ José qũẽguerica tutipʉ cʉ̃ caãno, cʉ̃ buiaetayupʉ. Bairo buiaeta yua, atore bairo qũĩñupʉ̃ Josére: ");
INSERT INTO cbcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Wãcãña José. Cawĩmaʉacarẽ capajĩãgamirĩcãrã merẽ riapeticoama. Bairi cʉ̃, cawĩmaʉ, cʉ̃ paco mena cʉ̃ neácʉ́ja tunu mʉjãã ya yepa, Israel yepapʉ —qũĩñupʉ̃ ángel Josére. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bairi ángel cʉ̃ caĩrõrẽ bairo ásupʉ José. Jesús, bairi cʉ̃ paco mena cʉ̃ neásúpʉ Israel yepapʉa tunu. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mai, topʉ ãcʉ̃, quetire tʉ̃goyupʉ José. “Herodes ãnacʉ̃ macʉ̃, Arquelao cawãmecʉcʉ Judea yepa macããna quetiupaʉ merẽ jããũpʉ̃,” ĩrĩqũẽ quetire tʉ̃goyupʉ. Bairo tʉ̃go yua, uwi, ti yepare tunuágaetimiñupʉ̃. Bairo qũẽguerica tutipʉ Dios cʉ̃ caquetibʉjʉatacʉ ãnirĩ, Galilea yepapʉ roque na jʉ̃goásúpʉ José. ");
INSERT INTO cbcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bairo Galilea yepapʉre etaʉ, na jʉ̃goãnicõãñupʉ̃ Nazaret cawãmecʉti macãpʉ. Profeta majã Jesure na caĩwoatujʉ̃goyetiricarore bairo baietaro baiyuparo: “Jesús, Nazaret macããcʉ̃ na caĩ nigʉmi,” ĩ woatuyupa mai profeta majã. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bairo cayoato bero, ti yʉtea caãno, Juan ãnacʉ̃, camasãrẽ oco mena cabautizapaʉ pʉame etayupʉ. Desierto cayucʉmanopʉ Judea yepare etari Dios yaye quetire camasãrẽ na quetibʉjʉgʉ etayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Atore bairo na ĩ quetibʉjʉyupʉ: “Dios cʉ̃ carotimasĩrĩpaʉ merẽ etaro baiya. Bairi tʉ̃goña qũẽnorĩ caroaro ãña Dios mena, mʉjãã yasire,” na ĩ quetibʉjʉyupʉ cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mai, Juan pʉame profeta Isaías ãnacʉ̃ cʉ̃ cawoatujʉ̃goyecʉtacʉ ãñupʉ̃. Atore bairo ĩ woatu quetibʉjʉyayupi Juan cʉ̃ cabaipeere: “Bairo ĩgʉmi jĩcãʉ̃ desierto cayucʉmanopʉ caãnicõãniatacʉ: ‘Marĩ Quetiupaʉ yoaro mee etagʉmi. Torena, caroaro cariape ãnicoteya. Camasã na quetiupaʉ cʉ̃ caetaparo jʉ̃goye cʉ̃ caatípawãrẽ na caqũẽnoyurorea bairo cʉ̃ qũẽnoyuya mʉjãã cʉ̃ã,’” ĩ woatu quetibʉjʉyayupi Isaías ãnacʉ̃ Juan cʉ̃ caĩquetibʉjʉpeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan pʉame waibʉcʉ camello cawãmecʉcʉ asero mena jutiiro qũẽnorĩ jãñañupʉ̃. Tunu bairo waibʉcʉ aserowẽ mena cʉ̃ jutiirore ñujãã tʉ̃gãbiyori jutii jãñañupʉ̃. Bairi tunu ʉgarique cʉsupʉ Juan yeseroare bairã caãnarẽ. Beroa oco cʉ̃ãrẽ etinucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bairo cʉ̃ cabaiãno, Juan tʉpʉ asúparã camasã capããrã. Jerusalén macã macããna, bairi Judea yepa macããna cʉ̃ã, Rio Jordán na caĩrĩya tʉ̃ni macããna nipetiro camasã Juan tʉpʉ asúparã. Juan yaye quetibʉjʉriquere tʉ̃gogarã cʉ̃tʉ asúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃gorã, roro na caátajere tʉ̃goña yapapuari Dios mena bʉsʉnetõñuparã. Bairo na caáto ĩña, oco mena na bautizayupʉ. Catʉ̃goʉsarãrẽ Rio Jordãpʉ na bautizayupʉ Juan. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mai, aperã capããrã fariseo majã, bairi saduceo majã mena Juarẽ cʉ̃ bautiza rotiraná etayuparã na cʉ̃ã. Bairo na caboro ĩñarĩ, atore bairo na ĩñupʉ̃ Juan: “¡Mʉjãã caĩtopairã, ãña pũnaarẽ bairo caãna mʉjãã caãnoi, mʉjãã yʉ bautizaecʉ! Atore bairo mʉjãã ĩ tʉ̃goñarã: ‘Dios camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉrẽ popiye marĩ cabaibujioatajere oco mena marĩ cosenetõbujioʉmi,’ mʉjãã ĩ tʉ̃goñarã. ¿Ñamʉ mʉjãã cʉ̃ quetibʉjʉyati, ‘Tie mena jãã netõgarã,’ mʉjãã caĩrĩjẽrẽ? ");
INSERT INTO cbcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bairo pʉame mʉjãã caátiãnierẽ boya: Rorije mʉjãã caátiere yapapuari caroaro ãnajẽ pʉame átijʉ̃goya. Bairo mʉjãã caáto, camasã nipetiro ĩñarã, ‘Torena, na yerire merẽ wasoa yaparoupa,’ ĩ masĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tunu bairoa, ‘Marĩã, Abraham ãnacʉ̃ pãrãmerã marĩ caãnoi, marĩ netõõgʉmi Dios,’ ĩ tʉ̃goñaeticõãña. Bairo mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, dope bairo átinetõmasĩã maniña. Dope bairo Dios boʉ, atie ʉ̃tã rupaa mena Abraham pãrãmerãrẽ bairo na átiqũẽno jẽñomasĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bairi caroaro mʉjãã caápericõãta, jĩcãʉ̃ yucʉ, caríca maniirẽ quetíjoerocacõãrĩcãrõrẽ bairo mʉjãã átirecõãgʉmi Dios mʉjãã cʉ̃ãrẽ. Petoaca rʉsaya mʉjããrẽ Dios cʉ̃ caĩñabesepa rʉ̃mʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Bairopʉa, yʉ paarique niña mʉjããrẽ oco mena yʉ cabautizarije. Roro mʉjãã caátajere yapapua tʉ̃goñarĩ tiere mʉjãã cajãnarõ ĩñarĩ, tore bairo mʉjããrẽ yʉ átiya. Yʉ paarique to cañumiatacʉ̃ãrẽ, yʉ bero caetaʉ cʉ̃ capaarije pʉame ñunetõgaro. Cʉ̃ roque Espíritu Santore jõmasĩgʉmi camasãpʉre. Tunu bairoa camasã roro na catʉ̃goñarĩjẽrẽ na wasoao joroque na átigʉmi. Cʉ̃ roque yʉ netõrõ caãnimajũʉ̃ nigʉmi. Bairi yʉ pʉame jĩcãrõ tʉ̃ni yʉ átipeyomasĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yʉ bero caetapaʉ pʉame marĩ ĩñabesegʉmi. Bairo carorãrẽ na beseregʉmi. Trigo aseri carorijere joerocacõãrĩcãrõrẽ bairo camasã carorãrẽ na beseregʉmi. Caʉ̃petieti peeropʉ na joeregʉmi. Caroarã roquere caroaro na qũẽnogʉmi. Trigo caroa majũrẽ caroaro na caqũẽnocũrõrẽ bairo caroaro na qũẽnogʉmi caetapaʉ cʉ̃ yarã majũrẽ,” na ĩ quetibʉjʉyupʉ Juan catʉ̃gorã etarãrẽ Jesús cʉ̃ caátipeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cabero Jesús Galilea yepa caãniatacʉ Juan tʉre etayupʉ Rio Jordán cawãmecʉtiya tʉ̃nipʉ. “Juan yʉ cʉ̃ bautizáto,” ĩ etayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cajʉ̃goye mai Juan pʉame cʉ̃ bautizagaetimiñupʉ̃ Jesure. Bairi atore bairo qũĩmiñupʉ̃ Juan: —¿Nopẽĩ mʉ pʉame yʉre mʉ bautiza rotiatíati? Yʉre mʉ cabautizaro roque ñubujioatato —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bairo Juan cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Baipʉa, yʉ caborore bairo mʉ ápa. Bairo mʉ caápata, caroaro cariape Dios marĩrẽ cʉ̃ carotirore bairo marĩ átigarã —qũĩñupʉ̃ Jesús Juarẽ. Bairo cʉ̃ caĩrõ bero, Juan pʉame “Jaʉ” ĩ, Jesús cʉ̃ caborore bairo oco mena cʉ̃ bautizayupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bairo Jesure cʉ̃ cabautizaro bero, Jesús pʉame petapʉ maanʉcãñupʉ̃. Bairo maanʉcã yua, jõbui ʉmʉrecóopʉ ĩñamʉgõjoyupʉ. Bairo cʉ̃ caĩñajoro, jicoquei ʉmʉrecóo pʉame pããnʉcãcoasuparo. Bairo cabairo, Espíritu Santo Dios Yeri majũ bauruiasúpʉ. Bua cʉ̃ caruiatóre bairo bauruietayupʉ Jesús tʉpʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bairo cʉ̃ caruietaro, jõbuipʉ atore bairo bʉsʉrique ocajoyuparo: “Ãni, yʉ macʉ̃, yʉ camai majũ niñami. Cʉ̃ caátiãnierẽ ñiñajesoya bʉtioro,” ĩ bʉsʉocajoyuparo bʉsʉrique. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cabero Espíritu Santo pʉame Jesure cʉ̃ neásúpʉ desierto cayucʉmanopʉ, wãtĩ cʉ̃rẽ cʉ̃ átiñato ĩ. “Cariapea cʉ̃ átinucũñati,” Jesure qũĩ jẽniñagʉ ásupʉ wãtĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bairo Jesús topʉ ãcʉ̃, ñe ũnie ʉgaesupʉ. Cuarenta rʉ̃mʉrĩ, bairi cuarenta ñamirĩ majũ aʉanʉcãcõãñupʉ̃. Cabero yua, queyarique tʉ̃goñañupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bairo cʉ̃ cabairo, wãtĩ pʉame Jesutʉ etayupʉ, roro cʉ̃ áparo, ĩ. Bairo cʉ̃tʉ etari, atore bairo qũĩñupʉ̃: —Mʉ, Dios macʉ̃ mʉ ãniña. Bairo cariapea Dios macʉ̃ caãcʉ̃ ãnirĩ, ati ʉ̃tã rupare pan qũẽnorĩ ʉgaya —qũĩñupʉ̃ wãtĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo pʉame qũĩcõãñupʉ̃ Jesús: —Mʉ caĩrõrẽ bairo yʉ áperigʉ. Dios yaye quetire na cawoaturica tutipʉ ricaati yʉ átirotietiya. Bairo ĩña ti tuti: ‘Ʉgarique marĩ caʉganucũrõ jeto boetiyami Dios. Nipetirije cʉ̃ yaye quetibʉjʉriquere marĩ catʉ̃goñarĩjẽ cʉ̃ãrẽ boyami,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ Jesús wãtĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bairo cʉ̃ caĩrõ bero, wãtĩ pʉame Jesure cʉ̃ neásúpʉ caroa macã Jerusalén macãpʉ. Topʉ etari yua, Dios ya wii templo wii buipʉ cʉ̃ neásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bairo topʉ cʉ̃ jʉ̃goetari, qũĩñupʉ̃ wãtĩ Jesure: —Mʉ, Dios macʉ̃ mʉ ãniña. Bairo cariapea Dios macʉ̃ caãcʉ̃ ãnirĩ, mʉ majũ patiñarui ácʉ́ja jõ yepapʉ. Mʉ riaecʉ. Tore bairo ĩ quetibʉjʉya Dios yaye queti: ‘Dios pʉame cʉ̃ yarã ángelea majãrẽ mʉ coterotigʉmi. Na, ángelea majã, mʉ bocáñegarãma ʉ̃tã rupaare mʉ cañarocapeaetiparore bairo ĩrã,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ wãtĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Bairo mʉ caĩquetibʉjʉrore bairo caĩmiatacʉ̃ãrẽ, mʉ caátirotirore bairo yʉ áperigʉ. Bairo yʉ caáto boetiyami Dios. Ape wãme ape pũrõpʉ atore bairo ĩ quetibʉjʉya: ‘Marĩ Quetiupaʉ Diore cʉ̃ camasĩrĩjẽrẽ átiepecõãrĩ cʉ̃ jẽnieticõãña,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ Jesús wãtĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bairo cʉ̃ caĩrõ bero, wãtĩ pʉame Jesure ʉ̃tãʉ̃ caʉ̃mʉarĩcʉ buipʉ cʉ̃ neásúpʉ. Topʉ etari yua, qũĩñojoyupʉ ati yepa macããna tocãnacãpaʉ macããna quetiuparã na carotimasĩrĩpaʉrire. Caroa macãrĩ majũrẽ qũĩñojoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bairo qũĩñojo yua, atore bairo qũĩñupʉ̃ wãtĩ: —Atie mʉrẽ yʉ caĩñojorijere mʉ yʉ nunigʉ. Yʉtʉ rʉpopaturi mena etanumurĩ yʉ mʉ caĩroaata, mʉ yʉ nunigʉ nipetirijere. “Jaʉ,” miwã —qũĩñupʉ̃ wãtĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Ácʉ́ja wãtĩ. Mʉ caĩrotirore bairo yʉ áperigʉ. Dios yaye woaturica tutipʉ ricaati yʉ átirotietiya. Bairo ĩña ti tuti: ‘Jĩcãʉ̃ã niñami marĩ caĩroaʉ, Dios jeto. Cʉ̃ caĩrĩjẽ jetore tʉ̃goya,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ Jesús wãtĩrẽ. Cʉ̃ yʉesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bairo Jesús cʉ̃ caĩrĩjẽrẽ tʉ̃go, acoásúpʉ wãtĩ pʉame yua. Bairo cʉ̃ caátó bero, jĩcããrã ángelea majã Jesure cʉ̃ jʉátirã etayuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cabero Jesús pʉame queti tʉ̃goyupʉ, “Juan preso jorica wiipʉ niupʉ̃,” ĩrĩqũẽ quetire. Bairo tiere tʉ̃go yua, Galilea yepapʉ acoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Baipʉa, Nazaret macãrẽ tuaesupʉ. Ti macãrẽ netõácʉ́, Capernaum cawãmecʉti macãpʉ etayupʉ. Ti macã Galilea ʉtabʉcʉra tʉ̃nipʉ niña. Marĩ ñicʉ̃jãã Zabulón, bairi Neftalí cawãmecʉna ãnana na caãna yepapʉ niña ti macã. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Profeta Isaías ãnacʉ̃ Zabulón, Neftalí macããnarẽ cʉ̃ caĩwoatujʉ̃goyetiricarore bairo baietaro baiyuparo. Atore bairo ĩ quetibʉjʉ woatucũñañupĩ Isaías: ");
INSERT INTO cbcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“To Zabulón yepa macããna, bairi aperã Neftalí yepa macããna, bairi aperã Rio Jordán ape nʉgõã, mar tʉ̃ni macããna, bairi aperã Galilea yepa macããna cʉ̃ã Diore camasĩẽna niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na, canaitĩãrõpʉ cañesẽãrãrẽ bairo caãna niñama. Bairo caãna nimirãcʉ̃ã, caroaro cabusurore ĩñarãrẽ bairo nigarãma. Dios cʉ̃ cajoʉ cʉ̃ caquetibʉjʉrijere tʉ̃gorã, caroaro cabusurore ĩñarãrẽ bairo nigarãma. Diore masĩcoagarãma yua,” ĩ woatuyupi profeta Isaías ãnacʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti watoare na quetibʉjʉ jʉ̃goyupʉ Jesús cʉ̃ yaye quetire camasãrẽ. Atore bairo na ĩ quetibʉjʉyupʉ: “Dios cʉ̃ carotimasĩrĩpaʉ merẽ etaro baiya. Bairi tʉ̃goña qũẽnorĩ caroaro ãña Dios mena,” na ĩ quetibʉjʉyupʉ Jesús camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cabero, Galilea na caĩrĩ ʉtabʉcʉra tʉ̃nipʉ ásúpʉ Jesús. Bairo ácʉ́ yua, Simón, apei cʉ̃ bai Andrés, jĩcãʉ̃ pũnaa caãna pʉgarãrẽ na ĩñajoyupʉ. Ape wãme “Pedro” qũĩñuparã Simorẽ. Bairo Jesús narẽ cʉ̃ caĩñajoro, na pʉgarãpʉa ʉtabʉcʉrapʉ bapi mena wai wasarã ásuparã na, pʉgarãpʉa. Na capaarije, waiwe wapatarique ãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bairo na ĩña, atore bairo na ĩñupʉ̃ Jesús: —Jito, yʉ bapacʉsa. Caroaro waire cawãsãmasĩrã mʉjãã ãniapʉ, wai na rutieticoáto, ĩrã. Ãmerẽ yua, caroaro camasãrẽ caquetibʉjʉrã mʉjãã ãnio joroque mʉjãã yʉ átigʉ, na yasieticõãto, ĩrã —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei pʉgarãpʉa na bapi yucʉre cũrĩ, acoásúparã Jesús mena. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bairo cajʉ̃goye jãñurĩ na caánemorõ, ʉtabʉcʉra tʉ̃nipʉ Jesús pʉame na ĩñajoyupʉ aperã pʉgarãrẽ tunu. Santiago, bairi cʉ̃ bai Juan cawãmecʉcʉ Zebedeo pũnaarẽ na ĩñajoyupʉ Jesús. Mai, Santiago, cʉ̃ bai Juan mena cũmua capairicapʉ ãñuparã. Bapi yucʉ caopecʉtiere jiyajãrã ásuparã. Bairo narẽ na ĩña, na piijoyupʉ Jesús: “Jito. Yʉ bapacʉsa. Marĩ quetibʉjʉto camasãrẽ Dios yaye caroa quetire,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã, jicoquei na cʉ̃ã acoásúparã Jesús mena. Na bapi yucʉre cũrĩ, na pacʉ cũmuapʉ caãcʉ̃rẽ cʉ̃ aweyocoásúpʉ Santiago, cʉ̃ bai Juan mena. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Cabero áñesẽãñupʉ̃ Jesús Galilea yepapʉ. Topʉ áñesẽã yua, tocãnacã macã macããna na cañubueri wiiripʉ sinagogas na caĩrĩ wiiripʉre buenucũñupʉ̃ to macããnarẽ. Dios cʉ̃ carotimasĩrĩpaʉ caetarore na buenucũñupʉ̃, caroa queti majũrẽ. Bairo topʉ bueñesẽãʉ̃, nipetiri wãme cariayecʉnarẽ na catioyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bairo tiere ĩñarã, camasã tocãnacãʉ̃pʉa ãmeo quetibʉjʉnetõñuparã na majũ. Bairi Siria yepa macããna tʉ̃gopeticoasuparã Jesús cʉ̃ caátimasĩrĩjẽrẽ. Bairo tiere tʉ̃go, na yarã cariarãrẽ cʉ̃tʉ na jeasúparã. Nipetirije riaye cacʉ̃gorãrẽ, bairi na rupaʉri cawʉ̃gãrãrẽ, bairi wãtĩã yeri pũna cacʉ̃gorãrẽ, bairi camecʉ̃rãrẽ, bairi ñicããrĩ cabʉʉrãrẽ cʉ̃tʉ na jeasúparã. Jesús pʉame bairo na cajeanárẽ na bocá catioyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bairo cʉ̃ caátimasĩrĩjẽrẽ ĩñarã, camasã capããrã cʉ̃ berore ʉsayuparã. Na, Galilea yepa macããna, bairi Decápolis yepa macãã macããna, bairi Jerusalén macã macããna, bairi Judea yepa macããna, bairi Rio Jordán cawãmecʉtiya jinʉgõã macããna nipetirã Jesús berore ʉsayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bairo capããrã camasã na caetaro ĩñarĩ yua, Jesús pʉame jĩcãʉ̃ ʉ̃tãʉ̃ buipʉ acoásúpʉ. Topʉ cʉ̃ caruiro, cʉ̃ cabuerã cʉ̃tʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bairo na caetaro ĩña, atore bairo na ĩ quetibʉjʉyupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ʉseanirĩ niñama Diore caroaro masĩẽtĩmirãcʉ̃ã, cʉ̃ mena catʉ̃goñatutuanemogarã pʉame. Bairo caãna ãnirĩ Dios cʉ̃ carotimasĩrĩpaʉ macããna nigarãma yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Tunu bairoa ʉseanirĩ niñama yapapuari caãnimiatana cʉ̃ã. Dios pʉame ʉseanirõ ãnitʉ̃goñarĩqũẽrẽ na jogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Tunu bairoa ʉseanirĩ niñama rorije caãmeoáperã. Ati yepa uparã na ãnio joroque na átigʉmi Dios cʉ̃ caĩrĩcãrõrẽã bairo. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Tunu bairoa ʉseanirĩ niñama Dios cʉ̃ caborore bairo bʉtioro caáticõã ãnigarã. Dios pʉame na jʉátinemogʉmi, cʉ̃ caborore bairo na caátimasĩparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Tunu bairoa ʉseanirĩ niñama cabopacarãrẽ caĩñamairã. Na cʉ̃ãrẽ na ĩñamairĩ na jʉátigʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Tunu bairoa ʉseanirĩ niñama ñe ũnie na yeripʉ carorije mána caãna. Na roque Diore qũĩñagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Tunu bairoa ʉseanirĩ niñama jĩcãrõ tʉ̃ni ãnajẽrẽ cajʉ̃goátiãna. ‘Narẽ Dios pũnaa caãna,’ na ĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Tunu bairoa ʉseanirĩ niñama Dios cʉ̃ caborore bairo na caátie jʉ̃gori caĩñate ecorã. Aperã roro popiye na baio joroque na caátimiatacʉ̃ãrẽ, Dios cʉ̃ carotimasĩrĩpaʉ macããna majũ nigarãma bairãpʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Tunu bairoa ʉseanirĩ mʉjãã ãnigarã, camasã roro mʉjããrẽ na caĩmiatacʉ̃ãrẽ. Tunu yʉre mʉjãã catʉ̃goʉsarije jʉ̃gori capee ĩtorique mena popiye mʉjãã baio joroque na caátimiatacʉ̃ãrẽ, ʉseanirĩ mʉjãã ãnigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bairo jeto ásupa camasã, profeta majã mʉjãã jʉ̃goyepʉ caquetibʉjʉnetõrĩ majã ãnana cʉ̃ãrẽ. Tore bairo ãmerẽ roro mʉjãã cabaimiatacʉ̃ãrẽ, Dios mʉjããrẽ caroare cʉ̃ cajopee paijãñurõ nigaro. Jõbuipʉ mʉjãã caetaro, pairo nigaro mʉjããrẽ caroa cʉ̃ cajopee pʉame. Tiere tʉ̃goñarĩ ʉseanirĩqũẽ mena bairoa ãnicõã ninucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mʉjãã, yʉ yarã ati yepapʉre moarẽ bairo mʉjãã ãniña camasãrẽ. Moa caocaetie caãmata, ñerẽ átimasĩẽtĩña camasãrẽ. Bairi moa caocarije capeticõã ʉsapata, ñe ũnie pʉamerẽ ñuẽtĩña. Rerique niña. Bairi macã yepapʉ reyama camasã tie ũnie carorijere. Bairo na carero, na ya wii macã yepa canetõáná pʉame na careatajere peaborecõãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tunu bairoa ati yepapʉre cabusurijere bairo mʉjãã ãniña camasãrẽ. Jĩcã macã ʉ̃tãʉ̃ buipʉ na caqũẽnorĩcã macã caãmata, yasioropʉ ãmerĩña. Nipetiro camasã caroaro ti macãrẽ ĩñajomasĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ jĩñaworiquere bʉgacũẽcʉ̃mi carupapata rocapʉ. Jõbuipʉ cũnucũñami, cʉ̃ ya wiire to ʉ̃busuwoáto, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bairi mʉjãã pʉame torea bairo mʉjãã átigarã mʉjãã cʉ̃ã. Caroaro mʉjãã átiãninucũgarã camasã na caĩñajoro, marĩ Pacʉ Dios, ʉmʉrecóo macããcʉ̃rẽ cʉ̃ na cabasapeoparore bairo ĩrã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “‘Moisés ãnacʉ̃, bairi profeta majã ãnana cʉ̃ã na caquetibʉjʉcũrĩqũẽrẽ jãnarotiacʉ́, tiere bueyami,’ ĩ tʉ̃goñaeticõãña yʉ capaarique cʉtiere. Bairo mee átiacʉ́ yʉ baiya ati yepapʉre. Dios yarã ãnana na caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo jĩcãrõ tʉ̃ni to baipeticõãto ĩ, ati yepapʉre yʉ apʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cariape mʉjããrẽ yʉ quetibʉjʉya: Ati ʉmʉrecóo capetiparo jʉ̃goye Moisés ãnacʉ̃ cʉ̃ caátiroticũrĩqũẽ jĩcã wãmeacã ũnorẽ noa ũna átiyasiomasĩẽtĩñama. Cʉ̃ caĩrĩcãrõrẽã bairo baicoagaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bairi ni jĩcãʉ̃ ũcʉ̃ Moisés cʉ̃ caátiroticũrĩqũẽ jĩcã wãmeacã ũnorẽ cʉ̃ cajãnarotiata, o camasãrẽ ricaati na cʉ̃ caĩquetibʉjʉata, Dios cʉ̃ carotimasĩrĩpaʉ macããna nipetiro netõrõ cabʉgoro macããcʉ̃ nigʉmi. Apei pʉame tie cʉ̃ caátiroticũrĩqũẽrẽ cʉ̃ catʉ̃goʉsacõãmata, bairi tunu camasãrẽ cariape na cʉ̃ caĩquetibʉjʉata, Dios cʉ̃ carotimasĩrĩpaʉ macããna mena carotimasĩ majũ nigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cariape mʉjããrẽ ñiña: Moisés ãnacʉ̃ cʉ̃ caátiroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi fariseo majã na caátiãnie netõjãñurõ Dios cʉ̃ caborore bairo caroaro mʉjãã caápericõãta, Dios cʉ̃ carotimasĩrĩpaʉre mʉjãã etaetigarã.” ");
INSERT INTO cbcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Apeyera, “Marĩ ñicʉ̃jããrẽ na caquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃goyupa: ‘Camasãrẽ na pajĩãreeticõãña. Ni jĩcãʉ̃ ũcʉ̃ apeire cʉ̃ capajĩãrocaata, roro cʉ̃ caátiere ĩñacõñarĩ popiye cʉ̃ baio joroque cʉ̃ átirotigarãma cabʉtoa camasĩrã,’ na caĩrĩqũẽrẽ mʉjãã tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bairo na caĩquetibʉjʉcũmiatacʉ̃ãrẽ, yʉ pʉame atore bairo mʉjããrẽ yʉ quetibʉjʉ cũnemoña: Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ yaʉ mena cʉ̃ caasiata, Dios pʉame roro cʉ̃ caátiere ĩñacõñarĩ popiye cʉ̃ baio joroque cʉ̃ átigʉmi. Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ cʉ̃ yaʉre roro cʉ̃ caĩtutiata, Junta Suprema macããna roro cʉ̃ caátiere ĩñacõñarĩ popiye cʉ̃ baio joroque cʉ̃ átigarãma. Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ cʉ̃ yaʉre, ‘Catʉ̃gomasĩẽcʉ̃ mʉ ãniña,’ ĩrĩ, bʉtioro yapapua tʉ̃goñarĩ cʉ̃ ãnio joroque cʉ̃ cʉ̃ caápata, caʉ̃petietopʉ caácʉ́re bairo nigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Bairi ni mʉjãã mena macããcʉ̃ roro cʉ̃ caátaje wapare yasiogʉ, altar mesapʉ waibʉcʉre cʉ̃ neátí, bairi, ‘Yʉ mena asiajãñuñami mai yʉ yaʉ,’ cʉ̃ caĩtʉ̃goñabócaata, ti altapʉre cʉ̃ canunigamirĩjẽrẽ cʉ̃ cacũrõ ñuña mai. Cariape cʉ̃ yaʉtʉ cʉ̃ caátó boya. Cʉ̃ mena cʉ̃ cabʉsʉqũẽnorõ boya. Bairo tiere áti yaparori bero roque, Diore cʉ̃ cañubuero ñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tunu bairoa ni apei ũcʉ̃, ‘Yʉ mʉjãã wapamoña,’ ĩrĩ, mʉjããrẽ juez caĩñabesei tʉpʉ cʉ̃ caneápáro jʉ̃goye, tãmurĩ cʉ̃ mena bʉsʉqũẽnojʉ̃goya. Mʉjããrẽ juez tʉpʉ cʉ̃ caneápériparore bairo ĩrã, cʉ̃ mena bʉsʉqũẽnojʉ̃goya. Mʉjãã cabʉsʉqũẽnojʉ̃goeticõãta, juez pʉame preso jorica wii macããna cacoterãrẽ mʉjããrẽ ñerotigʉmi. Bairo áti yaparo, na pʉame preso jorica wiipʉ mʉjããrẽ cũrecõãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cariape mʉjããrẽ ñiña: Dinero mʉjãã cawapamorĩjẽrẽ mʉjãã cawapatipeyoparo jʉ̃goye, topʉ mʉjãã ãnicõãgarã. Mʉjãã witimasĩetigarã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ĩ quetibʉjʉ yaparo, na ĩ nemoñupʉ̃ tunu: “‘Apeo mʉ nʉmo mee caãcõrẽ eperico cʉ̃goeticõãña,’ na caĩquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bairo na caĩquetibʉjʉcũmiatacʉ̃ãrẽ, yʉ pʉame atore bairo mʉjããrẽ yʉ quetibʉjʉ cũnemoña tunu: Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmo mee caãcõrẽ roro cõ cʉ̃ caátigatʉ̃goñata, merẽ cʉ̃ yeripʉre cõ mena caãcʉ̃rẽ bairo ãnicõãbujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Bairi ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ cʉ̃ caapea cariape nʉgõã macããcã mena carorije macããjẽ jetore ĩñanucũʉ̃mi. Bairo tia cʉ̃ caapea jʉ̃gori carorije macããjẽrẽ caĩñapai cʉ̃ caãmata, apeire tia cʉ̃ caapeare weeroticõãrĩ caãcʉ̃rẽ bairo cʉ̃ caãno, ñubujioro. Bairo cʉ̃ rupaʉ macããtõ jĩcãrõrẽ cʉ̃goetimicʉ̃ã, Dios tʉpʉ cʉ̃ caetaata, ñuña. Bairo cʉ̃ rupaʉ macããjẽ roro cʉ̃rẽ caátiecorotirije nipetiro mena peeropʉ roro cʉ̃ tãmʉo joroque Dios cʉ̃ caápata roque, ñuetimajũcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ cʉ̃ wãmo jʉ̃gori rorije jetore átinucũʉ̃mi. Bairo cʉ̃ wãmo jʉ̃gori carorijere caátieconucũʉ̃ cʉ̃ caãmata, apeire cʉ̃ wãmorẽ yisetaroticõãrĩ caãcʉ̃rẽ bairo cʉ̃ caãno, ñubujioro. Bairo cʉ̃ rupaʉ macããtõ jĩcãrõrẽ cʉ̃goetimicʉ̃ã, Dios tʉpʉ cʉ̃ caetaata, ñuña. Bairo cʉ̃ rupaʉ macããjẽ roro cʉ̃rẽ caátiecorotirije nipetiro mena peeropʉ roro cʉ̃ tãmʉo joroque Dios cʉ̃ caápata roque, ñuetimajũcõãña. Bairi roro mʉjãã caátinucũrĩjẽrẽ jãnacõãña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ cʉ̃ carocagaata, atore bairo ĩrĩcã pũrõrẽ cõ cʉ̃ cajoro, ñurõ: ‘Bairo mʉ cabairoi, mʉrẽ teei, mʉrẽ yʉ rocaya yua,’ na caĩquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bairo na caĩquetibʉjʉcũmiatacʉ̃ãrẽ, yʉ pʉame atore bairo mʉjããrẽ yʉ quetibʉjʉ cũnemoña tunu: Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmo, apei mena roro caepeeco cõ caãnimiatacʉ̃ãrẽ, cõrẽ cʉ̃ carocaata, roro cõ baio joroque cõ átiyami. Apei mena roro caepericore bairo caãcõ cõ ãnio joroque cõ átiyami, bairo cõ cʉ̃ caápata. Tunu bairoa apei pʉame capitiecoricore cʉ̃ cawãmojiyaata, apeo mena roro caepericʉre bairo caãcʉ̃ ãnibujioʉmi cʉ̃ cʉ̃ã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ĩ quetibʉjʉ yaparo, ape wãme atore bairo na ĩnemoñupʉ̃ tunu: “‘Dios mena ñiña, mʉjãã caĩatato bero caãmata, mʉjãã caĩrõrẽã bairo ása. Ĩtoeticõãña,’ marĩ ñicʉ̃jãã na caĩquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Bairo na caĩquetibʉjʉcũmiatacʉ̃ãrẽ, yʉ pʉame atore bairo mʉjããrẽ yʉ quetibʉjʉ cũnemoña tunu: Atore bairi wãme ĩẽtĩcõãña: ‘Jõ ʉmʉrecóo mena ñiña,’ o ‘Ati yepa mena ñiña,’ o ‘Jerusalén na caĩrĩ macã mena majũ ñiña,’ ĩẽtĩcõãña. Bairo mʉjãã caĩata, Diore caĩroaenarẽ bairo caãna mʉjãã ãnibujiorã. Ʉmʉrecóo pʉame Dios cʉ̃ caãnipaʉ niña. Ati yepa pʉame cʉ̃ carotiripaʉ niña. Jerusalén cʉ̃ã cʉ̃ carotimasĩrĩpaʉ niña. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tunu bairoa, ‘Yʉ rʉpoa mena ñiña,’ ĩẽtĩcõãña. Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ poawẽ jĩcãwẽ cañirĩwẽãcãrẽ cabotiriwẽ majũ átiwasoamasĩẽtĩñami. O cabotiriwẽãcã caãmata, cañirĩwẽ majũ átiwasoa masĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Bairi atore bairo ĩrĩqũẽ jeto ñuña: ‘Bairo yʉ átigʉ,’ o ‘Bairo yʉ áperigʉ,’ cariapea ĩrĩqũẽ jeto ñuña. Tie netõjãñurõ mʉjãã caĩata, wãtĩ cʉ̃ caĩbʉsʉjãrĩjẽrẽ catʉ̃goʉsarãrẽ bairo caãna mʉjãã ãnibujiorã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “‘Jĩcãʉ̃ apei mena ãmeo qũẽrĩ cʉ̃ caapeere cʉ̃ caroyetuata, cʉ̃ cʉ̃ã cʉ̃rẽã bairo cʉ̃ caapeere cʉ̃ caãmerõ ñurõ. O cʉ̃ opire cʉ̃ capapeata, cʉ̃ cʉ̃ã cʉ̃rẽã bairo cʉ̃ opire cʉ̃ capapeero ñurõ,’ na caĩquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bairo na caĩquetibʉjʉcũmiatacʉ̃ãrẽ, yʉ pʉame atore bairo mʉjããrẽ yʉ quetibʉjʉ cũnemoña tunu: Aperã roro mʉjããrẽ na caátimiatacʉ̃ãrẽ na ãmeeticõãña. Bairi ni jĩcãʉ̃ ũcʉ̃ mʉjãã wasopanarẽ cʉ̃ capaata, ape nʉgõã cʉ̃ãrẽ cʉ̃ ẽñotaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tunu bairoa apei mʉjãã pesu pʉame mʉjãã jutiiro cabui macããtõrẽ quetiupaʉ juezre cʉ̃ caẽmarotiata, mʉjãã camisa cʉ̃ãrẽ cʉ̃ nunicõãña mʉjãã pesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tunu bairoa ape yepa macããcʉ̃ soldau ũcʉ̃, ‘Pʉga kilómetro majũ yʉ yayere pʉsabojaya tãmurĩ wapa mano,’ mʉjãã cʉ̃ caĩata, baparicãnacã kilómetro majũ buipearo cʉ̃ mʉjãã pʉsabojagarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tunu bairoa apei cʉ̃ cajẽniata, cʉ̃ cabopacarijere cʉ̃ nuniña. Tunu apei, ‘Yʉre wasoya,’ mʉjãã cʉ̃ caĩata, ‘Mʉ yʉ wasoecʉ,’ qũĩẽtĩcõãña. Cʉ̃ nunicõãña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “‘Marĩ yarãrẽ marĩ camairõ ñuña. Tunu marĩ pesua pʉamerẽ marĩ cateero ñuña,’ na caĩquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bairo na caĩquetibʉjʉcũmiatacʉ̃ãrẽ, yʉ pʉame atore bairo mʉjããrẽ yʉ quetibʉjʉ cũnemoña tunu: Mʉjãã pesua cʉ̃ãrẽ na maiña. Rorije na ápericõãña. Caroa roquere na ása. Dios yarã mʉjãã caãnoi, roro mʉjãã baio joroque caánarẽ na jẽnibojaya Diopʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bairo mʉjãã caápata, Dios ʉmʉrecóo caãcʉ̃ pũnaarẽ bairo caãna mʉjãã ãnigarã. Dios pʉame nipetirore caĩñamai niñami. Carorijere caána, caroare caána cʉ̃ãrẽ muipʉ asibatopeyocõãnucũñami. Tunu bairoa oco caocarijere na jonucũñami Dios carorije wapare cacʉ̃gorãrẽ bairo cʉ̃ caĩñarãrẽ, carorije wapa cacʉ̃goenarẽ bairo cʉ̃ caĩñarã cʉ̃ãrẽ. Bairi mʉjãã cʉ̃ã Dios caroaro cʉ̃ caátorea bairo caroaro na ása, roro mʉjããrẽ caána cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉjããrẽ camairã jetore mʉjãã camaiata, Dios mʉjãã cawapatapee mʉjããrẽ cʉ̃ cajorije manigaro. Tore bairo átinucũñama Roma macããnarẽ camasã yaye dinerore jejobojari majã. Narẽ camairã jetore na mainucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tunu bairoa mʉjãã yarã jetore, ‘Caroare cʉ̃ joáto Dios mʉjããrẽ,’ na mʉjãã caĩata, ¿ñe ũnierẽ aperã netõrõ caroare mʉjãã átiyati? Tore bairo átinucũñama Diore camasĩẽna cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Marĩ Pacʉ, ʉmʉrecóo macããcʉ̃ pʉame roque caroaro cariape cʉ̃ caátie petietiya. Bairi mʉjãã Dios yarã ãnirĩ roro mʉjããrẽ caána cʉ̃ãrẽ caroaro na ása. Bairi Dios cʉ̃ caátinucũrĩjẽrẽ bairo mʉjãã cʉ̃ã caroaro cariape átinucũña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Ñubueráná caroaro tʉ̃goñaña. ‘Capããrã camasã na caneñarõ jetore marĩ ñubuegarã, caroaro marĩ caátiere na caĩñaparore bairo ĩrã,’ ĩ tʉ̃goñaeticõãña. Bairo mʉjãã caĩtʉ̃goñaata, marĩ Pacʉ Dios ʉmʉrecóo macããcʉ̃ mʉjãã cawapatapee mʉjããrẽ cʉ̃ cajopeere mʉjãã joetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Bairi camasã na cabopacarijere mʉjãã cajoata, nipetiro camasãrẽ, bairo mʉjãã caátiere na quetibʉjʉ masĩõẽtĩcõãña. Tore bairo átinucũñama caĩtopairã cʉ̃ã ñubuerica wii, sinagogare ãna, o maapʉ áñesẽãrã, nipetiro camasã narẽ na caĩroaparore bairo ĩrã. Cariape mʉjããrẽ ñiña: Na ũna camasã aperã narẽ na caĩroanucũrĩjẽ netõrõ cʉ̃gonemoetigarãma. Dios pʉame na ĩroaetiri caroare na joetigʉmi roro na catʉ̃goñarĩjẽ jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bairi mʉjãã pʉame camasã na cabopacarijere mʉjãã cajoata, ni ũcʉ̃ mʉjãã yaʉ caãnimajũʉ̃rẽ cʉ̃ quetibʉjʉeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Capããrã na caĩñaetopʉ, cabopacarãrẽ na jʉátinemoña. Tore bairo mʉjãã caápata, marĩ Pacʉ Dios yasioropʉ mʉjãã caátimiatacʉ̃ãrẽ, caĩñaʉ ãnirĩ mʉjãã jogʉmi mʉjãã cawapatapeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tunu bairoa Diore jẽnirã, caĩtopairã na cajẽnirõrẽ bairo jẽnieticõãña. Na pʉame ñubuerica wiipʉ ãna, nucũrĩ Diore cʉ̃ jẽniʉseanucũñama. O plaza tʉ̃nipʉ capããrã camasã na caãnopʉ ãna, bairo átiʉseanucũñama, nipetiro camasã caroaro na cañubuerijere na caĩñaparorore bairo ĩrã. Cariape mʉjããrẽ ñiña: Na ũna camasã aperã narẽ na caĩroanucũrĩjẽ netõrõ cʉ̃gonemoetigarãma. Dios na ĩroaetiri, caroare na joetigʉmi, roro na catʉ̃goñarĩjẽ jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bairi mʉjãã pʉame Diore cʉ̃ mʉjãã cajẽniata, atore bairo mʉjãã caáto ñuña: Mʉjãã ya arʉa jopere biajãáti, aperã na caĩñaetopʉ Diore cʉ̃ jẽninucũña. Tore bairo mʉjãã caápata, marĩ Pacʉ Dios jeto caĩñaʉ, mʉjãã mena caãcʉ̃ ãnirĩ caroare mʉjãã jogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Tunu bairoa Diore cʉ̃ jẽnirã, nairõ jĩcã wãmea cabʉgoro macããjẽrẽ ĩ bʉsʉjẽnieticõãña. Torea bairo jeto ĩ jẽninucũñama Diore camasĩẽna. ‘Nairõ jĩcã wãmea cʉ̃ marĩ caĩata, caroaro tʉ̃goʉmi Dios,’ ĩ tʉ̃goñañama, masĩẽna. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Marĩ Pacʉ Dios pʉame cʉ̃ mʉjãã cajẽniparo jʉ̃goyepʉa merẽ mʉjãã cajẽnipeere masĩcõãñami. Bairi narẽ bairo cʉ̃ jẽnieticõãña Diore. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Atore bairo mʉjãã caĩjẽnirõ boya: ‘Jãã Pacʉ, jõbui macããcʉ̃, nipetiro camasã mʉ wãmerẽ na ĩroáto. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tunu bairoa mʉ carotimasĩrĩpaʉ ati yepapʉ to apáro. Jõbuipʉ mʉ carotirorea bairo to baiáto ati yepapʉ cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tunu ãme jãã caʉgapee, jãã caborije, jããrẽ carʉsarije ũnie cʉ̃ãrẽ jãã joya. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tunu bairoa roro jãã caátaje cʉ̃ãrẽ jãã masiriyobojaya. Camasã roro jããrẽ na caátajere jãã camasiritirorea bairo roro jãã caátaje cʉ̃ãrẽ jãã masiriyobojaya mʉ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tunu wãtĩ roro jããrẽ cʉ̃ caátigarijere jãã ẽñotaya. Jãã netõõña. Mʉ jeto carotimasĩ mʉ ãniña. Mʉ jeto catutuanetõʉ̃ mʉ ãniña. Mʉ jeto camasã na caĩroapaʉ mʉ ãniña tocãnacã rʉ̃mʉa. Bairo to baiáto,’ bairo Diore cʉ̃ mʉjãã caĩjẽnipee ñuña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Camasã roro mʉjããrẽ na caátajere na mʉjãã cabʉsʉqũẽnoata, marĩ Pacʉ Dios ʉmʉrecóopʉ caãcʉ̃ cʉ̃ã roro mʉjãã caátajere masiriyobojagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bairo roro mʉjããrẽ na caátajere na mʉjãã cabʉsʉqũẽnoeticõãta roque, marĩ Pacʉ Dios cʉ̃ã roro mʉjãã caátajere masiriyobojaetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tunu bairoa ape rʉ̃mʉ ʉgarique betiri Diore ñubueãna, tʉ̃goñarĩqũẽ pairã yapapuarique cʉnarẽ bairã na cabaurore bairo baieticõãña. Tore bairo jeto átiyama caĩtopairã, nipetiro camasã ʉgarique betiri Diore na cañubuero na camasĩparore bairo ĩrã. Cariape mʉjããrẽ ñiña: Camasã na caĩroarije netõrõ cʉ̃goetigarãma. Dios na ĩroaetiri caroare na joetigʉmi, roro na catʉ̃goñarĩjẽ jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bairi mʉjãã pʉame ʉgarique betiri Diore mʉjãã cañubueata, atore bairo mʉjãã caáto ñuña: Mʉjãã riapére wacoseya. Mʉjãã poa cʉ̃ãrẽ caroaro wʉgapeoya. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bairo ása, ni jĩcãʉ̃ ũcʉ̃ ʉgarique betiri mʉjãã cañubuerijere cʉ̃ camasĩẽtĩparore bairo ĩrã. Atorea bairo mʉjãã caápata, marĩ Pacʉ Dios caĩñaʉ jeto mʉjãã mena caãcʉ̃ ãnirĩ caroare mʉjãã jogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tunu bairoa ati yepa macããjẽ pairo cawapacʉtiere jeeneñorĩ caroare bairo jecũcʉ̃gonetõẽtĩcõãña. Ati yepapʉ marĩ caãno, moena ʉgareyama ti ũnierẽ. O tie ãpõã ũnie caãmata cʉ̃ãrẽ, ʉta witiri boacoaya. O aperã tiere jerutirecõãñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Caroaro ása, jõbuipʉ roquere mʉjãã yaye wapa caãnipeere mʉjãã cacʉ̃gonetõparore bairo. Topʉ noa ũna moena caʉgarerã mánama. Caʉtawitiboarije ũnie cʉ̃ã mano. Cajerutiri majã cʉ̃ã mánama ʉmʉrecóopʉre. Bairi topʉ mʉjãã cacʉ̃gopee yasietigaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ati yepapʉ macããjẽ jetore mʉjãã camaitʉ̃goñaata, tie jetore mʉjãã bootʉ̃goñagarã. Jõbuipʉ mʉjãã cacʉ̃gopeere mʉjãã camaitʉ̃goñaata roque, ati yepa macããjẽrẽ bʉtioro mʉjãã bootʉ̃goñaetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","“Tunu bairoa mʉjãã caapee pʉame cajĩñaworicare bairo niña mʉjãã rupaʉre. Mʉjãã caapee caroaro to caĩñamasĩata, caroaro mʉjãã ĩñamasĩña. Caroyetuata, caroaro mʉjãã ĩñamasĩẽtĩña. Tore bairo mʉjãã, cayeriñurã ãnirĩ cariape mʉjãã catʉ̃goñaata, caroaro mʉjãã átimasĩgarã. Cayeriñuena mʉjãã caãmata roque, caroaro mʉjãã átimasĩẽtĩbujiorã. Dios mʉjããrẽ cʉ̃ camasĩõrĩjẽrẽ mʉjãã catʉ̃goʉsajãnacõãta, ¡roro majũ ána mʉjãã átibujiorã! ");
INSERT INTO cbcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tunu bairoa ni jĩcãʉ̃ ũcʉ̃, pʉgarãpʉa cʉ̃ quetiuparã na caĩrõrẽ bairo átimasĩẽtĩñami, jĩcãrõrẽã bairo na carotimasĩẽtĩcõãta. Bairo na cabaiata, jĩcãʉ̃rẽ qũĩroabujioʉmi. Apeire qũĩroaetibujioʉmi. Jĩcãʉ̃ mena yeri ñugʉmi. Apeire qũĩñategʉmi. Torea bairo mʉjãã cʉ̃ã dinerore mʉjãã cabotʉ̃goñaata, Dios yaye mʉjããrẽ cʉ̃ caátirotirijere mʉjãã ĩñatebujiorã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","26","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Mʉjãã yeri pũna pʉame, mʉjãã caʉgapee, bairi mʉjãã cajãñapee netõjãñurõ caãnimajũrĩjẽ niña. Bairi mʉjããrẽ ñiña: Ati yepa macããjẽrẽ bʉtioro bootʉ̃goñaeticõãña. Mʉjãã caʉgapeere, mʉjãã caetipeere, bairi mʉjãã cajãñapee cʉ̃ãrẽ bʉtioro tʉ̃goña macãẽtĩcõãña. Minia na caátiãnierẽ mʉjãã masĩña. Na caʉgapeere oteetiyama. Tunu na caʉgapeere cabʉtiro ĩña, jeetiyama. Na caʉgapeere jeri wiipʉ qũẽnocũẽtĩnucũñama. Bairo na caáperimiatacʉ̃ãrẽ, na caʉgapeere jonucũñami Dios. ¡Mʉjãã roquere minia netõrõ mʉjãã maiñami Dios! Bairi ãme mʉjãã caãnierẽ tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni ũcʉ̃ mʉjãã mena macããcʉ̃, cʉ̃ catʉ̃goñamacãrĩjẽ jʉ̃gori, ‘Yʉ bʉtinemogʉ jĩcã metro recomacã majũ, ʉ̃mʉaʉ ãnigʉ,’ ĩ masĩẽtĩñami. Mʉjãã catʉ̃goñamacããrĩjẽ jʉ̃gori mʉjãã átimasĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bairi, ¿nopẽĩrã mʉjãã cajãñapeere mʉjãã tʉ̃goñarĩqũẽ paiyati? Oó, tataboaro macããjẽ cabairije cʉ̃ãrẽ mʉjãã masĩña. Oó pʉame paaetinucũña. Eetinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bairo áperimirõcʉ̃ã, caroa bauya. Quetiupaʉ rey Salomón ãnacʉ̃ caroa majũ cʉ̃ cajutii jãñarĩqũẽ netõjãñurõ caroa bauya oó pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bairo tie taa ũnie Dios cʉ̃ caqũẽnorĩqũẽ jĩcã rʉ̃mʉ caroa cabaumiatacʉ̃ãrẽ, ape rʉ̃mʉ peeropʉ joeyama camasã, peero riorã. Mʉjããrẽ taa ũnie netõjãñurõ mʉjãã maiñami Dios. Bairi mʉjãã cajãñapeere mʉjãã jogʉmi yua. ¡Mʉjãã, Dios mena catʉ̃goñatutuaenarẽ bairo majũ mʉjããrẽ ñiñaña! ");
INSERT INTO cbcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bairi mʉjãã cabopacarijere tʉ̃goña macãẽtĩcõãña. ‘¿Ñerẽ marĩ ʉgarãati?’ o ‘¿Ñerẽ marĩ etirãati?’ o ‘¿Nerẽ marĩ jãñarãati?’ ĩ tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diore caĩroaena pʉame na caʉgapeere, bairi na caetipee cʉ̃ãrẽ tʉ̃goña macãnucũñama. Mʉjãã roque narẽ bairo baieticõãña. Marĩ Pacʉ Dios ʉmʉrecóo macããcʉ̃ marĩ cabopacarijere masĩpeyocõãñami. Bairi tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dios cʉ̃ carotimasĩrĩpaʉ roquere tʉ̃goñaña. Dios cʉ̃ carotirore bairo ása. Bairo mʉjãã caápata, ati yepa macããjẽ nipetirije mʉjãã cabopacarije cʉ̃ãrẽ mʉjãã jogʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tocãnacã rʉ̃mʉ ricaati capee wãme baicõã niña. Bairi ñamirõcã mʉjãã caátipeere tʉ̃goña macãẽtĩcõãña. Ñamirõcã caetaro roque mʉjãã caátipee ũnierẽ mʉjãã masĩgarã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Aperã noo na caátiere roro bʉsʉpaieticõãña, mʉjããrẽ Dios cʉ̃ã mʉjãã caátiere, ‘Roro átiyama,’ cʉ̃ caĩetiparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dios pʉame aperã na caátiãnierẽ roro mʉjãã cabʉsʉpairo cãrõ, mʉjãã ĩroaetigʉmi. Tunu bairoa aperãrẽ na mʉjãã catuticõñarõ cãrõ jĩcãrõ tʉ̃ni mʉjãã cʉ̃ãrẽ mʉjãã tutigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Tunu bairoa jĩcãʉ̃ caʉ̃mʉ cʉ̃ baire, ‘Mʉ caapeapʉ pũrõãcã jãñaña. Yʉ nerocapa,’ qũĩñupʉ̃. Bairo qũĩmicʉ̃ã, cʉ̃ pʉame tutu majũ cʉ̃gocõãñami cʉ̃ caapeapʉ. Tore bairo baiyami jĩcãʉ̃ ũcʉ̃ pairo roro caátacʉ, cʉ̃ cʉ̃ã petoaca roro caátacʉre, ‘Roro mʉ baiya,’ cʉ̃ cʉ̃ caĩbʉsʉpaiata. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Caĩtopairã mʉjãã ãniña! Torena, mʉjãã pʉame roque rejʉ̃goya mʉjãã carorijere. Bairo átiri bero roque, mʉjãã quetibʉjʉ masĩgarã aperã rorije na caátiere. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tunu bairoa caroa majũrẽ marĩ joetiya wii yaiare. Tunu perlas caroa cabotiri rupaaca cʉ̃ãrẽ yeseapʉre marĩ wẽjoetiya. Bairo marĩ caápata, tiere peabato recoagarãma. Torea bairo Dios yaye bʉsʉrique caroa majũ to caãnimiatacʉ̃ãrẽ, wii yaia, bairi yeseare bairo caãnarẽ bairo catʉ̃gogaenarẽ na quetibʉjʉeticõãña, caroa quetire roro na bʉsʉeticõãto, ĩrã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Noa ũna na cajẽniata, na cajẽnirĩjẽrẽ bócamasĩgarãma. Tunu bairoa apeye ũnierẽ na camacãata, na camacãrĩjẽrẽ bócamasĩgarãma. Tunu jopepʉ na capiiata, ti wii upaʉ pʉame ti jopere pããgʉmi. Bairi tore bairo Diore mʉjãã cajẽniata, mʉjãã caãnimasĩpeere jogʉmi. Bairi Diore mʉjãã cajẽnirõ ñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mʉjãã, capũnaacʉna mʉjãã pũnaa pan rupare na cajẽniata, ¿ʉ̃tã rupare na mʉjãã jobujiocʉti? Bairo mʉjãã áperã. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tunu bairoa waire na cajẽniata, ¿ãña ũcʉ̃rẽ na mʉjãã jobujiocʉti? Bairo mʉjãã áperã. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉjãã, carorã nimirãcʉ̃ã, mʉjãã pũnaarẽ caroa wãmerẽ mʉjãã jomasĩnucũña. Marĩ Pacʉ Dios ʉmʉrecóo macããcʉ̃ roque caroʉ́ majũ niñami. Camasã netõrõ caroʉ́ niñami. ¡Bairi noa ũna cʉ̃rẽ cajẽnirãrẽ na jogʉmi caroa ũnie majũrẽ! ");
INSERT INTO cbcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bairi aperã mʉjãã na caátore mʉjãã caborore bairo na cʉ̃ãrẽ na nʉcʉ̃bʉgoya. Tore bairo marĩ ĩ quetibʉjʉ cũñañupã Moisés ãnacʉ̃ bairi profeta majã cʉ̃ã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Ati yepapʉ mʉjãã caãno, pʉga jopeere bairo niña. Jĩcã jope, pairi jope niña. Ti jope jããetaricaro esari wãã baucoaya. Bairo caroa wãã baumirõcʉ̃ã, ti wãã yapapʉ camasã na cayasipapaʉ niña. Bairo cabaimiatacʉ̃ãrẽ, camasã capããrã ti jopere pããjããrĩ ti wããrẽ ánucũñama. Ape jope cʉ̃ã niña õcã jopeaca. Ti jope jããetaricaro esaeti wãã baucoaya. Bairo cabairi wãã nimirõcʉ̃ã, ti wãã yapapʉ camasãrẽ tocãnacã rʉ̃mʉa caroaro na canetõpapaʉ niña. Bairo cabaimiatacʉ̃ãrẽ, camasã petoaca ti jopere pããjããrĩ ti wããrẽ áyama. Mʉjãã pʉame roque na mena mʉjãã caátó yʉ boya,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “ ‘Dios yaye bʉsʉriquere mʉjããrẽ jãã quetibʉjʉgarã,’ jĩcããrã mʉjããrẽ na caĩmiatacʉ̃ãrẽ, bairo mʉjããrẽ ĩtogarã baiyama. Na tʉ̃goʉsaeticõãña. Ovejare bairo nurĩcãrã baumirãcʉ̃ã, macãnʉcʉ̃ yaia, cauwarã majũrẽ bairo caãna niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Marĩ caʉgarije ʉse cʉ̃ãrẽ marĩ jeetiya pota yucʉpʉ. Tunu bairoa ʉgarique, higuera na caĩrĩjẽ cʉ̃ãrẽ marĩ jeetiya pota wopʉ. Torea bairo caĩtopairã ricaati na caátiãnierẽ ĩñarĩ, ‘Naana, caĩtopairã niñama,’ mʉjãã ĩ masĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tunu tocãnacãʉ̃pʉa yucʉ caroʉ́ pʉame caroare rícacʉtiya. Apei yucʉ caroricʉ roque carorijere rícacʉtiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yucʉ caroʉ́ pʉame carorijere ríca cʉperiya. Tunu bairoa apei yucʉ caroricʉ caroa ríca cʉperiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bairi camasã tocãnacãʉ̃ã caroaro na caápericõãta, jĩcãʉ̃ yucʉ, caríca maniirẽ quetíjoerocacõãrĩcãrõrẽ bairo na átirecõãgʉmi Dios na cʉ̃ãrẽ. Petoaca rʉsaya Dios camasãrẽ cʉ̃ caĩñabesepa rʉ̃mʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tore bairo camasã na caátiãnierẽ ĩñamasĩrĩ tore bairo caátiãnarẽ na mʉjãã ĩ masĩgarã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Tocãnacãʉ̃pʉa, ‘Jãã Quetiupaʉ’ yʉre caĩrã nimirãcʉ̃ã, jĩcããrã na mena macããna ápérigarãma Dios cʉ̃ carotimasĩrĩpaʉpʉre. Noa ũna, yʉ Pacʉ ʉmʉrecóo macããcʉ̃ cʉ̃ carotirore bairo caáticõãna roque ágarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ti rʉ̃mʉ camasãrẽ Dios na cʉ̃ caĩñabesepa rʉ̃mʉ caetaro ĩña, atore bairo ñigarãma capããrã camasã yʉre: ‘Jãã Quetiupaʉ, jãã cʉ̃ã mʉ yaye bʉsʉriquere jãã quetibʉjʉnetõwʉ̃ camasãrẽ. Tunu bairoa mʉ wãme mena ĩrĩ, wãtĩ yeri pũnarẽ na jãã acuwiyojowʉ. Capee jãã átijẽñowʉ̃ mʉ camasĩrĩjẽ mena. Jããrẽ mʉ masĩĩ,’ ñimigarãma ti rʉ̃mʉ caetaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bairo na caĩmiatacʉ̃ãrẽ, atore bairo ñigʉ: ‘Mʉjãã yʉ masĩẽtĩña. Bairi ánája. ¡Mʉjãã carorije cacʉ̃gorã ãnirĩ yʉ mena mʉjãã ãmerĩgarã yua!’ na ñigʉ caĩtori majãrẽ,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ĩ quetibʉjʉ yaparo, ape wãmerẽ ĩcõñarĩ na ĩnemoñupʉ̃ tunu Jesús: “Ni ũcʉ̃ yʉ yaye quetire tʉ̃gori, cabero yʉ caĩrõrẽ bairo caácʉ atore bairo niñami: Tutuari wiire caqũẽnoʉrẽ bairo camasĩ niñami. Camasĩ pʉame cʉ̃ ya wiire ʉ̃tã bui qũẽnoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bairi cabero oco pairo caocaro, ria puta, wiipʉ etayuparo yua. Wĩno cʉ̃ã bʉtioro papuyuparo. Bairo cabaimiatacʉ̃ãrẽ, ti wii pʉame toa nicõãñuparõ. Wii botare cayepa ʉsʉropʉ nʉcõrĩ cʉ̃ caqũẽnorĩcã wii ãnirĩ toa nicõãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tunu bairoa apei cʉ̃ã yʉ yaye quetire tʉ̃gogaetiri, yʉ caĩrõrẽ bairo caápei atore bairo niñami: Tutuaeti wiire caqũẽnoʉrẽ bairo caãcʉ̃ niñami. Catʉ̃goñamasĩẽcʉ̃ ãnirĩ ʉ̃tã bui mee, paputiropʉ cʉ̃ wiire qũẽnoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bairi cabero oco pairo caocaro, ria puta, wiipʉ etayuparo. Wĩno cʉ̃ã bʉtioro papuyuparo. Bairo cabairoi yua, ti wii pʉame pecoasuparo. Wii botare cayepa ʉsʉetopʉ nʉcõrĩ cʉ̃ caqũẽnorĩcã wii ãnirĩ, ¡ñe mano ñapeticoasuparo!” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bairo camasãrẽ na ĩ quetibʉjʉ yaparo yua, nipetirã cʉ̃ yaye quetire catʉ̃gorã etarã pʉame cʉ̃ tʉ̃gocõã maniásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús pʉame Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majãrẽ bairo camasãrẽ na quetibʉjʉesupʉ. Carotimasĩ cʉ̃ caquetibʉjʉrore bairo na quetibʉjʉyupʉ. Bairi cʉ̃ yaye quetire tʉ̃gori, cʉ̃ tʉ̃gocõã maniásuparã nipetiro camasã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bairo Jesús ʉ̃tãʉ̃pʉ caãniatacʉ tunu ruiasúpʉ. Bairo cʉ̃ caruiató, capããrã camasã cʉ̃ bero ʉsayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bairo cabairo, jĩcãʉ̃ carupaʉ boaʉ pʉame Jesutʉ cʉ̃ rʉpopaturi mena etanumurĩ qũĩroaʉ etayupʉ. Bairo eta, atore bairo qũĩ jẽniñupʉ̃: —Yʉ Quetiupaʉ, mʉ cabooata, yʉ mʉ netõõgʉ yʉ caboariaye cʉtiere. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Bairo cʉ̃ caĩjẽnirõ tʉ̃go, Jesús pʉame cʉ̃ wãmo mena cʉ̃ pãñañupʉ̃. Bairo áticõã, atore bairo qũĩñupʉ̃ Jesús: —Mʉ cacatiro yʉ boya. ¡Bairi mʉ yʉ netõõña! —qũĩñupʉ̃ cariaʉre. Bairo Jesús cʉ̃ caĩrõ, jicoquei caticoasupʉ carupaʉ boamiatacʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bairo qũĩnemoñupʉ̃ tunu Jesús: —Tʉ̃goya. Aperãrẽ na quetibʉjʉeticõãña mʉrẽ yʉ canetõatajere. Cariape acoácʉ́ja sacerdote tʉpʉ. Qũĩñoña mʉ rupaʉ, mʉ cacatiatajere. Bairo tunu Diore cʉ̃ nuniña mʉ cacatirije wapare. Tore bairo marĩ átirotiyupi Moisés ãnacʉ̃. Bairo mʉ caátiatato bero, nipetiro camasã masĩgarãma mʉ cacatiatajere yua —qũĩñupʉ̃ Jesús carupaʉ boamiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cabero Capernaum na caĩrĩ macãpʉ etayupʉ Jesús. Bairo cʉ̃ caetaro tʉ̃go, jĩcãʉ̃, romano soldaua quetiupaʉ capitán majũ cʉ̃tʉ etayupʉ, cʉ̃ jẽniñagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Atore bairo qũĩñupʉ̃: —Yʉ Quetiupaʉ, yʉ paabojari majõcʉ jĩcãʉ̃ riajãñuñami. Ámasĩẽtĩñami. Cʉ̃ ñicããrĩ bʉʉjãñuñami. Cʉ̃ rupaʉ cʉ̃ãrẽ bʉtioro wisiojãñuñami —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Mʉ mena, mʉ ya wiipʉ yʉ ágʉ. Mʉ paabojari majõcʉre yʉ catiobojaʉágʉ́ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ soldaua quetiupaʉ capitán Jesure: —Yʉ Quetiupaʉ, yʉ mena mʉ ápéi. Mʉ, caãnimajũʉ̃ mʉ ãniña. Yʉ pʉame roque mʉrẽ bairo yʉ baietiya. Bairi yʉ ya wiire mʉ cajããrõ ñuetõ. Atopʉa ãcʉ̃, “Cʉ̃ catiáto,” mʉ caĩjoro jeto ñurõ. Bairo mʉ caĩrõ, caticoagʉmi yʉ yaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yʉ netõjãñurõ carotirã na carotiricʉ yʉ ãniña. Tunu bairoa yʉ cʉ̃ã quetiupaʉ ãnirĩ yʉ ʉ̃mʉarẽ na yʉ rotimasĩnucũña. Bairi “Tiaya,” yʉ caĩrõ, jicoquei atínucũñama. Tunu “Ánája,” yʉ caĩrõ, jicoquei ánucũñama. Tunu “Bairo ása,” yʉ paabojari majãrẽ yʉ caĩrõ, jicoquei yʉ caĩrõrẽ bairo átinucũñama —qũĩñupʉ̃ quetiupaʉ capitán Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bairo cʉ̃ caĩrõ tʉ̃go, Jesús pʉame tʉ̃goacʉacoasupʉ. Bairi cʉ̃rẽ caʉsarãrẽ na ãmejore ĩñarĩ, atore bairo na ĩñupʉ̃: —Mʉjããrẽ cariape ñiña: Ato Israel yepa macããna jĩcãʉ̃ ũcʉ̃ ãnirẽ bairo yʉ mena catʉ̃goñatutuaʉre yʉ bócaetañaẽtĩña. Cʉ̃ pʉame tʉ̃goñatutuajãñuñami Dios cʉ̃ carotimasĩrĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tunu cariape ñinemoña: Ape rʉ̃mʉ capããrã camasã romano majõcʉ ũna muipʉ cʉ̃ cawãmʉatópʉ caatíatana, bairi muipʉ cʉ̃ cañajãátopʉ caatíatana cʉ̃ã nipetiropʉ caatíatana etari, marĩ ñicʉ̃jãã, Abraham, Isaac, Jacob mena mesapʉ ruigarãma. Judío majã caãmerã na caãnimiatacʉ̃ãrẽ, na mena ʉga bapacʉtigarãma Dios cʉ̃ carotimasĩrĩpaʉ caetaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bairo caroaro na mena na caʉga bapacʉtimiatacʉ̃ãrẽ, aperã capããrã judío majã Dios cʉ̃ carotimasĩrĩpaʉre caetabujioatana pʉamerẽ canaitĩãrõpʉ na joregʉmi Dios, cʉ̃ mena na catʉ̃goñatutuaetie wapa. Bairi capããrã topʉ otigarãma. Na opire bacarʉpotugarãma, bʉtioro yapapuarã yua —na ĩñupʉ̃ Jesús cʉ̃ bero caʉsarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ĩ quetibʉjʉ yaparo, atore bairo qũĩnemoñupʉ̃ tunu soldaua quetiupaʉ capitárẽ: —Tunu ácʉ́ja mʉ ya wiipʉ. Tore bairo yʉ mena mʉ catʉ̃goñatutuarore bairo to baiáto. Mʉ paabojari majõcʉ caticoagʉmi —qũĩñupʉ̃. Tocãrõã bairo cʉ̃ caĩrõ, jicoquei caticoasupʉ capitán paabojari majõcʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cabero acoásúpʉ Jesús, Pedro cawãmecʉcʉ ya wiipʉ. Bairo ti wii jããetari Pedro mañicõrẽ cõ ĩñañupʉ̃. Cõ pʉame riao baiyupo. Bʉtioro bʉgoyupo. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bairo cõ cabairo ĩña, cõ wãmorẽ pãñañupʉ̃. Bairo cʉ̃ caátoa, jicoquei yua jãnacoasuparo bʉgoye pʉame. Tocãrõã caticoasupo. Bairo catiácó yua, tocãrõã ʉgariquere na qũẽnonuñupõ Jesujããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cabero canaioatípaʉ Pedro ya wiipʉre etayuparã nipetiro ti macã macããna. Wãtĩ yeri pũnarẽ cacʉ̃gorãrẽ na jeasúparã Jesús tʉpʉ. Bairo Jesús na caetaro ĩña, wãtĩ yeri pũnarẽ na acurewiyojoyupʉ. Jĩcãnia cʉ̃ caĩrõ witicoásúparã. Tunu bairoa nipetiro cariayecʉnarẽ na catioyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bairo profeta Isaías ãnacʉ̃ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiyuparo. Atore bairo ĩ quetibʉjʉ woatucũñañupĩ Isaías: “Marĩ riayere, popiye marĩ cabairije nipetirijere marĩ netõbojagʉmi,” ĩ quetibʉjʉ woatucũñañupĩ Isaías ãnacʉ̃ Jesús cʉ̃ caátipeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cabero camasã capããrã majũ Jesús tʉpʉre ĩñanucũ ãmejoreyuparã. Bairo na cabairo ĩñarĩ, Jesús pʉame, “Ʉtabʉcʉra ape nʉgõãpʉ marĩ pẽña átóca,” na ĩñupʉ̃ cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bairo na caápáro jʉ̃goye, jĩcãʉ̃ Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuei pʉame Jesure qũĩñupʉ̃: —Cabuei, yʉ cʉ̃ã mʉ cabuei yʉ ãnigaya. Bairi noo mʉ cañesẽãrõpʉ yʉ ágʉ yʉ cʉ̃ã —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Macãnʉcʉ̃ macããna waibʉtoa na caãnipaʉri cʉ̃goyama. Minia cʉ̃ã na riabatiri na caãnipaʉrire cʉ̃goyama. Bairo na cacʉ̃gomiatacʉ̃ãrẽ, yʉa, Camasã Jʉ̃gocʉ, yʉ caãnipaʉ ũno yʉ cʉ̃goetiya —qũĩñupʉ̃ Jesús caʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bairi apei Jesús berore caʉsaʉ pʉame atore bairo qũĩñupʉ̃: —Yʉ Quetiupaʉ, mai mʉ mena yʉ bapacʉperigʉ. Yʉ pacʉre cʉ̃ cotei ácʉ yʉ baiya. Cʉ̃ cariacoato bero roque, mʉ mena yʉ ábujioʉ —qũĩñupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, Jesús pʉame bairo qũĩñupʉ̃: —Ãmerẽ yʉ mena mʉ cabapacʉto yʉ boya. Camasã cariacoatanarẽ bairo caãna pʉame na qũẽnoáto cabaiyasirãrẽ —qũĩñupʉ̃ Jesús jĩcãʉ̃ cʉ̃rẽ caʉsagamirẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bairo cʉ̃ caĩrõ bero, Jesús pʉame cũmua capairicapʉ ájããñupʉ̃. Bairo cʉ̃ caájããrõ ĩñarã, cʉ̃ cabuerã cʉ̃ã ájããñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bairo ájãã yua, ti ʉtabʉcʉrapʉ pẽñacoásúparã. Bairo na caátó yua, wĩno pairo papu atíjʉ̃goyuparo. Bairo capapuro ocoturi pairo atíjabejããñuparõ, cũmua ruagari tʉ̃nipʉ yua. Mai, Jesús pʉame na caátó beroaca cãnijããcoasupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bairo cʉ̃ cabairoi, cʉ̃ cabuerã pʉame cʉ̃ wãcõñuparã. Cʉ̃ wãcõrĩ atore bairo qũĩñuparã Jesure: —¡Jããrẽ cabuei, jãã netõõña! ¡Ruarã marĩ baiya! —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bairo na caĩwãcõrõ tʉ̃go, bairo na ĩñupʉ̃: —¿Nopẽĩrã bʉtioro mʉjãã uwiyati? ¡Dios mena mʉjãã tʉ̃goñatutuaetimajũcõãña! —na ĩñupʉ̃. Ĩ yaparo, wãmʉnʉcãrĩ yua, wĩnorẽ jãnarotiyupʉ. Tunu bairoa oco turi cʉ̃ãrẽ jãnarotiyupʉ. Bairo cʉ̃ caáto, jicoquei jãnapeticoasuparo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bairo cʉ̃ caáto ĩña, cʉ̃ cabuerã pʉame qũĩñacõã maniáti, atore bairo ãmeo ĩñuparã na majũ: —¡Ago tame! ¿Ñamʉ ũcʉ̃ cʉ̃ ãniñati Jesús? Wĩno, ocoturi cʉ̃ã cʉ̃ tʉ̃gocõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cabero ti ʉtabʉcʉra ape nʉgõãpʉ pẽñaetayuparã Jesujãã, Gadara na caĩrĩ yepapʉ. Bairo eta yua, maanʉcãñupʉ̃ Jesús. Bairo cʉ̃ camaanʉcãrõ, pʉgarã caʉ̃mʉa wãtĩ yeri pũna cacʉ̃gorã pʉame cʉ̃tʉ etayuparã. Camasãrẽ na carerica ʉ̃tã wiiripʉ caãniatana cʉ̃tʉ etayuparã. Mai, na pʉame cauwiorã majũ ãñuparã. Bairi camasã pʉame tipaʉre netõámasĩẽtĩnucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bairi yua, na, caʉ̃mʉa pʉame Jesús cʉ̃ camaanʉcãrõ ĩña, bairo qũĩ awajayuparã: —¿Mʉ, Dios macʉ̃, ñerẽ acʉ́ mʉ atíati jãã tʉre? ¿Dios popiye jããrẽ cʉ̃ caátipa rʉ̃mʉ jʉ̃goye, mʉ pʉame popiye jãã baio joroque átigʉ mʉ atíati? —qũĩñuparã bʉtioro. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mai, to jʉ̃goye cayoajãñurĩpaʉpʉ capããrã yesea nurĩcãrã ʉga ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bairo na caʉgaãno, wãtĩ yeri pũna pʉame atore bairo bʉtioro qũĩñuparã Jesure: —Jããrẽ mʉ caacurewiyojomajũgaata, yesea tʉpʉ jãã árotiya. Napʉre jãã jããgarã —bʉtioro qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Bairo na caĩrõ tʉ̃go, “¡Jaʉ, topʉ ánája toroque!” na ĩñupʉ̃ Jesús, na ároti yua. Bairo cʉ̃ caĩrõ, wãtĩ yeri pũna pʉame caʉ̃mʉarẽ na witipeticoásúparã. Yeseapʉre jããrásúparã. Bairo yeseare na cajããrĩpaʉ yua, yesea ʉ̃tãʉ̃ bui caãnimiatana pʉame mecʉ̃rã ʉtabʉcʉrapʉ atʉre ñañuacoásúparã. Bairi yua, ruapeticoásuparã yesea pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bairo na cabairo ĩña, yeseare cacotemiatana pʉame acʉari acoásúparã. Bairo macãpʉ etarã, na quetibʉjʉyuparã nipetiro yesea na cabaiatajere. Tunu bairoa nipetiro wãtĩ yeri pũna cacʉ̃gomiatana na cabaiataje cʉ̃ãrẽ na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bairo tiere tʉ̃gori, camasã pʉame ĩñarásúparã cabaiatajere. Bairo topʉ etarã, Jesure qũĩña yua, bʉtioro aperopʉ cʉ̃ árotiyuparã. Na ya yepare cʉ̃ caãno boesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Bairo na caĩrõ tʉ̃go, Jesús cũmuarẽ ájããñupʉ̃ tunu. Bairo ájãã yua, ti ʉtabʉcʉra ape nʉgõãpʉ pẽñacoásúpʉ cʉ̃ cabuerã mena. Pẽñaátí yua, cʉ̃ ya macã majũpʉ etayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bairo cʉ̃ caetaro ĩña, ti macã macããna jĩcããrã Jesutʉ, ñicãrĩ cabʉʉricʉre cʉ̃ neasúparã, na canerĩ coro mena. Bairo na caató ĩña, Jesús pʉame masĩcõãñupʉ̃ cʉ̃ mena na catʉ̃goñatutuarijere. Torecʉ, atore bairo qũĩñupʉ̃ Jesús ñicãrĩ cabʉʉricʉre: —Yʉ yaʉ, caroaro ʉseanirõ ãnitʉ̃goñaña. Merẽ mʉ carorije wapare yʉ netõõcõãña —qũĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃tʉ macããna Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame bairo ĩ tʉ̃goñañuparã na yeripʉ: “Diore cʉ̃ netõnʉcãʉ̃ átiyami bairo cʉ̃ caĩrĩjẽ mena. ‘Merẽ mʉ carorije wapare yʉ recõãña,’ cʉ̃ ũcʉ̃ ĩ masĩã maa.” ");
INSERT INTO cbcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Masĩcõãñupʉ̃ Jesús cʉ̃ yeripʉ na caãmeobʉsʉrijere. Bairi atore bairo na ĩñupʉ̃: —¿Nopẽĩrã yʉ mena roro mʉjãã tʉ̃goñañati? ");
INSERT INTO cbcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","“Mʉ carorije wapare yʉ netõõña,” ãnirẽ yʉ caĩata, “Bairo ĩcõãʉ̃ ĩñami,” mʉjãã ĩbujiorã. Bairãpʉa, “Wãmʉnʉcãña,” cʉ̃rẽ yʉ caĩata, to bero cʉ̃ cawãmʉnʉcáto ĩñarã roque, “Bairo ĩcõãʉ̃ mee ĩñami Jesús,” mʉjãã ĩbujiorã. Yʉ, Camasã Jʉ̃gocʉ, ati yepapʉ yʉ carotimasĩrĩjẽrẽ mʉjãã camasĩparore bairo, tiere ñigʉ —na ĩñupʉ̃ Jesús Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majãrẽ. Ĩ yaparo, cʉ̃ caĩrõrẽ bairo qũĩnemoñupʉ̃ Jesús ñicãrĩ cabʉʉricʉre: —Wãmʉnʉcãña. Mʉ cacũñarĩ corore nepʉsari mʉ ya wiipʉ tunu ácʉ́ja. Merẽ mʉ riayere yʉ netõõña —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei wãmʉnʉcã yua, cʉ̃ ya wiipʉ acoásúpʉ cabʉʉmiatacʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bairo cʉ̃ caátó ĩña, to macããna, capããrã camasã cʉ̃ tʉ̃goñacõã maniásuparã. Bairi Diore cʉ̃ basapeoyuparã. Dios cʉ̃ camasĩrĩjẽrẽ camasãrẽ na cʉ̃ cajorijere tʉ̃goña ʉseaniñuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cabero topʉ caãniatacʉ acoásúpʉ Jesús. Bairo netõácʉ́, yʉ, ati tutire cawoatuʉ Mateo cawãmecʉcʉre ñiñajowĩ. Mai, yʉ pʉame Roma gobiernorẽ camasã yaye dinero impuestos na caĩrĩjẽrẽ jejobojari majõcʉ yʉ ãmʉ. Bairi yʉ capaari arʉapʉ yʉ caãno, ñiñajowĩ Jesús. Bairo ñiñajori bero, yʉtʉ etari atore bairo ñiwĩ yua: —Jito. Yʉ bapacʉsa. Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei yʉ pʉame Jesús mena yʉ bapacʉti acoaápʉ́ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cabero Jesús, bairi jãã, cʉ̃ cabuerã mena mesapʉ jãã caruiro, camasã capããrã ruirã etawã, yʉre bairo capaarique cʉ̃gorã, bairi aperã camasã roro na cabʉsʉpairã cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bairo jãã caʉgabapacʉtore ĩñarã yua, fariseo majã pʉame bairo jãã ĩ tutiwã: —¿Nopẽĩ dinero jejori majã mena, bairi roro caána mena mʉjããrẽ cabuei cʉ̃ etiʉga bapacʉtiyati? Roro ácʉ átiyami —jãã ĩ tutiwã fariseo majã, jãã, Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bairo na caĩtutiro tʉ̃go, bairo na ĩwĩ Jesús: —Ʉcotiri majõcʉre bairo yʉ ãniña ati wiire. Ʉcotiri majõcʉ ápériyami cacatirã na caãni wiiripʉre. Cariarã na caãni wiiri jetore etanucũñami, na ʉcoti etaʉ. Bairi ãnoa mena yʉ ãniña. Na carorije, riayere bairo caãnierẽ netõõʉ̃ ácʉ yʉ átiapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mʉjãã, ati wãmerẽ Dios cʉ̃ caquetibʉjʉcũrĩqũẽrẽ bueri mʉjãã camasĩrõ boya: “Mʉjãã, waibʉtoa riire mʉjãã cajoemʉgõrĩjẽ mee, cabopacarãrẽ na mʉjãã caĩñamairĩjẽ roquere yʉ boya,” ĩ quetibʉjʉyupi Dios cʉ̃ ya tutipʉ. Torecʉna, yʉ apʉ́ ati yepapʉre. “Caroarã marĩ ãniña,” caĩtorãrẽ na yʉ macãẽtĩña. Aperã, “Carorije wapa marĩ buicʉtiya,” caĩtʉ̃goñayapapuarãrẽ na macãʉ̃ acʉ́ yʉ apʉ́, na yeri wasoáto, ĩ —na ĩwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cabero Juan cʉ̃ cabuerã Jesús tʉpʉ etawã. Eta yua, bairo Jesure qũĩ jẽniñawã: —Jãã, bairi fariseo majã cʉ̃ã ʉgarique betiri Diore jãã ñubuenucũña. Mʉ cabuerã pʉame bairo áperiyama. ¿Nopẽĩrã na ʉgarique betietinucũñati? —qũĩ jẽniñawã Juan cʉ̃ cabuerã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩwĩ Jesús: —Caroaro yʉ caátiere mʉjãã tʉ̃gomasĩẽtĩña. Caʉ̃mʉ cawãmojiyapaʉre bairo yʉ ãniña. Cʉ̃ yarãrẽ bairo niñama yʉ cabuerã. Caʉ̃mʉ cʉ̃ cawãmojiyari rʉ̃mʉrẽ cʉ̃ yarã nipetirã ʉgayama pairo, cʉ̃ mena ʉseaniãna. Ti rʉ̃mʉrẽ aʉatãmʉoetiyama. Caʉ̃mʉ cʉ̃ cawãmojiyari rʉ̃mʉ bero roquere, cʉ̃ yarã caborã ʉgarique betiri Diore cʉ̃ tʉ̃goña jẽniñubuebujiorãma tunu. Narẽ bairo jãã ãniña. Bairi yʉ mena ãna, yʉ cabuerã aʉatãmʉoetigarãma. Yʉ camano roquere aʉatãmʉobujiorãma —na ĩ quetibʉjʉwĩ Jesús, Juan cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ĩ yaparo, “Yʉ yaye cawãma quetire cabʉcʉ macããjẽ mena tʉ̃goʉsa masĩã maniña,” ĩgʉ, atore bairi wãme na ĩcõña quetibʉjʉnemowĩ Jesús tunu: —Cabʉcʉro jutirore cawori opere seretuetiyama camasã camasĩrã jutiro cawãma asero carʉgaeti asero mena. Bairo na caápata, ñuetigaro. Cose, ti aserore bopo na caáto, rʉgagaro. Rʉgari tʉ̃gãwonemogaro paijãñurõ cawãma asero pʉame cabʉcʉro jutirore. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tunu bairoa ʉse oco cawãma qũẽnoyaparoriquere piojãẽtĩnucũñama camasã cabʉcʉ poa waibʉcʉ asero poapʉre. Bairo na caápata, ti poa wocoagaro, tie oco capãmʉrõĩ. Ti poa macããjẽ yasigaro. Bairi ʉse ocore cawãma qũẽnoyaparoriquere piojãnucũñama camasã cawãma poa mena. Bairo na caápata, ti poa tie oco cʉ̃ã nicõãña. Yasietiya —na ĩ quetibʉjʉwĩ Jesús to macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bairo narẽ cʉ̃ caquetibʉjʉãno, cʉ̃tʉ etawĩ judío majã quetiupaʉ jĩcãʉ̃. Bairo cʉ̃tʉ etari yua, rʉpopaturi mena etanumurĩ Jesure qũĩroawĩ. Atore bairo qũĩwĩ: —Jesús, yʉ macõ mepʉ riacoámó. Bairo cariacoataco cõ caãnimiatacʉ̃ãrẽ, mʉ wãmo mena cõ rupaʉri ãnajẽrẽ mʉ capãñaata, caticoagomo tunu. Bairi yʉ mena mʉ apá tãmurĩ —qũĩwĩ quetiupaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Bairo cʉ̃ caĩrõ tʉ̃go, wãmʉnʉcã yua, cʉ̃ mena acoámí. Jesús cariacoataco cõ caãnopʉ ácʉ́. Cʉ̃ cabuerã cʉ̃ã cʉ̃ mena jãã ápʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bairo jãã caátó, Jesús bero pʉame asúpo jĩcãõ carõmio pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã cʉ̃marĩ majũ cariíjãnaecõ. Bairo cʉ̃tʉ eta yua, aperã na caĩñaeto, cʉ̃ jutiro cayoaro yapaacarẽ pãñañupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mai, cõ pʉame cariape tʉ̃goñañupõ Jesús cʉ̃ cariaye netõmasĩrĩjẽrẽ. Bairo cariape tʉ̃goñarĩ yua, “Cʉ̃ jutiro cayoaro yapaacarẽ yʉ capãñaata, yʉ caticoago,” ĩ tʉ̃goñañupõ. Bairo tiere ĩ tʉ̃goñarĩ, Jesús bero pʉame atíri, tore bairo ásupo. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús pʉame cõ caátiere masĩcõãñupĩ. Bairo camasĩ ãnirĩ yua, ãmejorenʉcãrĩ, atore bairo cõ ĩwĩ: —Yʉ yao, caroaro ʉseanirõ ãnitʉ̃goñaña. Yʉ mena mʉ catʉ̃goñatutuaroi, mʉ riayere yʉ netõcõãña —cõ ĩwĩ. Bairo cʉ̃ caĩrõã, jicoquei caticoamo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cabero jĩcãʉ̃ judío majã quetiupaʉ ya wiipʉ Jesús cʉ̃ caetaro, ti wii macããna pʉame oti awajarã baiwã, cabaiyasiatacore ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bairo na cabairo ĩña, atore bairo na ĩwĩ Jesús: —Witiánája. Atio cawĩmao baiyasio mee baiyamo. Cãnio baiyamo —na ĩwĩ Jesús. Bairo cʉ̃ caĩrõ tʉ̃go, roro cʉ̃ bócaboyeticõãwã, “Merẽ yasicõãmo,” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bairo na cabaimiatacʉ̃ãrẽ, Jesús pʉame ti wiire na wiyocõãjowĩ. Áti yaparo, cariacoataco ãnacõ cõ caãni arʉapʉ jãátí yua, cõ ãnacõ wãmorĩrẽ ñewĩ. Bairo cʉ̃ caáto, cõ pʉame catitunurĩ wãmʉnʉcãcoámo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","To bero camasã nipetiro ti yepa tʉ̃ni macããna cʉ̃ã queti tʉ̃gopeticoasuparã Jesús cʉ̃ caátiatajere. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cabero topʉ caãniatacʉ acoámí Jesús tunu. Bairo cʉ̃ caátó, pʉgarã caʉ̃mʉa cacaapee ĩñaena cʉ̃ berore ʉsawã. Bairo ʉsa yua, bʉsʉrique tutuaro mena atore bairo qũĩwã: —¡Jesús, David ãnacʉ̃ pãrãmi, bopacooro jãã ĩñaña! —qũĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bairi Jesús wiire cʉ̃ cajããetaro, cacaapee ĩñaena pʉame cʉ̃tʉ etawã. Bairo na caetaro ĩña yua, atore bairo na ĩwĩ Jesús: —¿Yʉ canetõrĩjẽrẽ cariape mʉjãã tʉ̃goñañati? Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, bairo qũĩwã pʉgarãpʉa: —Jããrẽ mʉ canetõõpeere cariape jãã tʉ̃goñaña. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bairo na caĩrõ tʉ̃go, na caapeere pãñawĩ Jesús. Pãña yua, bairo na ĩwĩ: —Bairi yʉ mena mʉjãã catʉ̃goñatutuarijerea bairo to baiáto mʉjããrẽ —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bairo cʉ̃ caĩrõã, jicoquei ĩñamasĩcõãma yua. Bairo na cacatiro ĩña, Jesús pʉame bairo na ĩnemowĩ tunu bʉtioro: —Aperãrẽ na quetibʉjʉeticõãña mʉjããrẽ yʉ cacatiorijere. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bairo cʉ̃ caĩrõ tʉ̃gomirãcʉ̃ã, cabero nipetiropʉ camasãrẽ na quetibʉjʉ batocõãñupã Jesús narẽ cʉ̃ cacatioatajere. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bairo na caátó, camasã aperã Jesús tʉpʉ cʉ̃ neamá tunu apei wãtĩ yeri pũna cacʉ̃goʉre. Cʉ̃ pʉame wãtĩ yeri pũna jʉ̃gori bʉsʉmasĩẽmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bairi Jesús wãtĩ yeri pũnarẽ cʉ̃ cawiyojoro bero, caʉ̃mʉ pʉame catiácʉ bʉsʉmasĩcõámi tunu. Bairo cʉ̃ cabairo ĩña, to macããna qũĩñacõã maniáma. Bairo ãmeo ĩwã na majũ: —¡Diwatoa ũno ãni cʉ̃ cacatiorore bairo marĩ ĩñaepʉ̃ ato Israel yepapʉre! —ãmeo ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bairo na caãmeoĩmiatacʉ̃ãrẽ, fariseo majã pʉame bairo ĩwã: —Beelzebú, wãtĩã quetiupaʉ majũ cʉ̃ camasĩõrĩjẽ jʉ̃gori wãtĩã yeri pũna, camasãrẽ cajãñarãrẽ na acurewiyojo masĩñami —qũĩ bʉsʉpaiwã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Cabero áñesẽãwĩ Jesús tocãnacã macããpʉ. Bairi capairi macã, o õcã macããcã cʉ̃ãrẽ etaʉ, to macããna na cañubueneñarĩ wiipʉre na quetibʉjʉwĩ caroa queti, Dios cʉ̃ carotimasĩrĩpaʉ caetarijere. Tunu bairoa nipetiri wãme cariayecʉnarẽ na catiowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bairo capããrã camasãrẽ na ĩñarĩ yua, bopacooro na ĩñawĩ. Dope caátimasĩẽna tʉ̃goñarĩqũẽ pairique caãna na caãnoi, bopacooro na ĩñawĩ Jesús. Nurĩcãrã oveja narẽ cacotei camánarẽ bairo baiwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bairo na cabairoi, atore bairo jãã ĩwĩ Jesús, jãã, cʉ̃ cabuerãrẽ: —Oterique camasã na cajepee pairo caãnimiatacʉ̃ãrẽ, tie uparãrẽ cajʉjeparã pʉame capããrã mee niñama. Torea bairo Dios yaye quetire catʉ̃goʉsaparã capããrã na caãnimiatacʉ̃ãrẽ, marĩrẽ cajʉquetibʉjʉparã pʉame capããrã mee niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bairo na cabairoi, marĩ Pacʉ Diore mʉjãã cajẽnirõ boya. Cʉ̃ pʉame oterique Upaʉre bairo cʉ̃ yaye bʉsʉrique cajʉquetibʉjʉ batoparãrẽ na jomasĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Cabero Jesús, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ cʉ̃ caquetibʉjʉrotijoparãrẽ jãã besewĩ. Bairo jãã bese yua, jãã jowĩ masĩrĩqũẽrẽ. Wãtĩã yeri pũnarẽ wiyomasĩrĩqũẽrẽ, bairi tocãnacã wãmepʉrea riaye netõmasĩrĩqũẽ cʉ̃ãrẽ jãã jowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bairi pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ jãã ãmʉ Jesús cʉ̃ caquetibʉjʉrotijoparã. Cajʉ̃goye ãmi Simón. Simorẽã qũĩwĩ Jesús tunu “Pedro”. Tunu cabero ãmi Pedro bai, Andrés cawãmecʉcʉ. Cʉ̃ bero ãma Zebedeo pũna, Santiago, bairi cʉ̃ bai Juan mena. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Tunu cabero ãma Felipe, Bartolomé, Tomás, Mateo. Yʉ, Mateo pʉame Roma macããnarẽ, camasã yaye dinerore jejobojari majõcʉ caãnimirĩcʉ̃ yʉ ãmʉ. Tunu cabero ãmi Alfeo macʉ̃ Santiago cawãmecʉcʉ. Tunu cabero ãmi Tadeo. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Tunu cabero ãmi Simón. Cʉ̃ pʉame ãmi jĩcãʉ̃ celotea mena macããcʉ̃. Cabero ãmi Judas Iscariote. Cʉ̃ pʉame ãmi Jesure cañerotipaʉ. Tocãnacãʉ̃ã jãã ãmʉ Jesús cʉ̃ caquetibʉjʉrotijoparã, cʉ̃ cabeseatana yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bairo, Jesús pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ, jãã, cʉ̃ cabuerãrẽ jãã bese yaparo, camasãrẽ jãã quetibʉjʉ rotijowĩ. Bairo jãã quetibʉjʉ rotijori yua, cariape atore bairo jãã ĩwĩ: “Judío majã caãmerã na caãnopʉ mʉjãã cañesẽãrõ yʉ boetiya. Tunu bairoa Samaria yepa macããna na caãni macããrĩpʉ cʉ̃ãrẽ mʉjãã cañesẽãrõ yʉ boetiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ati yepa Israel macããna oveja nurĩcãrã cayasiricarãrẽ bairo caãna niñama. Na caãno pʉamerẽ mʉjãã caáñesẽãrõ yʉ boya. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bairo na mena ãna, atore bairo na ĩ quetibʉjʉya: ‘Dios cʉ̃ carotimasĩrĩpaʉ merẽ etaro baiya.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tunu bairoa cariayecʉnarẽ na catioya. Bairi cariacoatana cʉ̃ãrẽ tunu na cationemoña. Bairi na rupaʉ caboarã cʉ̃ãrẽ na catioya. Tunu bairoa wãtĩ yeri pũna camasã rupaʉpʉ caãnarẽ na acurewiyojoya. Yʉ camasĩrĩjẽrẽ wapa mano mʉjããrẽ yʉ joya. Bairi wapa mano cabopacarãrẽ na jʉátinemoña mʉjãã cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Tunu bairoa oro, plata, cobre moneda tiirire jeápéricõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tunu bairoa wasopoa, apeye ũnierẽ mʉjãã cajããrĩ poa cʉ̃ãrẽ jeápéricõãña. Tunu jutiro, mʉjãã cawasoaparo cʉ̃ãrẽ jeápéricõãña. Rʉpo jutii, mʉjãã cawasoapee, bairi tuericʉ cʉ̃ãrẽ mʉjãã cajeátó yʉ boetiya. Mʉjãã, paari majã ãnirĩ mʉjãã ʉgamasĩña noo mʉjãã caátópʉ na canurĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bairi noo cabori macã, o peeti macããcã camasã na caãnopʉ etarã, ‘¿Ni caroʉ́ cʉ̃ ãniñati?’ ti macã macããnarẽ na ĩ jẽniñajʉ̃goya. Bairo cʉ̃ ũcʉ̃rẽ masĩ yua, cʉ̃ ya wiipʉ mʉjãã ãnicõãwã. Capee wiiripʉ patowãcõ ñesẽãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bairi ti wii jããetarã yua, ‘Dios caroa yericʉtaje cʉ̃ joáto ati wii macããnarẽ,’ na mʉjãã ĩgarã ti wii macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bairo mʉjãã caĩjẽnirõ, na pʉame cʉ̃ã caroaro mena mʉjããrẽ na cajẽniata, Diore na mʉjãã cajẽnibojari wãmerẽ bairoa caroa yericʉtajere na jogʉmi Dios. Bairo mʉjãã caĩjẽnimiatacʉ̃ãrẽ, caroaro mena mʉjããrẽ na cajẽnieticõãta, Diore na mʉjãã cajẽnibojari wãmerẽ bairo caroa yericʉtajere na joetigʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bairo ti wii upaʉ cʉ̃ mena mʉjãã cabapacʉto cʉ̃ caboeticõãta, o mʉjãã yaye quetire cʉ̃ catʉ̃gogaeticõãta, cʉ̃ mena ãmerĩcõãña. Bairi yua, cʉ̃ ya wiire witirã, o cʉ̃ ya macãrẽ witiáná, cʉ̃ macã ñerĩ mʉjãã rʉpo jutii macããjẽrẽ mʉjãã paregarã, ‘Roro jããrẽ mʉ átiapʉ,’ ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cariape mʉjããrẽ ñiña: To macããna mʉjããrẽ na catʉ̃gogaetie wapa Dios pʉame roro na átigʉmi. Camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉ caãno Sodoma, Gomorra macãã macããna netõjãñurõ popiye na baio joroque na átigʉmi yua,” jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu: “Tʉ̃goya, ãmerẽ mʉjããrẽ caroa quetire yʉ quetibʉjʉ rotijoya. Ovejas nurĩcãrã, macãnʉcʉ̃ macããna lobos cauwiorã watoa na caãnorẽ bairo watoare mʉjãã yʉ joya. Bairi ãña cʉ̃ camasĩrõrẽ bairo tʉ̃goñamasĩña mʉjãã cʉ̃ã. Bairo baimirãcʉ̃ã, bua ñerẽ caápei cʉ̃ cabairore bairo mʉjãã caãno yʉ boya. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Diore caĩroaena na caátiãnierẽ tʉ̃goñamasacatiya. Na pʉame mʉjããrẽ ñerĩ, na quetiuparã tʉpʉ mʉjããrẽ jeágarãma. Aperã cʉ̃ã na cañubueri wiiripʉ mʉjãã bapegarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bairi yʉ yarã mʉjãã caãno jʉ̃gori na pʉame mʉjããrẽ roro na catutiparore bairo ĩrã, quetiuparã gobernadores, bairi quetiuparã reyes tʉpʉ cʉ̃ãrẽ mʉjããrẽ jeágarãma. Bairo na caátimiatacʉ̃ãrẽ, na ũnarẽ, bairi judío majã caãmerã cʉ̃ãrẽ yʉ yaye quetire nemojãñurõ mʉjãã quetibʉjʉ masĩgarã bairãpʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bairo mʉjããrẽ na cañerõ, uwirã, ‘¿Dope bairo na marĩ ĩrãati?’ ĩ tʉ̃goña macãẽtĩcõãña. Tipaʉ caetaro ĩña, Dios pʉame mʉjãã caĩmasĩpeere mʉjãã jogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mʉjãã catʉ̃goñamasĩrĩjẽ mena mʉjãã quetibʉjʉetigarã. Marĩ Pacʉ Dios mena macããcʉ̃, Espíritu Santo cʉ̃ camasĩõrĩjẽ jʉ̃gori roque mʉjãã quetibʉjʉgarã camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tipaʉ caãno, jĩcãʉ̃ pũnaa caãna nimirãcʉ̃ã, ãmeo bʉsʉjãbuitirecõãgarãma. Bairo ána, gobiernorẽ na ñerotiri pajĩãrerotigarãma. Tunu apei cʉ̃ã cʉ̃ macʉ̃rẽ torea bairo cʉ̃ átirotigʉmi. Tunu jĩcãʉ̃ pũnaa na pacʉare boetiri, na pajĩãrerotigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bairi yua, ati ʉmʉrecóo macããna nipetiro mʉjããrẽ ĩñategarãma, yʉ yarã mʉjãã caãnoi. Bairo mʉjããrẽ na caĩñatemiatacʉ̃ãrẽ, ni ũcʉ̃ mʉjãã mena macããcʉ̃ yʉ yaye quetire jĩcã wãmeacã ũno cʉ̃ cajãnaeticõãmata, cʉ̃ netõgʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bairi jĩcã macã macããna yʉ yaye bʉsʉriquere tʉ̃gogaena, roro mʉjããrẽ na caápata, ape macãpʉ ruti ánája. Cariape mʉjããrẽ ñiña: Israel yepa macããrĩ tocãnacã macããpʉre mʉjãã caquetibʉjʉpeyoparo jʉ̃goyepʉa, merẽ yʉ, Camasã Jʉ̃gocʉ nemo yʉ tunuatígʉ ati yepapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ bueri majõcʉ, cʉ̃rẽ cabuei netõrõ masĩẽtĩñami. Tunu ni jĩcãʉ̃ ũcʉ̃ paabojari majõcʉ cʉ̃ quetiupaʉ netõrõ rotimasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bairi ni jĩcãʉ̃ ũcʉ̃ bueri majõcʉ, cʉ̃rẽ cabueire bairo popiye cʉ̃ cabaigaeticõãta, ñuetõ. Torea bairo ni jĩcãʉ̃ ũcʉ̃ paabojari majõcʉ, cʉ̃ quetiupaʉre bairo popiye cʉ̃ cabaigaeticõãta, ñuetõ. Bairi jĩcã wii upaʉre, ‘Wãtĩ quetiupaʉ, Beelzebú cawãmecʉcʉ mʉ ãcʉ̃,’ cʉ̃ na caĩata, netõjãñurõ na ĩñategarãma caĩbʉsʉpairã ti wii upaʉ yarãrẽ,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu: “Bairi yʉ yarã, mʉjããrẽ caĩñaterãrẽ na uwieticõãña. Nipetiro ãme caãna na catʉ̃goñarĩjẽ nipetirijere masĩõpeyocõãgʉmi Dios. Baujaro nigaro mʉjãã yeripʉ mʉjãã catʉ̃goñarĩjẽ nipetirije. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bairo bairi yasioro mʉjããrẽ yʉ caĩrĩqũẽ cʉ̃ãrẽ nipetiro camasãrẽ na quetibʉjʉya bʉsʉrique tutuaro mena. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bairi yʉ yarã, mʉjããrẽ capajĩãreyasiogarã ũnarẽ na uwieticõãña. Bairo pajĩãremasĩmirãcʉ̃ã, dope bairo átimasĩẽtĩñama mʉjãã yeri pũna caãnipeere. Dios pʉame camasã na cayasiparo, caʉ̃petietopʉ na yeri pũnarẽ jomasĩñami. Bairi Dios pʉame roquere cʉ̃ uwiri jĩcãrõ tʉ̃ni caroaro ása. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Tunu pʉgarã minia, jĩcã moneda tiiaca wapacʉtiyama. Bairi petoaca wapacʉtimirãcʉ̃ã, ni jĩcãʉ̃ mini ũcʉ̃ Dios cʉ̃ caĩñarĩcãnʉgõẽcʉ̃ maami. Bairi marĩ Pacʉ Dios, ‘Bairo cʉ̃ baiáto,’ cʉ̃rẽ cʉ̃ caĩẽtĩcõãta, ni jĩcãʉ̃ mini ũcʉ̃ riayasietigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mʉjãã cʉ̃ã mʉjãã cabaipee nipetirijere ĩñaʉsagʉmi Dios. Mʉjãã poawẽrĩ cʉ̃ãrẽ nipetiro cõõñapeyo masĩcõãñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bairi, ‘Marĩ cabairijere masĩẽcʉ̃mi Dios,’ ĩ tʉ̃goñaeticõãña. Minia netõjãñurõ mʉjãã maiñami Dios. Bairi uwieticõãña,” jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu: “Ni jĩcãʉ̃ ũcʉ̃, ‘Jesús yaʉ yʉ ãniña,’ aperã camasã na catʉ̃goro caĩquetibʉjʉre, yʉ yaʉ cʉ̃ caãnierẽ yʉ cʉ̃ã yʉ Pacʉ, ʉmʉrecóo macããcʉ̃rẽ cʉ̃ yʉ quetibʉjʉgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bairi tunu apei, ‘Jesure yʉ masĩẽtĩña,’ caĩ pʉamerẽ yʉ cʉ̃ã, ‘Cʉ̃ yʉ masĩẽtĩña cʉ̃rã,’ ñi quetibʉjʉgʉ yʉ Pacʉ ʉmʉrecóo macããcʉ̃rẽ,” jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ĩ quetibʉjʉ yaparo, jãã ĩ quetibʉjʉnemowĩ tunu: “Camasã watoa yʉ caãnierẽ cariape masĩña. ‘Dios cʉ̃ cajoʉ cʉ̃ caetaro bero jʉ̃gori nipetiro camasã caroaro ãmeo átiãnigarãma,’ ĩ tʉ̃goñaeticõãña. Yʉ caetaro jʉ̃gori camasã jĩcãrõ tʉ̃ni tʉ̃goñaetigarãma. Caãmeoqũẽrã na catʉ̃goñarĩjẽrẽ bairo tʉ̃goñagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bairi camasã yʉ yaye bʉsʉriquere jĩcã yerire bairoa catʉ̃goʉsaena ãnirĩ jĩcãʉ̃ cʉ̃ pacʉre cʉ̃ pesucʉtigʉmi. Torea bairo apeo cʉ̃ã cõ pacore cõ pesucʉtigomo. Apeo cʉ̃ã cõ mañicõrẽ cõ pesucʉtigomo. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bairi jĩcãʉ̃ caʉ̃mʉ pesua pʉame jĩcã wii macããna majũ nimirãcʉ̃ã, tore bairo baigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bairi tunu ni jĩcãʉ̃ ũcʉ̃, cʉ̃ pacʉre, o cʉ̃ pacore yʉ netõrõ na cʉ̃ camaiata, yʉ cabueire bairo ãnimasĩẽtĩñami. Tunu bairoa apei ũcʉ̃ cʉ̃ macʉ̃rẽ, o cʉ̃ macõrẽ yʉ netõrõ na cʉ̃ camaiata, yʉ cabueire bairo ãnimasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tunu ni jĩcãʉ̃ ũcʉ̃ yʉ mena ágamicʉ̃ã, yʉre bairo popiye cʉ̃ cabaigaeticõãta, yʉ cabueire bairo ãnimasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tunu ni jĩcãʉ̃ ũcʉ̃ cʉ̃ caãnie pʉamerẽ mairĩ, yʉ yaye quetire cajãnaʉ pʉame yasicoagʉmi yua. Baipʉa, ni jĩcãʉ̃ ũcʉ̃ yʉ yaye quetire cajãnaecʉ roque netõcõãgʉmi. Cʉ̃rẽ na capajĩãrocacõãmiatacʉ̃ãrẽ, caticõã ãninucũgʉmi tocãnacã rʉ̃mʉa,” jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu: “Ni jĩcãʉ̃ ũcʉ̃ mʉjããrẽ cʉ̃ canʉcʉ̃bʉgoata, yʉre canʉcʉ̃bʉgoʉre bairo cʉ̃ ñiñagʉ. Tunu bairoa yʉre canʉcʉ̃bʉgoʉ caãcʉ̃ cʉ̃ caãnoi, Dios yʉre cajoʉ pʉame cʉ̃rẽ canʉcʉ̃bʉgoʉre bairo qũĩñagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ pʉame profetare cʉ̃ cʉ̃ canʉcʉ̃bʉgoata, caroare cʉ̃ jogʉmi Dios. Dios yaye bʉsʉriquere cʉ̃ caquetibʉjʉrotijoricʉ cʉ̃ caãnoi, caroaro cʉ̃ cʉ̃ caápata, profeta caroaro cʉ̃ caátie wapare bairo cʉ̃ cʉ̃ãrẽ cʉ̃ jogʉmi Dios. Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ pʉame carorije wapa cacʉ̃goecʉre cʉ̃ cʉ̃ canʉcʉ̃bʉgoata, caroare cʉ̃ jogʉmi Dios caʉ̃mʉrẽ. Cariape Dios yaʉ cʉ̃ caãnoi caroaro cʉ̃ cʉ̃ caápata, carorije wapa cacʉ̃goecʉ caroaro cʉ̃ caátie wapare bairo cʉ̃ cʉ̃ãrẽ cʉ̃ jogʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ pʉame yʉ cabueire cʉ̃ cʉ̃ canʉcʉ̃bʉgoata, caroare cʉ̃ jogʉmi Dios cʉ̃ cʉ̃ãrẽ. Yʉ cabuei, cabʉgoro macããcʉ̃ majũ cʉ̃ caãnimiatacʉ̃ãrẽ, caroaro cʉ̃ cʉ̃ caápata, cʉ̃rẽ caroaro cʉ̃ caátie wapa nigaro. Dise ũnieacãrẽ oco cʉ̃ caetipee cʉ̃ãrẽ yʉ cabueire cʉ̃ cajoata, cʉ̃rẽ caroaro cʉ̃ caátie wapa nigaro,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bairo pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ, jãã, cʉ̃ cabuerãrẽ jãã quetibʉjʉ yaparo yua, topʉ caãniatacʉ ti yepa macããjẽ ape macããrĩpʉ áñesẽãnemowĩ Jesús, caroa quetire camasãrẽ na quetibʉjʉ ácʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mai, Juan camasãrẽ cabautizamiatacʉ pʉame preso jorica wiipʉ ãñupʉ̃ ti rʉ̃mʉrĩrẽ. Bairo topʉ ãcʉ̃, queti tʉ̃goyupʉ Jesús cʉ̃ caátiãnierẽ. Bairo tʉ̃gori, atore bairo na ĩ jẽniñarotijoyupi cʉ̃ cabuerãrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“¿Cariapea Mesías, Dios cʉ̃ cajoʉ majũ, mʉ ãniñati? Cʉ̃ mee mʉ caãmata, ¿apei pʉamerẽ jãã coterãati?” na ĩ jẽniñarotijoyupi Juan cʉ̃ cabuerãrẽ, Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bairo cabero Juan cʉ̃ cabuerã torea bairo na caĩjẽniñarõ, atore bairo na ĩwĩ Jesús: “Tunu ánája Juan tʉpʉ. Cʉ̃ quetibʉjʉrájá mʉjãã caĩñaatajere, bairi mʉjãã catʉ̃goataje cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yʉ camasĩrĩjẽ jʉ̃gori caĩñamasĩẽtãna merẽ ĩñamasĩñama. Tunu caámasĩẽtãna cʉ̃ã merẽ ámasĩñama. Carupaʉ boaatana cʉ̃ã merẽ caticoayama. Tunu catʉ̃goetana cʉ̃ã merẽ tʉ̃gomasĩñama. Cabaiyasiatana cʉ̃ã merẽ caticoayama. Tunu cabopacarã cʉ̃ã caroa queti tʉ̃goyama, Dios narẽ cʉ̃ canetõrĩjẽrẽ. Tiere cʉ̃ quetibʉjʉrájá. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tunu bairoa mʉjããrẽ ñiña: ¡Ʉseanirĩ niñama camasã yʉ mena catʉ̃goñatutuajãnaena pʉame!” na ĩ jowĩ Jesús, Juan cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bairo Juan cʉ̃ cajoatána na caátó ĩña, to macããna capããrã camasãrẽ na quetibʉjʉ jʉ̃gowĩ Jesús, Juan cʉ̃ cabairiquere. Atore bairo na ĩwĩ: “¿Nopẽĩrã desierto cayucʉmanopʉ mʉjãã ásúpari? ¿Jĩcãʉ̃ yucʉacã wĩnoi cayuguiricʉacarẽ ĩñagarã, topʉ mʉjãã ásúpari? ");
INSERT INTO cbcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿O caʉ̃mʉ, caroa cajutii jãñaʉrẽ qũĩñagarã, topʉ mʉjãã ásúpari? Mʉjãã baiesupa. Camasã caroa jutii cajãnarã pʉame caroa wiiripʉ, quetiuparã ya wiiripʉ ãniñama. Desierto cayucʉmanopʉ etaetiyama na ũna. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿O profetare qũĩñagarã, topʉ mʉjãã ásúpari? Bairoa mʉjãã baiyupa. Cariape mʉjããrẽ ñiña: Mʉjãã pʉame, ‘Profeta ãcʉ̃mi Juan,’ mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, Juan profeta netõõjãñurõ caãnimajũʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cʉ̃ niñami Dios yaye quetibʉjʉrica tutipʉ na cawoatujʉ̃goyecʉtacʉ majũ. Atore bairo ti tutipʉ ĩ quetibʉjʉyayupi Dios, cʉ̃ macʉ̃rẽ, Juan cʉ̃ cabaipeere: ‘Mʉ, yʉ cajopaʉ, ti yepapʉ mʉ cabuiaparo jʉ̃goye, apeire cʉ̃ yʉ qũẽnoroti jojʉ̃gogʉ. Camasã mʉ yaye quetire na tʉ̃goʉsaáto ĩ, apeire yʉ qũẽnoroti jojʉ̃gogʉ,’ ĩ quetibʉjʉyayupi Dios Juan cʉ̃ cabaipeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cariape mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ ati yepapʉ cabuiaricʉ, Juan, camasãrẽ cabautizamiatacʉ netõrõ caquetibʉjʉnetõõmasĩ maami. Baipʉa, Dios cʉ̃ carotimasĩrĩpaʉ macããcʉ̃ pʉame nipetirã netõrõ cabʉgoro macããcʉ̃ ãnimicʉ̃ã, ape rʉ̃mʉpʉ roquere Juan netõrõ masĩcõãgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan cabautizamiatacʉ cʉ̃ cabauetaropʉi nijʉ̃goaná, ãme caãnapʉ tocãnacã rʉ̃mʉa nituetayama Dios cʉ̃ carotimasĩrĩpaʉ capããrã beropʉ bʉtioro cajããgarã. Na pʉame ãmeo qũẽrĩ majã jĩcã macãrẽ ẽmagarã bʉtioro na caátore bairo popiye bairi jããrã átiyama. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tunu Juan ati yepapʉ cʉ̃ caquetibʉjʉparo jʉ̃goye profeta majã nipetirã, bairi Moisés ãnacʉ̃ cʉ̃ã quetibʉjʉ jʉ̃goatíyayupa Dios cʉ̃ carotimasĩrĩpaʉ caetapeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tunu mʉjãã camasĩgaata, atore bairo mʉjããrẽ ñi quetibʉjʉnemoña: ‘Elíare bairo caãcʉ̃ ape rʉ̃mʉpʉ buiaetagʉmi,’ na caĩwoatucũjʉ̃goyecʉtacʉ majũ niñami Juan. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mʉjãã, caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Dope bairo mʉjãã, ati yʉtea macããna mʉjãã ũnarẽ ñicʉti? ¿Noa ũnarẽ bairo mʉjãã ãnicʉti? Cawĩmarãrẽ bairo mʉjãã ãniña. Cawĩmarã pʉame camasã na caneñaporipaʉ ũno plazapʉ eperã, awajari atore bairo ĩ joyama na baparãrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Jãã catõrõã putiro, mʉjãã basaetiapʉ. Tunu bairoa jãã caotiro cʉ̃ãrẽ, jãã mʉjãã otinemoetiapʉ,’ ĩ joyama cawĩmarã na baparãrẽ. Narẽ bairo mʉjãã ãniña, cayʉgaena majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tʉ̃gopeoya mai. Yʉ jʉ̃goye etayupʉ Juan. Cʉ̃ pʉame pan ʉgaesupʉ. Tunu ʉse oco cʉ̃ãrẽ etietinucũñupʉ̃. Bairo cʉ̃ cabairijere ĩñarã, mʉjãã pʉame, ‘Wãtĩ yeri pũna cacʉ̃goʉ ãcʉ̃mi. Cʉ̃ marĩ tʉ̃goetiroa,’ mʉjãã ĩñupã Juarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bairi Juan bero yʉ, Camasã Jʉ̃gocʉ, yʉ etawʉ. Yʉ pʉame camasã mena yʉ ʉganucũña. Na mena yʉ etinucũña. Bairo yʉ cabairijere ĩñarã, mʉjãã pʉame, ‘Ʉgapacajãñuñami. Ʉse oco cʉ̃ãrẽ etipacajãñuñami. Carorã mena bapacʉtiyami. Tunu bairoa Roma macããcʉ̃ gobiernorẽ camasã yaye dinerore cajejobojari majã mena bapacʉtiyami. Bairi caróʉ ãcʉ̃mi. Cʉ̃ marĩ tʉ̃goetiroa cʉ̃ cʉ̃ãrẽ,’ yʉ mʉjãã ĩnucũña. Baipʉa, Dios pʉame cʉ̃ camasĩrĩjẽrẽ camasãrẽ na áti ĩñoñami cʉ̃ mena catʉ̃goñatutuarã caroaro na caátie jʉ̃gori,” na ĩ quetibʉjʉwĩ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemowĩ tunu Jesús to macããnarẽ, ape macãã macããna roro na cabairiquere. Mai, na macããrẽ ãcʉ̃, capee caroa átijẽño ĩñorĩqũẽrẽ na áti ĩñowĩ Jesús. Bairo narẽ caroaro cʉ̃ caátimiatacʉ̃ãrẽ, na pʉame roro na caátajere tʉ̃goña yapapuari tʉ̃goña wasoaema na yerire. Bairi atore bairo na ĩwĩ Jesús na cabaipeere: ");
INSERT INTO cbcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Roro majũ baigarãma to Corazín macã macããna! ¡Roro majũ baigarãma Betsaida macã macããna cʉ̃ã! Dios cʉ̃ caátijẽñomasĩrĩjẽ capeere ĩñawã. Bairo caĩñarã nimirãcʉ̃ã, roro na caátajere jãnagaema. Tirʉ̃mʉpʉ macããna Tiro, Sidón macããna ãnana, Corazín, Betsaida macããna na caĩñarĩcãrõrẽã bairo na cʉ̃ã na caĩñaata, roro na caátajere jãnabujioricarãma Tiro, Sidón macããna pʉame. Bʉtioro yapapuarã na cajãñarĩjẽ jutii ũnierẽ jãñabujioricarãma. Peero õwã cʉ̃ãrẽ na rʉpoapʉ mapeobujioricarãma, bʉtioro yapapuari yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Cariape mʉjããrẽ ñiña: Camasãrẽ Dios cʉ̃ caĩñabeseri rʉ̃mʉ caetaro, Corazín, bairi Betsaida macããna pʉame, Tiro, Sidón macããna netõjãñurõ popiye baigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Torea bairo Capernaum macã macããna cʉ̃ã baigarãma. ‘Jõbuipʉ marĩ ágarã,’ caĩtʉ̃goñarã na caãnimiatacʉ̃ãrẽ, ¡caʉ̃cʉ̃ãrĩ opepʉ roquere na regʉmi Dios! Cʉ̃ caátijẽñorĩjẽ capeere ĩñawã Capernaum macããna. Tirʉ̃mʉpʉ macããna, Sodoma macããna ãnana, Capernaum macããna na caĩñarĩcãrõrẽ bairo na cʉ̃ã na caĩñaata, roro na caátajere jãnarĩ, yasietibujioricarãma. Na ya macã pʉame ati rʉ̃mʉrẽ nicõãbujioro mai. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Cariape mʉjããrẽ ñiña: To macããna na catʉ̃goetie wapa, Dios pʉame roro na átigʉmi. Camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉ caetaro, Capernaum macããna, Sodoma macããna netõjãñurõ popiye baigarãma,” na ĩ quetibʉjʉwĩ Jesús, camasã cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bairo ti watoa caãno atore bairo Diore qũĩ jẽniwĩ Jesús: “Caacʉ, mʉ, ati ʉmʉrecóo nipetiro upaʉ, mʉ ñujãñuña yʉ yarã mena. Naa, cabʉgoro macããnarẽ bairo caãna na caãnimiatacʉ̃ãrẽ, masĩrĩqũẽrẽ na mʉ joyupa. Aperã, ati yepa macããna, ‘Marĩ roque marĩ masĩnetõña,’ caĩrã pʉamerẽ na mʉ joesupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Caacʉ, tore bairo mʉ ásupa mʉ cabojʉ̃goyetiricarorea bairo caãno jʉ̃gori,” qũĩ jẽniwĩ Jesús cʉ̃ pacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bairo qũĩ jẽni yaparo, atore bairo na ĩwĩ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ: “Yʉ Pacʉ pʉame nipetirije masĩrĩqũẽrẽ yʉ jowĩ. Tunu yʉ caátiãnie cʉ̃ãrẽ yʉ Pacʉ jeto masĩñami. Tunu cʉ̃ caátiãnierẽ yʉ cʉ̃ã yʉ masĩpeyocõãña. Bairi yʉ cʉ̃ã yʉ jeto na yʉ masĩõmasĩña camasã yʉ cabeserãrẽ yʉ Pacʉ cʉ̃ caátiãnierẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tunu mʉjãã nipetirã cajʉ̃gobueri majã na caquetibʉjʉcũrĩqũẽrẽ caátipeyogamirã yʉ mena tʉ̃goñatutuarasá. Caroa yericʉtajere mʉjããrẽ yʉ jogʉ, ‘Jaʉ,’ mʉjãã caĩata. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wecʉa pʉgarã jiyaricarã jĩcãrõ mena na capaarorea bairo marĩ cʉ̃ã jĩcãrõ mena marĩ paaroa. Tunu bairoa yʉ yaye bʉsʉrique cʉ̃ãrẽ tʉ̃gopajeʉsaya. Yʉa, tutuaro caroti mee yʉ ãniña. Caroa yeri pũna mena caquetibʉjʉ yʉ ãniña. Bairi yʉ mena mʉjãã caãmata, caroa yericʉtaje majũ mʉjãã yeripʉre etagaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mʉjãã caátipee yʉ caborije pʉame tʉ̃goña yapapuao joroque mʉjããrẽ áperigaro. Tunu yʉ caborore bairo mʉjãã caátipee masiriyoetiya,” na ĩ quetibʉjʉwĩ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ti rʉ̃mʉrĩrẽ jãã, judío majã jãã cayerijãrĩ rʉ̃mʉ caãno, jãã netõápʉ́ weseripʉ. Bairo netõáná, jãã, Jesús cʉ̃ cabuerã pʉame queyari, trigo apeacarẽ jeri cacatirijerea jãã ʉgajʉ̃gowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bairo jãã caátore ĩñarĩ, fariseo majã atore bairo qũĩ tutiwã Jesure: —¡Na ĩñañijate! ¿Mʉ cabuerã roro na caátiere miñaetiyati? Ati rʉ̃mʉ ũnorẽ paariquere bairo átiyama mʉ cabuerã, bairo trigo apeacarẽ jeʉgarã. Ati rʉ̃mʉ ũnorẽ caápericõãpee niña na caátie ũnierẽ —qũĩ tutiwã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bairo na caĩtutiro tʉ̃go, atore bairo na ĩwĩ Jesús: —David ãnacʉ̃ queyamiácʉ́, ¿cʉ̃ caátajere na caquetibʉjʉcũrĩqũẽrẽ mʉjãã ĩñaetinucũñati Dios ya tutipʉ? Mʉjãã ĩñanucũrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bairo baiyuparo: David pʉame jããetayupʉ Dios ya wiire cʉ̃ ʉ̃mʉa mena. Ʉgariquere macãrã jããetayuparã. Bairi pan ãñuparõ, caroa Dios yaye majũ na caĩcũrĩqũẽ jeto. Tie pããrẽ sacerdote majã jetore na ʉgarotiyupʉ Moisés ãnacʉ̃. Bairo sacerdote majã jeto na caʉgarije caãnimiatacʉ̃ãrẽ, tie pããrẽ ʉgari bero, cʉ̃ ʉ̃mʉarẽ na batonuñupʉ̃ David. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tunu bairoa Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ ape pũrõ ape wẽẽpʉ sacerdote majã ati rʉ̃mʉ ũnorẽ na caátipeere, ¿mʉjãã ĩñaetinucũñati? Mʉjãã ĩñarĩcãrã. Ati rʉ̃mʉ ũnorẽ templo wiire paariquere bairo camasãrẽ na cajʉ̃goñubuero átirotiyupi Moisés. Bairo na pʉame ati rʉ̃mʉ ũnorẽ na capaamiatacʉ̃ãrẽ, tie jʉ̃gori carorije wapa cacʉ̃gorãrẽ bairo na ĩñaetinucũñami Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cariape mʉjããrẽ ñiña: Ãme ati yepapʉ mʉjãã mena macããcʉ̃ jĩcãʉ̃ templo wii netõjãñurõ caãnimajũʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios yaye cʉ̃ caquetibʉjʉcũrĩqũẽ, “Waibʉtoa rii joemʉgõrĩ yʉ mʉjãã cañubuero mee, camasãrẽ bopacooro mʉjãã caĩñamairõ roquere yʉ boya,” cʉ̃ caĩquetibʉjʉcũrĩqũẽrẽ mʉjãã tʉ̃gomasĩẽtĩña. Bairo tiere mʉjãã catʉ̃gomasĩata, yʉ cabuerã, carorije wapa cacʉ̃goenarẽ na mʉjãã tutietibujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉ, Camasã Jʉ̃gocʉ ãnirĩ, yʉ átirotimasĩña yerijãrĩcã rʉ̃mʉ cʉ̃ãrẽ camasã caroare na caátiãnipeere —na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cabero topʉ caãniatacʉ jãã jʉ̃goacoámí tunu Jesús. Á yua, ti yepa macãã wii na cañubueri wiire jãámi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mai, topʉ ãmi jĩcãʉ̃ caricábʉricʉ. Bairi to macããna qũĩ jẽniñawã Jesure: —Marĩ cayerijãrĩcã rʉ̃mʉrẽã cariayecʉnarẽ marĩ cacatioro, ¿to ñucõãcʉti? O paariquere bairo caãnoi, ati rʉ̃mʉ ũnorẽ tore bairo caápericõãpee, ¿to ãnicʉti? —qũĩ jẽniñawã Jesure, cʉ̃ caĩrĩjẽrẽ na quetiuparãrẽ bʉsʉjãgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bairo na caĩrõ tʉ̃go, atore bairo na ĩwĩ Jesús: —¿Ni ũcʉ̃ mʉjãã mena macããcʉ̃, oveja jĩcãʉ̃ãcã cacʉ̃goʉ ũcʉ̃ cʉ̃ caãmata, cʉ̃ yaʉ opepʉ ati rʉ̃mʉ ũnorẽ cʉ̃ cañarocajãápata, jicoquei cʉ̃ cʉ̃ nemʉgõmasĩẽtĩcʉti? Nipetirã mʉjãã tore bairo mʉjãã átibujiorã, marĩ cayerijãrĩ rʉ̃mʉ ũno cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Camasã pʉamerẽ oveja netõjãñurõ na maiñami Dios! Bairi cañurĩjẽ marĩ caátie ñuña Dios cʉ̃ caĩñajoro marĩ cayerijãrĩ rʉ̃mʉ ũno cʉ̃ãrẽ —na ĩwĩ Jesús ti wii macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bairo na ĩ yaparo, atore bairo qũĩwĩ Jesús caricábʉricʉre: —Mʉ ricáre ñupoya. Bairo cʉ̃ caĩrõ, caricábʉricʉ pʉame cʉ̃ ricáre ñupoowĩ. Tocãrõã cʉ̃ ricá ñucoápʉ ape nʉgõã macã ricáre bairo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bairo cʉ̃ caáto ĩñarã, fariseo majã pʉame ti wiire witi yua, “¿Dope bairo marĩ ánaati, Jesure pajĩãgarã?” ãmeo ĩ bʉsʉpaijʉ̃goyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús pʉame masĩcõãwĩ fariseo majã na caĩtʉ̃goñarĩjẽrẽ. Bairo masĩrĩ yua, topʉ caãniatacʉ aperopʉ acoámí. Bairo cʉ̃ caátó ĩñarã, capããrã camasã cʉ̃ bero ʉsawã. Na mena macããna cariayecʉna nipetirãrẽ na catiowĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Bairo na catio yaparo, narẽ cʉ̃ caátibojarijere aperãrẽ na quetibʉjʉ rotiemi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dios bʉsʉrica tutipʉ profeta Isaías ãnacʉ̃ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiwʉ. Atore bairo ĩ quetibʉjʉ woatucũñañupĩ Isaías ãnacʉ̃ Dios cʉ̃ caĩrĩjẽrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ãni, yʉ cabesericʉ, yʉ caroti niñami. Cʉ̃ yʉ maijãñuña. Cʉ̃ caátiãnierẽ ñiñaʉseaniña. Bairi yʉ yerire cʉ̃ mena yʉ bapacʉtirotigʉ. Cʉ̃ pʉame judío majã caãmerã cʉ̃ãrẽ cariape quetire na quetibʉjʉgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tunu bairoa camasãrẽ roro na bʉsʉnetõẽtĩgʉmi. Caroa yeri mena roque na quetibʉjʉgʉmi. Bairi noo macã maapʉ ãcʉ̃, di rʉ̃mʉ ũno awajatutiri na quetibʉjʉetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bairi camasã catʉ̃goñatutuaenarẽ caroaro mena na beyogʉmi. Cʉ̃ carotimasĩrĩpaʉ caetaparo jʉ̃goye tʉ̃goñatutuarique roquere na jogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bairi judío majã caãmerã cʉ̃ã nipetirã, ‘Cʉ̃ caĩrõrẽ bairo caroaro marĩ jʉátibojagʉmi,’ ĩ tʉ̃goñagarãma,” ĩ quetibʉjʉ woatucũñañupĩ Isaías ãnacʉ̃ Jesús cʉ̃ caátipeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ape rʉ̃mʉ Jesutʉ cʉ̃ neamá camasã jĩcãʉ̃ wãtĩ yeri pũna cacʉ̃goʉre. Mai, wãtĩ yeri pũna cʉ̃ cajãñarõ jʉ̃gori cʉ̃ pʉame ĩñamasĩẽmi. Bairi tunu bʉsʉmasĩẽmi. Jesús pʉame cʉ̃ catiowĩ cʉ̃ cʉ̃ãrẽ. Bairo cʉ̃ cacatioro, caʉ̃mʉ pʉame bʉsʉmasĩwĩ. Tunu bairoa ĩñamasĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bairo cʉ̃ cacatiro ĩña, nipetiro camasã tʉ̃goñacõã maniáma. Atore bairo ĩwã: “¿Ãni, Jesús, marĩ ñicʉ̃ David ãnacʉ̃ pãrãmi mee cʉ̃ ãnicʉti? ¿Dios cʉ̃ cajoʉ Mesías mee cʉ̃ ãnicʉti?” ĩwã nipetiro camasã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bairo na caĩrõ tʉ̃go, fariseo majã pʉame atore bairo ĩwã: “Dios jʉ̃gori mee, Beelzebú, wãtĩã quetiupaʉ majũ cʉ̃ camasĩõrĩjẽ jʉ̃gori wãtĩ yeri pũna, camasãrẽ caãnarẽ na acurewiyojo masĩĩmi Jesús,” ĩwã fariseo majã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús pʉame masĩcõãwĩ na catʉ̃goñarĩjẽrẽ. Bairo masĩrĩ yua, atore bairo na ĩwĩ: “Quetiupaʉ rey cʉ̃ carotimasĩrĩpaʉ macããna na caãmeoboeticõãta, jĩcãrõ ãnimasĩẽtĩñama. Tunu bairoa jĩcã macã, o jĩcã wii macããna na caãmeoboeticõãta, na cʉ̃ã caroaro ãnimasĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tore bairo Satanás, wãtĩã quetiupaʉ, cʉ̃ yarãrẽ na cʉ̃ caboeticõãta, ¿dope bairo to ãninetõrõati cʉ̃ carotimasĩrĩpaʉ? Ãninetõmasĩẽto. Yasipeticoagaro cʉ̃ yarãrẽ, na cʉ̃ caboeticõãta. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tunu bairoa Beelzebú jʉ̃gori wãtĩ yeri pũnarẽ na yʉ caacurewiyojomasĩata, ¿ñamʉ cʉ̃ camasĩrĩjẽ jʉ̃gori mʉjãã yarã cʉ̃ã yʉre bairo na átimasĩcʉti? Bairo mʉjãã caĩrõ tʉ̃gorã, mʉjãã yarã pʉame, ‘Cariape mee mʉjãã tʉ̃goñaña,’ mʉjããrẽ ĩbujiorãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yʉ pʉame, Dios Yeri Espíritu Santo cʉ̃ camasĩõrĩjẽ jʉ̃gori wãtĩ yeri pũnarẽ yʉ caacurewiyojomasĩata, nipetiro camasã yʉ caátiere ĩñarã, ‘Merẽ Dios cʉ̃ carotimasĩrĩpaʉ marĩrẽ etaya,’ ĩ masĩbujiorãma,” na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bairo ĩ quetibʉjʉ yaparo, cajerutiri majõcʉre ĩcõñarĩ atore bairo na ĩ quetibʉjʉnemowĩ tunu: “Jĩcãʉ̃ wii upaʉ, catutuaʉ majũ, cʉ̃ ya wii macããjẽrẽ caroaro cʉ̃ caĩñacoteata, ni ũcʉ̃ cajerutiri majõcʉ cʉ̃ yayere jerutimasĩẽcʉ̃mi. Jerutimasĩĩmi baipʉa, ti wii upaʉre cʉ̃ cajiyajʉ̃goata. Bairo cʉ̃ jiyajʉ̃gori bero roque, ti wii macããjẽ nipetirijere jerutipeyo masĩcõãʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yʉ mena caãnigaecʉ, yʉre caĩñateire bairo caãcʉ̃ niñami. Tunu bairoa yʉ mena caquetibʉjʉnetõõgaecʉ, camasãrẽ caquetibʉjʉmawijioʉre bairo caãcʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Bairi cariape mʉjããrẽ ñiña: Cabʉsʉpairã dope bairo roro na caĩrĩjẽ tocãnacã wãmerẽ masiriyogʉmi Dios, cʉ̃rẽ na cajẽniata. Bairo masiriyobojamicʉ̃ã, Espíritu Santore roro na cabʉsʉpaiata roquere, na masiriyoetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Baipʉa, noa ũna yʉ, Camasã Jʉ̃gocʉre roro na caĩrĩjẽrẽ masiriyogʉmi Dios, cʉ̃rẽ na cajẽniata. Tore bairo átimicʉ̃ã, Espíritu Santore roro na caĩata roque, na masiriyobojaetigʉmi. Ati yʉtea caãno cʉ̃ã, bairi ati yepa cʉ̃ cawasoaro bero caãnipa yʉtea cʉ̃ãrẽ na masiriyoetigʉmi, Dios Espíritu Santore roro na caĩata,” na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemowĩ tunu: “Tʉ̃goñañijate. Jĩcãʉ̃ yucʉ caroʉ́ carorijere rícacʉperiya. Tunu bairoa apei yucʉ caroricʉ caroare rícacʉperiya. Tocãnacã yucʉ carícacʉtii yucʉ rícare ʉgarã, tiire marĩ masĩña. ‘Yucʉ caroʉ́ niña,’ o ‘Yucʉ caroricʉ niña,’ marĩ ĩ masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Mʉjãã, ãña ũna moena majũ mʉjãã ãniña! Bairi rorije caáticõãna ãnirĩ dope bairo pʉame caroaro cariape macããjẽrẽ mʉjãã quetibʉjʉ masĩẽna. Marĩ yeri marĩ catʉ̃goñamasĩrĩjẽpʉ caãnoi, marĩ bʉsʉnucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bairi marĩ yeripʉ caroa caãmata, caroa wãme tʉ̃goñarĩqũẽrẽ marĩ bʉsʉnucũña. Tunu bairoa carorijere marĩ cabʉsʉnucũata cʉ̃ãrẽ, marĩ yeri pũnaapʉ carorije caãno jʉ̃gori carorije jeto bʉsʉrique niña. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cariape mʉjããrẽ ñiña: Dios camasãrẽ na cʉ̃ caĩñabeseri rʉ̃mʉ caetaro, roro na caĩrĩqũẽ tocãnacã wãmerẽ ĩñabesegʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mʉjãã ya risero jʉ̃gori mʉjãã masĩgʉmi Dios mʉjãã caátiãnierẽ. Caroaro caĩrĩcʉ̃ cʉ̃ caãmata, carorije wapa cacʉ̃goecʉre bairo qũĩñagʉmi Dios. Roro caĩrĩcʉ̃ cʉ̃ caãmata roque, carorije wapa cacʉ̃goʉre bairo qũĩñagʉmi,” na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cabero jĩcããrã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi fariseo majã mena Jesutʉ etawã tunu. Atore bairo qũĩwã: —Cabuei, jĩcã wãme ũno átijẽño ĩñorĩqũẽrẽ jããrẽ mʉ áti ĩñowã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bairo na caĩrõ tʉ̃gomicʉ̃ã, atore bairo na ĩwĩ Jesús: —Ati yepa macããna, ãme caãna, caroaro Dios mena ãnimasĩẽtĩñama. Jĩcã rʉ̃mʉ cʉ̃ boo, ape rʉ̃mʉ cʉ̃ boetiyama. Átijẽño ĩñorĩqũẽ jetore boyama. Bairo na cabomiatacʉ̃ãrẽ, tiere na áti ĩñoetigʉmi Dios. Merẽ na quetibʉjʉ cũñupĩ Jonás ãnacʉ̃ cʉ̃ cabairiquere. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás pʉame itia rʉ̃mʉ, itia ñami majũ wai capai paaro pupeapʉ ãñupĩ. Torea bairo yʉ, Camasã Jʉ̃gocʉ cʉ̃ã itia rʉ̃mʉ, itia ñami majũ ati yepa pupeapʉ yʉ ãnigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tirʉ̃mʉpʉre Jonás cʉ̃ caĩrĩjẽrẽ tʉ̃gorã, Nínive macã macããna pʉame roro na caátajere jãnacõãñupã. “Cariapea Dios cʉ̃ caquetibʉjʉnetõrotiricʉ majũ niñami Jonás,” ĩ tʉ̃goñamasĩñupã. Bairo Jonarẽ na caĩtʉ̃goñamiatacʉ̃ãrẽ, mʉjãã, ãme caãna pʉame Jonás netõjãñurõ caãnimajũʉ̃ cʉ̃ caĩrĩjẽrẽ mʉjãã tʉ̃goʉsagaetiya. Bairi Dios cʉ̃ caĩñabeseri rʉ̃mʉ caetaro, Nínive macã macããna pʉame catitunurĩ, “Roro majũ mʉjãã tʉ̃goʉsaesupa,” mʉjãã ĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tunu bairoa ti rʉ̃mʉ caetaro, jĩcãõ catitunurĩ, mʉjãã, ãme caãnarẽ, “Cariapea mʉjãã tʉ̃goʉsaepʉ,” mʉjããrẽ ĩregomo cõ cʉ̃ã. Ape nʉgõã waru jopepʉ macããcõ quetiupao ãnacõ cʉ̃ã bairo mʉjããrẽ ĩgomo. Cõ pʉame noo cayoaropʉ asúpo, Salomón ãnacʉ̃ cʉ̃ camasĩrĩjẽrẽ tʉ̃gogo. Bairo catʉ̃gogarico cõ caãnimiatacʉ̃ãrẽ, mʉjãã, ãme caãna yʉ camasĩrĩjẽrẽ mʉjãã tʉ̃gogaetiya. Bairo Salomón netõrõ camasĩ yʉ caãnimiatacʉ̃ãrẽ, yʉ caĩrĩjẽrẽ mʉjãã tʉ̃gogaetiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo na ĩnemowĩ Jesús tunu: “Wãtĩ yeri pũna caʉ̃mʉrẽ cʉ̃ cawitiátato bero, noo caoco manipaʉripʉ áñesẽãʉ̃mi. Áñesẽã yua, cʉ̃ caãniparore cʉ̃ cabocaeticõãta, atore bairo ĩ tʉ̃goñaʉmi: ");
INSERT INTO cbcNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Yʉ caãnimiatatopʉa yʉ tunuágʉ tunu,’ ĩ tʉ̃goñaʉmi. Bairo ĩ tʉ̃goña yua, tunuá, caʉ̃mʉrẽ qũĩñaʉmi tunu. Caʉ̃mʉ yeri pʉame caroaro na caowa qũẽnopeyoatato wiire bairo bauʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bairo cabairo ĩña yua, ácoacʉmi tunu wãtĩ, aperã jĩcã wãmo peti pʉga pẽnirõ cãnacãʉ̃ majũ cʉ̃ netõrõ cañuenarẽ na piineñoʉ ácʉ́. Bairo na bocá, ‘¡Jito!’ na ĩ, caʉ̃mʉrẽ cʉ̃ jããrãma tunu nipetirã. Bairi cʉ̃ yeripʉ ãnicõãrãma tunu. Bairo na caãno, jõpʉame roro baibujioʉmi tunu caʉ̃mʉ pʉame yua. Torea bairo baigarãma ati yʉtea macããna carorã, Dios narẽ cʉ̃ canetõatato bero cʉ̃ Yeri majũrẽ na yeripʉ caboena pʉame,” na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bairo narẽ cʉ̃ caquetibʉjʉãno, Jesús paco, bairi cʉ̃ bairã cʉ̃ã topʉ etayupa. Eta yua, cʉ̃ caãni wii macãpʉ cʉ̃ cotenucũñupã, cʉ̃ mena bʉsʉgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bairo macãpʉ na cacotenucũrõ, Jesutʉ macããcʉ̃ jĩcãʉ̃ atore bairo qũĩwĩ Jesure: —Mʉ paco, mʉ bairã mʉ macãũparã. Macãpʉa mʉrẽ coterã átiuparã —qũĩwĩ jĩcãʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩwĩ Jesús cʉ̃rẽ caquetibʉjʉre: —Naa, yʉ paco, yʉ bairã cʉ̃ã, yʉ yarã majũ na caãnimiatacʉ̃ãrẽ, aperã, yʉ yarãrẽ bairo caãna niñama na cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ĩ quetibʉjʉ yaparo, cʉ̃ wãmorẽ, jãã, cʉ̃ cabuerã tʉre ñupuajori atore bairo qũĩnemowĩ tunu: —Ãnoa niñama yʉ pacore bairo caãna, bairi yʉ bairãrẽ bairo caãna. ");
INSERT INTO cbcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Noa ũna yʉ Pacʉ ʉmʉrecóo macããcʉ̃ cʉ̃ carotirore bairo caána pʉame yʉ bairãrẽ bairo caãna, bairi yʉ bairã rõmirĩrẽ bairo caãna, bairi yʉ pacore bairo caãna niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti rʉ̃mʉa ti wii caãniatacʉ witiátí yua, ʉtabʉcʉra tʉ̃nipʉ ruietawĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bairo cʉ̃ caruiro, camasã capããrã cʉ̃tʉ neñaetawã. Bairo capããrã majũ na caãnoi, Jesús pʉame cũmua turorica capairicapʉ ájããwĩ. Cʉ̃tʉ catʉ̃gorã etarã pʉame peta paputiropʉ nucũwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bairo na cabairo, capee wãme ĩcõñarĩ na quetibʉjʉwĩ Jesús. Atore bairo na ĩ quetibʉjʉwĩ: “Jĩcã rʉ̃mʉ ásúpʉ jĩcãʉ̃ caʉ̃mʉ cʉ̃ wesepʉ, oteriquere otei ácʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Topʉ eta, cʉ̃ oteriquere wẽbato otejʉ̃goyupʉ. Bairo caroaro cʉ̃ caotemiatacʉ̃ãrẽ, oterique jĩcã rupaa ñañuparõ maapʉ. Bairo maapʉ ti rupaa cañarõ ĩñarã, minia pʉame wʉruiatí, ʉgarecõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Cabero cʉ̃ cawẽbatoro, ape rupaa ʉ̃tã yepapʉ cayepa esemenirõpʉ ñañuparõ. Tie pʉame yoaro mee putimiñuparõ, cayepa esemenirõ caãnoi yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bairo tie oterique pʉame pútiatímii yua, yoaro mee riacoásúparo muipʉ cʉ̃ caasijĩãrõĩ, dope bairo nʉcõõrĩ jõmasĩẽtĩrĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Cabero cʉ̃ cawẽbatoro, ape rupaa pota yucʉ watoapʉ ñañuparõ. Cabero pota yucʉ pʉame cabʉtinetõrõ, tie oterique pʉame caroaro pútimasĩẽsuparo. Pota yucʉ pʉame otere bʉtibiacõãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Cabero ape rupaa pʉame caroa yepapʉ ñañuparõ. Cabero puti, bʉticoasuparo. Bairo bʉtiátó, jĩcã jatí cien rupaa majũ rícacʉsuparo. Ape jatí sesenta rupaa majũ rícacʉsuparo. Ape jatí treinta majũ rícacʉsuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mʉjãã, caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ,” na ĩwĩ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Cabero jãã, Jesús cʉ̃ cabuerã cʉ̃tʉ jãã etawʉ. Cʉ̃tʉ eta yua, atore bairo cʉ̃ jãã ĩ jẽniñawʉ̃: “Camasã, mʉtʉ catʉ̃gorã etarãrẽ, ¿nopẽĩ capee ĩcõñarĩ na mʉ quetibʉjʉnucũñati?” cʉ̃ jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩ quetibʉjʉwĩ Jesús: “Dios cʉ̃ carotimasĩrĩpaʉ macããjẽrẽ tirʉ̃mʉpʉ macããna na catʉ̃goetajere mʉjãã roquere mʉjãã masĩõñami. Aperã tiere na camasĩrõrẽ boetiyami. Torecʉ, ape wãme ĩcõñarĩ na quetibʉjʉ rotiyami Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bairi ni jĩcãʉ̃ ũcʉ̃ yʉ caquetibʉjʉrijere cʉ̃ catʉ̃goʉsaata, Dios pʉame cʉ̃ masĩõnemogʉmi tunu. Bairo átimicʉ̃ã, petoaca catʉ̃goʉsaʉ cʉ̃ caãmata, cabero cʉ̃ camasĩmiatajere cʉ̃ masiriyocõãgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bairi ape wãme ĩcõñarĩ na yʉ quetibʉjʉnucũña camasã yʉtʉ catʉ̃gorã etarãrẽ. Bairi na pʉame cacaapee cʉ̃gorã nimirãcʉ̃ã, Dios cʉ̃ caátiere ĩñamasĩẽtĩñama. Tunu bairoa cʉ̃ yaye quetire tʉ̃gomirãcʉ̃ã, tiere tʉ̃gomasĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dios bʉsʉrica tutipʉ Isaías ãnacʉ̃ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiya narẽ: ‘Ati yepa macããna yʉ yaye quetire tʉ̃gomirãcʉ̃ã, di rʉ̃mʉ ũno tiere tʉ̃gomasĩẽtĩñama. Tunu bairoa cacaapee cʉ̃gorã nimirãcʉ̃ã, di rʉ̃mʉ ũno yʉ caátiere ĩñamasĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ati macã macããna, na yeripʉ catʉ̃goñamasĩgaetoi cacaapee cʉ̃gorã nimirãcʉ̃ã, yʉ caátiere ĩñamasĩẽtĩñama. Tunu bairoa caãmoo cʉ̃gorã nimirãcʉ̃ã, yʉ yaye quetire tʉ̃gomasĩẽtĩñama. Na yeripʉre tʉ̃goña masĩẽtĩñama na yʉ caquetibʉjʉgamirĩjẽrẽ. Bairi, “Jãã mʉ netõõwã,” ñietinucũñama,’ ĩ quetibʉjʉ cũñañupĩ Isaías ãnacʉ̃,” ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Bairo ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu Jesús: “Tirʉ̃mʉpʉ macããna profeta majã capããrã majũ mʉjãã caĩñarĩjẽ ũnierẽ ĩñagamiñupã. Na ũna aperã carorije wapa cacʉ̃goenarẽ bairo caána cʉ̃ã tiere ĩñagamiñupã. Mʉjãã catʉ̃gorije ũnie cʉ̃ãrẽ tʉ̃gogamiñupã. Bairi mʉjãã, yʉ cabuerã pʉame capee ĩña, tʉ̃go, caána ãnirĩ, ʉseanirĩ ãña,” jãã ĩwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Bairo ĩ quetibʉjʉ yaparo, atore bairo jãã ĩ quetibʉjʉ masĩõwĩ caoteire ĩcõñarĩ cʉ̃ caquetibʉjʉatajere: “Tʉ̃goya yʉ cabuerã. Mʉjããrẽ yʉ quetibʉjʉgʉ caroaro, ĩcõñarĩ caotei quetire camasãrẽ yʉ caquetibʉjʉatajere: ");
INSERT INTO cbcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Camasã jĩcããrã Dios yaye quetire tʉ̃goyama. Bairo tʉ̃gomirãcʉ̃ã, tʉ̃gomasĩẽtĩñama. Dios bʉsʉriquere na catʉ̃goatato beroaca, wãtĩ pʉame uwaro eta, jecõãñami na camasĩbujioatajere. Minia na cawʉje ʉgaricarore bairo etanecõãñami wãtĩ, na camasĩbujioatajere. Na pʉame caotei cʉ̃ caoterique maapʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Bairo tunu aperã camasã Dios yaye quetire ʉseanirõ tʉ̃go, jicoquei, ‘Jaʉ,’ ĩñama. Bairo bomirãcʉ̃ã, bairãpʉa na yeripʉ caroaro cʉ̃ yʉetiyama. Capútirije canʉcõmanajẽrẽ bairo niñama. Bairi roro na cabairo caãno, o Dios yaye quetire na catʉ̃goʉsaro jʉ̃gori aperã narẽ na caĩñatero ĩñarã, yoaro mee jãnañama Dios yaye quetire yua. Dios mena yoaro ãmerĩñama. Naa, caotei cʉ̃ caoterique ape rupaa ʉ̃tã buipʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bairo tunu aperã camasã Dios yaye quetire, ‘Jaʉ,’ na caĩrõ bero, apeye ũnie pʉamerẽ bʉtioro tʉ̃goña macãñama. Ati yepa macããjẽ wapatarique ũnierẽ, bairi caroaro na caãnigarije cʉ̃ãrẽ tʉ̃goñañama bʉtioro. Bairi Dios bʉsʉriquere tʉ̃goña masiriticõãñama. Caroaro caánarẽ bairo na caáperoi, caríca bʉtimasĩẽtĩẽrẽ bairo niñama. Bairi naa, caotei cʉ̃ caoterique ape rupaa pota watoapʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bairãpʉa, aperã roque Dios yaye quetire ʉseanirĩ tʉ̃goyama. Na yeri pũnapʉ cariape tʉ̃gopeori, tiere tʉ̃goʉsayama. Caotei cʉ̃ caoterique ape rupaa, caroa yepapʉ cañarĩcã rupaare bairo niñama. Bairi jĩcã jatí cien rupaa majũ rícacʉsuparo. Ape jatí sesenta rupaa majũ rícacʉsuparo. Ape jatí treinta majũ rícacʉsuparo. Torea bairo niñama Dios yayere catʉ̃goʉsanucũrã pʉame,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jãã ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo na ĩnemowĩ Jesús tunu cʉ̃tʉ catʉ̃gorã etarãrẽ: “Dios cʉ̃ carotiripaʉ atore bairo niña: Oteriquere caotei cʉ̃ oterique caroa majũrẽ cʉ̃ wesepʉre oteyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cabero cʉ̃, bairi aperã cʉ̃ yarã cʉ̃ã nipetiro na cacãnitoye cʉ̃ pesu pʉame yasioro cʉ̃ wesepʉ etayupʉ. Eta yua, oterique moetie majũrẽ trigo cʉ̃ caoteataje watoapʉre otenemocõãñupʉ̃. Bairo roro áti yaparo, acoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cabero cʉ̃ caotemirĩqũẽ pʉame puti, bʉtiyaparoyuparo. Moetie cʉ̃ã puti, bʉtiyaparoyuparo caroa oterique watoare. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bairo cabairo ĩña, ti wese upaʉ ʉ̃mʉa pʉame cʉ̃tʉ etayuparã. Eta yua, atore bairo qũĩ jẽniñuparã: ‘Jãã quetiupaʉ, oterique caroa majũrẽ mʉ oterotiricʉ. Bairo mʉ caátirotimiatacʉ̃ãrẽ, ¿dopẽĩrõ caroa watoare carorije to putiyupari?’ qũĩñuparã cʉ̃ ʉ̃mʉa pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃: ‘Yʉ pesuʉ jĩcãʉ̃ roro yʉ átibojaatacʉmi.’ Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ jẽniñañuparã: ‘Bairi, ¿ñerẽ jãã caátie mʉ boyati? ¿Moetiere jãã cawããrero mʉ boyati?’ qũĩñuparã cʉ̃ ʉ̃mʉa ti wese upaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃: ‘Bairo yʉ boetiya. Bairo mʉjãã caápata, trigo caroa apeye moetie mena mʉjãã wããrecõãbujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bairi trigo carorije mena to bʉticõáto mai. Cabero trigo jericapaʉ caetaro ĩña, atore bairo ñigʉ trigore cajebojari majãrẽ: “Trigore mʉjãã cajeparo jʉ̃goye carorijere ricaati jee yaparo, carupaa rotori jiyari joerecõãña. Bairo áti yaparo, trigo pʉamerẽ mʉjãã cajero yʉ boya. Jee yaparo, yʉ ya wii ʉgarique cũrĩcã wiipʉ mʉjãã cacũrõ yʉ boya,” ñigʉ trigore cajebojari majãrẽ,’ na ĩñupʉ̃ ti wese upaʉ,” na ĩcõña quetibʉjʉwĩ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo na ĩnemowĩ Jesús tunu cʉ̃tʉ catʉ̃gorã etarãrẽ: “Tunu mostaza na caĩrĩ apeacarẽ jĩcãʉ̃ cʉ̃ wesepʉ cʉ̃ caotericaacarẽ bairo niña Dios cʉ̃ carotimasĩrĩpaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tia apeacã pʉame õcããcã majũ nimirõcʉ̃ã, marĩ caotero bero bʉtiátó, pairicʉ majũ áya, nipetirije wesepʉ oterique netõrõ. Bairi minia cʉ̃ã tii yucʉ rʉpʉripʉre na ria batiirire qũẽnorĩ nicõãmasĩñama. Torea bairo niña Dios cʉ̃ carotimasĩrĩpaʉ cʉ̃ã,” na ĩcõña quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo na ĩnemowĩ Jesús tunu cʉ̃tʉ catʉ̃gorã etarãrẽ: “Levadurare bairo niña Dios cʉ̃ carotimasĩrĩpaʉ. Jĩcãõ trigo wãĩãrĩqũẽ wetare, itiarʉ majũ oco mena weyo yaparo, levadurare petoaca jããñamo. Bairo petoaca cõ cajããmiatacʉ̃ãrẽ, tie pʉame jesapeticoaya yua. Torea bairo niña Dios cʉ̃ carotimasĩrĩpaʉ cʉ̃ã,” na ĩcõña quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Torea bairo jeto na ĩcõña quetibʉjʉnucũwĩ Jesús nipetiro camasã cʉ̃tʉ catʉ̃gorã etarãrẽ. Dise ũnie quetibʉjʉriquere ĩcõñaetiri na quetibʉjʉemi. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bairo Dios bʉsʉrica tutipʉ profeta cʉ̃ caĩwoatuquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiwʉ. Atore bairo ĩ woatuyayupi profeta, Jesús cʉ̃ caĩpeere: “Capee wãme ĩcõñarĩ yʉ quetibʉjʉgʉ camasãrẽ. Ati ʉmʉrecóo Dios cʉ̃ caqũẽnoparo jʉ̃goye camasã na catʉ̃goetajere na yʉ quetibʉjʉgʉ,” ĩ woatu quetibʉjʉ jʉ̃goyeticũñañupĩ profeta. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cabero Jesús camasã cʉ̃tʉ catʉ̃gorã etarãrẽ, “Yʉ áya,” na ĩrĩ bero, jĩcã wiire jããetawĩ. Bairo cʉ̃ cajããetaro bero, jãã, cʉ̃ cabuerã pʉame cʉ̃tʉ jãã etawʉ. Atore bairo cʉ̃ jãã ĩ jẽniñawʉ̃: “¿Dope bairo ĩgaro to ĩñati carorije trigo watoapʉ na caotemirĩqũẽrẽ ĩcõñarĩ mʉ caquetibʉjʉataje? Jãã tʉ̃gomasĩẽtĩãpʉ̃. Bairi jãã mʉ caquetibʉjʉro jãã boya,” cʉ̃ jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩwĩ: “Oterique caroare caotei pʉame, yʉ, Camasã Jʉ̃gocʉre bairo caãcʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Caotei ya wese pʉame ati ʉmʉrecóo macãã yepare bairo niña. Ti wese caputibʉtirique caroa macããjẽ pʉame Dios cʉ̃ carotimasĩrĩpaʉpʉ macããnarẽ bairo niña. Ti wese caputibʉtirique oterique carorije pʉame wãtĩ yarãrẽ bairo niña. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ti wese upaʉ pesu pʉame wãtĩrẽ bairo caãcʉ̃ niñami. Tunu bairoa ti wese caputibʉtirique jericapaʉ caetaro ati ʉmʉrecóo capetiri rʉ̃mʉrẽ bairo niña. Bairi ti wese caputibʉtiriquere jebojari majã pʉame ángelea majãrẽ bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bairi jebojari majã moetiere na cajoerericarore bairo baigaro ati ʉmʉreco capetiri rʉ̃mʉ caetaro yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉ, Camasã Jʉ̃gocʉ, yʉ carotirã ángelea majãrẽ na yʉ jogʉ yʉ carotimasĩrĩpaʉpʉ. Yʉ yarã na catʉ̃goñarĩjẽrẽ royetuo joroque caánarẽ, bairi rorije caáticõãna cʉ̃ãrẽ na yʉ jeneñorotigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ángelea, bairo na cajeeneñopeyoro ĩña yua, caʉ̃petietopʉ na yʉ rerotigʉ. Topʉ bʉtioro otigarãma. Na opire bacarʉpotugarãma, bʉtioro yapapuarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bairo na caáto bero, yʉ yarã, carorije cacʉ̃goenarẽ bairo Dios cʉ̃ caĩñarĩcãrã pʉame muipʉ ʉmʉrecóo macããcʉ̃ cʉ̃ caasiyarijere bairo baupeticoagarãma yʉ Pacʉ cʉ̃ carotimasĩrĩpaʉre. Mʉjãã, caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ,” ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo ĩnemowĩ Jesús tunu: “Dios cʉ̃ carotimasĩrĩpaʉ atore bairo niña: Pairo cawapacʉtie capee moneda tiirire wesepʉ aperã na cayacũyasioricarore bairo niña. Bairi caʉ̃mʉ jĩcãʉ̃ tiere ĩña acʉari yua, jicoquei tiere yanemoñupʉ̃ tunu. Bairo áti yaparo, ʉseanirĩqũẽ mena cʉ̃ yaye apeye ũnie nipetirijere aperãrẽ nuni, tie wapa jeyupʉ, ti wesere wapatigʉ. Bairo cʉ̃ cawapatinunirõ, cʉ̃ yaye cʉ̃ cabocaataje cʉ̃ yaye majũ nicõãñuparõ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Dios cʉ̃ carotimasĩrĩpaʉ tunu atore bairo niña: Jĩcãʉ̃, cʉ̃ yayere canunireri majõcʉ perla caroaro cabotiri rupaacarẽ macãʉ̃ ácʉ́ baiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bairo cʉ̃ caátó, jĩcã, tocãnacã rupaa netõrõ caroa botirica majũrẽ bócacõãñupʉ̃. Bairo bócari, cʉ̃ yaye apeye ũnie nipetirijere aperãrẽ nuni, tie wapa jeyupʉ, tiare wapatigʉ. Bairo cʉ̃ cawapatiro, tia cʉ̃ ya majũ nicõãñuparõ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Dios cʉ̃ carotimasĩrĩpaʉ tunu atore bairo niña: Ria capairiyapʉ wai wasarã aperã na bapire na carocañuajorore bairo niña. Bairo camasã na caáto, wai capããrã tocãnacã wãme majũ ti bapire jããñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bairo na cajããrõ ĩña, wemoñuparã ti bapire paputiropʉ. Wemo yaparo yua, waire na beseruiyuparã. Wai caroarã jetore boyuparã. Carorã pʉamerẽ na recõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","“Torea bairo baigaro ati ʉmʉrecóo capetiparo jʉ̃goye. Ángelea majã pʉame ati yepapʉ etarã, camasã carorãrẽ na ricawori caʉ̃petietopʉre na regarãma. Topʉ bʉtioro otigarãma. Na opire bacarʉpotugarãma, bʉtioro yapapuarã yua,” ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩ jẽniñawĩ Jesús: —¿Mʉjããrẽ yʉ caquetibʉjʉatajere mʉjãã tʉ̃gomasĩati? Bairo cʉ̃ caĩjẽniñarõ, “Jãã tʉ̃gomasĩña,” cʉ̃ jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩnemowĩ tunu: —Ni jĩcãʉ̃, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuei ũcʉ̃ Dios cʉ̃ carotimasĩrĩpaʉ macããjẽrẽ cʉ̃ cajʉ̃gobueata, jĩcãʉ̃ wii upaʉre bairo nigʉmi. Ti wii upaʉ pʉame cʉ̃ ya wii macããjẽ cʉ̃ caqũẽnocũrĩqũẽ pʉga wãme mena átimasĩñami cawãma apeye ũnie mena cʉ̃ãrẽ, bairi cabʉcʉ apeye ũnie mena cʉ̃ãrẽ. Cʉ̃rẽã bairo nigʉmi, cajʉ̃gobuei cawãma macããjẽ yʉ cabuerije, bairi tunu Moisés ãnacʉ̃ cʉ̃ cacũrĩqũẽrẽ cabʉcʉ macããjẽrẽ cariape cʉ̃ catʉ̃goñaata —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bairo atie capee wãme ĩcõña quetibʉjʉ yaparori bero, ti macãpʉ witi acoámí. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bairo witi acoátí yua, cʉ̃ ya yepa majũpʉ etawĩ. Eta, ti yepa macããna na cañubueri wiire jããetawĩ, na quetibʉjʉgʉ. Bairo cʉ̃ caquetibʉjʉro tʉ̃go, to macããna pʉame tʉ̃gocõã maniáma. Atore bairo ĩwã: —Ãnia, caroaro jĩcãrõ tʉ̃ni quetibʉjʉyami. ¿Noopʉ atie caroaro cʉ̃ caquetibʉjʉmasĩrĩjẽrẽ cʉ̃ masĩñuparĩ? ¿Dope bairo átijẽñorĩqũẽ cʉ̃ãrẽ cʉ̃ átimasĩñuparĩ? ");
INSERT INTO cbcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ãni, yucʉpãĩrĩ mena rocapata ũnierẽ caqũẽnoʉ macʉ̃ mee cʉ̃ ãniñati? ¿Marĩ mena macããcõ, María macʉ̃ mee cʉ̃ ãniñati? Bairi, ¿Santiago, José, Simón, Judas jʉ̃gocʉ mee cʉ̃ ãniñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Cʉ̃ marĩ masĩjãñuña. Bairi, ¿marĩ mena macããna rõmirĩ jʉ̃gocʉ mee cʉ̃ ãniñati? Bairi, ¿noopʉ atie nipetirije cʉ̃ camasĩrĩjẽrẽ cʉ̃ masĩñuparĩ? —ãmeo ĩ jẽniñawã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bairo Jesure qũĩroagaetiri, cʉ̃ ya macã macããna pʉame cʉ̃ caquetibʉjʉrijere tʉ̃gogaema. Bairo na catʉ̃gogaeto ĩña, atore bairo na ĩwĩ Jesús: —Profeta majã tocãnacãʉ̃pʉrea na ĩroanucũñama camasã nipetiro na cañesẽãrõpʉ. Na ya macã macããna, bairi na ya wii macããna majũ roque na boetinucũñama. Na yarã jeto na ĩroaetinucũñama —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bairi cʉ̃ ya macã macããna cʉ̃ caquetibʉjʉrijere cariape na catʉ̃gogaetoi, capee caroa cʉ̃ caátijẽñomasĩrĩjẽrẽ topʉre áti ĩñoemi Jesús yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti rʉ̃mʉrĩ majũã Herodes, Galilea yepa macããna quetiupaʉ pʉame queti tʉ̃goyupʉ Jesús cʉ̃ caátimasĩrĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bairo tiere tʉ̃go, atore bairo na ĩñupʉ̃ cʉ̃ carotirãrẽ: “Jesús na caĩ, cʉ̃ã ãcʉ̃mi Juan el Bautista cabaiyasiricʉ ãnacʉ̃ tunu cacati majũ. Bairo cabai ãnirĩ capee átijẽñomasĩĩmi,” na ĩñupʉ̃ Herodes. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mai, cajʉ̃goyepʉ Herodes pʉame Juarẽ ñerotiyupʉ. Bairo cʉ̃ ñerotiri bero, ãpõãwẽ mena cʉ̃ jiyari, preso jorica wiipʉ cʉ̃ cũrocaroti joyupʉ. Juan cʉ̃ caquetibʉjʉrijere boesupʉ Herodes. Mai, “Mʉ bai Felipe nʉmo Herodías na caĩõ mena mʉ caãnie ñuẽtĩña. Carorije niña mʉ caátie,” cʉ̃rẽ cʉ̃ caĩquetibʉjʉrijere boesupʉ. Bairo boetiri preso jorica wiipʉ cʉ̃ cũrocaroti joyupʉ Herodes pʉame Juarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tunu nipetiro camasã Juarẽ, “Dios cʉ̃ caquetibʉjʉrotijoʉ ãcʉ̃mi,” ĩrã, cʉ̃ maijãñuñuparã. Bairi Herodes pʉame jicoquei Juarẽ cʉ̃ pajĩãroca rotigamicʉ̃ã, bairo átiroti masĩẽsupʉ, camasã yʉ tutirema, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bairo jĩcã rʉ̃mʉ yua, Herodes cʉ̃ cabuiarica rʉ̃mʉ caetaro, bose rʉ̃mʉ qũẽnoñupʉ̃. Bairo cʉ̃ caqũẽnorõ, Felipe nʉmo caãnimirĩcõ Herodías cawãmecʉco macõ pʉame basa ĩñoñupõ, Herodes cʉ̃ capiijoatana cõ na caĩñaparore bairo ĩõ. Herodes cʉ̃ã cõ cabasarijere ĩñajesomajũcõãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bairi nipetirã na catʉ̃goro, atore bairo cõ ĩñupʉ̃ Herodías macõrẽ Herodes pʉame: “Noo, yʉre mʉ cajẽnigari wãmerẽ yʉ jẽniña. Mʉ yʉ jomajũcõãgʉ. Ĩtoricaro mano Dios mena ñiña,” cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bairo cawãmao pʉame tiere tʉ̃gori, cõ pacore jẽniñao ásúpo. Cabero yua, cõ paco cõrẽ cõ caĩrotirore bairo qũĩñupõ Herodere: —Bairo yʉ boya: Ãmeacã Juan el Bautista rʉpoare patanerĩ jotʉ bapapʉ jããrĩ, yʉ mʉ jowa —qũĩñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bairo cõ caĩrõ tʉ̃go, tʉ̃goña yapapuacoásupʉ Herodes pʉame. Bairo tʉ̃goña yapapuamicʉ̃ã, “‘¡Dios mena ñiña!’ cõrẽ yʉ caĩatajere yʉ tʉ̃goama yʉ capiijoatana,” ĩ yua, cõrẽ cʉ̃ caĩatatore bairo átirotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bairi cʉ̃ ʉ̃mʉarẽ Juan preso jorica wiipʉ caãcʉ̃rẽ cʉ̃ rʉpoa patarotijoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ caĩrõrẽ bairo cʉ̃ ásuparã Juarẽ. Bairo cʉ̃ pajĩã yaparori bero, cʉ̃ ãnacʉ̃ rʉpoare jotʉ bapa buipʉ nejããrĩ, Herodías macõrẽ cõ nuniñuparã. Cõ pʉame cõ pacore cʉ̃ rʉpoa ãnatõrẽ cõ neásúpo, cʉ̃ cayasiro cõ masĩáto, ĩõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cabero Juan cʉ̃ cabuemirĩcãrã pʉame bairo cʉ̃rẽ na capajĩãrocarijere queti tʉ̃gori, preso jorica wiipʉ etarã, cʉ̃ ãnacʉ̃ rupaʉre neásúparã, masã opepʉ cʉ̃ yarocagarã. Bairo áti yaparori bero, Jesutʉ etawã, tie quetire cʉ̃ quetibʉjʉrã etarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bairo Jesús na caĩquetibʉjʉro tʉ̃go, topʉ caãniatacʉ cũmuarẽ ájããrĩ camasã manopʉ jãã jʉ̃goacoámí. Bairo jãã caátíere masĩrĩ yua, ti macãã macããna camasã pʉame maapʉ ʉtabʉcʉra tʉ̃ni ásúpa, jãã ẽñota áná. Bairo áná, jãã jʉ̃goye etayupa. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bairi Jesús ʉtabʉcʉra ape nʉgõãpʉ pẽñaeta yua, maanʉcãwĩ. Maanʉcãrĩ yua, camasã capããrãrẽ na ĩñawĩ. Bairo na cabairo, bopacooro na ĩñawĩ. Bairi na mena macããna cariayecʉna na caneatíatanarẽ na catiowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bairo na cʉ̃ caáticõãno, ñamicããcã nicoa ápʉ́. Bairi jãã, cʉ̃ cabuerã pʉame Jesutʉ etari, atore bairo cʉ̃ jãã ĩwʉ̃: —Merẽ ñamicã majũ niña. Atopʉre wiiri maniña. Dope camasã capããrãrẽ na marĩ áperã. Bairi ãnoarẽ na mʉ árotiwa macããpʉ, na majũ na caʉgapeere na wapatirápáro —jãã ĩwʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bairo jãã caĩrõ tʉ̃gomicʉ̃ã, atore bairo jãã ĩwĩ: —Aperopʉ na caʉgapeere na wapatira rotieticõãña. Mʉjãã majũ na ʉgarique nuña —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bairo cʉ̃ caĩrõ tʉ̃go, bairo cʉ̃ jãã ĩwʉ̃: —Jãã, jĩcã wãmo cãrõ pan jororiaca, wai, pʉgarããcã tocãrõã jãã cʉ̃goya —cʉ̃ jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bairo jãã caĩrõ: “Ato pʉame jeasá,” jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ĩ yaparo, camasã capããrã to caãnarẽ taa yepapʉ na ruirotiwĩ. Bairo na caruiro ĩña, pan rupaa jĩcã wãmo cãnacã rupaacarẽ, wai pʉgarã mena nee, jõbuire ĩñamʉgõjori, “Jãã mena mʉ ñujãñuña,” Diore qũĩ jẽniwĩ. Bairo qũĩ jẽni yaparo, pan rupaare carecomacã peeri, jãã, cʉ̃ cabuerãrẽ, jãã nuniwĩ, camasãrẽ jãã cabatoparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bairo jãã cabatoro bero yua, nipetiro camasã caroaro ʉgayapicoáma, ʉgariquere narẽ jãã cabatoatajere. Bairo na caʉgatuaro bero, jãã jejããwʉ̃ piiripʉ na caʉgarʉgarijere. Pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã piiri majũ jãã jejããjirowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","To caãna caʉgaatana jĩcã wãmo cãnacã mil majũ camasã ãma, carõmia, bairi cawĩmarã cʉ̃ã cõñaña manoa. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tipaʉ bero, jãã, cʉ̃ cabuerãrẽ cũmuapʉ jãã ájããrotiwĩ Jesús tunu. Camasãrẽ na cʉ̃ caĩñatʉsajotoye, ti ʉtabʉcʉra jĩnʉgõãpʉ cʉ̃ jʉ̃goye jãã capẽñaátó bowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bairi camasãrẽ na ĩñatʉsajo yaparo, ʉ̃tãʉ̃ buipʉ wãmʉcoásúpi Jesús, Diore cʉ̃ jẽniácʉ́. Bairi muipʉ cʉ̃ cajããrõ canaioatípaʉ, jĩcãʉ̃ã ãñupĩ Jesús ti ʉ̃tãʉ̃ buipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jãã pʉame merẽ cũmua mena tira recomacã majũpʉ jãã ãmʉ. Bairo jãã caãno, oco turi pʉame bʉtioro jabewʉ. Wĩno cʉ̃ã bʉtioro jãã riape jãã paputunuo pocõãwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bairo roro jãã cabairo, cabusuparo jʉ̃goyeaca oco bui peari jããtʉ amí Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bairo oco buipʉ cʉ̃ caató ĩña yua, “Apei ũcʉ̃ ãcʉ̃mi,” ĩrã, jãã, cʉ̃ cabuerã uwiri bairo jãã awajawʉ: —¡Ãni, camasocʉ ãnacʉ̃ wãtĩ marĩtʉ atíyami! —jãã ĩwʉ̃. Bʉtioro cauwirã ãnirĩ bairo jãã awajawʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bairo jãã cabairo, Jesús pʉame jãã ĩ jowĩ: —¡Tʉ̃goñatutuaya yʉ yarã, Jesua yʉ ãniña, yʉ uwieticõãña! —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩwĩ Pedro Jesure: —Mʉ, jãã Quetiupaʉ cariape mʉ caãmata, mʉtʉ oco buipʉ yʉ árotiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Bairo cʉ̃ caĩrõ tʉ̃go, “Jaʉ, yʉtʉ asá,” qũĩwĩ Jesús Pedrore. Bairo cʉ̃ caĩrõ tʉ̃go, Pedro, jãã cũmuapʉ cajãñaatacʉ pʉame cũmuarẽ ruiri oco buipʉ Jesutʉ ámiwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bairo ámasĩmicʉ̃ã, wĩno bʉtioro cʉ̃ caĩñarõ capapunemorõ, tʉ̃goña uwirique Pedrore etawʉ. Eta yua, ruacõã ruinutuami. Bairi atore bairo qũĩ awajawĩ Pedro Jesure: —¡Yʉ Quetiupaʉ, yʉre ñei asá! ¡Rua ácʉ́ yʉ baiya! ");
INSERT INTO cbcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bairo cʉ̃ caĩrõ tʉ̃go, jicoquei Jesús cʉ̃ wãmo ñujori Pedrore cʉ̃ ñewĩ. Ñerĩ yua, atore bairo qũĩwĩ: —Yʉ yaʉ, ¡jĩrĩãcã majũ yʉ mena mʉ tʉ̃goñatutuaya! ¿Nopẽĩ, “Yʉ ámasĩẽcʉ̃,” mi tʉ̃goñaati? —qũĩwĩ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bairo cũmuapʉ na caájããrõ, wĩno pʉame papujãnacoapʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bairo cabairo ĩña, jãã, cũmuapʉ caãna pʉame Jesutʉ rʉpopaturi mena etanumurĩ cʉ̃ jãã ĩroawʉ: —¡Cariape Dios macʉ̃ majũ mʉ ãniña! —cʉ̃ jãã ĩwʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bairo pẽñaáná, ʉtabʉcʉra ape nʉgõãpʉ jãã etawʉ, Genesaret cawãmecʉti yepapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bairo jãã caetaro ĩña, to macããna pʉame Jesure qũĩñamasĩwã. Bairi cʉ̃ caetarije quetire ti yepa nipetiropʉ quetibʉjʉ batoyupa, cariayecʉnarẽ na caneatíparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bairi na pʉame, Jesutʉ eta, atore bairo tʉ̃goñañupã: “Cʉ̃ jutiro yapa ũno cʉ̃ãrẽ marĩ capãñaata, marĩ caticoagarã,” ĩ tʉ̃goñañupã. Bairo pãñarĩqũẽrẽ bʉtioro cʉ̃ jẽniwã. Bairo cariayecʉna tocãnacãʉ̃ã cʉ̃ jutiro yapare capãñarã caticoama. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cabero etawã fariseo majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena. Na pʉame Jerusalén macãpʉ caatíatana ãma. Atore bairo qũĩwã Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nopẽĩrã mʉ cabuerã marĩ ñicʉ̃jãã ãnana na caroticũrĩqũẽrẽ bairo na áperiyati? Coseetiyama na wãmorĩrẽ na caʉgaparo jʉ̃goye —qũĩwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bairo na caĩrõ tʉ̃go, atore bairo na ĩ jẽniñawĩ Jesús: —¿Nopẽĩrã mʉjãã cʉ̃ã mʉjãã caátinucũrĩjẽrẽ bʉtioro borã, Dios marĩrẽ cʉ̃ caroticũrĩqũẽ pʉamerẽ mʉjãã áperinucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios pʉame atore bairo marĩ rotiyupi: “Mʉjãã pacʉare mʉjãã caĩroaro yʉ boya. Ni ũcʉ̃ cʉ̃ pacʉre, o cʉ̃ pacore roro cʉ̃ caĩata, cʉ̃ mʉjãã pajĩãrocacõãgarã,” ĩ quetibʉjʉ cũñupĩ Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bairo cʉ̃ caĩcũmiatacʉ̃ãrẽ, mʉjãã pʉame ricaati mʉjãã quetibʉjʉya camasãrẽ. Atore bairo mʉjãã ĩña: “Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ pacʉre, o cʉ̃ pacore, ‘Yʉ yaye nipetirijere merẽ Diore cʉ̃ yʉ nuniapʉ̃. Bairi mʉjãã cabopacarijere yʉ nunimasĩẽtĩña,’ cʉ̃ caĩata, ñurõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bairi ni jĩcãʉ̃ ũcʉ̃ tore bairo caĩ ãnirĩ, cʉ̃ pacʉre, o cʉ̃ pacore cʉ̃ cajʉátinemorõ átirotietiya,” mʉjãã ĩ quetibʉjʉya. Bairo ĩ quetibʉjʉrã, Dios marĩrẽ cʉ̃ caroticũrĩqũẽrẽ cajãnarotirãrẽ bairo mʉjãã baiya. Bairo caquetibʉjʉrã ãnirĩ netõjãñurõ mʉjãã boya mʉjãã caátinucũrĩjẽ mʉjãã ya wãme pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Caĩtopairã majũ mʉjãã ãniña! Dios pʉame Isaías ãnacʉ̃ cʉ̃ cawoaturica pũrõpʉ mʉjãã ũnarẽ cʉ̃ caĩquetibʉjʉnetõjʉ̃goyeticũrĩcãrõrẽ bairo mʉjãã baimajũcõãña. Atore bairo ĩñupĩ Dios mʉjããrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ati poa macããna na bʉsʉrique mena yʉre caĩroarãrẽ bairo baiyama. Bairo baimirãcʉ̃ã, na yeri na catʉ̃goñarĩjẽpʉ ricaati baicõãñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na pʉame, “Camasã na carotirique pʉamerẽ Dios cʉ̃ caquetibʉjʉroticũrĩqũẽ netõjãñurõ caãnimajũrĩjẽ niña,” caĩrãrẽ bairo buenucũñama. Bairo cabuerã na caãnoi, yʉre na cañubuegarije dope bairo átimasĩã maa,’ ĩñupĩ Dios mʉjãã cabaipeere —na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ĩ quetibʉjʉ yaparo, camasãrẽ na piineñorĩ, atore bairo na ĩwĩ Jesús: —Tʉ̃gopeoya yʉ yaye quetibʉjʉriquere. Tiere tʉ̃gomasĩña: ");
INSERT INTO cbcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Camasã na caʉgarije wapa jʉ̃gori mee carorã niñama. Na majũã rorije na yeripʉ na catʉ̃goñanucũrĩjẽ jʉ̃gori roque carorã niñama —na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bairo cʉ̃ caĩrõ tʉ̃go, jãã, cʉ̃ cabuerã pʉame cʉ̃tʉ etari, atore bairo cʉ̃ jãã ĩwʉ̃: —Bairo mʉ caĩrõ, fariseo majãrẽ tʉ̃goasiao joroque na mʉ áticʉpʉ —cʉ̃ jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩwĩ: —Wesepʉ moetie camasã na caoteetiere, to majũ caputirijere wãrocanucũñama. Torea bairo yʉ Pacʉ ʉmʉrecóo macããcʉ̃ camasã tocãnacãʉ̃ cʉ̃ yarã caãmerãrẽ na beseregʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bairi fariseo majã na caĩrĩjẽrẽ tʉ̃gopeoeticõãña. Na pʉame cacaapee mána, aperã na bapa cacaapee mána cʉ̃ãrẽ, “Mʉjããrẽ jãã jʉ̃gogarã,” caĩrãrẽ bairo niñama. Ni jĩcãʉ̃ ũcʉ̃ cacaapee mácʉ̃ pʉame, apei cʉ̃ bapa cacaapee mácʉ̃rẽ, “Mʉ yʉ jʉ̃gogʉ,” cʉ̃ caĩata, na pʉgarãpʉa opepʉ rocajãcõãbujiorãma —jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bairo cʉ̃ caĩrõ tʉ̃gomicʉ̃ã, tʉ̃gomasĩẽmi Pedro. Bairi atore bairo qũĩwĩ Jesure: —Ape wãme ĩcõñarĩ jããrẽ mʉ caquetibʉjʉrije, ¿dope bairo ĩgaro to ĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩwĩ Jesús Pedrore: —¿Mʉjãã cʉ̃ã yʉ yaye quetire mʉjãã tʉ̃gomasĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","18","Nipetiro camasã na caʉgarije tocãnacã wãme pʉame na paaropʉ yuaya. Yuari yua, cabero netõcoaya. Na caʉgarije mee na yeri pũna to royetuo joroque na átiya. Roro na catʉ̃goñarĩjẽ jʉ̃gori roque carorije caánarẽ bairo na ĩñañami Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Camasã na yeripʉ roro na catʉ̃goñarĩjẽ jʉ̃gori aperãrẽ na pajĩãreyama. Aperã na nʉmoa mee, o na manapʉ̃ã mena mee roro ãniñama. Cawãmarã cawãmojiyaena cʉ̃ã bairoa roro ãnajẽ cʉtiyama. Tunu bairoa aperã jerutiyama. Aperã mʉnana ĩñama. Aperã bʉsʉpaiyama. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bairo camasã na yeripʉ roro na catʉ̃goñarĩjẽ jʉ̃gori roro átiyama. Bairo na wãmorĩ coseena na caʉgarije wapa mee, roro na caátie jʉ̃gori carorije caánarẽ bairo na ĩñañami Dios —jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ĩ quetibʉjʉ yaparo, topʉ caãniatacʉ Tiro, Sidón cawãmecʉtopʉ ámí. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Topʉ cʉ̃ caetaro, ape yepa macããcõ, Canaán na caĩrĩ yepa macããcõ pʉame Jesutʉ etawõ. Bairo etari, bʉsʉrique tutuaro mena bairo qũĩwõ Jesure: —¡Yʉ Quetiupaʉ, David ãnacʉ̃ pãrãmi, bopacooro ñiñaña! ¡Yʉ macõ wãtĩ yeri pũnarẽ cʉ̃goyamo! —qũĩwõ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús pʉame cõ yʉemi. Bairo cʉ̃ cayʉeto ĩña, jãã, cʉ̃ cabuerã pʉame cʉ̃tʉ etari, atore bairo cʉ̃ jãã ĩwʉ̃: —Aperopʉ cõ árotiya. Awajari jãã berore ʉsayamo. Awaja jãnaẽtĩñamo —cʉ̃ jãã ĩwʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩwĩ: —Ape poa macããnarẽ yʉ jʉátinemo rotiemi Dios. Yʉ yarã, israelita majã jeto, oveja nurĩcãrã cayasiricarãrẽ bairo caãnarẽ yʉ jʉátinemorotiwĩ Dios —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, carõmio pʉame rʉpopaturi mena etanumurĩ atore bairo qũĩwõ Jesure: —¡Yʉ Quetiupaʉ, yʉ jʉátinemobojaya! —qũĩwõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bairo cõ caĩrõ tʉ̃go, bairo cõ ĩwĩ: —Mʉa, israelita yao mee mʉ ãniña. Bairi mʉ yʉ cajʉápata, jĩcãʉ̃, cʉ̃ pũnaa na caʉgarije pan rupaare ẽmarĩ cʉ̃ wii yaiare canureire bairo yʉ átibujioʉ —cõ ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩwõ. —Bairoa mʉ átibujioʉ baipʉa. Bairo mʉ caĩmiatacʉ̃ãrẽ, bairãpʉa cawĩmarã na caʉgawerije yepapʉ cañarĩjẽãcãrẽ ʉganucũñama wii yaia cʉ̃ã. Bairi na caʉgaricaroacarẽ bairo yʉ mʉ jʉátigʉ petoaca —qũĩwõ carõmio Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Bairo cõ caĩrõ tʉ̃go, bairo cõ ĩwĩ: —Mʉa, yʉ mena mʉ tʉ̃goñatutua netõmajũcõãña. ¡Bairi yʉ mʉ cajẽnirõrẽ bairo to baiáto! —cõ ĩwĩ. Bairo cʉ̃ caĩrõ, jicoquei caticoamo, cananea yao macõ, wãtĩ yeri pũna cacʉ̃gomiataco pʉame yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bairo topʉ caãniatacʉ Jesús acoámí Galilea ʉtabʉcʉra tʉpʉ tunu. Topʉ eta, tira tʉ̃ni ʉ̃tãʉ̃rẽ wãmʉcoámí. Bairi topʉ tuanumuetawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bairo topʉ cʉ̃ caruiro, camasã capããrã na yarã cariayecʉnarẽ cʉ̃tʉ na ne etawã. Na mena macããna jĩcããrã caámasĩẽna ãma. Aperã cacaapee ĩñamasĩẽna ãma. Aperã carupayuriri ãma. Aperã cabʉsʉena ãma. Aperã capee riayecʉna ãma. Bairi na yarã pʉame Jesús rʉpori tʉaca na cũrã etawã. Bairo na caáto ĩña, Jesús pʉame na catiowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bairo na cacatiro ĩñarã, to macããna pʉame ĩña acʉacoama. Cabʉsʉmasĩẽtĩmiatana merẽ bʉsʉmasĩwã. Tunu bairoa carupayuriri caãnimiatana merẽ catipeticoama. Caámasĩẽtĩmiatana merẽ ámasĩwã. Tunu bairoa caĩñamasĩẽtĩmiatana cʉ̃ã merẽ caroaro ĩñamasĩcoáma. Bairo na cacatiro ĩñarĩ cʉ̃ basapeojʉ̃gowã to macããna, jãã, Israel macããna jãã caĩroʉ Diore. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cabero Jesús pʉame, jãã, cʉ̃ cabuerãrẽ piijowĩ. Bairo jãã caetaro ĩña, atore bairo jãã ĩwĩ: —Ãnoa camasã merẽ itia rʉ̃mʉ majũ yʉ mena nicõãñama. Ñe ũnie majũ ʉgarique cʉ̃goetiyama. Bairi bopacooro na ñiñaña. Jicoquei na yʉ tunuo jogaetiya mai. Caʉgarique ʉgaenarẽ na yʉ catunuojoata, áwẽpʉ̃ẽtĩbujiorãma, na ya wiiripʉre áná. Bairi na marĩ ʉgarique nuto —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo cʉ̃ jãã ĩwʉ̃: —Ãnoa camasã capããrã niñama. Tunu atopʉ wiiri maniña. Bairi, ¿noopʉ marĩ bocarãti ʉgarique, pairo narẽ marĩ canupeere? —cʉ̃ jãã ĩ jẽniñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bairo jãã caĩrõ, Jesús pʉame jãã ĩnemowĩ tunu: —Pan rupaa, ¿nocãnacã rupaa majũ mʉjãã cʉ̃goyati? Bairo cʉ̃ caĩrõ, atore bairo cʉ̃ jãã ĩwʉ̃: —Jãã, jĩcã wãmo peti pʉga pẽnirõ cãrõ pan rupaaca, wai jĩcãrãcã jeto tocãrõã jãã cʉ̃goya —cʉ̃ jãã ĩwʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bairo jãã caĩrõ tʉ̃go, camasãrẽ yepapʉ na ruirotiwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bairo na caruiro ĩña, tie pan jĩcã wãmo peti pʉga pẽnirõ caãni rupaare, wai mena nerĩ, Diore, “Jãã mena mʉ ñujãñuña,” qũĩ jẽniwĩ. Bairo qũĩ jẽni yaparori bero, tie pan, bairi wai cʉ̃ãrẽ carecomacã peeri bero, jãã, cʉ̃ cabuerãrẽ jãã nuniwĩ, camasãrẽ jãã batoroti. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bairo jãã caáto yua, nipetiro camasã caroaro ʉgayapicoáma, ʉgarique jãã cabatoatajere. Bairo na caʉgatuaro bero, jãã jejããwʉ̃ piiripʉ na caʉgarʉgarijere. Jĩcã wãmo peti pʉga pẽnirõ cãnacã piiri majũ jãã jejããjirowʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","To caãna caʉgaricarã pʉame baparicãnacã mil majũ camasã ãma, carõmia, bairi cawĩmarã cʉ̃ã cõõña manoa. ");
INSERT INTO cbcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Cabero Jesús pʉame camasãrẽ, “Yʉ áya,” na ĩ yaparo, cũmuarẽ ájããwĩ. Bairo cʉ̃ caátáje uwiro bero yua, Magadán cawãmecʉti yepapʉ jãã acoápʉ́ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bairi Magadán yepapʉ cʉ̃ caãno, Jesús cʉ̃ caátiere ĩñarĩ bʉsʉjãgamirã, cʉ̃tʉ etawã fariseo, bairi saduceo majã mena. Bairo etarã, dise ũnie átijẽñorĩqũẽ ʉmʉrecóo macããjẽrẽ Jesure cʉ̃ áti ĩñorotimiwã. “¿Cariape Dios cʉ̃ carotijoricʉ majũ cʉ̃ ãnicʉti?” ĩrã, bairo cʉ̃ átirotimiwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús pʉame na yeripʉ roro na catʉ̃goñarĩjẽrẽ masĩcõãwĩ. Bairi atore bairo na ĩwĩ: “Ʉmʉrecóo cajũãrocajããto ĩñarã, ‘Ñamirõcã caroa rʉ̃mʉ ãnigaro,’ mʉjãã ĩ masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tunu bairoa cabusuripaʉ caãno, oco buseri cañirõ ĩñarã, ‘Oco rʉ̃mʉ ãnigaro,’ mʉjãã ĩ masĩña. Bairo caoco ocapeere, bairi caasipee cʉ̃ãrẽ bairo caĩñamasĩrã nimirãcʉ̃ã, ¿nopẽĩrã Dios ati yʉteare cʉ̃ caátiãnie pʉamerẽ mʉjãã masĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ati yepa macããna, ãme caãna, caroaro Dios mena ãnimasĩẽtĩñama. Jĩcã rʉ̃mʉ cʉ̃ boo, ape rʉ̃mʉ cʉ̃ boetiyama. Átijẽño ĩñorĩqũẽ jetore boyama. Bairo na cabomiatacʉ̃ãrẽ, tiere na áti ĩñoetigʉmi Dios. Merẽ na quetibʉjʉ cũñupĩ Jonás ãnacʉ̃ cʉ̃ cabairiquere,” na ĩ quetibʉjʉwĩ Jesús. Ĩ quetibʉjʉ yaparo, acoámí. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cabero Jesús, jãã, cʉ̃ cabuerã ʉtabʉcʉra ape nʉgõãpʉ jãã ápʉ́ tunu. Mai, jãã caʉgapee, pan rupaare masiriticõãrĩ jãã jeápéwʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Bairo jãã cabairo, Jesús pʉame bairo jãã ĩwĩ: —Tʉ̃goya mʉjãã. Fariseo, saduceo majã yaye levadura, pan pairica na cawauorijere boeticõãña —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bairo cʉ̃ caĩrõ tʉ̃go, jãã, cʉ̃ cabuerã, atore bairo jãã ãmeo ĩwʉ̃ jãã majũ: —¡Pan rupaa marĩ cajeatíbujioatajere marĩ masiriticũũpã! Bairi bairo marĩ ĩĩmi —jãã ãmeo ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús pʉame masĩcõãwĩ jãã caãmeoĩrĩjẽrẽ. Bairi atore bairo jãã ĩnemowĩ tunu: —¿Nopẽĩrã, “‘Pan rupaa na cajeatíbujioatajere na masiritiupari,’ ĩgʉ ĩcʉ̃mi Jesús,” mʉjãã ãmeo ĩñati? Bairo mee ĩgʉ ñiña. ¡Yʉ mena mʉjãã tʉ̃goña tutuaetimajũcõãña! ");
INSERT INTO cbcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mʉjãã tʉ̃goña masĩẽtĩñati mai? ¿Yoaro mee mʉjãã masiriticoayati yʉ caátijẽñorĩqũẽrẽ? Pan rupaa, jĩcã wãmo cãnacã rupaa jetore cʉ̃gomicʉ̃ã, caʉ̃mʉa jĩcã wãmo cãnacã mil majũ na ʉga yapicoao joroque na yʉ ápʉ. Tiere mʉjãã ĩñawʉ̃. Bairo caĩñarĩcãrã ãnirĩ cabero piiripʉ na caʉgarʉgariquere, ¿nocãnacã piiri majũ mʉjãã jejããjirori? ¿Tiere mʉjãã masiriticoayati? ");
INSERT INTO cbcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tunu bairoa ape rʉ̃mʉ pan rupaa, jĩcã wãmo peti pʉga pẽnirõ cãnacã rupaa jetore cʉ̃gomicʉ̃ã, caʉ̃mʉa baparicãnacã mil majũ na ʉga yapicoao joroque na yʉ ápʉ. Tie cʉ̃ãrẽ mʉjãã ĩñawʉ̃. Bairo caĩñarĩcãrã ãnirĩ cabero piiripʉ na caʉgarʉgariquere, ¿nocãnacã piiri majũ mʉjãã jejããjirori? ¿Tiere mʉjãã masiriticoayati? ");
INSERT INTO cbcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mʉjãã masiritiena. Bairi, ¿nopẽĩrã, “‘Pan rupaa na cajeatíbujioatajere na masiritiupari,’ ĩgʉ ĩcʉ̃mi Jesús,” caĩrãrẽ bairo mʉjãã ãmeo ĩñati? —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bairo cʉ̃ caĩrõ tʉ̃go, jãã tʉ̃goñamasĩwʉ̃ cʉ̃ caĩgarijere: “‘Fariseo, saduceo majã mena levadura, pan pairica na cawauorijere mʉjãã boepa,’ ĩrĩcãrõ ũnorẽã, ‘Ricaati na caquetibʉjʉrijere mʉjãã boepa,’ marĩ ĩgʉ ĩcʉ̃mi Jesús,” jãã ĩ tʉ̃goñamasĩwʉ̃, jãã, Jesús cʉ̃ cabuerã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cabero Cesarea de Filipo na caĩrĩ yepapʉ Jesús etari bero, atore bairo, jãã, cʉ̃ cabuerãrẽ jãã ĩwĩ: —¿Noa ãcʉ̃mi Camasã Jʉ̃gocʉre, yʉ na ĩnucũñati? —jãã ĩ jẽniñawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo cʉ̃ jãã ĩwʉ̃: —Jĩcããrã ĩñama: “Juan el Bautista ãcʉ̃mi.” Aperã ĩnucũñama: “Elías ãnacʉ̃ tunu catiri ãcʉ̃mi,” miñama. Aperã ĩnucũñama: “Jeremías, o apei profeta ãnacʉ̃ tunu catiri ãcʉ̃mi Jesús,” minucũñama —cʉ̃ jãã ĩ quetibʉjʉwʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bairo cʉ̃ jãã caquetibʉjʉro bero, atore bairo jãã ĩ jẽniñanemowĩ tunu: —¿Mʉjãã ate? ¿Noa ãcʉ̃mi yʉ mʉjãã ĩnucũñati? —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bairo cʉ̃ caĩrõ tʉ̃go, Simón Pedro pʉame bairo qũĩwĩ Jesure: —Mʉa, Mesías, Dios macʉ̃, tocãnacã rʉ̃mʉ caãnicõãninucũʉ̃ macʉ̃ majũ mʉ ãniña —qũĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩwĩ Jesús Pedrore: —Cʉ̃ã yʉ ãniña. Camasã pʉame yʉ caãnierẽ mʉ masĩõẽtĩñama. Yʉ Pacʉ, ʉmʉrecóo macããcʉ̃ roque mʉ masĩõñupĩ tiere. Bairi ʉseanirĩ ãña mʉ, Simón, Jonás macʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tunu atore bairo mʉrẽ ñiña: Ãmea, “Pedro” mʉ yʉ wãmetiya. Mʉ wãme cawãma wãme pʉame Pedro “ʉ̃tã” ĩgaro ĩña. Bairi noa ũna mʉrẽ bairo catʉ̃goñatutuarã ũna, yʉ ya poa macããna na ãnio joroque na yʉ átigʉ. Bairo caãna ãnirĩ yasietigarãma. Yʉ mena ãnicõãnucũgarãma tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tunu Dios cʉ̃ carotiripaʉ macããnarẽ caátijʉ̃goʉ majũ mʉ yʉ cũgʉ. Bairo caãcʉ̃ ãnirĩ ati yepa ãcʉ̃, “Dios ʉmʉrecóo macããcʉ̃ marĩrẽ cʉ̃ caátirotirije niña,” o “Cʉ̃ caátirotietie niña,” mi quetibʉjʉ besemasĩgʉ Dios yarãrẽ —qũĩwĩ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cabero, jãã, nipetiro Jesús cʉ̃ cabuerãrẽ atore bairo jãã ĩwĩ: “Mesías yʉ ãniña. Bairãpʉa, cʉ̃, yʉ caãnierẽ na quetibʉjʉeticõãña aperã camasãrẽ mai,” jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tipaʉ bero, jãã, cʉ̃ cabuerãrẽ Jerusalẽpʉ cʉ̃ caápére jãã quetibʉjʉ jʉ̃gonutuámí. Jãã quetiuparã cabʉtoa camasĩrã, bairi Dios cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi sacerdote majã quetiuparã cʉ̃ã, popiye cʉ̃ baio joroque na caátipeere jãã quetibʉjʉ jʉ̃gonutuámí, cʉ̃rẽ na capajĩãrotipee majũrẽ. “Bairo yʉ na caátimiatacʉ̃ãrẽ, itia rʉ̃mʉ bero yʉ caticoagʉ tunu,” jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame jõjãñurõ Jesure cʉ̃ neámí. Topʉ eta, bairo qũĩ jʉ̃goyupʉ Jesure: —¡Yʉ Quetiupaʉ, mʉ caĩrõrẽ bairo boecʉmi Dios! ¡Mʉ caĩrõrẽ bairo to baieticõãto! —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bairo cʉ̃ caĩrõ tʉ̃go, Jesús pʉame Pedrore cʉ̃ ãmejore ĩñarĩ, atore bairo qũĩñupʉ̃: —¡Ácʉ́ja wãtĩ Satanás! ¡Bairo mʉ caĩrõ roro yʉ cabaipeere cabʉsʉjãnemoʉrẽ bairo miña! Dios cʉ̃ catʉ̃goñarõrẽ bairo mee, camasã na catʉ̃goñarõrẽ bairo mʉ tʉ̃goñaña, bairo yʉ mʉ caĩata —qũĩñupʉ̃ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cabero Jesús, jãã, cʉ̃ buerãrẽ atore bairo jãã ĩwĩ: —Ni caboʉ, yʉ cabuei caãnigaʉ, cʉ̃ majũ cʉ̃ caátigamirĩjẽrẽ piticõãgʉmi. Yʉ carotirore bairo jeto roque átigʉmi tocãnacã rʉ̃mʉa. Popiye baimicʉ̃ã, yʉ yaye quetire jãnaetigʉmi yʉ cabuei caãnigaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bairo tunu caʉ̃mʉ apei cʉ̃ caãnie pʉamerẽ mairĩ, yʉ yaye quetire jãnacõãgʉmi. Bairo cabai ãnirĩ yasicoagʉmi yua. Apei, yʉ yaye quetire cajãnaecʉ roque netõcoagʉmi. Cʉ̃rẽ na capajĩãrocacõãmiatacʉ̃ãrẽ, caticõã ãninucũgʉmi tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tunu caʉ̃mʉ apei ati yepa macããjẽ nipetirije merẽ cʉ̃goyami, cʉ̃ caborije caãno cãrõ. Bairo cʉ̃gomicʉ̃ã, Diore cʉ̃ tʉ̃goñaẽtĩñami. Bairo catʉ̃goñaecʉ̃ ãnirĩ cʉ̃ cariaatato bero, Dios mena ãmerĩgʉmi. Bairi dope baieto pairo cʉ̃ cacʉ̃gorije pʉame. Wapa maa tie ati ʉmʉrecóo macããjẽ, Diore cʉ̃ camasĩẽtĩcõãta. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉ, Camasã Jʉ̃gocʉ, ati yepapʉ yʉ Pacʉ cʉ̃ camasĩrĩjẽ mena nemo yʉ tunuetagʉ. Ángelea majã, yʉ Pacʉtʉ macããna mena nemo yʉ tunuetagʉ. Ti rʉ̃mʉ pʉamerẽ ati yepa macããna tocãnacãʉ̃pʉrea na caátatorea bairo na cʉ̃ãrẽ na yʉ átigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cariape mʉjããrẽ yʉ quetibʉjʉya: Mʉjãã jĩcããrã, ato caãna, mʉjãã cariaparo jʉ̃goye yʉ, Camasã Jʉ̃gocʉ, quetiupaʉ reyre bairo yʉ caetarore mʉjãã ĩñamajũcõãgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cabero jĩcã wãmo peti jĩcã pẽnirõ cãnacã rʉ̃mʉrĩ bero Pedrore, Santiagore, bairi cʉ̃ bai Juarẽ na piiámí Jesús ʉ̃tãʉ̃ caʉ̃mʉarĩcʉ buipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bairo topʉ na caãno, Jesús pʉame cʉ̃ cabaurije wasoacoasupʉ. Cʉ̃ riape pʉame asiyaro baucoasuparo, muipʉ ʉmʉreco macããcʉ̃ cʉ̃ caasiyarore bairo. Baicõã, cʉ̃ jutiro cʉ̃ã botiro baicoasuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bairo cʉ̃ cabaiãno, Moisés ãnacʉ̃, Elías ãnacʉ̃ mena buiaetayuparã. Bairo buiaetarã yua, Jesús mena bʉsʉpẽni nucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bairo na caĩãno, Pedro pʉame atore bairo qũĩñupʉ̃ Jesure: —Yʉ Quetiupaʉ, ¡atopʉ marĩ caãno ñumajũcõãña! Bairi, “Jaʉ,” mʉ caĩata, itia wiipãĩrĩãcã majũ mʉjããrẽ jãã qũẽnobojagarã. Jĩcã wii mʉ ya wii, ape wii Moisés ya wii, ape wii Elías ya wii mʉjããrẽ jãã qũẽnobojagarã —qũĩñupʉ̃ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bairo cʉ̃ caĩãno, buseriwo caasiyabatori poa atí, na pauma tocoasuparo. Bairo catoro, Pedrojãã pʉame cayʉsʉropʉ ãñuparã. Bairo ãna, bʉsʉrique buseriwo watoapʉ cabʉsʉocajorijere tʉ̃goyuparã. Atore bairo ĩñuparõ: “Ãni, yʉ macʉ̃, yʉ camai majũ niñami. Cʉ̃ caátiãnierẽ ñiñajesoya bʉtioro. Cʉ̃ yaye bʉsʉriquere tʉ̃goʉsaya,” ĩ ocajoyuparo jõbuipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bairo caĩrõ tʉ̃go, Jesús cʉ̃ cabuerã pʉame yepapʉ mubia cũmucoásuparã. Tʉ̃gocõã maniásuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bairo na cabairoi, Jesús pʉame natʉ atí, na pãña, atore bairo na ĩñupʉ̃: —Yʉ yarã, wãmʉnʉcãña, uwieticõãña —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bairo cʉ̃ caĩrõ tʉ̃go, ĩñajoyuparã. Elías, Moisés cʉ̃ã mañuparã yua. Jesús jeto nucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cabero ʉ̃tãʉ̃rẽ na caruiató, atore bairo na ĩñupʉ̃ Jesús Pedrojããrẽ: —Ãme mʉjãã caĩñaatajere aperãrẽ na mʉjãã quetibʉjʉetigarã mai. Cabero yʉ, Camasã Jʉ̃gocʉ, cariacoatacʉ nimicʉ̃ã, yʉ cacatiro bero roque na mʉjãã quetibʉjʉgarã —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bairi cabero atore bairo qũĩ jẽniñañuparã Pedrojãã Jesure: —Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã bairo ĩñama: “Dios cʉ̃ cajopaʉ ati yepapʉ cʉ̃ caetaparo jʉ̃goye Elías ãnacʉ̃ catiri etanemogʉmi tunu,” ĩñama. ¿Nopẽĩrã bairo na ĩ quetibʉjʉyati camasãrẽ? ");
INSERT INTO cbcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bairo na caĩjẽniñarõ, atore bairo na ĩ quetibʉjʉyupʉ Jesús: —Na caĩrõrẽ bairo atíjʉ̃gogʉmi jĩcãʉ̃ Elías ãnacʉ̃rẽ bairo caãcʉ̃. Cʉ̃ pʉame nipetirijere qũẽnojʉ̃gogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Cariape mʉjããrẽ ñiña: Elías ãnacʉ̃rẽ bairo caãcʉ̃ merẽ etawĩ. Bairo cʉ̃ caetamiatacʉ̃ãrẽ, “Cʉ̃ã niñami Elías ãnacʉ̃rẽ bairo caãcʉ̃,” qũĩ masĩẽma camasã pʉame. Bairi ricaati noo na caborore bairo cʉ̃ áma. Torea bairo yʉ, Camasã Jʉ̃gocʉre popiye yʉ baio joroque yʉ átigarãma —ĩ quetibʉjʉyupʉ Jesús Pedrojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bairo cʉ̃ caĩrõ tʉ̃go, Jesús cʉ̃ cabuerã masĩcoasuparã. “Juan el Bautistare ĩgʉ ĩcʉ̃mi Jesús, Elías ãnacʉ̃rẽ bairo caãcʉ̃ caetamirĩcʉ̃ majũ cʉ̃ caĩata,” ĩ tʉ̃goña masĩcoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bairo cabero camasãtʉ na caetaro, jĩcãʉ̃ caʉ̃mʉ rʉpopaturi mena Jesutʉ etanumurĩ qũĩroawĩ. Bairo qũĩroari atore bairo qũĩwĩ caʉ̃mʉ Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—¡Yʉ Quetiupaʉ, yʉ macʉ̃rẽ cʉ̃ bopaca ĩñaña! Ñama riaye mena riamecʉ̃ baiyami. Bairo bairi, bʉtioro popiye baiyami. Capee majũ wãtĩ peeropʉ cʉ̃ jʉ̃gorocajoe ánucũñami. Ape rʉ̃mʉrã riapʉ cʉ̃ jʉ̃gorocañua mecʉ̃nucũñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bairi mʉ cabuerã tʉpʉ cʉ̃ yʉ neatímiapʉ̃. Na pʉame cʉ̃ netõõmasĩẽtĩñama —qũĩwĩ capacʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bairo cʉ̃ caĩrõ tʉ̃go, bairo na ĩwĩ Jesús to macããnarẽ: —¡Mʉjãã, ati yepa caãna Dios cʉ̃ camasĩrĩjẽrẽ cariape mʉjãã tʉ̃goetimajũcõãña! Bairo mʉjãã cabairoi, yʉ tʉ̃goña yapapuajãñuña. ¿Nocãrõ yoaro mʉjãã mena yʉ ãnibujiocʉti? Jaʉ, toroque cawãmaʉrẽ ato pʉame cʉ̃ neasá —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bairi wãtĩ yeri pũna cawãmaʉrẽ caroyetuoricʉre cʉ̃ acuwiyojowĩ. Bairo cʉ̃ caátó, cawãmaʉ pʉame jicoquei caticoami yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cabero aperã na camano, jãã jeto ãna, atore bairo Jesure cʉ̃ jãã ĩ jẽniñawʉ̃: —¿Nopẽĩrã wãtĩ yeri pũnarẽ jãã acurocawiyojo masĩẽtĩcʉti? —cʉ̃ jãã ĩwʉ̃, jãã, Jesús cʉ̃ cabuerã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩwĩ: —Dios mena mʉjãã tʉ̃goña tutuaetimajũcõãña. Cariape mʉjããrẽ ñiña: Mostaza cawãmecʉtii apeacã, õcã apeacã majũ niña. Tiacarẽ bairo petoaca Dios mena mʉjãã catʉ̃goñatutuata, ʉ̃tãʉ̃rẽ etari, “Wãáti, aperopʉ etanʉcãrõjã,” mʉjãã caĩata, mʉjãã caĩrõrẽã bairo baibujioro ti ʉ̃tãʉ̃ pʉame. Aperopʉ ágaro. Bairi dise mʉjãã caátimasĩẽtĩẽ manigaro, Dios mena mʉjãã catʉ̃goñatutuata. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wãtĩã, jõ caãniatacʉre bairo caãnarẽ na mʉjãã caárotigata, cajʉ̃goye ʉgarique betiri mʉjãã jẽniñubuegarã Diore —jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ape rʉ̃mʉ Galilea yepapʉ Jesús mena jãã caáñesẽãrõ, atore bairo jãã ĩ quetibʉjʉwĩ tunu: —Yʉ, Camasã Jʉ̃gocʉ, yʉ ñerotiecogʉ camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bairi yʉ pajĩãrotiecogʉ. Bairo yʉ na capajĩãrocacõãmiatacʉ̃ãrẽ, itia rʉ̃mʉ bero yʉ caticoagʉ tunu —jãã ĩwĩ. Bairo cʉ̃ caĩrõ tʉ̃go, jãã pʉame bʉtioro jãã tʉ̃goña yapapuawʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bairi Capernaum na caĩrõpʉ Jesús mena jãã caetaro, templo wii macããna camasã yaye dinerore jejobojari majã pʉame Pedrore qũĩñarã etayuparã. Bairo etarã, atore bairo qũĩñuparã: —¿Mʉjããrẽ cabuei, Dios ya wii macããjẽ caãnipeere cʉ̃ wapa joeticʉti? —qũĩ jẽniñañuparã Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bairo na caĩrõ tʉ̃go, bairo na ĩñupʉ̃ Pedro: —Wapa joʉmi. Ĩ yaparoʉ, wiire jããñupʉ̃. Bairo Jesure cʉ̃ caĩbʉsʉparo jʉ̃goyea, Jesús pʉame qũĩñupʉ̃ Pedrore: —¿Dope bairo mʉ tʉ̃goñañati, Simón? Ati yepa macããna quetiuparã, ¿noa ũnarẽ dinero, impuestore na jẽninucũñati? ¿Na ya yepa macããnarẽ, o ape yepa macããna pʉamerẽ na jẽninucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bairo cʉ̃ caĩrõ, Pedro pʉame qũĩñupʉ̃: —Ape yepa macããna pʉamerẽ jẽninucũñama. Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ quetibʉjʉ nemoñupʉ̃ tunu Jesús Pedrore: —Bairoa átinucũñama. Na ya yepa macããna pʉamerẽ wapati rotietinucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bairo marĩ pʉame cawapatietibujioparã caãna nimirãcʉ̃ã, marĩ wapatigarã bairãpʉa, roro marĩrẽ na catʉ̃goñaetiparore bairo ĩrã. Bairi ʉtabʉcʉrapʉ waiweija. Mʉ capajĩãjʉ̃goʉre cʉ̃ riserore tʉ̃gãpã átiri, jĩcã moneda tiire mʉ bócagʉ. Ti tii mena mʉ wapatigʉ marĩ pʉgarã yaye wapare cajẽnirãrẽ —ĩñupʉ̃ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tipaʉ caãno jãã, Jesús cʉ̃ cabuerã cʉ̃tʉ etarã, atore bairo jãã ĩ jẽniñawʉ̃: —¿Ni majũ cʉ̃ ãnicʉti jĩcãʉ̃ Dios cʉ̃ carotimasĩrĩpaʉ macããcʉ̃, caãnimajũʉ̃rẽ bairo caãcʉ̃? —jãã ĩ jẽniñawʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús pʉame bairo jãã caĩjẽniñarõ tʉ̃go, jĩcãʉ̃ cawĩmaʉrẽ cʉ̃ piijowĩ. Cʉ̃ piijo yua, jãã watoapʉ cawĩmaʉrẽ cʉ̃ nʉcõwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bairo átiri, atore bairo jãã ĩwĩ: —Cariape mʉjããrẽ ñiña: Mʉjãã, yʉ cabuerã, ãni cawĩmaʉrẽ bairo tʉ̃goñarĩqũẽ cʉtiri mʉjãã yerire mʉjãã cawasoaeticõãta, Dios cʉ̃ carotimasĩrĩpaʉre mʉjãã jããetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ãni, cawĩmaʉ pʉame cʉ̃ pacʉ mena tʉ̃goñatutuamajũcõãñami. Cʉ̃rẽ bairo Dios mena mʉjãã cabairo yʉ boya. Bairi ni jĩcãʉ̃ ũcʉ̃ Dios mena cʉ̃ catʉ̃goñatutuanemoata, Dios pʉame cʉ̃ carotimasĩrĩpaʉre caãnimajũʉ̃ cʉ̃ ãnio joroque cʉ̃ átigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃, yʉ yaye quetire tʉ̃goʉsari, ãni cawĩmaʉrẽ bairo caãcʉ̃rẽ cʉ̃ camaiata, yʉre camairẽ bairo cʉ̃ ñiñagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ni jĩcãʉ̃ ũcʉ̃ apei yʉ mena catʉ̃goñatutuajʉ̃goʉre, cʉ̃ tʉ̃gomawijiao joroque cʉ̃ caápata, roro majũ baigʉmi Dios cʉ̃ caĩñabesepa rʉ̃mʉ caetaro. Jĩcãʉ̃, ʉ̃tãã capairica mena cʉ̃ wãmʉarẽ jiyaturi, ria capairiyapʉ na carurocaricʉre bairo netõjãñurõ popiye baigʉmi cʉ̃ ũcʉ̃ ti rʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ati yepapʉ mʉjãã catʉ̃goñarĩjẽ mʉjããrẽ caroyeturije capee niña! Bairoa nicõãgaro tocãnacã rʉ̃mʉ ati yepapʉ mʉjãã caãno. ¡Bairo cabairo jʉ̃gori bopacooro netõrõ na baio joroque na átigʉmi Dios ati yepapʉre camasãrẽ roro cajʉ̃goátiri majã roquere! ");
INSERT INTO cbcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Bairi mʉjããrẽ ñinemoña tunu: Ni mʉjãã mena macããcʉ̃ cʉ̃ wãmorĩ mena jʉ̃gori carorije jetore átinucũʉ̃mi. O cʉ̃ rʉpori mena jʉ̃gori caroropʉ ánucũʉ̃mi. Bairo cʉ̃ wãmorĩ mena jʉ̃gori roro caátipai, o cʉ̃ rʉpo mena jʉ̃gori carorije caána na caãnopʉ caápai cʉ̃ caãmata, apei cʉ̃ wãmorĩrẽ, o cʉ̃ rʉporire capajurere ecoricʉre bairo cʉ̃ caãno, ñuña. Cʉ̃ rupaʉ macããjẽ cʉ̃goetimicʉ̃ã, rupa tutua Diotʉ cʉ̃ caátó, ñujãñuña. Peeropʉ roro cʉ̃ caábujiorijere cʉ̃ netõõgʉmi Dios, tore bairo roro cʉ̃ cabairijere cʉ̃ caátijãnata yua. Cʉ̃ wãmorĩ, o cʉ̃ rʉpori roro cʉ̃ átio joroque caátie mena cʉ̃gori roro peeropʉ cʉ̃ capopiye tãmʉoata roque, ñuetibujioro, yʉra. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ cʉ̃ caapee mena jʉ̃gori carorije macããjẽ jetore ĩñanucũʉ̃mi. Bairo cʉ̃ caapee mena jʉ̃gori carorije macããjẽrẽ caĩñapai cʉ̃ caãmata, apei cʉ̃ caapeere cawerocaecoricʉre bairo cʉ̃ caãno, ñuña. Bairo jĩcã ũno caapea cʉ̃goetimicʉ̃ã, Diotʉ cʉ̃ caátó ñujãñuña. Peeropʉ roro cʉ̃ caábujiorijere cʉ̃ netõõgʉmi Dios, tore bairo carorije macããjẽrẽ cʉ̃ caĩñajãnaata yua. Cʉ̃ caapee roro cʉ̃ átio joroque caátie mena cʉ̃gori roro peeropʉ cʉ̃ capopiye tãmʉoata roque, ñuetibujioro, yʉra. Bairi roro mʉjãã caátinucũrĩjẽrẽ jãnacõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tunu bairoa mʉjããrẽ ñiña: Cawĩmarãrẽ, cabʉgoro macããnarẽ bairo na ĩñaeticõãña. Na cʉ̃ãrẽ na mʉjãã canʉcʉ̃bʉgoro boya. Cariape mʉjããrẽ ñiña: Narẽ caĩñarĩcãnʉgõrĩ majã ángelea pʉame na cabairijere yʉ pacʉ Dios ʉmʉrecóo macããcʉ̃rẽ cʉ̃ quetibʉjʉnucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Torecʉ, yʉ, Camasã Jʉ̃gocʉ, yʉ apʉ́, camasã cayasibujiorãrẽ na netõʉ̃ acʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Tʉ̃gopeoya mai. Jĩcãʉ̃, cien ovejare cacotei jĩcãʉ̃ na mena macããcʉ̃ oveja cʉ̃ camawijiayasicoápata, ¿jicoquei cʉ̃ macãʉ̃ ápéribujioʉcʉti? Jicoquei cʉ̃ macãʉ̃ ácoabujioʉmi. Noventa y nueve caãnarẽ ẽñotaricaropʉ cũcõã, apei cayasiatacʉre cʉ̃ macãʉ̃ ábujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bairi oveja cayasiatacʉre cʉ̃ cabocaata, caroaro ʉseanibujioʉmi. Aperã camawijiaetiatanarẽ na cʉ̃ caʉseanirõ netõrõ cʉ̃ ʉseanibujioʉmi, cayasiatacʉre cʉ̃ cabocaata. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Torea bairo ãnoa cawĩmarã mena macããcʉ̃ jĩcãʉ̃ ũcʉ̃ cʉ̃ cayasiro boetiyami yʉ Pacʉ ʉmʉrecóo caãcʉ̃ pʉame,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩ nemowĩ tunu: “Ni jĩcãʉ̃ ũcʉ̃ mʉjãã yaʉ, roro mʉjããrẽ cʉ̃ caápata, cʉ̃tʉ átíri cʉ̃ quetibʉjʉya, aperã na catʉ̃goetopʉ. Bairi cʉ̃ pʉame mʉjãã caĩrĩjẽrẽ cʉ̃ catʉ̃goʉsaata, jĩcã yerire bairo cacʉ̃gorã mʉjãã tuagarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bairo mʉjãã caĩrĩjẽrẽ cʉ̃ catʉ̃gogaeticõãta roque, apei mʉjãã yaʉ, jĩcãʉ̃, o pʉgarãrẽ na piiya. Bairo na caetaro ĩña, na mena átíri, roro mʉjããrẽ caátiatacʉre mʉjãã quetibʉjʉ nemogarã tunu, cʉ̃ mʉjãã caĩrĩjẽrẽ aperã pʉgarã, o itiarã na catʉ̃goparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bairo mʉjãã caquetibʉjʉqũẽnogamiatacʉ̃ãrẽ, cʉ̃ pʉame jĩcã nʉgõã cʉ̃ catʉ̃gogaeticõãta, ñubueri majãrẽ na quetibʉjʉya. Torea bairo tunu na caquetibʉjʉrijere cʉ̃ catʉ̃gogaeticõãta, Diore camasĩẽcʉ̃rẽ bairo qũĩñacõãña yua. O romano majãrẽ camasã yaye dinerore cajejobojari majãrẽ bairo qũĩñacõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Cariape mʉjããrẽ ñiña: Dios cʉ̃ carotimasĩrĩpaʉ macããnarẽ caátijʉ̃gorã mʉjããrẽ yʉ cũña. Bairo caãna ãnirĩ ati yepa ãna, ‘Dios ʉmʉrecóo macããcʉ̃ marĩrẽ cʉ̃ caátirotirije niña,’ o ‘Dios cʉ̃ caátirotietie niña,’ mʉjãã ĩ masĩgarã Dios yarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Apeyera tunu mʉjããrẽ ñinemoña: Noa ũna mʉjãã mena macããna pʉgarãpʉa jĩcã yericʉnarẽ bairo dise ũnie mʉjãã caborijere Diore mʉjãã cajẽniata, mʉjãã caĩrõrẽã bairo mʉjãã átibojagʉmi yʉ Pacʉ Dios, ʉmʉrecóo macããcʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yʉ yarã yʉ yaye bʉsʉriquere na cañubueneñarõpʉ caãno cãrõ na mena yʉ ãnigʉ. Pʉgarã, o itiarã jeto na caãmata cʉ̃ãrẽ, na mena yʉ ãnigʉ,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bairo jããrẽ cʉ̃ caĩquetibʉjʉyaparoro, Pedro pʉame Jesutʉ atí, atore bairo qũĩ jẽniñawĩ: —Jãã Quetiupaʉ, yʉ yaʉ roro yʉ cʉ̃ caápata, ¿nocãnacãni majũ cʉ̃ mena yʉ bʉsʉqũẽnocʉti? ¿Jĩcã wãmo peti pʉga pẽnirõ cãnacãni majũ bairo yʉ áticʉti? —qũĩ jẽniñawĩ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, atore bairo qũĩwĩ Jesús Pedrore: —Baipʉa, tore bairo mee mʉjãã yʉ átirotiya. Siete por setenta cãnacãni majũ cʉ̃ mʉjãã bʉsʉqũẽnogarã, ñiña —qũĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ĩ quetibʉjʉ yaparo, ape wãmerẽ ĩcõñarĩ bairo jãã ĩ quetibʉjʉwĩ tunu: “Dios cʉ̃ carotimasĩrĩpaʉ atore bairo niña: Jĩcãʉ̃ quetiupaʉ rey cʉ̃ ʉ̃mʉa cʉ̃rẽ cawapamorã dinerore na catunuorõ boyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bairo boʉ, cʉ̃tʉ na piijoneñojʉ̃goyupʉ, na mena qũẽnogʉ. Bairi jĩcãʉ̃ cʉ̃ capiijojʉ̃goʉ pairo capee millones majũ cʉ̃ wapamoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cʉ̃ pʉame dope bairo cʉ̃ átiwapatimasĩẽsupʉ̃ tie cʉ̃ cawapamorĩjẽrẽ cʉ̃ quetiupaʉre. Bairo, ‘Yʉ cʉ̃goetiya,’ cʉ̃ caĩrõ tʉ̃go, quetiupaʉ rey pʉame cʉ̃ cawapamoʉrẽ, cʉ̃ nʉmorẽ, cʉ̃ pũnaarẽ, bairi cʉ̃ yaye nipetirije cʉ̃ cacʉ̃gorije ũnie cʉ̃ãrẽ aperãrẽ na nunirerotiyupʉ, cʉ̃ cawapamorĩjẽrẽ na cajeparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cawapamoʉ pʉame bairo rey cʉ̃ carotiro tʉ̃gori, rʉpopaturi mena cʉ̃tʉ etanumurĩ atore bairo bʉtioro qũĩñupʉ̃: ‘Yʉ Quetiupaʉ, jicoquei roro yʉ mʉ ápewa. Dinero mʉ yʉ cawapamorĩjẽrẽ tocãnacã tiirire cabero mʉ yʉ tunuogʉ baipʉa,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bairo cʉ̃ caĩrõ tʉ̃go, bopacooro qũĩñañupʉ̃ quetiupaʉ rey cʉ̃ ʉ̃mʉrẽ. Bairi, ‘Ñugaro. Caroaro mʉ tuagʉ. Yʉ mʉ cawapamorĩjẽrẽ mʉ yʉ masiriyogʉ’ qũĩñupʉ̃. Bairo ĩrĩ, caroaro tuao joroque cʉ̃ áti, cʉ̃ árotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bairo caroaro cʉ̃ caátimiatacʉ̃ãrẽ, cawapamomiatacʉ pʉame cabero apei cʉ̃ yaʉ petoaca cʉ̃rẽ cawapamoʉrẽ bocáetari cʉ̃ tutiyupʉ. Bairo cʉ̃ tuti yua, roro cʉ̃ wãmʉtutupʉre ñerĩ atore bairo qũĩñupʉ̃: ‘¡Yʉ mʉ cawapamorĩjẽrẽ jicoquei yʉ mʉ tunuogʉ!’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ cʉ̃ bapa cʉ̃ cawapamoʉrẽ: ‘Yʉ yaʉ, jicoquei roro yʉ mʉ ápewa. Dinero mʉ yʉ cawapamorĩjẽ tocãnacã tiirire cabero mʉ yʉ tunuogʉ baipʉa,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bairo cʉ̃ caĩrõ, cʉ̃ yʉesupʉ. Preso jorica wiipʉ cʉ̃ cũrocarotiyupʉ, yʉ cʉ̃ cawapamorĩjẽrẽ cʉ̃ jopeyoáto, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bairo cʉ̃ caáto ĩña, aperã cʉ̃ mena macããna paabojari majã tʉ̃goñarĩqũẽ paiyuparã. Bairo cabairã ãnirĩ na quetiupaʉre cʉ̃ quetibʉjʉrásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bairo na caĩquetibʉjʉro tʉ̃go, quetiupaʉ rey pʉame cʉ̃ piijorotiyupʉ tunu cʉ̃rẽ cawapamomiatacʉre. Bairo cʉ̃ caetaro ĩña, atore bairo qũĩñupʉ̃: ‘Mʉ, yʉ paabojari majõcʉ, ¡roro majũ mʉ tʉ̃goñaña! Bopacooro yʉ mʉ cajẽnirõĩ, pairo yʉ mʉ cawapamomiatajere yʉ masiriyobojaapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bairo yʉ caátimiatacʉ̃ãrẽ, ¿nopẽĩ bopacooro mʉrẽ yʉ caĩñaatatorea bairo, apei, mʉ bapare bopacooro cʉ̃ miñaetiati? Roro majũ mʉ tʉ̃goñaña,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bairo qũĩrĩ, netõjãñurõ cʉ̃ mena asiari, preso jorica wiipʉ cʉ̃ árotiyupʉ. Topʉ nicõãñupʉ̃ dinero cʉ̃ cawapamorĩjẽ cʉ̃ catunuopeyoparo jʉ̃goye,” ĩcõñarĩ jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Bairo ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu: —Yʉ Pacʉ ʉmʉrecóo macããcʉ̃ pʉame torea bairo átigʉmi mʉjãã tocãnacãʉ̃rẽ, mʉjãã yeripʉ mʉjãã yarã roro mʉjããrẽ na caátiere na mʉjãã camasiriyoepata —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bairo atiere cʉ̃ caĩquetibʉjʉro bero, Jesús Galilea yepapʉ caãniatacʉ, Judea yepapʉ acoámí. Rio Jordán muipʉ cʉ̃ cawãmʉatí nʉgõã pʉamepʉ acoámí. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bairo cʉ̃ caátó, capããrã camasã cʉ̃ ʉsawã. Bairi topʉ cariayecʉnarẽ na netõwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bairo cʉ̃ caáto, qũĩ jẽniñarã etawã jĩcããrã fariseo majã. “Carorije buei átiyami Jesús,” qũĩ bʉsʉjãgamirã, atore bairo cʉ̃ jẽniñamiwã: —Marĩ judío majã mena macããcʉ̃ ni jĩcãʉ̃ ũcʉ̃ cʉ̃ majũ cʉ̃ catʉ̃goñarõ jʉ̃gori cʉ̃ nʉmorẽ rocagʉ, ¿cõ cʉ̃ rocamasĩcʉti? —qũĩ jẽniñawã. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩwĩ Jesús: —Dios yaye quetibʉjʉriquere cajʉ̃gobuerã nimirãcʉ̃ã, ¿ati wãmerẽ mʉjãã ĩñaẽtĩñati Dios ya tutipʉre? Merẽ mʉjãã masĩrã. Caãnijʉ̃goripaʉ camasãrẽ átijʉ̃goʉ, caʉ̃mʉ, carõmio cʉ̃ã na qũẽnojʉ̃goyupi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na áti yaparo, atore bairo marĩ ĩcũñupĩ: “Jĩcãʉ̃ caʉ̃mʉ carõmio mena cʉ̃ cawãmojiyaata, cʉ̃ pacʉa tʉre witigʉmi. Ape wiipʉ ãnigʉmi cʉ̃ nʉmo mena. Bairo na cabairo, jĩcãʉ̃rẽ bairo na ñiñagʉ. Jĩcã rupaʉre bairo nigarãma,” marĩ ĩcũñupĩ Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bairi jĩcãʉ̃rẽ bairo Dios narẽ cʉ̃ cacũrĩcãrã na caãnoi, ni jĩcãʉ̃ ũcʉ̃ na ricawa masĩẽcʉ̃mi. Na majũ cʉ̃ã ãmeo pitimasĩẽtĩñama —na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, atore bairo qũĩ jẽniñanemowã tunu: —Bairopʉa, ¿nopẽĩ marĩ ñicʉ̃ Moisés ãnacʉ̃ cʉ̃ yaye quetibʉjʉcũrĩqũẽrẽ ape wẽẽpʉ, “Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ cʉ̃ carocagaata, atore bairo ĩrĩcã pũrõrẽ cõ cʉ̃ cajoro, ñurõ: ‘Bairo mʉ cabairoi, mʉ teei, mʉrẽ yʉ pitiya,’” qũĩ cũñuparĩ? —qũĩwã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bairo na caĩrõ tʉ̃go, atore bairo na ĩwĩ Jesús: —Mʉjãã ñicʉ̃jãã, mʉjããrẽ bairo ãmeo mairĩqũẽrẽ camasĩẽna na caãnoi, na mena macããcʉ̃ jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ carocagaʉre roro cʉ̃ caátiere ẽñotaesupi Moisés. Baipʉa, bairo boesupi Dios caãnijʉ̃goripaʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cariape mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmo, apei mena roro caepeeco cõ caãnimiatacʉ̃ãrẽ, cõrẽ rocari bero tunu apeo mena cʉ̃ cawãmojiyaata, roro majũ ácʉ átiyami. Dios cʉ̃ caroticũrĩqũẽrẽ caápei majũ niñami. “Apeo mʉ nʉmo mee caãcõ mena ãmerĩcõãña,” cʉ̃ caĩrĩqũẽrẽ cabaibotioʉ majũ niñami —na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bairo na cʉ̃ caĩquetibʉjʉyaparoro, jãã, cʉ̃ cabuerã pʉame atore bairo jãã ĩwʉ̃ Jesure: —Mʉ caĩrõrẽ bairo camasã na nʉmoarẽ na capitimasĩẽtĩcõãta, na nʉmoa caãniparãrẽ na camacãẽtĩcõãta, ñubujioricaro —jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bairo jãã caĩrõ tʉ̃go, bairo jãã ĩwĩ: —Tocãnacãʉ̃pʉa nipetiro camasã masĩẽtĩñama atie yʉ caĩquetibʉjʉrijere. Masĩõrĩqũẽrẽ Dios cʉ̃ cajorã jeto masĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Cawãmarã jĩcããrã rorã cabuiaricarã ãnirĩ nʉmo cʉtimasĩẽtĩñama. Tunu aperã, na nʉmo cʉtimasĩẽtio joroque na átiyama. Aperã na majũã Dios yaye rotiriquere netõjãñurõ átigarã, carõmiorẽ na negaetiyama. Bairo bairã, canʉmo cʉtimasĩẽnarẽ bairo nicõãñama. Bairi yʉ caĩquetibʉjʉcũrĩjẽrẽ bairo camasĩtʉ̃goñarã torea bairo na áparo —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Cabero tunu aperã na pũnaa cawĩmarãrẽ na jeamá Jesús tʉpʉ, na pãñarĩ Diore na cʉ̃ jẽnibojaáto, ĩrã. Bairo na pũnaarẽ na cajeató ĩñarĩ jãã, cʉ̃ cabuerã pʉame, “Na jeapéricõãña mʉjãã pũnaarẽ,” na jãã ĩwʉ̃ capacʉare. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bairo jãã caĩrõ tʉ̃go, atore bairo jãã ĩwĩ Jesús: —Yʉtʉ pʉame cawĩmarãrẽ na atírotiya. Na ẽñotaeticõãña. Dios cʉ̃ carotimasĩrĩpaʉ macããnarẽ bairo caãna niñama cawĩmarã. Narẽ bairo cayeriñurã jeto ãnimasĩñama Dios cʉ̃ carotimasĩrĩpaʉpʉre —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ĩ yaparo, cawĩmarãrẽ na pãñarĩ Diore na jẽnibojawĩ. Áticõã yua, acoámí tipaʉ caãnimiatacʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bairo cʉ̃ caátó, jĩcãʉ̃ cawãmaʉ Jesutʉ atíri, atore bairo qũĩ jẽniñawĩ: —Jããrẽ cabuei, ¿dope bairo yʉ átibujiocʉti, caroa yeri capetietiere bócagʉ? ");
INSERT INTO cbcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo pʉame qũĩwĩ Jesús: —¿Nopẽĩ, “Dise yʉ caátipee caroa wãme majũrẽ yʉre quetibʉjʉya,” yʉ mi jẽniñañati? Cañuʉ, jĩcãʉ̃ã niñami, Dios jeto. Caroa yeri capetietiere bócagʉ, Dios camasãrẽ cʉ̃ caroticũrĩqũẽrẽ mʉ tʉ̃goʉsagʉ —qũĩwĩ Jesús cawãmaʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bairo cʉ̃ caĩrõ tʉ̃go, “¿Dise pʉamerẽ cʉ̃ caroticũrĩqũẽrẽ yʉ ácʉati?” qũĩ jẽniñawĩ cawãmaʉ. Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩ quetibʉjʉwĩ Jesús cawãmaʉrẽ: —‘Pajĩãẽtĩcõãña camasãrẽ. Carõmio mena roro átiepeeticõãña. Aperã yayere jeerutieticõãña. Aperã cabʉgoroa na ĩbuitieticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ pacʉ, mʉ paco cʉ̃ãrẽ nʉcʉ̃bʉgoya. Mʉ mena macããna cʉ̃ãrẽ mʉ rupaʉre mʉ camairõrẽã bairo na maiña,’ —qũĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, atore bairo qũĩwĩ cawãmaʉ Jesure: —Tie nipetirijere merẽ yʉ átipeyocõãnucũña. Bairi, ¿ñe to rʉsacʉti mai yʉ caátipee? —qũĩ jẽniñawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, atore bairo qũĩ quetibʉjʉnemowĩ Jesús tunu cawãmaʉrẽ: —Caroʉ́ majũ, ñe ũnie carʉsaecʉ ãnigʉ, mʉ cacʉ̃gorije nipetirijere mʉ nunirepeyocõãgʉ. Tie wapare jeeri, cabopacarãrẽ na mʉ ricawogʉ. Bairo mʉ caápata, jõbuipʉ pairo nigaro mʉ cawapatapee. Bairo yʉ caĩrõrẽ bairo áti yaparori, yʉ mena bapacʉsa —qũĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tiere tʉ̃go, cawãmaʉ pʉame tʉ̃goñarĩqũẽ pairi acoámí. Capee apeye ũnierẽ cacʉ̃goʉ ãnirĩ Jesús cʉ̃ caĩrõrẽ bairo átigaemi yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bairo cʉ̃ caátó ĩña, atore bairo, jãã, cʉ̃ cabuerãrẽ jãã ĩwĩ: —Cariape mʉjããrẽ ñiña: Camasã apeye ũnierẽ capee cacʉ̃gori majã Dios cʉ̃ carotimasĩrĩpaʉre na caetapee masiriyojãñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tunu bairoa ñiña: Waibʉcʉ capai, camello, ãpõã pota opeacapʉ cʉ̃ cajã ãmewitiata, masiriyojãñuña. Tore bairo cabaimiatacʉ̃ãrẽ, netõjãñurõ masiriyoro niña caʉ̃mʉ capee apeyere cacʉ̃goʉ Dios cʉ̃ carotimasĩrĩpaʉre cʉ̃ caetapee pʉame roque —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bairo cʉ̃ caĩrõ tʉ̃go, jãã, cʉ̃ cabuerã pʉame, jãã tʉ̃goacʉacoapʉ. Atore bairo jãã ĩwʉ̃: —Bairi toroque, ¿ni ũcʉ̃ cʉ̃ netõmasĩcʉti? ");
INSERT INTO cbcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús pʉame jãã ĩñarĩ, atore bairo jãã ĩwĩ: —Dise ũnie camasã na caátimasĩẽtĩẽ nipetirije Dios cʉ̃ caátimasĩrĩjẽ jeto niña —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame bairo qũĩwĩ Jesure: —Jãã Quetiupaʉ, jãã roque merẽ nipetirije jãã cacʉ̃gorijere cũrĩ, mʉrẽ jãã bapacʉti ʉsajʉ̃gowʉ. Bairo jãã caátie wapa, ¿ñerẽ jãã cʉ̃ joʉati Dios? —qũĩ jẽniñawĩ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, bairo qũĩwĩ Jesús: —Cariape mʉjããrẽ ñiña: Dios ati ʉmʉrecóo nipetiro cawãmarõ cʉ̃ cawasoaripaʉ quetiupaʉ yʉ caãnopʉ, mʉjãã, yʉ baparã, yʉ rocajãñurõ mʉjãã rotigarã mʉjãã cʉ̃ã. Quetiuparã na caruiro ũno, tronopʉ mʉjãã ruigarã. Israelita pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã poari macããnarẽ na caátajere ĩñacõñarĩ na mʉjãã ĩñabesegarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ni jĩcãʉ̃ ũcʉ̃ yʉ mena bapacʉtigʉ, cʉ̃ ya wiire, o cʉ̃ bairãrẽ, cʉ̃ bairã rõmirĩrẽ, cʉ̃ pacʉare, cʉ̃ pũnaarẽ, o cʉ̃ ya yepa cʉ̃ãrẽ cʉ̃ caaweyocoápáta, narẽ cʉ̃ cacʉ̃goro netõjãñurõ bócanemogʉmi tunu cʉ̃ yaye ũnierẽ, bairi cʉ̃ yarã ũna cʉ̃ãrẽ. Bairi jĩcãʉ̃rẽ cʉ̃ caaweyocoápáta, cʉ̃ netõrõ cien bui peoro cãrõ majũ bócanemogʉmi. Tunu bairoa caroa yeri capetietiere cʉ̃ jogʉmi Dios yʉ mena cabapacʉtiácʉ́re. ");
INSERT INTO cbcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Apeyera tunu ati rʉ̃mʉrĩrẽ camasã jĩcããrã rotimasĩmirãcʉ̃ã, caberopʉ na mena macããnarẽ na rotimasĩẽtĩgarãma. Tunu bairoa ati rʉ̃mʉrĩrẽ camasã jĩcããrã rotimasĩẽtĩmirãcʉ̃ã, caberopʉ na mena macããna capããrãrẽ carotimasĩrã majũ nigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ĩ quetibʉjʉ yaparo, paabojari majãrẽ ĩcõñarĩ, atore bairo jãã ĩ quetibʉjʉnemowĩ tunu: “Dios cʉ̃ carotimasĩrĩpaʉ pʉame jĩcãʉ̃ ʉse wese upaʉ, cabusuripaʉ caãno cʉ̃ ya wesepʉ capaabojaparãrẽ camacãʉ̃átacʉre bairo niña. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cʉ̃ pʉame jĩcããrã caʉ̃mʉarẽ na bócari yua, ʉseanirĩ, ‘Jĩcã rʉ̃mʉ paarique wapare tocãrõ majũ mʉjããrẽ yʉ wapatigʉ, yʉ yaye ʉsere mʉjãã cajebojaata,’ na ĩñupʉ̃. Bairo ‘Jaʉ,’ na caĩrõ tʉ̃go, cʉ̃ ya wesepʉ paarotijoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cabero muipʉ cʉ̃ caasitutuatípaʉ caãno macãpʉ ásúpʉ tunu. Topʉ eta yua, ñe ũnie áperã plaza caãnarẽ na ĩñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Atore bairo na ĩñupʉ̃ na cʉ̃ãrẽ: ‘Mʉjãã cʉ̃ã yʉ ya wesepʉ paarájá. Bairo mʉjãã caparãápata, cariape mʉjããrẽ yʉ wapatigʉ,’ na ĩñupʉ̃. Bairi na cʉ̃ã, cʉ̃ carotirore bairo cʉ̃ wesepʉ paarã ásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cabero pasaribota caãno macãpʉ ásúpʉ tunu. Cabero tres de la tarde caãno ásúpʉ tunu, aperã cʉ̃rẽ capaabojaparãrẽ na macãʉ̃ ácʉ́. Bairo na bócaetari yua, ‘Cariape mʉjãã cʉ̃ãrẽ yʉ wapatigʉ,’ na ĩñupʉ̃. Bairo cʉ̃ caĩrõ, na cʉ̃ã, ‘Jaʉ,’ ĩñuparã. Bairo na caĩrõ tʉ̃go, na paarotiyupʉ cʉ̃ ya wesepʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Cabero cinco de la tarde caãno macãpʉ átʉsayupʉ tunu. Topʉ eta, aperã caʉ̃mʉa ñe ũnie caáperãrẽ na ĩña, atore bairo na ĩñupʉ̃: ‘¿Nopẽĩrã bairoa mʉjãã ĩñacõãnucũ naioañati paari mee?’ na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñuparã: ‘Ñamʉ ũcʉ̃, “Marĩ paáto,” jãã ĩẽtĩñami. Bairi jãã paaetiya,’ qũĩñuparã. Bairo na caĩrõ tʉ̃go: ‘Mʉjãã cʉ̃ã paabojaasá yʉ ya wesepʉ,’ na ĩñupʉ̃ ti wese upaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Cabero canaiorĩpaʉ caetaro ti wese upaʉ cʉ̃ ʉ̃mʉa quetiupaʉ mayordomorẽ cʉ̃ árotiyupʉ cʉ̃ wesepʉ. Atore bairo qũĩñupʉ̃: ‘Tocãrõã yʉ paabojari majãrẽ na piijori na wapatiya. Yʉ ya wese capaaʉ etatʉsaatacʉpʉi na wapatijʉ̃goacʉ́, capaaʉ etajʉ̃goatacʉpʉ cʉ̃ wapatituya,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bairo cʉ̃ caĩrõ, cinco de la tarde caãno capaabojarã etaátana majũ wapa jegarã, quetiupaʉ mayordomotʉ etayuparã. Bairo caberopʉ capaarã etaátana nimirãcʉ̃ã, jĩcã rʉ̃mʉ paarique wapa jĩcãrõ tʉ̃ni ñeñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cabero capaabojarã etajʉ̃goatana pʉame etarã yua, ‘Na netõjãñurõ marĩrẽ wapatigʉmi,’ ĩ tʉ̃goñañuparã. Bairo na caĩtʉ̃goñamiatacʉ̃ãrẽ, jĩcãrõ tʉ̃nia jĩcã rʉ̃mʉ paarique wapa cãrõ na joyupʉ na cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bairo jĩcãrõ tʉ̃nia na cʉ̃ cawapatiro ĩñarã yua, ‘¡Tame, ñuẽtĩña!’ ãmeo ĩ bʉsʉpaiyuparã na majũ ti wese upaʉ bairo cʉ̃ caátirotirijere. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Atore bairo qũĩñuparã: ‘Ãnoa caberopʉ capaabojarã etaátana pʉame jĩcã horaaca jeto paarã etaama. Jãã pʉame roque, ati rʉ̃mʉrẽ jãã paanaiocoápʉ caasiro watoare. Bairi, ¿nopẽĩ na netõjãñurõ jããrẽ mʉ wapa joetiyati?’ qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bairo na caĩrõ tʉ̃go, jĩcãʉ̃ na mena macããcʉ̃rẽ atore bairo qũĩñupʉ̃ ti wese upaʉ pʉame: ‘Yʉ yaʉ, mʉrẽ ricaati roro yʉ áperiya. Mʉrẽ yʉ caĩrõrẽã bairo mʉ yʉ wapatiya, jĩcã rʉ̃mʉ wapa majũrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bairi mʉ cawapatarijere jecoácʉ́ja. Caberopʉ capaabojarã etaátanarẽ jĩcãrõ tʉ̃ni na yʉ cawapatiata, ñujãñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yʉ majũã yʉ yaye dinerore yʉ caborore bairo yʉ átimasĩña. Bairi dopẽĩrã, ¿Cabopacarãrẽ na yʉ caĩñamairĩjẽrẽ roro mʉjãã ĩñatutiyati?’ qũĩñupʉ̃ ti wese upaʉ cajʉ̃goye capaabojaʉ etaátacʉre,” ĩcõñarĩ jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ĩ yaparo, atore bairo jãã ĩnemowĩ tunu: “Torea bairo ãmerẽ camasã caãnimajũrã nimirãcʉ̃ã, caberopʉ cabʉgoro macããna nigarãma. Tunu bairoa ãmerẽ camasã cabʉgoro macããna nimirãcʉ̃ã, caberopʉ caãnimajũrã nigarãma,” jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bairo cabero Jesús Jerusalén caátíwãpʉ ácʉ́, jãã, cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ camasã watoa caãnarẽ, jãã piiwʉojori, atore bairo jãã ĩwĩ: ");
INSERT INTO cbcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalẽpʉ marĩ caátíere merẽ mʉjãã masĩña. Topʉ ti macã macããna pʉame yʉ, Camasã Jʉ̃gocʉre, yʉ ñerĩ, yʉ jogarãma sacerdote majã quetiuparãrẽ, bairi Moisés ãnacʉ̃ cʉ̃ caquetibʉjʉcũrĩqũẽrẽ cajʉ̃gobueri majãrẽ. Bairo na caáto, sacerdote majã quetiuparãjãã pʉame yʉ pajĩãroca rotigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bairo átirotiri yua, ape yepa macããnarẽ yʉ nunirocacõãgarãma. Roro ñiepegarãma. Roro yʉ bape epegarãma. Bairo átieperi, yucʉpãĩpʉ yʉ papuatu rocagarãma. Bairo yʉre na caátimiatacʉ̃ãrẽ, itia rʉ̃mʉ bero caãno yʉ pʉame yʉ caticoagʉ tunu —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cabero Zebedeo nʉmo cõ pũnaa mena Jesutʉ etari, cõ rʉpopaturi mena etanumuñupõ, qũĩ jẽniñago. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Bairo cõ caáto ĩña, “¿Ñerẽ mʉ yʉ caáto mʉ boyati?” cõ ĩ jẽniñañupʉ̃. Cõ pʉame bairo qũĩñupõ: —Ati yepare mʉ carotimasĩrĩpaʉ caetaro, yʉ pũnaa mʉtʉ na mʉ caruirotiro yʉ boya. Jĩcãʉ̃ cariape nʉgõã, apei caãcõ nʉgõã na mʉ caruirotiro yʉ boya. “Jaʉ,” miwã —qũĩñupõ Juan, Santiago paco pʉame Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bairo cõ caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús cõ pũnaarẽ: —Mʉjãã cabaipeere masĩẽtĩmirãcʉ̃ã, yʉre mʉjãã jẽniña. Bʉtioro popiye bairicarore mʉjãã jẽnimiña. Yʉ pʉame popiye yʉ baigʉ. Yʉre bairo mʉjãã cʉ̃ã popiye mʉjãã cabaiata, ¿mʉjãã nʉcãmasĩrãti? —na ĩñupʉ̃ Jesús Juarẽ, bairi Santiago cʉ̃ãrẽ. Bairo cʉ̃ caĩrõ tʉ̃go: —Mʉrẽ bairo jãã nʉcãmasĩña —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bairi Jesús pʉame atore bairo na ĩñupʉ̃: —Mʉjãã caĩrõrẽ bairo popiye mʉjãã baigarã. Baipʉa, yʉ majũ yʉre cajʉrotiparã, yʉtʉ cariape nʉgõã, bairi caãcõ nʉgõã caruiparãrẽ na yʉ besemasĩẽtĩña. Yʉ Pacʉ pʉame roque bairo caãniparãrẽ na besemasĩñami —na ĩñupʉ̃ Jesús, Juarẽ bairi Santiago cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cabero jãã, Jesús cʉ̃ cabuerã pʉga wãmo cãnacãʉ̃ majũ caãna Santiago, Juan mena Jesure na caĩjẽniñaatajere catʉ̃goatana ãnirĩ na mena jãã asiacoapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús pʉame tiere ĩña, nipetirã jããrẽ cʉ̃tʉ piijori atore bairo jãã ĩwĩ: —Merẽ mʉjãã masĩña ati ʉmʉrecóo macããna na caátiãnierẽ. Ati yepa macããna Diore caĩroaena quetiuparã reyre bairo caãna tutuaro mena rotiepeyama na roca macããnarẽ. Popiye na baio joroque na rotiepeyama. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉjãã pʉame roquere tore bairo baietirotiya. Bairo pʉame bairotiya mʉjããrẽ: Mʉjãã mena macããcʉ̃, caãnimajũʉ̃rẽ bairo caãnigaʉ, mʉjãã roca netõjãñurõ carotimasĩrẽ bairo ãnirotiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tunu bairoa mʉjãã mena macããcʉ̃, caroti majũʉ̃rẽ bairo caãnigaʉ, mʉjãã ʉ̃mʉrẽ bairo cʉ̃ caãno, ñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bairi yʉ, Camasã Jʉ̃gocʉ quetiupaʉ majũrẽ bairo yʉre capaabojaparãrẽ na macãʉ̃ acʉ́ mee yʉ apʉ́ ati yepare. Camasãrẽ na jʉátinemoʉ acʉ́ yʉ apʉ́ ati yepapʉre. Tunu bairoa yʉ cariarije jʉ̃gori camasã capããrãrẽ na carorije wapare netõʉ̃ acʉ́ yʉ apʉ́ —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cabero jãã, Jesús mena Jericó na caĩrĩ macãpʉ caãniatana jãã cawitiro, capããrã camasã Jesús berore ʉsawã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bairo jãã caátó, cacaapee ĩñaena pʉgarã, maa tʉpʉ ruiyupa. Bairi cacaapee ĩñaena pʉame, Jesús cʉ̃ canetõátóre tʉ̃gorã, bʉsʉrique tutuaro mena atore bairo qũĩ awajajowã Jesure: —¡Jãã Quetiupaʉ, David ãnacʉ̃ pãrãmi, bopacooro jãã ĩñaña! —qũĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bairo na caĩrõ, camasã pʉame na tutiwã, na awajaeticõãto, ĩrã. Bairo narẽ na caĩmiatacʉ̃ãrẽ, jĩrĩã jãñurĩ awajanemowã tunu: —¡Jãã Quetiupaʉ, David ãnacʉ̃ pãrãmi, bopacooro jãã ĩñaña! ");
INSERT INTO cbcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús pʉame bairo na caĩawajarijere tʉ̃gori, tuanʉcãwĩ. Tuanʉcãrĩ yua, cʉ̃tʉ na piijowĩ. Atore bairo na ĩwĩ: —¿Ñerẽ mʉjãã yʉ caáto mʉjãã boyati? ");
INSERT INTO cbcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, bairo qũĩwã cacaapee ĩñaena Jesure: —Jãã Quetiupaʉ, caĩñamasĩẽna ãnirĩ jãã ĩñamasĩgaya tunu —qũĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús pʉame bopacooro na ĩñarĩ, na caapeere pãñawĩ. Bairo cʉ̃ caáto, jicoquei ĩñamasĩcõãma yua. Ĩñamasĩ, Jesús berore ʉsawã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bairo Jerusalén macã tʉpʉ cõñaáná yua, Betfagé na caĩrĩ macãrẽ, Olivo buro tʉre jãã etawʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Bairo etarã, jãã mena macããna, Jesús cʉ̃ cabuerã, pʉgarãrẽ atore bairo na ĩ jowĩ: —Ánája ato riape caãni macããcãpʉ. Topʉ etarã, jicoquei burra jiyanʉcõrĩcõrẽ cõ macʉ̃ mena mʉjãã bócagarã. Bairo na bóca yua, na õwãrĩ, na mʉjãã jeapá yʉ tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bairo mʉjãã caõwãrõ, jĩcãʉ̃ ũcʉ̃ mʉjããrẽ, “¿Nopẽĩrã na mʉjãã õwãñati?” cʉ̃ caĩata, atore bairo cʉ̃ mʉjãã ĩwã: “Marĩ Quetiupaʉ na boami. Yoaro mee mʉjãã tunuogʉmi tunu mʉjãã burrore,” cʉ̃ mʉjãã ĩwã —na ĩ jowĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tie pʉame profeta ãnacʉ̃ cʉ̃ caĩwoatuquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiwʉ. Atore bairo ĩ woatuyayupi profeta Jesús cʉ̃ cabaipeere mai: ");
INSERT INTO cbcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Atore bairo Sión cawãmecʉti macã macããnarẽ na ĩ quetibʉjʉya: ‘Mʉjãã quetiupaʉ rey pʉame mʉjããtʉ etaacʉ́ baiyami. Capajĩãrĩcʉ̃rẽ bairo mee, caroaro mena burro macʉ̃ bui pesari mʉjããtʉ etaacʉ́ baiyami,’ na ĩ quetibʉjʉya,” ĩ quetibʉjʉ jʉ̃goyeticũñañupĩ profeta ãnacʉ̃ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bairo Jesús cʉ̃ caĩrõ tʉ̃go, cʉ̃ cabuerã pʉame cʉ̃ caĩrotirorea bairo átiracoámá. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bairi burra, cõ macʉ̃ cʉ̃ãrẽ bóca yaparori, na jeámá Jesús tʉpʉ. Bairo na caje etaro yua, jãã jutii, cabui macããjẽrẽ, burro buire jãã peowʉ. Bairo jãã caáto, Jesús pʉame burro buipʉ wãmʉpeawĩ. Bairo cʉ̃ bui pesari yua, ánutuami Jesús Jerusalẽpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bairi camasã capããrã ãma. Jĩcããrã na mena macããna na jutii cabui macããjẽrẽ esocũwã maa cʉ̃ caátíwãrẽ. Aperã pepũũ queeri ũnierẽ patanerĩ Jesús jʉ̃goyere piticũjʉ̃gowã, Jesure qũĩroari, ʉseanirã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bairo bairã, nipetiro Jesús jʉ̃goye macããna, cʉ̃ bero macããna cʉ̃ã bʉsʉrique tutuaro mena atore bairo qũĩ basapeojʉ̃gowã: —¡Ñumajũcõãña! ¡Nipetiro cʉ̃ marĩ basapeoroa Quetiupaʉ Rey David marĩ ñicʉ̃ ãnacʉ̃ pãrãmirẽ! ¡Jesús, Dios cʉ̃ cajoʉ marĩ Quetiupaʉ majũ cʉ̃ caãnoi, cʉ̃rẽ marĩ cabasapeoro ñuña! ¡Nipetiro cʉ̃ marĩ basapeoroa Dios ʉmʉrecóo macããcʉ̃rẽ! —qũĩ basapeowã camasã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bairo Jesús Jerusalẽrẽ cʉ̃ cajãáto, ti macã macããna nipetirã qũĩñarã etawã: —Ãni, ¿ñamʉ cʉ̃ ãniñati? —ĩ jẽniñawã Jesure caʉsarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩwã: —Ãni Jesús, profeta, Nazaret Galilea yepa macããcʉ̃ niñami —na ĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bairo Jesús pʉame etari, templo capairi wii ñubuerica wiire jãámi. Ti wiire jããetari, to macããna nunirĩ cawapatari majãrẽ, bairi wapatiri majã cʉ̃ãrẽ na acurewiyojo jʉ̃gowĩ nipetirore. Tunu moneda tiirire cawasoari majã ya mesarire, bairi buare cawapatiri majã ya mesari cʉ̃ãrẽ tujerecũ peyocõãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bairo átiri, bairo na ĩwĩ: —Dios cʉ̃ caquetibʉjʉri tutipʉ bairo ĩña: “Yʉ ya wii ñubuerica wii majũ nigaro,” ĩña. Bairo caĩquetibʉjʉmiatacʉ̃ãrẽ, mʉjãã pʉame apeye arʉare bairo mʉjãã átiya. Camasãrẽ jerutinunirĩ majãrẽ bairo caãna ãnirĩ jerutiri majã na caãni wii, ʉ̃tã wiire bairo mʉjãã átiya ati wii, Dios ya wiire —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Cabero Jesús templopʉ cʉ̃ caãno mai, cacaapee ĩñamasĩẽna pʉame, bairi ñicãrĩ caroyetuarã cʉ̃ã cʉ̃tʉ etawã. Jesús pʉame na catiowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bairo sacerdote majã quetiuparã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã cʉ̃ã caroaro cʉ̃ caátiere ĩñamirãcʉ̃ã, tunu cawĩmarã templopʉ, “Nipetiro cʉ̃ marĩ basapeoto David ãnacʉ̃ pãrãmirẽ,” na caĩrõ tʉ̃gori, Jesure qũĩñatejãñuwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bairi atore bairo qũĩwã: —Cawĩmarã, ¿bairo na caĩrõ, mʉ tʉ̃goetiyati? “¡Tocãrõã jãnaña!” na ĩña —qũĩwã sacerdote majã quetiuparã Jesure. Bairo na caĩrõ tʉ̃go, atore bairo na ĩwĩ Jesús: —Yʉ tʉ̃gomajũcõãña. ¿Mʉjãã pʉame ãnoa cawĩmarã Diore na cabasapeorijere mʉjãã ĩñaetinucũñati Dios ya tutipʉ? Mʉjãã masĩrã. Bairo ĩña: ‘Dios, cawĩmarãrẽ, caũpũrããcã cʉ̃ãrẽ mʉrẽ na caĩʉseanipeere mʉ na basapeo joroque na mʉ átiya,’ ĩ quetibʉjʉya ti tutipʉ —na ĩwĩ Jesús fariseo quetiuparãjããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bairo ĩ yaparo, na aweyori ti macã Jerusalẽrẽ witicoámí, Betania macãpʉ ácʉ́. Topʉ jãã cãniwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cabusuri rʉ̃mʉ caãno tunucoámí Jesús Jerusalẽpʉ. Bairo ti macãpʉ ácʉ́, queya tʉ̃goñañupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bairo queyari, jĩcãʉ̃ yucʉ higuera cawãmecʉtii, maa tʉ̃niacã caãniirẽ ĩñajowĩ. Bairo ĩñajori yua, carícare ĩñaʉ ámí. Bairo carícare cʉ̃ camacãmiatacʉ̃ãrẽ, capũũ jeto ãñupã. Ríca mañupã. Bairo cabairoi, atore bairo ĩwĩ yua Jesús higuerare: —¡Atii, tocãrõã ríca manigaro yua! Bairo cʉ̃ caĩrõ, jicoquei ti yucʉ pʉame jĩnicoaápʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bairo cabairo ĩña, jãã, Jesús cʉ̃ cabuerã pʉame jãã ĩña acʉacoapʉ. Atore bairo jãã ĩwʉ̃ Jesure: —¿Ñe jʉ̃gori yoaro mee to jĩnicoayati ti yucʉ? —cʉ̃ jãã ĩ jẽniñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bairo jãã caĩjẽniñarõ tʉ̃go, atore bairo jãã ĩwĩ Jesús: —Cariape mʉjããrẽ ñiña: Dios mena tʉ̃goñatutuari pʉgani cãrõ tʉ̃goñarĩ mee, “Yʉ caĩrõrẽ bairo baicoagaro,” cariape mʉjãã caĩtʉ̃goñatutuacõãta, atii higuera yucʉre yʉ caátiatatore bairo netõjãñurõ mʉjãã átimasĩgarã. Bairi ati ʉ̃tãʉ̃rẽ etari, “Wãáti ria capairiyapʉ etanʉcãrõjã,” mʉjãã caĩata, mʉjãã caĩrõrẽã bairo baibujioro tii ʉ̃tãʉ̃ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Yʉ cajẽnirõrẽã bairo jogʉmi Dios,” cariape mʉjãã caĩtʉ̃goñatutuacõãta, nipetiri wãme cʉ̃ mʉjãã cajẽnirĩjẽrẽ mʉjãã jomajũcõãgʉmi Dios —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bairo cabero templo wiipʉ jãámi Jesús. Bairo topʉ camasãrẽ cʉ̃ cabueãnitoye, sacerdote majã quetiuparã, aperã judío majã, cabʉtoa camasĩrã cʉ̃ã, cʉ̃tʉ etari, atore bairo qũĩ jẽniñawã: —¿Noa ũna na carotiro mena bairo mʉ átiati ñamicã mʉ caátiatajere? ");
INSERT INTO cbcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩwĩ Jesús: —Yʉ cʉ̃ã mʉjããrẽ jĩcã wãme yʉ jẽniñagʉ. Cariape yʉ mʉjãã yʉwa: ¿Ni ũcʉ̃ camasãrẽ cʉ̃ bautiza rotijoyupari Juan ãnacʉ̃rẽ? ¿Dios, o camasã pʉame cʉ̃ na bautiza rotijoyupari? Tiere cariape yʉ mʉjãã caĩquetibʉjʉata, yʉ cʉ̃ã cariape mʉjããrẽ yʉ quetibʉjʉgʉ, “Noa ũna na carotiro mena bairo yʉ átiya,” mʉjãã ñigʉ —na ĩwĩ Jesús. Bairo cʉ̃ caĩrõ tʉ̃go, yasioroaca ãmeo bʉsʉwã na majũ cʉ̃rẽ na caĩyʉpeere: “¿Nopẽ bairo cʉ̃ marĩ yʉrãati? ‘Dios pʉame cʉ̃ bautiza rotijoricʉmi Juarẽ,’ marĩ caĩata, ‘Toroque, ¿nopẽĩrã Juan ãnacʉ̃ cʉ̃ caquetibʉjʉrijere cariape mʉjãã tʉ̃goeti?’ marĩ ĩbujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tunu bairoa, ‘Camasã pʉame cʉ̃ bautiza rotijoricarãma Juarẽ,’ marĩ ĩ masĩẽtĩña, marĩrẽ tutirema, ĩrã. Merẽ camasã nipetiro, ‘Juan ãnacʉ̃ Dios cʉ̃ caquetibʉjʉrotijoricʉ ãmi,’ ĩ tʉ̃goñacõãñama,” yasioroaca ãmeo ĩ bʉsʉwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bairi, “Jãã masĩẽtĩña Juarẽ cabautiza rotijoricʉre,” qũĩwã fariseo quetiuparãjãã Jesure. Bairo na caĩrõ tʉ̃go, Jesús pʉame bairo na ĩwĩ: —Cariape yʉ mʉjãã yʉetiya. Bairi yʉ cʉ̃ã, “Noa ũna na carotiro mena tore bairo yʉ átimasĩña,” mʉjããrẽ ñi quetibʉjʉetigʉ —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ĩ yaparo, ape wãme ĩcõñarĩ bairo na ĩ quetibʉjʉwĩ Jesús: —¿Dope bairo mʉjãã ĩ tʉ̃goñañati atie quetire? Jĩcãʉ̃ pʉgarã capũnaacʉcʉ ãñupʉ̃. Bairi jĩcãʉ̃rẽ, “Macʉ̃, ati rʉ̃mʉrẽ yʉ ʉse wesepʉ mʉ capaaʉáto yʉ boya,” qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ macʉ̃ pʉame, “¡Yʉ áperigʉ, yʉ ágaetiya!” qũĩñupʉ̃. Cabero cʉ̃ pacʉre cʉ̃ caĩnetõnʉcãrĩjẽrẽ ape wãme tʉ̃goña wasoari, paaʉ acoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Cabero tunu cʉ̃ macʉ̃ apeire torea bairo cʉ̃ paarotiyupʉ na pacʉ tunu. Cʉ̃ pʉame, “Jaʉ, ãmeacã yʉ paaʉ ágʉ,” qũĩñupʉ̃. Bairo caĩ nimicʉ̃ã, paaʉ ápéyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bairi na pacʉ cʉ̃ caborijere caátacʉ, ¿ni pʉame cʉ̃ ãñuparĩ? —na ĩ jẽniñawĩ Jesús, to caãna fariseo majãrẽ. Bairo cʉ̃ caĩjẽniñarõ tʉ̃go: —Cʉ̃ macʉ̃ cʉ̃ carotijʉ̃goatacʉ pʉame niñami na pacʉ cʉ̃ caĩrĩjẽrẽ catʉ̃goʉsaʉ majũ —qũĩwã. Bairo na caĩrõ tʉ̃go, atore bairo na ĩnemowĩ tunu Jesús to caãna fariseo majãrẽ: —Cariape mʉjããrẽ ñiña: Torea bairo Roma macã macããnarẽ camasã yaye dinerore jejobojari majã, bairi carõmia caʉ̃mʉa mena caepewapatarã rõmirĩ cʉ̃ã, mʉjãã jʉ̃goye Dios mena cabʉsʉqũẽnorã ãnirĩ, Dios cʉ̃ carotimasĩrĩpaʉre mʉjãã jʉ̃goye jããgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan ãnacʉ̃ pʉame caroa ãnajẽ cʉtajere mʉjããrẽ quetibʉjʉyupi. Bairo cʉ̃ caĩquetibʉjʉmiatacʉ̃ãrẽ, cariape cʉ̃ mʉjãã tʉ̃goesupa. Bairo cʉ̃ caĩquetibʉjʉriquere cariape mʉjãã catʉ̃goetimiatacʉ̃ãrẽ, dinerore jejobojari majã, bairi carõmia caʉ̃mʉa mena caepewapatarã rõmirĩ cʉ̃ã cʉ̃ tʉ̃goʉsayupa. Bairo na caáto ĩñamirãcʉ̃ã, roro mʉjãã caátajere tʉ̃goña yapapuari mʉjãã tʉ̃goña wasoaesupa mʉjãã yerire —na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ĩ quetibʉjʉ yaparo, atore bairo camasãrẽ na ĩ quetibʉjʉnemowĩ tunu: “Tunu ape wãme ĩcõñarĩ, mʉjããrẽ yʉ quetibʉjʉpa: Ãñupʉ̃ jĩcãʉ̃ wese upaʉ. Cʉ̃ pʉame ʉse wesere qũẽnoñupʉ̃. Bairo ti wesere ote yaparo, cʉ̃ wesere jãnía ẽñotayupʉ ʉ̃tã rupaa mena. Áti yaparo, ʉse ocore na canumuparo cʉ̃ãrẽ qũẽnoñupʉ̃. Áti yaparo, na caĩñacotepa wii caʉ̃mʉarĩ wii, torre cʉ̃ãrẽ qũẽnoñupʉ̃. Bairo qũẽno yaparori bero, acoásúpʉ cayoaropʉ. Mai, ágʉ jʉ̃goye, cʉ̃ wesere waso cũñupʉ̃ aperã paari majãrẽ, wapatagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cabero yua, ʉse cabʉtiri yʉtea caetaro masĩrĩ, cʉ̃ ʉ̃mʉarẽ na joyupʉ cʉ̃ ya wesere cʉ̃ cawasoricarã tʉpʉ. Cʉ̃rẽ na cawasorique wapare boʉ, na joyupʉ, tiere na jeatíbojaáto, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bairo cʉ̃ ʉ̃mʉa na caetaro ĩña, ti wese paari majã pʉame cʉ̃ ʉ̃mʉa cʉ̃ cajomiatana jĩcããrãrẽ na qũẽñuparã. Aperãrẽ na pajĩãrecõãñuparã. Aperãrẽ ʉ̃tã rupaa mena wẽẽrĩ na cãmitu tunuojoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Cabero ti wese upaʉ pʉame cʉ̃ ʉ̃mʉa cʉ̃ cajojʉ̃goricarã netõjãñurõ na jonemoñupʉ̃ tunu cʉ̃ wesepʉ. Tunu torea bairo na ásuparã ti wesere capaari majã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Cabero ti wese upaʉ cʉ̃ macʉ̃ majũrẽ cʉ̃ joyupʉ, atore bairo ĩ tʉ̃goñarĩ: ‘Yʉ macʉ̃ roquere cʉ̃ nʉcʉ̃bʉgobujiorãma, yʉ macʉ̃ majũ cʉ̃ caãnoi.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bairo cʉ̃ caĩtʉ̃goñamiatacʉ̃ãrẽ, wese paari majã pʉame ti wese upaʉ macʉ̃ cʉ̃ caatóre ĩñarĩ, ãmeo ĩñuparã: ‘Atíyami ati wese upaʉ macʉ̃. Cʉ̃ã niñami cʉ̃ pacʉ cʉ̃ cariaro bero ati wesere cacʉ̃goʉsapaʉ. Bairi cʉ̃ marĩ pajĩãrocacõãto. Bairo marĩ caápata, ati wese uparãrẽ bairo marĩ tuagarã,’ ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bairo caĩrã ãnirĩ na caĩrõrẽã bairo ásuparã. Ti wese tʉ̃nipʉ cʉ̃ ñeowaátí, cʉ̃ pajĩãrocacõãñuparã,” na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩ jẽniñawĩ cʉ̃ caĩrĩjẽrẽ catʉ̃gori majãrẽ: “¿Dope bairo ácʉmi mʉjãã ĩ tʉ̃goñañati cʉ̃ macʉ̃rẽ na capajĩãrocaro bero ti wese upaʉ pʉame ti wesere etaʉpʉ?” ");
INSERT INTO cbcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩwã: —Bairo átigʉmi: Bopacooro na ĩñaecʉ̃, ti wese paari majãrẽ na pajĩãrecõãgʉmi. Bairo na átireri bero, aperãrẽ cʉ̃ wesere coteroticũgʉmi. Na pʉame roque cʉ̃ jogarãma cʉ̃rẽ na cawasorique wapare, ti yʉtea caetaro —qũĩwã Jesure cʉ̃ caĩrĩjẽrẽ catʉ̃gori majã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemowĩ tunu: —¿Atie quetibʉjʉcũrĩqũẽrẽ mʉjãã ĩñaetinucũñati Dios yaye bʉsʉrica tutipʉ? Mʉjãã masĩrã. Bairo ĩña: ‘Ʉ̃tã mena cawii qũẽnorĩ majã jĩcã ʉ̃tããrẽ na caboetimiatacʉ̃ãrẽ, tia pʉame caãni majũrĩcã nigaro. Tia camanicõãta, wii manibujioricaro. Dios pʉame bairoa ásupi. Bairo cʉ̃ caátore ĩñarã, marĩ tʉ̃goña ʉseaniña,’ ĩ quetibʉjʉya Dios yaye bʉsʉrica tutipʉ —na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ĩ quetibʉjʉ yaparo, atore bairo na ĩ nemowĩ tunu: —Bairi mʉjããrẽ ñiña: Mʉjãã, Dios cʉ̃ carotimasĩrĩpaʉre cajããbujioatana topʉ mʉjãã jããetigarã. Aperã pʉame roque jããgarãma. Dios cʉ̃ carotirore bairo caátimajã jããgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tunu ni jĩcãʉ̃ ũcʉ̃ tia ʉ̃tãã mena cʉ̃ cañarocapeata, rocapecoabujioʉmi. Tunu bairoa tia, jĩcãʉ̃ buipʉ to cañarocapeata, cʉ̃ rocaboo rocacõãbujioro —na ĩ quetibʉjʉwĩ Jesús, tia ʉ̃tããrẽ bairo cʉ̃ cabairijere na quetibʉjʉgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, sacerdote majã quetiuparã bairi fariseo majã cʉ̃ã masĩcõãwã Jesús cʉ̃ caĩrĩjẽrẽ. “Marĩ pʉame tia ʉ̃tããrẽ carocari majãrẽ bairo marĩ ãniña. Bairi marĩrẽã ĩgʉ ĩcʉ̃mi Jesús,” ĩ tʉ̃goñawã. ");
INSERT INTO cbcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tie jʉ̃gori Jesure cʉ̃ ñegamirãcʉ̃ã, cʉ̃ ñemasĩẽma, camasãrẽ na uwirã. “‘Jesús profeta ãcʉ̃mi,’ ĩ tʉ̃goñarĩ marĩ qũẽrema camasã, cʉ̃ marĩ cañerotiata,” ĩrã, cʉ̃ ñemasĩẽma. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tunu ape wãme camasãrẽ ĩcõñarĩ na quetibʉjʉnemowĩ: ");
INSERT INTO cbcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dios cʉ̃ carotimasĩrĩpaʉ atore bairo niña: Jĩcãʉ̃ quetiupaʉ rey cʉ̃ macʉ̃ cʉ̃ cawãmojiyaparo bose rʉ̃mʉrẽ qũẽnobojayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bairo qũẽnorĩ yua, cʉ̃ capiiatanarẽ cʉ̃ ʉ̃mʉarẽ na piirotijoyupʉ. Bairo cʉ̃ caĩrõrẽã bairo cʉ̃ ʉ̃mʉa narẽ na caquetibʉjʉnetõmiatacʉ̃ãrẽ, cʉ̃ capiiatana pʉame atígaesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bairi cabero aperã cʉ̃ ʉ̃mʉarẽ tunu na piirotijonemoñupʉ̃: ‘Bairo mʉjãã ĩgarã yʉ capiiatanarẽ: “Merẽ marĩ caʉgaparo etaya. Yʉ wecʉare, aperã waibʉtoa caroaro cariicʉna cʉ̃ãrẽ na pajĩãrĩ, na riire yʉ ãsʉ̃ñaioyaparoya. Ñe ũnie rʉsaetiya. Bairi tãmurĩ mʉjãã apá,” na ĩ quetibʉjʉnetõrájá,’ na ĩ joyupʉ quetiupaʉ rey cʉ̃ ʉ̃mʉarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Cʉ̃ capiimiatana pʉame cʉ̃ yʉeticõãñuparã. Jĩcãʉ̃ na mena macããcʉ̃ cʉ̃ wesepʉ acoásúpʉ. Apei cʉ̃ caapeye nunirõpʉ acoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aperã pʉame quetiupaʉ rey ʉ̃mʉarẽ ñerĩ, roro na ásuparã. Jĩcããrãrẽ na pajĩãreyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bairo quetiupaʉ rey pʉame roro na caáto tʉ̃go yua, asiajãñuñupʉ̃. Cʉ̃ ʉ̃mʉa soldaua pajĩãrĩ majã pʉamerẽ natʉ joyupʉ, na pajĩãrerotijoʉ. Na ya macã cʉ̃ãrẽ joerocacõã rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bairo átirotiri bero, atore bairo cʉ̃ ʉ̃mʉa aperãrẽ na ĩñupʉ̃: ‘Yʉ macʉ̃ cʉ̃ cawãmojiyaparo bose rʉ̃mʉrẽ ñe ũnie merẽ rʉsaetiya. Yʉ capiijomiatana pʉame roro na caátie jʉ̃gori na yʉ boetiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bairi maarĩpʉ mʉjãã caátó yʉ boya tunu. Maapʉ caãna tocãnacãʉ̃pʉrea mʉjãã cabocaetarãrẽ, “Ʉgarasá quetiupaʉ rey macʉ̃ bose rʉ̃mʉrẽ,”’ na mʉjãã ĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ ʉ̃mʉa cʉ̃ caĩrõrẽã bairo maarĩpʉ ásuparã. Á yua, nipetiro na cabocaetarãrẽ na neñoñuparã, camasã na caĩroarã, na caĩroaena cʉ̃ãrẽ. Bairo na caátoi, quetiupaʉ rey bose rʉ̃mʉ cʉ̃ caqũẽnorĩ arʉare camasã jeto jiracoasuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Bairo quetiupaʉ rey pʉame cʉ̃ capiijoatanarẽ na jẽnigʉ, ti arʉapʉ etayupʉ. Eta yua, jĩcãʉ̃ na mena macããcʉ̃rẽ qũĩñabocayupʉ. Cʉ̃ pʉame jutii, wãmo jiyarica bose rʉ̃mʉ macããjẽ mee jutii jãñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bairo tie mee cʉ̃ cajãñarõ ĩñarĩ quetiupaʉ rey atore bairo qũĩñupʉ̃: ‘Yʉ yaʉ, wãmo jiyarica bose rʉ̃mʉ macããjẽrẽ mʉ jutii jãnaẽtĩña. Bairi, ¿noa na carotiro mena yʉ ya wiire mʉ jãáti?’ qũĩñupʉ̃. Caʉ̃mʉ pʉame quetiupaʉre dope bairo qũĩ masĩẽsupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bairi quetiupaʉ rey pʉame cʉ̃ mesarire caĩñarĩcãnʉgõrĩ majãrẽ atore bairo na ĩñupʉ̃: ‘Ãnirẽ cʉ̃ ñeña. Cʉ̃ wãmorĩ, cʉ̃ rʉporire jiyari, jõ macã canaitĩãrõpʉ cʉ̃ rocawiyocõã joya,’ na ĩñupʉ̃. To canaitĩãrõpʉ camasã capããrã otigarãma. Na opire bacarʉpotugarãma, bʉtioro yapapuarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Capããrã niñama Dios cʉ̃ capiijorã. Bairo na caãnimiatacʉ̃ãrẽ, na mena macããna jĩcããrã jeto cʉ̃ yʉyama, cʉ̃ cabeserã pʉame,” na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cabero fariseo majã jĩcãrõrẽ bairo ãmeo bʉsʉpẽnirã neñañuparã. “¿Dope bairo rorije cʉ̃ bʉsʉo joroque marĩ ánaati? Bairo roro Jesús cʉ̃ cabʉsʉata, cʉ̃ marĩ bʉsʉjãmasĩgarã,” ĩrã neñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bairo bʉsʉpẽni yaparo, na cabuerã, bairi Herodes yarã cʉ̃ãrẽ Jesutʉ na joyupa, atore bairo qũĩ jẽniñagarã: —Cabuei, jãã masĩña merẽ mʉ caátiãnierẽ. Mʉa, caroaro cariape mʉ quetibʉjʉnucũña. Tunu bairoa cariapea Dios marĩrẽ cʉ̃ caãnirotiricarorea bairo mʉ bueya. Aperã roro na cabaurije, aperã caroaro na cabaurije jʉ̃gori mee na miñabeseya. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bairo cabai ãnirĩ, ¿dope bairo mi tʉ̃goñañati romano majã marĩrẽ na carotirijere? ¿To ñuñati quetiupaʉ emperadore camasã yaye dinerore jeri, jãã cajoata, o to ñuẽtĩñati? —qũĩ jẽniñawã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús pʉame roro na caĩtʉ̃goñarĩjẽrẽ masĩcõãrĩ, atore bairo na ĩwĩ: —Mʉjãã, caĩtopairã, ¿nopẽĩrã, “Roro qũĩáto,” caĩrãrẽ bairo yʉ mʉjãã ĩ jẽniñañati? ");
INSERT INTO cbcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jaʉ, yʉre joñijate moneda tiire, emperadore mʉjãã cajonucũrĩ tii ũnorẽ —na ĩwĩ. Bairo cʉ̃ caĩrõ tʉ̃go, moneda tiire cʉ̃ nuniwã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bairo na canunirõ, atore bairo na ĩwĩ: —¿Noa riape to tusayati ti tii moneda tiiacapʉre? Tunu bairoa, ¿noa wãme woaturique to tusayati? —na ĩ jẽniñawĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bairo cʉ̃ caĩrõ, na pʉame bairo qũĩwã: —Emperador, quetiupaʉ ya wãme, bairi tunu cʉ̃ riape tusaya ti tii moneda tiiacapʉre —qũĩwã. Bairo na caĩquetibʉjʉro, atore bairo na ĩwĩ yua Jesús: —Toroque emperador quetiupaʉre cʉ̃ yaye caãnierẽ, cʉ̃rẽ cʉ̃ tunuojoya. Tunu bairoa Dios yaye caãnierẽ Diore cʉ̃ jonucũña —na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bairo cʉ̃ caĩrõ tʉ̃gorã, cʉ̃ caĩquetibʉjʉrijere tʉ̃go acʉacoama. Bairo bairã, cʉ̃ witiweyocoámá. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti rʉ̃mʉa caãno jĩcããrã saduceo majã na caĩrã qũĩñarámá Jesure. Mai, saduceo majã pʉame atore bairo caĩtʉ̃goñarĩ majã niñama: “Camasã cariacoatana, nopẽ bairo catitunu masĩẽnama,” caĩtʉ̃goñarã ãma. Bairi atore bairo qũĩwã Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Cabuei, Moisés ãnacʉ̃ atore bairo marĩrẽ ĩ woacũñañupĩ tirʉ̃mʉpʉre: “Ni jĩcãʉ̃ ũcʉ̃ cawãmojiyaricʉ cʉ̃ nʉmo mena pũnaa mácʉ̃ã cʉ̃ cariacoapata, cʉ̃ ãnacʉ̃ bai pʉame cʉ̃ buiacore cõ cʉ̃ wãmojiyaáto. Bairo cʉ̃ caáto, cʉ̃ pũnaa caãniparã pʉame cʉ̃ ãnacʉ̃ pũnaarẽ bairo ãnibujiorãma,” ĩcũñupĩ. Tiere mʉ masĩĩ. Bairi jĩcã wãme ĩcõñarĩ jãã quetibʉjʉpa mai: ");
INSERT INTO cbcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ãñuparã jĩcãni, jĩcã wãmo peti pʉga pẽnirõ cãnacãʉ̃ jĩcãʉ̃ pũnaa. Bairi cajʉ̃gocʉ pʉame wãmojiya jʉ̃goyupʉ. Cabero pũnaa mácʉ̃ã riacoásúpʉ. Bairi cʉ̃ ãnacʉ̃ bai pʉame cʉ̃ buiacore wãmojiyayupʉ tunu. Cabero pũnaa mácʉ̃ã riacoásúpʉ cʉ̃ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bairi torea bairo cʉ̃ bai cabero macããcʉ̃ cʉ̃ã cõ wãmojiyamii, riacoásúpʉ. Bairo jetoa aperã cʉ̃ bairã cʉ̃ã na buiacore nʉmocʉtimii, pũnaa mána jeto riapeticoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Cabero na ãnana nʉmo caãnimirĩcõ cʉ̃ã riacoásúpo. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bairo ati yepapʉ nipetirã nʉmo caãnacõ ãnirĩ yua, cariaricarã tunu na cacatiropʉ na caãno, ¿ni majũ jĩcã wãmo peti pʉga pẽnirõ cãnacãʉ̃ mena macããcʉ̃ nʉmo cõ ãnicʉti? —qũĩ jẽniñawã saduceo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩ quetibʉjʉwĩ Jesús: —Mʉjãã, saduceo majã, Dios yaye cʉ̃ caquetibʉjʉcũrĩqũẽ, bairi cʉ̃ catutuarije cʉ̃ãrẽ mʉjãã tʉ̃goña mawijiacoaya, bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ape ʉmʉrecóore caʉ̃mʉa, carõmia cʉ̃ã catiri caetaparã pʉame nʉmo manigarãma. Ángelea majã, ʉmʉrecóo macããna na caãnorẽ bairo nigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apeyera tunu mʉjããrẽ yʉ quetibʉjʉgʉ: ¿Cariacoatana nimirãcʉ̃ã tunu na cacatirore Dios cʉ̃ caquetibʉjʉcũrĩcã tutipʉ mʉjãã ĩñaetinucũñati atiwẽrẽ? Mʉjãã masĩrã: ");
INSERT INTO cbcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yʉa, yʉ ãniña Abraham, cʉ̃ macʉ̃ Isaac, bairi cʉ̃ macʉ̃ Jacob quetiupaʉ caãnacʉ̃,’ ĩñupĩ. Bairo cʉ̃ caĩrõĩ, marĩ masĩña: Dios pʉame cayasirã ãnana ũna quetiupaʉ mee niñami. ¡Cacatirã majũ quetiupaʉ roque niñami! —na ĩ quetibʉjʉwĩ Jesús saduceo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bairo camasã pʉame cʉ̃ caĩquetibʉjʉro tʉ̃go, tʉ̃gocõã maniáma caroaro Jesús cʉ̃ caĩquetibʉjʉrijere yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bairo Jesús caroaro cʉ̃ caĩquetibʉjʉro jʉ̃gori, pʉgani cʉ̃ jẽniñanemo masĩẽma saduceo majã pʉame yua. Bairo tiere tʉ̃gorã, fariseo majã pʉame na majũ ãmeo bʉsʉpẽnigarã neñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bairo bʉsʉpẽni yaparo yua, jĩcãʉ̃ na mena macããcʉ̃, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueire Jesutʉ cʉ̃ joyupa. Bairi cʉ̃ pʉame Jesús roro cʉ̃ bʉsʉáto ĩrã na cajoatacʉ, atore bairo qũĩ jẽniñawĩ: ");
INSERT INTO cbcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Cabuei, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ mena macããjẽ, ¿dise pʉame caãnimajũrĩjẽ cʉ̃ caroticũrĩqũẽ to ãniñati? —qũĩ jẽniñawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, atore bairo qũĩwĩ Jesús caʉ̃mʉrẽ: —‘Mʉjãã, Israel macããna, mʉjãã caátiãnie nipetirije mena cʉ̃ maiña. Tunu bairoa mʉjãã yeripʉ, mʉjãã catʉ̃goñarĩjẽ nipetirije mena cʉ̃ maiña. Tunu bairoa mʉjãã catutuarije nipetirije mena cʉ̃ maiña.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Atie Moisés cʉ̃ caroticũrĩqũẽ tocãnacã wãme netõrõ caãnimajũrĩjẽ niña. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Atie rocajãñurĩ cʉ̃ caroticũrĩqũẽ torea bairo jãñurĩ niña tie cʉ̃ã. Bairo ĩña: ‘Mʉjããtʉ macããna cʉ̃ãrẽ mʉjãã rupaʉre mʉjãã camairõrẽã bairo na maiña.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tie pʉga wãme cʉ̃ caroticũrĩqũẽ caãnimajũrĩjẽ niña. Moisés ãnacʉ̃ ape wãme cʉ̃ caroticũrĩqũẽ bairi profeta majã na caroticũrĩqũẽ tocãnacã wãme netõrõ caãnimajũrĩjẽ niña. Tie camanicõãta, ape wãme carotirije manibujioro —qũĩ quetibʉjʉwĩ Jesús cajʉ̃gobueire. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Bairo fariseo majã aperã na caneñarõ, atore bairo na ĩwĩ Jesús cʉ̃tʉ caãnarẽ: —¿Dope bairo mʉjãã ĩ tʉ̃goñañati Mesías, “Dios cʉ̃ cajoʉ,” na caĩrẽ? ¿Noa macʉ̃ cʉ̃ ãnicʉti? —na ĩ jẽniñawĩ. Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩwã: —David ãnacʉ̃ pãrãmi niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bairo na caĩrõ tʉ̃go, atore bairo na ĩ jẽniñanemowĩ tunu: —Bairo cʉ̃ caãnimiatacʉ̃ãrẽ, ¿nopẽĩ David ãnacʉ̃ pʉame Espíritu Santo cʉ̃rẽ cʉ̃ camasĩõrĩjẽ jʉ̃gori, “Yʉ Quetiupaʉ,” cʉ̃ qũĩñañuparĩ Mesíare? Atore bairo ĩñupĩ David: ");
INSERT INTO cbcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Dios pʉame yʉ Quetiupaʉre atore bairo qũĩwĩ: “Ato ruiya cariape nʉgõã pʉame mai. Mʉ pesua caãnanarẽ na yʉ canetõnʉcãrõ bero, mʉ pʉame na mʉ rotimasĩgʉ,”’ ĩ woatuyupi David ãnacʉ̃, Dios cʉ̃ caĩrĩqũẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bairo Mesíare, “Yʉ Quetiupaʉ,” cʉ̃ caĩmiatacʉ̃ãrẽ, ¿dope bairo cʉ̃ pãrãmi majũ cʉ̃ ãnibujiocʉti? —na ĩ jẽniñawĩ Jesús cʉ̃tʉ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, ni jĩcãʉ̃ ũcʉ̃ cʉ̃ yʉmasĩẽmi jĩcã wãmeacã ũno. Bairi yua pʉgani cʉ̃ jẽniñanemo masĩẽma. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cabero camasã cʉ̃tʉ caãnarẽ, bairi jãã, cʉ̃ cabuerã cʉ̃ãrẽ atore bairo jãã ĩwĩ: ");
INSERT INTO cbcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ cajʉ̃gobueri majã, bairi fariseo majã cʉ̃ã, ‘Bairo ĩgaro ĩña Moisés ãnacʉ̃ marĩrẽ cʉ̃ caroticũrĩqũẽ,’ mʉjããrẽ ĩ quetibʉjʉnucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bairi mʉjããrẽ na caĩquetibʉjʉrijere bairo ása. Na tʉ̃goʉsaya. Bairo na tʉ̃goʉsamirãcʉ̃ã, bairãpʉa na caátiãnierẽ bairo ápericõãña. Caĩtopairã ãnirĩ cariape rotimirãcʉ̃ã, na majũ pʉame na caátirotirore bairo áperiyama. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Caʉ̃mʉ jĩcãʉ̃, cʉ̃ paabojari majõcʉre cʉ̃ jʉpʉsaetiyami. Jĩcã wãme ũnoacã cʉ̃ãrẽ cʉ̃ jʉáperiyami. Tore bairo Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi fariseo majã cʉ̃ã átiyama camasãrẽ. ‘Jĩcã wãmeacã rʉsaeto ása,’ camasãrẽ caĩrã nimirãcʉ̃ã, na pʉame tore bairo áperimajũcõãñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tunu bairoa caroa wãme nipetirije na caátie camasã na caĩñajoropʉ átinucũñama, nipetiro camasã nʉcʉ̃bʉgoro na mena na catʉ̃goñaparore bairo ĩrã. Tunu bairoa Dios yaye bʉsʉrique, na cawoaturi pũrĩãcãrẽ jiyanucũñama na riapé buipʉ, na wãmorĩpʉ cʉ̃ãrẽ. Tunu bairoa jutii cayowerijere jãñajesoyama. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tunu bose rʉ̃mʉ caãno narẽ na capiiata, caroapaʉripʉre ruiri ʉgaganucũñama. Tunu bairoa ñubuerica wiipʉ na caápáta, quetiupaʉ cʉ̃ caruirije ũniepʉ jeto ruiganucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tunu bairoa maapʉ na caáñesẽãta, nipetiro camasã nʉcʉ̃bʉgorique mena na cajẽnirõ bonucũñama. ‘¡Jããrẽ Cabuerã!’ camasã narẽ na caĩjẽnirõ bonucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Bairo na cabomiatacʉ̃ãrẽ, bairo na caborore bairo mʉjãã caĩñacõrõ yʉ boetiya. Mʉjãã cabuei jĩcãʉ̃ã niñami. Tunu mʉjãã pʉame jĩcãʉ̃ pũnaa jĩcãrõrẽ bairo cabairã mʉjãã ãniña. Bairi, ‘¡Jããrẽ Cabuerã!’ camasã mʉjããrẽ na caĩroaro boeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ ati yepa macããcʉ̃rẽ, ‘Marĩ pacʉ ũcʉ̃ niñami,’ qũĩroaeticõãña. Jĩcãʉ̃ã niñami marĩ Pacʉ, ʉmʉrecóo macããcʉ̃ majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tunu bairoa, ‘¡Marĩ Quetiuparã!’ aperã mʉjããrẽ na caĩroarore boeticõãña. Yʉ, Cristo jeto camasã quetiupaʉ yʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bairi ni jĩcãʉ̃ ũcʉ̃ caãnimajũʉ̃rẽ bairo caãnigaʉ, cabopacarãrẽ caroaro na cʉ̃ cajʉáto ñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ majũã, ‘Caãnimajũʉ̃ yʉ ãniña,’ caĩ pʉamerẽ, cabʉgoro macããcʉ̃rẽ bairo cʉ̃ ãnio joroque cʉ̃ átigʉmi Dios. Apei, ‘Caãnimajũʉ̃ mee yʉ ãniña,’ caĩ pʉame roquere, cabero cabʉgoro macããcʉ̃rẽ bairo mee cʉ̃ ãnio joroque cʉ̃ átigʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Dios cʉ̃ carotimasĩrĩpaʉre mʉjãã jããmasĩẽtĩgarã. Tunu camasãrẽ ricaati buerã, Dios cʉ̃ carotimasĩrĩpaʉre cajããgarã pʉamerẽ caẽñotarãrẽ bairo na mʉjãã átinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Cawapearã rõmirĩ ya wiirire mʉjãã ẽmanucũña. Tunu yoaro Diore cʉ̃ mʉjãã jẽniñubuetonucũña. Bairi aperã netõjãñurõ roro mʉjãã netõgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Cayoaropʉ, ria capairiyare pẽña átí, o ape yepapʉre ánetõ átí, mʉjãã quetibʉjʉ ñesẽãnucũña, mʉjãã yaye quetire, camasã na catʉ̃goʉsaparore bairo ĩrã. Bairo jĩcãʉ̃ catʉ̃goʉsaʉre cʉ̃ bócarã, ricaati cʉ̃ mʉjãã caquetibʉjʉrije tʉ̃gori tʉ̃goñamawijiao joroque cʉ̃ mʉjãã átiya. Mʉjãã netõjãñurõ caróʉre bairo caácʉ cʉ̃ ãnio joroque cʉ̃ mʉjãã átiya. Bairo mʉjãã caátie jʉ̃gori caʉ̃petieti peeropʉ roro majũ baigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Mʉjãã, roro majũ mʉjãã netõgarã! Jĩcãʉ̃ cacaapee mácʉ̃ cʉ̃ yarãrẽ, ‘Mʉjãã yʉ jʉ̃gogʉ,’ caĩ ũcʉ̃rẽ bairo mʉjãã baiya. Ricaati camasãrẽ na mʉjãã bueya. Atore bairo na mʉjãã ĩ quetibʉjʉya: ‘Ni jĩcãʉ̃ ũcʉ̃, “Caãnorẽ bairo ñiña,” ĩgʉ, “¡Dios ya wii mena ñiña!” cʉ̃ caĩata, cabero cʉ̃ caĩrõrẽã bairo cʉ̃ caápericõãta, ñubujioro. Bairo ĩmicʉ̃ã, “¡Dios ya wii macããjẽ oro majũ mena ñiña!” cʉ̃ caĩata, cabero cʉ̃ caĩrõrẽã bairo cʉ̃ caápericõãta roque, ñuẽtĩña,’ cariape mee mʉjãã ĩ quetibʉjʉya camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Bairo caĩquetibʉjʉrã ãnirĩ cacaapee mánarẽ bairo mʉjãã baiya! Catʉ̃gomasĩẽnarẽ bairo mʉjãã tuaya. Dios ya wii macããjẽ oro pʉame, ti wii netõjãñurõ caãnimajũrĩjẽ mee niña. Ti wii pʉame, ti wii macããjẽ oro to ñuo joroque átiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tunu atore bairo camasãrẽ na mʉjãã quetibʉjʉnemoña: ‘Ni jĩcãʉ̃ ũcʉ̃, “Caãnorẽ bairo ñiña,” ĩgʉ, “¡Altar mena ñiña!” cʉ̃ caĩata, cabero cʉ̃ caĩrõrẽã bairo cʉ̃ caápericõãta, ñubujioro. Bairo ĩmicʉ̃ã, “¡Waibʉcʉ riire na cajoemʉgõjorije mena ñiña!” cʉ̃ caĩata, cabero cʉ̃ caĩrõrẽã bairo cʉ̃ caápericõãta roque, ñuẽtĩña,’ mʉjãã ĩto quetibʉjʉya camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Cacaapee mánarẽ bairo mʉjãã baiya! Waibʉcʉ riire na cajoemʉgõjorije pʉame altar netõjãñurõ caãnimajũrĩjẽ mee niña. Ti altar pʉame waibʉcʉ riire ñuo joroque átiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bairi ni jĩcãʉ̃ ũcʉ̃, ‘Caãnorẽ bairo ñiña,’ ĩgʉ, ‘¡Altar mena ñiña!’ cʉ̃ caĩata, ‘¡Altar, bairi nipetirije altar bui macããjẽ mena ñiña!’ caĩrẽ bairo ĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃, ‘¡Templo mena ñiña!’ cʉ̃ caĩata, ‘¡Templo wiire, bairi ti wii macããcʉ̃ Dios mena cʉ̃ã ñiña!’ caĩrẽ bairo ĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃, ‘¡Ʉmʉrecóo mena ñiña!’ cʉ̃ caĩata, ‘¡Dios ya trono, bairi to ruiricaro macããcʉ̃ mena cʉ̃ã ñiña!’ caĩrẽ bairo ĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Mʉjãã cʉ̃ã pʉga wãmo cãrõ moneda tiiriacarẽ mʉjãã cacʉ̃goata, jĩcã tiiaca mʉjãã jonucũña Diore. O ʉgarique asurique jĩcã wãme ũno pʉga wãmo cãrõ mʉjãã cacʉ̃goata, jĩcãrõãcã mʉjãã jonucũña Diore. Bairo cariape tie ũnierẽ átimasĩmirãcʉ̃ã, ape wãme paijãñurõ Dios cʉ̃ carotirique pʉamerẽ mʉjãã tʉ̃goñaetimajũcõãña. Caroaro ãmeo átaje cʉ̃ãrẽ marĩ rotiyami Dios. Camasãrẽ bopacooro na marĩ caĩñarĩjẽ, bairi caroaro ãmeo mairĩqũẽ cʉ̃ãrẽ marĩ rotiyami. Tie pʉamerẽ mʉjãã tʉ̃goñaẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Mʉjãã, jĩcãʉ̃ cacaapee ĩñaecʉ̃ cʉ̃ yarãrẽ, ‘Mʉjãã yʉ jʉ̃gogʉ,’ caĩ ũcʉ̃rẽ bairo mʉjãã baiya! Tunu, ‘Becoaca cʉ̃ manicõáto,’ ĩrã, oco mʉjãã caetipeere mʉjãã weyórotinucũña. Bairo weyorotimirãcʉ̃ã, waibʉcʉ capai, camellore rupaʉa caʉgayujorãrẽ bairo mʉjãã baiya. Cabʉgoro macããjẽ pʉamerẽ caãnimajũrĩjẽrẽ bairo mʉjãã átiya. Tunu bairoa caãnimajũrĩjẽ pʉamerẽ cabʉgoro macããjẽrẽ bairo mʉjãã ĩñacõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Jotʉ bapaarire dope bairo ʉgueri mano mʉjãã coserotinucũña. Bairo rotimirãcʉ̃ã, mʉjãã yeripʉ roro mʉjãã catʉ̃goñarĩjẽ pʉamerẽ mʉjãã coserotietiya Diore. Bairi mʉjãã cayajapairije nicõãña mʉjãã yeripʉ. Tunu bairoa mʉjãã caborije jetore mʉjãã tʉ̃goñanucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Mʉa, fariseo, cacaapee ĩñaecʉ̃ ũcʉ̃ tʉ̃gopeoya mʉ yʉ caĩrĩjẽrẽ! Jĩcãʉ̃, cʉ̃ jotʉ bapa pupeapʉre cacosejʉ̃goricʉre bairo, mʉ cʉ̃ã cajʉ̃goye mʉ yeripʉre cacosejʉ̃gopaʉ mʉ ãniña. Bairo mʉ caáto, caroʉ́ majũ mʉ ãnicõãgʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Camasã ãnana na cacũrocarica ʉ̃tã ope buire bairo mʉjãã baiya. Ti opeaca buipʉ cabotirije mena caroaro warerique bauya. Bairo baimirõcʉ̃ã, capupea pʉame caboaricarã õwã ãnajẽ, bairi capũnirĩjẽ cʉ̃ã nicõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Torea bairo mʉjãã baiya. Camasã mʉjããrẽ na caĩñarõ, caroarã majũ mʉjãã bauya. Bairo baumirãcʉ̃ã, mʉjãã yeri pupeapʉ mʉjãã rojãñuña. Caĩtorije tʉ̃goñarĩqũẽ, bairi apeye roro tʉ̃goñarĩqũẽ cʉ̃ã mʉjãã yeri pupeapʉ jiracõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi mʉjãã fariseo majã cʉ̃ã, caĩtopairã, roro majũ mʉjãã netõgarã, ricaati mʉjãã caátiãnie jʉ̃gori! Profeta majã, bairi aperã tirʉ̃mʉpʉ macããna caroarã cʉ̃ã, na rupaʉri ãnajẽ masã ope buire mʉjãã qũẽnonucũña caroa ʉ̃tã wiiriacãrẽ. Bairo áti yaparo, ti wiiriacãrẽ mʉjãã ĩñacotenucũña, camasã, profeta ãnanarẽ na ĩroáto, ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Cabero atore bairo mʉjãã ĩña: ‘Marĩ pʉame marĩ ñicʉ̃jãã na caãni yʉtea macããna marĩ caãmata, narẽ bairo profeta majãrẽ roro na marĩ áperibujioricarã,’ mʉjãã ĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bairo mʉjãã caĩrĩjẽ jʉ̃gori, ‘Profeta majãrẽ capajĩãrericarã pũnaa majũ marĩ ãniña,’ ĩrãrẽ bairo mʉjãã ĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Torena, ¡mʉjãã ñicʉ̃jãã roro na caátijʉ̃goriquere átipeyocõãña! ");
INSERT INTO cbcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Ãña ũna, moena majũ mʉjãã ãniña! Dios camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉ mʉjããrẽ peeropʉ popiye mʉjãã baio joroque cʉ̃ caáto, ¿dope bairo mʉjãã rutimasĩrãati? Mʉjãã rutimasĩẽtĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Torecʉ, mʉjããtʉ yʉ jonemogʉ tunu yʉ yarã profeta majãrẽ, camasĩrĩ majã cʉ̃ãrẽ, bairi cajʉ̃gobueri majã cʉ̃ãrẽ. Bairo na yʉ cajomiatacʉ̃ãrẽ, cañuena ãnirĩ na mʉjãã boetigarã. Jĩcããrã na mena macããnarẽ na mʉjãã pajĩãregarã. Aperãrẽ yucʉpãĩpʉ na mʉjãã papuaturotigarã. Tunu aperã yʉ yarãrẽ sinagoga ñubuerica wiipʉ na mʉjãã baperotigarã. Tunu aperãrẽ roro popiye na baio joroque na mʉjãã átigarã noo na caãnopʉ. Bairi ape macãpʉ na caápáta, topʉ cʉ̃ãrẽ na ʉsaáti, bairo jeto na mʉjãã átigarã roro majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bairo mʉjãã caáto jʉ̃gori, popiye mʉjãã baio joroque mʉjãã átigʉmi Dios. Tocãnacãʉ̃ caroarã, caãniñarĩcãrãrẽ na carií reyarique wapa popiye mʉjãã baio joroque mʉjãã átigʉmi. Na carií rejʉ̃goricʉ caroʉ́ Abel cawãmecʉcʉpʉi nijʉ̃go aná, Zacarías, Berequías macʉ̃, altar, santuario watoa mʉjãã capajĩãrĩcʉ̃pʉ nituyama camasã na carií rejʉ̃goatana capããrã beropʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cariape mʉjããrẽ ñiña: Na ãnana wapa roro popiye mʉjãã baio joroque mʉjãã átigʉmi Dios, mʉjãã ãme caãnarẽ,” na ĩwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Cabero atore bairo ĩnemowĩ Jesús tunu: “¡Jerusalén, Jerusalén macã macããna mʉjããrẽ ñiña: Dios yarã profeta majãrẽ mʉjãã pajĩãrenucũwʉ̃! Dios mʉjããrẽ cʉ̃ caquetibʉjʉrotijomirĩcãrã cʉ̃ãrẽ ʉ̃tã mena wẽẽrĩ na mʉjãã pajĩãrenucũwʉ̃. Bairo roro majũ na mʉjãã caátimiatacʉ̃ãrẽ, ¡nairõ mʉjããrẽ yʉ jʉátinemogamiwʉ̃! Ãboco cõ pũnaarẽ na asipogo, narẽ cõ caneñorõrẽ bairo mʉjãã yʉ jʉátinemogamiwʉ̃. Bairo yʉ caátimiatacʉ̃ãrẽ, jĩcã nʉgõã yʉ mʉjãã boepʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bairo mʉjãã caboetoi, tocãrõã yua, mʉjãã caãnipaʉ yasicoagaro. Tore camasã aweyorocacõãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Caãnorẽ bairo mʉjããrẽ ñiña: ‘¡Ʉseanirĩ atíyami Dios cʉ̃ cajoʉ majũ!’ mʉjãã caĩparo jʉ̃goye, yʉ mʉjãã ĩñaetigarã mai,” ĩwĩ Jesús, ti macãrẽ ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Cabero templo, Dios ya wii caãniatacʉ ti wiire witicoámí Jesús. Bairo cʉ̃ caátó, jãã, cʉ̃ cabuerã pʉame cʉ̃tʉ etari, atore bairo cʉ̃rẽ jãã ĩwʉ̃: “¡Jã, ĩñañijate! Caroa wii majũ niña templo wii.” ");
INSERT INTO cbcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bairo jãã caĩrõ tʉ̃go, Jesús pʉame bairo jãã ĩwĩ: —Ati wii paca ʉ̃tãpãĩrĩ ũnie nipetirijere mʉjãã ĩñaña. Tie cabaipeere cariape mʉjããrẽ ñiña: Jĩcã rʉ̃mʉ, ati wiire roro na caáti rʉ̃mʉ caetaro, jĩcã ʉ̃tãã ũno bui tuticʉti pesaricaro manopʉ átiyasio rocacõãgarãma ati wiire —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cabero Olivo buropʉ jãã acoápʉ́. Bairo topʉ etarã, Jesús cʉ̃ caruiro ĩñarĩ, jãã, cʉ̃ cabuerã pʉame Jesutʉ atí, atore bairo cʉ̃ jãã ĩ jẽniñawʉ̃: —Jããrẽ mʉ caquetibʉjʉro jãã boya: ¿Nocãrõpʉ to bairoati atie mʉ caĩrĩjẽ? ¿Dope bairo merẽ, “Ati yepa nemo yʉ tunuetagʉ,” bairi tunu, “Ati ʉmʉrecóo peticoagaro,” mʉ caĩataje to bairoati? —cʉ̃ jãã ĩ jẽniñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Bairo jãã caĩjẽniñarõ tʉ̃go, atore bairo jãã ĩwĩ Jesús: —Caroaro majũ mʉjãã tʉ̃goñamasĩgarã, jããpʉ, jãã ĩtoecore, ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Capããrã atígarãma ĩtoñesẽãrĩ majã. Atore bairo ĩgarãma: “Yʉa, Mesías yʉ ãniña, Dios cʉ̃ cajoʉ,” ĩgarãma. Bairo na ĩrĩ, camasã capããrãrẽ na ĩtogarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tunu bairoa mʉjãã queti tʉ̃gogarã: “Camasã aperopʉ cʉ̃ãrẽ ãmeo pajĩãrã átiuparã.” Bairo na caátie quetire tʉ̃gori, tʉ̃goacʉaeticõãña. Ati ʉmʉrecóo capetiparo jʉ̃goye bairoa cabaijʉ̃goyecʉtipee niña bairopʉa. Bairi tʉ̃goacʉaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ti yʉtea caãno jĩcã yepa macããna, ape yepa macããna mena ãmeo pajĩãgarãma. Tunu bairoa jĩcã macã macããna ape macã macããna mena ãmeo pajĩãgarãma. Tunu apeye aʉariarique atígaro. Tunu tutuaro mena ati yepa cʉ̃ã yuguigaro nipetiropʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jĩcãõ carõmio bairirupaʉ caãcõ cõ macʉ̃ cʉ̃ cabuiari rʉ̃mʉ capũnirõ tʉ̃goñarĩ cõ cawisiojʉ̃goriquere bairo niña atie ʉmʉrecóo cabaipee mʉjããrẽ yʉ caquetibʉjʉrije. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mai, atie cabaiparo jʉ̃goye mʉjããrẽ roro átijʉ̃gogarãma. Mʉjããrẽ ñerĩ, aperãrẽ mʉjãã jogarãma popiye mʉjãã baio joroque na caátiparore bairo ĩrã. Bairo áticõã, roro majũ mʉjããrẽ átigarãma. Bairi yua, ati ʉmʉrecóo macããna nipetirã mʉjããrẽ ĩñategarãma, yʉ yarã mʉjãã caãnoi. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bairi ti yʉtea caãno capããrã camasã yʉ yaye bʉsʉriquere piticõãgarãma. Jĩcããrã ãmeo bʉsʉjãbuitiregarãma na majũ. Bairo bairã, ãmeo tejãñugarãma na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tunu bairoa, ‘Jãã, profeta majã, jãã ãniña,’ caĩtori majã capããrã etagarãma. Bairo camasãrẽ na ĩ quetibʉjʉri, na ĩtogarãma. Ricaati tʉ̃gojʉ̃gogarãma camasã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Camasã rorije na caátie bʉtioro majũ nigaro. Bairi camasã capããrã na caãmeomairĩjẽrẽ jãnacõãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bairo na caátimiatacʉ̃ãrẽ, noa ũna yʉ yaye bʉsʉrique jĩcã wãmeacã ũnorẽ na cajãnaeticõãta, yasietigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Atie caroa queti cʉ̃ã ati ʉmʉrecóo capetiparo jʉ̃goye nipetiropʉ cajesapeticoa jʉ̃goyecʉtipee niña bairopʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bairi mʉjãã pʉame profeta Daniel ãnacʉ̃ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo cabaietarijere ĩñarã, atore bairo mʉjãã ĩ tʉ̃goñamasĩgarã: ‘Merẽ ati macã yasigaro baiya.’ Dios ya wiire nocãrõ caroapaʉre moecʉ̃ caróʉ majũ topʉ cʉ̃ caãnierẽ ĩñarã, tore bairo mʉjãã ĩ tʉ̃goñamasĩgarã yua. (Mʉjãã, ati tuti yʉ ya tutire caĩñabuerã pʉame tʉ̃gopeoya yʉ yaye, yʉ caquetibʉjʉrijere.) ");
INSERT INTO cbcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bairo cabairo, Judea yepa macããna ʉ̃tã yucʉpʉ na ruti ápáro. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tunu bairoa jĩcãʉ̃ ũcʉ̃ cʉ̃ wii, cabuimacã arʉapʉ cʉ̃ caãmata, ruiatíri, cʉ̃ apeyere, ape arʉapʉ caãnierẽ cʉ̃ jei ápéricõãto. Cariape cʉ̃ ácoa ápáro. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tunu bairoa cʉ̃, wesepʉ caãcʉ̃ cʉ̃ jutii ũnierẽ bomicʉ̃ã, cʉ̃ jetunuʉ apéricõãto cʉ̃ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ti rʉ̃mʉ caãno carõmia bairirupaʉ caãna popiye netõrõ baigarãma! ¡Tunu bairoa, caũpũrããcãrẽ, capũnaacʉna cʉ̃ã popiye netõrõ baigarãma ti rʉ̃mʉrẽ! ");
INSERT INTO cbcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bairi Diore cʉ̃ jẽniña, mʉjãã carutiripaʉ camasiriyoeti rʉ̃mʉ to caãniparore bairo ĩrã. Cawãma pue yʉtea caãno, o marĩ judío majã, marĩ cayerijãrĩ rʉ̃mʉ ũnorẽ to cabaietiparore bairo ĩrã, Diore cʉ̃ jẽniña. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ti rʉ̃mʉrẽ roro ati yepapʉre bairique nigaro. Dios ati yepare cʉ̃ caátijʉ̃gori rʉ̃mʉ bero tocãnacã rʉ̃mʉrẽ netõrõ popiye bairica yʉtea nigaro ti rʉ̃mʉ caetaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bairi Dios pʉame ti rʉ̃mʉ roro cabairijere cʉ̃ cajãnarotieticõãta, camasã nipetiro riapeticoabujiorãma. Baipʉa, mʉjãã, cʉ̃ cabeserãrẽ mairĩ, peti yʉtea ũnoa popiye mʉjãã cabaipa rʉ̃mʉrẽ áti ẽñotabojagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bairi ni jĩcãʉ̃ ũcʉ̃, ‘Mesías, Dios cʉ̃ cajoʉ pʉame ati macãpʉ etaupʉ,’ o ‘Jĩ macãpʉ etaupʉ,’ cʉ̃ caĩata, cariape cʉ̃ mʉjãã tʉ̃goetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Caĩtopairã capããrã atígarãma. ‘Yʉa, Mesías yʉ ãniña,’ o ‘Yʉa, profeta yʉ ãniña,’ caĩrã atígarãma. Capee átijẽñogarãma, camasã ricaati na catʉ̃goʉsaparore bairo ĩrã. Mʉjãã ũna, Dios cʉ̃ cabesericarã cʉ̃ãrẽ ĩtomigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Merẽ mʉjãã, yʉ cabuerã, tiere mʉjããrẽ yʉ quetibʉjʉ jʉ̃goyetiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bairi mʉjããrẽ ñiña: Noa ũna, ‘Mesías, desierto cayucʉmanopʉ buiaetaupʉ,’ na caĩata, cariape na tʉ̃goeticõãña. Camasã manopʉ yʉ macãrã ápéricõãña. Tunu bairoa aperã, ‘Mesías, ato marĩ caĩñaetopʉ ãcʉ̃mi,’ na caĩata, cariape na tʉ̃goeticõãña. Bairo mee yʉ tunuetagʉ ati yepare. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bʉpo pʉame yabei, muipʉ cʉ̃ cawãmʉatópʉi yabejʉ̃go acʉ́, jõ muipʉ cʉ̃ caruiropʉ yabetuetayami. Torea bairo yʉ, Camasã Jʉ̃gocʉ nemo ati yepapʉre yʉ catunuatí rʉ̃mʉrẽ yʉ baigʉ. Yoaro mee yʉ bauetagʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tunu bairoa noo rupaʉri ãnajẽ cacũñarõ yucaa cʉ̃ã topʉa neñaetagarãma,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ĩ quetibʉjʉ yaparo, atore bairo jãã ĩ nemowĩ tunu: “Camasã roro majũ na cabairi yʉtea capetiro bero, muipʉ ʉmʉrecóo macããcʉ̃ naitĩãcoagʉmi. Ñami macããcʉ̃ cʉ̃ã bauetigʉmi. Ñocõã, ʉmʉrecóore caãnimiatana cʉ̃ã ñacoagarãma. Bairo bairã, ʉmʉrecóo macããna nipetirã yugui ñacoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bairo cabairo bero, apeye ũnie átijẽñorĩqũẽ ʉmʉrecóo macããjẽ Dios cʉ̃ caáti ĩñorĩjẽ buiaetagaro. Bairi ati yepa tocãnacã poa macããna tiere ĩñarã, ‘Merẽ etamajũcoagʉmi Camasã Jʉ̃gocʉ,’ ĩ masĩgarãma. Bairo na pʉame yʉ uwirã otigarãma. Tocãrõã yʉ, Camasã Jʉ̃gocʉ, buseriwo watoapʉ nocãrõ yʉ catutuarije mena, bairi yʉ caasiyabatorije mena yʉ caatóre ĩñajogarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bairo trompeta, pútíricaro cabʉsʉocajoro yua, yʉ ʉ̃mʉa, ángelea majãrẽ nipetiropʉ na yʉ árotigʉ. Bairi ati ʉmʉrecóo macããna nipetiropʉ caãnarẽ na neñogarãma yʉ cabesericarã pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mai, higuera yucʉre mʉjãã masĩña. Ti yucʉ cawãma pũũ cawasoaro ĩñarã, ‘Merẽ cʉ̃ma cõñarõ baiya,’ mʉjãã ĩ masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Torea bairo mʉjããrẽ yʉ caquetibʉjʉrijere bairo cabaietaro ĩñarã, ‘Merẽ Jesús ati yepapʉ nemo cʉ̃ catunuetaparo cõñarõ baiya,’ mʉjãã ĩ masĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cariape mʉjããrẽ ñiña: Mʉjããrẽ yʉ caquetibʉjʉrije baipeticoagaro ti yʉtea macããna na cariaparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tunu bairoa ati ʉmʉrecóo, ati yepa cʉ̃ã yasipeticoagaro. Yʉ yaye quetibʉjʉrique roque petietigaro. Yʉ caĩrõrẽã bairo baimajũcõãgaro. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Bairopʉa ti rʉ̃mʉ, ti hora majũ mʉjãã yʉ caquetibʉjʉrije caetaparore ni jĩcãʉ̃ ũcʉ̃ masĩẽtĩñami. Ʉmʉrecóo macããna ángelea majã cʉ̃ã masĩẽtĩñama. Yʉ, cʉ̃ macʉ̃ cʉ̃ã yʉ masĩẽtĩña. Marĩ Pacʉ Dios jeto masĩñami ti rʉ̃mʉ caetaparore. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé ãnacʉ̃ cʉ̃ caãniyʉteare cabaiyaricarorea bairo baigaro nemo Camasã Jʉ̃gocʉ ati yepapʉre yʉ catunuatí rʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Atore bairo baiyayuparã camasã mai Noé ãnacʉ̃ cʉ̃ caãni yʉteapʉre, ati yepa caruaparo jʉ̃goye: Camasã caroaro ãñuparã. Eti, ʉga, bairi tunu wãmo jiya átiãñuparã, ñe ũno jĩcã wãmeacã cabaiãnipeere tʉ̃goñarĩ mee. Noé, cũmua capairicare cʉ̃ caájããrĩ rʉ̃mʉpʉ baijãnañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bairo ʉseanirõ cabaiãnimiatana pʉame na cayasipeere masĩẽsuparã. Ati yepa oco mena narẽ to cajʉ̃goneruaparo jʉ̃goye masĩẽsuparã. Torea bairo yʉ, Camasã Jʉ̃gocʉ, nemo yʉ catunuetaro dope caĩmasĩã mani rʉ̃mʉ yʉ etagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti rʉ̃mʉ caãno pʉgarã caʉ̃mʉa wesepʉ nigarãma. Bairo pʉgarã nimirãcʉ̃ã, jĩcãʉ̃ cʉ̃ mena macããcʉ̃ jeto neáecogʉmi. Apei cʉ̃ bapa pʉame neáecoetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tunu bairoa pʉgarã rõmia rupa bari trigo wãĩãnigarãma. Bairo pʉgarã rõmia nimirãcʉ̃ã, jĩcãõã, cõ mena macããcõ jeto neáecogomo. Apeo pʉame neáecoetigomo. Mʉjãã pʉame ti rʉ̃mʉ yʉ caetaparore dope bairo mʉjãã ĩ masĩẽtĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Bairi yʉ, mʉjãã Quetiupaʉ, yʉ caetaparore mʉjãã masĩẽtĩgarã. Bairi masacatiya yʉ yarã. Cacãnirãrẽ bairo baieticõãña. Caroaro ãnicoteya. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tunu ati wãme mʉjããrẽ ĩcõñarĩ yʉ caquetibʉjʉrijere tʉ̃gopeoya: Apei wii upaʉ, cʉ̃ ya wii macããjẽrẽ cayajaʉacʉ́re ñami caãno ti hora majũ cʉ̃ caetarore cʉ̃ camasĩata, cãnietibujioʉmi. Cʉ̃ caetarore ĩñaricanʉgõbujioʉmi, jããremi, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Torea bairo yʉ, Camasã Jʉ̃gocʉ, tunu yʉ caetari rʉ̃mʉrẽ jĩcãʉ̃ cayajari majõcʉre bairo yʉ etagʉ ati yepapʉre. ‘Ti rʉ̃mʉ majũ etagʉmi,’ caĩã mani rʉ̃mʉ yʉ etagʉ. Bairi caroaro ãña. Nemo yʉ catunuetaparo jʉ̃goye caroaro mʉjãã ãnicotegarã,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","Ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo jãã ĩnemowĩ tunu: “Jĩcãʉ̃ quetiupaʉ cʉ̃ caápáro jʉ̃goye, ‘Yʉ ʉ̃mʉa aperãrẽ na mʉ qũẽnowã. Ʉgariquere na mʉ batowa,’ qũĩ cũñupʉ̃ cʉ̃ ʉ̃mʉ, cʉ̃ rocajãñurĩ macããcʉ̃rẽ. Bairi cabero tunuetaʉ, cʉ̃ ʉ̃mʉ cʉ̃ caĩrotiricarorea bairo cʉ̃ caápata, caroare cʉ̃ jogʉmi. Bairi ʉseanirĩ nigʉmi cʉ̃ ʉ̃mʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cariape mʉjããrẽ ñiña: Quetiupaʉ pʉame atore bairo ĩgʉmi cʉ̃ ʉ̃mʉrẽ: ‘Nipetirije yʉ cacʉ̃gorijere carotibojaʉ mʉ ãnigʉ.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bairo átato ũnorẽã, cʉ̃ cacũátacʉ pʉame caróʉ cʉ̃ caãmata, ‘Yʉ quetiupaʉ tãmurĩ tunu etaecʉmi,’ ĩrĩ aperã cʉ̃ baparãrẽ roro na átibujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aperã cʉ̃rẽ bairo paabojari majãrẽ roro na átibujioʉmi. Tunu bairoa aperã caetipairã mena ʉga, eticũmu baibujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bairi cabero cʉ̃ quetiupaʉ cañesẽãʉ̃atácʉ pʉame, ‘Ti rʉ̃mʉ etagʉmi,’ cʉ̃ caĩmasĩẽtĩ rʉ̃mʉrẽ etabujioʉmi. Bairo etaʉ yua, cʉ̃ caroticũátacʉ roro cʉ̃ caátiere ĩñabujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bairo ĩña yua, popiye cʉ̃ baio joroque cʉ̃ átibujioʉmi. Cʉ̃ piticõãbujioʉmi, aperã caĩtorã mena cʉ̃ ãmarõ, ĩ. Topʉ bʉtioro otigarãma camasã. Na opire bacarʉpotugarãma, bʉtioro yapapuarã yua,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ĩ quetibʉjʉ yaparo, ape wãme ĩcõñarĩ atore bairo jãã ĩnemowĩ tunu: “Dios cʉ̃ carotimasĩrĩpaʉ pʉame cawãmarã rõmirĩ pʉga wãmo cãnacãõ cawãmojiyaenarẽ bairo niña. Bairi na yaʉ cʉ̃ cawãmojiyari rʉ̃mʉ caãno cʉ̃ bose rʉ̃mʉrẽ ĩñagarã, cʉ̃ pacʉ ya wiipʉ ásúparã, topʉ cʉ̃, cʉ̃ nʉmo caãnipao mena na caetarore coterã. Bairi ñami caãnoi, na cajĩñabusuri rupaare tocãnacãõpʉa jeásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bairo na mena macããna jĩcã wãmo cãnacã rõmirĩ catʉ̃goñajʉ̃goyecʉperã ãñuparã. Aperã na mena macããna catʉ̃goñajʉ̃goyecʉna ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Catʉ̃goñajʉ̃goyecʉperã pʉame na cajĩñawonemopee ʉse ape botella mena jeápeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na bapa pʉame camasĩrã ãnirĩ, ape botella ʉsere jeánemoñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bairo cʉ̃ nʉmo caãnipaore caneiátácʉ pʉame tãmurĩ etaesupʉ. Bairi cawãmarã rõmirĩ narẽ wʉgoa caetaro, cãnicoasuparã tie jãã ĩrĩ mee. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bairo ñami recomacã cacõñarõ majũ jĩcãʉ̃ awajarique mena, ‘¡Jã, ĩñañijate! ¡Atíyami cawãmaʉ, cʉ̃ nʉmo caãnipao mena! ¡Cʉ̃ marĩ jẽnirápáro!’ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bairo cʉ̃ caĩrõ tʉ̃go, cawãmarã rõmirĩ nipetirã wãcãrĩ, na cajĩñaworica rupaare qũẽnojʉ̃goyuparã tunu. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bairo na caqũẽnorõ, catʉ̃goñajʉ̃goyecʉperã pʉame atore bairo na ĩ jẽniñuparã na baparã rõmirĩrẽ: ‘¡Jãã jĩñaworica rupaa ʉse petiro baiya! Jĩña wotutuaetiya. Bairi mʉjãã yaye ʉse petoaca jãã joya,’ na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bairo na caĩrõ tʉ̃go, ‘Mʉjããrẽ jãã jomasĩẽtĩña. Mʉjããrẽ jãã cajoata, jãã yaye etaetibujioro,’ na ĩñuparã. ‘Bairi wapatirájá ʉsere mʉjããrẽ carʉsarijere,’ na ĩñuparã catʉ̃goñajʉ̃goyecʉna, na baparã rõmirĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bairo na caĩrõ tʉ̃go, ‘Jaʉ’ ĩ, acoásúparã ʉsere wapatiráná yua. Bairo na caátó bero, cawãmojiyapaʉ pʉame etayupʉ. Etari yua, catʉ̃goñajʉ̃goyecʉna paijãñurõ caʉsejeatana rõmirĩ pʉame cʉ̃, cʉ̃ nʉmo mena cʉ̃ pacʉ ya wiipʉ jããcoasuparã, ʉgarique jʉ ʉgaráná bose rʉ̃mʉ na caqũẽnoatajere. Bairo na cajããrõ bero, ti wii jope pʉamerẽ biacõãñuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cabero ʉsere cawapatiratana rõmirĩ jopetʉ etarã, atore bairo ĩ piiyuparã: ‘¡Jãã Quetiupaʉ, jãã jope pããña!’ qũĩmiñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bairo na caĩmiatacʉ̃ãrẽ, cawãmojiyaatacʉ pʉame ti jopere pããnemoesupʉ. ‘Cariapea mʉjããrẽ ñiña: Mʉjããrẽ yʉ masĩẽtĩña,’ na ĩñupʉ̃ yua,” ĩcõñarĩ jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bairo ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ: “Mʉjãã, ti rʉ̃mʉ ti hora majũ yʉ catunuetaparore mʉjãã masĩẽtĩgarã. Bairi caroaro masacatiri ãnicoteya. Cacãnirãrẽ bairo baieticõãña,” jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ape wãme ĩcõñarĩ tunu atore bairo jãã ĩ quetibʉjʉnemowĩ Jesús: “Dios cʉ̃ carotimasĩrĩpaʉ pʉame jĩcãʉ̃ quetiupaʉ cʉ̃ cabairiquere bairo niña. Cʉ̃ pʉame ape yepa cayoaropʉ ágʉ jʉ̃goye, cʉ̃ paabojari majãrẽ na piijori, na nuniñupʉ̃ tocãnacãʉ̃rẽã cʉ̃ yaye dinerore, tiere na caqũẽnobojaparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Bairi na mena macããcʉ̃rẽ jĩcã wãmo cãnacã mil moneda tiiri majũ cʉ̃ nuniñupʉ̃. Apei pʉamerẽ pʉga mil moneda tiiri majũ cʉ̃ nuniñupʉ̃. Apei pʉamerẽ jĩcã mil moneda tiiri majũ cʉ̃ nuniñupʉ̃. Na capaarique na cawapatamasĩrõ cãrõ na joyupʉ quetiupaʉ cʉ̃ ʉ̃mʉa tocãnacãʉ̃rẽã. Bairo na nuni yaparo, acoásúpʉ na quetiupaʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bairo cʉ̃ caátó bero, cʉ̃ ʉ̃mʉ jĩcã wãmo cãnacã mil moneda tiiri majũ cʉ̃ cajoatacʉ pʉame, ãmeo nuni wapatari yoaro mee apeye jĩcã wãmo cãnacã mil moneda tiiri majũrẽ wapatanemoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Torea bairo pʉga mil majũ moneda tiiri cʉ̃ cajoatacʉ cʉ̃ã apeye pʉga mil moneda tiiri majũrẽ wapatanemoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bairo caroaro na cawapatanemomiatacʉ̃ãrẽ, jĩcã mil moneda tiiri majũ cʉ̃ cajoatacʉ pʉame wapatanemoesupʉ. Cʉ̃ quetiupaʉ dinerore cʉ̃ canunirõ bero, acoásúpʉ. Á yua, yepa pupeapʉ ope yesea, cʉ̃ quetiupaʉ dinerore topʉ yacũcõãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bairo cayoato bero, paabojari majã quetiupaʉ pʉame tunuetayupʉ tunu cʉ̃ ya yepapʉ. Bairo tunuetari bero, cʉ̃ paabojari majãrẽ na piijoyupʉ, dinerore cʉ̃ canunicũrĩcãrãrẽ. ‘¿Nocãrõ majũ na wapataupari tocãnacãʉ̃pʉa?’ ĩ, na piijoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bairi cʉ̃ paabojari majõcʉ jĩcã wãmo cãnacã mil moneda tiiri majũ cʉ̃ cajoricʉ pʉame cʉ̃tʉ etajʉ̃goyupʉ. Eta yua, atore bairo qũĩñupʉ̃: ‘Yʉ quetiupaʉ, mʉ dinerore yʉ mʉ cacũrĩqũẽ mena yʉ wapatanemoapʉ. Mʉ pʉame jĩcã wãmo cãnacã mil moneda tiiri majũrẽ yʉ mʉ cacũmiatacʉ̃ãrẽ, tunu jĩcã wãmo cãnacã mil moneda tiirire mʉ yʉ tunuo buipeogʉ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bairo cʉ̃ caĩrõ, cʉ̃ quetiupaʉ pʉame atore bairo qũĩ yʉyupʉ: ‘Ñumajũcõãña. Cañuʉ mʉ ãniña mʉa paabojari majõcʉ. Bairi caroaro tʉ̃goñarĩqũẽ yeri pũna mena apeye petoaca caãnie ũnierẽ mʉ caĩñarĩcãnʉgõmasĩrõ jʉ̃gori, paijãñurõ caãnie ũnierẽ caĩñarĩcãnʉgõpaʉ mʉrẽ yʉ cũña. Bairi yʉ ya wiipʉ jããʉ̃ asá. Yʉ mena ʉseanirĩ ãña,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Cabero cʉ̃ paabojari majõcʉ apei pʉga mil moneda tiiri majũrẽ cʉ̃ cajoricʉ cʉ̃ã etari, atore bairo qũĩñupʉ̃: ‘Yʉ quetiupaʉ, mʉ dinerore yʉ mʉ cacũrĩqũẽ mena yʉ wapatanemoapʉ. Mʉ pʉame pʉga mil moneda tiiri majũrẽ yʉ mʉ cacũmiatacʉ̃ãrẽ, tunu pʉga mil moneda tiirire mʉ yʉ tunuo buipeogʉ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bairo cʉ̃ caĩrõ, cʉ̃ quetiupaʉ pʉame atore bairo qũĩ yʉyupʉ: ‘Ñumajũcõãña. Cañuʉ mʉ ãniña mʉa paabojari majõcʉ. Bairi caroaro tʉ̃goñarĩqũẽ yeri pũna mena apeye petoaca caãnie ũnierẽ mʉ caĩñarĩcãnʉgõmasĩrõ jʉ̃gori, paijãñurõ caãnie ũnierẽ caĩñarĩcãnʉgõpaʉ mʉrẽ yʉ cũña. Bairi yʉ ya wiipʉ jããʉ̃ asá mʉ cʉ̃ã. Yʉ mena ʉseanirĩ ãña,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Bairo na caátimiatacʉ̃ãrẽ, apei cʉ̃ paabojari majõcʉ jĩcã mil moneda tiiri majũrẽ cʉ̃ cajoricʉ pʉame yua cʉ̃tʉ etari, atore bairo qũĩñupʉ̃: ‘Yʉ quetiupaʉ, mʉa, tutuaro mena caroti mʉ ãniña. Caoteecʉ nimicʉ̃ã, aperã na caoteriquepʉre mʉ jenucũña. Tunu bairoa aperã yayere na mʉ ẽmanucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bairo caácʉ mʉ caãnierẽ uwiri caroaro yʉ qũẽnocũwʉ̃ mʉ dinerore. Yepapʉ yeseari yʉ yacũwʉ̃ tiere, yasire, ĩ. Ãmerẽ yua, mʉ yʉ tunuogʉ tie mʉ dinero, yʉ mʉ canunimirĩqũẽrẽ.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ quetiupaʉ pʉame qũĩñupʉ̃: ‘Mʉa, paabojari majõcʉ, cañuecʉ̃ cateeyepai majũ mʉ ãniña. ¿Atore bairo yʉre mi tʉ̃goñanucũñati: “Caoteecʉ nimicʉ̃ã, aperã na caoteriquepʉre jenucũñami. Tunu bairoa aperã yayere na ẽmanucũñami,” yʉre mi tʉ̃goñanucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bairo yʉre caĩtʉ̃goñaʉ nimicʉ̃ã, ¿nopẽĩ yʉ dinerore bancopʉ mʉ cũẽtĩ? Bairo cũrĩ, tie dinerore mʉ cawasorije wapa mʉ wapatanemobujioricʉ. Tie mena yʉ mʉ tunuobujioatacʉ, yʉ ya wii yʉ catunuetaro,’ qũĩ tutiyupʉ quetiupaʉ cʉ̃ ʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bairo qũĩ yaparori, atore bairo na ĩñupʉ̃ aperã cʉ̃tʉ caãnarẽ: ‘Dinero, cʉ̃ cacʉ̃gorijere ẽmarĩ, apei pʉga wãmo cãnacã mil majũ moneda tiirire cacʉ̃goʉre cʉ̃ joya.’ ");
INSERT INTO cbcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Torea bairo jeto yʉ átirotigʉ camasãrẽ. Noa ũna caroaro tʉ̃goñarĩqũẽ yeri pũna mena yʉ cajorijere na caĩñaʉsaata, paijãñurõ na yʉ jonemogʉ tunu. Aperã caroaro tʉ̃goñarĩqũẽ yeri pũna mena yʉ cajorijere na caĩñaʉsaeticõãta, na cacʉ̃gomirĩjẽ cʉ̃ãrẽ yʉ ẽmapeyocõãgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bairi ãni, yʉre capaabojamasĩẽcʉ̃rẽ macãpʉ cʉ̃ rocawiyojoya canaitĩãrõpʉ. Topʉre camasã otigarãma. Na opire bacarʉpotugarãma, bʉtioro yapapuarã yua,” ĩcõñarĩ jãã quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ĩ yaparo, atore bairo jãã ĩnemowĩ Jesús tunu: “Camasã Jʉ̃gocʉ, ati yepapʉ nemo yʉ catunuetari rʉ̃mʉrẽ caasiyarije mena yʉ atígʉ. Tunu bairoa yʉ yarã ángelea majã mena yʉ atígʉ. Bairo atí yua, trono quetiupaʉ cʉ̃ caruiro caroaro majũpʉ yʉ ruigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bairo yʉ caruiro, ati ʉmʉrecóo macããna, tocãnacã poa macããna yʉ riape neñaetagarãma. Bairo na caneñaetaro ĩña, na ñiñabesegʉ. Jĩcãʉ̃ ovejare cacotei cʉ̃ yarã nurĩcãrã oveja, bairi cabras na caĩrã cʉ̃ãrẽ ricaati jeto cʉ̃ cabesecũrõrẽ bairo camasã nipetirore na ñiñabesegʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bairi yʉ yarã, ovejare bairo caãna pʉamerẽ yʉtʉ cariape nʉgõãrẽ na yʉ nucũrotigʉ. Aperã yʉ camasĩẽna, cabrare bairo caãna roquere yʉtʉ caãcõ nʉgõãrẽ na yʉ nucũrotigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Bairo áticõã, yʉ, Quetiupaʉ Rey, bairo ñigʉ yʉ caruiro cariape nʉgõã caãnarẽ: ‘Yʉ yarã, yʉ Pacʉ caroaro ʉseanirĩqũẽrẽ cʉ̃ cajoricarã ãnirĩ, tiaya. Dios cʉ̃ carotimasĩrĩpaʉre jããrã asá, ati ʉmʉrecóo caãniparo jʉ̃goye mʉjãã caãnipeere cʉ̃ caĩjʉ̃goyeticũrĩcãrõrẽã bairo. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ pʉame yʉ caqueyaro, yʉ mʉjãã ʉgarotiwʉ. Tunu bairoa yʉ cañemejipiro, yʉ mʉjãã etirique nuniwʉ̃. Tunu bairoa canucũñesẽãrĩ majõcʉre bairo yʉ cabainucũñesẽãrõ, “Jããtʉ ãña,” yʉ mʉjãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tunu bairoa yʉ cajutii cʉ̃goeto, yʉ mʉjãã jutii nuniwʉ̃. Tunu yʉ cariaro, mʉjãã pʉame yʉtʉ etari caroaro yʉ mʉjãã jʉátinemowʉ̃. Torea bairo yʉ mʉjãã ápʉ preso jorica wii yʉ caãno cʉ̃ãrẽ,’ na ñigʉ nipetirã yʉ caruiro cariape nʉgõã caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Bairo yʉ caĩrõ tʉ̃go, atore bairo ñi jẽniñagarãma na, carorije wapa cacʉ̃goena yʉ caĩñarã pʉame: ‘Jãã Quetiupaʉ, ¿dipaʉ ũno mʉ caqueyaro, mʉrẽ jãã ʉgarotiri? Tunu, ¿dipaʉ ũno mʉ cañemejipiro, mʉrẽ etirique jãã nunirĩ? ");
INSERT INTO cbcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tunu, ¿dipaʉ ũno canucũñesẽãrĩ majõcʉre bairo mʉ cabainucũñesẽãrõ, “Jããtʉ ãña,” mʉrẽ jãã ĩrĩ? Tunu, ¿dipaʉ ũno mʉ cajutii cʉ̃goeto, mʉrẽ jutii jãã nunirĩ? ");
INSERT INTO cbcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tunu, ¿dipaʉ ũno majũ mʉ cariaro, o preso jorica wii mʉ caãno, mʉtʉ etari mʉrẽ jãã jʉátinemoñuparĩ?’ ñi jẽniñagarãma yʉtʉ cariape nʉgõãrẽ caãna pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo ñigʉ yʉ, Quetiupaʉ Rey: ‘Cariape mʉjããrẽ niña: Yʉ yarã cabʉgoro macããna cʉ̃ãrẽ caroaro na mʉjãã cajʉátinemorõĩ, yʉpʉre jʉátinemorã mʉjãã ápʉ,’ ñigʉ yʉtʉ cariape nʉgõã caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ĩ yaparo, yʉ, Quetiupaʉ Rey, ñinemogʉ tunu caãcõ nʉgõã pʉame caãnarẽ: ‘Mʉjãã, popiye mʉjãã baio joroque mʉjãã átigʉmi Dios cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽã bairo. Bairi ánája mʉjãã caʉ̃petietopʉ. Wãtĩ, cʉ̃ yarã ángelea cañuena mena Dios narẽ cʉ̃ cacũjʉ̃goricaropʉ ánája. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ pʉame yʉ caqueyaro yʉ mʉjãã ʉgarotiepʉ. Tunu bairoa yʉ cañemejipiro, yʉ mʉjãã etirique nuniepʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tunu bairoa canucũñesẽãrĩ majõcʉre bairo yʉ cabainucũñesẽãrõ, “Jããtʉ ãña,” yʉ mʉjãã ĩẽpʉ̃. Tunu bairoa yʉ cajutii cʉ̃goeto, yʉ mʉjãã jutii nuniepʉ̃. Tunu yʉ cariaro, bairi preso jorica wiipʉ yʉ caãno cʉ̃ãrẽ, yʉtʉ etari caroaro yʉ mʉjãã jʉátinemoepʉ,’ ñigʉ yʉtʉ caãcõ nʉgõã caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bairo yʉ caĩrõ tʉ̃go, atore bairo ñi jẽniñagarãma: ‘Jãã Quetiupaʉ, ¿dipaʉ ũno mʉ caqueyaro, o mʉ cañemejipiro, o jãã ya macãpʉ mʉ caetaro, o mʉ cariaro, o preso jorica wiipʉ mʉ caãno jãã jʉátinemoesuparĩ? Bairo mʉ cabairo jãã ĩñaepʉ̃,’ ñigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bairo na caĩrõ, atore bairo na ñigʉ, yʉ, Quetiupaʉ Rey: ‘Cariape mʉjããrẽ ñiña: Yʉ yarã cabʉgoro macããna cʉ̃ãrẽ na mʉjãã cajʉátinemoetoi, yʉpʉre jʉátinemoena mʉjãã ápʉ,’ na ñigʉ yʉtʉ caãcõ nʉgõã caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bairi na pʉame popiye bairique capetietopʉ ágarãma yua. Carorije cacʉ̃goenarẽ bairo yʉ caĩñarã pʉame yʉ mena ʉseanirĩ ãnicõã ninucũgarãma tocãnacã rʉ̃mʉa,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bairo nipetirije ĩ quetibʉjʉ yaparori, atore bairo cʉ̃ cabuerãrẽ jãã ĩnemowĩ tunu: ");
INSERT INTO cbcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Merẽ mʉjãã masĩña. Pascua bose rʉ̃mʉ etagaro baiya. Pʉga rʉ̃mʉa rʉsaya. Tocãrõã yʉ, Camasã Jʉ̃gocʉre, yʉ nunirocagarãma, yucʉpãĩpʉ aperã yʉ na capapuaturocaparore bairo ĩrã —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tipaʉ caãno, sacerdote majã quetiuparã, bairi cabʉtoa camasĩrã cʉ̃ã Caifás cawãmecʉcʉ ya wiire neñañuparã. Caifás pʉame sacerdote majã quetiupaʉ, sumo sacerdote majũ ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bairo neñarã, atore bairo ãmeo ĩñuparã na majũ: “¿Dope bairo camasã na caĩñaeto Jesure gobierno cʉ̃ ñerotio joroque marĩ áticʉti?” ãmeo ĩñuparã ĩtorique mena, Jesús cʉ̃ cariarore borã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Bairãpʉa, Pascua caãno cʉ̃ marĩ ñerotimasĩẽna, camasã roro awajari marĩ tutirema, ĩrã —ĩ tʉ̃goñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús pʉame tipaʉ caãno Betania macãpʉ ãmi, carupaʉ boamirĩcʉ̃ Simón cawãmecʉcʉ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bairo ti wii cʉ̃ caãno, jĩcãõ carõmio cʉ̃tʉ etawõ. Cõ pʉame caroarʉacapʉ jiraro cajʉtiñurĩjẽ pairo cawapacʉtiere neamó. Bairo Jesús mesapʉ cʉ̃ caruiro, carõmio pʉame tie caroa cajʉtiñurĩjẽrẽ cʉ̃ rʉpoapʉ piopeowõ, Jesure bʉtioro nʉcʉ̃bʉgoo. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jãã, cʉ̃ cabuerã pʉame bairo cõ caáto ĩñarã, cõ mena jãã asiajãñuwʉ̃. —¿Nopẽĩõ pairo cawapacʉtiere bairo cõ átireyati? ");
INSERT INTO cbcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Apei, tiere caboʉre cõ canuniata, tie wapa pairo dinerore jeri, aperã cabopacarãrẽ na jʉátinemo masĩbujiomo. Ãmerẽ tie yasicoaya cõ cawapatabujioataje yua —jãã ãmeo ĩwʉ̃ jãã majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús pʉame tʉ̃gowĩ jãã caãmeoĩrĩjẽrẽ. Bairi atore bairo jãã ĩwĩ: —¿Nopẽĩrã patowãcõrõ cõrẽ mʉjãã bʉsʉpaiyati? Atio carõmio bairo yʉre cõ caátie ñujãñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cabopacarã nicõãnucũgarãma mʉjãã watoare. Yʉ pʉame roque yoaro yʉ ãmerĩgʉ ati yepapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bairo cajʉtiñurĩjẽrẽ yʉ rʉpoare cõ capiopeoro jʉ̃gori yʉ rupaʉre caroaro qũẽnoñamo, yʉ rupaʉri ãnajẽrẽ na carocaparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cariape mʉjããrẽ ñiña: Ati ʉmʉrecóo nipetiropʉ, atie yʉ yaye queti, camasãrẽ Dios cʉ̃ canetõõrĩjẽrẽ na caquetibʉjʉropʉ atio carõmio bairo yʉre cõ caátie cʉ̃ãrẽ quetibʉjʉgarãma. Bairi cõ caátiere masĩcõã ninucũgarãma camasã tocãnacã rʉ̃mʉa —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bairi yua, jãã, Jesús cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ mena macããcʉ̃ jĩcãʉ̃ Judas Iscariote cawãmecʉcʉ na ĩñaʉ ásúpi quetiuparã sacerdote majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na tʉpʉ etari bairo na ĩñupʉ̃: —Jesure, mʉjãã yʉ ñerotigʉ, cʉ̃ mʉjãã capajĩãmasĩparore bairo. Bairi, ¿tie wapa nocãnacã moneda tiirire yʉre mʉjãã nunibujiocʉti tie wapa? —na ĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, treinta plata moneda tiiri majũ cõñarĩ, Judare cʉ̃ nuniñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tipaʉ bero Judas pʉame dipaʉ ũno dope bairo camasã mano macãjʉ̃goyupʉ, Jesure cʉ̃ ñerotigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bairi yua, Pascua bose rʉ̃mʉ, caãnijʉ̃gori rʉ̃mʉ, levadura pan cawauarije caasuamanierẽ judío majã na caʉgari rʉ̃mʉ etawʉ. Bairo ti rʉ̃mʉ caetaro ĩña, jãã, Jesús cʉ̃ cabuerã pʉame, cʉ̃tʉ etari, atore bairo cʉ̃rẽ jãã ĩ jẽniñawʉ̃: —¿Noopʉ marĩ caʉgapeere jãã caqũẽnoyuro mʉ boyati? ");
INSERT INTO cbcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bairo jãã caĩjẽniñarõ, atore bairo jãã ĩwĩ: —Ánája mʉjãã Jerusalẽpʉ. Bairo ti macãrẽ etarã, mʉjãã bócaetagarã jĩcãʉ̃, wii upaʉre. Bairo cʉ̃rẽ bócaeta yua, atore bairo cʉ̃ mʉjãã ĩgarã: “Cabuei bairo ĩñami: ‘Yʉ Pacʉ yʉre cʉ̃ cacũrĩcãrõ merẽ etaro baiya. Bairi mʉ ya wiipʉ yʉ atígʉ, yʉ cabuerã mena Pascua bose rʉ̃mʉrẽ netõgʉ,’ ĩñami marĩrẽ cabuei,” cʉ̃ mʉjãã ĩgarã —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bairo cʉ̃ caĩrõ tʉ̃go, jãã, Jesús cʉ̃ cabuerã, cʉ̃ caĩrõrẽã bairo jãã ápʉ. Bairi ti wiipʉ jãã qũẽnoyuwʉ Pascua rʉ̃mʉ jãã caʉgapeere. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cabero canaiorĩpaʉ caetaro, Jesús pʉame ti wii jããetari mesapʉ ruiwĩ jãã, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ cʉ̃ cabuerã mena. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bairo jãã caʉgaruiripaʉ, atore bairo jãã ĩwĩ Jesús: —Cariape mʉjããrẽ ñiña: Mʉjãã mena macããcʉ̃ jĩcãʉ̃ roro yʉre ĩ bʉsʉjãbuitirocagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bairo cʉ̃ caĩrõ tʉ̃go, bʉtioro jãã tʉ̃goña yapapuawʉ. Bairo bairã, apei, apei, Jesure bairo jãã ĩ jẽniñajʉ̃gowʉ̃: —¿Yʉ mee, yʉ ãnicõãẽtĩmicʉti mʉrẽ caĩbʉsʉjãbuitiri majõcʉ? —jãã, tocãnacãʉ̃pʉa jãã ĩ jẽniñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bairo jãã caĩrõ, bairo jãã ĩwĩ Jesús: —Ãni, ãmerẽ yʉ mena atirʉre cʉ̃ pããrẽ cayosene ʉgaʉ pʉame niñami yʉre roro caĩbʉsʉjãbuitirocapaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Torecʉna, yʉ, Camasã Jʉ̃gocʉ, profeta majã yʉ cabaipeere na caquetibʉjʉcũrĩcãrõrẽã bairo yʉ baigʉ. Cabaimiatacʉ̃ãrẽ, ¡yʉre caĩbʉsʉjãbuitirocapaʉre cʉ̃ carorije wapa pairo nigaro! Bairi cʉ̃ cabuiaeticõãta roque, ñubujioricaro —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bairo cʉ̃ caĩrõ tʉ̃go, Judas, Jesure caĩbʉsʉjã buitirocaricʉ ãnacʉ̃ pʉame atore bairo qũĩwĩ Jesure: —Yʉre cabuei, ¿yʉ mee yʉ ãnicʉti mʉrẽ caĩbʉsʉjãbuitirocapaʉ? Bairo cʉ̃ caĩrõ: —Mʉ, caĩrõrẽã bairo mʉ baiya —qũĩwĩ Jesús Judare. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bairo cʉ̃ caĩrõ bero, jãã caʉgatoye, Jesús pʉame cʉ̃ wãmo mena pããrẽ nerĩ, “Dios mʉ ñujãñuña jãã mena,” ĩ yaparo, carecomacã peenerĩ, jãã, cʉ̃ cabuerãrẽ atore bairo ĩrĩ jãã batowĩ: —Atie pan, yʉ rupaʉ niña. Tiere ʉgaya —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bairo ĩ yaparo, cʉ̃ wãmo mena copa etiricarʉre nerĩ, “Dios, mʉ ñujãñuña jãã mena,” qũĩ yaparo, atore bairo ĩrĩ ti copare jãã nuniwĩ: —Mʉjãã tocãnacãʉ̃ã nipetiro atirʉ macããjẽ ʉse ocore etiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Atie ʉse oco pʉame yʉ rií niña. Camasã capããrãrẽ na netõõgʉ, yʉ riacoagʉ. Bairo yʉ cariápee jʉ̃gori cawãma wãme camasãrẽ Dios cʉ̃ caátibojacũrĩqũẽ etacoaya. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cariape mʉjããrẽ ñiña: Ãmea mʉjãã mena ʉse ocore pʉgani yʉ etinemoetigʉ yʉ Pacʉ cʉ̃ carotimasĩrĩpaʉ tunu caetaro marĩ caetinemoparo jʉ̃goye —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ĩ yaparo, salmos basarique mena Diore jãã basapeowʉ. Basapeo yaparo yua, jãã acoápʉ́ Olivo cawãmecʉti buropʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bairo jãã caátó, atore bairo jãã ĩwĩ Jesús: —Ãme ñami mʉjãã nipetiro aperãrẽ uwirã, yʉ mʉjãã aweyocoagarã. Mʉjãã cabaipeere ĩ quetibʉjʉ jʉ̃goyeticũñañupã profeta majã Dios yaye woaturica tutipʉ: ‘Ovejare cacoteire camasã na capajĩãrõ yʉ ẽñotaetigʉ. Bairo cʉ̃rẽ na capajĩãrõ bero cʉ̃ yarã oveja pʉame ábatapeticoagarãma,’ ĩ quetibʉjʉ jʉ̃goyeticũñañupã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tunu bairoa apeyera, yʉ pʉame cariacoatacʉ nimicʉ̃ã, yʉ caticoagʉ tunu. Bairo cati yua, mʉjãã jʉ̃goye Galilea yepapʉ yʉ ágʉ —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bairo cʉ̃ caĩrõ bero, Pedro pʉame bairo qũĩwĩ: —Ãnoa yʉ mena macããna nipetiro mʉrẽ na caaweyocoamiatacʉ̃ãrẽ, yʉ pʉame roque di rʉ̃mʉ ũno mʉ yʉ aweyoetigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bairo cʉ̃ caĩrõ, bairo qũĩwĩ Jesús: —Pedro, cariape mʉrẽ ñiña: Ãme ñami ãbocʉ cʉ̃ capiiparo jʉ̃goye itiani, “Cʉ̃ yʉ masĩẽtĩña Jesure,” yʉ mitogʉ —qũĩwĩ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro pʉame bairo qũĩwĩ: —Mʉ mena yʉre na capajĩãrocagamiatacʉ̃ãrẽ, “Cʉ̃ yʉ masĩẽtĩña Jesure,” ñitoetimajũcõãgʉ —qũĩwĩ Pedro Jesure. Bairo cʉ̃ caĩrõ tʉ̃go, jãã, Jesús cʉ̃ cabuerã cʉ̃ã nipetiro, bairo jeto cʉ̃ jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bairi Jesús mena jãã etawʉ Getsemaní cawãmecʉtopʉ. Bairo jãã caetaro, bairo jãã ĩwĩ Jesús: —Ato ruicoteya mai. Jõ jãñurõpʉ Diore cʉ̃ jẽnigʉ yʉ átiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ĩ yaparo, Pedro, bairi pʉgarã Zebedeo pũnaa mena jõjãñurõpʉ na neámí Jesús. Bairo ácʉ́, bʉtioro tʉ̃goña yapapuayupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bairi atore bairo na ĩñupʉ̃ Pedrojããrẽ: —Riaʉre bairo yʉ tʉ̃goña yapapuaya. Mʉjãã pʉame cãniena, atoa yʉ mʉjãã cotewa. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ĩ yaparo, na jʉ̃goye jãñurõpʉ ánemoñupʉ̃ Jesús. Ánemo yua, cʉ̃ rʉpopaturi mena etanumurĩ yepapʉ cʉ̃ riapére mucũmuáti bairo Diore qũĩ jẽniñupʉ̃: “Caacʉ, mʉ cabooata, atie roro yʉ canetõpeere yʉ mʉ netõõbojagʉ. Bairopʉa, yʉ caborore bairo to baieticõãto. Mʉ caborore bairo roque to baiáto,” ĩ jẽniñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cabero tunu ásúpʉ Jesús, Pedrojãã na caãnopʉ. Bairo cacãnirãpʉ̃rẽ na etayupʉ. Bairi qũĩñupʉ̃ Jesús Pedrore: —¿Jĩcã hora ũnoacã cãniena, yʉ mʉjãã cotemasĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cãniena, wãmʉnʉcãrĩ Diore cʉ̃ jẽniña, wãtĩ mʉjããrẽ cʉ̃ caĩtoetiparore bairo ĩrã. Bairo yʉ mʉjãã caaweyocoagaetimiatacʉ̃ãrẽ, mʉjãã rupaʉ pʉame tutuaetiya —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ĩ yaparo, ásúpʉ tunu Jesús, Diore cʉ̃ jẽninemoʉ ácʉ́. Á yua, bairo qũĩ jẽninemoñupʉ̃ tunu: “Caacʉ, roro yʉ cabaipeere mʉ caẽñotagaeticõãta, bairoa to baiáto. Yʉ caborore bairo to baieticõãto. Mʉ caborore bairo roque to baiáto,” ĩ jẽniñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ĩ jẽni yaparo, tunucoásúpʉ Jesús Pedrojãã tʉpʉ. Bairo cacãnirãpʉ̃rẽ na etayupʉ tunu. Na pʉame wʉgoa cʉtiri ĩñapãã masĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bairo na cabairo ĩña yua, ásúpʉ Jesús tunu Diore cʉ̃ jẽniácʉ, cʉ̃rẽ cʉ̃ cajẽniatatore bairo. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bairo jẽni yaparo, tunucoásúpʉ Jesús Pedrojãã na caãnopʉ. Bairo natʉ eta, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã mai cacãnirãrẽ bairo mʉjãã nicõãnucũñati? Yʉ, Camasã Jʉ̃gocʉre, carorã carorije cawapa cʉ̃gorãrẽ yʉ na canunirocaripaʉ etaya merẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bairi, wãmʉnʉcãña. ¡Jito! Yʉre caĩbʉsʉjãbuitirocari majõcʉ pʉame marĩtʉ atíyami merẽ —na ĩñupʉ̃ Jesús Pedrojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bairo cʉ̃ caĩãno, Judas, jãã, Jesús cʉ̃ cabuerã mena macããcʉ̃ jĩcãʉ̃ caãninucũmiatacʉ pʉame etawĩ. Cʉ̃ mena capããrã camasã cʉ̃ã etawã. Na pʉame jarericapãĩrĩ, bairi yucʉ rʉcaari cʉ̃ãrẽ cʉ̃gori etawã. Sacerdote majã quetiuparã, bairi aperã judío majã cabʉtoa camasĩrã na cajoatana ãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mai, na caetaparo jʉ̃goye, Judas pʉame atore bairo na ĩñupʉ̃ Jesure cañeranárẽ: “Cʉ̃ wasopanarẽ ũpũrĩ yʉ cajẽnipaʉ pʉame Jesús nigʉmi. Bairo mʉjãã pʉame cʉ̃ yʉ caáto ĩñarã, cʉ̃rẽ mʉjãã ñegarã,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bairo Judas Jesutʉ etari, atore bairo qũĩ jẽniwĩ: —¡Cabuei, mʉ ãnimiñati! Bairo caroaro mena qũĩtori cʉ̃ ũpũwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Bairo cʉ̃ caáto, Jesús pʉame atore bairo qũĩwĩ: —Judas, yʉ bapa caãnimiatacʉ, mʉ caátigarijere jicoquei ása. Bairo cʉ̃ caĩrõ, Judas mena caetari majã pʉame Jesure etari, cʉ̃ ñecoámá. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mai, bairo Jesure na caáto ĩñarĩ, jĩcãʉ̃ jãã mena macããcʉ̃ pʉame sacerdote majã quetiupaʉ ʉ̃mʉrẽ cʉ̃ ãmorõrẽ patañocõã jowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Bairo cʉ̃ caáto ĩña, atore bairo qũĩwĩ Jesús: —Bairo ápericõãña. Noa ũna nipetirã jarericapãĩrĩ mena caãmeoqũẽnucũrã, aperã ya jarericapãĩrĩ mena pajĩãecori riacoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Dios yʉre cʉ̃ cajʉátinemobujiopeere mʉ tʉ̃goñaẽtĩñati? Yʉ Pacʉre cʉ̃ yʉ cajẽniata, ángelea majã pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã poa ejericito poa majũrẽ yʉ jobujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Baipʉa, bairo cʉ̃ caáto, yʉ boetiya. Cʉ̃ cajoata, nipetiro baipetietibujioro Dios bʉsʉrica tutipʉ profeta majã na caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo —qũĩwĩ Jesús caʉ̃mʉrẽ cacãmii tumiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ĩ yaparo, bairo ĩnemowĩ Jesús cʉ̃rẽ cañerĩ majãrẽ: —¿Nopẽĩrã cajerutiri majõcʉ yʉ caãnorẽ bairo jarericapãĩrĩ mena, bairi yucʉ rʉcaari mena yʉ mʉjãã ñerã atíati? Tocãnacã rʉ̃mʉa mʉjãã watoa yʉ ãninucũãpʉ̃ templo wiipʉre. Bairo yʉ caãnimiatacʉ̃ãrẽ, ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ yʉ ñeemi. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bairopʉa, nipetiro yʉ mʉjãã caátie Dios bʉsʉrica tutipʉ profeta majã na caĩquetibʉjʉ jʉ̃goyeticũrĩqũẽrẽ bairo baietaro baiya —na ĩwĩ. Tipaʉ caãno yua, jãã, Jesús cʉ̃ cabuerã uwirã, Jesure jãã rutiweyo peticoápʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bairi Jesure cañerĩ majã pʉame Caifás, sacerdote majã quetiupaʉ majũ ya wiipʉ cʉ̃ neásúparã. Mai, ti wiire merẽ ãñuparã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi aperã judío majã cabʉtoa camasĩrã cʉ̃ã, ti ñamirẽ caneñaetaatana. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bairi Jesure ti wiipʉ na caneátó, Pedro pʉame yoajãñurõpʉa na ĩñaʉsayupʉ. Bairo ti wiire na cajããetaro bero, Pedro cʉ̃ã etayupʉ ti wii macã yepa majũpʉ. Bairi ti yepa ẽñotaricarore jããetari, templo coteri majã guardia mena ruiyupʉ, “¿Dope bairo Jesure cʉ̃ na áti yaparo jorãati?” ĩgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bairi ti wii pupeapʉ sacerdote majã quetiuparã, bairi nipetiro Junta Suprema macããna mena Jesús cʉ̃ cayasiro boyuparã. Bairi, “¿di wãme carorije cʉ̃ ásupari?” ãmeo ĩ macãñuparã na majũ. “¿Dope bairo cʉ̃ caátaje wapa cʉ̃ marĩ pajĩãrotiyati?” ");
INSERT INTO cbcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bairo ãmeo ĩmacãmirãcʉ̃ã, dope bairo cʉ̃ caátaje wapa cʉ̃ na capajĩãrotimasĩpeere bócaesuparã. Camasã capããrã Jesús cʉ̃ caĩrĩqũẽrẽ na caĩtonetõmiatacʉ̃ãrẽ, dope bairo cʉ̃ caĩrĩqũẽ wapa cʉ̃ na capajĩãrotimasĩpeere bócaesuparã. Cabero aperã caĩtorã pʉgarã atore bairo na ĩñuparã: ");
INSERT INTO cbcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Ãni Jesús, cʉ̃ caĩrĩqũẽrẽ jãã tʉ̃gowʉ. Bairo ĩwĩ: “Dios ya wii templore yʉ rocacõãgʉ. Bairo áti yaparori, itia rʉ̃mʉ bero yʉ pʉame yʉ wasoanʉcõgʉ tunu ape wii yʉ camasĩrĩjẽ mena,” ĩwĩ Jesús —qũĩ bʉsʉjãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bairo na caĩquetibʉjʉro tʉ̃go, sumo sacerdote pʉame wãmʉnʉcãrĩ atore bairo qũĩñupʉ̃ Jesure: —¿Mʉna mee mʉrẽ na ĩñati? Roro mʉrẽ na caĩbʉsʉmiatacʉ̃ãrẽ, ¿nopẽĩ narẽ mʉ yʉetiyati? —qũĩ jẽniñañupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús pʉame cʉ̃ yʉeticõãñupʉ̃. Bairo cʉ̃ cayʉeto ĩña, atore bairo qũĩnemoñupʉ̃ tunu sumo sacerdote Jesure: —Dios, tocãnacã rʉ̃mʉ caãnicõãninucũʉ̃, cʉ̃ carotiro mena mʉ yʉ quetibʉjʉ rotiya jããrẽ: ¿Cariapea, Mesías, Dios macʉ̃ majũ mʉ ãniñati? ");
INSERT INTO cbcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Bairo cʉ̃ caĩrõ, atore bairo qũĩñupʉ̃ Jesús: —Mʉ caĩrõrẽã bairo cʉ̃ã yʉ ãniña. Tunu bairoa ãme beroaca Nipetiro Carotimasĩ tʉpʉ cariape nʉgõãrẽ yʉ caruiro mʉjãã ĩñamʉgõjogarã. Bairi tunu oco poa buseri watoapʉ ati yepare acʉ́ yʉ caruiató cʉ̃ãrẽ mʉjãã ĩñamʉgõjogarã —qũĩñupʉ̃ Jesús sumo sacerdotere. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bairo cʉ̃ caĩrõ tʉ̃go, sumo sacerdote pʉame cʉ̃ yaro jutirore tʉ̃gãworocacõã joyupʉ. Bairo átiri: —¡Roro majũ ĩcõãñami Diore, bairo cʉ̃ caĩata! Roro cʉ̃ caĩrĩqũẽrẽ marĩrẽ caquetibʉjʉnemoparãrẽ na marĩ macãnemoetigarã. Merẽ marĩ majũpʉa marĩ tʉ̃go yaparoya roro cʉ̃ caĩrĩjẽrẽ —ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bairi, “¿Dope bairo cʉ̃ marĩ ánaati?” na ĩñupʉ̃ sumo sacerdote cʉ̃ ya wiire caneñaatíatanarẽ. Bairo cʉ̃ caĩrõ, to macããna pʉame bairo ĩñuparã: —Roro cʉ̃ caĩrĩjẽ wapa cʉ̃ marĩ pajĩã rocarotigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ĩ yaparo, Jesús riapépʉ cʉ̃ ʉco eyotuyuparã. Bairi tunu cʉ̃ bapeyuparã. Aperã tunu cʉ̃ caapeere jutii asero mena jiyabiatori, cʉ̃ riapére cʉ̃ payuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bairo átiri, qũĩ jẽniñañuparã: —Mʉ, Dios cʉ̃ cajoʉ ãnirĩ mʉ camasĩrĩjẽ jʉ̃gori jãã quetibʉjʉya: ¿Noa ãmerẽ mʉrẽ na paayati? —qũĩ epeyuparã to macããna Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bairo na cabaiãno, Pedro pʉame ti wii macã yepa majũrẽ ruiyupʉ. Bairo cʉ̃ caruiro, jĩcãõ paabojari majõco pʉame cʉ̃tʉ etari bairo qũĩñupõ: —Mʉ cʉ̃ã, Jesús, Galilea yepa macããcʉ̃ mena mʉ áñesẽãwʉ̃. Cʉ̃ã mʉ ãcʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro pʉame ĩtoʉ, nipetiro to macããna na catʉ̃goro cõ ĩñupʉ̃: —Yʉ masĩẽtĩña. ¿Ñe ũnierẽ yʉ mʉ jẽniñañati? Cʉ̃ yʉ masĩẽtĩña Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bairo cõ ĩ yaparo yua, ti yepa ẽñotarica jope tʉpʉ ásúpʉ Pedro. Topʉ cʉ̃ caetanʉcãrõ, apeo carõmio Pedrore qũĩñarĩ atore bairo na ĩñupõ cõtʉ caãnarẽ: —Ãni cʉ̃ã Jesús, Nazaret macããcʉ̃ mena cabapacʉtinucũatacʉ ãcʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro pʉame cõ ĩñupʉ̃: —¡Dios mena ñiña! ¡Cʉ̃ yʉ masĩẽtĩmajũcõãña Jesure! ");
INSERT INTO cbcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cabero tunu to macããna Pedrotʉ etari bairo qũĩñuparã: —Bairo ĩcũʉ̃ miña, mʉa, Jesús mena macããcʉ̃ majũ mʉ ãniña. Mʉ cabʉsʉrijepʉ cʉ̃ã Galilea macããna na cabʉsʉrore bairo mʉ bʉsʉya. Bairi na mena macããcʉ̃ mʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bairo na caĩrõ tʉ̃go, Pedro pʉame na ĩñupʉ̃: —¡Tame, cariape Dios mena mʉjããrẽ ñiña! Netõjãñurõ merẽ mʉjããrẽ, “Cʉ̃ yʉ masĩẽtĩña,” mʉjãã ñimiñajã —na ĩñupʉ̃. Bairo Pedro cʉ̃ caĩtoãnipaʉa, jĩcãʉ̃ ãbocʉ piiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bairo cʉ̃ capiiro, Pedro pʉame tʉ̃goña bocayupʉ Jesús cʉ̃ cʉ̃ caĩatajere. “Pedro, ãmeacã ãbocʉ cʉ̃ capiiparo jʉ̃goye itiani, ‘Cʉ̃ yʉ masĩẽtĩña Jesure,’ yʉ mitogʉ,” cʉ̃ caĩatajere tʉ̃goña bocayupʉ. Bairo tʉ̃goña bocari yua, witicoásúpʉ macãpʉ. Topʉ yua, tʉ̃goña yapapuari bʉtioro otiyupʉ Pedro. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bairo ti ñami cabusuetaro, nipetirã sacerdote majã quetiuparã, bairi aperã judío majã cabʉtoa camasĩrã cʉ̃ã jĩcãrõ mena tʉ̃goñarĩ Roma macããna Jesure cʉ̃ na capajĩãrotipeere ãmeo ĩ bʉsʉyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bairo ĩbʉsʉ yaparo yua, Jesús wãmorĩrẽ jiyarotiyuparã. Áti yaparo, cʉ̃ neásúparã Pilato cawãmecʉcʉ tʉpʉ. Pilato pʉame Roma macããna, Israel yepare caẽmarĩcãrã ti yepare na caroticũrĩcʉ̃ gobernador majũ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mai, Judas, Jesure caĩbʉsʉjãbuitirocaatacʉ pʉame Jesure na capajĩãgaro ĩñarĩ, tʉ̃goña yapapuayupʉ roro cʉ̃ caátiatajere. Bairo tʉ̃goña yapapuari treinta moneda plata tiirire na tunuojoyupʉ fariseo majã quetiuparã, bairi judío majã cabʉtoa camasĩrãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Atore bairo na ĩñupʉ̃: —Ñe ũnie cabuicʉpeire qũĩ bʉsʉjãbuitirocaʉ, roro majũ Dios mena yʉ átiapʉ, bairo ácʉ —na ĩñupʉ̃ Judas. Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, fariseo quetiuparãjãã pʉame cʉ̃ yʉesuparã: —Jããrã, ñe wapa maa. ¡Mʉ majũã mʉ baitʉ̃goñaña ti wãmerẽ! —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas pʉame na caĩrõ tʉ̃go, tie moneda tiirire ti wii templo wiipʉre wecũrecõãñupʉ̃. Bairo áti yaparo, acoásúpʉ, cʉ̃ majũã pajĩãyasiácʉ́. Bairi yua, cʉ̃ majũã cʉ̃ wãmʉarẽ jiyatubiyori pajĩãyasicoasupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sacerdote majã quetiuparã pʉame Judas moneda tiiri cʉ̃ cawẽcũrerijere jeri, bairo ãmeo ĩñuparã na majũ: —Atie moneda tiiri caʉ̃mʉrẽ marĩ capajĩãrocarotiataje wapa niña. Bairo cabairoi, ati wii templo macãã pata Dios rocapatare marĩ jããnemomasĩẽna —ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bairo ãmeo ĩrĩ, jĩcãrõ mena tʉ̃goñañuparã. Jĩcã yepa Campo del Alfarero cawãmecʉti yepare wapatirotiyuparã tie dinero mena, ape yepapʉ caatíatana, marĩ ya macãpʉ cariayasirã na rupaʉri ãnajẽrẽ topʉ na cayareparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bairi camasã nipetiro bairo na caátajere tʉ̃gori, ti yepare Rií Yepa wãmeticõã ninucũñama, ãme rʉ̃mʉrĩ cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bairo profeta Jeremías ãnacʉ̃ Dios bʉsʉrica tutipʉ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietayuparo. Bairo ĩ quetibʉjʉ jʉ̃goyeticũñañupĩ Jeremías: “Bairi tie moneda, treinta tiiri majũrẽ, israelita majã ‘Tocãrõã wapa borotiya,’ na caĩrĩjẽrẽ neágarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bairo tiere jeátí yua, ‘Alfarero’ na caĩrĩ yepare wapatigarãma, tie dinero mena marĩ Quetiupaʉ cʉ̃ caĩquetibʉjʉcũrĩcãrõrẽ bairo,” ĩñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bairi Jesure cʉ̃ neásúparã fariseo majã Pilato gobernador tʉpʉ. Cʉ̃ pʉame na caĩbʉsʉpairijere tʉ̃goʉ, bairo qũĩ jẽniñañupʉ̃ Jesure: —¿Mʉa, judío majã Quetiupaʉ Rey mʉ ãniñati? Bairo cʉ̃ caĩrõ, Jesús pʉame qũĩñupʉ̃: —Mʉ caĩrõrẽã bairo yʉ baiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bairo fariseo majã quetiuparã, bairi cabʉtoa camasĩrã mena Jesure nemojãñurõ cʉ̃ na cabʉsʉjã nemomiatacʉ̃ãrẽ, Jesús pʉame na yʉesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bairi narẽ cʉ̃ cayʉeto ĩña yua, Pilato pʉame atore bairo qũĩ jẽniñañupʉ̃ Jesure: —¿Capee mʉrẽ roro na caĩrĩjẽrẽ mʉ tʉ̃goetiyati? ");
INSERT INTO cbcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús pʉame bairo cʉ̃ caĩrõ tʉ̃gomicʉ̃ã, jĩcã wãmeacã ũno cʉ̃ yʉesupʉ. Bairo cʉ̃ cayʉeto ĩña, bʉtioro Pilato gobernador quetiupaʉ pʉame tʉ̃gocõã maniásupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mai, tocãnacã Pascua bose rʉ̃mʉ caãno, Pilato pʉame wiyonucũñupʉ̃ jĩcãʉ̃ preso jorica wii macããcʉ̃rẽ, judío majã na caboʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bairi tipaʉ caãno romano majã preso na cajoricʉ ãñupʉ̃ jĩcãʉ̃, Jesús Barrabás cawãmecʉcʉ, judío majã nipetirã na camasĩ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bairi Pilato pʉame to macããna na caneñaporo ĩñaʉ, atore bairo na ĩ jẽniñañupʉ̃: —¿Ni pʉamerẽ yʉ cawiyoro mʉjãã boyati? ¿Jesús Barrabás, o Jesús, “Mesías” mʉjãã caĩwãmetinucũʉ̃rẽ? —na ĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Masĩcõãmiñupʉ̃ Pilato Jesure qũĩñatutiri cʉ̃ cayasiro na cabotʉ̃goñarĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Apeyera tunu Pilato ĩñabesei cʉ̃ caruiropʉ cʉ̃ caruiro, cʉ̃ nʉmo pʉame atore bairo qũĩ joyupo: “Cʉ̃, dise rorije caápeire roro cʉ̃ átirotieticõãña. Ãme ñami yʉ caqũẽgueropʉ popiye yʉ tʉ̃goñaapʉ̃ roro cʉ̃rẽ na caátipeere,” qũĩ joyupo. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bairi Pilato Jesure cʉ̃ cawiyogamiatacʉ̃ãrẽ, sacerdote majã quetiuparã, bairi cabʉtoa camasĩrã cʉ̃ã bairo boesuparã. Na pʉame yasioroaca camasã natʉ caãnarẽ atore bairo na ĩ rotiyuparã: “Barrabáre, Pilato cʉ̃ cawiyoro jãã boya. Jesús pʉamerẽ cʉ̃ pajĩãrotiya,” na ĩbʉsʉ awajarotiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bairi gobernador Pilato pʉame atore bairo na ĩ jẽniñanemoñupʉ̃ tunu: —¿Ni pʉamerẽ yʉ cawiyoro mʉjãã boyati? Bairo cʉ̃ caĩjẽniñarõ, bairo qũĩñuparã: —¡Barrabás roquere cʉ̃ mʉ cawiyoro jãã boya! ");
INSERT INTO cbcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bairo na caĩrõ, Pilato pʉame bairo na ĩ jẽniñanemoñupʉ̃ tunu: —Bairi Jesús, Mesías cawãmecʉcʉre, ¿dope yʉ caáto mʉjãã boyati? Bairo cʉ̃ caĩjẽniñarõ, bairo qũĩñuparã: —¡Yucʉpãĩpʉ cʉ̃ papuaturotiya! ");
INSERT INTO cbcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tunu na ĩnemoñupʉ̃ Pilato: —¿Nopẽĩrã yucʉpãĩpʉ cʉ̃ yʉ capapuaturotiro mʉjãã boyati? ¿Dise ũnie carorije cʉ̃ ásupari? Bairo cʉ̃ caĩjẽniñamiatacʉ̃ãrẽ: —¡Yucʉpãĩpʉ cʉ̃ papuaturotiya! —jĩrĩã bʉtioro jãñurĩ ĩ awajanemoñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bairo roro na caátigarije ĩñarĩ, “Dope bairo na yʉ quetibʉjʉnetõmasĩẽcʉ̃,” ĩ tʉ̃goñañupʉ̃ Pilato. Bairo ĩ tʉ̃goñarĩ cʉ̃ paabojari majõcʉre ocorʉ cʉ̃ neatí rotiyupʉ, camasã yʉ cawãmo coserijere na ĩñaáto ĩ. Bairo áti yaparo yua, atore bairo na ĩñupʉ̃ Pilato nipetiro camasãrẽ: —Bairo yʉ wãmorĩrẽ yʉ cacoserije jʉ̃gori mʉjããrẽ ñiñoña, yʉa, ñe yʉ buicʉperiya ãni cʉ̃ cariarije. Mʉjãã yaye wapa rotie roque niña. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ yʉyuparã to macããna: —¡Ñugaro, jãã, jãã pũnaa cʉ̃ã yaye wapa rotie jeto jʉ̃gori cʉ̃ mʉ pajĩãrotigʉ! —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Bairo na caĩrõ tʉ̃go, Pilato Barrabáre cʉ̃ wiyorotiyupʉ. Bairo áti yaparo, Jesure wecʉ asero wẽẽrĩ mena cʉ̃ baperotiyupʉ. Bairo cʉ̃ na caáti yaparoro, na nuniñupʉ̃, Jesure yucʉpãĩpʉ cʉ̃ na capapuatuparore bairo ĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gobernador cʉ̃ carotirã soldaua pʉame Jesure cʉ̃ neásúparã pretorio cawãmecʉti wii macã yepa recomacãpʉ. Topʉ etarã, na baparãrẽ na piineñoñuparã, Jesure roro cʉ̃ átiepegarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bairo neña yaparo, cʉ̃ jutirore weri, apero cajũãrõ, quetiupaʉ rey cʉ̃ cajãñarõ ũnorẽ cʉ̃ jããñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Áti yaparo, quetiupaʉ rey corona cʉ̃ capesari beto ũnorẽ cʉ̃ pesáto ĩrã, pota wẽẽrĩ mena juarica betore cʉ̃ rʉpoapʉ peoyuparã. Tunu bairoa, quetiupaʉ rey wãmocʉtacʉ ũnorẽ cʉ̃ ñeáto ĩ eperã, yucʉacarẽ cʉ̃ wãmo cariape nʉgõãpʉ cʉ̃ cʉ̃gorotiyuparã. Bairo áticõã yua, cʉ̃rẽ quetiupaʉre jẽnirãrẽ bairo na rʉpopaturi mena cʉ̃tʉ etanumurĩ bairo qũĩ boyeti epeyuparã: —¡Cʉ̃ ãnicõã ninucũáto ãni judío majã Quetiupaʉ Rey tocãnacã rʉ̃mʉa! —qũĩ boyeti epeyuparã soldaua Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bairo áticõã, cʉ̃ ʉcoo eyotuepeyuparã. Tunu bairoa cʉ̃ yucʉacarẽ nerĩ, cʉ̃ rʉpoare payuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bairo Jesure roro cʉ̃ átiepe yaparo yua, cʉ̃rẽ na cajãatajere cʉ̃ tuweneñuparã. Cʉ̃ jutii majũ pʉamerẽ cʉ̃ jããñuparã tunu. Bairo áti yaparo, cʉ̃ neásúparã, yucʉpãĩpʉ cʉ̃ papuaturáná. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bairo áná, bócaetayuparã jĩcãʉ̃ caʉ̃mʉ, Simón cawãmecʉcʉ, Cirene yepa macããcʉ̃rẽ. Bairo Simorẽ bócaetari cʉ̃ pʉsarotiyuparã, Jesús yucʉpãĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bairo átí yua, Gólgota buropʉ etayuparã. (Gólgota ĩgaro, “La Calavera” o “Rʉpoa coro buro” ĩgaro ĩña.) ");
INSERT INTO cbcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bairo etarã, ʉse ocore, mirra bʉʉrije cabairije ũnie mena asuyariquere Jesure cʉ̃ tĩãmiñuparã. Jesús pʉame tiere etiñarĩ etigaesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bairi soldaua yucʉpãĩpʉ Jesure cʉ̃ papuatu nʉcõrĩ bero, número tiirire ãmeo wẽnuniñuparã. Bairo átiri, na majũ masĩñuparã Jesús jutii ãnajẽrẽ canepaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bairo áti yaparo, topʉ ruiri, Jesure qũĩña coteyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tunu bairoa Jesús rʉpoa buire yucʉpãĩ woaturicapãĩrẽ papuatuyuparã, Jesure na cʉ̃ capajĩãrotirique wapare nipetiro camasã na ĩñao joroque ĩrã. Tipãĩrẽ atore bairo ĩ woaturique tusayuparo: ÃNI, JUDÍO MAJÃ QUETIUPAɄ REY NIÑAMI, ĩrĩqũẽ tusayuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bairi Jesús mena yucʉpãĩpʉ papuatureyuparã pʉgarã caʉ̃mʉa jerutiri majãrẽ. Jĩcãʉ̃ cariape nʉgõãrẽ, apei caãcõ nʉgõãrẽ na papuatuyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bairo yucʉpãĩpʉ papuaturicʉ Jesús cʉ̃ caãno yua, camasã canetõánucũrã pʉame Jesure qũĩroaena, na rʉpoare yureyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Roro majũ atore bairo qũĩñuparã: —¡Mʉ, templo wiire roca yaparori, itia rʉ̃mʉ bero ape wii cawãma wiire caqũẽnomasĩgaʉ ãnirĩ, mʉ majũã netõña! ¡Dios Macʉ̃ majũ mʉ caãmata, yucʉpãĩpʉ ãnimicʉ̃ã, atopʉ ruiasá! —qũĩ epeyuparã to macããna caĩñanetõánucũrã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Torea bairo qũĩ epeyuparã sacerdote majã quetiuparã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi cabʉtoa camasĩrã cʉ̃ã. Atore bairo qũĩñuparã: ");
INSERT INTO cbcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Aperãrẽ na netõũpĩ. Bairo na netõmicʉ̃ã, ãmerẽ cʉ̃ majũã netõmasĩẽtĩñami. Israel yepare quetiupaʉ rey majũ cariapea cʉ̃ caãmata, ¡cʉ̃ majũã cʉ̃ camasĩrĩjẽ mena atore ruiatíbujioʉmi! Bairo cʉ̃ caruiapáta, cariape marĩ tʉ̃gogarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dios mena tʉ̃goñatutuaricʉmi. Bairi Dios pʉame cariapea cʉ̃rẽ cʉ̃ camaiata, cʉ̃rẽ cʉ̃ netõõgʉmi. “Dios macʉ̃ yʉ ãniña,” marĩ ĩwĩ —qũĩ epeyuparã sacerdote quetiuparãjãã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bairi jerutiri majã, Jesús mena na capapuatuatana cʉ̃ã tore bairo roro qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Merẽ yua, pasaribota caãno, caãno tʉsaroa naitĩãcoapʉ ati yepa nipetiropʉ. Yoaro naitĩãwʉ̃. Ñamicã, tres de la tarde caãno majũ tunu busuwʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tipaʉ caãno, Jesús pʉame bʉsʉrique tutuaro mena atore bairo ĩñupʉ̃: “Elí, Elí, ¿lema sabactani?” (Ti wãme pʉame ĩrã, “Yʉ Pacʉ Dios, yʉ Pacʉ Dios, ¿nopẽĩ yʉ mʉ aweyocoátí?” ĩgaro ĩña.) ");
INSERT INTO cbcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bairo cʉ̃ caĩrõ tʉ̃go, to macããna pʉame bairo ãmeo ĩñuparã na majũ: —¡Jã, tʉ̃goñijate! Ãni Jesús, profeta Elías ãnacʉ̃rẽ cʉ̃ pii ĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ĩcõã yua, na mena macããcʉ̃ jĩcãʉ̃ carupajitia mena ʉse oco, cajʉ̃gũẽatajere yosene ásúpʉ. Bairo átícõã, yucʉ yapapʉ ti jitiare jiyaturi, tiere cʉ̃ ñumʉgõ joyupʉ, cʉ̃ etiáto, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bairo cʉ̃ caáto ĩña, aperã cʉ̃tʉ macããna pʉame bairo qũĩñuparã: —Bairo ápericõãña mai. Cʉ̃ caĩrĩjẽrẽ tʉ̃gori, ¿Elías ãnacʉ̃ cʉ̃ cʉ̃ netõʉ̃ acʉ́ati? Marĩ ĩñacoteroa mai —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús pʉame bʉsʉrique tutuaro mena ĩ wisiotʉsa, riacoásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tipaʉ caãno, templo wii arʉare ẽñotaricaro jutii asero carecomacã woocõã ruiásúparo. Yepa cʉ̃ã bʉtioro yuguiwʉ. Ʉ̃tã rupa cʉ̃ã waticoápʉ tie majũã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Camasã cariaricarã na cayarica opee cʉ̃ã to majũã pããcoásuparo. Bairo pããcoa yua, cariaricarã, Dios yarã pʉame tunu catitunucõãma. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bairo bairã, witicoámá, Jesús cariacoamiatacʉ tunu cʉ̃ cacatinemorõ bero. Tocãrõã Jerusalén caroa macãrẽ etari jããwã yua. Bairo capããrã camasã cʉ̃ã ti macãrẽ na caãnorẽ ĩñawã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bairi soldaua quetiupaʉ capitán, bairi cʉ̃ ʉ̃mʉa Jesure caĩñacoterã cʉ̃ã yepa cayuguirijere, bairi nipetiro tie cabairijere ĩñarã, bʉtioro uwiri atore bairo ãmeo ĩñuparã: —¡Cariapea ãni, Jesús, Dios Macʉ̃ majũ nimiupĩ! ");
INSERT INTO cbcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bairi Jesure cajʉátinemorĩcãrã carõmia capããrã, Galileapʉ Jesure cabapacʉtiatíatana pʉame jõpʉ̃ã tuari qũĩñacõã nucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jĩcãõ na mena macããcõ ãñupõ María Magdalena cawãmecʉco. Apeo, María, Santiago bairi José paco ãñupõ. Apeo Zebedeo pũnaa paco ãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bairo ti rʉ̃mʉ canaioatípaʉ caãno José cawãmecʉcʉ, Arimatea macã macããcʉ̃ etayupʉ. Cʉ̃ pʉame pairo apeyere cacʉ̃goʉ ãmi. Tunu bairoa Jesús yaye bʉsʉriquere catʉ̃goʉsaʉ ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bairi yua, Pilato tʉpʉ átí, Jesús rupaʉri ãnajẽrẽ yarocagʉ, cʉ̃ jẽniásúpʉ. Pilato pʉame bairo cʉ̃ caĩjẽnirõ tʉ̃go, “Jaʉ” ĩ, Jesús rupaʉri ãnajẽrẽ cʉ̃ ʉ̃mʉarẽ Josére ruio rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Bairo cʉ̃ caĩrõ bero, José pʉame Jesús rupaʉri ãnajẽrẽ lino jutii asero, caʉgueri mani asero mena cʉ̃ ũmañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bairo átiri bero, cawãma ʉ̃tã ope, na cayesearica opepʉ Jesús rupaʉri ãnajẽrẽ cũñupʉ̃. Áti yaparo, ʉ̃tãpãĩ mena ti opere tubiatoyupʉ. Bairo tubiato yaparo, acoásúpʉ José. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bairo José cʉ̃ caámiatacʉ̃ãrẽ, María Magdalena bairi apeo María cawãmecʉco cʉ̃ã topʉ tuari Jesure cʉ̃ carocatato riape ruicõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Bairo ti rʉ̃mʉ bero, yerijãrĩcã rʉ̃mʉ pʉamerẽ sacerdote majã quetiuparã, bairi fariseo majã mena jĩcãrõ tʉ̃ni ásúparã Pilato tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bairo cʉ̃tʉ eta, atore bairo qũĩñuparã: —Jãã Quetiupaʉ, jãã tʉ̃goñabocaapʉ Jesús, caĩtopai ãnacʉ̃ cʉ̃ caĩrĩqũẽrẽ. “Cariacoatacʉ nimicʉ̃ã, itia rʉ̃mʉ bero yʉ catigʉ tunu,” jãã ĩtowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bairi atore bairo mʉ caáto ñuña: Mʉ ʉ̃mʉarẽ cʉ̃ ãnacʉ̃ rupaʉri na cacũrocaatapaʉre itia rʉ̃mʉ majũ na coterotiya, Jesús cʉ̃ cabuerã ñamipʉ yasiori cʉ̃ rupaʉ ãnajẽrẽ na canerutietiparore bairo ĩrã. Bairo cʉ̃ cabuerã bairo na caápata, cabero camasãrẽ, “Merẽ catiupi,” na ĩtobujiorãma. Bairo na caĩtoata, jõpʉame roro baibujioro cʉ̃ caĩtojʉ̃gorique netõjãñurõ ati yepapʉre —qũĩñuparã sacerdote quetiuparãjãã Pilatore. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato pʉame bairo na ĩñupʉ̃: —Ãnoa soldauare na neánája. Cʉ̃ ãnacʉ̃rẽ na carocaatapaʉre caroaro mʉjãã carotiro cãrõ na coteáto —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bairo cʉ̃ caĩrõ tʉ̃go, sacerdote quetiuparãjãã acoásúparã Jesús rupaʉri ãnajẽrẽ na cacũrocaatapaʉpʉ. Topʉ etarã, ʉ̃tã, capairi tii na catubiatori tii buire caroaro jʉgobiacõãñuparã, “Aperã na capãata, marĩ ĩñamasĩbujiorã,” ĩrã. Bairo átiri, soldauare na cũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cabero yerijãrĩcã rʉ̃mʉ bero macã rʉ̃mʉ, cabusuripaʉaca caãno, ape semana caãni jʉ̃gori rʉ̃mʉ majũ, María Magdalena, bairi apeo María cawãmecʉco mena Jesús rupaʉri ãnajẽrẽ na cacũrocaatapaʉpʉ ĩñarásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bairo na caátó, jĩcãʉ̃ ángel, Diotʉ caatíatacʉ pʉame ruietayupʉ. Bairo cʉ̃ caruietaro yua, yepa bʉtioro majũ yuguiyuparo. Bairo cabairo, ángel pʉame Jesús rupaʉri ãnajẽrẽ na cacũrocaatapaʉre etanʉcãñupʉ̃. Bairo etanʉcã yua, ti opere na cabiaatatiire tunerocacõãñupʉ̃. Bairo áti yaparo, ti ʉ̃tã tii buire ruiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ángel pʉame asiyajãñuñupʉ̃, bʉpo cʉ̃ cayaberijere bairo. Cʉ̃ jutii cʉ̃ã cabotirije nieve cabaurore bairo bauyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bairi soldaua, bairo cʉ̃ cabairo ĩña yua, nanarĩ bʉtioro cʉ̃ uwiyuparã. Cariacoatanarẽ bairo baicũmucoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bairo na cabaiãno, ángel pʉame carõmia topʉ caĩñarã etarãrẽ atore bairo na ĩñupʉ̃: —Mʉjãã, uwieticõãña. Yʉ masĩña mʉjãã caátigarijere. Jesús yucʉpãĩpʉ na capapuaturocamiatacʉre qũĩñagarã mʉjãã baiya. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Atore maniñami. Merẽ caticoami tunu, mʉjããrẽ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo. Atopʉ asá mai. Ĩñañijate cʉ̃rẽ na cacũmiatatore. Catiri, atore maniñami. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bairo ĩña yaparori bero, tunu ánája macãpʉ. Cʉ̃ cabuerãrẽ atore bairo na quetibʉjʉrájá: “Merẽ caticuupi Jesús. Bairi mʉjãã jʉ̃goye Galilea yepapʉ ágʉmi. Topʉ mʉjãã cotegʉmi,” na ĩ quetibʉjʉrájá. Bairo na camasĩpeere yʉ quetibʉjʉ atíapʉ —na ĩ quetibʉjʉyupʉ ángel María Magdalenajããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, carõmia pʉame yoaro mee acoásúparã. Uwirã, bairi tunu tie quetire tʉ̃goʉseanirĩ atʉcoásúpa, jãã, Jesús cʉ̃ cabuerãrẽ quetibʉjʉráná. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bairo na caátó, Jesús pʉame na jʉ̃goye buiaetayupʉ. Bairo buiaetari yua, caroaro mena na jẽniñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, carõmia pʉame cʉ̃tʉ na rʉpopaturi mena etanumurĩ cʉ̃ rʉporire pããñarĩ ũpũñuparã, bʉtioro qũĩroarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bairo na caáto, atore bairo na ĩñupʉ̃ Jesús: —Yʉ uwieticõãña. Yʉ bairãrẽ bairo caãnarẽ atore bairo na ĩ quetibʉjʉrájá: “Galilea yepapʉ ánája. Topʉ Jesure cʉ̃ mʉjãã ĩñagarã,” na ĩ quetibʉjʉrájá —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bairo carõmia na caátoye, Jesús rupaʉri ãnajẽrẽ cacotemiatana jĩcããrã na mena macããna macãpʉ etayuparã. Etarã yua, sacerdote majã quetiuparãrẽ na quetibʉjʉyuparã nipetiro narẽ cabaiatajere. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bairo na caquetibʉjʉro tʉ̃gorã, sacerdote majã pʉame ásúparã cabʉtoa camasĩrã tʉpʉ jĩcãrõrẽ bairo na catʉ̃goñaparore bairo ĩrã. Bairo na mena bʉsʉ yaparo yua, soldauare pairo dinerore na nuniñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bairo na nuni yua, atore bairo na ĩñuparã: —Atore bairo mʉjãã cabaiatajere camasãrẽ na mʉjãã ĩ quetibʉjʉgarã: “Jãã cãnicoaupa. Bairo jãã cacãnitoye, Jesús cʉ̃ cabuerã pʉame atí, cʉ̃ ãnacʉ̃ rupaʉrire yajacũũpã,” mʉjãã ĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tunu bairoa quetiupaʉ gobernador bairo mʉjãã cacãniatajere cʉ̃ catʉ̃goata, jãã pʉame popiye baio joroque mʉjããrẽ cʉ̃ caátipeere jãã ẽñotabojagarã —na ĩ quetibʉjʉyuparã sacerdote majã quetiuparãjãã soldauare. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bairo na caĩrõ tʉ̃go, soldaua pʉame, “Jaʉ” ĩ, dinerore jeyuparã. Bairi sacerdotea quetiuparã narẽ na caĩrotirorea bairo quetibʉjʉ batoyuparã camasãrẽ. Bairi ati rʉ̃mʉrĩ cʉ̃ãrẽ torea bairo jeto ãmeo quetibʉjʉcõã ninucũñama judío majã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bairi yua, jãã, Jesús cʉ̃ cabuerã, pʉga wãmo peti rʉpore jĩcã pẽnirõ cãnacãʉ̃ majũ caãna jãã ápʉ́ Galilea yepapʉ. Topʉ etarã, ʉ̃tãʉ̃, Jesús jããrẽ cʉ̃ caĩquetibʉjʉricʉ majũ cʉ̃ jãã bocaetawʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bairo qũĩña yua, jãã rʉpopaturi mena etanumurĩ cʉ̃rẽ jãã ĩroawʉ. Mai, jĩcããrã jãã mena macããna, “Jesús catiri niñami,” ĩ masĩẽma. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Bairo jãã cabairo, Jesús pʉame jããtʉ etari, atore bairo jãã ĩwĩ: —Marĩ Pacʉ Dios yʉ joyami tocãnacã wãme rotimasĩrĩqũẽrẽ. Ʉmʉrecóo, bairi ati yepa cʉ̃ã rotimasĩrĩqũẽrẽ yʉ joyami. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bairi camasã tocãnacã poari macããnarẽ noo na caãnopʉ yʉ yaye quetire na quetibʉjʉ ñesẽãrájá, na cʉ̃ã yʉ yaye quetire na catʉ̃goʉsaparore bairo ĩrã. Bairo na catʉ̃goʉsaro, na mʉjãã bautizagarã. Marĩ Pacʉ Dios ya wãme mena, yʉ, cʉ̃ macʉ̃ ya wãme mena, bairi tunu Espíritu Santo ya wãme ĩrĩ mena na mʉjãã bautizagarã. ");
INSERT INTO cbcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tunu bairoa mʉjããrẽ yʉ caátiroticũrĩqũẽ nipetirijere na quetibʉjʉnetõõña, na cʉ̃ã tiere na catʉ̃goʉsaparore bairo ĩrã. Yʉa, mʉjããrẽ yʉ aweyoetigʉ. Mʉjãã mena yʉ ãnicõã ninucũgʉ tocãnacã rʉ̃mʉ, ati ʉmʉrecóo capetiropʉ —jãã ĩcũwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. Tocãrõã ñiña.");
INSERT INTO cbcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Caãnijʉ̃goripaʉpʉa Jesucristo, Dios macʉ̃ ati yepapʉ cʉ̃ caátiãnajẽrẽ marĩ tʉ̃goroa mai. Caroa queti niña. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Atore bairo ĩ woatu quetibʉjʉ cũñañupĩ profeta Isaías ãnacʉ̃ Dios cʉ̃ macʉ̃rẽ cʉ̃ caĩrĩqũẽrẽ: “Mʉ, yʉ cajopaʉ, ti yepapʉ mʉ cabuiaparo jʉ̃goye, apeire cʉ̃ yʉ qũẽnoroti jojʉ̃gogʉ. Camasã mʉ yaye quetire na tʉ̃goʉsaáto ĩ, apeire yʉ qũẽnoroti jojʉ̃gogʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bairo ĩgʉmi jĩcãʉ̃ desierto, cayucʉmanopʉ caãnicõãniatacʉ: ‘Marĩ Quetiupaʉ yoaro mee etagʉmi. Torena, caroaro cariape ãnicoteya. Camasã na quetiupaʉ cʉ̃ caetaparo jʉ̃goye cʉ̃ caatípawãrẽ na caqũẽnoyurore bairo cʉ̃ qũẽnoyuya mʉjãã cʉ̃ã,’” ĩ woatu quetibʉjʉyayupi Isaías ãnacʉ̃ Juan cʉ̃ caĩquetibʉjʉpeere. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bairo cayoato bero Juan ãnacʉ̃, camasãrẽ oco mena cabautizaricʉ pʉame etayupʉ desierto cayucʉmanopʉ. To macããna cʉ̃ yaye quetire catʉ̃gorã etarãrẽ atore bairo na ĩ quetibʉjʉyupʉ: “Tʉ̃goña qũẽnoña roro mʉjãã caátiãnierẽ. Tie mʉjãã cabairijere cʉ̃ tʉ̃goña jẽniña mʉjãã majũ Diore. Tunu bairoa cabautizarotiparã mʉjãã ãniña. Bairo mʉjãã caáto, mʉjãã netõgʉmi Dios,” na ĩñupʉ̃ Juan to macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bairo cʉ̃ cabaiãno, Jũãtʉpʉ asúparã camasã capããrã. Judea yepa macããna, bairi Jerusalén macã macããna cʉ̃ã, nipetiro camasã Jũãtʉpʉ asúparã. Juan yaye quetibʉjʉriquere tʉ̃gogarã cʉ̃tʉ asúparã. Bairo cʉ̃ caĩquetibʉjʉro tʉ̃gorã, roro na caátajere tʉ̃goña yapapuari Dios mena bʉsʉnetõñuparã. Bairo na caáto ĩña, oco mena na bautizayupʉ. Catʉ̃goʉsarãrẽ ria Jordán cawãmecʉtiyapʉ na bautizanucũñupʉ̃ Juan. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan pʉame waibʉcʉ camello cawãmecʉcʉ asero mena jutiiro qũẽnorĩ jãñañupʉ̃. Tunu bairo waibʉcʉ aserowẽ mena cʉ̃ jutiirore ñujãã tʉ̃gãbiyori jutii jãñañupʉ̃. Bairi tunu ʉgarique cʉsupʉ Juan yeseroare bairã caãnarẽ. Beroa oco cʉ̃ãrẽ etinucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Bairo ĩ quetibʉjʉyupʉ Juan nipetiro camasã catʉ̃gorã etarãrẽ: “Yʉ paarique niña mʉjããrẽ oco mena yʉ cabautizarije. Yʉ paarique to cañumiatacʉ̃ãrẽ, yʉ bero caetaʉ cʉ̃ capaarije pʉame ñunetõgaro. Cʉ̃ roque Espíritu Santore jõmasĩgʉmi camasãpʉre. Tunu bairoa camasã roro na catʉ̃goñarĩjẽrẽ na wasoao joroque na átigʉmi. Cʉ̃ roque yʉ netõrõ caãnimajũʉ̃ nigʉmi. Bairi yʉ pʉame jĩcãrõ tʉ̃ni yʉ átipeyo masĩẽtĩña,” na ĩ quetibʉjʉyupʉ Juan catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cabero Jesús Nazaret de Galilea macããcʉ̃ ti macã caãniatacʉ Juan tʉre etayupʉ. Bairo cʉ̃ caetaro, Jesús cʉ̃ãrẽ cʉ̃ bautizayupʉ Juan, Rio Jordán cawãmecʉtiyapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bairo Jesure cʉ̃ cabautizaro bero, Jesús pʉame petapʉ maanʉcãñupʉ̃. Bairo maanʉcã yua, jõbuipʉ ĩñamʉgõjoyupʉ. Bairo cʉ̃ caĩñajoro, jicoquei ʉmʉrecóo pʉame pããnʉcãcoasuparo. Bairo cabairo, Espíritu Santo, Dios Yeri majũ, bauruiasúpʉ. Bua cʉ̃ caruiatóre bairo bauruietayupʉ Jesús tʉpʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bairo cʉ̃ caruietaro, atore bairo jõbuipʉ bʉsʉrique ocajoyuparo: “Mʉ, yʉ macʉ̃, yʉ camai majũ mʉ ãniña. Mʉ caátiãnierẽ ñiñajesoya bʉtioro,” ĩ bʉsʉocajoyuparo bʉsʉrique. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","To bero jicoquei Espíritu Santo pʉame Jesure bʉtioro cʉ̃ árotiyupʉ desierto cayucʉmanopʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Topʉre cuarenta rʉ̃mʉrĩ majũ ãñupʉ̃ Jesús waibʉtoa cauwiorã na caãnopʉ. Bairo topʉ cʉ̃ caãno yua, Satanás pʉame rorije cʉ̃ átirotimiñupʉ̃ Jesure, “Cariapea cʉ̃ átinucũñati,” ĩ. Bairo Satanás cʉ̃ caátó bero, jĩcããrã ángelea majã Jesure cʉ̃ jʉátirã etayuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cabero Juan camasãrẽ cabautizamirĩcʉ̃rẽ preso jorica wiipʉ cʉ̃ na cacũrocaatato bero, Jesús pʉame Galilea yepapʉ acoásúpʉ. Topʉ etari, Dios yaye caroa quetire na quetibʉjʉ jʉ̃goyupʉ Jesús camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Atore bairo na ĩ quetibʉjʉyupʉ: “Dios cʉ̃ carotimasĩrĩpaʉ merẽ etaro baiya. Bairi tʉ̃goña qũẽnorĩ caroaro ãña Dios mena. Dios yaye caroa quetire cariape tʉ̃goya,” na ĩñupʉ̃ Jesús camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cabero Galilea na caĩrĩ ʉtabʉcʉra tʉ̃nipʉ ásúpʉ Jesús. Bairo ácʉ́ yua, Simón, apei cʉ̃ bai Andrés, jĩcãʉ̃ pũnaa caãna pʉgarãrẽ na ĩñajoyupʉ. Bairo Jesús narẽ cʉ̃ caĩñajoro, na pʉgarãpʉa ʉtabʉcʉrapʉ bapi mena wai wasarã ásuparã. Na capaarije, waiwe wapatarique ãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bairo na ĩña, atore bairo na ĩñupʉ̃ Jesús: —Jito, yʉ bapacʉsa. Caroaro waire cawãsãmasĩrã mʉjãã ãniapʉ, wai na rutieticoáto, ĩrã. Ãmerẽ yua, caroaro camasãrẽ caquetibʉjʉrã mʉjãã ãnio joroque mʉjãã yʉ átigʉ, na yasieticõãto, ĩrã —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei pʉgarãpʉa na bapi yucʉre cũrĩ, acoásúparã Jesús mena. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bairo cajʉ̃goye jãñurĩ na caánemorõ ʉtabʉcʉra tʉ̃nipʉ Jesús pʉame na ĩñajoyupʉ aperã pʉgarãrẽ tunu. Santiago, bairi cʉ̃ bai Juan cawãmecʉcʉ Zebedeo pũnaarẽ na ĩñajoyupʉ Jesús. Bairi Santiago, cʉ̃ bai Juan mena cũmua capairicapʉ ãñuparã. Bapi yucʉ caopecʉtiere jiyajãrã ásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bairo narẽ na ĩña, jicoquei na piijoyupʉ Jesús: “Jito, yʉ bapacʉsa. Marĩ quetibʉjʉto camasãrẽ Dios yaye caroa quetire,” na ĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go yua, na pacʉ, cʉ̃ ʉ̃mʉa mena cũmuapʉ na cũcõã, tocãrõã jicoquei Jesús mena acoásúparã ");
INSERT INTO cbcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Cabero Capernaum cawãmecʉti macãpʉ etayupʉ. Topʉ eta, yerijãrĩcã rʉ̃mʉ caãno ti macã macããna na cañubueri wiipʉre, sinagoga na caĩrĩ wiipʉre jããñupʉ̃. Bairo jããrĩ, na buejʉ̃goyupʉ to macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majãrẽ bairo camasãrẽ na quetibʉjʉesupʉ. Carotimasĩ cʉ̃ caĩquetibʉjʉrore bairo na quetibʉjʉyupʉ. Bairi cʉ̃ yaye quetire tʉ̃gori, to macããna pʉame tʉ̃gocõã maniásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mai, ti wii sinagoga ñubuerica wiipʉ ãñupʉ̃ jĩcãʉ̃ wãtĩ yeri pũna cacʉ̃goʉ. Bairo Jesús cʉ̃ cabueãno, wãtĩ yeri pũna cacʉ̃goʉ pʉame atore bairo bʉtioro qũĩ awajayupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Mʉ, Jesús Nazaret macããcʉ̃, ¿nopẽĩ mʉ atíati jãã tʉre? ¿Jããrẽ rei acʉ́ mʉ baiyati? Mʉrẽ yʉ masĩjãñuña. Mʉ, Dios macʉ̃, cañuʉ, mʉ ãniña —qũĩ awajayupʉ wãtĩ yeri pũna cacʉ̃goʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bairo cʉ̃ caĩrõ tʉ̃go, qũĩñupʉ̃ Jesús: —¡Bʉsʉeticõãña! ¡Ãni caʉ̃mʉ rupaʉre witi ácʉ́ja! —qũĩñupʉ̃ Jesús wãtĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bairo cʉ̃ caĩrõ tʉ̃go, wãtĩ yeri pʉame caʉ̃mʉrẽ cʉ̃ yugui, bʉtioro awajari cʉ̃ witicoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bairo caʉ̃mʉrẽ cʉ̃ caátiere ĩñarã, nipetiro camasã qũĩña acʉacoasuparã. —¿Ñe to ãniñati cawãma Jesús cʉ̃ carotirije? ¡Nocãrõ caroaro majũ cʉ̃ masĩñati! ¡Wãtĩ yeri pũna cʉ̃ã cʉ̃ yʉcõãñama! —ãmeo ĩñuparã na majũ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","To bero cʉ̃ tʉ̃goyuparã camasã nipetiro ti yepa tʉ̃ni macããna, Jesús cʉ̃ caátiere, cʉ̃ camasĩrĩjẽrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bairo na quetibʉjʉ yaparo, na ñubuerica wiire witicoásúpʉ Jesús. Ti wiire witiá, Santiago, bairi Juan mena acoásúpʉ Jesús, Simón, bairi cʉ̃ bai Andrés ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mai, Simón mañicõ pʉame riajãñuñupõ. Bʉtioro bʉgoyupo. Bairi cʉ̃ cajããrõ, cʉ̃ quetibʉjʉyuparã cabʉcʉo cõ cariarijere. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bairo na caĩquetibʉjʉro tʉ̃go, cõtʉ eta, cõ wãmo mena ñerĩ cõ tʉ̃gãwãmʉoñupʉ̃. Bairo cʉ̃ caáto, jicoquei jãnacoasuparo bʉgoye pʉame. Tocãrõã caticoasupo yua. Bairo catiáco, tocãrõã ʉgarique na qũẽnonuñupõ Jesujããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Cabero muipʉ cʉ̃ cajããrĩpaʉ, canaio atípaʉ caãno Simón ya wiipʉre etayuparã nipetiro ti macã macããna. Nipetirije cariayecʉnarẽ na jeasúparã Jesús tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bairo Jesús pʉame na caetaro ĩña, capããrã cariarãrẽ na catioyupʉ. Nipetirije riaye cacʉ̃gorãrẽ na catioyupʉ. Tunu bairoa wãtĩ yeri pũnarẽ na acurewiyojoyupʉ Jesús. Bairo na cawitiro, Jesús pʉame na bʉsʉrotiesupʉ. “Yʉ, Mesías, Dios cʉ̃ cajoʉ yʉ caãnierẽ na quetibʉjʉeticõãto,” ĩ, bairo na bʉsʉrotiesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ape rʉ̃mʉ cabusuatípaʉ Jesús wãcã, ti macãrẽ witicoásúpʉ. Bairo ácʉ́ yua, etayupʉ Jesús camasã na camanipaʉpʉ. Topʉ Diore cʉ̃ jẽniñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bairo topʉ cʉ̃ caãno, Simojãã cʉ̃ macãrásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bairo cʉ̃ macãrĩ, cʉ̃ etacoasuparã. Atore bairo qũĩñuparã: —Nipetirã mʉrẽ macãrã átiyama. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bairo na caĩrõ tʉ̃gomicʉ̃ã, bairo na ĩñupʉ̃ Jesús: —Ape macãã macããna cʉ̃ãrẽ na yʉ quetibʉjʉgʉ. Caroa quetire, Dios cʉ̃ carotimasĩrĩpaʉ caetarore na yʉ quetibʉjʉ masĩõgʉ. Torecʉna, yʉ jowĩ Dios ati yepapʉre —na ĩñupʉ̃ Jesús Simojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cabero áñesẽãñupʉ̃ Jesús Galilea yepapʉ. Topʉ áñesẽã yua, tocãnacã macã macããna na cañubueri wiiripʉ, sinagogas na caĩrĩ wiiripʉre buenucũñupʉ̃ to macããnarẽ. Tunu bairoa wãtĩ yeri pũnarẽ na acurewiyojoyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bairo cabero caʉ̃mʉ jĩcãʉ̃ carupaʉ boaʉ pʉame Jesutʉ cʉ̃ rʉpopaturi mena etanumurĩ qũĩroaʉ etayupʉ. Bairo eta, atore bairo qũĩ jẽniñupʉ̃: —Yʉ Quetiupaʉ, mʉ cabooata, yʉ mʉ netõõgʉ yʉ caboariaye cʉtiere. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bairo cʉ̃ caĩjẽnirõ tʉ̃go, cʉ̃ maitʉ̃goñañupʉ̃ Jesús cʉ̃ rupaʉ caboaʉre. Bairi cʉ̃ wãmo mena cʉ̃ pãñañupʉ̃. Bairo áticõã, bairo qũĩñupʉ̃: —Mʉ cacatiro yʉ boya. ¡Bairi mʉ yʉ netõõña! —qũĩñupʉ̃ Jesús cariaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","43","Bairo Jesús cʉ̃ caĩrõ, jicoquei caticoasupʉ carupaʉ boamiatacʉ. Bairo cʉ̃ cabairo ĩña, Jesús pʉame tutuaro mena cʉ̃ quetibʉjʉ rotiesupʉ aperãrẽ cʉ̃ cabaiatajere. Bairo qũĩñupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Cariape acoácʉ́ja sacerdote tʉpʉ. Qũĩñoña mʉ rupaʉre, mʉ cacatiatajere. Bairo tunu Diore cʉ̃ nuniña mʉ cacatirije wapare. Tore bairo marĩ átirotiyupi Moisés ãnacʉ̃. Bairo mʉ caátiatato bero, nipetiro camasã masĩgarãma mʉ cacatiatajere yua —qũĩñupʉ̃ Jesús carupaʉ boamiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, cʉ̃, carupaʉ boamiatacʉ pʉame Jesús cʉ̃ carotiata wãmerẽ bairo ápeyupʉ. Nipetirã na quetibʉjʉ peyocõãñupʉ̃ cʉ̃ cabaiatajere. Bairi Jesús pʉame jããmasĩẽsupʉ tocãnacã macããrẽ. Bairi macãã tʉ̃nipʉ camasã na cañesẽãetopʉ ásúpʉ. Bairo cʉ̃ cabaimiatacʉ̃ãrẽ, cʉ̃ macãrã, cʉ̃ bocacõãñuparã ti macãã macããna Jesure yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nocãnacã rʉ̃mʉ bero mea tunucoásúpʉ Jesús Capernaum macãpʉ. Topʉ cʉ̃ caãno, aperã, “Ti wiipʉ ãcʉ̃mi,” ĩrĩqũẽ queti tʉ̃goyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Capããrã camasã neña etayuparã. Bairo na cabairo, Jesús na bueyupʉ. Ti wiire jira netõcoasuparã. Jope tʉpʉa jira etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bairo cʉ̃ cabueãno, ti macã macããna cawãmarã baparicãnacãʉ̃ Jesutʉ ñicãrĩ cabʉʉricʉre cʉ̃ neasúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bairo cʉ̃ ne etamirãcʉ̃ã, ti wii pupeapʉ na yaʉre cʉ̃ nejãã masĩẽsuparã, camasã capããrã na cajiraro jʉ̃gori. Bairi wii buipʉ wãmʉcoásúparã ñicãrĩ cabʉʉricʉ mena. Ti wii buipʉ etarã, ope qũẽnorĩ cʉ̃ piti ruio joyuparã pũʉ̃ rʉpowẽrĩ mena Jesús tʉpʉ ñicãrĩ cabʉʉricʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bairo na caáto ĩña, Jesús pʉame tʉ̃goña masĩñupʉ̃ na catʉ̃goñarĩjẽrẽ. “Yʉ camasĩrĩjẽrẽ cariape tʉ̃goñatutuayama,” na ĩ tʉ̃goñañupʉ̃. Torecʉ, atore bairo qũĩñupʉ̃ Jesús ñicãrĩ cabʉʉricʉre: —Yʉ yaʉ, merẽ mʉ carorije wapare yʉ netõõcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bairo cʉ̃ caĩrõ tʉ̃go, ti wii macããna caruirã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame bairo ĩ tʉ̃goñañuparã na yeripʉ: ");
INSERT INTO cbcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ñamʉ ũcʉ̃ majũ caʉ̃mʉ cʉ̃ ãniñati, ‘Merẽ mʉ carorije wapare yʉ netõña,’ caĩã? Dios jeto netõõmasĩñami marĩ carorije wapare. Ãni, Jesús, Diore cʉ̃ netõnʉcãʉ̃ átiyami, bairo cʉ̃ caĩrĩjẽ mena,” ãmeo ĩ bʉsʉyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jicoquei masĩcõãñupʉ̃ Jesús cʉ̃ yeripʉ na caãmeobʉsʉrijere. Bairi atore bairo na ĩñupʉ̃: —¿Nopẽĩrã yʉ caĩatajere tʉ̃gori mʉjãã tʉ̃goñarĩqũẽ paiyati? ");
INSERT INTO cbcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","“Mʉ carorije wapare yʉ netõña,” ãnirẽ yʉ caĩata, “Bairo ĩcõãʉ̃ ĩñami,” mʉjãã ĩbujiorã. Bairãpʉa, “Wãmʉnʉcãña. Mʉ cacũñarĩ coro nepʉsari mʉ ya wiipʉ tunu ácʉ́ja,” cʉ̃rẽ yʉ caĩata, to bero cʉ̃ cawãmʉnʉcáto ĩñarã roque, “Bairo ĩcõãʉ̃ mee ĩñami Jesús,” mʉjãã ĩbujiorã. Yʉ, Camasã Jʉ̃gocʉ ati yepapʉ yʉ carotimasĩrĩjẽrẽ mʉjãã camasĩparore bairo, tiere ñigʉ —na ĩñupʉ̃ Jesús fariseojããrẽ. Ĩ yaparo, cʉ̃ caĩrõrẽ bairo qũĩnemoñupʉ̃ Jesús ñicãrĩ cabʉʉricʉre: ");
INSERT INTO cbcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mʉrẽ ñiña: ¡Wãmʉnʉcãña! Mʉ cacũñarĩ coro nepʉsari mʉ ya wiipʉ tunu ácʉ́ja. Merẽ mʉ riayere yʉ netõña —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei wãmʉnʉcã yua, cʉ̃ cacũñarĩ corore nepʉsa, ti wiire witicoásúpʉ cʉ̃ ñicãrĩ cabʉʉmiatacʉ pʉame nipetirã na caĩñarõ. Bairo cʉ̃ caátó ĩñarã, nipetiro camasã tʉ̃goñacõã maniásuparã. Bairi Diore atore bairo qũĩ basapeoyuparã: —¿Diwatoa ũno tore bairo caroa majũrẽ marĩ ĩñarĩ? Marĩ ĩñaepʉ̃. ¡Camasĩ niñami Dios! —qũĩ basapeoyuparã nipetirã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Cabero ásúpʉ tunu Jesús ʉtabʉcʉra tʉ̃nipʉ. Topʉ camasã neñañuparã. Bairo na caneñarõ, na bueyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bairo netõácʉ́, Leví cawãmecʉcʉ, Alfeo macʉ̃rẽ qũĩñajoyupʉ. Mai, Leví pʉame Roma gobiernorẽ camasã yaye dinero impuesto na caĩrĩjẽrẽ jejobojari majõcʉ ãñupʉ̃. Bairi cʉ̃ capaari arʉapʉ cʉ̃ caãno, qũĩñajoyupʉ Jesús Levíre. Bairo qũĩñajori bero, cʉ̃tʉ etaátí, atore bairo qũĩñupʉ̃ yua: —Jito, yʉ bapacʉsa. Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei Leví pʉame cʉ̃ yaye paarique nipetirore cũcõã, Jesús mena bapacʉti ácʉ acoásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cabero Jesús, bairi cʉ̃ cabuerã mena Leví ya mesapʉ na caruiro, camasã capããrã ruirã etayuparã. Na mena macããna jĩcããrã Leví ũna, gobiernorẽ camasã yaye dinerore cajejobojari majã ãñuparã. Aperã camasã roro na cabʉsʉpairã cʉ̃ã ãñuparã. Jesujãã mena ʉgabapacʉsuparã. Mai, capããrã ãñuparã Jesure catʉ̃goʉsari majã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bairo cʉ̃ caʉgabapacʉtore ĩñarã yua, fariseo majã pʉame na ĩ tutiyuparã Jesús cʉ̃ cabuerãrẽ. Na yarã, Moisés cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena atore bairo na ĩ tutiyuparã: —¿Nopẽĩ dinero jejori majã mena, bairi aperã roro caána mena mʉjããrẽ cabuei cʉ̃ etiʉga bapacʉtiyati? Roro ácʉ átiyami —na ĩ tutiyuparã fariseojãã Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bairo na catutiro tʉ̃go, bairo na ĩñupʉ̃ Jesús: —Ʉcotiri majõcʉre bairo yʉ ãniña ati wiire. Ʉcotiri majõcʉ ápériyami cacatirã na caãni wiiripʉre. Cariarã na caãni wiiri jetore etanucũñami, na ʉcoti etaʉ. Bairi ãnoa mena yʉ ãniña. Na carorije, riayere bairo caãnierẽ netõõʉ̃ ácʉ yʉ atíapʉ. Torecʉna, yʉ apʉ́ ati yepapʉre. “Caroarã marĩ ãniña,” caĩtorãrẽ na yʉ macãẽtĩña. Aperã, “Carorije wapa marĩ buicʉtiya,” caĩtʉ̃goña yapapuarã roquere na macãʉ̃acʉ́ yʉ apʉ́, na yeri wasoaáto, ĩ —na ĩ quetibʉjʉyupʉ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tiwatoa caãnopʉre Juan cʉ̃ cabuerã, bairi fariseo majã na cabuerã cʉ̃ã ʉgarique betiri Dios jetore cʉ̃ jẽniñuparã. Bairo na cabairo ĩña, jĩcããrã Jesutʉ etari atore bairo qũĩ jẽniñañuparã: —Ʉgarique betiri Dios jetore cʉ̃ jẽninucũñama Juan cʉ̃ cabuerã. Fariseo majã na cabuerã cʉ̃ã tore bairo átiyama na cʉ̃ã. Mʉ cabuerã pʉame áperiyama. ¿Nopẽĩrã na ʉgarique betietinucũñati? —qũĩ jẽniñañuparã to macããna Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Caroaro yʉ caátiere mʉjãã tʉ̃gomasĩẽtĩña. Caʉ̃mʉ cawãmojiyapaʉre bairo yʉ ãniña. Cʉ̃ yarãrẽ bairo niñama yʉ cabuerã. Caʉ̃mʉ cʉ̃ cawãmojiyari rʉ̃mʉrẽ cʉ̃ yarã nipetirã ʉgayama pairo, cʉ̃ mena ʉseaniãna. Ti rʉ̃mʉrẽ aʉatãmʉoetiyama. Caʉ̃mʉ cʉ̃ cawãmojiyaro bero roquere, cʉ̃ yarã caborã ʉgarique betiri Diore cʉ̃ tʉ̃goña jẽniñubuebujiorãma tunu. Narẽ bairo jãã ãniña. Bairi yʉ mena ãna, yʉ cabuerã aʉatãmʉoetigarãma. Yʉ camano roquere aʉatãmʉobujiorãma —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ĩ yaparo, “Yʉ yaye cawãma quetire cabʉcʉ macããjẽ mena tʉ̃goʉsa masĩã maniña,” ĩgʉ, atore bairi wãme na ĩcõña quetibʉjʉnemoñupʉ̃ Jesús tunu: —Cabʉcʉro jutirore cawori opere seretuetiyama camasã camasĩrã jutiro cawãma asero carʉgaeti asero mena. Bairo na caápata, ñuetigaro. Cose, ti aserore bopo na caáto, rʉgagaro. Rʉgari tʉ̃gãwonemogaro paijãñurõ cawãma asero pʉame cabʉcʉro jutirore. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tunu bairoa ʉse oco cawãma qũẽnoyaparoriquere piojãẽtĩnucũñama camasã cabʉcʉ poa waibʉcʉ asero poapʉre. Bairo na caápata, ti poa wocoagaro, tie oco capãmʉrõĩ. Ti poa macããjẽ yasigaro. Bairi ʉse ocore cawãma qũẽnoyaparoriquere piojãnucũñama camasã cawãma poa mena —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cabero judío majã na cayerijãrĩ rʉ̃mʉ caãno Jesujãã netõásúparã weseripʉ. Bairo netõáná, Jesús cʉ̃ cabuerã pʉame queyari trigo apeacarẽ jeri cacatirijerea ʉgajʉ̃goyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bairo na caáto ĩñarĩ, fariseo majã atore bairo qũĩ tutiyuparã Jesure: —¡Na ĩñañijate! ¿Mʉ cabuerã roro na caátiere miñaetiyati? Ati rʉ̃mʉ ũnorẽ paariquere bairo átiyama mʉ cabuerã, bairo trigo apeacarẽ jeʉgarã. Ati rʉ̃mʉ ũnorẽ caápericõãpee niña na caátie ũnierẽ —qũĩ tutiyuparã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Bairo na caĩtutiro tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —David ãnacʉ̃ queyamiácʉ́, ¿cʉ̃ caátajere na caquetibʉjʉcũrĩqũẽrẽ jĩcãni ũno mʉjãã ĩñaetinucũñati Dios ya tutipʉ? Mʉjãã ĩñanucũrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bairo baiyuparo: Abiatar cawãmecʉcʉ ãnacʉ̃, sacerdote majã quetiupaʉ cʉ̃ caãno, David pʉame jããetayupʉ Dios ya wiire cʉ̃ ʉ̃mʉa mena. Ʉgariquere macããrã, jããetayuparã. Bairi pan ãñuparõ, caroa Dios yaye majũ na caĩcũrĩqũẽ jeto. Tie pããrẽ sacerdote majã jetore na ʉgarotiyupʉ Moisés ãnacʉ̃. Bairo sacerdote majũ jeto na caʉgarije caãnimiatacʉ̃ãrẽ, tie pããrẽ ʉgari bero, cʉ̃ ʉ̃mʉa cʉ̃ãrẽ na batonuñupʉ̃ David. ");
INSERT INTO cbcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Tunu na ĩnemoñupʉ̃ Jesús fariseo majãrẽ: —Caroaro marĩ caãnipeere yerijãrĩcã rʉ̃mʉrẽ cũñupĩ Dios. Yerijãrĩcã rʉ̃mʉ pʉame marĩrẽ to rotiáto ĩ mee cũñupĩ Dios yerijãrĩcã rʉ̃mʉrẽ. Yʉ, Camasã Jʉ̃gocʉ ãnirĩ yʉ átirotimasĩña yerijãrĩcã rʉ̃mʉ cʉ̃ãrẽ camasã caroare na caátiãnipeere —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ape rʉ̃mʉ caãno tunu jããetayupʉ Jesús ñubuerica wiipʉ. Mai, topʉ ãñupʉ̃ jĩcãʉ̃ caricábʉricʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bairi to macããna pʉame Jesús cʉ̃ caátigarijere caroaro qũĩña ʉsayuparã, na quetiuparãrẽ bʉsʉjãgarã. “¿Yerijãrĩcã rʉ̃mʉrẽã cʉ̃ catioʉáti caricábʉʉre?” ĩ tʉ̃goñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Atore bairo qũĩñupʉ̃ caricábʉʉre Jesús: —Tiaya. Ato yʉ tʉpʉ asá. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bairo ĩ yaparoʉ, atore bairo na ĩ jẽniñañupʉ̃ tunu Jesús to macããnarẽ: —¿Ñerẽ marĩ ánaati ati rʉ̃mʉrĩ ũnorẽ, camasã na cayerijãrĩ rʉ̃mʉrĩrẽ? ¿Cañurĩjẽrẽ marĩ ánaati, o carorije pʉamerẽ marĩ ánaati? —na ĩ jẽniñañupʉ̃. Bairo na cʉ̃ cajẽniñamiatacʉ̃ãrẽ, cʉ̃ yʉesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bairi Jesús pʉame na asiayupʉ, na yeri na catʉ̃goñarĩjẽ na cawasoagaetie wapa jʉ̃gori. Bairo bai, atore bairo qũĩñupʉ̃ Jesús caricábʉricʉre: —Mʉ ricáre ñupoya. Bairo cʉ̃ caĩrõ, caricábʉricʉ pʉame cʉ̃ ricáre ñupooásupʉ. Tocãrõã cʉ̃ ricá ñucoasuparo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bairo cʉ̃ caáto ĩñarã, fariseo majã pʉame ti wiire witi yua, neñañuparã quetiupaʉ Herode majã mena. Bairo neñarã, “¿Dope bairo marĩ ánaati, Jesure pajĩãgarã?” ãmeo ĩ bʉsʉpaijʉ̃goyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Cabero ásúpʉ Jesús cʉ̃ cabuerã mena ʉtabʉcʉra tʉ̃nipʉ. Na bero ʉsayuparã capããrã Galilea yepa macããna. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judea macããna, Jerusalén macããna, Idumea macããna, Rio Jordán ape nʉgõã macããna, Tiro bairi Sidón macã tʉ̃ni macããna, capããrã Jesús bero ʉsayuparã. Ti yepa macããna capããrã cʉ̃ caátijẽñorĩjẽ quetire tʉ̃gorã, Jesure qũĩñagayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bairo na caãmeotuworijere ĩña, na jʉ̃goye ʉtabʉcʉrapʉ na árotiyupʉ Jesús cʉ̃ cabuerãrẽ, cũmuarẽ na caqũẽnoyuparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mai, capããrã camasãrẽ na catioyupʉ Jesús. Bairi aperã cariayecʉna cʉ̃ã ãmeo tuwori ʉtabijaro majũ cʉ̃ neñañuparã, Jesure cʉ̃ pãñagarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tunu bairo camasã wãtĩ yeri pũna cacʉ̃gorã Jesure na caĩñarõ cãnacãni, cʉ̃tʉ rʉpopaturi mena etanumurĩ atore bairo qũĩ awajayuparã: —¡Mʉ, Dios macʉ̃ mʉ ãniña! ");
INSERT INTO cbcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús pʉame bairo na caĩrõ, mai camasã cʉ̃rẽ na camasĩrõ boetiri, tutuaro mena tiere na bʉsʉrotiesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cabero Jesús ʉ̃tãʉ̃pʉ etari cʉ̃ cabueparã cʉ̃ caĩñajesorãrẽ na piineñojoyupʉ. Bairo cʉ̃ capiineñojoro tʉ̃go, cʉ̃ tʉpʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bairo na caetaro ĩña, na beseyupʉ pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ, cʉ̃ mena na cabapacʉtiparore bairo ĩ, tunu bairo na cajʉquetibʉjʉparore bairo ĩ. Bairo na bese yaparo yua, “Mʉjãã yʉ caquetibʉjʉrotijoparã mʉjãã ãnigarã,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bairo ĩ yaparo yua, wãtĩ yeri pũnarẽ wiyomasĩrĩqũẽrẽ na joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bairi pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ ãñuparã Jesús cʉ̃ caquetibʉjʉrotijoparã. Cajʉ̃goye ãñupʉ̃ Simón. Simorẽã qũĩñupʉ̃ tunu “Pedro”. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tunu cabero ãñuparã Santiago, bairi cʉ̃ bai Juan cawãmecʉcʉ. Naa, Zebedeo pũnaa ãñuparã. Bairi Santiagore bairi Juarẽã qũĩñupʉ̃ Jesús tunu “Boanerges”. Mai, Boanerges, “Bupo Pũnaa” ĩgaro ĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tunu cabero ãñuparã Andrés, Felipe, Bartolomé, Mateo, Tomás, apei Santiago. Cʉ̃, Santiago, Alfeo macʉ̃ ãñupʉ̃. Tunu cabero ãñupʉ̃ apei Simón. Cʉ̃ pʉame celotea mena macããcʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tunu cabero ãñupʉ̃ Judas Iscariote. Cʉ̃ pʉame ãñupʉ̃ Jesure cañerotipaʉ. Tocãrõã niñama Jesús cʉ̃ caquetibʉjʉrotijoparã, cʉ̃ cabesericarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cabero wiipʉ jãásúpʉ Jesús tunu. Topʉ capããrã camasã neña etayuparã. Torecʉ, Jesús cʉ̃ cabuerã mena ʉgamasĩẽsupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bairo, “Mecʉ̃coayami Jesús,” camasã na caĩrĩjẽ quetire tʉ̃gori, cʉ̃ yarã pʉame cʉ̃ piirásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bairo Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cabueri majã pʉame Jerusalén macã caatíatana, atore bairo ĩñuparã: “Dios jʉ̃gori mee, Beelzebú, wãtĩã quetiupaʉ majũ cʉ̃ camasĩõrĩjẽ jʉ̃gori wãtĩ yeri pũna, camasãrẽ caãnarẽ na acurewiyojo masĩĩmi Jesús. Beelzebú cʉ̃ jããrĩcʉ̃mi Jesure,” ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús pʉame masĩcõãñupʉ̃ na catʉ̃goñarĩjẽrẽ. Bairi cʉ̃tʉ na piijoyupʉ. Bairo piijo yaparo, ape wãme ĩcõñarĩ atore bairo na ĩñupʉ̃: “¿Dope bairo wãtĩ cʉ̃ majũã cʉ̃ acurocawiyo masĩcʉti?” ");
INSERT INTO cbcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Quetiupaʉ rey cʉ̃ carotimasĩrĩpaʉ macããna na caãmeoboeticõãta, jĩcãrõ ãnimasĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tunu bairoa jĩcã wii macããna na caãmeoboeticõãta, na cʉ̃ã caroaro ãnimasĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tore bairo Satanás, wãtĩã quetiupaʉ, cʉ̃ yarãrẽ na cʉ̃ caboeticõãta, ¿dope bairo cʉ̃ ãninetõʉ̃ati? Ãninetõmasĩẽcʉ̃mi. Yasicoacʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bairo ĩ quetibʉjʉ yaparo, cajerutiri majõcʉre ĩcõñarĩ atore bairo na ĩ quetibʉjʉnemoñupʉ̃ tunu: “Jĩcãʉ̃ wii upaʉ, catutuaʉ majũ, cʉ̃ ya wii macããjẽrẽ caroaro cʉ̃ caĩñacoteata, ni ũcʉ̃ cajerutiri majõcʉ cʉ̃ yayere jerutimasĩẽcʉ̃mi. Jerutimasĩĩmi baipʉa, ti wii upaʉre cʉ̃ cajiyajʉ̃goata. Bairo cʉ̃ jiyajʉ̃gori bero roque, ti wii macããjẽ nipetirijere jerutipeyo masĩcõãʉ̃mi,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Bairi cariape mʉjããrẽ ñiña: Cabʉsʉpairã dope bairo roro na caĩrĩjẽ tocãnacã wãmerẽ masiriyogʉmi Dios, cʉ̃rẽ na cajẽniata. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bairo masiriyobojamicʉ̃ã, Espíritu Santore roro na cabʉsʉpaiata roquere, na masiriyobojaetigʉmi. Roro na cabʉsʉpairije wapa na cabuicʉtie nicõã ninucũgaro tocãnacã rʉ̃mʉa. Petietigaro.” ");
INSERT INTO cbcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mai, na pʉame qũĩ jʉ̃goyuparã: “Wãtĩ, cʉ̃ jããrĩcʉ̃mi Jesure.” Bairi tore bairo na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bairo cʉ̃ caquetibʉjʉro bero, Jesús paco, bairi cʉ̃ bairã cʉ̃ã topʉ etayuparã. Eta yua, cʉ̃ caãni wii macãpʉa cʉ̃ cotenucũñuparã. Bairo cotenucũrã, cʉ̃ piirotiyuparã, cʉ̃ mena bʉsʉgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bairo macãpʉ na cacotenucũrõ, Jesutʉ macããna carupa beto caruiãmejorerã pʉame atore bairo qũĩñuparã Jesure: —Mʉ paco, mʉ bairã mʉ macãũparã. Macãpʉ mʉrẽ coterã átiuparã —qũĩñuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús cʉ̃rẽ caquetibʉjʉrãrẽ: —Naa, yʉ paco, yʉ bairã cʉ̃ã, yʉ yarã majũ na caãnimiatacʉ̃ãrẽ, aperã cʉ̃ã, yʉ yarãrẽ bairo caãna niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ĩ quetibʉjʉ yaparo, cʉ̃tʉ macããna caruirãrẽ na ĩñarĩ, atore bairo na ĩnemoñupʉ̃ tunu: —Ãnoa niñama yʉ pacore bairo caãna, bairi yʉ bairãrẽ bairo caãna. ");
INSERT INTO cbcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Noa ũna yʉ Pacʉ cʉ̃ carotirore bairo caána pʉame yʉ bairãrẽ bairo caãna, bairi yʉ bairã rõmirĩrẽ bairo caãna, bairi yʉ pacore bairo caãna niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Cabero acoásúpʉ Jesús ʉtabʉcʉra tʉ̃nipʉ. Topʉ eta, camasãrẽ na quetibʉjʉ jʉ̃goyupʉ tunu. Mai, camasã capããrã majũ na caãnoi, Jesús pʉame cũmua turorica capairicapʉ ájããñupʉ̃. Cʉ̃tʉ catʉ̃gorã etarã pʉame peta paputiropʉ nucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bairo na cabairo, capee wãme ĩcõñarĩ na quetibʉjʉyupʉ Jesús. Atore bairo na ĩ quetibʉjʉyupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yʉ caquetibʉjʉrijere caroaro tʉ̃gopeoya. Jĩcã rʉ̃mʉ ásúpʉ jĩcãʉ̃ caʉ̃mʉ cʉ̃ wesepʉ, oteriquere otei ácʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Topʉ eta, cʉ̃ oteriquere wẽbato otejʉ̃goyupʉ. Bairo caroaro cʉ̃ caotemiatacʉ̃ãrẽ, oterique jĩcã rupaa ñañuparõ maapʉ. Bairo maapʉ ti rupaa cañarõ ĩñarã, minia pʉame wʉruiatí, ʉgarecõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Cabero cʉ̃ cawẽbatoro, ape rupaa ʉ̃tã yepapʉ cayepa esemenirõpʉ ñañuparõ. Tie pʉame yoaro mee putimiñuparõ, cayepa esemenirõ caãnoi. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bairo tie oterique pʉame pútiatímii yua, yoaro mee riacoásúparo muipʉ cʉ̃ caasijĩãrõĩ, dope bairo nʉcõõrĩ jomasĩẽtĩrĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Cabero cʉ̃ cawẽbatoro, ape rupaa pota yucʉ watoapʉ ñañuparõ. Cabero pota yucʉ pʉame cabʉtinetõrõ, tie oterique pʉame caroaro pútimasĩẽsuparo. Pota yucʉ pʉame otere bʉtibiacõãñuparõ. Bairi rícamani yucʉ ásuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Cabero ape rupaa pʉame caroa yepapʉ ñañuparõ. Cabero puti, bʉticoasuparo. Bairo bʉtiátó, jĩcã jatí treinta rupaa majũ rícacʉsuparo. Ape jatí sesenta rupaa majũ rícacʉsuparo. Ape jatí cien majũ rícacʉsuparo,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Mʉjãã caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ,” na ĩñupʉ̃ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cabero Jesús jĩcãʉ̃ã cʉ̃ caãno, cʉ̃tʉ macããna bairi cʉ̃ cabuerã cʉ̃ã cʉ̃tʉ eta yua, atore bairo qũĩ jẽniñañuparã: “¿Dope ĩgaro to ĩñati caotei queti?” ");
INSERT INTO cbcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bairo na caĩrõ tʉ̃go, atore bairo na ĩ quetibʉjʉyupʉ Jesús: “Dios cʉ̃ carotimasĩrĩpaʉ macããjẽrẽ tirʉ̃mʉpʉ macããna na catʉ̃goetajere mʉjãã roquere mʉjãã masĩõñami. Aperã tiere na camasĩrõrẽ boetiyami. Torecʉ, ape wãme ĩcõñarĩ na quetibʉjʉ rotiyami Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Na pʉame cacaapee cʉ̃gorã nimirãcʉ̃ã, Dios cʉ̃ caátiere ĩñamasĩẽtĩñama. Tunu bairoa cʉ̃ yaye quetire tʉ̃gomirãcʉ̃ã, tiere tʉ̃gomasĩẽtĩñama. Bairi Diore, ‘Jãã mʉ netõõwã,’ qũĩẽtĩnucũñama. Torena, carorije wapa cacʉ̃gorã tuayama Dios cʉ̃ caĩñajoro yua,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩ quetibʉjʉyupʉ tunu: “¿Caotei cʉ̃ caátajere ĩ cõñarĩ mʉjããrẽ yʉ caquetibʉjʉatajere mʉjãã tʉ̃gomasĩẽtĩati? Tiere mʉjãã camasĩẽtĩcõãta, ¿Dope bairo rita ape wãmerẽ mʉjãã masĩcʉti? Mʉjãã masĩẽna. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","15","Ãmerẽ yua, mʉjããrẽ yʉ quetibʉjʉgʉ caroaro ĩcõñarĩ caotei quetire camasãrẽ yʉ caquetibʉjʉatajere: Camasã jĩcããrã Dios yaye quetire tʉ̃goyama. Bairo tʉ̃gomirãcʉ̃ã, tʉ̃gomasĩẽtĩñama. Dios bʉsʉriquere na catʉ̃goatato beroaca, wãtĩ pʉame uwaro eta, jecõãñami na camasĩbujioatajere. Minia na cawʉje ʉgaricarore bairo etanecõãñami wãtĩ, na camasĩbujioatajere. Na pʉame caotei cʉ̃ caoterique maapʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Tunu aperã camasã Dios yaye quetire ʉseanirõ tʉ̃go, jicoquei, ‘Jaʉ,’ ĩñama. Bairo bomirãcʉ̃ã, bairãpʉa na yeripʉ caroaro cʉ̃ yʉetiyama. Capútirije canʉcõmanajẽrẽ bairo niñama. Bairi roro na cabairo caãno, o Dios yaye quetire na catʉ̃goʉsaro jʉ̃gori aperã narẽ na caĩñatero ĩñarã, yoaro mee jãnañama Dios yaye quetire yua. Dios mena yoaro ãmerĩñama. Naa, caotei cʉ̃ caoterique ape rupaa ʉ̃tã buipʉ cañarĩcã rupare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Tunu aperã camasã Dios yaye quetire, ‘Jaʉ,’ na caĩrõ bero, apeye ũnie pʉamerẽ bʉtioro tʉ̃goña macãñama. Ati yepa macããjẽ wapatarique ũnierẽ, bairi caroaro na caãnigarije cʉ̃ãrẽ tʉ̃goñañama bʉtioro. Bairi Dios bʉsʉriquere tʉ̃goña masiriticõãñama. Caroaro caánarẽ bairo na caáperoi, caríca bʉtimasĩẽtĩẽrẽ bairo niñama. Bairi naa, caotei cʉ̃ caoterique ape rupaa pota watoapʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bairãpʉa, aperã roque Dios yaye quetire ʉseanirõ tʉ̃goyama. Na yeri pũnapʉ cariape tʉ̃gopeori, tiere tʉ̃goʉsayama. Caotei cʉ̃ caoterique ape rupaa, caroa yepapʉ cañarĩcã rupaare bairo niñama. Jĩcã jatí treinta rupaa majũ rícacʉsuparo. Ape jatí sesenta rupaa majũ rícacʉsuparo. Ape jatí cien majũ rícacʉsuparo. Torea bairo niñama Dios yayere catʉ̃goʉsanucũrã pʉame,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ĩ yaparo, atore bairo na ĩ quetibʉjʉnemoñupʉ̃ Jesús tunu: “¿Camasã carupapata rocapʉ, o cama rocapʉ jĩñaworiquere na cũñati? Tore bairo cũẽtĩnucũñama. Jõbuipʉ roque cũnucũñama camasã, nipetiro cajããetarã na caĩñamasĩparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na cajĩñaworipaʉ nipetiro baugaro caĩñamaniataje. Torea bairo ape rʉ̃mʉpʉ camasã nipetiro ãme camasĩã manierẽ masĩpeticoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mʉjãã caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ.” ");
INSERT INTO cbcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Tunu atore bairo na ĩnemoñupʉ̃ Jesús: “Yʉ caquetibʉjʉrijere mʉjãã catʉ̃gopeoata, Dios pʉame mʉjããrẽ masĩõnemogʉmi tunu yʉ caquetibʉjʉrijere. Bairo tʉ̃gomirãcʉ̃ã, petoaca mʉjãã catʉ̃gopeoata roque, cabero mʉjãã camasĩmiatajere mʉjãã masiriticõãgarã. Bairi caroaro cariape tʉ̃gopeoya,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ĩ yaparo atore bairo na ĩ quetibʉjʉnemoñupʉ̃ tunu: “Dios yaye macããjẽrẽ quetibʉjʉrique, jĩcãʉ̃ camasocʉ yepapʉ otere cʉ̃ caoterijere bairo niña: ");
INSERT INTO cbcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ote yaparori bero, tie otere ĩñapeocõã ãmeimi. Bairi tocãnacã ñamia cãnii, tocãnacã rʉ̃mʉa ãnicõã, cʉ̃ cabaitoye, cʉ̃ caoterique pʉame puticoato. Bairi cʉ̃ pʉame dope bairo bairi caputirore masĩẽcʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Putiro, yoaro mee pũũ witiro. Pũũ witi yaparo, carupa jatí jeñarõ. Carupa jatí jeña yaparo, caríca wiyoro, tie bʉti carupa rupaa jeñarõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti rupaa cabʉtiro ĩña, jeimi tiere caotericʉ, ‘Tocãrõã bʉti yaparoya,’ ĩ. Torea bairo Dios yaye macããjẽrẽ quetibʉjʉrique cʉ̃ã niña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ Jesús tunu cʉ̃tʉ catʉ̃gorã etarãrẽ: “¿Dope bairo mʉjããrẽ yʉ masĩõñati Dios cʉ̃ carotimasĩrĩpaʉre? ¿Di wãme ũnorẽ ĩcõñarĩ mʉjããrẽ yʉ quetibʉjʉyati? ");
INSERT INTO cbcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Mostaza na caĩrĩ apeacarẽ jĩcãʉ̃ cʉ̃ wesepʉ cʉ̃ caotericaacarẽ bairo niña Dios cʉ̃ carotimasĩrĩpaʉ. Tia apeacã pʉame õcããcã majũ nimirõcʉ̃ã, cabero puti bʉtiátó, pairicʉ majũ áya, nipetirije wesepʉ oterique netõrõ. Paca majũ rʉpʉri cʉtiya. Bairi minia cʉ̃ã tii yucʉ rʉpʉripʉre na ria batiirire qũẽnorĩ nicõãmasĩñama. Torea bairo niña Dios cʉ̃ carotimasĩrĩpaʉ cʉ̃ã,” na ĩcõña quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Torea bairo jeto capee wãme ĩcõñarĩ na quetibʉjʉnucũñupʉ̃ Jesús nipetiro camasã cʉ̃tʉ catʉ̃gorã etarãrẽ. Na camasĩjĩãtiparo cãrõ caroaro na quetibʉjʉyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dise ũnie quetibʉjʉriquere ĩcõñaetiri na quetibʉjʉesupʉ. Baipʉa, aperã na camano na catʉ̃goetopʉ cʉ̃ cabuerã pʉamerã nipetiro caroaro tʉ̃gojĩãtipetiricaro na quetibʉjʉnucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cabero ti rʉ̃mʉ muipʉ cʉ̃ cajããtõ, Jesús pʉame atore bairo na ĩñupʉ̃ cʉ̃ cabuerãrẽ: —Jito, ati ʉtabʉcʉra ape nʉgõãpʉ marĩ pẽña átóca. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bairo cʉ̃ caĩrõ bero, cʉ̃ cabuerã ájããñuparã cũmua cʉ̃ cajãatacapʉ, ape nʉgõãpʉ pẽñagarã. Bairo na caátó, aperã cʉ̃ã na cũmu rupaa mena Jesujãã bero ʉsa asúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bairo na caátó yua, wĩno pairo papu atíjʉ̃goyuparo. Bairo capapuro ocoturi pairo atíjabejããñuparõ, cũmua ruagari tʉ̃nipʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mai, Jesús pʉame na caátó beroaca, cũmua cawaturo pʉame jutipoti buipʉ cãnijããcoasupʉ. Bairo cʉ̃ cabairoi, cʉ̃ cabuerã pʉame cʉ̃ wãcõñuparã. Cʉ̃ wãcõrĩ atore bairo qũĩñuparã Jesure: —¡Jããrẽ cabuei, ruarã marĩ baiya! ¿Mʉ tʉ̃goñaẽtĩñati jããrẽ? —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bairo na caĩrõ tʉ̃gowãcã, wãmʉnʉcãñupʉ̃ Jesús. Wãmʉnʉcã, wĩnorẽ jãnarotiyupʉ. Tunu bairoa oco turi cʉ̃ãrẽ: —¡Jãna átoja! —ĩñupʉ̃. Bairo cʉ̃ caĩrõ, jicoquei jãnapeticoasuparo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Cabero atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —¿Nopẽĩrã bʉtioro mʉjãã uwiyati? ¿Dios mena mʉjãã tʉ̃goña tutuaetiyati mai? —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cʉ̃ cabuerã pʉame cʉ̃ caáto ĩñaacʉacoasuparã. Atore bairo ãmeo ĩñuparã na majũ: —¡Ago tame! ¡Nocãrõ majũ cʉ̃ masĩñati Jesús! Wĩno, ocoturi cʉ̃ã cʉ̃ tʉ̃gocõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cabero ti ʉtabʉcʉra ape nʉgõãpʉ pẽña etayuparã Jesujãã, Gerasa na caĩrĩ yepapʉ. Bairo eta yua, maa nʉcãñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bairo cʉ̃ camaa nʉcãrõ, caʉ̃mʉ jĩcãʉ̃, wãtĩ yeri pũna cacʉ̃goʉ pʉame cʉ̃tʉ etayupʉ. Camasãrẽ na carerica ʉ̃tã wiiripʉ caãniatacʉ cʉ̃tʉ etayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Mai, cʉ̃ pʉame ʉ̃tã wiiripʉ ninucũñupʉ̃. Cauwioʉ majũ ãñupʉ̃. Bairi camasã pʉame cʉ̃ ñesẽãrotietimiñuparã. Cʉ̃ wãmorĩrẽ, bairi cʉ̃ rʉpori cʉ̃ãrẽ ãpõã wẽẽrĩ mena nairõ cʉ̃ jiyanucũmiñuparã. Bairo na caátimiatacʉ̃ãrẽ, cʉ̃ pʉame ãpõã wẽẽrĩrẽ tʉ̃gãjure recoanucũñupʉ̃. Bairi ni ũcʉ̃ cʉ̃ átinetõnʉcã masĩẽsupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bairi ʉmʉrecóo caãno cãrõ, ñami cʉ̃ãrẽ bairo roro ñesẽãcõãnucũñupʉ̃ ʉ̃tã yucʉ buiripʉ. Camasãrẽ na carericaropʉ awaja ñesẽãnucũñupʉ̃. Bairi ʉ̃tã ruparire ñosẽ ñesẽãnucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bairo Jesure cayoaropʉ ĩñajoʉna, cʉ̃tʉ atʉeta, rʉpopaturi mena etanumuñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesús pʉame atore bairo qũĩñupʉ̃ wãtĩ yeri pũnarẽ: —¡Wãtĩ, jicoquei cʉ̃ witi ácʉ́ja! —qũĩñupʉ̃. Bairo cʉ̃ caĩrõã, wãtĩ yeri pũna cacʉ̃goʉ pʉame awajarique mena atore bairo qũĩ awajayupʉ: —¡Mʉ, Dios jõbui macããcʉ̃ macʉ̃ mʉ ãniña! ¿Ñerẽ ácʉ mʉ atíyati yʉtʉre? ¡Popiye yʉ cabaipeere ápericõãña! —bʉtioro qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","10","Bairo cʉ̃ caĩrõ tʉ̃go, qũĩ jẽniñañupʉ̃ Jesús wãtĩ yeri pũnarẽ: —¿Ñamʉ mʉ wãmecʉtiyati? Bairo cʉ̃ caĩrõ tʉ̃go, qũĩñupʉ̃ wãtĩ yeri pũna Jesure: —Jãã, capããrã jãã niña. Bairi yʉ wãme, Legión yʉ ãniña. ¡Jããrẽ ape macãpʉ jãã mʉ joepa! —bʉtioro qũĩñupʉ̃ wãtĩ yeri pũna Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mai, totʉ ʉ̃tãʉ̃pʉ capããrã yesea nurĩcãrã ʉgarã ásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bairo na caʉgaãno, wãtĩ yeri pũna pʉame atore bairo bʉtioro qũĩñuparã Jesure: —¡Yeseapʉre jããrẽ jãárotiya! Napʉre jãã jããgarã —bʉtioro qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bairo na caĩrõ tʉ̃go, “¡Jaʉ! Topʉ ánája toroque,” na ĩñupʉ̃ Jesús, na ároti yua. Bairo cʉ̃ caĩrõ, wãtĩ yeri pũna pʉame caʉ̃mʉrẽ cʉ̃ witipeticoásúparã. Yeseapʉre jããrásúparã. Bairo yeseare na cajããrĩpaʉ yua, yesea ʉ̃tãʉ̃ bui caãnimiatana pʉame mecʉ̃rã ʉtabʉcʉrapʉ atʉre ñañuacoásúparã. Bairi yua, ruapeticoasuparã yesea pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bairo na cabairo ĩña, yeseare cacotemiatana pʉame acʉari acoásúparã. Macãpʉ etacoasuparã. Topʉ na quetibʉjʉyuparã nipetiro yesea na cabaiatajere. Macã tʉ̃ni macããna cʉ̃ãrẽ na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bairo tiere tʉ̃gori, camasã pʉame ĩñarásúparã cabaiatajere. Bairo topʉ etarã, qũĩña acʉacoasuparã capããrã wãtĩ yeri pũnarẽ cacʉ̃gomiatacʉre. Cʉ̃ pʉame jutii jãñarĩ, caroaro tʉ̃goñarĩqũẽ mena ruiyupʉ. Bairi dope bairo cʉ̃ cabaiatajere masĩẽna, uwijãñuñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bairo baicõã, caĩñaatana pʉame, na quetibʉjʉyuparã caetarãrẽ. Wãtĩ yeri pũnarẽ cacʉ̃gomiatacʉ cʉ̃ cabaiataje, bairi yesea na cabaiataje cʉ̃ãrẽ na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bairo na caquetibʉjʉro, bʉtioro Jesure cʉ̃ uwiri, atore bairo bʉtioro qũĩñuparã: “¡Tunu ácʉ́ja mʉ caatíatatopʉ!” qũĩñuparã Jesure to macããna, Gerasa yepa macããna. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bairo na caĩrõĩ, Jesús pʉame cũmuarẽ ájããñupʉ̃ tunu cʉ̃ cabuerã mena. Bairo cʉ̃ caájããrõ, wãtĩ yeri pũnarẽ cacʉ̃gomiatacʉ pʉame bʉtioro qũĩñupʉ̃ Jesure: “¡Jesús, mʉ mena yʉ ágaya bʉtioro!” qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bairo cʉ̃ caĩrõ, Jesús qũĩñupʉ̃ tunu: —¡Yʉ yaʉ, tuaya! ¡Mʉ ya macã pʉame tunu ácʉ́ja! Topʉ etaʉ, mʉ yarã to macããnarẽ na quetibʉjʉya marĩ Quetiupaʉ Dios mʉrẽ mairĩ caroaro mʉ cʉ̃ caátiatajere —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bairo cʉ̃ caĩrõ tʉ̃go, tunucoásúpʉ cʉ̃ ya macãpʉ. Topʉ etaʉ, nipetirã Decápolis na caĩrĩ macãã macããnarẽ na quetibʉjʉyupʉ Jesús cʉ̃ caátiatajere. Tiere tʉ̃gori nipetiro camasã tʉ̃go acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bairo cabero Jesús ti ʉtabʉcʉrare cʉ̃ capẽñaetaro, capããrã camasã cʉ̃ coteyuparã. Bairo cʉ̃ caetaro ĩña, cʉ̃ cacoteatana pʉame capããrã cʉ̃tʉ neñapoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bairo Jesús cʉ̃ camaa nʉcãrõ, cʉ̃tʉ etayupʉ caʉ̃mʉ jĩcãʉ̃, Jairo cawãmecʉcʉ. Jairo pʉame camasã na cañubueri wii sinagoga quetiupaʉ ãñupʉ̃. Torecʉ cʉ̃tʉ eta, rʉpopaturi mena eta numurĩ Jesure qũĩroayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Atore bairo qũĩñupʉ̃: —¡Jesús, yʉ macõ riácópʉ baiamo! Mʉ wãmo mena cõrẽ ñigã peoñaʉ asá, cõ cacaticoaparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bairo cʉ̃ caĩrõ tʉ̃go, Jairo mena acoásúpʉ Jesús. Bairo cʉ̃ caátó, camasã pʉame ʉtabijaro majũ cʉ̃ ʉsayuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mai, na mena macããcõ jĩcãõ cariíjãnaecõ ãñupõ. Yoaro, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã cʉ̃marĩ majũ tiere riayupo. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Capããrã caʉcotiri majã cõ ʉcotimiñuparã. Na caʉcotimiatacʉ̃ãrẽ, cõ tʉ̃goesuparo. Bairo na caátimiatacʉ̃ãrẽ, jĩrĩã netõrõ roro majũ baiyupo. Tunu bairo cõ cacʉ̃gorijeacarẽ na nunire peyocõãñupõ ʉco wapa. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bairo baicõã yua, tʉ̃goñañupõ cõ pʉame Jesús cʉ̃ camasĩrĩjẽrẽ, cʉ̃ cariaye netõrĩjẽrẽ. Bairo tiere tʉ̃goñarĩ, Jesús bero pʉame asúpo. Bairo cʉ̃ bero atí yua, cʉ̃ jutirore tuañañupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mai, cõ pʉame cariape tʉ̃goñañupõ Jesús cʉ̃ cariaye netõmasĩrĩjẽrẽ. Bairo cariape tʉ̃goñarĩ yua, “Cʉ̃ jutiro cayoaro yapaacarẽ yʉ capãñaata, yʉ caticoago,” ĩ tʉ̃goñañupõ. Bairo tiere ĩ tʉ̃goñarĩ, Jesús bero pʉame atíri, tore bairo ásupo. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bairo cõ caáto, tocãrõã jicoquei caticoasupo. Cõ cariípetirije riaye jãnacoasuparo. Bairi cõ pʉame tocãrõã masĩcõãñupõ cõ riaye canetõrĩjẽrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús pʉame, “Yʉ camasĩrĩjẽ jʉ̃gori jĩcãõ cõ cariaye cʉtiere yʉ netõãpʉ̃,” ĩ masĩñupʉ̃. Bairo masĩrĩ, atore bairo na ĩñupʉ̃ Jesús cʉ̃tʉ caãna camasãrẽ: —¿Noa na tuañaati yʉ jutirore? —na ĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ cabuerã pʉame atore bairo qũĩñuparã Jesure: —Jãã cabuei, rita ãnoa camasã capããrã niñama. Bairi mʉ tunerocayama noo na caboro. Nana na caátiere mi bauya —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bairo na caĩrõ tʉ̃gomicʉ̃ã, cõ ĩñamacãñupʉ̃, cʉ̃rẽ capãñaatacore masĩgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bairo ĩñamacã cʉ̃ cabaiãno, cariamiataco pʉame, cõ cacatiatajere masĩrĩ, tunu bairi uwitʉ̃goñarĩ, Jesutʉ etayupo. Rʉpopaturi mena Jesús rʉpori tʉpʉ etanumuñupõ. Bairo etanumurĩ, nipetirije cõ cabaiatajere Jesure cʉ̃ quetibʉjʉyupo. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bairo cõ caĩquetibʉjʉro bero, cõ ĩñupʉ̃ Jesús: —Yʉ yao, yʉ camasĩrĩjẽrẽ cariape mʉ tʉ̃goñaupa. Bairi mʉ riayere yʉ netõõcõãña. Tunu ácója ʉseanirĩqũẽ mena —cõ ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bairo cʉ̃ caĩãnitoyea, jĩcããrã etayuparã, Jairo ya wii macããna pʉame. Jairore qũĩ quetibʉjʉrã etayuparã: —Mʉ macõ merẽ baiyasicoaamo. Bairi tocãrõã cʉ̃ patowãcõña marĩrẽ cabueire —qũĩ quetibʉjʉyuparã Jairore. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bairi Jesús cʉ̃ã cʉ̃ caĩrĩjẽrẽ tʉ̃goyupʉ. Bairo tʉ̃gori, atore bairo qũĩñupʉ̃ Jairore: —Jairo, tʉ̃go acʉaeticõãña. Dios cʉ̃ camasĩrĩjẽ jetore tʉ̃goñatutuaya —qũĩñupʉ̃ Jesús Jairore. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bairo ĩcõã, Pedro, Santiago, cʉ̃ bai Juan ásúparã Jesús mena. Aperãrẽ na árotiesupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bairo Jairo ya wiipʉ na caetaro, ti wii macããna pʉame oti awaja ãñuparã. Cabaiyasiatacore bopacooro cõ cabairijere cõ ĩña otiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bairo na cabairo ĩñarĩ, ti wiire jããrĩ bero, atore bairo na ĩñupʉ̃ Jesús: —Awaja otieticõãña mʉjãã. Atio cawĩmao baiyasietiyamo. Cãnio baiyamo —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bairo cʉ̃ caĩrõ tʉ̃go, nipetirã to macããna pʉame roro cʉ̃ bócaboyeticõãñuparã, “Merẽ yasicoaamo,” ĩrã. Bairo na cabaimiatacʉ̃ãrẽ, Jesús pʉame ti wiire na wiyocõã joyupʉ. Áti yaparo, cariacoataco ãnacõ cõ caãnopʉre jããcoasupʉ cõ ãnacõ pacʉa mena. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bairo jããeta yua, cõ ãnacõ wãmorĩrẽ ñerĩ, atore bairo cõ ĩñupʉ̃: —¡Talita cum! (Bairo ĩgaro ĩña: “Cawĩmao wãmʉnʉcãña.”) ");
INSERT INTO cbcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bairo cʉ̃ caĩrõ, cõ pʉame jicoquei catitunurĩ wãmʉnʉcã ñesẽãcoasupo yua. Mai, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã cʉ̃marĩ majũ cʉ̃goyupo. Bairo cõ cacatitunurõ ĩñarĩ, camasã pʉame bʉtioro tʉ̃goñacõã maniásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bairo na catʉ̃goñamaniamiatacʉ̃ãrẽ, Jesús pʉame na ĩnemoñupʉ̃ tunu atore bairo: “Aperãrẽ na quetibʉjʉeticõãña cawĩmao cõ cacatiatajere,” na ĩñupʉ̃. Ĩ yaparo, ʉgariquere cõrẽ na nurotiyupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Cabero, ti macãpʉ witi acoásúpʉ Jesús. Cʉ̃ cabuerã pʉame cʉ̃ mena ásúparã. Bairo witi acoátí yua, cʉ̃ ya yepa majũpʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eta, yerijãrĩcã rʉ̃mʉ caãno ti yepa macããna na cañubueri wiire jããñupʉ̃, na quetibʉjʉgʉ. Bairo cʉ̃ caquetibʉjʉro tʉ̃go, camasã capããrã tʉ̃gocõã maniásuparã. Atore bairo ĩñuparã: —Ãnia, caroaro jĩcãrõ tʉ̃ni quetibʉjʉyami. ¿Noopʉ atie caroaro cʉ̃ caquetibʉjʉmasĩrĩjẽrẽ cʉ̃ masĩñuparĩ? ¿Dope bairo átijẽñorĩqũẽ cʉ̃ãrẽ cʉ̃ átimasĩñuparĩ? ");
INSERT INTO cbcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ãni, yucʉpãĩrĩ mena rocapata ũnierẽ caqũẽnoʉ macʉ̃ mee cʉ̃ ãniñati? ¿Marĩ mena macããcõ, María macʉ̃ mee cʉ̃ ãniñati? Bairi, ¿Santiago, José, Judas, Simón jʉ̃gocʉ mee cʉ̃ ãniñati? Cʉ̃ marĩ masĩjãñuña. Bairi, ¿marĩ mena macããna rõmirĩ jʉ̃gocʉ mee cʉ̃ ãniñati? —ãmeo ĩ jẽniñañuparã na majũ. Bairi Jesure qũĩroagaetiri, cʉ̃ ya macã macããna pʉame cʉ̃ caquetibʉjʉrijere tʉ̃gogaesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bairo na catʉ̃gogaeto ĩña, atore bairo na ĩñupʉ̃ Jesús: —Profeta majã tocãnacãʉ̃pʉrea na ĩroanucũñama camasã nipetiro na cañesẽãrõpʉ. Na ya macã macããna, bairi na ya wii macããna majũ roque na boetinucũñama. Na yarã jeto na ĩroaetinucũñama —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bairi cʉ̃ ya macã macããna cʉ̃ caquetibʉjʉrijere cariape na catʉ̃gogaetoi, capee caroa cʉ̃ caátijẽñomasĩrĩjẽrẽ topʉre áti ĩñoesupʉ Jesús. Jĩcããrã cariarã jetore cʉ̃ wãmo mena na pãñarĩ na catioyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","“Cʉ̃rẽ cariapea ĩñami,” to macããna camasã na caĩtʉ̃goʉsaetie jʉ̃gori, tʉ̃goñarĩqũẽ pairi tʉ̃goñacõã maniásupʉ Jesús. Bairo na cabairo ĩñarĩ, Jesús pʉame totʉaca caãni macãrĩpʉ, na quetibʉjʉ ñesẽãʉ̃ ásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bairo jĩcã rʉ̃mʉ na neñoñupʉ̃ Jesús cʉ̃ caquetibʉjʉrotijoparã pʉga wãmo peti rʉpore pʉga pẽnirõ majũ caãnarẽ. Bairo na bese yaparo yua, tocãnacã macãã, pʉgarã jeto na árotiyupʉ. Mai, na caápáro jʉ̃goye na joyupʉ masĩrĩqũẽrẽ, wãtĩ yeri pũnarẽ wiyomasĩrĩqũẽ majũrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tunu apeye na cacʉ̃gorije ũnierẽ na jeárotiesupʉ. Bairi wasopoa, apeye ũnierẽ na cajããrĩ poa, pan, dinero cʉ̃ãrẽ na jeárotiesupʉ. Na tuericʉ jetore na neárotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tunu rʉpo jutii na cacʉ̃gorije, na jutii na cajãñarĩjẽ jeto mena na árotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bairo na ároti yaparo, atore bairo na ĩñupʉ̃: —Noo mʉjãã cañesẽãrõpʉ jĩcã wii ũnorẽ etarã, toa tuacõãña, ti macãpʉ mʉjãã caãni rʉ̃mʉrĩ cãrõ. Capee wiiripʉ patowãcõ ñesẽãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bairi di macã macããna ũna mʉjãã cabapacʉto na caboeticõãta, o mʉjãã yaye quetire na catʉ̃gogaeticõãta, na mena ãmerĩcõãña. Bairi na ya macãrẽ witiáná, na macã ñerĩrẽ mʉjãã rʉpo jutii macããjẽrẽ mʉjãã paregarã, “Roro jããrẽ mʉjãã átiapʉ,” ĩrã —na ĩ joyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bairo cʉ̃ caĩrõ bero acoásúparã yua. Bairo áná yua, camasãrẽ, “Roro mʉjãã caátinucũrĩjẽrẽ tʉ̃goña yapapuari tʉ̃goña wasoaya. Dios yaye bʉsʉrique pʉamerẽ tʉ̃goʉsajʉ̃goya,” na ĩ quetibʉjʉ ñesẽãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tunu bairoa camasã capããrã wãtĩ yeri cacʉ̃gorãrẽ na acurewiyojoyuparã Dios cʉ̃ catutuarije jʉ̃gori. Capããrã cariayecʉna cʉ̃ãrẽ na rʉpoare ʉse aceituna mena na piopeori na catioyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ti yʉtea caãno camasã nipetiro Jesús cariarãrẽ cʉ̃ canetõmasĩrĩjẽrẽ tʉ̃goyuparã. Bairi quetiupaʉ rey Herodes cʉ̃ã queti tʉ̃goyupʉ Jesús cʉ̃ caátimasĩrĩjẽrẽ. Bairo tiere tʉ̃go, atore bairo na ĩñupʉ̃ cʉ̃ carotirãrẽ: —Jesús na caĩ, cʉ̃ã ãcʉ̃mi Juan el Bautista cabaiyasiricʉ ãnacʉ̃ tunu cacati majũ. Bairo cabai ãnirĩ capee átijẽño masĩĩmi —na ĩñupʉ̃ Herodes. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aperã qũĩñuparã: —Dios camasãrẽ cʉ̃ caquetibʉjʉrotijoricʉ ãnacʉ̃, Elías cawãmecʉcʉ ãnacʉ̃ catiri buiaetaupʉ —qũĩñuparã aperã. Bairo aperã qũĩñuparã: —Tirʉ̃mʉpʉ caãnana profeta majã mena macããcʉ̃ jĩcãʉ̃ catiri buiaetaupʉ —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bairo Herodes na caĩquetibʉjʉrijere tʉ̃gomicʉ̃ã, atore bairo ĩñupʉ̃: —Juan, tirʉ̃mʉpʉ cʉ̃ rʉpoare yʉ capatarocarotiricʉ ãcʉ̃mi Jesús. Merẽ caticoatacʉmi tunu —ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mai, cajʉ̃goyepʉ Herodes pʉame Juarẽ ñerotiyupʉ. Bairo cʉ̃ ñerotiri bero, ãpõãwẽ mena cʉ̃ jiyari, preso jorica wiipʉ cʉ̃ cũroca rotijoyupʉ. Juan cʉ̃ caquetibʉjʉrijere boesupʉ Herodes. Mai, “Mʉ bai Felipe nʉmo Herodías na caĩõ mena mʉ caãnie ñuẽtĩña. Carorije niña mʉ caátie,” cʉ̃rẽ cʉ̃ caĩquetibʉjʉrijere boesupʉ. Bairo boetiri preso jorica wiipʉ cʉ̃ cũroca rotijoyupʉ Herodes pʉame Juarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías pʉame Juarẽ qũĩñatejãñuñupõ. Bairo qũĩñateeri yua, cʉ̃ pajĩã rotigamiñupõ. Bairo átirotigamiocʉ̃ã, átiroti masĩẽsupo, quetiupaʉ rey Herodes Juarẽ cʉ̃ camairĩjẽ jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes pʉame Juarẽ, “Caroʉ́, Dios cʉ̃ caquetibʉjʉrotijoʉ ãcʉ̃mi,” ĩ tʉ̃goña uwijãñuñupʉ̃. Bairi Juarẽ cʉ̃ qũẽnoñupʉ̃. Apeyera Juan cʉ̃rẽ cʉ̃ caĩquetibʉjʉrijere dope bairo átimasĩẽtĩmicʉ̃ã, caroaro mena cʉ̃ caĩrĩjẽrẽ tʉ̃goganucũñupʉ̃ Herodes. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mai, merẽ etayuparo Herodías Juarẽ cõ capajĩãrotimasĩpa rʉ̃mʉ majũ. Bairi jĩcã rʉ̃mʉ, Herodes pʉame cʉ̃ cabuiarica rʉ̃mʉ caetaro, bose rʉ̃mʉ qũẽnoñupʉ̃. Áticõã, cʉ̃ mena macããna cʉ̃ rocajãñurĩ carotimasĩrã, cʉ̃ comandante carotirã, Galilea yepa macããna carotimasĩrã cʉ̃ã cʉ̃ capiijoatana etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bairo na caʉgaãno, Felipe nʉmo caãnimirĩcõ Herodías cawãmecʉco macõ pʉame basao ásupo, Herodes cõ cʉ̃ caĩñaparore bairo ĩõ. Herodes cʉ̃ capiijoatana cʉ̃ã cõ cabasarijere ĩñajesomajũcõãñuparã. Bairi nipetirã na catʉ̃goro, atore bairo cõ ĩñupʉ̃ Herodías macõrẽ Herodes pʉame: —Noo, yʉre mʉ cajẽnigari wãmerẽ yʉ jẽniña. Mʉ yʉ jomajũcõãgʉ —cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pʉgani cãrõ, “Ĩtoricaro mano Dios mena ñiña. Mʉ yʉ jomajũcõãgʉ dise ũnie yʉre mʉ cajẽnirĩjẽrẽ. Yʉ ya yepa yʉ caquetiupaʉ cʉti yepa carecomacã ũno cʉ̃ãrẽ mʉ yʉ jomasĩgʉ, mʉ cabooata,” cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bairo cawãmao pʉame tiere tʉ̃gori, cõ pacore jẽniñao ásúpo. Atore bairo cõ ĩñupõ: —Caaco, ¿ñe ũnie pʉamerẽ cʉ̃ yʉ jẽnioati? Cõ paco pʉame ĩñupõ: —Juan el Bautista rʉpoare cʉ̃ jẽniojã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bairo cõ caĩrõ tʉ̃go, tãmurĩ cõ masõrĩcʉ̃ tʉpʉ átí, atore bairo qũĩñupõ: —Bairo yʉ boya: Ãmeacã Juan el Bautista rʉpoare patanerĩ jotʉ bapapʉ jããrĩ, yʉ mʉ jowa —qũĩñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","27","Bairo cõ caĩrõ tʉ̃go, tʉ̃goña yapapuacoásupʉ Herodes pʉame. Bairo tʉ̃goña yapapuamicʉ̃ã, “‘¡Dios mena ñiña!’ cõrẽ yʉ caĩatajere yʉ tʉ̃goama yʉ capiijoatana,” ĩ yua, cõrẽ cʉ̃ caĩatatore bairo átirotiyupʉ. Bairi cʉ̃ ʉ̃mʉ jĩcãʉ̃ soldaure Juan preso jorica wiipʉ caãcʉ̃rẽ cʉ̃ rʉpoa pataroti joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ caĩrõrẽ bairo cʉ̃ ásupʉ Juarẽ. Bairo cʉ̃ pajĩã yaparori bero, cʉ̃ ãnacʉ̃ rʉpoare jotʉ bapa buipʉ nejããrĩ, Herodías macõrẽ cõ nuniñupʉ̃. Cõ pʉame cõ pacore cʉ̃ rʉpoa ãnatõrẽ cõ neásúpo, cʉ̃ cayasiro cõ masĩáto ĩõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cabero Juan cʉ̃ cabuemirĩcãrã pʉame bairo cʉ̃rẽ na capajĩãrocarijere queti tʉ̃gori preso jorica wiipʉ etarã, cʉ̃ ãnacʉ̃ rupaʉre neásúparã, masã opepʉ cʉ̃ yarocagarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cabero Jesús cʉ̃ caquetibʉjʉrotijoricarã tunu etayuparã. Bairo eta yua, Jesure cʉ̃ quetibʉjʉyuparã na caátiñesẽãtaje, bairi na caĩbueñesẽãtaje cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bairo na caĩquetibʉjʉro bero, atore bairo na ĩñupʉ̃ Jesús: —Jito aperopʉ. Topʉ eta, ʉga, marĩ yerijãgarã mai —na ĩñupʉ̃. Mai, camasã capããrã na tʉpʉre nairõ majũ na caetaro, dope bairo átiʉga masĩẽsuparã Jesujãã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bairi topʉ caãniatacʉ cũmuarẽ ájããrĩ camasã manopʉ acoásúpʉ Jesús cʉ̃ cabuerã mena. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bairo Jesujãã na caátíere masĩrĩ yua, nipetiro macãã macããna Jesujãã na caátópʉ, ʉtabʉcʉra tʉ̃ni maapʉ atʉ ásúparã. Bairo áná, na jʉ̃goye na capẽñaetaparopʉre ãnicote yuyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bairi Jesús ʉtabʉcʉra ape nʉgõãpʉ pẽñaeta yua, maa nʉcãñupʉ̃. Maa nʉcãrĩ yua, camasã capããrãrẽ na ĩñañupʉ̃. Bairo bai, bopacooro na ĩñañupʉ̃, nurĩcãrã oveja narẽ cacotei camánarẽ bairo na cabairo jʉ̃gori. Bairi capee bueriquere na bueyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bairo na cʉ̃ cabueãno, ñamicããcã nicoasuparo. Bairi cʉ̃ cabuerã pʉame Jesutʉ etari, atore bairo qũĩñuparã: —Merẽ ñamicã majũ niña. Atopʉre wiiri maniña. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dope camasã capããrãrẽ na marĩ áperã. Bairi ãnoarẽ na mʉ árotiwa macããpʉ, na majũ na caʉgapeere na wapatirápáro —qũĩñuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bairo na caĩrõ tʉ̃gomicʉ̃ã, atore bairo na ĩñupʉ̃: —Mʉjãã majũ na ʉgarique nuña —na ĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñuparã: —¿Jãã cawapatiráto mʉ boyati? ¿Dos cientos denario moneda tiiri cãrõ mena pan rupare jãã wapatiracʉti, narẽ nugarã? ");
INSERT INTO cbcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Pan rupaa, ¿nocãnacã rupaa majũ mʉjãã cʉ̃goyati? Ĩñarájá. Bairo cʉ̃ caĩrõrẽ bairo áti yaparori bero, atore bairo qũĩ quetibʉjʉyuparã: —Jãã, jĩcã wãmo cãrõ pan jororiaca, wai, pʉgarããcã tocãrõã jãã cʉ̃goya. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bairo cʉ̃ na caĩquetibʉjʉ yaparo bero, camasã capããrã to caãnarẽ taa yepapʉ rupa poari na ruirotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bairo jĩcã poa macããna, ape poa macããna cien majũ camasã ruiyuparã. Ape poa macããna, ape poa macããna, cincuenta majũ camasã ruiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bairo na caruiro ĩña, pan rupaa jĩcã wãmo cãnacã rupaacarẽ, wai pʉgarã mena nerĩ, jõbuire ĩñamʉgõjori, “Jãã Pacʉ, jãã mena mʉ ñujãñuña,” qũĩ jẽniñupʉ̃ Jesús Diore. Bairo qũĩ jẽni yaparo, pan rupaare carecomacã peeri, cʉ̃ cabuerãrẽ na nuniñupʉ̃, camasãrẽ na cabatoparore bairo ĩ. Wai cʉ̃ãrẽ carecomacã peeri, cʉ̃ cabuerãrẽ na nuniñupʉ̃, camasã nipetirore na cabatoparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bairo na cabatoro bero yua, nipetiro camasã caroaro ʉgayapicoasuparã, ʉgarique na cabatoatajere. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bairo na caʉga tuaro bero, jejããñuparã piiripʉ na caʉgarʉgarijere. Pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã piiri majũ jejãã jiroyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","To caãna caʉgaatana jĩcã wãmo cãnacã mil majũ camasã ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tipaʉ bero cʉ̃ cabuerãrẽ cũmuapʉ na ájããrotiyupʉ Jesús tunu. Camasãrẽ na cʉ̃ caĩñatʉsajotoye, ti ʉtabʉcʉra jĩnʉgõãpʉ Betsaida macãpʉ cʉ̃ jʉ̃goye na capẽñaátó boyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bairi camasãrẽ na ĩñatʉsajo yaparo, ʉ̃tãʉ̃ buipʉ wãmʉcoásúpʉ Jesús, Diore cʉ̃ jẽniácʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bairi muipʉ cʉ̃ cajããrõ canaioatípaʉ Jesús cʉ̃ cabuerã cũmua mena merẽ tira recomacã majũpʉ na ĩñajoyupʉ Jesús. Cʉ̃ pʉame jĩcãʉ̃ã ãñupʉ̃ ti ʉ̃tãʉ̃ buipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Topʉ ãcʉ̃, cʉ̃ cabuerã popiye mena na capẽñaátóre ĩñajoyupʉ. Mai, wĩno pʉame bʉtioro na ríapere papu tunuoñuparõ. Bairo roro na cabairo, cabusuparo jʉ̃goyeaca oco bui peari natʉ asúpʉ Jesús. Cʉ̃ pʉame na netõágʉre bairo baimiñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bairo oco buipʉ cʉ̃ caató ĩña yua, cʉ̃ cabuerã uwiri bairo awajayuparã: “¡Ãni, camasocʉ ãnacʉ̃ wãtĩ marĩtʉ atíyami!” ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Cʉ̃ cabuerã nipetirã qũĩñañuparã Jesure. Bairo bʉtioro cauwirã ãnirĩ bairo ĩ awajayuparã yua. Bairo na cabairo, jicoquei Jesús pʉame na ĩ joyupʉ: —¡Tʉ̃goñatutuaya yʉ yarã, Jesua yʉ ãniña, yʉ uwieticõãña! —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bairo cũmuapʉ cʉ̃ caájããrõ, wĩno pʉame papu jãnacoasuparo yua. Bairo cabairo ĩña, cʉ̃ cabuerã pʉame bʉtioro ĩña acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Cajʉ̃goye Jesús pan rupare cʉ̃ caátijẽñorĩqũẽrẽ caĩñarĩcãrã nimirãcʉ̃ã, cʉ̃ caátimasĩnetõrĩjẽrẽ tʉ̃goña masĩẽsuparã. Na yeri mena tʉ̃goña masĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bairo pẽnaáná, ʉtabʉcʉra ape nʉgõãpʉ etayuparã, Genesaret cawãmecʉti yepapʉ. Topʉ etarã, na cũmuarẽ jiyatupoo yaparo, maa nʉcãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bairo na caetaro ĩña, jicoquei to macããna pʉame Jesure qũĩña masĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bairo cʉ̃ caetaro ĩñarĩ, ti yepa macããna nipetiropʉre atʉátí, na quetibʉjʉ batoyuparã. Cariayecʉnarẽ na canerĩ coro mena na jeatí rotiyuparã, “Tipaʉpʉa niñami Jesús,” na caĩrõpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bairo na pʉame Jesús noo cʉ̃ caboropʉ cʉ̃ caáñesẽãrõ, o peeti macããcã, o capairi macã, o macã tʉ̃ni macãã macããrĩpʉ cʉ̃ caátó cʉ̃ãrẽ na jeásúparã camasã cariarãrẽ. Jesús cʉ̃ caátí wããrĩpʉ cariarãrẽ na cũñuparã, bʉtioro, “Mʉ jutiro yapaacarẽ jãã pãñarotiya,” cʉ̃rẽ na caĩmasĩparore bairo ĩrã. Bairo cariayecʉna tocãnacãʉ̃pʉa cʉ̃ jutiro yapare capãñarã caticoasuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Cabero etayuparã fariseo majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena. Na pʉame Jerusalén macãpʉ caátíatana ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesús cʉ̃ cabuerã jĩcããrã wãmo coseena na caʉgaro na ĩñañuparã fariseo majã. “Ʉgagarã jʉ̃goye marĩrẽ bairo wãmo coseetiyama Jesús cʉ̃ cabuerã,” ĩ bʉsʉpaiyuparã. Bairi, “Carorã ãnama,” na ĩ ĩñañuparã, fariseo majã Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mai, fariseo majã, judío majã nipetirã na ñicʉ̃jãã na caátijʉ̃goatatorea bairo ána ásuparã. Bairi caroaro na wãmorĩrẽ tocãnacãnia coseri bero jeto ʉganucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ʉgarique cawapatiratana tunu etarã cʉ̃ã na wãmorĩrẽ cosenucũñuparã, ʉgagarã jʉ̃goye. Na ñicʉ̃jãã na caátinucũrĩqũẽ wãme cãrõ átinucũñuparã. Tunu bairoa etirique na capiojãrĩ rʉri cʉ̃ãrẽ, na jotʉri cʉ̃ãrẽ cosenucũñuparã. Bairo marĩ caápericõãta, Dios, “‘Carorã niñama,’ marĩ ĩ ĩñabujioʉmi,” ĩrã bairo átinucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bairi atore bairo qũĩ jẽniñañuparã fariseo majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena Jesure: —¿Nopẽĩrã mʉ cabuerã marĩ ñicʉ̃jãã ãnana na caroticũrĩqũẽrẽ bairo na áperiyati? Coseetiyama na wãmorĩrẽ na caʉgaparo jʉ̃goye —qũĩ jẽniñañuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —¡Caĩtopairã majũ mʉjãã ãniña! Dios pʉame Isaías ãnacʉ̃ cʉ̃ cawoaturica pũrõpʉ mʉjããrẽ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo mʉjãã baimajũcõãña. Atore bairo ĩñupĩ Dios mʉjããrẽ: ‘Ati poa macããna na bʉsʉrique mena yʉre caĩroarãrẽ bairo baibauyama. Bairo baimirãcʉ̃ã, na yeri na catʉ̃goñarĩjẽpʉ ricaati baicõãñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na pʉame, “Camasã na carotirique pʉamerẽ Dios cʉ̃ caquetibʉjʉroticũrĩqũẽ netõjãñurõ caãnimajũrĩjẽ niña,” caĩrãrẽ bairo buenucũñama. Bairo cabuerã na caãnoi, yʉre na cañubuegarije dope bairo átimasĩã maa,’ ĩñupĩ Dios mʉjãã cabaipeere. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mʉjãã pʉame mʉjãã caátinucũrĩjẽrẽ bʉtioro borã, Dios marĩrẽ cʉ̃ caroticũrĩqũẽ pʉamerẽ mʉjãã áperinucũña —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃: —Mʉjãã caátinucũrĩjẽrẽ bʉtioro borã, Dios marĩrẽ cʉ̃ caroticũrĩqũẽrẽ cabaibotiorãrẽ bairo mʉjãã baiya. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés ãnacʉ̃ pʉame atore bairo marĩrẽ ĩ woatucũñupĩ: “Mʉjãã pacʉare mʉjãã caĩroaro boya. Ni ũcʉ̃ cʉ̃ pacʉre, o cʉ̃ pacore roro cʉ̃ caĩata, cʉ̃ mʉjãã pajĩã rocacõãgarã,” ĩ woatuyupi Moisés. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bairo cʉ̃ caĩcũmiatacʉ̃ãrẽ, mʉjãã pʉame ricaati mʉjãã quetibʉjʉya. Atore bairo mʉjãã ĩña: “Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ pacʉre, o cʉ̃ pacore, ‘Yʉ yaye nipetirijere merẽ Diore cʉ̃ yʉ nuniapʉ̃. Corbán na caĩrĩjẽ niña. Bairi mʉjãã cabopacarijere yʉ nunimasĩẽtĩña,’ cʉ̃ caĩata, ñurõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bairi ni jĩcãʉ̃ ũcʉ̃ tore bairo caĩ ãnirĩ, cʉ̃ pacʉre, o cʉ̃ pacore cʉ̃ cajʉátinemorõ boetiya,” mʉjãã ĩ quetibʉjʉya. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bairo ĩ quetibʉjʉrã, Dios marĩrẽ cʉ̃ caroticũrĩqũẽrẽ cajãnarotirãrẽ bairo mʉjãã baiya. Bairo caquetibʉjʉrã ãnirĩ netõjãñurõ mʉjãã boya mʉjãã caátinucũrĩjẽ mʉjãã ya wãme pʉamerẽ. Tore bairo jeto capee wãme majũ mʉjãã átinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ĩ quetibʉjʉ yaparo, camasãrẽ na piineñorĩ, atore bairo na ĩñupʉ̃ Jesús: —Mʉjãã nipetiro camasã tʉ̃gopeoya yʉ yaye quetibʉjʉriquere. Tiere tʉ̃gomasĩña: ");
INSERT INTO cbcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Camasã na caʉgarije wapa jʉ̃gori mee carorã niñama. Na majũã rorije na yeripʉ na catʉ̃goñanucũrĩjẽ jʉ̃gori roque carorã niñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mʉjãã, caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bairo ĩ yaparo, camasã capããrã watoapʉ caãniatacʉ na aweyocoásúpʉ. Á yua, cʉ̃ cabuerã mena wiipʉ jããcoásupʉ. Bairo ti wiipʉ jããeta, cʉ̃ cabuerã pʉame atore bairo qũĩ jẽniñañuparã: “Ape wãme ĩcõñarĩ camasãrẽ mʉ caquetibʉjʉrije, ¿dope bairo ĩgaro to ĩñati?” ");
INSERT INTO cbcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —¿Mʉjãã cʉ̃ã mʉjãã tʉ̃gomasĩẽtĩñati yʉ yaye quetire? Nipetiro camasã na caʉgarije tocãnacã wãme pʉame na paaropʉ yuaya. Yuari yua, cabero netõcoaya. Na caʉgarije mee na yeri pũnarẽ to royetuo joroque na átiya. Bairo ĩ, “Tocãnacã wãme ʉgarique caroa jeto niña,” ĩgʉ ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tunu atore bairo ĩnemoñupʉ̃: —Na yeripʉ roro na catʉ̃goñarĩjẽ roque na yeri pũnarẽ tʉ̃goña asurotiya. Bairi roro na catʉ̃goñarĩjẽ jʉ̃gori carorije caánarẽ bairo na ĩñañami Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Camasã na yeripʉ roro na catʉ̃goñarĩjẽ jʉ̃gori tocãnacã wãme carorijere átinucũñama. Ato cãnacã wãme majũ na caátinucũrĩjẽ niña: átiepericarã cʉtaje, jerutirique, aperãrẽ pajĩãrerique, ");
INSERT INTO cbcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","camasã na nʉmoa mee, o na manapʉ̃ã mena mee ãnajẽ, tunu apeye ũnierẽ bonetõrĩqũẽ, roro tʉ̃goñarĩqũẽ, ĩtorique, cawãmarã jeto ãna ãmeo roro ãnajẽ cʉtaje, roro ĩñaʉgorique, bʉsʉpairique, botiorique ãnajẽ cʉtaje, tʉ̃gomasĩẽtãjẽ ãnajẽ cʉtaje. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bairo camasã na yeripʉ roro na catʉ̃goñarĩjẽ jʉ̃gori roro átiyama. Bairo na wãmorĩ coseena na caʉgarije wapa mee, roro na caátie jʉ̃gori carorije caánarẽ bairo na ĩñañami Dios —ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ĩ quetibʉjʉ yaparo, topʉ caãniatacʉ Tiro cawãmecʉti macãpʉ ásúpʉ. Topʉ eta, topʉ cʉ̃ caetarijere camasã na camasĩrõ boesupʉ Jesús, capããrã yʉ tʉpʉ na neñarema, ĩ. Bairi jĩcã wiipʉ jããcoasupʉ. Bairo jããmicʉ̃ã, dope bairo bairuti masĩẽsupʉ camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Topʉ cʉ̃ caetaro beroaca, jĩcãõ carõmio cawãtĩ yeri pũna jããecorico paco pʉame Jesús tʉpʉ rʉpopaturi mena etanumuo etayupo. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mai, cõ pʉame ape yepa macããcõ sirofenicia na caĩrõ macããcõ ãñupõ. Bairo etari, bʉsʉrique tutuaro mena cõ macõpʉ wãtĩ caãcʉ̃rẽ cʉ̃ acure rocawiyojo rotiyupo. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bairo cõ caĩmiatacʉ̃ãrẽ, atore bairo cõ ĩñupʉ̃ Jesús: —Mʉa, israelita yao mee mʉ ãniña. Bairi mʉ yʉ cajʉápata, jĩcãʉ̃ cʉ̃ pũnaa na caʉgarije pan rupaare ẽmarĩ cʉ̃ wii yaiare canureire bairo yʉ átibujioʉ —cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupõ. —Bairoa mʉ átibujioʉ baipʉa. Bairo mʉ caĩmiatacʉ̃ãrẽ, bairãpʉa cawĩmarã na caʉgawerije yepapʉ cañarĩjẽãcãrẽ ʉganucũñama wii yaia cʉ̃ã. Bairi na caʉgaricaroacarẽ bairo yʉ mʉ jʉátigʉ petoaca —qũĩñupõ carõmio Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bairo cõ caĩrõ tʉ̃go, bairo cõ ĩñupʉ̃: —Cariapea miña. Caroaro yʉ mena mʉ catʉ̃goñatutuaro jʉ̃gori, wãtĩ mʉ macõpʉre caãnimiatacʉre merẽ yʉ witirotiya. Tunu ácója mʉ ya wiipʉ —cõ ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bairo cõ ya wiipʉre tunueta ácó, cõ macõ, wãtĩ yeri pũna cacʉ̃gomiataco cacatiopʉre cõ etayupo yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bairo Tiro macãpʉ caãniatacʉ Jesús acoásúpʉ. Bairo netõáná, Decápolis cawãmecʉti macãã etari, netõáná, Galilea ʉtabʉcʉra tʉpʉ etayupʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bairo topʉ cʉ̃ caetaro, jĩcãʉ̃ tʉ̃gomasĩẽtĩ, bairi caroaro bʉsʉmasĩẽtĩ cabaire cʉ̃ neásúparã Jesús tʉpʉ, cʉ̃ wãmo mena cʉ̃ ñigãpeonetõáto ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bairo cʉ̃tʉ na cane etaro ĩña, Jesús pʉame aperopʉ camasã na camanopʉ cʉ̃ neásúpʉ. Topʉ cʉ̃ neá, cʉ̃ wãmojũãrĩ mena cʉ̃ ãmoo operipʉ ñujõrĩ bero, cʉ̃ wãmojũãrẽ ʉcoo wareri, cʉ̃ ñemerõrẽ pãñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Cabero ʉmʉrecóopʉre ĩñamʉgõjori yeri jĩnijãñupʉ̃. Cabero qũĩñupʉ̃ cabʉsʉmasĩẽcʉ̃ catʉ̃gomasĩẽcʉ̃rẽ: “¡Efata!” Efata ĩgaro ĩña: “¡Pãña!” Cʉ̃ ãmoo to tusuáto ĩ, bairo ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bairo Jesús cʉ̃ caĩrõ tʉ̃gomasĩ, bairi tunu bʉsʉmasĩ baicoasupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","“Aperãrẽ na mʉjãã quetibʉjʉepa,” na ĩmiñupʉ̃ Jesús. Bairo, “Mʉjãã quetibʉjʉepa,” cʉ̃ caĩmiatacʉ̃ãrẽ, aperãrẽ na quetibʉjʉbatoo peyocõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bairo cʉ̃ caátiere ĩña acʉacoati, bairo qũĩñuparã: “Nipetiri wãmerĩ caroaro átiyami Jesús. Cabʉsʉmasĩẽna cʉ̃ãrẽ na bʉsʉmasĩõ joroque na átiyami. Tunu bairoa catʉ̃gomasĩẽna cʉ̃ãrẽ na tʉ̃gomasĩõ joroque na átiyami,” ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti yʉtea caãnorẽ camasã capããrã Jesús tʉpʉ tunu na caneñaporo, cʉ̃ cabuerãrẽ na piijoyupʉ. Bairo na caetaro ĩña, atore bairo na ĩñupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ãnoa camasã merẽ itia rʉ̃mʉ majũ yʉ mena nicoayama. Ñe ũnie majũ ʉgarique cʉ̃goetiyama. Bairi bopacooro na ñiñaña. Jicoquei na yʉ tunuo jogaetiya mai. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Caʉgarique ʉgaenarẽ na yʉ catunuojoata, áwẽpʉ̃ẽtĩbujiorãma, na ya wiiripʉre áná. Jĩcããrã na mena macããna cayoaropʉ caatíatana niñama. Bairi na marĩ ʉgarique nuto —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñuparã: —Ãnoa camasã capããrã niñama. Tunu atopʉ wiiri maniña. Bairi, ¿noopʉ marĩ bocarãti ʉgarique, pairo narẽ marĩ canupeere? —qũĩ jẽniñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bairo na caĩrõ, Jesús pʉame na ĩnemoñupʉ̃ tunu: —Pan rupaa, ¿nocãnacã rupaa majũ mʉjãã cʉ̃goyati? Bairo cʉ̃ caĩrõ, atore bairo qũĩñuparã: —Jãã, jĩcã wãmo peti pʉga pẽnirõ cãrõ pan rupaaca tocãrõã jãã cʉ̃goya —qũĩñuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bairo na caĩrõ tʉ̃go, camasãrẽ yepapʉ na ruirotiyupʉ. Bairo na caruiro ĩña, tie pan jĩcã wãmo peti pʉga pẽnirõ caãni rupaare nerĩ, Diore, “Jãã mena mʉ ñujãñuña,” qũĩ jẽniñupʉ̃. Bairo qũĩ jẽni yaparori bero, tie pããrẽ carecomacã peeri bero, cʉ̃ cabuerãrẽ na nuniñupʉ̃, camasãrẽ na batoroti. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wai cʉ̃ãrẽ petoaca cʉ̃goyuparã. Narẽ nerĩ, Diore, “Jãã mena mʉ ñujãñuña,” qũĩ jẽniñupʉ̃. Bairo qũĩ jẽni yaparo, na cʉ̃ãrẽ na batorotiyupʉ camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bairo na caáto yua, nipetiro camasã caroaro ʉgayapicoasuparã, ʉgarique Jesús cʉ̃ cabuerã na cabatoatajere. Bairo na caʉgatuaro bero, jejããñuparã cʉ̃ cabuerã piiripʉ na caʉgarʉgarijere. Jĩcã wãmo peti pʉga pẽnirõ cãnacã piiri majũ jejããjiroyuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","To caãna caʉgaricarã pʉame baparicãnacã mil majũ camasã ãñuparã. Cabero Jesús pʉame camasãrẽ, “Yʉ áya,” na ĩ yaparo, cũmuarẽ ájããñupʉ̃. Dalmanuta cawãmecʉti yepapʉ ásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bairi Dalmanuta yepapʉ cʉ̃ caãno, Jesús cʉ̃ caátiere ĩñarĩ bʉsʉjãgamirã, cʉ̃tʉ etayuparã fariseo majã. Bairo etarã, dise ũnie átijẽñorĩqũẽ ʉmʉrecóo macããjẽrẽ Jesure cʉ̃ áti ĩñorotimiñuparã. “¿Cariape Dios cʉ̃ cajoricʉ majũ cʉ̃ ãnicʉti?” ĩrã, bairo cʉ̃ átirotimiñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús pʉame yeri jĩnijããrĩ, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã ati yepa macããna, ãme caãna átijẽño ĩñorĩqũẽ jetore na boyati? Bairo na cabomiatacʉ̃ãrẽ, tiere áti ĩñoetigʉmi Dios —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ĩ quetibʉjʉ yaparo, na cũmuarẽ etajãã, ʉtabʉcʉra ape nʉgõãpʉ pẽñacoásúpʉ Jesús cʉ̃ cabuerã mena. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mai, cʉ̃ cabuerã na caʉgapee, pan rupaare masiriticõãrĩ jeápéyuparã. Jĩcããcã cʉ̃goyuparã ti cũmuapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bairo na cabairo, Jesús pʉame bairo na ĩñupʉ̃: —Tʉ̃goya mʉjãã. Fariseo, Herodes majã yaye levadura, pan pairica na cawauorijere mʉjãã boeticõãña —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ cabuerã pʉame atore bairo ãmeo ĩñuparã na majũ: “¡Pan rupaa marĩ cajeatíbujioatajere marĩ masiriticũũpã! Bairi bairo marĩ ĩĩmi,” ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús pʉame masĩcõãñupʉ̃ na caãmeoĩrĩjẽrẽ. Bairi atore bairo na ĩnemoñupʉ̃ tunu: —¿Nopẽĩrã, “‘Pan rupaa na cajeatíbujioatajere na masiritiupari,’ ĩgʉ ĩcʉ̃mi Jesús,” mʉjãã ãmeo ĩñati? Bairo mee ĩgʉ ñiña. ¿Mʉjãã tʉ̃goña masĩẽtĩñati mai? ");
INSERT INTO cbcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Cayericʉna nimirãcʉ̃ã, ¿mʉjãã tʉ̃goña masĩẽtĩñati? Tunu cacaapee cʉ̃gorã nimirãcʉ̃ã, ¿mʉjãã ĩñamasĩẽtĩñati? Tunu caãmoocʉna nimirãcʉ̃ã, ¿mʉjãã tʉ̃goetiyati? ¿Yoaro mee mʉjãã masiriticoayati yʉ caátijẽñorĩqũẽrẽ? ");
INSERT INTO cbcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pan rupaa, jĩcã wãmo cãnacã rupaa jetore cʉ̃gomicʉ̃ã, caʉ̃mʉa jĩcã wãmo cãnacã mil majũ na ʉga yapicoao joroque na yʉ ápʉ. Tiere mʉjãã ĩñawʉ̃. Bairo caĩñarĩcãrã ãnirĩ cabero piiripʉ na caʉgarʉgariquere, ¿nocãnacã piiri majũ mʉjãã jejããjirori? Atore bairo qũĩñuparã cʉ̃ cabuerã pʉame: —Pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã piiri cãrõ jãã jejããjirowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ tunu Jesús: —Tunu bairoa ape rʉ̃mʉ pan rupaa, jĩcã wãmo peti pʉga pẽnirõ cãnacã rupaa jetore cʉ̃gomicʉ̃ã, caʉ̃mʉa baparicãnacã mil majũ na ʉga yapicoao joroque na yʉ ápʉ. Tie cʉ̃ãrẽ mʉjãã ĩñawʉ̃. Bairo caĩñarĩcãrã ãnirĩ cabero piiripʉ na caʉgarʉgariquere, ¿nocãnacã piiri majũ mʉjãã jejããjirori? ¿Tiere mʉjãã masiriticoayati? Cʉ̃ cabuerã pʉame atore bairo qũĩñuparã: —Jĩcã wãmo peti pʉga pẽnirõ cãrõ jãã jejããjirowʉ —qũĩñuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃: —Bairo majũã baiwʉ. ¿Bairi mʉjãã tʉ̃goña masĩẽtĩñati mai? ");
INSERT INTO cbcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús cʉ̃ cabuerã mena etayupʉ Betsaida cawãmecʉti macãpʉ. Ti macãpʉ na caetaro, jĩcãʉ̃ cacaapee ĩñamasĩẽcʉ̃rẽ cʉ̃ ne etayuparã. Jesús tʉpʉ cʉ̃ ne etari, atore bairo bʉtioro qũĩñuparã, “Ãnirẽ cʉ̃ pãñarĩ cʉ̃ netõña.” ");
INSERT INTO cbcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bairi Jesús cacaapee ĩñaecʉ̃rẽ cʉ̃ wãmo mena cʉ̃ tʉ̃gã ásúpʉ macã tʉ̃nipʉ. Topʉ cʉ̃ ne eta, Jesús cʉ̃ ʉcoo mena cʉ̃ wareyupʉ cʉ̃ capeere. Bairo áti yaparo cʉ̃ wãmoorĩ mena cʉ̃ capeere ñigã peoyupʉ. Bairo átiri bero qũĩ jẽniñañupʉ̃, “¿Merẽ apeye ũnierẽ miñañati?” ");
INSERT INTO cbcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bairo cʉ̃ caĩrõ, caĩñaecʉ̃ pʉame ĩñapãmasĩrĩ yua, atore bairo qũĩñupʉ̃: —Ñiñaña camasãrẽ. Baipʉa, yucʉre bairo cabaurã áñesẽãñama —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bairo cʉ̃ caĩrõ tʉ̃go, Jesús cʉ̃ wãmorĩ mena ñigã peonemoñupʉ̃ tunu. Bairo cʉ̃ caátopʉa, caroaro majũ ĩñamasĩñupʉ̃ yua. Tocãnacã wãmea caroaro ĩñamasĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bairo cʉ̃ cabairo ĩña, atore bairo qũĩñupʉ̃ Jesús: —Tunu ácʉ́ja mʉ ya wiipʉ. Baipʉa, macãpʉre mʉ tunu apérigʉ —qũĩñupʉ̃ Jesús cacaapee ĩñamasĩẽtĩmiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cabero Cesarea de Filipo na caĩrĩ yepapʉ Jesús, cʉ̃ cabuerã mena maapʉ ácʉ́, atore bairo na ĩñupʉ̃: —“¿Noa ãcʉ̃mi?” yʉ na ĩnucũñati camasã —na ĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñuparã Jesure cʉ̃ cabuerã pʉame: —Jĩcããrã ĩñama: “Juan el Bautista ãcʉ̃mi.” Aperã ĩnucũñama: “Elías ãnacʉ̃ catiri ãcʉ̃mi,” miñama. Aperã ĩnucũñama: “Tirʉ̃mʉpʉ caãnana profeta majã mena macããcʉ̃ jĩcãʉ̃ catiri caatácʉ ãcʉ̃mi Jesús,” minucũñama —qũĩ quetibʉjʉyuparã cʉ̃ cabuerã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bairo cʉ̃ na caquetibʉjʉro bero, atore bairo na ĩ jẽniñanemoñupʉ̃ tunu: —¿Mʉjãã ate? “¿Noa ãcʉ̃mi?” yʉ mʉjãã ĩnucũñati —na ĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, Simón Pedro pʉame qũĩñupʉ̃: —Mʉa, Mesías, Dios cʉ̃ cajoʉ majũ mʉ ãniña —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús Pedrore: “Cʉ̃ã, yʉ ãniña. Bairãpʉa, cʉ̃, yʉ caãnierẽ na quetibʉjʉeticõãña aperã camasãrẽ mai,” na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tipaʉ bero cʉ̃ cabuerãrẽ Jerusalẽpʉ roro popiye cʉ̃ cabaipeere na quetibʉjʉ jʉ̃gonutuásúpʉ. Quetiuparã cabʉtoa camasĩrã, bairi Dios cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi sacerdote majã quetiuparã cʉ̃ã, popiye cʉ̃ baio joroque na caátipeere na quetibʉjʉ nutuásúpʉ, cʉ̃rẽ na capajĩãrotipee majũrẽ. “Bairo yʉ, Camasã Jʉ̃gocʉ, yʉ na caátimiatacʉ̃ãrẽ, itia rʉ̃mʉ bero yʉ caticoagʉ tunu,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cʉ̃, na caátipeere caroaro cariape na quetibʉjʉyupʉ. Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame jõjãñurõ Jesure cʉ̃ neásúpʉ. Topʉ eta, bairo qũĩ jʉ̃goyupʉ Pedro Jesure: “¡Yʉ Quetiupaʉ, mʉ caĩrõrẽ bairo to baieticõãto!” qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bairo cʉ̃ caĩrõ tʉ̃go, Jesús pʉame cʉ̃ cabuerãrẽ na ãmejore ĩñarĩ, atore bairo qũĩñupʉ̃ Pedrore: —¡Ácʉ́ja Satanás! Bairo mʉ caĩrõ roro yʉ cabaipeere cabʉsʉjãnemoʉrẽ bairo miña. Dios cʉ̃ catʉ̃goñarõrẽ bairo mee, camasã na catʉ̃goñarõrẽ bairo mʉ tʉ̃goñaña, bairo yʉ mʉ caĩata —qũĩ tutiyupʉ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cabero Jesús cʉ̃ buerã, aperã camasã cʉ̃ãrẽ na piineñojori, atore bairo na ĩñupʉ̃: —Ni caboʉ, yʉ cabuei caãnigaʉ, cʉ̃ caátigamirĩjẽrẽ pitigʉmi. Yʉ carotirore bairo jeto roque átigʉmi tocãnacã rʉ̃mʉa. Popiye baimicʉ̃ã, yʉ yaye quetire jãnaetigʉmi yʉ cabuei caãnigaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bairo tunu caʉ̃mʉ apei cʉ̃ caãnie pʉamerẽ mairĩ, yʉ yaye quetire jãnacoagʉmi. Bairo cabai ãnirĩ yasicoagʉmi yua. Apei, yʉ yaye quetire cajãnaecʉ roque netõcõãgʉmi. Cʉ̃rẽ na capajĩã rocacõãmiatacʉ̃ãrẽ, caticõã ãninucũgʉmi tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tunu caʉ̃mʉ apei ati yepa macããjẽ nipetirije merẽ cʉ̃goyami, cʉ̃ caborije caãno cãrõ. Bairo cʉ̃gomicʉ̃ã, Diore cʉ̃ tʉ̃goñaẽtĩñami. Bairo catʉ̃goñaecʉ̃ ãnirĩ cʉ̃ cariaatato bero Dios mena ãmerĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bairi dope baieto pairo cʉ̃ cacʉ̃gorije pʉame. Wapa maa tie ati ʉmʉrecóo macããjẽ, Diore cʉ̃ camasĩẽtĩcõãta. ");
INSERT INTO cbcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bairi ni jĩcãʉ̃ ũcʉ̃ yʉre tʉ̃goñabobori, “Jesús yaʉ yʉ ãniña,” ati yʉtea macããna carorã ricaati caánarẽ na cʉ̃ caĩquetibʉjʉgaeticõãta, yʉ cʉ̃ã, “Ãni, yʉ yaʉ niñami,” cʉ̃ ñi masĩẽtĩgʉ. Yʉ, Camasã Jʉ̃gocʉ, ati yepapʉ yʉ Pacʉ cʉ̃ camasĩrĩjẽ mena nemo yʉ catunuetaro, “Ãni, yʉ yaʉ niñami,” cʉ̃ ñi masĩẽtĩgʉ. Ángelea majã jõbui macããna, cañurã mena, tunu yʉ catunuetaro, bairo cʉ̃ ñimasĩẽtĩgʉ ni jĩcãʉ̃rẽ tʉ̃goñabobori, “Jesús yaʉ yʉ ãniña,” cʉ̃ caĩquetibʉjʉgaeticõãta. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bairo Jesús camasãrẽ na cʉ̃ caquetibʉjʉro bero, atore bairo na ĩnemoñupʉ̃ cʉ̃ cabuerã pʉamerẽ: —Cariape mʉjããrẽ yʉ quetibʉjʉya: Mʉjãã jĩcããrã, ato caãna, mʉjãã cariaparo jʉ̃goye mʉjãã ĩñagarã Dios cʉ̃ carotimasĩrĩpaʉ tutuaro mena caetarore —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cabero, jĩcã wãmo peti jĩcã pẽnirõ cãnacã rʉ̃mʉrĩ bero Pedrore, Santiagore, Juarẽ na piiásúpʉ Jesús ʉ̃tãʉ̃ caʉ̃mʉarĩcʉ buipʉ. Bairo topʉ na caãno, Jesús pʉame cʉ̃ cabaurije wasoacoasupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cʉ̃ jutiro pʉame botiro baicoasuparo. Camasã coserique mena jutii botirije majũ na cacosero netõrõ botiyuparo. Asiyaʉ baicoasupʉ Jesús yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bairo cʉ̃ cabaiãno, Elías ãnacʉ̃, Moisés ãnacʉ̃ mena buiaetayuparã. Bairo buiaetarã yua, Jesús mena bʉsʉpẽninucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bairo na caĩãno, Pedro pʉame atore bairo qũĩñupʉ̃ Jesure: —Jããrẽ cabuei, ¡atopʉ marĩ caãno ñumajũcõãña! Bairi itia wiipãĩrĩãcã majũ mʉjããrẽ jãã qũẽnobojagarã. Jĩcã wii mʉ ya wii, ape wii Moisés ya wii, ape wii Elías ya wii mʉjããrẽ jãã qũẽnobojagarã —qũĩñupʉ̃ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mai, Jesús cʉ̃ cabuerã pʉame ĩña acʉanetõcoasuparã. Bairi Pedro pʉame dope bairo ĩ masĩẽtĩrĩ, tore bairo ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bairo cʉ̃ caĩãno, buseriwo atí, na pauma tocoasuparo. Bairo catoro, Pedrojãã pʉame cayʉsʉropʉ ãñuparã. Bairo ãna, bʉsʉrique buseriwo watoapʉ cabʉsʉocajorijere tʉ̃goyuparã. Atore bairo ĩñuparõ: “Ãni, yʉ macʉ̃, yʉ camai majũ niñami. Cʉ̃ yaye bʉsʉriquere tʉ̃goʉsaya,” ĩ ocajoyuparo jõbuipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bairo to caĩrõ tʉ̃go, tunu ãmejore ĩñajoyuparã. ¡Tame! Elías, Moisés cʉ̃ã mañuparã yua. Jesús jeto nucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cabero ʉ̃tãʉ̃rẽ na caruiató, atore bairo na ĩñupʉ̃ Jesús Pedrojããrẽ: “Ãme mʉjãã caĩñaatajere aperãrẽ na mʉjãã quetibʉjʉetigarã mai. Cabero, yʉ, Camasã Jʉ̃gocʉ, cariacoatacʉ nimicʉ̃ã, yʉ cacatiro bero roque na mʉjãã quetibʉjʉgarã,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bairo cʉ̃ caĩrõrẽ bairo aperãrẽ quetibʉjʉetimirãcʉ̃ã, na jetoa na yeripʉ tiere tʉ̃goñañuparã. Bairo tʉ̃goñarĩ, atore bairo ãmeo ĩ jẽniñañuparã, “¿Dope bairo ĩgʉ qũĩñati, ‘Cariacoatacʉ nimicʉ̃ã, yʉ catigʉ,’ Jesús cʉ̃ cabaipeere cʉ̃ caĩata?” ãmeo ĩ jẽniñañuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bairi cabero atore bairo qũĩ jẽniñañuparã Pedrojãã Jesure: —Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã bairo ĩñama: “Dios cʉ̃ cajopaʉ ati yepapʉ cʉ̃ caetaparo jʉ̃goye Elías ãnacʉ̃ catiri etanemogʉmi tunu,” ĩñama. ¿Nopẽĩrã bairo na ĩ quetibʉjʉyati camasãrẽ? ");
INSERT INTO cbcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bairo na caĩjẽniñarõ, atore bairo na ĩ quetibʉjʉyupʉ Jesús: —Na caĩrõrẽ bairo atíjʉ̃gogʉmi jĩcãʉ̃ Elías ãnacʉ̃rẽ bairo caãcʉ̃. Cʉ̃ pʉame nipetirijere qũẽnojʉ̃gogʉmi. Tunu bairoa, ¿nopẽĩrã Dios yaye bʉsʉrica tutipʉ cawoaturicarã pʉame, “Camasã Jʉ̃gocʉre popiye cʉ̃ baio joroque átigarãma. Roro majũ qũĩñategarãma,” na ĩ woatu quetibʉjʉcũñuparĩ? ");
INSERT INTO cbcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Cariape mʉjããrẽ ñiña: Elías ãnacʉ̃rẽ bairo caãcʉ̃ merẽ etawĩ. Bairo cʉ̃ caetamiatacʉ̃ãrẽ, “Cʉ̃ã niñami Elías ãnacʉ̃rẽ bairo caãcʉ̃,” qũĩ masĩẽma camasã pʉame. Bairi ricaati, noo na caborore bairo cʉ̃ áma, profeta majã na caquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo —na ĩ quetibʉjʉyupʉ Jesús Pedrojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ʉ̃tãʉ̃pʉ caetaatana na mena macããna na caãnopʉ rui etayuparã. Capããrã camasãrẽ na ĩñañuparã. Aperã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuerã Jesús cʉ̃ cabuerã mena bʉtioro ãmeo bʉsʉyuparã, bʉsʉnetõgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bairo na pʉame Jesús natʉ cʉ̃ caruietaro ĩña acʉacoasuparã. Bairi yua, cʉ̃tʉ atʉ ásúparã, cʉ̃ jẽniráná. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bairo na caatʉató: —¿Ñe ũnierẽ ãmeo bʉsʉrã mʉjãã átiati na mena? —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, camasã capããrã watoapʉ caãniatacʉ jĩcãʉ̃ bairo qũĩ yʉyupʉ: —Cabuei, yʉ macʉ̃ jĩcãʉ̃ã caãcʉ̃rẽ mʉtʉ cʉ̃ yʉ ne atíapʉ. Yʉ macʉ̃ wãtĩ yeri pũna jʉ̃gori bʉsʉmasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bairo wãtĩ yeri pũna pʉame yʉ macʉ̃rẽ cʉ̃ cajããrõĩ, cʉ̃ jʉ̃goñao joroque átiyami. Bairo cʉ̃ caáto, yʉ macʉ̃ pʉame cʉ̃ risero jopo witinucũñami. Cʉ̃ opi mena bacarʉpotu nucũñami. Tutuaʉ cʉ̃ bʉo joroque cʉ̃ átinucũñami. Bairi mʉ cabuerãrẽ bʉtioro na yʉ wiyorotimiapʉ wãtĩ yeri pũnarẽ. Mʉ cabuerã pʉame cʉ̃ wiyojo masĩẽtĩñama —qũĩ quetibʉjʉyupʉ wãtĩ yeri pũna cacʉ̃goʉ pacʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —¡Tame, mʉjãã, ati yepa caãna Dios cʉ̃ camasĩrĩjẽrẽ cariape mʉjãã tʉ̃goetimajũcõãña! Bairo mʉjãã cabairoi, yʉ tʉ̃goña yapapuajãñuña. ¿Nocãrõ yoaro mʉjãã mena yʉ ãnibujiocʉti? Jaʉ, toroque cawãmaʉrẽ ato pʉame cʉ̃ neasá —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bairo cʉ̃ caĩrõ tʉ̃go, cawãmaʉrẽ Jesutʉ cʉ̃ ne etayuparã. Bairo wãtĩ yeri pũna pʉame Jesure qũĩñarĩ, caʉ̃mʉrẽ cʉ̃ jʉ̃goñañupʉ̃ yepapʉ cʉ̃ risero jopo witirinʉcʉ̃pʉ̃. Bairo cʉ̃ jʉ̃goñaʉ, riañarĩqũẽrẽ bairo cʉ̃ ásupʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bairo cʉ̃ cabairo ĩña, atore bairo qũĩ jẽniñañupʉ̃ Jesús capacʉre: —¿Nocarõpʉ tore bairo cʉ̃ baijʉ̃gori? Cawãmaʉ pacʉ pʉame atore bairo qũĩ yʉyupʉ: —Cawĩmaʉaca ãcʉ̃pʉ̃na bairo baijʉ̃gowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Capee majũ wãtĩ peeropʉ cʉ̃ jʉ̃gorocajoe ánucũñami. Ape rʉ̃mʉrã riapʉ cʉ̃ jʉ̃gorocañua mecʉ̃nucũñami, cʉ̃ caria yasiparore bairo ĩ. Mʉ catutuarije mena cʉ̃rẽ mʉ canetõõmasĩata, jãã bopaca ĩñarĩ jãã jʉátinemoña. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Yʉre mʉ canʉcʉ̃bʉgoata, yʉ netõbojamasĩña. Yʉ mena catʉ̃goñatutuarã nipetirore nipetiri wãmerĩrẽ yʉ netõbojamasĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bairo cʉ̃ caĩrõ tʉ̃go, qũĩñupʉ̃ cariaʉ pacʉ Jesure tutuaro mena: —Mʉ mena yʉ tʉ̃goñatutuaya. Bairi nemojãñurõ mʉ mena yʉ tʉ̃goñatutuao joroque yʉ átinemoña. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bairo Jesús camasã capããrã cʉ̃ tʉpʉ na caatʉató ĩñaʉ, cʉ̃ jãnaoñupʉ̃ wãtĩ roro caácʉre. Atore bairo qũĩñupʉ̃ Jesús: —Wãtĩ yeri, camasãrẽ cabʉsʉena catʉ̃goenarẽ bairo caácʉ, tʉ̃goya. Mʉrẽ ñiña. Ãni, cawãmaʉ rupaʉre cʉ̃ witi ácʉ́ja. Pʉgani cʉ̃pʉre jããnemoeticõãña —qũĩñupʉ̃ Jesús wãtĩ yerire. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Bairo cʉ̃ caĩrõ, wãtĩ yeri pũna pʉame tocãrõã jicoquei cawãmaʉrẽ bʉtioro cʉ̃ yugui, cʉ̃ awajao joroque áti, cʉ̃ witicoásúpʉ yua. Bairo cʉ̃ caátó, cawãmaʉ wãtĩ yeri pũna cacʉ̃gomiatacʉ pʉame acũẽsupʉ. Cariacoatacʉre bairo baiyupʉ. Bairo cʉ̃ cabairo ĩñarĩ, capããrã ĩñuparã: “Merẽ riacuupi yua.” ");
INSERT INTO cbcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús pʉame cʉ̃ wãmopʉ ñerĩ, cʉ̃ tʉ̃gãwãmʉo nʉcõñupʉ̃. Bairo cʉ̃ caáto, cawãmaʉ pʉame wãmʉnʉcãcoasupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cabero Jesús wiipʉ cʉ̃ cajããrõ, aperã na camano, na jeto ãna, cʉ̃ cabuerã atore bairo Jesure qũĩ jẽniñañuparã: —¿Nopẽĩrã wãtĩ yeri pũnarẽ jãã acurocawiyojo masĩẽtĩcʉti? —qũĩ jẽniñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃: —Wãtĩã, jõ caãniatacʉre bairo caãnarẽ na mʉjãã caárotigata, cajʉ̃goye ʉgarique betiri mʉjãã jẽniñubuegarã Diore —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","To bero áná, Galilea macãtʉ netõásúparã Jesujãã. Jesús pʉame to cʉ̃ caátíere camasã na camasĩrõ boesupʉ, cʉ̃ cabuerãrẽ caquetibʉjʉñesẽãʉ̃ ãnirĩ. Atore bairo na ĩ quetibʉjʉyupʉ tunu: —Yʉ, Camasã Jʉ̃gocʉ, yʉ ñerotiecogʉ camasãrẽ. Bairi yʉ pajĩãrotiecogʉ. Bairo yʉ na capajĩãmiatacʉ̃ãrẽ, itia rʉ̃mʉ bero yʉ caticoagʉ tunu —na ĩ quetibʉjʉyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na pʉame tie cʉ̃ caĩrĩjẽrẽ tʉ̃gomajũcõãmirãcʉ̃ã, tiere tʉ̃gomasĩẽsuparã. Tunu bairoa Jesure cʉ̃ jẽniña uwijãñuñuparã tiere. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cabero Jesús cʉ̃ cabuerã mena Capernaum cawãmecʉti macãpʉ etayuparã. Bairo ti macã eta, na caãni wiipʉ na cajããrõ bero, atore bairo na ĩ jẽniñañupʉ̃ Jesús cʉ̃ cabuerãrẽ: —Maapʉ áná, ¿ñerẽ mʉjãã ãmeo bʉsʉpẽniatiati? ");
INSERT INTO cbcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mai, maapʉ áná, “¿Ni cʉ̃ ãnicʉti marĩ menarẽ caãnimajũʉ̃rẽ bairo caãcʉ̃?” ãmeo ĩ bʉsʉpẽni ásúparã. Bairo caãmeo ĩatana ãnirĩ boboori cʉ̃ yʉesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bairo na cayʉeto ĩña, Jesús pʉame cũmurõpʉ rui yaparori bero, “Tiaya mai,” na ĩñupʉ̃ Jesús cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ caãnarẽ. Atore bairo na ĩ quetibʉjʉyupʉ: —Aperã netõrõ carotimasĩrã mʉjãã caãnigaata, nipetirã bero macããnarẽ bairo mʉjãã caãnajẽ cʉtiere boya. Narẽ capaacoterãrẽ bairo caãniparã mʉjãã ãniña —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bairo ĩ yaparo, jĩcãʉ̃ cawĩmaʉrẽ na watoapʉ cʉ̃ nʉcõñupʉ̃. Bairo cʉ̃ nʉcõ, cʉ̃ nemʉgõrĩ, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ni jĩcãʉ̃ ũcʉ̃, yʉ yaye quetire tʉ̃goʉsari, ãni cawĩmaʉrẽ bairo caãcʉ̃rẽ cʉ̃ camaiata, yʉre camairẽ bairo cʉ̃ ñiñagʉ. Tunu bairoa yʉre camai cʉ̃ caãnoi, yʉ jeto mee Dios yʉre cajoricʉ cʉ̃ã cʉ̃rẽ camairẽ bairo qũĩñagʉmi —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan pʉame atore bairo qũĩñupʉ̃ Jesure: —Jããrẽ cabuei, apei caʉ̃mʉrẽ jãã ĩñawʉ̃. Cʉ̃ pʉame mʉ wãme mena ĩrĩ rotimasĩwĩ. Bairo rotimasĩrĩ yua, cʉ̃ acurewiyojowĩ wãtĩ yeri pũnarẽ, caʉ̃mʉrẽ cajãñamiatacʉre. Bairo cʉ̃ caáto ĩña, jãã pʉame cʉ̃ caátiere cʉ̃ jãã átirotiepʉ, marĩ mena macããcʉ̃ cʉ̃ caãmerõĩ —qũĩñupʉ̃ Juan Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús Juarẽ: —¿Nopẽĩrã cʉ̃rẽ, “Ápeina,” mʉjãã ĩrĩ? Bairo ĩẽtĩcõãña. Ni ũcʉ̃ yʉ wãme mena Diore jẽnirĩ apeye ũnierẽ átijẽñorĩ bero, roro yʉre ĩ masĩẽtĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jĩcãʉ̃ ũcʉ̃ caʉ̃mʉ marĩrẽ cʉ̃ catutieticõãta, marĩrẽ cajʉácʉre bairo caácʉ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ pʉame mʉjãã yʉ cabuerã mʉjãã caãno jʉ̃gori mʉjããrẽ cʉ̃ canʉcʉ̃bʉgoata, caroare cʉ̃ jogʉmi Dios caʉ̃mʉrẽ. Dise ũnieacãrẽ oco mʉjãã caetipee cʉ̃ãrẽ mʉjãã cʉ̃ cajoata, cʉ̃ caátie wapa nigaro —na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Ni jĩcãʉ̃ ũcʉ̃ apei yʉ mena catʉ̃goñatutuajʉ̃goʉre, cʉ̃ tʉ̃gomawijiao joroque cʉ̃ caápata, roro majũ baigʉmi Dios cʉ̃ caĩñabesepa rʉ̃mʉ caetaro. Jĩcãʉ̃ ʉ̃tãã capairica mena cʉ̃ wãmʉarẽ jiyaturi, ria capairiyapʉ na carurocaricʉre bairo netõjãñurõ popiye baigʉmi cʉ̃ ũcʉ̃ ti rʉ̃mʉrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bairi mʉjããrẽ ñinemoña tunu: Ni mʉjãã mena macããcʉ̃ cʉ̃ wãmorĩ mena jʉ̃gori carorije jetore átinucũʉ̃mi. Bairo cʉ̃ wãmorĩ mena jʉ̃gori roro caátipai cʉ̃ caãmata, apei cʉ̃ wãmorĩrẽ cayiseta rocaecoricʉre bairo cʉ̃ caãno, ñuña. Cʉ̃ rupaʉ macããjẽ wãmorĩ cacʉ̃goecʉre bairo baimicʉ̃ã, rupa tutua Diotʉ cʉ̃ caátó, ñujãñuña. Peeropʉ roro cʉ̃ caábujiorijere cʉ̃ netõõgʉmi Dios, tore bairo roro cʉ̃ caátiere cʉ̃ camasiritiata yua. Cʉ̃ wãmorĩ roro cʉ̃ átio joroque caátie mena cʉ̃gori roro peeropʉ cʉ̃ capopiye tãmʉoata roque, ñuetibujioro, yʉra. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Topʉre peero cʉ̃ã di rʉ̃mʉ ũno caʉ̃jãnaeti peero, cayatieti peero majũ nigaro. Becoa cʉ̃ã cariaena majũ nigarãma topʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tunu bairoa ni mʉjãã mena macããcʉ̃ cʉ̃ rʉpori mena jʉ̃gori carorije caána na caãnopʉ ánucũʉ̃mi. Bairo cʉ̃ rʉpori mena roro caápai cʉ̃ caãmata, apei cʉ̃ rʉporire cayisetarocaecoricʉre bairo cʉ̃ caãno, ñuña. Cʉ̃ rupaʉ macããjẽ rʉpori cacʉ̃goecʉre bairo baimicʉ̃ã, rupa tutua Diotʉ cʉ̃ caátó, ñujãñuña. Peeropʉ roro cʉ̃ caábujiorijere cʉ̃ netõõgʉmi Dios, tore bairo roro cʉ̃ cabainucũrĩjẽrẽ cʉ̃ cajãnaata yua. Cʉ̃ rʉpori roro cʉ̃ baio joroque caátie mena cʉ̃gori roro peeropʉ cʉ̃ capopiye tãmʉoata roque, ñuetibujioro, yʉra. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Topʉre peero cʉ̃ã di rʉ̃mʉ ũno caʉ̃jãnaeti peero, cayatieti peero majũ nigaro. Becoa cʉ̃ã cariaena majũ nigarãma topʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ cʉ̃ caapee mena jʉ̃gori carorije macããjẽ jetore ĩñanucũʉ̃mi. Bairo cʉ̃ caapee mena jʉ̃gori carorije macããjẽrẽ caĩñapai cʉ̃ caãmata, apei cʉ̃ caapeere cawerocaecoricʉre bairo cʉ̃ caãno, ñuña. Cʉ̃ rupaʉ macããjẽ cacaapee cʉ̃goecʉre bairo baimicʉ̃ã, cacaapee mácʉ̃ Diotʉ cʉ̃ caátó, ñujãñuña. Peeropʉ roro cʉ̃ caábujiorijere cʉ̃ netõõgʉmi Dios, tore bairo carorije macããjẽrẽ cʉ̃ caĩñajãnaata yua. Cʉ̃ caapee roro cʉ̃ átio joroque caátie mena cʉ̃gori roro peeropʉ cʉ̃ capopiye tãmʉoata roque, ñuetibujioro, yʉra. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Topʉre peero cʉ̃ã di rʉ̃mʉ ũno caʉ̃jãnaeti peero, cayatieti peero majũ nigaro. Becoa cʉ̃ã cariaena majũ nigarãma topʉre. Bairi roro mʉjãã caátinucũrĩjẽrẽ jãnacõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ati yepapʉ ãna, popiye mʉjãã baigarã. Peeropʉ marĩ caʉ̃rõ capũnirõrẽã bairo roro popiye netõrõ mʉjãã baigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa caocarije ñujãñuña. Moa caocaetie roque ñerẽ áti masĩẽtĩña camasãrẽ. Bairi moa caocarije capeticoaʉsapata, ñe ũnie pʉamerẽ ñuẽtĩña. Mʉjãã, yʉ cabuerã moa caocarijere bairo ãnajẽcʉsa. Ãmeo jʉátinemoña. Tunu bairoa jĩcã yericʉnarẽ bairo ãnajẽcʉsa,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bairo atiere cʉ̃ caĩquetibʉjʉro bero, Jesús to Capernaum caãniatacʉ, Judea yepapʉ acoásúpʉ. Rio Jordán muipʉ cʉ̃ cawãmʉatí nʉgõã pʉamepʉ acoásúpʉ. Bairo cʉ̃ caátó, capããrã camasã cʉ̃ ʉsayuparã. Bairi cʉ̃ caátinucũrõrẽ bairo Dios yaye cʉ̃ caquetibʉjʉnucũrĩjẽrẽ na quetibʉjʉyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bairo cʉ̃ caquetibʉjʉro, qũĩ jẽniñarã etayuparã jĩcããrã fariseo majã. “Carorije buei átiyami Jesús,” qũĩ bʉsʉjãgamirã, atore bairo cʉ̃ jẽniñamiñuparã: “Marĩ judío majã mena macããcʉ̃ ni jĩcãʉ̃ ũcʉ̃ cʉ̃ majũ cʉ̃ catʉ̃goñarõ jʉ̃gori cʉ̃ nʉmorẽ rocagʉ, ¿cõ cʉ̃ roca masĩcʉti?” qũĩ jẽniñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —¿Dope bairo Moisés ãnacʉ̃ cʉ̃ roticũñuparĩ camasãrẽ? —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bairo cʉ̃ caĩrõ, atore bairo qũĩñuparã: —Moisés ãnacʉ̃ atore bairo ĩ quetibʉjʉ cũñañupĩ: “Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ cʉ̃ carocagaata, atore bairo ĩrĩcã pũrõrẽ cõ cʉ̃ cajoata, ñurõ: ‘Bairo mʉ cabairoi, mʉrẽ teei, mʉrẽ yʉ pitiya,’” ĩ quetibʉjʉ cũñupĩ Moisés —qũĩñuparã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Mʉjãã ñicʉ̃jãã, mʉjããrẽ bairo ãmeo mairĩqũẽrẽ camasĩẽna na caãnoi, na mena macããcʉ̃ jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ carocagaʉre roro cʉ̃ caátiere ẽñotaesupi Moisés. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Baipʉa, bairo boesupi Dios caãnijʉ̃goripaʉpʉre. Ati ʉmʉrecóore atíjʉ̃goʉpʉa camasãrẽ átijʉ̃goʉ, caʉ̃mʉ carõmio cʉ̃ã na qũẽnojʉ̃goyupi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bairi jĩcãʉ̃ caʉ̃mʉ carõmio mena cʉ̃ cawãmojiyaata, cʉ̃ pacʉa tʉre witigʉmi. Ape wiipʉ ãnigʉmi cʉ̃ nʉmo mena. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bairo na cabairo, jĩcãʉ̃rẽ bairo na ĩñañami Dios. Jĩcã rupaʉre bairo nigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bairi Dios jĩcãʉ̃rẽ bairo cʉ̃ cacũrĩcãrã na caãnoi, ni jĩcãʉ̃ ũcʉ̃ na ricawa masĩẽcʉ̃mi. Na majũ cʉ̃ã ãmeo piti masĩẽtĩñama —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cabero wiipʉ ãna, Jesús cʉ̃ cabuerã cʉ̃ caĩquetibʉjʉatajere cʉ̃ jẽniñanemoñuparã tunu, masĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bairo na caĩjẽniñarõ, atore bairo na ĩñupʉ̃ Jesús: —Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ cõ rocari bero, tunu apeo mena cʉ̃ cawãmojiyaata, roro majũ caãnijʉ̃gorico mena ácʉ átiyami. Dios cʉ̃ caroticũrĩqũẽrẽ caápei majũ niñami. “Apeo mʉ nʉmo mee caãcõ mena ãmerĩcõãña,” cʉ̃ caĩcũrĩqũẽrẽ cabaibotioʉ majũ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tunu bairoa jĩcãõ ũcõ cõ manapʉre cʉ̃ rocari bero, tunu apei mena cõ cawãmojiyaata, roro majũ áco átiyamo. “Apei mʉ manapʉ mee caãcʉ̃ mena ãmerĩcõãña,” cʉ̃ caĩcũrĩqũẽrẽ cabaibotio majũ niñamo —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cabero tunu aperã na pũnaa cawĩmarãrẽ na jeasúparã Jesús tʉpʉ, na pãñarĩ, Diore na cʉ̃ jẽnibojaáto, ĩrã. Bairo na pũnaarẽ na cajeató ĩñarĩ, cʉ̃ cabuerã pʉame, “Na jeapéricõãña mʉjãã pũnaarẽ,” na ĩñuparã capacʉare. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bairo na caĩrõ tʉ̃go, asiari atore bairo na ĩñupʉ̃ Jesús: —Yʉtʉ pʉame cawĩmarãrẽ na atírotiya. Na ẽñotaeticõãña. Dios cʉ̃ carotimasĩrĩpaʉ macããnarẽ bairo caãna niñama cawĩmarã. Narẽ bairo cayeriñurã jeto ãnimasĩñama Dios cʉ̃ carotimasĩrĩpaʉpʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mʉjããrẽ cariape ñiña: Ni jĩcãʉ̃ ũcʉ̃ cawĩmaʉ cʉ̃ catʉ̃goñarõrẽ bairo Dios mena cʉ̃ catʉ̃goñatutuaeticõãta, Dios cʉ̃ carotimasĩrĩpaʉre etamasĩẽtĩgʉmi —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ĩ yaparo, cawĩmarãrẽ na nemʉgõ, cʉ̃ wãmorĩ mena na bui ñigãpeori, Diore na jẽnibojayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cabero Jesús aperopʉ cʉ̃ caápáro jʉ̃goye jĩcãʉ̃ cawãmaʉ cʉ̃tʉ atʉetari, cʉ̃ rʉpopaturi mena etanumurĩ qũĩroaʉ etayupʉ. Atore bairo qũĩ jẽniñañupʉ̃ cawãmaʉ Jesure: —Cañuʉ majũ cabuei, ¿dope bairo yʉ átibujiocʉti, caroa yeri capetietiere bócagʉ? ");
INSERT INTO cbcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —¿Nopẽĩ “Cañuʉ” yʉ mi piiyati? Cañuʉ, jĩcãʉ̃ã niñami, Dios jeto. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Merẽ mʉ masĩĩ Dios camasãrẽ cʉ̃ caátiroticũrĩqũẽrẽ: Pajĩãẽtĩcõãña camasãrẽ. Carõmio mena roro átiepeeticõãña. Aperã yayere jee rutieticõãña. Aperãrẽ cabʉgoroa na ĩbuitieticõãña. Tunu ĩtoeticõãña. Mʉ pacʉ, mʉ paco cʉ̃ãrẽ nʉcʉ̃bʉgoya —qũĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, atore bairo qũĩñupʉ̃ cawãmaʉ Jesure: —Cabuei, tie nipetirijere cawĩmaʉ ãcʉ̃pʉ̃na, yʉ átipeyocõã jʉ̃gowʉ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ maitʉ̃goñarĩ atore bairo qũĩ quetibʉjʉnemoñupʉ̃ Jesús tunu cawãmaʉrẽ: —Mai, jĩcã wãme mʉ rʉsacõãña. Mʉ cacʉ̃gorije nipetirijere nunirepeyocõãña. Tie wapare jeri, cabopacarãrẽ na ricawoya. Bairo mʉ caápata, jõbuipʉ pairo nigaro mʉ cawapatapee. Bairo yʉ caĩrõrẽ bairo áti yaparori, yʉ mena bapacʉsa —qũĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tiere tʉ̃go, cawãmaʉ pʉame tʉ̃goñarĩqũẽ pairi acoásúpʉ. Capee apeye ũnierẽ cacʉ̃goʉ ãnirĩ, Jesús cʉ̃ caĩrõrẽ bairo átigaesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bairo cʉ̃ caátó ĩña, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —¡Camasã apeye ũnierẽ capee cacʉ̃gori majã Dios cʉ̃ carotimasĩrĩpaʉre na caetapee masiriyojãñuña! —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bairo cʉ̃ caĩrõ tʉ̃go, tʉ̃go acʉacoasuparã cʉ̃ cabuerã. Bairi atore bairo na ĩnemoñupʉ̃ Jesús: —Yʉ yarã, tʉ̃gopeoya: Camasã apeye ũnierẽ capee cacʉ̃gori majã Dios cʉ̃ carotimasĩrĩpaʉre na caetapee masiriyojãñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Waibʉcʉ capai, camello, ãpõã pota opeacapʉ cʉ̃ cajã ãmewitiata, masiriyojãñuña. Bairo cʉ̃ caãmewitimasĩmiatacʉ̃ãrẽ, netõjãñurõ masiriyoro niña caʉ̃mʉ capee apeyere cacʉ̃goʉ Dios cʉ̃ carotimasĩrĩpaʉre cʉ̃ caetapee pʉame roque —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ cabuerã pʉame nemojãñurõ tʉ̃go acʉacoasuparã. Atore bairo ãmeo ĩñuparã na majũ: —Bairi toroque, ¿ni ũcʉ̃ cʉ̃ netõmasĩcʉti? ");
INSERT INTO cbcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús pʉame na ĩñarĩ, atore bairo na ĩñupʉ̃: —Dise ũnie camasã na caátimasĩẽtĩẽ nipetirije Dios cʉ̃ caátimasĩrĩjẽ jeto niña —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame bairo qũĩñupʉ̃ Jesure: —Jãã Quetiupaʉ, jãã roque merẽ nipetirije jãã cacʉ̃gorijere cũrĩ, mʉrẽ jãã bapacʉti ʉsajʉ̃gowʉ —qũĩñupʉ̃ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Ni jĩcãʉ̃ ũcʉ̃ yʉ mena bapacʉtigʉ yʉ yaye caroa quetibʉjʉriquere jʉquetibʉjʉgʉ, cʉ̃ ya wiire, o cʉ̃ bairãrẽ, cʉ̃ bairã rõmirĩrẽ, cʉ̃ pacʉare, cʉ̃ pũnaarẽ, o cʉ̃ ya yepa cʉ̃ãrẽ cʉ̃ caaweyocoápáta, narẽ cʉ̃ cacʉ̃goro netõjãñurõ bócanemogʉmi tunu ati yepapʉre ãcʉ̃ cʉ̃ yaye ũnierẽ, bairi cʉ̃ yarã ũna cʉ̃ãrẽ. Bairi jĩcãʉ̃rẽ cʉ̃ caaweyocoápáta, cʉ̃ netõrõ cien bui peoro cãrõ majũ bócanemogʉmi. Yʉ yaʉ cʉ̃ caãnie jʉ̃gori aperã popiye cʉ̃ baio roque cʉ̃ na caátimiatacʉ̃ãrẽ, bairo jeto bócanemogʉmi cʉ̃ ya wiirire, o cʉ̃ bairãrẽ, cʉ̃ bairã rõmirĩrẽ, cʉ̃ pacʉare, cʉ̃ pũnaarẽ, o cʉ̃ ya yepaa cʉ̃ãrẽ. Tunu ape ʉmʉrecóo caetaro, cʉ̃gonemogʉmi yeri capetietiere. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Apeyera tunu ati rʉ̃mʉrĩrẽ camasã jĩcããrã rotimasĩmirãcʉ̃ã, caberopʉ na mena macããnarẽ na rotimasĩẽtĩgarãma. Tunu bairoa ati rʉ̃mʉrĩrẽ camasã jĩcããrã rotimasĩẽtĩmirãcʉ̃ã, caberopʉ na mena macããna capããrãrẽ carotimasĩrã majũ nigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cabero Jesujãã Jerusalẽpʉ caãniatí wããpʉ ásúparã. Jesús pʉame cʉ̃ cabuerã jʉ̃goyere ásúpʉ. Bairo cʉ̃ cabairo ĩña, cʉ̃ cabuerã tʉ̃gocõã maniásuparã. Tunu bairoa nipetirã cʉ̃ bero caʉsarã uwitʉ̃goñañuparã. Bairo na cabairo ĩña, Jesús pʉame cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ camasã watoa caãnarẽ na piijori, atore bairo na ĩñupʉ̃ cʉ̃ cabaipeere: ");
INSERT INTO cbcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jerusalẽpʉ marĩ caátíere merẽ mʉjãã masĩña. Topʉ ti macã macããna pʉame yʉ, Camasã Jʉ̃gocʉre, yʉ ñerĩ, yʉ jogarãma sacerdote majã quetiuparãrẽ, bairi Moisés ãnacʉ̃ cʉ̃ caquetibʉjʉcũrĩqũẽrẽ cajʉ̃gobueri majãrẽ. Bairo na caáto, sacerdote majã quetiuparãjãã pʉame yʉ pajĩãroca rotigarãma. Bairo átirotiri yua, judío majã caãmerãrẽ yʉ nuni rocacõãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Roro ñiepegarãma. Na ʉco mena yʉ eyotu epegarãma. Bairo átiri, roro majũ yʉ bape epegarãma. Bairo yʉ átieperi, yʉ pajĩã rocacõãgarãma. Bairo yʉre na caátimiatacʉ̃ãrẽ, itia rʉ̃mʉ bero caãno yʉ pʉame yʉ caticoagʉ tunu,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cabero Santiago, Juan Zebedeo pũnaa Jesús tʉpʉ atí, atore bairo qũĩñuparã: —Jããrẽ cabuei, mʉrẽ jãã cajẽnirĩ wãme jããrẽ mʉ caátibojaro jãã boya —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Bairo na caĩrõ tʉ̃go: —¿Ñerẽ mʉjãã yʉ caáto mʉjãã boyati? —na ĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na pʉame bairo qũĩñuparã: —Ati yepare mʉ carotimasĩrĩpaʉ caetaro, mʉtʉ jãã mʉ caruirotiro jãã boya. Jĩcãʉ̃ cariape nʉgõã, apei caãcõ nʉgõã jãã mʉ caruirotiro jãã boya. “Jaʉ,” miwã —qũĩñuparã Juan, Santiago mena Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Mʉjãã caĩjẽnirĩjẽ cabaipeere caroaro mʉjãã masĩẽtĩña. Bʉtioro popiye bairicarore mʉjãã jẽnimiña. Yʉ pʉame popiye yʉ baigʉ. Yʉre bairo popiye mʉjãã cabaiata, ¿mʉjãã nʉcãmasĩrãti? —na ĩñupʉ̃ Jesús Juarẽ, bairi Santiago cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bairo cʉ̃ caĩrõ tʉ̃go: —Mʉrẽã bairo jãã nʉcãmasĩña —qũĩñuparã. Bairi Jesús pʉame atore bairo na ĩnemoñupʉ̃: —Yʉ cabaiparore bairo popiye mʉjãã baigarã mʉjãã cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Baipʉa, yʉ majũ yʉre cajʉrotiparã, yʉtʉ cariape nʉgõã, bairi caãcõ nʉgõã caruiparãrẽ na yʉ besemasĩẽtĩña. Yʉ Pacʉ pʉame roque bairo caãniparãrẽ na besemasĩñami —na ĩñupʉ̃ Jesús Juarẽ, bairi Santiago cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cabero Jesús cʉ̃ cabuerã pʉga wãmo cãnacãʉ̃ caãna majũ, Santiago, Juan mena Jesure na caĩjẽniñaatajere catʉ̃goatana ãnirĩ, na mena asiajãñuñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús pʉame tiere ĩña, cʉ̃tʉ na piijori atore bairo na ĩ quetibʉjʉyupʉ: —Merẽ mʉjãã masĩña ati ʉmʉrecóo macããna na caátiãnierẽ. Ati yepa macããna Diore caĩroaena quetiuparã reyre bairo caãna tutuaro mena rotiepeyama na roca macããnarẽ. Popiye na baio joroque na rotiepeyama. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉjãã pʉame roquere tore bairo baietirotiya. Bairo pʉame bairotiya mʉjããrẽ: Mʉjãã mena macããcʉ̃, caãnimajũʉ̃rẽ bairo caãnigaʉ, mʉjãã roca netõjãñurõ carotimasĩrẽ bairo ãnirotiya. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tunu bairoa mʉjãã mena macããcʉ̃, carotimajũʉ̃rẽ bairo caãnigaʉ, mʉjãã ʉ̃mʉrẽ bairo cʉ̃ caãmata, ñurõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yʉ, Camasã Jʉ̃gocʉ, quetiupaʉ majũrẽ bairo yʉre capaabojaparãrẽ macãʉ̃ acʉ́ mee yʉ apʉ́ ati yepapʉre. Camasãrẽ na jʉátinemoʉ acʉ́ yʉ apʉ́ ati yepapʉre. Tunu bairoa yʉ cariarije jʉ̃gori camasã na carorije wapare netõʉ̃ acʉ́ yʉ apʉ́ —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cabero Jericó na caĩrĩ macãpʉ etayuparã. Bairo ti macãpʉ caãniatana ti macãrẽ na cawitiro, cʉ̃ cabuerã Jesús berore ʉsayuparã. Capããrã camasã cʉ̃ã cʉ̃ bero ʉsayuparã. Bairo na caátó, jĩcãʉ̃ cacaapee ĩñaecʉ̃ Bartimeo cawãmecʉcʉ, Timeo macʉ̃ maa tʉpʉ dinerore jẽni ruiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cʉ̃, cacaapee ĩñaecʉ̃ pʉame, “Jesús Nazaret macã macããcʉ̃ netõácʉ́ baiyami,” na caĩrõ tʉ̃gori, bʉsʉrique tutuaro mena atore bairo qũĩ joyupʉ Jesure: —¡Jesús, David ãnacʉ̃ pãrãmi, bopacooro ñiñaña! ");
INSERT INTO cbcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bairo cʉ̃ caĩrõ, capããrã camasã pʉame cʉ̃ tutiyuparã, cʉ̃ awajaeticõãto, ĩrã. Bairo cʉ̃rẽ na caĩmiatacʉ̃ãrẽ, bʉtioro jãñurĩ awajanemoñupʉ̃ tunu: —¡David ãnacʉ̃ pãrãmi, bopacooro ñiñaña! ");
INSERT INTO cbcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús pʉame bairo cʉ̃ caĩawajarijere tʉ̃gori tuanʉcãñupʉ̃. Tuanʉcãrĩ yua, “Cʉ̃ piijoya,” na ĩñupʉ̃ Jesús cʉ̃tʉ caãnarẽ. Bairo cʉ̃ capiirotiro tʉ̃go, bairo qũĩñuparã to macããna cacaapee ĩñaecʉ̃rẽ: —Tʉ̃goñarĩqũẽ paieticõãña. Wãmʉnʉcãrĩ asá Jesutʉ. Mʉrẽ pii átiyami. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bairo na caĩrõ tʉ̃go, cacaapee ĩñaecʉ̃ pʉame jicoquei cʉ̃ jutiro cabuimacããtõrẽ wẽrocacũrĩ, pati wãmʉnʉcã acoásúpʉ Jesús tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bairo cʉ̃ caetaro ĩña, Jesús pʉame: —¿Ñerẽ mʉ yʉ caáto mʉ boyati? —qũĩ jẽniñañupʉ̃. Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, bairo qũĩñupʉ̃ cacaapee ĩñaecʉ̃ Jesure: —Yʉ Quetiupaʉ, caĩñamasĩẽcʉ̃ ãnirĩ ñiñamasĩgaya tunu —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús Bartimeorẽ: —Tunu ácʉ́ja mʉ ya wiipʉ. Yʉ mena mʉ catʉ̃goñatutuarije jʉ̃gori mʉ caapee ĩñamasĩõ joroque mʉ yʉ átiya. Bairo cʉ̃ caĩrõ, jicoquei ĩña masĩcoasupʉ yua. Bairo ĩña masĩrĩ bero, maapʉ Jesús berore ʉsa ásúpʉ Bartimeo cʉ̃ã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bairo Jerusalén tʉpʉ cõñaáná yua, Betfagé, Betania na caĩrĩ macããrẽ, Olivo buro tʉre etayuparã Jesujãã. Bairo etarã, Jesús pʉame cʉ̃ cabuerã pʉgarãrẽ macãpʉ na ájʉ̃gorotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Atore bairo na ĩ joyupʉ: —Ánája ato riape caãni macããcãpʉ. Topʉ etarã, jicoquei burro jiyanʉcõrĩcʉ̃rẽ cʉ̃ mʉjãã bócagarã. Cʉ̃, burro pʉame mai camasã na capesañaecʉ̃ nigʉmi. Cʉ̃rẽ cʉ̃ õwãrĩ, cʉ̃ mʉjãã neapá yʉ tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bairi tunu aperã mʉjããrẽ, “¿Nopẽĩrã cʉ̃ mʉjãã õwãñati?” na caĩata, atore bairo na mʉjãã ĩwã: “Marĩ Quetiupaʉ cʉ̃ boami. Yoaro mee mʉjãã tunuogʉmi tunu mʉjãã burrore,” na mʉjãã ĩwã —na ĩ joyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bairo cʉ̃ caĩrõ tʉ̃go cʉ̃ cabuerã pʉgarã pʉame acoásúparã. Bairo áná yua, burrore cʉ̃ bócayuparã. Wii jopetʉ maa tʉ̃ni na cajiyanʉcõãtacʉre cʉ̃ bócayuparã. Cʉ̃ bócaetari yua, cʉ̃ õwãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bairi burrore na caõwãrõ ĩñarĩ, to macããna jĩcããrã atore bairo na ĩñuparã: —¿Ñerẽ mʉjãã átiyati? ¿Nopẽĩrã cʉ̃ mʉjãã õwãñati? ");
INSERT INTO cbcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bairo na caĩrõ tʉ̃go, Jesús cʉ̃ cabuerã pʉame Jesús na cʉ̃ caĩrotiatatore bairo na ĩ yʉyuparã to macããnarẽ. Bairo na caĩyʉro, burro uparã pʉame, “Toroque cʉ̃ neánája,” na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bairo Jesutʉ burrore na cane etaro yua, na jutii, cabui macããjẽrẽ, burro buire peoyuparã. Bairo na caáto, Jesús pʉame burro buipʉ wãmʉ peayupʉ. Bairo cʉ̃ buipʉ pesari yua, ásúpʉ Jesús Jerusalẽpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bairo cʉ̃ caátó, to macããna capããrã camasã na jutii cabui macããjẽrẽ esocũñuparã maa cʉ̃ caátí wããrẽ. Aperã maatʉ macããjẽ pepũũ queeri ũnierẽ patanerĩ Jesús jʉ̃goyere piticũ jʉ̃goyuparã, Jesure qũĩroari ʉseanirã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bairo bairã, nipetiro Jesús jʉ̃goye macããna, cʉ̃ bero macããna cʉ̃ã bʉsʉrique tutuaro mena atore bairo qũĩ basapeo jʉ̃goyuparã: —¡Ñumajũcõãña! ¡Jesús, Dios cʉ̃ cajoʉ marĩ Quetiupaʉ majũ cʉ̃ caãnoi, cʉ̃rẽ marĩ cabasapeoro ñuña! ");
INSERT INTO cbcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Quetiupaʉ rey David marĩ ñicʉ̃ ãnacʉ̃ cʉ̃ caãnatõrẽ bairo caroaro to baicõã ãmarõ! ¡Nipetiro cʉ̃ marĩ basapeoroa Dios ʉmʉrecóo macããcʉ̃rẽ! —qũĩ basapeoyuparã to macããna. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bairo na cabasa ãno ũno, etayupʉ Jesús Jerusalẽpʉ. Topʉ eta, jããñupʉ̃ Jesús Dios ya wii, templo wiire. Bairo ti wiire jããnʉcã, nipetiropʉ ĩñapeyocõãñupʉ̃ Jesús. Ĩñapeyo yaparo, tocãrõã acoásúpʉ Betania macãpʉ cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ caãnacãʉ̃ mena, merẽ ñamicã caãnoi yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cabusuri rʉ̃mʉ caãno tunucoásúpʉ Jesús Jerusalẽpʉ tunu. Bairo ti macãpʉ ácʉ́, queya tʉ̃goñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bairo queyari, jĩcãʉ̃ yucʉ higuera cawãmecʉtiire yoajãñurõpʉa ãcʉ̃ ĩñajoyupʉ. Bairo ĩñajo yua, carícare ĩñaʉ ásúpʉ. Bairo carícare cʉ̃ camacãmiatacʉ̃ãrẽ, capũũ jeto nicõãñuparõ. Ríca mañuparõ. Carícacʉti yʉtea mee ãñuparõ mai. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bairo tii otei carícamanoi, atore bairo ĩñupʉ̃ Jesús ti oteire: —¡Atii tocãrõã ríca manigaro yua! Ni ũcʉ̃ ati rícare ʉgaetigʉmi yua. Bairo cʉ̃ caĩrĩjẽrẽ cʉ̃ cabuerã pʉame tʉ̃goyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cabero Jerusalẽpʉ na caetaro bero, Jesús pʉame jããñupʉ̃ templo capairi wii, ñubuerica wiire. Ti wiire jããetari, to macããna nunirĩ cawapatari majãrẽ, bairi wapatiri majã cʉ̃ãrẽ na acurewiyojo jʉ̃goyupʉ. Tunu moneda tiirire cawasoari majã mesarire, bairi buare cawapatiri majã ya mesari cʉ̃ãrẽ tujerecũ peyocoásupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bairo átiri yua, aperãrẽ apeye ũnierẽ cʉ̃gori, o pʉsari, templo wii recomacãpʉ caánucũrãrẽ na netõárotiesupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bairo áti yaparo, atore bairo na ĩ quetibʉjʉyupʉ to macããnarẽ: —Dios cʉ̃ caquetibʉjʉri tutipʉ bairo ĩña: “Yʉ ya wii ati ʉmʉrecóo nipetiro camasã na cañubueri wii, ñubuerica wii majũ nigaro,” ĩña. Bairo caĩquetibʉjʉmiatacʉ̃ãrẽ, mʉjãã pʉame apeye arʉare bairo mʉjãã átiya. Camasãrẽ jeruti nunirĩ majãrẽ bairo caãna ãnirĩ jerutiri majã na caãni wii, ʉ̃tã wiire bairo mʉjãã átiya ati wii, Dios ya wiire —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bairo cʉ̃ caĩquetibʉjʉrijere tʉ̃gorã, sacerdote majã quetiuparã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã cʉ̃ã, “¿Dope bairo átiri cʉ̃ marĩ pajĩãrãati?” ãmeo ĩ bʉsʉpẽni jʉ̃goyuparã na majũ. Mai, cʉ̃ uwiyuparã Jesure, nipetiro camasã Jesús yaye cʉ̃ quetibʉjʉrijere caroaro cʉ̃ na catʉ̃goʉsacõã maniátie jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cabero canaioatípaʉ caãno ĩña yua, Jesús cʉ̃ cabuerã mena ti macã Jerusalẽrẽ witicoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cabusuri rʉ̃mʉ caãno higuera yucʉtʉ netõásúparã. Bairo áná, higuera yucʉre canʉcõrĩpʉa cajĩni yasiatacʉre ĩñajoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bairo na caĩñajoro, Pedro pʉame Jesús cʉ̃ caĩrĩqũẽrẽ tʉ̃goñabocari, atore bairo qũĩñupʉ̃ Jesure: —Yʉ Quetiupaʉ, ĩñajoya. Jicʉ, “Tocãrõã ríca manigaro,” mʉ caĩñaatacʉ pʉame merẽ jĩnicuupa —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —Dios mena tʉ̃goñatutuaya. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cariape mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ atii ʉ̃tãʉ̃rẽ etari, “Wãáti ria capairiyapʉ etanʉcãrõjã,” cʉ̃ caĩata, cʉ̃ caĩrõrẽã bairo baibujioro tii ʉ̃tãʉ̃ pʉame. “Yʉ caĩrõrẽ bairo baicoagaro,” pʉgani cãrõ tʉ̃goñarĩ mee, cariape cʉ̃ caĩtʉ̃goñatutuacõãta, cʉ̃ caĩrõrẽã bairo baigaro yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Yʉ cajẽnirõrẽã bairo jogʉmi Dios,” cariape ĩ tʉ̃goñatutuacõãña. Bairo mʉjãã caĩtʉ̃goñatutuacõãta, nipetiri wãme cʉ̃ mʉjãã cajẽnirĩjẽrẽ mʉjãã jomajũcõãgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tunu bairoa Diore mʉjãã cajẽniparo jʉ̃goye, aperã camasã mena roro mʉjãã caátaje caãmata, na mena mʉjãã cabʉsʉqũẽnorõ ñuña, marĩ Pacʉ Dios ʉmʉrecóopʉ caãcʉ̃ cʉ̃ã roro mʉjãã caátajere mʉjãã cʉ̃ camasiriyobojaparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bairo roro mʉjããrẽ na caátajere na mʉjãã cabʉsʉqũẽnoeticõãta roque, marĩ Pacʉ Dios cʉ̃ã roro mʉjãã caátajere mʉjãã masiriyobojaetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tipaʉ bero etayuparã tunu Jesujãã Jerusalẽpʉ. Bairo etarã, templo wiipʉ jããñuparã. Bairo Jesús pʉame topʉ cʉ̃ cañesẽã ãnitoye, sacerdote majã quetiuparã, aperã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, aperã judío majã cabʉtoa camasĩrĩ majã cʉ̃ã cʉ̃tʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bairo cʉ̃tʉ etari, atore bairo qũĩ jẽniñañuparã Jesure: —¿Noa ũna na carotiro mena bairo mʉ átiati ñamicã mʉ caátiatajere? ");
INSERT INTO cbcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús fariseojããrẽ: —Yʉ cʉ̃ã mʉjããrẽ jĩcã wãme yʉ jẽniñagʉ. Cariape yʉ mʉjãã yʉwa: ¿Ni ũcʉ̃ camasãrẽ cʉ̃ bautiza rotijoyupari Juan ãnacʉ̃rẽ? ¿Dios, o camasã pʉame cʉ̃ na bautiza rotijoyupari? Tiere cariape yʉ mʉjãã caĩquetibʉjʉata, yʉ cʉ̃ã cariape mʉjããrẽ yʉ quetibʉjʉgʉ, “Noa ũna na carotiro mena bairo yʉ átiya,” mʉjãã ñigʉ —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bairo cʉ̃ caĩrõ tʉ̃go, yasioroaca ãmeo bʉsʉyuparã na majũ cʉ̃rẽ na caĩyʉpeere: “¿Nopẽ bairo cʉ̃ marĩ yʉrãati? ‘Dios pʉame cʉ̃ bautiza rotijoricʉmi Juarẽ,’ marĩ caĩata, ‘Toroque, ¿nopẽĩrã Juan ãnacʉ̃ cʉ̃ caquetibʉjʉriquere cariape mʉjãã tʉ̃goeti?’ marĩ ĩbujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tunu bairoa, ‘Camasã pʉame cʉ̃ bautiza rotijoricarãma Juarẽ,’ marĩ ĩ masĩẽtĩña, marĩrẽ tutirema ĩrã,” yasioroaca ãmeo ĩ bʉsʉyuparã. Mai, camasãrẽ na tʉ̃goña uwiyuparã. Na, nipetiro camasã pʉame, “Juan, Dios cʉ̃ caquetibʉjʉrotijoricʉ ãmi,” ĩ tʉ̃goñarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bairi, “Jãã masĩẽtĩña Juarẽ cabautiza rotijoricʉre,” qũĩñuparã fariseo quetiuparãjãã Jesure. Bairo na caĩrõ tʉ̃go, Jesús pʉame bairo na ĩñupʉ̃: —Cariape yʉ mʉjãã yʉetiya. Bairi yʉ cʉ̃ã, “Noa ũna na carotiro mena tore bairo yʉ átimasĩña,” mʉjããrẽ ñi quetibʉjʉetigʉ —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ĩ quetibʉjʉ yaparo, ati wãme ĩcõñarĩ na quetibʉjʉ jʉ̃goyupʉ Jesús. Atore bairo na ĩñupʉ̃: “Ãñupʉ̃ jĩcãʉ̃ wese upaʉ. Cʉ̃ pʉame ʉse wesere qũẽnoñupʉ̃. Bairo ti wesere ote yaparo, cʉ̃ wesere jãnía ẽñotayupʉ ʉ̃tã rupaa mena. Áti yaparo, ʉse ocore na canumuparo cʉ̃ãrẽ qũẽnoñupʉ̃. Áti yaparo, na cacoteri wii caʉ̃mʉarĩ wii, torre cʉ̃ãrẽ qũẽnoñupʉ̃. Bairo qũẽno yaparori bero, acoásúpʉ cayoaropʉ. Mai, ágʉ jʉ̃goye, cʉ̃ wesere wasocũñupʉ̃ aperã paari majãrẽ, wapatagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cabero yua, ʉse cabʉtiri yʉtea caetaro masĩrĩ, cʉ̃ ʉ̃mʉ jĩcãʉ̃rẽ cʉ̃ joyupʉ cʉ̃ ya wesere cʉ̃ cawasoricarã tʉpʉ. Cʉ̃rẽ na cawasorique wapare boʉ, cʉ̃ joyupʉ, tie wapare cʉ̃ jeatíbojaáto, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bairo cʉ̃ ʉ̃mʉrẽ cʉ̃ cajomiatacʉ̃ãrẽ, wese paari majã pʉame, cʉ̃ caetaro cʉ̃ qũẽñuparã. Bairo cʉ̃ qũẽrĩ, ñe ũnie mácʉ̃ cʉ̃ átitunuo joyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tunu ti wese upaʉ pʉame apei cʉ̃ ʉ̃mʉrẽ cʉ̃ joyupʉ. Cʉ̃ cʉ̃ãrẽ torea bairo cʉ̃ ásuparã. Roro cʉ̃ átieperi, cʉ̃ rʉpoare rií witio joroque cʉ̃ payuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Cabero ti wese upaʉ apei cʉ̃ ʉ̃mʉrẽ cʉ̃ joyupʉ tunu. Bairo topʉ cʉ̃ caetaro, cʉ̃ pajĩã rocacõãñuparã ti wese cacoteri majã yua. Cabero capããrã na jonemomiñupʉ̃ tunu. Bairo topʉ na caetaro, ti wesere cacoteri majã pʉame jĩcããrãrẽ na qũẽñuparã. Aperãrẽ na pajĩã recõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Bairo na caáto bero, jĩcãʉ̃ã rʉsayupʉ yua, cʉ̃ macʉ̃ bʉtioro cʉ̃ camai majũʉ̃ jeto. Bairo bairi ti wesepʉ cʉ̃ joyupʉ, atore bairo ĩ tʉ̃goñarĩ: ‘Cʉ̃ roquere cʉ̃ nʉcʉ̃bʉgobujiorãma, yʉ macʉ̃ cʉ̃ caãnoi.’ ");
INSERT INTO cbcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bairo cʉ̃ caĩtʉ̃goñamiatacʉ̃ãrẽ, wese paari majã pʉame ti wese upaʉ macʉ̃ cʉ̃ caatóre ĩñarĩ, ãmeo ĩñuparã: ‘Atíyami ati wese upaʉ macʉ̃. Cʉ̃ã niñami cʉ̃ pacʉ cʉ̃ cariaro bero ati wesere cacʉ̃goʉsapaʉ. Bairi cʉ̃ marĩ pajĩãrocacõãto. Bairo marĩ caápata, ati wese uparãrẽ bairo marĩ tuagarã,’ ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bairo caĩrã ãnirĩ na caĩrõrẽã bairo ásuparã. Ti wese tʉ̃nipʉ cʉ̃ ñeowa átí, cʉ̃ pajĩã rocacõãñuparã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩ jẽniñañupʉ̃ cʉ̃ caĩrĩjẽrẽ catʉ̃gori majãrẽ: “¿Dope bairo ácʉmi mʉjãã ĩ tʉ̃goñañati cʉ̃ macʉ̃rẽ na capajĩãrocaro bero ti wese upaʉ pʉame? Bairo átigʉmi: Topʉ á, ti wese paari majãrẽ na pajĩã recõãgʉmi. Bairo na átireri bero, aperãrẽ cʉ̃ wesere coteroticũgʉmi,” na ĩñupʉ̃ Jesús cʉ̃ caĩrĩjẽrẽ catʉ̃gori majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “¿Atie quetibʉjʉcũrĩqũẽrẽ mʉjãã ĩñaetinucũñati Dios yaye bʉsʉrica tutipʉ? Mʉjãã masĩrã. Bairo ĩña: ‘Ʉ̃tã mena cawii qũẽnorĩ majã jĩcã ʉ̃tããrẽ na caboetimiatacʉ̃ãrẽ, tia pʉame caãnimajũrĩcã nigaro. Tia camanicõãta, wii manibujioricaro. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios pʉame bairoa ásupi. Bairo cʉ̃ caátore ĩñarã, marĩ tʉ̃goña ʉseaniña,’ ĩ quetibʉjʉya Dios yaye bʉsʉrica tutipʉ,” na ĩ quetibʉjʉyupʉ Jesús tia ʉ̃tããrẽ bairo cʉ̃ cabairijere. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, to macããna pʉame masĩcõãñuparã Jesús cʉ̃ caĩrĩjẽrẽ. “Marĩ pʉame tia ʉ̃tããrẽ carocari majãrẽ bairo marĩ ãniña. Bairi marĩrẽã ĩgʉ ĩcʉ̃mi Jesús,” ĩ tʉ̃goñañuparã. Bairo ĩ tʉ̃goñamasĩrĩ jicoquei Jesure cʉ̃ ñegamiñuparã. Bairo cʉ̃ ñegamirãcʉ̃ã, cʉ̃ ñemasĩẽsuparã, camasãrẽ na uwirã. Bairi tocãrõã jãnarĩ acoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cabero tunu fariseo majã jĩcããrã bairi Herodes yarã cʉ̃ãrẽ Jesutʉ na joyuparã, “¿Dope bairo rorije cʉ̃ bʉsʉo joroque marĩ ánaati? Bairo roro Jesús cʉ̃ cabʉsʉata, cʉ̃ marĩ bʉsʉjã masĩgarã,” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bairi na cajoatana Jesús tʉpʉ etarã, atore bairo qũĩ jẽniñañuparã: —Cabuei, jãã masĩña merẽ mʉ caátiãnierẽ. Mʉa, caroaro cariape minucũña. Aperã roro na cabaurije, aperã caroaro na cabaurije jʉ̃gori mee na miñabeseya. Mʉa, cariapea Dios marĩrẽ cʉ̃ caãnirotiricarorea bairo mʉ bueya. Bairo cabai ãnirĩ, ¿dope bairo mi tʉ̃goñañati romano majã marĩrẽ na carotirijere? ¿To ñuñati quetiupaʉ emperadore camasã yaye dinerore jeri, jãã cajoata, o to ñueticʉti? —qũĩ jẽniñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús pʉame roro na caĩtʉ̃goñarĩjẽrẽ masĩcõãrĩ, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã, “Roro qũĩáto,” caĩrãrẽ bairo yʉ mʉjãã ĩ jẽniñañati? Jaʉ, yʉre joñijate moneda tiire, caroaro marĩ caĩñaparore bairo ĩrã —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bairo na canunirõ, atore bairo na ĩñupʉ̃: —¿Noa riapé to tusayati, ti moneda tiiacapʉre? Tunu bairoa, ¿noa wãme woaturique to tusayati? —na ĩ jẽniñañupʉ̃ Jesús. Bairo cʉ̃ caĩrõ, na pʉame ĩñuparã: —Emperador quetiupaʉ ya wãme, bairi tunu, cʉ̃ riape tusaya ti tii moneda tiiacapʉre —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bairo na caĩquetibʉjʉro, atore bairo na ĩnemoñupʉ̃ Jesús tunu: —Toroque emperador quetiupaʉre cʉ̃ yaye caãnierẽ cʉ̃rẽ cʉ̃ tunuojoya. Tunu bairoa Dios yaye caãnierẽ Diore cʉ̃ jonucũña —na ĩ quetibʉjʉyupʉ Jesús fariseojããrẽ. Bairo cʉ̃ caĩrõ tʉ̃gorã, cʉ̃ caĩquetibʉjʉrijere tʉ̃go acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cabero jĩcããrã saduceo majã na caĩrã qũĩñarásúparã Jesure. Mai, saduceo majã pʉame atore bairo caĩtʉ̃goñarĩ majã ãñuparã: “Camasã cariacoatana, nopẽ bairo catitunu masĩẽnama,” ĩ tʉ̃goñañuparã. Bairi atore bairo qũĩñuparã Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Cabuei, Moisés ãnacʉ̃ atore bairo marĩrẽ ĩ woacũñañupĩ tirʉ̃mʉpʉre: “Ni jĩcãʉ̃ ũcʉ̃ cawãmojiyaricʉ cʉ̃ nʉmo mena pũnaa mácʉ̃ã cʉ̃ cariacoapata, cʉ̃ ãnacʉ̃ bai pʉame cʉ̃ buiacore cõ cʉ̃ wãmojiyaáto. Bairo cʉ̃ caáto, cʉ̃ pũnaa caãniparã pʉame cʉ̃ ãnacʉ̃ pũnaarẽ bairo ãnibujiorãma,” ĩcũñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tiere mʉ masĩĩ. Bairi ape wãmerẽ ĩcõñarĩ jãã quetibʉjʉpa mai: Ãñuparã jĩcãni, jĩcã wãmo peti pʉga pẽnirõ caãnacʉ̃ã majũ jĩcãʉ̃ pũnaa. Bairi cajʉ̃gocʉ pʉame wãmojiya jʉ̃goyupʉ. Cabero pũnaa mácʉ̃ã riacoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bairi cʉ̃ ãnacʉ̃ bai pʉame cʉ̃ buiacore wãmojiyayupʉ tunu. Cabero pũnaa mácʉ̃ã riacoásúpʉ cʉ̃ cʉ̃ã. Tunu bairoa cʉ̃ ãnacʉ̃ bai apei pʉame cʉ̃ buiacore wãmojiyayupʉ tunu. Cabero cʉ̃ cʉ̃ã riacoásúpʉ pũnaa mácʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bairi bairo jeto baiyuparã nipetiro na ãnana bairã, aperã cʉ̃ã. Bairo nipetiro cõ mena nʉmocʉtimirãcʉ̃ã, cõ mena pũnaa mána jeto riapeticoasuparã. Cabero na ãnana nʉmo caãnimirĩcõ cʉ̃ã riacoásúpo. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bairo ati yepapʉ nipetirã nʉmo caãnacõ ãnirĩ yua, cariaricarã tunu na cacatiropʉ na caãno, ¿ni nʉmo majũ cõ ãnicʉti? —qũĩ jẽniñañuparã saduceo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩ quetibʉjʉyupʉ Jesús: —Mʉjãã, saduceo majã, Dios yaye cʉ̃ caquetibʉjʉcũrĩqũẽ, bairi cʉ̃ tutuarije cʉ̃ãrẽ mʉjãã tʉ̃goña mawijiacoaya, bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ape ʉmʉrecóore caʉ̃mʉa, carõmia cʉ̃ã catiri caetaparã pʉame nʉmo manigarãma. Ángelea majã, ʉmʉrecóo macããna na caãnorẽ bairo nigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Apeyera tunu mʉjããrẽ yʉ quetibʉjʉgʉ: Cariacoatana nimirãcʉ̃ã tunu na cacatirore Moisés ãnacʉ̃ cʉ̃ caquetibʉjʉwoacũrĩcã tutipʉ mʉjãã ĩñaetinucũñati ati wẽẽrẽ. Ti tutipʉ yucʉ ʉ̃mirõcʉ̃ã caʉ̃petietiire cʉ̃ caquetibʉjʉricapaʉpʉ atore bairo ĩ woatuyupi Moisés: “Yʉa, yʉ ãniña Abraham, cʉ̃ macʉ̃ Isaac, bairi cʉ̃ macʉ̃ Jacob quetiupaʉ caãnacʉ̃,” ĩñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bairo cʉ̃ caĩrõĩ, marĩ masĩña: ¡Dios pʉame cayasirã ãnana ũna quetiupaʉ mee niñami! Cacatirã majũ quetiupaʉ roque niñami. Tiere mʉjãã tʉ̃goña mawijiacoaya —na ĩ quetibʉjʉyupʉ Jesús saduceo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bairo na caãmeo bʉsʉpẽnirĩjẽrẽ catʉ̃goatacʉ jĩcãʉ̃ Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuei pʉame bairo Jesús caroaro cʉ̃ caĩquetibʉjʉro tʉ̃gori, Jesutʉ etayupʉ. Bairo cʉ̃tʉ eta, atore bairo qũĩ jẽniñañupʉ̃ Jesure: —Cabuei, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ mena macããjẽ, ¿dise pʉame caãnimajũrĩjẽ cʉ̃ caroticũrĩqũẽ to ãniñati? —qũĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús caʉ̃mʉrẽ: —Moisés ãnacʉ̃ cʉ̃ caroticũrĩjẽ mena macããjẽ cabuijãñurõ netõrõ carotirije atore bairo niña: “Tʉ̃goya mʉjãã Israel macããna. Dios marĩ Pacʉ jĩcãʉ̃ niñami. Apei maniñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bairi mʉjãã caátiãnie nipetirije mena cʉ̃ maiña. Tunu bairoa mʉjãã yeripʉ, mʉjãã catʉ̃goñarĩjẽ nipetirije mena cʉ̃ maiña. Tunu bairoa mʉjãã catutuarije nipetirije mena cʉ̃ maiña.” ");
INSERT INTO cbcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Atie rocajãñurĩ cʉ̃ caroticũrĩqũẽ torea bairo jãñurĩ niña tie cʉ̃ã. Bairo ĩña: “Mʉjããtʉ macããna cʉ̃ãrẽ mʉjãã rupaʉre mʉjãã camairõrẽã bairo na maiña.” Tie Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ tocãnacã wãme netõrõ caãnimajũrĩjẽ niña. Ape wãme tie netõrõ caãnie maa —qũĩ quetibʉjʉyupʉ Jesús cajʉ̃gobueire. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bairo cʉ̃ caĩrõ tʉ̃go, qũĩñupʉ̃ Jesure: —Cabuei, cariape miña. Mʉ caĩquetibʉjʉrijere bairo baiya: Dios marĩ Pacʉ jĩcãʉ̃ã niñami. Apei maniñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Marĩ caátiãnie nipetirije mena cʉ̃ marĩ maigarã. Tunu bairoa marĩ yeripʉ, marĩ catʉ̃goñarĩjẽ nipetirije mena cʉ̃ marĩ maigarã. Tunu bairoa marĩ catutuarije nipetirije mena cʉ̃ marĩ maigarã. Marĩtʉ macããna cʉ̃ãrẽ marĩ rupaʉre marĩ camairõrẽã bairo na marĩ maigarã. Tie pʉame marĩ catʉ̃gopeoro, waibʉtoa rii altapʉ marĩ cajoemʉgõ jonucũrĩjẽ tocãnacã wãme netõrõ caãnimajũrĩjẽ niña —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús pʉame caroaro cʉ̃ cayuro tʉ̃go, atore bairo qũĩñupʉ̃: —Petoaca rʉsaya Dios cʉ̃ carotimasĩrĩpaʉpʉ mʉ caetapee. Bairo cʉ̃ caĩrõ bero yua, cʉ̃ jẽniña uwiri, ni jĩcãʉ̃ ũcʉ̃ cʉ̃ jẽniñanemoesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bairo Jesús Dios ya wii templo wiipʉ camasãrẽ na bueãcʉ̃, atore bairo na ĩñupʉ̃ cʉ̃tʉ caãnarẽ: —¿Dopẽĩrã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame, “Mesías, ‘Dios cʉ̃ cajoʉ,’ na caĩrẽ David ãnacʉ̃ pãrãmi ãnigʉmi” na ĩ quetibʉjʉnucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David ãnacʉ̃ pʉame Espíritu Santo cʉ̃rẽ cʉ̃ camasĩõrĩjẽ jʉ̃gori, atore bairo ĩ woatuyupi: ‘Dios pʉame yʉ Quetiupaʉre atore bairo qũĩwĩ: “Ato ruiya cariape nʉgõã pʉame mai. Mʉ pesua caãnanarẽ na yʉ canetõnʉcãrõ bero, mʉ pʉame na mʉ rotimasĩgʉ,”’ ĩñupĩ David ãnacʉ̃, Dios cʉ̃ caĩrĩqũẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Bairo Mesíare, “Yʉ Quetiupaʉ,” cʉ̃ caĩmiatacʉ̃ãrẽ, ¿dope bairo cʉ̃ pãrãmi majũ cʉ̃ ãnibujiocʉti? —na ĩ jẽniñañupʉ̃ Jesús cʉ̃tʉ caãnarẽ. Na pʉame capããrã ãñuparã cʉ̃ yaye quetibʉjʉriquere ʉseanirĩqũẽ mena catʉ̃goʉsarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bairo Jesús camasãrẽ na quetibʉjʉãcʉ̃, atore bairo na ĩñupʉ̃: “Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã na caátiãnierẽ tʉ̃goñamasĩña: Na pʉame jutii cayowerijere jãñajesoyama. Bairo cajãñarã ãnirĩ plazapʉ na caáñesẽãta, nipetiro camasã nʉcʉ̃bʉgoricaro mena na cajẽnirõrẽ bonucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tunu bairoa ñubuerica wiiripʉ na caápáta, caroapaʉri jetore ruiganucũñama. Tunu bose rʉ̃mʉ caãno narẽ na capiiata, caroapaʉre ruiri ʉgaganucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tunu bairoa cawapearã rõmirĩ ya wiirire ẽmanucũñama. Tunu yoaro Diore cʉ̃ jẽniñubue tonucũñama. Na pʉame roque aperã netõjãñurõ popiye tãmʉogarãma.” ");
INSERT INTO cbcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jĩcã rʉ̃mʉ templo wiipʉ ãcʉ̃, camasã na yaye dinerore na cajããnucũrĩ patatʉ ruiyupʉ Jesús. Bairo totʉ ruiãcʉ̃, ti patapʉ na dinerore jori majãrẽ na ĩñajoyupʉ. Capããrã ãñuparã pairo cadinerocʉna. Na pʉame dinero jããrĩcã pataripʉ na yaye dinerore jããrã ásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na bero cawapeao cabopacao cʉ̃ã jããñupõ pʉga moneda, cobre tiiriacarẽ, cacʉ̃goeco majũ nimiocʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Bairo cõ caáto ĩña, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —Ãnoa cadinero cʉ̃gonetõõrã ãnirĩ narẽ catuarijere, dinerore na cajããnucũrĩ patapʉ jããñama. Atio cawapeao pʉame cabopacanetõõ ãnirĩ, cõ cacʉ̃gomirĩjẽ nipetirijere jããcõãñamo. Bairi cariape mʉjããrẽ ñiña: Dios cʉ̃ caĩñajoro atio pʉame cadinero cʉ̃gorã netõõjãñurõ jããñamo —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cabero templo Dios ya wii caãniatacʉ ti wiire witicoásúpʉ Jesús. Bairo cʉ̃ caátó, jĩcãʉ̃ Jesús cʉ̃ cabuei atore bairo qũĩñupʉ̃: —¡Cabuei, nocãrõ caroa wii majũ to ãniñati ati wii! Paca ʉ̃tãpãĩrĩ niña. Ati wii, caroa wiiro majũ nicõãña —qũĩñupʉ̃ Jesure jĩcãʉ̃ cʉ̃ cabuei, templo wiire ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩñupʉ̃ Jesús cʉ̃rẽ: —Ati wii paca ʉ̃tãpãĩrĩ ũnie nipetirijere miñaña. Cariape miña: Jĩcã rʉ̃mʉ, ati wiire roro na caátipa rʉ̃mʉ caetaro, jĩcã ʉ̃tãã ũno bui tuticʉti pesaricaro manopʉ átiyasio rocacõãgarãma ati wiire —qũĩñupʉ̃ Jesús cʉ̃ cabuei jĩcãʉ̃rẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cabero Olivo buropʉ acoásúparã Jesujãã. Mai, Olivo buro Dios ya wii templo jĩãme ãñuparõ. Bairo ti buropʉ na caetaro, topʉ ruiyupʉ Jesús. Bairo cʉ̃ caruiro, aperã na camano, cʉ̃ cabuerã Pedro, Santiago, Juan, Andrejãã pʉame atore bairo qũĩ jẽniñañuparã Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Cabuei, ¿nocãrõpʉ to bairoati atie mʉ caĩrĩjẽ? ¿Dope bairo merẽ, ‘Jesús cʉ̃ caĩrĩqũẽ etaro baiya,’ jãã ĩ masĩrãati?” ");
INSERT INTO cbcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bairo na caĩjẽniñarõ tʉ̃gori, atore bairo na ĩñupʉ̃ Jesús: “Caroaro majũ mʉjãã tʉ̃goñamasĩgarã, jããpʉ jãã ĩtoecore, ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Capããrã atígarãma ĩtoñesẽãrĩ majã. Atore bairo ĩgarãma: ‘Yʉa, Mesías yʉ ãniña Dios cʉ̃ cajoʉ,’ ĩgarãma. Bairo na ĩrĩ, camasã capããrãrẽ na ĩtogarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Tunu bairoa mʉjãã queti tʉ̃gogarã: ‘Camasã aperopʉ cʉ̃ãrẽ ãmeo pajĩãrã átiuparã.’ Bairo na caátie quetire tʉ̃gori, tʉ̃go acʉaeticõãña. Ati ʉmʉrecóo capetiparo jʉ̃goye bairoa cabaijʉ̃goyecʉtipee niña bairopʉa. Bairi tʉ̃go acʉaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ti yʉtea caãno jĩcã yepa macããna, ape yepa macããna mena ãmeo pajĩãgarãma. Tunu bairoa jĩcã macã macããna, ape macã macããna mena ãmeo pajĩãgarãma. Tunu tutuaro mena ati yepa cʉ̃ã yuguigaro nipetiropʉ. Apeye aʉa riarique atígaro. Jĩcãõ carõmio bairirupaʉ caãcõ cõ macʉ̃ cʉ̃ cabuiari rʉ̃mʉ capũnirõ tʉ̃goñarĩ cõ cawisiojʉ̃goriquere bairo niña ati ʉmʉrecóo cabaipee mʉjããrẽ yʉ caquetibʉjʉrije. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Diore caĩroaena na caátiãnierẽ tʉ̃goñamasacatiya. Mʉjããrẽ roro átigarãma. Mʉjããrẽ ñerĩ, popiye mʉjãã baio joroque mʉjãã átigarãma. Quetiuparã tʉpʉ mʉjããrẽ neágarãma, to macããna mʉjããrẽ na caĩñabeseparore bairo ĩrã. Aperã cʉ̃ã sinagogas, na cañubueri wiiripʉ mʉjãã bape epegarãma. Tunu yʉ yarã mʉjãã caãno jʉ̃gori na pʉame mʉjããrẽ roro na catutiparore bairo ĩrã, quetiuparã gobernadores, bairi quetiuparã reyes tʉpʉ cʉ̃ãrẽ mʉjãã neágarãma. Bairo na caátimiatacʉ̃ãrẽ, na ũnarẽ yʉ yaye quetire nemojãñurõ mʉjãã quetibʉjʉ masĩgarã bairãpʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Atie caroa queti cʉ̃ã ati ʉmʉrecóo capetiparo jʉ̃goye nipetiropʉ cajesapeticoa jʉ̃goyecʉtipee niña bairopʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bairi quetiuparã tʉpʉ roro mʉjããrẽ na caneátó, ‘¿Dope bairo na marĩ ĩrãati?’ ĩ tʉ̃goña macãẽtĩcõãña. Tipaʉ caetaro ĩña, Dios pʉame mʉjãã caĩmasĩpeere mʉjãã jogʉmi. Mʉjãã catʉ̃goñamasĩrĩjẽ mena mʉjãã quetibʉjʉetigarã. Marĩ Pacʉ Dios mena macããcʉ̃, Espíritu Santo cʉ̃ camasĩõrĩjẽ jʉ̃gori roque mʉjãã quetibʉjʉgarã camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tipaʉ caãno, jĩcãʉ̃ pũnaa caãna nimirãcʉ̃ã, ãmeo bʉsʉjãbuitirecõãgarãma. Bairo ána, gobiernorẽ na ñerotiri na pajĩãrerotigarãma. Tunu apei cʉ̃ã cʉ̃ macʉ̃rẽ torea bairo cʉ̃ átirotigʉmi. Tunu jĩcãʉ̃ pũnaa na pacʉare boetiri, na pajĩãrerotigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bairi yua, ati ʉmʉrecóo macããna nipetiro mʉjããrẽ ĩñategarãma, yʉ yarã mʉjãã caãnoi. Baipʉa, ni ũcʉ̃ mʉjãã mena macããcʉ̃ yʉ yaye jĩcã wãmeacã ũnorẽ cʉ̃ cajãnaeticõãta, cʉ̃ netõgʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bairi mʉjãã pʉame Dios ya wiire nocãrõ caroapaʉre moecʉ̃ caróʉ majũ topʉ cʉ̃ caãnierẽ ĩñarã, atore bairo mʉjãã ĩ tʉ̃goñamasĩgarã: ‘Merẽ ati macã yasigaro baiya.’ (Mʉjãã, atie yʉ ya pũrõrẽ caĩñabuerã pʉame tʉ̃gopeoya yʉ yaye, yʉ caquetibʉjʉrijere.) Bairo cabairo, Judea yepa macããna ʉ̃tã yucʉpʉ na ruti ápáro. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tunu bairoa jĩcãʉ̃ ũcʉ̃ cʉ̃ wii, cabuimacã arʉapʉ cʉ̃ caãmata, ruiatíri cʉ̃ apeyere, ape arʉapʉ caãnierẽ cʉ̃ jei ápéricõãto. Cariape cʉ̃ ácoa ápáro. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tunu bairoa cʉ̃, wesepʉ caãcʉ̃ cʉ̃ jutii ũnierẽ bomicʉ̃ã, cʉ̃ jetunuʉ apéricõãto cʉ̃ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Carõmia bairirupaʉ caãna popiye netõõrõ baigarãma! ¡Tunu bairoa, caũpũrããcãrẽ, capũnaacʉna cʉ̃ã popiye netõõrõ baigarãma ti rʉ̃mʉrẽ! ");
INSERT INTO cbcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bairi Diore cʉ̃ jẽniña, mʉjãã carutiripaʉ camasiriyoeti rʉ̃mʉ to caãniparore bairo ĩrã. Cawãma pue yʉtea caãno to cabaietiparore bairo ĩrã, Diore cʉ̃ jẽniña. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ti rʉ̃mʉrẽ roro ati yepapʉre bairique nigaro. Dios cʉ̃ caátijʉ̃gori rʉ̃mʉ bero tocãnacã rʉ̃mʉrẽ netõrõ popiye bairicapaʉ nigaro ti rʉ̃mʉ caetaro. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bairi Dios pʉame ti rʉ̃mʉ roro cabairijere cʉ̃ cajãnarotieticõãta, camasã nipetiro riapeticoabujiorãma. Bairo na cariapeticoamiatacʉ̃ãrẽ, mʉjãã, cʉ̃ cabeserãrẽ mairĩ roque, peeti yʉtea ũno popiye mʉjãã cabaipa rʉ̃mʉrẽ áti ẽñotabojagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bairi ni jĩcãʉ̃ ũcʉ̃, ‘Mesías, Dios cʉ̃ cajoʉ pʉame ati macãpʉ etaupʉ,’ o ‘Ji macãpʉ etaupʉ,’ cʉ̃ caĩata, cariape cʉ̃ mʉjãã tʉ̃goetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Caĩtopairã capããrã átigarãma. ‘Yʉa, Mesías yʉ ãniña,’ o ‘Yʉa, profeta yʉ ãniña,’ caĩrã átigarãma. Capee átijẽñogarãma, camasã ricaati na catʉ̃goʉsaparore bairo ĩrã. Mʉjãã ũna, Dios cʉ̃ cabesericarã cʉ̃ãrẽ ĩtomigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Bairi masacatiya yʉ yarã! Merẽ mʉjãã tiere mʉjããrẽ yʉ quetibʉjʉ jʉ̃goyetiya,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ĩ quetibʉjʉ yaparo, atore bairo na ĩ nemoñupʉ̃ tunu: “Camasã roro majũ na cabairi yʉtea capetiro bero, muipʉ ʉmʉrecóo macããcʉ̃ naitĩãcoagʉmi. Ñami macããcʉ̃ cʉ̃ã bauetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ñocõã, ʉmʉrecóore caãnimiatana cʉ̃ã ñacoagarãma. Bairo bairã, ʉmʉrecóo macããna nipetirã yugui ñacoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tocãrõã yʉ, Camasã Jʉ̃gocʉ, buseriwo watoapʉ nocãrõ yʉ catutuarije mena, bairi yʉ caasiyabatorije mena yʉ caatóre ĩñajogarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bairo yʉ caatóre na caĩñajoro yua, yʉ ʉ̃mʉa, ángelea majãrẽ nipetiropʉ na yʉ árotigʉ. Bairi ati ʉmʉrecóo macããna nipetiropʉ caãnarẽ na neñogarãma yʉ cabesericarã pʉamerẽ,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ĩ quetibʉjʉ yaparo, ati wãmerẽ ĩcõñarĩ na ĩnemoñupʉ̃ tunu: “Mai, higuera yucʉre mʉjãã masĩña. Ti yucʉ cawãma pũũ cawasoaro ĩñarã, ‘Merẽ cʉ̃ma cõñarõ baiya,’ mʉjãã ĩ masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Torea bairo mʉjããrẽ yʉ caquetibʉjʉrijere bairo cabaietaro ĩñarã, ‘Merẽ Jesús ati yepapʉ nemo cʉ̃ catunuetaparo cõñarõ baiya,’ mʉjãã ĩ masĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cariape mʉjããrẽ ñiña: Mʉjããrẽ yʉ caquetibʉjʉrije baipeticoagaro ti yʉtea macããna na cariaparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tunu bairoa ati ʉmʉrecóo, ati yepa cʉ̃ã yasipeticoagaro. Yʉ yaye quetibʉjʉrique roque petietigaro. Yʉ caĩrõrẽã bairo baicoagaro. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Bairopʉa di rʉ̃mʉ, di hora majũ mʉjãã yʉ caquetibʉjʉrije caetaparore ni jĩcãʉ̃ ũcʉ̃ masĩẽtĩñami. Ʉmʉrecóo macããna ángelea majã cʉ̃ã masĩẽtĩñama. Marĩ Pacʉ Dios macʉ̃, yʉ cʉ̃ã yʉ masĩẽtĩña. Marĩ Pacʉ Dios jeto masĩñami ti rʉ̃mʉ caetaparore. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Bairi ti rʉ̃mʉ yʉ caetapa rʉ̃mʉrẽ mʉjãã masĩẽtĩña. Bairi masacatiya yʉ yarã. Cacãnirãrẽ bairo baieticõãña. Caroaro coteya. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ti rʉ̃mʉ caetaparo, jĩcãʉ̃ quetiupaʉ cʉ̃ cabairiquere bairo niña. Cʉ̃ pʉame ape yepapʉ cayoaropʉ ágʉ jʉ̃goye, cʉ̃ paabojari majãrẽ na piijori, na cũñupʉ̃ tocãnacãʉ̃pʉrea cʉ̃ ya wii macããjẽ coteriquere caroaro na caqũẽnobojaparore bairo ĩ. Ti wii jope cacotei cʉ̃ãrẽ, ‘Masacatiya, cajerutiri majã jããrema,’ qũĩ quetibʉjʉ cũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cʉ̃ caátó bero caroaro na caãniyurorea bairo baiya mʉjãã cʉ̃ã. Na cʉ̃ã, ‘Tocãrõ majũ tunu etagʉmi marĩ quetiupaʉ,’ ĩ masĩẽnama. ‘Canaiorĩpaʉ caãno, ñami recomacã caãno, o ãbocʉ cʉ̃ capiiripaʉ, o cabusuripaʉ bero tunu etabujiomi,’ ĩ masĩẽnama. Mʉjãã cʉ̃ã narẽ bairo masĩẽtĩmirãcʉ̃ã, yʉre cotecõã ninucũña. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Masĩã mano yʉ caatípaʉre cacãnirãrẽ bairo mʉjãã ãnibujiorã, tocãnacã rʉ̃mʉa caroaro tʉ̃goñamasĩrĩ yʉre mʉjãã cacoteeticõãta. ");
INSERT INTO cbcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bairo mʉjããrẽ yʉ caĩrĩjẽrẽ yʉ yarã nipetirã cʉ̃ãrẽ atore bairo mʉjãã ñiña: ¡Caroaro coteya tocãnacã rʉ̃mʉa!” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Merẽ yua, pʉga rʉ̃mʉ rʉsayuparo bose rʉ̃mʉ, Pascua na caĩrĩ rʉ̃mʉ, pããrẽ cawauarije caasua manierẽ judío majã na caʉgapa bose rʉ̃mʉ majũ. Quetiuparã sacerdote majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame, “¿Dope bairo camasã na caĩñaeto Jesure gobierno cʉ̃ cañerotio joroque marĩ átiroticʉti?” ãmeo ĩñuparã na majũ ĩtorique mena, Jesús cʉ̃ cariarore borã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bairo ãmeo ĩrĩ cʉ̃rẽ na capajĩãgamiatacʉ̃ãrẽ, jĩcããrã na mena macããna atore bairo ĩñuparã: —Bairãpʉa, Pascua caãno cʉ̃ marĩ ñerotimasĩẽna, “Camasã roro awajari marĩ tutirema,” ĩrã, ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús pʉame tipaʉ caãno Betania macãpʉ ãñupʉ̃, carupaʉ boamirĩcʉ̃ Simón cawãmecʉcʉ ya wiipʉ. Bairo ti wii cʉ̃ caãno, jĩcãõ carõmio cʉ̃tʉ etayupo. Cõ pʉame caroarʉacapʉ jiraro cajʉtiñurĩjẽ pairo cawapacʉtiere neasúpo. Bairo Jesús mesapʉ cʉ̃ caruiro, carõmio caroa pʉame tie cajʉtiñurĩjẽrẽ cʉ̃ rʉpoapʉ piopeoyupo, Jesure bʉtioro nʉcʉ̃bʉgoo. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jĩcããrã to caãna pʉame bairo cõ caáto ĩñarã, cõ mena asiajãñuñuparã. Atore bairo ĩñuparã: —Tame, ¿nopẽĩõ pairo cawapacʉtiere bairo cõ átireyati? ");
INSERT INTO cbcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Apei, tiere caboʉre cõ canuniata, pairo, trescientos denario moneda tiiri majũ wapa nerĩ, aperã cabopacarãrẽ na jʉátinemo masĩbujiomo. Ãmerẽ tie yasicoaya cõ cawapatabujioataje yua —ãmeo ĩñuparã. Tore bairo ãmeo ĩ bʉsʉyuparã na majũ carõmio cõ caátiere ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús pʉame tʉ̃goyupʉ cõ na catutirijere. Bairi atore bairo na ĩñupʉ̃: —¿Nopẽĩrã patowãcõrõ cõrẽ mʉjãã bʉsʉpaiyati? Atio carõmio bairo yʉre cõ caátie ñujãñuña. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cabopacarã nicõãnucũgarãma mʉjãã watoare. Yʉ pʉame roque yoaro yʉ ãmerĩgʉ ati yepapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bairo cajʉtiñurĩjẽrẽ yʉ rʉpoare cõ capiopeoro jʉ̃gori yʉ rupaʉre caroaro qũẽnoñamo, yʉ rupaʉri ãnajẽrẽ na cayacũparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cariape mʉjããrẽ ñiña: Ati ʉmʉrecóo nipetiropʉ, atie yʉ yaye queti, camasãrẽ Dios cʉ̃ canetõõrĩjẽrẽ na caquetibʉjʉropʉ atio carõmio bairo yʉre cõ caátie cʉ̃ãrẽ quetibʉjʉgarãma. Bairi cõ caátiere masĩcõã ninucũgarãma camasã tocãnacã rʉ̃mʉa —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Bairi yua, jĩcãʉ̃ Jesús cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ mena macããcʉ̃, Judas Iscariote cawãmecʉcʉ na ĩñaʉ ásúpʉ quetiuparã sacerdote majãrẽ. Na tʉpʉ etari, Jesure bʉsʉjã buitirocacõãñupʉ̃, cʉ̃ na capajĩãmasĩparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bairo cʉ̃ caĩrõ tʉ̃go, ʉseanicoasuparã sacerdote majã quetiuparã. Bairo ʉseanirĩ, “Dinero mʉrẽ jãã jogarã tie wapa,” qũĩñuparã. Tipaʉ bero, Judas pʉame dipaʉ ũno dope bairo camasã mano macãjʉ̃goyupʉ, Jesure na ñerotigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bairi yua, etayuparo Pascua bose rʉ̃mʉ, caãnijʉ̃gori rʉ̃mʉ, levadura pan cawauorije caasua manierẽ judío majã na caʉgari rʉ̃mʉ. Tunu bairoa oveja nurĩcʉ̃ macʉ̃ cordero na caĩrẽ pajĩãrĩ na caʉgari bose rʉ̃mʉ etayuparo. Bairo ti rʉ̃mʉ caetaro ĩña, Jesús cʉ̃ cabuerã pʉame, cʉ̃tʉ etari, atore bairo qũĩ jẽniñañuparã: —¿Noopʉ marĩ caʉgapeere jãã caqũẽnoyuro mʉ boyati? ");
INSERT INTO cbcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bairo na caĩjẽniñarõ, na árotiyupʉ Jesús pʉgarã cʉ̃ cabuerãrẽ: —Ánája mʉjãã Jerusalẽpʉ. Bairo ti macãrẽ etarã, mʉjãã bócaetagarã jĩcãʉ̃ caʉ̃mʉrẽ, ocorʉ pʉsari caácʉ́re. Cʉ̃rẽ cʉ̃ bócaetari, cʉ̃ bero mʉjãã ʉsaápá. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cʉ̃ ʉsaa yua, cʉ̃ wiipʉ cʉ̃ cajããrõ ti wii upaʉre atore bairo cʉ̃ mʉjãã ĩgarã: “Cabuei bairo ĩ jẽniñajoyami: ‘¿Noopʉ to ãniñati Pascua bose rʉ̃mʉ caãno yʉ cabuerã mena yʉ caʉgapa arʉa?’ ĩ jẽniñajoyami,” cʉ̃ mʉjãã ĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bairo mʉjãã caĩjẽniñarõ, mʉjãã ĩñogʉmi jõbuipʉ caroaro qũẽnoweyorica arʉare. Topʉ marĩ caʉgapeere mʉjãã qũẽnoyuwa —na ĩñupʉ̃ Jesús cʉ̃ cabuerã pʉgarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bairo cʉ̃ caĩrõ tʉ̃go, acoásúparã Jerusalén macãpʉ. Topʉ na caetaro, nipetiro Jesús na cʉ̃ caĩatatorea bairo baipeticõãñuparõ. Bairi topʉ qũẽnoyuyuparã Pascua bose rʉ̃mʉ na caʉgapeere yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cabero canaiorĩpaʉ caetaro, Jesús pʉame ti wii jããetari mesapʉ ruiyupʉ pʉga wãmo peti rʉpore pʉga pẽnirõ caãna cʉ̃ cabuerã mena. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bairo na caʉgaruiripaʉ, atore bairo na ĩñupʉ̃ Jesús: —Cariape mʉjããrẽ ñiña: Mʉjãã mena macããcʉ̃ jĩcãʉ̃ roro yʉre ĩ bʉsʉjã buitirocagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bairo cʉ̃ caĩrõ tʉ̃go, bʉtioro tʉ̃goña yapapuayuparã cʉ̃ cabuerã. Bairo bairã, apei, apei, Jesure bairo ĩ jẽniña jʉ̃goyuparã: —¿Yʉ mee, yʉ ãnicõãẽtĩmicʉti mʉrẽ caĩbʉsʉjãbuitiri majõcʉ? —ĩ jẽniñañuparã tocãnacãʉ̃pʉa. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bairo na caĩrõ, bairo na ĩñupʉ̃ Jesús: —Ãni niñami yʉre roro caĩbʉsʉjãbuitirocapaʉ, ãmerẽ ati bapare yʉ mena cʉ̃ pan cayoseʉgaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Torecʉna, yʉ, Camasã Jʉ̃gocʉ, profeta majã yʉ cabaipeere na caquetibʉjʉcũrĩcãrõrẽã bairo yʉ baigʉ. Cabaimiatacʉ̃ãrẽ, ¡yʉre caĩbʉsʉjãbuitirocapaʉre cʉ̃ carorije wapa pairo nigaro! Bairi cʉ̃ cabuiaeticõãta, ñubujioricaro —na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bairo na ĩrĩ bero, na caʉgatoye, Jesús pʉame cʉ̃ wãmo mena pããrẽ nerĩ, “Dios, mʉ ñujãñuña jãã mena,” ĩ yaparori, carecomacã peenerĩ, cʉ̃ cabuerãrẽ, atore bairo ĩrĩ na batoyupʉ: —Atie pan, yʉ rupaʉ niña. Tiere ʉgaya —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bairo ĩ yaparo, cʉ̃ wãmo mena copa etirica bapare nerĩ, “Dios, mʉ ñujãñuña jãã mena,” qũĩ yaparori, ti copare na nuniñupʉ̃. Bairo cʉ̃ caáto, cʉ̃ cabuerã nipetiro ʉse oco ti copa macããjẽrẽ etipeticõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bairo na caetiro, atore bairo na ĩñupʉ̃: —Atie ʉse oco pʉame yʉ rií niña. Camasã capããrãrẽ na netõõgʉ, yʉ riacoagʉ. Bairo yʉ cariápee jʉ̃gori cawãma wãme camasãrẽ Dios cʉ̃ caátibojacũrĩqũẽ etacoaya. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cariape mʉjããrẽ ñiña: Ãmea mʉjãã mena ʉse ocore pʉgani yʉ etinemoetigʉ yʉ Pacʉ cʉ̃ carotimasĩrĩpaʉ tunu caetaro marĩ caetinemoparo jʉ̃goye —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ĩ yaparo, salmos basarique mena Diore basapeoyuparã. Basapeo yaparo yua, acoásúparã Olivo cawãmecʉti buropʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Bairo na caátó, atore bairo na ĩñupʉ̃ Jesús: —Yʉ cabuerã, mʉjãã nipetirã aperãrẽ uwirã, yʉ mʉjãã aweyocoagarã. Mʉjãã cabaipeere ĩ quetibʉjʉ jʉ̃goyeticũñañupã profeta majã Dios yaye woaturica tutipʉ: “Ovejare cacoteire camasã na capajĩãrõ yʉ ẽñotaetigʉ. Bairo cʉ̃rẽ na capajĩãrõ bero, cʉ̃ oveja pʉame bata peticõãgarãma,” ĩ quetibʉjʉ jʉ̃goyeticũñañupã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tunu apeyera cariacoatacʉ nimicʉ̃ã, yʉ caticoagʉ tunu. Bairo cati yua, mʉjãã jʉ̃goye Galilea yepapʉ yʉ ágʉ —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bairo cʉ̃ caĩrõ bero, Pedro pʉame bairo qũĩñupʉ̃ Jesure: —Ãnoa yʉ mena macããna nipetirã mʉrẽ na caaweyocoamiatacʉ̃ãrẽ, yʉ pʉame roque di rʉ̃mʉ ũno mʉ yʉ aweyoetigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Bairo cʉ̃ caĩrõ, bairo qũĩñupʉ̃ Jesús: —Pedro, cariape mʉrẽ ñiña: Ãme ñami ãbocʉ pʉgani cʉ̃ capiiparo jʉ̃goye itiani, “Cʉ̃ yʉ masĩẽtĩña Jesure,” yʉ mitogʉ —qũĩñupʉ̃ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro pʉame bʉtioro tutuaro mena bairo qũĩnemoñupʉ̃: —Mʉ mena yʉre na capajĩã rocagamiatacʉ̃ãrẽ, “Cʉ̃ yʉ masĩẽtĩña Jesure,” ñitoetimajũcõãgʉ —qũĩñupʉ̃ Pedro Jesure. Bairo cʉ̃ caĩrõ tʉ̃go, Jesús cʉ̃ cabuerã cʉ̃ã nipetiro, bairo jeto qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bairi Jesujãã ásúparã Getsemaní cawãmecʉtopʉ. Topʉ etari, bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —Ato ruicoteya mai. Jõ jãñurõpʉ Diore cʉ̃ jẽnigʉ yʉ átiya. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ĩ yaparo, Pedro, Santiago, bairi Juarẽ jõjãñurõpʉ na jʉ̃goásúpʉ Jesús. Bairo ácʉ́, bʉtioro tʉ̃goña yapapuayupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bairi atore bairo na ĩñupʉ̃ Pedrojããrẽ: —Riaʉre bairo yʉ tʉ̃goña yapapuaya. Mʉjãã pʉame cãniena, atoa yʉ mʉjãã cotewa. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ĩ yaparo, na jʉ̃goye jãñurõpʉ ánemoñupʉ̃ Jesús. Ánemo yua, cʉ̃ rʉpopaturi mena etanumurĩ yepapʉ cʉ̃ riapére mucũmuáti, Diore qũĩ jẽniñupʉ̃, roro cʉ̃ cabaipeere Dios cʉ̃ canetõõbojaparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Atore bairo qũĩ jẽniñupʉ̃ Diore: “Caacʉ, mʉ cabooata, atie roro yʉ canetõpeere yʉ mʉ netõõbojagʉ. Bairopʉa, yʉ caborore bairo to baieticõãto. Mʉ caborore bairo roque to bai áto,” ĩ jẽniñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cabero tunu ásúpʉ Jesús, Pedrojãã na caãnopʉ. Bairo cacãnirãpʉ̃rẽ na etayupʉ. Bairi qũĩñupʉ̃ Jesús Pedrore: —Jĩcã hora ũnoacã cãniena, ¿yʉ mʉjãã cotemasĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cãniena, wãmʉnʉcãrĩ Diore cʉ̃ jẽniña, wãtĩ mʉjããrẽ cʉ̃ canetõõẽtĩparore bairo ĩrã. Bairo mʉjãã cabomiatacʉ̃ãrẽ, mʉjãã rupaʉ pʉame tutuaetiya —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ĩ yaparo, ásúpʉ tunu Jesús Diore cʉ̃ jẽninemoʉ ácʉ́. Á yua, cʉ̃rẽ cʉ̃ caĩjẽnijʉ̃goatatorea bairo qũĩ jẽninemoñupʉ̃ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ĩ jẽni yaparo, tunucoásúpʉ Jesús Pedrojãã tʉpʉ. Bairo cacãnirãpʉ̃rẽ na etayupʉ tunu. Na pʉame wʉgoa cʉtiri ĩñapãã masĩẽsuparã. Bairi dope bairo qũĩ yʉ masĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bairo na cabairo ĩña yua, ásúpʉ Jesús tunu Diore cʉ̃ jẽniácʉ́. Bairo jẽni yaparo, tunucoásúpʉ Jesús Pedrojãã na caãnopʉ. Merẽ itiani majũ natʉre etayupʉ. Bairo natʉ eta, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã mai cacãnirãrẽ bairo mʉjãã nicõãnucũñati? Tocãrõã cãniña. Carorije cacʉ̃gorãrẽ Camasã Jʉ̃gocʉre, yʉ na canunirocaripaʉ etaya merẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bairi wãmʉnʉcãña. Jito, yʉre caĩbʉsʉjãbuitirocari majõcʉ pʉame marĩtʉ atíyami merẽ —na ĩñupʉ̃ Jesús Pedrojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bairo cʉ̃ caĩãno, Judas, Jesús cʉ̃ cabuerã mena macããcʉ̃ jĩcãʉ̃ caãninucũmiatacʉ pʉame etayupʉ. Cʉ̃ mena capããrã camasã cʉ̃ã etayuparã. Na pʉame jarericapãĩrĩ, bairi yucʉ rʉcaari cʉ̃ãrẽ cʉ̃gori etayuparã. Sacerdote majã quetiuparã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ cajʉ̃gobueri majã, bairi aperã judío majã cabʉtoa camasĩrã na cajoatana ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mai, na caetaparo jʉ̃goye, Judas pʉame atore bairo na ĩñupʉ̃ Jesure cañeranárẽ: “Cʉ̃ wasopanarẽ ũpũrĩ yʉ cajẽnipaʉ pʉame, Jesús nigʉmi. Bairo mʉjãã pʉame cʉ̃ yʉ caáto ĩñarã, cʉ̃rẽ mʉjãã ñegarã. Cʉ̃ ñe, caroaro cʉ̃ jiya, cʉ̃rẽ mʉjãã neágarã,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bairo Judas Jesutʉ etari, atore bairo qũĩ jẽniñupʉ̃: —¡Cabuei, mʉ ãnimiñati! Bairo caroaro mena qũĩtori cʉ̃ ũpũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bairo cʉ̃ caáto, Judas mena caetari majã pʉame Jesutʉ etari, cʉ̃ ñecoásúparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mai, bairo Jesure na caáto ĩñarĩ, jĩcãʉ̃ Jesús mena macããcʉ̃ pʉame sacerdote majã quetiupaʉ ʉ̃mʉrẽ cʉ̃ ãmorõrẽ cʉ̃ patañocõã joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bairo cʉ̃ caáto bero, atore bairo ĩñupʉ̃ Jesús cʉ̃rẽ cañerĩ majãrẽ: —¿Nopẽĩrã cajerutiri majõcʉ yʉ caãnorẽ bairo jarericapãĩrĩ mena, bairi yucʉ rʉcaari mena yʉ mʉjãã ñerã atíati? ");
INSERT INTO cbcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tocãnacã rʉ̃mʉa mʉjãã watoa yʉ ãninucũãpʉ̃ templo wiipʉre. Bairo yʉ caãnimiatacʉ̃ãrẽ, ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ yʉ ñeemi. Bairopʉa, nipetiro yʉ mʉjãã caátie Dios bʉsʉrica tutipʉ profeta majã na caĩquetibʉjʉ jʉ̃goyeticũrĩqũẽrẽ bairo baietaro baiya —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tipaʉ caãno yua, Jesús cʉ̃ cabuerã pʉame uwirã, Jesure rutiweyo peticoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bairo cʉ̃rẽ na cañeáto, jĩcãʉ̃ cawãmaʉ pʉame cʉ̃ cãnirĩ jutiro mena dʉrʉaturi ʉsa ásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bairo cʉ̃ cabairo, cʉ̃ cʉ̃ãrẽ cʉ̃ ñegamiñuparã. Cʉ̃rẽ na cañemiatacʉ̃ãrẽ, cʉ̃ cacãnirĩ jutirore tuwe rocacũ, jutii mácʉ̃ã atʉ ruticoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bairi Jesure cañerĩ majã pʉame sacerdote majã quetiupaʉ majũ ya wiipʉ cʉ̃ neásúparã. Mai, ti wiire merẽ ãñuparã sacerdote majã quetiuparã, bairi aperã judío majã cabʉtoa camasĩrã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã cʉ̃ã ti ñamirẽ caneñaetaatana. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bairi Jesure ti wiipʉ na caneátó, Pedro pʉame yoajãñurõpʉa na ĩña ʉsayupʉ. Bairo ti wiire na cajããetaro bero, Pedro cʉ̃ã etayupʉ ti wii macã yepapʉ. Bairi ti yepa ẽñotaricarore jããetari, templo coteri majã guardia mena ruiyupʉ. Na peerotʉ jũma ruiyupʉ Pedro cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bairi ti wii pupeapʉ sacerdote majã quetiuparã, bairi nipetiro Junta Suprema macããna mena Jesús cʉ̃ cayasiro boyuparã. Bairi, “¿di wãme carorije cʉ̃ ásupari?” ãmeo ĩ macãñuparã na majũ. “¿Dope bairo cʉ̃ caátaje wapa cʉ̃ marĩ pajĩãrotiyati?” Bairo ãmeo ĩmacãmirãcʉ̃ã, dope bairo cʉ̃ caátaje wapa cʉ̃ na capajĩãrotimasĩpeere bócaesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Camasã capããrã Jesús cʉ̃ caĩrĩqũẽrẽ na caĩtonetõmiatacʉ̃ãrẽ, dope bairo jĩcã riseroa ĩ bʉsʉesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bairi jĩcããrã na mena macããna wãmʉnʉcãrĩ atore bairo ĩtoyuparã mʉnana: ");
INSERT INTO cbcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ãni Jesús, cʉ̃ caĩrĩqũẽrẽ jãã tʉ̃gowʉ. Bairo ĩwĩ: “Ati wii templo camasã na caqũẽnorĩ wiire yʉ rocacõãgʉ. Bairo áti yaparori, itia rʉ̃mʉ bero yʉ pʉame yʉ wasoanʉcõgʉ tunu ape wii camasã mee na caqũẽnorĩcã wii majũ yua,” ĩwĩ Jesús —qũĩ bʉsʉjãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bairo ĩ bʉsʉmirãcʉ̃ã, na caĩrĩjẽ cʉ̃ãrẽ jĩcãrõrẽ bairo tʉ̃goñarĩ bʉsʉmasĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bairo na caĩquetibʉjʉro tʉ̃go, sumo sacerdote pʉame wãmʉnʉcãrĩ atore bairo qũĩñupʉ̃ Jesure: —¿Mʉna mee mʉrẽ na ĩñati? Roro mʉrẽ na caĩbʉsʉmiatacʉ̃ãrẽ, ¿nopẽĩ narẽ mʉ yʉetiyati? —qũĩ jẽniñañupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús pʉame cʉ̃ yʉeticõãñupʉ̃. Bairo cʉ̃ cayʉeto ĩña, atore bairo qũĩnemoñupʉ̃ tunu sumo sacerdote Jesure: —Jããrẽ cariape quetibʉjʉya: ¿Mʉ, Mesías, Dios nocãrõ Cañuʉ macʉ̃ mʉ ãniñati? ");
INSERT INTO cbcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bairo cʉ̃ caĩrõ, atore bairo qũĩñupʉ̃ Jesús: —Cʉ̃ã yʉ ãniña. Tunu bairoa ãme beroaca Nipetiro Carotimasĩ tʉpʉ cariape nʉgõãrẽ yʉ caruiparore mʉjãã ĩñamʉgõjogarã. Bairi tunu oco poa buseri watoapʉ ati yepare acʉ́ yʉ caruiató cʉ̃ãrẽ mʉjãã ĩñamʉgõjogarã —qũĩñupʉ̃ Jesús sumo sacerdotere. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bairo cʉ̃ caĩrõ tʉ̃go, sumo sacerdote pʉame cʉ̃ yaro jutirore tʉ̃gãworocacõã joyupʉ. Bairo átiri, atore bairo ĩñupʉ̃: —¡Roro majũ ĩcõãñami Diore, bairo cʉ̃ caĩata! Bairi roro cʉ̃ caĩrĩqũẽrẽ marĩrẽ caquetibʉjʉnemoparãrẽ na marĩ macãnemoetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Merẽ marĩ majũã marĩ tʉ̃go yaparoya roro cʉ̃ caĩrĩjẽrẽ. Bairi, dope bairo cʉ̃ marĩ ánaati —na ĩñupʉ̃ sumo sacerdote cʉ̃ ya wiire caneñaatíatanarẽ. Bairo cʉ̃ caĩrõ, to macããna nipetirã pʉame bairo ĩñuparã: “Roro cʉ̃ caĩrĩjẽ wapa cʉ̃ marĩ pajĩã rocarotigarã,” jĩcãrõ ãmeo ĩ bʉsʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bairo ĩ yaparo, jĩcããrã Jesure cʉ̃ riapépʉ ʉco eyotu epeyuparã. Bairi tunu cʉ̃ bapeyuparã. Aperã tunu cʉ̃ caapeere jutii asero mena jiyabiatori, cʉ̃ riapére cʉ̃ payuparã. Bairo átiri, qũĩ jẽniñañuparã: —¡Mʉ camasĩrĩjẽ jʉ̃gori jãã quetibʉjʉya! ¿Noa ãmerẽ mʉrẽ na paayati? —qũĩ epeyuparã to macããna Jesure. Templo wii coteri majã guardia majã cʉ̃ã Jesure cʉ̃ riapére paepeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Bairo na cabaiãno, Pedro pʉame ti wii macã yepa majũrẽ ruiyupʉ. Bairo cʉ̃ caruiro, jĩcãõ sacerdote majã quetiupaʉ paabojari majõco pʉame qũĩñacõã maniáti, atore bairo qũĩñupõ: —Mʉ cʉ̃ã, Jesús, Nazaret macã macããcʉ̃ mena mʉ áñesẽãwʉ̃. Cʉ̃ã mʉ ãcʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro pʉame ĩtori atore bairo cõ ĩñupʉ̃: —Yʉ masĩẽtĩña. ¿Ñe ũnierẽ yʉ mʉ jẽniñañati? Cʉ̃ yʉ masĩẽtĩña Jesure. Bairo cõ ĩ yaparo yua, ti yepa ẽñotarica jope tʉpʉ ásúpʉ Pedro. Bairo topʉ cʉ̃ caetanʉcãrõ, ãbocʉ pʉame piiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cabero tunu carõmio Pedrore qũĩñarĩ atore bairo na ĩñupõ tunu cõtʉ caãnarẽ: —Ãni cʉ̃ã, Jesús, Nazaret macããcʉ̃ mena cabapacʉti nucũatacʉ ãcʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro pʉame cõ ĩtonemoñupʉ̃ tunu: —¡Cariape Dios mena mʉ ñiña! Cʉ̃ yʉ masĩẽtĩmajũcõãña Jesure. Cabero tunu to macããna Pedrotʉ etari bairo qũĩñuparã: —Bairo ĩcũʉ̃ miña. Mʉa, Jesús mena macããcʉ̃ majũ mʉ ãniña. Mʉ cabʉsʉrije cʉ̃ã Galilea macããna na cabʉsʉrore bairo mʉ bʉsʉya. Bairi na mena macããcʉ̃ mʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bairo na caĩrõ tʉ̃go, Pedro pʉame na ĩtonemoñupʉ̃ tunu: —¡Tame, cariape Dios mena ñiña! Netõjãñurõ merẽ mʉjããrẽ, “¡Cʉ̃ yʉ masĩẽtĩña!” mʉjãã ñimiñajã —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bairo Pedro cʉ̃ caĩto ãnipaʉa, ãbocʉ pʉame piinemoñupʉ̃ tunu. Bairo cʉ̃ capiiro, Pedro pʉame tʉ̃goña bocayupʉ Jesús cʉ̃ cʉ̃ caĩatajere. “Pedro, ãmeacã ãbocʉ pʉgani cʉ̃ capiiparo jʉ̃goye itiani, ‘Cʉ̃ yʉ masĩẽtĩña Jesure,’ yʉ mitogʉ,” cʉ̃ caĩatajere tʉ̃goña bocayupʉ. Bairo tʉ̃goña bocari yua, bʉtioro otiyupʉ Pedro. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bairo ti ñami cabusuetaro, sacerdote majã quetiuparã, aperã judío majã cabʉtoa camasĩrã, bairi aperã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, nipetirã Junta Suprema macããna cʉ̃ã neñañuparã. Bairo neña, ĩbʉsʉ yaparo yua, Jesús wãmorĩrẽ jiyarotiyuparã. Áti yaparo, cʉ̃ neásúparã Pilato cawãmecʉcʉ tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato pʉame na caĩbʉsʉpairijere tʉ̃gori, bairo qũĩ jẽniñañupʉ̃ Jesure: —¿Mʉa, judío majã Quetiupaʉ Rey mʉ ãniñati? Bairo cʉ̃ caĩrõ, Jesús pʉame qũĩñupʉ̃: —Mʉ caĩrõrẽã bairo yʉ baiya. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bairi sacerdote majã quetiuparã Jesure nemojãñurõ cʉ̃ bʉsʉjãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bairi Pilato pʉame atore bairo qũĩ jẽniñañupʉ̃ Jesure: —Nocãrõ capee majũ roro mʉrẽ ĩñama. ¿Bairo na caĩmiatacʉ̃ãrẽ, na mʉ yʉgaetiyati? ");
INSERT INTO cbcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús pʉame bairo cʉ̃ caĩrõ tʉ̃gomicʉ̃ã, jĩcã wãmeacã ũno cʉ̃ yʉesupʉ. Bairo cʉ̃ cayʉeto ĩña, Pilato pʉame tʉ̃gocõã maniásupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mai, tocãnacã Pascua bose rʉ̃mʉ caãno, Pilato pʉame wiyonucũñupʉ̃ jĩcãʉ̃ preso jorica wii macããcʉ̃rẽ, judío majã na caboʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bairi tipaʉ caãno romano majã preso na cajoricʉ ãñupʉ̃ jĩcãʉ̃, Barrabás cawãmecʉcʉ. Na quetiupaʉ gobiernorẽ rocagarã camasãrẽ capajĩãrĩcãrã mena macããcʉ̃ jĩcãʉ̃ ãñupʉ̃ Barrabás. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bairo tipaʉ caãno, camasã pʉame Pilato tʉpʉ ásúparã. Bairo cʉ̃tʉ eta, “Bose rʉ̃mʉ caãno mʉ caátinucũrõrẽ bairo ása tunu,” qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bairo na caĩrõ tʉ̃gori, atore bairo na ĩ jẽniñañupʉ̃ Pilato: —¿Jesús, “Judío majã Quetiupaʉ Rey” mʉjãã caĩwãmetinucũʉ̃rẽ yʉ cawiyorotiro mʉjãã boyati? —na ĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Masĩcõãmiñupʉ̃ Pilato Jesure qũĩñatutiri sacerdote majã quetiuparã cʉ̃ cayasiro na cabotʉ̃goñarĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bairi Pilato Jesure cʉ̃ cawiyogamiatacʉ̃ãrẽ, sacerdote majã quetiuparã pʉame bairo boesuparã. Na pʉame yasioroaca camasã natʉ caãnarẽ atore bairo na ĩ rotiyuparã: “Barrabáre Pilato cʉ̃ cawiyoro boya. Jesús pʉamerẽ cʉ̃ pajĩãrotiya,” na ĩ quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bairi Pilato pʉame atore bairo na ĩ jẽniña nemoñañupʉ̃ tunu: —Bairi Jesús “Judío majã Quetiupaʉ Rey” mʉjãã caĩwãmetinucũʉ̃rẽ, ¿dope yʉ caáto mʉjãã boyati? ");
INSERT INTO cbcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bairo cʉ̃ caĩjẽniñarõ, bairo ĩ awajajʉ̃goyuparã: —¡Yucʉpãĩpʉ cʉ̃ papuatu rotiya! ");
INSERT INTO cbcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tunu na ĩnemoñupʉ̃ Pilato: —¿Nopẽĩrã yucʉpãĩpʉ cʉ̃ yʉ capapuaturotiro mʉjãã boyati? ¿Dise ũnie carorije cʉ̃ ásupari? Bairo cʉ̃ caĩjẽniñamiatacʉ̃ãrẽ, “¡Yucʉpãĩpʉ cʉ̃ papua turotiya!” bʉtioro jãñurĩ ĩ awajanemoñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bairo roro na caĩawajarijere tʉ̃goʉ, Pilato pʉame, camasã caroaro yʉre na ĩáto ĩ, Barrabáre wiyorotiyupʉ. Bairo áti yaparo, Jesure wecʉ asero wẽẽrĩ mena cʉ̃ baperotiyupʉ. Bairo cʉ̃rẽ na caátiyaparoro, na nuniñupʉ̃, Jesure yucʉpãĩpʉ na capapuatuparore bairo ĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pilato cʉ̃ carotirã soldaua pʉame Jesure cʉ̃ neásúparã pretorio cawãmecʉti wii macã yepa recomacãpʉ. Topʉ etarã, na baparãrẽ na piineñoñuparã, Jesure roro cʉ̃ átiepegarã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bairo neña yaparo, cʉ̃ jutirore weri, apero cajũãrõ, quetiupaʉ rey cʉ̃ cajãñarõ ũnorẽ Jesure cʉ̃ jããñuparã. Áti yaparo, “Quetiupaʉ rey corona cʉ̃ capesari beto ũnorẽ cʉ̃ pesa áto,” ĩrã, pota wẽẽrĩ mena juarica betore cʉ̃ rʉpoapʉ peoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bairo áticõã yua, cʉ̃rẽ quetiupaʉre jẽnirãrẽ bairo qũĩ boyeti epeyuparã: —¡Cʉ̃ ãnicõãninucũáto ãni judío majã Quetiupaʉ Rey tocãnacã rʉ̃mʉa! —qũĩ boyetiepeyuparã soldaua Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bairo áticõã, yucʉ mena cʉ̃ rʉpoare payuparã. Tunu bairoa cʉ̃ ʉcoo eyotuepeyuparã. Bairo áticõã, cʉ̃rẽ quetiupaʉre jẽnirãrẽ bairo na rʉpopaturi mena cʉ̃tʉ etanumurĩ cʉ̃ boyeti epeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bairo Jesure roro cʉ̃ átiepe yaparori yua, cʉ̃rẽ na cajãatajere cʉ̃ tuweneñuparã. Cʉ̃ jutii majũ pʉamerẽ cʉ̃ jããñuparã tunu. Bairo áti yaparo, cʉ̃ neásúparã, yucʉpãĩpʉ cʉ̃ papuaturáná yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bairo áná, bócaetayuparã jĩcãʉ̃ caʉ̃mʉ, Simón cawãmecʉcʉ, Cirene yepa macããcʉ̃rẽ. Simón pʉame Alejandro, Rufo cawãmecʉna pacʉ ãñupʉ̃. Bairo Simorẽ bócari cʉ̃ pʉsarotiyuparã, Jesús yucʉpãĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bairo átí yua, Gólgota buropʉ etayuparã. “Gólgota” ĩrã, “La Calavera” o “Rʉpoa coro buro” ĩgaro ĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bairo etarã, ʉse ocore mirra bʉʉrije cabairije ũnie mena asuriquere Jesure cʉ̃ tĩãmiñuparã. Jesús pʉame tiere etigaesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bairi soldaua yucʉpãĩpʉ Jesure cʉ̃ papuatunʉcõrĩ bero, número tiirire ãmeo wẽnuniñuparã. Bairo átiri, na majũ masĩñuparã Jesús jutii ãnajẽrẽ canepaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bairi soldaua muipʉ cʉ̃ caasitutuatípaʉ caãno yucʉpãĩpʉ cʉ̃ papuatu rocayuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tunu bairoa Jesús rʉpoa buire yucʉpãĩ woaturicapãĩrẽ papuatuyuparã, Jesure na cʉ̃ capajĩãrotirique wapare nipetiro camasã na ĩñao joroque ĩrã. Tipãĩrẽ atore bairo ĩ woaturique tusayuparo: ÃNI, JUDÍO MAJÃ QUETIUPAɄ REY NIÑAMI. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bairi Jesús mena yucʉpãĩpʉ na papuatuyuparã pʉgarã caʉ̃mʉa jerutiri majãrẽ. Jĩcãʉ̃ cariape nʉgõãrẽ, apei caãcõ nʉgõãrẽ na papuatuyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bairo na caátie pʉame Dios yaye quetibʉjʉrica tutipʉ na cawoatujʉ̃goyeticũrĩcãrõrẽ bairo cariape baietaro baiyuparo: “‘Cʉ̃ cʉ̃ã carorã mena macããcʉ̃ niñami,’ ĩ tʉ̃goñagarãma.” ");
INSERT INTO cbcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bairo yucʉpãĩpʉ papuaturicʉ Jesús cʉ̃ caãno yua, camasã canetõánucũrã pʉame Jesure qũĩroaena na rʉpoare yureyuparã. Roro majũ tore bairo qũĩñuparã: —¡Mʉ, templo wiire roca yaparori, itia rʉ̃mʉ bero ape wii cawãma wiire caqũẽnomasĩgaʉ ũcʉ̃ ãnirĩ, mʉ majũã netõña! ");
INSERT INTO cbcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Yucʉpãĩpʉ papuaturicʉ caãcʉ̃ nimicʉ̃ã, mʉ camasĩrĩjẽ jʉ̃gori yucʉpãĩpʉre ruiasá! —qũĩ epeyuparã to macããna caĩñanetõánucũrã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Torea bairo qũĩ epeyuparã sacerdote majã quetiuparã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã cʉ̃ã. Atore bairo qũĩñuparã: —Aperãrẽ na netõũpʉ̃. Bairo na netõmicʉ̃ã, ãmerẽ cʉ̃ majũã netõmasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Israel yepa macããcʉ̃ Mesías, Quetiupaʉ Rey majũ cariape cʉ̃ caãmata, cʉ̃ majũã cʉ̃ camasĩrĩjẽ mena atopʉ ruiatíbujioʉmi! Bairo cʉ̃ caruiapáta, tiere ĩñarĩ bero cariape marĩ tʉ̃gobujiorã. Bairi jerutiri majã, Jesús mena na capapuatuatana cʉ̃ã tore bairo roro qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Merẽ yua pasaribota caãno, caãno tʉsaroa naitĩãcoásúparo ati yepa nipetiropʉ. Yoaro naitĩãñuparõ. Ñamicã, tres de la tarde caãno majũ tunu busuyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tipaʉ caãno, Jesús pʉame bʉsʉrique tutuaro mena atore bairo ĩñupʉ̃: —Eloi, Eloi, ¿lema sabactani? Ti wãme pʉame ĩrã, “Yʉ Pacʉ Dios, yʉ Pacʉ Dios, ¿nopẽĩ yʉ mʉ aweyocoátí?” ĩgaro ĩña. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bairo cʉ̃ caĩrõ tʉ̃go, to macããna pʉame bairo ãmeo ĩñuparã na majũ: —¡Jã, tʉ̃goñijate! Profeta Elías ãnacʉ̃rẽ cʉ̃ pii ĩñami Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ĩcõã yua, na mena macããcʉ̃ jĩcãʉ̃ carupajitia mena ʉse oco, cajʉ̃gũẽatajere yosene ásúpʉ. Bairo átícõã, yucʉ yapapʉ ti jitiare jiyaturi, Jesutʉ ásúpʉ. Cʉ̃tʉ eta yua, tiere cʉ̃ ñumʉgõ joyupʉ, cʉ̃ etiáto, ĩ. Bairo áti yaparo, bairo na ĩñupʉ̃: —Marĩ ĩñacoteroa mai. Cʉ̃ caĩrĩjẽrẽ tʉ̃gori, ¿Elías ãnacʉ̃ yucʉpãĩpʉ cʉ̃ caãno cʉ̃ cʉ̃ ruioʉ acʉ́ati? —ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús pʉame bʉsʉrique tutuaro mena ĩ wisiotʉsa, riacoásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tipaʉ caãno, templo wii arʉare ẽñotaricaro jutii asero carecomacã woocõã ruiásúparo. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bairi soldaua quetiupaʉ capitán Jesús cʉ̃ cariayasicoato ĩñarĩ, atore bairo ĩñupʉ̃: —Cariapea ãni, Jesús, Dios macʉ̃ majũ nimiupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bairi Jesure cajʉátinemorĩcãrã jĩcããrã carõmia jõpʉ̃ã tuari qũĩñacõã nucũñuparã. Jĩcãõ na mena macããcõ ãñupõ María Magdalena cawãmecʉco. Apeo, María, Santiago cabai, bairi José paco ãñupõ. Apeo Salomé ãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na rõmirĩ pʉame Jesús Galileapʉ cʉ̃ caãno cʉ̃rẽ cajʉátinemorĩcãrã rõmirĩ ãñuparã. Aperã capããrã rõmirĩ Jerusalẽpʉ Jesús mena caetaatana cʉ̃ã ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Bairo ti rʉ̃mʉ ãñuparõ judío majã na cayerijãrĩ rʉ̃mʉ jʉ̃goye macã rʉ̃mʉ. Ti rʉ̃mʉ ñamicã merẽ judío majã qũẽno weyopeyogarã baiyuparã, na cayerijãrĩ rʉ̃mʉ caetaparo jʉ̃goye. Bairi ti rʉ̃mʉ canaiorĩpaʉ jʉ̃goyeaca José cawãmecʉcʉ, Arimatea macã macããcʉ̃ Pilatotʉ etayupʉ. Mai, José cʉ̃ã, quetiuparã, Junta Suprema majã mena macããcʉ̃ jĩcãʉ̃ caãnimajũʉ̃ ãñupʉ̃. Tunu bairoa Dios cʉ̃ carotimasĩrĩpaʉ caetarore cacotei jĩcãʉ̃ ãñupʉ̃. Bairi yua, tʉ̃goñatutuarique mena Pilato tʉpʉ átí, Jesús rupaʉri ãnajẽrẽ yarocagʉ, cʉ̃ jẽni ásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato pʉame bairo cʉ̃ caĩjẽnirõ tʉ̃go, “¿Merẽ cʉ̃ riacoabaupari?” ĩ masĩgʉ, cʉ̃ ʉ̃mʉ capitárẽ cʉ̃ piijori cʉ̃ jẽniñañupʉ̃: “¿Merẽ cʉ̃ baiyasicoaati?” ");
INSERT INTO cbcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Merẽ baiyasicoaami,” capitán cʉ̃ caĩquetibʉjʉro tʉ̃go, Jesús rupaʉri ãnajẽrẽ cʉ̃ ʉ̃mʉ capitárẽ Josére ruio rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bairo cʉ̃ caĩrõ bero, José pʉame lino jutii aserore wapati yaparo, Jesús rupaʉri ãnajẽrẽ ti asero mena cʉ̃ ũmañupʉ̃. Bairo átiri bero, cawãma ʉ̃tã ope, na cayesearica opepʉ Jesús rupaʉri ãnajẽrẽ cũñupʉ̃. Áti yaparo, ʉ̃tãpãĩ mena ti opere tubiatoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mai, María Magdalena bairi apeo María cawãmecʉco José pacojãã cʉ̃ã topʉ etari Jesure cʉ̃ na cacũrocaripaʉre ĩñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cabero yerijãrĩcã rʉ̃mʉ bero macã rʉ̃mʉ caãno María Magdalena, bairi apeo María Santiago paco, bairi apeo Salomé, cajʉtiñurĩjẽrẽ wapatiyuparã. Jesús rupaʉri ãnajẽrẽ pioturagarã baimiñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bairo ti rʉ̃mʉ, cabʉsʉripaʉaca muipʉ cʉ̃ cawãmʉatípaʉ caãno, ape semana caãni jʉ̃gori rʉ̃mʉrẽ Jesús rupaʉri ãnajẽrẽ na cacũrocaatapaʉpʉre ásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bairo topʉ áná, atore bairo ãmeo ĩ ásúparã na majũ: —¿Noa marĩrẽ ti ope na cabiaatatiire na tupãbojarãati? ");
INSERT INTO cbcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bairo ti masã opere etarã yua, ĩñajoyuparã. Ti opere na cabiaatatii, capairi ʉ̃tã tii pʉame tupãworicaropʉ bauyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bairo cabairoi, ti opepʉ jããñuparã. Bairo jããetari, jĩcãʉ̃ cawãmaʉ cariape nʉgõã pʉame jutii caroaro cabotiri wʉre cajãñaruire qũĩñañuparã. Bairo qũĩñarã yua, acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bairo na cabairo, atore bairo na ĩñupʉ̃ caʉ̃mʉ pʉame: —Mʉjãã, uwieticõãña. Yʉ masĩña. Jesús, Nazaret macã macããcʉ̃, yucʉpãĩpʉ na capapuaturocamiatacʉre cʉ̃ macãrã mʉjãã baiya. Ĩñañijate cʉ̃rẽ na cacũmiatatore. Merẽ catitunucoami. Bairi atore maniñami. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bairo ĩña yaparori bero, tunu ánája macãpʉ. Cʉ̃ cabuerã, bairi Pedro cʉ̃ãrẽ na quetibʉjʉrájá. Atore bairo na mʉjãã ĩwã: “Merẽ caticuupi Jesús. Bairi mʉjãã jʉ̃goye Galilea yepapʉ ágʉmi. Topʉ mʉjãã cotegʉmi,” na ĩ quetibʉjʉrájá. Bairo cʉ̃ cabaipeere mʉjãã cʉ̃ caquetibʉjʉcũrĩcãrõrẽã bairo topʉ cʉ̃ mʉjãã bocagarã yua —na ĩ quetibʉjʉyupʉ ángel María Magdalenajããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, carõmia pʉame yoaro mee acoásúparã. Nanauwirã, bairi tunu tie cabairijere tʉ̃goacʉari atʉcoásúparã. Bairi aperãrẽ na caĩñaatajere na quetibʉjʉesuparã, bʉtioro uwirã yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bairo judío majã na cayerijãrĩ rʉ̃mʉ busuri rʉ̃mʉ cabusuro bero Jesús cacatitunuatacʉ cõ buiaetajʉ̃goyupʉ María Magdalenarẽ. Mai, María pʉame cajʉ̃goyepʉre jĩcã wãmo peti pʉga pẽnirõ cãrõ majũ wãtĩ yeri pũnaarẽ Jesús cʉ̃ caawiyojobojarico ãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bairo Jesús Maríare cʉ̃ cabuiaetaro bero, cʉ̃ mena caquetibʉjʉñesẽãnucũrĩcãrãrẽ na quetibʉjʉo ácó ásúpo. Mai, na pʉame bʉtioro yapapuari otirã baiãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bairo, “Jesús merẽ tunu catiupi. Mepʉ cʉ̃ ñiñaapʉ̃,” cõ caĩrõ tʉ̃gomirãcʉ̃ã, cariape cõ tʉ̃goesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tipaʉ bero aperã cʉ̃ cabuerã pʉgarã caáñesẽãrãrẽ apeire bairo tunu na buiaetayupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bairo na cʉ̃ cabuiaetaro bero, na cʉ̃ã tunucoásúparã Jerusalẽpʉ cʉ̃ cabuerãrẽ na quetibʉjʉráná. Na cʉ̃ãrẽ cariape na tʉ̃goesuparã cʉ̃ cabuerã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cabero tunu cʉ̃ cabuerã pʉga wãmo peti rʉpore jĩcãã pẽnirõ caãnacãʉ̃ majũ na caʉgaruiripaʉa buiaetayupʉ. Bairo natʉ buiaetari, “Tunu caticuupi,” na yarã na caĩrĩjẽrẽ cariape na catʉ̃goetoi jʉ̃gori, “¿Nopẽĩrã, ‘Tunu caticuupi,’ na caĩrĩjẽrẽ cariape mʉjãã tʉ̃goetiyati?” na ĩ tuti etayupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bairo ĩ yaparo, atore bairo na ĩ quetibʉjʉnemoñupʉ̃: “Camasã tocãnacã poari macããnarẽ noo na caãnopʉ, yʉ yaye caroa quetire na quetibʉjʉ ñesẽãrájá, na cʉ̃ã yʉ yaye quetire na catʉ̃goʉsaparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bairo noa ũna yʉ yaye quetire tʉ̃goʉsari, cabautiza rotirã ũna caroaro netõcõãgarãma. Aperã catʉ̃goʉsaena pʉame roro popiye baigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bairi tunu yʉre catʉ̃goʉsarãrẽ cʉ̃ camasĩrĩjẽrẽ na jogʉmi Dios. Tiere narẽ cʉ̃ cajoro capee wãmerĩ átimasĩgarãma. Yʉ catutuarije mena wãtĩã camasãrẽ cajãñarãrẽ na acurewiyojo masĩgarãma. Bairi tunu aperã yayere na cabʉsʉmasĩẽtajere bʉsʉmasĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ãñarẽ ñerã cʉ̃ã, bairi capũnirĩjẽrẽ etirã cʉ̃ã, dope bairo baietigarãma. Apeyera tunu cariarãrẽ na wãmorĩ mena na cañigãpeoroa, na cariayecʉtie netõcoagaro,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bairo Jesús cʉ̃ cabuerãrẽ na ĩ quetibʉjʉ yaparori bero, na wʉweyori, ʉmʉrecóo pʉamerẽ wãmʉcoásúpʉ. Cʉ̃ pacʉ Dios tʉpʉre etaʉ, cariape nʉgõã pʉame etari ruiyupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bairo ʉmʉrecóopʉ cʉ̃ cawãmʉatato bero, cʉ̃ cabuerã tocãnacãʉ̃pʉa nipetiropʉ Jesús yaye quetire quetibʉjʉ ñesẽãñuparã. Na caquetibʉjʉñesẽãrõ, marĩ Quetiupaʉ pʉame masĩrĩqũẽrẽ na joyupʉ. Capee wãmerĩ átijẽño masĩrĩqũẽrẽ na joyupi, camasã, “Na caquetibʉjʉrijere cariapea niña,” na ĩ masĩáto ĩ yua. Tocãrõã ñiña.");
INSERT INTO cbcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Mʉ, Teófilo, nocãrõ majũ caãnimajũʉ̃rẽ, ati carta mena mʉ yʉ quetibʉjʉ woatujopa mai, Jesucristo cʉ̃ caátiãnajẽrẽ caroaro cõñarĩcãrõrẽ bairo. Mai, capããrã camasã tiere, Jesús cʉ̃ caátiãnajẽrẽ merẽ quetibʉjʉ woajomiñupã. Bairo na caátimiatacʉ̃ãrẽ, yʉ cʉ̃ã tiere yʉ quetibʉjʉ woajogʉ. Mai, Jesús cʉ̃ caátiãnajẽrẽ caĩñarĩcãrã pʉame na caquetibʉjʉnetõrĩqũẽrẽ jãã cʉ̃ãrẽ jãã quetibʉjʉwã. Caãnijʉ̃goripaʉ Jesús cʉ̃ caátiãnajẽrẽ na caĩñarĩqũẽrẽ jãã cʉ̃ãrẽ jãã quetibʉjʉwã. Bairo tiere tʉ̃gori yua, caroaro cõñarĩcãrõrẽ bairo mʉ yʉ quetibʉjʉ woatujoya ati carta mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Teófilo, merẽ Jesús cʉ̃ caátiãnajẽ jĩcã wãme ũnorẽ mʉ tʉ̃goyupa. Bairo cʉ̃ caátiãnajẽ nipetirije caroaro cariape cʉ̃ masĩnemoáto ĩ, mʉ yʉ quetibʉjʉ woajoya ati carta mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bairo baiyupa: Herodes cawãmecʉcʉ ãnacʉ̃ Judea yepa macããnarẽ quetiupaʉ rey cʉ̃ caãni yʉteare jĩcãʉ̃ sacerdote ãñupʉ̃. Abías ya poa macããcʉ̃ jĩcãʉ̃ ãñupʉ̃. Cʉ̃ pʉame Zacarías wãmecʉsupʉ. Cʉ̃ nʉmo Isabel wãmecʉsupo. Cõ pʉame Aarón ãnacʉ̃ pãrãmeo majũ ãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bairi na, pʉgarãpʉa Dios cʉ̃ caroticũrĩqũẽ nipetirijere tʉ̃goʉsayuparã. Bairo bairã, carorije wapa mánarẽ bairo baiyuparã, Dios cʉ̃ caĩñajoro. Tunu bairoa nii ũcʉ̃, “Roro ásuparã na,” ĩ masĩẽsuparã narẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na pʉame tiwatoare capũna mána ãñuparã. Isabel pʉame pũnaa bomiocʉ̃ã, yoaro pũnacʉti masĩẽsupo. Tunu bairoa cabʉtoa ãnirĩ na capũna cʉtigamirĩcãpaʉ merẽ netõcoásúparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bairo na cabairipaʉ jĩcã rʉ̃mʉ Zacarías templo wiipʉ paaʉ ásúpʉ, cʉ̃ ya poa macããna mena cʉ̃ cajʉpaari rʉ̃mʉ caetaro ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bairo topʉ eta, jʉpaa yua, jĩcã rʉ̃mʉ cʉ̃ yarã pʉame cʉ̃ beseyuparã. “Templo wii pupeapʉ werea cajʉtiñurĩjẽrẽ cʉ̃ joeáto,” qũĩñuparã cʉ̃ yarã Zacaríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bairo Zacarías, “Jaʉ,” ĩ, ti wii pupea ape arʉapʉ jãásúpʉ. Ti hora Zacarías cajʉtiñurĩjẽrẽ cʉ̃ cajoeri hora majũ Diore cʉ̃ jẽnirã baiyuparã camasã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bairo Zacarías tiere cʉ̃ cajoeãno yua, cʉ̃ tʉpʉ ángel pʉame buiaetayupʉ. Altar, cajʉtiñurĩjẽrẽ cʉ̃ cajoemʉgõrĩ mesa cariape nʉgõã pʉame buiaetanʉcãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bairo ángel cʉ̃ cabairo, Zacarías pʉame qũĩña acʉacoasupʉ. Qũĩña uwijãñuñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bairo cʉ̃ cabairo ĩña, ángel pʉame qũĩñupʉ̃ Zacaríare: —Yʉ uwieticõãña Zacarías. Caroa quetire mʉ quetibʉjʉ acʉ́ yʉ atíapʉ. Dios, mʉ cajẽnirĩjẽrẽ tʉ̃goyami. Bairo bairi mʉ caborore bairo mʉ nʉmo, macʉ̃ cʉtimasĩgomo. Bairi mʉ macʉ̃ caãnipaʉ cʉ̃ cabuiaro yua, “Juan” cʉ̃ mʉ wãmetigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti rʉ̃mʉ, cʉ̃ cabuiari rʉ̃mʉrẽ mʉ ʉseanigʉ bʉtioro. Mʉ mena macããna cʉ̃ã capããrã ʉseanigarãma, cʉ̃ cabuiaro ĩñarĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tunu bairoa mʉ macʉ̃ caãnipaʉ pʉame Dios yaye quetire catʉ̃gomasĩ ãnirĩ caãnimajũʉ̃ nigʉmi Dios cʉ̃ caĩñajorore. Bairi tunu ʉse oco cacũmuorĩjẽrẽ cʉ̃ etieticõáto. Bairi tunu Espíritu Santo, Dios Yeri cʉ̃ camasĩõrĩjẽ carʉsaecʉ majũ ãnicõãgʉmi. Cʉ̃ cabuiaparo jʉ̃goyepʉa merẽ cʉ̃ mena ãnicõãgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bairo mʉ macʉ̃ caãnipaʉ bʉtiácʉ́ yua, Israel yepa macããna capããrã cʉ̃ caquetibʉjʉrijere tʉ̃goʉsagarãma. Bairo bairã, marĩ Quetiupaʉ Diore cʉ̃ bogarãma tunu, na cʉ̃ caquetibʉjʉrije jʉ̃gori yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tunu bairoa marĩ Quetiupaʉ ati yepapʉ cʉ̃ caetaparo jʉ̃goye camasãrẽ na quetibʉjʉgʉmi mʉ macʉ̃ caãnipaʉ pʉame. Elías cawãmecʉcʉ ãnacʉ̃ Espíritu Santo jʉ̃gori caroaro cʉ̃ caquetibʉjʉmasĩrĩcãrõ cãrõ cʉ̃ cʉ̃ã Dios Yeri jʉ̃gori camasãrẽ caroaro na quetibʉjʉ masĩgʉmi. Bairo cʉ̃ caquetibʉjʉro, capũnacʉna pʉame na pũnaa mena na asiajãnao joroque na átigʉmi. Tunu bairoa Dios yaye quetire catʉ̃gogaena cʉ̃ã cariape tʉ̃goʉsagarãma tunu, mʉ macʉ̃ caãnipaʉ caroaro cʉ̃ caquetibʉjʉrije jʉ̃gori yua. Bairo bairi mʉ yarã Israel yepa macããna marĩ Quetiupaʉ cʉ̃ caetaparore caroaro yugarãma mʉ macʉ̃ caãnipaʉ caroaro na cʉ̃ caquetibʉjʉrije jʉ̃gori yua —qũĩ quetibʉjʉyupʉ ángel Zacaríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, Zacarías pʉame cariape cʉ̃ tʉ̃goesupʉ: —¿Ñe jʉ̃gori, “Cariape mʉ bʉsʉya,” ñi masĩcʉti? Merẽ cabʉtoa majũ jãã ãniña yʉ, yʉ nʉmo cʉ̃ã. Torena, jãã pũnacʉti masĩẽtĩña —qũĩñupʉ̃ Zacarías ángel pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bairo cʉ̃ caĩrõ tʉ̃go, ángel pʉame Zacaríare qũĩñupʉ̃ tunu: —Yʉʉ, Gabriel, Diotʉ macããcʉ̃ yʉ ãniña. Cʉ̃ majũã yʉ joámi mʉ tʉpʉ, caroa quetire cʉ̃ masĩáto, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Baipʉa, cabʉsʉmasĩẽcʉ̃ mʉ tuagʉ ãmerẽ. Yʉ caĩrĩjẽrẽ cariape mʉ catʉ̃goetie wapa bairo mʉ tuagʉ. Cabero mʉ macʉ̃ caãnipaʉ cʉ̃ cabuiaropʉ roque tunu mʉ bʉsʉmasĩgʉ. Yʉ yaye quetire mʉ caĩroaetimiatacʉ̃ãrẽ, tore bairo nipetirije baipeticoagaro ti yʉtea caetaro —qũĩ quetibʉjʉyupʉ ángel Zacaríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bairo ángel mena Zacarías cʉ̃ cabʉsʉãnitoye yua, to macããna cañubueri majã pʉame Zacarías ti arʉa cʉ̃ cawitietoi, yoaro coteyuparã. Na pʉame: “¿Nopẽĩ yoaro cʉ̃ baiyati?” ãmeo ĩ jẽniñañuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cabero Zacarías witietaʉ, na quetibʉjʉ masĩẽsupʉ. Cʉ̃ wãmo mena jeto na quetibʉjʉmiñupʉ̃. Bairo cʉ̃ cabairo ĩña, atore bairo ãmeo ĩñuparã: “Qũẽguericarore bairo apeye ũnierẽ ĩñaatacʉmi Zacarías,” ãmeo ĩ bʉsʉyuparã cañubueri majã macãpʉ cacoterã pʉame. Bairo bʉsʉmasĩẽcʉ̃ã, ãnicõãñupʉ̃ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bairo Zacarías nocãnacã rʉ̃mʉ bero templo wii coterique cʉ̃ capaari rʉ̃mʉrĩ capetiro ĩña, tunucoásúpʉ cʉ̃ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bairo topʉ eta, ãni yua, tocãrõã cʉ̃ nʉmo Isabel pʉame bairirupaʉ ãñupõ merẽ. Bairi wii pupeapʉ ãnicõã ninucũñupõ. Jĩcã wãmo cãnacãʉ̃ muipʉa, aperã tʉpʉ átáto mano ãnicõãnucũñupõ cõ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cõ pʉame bairo ĩ tʉ̃goñañupõ: “Ãmerẽ yʉ átinemoñami Dios, camasã pʉame, ‘Capũna mácõ niñamo Isabel,’ yʉre na caĩbʉsʉpaietiparore bairo ĩ. Bairi, ñujãñuñami Dios yʉ mena,” ʉseanirĩ ĩ tʉ̃goñanucũñupõ Isabel. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cabero Isabel jĩcã wãmo peti jĩcã pẽnirõ cãnacãʉ̃ muipʉa majũ bairirupaʉ cõ caãno, ángel Gabriel cawãmecʉcʉre cʉ̃ joyupʉ Dios tunu. Galilea na caĩrĩ yepapʉ, Nazaret cawãmecʉti macãpʉ cʉ̃ joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","“María cawãmecʉcore mʉ quetibʉjʉápá,” ĩ, cʉ̃ joyupʉ. Mai, María pʉame camanapʉ mácõ ãñupõ. Caʉ̃mʉ mena ãmeñupõ. José cawãmecʉcʉ nʉmo caãnipao ãnirĩ apei mena ãmeñupõ. José pʉame David ãnacʉ̃ pãrãmi ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bairo bairi Gabriel pʉame Maríare cõ buiaetayupʉ. Bairo cõtʉ buiaetari yua, cõ ĩñupʉ̃: —¡María, Dios cʉ̃ caĩroao majũ, mʉ ãnimiñati! Marĩ Quetiupaʉ mʉ mena ãniñami. Tocãnacãõ camasã rõmirĩ netõrõ caroaro mʉ átinemoñami —cõ ĩ quetibʉjʉ etayupʉ ángel Maríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Bairo cʉ̃ caĩrõ tʉ̃go yua, cõ pʉame tʉ̃go acʉacoasupo: “¿Dope bairo ĩgʉ qũĩñati, yʉre bairo cʉ̃ caĩjẽniata?” ĩ tʉ̃goñañupõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bairo cõ caĩtʉ̃goñarõ yua, ángel pʉame cõ ĩñupʉ̃ tunu: —Yʉ uwieticõãña María. Caroa quetire mʉrẽ quetibʉjʉ acʉ́ yʉ atíapʉ. Caroaro mʉ caátiãnierẽ ĩñajesoyami marĩ Quetiupaʉ Dios. Bairi mʉ beseami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bairi bairirupaʉ mʉ ãnigo. Cawĩmaʉaca mʉ cʉ̃gogo. Bairi mʉ macʉ̃ caãnipaʉ cʉ̃ cabuiaro yua, “Jesús” cʉ̃ mʉ wãmetigo. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tunu bairoa mʉ macʉ̃ caãnipaʉ pʉame caátirotimasĩ nigʉmi. Bairi nipetiro camasã, “Dios jõbui macããcʉ̃ macʉ̃ majũ niñami,” qũĩgarãma camasã cʉ̃rẽ. Cʉ̃, marĩ Quetiupaʉ Dios pʉame mʉ macʉ̃ caãnipaʉre quetiupaʉre bairo cʉ̃ cũgʉmi. Cʉ̃ ñicʉ̃ ãnacʉ̃ David ãnacʉ̃rẽ bairo cʉ̃ cũgʉmi mʉ macʉ̃ caãnipaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bairo cʉ̃ cacũrõ yua, mʉ macʉ̃ caãnipaʉ pʉame rotimasĩgʉmi. Israel yepa macããnarẽ tocãnacã rʉ̃mʉa na rotimasĩ ãnigʉmi yua. Cʉ̃ carotiãnie petietigaro —cõ ĩ quetibʉjʉyupʉ ángel Maríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Bairo cʉ̃ caĩrõ tʉ̃go, María pʉame atore bairo qũĩ jẽniñañupõ: —Yʉ pʉame, ¿dope bairo yʉ baioati? Caʉ̃mʉ mena yʉ ãmerĩnucũña —qũĩñupõ María ángel pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bairo cõ caĩrõ, cʉ̃ pʉame cõ ĩñupʉ̃: —Espíritu Santo, Dios Yeri majũ buseriwo ruiatí, catorore bairo baiñajãetagʉmi mʉpʉre. Bairo Dios, nipetiro netõrõ caátimasĩ, cʉ̃ camasĩrĩjẽ jʉ̃gori cawĩmaʉaca mʉ cʉ̃gogo. Bairo bairi nipetiro camasã, “Caroʉ́ cañuʉ, Dios macʉ̃ majũ niñami,” qũĩgarãma camasã cʉ̃rẽ, mʉrẽ cabuiapaʉ pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Apeyera tunu mʉ yao Isabel cawãmecʉco cʉ̃ã cabʉcʉo ãnimiocʉ̃ã, ãmerẽ bairirupaʉ ãniñamo cõ cʉ̃ã. Jĩcã wãmo peti jĩcã pẽnirõ cãnacãʉ̃ muipʉa merẽ cʉ̃goyamo capũna mácõ na caĩmirĩcõ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dise ũnie Dios cʉ̃ caátimasĩẽtĩẽ maniña. Nipetiro cʉ̃ caátimasĩrĩjẽ jeto niña —cõ ĩ quetibʉjʉ yaparoyupʉ ángel Maríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bairo cʉ̃ caĩrõ tʉ̃go, María pʉame qũĩñupõ: —Mʉ caĩrõrẽ bairo to baiáto toroque. Dios cʉ̃ carotio yʉ ãniña. Bairi cʉ̃ caborore bairo yʉ cʉ̃ áparo —qũĩñupõ María. Bairo cõ caĩyaparoro, ángel pʉame acoásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cabero nocãnacã rʉ̃mʉ bero caãno, María pʉame Judea caʉ̃tãyucʉ pairi yepapʉ, cariape acoásúpo. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Topʉ eta, Zacarías, bairi Isabel ya wiipʉ jããñupõ. Bairo jããrĩ yua, Isabere cõ ĩ jẽniñupõ: “¡Mʉ ãnimiñati!” ");
INSERT INTO cbcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bairo María cõ caĩrõ, Isabel macʉ̃ãcã pʉame cõ paropʉ yuguiyupʉ. Bairo cʉ̃ cabairo, Espíritu Santo Isabel yerire jããñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bairo cʉ̃ cajããrõ, Isabel pʉame Maríare ʉseanirĩqũẽ mena atore bairo cõ ĩñupõ: —¡Yʉ yao, camasã rõmirĩ tocãnacãõ netõrõ caroare mʉ joyami marĩ Pacʉ Dios! Mʉ macʉ̃ caãnipaʉ cʉ̃ãrẽ caroare cʉ̃ joyami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cabʉgoro macããcõ yʉ ãniña. Bairo cabaio yʉ caãnimiatacʉ̃ãrẽ, mʉ, yʉ Quetiupaʉ paco, yʉ mʉ nʉcʉ̃bʉgoya, bairo yʉre ĩñao acó. ¡Yʉ mena mʉ ñujãñuña! ");
INSERT INTO cbcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tʉ̃goya. Yʉre mʉ cajẽnirõ, yʉ macʉ̃ caãnipaʉ pʉame yʉ paropʉ yuguiami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Yʉ yao ʉseanirĩ ãña! Mʉrẽ marĩ Quetiupaʉ cʉ̃ caĩrĩqũẽrẽ cariape mʉ tʉ̃goyupa. Bairi caroare mʉ joupi Dios —cõ ĩñupõ Isabel Maríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bairo cõ caĩrõ, María pʉame cõ ĩñupõ Isabere: “Yʉ yeri ñujãñuña. Ñe ũnie yʉ rʉsaetiya. Yʉ mena ñumajũcõãñami marĩ Pacʉ Dios. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Dios, yʉre canetõõʉ̃, caroaro cʉ̃ caátiere tʉ̃goñarĩ yʉ ʉseaninetõña yʉ yeripʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yʉʉ, cʉ̃ carotio cabʉgoro macããcõ yʉ ãniña. Bairo cabaio yʉ caãnimiatacʉ̃ãrẽ, yʉ beseami. Cʉ̃ cajoʉ paco yʉ ãnigo cʉ̃ camasĩrĩjẽ jʉ̃gori. Bairo bairi nipetiro camasã ñiroagarãma. ‘Camasã rõmirĩ tocãnacãõ netõrõ ʉseaniñamo María,’ ñigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Marĩ Pacʉ Dios nipetiro caátimasĩ ãnirĩ caroare yʉ joami. Cʉ̃ caátimasĩrĩjẽ ñujãñuña yʉre. ¡Caroʉ́ cañuʉ majũ niñami! ");
INSERT INTO cbcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tunu bairoa noa ũna cʉ̃rẽ canʉcʉ̃bʉgorãrẽ na ĩñamaiñami Dios. Ape tuti, ape tuti macããnarẽ bairo jeto na ĩñamaiñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tunu cʉ̃rẽ canʉcʉ̃bʉgorãrẽ cʉ̃ caátimasĩrĩjẽrẽ na ĩñoñami Dios. ‘Cabʉgoro macããna mee marĩ ãniña,’ caĩtʉ̃goñarã roquere na caátigamirĩjẽrẽ na ẽñotayami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Quetiuparã cʉ̃ãrẽ na rotijãnoñami. Aperã cabʉgoro macããna roquere caãnimajũrã na ãnio joroque na átiyami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tunu bairoa caqueyarãrẽ ʉgariquere pairo na joyami. Aperã capee apeye ũnierẽ cacʉ̃gorã roquere ñe ũnie mánarẽ bairo na átiyami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Marĩ ñicʉ̃jãã, Abrahãjããrẽ cʉ̃ caĩrĩcãrõrẽ bairo átiyami Dios. Tiere masiritietiyami. Bairi marĩ, Israel yepa macããnarẽ marĩ jʉátiyami ãmerẽ caroaro,” cõ ĩñupõ ʉseanirĩ María Isabere. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bairo ĩ yaparo yua, Isabejãã mena ãninucũñupõ María. Itiarã muipʉa bero caãno, cõ ya wiipʉ tunucoásúpo tunu. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cabero Isabel pʉame cõ macʉ̃ cʉ̃ cabuiari rʉ̃mʉ etayuparo. Bairo caetari rʉ̃mʉ cõ macʉ̃ buiaetayupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bairo cʉ̃ cabuiaro, Isabejãã yarã, bairi natʉ macããna cʉ̃ã cõ macʉ̃ cʉ̃ cabuiaro tʉ̃gori ʉseaniñuparã. “Bairi cõ ĩñamaiñami Dios,” ʉseanirĩ ãmeo ĩñuparã na yarã, bairi natʉ macããna cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bairo jĩcã wãmo peti itia pẽnirõ cãnacã rʉ̃mʉrĩ cõ macʉ̃ cʉ̃ cabuiaro bero etayuparã na yarã pʉame. Cʉ̃ãcã rupaʉ macããtõrẽ yisetarã etayuparã. Bairo áti yaparo yua, cʉ̃ pacʉ wãmerẽ bairo, Zacarías cʉ̃ wãmetigamiñuparã cʉ̃ãcã cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bairo na cabomiatacʉ̃ãrẽ, cʉ̃ paco pʉame atore bairo ĩñupõ: —Bairo jãã boetiya. “Juan” roque jãã boya. Bairo marĩ wãmetiroa yʉ macʉ̃ãcãrẽ —na ĩñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bairo cõ caĩrõ tʉ̃go, cõ ĩñuparã: —¿Nopẽĩõ “Juarẽ” mʉ boyati? ¿Ni ũcʉ̃ mʉjãã yaʉ Juan cawãmecʉcʉ cʉ̃ ãñuparĩ? Jĩcãʉ̃ ũcʉ̃ mácʉ̃mi —cõ ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bairo cõ ĩ yaparo, Zacarías cabʉsʉmasĩẽcʉ̃rẽ na wãmorĩ mena qũĩ jẽniñañuparã, “¿dise wãme pʉame cʉ̃ boyati?” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bairo na caĩjẽniñarõ, Zacarías pʉame cʉ̃ wãmorĩ mena “Woaturicapãĩ, yucʉpãĩrẽ neasá,” na ĩñupʉ̃. Bairo na canenunirõ bero, Zacarías, “Juan wãmecʉtigʉmi cʉ̃ãcã,” ĩ woatuyupʉ tipãĩpʉre yua. Bairo cʉ̃ caĩwoaturo, to macããna caetari majã pʉame ĩña acʉacoasuparã, “¿Nopẽĩ bairo cʉ̃ boyati?” ĩrã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tocãrõã Zacarías cabʉsʉmasĩẽtĩmiatacʉ jicoquei bʉsʉmasĩcoasupʉ tunu. Bairo bʉsʉmasĩcõã yua, Diore qũĩ basapeoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bairo bairi natʉ macããna tʉ̃go acʉayuparã nipetirã. Tunu bairoa Judea yepa macããna caʉ̃mʉarĩ yepa macããna nipetirãpʉ ãmeo quetibʉjʉyuparã Zacaríajãã na cabairiquere. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bairo ãmeo quetibʉjʉrã yua, na yeripʉ tʉ̃goñañuparã nipetirã bʉtioro. “¿Dope cabaipaʉ cʉ̃ ãnicʉti ãni cawĩmaʉ?” ãmeo ĩñuparã. “Cariape Dios cʉ̃ maitʉ̃goñañupĩ,” ãmeo ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías pʉame cʉ̃ macʉ̃ cʉ̃ caátipeere quetibʉjʉyupʉ. Espíritu Santo cʉ̃ camasĩõrĩjẽ jʉ̃gori atore bairo ĩñupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Marĩ Pacʉ Dios caroʉ́ majũ niñami, marĩ, Israel yepa macããna, marĩ caĩroaʉ! Bairi marĩtʉ atíyami. Marĩ netõõʉ̃ acʉ́ atíyami, cʉ̃ yarã majũ marĩ caãnoi. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Marĩrẽ joʉ átiyami catutuaʉ majũ, marĩrẽ canetõõpaʉre. Cʉ̃ carotiricʉ David ãnacʉ̃ pãrãmerã poa watoai marĩrẽ joʉ átiyami marĩrẽ canetõõpaʉ majũrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tirʉ̃mʉpʉre profeta majãrẽ cʉ̃ caquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baietaro baiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bairo boyupi Dios: Marĩ wapana roro marĩrẽ caátigarãrẽ marĩ canetõõrõ boyupi. Tunu bairoa marĩ pesua roro marĩrẽ caátigarãrẽ marĩ canetõõrõ boyupi. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bairo bairi marĩrẽ joʉ átiyami marĩrẽ canetõõpaʉre. Marĩ ñicʉ̃jããrẽ cʉ̃ caĩrĩcãrõrẽ bairo ácʉ, marĩrẽ ĩñamairĩ, marĩ joʉ átiyami cʉ̃rẽ. Cʉ̃ caĩjʉ̃goyeticũrĩcãrõrẽ bairo tiere masiritietiyami Dios. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Marĩ ñicʉ̃ Abraham ãnacʉ̃rẽ cʉ̃ caĩcũrĩcãrõrẽ bairo tiere masiritietiyami. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bairi marĩ wapanarẽ cʉ̃ canetõrõ, marĩ pʉame uwiricaro mano cʉ̃ yaye quetire marĩ tʉ̃goʉsagarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tunu bairoa carorije caáperã, cariape caána majũ marĩ ãnigarã Dios cʉ̃ caĩñajoro tocãnacã rʉ̃mʉ marĩ cacatiri rʉ̃mʉ cãrõ,” ĩ quetibʉjʉyupʉ Zacarías. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ĩ quetibʉjʉ yaparo, qũĩñupʉ̃ tunu cʉ̃ macʉ̃ãcãrẽ: “Macʉ̃, atore bairo migarãma: ‘Dios jõbui macããcʉ̃ yaʉ niñami Juan. Cʉ̃ yaye quetire caquetibʉjʉjʉ̃goyecʉcʉ niñami,’ migarãma. Marĩ Quetiupaʉ camasãrẽ cʉ̃ caquetibʉjʉparo jʉ̃goye mʉ quetibʉjʉ jʉ̃goyecʉtigʉ. Marĩ Quetiupaʉ yaye quetire caroaro na tʉ̃goáto ĩ, cʉ̃ jʉ̃goye mʉ quetibʉjʉ jʉ̃goyecʉtigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bairo mʉ caquetibʉjʉro, Israel ya poa macããna atore bairo ĩ masĩgarãma: ‘Roro marĩ caátiere masiriyogʉmi marĩ Pacʉ Dios. Marĩ netõõgʉmi,’ ĩ masĩgarãma yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Marĩ Pacʉ Dios pʉame cʉ̃ camairĩjẽ mena marĩ netõõñami. Ti rʉ̃mʉ marĩrẽ cʉ̃ canetõõrĩ rʉ̃mʉ merẽ etaya. Jĩcã rʉ̃mʉ cabusuetarore bairo merẽ etaya. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Bairi camasãrẽ caroaro na masĩõgʉmi Dios cʉ̃ cajopaʉ. Camasã pʉame canaitĩãrõpʉ ruirãrẽ bairo caãna niñama. Bairo caãna nimirãcʉ̃ã, caroaro cabusurore ĩñarãrẽ bairo nigarãma, cʉ̃ caquetibʉjʉrijere tʉ̃gorã. Jĩcãrõ tʉ̃nia ãnimasĩgarãma,” qũĩñupʉ̃ Zacarías cʉ̃ macʉ̃ãcãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bairo cabero Zacarías cʉ̃ caĩrõrẽ bairo baiyupʉ. Cʉ̃ macʉ̃ yeri ñuʉ bʉtiásúpʉ. Bairo bʉtiácʉ́, desierto cayucʉmanopʉ ãninucũñupʉ̃ Juan. Israel ya poa macããnarẽ Dios yaye quetire cʉ̃ caquetibʉjʉparo jʉ̃goye topʉ ãninucũñupʉ̃ Zacarías macʉ̃ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mai, tiwatoapʉre quetiupaʉ emperador Augusto cawãmecʉcʉ ti yepa nipetiro caroti ãñupʉ̃. Bairo ãcʉ̃, na cõñarotiyupʉ nipetiro camasãrẽ. Na wãmerĩrẽ woatu rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mai, tiere, Siria cawãmecʉti yepa macããnarẽ, Cirenio cawãmecʉcʉ na quetiupaʉ cʉ̃ caãnipaʉ camasãrẽ na cõñajʉ̃go rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Torena, nipetiro camasã na ñicʉ̃jãã na caãni macãrĩpʉ ásúparã, na wãmerĩrẽ woatu rotiráná. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José cʉ̃ã Galilea cawãmecʉti yepa, Nazaret macã macããcʉ̃ caãniatacʉ ásúpʉ. Quetiupaʉ rey David ãnacʉ̃ pãrãmi ãnirĩ, David cʉ̃ cabuiaricaropʉ ásúpʉ, Belén cawãmecʉti macã Judea yepapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","María cʉ̃ nʉmo caãnipao mena ásúpʉ José, na wãmerĩrẽ woaturoti ácʉ́. María pʉame merẽ macʉ̃ jãñañupõ cõ parore. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bairi Belén macãrẽ na caetaro bero, cõ macʉ̃ãcã cʉ̃ cabuiari rʉ̃mʉ etayuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mai, ti macãpʉ camasã cañesẽãrĩ majã na cacãnirĩ wii jiranetõcoasuparo merẽ. Torecʉ, ti wii upaʉ wecʉa cʉ̃ canurã na cacãnirĩ wiipʉ yosarotiyupʉ Maríajããrẽ. Bairi topʉa macʉ̃cʉsupo, cõ macʉ̃ caãnijʉ̃goʉre. Bairo macʉ̃cʉti, jutii aseri mena cʉ̃ ũmañupõ. Cʉ̃ ũmarĩ yua, wecʉa, na caʉgari coropʉ cʉ̃ cũñupõ, topʉ cʉ̃ cãniáto, ĩõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bairo ti ñamirẽ waibʉtoa nurĩcãrã oveja cawãmecʉnarẽ cacoteri majã ãñuparã. Topʉ Belén macãtʉre na coteyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bairo na cacoteãno caãnoa yua, ángel Dios mena macããcʉ̃ natʉ buiaetayupʉ. Bairo cʉ̃ cabuiaetaro, na tʉpʉ bʉtioro asiwoyuparo Dios yaye mena cʉ̃ caasiyarije. Bairi ovejare cacoteri majã pʉame bʉtioro uwitʉ̃goñañuparã, bairo cabairoi. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bairo na cauwitʉ̃goñarõ ĩña, ángel pʉame atore bairo na ĩñupʉ̃: “Mʉjãã, ovejare cacoteri majã yʉ uwieticõãña. Caroa quetire mʉjããrẽ quetibʉjʉ acʉ́ yʉ atíapʉ. Nipetiro camasã tiere tʉ̃gorã bʉtioro ʉseanigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bairo baiya queti: Ãme ñami David ãnacʉ̃ cʉ̃ caãna macãpʉre buiámi mʉjããrẽ canetõõpaʉ. Mʉjãã Quetiupaʉ, Mesías, Dios cʉ̃ cajoʉ majũ merẽ buiámi,” na ĩñupʉ̃ ángel oveja cacoteri majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bairo na ĩ yaparo, atore bairo ĩnemoñupʉ̃: “Wecʉa wiipʉ na caʉgarique nurĩcã coro buipʉ pesayami. Jutii aseri mena ũmarĩcʉ̃ topʉ pesayami. Bairo mʉjãã cʉ̃ãcãrẽ bócarã yua, ‘Cʉ̃ã niñami,’ mʉjãã ĩ masĩgarã,” na ĩ quetibʉjʉyupʉ ángel ovejare cacoterãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bairo cʉ̃ caĩãno, ángelea majã capããrã buiaetayuparã jõbui macããna. Diore cʉ̃ basapeorã etayuparã. Atore bairo ĩ basayuparã: ");
INSERT INTO cbcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Dios jõbui macããcʉ̃ cañunetõʉ̃ niñami! ¡Bairi jĩcãrõ tʉ̃ni tʉ̃goñarĩqũẽrẽ cʉ̃ joáto narẽ cʉ̃ mena caroaro caãnarẽ!” ĩ basapeoyuparã ángelea majã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bairo ĩ basapeo yaparori bero, tunucoásúparã jõbuipʉ tunu. Bairo na caátó bero, ovejare cacoterã pʉame ãmeo ĩñuparã: —Jito, marĩ átóca Belẽpʉ. Marĩ Quetiupaʉ ãme ñami cʉ̃ caquetibʉjʉrijere bairo cabaiatajere marĩ ĩñaráróa —ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bairo ĩ yaparo, tãmurĩ ásúparã Belẽpʉ. Topʉ eta, Maríare, bairi Josére na bócayuparã. Cawĩmaʉacarẽ, wecʉa nurĩcã coro buipʉ capesaʉre cʉ̃ bócayuparã cʉ̃ cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bairo qũĩñarĩ, bairo ángel narẽ cʉ̃ caĩatajere na quetibʉjʉ netõñuparã Maríajããrẽ. “‘Mʉjãã Quetiupaʉ buiámi,’ jãã ĩãmi ángel,” na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bairi nipetiro camasã ovejare cacoteri majã na caĩquetibʉjʉnetõõrĩjẽrẽ tʉ̃gorã, bʉtioro tʉ̃goñañuparã na yeripʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María pʉame capee majũ tʉ̃goñanucũñupõ cõ yeripʉ ovejare cacoteri majã na caĩrĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Cabero ovejare cacoteri majã pʉame ʉseanirĩqũẽ mena tunucoásúparã. Bairo áná, Diore qũĩ basapeoyuparã: “Jãã Pacʉ Dios, mʉ roque caroʉ́ mʉ ãniña,” qũĩ basapeoyuparã. Nipetirije na caĩñaatajere, bairi na catʉ̃goataje cʉ̃ãrẽ tʉ̃goñarĩ bairo qũĩ basapeoyuparã. “Ángel marĩrẽ cʉ̃ caquetibʉjʉatatore bairo baiapʉ,” ĩñuparã oveja cacoteri majã, tunu áná yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bairo na caátó bero, jĩcã wãmo peti itia pẽnirõ cãnacã rʉ̃mʉrĩ canetõrõ, cʉ̃ãcãrẽ cʉ̃ rupaʉ macããtõrẽ yiseta rotiyuparã cʉ̃ pacʉa pʉame. Bairo áti yaparorã, “Jesús” cʉ̃ wãmetiyuparã. María bairirupaʉ cõ caãniparo jʉ̃goye ángel cʉ̃ cawãmeti rotiricarorea bairo cʉ̃ wãmetiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cabero nocãnacã rʉ̃mʉ María cõ cacatipetiro bero, Jesús pacʉa ásúparã Jerusalẽpʉ, Moisés ãnacʉ̃ cʉ̃ caroticũrĩcãrõrẽ bairo átiráná. “Merẽ ñucoayamo María,” to templo wii macããnarẽ na ĩ quetibʉjʉgarã ásúparã. Bairo áná, Jesuacarẽ cʉ̃ neásúparã, Diore qũĩñogarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tore bairo camasãrẽ na átirotiyupa. Dios yaye woaturica tutipʉ bairo ĩ quetibʉjʉyupa: “Mʉjãã pũnaa tocãnacãʉ̃ caʉ̃mʉa cabuiajʉ̃gorãrẽ yʉre mʉjãã ĩñogarã,” ĩ quetibʉjʉyupa Dios yaye woaturica tutipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tunu bairoa ape wãme Dios yaye cʉ̃ caroticũrĩqũẽrẽ bairo átiráná baiyuparã. Bairi buare pʉgarã, o buaaca cawĩmarã majũrẽ Diore ĩroari joemʉgõjoráná baiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bairo áná, Dios ya wii, templo wiipʉre etayuparã. Mai, tiwoatore ti macã Jerusalẽpʉre Dios yaʉ jĩcãʉ̃ Simeón cawãmecʉcʉ ãñupʉ̃. Diore caroaro caĩroaʉ, carorije wapa cacʉ̃goecʉ ãñupʉ̃. Bairo ãcʉ̃, Israel yepa macããnarẽ canetõõpaʉ cʉ̃ caetaparore ĩñagayupʉ. Tunu bairoa Espíritu Santo, Dios Yeri majũ Simeón mena ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bairo cʉ̃ mena cʉ̃ caãnoi, cʉ̃ masĩõñupʉ̃ cʉ̃ cariaparo jʉ̃goye Mesías, marĩ Quetiupaʉ Dios cʉ̃ cajoʉre cʉ̃ caĩñapeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bairo ti rʉ̃mʉ, Joséjãã templo wiipʉre na caetari rʉ̃mʉ, Espíritu Santo cʉ̃ camasĩrĩjẽ jʉ̃gori Simeórẽ cʉ̃ joyupʉ ti wiipʉ. Bairo ti wiipʉ cʉ̃ caãno, Jesús pacʉa pʉame ti wiire jããñuparã na cʉ̃ã, Moisés ãnacʉ̃ cʉ̃ carotiricarore bairo átiráná. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bairo na cajããtõ ĩña, Simeón pʉame natʉ atí, Jesuacarẽ ʉseanirĩ cʉ̃ neñupʉ̃. Bairo cʉ̃ ne yua, atore bairo Diore qũĩ basapeoyupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Yʉ Quetiupaʉ Dios, yʉre mʉ caĩrĩcãrõrẽ bairo ãmerẽ baiya. Ãniacarẽ mʉ cajoʉre ñiñaña. Camasãrẽ canetõõpaʉ majũrẽ ñiñaña. Bairi ʉseanirĩqũẽ mena yʉ riacoagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Cʉ̃ã niñami nipetiro camasãrẽ canetõõpaʉ mʉ cacũjʉ̃goyetiricʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cabusuatípaʉ caetaro, camasã ĩñamasĩñama. Tore bairo ãniaca bʉtiácʉ́pʉ cʉ̃ caquetibʉjʉro, judío majã caãmerã cʉ̃ã masĩgarãma. Tunu jããrẽ, mʉ yarã Israel yepa macããna cʉ̃ãrẽ jãã ĩroagarãma, camasãrẽ canetõõpaʉ jãã ya poa macããcʉ̃ jĩcãʉ̃ cʉ̃ caãno jʉ̃gori yua,” qũĩ basapeoyupʉ Simeón Diore. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bairo cʉ̃ caĩrõ tʉ̃gorã, José, bairi María bʉtioro tʉ̃goñañuparã, Simeón na macʉ̃ãcãrẽ cʉ̃ caĩrĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Bairo na catʉ̃goñarõ, Simeón pʉame atore bairo na ĩñupʉ̃: “Marĩ Pacʉ Dios caroare cʉ̃ jonemoáto mʉjããrẽ,” na ĩñupʉ̃. Bairo na ĩ yaparoʉ, tunu cõ ĩñupʉ̃ Simeón Maríare: —Yʉ yao, tʉ̃goya. Mʉ macʉ̃ãcã pʉame caroaro cariape Israel yepa macããnarẽ caquetibʉjʉpaʉ Dios cʉ̃ cacũjʉ̃goyetiricʉ niñami. Bairo bʉtiácʉ́, cʉ̃ caquetibʉjʉroi, Israel yepa macããna jĩcããrã netõgarãma. Aperã yasicoagarãma. Nipetiro camasã na yeripʉ na catʉ̃goñarĩjẽ pʉame baujaro na ĩñamasĩõ joroque átigʉmi, cʉ̃ caquetibʉjʉrije jʉ̃gori. Torena, jĩcããrã mʉ macʉ̃rẽ cʉ̃ tejãñugarãma. Mʉ pʉame tiere na cateero ĩñao, bʉtioro mʉ yapapuajãñugo —cõ ĩñupʉ̃ Simeón Maríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mai, ti wiipʉ ãñupõ Ana cawãmecʉco cʉ̃ã. Fanuel ãnacʉ̃ macõ, Aser ãnacʉ̃ ya poa macããcõ majũ ãñupõ. Cõ pʉame profeta ãñupõ. Bairi jĩcãõã ãninucũñupõ Ana. Mai, cawãmao ãcõ, manapʉcʉsupo. Jĩcã wãmo peti pʉga pẽnirõ cãnacã cʉ̃marĩ majũ cõ manapʉ mena ãnimiñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bairo cõ manapʉ cʉ̃ cariaro bero yua, jĩcãõã ãninucũñupõ. Apei boesupo. Bairo bairi templo wiipʉre ãninucũñupõ Ana. Topʉre ãcõ, Diore cʉ̃ jẽninucũñupõ. Ʉmʉrecóo, ñami cʉ̃ãrẽ cʉ̃ jẽninucũñupõ. Ʉgarique betiri Diore cʉ̃ jẽni ñubuenucũñupõ. Bairo áti ãcõ yua, cabʉcʉo ãñupõ. Ochenta y cuatro cʉ̃marĩ majũ cʉ̃goyupo. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bairo bai yua, Simeón Maríare cʉ̃ caquetibʉjʉ yaparoripaʉa cõ cʉ̃ã natʉ etayupo. Bairo etanʉcã, cʉ̃ãcãrẽ qũĩñarĩ, “Dios mʉ ñujãñuña jãã mena,” qũĩñupõ. Bairo ĩ yaparo, narẽ canetõõpaʉre cacoteri majãrẽ atore bairo na ĩ quetibʉjʉyupo: “Ʉseanirĩ ãña yʉ yarã Jerusalén macããna. Merẽ etayami marĩrẽ canetõõpaʉ,” na ĩ quetibʉjʉyupo. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cabero, Joséjãã Dios cʉ̃ carotiricarore bairo átipeyori bero, tunucoásúparã Galilea yepapʉ Nazaret macã, na ya macã majũpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","To bero Jesús pʉame caroaro tutuaʉ bʉtiyupʉ. Bairi tunu caroaro tʉ̃goñamasĩcoasupʉ. Torecʉ, Dios caroare cʉ̃ joyupʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tunu tocãnacã cʉ̃ma Jesús pacʉjãã Jerusalẽpʉ ánucũñuparã, Pascua bose rʉ̃mʉrĩrẽ ĩñaráná. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bairi Jesús pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã cʉ̃marĩ cacʉ̃goʉ cʉ̃ caãno ásúparã Jerusalẽpʉ. Na cabainucũrĩcãrõrẽ bairo baiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bairo topʉ eta, ãni, pascua bose rʉ̃mʉrĩ bero yua, tunuásúparã na ya paʉpʉ. Jesús pʉame Jerusalẽpʉ̃ã tuayupʉ. Cʉ̃ pacʉa pʉame masĩẽsuparã cʉ̃ catuarijere. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bairo áná, Jesure qũĩñaetimirãcʉ̃ã, “Marĩ mena macããna mena ãcʉ̃mi,” ĩ tʉ̃goñañuparã. “Marĩ berore ʉsaʉmi,” qũĩ tʉ̃goñañuparã Jesure ti rʉ̃mʉ, na caájʉ̃gori rʉ̃mʉrẽ. Cabero qũĩñaetiri yua, cʉ̃ macãjʉ̃goyuparã. “¿Jãã macʉ̃rẽ mʉjãã ĩñaetiati?” ĩ jẽniñañuparã. Na yarã, na bapa cʉ̃ãrẽ na ĩ jẽniñamiñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bairo cʉ̃ bócaetimirã yua, tunucoásúparã Jerusalẽpʉ, cʉ̃ macãráná. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bairo ti macãpʉ etarã, itia rʉ̃mʉ bero cʉ̃ bócayuparã Dios ya wii templo wiipʉ. Mai, Jesús pʉame to macããna cajʉ̃goñubueri majã mena ruiyupʉ. Na caquetibʉjʉrijere tʉ̃goʉ baiyupʉ. Tunu bairoa narẽ, “¿Dope bairo ĩgaro to ĩñati tie?” na ĩ jẽniñanucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bairi nipetiro camasã cʉ̃ caĩmasĩrĩjẽrẽ tʉ̃gorã, narẽ cʉ̃ cayʉrije cʉ̃ãrẽ tʉ̃gorã, cʉ̃ tʉ̃gocõã maniásuparã. “Cawĩmaʉ nimicʉ̃ã, masĩjãñuñami,” ĩñuparã na pʉame, Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bairi yua, cʉ̃ pacʉa topʉ cʉ̃ bócayuparã. Cʉ̃ bóca, qũĩña acʉacoasuparã. Cʉ̃ paco pʉame atore bairo qũĩñupõ: —Macʉ̃, ¿nopẽĩ jããrẽ, bairo mʉ baiyati? Yʉ, mʉ pacʉ mena mʉrẽ yoaro jãã macãmiapʉ̃. Bairi jãã tʉ̃goñarĩqũẽ paiapʉ —qũĩñupõ María Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Bairo cõ caĩrõ tʉ̃go, cõ ĩñupʉ̃: —¿Nopẽĩrã yʉre mʉjãã macãati? Yʉ Pacʉ yʉre cʉ̃ carotirijere yʉ caátigaro, ¿mʉjãã masĩẽtĩati? —cõ ĩñupʉ̃ Jesús Maríare. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bairo cʉ̃ caĩrĩjẽrẽ tʉ̃gomasĩẽsuparã cʉ̃ pacʉa pʉame. “¿Dope bairo ĩgʉ qũĩñati marĩ macʉ̃?” ĩcõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Cabero yua, na mena tunucoásúpʉ Jesús Nazaret macãpʉ. Bairo topʉ eta, ãcʉ̃ yua, cʉ̃ pacʉa na caĩrõrẽ bairo caroaro yʉyupʉ. Mai, cʉ̃ paco pʉame cʉ̃ caátiãnierẽ caroaro tʉ̃goña qũẽnocõã ãninucũñupõ cõ yeripʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús pʉame cʉ̃ catʉ̃goñarĩjẽ, cʉ̃ rupaʉ mena bʉticõã ʉsaásupʉ. Bairi Dios pʉame cʉ̃ caátiãnierẽ caroaro qũĩñajesoyupʉ. Camasã cʉ̃ã caroaro qũĩñajesoyuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Cabero yua, nocãnacã rʉ̃mʉrĩ bero, Juan ãnacʉ̃ desierto cayucʉmanopʉ ãninucũñupʉ̃, Zacarías ãnacʉ̃ macʉ̃ majũ. Mai, tiwatoa Tiberio cawãmecʉcʉ nipetiro yepa quetiupaʉ ãñupʉ̃. Merẽ wãmorĩ peti jĩcã rʉpo pẽnirõ cãnacã cʉ̃marĩ majũ quetiupaʉ ãñupʉ̃ Tiberio. Apei, Poncio Pilato cawãmecʉcʉ Judea yepa macããnarẽ cʉ̃rẽ carotibojaʉ ãñupʉ̃. Apei cʉ̃ã Herodes cawãmecʉcʉ Galilea yepa macããnarẽ cʉ̃rẽ carotibojaʉ ãñupʉ̃. Apei, Herodes bai cʉ̃ã, Felipe cawãmecʉcʉ Iturea, Traconite pʉga yepa macããnarẽ cʉ̃rẽ carotibojaʉ ãñupʉ̃. Apei cʉ̃ã Lisania cawãmecʉcʉ Abilinia yepa macããnarẽ cʉ̃ rotibojayupʉ cʉ̃ cʉ̃ã Tiberiore. Tunu bairoa Anás, Caifás cawãmecʉna sacerdote majã quetiuparã majũ ãñuparã na cʉ̃ã. Tiwatoa majũ Dios Juarẽ cʉ̃ quetibʉjʉ áñesẽãrotiyupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bairo cʉ̃ caĩrõ tʉ̃go, topʉ ásúpʉ Juan, Rio Jordán na caĩrĩ yaa tʉ̃nipʉ. To macããnarẽ atore bairo na ĩ quetibʉjʉyupʉ: “Tʉ̃goña qũẽnoña roro mʉjãã caátiãnierẽ. Tie mʉjãã cabairijere cʉ̃ tʉ̃goña jẽniña mʉjãã majũ Diore. Tunu bairoa cabautizarotiparã mʉjãã ãniña. Bairo mʉjãã caáto, mʉjãã netõgʉmi Dios,” na ĩñupʉ̃ Juan to macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Atore bairo ĩ woatu quetibʉjʉcũñañupĩ Isaías ãnacʉ̃, Dios yaʉ profeta Juan cʉ̃ cabaipeere: “Bairo ĩgʉmi jĩcãʉ̃ desierto cayucʉmanopʉ caãnicõãniatacʉ: ‘Marĩ Quetiupaʉ yoaro mee etagʉmi. Torena, caroaro cariape ãnicoteya. Camasã na quetiupaʉ cʉ̃ caetaparo jʉ̃goye cʉ̃ caatípawãrẽ na caqũẽnorõrẽ bairo cʉ̃ qũẽnoyuya mʉjãã cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Na pʉame na quetiupaʉ cʉ̃ caatípawãpʉre ope to caãmata, ñerĩ mena tore cũbiayama. Tunu bairoa ʉ̃tã buri to caãmata, yesea qũẽnoñama. Tunu bairoa carupa betori cʉ̃ã to caãmata, cariape qũẽno ãmewiyoyama ti wããrẽ. Caroa wãã majũ qũẽnoñama cʉ̃ caatípawãrẽ. Tore bairo mʉjãã cʉ̃ã marĩ Quetiupaʉ cʉ̃ caetaparore caroaro qũẽnoyuya mʉjãã yeripʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bairo nipetiro camasã narẽ Dios cʉ̃ canetõõroticũrĩcʉ̃rẽ qũĩñagarãma,’ ĩgʉmi cayucʉmanopʉ caãnicõãniatacʉ,” ĩ woatu quetibʉjʉ jʉ̃goyeticũñupĩ Isaías ãnacʉ̃ Juan cʉ̃ caĩquetibʉjʉpeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bairo Isaías cʉ̃ caĩwoatuquetibʉjʉro bero, cayoato bero Juan pʉame etayupʉ. Bairo cʉ̃rẽ cabautiza rotiratíatanarẽ atore bairo na ĩ quetibʉjʉyupʉ: “¡Mʉjãã caĩtopairã, ãña pũnaarẽ bairo caãna mʉjãã caãnoi, mʉjãã yʉ bautizaecʉ! Atore bairo mʉjãã ĩ tʉ̃goñarã: ‘Dios camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉrẽ popiye marĩ cabaibujioatajere oco mena marĩ cosenetõbujioʉmi,’ mʉjãã ĩ tʉ̃goñarã. ¿Ñamʉ mʉjãã cʉ̃ quetibʉjʉyati, ‘Tie mena jãã netõgarã,’ mʉjãã caĩrĩjẽrẽ? Bairo pʉame mʉjãã caátiãnierẽ boya: ");
INSERT INTO cbcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rorije mʉjãã caátiere yapapuari caroaro ãnajẽ pʉame átijʉ̃goya. Bairo mʉjãã caáto, camasã nipetiro ĩñarã, ‘Torena, na yerire merẽ wasoa yaparoupa,’ ĩ masĩgarãma. Tunu bairoa, ‘¡Marĩã, Abraham ãnacʉ̃ pãrãmerã marĩ caãnoi, marĩ netõõgʉmi Dios!’ ĩ tʉ̃goñaeticõãña. Bairo mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, dope bairo átinetõmasĩã maniña. Dope bairo Dios boʉ, atie ʉ̃tã rupaa mena Abraham pãrãmerãrẽ bairo átiqũẽno jẽñomasĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bairi caroaro mʉjãã caápericõãta, jĩcãʉ̃ yucʉ, caríca maniirẽ quetíjoerocacõãrĩcãrõrẽ bairo mʉjãã átirecõãgʉmi Dios mʉjãã cʉ̃ãrẽ. Petoaca rʉsaya mʉjããrẽ Dios cʉ̃ caĩñabesepa rʉ̃mʉ,” na ĩ quetibʉjʉyupʉ Juan cʉ̃rẽ cabautiza rotiratíatanarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ jẽniñañuparã to macããna capããrã: —Tame, toroque, ¿ñerẽ jãã átibujiocʉti? ");
INSERT INTO cbcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bairo na caĩjẽniñarõ tʉ̃go, Juan pʉame atore bairo na ĩñupʉ̃: —Nii ũcʉ̃ jutiro pʉgaro cacʉ̃goʉ, apei cacʉ̃goecʉre jĩcãrõ cʉ̃ nuniáto. Tunu bairoa ʉgarique cacʉ̃goʉ, apei cacʉ̃goecʉre cʉ̃ batoáto —na ĩ quetibʉjʉyupʉ Juan catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na watoa etayuparã jĩcããrã dinerore jejobojari majã. Roma gobiernorẽ camasã yaye dinerore impuestos cawãmecʉtiere jejobojari majã etayuparã, cʉ̃ bautiza rotirána Juarẽ. Na cʉ̃ã qũĩ jẽniñañuparã: —Cabuei, ¿dope jãã caátore cʉ̃ boyati Dios? ");
INSERT INTO cbcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩ quetibʉjʉyupʉ: —Mʉjãã quetiuparã na carotiricaro jĩcãrõ tʉ̃ni jeya. Tie netõrõ jeeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Cabero tunu soldaua cʉ̃ã cʉ̃ eta, qũĩ jẽniñañuparã: —Jãã ate, ¿ñerẽ jãã caátiere cʉ̃ boyati Dios? Bairo na caĩjẽniñarõ tʉ̃go, na cʉ̃ãrẽ na ĩ quetibʉjʉyupʉ: —Tutuaro mena camasãrẽ na ẽmaeticõãña. Tunu na bʉsʉjãẽtĩcõãña caáperãrẽ, marĩrẽ na wapatiáto, ĩrã. Tunu mʉjãã capaapee wapare mʉjãã quetiuparã na cajorijerea tocãrõã ʉseanicõãña. Bonemoeticõãña —na ĩ quetibʉjʉyupʉ Juan soldauare. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Camasã pʉame Juan cʉ̃ caquetibʉjʉrije jʉ̃gori bʉtioro tʉ̃goñañuparã. Bairi nipetiro camasã na yeripʉ atore bairo ĩ tʉ̃goñañuparã: “¿Ãni, Juan, Mesías, Dios cʉ̃ cajoʉ majũ cʉ̃ ãnicʉti?” ãmeo ĩ tʉ̃goñañuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bairo na caĩtʉ̃goñarõ, Juan pʉame atore bairo na ĩ quetibʉjʉyupʉ: “Yʉ paarique niña mʉjããrẽ oco mena yʉ cabautizarije. Yʉ paarique to cañumiatacʉ̃ãrẽ, yʉ bero caetaʉ cʉ̃ capaarije pʉame ñunetõgaro. Cʉ̃ roque Espíritu Santore jõmasĩgʉmi camasãpʉre. Tunu bairoa camasã roro na catʉ̃goñarĩjẽ na wasoao joroque na átigʉmi. Cʉ̃ roque yʉ netõrõ caãnimajũʉ̃ nigʉmi. Bairi yʉ pʉame jĩcãrõ tʉ̃ni yʉ átipeyomasĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yʉ bero caetapaʉ pʉame marĩ ĩñabesegʉmi. Bairo carorãrẽ na beseregʉmi. Trigo aseri carorijere joerocacõãrĩcãrõrẽ bairo camasã carorãrẽ na beseregʉmi. Caʉ̃petieti peeropʉ na joeregʉmi. Caroarã roquere caroaro na qũẽnogʉmi. Trigo caroa majũrẽ caroaro na caqũẽnocũrõrẽ bairo caroaro na qũẽnogʉmi caetapaʉ cʉ̃ yarã majũrẽ,” na ĩ quetibʉjʉyupʉ Juan catʉ̃gorã etarãrẽ Jesús cʉ̃ caátipeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bairo yua, atore bairo capee wãme, camasãrẽ na quetibʉjʉyupʉ Juan caroa queti majũrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bairo caroaro cʉ̃ caquetibʉjʉmiatacʉ̃ãrẽ, quetiupaʉ gobernador Herodes cawãmecʉcʉ pʉame Juan cʉ̃ caĩrĩjẽrẽ tʉ̃goʉsaesupʉ. Mai, Herodes bai Felipe nʉmorẽ cõ ẽmañupʉ̃. Herodías cawãmecʉco mena ãninucũñupʉ̃. Tore bairo apeye ũnie cʉ̃ãrẽ roro majũ ásupʉ Herodes. Bairo bairi roro cʉ̃ caátiere cʉ̃ quetibʉjʉmiñupʉ̃ Juan Herodere. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cabero Herodes pʉame cʉ̃ caĩrõ tʉ̃go, nemorõ roro ásupʉ. Juarẽ preso jorica wiipʉ cʉ̃ jorocacõãñupʉ̃ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mai, Juan pʉame to macããna nipetirãrẽ oco mena na bautizayupʉ. Bairo cʉ̃ caáto watoa, Jesús cʉ̃ãrẽ cʉ̃ bautizayupʉ. Bairo Jesús cʉ̃ cajẽnirĩpaʉa yua, jõbui ʉmʉrecóo pʉame pããnʉcãcoasuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bairo capãrõ yua, buare bairo ruiasúpʉ Espíritu Santo, Dios Yeri majũ, Jesús tʉpʉ. Bairo cʉ̃ cabauruiató, jõbuipʉ bʉsʉrique atore bairo ĩ ocajoyuparo: —Mʉ, yʉ macʉ̃, yʉ camai majũ, mʉ ãniña. Mʉ caátiãnierẽ ñiñajesoya bʉtioro —ĩ bʉsʉ ocajoyuparo jõbuipʉ bʉsʉrique. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bairi yua, Jesús camasãrẽ cʉ̃ caquetibʉjʉjʉ̃goripaʉ treinta años majũ cʉ̃goyupʉ. Mai, Dios macʉ̃ cʉ̃ caãnimiatacʉ̃ãrẽ, “Cʉ̃ pacʉ José niñami,” qũĩ tʉ̃goñañuparã camasã Jesure. José pʉame Elí cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí pʉame Matat cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Matat pʉame Leví cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Leví pʉame Melqui cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Melqui pʉame Jana cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Jana pʉame José cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José pʉame Matatías cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Matatías pʉame Amós cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Amós pʉame Nahúm cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Nahúm pʉame Esli cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Esli pʉame Nagai cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pʉame Maat cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Maat pʉame Matatías cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Matatías pʉame Semei cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Semei pʉame Josec cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Josec pʉame Judá cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá pʉame Joanán cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Joanán pʉame Resa cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Resa pʉame Zorobabel cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Zorobabel pʉame Salatiel cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Salatiel pʉame Neri cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pʉame Melqui cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Melqui pʉame Adi cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Adi pʉame Cosam cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Cosam pʉame Elmadam cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Elmadam pʉame Er cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pʉame Jesús cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Jesús pʉame Eliezer cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Eliezer pʉame Jorim cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Jorim pʉame Matat cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat pʉame Leví cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Leví pʉame Simeón cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Simeón pʉame Judá cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Judá pʉame José cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. José pʉame Jonám cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Jonám pʉame Eliaquim cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim pʉame Melea cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Melea pʉame Mena cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Mena pʉame Matata cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Matata pʉame Natán cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán pʉame David cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. David pʉame Isaí cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Isaí pʉame Obed cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Obed pʉame Booz cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Booz pʉame Sala cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Sala pʉame Naasón cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón pʉame Aminadab cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Aminadab pʉame Admin cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Admin pʉame Arni cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Arni pʉame Esrom cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Esrom pʉame Fares cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Fares pʉame Judá cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá pʉame Jacob cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Jacob pʉame Isaac cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Isaac pʉame Abraham cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Abraham pʉame Taré cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Taré pʉame Nacor cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor pʉame Serug cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Serug pʉame Ragau cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Ragau pʉame Peleg cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Peleg pʉame Heber cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Heber pʉame Sala cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala pʉame Cainán cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Cainán pʉame Arfaxad cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Arfaxad pʉame Sem cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Sem pʉame Noé cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Noé pʉame Lamec cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec pʉame Matusalén cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Matusalén pʉame Enoc cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Enoc pʉame Jared cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Jared pʉame Mahalaleel cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Mahalaleel pʉame Cainán cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán pʉame Enós cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Enós pʉame Set cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Set pʉame Adán cawãmecʉcʉ ãnacʉ̃ macʉ̃ ãñupʉ̃. Adán pʉame Dios cʉ̃ caqũẽnojʉ̃goricʉ ãnirĩ cʉ̃ macʉ̃rẽ bairo caãcʉ̃ ãñupʉ̃ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bairo Juan Jesure cʉ̃ cabautizaro bero, Jesús pʉame Espíritu Santo, Dios Yeri cʉ̃ camasĩõrĩjẽ carʉsaecʉ majũ ãnicõãñupʉ̃. Bairo cʉ̃ caãno yua, Jesure, Rio Jordán caãniatacʉre cʉ̃ jʉ̃goásúpʉ desierto cayucʉmanopʉ Espíritu Santo pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Bairi desierto cayucʉmanopʉ cuarenta rʉ̃mʉrĩ majũ ãñupʉ̃. Bairo topʉ cʉ̃ caãno yua, wãtĩ pʉame rorije cʉ̃ átirotimiñupʉ̃ Jesure, “Cariape cʉ̃ átinucũñati,” ĩ. Tunu topʉ ãcʉ̃, ñe ũnie ʉgaesupʉ Jesús. Bairi cuarenta rʉ̃mʉrĩ bero yua, queyarique tʉ̃goñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mai, wãtĩ pʉame atore bairo cʉ̃ átirotimiñupʉ̃ Jesure: —Mʉ, Dios macʉ̃ mʉ ãniña. Bairo cariapea Dios macʉ̃ caãcʉ̃ ãnirĩ, atia ʉ̃tãrẽ pan qũẽnorĩ ʉgaya —qũĩñupʉ̃ wãtĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo pʉame qũĩcõãñupʉ̃ Jesús: —Mʉ caĩrõrẽ bairo yʉ áperigʉ. Dios yaye quetire na cawoaturica tutipʉ ricaati yʉ átirotietiya. Bairo ĩña ti tuti: ‘Ʉgarique marĩ caʉganucũrõ jeto boetiyami Dios. Nipetirije cʉ̃ yaye quetibʉjʉriquere marĩ catʉ̃goñarĩjẽ cʉ̃ãrẽ boyami,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ Jesús wãtĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bairo cʉ̃ caĩrõ bero, wãtĩ pʉame Jesure ʉ̃tãʉ̃ buipʉ cʉ̃ neásúpʉ. Topʉ etari yua, qũĩñoñupʉ̃ ati yepa macããna tocãnacãʉ̃pʉa macããna quetiuparã na carotimasĩrĩpaʉrire. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Bairo qũĩño yaparo, bairo qũĩñupʉ̃ tunu Jesure: —Atie mʉrẽ yʉ caĩñorĩjẽrẽ yʉ cʉ̃goya. Bairi noo yʉ caboʉre cʉ̃ yʉ nuninetõmasĩña. Mʉ pʉame mʉ cabooata, tocãnacã macã macããnarẽ carotimasĩrĩjẽrẽ mʉrẽ yʉ nunigʉ. Nipetiro camasã mʉrẽ ĩroagarãma, rʉpopaturi mena etanumurĩ yʉre mʉ caĩroaata. Carotimasĩ mʉ ãnio joroque mʉ yʉ átigʉ. “Jaʉ,” miwã —qũĩñupʉ̃ wãtĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Mʉ caĩrõrẽ bairo yʉ áperigʉ. Dios yaye quetire na cawoaturica tutipʉ ricaati yʉ átirotietiya. Bairo ĩña ti tuti: ‘Jĩcãʉ̃ã niñami marĩ caĩroaʉ, Dios jeto. Cʉ̃ caĩrĩjẽ jetore tʉ̃goya,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ Jesús wãtĩrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bairo cʉ̃ caĩrõ bero, wãtĩ pʉame Jesure cʉ̃ neánemoñupʉ̃. Jerusalén macãpʉ Dios ya wii, templo wii buipʉ cʉ̃ neánemoñupʉ̃. Bairo topʉ eta, qũĩñupʉ̃ wãtĩ Jesure: —Mʉ, Dios macʉ̃ mʉ ãniña. Bairo cariapea Dios macʉ̃ caãcʉ̃ ãnirĩ, mʉ majũ patiñarui ácʉ́ja jõ yepapʉ. Mʉ riaecʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tore bairo ĩ quetibʉjʉya Dios yaye queti: ‘Dios pʉame cʉ̃ yarã ángelea majãrẽ mʉ coterotigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na, ángelea majã, mʉ bocáñegarãma ʉ̃tã rupaapʉ mʉ cañarocapeaetiparore bairo ĩrã,’ ĩ quetibʉjʉya Dios yaye quetire na cawoaturica tutipʉ —qũĩñupʉ̃ wãtĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Bairo mʉ caĩquetibʉjʉrore bairo caĩmiatacʉ̃ãrẽ, mʉ caátirotirore bairo yʉ áperigʉ. Bairo yʉ caáto boetiyami Dios. Ape wãme ape pũrõpʉ atore bairo ĩ quetibʉjʉya: ‘Marĩ Quetiupaʉ Diore cʉ̃ camasĩrĩjẽrẽ átiepecõãrĩ cʉ̃ jẽnieticõãña,’ ĩ quetibʉjʉya Dios yaye queti na cawoaturica tutipʉ —qũĩñupʉ̃ Jesús wãtĩrẽ. Cʉ̃ yuesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bairi wãtĩ pʉame ape wãme roro cʉ̃ átiroti masĩẽsupʉ. Bairo átiroti masĩẽtĩrĩ yua, Jesure cʉ̃ aweyocoásúpʉ mai. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bairo cabero Jesús Galilea yepapʉ Espíritu Santo cʉ̃ camasĩrĩjẽ mena ñe ũnie rʉsaricaro mano tunucoásúpʉ yua. Bairi to macããna nipetiro camasã ti yepa tʉ̃ni macããna pʉame cʉ̃ cabairijere tʉ̃gorã tocãnacãʉ̃pʉa ãmeo quetibʉjʉ netõõñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús pʉame tocãnacãpaʉri na cañubueneñarĩ wiiripʉre camasãrẽ na quetibʉjʉyupʉ. Bairo cʉ̃ caĩquetibʉjʉro, camasã nipetiro qũĩroayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Cabero Nazaret cawãmecʉti macãpʉ etayupʉ tunu Jesús. Cawĩmaʉ ãcʉ̃, cʉ̃ cabʉtirica macãpʉ etayupʉ. Topʉ eta, ti macã macããna na cañubueneñarĩ wiipʉre jããñupʉ̃ yerijãrĩcã rʉ̃mʉ caãno. Bairo jeto átinucũñupʉ̃ Jesús ti rʉ̃mʉ ũnorẽ. Bairi ti wii camasã riapepʉ nucũñupʉ̃, Dios ya tutire jʉ̃goquetibʉjʉgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bairo cʉ̃ cabairo, profeta Isaías ãnacʉ̃ cʉ̃ cawoaturiquere cʉ̃ nuniñuparã. Bairo cʉ̃ na canunirõ, ti pũrõ macããjẽ quetibʉjʉrique jĩcã wãmerẽ bócayupʉ. Atore bairo caĩrĩpaʉre bócayupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—“Espíritu Santo yʉ mena ãniñami merẽ, Dios yʉre cʉ̃ caroticũrĩcãrõrẽ bairo yʉ caátiparore bairo ĩ. Yʉ mena ãniñami, cabopacarãrẽ caroa quetire na yʉ caquetibʉjʉparore bairo. Yʉ jowĩ Dios, camasãrẽ cʉ̃ caqũẽnoparore bairo na yʉ caquetibʉjʉparore bairo ĩ. Jĩcããrã preso cañe ecoricarãrẽ bairo caãna niñama. Aperã cacaapee ĩñaenarẽ bairo niñama. Aperã wãtĩrẽ roro caátiecorãrẽ bairo caãna niñama. Na ũnarẽ yʉ caqũẽnoparore bairo ĩ, yʉ jowĩ Dios. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Camasãrẽ Dios cʉ̃ canetõrĩ yʉtea caetarore yʉ quetibʉjʉ rotijowĩ yua,” ĩña ati pũrõ —na ĩ quetibʉjʉyupʉ Jesús cʉ̃rẽ catʉ̃gori majã, sinagoga wii macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bairo ti pũrõrẽ ĩñayaparo, ti tutire biayupʉ. Bairo áti yua, ti wii papera tutirire cacoteire cʉ̃ pitinuniñupʉ̃. Pitinuni, etanumucoasupʉ Jesús. Bairo cʉ̃ caáto, nipetiro camasã qũĩñacõã ʉsayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bairo cʉ̃rẽ na caĩñaʉsaro, atore bairo na ĩñupʉ̃ Jesús: —Isaías ãnacʉ̃ cʉ̃ caĩquetibʉjʉ woaturicʉa yʉ ãniña. Ãmerẽ cʉ̃ caĩquetibʉjʉricarore bairo baietaya —na ĩñupʉ̃ Jesús ti wii macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bairo cʉ̃ caĩrõ tʉ̃gorã, cʉ̃ caĩrĩjẽrẽ tʉ̃go acʉacoasuparã. Atore bairo ĩñuparã: —Ago tame, ãni, caroaro jĩcãrõ tʉ̃ni bʉsʉyami. ¿José macʉ̃ mee cʉ̃ ãniñati? Bairo cʉ̃ã nimicʉ̃ã, ¿caroaro cʉ̃ masĩñati? —ãmeo ĩ bʉsʉyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Cabero Jesús pʉame na ĩñupʉ̃ tunu: —Ati yepa macããna apei narẽ cʉ̃ cacatiorore borã, cʉ̃ na caĩnucũrõrẽ bairo mʉjãã cʉ̃ã yʉ mʉjãã ĩ tʉ̃goñarã: “Mʉ, ʉcotiri majõcʉ, mʉ majũã ʉcoti catioya. Bairi Capernaupʉre ãcʉ̃, mʉ caátijẽñorĩqũẽrẽ bairo atore, mʉ ya macãpʉ cʉ̃ãrẽ mʉ átigʉ, Dios cʉ̃ cajoʉ mʉ caãmata,” yʉre mʉjãã ĩ tʉ̃goñarã —na ĩ quetibʉjʉyupʉ Jesús ti wii macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ĩ quetibʉjʉ yaparo, bairo na ĩñupʉ̃ tunu: —Cariape mʉjããrẽ ñiña: Ni ũcʉ̃ Dios yaʉ profetare cʉ̃ ya macã macããna cʉ̃ boenama. Noa majũ qũĩroaenama. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tunu bairoa marĩ ñicʉ̃ profeta Elías ãnacʉ̃, cʉ̃ caãni yʉteapʉ cawapearã rõmirĩ capããrã ãñuparã. Ati yepa Israel yepapʉre itia cʉ̃ma ape cʉ̃ma recomacã caoco ocaeti yʉteare capããrã ãñuparã. Tunu ti yʉteare bʉtioro aʉariarique ãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bairo capããrã na ũna na caãnimiatacʉ̃ãrẽ, cawapearã rõmirĩ jĩcãõã na mena macããcõ jetore cʉ̃ jʉátinemo rotiyupʉ Dios Elíare. Sarepta cawãmecʉcore ape yepapʉ Sidón macããcõrẽ cõ jʉátinemo rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tunu bairoa profeta apei Eliseo cawãmecʉcʉ ãnacʉ̃ cʉ̃ caãni yʉtea carupaʉ boarã capããrã ãñuparã ati yepapʉre. Bairo capããrã na ũna na caãnimiatacʉ̃ãrẽ, jĩcãʉ̃ã na mena macããcʉ̃ jetore cʉ̃ catiorotiyupʉ Dios Eliseore. Naamán cawãmecʉcʉre, ape yepa, Siria yepa macããcʉ̃rẽ cʉ̃ catiorotiyupʉ —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ ya macã macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃gorã, ñubuerica wii macããna pʉame bʉtioro asiajãñuñuparã Jesús mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bairo cʉ̃ mena asia yua, cʉ̃ ñe, ti macã jʉ̃goye ʉ̃tãʉ̃ buipʉ cʉ̃ neásúparã. Bairo topʉ etarã, cʉ̃ tuneroca ñojogamiñuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bairo na caátigamiatacʉ̃ãrẽ, Jesús pʉame na watoapʉ, cʉ̃ jãã ĩ masĩã mano, na netõ acoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cabero Galilea yepapʉ Capernaum cawãmecʉti macãpʉ acoásúpʉ Jesús. Topʉ eta, yerijãrĩcã rʉ̃mʉ caãno na jʉ̃gobueyupʉ camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Carotimasĩ cʉ̃ caĩquetibʉjʉrore bairo na quetibʉjʉyupʉ. Bairo cʉ̃ caquetibʉjʉrijere tʉ̃gorã, to macããna pʉame tʉ̃go acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mai, ti wii sinagoga ñubuerica wiipʉ ãñupʉ̃ jĩcãʉ̃ wãtĩ yeri pũna cacʉ̃goʉ. Bairo Jesús cʉ̃ cabueãno, wãtĩ yeri pũna cacʉ̃goʉ pʉame atore bairo bʉtioro qũĩ awajayupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Mʉ, Jesús Nazaret macããcʉ̃, ¿nopẽĩ mʉ atíati jãã tʉre? ¿Jããrẽ rei acʉ́ mʉ baiyati? Mʉrẽ jãã masĩjãñuña. Mʉ, Dios macʉ̃, cañuʉ, mʉ ãniña —qũĩ awajayuparã wãtĩ yeri pũna, caʉ̃mʉ risero mena jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bairo na caĩrõ tʉ̃go, na ĩñupʉ̃ Jesús: —¡Bʉsʉeticõãña mʉjãã! ¡Ãni caʉ̃mʉ rupaʉre witi ánája! —na ĩñupʉ̃ Jesús wãtĩãrẽ. Bairo cʉ̃ caĩrõ tʉ̃go, wãtĩ yeri pũna pʉame caʉ̃mʉrẽ cʉ̃ jʉ̃goñañupʉ̃ yepapʉ, cʉ̃rẽ caĩñarĩ majã watoare. Bairo áticõã, roro cʉ̃ átiri mee witicoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bairo caʉ̃mʉrẽ cʉ̃ caátiere ĩñarã, nipetiro camasã qũĩña acʉacoasuparã. —¿Ñe to ãniñati cawãma Jesús cʉ̃ carotirije? ¡Nocãrõ caroaro majũ cʉ̃ masĩñati! Wãtĩ yeri pũna cʉ̃ã cʉ̃ yʉcõãñama. “Witi ánája,” cʉ̃ caĩrõ, witicoayama yua —ãmeo ĩñuparã na majũ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bairo cʉ̃ caáto bero, cʉ̃ tʉ̃goyuparã camasã nipetiro ti yepa tʉ̃ni macããna, Jesús cʉ̃ caátiere, cʉ̃ camasĩrĩjẽrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bairo na quetibʉjʉ yaparo, na ñubuerica wiire witicoásúpʉ Jesús. Ti wiire witiá, jããcoasupʉ Simón cawãmecʉcʉ ya wiipʉ. Mai, Simón mañicõ pʉame riajãñuñupõ. Bʉtioro bʉgoyupo. Bairo cʉ̃ cajããrõ, cʉ̃ quetibʉjʉyuparã cabʉcʉo cõ cariarijere. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bairo na caĩquetibʉjʉro tʉ̃go, cõtʉ eta, “Bʉgoye tocãrõã jãnaña cõrẽ,” ĩñupʉ̃. Bairo cʉ̃ caĩrõ, jicoquei jãnacoasuparo bʉgoye pʉame. Tocãrõã caticoasupo. Bairo catiácó yua, tocãrõã ʉgarique na qũẽnonuñupõ Jesujããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cabero muipʉ cʉ̃ cajããrĩpaʉ, canaioatípaʉ caãno Simón ya wiipʉre etayuparã nipetiro ti macã macããna. Dise ũnie riaye caãno cãrõ cacʉ̃gorã yarã pʉame na neasúparã Jesús tʉpʉ. Bairo Jesús pʉame na caetaro ĩña, nipetirãrẽ na catioyupʉ. Cʉ̃ wãmorẽ na bui ñigãpeori tocãnacã wãme riaye cacʉ̃gorãrẽ na catioyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tunu bairoa na mena macããna cariarã capããrã wãtĩ yeri pũnarẽ cacʉ̃gorã cʉ̃ãrẽ na netõõñupʉ̃ Jesús. Bairo cʉ̃ caáto, wãtĩ yeri pũna pʉame qũĩ awajayuparã, bairo witi áná: —¡Mʉ roque Dios macʉ̃ mʉ ãniña! —qũĩñuparã. Bairo na caĩmiatacʉ̃ãrẽ, Jesús pʉame na ĩrotiesupʉ. Yʉ, Mesías, Dios cʉ̃ cajoʉ yʉ caãnierẽ na quetibʉjʉeticõãto ĩ, bairo na ĩrotiesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ape rʉ̃mʉ cabusuatípaʉ Jesús wãcã, ti macãrẽ witicoásúpʉ. Bairo ácʉ́ yua, etayupʉ Jesús camasã na camanipaʉpʉ. Bairo topʉ cʉ̃ caãno, ti macã macããna cʉ̃ macãñuparã. Bairo cʉ̃ macãrĩ, cʉ̃ etacoasuparã. Atore bairo qũĩñuparã: —Aperopʉ mʉ ápéwa. Jãã mena mʉ ãnicõãwã —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bairo na caĩrõ tʉ̃go, bairo na ĩñupʉ̃ Jesús: —Ape macãã macããna cʉ̃ãrẽ na yʉ quetibʉjʉgʉ. Caroa quetire, Dios cʉ̃ carotimasĩrĩpaʉ caetarore na yʉ quetibʉjʉ masĩõgʉ. Torecʉna, yʉ jowĩ Dios ati yepapʉre —na ĩñupʉ̃ Jesús ti macã macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cabero cʉ̃ caĩrõrẽ bairo quetibʉjʉ ñesẽãñupʉ̃ Jesús Judea yepapʉre. Ñubuerica wiiri macããnarẽ na quetibʉjʉ ñesẽãñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ape rʉ̃mʉ ʉtabʉcʉra Genesaret cawãmecʉtira tʉ̃nipʉ ãñupʉ̃ Jesús. Topʉ cʉ̃ caãno, camasã pʉame Dios yaye quetire tʉ̃gogarã, cʉ̃tʉ neñañuparã dope baiá masĩã manopʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bairo na cabairo yua, tira tʉ̃nipʉ ĩñajoyupʉ Jesús pʉga cũmuu, capaca turorica cũmuu majũrẽ. Mai, ti cũmuu uparã mañuparã. Na cũmuurẽ maa weyo, paputiropʉ na bapi yucʉre coserã baiyuparã. Wai pajĩãrĩ majã ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bairi Jesús pʉame ti cũmua jĩcãrẽ ájããñupʉ̃ Simón ya cũmua majũrẽ. Bairi Simorẽ jõjãñurĩ tuwiyo rotijoyupʉ. Simón pʉame, “Jaʉ,” ĩ, cʉ̃ tuwiyo joyupʉ. Bairo ti cũmuapʉ jãñarĩ Jesús pʉame petapʉ canucũrĩ majãrẽ caroaro na quetibʉjʉ jʉ̃goyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bairo na quetibʉjʉ yaparori bero, atore bairo qũĩñupʉ̃ Jesús Simorẽ: —Jito, ʉtabʉcʉra recomacãpʉ marĩ átóca. Topʉ etari mʉjãã bapire mʉjãã roca ñuawa. Bairo ána, marĩ wai pajĩãgarã —qũĩñupʉ̃ Jesús Simorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bairo cʉ̃ caĩrõ tʉ̃go, Simón pʉame qũĩñupʉ̃: —Cabuei, ati ñami jãã wai macãmiapʉ. Jãã bocaetiapʉ. Maniãma. Baipʉa, mʉ caĩrõrẽ bairo yʉ átigʉ. Bapire yʉ rocañuagʉ —qũĩñupʉ̃ Simón Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bairo Simojãã na caáto, tocãrõã wai capããrã ti bapire jããñuparã. Bairo jããnetõrã yua, na bapi wori nʉcʉ̃pʉ̃ jããñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bairo capããrã waire ĩña acʉari, na baparãrẽ ape cũmuapʉ caãnarẽ na piijoyuparã. “Jãã jʉátirasá,” na ĩñuparã. Bairo na caetaro yua, waire na jejããñuparã. Pʉga cũmuapʉrea waire na jejããñuparã. Cũmuu pʉame ruacoabujioyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bairo Simón pʉame Jesús cʉ̃ caátimasĩrĩjẽrẽ ĩñarĩ, cʉ̃tʉ rʉpopaturi mena etanumurĩ qũĩroayupʉ. Bairo áticõã, qũĩñupʉ̃ Simón Jesure: —Yʉ Quetiupaʉ, caróʉ yʉ ãniña. Carorije wapa cacʉ̃goʉ majũ yʉ ãniña. ¡Bairi yʉtʉ ãmeina! —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mai, bʉtioro ĩña acʉacoasupʉ Simón, Jesús cʉ̃ caátimasĩrĩjẽrẽ. Tie jʉ̃gori waire capããrã pajĩãñuparã. Bairi Simón, cʉ̃ mena macããna cʉ̃ã ĩña acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bairo cʉ̃ caáto, Jacobo, cʉ̃ bai Juan cʉ̃ã, Zebedeo pũnaa pʉame cʉ̃ã ĩña acʉacoasuparã. Mai, naa, Simón bapa ãñuparã. Jĩcãrõ wai pajĩãnucũñuparã. Bairi Jesús pʉame, Simón bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃: —Simón, uwiecʉa. Caroaro waire cawãsãmasĩ mʉ ãniapʉ, wai na rutieticoáto, ĩ. Ãmerẽ yua, caroaro camasãrẽ caquetibʉjʉ mʉ ãnio joroque mʉ yʉ átigʉ, na yasieticõãto, ĩ —qũĩñupʉ̃ Jesús Simorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bairo cʉ̃ caĩrõ bero, Simojãã petapʉ maarásúparã. Topʉ etarã, na cũmuurẽ, na apeye ũnie cʉ̃ãrẽ toa cũcõã, Jesús mena bapacʉtiracoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cabero Jesús jĩcã macãpʉ cʉ̃ caãno, caʉ̃mʉ jĩcãʉ̃ carupaʉ boaʉ pʉame qũĩñajoyupʉ Jesure. Bairo qũĩñajo yua, cʉ̃tʉ etari rʉpopaturi mena etanumurĩ Jesure qũĩroayupʉ. Bairo qũĩroa, atore bairo qũĩ jẽniñañupʉ̃: —Yʉ Quetiupaʉ, mʉ cabooata, yʉ mʉ netõõgʉ yʉ caboariaye cʉtiere —qũĩ jẽniñañupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, Jesús pʉame cʉ̃ wãmo mena cʉ̃ pãñañupʉ̃. Bairo áticõã, atore bairo qũĩñupʉ̃ Jesús: —Mʉ cacatiro yʉ boya. ¡Bairi mʉ yʉ netõõña! —qũĩñupʉ̃ cariaʉre. Bairo Jesús cʉ̃ caĩrõ, jicoquei caticoasupʉ carupaʉ boamiatacʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bairo cʉ̃ cabairo ĩña, Jesús pʉame cʉ̃ quetibʉjʉ rotiesupʉ aperãrẽ cʉ̃ cabaiatajere. Bairo qũĩñupʉ̃: —Cariape acoácʉ́ja sacerdote tʉpʉ. Qũĩñoña mʉ rupaʉ, mʉ cacatiatajere. Bairo tunu Diore cʉ̃ nuniña mʉ cacatirije wapare. Tore bairo marĩ átirotiyupi Moisés ãnacʉ̃. Bairo mʉ caátiatato bero, nipetiro camasã masĩgarãma mʉ cacatiatajere yua —qũĩñupʉ̃ Jesús carupaʉ boamiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bairo Jesús cʉ̃ caátiatajere camasã na camasĩrõrẽ cʉ̃ caboetimiatacʉ̃ãrẽ, nipetiropʉ queti batapeticoasuparo. Bairi capããrã camasã Jesús tʉpʉ etayuparã. Jĩcããrã cʉ̃ yaye bʉsʉriquere tʉ̃gogarã, bairi aperã na riayere cʉ̃ netõõrotigarã cʉ̃tʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bairo na cabaimiatacʉ̃ãrẽ, Jesús pʉame aperopʉ acoásúpʉ. Ácoa yua, etayupʉ Jesús camasã na camanopʉ. Topʉ Diore cʉ̃ jẽniñupʉ̃ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jĩcã rʉ̃mʉ Jesús camasãrẽ tunu cʉ̃ caquetibʉjʉãno, fariseo majã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena Jesutʉre tʉ̃go ruiyuparã. Mai, na, tocãnacã macã macããna caatíatana ãñuparã. Galilea yepa macããna, bairi Judea yepa macããna, tunu bairi Jerusalén macã macããna caatíatana cʉ̃ã ãñuparã. Bairo na catʉ̃goĩñaruiro, Jesús pʉame cariayecʉnarẽ na catioyupʉ. Dios cʉ̃rẽ cʉ̃ camasĩõrĩjẽ jʉ̃gori bairo na catioyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bairo camasãrẽ cʉ̃ cacatioãno, caʉ̃mʉa Jesutʉ etanemoñuparã tunu cariaʉ, ñicãrĩ cabʉʉricʉ mena. Mai, na canerĩ coro mena cʉ̃ neasúparã ñicãrĩ cabʉʉricʉre. Jesutʉre cʉ̃ cũgamiñuparã, marĩ yaʉre cʉ̃ catioáto, ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bairo cʉ̃tʉ cʉ̃ cũgamirãcʉ̃ã, ti wii pupeapʉ na yaʉre cʉ̃ nejãã masĩẽsuparã, camasã capããrã na cajiraro jʉ̃gori. Bairi wii buipʉ wãmʉcoásúparã ñicãrĩ cabʉʉricʉ mena. Ti wii buipʉ etarã, ope qũẽnorĩ, cʉ̃ pitiruio joyuparã pũʉ̃ rʉpo wẽẽrĩ mena Jesús tʉpʉ ñicãrĩ cabʉʉricʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bairo na caáto ĩña, Jesús pʉame tʉ̃goña masĩñupʉ̃ na catʉ̃goñarĩjẽrẽ. “Yʉ camasĩrĩjẽrẽ cariape tʉ̃goñatutuayama,” na ĩ tʉ̃goñañupʉ̃. Torecʉ, atore bairo qũĩñupʉ̃ Jesús ñicãrĩ cabʉʉricʉre: —Yʉ yaʉ, merẽ mʉ carorije wapare yʉ netõõcõãña —qũĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bairo cʉ̃ caĩrõ, ti wii macããna Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuerã, aperã fariseo majã mena ãmeo ĩ jẽniñañuparã na majũ Jesús cʉ̃ caĩatajere tʉ̃gori, “¿Ñamʉ ũcʉ̃ majũ caʉ̃mʉ cʉ̃ ãniñati, ‘Yʉ yaʉ, merẽ mʉ carorije wapare yʉ netõña,’ caĩã? Dios jeto netõõmasĩñami marĩ carorije wapare. Ãni, Jesús, Diore cʉ̃ netõnʉcãʉ̃ átiyami bairo cʉ̃ caĩrĩjẽ mena,” ãmeo ĩ bʉsʉyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Masĩcõãñupʉ̃ Jesús cʉ̃ yeripʉ na caãmeobʉsʉrijere. Bairi atore bairo na ĩñupʉ̃: —¿Nopẽĩrã yʉ caĩatajere tʉ̃gori, mʉjãã tʉ̃goñarĩqũẽ paiyati? ");
INSERT INTO cbcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","“Mʉ carorije wapare yʉ netõña,” ãnirẽ yʉ caĩata, “Bairo ĩcõãʉ̃ ĩñami,” mʉjãã ĩbujiorã. Bairãpʉa, “Wãmʉnʉcãña,” cʉ̃rẽ yʉ caĩata, to bero cʉ̃ cawãmʉnʉcáto ĩñarã roque, “Bairo ĩcõãʉ̃ mee ĩñami Jesús,” mʉjãã ĩbujiorã. Yʉ, Camasã Jʉ̃gocʉ, ati yepapʉ yʉ carotimasĩrĩjẽrẽ mʉjãã camasĩparore bairo, tiere ñigʉ —na ĩñupʉ̃ Jesús fariseojããrẽ. Ĩ yaparo, cʉ̃ caĩrõrẽ bairo qũĩnemoñupʉ̃ Jesús ñicãrĩ cabʉʉricʉre: —Mʉrẽ ñiña: ¡Wãmʉnʉcãña! Mʉ cacũñarĩ corore nepʉsari mʉ ya wiipʉ tunu ácʉ́ja. Merẽ mʉ riayere yʉ netõña —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei wãmʉnʉcã yua, cʉ̃ cacũñarĩ corore ne pʉsa, ti wiire witicoásúpʉ cʉ̃ ñicãrĩ cabʉʉmiatacʉ pʉame. Diore basapeori, cʉ̃ ya wiipʉ acoásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bairo cʉ̃ caátó ĩñarã, nipetiro camasã tʉ̃goña acʉari, atore bairo ĩñuparã: —Ago tame, ¿diwatoa ũno tore bairo caroa majũrẽ marĩ ĩñarĩ? Marĩ ĩñaepʉ̃. ¡Camasĩ niñami Dios! —qũĩ basapeoyuparã nipetirã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cabero acoásúpʉ Jesús tunu. Bairo ácʉ́, Leví cawãmecʉcʉre qũĩñajoyupʉ. Mai, Leví pʉame Roma gobiernorẽ camasã yaye dinero impuesto na caĩrĩjẽrẽ jejobojari majõcʉ ãñupʉ̃. Bairi cʉ̃ capaari arʉapʉ cʉ̃ caãno, qũĩñajoyupʉ Jesús Levíre. Bairo qũĩñajori bero, cʉ̃tʉ etaátí, atore bairo qũĩñupʉ̃: —Jito, yʉ bapacʉsa. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, tocãrõã jicoquei Leví pʉame cʉ̃ yaye paarique nipetirore cũcõã, Jesús mena bapacʉti ácʉ́ acoásúpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nocãrõ bero Leví cʉ̃ ya wiipʉ bose rʉ̃mʉ jʉ̃go qũẽnoñupʉ̃. Bairo bairi ti rʉ̃mʉrẽ cʉ̃ ya wiipʉ capããrã camasã ãñuparã cʉ̃ capiijoatana. Na mena macããna jĩcããrã Leví ũna, gobiernorẽ camasã yaye dinerore cajejobojari majã ãñuparã. Na ũna Jesujãã mena ʉga bapacʉsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bairo na caʉgabapacʉtore ĩñarã yua, fariseo majã pʉame na ĩ tutiyuparã Jesús cʉ̃ cabuerãrẽ. Na yarã, Moisés cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena atore bairo na ĩ tutiyuparã: —¿Nopẽĩ dinero jejori majã mena, bairi aperã roro caána mena mʉjãã etiʉga bapacʉtiyati? Roro mʉjãã átiya —na ĩ tutiyuparã fariseojãã Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bairo na catutiro tʉ̃go, bairo na ĩñupʉ̃ Jesús: —Ʉcotiri majõcʉre bairo yʉ ãniña ati wiire. Ʉcotiri majõcʉ ápériyami cacatirã na caãni wiiripʉre. Cariarã na caãni wiiri jetore etanucũñami, na ʉcoti etaʉ. Bairi ãnoa mena yʉ ãniña. Na carorije riayere bairo caãnierẽ netõõʉ̃ ácʉ yʉ atíapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Torecʉna, yʉ apʉ́ ati yepapʉre. “Caroarã marĩ ãniña,” caĩtorãrẽ na yʉ macãẽtĩña. Aperã, “Carorije wapa marĩ buicʉtiya,” caĩtʉ̃goña yapapuarã roquere na macãʉ̃acʉ́ yʉ apʉ́, na yeri wasoáto, ĩ —na ĩ quetibʉjʉyupʉ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Cabero Jesure qũĩ jẽniñañuparã tunu to macããna camasã: —Ʉgarique betiri Dios jetore cʉ̃ jẽninucũñama Juan cʉ̃ cabuerã. Fariseo majã na cabuerã tore bairo átiyama na cʉ̃ã. Mʉ cabuerã pʉame áperiyama. ¿Nopẽĩrã na ʉgarique betietinucũñati? —qũĩ jẽniñañuparã to macããna Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Caroaro yʉ caátiere mʉjãã tʉ̃gomasĩẽtĩña. Caʉ̃mʉ cawãmojiyapaʉre bairo yʉ ãniña. Cʉ̃ yarãrẽ bairo niñama yʉ cabuerã. Caʉ̃mʉ cʉ̃ cawãmojiyari rʉ̃mʉrẽ cʉ̃ yarã nipetirã ʉgayama pairo, cʉ̃ mena ʉseanirĩ ãna. Ti rʉ̃mʉrẽ aʉatãmʉoetiyama. Caʉ̃mʉ cʉ̃ cawãmojiyaro bero roquere, cʉ̃ yarã caborã ʉgarique betiri Diore cʉ̃ tʉ̃goñajẽni ñubuebujiorãma tunu. Narẽ bairo jãã ãniña. Bairi yʉ mena ãna, yʉ cabuerã aʉatãmʉoetigarãma. Yʉ camano roquere aʉatãmʉobujiorãma —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ĩ yaparo, “Yʉ yaye cawãma quetire cabʉcʉ macããjẽ mena tʉ̃goʉsa masĩã maniña,” ĩgʉ, atore bairi wãme na ĩcõña quetibʉjʉnemoñupʉ̃ Jesús tunu: —Cabʉcʉro jutirore cawori opere seretuetiyama camasã camasĩrã jutiro cawãma asero carʉgaeti asero mena. Bairo na caápata, ñuetigaro. Cose, ti aserore bopo na caáto, rʉgagaro. Rʉgari tʉ̃gãwonemogaro paijãñurõ cawãma asero pʉame cabʉcʉro jutirore. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tunu bairoa ʉse oco cawãma qũẽnoyaparoriquere piojãẽtĩnucũñama camasã cabʉcʉ poa waibʉcʉ asero poapʉre. Bairo na caápata, ti poa wocoagaro, tie oco capãmʉrõĩ. Ti poa macããjẽ yasigaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bairi ʉse ocore cawãma qũẽnoyaparoriquere piojãnucũñama camasã cawãma poa mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tunu bairoa ʉse oco cabʉcʉre caetiatana ni ũcʉ̃ jĩcãʉ̃ cawãmarẽ boecʉmi. Cʉ̃ pʉame, “Ʉse oco cabʉcʉ jeto yʉ ñuña,” ĩ tʉ̃goñañami —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Cabero judío majã na cayerijãrĩ rʉ̃mʉ caãno Jesujãã netõásúparã weseripʉ. Bairo netõáná, Jesús cʉ̃ cabuerã pʉame queyari trigo apeacarẽ cacatirijerea peenerĩ bure ʉgajʉ̃goyuparã. Bairo na caáto, fariseo majã pʉame na ĩñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bairo na caáto ĩña yua, atore bairo na ĩ tutiyuparã: —¿Nopẽĩrã ati rʉ̃mʉ ũnorẽ paariquere bairo mʉjãã átiyati? Ati rʉ̃mʉ ũnorẽ caápericõãpee niña mʉjãã caátie ũnierẽ —na ĩ tutiyuparã fariseo majã Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bairo na caĩtutiro tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —David ãnacʉ̃ queyamiácʉ́, ¿cʉ̃ caátajere na caquetibʉjʉcũrĩqũẽrẽ mʉjãã ĩñaetinucũñati Dios ya tutipʉ? Mʉjãã ĩñanucũrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bairo baiyuparo: David pʉame jããetayupʉ Dios ya wiire cʉ̃ ʉ̃mʉa mena. Ʉgariquere macããrã jããetayuparã. Bairi pan ãñuparõ, caroa Dios yaye majũ na caĩcũrĩqũẽ jeto. Tie pããrẽ sacerdote majã jetore na ʉgarotiyupʉ Moisés ãnacʉ̃. Bairo sacerdote majã jeto na caʉgarije caãnimiatacʉ̃ãrẽ, tie pããrẽ ʉgari bero, cʉ̃ ʉ̃mʉarẽ na batonuñupʉ̃ David —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tunu na ĩnemoñupʉ̃ Jesús fariseo majãrẽ: —Yʉ, Camasã Jʉ̃gocʉ ãnirĩ yʉ átirotimasĩña yerijãrĩcã rʉ̃mʉ cʉ̃ãrẽ camasã caroare na caátiãnipeere —na ĩ quetibʉjʉyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ape rʉ̃mʉ caãno tunu judío majã na cayerijãrĩ rʉ̃mʉ caetaro ĩña, jããetayupʉ Jesús ñubuerica wiipʉ. Bairo jããeta, na buejʉ̃goyupʉ. Topʉ ãñupʉ̃ jĩcãʉ̃ cariape nʉgõã caricábʉricʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mai, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi fariseo majã mena Jesús cʉ̃ caátigarijere caroaro qũĩña ʉsayuparã, na quetiuparãrẽ bʉsʉjãgarã. “¿Yerijãrĩcã rʉ̃mʉrẽã cʉ̃ catioʉáti caricábʉʉre?” ĩ tʉ̃goñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús masĩjãñuñupʉ̃ na catʉ̃goñarĩjẽrẽ. Bairo masĩmicʉ̃ã, atore bairo qũĩñupʉ̃ caricábʉʉre: —Tiaya. Ato yʉ tʉpʉ asá. Bairo cʉ̃ caĩrõ tʉ̃go, wãmʉnʉcã, cʉ̃ tʉpʉ etanʉcã etayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bairo cʉ̃ caetaro ĩña, atore bairo na ĩ jẽniñañupʉ̃ Jesús fariseojããrẽ: —¿Ñerẽ marĩ ánaati ati rʉ̃mʉrĩ ũnorẽ, camasã na cayerijãrĩ rʉ̃mʉrĩrẽ? ¿Cañurĩjẽrẽ marĩ ánaati, o carorije pʉamerẽ marĩ ánaati? Cañurĩjẽrẽ marĩ átigarã. Bopacooro cabairãrẽ marĩ canetõrõrẽ boyami Dios —na ĩñupʉ̃ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bairo na ĩ yaparo, nipetirãrẽ na ĩña, atore bairo qũĩñupʉ̃ Jesús caricábʉricʉre: —Mʉ ricáre ñupoya. Bairo cʉ̃ caĩrõ, caricábʉricʉ pʉame cʉ̃ caĩrõrẽ bairo ásupʉ. Tocãrõã cʉ̃ ricá ñucoasuparo yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bairo cʉ̃ caáto ĩñarã, fariseo majã pʉame asia netõcoasuparã Jesús mena. Bairo asia netõcõãti, atore bairo ãmeo ĩ jẽniñañuparã na majũ: “¿Dope bairo marĩ ánaati, Jesure cʉ̃ pajĩãgarã?” Cʉ̃ tejãñuñuparã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti rʉ̃mʉrĩrã Diore jẽnigʉ, ʉ̃tãʉ̃ buipʉ acoásúpʉ Jesús. Topʉ eta, ti ñamirẽ Diore qũĩ jẽniñubue busucoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bairo baibusueta, na piiyupʉ Jesús cʉ̃ cabueparãrẽ. Bairo na caetaro ĩña, na beseyupʉ pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ. Bese yaparo yua, “Mʉjãã yʉ caquetibʉjʉrotijoparã mʉjãã ãnigarã,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bairi pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ ãñuparã Jesús cʉ̃ caquetibʉjʉrotijoparã. Cajʉ̃goye ãñupʉ̃ Simón. Simorẽã qũĩñupʉ̃ tunu “Pedro”. Tunu cabero ãñupʉ̃ Pedro bai, Andrés cawãmecʉcʉ. Tunu cabero ãñuparã Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO cbcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, apei Santiago. Cʉ̃, Santiago, Alfeo macʉ̃ ãñupʉ̃. Tunu cabero ãñupʉ̃ apei Simón. Cʉ̃ pʉame celotes na caĩrã mena macããcʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Tunu cabero ãñupʉ̃ Judas, Santiago macʉ̃ pʉame. Tunu cabero ãñupʉ̃ Judas Iscariote. Cʉ̃ pʉame ãñupʉ̃ Jesure cañerotipaʉ. Tocãrõã niñama Jesús cʉ̃ caquetibʉjʉrotijoparã, cʉ̃ cabesericarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bairo Jesús na bese yaparo, buro bui caãniatacʉ ti burore cʉ̃ cabuerã mena ruietayupʉ yua. Bairo cʉ̃ caruiro, capããrã camasã qũĩñacoteyuparã. Na, camasã nipetiropʉ caatíatana ãñuparã. Torena, Judea yepa macããna, Jerusalén macã macããna, capairiyatʉ macã macããna, Tiro, Sidón na caĩrĩ macã macããna cʉ̃ã nipetiro ãñuparã. Jesús yaye quetire tʉ̃gogarã baiyuparã. Tunu bairoa, marĩ riayere cʉ̃ netõõáto, ĩrã baiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bairo bairi Jesús pʉame wãtĩ yeri pũna jʉ̃gori popiye cabairãrẽ na netõõñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bairo to macããna cariayecʉnarẽ na catioyupʉ Jesús cʉ̃ camasĩrĩjẽ mena. Bairi nipetiro camasã cʉ̃ pãñagayuparã, marĩ cʉ̃ãrẽ cʉ̃ catioáto, ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Cabero Jesús cʉ̃ cabuerãrẽ na ĩñamai, atore bairo na ĩñupʉ̃: “Ʉseanirĩ ãña mʉjãã yʉ cabuerã. Capee apeye ũnierẽ cacʉ̃goenarẽ bairo caãna nimirãcʉ̃ã, ãmerẽ Dios cʉ̃ carotimasĩrĩpaʉ macããna mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Tunu bairoa aʉanʉcãmirãcʉ̃ã, cabero mʉjãã ʉgayapigarã. Bairi ʉseanirĩ ãña. “Tunu bairoa ãmerẽ otimirãcʉ̃ã, cabero ʉseanirĩ mʉjãã boyetigarã. Bairi ʉseani ãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Mʉjãã, yʉ yarã majũ mʉjãã ãniña. Yʉ yaye quetire catʉ̃goʉsarã mʉjãã ãniña. Bairo catʉ̃goʉsarã mʉjãã caãnoi, camasã aperã mʉjããrẽ tejãñuñama. ‘Jãã mena ãmerĩcõãña,’ mʉjããrẽ ĩñama. ‘Moena mʉjãã ãniña,’ mʉjããrẽ ĩñama. Tunu yʉ, Camasã Jʉ̃gocʉre, yʉ mʉjãã catʉ̃goʉsaroi, mʉjããrẽ bʉsʉpaiyama. Tore bairo jeto ásupa na ñicʉ̃jãã profeta majã ãnana cʉ̃ãrẽ tirʉ̃mʉpʉre. Mʉjããrẽ tore bairo na caáto ĩñarã, mʉjãã ʉseanijãñugarã. Dios mʉjããrẽ caroare cʉ̃ cajopee paijãñurõ nigaro. Jõbuipʉ mʉjãã caetaro, pairo nigaro mʉjããrẽ caroa cʉ̃ cajopee. Bairo tiere tʉ̃goñarĩ ʉseanirĩqũẽ mena bairoa ãnicõã ninucũña,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ĩ yaparo, aperã cʉ̃ yaye quetire cariape catʉ̃gogaenarẽ atore bairo na ĩñupʉ̃: “Mʉjãã capee apeyere cacʉ̃gorã roque caroaro mʉjãã ãmerĩgarã. Ati yepapʉre caroaro ãnimirãcʉ̃ã, cabero popiye mʉjãã netõgarã. ¡Bopacooro mʉjãã tãmʉogarã! ");
INSERT INTO cbcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Tunu bairoa mʉjãã, ‘Ñe ũnie yʉ rʉsaetiya,’ caĩrã, ¡bopacooro mʉjãã tãmʉogarã mʉjãã cʉ̃ã! Ãmerẽ mʉjãã caborijere cʉ̃gomirãcʉ̃ã, cabero mʉjãã cʉ̃goetigarã. “Tunu mʉjãã, roro caĩboyetirã, ¡bopacooro mʉjãã tãmʉogarã mʉjãã cʉ̃ã! Ãmerẽ boyetimirãcʉ̃ã, cabero roro majũ otiri mʉjãã yapapuagarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tunu bairoa mʉjãã, ati yepa macããna nipetirã na caĩroaricarã ãnimirãcʉ̃ã, ¡bopacooro mʉjãã tãmʉogarã mʉjãã cʉ̃ã! Tirʉ̃mʉpʉre caãnijʉ̃goyaricarã cʉ̃ã bairo átiyayupa profeta majã caĩtori majã ãnanarẽ,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Bairo ĩ quetibʉjʉ yaparo, na ĩñupʉ̃ tunu: “Bairãpʉa mʉjãã, yʉ yaye quetire catʉ̃goʉsarã pʉame atore bairo mʉjãã caátore yʉ boya: Mʉjãã pesuare na mairotiya. Rorije na ãmeo ápericõãña. Caroa roquere na ása. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Roro mʉjããrẽ caĩrãrẽ, ‘Caroare cʉ̃ joáto Dios mʉjããrẽ,’ na ĩña. Tunu bairoa mʉjããrẽ popiye mʉjãã baio joroque caánarẽ na jẽnibojaya Diopʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tunu ni jĩcãʉ̃ ũcʉ̃ mʉjãã wasopanarẽ cʉ̃ capaata, ape nʉgõã cʉ̃ãrẽ cʉ̃ ẽñotaeticõãña. Tunu bairoa apei mʉjãã pesu pʉame mʉjãã jutiro cabui macããtõrẽ cʉ̃ caẽmaata, mʉjãã camisa cʉ̃ãrẽ maieticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tunu apei cʉ̃ cajẽniata, cʉ̃ cabopacarijere cʉ̃ nuniña. Tunu bairoa mʉjãã cacʉ̃gorijere caẽmaʉ cʉ̃ãrẽ, ‘Jãã tunuoña,’ qũĩẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aperã mʉjããrẽ caroaro na canʉcʉ̃bʉgoro mʉjãã boya. Torea bairo na cʉ̃ãrẽ mʉjãã canʉcʉ̃bʉgoro ñuña. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mʉjããrẽ camairã jetore mʉjãã caãmeo maiata, ¿ñe ũnie caroare mʉjãã ãmeo átiyati? Tore bairo átinucũñama Dios yaye quetire catʉ̃goʉsaena cʉ̃ã. Narẽ camairã jetore na mainucũñama. Torena, mʉjãã Dios yarã ãnirĩ, mʉjããrẽ cateerã cʉ̃ãrẽ na mairotiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tunu bairoa mʉjããrẽ caroaro caána jetore caroaro mʉjãã caápata, ¿ñe ũnie caroare mʉjãã átiyati? Tore bairo átinucũñama Dios yaye quetire catʉ̃goʉsaena cʉ̃ã. Narẽ caroaro caána jetore caroaro na átinucũñama. Bairi mʉjãã, Dios yarã ãnirĩ mʉjããrẽ carorije caána cʉ̃ãrẽ caroaro na átirotiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tunu bairoa mʉjããrẽ catunuomasĩrã jetore mʉjãã cawasoata, ¿ñe ũnie caroare mʉjãã átiyati? Tore bairo átinucũñama Dios yaye quetire catʉ̃goʉsaena cʉ̃ã. Narẽ nipetirã na cawasorijere catunuomasĩrã jetore na wasonucũñama. Bairi mʉjãã, Dios yarã ãnirĩ mʉjããrẽ catunuomasĩẽna cʉ̃ãrẽ na rotijoya. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bairi yʉ yarã, mʉjãã pesuare na maiña. Caroaro na átirotiya. Na wasoya mʉjãã cacʉ̃gorijere. ‘Marĩ tunuomasĩẽnama,’ ĩ tʉ̃goñaeticõãña. Bairo mʉjãã caápata, mʉjãã cawapatapee pairo nigaro. Caroaro mʉjãã caátie wapa jʉ̃gori pairo nigaro. Dios pʉame nipetirãrẽ caĩñamai niñami. ‘Yʉ mena mʉ ñujãñuña,’ caĩẽna, bairi rorije caána cʉ̃ãrẽ na ĩñamaiñami Dios. Bairi cʉ̃ pũnaa, nipetirã netõõrõ carotimasĩ pũnaa majũ mʉjãã ãnigarã, bairo mʉjãã caápata. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Marĩ Pacʉ Dios camasãrẽ cʉ̃ caĩñamairõrẽã bairo mʉjãã cʉ̃ã mʉjãã yarãrẽ na ĩñamaiña,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Bairo ĩ quetibʉjʉ yaparo, na ĩñupʉ̃ tunu: “Aperã noo na caátiãnierẽ roro bʉsʉpaieticõãña, mʉjããrẽ bairo Dios cʉ̃ã mʉjãã caátiere, ‘Roro átiyama,’ cʉ̃ caĩẽtĩparore bairo ĩrã. Tunu bairoa camasãrẽ, ‘Carorã mʉjãã ãniña,’ na ĩẽtĩcõãña, mʉjããrẽ bairo Dios cʉ̃ã, ‘Carorã mʉjãã ãniña,’ mʉjããrẽ cʉ̃ caĩẽtĩparore bairo ĩrã. Caroaro ása. Aperã roro mʉjããrẽ na caátiere masiritiya. Bairo mʉjãã caápata, Dios cʉ̃ã roro mʉjãã caátiere masiriyobojagʉmi. Mʉjããrẽ netõõgʉmi yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tunu aperã na cabopacarijere na joya. Bairo mʉjãã caápata, caroare mʉjãã jogʉmi Dios cʉ̃ã. Petoaca cabopacarãrẽ mʉjãã cajoata, petoaca mʉjãã jʉátigʉmi. Netõjãñurõ mʉjãã cajoata, netõjãñurõ mʉjãã jʉátigʉmi. Aperãrẽ mʉjãã cajʉátato cãrõ mʉjãã jʉátigʉmi Dios,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ĩ quetibʉjʉ yaparo, ape wãme na ĩ cõñañupʉ̃ tunu: “Ni jĩcãʉ̃ ũcʉ̃ cacaapee mácʉ̃ pʉame, apei cʉ̃ bapare cacaapee mácʉ̃rẽ, ‘Mʉ yʉ jʉ̃gogʉ,’ cʉ̃ caĩata, ñuetõ. Na, pʉgarãpʉa opepʉ rocajãcõãbujiorãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ bueri majõcʉ, cʉ̃rẽ cabuei netõõrõ masĩẽtĩñami. Bairo masĩpeyoetimicʉ̃ã, cabero roquere masĩpeyoʉpʉ, cʉ̃rẽã bairo masĩgʉmi,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","“Tunu bairoa jĩcãʉ̃ caʉ̃mʉ cʉ̃ baire, ‘Mʉ caapeapʉ pũrõãcã jãñaña. Yʉ nerocapa,’ qũĩñupʉ̃. Bairo qũĩmicʉ̃ã, cʉ̃ pʉame tutu majũ cʉ̃gocõãñami cʉ̃ caapeapʉ. Tore bairo baiyami jĩcãʉ̃ ũcʉ̃ pairo roro caátacʉ cʉ̃ cʉ̃ã petoaca roro caátacʉre, ‘Roro mʉ baiya,’ cʉ̃ cʉ̃ caĩbʉsʉpaiata. ¡Caĩtopairã mʉjãã ãniña! Torena, mʉjãã pʉame roque rejʉ̃goya mʉjãã carorijere. Bairo átiri bero roque, mʉjãã quetibʉjʉ masĩgarã aperãrẽ rorije na caátiere,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ĩ quetibʉjʉ yaparo, na ĩñupʉ̃ tunu: “Yucʉ, caroʉ́ pʉame carorijere rícacʉperiya. Tunu bairoa apei yucʉ caroricʉ caroare rícacʉperiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tocãnacã yucʉ carícacʉtiire ʉgarã, tiire marĩ masĩña. Tunu marĩ caʉgarije, higuera na caĩrĩjẽrẽ marĩ jeetiya pota yucʉpʉ. Tunu bairoa ʉse cʉ̃ãrẽ marĩ jeetiya pota wopʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Torea bairo camasã caroarã na yeripʉ caroaro tʉ̃goñañama. Bairi caroaro bʉsʉyama. Aperã carorã na yeripʉ roro tʉ̃goñañama. Bairi roro bʉsʉyama. Marĩ yeri marĩ catʉ̃goñamasĩrĩjẽpʉ caãnoi, marĩ bʉsʉnucũña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ĩ quetibʉjʉ yaparo, na ĩnemoñupʉ̃ tunu: “Mʉjãã yʉ yaye quetire átigaetimirãcʉ̃ã, ¿nopẽĩrã, ‘Jãã Quetiupaʉ,’ yʉre mʉjãã ĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ãmerẽ ape wãme ĩcõñarĩ mʉjããrẽ yʉ quetibʉjʉgʉ camasĩ cʉ̃ cabairijere. Ni ũcʉ̃ yʉtʉ caetaʉ, yʉ yaye quetire tʉ̃gori, cabero yʉ caĩrõrẽ bairo caácʉ atore bairo niñami: ");
INSERT INTO cbcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tutuari wiire caqũẽnoʉrẽ bairo camasĩ niñami. Cʉ̃ pʉame pupea yeseari cʉ̃ wii botare ʉ̃tã buire nʉcõñupʉ̃. Bairi cabero ria putaro, oco pʉame ti wiipʉ etayuparo. Bairo ti wiire bʉtioro to cajabemiatacʉ̃ãrẽ, ti wii pʉame toa nicõãñuparõ, ʉsʉro cʉ̃ caqũẽnorĩcã wii ãnirĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tunu bairoa apei cʉ̃ã yʉ yaye quetire tʉ̃gogaetiri, yʉ caĩrõrẽ bairo caápei atore bairo niñami: Tutuaeti wiire caqũẽnoʉrẽ bairo caãcʉ̃ niñami. Cʉ̃ pʉame ʉ̃tã bui mee cʉ̃ wii botare nʉcõñupʉ̃. Paputiropʉ cʉ̃ wiire qũẽnoñupʉ̃. Bairi cabero ria putaro, oco pʉame ti wiipʉ etayuparo. Bairo eta, ti wiire bʉtioro to cajaberoi yua, ti wii pʉame pecoasuparo. Ʉsʉeto cʉ̃ caqũẽnorĩcã wii ãnirĩ ñee mano ñapeticoasuparo,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bairo camasãrẽ na ĩ quetibʉjʉ yaparo yua, acoásúpʉ Jesús Capernaum na caĩrĩ macãpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mai, ti yepapʉ ãñupʉ̃ jĩcãʉ̃, romano soldaua quetiupaʉ capitán. Cʉ̃ pʉame capaabojari majõcʉre cʉ̃goyupʉ, cʉ̃ camai majũrẽ. Ti watoare riajãñuñupʉ̃ cʉ̃ capaabojari majõcʉ pʉame. Riácʉ́pʉ baiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bairo bʉtioro majũ cʉ̃ cariaroi yua, tʉ̃goyupʉ quetiupaʉ capitán ti yepare Jesús cʉ̃ caetarijere. Bairo tiere tʉ̃go yua, jĩcããrãrẽ judío majã cabʉtoa camasĩrãrẽ na piiroti joyupʉ Jesure. “Tãmurĩ yʉ yaʉre cʉ̃ catioʉ apáro,” na ĩ piiroti joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Bairi yua, Jesutʉ etarã, tutuaro mena qũĩñuparã: —Quetiupaʉ capitán, jããrẽ cajoʉ caroʉ́ niñami. Marĩrẽ, judío majãrẽ marĩ nʉcʉ̃bʉgoyami. Jãã cañubueri wiire qũẽnorotibojawĩ. Bairi mʉ cajʉáto boya. Jito tãmurĩ jãã mena —qũĩñuparã cabʉtoa camasĩrã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bairo na caĩrõ tʉ̃go, “Jaʉ,” ĩ, na mena ásúpʉ Jesús. Bairo quetiupaʉ capitán ya wiipʉ na caetaparo jʉ̃goye, aperã cʉ̃ mena macããnarẽ na joyupʉ tunu Jesús tʉpʉ quetiupaʉ capitán pʉame. Atore bairo na ĩ rotijoyupʉ Jesure: “Mʉ, caãnimajũʉ̃ mʉ ãniña. Yʉ pʉame roque mʉrẽ bairo yʉ baietiya. Bairi yʉ ya wiire mʉ cajããrõ ñuetõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bairi yʉ majũ mʉ yʉ macãʉ̃ ápériapʉ. Bairi topʉa ãcʉ̃, cʉ̃ catiáto, ĩ joya. Bairo mʉ caĩrõ, caticoagʉmi yʉ yaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉ netõjãñurõ carotirã na carotiricʉ yʉ ãniña. Tunu bairoa yʉ cʉ̃ã quetiupaʉ ãnirĩ yʉ ʉ̃mʉarẽ na yʉ rotimasĩnucũña. Bairi ‘Tiaya,’ yʉ caĩrõ, jicoquei atínucũñama. Tunu ‘Ánája,’ yʉ caĩrõ, jicoquei ánucũñama. Tunu ‘Bairo ása,’ yʉ paabojari majãrẽ yʉ caĩrõ, jicoquei yʉ caĩrõrẽ bairo átinucũñama,” na ĩ rotijoyupʉ quetiupaʉ capitán Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bairo na caĩrĩjẽrẽ tʉ̃go, Jesús pʉame tʉ̃goacʉacoasupʉ. Bairi cʉ̃rẽ caʉsarãrẽ na ãmejore ĩña, atore bairo na ĩñupʉ̃: —Mʉjããrẽ cariape ñiña: Ato Israel yepa macããna jĩcãʉ̃ ũcʉ̃ cʉ̃rẽ bairo yʉ mena catʉ̃goñatutuaʉre yʉ bócaetañaẽtĩña. Cʉ̃ pʉame tʉ̃goña tutuajãñuñami Dios cʉ̃ carotimasĩrĩjẽrẽ —na ĩñupʉ̃ Jesús cʉ̃ bero caʉsarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bairo cabero quetiupaʉ capitán cʉ̃ cajoatana wiipʉre tunueta ãna, paabojari majõcʉ cacatipʉre cʉ̃ etayuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesús pʉame atie bero ásúpʉ tunu Naín cawãmecʉti macãpʉ. Cʉ̃ mena bapacʉtiásúparã cʉ̃ cabuerã. Aperã capããrã camasã cʉ̃ã na bero ʉsayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bairo ti macãtʉ na caetaripaʉ Jesús pʉame ĩñajoyupʉ capããrã camasã ti macã, cawitiánárẽ. Na pʉame cabaiyasiatacʉre cʉ̃ yaráná, cʉ̃ neásúparã. Cabaiyasiatacʉ pʉame jĩcãʉ̃ã ãñupʉ̃ cawapearico macʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bairo Jesús cawapearicore ĩñaʉ, cõ ĩñamaiñupʉ̃. Bairi atore bairo cõ ĩñupʉ̃: —Yʉ yao, otieticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bairo ĩ yaparo, ti masã potire etanʉcã, pãñañupʉ̃. Bairo cʉ̃ caáto, ti potire caneatana pʉame tuanʉcãñuparã. Bairo na cabairo, cariacoatacʉre qũĩñupʉ̃ Jesús: —Cawãmaʉ, tʉ̃goya yʉ caĩrĩjẽ. Mʉrẽ ñiña: ¡Wãmʉnʉcãña! —qũĩñupʉ̃ Jesús cariacoatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bairo cʉ̃ caĩrõ, cariacoamiatacʉ pʉame jicoquei cati wãmʉnumuñupʉ̃ yua. Baicõã, bʉsʉjʉ̃goyupʉ. Bairo cʉ̃ cabairo ĩña, Jesús pʉame cʉ̃ joyupʉ cʉ̃ pacopʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bairo Jesús cʉ̃ caátijẽñorĩjẽrẽ ĩñarã, nipetiro camasã bʉtioro uwiyuparã. Tunu Diore qũĩ basapeoyuparã: —Profeta caroʉ́ cañuʉ majũ marĩtʉ etayami. Tunu atore bairo ĩ basapeoyuparã: —Dios cʉ̃ yarãrẽ jʉátinemogʉ marĩtʉ etayami —ĩ basapeoyuparã Jesús cʉ̃ caáto caĩñaatana. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bairo ti yepa, Judea yepa macããna, bairi ti yepa tʉ̃ni macããna cʉ̃ã nipetirã Jesús cʉ̃ caátiatajere tʉ̃gopeticoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan cʉ̃ã, presopʉ na cacũrocaricʉ tʉ̃goyupʉ tie quetire. Cʉ̃ cabuerã pʉame cʉ̃ quetibʉjʉyuparã. Bairi na mena macããnarẽ na piijoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Jesure na jẽniñarã ápáro,” ĩ, na piijoyupʉ. “‘¿Cariapea Mesías Dios cʉ̃ cajoʉ majũ mʉ ãniñati? ¿Cʉ̃ mee mʉ caãmata, apei pʉamerẽ jãã coterãati?’ qũĩ jẽniñarájá,” na ĩñupʉ̃ Juan cʉ̃ cabuerã pʉgarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bairi cʉ̃ cabuerã cʉ̃ caĩrõrẽ bairo ásúparã Jesús tʉpʉ. Bairo cʉ̃ tʉpʉ eta yua, atore bairo qũĩñuparã Jesure: —Juan, camasãrẽ cabautizamirĩcʉ̃ pʉame jãã joami. Mʉrẽ jãã jẽniñarotiami: “¿Cariapea, Mesías, Dios cʉ̃ cajoʉ majũ mʉ ãniñati? Cʉ̃ mee mʉ caãmata, ¿apei pʉamerẽ jãã coterãati?” —qũĩ jẽniñañuparã Juan cʉ̃ cajoatana Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mai, na cajẽniñaparo jʉ̃goyeaca, Jesús pʉame capããrã camasãrẽ na catioyupʉ. Cariayecʉnarẽ, bairi popiye cabairã cʉ̃ãrẽ, bairi wãtĩ yeri pũna cacʉ̃gorã cʉ̃ãrẽ, nipetirãrẽ na catioyupʉ. Tunu bairoa cacaapee ĩñamasĩẽna cʉ̃ãrẽ na catioyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bairi Juan cʉ̃ cabuerã na cajẽniñarõ, atore bairo na ĩñupʉ̃: —Ĩñañijate mʉjãã majũ yʉ caátiatajere. Tiere Juarẽ cʉ̃ quetibʉjʉrájá. Yʉ camasĩrĩjẽ jʉ̃gori caĩñamasĩẽtãna merẽ ĩñamasĩñama. Tunu caámasĩẽtãna cʉ̃ã merẽ ámasĩñama. Carupaʉ boaatana cʉ̃ã merẽ caticoayama. Catʉ̃goetana cʉ̃ã merẽ tʉ̃gomasĩñama. Tunu cabaiyasiatana cʉ̃ã merẽ caticoayama. Tunu cabopacarã cʉ̃ã caroa queti tʉ̃goyama Dios narẽ cʉ̃ canetõrĩjẽrẽ. Tiere cʉ̃ quetibʉjʉrájá. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tunu bairoa mʉjããrẽ ñiña: ¡Ʉseanirĩ niñama camasã yʉ mena catʉ̃goñatutuajãnaena pʉame! —na ĩ joyupʉ Jesús, Juan cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bairo Juan cʉ̃ cajoatána na caátó ĩña, to macããna capããrã camasãrẽ na quetibʉjʉ jʉ̃goyupʉ Jesús, Juan cʉ̃ cabairiquere. Atore bairo na ĩñupʉ̃: “¿Nopẽĩrã desierto cayucʉmanopʉ mʉjãã ásúpari? ¿Jĩcãʉ̃ yeruʉaca, wĩnoi cayuguiricʉacarẽ ĩñagarã, topʉ mʉjãã ásúpari? ");
INSERT INTO cbcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿O caʉ̃mʉ, caroa jutii cajãñaʉrẽ qũĩñagarã, topʉ mʉjãã ásúpari? Mʉjãã baiesupa. Camasã caroa jutii cajãñarã pʉame caroa wiiripʉ, quetiuparã ya wiiripʉ ãniñama. Desierto cayucʉmanopʉ etaetiyama na ũna. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿O profetare qũĩñagarã, topʉ mʉjãã ásúpari? Bairoa mʉjãã baiyupa. Cariape mʉjããrẽ ñiña: Mʉjãã pʉame, ‘Profeta ãcʉ̃mi Juan,’ mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, Juan profeta netõõjãñurõ caãnimajũʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cʉ̃ã niñami Dios yaye quetibʉjʉrica tutipʉ na cawoatujʉ̃goyecʉtacʉ majũ. Atore bairo ti tutipʉ ĩ quetibʉjʉyayupi Dios cʉ̃ macʉ̃rẽ, Juan cʉ̃ cabaipeere: ‘Mʉ, yʉ cajopaʉ, ti yepapʉ mʉ cabuiaparo jʉ̃goye, apeire cʉ̃ yʉ qũẽnoroti jojʉ̃gogʉ. Camasã mʉ yaye quetire na tʉ̃goʉsaáto ĩ, apeire yʉ qũẽnoroti jojʉ̃gogʉ,’ ĩ quetibʉjʉyayupi Dios Juan cʉ̃ cabaipeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cariape mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ ati yepapʉ cabuiaricʉ Juan netõrõ caquetibʉjʉnetõõmasĩ maami. Baipʉa, Dios cʉ̃ carotimasĩrĩpaʉ macããcʉ̃ pʉame nipetirã netõrõ cabʉgoro macããcʉ̃ ãnimicʉ̃ã, ape rʉ̃mʉpʉ roquere Juan netõrõ masĩcõãgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Bairo cʉ̃ caĩrõ tʉ̃go, nipetiro camasã Juan cʉ̃ cabautizaricarã pʉame Diore qũĩroayuparã. Gobiernorẽ camasã yaye dinerore cajejobojari majã cʉ̃ã qũĩroayuparã. ‘Torecʉ, marĩ Pacʉ Dios caroaro cariape átinucũñami,’ qũĩ tʉ̃goña masĩñuparã Dios cʉ̃ caátiere. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aperã fariseo majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame roque Juan cʉ̃ cabautizarijere boesuparã. Bairo boena, Dios narẽ cʉ̃ cajʉátigamirĩjẽrẽ bʉtioro ĩñateyuparã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Cʉ̃ pʉame masĩcõãñupʉ̃ na catʉ̃goñarĩjẽrẽ. Bairi atore bairo na ĩñupʉ̃: “¿Dope bairo mʉjãã, ati yʉtea macããna mʉjãã ũnarẽ ñicʉti? ¿Noa ũnarẽ bairo mʉjãã ãnicʉti? ");
INSERT INTO cbcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cawĩmarãrẽ bairo mʉjãã ãniña. Cawĩmarã pʉame camasã na caneñaporipaʉ ũno plazapʉ eperã, awajari atore bairo ĩ joyama na baparãrẽ: ‘Jãã catõrõã putiro mʉjãã basaetiapʉ. Tunu bairoa jãã caotiro cʉ̃ãrẽ, jãã mʉjãã otinemoetiapʉ,’ ĩ joyama cawĩmarã na baparãrẽ. Narẽ bairo mʉjãã ãniña cayugaena majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tʉ̃gopeoya mai. Yʉ jʉ̃goye etayupi Juan, camasãrẽ na bautizaʉ etaʉ. Cʉ̃ pʉame pan ʉgaesupʉ. Tunu ʉse oco cʉ̃ãrẽ etietinucũñupʉ̃. Bairo cʉ̃ cabairijere ĩñarã, mʉjãã pʉame, ‘Wãtĩ yeri pũna cacʉ̃goʉ ãcʉ̃mi. Cʉ̃ marĩ tʉ̃goetiroa,’ mʉjãã ĩñupã Juarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bairi Juan bero yʉ, Camasã Jʉ̃gocʉ, yʉ etawʉ. Yʉ pʉame camasã mena yʉ ʉganucũña. Na mena yʉ etinucũña. Bairo yʉ cabairijere ĩñarã, mʉjãã pʉame, ‘Ʉgapacajãñuñami. Ʉse oco cʉ̃ãrẽ etipacajãñuñami. Carorã mena bapacʉtiyami. Tunu bairoa Roma macããcʉ̃ gobiernorẽ camasã yaye dinerore cajejobojari majã mena bapacʉtiyami. Bairi caróʉ ãcʉ̃mi. Cʉ̃ marĩ tʉ̃goetiroa cʉ̃ cʉ̃ãrẽ,’ yʉ mʉjãã ĩnucũña. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Baipʉa, Dios pʉame cʉ̃ camasĩrĩjẽrẽ camasãrẽ na áti ĩñoñami cʉ̃ mena catʉ̃goñatutuarã caroaro na caátie jʉ̃gori,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Cabero fariseo majã mena macããcʉ̃ jĩcãʉ̃, Simón cawãmecʉcʉ Jesure qũĩñupʉ̃: “Jito, marĩ ʉgaáto yʉ ya wiipʉ.” Jesús pʉame cʉ̃ caĩrõ tʉ̃go, “Jaʉ,” ĩ, cʉ̃ ya wiipʉ ásúpʉ. Topʉ eta, ti wiire jãã, cʉ̃ mesapʉ etanumuñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mai, ti macãpʉ ãñupõ carõmio roro caáco. Cõ pʉame tʉ̃goyupo Jesús fariseo ya wiipʉ cʉ̃ caʉgaʉ etaro. Bairo tiere tʉ̃go, ti wiipʉ ásúpo cõ cʉ̃ã. Caroarʉacapʉ cajʉtiñurĩjẽrẽ cʉ̃gori ti wiipʉ ásúpo. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bairo ti wiire jããeta, Jesús rʉpori tʉpʉ ruiyupo. Bairo rui, otiyupo. Bairo cõ caotiro, cõ yaco oco pʉame cʉ̃ rʉporipʉ etayuparo. Bairo cabairo ĩña, cõ poa mena cõ caapee ocore pareyupo. Bairo pare yaparo, Jesure cʉ̃ nʉcʉ̃bʉgori cʉ̃ rʉporire ũpũñupõ. Ũpũ yaparo, caroa cajʉtiñurĩjẽ, cõ cajeatajere cʉ̃ rʉporire piopeoyupo yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bairi fariseo ti wii upaʉ pʉame bairo cõ caáto ĩña, atore bairo ĩ tʉ̃goñañupʉ̃: “Jesús, cariapea Dios yaʉ profeta cʉ̃ caãmata, atio carõmio cõ caátiãnierẽ masĩbujioʉmi. ‘Yʉre capãñao, rorije caáco niñamo,’ ĩ masĩbujioʉmi, Jesús profeta cʉ̃ caãmata,” ĩ tʉ̃goñañupʉ̃ fariseo, ti wii upaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús pʉame masĩcõãñupʉ̃ cʉ̃ caĩtʉ̃goñarĩjẽrẽ. Bairi atore bairo qũĩñupʉ̃: —Simón, jĩcã wãme mʉ ñigaya. Bairo cʉ̃ caĩrõ tʉ̃go, “Jaʉ, ĩña,” qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bairi Jesús pʉame atore bairo qũĩ quetibʉjʉyupʉ Simorẽ: —Caʉ̃mʉa pʉgarã dinerore cawapamorã ãñuparã. Jĩcãʉ̃ paijãñurõ, quinientos denario moneda tiiri majũ wapamoñupʉ̃. Apei pʉame petoaca cincuenta denario moneda tiiri majũ wapamoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na, pʉgarãpʉa tie dinerore tunuo masĩẽsuparã. Bairi na cawapamoʉ pʉame bopacooro na ĩñarĩ, “Ñugaro. Mʉjãã cawapamorĩjẽrẽ yʉ masiritigʉ,” na ĩñupʉ̃ yua. Bairi, ¿ni pʉame cʉ̃rẽ cʉ̃ mainetõcʉti? —qũĩ jẽniñañupʉ̃ Jesús fariseore. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, atore bairo qũĩñupʉ̃ fariseo Jesure: —Yʉra, paijãñurõ cawapamoʉ pʉame bʉtioro cʉ̃ maijãñuñami —qũĩñupʉ̃. Bairo cʉ̃ caĩrõ, “Cariape miña,” qũĩñupʉ̃ Jesús pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ĩ yaparo, carõmiorẽ ãmejore ĩña, qũĩñupʉ̃ Simorẽ: —¿Atio carõmio cõ caátiatajere miñaetiyati? Mʉ ya wii yʉ caetaro bero, yʉ mʉ oco joetiapʉ, yʉ rʉporire yʉ cacosepeere. Bairo mʉ caápericõãmiatacʉ̃ãrẽ, atio cõ caapee oco mena yʉ rʉporire coseamo. Áticõã tunu, cõ poa mena yʉ rʉporire pareamo. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tunu bairoa mʉ ya wii yʉ caetaro, caroaro jẽnirĩ yʉ mʉ ũpũetiapʉ. Bairo mʉ caápericõãmiatacʉ̃ãrẽ, atio nʉcʉ̃bʉgorique mena yʉ rʉporire ũpũ jãnaẽtĩñamo. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Tunu yʉ rʉpoare ʉse oco aceite mena mʉ peoetiapʉ. Bairo mʉ caápericõãmiatacʉ̃ãrẽ, atio caroa cajʉtiñurĩjẽrẽ yʉ piopeoamo yʉ rʉporire. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bairi mʉrẽ ñiña: Atio yʉre cõ caátiroarije jʉ̃gori yʉre bʉtioro cõ camairõrẽ áti ĩñoñamo. Bairi cõ carorije wapa pairo to caãnimiatacʉ̃ãrẽ, tiere yʉ masiriyoya. Baipʉa, apei petoaca cʉ̃ carorije wapare cʉ̃ camasiriyoata, petoaca cʉ̃ camairĩjẽ cʉ̃ãrẽ áti ĩñobujioʉmi cʉ̃rẽ camasiriyoʉre,” qũĩñupʉ̃ Jesús Simorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Qũĩ yaparo yua, atore bairo cõ ĩñupʉ̃ Jesús carõmiorẽ: —Yʉ yao, mʉ carorije wapare yʉ masiriyoya. ");
INSERT INTO cbcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bairo cʉ̃ caĩrõ tʉ̃go, ti wii macããna, cʉ̃ mena caʉgari majã pʉame ãmeo ĩñuparã na majũ: —Bairo caĩ, ¿ñamʉ ũcʉ̃ cʉ̃ ãnicʉti? ");
INSERT INTO cbcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bairo Jesús pʉame na caĩrĩjẽrẽ masĩmicʉ̃ã, carõmiorẽ cõ ĩnemoñupʉ̃: —Yʉ mena mʉ tʉ̃goñatutuaya. Bairi mʉrẽ yʉ netõõña. Caroaro ʉseanirĩqũẽ mena ácója —cõ ĩñupʉ̃ Jesús carõmiorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cabero Jesús áñesẽãñupʉ̃ ape macããrĩpʉ. Bairi tocãnacã macã, capairi macã, o õcã macããcã cʉ̃ãrẽ etaʉ, to macããnarẽ na quetibʉjʉyupʉ. Caroa queti, Dios cʉ̃ carotimasĩrĩpaʉ caetarore na quetibʉjʉyupʉ. Cʉ̃ cabuerã, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ apóstolea majã mena quetibʉjʉ ñesẽãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tunu carõmia, wãtĩ yeri pũnarẽ cacʉ̃gomiatana cʉ̃ã cʉ̃ mena bapacʉti ñesẽãñuparã. Jesús pʉame wãtĩ yeri pũnarẽ na acurewiyojobojayupʉ. Jĩcãõ Jesús mena caácó, María Magdalena wãmecʉsupo. Cõ pʉame wãtĩ yeri pũnarẽ jĩcã wãmo peti pʉga pẽnirõ majũ cacʉ̃gomiataco ãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apeo, Juana cawãmecʉco ãñupõ. Cõ pʉame Cuza, Herodes ya wiire paari majãrẽ carotibojaʉ nʉmo ãñupõ, Juana pʉame. Apeo, Susana cawãmecʉco ãñupõ. Capããrã ãñuparã bairãpʉa Jesús mena cañesẽãrĩ majã rõmirĩ. Na cacʉ̃gorije mena Jesujããrẽ na jʉátinemoñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cabero camasã capããrã, na ya macããpʉ caatíatana Jesutʉre neña etayuparã, qũĩñagarã. Bairo na caneñaetaro ĩña yua, na quetibʉjʉ jʉ̃goyupʉ Jesús. Oteriquere caoteire ĩcõñarĩ atore bairo na ĩ quetibʉjʉyupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Jĩcã rʉ̃mʉ ásúpʉ jĩcãʉ̃ caʉ̃mʉ cʉ̃ wesepʉ, oteriquere otei ácʉ́. Topʉ eta, cʉ̃ oteriquere wẽbato otejʉ̃goyupʉ. Bairo caroaro cʉ̃ caotemiatacʉ̃ãrẽ, oterique jĩcã rupa ñañuparõ maapʉ. Bairo cabairoi, ti wããrẽ caánetõrã camasã pʉame oteriquere pea aboyuparã. Tunu bairoa minia ti rupare ĩñarĩ, wʉ ruiatí, ʉgarecõãñuparã maapʉ cañaatarupare. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Cabero cʉ̃ cawẽbatoro, ape rupa ʉ̃tã yepapʉ ñañuparõ. Bairo tie oterique pʉame pútiatímii yua, yoaro mee riacoásúparo, ti yepa caoco mano jʉ̃gori yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Cabero ape rupaa pota yucʉ watoapʉ ñañuparõ. Cabero pota yucʉ pʉame bʉtinetõrõ, tie oterique caroaro pútimasĩẽsuparo. Pota yucʉ pʉame otere bʉtibiacõãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Cabero ape rupaa pʉame caroa yepapʉ ñañuparõ. Cabero puti, bʉticoasuparo. Bairo bʉtiátó yua, tocãnacã jatípʉa cien rupa jeto rícacʉsuparo,” na ĩ quetibʉjʉyupʉ Jesús. Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃: “Mʉjãã caãmoocʉna mʉjãã ãniña. Bairi ãmerẽ yua, mʉjããrẽ yʉ caquetibʉjʉatajere tʉ̃goãmewiyoya mʉjãã yeripʉ,” na ĩñupʉ̃, Jesús bʉsʉrique tutuaro mena cʉ̃tʉ caneñaetari majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cabero Jesús cʉ̃ cabuerã pʉame qũĩ jẽniñañuparã: “¿Dope ĩgaro to ĩñati caotei queti?” qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bairo na caĩrõ tʉ̃go, atore bairo na ĩ quetibʉjʉyupʉ Jesús: “Dios cʉ̃ carotimasĩrĩpaʉ macããjẽrẽ tirʉ̃mʉpʉ macããna na catʉ̃goetajere mʉjãã roquere mʉjãã masĩõñami. Aperã tiere na camasĩrõrẽ boetiyami. Torecʉ, ape wãme ĩcõñarĩ na quetibʉjʉ rotiyami Dios. Na pʉame cacaapee cʉ̃gorã nimirãcʉ̃ã, Dios cʉ̃ caátiere ĩñamasĩẽtĩñama. Tunu bairoa cʉ̃ yaye quetire tʉ̃gomirãcʉ̃ã, tiere tʉ̃gomasĩẽtĩñama,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ Jesús tunu cʉ̃ cabuerãrẽ: “Ãmerẽ yua, mʉjããrẽ yʉ quetibʉjʉgʉ caroaro ĩcõñarĩ camasãrẽ yʉ caquetibʉjʉatajere. Caotei cʉ̃ caoterije Dios yaye quetire bairo niña: ");
INSERT INTO cbcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Camasã jĩcããrã Dios yaye quetire tʉ̃goyama. Bairo tʉ̃gomirãcʉ̃ã, tʉ̃gomasĩẽtĩñama. Dios bʉsʉriquere na catʉ̃goatato beroaca, wãtĩ pʉame uwaro eta, jecõãñami na camasĩbujioatajere. Minia na cawʉje ʉgaricarore bairo etanecõãñami wãtĩ, na camasĩbujioatajere, Dios bʉsʉriquere cariape na tʉ̃goeticõãto, ĩ. Na canetõrõrẽ boetiyami wãtĩ. Na pʉame caotei cʉ̃ caoterique maapʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tunu aperã camasã Dios yaye quetire ʉseanirõ tʉ̃go, jicoquei, ‘Jaʉ,’ ĩñama. Bairo bomirãcʉ̃ã, bairãpʉa na yeripʉ caroaro cʉ̃ yʉetiyama. Capútirije canʉcõmanajẽrẽ bairo niñama. Bairi wãtĩ pʉame, ‘Roro ása,’ cʉ̃ caĩrõ, yoaro mee jãnañama Dios yaye quetire. Dios mena yoaro ãmerĩñama. Naa, caotei cʉ̃ caoterique ape rupaa ʉ̃tã rupaa buipʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tunu aperã camasã Dios yaye quetire, ‘Jaʉ,’ na caĩrõ bero, apeye ũnie pʉamerẽ bʉtioro tʉ̃goña macãñama. Ati yepa macããjẽ wapatarique ũnierẽ, bairi caroaro na caãnigarije cʉ̃ãrẽ tʉ̃goñañama bʉtioro. Bairi Dios bʉsʉriquere tʉ̃goña masiriticõãñama. Caroaro caánarẽ bairo na caáperoi, caríca bʉtimasĩẽtĩẽrẽ bairo niñama. Bairi naa, caotei cʉ̃ caoterique ape rupaa pota watoapʉ cañarĩcã rupaare bairo niñama. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bairãpʉa, aperã roque Dios yaye quetire ʉseanirõ tʉ̃goyama. Na yeri pũnapʉ cariape tʉ̃gopeori, tiere tʉ̃goʉsayama. Bairi Dios mena tutuaro niñama. Cʉ̃ yaye quetire jãnaẽtĩñama. Capee caroare átinucũñama. Caotei cʉ̃ caoterique ape rupaa, caroa yepapʉ cañarĩcã rupaare bairo niñama. Bairi capee carícacʉtacʉre bairo niñama yua,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ĩ yaparo, atore bairo na ĩ quetibʉjʉnemoñupʉ̃ Jesús tunu: “Ni ũcʉ̃ jĩcãʉ̃ jĩñaworiquere bʉgacũẽtĩnucũñami jotʉ rocapʉ. Cama rocapʉ cʉ̃ãrẽ cũẽtĩñami. Jõbuipʉ roque cũnucũñami, camasã nipetiro cajããetarã na caĩñamasĩparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na cajĩñaworipaʉ nipetiro baugaro caĩñamaniataje. Torea bairo ape rʉ̃mʉpʉ camasã nipetiro ãme camasĩã manierẽ masĩpeticoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Bairi yʉ caquetibʉjʉrijere mʉjãã catʉ̃gopeoata, Dios pʉame mʉjããrẽ masĩõnemogʉmi tunu yʉ caquetibʉjʉrijere. Bairo tʉ̃gomirãcʉ̃ã, petoaca mʉjãã catʉ̃gopeoata roque, cabero mʉjãã camasĩmiatajere mʉjãã masiriticõãgarã. Bairi caroaro cariape tʉ̃gopeoya,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Bairo cʉ̃ caĩquetibʉjʉro bero, Jesús paco, bairi cʉ̃ bairã cʉ̃ã topʉ etayuparã. Bairo camasã capããrã Jesús tʉpʉ na caãnoi, na yaʉ tʉpʉre eta ámasĩẽsuparã. Bairi Jesús cʉ̃ caãni wii macãpʉ cʉ̃ cotenucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bairo macãpʉ na cacotenucũrõ, Jesutʉ macããcʉ̃ jĩcãʉ̃ bairo qũĩñupʉ̃ Jesure: —Mʉ paco, mʉ bairã mʉ macãũparã. Macãpʉa mʉrẽ coterã átiuparã —qũĩñupʉ̃ jĩcãʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús to macããnarẽ: —Noa ũna Dios yaye quetire catʉ̃goʉsarã pʉame niñama yʉ pacore bairo caãna, bairi yʉ bairãrẽ bairo caãna —na ĩñupʉ̃ Jesús to macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jĩcã rʉ̃mʉ Jesús cʉ̃ cabuerã mena cũmua capairicapʉ ájããñupʉ̃. Bairo ájãã yua, atore bairo na ĩñupʉ̃: —Jito, ati ʉtabʉcʉra ape nʉgõãpʉ marĩ pẽña átóca. Bairo cʉ̃ caĩrõ bero, pẽñacoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bairo na caátó yua, wĩno pairo papu átijʉ̃goyuparo. Bairo capapuro, ocoturi pairo atíjabejããñuparõ, cũmua ruagari tʉ̃nipʉ yua. Mai, Jesús pʉame cãnijããcoasupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bairo cʉ̃ cabairoi, cʉ̃ cabuerã pʉame cʉ̃ wãcõñuparã. Cʉ̃ wãcõrĩ atore bairo qũĩñuparã Jesure: —¡Jããrẽ cabuei, ruarã marĩ baiya! ¡Yasirã marĩ baiya! —qũĩñuparã. Bairo na caĩrõ tʉ̃gowãcã, wãmʉnʉcãñupʉ̃ Jesús. Wãmʉnʉcã, wĩnorẽ jãnarotiyupʉ. Tunu bairoa oco turiri cʉ̃ãrẽ jãnarotiyupʉ. Bairo cʉ̃ caĩrõ, jicoquei jãnacoasuparo yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cabero atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —¿Dios mena mʉjãã tʉ̃goña tutuaetiyati? —na ĩñupʉ̃. Cʉ̃ cabuerã pʉame cʉ̃ caáto ĩña acʉacoasuparã. Bairi atore bairo ãmeo ĩñuparã na majũ: —Ago tame, ¡nocãrõ majũ cʉ̃ masĩñati Jesús! Wĩno, ocoturi cʉ̃ã cʉ̃ tʉ̃gocõãña —ĩñuparã, Jesús cʉ̃ camasĩrĩjẽrẽ ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Cabero ti ʉtabʉcʉra ape nʉgõãpʉ pẽña etayuparã Jesujãã. Galilea yepa jĩãme, Gerasa cawãmecʉtopʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Bairo eta yua, maanʉcãñupʉ̃ Jesús. Bairo cʉ̃ camaa nʉcãrõ, caʉ̃mʉ jĩcãʉ̃, wãtĩ yeri pũna cacʉ̃goʉ pʉame cʉ̃ atʉ etayupʉ. Mai, caʉ̃mʉ pʉame yoaro jutii mácʉ̃ niñesẽãñupʉ̃. Wiipʉ ãmeñupʉ̃. Ʉ̃tã wiiripʉ roque camasãrẽ na carericaropʉ niñesẽãñupʉ̃. Tunu wãtĩ yeri pũna cʉ̃rẽ cʉ̃ caãno jʉ̃gori nairõ mecʉ̃nucũñupʉ̃. Bairi camasã pʉame cʉ̃ ñesẽã rotietimiñuparã. Cʉ̃ wãmorĩrẽ, bairi cʉ̃ rʉpori cʉ̃ãrẽ ãpõã wẽẽrĩ mena cʉ̃ jiyanucũmiñuparã. Bairo na caátimiatacʉ̃ãrẽ, cʉ̃ pʉame ãpõã wẽẽrĩrẽ tʉ̃gãjure recoanucũñupʉ̃. Bairo áticõã, camasã manopʉ rutiñesẽãcõã nucũñupʉ̃. Bairo bai, ti rʉ̃mʉ Jesús tʉpʉ eta, rʉpopaturi mena etanumurĩ Jesure qũĩ awajayupʉ. Mai, Jesús pʉame atore bairo qũĩñupʉ̃ wãtĩ yeri pũnarẽ: —Wãtĩ, ¡jicoquei cʉ̃ witi ácʉ́ja! —qũĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, wãtĩ yeri pũna cacʉ̃goʉ pʉame, Jesure qũĩ awajayupʉ: —¡Mʉ, Dios, jõbui macããcʉ̃ macʉ̃, mʉ ãniña! ¿Ñerẽ mʉ ácʉati yʉtʉre? ¡Popiye yʉ cabaipeere ápericõãña! —bʉtioro qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","31","Bairo cʉ̃ caĩrõ tʉ̃go, qũĩ jẽniñañupʉ̃ Jesús wãtĩ yeri pũnarẽ: —¿Ñamʉ mʉ wãmecʉtiyati? Bairo cʉ̃ caĩrõ tʉ̃go, qũĩñupʉ̃ wãtĩ yeri pũna Jesure: —Jãã, capããrã jãã niña. Bairi yʉ wãme, Legión yʉ ãniña. ¡Jããrẽ aperopʉ, popiye bairicaropʉ jãã mʉ joepa! —bʉtioro qũĩñupʉ̃ wãtĩ yeri pũna Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mai, totʉ ʉ̃tãʉ̃pʉ capããrã yesea nurĩcãrã ʉgarã ásuparã. Bairo na caʉgaãno, wãtĩ yeri pũna pʉame atore bairo bʉtioro qũĩñuparã Jesure: —¡Yeseapʉre jããrẽ jãárotiya! Napʉre jãã jããgarã —bʉtioro qũĩñuparã. Bairo na caĩrõ tʉ̃go, “Jaʉ, topʉ ánája toroque,” na ĩñupʉ̃ Jesús, na ároti yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bairo cʉ̃ caĩrõ, wãtĩ yeri pũna pʉame caʉ̃mʉrẽ cʉ̃ witipeticoásúparã. Yeseapʉre jããrásúparã. Bairo yeseare na cajããrĩpaʉ yua, yesea ʉ̃tãʉ̃ bui caãnimiatana pʉame mecʉ̃rã ʉtabʉcʉrapʉ atʉre ñañuacoásúparã. Bairi yua, ruapeticoásúparã yesea pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bairo na cabairo ĩña, yeseare cacotemiatana pʉame acʉari acoásúparã. Macãpʉ etacoasuparã. Topʉ na quetibʉjʉyuparã nipetiro yesea na cabaiatajere. Macã tʉ̃ni macããna cʉ̃ãrẽ na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bairo tie tʉ̃gori camasã pʉame ĩñarásúparã cabaiatajere. Bairo topʉ etarã, qũĩña acʉacoasuparã capããrã wãtĩ yeri pũnarẽ cacʉ̃gomiatacʉre. Cʉ̃ pʉame jutii jãñarĩ, caroaro tʉ̃goñarĩqũẽ mena ruiyupʉ. Bairi dope bairo cʉ̃ cabaiatajere masĩẽna, uwijãñuñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bairo baicõã, caĩñaatana pʉame, na quetibʉjʉyuparã caetarãrẽ. Wãtĩ yeri pũnarẽ cacʉ̃gomiatacʉ cʉ̃ cabaiatajere na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bairo na caquetibʉjʉro, bʉtioro Jesure cʉ̃ uwiri atore bairo qũĩñuparã: “Tunu ácʉ́ja mʉ caatíatatopʉ,” qũĩñuparã Jesure to macããna, Gerasa yepa macããna. Bairo na caĩrõĩ, Jesús pʉame cũmuarẽ ájããñupʉ̃ tunu cʉ̃ cabuerã mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bairo cʉ̃ caájããrõ, wãtĩ yeri pũnarẽ cacʉ̃gomiatacʉ pʉame bʉtioro qũĩñupʉ̃ Jesure: —Jesús, mʉ mena yʉ ágaya bʉtioro —qũĩñupʉ̃. Bairo cʉ̃ caĩrõ, Jesús qũĩñupʉ̃ tunu: ");
INSERT INTO cbcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Yʉ yaʉ, tuaya. Mʉ ya macã pʉame tunu ácʉ́ja. Topʉ etaʉ, to macããnarẽ na quetibʉjʉya marĩ Quetiupaʉ Dios caroaro mʉ cʉ̃ caátiatajere —qũĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, tunucoásúpʉ cʉ̃ ya macãpʉ. Topʉ etaʉ, nipetirãrẽ na quetibʉjʉyupʉ Jesús cʉ̃ caátiatajere. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bairo cabero Jesús ti ʉtabʉcʉrare cʉ̃ capẽñaetaro, capããrã camasã cʉ̃ coteyuparã. Bairi ʉseanirĩqũẽ mena cʉ̃ bocáyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bairo Jesús cʉ̃ camaanʉcãrõ, cʉ̃tʉ etayupʉ caʉ̃mʉ jĩcãʉ̃, Jairo cawãmecʉcʉ. Jairo pʉame camasã na cañubueri wii sinagoga quetiupaʉ ãñupʉ̃. Torecʉ, cʉ̃tʉ eta, rʉpopaturi mena eta numurĩ Jesure qũĩroayupʉ. Bairi bʉtioro, “Yʉ ya wiipʉ mʉ caátó yʉ boya,” qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mai, Jairo macõ pʉame riajãñuñupõ. Cʉ̃ macõ, jĩcãõã caãcõ pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã cʉ̃marĩ majũ cacʉ̃go ãñupõ. Bairo bairi merẽ riácópʉ baiyupo. Bairi Jesús cʉ̃ ya wiipʉ cʉ̃ caátóre bʉtioro boyupʉ Jairo, cõrẽ cʉ̃ catioáto, ĩ. Bairo Jesús pʉame, Jairo macõ cõ cabairo tʉ̃go, Jairo mena acoásúpʉ, cariao cõ caãnopʉ ácʉ́. Bairo cʉ̃ caátó, camasã pʉame ʉtabijaro majũ cʉ̃ ʉsayuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mai, na mena macããcõ jĩcãõ cariíjãnaecõ ãñupõ. Yoaro, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã cʉ̃marĩ majũ tiere riayupo. Catimasĩẽsupo. Capããrã camasã cõrẽ na caʉcotimiatacʉ̃ãrẽ, cõ tʉ̃goesuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bairo baicõã yua, tʉ̃goñañupõ cõ pʉame Jesús cʉ̃ camasĩrĩjẽrẽ, cʉ̃ cariaye netõmasĩrĩjẽrẽ. Bairo tiere tʉ̃goñarĩ, Jesús bero pʉame asúpo. Bairo aperã na caĩñaeto, cʉ̃ jutiro cayoaro yapaacarẽ tuañañupõ. Bairo cõ caáto, tocãrõã, jicoquei caticoasupo. Cõ carií petirique riaye jãnacoasuparo yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bairo cõ capãñarõ bero, atore bairo na ĩñupʉ̃ Jesús cʉ̃tʉ caãna camasãrẽ: —¿Noa na tuañaati yʉ jutirore? —na ĩ jẽniñañupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, nipetirã, “Jãã tuañaetiapʉ,” qũĩñuparã. Bairo na caĩrõ bero, Pedro pʉame qũĩñupʉ̃ Jesure: —Jãã cabuei, rita ãnoa camasã capããrã niñama. Bairi mʉ tunerocayama noo na caboro. Nana na caátiere mi bauya —qũĩñupʉ̃ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bairo cʉ̃ caĩrõ tʉ̃gomicʉ̃ã, atore bairo na ĩnemoñupʉ̃ Jesús tunu: —Yʉ camasĩrĩjẽrẽ yʉ átiroyaapʉ. Bairi yʉ masĩña yʉ caátiatajere. Jĩcãʉ̃ ũcʉ̃ yʉ jutirore pañaroyaami —qũĩñupʉ̃ Jesús Pedrore. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bairi cariamiataco pʉame, ruti masĩẽtĩmiácó, uwi tʉ̃goñarĩ, Jesutʉ etayupo. Rʉpopaturi mena Jesús rʉpori tʉpʉ etanumuñupõ. Nipetiro camasã na caĩñarõ, atore bairo ĩ quetibʉjʉyupo: —Catigo, yʉa, mʉ jutirore yʉ tuañaapʉ. Bairo yʉ caáto, jicoquei yʉ caticoaapʉ, —qũĩ quetibʉjʉyupo. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bairo cõ caĩquetibʉjʉro bero, cõ ĩñupʉ̃ Jesús: —Yʉ yao, yʉ camasĩrĩjẽrẽ cariape mʉ tʉ̃goñaupa. Bairi mʉ riayere yʉ netõõcõãña. Tunu ácója ʉseanirĩqũẽ mena —cõ ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bairo cʉ̃ caĩãnitoyea, jĩcãʉ̃ etayupʉ, Jairo ya wii macããcʉ̃ pʉame. Jairore qũĩ quetibʉjʉ etayupʉ: —Mʉ macõ merẽ baiyasicoaamo. Bairi tocãrõã cʉ̃ patowãcõña marĩrẽ cabueire —qũĩ quetibʉjʉyupʉ Jairore. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bairi Jesús cʉ̃ã cʉ̃ caĩrĩjẽrẽ tʉ̃goyupʉ. Bairo tʉ̃gori, atore bairo qũĩñupʉ̃ Jairore: —Jairo, tʉ̃go acʉaeticõãña. Dios cʉ̃ camasĩrĩjẽ jetore tʉ̃goñatutuaya. Bairo mʉ catʉ̃goñaata, mʉ macõ netõgomo —qũĩñupʉ̃ Jesús Jairore. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cabero Jairo ya wiipʉ etayuparã. Bairo ti wiipʉ etarã, ti wiire jããñuparã. Pedro, Santiago, Juan, bairi cawĩmao pacʉa Jesús mena jããñuparã. Aperãrẽ na jããrotiesupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mai, to macããna nipetirã otiawaja ãñuparã. Bopacooro cõ cabairijere cõ ĩña otiyuparã. Bairo na cabairo ĩñarĩ, atore bairo na ĩñupʉ̃ Jesús: —Atio cawĩmao baiyasietiyamo. Cãnio baiyamo. Awaja otieticõãña mʉjãã —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bairo cʉ̃ caĩrõ tʉ̃go, nipetirã to macããna pʉame roro cʉ̃ bócaboyeticõãñuparã, “Merẽ yasicõããmo,” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bairo roro cʉ̃rẽ na caboca boyetimiatacʉ̃ãrẽ, Jesús pʉame cawĩmao cariacoataco cõ caãnopʉ jããeta yua, cõ ãnacõ wãmorĩrẽ ñerĩ, atore bairo cõ ĩñupʉ̃: —¡Cawĩmao wãmʉnʉcãña! ");
INSERT INTO cbcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bairo cʉ̃ caĩrõ, jicoquei catitunucoasupo. Bairo cati yua, wãmʉnʉcãcoasupo. Bairo cõ cawãmʉnʉcãrõ ĩña, “Cõ nuña ʉgariquere. Queyao baiyamo,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Cõ pacʉa pʉame bairo cõ cabairo ĩña, bʉtioro tʉ̃goñacõã maniásuparã. Bairo na catʉ̃goña maniamiatacʉ̃ãrẽ, Jesús pʉame na ĩnemoñupʉ̃ tunu atore bairo: —Aperãrẽ na quetibʉjʉeticõãña mʉ macõ cõ cacatiatajere —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jĩcã rʉ̃mʉ na neñoñupʉ̃ Jesús cʉ̃ cabuerãrẽ, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ caãnarẽ. Bairo narẽ neño, narẽ joyupʉ masĩrĩqũẽrẽ. Tocãnacã wãmepʉrea wãtĩ yeri pũnarẽ wiyomasĩrĩqũẽrẽ na joyupʉ. Baicõã, riaye netõmasĩrĩqũẽ cʉ̃ãrẽ na joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Baicõã, na quetibʉjʉ rotijoyupʉ. Camasãrẽ Dios cʉ̃ carotimasĩrĩpaʉ caetarore na masĩáto ĩ, na quetibʉjʉ rotijoyupʉ. Tunu bairoa, camasã cariayecʉnarẽ na catioáto ĩ, na joyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bairi na caápáro jʉ̃goye atore bairo na ĩñupʉ̃ Jesús: —Mʉjãã yaye apeye ũnierẽ jeápéricõãña. Bairi tuericʉ, wasopoa, pan, dinero cʉ̃ãrẽ mʉjãã jeápéwa. Mʉjãã cajãñarõ mena tocãrõã mʉjãã neágarã. Apero mʉjãã cawasoaparore mʉjãã neápéwa. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bairo noo mʉjãã cañesẽãrõpʉ jĩcã wii ũnorẽ etarã, toa tuacõãña, ti macãpʉ mʉjãã caãni rʉ̃mʉrĩ cãrõ. Capee wiiripʉ mʉjãã capatowãcõ ñesẽãrõrẽ yʉ boetiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bairi di macã macããna ũna mʉjããrẽ na caĩñateata, na mena ãmerĩcõãña. Bairo mʉjããrẽ na caboetiere ĩñarã, na macã ñerĩrẽ mʉjãã rʉpo jutii macããjẽrẽ mʉjãã paregarã. Mʉjãã mena roro na caátiãnierẽ na masĩáto ĩrã, bairo mʉjãã átigarã —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bairo cʉ̃ caĩquetibʉjʉro bero, acoásúparã cʉ̃ cabuerã. Macãã caãno cãrõ áñesẽãñuparã. Caroa quetire, Dios roro cabairãrẽ cʉ̃ canetõõrĩjẽrẽ na quetibʉjʉ ñesẽãñuparã. Tunu bairoa cariayecʉnarẽ na catioyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti yʉtea caãno Herodes, ti yepa macããna quetiupaʉ pʉame tʉ̃goyupʉ nipetirije Jesús cʉ̃ caátimasĩrĩjẽrẽ. Bairo tʉ̃gori yua, dope bairo ĩ masĩẽsupʉ Herodes. Mai, cʉ̃tʉ macããna atore bairo qũĩ quetibʉjʉyuparã: “Juan el Bautista, cabaiyasiricʉ ãnacʉ̃ merẽ catiupʉ,” qũĩñuparã cʉ̃tʉ macããna jĩcããrã Herodere. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aperã qũĩñuparã: “Dios camasãrẽ cʉ̃ caquetibʉjʉrotijoricʉ ãnacʉ̃, Elías cawãmecʉcʉ ãnacʉ̃ catiri buiaetaupʉ,” qũĩñuparã. Bairo aperã qũĩñuparã: “Apei, tirʉ̃mʉpʉ caãnana profeta majã mena macããcʉ̃ jĩcãʉ̃ catiri buiaetaupʉ,” qũĩñuparã aperã Herodere, Jesús cʉ̃ caátiere tʉ̃gori yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bairo na caĩrõ tʉ̃go, Herodes pʉame na ĩñupʉ̃: —Juarẽ cʉ̃ boecʉna, cʉ̃ rʉpoare yʉ patarocacõã rotiwʉ. Bairi, ¿ñamʉ ũcʉ̃ cʉ̃ ãnicʉti ãni, “Tocãrõ capee áti ĩñoñami,” mʉjãã caĩ? —na ĩñupʉ̃ Herodes cʉ̃tʉ macããnarẽ. Bairo na ĩ yaparo yua, Jesure qũĩñagamiñupʉ̃ bʉtioro. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cabero apóstolea Jesús cʉ̃ caquetibʉjʉrotijoricarã pʉame tunu etayuparã. Bairo eta yua, Jesure cʉ̃ quetibʉjʉyuparã na caátiñesẽãtajere. Bairo na caĩquetibʉjʉro tʉ̃go, “Jito aperopʉ,” na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. Bairo ĩ yua, Betsaida na caĩrĩ macãpʉ na jʉ̃go ásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Camasã pʉame Jesús topʉ cʉ̃ caátóre tʉ̃goyuparã. Bairo tʉ̃go yua, cʉ̃ berore ʉsayuparã. Bairo Jesús na caʉsaetarore ĩña, caroaro mena na bocáyupʉ. Bairo na bocá yua, Dios cʉ̃ carotimasĩrĩpaʉ caetarore na ĩ quetibʉjʉyupʉ. Tunu bairoa aperã cariayecʉnarẽ na catioyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bairo yoaro capee cʉ̃ caáto jeto, ñamicããcã nicoasuparo. Bairi cʉ̃ cabuerã pʉame Jesutʉ etari, atore bairo qũĩñuparã: —Ãnoa camasã capããrã niñama. Tunu atopʉre wiiri maniña. Bairi ãnoarẽ na árotiya macããpʉ, topʉ yerijã, na caʉgaparore bairo ĩ —qũĩñuparã cʉ̃ cabuerã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bairo na caĩrõ tʉ̃gomicʉ̃ã, atore bairo na ĩñupʉ̃ Jesús: —Mʉjãã majũ na ʉgarique nuña. Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñuparã na pʉame: —Jãã, jĩcã wãmo cãrõ pan jororiaca, wai pʉgarããcã, tocãrõã jãã cʉ̃goya, ãnoa na caʉgapeere macãpʉ jãã cawapatijeápericõãta —qũĩñuparã cʉ̃ cabuerã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mai, topʉ ãñuparã jĩcã wãmo cãnacã mil majũ camasã, Jesús cʉ̃ cabuerijere catʉ̃goatána pʉame. Tocãrõ na caãnimiatacʉ̃ãrẽ, atore bairo na ĩnemoñupʉ̃ Jesús tunu cʉ̃ cabuerãrẽ: —Camasãrẽ na ruirotiya. Rupa poari na ruirotiya. Cincuenta majũ jĩcã poare na ãmarõ —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bairo cʉ̃ caĩrõ tʉ̃go, “Jaʉ,” ĩ, cʉ̃ caĩrõrẽ bairo ásuparã. Bairi nipetiro camasã ape poa, ape poa ruiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús pʉame bairo na caruiro ĩña, pan rupa, wai mena nerĩ, jõbuire ĩñamʉgõjori, “Jãã Pacʉ, mʉ ñujãñuña jãã mena,” qũĩ jẽniñupʉ̃ Jesús Diore. Bairo qũĩ jẽni yaparo, pan rupare carecomacã peeri, wai cʉ̃ãrẽ carecomacã peeri, cʉ̃ cabuerãrẽ na nuniñupʉ̃, camasãrẽ na cabatoparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bairo áticõã yua, nipetiro camasã caroaro ʉga yapicoasuparã ʉgarique na cabatoatajere. Bairo na caʉgayaparoro bero, jejããñuparã piiripʉ na caʉgarʉgarijere. Pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã piiri majũ jejãã jiroyuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ape rʉ̃mʉ Jesús jĩcãʉ̃ã ãcʉ̃, Diore cʉ̃ jẽni baiyupʉ. Bairo cʉ̃ cabairo, cʉ̃ cabuerã pʉame cʉ̃tʉ etayuparã. Bairo na caetaro ĩña, atore bairo na ĩ jẽniñañupʉ̃ Jesús: —“¿Noa ãcʉ̃mi?” yʉ na ĩnucũñati camasã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñuparã Jesure cʉ̃ cabuerã pʉame: —Jĩcããrã ĩñama: “Juan el Bautista ãcʉ̃mi.” Aperã ĩnucũñama: “Elías ãnacʉ̃ catiri ãcʉ̃mi,” miñama. Aperã ĩnucũñama: “Tirʉ̃mʉpʉ caãnana profeta majã mena macããcʉ̃ jĩcãʉ̃ catiri caatácʉ ãcʉ̃mi,” minucũñama —qũĩ quetibʉjʉyuparã cʉ̃ cabuerã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bairo na caĩquetibʉjʉro bero, na ĩ jẽniñanemoñupʉ̃ tunu Jesús: —¿Mʉjãã ate? “¿Noa ãcʉ̃mi?” yʉ mʉjãã ĩnucũñati —na ĩ jẽniñañupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, jicoquei Pedro pʉame qũĩñupʉ̃ Jesure: —Mʉa, Mesías, Dios cʉ̃ cajoʉ, mʉ ãniña —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bairo cʉ̃ caĩrõ tʉ̃go, na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ: “Cʉ̃ã yʉ ãniña. Bairo cʉ̃ã yʉ caãnimiatacʉ̃ãrẽ, bairãpʉa mai, na quetibʉjʉeticõãña aperãrẽ.” ");
INSERT INTO cbcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ĩ quetibʉjʉ yaparo, atore bairo na ĩ ĩnemoñupʉ̃ tunu Jesús cʉ̃ cabuerãrẽ: —Yʉ, Camasã Jʉ̃gocʉ, bʉtioro popiye yʉ baigʉ. Marĩ quetiuparã cabʉtoa camasĩrã pʉame popiye yʉ baio joroque yʉ átigarãma. Dios cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã cʉ̃ã yʉ tejãñugarãma. Sacerdote majã quetiuparã cʉ̃ã yʉ tejãñugarãma. Bairo bairi yʉ pajĩã rotigarãma. Bairo yʉ na capajĩãrõ, cariacoatacʉ nimicʉ̃ã, itia rʉ̃mʉ bero yʉ caticoagʉ tunu —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cabero atore bairo na ĩ quetibʉjʉyupʉ Jesús tunu nipetirãrẽ: —Ni caboʉ, yʉ cabuei caãnigaʉ, cʉ̃ caátimirĩjẽrẽ jãnagʉmi. Yʉ carotirore bairo jeto roque átigʉmi tocãnacã rʉ̃mʉa. Popiye riaricaro cãrõ baimicʉ̃ã, yʉ yaye quetire jãnaetigʉmi, yʉ cabuei caãnigaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bairo tunu caʉ̃mʉ apei cʉ̃ caãnie pʉamerẽ mairĩ, yʉ yaye quetire jãnacoagʉmi. Bairo maimicʉ̃ã, yasicoagʉmi yua. Apei roque yʉ yaye quetire cajãnaecʉ roque netõcõãgʉmi. Cʉ̃rẽ na capajĩã rocacõãmiatacʉ̃ãrẽ, caticõã ãninucũgʉmi tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tunu caʉ̃mʉ apei ati yepa macããjẽ nipetirije merẽ cʉ̃goyami, cʉ̃ caborije caãno cãrõ. Bairo cʉ̃gomicʉ̃ã, Diore cʉ̃ tʉ̃goñaẽtĩñami. Bairo catʉ̃goñaecʉ̃ ãnirĩ cʉ̃ cariaatato bero Dios mena ãmerĩgʉmi. Bairi dope baieto pairo cʉ̃ cacʉ̃gorije pʉame. Wapa maa tie ati ʉmʉrecóo macããjẽ, Diore cʉ̃ camasĩẽtĩcõãta. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bairi ni jĩcãʉ̃ ũcʉ̃ yʉre tʉ̃goñabobori, o yʉ yaye queti cʉ̃ãrẽ tʉ̃goñabobori, “Jesús yaʉ yʉ ãniña,” cʉ̃ caĩquetibʉjʉgaeticõãta, yʉ cʉ̃ã, “Ãni, yʉ yaʉ niñami,” cʉ̃ ñi masĩẽtĩgʉ. Yʉ, Camasã Jʉ̃gocʉ, ati yepapʉ yʉ Pacʉ cʉ̃ camasĩrĩjẽ mena nemo yʉ catunuetaro, “Ãni, yʉ yaʉ niñami,” cʉ̃ ñi masĩẽtĩgʉ. Ángelea majã jõbui macããna, cañurã mena tunu yʉ catunuetaro, bairo cʉ̃ ñimasĩẽtĩgʉ ni jĩcãʉ̃rẽ yʉre tʉ̃goñabobori, “Jesús yaʉ yʉ ãniña,” cʉ̃ caĩquetibʉjʉgaeticõãta. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cariape mʉjããrẽ yʉ quetibʉjʉya: Mʉjãã jĩcããrã, ato caãna, mʉjãã cariaparo jʉ̃goye mʉjãã ĩñagarã Dios cʉ̃ carotimasĩrĩpaʉ majũrẽ —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cabero Jesús atiere na quetibʉjʉri bero, jĩcã wãmo peti itia pẽnirõ cãnacã rʉ̃mʉrĩ bero, Pedrore, Juarẽ, bairi Santiagore, “Jito,” na ĩñupʉ̃ Jesús. Bairi ʉ̃tãʉ̃ caʉ̃mʉarĩcʉ buipʉ na mena wãmʉ ásúpʉ Jesús. Diore qũĩ jẽniácʉ, topʉ na jʉ̃goásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bairo cʉ̃ cajẽniãno, Jesús riapé cʉ̃ baurique wasoacoasuparo. Baicõã, cʉ̃ jutiro cʉ̃ã botiro baicoasuparo. Asiyaʉ baicoasupʉ Jesús yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Bairo cʉ̃ cabaiãno, caʉ̃mʉa pʉgarã asiyarije mena buiaetayuparã. Na pʉame, Moisés ãnacʉ̃, bairi Elías ãnacʉ̃ ãñuparã Jesutʉ cabuiaetarã. Bairo buiaeta yua, Jesús mena bʉsʉpẽniñuparã Jerusalẽpʉ cʉ̃ cariápeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bairo na caĩãno, Pedrojãã wʉgoa paimirãcʉ̃ã, Jesús bairi cʉ̃ mena macããna pʉgarã na caasiyarijere ĩña acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bairo cabero Jesús mena macããna na caátípaʉa, Pedro pʉame dope bairo ĩ masĩẽtĩrĩ, atore bairo qũĩñupʉ̃ Jesure: —Jããrẽ cabuei, ¡atopʉ marĩ caãno ñumajũcõãña! Bairi itia wiipãĩrĩãcã majũ mʉjããrẽ jãã qũẽnobojagarã. Jĩcã wii mʉ ya wii, ape wii Moisés ya wii, ape wii Elías ya wii mʉjããrẽ jãã qũẽnobojagarã —qũĩñupʉ̃ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bairo cʉ̃ caĩãno, buseriwo atí na tocoasuparo. Bairo catoro, Pedrojãã pʉame tipoa toyepʉ ãñuparã. Bairi bʉtioro uwiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bairo na cabairo, bʉsʉrique buseriwo watoapʉ cabʉsʉocajorijere tʉ̃goyuparã. Atore bairo ĩñuparõ: “Ãni, yʉ macʉ̃, yʉ cabesericʉ majũ niñami. Cʉ̃ yaye bʉsʉriquere tʉ̃goʉsaya,” ĩ ocajoyuparo jõbuipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bairo caĩrõ bero, Moisés, bairi Elíajãã mañuparã. Jĩcãʉ̃ã tuayupʉ Jesús jeto yua. Tie na caĩñaatajere quetibʉjʉesuparã Pedrojãã aperãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti rʉ̃mʉ, cabusuri rʉ̃mʉ Jesujãã ti ʉ̃tãʉ̃rẽ ruicoasuparã. Bairo na caruietaro bero, capããrã camasã Jesutʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bairi jĩcãʉ̃ na mena macããcʉ̃ bʉsʉrique tutuaro mena qũĩñupʉ̃ Jesure: —Cabuei, qũĩñaʉasá yʉ macʉ̃rẽ. Jĩcãʉ̃ã caãcʉ̃ niñami yʉ macʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wãtĩ yeri pũna pʉame cʉ̃ mecʉ̃õ joroque átinucũñami yʉ macʉ̃rẽ. Bairo cʉ̃ awajao joroque cʉ̃ átinucũñami. Tunu cʉ̃ yugui mecʉ̃õ joroque cʉ̃ átinucũñami, cʉ̃ risero jopo witirinʉcʉ̃pʉ̃. Roro popiye cʉ̃ baio joroque cʉ̃ átinucũñami. Pitigaetiyami wãtĩ yeri pũna yʉ macʉ̃rẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bairi mʉ cabuerãrẽ bʉtioro na yʉ wiyorotimiapʉ wãtĩ yeri pũnarẽ. Mʉ cabuerã pʉame na wiyojo masĩẽtĩñama —qũĩ quetibʉjʉyupʉ wãtĩ yeri pũna cacʉ̃goʉ pacʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —¡Mʉjãã, ati yepa caãna Dios cʉ̃ camasĩrĩjẽrẽ cariape mʉjãã tʉ̃goetimajũcõãña! ¿Nocãrõ yoaro mʉjãã mena yʉ ãnibujiocʉti? Jaʉ, mʉ macʉ̃rẽ cʉ̃ neasá toroque —qũĩñupʉ̃ Jesús cariaʉ pacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bairo cawãmaʉ pʉame Jesutʉ cʉ̃ caetaripaʉ yua, wãtĩ yeri pũna pʉame cʉ̃ jʉ̃goñañupʉ̃ yepapʉ. Bairo cʉ̃ jʉ̃goñaʉ, riañarĩqũẽrẽ bairo cʉ̃ ásupʉ tunu. Bairo cʉ̃ caáto, Jesús pʉame cʉ̃ jãnaoñupʉ̃ wãtĩ roro caácʉre. Cʉ̃ acuwiyo joyupʉ yua. Bairo cʉ̃ caáto, cawãmaʉ pʉame caticoasupʉ. Cʉ̃ cacatiro ĩña, cʉ̃ pacʉre cʉ̃ tunuoñupʉ̃ Jesús cʉ̃ macʉ̃rẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bairi camasã pʉame bairo Dios cʉ̃ camasĩrĩjẽ jʉ̃gori Jesús cʉ̃ caáto ĩñarã, bʉtioro tʉ̃gocõã maniásuparã. Bairo to macããna Jesús capee caroaro cʉ̃ caátiere na catʉ̃goñacõã maniátipaʉa Jesús pʉame atore bairo na ĩñupʉ̃ cʉ̃ cabuerãrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ãmeacã mʉjãã yʉ caquetibʉjʉrijere tʉ̃gopeoya. Mʉjãã masiritiepa. Yʉ, Camasã Jʉ̃gocʉ, yʉ ñerotiecogʉ camasãrẽ —na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na pʉame tie cʉ̃ caĩrĩjẽrẽ tʉ̃gomajũcõãmirãcʉ̃ã, tiere tʉ̃gomasĩẽsuparã. Dios na catʉ̃gomasĩpeere na joesupʉ mai. Tunu bairoa Jesure cʉ̃ jẽniña uwijãñuñuparã tiere. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Cabero tunu ãmeo ĩ bʉsʉyuparã cʉ̃ cabuerã na majũ: “¿Ni majũ cʉ̃ ãnicʉti marĩ menarẽ caãnimajũʉ̃rẽ bairo caãcʉ̃?” ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús pʉame masĩcõãñupʉ̃ na caĩrĩjẽrẽ. Bairo masĩrĩ yua, cawĩmaʉacarẽ cʉ̃tʉ cʉ̃ tʉ̃gãẽtoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bairo áticõã, atore bairo na ĩ quetibʉjʉyupʉ. Jesús cʉ̃ cabuerãrẽ: —Ni jĩcãʉ̃ ũcʉ̃, yʉ yaye quetire tʉ̃goʉsari, ãni cawĩmaʉrẽ bairo caãcʉ̃rẽ cʉ̃ camaiata, yʉre camairẽ bairo cʉ̃ ñiñagʉ. Tunu bairoa yʉre camai cʉ̃ caãnoi, yʉ jeto mee Dios yʉre cajoricʉ cʉ̃ã cʉ̃rẽ camairẽ bairo qũĩñagʉmi. Ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃, mʉjãã roca netõjãñurõ carotimasĩ pʉame mʉjãã netõjãñurõ caãnimajũʉ̃rẽ bairo qũĩñagʉmi Dios —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan pʉame atore bairo qũĩñupʉ̃ Jesure: —Jããrẽ cabuei, apei caʉ̃mʉrẽ jãã ĩñawʉ̃. Cʉ̃ pʉame mʉ wãme mena ĩrĩ rotimasĩwĩ. Bairo rotimasĩrĩ yua, cʉ̃ acurewiyojowĩ wãtĩ yeri pũnarẽ, caʉ̃mʉrẽ cajãñamiatacʉre. Bairo cʉ̃ caáto ĩña, jãã pʉame cʉ̃ caátiere cʉ̃ jãã átirotiepʉ, marĩ mena macããcʉ̃ cʉ̃ caãmerõĩ —qũĩñupʉ̃ Juan Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús Juarẽ: —¿Nopẽĩrã cʉ̃rẽ, “Ápeina,” mʉjãã ĩrĩ? Bairo ĩẽtĩcõãña. Jĩcãʉ̃ ũcʉ̃ caʉ̃mʉ marĩrẽ cʉ̃ catutieticõãta, marĩrẽ cajʉácʉre bairo caácʉ niñami —na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cabero Jesús pʉame jõbuipʉ cʉ̃ pacʉtʉ cʉ̃ caátí rʉ̃mʉ caetagaro ĩña yua, yeri tutuarique mena Jerusalẽpʉ ájʉ̃goyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bairi cʉ̃ jʉ̃goye cʉ̃ mena macããnarẽ, Samaria yepa macãrẽ na ájʉ̃gorotiyupʉ, “Atíyami jããrẽ cabuei,” na ĩáto, ĩ. Narẽ caqũẽnoparãrẽ boʉ, topʉ na ájʉ̃gorotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bairo topʉ cʉ̃ cajomiatacʉ̃ãrẽ, to Samaria macããna pʉame na caetaro boesuparã. “Jerusalẽpʉ ácʉ́ baiyami Jesús,” na caĩrĩjẽrẽ na catʉ̃goatato bero jʉ̃gori, na boesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bairo Jesure na caboeto ĩñarã, cʉ̃ cabuerã, Santiago, Juajãã pʉame atore bairo Jesure qũĩñuparã: —Jãã Quetiupaʉ, ¿peero, jõbui macãã peeroi na marĩ joerecʉti? Roro na caĩrĩjẽ wapai, ¿Elías ãnacʉ̃ cʉ̃ caátatore bairo na marĩ áti yasiorecʉti? —qũĩñuparã cʉ̃ cabuerã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bairo na caĩrõ tʉ̃go, narẽ ãmejore ĩña, na ĩ tutiyupʉ Jesús cʉ̃ cabuerãrẽ: “Mʉjãã masĩẽtĩña mʉjãã caĩrĩjẽrẽ. Wãtĩ cʉ̃ carotirore bairo mʉjãã tʉ̃goñaña. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yʉa, Camasã Jʉ̃gocʉ, camasãrẽ na rei ácʉ mee yʉ apʉ́. Na netõõʉ̃ ácʉ yʉ apʉ́ ati yepapʉre,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. Bairo ĩ quetibʉjʉ yaparo, na jʉ̃goacoásúpʉ ape macãpʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bairo maapʉ na caátó, jĩcãʉ̃ caʉ̃mʉ Jesutʉ etayupʉ. Cʉ̃tʉ eta yua, atore bairo qũĩñupʉ̃ Jesure: —Yʉ cʉ̃ã, mʉ cabuei yʉ ãnigaya. Bairi noo mʉ cañesẽãrõpʉ yʉ ágʉ yʉ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Macãnʉcʉ̃ macããna waibʉtoa na caãnipaʉri cʉ̃goyama. Minia cʉ̃ã na riabatiri na caãnipaʉrire cʉ̃goyama. Bairo na cacʉ̃gomiatacʉ̃ãrẽ, yʉa, Camasã Jʉ̃gocʉ, yʉ caãnipaʉ ũno yʉ cʉ̃goetiya —qũĩñupʉ̃ Jesús caʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Cabero apeire qũĩñupʉ̃ tunu: —Jito, yʉ bapacʉsa. Bairo cʉ̃ caĩrõ tʉ̃go, caʉ̃mʉ pʉame “Jaʉ,” ĩmicʉ̃ã, atore bairo qũĩnemoñupʉ̃: —Yʉ Quetiupaʉ, mai mʉ mena yʉ bapacʉperigʉ. Yʉ pacʉre cʉ̃ cotei ácʉ yʉ baiya. Cʉ̃ cariacoato bero roque, mʉ mena yʉ ábujioʉ —qũĩñupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Camasã cariacoatanarẽ bairo caãna pʉame na qũẽnoáto cabaiyasirãrẽ, ñiña. Mʉ pʉame Dios cʉ̃ carotimasĩrĩpaʉ caetarore mʉ quetibʉjʉ ñesẽãgʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Cabero tunu apei qũĩñupʉ̃ Jesure: —Jãã Quetiupaʉ, yʉ cʉ̃ã mʉ mena yʉ bapacʉtigʉ. Baipʉa mai, cajʉ̃goye yʉ ya wii macããnarẽ na ñiñagʉ. “Ácʉ́ yʉ baiya marĩrẽ cabuei mena,” na ñiágʉ mai —qũĩñupʉ̃ apei caʉ̃mʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Ni jĩcãʉ̃ ũcʉ̃ jĩcã yeri mena caroaro Dios cʉ̃ carotiriquere cʉ̃ catʉ̃goʉsaeticõãta, ñuẽtĩña. Ape wãme, ape wãme ricaati tʉ̃goñarĩqũẽrẽ cʉ̃ catʉ̃goñaata, ñuẽtĩña. Bairi yua, Dios cʉ̃ carotimasĩrĩpaʉre dope bairo átimasĩã maniñami —qũĩñupʉ̃ Jesús caʉ̃mʉ apeire. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cabero Jesús, marĩ Quetiupaʉ, cʉ̃ caquetibʉjʉrotijoparã setenta y dos majũ caʉ̃mʉarẽ na beseyupʉ. Bairo na beseri bero yua, tocãnacã macãã, pʉgarã jeto cʉ̃ caetaparopʉ na ájʉ̃go rotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mai, na caápáro jʉ̃goye atore bairo na ĩñupʉ̃: “Oterique camasã na cajepee pairo caãnimiatacʉ̃ãrẽ, tie uparãrẽ cajʉjeparã pʉame capããrã mee niñama. Torea bairo Dios yaye quetire catʉ̃goʉsaparã capããrã na caãnimiatacʉ̃ãrẽ, marĩrẽ cajʉquetibʉjʉparã pʉame capããrã mee niñama. Bairo na cabairoi, marĩ Pacʉ Diore mʉjãã cajẽnirõ boya. Cʉ̃ pʉame oterique Upaʉre bairo cʉ̃ yaye bʉsʉrique cajʉquetibʉjʉ batoparãrẽ na jomasĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tʉ̃goya, ãmerẽ mʉjããrẽ caroa quetire yʉ quetibʉjʉ rotijoya. Corderos nurĩcãrã, macãnʉcʉ̃ macããna lobos cauwiorã watoa na caãno uwiojãñuña. Torea bairo mʉjãã pʉame camasã watoa mʉjãã caãno uwiojãñugaro. Bairi masacatiri mʉjãã cañesẽãrõ ñuña,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bairo na ĩ yaparo, atore bairo na ĩ quetibʉjʉnemoñupʉ̃ Jesús tunu: “Bairo áná, dinero jããrĩcã poa, bairi waso poa cʉ̃ãrẽ, bairi rʉpo jutii cʉ̃ãrẽ mʉjãã jee ápewa. Tunu maapʉ mʉjãã cabocáetarãrẽ na mena mʉjãã bʉsʉpẽniepa. Cariapea mʉjãã acoápá. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bairi jĩcã wii ũno etarã, ‘Dios caroa yericʉtaje cʉ̃ joáto ati wii macããnarẽ,’ mʉjãã ĩ etagarã ti wiire. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bairi ti wii macããna pʉame caroaro mena mʉjããrẽ na cajẽniata, mʉjãã caĩrõrẽã bairo caroa yericʉtajere na jogʉmi Dios. Baipʉa, caroaro mena mʉjããrẽ na cajẽnieticõãta, mʉjãã caĩrõrẽ bairo na áperigʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bairo mʉjããrẽ caqũẽnorãrẽ bócarã yua, na ya wiipʉ mʉjãã ãnicõãwã. Capee wiiripʉ patowãcõẽtĩcõãña. Bairi jĩcã wiia ãni, mʉjããrẽ na canurĩjẽ jetore mʉjãã ʉgawã. Mʉjãã, paari majã ãnirĩ, mʉjãã ʉgamasĩña na canurĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bairo bairi jĩcã macã ũno etarã, mʉjããrẽ caroaro na cajẽniata, na yaye ʉgarique na canurĩjẽ jetore ʉgaya. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tunu bairoa ti macã macããna cariayecʉnarẽ na catioya. Tunu atore bairo na ĩ quetibʉjʉya: ‘Dios cʉ̃ carotimasĩrĩpaʉ merẽ etaro baiya ati yepapʉre.’ ");
INSERT INTO cbcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bairo mʉjãã caquetibʉjʉñesẽãrõ, di macã macããna ũna mʉjããrẽ caroaro mena na cajẽnieticõãta, ti macã maapʉ nipetiro camasã na catʉ̃goropʉ atore bairo na mʉjãã ĩgarã: ");
INSERT INTO cbcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Jãã yaye quetire mʉjãã catʉ̃gogaetoi, mʉjãã ya macã ñerĩrẽ jãã rʉpo jutii catusarijere jãã pareya! Ape macãpʉ jãã áya. Bairo jãã caápáro jʉ̃goye tʉ̃gopeoya mai. Jãã yaye quetire mʉjãã catʉ̃goata, Dios cʉ̃ carotimasĩrĩpaʉ macããjẽrẽ mʉjãã tʉ̃gobujiorã,’ na mʉjãã ĩgarã ti macã macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉjãã, yʉ yarã cariape mʉjããrẽ ñiña: To macããna mʉjããrẽ na catʉ̃goetie wapa, Dios pʉame roro na átigʉmi. Camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉrẽ Sodoma macããna netõjãñurõ popiye na baio joroque na átigʉmi,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bairo na ĩ yaparo, atore bairo na ĩnemoñupʉ̃ tunu Jesús ape macãã macããnarẽ, Corazín, bairi Betsaida macãã macããnarẽ: “¡Roro majũ baigarãma to Corazín macã macããna! ¡Roro majũ baigarãma Betsaida macã macããna cʉ̃ã! Dios cʉ̃ caátijẽñoĩñorĩjẽ capeere ĩñawã. Bairo caĩñarã nimirãcʉ̃ã, roro na caátiere jãnagaema. Tirʉ̃mʉpʉ macããna Tiro, Sidón macããna ãnana, Corazín, Betsaida macããna na caĩñarĩcãrõrẽã bairo na cʉ̃ã na caĩñaata, roro na caátajere jãnabujioricarãma Tiro, Sidón macããna pʉame. Bʉtioro yapapuarã na cajãñarĩjẽ jutii ũnierẽ jãñabujioricarãma. Tunu peero õwãwopʉ ruibujioricarãma, bʉtioro na cayapapuarijere ĩñorã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bairi camasãrẽ Dios cʉ̃ caĩñabeseri rʉ̃mʉ caetaro Corazín, bairi Betsaida macãã macããna pʉame, Tiro, Sidón macãã macããna netõjãñurõ popiye baigarãma yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Torea bairo Capernaum macã macããna cʉ̃ã baigarãma. ‘Jõbuipʉ jãã ágarã,’ caĩtʉ̃goñarã na caãnimiatacʉ̃ãrẽ, ¡caʉ̃cʉ̃ãrĩ opepʉ roquere na regʉmi Dios!” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ Corazín, Betsaida, Capernaum macãã macããna na cabaipeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bairo na ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Yʉ cabuerã, ni jĩcãʉ̃ ũcʉ̃ mʉjãã yaye quetire catʉ̃goʉ, yʉ yaye quetire catʉ̃goʉre bairo niñami. Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ apei mʉjãã yaye quetire catʉ̃gogaecʉ, yʉ yaye quetire catʉ̃gogaecʉre bairo niñami. Bairo caãcʉ̃ ãnirĩ Dios, yʉre cajoricʉ yaye queti cʉ̃ãrẽ caboecʉre bairo niñami,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Cabero Jesús cʉ̃ caquetibʉjʉrotijoricarã setenta y dos majũ ʉseanirĩqũẽ mena tunu etayuparã caquetibʉjʉñesẽãrátána. Bairo etarã yua, atore bairo qũĩ quetibʉjʉyuparã Jesure: —¡Jãã Quetiupaʉ mʉ wãmei jãã caĩjẽnirõ, wãtĩ yeri pũna cʉ̃ã jãã caĩrotirorea bairo baimajũcõãñama! —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Ñuña mʉjãã caátiataje. Yʉ pʉame wãtĩ quetiupaʉ jõbuipʉ caãnimiatacʉ cʉ̃ cañarõrẽ ñiñajoapʉ. Cabʉpo yaberije cañarõrẽ bairo majũ ñaami. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mʉjããrẽ masĩrĩqũẽrẽ yʉ jowʉ, ãña mʉjããrẽ cʉ̃ cabacamiatacʉ̃ãrẽ, mʉjãã cariaetiparore bairo ĩ, o cotapa mʉjããrẽ cʉ̃ catoamiatacʉ̃ãrẽ, mʉjãã cariaetiparore bairo ĩ. Tunu bairoa mʉjããrẽ masĩrĩqũẽrẽ yʉ jowʉ, marĩ pesu wãtĩ cʉ̃ catutuarije nipetirijere mʉjãã canetõparore bairo ĩ. Bairo tie masĩrĩqũẽrẽ cacʉ̃gorã ãnirĩ, dise ũnie wãtĩ roro mʉjããrẽ cʉ̃ caátigamirĩjẽrẽ mʉjãã tãmuoetinucũgarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bairãpʉa, wãtĩ yeri pũnarẽ cawitiroti jomasĩrã nimirãcʉ̃ã, tie jetore mʉjãã catʉ̃goñarõ boetiya. Jõbuipʉ Dios ya pũrõpʉ mʉjãã caãno cãrõ mʉjãã wãmerĩrẽ cʉ̃ cawoaturicarã mʉjãã ãniña. Tie pʉamerẽ tʉ̃goñajesoya —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bairo tipaʉa bʉtioro Espíritu Santo mena ãnirĩ atore bairo ʉseanirĩqũẽ mena Diore qũĩ basapeoyupʉ Jesús: “Caacʉ, mʉ, ati ʉmʉrecóo nipetiro upaʉ, mʉ ñujãñuña yʉ yarã mena. Naa, cabʉgoro macããnarẽ bairo caãna na caãnimiatacʉ̃ãrẽ, masĩrĩqũẽrẽ na mʉ joyupa. Aperã, ati yepa macããna, ‘Marĩ roque marĩ masĩnetõña’ caĩrã pʉamerẽ na mʉ joetiya. Caacʉ, tore bairo mʉ ásupa mʉ cabojʉ̃goyetiricarore bairo caãno jʉ̃gori,” qũĩ jẽniñupʉ̃ Jesús cʉ̃ pacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bairo qũĩ jẽni yaparo, atore bairo na ĩñupʉ̃ Jesús cʉ̃tʉ caãnarẽ: “Yʉ Pacʉ pʉame nipetirije masĩrĩqũẽrẽ yʉ jowĩ. Tunu yʉ caátiãnie cʉ̃ãrẽ yʉ Pacʉ jeto masĩñami. Tunu cʉ̃ caátiãnierẽ yʉ cʉ̃ã yʉ masĩpeyocõãña. Bairi yʉ cʉ̃ã yʉ jeto na yʉ masĩõmasĩña camasã yʉ cabeserãrẽ yʉ Pacʉ cʉ̃ caátiãnierẽ,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Bairo ĩ yaparo, cʉ̃ cabuerãrẽ na ãmejore ĩña, atore bairo na ĩñupʉ̃ na jetore: “Tirʉ̃mʉpʉ macããna profeta majã capããrã mʉjãã caĩñarĩjẽ ũnierẽ ĩñagamiñupã. Quetiuparã ãnana cʉ̃ã tiere ĩñagamiñupã. Mʉjãã catʉ̃gorije ũnie cʉ̃ãrẽ tʉ̃gogamiñupã. Bairi mʉjãã pʉame capee ĩña, tʉ̃go caãna ãnirĩ ʉseanirĩ ãña,” na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cabero jĩcãʉ̃, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuei Jesús tʉpʉ etayupʉ. “Cariape cʉ̃ quetibʉjʉyati Jesús,” ĩ masĩgʉ, cʉ̃tʉ etayupʉ. Bairo cʉ̃tʉ eta, atore bairo qũĩ jẽniñañupʉ̃ Jesure: —Jããrẽ cabuei, ¿dope bairo yʉ ácʉati Dios tʉpʉ cariamanopʉ ágʉa? —qũĩ jẽniñañupʉ̃ cajʉ̃gobuei Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ na cawoaturica pũrõpʉ mʉ caĩñaata, ¿nopẽ ĩgaro tie bairo to ĩcʉti mʉrã? —qũĩ jẽniñañupʉ̃ Jesús cajʉ̃gobueire. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesure: —Atore bairo ĩña ti pũrõpʉ: ‘Mʉjãã, Israel macããna, mʉjãã caátiãnie nipetirije mena cʉ̃ maiña. Tunu bairoa mʉjãã yeripʉ, mʉjãã catʉ̃goñarĩjẽ nipetirije mena cʉ̃ maiña. Tunu bairoa mʉjãã catutuarije nipetirije mena cʉ̃ maiña.’ Tunu torea bairo: ‘Mʉjããtʉ macããna cʉ̃ãrẽ mʉjãã rupaʉre mʉjãã camairõrẽã bairo na maiña,’ ĩ quetibʉjʉyupi ti pũrõpʉ —qũĩñupʉ̃ cajʉ̃gobuei Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Cariape miña. Tore bairo ĩ woatuyupi Moisés ãnacʉ̃. Bairo bairi cʉ̃ caĩrĩcãrõrẽã bairo caroaro cariape mʉ caápata, Dios tʉpʉ cariamanopʉ mʉ ágʉ —qũĩ quetibʉjʉyupʉ Jesús Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueire. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bairo cʉ̃ caĩrõ tʉ̃gomicʉ̃ã, cʉ̃ caĩrõrẽ bairo átigaesupʉ. Bairi atore bairo qũĩ jẽniñanemoñupʉ̃ Jesure tunu: —¿Noa ũna na ãniñati marĩ yarã, marĩ rupaʉre bairo marĩ camaiparã? ");
INSERT INTO cbcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bairo cʉ̃ caĩrõ tʉ̃go, ĩcõñarĩ atore bairo qũĩñupʉ̃ Jesús cajʉ̃gobueire: —Jĩcãʉ̃ Jerusalẽpʉ caãniatacʉ Jericó macãpʉ ásúpʉ. Bairo ti macãpʉ cʉ̃ caetaparo jʉ̃goye jerutiri majã pʉame maapʉ cʉ̃ bocáetayuparã. Cʉ̃ bocáeta yua, roro cʉ̃ ásuparã. Cʉ̃ apeyere, cʉ̃ jutii nipetirijere jeyuparã. Jee yaparo, cʉ̃ payuparã bʉtioro, ñe mano riaricaropʉ. Áticõã yua, ruticoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bairo na caátó bero, jĩcãʉ̃ sacerdote na caqũẽatacʉ cʉ̃ cacũñarĩ wããrẽ ásúpʉ cʉ̃ cʉ̃ã. Bairo ácʉ́, etayupʉ na caqũẽatacʉtʉre. Bairo qũĩñamicʉ̃ã, cʉ̃ owanetõcoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bairo cʉ̃ canetõátó bero, apei tunu levita poa macããcʉ̃ etayupʉ. Bairo eta, qũĩña, cʉ̃ owanetõcoásúpʉ cʉ̃ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bairo na canetõátó bero, apei tunu Samaria yepa macããcʉ̃ etayupʉ. Bairo eta, bopacooro qũĩñañupʉ̃ na caqũẽatacʉre, Samaria yepa macããcʉ̃ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Qũĩña mai yua, cʉ̃tʉ eta, cʉ̃ cãmiirẽ cʉ̃ ʉcotiyupʉ. Aceite, bairi ʉse oco majũ mena cʉ̃ cãmiirẽ cʉ̃ ʉcotiyupʉ. Tunu jutii mena cʉ̃ cãmiirẽ jiyayupʉ. Áti yaparo, cʉ̃ yaʉ burro buipʉ cariaʉre cʉ̃ nepeoyupʉ. Bairo áti, cʉ̃ neásúpʉ camasã ñesẽãrĩ majã na cacãnirĩ wiipʉ. Topʉ ãcʉ̃, cʉ̃ ʉcotinemoñupʉ̃ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ape rʉ̃mʉ, cabusuri rʉ̃mʉ cʉ̃ caápáro jʉ̃goye Samaria yepa macããcʉ̃ pʉame atore bairo qũĩñupʉ̃ ti wii upaʉre: “Ʉ̃jʉ̃, pʉga denario moneda tiiri mʉ yʉ nuniña. Ãni, yʉ caneatíatacʉre cʉ̃ mʉ caqũẽnorõ yʉ boya. Mʉrẽ yʉ canunirĩjẽ to caetaeticõãta, cabero acʉ́pʉ, mʉ yʉ wapatinemogʉ tunu,” qũĩñupʉ̃ Samaria yepa macããcʉ̃ ti wii upaʉre —bairo ĩcõñarĩ quetibʉjʉyupʉ Jesús cajʉ̃gobueire. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bairo ĩcõñarĩ bero, atore bairo qũĩnemoñupʉ̃: —¿Dope bairo mʉ tʉ̃goñañati? Camasã itiarã qũĩñañuparã jerutiri majã na caqũẽatacʉre. Bairi, ¿ni pʉame cʉ̃ yaʉre bairo qũĩñañuparĩ? —qũĩ jẽniñañupʉ̃ Jesús cajʉ̃gobueire. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesure: —Cʉ̃rẽ caĩñamairĩcʉ̃ pʉame cʉ̃ yaʉre bairo qũĩñañupĩ —qũĩñupʉ̃ cajʉ̃gobuei pʉame. Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Bairo baimajũcõãñupĩ. Bairi mʉ cʉ̃ã cʉ̃rẽ bairo ácʉja. Aperã mʉ yarã, mʉ ũnarẽ, mʉ rupaʉre mʉ camairõrẽ bairo na mʉ jʉátinemogʉ na cʉ̃ãrẽ —qũĩñupʉ̃ Jesús, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuei pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Cabero netõásúpʉ Jesús. Bairo ácʉ́, jĩcã macãpʉ etayupʉ tunu. Topʉ cʉ̃ caetaro, jĩcã wii macããcõ, Marta cawãmecʉco pʉame bairo qũĩñupõ: “Jãã mena ʉgaʉ asá.” ");
INSERT INTO cbcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mai, Marta pʉame baiocʉsupo, María cawãmecʉcore. Bairo Jesús na ya wii cʉ̃ caetaro, María cʉ̃ rʉporitʉre etanumuñupõ. Jesús cʉ̃ caquetibʉjʉrijere bʉtioro tʉ̃gogayupo. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta pʉame jesaesupo: “Yʉ jeto paarique nipetirijere yʉ átimiña,” ĩ tʉ̃goñañupõ. Bairi Jesutʉ cõ baio cõ caruiro ĩñarĩ, Jesure qũĩñupõ: —Yʉ Quetiupaʉ, ¿yʉ cabairijere mʉ tʉ̃goñaẽtĩñati? Yʉ baio pʉame yʉ jʉáperiyamo. ¿Bairo cõ cabairije to ñuñati mʉrã? Jĩcãõã yʉ pʉame yʉ paaya. Bairi, “Cõ jʉpaoja,” cõ ĩña —qũĩñupõ Marta Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bairo cõ caĩrõ tʉ̃go, atore bairo cõ ĩñupʉ̃ Jesús: —Marta, mʉa, capee apeye ũnierẽ mʉ tʉ̃goñaña. ");
INSERT INTO cbcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bairo mʉ catʉ̃goñamiatacʉ̃ãrẽ, jĩcã wãme cariape tʉ̃goñarĩqũẽ niña. Bairi María pʉame ti wãmerẽ tʉ̃gogayamo. Bairi noa una, “Tocãrõã tʉ̃gojãnaña tiere,” cõ ĩ masĩẽnama —cõ ĩñupʉ̃ Jesús Martare. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ape rʉ̃mʉ Jesús Diore cʉ̃ cajẽnirõ bero, cʉ̃ cabuerã mena macããcʉ̃ jĩcãʉ̃, pʉame atore bairo qũĩñupʉ̃ Jesure: —Yʉ Quetiupaʉ, Diore jãã cajẽnimasĩparore bairo jãã mʉ buewa. Juan cʉ̃ cabuerãrẽ cʉ̃ caĩrĩcãrõrẽ bairo jãã cʉ̃ãrẽ mʉ buewa —qũĩñupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —Diore jẽnirã, atore bairo mʉjãã ĩ jẽniwã: ‘Jãã Pacʉ, jõbui macããcʉ̃, nipetiro camasã mʉ wãmerẽ na ĩroáto. Tunu bairoa mʉ carotimasĩrĩpaʉ ati yepapʉ to apáro. Jõbui mʉ carotirorea bairo to baiáto ati yepapʉ cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tunu tocãnacã rʉ̃mʉa jãã caʉgapeere jããrẽ jonucũña. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tunu bairoa roro jãã caátaje cʉ̃ãrẽ jãã masiriyobojaya. Camasã roro jããrẽ na caátajere jãã camasiritirorea bairo roro jãã caátaje cʉ̃ãrẽ jãã masiriyobojaya mʉ cʉ̃ã. Tunu wãtĩ roro jããrẽ cʉ̃ caátigarijere jãã ẽñotaya. Jãã netõña,’ bairo Diore cʉ̃ mʉjãã cajẽnipee ñuña —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bairo na ĩ yaparo, ape wãmerẽ ĩcõñarĩ atore bairo na ĩ quetibʉjʉnemoñupʉ̃ tunu: —Jĩcãʉ̃, ñami recomacã cʉ̃ bapa ya wiipʉ etayupʉ. Eta yua, bairo qũĩñupʉ̃: ‘Yʉ wasoya itia pan ũnoacã. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yʉ yaʉ jĩcãʉ̃ cayoaropʉ caatíatacʉ etayami. Cʉ̃rẽ yʉ canupee maniña yʉ wiire. Bairi mʉ yʉ jẽniña,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, cʉ̃ bapa pʉame cʉ̃ yʉesupʉ: ‘Yʉ pajʉ̃goeticõãña. Merẽ jope biaricaro niña. Yʉ, yʉ pũnaa cãnirã jãã baiya. Bairi dope bairo wãcãrĩ mʉ yʉ jomasĩẽcʉ̃,’ qũĩñupʉ̃ ti wii macããcʉ̃ cajẽniñaʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bairi mʉjããrẽ ñiña: Cʉ̃ bapa cʉ̃ caãnimiatacʉ̃ãrẽ, cʉ̃ caĩrõrẽ bairo átigaesupʉ. Baipʉa, ‘Nairõ yʉ patowãcõremi,’ ĩ, atore bairo átibujioʉmi: Wãcã, jopere pã, noo cʉ̃ bapa cʉ̃ caborore bairo nipetirijere cʉ̃ jobujioʉmi yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Tʉ̃gopeoya mʉjãã mai mʉjããrẽ ĩcõñarĩ yʉ caquetibʉjʉrijere: Noa ũna na cajẽniata, na cajẽnirĩjẽrẽ bócamasĩgarãma. Tunu bairoa apeye ũnierẽ na camacãata, na camacãrĩjẽrẽ bócamasĩgarãma. Tunu jopepʉ na capiiata, ti wii upaʉ pʉame ti jopere pããgʉmi. Bairi tore bairo Diore mʉjãã cajẽniata, mʉjãã caãnimasĩpeere jogʉmi. Bairi Diore mʉjãã cajẽnirõ ñuña. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mʉjãã, capũnaacʉna mʉjãã pũnaa pan rupare na cajẽniata, ¿ʉ̃tã rupare na mʉjãã jobujiocʉti? Bairo mʉjãã áperã. Tunu bairoa waire na cajẽniata, ¿ãña ũcʉ̃rẽ na mʉjãã jobujiocʉti? Bairo mʉjãã áperã. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tunu bairoa ãmona riare na cajẽniata, ¿cotapa ũcʉ̃rẽ na mʉjãã jobujiocʉti? Bairo mʉjãã áperã. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʉjãã, carorã nimirãcʉ̃ã, mʉjãã pũnaarẽ caroa wãmerẽ mʉjãã jomasĩnucũña. Marĩ Pacʉ Dios ʉmʉrecóo macããcʉ̃ roque caroʉ́ majũ niñami. Camasã netõrõ caroʉ́ niñami. ¡Bairi noa ũna cʉ̃rẽ cajẽnirãrẽ na jogʉmi Espíritu Santore!” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ape rʉ̃mʉ Jesús wãtĩ yeri pũnarẽ cʉ̃ acuwiyojoyupʉ caʉ̃mʉrẽ cajããmiatacʉre. Mai, caʉ̃mʉ pʉame bʉsʉmasĩẽsupʉ, wãtĩ yeri cʉ̃ cajãñarõ jʉ̃gori. Bairo Jesús cʉ̃rẽ cʉ̃ caacuwiyojoro bero, caʉ̃mʉ pʉame tunu bʉsʉmasĩñupʉ̃ yua. Bairo cʉ̃ cabairo ĩñarĩ, to macããna camasã ĩña acʉacoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jĩcããrã qũĩroaesuparã Jesure. Atore bairo qũĩñuparã: “Beelzebú wãtĩ quetiupaʉ majũ cʉ̃ camasĩõrĩjẽ jʉ̃gori wãtĩ yeri pũna, camasãrẽ caãnarẽ na acurewiyojo masĩĩmi Jesús,” qũĩ bʉsʉpaiyuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aperã tunu, dise ũnie átijẽñorĩqũẽrẽ ʉmʉrecóo macããjẽrẽ Jesús cʉ̃ caátijẽñorõ boyuparã. Na pʉame roro cʉ̃ áti ĩñarã ásuparã, “¿Dope bairo cʉ̃ ácʉati ãni?” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús pʉame na caĩtʉ̃goñarĩjẽrẽ masĩcõãñupʉ̃. Bairi atore bairo na ĩñupʉ̃: “Quetiupaʉ rey cʉ̃ carotimasĩrĩpaʉ macããna na caãmeoboeticõãta, jĩcãrõ ãnimasĩẽtĩñama. Tunu bairoa jĩcã wii macããna na caãmeoboeticõãta, na cʉ̃ã caroaro ãnimasĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tore bairo Satanás, wãtĩã quetiupaʉ cʉ̃ yarãrẽ na cʉ̃ caboeticõãta, ¿dope bairo to ãninetõrõati cʉ̃ carotimasĩrĩpaʉ? Ãninetõmasĩẽto. Yasipeticoagaro cʉ̃ yarãrẽ, na cʉ̃ caboeticõãta. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tunu bairoa Beelzebú jʉ̃gori wãtĩ yeri pũnarẽ na yʉ caacurewiyo jomasĩata, ¿ñamʉ cʉ̃ camasĩrĩjẽ jʉ̃gori mʉjãã yarã cʉ̃ã yʉre bairo na átimasĩcʉti? Bairo mʉjãã caĩrõ tʉ̃gorã, mʉjãã yarã pʉame, ‘Cariape mee mʉjãã tʉ̃goñaña,’ mʉjããrẽ ĩbujiorãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yʉ pʉame, Dios cʉ̃ camasĩõrĩjẽ jʉ̃gori wãtĩ yeri pũnarẽ yʉ caacurewiyo jomasĩata, nipetiro camasã yʉ caátiere ĩñarã, ‘Merẽ Dios cʉ̃ carotimasĩrĩpaʉ marĩrẽ etaya,’ ĩ masĩbujiorãma,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bairo ĩ quetibʉjʉ yaparo, cajerutiri majõcʉre ĩcõñarĩ atore bairo na ĩ quetibʉjʉnemoñupʉ̃ tunu: “Jĩcãʉ̃ wii upaʉ, catutuaʉ majũ cʉ̃ ya wii macããjẽrẽ caroaro cʉ̃ caĩñacoteata, ni ũcʉ̃ cajerutiri majõcʉ cʉ̃ yayere jerutimasĩẽcʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Baipʉa, apei cʉ̃ netõõrõ catutuaʉ cʉ̃ wiire jããrĩ, cʉ̃rẽ cʉ̃ caqũẽẽnetõata roque, ti wii upaʉ yaye cʉ̃ besure cʉ̃ ẽmapeyo masĩñami. Ti wii upaʉ pʉame, ‘Yʉ besu mena ni ũcʉ̃ ati wiire cajããʉ̃rẽ cʉ̃ yʉ netõcõãgʉ,’ cʉ̃ caĩtʉ̃goñamiatacʉ̃ãrẽ, cʉ̃ besure cʉ̃ ẽmapeyo masĩñami. Bairo ácʉ yua, ti wii upaʉ apeye ũnierẽ jeruti masĩcõãñami yua,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ĩ quetibʉjʉ yaparo, bairo na ĩnemoñupʉ̃ tunu: “Yʉ mena caãnigaecʉ, yʉre caĩñateire bairo niñami. Tunu bairoa yʉ mena caquetibʉjʉnetõõgaecʉ, camasãrẽ caquetibʉjʉmawijioʉre bairo niñami,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ĩ quetibʉjʉ yaparo, ape wãme cʉ̃ãrẽ na ĩnemoñupʉ̃ tunu: “Wãtĩ yeri pũna caʉ̃mʉrẽ cʉ̃ cawitiatato bero, noo caoco manorĩpʉ áñesẽãñami. Áñesẽã yua, cʉ̃ caãniparore cʉ̃ cabócaeticõãta, atore bairo ĩ tʉ̃goñañami: ‘Yʉ caãnimiatatopʉa yʉ tunuágʉ tunu,’ ĩ tʉ̃goñañami. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bairo ĩ tʉ̃goña yua, tunuá, caʉ̃mʉrẽ qũĩñañami tunu. Caʉ̃mʉ yeri pʉame wiire, caroaro na caowaqũẽno peyoata wiire bairo bauya. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bairo cabairo ĩña yua, acoásúpʉ tunu wãtĩ, aperã jĩcã wãmo peti pʉga pẽnirõ cãnacãʉ̃ majũ cʉ̃ netõrõ cañuenarẽ na piineñoʉ ácʉ́. Bairo na bóca, ‘Jito,’ na ĩ, caʉ̃mʉrẽ cʉ̃ jããñama tunu nipetirã. Bairi cʉ̃ yeripʉ ãnicõãñama tunu. Bairo na caãno, jõpʉame roro baibujioʉmi tunu caʉ̃mʉ pʉame yua,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bairo cʉ̃ caĩãno, na mena macããcõ jĩcãõ atore bairo qũĩñupõ bʉtioro: —¡Caroaro cariape mʉ quetibʉjʉya! Bairi mʉ paco, mʉrẽ camasõrĩcõ pʉame ʉseanirĩ ãcõmo mʉ mena —qũĩñupõ bʉsʉrique tutuaro mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bairo cõ caĩrõ tʉ̃go, bairo cõ ĩñupʉ̃ Jesús: —¡Yʉ paco netõõrõ ʉseaniñama Dios yaye quetire catʉ̃goʉsarã pʉame roque! ");
INSERT INTO cbcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cabero camasã pʉame aperã, aperã capããrã majũ na caneñaporo ĩña, atore bairo na ĩñupʉ̃ Jesús: “Ati yepa macããna, ãme caãna, caroaro tʉ̃goñaẽtĩñama. Átijẽño ĩñorĩqũẽ jetore boyama. Bairo na cabomiatacʉ̃ãrẽ, tiere na áti ĩñoetigʉmi Dios. Merẽ na quetibʉjʉ cũñupĩ Jonás ãnacʉ̃ cʉ̃ cabairiquere. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tirʉ̃mʉpʉre Jonarẽ cʉ̃ caátajere Nínive macã macããnarẽ na ĩñoñupĩ. Bairo narẽ cʉ̃ caĩñorõ bero, to macããna pʉame, ‘Cariapea Dios cʉ̃ caquetibʉjʉnetõrotiricʉ majũ niñami Jonás,’ ĩ tʉ̃goñamasĩñupã. Torea bairo yʉre Dios cʉ̃ caátipeere mʉjãã ãme caãnarẽ cʉ̃ caĩñorõ bero, bairoa mʉjãã ĩ tʉ̃goñamasĩgarã yʉ cʉ̃ãrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tunu bairoa ti rʉ̃mʉ camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉ caetaro, jĩcãõ ãnacõ catitunurĩ, mʉjãã, ãme caãnarẽ, ‘Cariapea mʉjãã tʉ̃goʉsaepʉ,’ mʉjããrẽ ĩregomo cõ cʉ̃ã. Ape nʉgõã waru jopepʉ macããcõ quetiupao ãnacõ bairo mʉjããrẽ ĩgomo. Cõ pʉame noo cayoaropʉ asúpo, Salomón ãnacʉ̃ cʉ̃ camasĩrĩjẽrẽ tʉ̃gogo. Bairo cõ catʉ̃gogarico cõ caãnimiatacʉ̃ãrẽ, mʉjãã, ãme caãna yʉ camasĩrĩjẽrẽ mʉjãã tʉ̃gogaetiya. Bairo Salomón netõrõ camasĩ yʉ caãnimiatacʉ̃ãrẽ, yʉ caĩrĩjẽrẽ mʉjãã tʉ̃gogaetiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tunu bairoa ti rʉ̃mʉ camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉ caetaro, Nínive macã macããna ãnana catitunurĩ, ‘Caroaro mʉjãã tʉ̃goʉsaepʉ,’ mʉjããrẽ ĩgarãma na cʉ̃ã. Na pʉame Jonás ãnacʉ̃ cʉ̃ caquetibʉjʉrijere tʉ̃gorã, roro na caátiere tʉ̃goña qũẽnoñuparã. Bairo na catʉ̃goñaqũẽnomiatacʉ̃ãrẽ, mʉjãã, ãme caãna, mʉjãã tʉ̃goña qũẽnogaetiya. Jonás netõrõ camasĩ yʉ caãnimiatacʉ̃ãrẽ, yʉ caĩrĩjẽ tʉ̃gori, mʉjãã tʉ̃goña qũẽnogaetiya,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Ni ũcʉ̃ jĩcãʉ̃ jĩñaworique cʉ̃ cajĩñawogaata, cayasioropʉ cũẽcʉ̃mi. Ni ũcʉ̃ jĩcãʉ̃ carupapata rocapʉ cũẽcʉ̃mi. Jõbuipʉ cũnucũñami, camasã nipetiro cajããetarã na caĩñamasĩparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","35","Tunu bairoa mʉjãã caapee pʉame cajĩñaworicare bairo niña mʉjãã rupaʉre. Mʉjãã caapee caroaro to caĩñamasĩata, caroaro mʉjãã ĩñamasĩgarã. Caroye tuata, caroaro mʉjãã ĩñamasĩẽtĩgarã. Tore bairo mʉjãã, cayeriñurã ãnirĩ cariape mʉjãã catʉ̃goñaata, caroaro mʉjãã átimasĩgarã. Cayeriñuena mʉjãã caãmata roque, caroaro mʉjãã átimasĩẽtĩgarã. Bairi Dios mʉjããrẽ cʉ̃ camasĩõrĩjẽrẽ tʉ̃goʉsa jãnaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bairi mʉjãã yeripʉ caroa jeto tʉ̃goñarĩ, bairi tunu carorijere tʉ̃goña ẽñotari, Dios cʉ̃ caátigarije nipetirijere mʉjãã tʉ̃gomasĩgarã. Jĩñaworique mʉjããrẽ cajĩñaworore bairo caroaro mʉjãã tʉ̃gomasĩgarã nipetirijere yua,” na ĩ quetibʉjʉyupʉ Jesús catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bairo cʉ̃ caĩrõ bero, fariseo majõcʉ Jesure, “Jito, marĩ átóca. Yʉ ya wiipʉ marĩ ʉgaáto,” qũĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, “Jaʉ,” ĩ, cʉ̃ tʉpʉ ʉgaʉ ásúpʉ Jesús. Bairi cʉ̃ wiipʉ jããeta, cariapea cʉ̃ mesapʉ etanumu etayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bairi fariseo pʉame, Jesús cariapea cʉ̃ caetanumurõ ĩña yua, “Tame,” ĩ tʉ̃goñañupʉ̃, “Marĩ, judío majã marĩ ya wãmerẽ bairo áperiyami Jesús. Cʉ̃ wãmorĩrẽ coseetiyami cʉ̃ caʉgaparo jʉ̃goye yua,” ĩ tʉ̃goñañupʉ̃ fariseo Jesús cʉ̃ cabairijere. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Marĩ Quetiupaʉ pʉame masĩcõãñupʉ̃ cʉ̃ catʉ̃goñarĩjẽrẽ. Bairi atore bairo qũĩñupʉ̃: —Mʉjãã, fariseo majã jotʉ bapaari mʉjãã cacosepeere nairõ mʉjãã tʉ̃goñanucũña. Bairi tie ũnierẽ nairõ tʉ̃goñamirãcʉ̃ã, mʉjãã yerire coserique pʉamerẽ mʉjãã tʉ̃goñaẽtĩña. Bairi yajariquere, bairi ape wãme ricaati tʉ̃goñarĩqũẽ cʉ̃ã nicõãña mʉjãã yeripʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Caĩtopairã mʉjãã ãniña. Cajotʉbapariwei pʉame jotʉ bapa bui cʉ̃ãrẽ, capupea cʉ̃ãrẽ qũẽnoñami. Torea bairo Dios pʉame mʉjãã rupaʉ jeto meerẽ, mʉjãã yeri pũna cʉ̃ãrẽ ásupi. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Atore bairo mʉjãã caátiere boyami Dios: Mʉjãã yeri mʉjãã caqũẽnorõ boyami. Bairo mʉjãã caápata, mʉjãã ñubujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Bairo átato ũnorẽã, ricaati mʉjãã, fariseo majã, mʉjãã átinucũña. Bairo ána yua, pʉga wãmo cãrõ moneda tiiriacarẽ mʉjãã cacʉ̃goata, jĩcã tiiaca mʉjãã jonucũña Diore. O ʉgarique jĩcã wãme ũno, pʉga wãmo cãrõ mʉjãã cacʉ̃goata, jĩcãrõãcã mʉjãã jonucũña Diore. Bairo cariape tie ũnierẽ átimasĩmirãcʉ̃ã, ape wãme paijãñurõ Dios cʉ̃ carotirique pʉamerẽ mʉjãã tʉ̃goñaetimajũcõãña. Caroaro ãmeo átaje cʉ̃ãrẽ marĩ rotiyami Dios. Caroaro ãmeo mairĩqũẽ cʉ̃ãrẽ marĩ rotiyami. Tie pʉamerẽ mʉjãã tʉ̃goñaẽtĩña. ¡Bairi mʉjãã carorije wapa pairo nigaro! ");
INSERT INTO cbcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tunu bairoa ñubuerica wiipʉ mʉjãã caápáta, caroapaʉre mʉjãã ruiganucũña. Tunu bairoa maapʉ mʉjãã caáñesẽãta, nipetiro camasã nʉcʉ̃bʉgoricaro mena na cajẽnirõ mʉjãã bonucũña. Bairo mʉjãã caboroi, ¡mʉjãã carorije wapa pairo nigaro! ");
INSERT INTO cbcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mʉjãã, camasã ãnanarẽ na cayarica opeere bairo mʉjãã ãniña. Ãme caãna pʉame ti opee buire áná, ‘Masã operi ãno,’ ĩ masĩẽtĩñama. Tore bairo mʉjãã ãniña. ¡Bairi mʉjãã carorije wapa pairo nigaro!” na ĩ quetibʉjʉyupʉ fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bairo cʉ̃ caĩrĩjẽrẽ tʉ̃go, fariseo mena macããcʉ̃ jĩcãʉ̃, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuei pʉame atore bairo qũĩñupʉ̃ Jesure: —Cabuei, bairo mʉ caĩata, jãã, jããrẽã roro ĩ micʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩñupʉ̃ Jesús: —Jĩcãʉ̃, cʉ̃ paabojari majõcʉre cʉ̃ jʉpʉsaetiyami. Jĩcã wãme ũnoacã cʉ̃ãrẽ cʉ̃ jʉáperiyami. Tore bairo na mʉjãã átiya camasãrẽ. ‘Moisés ãnacʉ̃ cʉ̃ carotiriquere jĩcã wãmeacã rʉsaeto ása,’ camasãrẽ na mʉjãã ĩnucũña. Bairo caĩrotirã nimirãcʉ̃ã, mʉjãã pʉame tore bairo mʉjãã áperimajũcõãña. ¡Bairi mʉjãã carorije wapa pairo nigaro! ");
INSERT INTO cbcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“Tunu bairoa caĩtopairã mʉjãã ãniña. Profeta majã na rupaʉri ãnajẽ masã ope buire mʉjãã qũẽnonucũña caroa ʉ̃tã wiiacarẽ, camasã profeta ãnanarẽ na ĩroáto, ĩrã. Bairo qũẽnomirãcʉ̃ã, mʉjãã ñicʉ̃jããrẽ bairoa mʉjãã ãnicõãña. Na pʉame Dios yaye quetire boena, profeta majãrẽ pajĩãreyuparã. Narẽ bairo mʉjãã boetiya Dios yaye quetire mʉjãã cʉ̃ã. Bairi, ‘Marĩ ñicʉ̃jãã profeta majãrẽ na capajĩãrĩcãrõrẽ bairo ñurõ. Dios yaye queti to yasicõãto,’ ĩrãrẽ bairo mʉjãã átinucũña. ¡Bairi mʉjãã carorije wapa pairo nigaro! ");
INSERT INTO cbcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Dios pʉame camasĩ ãnirĩ atore bairo ĩñupĩ: ‘Yʉ yarãrẽ na yʉ jogʉ camasã tʉpʉ. Profeta majãrẽ, apóstolea majã cʉ̃ãrẽ natʉ yʉ jogʉ, na quetibʉjʉáto, ĩ. Bairo yʉ cajomiatacʉ̃ãrẽ, jĩcããrãrẽ na pajĩãregarãma. Aperãrẽ roro popiye na baio joroque na átigarãma,’ ĩñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bairi Dios pʉame camasã profetare roro na caátaje jʉ̃gori ati rʉ̃mʉrẽ popiye na baio joroque na átigʉmi. Tocãnacãʉ̃ profeta majã, caãniñarĩcãrãrẽ na carií reyarique wapa popiye na baio joroque na átigʉmi ãme caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Na carií rejʉ̃goricʉ, Abel cawãmecʉcʉpʉi nijʉ̃goaná, Zacarías, altar, santuario watoa na capajĩãrĩcʉ̃pʉ nituetayama na carií rejʉ̃goatana capããrã beropʉ. Bairo na ãnana wapa roro popiye na baio joroque na átigʉmi ãme caãnarẽ yua,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ĩ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Dios yaye queti pʉame llavere bairo niña camasãrẽ. Llave jʉ̃gori wiire biaricarore marĩ pãjããmasĩña. Torea bairo Dios yaye queti jʉ̃gori ʉmʉrecóore marĩ jããmasĩña. Mʉjãã pʉame Dios cʉ̃ cabuerijere masĩmirãcʉ̃ã, cʉ̃rẽ mʉjãã boetiya. Tunu bairoa camasã Diore na camasĩgarijere mʉjãã ẽñotaya. ¡Bairi mʉjãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, mʉjãã carorije wapa pairo nigaro!” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Bairo cʉ̃ caĩrõĩ, to macããna, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, bairi fariseo majã mena cʉ̃ asiayuparã Jesure. Bairi ape wãme, ape wãme cʉ̃ jẽniñañuparã. “Carorije buei átiyami Jesús,” qũĩ bʉsʉjãgamirã, cʉ̃ jẽniñamiñuparã nairõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bairo na cabairo, capããrã majũ camasã, Jesutʉ neña etayuparã. Bairi capããrã majũ ãna, dope baiá masĩã manopʉ ãñuparã. Bairi Jesús pʉame cʉ̃ cabuerãrẽ atore bairo na ĩ jʉ̃goyupʉ: “‘Fariseo majã pan pairica na cawauorijere boeticõãña,’ ĩrĩcãrõ pʉamata, ‘Na caĩtopairijere mʉjãã boepa,’ ñiña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tunu bairoa ãme caãna na catʉ̃goñarĩjẽ nipetirijere masĩõpeyocõãgʉmi Dios nipetirãrẽ. Baujaro nigaro mʉjãã yeripʉ mʉjãã catʉ̃goñarĩjẽ nipetirije. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bairo bairi yasioro aperãrẽ mʉjãã caĩrĩqũẽ cʉ̃ãrẽ nipetiro camasã tʉ̃gogarãma. Mʉjãã ya arʉapʉ biajãáti, mʉjãã caĩrĩqũẽ cʉ̃ãrẽ capããrã na catʉ̃gojoro tiere quetibʉjʉgarãma aperã, bʉsʉrique tutuaro mena,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩñupʉ̃ tunu: “Yʉ yarã cariape mʉjããrẽ ñiña: Mʉjããrẽ capajĩãmasĩrãrẽ na uwieticõãña. Mʉjããrẽ na capajĩãatato bero, dope bairo átimasĩẽnama mʉjãã yeri pũna pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bairo pʉame ása: Dios yaye quetire tʉ̃goʉsaya. Cʉ̃ã, camasã na cariaro bero, caʉ̃petietopʉ na yeri pũnarẽ jomasĩñami. Bairi Dios pʉame roquere cʉ̃ uwiri jĩcãrõ tʉ̃ni caroaro ása. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tunu minia, jĩcã wãmo caãnacãʉ̃rẽ pʉga moneda tiiaca wapacʉtiyama. Bairo petoaca wapacʉtimirãcʉ̃ã, ni jĩcãʉ̃ ũcʉ̃ Dios cʉ̃ caĩñacoteecʉ maami. Nipetirãrẽ na cabairijere masĩcõãñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mʉjãã cʉ̃ãrẽ mʉjãã cabairijere masĩpeyocõãñami. Mʉjãã poa wẽẽrĩ cʉ̃ãrẽ cõõñapeyocõãñami Dios. Bairi, ‘Marĩ cabairijere masĩẽcʉ̃mi Dios,’ ĩ tʉ̃goñaeticõãña. Minia netõjãñurõ mʉjãã maiñami. Bairi uwieticõãña,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Cariape mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃, ‘Jesús yaʉ yʉ ãniña,’ aperã camasã na catʉ̃goro caĩquetibʉjʉre yʉ yaʉ cʉ̃ caãnierẽ yʉ cʉ̃ã yʉ Pacʉ yarã ángelea majã cʉ̃ãrẽ na yʉ quetibʉjʉgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bairi tunu apei, ‘Jesure yʉ masĩẽtĩña,’ caĩ pʉamerẽ yʉ cʉ̃ã, ‘Cʉ̃ yʉ masĩẽtĩña cʉ̃rã,’ na ñi quetibʉjʉgʉ, yʉ Pacʉ yarã ángelea majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bairi tunu noa ũna yʉ, Camasã Jʉ̃gocʉre, roro na caĩrĩjẽrẽ masiriyogʉmi Dios, cʉ̃rẽ na cajẽniata. Tore bairo átimicʉ̃ã, Espíritu Santore roro na caĩata roque, na masiriyobojaetigʉmi,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Yʉ yarã, mʉjããrẽ tutigarã, mʉjããrẽ jeágarãma. Jĩcã rʉ̃mʉ, ñubuerica wii uparã tʉpʉ, ape rʉ̃mʉ ĩñabeserica wii uparã tʉpʉ, ape rʉ̃mʉ ĩñabeseri majã tʉpʉ, ape rʉ̃mʉ macã quetiuparã tʉpʉ mʉjããrẽ neágarãma. Bairo mʉjããrẽ na caáto uwiri, ‘¿Dope bairo na marĩ ĩrãati?’ ĩ tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Marĩ mena macããcʉ̃, Espíritu Santo pʉame tipaʉ caetaro ĩña, na mʉjãã caĩpeere mʉjããrẽ masĩõgʉmi,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bairo cʉ̃ caĩrõ bero camasã capããrã watoa jĩcãʉ̃ qũĩñupʉ̃ Jesure: —Cabuei, yʉ pacʉ riacoámí. Bairi cʉ̃ cacʉ̃gomiatajere carecomacã yʉ boya. Bairi yʉ mʉ jʉĩgʉ yʉ jʉ̃gocʉre, tiere cʉ̃ ricawoáto, ĩ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús caʉ̃mʉrẽ: —Yʉ yaʉ, mʉjãã yayere cabatopaʉ mee yʉ ãniña. Bairo áti acʉ́ mee, yʉ apʉ́ ati yepapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ĩ yaparo, atore bairo na ĩnemoñupʉ̃ tunu to macããnarẽ: —Dios pʉame, “Carorije wapa cacʉ̃goenarẽ bairo mʉjããrẽ ñiñaña,” na ĩ tʉ̃goñaẽtĩñami, camasãrẽ pairo na cacʉ̃gorije jʉ̃gori. Torena, pairo apeye ũnierẽ ĩñaʉgaripeaeticõãña. Roro mʉjãã tʉ̃goñare —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ĩ yaparo, capee apeye ũnierẽ cacʉ̃goʉre ĩcõñarĩ bairo na ĩ quetibʉjʉnemoñupʉ̃ tunu: “Jĩcãʉ̃ caʉ̃mʉ caroa yepa majũrẽ cʉ̃goyupʉ. Bairi cʉ̃ oterique capee cʉ̃ rícacʉtibojayuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bairo capee carícacʉto ĩñarĩ, atore bairo ĩ tʉ̃goñañupʉ̃ caʉ̃mʉ pʉame: ‘¿Dope bairo yʉ ácʉati? ¿Yʉ cajepeere noorẽ yʉ cũʉ̃ati?’ ĩ tʉ̃goñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ĩ tʉ̃goña yaparo yua, atore bairo ĩ tʉ̃goñanemoñupʉ̃ tunu: ‘Merẽ yʉ masĩña yʉ caátipeere. Otere yʉ cacũnucũrĩ arʉarire yʉ weeregʉ. Áti yaparo, paca arʉri majũ yʉ qũẽnogʉ tunu. Topʉ yʉ cacʉ̃gorije, bairi yʉ cajepee mena nipetiro to jeto yʉ qũẽnocũgʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bairo áti yaparo, yʉ yerire atore bairo ñigʉ: “Ãmerẽ yua, capee cʉ̃marĩ yʉ cacʉ̃gopee nicõãña. Bairi ãmerẽ noo yʉ caborore bairo jeto yʉ átigʉ. Yerijã, ʉga, eti, ʉseanirĩ yʉ baiãnigʉ yua,”’ ĩ tʉ̃goñañupʉ̃ capee cacʉ̃goʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bairo cʉ̃ caĩtʉ̃goñamiatacʉ̃ãrẽ, Dios pʉame atore bairo qũĩñupʉ̃: ‘Catʉ̃goñamasĩẽcʉ̃ mʉ ãniña bairo mʉ caĩtʉ̃goñaata. Ati ñamia mʉ riacoagʉ. Bairi ati yepare caãmei ãnirĩ, ¿mʉ yaye apeye mʉ cacʉ̃gorijere dope mʉ ácʉati yua? ¿Nopẽ mʉ ápei?’ qũĩñupʉ̃ Dios capee apeyere cacʉ̃gomiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cʉ̃rẽ bairo niñami camasã nipetiro capee apeyere cacʉ̃gorã, Dios yaye quetire tʉ̃goʉsaena. Cʉ̃ ũna catʉ̃goñamasĩẽna majũ niñama,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Mʉjãã yeri pũna pʉame mʉjãã caʉgapee netõõjãñurõ caãnimajũrĩjẽ majũ niña. Tunu bairoa mʉjãã cajãñapee netõõjãñurõ caãnimajũrĩjẽ majũ niña. Bairi mʉjããrẽ ñiña: Ati yepa macããjẽrẽ bʉtioro bootʉ̃goñaeticõãña. Mʉjãã cacʉ̃gopeere, mʉjãã caʉgapeere, bairi mʉjãã cajãñapeere tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minia na caátiãnierẽ mʉjãã masĩña. Na caʉgapeere otejʉ̃goetiyama. Na caʉgapeere jeri wiipʉ qũẽnocũẽtĩnucũñama. Bairo na caáperimiatacʉ̃ãrẽ, na caʉgapeere jonucũñami Dios. ¡Mʉjãã roquere minia netõõrõ mʉjãã maiñami Dios! Bairi ãme mʉjãã caãnierẽ tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni ũcʉ̃ mʉjãã mena macããcʉ̃, cʉ̃ catʉ̃goñamacãrĩjẽ jʉ̃gori, ‘Yʉ bʉtinemogʉ jĩcã metro recomacã majũ, ʉ̃mʉaʉ ãnigʉ,’ ĩ masĩẽcʉ̃mi. Mʉjãã catʉ̃goñamacããrĩjẽ jʉ̃gori mʉjãã átimasĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bairi cabʉgoro macããjẽ ũnierẽ caátimasĩẽna nimirãcʉ̃ã, ¿nopẽĩrã, ‘Marĩ átimasĩpeyocõãrã marĩ catʉ̃goñamacãrĩjẽ jʉ̃gori,’ caĩtʉ̃goñarãrẽ bairo mʉjãã ĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tunu bairoa oó, tataboaro macããjẽ cabairije cʉ̃ãrẽ mʉjãã masĩña. Oó pʉame paaetinucũña. Eetinucũña. Bairo áperimirõcʉ̃ã, caroa bauya. Quetiupaʉ rey Salomón ãnacʉ̃ caroa majũ cʉ̃ cajutii jãñarĩqũẽ netõjãñurõ caroa bauya oó pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bairo tie taa ũnie Dios cʉ̃ caqũẽnorĩqũẽ jĩcã rʉ̃mʉ caroa cabaumiatacʉ̃ãrẽ, ape rʉ̃mʉ peeropʉ joeyama camasã, peero riorã. Mʉjããrẽ taa ũnie netõõjãñurõ mʉjãã maiñami Dios. Bairi mʉjãã cajãñapeere mʉjãã jogʉmi yua. ¡Mʉjãã, Dios mena catʉ̃goñatutuaenarẽ bairo mʉjããrẽ ñiñaña! ");
INSERT INTO cbcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Ati yepa macããna Diore caĩroaena pʉame na caʉgapeere, bairi na caetipeere tʉ̃goña macãnucũñama. Mʉjãã pʉame roque narẽ bairo baieticõãña. Marĩ Pacʉ Dios, marĩ cabopacarijere masĩpeyocõãñami. Bairi tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dios cʉ̃ carotimasĩrĩpaʉ roquere tʉ̃goñaña. Bairo mʉjãã catʉ̃goñaata, ati yepa macããjẽ mʉjãã cabopacarije cʉ̃ãrẽ mʉjãã jogʉmi Dios. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mʉjãã yʉ yarã, oveja petoaca caãnarẽ bairo mʉjããrẽ ñiñaña. Bairo capããrã mee caãna mʉjãã caãnimiatacʉ̃ãrẽ, Dios pʉame cañuʉ ãnirĩ cʉ̃ carotimasĩrĩpaʉpʉ mʉjãã caãnorẽ boyami. Bairi mʉjãã uwietigarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tunu bairoa mʉjãã cacʉ̃gorijere nunireri, dinero ñerĩ, aperã cabopacarãrẽ na batorájá. Bairo mʉjãã caápata, jõbuipʉ mʉjãã cawapatapee pairo nigaro. Ati yepapʉ mʉjãã caãno, mʉjãã yaye boacoaya. O jerutiri majã tiere jeruti recõãñama. O moena tiere ʉgareyama. Jõbuipʉ roquere mʉjãã yaye caãnipee yasietigaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ati yepapʉ macããjẽ jetore mʉjãã camaitʉ̃goñaata, tie jetore mʉjãã bootʉ̃goñagarã. Jõbuipʉ mʉjãã cacʉ̃gopeere mʉjãã camaitʉ̃goñaata roque, ati yepa macããjẽrẽ bʉtioro mʉjãã bootʉ̃goñaetigarã,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Bairo ĩ quetibʉjʉ yaparo, ape wãmerẽ na ĩ cõñañupʉ̃: “Caroaro mʉjãã qũẽnoyuwa. Mʉjãã jutii, mʉjãã cajãñapeere qũẽnoña. Tunu bairoa mʉjãã cajĩñaworijere jĩñapeori mʉjãã cotewa. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jĩcããrã paabojari majã ũnarẽ bairo ása. Na pʉame na quetiupaʉ aperã na cawãmojiyari bose rʉ̃mʉrẽ caĩñaʉ atácʉ cʉ̃ catunuetaparore caroaro cʉ̃ yuyuparã. ‘Jicoquei cʉ̃ caetaro, cʉ̃ marĩ pãjõrõã,’ ĩrã cʉ̃ yuyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ʉseanigarãma capaacoteri majã, na quetiupaʉ cʉ̃ catunuetarore caroaro cacotemasĩrã. Cãniena cacoterã ãnirĩ cʉ̃ mena ʉseanigarãma. Cariape mʉjããrẽ ñiña: Na quetiupaʉ pʉame mesapʉ na ruirotigʉmi, ʉgariquere na nugʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bairi noa ũna cãniena cacoterã ʉseanirĩ nigarãma, noo ñami recomacã, o cabusuatípaʉ na quetiupaʉ cʉ̃ catunuetarore cacoterã pʉame,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ĩ quetibʉjʉ yaparo, ape wãmerẽ na ĩ cõñañupʉ̃ tunu: “Apei wii upaʉ, cʉ̃ ya wii macããjẽrẽ cayajaʉacʉ́ cʉ̃ caetaparore cʉ̃ camasĩata, cãnietibujioricʉmi. Cʉ̃ caetaparore ĩñacotebujioricʉmi, jããremi, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tore bairo yʉ, Camasã Jʉ̃gocʉ, tunu yʉ caetari rʉ̃mʉrẽ jĩcãʉ̃ cayajari majõcʉre bairo yʉ etagʉ ati yepapʉre. ‘Ti rʉ̃mʉ majũ etagʉmi,’ caĩã mani rʉ̃mʉ majũ yʉ etagʉ. Bairi caroaro ãña. Yʉ catunuetarore caroaro mʉjãã cotewa,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame atore bairo qũĩñupʉ̃ Jesure: —Jãã Quetiupaʉ, ¿jĩcãʉ̃rẽ cʉ̃ ʉ̃mʉa cʉ̃rẽ na cacoterijere ĩcõñarĩ jãã jetore ĩ quetibʉjʉ miñati? ¿O nipetiro camasãrẽ ĩ quetibʉjʉáto miñati? —qũĩ jẽniñañupʉ̃ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús Pedrore: “Ni ũcʉ̃ jĩcãʉ̃ mayordomorẽ bairo caãcʉ̃, cʉ̃ quetiupaʉ cʉ̃ carotirore bairo caátimasĩ ũcʉ̃rẽ ñiña. Cʉ̃ quetiupaʉ pʉame cʉ̃ caápáro jʉ̃goye, ‘Yʉ ʉ̃mʉa aperãrẽ na mʉ qũẽnowã. Ʉgariquere na mʉ batowa,’ qũĩ cũñupʉ̃ cʉ̃ ʉ̃mʉrẽ. Bairi cabero tunueta, cʉ̃ ʉ̃mʉ, cʉ̃ caĩrotiricarorea bairo cʉ̃ caápata, caroare cʉ̃ jogʉmi. Bairi ʉseanirĩ nigʉmi mayordomo. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Caãnorẽ bairo mʉjããrẽ ñiña: Quetiupaʉ cʉ̃ yaye nipetirije upaʉre bairo cʉ̃ cũgʉmi, cʉ̃, mayordomo pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bairo cʉ̃ cacũmiatacʉ̃ãrẽ, cʉ̃ pʉame caróʉ cʉ̃ caãmata, ‘Yʉ quetiupaʉ tãmurĩ tunu etaecʉmi,’ ĩrĩ, aperã cʉ̃ baparãrẽ roro na átibujioʉmi. Cʉ̃ quetiupaʉ ʉ̃mʉa, cʉ̃ paabojari majã rõmirĩ cʉ̃ãrẽ roro na átibujioʉmi. Tunu bairoa ʉga, eticũmu baibujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bairi cabero cʉ̃ quetiupaʉ cañesẽãʉ̃atácʉ pʉame, ‘Ti rʉ̃mʉ etagʉmi,’ cʉ̃ caĩmasĩẽtĩ rʉ̃mʉrẽ etabujioʉmi. Bairo eta yua, cʉ̃ caroticũátacʉ roro cʉ̃ caátiere ĩñabujioʉmi. Bairo ĩña yua, popiye cʉ̃ baio joroque cʉ̃ átibujioʉmi. Cʉ̃ piticõãbujioʉmi, aperã yʉ caĩroaena mena cʉ̃ ãmarõ, ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ quetiupaʉ cʉ̃ caĩrĩjẽrẽ masĩmicʉ̃ã, tore bairo cʉ̃ caápata, cʉ̃ paecogʉmi bʉtioro cʉ̃ quetiupaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Apei cʉ̃ quetiupaʉ cʉ̃ caĩrĩjẽrẽ masĩẽtĩrĩ roro átiyami. Bairo roro cʉ̃ caátimiatacʉ̃ãrẽ, bʉtioro cʉ̃ paetigʉmi cʉ̃ quetiupaʉ pʉame. Bairi paijãñurõ camasĩjʉ̃goricarã pʉame netõjãñurõ caroaro na caátiere átirotiya. Petoaca camasĩrã netõjãñurõ caroaro na caáto ñuña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ĩ yaparo, atore bairo na ĩñupʉ̃ tunu: “Camasãrẽ na quetibʉjʉ ácʉ yʉ apʉ́ ati yepapʉre. Tunu yʉ yaye bʉsʉrique peerore bairo niña narẽ. ¡Bairi tiere nipetiro na masĩpeyocoáto! ");
INSERT INTO cbcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yʉ cʉ̃ã, yʉ yaye bʉsʉrique jʉ̃gori popiye yʉ baiya. Bairoa yʉ baicõã ãnigʉ yʉ paarique capetiparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mʉjãã, camasãrẽ yʉ caátiatájere mʉjãã masĩẽtĩña. ‘Dios cʉ̃ cajoʉ, cʉ̃ caetaro bero nipetiro camasã caroaro ãmeo átigarãma,’ mʉjãã ĩ tʉ̃goñaña. Bairo mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, bairo mee niña. Yʉ caetaro jʉ̃gori camasã jĩcãrõ tʉ̃ni tʉ̃goñaetigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bairi jĩcã wii macããna jĩcã wãmo cãnacãʉ̃ majũ na caãmata, yʉ yaye bʉsʉriquere tʉ̃gorã, itiarã ĩroagarãma. Pʉgarã ĩroaetigarãma. Torea bairo ape wii macããna cʉ̃ã pʉgarã ĩroagarãma. Itiarã ĩroaetigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bairi jĩcãʉ̃ cʉ̃ macʉ̃rẽ cʉ̃ pesucʉtigʉmi yʉ yaye bʉsʉriquere cʉ̃ catʉ̃goʉsaro jʉ̃gori. Torea bairo apei cʉ̃ pacʉre cʉ̃ pesucʉtigʉmi. Apeo cʉ̃ã cõ macõrẽ cõ pesucʉtigomo. Apeo cʉ̃ã cõ pacore cõ pesucʉtigomo. Apeo cʉ̃ã cõ pẽẽpõrẽ cõ pesucʉtigomo. Apeo cʉ̃ã cõ mañicõrẽ cõ pesucʉtigomo, yʉ yayere cõ catʉ̃goʉsaro jʉ̃gori,” na ĩñupʉ̃ Jesús cʉ̃tʉ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bairo ĩ quetibʉjʉ yaparo, atore bairo tunu na ĩnemoñupʉ̃ camasãrẽ: “Oco poari muipʉ cʉ̃ cawãmʉató to cawãmʉ atóre ĩñarã, ‘Oco ató baiya,’ mʉjãã ĩ masĩña. Torea bairo bainucũña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tunu bairoa ape nʉgõã warua jopepʉ cawĩno atóre ĩñarã, ‘Asigaro baiya ãme rʉ̃mʉrẽ,’ mʉjãã ĩ masĩña. Torea bairo bainucũña. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bairo caoco ocapeere, bairi caasipee cʉ̃ãrẽ bairo caĩñamasĩrã nimirãcʉ̃ã, ¿nopẽĩrã Dios ati yʉteare cʉ̃ caátiãnie pʉamerẽ mʉjãã masĩẽtĩñati? ¡Caĩtopairã mʉjãã ãniña!” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bairo ĩ quetibʉjʉ yaparo, atore bairo tunu na ĩnemoñupʉ̃: “¿Nopẽĩrã cariape átajere mʉjãã majũã mʉjãã ĩ bʉsʉ qũẽnomasĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni jĩcãʉ̃ ũcʉ̃, ‘Yʉ mʉjãã wapamoña,’ ĩrĩ, mʉjããrẽ juez caĩñabesei tʉpʉ cʉ̃ caneápáro jʉ̃goye, cʉ̃ mena bʉsʉqũẽnojʉ̃goya. Mʉjããrẽ juez tʉpʉ cʉ̃ caneápériparore bairo ĩrã, cʉ̃ mena bʉsʉqũẽnojʉ̃goya. Mʉjãã cabʉsʉqũẽnojʉ̃goeticõãta, juez pʉame guardiare mʉjããrẽ ñerotigʉmi. Bairo áti yaparo, na pʉame preso jorica wiipʉ mʉjããrẽ cũrecõãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cariape mʉjããrẽ ñiña: Dinero mʉjãã cawapamorĩjẽrẽ mʉjãã cawapatipeyoparo jʉ̃goye, topʉ mʉjãã ãnicõãgarã. Mʉjãã witimasĩetigarã,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jĩcã rʉ̃mʉ caãno camasã Jesure qũĩñarã etayuparã. Eta, atore bairo qũĩ quetibʉjʉyuparã: “Pilato pʉame Galilea macããnarẽ na pajĩãreupʉ, Diore na cañubuerã etaro. Waibʉtoa riire na cajoemʉgõrã etaro na pajĩãreupʉ,” qũĩ quetibʉjʉyuparã camasã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bairo na caĩquetibʉjʉro tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: “¿Dope bairo mʉjãã ĩ tʉ̃goñañati na cabaiatajere? ‘Na yarã Galilea macããna nipetirã netõrõ carorã ãniupã. ¿Bairi bʉtioro majũ na carorije wapa jʉ̃gori yasiupa,’ mʉjãã ĩ tʉ̃goñañati? ");
INSERT INTO cbcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bairo mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, baietiupa. Na yarã netõrõ carorã mee ãniupã. Caãnorẽ bairo mʉjããrẽ ñiña: Mʉjãã cʉ̃ã roro mʉjãã yasigarã, roro mʉjãã caátiere yapapuari Diore mʉjãã caĩbʉsʉqũẽnoeticõãta. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tunu bairoa, ¿dope bairo mʉjãã ĩ tʉ̃goñañati caʉ̃mʉarĩ wii Siloé macããjẽ ʉ̃tã rupaa mena catãni yasiricarãrẽ? Dieciocho majũ catãni yasiricarãrẽ roro na cabairiquere, ¿dope bairo mʉjãã ĩ tʉ̃goñañati? ‘Jerusalén macããna nipetiro netõrõ carorã ãniupã. ¿Bairi bʉtioro majũ na carorije wapa jʉ̃gori yasiupa,’ mʉjãã ĩ tʉ̃goñañati? ");
INSERT INTO cbcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bairo mʉjãã caĩtʉ̃goñamiatacʉ̃ãrẽ, baiesupa. Jerusalén macããna netõrõ carorã mee ãñupã. Caãnorẽ bairo mʉjããrẽ ñiña: Mʉjãã cʉ̃ã roro mʉjãã yasigarã, roro mʉjãã caátiere yapapuari Diore mʉjãã caĩbʉsʉqũẽnoeticõãta,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bairo ĩ quetibʉjʉ yaparo, higuera yucʉ carícamanirẽ ĩcõñarĩ tunu na ĩ quetibʉjʉnemoñupʉ̃: “Jĩcãʉ̃, cʉ̃ wesepʉ cʉ̃goyupʉ higuera cawãmecʉtiire. Bairi jĩcã rʉ̃mʉ carícare ĩñaʉ etayupʉ. Bócaesupʉ. Ríca mañuparõ mai. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Itia cʉ̃marĩ majũ bairo jeto baiyupʉ. Ríca mañuparõ. Bairo cabairoi, qũĩñupʉ̃ cʉ̃ ʉ̃mʉrẽ: ‘Merẽ itia cʉ̃ma majũ carícare yʉ macãmiña. Caríca mani ãno ati higuera marĩ caotemirĩcʉ. ¿Nopẽĩrõ to ãnicõãroati ati yepapʉ? Bairi quetírocacõãña,’ qũĩñupʉ̃ ti wese upaʉ cʉ̃ ʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ cʉ̃ ʉ̃mʉ pʉame: ‘Yʉ quetiupaʉ, ati yʉteare marĩ quetíetiroa mai. Tii pʉtore yʉ jetugʉ. Abono cʉ̃ãrẽ yʉ jããgʉ mai. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bairi ape yʉteare carícacʉpata, ñujãñugaro. Tii caríca manicõãta roquere, tiire quetírocacõã rotiya,’ qũĩñupʉ̃ caʉ̃mʉ ti wese upaʉre,” na ĩ quetibʉjʉyupʉ Jesús camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ape rʉ̃mʉ tunu Jesús judío majã na cayerijãrĩ rʉ̃mʉ caãno na cañubueneñarĩ wiipʉ jʉ̃gobuei ásupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mai, ti wiipʉ ãñupõ jĩcãõ carõmio. Cõ pʉame wãtĩ yeri pũna jʉ̃gori riajãñuñupõ. Dieciocho cʉ̃marĩ majũ riayupo. Bairi wãmʉ pomasĩẽsupõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bairo cõ cabairo ĩñaʉ, Jesús pʉame atore bairo cõ ĩñupʉ̃: —Yʉ yao, mʉ cariayecʉtie to petiáto, ñiña. Mʉ yʉ catioya —cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bairo ĩ yaparo, cʉ̃ wãmorĩrẽ cõ buire pitipeoyupʉ. Bairo cʉ̃ caáto, jicoquei wãmʉpo masĩcoasupo yua. Tunu Diore cʉ̃ basapeo jʉ̃goyupo, catiáco yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bairo ʉseanirõ cõ caãnimiatacʉ̃ãrẽ, ti wii ñubuerica wii quetiupaʉ pʉame asiajãñuñupʉ̃. Judío majã na cayerijãrĩ rʉ̃mʉrẽ Jesús cʉ̃ caátiere ĩñarĩ asiajãñuñupʉ̃. Bairo asiari atore bairo na ĩñupʉ̃ ti wii caneñarĩ majãrẽ: —Marĩ capaari rʉ̃mʉ jĩcã wãmo peti jĩcã pẽnirõ cãnacã rʉ̃mʉrĩ majũ niña. Ti rʉ̃mʉrĩ jeto catio rotiya. Marĩ cayerijãrĩ rʉ̃mʉ caãnorẽ catio rotieticõãña —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —Caĩtopairã mʉjãã ãniña, bairo mʉjãã caĩata. ¿Ni ũcʉ̃ mʉjãã mena macããcʉ̃ marĩ cayerijãrĩ rʉ̃mʉ caãno cʉ̃ wecʉre, o cʉ̃ burrore na oco etiricapaʉpʉ na cʉ̃ jee áperinucũñati? Nipetirã bairo jeto átinucũñama ati rʉ̃mʉ ũno cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bairi mʉjãã wecʉare caqũẽnonucũrã nimirãcʉ̃ã, ¿nopẽĩrã, ‘Atiore Abraham ãnacʉ̃ pãrãmeorẽ dieciocho cʉ̃marĩ majũ Satanás, wãtĩ quetiupaʉ roro cõ cʉ̃ caátie jʉ̃gori popiye cabaiore cõ marĩ catiorotietigarã ati rʉ̃mʉ ũnorẽ,’ ĩrãrẽ bairo mʉjãã ĩñati? ¡Roro mʉjãã tʉ̃goñaña! —qũĩñupʉ̃ Jesús ti wii ñubuerica wii quetiupaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bairo cʉ̃ caĩrõ, cʉ̃ pesua pʉame bobotʉ̃goña jãñuñuparã na caĩatajere. Aperã camasã pʉame ʉseani peticoasuparã, Jesús nocãrõ caroaro cʉ̃ caátiere ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Cabero atore bairo na ĩnemoñupʉ̃ Jesús tunu: “¿Dope bairo mʉjããrẽ yʉ masĩõñati Dios cʉ̃ carotimasĩrĩpaʉre? ¿Di wãme ũnorẽ ĩcõñarĩ mʉjããrẽ yʉ quetibʉjʉyati? ");
INSERT INTO cbcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza na caĩrĩ apeacarẽ jĩcãʉ̃ cʉ̃ wesepʉ cʉ̃ caotericaacarẽ bairo niña Dios cʉ̃ carotimasĩrĩpaʉ. Bairi caʉ̃mʉ tiacarẽ cʉ̃ caotero bero pairicʉ bʉtiya. Bairi minia pʉame tii rʉpʉ buire na ria batiirire qũẽnonucũñama. Torea bairo niña Dios cʉ̃ carotimasĩrĩpaʉ cʉ̃ã,” na ĩ cõña quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ĩ quetibʉjʉ yaparo, ape wãmerẽ ĩ cõñanemoñupʉ̃ tunu: “¿Dope bairo mʉjããrẽ yʉ masĩõñati Dios cʉ̃ carotimasĩrĩpaʉre? ");
INSERT INTO cbcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Levadurare bairo niña Dios cʉ̃ carotimasĩrĩpaʉ. Jĩcãõ trigo wãĩãrĩqũẽ wetare, itia rʉri majũ, oco mena weyo yaparo, levadurare petoaca jããñamo. Bairo petoaca cõ cajããmiatacʉ̃ãrẽ, tie pʉame jesapeticoaya yua. Torea bairo niña Dios cʉ̃ carotimasĩrĩpaʉ cʉ̃ã,” na ĩ cõña quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bairo bai, Jesús Jerusalẽpʉ ácʉ́, tocãnacã macãã cʉ̃ canetõrĩ macããrẽ camasãrẽ na quetibʉjʉyupʉ. Capaca macããrĩ, õcã macããrĩãcã cʉ̃ãrẽ na quetibʉjʉyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bairo cʉ̃ caátó, cʉ̃ mena macããcʉ̃ jĩcãʉ̃ atore bairo qũĩ jẽniñañupʉ̃: —Jãã Quetiupaʉ, ¿nocãnacãʉ̃ majũ camasãrẽ marĩ Pacʉ Dios cʉ̃ netõʉ̃ati? ¿Petoaca majũ na ãniñati Dios cʉ̃ canetõparã? —qũĩ jẽniñañupʉ̃ caʉ̃mʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, atore bairo na ĩ quetibʉjʉyupʉ Jesús: —Ati yepapʉ mʉjãã caãno, pʉga jopeere bairo niña. Bairi õcã jopeacarẽ mʉjãã capãjããmasĩrõ ñuña. Cariape mʉjããrẽ ñiña: Capããrã camasã ti jopere jããgamigarãma. Bairo jããgamirãcʉ̃ã, jããmasĩẽtĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jĩcã rʉ̃mʉ ti wii upaʉ pʉame wãmʉátí, ti jopere biacõãgʉmi yua. Pããnemoetigʉmi. Bairo cʉ̃ caáto, mʉjãã macãpʉ caãna cʉ̃ piirã, “Jãã pããña,” mʉjãã ĩmigarã. Bairo mʉjãã caĩmiatacʉ̃ãrẽ, “Mʉjããrẽ yʉ masĩẽtĩña,” mʉjãã ĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bairo cʉ̃ caĩrõ tʉ̃go, mʉjãã ĩnemogarã: “Jããrẽ mʉ masĩĩ. Mʉ mena eti, ʉga jãã ápʉ. Tunu bairoa jãã ya macããpʉ mʉ bueñesẽãwʉ̃. Jããrẽ mʉ masĩĩ,” mʉjãã ĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bairo mʉjãã caĩrõ tʉ̃go, atore bairo mʉjãã ĩnemogʉmi tunu: “Merẽ mʉjããrẽ ñiapʉ̃: ‘Mʉjããrẽ yʉ masĩẽtĩña. Mʉjãã, carorije caána mʉjãã caãnoi, ati wiire mʉjããrẽ yʉ jããrotietigʉ. ¡Ánája!’” mʉjãã ĩgʉmi ti wii upaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mʉjãã, marĩ ñicʉ̃jããrẽ Abraham, Isaac, Jacob, profeta majã nipetirã cʉ̃ãrẽ, Dios cʉ̃ carotimasĩrĩ paʉpʉ caãnarẽ mʉjãã ĩñajogarã. Mʉjãã pʉame aperopʉ wẽrewiyo joricarãrẽ bairo mʉjãã ãnigarã. Bairi bʉtioro mʉjãã otigarã. Mʉjãã opire mʉjãã bacarʉpotugarã, bʉtioro yapapuarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tunu bairoa Dios cʉ̃ carotimasĩrĩpaʉ caetaro camasã Diotʉ neña etagarãma. Muipʉ cʉ̃ cawãmʉatópʉ caatíatana, bairi cawaru macãã jopepʉ caatíatana, bairi ape nʉgõã waru macãã jopepʉ caatíatana, bairi muipʉ cʉ̃ cañajãátopʉ caatíatana cʉ̃ã Diotʉ neñaetagarãma. Bose rʉ̃mʉrẽ netõrã ána, cʉ̃tʉ rui ʉgagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ati rʉ̃mʉrĩrẽ jĩcããrã carotimasĩẽtãna rotimasĩgarãma. Tunu bairoa ati rʉ̃mʉrẽ jĩcããrã carotimasĩrã rotimasĩẽtĩgarãma Dios tʉpʉre —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bairo cʉ̃ caquetibʉjʉ ãno, ti rʉ̃mʉ majũrẽ cʉ̃tʉ etayuparã fariseo majã. Bairo cʉ̃tʉ eta, atore bairo qũĩñuparã: —Ati yepa quetiupaʉ, Herodes, mʉrẽ pajĩã rocacoagayami. Bairi tãmurĩ ruti ácʉ́ja —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bairo na caĩrõ tʉ̃gori, atore bairo na ĩñupʉ̃: —Tunu ánája Herodes tʉpʉ, macãnʉcʉ̃ yaire bairo caãcʉ̃ tʉpʉ. Atore bairo qũĩrájá: “‘Ãme wãtĩ yeri pũnarẽ yʉ acurewiyojoya. Tunu bairoa cariayecʉna cʉ̃ãrẽ na yʉ catioya. Ñamirõcã cʉ̃ãrẽ bairoa yʉ átigʉ. Bairi itia rʉ̃mʉ bero bairo yʉ caátiere yʉ átijãnagʉ,’ ĩñami Jesús,” qũĩrájá Herodere —na ĩ joyupʉ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ĩ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Ãme, ñamirõcã, ñamirõcã ape rʉ̃mʉ bairoa yʉ átigʉ, Dios yarã profeta majã camasã na capajĩã riírericarã ãnana Jerusalẽpʉ jeto yasinucũñupã. Bairi topʉ cariape yʉ caátó ñuña,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Cabero atore bairo na ĩnemoñupʉ̃ Jesús tunu: “Jerusalén, Jerusalén macã macããna mʉjããrẽ ñiña: ¡Dios yarã profeta majãrẽ mʉjãã pajĩã riírenucũñupã! Dios mʉjããrẽ cʉ̃ caquetibʉjʉrotijomirĩcãrãrẽ ʉ̃tã mena narẽ wẽẽrĩ na mʉjãã pajĩãrenucũñupã. Bairo roro majũ mʉjãã caátimiatacʉ̃ãrẽ, nairõ mʉjããrẽ yʉ jʉátinemogamiwʉ̃. Ãboco cõ pũnaarẽ na asipogo, narẽ cõ caneñorĩcãrõrẽ bairo mʉjãã yʉ jʉátinemogamiwʉ̃. Bairo yʉ caátigamiatacʉ̃ãrẽ, mʉjãã pʉame jĩcã nʉgõã yʉ mʉjãã boepʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bairo mʉjãã caboetoi, tocãrõã yua, mʉjãã caãnipaʉ yasicoagaro. Tore camasã aweyo rocacõãgarãma. Caãnorẽ bairo mʉjããrẽ ñiña: ‘¡Ʉseanirĩ niñami Dios cʉ̃ cajoʉ majũ!’ mʉjãã caĩparo jʉ̃goye, yʉ mʉjãã ĩñaetigarã mai,” na ĩñupʉ̃ Jesús Jerusalén macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ape rʉ̃mʉ tunu judío majã na cayerijãrĩ rʉ̃mʉ caãno Jesús ʉgaʉ ásupʉ jĩcãʉ̃ fariseo majã quetiupaʉ ya wiipʉ. Bairo topʉ cʉ̃ caãno, ti wii macããna fariseo majã pʉame qũĩñaʉsayuparã, “Dope bairo cʉ̃ caáto,” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mai, Jesús riapere ãñupʉ̃ cariayecʉcʉ cʉ̃ã. Cʉ̃ pʉame oco riayere cacʉ̃goʉ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bairo cʉ̃ cabairo ĩña, atore bairo na ĩñupʉ̃ Jesús to macããnarẽ, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuerãrẽ, bairi fariseo majã cʉ̃ãrẽ: —Marĩ cayerijãrĩcã rʉ̃mʉrẽã cariayecʉnarẽ marĩ cacatioro, ¿to ñucõãcʉti? O paariquere bairo caãnoi, ati rʉ̃mʉ ũnorẽ tore bairo caápericõãpee, ¿to ãnicʉti? —na ĩ jẽniñañupʉ̃ Jesús to macããnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bairo narẽ cʉ̃ caĩjẽniñamiatacʉ̃ãrẽ, bʉsʉesuparã. Bairo na cabʉsʉeto ĩña, cariaʉre cʉ̃ pãñarĩ cʉ̃ catioyupʉ yua. Cʉ̃ catio yaparo, cʉ̃ árotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bairo áticõã, tunu na ĩnemoñupʉ̃ Jesús fariseojããrẽ: —¿Ni ũcʉ̃ mʉjãã mena macããcʉ̃ cʉ̃ macʉ̃, o cʉ̃ wecʉ opepʉ ati rʉ̃mʉ ũnorẽ cʉ̃ cañarocajãápata, jicoquei cʉ̃ cʉ̃ ne mʉgõ masĩẽtĩñati? Nipetirã mʉjãã tore bairo mʉjãã átibujiorã, marĩ cayerijãrĩ rʉ̃mʉ ũno cʉ̃ãrẽ. ¿Bairo mʉjãã ápericʉti? —na ĩ jẽniñañupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bairo narẽ cʉ̃ caĩjẽniñamiatacʉ̃ãrẽ, dope bairo cʉ̃ yʉmasĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cabero aperã ti wii upaʉ cʉ̃ capiiatana na caetarore ĩñañupʉ̃ Jesús. Na pʉame caroapaʉre ruigayuparã bʉtioro, “Cabʉgoro macããna na caruiparore marĩ ruietiroa,” ĩrã. Bairo na cabairo ĩña, atore bairo na ĩ beyoyupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ni jĩcãʉ̃ mʉjãã mena macããcʉ̃rẽ wãmo jiyarica bose rʉ̃mʉrẽ cʉ̃rẽ cʉ̃ capiiata, ‘Caãnimajũrã na caruiparopʉ cʉ̃ ruigaeticõãto,’ ñiña. Topʉ cʉ̃ caruiata, cabero bobooro netõbujioʉmi. Apei ti bose rʉ̃mʉ upaʉ cʉ̃ capiimajũatacʉ etabujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bairi ti bose rʉ̃mʉ upaʉ pʉame cʉ̃ caetaro ĩña, atore bairo qũĩbujioʉmi: ‘Jõpʉ catʉsaropʉ ruija. Ãni pʉame cabero caetaʉ atore ruigʉmi,’ qũĩbujioʉmi. Bairo cʉ̃ caĩrõĩ, mʉjãã ũcʉ̃ bobotʉ̃goñabujiogʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bairi mʉjããrẽ na capiiata, catʉsari cũmurõ roquere ruiya. Cabero bose rʉ̃mʉ upaʉ pʉame topʉ mʉjãã caruiro ĩña: ‘Ato pʉame caãnimajũrã mena ruirasá,’ mʉjãã ĩgʉmi. Bairo cʉ̃ caĩrõ tʉ̃go, aperã ti mesa macããna mʉjããrẽ cʉ̃ caĩroarore ĩñagarãma yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ majũã, ‘Caãnimajũʉ̃ yʉ ãniña,’ caĩ pʉamerẽ, cabʉgoro macããcʉ̃rẽ bairo cʉ̃ ãnio joroque cʉ̃ átigʉmi Dios. Apei, ‘Caãnimajũʉ̃ mee yʉ ãninã,’ caĩ pʉame roquere, cabero cabʉgoro macããcʉ̃rẽ bairo mee cʉ̃ ãnio joroque cʉ̃ átigʉmi Dios —na ĩ quetibʉjʉyupʉ Jesús ti wii macããna, fariseo cʉ̃rẽ capiiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bairo na ĩ quetibʉjʉ yaparo, atore bairo qũĩnemoñupʉ̃: —Bose rʉ̃mʉrẽ mʉ caqũẽnonemoata, mʉ baparãrẽ na piieticõãña. Tunu bairoa mʉ bairãrẽ, mʉ jʉ̃gocʉjãã nipetirã mʉ yarãrẽ, mʉtʉ macããna pairo dinero cacʉ̃gorã cʉ̃ãrẽ na piieticõãña. Na ũnarẽ bairo mʉ capiiata, ape rʉ̃mʉ na cʉ̃ã mʉrẽ torea bairo átiãmebujiorãma. Bairi merẽ wapatiricʉre bairo mʉ tuabujioʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bairo bairi bose rʉ̃mʉrẽ mʉ caqũẽnonemoata, cabopacarãrẽ na piiya. Tunu bairoa caámasĩẽnarẽ, bairi jĩcã rʉpo, o jĩcã ricá caroyetuaricarãrẽ, bairi caĩñamasĩẽna cʉ̃ãrẽ, na ũnarẽ na piiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bairo ácʉ, ʉseanirĩ mʉ ãnigʉ. Cabopacarã pʉame mʉ átiãme masĩẽtĩgarãma, ñe ũnie cacʉ̃goena ãnirĩ. Bairo na caátiãme masĩẽtĩmiatacʉ̃ãrẽ, cariacoatana tunu na cacatiri rʉ̃mʉ caãno Dios pʉame caroare mʉ jogʉmi, caroaro na mʉ caátie wapa yua —qũĩ quetibʉjʉyupʉ Jesús fariseo, cʉ̃rẽ capiiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃go, jĩcãʉ̃ na mena mesapʉ carui pʉame atore bairo qũĩñupʉ̃ Jesure: —¡Dios cʉ̃ carotimasĩrĩpaʉ bose rʉ̃mʉrẽ cajʉ ʉgaʉ pʉame ʉseanirĩ nigʉmi! —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bairo cʉ̃ caĩrõ tʉ̃go, ape wãmerẽ ĩcõñarĩ atore bairo qũĩ quetibʉjʉyupʉ Jesús: —Jĩcãʉ̃ nocãrõ caroaro bose rʉ̃mʉrẽ qũẽnogayupʉ. Torecʉ, capããrã camasãrẽ na piineñorotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ʉgaricapaʉ caetaro ĩña, cʉ̃ capiiatanarẽ cʉ̃ ʉ̃mʉrẽ na piirotijoyupʉ. ‘Merẽ marĩ caʉgaparo etaya. Ñe ũnie rʉsaetiya. Bairi, “Tãmurĩ mʉjãã apá,” na ĩ quetibʉjʉʉja,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ ʉ̃mʉ cʉ̃ quetiupaʉ cʉ̃ caĩrõrẽã bairo ásupʉ. Bairo narẽ cʉ̃ caĩquetibʉjʉ netõmiatacʉ̃ãrẽ, nipetirã ricaati jeto qũĩ yʉyuparã. Jĩcãʉ̃ na mena macããcʉ̃ atore bairo qũĩñupʉ̃: ‘Meepʉ jĩcã yepa, oterica yepare yʉ wapatiapʉ. Bairi ãme ti yepare ĩñaʉ ágʉ yʉ baiya. “Bairi yʉ ámasĩẽtĩña, ĩãmi,” cʉ̃ miwã mʉ quetiupaʉre,’ qũĩñupʉ̃ jĩcãʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Apei cʉ̃ã atore bairo qũĩñupʉ̃: ‘Wecʉa jĩcã wãmo cãnacã bapa majũ yʉ wapatiapʉ. Bairi ãme narẽ ĩñaʉ ágʉ yʉ baiya. “¿Caroaro na paayati?” ĩ, ñiñaʉ ágaya. “Bairi yʉ ámasĩẽtĩña, ĩãmi,” cʉ̃ miwã mʉ quetiupaʉre,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Apei cʉ̃ã atore bairo qũĩñupʉ̃: ‘Mepʉ yʉ wãmoyiyaapʉ. “Bairi yʉ ámasĩẽtĩña, ĩãmi,” cʉ̃ miwã mʉ quetiupaʉre,’ qũĩñupʉ̃ apei. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bairo jeto na caĩrõ tʉ̃go, narẽ capiiámiatacʉ pʉame tunucoásúpʉ cʉ̃ quetiupaʉ tʉpʉ. Eta yua, na caĩatajere cʉ̃ quetibʉjʉnetõñupʉ̃. Bairo tiere tʉ̃go, cʉ̃ quetiupaʉ pʉame na mena asiajãñuñupʉ̃, cʉ̃ capiijomiatana mena. Asia yua, atore bairo qũĩñupʉ̃ tunu cʉ̃ ʉ̃mʉrẽ: ‘Tãmurĩ ácʉ́ja tunu macãpʉ. Cabopacarã maapʉ caãnarẽ, “Ʉgarasá,” na miwã. Tunu bairoa caámasĩẽnarẽ, bairi jĩcã rʉpo, o jĩcã ricá caroyetuaricarãrẽ, bairi caĩñamasĩẽna cʉ̃ãrẽ nipetirã na ũnarẽ na jee asá yʉ ya wiipʉ,’ qũĩñupʉ̃ ti bose rʉ̃mʉ upaʉ cʉ̃ ʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cabero cʉ̃ ʉ̃mʉ pʉame bairo áti yaparo, cʉ̃ quetiupaʉre atore bairo qũĩñupʉ̃ tunu: ‘Yʉre caroti, mʉ caĩrõrẽã bairo yʉ áti yaparoya merẽ. Bairopʉa, mʉ ya wii pʉame jiraetiya mai,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bairo cʉ̃ caĩrõ tʉ̃go, ti wii upaʉ pʉame: ‘Ácʉ́ja tunu macãpʉ. Maa cañesẽãrĩ majãrẽ, wii tʉ̃ni macããna cʉ̃ãrẽ na piija. Tutuaro mena, “Ʉgarasá,” na miwã. Yʉ ya wii to jiraáto ĩ, bairi mʉrẽ yʉ jonemoña,’ qũĩñupʉ̃ ti bose rʉ̃mʉ upaʉ cʉ̃ ʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Caãnorẽ bairo mʉjããrẽ ñiña: Noa ũna yʉ capiijʉ̃gomiatana caápérã yʉ mena ʉgaetigarãma —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bairo ti watoare camasã capããrã Jesús berore ʉsayuparã. Bairo na cabairo ĩña, cʉ̃ pʉame ãmejorenʉcãrĩ atore bairo na ĩñupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ni jĩcãʉ̃ ũcʉ̃, yʉ mena caágaʉ nipetirã netõõrõ yʉre cʉ̃ camairõ ñuña. Cʉ̃ pacʉ, cʉ̃ paco, cʉ̃ nʉmo, cʉ̃ pũnaa, cʉ̃ jʉ̃gocʉjãã, cʉ̃ jʉ̃gocõjãã, cʉ̃ bairã nipetirã netõõrõ yʉre cʉ̃ camairõ ñuña. Cʉ̃ rupaʉ netõõrõ yʉre cʉ̃ camairõ ñuña. Tore bairo yʉre cʉ̃ camaieticõãta, yʉ cabueire bairo ãnimasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tunu bairoa ni jĩcãʉ̃ ũcʉ̃ yʉ mena caágaʉ, popiye cʉ̃ cabaigaeticõãta, yʉ cabueire bairo ãnimasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tunu ni jĩcãʉ̃ mʉjãã mena macããcʉ̃ caʉ̃mʉarĩ wiire cʉ̃ caqũẽnorotiparo jʉ̃goye cʉ̃ dinerore cõñajʉ̃go masĩñami mai, ‘¿Yʉ dinero yʉ cacʉ̃gorije to etaroati?’ ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bairo cʉ̃ cacõñaeticõãta, cabero ti wiire qũẽnopeyo masĩẽtĩbujioʉmi. Ʉ̃tãpãĩrĩ, na cacũjʉ̃goripãĩrĩrẽ na cacũyaparoro bero, cʉ̃ dinero cʉ̃ cacʉ̃gomirĩjẽ pʉame peticoabujioro. Bairi yua, nipetiro camasã cʉ̃ paariquere ĩñarĩ, cʉ̃ boyeti epebujiorãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bairo qũĩbujiorãma: ‘Ãni, cʉ̃ ya wiire paajʉ̃gomicʉ̃ã, paapeyo masĩẽtĩñami,’ qũĩbujiorãma camasã, cʉ̃ capaapeyoetoi. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Torea bairo jĩcãʉ̃ quetiupaʉ apei mena cʉ̃ ʉ̃mʉarẽ cʉ̃ caãmeo qũẽrotijoparo jʉ̃goye, atore bairo ĩ tʉ̃goña jʉ̃gobujioʉmi: ‘Yʉ ʉ̃mʉa, pʉga wãmo cãnacã mil majũ soldaua niñama. Yʉ wapana pʉame veinte mil majũ niñama. Bairo na cabairoi, ¿narẽ yʉ netõomasĩcʉti?’ ĩ tʉ̃goña jʉ̃gobujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","‘Yʉ netõõmasĩẽcʉ̃,’ cʉ̃ caĩtʉ̃goñaata, cʉ̃ wapana cayoaropʉa na caãno mai, cʉ̃ caquetibʉjʉnetõrotire na tʉpʉ cʉ̃ jobujioʉmi. ‘Marĩ ãmeo qũẽẽtĩcõãto. Ñugaro,’ na ĩjã qũĩ rotijobujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bairo bairi ni ũcʉ̃ mʉjãã mena macããcʉ̃ cʉ̃ yaye cʉ̃ camairĩjẽrẽ cʉ̃ cajãnaeticõãta, yʉ cabueire bairo ãnimasĩẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tunu bairoa moa caocarije ñujãñuña. Moa caocaetie roque ñerẽ átimasĩẽtĩña camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bairi moa caocarije capeticõã ʉsapata, ñe ũnie pʉamerẽ ñuẽtĩña. Yepa ũnorẽ, o abono ũno cʉ̃ãrẽ ñuẽtĩña. Rerique niña. Mʉjãã, caãmoocʉna mʉjãã ãniña. Bairi moa cabairijere mʉjããrẽ ĩcõñarĩ yʉ caquetibʉjʉrijere tʉ̃goãmewiyoya mʉjãã yeripʉ,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bairi ti watoa Roma macããnarẽ camasã yaye dinerore jejobojari majã, aperã carorije caána cʉ̃ã Jesús cʉ̃ caĩquetibʉjʉrijere tʉ̃gogarã, cʉ̃ tʉre etanucũñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bairo na caátó ĩña, fariseo majã Jesure qũĩ bʉsʉpaiyuparã. Aperã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ camasãrẽ cajʉ̃gobuerã mena qũĩ bʉsʉpaiyuparã atore bairo: —Cʉ̃, Jesús carorije caánarẽ boyami. Moena mena ʉgabapacʉti nucũñami —qũĩñuparã, Jesús cʉ̃ cabairijere ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bairo na caĩrõĩ, Jesús pʉame oveja cacoteire ĩcõñarĩ atore bairo na ĩ quetibʉjʉyupʉ: ");
INSERT INTO cbcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Ni ũcʉ̃ mʉjãã mena macããcʉ̃ cien oveja majũrẽ cʉ̃ cacʉ̃goata, bairi jĩcãʉ̃ na mena macããcʉ̃ cʉ̃ camawijiaata, jicoquei cʉ̃ macãʉ̃ ápéribujioʉcʉti? Jicoquei cʉ̃ macãʉ̃ ácoabujioʉmi. Noventa y nueve caãnarẽ ẽñotaricaropʉ cũcõã, jĩcãʉ̃ camawijiaatacʉre cʉ̃ macãʉ̃ ábujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bairi caʉ̃mʉ pʉame cabero ovejare cʉ̃ macã bócari, cʉ̃ pʉsa, tunuatíbujioʉmi ʉseanirĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bairo cʉ̃ ya wiipʉ tunueta, cʉ̃ bapare, bairi cʉ̃tʉ macããna cʉ̃ãrẽ na neñoporotibujioʉmi. Bairo na caetaro ĩña, na ĩbujioʉmi: ‘Jĩcãʉ̃ yʉ oveja, camawijiamiatacʉre merẽ cʉ̃ yʉ bócaapʉ. Bairi yʉ mena mʉjãã cʉ̃ã ʉseanirasá,’ na ĩbujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Caãnorẽ bairo mʉjããrẽ ñiña: Jõbui macããna netõjãñurõ ʉseaniñama ati yepa macããcʉ̃ carorije caátimiatacʉ cʉ̃ yerire cʉ̃ cawasoaro berore. Noventa y nueve camasã cañurã caroaro na caátiãnie netõrõ ĩñajesoyama jõbui macããna pʉame,” na ĩñupʉ̃ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ĩ yaparo, ape wãmerẽ ĩcõña quetibʉjʉyupʉ tunu: “¿Dico ũcõ carõmio moneda pʉga wãmo cãnacã tiiri majũrẽ cõ cacʉ̃goata, bairi jĩcã tii wiipʉ to cayasicoápata, jicoquei ti tiire cõ macãõ áperibujiocʉti? Jicoquei macãõ ácoabujioomo. Cõ jĩñaworique lámparare jĩñawori canaitĩãrõrẽã owa macãbujioomo caroaro mena. Bócaripʉ owa macãjãnabujioomo yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bairo carõmio pʉame cabero ti tiire macã bócari, cõ baparã rõmirĩrẽ, bairi cõtʉ macããna cʉ̃ãrẽ na neñopo rotibujioomo. Bairi na caetaro ĩña, na ĩbujioomo: ‘Jĩcã moneda tiire, cayasimiata tiire merẽ yʉ bócaapʉ. Bairi yʉ mena mʉjãã cʉ̃ã ʉseanirasá,’ na ĩbujioomo. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Caãnorẽ bairo mʉjããrẽ ñiña: Torea bairo Dios yarã ángelea majã cʉ̃ã ʉseaniñama ati yepa macããcʉ̃ carorijere caátimiatacʉ cʉ̃ yerire cʉ̃ cawasoaro berore,” na ĩñupʉ̃ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ĩ yaparo, ape wãme cʉ̃ãrẽ ĩ cõñañupʉ̃: “Jĩcãʉ̃ ãñupʉ̃ pʉgarã caʉ̃mʉarẽ capũnaacʉcʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bairi jĩcã rʉ̃mʉ cabai pʉame atore bairo qũĩñupʉ̃ cʉ̃ pacʉre: ‘Caacʉ mʉ cariaro bero, mʉ yaye mʉ cacʉ̃gomirĩqũẽrẽ yʉre na caricawopeere ãmeacã yʉ boya. “Jaʉ,” miwã,’ qũĩñupʉ̃ cʉ̃ pacʉre. Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ caĩrõrẽã bairo ásupʉ cʉ̃ pacʉ pʉame. Na, pʉgarãpʉrea na ricawoyupʉ cʉ̃ yayere yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bairo cabero, nocãnacã rʉ̃mʉ bero meea cabai pʉame cʉ̃ cacʉ̃gomiataje nipetirijere nunireyupʉ. Bairo áticõã, tie wapa dinerore ñerĩ, acoásúpʉ cayoaropʉ ape yepapʉ. Bairo topʉ eta, noo cʉ̃ rupaʉ caborije carorije jetore ásupʉ. Bairo ácʉ, tie dinerore átire peyocõãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bairi cʉ̃ dinero capetiro beropʉ, ti yepa macããjẽ ʉgarique cʉ̃ã peticoasuparo. Bairo cabairoi, caátácʉ pʉame aʉa riajʉ̃goyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bairo aʉariari, ti yepa macããcʉ̃rẽ paarique jẽni ásúpʉ. Bairo cʉ̃ cajẽnirõ, to macããcʉ̃ pʉame cʉ̃ yeseare cʉ̃ coterotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bairo na cote ãcʉ̃ yua, na caʉgarije, qũẽnu ũnierẽã ʉgagamiñupʉ̃ cʉ̃ cʉ̃ã, bʉtioro queyari. Camasã noa ũna ʉgariquere cʉ̃ nuesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bairo roro tãmʉorĩ cʉ̃ pacʉ paabojari majã na caátiãnierẽ tʉ̃goña bócayupʉ: ‘Caacʉ ʉ̃mʉa capããrã ãma. Ni ũcʉ̃ na mena macããcʉ̃ queyaemi. Na ʉgarique cʉ̃ã rʉsacõãnucũwʉ̃ na ya wiipʉre. ¡Yʉ roque atopʉ ãcʉ̃, aʉai yʉ riaya!’ ĩ tʉ̃goñañupʉ̃ cawãmaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ĩ tʉ̃goña, atore bairo ĩ tʉ̃goñanemoñupʉ̃ tunu: ‘Caacʉ tʉpʉ yʉ tunuágʉ tunu. Topʉ eta, qũĩña, atore bairo cʉ̃ ñigʉ: “Caacʉ, Dios mena roro yʉ átiapʉ. Mʉ mena cʉ̃ãrẽ roro yʉ átiapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bairo roro yʉ caátiataje jʉ̃gori, mʉ macʉ̃rẽ bairo yʉ ãmerĩña yua. Apei, mʉ paabojari majõcʉre bairo yʉre miñagʉ ãmerẽ,” cʉ̃ ñigʉ Caacʉre,’ ĩ tʉ̃goñañupʉ̃ cawãmaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bairo ĩ tʉ̃goña, torea bairo baiyupʉ. Maapʉ cʉ̃ pacʉ ya macã caátíwãrẽ tunu ásúpʉ yua. “Bairi jõpʉ̃ã mai cawãmaʉ cʉ̃ caãno, cʉ̃ pacʉ pʉame qũĩñajoyupʉ. Qũĩñajo yua, bopacooro qũĩñañupʉ̃ cʉ̃ macʉ̃rẽ. Bairi cʉ̃ tʉpʉ atʉ ásúpʉ. Bairo cʉ̃ atʉ bocá, caroaro cʉ̃ jẽni, cʉ̃ pabario, ʉseanirĩ cʉ̃ bocáyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bairo cʉ̃ caátimiatacʉ̃ãrẽ, cʉ̃ macʉ̃ pʉame tʉ̃goña yapapuari atore bairo qũĩñupʉ̃: ‘Caacʉ, Dios mena roro yʉ átiapʉ. Mʉ mena cʉ̃ãrẽ roro yʉ átiapʉ. Bairo roro yʉ caátiataje jʉ̃gori mʉ macʉ̃rẽ bairo yʉ ãmerĩña yua. Apei, mʉ paabojari majõcʉre bairo yʉre miñagʉ ãmerẽ,’ qũĩñupʉ̃ cawãmaʉ cʉ̃ pacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, cʉ̃ pacʉ pʉame cʉ̃ yʉesupʉ. Cʉ̃ paabojari majãrẽ jutii cʉ̃ macʉ̃ cʉ̃ cawasoapeere na neátí rotiyupʉ: ‘Tãmurĩ jutii caroa majũrẽ jeasá. Tunu bairoa anillo, yʉ macʉ̃ cʉ̃ cawãmojããpa beto cʉ̃ãrẽ neasá. Tunu bairoa rʉpo jutii cʉ̃ capeapee cʉ̃ãrẽ jeasá. Cʉ̃ marĩ jããto,’ na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Ĩ yaparo, bairo na ĩnemoñupʉ̃ tunu: ‘Marĩ wecʉ macʉ̃ caroaro majũ cariicʉcʉre cʉ̃ pajĩãrájá. Cʉ̃ marĩ ʉgaroa. Ãni, yʉ macʉ̃ cariacoabujioatacʉ nimicʉ̃ã, tunu cacatiatacʉre bairo niñami ãmerẽ. Cayasicoamirĩcʉ̃rẽ cʉ̃ marĩ bócaya tunu. ¡Bairi marĩ bose rʉ̃mʉ qũẽnoto! ¡Ʉseanirĩ marĩ ãnito!’ na ĩñupʉ̃ cʉ̃ pacʉ cʉ̃ ʉ̃mʉarẽ. Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ caĩrõrẽã bairo ásuparã. Bose rʉ̃mʉ qũẽno jʉ̃goyuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Bairo na cabaiãno, cajʉ̃gocʉ pʉame jõpʉ wesepʉ ãñupʉ̃. Bairo topʉ paatʉsa, wiipʉ tunucoásúpʉ tunu. Bairo tunuatí wiitʉ etayupʉ. Bairo etaʉ yua, na cabasarijere tʉ̃goyupʉ wiipʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bairo tʉ̃go, paabojari majõcʉ jĩcãʉ̃rẽ cʉ̃ piijori qũĩ jẽniñañupʉ̃: ‘¿Dope to baiyati?’ ");
INSERT INTO cbcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃: ‘Mʉ bai, tirʉ̃mʉpʉ cañesẽãʉ̃ ámirĩcʉ̃ etaami. Bairi catiia cʉ̃ catunuetaro ĩña, mʉ pacʉ pʉame wecʉ macʉ̃ caroaro majũ caʉsecʉcʉre jãã pajĩãrotiami. “Bose rʉ̃mʉ marĩ qũẽnoto,” ĩãmi mʉ pacʉ,’ qũĩñupʉ̃ paabojari majõcʉ cajʉ̃gocʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, asiacoasupʉ. Ti wiire jããgaesupʉ. Bairo cʉ̃ cabairo tʉ̃go, cʉ̃ pacʉ pʉame macãpʉ cʉ̃ pii asúpʉ, cʉ̃ jããparo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Cajʉ̃gocʉ pʉame cʉ̃ pacʉre cʉ̃ yʉesupʉ mai. ‘Caacʉ nocãrõ yoaro mʉ mena yʉ paanucũña. Di rʉ̃mʉ ũno mʉ yʉ botioetinucũña mʉ carotirijere. Bairo caroaro majũ mʉrẽ yʉ caĩroamiatacʉ̃ãrẽ, di rʉ̃mʉ ũno jĩcãʉ̃ãcã ũcʉ̃ marĩ canuʉrẽ yʉ mʉ pajĩãrotiepʉ. “Mʉ baparã mena ʉseanirĩ bose rʉ̃mʉ qũẽnoña,” yʉ miepʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ãmerẽ ãni mʉ macʉ̃, carõmia caʉ̃mʉ mena caepewapatarã mena mʉ dinerore caátireatacʉ pʉame etaupi. Bairo cʉ̃ catunuetaro ĩña, jicoquei mʉ pʉame jĩcãʉ̃ wecʉ macʉ̃ caroaro majũ caʉsecʉcʉre cʉ̃ mʉ pajĩãrotiupa, bose rʉ̃mʉ marĩ qũẽñoto, ĩ. Bairo mʉ caáto ñuetõ,’ qũĩñupʉ̃ cajʉ̃gocʉ cʉ̃ pacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ cʉ̃ pacʉ: ‘Macʉ̃ mʉa, yʉ mena mʉ ãninucũña. Bairi yʉ yaye nipetirije mʉ yaye niña. ");
INSERT INTO cbcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mʉ bai pʉame cariacoabujioatacʉ nimicʉ̃ã, tunu cacatiatacʉre bairo niñami ãmerẽ. Cayasicoamirĩcʉ̃rẽ cʉ̃ marĩ bócaya tunu. Bairi marĩ caʉseanirõ ñuña. Bose rʉ̃mʉ marĩ caqũẽnorõ ñuña,’ qũĩñupʉ̃ capacʉ cʉ̃ macʉ̃ cajʉ̃gocʉre yua,” ĩcõñarĩ na ĩ quetibʉjʉyupʉ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ĩ quetibʉjʉ yaparo, ape wãmerẽ ĩcõñarĩ atore bairo na ĩ quetibʉjʉyupʉ cʉ̃ cabuerãrẽ: “Jĩcãʉ̃ capee apeye ũnierẽ cacʉ̃goʉ pʉame ʉ̃mʉ cʉ̃goyupʉ cʉ̃ roca carotimasĩrẽ, mayordomo na caĩrẽ. Bairo cʉ̃rẽ cʉ̃ cacʉ̃gomiatacʉ̃ãrẽ, mayordomo pʉame cʉ̃ dinerore cʉ̃ átiyasio rebojayupʉ cʉ̃ quetiupaʉ yayere. Bairo cʉ̃ caátoi, aperã pʉame cʉ̃ bʉsʉjãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bairo na caĩrõ tʉ̃go, cʉ̃ ʉ̃mʉrẽ cʉ̃ piijori atore bairo qũĩñupʉ̃: ‘Mepʉ yʉ quetibʉjʉama roro mʉ caátiere. ¿Dope bairo mʉ átiati yʉ yaye dinero mena? Tocãrõã yʉ mena mʉ paaetigʉ. Yʉ roca jãñurĩ carotibojaʉ mee mʉ ãnigʉ yua. Bairi cõñarĩ mʉ quetibʉjʉ woatugʉ yʉ yaye carʉsarijere,’ qũĩñupʉ̃ cʉ̃ quetiupaʉ cʉ̃ mayordomorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bairo cʉ̃ caĩrõ tʉ̃go, mayordomo pʉame tʉ̃goña macãñupʉ̃: ‘¿Dope bairo yʉ ácʉati ãmerẽ? Yʉre caroti yʉ paariquere yʉ wiyogayami. Ñerẽ yʉ paaecʉ ãmerẽ. Oterica yepare yeseari yʉ paawẽpʉ̃ẽcʉ̃. Tunu bairoa aperãrẽ dinerore yʉ jẽnibobojãñucʉpʉ. Bairi, ¿dope bairo yʉ ácʉati ãmerẽ?’ ĩ tʉ̃goña macãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ĩ tʉ̃goña yua: ‘Yʉ caátipeere merẽ yʉ masĩña, yʉ quetiupaʉ yʉre cʉ̃ cawiyoro bero, aperã na ya wiiripʉ yʉre na camaiparore bairo ĩ,’ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bairo ĩ yaparo yua, cʉ̃ quetiupaʉre cawapamorãrẽ jĩcããrã jeto na piijoneño jʉ̃goyupʉ, yʉ mena na bʉsʉpẽniató, ĩ. Bairi cʉ̃ capiijʉ̃goʉ cʉ̃ caetaro ĩña, atore bairo qũĩñupʉ̃: ‘¿Nocãrõ majũ yʉ quetiupaʉre mʉ wapamoñati?’ qũĩ jẽniñañupʉ̃ mayordomo pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃: ‘Pairo, cien raperi majũ aceituna oco rapeerire cʉ̃ yʉ wapamoña,’ qũĩñupʉ̃ caetajʉ̃goʉ mayordomorẽ. Bairo cʉ̃ caĩrõ tʉ̃go: ‘Ato ruiya mai. Ato niña mʉ cawapamorĩjẽrẽ caquetibʉjʉri pũrõ. Cien mʉ cawapamorõrẽ coseya. Cincuenta pʉame woatuya tunu. ¡Tãmurĩ ása!’ qũĩñupʉ̃ mayordomo caetajʉ̃goʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cabero etayupʉ tunu apei. Bairo cʉ̃ caetaro ĩña, bairoa qũĩñupʉ̃ tunu: ‘¿Nocãrõ majũ yʉ quetiupaʉre mʉ wapamoñati?’ qũĩ jẽniñañupʉ̃ mayordomo pʉame. Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃: ‘Pairo, trigo ʉgariquere cien piiri majũ cʉ̃ yʉ wapamoña,’ qũĩñupʉ̃ cabero macããcʉ̃ mayordomorẽ. Bairo cʉ̃ caĩrõ tʉ̃go, ‘Ato niña mʉ cawapamorĩjẽrẽ caquetibʉjʉri pũrõ. Cien mʉ cawapamorõrẽ coseya. Ochenta pʉame woatuya,’ qũĩñupʉ̃ mayordomo cabero macããcʉ̃rẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Cabero yua, quetiupaʉ pʉame cʉ̃ ʉ̃mʉ caróʉ, bairo cʉ̃ caáto tʉ̃goñamasĩrĩ, ‘¡Nocãrõ cʉ̃ masĩñati!’ qũĩ tʉ̃goñañupʉ̃,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃: “Bairo baiyama ati yepa macããna. Ĩto masĩjãñuñama, mayordomo cʉ̃ caĩtorore bairo. Bairi Dios yarã cabusuropʉ caánárẽ bairo caãna netõõrõ átiãni masĩjãñuñama ati yepapʉre.” ");
INSERT INTO cbcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Caãnorẽ bairo mʉjããrẽ ñiña: Mʉjãã pʉame mʉjãã yaye dinero mena caroaro ása. Ati yepa macããna carorã na caátiqũẽno cʉ̃gorijere caroaro ása. Cabopacarãrẽ dinerore na joya, mʉjãã mena na caʉseaniparore bairo ĩrã. Bairo mʉjãã caápata, jõbuipʉ mʉjãã caetaro, ʉseanirĩqũẽ mena mʉjããrẽ bocágarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Noo jĩcãʉ̃ ũcʉ̃ nʉcʉ̃rĩ yeri pũna mena apeye petoaca caãnie ũnierẽ cʉ̃ caĩñarĩcãnʉgõ masĩata, paijãñurõ caãnie ũnie cʉ̃ãrẽ ĩñaricanʉgõ masĩbujioʉmi. Apei, nʉcʉ̃rĩ yeri pũna mena mee apeye petoaca caãnie ũnierẽ cʉ̃ caĩñarĩcãnʉgõmasĩẽtĩcõãta, paijãñurõ caãnie ũnie cʉ̃ãrẽ ĩñaricanʉgõetibujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Torea bairo mʉjãã ati yepa macããjẽ pairo cawapacʉtiere nʉcʉ̃rĩ yeri pũna mena mʉjãã caĩñarĩcãnʉgõ masĩẽtĩcõãta, noa ũna jõbui macããjẽ nocãrõ cañurĩjẽ quetire mʉjããrẽ quetibʉjʉ cũẽnama. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tunu bairoa apei yaye cʉ̃ cacʉ̃gorijere nʉcʉ̃rĩ yeri pũna mena mʉjãã caĩñarĩcãnʉgõ masĩẽtĩcõãta, noa ũna mʉjãã yaye caãnipeere mʉjãã joenama. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tunu bairoa paabojari majõcʉ ni jĩcãʉ̃ ũcʉ̃ pʉgarãpʉa cʉ̃ quetiuparã na caĩrõrẽ bairo átimasĩẽtĩñami, jĩcãrõrẽã bairo na carotimasĩẽtĩcõãta. Bairo na cabaiata, jĩcãʉ̃rẽ qũĩroabujioʉmi. Apeire qũĩroaetibujioʉmi. Jĩcãʉ̃ mena yeri ñugʉmi. Apeire qũĩñategʉmi. Torea bairo mʉjãã cʉ̃ã dinerore mʉjãã cabotʉ̃goñaata, Dios yaye mʉjããrẽ cʉ̃ caátirotirijere mʉjãã ĩñatebujiorã,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseo majã pʉame dinerore catʉ̃goñamaimajũcõãrã ãnirĩ cʉ̃ caĩrĩjẽrẽ tʉ̃gomirãcʉ̃ã, cʉ̃ caĩrĩjẽrẽ cariape tʉ̃gopeoesuparã. Cʉ̃ bócaboyeti epecõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bairo na cabairo ĩña, Jesús pʉame atore bairo na ĩñupʉ̃: “Mʉjãã camasãrẽ caĩtorã mʉjãã ãniña. Camasã na caĩñarõpʉra caroarã majũ mʉjãã bauya, camasã watoa ãna. Baipʉa, Dios pʉame roque bairo mʉjãã cabaimiatacʉ̃ãrẽ, masĩjãñuñami roro mʉjãã yeri pũna caãnierẽ. Tunu bairoa dise ũnierẽ, ‘Cabʉgoro macããjẽ mee ñiña atie,’ camasã na caĩwãmetimiatacʉ̃ãrẽ, Dios pʉame tiere ĩñatejãñuñami,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ĩ quetibʉjʉ yaparo, atore bairo na ĩ quetibʉjʉ nemoñupʉ̃ tunu: “Moisés ãnacʉ̃ camasã na caátipeere cʉ̃ caroticũrĩqũẽ, bairi profeta majã na caquetibʉjʉcũrĩqũẽ cʉ̃ã mʉjãã jʉ̃goãñupã, Juan camasãrẽ cabautizamirĩcʉ̃ cʉ̃ caetaparo jʉ̃goye. Ati rʉ̃mʉrĩrã caroa queti, Dios cʉ̃ carotimasĩrĩpaʉ caetarore tʉ̃gorã átiyama camasã. Bairo na catʉ̃goro jʉ̃gori cʉ̃ carotimasĩrĩpaʉre jããmasĩõ joroque na átiya tie caroa queti. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Bairopʉa, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ pʉame nicõãgaro. Noa ũna mʉjãã mena macããna ati ʉmʉrecore, ati yepa cʉ̃ãrẽ átiyasiomasĩẽtĩñama. Torea bairo Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽ jĩcã wãmeacã ũno cʉ̃ãrẽ átiyasio masĩẽtĩñama camasã. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Bairi ni jĩcãʉ̃ ũcʉ̃ cʉ̃ nʉmorẽ cʉ̃ capitiata, bairi apeo mena cʉ̃ cawãmojiyaata, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ caápei niñami. ‘Apeo mʉ nʉmo mee caãcõ mena ãmerĩcõãña,’ cʉ̃ caĩcũrĩqũẽrẽ caápei niñami. Tunu bairoa apei camanapʉ pitirico mena cʉ̃ cawãmojiyaata, cʉ̃ cʉ̃ã Moisés cʉ̃ caroticũrĩqũẽrẽ caápei niñami,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ĩ quetibʉjʉ yaparo, ape wãmerẽ ĩcõñarĩ na ĩnemoñupʉ̃ tunu: “Jĩcãʉ̃ caʉ̃mʉ ãñupʉ̃ pairo cadinero cʉ̃goʉ. Cʉ̃ pʉame jutii caroa caʉgueri manie jetore jãñanucũñupʉ̃. Bairi nʉcʉ̃bʉgorique mena ãninucũñupʉ̃, caroa majũrẽ cajutii jãñaʉ ãnirĩ. Tunu bairoa tocãnacã rʉ̃mʉa bose rʉ̃mʉrĩ qũẽnonucũñupʉ̃ caroa rʉ̃mʉrĩ majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tunu bairoa ãñupʉ̃ jĩcãʉ̃ cabopacaʉ, Lázaro cawãmecʉcʉ. Cʉ̃ pʉame bopacooro ãninucũñupʉ̃. Cãmii boarique cʉ̃goyupʉ. Bairo bopacaʉ ãnirĩ, pairo cadinero cʉ̃goʉ jopetʉre ruinucũñupʉ̃ yepapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bairo bopacaʉ ãnirĩ pairo cadinero cʉ̃goʉ cʉ̃ caʉgañorĩjẽrẽ, cʉ̃ mesa roca cañarĩjẽrẽ ʉgaganucũmiñupʉ̃. Bairo ʉgamicʉ̃ã, dope átimasĩẽsupʉ. Roro netõrõ baiyupʉ. Nurĩcãrã yaia cʉ̃ cãmiirẽ cʉ̃ weronucũñuparã roro majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bairi yua, jĩcã rʉ̃mʉ cabopacaʉ pʉame riacoásúpʉ. Bairo cʉ̃ cabaiyasiro yua, ángelea majã cʉ̃ necoásúparã Abraham ãnacʉ̃ cʉ̃ caãnopʉ, nocãrõ caroaro caãnopʉ yua. Bairo cabopacaʉ ãnacʉ̃ cʉ̃ cabaiyasiro bero, pairo cadinero cʉ̃gomirĩcʉ̃ cʉ̃ã riacoásúpʉ. Bairo cʉ̃ cabaiyasiro ĩña, cʉ̃ yarocacõãñuparã cʉ̃ ãnacʉ̃ yarã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Bairi yua, dinero pairo cacʉ̃gomirĩcʉ̃ pʉame roro majũ netõñupʉ̃ cariaricarã ãnana cañuena na caãnopʉre yua. Bairo topʉ ãcʉ̃, ĩñamʉgõjoyupʉ jõbuipʉ. Bairo ĩñamʉgõjoʉ majũ, qũĩñabocayupʉ Abraham ãnacʉ̃rẽ. Lázaro ãnacʉ̃ cʉ̃ãrẽ qũĩñañupʉ̃ Abraham menapʉ cʉ̃ caãno. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bairo na ĩña yua, atore bairo qũĩñupʉ̃ pairo cadinero cʉ̃gomirĩcʉ̃ pʉame Abraham ãnacʉ̃rẽ, topʉ caãcʉ̃rẽ, bʉsʉrique tutuaro mena: ‘Jãã ñicʉ̃ Abraham, tʉ̃goya mai yʉ caĩrĩjẽrẽ. ¡Yʉ bopaca ĩñaña! Roro netõʉ̃ yʉ baicʉpʉ atopʉre. Bairi Lázarore cʉ̃ joya yʉ tʉpʉ. Cʉ̃ wãmojũã yapaaca mena ocopʉ weyori, yʉ ñemerõrẽ cʉ̃ yʉsʉoʉ apáro. Bʉtioro majũ bopacooro yʉ netõcʉpʉ, ati peero caʉ̃jãnaeti peerore ãcʉ̃,’ qũĩñupʉ̃ pairo cadinero cʉ̃gomirĩcʉ̃ Abrahãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, atore bairo qũĩñupʉ̃ Abraham ãnacʉ̃ pʉame pairo cadinero cʉ̃gomirĩcʉ̃rẽ: ‘Yʉ pãrãmi, mʉa caroaro mʉ ãmʉ ji yepapʉre. Caroaro netõrõ majũ mʉ ãmʉ mʉ yarã mena. Ãni, marĩ yaʉ, Lázaro pʉame roque roro majũ netõwĩ, topʉ ãcʉ̃. Bopacooro baiwĩ. Bairi ãmerẽ cʉ̃ ʉseanio joroque cʉ̃ jãã átiya atopʉre. Yerijãʉ̃ átiyami bopacooro canetõrĩcʉ̃ ãnirĩ. Mʉa, ãni Lázaro cʉ̃ cayerijãrõ ũnoa, mʉ pʉame bopacooro mʉ netõña caroaro caãnacʉ̃ ãnirĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tunu mʉrẽ ñiña: Ato jãã caãno pairi ope, ope caãni ẽñotarore bairo niña. Bairi topʉ caãna, dope bairo atímasĩẽnama atopʉre. Tunu bairoa, dope ámasĩẽnama ato caãna pʉame cʉ̃ã mʉjãã tʉpʉre. Bairi dope bairo ámasĩẽcʉ̃mi Lázaro cʉ̃ã mʉ tʉpʉre,’ qũĩñupʉ̃ Abraham ãnacʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩnemoñupʉ̃ pairo cadinero cʉ̃gomirĩcʉ̃ pʉame Abrahãrẽ tunu: ‘Jãã ñicʉ̃ Abraham mʉrẽ ñiña: Toroque Lázarore cʉ̃ árotiya yʉ pacʉ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Topʉ ãnama yʉ bairã jĩcã wãmo cãnacãʉ̃ majũ yʉrea bairo caãna. Bairi Lázaro narẽ cʉ̃ quetibʉjʉ ápáro, “Na cʉ̃ã roro bopacooro netõrema ati peero caʉ̃jãnaeti peerore na cariari rʉ̃mʉ,” ĩ,’ qũĩñupʉ̃ pairo cadinero cʉ̃gomirĩcʉ̃ Abrahãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bairo cadinero cʉ̃gomirĩcʉ̃ cʉ̃ caĩrõ tʉ̃go, atore qũĩñupʉ̃ Abraham pʉame: ‘Merẽ na, ji yepa macããna Moisés ãnacʉ̃, bairi profeta majã ãnana na caquetibʉjʉwoatucũñarĩqũẽrẽ masĩñama. Bairi tie na caquetibʉjʉwoatucũñarĩqũẽrẽ na tʉ̃goʉsaáto, atore roro tãmʉogaena,’ qũĩñupʉ̃ Abraham pairo cadinero cʉ̃gomirĩcʉ̃rẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ yʉyupʉ pairo cadinero cʉ̃gomirĩcʉ̃ Abrahãrẽ tunu: ‘Jãã ñicʉ̃ Abraham, bairoa baiya bairopʉa. Bairo cabaimiatacʉ̃ãrẽ, yʉ yarã pʉame tʉ̃goʉsaetiyama. Bairi cariacoatacʉ tunu cacati roquere qũĩñarĩ, caroaro cʉ̃ caĩrĩjẽ roquere tʉ̃goʉsa jʉ̃gobujiorãma. Na yerire tʉ̃goña wasoabujiorãma yʉ yarã,’ qũĩñupʉ̃ pairo cadinero cʉ̃gomirĩcʉ̃ pʉame Abrahãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩ tʉsayupʉ Abraham pʉame: ‘Moisés ãnacʉ̃, bairi profeta majã na caĩquetibʉjʉwoatucũñarĩqũẽrẽ na catʉ̃goʉsagaeticõãta, ti yepa macããna mʉ yarã, cariacoatacʉ tunu cacati cʉ̃ caĩrĩjẽ cʉ̃ãrẽ tʉ̃goʉsaetibujiorãma,’ qũĩ jãnañupʉ̃ Abraham pʉame pairo cadinero cʉ̃gomirĩcʉ̃rẽ yua,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús atore bairo na ĩñupʉ̃ cabero tunu cʉ̃ cabuerãrẽ: “Mʉjããrẽ ñiña: Tocãnacãnia nigarãma ati yepapʉre roro cajʉ̃goĩrĩ majã. Roro majũ baiyama camasã na caátie jʉ̃gori. Netõjãñurõ yʉ pʉame bopacooro na ñiñaña, roro caĩtori majãrẽ. ¡Na roquere bopacooro netõrõ na baio joroque na átigʉmi Dios, na yaye wapa! ");
INSERT INTO cbcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bairi atore bairo ñi tʉ̃goñaña yʉ bʉsʉriquere camasĩpeyoenarẽ roro cajʉ̃goĩrĩ majãrẽ: Ʉ̃tãã capairica mena na wãmʉarĩrẽ jiyaturi, ria capairiyapʉ na carurecõãpee niña. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bairi mʉjããrẽ ñiña: Caroaro ása. ¡Mʉjãã cʉ̃ã mʉjãã yasire! “Ni jĩcãʉ̃ ũcʉ̃ mʉjãã yaʉ, roro cʉ̃ caápata, cʉ̃ quetibʉjʉya tutuaro mena. Bairi cʉ̃ pʉame tunu cʉ̃ catʉ̃goñawasoata, cʉ̃ masiriyobojaya. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bairi mʉjããrẽ ñiña tunu: Mʉjãã yaʉ jĩcã rʉ̃mʉrẽ jĩcã wãmo peti pʉga pẽnirõ cãnacãni majũ mʉjããrẽ roro cʉ̃ caápata, ñuña. Bairi cʉ̃ pʉame tunu jĩcã wãmo peti pʉga pẽnirõ cãnacãni majũ, ‘Mʉjããrẽ pʉgani yʉ áperigʉ tore bairo,’ mʉjããrẽ cʉ̃ caĩata, cʉ̃ mʉjãã camasiriyobojapee niña tocãnacãnia cʉ̃ caĩata,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Cabero tunu, atore bairo qũĩ jẽniñuparã cʉ̃ cabuerã Jesús, marĩ Quetiupaʉre: —Jããrẽ paijãñurõ Dios mena tʉ̃goñatutuariquere jãã jonemoña —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃: —Yʉ yarã mʉjããrẽ ñiña: Mostaza cawãmecʉtii apeacã, õcã apeacã majũ niña. Tiacarẽ bairo petoaca Dios mena mʉjãã catʉ̃goñatutuaata, yucʉ capairicʉre etari, tiire, ‘Wãáti ria capairiyapʉ etanʉcãrõjã,’ mʉjãã caĩata, mʉjãã caĩrõrẽã bairo baibujioro tii yucʉ pʉame —na ĩ quetibʉjʉyupʉ Jesús, bairo na caĩjẽniñarõ cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Na ĩ quetibʉjʉ yaparo, na ĩnemoñupʉ̃ tunu Jesús: “¿Ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃, cʉ̃rẽ paacoteri majõcʉ cʉ̃ cacʉ̃goata, wesepʉ cʉ̃ quetiupaʉ wecʉare na nuʉ, o yepa cʉ̃ caoteparore qũẽnoʉ caatíatacʉ cʉ̃ caetaro ĩña, cʉ̃ quetiupaʉ pʉame: ‘Tãmurĩ etanumurĩ ʉgaya ʉgariquere,’ cʉ̃ qũĩbujiocʉti capaatacʉ cʉ̃ caetaroi? ");
INSERT INTO cbcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ĩẽcʉ̃mi yʉra. Atore bairo pʉame qũĩbujioʉmi: ‘Tãmurĩ ʉgarique qũẽnorĩ yʉ jeasá. Ʉgagʉ yʉ átiya. Bairi etirique cʉ̃ãrẽ yʉ joya. Mʉa, cabero mʉ ʉgawa yʉ caʉgayaparoro bero,’ qũĩbujioʉmi cʉ̃tʉ macããcʉ̃rẽ cʉ̃ quetiupaʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tunu bairoa cʉ̃ capaacoteri majõcʉre: ‘Yʉ mena mʉ ñujãñuña. Bairi mʉ mena yʉ ʉseaniña,’ qũĩ pitietibujioʉmi cʉ̃ quetiupaʉ pʉame cʉ̃ ʉ̃mʉ cʉ̃ caʉgarique nuu yaparoro berore. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bairi mʉjãã pʉame Dios mʉjããrẽ cʉ̃ caroticũrĩqũẽrẽ nipetirijere átipeyorã, atore bairo mʉjãã caĩpee niña: ‘Dios cʉ̃ carotirã marĩ ãniña. Bairi cʉ̃ caroticũrĩqũẽ jetore cʉ̃ marĩ jʉátibojaya. Bairi noa ũna marĩ mena macããna, “Caãnimajũrãrẽ bairo jããrẽ ĩñaña, jãã capaayaparoroi,” caĩmasĩrã maniñama,’ mʉjãã caĩpee niña,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cabero Jesús Jerusalén macãpʉ ácʉ́, Samaria bairi Galilea na caĩrĩ yepa watoare netõásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bairo ácʉ́, etayupʉ jĩcã macããcãrẽ. To cʉ̃ caetaro ĩña yua, pʉga wãmo cãnacãʉ̃ majũ caʉ̃mʉa witi asúparã, na rupaʉri cacãmii boarã pʉame, Jesure cʉ̃ bocárã aná. Bairo atímirãcʉ̃ã, Jesús tʉpʉ etaesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jõõpʉ̃ã tuari atore bairo qũĩ bʉsʉjoyuparã bʉsʉrique tutuaro mena: —¡Jesús cabuei, jããrẽ bopacooro jãã ĩñaña! ");
INSERT INTO cbcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bairo na caĩrõ, na ĩñajõõ, atore bairo na ĩ joyupʉ Jesús pʉame: —Jaʉ, mʉjããrẽ yʉ catiogʉ. Bairi ánája sacerdote majã tʉpʉ. Na quetibʉjʉrájá mʉjãã cabaiatajere —na ĩñupʉ̃ Jesús. Bairo cʉ̃ caĩrõ tʉ̃go, acoásúparã. Bairo na caátutuato, na cãmii caboamiataje na rupaʉrire peticoasuparo, cosericarore bairo yua, na riaye caãnimiataje. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bairi yua, na mena macããcʉ̃ jĩcãʉ̃ tiere ĩñarĩ, bʉtioro cʉ̃ basapeoyupʉ Diore, bʉsʉrique tutuaro mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bairo ĩ yua, na mena caámiatacʉ tunuatí, Jesús riape, yepapʉ cʉ̃ rʉpopaturi mena etanumurĩ qũĩroayupʉ. “Yʉ mena mʉ ñumajũcõãña,” qũĩñupʉ̃ Jesure cacãmii boamiatana mena macããcʉ̃ jĩcãʉ̃ pʉame. Cʉ̃ pʉame Samaria yepa macããcʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Cʉ̃rẽ qũĩña, atore bairo qũĩñupʉ̃ Jesús pʉame: —¿Noate aperã mʉ yarã? ¿Mʉ, jĩcãʉ̃ ató mʉ ãniati? Yʉa, pʉga wãmo caãnacʉ̃ã ãnama, mʉjãã ñiapʉ̃. ¿Noate aperã jĩcã wãmo peti baparicãnacãʉ̃ caãniatana? ");
INSERT INTO cbcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ãni, apero macããcʉ̃ jeto ató Diore cʉ̃ basapeo masĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ĩ yaparo, atore bairo qũĩnemoñupʉ̃ tunu: —Wãmʉnʉcãrĩ tunu ácʉ́ja mʉ ya wiipʉ. Yʉ mena mʉ catʉ̃goñatutuarije jʉ̃gori mʉ riayere yʉ netõõcõãña —qũĩñupʉ̃ Jesús cacãmii boamiatana pʉga wãmo cãnacãʉ̃ majũ mena macããcʉ̃ jĩcãʉ̃rẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jĩcãni fariseo majã atore bairo qũĩ jẽniñañuparã Jesure: “¿Nocãrõpʉ Dios cʉ̃ carotimasĩrĩpaʉ to etaroati?” Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús pʉame: —Dios cʉ̃ carotimasĩrĩpaʉ baujaro etaetigaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tunu bairoa ĩẽtĩgaro: ‘Atoa niña merẽ,’ o ‘Jõõ bauya,’ mʉjããrẽ ĩã manigaro. Merẽ Dios cʉ̃ carotimasĩrĩpaʉ mʉjãã recomacãpʉ niña —na ĩñupʉ̃ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ĩ yaparo, atore bairo na ĩñupʉ̃ cʉ̃ cabuerãrẽ: “Jĩcã rʉ̃mʉ mʉjããrẽ atore bairo tʉ̃goñarĩqũẽ etagaro: ‘Jĩcã rʉ̃mʉ ũno majũ marĩ ĩñagamiña Jesús, Camasã Jʉ̃gocʉre,’ mʉjãã ĩ tʉ̃goñagarã. Bairo yʉre mʉjãã caĩñagamiatacʉ̃ãrẽ, yʉ bauetigʉ,” na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ĩ yaparo, na ĩnemoñupʉ̃ tunu: “Aperã ĩgarãma: ‘Ati macãpʉ etaupʉ,’ o ‘Jĩ macãpʉ etaupʉ,’ ĩgarãma. Bairo na caĩmiatacʉ̃ãrẽ, cariape na mʉjãã tʉ̃goetigarã. Mʉjãã ápérigarã. Na caĩrĩjẽrẽ na mʉjãã tʉ̃goʉsaetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bairi mʉjããrẽ ñiña: Bʉpo cʉ̃ cayaberije mena ʉmʉrecóore jĩñawoyami pʉgatuapʉa. Torea bairo yʉ, Camasã Jʉ̃gocʉ nemo ati yepapʉre yʉ catunuatí rʉ̃mʉrẽ yʉ baigʉ. Yoaro mee yʉ bauetagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Baipʉa mai, caãnijʉ̃goro bairo yʉ baijʉ̃gogʉ: Ati yepapʉre roro popiye yʉ netõgʉ. Camasã, ati yepa macããna ñiñatejãñugarãma ati yʉtea macããna pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé ãnacʉ̃ cʉ̃ caãniyʉteare cabaiyaricarorea bairo baigaro nemo yʉ, Camasã Jʉ̃gocʉ ati yepapʉre yʉ catunuatí rʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Atore bairo baiyayuparã camasã mai Noé ãnacʉ̃ cʉ̃ caãni yʉteapʉre: Camasã caroaro ãñuparã. Eti, ʉga, bairi tunu wãmo jiya átiãñuparã, ñe ũno jĩcã wãmeacã cabaiãnipeere tʉ̃goñarĩ mee. Noé, cũmua capairicare cʉ̃ caájããrĩ rʉ̃mʉpʉ bairo baijãnañuparã. Ti rʉ̃mʉa ati yepare ruayuparo. Bairo caruaro, camasã nipetiro ruayasi peticoasuparã, caroaro ʉseanirõ caãnimiatana yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Torea bairo baiyupa Lot cʉ̃ caãni yʉteapʉ cʉ̃ãrẽ: Camasã ʉseanirõ ãñupã. Eti, ʉga, apeye ũnierẽ wapatijee áticõã, tunu nuni, oterique cʉ̃ãrẽ ote, wiiri cʉ̃ãrẽ caroa qũẽnorĩ ãñuparã, ñe ũnie rʉsaricaro mano, Lot ãnacʉ̃ cʉ̃ caãni yʉteapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bairi Lot ti macã, Sodoma macãrẽ cʉ̃ cawitiro bero, oco ocarore bairo wẽñuparõ. Peerori, azufre mena asuyaro jõbui ʉmʉrecóopʉ caatíe ñañuparõ. Tie mena yasi peticoasuparã ti macã Sodoma ãnatõ macããna ãnana. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Torea bairo baigaro nemo yʉ, Camasã Jʉ̃gocʉ yʉ cabauetari rʉ̃mʉrẽ,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãre. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ĩ quetibʉjʉ yaparo, na ĩnemoñupʉ̃ tunu: “Ti rʉ̃mʉ caetarore jĩcãʉ̃ ũcʉ̃ wii cabuimacã arʉapʉ cʉ̃ caãmata, ruiatíri, cʉ̃ apeyere, ape arʉapʉ caãnierẽ cʉ̃ jei ápéricõãto. Tunu bairoa cʉ̃, wesepʉ caãcʉ̃ cʉ̃ wiipʉ cʉ̃ tunu apéricõãto. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tʉ̃goña masĩnemoñijate Lot nʉmo ãnacõ cõ cabaiyariquere. Roro baiyupo. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bairi mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ caãnie pʉamerẽ mairĩ, yʉ yaye quetire jãnacõãgʉmi. Bairi maimicʉ̃ã, yasicoagʉmi yua. Apei roque yʉ yaye quetire cajãnaecʉ roque caticõã ãninucũgʉmi. Cʉ̃rẽ na capajĩã rocacoamiatacʉ̃ãrẽ, caticoa ãninucũgʉmi tunu. Cʉ̃ ũcʉ̃ pʉame netõgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Mʉjããrẽ caãnorẽ bairo ñiña: Yʉ, Camasã Jʉ̃gocʉ nemo yʉ caetari rʉ̃mʉ caãno, ti ñamirẽ jĩcã camapʉ pʉgarã cãnigarãma. Bairo pʉgarã nimirãcʉ̃ã, jĩcãʉ̃ã cʉ̃ mena macããcʉ̃ jeto neáecogʉmi. Apei cʉ̃ bapa pʉame neáecoetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tunu bairoa pʉgarã rõmia rupa bari trigo wãĩãnigarãma. Bairo pʉgarã rõmia nimirãcʉ̃ã, jĩcãõã cõ mena macããcõ jeto neáecogomo. Apeo pʉame neáecoetigomo. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tunu bairoa pʉgarã wesepʉ nigarãma. Bairo pʉgarã nimirãcʉ̃ã, jĩcãʉ̃ã cʉ̃ mena macããcʉ̃ jeto neáecogʉmi. Apei pʉame neáecoetigʉmi,” na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ jẽniñañuparã: —Jãã quetiupaʉ, ¿noopʉ to bairoati atie mʉ caĩquetibʉjʉrije? Cʉ̃ pʉame atore bairo na ĩ yʉyupʉ: —Noo rupaʉri ãnajẽ cacũñarõ, yucaa cʉ̃ã topʉ neñaetagarãma —na ĩ yʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Cabero Jesús ĩcõñarĩ na quetibʉjʉyupʉ, jẽnijʉtimirãcʉ̃ã Diore cʉ̃ na cajẽnijãnaetiparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Atore bairo na ĩñupʉ̃: “Ãñupʉ̃ jĩcãʉ̃ quetiupaʉ juez na caĩ. Cʉ̃ pʉame nipetirãrẽ cauwiecʉ ãñupʉ̃. Bairi Dios cʉ̃ãrẽ ĩroaesupʉ. Tunu bairoa camasãrẽ na nʉcʉ̃bʉgoesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cʉ̃, juez cʉ̃ caãni macãrẽã ãñupõ jĩcãõ cawapeao cʉ̃ã. Cõ pʉame aperã roro na caĩepeo ãñupõ, na pesuore bairo caãcõ. Bairi cawapeao pʉame tocãnacãnia ánucũñupõ juez quetiupaʉ tʉpʉ. Cʉ̃rẽ, ‘Tocãrõã yʉre na patowãcõẽtĩcõãtõ yʉre roro caĩrãrẽ na mʉ quetibʉjʉwa, mʉ, quetiupaʉ ãnirĩ,’ qũĩõ acó ánucũñupõ tocãnacãnia. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Baipʉa, quetiupaʉ juez pʉame capee majũ cõ jʉátigaesupʉ. Bairo jʉátigaetimicʉ̃ã, cabero atore bairo ĩ tʉ̃goñañupʉ̃: ‘Diore caĩroaecʉ yʉ ãniña. Tunu bairoa camasã cʉ̃ãrẽ na yʉ nʉcʉ̃bʉgoetiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Bairo cabai yʉ caãnimiatacʉ̃ãrẽ, atio pʉame yʉ pajʉ̃go jãnaẽtĩñamo. Bairi, yʉre tocãrõã cõ pajʉ̃go jãnato. Nairõ yʉ tʉre cõ apéricõãto ĩ, cõ yʉ jʉátigʉ,’ ĩ tʉ̃goñañupʉ̃,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ĩ yaparo, na ĩnemoñupʉ̃ tunu: “Tʉ̃gopeoya juez cañuecʉ̃ cawapeaore cõ cʉ̃ caátajere. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bairi, ¿Nopẽ bairo Dios, cʉ̃ yarã cʉ̃ canetõõparãrẽ, ʉmʉrecóo, ñamii nairõ na cajẽniata, na cʉ̃ jʉáperibujiocʉti? Cañuʉ ãnirĩ na jʉátimajũcõãgʉmi. ¿O na cotecõã manio joroque na cʉ̃ átibujiocʉti? Bairo na áperigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Caãnorẽ bairo mʉjããrẽ ñiña: Coteri mea, jicoquei na jʉátibujioʉmi. Mʉjããrẽ ñiña tunu: Nemo yʉ, Camasã Jʉ̃gocʉ yʉ catunuetari rʉ̃mʉrẽ, ¿ati yepapʉre mai Dios mena catʉ̃goñatutuarãrẽ na yʉ bócaetaʉ átí?” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Cabero tunu Jesús ĩ cõñanemorĩ, quetibʉjʉyupʉ fariseo, bairi jĩcãʉ̃ gobiernorẽ dinero jejobojari majõcʉ menarẽ. Na quetibʉjʉgʉ ásupʉ aperã, “Caroarã majũ jãã ãniña,” ĩrĩ aperãrẽ caĩñateri majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Atore bairo na ĩñupʉ̃: “Pʉgarã ñubuerã ásúparã caʉ̃mʉa Dios ya wii, templo na caĩrĩ wiipʉ. Bairi jĩcãʉ̃ ãñupʉ̃ fariseo majã mena macããcʉ̃. Apei pʉame ãñupʉ̃ Roma macãrẽ camasã yaye dinerore jejobojari majã mena macããcʉ̃ jĩcãʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Atore bairo fariseo pʉame nucũrĩ Diore qũĩ jẽniñupʉ̃: ‘Dios nocãrõ cañuʉ majũrẽ mʉrẽ ñiña. Mʉ ñujãñuña yʉ menarẽ. Yʉa, aperãrẽ bairo yʉ baietiya. Cañuʉ yʉ ãniña. Narẽ bairo yʉ yajapaietiya. Rorije átajere yʉ áperiya. Carõmio mena rorije átaje cʉ̃ãrẽ yʉ áperiya. Tunu bairoa ãni, apei, Roma macãrẽ dinero jejobojari majõcʉre bairo yʉ baietiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yʉa, pʉgani jeto jĩcã semanarẽ ʉgarique betiri mʉ yʉ ñubuenucũña. Tunu bairoa yʉ cawapatarije cʉ̃ãrẽ pʉga wãmo petiro cãnacã sero cãrõrẽ jĩcã sero cãrõ jeto tocãnacãnia mʉ yʉ jonucũña,’ ĩ jẽniñupʉ̃ Diore fariseo majõcʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Apei Roma macã macããnarẽ dinero jejobojari majõcʉ pʉame, noo, jopetʉaca ũnopʉ̃ã tuacõãñupʉ̃. Bairo tuari jĩrĩãcã ũno cʉ̃ãrẽ ʉmʉrecóore ĩñamʉgõnucũrĩ mee nucũñupʉ̃. Bairo nucũʉ̃, cʉ̃ majũ cotiare pari, atore bairo ĩ jẽniñupʉ̃ Diore: ‘Dios, nocãrõ cañuʉ majũ, mʉrẽ ñiña. ¡Yʉre bopacooro ĩñaña! Yʉa, roro caátajecʉcʉ yʉ ãniña,’ qũĩ jẽniñupʉ̃ Diore Roma macã macããnarẽ dinero jejobojari majõcʉ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mʉjããrẽ caãnorẽ bairo ñiña: Ãni, Roma macã macããnarẽ cadinero jejobojari majõcʉ, cʉ̃ ya wiire cʉ̃ catunuetaparo jʉ̃goye, merẽ Dios cʉ̃ carorije wapare cʉ̃ masiriyo bojacõãrĩcʉ̃mi. Apei fariseo majõcʉ pʉame roquere cʉ̃ masiriyo bojaetacʉmi. Bairi torea bairo ni jĩcãʉ̃ ũcʉ̃ cʉ̃ majũã: ‘Caãnimajũʉ̃ yʉ ãniña,’ caĩ pʉamerẽ, cabʉgoro macããcʉ̃rẽ bairo cʉ̃ ãnio joroque cʉ̃ átigʉmi Dios. Apei, ‘Caãnimajũʉ̃ mee yʉ ãniña,’ caĩ pʉame roquere, cabero cabʉgoro macããcʉ̃rẽ bairo mee cʉ̃ ãnio joroque cʉ̃ átigʉmi Dios,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bairo cʉ̃ caĩquetibʉjʉ yaparoro bero, tunu aperã na pũnaa, cawĩmarãrẽ na jeasúparã Jesús tʉpʉ, na pãñarĩ Diore na cʉ̃ jẽnibojaáto, ĩrã. Bairo na pũnaarẽ na cajeató ĩñarĩ, cʉ̃ cabuerã pʉame, “Na jeapéricõãña mʉjãã pũnaarẽ,” na ĩñuparã capacʉare. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bairo na caáto ĩña, na piijori atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —Yʉtʉ pʉame cawĩmarãrẽ na atírotiya. Na ẽñotaeticõãña. Dios cʉ̃ carotimasĩrĩpaʉ macããnarẽ bairo caãna niñama cawĩmarã. Narẽ bairo cayeriñurã jeto ãnimasĩñama Dios cʉ̃ carotimasĩrĩpaʉpʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mʉjããrẽ cariape ñiña: Ni jĩcãʉ̃ ũcʉ̃ cawĩmaʉ cʉ̃ catʉ̃goñarõrẽ bairo Dios mena cʉ̃ catʉ̃goñatutuaeticõãta, Dios cʉ̃ carotimasĩrĩpaʉre jãã masĩẽtĩgʉmi —na ĩ quetibʉjʉyupʉ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cabero jĩcãʉ̃ sacerdote majã mena macããcʉ̃ atore bairo qũĩ jẽniñañupʉ̃ Jesure: —Cañuʉ majũ cabuei, ¿dope bairo yʉ átibujiocʉti, caroa yeri capetietiere bócagʉ? ");
INSERT INTO cbcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo Jesús pʉame qũĩ yʉyupʉ: —¿Nopẽĩ cañuʉ yʉ mi piiyati? Cañuʉ, jĩcãʉ̃ã niñami, Dios jeto. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Merẽ mʉ masĩĩ Dios camasãrẽ cʉ̃ caátiroticũrĩqũẽrẽ: “Carõmio mena roro átiepeeticõãña. Pajĩãẽtĩcõãña camasãrẽ. Aperã yayere jeerutieticõãña. Aperãrẽ cabʉgoroa na ĩbuitieticõãña. Mʉ pacʉ, mʉ paco cʉ̃ãrẽ nʉcʉ̃bʉgoya.” ");
INSERT INTO cbcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ caʉ̃mʉ pʉame: —Tie nipetirijere cawĩmaʉ ãcʉ̃pʉ̃na, yʉ átipeyocõã jʉ̃gowʉ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tiere tʉ̃go, Jesús pʉame qũĩnemoñupʉ̃ tunu: —Mai, jĩcã wãme mʉ rʉsacõãña. Mʉ cacʉ̃gorije nipetirijere nunirepeyocõãña. Tie wapare jeri cabopacarãrẽ na ricawoya. Bairo mʉ caápata, jõbuipʉ pairo nigaro mʉ cawapatapee. Bairo yʉ caĩrõrẽ bairo áti yaparori, yʉ mena bapacʉsa —qũĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tiere tʉ̃go, caʉ̃mʉ pʉame tʉ̃goñarĩqũẽ paicoasupʉ. Capee apeye ũnierẽ cacʉ̃goʉ ãnirĩ, Jesús cʉ̃ caĩrõrẽ bairo átigaesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Bairo cʉ̃ catʉ̃goñarĩqũẽ pairo ĩñarĩ, atore bairo na ĩñupʉ̃ Jesús cʉ̃tʉ caãnarẽ: —Ni jĩcãʉ̃ ũcʉ̃ capee apeye ũnierẽ cacʉ̃goʉ, Dios cʉ̃ carotimasĩrĩpaʉre cʉ̃ caetapee masiriyojãñuña. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Waibʉcʉ capai, camello, ãpõã pota opeacapʉ cʉ̃ cajã ãmewitiata, masiriyojãñuña. Bairo cʉ̃ caãmewitimasĩmiatacʉ̃ãrẽ, netõjãñurõ masiriyoro niña caʉ̃mʉ capee apeyere cacʉ̃goʉ Dios cʉ̃ carotimasĩrĩpaʉre cʉ̃ caetapee pʉame roque —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bairo cʉ̃ caĩrĩjẽrẽ catʉ̃gorã pʉame cʉ̃ jẽniñañuparã: —Bairi, ¿ni ũcʉ̃ toroque cʉ̃ netõmasĩcʉti? ");
INSERT INTO cbcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús: —Dise ũnie camasã na caátimasĩẽtĩẽ, nipetirije Dios cʉ̃ caátimasĩrĩjẽ jeto niña. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame bairo qũĩñupʉ̃ Jesure: —Jãã Quetiupaʉ, jãã roque merẽ, nipetirije jãã cacʉ̃gorijere cũrĩ, mʉrẽ jãã bapacʉti ʉsajʉ̃gowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesús pʉame atore bairo qũĩ yʉyupʉ: —Ni jĩcãʉ̃ ũcʉ̃ Dios cʉ̃ carotimasirĩpaʉ macããjẽrẽ paagʉ, cʉ̃ ya wiire, o cʉ̃ nʉmorẽ, cʉ̃ bairãrẽ, cʉ̃ pacʉare, o cʉ̃ pũnaa cʉ̃ãrẽ na cʉ̃ caaweyocoápáta, narẽ cʉ̃ cacʉ̃goro netõrõ bócanemogʉmi tunu ati yepapʉre. Tunu ape ʉmʉrecóo caetaro, cʉ̃gonemogʉmi yeri capetietiere —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Cabero Jesús cʉ̃ cabuerãrẽ, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ majũ camasã watoa caãnarẽ na piiwʉojori na ĩñupʉ̃ na jetore: “Ãmerẽ Jerusalẽpʉ marĩ ágarã. Topʉ profeta majã ãnana yʉ, Camasã Jʉ̃gocʉre na caĩquetibʉjʉ woatuyaricarorea bairo baigaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ti macã macããna pʉame judío majã caãmerãrẽ yʉ nunirocacõãgarãma. Roro ñiepegarãma. Roro yʉ átiepegarãma. Na ʉcoo mena yʉ eyotuepegarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bairo átiri, roro majũ yʉ bape epegarãma. Bairo yʉ átieperi, yʉ pajĩã rocacõãgarãma. Bairo yʉre na caátimiatacʉ̃ãrẽ, itia rʉ̃mʉ bero caãno yʉ pʉame yʉ caticoagʉ tunu,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na, cʉ̃ cabuerã pʉame cʉ̃ caquetibʉjʉmirĩjẽrẽ tʉ̃gomasĩẽtĩmajũcõãñuparã. Na pʉame, “Jesús bairo baiyasigʉmi,” ĩ masĩẽsuparã. Bairi tʉ̃gomasĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cabero Jericó macãrẽ cõñaácʉ́, Jesús pʉame cacaapee ĩñaecʉ̃rẽ netõásúpʉ. Cʉ̃ pʉame maa tʉ̃ni camasãrẽ dinero jẽniruinucũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bairi yua, camasã capããrã na canetõrõrẽ tʉ̃gori, “¿Dope to baiyati?” na ĩ jẽniñañupʉ̃ cʉ̃tʉ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, na pʉame qũĩñuparã: —Jesús, Nazaret macã macããcʉ̃ netõácʉ́ baiyami —qũĩ quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tiere tʉ̃gori, bʉsʉrique tutuaro mena qũĩ joyupʉ Jesure: —¡Jesús, David ãnacʉ̃ pãrãmi, bopacooro ñiñaña! ");
INSERT INTO cbcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bairo cʉ̃ caĩrõ, aperã cʉ̃ riape caãna pʉame cʉ̃ tutiyuparã, cʉ̃ awajaeticõãto, ĩrã. Bairo cʉ̃rẽ na caĩmiatacʉ̃ãrẽ, bʉtioro jãñurĩ awajanemoñupʉ̃ tunu: —¡David ãnacʉ̃ pãrãmi, bopacooro ñiñaña! ");
INSERT INTO cbcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús pʉame cʉ̃ caĩawajarijere tʉ̃gori, tuanʉcãñupʉ̃. Tuanʉcãrĩ, “Cʉ̃ neasá,” na ĩñupʉ̃ aperãrẽ. Bairo yua, cʉ̃ na cane etaro ĩña, cʉ̃ jẽniñañupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ñerẽ mʉ yʉ caáto mʉ boyati? Bairo cʉ̃ caĩrõ caĩñaecʉ̃ pʉame qũĩñupʉ̃: —Yʉ Quetiupaʉ, caĩñamasĩẽcʉ̃ ãnirĩ ñiñamasĩgaya tunu —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús: —¡Jaʉ, ĩñamasĩña! Yʉ mena mʉ catʉ̃goñatutuarije jʉ̃gori mʉ caapee ĩñamasĩõ joroque mʉ yʉ átiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bairo cʉ̃ caĩrõ, jicoquei ĩñamasĩcoasupʉ. Ĩñamasĩ yua, Jesús bero ʉsari, Diore cʉ̃ basapeoyupʉ. Nipetiro camasã, tiere caĩñaatana cʉ̃ã Diore cʉ̃ basapeoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Cabero yua, etayupʉ Jericó cawãmecʉti macãrẽ. Eta yua, ti macãrẽ tẽñota jʉ̃goyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mai, ti macãpʉ ãñupʉ̃ Zaqueo cawãmecʉcʉ. Cʉ̃ pʉame pairo netõrõ apeye ũnierẽ cacʉ̃goʉ ãñupʉ̃. Roma macããnarẽ camasã yaye dinerore jejobojari majã quetiupaʉ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Cʉ̃ pʉame bʉtioro ĩñagamiñupʉ̃ Jesure. Bairo ĩñagamicʉ̃ã, cayepaʉaca ãnirĩ, tunu bairoa camasã capããrã cʉ̃ riapere na caãnoi, dope bairo Jesure qũĩña bocamasĩẽsupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bairi Jesús cʉ̃ caápáro riape atʉátí, yucʉpʉ wãmʉcoásúpʉ, cʉ̃ cʉ̃ caĩñajo masĩparore ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bairi Jesús pʉame to netõácʉ́ qũĩñamʉgõ joyupʉ Zaqueo, yucʉ buipʉ capesaʉre. Qũĩñabocari, atore bairo qũĩñupʉ̃: —Zaqueo, tãmurĩ ruiasá. Ãmerẽ mʉ ya wiipʉ yʉ tuagaya —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bairo cʉ̃ caĩrõ tʉ̃go, uwaro ruiátíri, ʉseanirĩqũẽ mena cʉ̃ ya wiipʉ cʉ̃ jʉ̃goásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bairo Jesús cʉ̃ mena cʉ̃ caátó ĩña, to macããna nipetirã Jesure ãmeo bʉsʉpai jʉ̃goyuparã na majũ, “Rorije caácʉ ya wiipʉ tuaʉ áyami,” ĩ bʉsʉpaiyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Cabero Zaqueo ya wiipʉ na caetaãno yua, Zaqueo pʉame wãmʉnʉcãrĩ atore bairo qũĩñupʉ̃ Jesure: —Yʉ Quetiupaʉ, ãmerẽ yua, yʉ cacʉ̃gorijere carecomacã majũ cabopacarãrẽ na yʉ jogʉ. Tunu bairoa ni jĩcãʉ̃ ũcʉ̃rẽ cayajaricʉ yʉ caãmata, yʉ cayajamirĩqũẽrẽ cʉ̃ yʉ tunuojonemogʉ tunu. Tie netõjãñurõ baparicãnacãni majũ cʉ̃ yʉ tunuojonemogʉ tunu —qũĩñupʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Jesús pʉame: —Ãni, Zaqueo cʉ̃ã, Abraham ãnacʉ̃ pãrãmi majũ niñami. Bairi ãme cʉ̃, cʉ̃ yarã cʉ̃ãrẽ na netõñami Dios. Torecʉna, yʉ apʉ́, yʉ, Camasã Jʉ̃gocʉ, camasã cayasicoabujiorãrẽ na netõʉ̃ ácʉ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Camasã pʉame Jesús cʉ̃ caĩrĩjẽrẽ caroaro cʉ̃ tʉ̃goʉsayuparã. Bairo caroaro na catʉ̃goʉsaro ĩñarĩ, dinerore ĩcõñarĩ na quetibʉjʉyupʉ. Mai, Jesús pʉame merẽ Jerusalén macãtʉacapʉ ãñupʉ̃. Bairi camasã pʉame Dios cʉ̃ carotimasĩrĩpaʉ, “Ãmeacã etagaro baiya,” ĩ tʉ̃goñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bairi atore bairo na ĩñupʉ̃ Jesús: “Ãñupʉ̃ jĩcãʉ̃ caʉ̃mʉ quetiuparã yaʉ. Cʉ̃ pʉame ágʉ baiyupʉ ape yepa cayoaropʉ. Topʉ cʉ̃ ya yepare quetiupaʉ, reyre bairo cʉ̃rẽ na cajõrõ bero, tunuatígayupʉ tunu cʉ̃ ya yepapʉa. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bairi ágʉ jʉ̃goye, cʉ̃ paabojari majã pʉga wãmo cãnacãʉ̃ majũ mena macããnarẽ na piijori, na nuniñupʉ̃ tocãnacãʉ̃rẽã dinerore. Na nuni yaparori, atore bairo na ĩñupʉ̃: ‘Mʉjãã majũ atie dinero mena wapataya aperã mena. Tunu, yʉ catunuetaropʉ mʉjãã wapata jãnagarã,’ na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bairo cʉ̃ caĩcũmiatacʉ̃ãrẽ, camasã, cʉ̃ caãni yepa macããna pʉame bʉtioro cʉ̃ mena asiajãñuñuparã. Quetiupaʉ, reyre bairo cʉ̃ cajããrõ boesuparã. Bairo cʉ̃rẽ caasiarã ãnirĩ, cʉ̃ berore na ĩ rotijoyuparã na quetibʉjʉbojari majãrẽ: ‘Jãã, reyre bairo mʉ cajããrõrẽ jãã boetiya jãã ya yepare.’ ");
INSERT INTO cbcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bairo cʉ̃ na caboetimiatacʉ̃ãrẽ, aperã, ape yepa macããna pʉame quetiupaʉ reyre bairo cʉ̃ jõõcõãñuparã. To bero tunucoásúpʉ tunu cʉ̃ ya yepapʉa. Bairo tunuetari bero, cʉ̃ paabojari majãrẽ na piirotijoyupʉ aperãrẽ, ‘Dinerore yʉ canunicũrĩcãrã nocãrõ majũ na wapataupari tocãnacãʉ̃pʉa,’ ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bairi cʉ̃ paabojari majõcʉ caãnijʉ̃goʉ pʉame etari, atore bairo qũĩñupʉ̃: ‘Quetiupaʉ, mʉ dinero yʉ mʉ cacũrĩqũẽ mena yʉ wapatanemoapʉ tunu. Mʉ pʉame pʉga wãmo cãnacã mil tiiri dinerore yʉ mʉ cacũmiatacʉ̃ãrẽ, tunu pʉga wãmo cãnacã mil tiiri mʉrẽ yʉ tunuo buipeogʉ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bairo cʉ̃ caĩrõ, cʉ̃ quetiupaʉ pʉame atore bairo qũĩ yʉyupʉ: ‘Ñumajũcõãña; cañuʉ mʉ ãniña mʉa paabojari majõcʉ. Bairi nʉcʉ̃rõ mena apeye petoaca caãnie ũnierẽ mʉ caĩñarĩcãnʉgõ masĩrõ jʉ̃gori, pʉga wãmo cãnacã macãã quetiupaʉ majũ mʉ jããõ joroque mʉ yʉ átigʉ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bairi tunu cʉ̃ paabojari majõcʉ cabero macããcʉ̃ pʉame etari, atore bairo qũĩñupʉ̃: ‘Quetiupaʉ, mʉ dinero yʉ mʉ cacũrĩqũẽ mena yʉ wapatanemoapʉ tunu. Mʉ pʉame jĩcã wãmo cãnacã mil tiiri dinerore yʉ mʉ cacũmiatacʉ̃ãrẽ, tunu jĩcã wãmo cãnacã mil tiiri mʉrẽ yʉ tunuo buipeogʉ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bairo cʉ̃ caĩrõ, cʉ̃ quetiupaʉ pʉame qũĩñupʉ̃: ‘Ñumajũcõãña; mʉ cʉ̃ã jĩcã wãmo cãnacã macãã quetiupaʉ majũ mʉ jããõ joroque mʉ yʉ átigʉ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Apei cʉ̃ paabojari majõcʉ pʉame yua cʉ̃tʉ etari, atore bairo qũĩñupʉ̃ cʉ̃ cʉ̃ã: ‘Quetiupaʉ, atie niña mʉ dinero. Yʉ mʉ canunimirĩqũẽ jetore mʉ yʉ tunuogʉ. Yasire ĩ, jutii asero mena ũmarĩ mʉ yʉ qũẽnocũbojawʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉa, tutuaro mena caroti mʉ ãniña. Aperã yayere na mʉ ẽmanucũña. Tunu bairoa caoteecʉ nimicʉ̃ã, aperã na caoteriquepʉre mʉ jenucũña. Bairi mʉrẽ uwiri, caroaro yʉ qũẽnocũwʉ̃ mʉ dinerore, yasire ĩ,’ qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ quetiupaʉ pʉame qũĩñupʉ̃: ‘Mʉa, paabojari majõcʉ, cañuecʉ̃ majũ mʉ ãniña. Bairi bairo mʉ caĩrĩjẽ menaa mʉrẽ ñiñabesegʉ. Yʉre, “Mʉa, tutuaro mena caroti mʉ ãniña,” yʉ miapʉ̃. Tunu bairoa, “Aperã yayere na mʉ ẽmanucũña. Tunu bairoa caoteecʉ nimicʉ̃ã, aperã na caoteriquepʉre mʉ jenucũña,” yʉ miapʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Dopẽĩ, bairo yʉ cabairijere masĩmicʉ̃ã, yʉ dinerore banco wiipʉ mʉ cũẽtĩ? Bairo cũrĩ, tie dinerore mʉ cawasorije wapa mʉ wapata nemobujioricʉ. Tie mena yʉ mʉ tunuobujioatacʉ, yʉ wii yʉ catunuetaro,’ qũĩ tutiyupʉ cʉ̃ quetiupaʉ cʉ̃ ʉ̃mʉrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bairo qũĩ yaparori, atore bairo na ĩñupʉ̃ aperã, cʉ̃tʉ caãnarẽ: ‘Dinero cʉ̃ cacʉ̃gomirĩjẽrẽ jeri, apei pʉga wãmo cãrõ cawapata nemorĩcʉ̃rẽ cʉ̃ joya,’ na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bairo cʉ̃ caĩrõ tʉ̃gomirãcʉ̃ã, cʉ̃tʉ caãna pʉame qũĩñuparã: ‘Merẽ pairo cʉ̃gonemoñami, pʉga wãmo cãrõ majũ. Bairi bonemoẽtĩñami,’ qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bairo na caĩrõ tʉ̃gori, atore bairo na ĩñupʉ̃: ‘Mʉjããrẽ cariape ñiña: Noa ũna nʉcʉ̃rõ mena yʉ cajorijere na caĩñarĩcãnʉgõata, paijãñurõ na yʉ jonemogʉ tunu. Aperã nʉcʉ̃rõ mena yʉ cajorijere na caĩñarĩcãnʉgõeticõãta, na cacʉ̃gomirĩjẽrẽ yʉ ẽmapeyocõãgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tunu bairoa yʉ pesua, yʉre reyre bairo caboetiatanarẽ na neatíri, yʉ caĩñajoro na pajĩãrecõãña,’ na ĩñupʉ̃ quetiupaʉ pʉame,” na ĩ cõña quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bairo atiere quetibʉjʉ yaparori bero, Jesús Jerusalẽpʉ ámajũñupʉ̃ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bairi Betfagé, Betania na caĩrĩ macãã tʉpʉ cõñaácʉ́, cʉ̃ cabuerã pʉgarãrẽ na árotiyupʉ. Mai, Betfagé, Betania pʉame Olivo na caĩrĩ buro tʉpʉ ãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Bairi atore bairo na ĩ joyupʉ cʉ̃ cabuerã pʉgarãrẽ: —Ánája ato riape caãni macããcãpʉ. Topʉ etarã, jĩcãʉ̃ burro jiyaturicʉre cʉ̃ mʉjãã bócagarã. Cʉ̃, burro pʉame mai camasã na capesañaecʉ̃ nigʉmi. Cʉ̃rẽ cʉ̃ õwãrĩ, cʉ̃ mʉjãã neapá yʉ tʉpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bairi tunu aperã, mʉjããrẽ, ‘¿Nopẽĩrã cʉ̃ mʉjãã õwãñati?’ na caĩata, atore bairo na mʉjãã ĩwã: ‘Marĩ Quetiupaʉ cʉ̃ boami,’ na mʉjãã ĩwã —na ĩ joyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bairo cʉ̃ caĩrõ tʉ̃go, acoásúparã cʉ̃ cabuerã pʉgarã pʉame. Bairo na caátó yua, nipetirije Jesús cʉ̃ caĩatatorea bairo baiyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bairi burrore na caõwãrõ ĩñarĩ, cʉ̃ uparã pʉame: —¿Nopẽĩrã cʉ̃ mʉjãã õwãñati? —na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na pʉame atore bairo na ĩ yʉyuparã cauparãrẽ: —Marĩ Quetiupaʉ cʉ̃ boami. Bairi cʉ̃ jãã õwãña —na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bairo cʉ̃ õwã yaparori, cʉ̃ neásúparã burrore Jesús tʉpʉ. Cʉ̃ nee etari yua, cʉ̃ cabuerã pʉame na jutii, cabui macããjẽrẽ, burro buire peoyuparã. Peo yaparori, Jesure cʉ̃ nemʉgõ peoyuparã burro buipʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bairo na caáto bero yua, Jesús pʉame ánutuásúpʉ Jerusalén caátíwãpʉ. Bairi camasã pʉame na jutii cabui macããjẽrẽ esocũñuparã maa cʉ̃ caátíwãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bairi Jesujãã Olivo buro roaro na caetaro yua, camasã Jesure caʉsari majã pʉame nipetiro bʉsʉrique tutuaro mena ĩ awaja jʉ̃goyuparã. Tunu bairoa ʉseanirĩqũẽ mena Diore cʉ̃ basapeoyuparã. Jesús cʉ̃ caátijẽño ĩñorĩqũẽ jʉ̃gori bʉtioro Diore cʉ̃ basapeoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Atore bairo qũĩ basapeoyuparã: —¡Jesús, Dios cʉ̃ cajoʉ, marĩ Quetiupaʉ majũ cʉ̃ caãnoi, cʉ̃rẽ marĩ cabasapeoro ñuña! ¡Jesús cʉ̃ caatáje jʉ̃gori Dios jõbui macããcʉ̃ mena caroaro marĩ ãnimasĩña! ¡Bairi nipetiro cʉ̃ marĩ basapeoroa Dios ʉmʉrecóo macããcʉ̃rẽ! —qũĩ basapeoyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bairo camasã Jesure caʉsari majã na caĩrĩjẽrẽ tʉ̃gori, atore bairo qũĩñuparã fariseo majã jĩcããrã, camasã watoapʉ caãna pʉame Jesure: —¡Jãã cabuei, mʉrẽ caĩawaja ʉsarãrẽ tocãrõ na jãnarotiya! —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bairo na caĩrõ, Jesús pʉame atore bairo na ĩñupʉ̃: —Mʉjããrẽ cariape ñiña: Ãnoa camasã yʉre na cabasapeoeticõãta, ʉ̃tã rupaa pʉame yʉre basapeobujioro —na ĩñupʉ̃ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Merẽ yua, Jesús Jerusalén macãtʉacapʉ ãcʉ̃, ti macãrẽ ĩñajori, otiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Atore bairo na ĩ tʉ̃goña yapapuayupʉ Jerusalén macã macããnarẽ: “Mʉjãã, Jerusalén macããna ãme rʉ̃mʉ mʉjããrẽ yʉ quetibʉjʉgamiña caroa yeri cʉtajere. Mʉjãã pʉame tie quetire apero cayasioropʉ caãnierẽ na caĩñamasĩẽtõrẽã bairo tiere mʉjãã masĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bairi mʉjããrẽ roro na caátipa rʉ̃mʉrĩ atígaro. Mʉjãã wapana pʉame Jerusalẽrẽ ʉ̃tã mena ẽñota, ãmejoregarãma rupa macãpʉa, mʉjãã carutimasĩẽtĩparore bairo ĩrã. Bairo áticõãrĩ, camasã, mʉjãã wapana pʉame mʉjãã tocãnacãpaʉpʉrea ẽñota ãmejoreri, mʉjãã ãmeo qũẽgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ãmeo qũẽrĩ mʉjããrẽ pajĩãre peyocõãgarãma mʉjãã wapana pʉame. Bairo mʉjãã pajĩãreri, Jerusalén macã ãnatõrẽ átiyasio rocamajũcõãgarãma. Tie ʉ̃tã rupaa na caẽñotamirĩqũẽ jĩcã ʉ̃tã ũno buituticʉti pesaricaro manopʉ átiyasio rocacõãgarãma, mʉjãã ya macã Jerusalén macã ãnatõrẽ. Mʉjãã majũ Dios mʉjããrẽ cʉ̃ canetõʉ̃ atiere mʉjãã tʉ̃gopeoepʉ. Bairi mʉjããrẽ pajĩãregarãma mʉjãã wapana,” ĩ yapapuayupʉ Jesús, Jerusalén macãrẽ ĩñajori. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bairo ĩrĩ bero, Jesús etayupʉ Jerusalén macãrẽ yua. Bairo etari, templo capairi wii, ñubuerica wiire jããñupʉ̃. Ti wiire jããetari, to macããna nunirĩ wapatari majãrẽ, bairi wapatiri majã cʉ̃ãrẽ na acurewiyojo jʉ̃goyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Bairo na acurewiyojori, atore bairo na ĩñupʉ̃: —Dios cʉ̃ caquetibʉjʉri tutipʉ bairo ĩña: ‘Yʉ ya wii ñubuerica wii majũ nigaro,’ ĩña. Bairo caĩquetibʉjʉmiatacʉ̃ãrẽ, mʉjãã pʉame apeye arʉare bairo mʉjãã átiya. Camasã jeruti nunirĩ majãrẽ bairo caãna ãnirĩ jerutiri majã na caãni wii, ʉ̃tã wiire bairo mʉjãã átiya ati wii, Dios ya wiire —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bairo áti yaparori bero, ti wiipʉ camasãrẽ na bueãñupʉ̃ tocãnacã rʉ̃mʉa ti semanarẽ. Bairo to cʉ̃ caãno, quetiuparã sacerdote majã, aperã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, aperã cabʉtoa camasĩrĩ majã pʉame na nipetiro, “¿Dope bairo átiri cʉ̃ marĩ pajĩãrãati?” ãmeo ĩ bʉsʉpẽni jʉ̃goyuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mai, camasã pʉame nipetiro cʉ̃ cabuerijere caroaro mena cʉ̃ tʉ̃goʉsayuparã. Bairi cʉ̃rẽ na capajĩãrocagamirĩjẽrẽ átimasĩẽsuparã fariseo majã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jĩcã rʉ̃mʉ templo wiipʉ camasãrẽ na cʉ̃ cabueãnitoye, quetiuparã sacerdote majã, aperã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã, aperã cabʉtoa camasĩrĩ majã cʉ̃ã, na nipetiro Jesutʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Etari atore bairo qũĩ jẽniñañuparã: —¿Noa na carotiro mena bairo mʉ átiati ñamicã mʉ caátiatajere? ");
INSERT INTO cbcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Jesús cʉ̃ã: —Yʉ cʉ̃ã mʉjããrẽ jĩcã wãme yʉ jẽniñagʉ. Cariape yʉ mʉjãã yʉwa: ");
INSERT INTO cbcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ni ũcʉ̃ camasãrẽ na cʉ̃ bautiza rotijoyupari Juan ãnacʉ̃rẽ? ¿Dios, o camasã pʉame cʉ̃ na bautiza rotijoyupari? —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, yasioroaca ãmeo bʉsʉyuparã na majũ cʉ̃rẽ na caĩyʉpeere: “¿Nopẽ bairo cʉ̃ marĩ yʉrãati rita? ‘Dios pʉame cʉ̃ bautiza rotijoricʉmi,’ marĩ caĩata, ‘Toroque, ¿nopẽĩrã cʉ̃ caquetibʉjʉrijere cariape mʉjãã tʉ̃goeti?’ marĩ ĩbujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tunu bairoa, ‘Camasã pʉame cʉ̃ bautiza rotijoyupa,’ marĩ ĩ masĩẽtĩña. Bairo marĩ caĩata, camasã pʉame ʉ̃tã rupaa mena marĩ wẽpajĩãbujiorãma. Merẽ nipetiro camasã, ‘Juan ãnacʉ̃ Dios cʉ̃ caquetibʉjʉrotijoricʉ majũ ãmi,’ ĩ tʉ̃goñamasĩrãma,” ãmeo ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bairi atore bairo qũĩñuparã fariseojãã Jesure: —Jãã masĩẽtĩña Juarẽ cabautiza rotijoricʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bairo na caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃: —Cariape yʉ mʉjãã yʉetiya. Bairi yʉ cʉ̃ã, ‘Noa ũna na carotiro mena tore bairo yʉ átimasĩña,’ mʉjããrẽ ñi quetibʉjʉetigʉ —na ĩñupʉ̃ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cabero aperã camasã catʉ̃gori majãrẽ ati wãmerẽ ĩcõñarĩ Jesús na quetibʉjʉyupʉ: “Ãñupʉ̃ jĩcãʉ̃ wese upaʉ. Cʉ̃ pʉame ʉse wesere qũẽnoñupʉ̃. Bairo ti wesere ote yaparori bero, acoásúpʉ cayoaropʉ. Mai, ágʉ jʉ̃goye, cʉ̃ wesere wasocũñupʉ̃ aperã paari majãrẽ, wapatagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cabero yua, ʉse cabʉtiri yʉtea caetaro masĩrĩ, cʉ̃ ʉ̃mʉ jĩcãʉ̃rẽ cʉ̃ joyupʉ cʉ̃ ya wesere cʉ̃ cawasoricarã tʉpʉ. Cʉ̃rẽ na cawasorique wapare bori, cʉ̃ joyupʉ, tie wapare cʉ̃ jeatíbojaáto, ĩ. Bairo cʉ̃ ʉ̃mʉrẽ cʉ̃ cajomiatacʉ̃ãrẽ, wese paari majã pʉame, cʉ̃ caetaro cʉ̃ qũẽñuparã. Bairo cʉ̃ qũẽrĩ, ñe ũnie mácʉ̃ cʉ̃ átitunuo joyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tunu ti wese upaʉ pʉame apei cʉ̃ ʉ̃mʉrẽ cʉ̃ joyupʉ. Cʉ̃ cʉ̃ãrẽ torea bairo cʉ̃ ásuparã. Roro cʉ̃ átieperi, cʉ̃ qũẽñuparã. Bairo áti yaparori, ñe ũnie mácʉ̃ cʉ̃ átitunuo joyuparã cʉ̃ cʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Cabero apei, tunu cʉ̃ joyupʉ. Tunu torea bairo cʉ̃ ásuparã ti wesere capaari majã pʉame. Roro cʉ̃ cãmii turi, cʉ̃ acuwiyo joyuparã ti wese camanopʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Bairo jeto ʉse wese macããna na caáto ĩñamirĩ, atore bairo ĩ tʉ̃goñañupʉ̃ ʉse wese upaʉ majũ pʉame: ‘¿Dope yʉ ácʉati yua? Yʉ macʉ̃, yʉ camairẽ cʉ̃ yʉ jogʉ na tʉpʉ. Cʉ̃ roquere cʉ̃ nʉcʉ̃bʉgobujiorãma, yʉ macʉ̃ cʉ̃ caãnoi,’ ĩ tʉ̃goñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bairi cabero yua, wese paari majã pʉame ti wese upaʉ macʉ̃ cʉ̃ caatóre ĩñarĩ, ãmeo ĩñuparã: ‘Atíyami ati wese upaʉ macʉ̃. Cʉ̃ã niñami cʉ̃ pacʉ cʉ̃ cariaro bero ati wesere cacʉ̃goʉsapaʉ. Bairi cʉ̃ marĩ pajĩãrocacõãto. Bairo marĩ caápata, ati wese uparãrẽ bairo marĩ tuagarã,’ ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bairo caĩrã ãnirĩ na caĩrõrẽã bairo ásuparã. Ti wese tʉ̃nipʉ cʉ̃ neowaátí, cʉ̃ pajĩã rocacõãñuparã,” na ĩ quetibʉjʉyupʉ Jesús. Bairo ĩ quetibʉjʉ yaparo, atore bairo na ĩ jẽniñañupʉ̃ cʉ̃ caĩrĩjẽrẽ catʉ̃gori majãrẽ: “¿Dope bairo ácʉmi mʉjãã ĩ tʉ̃goñañati cʉ̃ macʉ̃rẽ na capajĩãrocaro bero ti wese upaʉ pʉame yua? ");
INSERT INTO cbcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bairo átigʉmi: Topʉ á, ti wese paari majãrẽ na pajĩã recõãgʉmi. Bairo na átireri bero, aperãrẽ cʉ̃ wesere coteroticũgʉmi,” na ĩñupʉ̃ Jesús. Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩñuparã Jesure: —¡Tocãrõã ĩ jãnaña tiere! ¡Ĩẽtĩcõãña! —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bairo na caĩrõ, na ĩñarĩ, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã, ‘Tocãrõã ĩ jãnaña tiere,’ yʉ mʉjãã ĩñati? ¿Torea bairo na ĩ quetibʉjʉ woacũẽsupari Dios yaye quetibʉjʉrica tutipʉre? Atore bairo ĩña: ‘Ʉ̃tã mena cawii qũẽnorĩ majã jĩcã ʉ̃tããrẽ na caboetimiatacʉ̃ãrẽ, tia pʉame caãni majũrĩcã nigaro. Tia camanicõãta, wii manibujioricaro,’ ĩ quetibʉjʉ woacũñupã Dios ya tutipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bairi ni jĩcãʉ̃ ũcʉ̃ tia ʉ̃tãã mena cʉ̃ cañarocapeata, rocapecoabujioʉmi. Tunu bairoa tia, jĩcãʉ̃ buipʉ to cañarocapeata, cʉ̃ rocaboo rocacõãbujioro —na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bairo cʉ̃ caĩquetibʉjʉ yaparoro, quetiuparã sacerdote majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame masĩcõãñuparã Jesús cʉ̃ caĩrĩjẽrẽ. “Marĩ pʉame tia ʉ̃tããrẽ carocari majãrẽ bairo marĩ ãniña. Bairi marĩrẽã ĩgʉ ĩcʉ̃mi Jesús,” ĩ tʉ̃goñañuparã. Bairo ĩ tʉ̃goñamasĩrĩ jicoquei Jesure cʉ̃ ñegamiñuparã. Bairo cʉ̃ ñegamirãcʉ̃ã, cʉ̃ ñemasĩẽsuparã, camasãrẽ na uwirã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bairi Jesutʉ na joyuparã catʉ̃gorutiri majãrẽ. Na pʉame nʉcʉ̃bʉgori majãrẽ bairo Jesure na cabai ĩñorõ boyuparã, rorije cʉ̃ bʉsʉo joroque ĩrã. Bairi roro cʉ̃ caĩata, quetiupaʉ gobernadore cʉ̃ marĩ bʉsʉjãmasĩgarã ĩrã, bairo na joyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bairi na pʉame cʉ̃tʉ etari, atore bairo qũĩ jẽniñañuparã Jesure: —Cabuei, jãã masĩña merẽ mʉ caátiãnierẽ. Mʉa, caroaro cariape minucũña. Tunu bairoa caãnorẽ bairo mʉ quetibʉjʉnucũña. Aperã roro na cabaurije, aperã caroaro na cabaurije jʉ̃gori mee na miñabeseya. Mʉa, cariapea Dios marĩrẽ cʉ̃ caãnirotiricarorea bairo mʉ bueya. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bairo cabai ãnirĩ, ¿dope bairo mi tʉ̃goñañati romano majã marĩrẽ na carotirijere? ¿To ñuñati quetiupaʉ emperadore camasã yaye dinerore jeri jãã cajoata, o to ñueticʉti? —qũĩ jẽniñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús pʉame roro na caĩtʉ̃goñarĩjẽrẽ masĩcõãrĩ, atore bairo na ĩñupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Jaʉ, yʉre joñijate moneda tiire —na ĩñupʉ̃. Bairo na canunirõ, na ĩñupʉ̃: —¿Noa riapé to tusayati ti tii moneda tiiacapʉre? Tunu bairoa, ¿noa wãme woaturique to tusayati? —na ĩ jẽniñañupʉ̃ Jesús. Bairo cʉ̃ caĩrõ, na pʉame ĩñuparã: —Emperador, quetiupaʉ ya wãme, bairi tunu, cʉ̃ riapé tusaya ti tii moneda tiiacapʉre —qũĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bairo na caĩquetibʉjʉro, atore bairo na ĩnemoñupʉ̃ Jesús tunu: —Toroque emperador quetiupaʉre cʉ̃ yaye caãnierẽ, cʉ̃rẽ cʉ̃ tunuojoya. Tunu bairoa Dios yaye caãnierẽ Diore cʉ̃ jonucũña —na ĩ quetibʉjʉyupʉ Jesús fariseojããrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bairo cʉ̃ caĩrĩjẽrẽ tʉ̃gori yua, nopẽ bairo pʉame qũĩto masĩẽsuparã fariseo majã pʉame camasã watoare. Bairoa bocá bʉsʉeticõãñuparã, Jesús na cʉ̃ cayʉrijere tʉ̃gorã. “¡Nocãrõ cʉ̃ masĩñati!” ĩ, tʉ̃goñacõã jãnasuparã yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cabero jĩcããrã, saduceo majã na caĩrã qũĩñarã asúparã Jesure. Mai, saduceo majã pʉame atore bairo caĩtʉ̃goñarĩ majã ãñuparã: “Camasã cariacoatana, nopẽ bairo catitunu masĩẽnama,” ĩ tʉ̃goñañuparã. Bairi atore bairo qũĩñuparã Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Cabuei, Moisés ãnacʉ̃ atore bairo marĩrẽ ĩ woatucũñañupĩ tirʉ̃mʉpʉre: “Ni jĩcãʉ̃ ũcʉ̃ cawãmojiyaricʉ cʉ̃ nʉmo mena pũnaa mácʉ̃ã cʉ̃ cariacoapata, cʉ̃ ãnacʉ̃ bai pʉame cʉ̃ buiacore cõ cʉ̃ wãmojiyaáto. Bairo cʉ̃ caáto, cʉ̃ pũnaa caãniparã pʉame cʉ̃ ãnacʉ̃ pũnaarẽ bairo ãnibujiorãma,” ĩcũñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tiere mʉ masĩĩ. Bairi ape wãmerẽ ĩcõñarĩ jãã quetibʉjʉpa mai: Ãñuparã jĩcãni, jĩcãʉ̃ pũnaa jĩcã wãmo peti pʉga pẽnirõ caãnacãʉ̃ majũ. Bairi cajʉ̃gocʉ pʉame wãmojiya jʉ̃goyupʉ. Cabero pũnaa mácʉ̃ã riacoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bairi cʉ̃ ãnacʉ̃ bai pʉame cʉ̃ buiacore wãmojiyayupʉ tunu. Cabero pũnaa mácʉ̃ã riacoásúpʉ cʉ̃ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tunu bairoa cʉ̃ ãnacʉ̃ bai, apei pʉame cʉ̃ buiacore wãmojiyayupʉ tunu. Cabero cʉ̃ cʉ̃ã riacoásúpʉ pũnaa mácʉ̃ã. Bairi, bairo jeto baiyuparã nipetiro na ãnana bairã, aperã cʉ̃ã. Bairo nipetiro cõ mena nʉmo cʉtimirãcʉ̃ã, nipetirã cõ mena pũnaa mána jeto riapeticoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cabero na ãnana nʉmo caãnimirĩcõ cʉ̃ã riacoásúpo. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bairo ati yepapʉ nipetirã nʉmo caãnacõ ãnirĩ yua, cariaricarã tunu na cacatiropʉ na caãno, ¿ni nʉmo majũ cõ ãnicʉti? —qũĩ jẽniñañuparã saduceo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Bairo na caĩrĩjẽrẽ tʉ̃go, atore bairo na ĩñupʉ̃: —Ati ʉmʉrecóore caãna, carõmia manapʉ cʉtinucũñama. Caʉ̃mʉa cʉ̃ã nʉmo cʉtinucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aperã Dios mena na catʉ̃goñatutuarije jʉ̃gori, ape ʉmʉrecóore tunu catiri, caetaparã pʉame roque nʉmo manigarãma. Tunu bairoa na pũnaa rõmiarẽ na nʉmotietigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Topʉre pʉgani riaetigarãma nipetiro to macããna. Ángelea majã na caãnorẽ bairo nigarãma. Tunu bairoa Dios cʉ̃ cacatiorã ãnirĩ, cʉ̃ pũnarẽ bairo majũ caãna nigarãma. Bairi nʉmo cʉtaje manigaro ti ʉmʉrecóopʉre yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bairi Moisés ãnacʉ̃ cʉ̃ caquetibʉjʉwoacũñarĩcã tutipʉ marĩ quetibʉjʉ masĩõña atore bairo: ‘Nipetiro camasã cariacoatana nimirãcʉ̃ã, caticoagarãma.’ Ti tutipʉ yucʉ ʉ̃mirõcʉ̃ã caʉ̃petietiire cʉ̃ caquetibʉjʉricapaʉpʉ atore bairo ĩ woatuyupi Moisés: ‘Yʉa, yʉ ãniña Abraham, cʉ̃ macʉ̃ Isaac, bairi cʉ̃ macʉ̃ Jacob quetiupaʉ caãnacʉ̃,’ ĩñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios pʉame cayasirã ãnana ũna quetiupaʉ mee niñami. ¡Cacatirã majũ quetiupaʉ roque niñami! Dios, cʉ̃ caĩñajorore na nipetiro cacatirãrẽ bairo caãna niñama —na ĩ quetibʉjʉyupʉ Jesús saduceo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bairo cʉ̃ caĩrõ tʉ̃gori, jĩcããrã fariseo majã mena macããna atore bairo qũĩñuparã: —Cabuei, caroaro majũ mʉ quetibʉjʉya —qũĩñuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bairi yua, pʉgani cʉ̃ jẽniñanemo masĩẽsuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Cabero Jesús atore bairo na ĩ jẽniñañupʉ̃: —¿Nopẽĩrã, “Mesías Dios cʉ̃ cajoʉ, David ãnacʉ̃ pãrãmi nigʉmi,” na ĩ quetibʉjʉnucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ãnacʉ̃ pʉame Salmos tutipʉre atore bairo ĩ woatuyupi: ‘Dios pʉame yʉ Quetiupaʉre atore bairo qũĩwĩ: “Ato ruiya cariape nʉgõã pʉame mai. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mʉ pesua caãnanarẽ na yʉ canetõnʉcãrõ bero, mʉ pʉame na mʉ rotimasĩgʉ,”’ ĩñupĩ David ãnacʉ̃, Dios cʉ̃ caĩrĩqũẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Bairi Dios cʉ̃ cajoʉre, “yʉ Quetiupaʉ” cʉ̃ caĩmiatacʉ̃ãrẽ, ¿nopẽĩrã, “David ãnacʉ̃ pãrãmi ãnigʉmi,” na ĩ quetibʉjʉnucũñati? —na ĩñupʉ̃ Jesús, na catʉ̃gomasĩparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Cabero capããrã camasã na catʉ̃goãno, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: ");
INSERT INTO cbcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã na caátiãnierẽ tʉ̃goñamasĩña: Na pʉame jutii cayowerijere jãñajesoyama. Bairo cajãñarã ãnirĩ maapʉ na caáñesẽãta, nipetiro camasã nʉcʉ̃bʉgorique mena na cajẽnirõrẽ bonucũñama. Tunu bairoa ñubuerica wiiripʉ na caápáta, caroapaʉri jetore ruiganucũñama. Tunu bose rʉ̃mʉ caãno narẽ na capiiata, caroapaʉre ruiri ʉgaganucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tunu bairoa cawapearã rõmirĩ ya wiirire ẽmanucũñama. Tunu yoaro Diore cʉ̃ jẽniñubuetonucũñama. Na pʉame roque aperã netõjãñurõ popiye tãmʉogarãma.” ");
INSERT INTO cbcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Cabero templo wiipʉ ãcʉ̃, Jesús pairo cadinero cʉnarẽ na ĩñajoyupʉ. Na pʉame dinero jããrĩcã pataripʉ na yaye dinerore jããrã ásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na bero cawapeao cabopacao cʉ̃ã jããñupõ pʉga moneda, cobre tiiriacarẽ, cacʉ̃goeco majũ nimiocʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Bairo cõ caáto ĩña, atore bairo na ĩñupʉ̃ Jesús: —Ãnoa cadinero cʉ̃gonetõõrã ãnirĩ narẽ catuarijere jããñama. Atio cawapeao pʉame cabopacanetõõ ãnirĩ, cõ cacʉ̃gomirĩjẽ nipetirijere jããñamo. Bairi cariape mʉjããrẽ ñiña: Dios cʉ̃ caĩñajoro atio pʉame cadinero cʉ̃gorã netõõjãñurõ jããñamo —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Cabero jĩcããrã to caãna templo wiire ĩñarĩ, atore bairo ãmeo ĩ bʉsʉyuparã: “¡Nocãrõ caroa wii majũ to ãniñati ati wii! Paca ʉ̃tãpãĩrĩ niña. Tunu bairoa camasã aperã na canunirĩqũẽrẽ na cacũrĩqũẽ mena caroa wii majũ bauya,” ãmeo ĩ bʉsʉyuparã, templo wiire ĩñarĩ na majũ. Bairo na caĩrõ tʉ̃gori atore bairo na ĩñupʉ̃ Jesús: ");
INSERT INTO cbcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Jĩcã rʉ̃mʉ, ati wiire roro na caátipa rʉ̃mʉ etagaro. Bairo caetaro, jĩcã ʉ̃tãã ũno bui tuticʉti pesaricaro manopʉ átiyasio rocacõãgarãma ati wiire —na ĩñupʉ̃ Jesús camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bairo Jesús cʉ̃ caĩrõ, atore bairo qũĩ jẽniñañuparã: —Cabuei, ¿nocãrõpʉ to bairoati atie mʉ caĩrĩjẽ? ¿Dope bairo merẽ, “Jesús cʉ̃ caĩrĩqũẽ etaro baiya,” jãã ĩ masĩrãati? ");
INSERT INTO cbcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Bairo na caĩjẽniñarõ tʉ̃gori, atore bairo na ĩñupʉ̃ Jesús: “Caroaro majũ mʉjãã tʉ̃goñamasĩgarã, jããpʉ jãã ĩtoecore, ĩrã. Capããrã atígarãma caĩtoñesẽãrĩ majã. Atore bairo ĩgarãma: ‘Yʉa, yʉ ãniña Dios cʉ̃ cajoʉ. Ãmea niña Dios marĩrẽ cʉ̃ canetõõrĩ yʉtea,’ ĩgarãma. Bairo na caĩmiatacʉ̃ãrẽ, cariape na mʉjãã tʉ̃goetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tunu bairoa mʉjãã queti tʉ̃gogarã: ‘Camasã aperopʉ cʉ̃ãrẽ ãmeo pajĩãrã átiuparã.’ Bairo na caátie quetire tʉ̃gori, tʉ̃go acʉaeticõãña. Ati ʉmʉrecóo capetiparo jʉ̃goye bairoa cabaijʉ̃goye cʉtipee niña bairopʉa. Bairi tʉ̃go acʉaeticõãña,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ĩ quetibʉjʉ yaparo, na quetibʉjʉ nemoñupʉ̃ tunu: “Aperã jĩcã yepa macããna, ape yepa macããna mena ãmeo pajĩãgarãma. Tunu bairoa jĩcã macã macããna, ape macã macããna mena ãmeo pajĩãgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tunu tutuaro mena ati yepa cʉ̃ã yuguigaro nipetiropʉ. Apeye aʉa riarique atígaro. Riaye cʉ̃ã noo caãno cãnacãpaʉpʉa nigaro. Tunu ʉmʉrecóopʉre acʉorije majũ bai ĩñogaro. Marĩ caĩñañaetĩẽ ũnie bai ĩñogaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mai, atie cabaiparo jʉ̃goye mʉjããrẽ roro átijʉ̃gogarãma. Mʉjããrẽ ñerĩ, popiye mʉjãã baio joroque mʉjãã átigarãma. Ñubuerica wiiripʉ mʉjããrẽ jeágarãma, to macããna mʉjããrẽ na caĩñabeseparore bairo ĩrã. Bairo átiri, mʉjããrẽ preso jorica wiipʉ mʉjãã cũrecõãgarãma. Tunu yʉ yarã mʉjãã caãno jʉ̃gori, na pʉame mʉjããrẽ roro na catutiparore bairo ĩrã, quetiuparã gobernadores, bairi quetiuparã reyes tʉpʉ cʉ̃ãrẽ mʉjãã neágarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bairo na caátimiatacʉ̃ãrẽ, na ũnarẽ yʉ yaye quetire nemojãñurõ mʉjãã quetibʉjʉ masĩgarã bairãpʉa. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bairi quetiuparã roro mʉjããrẽ na caátíparo jʉ̃goye, ‘¿Dope bairo na marĩ ĩrãati?’ ĩ tʉ̃goña macãẽtĩcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉ pʉame mʉjãã caĩpeere yʉ masĩõgʉ. Bairo yʉ caátoi, ni jĩcãʉ̃ ũcʉ̃ mʉjãã pesua mena macããcʉ̃ mʉjãã caĩrĩjẽrẽ nʉcãmasĩẽtĩgʉmi. Ni ũcʉ̃ manigʉmi mʉjããrẽ cabotioʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bairãpʉa, mʉjãã yarãrẽ bairo caãna nimirãcʉ̃ã, mʉjãã bʉsʉjã buitiregarãma. Bairi mʉjãã pacʉa, mʉjãã bairã, aperã mʉjãã yarã, mʉjãã baparã cʉ̃ã mʉjãã bʉsʉjã buitiregarãma. Bairo átiri, jĩcããrãrẽ mʉjãã pajĩãregarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bairi yua, ati ʉmʉrecóo macããna nipetiro mʉjããrẽ ĩñategarãma, yʉ yarã mʉjãã caãnoi. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bairi roro mʉjããrẽ na caátimiatacʉ̃ãrẽ, mʉjãã yasietigarã. Mʉjãã poawẽ jĩcãwẽãcã ũno yasietigaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Bairi yʉ yaye jĩcã wãmeacã ũnorẽ jãnaeticõãña, mʉjããrẽ Dios cʉ̃ canetõõparore bairo ĩrã! ");
INSERT INTO cbcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jĩcã rʉ̃mʉ soldaua, pajĩãrĩ majã Jerusalén macãrẽ na cajotoa ãmejorero ĩñarã, atore bairo mʉjãã ĩ tʉ̃goñamasĩgarã: ‘Merẽ ati macã yasigaro baiya,’ mʉjãã ĩ tʉ̃goñagarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bairi mʉjããrẽ ñiña: Judea yepa macããna ʉ̃tã yucʉpʉ na ruti ápáro. Aperã Jerusalén macããna ti macãrẽ na witiweyoátó. Tunu aperã wesepʉ caãna ti macãrẽ na tunuapéricõãto. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti rʉ̃mʉrĩ pʉame camasã rorije na caátiei jʉ̃gori popiye na cabairi rʉ̃mʉrĩ nigaro. Nipetiro baigaro Dios bʉsʉrica tutipʉ cʉ̃ caĩquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti rʉ̃mʉrẽ roro ati yepapʉre bairique nigaro. Dios pʉame popiye na baio joroque na átigʉmi, na yaye wapai. ¡Bairi carõmia bairirupaʉ caãna popiye netõõrõ baigarãma! ¡Tunu bairoa, caũpũrããcãrẽ capũnaacʉna cʉ̃ã popiye netõõrõ baigarãma ti rʉ̃mʉrẽ! ");
INSERT INTO cbcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bairi ti macã macããna jĩcããrã besui riagarãma. Aperã preso joricarã na caãnoi, nipetiro macã macããrĩpʉ ácoagarãma. Aperopʉ macããna pʉame Jerusalén macãrẽ ẽmacõãgarãma yua. Na pʉame ti macãpʉ nicõã nigarãma Dios cʉ̃ caátirotiricaro cãrõ,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ĩ quetibʉjʉ yaparo, atore bairo na ĩnemoñupʉ̃ tunu: “Jõ ʉmʉrecóopʉ ricaati cabaurije baugaro. Muipʉ ʉmʉreco macããcʉ̃, ñami macããcʉ̃ cʉ̃ã, ñocõã cʉ̃ã ricaati baugarãma. Bairi yua, nipetiro camasã tiere ĩña acʉacoagarãma. Tunu bairoa ria capairiya oco turi roro cabʉsʉocajorore tʉ̃gori tʉ̃go acʉacoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Camasã pʉame bairo cabairo ĩñarĩ: ‘¿Dope bairo to bairoati ati ʉmʉrecóo?’ ĩ uwitʉ̃goñagarãma bʉtioro. Ñocõã cʉ̃ã yuguiñacoagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bairo cabairo beropʉ, yʉ, Camasã Jʉ̃gocʉre ñiñamʉgõ jogarãma. Buseriwo watoapʉ nocãrõ yʉ catutuarije mena, bairi yʉ caasiyabatorije mena yʉ caatóre ĩñajogarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bairi mʉjããrẽ ñiña: Mʉjããrẽ yʉ caquetibʉjʉrijere bairo caetaro ĩñarĩ wãmʉnʉcãña. Bairo wãmʉnʉcãrĩ, jõbui pʉame mʉjãã wãmorĩrẽ ñumʉgõjori coteya. Yʉ, tocãrõã yʉ atígʉ, mʉjããrẽ netõʉ̃ acʉ́,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bairo ĩ quetibʉjʉ yaparori, ati wãmerẽ ĩcõñarĩ na quetibʉjʉ nemoñupʉ̃ tunu: “Higuera cawãmecʉti yucʉ, o apei yucʉ cabairijere mʉjãã masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ti yucʉ cawãma pũũ cawasoaro ĩñarĩ, ‘Merẽ cʉ̃ma cõñarõ baiya,’ mʉjãã ĩ masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Torea bairo mʉjããrẽ yʉ caquetibʉjʉrije caetaro ĩñarĩ, ‘Merẽ Dios cʉ̃ carotimasĩrĩpaʉ cõñarõ baiya,’ mʉjãã ĩ masĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Cariape mʉjããrẽ ñiña: Mʉjããrẽ yʉ caquetibʉjʉrije baijʉ̃gogaro ti yʉtea macããna na cariaparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ati ʉmʉrecóo, ati yepa cʉ̃ã yasipeticoagaro. Yʉ yaye quetibʉjʉrique roque petietigaro. Yʉ caĩrõrẽã bairo baicoagaro. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Caroaro tʉ̃goñaña. Ti rʉ̃mʉ caetaparo jʉ̃goye mʉjãã ĩña acʉare. Nemo yʉ catunuetari rʉ̃mʉrẽ, yʉ yarã roro na caátiãnorẽ ñiñagaetiya. Cacũmurãrẽ, bairi ati yepa macããjẽrẽ catʉ̃goñarĩqũẽ pairã cʉ̃ãrẽ na ñiñagaetiya. Bairi caroaro ãña tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Waibʉcʉ pʉame petiire cʉ̃ cayoata, rutimasĩẽtĩñami. Torea bairo ti rʉ̃mʉ caetaro, camasã tocãnacãpaʉ macããna rutimasĩẽtĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bairi yʉ caetaparore caroaro yuya. Tunu atore bairo Diore cʉ̃ jẽniña: ‘Ti rʉ̃mʉ caetaripaʉ tʉ̃goñatutuariquere jãã joya, ti rʉ̃mʉ cabaipeere jãã canetõmasĩparore bairo ĩrã. Bairi tunu jãã, Camasã Jʉ̃gocʉ tʉpʉ jãã caetaparore bairo ĩrã, tʉ̃goñatutuariquere jãã joya,’ qũĩ jẽniña tocãnacã rʉ̃mʉa,” na ĩ quetibʉjʉyupʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús pʉame ʉmʉrecore templo wiipʉ ñubuenucũñupʉ̃ ti semanarẽ. Ñami pʉamerẽ ácoanucũñupʉ̃ Olivo cawãmecʉti buropʉ, ñami netõõgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Camasã nipetiro tocãnacã ñamirõcã caãno templo wiipʉ etanucũñuparã, Jesús cʉ̃ cabuerijere tʉ̃gorã etarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Merẽ yua, cõñarõ baiyuparo bose rʉ̃mʉ, Pascua na caĩrĩ rʉ̃mʉ, pããrẽ cawauarije caasua manierẽ na caʉgari bose rʉ̃mʉ majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Quetiuparã sacerdote majã, bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã pʉame, “¿Dope bairo átiri Jesure cʉ̃ marĩ pajĩãrãati?” ãmeo ĩ bʉsʉyuparã na majũ. Bairãpʉa, átimasĩẽsuparã mai, camasãrẽ uwirã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bairi yua, wãtĩ cʉ̃ jããñupʉ̃ Judas Iscariote na caĩrẽ. Cʉ̃ pʉame Jesús bueri majã pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ mena macããcʉ̃ jĩcãʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bairi yua, Judas pʉame na ĩñaʉ ásúpʉ quetiuparã sacerdote majã, bairi tunu aperã templo wii quetiuparã majũrẽ. Na tʉpʉ etari, Jesure bʉsʉjã buitirocacõãñupʉ̃, cʉ̃ na capajĩãmasĩparore bairo ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bairo cʉ̃ caĩrõ tʉ̃go yua, ʉseanicoasuparã. Bairo ʉseanirĩ, “Dinero mʉrẽ jãã jogarã tie wapa,” qũĩñuparã templo wii quetiuparã pʉame Judare. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bairo cʉ̃ na caĩrõ, “Jaʉ,” ĩrĩ, jeyupʉ dinerore. Tie dinerore jeri bero, Judas pʉame camasã manorẽ ĩñarĩ macãjʉ̃goyupʉ, Jesure na ñerotigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Merẽ yua, etayuparo Pascua bose rʉ̃mʉ, pããrẽ cawauarije asuena na caʉgari bose rʉ̃mʉ. Tunu bairoa oveja nurĩcʉ̃ macʉ̃ cordero na caĩrẽ pajĩãrĩ na caʉgari bose rʉ̃mʉ etayuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bairo ti rʉ̃mʉ caetaro ĩña, Jesús pʉame atore bairo na ĩ joyupʉ Juan, apei Pedro menarẽ: —Pascua bose rʉ̃mʉ marĩ caʉgapeere qũẽnoyurájá. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na pʉame bairo cʉ̃ caĩrõ tʉ̃go, qũĩñuparã: —¿Noopʉ marĩ caʉgapeere jãã caqũẽnoyuro mʉ boyati? ");
INSERT INTO cbcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bairo na caĩjẽniñarõ, atore bairo na ĩñupʉ̃ Jesús: —Jerusalén macãrẽ etarã, mʉjãã bócaetagarã jĩcãʉ̃ caʉ̃mʉrẽ, ocorʉ pʉsari caácʉ́re. Cʉ̃rẽ cʉ̃ bócaetari, cʉ̃ bero mʉjãã ʉsaápá. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cʉ̃ ʉsaa yua, cʉ̃ wiipʉ cʉ̃ cajããrõ, ti wii upaʉre atore bairo cʉ̃ mʉjãã ĩgarã: ‘Cabuei bairo ĩ jẽniñajoyami: “¿Noopʉ to ãniñati Pascua bose rʉ̃mʉ caãno yʉ cabuerã mena yʉ caʉgapa arʉa?” ĩ jẽniña rotijoyami,’ mʉjãã ĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bairo mʉjãã caĩjẽniñarõ, mʉjãã ĩñogʉmi jõbuipʉ caroaro qũẽnoweyorica arʉare. Topʉ marĩ caʉgapeere mʉjãã qũẽnoyuwa —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bairo cʉ̃ caĩrõ tʉ̃go, acoásúparã. Topʉ na caetaro, nipetiro Jesús na cʉ̃ caĩatatorea bairo baipeticõãñuparõ. Bairi topʉ qũẽnoyuyuparã Pascua bose rʉ̃mʉ na caʉgapeere yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cabero yua, na caʉgari hora caetaro, Jesús bairi cʉ̃ cabuerã nipetiro etanumurĩ ruiyuparã mesapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bairo nipetiro na caruiro ĩñarĩ, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ: —¡Nocãrõ majũ ati Pascua bose rʉ̃mʉrẽ mʉjãã yʉ jʉ̃goʉgaganucũmitʉjoapʉ yʉ cariaparo jʉ̃goye! ");
INSERT INTO cbcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cariape mʉjããrẽ ñiña: Dios cʉ̃ carotimasĩrĩpaʉ caetaparo jʉ̃goye mʉjãã mena yʉ ʉganemoetigʉ —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bairo ĩ yaparo, cʉ̃ wãmo mena jĩcãrʉ etiricarʉre nerĩ, “Dios, mʉ ñujãñuña jãã mena,” qũĩ yaparori, atore bairo na ĩñupʉ̃ Jesús, cʉ̃ cabuerãrẽ: —Atie ʉse ocore ãmeo tĩãbato peyocõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cariape mʉjããrẽ ñiña: Ãmea mʉjãã mena atie ʉse ocore pʉgani yʉ etinemoetigʉ yʉ Pacʉ cʉ̃ carotimasĩrĩpaʉ tunu caetaro marĩ caetinemoparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cabero tunu cʉ̃ wãmo mena pããrẽ nerĩ, “Dios mʉ ñujãñuña jãã menarẽ,” ĩ yaparori, carecomacã peenerĩ na batoyupʉ Jesús cʉ̃ cabuerãrẽ. Nunirĩ atore bairo na ĩñupʉ̃: —Atie pan, yʉ rupaʉ niña. Mʉjããrẽ yʉ cariabojarije macããjẽ niña. Bairi mʉjãã cʉ̃ã, cabero atore bairo yʉ caátajere tʉ̃goñarĩ, pããrẽ mʉjãã bato ʉganucũgarã —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cabero tunu torea bairo ásupʉ etiricarʉre, ʉga yaparori bero. Atore bairo na ĩñupʉ̃ Jesús: —Atirʉ macããjẽ ʉse oco pʉame yʉ rií niña. Camasãrẽ netõõgʉ, yʉ riacoagʉ. Bairo yʉ cariápee jʉ̃gori cawãma wãme camasãrẽ Dios cʉ̃ caátibojacũrĩjẽ niña. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tunu apeyera yʉre roro caĩbuitirocapaʉ yʉ mena, yʉ caʉgari mesapʉ ʉgaruiyami cʉ̃ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Torecʉna, yʉ, Camasã Jʉ̃gocʉ, yʉ Pacʉ yʉ cʉ̃ cabairotijoricarorea bairo yʉ baigʉ. Cabaimiatacʉ̃ãrẽ, yʉre caĩbuitirocapaʉre cʉ̃ carorije wapa pairo nigaro —na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bairo cʉ̃ caĩrĩjẽrẽ tʉ̃gori, “¿Ni majũ cʉ̃ ãnicʉti cʉ̃rẽ caĩbuitiri majõcʉ?” ãmeo ĩ jẽniña jʉ̃goyuparã na majũ, cʉ̃ cabuerã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Cabero tunu Jesús cʉ̃ cabuerã pʉame, “¿Ni majũ cʉ̃ ãnicʉti jĩcãʉ̃ marĩ mena macããcʉ̃, caãni majũʉ̃rẽ bairo caãcʉ̃?” ãmeo ĩ bʉsʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bairo na caĩrĩjẽrẽ tʉ̃go, atore na ĩñupʉ̃ Jesús: “Ati yepa macããna quetiuparã reyre bairo caãna tutuaro mena na rotiepeyama na roca macããnarẽ. ‘Camasãrẽ cajʉána’ wãmecʉtiyama bairãpʉa. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tore bairo na cabaimiatacʉ̃ãrẽ, mʉjãã pʉame roquere tore bairo baietirotiya. Bairo pʉame bairotiya mʉjããrẽ: Mʉjãã mena macããcʉ̃, caãnimajũʉ̃rẽ bairo caãnigaʉ mʉjãã mena macããcʉ̃, mʉjãã roca netõjãñurõ carotimasĩrẽ bairo ãnirotiya. Tunu bairoa carotiri majõcʉre bairo caãnigaʉ, mʉjãã ʉ̃mʉrẽ bairo cʉ̃ ãmarõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Toroque, ¿ni pʉame cʉ̃ ãnicʉti caãnimajũʉ̃rẽ bairo caãcʉ̃: Mesapʉ caʉgarui pʉame, o cʉ̃rẽ caʉgarique qũẽnonuʉ pʉame, cʉ̃ ãnicʉti caãnimajũʉ̃rẽ bairo caãcʉ̃? Ati yepa macããna pʉame, ‘Mesapʉ caʉgarui pʉame cʉ̃rẽ caʉgarique qũẽnonuʉ netõõrõ caãnimajũʉ̃ niñami,’ ĩ tʉ̃goñabujiorãma. Bairo na caĩtʉ̃goñamiatacʉ̃ãrẽ, yʉ pʉame ʉgariquere caqũẽnonuʉ ʉ̃mʉrẽ bairo yʉ ãniña mʉjãã menarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Apeyera tunu ati yepapʉre popiye yʉ cabairi rʉ̃mʉrĩrẽ mʉjãã roque tocãnacãnia yʉ mena mʉjãã bapacʉti ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bairo mʉjãã cabairoi, yʉ Pacʉ yʉre rotimasĩrĩqũẽrẽ cʉ̃ cajoricarorea bairo yʉ cʉ̃ã rotimasĩrĩqũẽrẽ mʉjããrẽ yʉ joya. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bairi yʉ carotimasĩrĩpaʉpʉ mʉjãã cʉ̃ã eti, ʉga, mʉjãã átigarã yʉ ya mesapʉ. Tunu bairoa quetiuparã na caruiro ũno, tronopʉ mʉjãã ruigarã. Israel yepa macããna, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã poari macããna na caátajere ĩñacõñarĩ na mʉjãã ĩñabesegarã,” na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Cabero tunu qũĩnemoñupʉ̃ Jesús Simorẽ: —Simón, yʉ yaʉ, tʉ̃goya yʉ caĩrĩjẽrẽ: Satanás pʉame mʉjããrẽ bʉsʉjãgʉmi, roro mʉjãã caátiparore bairo ĩ. Jĩcãʉ̃ trigo aserire cʉ̃ cajʉgarerore bairo mʉjãã cʉ̃ãrẽ regayami. Yʉ mena mʉjãã caãnorẽ boojãẽtĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bairo Satanás mʉjããrẽ cʉ̃ caátigamiatacʉ̃ãrẽ, yʉ pʉame mʉrẽ Diopʉre yʉ jẽnibojaapʉ, cʉ̃ mena caroaro majũ mʉ catʉ̃goñatutuaparore bairo ĩ. Bairi yua, yʉ mena tunu caroaro nemojãñurõ tʉ̃goñatutuari marĩ yarãrẽ caroaro na mʉ jʉ̃goãnigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bairo Jesús cʉ̃ caĩrõ tʉ̃go, qũĩñupʉ̃ Pedro pʉame: —Yʉ Quetiupaʉ, di rʉ̃mʉ ũno mʉ yʉ aweyoetigʉ. Ãmea mʉ mena preso jorica wiipʉ yʉ ámasĩña. Tunu bairoa mʉ mena yʉ baiyasi masĩña —qũĩñupʉ̃ Simón Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bairo cʉ̃ caĩrõ, atore bairo qũĩñupʉ̃ Jesús Simorẽ: —Pedro cariape mʉrẽ ñiña: Ãme ñamia ãbocʉ cʉ̃ capiiparo jʉ̃goye itiani majũ, ‘Cʉ̃ yʉ masĩẽtĩña Jesure,’ yʉ mitogʉ —qũĩñupʉ̃ Jesús Simorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Cabero tunu atore bairo na ĩñupʉ̃ Jesús: —Mʉjããrẽ wasopoa ũno, bairi moneda jããrĩcã poa ũno cʉ̃ãrẽ, bairi tunu rʉpo juti ũnie cʉ̃ãrẽ cʉ̃goena, mʉjããrẽ yʉ caárotirica rʉ̃mʉrẽ, ¿ñe ũnie mʉjãã to rʉsari? —na ĩñupʉ̃ Jesús. Bairo cʉ̃ caĩrõ, qũĩñuparã: —Ñe ũnie jãã rʉsaepʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Bairo na caĩrõ, na ĩnemoñupʉ̃ tunu: —Bairi ãmerã, cawasopoacʉcʉ, cʉ̃ wasopoare cʉ̃ neápáro. Tunu bairoa cʉ̃ moneda jããrĩcã poa cʉ̃ãrẽ cʉ̃ neápáro. Bairi tunu jarericapãĩ cacʉ̃goecʉ cʉ̃ã, cʉ̃ oco juricarore nunirocari, jĩcãpãĩ cʉ̃ jarericapãĩ wapatiáto. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bairi mʉjããrẽ ñiña: “Atore bairo ĩ woatuyayupa mai yʉ cabaipeere Dios bʉsʉrica tutipʉ: ‘Carorije caána watoapʉ yasigʉmi.’ Bairi nipetirije yʉre Dios ya tutipʉ na caĩwoatujʉ̃goyetirique, na caĩrĩcãrõrẽã bairo baipeticoagaro,” na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bairo cʉ̃ caĩrĩjẽrẽ caroaro tʉ̃goñamasĩẽtĩrĩ, atore bairo qũĩñuparã: —Jãã Quetiupaʉ, ato niña jarericapãĩrĩ pʉgapãĩ. Tie mena na marĩ ãmeo qũẽmasĩña. Bairo na caĩrõ, Jesús pʉame na ĩñupʉ̃: —Tocãrõ majũ átia mano. Bairo marĩ áperigarã —na ĩñupʉ̃ Jesús, bairo na caĩrõĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cabero yua, acoásúpʉ Olivos na caĩrĩ buropʉ. Topʉ caájeyanucũrĩcʉ̃ ãnirĩ topʉ ásúpʉ. Bairo Jesús cʉ̃ caátó, cʉ̃ cabuerã cʉ̃ã cʉ̃ ʉsa ásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bairi yua, topʉ na caetaro, atore bairo na ĩñupʉ̃: —Diore cʉ̃ jẽniña, wãtĩ mʉjããrẽ cʉ̃ canetõõẽtĩparore bairo ĩrã —na ĩñupʉ̃ Jesús cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bairo na ĩ yaparori bero, Jesús pʉame ʉ̃tããrẽ wẽjoricaro cãrõ wʉri, cʉ̃ rʉpopaturi mena etanumurĩ Diore cʉ̃ jẽnijʉ̃goyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Atore bairo ĩ jẽniñupʉ̃: “Caacʉ, mʉ cabooata, atie roro yʉ canetõpeere yʉ mʉ netõõbojagʉ. Bairopʉa, yʉ caborore bairo to baieticõãto. Mʉ caborore bairo roque to baiáto,” ĩ jẽniñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bairo cʉ̃ caĩjẽniãnipaʉa, ángel buiaetayupʉ, Jesure tʉ̃goñatutuarique cʉ̃ jogʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bairo roro cʉ̃ canetõrĩjẽ watoapʉ, Jesús netõjãñurõ jẽninemoñupʉ̃. Bairo cʉ̃ cajẽnirõ, cʉ̃ caasipuarije oco pʉame riíre bairije tapiwẽñuparõ yepapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bairo Diore jẽni yaparori, wãmʉnʉcã ásúpʉ cʉ̃ cabuerã tʉpʉ. Jesús pʉame cacãnirãpʉ̃rẽ na etayupʉ. Cʉ̃ cabuerã pʉame Jesús cʉ̃ caĩrĩjẽrẽ tʉ̃goñatutuaetiri cãnicoasuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Cacãnirãrẽ na etari, na ĩñupʉ̃ Jesús: —¿Nopẽĩrã mʉjãã cãniñati? Cãniena, wãmʉnʉcãrĩ Diore cʉ̃ jẽniña, wãtĩ mʉjããrẽ cʉ̃ canetõõẽtĩparore bairo ĩrã —na ĩñupʉ̃ Jesús, cʉ̃ cabuerã cacãnirãrẽ na etari. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bairo cʉ̃ cabuerãrẽ cʉ̃ caĩãnoa, capããrã camasã etayuparã. Narẽ cajʉ̃goʉ Judas ãñupʉ̃. Pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ Jesús cʉ̃ buerã mena macããcʉ̃ jĩcãʉ̃ caãninucũmirĩcʉ̃ ãñupʉ̃. Bairi yua, Judas pʉame Jesutʉ etayupʉ, cʉ̃ jẽnigʉ. Etari, caroaro mena átitori, cʉ̃ ũpũñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bairo cʉ̃ caáto, Jesús pʉame atore bairo qũĩñupʉ̃: —Judas, ¿nopẽĩ yʉ, Camasã Jʉ̃gocʉre ũpũrĩ yʉ mʉ ĩbuiti rocagayati? —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bairi Jesús mena macããna pʉame caetari majã na caátigarijere ĩñarĩ, qũĩñuparã Jesure: —Jãã Quetiupaʉ, ¿jarericapãĩrĩ mena na jãã qũẽcʉti? ");
INSERT INTO cbcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bairo ĩrĩ, jĩcãʉ̃ na mena macããcʉ̃ pʉame sacerdote majã quetiupaʉ ʉ̃mʉrẽ cʉ̃ cãmii tuyupʉ. Cʉ̃ ãmorõ cariape nʉgõã pʉamerẽ cʉ̃ patañocõã joyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bairo cʉ̃ caáto ĩña, atore bairo qũĩñupʉ̃ Jesús: —Bairo ápericõãña. Na mena ãmeo qũẽẽtĩcõãña —qũĩñupʉ̃. Bairo ĩ yaparori, cʉ̃ capataatacʉ ãmorõrẽ ñerĩ, cʉ̃ pititu catioyupʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Áti yaparori bero, na ĩñupʉ̃ Jesús. Quetiuparã sacerdote majã, bairi templo wii quetiuparã majã, aperã cabʉtoa camasĩrĩ majã, nipetiro cʉ̃rẽ ñegarã caetari majãrẽ, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã cajerutiri majõcʉ yʉ caãnorẽ bairo jarericapãĩrĩ mena, bairi yucʉ rʉcaari mena yʉ mʉjãã ñerã atíati? ");
INSERT INTO cbcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tocãnacã rʉ̃mʉa mʉjãã watoa yʉ ãninucũãpʉ̃ templo wiipʉre. Bairo yʉ caãnimiatacʉ̃ãrẽ, ni jĩcãʉ̃ ũcʉ̃ mʉjãã mena macããcʉ̃ yʉ ñeemi. Ãme ati ñamipʉ mʉjãã caátigarijere mʉjãã átimasĩgarã bairãpʉa wãtĩ cʉ̃ carotirore bairo —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bairo cʉ̃ caĩrõ bero, cʉ̃ ñeñuparã Jesure. Bairo cʉ̃ átiri, cʉ̃ neásúparã yua, sacerdote majã quetiupaʉ ya wiipʉ. Pedro pʉame yoajãñurõpʉa na ĩñaʉsayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Cabero topʉ etarã, guardia pʉame peero rioyuparã ti wii macã yepa recomacãrẽ. Bairo átiri, ti peerotʉ jũma ruiyuparã. Pedro cʉ̃ã na tʉre ruiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bairo peerotʉ cʉ̃ caruiro, jĩcãõ paabojari majõco Pedrore qũĩñaqũẽnorĩ bairo ĩñupõ: —Ãni cʉ̃ã Jesús mena macããcʉ̃ ãcʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro pʉame ĩtori atore bairo cõ ĩñupʉ̃: —Yʉ yao, cʉ̃ yʉ masĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Cabero tunu apei Pedrore qũĩñarĩ, bairo qũĩñupʉ̃: —Mʉ cʉ̃ã, Jesús mena macããcʉ̃ã mʉ ãniña. Pedro pʉame qũĩñupʉ̃: —Yʉ baietiya, tame. Cʉ̃ mee yʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bairi tunu jĩcã hora bero, apei cʉ̃ã jĩcãʉ̃ na mena macããcʉ̃ tutuaro mena na ĩñupʉ̃ cʉ̃ yarãrẽ: —Cariape mʉjããrẽ ñiña: Ãni cʉ̃ã Jesús mena macããcʉ̃ ãcʉ̃mi. Ãnia, Galilea macããcʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame qũĩñupʉ̃: —Tame, merẽ mʉjããrẽ, ‘Cʉ̃ yʉ masĩẽtĩña,’ mʉjãã ñimiñajã —na ĩñupʉ̃. Bairo Pedro cʉ̃ caĩtoãnipaʉa jĩcãʉ̃ ãbocʉ piiyupʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Marĩ Quetiupaʉ pʉame ãmejoreri, qũĩñajoyupʉ Pedrore. Bairo cʉ̃ caáto, Pedro pʉame tʉ̃goña bócayupʉ marĩ Quetiupaʉ cʉ̃ caĩatajere. “Pedro ãmeacã ãbocʉ cʉ̃ capiiparo jʉ̃goye itiani, ‘Cʉ̃ yʉ masĩẽtĩña Jesure,’ yʉ mitogʉ,” cʉ̃ cʉ̃ caĩatajere tʉ̃goña bócayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bairo tʉ̃goña bócari yua, witicoásúpʉ macãpʉ. Topʉ yua, tʉ̃goña yapapuari bʉtioro otiyupʉ Pedro. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bairi Jesure cacoterã pʉame roro qũĩ epejʉ̃goyuparã. Cʉ̃ bapeyuparã. Cʉ̃ payuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tunu cʉ̃ caapeere jutii asero mena jiyabiatori, na wãmorĩ mena cʉ̃ riapére cʉ̃ payuparã. Bairo átiri, qũĩ jẽniñañuparã: —Mʉ camasĩrĩjẽ jʉ̃gori jãã quetibʉjʉya: ¿Noa ãmerẽ mʉrẽ na payati? —qũĩ epeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tore bairo jeto capee wãme qũĩ epeyuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cabusuro bero, judío majã cabʉtoa camasĩrã majũ, bairi quetiuparã sacerdote majã, aperã Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobuerã cʉ̃ã neñañuparã. Jesure cʉ̃ neásúparã Junta Suprema macããna tʉpʉ. Topʉ etarã, atore qũĩ jẽniñañuparã: ");
INSERT INTO cbcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Jããrẽ cariape quetibʉjʉya: ¿Mʉ, Mesías, Dios cʉ̃ cajoʉ mʉ ãniñati? —qũĩ jẽniñañuparã. Jesús pʉame bairo na ĩñupʉ̃: —‘Cʉ̃ã yʉ ãniña,’ yʉ caĩata, cariape yʉ mʉjãã tʉ̃goetibujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tunu bairoa yʉ cʉ̃ã mʉjããrẽ yʉ cajẽniñaata, mʉjãã yʉetibujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bairo cariape mʉjãã catʉ̃goetimiatacʉ̃ãrẽ, yʉ, Camasã Jʉ̃gocʉ, Dios cʉ̃ caĩñajoro cʉ̃tʉ cariape nʉgõãrẽ caruipaʉ yʉ ãniña. Ãme beroaca Nipetiro Carotimasĩ tʉpʉ caruipaʉ yʉ ãniña —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bairo cʉ̃ caĩrõ tʉ̃go, to macããna nipetirã cʉ̃ jẽniñanemoñuparã: —¿Bairo mʉ caĩata, “Dios macʉ̃ yʉ ãniña,” ĩgʉ miñati? Bairo na caĩjẽniñarõ, Jesús pʉame na ĩñupʉ̃: —Cʉ̃ã yʉ ãniña, mʉjãã caĩrõrẽã bairo. ");
INSERT INTO cbcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bairo cʉ̃ caĩrõ, ãmeo ĩñuparã na majũ: —Roro cʉ̃ caĩrĩqũẽrẽ marĩrẽ caquetibʉjʉnemoparãrẽ na marĩ macãnemoetigarã. Merẽ marĩ majũã, marĩ tʉ̃go yaparoya roro cʉ̃ caĩrĩjẽrẽ —ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bairo ĩ yaparori bero, wãmʉnʉcãrĩ cʉ̃ neásúparã quetiupaʉ Pilato cawãmecʉcʉ tʉpʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Topʉ etarã, Jesure cʉ̃ bʉsʉjã jʉ̃goyuparã. Atore bairo qũĩ bʉsʉjãñuparã: —Ãni, cʉ̃ caquetibʉjʉrije jʉ̃gori jãã yarã na tʉ̃gomawijiao joroque na átiyami. ‘Roma macããcʉ̃ quetiupaʉ emperadore, marĩ yaye dinero impuestore cʉ̃ marĩ joetigarã,’ jãã ĩ quetibʉjʉnucũñami. Tunu bairoa, ‘Mesías yʉ ãniña,’ ĩtonucũñami. Bairo cʉ̃ caĩata, ‘Quetiupaʉ Rey yʉ ãniña,’ caĩrẽ bairo ĩnucũñami —qũĩ bʉsʉjãñuparã Pilatore. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bairo na caĩrõ tʉ̃go, atore bairo qũĩñupʉ̃ Pilato Jesure: —¿Mʉa, judío majã Quetiupaʉ Rey mʉ ãniñati? Bairo cʉ̃ caĩrõ, Jesús pʉame qũĩñupʉ̃: —Mʉ caĩrõrẽã bairo yʉ baiya —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo na ĩñupʉ̃ Pilato sacerdote majã quetiuparãrẽ, aperã camasã cʉ̃ãrẽ: —Yʉa, ãni roro cʉ̃ caátiere yʉ bócañaẽtĩña. Ñe ũnie buicʉperiyami —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bairo na cʉ̃ caĩmiatacʉ̃ãrẽ, nipetiro camasã pʉame tutuaro mena qũĩnemoñuparã tunu: —Ãni, cʉ̃ caquetibʉjʉrije mena roro camasã na tʉ̃gomawijiao joroque na átinucũñami. Galilea macãpʉ bairo átijʉ̃gowĩ. Ãmerẽ tunu, ati yepa, Judea yepare torea bairo roro na ĩtoʉ átiyami —qũĩ bʉsʉjãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bairo na caĩrĩjẽrẽ tʉ̃gori, Pilato pʉame, “¿Galilea macããcʉ̃ cʉ̃ ãniñati?” na ĩ jẽniñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bairi yua, “Cʉ̃ã niñami,” na caĩrõ tʉ̃go, Herodes cawãmecʉcʉ tʉpʉ Jesure cʉ̃ neárotiyupʉ Pilato. Mai, Herodes pʉame Galilea yepa macããna quetiupaʉ ãñupʉ̃. Baipʉa, ti rʉ̃mʉrĩrẽ cʉ̃ cʉ̃ã ãñupʉ̃ Jerusalén macãpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bairo Jesure Herodetʉ na cane etaro ĩña, Herodes pʉame bʉtioro qũĩñajesoyupʉ. Mai, Herodes pʉame Jesús cʉ̃ caátiere, camasã na caquetibʉjʉrijere tʉ̃gonucũñupʉ̃. Bairi bʉtioro Jesure qũĩñaga nucũmiñupʉ̃, ape wãme cʉ̃ caátijẽñomasĩrĩjẽrẽ ĩñagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bairo Jesús cʉ̃ caetaro, capee cʉ̃ jẽniñamiñupʉ̃. Jesús pʉame cʉ̃ yʉesupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Topʉ ãñuparã quetiuparã sacerdote majã, aperã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cajʉ̃gobueri majã mena. Na pʉame Jesure tutuaro mena cʉ̃ bʉsʉjãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bairi Herodes, cʉ̃ ʉ̃mʉa cʉ̃ã Jesure roro qũĩ epeyuparã. Bairo átiri, jutii quetiupaʉ rey ũcʉ̃ cʉ̃ cajãñarĩjẽ ũnierẽ cʉ̃ jãñuparã, cʉ̃ boyetiepegarã. Cabero Jesure Pilato tʉpʉ cʉ̃ neárotiyupʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti rʉ̃mʉ caãno, Herodes, bairi Pilato mena ãmeo bapacʉti jʉ̃goyuparã, cajʉ̃goyepʉ mai caãmeo ĩñatemirĩcãrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Cabero Pilato pʉame quetiuparã sacerdote majã, aperã carotimasĩrĩ majã, aperã camasã nipetirore na neñoñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na neñorĩ, atore bairo na ĩñupʉ̃: —Mʉjãã, ãnirẽ cʉ̃ bʉsʉpaigarã, yʉtʉ cʉ̃ mʉjãã neatíupa. ‘Cʉ̃ caquetibʉjʉrije mena camasãrẽ na tʉ̃gomawijiao joroque na átiyami,’ ĩrĩ, yʉtʉ cʉ̃ mʉjãã neatíupa. Bairo mʉjãã caĩrõĩ, yʉ pʉame mʉjãã caĩñajoro, cʉ̃ yʉ jẽniñamiapʉ̃. Bairo mʉjãã, ‘Roro átiyami,’ mʉjãã caĩmiatacʉ̃ãrẽ, yʉa, ãnirẽ roro cʉ̃ caátiere yʉ bócañaẽtĩña. Ñe ũnie mʉjãã cabʉsʉjãmirĩjẽ cʉ̃ yʉ wapa bocaetiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes marĩrẽ cʉ̃ catunuojoatacʉ cʉ̃ã, ‘Ñe ũnie buicʉperiyami,’ ĩũpĩ. Bairi cʉ̃ cayasimasĩrõ maniña. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Baipʉa, cʉ̃ yʉ baperotigʉ. Cʉ̃rẽ na cabapeyaparoro, cʉ̃ yʉ wiyogʉ —na ĩñupʉ̃ Pilato camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mai, tocãnacã Pascua bose rʉ̃mʉ caãno, Pilato pʉame wiyonucũñupʉ̃ jĩcãʉ̃ preso jorica wiipʉ macããcʉ̃, judío majã na caboʉre. Bairi Jesure cʉ̃ wiyogamiñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bairo cʉ̃ caátigamiatacʉ̃ãrẽ, nipetiro camasã pʉame bairo boesuparã: —¡Bairo mʉ áperigʉ! ¡Barrabás roquere jããrẽ mʉ wiyobojagʉ! —qũĩ awaja jʉ̃goyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás pʉame ti macãrẽ ãcʉ̃, na quetiupaʉ gobiernorẽ rocagʉ, bairi tunu camasãrẽ na pajĩãrĩ, preso jorica wiipʉ ãñupʉ̃ tie wapa. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato pʉame Jesure cawiyogaʉ ãnirĩ tunu na ĩnemoñupʉ̃: —Jesure cʉ̃ yʉ wiyogʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ to macããna netõõjãñurõ qũĩ awajayuparã: —¡Yucʉpãĩpʉ cʉ̃ papuaturotiya! ");
INSERT INTO cbcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tunu na ĩnemoñupʉ̃: —Cariape yʉ quetibʉjʉya: ¿Dise ũnie carorije cʉ̃ ásupari? Yʉa, ãnirẽ roro cʉ̃ caátiere yʉ bócañaẽtĩña. Bairi cʉ̃ cayasimasĩrõ maniña. Baipʉa, cʉ̃ yʉ baperotigʉ. Cʉ̃rẽ na cabape yaparoro, cʉ̃ yʉ wiyorotigʉ —na ĩñupʉ̃ merẽ itiani majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, “¡Yucʉpãĩpʉ cʉ̃ papuatu rotiya!” jĩrĩã bʉtioro jãñurĩ ĩ awajanemoñuparã. Bairi to macããna, sacerdote majã quetiuparã, bairi aperã camasã mena, bʉtioro na caawajaro jʉ̃gori, na caborore bairo baiyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bairi Pilato pʉame, “Torecʉ, na caborore bairo yʉ átigʉ,” ĩ tʉ̃goñañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bairi cárcel caãcʉ̃ gobiernorẽ carocagamirĩcʉ̃, camasãrẽ capajĩãrĩcʉ̃rẽ cʉ̃ wiyorotiyupʉ. Bairo átiri, Jesure yua, na caborore bairo na átirotiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bairi yua, Jesure cʉ̃ neásúparã, yucʉpãĩpʉ cʉ̃ papuatugarã. Bairo áná, Simón cawãmecʉcʉre cʉ̃ ñeñuparã, Jesús yucʉpãĩrẽ cʉ̃ pʉsabojáto, ĩrã. Mai, Simón pʉame Cirene yepa macããcʉ̃ ãñupʉ̃. Ti rʉ̃mʉrẽ aperopʉ caãniatacʉ etaʉ baiyupʉ Jerusalén macãrẽ. Bairi Jesús berore cʉ̃ yucʉpãĩrẽ pʉsa ásúpʉ Simón. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesure na capapuarátóre, capããrã camasã na ʉsayuparã. Bairi carõmia na mena caãna pʉame, roro Jesure na caátigaro ĩñarĩ, bʉtioro tʉ̃goña yapapuari, otiʉsayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Bairo na caotiro ĩñarĩ, Jesús pʉame atore bairo na ĩñupʉ̃ na, rõmirĩrẽ: —Mʉjãã, Jerusalén macããna rõmirĩ. Roro yʉ cabaipeere tʉ̃goña yapapuaeticõãña. Popiye mʉjãã cabaipa rʉ̃mʉrĩ etagaro. Ti rʉ̃mʉ caetaro, ati macã macããna rõmirĩ atore bairo ĩgarãma: ‘Ʉseanirĩ niñama carõmia capũnaacʉti masĩẽna, capũnaa mána, capũnaa ũpũõẽna.’ Roro tʉ̃goña yapapuari bairo ĩgarãma. Bairi mʉjãã majũã roro mʉjãã cabaipeere, mʉjãã pũnaa cʉ̃ã roro na cabaipee pʉamerẽ tʉ̃goña yapapuari otiya. Yʉre, ‘Roro baiyami,’ ĩ otieticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti rʉ̃mʉ caetaro, camasã pʉame riagamirã, ‘¡Ʉ̃tã yucʉre jããrẽ to tãnio reató!’ ãmeo ĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yʉ, caroaro caácʉ ãnirĩ yucʉ cacatiricʉre bairo yʉ ãniña. Bairo caãcʉ̃rẽ yʉre na caátimasĩata, nocãrõ roro netõõrõ na átigarãma ati macã macããnarẽ, yucʉ cajĩnirĩcʉre bairo caãnarẽ —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesús mena na neásúparã caʉ̃mʉa pʉgarã roro caánarẽ, Jesús mena na cʉ̃ãrẽ yucʉpãĩpʉ na papuaturegarã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bairi yua, La Calavera na caĩrõpʉ etarã, Jesure yucʉpãĩpʉ cʉ̃ papuatuyuparã. Cʉ̃ mena, roro caána cʉ̃ãrẽ na papuatuyuparã, jĩcãʉ̃ cariape nʉgõãrẽ, apei caãcõ nʉgõãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Bairo yucʉpãĩpʉ tusaʉ, Jesús pʉame Diore qũĩñupʉ̃: —Caacʉ, ãnoa roro na caátiere masĩẽtĩñama. Bairi tiere na masiriyobojaya —qũĩñupʉ̃. To caãna soldaua pʉame cʉ̃ jutirore nipetirã caborã ãnirĩ, número tiirire ãmeo wẽnuniñuparã. Bairo átiri na majũ masĩñuparã Jesús jutirore canepaʉre. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Camasã nipetiro to caãna Jesure qũĩñajoyuparã. Bairi tunu carotimasĩrĩ majã cʉ̃ã qũĩñajori roro qũĩ boyeti epeyuparã: —Aperãrẽ na netõũpʉ̃. Bairi ãmerẽ cʉ̃ majũã cʉ̃ netõáto. Mesías, Dios cʉ̃ cabesericʉ majũ cariape cʉ̃ caãmata, cʉ̃ majũã netõõmasĩbujioʉmi —qũĩ boyetiepeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldaua cʉ̃ã qũĩ boyetiepeyuparã. Cʉ̃tʉ etari, ʉse oco carorijere, “¡Ʉ̃jʉ̃, etiya!” qũĩ epeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tunu atore bairo qũĩnemoepeyuparã: —¡Mʉ, judío majã Quetiupaʉ Rey mʉ caãmata, mʉ majũã mʉ netõmasĩbujioʉ! Mʉ netõẽtĩña —qũĩ epeyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tunu bairoa Jesús rʉpoa buire yucʉpãĩ woaturicapãĩrẽ papuatuyuparã. Tipãĩpʉre atore bairo ĩ woaturique tusayuparo: ÃNI JUDÍO MAJÃ QUETIUPAɄ REY NIÑAMI, ĩ woaturique tusayuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jesús mena na capapuaatacʉ jĩcãʉ̃ Jesure tutiri atore bairo qũĩñupʉ̃: —¡Mesías, Dios cʉ̃ cajoʉ majũ mʉ caãmata, mʉ majũã mʉ netõõbujioʉ! Jãã cʉ̃ãrẽ mʉ netõõbujioʉ. Mʉ netõõmasĩẽcʉ̃ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Bairo cʉ̃ caĩrõ, cʉ̃ mena macããcʉ̃ apei pʉame qũĩ tutiyupʉ cʉ̃ bapare: —Mʉ, cariacoapaʉ nimicʉ̃ã, ¿Dios mena mʉ tʉ̃goña qũẽnogaetiyati mai? Marĩã, roro caãna ãnirĩ marĩ buicʉtiya. Bairi marĩrẽ pajĩãrã átiyama. Ãni roque dise ũnie carorije caápei niñami —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Cabero Jesús pʉamerẽ qũĩñupʉ̃: —Jesús, mʉ carotimasĩrĩpaʉ etaʉ, yʉre mʉ masiritiepa. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Bairo cʉ̃ caĩrõ, qũĩñupʉ̃ Jesús pʉame: —Cariape mʉrẽ ñiña: Ati rʉ̃mʉa yʉ mena mʉ ãnigʉ, Diotʉ, nocãrõ caroaro caãnopʉ —qũĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Merẽ yua, pasaribota caãno, caãno tʉsaroa yua, naitĩãcoásúparo ati yepa nipetiropʉ. Yoaro naitĩãñuparõ. Bairi muipʉ bauesupʉ. Ñamicã, tres de la tarde caãno majũ tunu busuyuparo. Tunu bairoa templo wii arʉare ẽñotaricaro jutii asero carecomacã woocoasuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Bairo cabairo bero yua, Jesús pʉame bʉsʉrique tutuaro mena atore bairo ĩñupʉ̃: —¡Caacʉ, yʉ yeri pũnarẽ yʉ bocáñeña! Atore bairo ĩ yaparo, riacoásúpʉ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldaua quetiupaʉ capitán pʉame cabaiatajere ĩñarĩ, atore bairo Diore qũĩ basapeoyupʉ: —Cariapea ãnia, Jesús carorije caápei majũ nimiupĩ —ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tunu bairoa camasã nipetiro to caãna tie cabaiatajere caĩñaatana ãnirĩ, bʉtioro tʉ̃goña yapapuari na cotiare pari tunuásúparã, Diore tʉ̃goñabobori. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bairi Jesús baparã caãnana cʉ̃ã nipetiro, aperã carõmia Galilea yepa macããna Jesure caʉsaátíatana pʉame toa tuari jõpʉ̃ã ĩñacõãnucũñuparã cabaiatajere. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mai, ãñupʉ̃ jĩcãʉ̃ caʉ̃mʉ cañuʉ José cawãmecʉcʉ. Arimatea cawãmecʉti macã macããcʉ̃ ãñupʉ̃. Ti macã pʉame Judea yepapʉre ãñuparõ. Cʉ̃ cʉ̃ã, quetiuparã, Junta Suprema majã mena macããcʉ̃ jĩcãʉ̃ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mai, José pʉame Dios cʉ̃ carotimasĩrĩpaʉ caetarore cacotei ãñupʉ̃. Bairi cʉ̃ mena macããna quetiuparã roro na caátiatajere caboetimiatacʉ ãñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bairi yua, Pilato tʉpʉ átí, Jesús rupaʉri ãnajẽrẽ yarocagʉ, cʉ̃ jẽniásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cabero yua, José pʉame Jesure, yucʉpãĩpʉ catusaʉre cʉ̃ ruioyupʉ. Bairo cʉ̃ átiri, jutii asero lino mena, cʉ̃ ũmañupʉ̃. Bairo átiri bero, ʉ̃tã opepʉ Jesús rupaʉri ãnajẽrẽ cũñupʉ̃. Áti yaparori, ʉ̃tãpãĩ mena tubiatoyupʉ. Ti ope pʉame mai, aperã cayasirãrẽ cacũroca mani ope ãñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ti rʉ̃mʉ pʉame ãñuparõ judío majã na cayerijãrĩ rʉ̃mʉ jʉ̃goye macã rʉ̃mʉ. Ti rʉ̃mʉ ñamicã merẽ judío majã na cayerijãrĩ rʉ̃mʉ etagaro baiyuparo. Bairi qũẽno weyopeyogarã baiyuparã, na cayerijãrĩ rʉ̃mʉ caetaparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bairi carõmia Galilea yepa macããna Jesure caʉsaátíatana cʉ̃ã ásúparã, Jesure ʉ̃tã opepʉ na cayarore ĩñaráná. Na, rõmirĩ pʉame Jesús rupaʉri ãnajẽrẽ na cacũatapaʉre masĩgarã, ĩñarã ásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bairo ĩña yaparori bero, na caãni wiiripʉ tunucoásúparã. Topʉ etarã yua, caroaro cajʉtiñurĩjẽrẽ qũẽnoñuparã Jesús rupaʉri ãnajẽrẽ na capiopeopeere. Bairo áti yaparori bero, yerijãñuparã Moisés ãnacʉ̃ cʉ̃ caroticũrĩcãrõrẽã bairo. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cabero yua, judío majã na cayerijãrĩ rʉ̃mʉ bero, ape semanarẽ na capaajʉ̃gori rʉ̃mʉ ãñuparõ. Bairi ti rʉ̃mʉ caãno, ñamirõcãcã cajʉtiñurĩjẽ caqũẽnoatana rõmirĩ pʉame masã opepʉ ásúparã, cajutiñurĩjẽrẽ Jesús rupaʉri ãnajẽrẽ pioturáná. Aperã rõmirĩ cʉ̃ã na bapacʉti ásúparã na mena. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bairo ti masã opere etarã yua, ĩñajoyuparã. Ti opere na cabiaatatii, ʉ̃tã tii tupãworicaropʉ bauyuparo. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bairo cabairoi, ti opepʉ jããñuparã. Marĩ Quetiupaʉ rupaʉri ãnajẽ pʉame mañuparõ yua, na caĩñaata. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bairo cʉ̃ rupaʉri ãnajẽ camanoi yua, bʉtioro tʉ̃goñacõã maniásuparã. Dope bairo áti masĩẽsuparã. Bairo na baiãno, pʉgarã caʉ̃mʉa natʉ etanʉcãñuparã. Na pʉame jutii caasiriyarije cayowerijere jãñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bairi carõmia pʉame bʉtioro uwiri murĩcũmucoásúparã yepapʉ. Bairo na caáto, atore bairo na ĩñuparã caʉ̃mʉa pʉame: —¿Nopẽĩrã cariaricarã ãnanarẽ na cacũrõpʉ cacatirea mʉjãã macãñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús atore maniñami. Merẽ caticoayami. ¿Galileapʉ mʉjãã caãno, cʉ̃ cabaipeere mʉjããrẽ cʉ̃ caquetibʉjʉriquere mʉjãã masĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Atore bairo mʉjããrẽ ĩwĩ: ‘Yʉ, Camasã Jʉ̃gocʉre, carorije caánarẽ yʉ jorocagarãma, yʉre yucʉpãĩpʉ na capapuaturocaparore bairo ĩrã. Bairo yʉ na caátirocamiatacʉ̃ãrẽ, itia rʉ̃mʉ bero yʉ caticoagʉ tunu,’ mʉjãã ĩ quetibʉjʉwĩ —na ĩ quetibʉjʉyuparã ángelea majã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bairo na caĩrõpʉ, tʉ̃goña bócayuparã Jesús narẽ riagʉ jʉ̃goye cʉ̃ caĩrĩqũẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bairo tʉ̃goñabócari yua, macãpʉ tunucoásúparã. Topʉ etarã, Jesús cʉ̃ cabuerã, pʉga wãmo peti rʉpore jĩcã pẽnirõ cãnacãʉ̃ apóstolea caãnarẽ nipetirije na caĩñaatajere na quetibʉjʉyuparã. Aperã cʉ̃ãrẽ na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Narẽ caquetibʉjʉri majã rõmirĩ pʉame ãñuparã: María Magdalena, Juana, apeo María, Santiago paco, aperã carõmia cʉ̃ã ãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bairo na caĩrõ tʉ̃go, apóstolea majã pʉame cariape na tʉ̃goesuparã. “Bairo ĩcõãrã mʉjãã ĩña,” na ĩcõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bairo cariape na catʉ̃goetimiatacʉ̃ãrẽ, Pedro pʉame atʉátí ĩñaʉ ásúpʉ masã opere. Bairi topʉ jãátí ĩñañupʉ̃. Bairo cʉ̃ caĩñarõ, mañuparõ Jesús rupaʉri ãnajẽ. Jutii aseri Jesure na caũmamiataje jeto ãñuparõ. Bairi tie jeto caãno ĩña acʉari, cʉ̃ wiipʉ tunucoásúpʉ. Bʉtioro tʉ̃goñarĩqũẽ pairi tʉ̃goñamani ásúpʉ, tie cabaiatajere ĩñarĩ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti rʉ̃mʉ caãnoa pʉgarã Jesús cʉ̃ cabuemirĩcãrã pʉame Emaús na caĩrĩ macãpʉ áná baiyuparã. Pʉga wãmo peti rʉpore jĩcã pẽnirõ cãnacã kilómetros majũ yoaro átáto ãñuparõ Jerusalén macã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Topʉ áná, na pʉame Jesús cʉ̃ baiatajere bʉsʉpai ásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bairo na cabʉsʉtutuátó, Jesús pʉame na ẽmʉetari, na mena átutuásúpʉ cʉ̃ cʉ̃ã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bairo cʉ̃rẽ ĩñamirãcʉ̃ã, “Jesús niñami,” ĩ masĩẽsuparã mai. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bairi yua, Jesús pʉame na jẽniñañupʉ̃: —¿Ñe ũnie quetire mʉjãã bʉsʉpaiyati? ¿Nopẽĩrã mʉjãã tʉ̃goñarĩqũẽ paiyati? —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bairo cʉ̃ caĩjẽniñarõ tʉ̃go, jĩcãʉ̃ na mena macããcʉ̃ Cleofas cawãmecʉcʉ qũĩñupʉ̃: —¿Ati rʉ̃mʉrĩ Jerusalén macãpʉ cabaiatajere mʉ jetoa mʉ tʉ̃goetiyati? Nipetiro ati yepa macããna masĩrãma. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bairo na caĩrõ, Jesús pʉame bairo na ĩñupʉ̃: —¿Dope to baiati? —na ĩñupʉ̃. Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩñuparã: —¿Jesús, Nazaret macããcʉ̃ cʉ̃ cabaiatajere mʉ tʉ̃goetiyati? Cʉ̃ pʉame profeta ãmi. Capee caátijẽñomasĩ ãmi. Cʉ̃ caquetibʉjʉrije cʉ̃ã ñumajũcõãwʉ̃. Bairi Dios, camasã cʉ̃ã nipetiro cʉ̃ mena ʉseaninucũwã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bairo cʉ̃ cabaimiatacʉ̃ãrẽ, quetiuparã sacerdote majã, aperã marĩ quetiuparã mena, cʉ̃ ñerĩ cʉ̃ nuniwã romano majãrẽ, cʉ̃ na capajĩãrõrẽ borã. Bairo átiri, yucʉpãĩpʉ cʉ̃ papuatu rocarotiwã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jãã pʉame, ‘Cʉ̃ã, ati yepa, Israel yepare caẽmarĩ majãrẽ carocapaʉ majũ ãnigʉmi,’ jãã ĩ tʉ̃goñamiwʉ̃. Merẽ yua, itia rʉ̃mʉ netõcoaya, cʉ̃rẽ na capajĩã rocaatato bero. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bairãpʉa, jãã pʉame jãã tʉ̃goacʉacoapʉ, jãã mena macããna rõmirĩ jĩcããrã, ‘Catiupi,’ jããrẽ na caĩquetibʉjʉro jʉ̃gori. Na pʉame cʉ̃ rupaʉri ãnajẽrẽ ʉ̃tã opepʉ na cacũrĩcãrõpʉ cabusuripaʉaca ĩñaráupa. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Bairo topʉ etarã yua, Jesús rupaʉri ãnajẽ camanoi, jãã tʉpʉ quetibʉjʉrã etaama: ‘Ángelea majãrẽ jãã ĩñaapʉ̃, “Catiyami Jesús,” jãã ĩãma,’ jãã ĩ quetibʉjʉama. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bairo na caĩrõ tʉ̃gori jĩcããrã jãã mena macããna ĩñaráupa Jesús masã opepʉ. Topʉ na caetaro, nipetiro jããrẽ na caĩatatorea bairo baiuparo, na caĩñaata. Bairãpʉa, Jesús pʉamerẽ qũĩñaetiuparã —qũĩ quetibʉjʉyuparã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bairo na caĩquetibʉjʉro tʉ̃gori, atore bairo na ĩñupʉ̃ Jesús cʉ̃ cabuemirĩcãrãrẽ: —¡Rʉsamajũcõãña mai mʉjããrẽ mʉjãã catʉ̃gomasĩpetipee! Marĩ ñicʉ̃jãã na caĩwoatucũrĩqũẽ nipetirijere, ¿nocãrõpʉ cariapea mʉjãã tʉ̃gopeyorãati? ");
INSERT INTO cbcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mesías, Dios cʉ̃ cajoʉ, cʉ̃ pacʉtʉ cʉ̃ catunuápáro jʉ̃goye ati yepapʉ popiye cʉ̃ cabaipeere cʉ̃ cũẽsupari? ¿Bairo mee ato na quetibʉjʉyayupari profeta majã ãnana? —na ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bairo na ĩ yaparori bero, na quetibʉjʉ jʉ̃goyupʉ Jesús cõñarĩcãrõrẽ bairo. Bairi cʉ̃ cabaipeere Moisés ãnacʉ̃ cʉ̃ caquetibʉjʉwoatucũrĩqũẽpʉi quetibʉjʉ jʉ̃goacʉ́, profeta majã na caquetibʉjʉwoatucũrĩqũẽpʉ quetibʉjʉ jãnañupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bairi yua, Jesús cʉ̃ cabuemirĩcãrã na caátí macãpʉ na caetaro, Jesús pʉame netõácʉ́re bairo baiyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bairo cʉ̃ canetõámiatacʉ̃ãrẽ, cʉ̃ cabuemirĩcãrã pʉame bairo qũĩñuparã: —Netõápéina. Jãã mena ati ñamirẽ mʉ tuagʉ. Merẽ ñamicãpʉ niña. Naiorõpʉ baiya —qũĩñuparã. Bairo na caĩrõ tʉ̃go, wiipʉ jããñupʉ̃, na mena tuagʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cabero mesapʉ ʉgagarã na caruiro, Jesús pʉame pããrẽ neñupʉ̃. Nerĩ, Diore jẽniñupʉ̃. Jẽni yaparo, pããrẽ na peebato nuniñupʉ̃ cʉ̃ cabuemirĩcãrãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bairo cʉ̃ caátopʉ merẽ yua, “Jesús niñami,” ĩ masĩjʉ̃goyuparã. Bairo cʉ̃ na caĩñamasĩmiatacʉ̃ãrẽ, Jesús pʉame yasicoasupʉ. Tunu baunemoesupʉ cʉ̃ cabuemirĩcãrãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bairo cʉ̃ cabairo ĩñarĩ, atore bairo ãmeo ĩñuparã: —Dios cʉ̃ caquetibʉjʉcũrĩqũẽrẽ marĩrẽ cʉ̃ caquetibʉjʉro, ¿tie meerẽ áto marĩ yeri cʉtiupari? Marĩ yeri caroaro tʉ̃goñao joroque marĩ átiami, maapʉ marĩ caátó —ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bairo ĩrĩ bero, jicoquei tunucoásúparã Jerusalén macãpʉ, na yarãrẽ quetibʉjʉráná. Topʉ etarã, Jesús cʉ̃ cabuemirĩcãrã pʉga wãmo peti rʉpore jĩcã pẽnirõ cãnacãʉ̃ apóstolea majã neñarĩ caãnarẽ na etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bairo na etari, na ĩñuparã: —Cariapea marĩ Quetiupaʉ cariacoatacʉ nimicʉ̃ã, catiupi. Simón cʉ̃ã qũĩñaupĩ —na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na ĩ yaparo, maapʉ Jesús narẽ cʉ̃ cabuiaetaatajere na quetibʉjʉyuparã. Tunu bairoa Jesús pããrẽ narẽ cʉ̃ cabatoro cʉ̃rẽ na caĩñamasĩátaje cʉ̃ãrẽ na quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bairo mai tiere na caquetibʉjʉãnitoyea, Jesús pʉame na recomacãpʉ buiaetayupʉ. Buiaetari atore bairo ĩ jẽniñupʉ̃: —Caroa yericʉtaje mʉjããrẽ cʉ̃ joáto Dios. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jesús cʉ̃ cabuemirĩcãrã pʉame qũĩña acʉacoasuparã. Cʉ̃ uwijãñuñuparã, “Jesús wãtĩ ãcʉ̃mi,” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bairo na cauwiro ĩñarĩ, atore bairo na ĩñupʉ̃: —¿Nopẽĩrã yʉre mʉjãã ĩñaacʉayati? ¿Nopẽĩrã, “Jesús mee niñami,” mʉjãã ĩ tʉ̃goñañati mai? ");
INSERT INTO cbcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ĩñañijate yʉ wãmorĩrẽ, bairi yʉ rʉpoori cʉ̃ãrẽ. Yʉa, Jesús yʉ ãniña. Pãñarĩ ñiñañijate. Espíritu yʉ caãmata, õwãã mani, rupaʉ mani, yʉ baibujioʉ. Cʉ̃ mee ãnirĩna, õwãã cʉti, rupaʉ cʉti yʉ baiya. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bairo na ĩna, na ĩñoñupʉ̃ Jesús cʉ̃ rʉpori, cʉ̃ wãmoorĩ cʉ̃ãrẽ, cʉ̃ na capapuaata opeere. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bairo na cʉ̃ caĩñomiatacʉ̃ãrẽ, cʉ̃ cabuemirĩcãrã pʉame cariapea tʉ̃goesuparã mai. Cʉ̃ caĩrĩjẽrẽ ʉseanirõ tʉ̃gomirãcʉ̃ã, tʉ̃go mawijiacõãñuparã. Bairo na cabairo ĩñarĩ, atore bairo na ĩ jẽniñañupʉ̃: —¿Ʉgarique ũnie atore mʉjãã cʉ̃goetiyati? ");
INSERT INTO cbcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bairo cʉ̃ caĩrõ yua, wai pʉ̃õrĩcʉ̃rẽ cʉ̃ nuniñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na canunirõ yua, nerĩ, petiro cʉ̃ cabuemirĩcãrã na caĩñarõ ʉgayupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ʉga yaparori bero, na ĩnemoñupʉ̃ tunu: —Yʉre cabaiataje atore bairo mʉjãã mena ãcʉ̃, yʉ caĩrĩqũẽ baiapʉ: “Nipetiro yʉre bairo baigʉmi Moisés ãnacʉ̃ cʉ̃ caroticũñarĩqũẽ, bairi profeta yaye cʉ̃ã, bairi salmos tutiri macããjẽ cʉ̃ã nipetiro bairo baipeticoagaro yʉre na caĩquetibʉjʉ woatucũñarĩqũẽ,” mʉjããrẽ ñiwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bairo cʉ̃ caĩrõpʉ, tʉ̃goña bócayuparã Dios ya tutipʉ na caquetibʉjʉcũñarĩqũẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bairo na cabairoi, atore bairo na ĩñupʉ̃ Jesús: —Atore bairo ĩ quetibʉjʉyupa mai: “Dios cʉ̃ cajoʉre roro cʉ̃ átiyasiogarãma. Bairo na caátimiatacʉ̃ãrẽ, itia rʉ̃mʉ bero tunu catigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bairi cʉ̃ cacatiro bero, cʉ̃ yarã pʉame cʉ̃ yaye quetire quetibʉjʉ batopeticõãgarãma nipetiro ati yepa macããnarẽ. Jerusalén macãĩ cʉ̃ yaye quetire quetibʉjʉ jʉ̃gogarãma. ‘Roro mʉjãã caátiere bʉsʉqũẽnoña mʉjãã yerire Dios mena, mʉjããrẽ cʉ̃ canetõõparore bairo ĩrã,’ na ĩ quetibʉjʉgarãma,” ĩ woatu quetibʉjʉyupa profeta majã. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mʉjãã merẽ atiere caquetibʉjʉmasĩrã mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bairi mʉjãã yeripʉ yʉ jogʉ yeri tutuariquere, yʉ Pacʉ cʉ̃ caĩrĩcãrõrẽã bairo. Bairi mai, ati macã, Jerusalén macãpʉa mʉjãã ãnicõãwã, yeri tutuarique jõbui ʉmʉrecóo macããjẽ caatíparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cabero Jesús na jʉ̃goásúpʉ macã camanopʉ. Betaniapʉ na jʉ̃goásúpʉ. Topʉ etari, Jesús pʉame cʉ̃ wãmorĩrẽ ñumʉgõrĩ, Diore na jẽnibojayupʉ: “Caroare cʉ̃ jonemoáto mʉjããrẽ marĩ Pacʉ Dios,” na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bairo ĩãcʉ̃na, na wʉweyori, ʉmʉrecóo pʉamerẽ wãmʉcoásúpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bairo cʉ̃rẽ qũĩroari bero, tunucoásúparã Jerusalén macãpʉ ʉseanirĩqũẽ mena yua. ");
INSERT INTO cbcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jesús cʉ̃ cabuericarã pʉame templo wiipʉ tocãnacã rʉ̃mʉa ánucũñuparã, Diore cʉ̃ basapeoráná. Tocãrõã ñiña.");
INSERT INTO cbcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tirʉ̃mʉpʉ ati yepa caãniparo jʉ̃goyepʉa merẽ ãnicõã jʉ̃goyupi Cristo, Dios macʉ̃, Dios Yaye Quetire Caquetibʉjʉ Majũ cawãmecʉcʉ. Cʉ̃ pʉame merẽ Dios mena ãnicõãñupĩ. Cʉ̃ cʉ̃ã Dios ãñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Caãni jʉ̃goripaʉpʉa cʉ̃ cʉ̃ã merẽ Dios mena ãnicõãñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dios, cʉ̃ macʉ̃ jʉ̃gori nipetirijere ásupi. Ati yepapʉre caãnie nipetirije cʉ̃ jʉ̃gori cʉ̃ caátaje jeto niña. Dise ũnie cʉ̃ jʉ̃gori mee cʉ̃ caátaje manimajũcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yeri capetietiere cajopaʉ majũ niñami Dios macʉ̃. Bairo caãcʉ̃ ãnirĩ ati yepa macããnarẽ na cajĩñawoʉre bairo niñami. Cʉ̃ caquetibʉjʉrique jʉ̃gori camasã, tiere catʉ̃goʉsarã pʉame caroaro ãnimasĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bairo Dios macʉ̃ cajĩñawoʉre bairo caãcʉ̃ pʉame carorã canaitĩãrõpʉre bairo caãnarẽ na jĩñawo etaʉ baiyami. Cʉ̃ caquetibʉjʉrijere cateerã canaitĩãrõpʉ caãnarẽ bairo caãna pʉame cʉ̃ bʉsʉnetõ masĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ãmi jĩcãʉ̃ camasocʉ Juan cawãmecʉcʉ. Cʉ̃ pʉame Dios cʉ̃ caquetibʉjʉrotijoricʉ ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dios macʉ̃, ati yepa macããnarẽ cajĩñawoʉre bairo caãcʉ̃ majũ cʉ̃ caatípeere caquetibʉjʉ jʉ̃goyetipaʉ ãmi Juan. Dios macʉ̃ cʉ̃ caquetibʉjʉpeere camasã cariape na tʉ̃goʉsaáto ĩ, Dios cʉ̃ caquetibʉjʉjʉ̃goyetirotijoricʉ ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Baipʉa Juan, ti yepa macããnarẽ cajĩñawoʉre bairo caãcʉ̃ mee ãmi. Dios pʉame cʉ̃ macʉ̃ cajĩñawoʉre bairo caãcʉ̃ cʉ̃ caatípeere cʉ̃ caquetibʉjʉrotijoricʉ ãmi Juan. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bairi Dios macʉ̃, caroaro cariape caãcʉ̃, cajĩñawoʉre bairo caãcʉ̃ majũ, ati yepa macããna nipetirore Dios yaye quetire quetibʉjʉacʉ́ asúpi. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bairi, Dios Yaye Quetire Caquetibʉjʉ Majũ cawãmecʉcʉ ati yepapʉre etayupi. Dios mena ati yepare caátacʉ cʉ̃ caãnimiatacʉ̃ãrẽ, ati yepa macããna pʉame, “Cʉ̃ã niñami Dios macʉ̃,” cʉ̃rẽ ĩ masĩẽma. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cʉ̃ caáta yepa macããna tʉpʉ etayupi. Bairo natʉ cʉ̃ caetamiatacʉ̃ãrẽ, na pʉame jĩcã nʉgõã cʉ̃ boema. Cʉ̃ yarã cʉ̃ boema. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bairo aperã cʉ̃ boeti, jĩcããrã pʉame cʉ̃ bojãñuñupã. Na pʉamerẽ caroa wãme na ãnirotiwĩ. Dios pũnaa majũ na ãnirotiwĩ, cʉ̃ mena catʉ̃goñatutuarã pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Camasã pũnaa cʉtajere bairo ãmerĩñama. Camasã na caátaje mena na caborije mena pũnaa cʉtiyama. Dios pũnaa pʉame roque cʉ̃ camasĩrĩjẽ jʉ̃gori cʉ̃ pũnaa caãna niñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bairi, Dios Yaye Quetire Caquetibʉjʉ Majũ cawãmecʉcʉ ati yepapʉ buia etayupi. Marĩrẽã bairo ati rupaʉ cacʉ̃goʉ buiaetari, marĩ camasã mena ãmi. Bairo marĩ mena ãni yua, bʉtioro marĩ maiwĩ. Tunu bairoa cariape jeto quetibʉjʉnucũwĩ. Jãã pʉame cʉ̃ caasiyarijere jãã ĩñawʉ̃. Dios macʉ̃ majũ cʉ̃ caãnoi, cʉ̃ pacʉ cʉ̃rẽ cʉ̃ cajorije caasiyarijere jãã ĩñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Bautista pʉame Dios macʉ̃ yaye quetire quetibʉjʉ, atore bairo ĩwĩ: “Ãni niñami mʉjããrẽ yʉ caquetibʉjʉjʉ̃goyetiricʉ: ‘Yʉ bero caetaʉ yʉ jʉ̃goye caãnacʉ̃ ãñupĩ. Bairo cʉ̃ cabairoi, cʉ̃ paarique pʉame, yʉ paarique netõjãñurõ caãnimajũrĩjẽ niña.’” ");
INSERT INTO cbcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dios pʉame capee caátimasĩ ãnirĩ ape wãme, ape wãme caroare cʉ̃ cajorije marĩ nipetirãrẽ marĩ jonucũwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés ãnacʉ̃ pʉame cʉ̃ carotiriquere cũñupĩ marĩ ñicʉ̃jãã ãnana mena. Jesucristo pʉame roque marĩrẽ ĩñamairĩ, marĩtʉ etawĩ, caroaro cariape átiãnajẽrẽ marĩ ĩñogʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni pʉame Diore caĩñarĩcʉ̃ mácʉ̃mi. Bairo cʉ̃ cabaimiatacʉ̃ãrẽ, Dios macʉ̃ jĩcãʉ̃ã caroaro cʉ̃ mena ãninucũñupĩ. Cʉ̃ pʉame cʉ̃ pacʉre marĩ masĩõ joroque marĩ átiyami. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bairi Jerusalén macã macããna judío majã quetiuparã pʉame Juan Bautista tʉpʉ na joyuparã sacerdote majãrẽ, bairi levita majã cʉ̃ãrẽ. “¿Ñamʉ majũ mʉ ãniñati?” Juarẽ qũĩ jẽniñarotirã, cʉ̃tʉ na joyupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan pʉame cariapea bairo na ĩ quetibʉjʉwĩ: —Yʉa, Mesías, Dios cʉ̃ cajoʉ mee yʉ ãniña —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tunu cabero qũĩ jẽniñanemowã: —Toroque, ¿ñamʉ majũ mʉ ãniñati? ¿Tirʉ̃mʉpʉ macããcʉ̃ profeta Elías cawãmecʉcʉ ãnacʉ̃ tunu catitunurĩ mee mʉ ãniñati? —qũĩ jẽniñawã. Juan pʉame: —Cʉ̃ mee yʉ ãniña —na ĩwĩ. Bairo cʉ̃ caĩrõ tʉ̃gori, qũĩ jẽniñanemowã tunu: —Toroquere, ¿ñamʉ majũ mʉ ãniñati? “¿Jĩcãʉ̃ profeta Dios cʉ̃ cajopaʉ atígʉmi ati yepapʉre,” marĩ ñicʉ̃jãã ãnana na caĩquetibʉjʉjʉ̃goyetiricʉ mee mʉ ãniñati? —qũĩwã Juarẽ. Bairo na caĩjẽniñarõ, Juan pʉame: —Cʉ̃ mee yʉ ãniña —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩ jẽniñanemowã tunu: —Toroquere, ¿ñamʉ majũ mʉ ãniñati? Jããrẽ cariapea quetibʉjʉya, jããrẽ cajoatanarẽ cariapea na jãã caquetibʉjʉnetõmasĩparore bairo. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","24","Bairo na caĩrõ, atore bairo na ĩwĩ Juan: —Yʉa, Isaías ãnacʉ̃ cʉ̃ cawoatu jʉ̃goyecʉtacʉ yʉ ãniña. Atore bairo ĩ woatu quetibʉjʉyayupi: “Bairo ĩgʉmi desierto cayucʉmanopʉ caãnicõãniatacʉ: ‘Marĩ Quetiupaʉ yoaro mee etagʉmi. Torecʉ, caroaro cariape ãnicoteya. Camasã na quetiupaʉ cʉ̃ caetaparo jʉ̃goye cʉ̃ caatípawãrẽ na caqũẽnoyurorea bairo mʉjãã cʉ̃ã caroaro áticoteya,’ ĩ woatu quetibʉjʉ jʉ̃goyetiyayupi Isaías ãnacʉ̃ yʉ caquetibʉjʉpeere,” na ĩwĩ Juan, cʉ̃rẽ Jerusalén macããna fariseo majã na cajẽniñarotijoatanarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tunu atore bairo qũĩ jẽniña nemowã: —Toroquere ñerẽ ácʉ, Mesías Dios cʉ̃ cajoʉ ãmerĩmicʉ̃ã, Elías ãnacʉ̃ ãmerĩmicʉ̃ã, profeta ãmerĩmicʉ̃ã, ¿nopẽĩ camasãrẽ na mʉ bautiza nucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Bairo na caĩrõ tʉ̃goʉ, atore bairo na ĩ quetibʉjʉwĩ Juan: —Yʉ paarique niña camasãrẽ oco mena yʉ cabautizarije. Yʉ bero caetaʉ, mʉjãã watoa caãcʉ̃, mʉjãã camasĩẽcʉ̃ paarique pʉame roque, yʉ paarique to cañumiatacʉ̃ãrẽ, ñunetõgaro. Cʉ̃ roque yʉ netõrõ caãnimajũʉ̃ niñami. Bairi yʉ pʉame jĩcãrõ tʉ̃ni yʉ átipeyo masĩẽtĩña —na ĩ quetibʉjʉwĩ Juan. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bairo bairi atie nipetiro baiwʉ Betania cawãmecʉti macãpʉ. Ti macã pʉame Rio Jordán ape nʉgõã muipʉ cʉ̃ cawãmʉatí nʉgõãpʉ ãmʉ Juan cʉ̃ cabautizaricaro pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ti rʉ̃mʉ busuri rʉ̃mʉ caãno cʉ̃ tʉpʉ Jesús cʉ̃ caetarore qũĩñawĩ Juan. Bairo qũĩña yua, atore bairo jãã ĩwĩ cʉ̃tʉ caãnarẽ: “¡Qũĩñaña cʉ̃rẽ! Ãnia niñami Cordero oveja macʉ̃rẽ bairo Dios cʉ̃ cacũrĩcʉ̃ cawãmecʉcʉ. Oveja na canuʉ cawĩmaʉ Diopʉre na cajoemʉgõjonucũrĩcʉ̃rẽ bairo caãcʉ̃ niñami. Cʉ̃ã, cʉ̃ cariápee jʉ̃gori ati ʉmʉrecóo macããna nipetiro roro na caátiere camasiriyobojapaʉ majũ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ãni niñami mʉjããrẽ yʉ caquetibʉjʉjʉ̃goyetiricʉ: ‘Yʉ bero caetaʉ yʉ jʉ̃goye caãnacʉ̃ ãñupĩ. Bairo cʉ̃ cabairoi, cʉ̃ capaarije yʉ paarique netõjãñurõ caãnimajũrĩjẽ nigaro.’ ");
INSERT INTO cbcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉ cʉ̃ã, ‘Cʉ̃ã niñami Dios macʉ̃,’ ñi masĩẽpʉ̃ mai. Bairo ĩ masĩẽtĩmicʉ̃ã, Israel yepa macããna cʉ̃rẽ na camasĩparore bairo ĩ, oco mena na yʉ bautizaʉ atíapʉ,” jãã ĩwĩ Juan, jãã, cʉ̃tʉ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ĩ yaparo, atore bairo jãã ĩnemowĩ tunu: “Espíritu Santo, Dios Yeri majũ ʉmʉrecóo caacʉ́ pʉame buare bairo bau ruiatíri, ãni Jesús buipʉ etapeami. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yʉa, mai cʉ̃ yʉ masĩẽpʉ̃. Bairo yʉ camasĩẽtĩmiatacʉ̃ãrẽ, Dios oco mena yʉre cabautiza rotijoricʉ pʉame atore bairo ñiwĩ: ‘Jĩcãʉ̃ caʉ̃mʉrẽ miñagʉ yʉ Yeri Espíritu Santo baurui etari cʉ̃ buipʉ caetapeaecoʉre. Cʉ̃ã nigʉmi camasã yeripʉ Espíritu Santore cajomasĩ,’ ñi quetibʉjʉwĩ Dios. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bairo Dios yʉre cʉ̃ caĩquetibʉjʉricarore bairoa ñiñaña ãmerẽ. Bairo caĩñaʉ ãnirĩ mʉjããrẽ cariape ñiña: Cʉ̃ã niñami Dios macʉ̃,” jãã ĩ quetibʉjʉwĩ Juan, jãã, cʉ̃tʉ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti rʉ̃mʉ cabusuri rʉ̃mʉ caãno, ãmi Juan tunu cʉ̃ cabautiza ãninucũrõpʉ. Jãã, pʉgarã Juan cʉ̃ cabuerã cʉ̃ã jãã ãmʉ cʉ̃ mena. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bairi cʉ̃ mena jãã caãno, Jesús jããrẽ cʉ̃ canetõátó ĩñarĩ, atore bairo jãã ĩwĩ Juan: —¡Ãnirẽ qũĩñaña! Ãnia niñami Cordero oveja macʉ̃rẽ bairo Dios cʉ̃ cacũrĩcʉ̃ cawãmecʉcʉ —jãã ĩwĩ Juan Bautista. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bairo cʉ̃ caĩrõ tʉ̃gorã, Juarẽ cʉ̃ jãã aweyocoápʉ́. Jesús berore jãã ʉsacoápʉ́, jãã pʉgarã, Juan cʉ̃ cabuemiatana pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bairo jãã caʉsaro, Jesús pʉame jãã ãmejorenʉcã ĩña, atore bairo jãã ĩwĩ: —¿Ñerẽ borã, yʉre mʉjãã ʉsayati? Bairo cʉ̃ caĩrõ: —Rabuni, ¿noopʉ mʉ caãnipaʉ to ãniñati? —cʉ̃rẽ jãã ĩ jẽniñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bairo jãã caĩjẽniñarõ tʉ̃goʉ, atore bairo jãã ĩwĩ Jesús: —Tiaya yʉ mena. Yʉ bapa cʉtirásá. Bairo cʉ̃ caĩrõ tʉ̃go, cʉ̃ mena jãã acoápʉ́. Bairo cʉ̃ caãnipaʉre etarã, cʉ̃ mena jãã ãnicõã naioapʉ̃, merẽ ñamicããcãpʉ caãno jʉ̃gori yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mai, yʉ mena macããcʉ̃ yʉre bairo Juan mena caãnimirĩcʉ̃ cabero Jesús yaye quetire catʉ̃goʉsaʉ Andrés pʉame Simón Pedro bai ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bairi cʉ̃ pʉame jicoquei cʉ̃ jʉ̃gocʉ Simorẽ cʉ̃ macãʉ̃ ácʉ́ baiwĩ. Bairo cʉ̃ bócaʉ yua, atore bairo qũĩñupĩ: —Mesías cawãmecʉcʉre jãã bócaapʉ. (Mai, Mesías, atore bairo ĩgaro ĩña: “Cristo, Dios cʉ̃ cabesericʉ ati yepapʉre cʉ̃ cajoricʉ,” ĩgaro ĩña.) ");
INSERT INTO cbcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Cabero Andrés pʉame cʉ̃ jʉ̃gocʉ Simorẽ cʉ̃ piietawĩ Jesús tʉpʉ. Bairi Jesús, Simorẽ qũĩñarĩ, atore bairo qũĩwĩ: —Simón mʉ ãniña Juan macʉ̃. Ãmerẽ Cefas mʉ wãmecʉtigʉ. (Mai, Cefas pʉame, “Pedro” ĩgaro ĩña.) ");
INSERT INTO cbcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti rʉ̃mʉ cabusuri rʉ̃mʉ caãno, Jesús pʉame, “Galilea yepapʉ yʉ ágʉ,” ĩ tʉ̃goñawĩ. Bairo topʉ ácʉ́, Felipe cawãmecʉcʉre cʉ̃ bocaetari atore bairo qũĩwĩ: —Jito. Yʉ mʉ bapacʉtiroapa. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Mai, cʉ̃, Felipe pʉame Betsaida cawãmecʉti macã macããcʉ̃ ãmi. Pedro, cʉ̃ bai Andrés mena ti macã macããna ãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Bairi Felipe pʉame Natanaere cʉ̃ piiámí. Bairo cʉ̃ tʉpʉ etaʉ, atore bairo qũĩñupĩ: —Dios yaye quetibʉjʉrica tutipʉ Moisés ãnacʉ̃, bairi profeta majã ãnana na cawoatujʉ̃goyeticũrĩcʉ̃rẽ jãã bócaapʉ. Cʉ̃ã, Jesús cawãmecʉcʉ, José macʉ̃, Nazaret macã macããcʉ̃ niñami —qũĩñupĩ Felipe. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Bairo cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩñupĩ Natanael Felipere: —¿Mʉ catʉ̃goñaata, Nazarepʉre jĩcãʉ̃ ũcʉ̃ cañuʉ cʉ̃ ãnicʉti? Felipe pʉame Natanaere bairo qũĩñupĩ: —Jito yʉ mena. Topʉ mʉ tʉ̃goñabesegʉ —qũĩñupĩ Felipe Natanaere. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bairo cabero Jesús Natanael cʉ̃ caetaro ĩñaʉ, atore bairo qũĩwĩ cʉ̃tʉ caãnarẽ: —Merẽ atíyami Israel macããcʉ̃ majũ jĩcãrõ tʉ̃ni caĩbʉsʉnucũʉ̃ —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Bairo Jesús cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩ jẽniñawĩ Natanael Jesure: —¿Dope bairi yʉ mʉ masĩñati? Jesús pʉame bairo qũĩwĩ: —Mʉ ñiñawʉ̃ Felipe mʉrẽ cʉ̃ capiiparo jʉ̃goye, higuera cawãmecʉtii roca mʉ caãno. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Bairo cʉ̃ caĩrõ tʉ̃goʉ, Natanael pʉame qũĩwĩ: —Cabuei, ¡Dios macʉ̃ mʉ ãniña, ati yepa Israel macããna quetiupaʉ Rey majũ mʉ ãniña! ");
INSERT INTO cbcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩnemowĩ Jesús Natanaere: —¿“Higuera yucʉ rocapʉ mʉ ñiñawʉ̃,” yʉ caĩrĩjẽrẽ tʉ̃gori, “Dios macʉ̃ã niñami,” yʉre mi nʉcʉ̃bʉgoyati? Cabero yʉ caátimasĩrĩjẽ netõjãñurõ caroa macããjẽrẽ miñagʉ —qũĩwĩ Jesús Natanaere. ");
INSERT INTO cbcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bairo qũĩ yaparoʉ, atore bairo na ĩnemowĩ Jesús cʉ̃tʉ caãnarẽ: —Cariapea mʉjããrẽ ñiña: Cabero ʉmʉrecóo capãnʉcãrõ mʉjãã ĩñagarã. Bairo capãnʉcãrõ ĩñarã, Diotʉ macããna ángelea majã yʉ, Camasã Jʉ̃gocʉ buipʉre ruiatí, bairi tunu wãmʉá na cabairo cʉ̃ãrẽ mʉjãã ĩñajogarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cabero itia rʉ̃mʉ bero caãno Galilea yepapʉ Caná cawãmecʉti macãpʉ to macããna na cawãmo jiyari bose rʉ̃mʉ qũẽnowã. Jesús paco cʉ̃ã topʉ ãmo. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bairi Jesús, jãã, cʉ̃ cabuerã cʉ̃ã, na capiijoatana ãnirĩ, topʉ jãã ãmʉ, ti bose rʉ̃mʉ caãnorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bairo bose rʉ̃mʉ na caáto, na caetirije ʉse oco peticoapʉ. Bairo capetiro ĩñarĩ, cʉ̃ paco pʉame atore bairo qũĩwõ Jesure: —Macʉ̃, etirique ʉse oco peticoaya. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Bairo cõ caĩrõ tʉ̃goʉ, atore bairo cõ ĩwĩ Jesús cʉ̃ pacore: —¿Caaco, dopẽĩõ bairo yʉ miñati? Dios cʉ̃ catutuarije camasãrẽ yʉ caáti ĩñoparo etaetiya mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, cʉ̃ paco pʉame ti wii macããna caʉse oco tĩã coterãrẽ atore bairo na ĩwõ: —Mʉjããrẽ cʉ̃ caátirotiri wãme cãrõ cʉ̃ mʉjãã áti ʉsawa. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mai, topʉ ãmʉ jĩcã wãmo peti jĩcã pẽnirõ cãnacã jotʉri, ʉ̃tã jotʉri. Capaca rʉri nocãrõ cincuenta, o setenta litro majũ caoco jeri rʉri ãmʉ tocãnacãrʉpʉa. Judío majã caroarã nigarã Dios cʉ̃ caĩñajoro, tirʉ macããjẽ oco mena na causanucũrĩrʉri ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Bairo cabairo yua, Jesús pʉame atore bairo na ĩwĩ ti wii macããna catĩã coterãrẽ: —Atie jotʉʉre oco mena pio jiroya. Bairo cʉ̃ caĩrõ tʉ̃gorã, cʉ̃ caĩrõrẽ bairo áma. Caroaro piojirocõãwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bairo na caáti yaparoro ĩñaʉ, atore bairo na ĩwĩ tunu: —Bairi yua, bose rʉ̃mʉ cajʉ̃goácʉ tʉpʉ jeánája petoaca tirʉ macããjẽrẽ, cʉ̃ etiñaáto —na ĩwĩ Jesús. Na pʉame, “jaʉ,” ĩrãna, cʉ̃ caĩrõrẽ bairo petoaca cʉ̃ jeámá bose rʉ̃mʉ cajʉ̃goácʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bairo bose rʉ̃mʉ cajʉ̃goácʉ pʉame tiere etiñañupʉ̃. Merẽ, tie oco pʉame ʉse oco majũ jẽñacoasupa. Mai, “Jesús cʉ̃ caátiataje niña,” ĩ masĩẽsupi. Catĩã coteri majã jeto masĩwã, na majũã ocore capiojãatana ãnirĩ. Bairi bose rʉ̃mʉ cajʉ̃goácʉ pʉame cawãmojiyaatacʉre cʉ̃ piijoyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Atore bairo qũĩñupʉ̃: —Camasã nipetiro bose rʉ̃mʉ caãno nipetirore ʉse oco caroa pʉamerẽ na tĩã jʉ̃gonucũñama. Cabero na capiijoatana pairo na caetituaro bero roque, ʉse oco cabʉgoro macããjẽ ũnierẽ na tĩãnucũñama. Mʉ pʉame ʉse oco caroa pʉamerẽ mʉ rʉgaupa, tame —qũĩñupʉ̃ ti bose rʉ̃mʉ cajʉ̃goácʉ cawãmo jiyatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Bairo bairi ato Galilea yepapʉ Caná cawãmecʉti macãpʉ atie Jesús cʉ̃ caáti ĩñorĩqũẽ pʉame cʉ̃ cawãma átijẽño ĩñoo jʉ̃gorique majũ ãmʉ. Bairo ácʉ, camasãrẽ na ĩñowĩ nocãrõ cʉ̃ catutuarijere. Bairo cʉ̃ caáti ĩñorõ, jãã, cʉ̃ cabuerã cʉ̃ã caroaro cariape cʉ̃ jãã tʉ̃gojʉ̃gowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tipaʉ bero ámí Jesús Capernaum cawãmecʉti macãpʉ. Cʉ̃ mena ámá cʉ̃ paco, bairi cʉ̃ bairã cʉ̃ã. Jãã, cʉ̃ cabuerã cʉ̃ã cʉ̃ mena jãã ápʉ́. Bairi ti macãpʉre nocãnacã rʉ̃mʉ mea jãã ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jãã, judío majã bose rʉ̃mʉ Pascua jãã caĩrĩ rʉ̃mʉ caetagaro caãno, Jerusalén macãpʉ ámí Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bairo topʉ etaʉ, templo capairi wii ñubuerica wiipʉ jãámí. Ti wiire jããetari, to macããna wecʉare, ovejare, buare nunirĩ cawapatari majãrẽ na ĩñawĩ. Tunu bairoa aperã moneda tiirire cawasoari majã na caruiropʉ caãna cʉ̃ãrẽ na ĩñawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bairo na caáto ĩñaʉ, bapericawẽẽ qũẽnowĩ Jesús yʉta wẽẽrĩ mena. Bairo tiwẽẽ mena waibʉtoare nunirĩ cawapatarãrẽ na bape acurewiyojowĩ ti wii pupea caãniatanarẽ. Na ovejare, na wecʉa cʉ̃ãrẽ na acurewiyojowĩ. Moneda tiirire cawasoari majã yaye dinero tiirire mabato recõãwĩ. Na mesarire tujerecũ peyocõãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bairo átiri, atore bairo na ĩwĩ buare canuni wapatarãrẽ: —¡Mʉjãã cawapatarijere jeánája! Yʉ Pacʉ ya wiire apeye nunirĩcã wiire bairo ápericõãña —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bairo cʉ̃ caáto ĩñarĩ, jãã, cʉ̃ cabuerã pʉame Dios yaye quetibʉjʉrique na cawoatucũrĩqũẽrẽ jãã tʉ̃goña bócawʉ. Atore bairo ĩ quetibʉjʉ jʉ̃goyeticũñañupã Jesús cʉ̃ caátipeere mai: “Caacʉ, mʉ ya wiire bʉtioro yʉ qũẽnogʉ, aperã ti wiire roro na ápericõãto ĩ.” ");
INSERT INTO cbcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bairo cʉ̃ caáto ĩñarĩ, judío majã quetiuparã pʉame atore bairo qũĩ jẽniñawã Jesure: —“Cariape Dios cʉ̃ carotiro mena jʉ̃gori nunirĩ majãrẽ na acurewiyojoʉmi Jesús,” jãã caĩmasĩparore bairo ĩ, ¿di wãme átijẽñorĩqũẽrẽ jããrẽ miñoʉati? —qũĩ jẽniñawã Jesure judío majã quetiuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Bairo na caĩrõ tʉ̃goʉ, atore bairo na ĩwĩ Jesús: —Ati wiire rocacõãña. Bairo mʉjãã carocamiatacʉ̃ãrẽ, itia rʉ̃mʉ bero yʉ pʉame yʉ qũẽno yerijãgʉ tunu —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bairo cʉ̃ caĩrõ tʉ̃gorã, judío majã quetiuparã pʉame bairo qũĩwã tunu: —Marĩ ñicʉ̃jãã ãnana ati wiire yoaro majũ qũẽnoñupã cuarenta y seis cʉ̃marĩ majũ. ¿Mʉ pʉame ñerẽ ácʉ, itia rʉ̃mʉ beroa mʉ qũẽnocũʉ̃ áti? —qũĩwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mai, Jesús ti wiire ĩ, cʉ̃ majũã cʉ̃ rupaʉ pʉamerẽ ĩ quetibʉjʉ masĩõgʉ ĩmiwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bairo Jesús na capajĩã rocaricʉ nimicʉ̃ã, itia rʉ̃mʉ bero nemo cacatii cʉ̃ caãno, jãã, cʉ̃ cabuerã pʉame tie cʉ̃ caĩrĩqũẽrẽ jãã tʉ̃goñabócawʉ. Bairo tʉ̃goñabócarã yua, Dios yaye cʉ̃ caquetibʉjʉcũrĩqũẽrẽ cariapea jãã tʉ̃gowʉ. Jesús yaye cʉ̃ãrẽ cariapea jãã tʉ̃gowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bairo capããrã camasã Jerusalẽpʉ Pascua bose rʉ̃mʉ caãno caneña etaatána pʉame Jesús cʉ̃ caáti ĩñorĩjẽrẽ ĩñarã, “Dios cʉ̃ cajoricʉ niñami,” qũĩ tʉ̃goñaroawã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bairo na catʉ̃goñamiatacʉ̃ãrẽ, na mena tʉ̃goña ʉseaniemi Jesús. Cʉ̃ pʉame camasã nipetirore na yeripʉ na catʉ̃goñarĩjẽrẽ tʉ̃goñamasĩ peyocõãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Camasã na caátiãnierẽ aperã cʉ̃rẽ na caquetibʉjʉro boemi Jesús. Cʉ̃ pʉame camasã nipetiro na yeripʉ na catʉ̃goñarĩjẽrẽ tʉ̃goñamasĩ peyocõãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jĩcãʉ̃ ãmi fariseo majã mena macããcʉ̃ Nicodemo cawãmecʉcʉ. Cʉ̃ pʉame judío majã quetiuparã mena macããcʉ̃ jĩcãʉ̃ caãnimajũʉ̃ ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Torecʉ, cʉ̃ pʉame jĩcã ñami caãno Jesure cʉ̃ jẽniñagʉ, cʉ̃ tʉpʉ ásúpʉ. Bairo cʉ̃tʉ etari, atore bairo qũĩñupʉ̃ Nicodemo Jesure: —Ni jĩcãʉ̃ ũcʉ̃ mena Dios cʉ̃ camanicõãta, ape wãme cʉ̃ caátijẽñorĩjẽ manibujioro. Bairo mʉ caátijẽñorĩjẽrẽ ĩñarã, “Jesús mena niñami Dios,” jãã ĩ tʉ̃goñamasĩcõãña. Tunu bairoa, “Camasãrẽ cʉ̃ quetibʉjʉáto ĩ, mʉrẽ joʉ ásupi Dios,” jãã ĩ masĩña —qũĩñupʉ̃ Nicodemo Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Bairo cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩñupʉ̃ Jesús: —Cariape mʉrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ pʉame tunu cʉ̃ cabuia nemoeticõãta, Dios cʉ̃ carotimasĩrĩpaʉre eta masĩẽtĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bairo cʉ̃ caĩrõ tʉ̃gori, Nicodemo pʉame qũĩ jẽniñañupʉ̃ Jesure: —¿Cabʉcʉ marĩ caãno beropʉ marĩã ñerẽ ána pʉgani cãrõ marĩ paco paropʉ tunu marĩ bʉtijã buiamasĩbujiocʉti? ");
INSERT INTO cbcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús pʉame bairo qũĩñupʉ̃: —Cariapea mʉrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ oco mena, bairi Espíritu Santo mena cʉ̃ã cʉ̃ cabuianemoeticõãta, Dios cʉ̃ carotimasĩrĩpaʉre etamasĩẽtĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Camasã na capũnaacʉna, camasã pũnaa majũ niñama. Dios pũnaa roque Espíritu Santo cʉ̃ catutuarije jʉ̃gori cʉ̃ pũnaa majũ niñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bairi, “Camasã na cawãma buia jʉ̃goricarore bairoa na cabuianemopee boya,” mʉ yʉ caĩquetibʉjʉrijere tʉ̃gomawijiaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wĩno pʉame noo caboropʉ papuya. Bairo tie cabʉsʉro tʉ̃gomasĩmirãcʉ̃ã, noopʉ caatíere, o noo caátíere marĩ masĩẽtĩña. Ĩñarĩqũẽ mee niña wĩno. Torea bairo niñama nipetiro camasã Espíritu Santo jʉ̃gori cabuianucũrã cʉ̃ã. Narẽ Espíritu Santo cʉ̃ cajããrõ ĩñamasĩã maa —qũĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Bairo cʉ̃ caĩrõ tʉ̃go, atore bairo qũĩ jẽniñanemoñupʉ̃ tunu Nicodemo Jesure: —¿Ñe ũnie jʉ̃gori Espíritu Santo mena buianemorĩqũẽ to ãnicʉti? ");
INSERT INTO cbcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús pʉame bairo qũĩñupʉ̃: —¿Mʉ, Israel yepa macããnarẽ Dios yaye quetire caquetibʉjʉjʉ̃goʉ nimicʉ̃ã, tiere mʉ masĩẽtĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cariape mʉrẽ ñiña: Jãã camasĩrĩjẽrẽ mʉjããrẽ jãã quetibʉjʉnucũña. Jãã caĩñarĩqũẽ cʉ̃ãrẽ mʉjããrẽ jãã quetibʉjʉnucũña. Bairo cariapea mʉjããrẽ jãã caquetibʉjʉmiatacʉ̃ãrẽ, mʉjãã pʉame tiere mʉjãã tʉ̃goʉsaetinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ati yepa macããjẽrẽ mʉjãã yʉ caquetibʉjʉro cariape yʉ mʉjãã tʉ̃goroaetiya. Bairi ʉmʉrecóo macããjẽ Dios yayere yʉ caquetibʉjʉata roquere, nemojãñurõ mʉjãã tʉ̃gomasĩẽna. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Ni jĩcãʉ̃ ũcʉ̃ camasocʉ ʉmʉrecóopʉre cawãmʉñarĩcʉ̃ mácʉ̃mi. Yʉ, Camasã Jʉ̃gocʉ jeto ʉmʉrecóopʉ caãnacʉ̃ yʉ rui apʉ́ ati yepapʉre. Bairi ʉmʉrecóo macããjẽ Dios yayere yʉ masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Bairi tirʉ̃mʉpʉre cayucʉmani yepapʉre Moisés ãnacʉ̃ ãñarẽ bairo cabauʉ cʉ̃ cawericʉre yucʉpʉ cʉ̃ papuatuyupi. Torea bairo yʉ, Camasã Jʉ̃gocʉ cʉ̃ã yucʉpãĩpʉ yʉ papuatu rocaecogʉ, nipetiro camasã yʉre catʉ̃goʉsarã na canetõmasĩparore bairo ĩ. Bairi nipetirã yʉre catʉ̃goʉsarã yeri capetieti pũnarẽ cʉ̃gogarãma. Ãnicõã nigarãma tocãnacã rʉ̃mʉa,” qũĩñupʉ̃ Jesús Nicodemorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dios pʉame ati ʉmʉrecóo macããna nipetiro camasãrẽ bʉtioro maiñami. Bairo marĩrẽ mairĩ, cʉ̃ macʉ̃ jĩcãʉ̃ã cʉ̃ caãnimiatacʉ̃ãrẽ, cʉ̃ joyupi ati yepapʉre, nipetirã cʉ̃ macʉ̃rẽ catʉ̃goʉsarã na yasieticõãto ĩ. Cʉ̃ mena caroaro ãnicõã ninucũgarãma tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios ati ʉmʉrecóo macããna nipetiro cabuicʉna na ãmarõ ĩ mee, cʉ̃ joyupi cʉ̃ macʉ̃rẽ. Narẽ cʉ̃ netõbojato ĩ roque, cʉ̃ joyupi Dios ati yepapʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ni ũcʉ̃ Dios macʉ̃rẽ catʉ̃goʉsaʉ ñe ũnie cawapa cʉ̃goecʉre bairo cʉ̃ tuao joroque ásupi Dios. Cʉ̃ macʉ̃rẽ catʉ̃goʉsaena roque carorije wapa cacʉ̃gorã cayasiparã majũ tuacõãñama merẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cʉ̃rẽ catʉ̃goʉsaena popiye catãmʉoparã majũ niñama. Atore bairo niña: Jesucristo jĩñabusuricarore bairo caãcʉ̃ cʉ̃ caató, cʉ̃ boesupa. Roro átaje pʉamerẽ cʉ̃ netõrõ bomirã, canaitĩãrõpʉ caãnarẽ bairo ãñupã. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nipetiro carorije caátinucũrã Dios macʉ̃ jĩñabusuricarore bairo caãcʉ̃rẽ qũĩña tejãñuñupã. Cʉ̃ tʉpʉ ãnigaetinucũñupã, roro yasioropʉ na caátiãninucũrĩjẽrẽ Jesús pʉame baujaropʉ to ãnipeticoao joroque cʉ̃ caáperiparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dios yaye cariape quetire catʉ̃goʉsarã pʉame Dios macʉ̃ tʉpʉ ãniganucũñama, “Nipetiro na caátie Dios cʉ̃ caborore bairoa átaje niña,” camasã na caĩmasĩparore bairo ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cabero Judea cawãmecʉti yepapʉ cʉ̃ cabuerãrẽ, jãã jʉ̃go ámí Jesús. Topʉ etari, jĩcã yʉtea cãrõ camasãrẽ na jãã bautiza ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Bairo topʉ jãã caãno, Juan Bautista cʉ̃ã Salim cawãmecʉti macã tʉpʉ, Enón cawãmecʉti macã majũrẽ bautizaʉ ãcʉ̃ baiyupʉ. Topʉre pairo oco ãñuparõ. Bairi camasã cʉ̃ tʉpʉ etayuparã, cʉ̃ bautiza rotirã etarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mai, atie nipetirije baiyupa cʉ̃, Juarẽ preso jorica wiipʉ na cajoparo jʉ̃goye. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bairo jĩcã rʉ̃mʉ Juarẽ na cañeparo jʉ̃goye, cʉ̃ cabuerã pʉame apei judío majõcʉ mena bʉsʉyuparã, cʉ̃ bʉsʉnetõgarã. Judío majã caroaro ãnigarã Dios cʉ̃ caĩñajoro oco mena na caátinucũrĩjẽrẽ ãmeo bʉsʉpẽniñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bairo ãmeo bʉsʉpẽni yaparo, Juan tʉpʉ ásúparã. Bairo cʉ̃tʉ eta, atore bairo qũĩ quetibʉjʉyuparã Juarẽ: —Jããrẽ cabuei, tirʉ̃mʉjãñurõã Rio Jordán ape nʉgõãpʉ mʉ mena caãniatacʉ, jããrẽ mʉ caquetibʉjʉricʉ pʉame ãmerẽ camasãrẽ na bautizaʉ átiupʉ cʉ̃ cʉ̃ã. Bairo cʉ̃ caáto, nipetiro camasã cʉ̃rẽ ʉsarã baiuparã —qũĩñuparã Juarẽ cʉ̃ cabuerã, Jesús cʉ̃ caátiãnierẽ quetibʉjʉrã. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Bairo na caĩrõ tʉ̃goʉ, atore bairo na ĩñupʉ̃ Juan: —Dios cʉ̃ carotieticõãta, camasã cʉ̃ ʉsaetibujiorãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mʉjããrẽ yʉ caquetibʉjʉriquere mʉjãã tʉ̃goricarã. “Yʉa, Mesías, Dios cʉ̃ cabesericʉ mee yʉ ãniña,” mʉjããrẽ ñiwʉ̃. Yʉa, cʉ̃ jʉ̃goye cʉ̃ cajojʉ̃goricʉ yʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ape wãme ĩcõñarĩ atore bairo mʉjããrẽ yʉ quetibʉjʉgʉ: Jĩcãʉ̃ camasocʉ cʉ̃ nʉmo caãnipaore cõ cʉ̃ cawãmo jiyari rʉ̃mʉ caãno cʉ̃ yao majũ tuayamo. Cʉ̃ bapa cʉ̃ mena macããcʉ̃ cõ mena cʉ̃ cawãmo jiyaro ĩñaʉ, ʉseani nemoʉmi. Jesús pʉame cawãmo jiyaricʉre bairo caãcʉ̃ niñami. Camasã cʉ̃rẽ caʉsarã pʉame, cʉ̃ nʉmo, cʉ̃ cawãmo jiyaricore bairo caãna niñama. Bairi, yʉ, Jesús mena macããcʉ̃ ãnirĩ, camasã cʉ̃rẽ na caʉsaro ĩñaʉ, yʉ ʉseani nemoña. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesús pʉame tocãnacã rʉ̃mʉ nemojãñurõ caãnimajũʉ̃ ãninutuagʉmi. Yʉ pʉame roque nemorõ cabʉgoro macããcʉ̃ yʉ caãnicõãnutuapee majũ niña —ĩcõñarĩ na ĩ quetibʉjʉyupʉ Juan cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesús, ʉmʉrecóopʉ caatácʉ ãnirĩ, nipetirã netõrõ caãnimajũʉ̃ niñami. Noo ati yepa macããcʉ̃ pʉame roque ati yepa macããjẽ jetore quetibʉjʉ masĩñami. Cʉ̃, ʉmʉrecóopʉ caatácʉ ãnirĩ nipetirã netõrõ caãnimajũʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ʉmʉrecóopʉ cʉ̃ caĩñarĩqũẽrẽ, cʉ̃ catʉ̃gorique cʉ̃ãrẽ quetibʉjʉyami. Cʉ̃ caquetibʉjʉrije pʉame cariape majũ to caãnimiatacʉ̃ãrẽ, tiere cariape tʉ̃goetiyama camasã. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jĩcããrã niñama bairãpʉa cʉ̃ yaye quetire cariape catʉ̃goʉsarã. Bairo catʉ̃goʉsarã ãnirĩ, “Cariape quetibʉjʉyami,” ĩ tʉ̃goña masĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios pʉame Espíritu Santo cʉ̃ camasĩrĩjẽrẽ bʉtioro majũ cʉ̃ joyupi Jesure, ati yepapʉ cʉ̃ cajoricʉre. Bairo cʉ̃ cajoroi, Jesús pʉame caroaro cariape quetibʉjʉnucũñami Dios yaye quetire. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios cʉ̃ macʉ̃rẽ mairĩ, nipetiro rotimasĩrĩqũẽrẽ cʉ̃ joyupi. ");
INSERT INTO cbcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Torecʉ, noo macããcʉ̃ Jesure catʉ̃goʉsaʉ pʉame merẽ yeri capetieti pũnarẽ cʉ̃goyami. Apei, Jesure catʉ̃goʉsagaecʉ roque tie yeri capetieti pũnarẽ cʉ̃goetiyami. Popiye cʉ̃ baio joroque cʉ̃ átigʉmi Dios, cʉ̃ macʉ̃rẽ cʉ̃ catʉ̃goʉsaetie wapa. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Cabero camasã capããrã majũ Jesure na catʉ̃goʉsarijere tʉ̃goyuparã fariseo majã. Tunu bairoa Juan Bautista cʉ̃ cabautizaricarã netõjãñurõ Jesús cʉ̃ cabautizarã pʉame na caãnierẽ tʉ̃goyupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mai, Jesús pʉame camasãrẽ na bautizaemi. Jãã, cʉ̃ cabuerã pʉame roque cʉ̃ carotiro jʉ̃gori na jãã bautizawʉ.) ");
INSERT INTO cbcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bairi Jesús pʉame, “Yʉ cabairijere masĩcõãñama fariseo majã,” ĩ tʉ̃goñarĩ, Judea yepapʉ caãniatacʉ Galilea yepapʉ tunucoámí. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bairo tunuácʉ́, Samaria yepapʉ cʉ̃ canetõápée ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bairo netõácʉ́, Sicar cawãmecʉti macãpʉ etawĩ. Mai, ti macã tʉpʉ niña jãã ñicʉ̃ Jacob ãnacʉ̃ cʉ̃ macʉ̃ Josére cʉ̃ cacũrĩcã yepa majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ti yepapʉre niña oco warica ope, Jacob ãnacʉ̃ ya oco ope majũ. Bairo Jesús pʉame maarẽ caatímiatacʉ jʉtiri, ti opetʉre etanumu etawĩ. Muipʉ ʉmʉrecóo recomacã majũ cʉ̃ caãnipaʉ ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mai, jãã cʉ̃ cabuerã pʉame jãã acoápʉ́ macãpʉ, apeye ũnie ʉgariquere wapatiráná. Topʉ jãã caãnitoye, jĩcãõ carõmio etayupo, ti ope macããjẽrẽ oco waao acó. Bairo cõ caetaro ĩñaʉ, atore bairo cõ ĩñupʉ̃ Jesús: —Oco peeto yʉ joya. Yʉ cʉ̃ã yʉ etigaya. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mai, ti yepapʉre jãã, judío majã, Samaria yepa macããna mena jãã ãmeo bʉsʉpẽnietinucũña. Bairi to macããcõ pʉame tie tʉ̃goñarĩ atore bairo qũĩñupõ Jesure: —¿Nopẽĩ mʉa, judío majõcʉ nimicʉ̃ã, yʉ, Samaria yepa macããcõrẽ yʉ mʉ oco jẽniñati? —qũĩñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Bairo cõ caĩrõ tʉ̃goʉ, atore bairo cõ ĩñupʉ̃ Jesús carõmiorẽ: —Mʉa, Dios camasãrẽ cʉ̃ cajogarijere mʉ masĩẽtĩña. Yʉ cʉ̃ãrẽ mʉ masĩẽtĩña. Yʉre mʉ camasĩata roque, mʉ pʉame ocore yʉ mʉ jẽnibujioataco. Bairo yʉ mʉ cajẽniata, yʉ pʉame oco caticõã nio joroque caátiere mʉ yʉ jobujioatacʉ —cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Bairo cʉ̃ caĩrõ tʉ̃go, carõmio pʉame qũĩ jẽniñanemoñupõ tunu: —¿Ñe mena ocore mʉ waneiáti? Ati ope ʉ̃cʉ̃ãjãñuña. Bairi, ¿noopʉ oco cacaticõãninucũrĩjẽrẽ mʉ bocabujiocʉti? ");
INSERT INTO cbcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Marĩ ñicʉ̃ Jacob ãnacʉ̃ ati ope macããjẽrẽ etinucũñañupĩ. Cʉ̃ pũnaa, cʉ̃ yarã, cʉ̃ canurã cʉ̃ã etinucũñañupã. Ati opere ati yepa macããnarẽ na cũñañupĩ Jacob ãnacʉ̃. ¿Mʉ pʉame roque cʉ̃ netõrõ caãnimajũʉ̃ mʉ ãniñati? —qũĩ jẽniñañupõ carõmio Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Bairo cõ caĩrõ tʉ̃goʉ, atore bairo cõ ĩñupʉ̃ Jesús: —Nipetiro ati opere caoco etirã pʉame bairoa ñeme jipicõãgarãma tunu. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ni ũcʉ̃ atie oco yʉ cajogarijere caetii pʉame pʉgani cãrõ ñeme jipinemoetigʉmi tunu. Cʉ̃pʉre cʉ̃ yeripʉ oco tutuaro cawitipetietore bairo yeri tʉ̃goñatutuacõãnajẽ cʉ̃ãrẽ cʉ̃gocõã ninucũgʉmi. Tie jʉ̃gori caticõã ninucũgʉmi tocãnacã rʉ̃mʉ —cõ ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Bairo cʉ̃ caĩrõ tʉ̃go, carõmio pʉame bairo qũĩñupõ tunu: —Toroquere, tie ocore yʉ joya, pʉgani cãrõ yʉ cañemejipinemoetiparore bairo ĩ. Ati opepʉre pʉgani cãrõ oco wago yʉ bainemoetigo yua —qũĩñupõ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Bairo cõ caĩrõ tʉ̃gomicʉ̃ã, atore bairo cõ ĩñupʉ̃ Jesús: —Mai, mʉ manapʉre cʉ̃ pioja. Cʉ̃ piiri bero, atopʉ asá cʉ̃ mena. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bairo cʉ̃ caĩrõ, carõmio pʉame atore bairo qũĩñupõ: —Camanapʉ mácõ yʉ ãniña. Jesús pʉame bairo cõ caĩrõ, bairo cõ ĩ yʉyupʉ: —“Camanapʉ mácõ yʉ ãniña,” mʉ caĩata, cariapea miña. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Jĩcã wãmo cãnacãʉ̃ majũ camanapʉ cʉtimirĩcõ mʉ ãniña. Ãme mʉ mena caãcʉ̃ cʉ̃ã mʉ manapʉ majũ mee niñami. Toreco, cariapea miña —cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bairo cʉ̃ caĩrõ, carõmio pʉame atore bairo qũĩñupõ Jesure. —Mʉ caĩrĩjẽrẽ tʉ̃gori, merẽ yʉ masĩña: Mʉa, profeta, Dios yaye quetire caquetibʉjʉri majõcʉ mʉ ãcʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bairi jãã, Samaria yepa macããna jãã ñicʉ̃jãã jicʉ ʉ̃tãʉ̃pʉ Diore cʉ̃ ñubuenucũñupã. Mʉjãã judío majã roque aperopʉ Jerusalẽpʉ mʉjãã ñubuenucũña —qũĩñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Bairo cõ caĩrõ, atore bairo cõ ĩñupʉ̃ Jesús: —Yʉ caĩrĩjẽrẽ cariape tʉ̃goya: Jicʉ ʉ̃tãʉ̃pʉ ápérimirãcʉ̃ã, o Jerusalén macãpʉ ápérimirãcʉ̃ã, marĩ Pacʉ Diore cʉ̃ mʉjãã cañubuemasĩpa rʉ̃mʉ cõñarõ baiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉjãã, Samaria yepa macããna Diore tʉ̃gonucũmirãcʉ̃ã, cʉ̃ mʉjãã masĩẽtĩña. Jãã, judío majã roque Dios camasãrẽ cʉ̃ canetõgarije quetire cʉ̃ caquetibʉjʉcũrĩcãrã majũ ãnirĩ cʉ̃ jãã masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bairi camasã caroaro cariape Diore na cañubuerica yʉtea etaro baiya. Merẽ ti yʉtea ãnijʉ̃goya. Bairi camasã noo na cañubuenucũrĩpaʉ jʉ̃gori mee, Espíritu Santo na yeripʉ cʉ̃ caãno jʉ̃gori pʉame roque Diore cʉ̃ ñubuegarãma. Tore bairo na cañubuero boyami Dios cʉ̃rẽ caroaro cariape cañubuerã pʉamerẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Marĩ caĩñaecʉ̃ niñami Dios. Bairi cʉ̃rẽ caroaro cariape cañubuerã pʉame na yeri na catʉ̃goñarĩjẽpʉ roque cʉ̃rẽ cañubueparã niñama —cõ ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bairo cʉ̃ caĩrõ, carõmio pʉame atore bairo qũĩñupõ Jesure: —Ape rʉ̃mʉ Mesías Dios cʉ̃ cabesericʉ, Cristo cawãmecʉcʉ cʉ̃ caetapeere yʉ masĩña. Cʉ̃, etaʉpʉ, cʉ̃ majũ nipetirijere marĩ quetibʉjʉgʉmi —qũĩñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Bairo cõ caĩrõ tʉ̃goʉ, bairo cõ ĩ masĩõñupʉ̃ Jesús: —Yʉ, mʉ mena cabʉsʉpẽni, cʉ̃ã yʉ ãniña Cristo, Dios cʉ̃ cabesericʉ majũ —cõ ĩñupʉ̃ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bairo cõ cʉ̃ caĩquetibʉjʉripaʉa, jãã, Jesús cʉ̃ cabuerã, macãpʉ caʉgarique wapatiratána cʉ̃ tʉpʉ jãã etawʉ. Bairo etarã yua, dope bairo jãã ĩ tʉ̃goñamasĩẽpʉ̃, Jesús carõmio mena cʉ̃ cabʉsʉpẽnirõ ĩñarã. Bairi, “¿Ñe ũnierẽ mʉ átiyati?” jãã ĩ jẽniñaepʉ̃ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bairo carõmio pʉame jãã caetaro ĩñao, cõ oco warica jotʉre toa piti ropocõãwõ. Bairo piti ropo yaparo, macãpʉ acoámó. Topʉ etari, atore bairo na ĩ quetibʉjʉyupo to macããnarẽ: ");
INSERT INTO cbcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Tiaya mʉjãã cʉ̃ã. Nipetiro ĩñarasá. Jõ jĩcãʉ̃ camasocʉ niñami dope bairo yʉ caátajere camasĩpeyocõãʉ̃. ¿Cristo, Dios cʉ̃ cabesericʉ mee cʉ̃ ãnibauyati? —na ĩ quetibʉjʉyupo. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bairo na cõ caĩquetibʉjʉro tʉ̃gorã, to macããna pʉame ti macãrẽ witiá yua, jãã caãnopʉ etawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mai, na caatípaʉa Jesure, “Ʉgariquere ʉgaya,” cʉ̃ jãã ĩmiwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bairo jãã caĩrõ tʉ̃gomicʉ̃ã, atore bairo jãã ĩwĩ Jesús: —Yʉa, apeye ũnie ʉgarique yʉ cʉ̃goya mʉjãã camasĩẽtĩẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bairo cʉ̃ caĩrõ tʉ̃gorã, jãã, cʉ̃ cabuerã pʉame atore bairo jãã ãmeo ĩ bʉsʉwʉ: —¿Aperã merẽ ʉgariquere cʉ̃ na jeatíbaupari? —jãã ĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Bairo jãã caĩrõ tʉ̃goʉ, Jesús pʉame atore bairo jãã ĩwĩ: —Dios, yʉre cajoʉ, cʉ̃ caborijere ácʉ yʉ átiya. Bairi jĩcãʉ̃ bʉtioro caʉgagatʉ̃goñaʉrẽ bairo yʉ cʉ̃ã yʉ cʉ̃ caátirotijoriquere yʉ átipeyogaya. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Atore bairo yʉ mʉjãã ĩña: Baparicãnacãʉ̃ muipʉa rʉsaya oterique caríca cʉtiparo jʉ̃goye. Bairo yʉ mʉjãã caĩmiatacʉ̃ãrẽ, ape wãme ĩcõñarĩ mʉjããrẽ yʉ quetibʉjʉpa: Oteriquere ĩñañijate. Yʉra, merẽ jeriquepʉ niña. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oterique rícare cajeri majõcʉ cʉ̃ capaarique wapa wapatagʉmi. Cʉ̃ capaarique wapa pʉame Dios cʉ̃ cajorije yeri capetieti pũna majũ niña. Bairo bairi oterique caotei, cabero cʉ̃ caoterique caríca cʉtopʉ tiere cajei cʉ̃ã pʉgarãpʉa ʉseanigarãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Camasã na caquetibʉjʉnucũrĩ wãmerẽ bairo cariape baiya: “Jĩcãʉ̃ jicoqueipʉa oteimi. Cabero cʉ̃ caoterique caríca cʉtopʉ apei jeimi tunu,” ĩ nucũñama camasã. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mʉjãã, yʉ cabuerã, na caĩnucũrõrẽã bairo mʉjãã baiya. Mʉjããrẽ yʉ yaye quetire mʉjãã yʉ quetibʉjʉ rotijoya merẽ aperã na caquetibʉjʉjʉ̃goricarã tʉpʉ, caroaro jĩcãrõ tʉ̃ni na catʉ̃gopeti jĩãtietaparore bairo ĩ. Mʉjãã, aperã na capaajʉ̃goriquepʉre capaayaparo petietabojarãrẽ bairo mʉjãã yʉ átirotijoya na watoapʉre. Bairi merẽ mʉjããrẽ masiriyoetiya mʉjãã yʉ caquetibʉjʉrotijorije yua —jãã ĩwĩ Jesús yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bairi capããrã to macããna Samaria yepa macããna, “Nipetiro yʉ caátajere masĩpeyocõãñami Jesús,” carõmio cõ caĩrõ jʉ̃gori, qũĩroa jʉ̃gowã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bairo bairi Jesús tʉpʉ etarã, “Ápéricõãña,” qũĩwã Jesure. “Jãã mena mʉ tuagʉ mai,” bairo na caĩrõ tʉ̃goʉ, pʉga rʉ̃mʉ majũ na mena ãmi Jesús, narẽ bue ãcʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bairo Jesús cʉ̃ caquetibʉjʉrijere tʉ̃gorã, cʉ̃rẽ caĩroarã menarẽ ãninemowã capããrã to macããna camasã. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na pʉame atore bairo cõ ĩwã carõmiorẽ: —Ñamicãã jããrẽ mʉ caquetibʉjʉataje jʉ̃gori Jesús mena jãã tʉ̃goñatutuajʉ̃goapʉ. Ãme roque jãã majũ cʉ̃ caquetibʉjʉrijere tʉ̃gori, nemojãñurõ cʉ̃ mena jãã tʉ̃goñatutuaya. Cariape cʉ̃ã niñami ati ʉmʉrecóo macããna na carorije wapare canetõʉ̃ majũ —cõ ĩwã to macããna carõmiorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bairi pʉga rʉ̃mʉ Samaria yepa macããna mena cʉ̃ caãniatato bero, Jesús Galilea yepapʉ acoámí. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mai, Jesús, cʉ̃ majũ cʉ̃ caĩatatore bairo baiwʉ: “Ni ũcʉ̃ Dios yaʉ profetare cʉ̃ ya macã macããna cʉ̃ boenama. Noa majũ qũĩroaenama.” ");
INSERT INTO cbcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bairo bairi Jesús Galilea yepapʉ cʉ̃ caetaro ĩñarã, camasã to macããna pʉame caroaro cʉ̃ jẽniwã. Mai, na cʉ̃ã Jerusalẽpʉ Pascua bose rʉ̃mʉ ĩñarã etayupa. Topʉ Jesús cʉ̃ caáti ĩñorĩqũẽrẽ ĩñañupã. Bairo bairi caroaro qũĩña ʉseaniwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bairo Jesús Galilea yepapʉ áñesẽã, Caná na caĩrĩ macãpʉ ocorea, ʉse oco majũ cʉ̃ caátijẽñorĩcã macãpʉ tunucoámí. Ti macãpʉre ãñupĩ jĩcãʉ̃ ti yepa quetiupaʉ rey roca carotimasĩ majũ. Cʉ̃ macʉ̃ pʉame bʉtioro riayupʉ ape macãpʉ Capernaupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bairo bairi, “Jesús Judea yepapʉ caãniatacʉ Galilea yepapʉ etaupʉ,” na caĩrĩjẽrẽ queti tʉ̃gori, Jesús tʉpʉ ásúpʉ. Cʉ̃tʉ etaʉ, “Jito yʉ ya wiipʉ. Yʉ macʉ̃ pʉame cariacʉpʉ niñami. Cʉ̃ catioʉ asá,” bʉtioro qũĩwĩ capacʉ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Bairo cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩwĩ Jesús: —Mʉjãã camasã, yʉ caátimasĩrĩjẽ átijẽñorĩqũẽrẽ mʉjãã caĩñaepata, yʉ mena mʉjãã tʉ̃goñatutuaetinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bairo cʉ̃ caĩrõ tʉ̃gomicʉ̃ã, atore bairo qũĩwĩ quetiupaʉ rey roca carotimasĩ Jesure: —Yʉ Quetiupaʉ, ¡jito, diwatoa! Yʉ macʉ̃ cariacʉpʉ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Bairo cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩwĩ Jesús: —Mʉ ya wiipʉ tunucoa ácʉ́ja. Merẽ mʉ macʉ̃ catigʉmi —qũĩwĩ. Bairo cʉ̃ caĩrĩjẽrẽ cariape tʉ̃goʉ, carotimasĩ pʉame acoámí cʉ̃ ya wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bairo cʉ̃ catunu átípaʉa, cʉ̃ paacoteri majã pʉame maapʉ cʉ̃ bocáetari, atore bairo qũĩñuparã: —¡Mʉ macʉ̃ caticoami merẽ! ");
INSERT INTO cbcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bairo na caĩquetibʉjʉro tʉ̃gori, “¿Dipaʉ muipʉ cʉ̃ caãno majũ cʉ̃ cati jʉ̃goati yʉ macʉ̃?” na ĩ jẽniñañupʉ̃. Bairo cʉ̃ caĩrõ, qũĩñuparã: —Ñamicã, jĩcãrõ riape beroaca cʉ̃ bʉgojãnaapʉ —qũĩ quetibʉjʉyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bairo na caĩquetibʉjʉro tʉ̃goʉ, capacʉ pʉame tʉ̃gomasĩ rocajoyupʉ: “‘Merẽ mʉ macʉ̃ caticoayami,’ Jesús yʉ cʉ̃ caĩata hora majũ niupã,” ĩ tʉ̃gomasĩ rocajoyupʉ. Bairo tiere na cʉ̃ caquetibʉjʉro tʉ̃gorã, cʉ̃, cʉ̃ ya wii macããna nipetiro cʉ̃ã cʉ̃rẽ bairo Jesús mena tʉ̃goñatutua jʉ̃goyuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mai, carotimasĩ macʉ̃rẽ Jesús cʉ̃ cacatiorique pʉame Galilea yepapʉre ocorea, ʉse oco majũ cʉ̃ caátijẽñorĩqũẽ bero cʉ̃ caáti ĩñobaporique ãmʉ ti wãme. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bairo jĩcã yʉtea canetõrõ bero Jesús pʉame judío majã na cabose rʉ̃mʉ qũẽnorõ ĩñaʉ ácʉ́, tunu ámí Jerusalén macʉ̃pʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mai, ti macã Jerusalén pʉame ʉ̃tã mena ʉ̃mʉarõpʉ na caẽñotaãmejorerica macã ãmʉ. Bairi jĩcã jope oveja nurĩcãrã na cajããrĩ jope cawãmecʉti jope ãmʉ. Bairo bairi ti jope jãátápaʉ tʉre ãmʉ jĩcã ope caoco witiri ope. Tipaʉ Betzata wãmecʉpʉ yʉ yaye hebreo mena. Ti opetʉre jĩcã wãmo cãnacã jopee majũ jopeeri werique ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bairo bairi ti jopeeri tʉre capããrã cariarã ãma. Jĩcããrã cacaapee ĩñamasĩẽna, aperã caámasĩẽna, aperã cabʉʉrã cũña jowã tipaʉre. Na pʉame oco cajabewẽrĩjẽrẽ coterã baiwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mai, ángel pʉame masĩã mano cʉ̃ cabori rʉ̃mʉpʉ caãno ti oco opepʉ etanucũñupʉ̃. Bairo etari, ocore átijabenucũñupʉ̃. Bairo cʉ̃ caátijabero bero, ni ũcʉ̃ tie ocore cañañuajʉ̃goʉ pʉame cʉ̃ cariayecʉtie cʉ̃ netõcõã nucũñuparõ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mai, na menarẽ jĩcãʉ̃ ãmi treinta y ocho cʉ̃marĩ majũ cariayecʉtiãcʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bairo bairi Jesús ti operi tʉpʉ netõácʉ́, topʉ cacũñaʉrẽ qũĩñawĩ. Yoaro cʉ̃ cariayecʉto qũĩñamiácʉ, atore bairo qũĩ jẽniñawĩ Jesús cariaʉre: —¿Mʉ riaye canetõrõ mʉ boyati? ");
INSERT INTO cbcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Cariaʉ pʉame atore bairo qũĩ yʉwĩ Jesure: —Yʉ Quetiupaʉ, yʉre cajʉátinemoʉ manimajũcõãñami. Tocãnacã nia oco cajabenetõrĩpaʉ caãno tie ocopʉ yʉ cañañuagaro, aperã pʉame yʉ jʉ̃goye ñañuaweyocõã nucũñama —qũĩwĩ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Bairo cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩwĩ Jesús: —Wãmʉnʉcãña, mʉ cacũñarõrẽ nepʉsari ácʉ́ja. Merẽ mʉ riayere yʉ netõcõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bairo cʉ̃ caĩrõ, jicoquei ñucoami cariaye cʉtimiatacʉ pʉame yua. Bairo wãmʉnʉcã yua, cʉ̃ cacũñarõrẽ ne acoámí. Mai, ti rʉ̃mʉ pʉame judío majã na cayerijãrĩ rʉ̃mʉ ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bairo bairi Jesús cʉ̃ cacatioatacʉ cʉ̃ cacũñarõrẽ cʉ̃ caneátó ĩñarã, judío majã quetiuparã pʉame atore bairo qũĩwã cʉ̃rẽ: —¿Nopẽĩ ãme rʉ̃mʉ marĩ cayerijãrĩ rʉ̃mʉ caãnimiatacʉ̃ãrẽ, mʉ cacũñarõrẽ mʉ ne ñesẽãñati? Ati rʉ̃mʉ ũnorẽ bairo boetiya —qũĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bairo na caĩrõ tʉ̃goʉ, atore bairo na ĩwĩ cariamiatacʉ: —Yʉre cariaye netõatacʉ pʉame, “Mʉ cacũñarõrẽ nerĩ ácʉ́ja,” ñiami —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Atore bairo qũĩwã tunu: —¿Ñamʉ majũ, “Mʉ cacũñarõrẽ nerĩ ácʉ́ja,” mʉ qũĩati? —qũĩ jẽniñawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bairo na caĩjẽniñarõ tʉ̃gori, cacatiatacʉ pʉame qũĩña macãmiwĩ Jesure. Qũĩña bócaemi. Jesús pʉame bauemi, merẽ capããrã camasã caĩñarã etarã watoapʉ caácʉ́ ãnirĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cabero Dios ya wii templo wiipʉ cʉ̃ boca etaʉ, atore bairo qũĩwĩ Jesús cʉ̃ cacatioatacʉre: —Tʉ̃gopeoya yʉ caĩrĩjẽrẽ: Merẽ canetõatacʉpʉ mʉ ãniña. Bairi roro mʉ átinemoepa. Carorije mʉ caátinemoata, nemojãñurõ mʉ tãmʉogʉ tunu —qũĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Bairo Jesús cʉ̃ caĩrõ bero, caʉ̃mʉ pʉame judío majã quetiuparãrẽ na quetibʉjʉ ámí. “Yʉre cariaye netõatacʉ pʉame ‘Jesús’ wãme cʉtiyami,” na ĩ quetibʉjʉwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bairo cʉ̃ caĩrõ tʉ̃gorã, judío majã quetiuparã Jesús, yerijãrĩcã rʉ̃mʉrẽã caʉ̃mʉrẽ cʉ̃ canetõrĩqũẽ jʉ̃gori cʉ̃ mena asiarã popiye cʉ̃ baio joroque átigayupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús pʉame bairo na ĩwĩ: —Yʉ Pacʉ tocãnacãnia paanucũñami. Yʉ cʉ̃ã cʉ̃rẽã bairo yʉ paanucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bairo cʉ̃ caĩrõ tʉ̃gorã, nemojãñurõ Jesús cʉ̃ cariaro boyuparã judío majã quetiuparã pʉame. Mai, “Marĩ cayerijãrĩ rʉ̃mʉ macããjẽ marĩ ñicʉ̃jãã na caroticũrĩqũẽrẽ nʉcʉ̃bʉgoetiyami Jesús, bairo cariayecʉcʉre cʉ̃ cacatioata,” ĩ tʉ̃goñarĩ, cʉ̃ mena asiajãñuñuparã. Bairo tunu, “‘Dios niñami yʉ Pacʉ majũ,’ cʉ̃ caĩata, ‘Yʉ, Dios mena jĩcãrõrẽ bairo jãã ãniña,’ caĩrẽ bairo ĩñami Jesús,” ĩ tʉ̃goñarĩ, netõrõ majũ cʉ̃ mena asiayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bairo na caĩtʉ̃goñarĩjẽrẽ masĩcõãrĩ, atore bairo na ĩwĩ Jesús: “Cariape mʉjããrẽ ñiña: Yʉ, Dios macʉ̃ nimicʉ̃ã, dise ũnie átijẽñorĩqũẽrẽ yʉ majũã yʉ áti masĩẽtĩña. Yʉ Pacʉ cʉ̃ caátigarijere masĩrĩ, cʉ̃ carotiro mena jeto tiere yʉ áti masĩña. Yʉ Pacʉ cʉ̃ caátigarijere masĩrĩ, tie nipetirijere yʉ átinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ Pacʉ yʉre mairĩ, nipetirije cʉ̃ caátinucũrĩjẽrẽ ñiñoñami. Ãme caámasĩẽcʉ̃rẽ cʉ̃ yʉ caátiorije netõjãñurõ caroa macããjẽ cʉ̃ caátigarijere yʉ áti ĩñogʉmi caberopʉre. Tie roquere ĩñarã, nemorõ mʉjãã ĩña acʉamajũcõãgarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉ Pacʉ pʉame cabaiyasiricarãrẽ tunu na catiocõãñami. Cʉ̃rẽ bairoa yʉ cʉ̃ã noo yʉ caborãrẽ na yʉ joya catiriquere. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yʉ Pacʉ pʉame ni ũcʉ̃ camasocʉre qũĩña beseetiyami. Yʉ pʉamerẽ nipetiro camasãrẽ na ĩñabeseroti yʉ jowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","‘Yʉre na caĩroarore bairo yʉ macʉ̃ cʉ̃ãrẽ na ĩroáto,’ ĩ, yʉ jowĩ yʉ Pacʉ Dios. Bairi yʉre caĩroaecʉ pʉame yʉ Pacʉ yʉre cajoricʉ cʉ̃ãrẽ caĩroaecʉre bairo nicõãñami mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Cariape mʉjããrẽ ñiña: Ni jĩcãʉ̃ ũcʉ̃ yʉ yaye quetire catʉ̃goʉsaʉ, bairi Dios yʉre cajoricʉ mena catʉ̃goñatutuaʉ pʉame caticõã ninucũgʉmi tocãnacã rʉ̃mʉa. Popiye cʉ̃ baio joroque Dios cʉ̃ caátipaʉ mee niñami. Bairi cʉ̃, ñamicã cabaiyasiricʉ nimicʉ̃ã, ãmerẽ yua, cacaticõãninucũʉ̃rẽ bairo tuayami. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cariape mʉjããrẽ ñiña tunu: Petoaca rʉsaya ati yepa macããna yʉ, Camasã Jʉ̃gocʉre, yʉ na catʉ̃goʉsaparo. Merẽ yʉ na catʉ̃goʉsari yʉtea ãnijʉ̃goya. Yʉre catʉ̃goʉsaena pʉame yasiricaropʉ caápárã majũ tuagarãma. Yʉ yaye quetire cariape catʉ̃gorã pʉame roque caticõã ninucũgarãma tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yʉ Pacʉ camasãrẽ ãnicõãninucũrĩqũẽrẽ cajoʉ niñami. Bairo bairi yʉ cʉ̃ãrẽ camasãrẽ ãnicõãninucũrĩqũẽrẽ na yʉ cajoro boyami. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tunu bairoa Camasã Jʉ̃gocʉ yʉ caãnie jʉ̃gori yʉ pʉamerẽ nipetiro camasãrẽ na ĩñabeseroti yʉ jowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Bairo yʉ caĩquetibʉjʉrijere tʉ̃gorã, acʉaeticõãña. Jĩcã rʉ̃mʉ nipetiro cabaiyasiricarã cʉ̃ã yʉ yaye bʉsʉriquere tʉ̃gogarãma. Tiere tʉ̃gorã, masã operipʉ caãnimiatana catitunugarãma. Caroaro cariape caátana catitunurĩ bero, ʉseanirĩ ãnicõã ninucũgarãma tocãnacã rʉ̃mʉa. Roro caátana pʉame roque catitunurĩ bero caʉ̃petietopʉ popiye baicõã ninucũgarãma tocãnacã rʉ̃mʉa,” na ĩ quetibʉjʉwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ĩ quetibʉjʉ yaparo, atore bairo na ĩwĩ tunu: “Yʉ majũ jĩcãʉ̃ã camasãrẽ ñiña besemasĩẽtĩña. Yʉ Pacʉ cʉ̃ caboro cʉ̃ carotirore bairo na ñiña besemasĩña. Bairo bairi na yʉ caĩñabeserije pʉame caroaro cariape niña. Yʉ majũã yʉ caboro yʉ caátigarijere yʉ áperiya. Yʉ Pacʉ, yʉre cajoricʉ, cʉ̃ caborore bairo yʉ átinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tunu bairoa yʉ majũ, ‘Yʉ yaye bʉsʉrique cariape niña,’ jĩcãʉ̃ã mʉjããrẽ yʉ caĩata, ‘Mʉnana, marĩ ĩtoyami,’ mʉjãã ĩbujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bairo mʉjãã caĩmiatacʉ̃ãrẽ, apei yʉ caátiãnierẽ ĩñarĩ, ‘Cʉ̃ yaye bʉsʉrique cariape niña,’ mʉjããrẽ ĩñami. Yʉre cʉ̃ cajʉ̃goĩrĩjẽ pʉame roque caãnimajũrĩjẽ niña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tunu apei Juan Bautista tʉpʉre yʉ yaye quetire mʉjãã yarã mena mʉjãã jẽniña rotijoyupa. Juan pʉame cariape majũ mʉjããrẽ quetibʉjʉ joyupi yʉ caátiãnie quetire. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jĩcãʉ̃ camasocʉ, ‘“Jesús yaye bʉsʉrique cariape niña,” mʉjããrẽ cʉ̃ caĩquetibʉjʉeticõãta, yʉ átimasĩẽtĩbujioʉ,’ ñi tʉ̃goñaẽtĩña baipʉa. Dios mʉjããrẽ cʉ̃ canetõrõ roque yʉ boya. Bairo bairi Juan narẽ cʉ̃ caĩrĩqũẽrẽ na tʉ̃gobocaáto ĩ, tiere mʉjããrẽ ñinemoña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan pʉame cajĩñabusujʉ̃gori majõcʉre bairo caãcʉ̃ ãmi. Cajĩñabusurica caroaro jĩñawoya. Tia jĩñabusurica caʉ̃busuorore bairo ãmi Juan, Dios yaye caroa quetire quetibʉjʉ ãcʉ̃. Tie cʉ̃ yaye quetibʉjʉriquere tʉ̃gorã, nocãrõ mea tiere mʉjãã tʉ̃go ʉseanimiñupã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yʉ caátijẽñorĩjẽ pʉame Juan cʉ̃ caquetibʉjʉrique netõrõ caãnimajũrĩjẽ niña. Yʉ caátijẽñorĩjẽ yʉ Pacʉ cʉ̃ caátirotirije majũ niña. Bairo bairi tiere ĩñarĩ, ‘Cariapea Jesús, Dios cʉ̃ cajoricʉ majũ niñami,’ yʉre mʉjãã caĩmasĩpee niña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yʉ Pacʉ, yʉre cajoricʉ pʉame, yʉ caátiãnierẽ caroaro quetibʉjʉyami mʉjããrẽ. Di rʉ̃mʉ ũno cʉ̃ cabʉsʉrije majũrẽ mʉjãã catʉ̃goetimiatacʉ̃ãrẽ, bairi tunu cʉ̃ cabaurijere mʉjãã caĩñaetimiatacʉ̃ãrẽ, tore bairo mʉjãã quetibʉjʉyami baipʉa yʉ Pacʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bairo mʉjããrẽ cʉ̃ caquetibʉjʉmiatacʉ̃ãrẽ, yʉ, cʉ̃ cajoricʉre mʉjãã ĩroaetiya. Bairo bairi cʉ̃ caquetibʉjʉrijere mʉjãã tʉ̃go ʉsaetinucũña. Cayeri tʉ̃goʉsaena mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yeri capetietiere bócagarã, Dios yaye quetire na cawoaturica tutire caroaro ĩroarique mena mʉjãã buecõã ninucũmiña. Yʉa, ti tutire cawoaturicarã na cawoatujʉ̃goyetacʉ yʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bairo na cawoatujʉ̃goyetacʉ yʉ caãnimiatacʉ̃ãrẽ, mʉjãã pʉame yʉ mʉjãã boetiya. Bairo yʉre mʉjãã caboeticõãta, yʉ cajomasĩrĩjẽ yeri capetieti pũnaarẽ mʉjãã cʉ̃goetigarã,” na ĩwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ĩ quetibʉjʉ yaparo, atore bairo na ĩ quetibʉjʉwĩ tunu: “Camasã, ‘Caroaro majũ caquetibʉjʉ niñami,’ yʉre na caĩpee yʉ macãẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bairo macãẽtĩrĩ, bairo mʉjããrẽ ñinemoña: Mʉjãã yeri mʉjãã catʉ̃goñarĩjẽrẽ yʉ masĩña. Mʉjãã pʉame roque mʉjãã yeripʉ Diore camasĩẽna majũ mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉ Pacʉ cʉ̃ carotiro jʉ̃gori mʉjããrẽ buei acʉ́ yʉ apʉ́ ati yepapʉre. Bairo cʉ̃ cajoricʉ yʉ caãnimiatacʉ̃ãrẽ, yʉ mʉjãã boetiya. Apei cabuei cʉ̃ majũã cʉ̃ caboro mʉjãã tʉpʉ cʉ̃ caapáta, cʉ̃ mʉjãã tʉ̃goʉsabujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aperã, ‘Caroarã mʉjãã ãniña,’ mʉjããrẽ na caĩrĩjẽrẽ mʉjãã boya. Bairo bomirãcʉ̃ã, Dios jĩcãʉ̃ã caãcʉ̃ pʉame, ‘Caroarã mʉjãã ãniña,’ mʉjããrẽ cʉ̃ caĩpee pʉamerẽ mʉjãã macãẽtĩña. Bairo cabairã ãnirĩ, dope bairo yʉ mena mʉjãã tʉ̃goñatutua jʉ̃gomasĩẽna. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tunu bairoa, ‘Marĩ caátiere qũĩ bʉsʉjãbujioʉmi Diopʉre,’ ĩ tʉ̃goñaeticõãña. Bairo mee yʉ átiya. Moisés ãnacʉ̃ pʉame roro mʉjãã caátiere quetibʉjʉ buitiyami mʉjããrẽ Diopʉre. Moisés ãnacʉ̃ mʉjãã caĩroanucũʉ̃ majũ pʉame roque bairoa átiyami. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yʉ pʉame Moisés ãnacʉ̃ cʉ̃ cawoatujʉ̃goyecʉtacʉ yʉ ãniña. Bairi cʉ̃ yaye quetire caroaro cariape mʉjãã catʉ̃goata, yʉ yaye queti cʉ̃ãrẽ mʉjãã tʉ̃goʉsabujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Cabʉgoroa cʉ̃ yaye cʉ̃ cawoatucũrĩqũẽrẽ cariape mʉjãã catʉ̃goʉsaepata, nemojãñurõ ãnirĩ mʉjããrẽ yʉ caĩrĩjẽ roquere mʉjãã tʉ̃goʉsaena,” na ĩwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tipaʉ bero Jesús tunucoámí Galilea yepapʉre tunu. Topʉre ãcʉ̃, Galilea macããra ʉtabʉcʉrapʉ pẽñawĩ. Mai, tira pʉame ape wãme Tiberias wãmecʉtiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bairo bairi to macããna camasã cʉ̃ camasĩrĩjẽ mena Jesús cariayecʉnarẽ cʉ̃ canetõrõ ĩñawã. Bairo cʉ̃ caáti ĩñorĩjẽrẽ ĩñarã, cʉ̃ berore ʉsawã capããrã camasã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bairi jãã, Jesús cʉ̃ cabuerã cʉ̃ã, ape nʉgõãpʉ pẽña etarã yua, ʉ̃tãʉ̃pʉ jãã wãmʉcoápʉ́. Wãmʉá, jãã etanumucoápʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tipaʉ caãno judío majã na ya bose rʉ̃mʉ Pascua cawãmecʉti rʉ̃mʉ caãniparo cõñarõ baiwʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bairo Jesús camasã capããrã cʉ̃ bero na caʉsaro ĩñaʉ, atore bairo qũĩwĩ Felipere: —¿Noopʉ ʉgariquere marĩ wapatirãti, ãnoa nipetiro camasãrẽ marĩ canupeere? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mai, Jesús pʉame merẽ dope bairo cʉ̃ caátipeere masĩmicʉ̃ã, tore bairo cʉ̃ jẽniñawĩ Felipere, “¿Dope bairo yʉre cʉ̃ yʉati?” ĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Bairo cʉ̃ caĩrõ tʉ̃goʉ, atore bairo qũĩwĩ Felipe Jesure: —¡Ago, tame! docientos denario moneda tiiri mena pããrẽ na marĩ cawapatinumiatacʉ̃ãrẽ, nipetiro camasãrẽ petoaca caãnie etatuaetibujioro —qũĩwĩ Felipe. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Bairo cʉ̃ caĩrõ tʉ̃goʉ, apei jãã mena macããcʉ̃ Andrés, Simón Pedro bai pʉame, atore bairo qũĩwĩ Jesure: ");
INSERT INTO cbcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Atore niñami cawĩmaʉ jĩcãʉ̃. Cʉ̃ pʉame jĩcã wãmo cãnacã rupaa cebada mena na caátaje pããrẽ cʉ̃goyami. Bairi tunu wai pʉgarããcã cʉ̃goyami. Atie ʉgariqueaca, ãnoa camasã capããrã na caãnoi, na etatuaetimajũcõãbujioro —qũĩwĩ Andrés. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩwĩ Jesús: —Nipetiro camasãrẽ na rui rotiya. Mai, to na caruiparo pʉame caroaro cataa cʉto ãmʉ. Bairo bairi etanumu peticoama taa buipʉ nipetirã, jĩcã wãmo cãnacã mil majũ camasã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bairo na caruiro ĩñaʉ, Jesús pʉame pan rupaare nerĩ, Diore, “Jãã mena mʉ ñujãñuña,” qũĩ jẽniwĩ. Bairo qũĩ jẽni yaparori bero, yepapʉ caruirãrẽ tie pããrẽ jãã batorotiwĩ. Torea bairo ámi wai cʉ̃ãrẽ. Bairo átiri bero, camasã na caʉgagaro cãrõ ʉgawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bairo na caʉgatuaro bero, atore bairo jãã ĩwĩ Jesús, jãã, cʉ̃ cabuerãrẽ: —Na caʉgarʉgarije jeneñoña, yasire ĩrã —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bairo cʉ̃ caĩrõ tʉ̃gori, cʉ̃ carotirore bairo jãã ápʉ. Jĩcã wãmo cãrõ pan rupaa caãnimiatajere jãã jeneño jirowʉ pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã piiri majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bairi to macããna camasã, bairo Jesús pan, wai mena cʉ̃ caáti ĩñoatajere ĩñarĩ, atore bairo ãmeo ĩwã na majũ: —Toroquere, ãni Jesús, “Jĩcãʉ̃ profeta Dios cʉ̃ cajopaʉ majũ ati yepapʉre atígʉmi,” marĩ ñicʉ̃jãã ãnana na caĩquetibʉjʉ jʉ̃goyetiricʉ ãcʉ̃mi. Cariapea cʉ̃ã ãnibauyami —ãmeo ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bairo ãmeo ĩrã yua, bʉtioro ti yepa Quetiupaʉ rey cʉ̃ jõõgarã cʉ̃ neágamiwã Jesure. Cʉ̃ pʉame bairo cʉ̃ na caátigarijere boecʉ, ʉ̃tãʉ̃ buipʉ wãmʉcõámí yua, jĩcãʉ̃ã ãnigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cabero canaiocũmuatípaʉ jãã, Jesús cʉ̃ cabuerã pʉame ʉtabʉcʉrapʉ jãã roaápʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bairi cũmuapʉ etajãã, ti ʉtabʉcʉrare jãã pẽña jʉ̃goapʉ, Capernaum macãpʉ etarágarã. Tocãrõã merẽ naitĩã peticoápʉ. Jesús pʉame jãã tʉpʉ etaemi mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bairo jãã capẽña atípaʉ, wĩno bʉtioro papu jʉ̃goapʉ. Bairi oco turi paca majũ jabewʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bairo bairi yoaropʉ jĩcã wãmo cãnacã kilómetro majũ jãã caatʉsátípaʉ, Jesús pʉame jãã tʉpʉ acʉ́, oco buipʉ peacoamí. Bairo cʉ̃ caató ĩñarã, bʉtioro jãã uwicoápʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bairo jãã cauwiro ĩñaʉ, atore bairo jãã ĩ jowĩ Jesús: —¡Yʉ yarã, Jesua yʉ ãniña, yʉ uwieticõãña! —jãã ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bairo cʉ̃ caĩrõ tʉ̃gorã, cũmuapʉ cʉ̃ caetajãrõ jãã bowʉ. Bairo cʉ̃ caetajãrõ bero, jicoquei ape nʉgõã tʉpʉ jãã etacoápʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti rʉ̃mʉ busuri rʉ̃mʉ caãno, camasã ʉtabʉcʉra ape nʉgõãpʉ catuaricarã pʉame jĩcãã caãnia cũmua mena jãã capeñaatajere masĩñupã. Tunu bairoa Jesús jãã mena cʉ̃ caápériataje cʉ̃ãrẽ masĩcõãñupã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tipaʉ beroaca aperã Tiberias macããna etayuparã na cũmuu mena, Jesure cʉ̃ macãrã. Bairi, Jesús Diore, “Jãã mena mʉ ñujãñuña,” cʉ̃ caĩ jẽnirĩcãrõ bero, capããrã camasã na capan ʉgaricaropʉ etayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bairo na capan ʉgaricapaʉpʉ etari bero, Jesús bairi jãã cʉ̃ cabuerã cʉ̃ãrẽ jãã bócaetiri, na cũmuupʉ etajãñuparã tunu. Bairo etajãã yua, jããtʉ Capernaupʉ atí acoásúpa Jesure macãráná. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bairo bairi jãã tʉpʉ pẽñaeta yua, atore bairo qũĩ jẽniñawã Jesure: —Jãã Quetiupaʉ, ¿dope bairo bairi mʉ peñaetaáti ʉtabʉcʉra ati nʉgõãpʉre? —qũĩ jẽniñawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩwĩ Jesús: —Cariapea mʉjãã ñiña: Yʉ caátijẽñorĩqũẽ pʉamerẽ, “¿Dope bairo ĩgaro to ĩñati?” ĩ tʉ̃goñarã mee yʉre mʉjãã macãrã atíupa. Pan, mʉjãã caʉgayapirique jʉ̃gori roque yʉre mʉjãã macãrã atíupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʉjãã caʉgapee jeto meerẽ macãña. Ati yepa macããjẽ ʉgarique yoaro mee peticoaya. Mʉjããrẽ yʉ cajogarije yeri capetieti pũna pʉame roquere bʉtioro macãña. Tie pʉame niña capetietie majũ. Torecʉna, yʉ jowĩ yʉ Pacʉ Dios, “Caticõãninucũpeere camasãrẽ na mʉ jogʉ,” ĩ —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩ jẽniñawã Jesure: —¿Dope bairo jãã átibujiocʉti, Dios cʉ̃ caátipeere cʉ̃ carotirore bairo átipeyogarã? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bairo na caĩjẽniñarõ tʉ̃go, atore bairo na ĩ nemowĩ Jesús: —Dios mʉjããrẽ cʉ̃ caátirotirije atore bairo niña: Yʉ, cʉ̃ cajoricʉ, yʉ yaye quetire cariape mʉjãã catʉ̃goʉsaro boyami —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩ jẽniñanemowã Jesure: —¿Ñe ũnie átijẽñorĩqũẽrẽ jãã mʉ áti ĩñoʉati, mʉ yaye quetire cariape jãã catʉ̃goʉsaparore bairo ĩ? ¿Dope bairije jããrẽ mʉ áti ĩñoʉati? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Marĩ ñicʉ̃jãã ãnana desierto cayucʉmanopʉ ãna, ʉgarique maná cawãmecʉtiere ʉganucũñañupã. Dios yaye quetibʉjʉrica tutipʉ cʉ̃ã torea bairo quetibʉjʉya: “Dios pʉame ʉmʉrecóo macããjẽ ʉgarique pan ũnierẽ na jonucũñupĩ,” ĩña ti tutipʉ —qũĩwã Jesure to macããna. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bairo na caĩrõ, atore bairo na ĩwĩ Jesús: —Cariapea mʉjããrẽ ñiña: Moisés ãnacʉ̃ ʉgarique ʉmʉrecóo macããjẽrẽ marĩ ñicʉ̃jãã ãnanarẽ na joesupi. Yʉ Pacʉ pʉame roque na joyupi. Cʉ̃ã niñami ʉmʉrecóo macããjẽ ʉgariquere bairije caroa majũrẽ cajocõãninucũʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yʉ, ʉmʉrecóopʉ caãnacʉ̃ ati yepapʉ Dios cʉ̃ cajoricʉ yʉ ãniña. Pan, Dios cʉ̃ cajorijere bairo yʉ ãniña ati ʉmʉrecóo macããna camasãrẽ. Yeri capetieti pũnarẽ cajoãcʉ̃ yʉ ãniña —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bairo cʉ̃ caĩrõ tʉ̃gorã, bairo qũĩwã Jesure: —Jãã Quetiupaʉ, tie pan ũnierẽ jãã jonucũña —qũĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Bairo na caĩrõ tʉ̃go, atore bairo na ĩnemowĩ Jesús tunu: —Yʉa, yʉ ãniña ʉgarique pããrẽ bairo caãcʉ̃ cacaticõãninucũrĩqũẽrẽ cajoãcʉ̃. Bairi ni ũcʉ̃ yʉtʉ caatígaʉ pʉame di rʉ̃mʉ ũno aʉatãmʉoetigʉmi. Tunu bairo ni ũcʉ̃ yʉ yaye quetire catʉ̃goʉsaʉ di rʉ̃mʉ ũno ñeme jipietigʉmi. Yʉre catʉ̃goʉsarã pʉamerẽ ñe ũnie na rʉsaetigaro na caãniʉseanipee caroa yeri cʉtaje, ĩgʉ ñiña. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mʉjãã pʉame roque yʉ caátiãnierẽ ĩñamirãcʉ̃ã, yʉ mena mʉjãã tʉ̃goñatutuaetiya. Tierea merẽ mʉjããrẽ yʉ quetibʉjʉ yaparomiña. Mʉjãã pʉame mʉjãã tʉ̃gogaetiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nipetiro yʉtʉ caatíparãrẽ mai yʉ Pacʉ pʉame na yeripʉ yʉtʉ na atítʉ̃goñao joroque na ásupi. Bairo cʉ̃ caátana yʉtʉ na caetaro, di rʉ̃mʉ ũno na boeticõã yʉ baietigʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yʉa, ʉmʉrecóopʉ caatácʉ ati yepapʉ etari, yʉ caboro mee, yʉ Pacʉ, yʉre cajoricʉ, cʉ̃ caátirotiriquere áti acʉ́ yʉ baiwʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yʉ Pacʉ, yʉre cajoricʉ, yʉ cʉ̃ caátiroticũrĩqũẽ atore bairo niña: Yʉ yarã nipetiro cʉ̃ cacũrĩcãrãrẽ yʉ canetõrõ boyami. Bairo bairi ati ʉmʉrecóo capetiro caãno, cariaricarã na caãnimiatacʉ̃ãrẽ, narẽ yʉ cacatioro boyami. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yʉ, Dios Macʉ̃, atore bairo yʉ caáto boyami yʉ Pacʉ: Nipetiro camasã yʉ caátiãnierẽ ĩñarĩ bero, yʉ yaye quetire cariape catʉ̃goʉsarã na cacaticõãninucũrõ átirotiyami. Bairo bairi ati ʉmʉrecóo capetiro caãno, cariacoatana na caãnimiatacʉ̃ãrẽ, narẽ yʉ catiogʉ tunu —na ĩ quetibʉjʉwĩ Jesús cʉ̃tʉ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Bairo cʉ̃ caĩrõ tʉ̃gorã, judío majã quetiuparã pʉame cʉ̃ bʉsʉpai jʉ̃goyuparã. Jesús, “Ʉmʉrecóo macããcʉ̃ ʉgarique pan majũrẽ bairo caãcʉ̃ yʉ ãniña,” cʉ̃ caĩrĩjẽ jʉ̃gori, atore bairo ãmeo ĩ bʉsʉpai coteyuparã na majũ: —¿Ãnia, Jesús, José macʉ̃ mee cʉ̃ ãniñati? Cʉ̃ pacʉ, cʉ̃ paco marĩ camasĩrã jeto niñama. Torecʉ, ¿nopẽĩ, “Ʉmʉrecóopʉ caãnacʉ̃ yʉ rui apʉ́ ati yepapʉre,” qũĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bairo na caĩrĩjẽrẽ tʉ̃gomasĩrĩ, atore bairo na ĩwĩ Jesús: —Yʉ bʉsʉpaieticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni jĩcãʉ̃ ũcʉ̃ yʉ atímasĩẽtĩñami, yʉ Pacʉ yʉre cajoricʉ pʉame cʉ̃ yeripʉ yʉtʉ cʉ̃ caatítʉ̃goñapeere cʉ̃ cajooeticõãta. Baipʉa, cʉ̃ cajoata, yʉ yaʉ ãnigʉmi. Bairo caãcʉ̃ ãnirĩ ati ʉmʉrecóo capetiro caãno, cariacoatacʉ cʉ̃ caãnimiatacʉ̃ãrẽ, cʉ̃ yʉ catiogʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios ya tutipʉ tore bairo ĩ woatu quetibʉjʉ cũñañupã profeta majã ãnana: “Dios nipetiro camasãrẽ na masĩõgʉmi cʉ̃ yaye quetire.” Bairi nipetiro yʉ Pacʉ cʉ̃ caquetibʉjʉrijere cariape catʉ̃goʉsarã pʉame yʉtʉ etagarãma, yʉ yaye quetire tʉ̃goʉsagarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ni jĩcãʉ̃ ũcʉ̃ yʉ Pacʉ Diore caĩñarĩcʉ̃ maniñami. Jĩcãʉ̃ã yʉ ãniña cʉ̃rẽ caĩñarĩcʉ̃ cʉ̃ mena caãnacʉ̃ ati yepapʉ caetaricʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cariape mʉjããrẽ ñiña: Yʉ mena catʉ̃goñatutuarã yasietigarãma. Na pʉame caticõã ninucũgarãma tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉa, yʉ ãniña ʉmʉrecóo macããcʉ̃, ʉgarique pan majũrẽ bairo caãcʉ̃. Bairo bairi yeri capetieti pũnarẽ cajoʉ yʉ ãniña yʉ yarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉjãã ñicʉ̃jãã roque desierto cayucʉmanopʉ ãna, ʉgarique maná cawãmecʉtiere ʉgayupa. Tiere ʉgamirãcʉ̃ã, baiyasi peticoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yʉ pʉame, ape wãme ʉgarique ʉmʉrecóo macããjẽ pʉamerẽ mʉjããrẽ quetibʉjʉgʉ ñiña. Tiere caʉgarã caticõã ninucũgarãma tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉa, yʉ ãniña atie ʉgarique pan ʉmʉrecóopʉ caruiatájere bairo caãcʉ̃. Tie pããrẽ caʉgarã caticõã ninucũgarãma. Tie ʉgarique pan ũnie pʉame yʉ rupaʉre bairo niña. Bairo bairi ati ʉmʉrecóo macããna na cacaticõãninucũparore bairo ĩ, yʉ rupaʉ mena roro yʉ baigʉ. Ati ʉmʉrecóo macããna yʉ yaye quetire caborã roro na caátaje wapa jʉ̃gori popiye na cabaiparo ũnorẽã, yʉ pʉame roque popiye yʉ baigʉ na carorije wapa jʉ̃gori, ĩgʉ ñiña.” ");
INSERT INTO cbcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bairo cʉ̃ caĩrõ tʉ̃gorã, judío majã quetiuparã pʉame atore bairo ãmeo ĩwã na majũ: —¿Dopẽĩ ãni, cʉ̃ rupaʉre marĩ cʉ̃ ʉgarotibujiocʉti? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Bairo na caĩrõ tʉ̃gori, atore bairo na ĩwĩ Jesús: —Cariapea mʉjãã ñiña: Yʉ, Camasã Jʉ̃gocʉ, yʉ rupaʉre mʉjãã caʉgaeticõãta, tunu bairoa yʉ riíre mʉjãã caetieticõãta, cacaticõãninucũparã mee mʉjãã tuagarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ni ũcʉ̃ yʉ rupaʉre caʉgaʉ, bairi yʉ rií cʉ̃ãrẽ caetii pʉame caʉ̃petietopʉ ápérigʉmi. Bairo bairi ati ʉmʉrecóo capetiro caãno, cariacoatacʉ cʉ̃ caãnimiatacʉ̃ãrẽ, cʉ̃ yʉ catiocõãgʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ rupaʉ pʉame ʉgarique majũrẽ bairo niña. Yʉ rií cʉ̃ã etirique majũrẽ bairo niña. Tie ʉgarique ati yepa macããjẽ netõjãñurõ caãnimajũrĩjẽ niña. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bairi ni ũcʉ̃ yʉ rupaʉre caʉgaʉ, bairi yʉ rií cʉ̃ãrẽ caetii yʉ mena macããcʉ̃ niñami. Yʉ cʉ̃ã cʉ̃ mena yʉ ãnicõãgʉ. Jĩcãrõrẽ bairo cayericʉna jãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ Pacʉ, yʉre cajoricʉ pʉame, cacaticõãninucũʉ̃ niñami. Cʉ̃ catutuarije jʉ̃gori yʉ ãniña. Torea bairo yʉ rupaʉre caʉgarã cʉ̃ã yʉ catutuarije jʉ̃gori caticõã ninucũgarãma tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bairo bairi ʉmʉrecóo macããjẽ ʉgarique caruiatáje majũrẽ mʉjããrẽ yʉ quetibʉjʉya. Atie ʉgarique maná, mʉjãã ñicʉ̃jãã na caʉganucũrĩqũẽrẽ bairo baietiya. Tie manárẽ ʉgamirãcʉ̃ã, baiyasipeticoásúpa. Pan ʉmʉrecóo macããjẽ caruiatájere caʉgarã roque caticõã ninucũgarãma —na ĩ quetibʉjʉwĩ Jesús cʉ̃tʉ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mai, tiere na quetibʉjʉwĩ Jesús Capernaum macãpʉ judío majã neñarĩ na cañubueri wiipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesure caʉsarã pʉame bairo cʉ̃ caquetibʉjʉrijere tʉ̃gorã, atore bairo ãmeo ĩwã na majũ: —Atie cʉ̃ caquetibʉjʉrije masiriyojãñuña. Noa tiere tʉ̃go ãmewiyoenama —ãmeo ĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bairo Jesús pʉame cʉ̃ camasĩrĩjẽrẽ cʉ̃ na cabʉsʉpairijere tʉ̃goñarĩ yua, atore bairo na ĩwĩ: —¿Bairo yʉ caĩquetibʉjʉrije mena mʉjãã asiao joroque ñiñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bairo tie yʉ yaye quetire mʉjãã catʉ̃gojesoeticõãta, yʉ, Camasã Jʉ̃gocʉ, yʉ caatátopʉ yʉ catunuwãmʉátó ĩñajorã, ¿dope bairo mʉjãã tʉ̃goñabujiorãti? ");
INSERT INTO cbcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dios Yeri Espíritu Santo jeto yeri capetieti pũnarẽ cajomasĩ niñami. Camasã roque rupaʉ tutuarã nimirãcʉ̃ã, na majũã na yeripʉ jomasĩẽtĩñama na cacaticõãninucũpeere. Baipʉa, merẽ mʉjããrẽ yʉ quetibʉjʉapʉ dope bairo yeri capetieti pũnarẽ mʉjãã cacʉ̃gopeere. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bairo mʉjããrẽ yʉ caquetibʉjʉmiatacʉ̃ãrẽ, mʉjãã mena macããna jĩcããrã mai yʉ yaye quetire cariape tʉ̃goetiyama —na ĩwĩ Jesús cʉ̃rẽ catʉ̃goʉsarãrẽ. Mai, caãnijʉ̃goripaʉpʉa merẽ masĩcõãñupĩ Jesús cʉ̃ yaye quetire catʉ̃goʉsaetiparãrẽ. Cʉ̃rẽ cabʉsʉjãbuitipaʉ cʉ̃ãrẽ cʉ̃ masĩjʉ̃goyeticõãñupĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Torecʉ, atore bairo na ĩnemowĩ Jesús tunu: —Mepʉ mʉjããrẽ yʉ caĩata wãmerẽã bairo mʉjããrẽ ñinemoña tunu: Ni jĩcãʉ̃ ũcʉ̃ yʉ yaʉ ãnimasĩẽtĩñami, yʉ Pacʉ pʉame cʉ̃ yeripʉ yʉtʉ cʉ̃ caatígatʉ̃goñapeere cʉ̃ cajooeticõãta —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tipaʉ bero capããrã camasã cʉ̃rẽ caʉsamiatana pʉame cʉ̃ aweyocoátí, cʉ̃ ʉsajãnacõãwã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Bairo na caátó ĩñaʉ, Jesús pʉame, jãã, cʉ̃ cabuerãrẽ atore bairo jãã ĩ jẽniñawĩ: —¿Mʉjãã cʉ̃ã yʉre mʉjãã aweyocoagayati? —jãã ĩ jẽniñawĩ Jesús jãã, cʉ̃ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ cãrõ caãnarẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bairo cʉ̃ caĩrõ, jicoquei atore bairo qũĩwĩ Simón Pedro pʉame: —Jãã Quetiupaʉ, ¿noa pʉamerẽ jãã tʉ̃goʉsabujiocʉti? Mʉ jeto jĩcãʉ̃ã mʉ ãniña caroa yeri pũna caticõãninucũrĩqũẽ macããjẽrẽ caquetibʉjʉ. Ni apei jãã catʉ̃goñatutuaʉ mácʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Merẽ mʉ yaye quetibʉjʉriquere cariape jãã tʉ̃goya. Bairo bairi, “Jãã Quetiupaʉ Jesús, Caroʉ́, Dios cʉ̃ Cajoricʉ majũ niñami,” cariape mʉrẽ jãã ĩ tʉ̃goñaña —qũĩwĩ Simón Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo jãã ĩwĩ Jesús: —Mʉjãã yʉ cabuerã pʉga wãmo peti rʉpore pʉga pẽnirõ cãrõ majũ yʉ cabesericarã mʉjãã ãniña. Bairo tocãnacãʉ̃ yʉ cabesericarã mʉjãã caãnimiatacʉ̃ãrẽ, jĩcãʉ̃ mʉjãã mena macããcʉ̃ wãtĩ quetiupaʉ Satanás cʉ̃ caroti majũ niñami —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Bairo ĩ, Judas Iscariote, Simón macʉ̃rẽ qũĩgʉ ĩwĩ Jesús. Judas pʉame jãã mena macããcʉ̃ pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacãʉ̃ mena macããcʉ̃ nimicʉ̃ã, cabero Jesure cʉ̃ bʉsʉjãbuiti rocacõãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tipaʉ bero Galilea yepapʉ baiñesẽãwĩ Jesús. Judea yepapʉre ágaemi. Mai, topʉ caãna judío majã quetiuparã pʉame Jesure cʉ̃ pajĩãgarã cʉ̃ macãrã baiãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bairo bairi topʉ cʉ̃ caãno, judío majã bose rʉ̃mʉrĩ mena macã rʉ̃mʉ jĩcã rʉ̃mʉ Enramadas cawãmecʉti bose rʉ̃mʉ majũ cõña ató baiwʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bairo ti rʉ̃mʉ cacõñaató ĩñarã, Jesús bairã pʉame atore bairo qũĩwã na jʉ̃gocʉre: —Atopʉ tuaeticõãña. Ácʉ́ja Judea yepapʉre. To macããna mʉrẽ catʉ̃goʉsarã cʉ̃ã mʉ caáti ĩñorĩjẽrẽ na ĩñaáto. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ni jĩcãʉ̃ ũcʉ̃ camasã cʉ̃rẽ na camasĩrõ cʉ̃ cabooata, cayasioropʉ ápeimi cʉ̃ caátimasĩrĩjẽrẽ. Baujaro roque átinucũʉ̃mi. Bairo bairi ati ʉmʉrecóo macããna nipetiro mʉrẽ na masĩáto ĩ, mʉ cʉ̃ã baujaro áti ĩñoʉja mʉ caáti jẽñomasĩrĩjẽrẽ —qũĩ boyeti epewã Jesure cʉ̃ bairã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mai, na, cʉ̃ bairã majũ nimirãcʉ̃ã, “Dios cʉ̃ cajoricʉ niñami marĩ yaʉ Jesús,” ĩ tʉ̃goñamasĩẽma Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Torecʉ, atore bairo na ĩwĩ Jesús: —Noo yʉ cabori rʉ̃mʉ topʉre yʉ ámasĩẽtĩña. Yʉ Pacʉ yʉre Judea yepapʉ yʉ caápá rʉ̃mʉ cʉ̃ cacũrĩcã rʉ̃mʉ etaetiya mai. Mʉjãã roque noo mʉjãã cabori rʉ̃mʉ topʉre mʉjãã ámasĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ati ʉmʉrecóo macããna Diore catʉ̃goʉsaena di rʉ̃mʉ ũno mʉjããrẽ ĩñateetiyama. Yʉ pʉame roquere ñiñatejãñuñama, “Carorije caáticõãna mʉjãã ãniña,” cariape na yʉ caĩrĩjẽ jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉjãã jeto bose rʉ̃mʉrẽ ĩñarájá. Yʉ Pacʉ yʉre cʉ̃ cacũrĩcã rʉ̃mʉ etaetiya mai. Torecʉ, yʉ ámasĩẽtĩña —na ĩwĩ Jesús cʉ̃ bairãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bairo na ĩ yaparori bero, narẽ cʉ̃ caĩrĩcãrõrẽã bairo Galilea yepapʉ tuacõãwĩ mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bairi cʉ̃ bairã Jerusalén macãpʉ bose rʉ̃mʉrẽ na caĩñarã átáto bero roque, cʉ̃ cʉ̃ã bose rʉ̃mʉ ĩñaʉ ácʉ́ baiwĩ. Baipʉa, camasã capããrã cʉ̃rẽ na caĩñajoropʉ ápéwĩ. Bairi yasioro camasã cʉ̃rẽ na caĩñaetopʉ ámí. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bairo ti bose rʉ̃mʉ caãno, judío majã quetiuparã Jesure macãrã: —¿Jõ caãniatacʉ ate? ¿Noopʉ cʉ̃ ãnicʉti? —ãmeo ĩñuparã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mai, topʉ caãna camasã patoaca pʉame, Jesús cʉ̃ caátiãnierẽ ĩñarĩ, atore bairo ãmeo ĩ bʉsʉyupa na majũ: “Caroʉ́ niñami. Cʉ̃ cabuerije cariape niña,” qũĩñuparã jĩcããrã. Aperã pʉame, “Caroʉ́ mee niñami. Cʉ̃ cabuerije jʉ̃gori camasãrẽ na tʉ̃goña mawijiao joroque ácʉ átiyami,” ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bairãpʉa, nipetiro camasã, judío majã quetiuparãrẽ na uwirã, na catʉ̃gojoropʉ Jesure na catʉ̃goñarĩjẽrẽ na bʉsʉ ĩñoema, marĩ tutirema, ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bairo bairi Jesús pʉame Jerusalén macãpʉ etari bero, na cabose rʉ̃mʉ qũẽno recomacã cʉtipaʉre Dios ya wii templo wiire jããetawĩ. Bairo jããetari yua, to macããna camasãrẽ na quetibʉjʉ jʉ̃goámi. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bairo cʉ̃ caquetibʉjʉrijere tʉ̃gorã, jĩcããrã judío majã quetiuparã pʉame cʉ̃ tʉ̃go acʉacoama: —Ãnia, cabueetacʉ nimicʉ̃ã, ¿dopẽĩ tocãrõ capee wãme majũ cʉ̃ masĩñati? —ãmeo ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Bairo na caĩrõ tʉ̃goʉ, atore bairo na ĩwĩ Jesús: —Yʉ cabuerije yʉ yaye mee niña. Yʉ Pacʉ yʉre cajoricʉ yaye macããjẽ pʉame roque niña. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ni ũcʉ̃ Dios cʉ̃ caboro caátigaʉ pʉame yʉ cabuerijere tʉ̃gori bero, “Cariapea niña. Dios cʉ̃ carotiro mena quetibʉjʉyami Jesús,” o “Cʉ̃ majũã cʉ̃ caboro mena bʉsʉyami,” ñi besemasĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ majũã cʉ̃ caboro mena cabʉsʉnucũʉ̃ pʉame, camasã, “Caãnimajũʉ̃rẽ bairo niñami,” cʉ̃ na ĩáto ĩ, na quetibʉjʉyami. Apei, “Nipetiro camasã cʉ̃rẽ cajoricʉre na ĩroáto,” caĩ pʉame roque cariape quetibʉjʉ átiyami. Bairo caĩ ãnirĩ di rʉ̃mʉ ũno ĩtoecʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Apeyera tunu Moisés ãnacʉ̃, ¿Dios cʉ̃ caroticũrĩqũẽrẽ mʉjãã ñicʉ̃jãã ãnana mena mee cʉ̃ cũñuparĩ? Na menaa cũñupĩ. Bairo tiere cʉ̃ cacũmiatacʉ̃ãrẽ, ni ũcʉ̃ mʉjãã mena macããcʉ̃, Moisés ãnacʉ̃ cʉ̃ carotiriquere catʉ̃goʉsaʉ mácʉ̃mi. Bairo bairi mʉjããrẽ ñiña: ¿Nopẽĩrã yʉre mʉjãã pajĩãgayati?” na ĩwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩwã to caãna Jesure: —¿Noa mʉrẽ na pajĩãgayati? ¡Cawãtĩ yeri pũnacʉcʉ mʉ ãcʉ̃! —qũĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Bairo na caĩrõ tʉ̃goʉ, bairo na ĩwĩ Jesús: —Mʉjãã nipetirã mʉjãã cayerijãrĩ rʉ̃mʉ caãno cariaricʉre cʉ̃ yʉ canetõrõ mʉjãã ĩña acʉacoapʉ. Bairo caĩña acʉaricarã ãnirĩ, yʉ mʉjãã pajĩãgaya, ti rʉ̃mʉrẽ jĩcã wãmea yʉ caátaje caãnimiatacʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mʉjãã cʉ̃ã paariquere bairo mʉjãã átinucũña ati rʉ̃mʉ ũnorẽ. Moisés ãnacʉ̃ mʉjãã pũnaa rupaʉ macããjẽrẽ yiseta rotiriquere mʉjããrẽ átirotiyupi. (Mai, Moisés ãnacʉ̃ tiere cʉ̃ caroticũrĩqũẽ jʉ̃goyepʉa, aperã mʉjãã ñicʉ̃jãã pʉame roque tiere átijʉ̃goasúpa.) Bairo bairi mʉjãã pʉame tie na caátiroticũrĩqũẽrẽ tʉ̃goʉsarã, mʉjãã pũnaa na cabuiatato bero, torea bairo na mʉjãã átinucũña yerijãrĩcã rʉ̃mʉ caãnimiatacʉ̃ãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bairo bairi Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ cõñarĩcãrõrẽ bairo átigarã, mʉjãã pũnaa rupaʉ macããjẽrẽ yisetariquere mʉjãã átirotinucũña, yerijãrĩcã rʉ̃mʉ caãnimiatacʉ̃ãrẽ. Bairo átirotinucũmirãcʉ̃ã, yerijãrĩcã rʉ̃mʉ caãno jĩcãʉ̃rẽ cʉ̃ yʉ cariaye netõrõ ĩñamirãcʉ̃ã, ¿dopẽĩrã yʉ paarique macããjẽrẽ mʉjãã ĩñateyati? ");
INSERT INTO cbcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yʉ catʉ̃goñarĩjẽrẽ camasĩẽna ãnirĩ, yʉ caátiãnierẽ tocãrõã yʉ bʉsʉpaijãnaña. Ni jĩcãʉ̃ ũcʉ̃rẽ cʉ̃ caátiãnierẽ mʉjãã caĩñabesegaata, caroaro cariape tʉ̃goñarĩ qũĩñabeseya. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bairo Jerusalén macãpʉ Jesús camasãrẽ na cʉ̃ caquetibʉjʉripaʉ caãno to macããna jĩcããrã atore bairo ãmeo ĩwã na majũ Jesure ĩñarĩ: —¿Ãnia, na capajĩãrocaganucũʉ̃ mee cʉ̃ ãniñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nipetiro camasã na catʉ̃gojoropʉ na quetibʉjʉ ãniñami. Bairo nipetiro na caĩñarõpʉ cʉ̃ caquetibʉjʉmiatacʉ̃ãrẽ, ¿ñerẽ ána, “Jãna ácʉ́ja,” cʉ̃ na ĩẽtĩñati marĩ quetiuparã? Toroquere, “Ãni, Mesías, Dios cʉ̃ cajoricʉa ãcʉ̃mi,” ¿cʉ̃rẽ na ĩ tʉ̃goñaroayati? ");
INSERT INTO cbcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bairãpʉa, nipetiro camasã, “Mesías, Dios cʉ̃ cajopaʉ ati yepapʉ cʉ̃ caetaro, ni jĩcãʉ̃ ũcʉ̃ noopʉ cʉ̃ caatíatajere masĩẽtĩgʉmi,” marĩ ĩ tʉ̃goñamasĩña. Ãni, Jesús roquere, “To macããcʉ̃ niñami,” cʉ̃ marĩ ĩ masĩcõãña. Dios cʉ̃ cajoricʉ majũ cʉ̃ caãmata roque, “To macããcʉ̃ niñami,” cʉ̃ marĩ ĩ masĩẽtĩbujiorã —ãmeo ĩwã to macããna, tʉ̃goñamawijiarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bairo na caãmeo ĩrõ tʉ̃goʉ, Jesús pʉame Dios ya wii templo wiipʉ cabueãniatacʉ atore bairo na ĩwĩ bʉsʉrique tutuaro mena: —“Cʉ̃ jãã masĩña Jesure. Cʉ̃ caãni macã cʉ̃ãrẽ jãã masĩña,” yʉ mʉjãã ĩmiña. ¡Bairo ĩmirãcʉ̃ã, yʉre cajoricʉre cʉ̃ mʉjãã masĩẽtĩña! Yʉ caboro mee yʉ apʉ́ ati yepapʉre. Apei cʉ̃ cajoricʉ yʉ ãniña. Bairi tocãnacãʉ̃pʉa camasã cʉ̃ mena na catʉ̃goñatutuapeere boya. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bairo yʉ pʉame cʉ̃ cajoricʉ ãnirĩ, caroaro cʉ̃ yʉ masĩña —na ĩwĩ Jesús to macããna quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bairo cʉ̃ caĩrõ tʉ̃gori, cʉ̃ mena asiajãñuwã. Bairo asiari, jicoquei cʉ̃ ñegamiwã. Bairo cʉ̃ ñegamirãcʉ̃ã, Dios cʉ̃ cacũrĩcãpaʉ caetaeto jʉ̃gori cʉ̃ ñemasĩẽma mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bairãpʉa, aperã capããrã camasã qũĩroawã Jesure. Atore bairo cʉ̃ caátiãnierẽ ãmeo ĩwã na majũ: —Mesías, Dios cʉ̃ cabesericʉ, ati yepapʉ acʉ́, ¿ãni, Jesús, cʉ̃ caáti ĩñorĩjẽ netõrõ cʉ̃ átimasĩati? Bairo ápeimi. Torena, cʉ̃ã ãniñami Mesías —ãmeo ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mai, fariseo majã pʉame camasã Jesure na caĩroarije quetire tʉ̃goyupa. Bairo tʉ̃gori, jicoquei Jesure cʉ̃ ñegamiñupã. Bairo bairi na, aperã sacerdote majã quetiuparã mena templo wiire cacoterã soldauare na joyupa Jesús tʉpʉ, “Cʉ̃ na ñeáto,” ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Bairo na caetaro ĩñaʉ, atore bairo na ĩwĩ Jesús to macããna camasãrẽ: —Mʉjãã mena tocãnacã rʉ̃mʉ yʉ ãnicõãmerĩnucũgʉ. Cabero yʉre cajoricʉ tʉpʉ yʉ ácoagʉ tunu. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉre mʉjãã macãmigarã. Bairo yʉ macãmirãcʉ̃ã, yʉ caátípaʉpʉre caetamasĩẽna ãnirĩ, yʉ mʉjãã bócaetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bairo cʉ̃ caĩrõ tʉ̃gorã, judío majã quetiuparã pʉame atore bairo ãmeo ĩ jẽniñawã na majũ: —¿Noopʉ cʉ̃ ágabauyati ãni, “Yʉ mʉjãã bócaetigarã,” caĩã? ¿Marĩ yarã judío majã ape yepa macããna tʉpʉ caábataricarãrẽ na cʉ̃ quetibʉjʉ ñesẽãgabauyati? o, ¿ape yepa macããna cʉ̃ãrẽ cʉ̃ quetibʉjʉ ñesẽãgabauyati? ");
INSERT INTO cbcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Dope bairo ĩgʉ, “Yʉ caãnipaʉpʉre mʉjãã ámasĩẽtĩgarã. Bairo yʉ macãmirãcʉ̃ã, yʉ mʉjãã bócaetigarã,” marĩrẽã qũĩñati? —ãmeo ĩ jẽniñawã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bairo bose rʉ̃mʉrĩ caãnitʉsari rʉ̃mʉ caãnimajũrĩ rʉ̃mʉ caãno, Jesús pʉame wãmʉnʉcãwĩ. Bairo wãmʉnʉcãrĩ bʉsʉrique tutuaro mena atore bairo na ĩ quetibʉjʉwĩ to macããnarẽ: —Cañemejipirã, yʉ tʉpʉ oco etirasá. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bairo yʉtʉ mʉjãã caetiro, mʉjãã yeri pũnapʉre ria oco ũmayurore bairo cacatiorije nigaro. Torea bairo ĩ quetibʉjʉya Dios yaye bʉsʉrica tutipʉ cʉ̃ãrẽ —na ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mai, Jesure catʉ̃goʉsarã na yeri pũnapʉre ria oco ũmayurore bairo cabairijere quetibʉjʉ, “Espíritu Santore na yeri pũnapʉ cabairijere,” ĩ quetibʉjʉgʉ ĩwĩ Jesús. “Ñe ũnie rʉsaricaro mano cʉ̃gogarãma Espíritu Santo cʉ̃ camasĩrĩjẽrẽ,” ĩ quetibʉjʉgʉ ĩwĩ. Mai, Espíritu Santo pʉame camasã yeripʉre ñajããetaemi, Jesús ʉmʉrecóopʉ cʉ̃ cawãmʉápéro jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bairo cʉ̃ caĩrõ tʉ̃gorã, na mena macããna jĩcããrã atore bairo ãmeo ĩwã na majũ: —Cariape cʉ̃ã profeta Dios cʉ̃ cajopaʉ marĩ ñicʉ̃jãã na caĩquetibʉjʉ jʉ̃goyetiricʉ majũ niñami —ãmeo ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Atore bairo ãmeo ĩwã aperã cʉ̃ã: —Ãnia, Jesús, Mesías, Dios cʉ̃ cabesericʉ majũ niñami —ãmeo ĩwã na majũ. Bairo na caĩrõ tʉ̃gomirãcʉ̃ã, atore bairo ĩwã aperã tunu: —Cʉ̃ mee niñami. Dios cʉ̃ cabesericʉ majũ cʉ̃ caãmata, Galilea yepa macããcʉ̃ ãmerĩbujioʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios yaye quetibʉjʉrica tutipʉ atore bairo marĩ ĩ quetibʉjʉya: “Mesías, Dios cʉ̃ cabesericʉ pʉame, quetiupaʉ rey David ãnacʉ̃ pãrãmi nigʉmi. Bairo caãcʉ̃ ãnirĩ, David ãnacʉ̃ cʉ̃ caãna macã, Belén cawãmecʉti macã macããcʉ̃ ãnigʉmi,” ĩ quetibʉjʉya Dios yaye cʉ̃ caquetibʉjʉcũrĩqũẽ —ãmeo ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bairo camasã Jesús cʉ̃ caátiãnierẽ tʉ̃goñarĩ, jĩcãrõrẽ bairo yericʉpewa. Bairi na majũ ricaati jeto ãmeo tʉ̃goñarĩqũẽ ricawaticõãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Na mena macããna jĩcããrã preso jorica wiipʉ cʉ̃ neágamiwã. Bairo átigamirãcʉ̃ã, cʉ̃ neámasĩẽma. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bairo bairi soldaua Dios ya wii coteri majã pʉame tunucoásúparã fariseo majã, bairi sacerdote majã quetiuparã tʉpʉ. Bairo topʉ na caetaro ĩñarã, atore bairo na ĩñuparã sacerdote majã quetiuparã narẽ: —¿Nopẽĩrã Jesure cʉ̃ mʉjãã ñeapériati? —na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Soldaua pʉame atore bairo na ĩ yʉyuparã sacerdotea quetiuparãrẽ: —¡Jĩcãʉ̃, cʉ̃rẽ bairo caĩquetibʉjʉre di rʉ̃mʉ ũno jãã tʉ̃goetimajũcõãnucũwʉ̃! —na ĩñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bairo na caĩrõ tʉ̃gorã, fariseo majã pʉame atore bairo na ĩñuparã tunu: —¿Bairi mʉjãã cʉ̃ã ato cʉ̃rẽ caĩtoecorãrẽ bairo tuarã mʉjãã baiyati? ");
INSERT INTO cbcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¡Ni jĩcãʉ̃ ũcʉ̃ marĩ mena macããcʉ̃ quetiupaʉ, o fariseo majõcʉ cʉ̃rẽ catʉ̃goʉsaʉ mácʉ̃mi! ");
INSERT INTO cbcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bairo cʉ̃rẽ marĩ catʉ̃goʉsaetimiatacʉ̃ãrẽ, ati macã macããna, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ camasĩẽna roque, cʉ̃ tʉ̃goʉsarã átiyama. Torena, moena Dios popiye cʉ̃ caátiparã majũ tuayama —na ĩñuparã fariseo majã ñerotirã na cajomiatana soldauare. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Bairo na caĩrõ tʉ̃gori, Nicodemo, ñamipʉ Jesure caĩñaʉ etaricʉ, jĩcãʉ̃ fariseo majã mena macããcʉ̃ pʉame atore bairo na ĩñupʉ̃: ");
INSERT INTO cbcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Marĩ ñicʉ̃jãã na caroticũrĩqũẽrẽ tʉ̃gori, atore bairo marĩrẽ caátipee niña: Ni ũcʉ̃ camasocʉ roro cʉ̃ caátajere caroaro ĩñaetimirãcʉ̃ã, cʉ̃ majũ cʉ̃ caquetibʉjʉetoa, cʉ̃ marĩ popiye átimasĩẽtĩbujiorã. Cʉ̃ caquetibʉjʉro bero, rorije cʉ̃ caátajere masĩrĩ bero roque, cariape cʉ̃ marĩ popiye átimasĩbujiorã —na ĩñupʉ̃ Nicodemo, cʉ̃ mena macããna fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩñuparã tunu: —¿Mʉ cʉ̃ã Galilea yepa macããcʉ̃ mʉ ãniñati? Dios yaye quetibʉjʉrica tutipʉ buenemoña. Ni jĩcãʉ̃ ũcʉ̃ profeta majõcʉ caãnipaʉ Galilea yepai caacʉ́ manigayupi —qũĩ tutiyuparã Nicodemorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bairo bairi cabero camasã Jerusalén macãpʉ bose rʉ̃mʉ caetaatana pʉame na ya wiiripʉ tunu peticoámá. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús pʉame roque Jerusalẽpʉ tʉari, Olivo cawãmecʉti buropʉ ámí. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bairo cabusuri rʉ̃mʉ caãno Dios ya wii templo wii ámí Jesús tunu. Bairo to macããna camasã Jesure qũĩñarĩ, cʉ̃ tʉpʉ neñapowã, cʉ̃ caquetibʉjʉrijere tʉ̃gogarã. Bairo na cabairo ĩñaʉ, Jesús pʉame topʉ ruiri na quetibʉjʉ jʉ̃gowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bairo narẽ cʉ̃ caquetibʉjʉãnipaʉre, Moisés ãnacʉ̃ cʉ̃ caquetibʉjʉcũrĩqũẽrẽ cajʉ̃gobueri majã, bairi fariseo majã cʉ̃ã Jesús tʉpʉ etawã. Jĩcãõ carõmio cõ manapʉ mee caãcʉ̃ mena roro caátiatacore nipetiro camasã na caĩñajoropʉ cõ ne etawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bairo cõ ne eta yua, atore bairo qũĩwã Jesure: —Jãã Quetiupaʉ, atio carõmio cõ manapʉ mee caãcʉ̃ mena roro caácore jãã bócaetaapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Marĩ ñicʉ̃ Moisés ãnacʉ̃ cʉ̃ caroticũrĩcã tutipʉ, cõrẽ bairo caánarẽ ʉ̃tã rupaa mena wẽẽjĩãre rotiyupi. ¿Mʉate, dope bairo miñati? —qũĩ jẽniñañuparã fariseo majã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tore bairo qũĩ jẽniñawã Jesure, roro cʉ̃ bʉsʉáto, ĩrã. Na quetiuparãrẽ cʉ̃ caĩrĩjẽrẽ bʉsʉjãbuitigarã ĩwã. Bairo na caĩrõ tʉ̃gori, Jesús pʉame mubianumuáti yua, cʉ̃ wãmojũã mena yepapʉ woawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bairo cʉ̃rẽ na cajẽniña jãnaeto tʉ̃gori, camubiatacʉ wãmʉ nʉcãrĩ, atore bairo na ĩwĩ Jesús: —Mʉjãã mena macããcʉ̃ jĩcãni ũno carorije caátiñaetacʉ cʉ̃ caãmata, ʉ̃tããrẽ nerĩ, cõrẽ cʉ̃ wẽẽ jʉ̃goáto —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bairo ĩ yaparo, yepapʉ mubia numuáti tunu, cʉ̃ wãmojũã mena woatunemowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bairo cʉ̃ caĩrĩjẽrẽ tʉ̃gori fariseo majã pʉame witipeticõámá, jĩcãʉ̃rĩ jeto yua. Mai, cabʉtoa pʉame witiájʉ̃gowã. Na bero aperã cʉ̃ã witiámá. Bairi Jesús pʉame jĩcãʉ̃ã carõmio mena tuacõãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Bairo cabero wãmʉnʉcãrĩ, carõmio jĩcãõã cõ caãno ĩñaʉ, atore bairo cõ ĩwĩ: —¿Mʉrẽ cabʉsʉjãatana noo na áyati? ¿Ni jĩcãʉ̃ ũcʉ̃, “Mʉ carorije wapa mʉ buicʉtiya,” caĩ ũcʉ̃ cʉ̃ maati yua? —cõ ĩwĩ Jesús carõmiorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Bairo cʉ̃ caĩrõ tʉ̃go: —Ni jĩcãʉ̃ ũcʉ̃ maniñami —qũĩwõ. Bairo cõ caĩrõ, Jesús pʉame atore bairo cõ ĩwĩ tunu: —Yʉ cʉ̃ã, “Mʉ buicʉtiya,” mʉ ñiecʉ̃. Tunu ácója. Carorijere átinemoeticõãña yua —cõ ĩwĩ Jesús carõmiorẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Cabero tunu Jesús camasãrẽ na quetibʉjʉnemogʉ, atore bairo na ĩ cõña quetibʉjʉwĩ: —Ati ʉmʉrecóo macããnarẽ cajĩñawoʉre bairo caãcʉ̃ yʉ ãniña. Bairi ni ũcʉ̃ yʉre catʉ̃goʉsaʉ pʉame caroaro cariape tʉ̃goñamasĩgʉmi. Tie cʉ̃ yʉ camasĩõjorije jʉ̃gori yeri capetieti pũnarẽ cʉ̃gogʉmi —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩwã fariseo majã Jesure: —Mʉ majũã mʉ caátiãnipeere quetibʉjʉ mʉ átiya. Apei mʉrẽ cajʉĩnemoʉ mácʉ̃mi. Bairi mʉ caquetibʉjʉrije wapa maa —qũĩwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Bairo na caĩrõ tʉ̃gori yua, atore bairo na ĩwĩ Jesús fariseo majãrẽ: —Yʉ majũã yʉ caátiãninucũrĩjẽrẽ yʉ caquetibʉjʉmiatacʉ̃ãrẽ, yʉ caĩquetibʉjʉrije caãnimajũrĩjẽ majũ nicõãña. Yʉ caãnatõrẽ, bairi tunu yʉ caápáropʉ cʉ̃ãrẽ yʉ masĩña. Mʉjãã pʉame roque, “Topʉ caatácʉ niñami,” o “Topʉ caápáʉ niñami,” yʉ mʉjãã ĩ masĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ati ʉmʉrecóo macããna na caĩñabesenucũrõrẽ bairo mʉjãã ĩñabeseya mʉjãã cʉ̃ã. Yʉ pʉame roque ni jĩcãʉ̃ ũcʉ̃ cʉ̃ caátiãnie jʉ̃gori ñiñabeseetiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bairo yʉ caápata roque, cariapea mʉjããrẽ ñiñabesebujioʉ. Yʉ majũã yʉ caboro ñiñabese masĩẽtĩña. Yʉ Pacʉ yʉre cajoricʉ mena roque ñiñabese masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉjããrẽ carotirije, atore bairo niña: Apei jĩcãʉ̃ cʉ̃ caátajere pʉgarã camasã na caĩñarĩqũẽrẽ quetibʉjʉrã, na pʉgarãpʉa caroaro jĩcãrõ tʉ̃ni na caĩquetibʉjʉ netõata, na caquetibʉjʉrije cariape niña, ĩ quetibʉjʉya. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Bairo bairi yʉa, jĩcãʉ̃ yʉ ãniña, “Yʉ caátiãnierẽ cariapea niña,” caĩquetibʉjʉ. Yʉ Pacʉ yʉre cajoricʉ cʉ̃ã torea bairo jĩcãrõ tʉ̃ni quetibʉjʉyami. Bairi jãã yaye quetire mʉjãã catʉ̃goʉsaro ñuña —na ĩwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩ jẽniñanemowã Jesure tunu: —¿Toroquere, noopʉ mʉ pacʉ cʉ̃ ãnicʉti? Bairo cʉ̃rẽ na cajẽniñarõ tʉ̃go, atore bairo na ĩ yʉwĩ Jesús: —Yʉre mʉjãã masĩẽtĩña. Bairi yʉ Pacʉ roquere nemorõ mʉjãã masĩẽna. Yʉre mʉjãã camasĩata, yʉ Pacʉ cʉ̃ãrẽ mʉjãã masĩbujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mai Jesús, bairo atiere na quetibʉjʉ, Dios ya wii templo wiipʉ ãmi. Camasã dinero jorã na cajããrĩ patari tʉpʉ nucũwĩ. Topʉ cʉ̃ caãno, judío majã quetiuparã dope bairo roro cʉ̃ átimasĩẽma. Dios cʉ̃rẽ cʉ̃ cacũrĩcã rʉ̃mʉ caetaetoi, cʉ̃ ñemasĩẽma mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Atore bairo na ĩnemowĩ Jesús judío majã quetiuparãrẽ: —Caápáʉ yʉ ãniña. Bairo yʉ caátó bero, yʉ mʉjãã macãgarã. Bairo macãmirãcʉ̃ã, yʉ mʉjãã bócaetigarã. Yʉ caátípaʉpʉre mʉjãã ámasĩẽtĩña. Bairo bairi carorije mʉjãã caátiãninucũrĩjẽ mena mʉjãã baiyasicoagarã —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bairo cʉ̃ caĩrõ tʉ̃gorã, judío majã quetiuparã pʉame atore bairo ãmeo ĩ jẽniñawã na majũ: —“Yʉ caátópʉre mʉjãã ámasĩẽna,” cʉ̃ caĩata, ¿cʉ̃ majũã pajĩãyasigʉ qũĩñati? —ĩwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Bairo na caãmeoĩrõ tʉ̃gori, atore bairo na ĩ nemowĩ Jesús: —Mʉjãã, ati ʉmʉrecóo macããna mʉjãã ãniña. Yʉ pʉame roque jõbuipʉ macããcʉ̃ yʉ ãniña. Ati yepa macããcʉ̃ mee yʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bairi merẽ cajʉ̃goye torea bairo mʉjããrẽ yʉ quetibʉjʉapʉ: “Roro mʉjãã caátie wapa jʉ̃gori mʉjãã baiyasigarã,” mʉjãã ñiapʉ̃. “Mesías, Dios macʉ̃ majũã niñami,” yʉ mʉjãã ĩ tʉ̃goñaẽtĩña. Torena, roro mʉjãã caátinucũrĩjẽ mena mʉjãã baiyasigarã —na ĩwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bairo cʉ̃ caĩrõ tʉ̃gorã, atore bairo qũĩ jẽniñanemowã Jesure: —¿Mʉa, ni ũcʉ̃ majũ mʉ ãniñati? Bairo na caĩjẽniñarõ tʉ̃go, Jesús pʉame atore bairo na ĩwĩ: —Caãnijʉ̃goripaʉpʉa mʉjããrẽ merẽ yʉ caãnierẽ yʉ quetibʉjʉ jʉ̃gomiwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Apeyera tunu capee majũ niña mʉjããrẽ yʉ caquetibʉjʉgarije. Roro mʉjãã caátie jʉ̃gori mʉjããrẽ popiye yʉ caátipee cʉ̃ã niña. Yʉre cajoricʉ pʉame cariape caquetibʉjʉ niñami. Bairo bairi cʉ̃ caquetibʉjʉriquere catʉ̃goricʉ ãnirĩ mʉjãã ati yepa macããnarẽ cariapea mʉjãã yʉ quetibʉjʉnetõña —na ĩwĩ Jesús judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bairo narẽ cʉ̃ caĩquetibʉjʉro, na pʉame cʉ̃ tʉ̃gomasĩẽma. Cʉ̃ pacʉre na ĩ quetibʉjʉ ĩmiwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bairi atore bairo na ĩnemowĩ Jesús: —Yʉ, Camasã Jʉ̃gocʉre, jõbui yucʉpãĩpʉ yʉre mʉjãã capapuaturotiropʉ, Mesías, Dios macʉ̃ majũ yʉ caãnierẽ mʉjãã ĩñamasĩgarã yua. Yʉa, yʉ Pacʉ yʉre cʉ̃ caquetibʉjʉricaro cãrõã mʉjãã camasãrẽ yʉ quetibʉjʉnucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉ Pacʉ yʉre cajoricʉ pʉame yʉ mena nicõãñami. Yʉ caátiãnierẽ ĩñarĩ catʉ̃goñaʉseani ãcʉ̃ ãnirĩ di rʉ̃mʉ ũno yʉ aweyoetiyami —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bairo Jesús cʉ̃ caquetibʉjʉrijere tʉ̃gorã, to macããna capããrã camasã qũĩroa jʉ̃gowã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Cabero atore bairo ĩwĩ Jesús judío majã cʉ̃rẽ catʉ̃goʉsajʉ̃gorã pʉamerẽ: —Yʉ caquetibʉjʉrijere caroaro cariape mʉjãã catʉ̃goʉsa ãmata, yʉ yarã, yʉ cabueri majã majũ, mʉjãã tuagarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tunu bairoa cariape macããjẽ quetibʉjʉriquere mʉjãã masĩgarã. Bairo tiere caroaro cariape mʉjãã camasĩata, ni ũcʉ̃rẽ carotiecorãrẽ bairo mʉjãã baietigarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩwã Jesure: —¿Nopẽĩ, “Ni ũcʉ̃rẽ carotiecorãrẽ bairo mʉjãã baietigarã,” jãã miñati? Jãã, Abraham ãnacʉ̃ pãrãmerã caãnibuipearã majũ jãã ãniña. Ni ũcʉ̃ cʉ̃ carotirijere caáticotenucũrĩcãrã mee jãã ãniña —qũĩwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús atore bairo na ĩnemowĩ tunu: —Cariape mʉjããrẽ ñiña: Nipetirã carorije caána roro na caátinucũrĩjẽrẽ jãnamasĩẽtĩñama. Bairi carorijere caátirotiecocõãninucũrã majũ tuayama. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jĩcãʉ̃ ũcʉ̃ aperãrẽ paacoteri majõcʉ cʉ̃ caãmata, cʉ̃ ya wii macããna mena macããcʉ̃ ãmerĩcõã ninucũñami. Cʉ̃, quetiupaʉ macʉ̃ pʉame roque cʉ̃ ya wii macããna mena macããcʉ̃ majũ nicõã nigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Torecʉ, yʉ, Dios macʉ̃ ãnirĩ carorije mʉjãã caátinucũrĩjẽrẽ carotiire mʉjãã netõbojaʉ acʉ́ yʉ apʉ́. Bairo mʉjããrẽ yʉ canetõbojaro bero, carorije macããjẽrẽ cajãnarĩcãrã majũ mʉjãã tuacõãgarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Merẽ yʉ masĩña Abraham ãnacʉ̃ pãrãmerã majũ mʉjãã caãnierẽ. Cʉ̃ pãrãmerã nimirãcʉ̃ã, yʉ caquetibʉjʉrijere cabaibotiorã ãnirĩ yʉre mʉjãã pajĩãga coteãninucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉ Pacʉ yʉre cʉ̃ caquetibʉjʉrotijoriquerea mʉjãã yʉ quetibʉjʉnucũña. Mʉjãã pʉame roque mʉjãã pacʉ cʉ̃ carotirijere catʉ̃gorã ãnirĩ cʉ̃ caátore bairo mʉjãã átinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na pʉame atore bairo qũĩwã: —¡Jãã ñicʉ̃ ãnacʉ̃ majũ niñami Abraham! Bairo na caĩrõ, atore bairo na ĩwĩ Jesús tunu: —Abraham ãnacʉ̃ pãrãmerã majũ mʉjãã caãmata, cʉ̃ caátiãninucũñarĩcãrõrẽã bairo mʉjãã átiãnibujiorã. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yʉ Pacʉ cʉ̃ caquetibʉjʉrije cariape caãnierẽ yʉ caquetibʉjʉmiatacʉ̃ãrẽ, yʉ mʉjãã pajĩãgaya. ¡Abraham ãnacʉ̃ pʉame tore bairo caápei ãñupĩ! ");
INSERT INTO cbcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉjãã pacʉ cʉ̃ caátinucũrõrẽ bairo mʉjãã átiya mʉjãã cʉ̃ã —na ĩwĩ Jesús. Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩwã: —Jãã pacʉa noo caboro átieperi na capũnaa cʉtana mee jãã niña. ¡Jããrã, jãã pacʉ Dios jĩcãʉ̃ã niñami! ");
INSERT INTO cbcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús na ĩnemowĩ tunu: —Cariapea, “Dios, jãã pacʉa niñami,” mʉjãã caĩata, yʉ cʉ̃ãrẽ mʉjãã maibujiorã. Yʉa, Dios tʉpʉ caãnacʉ̃ yʉ apʉ́. Yʉ majũã yʉ caboro jʉ̃gori yʉ apéwʉ. Dios pʉame roque yʉre yʉ jowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bairi, ¿nopẽĩrã yʉ caquetibʉjʉrijere mʉjãã tʉ̃goʉsagaetiyati? Atore bairo niña: Yʉ caquetibʉjʉrijere catʉ̃gogaena ãnirĩ tiere mʉjãã tʉ̃gonʉcʉ̃bʉgogaetiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉjãã pacʉ wãtĩ niñami. Cʉ̃ yarã mʉjãã ãniña. Bairi cʉ̃ caborije pʉamerẽ mʉjãã átiganucũña. Caãnijʉ̃goripaʉpʉa cañuecʉ̃ camasãrẽ capajĩãrei ãnijʉ̃goyupi. Cariape caápei majũ niñami. Jĩcã wãme ũnoacã cariape quetibʉjʉetinucũñami. Caĩtopai majũ niñami. Bairo caĩtopai ãnirĩ caĩtopairã pacʉ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Torena mʉjãã, cʉ̃ mena macããna ãnirĩ cariape macããjẽ yʉ caquetibʉjʉrije pʉamerẽ cariape mʉjãã tʉ̃goetiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Bairi ni pʉame mʉjãã mena macããcʉ̃, “Ati wãme carorijere caátacʉ majũ niñami,” cariapea yʉre qũĩ masĩñati? Cariape yʉ caquetibʉjʉrije to ãnimiatacʉ̃ãrẽ, ¿nopẽĩrã yʉre mʉjãã tʉ̃goʉsaetiyati? ");
INSERT INTO cbcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios yarã caãna caroaro tʉ̃goʉsayama Dios yaye quetire. Mʉjãã, Dios yarã mee ãnirĩ yʉ caquetibʉjʉrijere mʉjãã tʉ̃goʉsagaetiya —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩwã judío majã: —Samaria yepa macããcʉ̃ mʉ ãcʉ̃. Tore bairo ĩrã, cawãtĩ cʉ̃goʉ cariapea mʉrẽ jãã ĩña —qũĩ tutiwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Bairo na caĩtutiro tʉ̃go, atore bairo na ĩwĩ Jesús: —Cawãtĩ cʉ̃goʉ mee yʉ ãniña. Yʉ Pacʉ roquere cʉ̃ nʉcʉ̃bʉgoʉ yʉ átiya. Mʉjãã pʉame roque yʉ caátiere ĩñarã, “Carorijere caácʉ niñami,” yʉ mʉjãã ĩnucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Caroaro yʉ caátinucũrĩjẽrẽ ácʉ, “Caãnimajũʉ̃ niñami,” camasã yʉre na ĩáto ĩ mee yʉ baiya. Jĩcãʉ̃ pʉame yʉre camasã na caĩroapeere cʉ̃ caboro jʉ̃gori roque yʉ baiya. Bairi camasã yʉre caĩroaena pʉamerẽ popiye na baio joroque na átigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cariapea mʉjãã ñiña: Yʉ caquetibʉjʉrijere catʉ̃goʉsarã baiyasietigarãma —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩwã judío majã: —“Yʉ caquetibʉjʉrijere catʉ̃goʉsarã baiyasietigarãma,” mʉ caĩrĩjẽrẽ tʉ̃gori, cariapea, “Cawãtĩ cʉ̃goʉ majũã niñami,” mʉrẽ jãã ĩ masĩña. Cajʉ̃goye macããna profeta majã ãnana nipetirã baiyasi peticoasupa. Abraham ãnacʉ̃ cʉ̃ã baiyasicoasupi. Mʉ pʉame, ¿dopẽĩ, “Yʉ yaye quetire catʉ̃goʉsaʉ baiyasietigʉmi,” miñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mʉ pʉame jãã ñicʉ̃ Abraham ãnacʉ̃ netõrõ caãcʉ̃ majũ mʉ ãniñati? Profeta majã ãnana cʉ̃ã baiyasi peticoasupa. Bairo mʉ caĩbʉsʉata, ¿“Noa netõrõ caãcʉ̃ yʉ ãniña,” ĩ tʉ̃goñaʉ miñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Bairo na caĩrõ, atore bairo na ĩwĩ Jesús: —Yʉ majũã, “Caroaro caácʉ yʉ ãniña,” yʉ caĩata, yʉ caquetibʉjʉrije wapa manibujioro. “Dios jãã pacʉ niñami,” mʉjãã caĩnucũmii pʉame yʉ caátiere ĩñajesonucũñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉjãã pʉame cʉ̃rẽ mʉjãã masĩẽtĩmajũcõãña. Yʉ roque cʉ̃rẽ yʉ masĩña. Cʉ̃rẽ masĩmicʉ̃ã, “Cʉ̃rẽ yʉ masĩẽtĩña,” yʉ caĩata, mʉjããrẽ bairoa caĩtoriquepai majũ yʉ ãnibujioʉ. Cariapea, “Cʉ̃rẽ yʉ masĩña,” mʉjããrẽ yʉ caĩata, ñuña. Bairi cʉ̃ carotirijere yʉ átinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉjãã ñicʉ̃ Abraham ãnacʉ̃ ati yepapʉ yʉ caátípa rʉ̃mʉrẽ queti tʉ̃gori, ʉseanijʉ̃goye cʉtiyayupi. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bairo cʉ̃ caĩrõ tʉ̃gori, atore bairo qũĩwã judío majã tunu: —¿Cincuenta cʉ̃marĩ majũ cʉ̃goetimicʉ̃ã, “Abraham ãnacʉ̃rẽ cʉ̃ ñiñawʉ̃,” caĩrẽ bairo miñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Bairo na caĩrõ, atore bairo na ĩwĩ Jesús tunu: —Cariape mʉjããrẽ ñiña: Abraham ãnacʉ̃ cʉ̃ cabuiaparo jʉ̃goyepʉa merẽ yʉ ãnijʉ̃gowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bairo cʉ̃ caĩrõ tʉ̃gori, ʉ̃tã rupaa mena cʉ̃rẽ wẽjĩãgamiwã. Cʉ̃ pʉame ti wii, Dios ya wiipʉ caãniatacʉ na watoapʉ “Cʉ̃ jãã,” ĩ masĩã mano na witiweyocoámí yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús, jĩcãpaʉre netõácʉ́, jĩcãʉ̃ cacaapee ĩñaecʉ̃ cabuiaricʉre qũĩñajowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bairo cʉ̃rẽ etari bero, jãã, cʉ̃ cabuerã pʉame atore bairo cʉ̃ jãã ĩ jẽniñawʉ̃: —Jããrẽ cabuei, ¿dopẽĩ caapee ĩñaecʉ̃, ãni caʉ̃mʉ cʉ̃ buiayupari? ¿Cʉ̃ pacʉa roro na caátaje jʉ̃gori caapee ĩñaecʉ̃ cʉ̃ buiayupari? o ¿cʉ̃ majũ cʉ̃ carorije wapa tore bairo cʉ̃ buiayupari? —cʉ̃ jãã ĩ jẽniñawʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Bairo cʉ̃ jãã caĩjẽniñarõ tʉ̃gori, atore bairo jãã ĩ yʉwĩ: —Cʉ̃ majũ cʉ̃ carorije wapa jʉ̃gori mee tore bairo buiayupi. Tunu bairoa cʉ̃ pacʉa na carorije wapa jʉ̃gori mee tore bairo caapee ĩñaecʉ̃ buiayupi. Bairo pʉame baiyupa: Dios nocãrõ cʉ̃ catutuarijere cʉ̃ jʉ̃gori camasãrẽ na áti ĩñogʉ, tore bairo cʉ̃ buiao joroque ásupi. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bairi marĩ pʉame ãmea yʉ Pacʉ yʉ cʉ̃ caquetibʉjʉrotijoriquere tãmurĩ marĩ quetibʉjʉ yaparogarã camasãrẽ. Ñami caãnorẽ camasã paaetinucũñama. Ʉmʉreco roquere paanucũñama. Bairi cabero ati yʉtea canetõrõ beropʉ roquere dope bairo quetibʉjʉ masĩã manigaro Dios yaye quetire. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bairi yʉ pʉame ati yepapʉ ãcʉ̃, mʉjãã ati yepa macããnarẽ, cajĩñawojʉ̃goʉre bairo caãcʉ̃ yʉ ãniña. Caroaro cabusurijere bairo caãnie caroa quetire mʉjãã quetibʉjʉ acʉ́ yʉ apʉ́ —jãã ĩ quetibʉjʉwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bairo jããrẽ ĩ quetibʉjʉ yaparori bero yua, yepapʉ ʉcoo eyocũwĩ. Bairo eyocũrĩ, paawĩtõwĩ ñerĩ mena cʉ̃ ʉcoore. Bairo átiri, cacaapee ĩñaecʉ̃rẽ cʉ̃ caapeepʉ cʉ̃ warepajĩñowĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Cʉ̃ caapeere cʉ̃ warepajĩñorĩ bero, atore bairo qũĩwĩ: —Siloé cawãmecʉti oco opepʉ mʉ caapeere wacoseija —qũĩ jowĩ Jesús cacaapee ĩñaecʉ̃rẽ. (Mai, Siloé ĩgaro ĩña: “Jĩcãʉ̃rẽ cajooecorica oco ope,” ĩgaro ĩña.) Bairo Jesús cʉ̃ caĩrõ tʉ̃go, cacaapee ĩñaecʉ̃ pʉame ti oco opepʉ cosei acoámí. Bairo cʉ̃ caapeere topʉ coseri bero, tunu acʉ́, caroaro ĩñamasĩcoasupi yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bairo cʉ̃ caĩñamasĩrõ ĩñarã, cʉ̃ caãnipaʉtʉ macããna, aperã limosna cʉ̃ cajẽniruinucũrõ caĩñarĩcãrã cʉ̃ã atore bairo ãmeo ĩ jẽniñawã: —¿Ãnia, átáwãtʉ calimosna jẽni ruinucũatacʉ mee cʉ̃ ãniñati mʉjããrã? —ãmeo ĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jĩcããrã bairo ãmeo ĩwã: —Cʉ̃ã niñami. Apei mee niñami. Aperã pʉame atore bairo ãmeo ĩwã: —Cʉ̃rẽ bairo baumicʉ̃ã, cʉ̃ mee niñami. Apei niñami. Bairo na caĩmiatacʉ̃ãrẽ, cʉ̃ majũ cʉ̃ã bairo na ĩwĩ: —Cʉ̃ majũã yʉ ãniña. ¡Tame! —na ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bairo ãmeo ĩrĩ bero yua, cʉ̃rẽ jẽniñawã: —Ãmerã, ¿ñe ũnie jʉ̃gori mʉ caapee ĩñamasĩcoayati? ");
INSERT INTO cbcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Cʉ̃ pʉame bairo na caĩjẽniñarõ, bairo na ĩwĩ: —Jĩcãʉ̃ Jesús cawãmecʉcʉ pʉame atore bairo yʉ átiroyaámi. Cʉ̃ ʉcoore yepapʉ eyocũrĩ, paawĩtõõ átiri, tie mena yʉ caapeere ware pajĩñoroyaámi. Bairo yʉ átiri bero, “Siloé cawãmecʉti oco opepʉ mʉ caapeere wacoseija,” ñijowĩ. Bairo cʉ̃ caĩrõ tʉ̃gori, cʉ̃ caátirotirore bairo yʉ ápʉ. Bairo yʉ cʉ̃ caátirotiro bero yua, ñiñamasĩña —na ĩ quetibʉjʉwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bairo cʉ̃ caĩrõ tʉ̃gori, na pʉame cʉ̃ jẽniñawã tunu: —Cʉ̃, mʉrẽ cacatioatacʉ, ¿noopʉ cʉ̃ ãnicʉti? —qũĩwã. Cʉ̃ pʉame bairo na caĩrõ, atore bairo na ĩwĩ: —Ũba, ¿noo ãcʉ̃ ãcʉ̃mi rita? Yʉ masĩẽtĩña —na ĩ quetibʉjʉwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Mai, Jesús, cacaapee ĩñaecʉ̃rẽ cʉ̃ ʉcoo mena ñerĩrẽ paawĩtõrĩ cʉ̃ cacatiorica rʉ̃mʉ pʉame, judío majã na cayerijãrĩ rʉ̃mʉ ãmʉ. Bairi fariseo majã tʉpʉ cʉ̃ neámá cacaapee ĩñamasĩẽtĩmiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bairo fariseo majãtʉ cʉ̃ na cane etaro, fariseo majã pʉame bairo qũĩ jẽniñuparã: “¿Dope bairo yua caroaro miñamasĩcoati?” Cʉ̃ pʉame bairo na ĩ quetibʉjʉyupʉ: —Jĩcãʉ̃, Jesús cawãmecʉcʉ, cʉ̃ ʉcoore ñerĩ mena pawĩtõrĩ yʉ pajĩñowĩ yʉ caapeere. Bairo cʉ̃ caáto bero, yʉ pʉame yʉ caapeere yʉ wacosewʉ. To bero ñiñamasĩcõãña yua —na ĩ quetibʉjʉyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃gori, jĩcããrã fariseo majã atore bairo ãmeo ĩñuparã: —Ãnirẽ cacatioatacʉ, Dios yaʉ mee ãcʉ̃mi. Dios yaʉ mee ãnirĩna, marĩ cayerijãrĩ rʉ̃mʉrẽ nʉcʉ̃bʉgoetiupi. Aperã pʉame bairo ãmeo ĩñuparã: —¿Dope bairo carorijere caátipai nimicʉ̃ã, caroa Dios yaye macããjẽrẽ cʉ̃ áti ĩñobujiocʉti? —ãmeo ĩñuparã. Bairo ĩrã, na pʉame jĩcãrõrẽ bairo tʉ̃goñarĩ bʉsʉesuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bairo ãmeo ĩrĩ bero, cacaapee ĩñaetimirĩcʉ̃rẽ cʉ̃ jẽniñanemoñuparã tunu: —Mʉrẽ miñamasĩõ joroque caátiatacʉre, ¿ñamʉ majũ ãcʉ̃mi, cʉ̃ mi tʉ̃goñañati? Bairo na caĩrõ, cʉ̃ pʉame bairo na ĩñupʉ̃: —Yʉra, Dios yaʉ profeta majũ niami —na ĩ quetibʉjʉyupʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bairo cʉ̃ caĩquetibʉjʉmiatacʉ̃ãrẽ, judío majã quetiuparã pʉame cariape cʉ̃ tʉ̃goesuparã cacaapee ĩñaecʉ̃ cajʉ̃goye cʉ̃ caãnajẽrẽ. Tunu bairoa Jesús cʉ̃rẽ qũĩñamasĩõ joroque cʉ̃ caátiataje cʉ̃ãrẽ cariape tʉ̃gogaesuparã. Bairi yua cʉ̃ pacʉare na piijoyupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na piijori, atore bairo na ĩ jẽniñañuparã: —Ãnia, ¿mʉjãã macʉ̃ majũã cʉ̃ ãniñati? ¿Cariape majũã cacaapee ĩñamasĩẽcʉ̃ cʉ̃ buiari mʉjãã macʉ̃? ¿Dopẽĩ ãmerẽ yua caroaro cʉ̃ caapee ĩñamasĩjãñuñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bairo cʉ̃ caĩrõ, cʉ̃ pacʉa pʉame bairo na ĩ yʉyuparã judío majã quetiuparãrẽ: —Jãã macʉ̃ majũã niñami. Cʉ̃ã, cacaapee ĩñamasĩẽcʉ̃ buiawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cʉ̃, jãã macʉ̃ã cʉ̃ caãnimiatacʉ̃ãrẽ, dope bairo cʉ̃ cacaapee ĩñamasĩatajere jãã masĩẽtĩña. Bairi tunu cʉ̃rẽ cʉ̃ caapee ĩñao joroque caátiatacʉ cʉ̃ãrẽ jãã masĩẽtĩmajũcõãña. ¡Mʉjãã majũ cʉ̃rẽ cʉ̃ jẽniñañijate! Merẽ cʉ̃ majũ cabʉtitʉ̃goña masĩcoacʉpʉ niñami. Torecʉ, cʉ̃ majũã cʉ̃ cabaiatajere cariape mʉjãã quetibʉjʉ masĩñami —na ĩ quetibʉjʉyuparã cʉ̃ pacʉa judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cʉ̃ pacʉa pʉame tore bairo na ĩ quetibʉjʉyuparã judío majã quetiuparãrẽ, na uwimirã. Mai, na, judío majã quetiuparã pʉame jĩcãrõ tʉ̃goñarĩqũẽ cʉtiri, “Ni jĩcãʉ̃ ũcʉ̃, ‘Jesús, Mesías niñami,’ cariape caĩ ũcʉ̃rẽ ñubuerica wiipʉa cʉ̃ marĩ wiyogarã,” ãmeo ĩñuparã. Bairo na caátigarijere tʉ̃goña uwiri, tore bairo na ĩñuparã cʉ̃ pacʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bairo tiere masĩrĩ, capacʉa pʉame, “Mʉjãã majũ cʉ̃rẽ cʉ̃ jẽniñañijate. Merẽ cʉ̃ majũ cabʉtitʉ̃goña masĩcoacʉpʉ niñami,” na ĩñuparã judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bairi judío majã quetiuparã pʉame cacaapee ĩñaetimiatacʉre, cʉ̃ piijori bairo qũĩñuparã tunu: —Cariape Dios mena jããrẽ quetibʉjʉya. Cʉ̃, mʉrẽ cacatioatacʉ carorije caácʉ cʉ̃ caãnierẽ jãã masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bairo na caĩrõ tʉ̃gori, cʉ̃ pʉame na ĩñupʉ̃: —¡Ũba! “Carorije caácʉ ãcʉ̃mi,” o “Caroa caácʉ ãcʉ̃mi,” cʉ̃ ñi masĩẽtĩña. Ati wãme jetore yʉ masĩña: Caãnijʉ̃gorore mai cacaapee ĩñaecʉ̃ yʉ ãnimiwʉ̃. Cabaimirĩcʉ̃ ãmerẽ yua ñiñamasĩcõãña. Tie roquere yʉ masĩña —na ĩñupʉ̃, judío majã quetiuparãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bairo cʉ̃ caĩrõ, judío majã quetiuparã pʉame atore bairo qũĩ jẽniñanemoñuparã tunu: —¿Dope bairo majũ mʉ cʉ̃ áticatioati? ¿Dope bairo átiri miñamasĩõ joroque mʉ cʉ̃ átiati? ");
INSERT INTO cbcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bairo na caĩjẽniñarĩjẽrẽ tʉ̃go, bairo na ĩñupʉ̃: —Merẽ cariape mʉjãã yʉ quetibʉjʉapʉ. Bairo yʉ caĩquetibʉjʉmiatacʉ̃ãrẽ, cariape yʉ mʉjãã tʉ̃gogaetiya. ¿Dopẽĩrã pʉgani cãrõ yʉ caquetibʉjʉro mʉjãã boyati? ¿Mʉjãã cʉ̃ã cʉ̃rẽ cʉ̃ tʉ̃goʉsagarã, tore bairo mʉjãã ĩñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bairo cʉ̃ caĩrõ yua, na pʉame roro qũĩ tutiri, bairo qũĩñuparã: —Mʉa, cʉ̃ ũcʉ̃rẽ cʉ̃ tʉ̃goʉsaya. Jãã, Moisés ãnacʉ̃ cʉ̃ caroticũrĩqũẽrẽ catʉ̃goʉsarã jãã ãnicõã nigarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jãã masĩña: Moisés ãnacʉ̃rẽ Dios cʉ̃ quetibʉjʉ roticũñupĩ. Apei, mʉrẽ cacatioatacʉ pʉamerẽ jãã masĩẽtĩmajũcõãña. “Noo atíatacʉmi,” cʉ̃ jãã ĩ masĩẽtĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bairo cʉ̃ na caĩrõ, cacaapee ĩñaetimirĩcʉ̃ pʉame bairo na ĩ yʉyupʉ: —¡Ago tame! “‘Noo atíatacʉmi,’ cʉ̃ jãã ĩ masĩẽtĩña,” ¿mʉjãã ĩñati? Mʉjãã pʉame cʉ̃ mʉjãã caĩmasĩẽto ũno, yʉ pʉamea cʉ̃ yʉ masĩña yʉre caapee ĩñao joroque caátiatacʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Merẽ cariape marĩ masĩña: Dios, carorije caáticõãninucũrãrẽ cʉ̃ yaye, cʉ̃ camasĩrĩjẽrẽ na átirotietiyami. Cʉ̃rẽ caĩroarã, cʉ̃ caborore bairo caána jetore cʉ̃ yaye cʉ̃ camasĩrĩjẽrẽ na átirotinucũñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bairi ni ũcʉ̃ ati yepa macããcʉ̃ camasocʉ ĩñamasĩẽcʉ̃ cabuiaricʉre cʉ̃ caapee ĩñamasĩõ joroque cʉ̃ átimasĩẽcʉ̃mi. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dios cʉ̃ cajoʉ ãnirĩ, Dios cʉ̃ camasĩrĩjẽ mena yʉ catiowĩ. Cʉ̃ mee cʉ̃ caãmata, yʉre yʉ catioetibujioatacʉmi —na ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bairo cʉ̃ caĩrõ, atore bairo qũĩ tutiyuparã: —Bʉsʉeticõãña. Mʉ pʉame mʉ carorije wapa cacaapee ĩñaecʉ̃ mʉ buiayupa. Bairo carorije caátipai ãnirĩ jããrẽ mʉ rotimasĩẽtĩña —qũĩ tutiyuparã. Bairo qũĩ tutiri yua, ti wii ñubuerica wiire cʉ̃ acuwiyo jocõãñuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bairo cacaapee ĩñaecʉ̃rẽ cʉ̃ tutiri cʉ̃ na caacuwiyoatajere queti tʉ̃gori bero, cʉ̃ bócaetari, atore bairo qũĩ jẽniñawĩ Jesús: —¿Cariapea, “Mesías, Dios cʉ̃ cajoʉ majũ niñami,” mi tʉ̃goñañati? ");
INSERT INTO cbcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Cʉ̃ pʉame bairo qũĩ yʉwĩ: —Yʉ Quetiupaʉ, ¿ñamʉ ũcʉ̃rẽ cʉ̃ miñati? Yʉ cʉ̃ã cʉ̃rẽ cʉ̃ yʉ tʉ̃goʉsagamiña. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús pʉame bairo cʉ̃ caĩrõ, bairo qũĩwĩ: —Mʉ mena cabʉsʉa, cʉ̃ã yʉ ãniña. Cʉ̃rẽã miñaña merẽ —qũĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bairo Jesús cʉ̃ caĩrõ, cacaapee ĩñaetimirĩcʉ̃ pʉame atore bairo qũĩwĩ rʉpopaturi mena etanumurĩ: —Yʉ Quetiupaʉ, cariape mʉ tʉ̃gori mʉ ñiroaya —qũĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tie bero, bairo qũĩnemowĩ Jesús tunu: —Ati yepapʉre caroa cariape macããjẽrẽ áti acʉ́ yʉ apʉ́. Ati yepa macããna cacaapee ĩñaenarẽ bairo caãnarẽ caroa macããjẽrẽ na tʉ̃goʉsaáto ĩ pʉame, yʉ apʉ́. Tunu bairoa aperã, “Dios yaye macããjẽrẽ camasĩrã ãnirĩ cacaapee ĩñamasĩrãrẽ bairo jãã ãniña,” caĩtonucũrã caĩñamasĩẽna majũrẽ bairo na tuao joroque ĩ, yʉ apʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bairo Jesús cʉ̃ caĩquetibʉjʉrijere tʉ̃gori, jĩcããrã fariseo majã atore qũĩwã: —¿Jãã cʉ̃ãrẽ, “Caĩñaenarẽ bairo catʉ̃gomasĩẽna majũ mʉjãã ãniña,” jãã ĩgʉ miñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Bairo na caĩrõ, Jesús pʉame atore bairo na ĩwĩ: —Cacaapee ĩñaenarẽ bairo mʉjãã cʉ̃ã Dios yaye macããjẽrẽ camasĩẽna mʉjãã roro mʉjãã caátie wapa cabuicʉperã mʉjãã ãnibujiorã. “Jãã, camasĩrã majũ jãã ãniña,” caĩrã nimirãcʉ̃ã, jĩcãrõ tʉ̃ni mʉjãã ápericõã ninucũña. Tie jʉ̃gori cabuicʉna majũ mʉjãã tuaya yua —na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Bairo na ĩ yaparori bero, atore bairo na ĩ quetibʉjʉnemowĩ Jesús: “Cariape mʉjããrẽ ñiña: Ni ũcʉ̃ camasocʉ nurĩcãrã oveja na cajããnucũrĩ jopepʉ jããẽcʉ̃ã, aperopʉ cawãmʉnetõjããʉ̃ cañuecʉ̃, jerutiri majõcʉ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Apei, ẽñotaricarore jããrĩcã jope majũpʉ cajããʉ̃ pʉame roque nurĩcãrã ovejare cacotei majũ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bairo jopetʉ cʉ̃ caetaro, ti jopere cacotei pʉame cʉ̃ cʉ̃ capããjõrõ bero, cʉ̃ canurã oveja cʉ̃ã cʉ̃ bʉsʉriquere tʉ̃gomasĩcõãñama. Tunu bairoa cʉ̃ canurã ovejare na wãmerĩ jeto na piiwiyo jomasĩñami, na jãnirõ macãpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bairo na piiwiyojo yaparori, na neñorĩ, na jʉ̃goyecʉti ámasĩñami. Bairo cʉ̃ caáto, na, oveja nurĩcãrã pʉame caroaro qũĩñamasĩrĩ cʉ̃ ʉsanucũñama. Bairo tunu cʉ̃ capiirijere tʉ̃gori, caroaro cʉ̃ pitietinucũñama, na upaʉre caĩñamasĩrã ãnirĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bairãpʉa, apei na camasĩẽcʉ̃ pʉamerẽ cʉ̃ ʉsaetinucũñama. Cʉ̃ cabʉsʉrijere catʉ̃gojeyaena ãnirĩ, cʉ̃ uwiri aperopʉ cʉ̃ aweyocõãnucũñama. Bairi noa ũna na camasĩẽnarẽ nurĩcãrã oveja na ʉsaetinucũñama,” na ĩ quetibʉjʉwĩ Jesús fariseo majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús atore bairo fariseo majãrẽ na cʉ̃ caĩquetibʉjʉmiatacʉ̃ãrẽ, na pʉame, “Atore bairo pʉame ĩgʉ ĩcʉ̃mi,” cariape ĩ tʉ̃gomasĩẽma. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bairo na ĩ quetibʉjʉ yaparori bero, Jesús pʉame atore bairo na ĩ quetibʉjʉnemowĩ fariseo majãrẽ tunu: “Cariape majũ mʉjããrẽ ñiña: Yʉ pʉame oveja na cajããrĩ jopere bairo majũ yʉ ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Aperã, yʉ jʉ̃goye caquetibʉjʉrã etajʉ̃goricarã pʉame carorã cañuena, cayajapairãrẽ bairo majũ ãñupã. Bairi yʉ yarã oveja nurĩcãrãrẽ bairo caãna cʉ̃ã narẽ na ĩroaetiri na tʉ̃goʉsaesupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉa, oveja na cajããrĩ jope majũrẽ bairo caãcʉ̃ yʉ ãniña. Bairi yʉre caĩroaʉ pʉame yʉ jʉ̃gori cʉ̃ carorije wapare canetõecoricʉpʉ niñami. Jĩcãʉ̃ oveja jãáti, o witiáti bero cataa bócaʉgamasĩrẽ bairo tuayami yua caroa yericʉtaje mena. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Yajari majõcʉ, yajaʉ acʉ́ jeto atínucũñami. Tunu bairoa pajĩãrei acʉ́ jeto atínucũñami. Yʉ pʉame roque mʉjããrẽ yeri capetietipeere nocãrõ majũ pairo mʉjãã cacʉ̃gopeere joʉ acʉ́ yʉ apʉ́. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yʉ pʉame roque oveja nurĩcãrãrẽ caroaro caĩñarĩcãnʉgõ cotemasĩrẽ bairo yʉ ãniña. Bairi ni jĩcãʉ̃ ũcʉ̃ oveja coteri majõcʉ cañuʉ, cʉ̃ canurã ovejare mairĩ popiye tãmʉomasĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Apei, ovejare cʉ̃ yarã meerẽ cacotei ãnirĩ, paawapatarique jetore bonucũñami. Bairo caboʉ ãnirĩ, yai ovejare caʉgaʉ cʉ̃ caató ĩñarĩ, na aweyocoayami, ovejare cacoteecʉ ãnirĩ. Bairo cʉ̃ caaweyoro bero, yai pʉame na ñeacubato recõãñami, na ʉgaʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cʉ̃, ovejare caaweyoʉ pʉame na ovejare camaiecʉ̃ ãnirĩ, tunu bairo wapatarique jetore cabonucũʉ̃ ãnirĩ na aweyocoayami. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Yʉ pʉame roque oveja nurĩcãrãrẽ caroaro caĩñarĩcãnʉgõ cotemasĩrẽ bairo yʉ ãniña. Bairi yʉ Pacʉ Dios yʉ masĩñami yʉ paariquere. Yʉ cʉ̃ã yʉ Pacʉ Dios yʉre cʉ̃ camasĩrõrẽ bairo yʉ masĩña cʉ̃ caãnajẽ cʉtiere. Torea bairo yʉ yarã ovejare bairo caãna cʉ̃ãrẽ na ñiñaricanʉgõ cotenucũña. Bairo yʉ cacoterã, nurĩcãrã oveja na upaʉre caroaro na caĩñamasĩrõrẽ bairo ñiñamasĩcõã ninucũñama. Bairi yʉ pʉame yʉ yarã ovejare bairo caãnarẽ netõgʉ, popiye yʉ tãmʉomasĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bairi tunu aperopʉ cʉ̃ãrẽ ovejare bairo caãna, yʉ ya jãnirõ mee caãna mai, capããrã niñama. Bairi na cʉ̃ãrẽ na yʉ neñomasĩña. Bairo na neño yaparori, jĩcãrõ tʉ̃ni ãnio joroque na yʉ qũẽnogʉ. Bairo na yʉ caqũẽnorõ, jĩcãrõ tʉ̃ni ãnigarãma. Bairo yʉ caneñojoatana yua jĩcã poa macããnarẽ bairo jeto tuagarãma. Yʉ narẽ cacotei cʉ̃ã jĩcãʉ̃ã yʉ ãnigʉ. Bairo na, yʉ yarã ovejare bairo caãna pʉame caroaro mena yʉ tʉ̃goʉsagarãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Yʉ pʉame camasãrẽ na carorije wapa jʉ̃gori yʉ riacoagʉ, na netõgʉ. Bairo cariacoacʉ nimicʉ̃ã, yʉ majũ rupaʉ to catio joroque yʉ baigʉ. Bairi yʉ Pacʉ ñiñamai jãñunucũñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Bairi ni ũcʉ̃ pʉame cabʉgoroa yʉ pajĩãroca masĩẽtĩñami. Yʉ cabaimasĩpee atore bairo niña: Camasãrẽ na netõgʉ, yʉ cabori rʉ̃mʉ caãno na carorije wapa jʉ̃gori yʉ riacoagʉ. Bairo cariacoacʉ nimicʉ̃ã, yʉ majũ rupaʉ to catio joroque yʉ baigʉ. Tore bairo yʉ Pacʉ yʉ bairotijowĩ,” na ĩ quetibʉjʉwĩ Jesús fariseo majã cʉ̃rẽ catʉ̃gorã etarãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bairo Jesús cʉ̃ caĩquetibʉjʉrijere tʉ̃gori yua, ãmeo bʉsʉrique ricawaticoama tunu judío majã. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bairo bairã, na mena macããna capããrã atore bairo ãmeo ĩwã: —¿Dopẽĩrã wãtĩ yeri pũna cacʉ̃goʉ, camecʉ̃rẽ cʉ̃ mʉjãã tʉ̃gopeo ʉsayati? ");
INSERT INTO cbcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aperã pʉame bairo ãmeo ĩwã: —Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ yeripʉ wãtĩ yeri pũna cacʉ̃goʉ tore bairo ĩ quetibʉjʉ masĩẽtĩñami. Mʉjããrã, ¿wãtĩ yeri pũna cacʉ̃goʉ cʉ̃ã cacaapee ĩñaecʉ̃rẽ caapee ĩñao joroque cʉ̃ átimasĩcʉti? —bairo ãmeo ĩ bʉsʉwã fariseo majã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mai, ti watoare pue yʉtea ãmʉ. Ti yʉtea caãno Jerusalén macãpʉre Dios ya wii templo wiire na cabose rʉ̃mʉ átipeo jʉ̃gorica rʉ̃mʉ caetaro, na cabose rʉ̃mʉ qũẽnopeori yʉtea ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Bairo na cabose rʉ̃mʉ qũẽnorõ, Jesús pʉame templo wiitʉ Pórtico de Salomón na caĩrĩ arʉa tʉpʉ áñesẽãwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bairo tipaʉ cʉ̃ caáñesẽãrõ, judío majã pʉame cʉ̃ jotoanʉcãrĩ bairo qũĩ jẽniñawã: —¿Nocãrõ yoaropʉ jããrẽ, “Dios cʉ̃ cajoʉ yʉ ãniña,” jãã mitoãcʉ̃ãti? Bairi Dios cʉ̃ cajoʉ, Mesías mʉ caãmata, jicoquei cariapea cʉ̃ mʉ caãnierẽ jãã quetibʉjʉcõãña —qũĩ jẽniñawã Jesure judío majã quetiuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Bairo na caĩrõ, Jesús pʉame bairo na ĩ yʉwĩ: —Merẽ mʉjããrẽ yʉ quetibʉjʉnucũña. Mʉjãã pʉame cariape yʉ mʉjãã tʉ̃gogaetiya. Merẽ nipetirije yʉ Pacʉ cʉ̃ caátirotirije mena Mesías yʉ caãnierẽ mʉjãã yʉ áti ĩñonucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bairo yʉ caáti ĩñorĩjẽrẽ ĩñamajũcõãmirãcʉ̃ã, cariape mʉjãã tʉ̃goetinucũña. Yʉ cacoterã yʉ yarã oveja mena macããna mee ãnirĩ yʉ mʉjãã tʉ̃gogaetiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yʉ yarã ovejare bairo caãna yʉ cabʉsʉrijere yʉ tʉ̃gomasĩcõãñama. Bairo yʉ cʉ̃ã narẽ na yʉ masĩjãñuña. Bairi na pʉame cʉ̃ã caroaro yʉ tʉ̃goʉsanucũñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bairo cariape yʉ mena catʉ̃goʉsarãrẽ yʉ mena caãnarẽ caticõãnajẽrẽ na yʉ jonucũña. Na pʉame ati yepa na caãno ũno, jĩcãʉ̃ na mena macããcʉ̃ yasietigʉmi. Ñamʉ jĩcãʉ̃ ũcʉ̃ na yasio joroque yʉ jiya átibojaetigʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉ Pacʉ pʉame roque yʉ yarã caãniparãrẽ yʉ jowĩ. Cʉ̃, yʉ Pacʉ pʉame nipetiro netõrõ catutuaʉ majũ niñami. Bairo ni ũcʉ̃ pʉame na yasio joroque yʉ jiya átibojaetigʉmi yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Torena, yʉ Pacʉ Dios mena jĩcãrõrẽ bairo jãã ãnajẽ cʉticõãña —na ĩ yʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bairo cʉ̃ caĩquetibʉjʉro tʉ̃gorã, judío majã pʉame ʉ̃tã rupaa jeri cʉ̃ wẽjĩãgamiwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Bairo na cajeripaʉa, Jesús pʉame bairo na ĩwĩ: —Yʉ Pacʉ Dios cʉ̃ catutuarije mena capee majũ caroa wãmerẽ mʉjãã caĩñajoro yʉ áti ĩñonucũña. Bairo capee caroa wãmerẽ mʉjãã yʉ caáti ĩñomiatacʉ̃ãrẽ, ¿di wãme jʉ̃gori yʉ mʉjãã ʉ̃tã wẽjĩãgayati? —na ĩ jẽniñawĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bairo cʉ̃ caĩjẽniñarõ, judío majã pʉame bairo qũĩ yʉwã: —Bairãpʉa, caroa wãme mʉ caátie wapa jʉ̃gori mee mʉrẽ ʉ̃tã mena jãã wẽjĩãgaya. Roro cabʉgoroa Diore nʉcʉ̃bʉgoecʉa, mʉ caĩbʉsʉpairije jʉ̃gori roque, mʉrẽ jãã pajĩãrocagaya. Mʉa, cabʉgoro macããcʉ̃, ati yepa macããna camasãrẽ bairo caãcʉ̃ mʉ ãniña. Bairo caãcʉ̃ nimicʉ̃ã, mʉ majũã, “Dios yʉ ãniña,” caĩrẽ bairo mi bʉsʉnucũña —qũĩwã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Bairo na caĩrõ tʉ̃go, Jesús pʉame judío majãrẽ atore bairo na ĩwĩ: —Dios ya tutipʉ mʉjããrẽ carotirije pʉame bairo ĩña: “ ‘Mʉjãã cʉ̃ã Diore bairo caãna mʉjãã ãniña,’ mʉjãã ñiña,” ĩ quetibʉjʉ woatuyupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bairi, “Dios ya tutipʉ na cawoatucũrĩqũẽ, bairo ĩcõãrõ ĩña,” marĩ ĩ masĩẽtĩña. Tiere merẽ cariape marĩ masĩña. Bairi Dios pʉame cʉ̃ yaye quetire cʉ̃ caquetibʉjʉ rotijoricarãrẽ, “Mʉjãã cʉ̃ã Dios yarãrẽ bairo caãna mʉjãã ãniña,” na ĩ bʉsʉyupi. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios pʉame roque yʉ beseri, ati yepapʉ yʉ jowĩ. Bairo Dios cʉ̃ cajoricʉ yʉ caãnimiatacʉ̃ãrẽ, ¿dopẽĩrã yʉre, “Diore cabaibotioʉre bairo majũ niñami,” yʉ mʉjãã ĩnucũñati? “Dios macʉ̃ yʉ ãniña,” yʉ caĩrĩjẽrẽ tʉ̃gori, ¿dopẽĩrã tore bairo yʉ mʉjãã ĩnucũñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ Pacʉ cʉ̃ carotiri wãmerẽ bairo mee mʉjããrẽ yʉ caáti ĩñoata, cariapea yʉre catʉ̃goʉsaetiparã mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bairãpʉa, Dios jʉ̃gori caroa wãmerẽ yʉ caápata roque, yʉre ĩroaetimirãcʉ̃ã, caroaro tʉ̃goʉsaya Dios yaye macããjẽrẽ yʉ caáti ĩñorĩjẽrẽ. Bairo yʉ caátiere caĩñarã ãnirĩ yʉ Pacʉ yʉpʉre cʉ̃ caãnierẽ caroaro jĩcãrõ tʉ̃ni catʉ̃goʉsaparã mʉjãã ãniña. Bairi tunu yʉ cʉ̃ã yʉ Pacʉ cʉ̃ caãnajẽ cʉtiere bairoa yʉ caãnajẽ cʉtiere catʉ̃goʉsaparã mʉjãã ãniña —na ĩwĩ Jesús judío majãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bairo Jesús cʉ̃ caĩquetibʉjʉrijere tʉ̃gorã, judío majã pʉame preso jorica wiipʉ cʉ̃ neágamiwã tunu. Bairo Jesure judío majã preso jorica wiipʉ na caneágamiatacʉ̃ãrẽ, Jesús pʉame camasã capããrã watoa cʉ̃ jãã ĩã mácʉ̃ã, apero pʉame na rutiweyocoámí. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tie bero, Jesús pʉame yua, Rio Jordán cawãmecʉtiya ape nʉgõãpʉ jãã jʉ̃go tunucõã pẽñaámí tunu. Bairo pẽña ácʉ́ yua, Juan cawãmecʉcʉ cajʉ̃goyepʉ camasãrẽ oco mena cʉ̃ cabautiza ãnatõpʉ jãã jʉ̃go tuacõãwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bairo to jãã catuaro, capããrã majũ camasã jãã ĩñarã etawã. Bairo etari, na pʉame atore bairo ãmeo ĩbʉsʉwã: —Cariape majũ ĩñupĩ Juan Jesús cʉ̃ cabairijere, Dios cʉ̃ camasĩrĩjẽ mena caroare átijẽño ĩñoetimicʉ̃ã. Ãni, Jesús cʉ̃ cabaipee nipetirijere cariapea ĩ quetibʉjʉyupi Juan —ãmeo ĩbʉsʉwã na majũ. ");
INSERT INTO cbcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tipaʉre capããrã majũpʉa camasã Jesure cʉ̃ tʉ̃goʉsa jʉ̃gowã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jĩcãʉ̃ ãñupĩ riayewai Lázaro cawãmecʉcʉ. Cʉ̃ pʉame Betania cawãmecʉti macã macããcʉ̃ ãmi. Ti macãpʉ macããcõ María, apeo cʉ̃ yao Marta cʉ̃ã ãmo. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mai, cõ, María, Lázaro yao pʉame marĩ Quetiupaʉ Jesure cajʉtiñurĩjẽ mena cʉ̃ rʉporire capiopeorico ãmo. Bairo piopeori bero, cõ poañapõ mena cʉ̃ rʉporire capaareboporico ãmo. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bairi Lázaro yarã rõmirĩ pʉame atore bairo qũĩ quetijoyupa Jesure: —Jãã Quetiupaʉ, mʉ bapa Lázaro riajãñuñami —ĩ joyupa Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bairo cʉ̃ na caĩquetijoatajere tʉ̃gori, Jesús pʉame atore bairo jãã ĩwĩ: —Atie Lázaro cʉ̃ cariaye cʉtiãnie cʉ̃ riayasimajũcoao joroque caátipee mee niña. Dios cʉ̃ catutuarije camasãrẽ yʉ caáti ĩñopee roque nigaro. Tunu bairoa yʉ, Dios macʉ̃ yʉ caátitutuãnie cʉ̃ãrẽ na ĩñao joroque yʉ átigʉ, Lázaro cʉ̃ cariarije jʉ̃gori —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mai, Jesús pʉame Martare, Maríare, bairi Lázaro cʉ̃ãrẽ camai majũ ãmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bairo Lázaro cʉ̃ cariarijere tʉ̃gomicʉ̃ã, tunu pʉga rʉ̃mʉ cãrõ tipaʉre jãã jʉ̃gotuacõãwĩ mai. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cabero atore bairo jãã ĩwĩ Jesús, jãã, cʉ̃ cabuerãrẽ: —Jito tunu Judea yepapʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bairo cʉ̃ caĩrõ, jãã cʉ̃ cabuerã pʉame atore bairo cʉ̃ jãã ĩwʉ̃: —Jããrẽ cabuei, yoápériya ti yepa macããna mʉrẽ ʉ̃tã rupaa mena na cawẽpajĩãbujioata rʉ̃mʉ. Bairo to macããna mʉrẽ na caátaje caãnimiatacʉ̃ãrẽ, ¿mʉ ágayati ti yepapʉ tunu? ");
INSERT INTO cbcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Bairo jãã caĩrõ, Jesús pʉame jãã ĩwĩ: —Merẽ marĩ masĩña: Jĩcã ʉmʉreco, pʉga wãmo peti rʉpore pʉga pẽnirõ cãnacã hora majũ cʉ̃gonucũña. Bairi ʉmʉrecore marĩ caáñesẽãta, pʉgataricaro mano caroaro marĩ áñesẽãcõãña, muipʉ ʉmʉreco macããcʉ̃ cʉ̃ cabusuro jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bairãpʉa, ñamirẽ marĩ caáñesẽãta, pʉgatarique nibujioro muipʉ ʉmʉreco macããcʉ̃ cʉ̃ cabusuwoeto jʉ̃gori. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bairo jãã ĩ quetibʉjʉ yaparo, atore bairo jãã ĩnemowĩ tunu: —Marĩ bapa Lázaro pʉame cãnii baiimi. Bairo cʉ̃ cacãnimiatacʉ̃ãrẽ, cʉ̃ wãcõʉ̃ ágʉ yʉ átiya. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bairo cʉ̃ caĩrõ tʉ̃gorã, jãã cʉ̃ cabuerã pʉame bairo cʉ̃ jãã ĩwʉ̃: —Jãã Quetiupaʉ, ¿cacãnirẽ bairo cʉ̃ cabaiata, cʉ̃ cacatinemopee ãno to baicʉti? ");
INSERT INTO cbcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mai, Jesús pʉame Lázaro cʉ̃ cabaiyasicoatiere ĩgʉ, tore bairo jãã ĩmiwĩ. Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, jãã cʉ̃ cabuerã pʉame, “‘Catirã marĩ cawʉgoa cãnirĩjẽ mena cãnii baiimi Lázaro,’ marĩ ĩgʉ ĩcʉ̃mi Jesús,” jãã ĩ tʉ̃goñacõãwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bairo jãã catʉ̃gomasĩẽtõĩ, Jesús pʉame atore bairo cariape jãã ĩ quetibʉjʉwĩ: —“Lázaro merẽ riacoayami,” ĩgʉ ñiña. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bairi Lázaro tʉpʉ yʉ caãmerĩataje mena yʉ tʉ̃goña ʉseaniña. Mʉjãã pʉame tore bairo áti ĩñorĩcãrõpʉ mʉjãã tʉ̃goʉsanucũña. Bairi Lázaro cariaatacʉ tʉpʉ marĩ ĩñaráróa —jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Bairo Jesús, jãã cʉ̃ caĩrõ tʉ̃go, Tomás, apeyera Gemelo na caĩ wãmetinucũʉ̃ pʉame atore bairo jãã ĩwĩ: —Jito, marĩ cʉ̃ã cʉ̃ mena marĩ cariayasiro ñurõ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bairo topʉ etarã, jãã wiroñawʉ̃: Merẽ Lázaro ãnacʉ̃rẽ baparicãnacã rʉ̃mʉ netõñupã cʉ̃ rupaʉri ãnajẽrẽ ʉ̃tã opepʉ na cacũrocaatato bero yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mai, Betania pʉame Jerusalén macã tʉaca itia kilómetro cãrõ majũ etaricaro ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Capããrãpʉa judío majã mena macããna Martare, bairo Maríajããrẽ na ĩñarásúpa, na yaʉ cʉ̃ cariaro jʉ̃gori na tʉ̃goña yapapuaeticõãto ĩrã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bairo Jesús ti macãpʉ cʉ̃ caetaató tʉ̃gori, Marta pʉame jãã bocáo asúpo. Cõ yao María pʉame wiipʉa tuacõãñupõ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bairo Marta pʉame jãã bocári, atore bairo qũĩwõ Jesure: —Yʉ Quetiupaʉ, jããtʉ mʉ caãmata, yʉ yaʉ baiyasietibujioatacʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Baiopʉa, yʉ masĩña: Nipetirije mʉ cajẽnirĩjẽrẽ mʉ jogʉmi Dios. Ãmepʉ̃ cʉ̃ãrẽ mʉ cajẽnirõrẽ bairo átimasĩñami Dios —qũĩwõ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Bairo cõ caĩrõ, Jesús pʉame cõ ĩwĩ: —Mʉ yaʉ catitunucoagʉmi tunu —cõ ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Bairo Jesús cõ cʉ̃ caĩrõ, Marta pʉame atore bairo qũĩwõ tunu: —Yʉ masĩña merẽ tiere. Nipetiro cariaricarã nemo na cacatitunurĩ rʉ̃mʉ, catʉsari rʉ̃mʉ caãnopʉ cʉ̃ cʉ̃ã catitunugʉmi —qũĩwõ Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Bairo cõ caĩrõ tʉ̃go, Jesús pʉame bairo cõ ĩwĩ Martare tunu: —Yʉa, yʉ ãniña cariayasiricarãrẽ cacatijʉ̃goʉ. Bairi nipetiro yʉre catʉ̃goʉsarã ati yepapʉre cariacoana nimirãcʉ̃ã, caticõã ninucũgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tocãnacãʉ̃pʉa mai, cacatiãna, yʉre catʉ̃goʉsarã cariacoana nimirãcʉ̃ã, caticõã nigarãma. ¿Cariape mʉ tʉ̃goyati atore bairo mʉ yʉ caĩquetibʉjʉrijere? —cõ ĩwĩ Jesús Martare. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Bairo Jesús cõ cʉ̃ caĩrõ tʉ̃go, Marta pʉame atore bairo qũĩ yʉwõ: —Yʉ Quetiupaʉ, mʉrẽ cariape majũ yʉ tʉ̃goʉsaya. Mʉa, mʉ ãniña Mesías, Dios macʉ̃. Dios cʉ̃ cajoʉ majũ mʉ ãniña. Mʉa, ati yepapʉ caatípaʉ na caĩwoatujʉ̃goyeticũrĩcʉ̃ majũ mʉ ãniña —qũĩwõ Marta Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Atore bairo Jesure qũĩ bʉsʉ yaparori bero yua, cõ baio Maríare cõ piijori yasioroaca cõ ĩ quetibʉjʉyupo: —Marĩrẽ cabuei atoa niñami. Bairi mʉrẽ yʉ piijorotiami. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bairo Marta cõ caĩrõ tʉ̃go, jicoquei wãmʉnʉcã Jesure qũĩñao atícoasupo. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mai, Jesús pʉame macã tʉ̃nipʉ jãã jʉ̃goãnicõãwĩ. Ti macãpʉre jãã jããetaepʉ mai. Marta jããrẽ cõ cabocáetatapaʉpʉa jãã ãnicõãwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bairo Marta cõ cõ caĩrõ, tãmurĩ wãmʉnʉcãrĩ na wiire witi atícoasupo María, Jesutʉ acó. Bairo tãmʉrĩ cõ cawitiáto ĩñarã, judío majã cõ ya wiipʉ cõjããrẽ na tʉ̃goña yapapuaeticõãto ĩrã, caĩñarátana pʉame cõ ʉsacoásúparã. “María cõ yaʉ masã opepʉ otio acó baiomo,” ĩ tʉ̃goñarĩ cõ ʉsacoásúparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bairo María atí, Jesús cʉ̃ caãnopʉ etari, Jesús rʉpori tʉpʉ cõ rʉpopaturi mena etanumuo etawõ. Bairo etari, María qũĩwõ Jesure: —Yʉ Quetiupaʉ, jããtʉ mʉ caãmata, yʉ yaʉ baiyasietibujioatacʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Bairo María, judío majã cõ mena caatíatana cʉ̃ã na caotiro ĩñarĩ, Jesús pʉame cʉ̃ yeripʉ bʉtioro na tʉ̃goñamairĩ yapapuajãñuwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bairo tʉ̃goña yapapuari, bairo na ĩ jẽniñawĩ: —¿Noopʉ Lázaro rupaʉri ãnajẽrẽ mʉjãã rocari? Bairo qũĩwã na pʉame: —Jãã Quetiupaʉ, marĩ ĩñaátó ti masã opepʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Bairo na caĩrõ, Jesús pʉame bʉtioro otiwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bairo Jesús bʉtioro cʉ̃ caotiro ĩñarã, judío majã pʉame bairo na majũ ãmeo ĩwã: —Ĩñañijate. ¡Nocãrõ bʉtioro majũ cʉ̃ cʉ̃ maimiñuparĩ Lázaro ãnacʉ̃rẽ Jesús! ");
INSERT INTO cbcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bairo na caĩrõ, judío majã mena macããna jĩcããrã na majũ bairo ãmeo ĩwã: —Ãni Jesús, cacaapee ĩñaetacʉ cʉ̃ãrẽ cacatiocõãrĩcʉ̃ nimicʉ̃ã, ¿dopẽĩ jĩcã wãme ũno Lázaro ãnacʉ̃rẽ cʉ̃ jʉátinemo masĩẽtĩbujioyupari? —ãmeo ĩwã jĩcããrã judío majã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tunu Jesús pʉame bairo na caãmeo ĩtoye, cʉ̃ yeripʉ bʉtioro tʉ̃goñarĩ, Lázaro ãnacʉ̃ masã opetʉacapʉ ámí. Mai, Lázaro ãnacʉ̃ masã ope pʉame ʉ̃tã opepʉ ãmʉ. Bairi tunu ʉ̃tã tii mena ti ope biaricaro cʉ̃gowʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Bairo ĩwĩ yua Jesús pʉame: —Masã ope ʉ̃tã tii biaricatiire newoya. Bairo Jesús cʉ̃ caĩrõ tʉ̃go, Marta, Lázaro cabaiyasiatacʉ ãnacʉ̃ yao pʉame atore bairo qũĩwõ Jesure: —Yʉ Quetiupaʉ, merẽ baparicãnacã rʉ̃mʉ majũ netõcoaya. Toreto, merẽ roro majũ ʉ̃nijusucoato. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Bairo cʉ̃rẽ cõ caĩrõ tʉ̃go, Jesús pʉame atore bairo cõ ĩwĩ Martare: —Merẽ mʉ yʉ quetibʉjʉapʉ: “Cariape yʉ mʉ catʉ̃goʉsaata, Dios caroa camasãrẽ cʉ̃ caáti ĩñorĩjẽrẽ miñago,” mʉ ñiapʉ̃ —cõ ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bairo Jesús Martare cõ cʉ̃ caĩ yaparoro, Lázaro ãnacʉ̃ masa ope ʉ̃tã tii biaricatiire pãwocõãwã yua. Bairo na capãworo ĩñarĩ, Jesús pʉame ʉmʉrecóopʉ ĩñamʉgõjori, atore bairo Diopʉre qũĩ jẽniwĩ: —Caacʉ, yʉ mena mʉ ñujãñuña. Tocãnacãni yʉ cajẽnirõ yʉ mʉ tʉ̃gocõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉ masĩña merẽ: tocãnacãni yʉ mʉ tʉ̃gonucũña. Bairi tunu ãnoa camasã caãna jʉ̃gori bairo ñiña: “Cariapea ãnia niñami Dios cʉ̃ cajoʉ majũ,” na ĩáto ĩ, bairo mʉ ñiña —qũĩwĩ Jesús cʉ̃ Pacʉ Diopʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bairo Diopʉre qũĩ jẽni yaparori bero, Jesús pʉame bʉsʉrique tutuaro mena atore bairo ĩwĩ: —¡Lázaro, witiasá topʉre! ");
INSERT INTO cbcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Bairo Jesús cʉ̃ caĩrõ, cariayasiricʉ pʉame ti masã opepʉre witicoamí. Cʉ̃ wãmorĩ cʉ̃ rʉpori cʉ̃ã juti mena na cadʉrʉaricʉ witiamí. Tunu bairoa cʉ̃ rʉpoa cʉ̃ãrẽ juti asero mena paumarĩcʉ̃ witiamí. Bairo cʉ̃ cawitiató, Jesús, bairo na ĩwĩ: —Cʉ̃ õwãña, cʉ̃ caámasĩparore bairo ĩrã —na ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bairo Jesús cʉ̃ caátiere ĩñarĩ, capããrã judío majã Maríajããrẽ cabapacʉtirátana, Jesús cʉ̃ caáti ĩñoatajere caĩñaatana cʉ̃ tʉ̃goʉsajʉ̃gowã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bairo na catʉ̃goʉsamiatacʉ̃ãrẽ, aperã jĩcããrã pʉame fariseo majãrẽ na ĩñarásúpa. Bairo na ĩñarátí yua, nipetirije Jesús cʉ̃ caátiatajere na quetibʉjʉyupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bairo na caĩquetibʉjʉrijere tʉ̃gori, fariseo majã sacerdote majã quetiuparã cʉ̃ã nipetirã neñañuparã Junta Suprema na caĩrõpʉ. Topʉ neñarĩ, atore bairo ĩñuparã: —¿Dope bairo cʉ̃ mena marĩ ánaati? Cʉ̃, caʉ̃mʉ capee majũ caroa áti ĩñorĩqũẽrẽ na áti ĩñoʉ átiyami camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cʉ̃rẽ, bairoa marĩ caátiroticõãmata, capããrã camasã cʉ̃ jetore cʉ̃ tʉ̃gopaje ʉsagarãma. Bairi tunu Roma macããna carotirã marĩ tʉpʉ atíri, marĩ ñubuerica wii templo wiire átiyasio rocacõãgarãma. Tunu bairoa marĩ nipetiro ati yepa caãna cʉ̃ãrẽ marĩ pajĩãre peyocoagarãma —ãmeo ĩ bʉsʉyuparã na caneñarõpʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mai, na mena macããcʉ̃ jĩcãʉ̃ Caifás cawãmecʉcʉ ti cʉ̃marẽ sacerdote majã quetiupaʉ caãcʉ̃ pʉame bairo na ĩñupʉ̃: —Mʉjãã, catʉ̃goñarĩqũẽ mána majũ mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bairoa tunu mʉjãã atore bairo mʉjãã ĩ tʉ̃goñaẽtĩñati: “Nipetiro marĩ camasãrẽ aperã na capajĩã repeyoparo ũnorẽã, jĩcãʉ̃ã caʉ̃mʉ jeto cʉ̃ cariaro roque ñubujioro,” ¿mʉjãã ĩ tʉ̃goñaetimajũcõãñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mai, Caifás pʉame atore bairo cʉ̃ caĩyaparoata, cʉ̃ majũã cʉ̃ catʉ̃goñarõ mee bairo ĩñupʉ̃. Ti cʉ̃marẽ sacerdote majã quetiupaʉ cʉ̃ caãnoi, Dios pʉame, “Bairo ĩña,” ĩrĩqũẽrẽ cʉ̃ catʉ̃goñarĩqũẽ joro jʉ̃gori bairo ĩñupʉ̃. Jesús, judío majã na carorije wapare netõgʉ, ti yepa macããnarẽ na cʉ̃ cariabojapeere ĩgʉ, bairo ĩñupʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bairi tunu Jesús judío majã na carorije wapa jeto meerẽ cʉ̃ canetõbojapeere bairo ĩñupʉ̃. Nipetiro aperã ati yepa macããna caábataricarã Dios yarã cʉ̃ pũnaa caãniparã cʉ̃ãrẽ na cʉ̃ canetõpeere ĩgʉ ĩñupʉ̃ Caifás sacerdote majã quetiupaʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bairo Junta Suprema na caĩrõpʉ na caneñabʉsʉri rʉ̃mʉa, Jesure cʉ̃ na capajĩãrocapeere ãmeo bʉsʉpẽni weyocõãñuparã fariseo majã bairi sacerdote majã quetiuparã mena. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bairi yua, Jesús pʉame cʉ̃ na capajĩãgarijere masĩrĩ, baujaro judío majã quetiuparã na caãnopʉre ãniñesẽãẽmi yua. Bairi Jesús Judea yepa caãnimiatacʉ jãã cʉ̃ cabuerã mena jĩcãpaʉ desierto tʉaca macã, Efraín cawãmecʉti macãpʉ jãã jʉ̃goetawĩ. Bairo ti macãpʉ jãã cʉ̃ cabuerã mena etari, ti macãpʉ jãã jʉ̃goãnicõãwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bairo Jesús ti macãpʉ jãã cʉ̃ cajʉ̃goãno, merẽ petoaca rʉsawʉ judío majã bose rʉ̃mʉ Pascua caetaparo. Bairo ti rʉ̃mʉ caetaparo jʉ̃goye nipetiro judío majã Jerusalén macãpʉ jeto ámá. Caroarã nigarã Dios cʉ̃ caĩñajoro, na caátinucũrõrẽ bairo átigarã ásuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bairo bairã, judío majã quetiuparã pʉame Jesure cʉ̃ macã ñesẽãñuparã, cʉ̃ ñerĩ cʉ̃ preso jogarã. Bairo cʉ̃ macã ñesẽãrĩ, tocãnacãʉ̃pʉrea templo wiipʉ na jẽniñamacã ñesẽãñuparã. Atore bairo ĩñuparã: —¿Dope mʉjãã ĩ tʉ̃goñañati? ¿Jesús cʉ̃ã ati bose rʉ̃mʉrẽ cʉ̃ etaʉati, o cʉ̃ etaecʉati ato? —na ĩ jẽniñañuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mai, judío majã aperã sacerdote majã quetiuparã cʉ̃ã ni jĩcãʉ̃ ũcʉ̃ Jesure cʉ̃ caetarije quetire cʉ̃ catʉ̃goata, “Jicoquei cariape cʉ̃ quetibʉjʉáto,” ĩ roti cũñuparã, bairo na caĩquetibʉjʉro Jesure cʉ̃ ñe masĩgarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jĩcã wãmo peti jĩcã pẽnirõ cãnacã rʉ̃mʉ Pascua bose rʉ̃mʉ caetaparo jʉ̃goye, Jesús Betania macãpʉ jãã jʉ̃goámí. Ti macãpʉ cariayasiricʉre cʉ̃ cacatioricʉ Lázaro tʉpʉ jãã jʉ̃goámí. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Topʉ, cʉ̃ cacatioricʉ Lázarojãã ya wiipʉ jãã jʉ̃go ʉgarique ʉgawã, Jesure bʉtioro qũĩroarã. Mai, Marta pʉame jããrẽ ʉgarique batoo ámo. Lázaro pʉamea jãã menarẽ mesapʉ ʉgarui ámi. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bairo jãã caʉgaruiro, María pʉame nardo caroa cajʉtiñurĩjẽ cawapa pacarije pairo trescientos gramos majũrẽ jeamó. Bairo jeatíri, Jesús rʉporire piopeowõ. Bairo áti yaparo, cõ poañapõ mena pare bopowõ. Bairo cõ caáto, nipetiro ti wii pupeapʉ jʉtiñu bijapeticoapʉ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bairo Jesure cõ caátiere ĩña, Judas Iscariote, jãã mena macããcʉ̃, Jesure cabero cabʉsʉjãbuitirocapaʉ pʉame bairo ĩwĩ: ");
INSERT INTO cbcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Dopẽĩõ tie cawapa pacarijere trescientos denario moneda tiiri majũ nuniwapatari, cabopacarãrẽ na cõ jʉápeyupari? —ĩwĩ Judas jãã mena macããcʉ̃ pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mai, Judas pʉame cabopacarãrẽ caĩñamai ũcʉ̃ meena, tore bairo ĩ bʉsʉwĩ. Cajeruti jeyanucũrĩ majõcʉ ãnirĩ bairo ĩwĩ. Mai, cʉ̃, Judas pʉame jãã yaye dinero cajãñarĩ poare caĩñarĩcãnʉgõbojaʉ ãmi. Bairo caácʉ nimicʉ̃ã, ti poa macããjẽrẽ jericawori cʉ̃ majũ cʉ̃ caborijere cawapatinucũʉ̃ ãnirĩ, tore bairo ĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Bairo Judas cʉ̃ caĩrõ, Jesús pʉame qũĩwĩ: —Patowãcõrõ cõ ĩ bʉsʉpajʉ̃goeticõãña. Atio carõmio pʉame yʉ rupaʉri caãnipeere caroaro átijʉ̃goyeticũõ átiyamo tie cajʉtiñurĩjẽ mena. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Cabopacarã roquere tocãnacãnia na mʉjãã ĩñacõã ninucũgarã, mʉjãã watoa na caãno. Yʉ pʉame roque tocãnacãnia mʉjãã mena yʉ ãmerĩgʉ —qũĩwĩ Jesús Judare yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Capããrã judío majã mena macããna masĩñupã Betania macãpʉ Jesús jãã cʉ̃ cajʉ̃goãnierẽ. Torena, bʉtioro Jesure caĩñagarã ãnirĩ, ti macãpʉ jãã ĩñarã etawã. Bairi Jesús jeto meerẽ caĩñagarã ãnirĩ etawã. Lázaro cariayasiricʉ ãnacʉ̃rẽ Jesús cʉ̃ cacatioricʉ cʉ̃ãrẽ ĩñagarã, topʉ etawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Mai, sacerdote majã quetiuparã pʉame, “Cʉ̃, cariaricʉre Jesús cʉ̃ cacatio ĩñorĩqũẽrẽ caĩñarĩcãrã ãnirĩ capããrã judío majã marĩrẽ ricawatiri, Jesús pʉamerẽ cʉ̃ tʉ̃goʉsarã átiyama,” ãmeo ĩñuparã. Bairo ĩrĩ yua, Lázaro cʉ̃ãrẽ cʉ̃ pajĩã rocacõãgayuparã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mai, ti watoa caãno, capããrã camasã Jerusalẽpʉ ásúpa, Pascua bose rʉ̃mʉ netõrána. Bairi ti rʉ̃mʉ busuri rʉ̃mʉ caãno merẽ masĩñupã Jesús ti macãrẽ cʉ̃ caetapeere. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bairo cʉ̃ caetapeere camasĩrã ãnirĩ yua, peepũ ũnie carupaño querire pajure jeri, Jesure cʉ̃ bocáwã. Bairo cʉ̃ bocárána, atore bairo ĩ basa awajabʉsʉ ʉseanipeowã: —¡Nocãrõ to ñumajũcõãñati! ¡Nocãrõ cañuʉ majũrẽ Dios cʉ̃ catutuarije mena marĩ cʉ̃ cajoʉre cʉ̃ marĩ basapeoto! ¡Nocarõ cañuʉ Israel macããna Quetiupaʉ Rey majũrẽ cʉ̃ marĩ basapeoto! ");
INSERT INTO cbcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús pʉame burrore bocáetari cʉ̃ buipʉ pesari ámí Jerusalẽpʉ. Mai, Dios ya tutipʉ cʉ̃ãrẽ torea bairo cʉ̃ cabaipeere ĩ quetibʉjʉyupa: ");
INSERT INTO cbcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tʉ̃goña uwieticõãña mʉjãã Sión macã macããna. Ĩñañijate. Mʉjãã Quetiupaʉ Rey burro buipʉ pesari atíyami,” ĩ quetibʉjʉ woatuyupa Dios ya tutipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mai, caãnijʉ̃goro jãã, cʉ̃ cabuerã, jãã tʉ̃gomasĩẽpʉ̃ tore bairo ĩ quetibʉjʉriquere. Cabero, Jesús riari bero ʉmʉrecóopʉ cʉ̃ cawãmʉátó beropʉ roque, nipetirije Jesús cʉ̃ cabaipeere na cawoatujʉ̃goyetiriquere jãã masĩwʉ̃. “Jesús cʉ̃ cabaipeere ĩ quetibʉjʉrã bairo ĩ woatuyupa,” jãã ĩ tʉ̃goñamasĩwʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mai, Jesús Lázarore masã opepʉ caãcʉ̃rẽ cʉ̃ cacatioro caĩñarĩcãrã pʉame tie nipetiro na caĩñarĩqũẽrẽ na quetibʉjʉ netõrã áma camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bairi nipetiro camasã Jesure cʉ̃ bócarásúpa. Jesús, ti wãme catiorique caroare cʉ̃ caáti ĩñorĩqũẽrẽ na caquetibʉjʉro jʉ̃gori cʉ̃ bócarásúpa. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aperã fariseo majã pʉame atore bairo ãmeo ĩñuparã: —Merẽ mʉjãã masĩña: Tore bairo na caĩrĩjẽrẽ marĩ caẽñotaeticõãta, dope marĩ áti masĩẽtĩgarã. Ĩñañijate. ¡Nipetiro camasã cʉ̃ jetore tʉ̃goʉsarã átiyama! —ãmeo ĩñuparã fariseo majã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalẽpʉ cabose rʉ̃mʉ netõrátana mena macããna cʉ̃ã ãñupã jĩcããrã griego majã. Bairi na cʉ̃ã ti bose rʉ̃mʉ caãno Diore caĩroaratána ãñupã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bairi na pʉame Jesure caĩñagarã ãnirĩ, Felipe tʉpʉ etawã. Mai, Felipe pʉame Galilea yepa jĩcã macã Betsaida macããcʉ̃ ãmi. Bairi na pʉame bʉtioro atore bairo Felipere qũĩwã: —Jesure bʉtioro cʉ̃ jãã ĩñagaya. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Bairo cʉ̃ na caĩrõ tʉ̃go, Felipe, Andrés pʉamerẽ cʉ̃ quetibʉjʉámí. Bairi na pʉgarãpʉa Jesure cʉ̃ quetibʉjʉra etawã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Bairo cʉ̃ na caĩquetibʉjʉro tʉ̃go, Jesús pʉame atore bairo jãã ĩwĩ: —Merẽ petoaca cõñacoatíya yʉ, Camasã Jʉ̃gocʉre yʉ na capajĩãrocaro bero caãnimiatacʉ̃ãrẽ yʉ cacatitunu wãmʉápáro ʉmʉrecóo buipʉ nocãrõ caroaro caãnopʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cariape majũ mʉjãã yʉ quetibʉjʉya: Trigo apea ũnorẽ ñerĩ pupeapʉ marĩ caotero bero, tie oterique boaweri caputieticõãta, bairica majũ ríca jomasĩẽtĩgaro. Bairopʉa, ñerĩ pupeapʉ marĩ caotero bero, tie oterique boaweri caputiata roquere, caroa capee majũ rícacʉtinucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bairi tunu Diore caboena ãnirĩ, ati yepa macããjẽ jetore bʉtioro mʉjãã caʉgaripea ĩñacõãninucũata, cayasiparãrẽ bairo mʉjãã tuagarã. Bairi ati yepa macããjẽ carorijere mʉjãã caboeticõãta roque, Dios mena caãnicõãninucũparã mʉjãã ãnigarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bairi noo caborã yʉ caquetibʉjʉrijere catʉ̃goʉsagarã na tʉ̃gopaje ʉsaáto yʉ yayere, yʉ paabojari majãrẽ bairo na caãnigaata. Tore bairo na caápata, na cʉ̃ã yʉ caãnopʉre ãnigarãma. Bairi yʉ caquetibʉjʉrore bairo tʉ̃goʉsari caroaro caáticõãnarẽ yʉ Pacʉ Dios pʉame na ĩñamairĩ caroare na jogʉmi —jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Bairo jãã ĩ quetibʉjʉ yaparo, bairo jãã ĩwĩ Jesús: “¡Ãmea bʉtioro majũ yʉ yeripʉ yʉ tʉ̃goña yapapuaya! ¿Bairi, nopẽ bairo Diore cʉ̃ ñi jẽnicʉti? ‘Caacʉ popiye yʉ baio joroque cabaipee to baieticõãto,’ cʉ̃ ñi jẽnietigʉ. Bairo Diore cʉ̃ ñi jẽnietigʉ, ¡torecʉna popiye yʉ catãmʉorĩjẽ jʉ̃gori ati yepa macããna na carorije wapare netõʉ̃ acʉ́ yʉ apʉ́!” jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ĩ yaparo, atore bairo qũĩ jẽniwĩ Diopʉre: “Caacʉ, ãmerẽ mʉ catutuarije pʉamerẽ camasãrẽ na ĩñoña,” qũĩ jẽniwĩ Jesús. Bairo cʉ̃ caĩjẽnirõ, ʉmʉrecóopʉ atore bairo ĩ bʉsʉocajowʉ: “Merẽ yʉ catutuarije caroa áti ĩñorĩqũẽrẽ camasãrẽ na yʉ áti ĩñonucũña. Bairi tunu yʉ catutuarije caroa mena camasãrẽ na yʉ áti ĩñonemogʉ tunu,” ĩ bʉsʉocajowʉ jõbuipʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Camasã, cʉ̃tʉ catʉ̃goãna pʉame bairo caĩbʉsʉocajorijere tʉ̃gori, bairo ĩwã: —Bʉpore bairo ocajoapʉ. Aperã camasã jĩcããrã bairo ĩwã: —Diotʉ macããcʉ̃ ángel Jesús mena bʉsʉroyaami —ĩwã. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bairo na caĩrõ tʉ̃go, Jesús pʉame bairo na ĩwĩ: —Yʉ yaye macããjẽ rotie meerẽ bairo ĩ bʉsʉami Dios. Mʉjãã yaye macããjẽ rotie majũ roquere bairo ĩ bʉsʉami. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bairi tunu merẽ ãmea niña Dios ati yepa macããna nipetiro camasãrẽ cʉ̃ caĩñabeseri rʉ̃mʉ. Bairi wãtĩ ati yepa quetiupaʉ cʉ̃ãrẽ ãmea Dios cʉ̃ rocacõãgʉmi yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bairi tunu yucʉpãĩpʉ yʉ papuaturi yʉ na canemʉgõnʉcõrõ jʉ̃gori, ati yepa macããna capããrã na carorije wapare netõrĩ, yʉ yarã jeto na ãnio joroque na yʉ átigʉ —jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Bairo Jesús cʉ̃ caĩrĩjẽrẽ cʉ̃ tʉ̃gomasĩata, bairo yucʉpãĩpʉ cʉ̃ na capapuaro cʉ̃ cariápeere quetibʉjʉgʉ ĩmiwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Camasã pʉame bairo cʉ̃ caĩquetibʉjʉrijere tʉ̃gorã, atore bairo qũĩwã Jesure: —Dios ya tutipʉ na cawoaturiquere camasã jãã na caquetibʉjʉro atore bairo jeto jãã tʉ̃gonucũña: Mesías Dios cʉ̃ cajoʉ tocãnacã rʉ̃mʉ cacaticõãninucũʉ̃ nigʉmi. ¿Nopẽ mʉ pʉame, “Dios cʉ̃ cajoʉ Camasã Jʉ̃gocʉ pʉame yucʉpãĩpʉ yʉ na capapuarocaro yʉ riacoagʉ,” miñati? ¿Bairi ni pʉame cʉ̃ ãnicʉti cʉ̃, camasã Jʉ̃gocʉre bairo caãcʉ̃? —qũĩ jẽniñawã camasã Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Bairo camasã cʉ̃ na caĩrõ tʉ̃go, Jesús pʉame atore bairo na ĩwĩ: —Mʉjãã mena mai ati yepapʉ ãcʉ̃, yʉa, yʉ ãniña ati yepa macããna canaitĩãrõpʉ caãnarẽ bairo caãnarẽ cajĩñawoaʉre bairo caácʉ majũ. Baipʉa, yoaro majũ mʉjãã mena yʉ ãmerĩgʉ. Bairi mʉjãã mena yʉ caãno mai, yʉ caquetibʉjʉrijere caroaro yʉ tʉ̃goʉsaya, roro jãã tãmʉore, ĩrã. Bairi merẽ mʉjãã masĩña: Camasã ñami canaitĩãrõpʉ jĩñawoena áná, “Cariape jãã áná,” ĩ masĩẽtĩñama. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bairi yʉ, cajĩñawoʉre bairo caãcʉ̃, mʉjãã mena mai yʉ caãno ĩñarĩ, caroaro majũ yʉ tʉ̃goʉsaya. Canaitĩãrõpʉ caãnarẽ bairo mʉjãã caãmerĩparore bairo ĩrã, caroaro cariape yʉ caquetibʉjʉrijere yʉ tʉ̃goʉsaya —na ĩwĩ Jesús camasãrẽ. Bairo na ĩ quetibʉjʉ yaparo, aperopʉ na rutiweyocoámí Jesús yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bairo Jesús pʉame nocãrõ caroa Dios yaye áti ĩñorĩqũẽrẽ na caĩñarõ, na cʉ̃ caáti ĩñomiatacʉ̃ãrẽ, judío majã pʉame, “Cariape caroare marĩ áti ĩñoʉ átiyami,” qũĩ tʉ̃goʉsaema Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bairi profeta Isaías ãnacʉ̃ Dios ya tutipʉ cʉ̃ cawoaquetibʉjʉcũrĩcãrõrẽ bairo bai etawʉ yua. Mai, profeta Isaías ãnacʉ̃ pʉame Dios ya tutipʉ atore bairo ĩ woatujʉ̃goyeticũñupĩ: “Dios, jãã Quetiupaʉ, jãã caquetibʉjʉrijere, noa ũna tiere tʉ̃goʉsaetiyama. Bairi tunu mʉ yaye caroa áti ĩñorĩqũẽrẽ ĩñamajũcõãmirãcʉ̃ã, cariape jãã tʉ̃goʉsaetiyama,” ĩ woatuyupi. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bairi camasã profeta Isaías ãnacʉ̃ cʉ̃ caĩwoaquetibʉjʉricarore bairo Jesús cʉ̃ caquetibʉjʉrijere cʉ̃ tʉ̃goʉsagaema. Tunu profeta Isaías ãnacʉ̃ apepaʉpʉ cʉ̃ãrẽ atore bairo ĩ woatu quetibʉjʉcũñañupĩ: ");
INSERT INTO cbcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Cacaapee cʉ̃gorã nimirãcʉ̃ã, di rʉ̃mʉ ũno caroa Dios cʉ̃ caáti ĩñorĩjẽrẽ na ĩñamasĩẽtĩõ joroque na átigʉmi. Ati poa macããna na yeripʉ catʉ̃goñamasĩgaetoi, cacaapee cʉ̃gorã nimirãcʉ̃ã, cʉ̃ caátiere na ĩñamasĩẽtĩõ joroque na átigʉmi. Tunu bairoa caãmoo cʉ̃gorã nimirãcʉ̃ã, cʉ̃ yaye quetire na tʉ̃gomasĩẽtĩõ joroque na átigʉmi. Na yeripʉre tʉ̃goñamasĩẽtĩñama na cʉ̃ caquetibʉjʉgamirĩjẽrẽ. Bairi, ‘Jãã mʉ netõwã,’ ĩẽtĩnucũñama Diore,” ĩ quetibʉjʉyupi Isaías ãnacʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mai, Isaías ãnacʉ̃ pʉame tore bairo cʉ̃ caĩwoaturijere merẽ ĩñañupĩ Dios cʉ̃ catutuarije mena ati yepapʉ Jesús cʉ̃ cabaipeere. Bairo Jesús cʉ̃ cabaipeere caĩñarĩcʉ̃ ãnirĩ tore bairo quetibʉjʉyupi. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bairo Jesure cʉ̃ na catʉ̃goʉsaetimiatacʉ̃ãrẽ, capããrãpʉa judío majã mena macããna cʉ̃ caquetibʉjʉrijere tʉ̃goʉsawã. Bairi tunu jĩcããrã judío majã quetiuparã caãnimajũrã cʉ̃ã Jesús cʉ̃ caquetibʉjʉrijere cʉ̃ tʉ̃goʉsawã. Bairo Jesure cʉ̃ tʉ̃goʉsamirãcʉ̃ã, fariseo majãrẽ uwiri, baujaro, “Jesure catʉ̃goʉsarã jãã ãniña,” ĩẽma. “Bairo marĩ caĩata, sinagoga ñubuerica wiiripʉ marĩ caãno fariseo majã marĩ acuwiyorema,” ĩrã, baujaro Jesure cʉ̃ na catʉ̃goʉsarijere bai ĩñogaema. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mai, na pʉame Dios bʉtioro na cʉ̃ caĩñajesopee ũnorẽã, bʉtioro camasã pʉame narẽ na caĩroaro bowã. Bairi Jesús pʉamerẽ baujaro tʉ̃goʉsagaema. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Bairo jãã ĩ quetibʉjʉ yaparo, Jesús pʉame bʉsʉrique tutuaro mena atore bairo ĩwĩ: “Ni jĩcãʉ̃ ũcʉ̃ yʉ caquetibʉjʉrijere catʉ̃goʉsaʉ pʉame, yʉ jeto merẽ tʉ̃goʉsaʉ átiyami. Yʉre cajoricʉ yʉ Pacʉ Dios cʉ̃ãrẽ cʉ̃ tʉ̃goʉsaʉ átiyami. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bairi tunu ni jĩcãʉ̃ ũcʉ̃ yʉre caĩñanʉcʉ̃bʉgoʉ yʉ jeto meerẽ ĩñanʉcʉ̃bʉgoʉ átiyami. Bairi yʉre cajoricʉ yʉ Pacʉ Dios cʉ̃ãrẽ caĩñanʉcʉ̃bʉgoʉre bairo ácʉ baiyami. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉa, yʉ ãniña camasãrẽ canaitĩãrõpʉ caãnarẽ cajĩñawoʉre bairo caátiatácʉ ati yepapʉre. Bairi yʉ caquetibʉjʉrijere catʉ̃goʉsarã pʉame canaitĩãrõpʉ caãnarẽ bairo roro átiãmerĩgarãma. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bairi yʉ caquetibʉjʉrijere tʉ̃gocõãmirãcʉ̃ã, yʉ caquetibʉjʉrore bairo caáperãrẽ popiye na baio joroque na átiacʉ́ mee yʉ apʉ́. Bairi tunu ati yepa macããna camasãrẽ yʉ majũã na átirei acʉ́ mee yʉ baiwʉ. Na carorije wapa roquere ati yepa macããna camasãrẽ na netõʉ̃ ácʉ yʉ baiwʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bairo yʉre boetiri, yʉ caquetibʉjʉrijere catʉ̃goʉsagaenarẽ carepaʉ merẽ nicõãñami. Bairi atie mʉjãã yʉ caquetibʉjʉrijere na catʉ̃goʉsagaetie wapa jʉ̃gori popiye na baio joroque na átigʉmi camasãrẽ Dios, cʉ̃ caĩñabeseri rʉ̃mʉ catʉsari rʉ̃mʉ caãno yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉ pʉame yʉ majũã yʉ catʉ̃goñarĩjẽ mena mee bʉsʉri mʉjãã yʉ quetibʉjʉnucũña. Yʉ Pacʉ Dios yʉre ati yepapʉ cajoricʉ pʉame roque yʉ caĩpeere, yʉ caátipee cʉ̃ãrẽ yʉ átiroticũwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bairi yʉ masĩña baipʉa yʉ Pacʉ Dios yʉ cʉ̃ caátiroticũrĩqũẽrẽ: Camasã yeri capetietiere na cacʉ̃gomasĩparore bairo ĩ, tore bairo yʉ quetibʉjʉ rotijowĩ. Bairi yʉ caĩrĩjẽ pʉame yʉ majũã yʉ caĩrĩjẽ mee niña. Yʉ Pacʉ cʉ̃ caĩquetibʉjʉrotijoricarore bairo jeto roque cariape ñi quetibʉjʉnucũña,” jãã ĩ quetibʉjʉwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Judío majã bose rʉ̃mʉ Pascua caetaparo, jĩcã rʉ̃mʉa rʉsawʉ merẽ. Cʉ̃ pacʉ cʉ̃ cacũrĩcã rʉ̃mʉ caetaro, jããrẽ pitiri cʉ̃ pacʉ Dios tʉpʉ átí cʉ̃ caãniápére masĩcõãwĩ merẽ Jesús. Bairi ati yepa macããna marĩ cʉ̃ yarãrẽ marĩ maimajũcõãwĩ Jesús. Bairo jeto marĩ maicõã ninucũgʉmi tocãnacã rʉ̃mʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Bairi merẽ Judas, Simón Iscariote macʉ̃rẽ cʉ̃ yeripʉ wãtĩ cʉ̃ jãcõã bauwĩ, Jesure cʉ̃ cabʉsʉjãbuitirocamasĩparore bairo ĩ. Bairi Jesús pʉame masĩcõãwĩ, Dios cʉ̃ carotijoricʉ ãnirĩ. Tunu bairoa Dios tʉpʉa cʉ̃ catunuápée cʉ̃ãrẽ masĩcõãwĩ Jesús. Bairi cʉ̃ pacʉ Dios pʉame nipetirije rotimasĩrĩqũẽrẽ cʉ̃ joyupi Jesure. Bairi jãã jĩcãrõ mesapʉ caʉgaruimiatacʉ, Jesús pʉame wãmʉnʉcãwĩ. Bairo wãmʉnʉcãrĩ, cʉ̃ jutiro cabui macããtõrẽ tuwe cũcõãwĩ. Bairo áti yaparo, juti aserore neátiri, tore cʉ̃ isitawẽpʉ nejiyatuwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bairo áti yaparo, ocore jotʉ bapapʉ waapiojãwĩ. Bairo átiri, jãã, cʉ̃ cabuerã rʉporire cosejʉ̃gowĩ Jesús. Bairo cose yaparori bero, jutii asero cʉ̃ isitawẽpʉ cʉ̃ capajũãtuatato mena jãã rʉporire parebopowĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedro pʉame cʉ̃ rʉporire Jesús cʉ̃, cʉ̃ cacosegaro, bairo qũĩwĩ: —Yʉ Quetiupaʉ, ¿yʉ cʉ̃ãrẽ yʉ rʉporire mʉ coseiáti? ");
INSERT INTO cbcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Bairo Simón Pedro cʉ̃ caĩrõ tʉ̃go, Jesús pʉame bairo qũĩwĩ: —Ãmeacã bairo mʉ yʉ caátigarijere mʉ tʉ̃goña masĩẽtĩña mai. Caberopʉ tiere mʉ tʉ̃goña masĩgʉ yua —qũĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro pʉame bairo Jesús cʉ̃ caĩrõ tʉ̃go, bairo qũĩwĩ: —¡Yʉa, yʉ rʉporire mʉ yʉ cose rotietimajũcõãgʉ! Bairo cʉ̃ caĩrõ, Jesús pʉame bairo qũĩwĩ Pedrore: —Bairo mʉ yʉ cacoseeticõãta, mʉa, yʉ yarã mena macããcʉ̃rẽ bairo mʉ ãmerĩgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jesús bairo cʉ̃ caĩrõ tʉ̃go, bairo qũĩwĩ Simón Pedro pʉame: —Yʉ Quetiupaʉ, toroque yʉ rʉpori jetore coseeticõãña. ¡Bairi yʉ wãmorĩ, yʉ rʉpoa cʉ̃ãrẽ yʉ cosepeyocõãña yua! —qũĩwĩ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Bairo cʉ̃ caĩmiatacʉ̃ãrẽ, Jesús pʉame bairo qũĩnemowĩ tunu: —Ãmeacã merẽ caroaro caʉgueri usacosere yaparoatana marĩ caãmata, nairõãcã usanemoa maninucũña, merẽ caroaro nipetiro rupaʉ caʉgueri mána ãnirĩ. Bairi marĩ rʉpori jetore marĩ cacosenemopee niña. Bairãpʉa, carorije cawapa mána, caʉgueri mánarẽ bairo caãna mʉjãã ãniña. Bairo cabairã nimirãcʉ̃ã, bairãpʉa nipetiro tocãnacãʉ̃pʉa bairo mʉjãã ãmerĩña —qũĩwĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Mai, “Bairãpʉa, nipetiro tocãnacãʉ̃pʉa caʉgueri mánarẽ bairo mee mʉjãã ãniña,” jãã cʉ̃ caĩata, cʉ̃rẽ cabʉsʉjãbuitirocapaʉre cʉ̃ masĩrĩ, bairo jãã ĩwĩ Jesús. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bairo jãã, cʉ̃ cabuerã rʉporire cose yaparo, cabuimacããtõ jutiro cʉ̃ cawecũatatore nejãñawĩ tunu Jesús. Bairo áti yaparo, mesapʉ ruiwĩ jãã mena. Bairo etanumurĩ bero, atore bairo jãã ĩ jẽniñawĩ Jesús: —¿Mʉjãã masĩñati dope ĩgʉ mʉjãã rʉporire yʉ coseupari? ");
INSERT INTO cbcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉjãã pʉame yʉre, jããrẽ Cabuei, jãã Quetiupaʉ, yʉ mʉjãã ĩ piinucũña. Bairo yʉre ĩ piirã, cariapea ĩrã yʉ mʉjãã ĩnucũña. Cʉ̃ã yʉ ãniña baipʉa. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bairi yʉ pʉame jããrẽ Cabuei, jãã Quetiupaʉ, mʉjãã caĩpiinucũʉ̃ pʉame, mʉjãã rʉporire yʉ cose yaparoya merẽ. Bairi mʉjãã cʉ̃ã torea bairo mʉjãã majũ mʉjãã rʉporire caãmeo coseparã mʉjãã ãniña tocãnacãʉ̃pʉrea. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bairi mʉjããrẽ ati wãmerẽ mʉjãã yʉ áti ĩñoña, mʉjãã cʉ̃ã tore bairo mʉjãã caãmeo átinucũparore bairo ĩ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cariape mʉjãã ñi quetibʉjʉya: Ni jĩcãʉ̃ ũcʉ̃ cʉ̃ quetiupaʉre capaabojari majõcʉ cʉ̃ quetiupaʉ netõrõ ãmerĩñami. Bairoa tunu ni jĩcãʉ̃ ũcʉ̃ cajooecoʉ pʉame cʉ̃rẽ cajoricʉ netõrõ ãmerĩñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bairo yʉ caĩquetibʉjʉrijere tʉ̃goʉsari caroaro mʉjãã caáti ãmata, caroaro ʉseanirĩqũẽ mena mʉjãã ãnimasĩgarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Baipʉa, mʉjãã nipetirãrẽ, ‘Bairo mʉjãã baigarã,’ ĩ bʉsʉ mee mʉjãã ñiña. Yʉ pʉame roque merẽ yʉ masĩña yʉ cabesericarã mʉjãã caãnierẽ. Bairi Dios ya tutipʉ na caĩwoatuquetibʉjʉ jʉ̃goyeticũrĩcãrõrẽ bairo baigaro. Atore bairo ĩ woatu quetibʉjʉyupa: ‘Yʉ mena caʉgarui nimicʉ̃ã, yʉre cateei yʉ wapacʉ majũ tuagʉmi,’ ĩ woatuyupa. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Bairi merẽ mʉjããrẽ cariape mʉjãã quetibʉjʉ weyojʉ̃goyeticũʉ̃ ñiña. Bairi mʉjãã yʉ caquetibʉjʉrore bairo cabairo ĩñarã yua, ‘Dios cʉ̃ cajoricʉ majũ niñami,’ yʉ mʉjãã ĩgarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cariape mʉjããrẽ ñi quetibʉjʉya: Ni jĩcãʉ̃ ũcʉ̃ yʉ caquetibʉjʉrotijoʉre catʉ̃goʉsaʉ ũcʉ̃ pʉame yʉre catʉ̃goʉsaʉre bairo niñami. Bairi tunu ni jĩcãʉ̃ ũcʉ̃ yʉ caquetibʉjʉrijere catʉ̃goʉsaʉ pʉame yʉre cajoricʉ cʉ̃ãrẽ catʉ̃goʉsaʉre bairo niñami,” jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bairo jãã ĩ quetibʉjʉ yaparo, Jesús pʉame bʉtioro tʉ̃goñarĩqũẽ pairi cariapea jãã quetibʉjʉcõãwĩ cʉ̃ cabaipeere. Atore bairo jãã ĩwĩ: —Cariape majũ mʉjããrẽ ñi quetibʉjʉya: Mʉjãã mena macããcʉ̃ jĩcãʉ̃ roro yʉre ĩ bʉsʉjãbuitirocagʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bairo Jesús jãã cʉ̃ caĩrõ tʉ̃gori, jãã cʉ̃ cabuerã pʉame jãã majũ tocãnacãʉ̃pʉa, jãã ãmeo ĩña maniapʉ̃. “Cʉ̃rẽ ĩ ĩmi Jesús,” jãã ĩ masĩẽpʉ̃. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mai, yʉ pʉame Jesús bʉtioro cʉ̃ caĩñamai majũ yʉ ãmʉ. Bairi yʉ mena Jesús pʉame cʉ̃ cabʉsʉnemopee ãmʉ, jãã caʉgaruiãnitoye mai, cʉ̃ cabaipeere. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bairi Pedro pʉame yʉre ĩñarĩqũẽ mena yasioroa yʉ quetibʉjʉ jowĩ: “Noa na caátipeere tore bairo qũĩñati,” qũĩ jẽniñáto ĩ, tore bairo ámi Pedro. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Bairo cʉ̃ caátimasĩõrĩjẽrẽ ĩñarĩ, yʉ pʉame cʉ̃tʉ jãñurĩ etanʉcãrĩ atore bairo cʉ̃ ñi jẽniñawʉ̃ Jesure: —Yʉ Quetiupaʉ, ¿ni majũ cʉ̃ ãniñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús pʉame bairo cʉ̃ yʉ caĩjẽniñarõ, atore bairo ñiwĩ: —Pan yosenerĩ yʉ canuni pʉame cʉ̃ majũ nigʉmi. Bairo jãã ĩ quetibʉjʉ yaparo, Jesús tocãrõã yua cʉ̃ pããrẽ yosenunijowĩ Judas Simón Iscariote macʉ̃rẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bairo pããrẽ cʉ̃ cañerõ bero, Judas yeripʉ wãtĩ merẽ nicõãñupĩ. Bairo cʉ̃ cabairo ĩña, tocãrõã Jesús pʉame bairo qũĩwĩ yua: —Bairo mʉ caátigarijere tãmurĩã áticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bairo Jesús cʉ̃ caĩrõ, jãã cʉ̃ cabuerã mesapʉ caʉgaruiatana, jĩcãʉ̃ ũcʉ̃ pʉamena, “Bairo Jesús ĩgʉ ĩñami,” jãã ĩ tʉ̃goña masĩẽpʉ̃, tiere tʉ̃gorã. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mai, Judas pʉame jãã yaye dinero cajãñarĩ poare caĩñarĩcãnʉgõbojari majõcʉ ãmi. Bairi atore bairo jĩcããrã jãã mena macããna ĩ tʉ̃goñacõãwã: “‘Bose rʉ̃mʉ macããjẽ rotie mʉ wapati ápá,’ qũĩgʉ ĩatacʉmi, o ‘Apeye ũnie wapatiri cabopacarãrẽ na nunijã,’ ĩgʉ ĩatacʉmi,” jãã ĩ tʉ̃goñacõãwʉ̃ jãã pʉame. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mai, Judas pʉame Jesús pããrẽ cʉ̃, cʉ̃ cayosenunirõ beroaca, jicoquei witicoámí merẽ yua. Bairo cʉ̃ cawitiátípaʉ merẽ ñamipʉ ãmʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cʉ̃ cawitiatato bero, Jesús pʉame bairo jãã ĩwĩ yua: —Ãmea Dios macʉ̃ yʉ caãnierẽ, yʉ, Camasã Jʉ̃gocʉ, yʉ áti ĩñogʉ. Bairi Dios pʉame yʉ jʉ̃gori nocãrõ cʉ̃ catutuarije caroare áti ĩñogʉmi camasãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yʉ, Camasã Jʉ̃gocʉ nocãrõ yʉ catutuarije yʉ caáti ĩñoata, yʉ Pacʉ Dios cʉ̃ã jãã catutuãnierẽ ĩñogʉmi. Tãmurĩã tore bairo áti ĩñogʉmi Dios cʉ̃ camasĩrĩjẽrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ yarã, yʉ pũnaarẽ bairo caãna yoaro mʉjãã mena yʉ tuaetigʉ ati yepapʉre. Bairo mʉjãã yʉ caaweyoro bero, mʉjãã pʉame bʉtioro yʉ mʉjãã macãmigarã. Bairi mʉjãã ñinemoña tunu, judío majãrẽ na yʉ caĩquetibʉjʉatatorea bairo ñi quetibʉjʉgʉ: Yʉre mʉjãã macãmigarã. Bairo yʉ macãmirãcʉ̃ã, yʉ caátípaʉpʉre caetamasĩẽna ãnirĩ, yʉ mʉjãã bócaetigarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bairi atie cawãma wãmerẽ mʉjãã yʉ átiroti cũña: Mʉjãã majũ tocãnacãʉ̃pʉa mʉjãã ãmeo maicõã ninucũwã. Bairi yʉ, mʉjããrẽ yʉ camairõrẽã bairo mʉjãã cʉ̃ã tocãnacãʉ̃pʉrea ãmeo maicõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bairi tocãnacãʉ̃pʉrea mʉjãã caãmeomairõ ĩñarã, nipetiro camasã mʉjããrẽ, “Na roque Jesús cʉ̃ cabuerã majũ niñama,” mʉjãã ĩ ĩñagarãma —jãã ĩwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Bairo Jesús cʉ̃ caĩquetibʉjʉro bero, Simón Pedro atore bairo qũĩ jẽniñawĩ: —Yʉ Quetiupaʉ, ¿noopʉ ágʉ, tore bairo mi quetibʉjʉyati jããrẽ? Jesús pʉame atore bairo qũĩ yʉwĩ: —Mʉa, noo yʉ caátópʉre yʉ mʉ ʉsamasĩẽtĩgʉ mai. Caberopʉ roque yʉ tʉpʉ mʉ ámasĩgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bairo cʉ̃ caĩrõ tʉ̃go, Pedro pʉame atore bairo qũĩwĩ: —Yʉ Quetiupaʉ, ¿dopẽĩ ãmerẽ mai mʉ yʉ ʉsamasĩẽtĩbujiocʉti? ¡Cotericaro mano mʉ cariaparo ũnorẽã, yʉ pʉame roque yʉ riamasĩña! —qũĩwĩ Pedro Jesure. ");
INSERT INTO cbcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Bairo Pedro cʉ̃ caĩrõ, Jesús pʉame bairo qũĩwĩ: —¿Cariapea cotericaro mano yʉ jʉ̃gori mʉ riagayati? Bairi mʉrẽ cariapea ñiña: Ãbocʉ cʉ̃ capiiparo jʉ̃goye, itiani majũ, “Cʉ̃ yʉ masĩẽtĩña Jesure,” yʉ mitogʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Yʉ yarã, tʉ̃goñarĩqũẽ paieticõãña. Dios mena tʉ̃goñatutuari yʉ mena cʉ̃ãrẽ tʉ̃goñatutuacõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉ Pacʉ cʉ̃ caãno ʉmʉrecóopʉre ãnapaʉri capee majũ niña. Yʉ Pacʉ tʉpʉ ãnimasĩrĩqũẽ caãmerĩcõãta, ‘Mʉjãã caãnipapaʉre mʉjãã yʉ qũẽnojʉ̃goyetibojaʉ áya,’ mʉjãã ñietibujioricʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bairi mai, yʉ pʉame mʉjãã caãnipapaʉ roto mʉjãã qũẽnobojaʉ ácʉ́ yʉ baiya. Bairo qũẽno yaparori bero roque, mʉjããrẽ yʉ nei atígʉ, yʉ mena mʉjãã caãnimasĩparore bairo ĩ. Bairo yʉ caató, mʉjãã cʉ̃ã yʉ caãnipaʉa mʉjãã ãnigarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Merẽ mʉjãã etamasĩña yʉ jʉ̃gori yʉ caátípaʉpʉre.” ");
INSERT INTO cbcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Bairo jãã cʉ̃ caĩrõ tʉ̃go, Tomás pʉame Jesure bairo qũĩwĩ: —Jãã Quetiupaʉ, jãã masĩẽtĩña. ¿Noopʉre ágʉ bairo miñati? ¿Dope bairo jãã masĩrãati mʉ caápáwãpʉre? ");
INSERT INTO cbcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús pʉame bairo cʉ̃ caĩrõ, atore bairo qũĩwĩ: —Yʉa, yʉ ãniña, maa átáwãrẽ bairo caãcʉ̃. Yʉa, yʉ ãniña cariape caácʉ. Caticõãnio joroque caácʉ yʉ ãniña camasãrẽ. Yʉ jʉ̃gori mena jeto mʉjãã etamasĩgarã yʉ Pacʉ cʉ̃ caãnopʉre. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yʉre mʉjãã camasĩata, yʉ Pacʉ cʉ̃ãrẽ cʉ̃ mʉjãã masĩcõãgarã. Merẽ ãmea yʉ mʉjãã masĩña. Bairo yʉre camasĩrã ãnirĩ, yʉ Pacʉ cʉ̃ caátiãnie cʉ̃ãrẽ caĩñacõãnarẽ bairo mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Bairo Jesús jãã cʉ̃ caĩrõ tʉ̃go, Felipe pʉame Jesure bairo qũĩwĩ: —Yʉ Quetiupaʉ, mʉ Pacʉre jãã ĩñoña. Bairo jãã mʉ caĩñoata, jããrẽã tocãrõã ñucõãña yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Bairo cʉ̃ caĩrõ, Jesús pʉame atore bairo qũĩwĩ: —¡Ago tame Felipe! Nocãrõ yoaro mʉjãã mena yʉ caãnimiatacʉ̃ãrẽ mai, ¿yʉ mʉ masĩẽtĩrecoayati? Yʉre caĩñanucũʉ̃, yʉ Pacʉ cʉ̃ãrẽ caĩñacõãninucũʉ̃rẽ bairo ãcʉ̃ baiyami merẽ. ¿Dopẽĩ, ‘Mʉ Pacʉre jãã ĩñoña,’ yʉ miñati? ");
INSERT INTO cbcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Cariape yʉ Pacʉ mena yʉ caãnierẽ, bairi yʉ Pacʉ cʉ̃ã yʉ mena cʉ̃ caãnierẽ mʉjãã masĩẽtĩñati? Bairi atore bairo mʉjãã yʉ caĩquetibʉjʉrije yʉ majũã yʉ catʉ̃goñarõ mee bairo niña. Yʉ Pacʉ, yʉ mena caãcʉ̃ mena roque cʉ̃ carotiro mena bairo caroaro cʉ̃ paariquere yʉ átiãninucũña. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mʉjãã cʉ̃ã cariape masĩña yʉ Pacʉ mena yʉ caãnierẽ. Bairi yʉ Pacʉ cʉ̃ã yʉ mena cʉ̃ caãnierẽ masĩña. Bairo baiena cʉ̃ã, jĩrĩãpʉra mʉjãã yʉ caáti ĩñonucũrĩjẽrẽ ĩñarĩ, mʉjãã cʉ̃ã cariapea masĩña. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bairi mʉna mee mʉjããrẽ ñiña: Yʉ caquetibʉjʉrijere cariape catʉ̃goʉsaʉ ãnirĩ yʉ caátie ũnierẽ cʉ̃ cʉ̃ã átimasĩgʉmi. Yʉ roque yʉ Pacʉ tʉpʉ yʉ caácoato jʉ̃gori, cʉ̃ pʉame jĩrĩã netõjãñurõ caroaro majũ átimasĩgʉmi. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bairi yʉ wãme mena ĩrĩ nipetirije mʉjãã cajẽnirõ, mʉjãã caĩrõrẽã bairo mʉjãã yʉ átibojagʉ. “Yʉ Pacʉ Dios yʉ jʉ̃gori yʉ Pacʉ cʉ̃ catutuarijere na ĩñáto na cʉ̃ã,” ĩ bairo mʉjããrẽ yʉ áti ĩñogʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bairi yʉ wãme mena ĩrĩ tocãnacã wãme mʉjãã cajẽnirõ cãrõ mʉjãã cajẽnirõrẽã bairo mʉjãã yʉ átibojanucũgʉ yua —jãã ĩ quetibʉjʉwĩ Jesús, jãã, cʉ̃ cabuerãrẽ. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Bairo jãã ĩ quetibʉjʉ yaparori bero, bairo jãã ĩ quetibʉjʉwĩ tunu Jesús: “Yʉre mʉjãã camaiata, yʉ caroticũrĩjẽ cʉ̃ãrẽ torea bairo caroaro mʉjãã áticõã ninucũgarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Yʉ pʉame yʉ Pacʉpʉre mʉjãã yʉ jẽnibojagʉ, apei mʉjããrẽ cajʉ̃goãnitutuapaʉ, Espíritu Santo cariape majũ caãcʉ̃rẽ, tocãnacãni mʉjãã mena cʉ̃ caãninucũparore bairo ĩ. Ati yepa macããna roque, cʉ̃, Espíritu Santore na yeripʉ cʉ̃ cʉ̃goetinucũñama. Bairo cʉ̃ cʉ̃goetiri, cʉ̃ caátie, cʉ̃ catutuarije cʉ̃ãrẽ ĩñajesoetinucũñama. Bairi mʉjãã pʉame roque cʉ̃ mʉjãã masĩjãñuña, cʉ̃ pʉame mʉjãã mena tocãnacãni mʉjããpʉre cʉ̃ caãno jʉ̃gori. Bairi tocãnacãnia mʉjãã mena, mʉjããpʉre ãnicõã ninucũgʉmi yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Baipʉa, mʉjãã yʉ aweyocoápérigʉ. Yʉ atígʉ tunu, mʉjãã mena tocãnacã rʉ̃mʉa ãnicõã ninucũgʉ. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Merẽ petoaca rʉsaya ati yepa macããna camasã yʉre na caĩñajãnaparo yua. Mʉjãã pʉame roque tocãnacã rʉ̃mʉa yʉ mʉjãã masĩcõã ninucũgarã mʉjãã mena yʉ caãnicõãninucũrĩjẽrẽ. Yʉ pʉame caãnicõãninucũʉ̃ yʉ ãniña. Bairi torea bairo mʉjãã cʉ̃ã mʉjãã ãnicõã ninucũgarã. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mʉjããrẽ Espíritu Santo cʉ̃ caetari rʉ̃mʉ caãno yua, mʉjãã masĩgarã yʉ Pacʉ mena yʉ caãnierẽ. Bairi mʉjãã cʉ̃ã yʉ mena ãna, yʉ cʉ̃ã bairi mʉjãã mena yʉ caãnie cʉ̃ãrẽ mʉjãã masĩgarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ caroticũrĩjẽrẽ tʉ̃goʉsari, yʉ caroticũrĩjẽrẽ bairo caáticõãninucũʉ̃ pʉame cariapea yʉ maicõãninucũʉ̃ átigʉmi yua. Bairi yʉre camaicõãcʉ̃rẽ yʉ Pacʉ cʉ̃ã cʉ̃ maicõã ninucũgʉmi. Yʉ cʉ̃ã cʉ̃ yʉ maicõã ninucũgʉ. Bairi cʉ̃ ñiñogʉ yʉ camasĩrĩjẽrẽ yua,” jãã ĩ quetibʉjʉwĩ Jesús cʉ̃ cabuerãrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Apei Judas cawãmecʉcʉ, Judas Iscariote mee caãcʉ̃ pʉame atore bairo Jesure qũĩ jẽniñawĩ: —Yʉ Quetiupaʉ, ¿dopẽĩ jãã jetore mʉ camasĩrĩjẽrẽ jãã miñoʉati? ¿Dopẽĩ ati yepa macããna camasã cʉ̃ãrẽ na miñoecʉati? —qũĩ jẽniñawĩ. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús pʉame bairo Judas cʉ̃ caĩjẽniñarõ, atore bairo qũĩ yʉwĩ: —Yʉre camai, yʉ bʉsʉrique cʉ̃ãrẽ catʉ̃goʉsaʉ niñami. Bairi yʉ Pacʉ cʉ̃ã cʉ̃ maijãñugʉmi. Bairi yua yʉ Pacʉ mena pʉgarãpʉa cʉ̃ mena jãã ãnicõã ninucũgarã tocãnacã rʉ̃mʉa yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉre camaiecʉ̃ pʉame roque yʉ bʉsʉrique cʉ̃ãrẽ catʉ̃goʉsaecʉ niñami. Tunu bairoa yʉ caĩquetibʉjʉrije yʉ majũã yʉ catʉ̃goñarõã, yʉ caĩbʉsʉrije mee niña. Yʉ Pacʉ Dios yʉre cajoricʉ cʉ̃ caĩbʉsʉ quetibʉjʉrotirije majũ roque niña. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bairi mʉjãã mena ãcʉ̃ mai, nipetirije atiere mʉjãã ñi quetibʉjʉya. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bairi Espíritu Santo mʉjããrẽ cajʉ̃goãnitutuapaʉ, yʉ Pacʉ yʉ jʉ̃gori mʉjããrẽ cʉ̃ cajopaʉ pʉame nipetirije mʉjãã masĩõgʉmi. Bairi tunu atie mʉjãã yʉ caquetibʉjʉrije nipetirijere tʉ̃goña masĩpetio joroque mʉjãã átigʉmi yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Bairi yʉ pʉame yʉ ácoagʉ. Bairo ácʉ́, mʉjããrẽ yʉ joya jĩcãrõ tʉ̃ni tʉ̃goña yeri jãña ãnajẽrẽ. Tie jĩcãrõ tʉ̃ni tʉ̃goña yeri jãñarĩqũẽ caãnicõãnie yʉ yaye majũrẽ mʉjãã yʉ joya yua. Ati ʉmʉrecóo macããna camasã na cajonucũrõrẽ bairo mee mʉjãã yʉ joya. Torena, tʉ̃goña yapapuaeticõãña. Uwitʉ̃goñaeticõãña. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Merẽ yʉ mʉjãã tʉ̃goapʉ, ‘Yʉ áya,’ mʉjãã yʉ caĩrĩjẽrẽ. Bairi tunu, ‘Mʉjãã mena yʉ ãni atígʉ,’ yʉ caĩrĩjẽ cʉ̃ãrẽ mʉjãã tʉ̃goapʉ. Yʉre camaitʉ̃goñamajũcõãrã mʉjãã caãmata, ‘Yʉ Pacʉ tʉpʉ yʉ áya,’ yʉ caĩrĩjẽrẽ tʉ̃gori bʉtioro mʉjãã ʉseanibujioatana. Yʉ Pacʉ Dios pʉame yʉ netõrõ caãnimajũʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Torecʉ, cariape majũ mʉjããrẽ ñi quetibʉjʉ jʉ̃goyetiweyocõãña merẽ. Bairo yʉ caĩrĩjẽrẽ bairo cabairopʉ, ‘Cariape majũ jãã ĩ quetibʉjʉyupi,’ mʉjãã ĩ masĩgarã yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Tocãrõã yua, mʉjãã mena capee yʉ bʉsʉetigʉ. Merẽ atígʉ baiyami ati yepa macããnarẽ carotimasĩrĩ majõcʉ. Cʉ̃ pʉame bairo rotimasĩmicʉ̃ã, yʉre nopẽ caátijĩãtimasĩẽcʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bairoa cabaipee niña bairopʉa, ati yepa macããna nipetiro camasã yʉ Pacʉ Diore cʉ̃ yʉ camairĩjẽrẽ na camasĩparore bairo yua. Tunu bairoa masĩgarãma yʉ Pacʉ Dios yʉre carotijoricʉ yʉ cʉ̃ carotirorea bairo yʉ caátie cʉ̃ãrẽ,” jãã ĩwĩ Jesús. Bairo ĩ yaparori bero: “Wãmʉnʉcãña. Jito, tãmurĩ marĩ átóca merẽ,” jãã ĩwĩ Jesús, jãã, cʉ̃ cabuerãrẽ yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Bairo jãã ĩ yaparori bero, Jesús bairo jãã ĩnemowĩ tunu: “Yʉ pʉame ʉsewʉ caãnimajũrĩ wʉre bairo caãcʉ̃ yʉ ãniña. Bairi yʉ Pacʉ Dios pʉame caʉse otericʉ majũrẽ bairo caãcʉ̃ niñami. ");
INSERT INTO cbcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bairi ʉsewʉ jĩcã rʉpʉ caríca manicõãta, ti rʉpʉre pajure recõãmasĩñami yʉ Pacʉ. Caroaro ti rʉpʉ caríca cʉpata, carorije ũnierẽ jee reri, caroaro ĩñanʉnʉje masĩñami, capee to caríca cʉtinemoparore bairo yua. ");
INSERT INTO cbcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bairi mʉjãã pʉame torea bairo yʉ caátiroticũrĩqũẽrẽ tʉ̃goʉsari caroarã majũ catuarã mʉjãã ãniña. ");
INSERT INTO cbcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bairi yʉre tʉ̃goʉsa jãnaeticõãña. Yʉ cʉ̃ã, mʉjããrẽ mairĩ, mʉjãã yʉ capitietorea bairo mʉjãã cʉ̃ã yʉre yʉ tʉ̃goʉsajãnaeticõãña. Bairi merẽ mʉjãã masĩña: Jĩcã rʉpʉ ʉsewʉ rʉpʉ carupaʉ majũpʉ to caãmerĩcõãta, ríca jomasĩẽtĩña. Carupaʉ majũpʉa caãni rʉpʉ ãnirĩ ríca cʉtimasĩnucũña. Torea bairo mʉjãã cʉ̃ã caroa wãmerẽ mʉjãã átiãnimasĩẽna, yʉre tʉ̃goʉsari jĩcãrõrẽ bairo yʉ mena mʉjãã caãmerĩcõãta. ");
INSERT INTO cbcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Bairi yʉ pʉame ʉsewʉ carupawʉ majũrẽ bai