﻿USE sofia;
DROP TABLE IF EXISTS sofia.caxNT_vpl;
CREATE TABLE caxNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES caxNT_vpl WRITE;
INSERT INTO caxNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tone nüri bama pünanaquiti Jesucristo tücañe, bama ipiarientetorrti David y arrti Abraham. ");
INSERT INTO caxNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Arrti Abraham tonenti yaütoti Isaac. Arrti Isaac tonenti yaütoti Jacob. Arrti Jacob tonenti yaütoti Judá, y arrübama yaruquitorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Arrti Judá tonenti yaütoti Fares ichepeti Zara. Nipiacütorrüma nürirri Tamar. Arrti Fares tonenti yaütoti Esrom, naqui yaütoti Aram. ");
INSERT INTO caxNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arrti Aram tonenti yaütoti Aminadab, naqui yaütoti Naasón. Arrti Naasón tonenti yaütoti Salmón. ");
INSERT INTO caxNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Arrti Salmón tonenti yaütoti Booz. Nipiacütoti nürirri Rahab. Arrti Booz tonenti yaütoti Obed. Nipiacütoti Obed nürirri Rut. Arrti Obed tonenti yaütoti Isaí. ");
INSERT INTO caxNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Arrti Isaí tonenti yaütoti yüriaburrü David. Arrti yüriaburrü David posoti aübu nicüpostoti Urías y anati aütorrüma nürirrti Salomón. ");
INSERT INTO caxNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Arrti Salomón tonenti yaütoti Roboam. Arrti Roboam tonenti yaütoti Abías naqui yaütoti Asa. ");
INSERT INTO caxNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Arrti Asa tonenti yaütoti Josafat. Arrti Josafat tonenti yaütoti Joram naqui yaütoti Uzías. ");
INSERT INTO caxNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Arrti Uzías tonenti yaütoti Jotam. Arrti Jotam tonenti yaütoti Acaz. Arrti Acaz tonenti yaütoti Esequías. ");
INSERT INTO caxNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Arrti Esequías tonenti yaütoti Manasés. Arrti Manasés tonenti yaütoti Amón. Arrti Amón tonenti yaütoti Josías. ");
INSERT INTO caxNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Arrti Josías tonenti yaütoti Jeconías ichepe bama yaruquitorrti au manu tiemporrü nauquiche süromatü bama israelitarrü au Babilonia presoma ui masortaboca babiloniorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Auqui arrti Jeconías tonenti yaütoti Salatiel, naqui yaütoti Zorobabel. ");
INSERT INTO caxNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Arrti Zorobabel tonenti yaütoti Abiud. Arrti Abiud tonenti yaütoti Eliaquim, naqui yaütoti Azor. ");
INSERT INTO caxNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Arrti Azor tonenti yaütoti Sadoc. Arrti Sadoc tonenti yaütoti Aquim. Arrti Aquim tonenti yaütoti Eliud. ");
INSERT INTO caxNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Arrti Eliud tonenti yaütoti Eleazar. Arrti Eleazar tonenti yaütoti Matán. Arrti Matán tonenti yaütoti Jacob. ");
INSERT INTO caxNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Arrti Jacob tonenti yaütoti José iquiana Mariarrü, nipiacütoti Jesús, naqui Cristo. ");
INSERT INTO caxNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abe catorce familiarrü auquiti Abraham hasta arrti yüriaburrü David. Auquiti David hasta numo süromatü au Babilonia abe ito catorce familiarrü. Auqui manu tiemporrü hasta numo anati icu cürrü Cristo abe ito catorce familiarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sane numo aübo anati icu cürrü Jesucristo: Arrüna nipiacütoti nürirri Mariarrü. Comprometebo apo aübuti taman ñoñünrrü nürirrti José. Chüposopümainqui, pero tanancati ipiaümacarrü icütüpü ui noñemarrti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Arrti José champü causane au nisüboriquirrti. Chirranrrtipü uraboiti isucarü genterrü arrüna nipünate au ñaquioncorrti. Sane nauquiche rrantipü aiñocoti Mariarrü anecanatai, tapü cuaso ui macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Numo anancati ñapensatioti arrüna sane, tamanti ángel auqui napese itusiancanatiyü isucarüti au niposiquirrti, nanti ümoti: —José, arrücü auqui nesarrti familiarrü David, tapü airruca asuriu Mariarrü acüposübocü, itopiqui arrti maniqui aürrü anati icütüpü, ta ui noñemarrti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Arrtü tanati icu cürrü aiña üriboti Jesús. Itopiqui uiti ñana taesüburuma macrirrtianuca eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nanaiña arrüna pasao sane, nauqui acoco arrümanu nurarrti Tuparrü tücañe turuquiti profetarrü: ");
INSERT INTO caxNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Arrümanu cupiquirri chisuputaratiquipü ñoñünrrü, anati ñana ipiaümacarrü icütüpü, nürirrti Emanuel. Auqui besüro arrüna nürirrti nantü: Anati Tuparrü uyarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nauquiche sütopücoti José, isamutenti sane tacana arrüna yacüpucurrti maniqui ángel ümoti. Yasutiuti Mariarrü icüpostoboti. ");
INSERT INTO caxNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero anatiatai ichepe champü causane uiti ümo, cheperrtü tanati icu cürrü maniqui ipiaümacarrü. Numo tanati icu cürrü süro üriboti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Arrti Jesús anati icu cürrü au manu pueblurrü nürirri Belén, au manu cürrü nürirri Judea, au na cauta nacarrti yüriaburrü Herodes. Au manu tiemporrü iñataimia au Jerusalén manuma mañoñünca cuamatü auqui tauna ümo tansürü. Arrüma estudiaboma ñome arrüba nostoñeca abe icu napese. ");
INSERT INTO caxNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ñanquitioma pünanaqui macrirrtianuca cauta nacarrti maniqui üriatu bama israelitarrü maniqui aübo anati icu cürrü. Namatü: —Sumarrtai taha arrüna auquiche sobetü arrümanu nocoborese nibiasarurrti. Uirri nauquiche sobetü supanaun ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nauquiche ipiatenti yüriaburrü Herodes arrüna sane, chümarrtacarrüpatai ümoti. Namanaiña macrirrtianuca au Jerusalén, chümarrtacarrüpataito ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Auqui oberabarama uiti Herodes arrübama üriatu bama sacerdoterrü y arrübama manunecana nüriacarrü nauqui anquirioti pünanaquimia. Cauta ñana anati icu cürrü maniqui Cristo. ");
INSERT INTO caxNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Arrüma namatü: —Anati ñana icu cürrü au pueblurrü Belén, auna cürrü Judea, itopiqui ane corobo tücañe uiti maniqui taman profetarrü sane: ");
INSERT INTO caxNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nanti Tuparrü: Arraño bama pohoso au Belén yarusürürrü año eanaqui bama auqui piquiataca puebluca au na cürrü Judea, itopiqui auqui naubesa pueblurrü anati ñana taman yüriaburrü naqui bacuirarabo itacu niyesa genterrü Isarel. ");
INSERT INTO caxNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Auqui arrti Herodes anecanatai yatasucurrti ümo manuma mañoñünca cuamatü auqui tauna ümo tansürü nauqui anquirioti pünanaquimia, isane nanenese tücañe arrtaimia manu nocoborese. ");
INSERT INTO caxNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nanti ümoma: —¡Amecosi au Belén apanquisio nurria arrtü tanati icu cürrü maniqui ñaüma! Arrtü tütabücoti aboi, aburasoi isucarüñü nauqui yerotito rranaun ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Arrümanu nocoborese arrtaimia auqui niporrüma, cusürübo aübuma, tochenco onü taman porrü arrümanu cauta anati maniqui ñaüma. ");
INSERT INTO caxNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Arrümanuma mañoñünca pucünuñama nurria, nauquiche tarrtaimia manu nocoborese ane onü manu taman porrü. ");
INSERT INTO caxNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Numo süromampo besüro narrtarrüma ümoti maniqui ñaüma, anati ichepe nipiacütoti. Auqui bachesoiyoma esati y manaunuma ümoti. Yaübutama nibiaurirrimia, auqui macumananama ümoti, oro, rroriocorrü y mirra. ");
INSERT INTO caxNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Au manu tobirri arrti Tuparrü nanti ümoma au niposiquirrimia: —Champürrtü urria arrtü apasücübüca tato au niporrti yüriaburrü Herodes. Sane nauquiche basücübücoma tato besüro uimia au niporrüma auqui quiatarrü cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nauquiche tüsüroma tato manuma mañoñünca, tamanti ángel itusiancanatiyü isucarüti José auqui niposiquirrti, nanti sane: —¡Atüsai aiquiarrti maniqui ñaüma aübu nipiacütoti. Acosi au Egipto. Acamanu asiquia cheperrtü surapoi tatito asucarücü! Itopiqui arrti yüriaburrü Herodes rranrrti apacheriuruti naqui ñaüma, nauqui aitabairotiti. ");
INSERT INTO caxNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Auqui arrti José atüraiti, iquianatiti maniqui ñaüma aübu nipiacütoti au manu tobirri. Besüburuti aübuma au manu cürrü nürirri Egipto. ");
INSERT INTO caxNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Taha süsioma chepe numo coiñoti maniqui yüriaburrü Herodes. Arrüna sane pasao nauqui acoco arrümanu turapoiticaü Tuparrü tücañe turuquiti taman profetarrü. Nanti sane: “Rraemenca iyoti isaü na ayeti tato auqui Egipto”. ");
INSERT INTO caxNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nauquiche tütusio ümoti yüriaburrü que arrümanuma mañoñünca encañaoma ümoti, chümarrtacarrüpatai ümoti ui nitüborirrti. Sane nauquiche bacüpuruti nauqui ataborimia namanaiña bama mañaümanca au manu pueblurrü Belén y au manu cürrü saimia. Taborioma uimia arrübama aübo aboma icu cürrü, hasta bama tütabe torrü añorrü ümoma. Itopiqui ta tütabe torrü añorrü nipiasaca manu nanenese auche tücañe arrtaimia nocoborese manuma mañoñünca cuamatü auqui tauna ümo tansürü. ");
INSERT INTO caxNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sane cocono caüma arrüna corobo uiti profetarrü Jeremías tücañe. Nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rabotü taman tosibirri au manu pueblurrü Ramá y fuerte nareocorrü y suchequirri. Arrümanu areoro ta Raquel, areoro ui nisuchequirri isiu bama aürrü itopiqui chauqui tücoiñoma, chirranrrüpü nauqui anati naqui ipucünumucuta. ");
INSERT INTO caxNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nauquiche tücoiñoti yüriaburrü Herodes, tamanti ángel esaquiti Tuparrü itusiancanatiyü isucarüti José au niposiquirrti nauquiche anancatiqui au Egipto, nanti sane ümoti: ");
INSERT INTO caxNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Atüsai, aiquiarrti maniqui ñaüma aübu nipiacütoti y acosi tato au cürrü Israel, itopiqui chauqui tücoiñoma manuma rranrrüma aitabairomati naqui ñaüma. ");
INSERT INTO caxNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Auqui arrti José atüraiti, iquianatiti maniqui ñaüma aübu nipiacütoti. Basücübücoma tato au manu cürrü Israel. ");
INSERT INTO caxNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nauquiche tipiatenti José que arrti Arquelao matoconoti itoboti Herodes naqui yaütoti, birrubuti José aüroti tato au Judea. Arrti ángel manitanati ümoti au niposiquirrti, nauqui aürotitü au manu cürrü nürirri Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nauquiche tiñataimia au Galilea, süromatü avivimia au manu pueblurrü nürirri Nazaret. Arrüna sane pasao nauqui acoco arrüna turapoimia bama profetarrü tücañe, que arrti Jesús tiene que nürirrtito uimia Nazareno. ");
INSERT INTO caxNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Au manio naneneca tücañe, arrti Juan Bautista cuati au manu rroense Judea, nauqui anunecati. ");
INSERT INTO caxNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nanti sane: —Apiñorroncosaño nauqui urria nausüboriqui, itopiqui tüsaimia tiemporrü nauqui üriaburuti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Arrti profetarrü Isaías turapoiti tücañe. Nanti sane: Rabotü taman tosibirri eana rroense. Nantü sane: “¡Apicoñoco cutubiurrü cümenuti Señor, y apipesünaca nurria!” ");
INSERT INTO caxNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Naibirrti Juan tücañe niqui manu numuquianrrü camello, nipoñoentorrti taquirrtai. Niyaratarrti pururrü nubasoroca y nuhurrü eanaqui nüunrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Cuamatü esati arrübama auqui Jerusalén y auqui manu cürrü Judea y auqui taha saimia manu sapoco nürirri Jordán. Cuamatü onsaperioma arrüna nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Urapoimia isucarüti Juan nanaiña arrüba nomünantü uimia, ürioma uiti eana turrü au manu sapoco nürirri Jordán. ");
INSERT INTO caxNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Süromatito esati Juan sürümanama bama fariseorrü y saduceorrü, nauqui ürimia uiti. Auqui nanti ümoma: —¡Niñupariente noirroboca! ¿Quitipü urapoiche ausucarü nauqui puerurrü aupesübu ñünana cuabotü carrticurrü tütane saimia? ");
INSERT INTO caxNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Arrtü aurrianca aupesübu, apisamune arrüna urria, na atusi ta apiñorroncosaño ñemanauncurratoe. ");
INSERT INTO caxNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tapü abasiquia apapensa que arraño ui na abecatü eanaqui nesarrti familiarrü Abraham champü nümoche apiñorronconaño. Itopiqui arrti Tuparrü puerurrti aisamunenti ipiarienteboti Abraham oboi arrüba canca. ");
INSERT INTO caxNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chauqui totoro nurria hacharrü nauqui atüsü ba sueca. Arrüba sueca churriampü nobütarrü botüsüro. Amontonabohio nauqui abü. ");
INSERT INTO caxNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Arrti Juan nantito sane: —Ñemanauncurratoe arrüñü rraunimiaca ui turrtai, nauqui atusi que chauqui tapiñorroncocaño. Pero sucanañü ito aume: Anati naqui cuatiqui isiuñü. Arrti maunimianati uiti Espíritu Santo y ui pese. Ane manrrü nüriacarrti rropünanaquiñü, arrüñü chiyaserebiquiapü ni iñeniompü nisapaturrti. ");
INSERT INTO caxNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Arrti chauqui tacomoraboti nauqui asucüti nesarrti trigo. Arrümanu trigo iñatati peese pünanaqui niyarrirri. Arrümanu niyarrirri amontonabo uiti y tiene que acheti pese ümo. Arrümanu pese champü nitacüru noncorrü. Tapü trigo ahüburu uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Auqui iñataiti Jesús auqui Galilea au manu sapoco nürirri Jordán, auna cauta anancati Juan Bautista. Rranrrti nauqui üriti uiti Juan. ");
INSERT INTO caxNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Chirranrrtipü baeta Juan aiñaunimianatiti, nanti ümoti Jesús: —Arrüñü tiene que isüri obi, ¿causane ayetü yesañü nauqui üri sobi? ");
INSERT INTO caxNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aiñumuti Jesús, nanti: —Aiñaunimiasañüantai, itopiqui tiene que uicoco nanaiña arrüna yacüpucurrti Tuparrü. Sane nauquiche arrti Jesús ürioti uiti Juan. ");
INSERT INTO caxNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nauquiche tüchauqui nüriquirrti Jesús, süroti tato taiyiritu eanaqui turrü. Au manu rratorrü aurübo napese, auqui asaratitü ümoti Espíritu Santo, cuati onüti tacana naca nututaquimia. ");
INSERT INTO caxNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Auqui rabotito taman manitacarrü auqui napese, nantü sane: —Tonenti naqui Isaü, naqui chiyaupü nicuarrti iñemo, tarucu nipucünuncu icuatati. ");
INSERT INTO caxNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Auqui manu sürotitü Jesús uiti Espíritu Santo eana manu rroense auna cauta pururrü canca y cüosorrü, nauqui aüro macocotorrü ümoti uiti choborese. ");
INSERT INTO caxNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta naneneca y cuarenta tobiquia nacarrti chübasotipü. Auqui onquisioti nicürüpürrti. ");
INSERT INTO caxNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Auqui caüma sürotitü choborese esati, nauqui aiñanti ñacocotorrti ümoti. Nanti sane: —Arrtü ñemanauncurratoe arrücü Aütorrti Tuparrü aisamusio pan arrüba canca. ");
INSERT INTO caxNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Auqui aiñumuti Jesús, nanti: —Nantü au Nicororrü: “No solamenterrü ui pan osüboriquia. Arrtü uicocota nurarrti Tuparrü, uirri ito osüboriquia”. ");
INSERT INTO caxNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Auqui manu arrti choborese iquianatiti Jesús au manu pueblurrü nürirri Jerusalén. Iquianatiti onü manu yapetairratoe niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nanti ümoti: —Arrtü ñemanauntuapae arrücü Aütorrti Tuparrü, aiñemecasü auqui na ape, itopiqui nantü sane Nicororrü: Arrti Bae Tuparrü tiene que acüputi ümo bama nesarrti angelerrü, nauqui acuirama atacucü, tapü obürio aemo oboi canca. ");
INSERT INTO caxNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Auqui aiñumuti Jesús: —Pero nantito icu Nicororrü: “Tapü aiñata macocotorrü ümoti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Auquimanu arrti choborese iquianatitito Jesús onü taman yiriturrü apetaisürü. Acamanu itusiancatati isucarüti nanaiña arrüba nacioneca abe icu na cürrü, aübu nanaiña niñocoñoporrü. ");
INSERT INTO caxNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nanti ümoti: —Itorrimiata aemo nanaiña arrüna ane icu na cürrü, arrtü achesoiquia yesañü y anaunca iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Auqui nanti Jesús ümoti: —¡Aquicho auquina yesaquiñü naqui choborese, itopiqui icu Nicororrü nantü sane: “Anaun y aserebi ümotiatai Tuparrü!” ");
INSERT INTO caxNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Auqui arrti choborese sürotitü esaquiti Jesús; au manu rratorrü cuamatü bama angelerrü aserebimia ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Au manio naneneca arrti Jesús ipiatenti que arrti Juan Bautista anati au preso. Auqui süroti tato au Nazaret au manu cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero champürrtü asioti acamanu. Sürotito aviviti au manu pueblurrü nürirri Capernaum, abeu manu narubaitu turrü saimia ñome ba cüca nobürirri Zabulón y Neftalí. ");
INSERT INTO caxNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sane cocono arrümanu corobo tücañe uiti profetarrü Isaías: ");
INSERT INTO caxNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Arrüba cüca Zabulón y Neftalí abe saimia narubaitu turrü, topü manu sapoco Jordán, nobürirri ito Galilea, auna cauta aboma bama chütüpü israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Arrümanuma macrirrtianuca auqui manio puebluca churriampü nisüboriquirrimia, amoncoma eana tomiquianene, pero caüma cuatü taman basarurrü nauqui anentarrü ümoma. Arrübama amoncoma eana nomünantü tacana coiñoma, caüma cuatito taman basarurrü nauqui anentarrü ümoma. (Uirri caüburuma eanaqui nomünantü.) ");
INSERT INTO caxNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Auquimanu comensaboti Jesús anunecati ümo macrirrtianuca, nanti ümoma: —Apiñorroncosaño, itopiqui contoatai üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Arrti Jesús amencoti abeuqui manu narubaitu turrü au Galilea. Acamanu asaratitü ümo torrü mañoñünca, yaruquitorrümantoe. Arrti maniqui taman nürirrti Simón y nürirrtito Pedro. Arrti maniqui quiatarrü nürirrti Andrés. Arrüma batrabacarama acaübuma nopiocorrü eanaqui turrü ui momese. ");
INSERT INTO caxNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Auqui nanti Jesús ümoma: —¡Ausiapata isiuñü, irranca iñununecanaño apacaübu mañoñünca eanaqui nomünantü! ");
INSERT INTO caxNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Au manu rratorrü arrümanuma torrü iñocotama nimomerrüma. Süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Manrrü taha asaratitito ümo bama maquiataca torrü, arrti Jacobo ichepeti yaruquitorrti nürirrti Juan, tonema aütorrti Zebedeo. Amoncoma au taman barco ichepeti yaütorrüma, icoñocotama nimomerrüma. Auqui tasuruma ito uiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Au manu rratorrü iñocotama manu barco. Onconotito yaütorrüma uimia, süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Arrti Jesús amencoti au nanaiña manu cürrü Galilea, manunecanati ümo macrirrtianuca au manio poca sinagoga. Urapoiti isucarüma arrüba omirria manitacaca icütüpüti Tuparrü. Bacurarati ümo bama maunrrocono oboi arrüba aruqui nanaiña norrococa. Urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ipiatema nürirrti au nanaiña manu cürrü Siria. Canama esati arrübama tarucu nitaquisürücürrüma oboi arrüba aruqui nanaiña norrococa, arrübama aboma machoboreca auma, arrübama chüpuerurrüpüma amema y arrübama consa. Enterurrüma urriancama tato uiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sürümana genterrü sürotü isiuti auqui Galilea, auqui manu cürrü nürirri Diez Puebluca, auqui Jerusalén, auqui manu cürrü Judea y auqui manu topüqui manu sapoco nürirri Jordán. ");
INSERT INTO caxNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Taman nanenese asaratitü Jesús cümenu sürümana macrirrtianuca. Auqui süroti onü taman yiriturrü. Acamanu tümonsoti y arrübama ñanunecasarrti tümonsoma ito itupecuti. ");
INSERT INTO caxNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Auqui manunecanati, nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Urriampae naca bama ichimiancanamacü, itopiqui arrti Tuparrü bayurarati ümoma, nauqui aye uimia esati, arrtü türiabucati. ");
INSERT INTO caxNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‛Urriampae naca bama suchebo, itopiqui arrti Tuparrü bacheboti ipucünuncubuma ñana. ");
INSERT INTO caxNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‛Urriampae naca bama itaquisünacanamacü, itopiqui torrio ñana nanaiña cürrü uiti Tuparrü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‛Urriampae naca bama cürüpüo y tosüo iyo nomirria nurarrti Tuparrü, itopiqui bayurarati caüma ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‛Urriampae naca bama ipiaca apucüru, itopiqui arrti Bae Tuparrü pucürusutito itacuma. ");
INSERT INTO caxNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‛Urriampae naca bama urria ñapensacarrüma, itopiqui asaramati Tuparrü ñana. ");
INSERT INTO caxNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‛Urriampae naca bama bapachero causane nauqui urria naca maquiataca, itopiqui tonema ñana aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‛Urriampae naca bama taquisürü itopiqui arrüna urria nisüboriquirrimia, itopiqui tonema bama üriabucama ñana ichepeti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‛Urriampae nabaca arrtü unuma año y ocüsioma aume bama macrirrtianuca auqui niyaca, o arrtü mapañama aucütüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aupucünu, tapü ausuchecatai, itopiqui ane naucua au napese. Apaquionsaño: Arrübama profetarrü cusürübo amopünanaqui taquisürüma ito tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nanti Jesús ümo bama ñanunecasarrti: —Arraño tacana siürrü icu na cürrü. Arrtü arrümanu siürrü ensoro nisücürrü, chüpuerurrüpü aserebiqui. Botabatai acü na aicümonema macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‛Arraño tacana basarurrü ümo macrirrtianuca icu na cürrü. Arrtü taman pueblurrü ane onü taman yiriturrü, chüpuerurrüpü chütusiopü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chüpuerurrüpü uiñonoco basarurrü nauqui uitamurriquia. Tiene que uiñotorrimia ape, nauqui anentarrü ümo bama abomampo. ");
INSERT INTO caxNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sane ito arraño tiene que anentarrü aboi ümo macrirrtianuca. Tapü apiñanecata isucarüma arrüna urria napisamute, sane nauqui aiñanaunumati Aubaü, naqui anati au napese, itopiqui uiti arrüna urria napisamute. ");
INSERT INTO caxNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nantito Jesús: —Tapü apapensaca que isecatü nauqui apiñoco sobi napacoconauncu ümo nüriacarrü uiti Moisés, ichepe ñanunecacarrüma bama profetarrü, ta isecatü nauqui acoco sobi. ");
INSERT INTO caxNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ñemanauncurratoe sucanañü aume: Mientras que aninqui cürrü y napese, chüpuerurrüpü acaübu ni tamanpü letrarrü eanaqui nüriacarrü, cheperrtü cocono nanaiña arrüna corobo. ");
INSERT INTO caxNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Arrti naqui chicocotapü arrüna yacüpucu nüriacarrü panaca chitonempatai, y manunecanati ümo genterrü tapü icocotama, tonenti naqui manrrü chücuasürüpatai arrtü türiabucati Tuparrü. Tapü arrti naqui icocota y manunecanatito ümo macrirrtianuca sane, tonenti naqui cuasürüti arrtü türiabucati Tuparrü uyarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tiene que apisamune isiu nirrancarrti Tuparrü nauqui manrrü urria nausüboriqui pünanaqui nisüboriqui bama manunecana nüriacarrü y bama fariseorrü si no, chüpuerurrüpü aye aboi esati Tuparrü, au na cauta üriabucati. ");
INSERT INTO caxNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nantito Jesús: —Arraño chauqui tamoncoi manu bacüpucurrü ümo bama antiburrü tücañe: “Tapü apatabaiquia, itopiqui arrtü apatabaiquia tiene que ayetü carrticurrü aume”. ");
INSERT INTO caxNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tapü arrüñü caüma sucanañü aume: Arrti naqui tüborico ümoti quiatarrü tiene que acurrtati Tuparrü aübuti. Arrti naqui unutiti quiatarrü, tiene que carrticaboti ui mayüriabuca. Arrti naqui mapaurramacanati ümoti quiatarrü, tonenti naqui sürobotü au infierno. ");
INSERT INTO caxNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‛Sane nauquiche arrtü aecatü au niporrti Tuparrü aübu nacumanata ümoti y aquioncü taha iyoti aruqui ane isane churriampü uiti aübucü, ");
INSERT INTO caxNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","auqui caüma aiñoco nacumanata acamanu esa altar y acosi esati aruqui nauqui airrimiaca tato aübuti. Auqui caüma puerurrü asücübü tato nauqui aitorrimia nacumanata ümoti Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‛Arrtü ebeca ümoti quiatarrü y aecatü uiti esa nüriacarrü, arrtü tabaca isiu cutubiurrü, anqui püanaquiti marrimiacatarrü, tapü aiñatai uiti esati yüriaburrü. Itopiqui arrti caüma itorrimianatiyü mecu masortaboca y arrüma caüma iñanamacü au preso. ");
INSERT INTO caxNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ñemanauncurratoe sucanañü aemo chataesübucapü uimia cheperrtü apacaca nanaiña nebequi. ");
INSERT INTO caxNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nantito Jesús: —Tamoncoi arrüna corobo tücañe sane: “Tapü aecatü isiu quiatarrü paürrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tapü arrüñü sucanañü aume: Arrti naqui asaratü ümo taman paürrü y tirranrrti ümo, chauqui tütane nomünantü uiti au nausasürrti. ");
INSERT INTO caxNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","‛Arrtü atacheca asaratü ümo arrüna churriampatai ui taman nasüto, mejor aiquiaübu, arusaübu. Itopiqui manrrü urria arrtü ensoro arrümanu taman nasüto, pünanaquirrtü enterurrü nacütüpü sürotü au infierno. ");
INSERT INTO caxNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Arrtü aisamute nomünantü ui nepanauncu nehe, mejor aitüsüna y arusaübu. Itopiqui manrrü urria arrtü ensoro tamantai nehe pünanaquirrtü enterurrü nacütüpü sürotü au infierno. ");
INSERT INTO caxNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‛Tücañe ane ito corobo sane: “Arrti naqui rranrrti aiñocoti nicüpostoti, tiene que aitorrimiati ümo taman quichonimiacarrü corobo icu arrüna uiche atusi que chitonenquipü nicüpostoti. ");
INSERT INTO caxNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tapü arrüñü sucanañü aume: Arrtü anati naqui iñocota nicüpostoti, arrüna champü causane nisüboriquirri aübuti, chauqui tütane nomünantü uiti. Itopiqui auqui nacarrti caüma puerurrü aürotü avivi aübuti quiatarrü. Y arrti naqui poso aübu, chauqui tütane ito nomünantü uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‛Tamoncoi ito tücañe arrüna manitacarrü ümo bama antiburrü, arrüna nantü sane: “Tapü chücoconopü aboi arrüna arrtü ane isane aburapoi aübu curusürru au nürirrti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Arrüñü sucanañü aume, tapü apitusiancata curusürrü. Arrti Tuparrü anati au napese. Sane nauquiche tapü apitusiancata curusürrü au nüri napese. ");
INSERT INTO caxNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tapü apitusiancata ito curusürrü au nüri cürrü, itopiqui tone arrüna cauta ito üriabucati. Ni au nüripü Jerusalén, itopiqui tone nesarrti pueblurrü naqui yarusürürrü yüriaburrü, naqui Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tapü apitusiancata ito curusürrü au nüri nautanu, itopiqui chüpuerurrüpü año apiquiampia nisu taman niqui nautanu. Uitiatai Tuparrü puerurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aburasoi solamenterrü arrüna arrtü sane o chüsanempü. Itopiqui arrtü tapipiasatapae, chauqui tuiti choborese. ");
INSERT INTO caxNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‛Arrümanu nüriacarrti Moisés tücañe nantü sane: “Arrtü anati naqui ane causane uiti aemo, atoco tato atüborito ümoti”. ");
INSERT INTO caxNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tapü arrüñü caüma sucanañü aume: Arrtü anati naqui tüborico aume, tapü apasutiu nitüborirrti. Arrtü anati naqui iñompebairotiyü au taman nasu, aitorrimia ito quitarrü narücüqui nasu ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Arrtü anati naqui iquianü au nüriacarrü nirrancarrti aiquiaübuti apünanaquicü nacamisa, aitorrimia ito nasaco ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Arrtü icüpurumacü aübu cacarrü nauqui aiquia ümoma taman kilómetro, acosi aübu torrü kilómetros. ");
INSERT INTO caxNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Arrtü anati naqui manquio isane apünanaquicü, aitorrimia ümoti. Tapü chaprerrtacapü ümoti naqui rranrrü aprerrta apünanaquicü. ");
INSERT INTO caxNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nantito Jesús: —Tamoncoi ito arrüna manitacarrü, nantü sane: “Tari cuasürüti aemo naqui buenorrti aübücü, y atübori ümoti naqui tüboricatai aemo”. ");
INSERT INTO caxNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tapü arrüñü sucanañü aume: Tari cuasürüma aume bama tüboricatai aume. Apicunusüancarrüma bama churriampü ñanitacarrüma aume. Apisamuse arrüna urria aübu bama ipiaurramanaño. Apean itacu bama tüboricatai aucuata y arrübama autaquisürüca uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sane caüma tusio ta arraño aütorrti naqui Aubaü anati au napese. Itopiqui uiti cuara surrü ümo bama malorrü y ümo bama ito buenurrü. Uitito rrobeoca ümo bama champü nipünatema y ümo bama ito tarucu nipünatema. ");
INSERT INTO caxNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Arrtü cuasürüma aume solamenterrü arrübama Hasta arrübama mayacobraca impuesto isamutema ito sane panaca picarurrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Arrtü apanquiquia nurria solamenterrü ümo bama aubaruqui o ümo bama apisuputacama, ¿napaquionco urria arrüna apisamute sane? Arrübama ito chisuputaramatipü Tuparrü isamutema ito sane. ");
INSERT INTO caxNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Apiña nausüboriqui tacana nisüboriquirrti naqui Aubaü anati au napese. Arrti champü isane nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nantito Jesús: —Aensarrtü abasiquia apitusianca napanauncu ümoti Tuparrü isucarü macrirrtianuca, solamenterrü ui naurrianca asaramatü aume. Arrtü apisamute sane, chüpuerurrüpü ane naucua au napese uiti Tuparrü naqui Auyaü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Arrtü ane isane acumanaca nauqui ayura ümoti naqui pobrerrü, tapü asiquia uraboi isucarü macrirrtianuca, tacana arrüna nisoni bama mañapanca ubau ba poca sinagoga y yusiu cayaca. Arrüma isamutema arrüna sane ui nirranacarrüma urria ñanitaca genterrü ümoma. Pero surapoi nurria ausucarü, que arrüma chüpuerurrüpü ane nicuarrüma uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Arrtü ane isane acheca ümoti naqui pobrerrü, tapü tusio ümoti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tari anecanatai nacumanaca, itopiqui arrti Tuparrü asaratitü aemo, sane nauquiche caüma ane nacua uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‛Arrtü apeanca, tapü apeanca tacana arrübama mañapanca. Arrüma urriantai ümoma eama auqui natücaiquirrimia ubau ba poca sinagoga y au ba nerrquina cayaca. Ui arrüna sane ensoro arrümanu nicuarrüma uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Arrtü arrianca ehan, acosi au naesa cuarto tamancü y aiñamasio turuca, auqui caüma puerurrü eanca ümoti Uyaü, naqui anati acamanupo achepecü. Arrti asaratitü aemo tamancü au naesa cuarto, auqui caüma ane nacua uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‛Arrtü eanca, tapü yabaiturrü nanitaca tacana arrübama chisuputaramatipü Tuparrü, ñaquioncorrüma oncoiti ui arrüna yabaiturrü neancarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tapü apisamute sane arraño. Arrti Bae Tuparrü tütusiatai ümoti arrüna naurriantümo. ");
INSERT INTO caxNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sane nauquiche arrtü apeanca, amucanaño sane: Suiyaü, aca au napese. Tari anaunrrü nüri. Üriabusü suiñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tari urranena isiu narrianca auna acü, tacana au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ache sumutuburibo naneneca. ");
INSERT INTO caxNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Airrimiaca tato nomünantü soboi, tacana arrüsomü sopirrimiacata tato ümo bama churriampü uimia suiñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tapü acheca macocotorrü suiñemo. Aitaesümunusu somü eanaqui nomünantü. Itopiqui champü nitacüru nüriaca, champü ito nitacüru nacusüu y nanentacarrü aesacü. Amén. ");
INSERT INTO caxNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‛Itopiqui arrtü apirrimiacata tato ümoti quiatarrü, arrti Uyaü naqui anati au napese, rrimiacana tato uiti aume. ");
INSERT INTO caxNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero arrtü chapirrimiacatapü tato ümoti quiatarrü, arrti Uyaü naqui anati au napese, chüpuerurrüpito airrimiacati tato nomünantü aboi. ");
INSERT INTO caxNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nantito Jesús ümoma: —Tapü apapanca ausuche arrtü ayunabo año (arrtü chaubacapü). Tapü apiñata tacana bama mañapanca. Arrüma arrtü ayunaboma mapañama asuchema ui nirrancarrüma atusi ümo macrirrtianuca que ayunaboma. Ñemanauncurratoe sucanañü aume: Ui arrümanu sane nisonirrimia chüpuerurrüpü ane nicuarrüma uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Arrtü ayunabocü, atasubi y atacünauncu bien, tacanarrtü aca au pierrta, ");
INSERT INTO caxNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tapü tusio ümo macrirrtianuca arrüna ayunabocü o sea arrtü chacapü pemacarrü naquionco iyoti Tuparrü. Tamantiatai naqui Uyaü tusio ümoti arrüna anecanatai nachücoi. Uirri caüma ane nacua uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‛Tapü tarucapae namenarri icu na cürrü, itopiqui puerurrtai rriho y mameso amopünanaqui. Puerurrtaito aicusüpürioma bama macusüpüca. ");
INSERT INTO caxNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Manrrü urria arrtü urria nausüboriqui. Tone te tacana namenarri au napese. Tari amontonabo aboi taha au napese, auna cauta chüpuerurrüpü irri y chüpuerurrüpito amameso y chiñataipüma bama macusüpüca iyo. ");
INSERT INTO caxNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Itopiqui arrüna cauta ane namenarri, tone arrüna ümoche napapensaca. ");
INSERT INTO caxNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nantito Jesús sane: —Arrüba nasüto tacana basarurrü ümo nacütüpü. Sane nauquiche arrtü omirria nasüto anentarrü ito nurria ümo enterurrü nacütüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Arrümanio omirria nasüto toneño tacana arrüba omirria napensaca. Tapürrtü chomirriampü napensaca, tacanarrtü chomirriampü nasüto. Ane nausüpü au tomiquianene. ");
INSERT INTO caxNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‛Champüti naqui puerurrü aserebiti ümo bama torrüma ipiatronetorrti. Itopiqui chüpuerurrüpü ichépe nicuarrüma ümoti. Rrepente ane nauche cuasürüti nurria maniqui taman ümoti y tüboricoti ümoti quiatarrü. O ane nauche baserebiotito nurria ümoti maniqui quiatarrü, tapü arrti naqui chücuasürütipü ümoti. Chüpuerurrüpü baserebi ümoti Tuparrü arrtü tarucu nurrianca ümo monirri. ");
INSERT INTO caxNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‛Sane nauquiche sucanañü aume: Tapü tarucapae napapensaca iyo arrüna amutuburibo, autüpobocü, abaibibocü, itopiqui arraño ausüboriquia. Manrrü te cuasürü nosüboriqui pünanaqui comirarrü, y manrrü cuasürü nocütüpü pünanaqui nusaibi. ");
INSERT INTO caxNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Amasasio nutaumanca, arrüba abe bupasoro, ¿cautapü tupancüturu nauqui cosechabohio umutuburibo? Chopiñahübutapito. Pero arrti Tuparrü bacheboti umutuburibo. Arraño manrrü te naucua ümoti ñopünanaqui nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Isanempataipito iyebo oemo auqui arrüna tarucu numapensaca? ");
INSERT INTO caxNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‛¿Causane tarucapae napapensaca iyo arrüna abaibibo? Cabitopü apapensa iyo ubaibibo arrüba püsioca eanaqui rroense. Champürrtü patrabacara, ni apaiñapü. ");
INSERT INTO caxNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero sucanañü aume: Ni arrtipü Salomón tücañe aye uiti tacana nubaibiqui manio püsioca, panaca rricurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Arrti Tuparrü bacheboti iyusubu püsioca eana rroense. Abu arrtü bosübo botüsüro nauqui amoho. Arraño te manrrü asaratitü Tuparrü autacu. ¿Sane nauquiche, causane chamoncapütü ümoti? ");
INSERT INTO caxNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sane nauquiche tapü ane penarrü aboi, rrepente amucanaño: ¿Isanempü uñutuburibo caüma? ¿Isanempü arrüna otüpobo caüma? ¿Isanempü arrüna usaibibo? ");
INSERT INTO caxNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Arrübama macrirrtianuca icu na cürrü mapensarama iyo arrüna sane. Pero arroñü anati Uyaü au napese. Arrti tütusiatai ümoti arrüna naurriantümo. ");
INSERT INTO caxNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sane nauquiche apapensa iyo arrüna, arrtü türiabucati Tuparrü abarrüpecu y nauqui urria nabaca au narrtarrti. Auqui caüma torrio aume nanaiña arrüba piquiataca naurriantümo. ");
INSERT INTO caxNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tapü tarucapae penarrü aboi iyo arrüna uiche ausüboriquia au quiatarrü nanenese. Tari ane penarrü aboi ümo tamantai nanenese iyo arrüna amutuburibo. Itopiqui au quiatarrü nanenese, cuantio piquiataca nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nantito Jesús ümo bama ñanunecasarrti: —Tapü apuncati quiatarrü, arrtü chaurriancapü carrticabo año uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Arrüna carrticurrü apacheca ümoti quiatarrü, tone ito torrio aume uiti. Arrti Tuparrü iñatati aume isiu arrüna napisamute ümo maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Causanempü ane nümoche obi arrüna chimiantai nünantü uiti aruqui, tapü arrüna tarucu nomünantü obi charrtaipü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Causane arrian anuneca ümoti quiatarrü, naqui champüapae nomünantü uiti, tapü arrücü tarucu nomünantü obi? ");
INSERT INTO caxNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ñapanrrücü! Primero tiene que aicoñoco nasüboriqui aübuti Tuparrü, arrtü arrianca aiñununecanati naqui ane chimiantai nomünantü uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‛Tapü apanitaquio nomirria isucarü bama tarucapae nomünantü uimia, itopiqui champü nümoche uimia. Tapü apitusiancata ito nabüriaca isucarüma, itopiqui tiene que arriama aitabairoma año. ");
INSERT INTO caxNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‛Arrtü ane isane naurriantümo apanqui pünanaquiti Tuparrü, arrti caüma bayurarati aume. Apapache y tabüco aboi. Apiyotobaita tururrü, aurübo aume. ");
INSERT INTO caxNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Itopiqui arrti naqui manquio, torrio ümoti, y arrti naqui bapachero, tabüco uiti. Arrti naqui iyotobaitati tururrü, aurübo ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‛¿Aensapü apitorrimiata canrrü ümoti abaübosi, arrtü manquioti pan amopünanaqui? ¡No, champü! ");
INSERT INTO caxNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Arrtü manquiotito nopiocorrü amopünanaqui, ¿aensapü apitorrimiata noirroborrü ümoti? ");
INSERT INTO caxNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Arraño panaca malorraño, pero apipiaca apache arrüna urria ümo bama abaübosi. Arrti Bae Tuparrü naqui anati au napese, manrrü botorrio arrüba omirriantai uiti ümo bama manquio pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sane nauquiche tapü apisamute ümo maquiataca arrüna churriampü aume. Ümo te arrüna sane torrio tücañe nüriacarrü uiti Moisés y ñanunecacarrüma bama profetarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‛Arrtü urrianca oerotü au napese, tiene que bapacherio arrümanu tunumusiña tururrü. Amasasai nurria, tapü amecatü auqui manu tururrü arubaesa, ni isiuquipü manu pacubaesa cutubiurrü, itopiqui isiuqui oecatü au infierno. Sürümanama bama süromatü isiuqui manu cutubiurrü itopiqui pacubaesa. ");
INSERT INTO caxNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tapü arrümanu nituru napese ta tunumusiñatai. Cümpaiñamatai ito cutubiuma ümo. Mümanamantai bama süromatü isiuqui. ");
INSERT INTO caxNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nantito Jesús: —Amasasai nurria ñünana bama cuamatü aübu ñapanturrüma anunecama au nürirrti Tuparrü. Cuamatü tacana nobirramanca, abu ta nuitümürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Arraño puerurrü apisuputarama ui arrüna nisamutema. ¿Acasopü puerurrü mata nüta uva icütüpüqui parirri? Champü ito tubarrtai üta cümüchürürrü tacana nütaca higo. ");
INSERT INTO caxNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Arrüba omirria sueca, omirria ito nobütarrü. Arrüba chomirriampü sueca, chomirriampito nobütarrü. Chüpuerurrüpü basarai churriampü nüta na urria suese. ");
INSERT INTO caxNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Champü ito tubarrtai urria nobütaca ba chomirriampü sueca. ");
INSERT INTO caxNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sane nauquiche arrüba chomirriampü sueca, botüsüro nauqui amoho. ");
INSERT INTO caxNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sane ito arraño, tiene que apisuputarama bama mañapanca ui arrüna isamutema. ");
INSERT INTO caxNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‛Chüpuerurrüpü ichépe aye ui macrirrtianuca auna cauta ane nüriacarrti Tuparrü, arrtü namatatai iñemo: “Señor, Señor”. Ümonatai arrümanu nurarrüma. Solamenterrü arrübama isamutema yacüpucurrti Iyaü naqui anati au napese iyebo uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Arrtü iñatai manu nanenese nesa bacurrtacarrü, sürümanama bama namatü iñemo: “Señor, Señor, arrüsomü amonco somü supanitate nüri. Au nüri sopicüpucama bama machoboreca auqui macrirrtianuca. Supasamuca sürümana milagrorrü au nüri”. ");
INSERT INTO caxNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero arrüñü caüma sucanañü ümoma: “Champürrtü isuputacaño, apaquicho auquina yesaquiñü, bama mañasamuca nomünantü”. ");
INSERT INTO caxNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‛Arrti naqui oncoi nisura, y isamutenti nanaiña arrüna nirracüpucu, iyebo uiti tacana nacarrti maniqui ñoñünrrü bien ipiacati. Isamutenti niporrti onü canrrü, nauqui segurorrü nacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Numo iñatai nitiempo tanaunrrü, ubataso nusüruca, umuünasio. Iñatai turrü itupecu manu porrü. Y bausucüro fuerte maquiütürrü, pero chütaübücopü, itopiqui atünaiñacana uiti onü manu canrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tapü arrti naqui oncoi nisura y chisamutentipü arrüna nirracüpucu, iyebo uiti tacana nacarrti maniqui taman ñoñünrrü sonsorrü naqui isamutenti niporrti eana cüosorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Numo iñatai nitiempo tanaunrrü ubataso nusüruca, umuünasio y bausucüro ito fuerte maquiütürrü ümo manu porrü. Auqui taümünaña, iñarrio y champü isane yerubutü. ");
INSERT INTO caxNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nauquiche tüchauqui ñanitacarrti Jesús, enterurrü manuma macrirrtianuca cütobüsoma ui arrüna ñanunecacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Itopiqui arrti manunecanati aübu nanaiña nüriacarrti y champürrtü tacana bama manunecana nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nauquiche tücuati tato Jesús onüqui manu yiriturrü, sürümanama macrirrtianuca cuamatito isiuti. ");
INSERT INTO caxNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Auqui tamanti ñoñünrrü maunrrocono ui arrümanu norrocorrü nürirri lepra, cuati esati. Bachesoiyoti esati y nanti ümoti: —Señor, arrücü puerurrü aicurarañü, arrtü arrianca. ");
INSERT INTO caxNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Auqui arrti Jesús iñenotiti maniqui maunrrocono y nanti ümoti: —Irranca icurarü. Caüma urriancü tato. Ui arrümanu nurarrti sane, arrti maniqui maunrrocono urriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Auqui nanti Jesús ümoti maniqui ñoñünrrü: —Tapü urapoi ümoti quiatarrü arrüna sane. Auquina acosi besüro aitusiancasü isucarü bama sacerdoterrü. Acumana ito itobo ümoti Tuparrü, tacana arrüna yacüpucurrti Moisés tücañe, nauqui asaraimia macrirrtianuca, arrücü chauqui turriancü tato. ");
INSERT INTO caxNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nauquiche iñataiti Jesús au manu pueblurrü nürirri Capernaum, tamanti capitán rromanorrü cuati esati: ");
INSERT INTO caxNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Asamu nurria iñemo, Señor. Arrti imoso anati icu nicürurrti maunrroconoti, y chüpuerurrtipü aepocoti, tarucu nitaquisürücürrti ui manu norrocorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Auqui nanti Jesús ümoti: —Auritarrü yecatanu rracura ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Auqui iñumutati maniqui capitán: —Señor, arrüñü champü isane niyaca nauqui aerotü au nipo. Acüpuatai ümo norrocorrü nauqui aürotü pünanaquiti, nauqui urrianati tato. ");
INSERT INTO caxNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Itopiqui arrüñü ito yaca ümo yacüpucu bama manrrü ane nüriacarrüma rropünanaqui, tacana arrüna nisüriaca ümo bama niyesa soldadorrü. Arrtü rracüpuca ümoti taman uturuquimia, sürotitü. Arrtü itasucati quiatarrü, cuati. Arrtü rracüpuca ümoti imoso na aisamunenti arrümanu isane nirrantümo, isamutentito. ");
INSERT INTO caxNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nauquiche oncoiti Jesús arrümanu nurarrti sane, cütobüsoti. Auqui nanti ümo bama macrirrtianuca amoncoma isiuti: —Ñemanauncurratoe sucanañü aume, champüti naqui isuputacai au nanaiña Israel tacana nacarrti naqui ñoñünrrü tarucu noncorrti iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nantito Jesús ümoma: —Sürümanama bama macrirrtianuca cuamatü ñana auqui iche, auqui tansürü y auqui nimümürrü, nauqui atümoma ichepeti Abraham, ichepeti Isaac y ichepeti Jacob, nauqui aama auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tapü arrübama ümocheapae atorri, nauqui aye uimia esati Tuparrü, arrübama israelitarrü, tiene que apenema au tomiquianene. Taha tarucu nareorrüma y acamanu ito botoquio nohorrüma ui nitaquisürücürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Auqui nanti Jesús ümoti maniqui capitán: —Acosi tato au napo, ui arrüna oncatü nurria iñemo, chauqui turriancati tato maniqui amoso. Sane pasao au manu horarrü, urriancati tato maniqui mosorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Auqui manu iñataiti Jesús au niporrti Pedro. Acamanu ananca maunrrocono nipiacürrtoti Pedro. Ananca aübu fuerte pacütaiquirri. ");
INSERT INTO caxNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Auqui arrti Jesús iñentati nehese. Au manu atorrü pasao nipiacütaiquirri. Sane nauquiche atürai nauqui ariorrü apema ümoti Jesús y ümo bama maquitaca, itopiqui turrian tato ümo. ");
INSERT INTO caxNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nauquiche tütobiquia, canama esati Jesús sürümanama bama aboma machoboreca auma. Ui tamantai nurarrti Jesús süromatü machoboreca auquimia, y namanaiña bama maunrrocono urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Enterurrü arrüna pasabo sane ta nauqui acoco arrümanu urpaoiti tücañe profetarrü Isaías. Nanti sane: “Uiti Cristo urrianca oñü tato. Iquiaübutati norrocorrü oñopünanaqui”. ");
INSERT INTO caxNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nauquiche arrtaiti Jesús sürümanama macrirrtianuca itupecuti, nanti ümo bama ñanunecasarrti: —Curi topü narubaitu na turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tamanti maestro nesa nüriacarrü cuati esati Jesús, nanti ümoti: —Maestro, irranca yerotü asiucü au nanaiñantai auna cauta naecü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aiñumuti Jesús: —Apensasio nurria. Arrüba numantureca ane niyoporrü cütu. Arrüba nutaumanca ane niñusumenurrü auna cauta apacansa. Tapü arrüñü Ñemanauncurratoe Ñoñünrrü champü nipo auna cauta ñacansa. ");
INSERT INTO caxNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tamanti uturuqui bama ñanunecasarrti Jesús nanti ümoti: —Señor, yasiquia baeta esati taita cheperrtü tücoiñoti, nauqui iñanati cütu, auqui caüma yecatü asiucü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Auqui aiñumuti Jesús: —No, ariacu isiuñü caüma. Arrübama chicocoromatipü Tuparrü, tari uimia aiñanama cütu bama coiño. ");
INSERT INTO caxNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Auqui arrti Jesús sürotitü au manu taman barco ichepe bama ñanunecasarrti. Süromatü auqui manu isuqui turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Au manu rratorrü nauquiche amoncoma isu turrü, maquiütüca fuerte. Pocoro turrü uirri y supiuru au barco ui manu maquiütürrü. Arrti Jesús anancati manumuti au manu barco. ");
INSERT INTO caxNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Auqui arrübama ñanunecasarrti süromatü esati nauqui airrtopünanamati, namatü ümoti: —¡Señor, ayura suiñemo, tirranrrü uyubaca! ");
INSERT INTO caxNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Auqui arrti Jesús sütopücoti, nanti ümoma: —¿Causane tarucapae naupirrucu? ¿Causane chamoncapütü nurria iñemo? Auqui atüraiti y icuansomocotati maquiütürrü, y nipococo turrü. Y au manu rratorrü tochenco nanaiña. ");
INSERT INTO caxNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Arrübama ñanunecasarrti cütobüsoma nurria. Namatü ümomantoe: —¿Ñacutipü naqui ñoñünrrü? ¡Hasta maquiütürrü y turrü omoncoi nurarrti! ");
INSERT INTO caxNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tiñataiti Jesús topü manu turrü au manu cürrü nürirri Gadara. Acamanu cuamatü torrüma mañoñünca auqui panteón, aboma machoboreca auma. Cuamatü esati Jesús yarucurrüma. Arrüma bien malorrüma, birrubuma macrirrtianuca apasama auqui manu cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Auqui arrümanuma torrü tosibicoma: —¿Causane ayetü tauna suichepe? ¡Arrücü Aütorrti Tuparrü! ¡Apuraurrücüapae ache suichaquisürücübo! (Abu chiñataiquipü manu nanenese nesa bacurrtacarrü.) ");
INSERT INTO caxNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Acamanu saimia amonquio nupaucheca, bubaso. ");
INSERT INTO caxNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Arrümanuma machoboreca namatü ümoti Jesús sane: —Asamu nurria suiñemo arrtü aicüpuca somü auqui bama mañoñünca, aicüpusu somü ubau manio nupaucheca. ");
INSERT INTO caxNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Auqui iñumutati Jesús: —Bueno, ¡amecosi ubahu! Auqui arrümanuma machoboreca süroma ubau manio nupaucheca. Ui arrüna sane rrepenteatai locorriantai. Opiñemecanaño abeuqui manu taman nisacürrü. Bupaquio au turrü y ububacara cütu. Auqui mocoiño. ");
INSERT INTO caxNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tapü arrümanuma bacuirara yutacu manio nupaucheca, süroma tato yarucurrüma au pueblurrü ui nirrucurrüma, besüro uraboimia arrüna pasabo sane. Urapoimia ito que urriancama tato manuma torrü mañoñünca amoncoma machoboreca auma. ");
INSERT INTO caxNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sane nauquiche enterurrü manuma macrirrtianuca auqui manu pueblurrü, süromatü auna cauta anancati Jesús. Ñanquitioma pünanaquiti nauqui aürotitü auqui manu nicürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Auqui arrti Jesús süroti tato au taman barco topü manu narubaitu turrü. Iñataiti tato au manu pueblurrü arrüna cauta bavivicoti, nürirri Capernaum. ");
INSERT INTO caxNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Acamanu anancati taman maunrrocono, canati esati Jesús ui bama icumpañeruturrti, icu nicürurrti. Chüpuerurrüpü amenti. Asaratitü Jesús ümo manuma uiche ayeti maniqui maunrrocono. Tütusiatai ümoti que arrüma bien icocoromati. Sane nauquiche nanti ümoti maniqui maunrrocono: —Tapü airruca, saruqui, itopiqui arrüba nomünantü obi morrimiacana tato sobi aemo. ");
INSERT INTO caxNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Auqui arrümanuma maestro ümo nüriacarrü, mapensarama au nitusirrimia sane: “Arrti naqui ñoñünrrü ane nipünatenti aübuti Tuparrü ui arrüna nurarrti sane”. ");
INSERT INTO caxNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Arrti Jesús tütusiatai ümoti arrüna ñapensacarrüma, nanti ümoma: —¿Causane churriampatai napapensaca iñemo? ");
INSERT INTO caxNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Arrüñü Ñemanauncurratoe Ñoñünrrü ane nisüriaca auna icu na cürrü nauqui aurrimiaca tato sobi nomünantü. Pero rrepente amucanaño iñemo que rranitacatai. ");
INSERT INTO caxNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Caüma itusiancata ausucarü nisüriaca, rracurara ümoti naqui maunrrocono. Auqui nanti ümoti maniqui maunrrocono: —¡Atüsai, aiquia nacüru, y acosi tato au napo! ");
INSERT INTO caxNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Auqui arrti maniqui maunrrocono atüraiti, iquiatati nicürurrti y süroti tato au niporrti. ");
INSERT INTO caxNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Arrübama macrirrtianuca aboma acamanu arrtaimia arrüna sane, cütobüsoma. Iñanaunumati Tuparrü itopiqui torrio uiti arrüna sane nüriacarrü ümo mañoñünca icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Auqui arrti Jesús sürotitito auqui manu. Auqui arrti Jesús asaratitü ümoti taman ñoñünrrü nürirrti Mateo. Anancati tümonsoti auna cauta bacobürarati impuestorrü. Arrti Jesús nanti ümoti: —¡Ariacu isiuñü! Auqui arrti Mateo atüraiti y sürotitü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Au manu nanenese, arrti Jesús anancati basoti au niporrti Mateo. Sürümanama bama bacobürara impuestorrü y arrübama maquiataca ane nomünantü uimia, amoncoma basoma ichepeti Jesús acamanu, y arrübama ito ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pero arrümanuma fariseorrü nauquiche arrtaimia arrüna sane, ñanquitioma pünanaqui bama ñanunecasarrti Jesús sane: —¿Causane aati maniqui aubesa maestro ichepe bama mayacobraca impuestorrü y arrübama tarucu nomünantü uimia? ");
INSERT INTO caxNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Arrti Jesús oncoiti arrüna nurarrüma, auqui nanti ümoma: —Champü nümocheti mercurrü ümo bama urria ümoma, ta ümo bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Amecosi apapensario nurria isane nümoche arrüna nurarrti Tuparrü sane icu Nicororrü: “Chirrancapü apacumana iñemo numuquianca. Arrüna nirrantümo es nauqui ane naupucüru itacuti quiatarrü”. Arrüñü chisecapütü nauqui itasuruma bama urria nisüboriquirrimia, ta isecatü itasuruma bama tarucapae nomünantü uimia, nauqui puerurrü aiñorronconomacü. ");
INSERT INTO caxNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Auqui arrümanuma ñanunecasarrti Juan Bautista cuamatü esati Jesús, ñanquitioma pünanaquiti sane: —¿Causane chayunabopüma bama anunecasa tacana arrübama fariseorrü y arrüsomü? ");
INSERT INTO caxNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aiñumuti Jesús nurarrüma: —Chüpuerurrüpü ayunaboma y asuchema, arrübama tasuru ümo tübübürrü, mientras que arrti naqui itübübüche anati acamanu ichepema. Pero iñatai ñana manu nanenese auche carübuti pünanaquimia maniqui itübübüche. Auqui caüma chübasopüma ui nisuchequirrimia isiuti. ");
INSERT INTO caxNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‛Champüti naqui marruparriancana ui arrüna iyebo. Itopiqui iñünanü y uirri manrrü niquiopücü manu poma rrürüpütürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sane ito chüpuerurrüpü uiñahübu nuevurrü vinorrü nauqui oco ubau arrüba nitaqui numuquianca namoncoca, itopiqui bopobo taquiquia uirri. Ui arrüna sane caüma ensoratai manu vinorrü y omensoro ito manio taquiquia. Asi que mejor uiñahübu nuevurrü vinorrü ubau arrüba obebo taquiquia, tapü arapara vinorrü y tapü bopobo taquiquia. (Arrüna nirranunecaca tone tacana manu nuevurrü vinorrü.) ");
INSERT INTO caxNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nauquiche aübapae chauqui nurarrti Jesús, tamanti üriatu manuma israelitarrü iñataiti acamanu esati Jesús. Bachesoiyoti esati y nanti ümoti: —Aübapae aco nichaquiumucu, pero süborico tato arrtü ayecatü aiña nehe onü. ");
INSERT INTO caxNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Auqui arrti Jesús atüraiti ichepe bama ñanunecasarrti y süromatü isiuti maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Acamanu ananca manu paürrü tütabe doce añorrü nacarrü aübu manu norrocorrü, tarucu nitaquisürücürrü ui narapaca notorrü cübobiqui. Auqui sürotü esati Jesús chacuquitiatai nauqui aiñe nabeu naibirrti. ");
INSERT INTO caxNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sane arrüna ñapensacarrü: “Arrtü iñenta caüma nabeu naibi Jesús, entonces urriancañü tato”. ");
INSERT INTO caxNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Arrti Jesús asarati tato chacuti, y nanti ümo manu paürrü: —¡Tapü airruca, paürrü, urriancü tato, itopiqui aicococañü! Au manu rratorrü urriante tato. ");
INSERT INTO caxNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nauquiche tiñataiti Jesús au niporrti maniqui yüriaburrü, arrtaiti chauqui tacomoraboma, ariorrüma aiñama cütu manu nitaquiumucuturrti maniqui yüriaburrü. Aboma bama mapununu burrirri. Rabotü nareorrüma, y nitosibirrimia ui nisuchequirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Auqui nanti Jesús ümoma: —¡Apaquicho auquina esaqui na cupiquirri! Champürrtü coiño, ane manumu. Pero arrüma iyabomati. ");
INSERT INTO caxNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Auqui baquichoroma uiti auquimanu. Arrti sürotipo au manu porrü. Aiñenti nehe manu cupiquirri. Auqui süborico tato, atüraiyo tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Contoatai tusio au nanaiña manu cürrü arrüna nisamutenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nauquiche tüsürotitito Jesús auqui niporrti maniqui yüriaburrü, torrü mañoñünca supuso süromatü isiuti aübu nitosibirrimia, namatü sane: —¡Apucüru suichacu arrücü Cristo enaqui nesarrti familiarrü David! ");
INSERT INTO caxNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nauquiche tüsürotitüpo Jesús, arrümanuma torrü cuamatü esati. Arrti Jesús ñanquitioti pünanaquimia: —¿Apicocota arrüna arrtü puerurrü rracura aume? Arrüma iñumutama: —¡Sopicocota, Señor! ");
INSERT INTO caxNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Auqui arrti Jesús iñentati nisütorrüma y nanti ümoma: —Rracurara aume, isiuqui arrüna amoncatü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Au manu rratorrü urrian tato narrtarrüma. Auqui arrti Jesús encargaboti nurria ümoma, tapü asioma uraboimia. ");
INSERT INTO caxNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Taipü sane uimia. Aübapae saliboma auqui manu esaquiti, turapoimia isucarü macrirrtianuca au nanaiña manu cürrü, arrüna nisamutenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nauquiche aübapae süromati bama torrü esaquiti Jesús, canati taman ñoñünrrü acamanu esati, naqui chüpuerurrüpü anita, itopiqui anati taman choborese auti. ");
INSERT INTO caxNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Auqui arrti Jesús icüpurutiti maniqui choborese auquiti. Sane nauquiche puerurrü anitati tato maniqui ñoñünrrü. Enterurrüma manuma macrirrtianuca cütobüsoma ui arrüna sane, namatü: —Champü tubarrtai au na cürrü Israel arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tapü arrümanuma fariseorrü namatü sane: —Arrti naqui ñoñünrrü, bacüpuruti ümo machoboreca auqui macrirrtianuca itopiqui torrio üriacaboti uiti naqui üriatu bama machoboreca. ");
INSERT INTO caxNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Arrti Jesús amencoti auqui nanaiña puebluca y poca, aübu bama ñanunecasarrti. Sürotitito ubau manio poca sinagoga auna cauta nantarrü iyoberabaramacü macrirrtianuca nauqui eama. Urapoiti nomirria icütüpü na arrtü türiabucati Tuparrü. Urriancama ito tato uiti arrübama maunrrocono oboi arrüba aruqui nanaiñantai norrococa. ");
INSERT INTO caxNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nauquiche asaratitü ümo cütüpürrü macrirrtianuca, taquisürümantai ümoti. Itopiqui cuamatü esati tacana arrobe omiñarriatai nobirraca patachebo, champüti bacuirara yutacu. ");
INSERT INTO caxNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Auqui nanti Jesús ümo bama ñanunecasarrti: —Cütüpürrü bama macrirrtianuca choncoipüma arrüna urria manitacarrü. Ichepecacama tacana taman ñanaunrrü aübu tupubo trigo. Pero arrübama batrabacara ümoti Tuparrü ta mümanamantai. ");
INSERT INTO caxNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sane nauquiche apanqui pünanaquiti naqui esache manu cosecharrü, nauqui acüputi ümo bama nesarrti trabajadorerrü nauqui atama. ");
INSERT INTO caxNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Arrti Jesús batasuruti ümo bama doce ñanunecasarrti. Torrio uiti üriacaboma, nauqui puerurrü acüpuma ümo machoboreca auqui macrirrtianuca, y nauqui puerurrüma ito acurama aruqui nanaiñantai norrococa. ");
INSERT INTO caxNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tonehio arrüba nürirrimia bama doce apostolerrü: Arrti Simón naqui nürirrtito Pedro, ichepeti yaruquitotiatoe nürirrti Andrés; arrti Jacobo ichepeti yaruquitotiatoe nürirrti Juan, tonema arrübama aütorrti Zebedeo; ");
INSERT INTO caxNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","arrti Felipe, arrti Bartolomé, arrti Tomás y arrti Mateo naqui yacobrarrü impuestorrü; arrti Jacobo naqui aütorrti Alfeo; arrti Lebeo nürirrtito Tadeo; ");
INSERT INTO caxNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","arrti Simón naqui auqui manu partidorrü cananista; arrti Judas Iscariote naqui uiche aipiaventecanatiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bacüpuruti Jesús ümo bama doce ñanunecasarrti aübu arrüna ñanunecacarrti ümoma sane: —Tapü amecatü au puebluca auna cauta champüma bama israelitarrü. Tapü amecatü au manio puebluca au manu cürrü Samaria. ");
INSERT INTO caxNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amecosi apapacheroma manuma macrirrtianuca auqui na cürrü Israel, arrübama chaquionopümainqui iyoti Tuparrü, ta aboma tacana arrobe nobirraca omensoro. ");
INSERT INTO caxNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Amecosi aburaboi que tüsaiyapae üriaburuti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Apacura ümo bama maunrrocono. Apitümoniancasama tato bama coiño. Apacura ito ümo bama upusara ñañeturrüma (lepra). Apicüpusuma bama machoboreca auqui macrirrtianuca. Arrüna nabüriaca torrio aume champürrtü apacompratio. Sane ito tapü apacobracama bama urriancama tato aboi. ");
INSERT INTO caxNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‛Tapü apacaca oro ni monirripü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tapü apacaca tapiquirri. Tapü apacaca ito rroparrü. Amecosi saneantai aübu arrüna ane aucütüpü. Tapü apacaca zapaturrü y tapü apacaca bastón. Arraño tusio te aume que arrti naqui batrabacara tiene que atorri utuburiboti. ");
INSERT INTO caxNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‛Arrtü apiñatai au taman pueblurrü o au taman rranchurrü, apapacheti naqui ñoñünrrü macumananaunrrtai. Abasiquia au niporrti, cheperrtü amecatito auqui manu pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Arrtü apiñatai au taman porrü, apanqui nurria ümo bama pohoso. Amucanaño sane: “Taiquiana urria nabaca uiti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Arrtü yasutiuma arrümanu napanquiqui, urria nacarrüma. Tapürrtü chiyasutiupüma chücurusüopüma aboi. ");
INSERT INTO caxNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Arrtü chiyasuriurupüma año y chirranrrüpüma oncoimia napanunecaca, amecosi ito auqui manu porrü o auqui manu pueblurrü. Apipetobisaño nurria arrtü tünamequito nauqui, atusi ümoma que ane nipünatema. ");
INSERT INTO caxNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ñemanauncurratoe sucanañü aume: Arrtü iñatai manu nanenese nesa bacurrtacarrü torrio carrticurrü ümo manu pueblurrü. Arrümanu carrticurrü manrrü fuerte pünanaqui manu torrio ümo bama pohoso auqui Sodoma y Gomorra. ");
INSERT INTO caxNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nantito Jesús ümo bama ñanunecasarrti: —¡Icüpucaño tacana arrobe nobirraca omeana nuitümüca! Arraño tiene que amasarai nurria autacuapatoe, tacana noirroborrü. Pero sí tapü ane causane aboi ümo maquiataca. Apiña tacana nututaquiquia. Champü causane oboi. ");
INSERT INTO caxNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Amasai nurria, itopiqui arrübama macrirrtianuca tiene que autorriquia uimia ümo bama mayüriabuca, nauqui acurrtama abaübu. Aucüboriquia uimia au ba poca sinagoga cauta nantarrü meaboma bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hasta iquianama año ito ñana esa bama tarucu nüriacarrüma y esa bama mayarusürüca mayüriabuca auqui niyaca. Así que arraño caüma puerurrü apanitane nisüri isucarüma y isucarü nanaiña genterrü icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Arrtü itorrimianama año mecu bama mayüriabuca, tapü ane nümoche aboi iyo arrüna apanitacabo o arrüna aburapoboibo isucarüma. Au manu nanenese ñana torrio aume uiti Bae Tuparrü arrüna apanitacabo. ");
INSERT INTO caxNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Itopiqui champürrtü aboiyapatoe arrüna apanitaca, ta uiti Espíritu Santo naqui anati au nabausasü uiti Uyaü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‛Arrübama mañoñünca itorrimianama bama yaruquitorrümantoe nauqui ataborimia. Aboma bama mayaüca torrioma ito ui bama yaütorrüma. Y arrübama mayaüca tüboricoma ümo bama yaütorrüma. Sane nauquiche coiñoma uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Namanaiñantai tüboricoma aume auqui niyaca. Pero arrti naqui chübatachebopü ñacoconauncurrti iñemo, tonenti naqui iyebo uiti ñana esati Tuparrü au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Arrtü itaquisünümacanama año au taman pueblurrü, aupesübu auqui manu. Amecosi au quiatarrü pueblurrü. Ñemanauncurratoe sucanañü aume: Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ise tato abarrüpecu antes que apiñanai au nanaiña puebluca auna cürrü Israel. ");
INSERT INTO caxNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‛Arrti taman alumnorrü chüpuerurrüpü ane manrrü nüriacarrti pünanaquiti maestro. Arrti taman mosorrü chüpuerurrüpito ane manrrü nüriacarrti pünanaquiti ipiatronetorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Arrti alumnorrü tiene que ataquisürüti isiatai tacanati maestro. Arrti mosorrü isiatai. Arrüñü tacanati aupatron. Arraño tacana bama imoso. ¿Uramapü sane aume, arrtü namatü iñemo choborese? ");
INSERT INTO caxNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‛Tapü aupirruca ñünana bama aboma ausiu, bama tüboricatai aume. Itopiqui chüpuerurrüpü ane arrümanu chütusiopü. Nanaiña arrüna anecanatai tiene que atusi. ");
INSERT INTO caxNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Arrüna aumeantai surapoi anecanatai, arraño tiene que aburaboi nurria isucarü macrirrtianuca. Tapü apiñanecata isucarüma. Arrüna surapoi ituru namumasuatai, arraño tiene que autosibine isucarü macrirrtianuca, nauqui atusi ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tapü aupirruca ñünana bama itabaitama arrüna cürrü nocütüpü. Pero nuyausüpü chüpuerurrüpüma aitabaimia. Aupirru tone ñünanati Tuparrü naqui puerurrü aipenenoti año au infierno aübu nanaiña naücütüpü y nabausüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‛Bacobraca tamantai monimia itobo torrü nutaumanca. Pero arrti Tuparrü chüpuerurrüpü atacüru ñaquioncorrti ni iyo nampü taman nutauma arrtü paquio acü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sane ito niqui nautanu abe mupacümuncunu uiti Tuparrü taiquiana taman. ");
INSERT INTO caxNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sane nauquiche tapü aupirruca. Arraño manrrü naucua ümoti Tuparrü mopünanaqui nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nantito Jesús ümoma: —Arrübama urapoimia isucarü macrirrtianuca que icocoromañü, arrüñü ito surapoi isucarüti Iyaü naqui anati au napese que arrüma nirranunecasama. ");
INSERT INTO caxNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tapü arrübama mapaña isucarü macrirrtianuca que chisuputarapümañü, arrüñü ito tiene que suraboi isucarüti Iyaü naqui anati au napese que arrüma chitonempüma airranunecasa. ");
INSERT INTO caxNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nantito Jesús ümoma: —Arraño apapensaca que arrüñü isecatü nauqui manrrü urria nacarrüma bama macrirrtianuca icu na cürrü. Abu chüsanempü. Auqui niyaca caüma ane bahiquirri. ");
INSERT INTO caxNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Isecatü nauqui atüborimia bama mayaüca ümo bama yaütorrüma y arrüba cupiquiquia ñome niyupaparrü, arrüba tüboposo ñome niyupaparrtorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sane caüma enemigorrüma ümomantoe abu, familiarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‛Arrti naqui manrrü nicuarrti yaütoti y nipiacütoti ümoti rropünanaquiñü, chüpuerurrüpü yasuriurutito. Isiatai arrti naqui manrrü nicuarrüma bama aübosirrti ümoti rropünanaquiñü, chüpuerurrüpü yasuriuruti. ");
INSERT INTO caxNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Arrti naqui chirranrrüpü ataquisürü tacana arrüñü, chüpuerurrüpü yasuriuruti. ");
INSERT INTO caxNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Arrti naqui chirranrrüpü aco auqui niyaca, ensoro pünanaquiti nisüboriquirrti au napese. Tapü arrti naqui coiño auqui niyaca, tonenti naqui iyebo uiti au napese ichepeñü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nantito Jesús ümoma: —Arrti naqui yasuriuruti año, yasuriurutiñü ito. Arrtü yasuriurutiñü, arrti Tuparrü yasuriurutitito ta uiti aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Arrti naqui yasuriurutiti taman profetarrü itobo arrüna ñanitacarrti au nürirrti Tuparrü, ane nicuarrti uiti Tuparrü isiu tacana arrüna nicua bama profetarrü. Arrti naqui yasuriurutiti taman ñoñünrrü naqui buenorrü au nisüboriquirrti, ane ito nicuarrti uiti Tuparrü isiu tacana arrümanu nicuarrti maniqui ñoñünrrü buenorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Arrtü anati naqui macumanana taman basorrü turrü ümoti naqui manrrü taquisüratai uturuqui bama nirranunecasa, ane ito nicuarrti au napese itobo. ");
INSERT INTO caxNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nauquiche tüchauqui ñanunecacarrti Jesús ümo bama doce ñanunecasarrti, sürotitü auqui manu anunecati ubau ba piquiataca puebluca y poca. ");
INSERT INTO caxNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Arrti Juan Bautista anancati au preso. Ipiatenti nanaiña arrüna isamutenti Cristo. Auqui bacüpuruti ümo bama torrü ñanunecasarrti, nauqui ariorrüma esati Jesús ");
INSERT INTO caxNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","anquirioma anquirioma pünanaquiti: —¿Arrücü Cristo, naqui yebobotü, o tiene que suparrüpera cümenutiqui? ");
INSERT INTO caxNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aiñumuti Jesús: —Amecosi aburaboi isucarüti Juan enterurrü arrüna amarrtai y arrüna amoncoi. ");
INSERT INTO caxNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aburasoi isucarüti que arrübama supuso asarama tato. Arrübama chamencopü amencoma tato. Arrübama maunrrocono ui lepra urriancama tato. Arrübama chonaunpüma onauma tato. Arrübama tücoiño süboricoma tato. Arrübama taquisürü, abe omirria manitacaca isucarüma, arrüba uiche ataesübuma eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aburasoi ito isucarüti arrüna sane: Urriampae nacarrüma bama oncomatü nurria iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nauquiche tüsüroma tato manuma ñanunecasarrti Juan, arrti Jesús manitanati icütüpüti Juan isucarü manuma macrirrtianuca, nanti: —¿Isane nümoche abacatü aucutanu au rroense numo apapaseacati Juan? ¿Taqui abacatü amasaraiti ñoñünrrü naqui tacana taman nihi tutairri arrüna ane mapetonono ui maquiütürrü? No, champürrtü sane nacarrti Juan. ");
INSERT INTO caxNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿O abacatü amasarati taman ñoñünrrü, naqui champü tacanache naibiquirrti? Arraño tusio aume que arrübama champü tacanache naibiquirrimia aboma au nipo bama mayüriabuca. ");
INSERT INTO caxNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¡Isanempü nümoche abacatü! ¿Taqui abacatü amasarati taman profetarrü? Bien ñemanauntu, arrti te profetarrti. Manrrüqui nüriacarrti pünanaquiti profetarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Arrti Juan tonenti maniqui coreorrü uiti Tuparrü. Ane te corobo icütüpüti Juan arrüna sane nurarrti Tuparrü ümoti Cristo: Rracüpuca ümoti taman coreorrü nauqui acusürüti, aicoñocoti cutubiurrü acümenucu. ");
INSERT INTO caxNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñemanauncurratoe sucanañü aume —nanti Jesús ümo genterrü—, icu na cürrü champü tanati naqui manrrü nüriacarrti pünanaquiti Juan Bautista. Pero auna cauta üriabucati Tuparrü, arrti naqui chitonempatai ane manrrü nüriacarrti pünanaquiti Juan. ");
INSERT INTO caxNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‛Auqui numo aübo ayeti Juan Bautista anunecati, tanancatai nüriacarrti Tuparrü hasta caümainqui. Pero aboma bama churriampatai ümoma, sane nauquiche rranrrümampae aitochenacama. ");
INSERT INTO caxNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Itopiqui arrti Moisés y namanaiña bama profetarrü urapoimiacaü arrünarrtü üriabucati Tuparrü. Numo cuati Juan, chauqui tirranrrü acoco nurarrüma tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Arrtü aurrianca apicoco arrüna sane, entonces apicoco. Arrti Juan tonenti profetarrü Elías, naqui yebobotü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Arraño ane namumasu, amonsapesio. ");
INSERT INTO caxNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nantito Jesús: —¿Aübuchepü ichepecanama bama macrirrtianuca arrüna tiemporrü? Arrübama macrirrtianuca caüma tacana masiomanca. Cupiusuma au plaza y tosibicoma ümo bama icumpañeruturrüma: ");
INSERT INTO caxNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Supapunuca burrirri aume, pero chautococapü. Supasoniquia aume arrüna orronenatai, pero chabareocapü”. ");
INSERT INTO caxNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Itopiqui numo cuati Juan, amucanaño que anati choborese auti ui arrüna amarrtai charucupatai niyacarrti y chichabotipü vinorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Auqui isecatito arrüñü naqui Ñemanauncurratoe Ñoñünrrü. Irraca, ichaca y aburapoi iñemo que arrüñü chaborrüñü y tarucu nirraca. Amucanaño ito que arrüñü amigorrüñü ümo bama tarucu nomünantü uimia y arrübama mayacobraca impuestorrü. Pero tusiatai arrüna ñapanauncurrti Tuparrü ui arrüna urria isamutenti auna icu na cürrü. Sane ñanunecacarrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Auqui arrti Jesús macuansomoconoti ümo bama pohoso ubau manio puebluca auna cauta manrrtai ñasamucurrti milagrorrü tücañe. Itopiqui arrüma champürrtü iñorronconomacü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nanti sane ümoma: —Autaquisürücatai bama auqui manio puebluca Corazín y Betsaida. Arrübama pohoso au manio puebluca Tiro y Sidón tarucu nomünantü uimia tucañe. Pero arrtü nampü omirriante arrüba milagrorrü taha tücañe, coboipü aiñorronconomacü, aibioma luto y manrrü tübütürrü itama, na atusi orronene ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bien sucanañü aume. Arrtü iñatai manu nanenese nesa bacurrtacarrü, tiene que atorri aume manrrü fuerte carrticurrü pünanaqui arrüna torriobo ümo bama auqui Tiro y Sidón. ");
INSERT INTO caxNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y arraño bama auqui Capernaum, napaquioncopü tarucu manauncurrü aume. Pero arraño tiene que autapeneca au nusutu cürrü. Arrtü nampü omirriante arrüba milagrorrü au manu pueblurrü malorrü Sodoma tücañe, aninquipü caüma, itopiqui iñorronconomacüpü, y chiñarriopü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ñemanauncurratoe sucanañü aume —nanti Jesús, —au manu nanenese ñana nesa bacurrtacarrü, arraño tiene que atorri aume carrticurrü manrrü fuerte pünanaqui arrüna carrticurrü torriobo ümo bama pohoso auqui Sodoma. ");
INSERT INTO caxNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Au manu tiemporrü arrti Jesús meaboti sane: —Arrücü Iyaü ane nüriaca ümo napese y ümo cürrü ito. Ñachampiencaca aemo, itopiqui aiñanecaquio arrüba sane pünanaqui bama namatü que tarucu ñapanauncurrüma y aitusiancaquio isucarü bama masiomanca. ");
INSERT INTO caxNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sane te Iyaü. Itopiqui sane arrüna narrianca. ");
INSERT INTO caxNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Auqui nanti Jesús ümo manuma amoncoma acamanu: —Arrti Iyaü itorrimiatati isüriacabo ümo nanaiñantai icu na cürrü. Arrüñü Aütorrti Tuparrü. Champüti naqui isuputaratiñü nurria, arrtiatai Iyaü. Y champüti naqui isuputaratiti nurria Iyaü, arrüñüantai ichepe bama itusiancacati isucarüma. ");
INSERT INTO caxNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ausiapata tauna yesañü namanaiña bama batachebo ui tarucu penarrü aboi, y ui napacoconauncu ümo bacüpucuca. Apacansa. ");
INSERT INTO caxNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Apacoconaun iñemo, amonsoi nisura, apiña isiuquiñü, arrüñü champü causane sobi au nisüboriqui. Tarucu nibuenucu, sobi macansara nabausüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Arrüna nirracüpucu aume champürrtü cuerrtarrü naqui apicoco. Puerurrtai año apisamune. ");
INSERT INTO caxNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Au manu tiemporrü tücañe, taman nanenese nesa macansacarrü, arrti Jesús sürotitü ichepe bama ñanunecasarrti auqui manio ñanaunca, arrüba cauta ane trigo. Arrümanuma ñanunecasarrti cürüpüoma. Auqui baurrtaquioma chimiantai nüta trigo y basoma. ");
INSERT INTO caxNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Arrübama fariseorrü nauquiche arrtaimia arrüna sane, namatü ümoti Jesús: —¡Asasatü. Arrübama anunecasa baurrtaquioma nüta trigo, abu churriampü batrabaca au nanenese nesa macansacarrü! ");
INSERT INTO caxNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aiñumuti Jesús: —¿Taqui champürrtü lehebo año icu Nicororrü arrüna isamutenti David tücañe ichepe bama icumpañeruturrti, nauquiche cürüpüoma? ");
INSERT INTO caxNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sürotipo au niporrti Tuparrü aübuma, iyarioma manio pan mosamamecana ümo bamantai sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Taqui champürrtü lehebo año ito arrüna nantü au nüriacarrü uiti Moisés sane? Arrübama sacerdoterrü chümacansarapüma au nanenese nesa macansacarrü. Batrabacarama au niporrti Tuparrü. Pero ta champü nipünatema uirri. ");
INSERT INTO caxNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Arrüñü ane manrrü nisüriaca pünanaqui bama batrabacara au niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Arraño champürrtü iyebo aboi arrüna nantü au Nicororrü: “Manrrü irranca nauqui ane naupucüru itacuti quiatarrü, pünanaquirrtü apacumanaca numuquianca iñemo”. Arrtü nampü iyebo aboi, quiubupü abasiquia apanita arrüna churriampü ümoti naqui champü nipünantenti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Itopiqui arrüñü Ñemanauncurratoe Ñoñünrrü, ane ito nisüriaca ümo arrüna nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Auqui arrti Jesús sürotitü auquimanu. Sürotipo au manu porrü sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Acamanupo anancati taman ñoñünrrü naqui süübatai neherrti. Arrümanuma fariseorrü bapacheroma niquiubuma causane nauqui urabomati Jesús. Ñanquitioma pünanaquiti, namatü: —¿Urria bacura ümo bama maunrrocono au nanenese nesa macansacarrü? ");
INSERT INTO caxNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aiñumuti Jesús: —Supiarrtü anati taman abuturuqui naqui paquio niyaburrti nobirrama au cütubirri au nanenese nesa macansacarrü. ¿Aensapü chüsürotitüpü aiquiaübuti tanene au nanenese nesa macansacarrü? ");
INSERT INTO caxNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Arraño tusio nurria aume que manrrtai nicuarrti ñoñünrrü pünanaqui taman nobirrarrü. Sane nauquiche urria uisamune arrüna urria au nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Auqui nanti Jesús ümoti maniqui ñoñünrrü: —¡Aipesünaca nehe! Ipesünacatati maniqui ñoñünrrü. Au manu rratorrü urriante tato tacana arrümanu quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Arrümanuma fariseorrü caüma süromatü türüpo auqui manu esaquiti Jesús. Auqui baparioma causane uimia nauqui aitabairomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pero arrti tusiatai ümoti. Sane nauquiche sürotitito auquimanu. Cütüpürrü genterrü sürotü isiuti. Isiu na namenrrti bacurarati ümo namanaiña bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Macuansomoconoti ümoma, tapü urapoimia isucarü bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Arrüna nisamutenti Jesús, ta nauqui acoco arrüna urapoiti tücañe profetarrü Isaías, nauquiche nanti: ");
INSERT INTO caxNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sane nurarrti Tuparrü: Tonenti naqui baserebioti iñemo y tacümanauncunuti sobi. Bien cuasürüti iñemo. Tonenti naqui ipucünuncatai icuatati. Tiene que rracüpu niyesa Espíritu au nausasürrti. Tiene que ito uraboiti isucarü macrirrtianuca causane niyücü nirracurrtaca aübuma. ");
INSERT INTO caxNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Chüpuerurrüpü nauqui ahiti, ni atosibitipü, ni uratoquitipü yusiu cayaca. ");
INSERT INTO caxNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Chübachebotipito chacu bama champüqui nicusüurrüma, ni uratoquitipü ümoti naqui tarucapae nisuchequirriti. Chübatachebotipü cheperrtü urriante uiti nanaiña arrüna urria au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y nanaiña genterrü icuqui na cürrü tiene que oncotü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Auqui iquianamati esati Jesús maniqui taman ñoñünrrü naqui chasarapütü, y chüpuerurrüpü anitati, itopiqui anati taman choborese auti. Arrti Jesús bacurarati ümoti. Sürotitü choborese auquiti uiti. Sane nauquiche arrti maniqui ñoñünrrü asarati tato y puerurrü ito anitati tato. ");
INSERT INTO caxNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Enterurrü manuma macrirrtianuca amoncoma acamanu cütobüsoma ui arrüna nisamutenti Jesús, namatü: —¿Taqui tonenti Cristo naqui cuabotü eanaqui nesarrti familiarrü David? ");
INSERT INTO caxNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nauquiche oncoimia bama fariseorrü arrüna sane, namatü: —Arrti naqui ñoñünrrü bacüpuruti ümo bama machoboreca auqui macrirrtianuca, solamenterrü itopiqui torrio üriacaboti uiti Beelzebú naqui üriatu bama machoboreca. ");
INSERT INTO caxNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero arrti Jesús chauqui tütusiatai ümoti arrümanu ñapensacarrüma, nanti ümoma: —Supiarrtü ane taman nación. Arrübama mayüriabuca bahiyoma ümomantoe. Arrümanu nación chüpuerurrüpü urura, mameso nüriacarrü. Isiatai arrtü ane taman familiarrü o taman pueblurrü auna cauta tüboricomantai ümomantoe, chüpuerurrüpü urura, tiene que aiñarri. ");
INSERT INTO caxNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sane ito pasabo ümoti choborese, arrtü bacüpurutipü tanene auqui macrirrtianuca ümo bama machoboreca. Uirrtiatoepü mameso nüriacarrti, chüpuerurrüpü urura nicusüurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Arraño amucanaño que arrüñü rracüpuca ümo machoboreca auqui macrirrtianuca ui nüriacarrti naqui yarusürürrü choborese. ¿Carü arrübama napanunecasa quitipü naqui üriacache arrüna uiche puerurrüma acüpuma tanene ümo machoboreca? ¿Aensapü ui nüriacarrti choborese ito? A ver te urama sane ümo arrüna napanitaca iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero arrtü ñemanauntu —nanti Jesús—, rracüpuca ümo machoboreca auqui macrirrtianuca ui nüriacarrti Espíritu Santo, naqui cuati esaquiti Tuparrü, auqui caüma tusiatai que chauqui türiabucati Tuparrü abarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Chüpuerurrüpü uiquiaübu nenarrirrti naqui tarucu nicusüurrti arrtü chütomoenotipü primero osoi. ");
INSERT INTO caxNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nantito Jesús: —Arrti naqui chocümanapü ichacuñü, tüboricotiatai iñemo. Arrti naqui chübatasurutipü ichepeñü ümo macrirrtianuca isiuñü, iñarrimiacata arrüba omirria. ");
INSERT INTO caxNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sane nauquiche sucanañü aume, que puerurrü arrimiaca tato aruqui nanaiñantai nomünantü aboi. Pero arrti naqui churriampatai nurarrti ümoti Espíritu Santo, chüpuerurrüpü ane marrimiacatarrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Arrüñü Ñemanauncurratoe Ñoñünrrü, arrtü anati naqui churriampatai nurarrti iñemo, ane marrimiacatarrü tato ümoti. Pero arrtü anati naqui churriampatai nurarrti ümoti Espíritu Santo, chüpuerurrüpü ane marrimiacatarrü tato ümoti, ni aunampü icu na cürrü, ni au napesepü ñana. ");
INSERT INTO caxNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nantito Jesús ümoma: —Arrtü ane taman suese urria, üta ito omirria. Tapürrtü ane taman suese churriampü, chomirriampito nütarrü. Sane nauquiche usuputacai suese ui nütarrü, arrtü urria o churriampü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sane ito arraño bama niñupariente noirroboca, chüpuerurrüpü urria arrüna napanitaca, itopiqui malorrü año. Arrüna ane au nuyausasü tone arrüna manitate. ");
INSERT INTO caxNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Arrti ñoñünrrü buenurrü, manitanati arrüba omirria, itopiqui arrüba omirria abe au nausasürrti. Tapü arrti naqui ñoñünrrü malorrü, manitanati arrüba chomirriampü, itopiqui arrüba chomirriampü abe au nausasürrti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ñemanauncurratoe sucanañü aume: Ñana au manu nanenese nesa bacurrtacarrü, tiene que apacurrtario nanaiña arrüba chomirriampatai napanitaca tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Itopiqui tiene que apacurrta isiuqui arrüna napanitaca. Arrti naqui manitanatai ane nipünatenti. Pero arrti naqui besüro nurarrti, champü isane aübuti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Auqui namatü ümoti Jesús manuma fariseorrü y arrümanuma maestro ümo nüriacarrü: —Maestro, suirranca nauqui asamu taman milagrorrü suisucarü, nauqui atusi suiñemo que arrücü ayecatü esaquiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iñumutati Jesús manu nurarrüma: —Arrüna genterrü auna y arraño bien malorrü, chapaquioncañopü iyoti Tuparrü. Aurrianca amasarai señarrü y milagrorrü. Chüpuerurrüpü atorri quiatarrü señarrü y milagrorrü aume, cunauntañantai manu señarrü uiti profetarrü Jonás, arrüna pasabo tücañe ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Itopiqui arrti Jonás anancati cübobi manu yarusürürrü nopiocorrü, trerrü naneneca y trerrü tobiquia nacarrti ahu. Sane ito pasao iñemo arrüñü Ñemanauncurratoe Ñoñünrrü, tiene que yaca cütu eana cürrü trerrü naneneca y trerrü tobiquia. ");
INSERT INTO caxNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Arrtü iñatai manu nanenese nesa bacurrtacarrü, arrümanuma mañoñünca auqui manu pueblurrü Nínive tücañe, atüraiyoma y uimia caüma uraboimia carrticurrü ümo na genterrü nesa arrüna tiemporrü. Itopiqui arrüma tücañe iñorronconomacü, numo anancati Jonás manunecanati ümoma, tapü asioma aübu arrüna churriampatai nisüboriquirrimia. Arraño caüma chaurriancapü apicocoroti naqui manrrü pünanaquiti Jonás, ta arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Arrümanu ito paürrü nüriaburrü auqui tauna ümo mancarrü, atüraiyo ito ñana arrtü iñatai manu nanenese nesa bacurrtacarrü y uirri caüma urapoi carrticurrü ümo na genterrü nesa arrüna tiemporrü, itopiqui tone cuatü tücañe auqui iche nauqui onsaperio ñanunecacarrti Salomón. Arraño caüma chaurriancapü apicocoroti naqui manrrü pünanaquiti Salomón, ta arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‛Arrtü anati taman choborese aübo aiquiaüburutiyü auquiti taman ñoñünrrü, amencotiatai eana rroense auna cauta champü turrü, yapachequirrti arrüna cauta acansati. Arrtü chümatamünanatipü, ");
INSERT INTO caxNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","auqui caüma mapensarati: “Yeca tato au nipo, arrüna auquiche saliboñü”. Arrtü basücübücoti tato, icuñunutiti maniqui ñoñünrrü tacana arrone porrü bien sunucunu, bien coñocono y cücheca. ");
INSERT INTO caxNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Auqui caüma sürotitü atasuti ümo bama siete maquiataca machoboreca manrrü malorrüma pünanquiti, nauqui aüroma ichepeti avivimia auti maniqui ñoñünrrü. Sane nauquiche manrrü churriampatai nisüboriquirrti. Sane tiene que apasa ümo na genterrü malorrü arrüna tiemporrü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nauquiche anancatiqui Jesús manitanati ümo genterrü, auqui iñatai nipiacütoti ichepe bama yaruquitorrti. Arrüma süsioma türüpo, rranrrüpüma aparimia aübuti. ");
INSERT INTO caxNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tamanti urapoiti isucarüti Jesús, nanti ümoti: —Napacüma y bama aruquitaiqui aboma auna türüpo, rranrrüma aparimia aübucü. ");
INSERT INTO caxNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero arrti Jesús nanti ümoti maniqui urapoiti isucarüti: —¿Ñacusanempito nipiacü, y ñacubamapito bama masaruquitaiqui? ");
INSERT INTO caxNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Auqui masamunuti señarrü ümo bama ñanunecasarrti, nanti ümoma: —Arrübama nirranunecasa tonema tacana nipiacü, y tonema bama masaruquitaiqui. ");
INSERT INTO caxNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Itopiqui cualquierarrtiatai naqui icocota arrüna yacüpucurrti Iyaü, naqui anati au napese, tonenti saruqui y tone niquiasi y nipiacü. Sane nanti Jesús ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Au manuinqui nanenese arrti Jesús sürotitü auqui manu porrü arrüna cauta anancati. Sürotitü atümoti abeu manu narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sürümanama macrirrtianuca iñataimia acamanu esati. Süroti au taman barco, arrüna ananca esa nabeurrü, tümonsoti ahu. Enterurrü genterrü ane abeu narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Auqui manunecanati ümoma aruqui nanaiñantai. Urapoitito isucarüma arrüna machepecatarrü sane: —Tamanti ñoñünrrü sürotitü ancütuti au niyorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Isiu na yasupiucurrti niyorrü, abe arrüba bupaquio isiu cutubiurrü. Auqui cuantio nutaumanca y yubario. ");
INSERT INTO caxNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Piquiataca bupaquio omonü canca, auna cauta chimiantai cürrü. Orratorrtai ububaüro, itopiqui chotüsapü nubacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nauquiche tütane ape surrü bosübo uirri. Champü te nurria niyurranacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Piquiataca bupaquio omeana cümeca. Musunaun arrümanio cümeca y chiyebopü ito oboi manio plantamanca. ");
INSERT INTO caxNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero piquiataca niyoca bupaquio eana arrüna urria cürrü. Sane nauquiche ububaüro y musunaun. Urriampae nobütacarrü. Abe ba pachebo cien granurrü. Piquiataca pachebo sesenta y abe ito ba pachebo treinta granurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Arraño ane namumasu, amonsapesio te. ");
INSERT INTO caxNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Auqui arrümanuma ñanunecasarrti Jesús süromatü esati, nauqui namatü ümoti: —¿Causane asiquia anitanio machepecataca isucarü macrirrtianuca? Cuestarrü aye uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Auqui iñumutati Jesús: —Aumeantai tusio uiti Tuparrü causane arrüna niyücürrü taha auna cauta ane nüriacarrti. Pero arrübama macrirrtianuca chüpuerurrüpü atusi ümoma. Chütorriopü ümoma uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Itopiqui arrti naqui tusio ümoti torrioqui manrrü ipiacaboti, pero arrti naqui chütusiopü nurria ümoti, hasta arrümanu chimiantai ipiacati carübu pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sane nauquiche rranunecaca oboi machepecataca, itopiqui arrüma arrtanaunrrüma y onaunrrüma ito, pero chentienderrüpüma. ");
INSERT INTO caxNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sane cocono arrümanu urapoiti profetarrü Isaías tücañe: Arraño tiene que amoncoi, pero chüpuerurrüpü aüro au nautanu. Tiene que amasacatito, pero chüpuerurrüpü aye au namasata arrüna amarrtai. ");
INSERT INTO caxNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Itopiqui tarucu nitai nabausasü. Uirri arrüna chautanunauncapü ümo arrüna arrtü ane isane amoncoi. Abaca ito tacanarrtü umamana nausüto, chamasacapütü nurria. Sane nauquiche chüpuerurrüpü aye aboi, chüpuerurrüpü ito apiñorronconaño y chüpuerurrüpito autaesübu sobi eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nantito Jesús ümo bama ñanunecasarri: —Pero arraño urriampae nabaca itopiqui amasacatü ui nausüto y süro au nautanu arrüna amoncoi. ");
INSERT INTO caxNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ñemanauncurratoe sucanañü aume, sürümanama bama profetarrü y arrübama urria nisüboriquirrimia tücañe, rranrrrüpüma asaraimia arrüna amarrtai caüma. Rranrrüpüma ito onsaperioma, arrüna amoncoi caüma, pero chiyebopü ümoma, itopiqui coiñoma. ");
INSERT INTO caxNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nantito Jesús: —Suraboira ito caüma ausucarü isane nümoche arrümanu machepecatarrü ümoti maniqui ñoñünrrü sürotitü ancütuti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aboma bama oncoimia arrüna manitacarrü icütüpü nüriacarrti Tuparrü, pero chentienderrüpüma ümo. Iyebo uimia tacana nubaca arrümanio niyoca bupaquio isiu cutubiurrü. Cuati choborese iquiaübutati arrümanio omirria manitacaca auqui nausasürrüma, tacana manio nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Arrümanio niyoca bupaquio omonü canca isiu tacana arrübama oncoimia nurarrti Tuparrü y yasutiuma aübu nipucünuncurrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero chipiacapüma asamuma tairri. Ui arrüna ñacoconauncurrüma ümoti Tuparrü, taquisürüma y aboma bama tüboricomantai ümoma. Sane caüma orratorrtai iñocotama arrüna ñacoconauncurrüma ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Arrümanio niyoca omeno cütu omeana cümeca, isiu tacana bama oncoimia arrüna nurarrti Tuparrü, pero ñana manrrü aboma yusiu arrüba nenarri nantai cürrü. Itopiqui tarucapae penarrü uimia iyo nisüboriquirrimia. Ui arrüna sane ñapensacarrüma, tacürusu ñaquioncorrüma iyoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero arrümanio niyorrü omeno cütu au manu cürrü urria, ta tacana bama oncoimia nurarrti Tuparrü, iyebo uimia. Y urria nisüboriquirrimia. Aboma tacana manu niyorrü bachebo cien granurrü, piquiataca tacana ba pachebo sesenta granurrü, o tacana manu ütao treinta granurrü auqui taman niyorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Auqui arrti Jesús urapoiti arrüna quiatarrü machepecatarrü: —Arrüna arrtü üriabucati Tuparrü oemo, isiu tacanati maniqui taman ñoñünrrü mancüturu urria niyo trigo au niyorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Au tobirri nauquiche tümanumuma macrirrtianuca, cuati maniqui nesarrti enemigorrü ancütuti narrüchopüro eana nesarrti trigo, arrümanu isiu nacarrü tacana trigo, abu churriampü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ubaüro arrümanu trigo, abe nütarrü. Ubaüro ito manu narrüchopüro. ");
INSERT INTO caxNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sane nauquiche süromatü manuma mamosoca uraboimia isucarüti naqui iyoche: “Señor, arrücü ancütuca aucutanu arrüna urria au naho. ¿Causanempü nauqui ataso ito caüma ui narrüchopüro?” ");
INSERT INTO caxNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Auqui arrti maniqui iyoche nanti ümoma: “Arrüna sane es uiti naqui tüboricatai isuatañü”. Auqui arrümanuma mamosoca ñanquitioma pünanaquiti maniqui iyoche: “Arrianca nauqui sopiquiyaurio manio narrüchopüro?” ");
INSERT INTO caxNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aiñumuti maniqui iyoche: “No, tapü apiquiyauquio, itopiqui arrtü apiquiyauquio rrepente boquiyauru ito manio trigo abe acamanu omeana. ");
INSERT INTO caxNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejor apiñoco, tari ñusunauna juntorrü cheperrtü tupubu trigo. Auqui caüma rracüpuca ümo bama niyesa trabajadorerrü aiquiyaübuma primero arrümanio narrüchopüro nauqui aiñonocoma. Auqui ito caüma tana manu trigo nauqui ahübu iquiana nipo. ");
INSERT INTO caxNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iñatatito quiatarrü machepecatarrü, nanti sane: —Arrüna nüriacarrti Tuparrü oemo, es tacana arrone niyo mostaza sürocütu uiti taman ñoñünrrü au niyorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ñemanauncurratoe chitonempatai arrümanu niyo mostaza. Tapü arrtü ubaüro, isamunü sürümanarrü tacana suese. Arrüba nutaumanca caüma pasumenunu yocütüpü nipiarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iñatatito Jesús arrüna quiatarrü machepecatarrü isucarü macrirrtianuca, nanti sane: —Arrüna nüriacarrti Tuparrü oemo ta tacana arrümanu nürirri levadura arrüna uiche atusa tubarrirri arrtü masamuca pan. Taman paürrü iñata eana tubarrirri, auqui bien icorauta, nauqui aiñarri nurria eana manu tubarrirri. ");
INSERT INTO caxNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Arrti Jesús nanaiña urapoiti isucarü genterrü oboi machepecataca. Chümanitanatipü ümoma mientras que chiñatatipü machepecatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pasao arrüna sane, nauqui acoco arrümanu turapoiticaü tücañe taman profetarrü, nauquiche maconomonoti sane: Rranitaca yupu machepecataca. Surapoi arrüna ananca anecana, auqui numo maübo urriane na cürrü sobi, nanti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Auqui arrti Jesús masamunuti nariorrü ümo macrirrtianuca. Sürotipo au taman porrü. Acamanu arrübama ñanunecasarrti cuamatü esati y namatü ümoti: —Urasoi suisucarü, isane nümoche arrümanu machepecatarrü, narrüchopüro au ñanaunrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Auqui urapoiti isucarüma, nanti sane: —Arrti maniqui mancüturu, ta arrüñü, naqui Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Y arrümanu ñanaunrrü tone arrüna cürrü. Arrümanu niyo trigo, tacana arrübama macoconaunrrüma ümoti Tuparrü. Tapü arrümanu narrüchopüro tonema bama macoconaunrrüma ümoti choborese. ");
INSERT INTO caxNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tapüti maniqui enemigorrü uiche aiñaniontiño cütu manio narrüchopüro, tonenti naqui choborese. Arrümanu nitaca trigo tone arrüna arrtü tiñatai ñapacümuncuturrti Tuparrü. Arrümanuma trabajadorerrü ta tonema bama angelerrü esaquiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Arrümanu narrüchopüro amontonabo nauqui oho ui pese. Sane ito ñana pasabo, arrtü tiñatai ñapacümuncuturrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que rracüpu ümo bama niyesa angelerrü nauqui aipenenoma auqui manu cauta ane nisüriaca arrübama bachebo macocotorrü y arrübama isamutema nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tiene que apenema au horno ui bama angelerrü auna cauta ane pese. Acamanu tarucu nareorrüma y botoquio nohorrüma ui nitaquisürücürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tapü arrübama isamutema arrüna yacüpucurrti Tuparrü, tiene que anentarrü uimia tacana ui surrü auna cauta ane nüriacarrti naqui Yaütorrüma. Arraño ane namumasu, amonsapesio te. ");
INSERT INTO caxNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Arrtü üriabucati Tuparrü oemo pasabo tacana uiti taman ñoñünrrü naqui matamünana monirri cütu. Arrti caüma iñanecatati tatito auna cauta ananca. Ui arrüna sane tarucu nipucünuncurrti, süroti tato au niporrti aipiaventecanatiño nanaiña arrüba nenarrirrti, nauqui acomprarioti arrümanu cürrü, cauta ane manu chama monirri. ");
INSERT INTO caxNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nantito Jesús ümoma: —Arrtü üriabucati Tuparrü oemo, pasabo tacana uiti taman ñoñünrrü comercianterrü, bapacheroti perlaca arrüba omirriantai y tarucu niyucuarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Arrtü tabüco uiti taman perlarrü arrüna champü tacanache nicuarrü, süroti tato au niporrti, aipiaventecanati nanaiña nenarrirrti, nauqui acomprarioti manu perlarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nantito Jesús: —Arrüna ito nüriacarrti Tuparrü oemo, ta tacana arrone taman momese süro eana narubaitu turrü y basuru aruqui nanaiñantai nopiococa. ");
INSERT INTO caxNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Arrtü tataso manu momese ui nopiocorrü, arrübama imomeche iquiaübutama taiyiritu na aitacümanauncunioma manio nopiococa, arrüba omirria omeno peese au noconorrü. Tapü arrüba chomirriampü bobotabo uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sane tiene que apasa ñana arrtü tiñatai ñapacümuncuturrti Tuparrü. Cuamatü ñana bama angelerrü nauqui aitacümanauncunuma bama urria nisüboriquirrimia eananqui bama malorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Arrübama malorrü tiene que apenema eana pese au manu horno. Acamanu tarucu nareorrüma y botoquio nohorrüma ui nitaquisürücürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Auqui arrti Jesús ñanquitioti pünanaqui bama ñanunecasarrti nanti sane: —¿Tusio aume arrüna sucanañü? Auqui aiñunuma, namatü: —Iyebo soboi, Señor. ");
INSERT INTO caxNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Auqui nanti Jesús ümoma: —Aboma bama tiyebo uimia causane nüriacarrti Tuparrü. Manunecanama caüma arrüba tücoboi autusi ümoma, y arrüba ito aübo autusi ümoma. Ichepecacama tacanati taman naqui ane niporrti. Arrti itusiancatati arrüba omirria abe umahüburu uiti y itusiancaniontiño ito arrüba pomanca abe umahüburu uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nauquiche tanaiña uraboiti Jesús arrüba machepecataca, sürotitü auqui manu. ");
INSERT INTO caxNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Auqui iñataiti tato au Nazaret au manu cürrü Galilea auna cauta asunaunti tücañe. Acamanu manunecanati au manu porrü sinagoga auna cauta nantarrü iyoberabaramacü. Enterurrü genterrü cütobüso. Namatü sane: —¿Auquichepü aipiati naqui ñoñünrrü arrüna sane, tarucapae ñapanauncurrti? ¿Causanempü nauqui puerurrti aisamunenti arrüba milagrorrü? ");
INSERT INTO caxNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Abu arrti auqui nantai. Tonenti naqui aütorrti carpinterurrü José. Nipiacütoti nürirri Mariarrü. Arrübama yaruquitorrti aboma ito auna: Arrti Jacobo, arrti José, arrti Simón y arrti Judas. ");
INSERT INTO caxNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Arrüba niquiastoti bopohoso ito auna uyarrüpecu. ¿Auquichepatai uiti arrüna ñapanauncurrti y nüriacarrti? ");
INSERT INTO caxNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sane nauquiche ünantü ümoma nacarrti. Auqui nanti Jesús ümoma: —Arrübama profetarrü cuamatü auqui quiatarrü narücüquirri bien cuasürüma aume. Tapü arrti naqui auquina abarrüpecuqui, ta chapacoconauncapü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sane nauquiche champürrtü masamunuti nurria milagrorrü acamanu, itopiqui champürrtü icocoromati nurria. ");
INSERT INTO caxNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Au manu tiemporrü tücañe, arrti Herodes yüraburrti au manu cürrü nürirri Galilea. Arrti ipiatenti nürirrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Auqui nanti ümo manuma imostorrti: —Arrti maniqui ñoñünrrü tonenti Juan Bautista. Süboricoti tato eanaqui macoiñoca. Sane nauquiche ane nüriacarrti, nauqui asamuti milagrorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Taipü arrti maniqui yüriaburrü Herodes, bacüpuruti tücañe nauqui aiñenomati Juan Bautista. Tomoenoti ui cadenarrü y süroti au preso uimia auqui naca Herodías. Arrümanu paürrü Herodías tone nicüpostoti Felipe tücañe naqui yaruquitorrti Herodes, y arrti Herodes pohosoti aübu. ");
INSERT INTO caxNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Arrti Juan icuansomoconotiti Herodes tücañe, nanti ümoti: —Churriampü apoca aübu Herodías itopiqui tone nicüpostoti aruqui. ");
INSERT INTO caxNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Sane nauquiche rranrrtipü Herodes aitabairotiti Juan. Pero birrubuti ñünana genterrü, itopiqui enterurrümantai namatü que arrti Juan profetarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Auqui iñatai manu nesarrti cumpleañorrü Herodes. Arrümanu nicheche manu Herodías cuatü atoco isucarü namanaiña manuma amoncoma acamanu, bama tasuruma uiti. Arrti Herodes bien urriampae ümoti arrümanu nitococo manu nicheche Herodías. ");
INSERT INTO caxNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sane nauquiche itusiancatati nurria curusürrü isucarü manu cupiquirri, nanti ümo: —Anqui rropünanaquiñü isiu naca narrianca ichücü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Arrümanu Herodías bien iñununecata manu nichechese. Tone caüma urapoi isucarüti Herodes arrüna sane: —¡Aitorrimia iñemo nitanu Juan Bautista au taman praturrü! ");
INSERT INTO caxNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ui arrümanu sane nurarrü sucheboti yüriaburrü Herodes. Pero titusiancatati curusürrü isucarü y arrtaimia manuma amoncoma acamanu. Sane nauquiche tiene que aitorrimiati ümo. ");
INSERT INTO caxNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bacüpuruti nauqui aüromatü aitüsünama nitanurrti Juan au cárcel auna cauta anancati. ");
INSERT INTO caxNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Auqui cuatü uimia taman praturrü, ane ahu nitanurrti Juan. Itorrimiatama ümo manu cupiquirri. Atoco tone aitorrimia ümo nipiaparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Auqui iñataimia manuma ñanunecasarrti Juan aiquiama nicunturrti y süromatü aiñanamati cütu. Auqui süromatito uraboimia isucarüti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nauquiche tütusio ümoti Jesús, sürotitü iche auquimanu tamanti au taman barco auna cauta champü macrirrtianuca. Numo tipiatema manuma macrirrtianuca auqui manio puebluca, süromatü isiuti abeuqui manu turrü, acü süromatü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iñataiti Jesús taha au manu quiatarrü nabeurrü, tobüsoti auqui barco acü. Asaratitü ümo sürümana genterrü. Auqui pucürusuti itacuma. Sane nauquiche bacurarati ümo manuma maunrrocono cuamatü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nauquiche aübapae ütobi, arrübama ñanunecasarrti süromatü esati, namatü ümoti: —Chauqui tütümümücapae, auna champü poca. Asamu nariorrü ümo bama macrirrtianuca, naqui aüroma tato au ba rranchuca, nauqui acomporama utuburiboma. ");
INSERT INTO caxNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Auqui nanti Jesús: —Champü nümoche aüroma tato. Arraño tiene que apapache utuburiboma. ");
INSERT INTO caxNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Auqui namatü ümoti: —Ane auna soboi cincoatai pan y torratai nopiocomanca. ");
INSERT INTO caxNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nanti ümoma: —¡Apiquiataunasio iñemo! ");
INSERT INTO caxNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Auqui bacüpuruti ümo genterrü nauqui atümoma onü borrü. Auqui iquianiontiño mecuti manio cinco pan yochepe manio torrü nopiococa. Asaratitü ape, machampiencanati ümoti Tuparrü. Auqui bochepesüro uiti manio pan. Itorrimaniontiño ümo bama ñanunecasarrti y uimia rrepartibo ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Enterurrü manu genterrü baso y abeco nurria. Auqui arrübama ñanunecasarrti Jesús matacümanauncunuma arrüba niyupearrtuca, arrüba bosobürau uimia. Ubataso uimia doce noconoca. ");
INSERT INTO caxNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Arrümanu nubiqui manuma basoma, taqui cinco mil mañoñüncatai. Champürrtü mupacümuncunu paüca ni arrübamapü masiomanca. ");
INSERT INTO caxNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Auqui bacüpuruti Jesús ümo bama ñanunecasarrti, ariorrüma acusürüma taha nauqui aüromatü topü manu narubaitu turrü au taman barco. Tapü arrti caüma masamunuti baeta nariorrü ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Auqui sürotitü onü yiriturrü tamanti nauqui eanti. Tomite ümoti acamanu tamanti. ");
INSERT INTO caxNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tapü arrümanu barco tütane cümuinta manu narubaitu turrü. Maquiütüca fuerte cümenu, pocoro turrü, supiuru cütüpü barco. ");
INSERT INTO caxNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cuatü nanenese, arrti Jesús iñataiti isiu manu barco, amencoti isuqui turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Arrümanuma ñanunecasarrti asaramatü cümenuti cuati isuqui turrü. Auqui tosibicoma ui nirrucurrüma, namatü sane: —¡Anite yausüpürrü! ");
INSERT INTO caxNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Au manu rratorrü arrti Jesús manitanati ümoma, nanti: —¡Tapü aupirruca, ta arrüñü, tapü ane penarrü aboi! ");
INSERT INTO caxNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Auqui arrti Pedro manitanati, nanti ümoti: —Señor, arrtü ñemanauntu ta arrücü, aitasusuñü tanu aesacü, tari ñamena isuqui turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nanti Jesús: —¡Ariacu te tauna yesañü! Auqui arrti Pedro tobüsoti auqui barco y amenti isuqui turrü, niyücürrti cümenuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nauquiche onquisioti nicusüu manu maquiütürrü, birrubuti. Auqui numo tüniyücürrüpü ubacati cütu, tosibicoti sane: —¡Ayurasañü Señor, tapü yubacaca cütu! ");
INSERT INTO caxNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Au manu rratorrü arrti Jesús iñentati neherrti Pedro y nanti ümoti: —¡Champürrtü aicococañü nurria! ¿Causane choncapütü iñemo? ");
INSERT INTO caxNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nauquiche süromampo au manu barco, arrümanu maquiütürrü tochenco. ");
INSERT INTO caxNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Arrümanuma amoncoma au manu barco, bachesoiyoma esati Jesús, namatü ümoti: —¡Ñemanauncurratoe arrücü Aütorrti Tuparrü! ");
INSERT INTO caxNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sane tompücana uimia manu narubaitu turrü. Auqui aiñanaimia au manu cürrü nürirri Genesaret. ");
INSERT INTO caxNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tisuputaramati acamanu. Urapoimia au nanaiñantai manu cürrü ta iñataiti. Auqui macanama bama maunrrocono esati. ");
INSERT INTO caxNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ñanquitioma pünanaquiti Jesús nauqui aiñemantai nabeu naibirrti. Arrtü tiñentama, urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Auqui süromatü esati Jesús manuma fariseorrü y manuma maestro ümo nüriacarrü. Arrüma cuamatü auqui manu pueblurrü nürirri Jerusalén, nauqui anquirioma pünanaquiti, namatü sane: ");
INSERT INTO caxNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Causane arrübama anunecasa chicocotapüma arrüna ñanunecacarrüma bama antiburrü tücañe? Arrüma champürrtü entunumioma primero nauqui aama. ");
INSERT INTO caxNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Auqui ñanquitioti pünanaquimia nanti sane: —Arraño ito, ¿causane chapicocotapü arrüna yacüpucurrti Tuparrü, itopiqui arrüna napacüpucuatai? ");
INSERT INTO caxNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Arrti Tuparrü nanti: “Tari ane nanauncu ümoti aüma y ümo ito napacüma. Arrti naqui manitana churriampü ümoti yaütoti o ümo nipiacütoti, tari comati”. ");
INSERT INTO caxNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tapü arraño amucanaño, que puerurrü amucanaño ümoti aubaü y ümo naupacü arrüna sane: “No, arrüñü chüpuerurrüpü rrayura aume, itopiqui enterurrü arrüba niñenarri chauqui titorrimiaquio ümoti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Arrtü ananti naqui nanti sane, chauqui champü nümochequi ayurati ümoti yaütoti y ümo nipiacütoti. Ui arrüna sane aboi apiñocota yacüpucurrti Tuparrü yucuata arrüba napacüpucuatoe. ");
INSERT INTO caxNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Mañapanca año! Ñemanauncurratoe nurarrti profetarrü Isaías tücañe nauquiche maconomonoti sane aucütüpü: ");
INSERT INTO caxNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Arrübama macrirrtianuca ui narurrümantai iñanaunumañü —nanti Tuparrü—, pero au nitusirrimia ta champürrtü icocoromañü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Umonatai arrtü cuamatü aiñanaunumañü y achesoimia yesañü, itopiqui arrümanu ñanunecacarrüma, ta yacüpucu bama mañoñüncatai. ");
INSERT INTO caxNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Auqui tasuruma macrirrtianuca uiti Jesús y nanti ümoma: —¡Amonsapesio y tari entienderrü año ümo arrüna nisura! ");
INSERT INTO caxNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Champüti naqui ane nomünantü uiti au narrtarrti Tuparrü auqui naca arrüna iñatenti, ta ui arrüna churriampü ñanitatenti. ");
INSERT INTO caxNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Auqui arrümanuma ñanunecasarrti Jesús süromatü esati y namatü ümoti: —¿Tusio aemo que arrübama fariseorrü ünantü ümoma arrüna ucanü? ");
INSERT INTO caxNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aiñumuti Jesús nurarrüma ui machepecatarrü, nanti sane: —Cualquierarrü arrüna plantarrü chüsürocütupü uiti Iyaü naqui anati au napese, tiene que aquiyaü aübu nanaiña nirranacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Asioma sane bama fariseorrü. Arrüma tacana bama supuso, pero ta ipiasurumati naqui quiatarrü supuso. Arrtü anati taman supuso naqui ipiasurutiti quiatarrü supuso, arrümanuma torrü tiene que apaquimia au taman cütubirri. (Machepecatarrü arrüna sane.) ");
INSERT INTO caxNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Auqui arrti Pedro nanti ümoti Jesús: —Urasoi suisucarü isane nümoche arrüna machepecatarrrü apü nusura. ");
INSERT INTO caxNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aiñumuti Jesús, nanti sane: —¿Arraño ito chütusiopü aume arrüna sane? ");
INSERT INTO caxNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Unca amarrtaimo que arrüna umate sürotü ocübobi au nuñaunso. Auqui pasao pürücü, barutaübu tatito tanene. ");
INSERT INTO caxNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero auqui nuyausasü cuantio arrüba chomirriampü numapensaca. ");
INSERT INTO caxNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mapensaca batabai, urrianca ümo quiatarrü paürrü, baviviquia tacana numuquianca, bacusüpüca, mapanca y macuentuca icütüpüti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Enterurrü arrüba numapensaca sane pururrü nomünantü. Tapü arrüna arrtü chuicocotapü oñentunumi primero arrtü oecatü uba, ta champü nomünantü uirri. ");
INSERT INTO caxNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Auqui sürotitü Jesús auquimanu. Sürotitü au manu cürrü saimia manio puebluca nürirri Tiro y Sidón. ");
INSERT INTO caxNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Taman paürrü cananearrü ananca pohoso acamanu. Cuatü esati Jesús nitosibirri, nantü ümoti sane: —¡Señor, naü nüriaburrü David, apucüru ichacuñü! Nicheche ane choborese ahu. Tarucapae nitaquisürücürrü uirri. ");
INSERT INTO caxNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Arrti Jesús champürrtü iñumutati manu nurarrü. Auqui arrübama ñanunecasarrti namatü ümoti: —¡Aicüpu tato manu paürrü, tübatatai suiñemo nitosibirri! ");
INSERT INTO caxNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Auqui arrti Jesús nanti ümo: —Arrti Tuparrü icüpurutiñü esa bamantai israelitarrü, nauqui rrayura ümoma. Arrüma aboma tacana arrobe nobirraca omensoro. Tapü arrücü chütüpü israelitarrücü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Arrümanu paürrü bachesoiyo esati Jesús y nantü ümoti: —¡Señor, ayurasañü! ");
INSERT INTO caxNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Auqui iñumutati Jesús ui machepecatarrü, nanti ümo: —Champürrtü urria arrtü uiquiaübuta niyarata bama masiomanca, nauqui uitorrimia ñome tamococa. (Ta arrübama isralitarrü tonema bama tacana aübosirrti Tuparrü.) ");
INSERT INTO caxNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Arrümanu paürrü iñumuta, nantü sane: —Ñemanauntu Señor, arrüba tamocomanca bubaso ito arrüba niyupaquituca icuqui mensarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Auqui nanti Jesús ümo: —¡Paürrü, aicococañü nurria! Isamunena isiu arrüna narrianca. Au manu rratorrü urriante tato manu nichechese. ");
INSERT INTO caxNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Auqui arrti Jesús sürotitü auquimanu. Pasaoti abeuqui manu narubaitu turrü ane au Galilea. Auqui sürotitü onü taman yiriturrü, atümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Cütüpürrü macrirrtianuca iñataimia acamanu esati. Cuamatü uimia arrübama rrenco, arrübama supuso, arrübama chüpuerurrüpü anitama. Cuamatü ito uimia sürümanama bama maquiataca maunrrocono. Iñanama esati Jesús y arrti bacurarati ümoma. Urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Arrümanuma macrirrtianuca cütobüsoma ui arrüna arrtaimia: Arrübama chüpuerurrüpü anitama, manitanama tato. Arrübama rrenco urrian tato namensüma. Arrübama supuso, asarama tato uiti. Sane nauquiche iñanaunumati Tuparrü, naqui Tuparrü ümo bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Auqui arrti Jesús batasuruti ümo bama ñanunecasarrti y nanti ümoma: —Taquisürümantai iñemo bama macrirrtianuca, itopiqui chauqui tütabe trerrü naneneca nacarrüma auna ichepeñü y champü isane utuburiboma. Chirrancapü icüpuruma tato au niporrüma aübu nicürüpürrüma. Rrepente chücusüurupüma isiu cutubiurrü ui nicürüpürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Auqui namatü ümoti bama ñanunecasarrti: —¿Causanempü nauqui atabü osoi tuburibo na cütüpürrü genterrü? Champü poca auna saimia. ");
INSERT INTO caxNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ñanquitioti Jesús pünanaquimia: —¿Mantucubo pan abe aboi? Arrüma namatü: —Abe siete pan y mümanantai nopiocomanca. ");
INSERT INTO caxNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Auqui bacüpuruti Jesús ümo macrirrtianuca nauqui atümoma acü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Auqui iquianiontiño mecuti manio siete pan y arrümanio nopiocomanca. Machampiencanati ümoti Tuparrü, bochepesüro uiti, itorrimianiontiño ümo manuma ñanunecasarrti, nauqui rrepartibo uimia ümo namanaiña macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Enterurrü macrirrtianuca basoma, bien abecoma. Ubataso tato siete noconoca ui bama ñanunecasarrti, pururrü nisobüraturrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nubiqui manuma basoma cuatro mil mañoñüncatai, chümupacünuncunupü paüca ni masiomancapü. ");
INSERT INTO caxNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Auqui arrti Jesús masamunuti nariorrü ümo macrirrtianuca. Süroti au taman barco ichepe bama ñanunecasarrti y süromatü au manu cürrü nürirri Magdala. ");
INSERT INTO caxNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Arrümanuma fariseorrü ichepe manuma saduceorrü yebomatü esati Jesús nauqui aiñama macocotorrü ümoti. Ñanquitioma pünanaquiti nauqui aitusiancati taman señarrü isucarüma nauqui atusi ümoma ta uiti Tuparrü atorri üriacaboti. ");
INSERT INTO caxNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aiñumuti Jesús nurarrüma: —Arrtü amarrtai cüturiqui napese isiu nimümürrü, amucanaño: “Canapae urria napese tubaca”. ");
INSERT INTO caxNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Arrtü tansürü amarrtai napese cüsaüboca, amucanaño: “Rrobeoca caüma”. ¡Mañapanca! Arraño bien tusio aume arrüna ümoche cütüriqui napese, ta tone señarrü arrtü rrobeoca o arrtü urria napese. ¿Causane chütusiopü aume ümoche nanaiña arrüba milagrorrü omirriante sobi? ");
INSERT INTO caxNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Arraño macrirrtianuca caüma apanquiquia nauqui itusianca señarrü ausucarü. Abu tarucu naumaloco. Apiñococati Tuparrü. Chüpuerurrüpü itusianca señarrü ausucarü. Cunauntaiñatai arrüna sane surapoi ausucarü: Apaquionsaño iyoti profetarrü Jonás y arrüna pasabo ümoti. Tone caüma señarrü aume. Sane nurarrti Jesús isucarüma. Auqui süroti tato auquimanu. ");
INSERT INTO caxNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Süromatü topü manu narubaitu turrü. Arrübama ñanunecasarrti Jesús tacürusu ñaquioncorrüma acama pan itapiquiboma. ");
INSERT INTO caxNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Auqui nanti Jesús ümoma: —¡Amasasai nurria ñünana nesarrüma levadura bama fariseorrü ichepe bama saduceorrü! ");
INSERT INTO caxNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Arrüma namatü ümomantoe: —Canapae nanti sane, itopiqui na chumacacapü one pan. ");
INSERT INTO caxNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Arrti Jesús tütusiatai ümoti arrümanu nurarrüma, nanti ümoma: —¿Causane ane penarrü aboi itopiqui champü pan aboi? Arraño chapicococapüñü nurria. ");
INSERT INTO caxNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Champürrtü entienderrü año pario ümo arrüna sane? ¿Causane chapaquioncañopü arrone yasapacama bama cinco mil mañoñünca oboi cincoatai pan? Tantorrü noconoca ubataso tato aboi ui pururrü nisobüraturrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chapaquioncañopito arrone yasapacama cuatro mil macrirrtianuca oboi sieteatai pan. Mantucubatai noconoca ubataso tato oboi nisobüraturrüma? ");
INSERT INTO caxNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chütusiopü aume ümoche arrüna nirranitaca? Champürrtü rranitaca iyo levadura ümo pan. ");
INSERT INTO caxNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sane nauquiche caüma entienderrüma bama ñanunecasarrti arrüna nurarrti ümoma. Abu ta champürrtü manitanati ümo levadura ümo pan. Ta urapoiti isucarüma, tapü icocotama ñanunecacarrüma bama fariseorrü y bama saduceorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Isiu namenrrüma iñataimia saimia manu pueblurrü nürirri Cesarea de Filipo. Acamanu arrti Jesús ñanquitioti pünanaqui bama ñanunecasarrti, nanti ümoma: —¿Uramapü sane iñemo macrirrtianuca arrüñü Ñemanauncurratoe Ñoñünrrü? ");
INSERT INTO caxNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Auqui aiñumuma bama ñanunecasarrti, namatü sane: —Aboma bama namatü que arrücü Juan Bautista. Maquiataca namatü que arrücü Elías. Maquiataca namatü ito que arrücü Jeremías o arrti quiatarrü profetarrü auqui tücañe, naqui süborico tato. ");
INSERT INTO caxNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Auqui nanti Jesús ümoma: —Y carü arraño, ¿aburaño sane iñemo? ");
INSERT INTO caxNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Auqui aiñumuti Simón Pedro, nanti: —Arrücü Cristocü naqui Aütorrti Tuparrü, naqui süborico. ");
INSERT INTO caxNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Auqui nanti Jesús ümoti: —Arrücü Simón Pedro, aütorrti Jonás. Urriampae naca itopiqui champüti ñoñünrrü naqui uiche atusi aemo arrüna sane, ta uiti Tuparrü naqui Iyaü naqui anati au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Arrüna nüri Pedro, nantü auqui besüro “Canrrü”. Arrübama icocoromañü ñana tacana arrone porrü urriante onü canrrü, arrüna chüpuerurrüpü apoco. Ni arrünampü concorrü puerurrü acana ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tiene que itorrimianio aemo niyabe arrüna cauta ane nüriacarrti Tuparrü. Arrüna urria aemo icu na cürrü, urria ito au napese. Arrüna churriampü aemo icu na cürrü, churriampito au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Auqui arrti Jesús nanti ümo bama ñanunecasarrti: —Tapü aburapoi isucarüti quiatarrü arrüna tusio aume, ta arrüñü Cristoñü. ");
INSERT INTO caxNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sane nauquiche arrti Jesús comensaboti uraboiti nurria isucarü bama ñanunecasarrti, arrüna pasabobo ümoti. Nanti: —Tiene que yerotü au Jerusalén. Taha tiene que ichaquisürü ui bama mamayoreca, mayüriabuca ichepe bama üriatu bama sacerdoterrü y ui bama manunecana nüriacarrü. Itabairomañü, pero pürücü ba trerrü naneneca tiene que isübori tato. ");
INSERT INTO caxNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Auqui arrti Pedro iquianatiti Jesús peese, aicuansomoconotiti: —Tapü apensaca sane, Señor, tapü pasao aemo arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Auqui arrti Jesús apebüti tato nurria ui manu nurarrti Pedro ümoti, nanti ümoti: —Aquicho auquina yasaquiñü, arrücü choborese. Arrücü aiñata macocotorrü iñemo. Napensaca champürrtü tacana ñapensacarrti Tuparrü, ta tacana ñapensaca macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Auqui nanti Jesús ümo bama ñanunecasarrti: —Arrtü anati naqui rranrrü ayetitü isiuñü, tari taquisürübati isiuquiñü, tari tacürusu ñaquioncorrti iyotiatoe, tacanarrtü chüvaleopü nisüboriquirrti ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Arrti naqui rranrrü ataesübu ñünana concorrü auna icu na cürrü, pero ta chüpuerurrüpü aye uiti au napese ümo para siemprerrü. Arrti naqui coiñoti auqui niyaca, süboricoti au napese ümo para siemprerrü. ");
INSERT INTO caxNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Champü niyaserebiquirri ümoti ñoñünrrü acananenti nanaiña arrüba abe icu na cürrü, arrtü au nitacürurrü peneco nausüpürrti, itopiqui tarucu nicua nuyausüpü. Champü aye uirri tacana nicuarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Arrüñü Ñemanauncurratoe Ñoñünrrü. Iseca tato ñana auqui napese aübu nanaiña nanentacarrü esaquiti Tuparrü naqui Iyaü. Isecatü ichepe bama angelerrü bama baserebio iñemo. Auqui caüma rrapacaca ümo namanaiña macrirrtianuca itobo arrüba isamutema icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ñemanauncurratoe sucanañü aume: Aboma auna uyarrüpecu bama chüpuerurrüpü acoma cheperrtü arrtaimia nisequi tato aübu nanaiña nisüriaca. ");
INSERT INTO caxNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bupasao manio seirri naneneca. Auqui sürotitü Jesús onü manu yiriturrü bien apetaisürü. Süromatü uiti arrti Pedro, arrti Jacobo y arrti Juan yaruquitorrti Jacobo. ");
INSERT INTO caxNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nauquiche taboma onü manu yiriturrü, arrti Jesús campiabo nacarrti isucarüma. Nisurrti bien cuaratai tacana nicua surrü y naibirrti champü tacanache nipurusubiquirri y bucuara ito. ");
INSERT INTO caxNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Au manu rratorrü itusiancanamacü arrti Moisés ichepeti Elías. Aboma baparioma aübuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Auqui nanti Pedro ümoti Jesús: —Señor, bien urria nusaca auna. Arrtü arrianca supasamuna trerrü cüpahumanca: Taman aemo, quiatarrü ümoti Moisés y quiatarrü ümoti Elías. ");
INSERT INTO caxNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nauquiche anancatiqui Pedro manitanati ümoti Jesús, au manu rratorrü cuatü cüsaüborrü arrone cuara nurria oñüma. Auqui rabotü manitacarrü eanaqui, nantü sane: —Tonenti naqui Isaü naqui tarucu nicuarrti iñemo, ipucünuncatai icuatati. ¡Amonsoi nurria nurarrti! ");
INSERT INTO caxNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Arrübama ñanunecasarrti Jesús, numo oncoimia arrüna manitacarrü, bachesoiyoma y mataconoconoma, iñatai nisurrüma acü ui nirrucurrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Au manu rratorrü cuati Jesús esama aiñenti neherrüma, nanti ümoma: —¡Apatüsai, tapü aupirruca! ");
INSERT INTO caxNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nauquiche asarama tato nurria manuma ñanunecasarrti, champümainqui manuma torrü y champüquito manu cüsaüborrü, arrtiatai Jesús anancatiqui acamanu. ");
INSERT INTO caxNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Auqui süroma tato onüqui manu yiriturrü, niyücürrüma cümama. Nanti Jesús ümoma: —¡Tapü aburapoi isucarü maquiataca arrüna amarrtai, cheperrtü isüboriquia tato eanaqui macoiñoca! ");
INSERT INTO caxNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Auqui ñanquitioma pünanaquiti, namatü: —¿Causane arrübama manunecana ümo nüriacarrü namatü que tiene que ayeti acusürüti Elías apünanaquicü? ");
INSERT INTO caxNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aiñumuti Jesús, nanti: —Bien ñemanauntu te arrti Elías cuati acusürüti nauqui aicoñocoti tato arrüba churriampü nisüboriquirrimia bama macrirrtianuca icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sucanañü aume, ta arrti Elías chauqui tanancati auna icu na cürrü. Pero arrübama macrirrtianuca champürrtü isuputaramati. Isamutema aübuti isiu arrüna nirrancarrüma. Sane ito isamutema ñana saübuñü, arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ichaquisürü ui bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tütusiatai ümoma que arrti Jesús manitananti apüti Juan Bautista. ");
INSERT INTO caxNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nauquiche iñataimia tato auna cauta aboma macrirrtianuca, tamanti ñoñünrrü cuati esati Jesús. Bachesoiyoti esati y nanti ümoti: ");
INSERT INTO caxNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—¡Señor, apucüru itacuti isaü! Chaübopü ñaunrrococorrti. Tarucapae nitaquisürücürrti uirri. Ane nauche tasurerecoti y taübücoti oto pese y eana turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chauqui tiquiacati taha esa bama anunecasa, pero arrüma chüpuerurrüpü acurama ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Auqui arrti Jesús nanti ümoma: —Arraño caümainqui chapicococapüñü y tarucu nomünantü aboi. Abu tücoboi niyaca abarrüpecu. ¿Hasta auche ñana tiene que ñasamunca abaübu? ¡Apiquiataunarrti maniqui ñaüma! Auqui cuati maniqui ñaüma uimia esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Arrti icuansomoconotiti maniqui choborese anati auti, icüpurutiti tanene auquiti. Arrti maniqui choborese sürotitü auquiti maniqui ñaüma. Sane nauquiche urriancati tato au manu rratorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Auqui arrübama ñanunecasarrti süromatü peese aübuti Jesús anquirioma pünanaquiti arrüna sane, namatü: —¿Causanempü chüpuerurrüpü somü sopicüpüruti maniqui choborese auquiti maniqui ñaüma? ");
INSERT INTO caxNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nanti Jesús ümoma: —Itopiqui champürrtü apicococañü nurria. Ñemanauncurratoe sucanañü aume: Arrtü apicococañü pario, entonces puerurrü amucanaño ümo na yiriturrü: “Acosi auquina au quiatarrü narücüquirri”. Auqui arrüna yiriturrü sürotü auquina. Champü cuestarabo aume arrtü apicococañü nurria. ");
INSERT INTO caxNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero arrti naqui choborese sane chüpuerurrüpü uicüpuruti tanene auqui macrirrtianuca arrtü choñeancapü, y arrtü chayunabopü oñü, chubacapü ui numaquionco iyoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nauquiche anancatiqui Jesús ichepe bama ñanunecasarrti au manu cürrü Galilea, nanti ümoma: —Arrüñü Ñemanauncurratoe Ñoñünrrü, tiene que aitorrimianamañü mecu bama mayüriabuca. ");
INSERT INTO caxNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Itabairomañü. Pero ta yopürücü manio trerrü naneneca isüboriquia tato. Ui arrüna sane nurarrti Jesús tarucu nisuchequirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iñataimia au manu pueblurrü nürirri Capernaum. Aboma ito acamanu bama bacobürara impuestorrü ümo niporrti Tuparrü. Cuamatü esati Pedro, anquirioma pünanaquiti, namatü: —¿Carüti maniqui aubesa maestro, aensapü bapacarati impuestorrü ümo niporrti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aiñumuti Pedro: —Bapacarati. Auqui aürotitüpo Pedro au manu porrü cauta anancati Jesús. Arrti Jesús cusürüboti anitati ümoti Pedro, nanti: —¿Uracü sane Simón? ¿Pünanaquiche acobürama impuestorrü bama mayüriabuca? ¿Taqui pünanaqui bama pohoso, o pünanaqui bama extranjerurrü? ");
INSERT INTO caxNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Auqui aiñumuti Pedro, nanti: —Pünanaqui bama extranjerurrü. Nanti Jesús: —Entonces arrübama pohoso chübapacarapüma. ");
INSERT INTO caxNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero tapü anati naqui tüborico oemo, mejor acosi aha. Arrtü ane na nopiocorrü itononü, aiquiaübu y aiyaübu narurrü. Acamanu ahi tabüco obi taman monedarrü. Aiquiaübu ahiqui y uirri apacase noesa impuestorrü ümo niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Au manu tiemporrü tücañe arrümanuma ñanunecasarrti Jesús süromatü esati nauqui anquirioma pünanaquiti, namatü: —¿Ñacuti subarrüpecuqui naqui ane manrrü nüriacarrti arrtü üriabucati Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Auqui arrti Jesús itasurutiti taman ñaüma isucarüma, iñanatiti cümuinta auna cauta amoncoma. ");
INSERT INTO caxNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Auqui nanti ümoma: —Ñemanauncurratoe sucanañü aume: Arrtü chücampiabopü napapensaca tacana ñapensacarrti naqui ñaüma, chüpuerurrüpü aye aboi auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sane nauquiche arrti naqui ichimiancanatiyü tacana bama masiomanca, tonenti ane manrrü nüriacarrti auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Arrti naqui yasuriurutiti taman ñaüma au nisüri, yasurirurutiñü ito. ");
INSERT INTO caxNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‛Arrtü anati naqui iñata macocotorrü ümo bama icocoromañü nauqui tapü icocoromañünqui, manrrüpü urria arrtü tomoeno sürümanarrü canrrü itüti, nauqui botaboti aübu au narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pobrerrümantai bama icu na cürrü oboi ba macocotoca uiche aisamunema nomünantü. Pobrerrtiatai naqui ñoñünrrü uiche aiñanti ba macocotoca. ");
INSERT INTO caxNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sane nauquiche arrtü nehe o napope arrüna uiche aisamute nomünantü, mejor aitüsünasio y arusiompü. Manrrü urria arrtü asüboriquia esati Tuparrü aübu tamantai nehe o tamantai napope. Tapü aichücü aürotü au infierno oto pese oboi manio nehe o napope. ");
INSERT INTO caxNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tapürrtü atapeneca au nomünantü ui nasüto mejor aiquiaübu y arusaübu. Itopiqui manrrü urria arrtü aücatü esati Tuparrü aübu tamantai nasüto, pünanaquirrtü aecatü au infierno oto pese yupu manio torrücaü nasüto. ");
INSERT INTO caxNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nantito Jesús: —Tapü chücuasürüpüma aume bama masiomanca icocoromañü. Arrübama angelerrü bacuirara itacuma, nantarrtai aboma esati Tuparrü au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Arrüñü Ñemanauncurratoe Ñoñünrrü isecatü icu na cürrü, nauqui ñataisümunucu eanaqui nomünantü ümo bama iñoconomati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Amonsoi arrüna machepecatarrü: Supiarrtü anati naqui taman ñoñünrrü abe cien niyaburrti nobirraca. Taman omeanaqui ensoro. ¿Acaso chomonconopü uiti manio noventa y nueve eana rroense na ariorrti apacherioti manu taman ensoro omeana yirituca? ");
INSERT INTO caxNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Arrtü tabüco uiti, manrrü nipucünuncurrti pünanaqui yucuata manio amonquiatai. ");
INSERT INTO caxNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sane ito arrti Iyaü naqui anati au napese, chirranrrtipü nauqui anati naqui sürotü au infierno eanaqui bama masiomanca icocoromañü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nantito Jesús: —Arrtü arrti taman aruqui ane causane uiti aemo, aitasurrti peese. Apari nurria aübuti y urasoi isucarüti arrüna churriampü uiti aemo. Arrtü oncoiti arrüna nura, urrian tato naca aübuti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tapürrtü chirranrrtipü oncoiti nura, apari tatito aübuti aübu bama maquiataca bama asaramatü causane uiti aemo, na atusi nurria nipünatenti. Rrepente auquiapae yasutiuti nura maniqui aruqui. ");
INSERT INTO caxNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Arrtü chirranrrtipü oncoiti, urasoi isucarü namanaiña bama icocoromati Tuparrü. Arrtü chirranrrtipü oncoiti nurarrüma, auqui caüma aiñasü peese pünanaquiti tacana pünanaqui bama chicocoromatipü Tuparrü y bama mayacobraca impuestorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‛Ñemanauncurratoe sucanañü aume: Arrüna napacüpücu auna icu na cürrü, valeo ito au napese. Arrüna chichebopü aboi auna icu na cürrü, au napese isiatai chichebopito. ");
INSERT INTO caxNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‛Sucanañü ito aume: Arrtü aboma torrüma mañoñünca icu na cürrü chepatai ñapensacarrüma nauqui anquimia arrüna nirrantümoma pünanaquiti Iyaü au napese, arrti caüma macumananati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Itopiqui auna cauta aboma torrü o trerrüma iyoberabaramacü au nisüri, arrüñü yaca acamanu eanama. ");
INSERT INTO caxNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Auqui arrti Pedro sürotitü esati Jesús, ñanquirioti pünanaquiti: —Señor, ¿mantucubu veserrü tiene que irrimiaca tato nomünantü ümoti saruqui? ¿Taqui siete veserrü? ");
INSERT INTO caxNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aiñumuti Jesús, nanti sane: —Champürrtü sieteatai veserrü. Ta sucanañü aemo: Hasta setenta veserrü siete narrimiacaca tato ümoti aruqui. ");
INSERT INTO caxNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‛Arrünarrtü üriabucati Tuparrü pasao uiti tacana uiti taman yüriaburrü naqui rranrrü acurrta aübu bama imostoti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tanati bacurrtarati. Cuati acamanu esati arrti maniqui taman mosorrü, naqui tarucapae nebequirrti ümoti, sürümana millonerrü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Arrti maniqui mosorrü champü uiche apacanenti manu nebequirrti. Sane nauquiche arrti maniqui yüriaburrü bacüpuruti nauqui apaventeti aübu nanaiña nicüpostoti, nenarrirrti y namanaiña bama aütorrti nauqui puerurrü apacanenti manu nebequirrti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Auqui arrti maniqui mosorrü bachesoiyoti nurria esati manqui yüriaburrü, nanti ümoti sane: “Señor, apucüru ichacuñü. Tapü apuraurrücüapae acobrarañü. Tiene que rrapacane nanaiña manu nirrebequi aemo”. ");
INSERT INTO caxNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sane nauquiche arrti maniqui yüriaburrü pucürusuti itacuti, perdonabo uiti manu nebequirrti. Champürrtü ananto acobraratiti. Emecanantito uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero arrti maniqui mosorrü nauquiche tanati tato türüpo, icuñunutiti maniqui quiatarrü mosorrü icumpañeruturrti, naqui ebeoti chimiantai ümoti. Iñenotiti auqui nitapeurrti, itumenotiti, tüsaipü aconti uiti. Auqui nanti ümoti: “¡Apaca iñemo arrone nebequi!” ");
INSERT INTO caxNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Auqui arrti maniqui icumpañeruturrti bachesoiyoti esati. Nanti ümoti: “¡Apucürü ichacuñü, tapü apuraurrücüapae acobrarañü, tiene que te rrapacane nanaiña nirrebequi aemo!” ");
INSERT INTO caxNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero arrti champürrtü pucürusuti itacuti. Más bien sürotitü aiñanatiti au preso, cheperrtü bapacarati ümoti arrümanu nebequirriti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nauquiche arrtaimia manuma maquiataca mamosoca, orronene nurria ümoma. Aüromatü uraboimia isucarüti maniqui yüriaburrü nanaiña arrüna pasabo uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nauquiche tütusio ümoti, maemencoti iyoti maniqui mosorrü. Nauquiche tanati acamanu esati, nanti ümoti: “Arrücü mosorrü malorrü. Aucutanu ataquisürücatai iñemo. Sane nauquiche chirracobracapü arrümanu tarucu nebequi iñemo, itopiqui achesoiquia nurria yesañü. ");
INSERT INTO caxNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Isiupücü tiene que ataquisürüti aemo maniqui acumpañeru tacana arrüna nataquisürücü iñemo”. ");
INSERT INTO caxNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sane nauquiche bien tüboricoti maniqui yüriaburrü ümoti. Bacüpuruti nauqui carrtigaboti nurria cheperrtü bapacarati nanaiña arrümanu tarucapae nebequirrti. ");
INSERT INTO caxNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Auqui nantito Jesús: —Sane ito isamutenti Iyaü au napese abaübu, arrtü chirrimiacanapü aboi nomünantü ümoti quiatarrü aübu nanaiña nabausasü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nauquiche tüchauqui nurarrti Jesús arrüna sane, sürotito auqui Galilea, niyücürrti au manu cürrü nürirri Judea, topü manu sapoco nürirri Jordán. ");
INSERT INTO caxNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cütüpürrü macrirrtianuca süromatü isiuti. Taha urriancama tato uiti sürümanama bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Acamanu aboma bama fariseorrü. Uturuquimia süromatü esati Jesús nauqui aiñama metorrü ümoti. Ñanquitioma pünanaquiti, namatü: —¿Aensapü puerurrü sopiñoconio suisüposütaiqui, arrtü ane pario na itopiquiche? ");
INSERT INTO caxNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aiñumuti Jesús, nanti ümoma: —Tusiatai aume ane corobo sane: “Auqui maübo arrti Tuparrü isamunutiti taman ñoñünrrü ichepe taman paürrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Auqui nanti Tuparrü: “Sane nauquiche arrti yaürrü iñoconotiti yaütoti y nipiacütoti nauqui aürotitü ichepe nicüpostoti. Sane nauquiche caüma tacanarrtü tamantai nacarrüma”. ");
INSERT INTO caxNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Champürrtü torrümainqui, tamantai au narrtarrti Tuparrü. Sane nauquiche churriampü aiñoconomacü arrübama tüposo. ");
INSERT INTO caxNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Auqui arrümanuma fariseorrü ñanquitioma tatito pünanaquiti Jesús: —¿Causanempü acüputi Moisés tücañe nauqui atorri ñome paüca taman nicororrü arrüna uiche atusi ta champürrtü abiqui isiuti naqui nopiquianio? ");
INSERT INTO caxNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aiñumuti Jesús, nanti: —Torrio te uiti Moisés nauqui apiñoconio naucüposütaiqui itopiqui tarucu nomünantü aboi. Pero arrüna nirrancarrti Tuparrü auqui maübo ta champürrtü sane. ");
INSERT INTO caxNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sucanañü aume que arrti naqui iñococotati nicüpostoti, arrüna champü causane nisüborirquirri aübuti quiatarrü, y posoti aübu quiatarrü paürrü, chauqui tisamutenti nomünantü. Arrti naqui poso aübu taman paürrü arrüna oncono uiti iquiana, chauqui ito tisamutenti nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Auqui arrübama ñanunecasarrti Jesús namatü ümoti: —Arrtü sane, manrrü urria chopocapü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Auqui nanti Jesús ümoma: —Chüpuerurrüpü namanaiña atusi ümoma arrüna ñapanauncurrti Tuparrü. Cunauntaña bama torrio ümoma na atusi ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sürümanatai arrüna itopiquiche chüposotipü ñoñünrrü: Aboma bama chüposopüma itopiqui auquiapae mamesoma. Aboma chüposopüma itopiqui tübioma. Aboma ito bama chüposopüma itopiqui rranrrüma aserebimia ümoti Tuparrü. Arrti naqui puerurrü asuriuti arrüna sane, tari yasuriurati. ");
INSERT INTO caxNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Acamanu ito macanama masiomanca esati Jesús, nauqui aiñanti neherrti onüma, y nauqui eanti itacuma. Tapü arrübama ñanunecasarrti icuansomoconoma manuma uiche ayematü manuma masiomanca. ");
INSERT INTO caxNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Arrti Jesús nanti ümo manuma ñanunecasarrti: —Asioma sane, tari yebamatü tauna yesañü manuma masiomanca, tapü abasiquia icuatama. Auna cauta üriabucati Tuparrü cuasürüma bama tacana naca bama masiomanca. ");
INSERT INTO caxNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Auqui iñatati neherrti ita manuma masiomanca, ñacunusüancacarrti ümoma. Auqui caüma sürotitito auqui manu. ");
INSERT INTO caxNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Taman nanenese, arrti maniqui taman yaürrü sürotitü esati Jesús nauqui anquirioti pünanaquiti, nanti sane: —Buen Maestro, irranca rranquirio apünanaquicü: ¿Isane arrüna urria isamune nauqui aye sobi nisüboriqui esati Bae Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aiñumuti Jesús, nanti sane ümoti: —¿Causane ucanü iñemo buenurrüñü? Tamantiatai Tuparrü naqui anati au napese naqui buenurrü. Arrtü arrianca aye obi au napese esati Tuparrü, aicocosio arrüba yacüpucurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Auqui nanti maniqui yaürrü ümoti: —¿Ñacusabe arrüba yacüpucurrti Tuparrü? Aiñumuti Jesús: —Tapü atabaiquia, tapü arrianca ümo quiatarrü paürrü, tapü acusüpüca, tapü apanca apüti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Anaun ümoti aüma y ümo napacüma. Tari cuasürüti aemo asüborisapa tacana nacua aemoantoe. ");
INSERT INTO caxNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aiñumuti maniqui yaürrü, nanti: —Enterurrü arrüba bacüpucuca icocoquio auqui maübo nisunaun. ¿Isane manrrü arrüna faltabo iñemo? ");
INSERT INTO caxNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nanti Jesús ümoti: Arrtü arrianca bien urriampae nasüboriqui, acosi tato au napo y aipiaventecasio enterurrü arrüba abe obi. Aitorrimia nicuarrü ümo bama pobrerrü y ariacu isiuñü. Auqui caüma ane nacua au napese uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Arrti maniqui yaürrü oncoiti arrümanu nurarrti Jesús sane, süroti tato aübu tarucu nisuchequirrti, itopiqui arrti bien rricurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Auqui nanti Jesús ümo bama ñanunecasarrti: —Ñemanauncurratoe sucanañü aume: Cuestarrü ümoti taman rricurrü nauqui aye uiti auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Manrrü chücuestarrüpü ümo taman camello apasa auqui nirrto cümese. (Arrümanu numuquianrrü camello isiu nisunaun cabayurrü.) Arrti rricurrü cuestarrü aye uiti auna cauta ane nüriacarrti Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nauquiche oncoimia arrüna sane bama ñanunecasarrti Jesús, tarucu nicütobürrüma, namatü ümomantoe: —¿Quitimo naqui puerurrü aye uiti esati Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tapü arrti Jesús asaratitü ümoma, nanti: —Arrübama mañoñünca icuqui nantai cürrü chüpuerurrüpü aisamunema arrüna sane uirrimiantoe, pero arrti Bae Tuparrü puerurrti aisamunenti nanaiñantai. ");
INSERT INTO caxNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Auqui nanti Pedro ümoti Jesús: —Señor, arrüsomü sopiñocota nanaiña arrüna ane soboi, nauqui sobetü asiucü. ¿Isane arrüna iyebo ñana soboi auqui na subaca asiucü? ");
INSERT INTO caxNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aiñumuti Jesús: —Ñemanauncurrratoe sucanañü aume: Au manu tiemporrü ñana coñocono tato nanaiña arrüba omirriante uiti Tuparrü. Auqui caüma arrüñü Ñemanauncurratoe Ñoñünrrü ichümoca au niyesa tronorrü taha auna cauta üriabucati Iyaü. Tapü arraño bama nirranunecasa tiene que autümo ito ichepeñü esati Tuparrü au manio doce tronorrü, nauqui apacurrta ñome manio doce familiarrü auqui Israel. ");
INSERT INTO caxNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Arrübama iñocotama niporrüma, yaruquitorrüma, niquiasitorrüma, yaütorrüma, nipiacütorrüma, aütorrüma, nicüpostorrüma niyorrüma auqui niyaca, tiene que asuriuma cien veserrü manrrü. Tiene que ito aye uimia esati Tuparrü au napese auna cauta champü nitacüru nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sürümanama bama arucapae ümoma caüma, pero ñana tonema bama champü yaserebiquirrimia. Sürümanama ito bama champütiatai asaratü ümoma caüma, pero ñana tonema bama cusürübo aüromatü esati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nanti Jesús ümoma: —Arrtü üriabucati Tuparrü oemo, pasao tacana uiti taman patrón. Ane niyorrti bien arubaesa, ane uva cütu uiti. Taman nanenese tansürapae sürotitü apacheti bama trabajadorerrü ümoti nauqui atama nüta uva. ");
INSERT INTO caxNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nauquiche tütabücoma uiti, nanti ümoma: Rrapacaca aume taman denario au sapese. Auqui bacüpuruti ümoma au niyorrti nauqui atrabacama. Süromatü. ");
INSERT INTO caxNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Taqui a las nueve tansürü sürotitü au plaza, besüro narrtarrti ümo bama mañoñünca aboma acamanu champü yachücoimia. ");
INSERT INTO caxNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nanti ümoma: “Amecosi apatrabaca au niyo, apata nüta uva. Rrapacaca bien aume”. Auqui arrümanuma mañoñnca süromatito atrabacama ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tiñatai toce. Süroti tatito au plaza. Isamutenti tatito isiatai. Isiu nimümürrü taqui a las tres, isiatai tatito uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tütümümüca a las cinco, süroti tatito au plaza. Tabücoma uiti manuma mañoñünca aboma acamanu tümonsoma, champü yachücoimia. Nanti ümoma: “¿Causane chapatrabacacapü arrüna nanenese?” ");
INSERT INTO caxNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Auqui namatü ümoti: “Itopiqui champüti naqui iquianati somü supatrabaca”. Auqui nanti ümoma: “Amecosi au niyo apatrabaca. Rrapacaca bien aume”. ");
INSERT INTO caxNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nauquiche tütobiquia, nanti maniqui iyoche ümoti maniqui capatarrü: “Aiyoberabasama manuma trabajadorerrü y apaca ümoma. Cusürübo apaca ümo manuma aübapae aiñanaimia. Au nitacürurrü apaca ito ümo manuma amoncomantai auqui tansürü”. ");
INSERT INTO caxNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Auqui cuamatü manuma aüboqui aiñanaimia a las cinco isiu nimümürrü. Pagabo ümoma taman denario. ");
INSERT INTO caxNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Au nitacürurrü pucünuñama ito manuma tücoboi yatrabacacarrüma auqui tansürü, ñaquioncorrümampü pagabo ñana manrrü ümoma. Pero tamantai ito denario pagabo ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nauquiche tiyasutiuma manu pagorrü, uratoquioma ümoti maniqui iyoche. ");
INSERT INTO caxNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Namatü: “Arrübama aübapae aiñanaimia tamantai horarrü batrabacarama. Pero arrücü apacaca ümoma isiu nisubaiqui arrüna apacaca suiñemo. Abu arrüsomü enterurrü sapese supatrabacaca ümo nipequi surrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Auqui arrti maniqui iyoche nanti ümoti manqui taman: “Saruqui, champürrtü rrencañaca aemo. Ta tüsurapoi asucarücü que rrapacaca taman denario au sapese. ");
INSERT INTO caxNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nani arrüna nacanasa, acosi. Taiquiana urria aemo tanu. Arrüñü irranca rrapaca ümo bama aübatai atrabacama isiu tacana arrüna nirrapacaca aemo. ");
INSERT INTO caxNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Arrüñü isamute aübu nimoni isiu arrüna nirranca. ¿Taqui ünantü aemo arrüna tarucu nibeunucu?” ");
INSERT INTO caxNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sane te pasabo ñana: Arrübama champütiatai asaratü ümoma caüma, tonema bama cusürübo aüromatü ñana esati Tuparrü. Tapü arrübama arucapae ümoma caüma, tonema bama champü yaserebiquirrimia ñana. ");
INSERT INTO caxNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tanati Jesús isiu cutubiurrü, niyücürrti au Jerusalén. Auqui tasuruma peese uiti bama ñanunecasarrti. Nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Tusio aume que usaca noecü au Jerusalén. Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ichorri ümo bama üriatu sacerdoterrü y ümo bama manunecana nüriacarrü. Arrüma caüma namatü tiene que ison. ");
INSERT INTO caxNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tiene que ito aitorrimianamañü ümo bama extranjerurrü. Arrüma caüma emeonomañü, icübairomañü y icüramucunumañü apü curusürrü. Pero yopürücü trerrü naneneca tiene que isübori tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Au manu nanenese arrümanu nicüpostoti Zebedeo sürotü esati Jesús aübu bama torrü aürrü: Arrti Jacobo y arrti Juan. Bachesoiyo esati. ");
INSERT INTO caxNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Arrti Jesús ñanquitioti pünanaqui: —¿Isane narriantümo? Aiñumu manu paürrü: —Irranca nauqui aitümocoquio arrüba torrücaü nisaütaiqui apetacucü au napese arrtü üriabucü. Taman au nepanauncu nehe, quiatarrü au nepau nehe. ");
INSERT INTO caxNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aiñumuti Jesús: —Chütusiopü aemo isane arrüna anquitio. Auqui nanti ümoti Jacobo y ümoti Juan: —¿Aensapü puerurrü avantabo año ümo nautaquisürücü tacana arrücuatü taquisürücürrü cuabotiqui iñemo? Auqui iñumutama: —Puerurrü somü. ");
INSERT INTO caxNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Auqui nanti Jesús ümoma: —Ñemanauntu te autaquisürüca ñana tacana arrüna nichaquisürücü. Pero arrümanu naurriantümo nauqui autümo au nepanauncu y nepau niñe, canapae champü nisüriaca nauqui itorrimia aume. Arrtiatai Iyaü naqui puerurrü aitorrimiati ümo bama urria au ñaquioncorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Arrümanuma diez maquiataca ñanunecasarrti Jesús oncoimia arrüna sane. Tüboricoma ümoti Juan y ümoti Jacobo. ");
INSERT INTO caxNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Auqui tasuruma uiti Jesús namanaiña manuma ñanunecasarrti, nanti ümoma: —Arraño bien tusio aume arrüna sane. Arrübama ane nüriacarrüma icu na cürrü isamutema isiu nirrancarrüma, fuerte nurria yacüpucurrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero arraño tapü sane aboi aumeampatoe. Arrti naqui rranrrü ane manrrü nüriacarrti, tari yaserebirati ümo bama maquiataca, ");
INSERT INTO caxNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","tiene que aisamunutiyü tacana mosorrü ümo bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sane ito arrüñü Ñemanauncurratoe Ñoñünrrü champürrtü isecatü nauqui aserebimia iñemo. Ta isecatü nauqui yaserebi ümo bama macrirrtianuca y nauqui itorrimia nisüboriqui tacana bapacatarrü itobo nomünantü uimia. Sane nurarrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pasaoma auqui manu pueblurrü Jericó, niyücürrüma au Jeruslén. Cütüpürrü macrirrtianuca süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Acamanu isiu cutubiurrü aboma torrü mañoñünca tümonsoma, supusuma. Oncoimia que pasaoti Jesús auquimanu esaquimia. Tosibicoma, namatü: —¡Señor, arrücü eanaqui nesarrti familiarrü yüriaburrü David, apucüru suichacu! ");
INSERT INTO caxNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Auqui cuasoma ui manuma macrirrtianuca, na etayoimia. Pero arrüma manrrü nitosibirrimia: —¡Señor, arrücü eanaqui nesarrti familiarrü yüriaburrü David, apucürü suichacu! ");
INSERT INTO caxNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Auqui arrti Jesús tochencoti. Tasuruma uiti. Cuamatü esati. Nanti ümoma: —¿Isane naurriantümo? ");
INSERT INTO caxNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Arrüma iñumutama: —¡Señor, suirranca sumasara tato! ");
INSERT INTO caxNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Arrti Jesús pucürusuti itacuma. Iñentati nistorrüma. Au manu rratorrü asarama tato nurria. Auqui süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tütaboma saimia Jerusalén, iñataimia au manu pueblurrü nürirri Betfagé, cutaquiquibo manu yiriturrü nürirri Olivos. Auquimanu bacüpuruti Jesús ümo bama torrüma ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nanti ümoma: —Amecosi au ba ta poca abe taha ocümenu. Acamanu ane taman bururrü paüma, tomoeno aübu naübosimia esa. Apitaquisüna y apiquiasio tauna iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Arrtü anati naqui manitana aume, amucanaño ümoti sane: “Arrti Señor rranrrti ocupabo uiti”. Auqui caüma autorri aume. ");
INSERT INTO caxNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pasabo nanaiña arrüna sane, nauqui acoco arrümanu corobo tücañe uiti taman profetarrü. Nantü sane: ");
INSERT INTO caxNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Amucanaño ümo manuma pohoso au Sión: Amasasatü, arrti naqui yüriaburrü aume cuati aubesa tacanarrtü taquisürütiatai. Cuati chacu taman naübosi bururrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Auqui arrümanuma torrü ñanunecasarrti, isamutema isiu arrüna yacüpucurrti Jesús ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Cuatü uimia manu bururrü aübu naübosirri. Iñatama naibirrimia chacu manu naübosirri nauqui aüroti Jesús chacu. ");
INSERT INTO caxNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tarucapae nubiqui macrirrtianuca. Ipiacumainquiatama nicüburrirrimia isiu cutubiurrü cümenuti Jesús. Maquiataca maneonoma nasusüca, matüsünanama nasu mutacürrü, iñatama ito isiu cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Arrübama cusürübo y arrübama cuamatü isiuti Jesús, tosibicoma sane, namatü: —¡Gloria ümoti naqui yüriaburrü eanaqui nesarrti familiarrü David tücañe! ¡Curusüoti uiti Tuparrü naqui cuatü au nürirrti Señor! ¡Uiñanaunati Tuparrü au napese! ");
INSERT INTO caxNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nauquiche iñataiti Jesús au Jerusalén, enterurrü macrirrtianuca cütobüsoma. Aboma bama ñanquitioma: —¿Ñacutipü naqui ñoñünrrü? ");
INSERT INTO caxNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na arrümanuma macrirrtianuca cuamatü aübuti, namatü: —Tonenti naqui profetarrü Jesús auqui pueblurrü Nazaret, auqui manu cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Auqui arrti Jesús sürotipo au niporrti Tuparrü. Penecoma türüpo uiti manuma amoncoma acamanu mapaventecanama y macomporarama ausüratai. Ipemünacaniontiño nimesa bama macampiara monirri aübu macrirrtianuca y arrümanio nisiya bama mapaventecana nututaquiquia. ");
INSERT INTO caxNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nanti ümoma: —Nantü au Nicororrü sane: “Arrüna nipo urriante ümo meancarrü”. Pero arraño apiñata tacanarrtü nipo bama macusüpüca. ");
INSERT INTO caxNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Au manu niporrti Tuparrü cuamatü esati Jesús bama supusu y arrübama chüpuerurrüpü amema. Urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Arrümanuma üriatu sacerdoterrü ichepe manuma manunecana nüriacarrü arrtaimia arrümanio milagrorrü omirriante uiti Jesús. Oncoimia ito nitosibi masiomanca au niporrti Tuparrü, bama namatü sane: “¡Gloria ümoti aütorrti yüriaburrü David!” Sane nauquiche tüboricoma uirri. ");
INSERT INTO caxNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Namatü ümoti Jesús: —Onsoi arrürabotü ñanitacarrüma. Aiñumuti Jesús: —Ñoncoi. ¿Champümo tülehebo año arrüna nantü icu Nicororrü? Nantü sane: Obi te Tuparrü iñanaunumacü bama masiomanca, hasta arrübama aübo aboma icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Auqui onconoma macrirrtianuca uiti Jesús. Sürotitü au Betania. Acamanu barücüboti. ");
INSERT INTO caxNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tansürapae basücübücoti tato Jesús au Jerusalén. Isiu cutubiurrü cürüpüoti. ");
INSERT INTO caxNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Auqui asaratitü ümo taman suese higuera ane abeu cutubiurrü. Sürotitü esa, nirrancarrtipü atamünati nütarrü. Pero champüatai. Pururrtai nasurrü. Sane nauquiche nanti ümo: —¡Tari chanantopü ütaca tato! ");
INSERT INTO caxNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Au manu rratorrü süübu manu suese. Arrübama ñanunecasarrti nauquiche arrtaimia arrüna sane, cütobüsoma. Ñanquitioma pünanaquiti, namatü: —¿Causanemo contoapae tüsüübo manu suese higuera? ");
INSERT INTO caxNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aiñumuti Jesús: —Ñemanauncurratoe sucanañü aume: Arrtü bien amoncatü Tuparrü, arraño ito puerurrü apisamune arrüna sane, hasta manrrü. Puerurrü ito amucanaño ümo taman yiriturrü: “¡Aiquiaübusü auquina, acosi au narubaitu turrü!” Arrümanu yiriturrü sürotü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Enterurrü apanquiquia au napeanca y arrtü bien amoncatü ümoti Tuparrü, torrio aume. ");
INSERT INTO caxNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Auqui iñataimia au Jerusalén. Sürotipo Jesús au niporrti Tuparrü. Acamanupo manunecanati ümo macrirrtianuca. Auqui cuamatü esati bama üriatu sacerdoterrü y arrübama mamayoreca israelitarrü, ñanquitioma pünanaquiti: —¿Quiti uiche aitorrimia aemo üriacabocü nauqui aisamune arrüna sane? ");
INSERT INTO caxNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aiñumuti Jesús: —Surapoi ausucarü, arrtü apiñumuta arrüna irranca rranquirio amopünanaqui. ");
INSERT INTO caxNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Quiti uiche aicüpurutiti Juan nauqui aunimiati? ¿Taqui uiti Bae Tuparrü o ui bamantai mañoñünca? Auqui caüma ñanquitioma pünanaquimiantoe, namatü: —Arrtü usucana oñü que uiti Bae Tuparrü, entonces arrti Jesús caüma nanti oemo: “Bueno, ¿causane chapicococatipü?” ");
INSERT INTO caxNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Arrtü usucana oñü que ui bamantai mañoñünca, tüboricoma macrirrtianuca oemo. Itopiqui tüsaipü enterurrümantai icocotama que arrti Juan profetarrti tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sane nauquiche namatü ümoti Jesús: —Champürrtü tusio suiñemo. Auqui nanti Jesús ümoma: —Arrüñü ito chüpuerurrüpü suraboi ausucarü quiti uiche atorri iñemo isüriacabo, nauqui puerurrü isamune arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nantito Jesús ümoma: —¿Aburaño ümo arrüna sane? Anati taman ñoñünrrü, aboma torrüma aütorrti. Nanti ümoti maniqui taman: “Isaü, acosi caüma atrabaca au niyo, ata uva”. ");
INSERT INTO caxNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Arrti maniqui aütorrti nanti: “No, chirrancapü”. Pero auqui campiabo ñapensacarrti, sürotitü atrabacati. ");
INSERT INTO caxNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Arrti maniqui yaütoti sürotitito esati maniqui quiatarrü aütorrti, icüpurutitito ariorrti atanti uva au niyorrti. Arrti maniqui aütorrti aiñumuti: “Urria taita, yecatü rratrabaca”. Pero champürrtü sürotitü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‛¿Ñacuti uturuqui manuma torrü icocota arrüna yacüpucurrti maniqui yaütorrüma? Aiñumuma: —Arrti maniqui yeboti atrabacati. Auqui nanti Jesús ümoma: —Ñemanauncurratoe sucanañü aume: Arrübama mayacobraca impuestorrü y arrüba paüca opichübañantai ümo mañonünca tiene que aye uimia primero amopünanaqui auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Itopiqui arrti Juan Bautista cuati tücañe anunecati causane nauqui urria nausüboriqui aübuti Tuparrü. Pero arraño chapicocotapü nurarrti. Arrübama mayacobraca impuestorrü y arrüba paüca opichübañantai ümo mañoñünca icocotama ñanunecacarrti Juan. Arraño amarrtai arrüna sane, pero ta chapiñorroncocañopü y chapicocotapü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‛Amonsoi nurria arrüna quiatarrü machepecatarrü: Anati taman ñoñünrrü naqui mana cütu uva au niyorrti. Masamunuti siercu itacu. Urrinate ito taman babetarrü canrrü uiti, arrüna cauta ataichome uva iyo niyürrü. Masamunutito arrüna cauta puerurrü ariorrti ape acuirati itacu niyorrti. ‛Auqui torrio uiti manu niyorrti ümo bama trabajadorerrü nauqui atocoma acuirama itacu. Arrti cübüsoti au quiatarrrü narücüquirri. ");
INSERT INTO caxNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nauquiche tiñatai nitiempo nupucu uva, bacüpuruti ümo bama imostoti ariorrüma anquirioma uva arrüna tocabo ümoti pünanaqui manuma trabajadorerrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nauquiche tiñataimia manuma mamosoca taha, enoma ui bama trabajadorerrü. Tamanti ocüsioma ümoti, arrti quiatarrü taborioti y arrti quiatarrü obürio ümoti oboi canca. ");
INSERT INTO caxNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Arrti maniqui iyoche bacüpuruti tatito ümo sürümanama mamosoca. Pero arrümanuma trabajadorerrü isiatai tatito uimia tacana arrüna yachücoimia ümo manuma primero. ");
INSERT INTO caxNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‛Au nitacürurrü icüpurutiti naqui propiorrü aütorrti, itopiqui mapensarati sane: “Tiene que ane ñanauncurrüma manuma trabajadorerrü ümoti naqui isaü”. ");
INSERT INTO caxNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nauquiche tiñataiti taha, arrümanuma trabajadorerrü asaramatü cümenuti, namatü ümomantoe: “Tonenti aütorrti naqui iyoche. Tonenti ñana naqui ümoche atorri nanaiña. Uitabairoti nauqui noesa caüma na ñanaunrrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sane nauquiche iñenomati, iquianamati auqui manu ñanaunrrü, y itabairomati. ");
INSERT INTO caxNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Auqui arrti Jesús ñanquitioti pünanaqui bama sacerdoterrü y pünanaqui bama mamayoreca: —Arrtü cuati tato caüma maniqui iyoche, ¿causanempü uiti ümo manuma trabajadorerrü? ");
INSERT INTO caxNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Auqui aiñumuma: —Ui nitüborirrti ümoma, taborioma uiti. Itorrimiatati manu ñanaunrrü ümo maquiataca trabajadorerrü arrübama urria yachücoimia. Arrüma caüma itorrimiatama arrüna tocabo ümoti, arrtü tütane cosecharrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Auqui nanti Jesús ümoma: —¿Champürrtü lehebo año arrüna nantü icu Nicororrü? Nantü sane: Arrübama masamunu porrü oboi canca, yarutaübutama manu taman canrrü ñaquioncorrüma churriampü, abu manrrü urria. Tone baserebio tacana taman nompacüorrü principal ümo porrü. Arrüna isamutenti Señor usucarü ucütobüca uirri. ");
INSERT INTO caxNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‛Sane nauquiche sucanañü aume —nanti Jesús—, tiene que acaübu amopünanaqui arrüna nüriacarrti Tuparrü, nauqui atorri ümo bama ipiaca aiñama nisüboriquirrimia tacana arrüna urria ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tapü arrümanu canrrü, arrtü anati naqui taübüco onü, coiñoti. Y arrti naqui paquio manu canrrü onüti, cütocati nurria iquiana. (Arrti Jesús tacana manu canrrü. Arrübama üriatu israelitarrü tacana bama masamunu porrü.) ");
INSERT INTO caxNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nauquiche oncoimia manuma üriatu bama sacerdoterrü ichepe manuma fariseorrü arrümanio machepecataca uiti Jesús, tütusiatai ümoma arrümanu nurarrti ta ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sane nauquiche rranrrümampü aiñenomati. Pero birrubuma ñünana macrirrtianuca, itopiqui arrüma icocotama que arrti Jesús profetarrti, y manitanati au nürirrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Auqui arrti Jesús manitanati tatito yupu machepecataca, nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Arrüna arrtü üriabucati Tuparrü oemo, pasao uiti tacana uiti maniqui yüriaburrü naqui masamunuti tübübürrü ümo nipocorrti aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bacüpuruti ümo bama imostoti ariorrüma atasuma ümo bama tütasuruma. Pero arrüma bama champürrtü rranrrüma aüromatü ümo manu tübübürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Auqui bacüpuruti tatito ümo maquiataca imostoti, nanti ümoma: “Amucanaño ümo bama tasuru que tüchauqui pemacarrü. Chauqui tanaiña apobiqui sümucuca, tari yebomatü ümo tübübürrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero arrümanuma tasuru champü nümoche uimia. Anati naqui sürotitü au niyorrti y maquiataca süromatü ümo nesarrüma negociorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Maquiataca iñenoma manuma imostoti maniqui yüriaburrü. Ocüsioma ümoma y taborioma uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sane nauquiche arrti maniqui yüriaburrü tüboricoti nurria. Bacüpuruti ümo sürümanama masortaboca nauqui, ariorrüma aitabairoma manuma mayatabayoca y nauqui aiñonocoma ito manu nesarrüma pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Auqui nanti ümo manuma imostoti: “Chauqui tütane nanaiña ümo tübübürrü, pero arrümanuma tasuru tarucu nimialocorrüma. Sane nauquiche champürrtü cuamatü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Amecosi caüma auba nerrüquinaca tanu yusiu ba cayaca, apatasu ümo bama cualquierarrtai bama apicuñucama, nauqui ayematü ümo tübübürrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Auqui arrümanuma mamosoca süromatü yusiu cayaca. Oberabarama uimia enterurrüma bama icuñunuma. Aboma bama malorrü y aboma ito bama buenurrrü. Sane nauquiche ataso niporrti maniqui yüriaburrü ui arrümanuma tasuru. ");
INSERT INTO caxNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‛Auqui arrti maniqui yüriaburrü sürotipo asaboriti ümoma. Besüro narrtarrti ümoti maniqui taman ñoñünrrü anan cati acamanu eanama. Champürrtü aibioti tacanarrtü ümo tübübürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nanti ümoti: “¿Causane ayetüpo aübu arrüna nahibi sane? ¿Causane chacampiacapü nauqui ayetü ümo na tübübürrü?” Arrti maniqui ñoñünrrü chümanitanatipü ui nicüsorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Auqui arrti maniqui yüriaburrü nanti ümo manuma mamosoca baserebioma icu mensarrü: “¡Apipüniñoencasarrti y apitomoensio ito neherrti! ¡Apipenesorrti türüpo ümo tomiquianene! Taha au infierno, aboma bama areoroma y botoquio nohorrüma”. ");
INSERT INTO caxNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‛Sürümanama bama tasuru, pero mümanamantai bama tacümanauncunu uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Arrümanuma fariseorrü caüma süromatü türüpo, apachema causane niquiubuma nauqui anitati Jesús uimia arrüna uiche puerurrü urabomati. ");
INSERT INTO caxNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sane nauquiche bacüpuruma ümo bama ñanunecasarrüma ichepe manuma auqui nesarrti partidorrü Herodes nauqui aüromatü esati. Arrüma namatü ümoti Jesús: —Maestro, tusio suiñemo que ñemanauntu arrüna nura isucarü macrirrtianuca y aiñununecacama ito causane nauqui urria nisüboriquirrimia ümoti Tuparrü, y champü nümoche obi ñapensaca macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Urasoi suisucarü arrüna sane: ¿Taqui urria bapaca impuestorrü ümoti yarusürürrü yüriaburrü Cesar o champü? ");
INSERT INTO caxNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero arrti Jesús tütusiatai ümoti arrümanu churriampü ñapensacarrüma, auqui nanti ümoma: —Arraño mañapanca. ¿Causane apache macocotorrü iñemo? ");
INSERT INTO caxNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Apitusianca isucarüñü taman monedarrü arrüna uiche apapaca impuestorrü. Itusiancatama isucarüti taman monedarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nauquiche tarrtaiti Jesús manu monedarrü, ñanquitioti pünanaquimia, nanti: —¿Nausüpütuche arrüna ane icu na monedarrü y quiti üriche arrüna ane corobo icu? ");
INSERT INTO caxNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aiñumuma manuma fariseorrü, namatü: —Nürirrti yarusürürrü yüriaburrü Cesar y nausüpüturrti. Auqui nanti Jesús ümoma: —Apitorrimia te ümoti Cesar arrüna tocabo ümoti y apitorrimia ito ümoti Tuparrü arrüna tocabo ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nauquiche oncoimia arrüna sane nurarrti Jesús ümoma, cütobüsoma uiti. Auqui süroma tato. Onconoti Jesús uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Au manu nanenese iñataimia esati bama saduceorrü nauqui aparimia aübuti. Arrüma chicocotapüma nisüboriquirrimia tato bama coiño. Sane nauquiche caüma ñanquitioma pünanaquiti Jesús, namatü: ");
INSERT INTO caxNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, arrti Moisés bacüpuruti sane: Arrtü anati taman ñoñünrrü naqui coiñatai pünanaqui nicüpostoti, chaübosiopü uiti, tari ñatoconati quiatarrü yaruquitorrti apoti aübu, nauqui ane naübosirri uiti au nürirrti maniqui coiño. ");
INSERT INTO caxNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bueno, auna subarrüpecu aboma tücañe sietema mañoñünca yaruquitorrümantoe. Arrti maniqui yarusürürrü posoti, pero coiñotiatai pünanaqui nicüpostoti. Champürrtü aübosio uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Arrti maniqui segundo posoti aübu manu biurarrü, isiatai, coiñotiatai ito pünanaqui, chaübosiopü uiti. Isiatai pasabo ümoti maniqui tercero y sane niyücürrü hasta arrti maniqui séptimo. ");
INSERT INTO caxNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Au nitacürurrü coiño ito manu paürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Carü ñana arrtü süboricomapü tato eanaqui macoiñoca, quiti uturiqui manuma siete, naqui propiorratoe iquiana manu paürrü? Itopiqui chépe posoma aübu. ");
INSERT INTO caxNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aiñumuti Jesús, nanti ümoma: —Arraño champürrtü apipiaca apapensa, itopiqui champürrtü apisuputacai Nicororrü ni arrünampü nicusüurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Arrtü süboricoma tato bama macoiñoca, champüqui nümoche apoma. Arrüna nacarrüma caüma chauqui tacana naca bama angelerrü esati Tuparrü au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Arraño chapicocotapü arrüna nisüboriquirrimia tato bama coiño, ¿canapae champürrtü lehebo año arrüna nurarrti Tuparrü icu Nicororrü? Nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Arrüñü Tuparrüñü ümoti Abraham, ümoti Isaac y ümoti Jacob”. Arrti Bae Tuparrü champürrtü Itupa bama macoiñoca, ta Itupa bama süborico. (Itopiqui arrti rranrrti nauqui uiñanaunuti. Abu arrübama coiño chüpuerurrüpümainqui aiñanaunumati. Uirri tusio que arrübama trerrü antiburrü süboricoma tato esati Tuparrü.) ");
INSERT INTO caxNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nauquiche oncoimia arrüna sane, arrümanuma macrirrtianuca cütobüsoma ui arrüna ñanunecacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Arrübama fariseorrü iyoberabaramacü nauquiche tipiatema que uiti Jesús etayoimia arrübama saduceorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tamanti uturuqui bama fariseorrü, naqui manunecana nüriacarrü, rranrrtipü aiñanti macocotorrü ümoti Jesús. Ñanquitioti pünanaquiti: ");
INSERT INTO caxNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, ¿ñacuna manrrü yarusürürrü bacüpucurrü omeanaqui nanaiña arrüba bacüpucuca au nüriacarrü? ");
INSERT INTO caxNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Auqui nanti Jesús ümoti: —Tari cuasürüti aemo Señor naqui Tuparrü aübu nanaiña nausasü, aübu nanaiña nausüpü y aübu nanaiña napensaca. ");
INSERT INTO caxNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tone arrüna manrrü yarusürürrü bacüpucurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aninqui quiatarrü bacüpucurrü isiatai yarusürürrü tacana arrümanu primero: “Tari cuasürüti aemo asüborisapa tacana arrüna nacua aemoantoe”. ");
INSERT INTO caxNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ubau arrüba torrü bacüpucuca abe nanaiña arrüba piquiataca bacüpucuca uiti Moisés y arrüba manunecataca ui bama profetarrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nauquiche amoncomainqui oberabarama manuma fariseorrü, ");
INSERT INTO caxNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","arrti Jesús ñanquitioti pünanaquimia: —¿Isane nacarrti Cristo aume, naqui tiene que ayetü? ¿Quitipü aütocheti au napaquionco? Namatü: —Arrti cuati eanaqui nesarrti familiarrü yüriaburrü David tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aiñumuti Jesús: —Arrti yüriaburrü David tücañe nanti “Señor” ümoti Cristo, numo manitanati uiti Espíritu Santo. Ane arrümanu corobo sane uiti David: ");
INSERT INTO caxNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Arrti Bae Tuparrü nanti ümoti Señor: “Atümo auna rrupetacuñü au nepanauncu niñe, cheperrtü bachesoiyoma sobi aesacü arrübama tüboricomantai aemo”. ");
INSERT INTO caxNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Arrtü nampü ñoñünrrtiatai Cristo eanaqui nesarrti familiarrü David, quiubupü nanti David “Señor” ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Arrümanuma fariseorrü champürrtü iñumutama arrümanu nurarrti Jesús. Auquito birrubuma. Champürrtü ananto ayematü anquirioma arrüna ausüratai pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Auqui nanti Jesús ümo macrirrtianuca y ümo bama ñanunecasarrti: ");
INSERT INTO caxNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Arrübama manunecana nüriacarrü y arrübama fariseorrü ñaquioncorrüma ipiacama nurria anunecama nüriacarrü tacanati Moisés tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sane nauquiche apicocoatai arrüna yacüpucurrüma y apisamute arrüna urapoimia ausucarü, pero tapü apisamute tacana arrüna isamutema, itopiqui arrüma chisamutempüma isiu arrüna ñanunecacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bacheboma bacüpucuca ümo genterrü, arrüba tacana cargarrü ümoma, champüti naqui avantabo iquiana. Tapü arrüma ni arriampüma aipoconocoma pario. ");
INSERT INTO caxNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nanaiña arrüna urriante uimia, es ui nirrancarrüma nauqui asaramatü macrirrtianuca ümoma. Urriantai ümoma aiñanioma icutama y apü nipiarrüma arrümanio bupacubaesa cintaca ane corobo yucu arrüna nurarrti Tuparrü. Urriantai ümoma aiñama nabesaqui naibirrimia manrrü abaesa. ");
INSERT INTO caxNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Arrtü ane yacarrü o ubau arrüba sinagoga urriantai ümoma atümoma ubau arrüba tümoca abe bien ümo nisurratoe. ");
INSERT INTO caxNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Urriantai ümoma arrtü manquioma nurria macrirrtianuca ümoma yusiu cayaca aübu rrespetorrü. Rranrrüma ito nauqui namatü ümoma “maestro”. ");
INSERT INTO caxNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‛Pero arraño, tapü apisamute sane, tapü aurrianca nauqui namatü aume maestro, itopiqui ichepatai nabaca, tacanarrtü aubaruquiapatoe año. Tamantiatai naqui maestro aume: Arrti Cristo. ");
INSERT INTO caxNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tapü amucanaño ito “iyaü” ümoti cualquierarrü icu na cürrü, itopiqui tamantiatai Aubaü naqui anati au napese. ");
INSERT INTO caxNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tapü apisamucaño tacana yüriaburrü año, itopiqui tamantiatai naqui yüriaburrü: Arrti Cristo. ");
INSERT INTO caxNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sane nauquiche arrti naqui baserebio tacana mosorrü ümo maquiataca, tonenti naqui manrrü cuasürüti, ane ito manrrü nüriacarrti abarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Itopiqui arrti naqui rranrrtiatai champüti manrrü pürücüti, tonenti naqui champü isane nacarrti ñana. Arrti naqui ichimiancanatiyü tonenti, naqui yarusürürrü ñana uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y bama fariseorrü, mañapanca! ¿Causane apiñama nituru napese pünanaqui bama rranrrüma aüromampo? Arraño chamencapütüpo, ni chebopito aboi ariorrümampo bama ranrrü aüromampo auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y arrübama fariseorrü, mañapanca! ¿Causane apiquiaübu niyopo arrüba biuraca? Tapü tusio arrüna naupicarucu, apeanca yabaiturrü. Tiene que ayetü yarusürürrü carrticurrü aume. ");
INSERT INTO caxNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y arrübama fariseorrü, mañapanca! Amecatü au nanaiña cürrü topü ba narubaitu tuca, nauqui asuriuma bama macrirrtianuca arrüna naubesa religión. Arrüma caüma torrü vecerrü manrrü churrimapatai nisüboriquirrimia amopünanaqui, manrrü niyücürrüma au infierno tacana arraño. ");
INSERT INTO caxNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‛¡Autaquisürücatai arraño itopiqui aurriancatai apipiasuruti quiatarrü, abu abaca tacana supurrü año! Aurriancatai apanuneca ümo maquiataca, pero ta chütusiopü aume. Arraño amucanaño arrtü anati naqui masamunu promesarrü y itusiancatati nurria curusürrü au nüri niporrti Tuparrü, chüvaleopü arrümanu sane. Tapürrtü itusiancatati curusürrü au nüri oro auqui niporrti Tuparrü, tone valeo. ");
INSERT INTO caxNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Masonsoca! Arraño abaca tacanarrtü supurrü año. Manrrü te Tuparrü cuasürü niporrti Tuparrü pünanaqui manu oro. Arrümanu oro ane samamecana solamenterrü itopiqui ane au niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Arraño amucanaño ito: “Arrtü anati naqui masamunuti promesarrü y itusiancatati nurria curusürrü au nüri altar, auqui caüma chüvaleopü. Tapürrtü itusiancatati curusürrü au nüri manu macumanatarrü icu altar, auqui caüma valeo nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tarucu nausonsoco, pariquipapae, chamasacapütü nurria, abaca tacana supurrü año. Manrrü te valeo altar pünanaqui numacumanata. Arrüna macumanatarrü ane samamecana solamenterrü itopiqui ane icu altar. ");
INSERT INTO caxNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ñemanauncurratoe: Arrti naqui itusiancatati curusürrü au nüri altar, itusiancatati au nüri arrüna ito ane icu. ");
INSERT INTO caxNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Arrti naqui itusiancatati curusürrü au nüri niporrti Tuparrü, itusiancatati au nürirrtito Tuparrü naqui pohoso acamanu. ");
INSERT INTO caxNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Arrti naqui itusiancatati curusürrü au nüri napese, itusiancatati au nürirrtito Tuparrü, itopiqui tone arrüna cauta anati. ");
INSERT INTO caxNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y arraño bama fariseorrü, mañapanca! Arraño apitorrimiata ümoti Tuparrü taman ubuturuqui diez nasu menta, aníz y comino. Pero champü nümochehio aboi arrüba manunecataca manrrü yarusürürrü icu nüriacarrü. Tai ñemanauntu urria arrümanu napachücoi sane. Pero si tapü apitompücaquio arrüba manrrü yarusürürrü, arrüna uipia bacurrta nurria, uipia upucüru itacuti quiatarrü y nauqui puerurrü oncomatü oemo, tonehion arrüba manunecataca manrrü yarusürürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Arraño aurriancatai apipiasuruti quiatarrü abu abaca tacana ausupuca. Apicocoquio arrüba bacüpucuca mochiomancatai. Pero chapicocoquiompü arrüba yarusürüca bacüpucuca. Arrüna napachücoi sane es tacanarrtü apiquiaübuta taman nocüpüma eanaqui narrirri arrtü auchaca, tapürrtü ane taman camello eana ta apipiuncutatai. ");
INSERT INTO caxNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y arraño bama fariseorrü, mañapanca! Apiyarrübita basorrü y praturrü icütüpüquiatai. Pero auna ubahu ta ubataso ui arrüna napacusüpüsu y arrüna napacaübusu pünanaquiti quiatarrü ui tarucu naurrianca iyo nenarrirri. ");
INSERT INTO caxNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Arraño bama fariseorrü bien supurrü año. Primero tiene que apicoñoco arrüba chomirriampü napapensaca au nabausasü, auqui caüma urria ito enterurrü nausüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y arraño bama fariseorrü, mañapanca! Itopiqui arraño tacana arrone cajón ümo macoiñoca, icütüpüatai ta bien purusubi y coñorrtai. Pero tapo pururrü yapaiquia y nicümüca. ");
INSERT INTO caxNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sane nabaca arraño. Urria nabura ümo macrirrtianuca. Tapü au nabausasü ta ataso ui mapancarrü y nanaiña arrüba chomirriampü. ");
INSERT INTO caxNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‛¡Autaquisürücatai arraño bama manunecana nüriacarrü y bama fariseorrü, mañapanca! Arraño apisamute niquiajon bama profetarrü bama coiño tücañe y apicoñoco ito arrüba nicürrüma bama buenurrüma tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Amucanaño ito: “Arrtü amoncosomüpü ichepe bama antiburrü tücañe, quiubupü ataborimia soboi bama profetarrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ui arrüna aburapoi sane, chauqui tütusio que arraño te eanaqui nesarrüma familiarrü bama uiche ataborimia bama profetarrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arraño caüma isiatai napachücoi churriampü tacana bama antiburrü. ");
INSERT INTO caxNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‛Arraño niñupariente noirroboca. ¿Causanempü naqui puerurrü aberrücapa ñünana carrticurrü au infierno? ");
INSERT INTO caxNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","¡Amonsoi! Tiene que icüpuruma aume bama profetarrü ichepe bama ane ñapanauncurrüma y arrübama maestro. Pero arraño caüma apitabaiquiama, apiñacama apü curusürrü, maquiataca poborioma aboi ubau sinagoga y apitaquisünacama ubau puebluca. ");
INSERT INTO caxNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sane nauquiche caüma süro carrticurrü aume itobo nanaiña arrüna niconcorrüma bama mañoñünca buenorrü, arrübama taborioma tücañe, auqui numo taborioti Abel naqui buenurrü, hasta arrti Zacarías naqui aütorrti Berequías, naqui itabairomati bama aupariente tücañe au nusuara niporrti Tuparrü esa altar. ");
INSERT INTO caxNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Arrübama macrirrtianuca caüma tiene que carrticaboma ichepe manuma tarucu nomünantü uimia tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nantito Jesús ümoma: —¡Autaquisürücatai bama pohoso au Jerusalén! Arraño apitabaiquiama bama profetarrü y aparucama oboi canca. Irriancapü iyoberabaraño, tacana arrone curubasürrü iyoberabario naübosirri iquiana nipiarrü. ¡Pero arraño chaurriancapü! ");
INSERT INTO caxNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Amasasatü te nurria, arrüba naupo tiene que acüche ñoquiana y omiñarri. ");
INSERT INTO caxNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Itopiqui sucanañü nurria aume, chüpuerurrüpü nauqui amasarañü tato, cheperrtü iñatai manu nanenese auche amucanaño: “Curusüoti uiti Tuparrü naqui cuatü au nürirrti”. ");
INSERT INTO caxNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Auqui sürotitü Jesús türüpo auqui niporrti Tuparrü. Numo tüniyücürrti türüpo, arrübama ñanunecasarrti cuamatü esati, uraboimia arrüna pucürusumantai icuata arrüna nicoñoco manu niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero arrti Jesús nanti: —¿Amarrtai nanaiña arrüna sane? Ñemanauncurratoe sucanañü aume: Arrüna porrü iñarrio ñana, chüpuerurrüpü na querabo ni tamanpü canrrü onü quiatarrü, nanaiña tiene que aiñarri. ");
INSERT INTO caxNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Auqui süromatü onü manu yiriturrü nürirri Olivos. Nauquiche tanancati tümonsoti Jesús acamanu, arrübama ñanunecasarrti ñanquitioma pünanaquiti masamuñantai: —Suirranca nauqui uraboi suisucarü, auche ñana cocono arrüna sane. ¿Isanempü arrüna señarrü nauqui atusi arrüna nayequi tato y arrüna arrtü tiñatai mapacümuncuturrü uiti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nanti Jesús ümoma: —¡Amasasai nurria, tapü anati naqui encañao aume! ");
INSERT INTO caxNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Itopiqui chiyaupüma bama cuabotü au nisüri aübu arrüna nurarrüma sane: “Arrüñü Cristo” y ui arrüna sane nurarrüma sürümanama bama icocotama ñapanturrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amoncoi nüri guerra, itopiqui tiene que sane te, pero ta chütoneinquipü ñapacümuncuturrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Taman nación tiene que ahi aübu quiatarrü. Tamanti yüriaburrü tiene que ahiti aübuti quiatarrü. Tiene que ane carerrtiya, norrocorrü y tiene que apaichocono cürrü au nanaiñantai. ");
INSERT INTO caxNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Enterurrü arrüna sane, arrtü aübo ane taquisürücürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Auqui tiene que autorriquia mecu macrirrtianuca nauqui emeonoma año chépe nauconco uimia y namanaiñantai tüboricoma aume auqui niyaca. ");
INSERT INTO caxNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Au manu tiemporrü ñana mapaventecanama ümoti quiatarrü. Sürümanama bama ensoro pünanaquimia arrüna ñacoconauncurrüma iñemo. Tüboricomantai ümomantoe. ");
INSERT INTO caxNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tiene que ayematü sürümanama mañapanca arrübama namatü que manitanama au nürirrti Tuparrü. Ui arrüna sane sürümanama bama icocotama ñapanturrüma. ");
INSERT INTO caxNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tiene que ane tarucu nomünantü ui macrirrtianuca icu cürrü. Ui arrüna sane chauqui chücuasürüpümainqui ümomantoe. ");
INSERT INTO caxNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero arrti naqui chübatachebopü isiuñü cheperrtü iñatai manu nanenese, tonenti naqui chiyebopü ui manu carrticurrü uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero cusürübo tiene que atusi nurarrti Tuparrü au nanaiñantai icu na cürrü ui bama ipiacama anitanema, auqui caüma iñatai ñapacümuncuturrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‛Arrti naqui lehebo arrüna Nicororrü uiti profetarrü Daniel tari yeraca au nitanurrti. Arrti maconomonoti tücañe icütüpü arrümanu ünantapae. Arrtü amarrtai arrüna sane au niporrti Tuparrü, ");
INSERT INTO caxNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","arrübama aboma au cürrü Judea tiene que aesübuma omeana yirituca. ");
INSERT INTO caxNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Arrti naqui batrabacara chacu niporrti, tapü sürotipo aiquianti nenarrirrti, mejor tari yesüburati saneantai. ");
INSERT INTO caxNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Arrti naqui anati au niyorrti tapü süroti tato au porrü aiquianti naibirrti, mejor tari yesüburati saneantai. ");
INSERT INTO caxNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Butaquisüratai arrüba paüca anatiqui ñupaümacarrü y arrüba ito aübo ane omemecu y yocütüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Apanqui pünanaquiti Tuparrü tapü tocabo aume aupesübu au nitiempo rrimianene ni aupü nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Itopiqui au manio naneneca ñana ane taquisürücürrü tacana arrüna champü tubarrtai auqui numo aübo urriane cürrü, ni anempito ñana. ");
INSERT INTO caxNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Arrtü nampü chichimiancatatipü Tuparrü arrümanu tiemporrü auche ane taquisürücürrü, champütipü naqui süboricoiqui. Pero como tarucu nicuarrüma bama tacümanauncunu uiti sane nauquiche ichimiancatati manu tiemporrü ñana. ");
INSERT INTO caxNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‛Arrtü anati naqui nanti aume: “Amasatü, tonenti Cristo naqui” y arrtü namatito: “Amasatü tonenti naqui taha”, tapü apicocota. ");
INSERT INTO caxNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Cuamatito mañapanca y namatü: “Arrüñü Cristo, arrüñü rranitaca au nürirrti Tuparrü”. Urriante ito yarusürürrü señarrü uimia y milagrorrü arrüna uiche encañama ümo macrirrtianuca. Hasta rranrrüma encañama ümo bama tacümanauncunu uiti Tuparrü, arrtü puerurrüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pero chauqui tütusio aume sobi. ");
INSERT INTO caxNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sane nauquiche tapü apicocota arrtü namatü aume: “Isuñucati Cristo taha eana rroense, o anati taha au manu taman porrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Arrtü iseca tato, es tacana ñasünarrü arrüna quara auqui tauna ümo tansürü hasta auna ümo nimümürrü, chanecataipü nisequi tato. ");
INSERT INTO caxNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Auna cauta ane nicunturrü acamanu opiyoberabaraño parrüpaquiquia. ");
INSERT INTO caxNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‛Arrtü tübupasao manio naneneca nesa taquisürücürrü, surrü y pama obotochebo. Norrtoñeca bupaquio auqui napese icu na cürrü. Nanaiña arrüba abe icu napese bupaichoconono. ");
INSERT INTO caxNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Auqui caüma amarrtai señarrü icu napese sobi naqui Ñemanauncurratoe Ñoñünrrü. Namanaiña macrirrtianuca icuqui na cürrü areoroma y tiene que asaramañü, nisequi tato auqui napese omeanaqui cüsaüboca aübu tarucu nisüriaca y aübu tarucu nanentarrü sobi. ");
INSERT INTO caxNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Rracüpuca ito ümo bama niyesa angelerrü isiu nipucu taman cornetarrü, nauqui aiyoberabarama bama tacümanauncunu sobi auqui nanaiñantai icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tari süro nurria au nautanu arrüna machepecatarrü apü manu suese higuera: Arrtü aübapae nasurrü tato, arraño tusio aume ta tüsaimia nitiempo tarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Isiu arrtü amarrtai tücomensabo taquisürücürrü, auqui caüma tusio aume que tüsaimia ñapacümuncuturrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ñemanauncurratoe sucanañü aume: Arrübama macrirrtianuca auna caüma chüpuerurrüpü acoma mientras que chüpasabopü nanaiña arrüna. ");
INSERT INTO caxNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Arrüna cürrü y napese tiene que amiñarri, pero nisura tiene que acoco. ");
INSERT INTO caxNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‛Champüti manrrü atusi ümoti isane arrüna nanenese o isane horarrü auche ise tato, ni arrübama angelerrü au napese, ni arrüpüñü naqui Aütorrti Tuparrü atusi iñemo. Solamenterrü arrti Tuparrü naqui Uyaü tusio ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‛Arrtü iseca tato, arrüñü Ñemanauncurratoe Ñoñünrrü, pasao auna icu cürrü isiu tacana tücañe numo süboricotiqui Noé. ");
INSERT INTO caxNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Au manu tiemporrü tücañe nauquiche chiñataiquipü manu turrü, arrümanuma macrirrtianuca chaboma, basoma, posoma y maponacanama ito ñome nitaquiumucuturrüma y ümo bama aütorrüma, hasta que iñatai manu nanenese nauquiche süroti Noé au arca. ");
INSERT INTO caxNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chütusiopü ümoma isane pasabobo, rrepenteatai cuatü manu turrü y coiñoma uirri. Sane ito ñana chütusiopatai isane horarrü iñatai tato icu na cürrü, arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Au manu tiemporrü ñana aboma torrü mañoñünca au ñanaunrrü, tamanti uturuquimia carüboti, tapü arrti quiatarrü onconoti. ");
INSERT INTO caxNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Abe ito paüca tonrrio patubarrio, taman carübo, quiatarrü oncono. ");
INSERT INTO caxNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‛Sane nauquiche amasasai nurria itacu nausüboriqui, itopiqui chütusiopü aume isane horarrü ise tato auna icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Supiarrtü anati taman ñoñünrrü naqui ane niporrti. Arrtü nampü tusio ümoti isane horarrü tobirri aiñanainti cusüpürrü, taipü anutipü, yacuiracarrti, tapü macanati nenarrirrti. ");
INSERT INTO caxNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sane ito arraño tiene que aparrüpera aübu urria nausüboriqui tapü autabücatai. Itopiqui chütusiopü aume auche ise tato. ");
INSERT INTO caxNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nantito Jesús ümoma: —Arraño abaca tacanati taman mosorrü naqui oncono uiti ipiatronetorrti, nauqui acuirati itacu nanaiña nenarrirrti au niporrti, y nauqui asaparati ümo bama maquiataca mamosoca naneneca, cheperrtü iñataiti tato. ");
INSERT INTO caxNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Urriampae nacarrti maniqui mosorrü arrtü tabücoti isamutenti arrüna yacüpucurrti maniqui ipiatronetorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ñemanauncurratoe sucanañü aume: Arrti maniqui mosorrü tiene que aüroti tacana capatarrü uiti maniqui patrón ümo nanaiña nenarrirrti. ");
INSERT INTO caxNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero supiarrtü malorrti maniqui mosorrü y arrtü mapensarati que chücontopü ayeti tato maniqui ipiatronetorrti, ");
INSERT INTO caxNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y bacheboti chacu bama maquiataca mamosoca y chaiyatai ñasamucurrti pierrta aübu bama mayarisüboca. ");
INSERT INTO caxNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Auqui caüma arrti maniqui patrón rrepenteatai iñataiti tato y arrti maniqui mosorrü tabücotiatai, itopiqui chütusiopü ümoti isane nanenese y horarrü auche aiñananiti tato ipiatronetorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Itacu arrüna sane arrti maniqui patrón bacheboti yarusürürrü carrticurrü ümoti maniqui mosorrü. Penecoti uiti ichepe bama mañapanca, nauqui ataquisürüti tacana nitaquisürücürrüma. Uirri caüma areoroti, botoquio nohorrti ui tarucu nitaquisürücürrti. ");
INSERT INTO caxNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Arrtü üriabucati Tuparrü, pasao uiti tacana oboi arrümanio diez cupiquiquia, omenotü ümo taman tübübürrü nauqui amasarati maniqui aübo apo. Apacana niyubasarurrü arrüba omomo ui nacaite. ");
INSERT INTO caxNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Arrümanio cinco ubuturuqui champü ñupanauncurrü, tapü arrümanio piquiataca cinco bien urria ñupapanauncurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Arrümanio cinco sonsorrü champürrtü pacana chama nacaite ümorrtü cüpüro auqui niyubasarurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tapü arrümanio piquiataca cinco pacana chama nacaite. ");
INSERT INTO caxNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Arrti maniqui nitübübüche chücontopü aiñanainti esa manu nitübübürrti. Sane nauquiche arrümanio cupiquiquia cuatü ñome ñumpanucurrü y mumpanumu. ");
INSERT INTO caxNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Taqui cümuinta tobirri, rabotü tosibirri: “¡Tücuati naqui nitübübüche! ¡Amecosi apicuñunuti!” ");
INSERT INTO caxNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Auqui arrümanio cupiquiquia patürai apicoñoco niyubasarurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Arrümanio cinco chupacanapü chama nacaite, panquio mopünanaqui manio piquiataca cinco, itopiqui tirranrrü acüpu nacaite auqui niyubasarurrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Auqui arrümanio cinco opiñumuta: “No chisuirrancapü, itopiqui rrepenteatai chiñataipito suiñemo arrüna nacaite. Mejor amecosi auna cauta ane paventeobo apacompora aume”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero nauquiche tomenotü manio cinco cupiquiquia apacompora nacaite, arrti maniqui nitübübüche iñataiti. Arrümanio piquiataca cinco chauqui niyocoborirri, omenotüpo ichepeti maniqui nitübübüche. Auqui mamana tururrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Auqui opiñatai tato manio cinco, opiyotobaita tururrü, munantü: “¡Señor, Señor, aiyaübu suiñemo tururrü!” ");
INSERT INTO caxNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Auqui arrti maniqui itübübüche iñumutati: “Ñemanauntu sucanañü aume: Champürrtü isuputacaño”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nantito Jesús: —Sane ito arraño amasasai nurria, itopiqui chütusiopü aume isane nanenese o isane horarrü auche iñatai tato, arrüñü Ñemanauncurratoe Ñonünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nantito Jesús: —Suraboira quiatarrü machepecatarrü ausucarü: Arrtü üriabucati Tuparrü, pasao tacana uiti maniqui taman ñoñünrrü naqui rranrrü aürotü au quiatarrü nación. Tasuruma uiti bama imostoti nauqui acuirama itacu niporrti. ");
INSERT INTO caxNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‛Itorrimiatati cinco mil monedarrü ümoti maniqui taman, ümoti quiatarrü torrio dos mil monedarrü y ümoti quiatarrü torrio mil monedarrü. Torrio sane uiti isiu naca arrüna narucurrü ümoma. Auqui sürotitü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Arrti maniqui taman mosorrü naqui torrio ümoti cinco mil, batrabacarati aübu y macananati piquiataca cinco mil monedarrü auqui. ");
INSERT INTO caxNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sane ito isamutenti maniqui torrio ümoti dos mil, macananatito piquiataca dos mil auqui. ");
INSERT INTO caxNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tapü arrti maniqui torrio ümoti mil, iñanecatati cütu. ");
INSERT INTO caxNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‛Tücoboi niyücürrti maniqui patrón taman nanenese iñataiti tato esama. Auqui bacurrtarati aübuma. ");
INSERT INTO caxNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Primero iñataiti maniqui torrio tücañe ümoti cinco mil monedarrü, nanti ümoti: “Señor, aitorrimiata tücañe iñemo cinco mil. Pero auna abe piquiataca cinco mil monedarrü nirracanasa ubauqui”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Auqui nanti patrón ümoti: “Arrücü imoso bien urria nachücoi y bien buenorrücü. Ui na cumplibocü aübu na chimiantai monimia torrio sobi, puerurrü itorrimia manrrü chama aemo. ¡Ariacupo y apucünu ichepeñü!” ");
INSERT INTO caxNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Auqui iñataitito maniqui mosorrü naqui torrio ümoti dos mil y nanti ümoti ipiatronetorrti: “Señor, aitorrimiata tücañe iñemo dos mil, auna ane quiatarrü dos mil, arrüna nirracanasa”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nanti patrón ümoti: “Arrücü imoso bien urria nachücoi y buenorrücü. Ui na cumplibocü aübu arrüna chimiantai monirri torrio sobi aemo, puerurrü itorrimia manrrü chama aemo. ¡Ariacupo y apucünu ichepeñü!” ");
INSERT INTO caxNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Au nitacürurrü iñataiti maniqui botorrio mil monedarrü ümoti. Nanti ümoti ipiatronetorrti: “Señor, arrüñü tusio iñemo que arrücü tarucu nabrutucu. Arrücü cosechabocü auquina cauta chancapü cütu y acaca auqui na cauta champü isane oncono obi. ");
INSERT INTO caxNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sane nauquiche irruca aünanacü. Ananca anecana sobi namoni eana cürrü, tapü ensoro. Pero nani itorrimiana tato aemo”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aiñumuti maniqui patrón: “Arrücü mosorrü nicumaturrü y miarriquiatarrü, tusio te aemo que arrüñü cosechaboñü auqui na cauta champü isane iñata cütu y rracaca au quina cauta champü isane oncono sobi. ");
INSERT INTO caxNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sane nauquiche manrrüpü urria arrtü aiñocotapü manu nimoni esa bama ipiacama atrabacama aübu, ümo arrtü iseca tato yasutiupü, torrio tato iñemo aübu ñacanasarrü pario”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Auqui nanti patrón ümo manuma amoncoma acamanu: “¡Apiquiaübu manu mil monedarrü pünanaquiti y apitorrimia ümoti maniqui abe diez mil uiti! ");
INSERT INTO caxNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Itopiqui arrti naqui ane uiti, torrioqui manrrü uübo ümoti y sane caüma ane chama ümoti. Tapü arrti naqui chüpuerurrüpü oñoncatü ümoti, carübu pünanaquiti arrüna chimiantai ane uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Arrti naqui mosorrü champü yaserebiquirrti aparusaüburrti türüpo ümo tomiquianene, auna cauta tiene que areoti y botoquio nohorrti ui nitaquisürücürrti”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nantito Jesús ümoma: —Arrtü isecatato icu na cürrü, isecatü tacanati yarusürürrü yüriaburrü. Cuamatü isiuñü bama angelerrü y tiene que ichümo au niyesa tronorrü arrüna champü tacanache nanentacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Arrübama macrirrtianuca auqui nanaiña nacioneca icuqui na cürrü iyoberabaramacü yesañü. Süroma peese sobi, tacana uiti taman naqui bacuirara yutacu nobirraca. Omeno peese nobirraca uiti omeanaqui chibuca. ");
INSERT INTO caxNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iñaniontiño nobirraca au nepanauncurrti, tapü chibuca iñaniontiño au nepaurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sane ito ñana sobi ümo bama macrirrtianuca. Sucanañü ñana ümo bama aboma au nepanauncu niñe: “Ausiapata tauna arraño bama aucurusüca uiti Iyaü, apasusiu abüriacabo, ta sane ñapensacarrti aume auqui maübo nauquiche urriane na cürrü uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Itopiqui nauquiche anancañü isürüpüca, arraño apasapacañü. Nauquiche anancañü ichosüca apichamacañü. Nauquiche anancañü ñamenca arraño, apasuquiucañü au naupo. ");
INSERT INTO caxNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nauquiche champü nisahibi, arraño apacheca isaibiboñü. Nauquiche anancañü ñaunrrococa, apapaseacañü. Nauquiche anacañü au preso, apatasuacañü”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Auqui caüma arrümanuma urria tücañe nisüboriquirrimia, namatü: “Señor, champü tüsumasacü tücañe acürüpüca y supachecapü utuburibocü. Champü ito tüsumasacü atosüca y supachecapito atüpobocü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Auchepü tücañe sumasacü amenca nauqui supasuriurü au suipo, o auchepü sumasacü champü nahibi y supachecapü aibibocü? ");
INSERT INTO caxNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Auchepito tücañe sumasacü aunrrococa o anancü au preso y subacapütü sumasarü?” ");
INSERT INTO caxNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Auqui caüma sucanañü sane ümoma: “Ñemanauncurratoe sucanañü aume: Enterurrü arrüna urria apisamute tücañe ümo arrübama isaruquitaiqui, bama champü causane uimia, ta tacanarrtü apisamute iñemo”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‛Auquito caüma sucanañü ümo bama aboma au nepau niñe: “Apaquicho auquina yesaquiñü, arraño bama tarucu nomünantü aboi. Amecosi au infierno eana pese arrüna champü nitacürurrü. Chauqui tacomorabo icümenuti choborese y arrübama ito nesarrti angelerrü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nauquiche anancañü abarrüpecu isürüpüca, arraño champürrtü apasapacañü. Ichosüca, champürrtü apacheca ichüpoboñü. ");
INSERT INTO caxNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Anancañü ñamenca, champürrtü apasuquiucañü au naupo. Anancañü ñaunrrococa y anancañü ito au preso, champürrtü apapaseacañü”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Auqui caüma namatü iñemo: “Señor, ¿cautapü tümasacü acürüpüca, atosüca, amenca, o arrtü champü nahibi, aunrrococa, apresoca, nauquipü supayura aemo? Champü tüsumasacü”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Auqui caüma sucanañü ümoma: “Ñemanauncurratoe sucanañü aume: Enterurrü arrüna champürrtü apisamute ümoti taman uturuqui bama isaruquitaiqui, ta iñemo arrüna napachücoi sane”. ");
INSERT INTO caxNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sane nauquiche caüma süromatü ümo carrticurrü arrüna champü nitacürurrü. Tapü arrübama isamutema isiu nirrancarrti Tuparrü tücañe, tonema bama süromatü au napese auna cauta champü nitacüru süboriquirri. ");
INSERT INTO caxNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nauquiche tanaiña urapoiti Jesús arrüna sane, nanti ümo bama ñanunecasarrti: ");
INSERT INTO caxNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Arraño tusio aume que pürücü ba torrü naneneca iñatai pierrta parrcua. Au na pierrta tiene que aitorrimianamañü mecu bama rromanorrü nauqui aiñanamañü apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Au manu tiemporrü ito tücañe, arrübama üriatu sacerdoterrü y arrübama mamayoreca israelitarrü iyoberabaramacü au manu nusuara niporrti Caifás, maniqui yarusürürrü sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Acamanu bapacheroma niquiubuma causane nauqui puerurrü aiñenomati Jesús aübu nencañacarrüma, nauqui aitabairomati. ");
INSERT INTO caxNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Namatü: —Tapü uisamute ümo arrüna pierrta. Itopiqui arrtü sane osoi, uirrtopünatatai nitübori bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Arrti Jesús anancati au Betania au niporrti Simón naqui maunrrocono tücañe, ui manu nürirri lepra. Basoma icu mensarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Auqui iñatai manu taman paürrü acamanu esati aübu taman boteyama canrrü alabastro, ataso ui perfume arrüna chiyaupü nicuarrü. Auqui iyarapata itati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nauquiche arrtaimia arrüna sane arrübama ñanunecasarrti, ünantü ümoma, namatü: —¡Ensoratai ui manu paürrü arrüna tarucu nicuarrü! ");
INSERT INTO caxNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Abu puerurrüpü aye chama monirri itobo, nauqui atorri ümo bama pobrerrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Arrti Jesús oncoiti nurarrüma, nanti ümoma: —¡Tapü abasiquia icuata! Arrüna isamute, urria. ");
INSERT INTO caxNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Itopiqui arrübama pobrerrü nantarü au nantai abarrüpecu nacarrüma, pero arrüñü chüpuerurrüpü nauqui yasiquia auna abarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Arrüna paürrü iyarapata arrüna perfume ichañü ümo ñana arrtü iñanamañü cütu. ");
INSERT INTO caxNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ñemanuncurratoe sucanañü aume: Ñana arrübama manitana nomirria isucarü macrirrtianuca icu na cürrü, tiene que uraboimia ito arrüna isamute iñemo arrüna paürrü nauqui aquionomacü iyo. ");
INSERT INTO caxNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Auqui tamanti uturuqui manuma ñanunecasarrti nürirrti Judas Iscariote, yebotitü apariti aübu bama üriatu sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nanti ümoma: —¿Mantucubo monirri apapacaca iñemo, arrtü itorrimiacati Jesús amemecu? Arrüma bapacarama ümoti treinta moniquia. ");
INSERT INTO caxNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Auquimanu arrti Judas bapacheroti causane niquiubuti, nauqui atorriti Jesús uiti ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Arrübama israelitarrü tücañe basoma pan champü levadura eana ñome siete naneneca ümo manu pierrta. Au manu primer nanenese arrübama ñanunecasarrti Jesús süromatü esati anquirioma pünanaquiti: —¿Cauta arrianca supapema nauqui uba ümo na pierrta parrcua? ");
INSERT INTO caxNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nanti Jesús ümoma: —Amecosi au pueblurrü, au niporrti maniqui taman ñoñünrrü y amucanaño ümoti: “Arrti Maestro nanti: Tüsaimia nisonco. Au na napo irranca irra arrüna cena pascual aübu bama nirranunecasa”. ");
INSERT INTO caxNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Arrümanuma ñanunecasarrti isamutema isiu arrüna yacüpucurrti. Süromatü apemama. ");
INSERT INTO caxNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nauquiche tütobiquia arrti Jesús tümonsoti esa mensarrü aübu bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nauquiche amoncoma basoma, nanti Jesús ümoma: —Ñemanauncurratoe sucanañü aume: Tamanti abuturuqui tiene que aitorrimianatiñü mecu bama tüboricomantai iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Auqui caüma tarucu nisuchequirrimia, taiquianati taman ñanquitioma pünanaquiti Jesús: —¿Taqui arrüñü, Señor? ");
INSERT INTO caxNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aiñumuti: —Arrti naqui baso ichepeñü auqui na taman praturrü, tonenti naqui uiche aipiaventecanatiñü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que acoco sobi arrüna nantü icu Nicororrü. ¡Pero taquisürütiatai naqui uiche aipiaventecanatiñü! Manrrüpü uirria arrtü chanatipü icu cürrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Auqui manitanati Judas, naqui uiche aipiaventecanatiti Jesús, nanti ümoti: —Maestro, ¿taqui arrüñü? Aiñumuti Jesús: —Arrücü te. ");
INSERT INTO caxNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nauquiche amoncoma basoma, arrti Jesús iquiatati mecuti manu pan, machampiencanati ümoti Tuparrü. Auqui chepesüro uiti y itorrimiatati ümo bama ñanunecasarrti, nanti sane: —Auba, tone nisütüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Auqui iquiatatito mecuti taman coparrü aübu vinorrü niyü uva. Machampiencanati ümoti Tuparrü, auqui itorrimiatatito ümo bama ñanunecasarrti, nanti sane: —Aucha namanaiña año auqui na coparrü, ");
INSERT INTO caxNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","itopiqui tone niñoto arapara autopiqui icu na cürrü, nauqui amorrimiaca tato nanaiña nomünantü ui macrirrtianuca. Ui arrüna niñoto urriante nuevurrü tratorrü uiti Tuparrü aupu. ");
INSERT INTO caxNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sucanañü aume, chanantopü icha arrüna niyü uva, cheperrtü yaca auchepe esati Uyaü auna cauta ane nüriacarrti. Auqui caüma ichaca tatito. ");
INSERT INTO caxNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iyaü ñacantacarrüma süromatü auqui pueblurrü onü manu yiriturrü nürirri Olivos. ");
INSERT INTO caxNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Acamanu nanti Jesús ümoma: —Arraño caüma arrüna tobirri apiñococañü ui tarucu naupirrucu, itopiqui nantü sane icu Nicororrü: “Omiñarrio nobirraca arrtü coiñoti naqui bacuirara yutacu”. ");
INSERT INTO caxNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero arrtü isüboriquia tato, isusürüca yerotü au Galilea amopünanaqui. ");
INSERT INTO caxNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Auqui nanti Pedro: —Arrtü maquiataca iñoconomacü ui nirrucurrüma, pero arrüñü chiñococüpü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Auqui nanti Jesús ümoti: —Ñemanauncurratoe sucanañü aemo: Caüma arrüna tobirri, arrtü chüpuruiquipü pohorrü, ucanu trerrü veserrü, que chasuputacapüñü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nanti Pedro ümoti: —Chüpuerurrüpü. Arrtü rranrrüma aitabairomañü achepecü, pero arrüñü chüpuerurrüpü sucanañü sane. Sane ito nura bama maquiataca ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iñataimia au manu nürirri Getsemaní. Arrti Jesús nanti ümoma: —Autümo auna, yecatü baeta manrrü taha rrapari aübuti Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Auqui tasuruti Pedro uiti Jesús ichepe manuma torrü, arrti Jacobo y arrti Juan. Sürotitü aübuma. Nauquiche tücunauntaiñamantai manuma cuatro, arrti Jesús onquisioti yarusürürrü nisuchequirrti y nirrucurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Auqui nanti ümoma: —Ñonquisio nurria caüma yarusürürrü nisuchequi niyausüpü. Abasiquia auna, tapü aumpanuca. Tari amarrtaiquiatü ichepeñü arrüna tobirri. ");
INSERT INTO caxNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Auqui sürotitü manrrü tahiqui pario. Bachesoiyoti, mataconoconoti, iñatai nurria nisurrti acü, meaboti ümoti Bae Tuparrü, nanti sane: —Iyaü, arrtü puerurrü, tapü cuatü iñemo manu yarusürürrü taquisürücürrü, pero tapü aiñata isiu nirranca, aiña isiu narrianca. ");
INSERT INTO caxNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nauquiche tüchauqui neancarrti ümoti Tuparrü süroti tato esa manuma ñanunecasarrti, tabücoma uiti manumuma. Nanti ümoti Pedro: —¿Chüpuerurrüpü pario amarrtaiquiatü ichepeñü ümo taman horarrü? ");
INSERT INTO caxNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tari amarrtaiquiatü aübu napeanca ümoti Tuparrü, tapü apatacheca, arrtü cuatü macocotorrü aume. Ñemanauncurratoe sucanañü aume: Nabausüpü rranrrtaipü aüro au nomirria, pero arrüna cürrü naucütüpü ta chütonempü nirrantümo, chücusüurupatai. ");
INSERT INTO caxNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Auqui süroti tatito eanti ümoti Tuparrü, nanti sane: —Iyaü, arrtü chüpuerurrüpü aiquiaübu rropünanaquiñü arrücuatü nichaquisürücü itacu macrirrtianuca, aiña te isiu narrianca. ");
INSERT INTO caxNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Numo tiñataiti tatito esa bama ñanunecasarrti, tabücoma tatito uiti manumuma, itopiqui tarucapae nirrancarrüma anuma. ");
INSERT INTO caxNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Auqui onconoma tatito uiti, süroti tato eanti ümoti Tuparrü. Isiatai tatito nurarrti tacana arrüna primero. ");
INSERT INTO caxNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Auqui süroti tato esa bama ñanunecasarrti y nanti ümoma: —¡Causane apacansacaiqui y aumpanucaiqui! Chauqui tiñatai horarrü nauqui aitorrimianamañü mecu bama tarucu nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Apatüsai, curi, itopiqui tücuati naqui uiche aipiaventecanatiñü! ");
INSERT INTO caxNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nauquiche anancatiqui baparioti aübuma, asaratitü cümenuti Judas naqui eanaqui manuma doce ñanunecasarrti. Cuamatü isiuti sürümanama mañoñünca aübu sueca y cüseca, yacüpucu bama üriatu bama sacerdoterrü y arrübama mamayoreca. ");
INSERT INTO caxNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Arrti Judas turapoiti tücañe nesarrti señarrü isucarü manuma icumpañeruturrti, nanti sane: —Arrti naqui yacheca caüma besorrü ümoti, tonenti Jesús, apiñensorrti. ");
INSERT INTO caxNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Auqui arrti Judas besüro uiti esati Jesús. Bacheboti besorrü ümoti. Manquiotito nurria ümoti, nanti: ¡Chamurraume, maestro! ");
INSERT INTO caxNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Arrti Jesús nanti ümoti: —¿Ümo ayetü, saruqui? Auqui arrümanuma maquiataca cuamatü nauqui aiñenomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Auqui arrti maniqui taman ñanunecasarrti Jesús iquiaübutati nicüserrti. Bacheboti uirri ümoti maniqui taman imostoti yarusürürrü sacerdoterrü. Tüsüro numasurrti uiti. ");
INSERT INTO caxNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Auqui nanti Jesús ümoti maniqui ñanunecasarrti: —Aiñahübu tato manu nacüse, itopiqui arrübama bahiyoma ui cüsese, ui cüsese ito tiene que acoma. ");
INSERT INTO caxNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Chütusiopü aemo que arrüñü puerurrüpüñü rranqui pünanaquiti Iyaü nauqui acüputi sürümana mil angelerrü y auritarrüpatai tütaboma auna nauqui ocümama ichacuñü? ");
INSERT INTO caxNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero arrtü isamute arrüna sane, quiubupü acoco arrüna nantü au Nicororrü tiene que apasa arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Auqui nanti Jesús ümo bama cuamatü iyoti: —Abecatü yupu cüseca y sueca, na apiñenoñü, tacanarrtü cusüpürrüñü, abu naneneca nantarrü amasacañü au niporrti Tuparrü ichümoca aübu nirranunecaca. ¿Causanempü chapiñencapüñü acamanu? ");
INSERT INTO caxNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero nanaiña arrüna sane pasabo iñemo, nauqui acoco nura bama profetarrü ane icu Nicororrü. Auqui namanaiña bama ñanunecasarrti Jesús besüburuma. Onconoti uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Arrübama uiche aiñenomati Jesús iquianamati esati yarusürürrü sacerdoterrü, nürirrti Caifás. Acamanu chauqui toberabarama bama mamayoreca ichepe bama manunecana nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Arrti Pedro sürotitü isiuti Jesús auqui icheatai. Iñataiti au manu nusuara esa niporrti maniqui yarusürürrü sacerdoterrü. Acamanu tümonsoti esa bama policiarrü na atusi ümoti isane pasabobo ümoti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Arrümanuma üriatu sacerdoterrü ichepe manuma mamayoreca y namanaiña manuma mayüriabuca israelitarrü, bapacheroma niquiubuma causane nauqui urabomati Jesús aübu ñapanturrüma, nauqui aitabairomati. ");
INSERT INTO caxNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero chütabücopü uimia, panacapü sürümanama amoncoma acamanu aübu ñapanturrüma icütüpüti. Au nitacürurrü torrüma mañoñünca, ");
INSERT INTO caxNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","namatü: —Arrti naqui ñoñünrrü nanti tücañe sane: “Arrüñü puerurrüñü iñarrimiaca niporrti Tuparrü y au trerrü naneneca atürai tato sobi”. ");
INSERT INTO caxNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Auqui arrti maniqui yarusürürrü sacerdoterrü atüraiti, nanti ümoti Jesús: —¿Causane chaiñumutapü nurarrüma? ¿Ñemanauntu nurarrüma aemo? ");
INSERT INTO caxNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Arrti Jesús chiñumutatipü. Auqui arrti maniqui yarusürürrü sacerdoterrü nanti tatito ümoti: —Au nürirrti Tuparrü naqui süborico, sucanañü aemo, urasoi suisucarü: ¿Ñemanauntu arrücü Cristo, naqui Aütorrti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Auqui arrti Jesús iñumutati: —Ñemanauntu te arrüñü Cristoñü, tacana arrüna ucanü. Suraboira ito ausucarü, tiene que amasarañü ñana ichümoca au nepanauncurrti Tuparrü naqui chiyaupü nüriacarrti. Amasacañü ito ñana nisequi tato auqui napese omeanaqui cüsaüboca. ");
INSERT INTO caxNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Auqui arrti maniqui yarusürürrü sacerdoterrü iquiopünatati naibirrtiatoe, na atusi que ünantü ümoti, nanti sane: —Arrti naqui ñoñünrrü ane nipünatenti ui arrüna isamunutiyü tacana Tuparrü. Champü ümochetiqui terrticurrü osoi. Arraño bien tamoncoi arrüna isamunutiyü tacana Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Causane napapensaca? Arrüma iñumutama: —Ane nipünatenti, sane nauquiche tiene que aconti. ");
INSERT INTO caxNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Auqui arrümanuma aboma esati utureuruma isuti, ipubairomati. Maquiataca iñompebairomati. ");
INSERT INTO caxNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Namatü ümoti: —Arrtü ñemanauntu arrücü Cristo, ¡adivinabocü ñacuti naqui ocüsio aemo! ");
INSERT INTO caxNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tapü arrti Pedro anancati türüpo tümonsoti au nusuara. Auqui cuatü taman cumanacarrü esati, nantü ümoti: —Arrücü ito saon anancü ichepe manu Jesús auqui Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Arrti Pedro iñumutati nurarrü isucarü namanaiña manuma amoncoma acamanu: —Chütusiopü iñemo isane arrüna nurapoi. Chisuputacatipü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Auqui sürotitü abeu tururrü. Acamanu ito taman paürrü asaratü ümoti, nantü ümo manuma amoncoma acamanu: —Arrüna noñünrrü ananca ito amenco aucutanu ichepe manu Jesús auqui Nazaret. ");
INSERT INTO caxNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Acamanu mapañati tatito Pedro, itusiancatati nurria curusürrü, nanti sane: —¡Chisupatacatipü maniqui ñoñünrrü! ");
INSERT INTO caxNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tücoboi pario cuamatü esati Pedro manuma amoncoma acamanu, namatü ümoti: —Ñemanauntu te, arrücü ito anancü aucutanu ichepeti maniqui ñoñünrrü, itopiqui chanecanapatai arrüna nanitaca. ");
INSERT INTO caxNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Auqui ipiaurramanatiyü Pedro y nanti sane: —¡Chisuputacatipü maniqui ñoñünrrü! Au manu rratorrü puru pohorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Auqui aquionotiyü iyo arrümanu nurarrti Jesús tücañe ümoti sane: “Ñemanauncurratoe sucanañü aemo, caüma arrüna tobirri chüpuruiquipü pohorrü ucanü trerrü vecerrü que chasuputacapüñü”. Auqui arrti Pedro sürotitü türüpo, orronene nurria ümoti y areoroti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nauquiche tütaneneca tato, namanaiña manuma üriatu sacerdoterrü ichepe manuma mamayoreca israelitarrü iyoberabaramacü tatito, nauqui chépe apachema niquiubuma causane nauqui aitabairomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tomoenoti uimia y süromatü aübuti naqui aitorrimianamati ümoti yüriaburrü rromanorrü, nürirrti Poncio Pilato. ");
INSERT INTO caxNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Auqui arrti Judas, naqui uiche aipiaventecanatiti Jesús, tütusio ümoti tiene que aconti Jesús. Cuatü ümoti orronene au nitusirrti ui arrüna isamutenti sane. Auqui süroti tato aitorrimianiontiño manio treinta moniquia ümo manuma üriatu sacerdoterrü y arrümanuma mamayoreca. ");
INSERT INTO caxNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nanti ümoma: —Arrüñü tarucu nomünantü sobi, itopiqui ipiaventecacati naqui champü isane nipünatenti. Arrüma iñumutama: —¡Ümochepito soboi, coiñoti te auqui naca! ");
INSERT INTO caxNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Auqui arrti Judas yarutaübutati manu monirri au niporrti Tuparrü. Sürotitü aiñotorrimianatiyü ape y coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Auqui arrümanuma üriatu sacerdoterrü itacümanauncutama manu monirri, namatü: —Chüpuerurrüpü uiña na monirri eana arrüna macumanatarrü ümoti Tuparrü, itopiqui tone te bapacatarrü itobo narapaca notorrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Auqui mapensarama acomporama taman lote ui arrümanu monirri, auna cauta aiñanama cütu bama extrajerurrü. Comprabo uimia arrümanu lote auquiche nantarrü taurrü ui bama masamunuma parropeca. ");
INSERT INTO caxNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sane nauquiche hasta caümainqui nüri arrümanu lote “cürrü itobo notorrü”. ");
INSERT INTO caxNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sane cocono arrümanu nurarrti profetarrü Jeremías tücañe, nauquiche nanti: “Itapeonotama manio treinta moniquia, yapacata bama israelitarrü itoboti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ui arrümanu monirri macomporarama manu cürrü nesarrti maniqui masamunu parropeca. Sane yacüpucurrti Señor”. ");
INSERT INTO caxNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Auqui iquianamati Jesús esati maniqui yüriaburrü Poncio Pilato. Arrti ñanquitioti pünanaquiti Jesús: —¿Ñemanauntu arrücü üratu bama israelitarrü? Iñumutati Jesús: —Arrüñü te. ");
INSERT INTO caxNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Auqui arrümanuma mayüriabuca urabomati Jesús. Pero arrti chümanitanatipü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Auqui nanti Pilato ümoti: —¿Choncoipü arrüna churriampü nurarrüma aemo? ");
INSERT INTO caxNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Chiñumutatipü. Sane nauquiche arrti yüriaburrü Pilato cütobüsoti ui arrüna chiñumutatipü, chümarrtacanapüatai ñapensacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Au manu pierrta parrcua nantarrü arrti yüriaburrü ane nesarrti costumbrerrü ataesümunucuti auqui preso ümoti taman isiu arrüna nirranca macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Au manu tiemporrü anancati au preso maniqui namanaiñamantai isuputaramati, nürirrti Barrabás naqui chiyaupü nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nauquiche tiyoberabaramacü macrirrtianuca, arrti Pilato ñanquitioti pünanaquimia: —¿Quiti naqui aurrianca nauqui ataesübuti auqui preso, arrti Barrabás o arrti Jesús naqui ümoche namatü Cristo? ");
INSERT INTO caxNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ñanquitioti sane, itopiqui tusiatai ümoti que arrüma itorrimianamati Jesús ui arrüna ubatioma bama mayüriabuca. ");
INSERT INTO caxNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nauquiche anancati Pilato tümonsoti nauqui acurrtati, iñatai taman mensaje ümoti ui nicüpostoti, nantü sane: “Tapü asiquia icuata manu noñünrrü champü nipünate, itopiqui nütoba iposiquia icütüpü, uirri tarucapae nirrucu”. ");
INSERT INTO caxNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Arrümanuma üriatu sacerdoterrü ichepe manuma mamayoreca, uimia batacheboma bama macrirrtianuca, na anquirioma nauqui ataesübuti Barrabás auqui preso, tapü arrti Jesús tari comati apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Auqui arrti yüriaburrü Pilato ñanquitioti tatito pünanaqui genterrü: —¿Ñacuti naqui aurrianca na ataesübuti auqui preso sobi, arrti Barrabás o arrti Jesús? Iñumutama macrirrtianuca: —Arrti Barrabás. ");
INSERT INTO caxNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ñanquitioti Pilato: —¿Isane niyachücoi aübuti Jesús naqui nürirrti Cristo? Auqui iñumutama aübu nitosibirrimia: —¡Aiñarrti apü curusürrü! ");
INSERT INTO caxNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Auqui iñumutati Pilato: —¿Isanemo arrüna nipünatenti? Auqui namatü tatito aübu nitosibirrimia: —¡Aicünamunucusurrti apü curusürrü! ");
INSERT INTO caxNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Auqui arrti Poncio Pilato chütusiopü ümoti causane ocümati itacuti Jesús. Nauquiche tarrtaiti tarrüchopüratai ui macrirrtianuca, bacüpuruti iyo turrü nauqui entunumiti isucarü macrirrtianuca aübu nurarrti sane: —Chisaübupüñü niconcorrti naqui ñoñünrrü, itopiqui champü isane nipünatenti. Amasasai aboiyapatoe. ");
INSERT INTO caxNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Auqui namatü aübu nitosibirrimia: —¡Arrüsomü ichepe bama suisaütaiqui rresponsablerrü somü caüma ümo niconcorrti! ");
INSERT INTO caxNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Auqui taesüburuti Barrabás auqui preso uiti Pilato. Bacüpuruti ümo masortaboca na aicübairomati Jesús. Auqui bacüpuruti nauqui aicünamunucunumati apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Auqui sürotitü Jesús ui masortaboca au palacio niporrti yüriaburrü Pilato. Acamanu oberabarama sürümanama masortaboca itupecuti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iquiaübutama naibirrti, nauqui aiñama rroparrü cüturiqui cütüpüti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Auqui iñatama taman tarusürrü cümeca itati. Iñatama ito taman barrton mecuti y bachesoiyoma esati aübu nuncurrüma ümoti, namatü: —¡Taiquiana urria nisüboriquirrti naqui üriatu bama israelitarrü! ");
INSERT INTO caxNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Utureuruma isuti, iquiaübutama nibiarrtonrrti, bacheboma itati uirri. ");
INSERT INTO caxNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nauquiche temeonomati nurria, iquiaübutama manu rroparrü cüturiqui icütüpüquiti. Iñatama tato naibirrti nauqui ariorrüma aübuti aicünamunucunumati apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nauquiche tüsüromatü aübuti, icuñunumati taman ñoñünrrü auqui Cirene, nürirrti Simón; icüpurumati aiquianti nicurusürrti Jesús isiuti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sane nauquiche iñataimia au manu nürirri Gólgota, nantü auqui besüro “nipiai nitanu macoiñoca”. ");
INSERT INTO caxNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Acamanu ichamanamati Jesús vinorrü aübu nansibirri eana. Nauquiche tututenti Jesús arrümanu ñachamatarrüma, champürrtü arriantiqui aichabaoti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Numo tücrabuti uimia apü curusürrü, arrümanuma masortaboca suerteabo uimia arrüba naibirrti. Sane cocono arrümanu nurarrti profetarrü Jeremías tücañe, nauquiche nanti sane: “Suerteabo uimia arrüba nisahibi”. ");
INSERT INTO caxNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Auqui tümonsoma manuma masortaboca, yacuiracarrüma itacuti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ane ito taurarrü, corobo icu arrüna itopiquiche aitabairomati. Nantü sane manu nicororrü: “Tonenti Jesús, naqui üriatu bama israelitarrü”. Icünamunucutama ito apü curusürrü ape pario onü nitanurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Süroma ito torrüma macusüpüca apü nicurusürrüma, tamanti au nepanauncurrti Jesús, arrti quiatarrü au nepaurrti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Arrübama pasaoma esaquiti itatobiromacü aübu nuncurrüma ümoti, ");
INSERT INTO caxNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","namatü: —Arrücü ucanü que puerurrü aiñarrimia niporrti Tuparrü y aiñatünaca tato au trerrü naneneca. Aitaesümunusü obiatoe, arrtü ñemanauntu Aütorrti Tuparrücü, ariacu acü apüqui manu curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sane ito nura manuma üriatu sacerdoterrü ichepe manuma manunecana nüriacarrü y bama mamayoreca, namatü ümomantoe: ");
INSERT INTO caxNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Bayurarati ümo maquiataca, pero ümotiatoe chüpuerurrütipü ayurati. Arrtü üriatu bama israelitarrti, tari yebati acü apüqui manu curusürrü, nauqui uicocoroti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Oncotitü ümoti Tuparrü. Tari yayurati Tuparrü caüma ümoti, arrtü ñemanauntu arrüna nanti oemo que arrti Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sane ito nuncurrüma ümoti manuma macusüpüca aboma apü nicurusürrüma esati. ");
INSERT INTO caxNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Auqui iñatai toce. Auquimanu caüma hasta las trerrü isiu nimümürrü enterurrü tomiquianene icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Auqui tosibicoti Jesús fuerte, nanti: —¿Eli, Eli, lama sabactani? —nantü auqui besüro: ¿Iyaü, Iyaü, causane aiñoconoñü? ");
INSERT INTO caxNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Arrübama amoncoma acamanu oncoimia y namatü: —Amonsoi, babicoti iyoti profetarrü Elías. ");
INSERT INTO caxNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Au manu rratorrü ipiacünotiyü taman uturuquimia aipiancati taman rriese ui vinorrü pichananene, süro uiti icutacu suema. Auqui iñatati ituruti Jesús, nauqui aichabaotipü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero maquiataca namatü: —Asioti sane; basaborira arrtü cuati Elías ocümati itacuti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Auqui tosibicoti tatito Jesús fuerte y coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Au manu rratorrü quiopüro cortina au niporrti Tuparrü cümuintaqui, y paichoconono cürrü y butarubu canca. ");
INSERT INTO caxNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ubaurübo sürümana nicü bama macoiñoca. Nauquiche tüsüboricoti tato Jesús sürümanama süboricoma tato, bama icocoromati Tuparrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Arrüma süromatü au Jerusalén. Acamanu sürümanama macrirrtianuca asaramatü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Auqui arrti capitán ichepe masortaboca bama bacuirarama itacuti Jesús, birrubuma ui na arrtaimia paichoconono cürrü y ausüratai pasabo. Namatü ümomantoe: —Ñemanauntu arrti naqui ñoñünrrü tonenti Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Acamanu amonquio sürümana paüca arrüba cuantio tücañe auqui Galilea isiuti Jesús arrüba payurara ümoti. Arrio amonquio pasabori nanaiña arrüba pasabo auqui icheheñatai. ");
INSERT INTO caxNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Omeana ananca Mariarrü Magdalena, ananca ito Mariarrü nipiacütoti Jacobo y arrti José y arrümanu nipiacüto bama aütorrti Zebedeo. ");
INSERT INTO caxNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nauquiche tütobiquia, cuati maniqui taman ñoñünrrü rricurrü nürirrti José. Arrti auqui manu pueblurrü nürirri Arimatea. Icocorotitito Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Arrti yebotitü esati yüriaburrü Pilato anquirioti pünanaquiti nicunturrti Jesús. Auqui arrti Pilato bacüpuruti na atorri ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Arrti maniqui José icümurriancatati nurria nicunturrti Jesús ui taman cüburrirri bien aseabo. ");
INSERT INTO caxNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Auqui iñatati au manu nusutu canrrü, arrüna pauru uiti ümoti, ümorrtü coiñoti, icüboti. Nauquiche tütaburrio uiti manu nusuturrü ui canrrü sürümanarrü, süroti tato. ");
INSERT INTO caxNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Acamanu ananca ito María Magdalena, ichepe quiatarrü Mariarrü, motümonso esa manu nusuturrü. ");
INSERT INTO caxNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Au manu quiatarrü nanenese nesa macansacarrü (sabaro), arrümanuma üriatu sacerdoterrü ichepe manuma fariseorrü yebomatü esati Pilato, ");
INSERT INTO caxNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","namatü ümoti: —Arrücü yüriaburrücü, suburaboira asucarücü que arrüsomü supaquionca somünqui ümo arrone nanti tücañe maniqui ñapanrrü Jesús, nauquiche süboricotiqui, arrtü tübupasao trerrü naneneca niconcorrti tiene que asüboriti tato. ");
INSERT INTO caxNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sane nauquiche acüpu ümo masortaboca nauqui asegurabo nurria uimia nituru manu nusuturrü cauta ane nicunturrti, y nauqui acuirama itacu cheperrtü bupasao manio trerrü naneneca. Tapü cuamatü bama ñanunecasarrti au tobirri aicusüpüriuma nicunturrti. Sane caüma puerurrüpü uraboimia isucarü macrirrtianuca que süboricoti tato. Auqui caüma manrrü tarucu arrüna mapancarrü pünanaqui arrümanu primero. ");
INSERT INTO caxNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Auqui arrti Pilato nanti ümoma: —Rracüpura ümo masortaboca nauqui aüromatü acuirama itacu manu nusuturrü auchepe. Amecosi te asegurabo nurria aboi isiu naca arrüna puerurrü año. ");
INSERT INTO caxNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Auqui arrümanuma üriatu sacerdoterrü süromatü aübu masortaboca na acuirama itacu manu nusuturrü nauqui asegurabo uimia. Iñama ito arrüna uiche emana manu canrrü nitaburri manu nusuturrü, na atusi arrtü pocoro tato. Auqui süroma tato manuma mayüriabuca, tapü masortaboca onconoma acamanu acuirama itacu. ");
INSERT INTO caxNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iñatai manu nanenese tominco. Aübapae anene sürotü María Magdalena ichepe quiatarrü Mariarrü amasabori ümo nicürrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Au manu rratorrü paichoconono cürrü, abu ta niyequirrti taman ángel auqui napese uiti Señor, nauqui aiquiaübuti manu canrrü ituruqui nusuturrü. Nauquiche tücarübu uiti manu canrrü, tümonsoti onü. ");
INSERT INTO caxNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anentarrtai nacarrti y naibirriti champü tacanache nipurusubiquirri. ");
INSERT INTO caxNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nauquiche tarrtaimia masortaboca arrüna sane, paichocononoma ui nirrucurrüma y süsioma tacana coiñoma. ");
INSERT INTO caxNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Opiñatai acamanu manio paüca. Auqui nanti ángel ñome: —¡Tapü aupirruca! Tusio iñemo que apapachequiucati Jesús naqui süroti apü curusürrü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Champütiqui auna, tüsüboricoti tato. Supia ausiapata apasabori auna cauta aiñanamati. ");
INSERT INTO caxNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Amecosi tato apuraurraño aburaboi isucarü bama ñanunecasarrti sane: “Tüsüboricoti tato eanaqui macoiñoca y tiene que acusürüti ariorrti au Galilea amopünanaqui. Taha tiene que amasarati”. Ümo isetü suraboi ausucarü. Sane nanti ángel ñome manio paüca. ");
INSERT INTO caxNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Auqui omenotü esaqui nusuturrü apuraurrio nurria tanu aübu yupirrucurrü y tacane tarucu niñupucünuncurrü aburaboi isucarü bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Au manu rratorrü itusiancanatiyü Jesús yusucarü. Manquioti nurria ñome. Auqui arrio panaunu ümoti, opitañumenio nurria nipoperrti. ");
INSERT INTO caxNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Arrti nanti ñome: —Tapü aupirruca. Amecosi aburaboi isucarü bama masaruquitaiqui, tari yeracamatü au Galilea arrüperama isümenuñü, nauqui asaramañü. ");
INSERT INTO caxNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nauquiche tomenotü manio paüca, aboma bama eanaqui manuma masortaboca süroma tato au pueblurrü uraboimia isucarü bama üriatu sacerdoterrü nanaiña arrüna pasabo. ");
INSERT INTO caxNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Auqui arrüma süromatü esa bama mamayoreca na aparimia aübuma. Bacheboma chama monirri ümo manuma masortaboca. ");
INSERT INTO caxNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Namatü ümoma: —Arraño aburasoi isucarü genterrü que arrübama ñanunecasarrti Jesús icusüpütiuma nicunturrti, nauquiche amoncaño aumpanuca. ");
INSERT INTO caxNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Arrtü ipiatenti yüriaburrü arrüna sane, supapariquia nurria aübuti, tapü tüboricoti aume. ");
INSERT INTO caxNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Auqui arrümanuma masortaboca isamutema isiu arrümanu nurarrüma ümoma. Yasutiuma manu chama monirri. Sane nauquiche arrübama israelitarrü icocotama hasta caümainqui. ");
INSERT INTO caxNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sane nauquiche arrümanuma once ñanunecasarrti, süromatü au Galilea onü manu yiriturrü, auna cauta tiene que asaramati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nauquiche tasaramati, manaunuma ümoti. Pero aboma bama chicocotapü nurria arrtü tonenti. ");
INSERT INTO caxNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Arrti Jesús sürotitü esama, nanti ümoma: —Ane nisüriaca caüma au napese y auna ito icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sane nauquiche amecosi au nanaiñantai icu na cürrü. Apiñununecasama macrirrtianuca nauqui aicocoromañü. Apaunimia ümoma au nürirrti naqui Uyaü, au nisüri, y au nürirri naqui Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Apiñununecasama ito na acoconauma ümo arrüna nirracüpucu aume. Tapü tacürusu ito napaquionco iyo arrüna sane: Arrüñüü yaca auchepe cheperrtü tiñatai ñapacümuncuturrti Tuparrü. Amén.");
INSERT INTO caxNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sane numo aübo ane arrüna champü tacanache manitacarrü icütüpüti Jesucristo, naqui Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Uiti profeterrü Isaías tücañe ane corobo sane: Sane nurarrti Tuparrü ümoti Cristo: Rracüpuca ümoti taman niyesa coreorrü acusürüti apünanaquicü, nauqui aicoñocoti cutubiurrü acümenucü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Rabotü taman tosibirri eana rroense, nantü sane: “Apicoñoco cutubiurrü cümenuti Señor, apipesünaca nurria”. (Tone arrüna corobo uiti profetarrü Isaías tücañe.) ");
INSERT INTO caxNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Arrüna sane nurarrti cocono nauquiche cuati Juan Bautista. Uiti maniqui Juan Bautista ürioma macrirrtianuca eana turrü au manu rroense. Manunecanati ümoma sane: —Apiñorroncosaño. Apicoñoco nausübori aübuti Tuparrü, nauqui puerurrü abüriquia sobi, y sane caüma rrimiacana tato uiti Tuparrü arrüba nomünantü aboi. ");
INSERT INTO caxNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sane nauquiche cuamatü namanaiña macrirrtianuca esati Juan auqui manu cürrü nürirri Judea y auqui manu pueblurrü Jerusalén. Urabomacü, y sane ürioma uiti au manu sapoco nürirri Jordán. ");
INSERT INTO caxNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Naibirrti Juan tücañe niqui manu numuquianrrü nürirri camello. Nipoñoentorrti taquirri. Niyaratarrti nubasoroca y nuhurrü eanaqui nüunrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aübu arrüna ñanunecacarrti ümo macrirrtianuca nanti sane: —Cuatiqui isiuñü naqui ane manrrü nüriacarrti rropünanaquiñü. Arrüñü champü isane niyaca, ni puerurrüpü isoquisünapü nehe nisapaturrti. ");
INSERT INTO caxNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Arrüñü rraunimiaca aume ui turrtai. Tapü arrti tiene que aunimiati aume uiti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Au manio naneneca arrti Jesús cuatati auqui manu pueblurrü nürirri Nazaret, ane au manu cürrü Galilea. Arrti ürioti uiti Juan au manu sapoco nürirri Jordán. ");
INSERT INTO caxNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nauquiche tücuati tato Jesús taiyiritu eanaqui turrü, arrtaiti napese aurübo. Auqui asaratitü ümoti Espíritu Santo, cuati onüti auqui napese tacana naca nututaquimia. ");
INSERT INTO caxNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Rabotito manitacarrü auqui napese, nantü sane: —Arrücü isaücü. Tarucu nacua iñemo. Ipucünuncatai acuatacü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Auqui arrti Espíritu Santo iquianatiti Jesús eana rroense, auna cauta abe numuquianca naurri rroense. ");
INSERT INTO caxNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Taha anancati ñome cuarenta naneneca. Auqui cuatitü choborese esati aübu ñacocotorrti ümoti. (Pero arrti Jesús champürrtü batacheboti uiti.) Auqui cuamatü bama angelerrü esati nauqui aserebimia ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nauquiche tiñanamati Juan Bautista au preso, arrti Jesús sürotitü au Galilea. Manunecanati arrüba omirria manitacaca icütüpü nüriacarrti Tuparrü ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Manunecanati sane: —Chauqui tiñatai arrüna tiemporrü nauqui üriabucati Tuparrü. Apicoñoco nausüboriqui aübuti. Apicoco arrüna urria manitacarrü, nauqui puerurrü autaesübu eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Taman nanenese anancati Jesús amencoti abeu manu narubaitu turrü au manu cürrü Galilea. Auqui asaratitü ümoti Simón ichepeti yaruquitorrti, nürirrti Andrés. Arrüma batrabacarama, yasucurrüma nopiocorrü ui nimomesüma. Tone niyachücoimia. ");
INSERT INTO caxNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Auqui nanti Jesús ümoma: —¡Ausiapata isiuñü! Irranca iñunecanaño apacaübu mañoñünca eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Au manu rratorrü arrümanuma torrü iñocotama nimomesüma. Süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Auqui sürotitito manrrü tahaiqui pario. Asaratitito ümoti Jacobo ichepeti yaruquitorrti, nürirrti Juan. Tonema aütorrti Zebedeo. Amoncoma au nesarrüma canoarrü, icoñocotama nimomesüma. ");
INSERT INTO caxNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tasuruma ito uiti. Auqui süromatito isiuti. Onconoti yaütorrüma uimia. Onconoti ichepe bama ayuranterrü au nesarrüma canoarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iñataimia au manu pueblurrü nürirri Capernaum. Au manu nanenese nesa macansacarrü sürotitü au manu porrü sinagoga auna cauta nantarrü meaboma. Acamanu manunecanati ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Arrümanu genterrü cütobüso ui arrüna nurarrti ümoma, itopiqui manitanati tacanati naqui chiyaupü nüriacarrti. Arrümanio nurarrti champürrtü tacana nurarrüma bama maestro ümo nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Au manu porrü sinagoga anancatito taman ñoñünrrü naqui anati choborese auti. Au manu rratorrü tosibicoti, nanti sane: —¿Causane ayetü tauna suichepe, arrücü Jesús auqui Nazaret? ");
INSERT INTO caxNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¿Ayecatü nauqui aitabairosomü? Tusio iñemo, arrücü aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Arrti Jesús icuansomoconotiti choborese, nanti ümoti: —¡Etaiquei, acosi auquiti naqui ñoñünrrü! ");
INSERT INTO caxNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Auqui arrti maniqui ñoñünrrü simia niconcorrti uiti choborese, tosibicoti arrone nurria. Auqui sürotitü choborese auquiti. ");
INSERT INTO caxNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Namanaiña cütobüsoma y namatü ümomantoe: —¿Isane arrüna sane? ¿Isanempü naca arrüna nuevurrü manunecatarrü? Arrti naqui ñoñünrrü ane nüriacarrti, nauqui acüputi ümo bama machoboreca, y arrüma icocotama nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Contoatai ipiatema nürirrti Jesús au nanaiña cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nauquiche tücuati tato türüpo Jesús auqui sinagoga, sürotitü ichepeti Jacobo y arrti Juan au niporrti Simón y arrti Andrés. ");
INSERT INTO caxNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Arrümanu nipiacüstoti Simón ananca barücüro, pacütayo. Auqui urapoimia isucarüti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Arrti sürotitü esa. Iñentati nehese y iñatünaiñacatati. Au manu rratorrü pasao nipiacütaiquirri pünanaqui. Auqui mapemana ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nauquiche aübapae ütobi, bacarrearama esati Jesús bama maunrrocono y arrübama anati choborese auma. ");
INSERT INTO caxNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Namanaiña bama macrirrtianuca auqui manu pueblurrü cuamatü abeu tururrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Arrti Jesús bacurarati ümo manuma sürümana maunrrocono, aruqui nanaiña norrocorrü ane ümoma. Bacüpurutito ümo bama machoboreca auqui macrirrtianuca. Chichebopü na anitama machoboreca uiti, itopiqui arrüma tisuputaramati. ");
INSERT INTO caxNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tansürapae quiatarrü nanenese arrti Jesús sürotitito auqui manu pueblurrü. Sürotitü tamanti auna cauta champü macrirrtianuca. Taha meaboti ümoti Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Auqui arrti Simón sürotitü ichepe bama icumpañeruturrti apacheriurumati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nauquiche tütabücoti uimia, namatü ümoti: —Namanaiña yapacheriurumacü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aiñumuti Jesús: —Curi au ba piquiataca puebluca saimiantai, nauqui suraboi ito nurarrti Tuparrü taha. Ümo te isetü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sane nauquiche amencoti au nanaiña manu cürrü Galilea. Urapoiti nurarrti Tuparrü isucarüma au ba poca sinagoga. Bacüpurutito ümo machoboreca auqui macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taman nanenese sürotitü esati Jesús maniqui ñoñünrrü maunrroconoti ui lepra. Aiñanainti esati. Achesoiti esati. Nanti ümoti: —Arrtü arrianca puerurrü aicurarañü. ");
INSERT INTO caxNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Arrti Jesús pucürusuti itacuti. Iñenotiti, nanti ümoti: —Abu irranca. Chauqui turriancü tato sobi. ");
INSERT INTO caxNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Isiu manu nurarrti arrti maniqui maunrrocono urriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Auqui arrti Jesús masamunuti nariorrü ümoti. Pero bacüpuruti nurria ümoti, nanti: ");
INSERT INTO caxNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Tapü urapoi isucarüti quiatarrü. Auquina acosi besüro obi aitusiancasü isucarü bama sacerdoterrü, na atusi ümoma turriancü tato. Acumana ito ümoti Tuparrü, tacana arrüna yacüpucurrti Moisés tücañe, nauqui asaraimia macrirrtianuca, arrücü chauqui turriancü tato. ");
INSERT INTO caxNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero arrti maniqui ñoñünrrü nauquiche tüsürotitü, urapoiti isucarü namanaiñantai arrüna pasabo ümoti. Sane nauquiche arrti Jesús chüpuerurrüquipü aitusiancati nurria niyücürrti au ba puebluca. Anatiatai tanu auna cauta champü genterrü. Pero cuatü genterrü auqui nanaiñantai asaramati acamanu ito. ");
INSERT INTO caxNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Omenotü naneneca. Auqui arrti Jesús süroti tato au pueblurrü Capernaum. Chauqui tütusio ümo bama pohoso que arrti anati au porrü. ");
INSERT INTO caxNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Oberabarama sürümanama macrirrtianuca acamanu esati. Ataso uimiapo, y hasta champü camporrü abeu tururrü. Arrti Jesús anati urapoiti nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Auqui iñataimia cuatro mañoñünca aübuti taman maunrrocono, naqui chüpuerurrüpü amenti. ");
INSERT INTO caxNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ui na tarucapae genterrü chüpuerurrüpü aiñanaimia nurria esati Jesús. Sane nauquiche aüromatü ichacu manu porrü. Iponsünatama arrüna cauta anati Jesús. Auqui manu nusuturrü caüma iñanamati acü maniqui maunrrocono esati Jesús aübu nanaiña nicürurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Arrti Jesús tütusiatai ümoti, que arrümanuma mañoñünca oncomatü ümoti. Sane nauquiche nanti ümoti maniqui maunrrocono: —Arrüba nomünantü obi chauqui tümorrimiacana tato sobi. ");
INSERT INTO caxNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Acamanu amoncoma tümonsoma bama maestro ümo nüriacarrü. Arrüma mapensarama au nitusirrimiantai ui arrüna sane; namatü ümomantoe: ");
INSERT INTO caxNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Causane anitati sane naqui ñoñünrrü? Arrti ane nipünatenti aübuti Bae Tuparrü ui arrüna sane, itopiqui champüti puerurrü airrimiacati tato nomünantü; ta cunauntañati Bae Tuparrü naqui puerurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero arrti Jesús tütusiatai ümoti arrüna ñepensatioma. Nanti ümoma: —¿Causane apapensa sane? ");
INSERT INTO caxNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Arrüñü ñemanauncurratoe ñoñünrrü ane nisüriaca auna icu na cürrü nauqui aurrimiaca tato sobi nomünantü. Pero rrepente amucanaño iñemo que rranitacatai. ");
INSERT INTO caxNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sane nauquiche caüma itusiancana ausucarü arrüna nisüriaca; rracurara ümoti naqui ñoñünrrü. Auqui nanti ümoti maniqui maunrrocono: ");
INSERT INTO caxNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—¡Atüsai, aiquia nacüru, acosi tato au napo! ");
INSERT INTO caxNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Au manu rratorrü atüraiti maniqui maunrrocono. Iquiatati nicürurrti, y süroti tato isucarü namanaiña. Sane nauquiche namanaiña cütobüsoma ui arrüna arrtaimia, y iñanaunumati Tuparrü. Namatü: —Champü tübarrtai tacana arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Auqui arrti Jesús süroti tatito abeu narubaitu turrü. Namanaiña macrirrtianuca cuamatü esati, y arrti manunecanati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Auqui sürotitito auqui manu. Auqui namenrrti asaratitü ümoti Leví, aütorrti Alfeo. Anancati tümonsoti au na cauta nantarrü bacobürarama impuestorrü. Nanti Jesús ümoti: —Ariacu isiuñü. Auqui arrti Leví atüraiti y sürotitü isiuti. ");
INSERT INTO caxNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Auqui caüma anancati Jesús basoti ichepe bama ñanunecasarrti au niporrti Leví. Acamanu ito amoncoma basoma ichepeti bama mayacobraca impuestorrü, y bama maquiataca ane nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tapü arrübama maestro ümo nüriacarrü y bama fariseorrü asaramatü ümoti Jesús, basoti ichepe bama mayacobraca impuestorrü y arrübama tarucu nomünantü uimia. Namatü ümo bama ñanunecasarrti: —¿Causane aati ichepe bama mayacobraca impuestorrü y arrübama tarucu nomünantü uimia? ");
INSERT INTO caxNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nauquiche oncoiti Jesús arrüna nurarrüma, nanti ümoma: —Champü nümocheti mercurrü ümo bama urria ümoma, ta ümo bama maunrrocono. Chisecapütü nauqui itasuruma bama urria nisüboriquirrimia, ta ümo bama tarucu nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Au manu nanenese arrübama ñanunecasarrti Juan y arrübama ñanunecasarrüma bama fariseorrü amoncoma ayunaboma. (Chübasopüma ui ñanauncurrüma ümoti Tuparrü.) Auqui süromatü esati Jesús, ñanquitioma pünanaquiti, namatü: —¿Causane arrübama ñanunecasarrti Juan ichepe bama ñanunecasarrüma bama farisoerrü ayunaboma, tapü bama anunecasa basomantai pemacarrü? ");
INSERT INTO caxNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aiñumuti Jesús aübu machepecatarrü ümoma: —Arrüñü ichepecacañü tacanati taman tübübüho. ¿Taqui puerurrüpito ayunabo bama tasuru ümo tübübürrü, arrtü anati naqui itübübüche acamanu ichepema? Arrtü anati acamanu maniqui itübübüche, tiene que aama ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero iñatai ñana manu nanenese auche carübuti pünanaquimia maniqui aübo apo. Auqui caüma ayunaboma. ");
INSERT INTO caxNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Urapoitito quiatarrü machepecatarrü isucarüma: —Champüti naqui marruparriancana nirrürüpütürrti ui arrüna iyebo. Itopiqui iñünanü, y uirri manrrü quiopüro manu pooma rürüpütürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chüpuerurrüpito uiñahübu nuevurrü vinorrü nauqui oco au ba nitaqui numuquianca namoncoca, itopiqui bopobo taquiquia uirri. Ui arrüna sane ensoro vinorrü, y omensoro ito manio taquiquia. Sane nauquiche uiñahübuta nuevurrü vinorrü ubau arrüba abebo taquiquia, tapü bopobo, y tapü arapara vinorrü. (Ichepecatati Jesús manu vinorrü tacana arrüna ñanunecacarrti.) ");
INSERT INTO caxNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Taman nanenese nesa macansacarrü arrti Jesús pasaoti auqui manio ñanaunca. Arrübama ñanunecasarrti baurrtaquioma chimiantai nüta trigo auqui nipiasacarrüma, nauqui aama pario. ");
INSERT INTO caxNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Auqui namatü bama fariseorrü ümoti Jesús: —Asasatü. ¿Causane aisamunema arrüna churriampü au na nanenese nesa macansacarrü? Arrüna sane es trabacorrü. ");
INSERT INTO caxNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Auqui nanti Jesús ümoma: —¿Taqui chülehebopüañoinqui icu Nicororrü arrüna isamutenti David tücañe, nauquiche cürüpüoti ichepe bama icumpañeruturrti. ");
INSERT INTO caxNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Arrti sürotipo au niporrti Tuparrü iyariontiño manio pan mosamamecana, ichepe bama icumpañeruturrti. Abu cunauntaiñamantai bama sacerdoterrü puerurrü arioma. Arrümanu sane pasabo nauquiche yüriaburrti Abiatar ümo bama sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nantito Jesús ümoma: —Arrti Bae Tuparrü icunusüancatati nanenese nesa macansacarrü, nauqui aserebi manu nanenese ümo macrirrtianuca, champürrtü nauqui ataquisürüma uirri. ");
INSERT INTO caxNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Arrüñü Ñemanauncurratoe ñoñünrrü ane nisüriaca ito ümo na nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Auqui arrti Jesús süroti tatito au manu porrü sinagoga auna cauta nantarrtai meaboma. Acamanu anancati taman ñoñünrrü naqui süübatai nehesti. ");
INSERT INTO caxNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tapü arrübama tüboricatai ümoti yarrüpiaramati nurria, averrtü bacurarati au na nanenese nesa macansacarrü, nauqui urabomati. ");
INSERT INTO caxNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Auqui nanti Jesús ümoti maniqui ñoñünrrü süübatai nehesti: —Atüsai, ariacu auna cümuinta. ");
INSERT INTO caxNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Auqui atüraiti maniqui ñoñünrrü, iñanatiyü cümuinta. Auqui ñanquitioti Jesús pünanaqui manuma maquiataca: —¿Isane arrüna urria uisamune au nanenese nesa macansacarrü, arrüna urria o arrüna churriampü? ¿Urria bacuira itacu nisüboriquirrti osüborisapa, o uitabairoti? Pero arrüma champürrtü iñumutama. ");
INSERT INTO caxNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Asaratitü Jesús ümoma, ünantü ümoti. Suchebotito itopiqui champürrtü rranrrüma aicocoma. Auqui nanti ümoti maniqui ñoñünrrü: —¡Aipesünaca nehe! Arrti maniqui ñoñünrrü ipesünacatati nehesti, y au manu rratorrü urrian tato. ");
INSERT INTO caxNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Auqui arrümanuma fariseorrü süromatü türüpo esaquiti Jesús. Mapensarama ichepe bama auqui manu nesarrti partidorrü Herodes, causane nauqui puerurrü aitabairomai Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Auqui arrti Jesús sürotitü ichepe bama ñanunecasarrti abeu manu narubaitu turrü. Süromatito isiuti sürümanama macrirrtianuca auqui manu cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Sürümanama ito bama cuamatü esati auqui manu cürrü Judea, y auqui Jerusalén, auqui manu cürrü Idumea, y auqui topüqui manu sapoco nürirri Jordán, y auqui manio puebluca Sidón y Tiro. Rranrrüma asaramati, itopiqui ipiatema arrüna isamutenti. ");
INSERT INTO caxNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Auqui bacüpuruti ümo bama ñanunecasarrti, nauqui ariorrüma acomorabo uimia taman barco isu turrü ümoti, saimiantai nabeurrü, nauqui atümoti ahu, tapü simianati ui cütüpürrü genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Itopiqui tusio arrüna sürümanama urriancama tato uiti, y eterurrüma bama maunrrocono rranrrüma aiñenomati, nauqui urrianama tato. ");
INSERT INTO caxNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Arrübama aboma machoboreca auma, arrtü asaramatü ümoti Jesús, bachesoyoma esati y tosibicoma, namatü: —¡Arrücü Aütorrti Tuparrü! ");
INSERT INTO caxNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero arrti Jesús arrone nurria yacüpucurrti ümoma, tapü urapoimia quiti naqui. ");
INSERT INTO caxNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Auqui arrti Jesús sürotitü onü taman yiriturrü. Tasuruma uiti arrübama urria au narrtarrti. Aüromatü esati. ");
INSERT INTO caxNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Eanaquimia tacümanauncunuma uiti doce nubuquirrimia, nauqui aboma ichepeti, y nauquito aüromatü uraboimia nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Torrio ito uiti üriacaboma, nauqui acurama ümo bama maunrrocono y nauqui acüpuma ümo bama machoboreca auqui macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tonema arrübama doce: Arrti Simón naqui süro üriboti uiti Jesús Pedro. ");
INSERT INTO caxNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Arrti Jacobo ichepeti yaruquitorrtiatoe, nürirrti Juan. Arrüma tonema bama aütorrti Zebedeo. Nürirrimia ito uiti Jesús “Boanerges”, auqui besüro nantü: “aüto nisüurrü”. ");
INSERT INTO caxNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Arrti Andrés, arrti Jacobo naqui aütorrti Alfeo, arrti Tadeo, arrti Simón naqui auqui manu partidorrü nürirri cananista, ");
INSERT INTO caxNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y arrti Judas Iscariote, naqui uiche aipiaventecanatiti Jesús ñana. Auqui arrti Jesús sürotitü ichepe bama ñanunecasarrti au taman porrü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Acamanu iyoberabaramacü tatito sürümanama macrirrtianuca. Así que arrti Jesús ichepe bama ñanunecasarrti chichebopü ni aapüma ui manu cütüpürrü genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nauquiche ipiatema bama nesarrti familiarrü Jesús, cuamatü nauqui aiquianamati tato, itopiqui aboma bama namatü, arrti chauqui tülocorrtiatai. ");
INSERT INTO caxNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Arrümanuma ito maestro ümo nüriacarrü cuamatü auqui Jerusalén, namatü: —Arrti naqui ñoñünrrü anati Beelzebú auti, naqui üriatu bama machoboreca. ");
INSERT INTO caxNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Auqui arrti Jesús tasuruma uiti, nauqui uraboiti isucarüma arrüna machepecatarrü, nanti sane ümoma: —¿Causane puerurrti choborese acüputi türüpo ümotiatoe? ");
INSERT INTO caxNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Arrtü taman nación bahiyo aübuatoe, arrümanu nación chüpuerurrüpü urura. ");
INSERT INTO caxNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Isiatai pasao aübu taman familiarrü, arrtü tüboricoma ümomantoe. Chüpuerurrüpü urura manu familiarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sane ito arrti choborese, arrtü tüboricoti ümotiatoe, chüpuerurrüpü nauqui ururati, tiene que atacüru nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nantito ümoma arrüna sane: —Chüpuerurrüpito oeropo au niporrti taman ñoñünrrü naqui chiyaupü nicusüurrti, nauqui uiquiaüburio nenarrirrti, arrtü chütomoenotipü osoi. Ta arrtü tomoenoti, auqui caüma puerurrü oeropo uiquiaüburio nenearrirrti. ");
INSERT INTO caxNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ñemanauncurratoe sucanañü aume: Arrüba nomünantü ui mañoñünca puerurrü morrimiacana tato uiti Tuparrü, y nanaiña ito arrüba churriampü ñanitacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tapü arrti naqui manitanati churriampü ümoti Espíritu Santo, champü marrimiacatarrü tato ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sane nurarrti Jesús ümoma, itopiqui namatü que anati choborese auti. ");
INSERT INTO caxNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Auqui iñataimia esati Jesús bama yaruquitorrti y nipiacütoti, pero süsioma türüpo. Auqui itasurumati türüpo. ");
INSERT INTO caxNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Arrümanuma tümonsoma itupecuti Jesús namatü ümoti: —Ane taha türüpo napacüma ichepe bama aruquitaiqui. Yapacheriurumacü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aiñumuti Jesús, nanti: —¿Ñacusane arrüna nipiacü y arrübama masaruquitaiqui? ");
INSERT INTO caxNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Auqui asaratitü nurria ümo manuma tümonsoma acamanu itupecuti, nanti sane: —Arrübama aboma auna, tonema masaruquitaiqui y nipiacü. ");
INSERT INTO caxNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Itopiqui arrti naqui isamute isiu nirrancarrti Tuparrü, tonenti saruqui, niquiasi y nipiacü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Arrti Jesús manunecanati tatito abeu manu narubaitu turrü, y oberabara tatito cütüpürrü genterrü acamanu esati. Sane nauquiche arrti Jesús sürotitü au taman barco nauqui atümoti ahu isu turrü saimiantai nabeurrü. Namanaiña macrirrtianuca aboma eana cüosorrü abeu manu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Auqui manunecanati ümoma aruqui nanaiñantai. Urapoitito isucarüma arrüna machepecatarrü sane: ");
INSERT INTO caxNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Amonsoi arrüna sane: Tamanti ñoñünrrü sürotitü ancütuti au niyorrti. ");
INSERT INTO caxNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Isiu arrüna ñancütucurrti abe arrüba niyoma bupaquio isiu cutubiurrü. Auqui cuantio nutaumanca, yubario. ");
INSERT INTO caxNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Piquiataca bupaquio omeana canca, auna cauta champü nurria cürrü. Ububaüro unrratorrtai, pero charutabaesapü cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sane nauquiche bosübo ui surrü, itopiqui champü niñurranacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Piquiataca bupaquio omeana cümeca. Arrümanio cümeca musunaun y arrümanio plantamanca bosübo ito oboi, y sane chüpuerurrüpü aye oboi. ");
INSERT INTO caxNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero abe arrüba bupaquio au na urria cürrü. Tonehio arrüba musunaun, coñorrtai plantamanca, y auqui iyebo chama. Abe arrüba pachebo treinta niyomanca, y abe ito arrüba pachebo sesenta y piquiataca pachebo cien. ");
INSERT INTO caxNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Auqui nanti Jesús ümoma: —Arraño ane namumasu. ¡Amonsapesio te! ¿Causane anunecati Jesús oboi machepecataca? ");
INSERT INTO caxNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nauquiche tütamanti Jesús ichepe bama ñanunecasarrti y bama maquiataca, ñanquitioma pünanaquiti: —¿Isane ümoche arrüna machepecatarrü? ");
INSERT INTO caxNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Auqui urapoiti isucarüma, nanti: —Aume tiene que atusi uiti Tuparrü isane ümoche arrüba machepecataca apü nüriacarrti. Tapü ümo bama maquiataca tiene que iñununecanama aübu machepecatacatai. ");
INSERT INTO caxNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Itopiqui arrüma asaramatü, pero tacanarrtü supusoma. Onaunrrüma, pero chüsüropü au nitanurraüma. Ui arrüna sane chüpuerurrüpü aiñorronconomacü, nauqui urria tato nisüboriquirrimia aübuti Tuparrü, y ui arrüna sane chüpuerurrüpü amorrimiaca tato nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Auqui nantito ümoma: —Canapae chüsüropü au nautanu arrüna machepecatarrü. ¿Causanempü nauqui aye ito aboi arrüba piquiataca machepecataca? ");
INSERT INTO caxNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Arrti maniqui mancüturu niyo trigo, tacanati naqui manunecana nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aboma bama tacana manio niyo trigo bupaquio isiu cutubiurrü. Cuati choborese iquiaübutati auqui nausasürrüma nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aboma ito bama tacana manio niyo trigo bupaquio omeana canca, auna cauta ane chimiantai cürrü. Oncoimia nurarrti Tuparrü y yasutioma aübu nipucünuncurrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero chipiacapüma asamuma tairri. Iñocotama nurarrti Tuparrü, arrtü aboma bama tüboricoma ümoma ui arrüna ñacoconauncurrüma ümo arrüna urria. ");
INSERT INTO caxNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aboma ito bama maquiataca tacana arrümanio niyo trigo bupaquio omeana cümeca. Arrüma oncoimia nurarrti Tuparrü, ");
INSERT INTO caxNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero tarucapae nirrancarrüma nauqui ane nenarrirrimia icu na cürrü. Tarucu penarrü uimia iyo aruqui nanaiñantai. Ui arrüna sane oncono uimia ñacoconauncurrüma ümoti Tuparrü, y sane chüpuerurrüpü nauqui ane arrüna nurria uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero aboma ito bama oncoimia nurarrti Tuparrü, icocotama y isamutema arrüna urria. Arrüma tacan arrümanio niyoca bupaquio au na urria cürrü, arrüba pachebo treinta granorrü, y sesenta y cien. ");
INSERT INTO caxNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Auqui nantito Jesús ümoma: —¿Aensapü uiñonocota basarurrü nauqui uitamurriquia ui siucurrü o uiña iquiana cürurrü? No, ta uiñata ape nauqui anentarrü uirri ümo bama abomampo. ");
INSERT INTO caxNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sane ito champü arrüna anecanatai, tiene que atusi ñana. Nanaiña arrüna chütusiopü caüma, pero ta tusiatai ñana. ");
INSERT INTO caxNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Arraño ane namumasu; tari amonsapesio nurria. ");
INSERT INTO caxNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nantito Jesús ümoma: —Amasasai nurria isiu arrüna amoncoi. Arrtü apisamute isiu nisura, torrio manrrü apapanauncubu uiti Tuparrü, sane nauqui atusi nurria aume. ");
INSERT INTO caxNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Itopiqui arrti naqui oncoi, tusio ümoti, y tiene que atorriqui manrrü ipiacaboti. Tapü arrti naqui chütusiopü ümoti, tiene que acaübu pünanaquiti hasta tusio pario ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nantito Jesús ümoma: —Arrüna nüriacarrti Tuparrü oemo tacanati taman ñoñünrrü mancüturuti au niyorrti. ");
INSERT INTO caxNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nauquiche tüsüro cütu uiti, süroti tato au niporrti. Tobiquia manumuti, tansürüca atüraiti. Tapü arrümanu süro cütu ubaüro, y sunaun, pero chütusiopü ümoti causane nauquiche ubaü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Primero ubaüro eanaqui cürrü, cuantio nasuma y nihirri. Auqui püsio, y auqui caüma ütau. Sane nauquiche caüma ane tuburiboti. ");
INSERT INTO caxNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Arrtü tüchauqui, auqui caüma sürotitü aitati, itopiqui chauqui tupubo. ");
INSERT INTO caxNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nantito Jesús ümoma: —Causanempü arrtü üriabucati Tuparrü oemo? ¿Aübuche uichepeca? ");
INSERT INTO caxNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bueno ta tacana taman niyo mostaza, arrüna manrrü chiomancatai niyoma. ");
INSERT INTO caxNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero arrtü süro cütu, sunaun, isamunü manrrü sürümanarrü omeana nanaiña plantaca, aübu sürümana nipiarrü. Ui arrüna sane cuantio nutaumanca apasamu iñusumenubu eana nipiarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sane ñanunecacarrti Jesús ümo macrirrtianuca yupu sürümana machepecataca, isiu naca arrüna iyebo uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chümanitanatipü ümoma mientras chiñatatipü machepecatarrü ümoma. Pero arrtü tamanti ichepe bama ñanunecasarrti, urapoiti isucarüma isane ümoche arrümanio machepecataca. ");
INSERT INTO caxNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Au manu nanenese nauquiche tütobiquia, nanti Jesús ümo bama ñanunecasarrti: —Curi topü na narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Auqui iquianamati au taman barco. Macrirrtianuca onconoma uimia, pero aboma bama süromatü ichepeti ubau piquiataca barcoca. ");
INSERT INTO caxNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nauquiche taboma isu turrü, cuatü maquiütürrü fuerte. Pocoro turrü uirri, y supiuru au barco. Tüsaipü ata uirri. ");
INSERT INTO caxNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tapü arrti Jesús anancati manumuti onü taman cabezerarrü au niyoto barco. Auqui airrtopünanamati, namatü ümoti: —¡Maestro! ¿Champü nümoche obi arrüna tirranrrü uyubaca? ");
INSERT INTO caxNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Auqui atüraiti Jesús. Icuansomocotati maquiütürrü y ümo turrü. Nanti ümo: —¡Etaiquei! Au manu rratorrü tochenco maquiütücürrü y chüpocoroiquipü turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Auqui nanti ümo bama ñanunecasarrti: —¿Causane tarucu naupirrucu? ¿Chapicococapüñünqui? ");
INSERT INTO caxNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Arrüma cütobüsoma. Namatü ümomantoe: —¿Isanempü nacarrti naqui ñoñünrrü? ¡Itopiqui hasta maquiütürrü y turrü omoncoi nurarrti! ");
INSERT INTO caxNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tiñataimia topü narubaitu manu turrü au manu cürrü nürirri Gadara. ");
INSERT INTO caxNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Numo tübajaboti Jesús auqui manu barco, cuati taman ñoñünrrü auqui panteón naqui anati choborese auti. ");
INSERT INTO caxNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Arrti maniqui ñoñünrrü bavivicoti eana nicü bama macoiñoca. Champüti puerurrü aitomoenotiti, ni uipü carenarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Itopiqui ane nauche motomoeno nurria ui bama pohoso neherrti y nipoperrti ui carenarrü, pero champü nacarrü ümoti. Botopüro uiti. Champüti naqui puerurrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tobiquia y naneneca nitosibirrti uturu nicü bama macoiñoca. Amencotiatai ubuturu yirituca. Obürio ümoti uirrtiatoe oboi canca. ");
INSERT INTO caxNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nauquiche asaratitü cümenuti Jesús auqui iche, ipiacünotiyü cümenuti. Bachesoiyoti esati. ");
INSERT INTO caxNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tosibicoti nurria, nanti ümoti: —¿Isane ümocheñü obi? Arrücü Aütorrti yarusürürrü Tuparrü. Rranquiquia apünanaquicü au nürirrti Tuparrü, tapü ane causane obi iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Manitanati sane, itopiqui arrti Jesús chauqui tünanti ümoti sane: —¡Arrücü choborese acosi auquiti naqui ñoñünrrü! ");
INSERT INTO caxNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Auqui ñanquitioti Jesús pünanaquiti maniqui choborese: —¿Isane nüri? Aiñumuti: —Arrüñü nisüri Diez Mil, itopiqui sürümana somü subaca auti naqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Auqui ñanquitioma machoboreca pünanaquiti Jesús tapü bacüpuruti ümoma auqui manu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Acamanu saimia manu yiriturrü amonquio sürümana nupaucheca, bubaso. ");
INSERT INTO caxNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Auqui arrümanuma machoboreca ñanquitioma pünanaquiti Jesús, namatü sane: —Aicüpusu somü ubau manio nupaucheca. Suirranca somenotü ubau. ");
INSERT INTO caxNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Torrio uiti ümoma. Süromatü manuma machoboreca ubau manio nupaucheca. Uirri caüma arrümanio nupaucheca rrepenteatai opipiacünaño esaqui manu yiriturrü. Bupaquio eana turrü y ububacara. Enterurrü mocoiño, nububiquirri taqui dos mil. ");
INSERT INTO caxNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Auqui arrümanuma bacuirara yutacu besüburuma ui nirrucurüma. Süromatü uraboimia arrüna pasabo au pueblurrü y au camporrü. Sane nauquiche namanaiña macrirrtianuca süromatü asaborimia ümo arrüna pasabo. ");
INSERT INTO caxNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nauquiche iñataimia esati Jesús, besüro narrtarrüma ümoti maniqui ñoñünrrü, maniqui amoncoma tücañe machoboreca auti. Anati tümonsoti y ane naibirrti. Urriampae nisüboriquirrti, champü causane. Arrümanuma macrirrtianuca chauqui tübirrubuma. ");
INSERT INTO caxNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Acamanu amoncoma bama arrtaimia arrüna pasabo ümoti maniqui ñoñünrrü y ñome manio nupaucheca. Arrüma urapoimia isucarü genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Auqui namatü macrirrtianuca ümoti Jesús: —Asamu nurria suiñemo, acosi auquina subarrüpecuqui. ");
INSERT INTO caxNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nauquiche tüsüroti tato Jesús au manu barco, nanti maniqui ñoñünrrü, naqui amoncomatücaü machoboreca auti: —Irranca yero tanu asiucü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero arrti Jesús chirranrrtipü. Nanti ümoti: —Acosi tato au napo esa bama apariente. Urasoi isucarüma arrüna isamutenti Bae Tuparrü aemo. Itopiqui uiti urrian tato nasüboriqui, itopiqui ataquisürüca ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Auqui arrti maniqui ñoñünrrü sürotitü uraboiti arrüna isamutenti Jesús ümoti au nanaiña puebluca au manu cürrü nürirri Diez Puebluca. Sane nauquiche namanaiña macrirrtianuca cütobüsoma uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nauquiche tütompücatama tatito manu narubaitu turrü, cuamatü tatito sürümanama macrirrtianuca esati Jesús abeu manu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Auqui iñataiti taman ñoñünrrü, nüriatu manu porrü sinagoga acamanu, nürirrti Jairo. Nauquiche asaratitü ümoti Jesús, sürotitü esati, bachesoiyoti, ");
INSERT INTO caxNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","itaquisününancanatiyü nurria esati, nanti ümoti: —Tüsaiyapae acon nichaquiumucu. Ariacu aiña nehe onü, nauqui urriane tato. ");
INSERT INTO caxNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Auqui arrti Jesús sürotitü ichepeti. Sürümanama ito macrirrtianuca süromatü. Sane nauquiche simianati ui tarucapae nubiquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Acamanu eanama ananca taman paürrü maunrrocono. Tütabe doce añorrü narapaca notarrü. Tananca mecu sürümana mamercuca, pero churriantempü tato uimia. Tarucapae nitaquisürücürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chauqui tücarrtao uirri nanaiña nenarrirri y ümonatai yapacacarrü. Más bien manrrü tarucu ümo. ");
INSERT INTO caxNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Arrümanu paürrü nauquiche oncoi nürirrti Jesús, sürotü esati ichacuquitiatai eana manu genterrü, nauqui aiñe pario naibirrti. ");
INSERT INTO caxNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nantü ümoantoe: —Arrtü iñenta pario naibirri, urriancañü tato. ");
INSERT INTO caxNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nauquiche tiñenta naibirrti, au manu rratorrü tochenco narapaca notorrü. Onquisio chauqui turrian tato ümo. ");
INSERT INTO caxNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pero arrti Jesús tusiatai ümoti que ane taman urriante tato ui nicusüurrti. Asarati tato chacuti, ñanquitioti: —¿Ñacuti iñentati nisahibi? ");
INSERT INTO caxNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Auqui namatü ümoti bama ñanunecasarrti: —Chauqui tarrtai arrüna isimianamacüatai macrirrtianuca. ¿Causane anquirio quiti iñenta nahibi? ");
INSERT INTO caxNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Auqui arrti Jesús asaratitü itupecuti, nirrancarrti atusi ümoti quiti iñentati naibirrti. ");
INSERT INTO caxNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Arrümanu paürrü paichoconono ui nirrucurrü ui arrüna pasabo ümo. Sane nauquiche sürotü esati, bachesoiyo, y urapoi nanaiña arrüna pasabo ümo. ");
INSERT INTO caxNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Auqui nanti ümo: —Arrücü ataquisürüca iñemo. Chauqui turriancü tato, itopiqui aicococañü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nauquiche anancatiqui manitanati Jesús ümo manu paürrü, iñataimia auqui niporrti maniqui yüriaburrü Jairo, niyupu manu cupiquirri. Uraboimia isucarüti Jairo arrüna sane: —Chauqui tücoiño nataquiumucu. Tapü asiquiaiqui anqui pünanaquiti naqui maestro. ");
INSERT INTO caxNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Arrti Jesús oncoiti nurarrüma, pero champü nümoche uiti. Nanti ümoti maniqui yüriaburrü: —Tapü airruca, aicocosoñüantai. ");
INSERT INTO caxNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Arrti Jesús chirranrrtipü nauqui aüromatü arrübama maquiataca isiuti, ta cunauntaiñatiatai Pedro, arrti Jacobo y arrti Juan yaruquitorrti Jacobo. ");
INSERT INTO caxNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nauquiche iñataimia au niporrti Jairo, arrüchopüratai ui macrirrtianuca. Tosibicoma y areoroma. ");
INSERT INTO caxNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Arrti Jesús sürotipo y nanti ümoma: —¿Causane autosibiquiatai y abareocatai? Arrüna cupiquirri champürrtü coiño, ta ane manumu. ");
INSERT INTO caxNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Arrüma iyapoimiantai ui arrümanu nurarrti sane. Pero arrti bacüpuruti ümoma, nauqui ariorrüma türüpo namanaiña. Auqui iquianatiti Jairo naqui niyupurrü manu cupiquirri y nipiaparrü y arrümanuma trerrü ñanunecasarrti. Süromampo auna cauta ananca nicuntu manu cupiquirri. ");
INSERT INTO caxNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iñentati nehese, y nanti ümo: —Talita cumi —nantü auqui besüro: Cupiquirri, atüsai. ");
INSERT INTO caxNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Au manu rratorrü manu cupiquirri atürai y amenco. Ane doce añorrü ümo. Ui manu sane cütobüso nurria genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Auqui nanti Jesús ümoma: —Tapü aburapoi arrüna pasabo one. Auqui bacüpuruti ümoma, nauqui asapanema manu cupiquirri. ");
INSERT INTO caxNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Auqui taha süroti tato Jesús au nesarrti pueblurrü, nürirri Nazaret. Süromatü ichepeti bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nauquiche tiñatai manu nanenese nesa macansacarrü, sürotitü anunecati au manu porrü sinagoga. Arrübama oncoi nurarrti, cütobüsoma. Namatü: —¿Causanempü aipiati naqui ñoñünrrü nanaiña arrüba urapoboiboti? ¿Causanempü torrinauncu uiti Bae Tuparrü arrüna ipiacaboti y arrüba milagrorrü omirriante uiti? ");
INSERT INTO caxNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Abu auquinantiatai, carpinterurrti, aüto Mariarrü, naqui yaruquitorrti Jacobo, José, Judas y arrti Simón. Y arrüba niquiastoti bopohoso ito auna uyarrüpecu. Sane nurarrüma. Chirranrrüpüma aicocoromati. ");
INSERT INTO caxNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nanti Jesús ümoma: —Namanaiña bama profeterrü cuamatü auqui iche uraboimia nurarrti Tuparrü, bien cuasürüma aume. Tapü arrti naqui auposapa auquina abarrüpecuqui, ta chapicococatipü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sane nauquiche chümasamunutiquipü milagrorrü acamanu. Solamenterrü iñatati neherrti onü bama mümanamantai maunrrocono. Urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Cütobüsoti itopiqui chicocotapüma nurarrti. Auqui amencoti au manio poca samiantai. Manunecanati. ");
INSERT INTO caxNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Auquimanu batasuruti ümo manuma doce ñanunecasarrti. Bacüpuruti ümoma taiquiana torrüma, y bacheboti üriacaboma nauqui acüpuma ümo machoboreca auqui macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bacüpuruti ümoma tapü ane isane macanama itapiquiboma isiu cutubiurrü, ni monirripito, y tapü macanama ito torrü naibirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bacüpurutito acama ibiarrtoboma y sapaturrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nanti ümoma: —Arrtü alojabo año au taman porrü, abasiquia acamanu cheperrtü amencatito auqui manu pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Arrtü ane taman pueblurrü cauta chirranrrüpüma macrirrtianuca asuriuruma año, y arrtü chirranrrüpüma oncoimia arrüna napanunecaca, amecosi auqui manu y apicütobi naupope ñünana cütorrü, na atusi ümoma que ane nipünatema. ");
INSERT INTO caxNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chauqui nurarrti Jesús ümoma, süromatü uraboimia ümo namanaiña macrirrtianuca nauqui aiñorronconomacü isucarüti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bacüpuruma ito ümo machoboreca, nauqui ariorrüma auqui macrirrtianuca. Isematama nasaite icuta bama maunrrocono, y urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Arrti yüriaburrü Herodes ipiatenti nanaiña arrüna sane, itopiqui namanaiña macrirrtianuca toncoimia nürirrti Jesús. Arrti Herodes nanti: —Arrti Jesús, tonenti Juan Bautista, süboricoti tato eanaqui macoiñoca. Sane nauquiche ane nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Maquiataca namatü: —Arrti maniqui ñoñünrrü Jesús tonenti profetarrü Elías. Maquiataca namatü: —Arrti naqui profetarrti isiu naca bama profetarrü tücañe, bama manitanama ito au nürirrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tapü arrti Herodes, nauquiche toncoiti arrüna piaracarrü, nanti: —Arrti naqui ñoñünrrü Jesús tonenti Juan Bautista, naqui rracüpuca atüsoquiti iyo nitanurrti tücañe. Tonenti naqui süborico tato. ");
INSERT INTO caxNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Taipü arrüna sane pasaotücaü auqui naca manu paürrü Herodía. Bacüpuruti Herodes nauqui enti Juan Bautista, nauqui atomoenti oboi carenaca au preso. Itopiqui arrümanu Herodías nicüpostoti tücañe Felipe, yaruquitorrti Herodes. Auqui arrti Herodes posoti aübu. ");
INSERT INTO caxNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Auqui arrti Juan nanti ümoti Herodes: —Churriampü aiquia acüposübocü nicüpostoti aruqui. ");
INSERT INTO caxNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sane nauquiche tüborico Herodías ümoti Juan. Rranrrü aitabairoti. Pero chüpuerurrüpü, itopiqui tusio ümoti Herodes que arrti Juan urria nisüboriquirrti, y birrubuti ñünanati, itopiqui arrti yacüpusurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Bacuirarati nurria itacuti Juan au preso ñünana Herodías. Arrchopüratai au nitanurrti Herodes ui nurarrti Juan, pero ta rranrrti oncoiti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Auqui iñatai arrümanu nanenese auche puerurrü aisamune Herodías isiu nirrancarrü. Arrti Herodes masamunuti pierrta ümo nesarrti cumpleañorrü. Batasuruti ümo arrübama mayüriabuca ichepe arrübama üriatu masortaboca y arrübama rricurü auqui Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Auqui arrümanu nicheche Herodías cuatü esama. Tocoso isucarüma. Arrümanu nitococorrü urriampae ümoti yüraburrü Herodes y ümo arrübama tasuru uiti. Nanti Herodes ümo manu cupiquirri: —Anqui rropünanaqui isiu narrianca, ichücü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Itusiancatati curusürrü isucarü na aicoco. Puerurrti aitorrimiati ümo isiu arrüna ñanquitio, champü nacarrü ümoti arrtü ñanquitio cümuinta arrümanu cürrü cauta anati üriabucati. ");
INSERT INTO caxNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Au manu rratorrü manu cupiquirri sürotü anquirio pünanaqui nipiaparrü. Nantü ümo: —¿Isanempü arrüna rranquitomoebo pünanaqui nüriaburrü? Nantü nipiaparrü ümo: —¡Anquisio pünanaqui nitanu Juan Bautista! ");
INSERT INTO caxNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Auqui süro tato esati yüriaburrü, nantü ümoti: —Irranca nauqui aitorrimia iñemo nitanu Juan Bautista au taman praturrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Auqui sucheboti yüriaburrü ui manu ñanquiquirri pünanaquiti, pero chauqui titusiancatati curusürrü isucarü y isucarü bama tarusu uiti. Sane nauquiche icocotatiatai. ");
INSERT INTO caxNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Au manu rratorrü bacüpuruti ümoti taman sortaborrü nauqui aitüsoquirotiti Juan iyo nitanurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sürotitü maniqui sortaborrü auna cauta anancati presoti Juan. Itüsoquirotiti iyo nitanurrti. Iquiatati tato au taman praturrü. Itorrimiatati ümo manu cupiquirri. Tone itorrimiata ümo nipiaparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nauquiche tütusio ümo bama ñanunecasarrti Juan, süromatü aiquiama nicunturrti, nauqui aiñanamati cütu. ");
INSERT INTO caxNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Arrübama doce ñanunecasarrti Jesús cuama tato esati. Acamanu urapoimia isucarüti nanaiña arrüna nisamutema y arrüna ñanunecacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nanti Jesús ümoma: —Ausiapata, curi macansa baeta auna cauta champü genterrü. Itopiqui sürümanama macrirrtianuca süromatü esaquiti y maquiataca iñataimia; sane enterurrü sapese. Ni anempü tiemporrü nauqui aama. ");
INSERT INTO caxNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Auqui sürotitü ichepema auna cauta champü genterrü au taman barco isuqui turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sürümanama bama asaramatü isiuma. Sane nauquiche tusio ümo macrirrtianuca arrüna cauta niyücürrti Jesús ichepe bama ñanunecasarrti au barco. Auqui süromatü macrirrtianuca auna cauta niyücürrti, yarucurrümantai isiuqui nabeu turrü. Cuamatito auqui manio puebluca saimia, y cusürüboma aiñanaimia auna cauta niyücürrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nauquiche saliboti Jesús auqui barco, asaratitü ümo sürümanama macrirrtianuca. Taquisürümantai ümoti, itopiqui arrüma tacana nobirraca champüti bacuirara yutacu. Auqui manunecanati ümoma aruqui nanaiñantai. ");
INSERT INTO caxNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nauquiche tütümümüca, cuamatü esati Jesús bama ñanunecasarrti. Namatü ümoti: —Chauqui tütümümüca, champü poca auna. ");
INSERT INTO caxNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aicüpusuma macrirrtianuca, nauqui ariorrüma acomporama utuburiboma au ba poca manrrü saimia pario. ");
INSERT INTO caxNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aiñumuti Jesús: —¡Apapache arraño utuburiboma! Auqui namatü: —¿Aensapü puerurrü somü somenotü supacompora pan ümoma nauqui supasaparama? Urriampü pario arrtü anempü soboi docientos denarios. Iñataipü ümoma, pero champü soboi. ");
INSERT INTO caxNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Auqui nanti ümoma: —¿Mantucubo pan abe aboi? Amecosi amasario. Nauquiche tipiacümuncutama, namatü ümoti: —Abe cinco pan y torrü nopiococa. ");
INSERT INTO caxNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Auqui bacüpuruti ümo macrirrtianuca atümoma onü borrü taiquiana urria nubiquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Auqui tümonsoma taiquiana cien y taiquiana cincuenta. ");
INSERT INTO caxNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Auqui arrti Jesús iquianiontiño mecuti manio cinco pan ichepe manio torrü nopiocomanca. Asaratitü ape. Machampiencanati ümoti Tuparrü. Ichepesünatati pan y arrümanio nopiocomanca. Itorrimiatati ümo bama ñanunecasarrti, nauqui rrepartibo uimia ümo nanaiña genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sane namanaiña basoma y abecoma. ");
INSERT INTO caxNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Auqui amontonabo uimia arrüna nisobüraturrüma. Ubataso doce noconoca. ");
INSERT INTO caxNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Arrümanu genterrü ananca baso nubiquirri cinco mil mañoñünca, y amonquio ito paüca y masiomanca. ");
INSERT INTO caxNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Auqui arrti Jesús bacüpuruti ümo bama ñanunecasarrti nauqui aüromatü au barco, nauqui aitompücama manu narubaitu turrü, nauqui aiñanaimia primero pünanaquiti au manu pueblurrü nürirri Betsaida, topü manu turrü. Süromatü. Auqui masamunuti nariorrü ümo macrirrtianuca, y arrüma süromatito. Onconoti tamanti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Auqui sürotitü tamanti onü manu yiriturrü, nauqui anitati aübuti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Arrübama ñanunecasarrti tobiquiama cümuinta turrü au nesarrüma barco, niyücürrüma topü. Tapü arrti Jesús iñataiti tato abeu turrü onüqui yiriturrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Asaratitü isiu bama ñanunecasarrti au nesarrüma barco. Cuestarrü ümoma aeromatü, itopiqui maquiütüca fuerte icümenuma. Tücuatü nanenese iñataiti Jesús isiuma. Amencoti isuqui turrtai. Rranrrtipü apasati besüratai uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Auqui asaramati amencoti isuqui turrü. Namanaiña tosibicoma ui nirrucurrüma, ñaquioncorrüma arrti yausüpürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Auqui manitanati ümoma, nanti sane: —Tapü aupirruca, ta arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Auqui sürotipo au barco esama. Tochenco maquiütürrü. Tapü arrüma tarucu nicütobürrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chütusioiquipü ümoma isane nacarrti, ni uipü manu milagrorrü arrümanio cinco pan. Chiyebopü uimia au na ñaquioncorrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nauquiche tütompücana uimia manu turrü, iñataimia au manu cürrü nürirri Genezaret. Itomoentama nesarrüma barco. ");
INSERT INTO caxNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Acamanu bajaboti Jesús ichepe bama ñanunecasarrti. Arrübama macrirrtianuca auqui manu cürrü tisuputaramati. ");
INSERT INTO caxNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Süromatü yarucurrüma au nanaiña manio poca saimia iyo bama maunrrocono. Auqui iquianama bama maunrrocono icu nicürurrüma esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Au nanaiña arrüna cauta yebotitü, au rranchuca y au puebluca arrübama pohoso iñanama bama maunrrocono au plaza. Arrübama maunrrocono manquioma pünanaquiti nauqui chebo uiti aiñema nabeu naibirrti. Arrübama iñentama urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Auqui süromatü esati Jesús arrübama fariseorrü ichepe bama manunecana nüriacarrü; aübo aiñanaimia auqui Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Arrüma asaramatü ümo bama ñanunecasarrti Jesús basoma aübu nentuquirrimia, champürrtü entunumiuma. ");
INSERT INTO caxNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Itopiqui arrübama fariseorrü ichepe bama israelitarrü chüpuerurrüpü aama aübu nentuquirrimia, itopiqui macoconaurrüma ümo yacüpucurrüma bama antiburrü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Arrtü iñataimia tato au niporrüma auqui na cauta macomporarama utuburiboma, chübasopüma mientras chentunumiupüma. Macoconaunrrüma aruqui nanaiña bacüpucuca. Ipiaubitama ito basoca, pratuca, siucuca. ");
INSERT INTO caxNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Arrübama fariseorrü ichepe bama manunecana nüriacarrü ñanquitioma pünanaquiti Jesús: —¿Causane arrübama anunecasa chicocotapüma yacüpucu bama antiburrü tücañe? Basoma aübu nentuquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aiñumuti Jesús, nanti ümoma: —Bien ñemanauntu nurarrti tücañe profetarrü Isaías. Manitanati abapa bama mañapanca. Sane corobo uiti tücañe: Arrübama macrirrianuca isuasürüca ümoma ui nurarrümantai. Pero au nausasürrüma champürrtü sane. ");
INSERT INTO caxNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Champü yaserebiquirri iñemo, arrtü bachesoyoma yesañü, itopiqui arrümanio ñanunecacarrüma yacüpucu bama mañoñüncatai icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Arraño apiñocota niyacüpucurrti Bae Tuparrü, itopiqui aurrianca apicoco yacüpucu bama macrirrtianuca icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nantito ümoma: —Arraño apipiaca nurria apiñoco niyacüpucurrti Bae Tuparrü, nauqui apisamune isiu naca naurrianca. ");
INSERT INTO caxNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bacüpuruti Moisés tücañe sane: “Tari cuasürüti aemo aüma y napacüma”. Nantito Moisés: “Arrti naqui manitanati churriampü ümoti yaütoti y ümo nipiacütoti, ane bacüpucurrü nauqui aconti ui mayüriabuca”. ");
INSERT INTO caxNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero arraño amucanaño, que puerurrü aburaboi isuracüti aubaü y isucarü naupacü arrüna sane: “Chüpuerurrüpü rrayurarü, itopiqui nanaiña niñenarri chauqui titorrimiata ümoti Tuparrü”. (Auqui ñanitacarrüma namatü “corbán” ümo arrüna sane.) ");
INSERT INTO caxNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Arrtü anati naqui nanti sane, chauqui chicheboiquipü aboi na ayurati ümoti yaütoti y ümo nipiacütoti. ");
INSERT INTO caxNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ui arrüna sane aboi, apiñocota yacüpucurrti Tuparrü yucuata arrüba napacüpucuatoe. ");
INSERT INTO caxNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Auqui manitanati ümo manu cütüpürrü genterrü, nanti: —¡Amonsapesio nurria y apipiase arrüna sucanañe aume: ");
INSERT INTO caxNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Arrtü ubaca aübu nuñentuqui, chütonempü nomünantü. Ta arrüna arrtü mapensaca auqui nuyausasü churriampü, tone nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Arraño abe naumumasu. ¡Amonsapesio te nurria! ");
INSERT INTO caxNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Auqui onconoma macrirrtianuca uiti Jesús. Sürotipo au taman porrü. Auqui arrübama ñanunecasarrti ñanquitioma pünanaquiti: —¿Isane ümoche arrüna sane nura? ");
INSERT INTO caxNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nanti ümoma: —¿Así que arraño chütusiopito aume? Arrtü ubaca aübu nuñentuqui, chütonempü nomünantü au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Itopiqui umate; chüsüropütü au nuyausasü, ta süro au nuñaunso, y auqui barutaübu tato tanene. Tone ñanunecacarrti Jesús: Nanaiña arrüba umate, ta omirria. ");
INSERT INTO caxNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nantito: —Arrtü mapensaca churriampü auqui nuyausasü, uirri ane nuipünate. ");
INSERT INTO caxNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Auqui nausasü macrirrtianuca cuatü nomünantü. Mapensarama ñome ba chomirriampü. Nacarrümantai yusiu paüca. Cusüpüoma. Aboma aübu nicüpostoti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Rranrrüma ümo nenarrirrti quiatarrü. Isamutema nomünantü. Matachemacanama. Churriampü nisüboriquirrimia. Ubatioma nenarrirrti quiatarrü. Macuenturuma apüti quiatarrü. Ñentonaunrrüma. Chümapensarapüma urria. ");
INSERT INTO caxNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Enterurrü arrüba nomünantü cuantio auqui nuyausasü. Oboi te ane nuipünate. ");
INSERT INTO caxNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Auquimanu sürotitü Jesús au manu cürrü saimia manio puebluca Tiro y Sidón. Sürotitü au manu taman porrü. Chirranrrtipü nauqui atusi ümo macrirrtianuca que iñataiti acamanu, pero chüpuerurrüpü atanecati ñünanama. ");
INSERT INTO caxNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Taman paürrü ipiate nürirrti Jesús. Ane nichechese arrüna anati choborese ahu. Cuatü achesoi esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Arrümanu paürrü auqui quiatarrü nacíon, nürirri Sirofenecia. Nurarrü griegorrü. Ñanquitio pünanaquiti Jesús nauqui aiquiaüburutiti choborese auqui nichechese. ");
INSERT INTO caxNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nanti ümo ui machepecatarrü: —Mejor basaparama masiomanca primero. Itopiqui churriampü uiquiaübu niyaratarrüma y uitorrimia ñoma tamocomanca. ");
INSERT INTO caxNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Auqui iñumuta manu paürrü, nantü ümoti: —Sane te Señor, pero arrüba tamocomanca bubaso ito iquianaqui mensarrü nupusatu niyubarata siomanca. ");
INSERT INTO caxNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Auqui nanti ümo: —Ñemanauntu oncatü nurria iñemo. Acosi tato au napo. Chauqui tüsürotitü choborese auqui nacheche. ");
INSERT INTO caxNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Auqui süro tato manu paürrü au niporrü. Iñatai tato esa nichechese. Ananca barücüro, chauqui tüsürotitü choborese auqui. ");
INSERT INTO caxNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Basücübücoti tato Jesús auqui manu cürrü saimia Tiro. Pasaoti auqui Sidón. Auqui taha süroti tato abeu manu turrü au Galilea au manu cürrü nürirri Diez Puebluca. ");
INSERT INTO caxNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Acamanu iquianamati taman ñoñünrrü esati, naqui chonautipü y chüpuerurrüpü anitati. Manquioma pünanaquiti nauqui aiñanti nehesti onüti. ");
INSERT INTO caxNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Auqui arrti Jesús iquianatiti au narücüquirri pünanaqui macrirrtianuca. Acamanu iñatati nehesti ubau numasurrti. Auqui utureuruti icutacu nehesti, y iñatati cutacu nuturrti. ");
INSERT INTO caxNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Auqui asaratitü ape, anasacoti fuerte, y nanti: —Efata —nantü auqui besüro “tari onaurrti tato”. ");
INSERT INTO caxNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Au manu rratorrü onaurrti y puerurrü anitati maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nanti Jesús ümo bama amoncoma acamanu: —¡Tapü aburapoi isucarü maquiataca! Pero arrüma urapoimiantai tanu. ");
INSERT INTO caxNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tarucu nicütobürrüma, namatü: —Enterurrü arrüba isamutenti omirria. Arrübama chonaunpü onaurrüma tato uiti, y arrübama chüpuerurrüpü anitama manitanama uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Au manio naneneca oberabarama sürümanama macrirrtianuca esati Jesús. Champü utuburiboma. Auqui tasuruma uiti Jesús bama ñanunecasarrti, nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Taquisürümantai iñemo bama macrirrtianuca. Chauqui tütabe trerrü naneneca nacarrüma auna ichepeñü, y champü utuburiboma. ");
INSERT INTO caxNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Arrtü icüpucama tato au niporrüma, rrepente tasurerecoma isiu cutubiurrü ui nicürüpürrüma, itopiqui aboma bama cuamatü auqui iche. ");
INSERT INTO caxNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Auqui iñumutama bama ñanunecasarrti: ¿Causanempito puerurrü basaparama au na rroense, auna cauta champüti bavivico? ");
INSERT INTO caxNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nanti ümoma: —¿Mantucubu pan abe aboi? Namatü: —Abe siete. ");
INSERT INTO caxNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Auqui bacüpuruti Jesús ümo macrirrtianuca nauqui atümoma. Auqui iquianiontiño mecuti manio siete pan. Machampiencanati ümoti Tuparrü. Ichepesünaniotiño nauqui rrepartibo ui bama ñanunecasarrti ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Abe ito uimia mümanantai nopiocomanca. Icunusüancaniontiño ito y rrepartibo ito ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sane nauquiche basoma bien namanaiña. Iyau niyacarrüma arrübama ñanunecasarrti süromatü aitapeonoma niyosobüratuca. Ubataso siete noconoca uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nubiquirrimia bama basoma taqui cuatro mil mañoñünca. Auqui masamunuti Jesús nariorrü pünanaqui manu genterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sürotitü au barco aübu bama ñanunecasarrti. Süromatü topü manu turrü. Iñataimia au manu cürrü nürirri Dalmanuta. ");
INSERT INTO caxNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Acamanu cuamatü bama fariseorrü esati Jesús, nauqui uratoquimia aübuti. Manquioma señarrü pünanaquiti icu napese, abu ñacocotorrüma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tapü arrti Jesús anasacoti fuerte au nitusirrti. Nanti: —¿Causane anqui señarrü arrüna genterrü? Ñemanauncurratoe sucanañü aume: Chitusiancatapü señarrü ausucaü. ");
INSERT INTO caxNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Auqui onconoma uiti. Süroti tato au barco. Süroma tato topü manu turrü au quiatarrü narücüquirri. ");
INSERT INTO caxNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Arrübama ñanunecasarrti tacürusu ñaquioncorrüma acama itapiquiboma. Macanama tamantai pan au barco. ");
INSERT INTO caxNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nanti Jesús ümoma: —Amasasai nurria ñünana nesarrüma levadura bama fariseorrü, y ñünana nesarrti levadura Herodes. ");
INSERT INTO caxNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Auqui bama ñanunecasarrti ñanquitioma pünanaquimiantoe, namatü sane: —Nanti Jesús sane, itopiqui champü pan osoi. ");
INSERT INTO caxNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tusiatai ümoti Jesús arrüna nurarrüma. Nanti ümoma: —¿Causane tarucu napapensaca iyo arrüna champü pan aboi? ¿Chütusioiquipü aume? ¿Chapicococapüñünqui? ¿Tairriqui nabausasü? ");
INSERT INTO caxNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¡Ümoche abe nausüto y naumumasu! ");
INSERT INTO caxNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Chapaquioncapü nauquiche ichepesünaquio cinco pan ümo cinco mil macrirrtianuca? ¿Mantucubu noconoca ubataso ui nisobüratuca? Namatü: —Ubataso doce. ");
INSERT INTO caxNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nantito ümoma: —Nauquiche ito ichepesünaquio siete pan ümo manuma cuatro mil, ¿mantucubu noconoca ubataso ui nisobüratuca? Namatü: —Ubataso siete. ");
INSERT INTO caxNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Auqui nanti ümoma: —¿Chentienderrüquipü año? (Ta ichepecatati Jesús manu levadura tacana ñanunecacarrüma bama fariseorrü.) ");
INSERT INTO caxNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iñataimia au manu pueblurrü Betsaida. Arrübama pohoso acamanu iquianamati taman ñoñünrrü supuso esati Jesús. Manquioma pünanaquiti, nauqui aiñenotiti pario maniqui supuso. ");
INSERT INTO caxNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Auqui arrti Jesús iñentati neherrti, sürotitü pürücü manu pueblurrü aübuti. Acamanu iñatati neherrti omonü nirrtorrti. Auqui ñanquitioti pünanaquiti, arrtü tüpuerurrü asaratitü pario. ");
INSERT INTO caxNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Arrti maniqui ñoñünrrü nanti: —Tiyasacatü pario ümo macrirrtianuca, pero au niyasata tacana sueca, arrüba mamenco. ");
INSERT INTO caxNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iñatati tatito Jesús neherrti omonü nirrtorrti. Auqui asaratitü nurria maniqui ñoñünrrü. Urriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Auqui arrti Jesús nanti ümoti: —¡Acui tato besüro obi au napo, tapü aübüca auqui pueblurrü! ");
INSERT INTO caxNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Auqui arrti Jesús sürotitü aübu bama ñanunecasarrti au manu cürrü saimia manu pueblurrü nürirri Cesarea de Filipo. Isiu cutubiurrü ñanquitioti pünanaquimia: —¿Uramapü sane iñemo macrirrtianuca? ");
INSERT INTO caxNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Auqui namatü: —Aboma bama namatü arrücü Juan Bautista. Maquiataca namatü, arrücü Elías. Aboma ito bama namatü, arrücü tamanti eanaqui bama profetarrü tücañe, naqui süborico tato. ");
INSERT INTO caxNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Auqui ñanquitioti pünanaquimia: —¿Carü arraño, causane napapensaca iñemo? Aiñumuti Pedro: —Arrücü Cristo, naqui tacümanauncunu uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nanti Jesús ümoma: —¡Tapü aburapoi arrüna sane! ");
INSERT INTO caxNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Auqui manunecanati Jesús ümo bama ñanunecasarrti, nanti ümoma: —Arrüñü ñemanauncurratoe ñoñünrrü tiene que yasuriu au cuantio naneneca yarusürürrü taquisürücürrü ui bama mamayoreca ichepe bama üriatu sacerdoterrü y bama manunecana nüriacarrü. Tiene que atüborimia iñemo chepe nisonco uimia, pero pürücü trerrü naneneca isüboriquia tato. ");
INSERT INTO caxNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Bien ñemanuncurratoe arrüna surapoi ausucarü. Auqui arrti Pedro iquianatiti Jesús peese, y nanti ümoti: —¡Tapü pasao aemo arrüna sane, Señor! ");
INSERT INTO caxNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tapü arrti Jesús pebücoti y asaratitü nurria ümo bama ñanunecasarrti. Auqui icuansomoconotiti Pedro, nanti ümoti: —¡Aquicho auquina yesaquiñü, choborese! Arrüna napensaca champürrtü uiti Tuparrü, ta icuqui nantai cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Auqui batasuruti ümo macrirrtianuca ichepe bama ñanunecasarrti, nanti ümoma: —Arrtü anati naqui rranrrü ayetitü isiuñü, tari taquisürübati isiuquiñü. Tari tacürusu ñaquioncorrti iyotiatoe, tacanarrtü chüvaleopü nisüboriquirrti ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Arrti naqui rranrrü ataesübu ñünana concorrü auna icu na cürrü, chüpuerurrüpü aye uiti au napese. Pero arrti naqui coiño auqui niyaca y auqui naca na urria manitacarrü, tiene que aye uiti au napese ichepeñü. ");
INSERT INTO caxNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Champü yaserebiquirri oemo, arrtü macanate nanaiña nenarri na cürrü, arrtü au nitacürurrü peneco nuyausüpü au infierno. ");
INSERT INTO caxNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Itopiqui tarucu nicua nuyausüpü, champü aye uirri tacana nicuarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Arrtü anati naqui cüsobo uraboiti nisüri y nisura isucarü na genterrü malorrü y tarucu nomünantü uirri, sane ito arrüñü chirrancapü yaca aübuti, arrtü iseca tato ñana ichepe bama angelerrü aübu tarucu nanentacarrü uiti Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Auqui nantito ümoma: —Sucanaño aume ñemanauncurratoe: Aboma uturuqui bama auna chüpuerurrüpü acoma cheperrtü arrtaimia nüriacarrti Tuparrü oemo icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pürücü seirri naneneca arrti Jesús sürotitü onü taman yiriturrü apetaisürü aübu bama trerrü ñanunecasarrti, arrti Pedro, arrti Jacobo y arrti Juan. Acamanu isomosoconotiyü isucarüma. ");
INSERT INTO caxNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Arrümanu naibirrti cuara, champü tacanache nipurusubiquirri. ");
INSERT INTO caxNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Auqui arrümanuma trerrü ñanunecasarrti asaramatü ümoti Elías ichepeti Moisés, cuamatü auqui napese esati Jesús nauqui aparimia aübuti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Auqui nanti Pedro ümoti Jesús: —Urriampae nusaca auna. Masamuna trerrü cüpahuca, taman aemo, quiatarrü ümoti Moisés y quiatarrü ümoti Elías. ");
INSERT INTO caxNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Taipü arrti Pedro manitanatiatai ui tarucu nicütobürrti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Au manu rratorrü itamurriquianama taman cüsaüborrü. Eana manu cüsaüborrü rabotü manitacarrü, nantü sane: —Tonenti naqui isaü. Tarucu nicuarrti iñemo. ¡Amonsoi nurarrti! ");
INSERT INTO caxNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Auqui arrümanuma trerrü asarama tato nurria. Champütiqui Elías y arrti Moisés, arrtiatai Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Numo tücuama tato itaqui manu yiriturrü, nanti Jesús ümoma: —Tapü aburapoi arrüna amarrtai one, cheperrtü isüboriquia tato uturuqui macoiñoca, arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sane nauquiche etayoimiantai, churapoipüma. Chütusiopü ümoma causane arrümanu urapoiti isucarüma, arrüna tiene que asüboriti tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Auqui ñanquitioma pünanaquiti: —¿Causane namatü bama manunecana nüriacarrü que ta arrti Elías tiene que eyeti acusürüti apünanaquicü, naqui Cristo? ");
INSERT INTO caxNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aiñumuti: —Ñemanauntu te tiene que acusürüti ayeti Elías, nauqui aicoñocoti nanaiña cümenuti Cristo. Pero tusio aume, arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ichaquisürü y chüpuerurrüpü isuasürü ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sucanañü aume: Arrti Elías chauqui tanancati uyarrüpecu, pero arrübama macrirrtianuca emeonomati isiu nirrancarrüma tacana arrüna nantü icu Nicororrü, sane pasabo ümoti. (Ta arrti Juan Bautista.) ");
INSERT INTO caxNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nauquiche cuama tato esa bama maquiataca ñanunecasarrti, besüro narrtarrüma ümo cütüpürrü genterrü itupecuma. Amoncoma ito arrübama manunecana nüpiacarrü, uratoquioma aübuma. ");
INSERT INTO caxNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Numo tasaramatü cümenuti Jesús, cütobüsoma. Ipiacünomacü cümenuti nauqui anquimia nurria ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Auqui ñanquitioti pünanaqui bama ñanunecasarrti: —¿Isane arrüna naburatoquitio aübuma? ");
INSERT INTO caxNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tamanti uturuqui manuma amoncoma acamanu iñumutati: —Maestro, iquiacati isaü tauna aesacü, anati choborese auti. Uiti chüpuerurrüpü anitati. ");
INSERT INTO caxNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Isamutenti isiu nirrancarrti aübuti. Yaruraüburutiti acü. Botoquio nohorrti y atüo ahiquiti. Uirri arrüna chücusüurutipü. Titusiancacati isucarü bama anunecasa, nauqui aiquiaüburumati choborese auquiti, pero chüpuerurrüpüma. ");
INSERT INTO caxNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aiumuti Jesús: —¡Causanempü chapicococapüñü! Tantorrü naneneca niyaca abarrüpecu aübu nisura. Apiquiataunarrti maniqui ñaüma. ");
INSERT INTO caxNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Numo asaratitü choborese ümoti Jesús, yaruraüburutiti maniqui ñaüma tatito acü, atüo ahiquiti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Auqui ñanquitioti Jesús pünanaquiti yaütoti: —¿Mantucubo naneneca ñaunrrococorrti? ");
INSERT INTO caxNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nanti yaütoti: —Auqui numo chimiantiqui. Ane nauche taübücoti oto pese uiti choborese, y eana turrü; sane nauquiche taquisürütiatai. ");
INSERT INTO caxNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Arrtü puerurrü acura ümoti, apucüru te suichacu, ayurasa somü. —Auqui nanti Jesús: —Tapü anquitio rropünanaqui arrtü puerurrü rracura ümoti. Arrti naqui icocorotiñü nanaiña urriante ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Auqui atosibiti yaütoti maniqui ñaüma, nanti: —¡Icococü! Ayurasañü na icocorü nurria. ");
INSERT INTO caxNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Numo asaratitü Jesús tütarucapae genterrü esati, icuansomoconotiti choborese, nanti ümoti: —Arrücü choborese, obi chonauntipü y chümanitanatipü naqui ñaüma. ¡Acosi auquiti, y tapü ananto aye tato auti! ");
INSERT INTO caxNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Auqui tosibocoti choborese niyücürrti auquiti. Arrti ñaüma paichocononoti tatito uiti, y auqui simia niconcorrti. Namatü macrirrtianuca, tücoiñoti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero arrti Jesús iñentati neherrti, aiñatünacanatiti. Auqui arrti maniqui ñaüma atüraiti y turrian tato ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Auqui sürotipo Jesús au taman porrü. Acamanupo arrübama ñanunecasarrti ñanquitioma pünanaquiti anecanatai: —¿Causane chüpuerurrüpü sopicüpuruti choborese auquiti maniqui ñaüma? ");
INSERT INTO caxNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aiñumuti Jesús, nanti sane: —Tusio aume, nauqui saliboti naqui choborese, tiene que oñean nurria ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nauquiche tüsüromatü auquimanu, pasaoma auqui manu cürrü nürirri Galilea. Arrti Jesús chirranrrtipü na atusi nipiasacarrti auquimanu, itopiqui manunecanati ümo bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Urapoti isucarüma sane: —Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que aitorrimianamañü mecu mañoñünca nauqui aitabairomañü, pero pürücü trerrü naneneca isüboriquia tato. ");
INSERT INTO caxNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Arrübama ñanunecasarrti chütusiopü ümoma ümoche arrümanu nurarrti. Birrubuma anquirioma pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iñataimia au manu pueblurrü nürirri Capernaum. Numo anancati au taman porrü ñanquitioti pünanaquimia: —¿Isane ümoche arrüna abasiquia aburatoqui one isiu cutubiurrü? ");
INSERT INTO caxNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Chiñumutapüma, itopiqui amoncoma ñanquitioma pünanaquimiantoe quiti naqui ane manrrü nüriacarrti uturuquimia. ");
INSERT INTO caxNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Auqui tümonsoti Jesús. Batasuruti ümo bama doce ñanunecasarrti, nanti ümoma: —Arrtü anati naqui rranrrü ane manrrü nüriacarrti, tiene que aiñanti nurria yaserebiquirrti ümo maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Auqui itusiancanatiti taman ñaüma isucarüma, iñanatiti cümuinta auna cauta amoncoma, y nanti ümoma aübu yapasucurrti ümoti maniqui ñaüma: ");
INSERT INTO caxNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Arrti naqui yasuriurutiti taman ñaüma tacanati naqui au nisüri, ta yasuriurutiñü ito. Arrti naqui yasuriurutiñü, yasuriurutitito naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Auqui nanti Juan ümoti: —Maestro, sumasacati taman ñoñünrrü bacüpuruti tanene ümo machoboreca au nüri. Como arrti maniqui ñoñünrrü chamencotipü ochepe, sane nauquiche prohibibo somü ümoti tapü asioti aisamunentiqui sane. ");
INSERT INTO caxNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aiñumuti Jesús, nanti: —Asioti saneantai. Itopiqui arrti naqui masamunu milagrorrü au nisürü, chüpuerurrüpü anitati churriampü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Arrti naqui chütüboricopü oemo, ocümanati utacu. ");
INSERT INTO caxNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ñemanauncurratoe sucanañü aume, arrti naqui macumana aume au nisüri aunque sea tumantai au taman vasorrü itopiqui arraño apicococañü, tiene que atorri ümoti nicuarrti uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Arrtü anati naqui iñatati macocotorrü ümo bama icocoromañü, nauqui tapü icocoromañünqui, manrrüpü urria arrtü tomoeno sürümanarrü canrrü itüti, nauqui botaboti aübu au narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Arrtü aisamute nomünantü ui taman nehe, mejor aitüsüna, itopiqui manrrü urria arrtü aecatü esati Tuparrü aübu tamantai nehe, pünanaquiapae arrtü aecatü au infierno yupu manio torrücaü nehe, auna cauta champü nitacüru nonco pese. ");
INSERT INTO caxNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Taha ito abe nicümüca arrüba chümocoiñopü y pese chotochebopü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Arrtü atapeneca ui taman napope au nomünantü, mejor aitüsüna. Manrrü urria arrtü aecatü esati Tuparrü aübu tamantai napope, pünanaquiapae arrtü apeneca au infierno yupu manio torrücaü napope, auna cauta champü nitacüru nonco pese. ");
INSERT INTO caxNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Taha ito abe nicümüca arrüba chümocoiñopü, y pese chotochebopü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Arrtü ui nasüto atapeneca au nomünantü, mejor aiquiaübu, itopiqui manrrü urria arrtü aecatü esati Tuparrü aübu tamantai nasüto, pünanaquiapae arrtü aecatü au infierno yupu manio torrücaü nasüto, ");
INSERT INTO caxNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","auna cauta abe nicümüca arrüba chümocoiñopü y pese champü nitacüru noncorrü. ");
INSERT INTO caxNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Taha namanaiña aboma oto pese, tacanarrtü süro siürrü osoi cütüpü nañese, tapü apore. ");
INSERT INTO caxNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ñemanauncurratoe urria oemo siürrü. Pero arrtü tacürusu nisücürrü, ¿causanempü nauqui asü tato, y causane nauqui puerurrü aserebi tato? Sane ito arraño, tapü ensoro amopünanaqui arrüna urria nausüboriqui, y apacumananaun aume ampatoe. ");
INSERT INTO caxNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Auqui arrti Jesús sürotitü auqui Capernaum au manu cürrü nürirri Judea. Auqui taha sürotitito topü manu sapoco nürirri Jordán. Acamanu oberabarama tatito macrirrtianuca esati. Manunecanati ümoma, arrüna nantarrü isamutenti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Acamanu aboma bama fariseorrü. Süromatü esati Jesús aübu ñacocotorrüma ümoti, namatü: —¿Aensapü puerurrü sopiñoco suisüposü? ");
INSERT INTO caxNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aiñumuti Jesús: —¿Isane arrüna yacüpucurrti Moisés tücañe? ");
INSERT INTO caxNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iñumutama, namatü: —Arrti Moisés nanti sane: Puerurrü sopiñoco suisüposü, arrtü torrio ñome nicororrü, arrüna uiche atusi que chütonenquipü suisüposü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Auqui nanti Jesús ümoma: —Arrti Moisés bacüpuruti sane, itopiqui arraño chaurriancapü apicoco nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero tücañe, nauquiche omirriante nanaiña uiti Tuparrü, urriancati uiti taman ñoñünrrü y taman paürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sane nauquiche arrti ñoñünrrü iñocotati nipiacütoti y arrti yaütoti, nauqui aviviti aübu nicüpostoti ümo enterurrü nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Arrtü tüposoma, es tacanarrtü tamantai nacarrüma. Champürrtü torrümainqui, taman nacarrü nacarrüma au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sane nauquiche chüpuerurrüpü aiñoconomacü, itopiqui arrüna sane es uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nauquiche amoncoma au taman porrü, arrübama ñanunecasarrti ñanquitioma pünanaquiti, isane ümoche arrümanu ñanunecacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aiñumuti, nanti: —Arrti naqui iñocotati nicüpüstoti y posoti aübu quiatarrü, chauqui tütane nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Arrtü paürrü iñoconoti iquiana y poso aübuti quiatarrü, tane ito nipünate. ");
INSERT INTO caxNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Acamanu ito macanama masiomanca esati Jesús, nauqui aiñanti neherrti itama. Pero cuasoma ui bama ñanunecasarrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ümoti Jesús churriampü arrüna sane, nanti ümo bama ñanunecasarrti: —Tari yebamatü yesañü manuma masiomanca. Tapü ane causane aboi ümoma. Arrübama ichimiancanamacü tacana masiomanca, tonema bama iyebo uimia auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ñemanauncurratoe sucanañü aume, arrti naqui chirranrrüpü oncotitü ümoti Tuparrü tacanati taman ñaüma, chüpuerrrüpü aye uiti auna cauta üriabucati. ");
INSERT INTO caxNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Auqui canama uiti masiomanca itocüti, y curusüoma uiti aübu neherrti itama. ");
INSERT INTO caxNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nauquiche tüsürotitito Jesús, au manu rratorrü cuati taman ñoñünrrü yarucurrti isiuti. Bachesoiyoti esati, ñanquitioti pünanaquiti: —Buen Maestro, ¿causane nauqui aye sobi esati Tuparrü au napese? ");
INSERT INTO caxNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aiñumuti Jesús, nanti sane ümoti: —¿Causane ucanü iñemo ta buenorrüñü? Tamantiatai Tuparrü naqui anati au napese, naqui buenorrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Arrücü tusio aemo arrüba yacüpucurrti Tuparrü: “Tapü atabaiquia. Tapü aecatü isiu quiatarrü paürrü. Tapü acusüpüca. Tapü apanca apüti quiatarrü. Tapü encañaca. Tari cuasürüti aemo aüma y napacüma”. ");
INSERT INTO caxNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aiñumuti maniqui ñoñünrrü: —Maestro, enterurrü arrüba icocoquio auqui numo naümañünqui. ");
INSERT INTO caxNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Arrti Jesús asaratitü ümoti, chauqui tücuasürüti ümoti. Auqui nanti ümoti: —Aninqui arrüna faltabo aemo. Aipiaventecasio nanaiña naenarri y aitorrimia nicuarrü ümo bama pobrerrü. Arrtü aisamute sane, ane nacua uiti Tuparrü au napese. Auqui caüma ariacu isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nauquiche oncoiti arrüna sane, mapensarati. Auqui süroti tato au niporrti, sucheboti nurria, itopiqui bien rricurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Auqui arrti Jesús asaratitü itupecuti, y nanti ümo bama ñanunecasarrti: —Arrübama rricurrü cuestarrü ümoma nauqui aye uimia auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Arrübama ñanunecasarrti cütobüsoma ui nurarrti, pero arrti Jesús nanti tatito ümoma: —Isaütaiqui, cuestarrü ümo bama oncomatü ümo nenarrirrimia aye uimia auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¿Aensapü pasao manu numuquianrrü camello auqui nirrto cümese? (Abu nisunaunrrü tacana cabayurrü.) Tapü arrti rricurrü manrrüqui cuestarrü ümoti aye uiti auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nauquiche oncoimia arrüna sane, tarucu nicütobürrüma. Ñanquitioma pünanaquimiantoe: —¿Quitipito puerurrü aye uiti esati Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Auqui asaratitü Jesús ümoma, nanti: —Arraño mañoñünca chüpuerurrüpü aye aboi esati Tuparrü auqui namuñemantoe. Pero arrti Bae Tuparrü bayurarati aume, itopiqui arrti nanaiña puerurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Auqui nanti Pedro ümoti: —Señor, arrüsomü sopiñocota nanaiña somenarri, nauqui sobetü asiucü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nanti Jesús: —Sucanañü aume ñemanauncurratoe, arrti naqui iñocotati niporrti, yaruquitorrti, niquiastoti, yaütoti, nipiacütoti, nicüpostoti, aütorrti y niyorrti ichopiquiñü y itopiqui arrüna urria manitacarrü, ");
INSERT INTO caxNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tiene que atorri tato ümoti auna icu na cürrü manrrü chama pünanaqui arrüna oncono uiti. Torrio ümoti poca, yaruquitoboti, iquiasitoboti, ipiacütoboti, aübosiboti, iyoboti. Pero torrio ito itaquisürücüboti. Y tiene que aye uiti ñana au napese esati Bae Tuparrü, auna cauta chütacürusupü süboriquirri. ");
INSERT INTO caxNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Itopiqui sürümanama bama arucapae ümoma caüma, pero ñana tonema bama champü yaserebiquirrimia. Sürümanama ito bama champütiatai asaratü ümoma caüma, pero ñana tonema bama cusürübo aüromatü esati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nauquiche aboma isiu cutubiurrü niyücürrüma au Jerusalén, arrti Jesús cusürüboti aübu macrirrtianuca, y arrübama ñanunecasarrti cütobüsoma. Süromatü isiuti aübu nirrucurrüma. Auqui tasuruma tatito uiti manuma doce apostolerrü, nauqui uraboiti isucarüma arrüna pasabobo ümoti. Nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tusio aume, ta noecü au Jerusalén. Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ichorri mecu bama üriatu sacerdoterrü, y ümo bama manunecana nüriacarrü. Arrüma namatü tiene que aitabairomañü. Itorrimianamañü ümo bama extranjerurrü auqui Roma. ");
INSERT INTO caxNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Arrüma caüma emeonomañü y ocüsioma iñemo. Utureuruma isuñü. Auqui itabairomañü. Pero pürücü trerrü naneneca tiene que isübori tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Auqui arrübama aütorrti Zebedeo, arrti Jacobo ichepeti Juan süromatü esati Jesús, namatü ümoti: —Maestro, suirranca nauqui aichübo somü arrüna suirranca supanquirio. ");
INSERT INTO caxNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aiñumuti Jesús: —¿Isane naurriantümo? ");
INSERT INTO caxNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Namatü: —Arrtü türiabucü, suirranca suichümo apetacucü, tamanti au nepanauncu, arrti quiatarrü au nepau. ");
INSERT INTO caxNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Auqui nanti Jesús ümoma: —Chütusiopü aume isane arrüna apanquitio. ¿Aensapü puerurrü avantabo año ümo nautaquisürücü tacana arrücuatü taquisürücürrü cuabotiqui iñemo? ");
INSERT INTO caxNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aiñumuma: —Puerurrü somü. —Ñemanauntu te —nanti Jesús ümoma —arraño autaquisürüca ñana tacana arrüna cuabotü ichaquisürücüboñü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero arrüñü champü nisüriaca nauqui itorrimia aume nauqui autümo rrupetacuñü au niñepanauncu y au niñepau. Arrtiatai Bae Tuparrü puerurrti aitorrimiati ümo bama urria au ñaquioncorrti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nauquiche tütusio ümo bama maquitaca arrüna ñanquitioma bama torrü, tüboricoma ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Auqui tarusuma namanaiña uiti Jesús, nanti ümoma: —Arraño tusio aume que arrübama mayüriabuca auna icu na cürrü ane nüriacarrüma ümo bama macrirrtianuca. Arrübama manrrü yarusürürrü nüriacarrüma isamutema isiu naca nirrancarrüma aübuma. ");
INSERT INTO caxNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero arraño tapü apisamute sane aumeampatoe. Arrtü anati abarrüpecuqui, rranrrti ane manrrü nüriacarrti, tari yaserebiati nurria ümo maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Arrti naqui rranrrti aisamunutiyü yüriaburrti, tari isamunutiyü tacana mosorrti ümo maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Arrüñü Ñemanauncurratoe Ñoñünrrü chisecapütü nauqui aserebimia iñemo, ta isecatü yaserebi ümoma. Isecatü itorrimia nisüboriqui tacana bapacatarrü itobo nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iñataimia au manu pueblurrü nürirri Jericó. Pasaoti Jesús auqui manu aübu bama ñanunecasarrti y aübu maquiataca macrirrtianuca sürümanama. Anati acamanu taman ñoñünrrü supuso, nürirrti Bartimeo, aütorrti Timeo. Anancati tümonsoti isiu cutubiurrü, ñanquiquirrti pünanqui macrirrtianuca nauqui acumanama ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nauquiche oncoiti que pasaoti Jesús naqui auqui Nazaret, tosibicoti isiuti, nanti: —Jesús, aütorrti yüriaburrü David, apucüru ichacuñü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Arrübama macrirrtianuca icuansomoconomati, namatü ümoti: —¡Etaiquei! Pero arrti manrrü nitosibirrti, nanti tatito: —Aütorrti yüriaburrü David, apucürü ichacuñü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Auqui arrti Jesús tochencoti, nanti: —Apiquiataunarrti. Auqui süromatü aiquianamati. Namatü ümoti: —Aiña nurria, atüsai, maemencoti Jesús acü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Auqui yarutaübutati nicüburrirrti ui taman nitobücürrti. Aiñanainti esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Arrti ñanquitioti pünanquiti: —¿Isane narriantümo? Arrti maniqui supurrü nanti: —Maestro, irranca nauqui yasaratü. ");
INSERT INTO caxNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aiñumuti Jesús: —Acui tato, chauqui turriancü tato, itopiqui aicococañü. Au manu rratorrü urrian tato narrtarrti. Sürotitü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iñataimia saimia Jerusalén, yobesa manio poca nobürirri Betfage y Betania, cutaquiquibo manu yiriturrü nürirri Olivo. Arrti Jesús bacüpuruti ümo manuma torrü ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nanti ümoma: —Amecosi au ba taha poca. Arrtü apiñatai taha, ane taman bururrü tomoeno, arrüna champüti tiyebo ichacu. Apisoquisüna, apiquia tauna. ");
INSERT INTO caxNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Arrtü anati ñanquitio amopünanaqui, causane apisamune arrüna sane, amucanaño: “Arrti Señor rranrrti ocupabo uiti”. ");
INSERT INTO caxNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Süromatü manuma torrü. Tabüco uimia manu bururrü, ane tomoeno abeu nusuara saimia taman porrü. ");
INSERT INTO caxNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nauquiche tisoquisünatama, arrümanuma amoncoma au manu porrü namatü ümoma: —¿Isane napachücoi? ¿Causane apisoquisüna manu bururrü? ");
INSERT INTO caxNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Auqui iñumutama isiu arrümanu yacüpucurrti Jesús ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sane nauquiche champü causane uimia ümoma. Auqui aiquiama manu bururrü. Aiñanaimia tato esati Jesús aübu. Iñatama naibirrimia chacu, nauqui aüroti Jesús ichacu. ");
INSERT INTO caxNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sürümanama ito bama iñatama naibirrimia isiu cutubiurrü cümenuti Jesús. Maquiataca maneonoma nasusüca, iñatama ito isiu cutubiurrü cümenuti. ");
INSERT INTO caxNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Arrübama cusürübo y arrübama cosotiqui tosibicoma, namatü: —¡Gloria ümoti naqui cuati au nürirrti Tuparrü! ");
INSERT INTO caxNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Chapie ümoti Tuparrü, iñataiti naqui ñemanauncurratoe yüriaburrü oemo, tacanati uyaü David tücañe, naqui yüriaburrü! ¡Gloria ümoti Tuparrü! ");
INSERT INTO caxNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sane nauquiche iñataiti Jesús au Jerusalén. Auqui aürotitü au niporrti Tuparrü. Nauquiche tasaratitü ümo nanaiña arrüba abe acamanupo, sürotitü au Betania aübu bama doce ñanunecasarrti, itopiqui chauqui tütümümüca. ");
INSERT INTO caxNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Au quiatarrü nanenese basücübücoti tato auqui Betania. Cürüpüoti. ");
INSERT INTO caxNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Asaratitü auqui iche ümo taman suese higuera. Aürotitü esa nauqui apacheti nütarrü. Abu chütüpü nitiemporrü na üta manu suese. Sane nauquiche pururrü nasurrtai arrtaiti. ");
INSERT INTO caxNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Auqui manitanati Jesús ümo manu suese, nanti ümo: —Chanantopü anati baso nüta. Arrümanuma ñanunecasarrti oncoimia arrüna ñanitacarrti ümo. ");
INSERT INTO caxNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iñataimia au Jerusalén. Aürotipo Jesús au niporrti Tuparrü. Penecoma türüpo uiti arrübama mapaventecana ausüratai y arrübama macomporara acamanupo. Bopebüco uiti nimensarrüma bama macampiara monirri. Bopebüco ito uiti nisiyarrüma bama mapaventecana nututaquiquia. ");
INSERT INTO caxNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chichebopü ümoma uiti nauqui acama ausüratai au niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Manunecanati ümoma, nanti: —Icu Nicororrü nantü sane: “Arrüna nipo urriante ümo meancarrü ümo macrirrtianuca auqui nanaiña nasioneca”. Pero aboi caüma tacana nipo bama macusüpüca. ");
INSERT INTO caxNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Arrübama üriatu bama sacerdoterrü ichepe bama manunecana nüriacarrü oncoimia nurarrti. Sane nauquiche bapacheroma niquiubuma causane nauquiche aitabairomati. Pero birrubuma ñünanati, itopiqui macrirrtianuca urria ümoma arrüna ñanunecacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nauquiche aübapae ütobi, arrti Jesús süroti tato auqui pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Au manu quiatarrü nanenese tansürü pasaoma tatito esaqui manu suese higuere. Arrtaimia chauqui tüsüübo auqui nirranacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aquionotiyü Pedro, nanti ümoti Jesús: —¡Maestro, asasatü ümo manu suese arrone aipiaurramata tümüca, chauqui tüsüübo! ");
INSERT INTO caxNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aiñumuti Jesús: —Apicocosorrti Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ñemanauntu arrüna sucanañü aume: Arrti naqui nanti ümo taman yiriturrü: “Acosi auquina, aiñasü au narubaitu turrü”, arrtü champü isane quiatarrü ñapensacarrti au nausasürrti, y arrtü icocotati arrüna nurarrti, ta cocono. ");
INSERT INTO caxNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sane nauquiche sucanañü aume: Arrtü apanquiquia pünanaquiti Tuparrü, apicoco nurria, y amonsotü ümoti. Auqui caüma itorrimiatati aume. ");
INSERT INTO caxNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Arrtü aurrianca apapari aübuti Tuparrü au napeanca, pero ane nünantü aume uiti quiatarrü, apiñarrimiaca. Sane caüma arrti naqui Aubaü naqui anati au napese iñarrimiacatatito tato nomünantü aboi. ");
INSERT INTO caxNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tapü arrtü arraño chapiñarrimiacatapü nomünantü aumeampatoe, ta sane ito uiti naqui Aubaü naqui anati au napese, chiñarrimiacatatipito tato nomünantü aboi. ");
INSERT INTO caxNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Auqui süromatito au Jerusalén. Nauquiche iñataimia taha, arrti Jesús amencoti au niporrti Tuparrü. Auqui süromatü esati bama üriatu bama sacerdoterrü ichepe bama manunecana nüriacarrü, y arrümanuma maquiataca mamayoreca. ");
INSERT INTO caxNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Anquirioma pünanaquiti: —¿Isane nüriaca, nauqui aisamune arrüna sane? ¿Quiti naqui bacüpuru aemo? ");
INSERT INTO caxNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aiñumuti Jesús: —Arrüñü irranca rranquirio ito amopünanaqui. Arrtü aburapoi isucarüñü arrüna rranquitio, auqui caüma surapoi ausucarü quiti uiche aicüpuruñü, nauqui isamune arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Quiti uiche aicüpurutiti Juan Bautista tücañe? ¿Arrti Bae Tuparrü o mañoñüncatai? ¡Aburasoi! ");
INSERT INTO caxNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Auqui ñanquitioma pünanaquimiantoe, namatü: —Arrtü usucana oñü, ta uiti Bae Tuparrü aicüpurutiti, auqui nanti Jesús caüma oemo: “¿Causane chapicocotapü nurarrti?” ");
INSERT INTO caxNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tapürrtü usucana oñü, ta ui arrübamantai mañoñünca aicüpurumati, ¿isanempü pasabobo oemo ui macrirrtianuca, itopiqui arrüma icocotama que arrti Juan Bautista profetarrti tücañe uiti Tuparrü. Birrubuma ñünana macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Auqui namatü ümoti Jesús: —Chütusiopü suiñemo. Auqui nanti Jesús ümoma: —Arrüñü chüpuerurrüpito suraboi ausucarü quiti uiche aitorrimia iñemo isüriacabo, nauqui isamune arr üna sane. ");
INSERT INTO caxNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Auqui manunecanati Jesús ümoma aübu arrüna machepecatarrü. Nanti: —Anati taman ñoñünrrü mancüturuti uva au niyorrti. Nauquiche tanaiña süro cütu uiti, masamunuti sierco itacu. Auqui masamunutito babetarrü canrrü cauta atubarri uva iyo niyürrü. Auqui masamunuti cürurrü petaisürü abeu niyorrti auna cauta ariorrti ape acuirati itacu uva. Auqui prestabo uiti manu niyorrti ümo bama trabajadorerrü. Auqui sürotitü au quiatarrü cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nauquiche tiñatai nitiempo nupucu uva, bacüpuruti ümoti taman imostorrti, nauqui ariorrti anquiti uva pünanaquimia, arrüna tocabo ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Arrümanuma trabajadorerrü chüsamianapü ümoma. Iñenomati maniqui mosorrü cuati iyo uva. Ocüsioma ümoti y icüpurumati tato saneantai. ");
INSERT INTO caxNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Auqui arrti maniqui iyoche bacüpuruti ümoti quiatarrü mosorrü. Isiatai yachücoimia ümoti. Süroti tato bien cuasoti uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bacüpuruti ümoti quiatarrü mosorrü. Arrti caüma coiñoti uimia. Auqui bacüpuruti ümo sürümanama imostorrti, pero sane ito pasao ümoma uimia. Aboma bama obürio ümoma, y maquiataca coiñoma. ");
INSERT INTO caxNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Au nitacürurrü sobürauti tamantiatai, naqui aütorrti. Arrti chiyaupü nicuarrti ümoti. Icüpurutitito. Tacürurrü yacüpucurrti, ñaquioncorrti que macoconaunrrüma ümoti, itopiqui aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero arrümanuma trabajadorerrü namatü ümomantoe: —Arrti naqui torrio ñana ümoti nanaiña arrüna nenarrirrti naqui yaütoti. Mejor uitabairati, nauqui nanaiña oncono oemo. ");
INSERT INTO caxNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Auqui itabairomati. Yarutaübutama nicunturrti pürücü manu ñanaunrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Auqui nanti Jesús: —¿Causanempü caüma uiti maniqui iyoche? Suraboira: Cuati tato caüma y coiñoma uiti manuma trabajadorerrü, nauqui aitorrimiati manu niyorrti ümo maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Champü tüleheboañoinqui icu Nicororrü uiti Tuparrü arrüna nantü sane? Arrübama masamunu poca oboi canca yarutaübutama manu taman canrrü, ñaquiocorrüma churriampü, abu mejor manu canrrü. Pero uiti Bae Tuparrü caüma manu canrrü süro cütu tacana nompacüorrü principal ümo porrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sane isamutenti Tuparrü usucarü. Ocütobüca uirri. (Arrübama fariseorrü tacana bama masamunuma porrü oboi canca. Yarutaübutama arrümanu taman canrrü abu manrrü mejor. Arrti Jesús tacana arrümanu canrrü mejor.) ");
INSERT INTO caxNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Itopiqui arrüna nurarrti Jesús sane, rranrrüma aiprensonoconomati, itopiqui tusio nurria ümoma, ta ümoma manu machepecatarrü. (Arrübama fariseorrü tacana bama trabajadorerrü. Arrti Jesús tacana aütorrti maniqui iyoche. Arrti Bae Tuparrü tacana maniqui iyoche.) Pero birrubuma ñünana genterrü. Sane nauquiche iñoconomati. ");
INSERT INTO caxNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Auqui bacüpuruma ümo bama fariseorrü ichepe bama auqui nesarrti partidorrü Herodes esati Jesús aübu macocotorrü ümoti. Rranrrüma nauqui anitati uimia arrüna uiche puerurrü urabomati. ");
INSERT INTO caxNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aiñanaimia esati. Namatü ümoti: —Maestro, tusio suiñemo, arrücü anunecaca nomirria. Champü nümoche obi arrüna ñapensacarrüma macrirrtianuca. Chairrucapü ñünanama, y ñemanauncurratoe anunecaca nurarrti Tuparrü. Urasoi suisucarü, ¿taqui urria bapaca impuestorrü ümoti yarusürürrü yüriaburrü Cesar, o champü? ");
INSERT INTO caxNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero arrti Jesús tütusiatai ümoti arrüna churriampü ñapensacarrüma aübuti. Nanti ümoma: —¿Causane apiña macocotorrü iñemo? Apitusianca isucarüñü taman monedarrü nauqui yasarai. ");
INSERT INTO caxNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Itusiancatama isucarüti. Auqui ñanquitioti pünanaquimia: —¿Quiti ausüpütuche arrüna icu na monedarrü, y quiti üriche arrüna corobo auna icu? Aiñumuma: —Nausüpüturrti yüriaburrü Cesar y nürirrti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Auqui nanti Jesús ümoma: —Apicoco yacüpucurrti Cesar, y apicoco ito yacüpucurrti Tuparrü. Cütobüsoma ui arrüna sane nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Auqui arrübama mümanamantai auqui manu partidorrü saduceorrü süromatü esati Jesús. Taipü arrübama saduceorrü chicocotapüma arrtü osüboriquia tato, arrtü oconca. Sane nauquiche urapoimia arrüna ñapensacarrüma isucarüti Jesús: ");
INSERT INTO caxNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, arrti Moisés tücañe bacüpuruti sane: “Arrtü anati coiño, y nicüpostoti chaübosioquipü uiti, tiene que apo aübuti yaruquitorrti maniqui coiño, nauqui ane nipiaümacarrü uiti ümoti yaruquitoti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bueno, aboma siete yaruquitorrümantoe. Arrti maniqui yarusürürrü pohosoti, y coiñoti pünanaqui nicüpostoti. Pero champü naübosirri uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Auqui arrti maniqui segundo yaruquitorrti pohosotito aübu. Auqui coiñotito. Chaübosiopito uiti. Sane pasabo ito ümoti maniqui tercero. ");
INSERT INTO caxNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Namanaiña arrümanuma siete pohosoma aübu, y namanaiña coiñoma, pero champü nipiaümacarrü uimia. Au nitacürurrü coiño ito manu paürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Arrtü süboricomapü tato, ¿quitipü naqui icüposüche uturuqui manuma siete? ");
INSERT INTO caxNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aiñumuti Jesús: —Arraño chütusiopü aume, itopiqui chapisuputacaipü Nicororrü uiti Tuparrü, y chütusiopü aume arrüna nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Arrtü süboricoma tato bama tücoiño, chüposopümainqui, itopiqui nacarrüma caüma tacana bama angelerrü, bama aboma au napese. ");
INSERT INTO caxNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero arraño aurrianca atusi aume cütüpü arrüna nosüboriqui tato arrtü oconca. Canapae chülehebopü año au manu librurrü corobo uiti Moisés tücañe, nauquiche manitanati Tuparrü aübuti eanaqui nonco pese apüqui manu suema. Acamanu nanti sane: “Arrüñü Nituparrti Abraham y Nituparrtito Isaac y Nituparrti Jacob”. ");
INSERT INTO caxNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Arrti Tuparrü champürrtü Nitupa bama macoiñoca, ta Nitupa bama süborico. Arraño bien chütusiopü aume. (Itopiqui arrti Tuparrü rranrrti nauqui uiñanaunuti. Abu arrübama coiño chüpuerurrüpümainqui aiñanaunumati. Uirri tusio que arrübama trerrü antiburrü süboricoma tato esati Tuparrü.) ");
INSERT INTO caxNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Auqui tamanti uturuqui manuma manunecana nüriacarrü iñataiti esati Jesús, itopiqui ipiatenti que arrti Jesús iñumutati tato nurria nurarrüma bama saduceorrü. Ñanquitioti pünanaquiti Jesús: —¿Ñacusane arrüna yarusürürrü yacüpucurrti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aiñumuti Jesús: —Tone arrüna yarusürürrü yacüpucurrti Tuparrü pünanaqui nanaiña: “Amonsoi nurria macrirrtianuca auqui Israel. Anati tamantiatai Tuparrü oemo, naqui Señor. Champüti manrrü pürücüti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tari cuasürüti aume Bae Tuparrü aübu nanaiña nabausasü, aübu nanaiña nabausüpü, aübu nanaiña napapensaca y aübu nanaiña naucusüu”. Tone arrüna manrrü yarusürürrü yacüpucurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ane quiatarrü yacüpucurrti isiatai nicuarrü: “Tari cuasürüti aume ausüborisapa tacana naucua aumeampatoe”. Champü quiatarrü bacüpucurrü arrüna manrrü yarusürürrü pünanaqui arrüba torrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Auqui nanti maniqui ñoñünrrü ümoti Jesús: —Maestro, bien ñemanauntu arrüna nura. Ta anati tamantiatai Tuparrü, champüti manrrü quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bien urria arrtü cuasürüti oemo aübu nanaiña nuyausasü, aübu nanaiña numapensaca y aübu nanaiña nuyausüpü y aübu nanaiña nucusüu. Urria ito arrtü cuasürüti oemo osüborisapa. Tone arrüna manrrü valeo ümoti Tuparrü pünanaqui arrüna arrtü macumanaca ausüratai ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Arrti Jesús tusio ümoti, ta manitanati aübu nanaiña nausasürrti. Nanti ümoti: —Champürrtü ichequi naca pünanaquiti Tuparrü. Auqui champütiqui manrrü naqui ñanquitio pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Eana ñanunecacarrti au niporrti Tuparrü ñanquitioti Jesús pünanaquimia: —¿Causane namatü bama manunecana nüriacarrü, que arrti Cristo ta aütorrti David, naqui yüriaburrü tücañe? ");
INSERT INTO caxNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Itopiqui arrti David nanti tücañe uiti Espíritu Santo sane: Arrti Bae Tuparrü nanti ümoti Cristo: “Atümo rrupetacuñü au nepanauncu niñe, cheperrtü bachesoiyoma sobi bama aesa enemigorrü aesacü”. ");
INSERT INTO caxNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Causane nauqui arrti Cristo ta aütorrti David? Itopiqui arrtiatoe David nanti: Arrti Cristo isüriatu. Sürümanama macrirrtianuca onsapetioma nurarrti Jesús, y urria ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Arrti Jesús nantito eana ñanunecacarrti: —Amasasai nurria ñünana bama manunecana nüriacarrü. Tapü apisamute tacana arrüna yachücoimia. Urriantai ümoma amema aübu naibirrimia coñorrtai y abaesa. Urriantai ümoma acuasürüma ümo macrirrtianuca. Rranrrüma nauqui anquimia nurria macrirrtianuca ümoma yusiu cayaca. ");
INSERT INTO caxNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Urria ito ümoma atümoma icu ba tümoca abe bien ümo nisurratoe au ba poca sinagoga y arrtü ane pierrta. Sane ito isamutema. ");
INSERT INTO caxNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Arrüma ito iquiaübutama niyopo biuraca. Auqui caüma meaboma yabaiturrü, abu ñapanturrüma. Tonema bama ñana yasutiuma yarusürürrü carrticurrü itopiqui arrüna sane yachücoimia. ");
INSERT INTO caxNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Taman nanenese anancati Jesús tümonsoti au niporrti Tuparrü saimia ümo manu baurimia auna cauta bacheboma macrirrtianuca monirri ümoti Tuparrü. Arrtayotitü ümo arrüna niyachequirrimia monirri. Aboma sürümanama bama rricurrü bacheboma chama nimonirrimia. ");
INSERT INTO caxNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Au manu rratorrü iñatai taman paürrü biurarrü, pobrerrü. Aiñanio manio torratai monedarrü au manu baurirri, arrüba chimiantai niyucuarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Auqui tasuruma uiti Jesús bama ñanunecasarrti, nanti ümoma: —Ñemanauncurratoe sucanañü aume, arrümanu biurarrü bachebo manrrü chama pünanaqui bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Itopiqui arrüma itorrimiatama nisobüratu nimonirrimia. Tapü arrüna pobrerrü biurarrü itorrimiata nanaiña ar rüna ane uirri. ");
INSERT INTO caxNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nauquiche tüniyücürrtito Jesús auqui niporrti Tuparrü, nanti taman ñanunecasarrti ümoti: —Maestro, asatü ñome ba canca posürümanaca arrüba uiche omirriane ba poca omirriantai. ");
INSERT INTO caxNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aiñumuti Jesús: —Caüma acütobüca ui arrüba poca coñorrtai, y ba canca. Pero ñana chüpuerurrüpü abasio omonüampatoe, ni tamampü canrrü. Nanaiña tiene que amiñarri. ");
INSERT INTO caxNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Auqui süromatito. Aiñanaimia onü manu yiriturrü nürirri Olivos. Arrümanu yiriturrü ane cutaquibo manu niporrti Tuparrü. Acamanu tümonsoti ichepe bama ñanunecasarrti, arrti Pedro, arrti Jacobo, arrti Juan y arrti Andrés. Arrüma ñanquitioma pünanaquiti anecanatai, namatü sane: ");
INSERT INTO caxNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Urasoi suisucarü, ¿auche ñana pasabo arrüna ucanü one, que omiñarrio arrümanio poca omirriantai? ¿Isane señarrü arrüna uiche atusi? ");
INSERT INTO caxNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Auqui nanti Jesús ümoma: —Apacuira nurria autacuapatoe, tapü anati naqui encañao aume. ");
INSERT INTO caxNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Itopiqui tiene que ayematü sürümanama bama namatü que manunecanama au nisüri, y namatü sane: “Arrüñü Cristo”. Sürümanama macrirrtianuca batacheboma uimia ui arrüna ñapanturrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Arrtü amoncoi nüri guerra, tapü aupirruca. Itopiqui tiene que acoco arrümanu sane, pero champürrtü tone nitacürurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nacioneca pahiyo ñomeampatoe. Mayüriabuca bahiyoma aübumantoe. Paichoconono cürrü au nanaiñantai. Ane ito carestiya. Sane aübapae ane nitaquisürücü macrirrtianuca icu na cürrü. Pero champürrtü tünitacürurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Apacuira nurria autacuapatoe, itopiqui tiene que aitorrimianama año mecu bama mayüriabuca. Icübairoma año au ba poca sinagoga. Iquianama año esa bama mayarusürüca mayüriabuca auqui niyaca, nauqui puerurrü aburaboi nisüri isucarüma. ");
INSERT INTO caxNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero primero tiene que atusi au nanaiñantai icu na cürrü arrüna urria manitacarrü isütüpüñü. Auqui caüma iñatai ñapacümuncuturrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Arrtü iquianama año esa bama mayüriabuca, tapü apapensaca isane arrüna aburapoboibo isucarüma, ta aburasoi arrüna torrio aume aburapoboibo uiti Tuparrü au manu rratorrü, itopiqui champürrtü arraño na apanitaca, ta arrti Espíritu Santo naqui manitana abauqui. ");
INSERT INTO caxNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aboma ito bama ñana paventeoma uimia ümo bama mayüriabuca arrübama propiorratoe yaruquitorrüma, y sane coiñoma auqui nacarrüma. Aboma ito bama paventeoma uimia bama aütorrümantoe. Y arrübama mayaüca tiene que atüborimia ümo bama yaütorrüma, sane nauqui ataborimia itopiquimia. ");
INSERT INTO caxNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Namanaiña macrirrtianuca tüboricomantai aume auqui niyaca. Pero arrti naqui chiñocotatipü nisura chepe nitacürurrü, tonenti naqui tiene que aye uiti au napese. ");
INSERT INTO caxNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Arrti profetarrü Daniel maconomonoti tücañe cütüpü manu ünantapae. Arrtü amarrtai arrümanu churriampatai auna cauta chücoñopütü ane, au niporrti Tuparrü, auqui caüma arrübama abomainqui au Judea tari yesüburama ubuturu yirituca. ");
INSERT INTO caxNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Arrti naqui anati batrabacarati chacu niporrti, tapü sürotipo aiquianti nenarrirrti. ");
INSERT INTO caxNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Arrti naqui anati au niyorrti, tapü süroti tato au niporrti aiquianti naibirrti. Mejor tari yesüburati saneantai. ");
INSERT INTO caxNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Butaquisüratai arrüba paüca aübo ane omemecu y arrüba ane niñupaümacarrü yocütüpü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Apanqui pünanaquiti Tuparrü tapü pasao arrüna sane, arrtü tarucapae rrimianene. ");
INSERT INTO caxNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Itopiqui au manio naneneca ñana chiyaupü nitaquisürücü bama macrirrtianuca. Champü tüpasao sane auqui numo maübo tücañe urriane na cürrü, ni anempito ñana. ");
INSERT INTO caxNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Arrtü nampü chichimiancatatipü Tuparrü manu tiemporrü nesa taquisürücürrü, champütipü naqui süboricoiqui. Pero como tarucu nicuarrüma bama tacümanauncunu ümoti Tuparrü, sane nauquiche ichimiancatati manu tiemporrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Namatito ñana aume sane: “Amasasai, auna nacarrti Cristo. Amasasatü, taha nacarrti”. Pero arraño tapü apicocota. ");
INSERT INTO caxNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Itopiqui sürümanama ito bama cuamatü aübu ñapanturrüma y namatü: “Arrüñü Cristo”. Namatito: “Arrüñü rranunecaca au nürirrti Tuparrü”. Masamunuma ito milagrorrü, nauqui sane manrrü puerurrü encañama ümo macrirrtianuca. Rranrrüma encañama ito ümo bama tacümanauncunu uiti Tuparrü, arrtü puerurrüpü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amasasai nurria, chauqui tüsurapoi ausucarü, ta sane pasabobo ñana. ");
INSERT INTO caxNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Au manio naneneca arrtü tüpasao manu taquisürücürrü, surrü y pama chüpuerurrüpü nauqui aucua. ");
INSERT INTO caxNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Norrtoñeca bupaquio icu cürrü. Nanaiña arrüba icu napese mupaichoconono. ");
INSERT INTO caxNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Auqui caüma asaramatü macrirrtianuca iñemo Ñemanauncurratoe Ñoñünrrü. Isecatü auqui napese eana cüsaüboca aübu nanentacarrü sobi y aübu tarucu nisusüu. ");
INSERT INTO caxNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Au manu rratorrü rracüpuca ümo bama niyesa angelerrü nauqui aiyoberabarama bama icocoromañü auqui nanaiñantai icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Apipia arrüna machepecatarrü apü manu suese higuera. Arrtü aübapae nasurrü tato, arraño tütusio aume que ta tüsaimia nitiempo tanaunrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Isiu ito arrtü amarrtai tirranrrü acoco nanaiña arrüna pasabobo, chauqui tütusio aume, ta tüsaimia ñapacümuncuturrti Tuparrü, nauqui ise tato icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ñemanauncurratoe sucanañü aume: Enterurrü arrüna sucanañü aume tiene que acoco isucarü bama macrirrtianuca caüma, antes que acoma. ");
INSERT INTO caxNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Arrüna cürrü y napese omiñarrio ñana, pero nisura chüpuerurrüpü nauqui amenso, cheperrtü tücocono nanaiña. ");
INSERT INTO caxNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero champüti atusi ümoti arrümanu nanenese ni horarrüpü arrüna auche ñana isetü. Ni arrübamapü angelerrü auqui napese, ni arrüpüñü naqui Aütorrti Tuparrü atusi iñemo. Ta cunauntaiñatiatai Bae Tuparrü tusio ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sane nauquiche amasasai nurria itacu nausüboriqui, itopiqui chütusiopü aume auche ñana ise tato. ");
INSERT INTO caxNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Arrüna nisequi tato toneantoe tacanarrtü tamanti ñoñünrrü sürotitü iche. Oncono uiti niporrti mecu bama imostorrti. Torrio uiti ümoma taiquiana taman arrüna yachücoboiboma. Bacüpurutito ümoti taman acuirati nurria itacu tururrü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sane isamutenti maniqui ipoche. Pero chütusiopü ümoma auche aiñanainti tato. Rrepente iñataiti arrtü aübo ütobi, o arrtü cümuinta tobiri, o arrtü cuatü nanenese, o arrti tansürapae. Sane ito arraño, amasasai nurria. ");
INSERT INTO caxNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Rrepenteatai isecatü. Tapü autabücatai sobi chaparrüperacapü isumenuñü. ");
INSERT INTO caxNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Arrüna sucanañü aume, sucanañü ito ümo bama m aquiataca: Aparrüpera. ");
INSERT INTO caxNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Faltabo torrü nanenecaiqui ümo manu pierrta parrcua. Au manu pierrta basoma pan champü levadura eana. Arrübama üriatu bama sacerdoterrü y arrübama manunecana nüriacarrü bapacheroma niquiubuma nauqui aiñenomati Jesús anecanatai, nauqui aitabairomati. Namatü: ");
INSERT INTO caxNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Chüpuerurrüpü uiñenoti au na pierrta, itopiqui sürümanama macrirrtianuca; rrepente ñana tüboricoma oemo. ");
INSERT INTO caxNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Arrti Jesús anancati au Betania au niporrti Simón, naqui tücañe maunrrocono ui lepra. Acamanu amoncoma tümonsoma esa mensarrü basoma. Auqui iñatai esama taman paürrü aübu taman boteyarrü canrrü alabastro, ataso ui nasaite nürirri narde, urriantai norimia. Arrümanu nasaite chiyaupü nicuarrü. Acamanu itanumata manu boteyama. Aiyarapa itati Jesús arrümanu narde. ");
INSERT INTO caxNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Uturuqui manuma amoncoma acamanu ünantü ümoma. Namatü ümomantoe: —¿Causanempü nauqui aiñensonoco manu nasaite? ");
INSERT INTO caxNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Abu puerurrüpü aipiaventeca itobo trescientos denarios (trescientos jornalerrü) o hasta manrrüqui, nauqui aruquipü atorri ümo bama pobrerrü. Sane nauquiche tüboricoma ümo manu paürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tapü arrti Jesús nanti ümoma: —Asio sane, tapü abasiquia icuata. Arrüna isamute iñemo, ta urria. ");
INSERT INTO caxNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Arrübama pobrerrü siemprerrü aboma abarrüpecu, puerurrü apisamune arrüba nomirria aübuma, arrtü aurrianca. Pero arrüñü chüpuerurrüpü yasiquia abarrüpecu ñana. ");
INSERT INTO caxNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Arrüna paürrü isamute iñemo isiu arrüna puerurrü. Isemanañü arrümanu perfume urriantai norimia ümo ñana, arrtü iñanamañü cütu. ");
INSERT INTO caxNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ñemanauncurratoe sucanañü aume: Arrtü aboma bama süromatü uraboimia arrüna urria manitacarrü au nanaiña icu na cürrü, urapoimia ito arrüna nisamute na paürrü iñemo, nauqui aquionomacü iyo. ");
INSERT INTO caxNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tamanti uturuqui manuma doce apostolerrü nürirrti Judas Iscariote, sürotitü anitati aübu bama üriatu bama sacerdoterrü. Uraboiti isucarüma ta puerurrti aitorrimianatiti Jesús emecuma. ");
INSERT INTO caxNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nauquiche oncoimia arrüna sane, pucünuñama nurria, y namatü ümoti tiene que achema monirri ümoti. Auqui arrti Judas bapacheroti niquiubuti, nauqui aitorrimianatiti Jesús ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Iñatai manu primer nanenese nesa manu pierrta parrcua, arrüna auche basoma pan champü levadura eana. Batabaiyoma ito nobirrarrü au manu nanenese, arrüna niyacheatarrüma. Sane nauquiche arrübama ñanunecasarrti Jesús ñanquitioma pünanaquiti: —¿Cauta arrianca nauqui ariorroñü mapema nauqui uba ümo na parrcua? ");
INSERT INTO caxNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Auqui bacüpuruti ümo torrüma ñanunecasarrti: —Amecosi au pueblurrü. Taha tiene que apicuñunuti taman ñoñünrrü aübu bausürrü ompacüti aübu turrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Amecosi isiuti auna cauta niyücürrti. Arrtü sürotipo au taman porrü, amucanaño ümoti maniqui ipoche: “Arrti maestro nanti sane: ¿Cauta naca manu cuarto arrüna cauta puerurrü irra aübu bama nirranunecasa ümo na pierrta parrcua?” ");
INSERT INTO caxNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Auqui caüma itusiancatati ausucarü arrümanu taman cuarto sürümanarrü, ane ape onü quiatarrü cuarto, tüchauqui oemo. Acamanu apapema oemo. ");
INSERT INTO caxNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Auqui süromatü manuma torrü. Nauquiche iñataimia au pueblurrü, isamutema isiu arrüna nurarrti Jesús ümoma. Acamanu mapemanama ümo manu pierrta parrcua. ");
INSERT INTO caxNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nauquiche aübapae ütobi, arrti Jesús iñataiti ichepe bama maquiataca apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Atümoma. Basoma. Isiu niyacarrüma nanti Jesús ümoma: —Ñemanauncurratoe sucanañü aume: Anati taman abuturuqui aipiaventecanatiñü caüma. ");
INSERT INTO caxNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sane nauquiche sucheboma. Taiquianati taman ñanquitioma pünanaquiti: —¿Taqui arrüñü? ");
INSERT INTO caxNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aiñumuti Jesús: —Tamanti naqui ameanaqui naqui basoti ichepeñü auqui nipratu. ");
INSERT INTO caxNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que acoco saübuñü nanaiña arrüna ane corobo. Pero pobrerrtiatai naqui uiche aipiaventecanatiñü. Manrrüpü urria arrtü champüti icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Auqui niyacarrüma iquiatati Jesús pan mecuti y machampiencanati ümoti Tuparrü. Ichepesünatati y itorrimiatati ümo bama apostolerrü. Nanti: —Aumase, itopiqui arrüna tone nisütüpü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Auquito iquiatati coparrü mecuti aübu vinorrü. Machampiencanatito ümoti Tuparrü. Auquito itorrimiatati ümoma, y namanaiña chaboma auqui. ");
INSERT INTO caxNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nanti: —Tone niñoto, arrüna araparabo caüma nauqui urria tato nisüboriquirrimia bama sürümanama macrirrtianuca. Ui niñoto tusio arrüna nuevurrü tratorrü uiti Tuparrü aübu genterrü icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ñemanauncurratoe sucanañü aume: Arrüñü chüpuerurrüpü ichaiqui arrüna vinorrü, niyü uva, cheperrtü türiabucati Tuparrü, naqui Iyaü. Auqui ichaca tatito. ");
INSERT INTO caxNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nauquiche tüchauqui ñacantacarrüma ümoti Tuparrü, süromatü onü manu yiriturrü nürirri Olivos. Acamanu nanti Jesús ümoma: ");
INSERT INTO caxNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nanaiña arraño tiene que apiñoconoñü arrüna tobirri. Itopiqui sane nantü icu Nicororrü uiti Tuparrü: “Itabairoti naqui bacuirara yutacu nobirraca. Sane nauquiche caüma nobirraca omiñarrio”. ");
INSERT INTO caxNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero arrtü isüboriquia tato, isusürüca yerotü amopünanaqui au Galilea. ");
INSERT INTO caxNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Auqui nanti Pedro ümoti: —Arrtü iñoconomacü maquiataca, pero arrüñü chüpuerurrüpü iñoconü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nanti Jesús ümoti: —Ñemanauncurratoe sucanañü aemo: Caüma na tobirri antes que rabotü torrü nipucu curasürrü pohorrü, arrücü ucanü trerrü veserrü chasuputacapüñü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero arrti Pedro chunatipü, nanti: —Arrtü isonca achepecü, chüpuerurrüpü sucanañü ta chisuputacapücü. Sane ito nurarrüma bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aiñanaimia au manu nürirri Getsemaní. Acamanu nanti Jesús ümo bama ñanunecasarrti: —Autümo auna. Arrüñü yecatü manrrü tahiqui, nauqui rrehan ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tasuruma uiti isiuti arrti Pedro, arrti Jacobo y arrti Juan. Au manu rratorrü onquisioti yarusürürrü nisuchequirrti y tarucu nirrucurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Auqui nanti ümo manuma trerrü: —Ñonquisio tarucapae nisuchequi ñünana concorrü. Abasiquia auna, tapü aumpanuca. ");
INSERT INTO caxNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Auqui sürotitü manrrü tahiqui pario. Bachesoiyoti. Ñanquitioti pünanaquati Tuparrü arrtü puerurrü apasa pünanaquiti arrümanu taquisürücürrü cuabotiqui ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Au manu neancarrti nanti sane: —Iyaü, champü arrüna cuestarrü aemo. Aitaesümusuñü ñünana arrüna taquisürücürrü cuabotü iñemo. Pero tapü aisamute isiu nirranca, ta isiu narrianca, arrücü Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Auqui süroti tato esa manuma trerrü. Aboma manumuma. Auqui nanti ümoti Pedro: —Simón, ¿anuca? ¿Champürrtü puerurrücü asiquia arrtaiquiatü ichepeñü ni ümopü taman horarrü? ");
INSERT INTO caxNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tapü aumpanuca. Apanqui pünanaquiti Tuparrü, nauqui urria nabaca, arrtü cuatü macocotorrü aume. Nabausüpü rranrrü ümo nomirria, pero naucütüpü chücusüurupü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Auqui süroti tatito apariti aübuti Tuparrü. Sane tatito nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cuati tatito esama. Aboma manumuma tatito, itopiqui tarucu nirrancarrüma anuma. Chütusiopü ümoma isane urapoboiboma isucarüti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nauquiche tütabe trerrü niyücürrti esama, nanti ümoma: —¿Caüma puerurrü aumpanu y apacansa? Ta chauqui tiñatai manu horarrü, arrüna auche caüma itorrimianamañü mecu bama chiyaupü nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Apatüsai, curi tato. Chauqui tücuati naqui uiche aipiaventecanatiñü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nauquiche anancatiqui manitanati aübuma, iñataiti Judas, naqui uturuqui manuma doce apostolerrü. Cuati ichepe sürümanama mañoñünca yupu sueca y cüseca. Arrüma cuamatü yacüpucurrüma bama üriatu bama sacerdoterrü y bama manunecana nüriacarrü y bama mamayoreca. ");
INSERT INTO caxNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Arrti Judas tünanti ümoma manuma mañoñünca sane: —Rranquiquia nurria ümoti caüma aübu besorrü ümoti, ta tonenti. Apiñensorrti. Apiquiarrti. Amasasatü nurria itacuti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nauquiche iñataiti esati Jesús, nanti ümoti: —Chamurraume maestro. Auqui bacheboti besorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sane caüma iñemomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero tamanti uturuqui manuma ñanunecasarrti iquiaübutati nicüserrti y bacheboti ümoti maniqui imostorrti yarusürürrü sacerdoterrü. Tüsüro uiti taman numasurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Auqui nanti Jesús ümo manuma mañoñünca: —Arraño abecatü yupu sueca y cüseca, nauqui puerurrü apiquianañü au preso, tacanapaepü cusüpürrüñü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naneneca anancañü abarrüpecu. Rranunecaca au niporrti Tuparrü. Pero arraño champü causane aboi iñemo. Arrüna sane es nauqui acoco arrüna nantü icu Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Auqui arrübama ñanunecasarrti iñoconomati, besüburuma. ");
INSERT INTO caxNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero tamanti yaürrü sürotitü isiuti. Naibirrti nicüburrirrtiatai. Auqui rranrrümampü aiñenomatito. ");
INSERT INTO caxNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tapü arrti iñocotati manu nicüburrirrti mecuma y besüburuti cüsuasati. ");
INSERT INTO caxNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Auqui iquianamati Jesús au niporrti maniqui yarusürürrü sacerdoterrü. Acamanu iyoberabaramacü namanaiña arrübama üriatu sacerdoterrü y arrübama mamayoreca israelitarrü y arrübama manunecana nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tapü arrti Pedro anancati sürotitü isiuti Jesús auqui icheatai. Iñataiti au manu nusuara esa niporrti maniqui yarusürürrü sacerdoterrü. Acamanu atümoti arrüpecu manuma masortaboca, baperoti pese. ");
INSERT INTO caxNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Arrti yarusürürrü sacerdoterrü ichepe manuma amoncoma acamanu bapacheroma niquiubuma, causane nauqui ane nipünatenti Jesús, nauqui puerurrü aitabairomati. Pero champü isane nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sürümanama bama manitanama ünantatai icütüpüti, ñapanturrüma, pero chichepepatai nurarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aboma ito bama atüraimia nauqui urabomati; sane nurarrüma aübu ñapanturrüma: ");
INSERT INTO caxNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Arrüsomü somoncoi nurarrti sane: “Tiene que iñarrimiaca niporrti Tuparrü, arrüna nisamucurrüma bama mañoñüncatai. Iyau trerrü naneneca tiene que iñatünaiñaca tato quiatarrü, arrüna chisiupü tacana nisamucurrümantai bama mañoñünca”. ");
INSERT INTO caxNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero chichepepito nurarrüma, sane nauquiche chüvaleopü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Au nitacürurrü atüraiti yarusürürrü sacerdoterrü y ñanquitioti pünanaquiti Jesús: —¿Causane chaiñumutapü arrüna nurarrüma aemo? ");
INSERT INTO caxNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero arrti Jesús süsioti etaiyoitiatai, chiñumutatipü. Auqui arrti yarusürürrü sacerdoterrü ñanquitioti tatito pünanaquiti: —¿Arrücü Cristo, Aütorrti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Auqui nanti Jesús: —Arrüñü. Arraño tiene que amasarañü naqui Ñemanauncurratoe Ñoñünrrü yaca ñana ichümoca au nepanauncurrti Tuparrü, naqui champü tacanache nüriacarrti. Tiene que amasarai nisequi tato auqui napese omeana cüsaüboca. ");
INSERT INTO caxNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ui arrüna sane nurarrti Jesús arrti yarusürürrü sacerdoterrü iquiompünatati naibirrti ui nitüborirrti, nanti sane: —Champü nümoche basiquiaiqui bapacheti terrticurrü, itopiqui chauqui tünanti uirrtiatoe. ");
INSERT INTO caxNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Arraño chauqui tamoncoi arrüna churriampü nurarrti ümoti Tuparrü. Ane nipünatenti. ¿Aburaño sane? Auqui namanaiña namatü: —¡Tari comati! ");
INSERT INTO caxNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sane nauquiche aboma bama uturriquiyoma isuti. Itamurriquiatama nisurrti, ocüsioma ümoti y namatü ümoti: —¿Tusio aemo quiti ocüsio aemo? Arrübama masortaboca bacheboma ito isuti. ");
INSERT INTO caxNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tapü arrti Pedro anancati türüpoatai. Au manu rratorrü iñatai manu nicumanacatarrti yarusürürrü sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Besüro narrtarrü ümoti Pedro, anancati baperoti pese. Auqui arrtayotü nurria ümoti, nantü ümoti: —Arrücü ito anancü ichepe Jesús, arrümanu auqui Nazaret. ");
INSERT INTO caxNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aiñumuti Pedro aübu ñapanturrti ümo, nanti sane: —Chisuputacatipü, ni atusipü iñemo isane arrüna asiquia anquirio rropünanaquiñü. Auqui sürotitü türüpo. Au manu rratorrü puru taman pohorrü. ");
INSERT INTO caxNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Coboi pario arrümanu cumanacarrü asaratü tatito ümoti y nantü ümo manuma amoncoma acamanu: —Arrüna noñünrrü tone arrüna uturuqui arrümanio amonquio isiu Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero arrti Pedro mapañati tatito. Auqui arrümanuma amoncoma acamanu namatü tatito ümoti: —Ñemanauntu, saon, arrücü anancü ichepema ito. Itopiqui arrücü auqui Galilea ito, chanecanapatai ui nura, toneantoe tacana nurarrüma. ");
INSERT INTO caxNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Auqui arrti Pedro itusiancatati curusürrü y ipiaurramacanatiyü. Nanti sane: —Chisuputacatipü maniqui ñoñünrrü naqui iyoche nabura. ");
INSERT INTO caxNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Au manu rratorrü puru tatito pohorrü. Auqui aquionotiyü Pedro ümo arrümanu nurarrti Jesús ümoti tücañe sane: “Antes que abe torrü nipucu pohorrü ucanü trerrü vecerrü ta chasuputacapüñü”. Auqui or ronene nurria ümoti. Areoroti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nauquiche tücuatü nanenese, iyoberabaramacü tatito namanaia bama üriatu sacerdoterrü ichepe bama mamayoreca y bama manunecana nüriacarrü. Iquianamati Jesús esati yüriaburrü rromano, nürirrti Pilato. Itorrimianamati Jesús mecuti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Auqui arrti Pilato ñanquitioti pünanaquiti Jesús: —¿Así que arrücü üriatu bama israelitarrü? Aiñumuti Jesús: —Arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Arrübama üriatu bama sacerdoterrü urabomati isucarüti Pilato. ");
INSERT INTO caxNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Auqui arrti Pilato ñanquitioti tatito pünanaquiti Jesús, nanti: —¿Causane chaiñumutapü? Arrüma asioma urabomacü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero arrti Jesús chiñumutatipü. Sane nauquiche arrti Pilato cütobüsoti, chütusiopü ümoti causane uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Arrti Pilato yacheatarrti aitaesümunutiti taman ñoñünrrü auqui preso ümo manu pierrta parrcua isiuqui arrüna ñanquitioma bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Au manu tiemporrü anancati au preso taman ñoñünrrü nürirrti Barrabás, y amoncoma ito maquiataca ichepeti au preso. Arrüma batabayoma macrirrtianuca tücañe y bahiyoma aübu mayüriabuca y masortaboca. Sane nauquiche aboma au preso. ");
INSERT INTO caxNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Auqui iyoberabaramacü sürümanama macrirrtianuca esa niporrti Pilato, nauqui anquirioma pünanaquiti naqui aisamunenti arrüna niyacheatarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Arrti Pilato nanti: —¿Aurrianca nauqui iñemecanati üriatu bama israelitarrü? ");
INSERT INTO caxNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Itopiqui tusiatai ümoti Pilato que arrübama üriatu sacerdoterrü ubatioma arrüna coñorrtai ñanunecacarrti Jesús, y uirri aitorrimianamati ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero arrübama üriatu bama sacerdoterrü manitanama fuerte ümo macrirrtianuca, nauqui anquiriomati Barrabás, nauqui ataesübuti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aiñumuti Pilato sane: —¿Isane aurrianca nauqui isamune aübuti naqui amucanaño ümoti üriatu bama israelitarrü? ");
INSERT INTO caxNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tosibicoma sane: —¡Aiñarrti apü curusürrü! ");
INSERT INTO caxNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Auqui nanti Pilato: —Isanemo arrüna nipünatenti? Manrrü nitosibirrimia: —¡Aiñarrti apü curusürrü! ");
INSERT INTO caxNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Arrti Pilato rranrrti nauqui urria nisüboriquirrti aübu macrirrtianuca. Sane nauquiche iñemecanatiti Barrabás. Auqui bacüpuruti nauqui aicübairomati Jesús. Auqui itorrimianatiti mecu bama masortaboca, nauqui aicünamunucunumati apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Auqui arrümanuma masortaboca iquianamati Jesús türüpo au manu nusuara. Acamanu iyoberabaramacü namanaiña masortaboca. ");
INSERT INTO caxNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iñatama aibiboti cüturiqui. Masamunuma itarusüboti cümeca y iñatama itati. ");
INSERT INTO caxNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Auqui tosibocoma ümoti sane: —¡Viva ümoti naqui üriatu bama israelitarrü! ");
INSERT INTO caxNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bacheboma itati ui boquirri. Utureuruma cütüpüti. Bachesoiyoma esati anauma ümoti aübu nuncurrüma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nauquiche chauqui nuncurrüma ümoti, iquiaübutama icütüpüquiti manu naibirri cüturiqui. Iñatama tato icütüpüti naibirrtiatoe. Auqui iquianamati türüpo, nauqui aiñanamati apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Acamanu anancati taman ñoñünrrü nürirrti Simón auqui manu pueblurrü nürirri Cirene, yaütoti Alejandro y Rufo. Aübo aiñanainti tato auqui ñanaunrrü. Pasaoti auqui manu. Sane nauquiche arrübama masortaboca icüpurumati nauqui aiquianti nicurusürrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iquianamati Jesús au manu nürirri Gólgota. Arrüna nürirri nantü auqui besüro: “Nipiai nitanu macoiñoca”. ");
INSERT INTO caxNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Acamanu bacheboma ümoti vinorrü aübu nansibirri eana. Pero arrti champürrtü ichapautati. ");
INSERT INTO caxNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Auqui icünamunucunumati apü curusürrü. Auqui caüma manuma masortaboca sorteabo uimia naibirrti, na atusi ümoma quiti ümoche tocabo. ");
INSERT INTO caxNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve tansürü tücañe, nauquiche iñanamati apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iñatama ito nicororrü icuta nicurusürrti, nauqui atusi arrüna nipünatenti. Arrümanu nicororrü nantü sane: “Tonenti naqui üriatu bama israelitarrü”. ");
INSERT INTO caxNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Torrü mañoñünca ito cürabuma uimia apü nicurusürrüma, macusüpüca, tamanti au ñepanauncurrti Jesús, arrti quiatarrü au nepaurrti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sane nauquiche cocono nanaiña arrüna nantü icu Nicororrü sane: “Iñanamati tacana arrübama tarucu nipünatema”. ");
INSERT INTO caxNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Arrübama pasaoma auqui manu esaquiti, unumati. Itatobiromacü nurria, namatü: —Arrücü ucanü tücañe tiene que aiñarrimiaca niporrti Tuparrü y au trerrü naneneca aiñatünaiñaca tato. ");
INSERT INTO caxNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Caüma puerurrü aitusianca, arrtü puerurrücü aiquiaüburü obiatoe apüqui nacurusü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sane ito ui bama üriatu sacerdoterrü y bama manunecana nüriacarrü. Unumatito, namatü ümomantoe: —Arrti ocümati itacu maquiataca, pero itacutiatoe ta chüpuerurrtipü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Arrtü ñemanauntu ta tonenti Cristo, üriatu bama israelitarrü, tari iquiaüburutiyü uirrtiatoe apüqui manu curusürrü, nauqui basarai. Auqui caüma tiene que uicoco. Arrümanuma torrü macusüpüca amoncoma ichepeti apü curusürrü unumatito. ");
INSERT INTO caxNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nauquiche tütoce, rrepenteatai tomiquianene icu cürrü chepe las tres isiu nimümürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Au manu rratorrü arrti Jesús tosibicoti fuerte, nanti sane: —Eloi, Eloi, ¿lama sabactani? —Auqui besüro nantü sane: “Iyaü, Iyaü, ¿causane aiñoconoñü?” ");
INSERT INTO caxNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Uturuqui manuma amoncoma acamanu oncoimia manu nitosibirrti, namatü: —Amonsoi, canapae yabirotiti profetarrü Elías. ");
INSERT INTO caxNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Auqui sürotitü maniqui taman uturuquimia yarucurrti aipiancati taman rriese ui vinorrü ocoro. Aiñanti icutacu suema. Aürotitü esati Jesús nauqui aitorrimiati ümoti, nanti: —Basaraira arrtü cuati caüma Elías aiquiaüburutiti apüqui na curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Auqui arrti Jesús tosibicoti tatito fuerte, auqui coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Au manu rratorrü quiopüro manu cortinarrü au niporrti Tuparrü auqui ape chepe acü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nauquiche tarrtaiti niconcorrti Jesús maniqui üriatu masortaboca, nanti: —Ñemanauncurratoe arrti naqui ñoñünrrü ta toenti Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Acamanu amonquio ito paüca pasaborico auqui ichiatai. Ananca María Magdalena ichepe Mariarrü arrüna nipiacütoti José y Jacobo naqui tapaurrirri, y ananca ito Salomé. ");
INSERT INTO caxNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tonehio arrümanio paüca amonquio isiuti Jesús, numo anancatiqui au manu cürrü Galilea, payurara ümoti. Acamanu amonquio ito piquiataca paüca arrüba cuantio ichepeti au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chauqui tütobiquia, niyücürrü ümo manu nanenese nesa macansacarrü. Auqui cuati maniqui taman ñoñünrrü nürirrti José auqui manu pueblurrü nürirri Arimatea. ");
INSERT INTO caxNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arrti tamanti uturuqui manuma mayüriabuca au Jerusalén. Anancatito barrüperarati arrtü türiabucati Tuparrü. Arrti sürotitü esati Pilato aübu nanaiña nirrancarrti anquirioti nicunturrti Jesús pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Arrti Pilato cütobüsoti, nauquiche oncoiti que arrti Jesús chauqui tücoiñoti. Sane nauquiche itasurutiti maniqui üriatu bama masortaboca, nauqui anquirioti nurria pünanaquiti arrtü ñemanauntu coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nanti maniqui üriatu masortaboca ta ñemanauntu. Sane nauquiche chebo uiti ümoti José nauqui aürotü nicunturrti Jesús uiti. ");
INSERT INTO caxNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Arrti José acomorabo uiti cüburriquia bien omirria. Auqui sürotitü yupu, nauqui aiquiaübuti nicunturrti Jesús apüqui curusürrü. Icümurriancatati nurria oboi manio cüburriquia. Auqui iñatati au manu nusutu canrrü. ");
INSERT INTO caxNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Acamanu amonquio María Magdalena ichepe Mariarrü nipiacütoti José. Arrio umarrtai nurria arrüna ca uta aiñanti José nicunturrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pasao manu nanenese nesa macansacarrü (sabaro). Nauquiche tüsüro cütu surrü, María Magdalena ichepe nipiacütoti Jacobo y Salomé pacomporara perfume, arrüna uiche apisema nicunturrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tansürapae tominco omenotü esa manu nusuturrü, aübapae ayetü tanene surrü. ");
INSERT INTO caxNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Munantü ñomeampatoe: —¿Uichepü caüma aiquiaübu oemo arrümanu canrrü sürümanarrü ituruqui manu nusuturrü? ");
INSERT INTO caxNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nauquiche opiñatai esa nusuturrü umarrtai champürrtü anancaiqui manu canrrü ituru. ");
INSERT INTO caxNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Omenompo apasabori. Besüro numarrtarrü ümoti taman yaürrü. Anancati tümonsoti au nepanauncu manu nusuturrü. Purusubi naibirrti y abaesa. Bocütobüso. ");
INSERT INTO caxNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tapü arrti nanti ñome: —Tapü aupirruca. Arraño apapachequiucati Jesús, nauqui aqui Nazaret. Chauqui tüsüboricoti tato, champütiqui auna. ");
INSERT INTO caxNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amasasai arrüna cauta anancati, champütiqui. Amecosi aburaboi isucarü bama ñanunecasarrti y isucarüti Pedro. Amucanaño sane ümoma: Arrti Jesús cusürüboti aürotitü amopünanaqui au Galilea. Taha amasacati isiu arrüna nurarrti aume tücañe. ");
INSERT INTO caxNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Auqui arrümanio paüca cuantio tato türüpü auqui manu nusuturrü yuparucurrü, tarucu niyopirrucurrü. Champürrtü uburapoi ui niyopirrucurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Arrti Jesús süboricoti tato au manu cuatü nanenese ümo tominco. Itusiancanatiyü primero isucarü María Magdalena arrüna bacüpuruti tücañe ümo bama siete machoboreca auqui, numo anancatiqui amencoti. ");
INSERT INTO caxNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tone sürotü uraboi isucarü bama amoncoma tücañe ichepeti Jesús. Arrüma aboma sucheboma y areoroma. ");
INSERT INTO caxNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nauquiche turapoi isucarüma ta tüsüboricoti tato Jesús, arrüma chicocotapüma. ");
INSERT INTO caxNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Auqui itusiancanatiyü Jesús isucarü manuma torrü isiu cutubiurrü au quiatarrü nacarrti. ");
INSERT INTO caxNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Arrüma süromatü uraboimia isucarü maquiataca, pero chicocotapüma. ");
INSERT INTO caxNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Manrrü isiu nimümürrü itusiancanatiyü isucarü manuma once apostolerrü, nauquiche amoncoma basoma. Acamanu cuasoma uiti, itopiqui chicocotapüma nurarrüma bama itusiancanatiyü isucarüma, nauquiche urapoimia isucarüma ta chauqui tüsüboricoti tato. ");
INSERT INTO caxNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Auqui nanti ümoma: —Amecosi au nanaiñantai icu na cürrü aburaboi arrüna nomirria isucarü namanaiña macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Arrti naqui icocorotiñü y ürioti, taesüburuti pünanaqui carrticurrü, tiene que aye uiti au napese. Tapü arrti naqui chicocorotipüñü, cuatü ümoti carrticurrü. ");
INSERT INTO caxNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Arrübama icocoromañü tiene que aisamunema isiu arrüna nisüriaca. Bacüpuruma ümo machoboreca auqui macrirrtianuca au nisüri. Sobi Manitanama auqui piquiataca manitacaca. Iñentama noirroborrü pero chüpuerurrüpü ane nipenese ümoma. ");
INSERT INTO caxNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Arrtü chaboma pichararrü chüpuerurrüpü ane causane uirri ümoma. Iñatama nehesüma ita bama maunrrocono, y urriancama tato uimia. ");
INSERT INTO caxNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chauqui nipiarirrti Señor Jesús aübuma, sürotitü au napese. Tümonsoti au nepanauncurrti Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tapü arrübama ñanunecasarrti süromatü au nanaiñantai, nauqui uraboimia arrüna urria manitacarrü. Arrti Señor Jesús bayurarati ümoma, sane nauqui puerurrüma asamuma milagrorrü. Amén.");
INSERT INTO caxNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aboma sürümanama bama maconomonoma arrüna pasabo tücañe uyarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Arrüma oncoimia nurarrüma bama amoncoma tücañe ichepeti Jesús auqui maübo, bama manunecana caüma nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Arrüñü ito yacatü rranquirio nurria pünanaquimia, nauqui atusi nurria iñemo arrüna pasabo auqui numo aübapae. Sane nauquiche rraconomoca tanu aemo, naqui Teófilo, ");
INSERT INTO caxNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nauqui atusi nurria aemo que ñemanauncurratoe arrüna manunecacarrü toncoi. ");
INSERT INTO caxNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tücañe numo yüriaburrti Herodes au manu cürrü Judea, anati taman ñoñünrrü sacerdoterrti, nürirrti Zacarías. Arrti anati auqui manu gruporrü sacerdoterrü nürirri Abías. Nüri nicüpostoti Saberarrü. Tone ito auqui nesarrti familiarrü maniqui antiburrü sacerdoterrü Aarón. ");
INSERT INTO caxNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Arrti Zacarías y nicüpostoti bavivicoma isiu nirrancarrti Tuparrü. Icocotama nanaiña arrüba yacüpucurrti Señor. Champü causane nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero arrüma champürrtü aübosioma, itopiqui Saberarrü chüpuerurrüpü aübosi y todaviarrü tüpoma, y sane ito arrti Zacarías tüpomatito. ");
INSERT INTO caxNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Taman nanenese tocabo ümo nesarrti gruporrü Zacarías aserebimia au niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Arrümanuma sacerdoterrü ane yacheatarrüma suerteabo uimia, na atusi ñacuti naqui sürobotü au nicümuinta niporrti Tuparrü aiñonocoti rroriocorrü. Au manu nanenese tocabo ümoti Zacarías. ");
INSERT INTO caxNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Así que iñonocotati rroriocorrü au niporrti Tuparrü. Macrirrtianuca meaboma ümoti Tuparrü türüpo. ");
INSERT INTO caxNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rrepenatatai cuati taman ángel esati auqui napese esaquiti Señor. Atüraiti au nepanauncu altar cauta omo manu rroriocorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Arrti Zacarías chütusiopü ümoti causane uiti, numo asaratitü ümoti. Cütobüsoti y birrubuti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero arrti ángel nanti ümoti: —Tapü airruca Zacarías, itopiqui arrti Tuparrü oncoiti neanca. Nacüposü Saberarrü anati ñana ipiaümacarrü. Aiña üriboti Juan. ");
INSERT INTO caxNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tarucu napucünuncu icuatati, arrtü anati icu cürrü, y sürümanama ito macrirrtianuca pucünuñama icuatati. ");
INSERT INTO caxNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Arrti chichabotipü vinorrü, ni cualquierarrüpü arrüna ocoro. Tiene que atorri üriacaboti uiti Tuparrü, y anatito Espíritu Santo au nausasürrti ante que anati icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Uiti caüma sürümanama bama israelitarrü iñorronconomacü isucarüti Señor naqui Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cusürüboti anati icu na cürrü pünanaquiti Cristo. Tarucu nüriacarrti y anati Espíritu Santo auti tacanati profetarrü Elías tücañe. Urapoiti arrüna niyequirrti Cristo. Icoñocotati nisüboriqui genterrü, tapü tüboricoma ümomantoe. Uitito macoconaunrrüma bama chipiacapü acoconauma. Sane caüma puerurrüma asuriurumati Cristo. ");
INSERT INTO caxNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Auqui arrti Zacarías ñanquitioti pünanaquiti ángel: —Aensapü pasao iñemo arrüna sane. Itopiqui arrüñü tüpomañü, y nisüposü isiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Arrti ángel iñumutati, nanti: —Arrüñü nisüri Gabriel, imostorrti Tuparrüñü. Icüpurutiñü nauqui suraboi asucarücü arrüna urriampae manitacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tapü arrücü chaicocotapü. Sane nauquiche auquina caüma chüpuerurrüpü anitacaiqui, cheperrtü anati icu cürrü maniqui ahü. Arrüna nisura aemo tiene que acoco ñana. ");
INSERT INTO caxNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Arrümanuma macrirrtianuca aboma türüpo barrüperarama ümoi Zacarías. Chütusiopü ümoma causane chücontopü ayeti tato türüpo. ");
INSERT INTO caxNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nauquiche iñataiti tato türüpo, chüpuerurrüpü anitati ümoma. Esucutiatai ümoma. Ui arrüna sane tütusiatai ümoma, ta asaratitü auqui quiatarrü narrtarrti au niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Arrti Zacarías cocono uiti manio naneneca yaserebiquirrti au niporrti Tuparrü. Auqui süroti tato au niporrti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Auqui caüma arrümanu Saberarrü nicüpostoti tanati cütüpü ipiaümacarrü. Ane au niporrü ümo cinco panca, chüsalibopü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ane mapensara sane: “Nupu Tuparrü isamute saübuñü arrüna urriampae. Ui arrüna sane caüma chauqui chupunuñünquipü crirrtianuca, itopiqui tütane nisaü”. ");
INSERT INTO caxNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Numo tabe seirri panca nacarrti ipiaümacarrü icütüpü Saberarrü, arrti Tuparrü bacüpuruti ümoti maniqui ángel Gabriel au manu pueblurrü nürirri Nazaret. Ane au manu cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Sürotitü esa manu taman cupiquirri nürirri Mariarrü. Arrüna rranrrü apo aübuti taman ñoñünrrü nürirrti José, naqui auqui nesarrti familiarrü yüriaburrü David tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Iñataiti ángel esa Mariarrü. Manquioti nurria ümo, nanti: —Arrti Tuparrü anati achepecü y icunusüancanatiyü manrrü mopünanaqui nanaiña paüca icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nauquiche tasaratü Mariarrü ümoti ángel, cütobüso ui na nurarrti ümo. Nantü ümoantoe: “¿Causane anqui iñemo sane?” ");
INSERT INTO caxNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Auqui arrti ángel nanti ümo: —Tapü airruca María, itopiqui arrti Tuparrü urria ñaquioncorrti aemo y acurusüca uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Auquina caüma anati acütüpü apaümaca. Arrtü tanati icu cürrü, aiña üriboti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Arrti caüma ane nüriacarrti uiti Bae Tuparrü. Tonenti Aütorrti. Yüriaburrti ñana uiti Tuparrü tacanati yüriaburrü David tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ane nüriacarrti ümo manuma israelitarrü. Champü nitacüru nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Auqui ñanquitio Mariarrü pünanaquiti ángel: —¿Causanempü apasa iñemo arrüna sane? Arrüñü chipocaiquipü aübu noñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aiñumuti ángel: —Arrti Espíritu Santo cuati aucü y arrüna nicusüurrti Tuparrü cuatito aemo. Sane nauquiche arrti maniqui apaümaca tonenti Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Suraboira ito asucarücü, arrüna napariente Saberarrü tütane seirri panca tanati ipiaümacarrü cütüpü au nipocorrü. Abu namatü tücañe que chüpuerurrüpü aübosi. ");
INSERT INTO caxNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pero ümoti Tuparrü champü isane arrüna cuestarrü, nanaiñantai urriante uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Auqui nantü Mariarrü: —Arrüñü nicumanacata Señor, tari isamunena isiu nirrancarrü saübuñü, isiu arrüna nura. Auqui manu süroti tato ángel. ");
INSERT INTO caxNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Au manio naneneca sürotü Mariarrü apaseane Saberarrü au manu taman pueblurrü ane omeana yirituca au manu cürrü Judea. ");
INSERT INTO caxNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Besüro uirri au niporrti Zacarías. Manquio nurria ümo Saberarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nauquiche manquio ümo, onquisio Saberarrü pocoroti maniqui ipiaümacarrü cütüpü. Abu arrti Espíritu Santo süroti au nausasü Saberarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Au manu rratorrü manitana fuerte, nantü sane: —Nupu Tuparrü icunusüancanü pünanaqui nanaiña paüca, y icunusüancata ito napaümaca. ");
INSERT INTO caxNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Isanempü niyaca nauqui apasearañü, arrücü nipiacü Señor? ");
INSERT INTO caxNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nauquiche tiñoncoi nanquiqui iñemo, arrüna nipiaümaca pocoro sübobiñü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Urriampae naca, itopiqui aicocota nura Señor, arrüna nantü tücañe aemo. ");
INSERT INTO caxNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Auqui nantü Mariarrü: Iñanaunta Nupu Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tarucu nipucünuncu uirri, arrüna uiche ichaesübuca eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Itopiqui Nupu Tuparrü chütacürusupü ñaquioncorrü iyoñü. Arrüñü te nicumanacatarrü y ichaquisürücatai ümo. Auqui na caüma tusio ñome nanaiña crirrtianuca, ta isurusüca uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Itopiqui Nupu Tuparrü chiyaupü ñapanauncurrü. Isamute iñemo arrüna champü tacanache, itopiqui nürirri anaunu. ");
INSERT INTO caxNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pucürusu itacu nanaiña ba opiñanaunta ümo para siemprerrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Arrüna isamute champü tacanache. Omiñarrio uirri arrüba vianuhuca aübu nanaiña ñupapensacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iquiaübuta nobüriaca ba nüriabuca. Bayurara ñome ba pobrerrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Basapara ñome ba bocürüpüo. Tapü rricuca icüpurio aübu niyocürüpürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bayurara ito ñome ba bopohoso au na nación Israel, arrüba paserebio ümo. Chütacürusupü ñaquioncorrü y pucürusu yutacu. ");
INSERT INTO caxNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sane nurarrü ñome ba nurrupu tücañe, ümo Abraham aübu nanaiña nesarrü familiarrü. Rranrrü ayura ñome ümo para siemprerrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Auqui Mariarrü süsio acamanu esa Saberarrü ümo trerrü panca. Auqui süro tato au niporrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tiñatai manu tiemporrü auche ane mecu Saberarrü. Anati icu cürrü. Ñaümati. ");
INSERT INTO caxNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tapü arrübama ipiariente Saberarrü y arrübama iposapatarrü oncoimia arrüna sane. Pucünuñama nurria ichepe, itopiqui arrti Tuparrü pucürusuti itacu. ");
INSERT INTO caxNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tütabe ocho naneneca nacarrti maniqui ñaüma icu cürrü. Süromatü aübuti nauqui circuncidaboti. Rranrrüma caüma nauqui aüro üriboti Zacarías, inrrataboti yaütoti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero nipiacütoti chirranrrüpü nauqui sane nürirrti, nantü sane ümoma: —Süro üribo Juan. ");
INSERT INTO caxNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iñumutama: —Champüti sane nürirrti eana naesa familiarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ñanquitioma pünanaquiti yaütoti aübu señarrü isane rranrrti aüro üriboti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Arrti Zacarías manquioti taman taurama. Torrio ümoti. Aiconomoti icu sane: “Nürirrti Juan”. Namanaiña cütobüsoma uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Au manu rratorrü puerurrü tato anitati Zacarías. Machampiencanati ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ui arrüna sane namanaiña bama iposapatarrti cütobüsoma. Contoatai tütusio arrüna sane pasabo au nanaiñanatai manu cürrü Judea, auna cauta abe yirituca. ");
INSERT INTO caxNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Namanaiña bama oncoimia arrüna sane mapensarama uirri. Ñanquitioma pünanaquimiantoe, namatü: —¿Isanempü rranrrü aisamunutiyü naqui ñaüma? Arrti Señor macunusüancanati nurria ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Auqui cuati Espíritu Santo au nausasürrti Zacarías. Manitanati uiti caüma, nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Uiñanaunati Señor, naqui Tuparrü ümo bama auqui Israel. Cuati oemo nauqui utaesübu uiti eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chauqui tübacüpuruti ümoti naqui ane nüriacarrti, nauqui utaesübu eanaqui nomünantü. Cuati eanaqui nesarrti familiarrü yüriaburrü David, naqui baserebioti ümoti Tuparrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sanen te nanti Tuparrü tücañe uturuqui bama profetarrü. Arrüma samamecanama uiti, nauqui anitama au nürirrti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Urapoimia que rranrrti aitaesümunuti oñü ñünana bama tüboricatai oemo. ");
INSERT INTO caxNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pucürusuti itacu bama antiburrü. Aquionotiyü iyo manu tratorrü masamunuti aübuma. ");
INSERT INTO caxNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tone arrüna nurarrti Tuparrü ümoti Abraham tücañe, nauquiche itusiancatati isucarüti curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nanti, rranrrti aitaesümunuti oñü ñünana bama tüboricatai oemo y ñünana nuirrucu ñünanama, nauqui baserebi ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Rranrrti urria nosüboriqui y samamecana oñü ümoti nauqui urria numapanauncu enterurrü nosüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Arrücü isaü profetarrücü ñana uiti yarusürürrü Tuparrü. Acusürüca uraboi arrüna niyequirrti Señor, nauqui aicoñoco ma nisüboriquirrimia bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Urapoi isucarüma ta chauqui tüpuerurrü aurrimiacana tato nomünantü uimia, y sane urria nacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sane ito nirrantümoti Tuparrü. Ucuasürüca ümoti. Pucürusuti utacu. Arrüna niyequirrti Señor tacanarrtü cuatü nanenese, y arrüna tomiquianene sürotü ñünana. ");
INSERT INTO caxNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Usaca tacana au tomiquianene, itopiqui oconca ñana. Pero uiti Señor caüma cuatü nanentacarrü oemo, itopiqui bacheboti osüboriquibo. ");
INSERT INTO caxNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Arrti maniqui ñaüma sunaunti. Bacheboti Tuparrü manrrü ñapanauncubuti. Sürotitito aviviti eana rroense pururrü canca y cüosorrü. Nacarrti taha cheperrtü sürotitü anunecati ümo bama macrirrtianuca auqui cürrü Israel. ");
INSERT INTO caxNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Au manio naneneca tücañe arrti yarusürürrü yüriaburrü César Augusto rranrrti atusi ümoti, mantucubo bama macrirrtianuca aboma iquiana nüriacarrti. Sane nauquiche bacüpuruti nauqui ane censo. ");
INSERT INTO caxNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Arrümanu primer censo ane numo yüriaburrti Cirenio au manu cürrü Siria. ");
INSERT INTO caxNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Namanaiña süroma tato au nesarrümantoe pueblurrü, nauqui acoroma. ");
INSERT INTO caxNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Arrti José anancati au manu pueblurrü nürirri Nazaret, ane au manu cürrü nürirri Galilea. Sürotitü auqui manu au manu cürrü Judea, au manu pueblurrü nürirri Belén, auna cauta anati icu cürrü David tücañe. Itopiqui arrti José anati auqui nesarrti familiarrü David. ");
INSERT INTO caxNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Süroti tato au Belén nauqui acoroti ichepe Mariarrü. Arrti rranrrti apo aübu. Mariarrü chauqui tanati ipiaümacarrü cütüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nauquiche taboma au manu pueblurrü Belén, iñatai manu nanenese auche ane mecu Mariarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Acamanu anati icu cürrü naqui primer ipiaümacarrü. Cüburriuti uirri. Iñanati au taman babetama, arrüna auquiche auba numuquianca, itopiqui champü porrü tabüco uimia au pueblurrü cauta arücüma. Barücüroma au manu cüpahurrü, niyocora numuquianca. ");
INSERT INTO caxNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Au manu tobirri aboma mañoñünca au manu rroense saimia Belén. Bacuirarama yutacu niyaburrüma nobirraca. ");
INSERT INTO caxNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Rrepenteatai iñataiti taman ángel esaquiti Tuparrü. Cuara nurria itupecuma ui nanantacarrti Tuparrü. Au manu rratorrü tarucapae nirrucurrüma manuma mañoñünca. ");
INSERT INTO caxNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero arrti ángel nanti ümoma: —Tapü aupirruca, itopiqui isecatü suraboi ausucarü arrüna urriampae manitacarrü, arrüna uiche apucünuma macrirrtianuca icu na cürrü: ");
INSERT INTO caxNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","One anati icu cürrü au nesarrti pueblurrü David naqui uiche autaesübuca eanaqui nomünantü. Tonenti Cristo, naqui Señor. ");
INSERT INTO caxNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Suraboira ausucarü arrüna señarrü aume, nauqui atabüti aboi maniqui ñaüma. Anati cüburriuti, y anati barücüboti au taman babetama. ");
INSERT INTO caxNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Au manu rratorrü iñataimia maquiataca angelerrü sürümanama acamanu esati. Macantarama ümoti Tuparrü sane: ");
INSERT INTO caxNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Gloria ümoti Tuparrü naqui anati au napese. Au na icu na cürrü, tari urria nacarrüma bama macrirrtianuca bama urria au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Auqui arrümanuma angelerrü süroma tato au napese. Tapü arrümanuma mañoñünca namatü ümomantoe: —Curi te au Belén, nauqui basarai arrüna pasabo, arrüna urapoiti Señor usucarü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Auqui süromatü au Belén, apuraurrü namenrrüma. Iñataimia taha. Asaramati José y Mariarrü. Y arrti maniqui ñaüma anati barücüboti au babetama. ");
INSERT INTO caxNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nauquiche tasaramati, urapoimia arrüna pasabo ümoma y arrüna nurarrti ángel ümoma icütüpüti maniqui ñaüma. ");
INSERT INTO caxNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Namanaiña cütobüsoma ui nurarrüma ");
INSERT INTO caxNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero Mariarrü iñahübuta au nitusirri nanaiña ba manitacaca. ");
INSERT INTO caxNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Arrümanuma bacuirara yutacu nobirraca basücübücoma tato. Machampiencanama ümoti Tuparrü. Iñanaunumati, itopiqui arrtaimia nanaiña isiu nurarrti ángel ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Numo tütabe ocho naneneca nacarrti icu cürrü maniqui ñaüma, circuncidaboti. Iñatama üriboti Jesús, isiu yacüpucurrti ángel ümo Mariarrü, nauquiche chütochiquioquipü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Numo tücumplibo manio cuarenta naneneca nauquiche turrian tato nurria ümo Mariarrü, tacana yacüpucu nüriacarrü, auqui iquianamati maniqui ñaüma au manu pueblurrü Jerusalén, nauqui aitorrimianamati ümoti Señor. ");
INSERT INTO caxNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Isamutema sane, itopiqui sane nantü manu nüriacarrü: “Arrtü ñaümati naqui primer usaübosi, tiene que uitorrimianati ümoti Señor. Samamecanati caüma ümoti”. ");
INSERT INTO caxNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Süromatü au niporrti Tuparrü, nauqui acumanama ümoti isiu na yacüpucurrti ane corobo sane: “Torrü nututaquimianca o torrü nutaecusimianca”. ");
INSERT INTO caxNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Au manu tiemporrü anati taman ñoñünrrü bavivicoti au Jersalén, nürirrti Simeón. Anati Espíritu Santo au nausasürrti. Bien buenurrti y manaunuti ümoti Tuparrü. Tücoboi yarrüperacarrti ümoti naqui uiche ataesübu genterrü israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Arrti Espíritu Santo turapoiticaü tücañe isucarüti, ta chücoiñotipü mientras chasaratitipü Cristo, naqui cuabotü esaquiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Au manu nanenese arrti manqui ñoñünrrü sürotitü au niporrti Tuparrü uiti Espíritu Santo. Arrti José y Mariarrü iñataimia ito acamanu aübuti Jesús, nauqui aisamunema isiu nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Auqui arrti Simeón süroti esama, aiquiantiti maniqui ñaüma. Iñanaunutiti Tuparrü, nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Iyaü, arrüñü amoso puerurrü ison caüma, itopiqui chauqui tücocono arrümanu nura iñemo, ");
INSERT INTO caxNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","itopiqui chauqui tiyasacati naqui uiche suichaesübu eanaqui nomünantü, ");
INSERT INTO caxNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","naqui cuati ümo namanaiña macrirrtianuca icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tonenti naqui ane nüriacarrti, nauqui anunecatito ümo manu genterrü chütüpü israelitarrü. Y arrübama israelitarrü cuasürüma caüma auqui naca icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Arrti José y Mariarrü cütobüsoma ui na nurarrti Simeón ümoti maniqui ñaüma. ");
INSERT INTO caxNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Auqui arrti Simeón macunusüancanati ümoma, auqui nantito ümo Mariarrü nipiacütoti Jesús: —Sürümanama bama israelitarrü chiyasuriurumatipü ñana naqui ñaüma y sürümanama ito bama yasuriurumati. ");
INSERT INTO caxNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nanaiña arrüna ñapensacarrüma au nausasürrüma tiene que atusi ñana. Tapü aemo Maria, orronene nurria aemo au nausasü tacana arrone oquio ui cüsese. ");
INSERT INTO caxNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Acamanu ananca ito taman paürrü profetarrü, nurirri Nanarrü, nitaquiumucuturrti Fanuel, auqui nesarrti familiarrü Aser. Chauqui tüpoma nurria. Poso tücañe numo cupiquirriqui nurria, pero numo tütabe siete añorrü yaviviquirri aübuti iquiana, coiñoti pünanaqui. ");
INSERT INTO caxNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tütabe ochenta y cuatro añoca nacarrü sane viurarrü. Ane au niporrti Tuparrü naneneca y tobiquia, yaserebiquirri ümoti Señor aübu neancarrü, y ane nauche chübasopü ui ñaquioncorrü iyoti (ayunabo). ");
INSERT INTO caxNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Au manu rratorrü sürotü esama. Machampiencana ümoti Tuparrü. Manitana cütüpüti ñaüma ümo bama barrüperara cümenuti Cristo, naqui uiche ataesübuma eanaqui nomünantü bama auqui Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Arrti José ichepe Mariarrü numo tisamutema nanaiña isiu yacüpucu nüriacarrü, basücübücoma tato au manu cürrü Galilea, au manu nesarrüma pueblurrü Nazaret. ");
INSERT INTO caxNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Arrti maniqui ñaüma sunaunti acamanu. Arrti Bae Tuparrü bacheboti ñapanauncubuti y icunusüancanatiti. ");
INSERT INTO caxNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Arrti José y Mariarrü añoca süromatü au Jerusalén ümo pierrta parrcua. ");
INSERT INTO caxNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Numo tütabe doce añorrü ümoti Jesús, süroma tatito au Jerusalén ümo pierrta aübuti Jesús, tacana arrüna yacheatarrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nauquiche tüpasao manu pierrta, arrti José y Mariarrü süroma tato au niporrüma. Tapü arrti Jesús süsioti au Jerusalén. Pero chütusiopü ümoma, arrtü onconoti, ");
INSERT INTO caxNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ñaquioncorrüma cuati eana manu cütüpürrü genterrü. Nauquiche tütane taman nanenese namenrrüma, yapacheriurumati eana manuma ipiarientetorrüma isiu cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Champürrtü tabücoti uimia. Auquimanu basücübücoma tato au Jerusalén nauqui apacheriurumati. ");
INSERT INTO caxNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pürücü trerrü naneneca tabücoti uimia. Anancati au niporrti Tuparrü. Tümonsoti eana manuma manunecanama nüriacarrü. Onsapecoti nurarrüma, y ñanquitioti pünanaquimia. ");
INSERT INTO caxNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Namanaiña bama oncoimia nurarrti cütobüsoma ui ñapanauncurrti y ui na tusio ümoti, arrtü ane arrüna ñanquitioma pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Arrti José ichepe Mariarrü asaramatü ümoti. Cütobüsoma. Nantü nipiacütoti ümoti: —¿Causane aisamune suiñemo arrüna sane? ¡Naüma y arrüñü au nanaiñantai subacatü supapacheriurü, y tarucu penarrü soboi acü! ");
INSERT INTO caxNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Auqui arrti Jesús nanti ümoma: —¿Causane abasiquia apapacheriuruñü? ¿Taqui chütusiopü aume, arrüñü tiene que yaca au na niporrti Iyaü? ");
INSERT INTO caxNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero arrüma chentienterrüpüma ümo arrüna sane nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Auquimanu süroti tato isiuma au Nazaret. Macoconaunrrti ümoma. Tapü nipiacütoti iñahübuta nanaiña arrüna sane au nitusirri. ");
INSERT INTO caxNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Arrti Jesús sunaunti y manrrü ñapanauncurrti y arrti Tuparrü pucünuñati icuatati y genterrü isiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Au manu tiemporrü tücañe tütabe quince añorrü üriabucati yarusürürrü yüriaburrü Tiberio. Arrti Poncio Pilato yüriaburrti au manu cürrü Judea. Tapüti Herodes yüriaburrti au Galilea. Arrti yaruquitorrti, nürirrti Felipe yüriaburrti au Iturea y au Traconite. Y arrti Lisanias yüriaburrti au Abilinia. ");
INSERT INTO caxNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Arrti Anás y arrti Caifás tonema bama mayarusürüca sacerdoterrü. Au manu tiemporrü arrti Tuparrü manitanati ümoti Juan, aütorrti Zacarías. Bacüpuruti ümoti. Arrti Juan anancati au rroense auna cauta abe pururrü canca y cüosorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Así que sürotitü au nanaiña cüca abeu manu sapoco Jordán. Uraboiti isucarü genterrü nurarrti Tuparrü; nanti sane: —Apiñorroncosaño, nauqui puerurrü abüri sobi. Sane caüma arrti Bae Tuparrü irrimiacatati tato nomünantü aboi. ");
INSERT INTO caxNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Arrüna sane pasabo nauqui acoco arrümanu corobo tücañe uiti profetarrü Isaías. Sane corobo uiti: Rabotü manitacarrü eana rroense, nantü sane: “Apicoñoco nicutubiurrti Señor. Apiyaübu besüro nurria. ");
INSERT INTO caxNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nanaiña arrüba opotüsa, tari umatamacana, y nanaiña yirituca bupauru, nauqui querabo cüsumaña. Arrüna cauta cüono, tari pesünacana. Arrüna cauta chichepepü, tari chepecana nurria nanaiña. ");
INSERT INTO caxNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sane nauqui namanaiña macrirrtianuca icu na cürrü asaramatü ümoti naqui uiche utaesübu eanaqui nomünantü”. Sane corobo uiti Isaías tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nauquiche süromatü macrirrtianuca esati Juan nauqui ürimia uiti, nanti ümoma: —¡Arraño niñupariente noirroboca! ¿Quitipü urapoi ausucarü nauqui puerurrü aupesübu ñünana carrticurrü arrüna cuabotü? ");
INSERT INTO caxNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Arrtü aurrianca aupesübu, apisamuse arrüna urria, na atusi ta apiñorroncocaño ñemanauncurratoe. Tapü abasiquia apapensa que arraño ui na abecatü eanaqui nesarrti familiarrü Abraham champü nümoche apiñorronconaño. Itopiqui arrti Tuparrü puerurrti aisamunenti ipiarienteboti Abraham oboi arrüba canca. ");
INSERT INTO caxNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Arraño ichepecacaño tacana sueca. Chauqui totoro nurria hacharrü nauqui atüsü ba sueca. Arrüba chomirriampü nobütarrü botüsüro. Amontonabohio nauqui abü. ");
INSERT INTO caxNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ñanquitioma pünanaquiti Juan: —¿Causanemo caüma soboi? ");
INSERT INTO caxNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aiñumuti Juan: —Arrti naqui ane torrü niquiamisarrti, tari itorrimiatati taman ümoti naqui champü uiti. Y arrti naqui ane utuburiboti, tari ñacumanati ümoti naqui champü isane ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Cuamatito esati Juan bama mayacobraca impuestorrü, nauqui ürimia. Ñanquitioma pünanaquiti: —¿Maestro, causanempü caüma soboi? ");
INSERT INTO caxNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aiñumuti Juan: —Tapü apacobracapae chama. Apacobüra isiu yacüpucu nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aboma ito masortaboca acamanu. Arrüma ñanquitioma ito pünanaquiti, namatü: —¿Carü arrüsomü, causane soboi? Aiñumuti Juan: —Tapü apacaübucaiqui pünanaqui genterrü arrüna naurriantümo. Tapü apitomocati naqui champü causane uiti. Tari conformabo año aübu napacanasa. ");
INSERT INTO caxNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Arrüna genterrü ane barrüperara cümenuti Cristo. Sane nauquiche namatü ümomantoe: —¿Taqui arrti Juan tonenti Cristo? ");
INSERT INTO caxNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tapü arrti Juan nanti ümo namanaiña: —Arrüñü rraunimiaca ui turrtai. Pero anati naqui cuatiqui isiuñü. Arrti maunimianati aume uiti Espíritu Santo y ui pese, arrtü cuati Espíritu Santo au nabausasü. Arrti ane manrrü nüriacarrti rropünanaquiñü. Arrüñü champü isane niyaca, ni puerurrüpü isoquisünapü nehe nisapaturrti. ");
INSERT INTO caxNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Arrti chauqui tacomoraboti, nauqui asucüti nesarrti trigo. Arrümanu trigo iñatati peese pünanaqui niyarrirri. Arrümanu niyarrirri amontonabo uiti y tiene que acheti pese ümo. Arrümanu pese champü nitacüru noncorrü. Tapü trigo ahüburu uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sane ñacuansomococorrti Juan ümo genterrü. Urapoitito isucarüma arrüna urriampae manitacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Icuansomoconotitito yüriaburrü Herodes, itopiqui anati isiu nicüpostoti yaruquitorrti, nürirrti Felipe, y itopiquito arrüba piquiataca nomünantü isamutenti. ");
INSERT INTO caxNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero arrti Herodes champürrtü icocotati nurarrti Juan. Más bien masamunuti manrrü nomünantü: Iñanatiti Juan au preso. ");
INSERT INTO caxNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nauquiche anancatiqui Juan maunimianati ümo genterrü, arrti Jesús üriotito uiti. Numo meaboti Jesús ümoti Tuparrü, aurübo napese. ");
INSERT INTO caxNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Auqui arrti Espíritu Santo cuati auqui napese onüti Jesús tacana naca nututaquimia. Auquimanu rabotü taman manitacarrü auqui napese, nantü sane: —Arrücü isaücü. Tarucu nacua iñemo. Ipucünuncatai acuatacü. ");
INSERT INTO caxNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Numo tütabe treinta añorrü ümoti Jesús, auqui comenzaboti anunecati. Arrübama macrirrtianuca ñaquioncorrüma aütorrti José, (abu uiti Espíritu Santo). Arrti José aütorrti Elí. ");
INSERT INTO caxNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Arrti Elí aütorrti Matat, arrti Matat aütorrti Leví, arrti Leví aütorrti Melqui, arrti Melqui aütorrti Jana, arrti Jana aütorrti José, ");
INSERT INTO caxNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","arrti José aütorrti Matatías, arrti Matatías aütorrti Amós, arrti Amós aütorrti Nahum, arrti Nahum aütorrti Esli, arrti Esli aütorrti Nagai, arrti Nagai aütorrti Maat, ");
INSERT INTO caxNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","arrti Maat aütorrti Matatías, arrti Matatías aütorrti Semei, arrti Semei aütorrti José, arrti José aütorrti Judá, ");
INSERT INTO caxNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","arrti Judá aütorrti Joana, arrti Joana aütorrti Resa, arrti Resa aütorrti Zorobabel, arrti Zorobabel aütorrti Salatiel, arrti Salatiel aütorrti Neri, ");
INSERT INTO caxNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","arrti Neri aütorrti Melqui, arrti Melqui aütorrti Adi, arrti Adi aütorrti Cosam, arrti Cosam aütorrti Elmodam, arrti Elmodam aütorrti Er, ");
INSERT INTO caxNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","arrti Er aütorrti Josué, arrti Josué aütorrti Eliezer, arrti Eliezer aütorrti Jorim, arrti Jorim aütorrti Matat, ");
INSERT INTO caxNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","arrti Matat aütorrti Leví, arrti Leví aütorrti Simeón, arrti Simeón aütorrti Judá, arrti Judá aütorrti José, arrti José aütorrti Jonán, arrti Jonán aütorrti Eliaquim, ");
INSERT INTO caxNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","arrti Eliaquim aütorrti Malea, arrti Malea aütorrti Mainán, arrti Mainán aütorrti Matata, arrti Matata aütorrti Natán, ");
INSERT INTO caxNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","arrti Natán aütorrti David, arrti David aütorrti Isaí, arrti Isaí aütorrti Obed, arrti Obed aütorrti Booz, arrti Booz aütorrti Salmón, arrti Salmón aütorrti Naasón, ");
INSERT INTO caxNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","arrti Naasón aütorrti Aminadab, arrti Aminadab aütorrti Aram, arrti Aram aütorrti Esrom, arrti Esrom aütorrti Fares, arrti Fares aütorrti Judá, ");
INSERT INTO caxNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","arrti Judá aütorrti Jacobo, arrti Jacobo aütorrti Isaac, arrti Isaac aütorrti Abraham, arrti Abraham aütorrti Taré, arrti Taré aütorrti Nacor, ");
INSERT INTO caxNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","arrti Nacor aütorrti Serug, arrti Serug aütorrti Ragau, arrti Ragau aütorrti Peleg, arrti Peleg aütorrti Heber, arrti Heber aütorrti Sala, ");
INSERT INTO caxNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","arrti Sala aütorrti Cainán, arrti Cainán aütorrti Arfaxad, arrti Arfaxad aütorrti Sem, arrti Sem aütorrti Noé, arrti Noé aütorrti Lamec, ");
INSERT INTO caxNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","arrti Lamec aütorrti Matusalén, arrti Matusalén aütorrti Enoc, arrti Enoc aütorrti Jared, arrti Jared aütorrti Mahalaleel, arrti Mahalaleel aütorrti Cainán, ");
INSERT INTO caxNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","arrti Cainán aütorrti Enós, arrti Enós aütorrti Set, arrti Set aütorrti Adán, arrti Adán urriancati uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Así que tanati Espíritu Santo au nausasürrti Jesús. Süroti tato auqui manu sapoco Jordán. Uiti Espíritu Santo caüma sürotitü au manu rroense cauta abe pururrü canca y cüosorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarenta naneneca nacarrti taha. Acamanu arrti choborese iñatati macocotorrü ümoti. Arrti Jesús chübasotipü enterurrü manio naneneca nacarrti acamanu. Sane nauquiche cürüpüoti. ");
INSERT INTO caxNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Auqui arrti choborese nanti ümoti: —Arrtü arrücü ñemanauncurratoe Aütorrti Tuparrü, aisamusio pan arrüba canca. ");
INSERT INTO caxNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aiñumuti Jesús: —Nantü icu Nicororrü sane: No solamenterrü ui pan osüboriquia. Arrtü uicocota nurarrti Tuparrü, uirri ito osüboriquia. ");
INSERT INTO caxNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Auqui arrti choborese iquianatiti Jesús onü taman yiriturrü petaisürü. Au manu rratorrü itusiancatati isucarüti nanaiña cüca y nacioneca abe icu na cürrü aübu nanaiña niñocoñoporrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nanti ümoti: —Itorrimiata aemo nanaiña arrüna ane icu na cürrü, arrtü achesoiquia yesañü y anaunca iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Itopiqui nanaiña arrüba arrtai tonehio niyesa, y puerurrü itorrimianio ümoti naqui irranca itorrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Auqui nanti Jesús ümoti: —Icu Nicororrü nantü sane: “Anaun y asarebi ümotiatai Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Auqui arrti choborese iquianatiti Jesús au manu pueblurrü Jerusalén onü manu yapetairratoe niporrti Tuparrü. Nanti ümoti: —Arrtü ñemanauncurratoe Aütorrtiapae Bae Tuparrü, aiñemecasü auqui na ape acü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Itopiqui sane nantü icu Nicororrü: Arrti Bae Tuparrü bacüpuruti ümo bama nesarrti angelerrü, nauqui acuirama atacucü, nauqui masamuña aiñanai acü uimia, ");
INSERT INTO caxNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","tapü obürio ümo napope oboi canca. ");
INSERT INTO caxNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Auqui iñumutati Jesús, nanti: —Pero nantito icu Nicororrü sane: “Tapü aiñata macocotorrü ümoti Tuparrü, naqui Señor”. ");
INSERT INTO caxNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Auqui sürotitü baeta choborese esaquiti Jesús, itopiqui champü manrrü niquiubuti, naqui aiñanti macocotorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Auqui arrti Jesús süroti tato au manu cürrü Galilea aübu tarucu nüriacarrti uiti Espíritu Santo. Ipiatema nürirrti au nanaiña Galilea. ");
INSERT INTO caxNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sürotitü au nanaiñantai anunecati. Manunecanati au poca sinagoga auna cauta nantarrü meaboma. Namanaiña ane ñanauncurrüma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Auqui iñataiti tato au manu pueblurrü Nazaret, auna cauta sunaunti tücañe. Sürotitü au porrü sinagoga au nanenese nesa macansacarrü, tacana arrüna yacheatarrti. Acamanu atüraiti nauqui leheboti icuqui Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Itorrimiatama ümoti arrüna corobo uiti profetarrü Isaías. Iyaübutati. Tabüco uiti arrüna nantü sane: ");
INSERT INTO caxNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Arrti Espíritu Santo anati au niyausasü uiti Señor. Itacümanauncunutiñü nauqui suraboi arrüna urriampae manitacarrü ümo bama pobrerrü. Icüpurutiñü ito ümo bama taquisürü, sane nauqui urriancama tato sobi. Suraboito ümo bama preso, nauqui puerurrü ataesübuma. Arrübama supuso sobi caüma asarama tato. Urria caüma sobi nacarrüma bama taquisürü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Surapoito que arrti Señor macunusüancanati oemo arrüba naneneca. Tone arrüna leheboti Jesús isucarüma. ");
INSERT INTO caxNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Auqui iñamatati tato manu librurrü, itorrimiatati tato ümoti maniqui ayuranterrü au manu sinagoga. Atümoti. Tapü arrübama aboma acamanu arrtayomatü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Auqui caüma manitanati ümoma, nanti sane: —Arrüna nanenese chauqui tücocono ausucarü arrüna Nicororrü aübo leheboñü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Namanaiña macrirrtianuca acamanu urria ñanitacarrüma ümoti Jesús. Cütobüsoma ui na coñorrtai ñanitacarrti. Auqui caüma mapensarama y namatü ümomantoe: —Canapaemo aütorrti José naqui. ");
INSERT INTO caxNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nanti Jesús ümoma: —Arraño amucanaño caüma iñemo arrüna sane manitacarrü: “Arrti merecurrü, tari yacurarati ümotiatoe”. Amucanaño ito iñemo sane: “Arrücü te auquina suyarrüpecuqui; asamu ito arrüba milagrorrü auna propiorrü nacü, tacana arrüna somoncoi que asamuca au Capernaum”. ");
INSERT INTO caxNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Suraboira ausucarü ñemanauncurratoe, arrübama macrirrtianuca au taman pueblurrü chüpuerurrüpü asuriurumati nurria naqui profetarrü auquina propiorrü nicürrti. ");
INSERT INTO caxNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tusio nurria aume, au manu nitiemporrti profetarrü Elías tücañe abe sürümana biuraca au na cürrü Israel, nauquiche chürrobeocapü ñome manio trerrü añoca y merio. Sane nauquiche tarucapae carerrtiya au nanaiña cürrü Israel. ");
INSERT INTO caxNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero arrti Tuparrü champürrtü icüpurutiti Elías nauqui ayurati ñome manio biuraca abe au na cürrü Israel, ta icüpurutiti na ayurati ümo manu taman viurarrü au Sarepta au manu quiatarrü cürrü, taha saimia manu pueblurrü nürirri Sidón. ");
INSERT INTO caxNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aboma ito au na cürrü Israel sürümanama bama maunrrocono, poreatai nañeturrüma ui manu norrocorrü nürirri lepra, numo süboricotiqui profetarrü Eliseo. Pero champürrtü bacurarati Eliseo ümoma, pero si bacurarati ümoti maniqui ñoñünrrü nürirrti Naamán auqui manu quiatarrü cürrü nürirri Siria. ");
INSERT INTO caxNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ui arrüna sane nurarrti Jesús tüboricoma ümoti bama aboma au manu porrü sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Atüraimia, ipenenomati Jesús türüpo. Arrümanu nesarrüma pueblurrü ane onü taman yiriturrü aübu taman nisacürrü. Acamanu iquianamati, nauqui aipenenomati auqui manu nisacürrü petaisürü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero arrti Jesús pebücoti tato, pasaotiatai eanaquimia. Champü causane uimia ümoti. Sürotitü auqui manu. ");
INSERT INTO caxNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sürotitü au manu pueblurrü nürirri Capernaum au manu cürrü Galilea. Acamanu manunecanati ümo genterrü au nanenese nesa macansacarrü au porrü sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Cütobüsoma ui ñanunecacarrti, itopiqui manitanati aübu nüriacarrti uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Au manu sinagoga anancati taman ñoñünrrü naqui anati choborese auti. Tosibicoti nurria, nanti: ");
INSERT INTO caxNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Causane asiquia suisuata, arrücü Jesús auqui Nazaret? ¿Ayecatü nauqui aitabairo somü? Isuputacü; tusio iñemo ta arrücü Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Auqui arrti Jesús icuansomoconotiti maniqui choborese, nanti ümoti: —¡Etaiquei, acosi auquiti naqui ñoñünrrü! Auqui arrti maniqui ñoñünrrü taübücoti acü acamanu isucarüma uiti choborese. Auqui sürotitü auquiti. Champü causane uiti ümoti maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Namanaiña cütobüsoma, namatü ümomantoe: —¿Causanempü arrüna sane manitacarrü? Arrti naqui ñoñünrrü Jesús ane nüriacarrti y nicusüurrti. Bacüpuruti ümo bama machoboreca, y arrüma icocotama nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Unrratorrtai ipiatema nürirrti Jesús au nanaiñantai manu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Auqui arrti Jesús sürotitü auqui manu sinagoga au niporrti Simón. Aiñanainti taha. Nipiacürrtoti Simón ananca maunrrocono, fuerte nurria nipiacütaiquirri. Manquioma pünanaquiti Jesús, nauqui ayurati ümo. ");
INSERT INTO caxNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aürotitü esa. Manitanati ümo manu norrocorrü, nauqui aürotü pünanaqui. Au manu rratorrü urrian tato ümo. Atürayo, y mapemana ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tüsüro cütu surrü. Arrübama macrirrtianuca macanama esati Jesús bama maunrrocono, aruqui nanaiña norrocorrü ümoma. Arrti iñatati neherrti itama, y sane urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eana manuma maunrrocono aboma bama anati choborese auma. Süromatü machoboreca auquimia ui yacüpucurrti Jesús. Tosibicoma y namatü: —¡Arrücü Aütorrti Tuparrü! Pero arrti Jesús macuansomoconoti ümoma, sane nauquiche chüpuerurrüpüma anitama uiti, itopiqui tusio ümoma que arrti te tonenti Cristo. ");
INSERT INTO caxNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Quiatarrü nanenese nauquiche tüsai anene, arrti Jesús sürotitü auqui pueblurrü. Sürotitü au na cauta champü genterrü. Pero arrübama pohoso auqui pueblurrü yapacheriurumati. Iñataimia isiuti. Rranrrüma nauqui asioti esama, tapü sürotitü auquimanu. ");
INSERT INTO caxNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tapü arrti Jesús nanti ümoma: —Tiene que suraboi arrüna nüriacarrti Tuparrü au piquiataca puebluca, ta ümo icüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sane namenrrti Jesús au manu cürrü Galilea, ñanunecacarrti au ba poca sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Taman nanenese anancati Jesús abeu manu narubaitu turrü, nürirri Genesaret. Iñatai sürümana genterrü esati, hasta que simianati uimia ui nirrancarrüma oncoimia nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Auqui arrti Jesús asaratitü abeu manu narubaitu turrü amonquio torrü barcoca. Arrümanuma esache batrabacara nauqui acaübuma nopiocorrü. Tone niyachücoimia. Chauqui tüsüromatü ubauqui barcoca, nauqui aiyarrübimia nimomerrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Auqui arrti Jesús süroti au manu taman barco, nesarrti Simón. Ñanquitioti pünanaquiti nauqui aiquichoniancati pario manu barco pünanaqui nabeurrü. Auqui tümonsoti Jesús au barco, y auquimanu isuqui turrü manunecanati ümo bama sürümana genterrü, aboma abeu. ");
INSERT INTO caxNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nauquiche tüchauqui ñanunecacarrti, nanti ümoti Simón: —Curi taha cümuinta na turrü, auna cauta otüüsa, nauqui apacaübu nopiocorrü, arrücü aübu bama acumpañero. ");
INSERT INTO caxNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aiñumuti Simón: —Maestro, enterurrü tobirri sopiñata suimome eana turrü, pero champü isane iyebo soboi. Pero como acüpuca, yecatü iña nimome. ");
INSERT INTO caxNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Isamutema sane. Auqui bacaüburuma sürümana nopiococa; tüsaipü aquiopü nimomerrüma ñoquiana. ");
INSERT INTO caxNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Auqui masamunuma señarrü ümo manuma maquiataca icumpañeruturrüma, arrübama aboma au quiatarrü barco, nauqui ayematü ayurama ümoma. Auqui süromatü ayurama. Ubataso uimia manio torrü barcoca ui nopiococa, tüsaipü abubaca ñoquiana. ");
INSERT INTO caxNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Numo arrtaiti Simón Pedro arrüna sane, bachesoiyoti esati Jesús, nanti ümoti: —Acosi auquina yesaquiñü, Señor, itopiqui arrüñü ñoñünrrüñü tarucu nomünantü sobi. ");
INSERT INTO caxNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Itopiqui arrti Simón y arrübama icumpañeruturrti cütobüsoma nurria y birrubuma ui arrüna yacaübucurrüma nopiocorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Arrümanuma aütorrti Zebedeo, arrti Jacobo y arri Juan cütobüsoma ito. Tonema bama icumpañeruturrti Simón. Pero arrti Jesús nanti ümoti Simón: —Tapü airruca, auquina caüma iñununecanü acaübu genterrü eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Auquimanu süroma tato abeu turrü yupu manio barco. Aitononioma eana cüosorrü. Auqui iñocotama nanaiña y süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anancati Jesús au taman pueblurrü. Auqui iñataiti taman ñoñünrrü esati, naqui maunrrocono ui lepra. (Poreo nañeturrti.) Numo asaratitü ümoti Jesús aürotitü esati, achesoiti. Manquioti pünanaquiti aübu nanaiña nausasürrti, nanti ümoti: —Señor, arrtü arrianca, puerurrü acuraca iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Auqui arrti Jesús iñenotiti, nanti ümoti: —Abu irranca, chauqui turriancü tato sobi. Nauquiche tünanti sane, arrümanu norrocorrü sürotü pünanaquiti. Urriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nantito Jesús ümoti: —Tapü urapoi arrüna sane isucarüti quiatarrü. Acosi auquina besüro obi esati sacerdoterrü, nauqui atusi ümoti ta chauqui turriancü tato, itopiqui sane yacüpucurrti Moisés tücañe. Auqui caüma acumana ito ümoti Tuparrü itobo na chauqui turrian tato aemo. ");
INSERT INTO caxNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ipiatema nürirrti Jesús au nanaiñantai. Sane nauquiche iyoberabaramacü sürümanama macrirrtianuca esati, nauqui onsaperioma nurarrti, y nauqui urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tapü arrti Jesús sürotitü auna cauta champü genterrü nauqui eanti. ");
INSERT INTO caxNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Taman nanenese arrti Jesús anancati manunecanati au taman porrü. Aboma bama fariseorrü tümonsoma acamanu ichepe bama manunecana nüriacarrü. Aübo aiñanaimia auqui nanaiñantai Galilea y auqui Judea y auquito Jerusalén. Arrti Jesús anati bacurarati ümo bama maunrrocono ui nicusüurrti, arrüna torrio ümoti uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Auqui iñataimia ito manuma mañoñünca aübuti taman chüpuerurrüpü atüraiti, anati icu nicürurrti. Rranrrümampü aüromatüpo aübuti, nauqui aiñanamati esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero chütabücopü uimia auquiche aüromatüpo, itopiqui cütüpürrü macrirrtianuca. Sane nauquiche bapacheroma niquiubuma. Süromatü chacu porrü. Iponsünatama. Auqui manu nusuturrü iñanamati acü maniqui maunrrocono icu nicürurrti eana manu genterrü esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Arrti Jesús tütusio ümoti que arrüma icocoromati. Nanti ümoti maniqui maunrrocono: —Yobo, arrüba nomünantü obi chauqui tümorrimiacana tato sobi. ");
INSERT INTO caxNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tapü arrübama fariseorrü y arrübama manunecana nüriacarrü mapensarama au nitusirrimia ui na nurarrti sane. Namatü ümomantoe: —¿Ñacutipü naqui ñoñünrrü? Ane nipünatenti aübuti Tuparrü ui arrüna sane nurarrti. Champüti puerurrü airrimiacati tato nomünantü. Arrtiatai Bae Tuparrü naqui puerurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero arrti Jesús tütusiatai ümoti arrüna ñepensacarrüma, nanti ümoma: —¿Causane apapensa arrüna sane? ");
INSERT INTO caxNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Arrüñü Ñemanauncurratoe Ñoñünrrü ane nisüriaca auna icu na cürrü nauqui aurrimiaca tato sobi nomünantü. Pero rrepente amucanaño iñemo que rranitacatai. ");
INSERT INTO caxNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sane nauquiche caüma itusiancana ausucarü arrüna nisüriaca: rracurara ümoti naqui ñoñünrrü. Auqui nanti ümoti maniqui ñoñünrrü chüpuerurrüpü amenti: —¡Atüsai, aiquia nacüru, acui tato au napo! ");
INSERT INTO caxNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Auquimanu atüraiti maniqui ñoñünrrü icuqui nicürurrti isucarüma. Iquiatati manu nicürurrti. Süroti tato au niporrti, ñanauncurrti ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Namanaiña cütobüsoma iñanaunumati Tuparrü y namatü aübu nirrucurrüma: —Champü tumarrtai tacana arrüna sane one. ");
INSERT INTO caxNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sürotitü Jesús auquimanu. Auqui asaratitü ümoti taman yacobrarrü impuestorrü, nürirrti Leví. Anati tümonsoti auna cauta nantarrü bapacarama. Nanti Jesús ümoti: —Ariacu isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Auquimanu arrti Leví atüraiti. Iñocotati nanaiña. Sürotitü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Auqui arrti Leví masamunuti pierrta au niporrti aübuti Jesús. Aboma ito bama icumpañeruturrti tücañe, mayacobraca ichepeti, y bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tapü arrübama fariseorrü y arrübama manunecana nüriacarrü ünantü ümoma. Namatü ümo bama ñanunecasarrti Jesús: —¿Causane abasiquia auba ichepe bama mayacobraca impuestorrü y ichepe bama ane nomünantü uimia? ");
INSERT INTO caxNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Arrti Jesús oncoiti nurarrüma, nanti ümoma: —Champü nümocheti mercurrü ümo bama urria ümoma, ta ümo bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ta arrüñü isecatü ümo bama ane nomünantü uimia, nauqui aiñorronconomacü. Champürrtü isecatü ümo bama urriantai nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ñanquitioma ito pünanaquiti Jesús: —Arrübama ñanunecasarrti Juan nantarrü ayunaboma, chübasopüma ui ñanauncurrüma ümoti Tuparrü, aübu tarucu neancarrüma; y arrübama ito ñanunecasarrüma bama fariseorrü isamutema isiatai. Pero arrübama nanunecasa nantarrtai basoma y chaboma. ");
INSERT INTO caxNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aiñumuti Jesús nurarrüma ui machepecatarrü: —Arrüñü ichepecacañü tacanati taman tübübüho. Arrübama tasuru ümo tübübürrü chüpuerurrüpü ayunaboma, arrtü anatiqui naqui itübübüche acamanu ichepema. ");
INSERT INTO caxNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero cuatiqui manu nanenese auche carübuti maniqui tübübüche pünanaquimia. Auqui caüma ayunaboma. ");
INSERT INTO caxNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Urapoitito arrüna quiatarrü machepecatarrü isucarüma: —Champüti naqui matüsünana taman camisarrü nuevurrü, nauqui arrüparriancati uirri nirrürüpütürrti. Arrtü isamutenti sane, ensoratai niquiamisarrti nuevurrü. Y chücoñopütü ümo manu rrürüpütürrü nauqui arruparrianca uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chuñahübutapü vinorrü iyebo au nitaqui numuquianca namoncoca, na oco, itopiqui arrtü uiñata, bopobo taquiquia uirri, y vinorrü osüro acü. ");
INSERT INTO caxNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tiene que uiñahübu vinorrü iyebo au taquiquia iyebo. Sane chensoropü vinorrü, ni taquiquiapito. (Au manu tiemporrü ahüburu uimia niyü uva au nitaqui numuquianca, nauqui oco, iyo vinorrü.) ");
INSERT INTO caxNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Arrübama ipiacama achama vinorrü arrüna tücoboi nahübucu, bien urria ümoma. Chirranrrüpüma achama arrüna vinorrü iyebo. ");
INSERT INTO caxNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Taman nanenese nesa macansacarrü arrti Jesús amencoti auqui manio ñanaunca auna cauta ane trigo. Arrübama ñanunecasarrti matanama chimiantai nüta trigo, baurrtaquioma y basoma. ");
INSERT INTO caxNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Auqui arrübama fariseorrü namatü ümoma: —¿Causane apisamune arrüna sane? Churriampü batrabaca au na nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Arrti Jesús iñumutati nurarrrüma: —¿Taqui chülehebopü año icu Nicororrü arrüna isamutenti yüriaburrü David tücañe, numo cürüpüoti ichepe bama icumpañeruturrti? ");
INSERT INTO caxNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ta sürotipo au niporrti Tuparrü aübuma. Besüro uiti ümo manio pan mosamamecana. Iyariotiño, y bachebotito ümo bama icumpañeruturrti. Abu champüti naqui puerurrü arioma, cunauntaiñamantai bama sacerdoterrü. (Abu champü nipünatenti David uirri.) ");
INSERT INTO caxNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Arrüñü Ñemanauncurratoe Ñoñünrrü ane nisüriaca ümo na nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Quiatarrü nanenese nesa macansacarrü arrti Jesús sürotitü au manu taman porrü sinagoga nauqui anunecati. Acamanu anancati taman ñoñünrrü süübo nepanauncu neherrti. ");
INSERT INTO caxNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tapü arrübama fariseorrü y arrübama manunecana nüriacarrü barrüpiarama ümoti Jesús, nauqui asaraimia, arrtü bacurarati au na nanenese nesa macansacarrü. Bapacheroma niquiubuma nauqui urabomati. ");
INSERT INTO caxNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero arrti Jesús tütusiatai ümoti arrüna ñapensacarrüma. Nanti ümoti maniqui ñoñünrrü süübo neherrti: —Atüsai, ariacu tauna cümuinta. Atüraiti maniqui ñoñünrrü. Aürotitü taha cümuinta. ");
INSERT INTO caxNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Auqui arrti Jesús ñanquitioti pünanaqui manuma maquiataca: —¿Ñacusane arrüna urria uisamune au na nanenese nesa macansacarrü, arrüna urria o arrüna churriampü? ¿Taqui urria bacuira itacu nisüboriquirrti osüborisapa, o aensapü urria uitabairoti? ");
INSERT INTO caxNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Asaratitü Jesús ümo namanaiña bama aboma acamanu. Auqui nanti ümoti maniqui ñoñünrrü: —Aipesünaca nehe. Arrti maniqui ñoñünrrü isamutenti sane. Auqui urriante tato manu neherrti. ");
INSERT INTO caxNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tapü arrübama maquiataca tüboricoma nurria. Ñanquitioma pünanaquimiantoe arrüna niquiubuma nauqui aisamunema arrüna churriampü aübuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Au manio naneneca arrti Jesús sürotitü onü manu yiriturrü nauqui eanti. Enterurrü tobirri neancarrti ümoti Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nauquiche tütaneneca, batasuruti ümo bama ñanunecasarrti. Matacümanauncunuti ümo bama doce eanaquimia. Süro ito uiti üriboma “apostolerrü”. Arrüna nürirriama nantü auqui besüro “Bama yacüpusurrti Jesús”. ");
INSERT INTO caxNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tonehio nürirrimia: Arrti Simón naqui süro ito üriboti Pedro, arrti Andrés yaruquitorrti Simón, arrti Jacobo, arrti Juan, arrti Felipe, arrti Bartolomé, ");
INSERT INTO caxNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","arrti Mateo, arrti Tomás, arrti Jacobo naqui aütorrti Alfeo, arrti Simón naqui auqui manu partdorrü cananista, ");
INSERT INTO caxNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","arrti Judas aütorrti Jacobo y arrti Judas Iscariote, naqui ipiaventecanatiti Jesús ümo bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cuati tato Jesús onüqui manu yiriturrü aübu bama ñanunecasarrti. Sürotitü taha auna cauta champü yirituca Iñataimia esati sürümanama bama maquiataca ñanunecasarrti y sürümanama macrirrtianuica auqui nanaiñantai, auqui cürrü Judea, auqui Jerusalén, y auqui manio puebluca nobürirri Tiro y Sidón abe abeu narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rranrrüma onsaperioma nurarrti, y arrübama maunrrocono rranrrüma nauqui urrianama tato uiti. Namanaiña bama anati choborese auma urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Arrübama maunrrocono rranrrüma aiñenomati Jesús, itopiqui namanaiña urriancama tato ui nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Auqui arrti Jesús asaratitü ümo bama ñanunecasarrti, nanti: —Urriampae nacarrüma bama pobrerrü, itopiqui iyebo uimia ñana auna cauta üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‛Urriampae ito nacarrüma bama cürüpüoma caüma, itopiqui ñana abecoma. ‛Urriampae ito nacarrüma bama suchebo y areoro, itopiqui ñana biyaboma tato ui nipucünuncurrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‛Urriampae ito nabaca arrtü unuma año bama macrirrtianuca auqui niyaca y arrtü ipenenoma año arrüpecuquimia, o arrtü uratoquioma aume, o churriampü ümoma arrtü oncoimia nabüri. Urriampae nabaca, arrtü isamutema arrüna sane aume auqui niyaca, arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","‛Aupucünu nurria, itopiqui iñatai manu nanenese auche rracumanaca aume au napese itobo na nautaquisürücü. Sane ito isamutema bama antiburrü aübu bama profetarrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‛Tapü arraño bama rricurrü, urriampae naba caüma, pero ñana autaquisürüca. ");
INSERT INTO caxNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‛Autaquisürücatai bama champü faltabo aume y ababecatai, itopiqui ñana aucürüpüca. ‛Autaquisürücatai ito bama pucünuña caüma, itopiqui ñana ausucheca y abareoca. ");
INSERT INTO caxNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‛Autaquisürücatai arrtü manaunuma aume bama macrirrtianuca, itopiqui sane ito ui bama antiburrü ümo bama mañapanca profetarrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‛Arraño amoncoi nisura, sucanañü aume sane: Tari cuasürüti aume aubesa enemigorrü. Tari urria napachücoi ümo bama tüboricatai aucuata. ");
INSERT INTO caxNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tari apicunusüancasa bama ipiaurramanaño. Apean ito itacu bama unuma año. ");
INSERT INTO caxNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Arrti naqui iñompebairoti año, apichüsotito narucüqui nausu. Arrtü anati naqui rranrrti aiquiaübuti naucüburri, tari apichüsotito naucamisa. ");
INSERT INTO caxNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Apacumana ito ümoti naqui manquioti amopünanaqui. Arrti naqui iquiaübutati amopünanaqui, tapü apanquitio tato. ");
INSERT INTO caxNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Apisamuse ümo bama maquiataca arrüna urria aumeantoe. ");
INSERT INTO caxNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‛Arrtü cuasürütiatai aume naqui urria uiti aume, pero bama maquiataca champü, champü naucua uiti Tuparrü itobo, itopiqui arrübama churriampü nisüboriquirrimia isamutema ito sane. ");
INSERT INTO caxNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Arrtü apasamuca nomirria ümo bama masamunuma urria ito aume, champü naucua uiti Tuparrü itobo, itopiqui arrübama churriampü nisüboriquirrimia isamutema ito sane. ");
INSERT INTO caxNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Arrtü apaprerrtaca ümo bamantai puerurrü apacama tato aume, champü naucua uiti Tuparrü itobo, itopiqui sane isamutema ito bama ane nomünantü uimia. Baprerrtarama ümo bama nesarrüma amigorrü, itopiqui bapacarama tato itobo. ");
INSERT INTO caxNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero arraño tiene que acuasürüma aume bama aubesa enemigorrü. Apasamu arrüna urria ümoma. Y arrtü apaprerrtaca ümoma, tapü abasiquia aparrüpera arrtü bapacarama tato itobo. Sane caüma yarusürürrü naucua uiti Tuparrü, y tusio ito, ta arraño tacana aütorrti yarusürürrü Tuparrü. Sane nauquiche, apasamu urria ümo bama malorrü, itopiqui arrti Tuparrü buenurrtito aübu bama chipiacapüma achampiencama y aübu bama malorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tari aupucüru itacu bama maquiataca, tacanatito Uyaü naqui anati au napese, pucürusuti autacu. ");
INSERT INTO caxNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‛Tapü aipiaurramacati quiatarrü, y arrti Tuparrü chipiaurramanatipü añoito. Tapü apuncati quiatarrü; auqui caüma chücarrticabopü año uiti Tuparrü. Apirrimiaca nomünantü uiti quiatarrü, sane caüma arrti Tuparrü irrimiacatatito arrüna nomünantü aboi. ");
INSERT INTO caxNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Apacumana ümoti quiatarrü, auqui caüma arrti Tuparrü macumananati tato aume. Tantorrü ñacumanacarrti aume, arrüna chüpuerurrüpü apasutio nanaiña. Arrti macumananati aume isiu nartabaiqui arrüna napacumanaca ümoti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Auqui arrti Jesús urapoitito isucarüma arrüna machepecatarrü apü bama manunecana: —Arrti supuso chüpuerurrüpü acusürüti aübuti quiatarrü naqui supuso. Rrepente chépema paquioma au cütubirri bama torrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Champüti naqui ununecana puerurrü aiñununecanatiti nesarrti maestro. Ta tiene que estudiaboti nauqui aye uiti tacanati nesarrti maestro. ");
INSERT INTO caxNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‛¿Causanempü ane nümoche obi arrüna nomünantü pario uiti aruqui, tapü arrüna tarucu nomünantü obi champü nümoche obi? ");
INSERT INTO caxNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Causane arrian anuneca ümoti quiatarrü naqui champüapae nomünantü uiti, tapü arrücü tarucu nomünantü obi? ¡Ñapanrrücü! Primero tiene que aicoñoco nasüboriqui aübuti Tuparrü, arrtü arrianca aiñununecanati aruqui. ");
INSERT INTO caxNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‛Arrüba sueca omirria pachebo nobütarrü omirria ito. Arrüba sueca chomirriampü pachebo nobütarrü chomirriampito. ");
INSERT INTO caxNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chümacacapü higo cütüpüqui nihi cümüchürürrü, ni macampü uva cütüpüqui parirri. ");
INSERT INTO caxNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sane ito arrti ñoñünrrü buenurrü manitanati arrüba omirria, itopiqui arrüna urria ane au nausasürrti. Tapüti naqui ñoñünrrü churriampü nisüboriquirrti manitanati arrüba omünantatai, itopiqui arrüba nomünantü abe au nausasürrti. Arrüna ane au nuyausasü, tone arrüna manitate. ");
INSERT INTO caxNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‛¿Causane amucanaño iñemo Señor, Señor, pero chapisamutempü nirracüpucu aume? ");
INSERT INTO caxNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Arrti naqui cuati yesañü y oncoiti nisura, y isamutenti isiu, ");
INSERT INTO caxNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ichepecacati tacanati taman ñoñünrrü masamunuti ipoboti. Primero bapauruti cürrü bien otüüsa. Iñatati nitümo porrü onü canrrü. Numo tüchauqui manu niporrti, rrobeoca, ataso sapoco uirri. Uüno. Iñatai turrü itupecu manu porrü fuerte nurria, pero chüpocoropü uirri, itopiqui ane nitümorrü onü canrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tapü arrti naqui oncoiti nisura y chisamutentipü isiu, ichepecacati tacanati taman ñoñünrrü masamunutito ipoboti pero eana cüosorrü, champü nitümorrü. Numo iñatai nitiempo tanaunrrü ubataso nusüruca y umuüno. Iñatai fuerte itupecu manu porrü. Taübüco y iñarrio nurria. Ensoratai. ");
INSERT INTO caxNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nauquiche tüchauqui ñanitacarrti Jesús ümo genterrü, sürotitü au Capernaum. ");
INSERT INTO caxNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Acamanu anancati taman capitán rromanorrü. Anati taman imostorrti, naqui tarucapae nicuarrti ümoti. Maunrroconoti maniqui mosorrü, tüsaiyapae aconti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nauquiche oncoiti nürirrti Jesús maniqui capitán, bacüpuruti ümo bama üriatu israelitarrü nauqui aeromatü esati Jesús, anquimia pünanaquiti nauqui ariorrti acurati ümoti maniqui mosorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Arrüma caüma süromatü esati Jesús. Aiñanaimia esati. Manquioma pünanaquiti, namatü. —Asamu nurria ümoti maniqui capitán, nauqui aicurarati maniqui imostorrti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Itopiqui arrüna noesa genterrü cuasürü ümoti maniqui capitán. Uitito urriane arrüna porrü sinagoga au na sobesa pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Auqui arrti Jesús sürotitü isiuma. Pero nauquiche tütaboma saimia niporrti capitán, arrti capitán bacüpuruti ümo bama nesarrti amigorrü, nauqui uraboimia isucarüti Jesús arrüna sane: —Nanti capitán sane: Señor, arrüñü champü isane niyaca nauqui aerotü au nipo. ");
INSERT INTO caxNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sane nauquiche champürrtü yaca tanu aesacü. Pero tusio iñemo que ui tamantai nacüpucu urriancati tato naqui imoso. ");
INSERT INTO caxNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Itopiqui bacüpuruma ito iñemo bama isüriatu, y tacane aboma ito bama ümoche rracüpu. Arrtü sucanañü ümoti taman: “Acosi”, sürotitü. Y arrtü itasucati quiatarrü, cuati, y arrtü sucanañü ümoti imoso: “Aisamuse arrüna sane”, isamutenti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Arrti Jesús cütobüsoti ui arrüna sane nurarrti maniqui capitán. Asaratitü ümo genterrü arrüna ananca isiuti, nanti ümoma: —Ñemanauncurratoe, champü tiñoncoi eana bama israelitarrü tacana arrüna sane macoconauncurrü iñemo tacana arrüna oncotitü iñemo naqui ñoñünrrü rromanorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Basücübücoma tato manuma nesarrti amigorrü capitán. Iñataimia tato au niporrti. Asaramati maniqui mosorrü chauqui turriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tomenotü naneneca. Auqui arrti Jesús sürotitü au manu pueblurrü nürirri Naín. Süromatü isiuti bama ñanunecasarrti y arrüna cütüpürrü genterrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nauquiche tiñataiti saimia manu pueblurrü, asaratitü cümenu manuma mañoñünca cuamatü auqui pueblurrü aübuti taman coiño, nauqui aiñanamati cütu. Arrti maniqui coiño cunauntaiñatiatai aürrü manu paürrü biurarrü. Sürümana genterrü auqui pueblurrü süromatü isiuti maniqui coiño. ");
INSERT INTO caxNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nauquiche asaratitü Señor ümo nipiacütoti, taquisürü ümoti. Nanti ümo: —Tapü areoca. ");
INSERT INTO caxNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Auqui aürotitü esa manu cürurrü, aiñenti. Tapü manuma iquiatama tochencoma aübu. Auqui nanti Jesús ümoti maniqui coiño: —Sucanañü aemo yaürrü: ¡Atüsai! ");
INSERT INTO caxNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Auqui arrti maniqui coiño tümonsoti y manitanati. Arrti Jesús itorrimianatiti tato ümo nipiacütoti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ui arrüna sane arrtaimia, tarucu nirrucurrüma bama macrirrtianuca. Iñanaunumati Tuparrü, namatü: —Anati taman profetarrü auna uyarrüpecu, tarucu nüriacarrti. Arrti Tuparrü bayurarati ümo nesarrti genterrü, bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Au nanaiña cürrü Judea y auna itupecu ipiatema arrüna isamutenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Arrti Juan Bautista ipiatenti nanaiña arrüna sane, itopiqui urapoimia isucarüti bama ñanunecasarrti. Auqui batasuruti ümo bama torrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bacüpuruti ümoma, nauqui aüromatü esati Jesús, nauqui anquirioma pünanaquiti sane: “¿Arrücü Cristo, naqui yebobotü, o tiene que suparrüperaiqui cümenutiqui? ");
INSERT INTO caxNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Arrübama torrü macoreoca uiti Juan süromatü esati Jesús. Aiñanaimia esati, namatü ümoti: —Arrti Juan Bautista icüpuruti somü nauqui supanquirio apünanaquicü, arrtü arrücü Cristo, naqui yebobotü, ¿tiene que suparrüperaiqui cümenuti? ");
INSERT INTO caxNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Au manu nauquiche iñataimia, arrti Jesús anancati bacurarati ümo bama sürümanama maunrrocono y arrübama anati choborese auma. Aboma ito bama supuso, uiti asarama tato. ");
INSERT INTO caxNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Auqui iñumutati Jesús nurarrüma, nanti: —Amecosi tato aburaboi isucarüti Juan nanaiña arrüna amarrtai y arrüna amoncoi. Aburasoi ito isucarüti que arrübama supuso asarama tato, arrübama chamencopü amencoma tato sobi, arrübama maunrrocono ui lepra urriancama tato, arrübama chonaumpüma onauma tato, arrübama coiño süboricoma tato y surapoi ito isucarü bama pobrerrü arrüna omirriantai manitacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Urriampae nacarrti naqui chübatachebotipü ñacoconauncurrti iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nauquiche tüsüroma tato bama yacüpusurrti Juan, arrti Jesús manitanati cütüpüti Juan. Nanti ümo genterrü: —¿Isanempü ümoche abacatü aucutanu au rroense? ¿Taqui abacatü amasarai taman nihi tutairri ane mapetonono ui maquiütürrü? ");
INSERT INTO caxNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O abacatü amasarati taman ñoñünrrü naqui champü tacanache naibiquirrti? Arraño tusio aume que arrübama champü tacanache naibiquirrimia aboma au nipo bama mayüriabuca. ");
INSERT INTO caxNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Isanemo nümoche abacatü? ¿Taqui abacatü amasarati taman profetarrü? Ñemanauntu nurria, arrti te profetarrti. Manrriqui nüriacarrti pünanaquiti profetarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Arrti Juan tonenti maniqui coreorrü uiti Tuparrü. Ane te corobo icütüpüti Juan arrüna sane nurarrti Tuparrü ümoti Cristo: “Rracüpuca ümoti taman coreorrü, nauqui acusürüti aicoñocoti cutubiurrü acümenucü”. ");
INSERT INTO caxNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Ñemanauncurratoe sucanañü aume —nanti Jesús—, icu na cürrü champü tanati naqui manrrü ane nüriacarrti pünanaquiti Juan Bautista. Pero au na cauta üriabucati Tuparrü arrti naqui chitonentipatai ane manrrü nüriacarrti pünanaquiti Juan. ");
INSERT INTO caxNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","‛Nanaiña genterrü ichepe bama mayacobraca impuestorrü iñorronconomacü y ürioma uiti Juan tücañe. Urria ümoma ñapensacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tapü arrübama fariseorrü y bama maestro ümo nüriacarrü champürrtü ürioma uiti Juan. Chirranrrüpüma asuriuma arrüna urria ñapensacarrti Tuparrü aübuma. ");
INSERT INTO caxNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nantito Señor ümoma: —¿Aübuchepü ichepeca bama macrirrtianuca arrüna tiemporrü caüma? ");
INSERT INTO caxNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Arrüma tacana arronema masiomanca aboma tümonsoma au plaza, cupiusuma. Tosibicoma ümo bama icumpañeruturrüma, namatü: “Supapunuca burrirri aume, pero chautococapü. Supasoniquia aume arrüna orronenatai, pero chabareocapü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Itopiqui numo cuati Juan Bautista, arraño amucanaño que anati choborese auti, locorrti, itopiqui amarrtai chipiacatipü achati arrüna ocoro, y charucupatai niyacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Auqui isecatü arrüñü naqui Ñemanauncurratoe Ñoñünrrü. Arrüñü caüma irraca, ichaca, y arraño amucanaño iñemo que chaborrüñü y tarucu nirraca. Amucanaño ito que arrüñü amigorrüñü ümo bama tarucu nomünantü uimia y ümo bama mayacobraca impuestorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero tusiatai arrüna ñapanauncurri Tuparrü ui arrüna urria isamutenti auna icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tamanti eanaqui manuma fariseorrü itasurutiti Jesús nauqui aati ichepeti. Arrti Jesús sürotitü au niporrti. Aiñanainti taha. Atümoti esa mensarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ananca taman paürrü pohoso au manu pueblurrü, churriampatai nisüboriquirri. Oncoi nürirrti Jesús, ta sürotitü aati au niporrti maniqui fariseorrü. Auqui iñatai acamanu esati aübu taman boteyama ataso ui nasaite arrüna urriampae norimia. ");
INSERT INTO caxNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Areoro. Bachesoiyo esati Jesús. Panso nipoperrti ui nisucürrü. Isübuta tato ui niqui nitanurrü. Besabo ito ümo nipoperrti. Isemata manu nasaite nipoperrti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nauquiche tarrtaiti arrüna sane maniqui fariseorrü naqui itasurutiti Jesús, mapensarati: “Arrtü ñemanauntupü profetarrti naqui Jesús, tusiopü ümoti isane naca na paürrü, ta churriampü nisüboriquirri. Y todaviarrü iñenoti”. ");
INSERT INTO caxNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Auqui nanti Jesús ümoti maniqui fariseorrü: —Simón, ane arrüna irranca suraboi asucarücü. Aiñumuti maniqui fariseorrü, nanti: —Urasoi te isucarüñü, maestro. ");
INSERT INTO caxNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Auqui nanti Jesús ümoti: —Aboma torrüma mañoñünca ebeoma ümoti taman yaprerrtarrü. Arrti maniqui taman ebeoti quiniento denarios, arrti maniqui quiatarrü ebeoti cincuenta denarios. ");
INSERT INTO caxNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Arrümanuma torrü chüpuerurrüpüma apacanema manu nebequirrimia. Pero arrti maniqui baprerrtarati ümoma itorrimiatatiatai ümoma manu nebequirrimia. ¿Uracü sane, ñacuti eanaqui manuma torrü manrrü machampiencanati ümoti? ");
INSERT INTO caxNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Arrti Simón aiñumuti: —Canapae arrti maniqui ebeoti manrrü. Nanti Jesús: —Ñemanauncurratoe arrüna ucanü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Auqui asaratitü ümo manu paürrü, nanti ümoti Simón: —Ani na paürrü. Nauquiche iñatai auna napo, champürrtü acheca iñemo turrü, nauqui iyarrübirio nipope. Tapü arrüna paürrü iyarrübirio nipope ui nisucürrü, y isübuta tato ui niqui nitanurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Champürrtü acheca besorrü iñemo, pero arrüna paürrü nauquiche iñatai auna napo, ane besabo ümo nipope. ");
INSERT INTO caxNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Champürrtü acheca ito iñemo nasaite arrüna urriantai norimia ümo nichanu, pero arrüna paürrü isemata nasaite nipope. ");
INSERT INTO caxNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sane nauquiche suraboira asucarücü arrüna sane: Morrimiacana tato arrüba tarucapae nomünantü uirri, sane nauquiche tarucapae nisuasürücü ümo. Pero arrti naqui morrimiacana tato chimiantai nomünantü uiti, chimiantaito arrüna nisuasürücü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Auqui nanti Jesús ümo manu paürrü: —Arrüba nomünantü obi, chauqui tümorrimiacana tato sobi. ");
INSERT INTO caxNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tapü arrübama amoncoma tümonsoma acamanu ichepeti namatü ümomantoe: —¿Ñacutipü naqui ñoñünrrü? Hasta morrimiacana tato uiti nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Auqui nantito Jesús ümo manu paürrü: —Chauqui tataesübuca eanaqui nomünantü, itopiqui aicococañü. Acosi tato, taiquina urria tanu aemo. ");
INSERT INTO caxNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nauquiche tüpasao arrüna sane, arrti Jesús amencoti auqui sürümana puebluca y poca. Urapoiti arrüna nüriacarrti Tuparrü. Arrübama doce ñanunecasarrti süromatü isiuti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Amonquio ito ichepeti manio paüca, tomirrianquio tato uiti. Abe arrüba anancati choborese ubau. Abe ito arrüba amonquio upaunrrocono. Acamanu omeana ananca Mariarrü, arrüna nürirri ito Matarenarrü, arrüna amoncoma tücañe siete machoboreca ahu. ");
INSERT INTO caxNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ananca ito Juanarrü, nicüpostoti Chuza naqui administrador ümoti yüriaburrü Herodes. Ananca ito Susana acamanu y amonquio ito piquiataca paüca. Payurara y pachebo arrüna ane oboi ümoti Jesús y ümobama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sürümanama bama auqui puebluca süromatü asaramati Jesús. Nauquiche tütaboma sürümanama macrirrtianuca, manunecanati ümoma ui arrüna machepecatarrü, nanti: ");
INSERT INTO caxNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tamanti ñoñünrrü sürotitü ancütuti. Basupiutati niyorrü. Auqui abe ba bupaquio isiu cutubiurrü. Icümotema macrirrtianuca, y cuantio nutaumanca yubario. ");
INSERT INTO caxNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Abe ito arrüba bupaquio omeana canca. Ububaüro manio niyoca. Pero unrratorrü bosübo, itopiqui champürrtü panso nurria cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Abe ito arrüba bupaquio omeana cümeca. Ububaüro y musunaun manio plantamanca ichepe manio cümeca. Pero manrrü apuraurrü niñusunaun manio narrüchopüro cümeca. Sane nauquiche chiyebopü oboi manio plantamanca. ");
INSERT INTO caxNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Abe ito arrüba bupaquio auna urriampae cürrü. Ububaüro y musunaun. Pachebo nobütarrü chama. Hasta pachebo auquitaman niyoma cien niyorrü. Manitanati Jesús fuerte nurria, nanti: —Arraño ane naumumasu. ¡Amonsapesio te! ");
INSERT INTO caxNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Auqui arrübama ñanunecasarrti ñanquitioma pünanaquiti: —¿Isane nümoche arrüna machepecatarrü? ");
INSERT INTO caxNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nanti Jesús ümoma: —Arraño torrio aume uiti Tuparrü nauqui aye aboi arrüba machepecataca, causane nüriacarrti. Pero ümo bama maquiataca rranitaca ui machepecatacatai. Sane caüma chiyebopü uimia. Asaramatü, pero charrtaipüma. Oncoimia, pero chüsüropü au nitanurrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‛Suraboira ausucarü isane nümoche arrüna machepecatarrü: Arrümanu niyorrü tacana nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Arrümanio bupaquio isiu cutubiurrü tacana arrübama oncoi, pero cuati choborese iquiaübutati nurarrti Tuparrü auqui nausasürrüma, tapü icocotama, y tapü taesüburuma eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tapü arrümanio niyoca bupaquio eana canca tacana arrübama ocoimia y yasutiuma nurarrti Tuparrü aübu nipucünuncurrüma. Pero champürrtü icocotama nurria. Icocotama baeta. Auqui caüma, arrtü cuatü taquisürücürrü ümoma, iñocotama ñacoconauncurrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tapü arrümanio niyoca bupaquio eana cümeca, tacana arrübama oncoimia nurarrti Tuparrü, pero champü nümoche uimia, itopiqui tarucu penarrü uimia iyo ausüratai icuqui nantai cürrü, y mapensarama iyo nenarrirrimia y iyo pierrtacatai. Ui arrüna sane chicoñocotapüma nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero arrümanio niyoca bupaquio au na urriampae cürrü, tonema bama yasutiuma nurarrti Tuparrü aübu nanaiña nausasürrüma. Toneantai ñapensacarrüma. Isamutema isiu nurarrti Tuparrü. Chübatachebopüma arrtü cuantio macocotoca ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nantito Jesús: —Arrtü uiñonocota taman basarurrü, chüpuerurrüpü uitamurriquia, ni uiñatapü iquiana cürurrü. Ta uiñotorrimiata ape, nauqui anentarrüpo ümo bama cuamatüpo. ");
INSERT INTO caxNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sane ito arrüna anecanatai, ta tiene que atusi ñana. Nanaiña arrüna chütusiopü caüma, tusiatai ñana. ");
INSERT INTO caxNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Amonsoi nurria arrüna nisura, itopiqui arrti naqui oncoi, tusio ümoti y torrioiqui manrrü uübo ipiacaboti. Pero arrti naqui chütusiopü ümoti, caüburu pünanaquiti arrüna ipiacati au ñapensacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Acamanu ito iñatai nipiacütoti Jesús ichepe bama yaruquitorrti. Pero chüpuerurrüpüma aiñanaimia taha esati nurria, itopiqui sürümanama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tamanti urapoiti isucarüti Jesús, nanti: —Napacüma y bama aruquitaiqui aboma taha türüpo, rranrrüma asaramacü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero arrti Jesús nanti ümoma: —Arrübama oncoimia nurarrti Tuparrü y icocotama y isamutema isiu, tone nipiacü y tonema bama masaruquitaiqui. ");
INSERT INTO caxNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Taman nanenese arrti Jesús süroti au barco aübu bama ñanunecasarrti, nanti ümoma: —Curi taha topü na turrü. Auqui süromatü, ");
INSERT INTO caxNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","niyücürrüma isuqui turrü. Arrti Jesús manumuti au barco. Nauquiche aboma cümuinta manu turrü, cuatü fuerte maquiütürrü, y pocoro nurria turrü uirri. Süro turrü au barco y rranrrü ubaca. ");
INSERT INTO caxNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Auqui airrtopünanamati Jesús. Namatü ümoti: —¡Maestro, Maestro, tüsaiyapae uyubaca! Auquimanu arrti Jesús atüraiti. Icuansomocotati maquiütürrü y turrü. Au manu rratorrü nanaiña tochenco uiti. Chümaquiütücaiquipü, ni apocoiquipü turrü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Auqui nanti ümo bama ñanunecasarrti: —¿Causane chapicococapüñü nurria? Pero arrüma cütobüsoma. Ñanquitioma pünanaquimiantoe: —¿Isanempü nacarrti naqui ñoñünrrü? Manitanati ümo maquiütürrü y ümo turrü, y opicocota nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aüboqui aiñanaimia topü manu narubaitu turrü au manu cürrü nürirri Gadara, niyequirrimia auqui Galilea. ");
INSERT INTO caxNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tobüsoti acü Jesús auqui barco. Auqui cuati taman ñoñünrrü esati auqui pueblurrü, naqui chaübopü nacarrüma machoboreca auti. Anati cüsuasati y chübavivicotipü au porrü, si no eana bama coiño. ");
INSERT INTO caxNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nauquiche tasaratitü cümenuti Jesús, sürotitü achesoiti esati aübu nitosibirrti. Nanti maniqui choborese turuquiti: —¿Causane ayetü auna yesañü, arrücü Jesús, Aütorrti yarusürürrü Tuparrü? Tapü aitaquisünüancacañü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nanti sane maniqui choborese, itopiqui arrti Jesús ticüpurutiti auquiti maniqui ñoñünrrü. Taipü arrübama macrirrtanuca nantarrü itomoenomati maniqui ñoñünrrü. Tomoeno neherrti y nipoperrti ui carenarrü. Pero arrti itopünatati y sürotitü uiti choborese au rroense auna cauta cücheca. ");
INSERT INTO caxNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Auqui arrti Jesús ñanquitioti pünanaquiti: —¿Isane nüri? Aiñumuti: —Arrüñü nisüri “Sürümanama”. Nanti sane itopiqui sürümanama bama machoboreca aboma auti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Arrübama machoboreca manquioma pünanaquiti Jesús tapü bacüpuruti ümoma au manu nusutu cürrü, arrüna champü nitacürurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Acamanu saimia amonquio nupaucheca, abe bubaso onü manu yiriturrü. Manquioma machoboreca nauqui puerurrüma aüromatü ubau manio nupaucheca. Torrio uiti Jesús ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Auqui süromatü auquiti maniqui ñoñünrrü. Süromatü ubau manio nupaucheca. Uirri caüma locorriantai. Opipiacünaño abeuqui manu nisacürrü, bupaquio au turru y ububacara. Mocoiño. ");
INSERT INTO caxNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tapü arrübama bacuirara yutacu cütobüsoma ui arrüna sane arrtaimia. Süromatü yarucurrüma au pueblurrü y au nanaiñantai uraboimia arrüna sane pasabo. ");
INSERT INTO caxNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nauquiche toncoimia bama pohoso, süromatü asaborimia. Aiñanaimia taha esati Jesús. Arrti maniqui ñoñünrrü naqui amoncoma machoboreca auti, anati tümonsoti esati Jesús. Ane naibirrti tato. Champü causane nacarrti. Arrübama pohoso birrubuma. ");
INSERT INTO caxNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Arrübama arrtaimia arrüna pasabo urapoimia isucarüma, causane nauquiche urriancati tato maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ui arrüna sane enterurrüma bama macrirrtianuca auqui manu cürrü Gadara namatü ümoti Jesús: —Asamu nurria suiñemo, acosi auquina subarrüpecuqui. Itopiqui tarucu nirrucurrüma. Auqui arrti Jesús süroti tato au barco, nauqui aüroti tato au Galilea. ");
INSERT INTO caxNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tapü arrti maniqui ñoñünrrü urriancati tato rranrrti aürotitü isiuti Jesús. Pero arrti Jesús chirranrrtipü. Nanti ümoti: ");
INSERT INTO caxNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Acosi tato au napo, urasoi tanu arrüna urria yachücoiti Tuparrü aübucü. Auqui süroti tato maniqui ñoñünrrü. Urapoiti au pueblurrü arrüna urria isamutenti Jesús ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nauquiche tiñataiti Jesús taha topü manu narubaitu turrü, yasuriurumati aübu nipucünuncurrüma, itopiqui namanaiña amoncoma barrüperarama cümenuti. ");
INSERT INTO caxNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Auqui iñataitito taman ñoñünrrü nürirrti Jaíro, naqui ane nüriacarrti au porrü sinagoga. Arrti bachesoiyoti esati Jesús. Anquiti pünanaquiti nauqui aüro itü au niporrti, ");
INSERT INTO caxNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","itopiqui nitaquiumucuturrti tüsaiyapae aco. Manu nitaquiumucuturrti ane taqui doce añorrü ümo. Sürotitü Jesús isiuti y süromatito isiuma sürümanama macrirrtianuca, hasta que simianati Jesús uimia. ");
INSERT INTO caxNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Acamanu eanama ananca taman paürrü maunrrocono. Tütabe doce añorrü nacarrü aübu manu narapaca notorrü. Champü isane ümo, itopiqui nanaiña carrtao uirri nauqui urrianempü tato, pero champüti naqui mercurrü puerurrü acurati ümo. ");
INSERT INTO caxNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Arrümanu paürrü sürotü esati Jesús chacuquiti. Iñenta nabeu naibirrti, y au manu rratorrü tochenco narapaca notorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Auqui arrti Jesús ñanquitioti: —¿Ñacuti iñenoñü? Champüti manitana. Arrti Pedro y arrübama icumpañeruturrti namatü ümoti: —Maestro, arrtai te arrübama macrirrtianuca isimianamacü y ipenenomacü. ¿Causanempü anquirio ñacuti aiñenü? ");
INSERT INTO caxNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero arrti Jesús nanti: —Tamanti iñenoñü, itopiqui tusio iñemo tamanti urriancati tato ui nisusüu. ");
INSERT INTO caxNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tütusio ümo manu paürrü, ta chüpuerurrüpü aiñanecanü manrrü. Así que sürotü esati Jesús aübu nipiaichoconocorrü ui nirrucurrü, achesoi esati. Urabü isucarü namanaiña macrirrtianuca, itopiquiche aiñenoti Jesús, y causane ito nauqui urrian tato. ");
INSERT INTO caxNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Auqui nanti Jesús ümo: —Turriancü tato, itopiqui aicococañü. Acosi tato, taiquiana urria aemo tanu. ");
INSERT INTO caxNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Anancatiqui manitanatiqui, auqui iñataiti taman auqui niporrti Jaíro. Nanti ümoti Jaíro: —Nataquiumucu chauqui tücoiño, tapü asiquiaiqui icuatati naqui maestro. Champü nümochequi. ");
INSERT INTO caxNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Arrti Jesús oncoiti nurarrrti. Nanti ümoti Jaíro: —Tapü airruca, aicocosoñüantai. Nataquiumucu urriante tato caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nauquiche tiñataiti au niporrti Jaíro, champürrtü chebo uiti nauqui aüromatüpo ichepeti cunauntaiñamantai Pedro, arrti Jacobo, arrti Juan y arrti maniqui iyupurrü y nipiapa manu cupiquimia. ");
INSERT INTO caxNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Namanaiña amoncoma areoroma y sucheboma isiu manu cupiquirri. Auqui nanti Jesús ümoma: —Tapü abareoca, arrüna cupiquirri champürrtü coiño, ta ane manumu. ");
INSERT INTO caxNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero arrübama amoncoma acamanu iyabomati Jesús, itopiqui tusio ümoma ta coiño. ");
INSERT INTO caxNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Auqui arrti Jesús sürotitü esa. Iñentati nehese, manitanati ümo fuerte nurria, nanti: —¡Cupiquirri, atüsai! ");
INSERT INTO caxNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Auquimanu süborico tato y au manu rratorrü atürai tato. Arrti Jesús bacüpuruti nauqui asapanema. ");
INSERT INTO caxNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Arrti yupurrü ichepe nipiaparrü cütobüsoma. Auqui nanti Jesús ümoma: —Tapü aburapoi tanu arrüna pasabo one. ");
INSERT INTO caxNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Auqui arrti Jesús oberabarama uiti bama doce ñanunecasarrti. Bacheboti ümoma üriacaboma, nauqui puerurrüma acüpuma tanene ümo bama machoboreca, y nauqui urriancama tato uimia bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nanti ümoma: —Icüpucaño nauqui aburaboi arrüna causane arrtü üriabucati Tuparrü, y nauqui apacura ümo bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nantito ümoma: —Tapü apacaca isaneantai, ni barrton, ni pusanese, ni autapiquibo, ni aumonibopü. Amecosi aübu arrüna ane aucütüpü. Tapü apacaca quiatarrü camisarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Arrtü anati naqui yasuriuruti año au niporrti, abasiquia acamanu cheperrtü amecatito auquimanu. ");
INSERT INTO caxNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Arrtü apiñatai au taman pueblurrü auna cauta chirranrrüpüma asuriuruma año, amecosito auquimanu. Apipetobisaño ñünana cütorrü, na atusi ümoma que ane nipünatema. ");
INSERT INTO caxNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Auqui süromatü manuma doce. Amencoma auqui nanaiña puebluca. Urapoimia arrüna urriampae manitacarrü y urriancama tato uimia bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Arrti yüriaburrü Herodes ipiatenti nanaiña arrüna isamutenti Jesús. Chütusiopü ümoti causane uiti ui arrüna oncoiti, itopiqui aboma bama namatü que arrti Juan Bautista süboricoti tato, que tonenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Maquiataca namatü, arrti Jesús tonenti profetarrü Elías, naqui cuati tato icu cürrü. Aboma ito maquiataca namatü, arrti Jesús tonenti taman profetarrü antiburrü, naqui süboricoti tato. ");
INSERT INTO caxNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tapü arrti Herodes nanti: —Arrüñü rracüpuca tücañe nauqui atüsü nitanurrti Juan Bautista; tusio te iñemo ta coiñoti. ¿Ñacutipü maniqui ipiatempae nürirrti, maniqui Jesús? Sane nauquiche arrti Herodes rranrrti asaratiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Auqui cuama tato bama apostolerrü esati Jesús. Iñataimia esati. Urapoimia isucarüti nanaiña arrüna isamutema. Auqui arrti Jesús sürotitü aübuma auna cauta champü genterrü, taha saimia manu pueblurrü nürirri Betsaida. ");
INSERT INTO caxNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nauquiche tütusio ümo bama macrirrtianuca, süromatü isiuti. Arrti yasuriuruti ümoma aübu nurria. Manitanati ümoma causane arrtü üriabucati Tuparrü. Arrübama maunrrocono eanama urriancama tato uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nauquiche tütümümüca, arrübama ñanunecasarrti süromatü esati, namatü ümoti: —Asamu nariorrü ümo na genterrü, nauqui aüro tato acansa y nauqui apache tuburibo taha ubau manio poca saimia. Itopiqui auna cauta nusaca champü isane. ");
INSERT INTO caxNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero arrti Jesús nanti ümoma: —Apache arraño tuburiboma. Auqui namatü: —Champü isane soboi, cunauntaiñantai cinco panes y torrü nopiococa. ¿Arrianca nauqui somenotü supacompora pemacarrü ümo na cütüpürrü genterrü? ");
INSERT INTO caxNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Arrüna nubiquirrimia taqui cinco mil mañoñünca. Auqui nanti Jesús ümo bama ñanunecasarrti: —Aburasoi isucarüma tari tümonsoma taiquiana cincuenta. ");
INSERT INTO caxNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sane isamutema. Namanaiña tümonsoma. ");
INSERT INTO caxNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Auquimanu arrti Jesús iquianiotiño mecuti manio cinco panes y arrümanio torrü nopiocomanca. Asaratitü ape. Machampiencanati ümoti Tuparrü yobitobo. Auqui itorrimiatati ümo bama ñanunecasarrti, nauqui aitorrimiama ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Namanaiña basoma y abecoma nurria. Auqui ubataso doce noconoca ui na nisobüraturrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Taman nanenese arrti Jesús anancati meaboti. Aboma ichepeti bama ñanunecasarrti. Auqui ñanquitioti pünanaquimia: —¿Urama sane macrirrtianuca iñemo? ");
INSERT INTO caxNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Arrüma namatü: —Aboma bama namatü arrücü Juan Bautista. Aboma bama maquiataca namatü arrücü Elías. Namatito aemo bama maquiataca arrücü tamanti uturuqui bama antiburrü profetarrü, naqui süborico tato. ");
INSERT INTO caxNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Auqui ñanquitioti pünanaquimia: —¿Carü arraño, aburaño iñemo? Auqui arrti Pedro nanti ümoti: —Arrücü Cristo naqui tacümanauncunu uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Auqui arrti Jesús urapoiti nurria isucarüma, tapü urapoimia arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nantito ümoma: —Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ichaquisürü nurria y chüpuerurrüpü isuasürü ümo bama mamayoreca israelitarrü y bama üriatu sacerdoterrü y bama manunecana nüriacarrü. Tiene que ichabori, pero pürücü trerrü naneneca isüboriquia tato. ");
INSERT INTO caxNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Auqui nantito ümo namanaiña: —Arrtü anati naqui rranrrü ayetitü isiuñü, tari taquisürübati isiuquiñü. Tari tacürusu ñaquioncorrti iyotiatoe naneneca, tacanarrtü chüvaleopü nisüboriquirrti ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Arrti naqui chirranrrüpü aconti auqui niyaca, ensoro ñana nisüboriquirrti. Pero arrti naqui coiño auqui niyaca iyebo uiti ñana nisüboriquirrti au napese. ");
INSERT INTO caxNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Champü niyaserebiquirri ümoti ñoñünrrü acananenti nanaiña arrüba abe icu na cürrü, arrtü au nitacürurrü peneco nausüpürrti au infierno. Itopiqui tarucu nicua nuyausüpü. Champü aye uirri tacana nicuarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Arrti naqui cüsobo saübuñü y aübu nisura, arrüñü ito chirrancapü yaca aübuti au manu nanenese auche iseca tato aübu tarucu nanentacarrü y aübu tarucu nisüriaca uiti Iyaü, y aübu bama angelerrü samamecana ümoti, ta arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sucanañü ito aume ñemanauncurratoe: Aboma bama auna auchepe chüpuerurrüpü acoma cheperrtü arrtaimia nüriacarrti Tuparrü auna icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tübupasao ocho naneneca nipiarirrti Jesús sane. Auqui sürotitü onü taman yiriturrü nauqui eanti. Süromatü isiuti arrti Pedro, arrti Jacobo y arrti Juan. ");
INSERT INTO caxNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nauquiche tanancati Jesús meaboti, campiabo naca nisurrti y arrüna naibirrti isamunü purusubiapae, cuara. ");
INSERT INTO caxNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Auquimanu paecüburuma torrü mañoñünca aparimia aübuti Jesús. Arrümanuma torrü arrti Moisés y arrti Elías. ");
INSERT INTO caxNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tarucapae nanentacarrü itupecuma. Manitanama ümo niconcorrti Jesús, y ümo arrüna cuabotü itaquisürücüboti au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Arrti Pedro y arrübama icumpañeruturrti tarucapae nirrancarrüma anuma. Pero süsioma arrtayomatü. Sane nauquiche arrtaimia arrümanu nanentacarrti Jesús, aübu manuma torrü mañoñünca auqui napese amoncoma ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Masamuña aquichoma esaquiti Jesús manuma torrü. Auqui arrti Pedro nanti: —Maestro, urriampae nusaca auna. Supasamuna trerrü cüpahumanca, taman aemo, taman ümoti Elías quiatarrü ümoti Moisés. Pero arrti Pedro manitanatiatai, chütusiopü ümoti isane arrüa nanti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nauquiche anatiqui manitanati Pedro, cuatü taman cüsaüborrü, itamurriquianama. Arrübama ñanunecasarrti Jesús birrubuma, itopiqui taboma eana manu cüsaüborrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eanaqui manu cüsaüborrü rabotü taman manitacarrü, nantü sane: —Arrti naqui tonenti isaü. Tarucu nicuarrti iñemo. ¡Amonsotü ümoti! ");
INSERT INTO caxNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nauquiche tochenco manu manitacarrü, auqui asaramatü tato ümoti Jesús, tamantiatai. Arrüma churapoipüma isucarüti quiatarrü arrüna arrtaimia. ");
INSERT INTO caxNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Au manu quiatarrü nanenese cuama tato onüqui manu yiriturrü. Cuamatü sürümanama macrirrtianuca cümenuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eanama anancati taman ñoñünrrü. Arrti manitanati fuerte nurria. Nanti sane ümoti Jesús: —Maestro, asamu nurria iñemo, apucüru itacuti cunauntaiñatiatai isaü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anati choborese auti. Arrtü cuatü ataquerrü ümoti tosibicoti uiti, y atüo ahiquiti. Yaruraüburutiti acü y chirranrrtipü aiñemecanatito. ");
INSERT INTO caxNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chauqui tirranquiquia pünanaqui bama anunecasa, nauqui aicüpurumati choborese auquiti. Pero chüpuerurrüpüma. ");
INSERT INTO caxNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Auqui arrti Jesús nanti: —Hasta caümainqui chapicococapüñü, y tarucu nomünantü aboi. Abu tücoboi niyaca abarrüpecu. ¿Hasta auchepü ñana tiene que ñasamunaunca abaübu? ¡Apiquiataunarrti maniqui ñaüma! ");
INSERT INTO caxNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nauquiche sürotitü esati Jesús maniqui ñaüma, arrti choborese yaruraüburutiti tatito acü ümo quiatarrü ataquerrü. Pero arrti Jesús icuansomoconotiti maniqui choborese. Y sane caüma urriancati tato maniqui ñaüma uiti Jesús. Aitorrimiatiti tato ümoti yaütoti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Namanaiña cütobüsoma ui arrüna sane nüriacarrti Tuparrü. Nauquiche amoncomainqui cütobüsoma ui arrüna sane, nanti Jesús ümo bama ñanunecasarrti: ");
INSERT INTO caxNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Amonsoi nurria arrüna sane, tapü tacürusu napaquionco: Arrüñü Ñemanauncurratoe Ñoñünrrü ichorriquia ñana mecu bama mañoñünca. ");
INSERT INTO caxNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero arrübama ñanunecasarrti chiyebopü uimia isane ümoche arrüna nanti. Champürrtü tütorrio ümoma nauqui entienderrüma. Birrubuma anquirioma pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Auqui arrübama ñanunecasarrti uratoquioma ñacuti eanaquimia ane manrrü nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero arrti Jesús tusiatai ümoti arrüna ñapensacarrüma. Iquianatiti taman ñaüma esati. ");
INSERT INTO caxNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nanti ümoma: —Arrti naqui yasuriurutiti naqui ñaüma au nisüri, ta tacanarrtü yasuriurutiñü ito. Arrti naqui yasuriurutiñü, yasuriurutitito naqui uiche aicüpuruñü. Itopiqui arrti naqui chütonempatai, tonenti naqui manrrü ane nüriacarrti abarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Auqui arrti Juan nanti ümoti Jesús: —Maestro, anati taman ñoñünrrü, sumasacati bacüpuruti tanene ümo bama machoboreca au nüri. Auqui prohibibo soboi ümoti, tapü asioti aisamunenti sane, itopiqui champürrtü amencoti suichepe. ");
INSERT INTO caxNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Auqui arrti Jesús nanti ümoti: —Asioti saneantai, itopiqui arrti naqui chütüboricopü oemo, bayurarati oemo. ");
INSERT INTO caxNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nauquiche tüsaimia manu tiemporrü nauqui aüroti tato Jesús au napese, sürotitü au Jerusalén aübu nanaiña nirrancarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bacüpuruti ümo bama coreorrü, nauqui ariorrüma acusürüma au manu taman puebluma au manu cürrü Samaria, nauqui apachema cauta arücüma manu tobirri. Süromatü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero arrübama samaritanorrü chirranrrüpüma asuriuruma, itopiqui ünantü ümoma arrüna niyücürrüma au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Arrti Jacobo ichepeti Juan nauquiche oncoimia arrüna sane, namatü ümoti Jesús: —¿Señor, arrianca nauqui supanqui pese auqui napese, nauqui üüma bama samaritanorrü, tacana arrüna tücañe uiti profetarrü Elías? ");
INSERT INTO caxNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero arrti Jesús macuansomoconoti ümoma, nanti: —Canapae tacürusu napaquionco, ta apacoconaunca ümoti Espíritu Santo, champürrtü ümoti choborese. ");
INSERT INTO caxNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Arrüñü Ñemanauncurratoe Ñoñünrrü champürrtü isecatü nauqui itabairoma macrirrtianuca, ta isecatü nauqui ataesübuma sobi eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Auqui süromatü au quiatarrü puebluma arücüma. Nauquiche aboma isiu cutubiurrü, tamanti ñoñünrrü nanti ümoti Jesús: —Señor, irranca yerotü asiucü au nanaiña auna cauta naecü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Arrti Jesús iñumutati: —Arrüba numantureca abe niyoporrü cütu, y arrüba nutaumanca abe niñusumenurrü auna cauta apacansa. Pero arrüñü Ñemanauncurratoe Ñoñünrrü champü nipo cauta ñacansa. ");
INSERT INTO caxNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nantito Jesús ümoti quiatarrü: —¡Ariacu isiuñü! Arrti iñumutati: —Señor, yeca tanu asiucü, arrtü tücoiñoti taita. ");
INSERT INTO caxNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Auqui nanti Jesús ümoti: —Arrübama chicocoropümañü tonema bama au narrtarrti Tuparrü tacana coiñoma. Tari tonema bama uiche aüroma cütu bama coiño. Pero arrücü acosi uraboi nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Auqui nantito quiatarrü ümoti Jesús: —Señor, irranca yerotü asiucü, pero yecatü baeta ñasamu nariorrü ümo bama ipiariente au nipo. ");
INSERT INTO caxNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Auqui arrti Jesús urapoiti isucarüma arrüna machepecatarrü: —Arrti naqui rranrrti atrabacati au ñanaunrrü pero chiñatatipü nurria, chüpuerurrüpü aye uiti naurri ñanaunrrü. Isiatai arrti naqui rranrrti aserebiti auna cauta ane nüriacarrti Tuparrü, tapü batacheboti ui maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nauquiche tübupasao nanaiña arrüna sane, arrti Señor matacümanauncunutito ümo bama setenta, nauqui aüromatü taiquiana torrüma auqui nanaiña poca y puebluca, arrüba auquiche tiene que apasatiqui. ");
INSERT INTO caxNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Urapoiti isucarüma arrüna machepecatarrü: —Ñemanauncurratoe sucanañü aume, chama arrüna iyebo au ñanaunrrü. Tapü bama matana mümanamantai. Sane nauquiche apanqui pünanaquiti naqui iyoche, nauqui acüputi bama trabajadorerrü, nauqui atama. (Arrübama choncoipü nürirrti Jesús tonema tacana ñanaunrrü. Arrübama urapoimia nürirrti Jesús tonema tacana bama matana.) ");
INSERT INTO caxNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Icüpucaño tacana arrone nobirramanca omeana nuitümüca. ");
INSERT INTO caxNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tapü apacaca pusanese ausübo naumoni, ni sapaturrüpü. Tapü yabaiturrü napapariqui aübu bama apicuñucama isiu cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Arrtü apiñatai au taman porrü, apanqui nurria ümo bama pohoso. Amucanaño sane: “Taiquiana urria nabaca uiti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Arrtü yasutiuma napanquiqui, urria nacarrüma. Tapürrtü chiyasutiupüma, chücurusüopüma aboi. ");
INSERT INTO caxNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Arrtü alojabo año au taman porrü, abasiquia acamanu. Auba y aucha arrüna torrio aume uimia. Itopiqui arrti naqui trabajador tiene que apacama ümoti. Tapü amamenca au pocatai. ");
INSERT INTO caxNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Arrtü apiñatai au taman pueblurrü auna cauta yasuriuruma año, auba y aucha arrüna torrio aume uimia. ");
INSERT INTO caxNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Apacura ümo bama maunrrocono arrtü aboma acamanu. Amucanaño ümo bama pohoso: “Arrti Tuparrü üriabucati abarrüpecu caüma”. ");
INSERT INTO caxNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero arrtü apiñatai au taman pueblurrü auna cauta chirranrrüpüma asuriuruma año, amecosi isiu cayarrü amucanaño sane: ");
INSERT INTO caxNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Arrüna cütorrü auqui naubesa pueblurrü sopicütobita cütüpüqui suipope, nauqui atusi ta ane napipünate. Pero chauqui tütusio aume, arrti Tuparrü üriabucati caüma”. ");
INSERT INTO caxNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Au manu nanenese nesa bacurrtacarrü ñana torrio carrticurrü ümo manuma pohoso acamanu, manrrü fuerte nurria pünanaqui manu carrticurrü torrio ümo bama pohoso au manu pueblurrü Sodoma tücañe, bama tarucu nomünantü uimia. Auqui süromatü manuma setenta. ");
INSERT INTO caxNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‛Autaquisürücatai bama pohoso auqui Corazín y Betsaida. Arrübama pohoso au manio puebluca Tiro y Sidón tarucu nomünantü uimia tücañe. Pero arrtü nampü omirriante arrüba milagrorrü taha tücañe, coboipü aiñorronconomacü, aibibomampü luto y manrrü tübütürrü itama, na atusi ta orronrrü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero arrtü iñatai manu nanenese auche bacurrtarati Tuparrü, arraño apasutiu manrrü carrticurrü pünanaqui na genterrü auqui Tiro y Sidón. ");
INSERT INTO caxNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¿Carü arraño bama pohoso au Capernaum. Napaquioncopü tarucu manauncurrü aume, abu tiene que aupene au nusutu cürrü auna cauta aboma bama macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","‛Suraboira aume, bama nirranunecasa: Arrtü oncoimia nabura, ta tacanarrtü oncoimia nisura. Y arrtü chiyasuriurumapü año, chiyasuriurupümañü ito. Arrti naqui chiyasuriurupüñü, chiyasuriurutipito naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Auqui basücübücoma tato manuma setenta. Iñataimia tato esati Jesús. Tarucu nipucünuncurrüma. Namatü: —Señor, hasta machoboreca macoconaunrrüma suiñemo, arrtü supacüpuca ümoma au nüri. ");
INSERT INTO caxNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nanti Jesús ümoma: —Ñemanauntu arrüñü yasacatü isiuti choborese paquioti auqui napese tacanarrtü masünaca. ");
INSERT INTO caxNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Torrio sobi aume abüriacabo nauqui puerurrü apicümone onü noirroboca y onü nupataca, y nauqui apacana ümoti choborese. Champü causane uiti aume. ");
INSERT INTO caxNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero tapü tarucapae naupucünuncu ui na ñacoconauncurrti choborese aume. Aupucünu manrrü ui arrüna ane corobo nabüri au napese. ");
INSERT INTO caxNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Au manu rratorrü tarucu nipucünuncurrti Jesús uiti Espíritu Santo. Nanti sane: —Iñanauncü Iyaü, itopiqui ane nüriaca au napese y icu na cürrü. Arrüna nüriaca ananca anecana obi, pero caüma aitusiancata isucarü bama chitonempümantai. Tapü ümo bama tarucu nitusiquirri ümoma y bama ipiacamampae au ñaquioncorrüma aiñanecata. Sane te Iyaü, aiñata isiu narrianca. ");
INSERT INTO caxNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","‛Arrti Iyaü itorrimiatati nanaiña iñemo arrüba omirriante uiti. Arrüñü Aütorrti. Champüti manrrü isuputarañü, cunauntaiñati Iyaü. Champütito naqui isuputaratiti Iyaü, cunauntaiñañüantai, arrüñü Aütorrti. Y arrüñü itusiancacati ümo bama irranca, nauqui aisuputaramatito. ");
INSERT INTO caxNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Auquimanu asaratitü ümo bama ñanunecasarrti. Nanti ümoma: —Urriampae nabaca, itopiqui amarrtai arrüna isamute. ");
INSERT INTO caxNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Itopiqui sucanañü aume, sürümanama bama profetarrü y bama mayüriabuca tücañe rranrrüma asaraimiapü arrüna amarrtai caüma, pero charrtaipüma. Rranrrüma ito oncoimiapü arrüna amoncoi sobi, pero choncoipüma. ");
INSERT INTO caxNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tamanti manunecana nüriacarrü sürotitü esati Jesús nauqui aiñanti macocotorrü ümoti. Ñanquitioti pünanaquiti: —Maestro, ¿causane sobi nauqui aye sobi taha au napese auna cauta champü nitacüru nisüboriqui? ");
INSERT INTO caxNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Arrti Jesús iñumutati: —¿Ura sane arrüna corobo nüriacarrü? ¿Isane arrüna lehebocü? ");
INSERT INTO caxNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nanti maniqui ñoñünrrü: —Nantü sane: Tari cuasürüti aemo Señor, naqui Tuparrü, aübu nanaiña nausasü, aübu nanaiña nausüpü, aübu nanaiña nacusüu y aübu nanaiña naquionco, y tari cuasürütito aemo asüborisapa tacana arrüna nacua aemoantoe. ");
INSERT INTO caxNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Auqui nanti Jesús ümoti: —Tusio nurria aemo. Arrtü aisamute arrüna sane, iyebo obi auna cauta champü nitacüru nasüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tapü arrti maniqui maestro rranrrti acanati ui ñanitacarrti. Nanti ümoti Jesús: —¿Ñacutipü naqui isüborisapa, naqui tiene que acuasürüti iñemo? ");
INSERT INTO caxNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Auqui urapoiti Jesús arrüna sane isucarüti: —Tamanti ñoñünrrü sürotitü auqui Jerusalén au Jericó. Isiu cutubiurrü enoti ui bama macusüpüca. Iquiaübutama pünanaquiti nanaiña arrüna ane uiti, hasta naibirrti sürotü uimia. Ipubairomati. Auqui besüburuma. Onconoti uimia simia niconcorrti. ");
INSERT INTO caxNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Rrepenteatai cuati taman sacerdoterrü isiuqui manu cutubiurrü. Asaratitü ümoti maniqui ñoñünrrü acü. Champü nümoche uiti. Pasaotiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tücoboi pario niyücürrti, pasaotito auquimanu taman ñoñünrrü levitarrü. (Arrübama levitarrü ayuranterrüma au niporrti Tuparrü.) Asaratitü ümoti maniqui ñoñünrrü acü. Pasaotito. ");
INSERT INTO caxNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Auqui cuati taman ñoñünrrü samaritanorrü isiuqui manu cutubiurrü. (Arrübama samaritanorrü chücuasürüpüma ümo bama israelitarrü.) Nauquiche asaratitü ümoti maniqui ñoñünrrü acü, pucürusuti itacuti. ");
INSERT INTO caxNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sürotitü esati. Acurati ümo manio nobüriturrü ümoti ui nasaite y vinorrü. Aicümurriancati manio obürio. Auqui aiquiamperotiti chacu niyaburrti bururrü. Aürotitü aübuti auna cauta ane alojamientorrü. Acamanu bacuirarati itacuti. ");
INSERT INTO caxNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Au manu quiatarrü nanenese tirranrrti aürotitü maniqui samaritanorrü. Bapacarati torrü monedarrü ümoti maniqui esache alojamientorrü, y nanti ümoti: “Acuira itacuti naqui ñoñünrrü. Arrtü bacarrtarati manrrü apünanaquicü, rrapacaca aemo, arrtü yapasaca tato auquina”. ");
INSERT INTO caxNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Auqui ñanquitioti Jesús pünanaquiti maniqui maestro: —¿Ñacuti eanaqui manuma trerrü isamutenti urria ümoti manqui obürio ümoti, tacana ümoti ñemanauncurratoe isüborisapatarrti? ");
INSERT INTO caxNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nanti: —Arrti maniqui pucürusu itacuti. Auqui nanti Jesús ümoti: —Acosi aisamune isiu. ");
INSERT INTO caxNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sürotitito Jesús. Iñataiti au manio poca. Acamanu ane taman paürrü nürirri Martarrü. Yasuriuruti au niporrü. ");
INSERT INTO caxNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ane ito naruquirri, nürirri Mariarrü. Arrüna Mariarrü tümonso esati Jesús, nauqui onsaperio ñanunecacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tapü Martarrü ananca aübu tarucapae yachücoi au porrü. Auqui sürotü esati Jesús, nantü ümoti: —Señor, ¿champü nümoche obi na tamañü rratrabacaca? Aicüpu na nisaruqui, nauqui ayura iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero arrti Jesús iñumutati nurarrü, nanti ümo: —Marta, Marta, arrücü tarucapae penarrü obi iyo arrüna ausüratia nachücoi. ");
INSERT INTO caxNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero sucanañü aemo, ane arrüna manrrü urria bachücoboibo: oñonsaperio nurarrti Tuparrü. Arrüna Mariarrü naruqui iyebo uirri arrüna manrrü urria, champüti puerurrü aiquiaübu pünanaqui. ");
INSERT INTO caxNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Taman nanenese anancati Jesús meaboti. Chauqui neancarrti, tamanti eanaqui bama ñanunecasarrti nanti ümoti: —Señor, aiñununecasa somü nauqui sopipia sopean. Arrtito Juan Bautista manunecanati tücañe ümo bama ñanunecasarrti nauqui aipiama eama. ");
INSERT INTO caxNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Arrti Jesús nanti ümoma: —Arrtü apeanca, amucanaño sane: Suiyaü, aca au napese. Tari anaunrrü nüri. Üriabusü suiñemo. Tari urrianena isiu narrianca auna acü, tacana au napese. ");
INSERT INTO caxNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ache sumutuburibo naneneca. ");
INSERT INTO caxNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Airrimiaca tato nomünantü soboi, tacana arrüsomü sopirrimiacata ümo bama churriampü uimia suiñemo. Tapü acheca suiñemo macocotorrü. Acuira suichacu ñünana nomüantü. ");
INSERT INTO caxNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Auqui nantito Jesús ümoma: —Supi arrtü anatipü taman abuturuqui anati nesarrti amigorrü. Cümuinta tobirri sürotitü au niporrti, nanti ümoti: “Saruqui, aprerrta iñemo trerrü cuñapeca, ");
INSERT INTO caxNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","itopiqui iñataiti taman yobo taha au nipo auqui nesarrti viajerrü. Champü isane sobi nauqui yasaparati”. ");
INSERT INTO caxNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y arrti maniqui anatipo iñumutati sane: “Tapü asiquia isuatañü. Charrtaipü tururrü amana y arrübama isaü namanaiña aboma rrupeuñü. Chüpuerurrüpü rratürai yaprerrta aemo. ");
INSERT INTO caxNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Auqui nanti Jesús ümo bama ñanunecasarrti: —Chirranrrtipü atüraiti nauqui acheti ümoti arrüna manquioti pünanaquiti. Pero au nitacürurrü atüraiti. Isamutenti sane, champürrtü ui na amigorrti ümoti, ta nauqui tapü asioti icuatati. ");
INSERT INTO caxNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sane nauquiche sucanañü aume: Apanqui pünanaquiti Bae Tuparrü, y arrti bacheboti aume. Apapache, auqui tabüco aboi. Apiyotobai tururrü, auqui aurübo aume. ");
INSERT INTO caxNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Itopiqui arrti naqui manquio, torrio ümoti. Arrti naqui bapachero, tabüco uiti. Arrti naqui iyotobaita tururrü aurübo ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Arraño mañoñünca ¿aensapü apacheca canrrü ümoti aubaü, arrtü manquioti pan? Arrtü manquioti amopünanaqui nopiocorrü ¿aensapü apacheca ümoti noirroborrü? ");
INSERT INTO caxNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Arrtü manquioti naübosi curasürrü ¿aensapü apacheca ümoti nupatarrü? ");
INSERT INTO caxNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Arraño malorrü te año, abu ta apipiaca apache arrüna urria ümo bama aubaütaiqui. Pero manrrtiatai Aubaü naqui anati au napese ipiacati acheti aume arrüna urria. Icüpurutiti Espíritu Santo au nausasü bama manquioma. ");
INSERT INTO caxNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Arrti Jesús anancati bacüpuruti ümoti choborese auquiti taman ñoñünrrü, naqui chüpuerurrüpü anitati uiti. Nauquiche tüsürotitü auquiti, auqui caüma puerurrti tato anitati. Cütobüso genterrü ui arrüna sane isamutenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero aboma ito bama namatü: —Arrti naqui Jesús bacüpuruti ümo bama machoboreca au nürirrti Beelzebú (Satanás), naqui üriatu bama machoboreca. ");
INSERT INTO caxNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Maquiataca bacheboma macocotorrü ümoti Jesús. Manquioma pünanaquiti taman señarrü auqui napese. ");
INSERT INTO caxNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero arrti Jesús tütusiatai ümoti arrüna ñapensacarrüma. Iñatati machepecatarrü ümoma, nanti: —Supi arrtü ane taman nación, y arrübama mayüriabuca bahiyoma ümomantoe. Contoatai iñarrio manu nación. Sane ito arrtü tüboricomantai ümomantoe bama pohoso au taman porrü, iñario ito manu familiarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sane ito arrti Satanás arrtü bahiyoti ümotiatoe, chüpuerurrüpü urura nüriacarrti. Sucanañü arrüna sane, itopiqui arraño amucanaño iñemo, que rracüpuca ümo bama machoboreca au nürirrti Satanás. ");
INSERT INTO caxNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Arrtü ñemanauntupü rratrabacaca aübuti Satanás, ¿carü arrübama apanuecasa, quitipü naqui üriacache arrüna uiche puerurrüma acüpuma tanene ümo machoboreca? Uramapü sane ümo arrüna sane napanitaca iñemo? ");
INSERT INTO caxNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero ñemanauntu, arrüñü rracüpuca ümo machoboreca ui nüriacarrti Tuparrü. Ui arrüna sane chauqui tütusio aume que türiabucati Tuparrü abarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‛Suraboira ausucarü arrüna quiatarrü machepecatarrü: Supi arrtü anati taman ñoñünrrü bien cusüuruti y ane nanaiña nicomerrti uiche ocümati itacu nenarrirrti, arrüna ane ahüburu uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero arrtü cuati naqui manrrü cusüuruti pünanaquiti, y macananati ümoti, auqui caüma iquiaübutati pünanaquiti nanaiña arrüna nicomerrti, arrüna ümoche oncotitü. ");
INSERT INTO caxNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Itopiqui arrti naqui chocümanapü ichacuñü, tüboricotiatai iñemo. Arrti naqui chübatasurupü ümo macrirrtianuca isiuñü, iñarrimiacatati arrüna omirria. ");
INSERT INTO caxNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‛Arrtü sürotitü choborese auquiti taman ñoñünrrü, sürotitü tanu, amencotiatai. Bapacheroti auna cauta acansati. Arrtü champü tabüco uiti, aquionotiyü auna cauta anancati tücañe. Auqui nanti ümotiatoe: “Yeca tato au nipo, auna cauta anancañü tücañe”. ");
INSERT INTO caxNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Arrtü iñataiti tato, icuñunutiti maniqui ñoñünrrü tacana arrone porrü sunucunu auquipo, bien coñocono. ");
INSERT INTO caxNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Auquimanu sürotitü acanti ümo bama siete maquiataca machoboreca uüboti manrrü. Manrrü ünantatai nacarrüma pünanaquiti. Süromatü avivimia auti maniqui ñoñünrrü. Arrti maniqui ñoñünrrü caüma manrrü ünantatai nisüboriquirrti pünanaqui tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Arrti Jesús manitanatiqui arrüna sane. Auqui taman paürrü eana manu genterrü tosibico, nantü: —¡Urriampae naca manu paürrü arrüna uiche aca icu cürrü, arrüna uiche aisunauncunü! ");
INSERT INTO caxNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero arrti Jesús nanti ümo: —Pero manrrü urriampae naca bama oncoi nurarrti Tuparrü y isamutema isiu. ");
INSERT INTO caxNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iyoberabaramanquicü macrirrtianuca itupecuti Jesús. Auqui manitanati ümoma, nanti sane: —Caüma arrüna tiemporrü arrüna genterrü bien malorrü. Manquio taman señarrü auqui napese. Pero chütorriopü ümo, cunauntaiñantai manu señarrü apüti profetarrü Jonás tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ta arrti Jonás señarrti tücañe ümo bama pohoso au manu pueblurrü Nínive. Arrüñü Ñemanauncurratoe Ñoñünrrü isiatai señarrüñü ümo bama macrirrtianuca arrüna tiemporrü caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Arrümanu ito paürrü nüriaburrü auqui tauna ümo mancarrü atüraiyo ñana au manu nanenese nesa bacurrtacarrü. Uirri urapoi nipünate genterrü nesa arrüna tiemporrü caüma, itopiqui tone cuatü tücañe auqui iche nauqui onsaperio ñanunecacarrti Salomón, naqui yüriaburrü. Pero arraño caüma chaurriancapü apicocoroñü, abu arrüñü manrrü nisüriaca pünanaquiti Salomón. ");
INSERT INTO caxNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Au manu nanenese nesa bacurrtacarrü ñana arrümanuma mañoñünca auqui manu pueblurrü Nínive atüraiyoma. Uimia urapoimia nipünate genterrü nesa na timporrü caüma. Itopiqui arrüma tücañe iñorronconomacü, numo anancati Jonás manunecanati ümoma, tapü asioma aübu arrüna churriampü nisüboriquirrimia. Arraño caüma chaurriancapü apicocoroñü, abu arrüñü manrrü nisüriaca pünanaquiti Jonás. ");
INSERT INTO caxNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Champürrtü uiñonocota basarurrü nauqui uiñaneca, o nauqui uitamurriquia, ta nauqui uiña ape, nauqui acuapo ümo bama cuamatüpo. ");
INSERT INTO caxNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Arrüna nosüto tacana basarurrü ümo nocütüpü. Arrtü omirriantai nosüto, ta nanaiña nocütüpü ane au nanentarrü. Pero arrtü chomirriampü nosüto, usaca tacana au tomiquianene. ");
INSERT INTO caxNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Arrüna nirranunecaca tacana basarurrü. Apacuira nurria itacu, tapü ensoro amopünanaqui, itopiqui arrtü ensoro, ta abaca au tomiquianene. ");
INSERT INTO caxNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Arrtü iyebo aboi nirranunecaca, abaca tacana au nanentacarrü. Auqui caüma amarrtai nanaiña arrüba omirria, tacanarrtü cuara aume ui basarurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chauqui ñanitacarrti Jesús, tamanti fariseorrü itasurutiti au niporrti, nauqui aati. Sürotitü Jesús. Aiñanainti au niporrti. Besüro uiti esa mensarrü. Atümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Arrti maniqui fariseorrü cütobüsoti ui arrüna sane arrtaiti, itopiqui champürrtü icocotati Jesús arrüna bacüpucurrü uimia, nauqui entunumiti antes que aati. ");
INSERT INTO caxNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero arrti Señor nanti ümoti: —Arraño bama fariseorrü apiyarrübita nurria basoca y pratuca, tapü arrüba napapensaca au nautusi omünantatai, naurrianca apacusüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Sonsorraño! ¿Taqui chütusiopü aume que arrti naqui isamutenti nocütüpü isamutentito nuyausasü? ");
INSERT INTO caxNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Arraño apacumanaca ümo bama pobrerrü. Mejor apiquiaübu arrüba nomünantü auqui nabausasü. Sane nauqui querabo urriantai nausüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‛Autaquisürücatai arraño bama fariseorrü. Apacheca ümoti Tuparrü taman uturuqui diez nasu menta y ruda y nasu nanaiña piquiataca plantamanca, arrüba umate. Pero champü nümoche aboi arrüna ñemanauncurratoe bacurrtacarrü aübu genterrü. Chücuasürütipü Tuparrü aume. Tonempü tiene que apisamute primero. Auqui caüma puerurrü ito apisamune isiu manio piquiataca bacüpucuca. ");
INSERT INTO caxNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‛Autaquisürücatai arraño bama fariseorrü, itopiqui aurrianca autümo icu ba tümoca ümo nisurratoe au ba poca sinagoga. Aurrianca ito nauqui namanaiña rrespetaboma aume, y anquimia nurria aume isiu cayaca. ");
INSERT INTO caxNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‛Autaquisürücatai, itopiqui arraño tacana nicü bama coiño, y arrübama macrirrtianuca pasaoma onüqui y chütusiopü ümoma que tone. ");
INSERT INTO caxNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Auqui arrti maniqui taman maestro ümo nüriacarrü nanti ümoti Jesús: —Maestro, ui arrüna sane nura canapae anitaca suiñemo ito churriampü. ");
INSERT INTO caxNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Auqui arrti Jesús nanti ümoti: —Autaquisürücataito arraño bama manunecana nüriacarrü. Itopiqui apacüpuca nauqui aisamunema bama macrirrtianuca isiu napacüpucu fuerte nurria, abu arraño chapicocoquiompü pario. ");
INSERT INTO caxNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Autaquisürücatai arraño, itopiqui na apicoñocota nicürrüma bama profetarrü tücañe, itopiqui coiñoma tücañe ui bama antiburrü aubaütaiqui. ");
INSERT INTO caxNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ui arrüna sane tacanarrtü tütusio que arraño urriantai aume arrüna isamutema bama antiburrü. Arrüma batabaiyoma ümo bama profetarrü, y arraño apicoñocotama nicürrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‛Sane nauquiche arrti Tuparrü au ñapensacarrti nanti sane: “Rracüpura ümo bama profetarrü y ümo bama apostolerrü aume, pero uturuquimia, arraño apitabaiquiama, y abaca ito isiu bama sobürau ui nautübori ümoma”. ");
INSERT INTO caxNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sane nauquiche caüma arrti Tuparrü ñanquitioti amopünanaqui noto bama taborioma tücañe auqui numo maübo urriane na cürrü, ");
INSERT INTO caxNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","auqui niconcorrti Abel hasta niconcorrti Zacarías, naqui taborioti esa altar au niporrti Tuparrü. Suraboira nurria: Arrti Bae Tuparrü ñanquitioti noto bama taborioma tücañe pünanaqui na genterrü arrüna tiemporrü caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‛Autaquisürücatai arraño bama manunecana nüriacarrü. Arraño chaurriancapü amoncoi nisura. Arrtü aurriancapü, puerurrü aye aboi esati Tuparrü. Pero chichebopito aboi nauqui aye ui bama maquiataca, tacanarrtü apiquiaübuta niyabe nituru napese. ");
INSERT INTO caxNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nauquiche nanti Jesús arrüna sane, arrübama manunecana nüriacarrü y arrübama fariseorrü tüboricoma nurria ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Auqui caüma tarucapae yapariquirrimia aübuti, nirrancarrüma nauqui anitati uimia arrüna churriampü, nauqui puerurrü urabomati. ");
INSERT INTO caxNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Auna cauta anancati Jesús iñataimia sürümanama macrirrtianuca, hasta que isimianamacü uirrimiantoe. Auqui arrti Jesús manitanati primero ümo bama ñanunecasarrti, nanti ümoma sane: —Amasasai nurria ñünana ñanunecacarrüma bama fariseorrü y ñünana ñapanturrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Itopiqui champü arrüna anecana ñana; nanaiña tiene que atusi. ");
INSERT INTO caxNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Arrüna anecanatai amucanaño, nanaiña caüma tusiatai tanu. ");
INSERT INTO caxNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‛Sucanañü ito aume bama amigorrü —nanti Jesús—, tapü aupirruca ñünana bama itabaitama arrüna cürrü nocütüpü, pero champü manrrü causane uimia oemo, chüpuerurrüpü aitabaimia nuyausüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero suraboira ausucarü ñünanache tiene que aupirru: Ta ñünanati Tuparrü, naqui puerurrü aiquiaübuti nosüboriqui, y ane ito nüriacarrti nauqui aipenenoti oñü au infierno. Ñünanati te tiene que uirru. ");
INSERT INTO caxNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‛Mapaventecaca cinco nutaumanca itobo torratai monedarrü, pero ta chütacürusupü ñaquioncorrti Bae Tuparrü yubapa. ");
INSERT INTO caxNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sane ito arraño, hasta niqui nautanu mupacümuncunu uiti Bae Tuparrü taiquiana taman. Sane nauquiche tapü aupirruca. Arraño manrrü aucuasürüca ümoti pünanaqui sürümana nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‛Arrüñü Ñemanauncurratoe Ñoñünrrüñü. Arrübama urapoi isucarü genterrü que icocoromañü, arrüñü ito surapoi isucarü bama angelerrü esati Tuparrü que tonema nirranunecasa. ");
INSERT INTO caxNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tapü arrti naqui mapaña isucarü genterrü que chisuputaratipüñü, arrüñü ito surapoi ñana isucarü bama angelerrü esati Tuparrü que chütonentipü nirranunecasa. ");
INSERT INTO caxNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‛Arrti naqui manitana churriampü iñemo, puerurrü arrimiaca tato nomünantü uiti, arrtü iñorronconotiyü. Tapü arrti naqui manitanati churriampü ümoti Espíritu Santo chüpuerurrüpü ane marrimiacatarrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‛Arrtü iquianama año au ba poca sinagoga, o esa bama mayüriabuca, nauqui acurrtama abaübu, tapü apapensaca iyo arrüna causane nauqui apanita autacuatoe. ");
INSERT INTO caxNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Itopiqui arrti Espíritu Santo bacheboti aume apanitacabo isucarüma au manu horarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tamanti eanaqui manu genterrü nanti ümoti Jesús: —Maestro, ucanü ümoti saruqui, tari itorrimianati iñemo arrüna tocabo iñemo eanaqui nenarrirrti suiyaü, naqui coiño. ");
INSERT INTO caxNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Auqui aiñumuti Jesús, nanti: —Arraño aurrianca apiñanañü tacanati yüriaburrü, nauqui chepesüro sobi namenarri, abu chümopü isetü icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nantito ümoma: —Amasasai nurria ñünana arrüna naurrianca iyo nenarriquia. Arrüna urria nosüboriqui champürrtü ane oboi ba ausüratai noñenarri. ");
INSERT INTO caxNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Auqui urapoiti isucarüma arrüna sane: —Anati taman ñoñünrrü rricurrti. Ane chama niyorrti y iyebo nurria ümoti arrüna süro cütu uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Auqui mapensarati: “¿Causane sobi caüma? Champü cauta iñahübu arrüna niyesa cosecharrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Auqui mapensarati nurria: “Chauqui tütusio iñemo causane sobi —nanti—. Iñarrimiacana nanaiña arrrüba nisüru y poca cauta ahübu. Isamunena manrrü sürümanarrü. Acamanu caüma iñahübuta nanaiña niyesa cosecharrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Auqui caüma sucanañü iñemoantoe: “Ane nanaiña iñemo. Ane ahüburu ñome sürümana añoca. Ñacansara, irrara, ichara y ñasamune ito pierrta”. ");
INSERT INTO caxNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Auqui arrti Tuparrü nanti ümoti: “Tarucu nasonsoco, ñoñünrrü, itopiqui caüma na tobirri aconca, y arrüna ane ahüburu obi, ¿quitipü ümoche caüma?” ");
INSERT INTO caxNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sane pasabo ümoti naqui amontonabo uiti enarriboti, pero au narrtarrti Tuparrü pobrerrtiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Auqui nanti Jesús ümo bama ñanunecasarrti: —Sucanañü aume, tapü ane nümocheapae aboi arrüna amutuburibo y abaibibo. ");
INSERT INTO caxNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Arrüna nosüboriqui manrrü valeo pünanaqui arrüna uñutuburibo. Arrüna nocütüpü manrrü valeo pünanaqui nusahibi. ");
INSERT INTO caxNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Amasasai arrüba norrürüca nirri turrü. Champürrtü pancüturu, ni cosechabohiompü, ni anempü cauta apahübu. Pero arrti Tuparrü bacheboti ñome umutuburibo. Arraño manrrü te aucuasürüca pünanaqui nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Taqui puerurrü ausunaun pario ui arrüna tarucapae penarrü aboi iyo nausüboriqui? No, chüpuerurrüpü, ni medio metro ausunaunca uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Así que tütusio aume que chüpuerurrüpü apisamune arrüna chimiantai. Sane nauquiche tapü ane penarrü aboi iyo piquiataca manrrü chama. ");
INSERT INTO caxNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‛Amasasai causane niñusunaun püsioca. Champürrtü patrabacara, ni apaiñapü. Sucanañü aume: Arrti yüriaburrü Salomón tücañe chama nenarrirrti, pero ni anempü naibirrti tacana nubaibiqui manio püsioca coñorrtai. ");
INSERT INTO caxNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Arrti Tuparrü bacheboti iyusubu ba narrüchopüro coñorrtai, arrüba abe eana rroense caüma, y tubaca botüsüro, sürobo au horno nauqui amoho. Pero manrrü te bacheboti abaibibo, arraño bama chamoncapütü nurria ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sane nauquiche tapü tarucapae napapensaca iyo arrüna amutuburibo y arrüna nauqui aucha. ");
INSERT INTO caxNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Itopiqui arrüna genterrü icu na cürrü toneantai ñapensacarrü. Pero arraño chauqui tanati taman naqui Aubaü au napese. Tütusiatai ümoti arrüna naurriantümo. ");
INSERT INTO caxNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Apiña nurria, nauqui apicoco nüriacarrti Tuparrü. Auqui caüma torrio aume nanaiña arrüna naurriantümo. ");
INSERT INTO caxNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‛Tapü aupirruca bama mümanamantai nirranunecasa. Arrti Tuparrü rranrrtiatai nauqui ane nabüriaca ñana ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Apipiaventeca arrüna ane aboi. Apacumana ümo bama champü isane ümoma. Auqui caüma ane quiatarrü naca namenarri au napese auna cauta chiñataitipü cusüpürrü, ni aiñanaipü nirrirri, nauqui aiñamesoco. ");
INSERT INTO caxNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Itopiqui arrüna cauta ane namenarri, tone arrüna ümoche napapensaca. ");
INSERT INTO caxNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Urapoitito Jesús arrüna machepecatarrü: —Aucobori ümo trabacorrü aübu naubasaru omo. ");
INSERT INTO caxNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Apisamuse tacana bama mamosoca barrüperarama cümenuti Señor, arrtü cuati tato, nauqui aiyaübuma tururrü cümenuti, arrtü tiñataiti tato auqui pierrta tübübürrü, y iyotobaitati tururrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Urriampae naca bama mosorrü tabüro tüchauqui nicoborirrimia, arrtü tiñataiti tato naqui Señor. Ñemanauncurratoe, uiti Señor caüma tümonsoma esa mensarrü, y arrti campiabo naibirrti nauqui aserebiti ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Rrepente iñataiti cümuinta tobirri, o cuatü nanenese. Urriampae nacarrüma bama mosorrü, itopiqui tüchauqui nicoborirrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","‛Amonsoi arrüna quiatarrü machepecatarrü: Arrtü tusiopü ümoti naqui ipoche isane horarrü iñataiti cusüpürrü, chüpuerurrüpü anuti, nauqui tapü cusüpüoti auqui niporrti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sane ito arraño tiene que aparrüpera isumenuñü, itopiqui arrüñü Ñemanauncurratoe Ñoñünrrü cualquier horarrü iseca tato ñana, y arraño chütusiopü aume. Autabücatai. ");
INSERT INTO caxNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Auqui arrti Pedro ñanquitioti pünanaquiti Jesús: —¿Señor, aiñata suiñemoatai arrüna machepecatarrü, o ümo namanaiña? ");
INSERT INTO caxNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aiñumuti Señor ui quiatarrü machepecatarrü: —Arrti taman patrón sürotitü auqui niporrti. Onconoti taman mosorrü uiti, naqui oncotitü nurria ümoti, nauqui acheti tuburibo bama maquiataca mamosoca naneneca. ");
INSERT INTO caxNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Urriampae nacarrti naqui mosorrü, arrtü nanaiña icocotati arrüna yacüpucurrti patrón ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sucanañü aume: Arrti maniqui patrón iñanatiti nauqui asaratitü itacu nanaiña nenarrirrti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero supi arrtü mapensarati maniqui mosorrü que chücontopü aiñanainti tato patrón, auqui caüma bacheboti chacu bama maquiataca mamosoca y ümo ba cumanacaca. Y arrti caüma basoti bien, chaboti y osisübaboti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Auqui arrti patrón iñataiti tato au manu nanenese, y arrti maniqui mosorrü tabücotiatai uiti. Auqui caüma bacheboti patrón tarucapae carrticurrü ümoti, iñanatiti ichepe bama chümacoconaunrrüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‛Arrti naqui mosorrü tusio nurria ümoti yacüpucurrti Señor, pero ta champürrtü icocotati ni aisamunentipü, tonenti naqui carrticaboti nurria uiti Señor. ");
INSERT INTO caxNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tapü arrti naqui mosorrü chütusiopü ümoti arrüna yacüpucurrti Señor, y isamutenti arrüna churriampü, tonenti carrticaboti pariatai. Ta arrti naqui torrio ümoti chama ipiacaboti uiti Tuparrü, chama ito manquioti pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nantito Jesús: —Isecatü auqui napese nauqui iñaunrrimia pese. Tirrancatai yasarai nonco manu pese. (Arrüna pese tone arrtü coiñoti Jesús, y arrtü aboma bama icocoromati au nanaiñantai.) ");
INSERT INTO caxNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero antes que urriane sobi nanaiña, tiene que ayetü iñemo tarucapae taquisürücürrü, cheperrtü cocono sobi nanaiña. ");
INSERT INTO caxNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Arraño napaquionco isetü nauqui urria nacarrüma bama macrirrtianuca aübumantoe, abu chüsanempü. Ta isecatü nauqui sobi ane bahiquirri icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Itopiqui auqui caüma uratoquioma eana familiarrü auqui niyaca. Arrtü aboma cinco au taman porrü, trerrüma aboma tüboricoma ümo bama torrüma y bama torrüma ümo bama trerrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Arrti yaürrü tüboricoti ümoti yaütoti. Arrti ñoñünrrü toboricoti ümoti aütorrti. Taman paürrü tüborico ümo nichechese, y cupiquirri tüborico ümo nipiaparrü. Ane paürrü tüborico ümo nicupiquiturrü, y ane cupiquirri tüborico ümo nipiaparrtorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nantito Jesús ümo genterrü: —Au na cürrü arrtü amasaquio cuantio cüsaüboca tape auqui nimümürrü, amucanaño: “Rrobeoca caüma”, y sane cocono. ");
INSERT INTO caxNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y arrtü bausücüro auqui mancarrü amucanaño: “Peco caüma”, y sane cocono. ");
INSERT INTO caxNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Arraño mañapanca. Amarrtai napese sane, tusio aume uirri arrtü rranrrü arrobeo o arrtü peco. ¿Causane chamarrtaipito isane ümoche arrüna pasabo arrüna tiemporrü caüma ausucarü? ");
INSERT INTO caxNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‛¿Causane chütusiopü aume aboiyapatoe isane arrüna urria, nauqui apisamune? ");
INSERT INTO caxNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Suraboira quiatarrü machepecatarrü ausucarü: Supi arrtü anati naqui masamunuti chürüri aemo. Rranrrti aiquianatiyü esati Yüriaburrü na urabotiyü. Aiña nurria, aiñarrimiaca tato aübuti isiu cutubiurrü antes que aiñanai esati Yüriaburrü. Itopiqui arrtü aiñatai uiti esati, arrti caüma itorrimianatiyü mecuti policiarü, y uiti caüma aecatü au preso. ");
INSERT INTO caxNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sucanañü aemo, chüpuerurrüpü ataesübu auqui preso, cheperrtü apacaca nanaiña nebequi. ");
INSERT INTO caxNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Au manio nananeca iñataimia esati Jesús mañoñünca. Uraboimia isucarüti causane uiti yüriaburrü Pilato ümo manuma mañoñünca auqui manu cürrü Galilea. Ta taborioma uiti, numo macumananama numuquianca ümoti Tuparrü au niporrti Tuparrü. Arapara notorrüma ichepe nomoto manio numuquianca. ");
INSERT INTO caxNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Arrti Jesús nanti ümoma: —Arraño napaquionco que pasao sane ümo bama auqui Galilea, itopiqui arrüma ane manrrü nomünantü uimia pünanaqui bama maquiataca pohoso taha. ");
INSERT INTO caxNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero sucanañü aume, arraño arrtü chapiñorroncocañopü, pasao aume isiatai tacana ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Amoncoi ito nüri manuma dieciocho mañoñünca, coiñoma nauquiche taübüco onüma manu torerrü au Siloé saimia Jerusalén. Napaquionco caüma pasao ümoma sane, itopiqui ane manrrü nomünantü uimia pünanaqui bama maquiataca pohoso au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero sucanañü aume, arraño arrtü chapiñorroncocañopü, pasao aume isiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Urapoitito Jesús isucarüma arrüna machepecatarrü: —Tamanti ñoñünrrü mancüturuti taman suese higuera au niyorrti. Numo tüsunaun, sürotitü asaraiti, arrtü ütau. Pero champü nütarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Auqui nanti ümoti maniqui bacuirara itacu niyorrti: “Tabe trerrü añoca nisequi yapache nüta na suese, pero ta champü. Aitüsüna, itopiqui champü nümoche ane auna”. ");
INSERT INTO caxNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Auqui nanti maniqui bacuirara itacu ñanaunrrü: “Señor, asio sane na suese arrünainqui añorrü. Icüncana cürrü y yachera naha bacarrü itupecu. ");
INSERT INTO caxNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Auqui caüma rrepente ütao. Perorrtü champü, auqui caüma tüsüro”. ");
INSERT INTO caxNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Taman nanenese nesa macansacarrü anancati Jesús manunecanati au taman porrü sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Acamanu ananca manu paürrü tütabe dieciocho añorrü ñaunrrococorrü uiti choborese. Poboro, chüpuerurrüpü aipesünacanü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nauquiche asaratitü Jesús ümo manu paürrü, itasutati y nanti ümo: —Rracurara aemo, paürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Auqui iñatati neherrti onü. Auquimanu urriante tato manu paürrü, y puerurrü abesü tato. Auqui iñanaunuti Tuparrü, machampiencana ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero arrti maniqui yüriaburrü au manu sinagoga tüboricoti, itopiqui bacurarati Jesús au manu nanenese nesa macansacarrü. Nanti ümo genterrü: —Abe seirri naneneca nauqui batrabaca. Au manio naneneca puerurrü abetü nauqui curabo año. Pero au na nanenese nesa macansacarrü churriampü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Auqui nanti Señor ümoti: —¡Ñapanrrücü! ¿Aensapü chapisoquisünatapü naupabu buyese y naupabu bururrü au na nanenese nesa macansacarrü, nauqui amenotü apichamanio turrü? ");
INSERT INTO caxNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tapü arrüna paürrü auqui nesarrti familiarrü Abraham tütabe dieciocho añorrü nacarrü tacana tomoeno uiti choborese ui norrocorrü. Urriantai te isoquisüna au na nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ui arrüna nurarrti Jesús sane, namanaiña cüsoboma, bama tüborico ümoti. Pero arrüna genterrü pucünuña ui arrüna arrtaimia y ui arrüna isamutenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Manunecanati Jesús ümoma, nanti: —¿Tacanachepü naca arrünarrtü üriabucati Tuparrü oemo? ¿Aübuchepü ichepeca? ");
INSERT INTO caxNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ta tacana arrone niyo mortasa. Tamanti ñoñünrrü iñatati cütu au niyorrti. Auqui ubaüro, sunaun cheperrtü sürümanarrü suese. Cuantio nutaumanca pasumenunu apü nipiarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nantito Jesús: —¿Aübuchepü ichepeca arrünarrtü üriabucati Tuparrü oemo? ");
INSERT INTO caxNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ta tacana arrone levadura, arrüna süro eana tubarrirri ui taman paürrü, cheperrtü nanaiña manu masa tusabo uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Arrti Jesús niyücürrtiqui au Jerusalén. Pasaoti auqui manio puebluca y poca, ñanunecacarrti ümo bama pohoso, niyücürrti au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tamanti ñanquitioti pünanaquiti: —¿Señor, taqui mümanamantai bama taesüburuma eanaqui nomünantü? Iñumutati Jesús ui machepecatarrü apü tururrü: ");
INSERT INTO caxNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Tari apapasa auqui manu tururrü tunumusiña. Sürümanama bama rranrrüma aüromatü auqui, pero chüpuerurrüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","‛Arrti naqui ipoche atüraiti nauqui aiñamati ñana. Tapü arraño caüma abaca türüpo. Apiyotobaita tururrü, amucanaño: “Señor, aiyaübu naturu suiñemo”. Auqui iñumutati: “Chütusiopü iñemo auquiche año”. ");
INSERT INTO caxNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Auquimanu caüma amucanaño: “Amonco somü subaca aübucü y suichaca ito. Anunecaca suiñemo isiu cayaca au sobesa pueblurrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Auqui iñumutati tatito: “Chauqui tüsucanañü aume, chütusiopü iñemo auquiche año. Amecosi auquina yesaquiñü namanaiña bama apisamute nomünantü”. ");
INSERT INTO caxNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abareoca caüma. Botoquio namo ui arrüna amasacatü ümoti Abraham, ümoti Isaac, ümoti Jacob y ümo namanaiña bama profetarrü, aboma auna cauta üriabucati Tuparrü, tapü arraño taupeneca türüpo. ");
INSERT INTO caxNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Itopiqui cuamatü macrirrtianuca auqui maquiütürrü, y auqui mancarrü, auqui tansürü y auqui nimümürrü, nauqui atümoma aama auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sane arrübama chütonempatai au napaquionco, caüma cusürüboma ñana aye uimia esati Tuparrü. Tapü arrübama sürobotü au napese au napaquionco chiyebopü uimia. ");
INSERT INTO caxNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Arrümanu nanenese iñataimia manuma fariseorrü esati Jesús, namatü ümoti: —Acosi auquina, itopiqui arrti Herodes rranrrti aitabairotiyü. ");
INSERT INTO caxNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Arrti Jesús iñumutati nurarrüma: —Amecosi aburaboi isucarüti maniqui picarurrü arrüna sane nisura: Caüma y tubaca rracüpuca tanene ümo bama machoboreca y rracuraca ümo bama maunrrocono. Pürücü tubaca tacürusu nirracuraca. ");
INSERT INTO caxNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero yücatüqui, caüma y tubaca y pürücü tubaca, niyücü au Jerusalén. Itopiqui arrtü itabairomañü tiene que ison au Jerusalén, tacana ito bama maquiataca profetarrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‛¡Causanempito ui bama pohoso auqui Jerusalén! Ta uimia taborioma bama profetarrü tücañe y yaruruma oboi canca bama yacüpusurrti Tuparrü. Chaübopü nirranca oberabama sobi, tacana arrone curubasürrü oberabara uirri naübosirri iquiana nipiarrü, pero arrüma chirranrrüpüma. ");
INSERT INTO caxNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Arrüna niporrti Tuparrü au nesarrüma pueblurrü oncono caüma uiti Tuparrü. Auqui caüma chüpuerurrüpü asaramañünqui tato, cheperrtü tiñata manu nanenese auche ñana namatü iñemo: “Tari anaunuti naqui cuati au nürirrti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Au manu tücañe nanenese nesa macansacarrü arrti Jesús sürotitü aati au niporrti maniqui yüriaburrü fariseorrü. Arrübama maquiataca fariseorrü amoncoma barrüpiarama ümoti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Anancatito taman ñoñünrrü acamanu, naqui taquisürüti ui quichusarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Auqui arrti Jesús ñanquitioti pünanaqui bama manunecana nüriacarrü y pünanaqui bama fariseorrü, nanti: —¿Taqui urria bacura au na nanenese nesa macansacarrü, o champü? ");
INSERT INTO caxNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Arrüma etayoimia. Chiñumutapüma. Auquimanu arrti Jesús bacurarati ümoti maniqui maunrrocono. Urriancati tato. Masamunuti Jesús nariorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Auqui nanti ümo bama fariseorrü: —¿Causane aboi, arrtü paquio au cütubirri naupabu bururrü o naupabu buyese au na nenenese nesa macansacarrü? ¿Aensapü omoncono cütu? No, apiquiaübuquio tanene. ");
INSERT INTO caxNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tapü arrüma chütusiopü ümoma isane urapoboiboma. ");
INSERT INTO caxNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Arrtaitito Jesús arrüna niyachücoimia bama tasuru. Bapacheroma arrüba tümoca manrrü omirria esa mensarrü. Auqui arrti Jesús bacheboti consejorrü ümoma: ");
INSERT INTO caxNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Arrtü itasurumacü ümo pierrta, tapü apacheca arrüba tümoca manrrü omirria, itopiqui rrepente iñataiti naqui manrrü cuasürüti apünanaquicü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Auqui caüma arrti maniqui batasuru aürotitü aesacü, nauqui nanti aemo sane: “Atüsai, aitorrimia ümoti na tümorrü”. Arrücü caüma aübu nacüso aecatü atümo arrüna chüvaleopü tümorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Arrtü itasurumacü, acosi atümo au na nitacüru tümorrü. Auqui caüma cuati maniqui itasurü, nanti aemo: “Amigo, apasai atümo auna manrrü urria tümorrü”. Sane caüma manrrü ane nacua isucarü bama maquiataca aboma achepecü tümonsoma esa mensarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Itopiqui arrti naqui rranrrü yarusürürrü pünanaquiti quiatarrü, taquisürütiatai uiti Tuparrü. Tapü arrti naqui ichimiancanatiyü, tonenti ñana tarucu nüriacarrti uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nantito Jesús ümoti maniqui itasurutiti: —Arrtü arrianca asapa pemacarrü, tapü atasuca ümo bama naesa amigorrü ni ümo bama aruquitaiqui, ni ümopü bama apariante, ni ümopü bama aposapa bama rricurrü, itopiqui arrüma bapacarama tato ñana aemo itobo. ");
INSERT INTO caxNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Arrtü asamuca pierrta, atasu ümo bama pobrerrü, ümo bama renco, ümo bama chüpuerurrüpü amema y ümo bama supusu. ");
INSERT INTO caxNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Urriampae naca, arrtü aisamute sane. Tonema bama chüpuerurrüpü apaca tato aemo itobo, pero si ane nacua au napese itobo ñana, arrtü asüboriquia tato ichepe bama urria nisüboriquirrimia au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ui arrüna sane oncoimia, tamanti eanaqui manuma tümonso acamanu nanti ümoti Jesús: —Urriampae nacarrüma bama tasuru, nauqui aama auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Auqui urapoiti Jesús arrüna machepecatarrü: —Tamanti ñoñünrrü batasuruti ümo sürümanama macrirrtianuca nauqui aama nipemacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nauquiche tiñatai manu horarrü, icüpurutiti imostorrti nauqui atasuti. Nanti maniqui mosorrü ümoma: “Ausiapata auba, itopiqui tüchauqui pemacarrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Namanaiña chirranrrüpümainqui aüromatü. Tamanti nanti: “Aübatai rracompraca taman ñanaunrrü. Irranca yerotü yasarai. Tapü ünantü ümoti apatron”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Arrti maniqui quiatarrü nantito: “Rracompraca cinco buyeca. Irranca rracone yupu. Rranquiquia apünanaquicü, tapü ünantü aemo”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nantito quiatarrü: “Aübatai ipoca, sane nauquiche chüpuerurrüpü yero tanu”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nauquiche iñataiti tato maniqui mosorrü au porrü, urapoiti nanaiña arrüna sane isucarüti patrón. Auqui arrti maniqui patrón tüboricoti. Nanti tatito ümoti imostorrti: “Acosi isiu cayaca au pueblurrü, aiquiasama tauna bama pobrerrü, bama chamencopü, bama supuso”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nauquiche tisamuteti arrüna sane maniqui mosorrü, nanti ümoti patrón: “Señor, chauqui tisamute nanaiña arrüna nacüpucu iñemo. Pero canapae aninqui camporrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Auqui nanti tatito patrón ümoti aniqui imostorrti: “Acosi tatito isiu cutubiuca atasu ümoti cualquierarrü. Tari ñasamunuma nurria, tari yebamatü, nauqui ata nipo. ");
INSERT INTO caxNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tapü arrübama primero tasuru sobi ümo nipemaca chüpuerurrüpü aama”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sürümanama macrirrtianuca süromatü isiuti Jesús. Arrti pebücoti tato, nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Arrti naqui rranrrti ayeti isiuñü, tiene que isuasürü manrrü ümoti pünanaquiti yaütoti, nipiacütoti, nicüpostoti, aütorrti, yaruquitorrti y niquiasitorrti. Si no, chüpuerurrüpü nirranunecasati. Hasta nisüboriquirrtiatoe chüpuerurrüpito acuasürü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Arrti naqui chirranrrtipü ataquisürüti isiuquiñü, chüpuerurrüpü nirranunecasati. ");
INSERT INTO caxNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sane nauquiche urapoitito Jesús isucarüma arrüna machepecatarrü: —Supi arrtü anatipü taman abuturuqui rranrrti asamuti porrü. Primero mapensarati manucubu nicuarrü, na atusi ümoti arrtü iñatai nimonirrti. ");
INSERT INTO caxNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Arrtü chiñapensatiotipü nurria, isamutenti primero nitümorrü. Chauqui turriante uiti. Auqui tacürusu nimonirrti, chütacürusupü urriane uiti niporrti. Auqui caüma unumati bama macrirrtianuca, ");
INSERT INTO caxNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","namatü ümoti: “Arrti naqui ñoñünrrü rranrrtipü asamuti ipoboti, pero chüpuerurrüpü atacüru uiti”. ");
INSERT INTO caxNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sane ito ui taman yüriaburrü. ¿Aensapü chümapensaratipü primero, arrtü rranrrü ane bahiquirri aübuti quiatarrü yüriaburrü? Mapensarati te, arrtü rranrrti ahiti aübu bama diez mil nesarrti masortaboca ümoti maniqui quiatarrü, naqui cuati aübu bama veinte mil. ");
INSERT INTO caxNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Arrtü onquisioti que chüpuerurrtipü, tiene que acüputi manitacarrü ümoti maniqui quiatarrü yüriaburrü, nauqui airrimiacati tato aübuti, tapü ane bahiquirri aübuti. ");
INSERT INTO caxNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sane te arrübama chirranrrüpü aiñocoma nanaiña arrüna ane ümoma, chüpuerurrüpü nirranunecasama. ");
INSERT INTO caxNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‛Arrüna siürrü bien baserebio oemo. Pero arrtü chüsüroiquipü, chüpuerurrüpü asarebi tato oemo. ");
INSERT INTO caxNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chübaserebioiquipü ni ümopü ñanaunrrü. Mejor botabatai. Amonsoi te nisura, ümo ane namumasu. ");
INSERT INTO caxNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Namanaiña bama mayacobraca impuestorrü y bama ane nomünantü uimia süromatü esati Jesús, nauqui onsaperioma nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tapü arrübama fariseorrü y bama manunecana nüriacarrü ünantü ümoma, namatü: —Arrti naqui ñoñünrrü anati ichepe bama malorrü, y basoti aübuma. ");
INSERT INTO caxNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Auqui arrti Jesús urapoiti arrüna machepecatarrü isucarüma: ");
INSERT INTO caxNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Supiarrtü anati naqui abuturuqui abe cien niyaburrti nobirraca, y ensoro taman omeanaqui. Auqui iñoconiontiño manio noventa y nueve eana rroense, nauqui aürotitü apacheriuti manu taman ensoro, chepe nitabücürrü uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Arrtü tabüco uiti, pucünuñati, iñatati ompacüti y süroti tato aübu. ");
INSERT INTO caxNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Arrtü tiñataiti tato au niporrti esa bama nesarrti amigorrü y esa bama iposapatarrti, nanti ümoma: “Aupucünu ichepeñü, itopiqui tabüco sobi arrüna niyabu nobirrama ananca ensoro”. ");
INSERT INTO caxNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sucanañü aume —nanti Jesús—. Ane manrrü pucünuncurrü au napese arrtü iñorronconotiyü taman ñoñünrrü tarucu nomünantü uiti, pünanaqui itacu bama noventa y nueve macrirrtianuca urriantai nisüboriquirrimia au ñaquioncorrüma, y champü nümoche aiñorronconomacü. ");
INSERT INTO caxNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‛Suraboira quiatarrü machepecatarrü: Ane ito taman paürrü, ane nimonirri diez monedarrü. Ensoro taman pünanaqui. ¿Causane uirri caüma? Tiene que aiñonoco basarurrü y asunucu auquipo aübu niyapachequirri iyo, cheperrtü tabüco uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Arrtü tütabüco uirri, itasuriu arrüba nesarrü amigorrü y arrüba niposapatarrü, nantü ñome: “Aupucünu ichepeñü, itopiqui tabüco sobi nimoni, arrüna ananca ensoro rropünanaquiñü. ");
INSERT INTO caxNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sucanañü ito aume —nanti Jesús—, sane ito nipucünuncurrüma bama angelerrü aboma esati Tuparrü, arrtü iñorronconotiyü tamanti naqui ane nomünantü uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Urapoitito Jesús arrüna machepecatarrü isucarüma: —Anati taman ñoñünrrü. Aboma torrüma aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Arrti maniqui sunahüburrü nanti sane ümoti yaütoti: “Iyaü, aichüsoñü manu naenarri, arrüna tocabo iñemo, arrtü aconca”. Auqui arrti yaütoti chepesüro uiti arrüna nenarrirrti ümo manuma torrü aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Au manio nananeca arrti maniqui sunahüburrü acomoraboti nanaiña nenarrirrti y auqui sürotitü iche au quiatarrü cürrü. Taha tacürusu nimonirrti ui arrüna churriampü nisüboriquirrti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nauquiche tütacürusu nanaiña, auqui ane carerrtiya au manu cürrü. Tapü arrti caüma cuatü nicürüpürrti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Auquimanu sürotitü apacheti trabacorrü esati taman ñoñünrrü au manu cürrü. Arrti maniqui ñoñünrrü icüpurutiti nauqui acuirati yutacu niyaburrti nupaucheca. ");
INSERT INTO caxNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tarucapae nicürüpürrti maniqui yaürrü. Rranrrti aati niyubarata manio nupaucheca, pero chütorriopü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Auquimanu mapensarati. Nanti ümotiatoe: “Au niporrti taita aboma sürümanama nesarrti trabajadorerrü, y ane chama utuburiboma, sobüratai. Tapü arrüñü yaca auna tüsai ison nisürüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yeca tato esati taita, sucanañü ümoti: Iyaü, ane nipünate aübucü y aübutito Tuparrü. Isamute nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tapü aiñacañü tacana ahüñünqui, si no tacanati taman naesa trabajador. ");
INSERT INTO caxNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Auqui manu atüraiti, süroti tato esati yaütoti. Nauquiche tanati taha saimia niporrti, arrti yaütoti asaratitü cümenuti. Pucürusuti itacuti. Aürotitü yarucurrti cümenuti aitañumenutiti. Bacheboti besorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Auqui nanti maniqui yaürrü ümoti yaütoti: “Iyaü, ane nipünate aübucü y aübutito Tuparrü, isamute arrüna nomünantü. Tapü aiñacañü tacana ahüñünqui”. ");
INSERT INTO caxNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tapü arrti yaütoti nanti ümo bama imostoti: “Apaca tauna arrüna mejor rroparrü aibiboti, apiña apüti. ¡Apuraurrü año! Apiña ito sorotiquiarrü apü neherrti y sapaturrü ipopeti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Apatabai ito manu taman bacarrü baüro, nauqui uba aübuti. Masamuna pierrta aübuti. ");
INSERT INTO caxNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Itopiqi arrti naqui isaü anancati tacanarrtü coiñoti, pero caüma tacanarrtü süboricoti tato. Anancati ensoroti, pero caüma anati tato”. Auqui masamunuma pierrta. ");
INSERT INTO caxNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‛Tapü arrti maniqui quiatarrü aütorrti anancati au ñanaunrrü. Auqui cuati tato. Nauquiche tanati tato saimia porrü oncoiti manu pierrta, nitococorrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Auqui batasuruti ümoti taman mosorrü, ñanquitioti pünanaquiti isane arrüna pasabo. ");
INSERT INTO caxNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Auqui urapoiti maniqui mosorrü isucarüti, nanti: “Arrti aruqui iñataiti tato, y arrti aüma bacüpuruti nauqui atabori manu taman bacarrü bien baüro, itopiqui iñataiti bien sanurrti”. ");
INSERT INTO caxNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Auqui arrti maniqui yaruquitorrti tüboricoti y chirranrrtipü aürotitüpo. Pero arrti yaütoti sürotitü türüpo. Anitati nurria ümoti, nauqui aürotitüpo. ");
INSERT INTO caxNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Arrti maniqui aütorrti nanti ümoti: “Tusio nurria aemo taita, mantucubu añoca nirratrabacaca achepecü, y nantarrtai isamute isiu nacüpucu. Pero champürrtü acheca iñemo ni tamampü chivuma, nauqui ñasamu pierrta aübu bama niyesa amigorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero arrti maniqui ahü aübo aiñanainti tato, naqui tacürusu uiti namoni aübu paüca, y arrücü atabaiquia manu taman bacarrü bien baüro ümoti”. ");
INSERT INTO caxNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Auqui nanti yaütoti ümoti: “Isaü, arrücü aca siemprerrü ichepeñü, nanaiña arrüna ane sobi tone ito naesa. ");
INSERT INTO caxNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Caüma supasamuca pierrta y suipucünunca, itopiqui arrti aruqui anancati tacanarrtü coiñoti, pero caüma tacanarrtü süboricoti tato. Anancati ensoroti, pero caüma anati tato. ");
INSERT INTO caxNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Arrti Jesús urapoitito ümo bama ñanunecasarrti arrüna machepecatarrü: —Anati taman ñoñünrrü rricurrü. Anatito taman capatarrü ümoti. Auqui süromatü urabomati isucarüti patrón bama maquiataca imostorrti. Urapoimia que churriampü yachücoiti capatarrü aübu nenarrirrti patrón. ");
INSERT INTO caxNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Auqui arrti maniqui patrón itasurutiti maniqui capatarrü, nauqui anitati aübuti. Nanti ümoti: “¿Isane arrüna nachücoi? Ñoncoi que acusüpüca niñenarri. Mejor bacurrtara, itopiqui auquina caüma chauqui chüpuerurrüquipü capatarrücü iñemo”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Auqui arrti maniqui capatarrü mapensarati sane: “¿Causane caüma sobi? Itopiqui chirranrrtiquipü nauqui rratrabacaiqui ümoti. Chiñuñetempü rratrabaca au ñanaunrrü. Isüsoca ito rranqui limosnarrü pünanaqui genterrü. ");
INSERT INTO caxNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pero chauqui tütusio iñemo causane sobi —nanti ümotiatoe—, nauqui aboma bama yasuriurumañü au niporrüma, arrtü chirratrabacacaiquipü esati patrón”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Auqui batasuruti ümo bama ebeoma ümoti patrón, taiquianati taman. Nanti ümoti maniqui primero: “¿Mantucubu nebequi ümoti patrón?” ");
INSERT INTO caxNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Arrti maniqui yebeorrü iñumutati: “Rrebeca cien turrilemanca nasaite”. Nanti capatarrü: “Nani quichonimiacarrü nesa nebequi. Aiconomo icu arrüna nebequi cinuentatai turrilemanca”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Iñataiti quiatarü esati. Ñanquitiotito pünanaquiti: “¿Carücü, mantucutu nebequi?” Nanti: “Arrüñü rrebeca cien pusaneca trigo”. Nanti capatarrü ümoti: “Carü nani quichonimiacarrü ane corobo icu arrüna tücañe nebequi. Pero caüma aiconomo ochentatai pusaneca trigo”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Arrti maniqui patrón ipiatenti arrüna sane yachücoiti maniqui capatarrü. Nanti: “Arrti naqui niyesa capatarrü bien ipiacati itacutiatoe”. Nantito Jesús: —Ñemanauncurratoe, arrübama chicocoromatipü Tuparrü tamünauncatai uimia niquiubuma pünanaqui bama icocoromati. ");
INSERT INTO caxNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Chama nomünantü ane icu na cürrü ui monirri. Sane nauquiche sucanañü aume: Apisamuse arrüna urria ui na monirri. Arrtü tacürusu naumoni icu na cürrü, torrio aume aupobo au napese itobo. ");
INSERT INTO caxNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Arrti naqui ane ñanauncurrti aübu na chimiantai monirri, ane ito ñanauncurrti aübu na chama monirri. Tapü arrti naqui champü ñanauncurrti aübu na chimiantai, chüpuerurrüpito oñoncatü ümoti aübu chama monirri. ");
INSERT INTO caxNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Arrtü arraño champü napanauncu aübu ba nenarriquia icuqui na cürrü, chüpuerurrüpü oncotitü Tuparrü aume aübu na ñemanauncurratoe nenarrirri auqui napese. ");
INSERT INTO caxNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Arrtü champü napanauncu aübu nenarrirrti quiatarrü, chüpuerurrüpü atorri propiorrü amenarribo, arrüna rranrrti Tuparrü acumanati aume. ");
INSERT INTO caxNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Champüti naqui puerurrü aserebi ümo torrü mapatroneca. Itopiqui arrti taman cuasürüti ümoti, tapü arrti quiatarrü chücuasürütipü ümoti. Baserebioti nurria ümoti taman, tapü ümoti quiatarrü champü. Chüpuerurrüpü apaserebi ümoti Tuparrü mientras manrrü aurrianca ümo monirri. ");
INSERT INTO caxNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Arrübama fariseorrü tarucapae nirrancarrüma iyo monirri. Oncoimia arrüna sane. Unumati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Auqui arrti Jesús nanti ümoma: —Arraño apisamute arrüna tacanarrtü urria ümo macrirrtianuca. Pero arrti Tuparrü isuputacaiti arrüna napapensaca au nautusi. Arrüna napachücoi urria ümo macrirrtianuca, pero ümoti Tuparrü ünantatai. ");
INSERT INTO caxNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Arrüna nüriacarrü uiti Moisés y ñanunecacarrüma bama profetarrü tücañe buvaleo chepe numo iñataiti Juan Bautista. Arrti caüma urapoiti arrüna urriampae manitacarrü que arrti Tuparrü üriabucati oemo. Chauqui taboma sürümana macrirrtianuca rranrrüma aicocoma nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Arrüna cürrü y napese omiñarrio ñana, pero arrüna corobo nüriacarrü, nanaiña tiene que acoco. ");
INSERT INTO caxNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Arrtü anati taman ñoñünrrü iñocotati nicüpostoti y posoti aübu quiatarrü paürrü, chauqui tane nipünatenti. Arrtü posoti aübu na oncono uiti iquiana, churriampü. Ane ito nipünatenti uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nantito Jesús: —Anati taman ñoñünrrü rricurrü. Abe naibirrti omirria, champü tacanache. Naneneca ñasamucurrti pierrta. Champü tacanache nurriancarrü uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Anatito quiatarrü ñoñünrrü pobrerrti, nürirrti Lázaro. Maunrroconoti oboi yaca. Cuati atümoti abeu nitururrti maniqui rricurrü, ");
INSERT INTO caxNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","nirrancarrti aati manio bupaquio icuqui nimensarrti maniqui rricurrü. Hasta tamococa apicusebata manio yaca cütüpüti. ");
INSERT INTO caxNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Taman nanenese coiñoti maniqui pobrerrü. Cuamatü bama angelerrü iyoti, nauqui aiquianamati esati Abraham au napese. Auqui coiñotito maniqui rricurrü. Iñanamati cütu. ");
INSERT INTO caxNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Arrti maniqui rricurrü caüma tarucapae nitaquisürücürrti au infierno. Nauquiche asaratitü ape auquimanu, besüro narrtarrti auqui iche ümoti Abraham y ümoti Lázaro esati. ");
INSERT INTO caxNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Auqui tosibicoti maniqui rricurrü, nanti sane: “Iyaü Abraham, apucüru ichacuñü. Aicüpurrti Lázaro tauna, nauqui ayeti aübu tuma iñemo, nauqui rrimianaiña pario ümo niñutu, itopiqui tarucapae nichaquisürücü eana pese auna”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Auqui arrti Abraham iñumutati, nanti: “Isaü, aquionsü tücañe numo asüboriquiaiqui urriampae aemo. Tapü arrti Lázaro tücañe taquisürüti. Caüma urriampae nacarrti. Tapü arrücü asutiu nataquisürücü. ");
INSERT INTO caxNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ane ito taman cütubirri otüüsa auna cümuinta. Chüpuerurrüpü supapasa topü, ni auqui tahapü puerurrü apapasa tauna”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Auqui nanti tatito maniqui rricurrü: “Rranquiquia nurria apünanaquicü, Iyaü Abraham, aicüpurrti Lázaro au niporrti taita. ");
INSERT INTO caxNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Acamanu aboma cincomainqui masaruquitaiqui. Aicüpurrti nauqui uraboiti isucarüma, tapü cumatüquito tauna, itopiqui tarucapae taquisürücürrü auna”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Auqui nanti Abraham: “Ane uimia Nicororrü uiti Moisés y ui bama profetarrü. Tari icocotama”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Iñumutati tatito maniqui rricürrü: “Sane te, Iyaü Abraham. Pero arrtü anati naqui süborico tato eanaqui macoiñoca y urapoiti isucarüma, auqui caüma icocotama y iñorronconomacü”. ");
INSERT INTO caxNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nanti tatito Abraham: “Arrüma chirranrrüpüma aicocoma arrüna yacüpucurrti Moisés, ni ñanunecacarrüma bama profetarrüpü. ¿Quiubupito aicocoma nurarrti naqui süborico tato eanaqui macoiñoca? ");
INSERT INTO caxNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nanti Jesús ümo bama ñanunecasarrti: —Ane nantarrü macocotorrü oemo, nauquipü uisamune nomünantü. Pero taquisürütiatai naqui uiche aiñanti macocotorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Manrrüpü urria arrtü tomoeno canrrü sürümanarrü itüti, nauqui aruraüburumati au narubaitu turrü, tapü asioti achetiqui macocotorrü ümo bama icocoromañü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amasasai nurria autacuapatoe. Arrtü arrti aruqui masamunuti nomünantü aemo, aicuansomocosorrti. Arrtü iñorronconotiyü ui nura, airrimiaca manu nomünantü aübuti. ");
INSERT INTO caxNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Arrtü siete veserrü masamunuti nomünantü aemo au taman sapese, y siete veserrü cuati airrimiacati tato aübucü, arrücü tiene que airrimiaca tato aübuti. ");
INSERT INTO caxNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Arrübama apostolerrü namatü ümoti Señor: —Ayura suiñemo, nauqui manrrü sopipia somoncatü ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Auqui nanti Señor ümoma: —Arrtü amoncatüpü pario ümoti Tuparrü, puerurrüpü amucanaño ümo na suese sicomoro sane: “Aiquiaübusü auquina, suese. Acosi cümuinta narubaitu turrü”. Icocotapü manu suese arrüna napacüpucu. ");
INSERT INTO caxNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Supi arrtü anati taman patrón. Anati imostorrti. Aübapae aiñanainti tato maniqui imostorrti auqui ñanaunrrü, o auqui yacuiracarrti yutacu nobirraca. ¿Aensapü nanti patrón caüma ümoti sane: “Apasai, atümo nauqui aha primero rropünanaquiñü?” ");
INSERT INTO caxNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","No, chüpuerurrüpü sane nurarrti. Ta nanti ümoti sane: “Apema iñemo nauqui irra. Arrtü tüchauqui nirraca, atococa caüma aha y acha”. ");
INSERT INTO caxNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Champü nümoche achampiencati patrón ümoti itacu arrüna isamutenti isiu yacüpucurrti, itopiqui mosorrti te. ");
INSERT INTO caxNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sane ito arraño amucanaño ümoti Tuparrü sane: “Arrüsomü mosorrü somü. Champüapae supaserebiqui, itopiqui solamenterrü sopicocota arrüna nacüpucu”. ");
INSERT INTO caxNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Arrti Jesús amencotiqui, niyücürrti au Jerusalén. Pasaoti auqui manio cüca Samaria y Galilea. ");
INSERT INTO caxNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nauquiche tiñataiti au manio poca cuamatü cümenuti bama diez mañoñünca maunrrocono ui leprarrü. Rranrrü apore nañeturrüma. Tochencoma iche pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tosibocoma ümoti, namatü: —¡Jesús, maestro, apucüru suichacu! ");
INSERT INTO caxNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Asaratitü Jesús ümoma, nanti ümoma: —Amecosi apitusiancanaño isucarü bama sacerdoterrü, nauqui uraboimia, que turrian tato aume. Nauquiche süromatü, urriancama tato auqui namenrrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Auqui tamanti eanaquimia basücübücoti tato esati Jesús, ñanauncurrti ümoti Tuparrü aübu ñanitacarrti fuerte. ");
INSERT INTO caxNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bachesoiyoti esati Jesús, machampiencanati ümoti. Arrti naqui ñoñünrrü samaritanurrti. ");
INSERT INTO caxNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Auqui nanti Jesús: —Canapae diezma bama urriancama tato sobi. ¿Cautamo nacarrüma bama maquiataca nueve? ");
INSERT INTO caxNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Arrti naqui ñoñünrrü extranjerurrti. Tonentiatai naqui basücübücoti tato, nauqui achampiencati ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Auqui nanti ümoti maniqui ñoñünrrü: —Atüsai, acosito. Chauqui turriancü tato, itopiqui aicococañü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Arrübama fariseorrü ñanquitioma pünanaquiti Jesús auche ñana üriabucati Tuparrü. Aiñumuti Jesús, nanti ümoma: —Arrüna nüriacarrti Tuparrü chüpuerurrüpü basarai. ");
INSERT INTO caxNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chüpuerurrüpü usucana oñü: “Auna nacarrü”, ni “Tahapü nacarrü”. Itopiqui chauqui tütane abarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Auqui nanti Jesús ümo bama ñanunecasarrti: —Iñatai ñana manu tiemporrü aurriancapae amasarañü, arrüñü Ñemanauncurratoe Ñoñünrrü, pero chüpuerurrüpü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Namatü ñana: “Chauqui tiñataiti tato Cristo, anati auna, o anati taha”. Tapü amecatü isiuma, tapü apicocota nurarrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Itopiqui arrtü iseca tato, isecatü tacana arrone masünaca icu napese. Tütusio tone manu nanenese nisequi tato. ");
INSERT INTO caxNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero primero tiene que ichaquisürü y chiyasuriurupümañü bama macrirrtianuca arrüna tiemporrü caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Arrtü iseca tato ñana pasabo tacana arrüna pasabo tücañe nauquiche süboricotiqui Noé. ");
INSERT INTO caxNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Namanaiña basoma y chaboma y pohosoma ito. Pero nauquiche tüsürotitü Noé au arca, auqui cuatü manu turrü onüma, y namanaiña coiñoma. ");
INSERT INTO caxNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sane ito pasabo tücañe au nitiemporrti Lot. Basoma, chaboma, macomporarama y mapaventecanama, mancüturuma y masamunuma poca. ");
INSERT INTO caxNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero nauquiche sürotitü Lot auqui manu pueblurrü, auqui paquio pese y asufre auqui napese. Coiñoma namanaiña uirri. ");
INSERT INTO caxNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sane ito pasabo ñana au manu nanenese arrtü iseca tato, arrüñü Ñemanauncurratoe Ñoñünrrü. Tabücomantai macrirrtianuca ui carrticurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Arrti naqui tabüco chacu niporrti au manu nanenese, tapü süroti tatopo iyo nenarrirrti. Arrti naqui tabüco au ñanaunrrü, tapü süroti tato au porrü. ");
INSERT INTO caxNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Apaquionsaño ümo manu pasabo ümo nicüpostoti Lot. ");
INSERT INTO caxNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Arrti naqui chirranrrüpü aenso nisüboriquirrti auqui niyaca, coiñoti ñana. Tapü arrti naqui coiño ichopiquiñü, süboricoti au napese ñana. ");
INSERT INTO caxNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Arrümanu tobirri ñana aboma torrüma barücüroma icu taman cürurrü. Tamanti uturuquimia camperoti au napese, pero arrti quiatarrü onconoti. ");
INSERT INTO caxNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Abe ito torrü paüca patubarrio chépe. Taman campero, quiatarrü oncono. ");
INSERT INTO caxNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aboma ito torrüma mañoñünca au ñanaunrrü batrabacarama. Tamanti camperoti au napese, arrti quiatarrü onconoti. ");
INSERT INTO caxNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ui arrüna sane oncoimia, ñanquitioma pünanaquiti Jesús: —¿Señor, cauta pasabo ñana arrüna sane? Iñamutati Jesús ui machepecatarrü: —Auna cauta abe niñucuntu ba coiño, acamanu ito apiyoberabaraño parrupaquiquia. (Auna cauta aboma bama malorrü, acamanu ito cuatü carrticurrü uiti Tuparrü.) ");
INSERT INTO caxNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Urapoiti Jesús arrüna machepecatarrü isucarü bama ñanunecasarrti, tapü ubata ümoma arrtü meaboma, nauqui asioma eama. Nanti: ");
INSERT INTO caxNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Anati tücañe taman bacurrtara au manu pueblurrü. Champü ñanauncurrti ümoti Tuparrü. Champü ito ñanauncurrti ümoti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Au manuinqui pueblurrü ane ito taman paürrü biurarrü. Sürotü esati maniqui yacurrtarrü, nauqui uraboi arrüna chürüri isucarüti, nauquipü acurrtati aübuti maniqui nesarrü enemigorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tübupasao naneneca champü nümoche manu paürrü uiti maniqui yacurrtarrü. Chatendebotipü ümo. Pero tone naneneca ane icuatati. Auqui mapensarati sane: Arrüñü champürrtü ane nirranauncu ümoti Tuparrü, y champü nümoche sobi genterrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero tapü asio isuatañü na paürrü, mejor rrocümana itacu, nauqui tapü cuatüqui yesañü. ¡Si no cuatü caüma ahi saübuñü! ");
INSERT INTO caxNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Auqui nanti Señor: —Sane uiti maniqui yacurrtarrü malorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Manrrü te arrti Tuparrü ocümanati itacu bama icocoromati. Aensapü chücontopü aiñumuti neancarrüma bama manquio pünanaquiti tobiquia y naneneca? ");
INSERT INTO caxNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Abu contoatai bayurarati ümoma. Pero arrüñü Nemanauncurratoe Ñoñünrrü arrtü iseca tato acü ñana, ¿aensa oncomatüqui iñemo bama mañoñünca icu na cürrü? ");
INSERT INTO caxNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Urapoitito Jesús arrüna quiatarrü machepecatarrü ümo bama ñaquioncorrüma manrrü buenurrüma pünanaqui maquiataca: ");
INSERT INTO caxNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Aboma torrüma mañoñünca. Süromatü au niporrti Tuparrü eama. Arrti maniqui taman fariseorrti, y arrti maniqui quiatarü yacobrarrü impuestorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Arrti maniqui fariseorrü atüraiti nauqui eanti itacutiatoe. Nanti sane: “Arrücü Tuparrü ñachampiencaca aemo, itopiqui champürrtü yaca tacana bama maquiataca. Arrüma rranrrüma ümo nanaiña ümomantoe, ñencañarrüma, rranrrüma ümo nicüpostoti quiatarrü. Tapü arrüñü chisamutempü sane. Champürrtü yaca tacana nacarrti naqui yacobrarrü impuestorrü auna. ");
INSERT INTO caxNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Arrüñü chirracapü torrü nananeca au semana ui nirraquionco ácü. Yacheca ito aemo arrüna decima parterrü nanaiña nirracanasa”. ");
INSERT INTO caxNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tapü arrti maniqui yacobrarrü impuestorrü anati taha icheatai. Birrubuti asaratitü pario ape. Orronene ümoti. Meaboti sane: “Iyaü, apucüru ichacuñü, itopiqui arrüñü ane nomünantü sobi”. ");
INSERT INTO caxNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Auqui nantito Jesús: —Arrti maniqui yacobrarrü impuestorrü süroti tato au niporrti, chauqui tümorrimiacana arrüba nomünantü uiti. Tapü arrti fariseorrü champüatai. Itopiqui arrübama mañentonaunca cüsoboma ñana uiti Tuparrü, tapü arrübama itaquisünüancanamacü torrio ümoma üriacaboma uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Macanama manuma masiomanca esati Jesús, nauqui acurusüma uiti. Pero arrübama ñanunecasarrti macuansomoconoma ümo manuma macanama. ");
INSERT INTO caxNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Auqui nanti Jesús ümoma: —Asioma sane manuma masiomanca, tari yebamatü yesañü. Tapü abasiquia icuatama. Itopiqui arrti Tuparrü yasuriuruti ümo bama oncomatü ümoti tacana nacarrüma bama masiomanca, auna cauta üriabucati. ");
INSERT INTO caxNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñemanauncurratoe sucanañü aume: Arrti naqui chirranrrüpü oncotitü ümoti Tuparrü tacana taman ñaüma, chüpuerurrüpü aye uiti auna cauta ane nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tamanti eanaqui manuma mayüriabuca israelitarrü ñanquitioti pünanaquiti Jesús: —Buen maestro, ¿causane sobi nauqui aye sobi isüboriquiboñü arrüna champü nitacürurrü? ");
INSERT INTO caxNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nanti Jesús ümoti: —¿Causane ucanü iñemo buenurrüñü? Arrti Tuparrü tonentiatai naqui buenurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tusio nurria aemo arrüba yacüpucurrti Tuparrü: “Tapü aecatü isiu quiatarrü paürrü. Tapü atabaiquia. Tapü acusüpüca. Tapü apanca apüti quiatarrü. Tari ane nanauncu ümoti aüma y ümo napacüma”. ");
INSERT INTO caxNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Auqui iñumutati maniqui ñoñünrrü: —Nanaiña arrüna sane icocota auqui numo chimiañünqui. ");
INSERT INTO caxNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nanti Jesús ümoti: —Pero aninqui arrüna faltaboiqui aemo. Aipiaventecasio naniña arrüba naenarri y acumana nicuarrü ümo bama pobrerrü. Auqui caüma ane nacua uiti Tuparrü au napese. Auqui caüma ariacu isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nauquiche toncoiti arrüna sane maniqui ñoñünrrü, sucheboti, itopiqui bien rricurrti. ");
INSERT INTO caxNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Arrti Jesús arrtaiti nisuchequirrti, nanti: —Cuestarrü ümo bama rricurrü aye uimia esati Tuparrü auna cauta üriabucati. ");
INSERT INTO caxNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Arrümanu numuquianrrü camello manrrü chücuestarrüpü ümo, nauqui apasa auqui nirrto cümese, pünanaquiti rricurrü, nauqui aye uiti auna cauta ane nüriacarrti Tuparrü. (Arrümanu camello nisunaunrrü tacana cabayurrü.) ");
INSERT INTO caxNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Arrübama oncoi arrüna sane namatü: —¿Ñacutimo naqui puerurrü aye uiti esati Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nanti Jesús ümoma: —Arrübama macrirrtianuca chüpuerurrüpü aye uimia, pero arrti Tuparrü nanaiña puerurrü urriane uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Auqui nanti Pedro ümoti Señor: —Señor, tusio aemo sopiñocota nanaiña arrüna somenarri, nauqui somenotü asiucü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nanti Jesús: —Ñemanauncurratoe sucanañü aume, arrti naqui iñocotati niporrti, o yaütoti, o yaruquitorrti, o nicüpostoti, o aütorrti itopiqui arrüna rranrrti aserebiti ümoti Tuparrü, ");
INSERT INTO caxNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","torrio tato ümoti manrrü itobo icu na cürrü, y torrio ito isüboriquiboti arrüna champü nitacürurrü au manu nuevurrü cürrü cuabotiqui. ");
INSERT INTO caxNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Arrti Jesús batasuruti ümo bama doce ñanunecasarrti, nanti ümoma: —Caüma oecatü au Jerusalén, nauqui acoco sobi arrüna corobo tücañe iñemo ui bama profetarrü, ta arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Taha itorrimianamañü mecu bama extranjerurrü. Arrüma unumañü, uratoquioma iñemo, utureuruma iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tiene que ocüsimia iñemo, y auqui itabairomañü. Pero pürücü ba trerrü naneneca isüboriquia tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Arrübama ñanunecasarrti champürrtü iyebo uimia ñanitacarrti, ni atusipü ümoma isane ümoche. ");
INSERT INTO caxNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tanati Jesús saimia manu pueblurrü nürirri Jericó. Acamanu anati taman ñoñünrrü naqui supuso. Tümonsoti isiu cutubiurrü, ñanquiquirrti limosnarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Auqui oncoiti nipiasacarrüma manuma macrirrtianuca, ñanquitioti isane arrüna pasabo. ");
INSERT INTO caxNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Namatü ümoti: —Arrti Jesús auqui Nazaret pasaoti auquina. ");
INSERT INTO caxNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Auqui tosibicoti fuerte, nanti: —¡Jesús, aütorrti yüriaburrü David, apucüru ichacuñü! ");
INSERT INTO caxNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tapü arrübama cusürübo icuansomoconomati, nauqui etayoiti. Tapü arrti manrrü nitosibirrti, nanti: —¡Aütorrti yüriaburrü David, apucüru ichacuñü! ");
INSERT INTO caxNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Auqui arrti Jesús tochencoti. Bacüpuruti iyoti. Nauquiche tanati esati, arrti Jesús ñanquitioti pünanaquiti: ");
INSERT INTO caxNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Isane arrüna arranca isamune aemo? Iñumutati maniqui supuso: —Señor, irranca nauqui acura iñemo, nauqui puerurrü yasara tato obi. ");
INSERT INTO caxNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Auqui nanti Jesús ümoti: —Rracurara aemo, nauqui urrianü tato, itopiqui aicococañü. ");
INSERT INTO caxNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Au manu rratorrü asarati tato maniqui supuso. Auqui sürotitü isiuti Jesús, ñachampiencacarrti ümoti Tuparrü. Namanaiña bama macrirrtianuca arrtaimia arrüna sane y iñanaunumatito Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Auqui iñataiti Jesús au manu pueblurrü nürirri Jericó. Pasaoti auqui manu. ");
INSERT INTO caxNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Acamanu pohosoti taman ñoñünrrü rricurrü, nürirrti Zaqueo, naqui üriatu bama mayacobraca impuestorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rranrrtipü asaratiti Jesús, pero chüpuerurrtipü, itopiqui tarucapae macrirrtianuca, y arrti chimiantiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Auqui sürotitü acusürüti yarucurrti isiu cutubiurrü arrüna auquiche tiene que apasati Jesús. Aüroti ape apü taman suese sicomoro. ");
INSERT INTO caxNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nauquiche tiñataiti Jesús acamanu, besüro narrtarrti ape ümoti, nanti ümoti: —Zaqueo, ariacu tato acü apuraurrücü, itopiqui caüma ñacansaca au napo. ");
INSERT INTO caxNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Auqui arrti Zaqueo cuati acü apuraurrti. Yasuriurutiti Jesús au niporrti aübu tarucu nipucünuncurrti. ");
INSERT INTO caxNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ui arrüna sane arrtaimia arrübama macrirrtianuca, manitanama churriampü ümoti Jesús. Namatü: —¡Causane aürotitü acansati au niporrti maniqui tarucu nomünantü uiti! ");
INSERT INTO caxNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tapü arrti Zaqueo atüraiti esati Señor, nanti ümoti: —Señor, yacheca ümo bama pobrerrü cümuinta arrüna ane sobi, y arrüna isusüpütio pünanaquiti taman o rrencañaca, itorrimiata tato ümoti cuatro veserrü manrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Auqui nanti Jesús ümoti: —One ataesübuca eanaqui nomünantü, Zaqueo, arrücü ichepe nanaiña naesa familiarrü. Ta arrücü ito aca eanaqui nesarrti familiarrü Abraham. ");
INSERT INTO caxNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Arrüñü Ñemanauncurratoe Ñoñünrrü isecatü nauqui yapache y ñataesümunucu eanaqui nomünantü ümo bama aboma iche pünanaquiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Arrübama macrirrtianuca arrtaimia arrüna pasabo uiti Jesús. Auqui urapoiti isucarüma arrüna machepecatarrü, itopiqui tanati saimia Jerusalén. Au ñaquioncorrüma que au manu rratorrü üriabucati Tuparrü icu na cürrü uiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nanti ümoma: —Anati taman ñoñünrrü rricurrü. Sürotitü au quiatarrü cürrü iche, nauqui aisamunutiyü yüriaburrti taha, y auquimanu rranrrti ayeti tato nauqui üriaburuti ümo bama pohoso au nicürrtiatoe. ");
INSERT INTO caxNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nauquiche chüsürotitüquipü, batasuruti ümo bama diezma imostorrti. Itorrimiatati ümo cadati taman taman monedarrü oro tarucapae nicuarrü. Nanti ümoma: “Apasamu negociorrü aübu na monirri cheperrtü iseca tato”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero arrübama pohoso auqui nicürrti champürrtü rranrrüma nauqui yüriaburrti ümoma. Bacüpuruma isiuti comisión, nauqui uraboimia isucarüti sane: “Chüsuirrancapü nauqui üriaburü suiñemo”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero arrti chauqui tüyüriaburrti taha au manu quiatarrü cürrü. Auqui süroti tato au niporrti. Nauquiche tiñataiti tato, batasuruti ümo manuma diezma imostorrti bama ümoche tücañe torrio monirri. Rranrrti atusi ümoti mantucubu ñacanasarrti cadati taman. ");
INSERT INTO caxNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Arrti maniqui cusürübo itusiancanatiyü isucarüti, nanti: “Señor, nani namoni. Macanana sobi diez veserrü manrrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Auqui arrti maniqui esache nanti ümoti: “Urriampae nachücoi. Arrücü buen mosorrücü. Acoconaunca aübu chimiantai monirri. Iñacü yüriaburrücü ñome diez puebluca”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Cuati maniqui quiatarrü, itusiancanatiyü, nanti: “Señor, nani namoni, ane ñacanasarrü sobi cinco veserrü manrrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nanti yüriaburrü ümoti: “Arrücü ito yüriaburrücü sobi ñome cinco puebluca”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Auqui cuatito maniqui quiatarrü, nanti: “Señor, carü nani namoni. Itomoenta icu nipiañuera, nauqui iñahübu. ");
INSERT INTO caxNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Irruca aünanacü. Itopiqui tarucu nabrutucu. Acaca auquina cauta champü isane oncono obi. Arrianca ata auna cauta chancapü cütu obi”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Auqui caüma nanti Señor ümoti: “¡Mosorrü marriquiatarrü! Ui arrüna uratoe yacheca aemo carrticurrü caüma. Tusio aemo que arrüñü tarucu nibrutucu. Rracaca auquina cauta champü isane oncono sobi, y rrataca auquina cauta champürrtü rrancütuca. ");
INSERT INTO caxNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Causane chaiñatapü nimoni esa bama ipiaca atrabacama aübu, ümo arrtü tiseca tato au nipo, aitorrimiatapü tato iñemo aübu ñacanasarrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Auqui nanti ümo manuma amoncoma acamanu: “Apiquiaübu pünanaquiti manu monirri. Apitorrimia ümoti maniqui ane uiti diez monedarrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Auqui namatü ümoti: “Arrti te tütane uiti chama monirri”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Auqui nanti Señor: “Sucanañü aume, arrti naqui ane uiti, torrio manrrü ümoti uübo. Tapü arrti naqui champü isane ümoti carübu pünanaquiti arrüna chimiantai ane uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tapü arrübama tüboricomantai isuatañü, bama chirranrrüpüma nauqui yüriaburrüñü, apiquiasama tauna, nauqui ataborimia isucarüñü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nauquiche tütacürusu arrüna nipiarirrti Jesús, pasaotito, niyücürrti au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tanati saimia manio pueblumanca nobürirri Betfagé y Betania, abe cutaquiquibo manu yiriturrü Olivo. Auquimanu bacüpuruti ümo bama torrüma ñanunecasarrti, ");
INSERT INTO caxNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nanti ümoma: —Amecosi au manio poca abe taha saimia. Arrtü apiñatai taha, tabüco aboi bururrü arrüna champüti tüsüro chacu, ane tomoeno. Apisoquisüna y apiquia tauna. ");
INSERT INTO caxNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Arrtü anati naqui nanti aume, ¿causane apisoquisüna manu bururrü? Amucanaño ümot sane: “Arrti Señor ane nümoche uiti”. ");
INSERT INTO caxNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Auqui süromatü manuma torrü. Aiñanaimia taha. Tabüro uimia manu bururrü tacana nurarrti Jesús ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nauquiche tüsoquisüro uimia, cuamatü manuma iyabuche, namatü: —¿Causane apisoquisüna manu bururrü? ");
INSERT INTO caxNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aiñumuma: —Arrti Señor ane nümoche uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Auqui chebatai uimia. Sürotü uimia manu bururrü esati Jesús. Aiñanaimia. Iñatama naibirrimia chacu. Atobüti Jesús chacu. ");
INSERT INTO caxNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sürotitü. Isiu arrüna namenrrti arrübama macrirrtinuca ipiacumainquiatama naibirrimia isiu cutubiurrü cümenuti. ");
INSERT INTO caxNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nauquiche tütaboma saimia nicümama manu yiriturrü Olivos, namanaiña bama icocoromati ui nipucünuncurrüma iñanaunumati Tuparrü, itopiqui tarrtaimia nanaiña arrüba milagrorrü uiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Namatü sane: —Tari anaunuti naqui yüriaburrü, naqui cuati au nürirrti Tuparrü. Tari pucünuñama bama aboma au napese. ¡Gloria ümoti Bae Tuparrü! ");
INSERT INTO caxNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eana manu genterrü aboma bama fariseorrü, namatü: —Maestro, aicuansomocosoma bama cuamatü asiucü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tapü arrti Jesús iñumutati, nanti: —Sucanañü aume, arrtü etayoimia bama, seguramente botosibico arrüba canca, opiñanaunuñü. ");
INSERT INTO caxNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aiñanainti manrrü taha arrüna auquiche atusi Jerusalén. Nauquiche asaratitü ümo pueblurrü areoroti itacu bama pohoso, ");
INSERT INTO caxNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nanti: —Chentienderrüpü año bama macrirrtianuca au na pueblurrü Jerusalén au na nanenese arrüna uiche urriampü caüma nabaca. Pero caüma chauqui chüpuerurrüquipü atusi aume arrüna torriobopü aume. ");
INSERT INTO caxNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cuantionqui naneneca chomirriampü aume. Arrübama aubesa enemigorrü süromatü itupecu naubesa pueblurrü, nauqui ahimia aume. ");
INSERT INTO caxNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nanaiña pueblurrü tiene que añarri. Namanaiña auconca bama pohoso. Ni tamampü canrrü oncono onü quiatarrü, itopiqui chütusiopü aume que arrti Tuparrü rranrrti ayurati aume. ");
INSERT INTO caxNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Auqui sürotitü Jesús au niporrti Tuparrü. Penecoma uiti bama mapaventecana y bama macomporara acamanu. ");
INSERT INTO caxNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nanti ümoma: —Icu Nicororrü nantü sane: “Sane nanti Tuparrü: Nipo ane ümo meancarrü”. Pero aboi caüma apiñata tacana nipo bama macusüpüca. ");
INSERT INTO caxNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naneneca ñanunecacarrti Jesús au niporrti Tuparrü. Pero arrübama üriatu bama sacerdoterrü y bama manunecana nüriacarrü y bama mayüriabuca bapacheroma niquiubuma, causane nauqui aitabairomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero champürrtü tabüco uimia, itopiqui namanaiña macrirrtianuca aboma onsapetioma nurria nurarrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Au manu taman nanenese anancati Jesús au niporrti Tuparrü, ñanunecacarrti ümo macrirrtianuca. Urapoiti arrüna urriampae manitacarrü. Acamanu iñataimia esati bama üriatu bama sacerdoterrü y bama manunecana nüriacarrü, ichepe bama mamayoreca. ");
INSERT INTO caxNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Namatü ümoti: —Urasoi suisucarü quiti yacüpucuche aemo, nauqui puerurrü aisamune arrüna sane. ¿Quiti uiche aitorrimia aemo üriacabocü? ");
INSERT INTO caxNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nanti Jesús ümoma: —Arrüñü ito irranca rranquirio amopünanaqui. Aburasoi isucarüñü ito. ");
INSERT INTO caxNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Quiti uiche aicüpurutiti Juan Bautista nauqui aunimiati, arrti Bae Tuparrü o mañoñüncatai? ");
INSERT INTO caxNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Auqui baparioma aübumantoe, namatü: —¿Isane arrüna usurapoboibo? Arrtü usucana oñü que uiti Tuparrü ayeti tücañe Juan Bautista, auqui caüma arrti Jesús iñumutati: “¿Causane chapicocotapü nurarrti?” ");
INSERT INTO caxNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tapürrtü usucana oñü que ui mañoñüncatai, namanaiña macrirrtianuca itabairoma oñü oboi canca, itopiqui arrüma ñaquioncorrüma ta arrti Juan manitanati au nürirrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Auqui namatü ümoti Jesús: —Chütusiopü suiñemo quiti uiche aicüpurutiti Juan, nauqui aunimiati. ");
INSERT INTO caxNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Auqui nanti Jesús ümoma: —Arrüñü ito chüpuerurrüpü suraboi ausucarü quiti uiche aitorrimia iñemo isüriacabo, nauqui puerurrü isamune arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Auqui manitanati ümo genterrü ui arrüna machepecatarrü: —Anati taman ñoñünrrü mancüturuti uva au niyorrti. Auqui torrio uiti mecu bama trabajadorerrü. Auqui sürotitü iche auquimanu ümo sürümana naneneca. ");
INSERT INTO caxNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nauquiche tiñatai mani nitiempo nupucu uva, bacüpuruti ümoti taman mosorrü nauqui anquirioti pünanaqui manuma trabajadorerrü nüta uva, arrüna tocabo ümoti. Pero arrüma ipubairomati. Icüpurumati tato saneantai, champü torrio ümoti uimia. ");
INSERT INTO caxNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Arrti maniqui iyoche bacüpuruti ümoti quiatarrü mosorrü. Isiatai uimia ümoti. Ipubairomati, unumati, icüpurumati tato saneantai. ");
INSERT INTO caxNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Auqui arrti maniqui iyoche bacüpuruti tatito ümoti quiatarrü mosorrü. Pero arrümanuma trabajadorerrü bahiyoma ümoti, obürio ümoti uimia. Penecoti uimia tato. ");
INSERT INTO caxNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aüboqui nanti maniqui iyoche: “¿Causane caüma sobi? Mejor icüpuruti naqui isaü, naqui tarucu nicuarrti iñemo. Arrtü tasaramati, canapae ane ñanauncurrüma ümoti”. ");
INSERT INTO caxNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero nauquiche asaramatü manuma trabajadorerrü ümoti, namatü ümomantoe: “Tonenti naqui tiene que asuriuruti nanaiña nenarrirrti naqui iyoche. Mejor uitabairoti, nauqui asio oemo nanaiña”. ");
INSERT INTO caxNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Auqui aiquianamati auqui manu ñanaunrrü. Taborioti uimia. ¿Causane caüma uiti maniqui iyoche ümo manuma trabajadorerrü? ");
INSERT INTO caxNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sürotitü te taha esama nauqui ataborimia uiti, y nauqui aitorrimiati manu ñanaunrrü ümo maquiataca. Nauquiche oncoimia arrüna sane manuma macrirrtianuca namatü: —Tapü pasabo arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Arrti Jesús asaratitü nurria ümoma, nanti: —Taqui chütusiopü aume isane ümoche ane corobo icu Nicororrü sane: Arrübama masamunuma porrü canca yarutaübutama manu taman canrrü, ñaquioncorrüma churriampü, abu manrrü urria. Tone baserebio tacana taman nompacüorrü principal ümo porrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‛Arrti naqui taübüco onü manu canrrü, iñarrioti. Tapürrtü paquio manu canrrü onüti, cütocati nurria iquiana. (Arrti Jesús tacana manu canrrü. Arrübama üriatu israelitarrü tacana bama masamunu porrü.) ");
INSERT INTO caxNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Arrübama üriatu bama sacerdoterrü y bama manunecana nüriacarrü rranrrüpüma aiñenomati Jesús au manu rratorrü, itopiqui tusiatai ümoma, ta ümoma aüro manu machepecatarrü. Pero birrubuma ñünana genterrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Auqui caüma bacüpuruma ümo bama mañoñünca nauqui arrüpiama ümoti. Mapañama ane ñanauncurrüma ümoti Tuparrü, abu rranrrüma nauqui atabüti Jesús uimia arrtü manitanati arrüna churriampü, nauqui puerurrüma aitorrimianamati ümoti yüriaburrü rromanorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sane nauquiche ñanquitioma pünanaquiti: —Maestro, tusio suiñemo arrücü anunecaca arrüna urria, champü nümoche obi ñapensacarrüma bama macrirrtianuca. Anunecaca causane nauqui aye osoi nosüboriqui urria ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ucanü suiñemo, ¿taqui urria bapaca impuestorrü ümoti yarusürürrü yüriaburrü César, o churriampü? ");
INSERT INTO caxNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero arrti Jesús tütusiatai ümoti arrüna ñacocotorrüma ümoti. Nanti ümoma: —¿Causane aurrianca apencaña iñemo? ");
INSERT INTO caxNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Apitusianca isucarüñü taman monedarrü. Nauquiche titusiancatama nanti: —¿Quiti ausüpütuche arrüna ane icu, y quiti üriche arrüna corobo? Arrüma iñumutama: —Nausüpüturrti yarusürürrü yüriaburrü César, y nürirrtito. ");
INSERT INTO caxNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Auqui nanti Jesús ümoma: —Sanen te, apacoconaun ümoti yarusürürrü yüriaburrü. Apacoconaun ito ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Sane nauquiche chüpuerurrüpü ane causane uimia ümoti ui arrüna nanti isucarü genterrü. Cütobüsoma y etayoimia. ");
INSERT INTO caxNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aboma ito manuma saduceorrü süromatü asaramati Jesús. Arrüma chicocotapüma arrtü süboricoma tato ñana bama coiño. Namatü ümoti Jesús: ");
INSERT INTO caxNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, ane nicororrü uiti Moisés, nantü sane: “Arrtü anati taman ñoñünrrü coiñoti y oncono nicüpostoti, pero champü naübosirri uiti, auqui arrti yaruquitorrti tari posoti aübu manu paürrü biurarrü, nauqui ane naübosirri uiti au nürirrti maniqui coiño”. ");
INSERT INTO caxNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bueno, aboma auna suyarrüpecu bama siete mañoñünca yaruquitorrümantoe. Arrti maniqui cusürübo apoti aübu manu paürrü. Coiñoti y chaübosiopü uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Arrti maniqui segundo posoti aübu manu biurarrü y coiñotito, isiatai champü naübosirri uiti. ");
INSERT INTO caxNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Auqui arrti maniqui tercero posoti aübu manu paürrü biurarrü. Coiñotito y campü naübosirri uiti. Sane pasabo ümo manuma maquiataca. Posoma aübu, y coiñoma. Champürrtü aübosio uimia. ");
INSERT INTO caxNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Auqui coiño ito manu paürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Carü arrtü süboricomampü tato bama coiño, ¿quiti naqui icüposüche manu paürrü? Itopiqui namanaiña posoma aübu. ");
INSERT INTO caxNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Arrti Jesús iñumutati nurarrüma, nanti: —Auna icu na cürrü arrübama mañoñünca y ba paüca posoma. ");
INSERT INTO caxNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ñana arrtü süboricoma tato eanaqui macoiñoca, chauqui chüposopümainqui taha au napese. ");
INSERT INTO caxNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Taha chauqui champüqui concorrü. Nacarrüma caüma tacana naca bama angelerrü. Arrüma caüma aütorrti Tuparrü, itopiqui süboricoma tato. ");
INSERT INTO caxNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Arrti Moisés asaratiti Tuparrü tücañe apü manu suese omo. Acamanu tusio que arrübama coiño süboricoma tato, itopiqui acamanu nanti Tuparrü que arrti Tuparrti ümoti Abraham, ümoti Isaac y ümoti Jacob. ");
INSERT INTO caxNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Arrti Tuparrü champürrtü Nitupa bama coiño, ta Nitupa bama süborico. Uirri tusio oemo que arrübama trerrü antiburrü süboricoma tato esati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eanaqui manuma manunecana nüriacarrü namatü sane: —Ñemanauncurratoe, Maestro, bien aiñumuta arrüna nura bama saduceorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Auquimanu champürrtü asiomainqui anquirioma pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Auqui nanti Jesús ümoma: —¿Causane amucanaño que arrti Cristo aütorrti David, o sea eanaqui nesarrti familiarrü David tücañe? ");
INSERT INTO caxNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Abu arrti David nanti Señor ümoti Cristo. Ane manu Salmo corobo uiti, nantü sane: Arrti Bae Tuparrü nanti ümoti Señor: “Atümo auna rrupetacuñü au nepanauncu niñe, ");
INSERT INTO caxNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","cheperrtü bachesoiyoma sobi aesacü arrübama tüboricatai aemo”. ");
INSERT INTO caxNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Arrtü nampü ñoñünrrtiatai Cristo eanaqui nesarrti familiarrü David, quiubupü nanti David “Señor” ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Namanaiña macrirrtianuca oncoimia arrüna nanti Jesús ümo bama ñanunecasarrti. Nanti sane ümoma: ");
INSERT INTO caxNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Amasasai nurria ñünana bama manunecana nüriacarrü. Arrüma urriantai ümoma amema aübu naibirrimia abaesa. Rranrrüma nauqui apanqui nurria ümoma au plaza, y nauqui apanaun ümoma. Tümonsoma auna bien ümo nisurratoe au ba poca sinagoga. Tacane ito itacümanauncutama omirria tümoca au pierrtaca. ");
INSERT INTO caxNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pero arrüma encañaoma ñome ba viuraca iyo nomenarrirri, itopiqui arrio chüpuerurrüpü amocüma yutacuapatoe. Auqui meaboma yabaiturrü, nauqui tapü tusio arrüna churriampatai isamutema. Tonema bama carrticabo nurria ñana. ");
INSERT INTO caxNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Anancati Jesús au niporrti Tuparrü. Asaratitü ümo bama rricurrü bacheboma nimonirrimia au manu baurimia, ñacumanatarrüma ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Asaratitito ümo taman paürrü biurarrü, bachebo torrtai monedarrü, chimiantai niyucuarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Auqui nanti: —Ñemanauncurratoe sucanañü, arrüna paürrü biurarrü pobrmrrü bachebo manrrü pünanaqui namanaiña au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Itopiqui arrüma bacheboma arrüna nisobüratu nimonirrimia. Tapü arrüna paürrü bachebo nanaiña arrüna nimonirri. ");
INSERT INTO caxNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eanaqui bama ñanunecasarrti Jesús urapoimia arrüna coñorrtai niporrti Tuparrü, y arrüba canca omirria y posürümanaca, y arrüba macumanataca. Auqui nanti Jesús ümoma: ");
INSERT INTO caxNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Cuatü manu nanenese ñana auche nanaiña iñarrio arrüna amarrtai. Ni tamampü canrrü oncono onü quiatarrü, nanaiña tiene que añarri. ");
INSERT INTO caxNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Auqui ñanquitioma pünanaquiti: —Maestro, ¿auche apasa arrüna sane, isane arrüna señarrü, arrtü tüsaimia? ");
INSERT INTO caxNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nanti Jesús ümoma: —Amasasai nurria, tapü anati naqui encañao aume, itopiqui sürümanama cuamatü ñana au nisüri, namatü: “Arrüñü Cristo, chauqui tiñatai”. Tapü amecatü isiuma. ");
INSERT INTO caxNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Arrtü apipiate nüri guerra y bahiquirri aübu mayüriabuca, tapü aupirruca uirri. Tone cusürübo apasa. Pero chütonenquipü ñapacümuncuturrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nantito ümoma: —Taman nación bahiyo aübu quiatarrü. Tamanti yüriaburrü masamunuti guerra aübuti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tarucu nipiaichoconoco cürrü. Ane ito carerrtiya y norrocorrü au nanaiñantai cürrü. Tapü icu napese tusio ñana arrüba señarrü uirrucatai ñomünana. ");
INSERT INTO caxNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‛Pero primero autaquisürüca uimia. Iquianama año au ba sinagoga nauqui acurrtama aupu. Iñanama año au preso auqui niyaca. Amecatü uimia esa bama mayüriabuca. ");
INSERT INTO caxNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Auqui caüma puerurrü aburaboi isucarüma nisüri. ");
INSERT INTO caxNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tapü apapensaca iyo na apanitacabo autacuapatoe. ");
INSERT INTO caxNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Itopiqui arrüñü yache aume apanitacabo au manu horarrü ñana. Champüti naqui puerurrü aiñumu tato nabura sobi. ");
INSERT INTO caxNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","‛Arraño caüma tiene que autaquisürü uimia. Hasta bama aubaütaiqui y naupacütaiqui aboma ausiu. Bama aubaruqui y bama aupariente y bama aubesa amigorrü tüboricoma aume, itorrimianama año. Aboma bama abuturuqui coiñoma uimia. ");
INSERT INTO caxNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Namanaiña icu na cürrü tüboricomantai aume auqui niyaca. ");
INSERT INTO caxNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero chüpuerurrüpü aenso ni tamampü niqui nautanu. Arrti Tuparrü bacuirarati autacu. ");
INSERT INTO caxNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Arrtü chapatachecapü uimia, ane ñana nausüboriqui arrüna champü nitacürurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‛Arrtü amarrtai tütaboma bama sürümanama masortaboca itupecu na pueblurrü Jerusalén, auqui caüma tütusio aume, ta conto iñarrio. ");
INSERT INTO caxNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Arrübama aboma au na cürrü Judea, tari yesüburama omeana yirituca. Arrübama aboma au Jerusalén, tari yeracamatü auqui. Arrübama aboma au camporrü, tapü süroma tato au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Itopiqui tonehio manio naneneca nesa carrticurrü, auche ñana acoco nanaiña arrümanu nantü icu Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Butaquisüratai arrüba paüca abe botochiquio, y arrüba papaümana, itopiqui au manu nanenese tarucu taquisürücürrü ümo na genterrü. Tone carrticurrü uiti Tuarrü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aboma bama coiño ui bahiquirri. Aboma maquiataca enoma y canama au piquiataca cüca. Tapü arrübama extranjerurrü, iñarrio uimia arrüna pueblurrü Jerusalén y iñonocotama. Querabo mecuma cheperrtü tacürusu nüriacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‛Auqui ane señarrü isu surrü, isu pama y omeana norrtoñeca. Tapü icu na cürrü arrübama macrirrtianuca chütusiopü ümoma causane uimia. Cütobüsoma y birrubuma ui na buyarrü ui tarucapae nipococo narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chauqui chücusüurupümainqui ui nirrucurrüma, ñapensacarrüma cümenu na cuabotiqui icu na cürrü, itopiqui hasta arrüba abe icu napese bupaichoconono ito. ");
INSERT INTO caxNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Auqui caüma asaramañü, arrüñü Ñemanauncurratoe Ñoñünrrü, isecatü eana cüsaüboca aübu tarucu nisüriaca y tarucu nanentacarrü sobi. ");
INSERT INTO caxNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Arrtü tirranrrü apasa nanaiña arrüna sane, aupucünu, tari arucu tato aume, itopiqui tüsaimia nauqui autaesübu icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Auqui urapoiti Jesús arrüna machepecatarrü isucarüma: —Amasasai arrüna suese higuera, o piquiataca sueca ito. ");
INSERT INTO caxNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Arrtü tamarrtai aübapae ubasu tato sueca, tütusio aume, ta tüsaimia nitiempo tanaunrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sane ito arrtü amarrtai arrüba sane, tütusio aume que contoatai üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‛Ñemanauncurratoe sucanañü aume, pasabo nanaiña arrüna sane antes que acoma bama macrirrtianuca arrüna tiemporrü caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Arrüna napese y na cürrü omiñarrio ñana, pero nisura ñemanauncurratoe tiene que acoco. ");
INSERT INTO caxNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‛Amasasai nurria. Tapü apichücaño ümo arrüna naurriantümo y nauborisüba. Tapü tarucapae napapensaca iyo arrüna ausüratai icuqui cürrü. Apacuira nurria autacu, tapü autabücatai ui manu nanenese, arrtü iñatai. ");
INSERT INTO caxNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Itopiqui arrümanu nanenese cuatü tacana metorrü, rrepenteatai iñatai ümo bama süborico icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tari abaca amarrtaiquiatü, y apanqui nantarrü pünanaquiti Tuparrü, nauqui urria nabaca au ba taquisürücüca cuabotü, y nauqui puerurrü apitusiancanaño isucarüñü au nitacürurrü, arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Manunecanati Jesús au sapese nantarrü au niporrti Tuparü. Tapü au tobirri sürotitü onü manu yiriturrü nürirri Olivos. ");
INSERT INTO caxNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Namanaiña macrirrtianuca cuamatü esati au niporrti Tuparrü tansürapae, nauqui onsaperioma nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tüsaimia manu pierrta parrcua, auna cauta basoma pan champü levadura eana. ");
INSERT INTO caxNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Arrübama üriatu bama sacerdoterrü y bama manunecana nüriacarrü bapacheroma niquiubuma, causane nauqui aitabairomati Jesús. Pero birrubuma ñünana macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Auqui süroti choborese auti Judas, nürirrtito Iscariote, naqui eanaqui manuma doce apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Arrti naqui Judas sürotitü esa bama üriatu bama sacerdoterrü y bama mayüriabuca auqui niporrti Tuparrü. Baparioti aübuma, causane nauqui aitorrimianatiti Jesús ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Arrüma bien pucünuñama. Namatü ümoti: —Supacheca aemo monirri itobo. ");
INSERT INTO caxNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Urria ümoti. Auqui caüma bapacheroti niquiubuti, nauqui aitorrimianatiti Jesús ümoma anecanatai, tapü tusio ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iñatai manu pierrta parrcua. Au manu pierrta batabaiyoma ito nobirrama, nauqui aama, ñaquioncorrüma iyoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Arrti Jesús bacüpuruti ümo bama torrü, arrti Pedro y arrti Juan. Nanti ümoma: —Amecosi apapema oemo ümo na pierrta parrcua. ");
INSERT INTO caxNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Arrüma ñanquitioma pünanaquiti: —¿Cauta arrianca nauqui supapema? ");
INSERT INTO caxNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Arrti nanti: —Arrtü apiñatai au pueblurrü apicuñucati taman ñoñünrrü, ane bausürrü ompacüti ataso ui turrü. Amecosi isiuti au na porrü cauta sürotitü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Amucanaño sane ümoti maniqui ipoche acamanu: “Nanti Señor: ¿Cauta naca manu curato auna cauta irra ichepe bama nirranunecasa ümo na pierrta parrcua”? ");
INSERT INTO caxNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Auquimanu itusiancatati ausucarü manu cuarto sürümanarrü ane ape au primer piso, chauqui tücoñocono. Acamanu apapema. ");
INSERT INTO caxNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Süromatü manuma torrü. Tabüco uimia nanaiña tacana arrüna nanti Jesús ümoma. Auqui mapemanama, nauqui aama ümo manu pierrta parrcua. ");
INSERT INTO caxNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nauquiche tütobiquia, iñataiti Jesús aübu bama maquiataca ñanunecasarrti. Atümoti esa mensarü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Auqui nanti ümoma: —Chaübopü nirranca irra aupu ümo na parrcua antes que ichaquisürü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Itopiqui sucanañü aume nurria, chüpuerurrüpü irra tatito ümo na pierrta cheperrtü cocono sobi arrüna ümoche na pierrta, arrtü üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Auqui iquiampetati manu coparrü, machampiencanati ümoti Tuparri, nanti: —Aucha nanaiña año arrüna itorrimiata aume. ");
INSERT INTO caxNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Itopiqui sucanañü aume, auquina caüma chichacaiquipü arrüna niyü uva, cheperrtü üriabucati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Auqui iñentatito pan. Machampiencanati ümoti Tuparrü. Ichepesünatati. Itorrimiatati ümoma, nanti: —Arrünani tone nisütüpü. Tone torrio nauqui aco autacu. Aumase pan sane, nauqui nantarrtai apaquioncañü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sane ito isamutenti aübu manu coparrü iyau niyacarrüma, nanti ümoma: —Tone niñoto, arapara caüma itacu sürümanama macrirrtianuca, na atusi que arrti Bae Tuparrü isamutenti nuevurrü tratorrü aübuma. ");
INSERT INTO caxNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‛Pero arrti naqui ñoñünrrü uiche aitorrimianañü anati auna ichepeñü esa na mensarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ison, ta sane ñapensacarrti Tuparrü iñemo. Pero taquisürütiatai naqui uiche aitorrimianañü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Auqui caüma bama ñanunecasarrti ñanquitioma pünanaquimiantoe quiti naqui uiche aitorrimiatiti Jesús ñana. ");
INSERT INTO caxNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Auqui caüma bama ñanunecasarrti Jesús uratoquioma ümomantoe, ñacuti naqui manrrü ane nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Auqui nanti Jesús ümoma: —Arrübama ane nüriacarrüma ümo macrirrtianuca icu na cürrü, isamutema isiu nirrancarrüma aübuma. Y arrübama mayüriabuca namatü que urria yachücoimia ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tapü arraño tapü apisamute sane. Arrti naqui ane manrrü nüriacarrti, tari ichimiancanatiyü isucarü maquiataca. Arrti naqui bacüpuru, tari tonenti naqui baserebio aume. ");
INSERT INTO caxNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ñacuti naqui ane manrrü nüriacarrti, arrti naqui tümonsoti esa mensarrü nauqui aati, o arrti naqui baserebio pemacarrü? Ñemanauntu te, arrti naqui tümonso esa mensarrü. Tapü arrüñü isecatü nauqui yaserebi aume. ");
INSERT INTO caxNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‛Arraño nantarrtai amoncaño ichepeñü numo chütamampatai iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sane nauquiche yacheca aume abüriacabo, tacanati Iyaü bacheboti isüriacaboñü, ");
INSERT INTO caxNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","sane nauqui auba y aucha ichepeñü ñana esa nimensa auna cauta ane nisüriaca, y nauquito autümo au tronorrü y apacurrta ümo bama auqui ba doce familiarrü Israel. ");
INSERT INTO caxNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nantito Señor ümoti Simón Pedro: —Simón, Simón, arrti choborese ñanquiriorotiyü pünanaquiti Tuparrü, nauqui ane nüriacarrti aemo. Rranrrti acheti macocotorrü aemo. ");
INSERT INTO caxNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero arrüñü rranquiquia atacucü tapü tacürusu nacoconauncu iñemo. Arrtü turrian tato naquionco iñemo, ayura ümo bama aruquitaiqui au nisüri, nauqui tapü oncono uimia ñacoconauncurrüma iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Auqui nanti Simón Pedro ümoti Jesús: —Señor, yecatü asiucü au preso, cheperrtü isonca achepecü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nanti Jesús ümoti: —Pedro, suraboira nurria asucarücü: Caüma na tobirri antes que apu pohorrü, apanca trerrü veserrü, ucanü que chasuputacapüñü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Auqui ñanquitioti Jesús pünanaquimia: —Nauquiche icüpucaño tanu, champürrtü apacaca pusanese, ni aumonibopü ni ausapatubupü. ¿Taqui ane faltabo aume? —Champü te —namatü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nanti ümoma: —Tapü caüma apiquia naupusane y apaca ito aumonibo. Arrti naqui champü nicüserrti, tari ipiaventecanati nicüburrirrti, nauqui aye uiti icüseboti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Itopiqui sucanañü nurria aume, tiene que acoco sobi arrüna nantü icu Nicororrü. Ta ane corobo sane: “Urabomati tacanati yatabayorrü”. Nanaiña arrüna corobo iñemo tücañe, tiene que acoco sobi caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Auqui namatü ümoti: —Señor, auna abe torrü cüseca posürümanaca. Nanti: —Iñatai, abasio sane. ");
INSERT INTO caxNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Auqui arrti Jesús sürotitü auquimanu. Sürotitü onü manu yiriturrü nürirri Olivos, tacana arrüna nantarrtai yachücoiti. Arrübama ñanunecasarrti süromatü isiuti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nauquiche tiñataiti taha, nanti ümoma: —Apean auna, tapü apatacheca arrtü cuatü aume macocotorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Auqui sürotitü manrrü tahiqui pario pünanaquimia. Nichequirri tacana arrtü baruca canrrü. Acamanu bachesoiyoti, nauqui eanti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nanti: —Iyaü, arrtü arrianca, aitaesümunusuñü pünanaqui nichaquisürücü arrüna cuabotü iñemo. Pero aiña isiu narrianca, tapü aiñata isiu nirranca. ");
INSERT INTO caxNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Au manu rratorrü iñataiti taman ángel esaquiti Tuparrü, nauqui acheti icusüubuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Onquisioti tarucapae nisuchequirrti y nirrucurrti. Manrrü meaboti ümoti Tuparrü. Au na neancarrti umüunca ümoti notorrü, rrüquio acü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nauquiche tütacürusu neancarrti, süroti tato esa bama ñanunecasarrti. Tabücoma uiti manumuma ui nisuchequirrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Auqui nanti ümoma: —¿Causane abasiquia aumpanu? Apatüsai, nauqui apean, tapü apatacheca ui macocotorrü, arrtü cuatü aume. ");
INSERT INTO caxNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Anancatiqui manitanati, rrepenteatai iñataimia sürümanama mañoñünca. Arrti Judas cusürüboti aübuma, abu tonenti naqui tücañe eanaqui bama doce ñanunecasarrti. Sürotitü esati Jesús, nauqui anquiti nurria ümoti aübu besorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Auqui nanti Jesús ümoti: —¡Judas, así que ui arrüna besorrü aitorrimiacañü mecuma, arrüñü Ñemanauncurratoe Ñoñünrrü! ");
INSERT INTO caxNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Arrübama amoncoma ichepeti Jesús arrtaimia arrüna pasabobo, namatü: —Señor, bahira ümoma aübu cüsese. ");
INSERT INTO caxNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tamanti eanaquimia obürio uiti ümoti maniqui imostorrti yarusürürrü sacerdoterrü. Oquio nepanauncu numasurrti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tapü arrti Jesús nanti: —¡Asio sane, tapü ahiquia! Auqui caüma bacurarati ümoti maniqui obürio ümoti. Au manu rratorrü urriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Auqui nanti Jesús ümo manuma üriatu bama sacerdoterrü y ümo manuma masortaboca auqui niporrti Tuparrü y ümo manuma mayüriabuca, bama cuamatü iyoti: —Arraño abecatü iyoñü aübu cüseca y aübu sueca tacanapaepürrtü cusüpürrüñü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nauquiche anancañü abarrüpecu naneneca au niporrti Tuparrü chapiñencopüñü. Pero chauqui tiñatai arrüna horarrü aume, itopiqui arrti choborese üriabucati caüma. ");
INSERT INTO caxNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Auqui iñenomati Jesús. Sürotitü uimia au niporrti maniqui yarusürürrü sacerdoterrü. Tapü arrti Pedro süroti isiuti auqui icheatai. ");
INSERT INTO caxNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Acamanu arrübama masortaboca maunrrimianama pese türüpo au nusuara. Acamanu tümonsoma itupecu, nauqui apema, itopiqui rrimianene manu tobirri. Arrti Pedro tümonsotito eanama. ");
INSERT INTO caxNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Auquimanu cuatü taman cumanacarrü, besüro narrtarrü ümoti Pedro. Anati tümonsoti esa manu pese. Ane caüma narrtarrü ümoti, auqui nantü: —Arrüna noñünrrü ananca ito ichepe Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero arrti Pedro mapañati ümo, nanti: —Champürrtü isuputacati maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Coboi pario tamantito asaratitü ümoti Pedro, nantito ümoti: —Arrücü ito anancü ichepeti Jesús. Nanti Pedro: —No, champürrtü anancañü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tupasao taman horarrü cuati quiatarrü, nanti: —Ñemanauncurratoe arrti naqui ñoñünrrü anancatito ichepeti Jesús, itopiqui chanecanapatai galileorrtito. ");
INSERT INTO caxNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero arrti Pedro mapañati tatito, nanti: —Chütusiopü iñemo isane arrüna anitaca. Au manu rratorrü puuru pohorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Auqui arrti Señor pebücoti, asaratitü ümoti Pedro. Tapü arrti Pedro aquionotiyü iyo nipiarirrti tücañe Señor ümoti sane: “Antes que apu pohorrü apanca trerrü veserrü que chasuputacapüñü”. ");
INSERT INTO caxNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Auqui sürotitü türüpo. Orronene nurria ümoti, y tarucu nareorrti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Arrümanuma mañoñünca bacuirara itacuti Jesús unumati, bacheboma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Itamurriancatama nisurrti. Bacheboma isuti. Ñanquitioma pünanaquiti: —¿Tusio aemo quiti bachebo aemo? Urasoi, arrtü arrücü profetarrücü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aruqui nanaiñantai ñanitacarrüma churriampü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nauquiche tütaneneca arrübama mamayoreca israelitarrü y bama üriatu bama sacerdoterrü y bama manunecana nüriacarrü iyoberabaramacü. Itasurumati Jesús. Iñanamati esama. Acamanu ñanquitioma pünanaquiti: ");
INSERT INTO caxNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Urasoi nurria suisucarü, ¿arrücü Cristo? Auqui iñumutati nurarrüma: —Arrtü sucanañü aume que arrüñü, chapicocotapü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Arrtü rranquitio amopünanaqui, chüpuerurrüpü apiñumu, y chaurriancapü apiñemecanañü. ");
INSERT INTO caxNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Arrüñü Ñemanauncurratoe Ñoñünrrü ichümoca ñana au nepanauncu neherrti Tuparrü, naqui tarucu nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Auqui ñanquitioma pünanaquiti: —¿Así que arrücü Aütorrti Tuparrü? Iñumutati: —Arrüñü te. ");
INSERT INTO caxNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Auqui namatü: —Champü nümochetiqui terrticurrü. Chauqui toñoncoi nurarrti ui propoirrü nuñumasu. ");
INSERT INTO caxNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Auqui namanaiña atüraimia. Aüromatü aübuti Jesús esati Pilato, naqui yüriaburrü rromanorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aiñanaimia esa niporrti. Acamanu urabomati Jesús isucarüti Pilato. Namatü: —Tabücoti soboi naqui ñoñünrrü ausüratai uiti ümo macrirrtianuca. Nanti qu churriampü bapaca impuestorrü ümoti yarusürürrü yüriaburrü César. Nantito que tonenti Cristo, tacana yüriaburrti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Auqui arrti Pilato ñanquitioti pünanaquiti Jesús: —¿Arrücü yüriaburrücü ümo bama israelitarrü? Iñumutati Jesús: —Arrüñü te. ");
INSERT INTO caxNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Auqui nanti Pilato ümo bama üriatu bama sacerdoterrü y ümo bama macrirrtianuca: —Champü nipünatenti naqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero arrübama macrirrtianuca manrrü nitosibirrimia fuerte nurria, namatü: —Itümoniancatati genterrü ui arrüna ñanunecacarrti. Cusürübo uiti au Galilea, y caüma iñataiti auna Judea, nauqui aisamunenti isiu. ");
INSERT INTO caxNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nauquiche oncoiti Pilato arrüna sane, ñanquitioti pünanaquimia, arrtü ñemanauntu auqui Galileati. ");
INSERT INTO caxNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Namatü ümoti que auqui tahati. Auqui icüpurutiti Jesús esati Herodes naqui yüriaburrü au Galilea, itopiqui au manio naneneca anancatito Herodes au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nauquiche tasaratitü Herodes ümoti Jesús, bien pucünuñati, itopiqui chaübopü nirrancarrti asaratiti. Oncoitiatai nürirrti. Rranrrti nauqui asamuti milagrorrü isucarüti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ausüratai ñanquitioti pünanaquiti Jesús. Pero arrti Jesús champürrti iñumutati nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Acamanu amoncoma ito bama üriatu bama sacerdoterrü ichepe bama manunecana nüriacarrü, urabomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Auqui arrti Herodes ichepe bama nesarrti masortaboca unumati Jesús. Nauqui atusi nurria nuncurrüma ümoti, süro aibiboti uimia coñorrtai tacana naibirrti yüriaburrü. Auqui arrti Herodes icüpurutiti tato esati Pilato. ");
INSERT INTO caxNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Arrümanu nanenese arrti Pilato ichepeti Herodes isamunumacü amigorrü aübumantoe. Abu tücañe enemigorrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Auqui arrti Pilato oberabarama uiti bama üriatu bama sacerdoterrü, bama mayüriabuca y bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Auqui nanti ümoma: —Arraño apiquiacati tauna yesañü naqui ñoñünrrü. Amucanaño que ausüratai uiti ümo macrirrtianuca. Türranquitio pünanaquiti ausucarü, pero chütusiopü arrtü ñemanauntu arrüna amucanaño ümoti. Canapae champü nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni arrtipü Herodes tabücopü nipünatenti. Sane nauquiche icüpurutiti tato iñemo, chauqui tamarrtai. Champü arrüna nipünatenti nauqui aconti sobi. ");
INSERT INTO caxNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Rracüpura nauqui acüboriti, y auqui iñemecacati. ");
INSERT INTO caxNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ümo manu pierrta nantarrtai anati naqui emecana auqui preso. Tone arrüna yacheatarrti Pilato. ");
INSERT INTO caxNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Namanaiña tosibicoma manu genterrü, namatü: —¡Tari comati maniqui Jesús, aitaesümunurrti Barrabás! ");
INSERT INTO caxNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Taipü arrti maniqui Barrabás anancati au preso, itopiqui yatabayorrti au manu pueblurrü. Bahiyoti aübu bama masortaboca rromanorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tapü arrti Pilato rranrrti aiñemecanatiti Jesús. Manitanatiqui ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero arrüma tosibicoma manrrü fuerte nurria, namatü: —¡Aiñarrti apü curusürrü! ");
INSERT INTO caxNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tütabe trerrü ñanquiquirrti Pilato pünanaquimia sane: —¿Isane arrüna nomünantü uiti naqui ñoñünrrü? Champürrtü tabüco sobi nipünatenti nauqui acontipü. Rracüpura na acüboriti, auqui caüma iñemecacati. ");
INSERT INTO caxNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero arrüma manrrü nitosibirrimia, nauqui aiñanatiti apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ui na tarucapae nitosibirrimia chebatai uiti Pilato aisamunentiatai arrüna ñanquitioma pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sane nauquiche emecanati maniqui ñoñünrrü, naqui ñanquirioromati, naqui anancati au preso itopiqui yahiquirrti y itopiquito arrüna yatabaiquirrti. Tapüti Jesús torrioti mecuma, tari isamutema aübuti isiu nirrancarrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nauquiche tanancati Jesús mecu masortaboca, süromatü aübuti, nauqui aiñanamati apü curusürrü. Isiu cutubiurrü icuñunumati maniqui ñoñünrrü auqui Cirene, nürirrti Simón. Aübo cuati tato auqui camporrü. Iñenomati nauqui aiquianti ompacüti curusürrü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Süromatito isiuti Jesús sürümanama macrirrtianuca y sürümana paüca. Bareoro y botosiboco ui niyusuchequirri itacuti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero arrti asaratitü ñome, nanti: —Arraño paüca auqui Jerusalén, tapü abareoca ichacuñü. Abareo autacuapateo y itacu bama abaübositaiqui. ");
INSERT INTO caxNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Itopiqui cuantionqui naneneca auna auche amucanaño: “Urriampae nubaca ba paüca champürrtü ubaübosio”. ");
INSERT INTO caxNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Auquimanu caüma namatü bama macrirrtianuca ñome ba yirituca: “Aupaqui somonü”, y ñome ba yiritumanca namatü: “Apiñanecasa somü”. ");
INSERT INTO caxNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Isamutema arrüna tarucu nomünantü iñemo. Pero abaübü isamutema arrüna manrrü tarucu nomünantü ñana. ");
INSERT INTO caxNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Süromatito uimia torrü mañoñünca macusüpüca, nauqui ataborimia ichepeti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aiñanaimia au manu nürirri “Nipiai nitanu macoiñoca”. Acamanu crabuti Jesús uimia apü curusürrü. Arrübama torrüma macusüpüca crabuma ito apü nicurusürrüma, tamanti au nepanauncurrti Jesús, arrti quiatarrü au nepaurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Arrti Jesús nanti: —Iyaü, tari airrimiaca nomünantü ui bama macrirrtianuca, itopiqui chütusiopü ümoma arrüna isamutema. Tapü bama masortaboca suerteabo uimia naibirrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Arrübama macrirrtianuca amoncoma acamanu arrtayomatü. Arrübama ito mayüriabuca aboma acamanu aübu nuncurüma ümoti Jesús. Namatü: —Mataesümunucunuti ümoti quiatarrü. Caüma tari itaesümunutiyü uirrtiatoe, arrtü ñemanauncurratoe Cristo ti, naqui Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Arrübama masortaboca unumatito Jesús. Süromatü esati, aichamanamati vinorrü ocoro. ");
INSERT INTO caxNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Namatü ümoti: —Arrtü yüriaburrücü ümo bama israelitarrü, aitaesümunusü obiatoe. ");
INSERT INTO caxNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iñatama ito taurarrü apü curusürrü onü nitanurrti ape pario. Ane corobo icu auqui manio trerrü manitacaca griego, latín y hebreo, nantü sane: “Tonenti Jesús, naqui üriatu bama israelitarrü”. ");
INSERT INTO caxNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tamanti uturuqui manuma torrü macusüpüca otorrio ichepeti Jesús nanti: —Arrtü arrücü Cristo, aitaesümunusü obiatoe, y aitaesümunusü somü ito. ");
INSERT INTO caxNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tapüti maniqui quiatarrü icumpañeruturrti icuansomoconotiti, nanti ümoti: —Champü nanauncu ümoti Tuparrü. Arrücü aca ito aübu na carrticurrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Arroñü te ane nomünantü osoi. Utaquisürüca itopiqui na churriampü uisamute. Tapüti naqui ñoñünrrü champü nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Auqui nanti ümoti Jesús: —Arrtü taca auna cauta ane nüriaca, aquionsü iyoñü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Auqui arrti Jesús iñumutati nurarrti, nanti: —Ñemanauncurratoe sucanañü aemo, caüma aiñatai ichepeñü au paraiso. ");
INSERT INTO caxNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tiñatai tose. Auqui tomiquianene au nanaiña cürrü. Nururacarrü manu nitomiquianenequirri hasta las trerrü isiu nimümürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Arrüna surrü otochebo. Arrümanu cortinarrü au niporrti Tuparrü quiopüro cümuintaqui. ");
INSERT INTO caxNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Auqui arrti Jesús tosibicoti, nanti: —Iyaü, amecucü itorrimiata niyausüpü. Iyau manu nurarrti coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nauquiche tarrtaiti maniqui capitán rromanorrü arrüna pasabo, iñanaunutiti Tuparrü. Nanti sane: —Ñemanauncurratoe, arrti naqui ñoñünrrü champü nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Namanaiña manuma macrirrtianuca arrtaimia arrüna pasabo. Süromatü auquimanu, mapensarama, orronene ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Arrübama isuputaramati Jesús y arrüba paüca cuantio auqui Galilea isiuti Jesús abe umarrtayotü ümo arrüna sane pasabo auqui icheatai. ");
INSERT INTO caxNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Anati taman ñoñünrrü bien buenurrti, y urria nisüboriquirrti, nürirrti José. Arrti auqui manu pueblurrü nürirri Arimatea, ane au manu cürrü Judea. Tonenti tamanti eana manuma mamayoreca israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Arrti naqui José barrüperarati na üriaburati Tuparrü. Champürrtü urria ümoti arrüna isamutema aübuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Arrti sürotitü esati Pilato, nauqui anquirioti nicunturrti Jesús pünanaquiti. Torrio uiti Pilato ümoti. ");
INSERT INTO caxNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nauquiche tücaüburuti Jesús apüqui curusürrü uiti José, cüburrioti uiti. Süroti cütu au manu nusutu canrrü, auna cauta champüti tüsüro cütu. ");
INSERT INTO caxNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Arrümnu nanenese tüniyücürrü ümo manu nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Arrümanio paüca cuantio tücañe ichepeti Jesús auqui Galilea omenotü apasabori auna cauta aiñama nicunturrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Auqui omeno tato au niyopürrü. Nauquiche topiñatai taha, acomorabo oboi perfume, arrüba omirriantai norimia. Au manu nanenese nesa macansacarü pacansara tacana arrüna nantü nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Arrümanu tominco tansürapae omenotü manio paüca esa manu nusuturrü. Opiquiata manu perfume. ");
INSERT INTO caxNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nauquiche topiñatai esa nusuturrü, umarrtai manu canrrü uiche ataburri tücañe, carübo. ");
INSERT INTO caxNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Omenotüpo, pero champürrtü tabüco oboi nicunturrti Señor Jesús. ");
INSERT INTO caxNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bocütobüso acamanupo, chütusiopü ñome causane oboi. Rrepenteatai amasaratü ümo torrüma mañoñünca aboma atürayoma yobesa. Cuara nurria naibirrimia. ");
INSERT INTO caxNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Arrümanuma mañoñünca namatü ñome: —¿Causane abasiquia apapacheriuruti eanaqui bama macoiñoco naqui süborico tato? ");
INSERT INTO caxNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Champüti auna. Chauqui tüsüboricoti tato. Apaquionsaño ümo arrümanu nurarrti tücañe aume au Galilea. ");
INSERT INTO caxNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nantipütoche aume: “Arrüñü Ñemanauncurratoe Ñoñünrrü tiene que ichorri ümo bama ane nomünantü uimia, y itabairomañü apü curusürrü. Y pürücü ba trerrü naneneca isüboriquia tato”. ");
INSERT INTO caxNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Auqui upaquionaño manio paüca iyo nurarrti Jesús tücañe. ");
INSERT INTO caxNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Auqui manu omeno tato au pueblurrü, aburaboi isucarü manuma once ñanunecasarrti Jesús y isucarü bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tonehio manio paüca: María Magdalena, Juanarrü, Mariarrü nipiacütoti Jacobo, y arrüba piquiataca paüca. Oboi aburaboi isucarü bama apostolerrü arrüna pasabo ñome. ");
INSERT INTO caxNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero nauquiche toncoimia bama apostolerrü tacanarrtü piaracarrtai ümoma. Chicocotapüma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tapü arrti Pedro sürotitü türüpo, yarucurrti esa nusuturrü. Nauquiche iñataiti taha, sürotitüpo. Arrtaiti manio cüburriquia, abe au taman narücüquirri. Auquimanu süroti tato au porrü, cütobüsoti. ");
INSERT INTO caxNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Arrümanuinqui nanenese tücañe torrüma bama ñanunecasarrti Jesús süromatü au manu pueblurrü nürirri Emaús. Nichequirri taqui once kilómetros auqui Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amoncoma baparioma ümo arrüna pasabo au Jerusalén, niyücürrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Numo baparioma sane y mapensarama, arrti Jesús sürotitü esama, amencoti ichepema. ");
INSERT INTO caxNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Arrüma asaramati, pero tacana taburrio narrtarrüma, chisuputaramatipü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Auqui arrti Jesús ñanquitioti pünanaquimia: —¿Isane arrüna abasiquia apapari isiu cutubiurrü? ¿Causane ausuchecatai? ");
INSERT INTO caxNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tamanti eanaquimia nürirrti Cleofás iñumutati nurarrti Jesús: —Au nanaiñantai tusio arrüna pasabo au Jerusalén arrüba naneneca tübupasao. Arrücü anancü taha, ¿causane chütusiopü aemo? ");
INSERT INTO caxNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nanti: —Isane arrüna pasabo? Namatü ümoti: —Arrüna pasabo ümoti Jesús auqui Nazaret. Tonenti profetarrti tücañe, tarucu nüriacarrti. Tusio ui arrüna isamutenti y ui arrüna nurarrti isucarüti Tuparrü y isucarü bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Arrübama üriatu sacerdoterrü y bama mayüriabuca itorrimianamati, nauqui aconti apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tapü arrüsomü supapensaca que uiti taesüburu tato arrüna genterrü Israel. Chauqui tübupasao trerrü naneneca arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Abe ito manio paüca amonquio suichepe. Opicütomünana somü, itopiqui obebotü cuatü nanenese au nicürrti. ");
INSERT INTO caxNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Champürrtü tabüco oboi nicunturrti. Auqui manu cuantio tato aburaboi suisucarü arrüna umarrtai manuma angelerrü. Namatü ñome, süboricoti tato. ");
INSERT INTO caxNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Auqui arrübama suisumpañeru süromatü asaborimia au manu nusutu canrrü. Tabüco uimia tacana arrüna munantü manio paüca, tapü arrti Jesús champürrtü asaramati. ");
INSERT INTO caxNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Auqui nanti Jesús ümoma: —¿Causanempü chüpuerurrüpü apicoco arrüna turapoimiacaü bama profetarrü. Canapae tairri nautanu. ");
INSERT INTO caxNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Arrti Cristo tiene que ataquisürüti primero, y auqui caüma atorri üriacaboti y nanentacaboti au napese. ");
INSERT INTO caxNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Auqui urapoiti nurria arrüna nantü icu Nicororrü, arrüna manitanama ümoti tücañe. Cusürübo uraboiti arrüna ane corobo uiti Moisés, y auqui nicororrü ui bama profetarrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Iñataimia au manu pueblurrü Emaús. Arrti Jesús isamutenti tacanarrtü pasaotiatai. ");
INSERT INTO caxNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Arrüma rranrrüma nauqui asioti ichepema, namatü: —Asiquia suichepe, itopiqui chauqui tütümümüca. Así que sürotipo ichepema. ");
INSERT INTO caxNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nauquiche tanancati tümonsoti ichepema esa mensarrü, iñentati manu pan. Icunusüancatati y chepesüro uiti. Itorrimiatati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Au manu rratorrü tacanarrtü rrütopücoma. Aüboqui isuputaramati. Pero arrti Jesús ensoroti tatito esaquimia au manu rratorrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Auqui namatü ümomantoe: —Taitacu oñonquisio tacana uürara utusi ui nupucünuncu, nosequi ichepeti, numo manitanati oemo isiu cutubiurrü, urapoiti usucarü icuqui Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Auqui champürrtü barrüperaramainqui. Basücübücoma tato au Jerusalén au manu tobirri. Nauquiche tiñataimia tato, tabücoma uimia bama once apostolerrü oberabarama aübu bama icumpañeruturrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Arrüma namatü ümo manuma torrü: —Ñemanauncurratoe süboricoti tato Señor. Arrti Simón Pedro asaratiti. ");
INSERT INTO caxNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Auqui arrümanuma torrü urapoimia arrüna pasabo ümoma isiu cutubiurrü, y causane nauquiche aisuputaramati Jesús, nauquiche ichepesünatati pan. ");
INSERT INTO caxNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nauquiche amoncomainqui baparioma arrüna sane, arrti Jesús paecüburuti eanama. Manquitioti nurria ümoma, nanti: —Taiquiana urria nabaca. ");
INSERT INTO caxNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Auqui cütobüsoma bama ñanunecasarrti, y birrubuma, ñaquioncorrüma asaramati taman yausüpürrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Auqui nanti Jesús ümoma: —¿Causane tarucu naucütobü? ¿Causane apapensaca ui naupirrucu? ");
INSERT INTO caxNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Amasasai niñe y nipope, ta arrüñü. Ausiapata tauna nauqui apiñenoñü. Arrti yausüpürrü champü nañeturrti ni anempito nipiairrti. Tapü arrüñü ane nirrañetu y nipiai. ");
INSERT INTO caxNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Auqui itusiancatati neherrti y nipoperrti isucarüma, nauqui asaraimia. ");
INSERT INTO caxNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero arrüma champürrtü icocotamainqui nurria ui na nipucünuncurrüma y ui na nicütobürrüma. Auqui nanti Jesús ümoma: —¿Ane auna aboi nauqui irra? ");
INSERT INTO caxNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Torrio ümoti peasorrü nopiocorrü cünucunu. ");
INSERT INTO caxNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yasutioti y basoti isucarüma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Auqui nanti ümoma: —Arrüna pasabo iñemo, tone arrümanu tüsurapoi tücañe ausucarü, nauquiche anancañünqui auchepe. Nanaiña tiene que acoco arrüna ane corobo isütüpüñü uiti Moisés y ui bama profetarrü y au manu librurrü salmo. ");
INSERT INTO caxNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Auqui caüma manunecanati ümoma, nauqui aye uimia Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nanti tatito ümoma: —Sane ane corobo. Arrti Cristo tiene que ataquisürüti y aconti y pürücü ba trerrü naneneca süboricoti tato eanaqui macoiñoca. Sane pasao iñemo. ");
INSERT INTO caxNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Arrüna nisüri tiene que aburaboi isucarü namanaiña macrirrtianuca auna Jerusalén y au nanaiña icu na cürrü, nauqui atusi ümoma, y nauqui amorrimiaca tato nomünantü uimia, arrtü iñorronconomacü. ");
INSERT INTO caxNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Arraño terrticurrü año ümo arrüna sane, itopiqui amarrtai. ");
INSERT INTO caxNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Icüpucati Espíritu Santo aume, ta sane turapoiticaü Tuparrü, rranrrti aicüpurutiti aume. Pero abasiquiaiqui auna pueblurrü Jerusalén cheperrtü apasuquiucati auqui napese. Arrtü cuati, torrio aume abüriacabo auqui ape. ");
INSERT INTO caxNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Auqui arrti Jesús sürotitü aübuma auqui pueblurrü. Iñataimia au manu nürirri Betania. Acamanu iquiamperotiño ape nipiarrti. Macunusüancanati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Isiu manu ñacunusüancacarrti ümoma, sürotitü ape pünanaquimia au napese. ");
INSERT INTO caxNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Arrüma asaramatü isiuti aübu ñanauncurrüma ümoti. Auqui süroma tato au Jerusalén aübu tarucu nipucünuncurrüma. ");
INSERT INTO caxNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nantarrtai aboma au niporrti Tuparrü, ñanauncurrüma ümoti Tuparrü. Amén. ");
INSERT INTO caxNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tücañe numo champüqui isane, anancatiatai Cristo, naqui nürirrtito “Nurarrti Tuparrü”. Anancati ichepeti Tuparrü, ta arrtito Tuparrti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Auqui ñemonco anancati ichepeti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Arrti Cristo nisamucurrti nanaiña arrüba abe, champü arrüna anancatai, champü arrüna ubaüro uirratoe, nanaiña nisamucurrti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uiti naca nanaiña süboriquirri icu na cürrü. Arrti tacana basarurrü ümo macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sanen te, arrti tacana basarurrü, arrüna cuara au tomiquianene, y arrümanu tomiquianene chüpuerurrüpü aiñotochema. ");
INSERT INTO caxNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Arrti Tuparrü icüpurutiti maniqui taman ñoñünrrü, nürirrti Juan Bautista. ");
INSERT INTO caxNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Arrti Juan cuati uraboiti nürirrti Cristo, naqui ñemanauncurratoe basarurrü ümo macrirrtianuca, nauqui aicocoromati namanaiña. ");
INSERT INTO caxNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Arrti Juan chütonentipü manu basarurrü. Pero cuati uraboiti manu basarurrü, o sea urapoiti nürirrti Cristo. ");
INSERT INTO caxNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Arrti Cristo, naqui ñemanauncurratoe basarurrü, iñataiti icu na cürrü, nauqui anentarrü ümo bama aboma icu. ");
INSERT INTO caxNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sane nauquiche cuati icu na cürrü, abu nisamucurrti na cürrü. Tapü arrübama pohoso icu na cürrü chisuputaramatipü, abu uiti urriancama. ");
INSERT INTO caxNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iñataiti au na propiorrü nisamucurrti, pero arrübama ipiarientetorrti chiyasuriurumatipü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero aboma bama yasuriurumati. Oncomatü ümoti. Torrio üriacaboma uiti, nauqui aisamunumacü aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iyebo uimia sane itopiqui torrio ümoma uiti Tuparrü, champürrtü ui arrüna aboma icu na cürrü ni ui nirrancarrti taman ñoñünrrü, ta uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Así que arrti Cristo, naqui nürirrtito “Nurarrti Tuparrü” isamunutiyü ñoñünrrü. Anancati uyarrüpecu. Arrüsomü sumarrtai nüriacarrti y nicusüurrti, arrüna torrio ümoti uiti Tuparrü, itopiqui tonenti Aütorrti Tuparrti. Somoncoito ñanitacarrti ñemanauncurratoe, y uitito tusio nibuenucurrti Tuparrü oemo. Tusio ito uiti arrüna nucua ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Arrti Juan urapoiti nürirrti Cristo, nanti: —Tonenti naqui üriche arrüna sucanañü: Cuatiqui isiuñü naqui ane manrrü nüriacarrti rropünanaquiñü, itopiqui numo chiyacapüqui icu na cürrü, arrti tanancatiatai. ");
INSERT INTO caxNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Namanaiña oñü basutio arrüba omirria macumanataca mecuquiti ui nucua ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Arrüna nüriacarrü torrio oemo uiti Tuparrü mecuquiti Moisés tücañe, pero caüma uiti Jesucristo tusio oemo nucua ümoti Tuparrü y arrüna ñemanauncurratoe manunecatarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Champüti naqui tasaratiti Tuparrü, cunauntañatiatai naqui Aütorrti, itopiqui anati ichepeti. Uitito usuputacati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Arrümanuma israelitarrü au Jerusalén bacüpuruma ümo manuma sacerdoterrü y ümo manuma levitarrü, anquirioma pünanaquiti Juan isane nacarrti, arrtü Cristoti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pero arrti urapoiti nurria isucarüma, nanti: —Arrüñü champürrtü Cristoñü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Auqui ñanquitioma tatito pünanaquiti: —¿Ñacucümo? ¿Arrücü profetarrü Elías? Aiñumuti Juan: —Champürrtü arrüñü. Así que ñanquitioma tatito pünanaquiti: —¿Taqui arrücü maniqui profetarrü, arrti maniqui sopipiate que tiene que ayetitü? Aiñumuti tatito Juan, nanti: —Champürrtü arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Auqui namatü ümoti: —¿Ñacucümo? Itopiqui tiene que someno tato suburaboi isucarü bama uiche aicüpuruma somü. ¿Isane arrüna puerurrücü uraboi suisucarü acütüpücüatoe? ");
INSERT INTO caxNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Auqui iñumutati Juan, nanti: —Arrüñü naqui ümoche manitanati tücañe profetarrü Isaías, nauquiche maconomonoti sane: “Anati naqui tosibicoti eana rroense, nanti: Apiyaübu besüro cutubiurrü cümenuti Señor”. ");
INSERT INTO caxNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Arrümanuma yebomatü anitama aübuti Juan bacüpucurrü ümoma ui manuma fariseorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sane nauquiche manrrü ñanquiquirrimia pünanaquiti Juan, namatü: —Arrtü chütüpü Cristocü, ni Elías pücü, ni arrtipü maniqui profetarrü, ¿causane aunimia ümo genterrü? ");
INSERT INTO caxNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nanti Juan: —Arrüñü rraunimiaca ui turrtai, pero auna abarrüpecu anati maniqui taman chapisuputacatiquipü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Contoatai matoconoti ichoboñü. Arrüñü champü isane niyaca ni yaserebipü pario nauqui isoquisüna nehe nisapaturrti, itopiqui tarucu nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nanaiña arrüna pasabo au manu cürrü nürirri Betábara topü manu sapoco Jordán, auna cauta anancati Juan maunimianati tücañe. ");
INSERT INTO caxNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Au quiatarrü nanenese arrti Juan asaratitü cümenuti Jesús, cuatati esati. Auqui nanti Juan: —Tonenti naqui torrioti uiti Tuparrü oemo, tacana arrone nobirrama arrüna uiche morrimiacana tato nomünantü ui macrirrtianuca icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tonenti te naqui üriche arrüna sucanañü: “Cuatiqui isiuñü naqui ane manrrü nüriacarrti rropünanaquiñü, itopiqui arrti anancatiatai rropünanaquiñü”. ");
INSERT INTO caxNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Numo sucanañü arrüna sane, chisuputacatiquipü. Pero isecatü rraunimia ui turrü, nauqui asuputaramati bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nantito Juan: —Arrüñü yasacati Espíritu Santo cuati auqui napese tacana naca nututaquimia, üro onüti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tücañe chütusiopü iñemo arrtü tonenti, pero arrti Tuparrü naqui uiche aicüpuruñü nauqui rraunimia ui turrü, turapoiticaü tücañe isucarüñü: “Arrtü asacatü ümoti Espíritu Santo üroti onüti taman ñoñünrrü, ta tonenti maniqui maunimianabo uiti Espíritu Santo”. ");
INSERT INTO caxNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chauqui tiyarrtai —nanti Juan— y suraboira ito ausucarü, ta tonenti naqui Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Au quiatarrü nanenese arrti Juan anancati tatito acamanu ichepe manuma torrü ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Arrti Jesús pasaoti auqui manu. Auqui arrti Juan nanti ümo bama ñanunecasarrti: —Amasasatü, tonenti naqui torrioti oemo uiti Tuparrü tacana arrone nobirrama, arrüna coiñobo uitobo. ");
INSERT INTO caxNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Arrümanuma torrü ñanunecasarrti Juan oncoimia arrümanu nurarrti, auqui süromatü isiuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Arrti Jesús asarati tato chacuti. Asaratitü ümo manuma torrü, nanti ümoma: —¿Isane naurriantümo? Arrüma namatü: —Maestro, ¿cauta napo? ");
INSERT INTO caxNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aiñumuti Jesús: —Ausiapata amasarai. Auqui süromatü isiuti asaraimia arrüna cauta bavivicoti. Aboma ichepeti auqui las cuatro isiu nimümürrü hasta chepe suma. ");
INSERT INTO caxNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tamanti uturuqui manuma torrü, Andrés nürirrti, tonenti yaruquitorrti Simón. ");
INSERT INTO caxNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sürotitü esati. Nanti ümoti: —Tütabücoti soboi maniqui Mesías, arrti maniqui Cristo. ");
INSERT INTO caxNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Auqui iquianatitito esati Jesús. Numo tasaratitü Jesús ümoti Simón, nanti ümoti: —Arrücü Simóncü, aütorrti Jonás. Pero caüma süro üribocü sobi Pedro. Arrüna nuevurrü nürirrti nantü auqui besüro “Canrrü”. ");
INSERT INTO caxNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Au quiatarrü nanenese arrti Jesús rranrrti ariorrti tato au manu cürrü Galilea. Auqui icuñunutiti Felipe, nanti ümoti: —Ariacu isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Arrti Felipe auqui manu pueblurrü nürirri Betsaida. Tone nipueblurrtito Andrés y arrti Pedro. ");
INSERT INTO caxNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Arrti Felipe caüma sürotitü apacheriurutiti Natanael. Nauquiche tütabücoti uiti, nanti ümoti: —Tütabücoti soboi maniqui Cristo, naqui icütüpüche maconomonoti Moisés yucu libruca nesa nüriacarrü, y arrübama ito profetarrü tücañe. Arrti Jesús, tonenti aütorrti José auqui manu pueblurrü Nazaret. ");
INSERT INTO caxNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aiñumuti Natanael, nanti: —¿Aensapü puerurrü ane na salibo urria auqui Nazaret? Aiñumuti Felipe: —Ane. Supian, ariacu asabori. ");
INSERT INTO caxNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nauquiche asaratitü Jesús cümenuti Natanael, nanti: —Auna nacarrti naqui taman ñemanauncurratoe israelitarrü, naqui chipiacapü encaña. ");
INSERT INTO caxNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tiñataiti Natanael esati Jesús. Auqui ñanquitioti pünanaquiti: —¿Causane asuputarañü? Aiñumuti Jesús: —One nauquiche chatasucaiquipü uiti Felipe, tiyasacü iquiana manu suese higuera. ");
INSERT INTO caxNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Auqui nanti Natanael ümoti: —Maestro, arrücü Aütorrti Tuparrü. Arrücü te yüriaburrücü ümo bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aiñumuti Jesús: —Taicococañü itopiqui sucanañü aemo, que yasacü iquiana manu suese higuera. Pero arrtaiqui ñana arrüba manrrü yarusürürrü milagrorrü sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Auqui nanti tatito Jesús: —Ñemanauncurratoe sucanañü aume: Arraño amarrtaiqui ñana napese aurübo, y arrübama angelerrü cuamatü esaquiti Tuparrü auqui napese acü yesañü, y yesaquiñü süroma tato au napese, ta arrüñü Ñemanauncurratoe Ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Numo tübupasao trerrü naneneca, auqui ane tübübürrü au manu pueblurrü Caná au manu cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Arrti Jesús ichepe bama ñanunecasarrti tasuruma ito ümo manu tübübürrü. Acamanu ananca ito nipiacütoti. ");
INSERT INTO caxNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cümuinta manu pierrta cüpüro vinorrü. Auqui nantü nipiacütoti Jesús ümoti: —Chauqui tücüpüro vinorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Arrti Jesús iñumutati nurarrü, nanti: —Arrücü paürrü, ¿causane asiquia isuatañü aübu arrüna nura sane? Chiñataiquipü niyesa horarrü, nauqui rrayura. ");
INSERT INTO caxNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Auqui nantü nipiacütoti ümo bama mamosoca acamanu: —¡Apicoco caüma arrtü bacüpuru aume! ");
INSERT INTO caxNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Amonquio acamanu seirri parropeca posürümanaca, arrüba ubataso nantarrü oboi cien litro turrü cada taman. Abe acamanu nauqui arrübimia bama israelitarrü tacana arrüna bacüpucurrü ui nüriacarrü uiti Moisés. ");
INSERT INTO caxNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Auqui nanti Jesús ümo bama mamosoca: —¡Apiñatamacasio ba seirri parropeca ui turrü! Arrüma iñatamacanioma nurria. ");
INSERT INTO caxNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Auqui nanti Jesús ümoma: —Aparrüquia onüqui, simiantai. Amecosi apichamanati maniqui encargabo ümo na pierrta. Sane isamutema. ");
INSERT INTO caxNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Arrti maniqui encargabo ümo manu pierrta ñacontenti manu tuma, chauqui tisamunü vinorrü. Chütusiopü ümoti auquiche manu vinorrü, tapü bama mamosoca tusio ümoma. Sane nauquiche arrti maniqui encargabo yabirotiti maniqui aübo apoti, ");
INSERT INTO caxNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nanti ümoti: —Nantarrü machamaca primero arrüna mejor vinorrü. Arrtü tüchaboma chama bama bapaseara, auqui caüma machamaca ito arrüna vinorrü nurichurrtai. Tapü arrücü hasta auritarrü anancaiqui ahüburu obi arrüna mejor vinorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tone arrüna primer milagrorrü isamutenti Jesús au Caná, au manu cürrü Galilea. Ui arrüna sane itusiancatati nüriacarrti isucarü bama ñanunecasarrti, y arrüma masamuña aicocoromati nurria. ");
INSERT INTO caxNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Auquimanu sürotitü Jesús au manu pueblurrü Capernaum aübu nipiacütoti y aübu bama yaruquitorrti y aübu bama ñanunecasarrti. Acamanu amoncoma ñome manio naneneca. ");
INSERT INTO caxNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Numo tüsaimia manu pierrta parrcua, arrti Jesús sürotitü au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iñataiti au pueblurrü. Sürotitü au niporrti Tuparrü. Acamanu tabücoma uiti manuma mapabentecana buyeca, nobirraca y nututaquiquia. Aboma ito bama macampiara monirri ümo genterrü ñacumanataboma ümoti Tuparrü. Aboma tümonsoma esa nimensarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Numo tarrtaiti Jesús arrüna sane, masamunuti taman chücotirri sogarrü. Ipirrumuniontiño manio numuquianca buyeca, nobirraca auqui niporrti Tuparrü. Ipemünacaniontiño nimensarrüma manuma ñacampiaraca monirri, yaruriompurutiño ito manio ficharrü uimia. ");
INSERT INTO caxNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nanti ümo bama mañapabentecaca nututaquiquia: —Apiquiaübusio auquina arrüba. Tapü apiñata niporrti Iyaü tacana mercadorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Auqui manu arrübama ñanunecasarrti aquionomacü iyo manu nurarrti Tuparrü icu Nicororrü: “Arrübama macrirrtianuca tüboricoma iñemo, itopiqui tarucapae nirranca rrocüma itacu niporrti Tuparrü”. ");
INSERT INTO caxNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Auqui arrübama israelitarrü ñanquitioma pünanaquiti Jesús, namatü: —¿Uiche puerurrü atusi suiñemo arrtü ane nüriaca nauqui aisamune arrüna sane? Aitusianca suisucarü señarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aiñumuti Jesús: —Apiñarrimiaca arrüna niporrti Tuparrü, arrüñü iñatünaiñacata tato au trerrü naneneca. ");
INSERT INTO caxNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tapü arrüma iñumutama, namatü: —Cuarenta y seirri añoca yatrabacacarrüma nauqui urriane uimia arrüna niporrti Tuparrü. ¿Taqui puerurrü atürai tato obi au trerratai naneneca? ");
INSERT INTO caxNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero arrüna nurarrti champürrtü ümo manu niporrti Tuparrü au Jerusalén, ta ümo nicütüpürrtiatoe. Ichepecatati aübu niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sane nauquiche numo tüsüboricoti tato Jesús eanaqui macoiñoca yubau manio trerrü naneneca, arrübama ñanunecasarrti aquionomacü iyo arrümanu nurarrti tücañe au niporrti Tuparrü. Auqui caüma icocotama nurria arrüna nantü icu Nicororrü icütüpüti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nauquiche anancati Jesús au Jerusalén ümo manu pierrta parrcua, sürümanama icocoromati, itopiqui arrtaimia arrüba milagorrü omirriante uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero arrti Jesús siemprerrü ane ñaquioncorrti ñünanama, itopiqui isuputacaiti nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Champü nümocheti naqui uiche uraboi isucarüti causane nisüboriqui macrirrtianuca, itopiqui arrti tusiatai ümoti arrüna ñapensacarrüma au nitusirrimia. ");
INSERT INTO caxNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anati au Jerusalén maniqui taman ñoñünrrü fariseorrü, nürirrti Nicodemo. Arrti tamanti eanaqui bama üriatu bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Arrti naqui Nicodemo taman tobirri yebotitü apasearatiti Jesús. Nanti ümoti: —Maestro, tusio suiñemo que ta uiti Bae Tuparrü aicüpurutiyü nauqui aiñununecana somü. Itopiqui champüti puerurrü asamuti arrüba milagrorrü uirrtiatoe tacana arrüba obi, arrtü champüti Tuparrü ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Auqui nanti Jesús ümoti: —Ñemanauncurratoe suraboira asucarücü: Tiene que anantito usaca icu cürrü, tacana arrüna numo aübo usaca, arrtü urrianca aye osoi esati Tuparrü, auna cauta üriabucati. ");
INSERT INTO caxNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aiñumuti Nicodemo, nanti: —¿Aensapü puerurrü nauqui anantito usaca icu cürrü, arrtü tusunaunca? ¿Taqui puerurrti ñoñünrrü aüroti tatito icübobi nipiacütoti, nauqui anantito anati icu cürrü? ");
INSERT INTO caxNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Auqui nanti Jesús ümoti: —Ñemanauncurratoe sucanañü aemo: Ui nusaca icu cürrü chüpuerurrüpü uiñanai esati Tuparrü, auna cauta üriabucati. Tiene que basurio osüboriquibo uiti Espíritu Santo. Tone arrüna tacana aübo usaca tatito icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Usaca icu cürrü aübu cürrü nocütüpü. Tapü arrüna ñemanauncurratoe nosüboriqui torrio oemo uiti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tapü acütobüca ui arrüna nisura sane aemo: “Tiene que usaca tatito icu cürrü”. ");
INSERT INTO caxNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Arrüna sane isiu tacana maquiütürrü, chütusiopü oemo auquiche ayetü, ni cautapü niyücürrü. Sürotü isiu nirrancarrü. Solamenterratai oñoncoi nisüurrü. Sane into pasao uiti Espíritu Santo, arrtü torrio uiti arrüna ñemanauncurratoe osüboriquibo. ");
INSERT INTO caxNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Causane arrüna sane? —nanti Nicodemo. ");
INSERT INTO caxNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Arrti Jesús iñumutati: —Arrücü chaübopü nanunecaca ümo bama israelitarrü. ¿Causane chütusiopü aemo arrüna sane? ");
INSERT INTO caxNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ñemanauncurratoe sucanañü aemo: Arrüsomü supanitate arrüna tusio suiñemo. Suburapoi arrüna sumarrtai. Pero arraño chapicocotapü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Arrtü chapiococotapü nirranitaca yocütüpü arrüba abe icu na cürrü, ¿causanempü nauqui apicoco arrüna arrtü surapoi ausucarü arrüna ane au napese? ");
INSERT INTO caxNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‛Champüti ñoñünrrü naqui yebotitü au napese icuqui na cürrü nauqui atusi ümoti. Arrüñü Ñemanauncurratoe Ñoñünrrü, anancañü au napese. Auqui ta isetü icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Arrti Moisés tücañe, anancati au manu rroense, iñatati manu noirroborrü yerurrü apü taman suese, nauqui urrianama tato macrirrtianuca bama maunrrocono. Sane ito arrüñü tiene que aiñanamañü apü suese ñana. ");
INSERT INTO caxNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Auqui caüma namanaiña bama icocoromañü torrio ümoma isüboriquiboma, arrüna chütacürusupü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‛Tarucu nucua ümoti Tuparrü. Sane nauquiche icüpurutiti naqui tamantai Aütorrti. Namanaiña bama icocoromati chensoropü nausüpürrüma, y chütacürusupü nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Itopiqui arrti Tuparrü champürrtü icüpurutiñü nauqui yache carrticurrü ümo macrirrtianuca icu cürrü, ta nauqui ataesübuma sobi eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","‛Sane nauquiche arrti naqui oncotitü iñemo, chücarrtigabotipü. Tapü arrti naqui choncotitüpü iñemo, chauqui tütusio que cuatü ümoti carrticurrü, itopiqui chirranrrtipü aicocorotiti naqui tamantai Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Arrübama chicocoropümañü ane carrticurrü ümoma. Itopiqui cuatü manu basarurrü icu na cürrü, pero arrüma manrrü urria ümoma tomiquianene pünanaqui nanentarrü, itopiqui isamutema arrüba nomünantü. (Arrümanu basarurrü, tonenti Cristo; tapü arrümanu tomiquianene, tone arrüba nomünantü icu na cürru.) ");
INSERT INTO caxNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Namanaiña bama isamutema arrüna churriampü, tüboricomantai icuata manu basarurrü, y chüsüropümatü esa ui nirrancarrüma tapü tusio arrüna churriampatai nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tapü arrübama isamutema arrüna ñemanauncurratoe urria, süromatü esa manu basarurrü (esati Cristo), nauqui atusi que urria nisamutema ui yayuracarrti Tuparrü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Auqui manu arrti Jesús bapasearati au manu cürrü Judea ichepe bama ñanunecasarrti. Anancati acamanu ñome manio naneneca, maunimianati ichepema. ");
INSERT INTO caxNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Arrti Juan anancati maunimianatito au manu nürirri Enón, saimia Salim, itopiqui acamanu ane chama turrü. Arrümanuma macrirrtianuca süromatü acamanu esati nauqui ürimia uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Arrüna pasabo sane numo champürrtü tiñanamati Juan au preso. ");
INSERT INTO caxNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Auqui aboma bama uturuqui manuma ñanunecasarrti Juan, uratoquioma ümoti maniqui taman israelitarrü yotopiqui arrümanio bacüpucuca ümoma ui nüriacarrü nauqui atopimia y arrübimia. ");
INSERT INTO caxNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sane nauquiche süromatü esati Juan uraboimia isucarüti, namatü ümoti: —Maestro, aquioncü iyoti maniqui ñoñünrrü anancati aesacü taha topü sapoco Jordán. Urapoi aucutanu nürirrti suisucarü. Arrti maniqui ñoñünrrü maunimianatito caüma, y namanaiña macrirrtianuca süromatü taha esati. ");
INSERT INTO caxNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Auqui iñumutati Juan, nanti: —Nanaiña arrüna ane osoi torrio oemo uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Arraño amoncoi nurria nisura que arrüñü chütüpü Cristoñü. Arrüñü isecatü isusürü suraboi nürirrti. ");
INSERT INTO caxNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Arrti Cristo tacanati naqui rranrrü apo, tapü genterrü ta tacana arrüna cupiquirri aübuche rranrrti apoti. Arrüñü tacanati naqui nesarrti amigorrü. Arrti naqui anati aübu manu cupiquirri arrtü ane tübübürrü, tonenti naqui iquiana. Arrti naqui esarrti amigorrü anati acamanu, pucünuñati ui nurarrti naqui itübübüche. Sane into arrüñü caüma tarucu nipucünuncu. ");
INSERT INTO caxNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Urria arrtü ane manrrü nüriacarrti rropünanaquiñü. Tapü arrüñü tari champü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nantito Juan: —Arrti naqui cuabotü auqui napese ane manrrü nüriacarrti ümo nanaiña. Tapü arrüñü yaca icuqui nantai cürrü; ñapensaca y rranitaca ito tacana arrübama icuqui nantai cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tapü arrti Cristo cuati auqui napese. Urapoiti ausucarü arrüna arrtaiti y oncoiti taha. Pero arraño chapicocotapü nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero arrübama icocotama tonema bama tusio ümoma ta ñemanauncurratoe nanaiña arrüna urapoiti Jesús ta tone nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Arrti cuati ui yacüpucurrti Tuparrü. Urapoiti ausucarü nurarrti, itopiqui arrti Tuparrü chauqui ticüpurutiti Espíritu Santo auti aübu nanaiña nicusüurrti. ");
INSERT INTO caxNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cuasürüti ümoti Yaütoti. Torrio üriacaboti ümo nanaiña arrüna ane. ");
INSERT INTO caxNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Namanaiña bama icocoromati naqui Aütorrti Tuparrü tütusio ümoma ta chütacürüsüpü nisüboriquirrimia. Tapü arrübama chirranrrüpüma aicocoromati, chüpuerurrüpü aye uimia au napese. Más bien arrüna nitüborirrti Tuparrü ümoma chüpuerurrüpü atacüru. ");
INSERT INTO caxNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Arrti Jesús champürrtü tonenti naqui maunimiana, ta arrübama ñanunecasarrti. Pero arrübama fariseorrü oncoimia que manrrü nubiquirrimia bama süromatü esati Jesús pünanaqui bama süromatü esati Juan. ");
INSERT INTO caxNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Numo ipiatenti Jesús que tütusio ümoma, sürotitito auqui Judea, niyücürrti tato au Galilea. ");
INSERT INTO caxNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Au manu viajerrü pasaoti auqui manu cürrü nürirri Samaria. ");
INSERT INTO caxNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Au manu cürrü iñataiti saimia manu taman pueblurrü nürirri Sicar, esa manu ñanaunrrü torrio tücañe uiti Jacob ümoti José naqui aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Acamanu ane manu taman noria, nürirri “Jacob”. Arrti Jesús iñataiti acamanu esa. Batacheboti ui namenrrti, sane nauquiche tümonsoti acamanu. Chauqui tütoce. ");
INSERT INTO caxNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Tapü arrübama ñanunecasarrti süromatü au pueblurrü acomporama utuburiboma. Auqui iñatai taman paürru auqui Samaria esa manu noria, nauqui arrüquian turrü. Arrti Jesús nanti ümo: —Ache iñemo tuma. ");
INSERT INTO caxNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aiñumu manu paürrü: —¿Causane anqui turrü rropünanaquiñü, abu arrücü israelitarrücü, tapü arrüñü samaritanarrüñü? Itopiqui arrübama israelitarrü champürrtü urria uimia ümo bama samaritanorrü, chümanitanapüma aübuma. ");
INSERT INTO caxNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Auqui arrti Jesús iñumutati: —Chütusiopü aemo isane arrüna ñacumanatarrti Tuparrü aemo, ni atusipü aemo ñacuti naqui manquio tuma apünanaquicü. Arrtü nampü tusio aemo, anquiquiapü tuma rropünanaquiñü, arrüna bachebo osüboriquibo, auquipü caüma yacheca aemo. ");
INSERT INTO caxNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Auqui nantü manu paürrü ümoti Jesús: —Señor, champü obi arrüna uiche acaübu turrü tanene y arrüna noria otüsa. ¿Causanempü obi nauqui aichamanañü arrüna turrü bachebo osüboriquibo? ");
INSERT INTO caxNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Suipiariente Jacob tücañe oncono uirri suiñemo arrüna noria. Auqui tücañe chabo tuma yupu nanaiña ba naütaiqui y nanaiña niyaburrü numuquianca. ¿Aensapü ane manrrü nüriaca pünanaqui? ");
INSERT INTO caxNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Arrti Jesús nanti: —Namanaiña bama chabo na turrü auqui na noria tosüoma tatito. ");
INSERT INTO caxNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero arrti naqui chabo na turrü torrio sobi, chanantopü atosüti tato. Arrüna turrü torrio sobi isamunü tacana arrone nantaiturrü auti naqui chabo, chücüpüropü. Arrüna turrü bachebo isüboriquiboti, arrüna chütacürusupü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Señor, ache iñemo manu turrü —nantü manu paürrü—, tapü ananto ichosü tato, nauqui tapü yasiquia isetato ñarrüquia auqui na noria. ");
INSERT INTO caxNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nanti Jesús: —Acosi apacheriuruti aiquianü y aiquiarrti tauna. ");
INSERT INTO caxNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Champü niquianañü —nantü manu paürrü. Nanti tatito Jesús ümo: —Ñemanauntu te arrüna ucanü, que champüti aiquianü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Itopiqui amoncoma cincoma aiquianü, pero ta chapocapü ni aübutipü maniqui anati caüma aesacü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nauquiche toncoi arrüna sane, arrümanu paurrü nantü: —Señor, canapae profetarrücü, nanaiña tusio aemo. ");
INSERT INTO caxNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Arrüba nirruputaiqui tücañe opiñanaunta Nupu Tuparrü auna onü na yiriturrü, tapü arraño ba israelitarrü amucanaño que tiene que uiñanaun au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aiñumuti Jesús, nanti: —Aicocosoñü paürrü, cuatiqui manu auche ñana iñanaunumati Tuparrü ni aunampüatai onü na yiriturrü, ni aupüatai Jerusalén, sino au nanaiñantai. ");
INSERT INTO caxNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Arraño samaritanorrü chapisuputacatipü Tuparrü, naqui ümoche apanaun, tapü arrüsomü israelitarrü sopisuputacati, itopiqui arrti naqui uiche taesüburuma macrirrtianuca eanaqui nomünantü cuati eanaqui bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tirranrrü aiñanai manu tiemporrü auche iñanaunumati Tuparrü bien ñemanauncurratoe aübu nanaiña nausasürrüma ui yayuracarrti Espíritu Santo, champü nümoche arrüna cauta. ");
INSERT INTO caxNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Arrti Tuparrü pururrü Espíritu nacarrti. Sane nauquiche tiene que uiñanaunuti aübu nanaiña noesa espíritu y ui yayuracarrti Espíritu Santo. Tone caüma ñemanauncurratoe numanauncu ümoti. Sanen te nirrancarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Auqui nantü manu paürrü: —Tusio te iñemo que cuatü manu uiche utaesübu eanaqui nomünantü, arrümanu Mesías arrüna nürirrto Cristo. Arrtü cuatü, uirri uraboi nanaiña suisucarü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aiñumuti Jesús: —Unca arrüñümo Cristo. ");
INSERT INTO caxNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Au manu rratorrü iñataimia tato bama ñanunecasarrti. Cütobüsoma ui na arrtaimia baparioti Jesús aübu paürrü. Pero champüti naqui ñanquitio pünanaquiti isane nirrantümo, o isane arrüna nipiarirrti aübu. ");
INSERT INTO caxNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Auqui arrümanu paürrü iñocota niyahusürrü y süro tato au pueblurrü uraboi isucarü macrirrtianuca, nantü sane: ");
INSERT INTO caxNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ausiapata amasarai nanta taman noñünrrü, urapoi isucarüñü nanaiña arrüna nisamute. ¿Taqui chitonempü Cristo? ");
INSERT INTO caxNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Auqui süromatü manuma macrirrtianuca auqui pueblurrü, auna cauta anancati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Arrübama ñanunecasarrti namatü ümoti: —Maestro, ariacu aha. ");
INSERT INTO caxNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero arrti nanti ümoma: —Arrüñü ane rrutuburibo arrüna chapisuputacaipü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Arrübama ñanunecasarrti ñanquitioma pünanaquimiantoe, namatü: —¿Taqui anati naqui uiche acanti tauna utuburiboti? ");
INSERT INTO caxNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero arrti nanti ümoma: —Tone rrutuburiboñü, arrüna arrtü isamute yacüpucurrti Tuparrü, naqui icüpurutiñü, nauqui itacünucu arrüna trabacorrü torrio iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Caüma namatü macrirrtianuca: “Sürotiqui cuatro panca, nauqui mata trigo”. Pero arrüñü sucanañü aume: “Amasasio ñanaunca, chauqui tupubo trigo, turria nauqui mata. (Machepecatarrü arrüna sane. Arrüna trigo upubo tacana bama sürümana macrirrtianuca, rranrrüma onsaperioma nurarrti Tuparrü.) ");
INSERT INTO caxNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Arrti naqui batrabacara ümo cosecharrü, torrio ümoti bapacatarrü itobo. Tapü arrüna cosecharrü arrüna matanati, tone tacana bama sürümanama macrirrtianuca torrio ümoma isüboriquiboma arrüna chütacürusupü. Sane nauquiche arrti naqui mancüturu tücañe y arrti naqui matana, juntorrü pucünuñama. ");
INSERT INTO caxNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pero ñemanauntu te arrüna manitacarrü nantü sane: “Tamanti mancüturuti, tapüti quiatarrü matanati”. ");
INSERT INTO caxNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Icüpucaño apata au ba ñanaunca cauta mancüturuma bama maquiataca. (O sea, icüpucaño aburaboi nisüri isucarü bama macrirrtianuca chauqui toncoimia nürirrti Tuparrü ui bama manitana tücañe au nürirrti.) ");
INSERT INTO caxNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sürümanama bama pohoso au manu pueblurrü icocoromati Jesús, ui nura manu paürrü, numo urapoi isucarüma: “Arrüna noñünrrü urapoi isucarüñü nanaiña arrüna pasabo sobi”. ");
INSERT INTO caxNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nauquiche iñataimia esati, ñanquitioma pünanaquiti nauqui asioti acamanu ichepema. Así que anati ichepema torrü naneneca. ");
INSERT INTO caxNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Manrrü nubiquirrimia caüma bama icocoromati, numo oncoimia nurria turuquitiatoe arrüna nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Namatü ümo manu paürrü: —Caümampae sopicococati champürrtü ui arrüna urapoi suisucarü, si no ui arrüna somoncoi nurarrtiatoe. Caüma tusio nurria suiñemo ta tonenti Cristo, naqui uiche taesüburuma macrirtianuca icuqui na cürrü eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iyau manio torrü naneneca sürotitito Jesús auqui manu pueblurrü, niyücürrti au manu cürrü Galilea. ");
INSERT INTO caxNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chauqui turapoiti Jesús, que arrti taman profetarrü chücuasürütipü au na nicürrtiatoe. ");
INSERT INTO caxNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero nauquiche iñataiti au Galilea, arrübama pohoso acamanu yasuriurumati nurria, itopiqui yebomatito ümo manu pierrta parrcua au Jerusalén. Taha arrtaimia nanaiña arrüna isamutenti au manu pierrta. ");
INSERT INTO caxNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iñataiti tato au manu pueblurrü Caná au manu cürrü Galilea, auna cautatücaü isamunü vinorrü turrü uiti. Ane manu quiatarrü pueblurrü saimia Caná, nürirri Capernaum. Taha anati maniqui taman ñoñünrrü batrabacarati ümoti yüriaburrü. Anatito aütorrti naqui maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nauquiche tütusio ümoti maniqui ñoñünrrü, que arrti Jesús tiñataiti tato auqui Judea, sürotitü asaratiti au Caná. Acamanu nanti ümoti: —Ariacu au nipo nauqui aicurarati isaü, itopiqui tüsayapae aconti. ");
INSERT INTO caxNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Auqui nanti Jesús ümoti: —Arraño chapicococapüñü, arrtü chamarrtaipü arrüba milagrorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Auqui nanti maniqui ñoñünrru ümoti: —¡Señor, ariacu conto, antes que aconti isaü! ");
INSERT INTO caxNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Acosi tato au napo —nanti Jesús ümoti—, arrti ahü turrian tato ümoti. Arrti maniqui ñoñünrrü icocotati manu nurarrti Jesús ümoti, süroti tato. ");
INSERT INTO caxNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nauquiche tanati tato saimia niporrti, cuamatü bama imostorrti cümenuti, namatü ümoti: —Arrti ahü chauqui turriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Auqui ñanquitioti pünanaquimia isane horarrü urrian tato ümoti. Namatü: —Tümüca a la una isiü nimümürrü apasa nipiacütaiquirrti. ");
INSERT INTO caxNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Au manu rratorrü tusiatai ümoti maniqui ñoñünrrü uiche apasa nipiacütaiquirrti aütorrti, itopiqui au manu horarrü tücañe nanti Jesús ümoti: “Arrti ahü chauqui turrian tato ümoti”. Auqui manu caüma icocorotiti Jesús aübu nanaiña bama nesarrti familiarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tone arrüna segundo milagrorrü uiti Jesús, nauquiche iñataiti tato au Galilea auqui Judea. ");
INSERT INTO caxNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Omenotü naneneca. Auqui arrti Jesús süroti tatito au Jerusalén, itopiqui ane quiatarrü pierrta taha. ");
INSERT INTO caxNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Au manu pueblurrü, saimia manu tururrü nürirri “nituru nobirraca” ane manu turrü nürirri Betesda. Sane nürirri auqui nura bama israelitarrü. Esa manu turrü abe cinco poca posürümanaca chümutauncunupü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Au manio poca aboma barücüroma sürümanama bama maunrrocono, bama supusuma, bama chüpuerurrüpü amema, bama bosübo nitaparrüma y nipiarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Barrüperarama ümo nipococo turrü, itopiqui ane nauche cuati taman ángel auqui napese, y pocoro turrü uiti. Auqui caüma arrti naqui sürotü acusürüti eana manu turrü, urriancati tato, champü nümoche isane naca norrocorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eana manuma maunrrocono anancati maniqui taman ñoñünrrü, tütabe treinta y ocho añoca ñaunrrococorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Arrti Jesús pasaoti auquimanu. Asaratitü ümoti maniqui maunrrocono, anati barücüroti. Ipiatenti Jesús que tücoboi manu norrocorrü ümoti. Auqui ñanquitioti pünanaquiti, nanti: —¿Arrianca urrianü tato? ");
INSERT INTO caxNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aiñumuti maniqui maunrrocono, nanti: —Señor, champüti naqui uiche aiñanatiñü eana turrü, arrtü pocoro. Arrtü yecatü ñana, tanati quiatarrü acusürüti rropünanaquiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Auqui nanti Jesús ümoti: —¡Atüsai, asusiu nacüru, acosi tato au napo! ");
INSERT INTO caxNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Au manu rratorrü arrti maniqui maunrrocono urriancati tato. Yasutiuti nicürurrti, amencoti. Arrüna sane pasao au taman nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sane nauquiche arrübama israelitarrü namatü ümoti maniqui urriancati tato: —Caüma na nanenese nesa macansacarrü, churriampü aiquia nacüru. ");
INSERT INTO caxNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aiñumuti, nanti ümoma: —Arrti naqui uiche urrianañü tato nanti iñemo: “Aiquia nacüru, acosi tato au napo”. ");
INSERT INTO caxNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ñanquitioma pünanaquiti: —¿Ñacuti maniqui nanti sane aemo? ");
INSERT INTO caxNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Arrti maniqui ñoñünrrü chütusiopü ümoti ñacuti naqui uiche urrianati tato, itopiqui arrti Jesús iñensonoconotiyü arrüpecuqui manu cütüpürrü genterrü acamanu. ");
INSERT INTO caxNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Auquimanu arrti Jesús icuñunutiti au niporrti Tuparrü maniqui urriancati tato uiti, nanti ümoti: —Onsoi nurria, chauqui turriancü tato. Tapü asiquia aisamune arrüba nomünantü, nauqui tapü aunrrococa tatito manrrü tarucapae. ");
INSERT INTO caxNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Auqui sürotitü maniqui ñoñünrrü uraboiti isucarü bama israelitarrü, que uiti Jesús urrianati tato. ");
INSERT INTO caxNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Auqui manu caüma arrübama israelitarrü aboma isiuti Jesús nirrancarrüma aitabairomati, itopiqui bacurarati au na nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero arrti nanti ümoma: —Arrti Iyaü siemprerrü anati batrabacarati, arrüñü isamute isiatai. ");
INSERT INTO caxNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ui arrüna sane nurarrti, manrrü nirrancarrüma aitabairomati. Ünantü ümoma arrüna chicocotatipü arrümanu nanenese nesa macansacarrü. Pero manrrtai nitüborirrimia ümoti ui arrüna urapoiti que arrti Tuparrü tonenti Yaütoti. Itopiqui ui arrüna nurarrti sane urapoiti que Tuparrtito. ");
INSERT INTO caxNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Auqui nanti Jesús ümoma: —Arrüñü Aütorrti Tuparrü, champürrtü rratrabacaca ui niñuñemantoe, ta rratrabacaca ui nuñemarrti Iyaü. Itopiqui nanaiña arrüna yarrtai isamutenti Iyaü, arrüñü isamute ito isiuquiti. ");
INSERT INTO caxNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Arrti Iyaü itusiancatati isucarüñü nanaiña arrüna isamutenti, itopiqui isuasürüca ümoti. Uiti isamute ñana arrüba manrrü yarusürürrü milagrorrü, uiche aucütobüca nurria. ");
INSERT INTO caxNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Arrti Iyaü masümoniancanati tato ümo bama coiño, bacheboti isüboriquiboma. Isiatai arrüñü ñasümoniancaca ito ümo bama urria au niyasata. ");
INSERT INTO caxNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Iñocotati nanaiña nüriacarrü iñemo. Arrüñü caüma rracurrtaca aübu bama macrirrtianuca, champürrtü arrti. ");
INSERT INTO caxNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Sane nauquiche iñanaunumañü macrirrtianuca isiatai tacana ñanauncurrüma ümoti Iyaü. Arrübama chiñanaunumapüñü, chiñanaunumatipito Iyaü, naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‛Ñemanauncurratoe sucanañü aume, arrti naqui onsapetioti nisura y icocorotiti naqui uiche aicüpuruñü, torrio ümoti isüboriquiboti arrüna chütacürusupü. Chücarrtigabotipito, itopiqui chauqui tüpasaoti auqui concorrü ümo süboriquirri. ");
INSERT INTO caxNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sucanañü aume, tirranrrü aiñanai manu tiemporrü auche oncoimia nisura bama coiño, y arrübama icocoromañü süboricoma tato. ");
INSERT INTO caxNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Arrti Iyaü ane nüriacarrti nauqui acheti osüboriquibo. Sane ito torrio iñemo isüriacaboñü uiti, nauqui sobi süboricoma macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Torrio ito iñemo isüriacaboñü nauqui rracurrta aübu macrirrtianuca, itopiqui arrüñü Ñemanauncurratoe Ñoñünrrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tapü aucütobüca ui arrüna sane nisura, itopiqui contoatai iñatai manu horarrü arrüna auche namanaiña bama coiño oncoimia nirrabiqui. ");
INSERT INTO caxNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Atüraimia tato auqui na cauta süroma cütu tücañe. Arrübama isamutema arrüna urria numo süboricomainqui, atüraimia tato nauqui asüborimia ichepeñü. Tapü arrübama isamutema arrüna nomünantü, atüraimia tato nauqui asuriuma carrticurrü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‛Arrüñü champü isane puerurrü isamune ui niñuñemantoe. Rracurrtaca isiu yacüpucurrti Iyaü iñemo. Ñemanauncurratoe nirracurrtaca, itopiqui champürrtü iñata isiu naca nirranca, ta isiu nirrancarrti naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Arrtü rranitaca ichacuñüantoe, chüvaleopü nisura. ");
INSERT INTO caxNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero anati quiatarrü naqui manitanati ichacuñü, arrti Iyaü. Tusio te iñemo, que valeo arrümanu nurarrti iñemo, itopiqui bien ñemanauncurratoe. ");
INSERT INTO caxNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Arraño apacüpuca tücañe coreorrü esati Juan Bautista. Arrüna nurarrti isütüpüñü ta bien ñemanauntu. ");
INSERT INTO caxNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero arrüñü champürrtü ñoncatü ümoti ñoñünrrü nauqui anitati ichacuñü. Surapoi ausucarü arrüna sane nauqui apicocoroñü y nauqui autaesübu eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ñemanauntu, arrti Juan anancati tacana arrone basarurrü icu na cürrü, y arraño aupucünunca baeta ui nanentacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero arrüñü ane quiatarrü terrticurrü iñemo, arrüna manrrü urria pünanaqui ñanitacarrti Juan: Ta arrüba milagrorrü omirriante sobi au nürirrti Iyaü, toneion tacana terrticurrü iñemo. Oboi te tusio aume ta ñemanauntu nisura, y ta isecatü ui yacüpucurrti Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Arrti Iyaü, naqui uiche aicüpuruñü, tonenti terrticurrtito iñemo. Arraño champürrtü amasacati, ni amoncoipü ñanitacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Chüpuerurrüpü apicoco nurarrti, itopiqui chapicococapüñü, abu uiti aicüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Arraño tarucu lehebo año icuqui Nicororrü uiti Tuparrü. Napaquioncopü que uirri iyebo aboi nausüboriqui au napese, arrüna chütacürusupü. Tai iñemo arrüna corobo icu Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero arraño chaurriancapü abetü yesañü, nauqui yache ausüboriquibo. ");
INSERT INTO caxNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‛Champürrtü yapacheca niquiubuñü nauqui urriantai nura macirrtianuca iñemo, ta irranca nauqui urria ñaquioncorrti Tuparrü saübuñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero isuputacaño nurria, tusio iñemo, ta chücuasürütipü Tuparrü aume. ");
INSERT INTO caxNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Isecatü aume au nürirrti Iyaü, pero arraño chapasuquiucapüñü. Pero arrtü cuatati quiatarrü naqui ui nuñemarrtiatoe, ta apasuquiucati. ");
INSERT INTO caxNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Arraño aurrianca nauqui urriantai ñanitacarrüma macrirrtianuca aume. Pero champü nümoche aboi arrüna ñapensacarrti Tuparrü. Uirri arrüna chüpuerurrüpü apicoco nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Napaquionco que suracaño isucarüti naqui Iyaü, abu chüsanempü. Anati quiatarrü naqui uiche urabaño, tonenti Moisés, naqui ümoche amoncatü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arrtü nampü apicocota nurarrti Moisés, apicococapüñü ito, itopiqui arrti maconomonoti tücañe isütüpüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero chapicocotapü nurarrti, sane nauquiche chüpuerurrüpito apicoco nisura. ");
INSERT INTO caxNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Auqui arrti Jesús sürotitü topü manu narubaitu turrü au manu currü Galilea. Arrümanu turrü nürirrito “Turrü nesa Tiberias”. ");
INSERT INTO caxNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cütüpürrü macrirrtianuca süromatü isiuti, itopiqui arrtaimia manio milagrorrü omirriante uiti y nurriancarrüma tato bama maunrrocono. ");
INSERT INTO caxNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Auqui sürotitü onü manu yiriturrü. Acamanu tümonsoti ichepe bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chauqui tüsaimia manu pierrta parrcua. ");
INSERT INTO caxNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nauquiche asaratitü cümenu manuma sürümana macrirrtianuca, bama cuamatü isiuti, nanti ümoti Felipe: —¿Auquiche caüma aye osoi utuburibo nanaiña na genterrü? ");
INSERT INTO caxNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nanti sane Jesús, itopiqui rranrrti asaraiti causane uiti Felipe. Abu tusiatai ümoti arrüna urriantamoebo uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Auqui iñumutati Felipe: —Arrtü anempü osoi doscientos denarios puerurrüpü pario macompora pan, nauqui bachepü taiquiana peasomantai ümo cadati taman. ");
INSERT INTO caxNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Auqui nanti Andrés, yaruquitorrti Simón Pedro, naqui tamantito eanaqui bama ñanunecasarrti Jesús: ");
INSERT INTO caxNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Auna anati taman ñaüma, abe uiti cinco pan y torrü nopiocomanca, pero quiubupito aiñanai ümo na cütüpürrü genterrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Auqui nanti Jesús: —Aburasoi isucarüma nauqui atümoma acü. Auqui tümonsoma manuma macrirrtianuca onü borrü. Nubiquirrimia taqui cinco mil mañoñüncatai (abe ito paüca y masiomanca). ");
INSERT INTO caxNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Auqui arrti Jesús yasuriurutiño manio cinco pan, machampiencanati ümoti Tuparrü. Itorrimianatiño ümo bama ñanunecasarrti, nauqui atocoma aitorrimianioma ümo bama aboma tümonso acamanu. Sane ito isamutenti yupu manio nopiocomanca. Iñatai ümo namanaiña. ");
INSERT INTO caxNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Numo tabecoma, nanti Jesús ümo bama ñanunecasarrti: —Apitacümanauncusiu arrüba peasomanca bosobürao, tapü ane arrüna ensoro. ");
INSERT INTO caxNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Arrüma isamutema sane. Ubataso uimia doce noconoca ui yopeastu manio cinco pan. ");
INSERT INTO caxNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Numo tarrtai genterrü arrüna milagrorrü urriante uiti Jesús, namatü: —Tonenti naqui profetarrü, naqui cümenuche nubarrüperaca, naqui cuabotü icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Auqui arrti Jesús tusiatai ümoti, que arrüma rranrrüma au nacarrtai ümoma aiñanamati ümo yüriaburrti. Sane nauquiche iquiaüburutiyü auqui manu, süroti tatito tamanti onü manu yiriturrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Numo tirranrrü ütobi arrümanuma ñanunecasarrti süromatü abeu narubaitu turrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Süromatü au taman barco isuqui turrü, niyücürrüma au Capernaum. Chauqui tütomiquianene y arrti Jesús champürrtü tiñataiti tato. ");
INSERT INTO caxNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Auqui caüma maquiütüca fuerte, tarucapae nipococo turrü, basupiuru tape. ");
INSERT INTO caxNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chauqui taboma taqui cinco o seirri kilómetros pünanaqui nabeurrü. Rrepenteatai asaramatü cümenuti Jesús cuati sane ümo na cauta ane barco aübuma. Amencoti isuqui turrü. ¡Arrone nurria nirrucurrüma! ");
INSERT INTO caxNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero arrti Jesús nanti ümoma: —Tapü aupirruca, ta arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Auqui arrüma pucünuñama nurria. Yasuriurumati au barco, y au anu orratorrü tiñataimia au na cauta niyücürrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Au quiatarrü nanenese arrümanuma macrirrtianuca manuma oncono topü manu turrü, tusio ümoma que arrübama ñanunecasarrti Jesús süromatü isuqui turrü au manu tamantai barco arrüna ananca acamanu. Tusio ito ümoma, que arrti Jesús champürrtü sürotitü ichepema. ");
INSERT INTO caxNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Auqui caüma opiñatai piquiataca barcoca auqui Tiberias. Opiñatai saimia manu cauta tücañe machampiencanatito Jesús yobitobo pan y basoma ito. ");
INSERT INTO caxNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nauquiche chütabücotipü Jesús uimia acamanu, ni arrübamapü ñanunecasarrti, süromatü ubau manio barco. Tompücana uimia manu turrü, iñataimia au Capernaum. Acamanu yapacheriurumati. ");
INSERT INTO caxNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Acamanu tabücoti uimia. Ñanquitioma pünanaquiti, namatü: —¿Maestro, auche aiñanai auna? ");
INSERT INTO caxNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Auqui nanti Jesús ümoma: —Ñemanauncurratoe sucanañü aume, arraño apapachequiucañü itopiqui aubaca sobi ichepe nababe, champürrtü itopiqui arrüna tusio aume isane nümochio arrüba milagrorrü omirriante sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tapü apapacheca amutuburibo arrüna contoatai tacürusu, apapache amutuburibo arrüna ururau, arrüna bachebo süboriquirri arrüna champü nitacürurrü. Arrüñü Ñemanauncurratoe Ñoñünrrü, tone arrüna yacheca aume, itopiqui torrio isüriacabo uiti Tuparrü nauqui isamune sane. ");
INSERT INTO caxNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Auqui ñanquitioma pünanaquiti: —¿Causane soboi, nauqui sopisamune arrüna urria ümoti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aiñumuti Jesús: —Cunauntañatai arrüna nirrantümoti Tuparrü: Apicocosoñü itopiqui uiti te aicüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Arrüma caüma namatü: —¿Isane señarrü puerurrü aitusianca suisucarü nauqui sumasarai y nauqui sopicocorü? ¿Isane arrüna puerurrücü aisamune suisucarü? ");
INSERT INTO caxNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Arrübama uyaütaiqui tücañe basoma manu pan nürirri maná numo amoncoma eana manu rroense pururrü cüosorrü y canca. Sanen te nantü icu Nicororrü: “Arrti Moisés bacheboti ümoma manu pan auqui napese utuburiboma”. ");
INSERT INTO caxNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aiñumuti Jesús: —Ñemanauncurratoe sucanañü aume, champürrtü arrti Moisés naqui bacheboti pan utuburiboma auqui napese, ta arrti Tuparrü, naqui Iyaü. Arrtito caüma rranrrti acheti aume arrüna ñemanauncurratoe pan auqui napese. ");
INSERT INTO caxNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Itopiqui arrüna pan bacheboti Tuparrü, tonenti naqui cuati auqui napese auna acü, nauqui acheti isüboriquibo bama macrirrtianuca icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Auqui namatü ümoti: —Señor, ache nantarrü suiñemo manu pan, suirranca ümo. ");
INSERT INTO caxNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Arrti Jesús iñumutati nurarrüma, nanti: —Ichepecacañü tacana manu pan bachebo ausüboriquibo. Arrti naqui cuati yesañü chüpuerurrüpü acürüpüti, y arrti naqui icocoroñü chüperurrüpü atosüti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero chauqui tüsucanañü aume, arraño amasacañü, pero chapicococapüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Namanaiña bama cuamatü yesañü ui yacüpucurrti naqui Iyaü, yasuquiucama. Chipenecapüma. ");
INSERT INTO caxNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Chisecapütü auqui napese, nauqui isamune arrüna isiu nirranca, sino nauqui isamune arrüna isiu nirrancarrti naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tone arrüna nirrancarrti Iyaü iñemo, tapü anati naqui ensoro rropünanaquiñü uturuqui bama torrioma iñemo uiti. Más bien süboricoma tato sobi au manu tacürurrü nanenese. ");
INSERT INTO caxNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Arrti Iyaü rranrrti nauqui asüborimia ümo para siemprerrü namanaiña bama asaramañü y icocoromañü. Au manu tacürurrü nanenese isümoniancacama ito tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Auqui arrübama israelitarrü tüboricoma ümoti Jesús ui manu nurarrti, itopiqui nanti: “Arrüñü arrümanu pan cuatü auqui napese”. ");
INSERT INTO caxNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Namatü: —¿Acaso chitonentipü Jesús naqui aütorrti José? Usuputacati te yaütoti y nipiacütoti. ¿Causane uraboiti, que cuati auqui napese? ");
INSERT INTO caxNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Auqui nanti Jesús: —¿Causane ünantü aume arrüna nisura? ");
INSERT INTO caxNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Champüti naqui puerurrü aicocorotinü, arrtü chübacüpucurrüpü uiti Iyaü ümoti, naqui uiche aicüpuruñü. Sobi isümoniancanama tato ñana au manu tacürurrü nanenese. ");
INSERT INTO caxNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Arrübama profetarrü tücañe maconomonoma sane: “Arrti Tuparrü manunecanati ümo namanaiña”. Sane nauquiche namanaiña bama onsapetio nurarrti Tuparrü y icocotama, cuamatü yesañü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‛Pero champüti naqui tasaratiti naqui Iyaü, cunauntañañüantai arrüñü yasacati, itopiqui isecatü esaquiti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ñemanauncurratoe sucanañü aume, arrti naqui icocoroñü champü nitacüru nisüboriquirrti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Arrüñü manu pan bachebo ausüboriquibo. ");
INSERT INTO caxNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Arrübama antiburrü uyaütaiqui tücañe basoma arrümanu pan maná au manu narubaitu rroense, pero coiñoma ito. ");
INSERT INTO caxNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero arrüñü rranitaca ümo manu pan cuatü auqui napese. Arrti naqui iñatenti, chütacürusupü nisüboriquirrti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Arrüñü te manu pan cuatü auqui napese, arrüna bachebo süboriquirri. Arrti naqui baso manu pan, torrio ümoti isüboriquiboti arrüna chütacürusupü. Arrüna pan yacheca, tone arrüna propiorrü nirrañetu. Itorrimiata isüboriquibo bama icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ui arrüna nurarrti Jesús uratoquioma ümomantoe bama israelitarrü. Namatü: —¿Causane acheti uñutuburibo arrüna nañeturrti? ");
INSERT INTO caxNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Auqui nanti Jesús ümoma: —Ñemanauncurratoe sucanañü aume, arrüñu, Ñemanauncurratoe Ñoñünrrü: Arrtü chaubacapü nirrañetu y chapichapautapü niñoto, chüpuerurrüpü atorri aume ausüboriquibo au napese. ");
INSERT INTO caxNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Arrti naqui basoti nirrañetu y chaboti niñoto, ane nisüboriquirrti ümo para siemprerrü y isümoniancacati tato au manu tacürurrü nanenese. ");
INSERT INTO caxNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Itopiqui arrüna nirrañetu es ñemanauncurratoe comirarrü, y arrüna niñoto ñemanauncurratoe tüporrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Arrti naqui iñatenti nirrañetu y ichapautati niñoto, süboricoti ichepeñü, y arrüñü ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Arrüñü isüboriquia uiti Iyaü naqui uiche ane süboriquirri. Uiti aicüpurutiñü. Sane ito arrübama iñatema nirrañetu süboricoma sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Así que tone arrüna pan cuatü auqui napese, ta arrüñü. Chisiupü tacana manu maná tücañe arrüna basoma bama uyaütaiqui eana narubaitu rroense. Itopiqui arrüma coiñoma namanaiña. Pero arrti naqui baso arrüna pan torrio sobi, süboricoti ümo para siemprerrü. ");
INSERT INTO caxNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nanaiña arrüna sane manunecanati Jesús au manu porrü sinagoga au Capernaum. ");
INSERT INTO caxNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sürümanama uturuqui manuma amenco ichepeti Jesús oncoimia arrüna sane, auqui namatü: —Cuerrtarrapae arrüna manunecatarrü, chüpuerurrüpü basuriu. ");
INSERT INTO caxNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Arrti Jesús tütusiatai ümoti que champürrtü urria ümoma ñanunecacarrti. Auqui ñanquitioti pünanaquimia: —¿Arraño ünantü aume arrüna nisura, saon? ");
INSERT INTO caxNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aburañopü sane arrtü amasacatü isiuñü niyücü tato esati Tuparrü, arrüna auquiche isetü? ");
INSERT INTO caxNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Solamenterrü uiti Espíritu Santo ane nosüboriqui esati Tuparrü. Arrüna cürrü nocütüpü chüpuerurrüpü aye uirri. Rranitaca aume uiti Espíritu Santo, nauqui ane ausüboriquibo arrüna ñemanauncurratoe. ");
INSERT INTO caxNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero aboma bama abarrüpecu chicocotapüma nisura. Itopiqui arrti Jesús tusio nurria ümoti ñacu bama eanaquimia chicocotapüma, y ñacuti naqui uiche aipiabentecanati ñana. ");
INSERT INTO caxNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Auqui nanti tatito ümoma: —Sane nauquiche surapoi one ausucarü, champüti naqui puerurrü aicocoroñü, arrtü chübacüpucurrüpü uiti Iyaü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Auquimanu sürümanama bama amenco ichepeti Jesús iñoconomati, champürrtü amencomainqui ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Auqui ñanquitioti Jesús pünanaqui manuma doce ñanunecasarrti: —¿Carü año, causane aboi? Aurrianca ito apiñoconoñü? ");
INSERT INTO caxNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Auqui arrti Simón Pedro iñumutati, nanti: —Señor, ¿quitipü naqui esache somenotü? Tamancüatai. Arrüna nura tone uiche ñemanauncurratoe suisüboriquia. ");
INSERT INTO caxNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Arrüsomü chauqui tisopicococü, tusio suiñemo ta arrücü Cristo, naqui Aütorrti Tuparrü naqui süborico. ");
INSERT INTO caxNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Auqui nanti Jesús ümoma: —Sobi te itacümanauncunaño, arraño bama doce. Pero tamanti abarrüpecuqui anati choborese auti. ");
INSERT INTO caxNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Arrümanu sane nurarrti Jesús ta ümoti maniqui Judas Iscariote, naqui aütorrti Simón, itopiqui arrti tümapensarati aipiabentecanatiti Jesús, abu arrtito tamanti eanaqui manuma doce ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Numo tüpasao arrüna sane, arrti Jesús amencoti au manu cürrü Galilea. Chirranrrtipü asioti au Judea, itopiqui acamanu arrümanuma israelitarrü rranrrüma aitabairomati. ");
INSERT INTO caxNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero tüsaimia manu pierrta nürirri “cüpahumanca”. Tone taman omeanaqui ba pierrtaca urriante ui bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sane nauquiche arrübama yaruquitorrti Jesús namatü ümoti: —Tapü asiquia auna, acosi au Judea nauqui asaraimia bama anunecasa taha arrüna urrantamoebo obi. ");
INSERT INTO caxNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Itopiqui arrti naqui rranrrü nauqui asuputaramati macrirrtianuca, chüpuerurrüpü nauqui anecanatai yatrabacacarrti. Arrtü arrianca aisamune arrüna trabacorrü y arrüba milagrorrü, aisamuse isucarü nanaiña genterrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Taipü ni arrübamapü yaruquitorrti aicocoma que Cristoti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Auqui nanti Jesús ümoma: —Chiñataiquipü niyesa horarrü. Tapü arraño, cualquierarrü horarrü urria aume. ");
INSERT INTO caxNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Arrübama macrirrtianuca icu na cürrü chüpuerurrüpü atüborimiantai aucuata, pero isuatañü tüboricomantai, itopiqui nantarrtai surapoi isucarüma, arrüna churriampü nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amecosi arraño ümo na pierrta; arrüñü chiyecapütü auchepe, itopiqui chiñataiquipü niyesa horarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sane nurarrti ümoma y süsioti au Galilea. ");
INSERT INTO caxNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero nauquiche tüsüromatü manuma yaruquitorrti, arrti Jesús sürotitito au Jerusalén ümo pierrta. Pero anecanatai arrüna niyücürrti, chütusiopü ümo genterrü arrtü arrti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Auqui arrümanuma israelitarrü yapacheriurumati au manu pierrta au Jerusalén, namatü: —¿Cautapü nacarrti maniqui ñoñünrrü? ");
INSERT INTO caxNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Arrüpecu manuma macrirrtianuca sürümanama bama bapario iyoti. Aboma bama namatü: “Arrti maniqui ñoñünrrü bien buenurrti”. Pero maquiataca namatü: “Champürrtü buenurrti, itopiqui encañaoti ümo macrirrtianuca”. ");
INSERT INTO caxNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero anecanatai arrümanu nurarrüma iyoti, itopiqui birrubuma ñünana bama maquiataca israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Taboma cümuinta manu pierrta. Auqui sürotitü Jesús au niporrti Tuparrü anunecati. ");
INSERT INTO caxNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Cütobüsoma manuma israelitarrü, namatü: —¿Causane tarucu ñapanauncurrti naqui ñoñünrrü, abu champürrtü estudiaboti? ");
INSERT INTO caxNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Auqui aiñumuti Jesús, nanti: —Arrüna nirranunecaca champürrtü nirranunecacatoe, ta ñanunecacarrti naqui uiche aicüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Arrti naqui rranrrti aisamunenti isiu nirrancarrti Tuparrü, tonenti naqui tusio ümoti arrtü sobiatoe arrüna nirranunecaca, o arrtü uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Arrti naqui manitana auqui nuñemarrtiatoe, bapacherotiatai nauqui acuasürüti ümo genterrü. Tapü arrti naqui bapacheroti nauqui acuasürüti ümoti naqui uiche aicüpurutiti, tonenti naqui ümoche puerurrü oñoncatü. Chipiacatipü apanti y champü isane aübuti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‛Ñemanauntu te uiti Moisés tücañe torrio arrüna nüriacarrü. Pero champüti abarrüpecu naqui icocota arrüna nüriacarrü. ¿Causane aurrianca apitabairoñü? ");
INSERT INTO caxNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Locorrücü —namatü bama macrirrtianuca ümoti—, canapae anati choborese aucü. ¿Quitipü naqui rranrrü aitabairü? ");
INSERT INTO caxNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aiñumuti Jesús: —Tamantai milagrorrü urriante sobi au nanenese nesa macansacarrü, y nanaiña año aucütobüca uirri. ");
INSERT INTO caxNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero arraño ito apatrabacaca au nanenese nesa macansacarrü, arrtü tocabo circuncidaboti taman ñaüma aboi. Arrti Moisés bacüpuruti nauqui circuncidaboma mañaümanca arrtü tütabe ocho naneneca nacarrüma icu cürrü. Abu champürrtü uiti Moisés manu bacüpucurrü ümo circuncición, ta uiti Tuparrü ümoti Abraham manrrü tücañeampae. ");
INSERT INTO caxNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sane nauquiche circuncidaboma bama mañaümanca tütabe ocho naneneca nacarrüma icu cürrü au na nanenese nesa macansacarrü, nauqui acoco nurria yacüpucurrti Moisés. ¿Causane autübori iñemo itopiqui arrüna urriantato sobi enterurrü nicütüpürrti taman ñoñünrrü au nanenese nesa macansacarrü? ");
INSERT INTO caxNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tapü amonsapequio arrüba mapancaca, más bien apicoco arrüna ñemanauntu, nauqui urria napapensaca. ");
INSERT INTO caxNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Eanaqui manuma pohoso au Jerusalén aboma bama namatü: —Amasasai, tonenti naqui iyoche yapachequirrimia nauqui aitabairomati. ");
INSERT INTO caxNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Auna anati, manunecanati isucarü nanaiña genterrü, y champü causane uimia ümoti. ¿Aensapü ticocotama bama mayüriabuca, que tonenti Cristo, naqui ümoche nubarrüperaca? ");
INSERT INTO caxNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero arroñü te tusio oemo arrüna auquicheti. Tapürrtü cuati maniqui ñemanauncurratoe Cristo, ta champüti naqui tusio ümoti auquiche ayeti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Arrti Jesús anancati manunecanati au niporrti Tuparrü. Auqui manitanati fuerte nurria, nanti sane: —¡Así que apisuputacañü, y tusio aume arrüna auquiche isetü! Pero chisecapütü ui niñuñemantoe, ta isecatü ui yacüpucurrti Tuparrü. Ümoti puerurrü oñoncatü. Pero arraño chapisuputacatipü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Arrüñü isuputacati nurria, itopiqui isecatü esaquiti, uiti aicüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Auqui rranrrüpüma aiquianamati au preso. Pero champüti naqui iñenotiti, itopiqui chiñataiquipü manu horarrü ensümunu uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero sürümanama eana manu genterrü icocoromati, namatü: —Arrtü cuati Cristo, ¿taqui masamunuti manrrü arrüba milagrorrü pünanaquiti naqui ñoñünrrü? ");
INSERT INTO caxNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Arrümanuma fariseorrü oncoimia nipiarirrimia manuma macrirrtianuca iyoti Jesús. Auqui arrüma ichepe bama üriatu bama sacerdoterrü bacüpuruma ümo bama policiarrü auqui niporrti Tuparrü, nauqui aiquianamati Jesús au preso. ");
INSERT INTO caxNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Arrti Jesús nanti ümo genterrü: —Yaca auna auchepe ñome ba mümanantai naneneca. Auqui yeca tato esati naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Arraño tiene que apapacheriuruñü, pero chüpuerurrüpü ichabü aboi, itopiqui chüpuerurrüpü amenotü isiuñü auna cauta niyücü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Auqui arrümanuma israelitarrü ñanquitioma pünanaquimiantoe, namatü: —¿Cautapü niyücürrti naqui, nauqui chüpuerurrüpü atabüti osoi? ¿Taqui rranrrti ariorrti esa bama israelitarrü bama iñarriomantai eana bama griegorrü, nauqui anunecati ümoma, y ümo bama griegorrü? ");
INSERT INTO caxNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Isanempü ümoche arrüna nanti sane oemo: “Apapachequiucañü, pero chüpuerurrüpü ichabü aboi, itopiqui chüpuerurrüpü amenotü auna cauta niyücü?” ");
INSERT INTO caxNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Arrümanu tacürurrü nanenese nesa pierrta manrrü yarusürürrü pierrta. Au manu nanenese atüraiti Jesús isucarü macrirrtianuca, anitati fuerte, nanti: —Arrti naqui tosüo, tari yebati yesañü y chaboti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ausiapata aucha yesañü, namanaiña bama apicococañü. Ta sane nantü icu Nicororrü: “Osüro auqui nausasürrüma tacana turrü arrüna bachebo süboriquirri”. ");
INSERT INTO caxNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Manitanati Jesús icütüpüti Espíritu Santo naqui cuabotü au nausasürrüma bama icocoromati Jesús. Arrti Espíritu Santo tonenti tacana manu turrü bachebo osüboriquibo. Itopiqui au manu tiemporrü champürrtü tiyasuriurumati Espíritu Santo, ni tiyebotitüpü tato Jesús esa nanentacarrti Tuparrü au napese. ");
INSERT INTO caxNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sürümanama eana manu genterrü oncoimia arrüna sane nurarrti, namatü: —Ñemanauntu te, arrti naqui ñoñünrrü tonenti maniqui profetarrü, naqui coboi oñoncoi tiene que ayeti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Maquiataca namatü: —Tonenti Cristo, naqui ensümunu ayeti uiti Tuparrü. Maquiataca namatü: —No, arrti Cristo chüpuerurrüpü ayeti auqui Galilea. ");
INSERT INTO caxNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nantü te icu Nicororrü que arrti Cristo cuati eanaqui nesarrti familiarrü David, y tiene que anati icu cürrü au Belén, auna cauta pohosoti tücañe David. ");
INSERT INTO caxNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sane nauquiche chichepepü ñapensacarrüma manuma macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aboma bama rranrrüma aiquianamati au preso, pero champüti naqui puerurrü aiñenotiti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Arrümanuma policiarrü auqui niporrti Tuparrü basücübücoma tato esa manuma fariseorrü y arrümanuma üriatu bama sacerdoterrü. Arrüma ñanquitioma pünanaquimia: —¿Causane chücuatatipü aboi? ");
INSERT INTO caxNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aiñumuma manuma policiarrü: —Champü tütanati naqui manitana tacana nurarrti maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Auqui namatü manuma fariseorrü ümoma: —Así que arraño ito apichücaño, nauqui encañati aume. ");
INSERT INTO caxNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Acaso aboma bama icocoromati uturuqui bama mayüriabuca y arrübama fariseorrü? ¡No, ni tamantipü! ");
INSERT INTO caxNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Pero arrübama macrirrtianuca icocoromati itopiqui chisuputacaipüma nüriacarrü, tari paunrramanama! ");
INSERT INTO caxNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Acamanu anancatito Nicodemo, naqui yebotü tücañe apasearatiti Jesús au tobirri. Arrti fariseorrti. Arrti nanti ümo bama maquiataca fariseorrü: ");
INSERT INTO caxNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Nantü sane nüriacarrü: Chüpuerurrüpü bache carrticurrü ümoti taman, arrtü chübacurrtacapü nurria primero aübuti, nauqui atusi arrüna arrtü ane nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Arrüma iñumutama: —¡Canapae arrücü ito auqui Galilea, saon! Lehebocü te pario Nicororrü, na atusi aemo chüpuerurrüpü anati profetarrü auqui Galilea. ");
INSERT INTO caxNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Auqui süromatü auquimanu, cadati taman süroti tato au niporrti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tapü arrti Jesús sürotitü onü manu yiriturrü nürirri Olivos. ");
INSERT INTO caxNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tansürü quiatarrü nanenese basücübücoti tato au niporrti Tuparrü. Nanaiña manu genterrü cuatü esati. Tümonsoti acamanu, na anunecati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Auqui iñataimia acamanu bama maestro ümo nüriacarrü ichepe manuma fariseorrü. Cuatü uimia taman paürrü, arrüna tabüco uimia aübuti quiatarrü ñoñünrrü. Süro uimia cümuinta manu genterrü esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Auqui namatü ümoti Jesús: —Maestro, arrüna paürrü tabüco soboi, ananca aübuti quiatarrü ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nantü nüriacarrü uiti Moisés, arrüna paürrü sane nisüboriquirri tiene que barurui oboi canca nauqui aco osoi. ¿O uracü sane? ");
INSERT INTO caxNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ui arrüna ñanquitioma sane pünanaquiti, ñacocotorrüma ümoti, nauqui puerurrü urabomati. Tapü arrti Jesús mataconoconoti, y maconomonoti acü ui neherrti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Arrüma ñanquitioma tatito pünanaquiti. Auqui atüraiti, nanti ümoma: —Arrti naqui champü nomünantü uiti abuturuqui, tari cusürüboti aruruiti na paürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Auqui mataconoconoti tatito, seguibo ñaconomocorrti acü ui neherrti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Numo toncoimia arrüna nurarrti ümoma, masamuña aüroma tato auqui manu taiquianati taman, cusürüboma bama manrrü tüyarusürürrüma. Onconoti Jesús acamanu aübu manu paürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Auqui atüraiti tato, nanti ümo manu paürrü: —¿Cauta nacarrüma? ¿Champüti naqui uiche carrtigabocü? ");
INSERT INTO caxNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Champü, Señor —nantü manu paürrü. —Bueno —nanti Jesús ümo—, ni sobipito carrtigabocü. Acosi tato au napo, tapü ananto sane obi aisamune arrüna churriampü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Auqui manitanati tatito ümo manuma macrirrtianuca, nanti ümoma: —Arrüñü tacana basarurrü ümo macrirrtianuca icu na cürrü. Arrti naqui icocorotiñü ane basarurrü ümoti, arrüna bachebo isüboriquiboti. Chauqui chamencotiquipü au tomiquianene. ");
INSERT INTO caxNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Arrübama fariseorrü namatü ümoti: —Arrücü ta anitaca atacucüatoe, sane nauquiche chüvaleopü arrüna nura. ");
INSERT INTO caxNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aiñumuti Jesús: —Ñemanauntu arrüna nisura. Valeo arrtü rranitaca ichacuñüantoe. Itopiqui tusio iñemo auquiche isetü y cauta niyücü. Tapü arraño chütusiopü aume auquiche isetü, ni cautapü niyücü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Arraño apacurrtaca aübuti quiatarrü isiu napapensaca icuqui nantai cürrü. Arrüñü chiyacurrtacapü aübuti quiatarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Arrtü yacurrtaca aübuti quiatarrü ta ñemanauntu ito niyacurrtaca, itopiqui arrti Iyaü, naqui uiche aicüpuruñü anati ichepeñü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ane arrüna nüriacarrü aboi, nantü sane: Na atusi arrtü ñemanauntu nurarrti taman ñoñünrrü, tiene que aboma bama torrüma o trerrüma bama terrticurrü, bama chepatai nurarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Arrüñü terrticurrüñü iñemoantoe, y arrti Iyaü terrticurrtito iñemo, itopiqui uiti aicüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Cautamo nacarrti aüma? —ñanquitioma pünanaquiti. Nanti Jesús: —Arraño chapisuputacapüñü, ni apisuputaratipito Iyaü. Arrtünampü apisuputacañü, apisuputacatipito naqui Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nanaiña arrüna sane nanti Jesús numo anancati manunecanati au niporrti Tuparrü au manu cauta naca manu baurirri auche aüro monirri macumanatarrü ümoti Tuparrü. Y champüti naqui puerurrü aiquianatiti Jesús au preso, itopiqui chiñataiquipü manu nesarrti horarrü ensümunu uiti Tuparrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nanti tatito Jesús ümoma: —Arrüñü yecatü auquina. Arraño caüma apapachequiucañü, pero chüpuerurrüpü ichabü aboi. Sane nauquiche caüma auconca aübu nanaiña nomünantü aboi. Chüpuerurrüpü aye aboi au na cauta niyücü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Arrübama israelitarrü namatü: —¿Causane nanti chüpuerurrüpü aye osoi auna cauta niyücürrti? ¿Taqui rranrrti aitabairotiyü? ");
INSERT INTO caxNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aiñumuti Jesús: —Arraño te icuqui nantai cürrü. Tapü arrüñü champürrtü icuqui na cürrü. Arrüñü isecatü auqui napese. ");
INSERT INTO caxNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sane nauquiche tüsurapoi ausucarü, que auconca ñana aübu nanaiña nomünantü aboi, itopiqui chaurriancapü apicoco ta arrüñü arrti maniqui üriotü ayetitü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Auqui ñanquitioma pünanaquiti: —¿Ñacucümo? Aiñumuti Jesús, nanti: —Chauqui tüsurapoi ausucarü auqui maübo. ");
INSERT INTO caxNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ane cütüpürrü surapoboiboñü ümo arrüna churriampü napisamute. Pero chüsurapoipü caüma. Solamenterratai surapoi icu na cürrü arrüna nanti iñemo naqui uiche icüpuruñü. Arrüna nurarrti ñemanauncurratoe. ");
INSERT INTO caxNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero arrüma chentienderrüpüma que manitanati icütüpüti Tuparrü, naqui Yaütoti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sane nauquiche nanti ümoma: —Arrtü tapiñacañü apü curusürrü, auqui caüma tusio aume ta arrüñü naqui Cristo, itopiqui champü isane isamute ui niñoñemantoe. Solamenterrtai surapoi ausucarü arrüna ñanunecacarrti Iyaü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Arrti icüpurutiñü auna icu na cürrü, y anati ichepeñü. Champürrtü iñoconotiñü tamanñü, itopiqui isamute arrüna urria ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Numo nanti Jesús arrüna sane, sürümanama macrirrtianuca icocoromati. ");
INSERT INTO caxNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Auqui nanti ümo bama israelitarrü, bama ticocoromati: —Arrtü apiñata nausüboriqui isiuqui arrüna nirranunecaca aume, ñemanauncurratoe nirranunecasa año caüma. ");
INSERT INTO caxNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Auqui ito caüma apisuputacai arrüna ñemanauntu. Ui arrüna ñemanauntu librerrü año, chümosorrüquipü año. ");
INSERT INTO caxNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aiñumuma: —Arrüsomü eanaqui nesarrti familiarrü Abraham tücane, y champü tümosorrü somü. ¿Causane ucanü librerrü somü ñana? Uncamo librerrü somü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Auqui nanti Jesús ümoma: —Ñemanauncurratoe sucanañü aume: Arrti naqui isamutenti nomünantü, mosorrti ümo nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Arrübama mosorrü champü isane nüriacarrüma. Tapü arrti naqui aütorrti patrón torrio ümoti nanaiña üriacaboti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Arrüñü Aütorrti Tuparrüñü. Arrtü autaesübuca sobi eanaqui nomünantü auqui caüma ñemanauncurratoe nautaesübucu. ");
INSERT INTO caxNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tusio te iñemo que arraño eanaqui nesarrti familiarrü Abraham. Pero ta aurrianca apitabairoñü, itopiqui chaurriancapü apasurio nisura. ");
INSERT INTO caxNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Arrüñü surapoi arrüna itusiancatati naqui Iyaü isucarüñü. Sane ito arraño apisamute arrüna amoncoi uiti aubaü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Arrüma iñumutama, namatü: —Arrti naqui suiyaü tücañe, tonenti te Abraham. Nanti Jesús ümoma: —Arrtü nampü ñemanauntu que aubaüti Abraham, apisamutempü isiu arrüna urriante uiti tücañe. ");
INSERT INTO caxNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Isecatü suraboi ausucarü arrüna ñemanauntu manunecatarrü, arrüna ñoncoi uiti Tuparrü. Pero arraño aurrianca apitabairoñü. Arrti Abraham nuncapü aisamunenti arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Arraño apisamute isiu tacana arrüna isamutenti naqui ñemanauncurratoe aubaü. Auqui namatü ümoti Jesús: —Arrüsomü champürrtü aütorrti naqui chüposopü. Anati tamantiatai suiyaü, naqui Bae Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Auqui nanti Jesús ümoma sane: —Arrtüpü ñemanauntu aütorrti Tuparrü año, isuasürücapü aume, itopiqui isecatü esaquiti. Champürrtü isecatü ui niñoñemantoe. Uiti aicüpurutiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Causane chüpuerurrüpü aüro au nautanu arrüna sucanañü aume? Ta ui na te chaurriancapü amoncoi arrüna nisura. ");
INSERT INTO caxNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Arrti aubaü tonenti naqui choborese. Aurrianca apisamune isiu arrüna nirrancarrti. Arrti auqui maübo yatabayorrti. Churriampü ümoti arrüna ñemanauntu nurarrti Tuparrü. Arrtü manitanati, mapañati auqui nuñemarrti, itopiqui ñemanauncurratoe ñapanrrti. Nanaiña arrüba mapancaca icu na cürrü cuantio uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Arrüñü rranitate arrüna ñemanauntu. Sane nauquiche chüpuerurrüpü apicoco. ");
INSERT INTO caxNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Arraño chüpuerurrüpito apitusianca arrtü ane nomünantü sobi. Pero arrüñü surapoi arrüna ñemanauntu. ¿Causane chapicocotapü? ");
INSERT INTO caxNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Arrübama icocoromati Tuparrü pucünuñama arrtü oncoimia nurarrti. Pero arraño champürrtü apicococati. Sane nauquiche chaurriancapü amoncoi nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Auqui namatü manuma israelitarrü ümoti: —Taiquiana sumucana somü nurria aemo, arrücü tacana samaritanorrücü y anati choborese aucü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Arrüñü champüti choborese sauñü —nanti Jesús—. Más bien arrüñü tarucu nirranauncu ümoti Iyaü, pero arraño apuncañü. ");
INSERT INTO caxNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Champürrtü yapacheca niquiubuñü nauqui tarucu ñanauncurrüma macrirrtianuca iñemo. Pero anati quiatarrü naqui bapachero causane nauqui aiñanaunumañü. Arrti te ñemanauncurratoe yacurrtacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ñemanauntu te arrüna sucanañü aume: Arrti naqui macoconaunrrü ümo nisura, chüpuerurrüpü aconti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Aiñumuma manuma israelitarrü: —Chauqui tütusio nurria suiñemo, que anati choborese aucü. Itopiqui arrti Abraham coiñoti, y arrübama profetarrü tücañü coiñoma ito. Pero arrücü ucanü: “Arrti naqui macoconaunrrü ümo nisura, chücoiñotipü”. ");
INSERT INTO caxNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Taqui ane manrrü nüriaca pünanaquiti Abraham, naqui suiyaü? Arrti coiñoti, y bama profetarrü coiñoma ito. ¿Isanempatai arrüna naca auna naquionco? ");
INSERT INTO caxNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Auqui iñumutati Jesús: —Arrtü nampü niñuñemantoepü arrüna nisüriaca, chüvaleopü. Pero anati naqui uiche atorri iñemo isüriacabo, ta uiti Iyaü. Arraño amucanaño que tonenti naqui Autupa. ");
INSERT INTO caxNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero chapisuputacatipü. Arrüñü te isuputacati. Arrtüpü sucanañü que chisuputacatipü, ñapanrrüpüñü ito tacana arraño. Pero ñemanauntu te, isuputacati nurria, icocota nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Arrti Abraham, naqui aubaü tücañe pucünuñati ui yarrüperacarrti isumenuñü. Auqui asaratiñü, pucünuñati. ");
INSERT INTO caxNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Auqui namatü manuma israelitarrü: —Ni tütanempü cincuenta añorrü aemo, ¿causane ucanü que asacati Abraham? ");
INSERT INTO caxNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aiñumuti Jesús: —Ñemanauntu sucanañü aume: Tücañe numo champütiqui Abraham icu na cürrü, arrüñü chauqui tanancañüantai. ");
INSERT INTO caxNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Auqui macanama canca uiche arurumati, nauqui aitabairomati. Pero arrti Jesús iñanecanatiyü ñünanama, pasaoti eanaquimia. Auqui sürotitü türüpo auqui niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nauquiche tüpasaoti Jesús auqui manu, asaratitü ümoti maniqui taman ñoñünrrü naqui supuso auquiapae numo aübo anati icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Arrübama ñanunecasarrti Jesús ñanquitioma pünanaquiti: —¿Maestro, causane anati icu cürrü supusoti naqui ñoñünrrü? ¿Taqui ui nomünantü uiti yaütoti y nipiacütoti, o ui nomünantü uirrtiatoe? ");
INSERT INTO caxNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aiñumuti Jesús: —Champürrtü itopiqui nomünantü uiti, ni itopiquipü nomünantü uiti yaütoti y nipiacütoti. Pasao arrüna ümoti sane, nauqui atusi auquiti arrüna nüriacarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tiene que batrabaca nurria au sapese. Arrtü tütobiquia, chüpuerurrüpüqui batrabaca, saon. Sane ito arrüñü tiene que isamune isiu yacüpucurrti Tuparrü arrtü cheboiqui iñemo isamune yacüpucurrti. Itopiqui cuantioqui manio naneneca auche ñana chüpuerurrüquipü uisamune sane. ");
INSERT INTO caxNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pero mientras yacaiqui icu na cürrü, yaca tacana basarurrü ümo macrirrtianuca, ununecanama sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Isiu manu nurarrti utureuruti acü, masamunuti chimiantai tauma ui manu nutureurrti. Auqui isematati omonü nirrtorrti maniqui supuso. ");
INSERT INTO caxNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nanti ümoti: —¡Atüsai, acosi atasubi au manu turrü nürirri Siloé! Arrümanu Siloé nantü auqui besüro “arrti coreorrü”. Arrti maniqui supuso sürotitü atasubiti au manu turrü. Nauquiche tücuati tato, turria narrtarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Arrübama iposapatarrti y arrübama isuputaramati tücañe numo supusotiqui, ñanquitioma pünanaquimiatoe, namatü: —Canapaemo arrti anaqui ñoñünrrü nantarrtai tümonsoti isiu cutubiurrü ñanquiquirrti limosnarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aboma bama namatü: —¡Uncamo tonenti! Maquiataca namatü: —No, chitonentipü, pero ta isiapae nacarrti. Pero arrti maniqui ñoñünrrü nanti: —Unca arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Auqui ñanquitioma nurria pünanaquiti: —¿Causane nauqui puerurrü asaratü? ");
INSERT INTO caxNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Auqui iñumutati: —Arrti maniqui ñoñünrrü nürirrti Jesús masamunuti tauma. Isematati omonü nisüto. Nanti iñemo: “Acosi atasubi au manu turrü nürirri Siloé”. Auqui yacatü. Numo tiyatasubiqia, auqui yasacatü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Cauta nacarrti maniqui ñoñünrrü? —ñanquitioma pünanaquiti. —Chütusiopü iñemo —nanti ümoma. ");
INSERT INTO caxNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Auqui iquianamati maniqui supuso esa bama fariseorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Itopiqui arrümanu nanenese auche asamuti Jesús tauma, ta au manu nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Arrübama fariseorrü ñanquitioma tatito pünanaquiti, causane nauquiche puerurrü asaratitü. Arrti nanti ümoma: —Bueno, arrti te isematati tauma omonü nisüto. Auqui yatasubiquia, y au manu rratorrü yasacatü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Uturuqui manuma fariseorrü aboma bama namatü: —Arrti maniqui ñoñünrrü Jesús chüpuerurrüpü uiti Tuparrü aicüpurutiti, itopiqui batrabacarati au na nanenese nesa macansacarrü. Pero maquiataca namatü: —¿Causane puerurrti asamuti arrüba milagrorrü, arrtü ane nomünantü uiti? Sane nauquiche chichepepü ñapensacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Auqui ñanquitioma tatito pünanaquiti maniqui supuso tücañe, namatü: —Así que urrian tato nasata uiti. ¿Carücü uracü sane, isane nacarrti maniqui ñoñünrrü? —¡Au nirraquionco sucanañü ta tonenti te profetarrti! —nanti maniqui supuso tücaü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tapü arrümanuma israelitarrü chirranrrüpüma aicocoma arrtü supusoti tücañe maniqui ñoñünrrü, y caüma asaratitü. Sane nauquiche maemencoma iyoti yaütoti y nipiacütoti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Namatü sane ümoma: —¿Ñemanauntu tonenti naqui ahü? ¿Ñemanauntu anati icu cürrü supusoti? ¿Causanemo caüma urria narrtarrti? ");
INSERT INTO caxNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Arrüma iñumutama sane: —Tusio suiñemo que tonenti suisaüti. Anati icu cürrü supusoti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero caüma chütusiopü suiñemo causane nauquiche urria narrtarrti, ni atusipü suiñemo quiti naqui uiche. Apanquisio te pünanaquiti. Arrti te chauqui tüyarusürürrti, y puerurrti uraboiti ausucarü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Namatü sane ui nirrucurrüma ñünana bama üriatu isaraelitarrü. Itopiqui arrübama israelitarrü chauqui turapoimia, tiene que apenema auqui ba sinagoga, namanaiña bama icocotama que arrti Jesús tonenti Cristo. ");
INSERT INTO caxNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sane nauquiche nanti maniqui yaütoti ichepe nipiacütoti: “Apanquisio te pünanaquiti, chauqui tüyarusürürrti”. ");
INSERT INTO caxNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Auqui arrümanuma mayüriabuca itasurumati tatito maniqui ñoñünrrü anancati tücañe supusoti. Namatü ümoti: —Arrti Bae Tuparrü oncoiti nura. Urasoi arrüna ñemanauntu suisucarü. Arrüsomü tusio suiñemo que arrti maniqui ñoñünrrü ane nomünantü uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Auqui aiñumuti maniqui ñoñünrrü: —Chütusiopü iñemo arrtü ane nomünantü uiti, o champü. Pero ta tusio iñemo que anancañü tücañe isupuca, y caüma yasacatü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ñanquitioma tatito pünanaquiti: —¿Causane uiti aemo? ¿Causane nauquiche asacatü? ");
INSERT INTO caxNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aiñumuti tatito, nanti: —Chauqui tüsurapoi ausucarü, pero chapicocotapü. ¿Causane nauqui aurrianca suraboi tatio? ¿Taqui aurrianca ito caüma apisamunaño ñanunecasarrti? ");
INSERT INTO caxNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Auqui unumati, namatü: —Arrücü te ñanunecasarrti maniqui ñoñünrrü, pero arrüsomü ñanunecasarrti Moisés. ");
INSERT INTO caxNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tusio suiñemo que arrti Tuparrü manitanati ümoti Moisés tücañe. Pero arrti naqui ñoñünrrü ni atusipü suiñemo auquicheti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Arrti iñumutati nurarrüma, nanti: —¡Causanemo arrüna sane! Chütusiopü aume auquicheti, abu uiti yasacatü. ");
INSERT INTO caxNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bien tusio oemo que arrti Bae Tuparrü choncoitipü neancarrüma bama ane nomünantü uimia. Cunauntaiña oncoiti neanca bama iñanaunumati y macoconaunrrüma ümo yacüpucurrti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","¡Champü toñoncoi ni auqui ñemoncopü arrüna sane piaracarrü, que asaratitü naqui supuso auqui maübo anati icu currü! ");
INSERT INTO caxNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Arrtü chiniyacüpusurrtipü Tuparrü naqui ñoñünrrü, quiubupü aisamunenti arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Auqui namatü ümoti: —Arrücu ane nomünantü obi auqui numo aübo aca icu currü. ¿Causane arria aiñununecana somü? Auqui penecoti uimia auqui sinagoga. Chüpuerurrtiquipü aiñanaunutiti Tuparrü au ba poca sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Arrti Jesús ipiatenti arrüna tüpenecoti uimia auqui sinagoga. Yapacheriurutiti. Numo ticuñunutiti, nanti ümoti: —¿Aicococati naqui Aütorrti Tuparrü? ");
INSERT INTO caxNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Señor —nanti—, urasoi isucarüñü ñacuti maniqui, nauqui icocoroti. ");
INSERT INTO caxNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aiñumuti Jesús: —Chauqui tasacati, unca arrüñü, naqui aübuche anitaca. ");
INSERT INTO caxNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Auqui arrti maniqui ñoñünrrü bachesoiyoti esati Jesús, manaunuti ümoti. Nanti: —Icococü, Señor. ");
INSERT INTO caxNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nantito Jesús: —Isecatü icu na cürrü nauqui rracurrta. Sobi asarama tato bama supuso y arrübama urria narrtarrüma sobi süsioma tacana supusoma. ");
INSERT INTO caxNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amoncoma acamanu bama fariseorrü, oncoimia nurarrti. Chauqui tütusio ümoma ta ümoma arrümanu machepecatarrü. Ñanquitioma pünanaquiti: —¿Taqui supurrü somü ito au naquionco? ¿Taqui chütusiopü oemo? ");
INSERT INTO caxNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aiñumuti Jesús: —Arrtü nampü supurrü año, champü napipünatempü. Pero arraño amucanaño ta urria nabasata, tusio aume arrüna ñemanauntu. Sane nauquiche caüma querabo año aübu nomüntü aboi. ");
INSERT INTO caxNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Urapoitito Jesús arrüna machepecatarrü apü niyocora nobirraca. Nanti: —Ñemanauncurratoe sucanañü aume: Arrübama macusüpüca y arrübama mayatabayoca chüsüropümampo au corarrü auqui tururrü, ta auqui quiatarrü narücüquirri, apüqui siercu. ");
INSERT INTO caxNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tapü arrti naqui iyabuche sürotipo auqui tururrü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Arrti naqui bacuirara abeu tururrü iyaübutati nauqui aürotipo naqui yabuche. Y arrüba nobirraca yusuputacai nurarrti arrtü yabiriotiño nobürirri taiquiana taman. Y omeno türüpo uiti auqui corarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Arrtü tanaiña omeno türüpo uiti, sürotitü acusürüti yupu. Y arrümanio nobirramanca omenotü isiuti, itopiqui yusuputacai nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero arrtü cuati quiatarrü, chomenopütü isiuti, más bien opesüburu ñünanati, itopiqui chiyusuputaratipü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tone arrüna machepecatarrü urapoiti Jesús isucarü macrirrtianuca, pero arrüma chentienderrüpüma isane arrüna nümoche. ");
INSERT INTO caxNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Auqui manitanati tatito ümoma, nanti: —Arrüñü te tacana manu nituru manu corarrü ñome nobirramanca. Arrübama icocoromañü tonema tacana niyabu nobirramanca. ");
INSERT INTO caxNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Namanaiña bama cusürüboma rropünanaquiñü, tonema bama pururrü macusüpüca y mayatabayoca. Pero arrübama icocoromañü, chonsapetiopüma nurarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Arrüñü tacana tururrü. Arrübama süromampo auqui na tururrü, morrimiacana tato nomünantü uimia, tacana ba nobirramanca. Omenompo au corarrü y cuantio tatito türüpo. Tabüco oboi urria pasto. ");
INSERT INTO caxNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‛Arrti cusüpürrü cuati nauqui acusüpüti, atabaiti y nauqui aiñamesocoti. Pero arrüñü isecatü nauqui yache yosüborquibo niyabu nobirramanca, arrüna chütacürusupü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Arrüñü tacanatito naqui iyabuche, naqui buenurrti, naqui mejor cuiranterrü yutacu nobirramanca. Itopiqui itorrimiata nisüboriqui yutacu niyabu nobirramanca. ");
INSERT INTO caxNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Arrti naqui bacuirarati yutacu nobirraca itobo monirratai chübucuasürüpü nurria ümoti. Arrtü asaratitü cümenu nuitümürrü, besüburuti. Omoncono nobirraca uiti, itopiqui champürrtü niyaburrti. Auqui nuitümürrü maiñeno manio nobirraca, y omiñarrio ñünana. ");
INSERT INTO caxNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Arrti maniqui bacuirara yutacu nobirraca besüburuti, itopiqui champü nümochio uiti manio nobirraca. Batrabacarati iyo monirratai. ");
INSERT INTO caxNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","‛Arrüñü naqui iyabuche manio nobirraca. Rracuiraca nurria yutacu. Isuputaquio nurria niyabu nobirramanca, y arrio yusuputarañü ito. ");
INSERT INTO caxNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tacane ito isuputacati naqui Iyaü y arrti isuputaratiñü. Arrüñü itorrimiata nisüboriqui yutacu nobirramanca. ");
INSERT INTO caxNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Abe ito piquiataca niyabu nobirraca, pero champürrtü auqui na corarrü ion. Tiene que iquianio ito tauna. Arrion opicocota nisura. Tiene que abetü yochepe tacana ba amoncatai, nauqui ichepe nubacarrü, y tamantiatai naqui bacuirarabo yutacu, ta arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‛Isuasürüca ümoti Iyaü, itopiqui ichücañantai ison. Pero ñana tiene que isübori tato. ");
INSERT INTO caxNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Champüti naqui puerurrü aitabairotiñü. Sobiatoe itorrimia nisüboriqui auqui niñoñemantoe. Puerurrüñü itorrimia y puerurrüñü ito yasuriu tato, itopiqui torrio isüriacabo uiti Tuparrü, nauqui isamune sane. ");
INSERT INTO caxNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ui arrüna sane nurarrti Jesús, chichepepü tatito ñapensacarrüma bama üriatu bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aboma bama uturuquimia namatü: —Anati choborese auti, locorrti. ¿Causane amonsaperio nurarrti? ");
INSERT INTO caxNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero aboma bama maquiataca namatü: —¿Aensapü manitanati sane naqui locorrü? ¿Aensapü puerurrü acheti choborese arrtaboti naqui supuso? ");
INSERT INTO caxNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Auqui iñatai manu nipierrta niporrti Tuparrü. Arrümanu tiemporrü tarucu rrimianene. ");
INSERT INTO caxNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Arrti Jesús amencoti isiu manu nicorerorrü nürirri “Salomón”, au niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Auqui iñataimia esati bama üriatu bama israelitarrü. Atüraimia itupecuti, ñanquitioma pünanaquiti: —¿Auchepü ñana uraboi suisucarü arrtü ñemanauntu arrücü Cristocü? Urasoi nurria suisucarü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aiñumuti Jesús: —Chauqui tüsurapoi ausucarü, pero chapicocotapü. Puerurrü te atusi aume ui arrüba milagrorrü isamuquio au nürirrti Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Arraño chapicocotapü, itopiqui champürrtü arrüpecuqui niyabu nobirramanca año. ");
INSERT INTO caxNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Niyabu nobirramanca yusuputacai nisura y isuputaquio ito. Arrio cuantio isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sane nacarrüma bama tacana niyabu nobirramanca. Yacheca isüboriquiboma arrüna chütacürusupü. Chüpuerurrüpü aenso nausüpürrüma. Champüti naqui puerurrü aiñensonoconoma rropünanaquiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Itopiqui torrioma iñemo uiti Iyaü, y arrti ane manrrü nüriacarrti pünanaqui namanaiña. Sane nauquiche champüti naqui puerurrü aiñensonoconoma pünanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Arrüñü ichepeti Iyaü taman nacarrtai subaca. ");
INSERT INTO caxNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Auqui arrümanuma israelitarrü macanama tatito canca uiche arurumati. ");
INSERT INTO caxNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero arrti Jesús nanti ümoma: —Sürümana milagrorrü omirriante sobi au nürirrti Iyaü. ¿Ñacusane arrüna milagrorrü itacuche aurrianca aparuruñü? ");
INSERT INTO caxNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aiñumuma manuma israelitarrü: —Champürrtü suirranca suparurü oboi canca itacu na urria aisamute, si no itacu arrüna churriampü nanitaca ümoti Tuparrü. Aisamucü tacana Tuparrücü, abu ñoñünrrücüatai. ");
INSERT INTO caxNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aiñumuti Jesús nurarrüma, nanti: —Icu naubesa librurrü nesa nüriacarrü ane corobo sane: “Nanti Tuparrü: Nabaca tacana Tuparrü año”. ");
INSERT INTO caxNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tusio nurria oemo que valeo arrüna nantü icu Nicororrü. Manitanati Tuparrü tücañe ümo manuma macrirrtianuca, nanti arrüma tacana Tuparrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Arrüñü samamecanañü uiti Iyaü, nauqui aicüpurutiñü icu na cürrü. ¿Causane aburaboi que churriampü nirranitaca ümoti itopiqui na sucanañü que arrüñü Aütorrti? ");
INSERT INTO caxNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Arrtü chuipü nüriacarrti Tuparrü omirriane sobi arrüba milagrorrü, tapü apicococañü. ");
INSERT INTO caxNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero ñemanauntu te omirrante sobi ba milagrorrü ui yacüpucurrti Tuparrü. Sane nauquiche apicocosoñü yusiuqui ba milagrorrü omirrante sobi, arrtü chüpuerurrüpü apicoco nisura. Sane nauqui atusi aume que arrti Iyaü anati ichepeñü, y arrüñü yaca ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Auqui rranrrümampü tatito aiquianamati au preso, pero arrti iquiaüburutiyü pünanaquimia. ");
INSERT INTO caxNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Auqui basücübücoti tato Jesús auna sane ümo tansürü topü manu sapoco Jordán, au manu cauta anancati tücañe Juan Bautista maunimianati. Acamanu süsioti. ");
INSERT INTO caxNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cütüpürrü macrirrtianuca yebomatü asaramati acamanu. Namatü: —Arrti Juan tücañe chümasamunutipü milagrorrü, pero bien ñemanauntu nanaiña arrüna urapoiti usucarü icütüpüti naqui Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sürümanama uturuquimia icocoromati Jesús acamanu. ");
INSERT INTO caxNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Anati tücañe maniqui taman ñoñünrrü nürirrti Lázaro. Pohosoti au manu puebluma nürirri Betania. Acamanu abe ito manio torrü niquiastoti, nobürirri Mariarrü y Martarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Arrümanu Mariarrü tone manu isemata nipoperrti Jesús ui manu perfume urriantai norimia, y sühüburu ito tato uirri ui niqui nitanurrü. Au manio naneneca maunrroconoti Lázaro. ");
INSERT INTO caxNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Así que arrüba torrü niquiastoti pacüpuru coreorrü iyoti Jesús, nauqui uraboiti isucarüti arrüna sane nuburarrü: —Señor, maunrroconoti aesa amigorrü, naqui cuasürü aemo. ");
INSERT INTO caxNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Numo toncoiti Jesús arrüna sane, nanti: —Arrümanu norrocorrü ümoti Lázaro champürrtü nauqui aconti, ta nauqui iñanaunumati Tuparrü bama macrirrtianuca, y nauqui aiñanaunumañü ito, itopiqui ta arrüñü Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tarucu nicua Martarrü ümoti Jesús, tacane ito Mariarrü y arrti yotübaurrirri Lázaro. ");
INSERT INTO caxNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Numo turapoimia isucarüti Jesús, que ta anati Lázaro maunrroconoti, querabotiqui ñome torrü naneneca au manu cauta anancati. ");
INSERT INTO caxNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Auqui aüboqui nanti ümo bama ñanunecasarrti: —Curi tato au Judea. ");
INSERT INTO caxNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Arrüma namatü: —Maestro, aübopütoche rranrrüma aitabairomacü bama israelitarrü. ¿Causane arrianca aüro tatito taha esama? ");
INSERT INTO caxNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Auqui urapoiti arrüna machepecatarrü isucarüma: —Abe te doce horarrü au sapese. Arrtü uñamenca au sapese, choñopopetabarriquiapü, itopiqui basacatü nurria ui nanentacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero arrtü uñamenca au tobirri oñopopetabarriquia, itopiqui tomiquianene. ");
INSERT INTO caxNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Auqui nantito: —Arrti oesa amigorrü Lázaro chauqui tümanumuti. Pero caüma yecatü istopünanati tato. ");
INSERT INTO caxNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Señor —namatü bama ñanunecasarrti—, arrtü manumuti, taqui urriancati tato ñana. ");
INSERT INTO caxNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Arrti Jesús rranrrtipü uraboiti isucarüma que chauqui tücoiñoti, pero arrüma ñaquioncorrüma manumutiatai. ");
INSERT INTO caxNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sane nauquiche urapoiti nurria isucarüma, nanti: —Arrti Lázaro chauqui tücoiñoti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pero urria arrüna chanancapüñü taha, itopiqui ui arrüna sane apicococañü nurria caüma. Pero curi te basarati. ");
INSERT INTO caxNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Arrti Tomás naqui nürirrtito uimia tocarrü, nanti ümo bama maquiataca: —Curito te arroñü nauqui oco ito ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iñataimia au Betania. Tabe cuatro naneneca nacarrti Lázaro cütu au manu nusutu canrrü, taburrio ui canrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Arrümanu pueblurrü Betania ane saimia Jerusalén, ane trerrü kilómetros y media nichequirri pünanaqui. ");
INSERT INTO caxNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sürümanama bama israelitarrü aboma acamanu apaseama ümo Mariarrü y Martarrü, nauqui achema ñupucünuncubu, tapü tarucapae niyusuchequirri isiuti yotubaurrirri, naqui coiño. ");
INSERT INTO caxNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nauquiche tütusio ümo Martarrü que arrti Jesús tanati saimia pueblurrü, atürai, sürotü aicuñunuti. Mariarrü oncono au porrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nauquiche tiñatai Martarrü esati Jesús, nantü ümoti: —Señor, arrtü nampü anancüpü auna, quiubupü aco nichübaurri. ");
INSERT INTO caxNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero tusio iñemo que nanaiña torrio aemo caüma ui Nupu Tuparrü, arrtü anquiquia pünanaqui. ");
INSERT INTO caxNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aiñumuti Jesús: —Arrti atübaurri tiene que asüboriti tato. ");
INSERT INTO caxNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Auqui nantü ümoti: —Tusio te iñemo que au manu tacürurrü nanenese bosüborico tato nanaiña arrüba tümocoiño. Auqui caüma arrüna nichübaurri süborico ito tato yochepe. ");
INSERT INTO caxNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Auqui nanti Jesús ümo: —Sobi te süboricoma tato, sobito torrio ümoma isüboriquiboma. Arrti naqui icocorotiñü ane isüboriquiboti, champü nümoche arrtü coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Torrio ümoti isüboriquiboti arrüna chütacürusupü, chensoropü nausüpürrti, itopiqui oncotitü iñemo. ¿Aicocota arrüna sane Marta? ");
INSERT INTO caxNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Icocota Señor —nantü—, ta arrücü Cristocü, arrüna ensümunu ayetü icu na cürrü, Naüto Nupu Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Auqui süro tato Martarrü esa Mariarrü, arrüna naruquirri. Nantü ümo masamuñantai: —Tiñatai Jesús, rranrrü asarü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Auqui atürai Mariarrü, aürotü yarucurrü esati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Arrti champürrtü tüsürotitü au pueblurrü, anancatiqui au manu cauta aicuñunuiti Martarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tapü au porrü amoncoma manuma israelitarrü cuamatü achema pario ñupucünuncubu. Arrtaimia arrüna apuraurrü atürai nauqui aürotü türüpo. Aüromatito isiu, ñaquioncorrüma rranrrü aürotü areo esa nicürrti itübaurrirri. ");
INSERT INTO caxNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Aiñanai Mariarrü esati Jesús, besüro achesoi esati, nantü ümoti: —Arrtü nampü anancüpü auna, quiubupü aco nichübaurri. ");
INSERT INTO caxNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Arrti Jesús asaratitü ümo, ane areoro, y arrübama aboma isiu aboma ito areoroma. Au manu rratorrü onquisioti tarucu nisuchequirrti, anasacoti fuerte, nanti: ");
INSERT INTO caxNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Cauta apiñanati cütu? —Ariacu Señor —namatü—, curi basarai nicürrti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Auqui arrti Jesús areoroti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Namatü manuma macrirrtianuca: —Amasasatü, tarucu nicuarrti tücañe ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero aboma ito bama namatü: —Tonenti naqui ñoñünrrü uiche asarati tato arronequi supusu. ¿Causane chübacuraratipito ümoti Lázaro, tapü coiñoti? ");
INSERT INTO caxNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Onquisioti Jesús tatito tarucu nisuchequirrti. Sürotitü esa manu nicürrti Lázaro. Anati cütu au manu nusutu canrrü, taburrio ui canrrü ito. ");
INSERT INTO caxNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Auqui acüputi Jesús ümoma, nanti: —¡Apiquiaübu manu canrrü! —Pero Señor —nantü Martarrü—, chauqui tütabe cuatro naneneca niconcorrü, chauqui toriotü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nanti Jesús ümo: —Chauqui tüsurapoi asucarücü, arrtü oncatü nurria iñemo, arrtai nicusüurrti Tuparrü y nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Auqui iquiaübutama manu canrrü. Arrti Jesús asaratitü ape au napese, meaboti, nanti sane: —Iyaü, chapie aemo, arrücü aitorrimiata iñemo arrüna rranquiquia apünanaquicü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tusio iñemo, nantarrtai oncoi nirranquiqui apünanaquicü. Pero rreanca sane auna isucarü bama macrirrtianuca, nauqui aicocoma que ta obi aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chauqui neancarrti, yabirotiti Lázaro, fuerte nurria nurarrti: —¡Lázaro, ariacu türüpü! ");
INSERT INTO caxNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Auqui arrti maniqui coiño atüraiti tato auqui manu nusuturrü, motomoenoinqui neherrti y nipoperrti, suburriotito, bien quiñoenotiqui ui nicüburrirrti. Auqui nanti Jesús ümo manuma amoncoma acamanu: —Apitaquisünarrti, nauqui puerurrü amenti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sürümanama bama israelitarrü bapaseara ümo Mariarrü, arrtaimia arrüna milagrorrü urriante ui Jesús, y icocoromati. ");
INSERT INTO caxNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero aboma ito uturuquimia bama süromatü esa bama fariseorrü uraboimia arrüna urriante uiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Auqui arrübama üriatu sacerdoterrü ichepe bama fariseorrü iyoberabaramacü nauqui aparimia, namatü: —¿Causane osoi caüma? Arrti naqui ñoñünrrü tarucu ñasamucurrti milagrorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Arrtü uicheta ümoti, namanaiña ñana süromatü isiuti y icocoromati. Auqui caüma arrübama rromanorrü cuamatü aitabairoma oñü, y nauqui aiñarrimiacama niporrti Tuparrü y nanaiña arrüna noesa nación. ");
INSERT INTO caxNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tamanti uturuquimia nürirrti Caifás. Tonenti naqui yarusürürrü sacerdoterrü au manu añorrü. Arrti nanti ümo bama maquiataca: —Arraño champürrtü tusio aume. ");
INSERT INTO caxNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Taqui chentienderrüpü año que manrrü urria arrtü coiñoti naqui taman ñoñünrrü, pünanaquirrtü coiñoma namanaiña macrirrtianuca auna noesa nación. ");
INSERT INTO caxNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Arrti Caifás champürrtü manitanati ui ñapanauncurrtiatoe, ta torrio ümoti arrüna urapoboiboti uiti Tuparrü, itopiqui yarusürürrü sacerdoterrti au manu añorrü. Sane nauquiche urapoiticaü que arrti Jesús coiñoti ñana itacu bama israelitarrü, ");
INSERT INTO caxNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","y champürrtü itacumantai, ta itacu ito namanaiña bama icocoromati Tuparrü, nauquito oberabama uiti bama iñarriomantai au nanaiñantai icu na cürrü, nauqui ichepe nacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Auqui manu nanenese caüma arrübama mayüriabuca baparioma causane nauqui aitabairomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sane nauquiche arrti Jesús chamencotiquipü arrüpecu bama israelitarrü. Sürotitü au manu taman pueblurrü nürirri Efraín, ane abeu manu narubaitu rroense pururrü cüosorrü y canca. Acamanu süsioti ichepe bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tüsaimia manu pierrta parrcua. Cütüpürrü genterrü auqui nanaiñantai puebluca iñataimia au Jerusalén apierrtanacama. Isamutema nanaiña isiuqui arrüna yacüpucu nüriacarrü nauqui limpiorrü nisüboriquirrimia ümorrtü tiñatai manu pierrta parrcua. ");
INSERT INTO caxNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Amoncoma aübu yapachequirrimia iyoti Jesús. Ñanquitioma pünanaquimiantoe, namatü: —¿Aburaño sane, aensapü cuatati caüma ümo na pierrta? ");
INSERT INTO caxNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Arrübama üriatu bama sacerdoterrü y bama fariseorrü bacüpuruma ümo genterrü, nauqui uraboimia arrtü anati naqui tusio ümoti cauta nacarrti Jesús, nauqui aiñenomati y aiñanamati au preso. ");
INSERT INTO caxNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Faltaboiqui seirri naneneca ümo manu pierrta parrcua. Süroti tato Jesús au Betania, auna cauta pohosoti Lázaro, naqui süboricoti tato uiti Jesús auqui niconcorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Numo tiñataiti Jesús au niporrti Lázaro, masamunuma pemacarrü ümoti, nauqui ahati ichepe bama ñanunecasarrti. Martarrü ane basuru pemacarrü icu mensarrü, y arrti Lázaro anati basoti ichepeti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Auqui Mariarrü sürotü esati Jesús aübu taman boteyama ataso ui perfume, arrüna tarucapae nicuarrü. Auqui isemata nipoperrti uirri, isübuta ito tato ui nubabaitu nitanurrü. Enterurrü manu porrü ataso ui norimia manu perfume. ");
INSERT INTO caxNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Anatito acamanu Judas Iscariote, naqui tamanti eanaqui manuma doce ñanunecasarrti Jesús naqui uiche aipiaventecanatiti ñana. Arrti nanti: ");
INSERT INTO caxNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Causane chüpaventeopü manu perfume? Ane te nicuarrü itobo trescientos denarios, puerurrüpü bayura ümo bama pobrerrü uirri. ");
INSERT INTO caxNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Arrti Judas nanti arrüna sane, champürrtü ui na cuasürüma ümoti bama pobrerrü ta ui na cusüpürrti. Taipü arrti naqui uiche nacarrü manu pusanese auche ahüburu monirri arrüna torrio nantarrü ümoma, y nantarrtai cusüpüoti aruqui. ");
INSERT INTO caxNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Auqui nanti Jesús ümoti: —Asio sane, tone isamute iñemo arrüna sane ümorrtü isonca y nauqui aiñanamañü cütu. ");
INSERT INTO caxNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Arrübama pobrerrü siemprerrü aboma auchepe, pero arrüñü chiyasiquiapü auchepe. ");
INSERT INTO caxNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sürümanama bama israelitarrü oncoimia que arrti Jesús anati au Betania. Auqui süromatü taha asaramati. Rranrrüma ito asaramati Lázaro, naqui süboricoti tato uiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ui arrüna sane arrübama üriatu bama sacerdoterrü rranrrüma aitabairomatito Lázaro, ");
INSERT INTO caxNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","itopiqui auqui nacarrti sürümanama bama israelitarrü saliboma auqui nesarrüma partidorrü y icocoromati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sürümanama macrirrtianuca iñataimia au Jerusalén ümo manu pierrta parrcua. Au manu quiatarrü nanese ipiatema que arrti Jesús cuatai au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Auqui matüsünanama nasu mutacürrü, y süromatü aicuñunumati aübu tarucu nipucünuncurrüma. Tosibicoma, namatü: —Uiñanaunati Tuparrü. Tari curusüuti naqui cuatü au nürirrti Tuparrü, naqui yüriaburrü ümo na cürrü Israel. ");
INSERT INTO caxNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Arrti Jesús tabüco uiti buruma. Süroti chacu, nauqui aürotitü. Arrüna sane tanancatai corobo tücañe, nantü sane: ");
INSERT INTO caxNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tapü aupirruca bama pohoso au Jerusalén. Caüma cuati naqui yüriaburrü aume. Cuati chacu buruma. ");
INSERT INTO caxNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Au manu nanenese arrübama ñanunecasarrti Jesús chütusiopü ümoma que ta tücocono arrümanu nantü icu Nicorrü. Pero nauquiche tüsüroti tato esati Tuparrü au napese, aquionomacü iyo arrüna anancatai corobo, y isucarüma nurria cocono nanaiña ui manu yasuriurumati Jesús sane au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aboma ito au Jerusalén bama amoncoma au Betania, numo tasuruti Lázaro auqui manu nusuturrü, süboricoti tato uiti Jesús, bama arrtaimia manu milagrorrü. Arrüma chauqui turapoimia tanu arrümanu isamutenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sane nauquiche aboma sürümanama macrirrtianuca süromatü aicuñunumati, itopiqui toncoimia nüri manu milagrorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tapü arrübama fariseorrü namatü ümomantoe: —Chauqui tamarrtai, ümonatai nanaiña arrüna nubapariqui. Enterurrü genterrü sürotü isiuti naqui. ");
INSERT INTO caxNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Eana manu genterrü iñatai au Jerusalén ümo pierrta, aboma ito mümanamantai griegorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Arrüma süromatü esati Felipe naqui auqui Betsaida, au manu cürrü Galilea, namatü ümoti: —Señor, suirranca sopisuputarati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Arrti Felipe urapoiti isucarüti Andrés. Auqui süromatü uraboimia isucarüti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Auqui nanti Jesús ümoma: —Chauqui tiñatai arrüna nanenese. Caüma tiene que atusi ümo genterrü arrüna tarucu manauncurrü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Auqui urapoitito arrüna machepecatarrü isucarüma ümo niconcorrti: —Amonsoi nurria. Taman niyo trigo tiene que aüro cütu, y taha cütu coiño. Pero auqui niconcorrü ubaüro tato y bachebo caüma cosecharrü. Arrtü chüsüropü cütu querabo tamantai, champü nütarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Arrti naqui tarucu nicua nisüboriquirrti ümoti, ensoro ñana nausüpürrti. Pero arrti naqui itorrimiatatatai nisüboriquirrti auna icu na cürrü, tonenti naqui torrio isüboriquiboti au napese, arrüna chütacürusupü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Arrübama rranrrüma aserebimia iñemo, tari yebamatü isiuñü. Auna cauta yecatü, acamanu ito tiene que aboma bama nirranunecasa. Y anaunuma uiti Iyaü namanaiña bama baserebio iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‛Caüma tarucapae nirrucu. ¿Causane caüma sobi? ¿Taqui rranquitio caüma pünanaquiti Iyaü nauqui apasa rropünanaquiñü arrücuatü nichaquisürücü? No, chüpuerurrüpü rranquirio arrüna sane, itopiqui ümo te isetü icu na cürrü, nauqui ichaquisürü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mejor rranquira pünanaquiti sane: “Iyaü, aiña isiu narrianca, sane nauqui atusi nüriaca”. Au manu rratorrü rabotü manitacarrü auqui napese, nantü sane: —Chauqui titusiancata nisüriaca y caümainqui itusiancata. ");
INSERT INTO caxNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Arrümanuma macrirrtianuca oncoimia manu manitacarrü, ñaquioncorrümapü ta süuru. Aboma maquiataca namatü: —Canapae tamanti ángel manitanati ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pero arrti Jesús nanti ümo manu genterrü: —Champürrtü iñemoantai arrüna manitacarrü, ta aume ito y autacu. ");
INSERT INTO caxNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chauqui tiñatai nanenese nesa bacurrtacarrü aübu bama macrirrtianuca icu na cürrü. Caüma carübu pünanaquiti choborese nanaiña nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Arrüñü Ñemanauncurratoe Ñoñünrrü, arrtü yaca ape apü curusürrü, rraemenca yesañü ümo namanaiña macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ui arrüna sane nurarrti, urapoiti isucarüma causane ñana niconcorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Auqui namatü ümoti manuma macrirrtianuca: —Lehebo somü icu librurrü nesa nüriacarrü, nantü que arrti Cristo chüpuerurrüpü aconti, champü nitacüru nisüboriquirrti. ¿Causane ucanü que arrti Ñemanauncurratoe Ñoñünrrü tiene que aconti apü curusürrü? ¿Causane ucanü que ta arrücü Ñemanauncurratoe Ñoñünrrücü? ");
INSERT INTO caxNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aiñumuti Jesús: —Arrüñü yaca auna abarrüpecu tacana basarurrü aume. Yacaiqui ñome ba mümanantai naneneca. Amame te au nanentaca basarurrü, tapü autabüca au tomiquianene. Itopiqui arrti naqui amencoti au tomiquianene chütusiopü ümoti cauta niyücürrti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Amonsotü ümo basarurrü arrüna nabaca au tomiquianene. Sane ito amonsotü iñemo mientras yacaiqui abarrüpecu. Sane nauqui urria nausüboriqui, tacanarrtü ane nanentarrü aume au tomiquianene. Numo tüchauqui arrüna ñanitacarrti Jesús ümoma, sürotitü aiñanecanatiyü pünanaquimia. ");
INSERT INTO caxNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sürümana milagrorrü omirriante uiti, pero ni sanempü aicocoromati. ");
INSERT INTO caxNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sane cocono arrüna turapoiticaü profetarrü Isaías tücañe sane: Señor, champüti naqui icocota arrüna numanunecaca. Champüma bama tusio ümoma ta chauqui itusiancatati Tuparrü nicusüurrti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Arrti Isaías urapoiticaü ito causane arrüna nauquiche chicocotapüma. Ta ane te corobo ito tücañe uiti sane: ");
INSERT INTO caxNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Arrübama macrirrtianuca aboma tacana supusoma uiti Tuparrü. Tairri nausasürrüma uiti. Sane nauquiche tacanarrtü chasarapümatü. Chüsüropü au nitanurrüma nurarrti Tuparrü. Chücuamapütü yesañü nauqui rracura ümoma, nanti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Arrüna ñanitacarrti profetarrü Isaías tücañe, abu ta ümoti Jesús, itopiqui auqui quiatarrü narrtarrti asaratitü ümoti Cristo aübu nanaiña nanentacarrti y nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Taipü sürümanama uturuqui bama üriatu bama israelitarrü icocoromati Jesús, pero anecanatai, champürrtü isucarü macrirrtianuca, ui nirrucurrüma ñünana bama fariseorrü, tapü penocoma uimia auqui sinagoga. ");
INSERT INTO caxNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Manrrü urriantai ümoma arrüna nicuarrüma ümo genterrü. Tapü arrüna nicuarrüma ümoti Tuparrü champü nümoche uimia. ");
INSERT INTO caxNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Auqui manitanati Jesús fuerte, nanti ümo genterrü: —Arrti naqui icocorotiñü, icocorotitito naqui Iyaü, naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Arrtü amasacañü, amasacatito naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Arrüñü isecatü icu na cürrü tacana basarurrü ümo bama icocoromañü, nauqui tapü asioma au tomiquianene. ");
INSERT INTO caxNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aboma bama oncoimia nisura, pero chicocotapüma. Champürrtü sobi carrtigaboma. Itopiqui arrüñü chisecapütü icu na cürrü, nauqui yache carrticurrü, sino nauqui sobi ataesübuma macrirrtianuca eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Arrti naqui chiyasuriurutipüñü y chicocotatipü nisura, chauqui tütane arrüna uiche atusi que ta ane nipünatenti au manu tacürurrü nanenese. Tone nisura arrüna uiche uraboi ta ane nipünatenti, tone arrüna uiche carrtigaboti. ");
INSERT INTO caxNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Itopiqui chirranitacapü ui niñuñemantoe. Rranunecaca arrüna yacüpucurrti Iyaü, naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Arrüñü icocota arrüna yacüpucurrti Iyaü. Ui arrüna yacüpucurrti torrio aume ausüboriquibo, arrüna chütacürusupü. Sane te, rranitate cunauntaiña arrüna yacüpucurrti Iyaü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sürotiqui taman nanenese ümo pierrta parrcua. Arrti Jesús chauqui tütusio ümoti, contoatai tiene que aiñocoti na cürrü, nauqui ariorrti tato esati Yaütoti au napese. Nantarrtai cuasürüma ümoti bama icocoromati auna icu na cürrü. Cuasürüma ümoti chepe nitacüru nisüboriquirrti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Arrti choborese chauqui tübacheboti ñapensacaboti Judas Iscariote, nauqui aipiabentecanatiti Jesús. Arrti Jesús aquionotiyü, que cuatati esaquiti Tuparrü auqui napese, y tiene que ariorrti tato taha. Tusio ito ümoti que torrio ümoti nanaiña üriacaboti uiti Yaütoti. Au manu tobirri amoncoma basoma. ");
INSERT INTO caxNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Auqui atüraiti Jesús esaqui mensarrü. Iquiaübutati naibirrti onüqui niquiamisarrti. Itomoentati taman toallarrü itupecuti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Auqui baraparati turrü au taman currabirri, uiche aiyarrübiti nipoperrüma manuma ñanunecasarrti y aisühübuti tato apüqui nipoperrüma ui manu toallarrü tomoeno itupecuti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aiñanainti esati Pedro. Arrti nanti ümoti: —Señor, ¿causane arria aipünümiancanañü? ");
INSERT INTO caxNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aiñumuti Jesús: —Chüpuerurrüpü atusi aemo caüma isane ümoche arrüna isamute, pero manrrü ñana tusio aemo. ");
INSERT INTO caxNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nanti Pedro: —¡Chüsamianapü iñemo nauqui aipünümiancanañü! Auqui nanti Jesús ümoti: —Arrtü chaichetapü nauqui ipünümiancanü, chüpuerurrüpü nirranunecasacü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Auqui nanti Pedro: —Arrtü sane, aiyarrübisio ito niñe y nichanu, tapü cunauntaiña nipope. ");
INSERT INTO caxNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aiñumuti Jesús: —Arrti naqui aübo atopiti, champü nümoche atopiti tatito. Cunauntañantai arrtü bapürübioti, itopiqui enterurrü nicütüpürrti chauqui taseabo. Arraño chauqui turria napapensaca, cunauntañatiatai taman abuturuqui, champürrtü urria nacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tusiatai ümoti Jesús ñacuti naqui uiche ñana aipiabentecanatiti. Sane nauquiche nanti: “Chenterurrüpü año urria nabaca”. ");
INSERT INTO caxNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Numo tüchauqui ñapünümiancacarrti ümoma, iñatati tato naibirrti apüti, tümonsoti tatito esa mensarrü. Auqui nanti ümoma: —¿Tusio aume isane nümoche arrüna isamute sane? ");
INSERT INTO caxNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Arraño amucanaño iñemo Maestro y Señor. Urria arrüna sane nabura iñemo, itopiqui ñemanuntu arrüñü te. ");
INSERT INTO caxNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arrüñü te Maestroñü y Señorñü, abu one ipünümiancacaño. Sane ito arraño, auquina caüma tiene que apipünümiancanati ausüborisapa. (O sea, tiene que apaserebi ümoti quiatarrü.) ");
INSERT INTO caxNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Arrüñü yaserebiquia aume sane nauqui apisamune isiuquiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Suraboira ñemanauncurratoe ausucarü: Arrti taman mosorrü champürrtü ane manrrü nüriacarrti pünanaquiti ipiatronetorrti. Arrti taman coreorrü champürrtü ane manrrü nüriacarrti pünanaquiti naqui uiche aicüpurutiti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sane nauquiche caüma arrtü entienderrü año nirranunecaca aume y apisamute isiuqui, urria nabaca. ");
INSERT INTO caxNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‛Champürrtü rranitaca ümo nanaiña año. Itacümanauncucaño aucutanu, y bien isuputacaño. Contoatai tiene que acoco arrüna nantü sane Nicororrü: “Arrti naqui baso ichepeñü tüboricoti iñemo”. ");
INSERT INTO caxNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Surapoicaü ausucarü nanaiña arrüna pasabobo, ümorrtü cocono ñana, arraño tütusio aume caüma que arrüñü Cristoñü naqui Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ñemanauncurratoe sucanañü aume: Arrti naqui yasuriurutiti naqui ümoche rracüpuca, es tacanarrtü yasuriurutiñü ito. Arrti naqui yasuriurutiñü ta tacanarrtü yasuriurutitito naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Numo turapoiti arrüna sane isucarüma, onquisioti orronene au nausasürrti ui tarucu nisuchequirrti. Auqui caüma urapoiti besüro nurria isucarüma: —Tusio nurria iñemo, tamanti abarrüpecuqui tiene que aipiaventecanatiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Auqui arrümanuma ñanunecasarrti asaramatü ümomantoe. Chütusiopü ümoma ñacuti ümoche manu ñanitacarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tamanti eanaquimia, naqui manrrü cuasürüti ümoti Jesús anancati tümonsoti petacuti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Auqui arrti Pedro masamunuti señarrü ümoti, nauqui anquirioti pünanaquiti Jesús, ñacuti maniqui ümoche manu nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Auqui arrti maniqui sürotitü manrrü saimia esati Jesús, anquirioti pünanaquiti: —Señor, ¿ñacuti maniqui? ");
INSERT INTO caxNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aiñumuti Jesús, nanti: —Ipiancana taman peasorrü pan, y arrti naqui ümoche itorrimia, ta tonenti. Auqui aipiancati manu peasorrü pan. Aitorrimiati ümoti Judas Iscariote, naqui aütorrti Simón. ");
INSERT INTO caxNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Arrti Judas yasutiuti manu pan. Auqui süroti choborese auti. Auqui nanti Jesús ümoti: —Aisamuse contocaü arrüna arrianca aisamune. ");
INSERT INTO caxNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero arrübama maquiataca acamanu chütusiopü ümoma isane ümoche arrüna nurarrti Jesús ümoti Judas. ");
INSERT INTO caxNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ñaquioncorrüma bacüpuruti Jesús ümoti Judas na acomporati utuburibomainqui ümo pierrta, o nauqui acheti monirri ümo bama pobrerrü, itopiqui arrti Judas tonenti naqui ane uiti manu pusanese auche ahübu nimonirrimia. ");
INSERT INTO caxNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Numo tiyasutiuti Judas manu pan mecuquiti Jesús, atüraiti, sürotitü türüpo. Chauqui tütobiquia. ");
INSERT INTO caxNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nauquiche tüsürotitü Judas auqui manu, nanti Jesús: —Caüma tusio arrüna tarucu nanentacarrti Tuparrü ichupecuñü. Caüma ito tarucu ñanauncurrüma macrirrtianuca ümoti Tuparrü, ui nanaiña arrüna pasabobo iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sobi tusio icu na cürrü arrüna tarucu nicusüurrti Tuparrü y nanentacarrti. Sane ito arrti Tuparrü itusiancatati isucarü macrirrtianuca ñanauncurrti iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","¡Amonsoi masaütaiqui! Chübubiuquipü naneneca niyaca auna icu na cürrü auchepe. Tiene que apapacheriuruñü. Pero chüpuerurrüpü amenotü isiuñü auna cauta niyücü. Chauqui tüsurapoi arrüna sane isucarü bama maquiataca israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pero itorrimiana aume arrüna nuevurrü nirracüpucu nauqui aucua aumeampatoe. Arraño aucuasürüca iñemo. Sane ito tiene que aucuasürü aumeampatoe. ");
INSERT INTO caxNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Arrtü aucuasürüca aumeampatoe, tusio ümo namanaiña macrirrtianuca ta nirranunecasa año. ");
INSERT INTO caxNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Auqui nanti Pedro ümoti Jesús: —Señor, ¿cauta naücü? Aiñumuti Jesús: —Chüpuerurrüpü aürotü isiuñü caüma auna cauta niyücü, pero manrrü ñana amecatüqui isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—¿Causane chüpuerurrüpü yero tanu asiucü caüma? —nanti Pedro—, irranca hasta ison aitobocü. ");
INSERT INTO caxNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Acon ichoboñü? —nanti Jesús ümoti—, ¿aensapü sane? Suraboira asucarücü, caüma arrüna tobirri, antes que apu pohorrü curasürrü, apanca trerrü veserrü que chasuputacapüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Auqui nantito Jesús ümo namanaiña: —¡Tapü aupirruca! Amonsotü nurria ümoti Tuparrü. Amonsotito iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Au napese auna cauta nacarrti Tuparrü abe sürümana aupobo. Sane nauquiche yecatü isusürü icoñoco aucümenu. Arrtü nampü chüsanempü, coboipü suraboi ausucarü que champü isanempü aume ta au napese. ");
INSERT INTO caxNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Arrtü tücoño sobi, iseca tato abapa, itopiqui irranca nauqui abaca ichepeñü au napese. ");
INSERT INTO caxNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Caüma tusio te aume cauta niyücü, y tusio ito aume cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Auqui nanti Tomás ümoti: —Chütusiopü suiñemo cauta naücü, Señor. ¿Causanempü atusi suiñemo manu cutubiurrü? ");
INSERT INTO caxNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aiñumuti Jesús: —Arrüñü te tacana manu cutubiurrü. Arrüñü ñemanauncurratoe, chirrapancapü. Sobito ane nanaiña süboriquirri. Ta cunauntaña isiuquiñü puerurrü apiñanai esati Uyaü, naqui Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Arrtü ausuputacañü, ausuputacatito naqui Iyaü. Pero sucanañü aume que ta chauqui tapisuputacati y tamasacatito. ");
INSERT INTO caxNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Auqui nanti Felipe ümoti: —Señor, aitusiancarrti Uyaü suisucarü, toneantai suirranca supanquirio apünanaquicü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aiñumuti Jesús, nanti ümoti: —Onsoi Felipe: Tücoboi niyaca auchepe. ¿Causane chapisuputacapüñünqui? Itopiqui arrti naqui asaratiñü, asaratitito naqui Iyaü. ¿Causane anquirio rropünanaquiñü nauqui itusiancanati naqui Iyaü ausucarü? ");
INSERT INTO caxNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Taqui chaicocotapü que anati Iyaü sauñü, y arrüñü yaca auti? Champürrtü rranunecaca aume auqui niñoñemantoe. Arrti Iyaü anati ichepeñü. Arrti te isamutenti nanaiña arrüna propiorrü yatrabacacarrti ñemecuquiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Apicoco te nurria que arrüñü y arrti Iyaü taman nacarrtai subaca. Arrtü cuestarrapae aume apicoco arrüna surapoi ausucarü, apicocosoñü isiuquiatai itopiqui chauqui tamarrtai arrüba milagrorrü omirrante sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Suraboira ñemanauncurratoe ausucarü: Arrti naqui icocoroñü, isamutentito milagrorrü tacana arrüba isamuquio, hasta masamunutito manrrü yarusürürrü milagrorrü, itopiqui arrüñü yeca tato esati Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Auqui caüma yacheca aume nanaiña arrüna apanquiquia pünanaquiti Iyaü au nisüri. Sane nauquiche caüma tusio nüriacarrti naqui Iyaü sobi, ta arrüñü Aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sanen te, apanqui pünanaquiti Iyaü au nisüri arrüna naurriantümo. Auqui itorrimiata aume. ");
INSERT INTO caxNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‛Arrtü ñemanauncurratoe isuasürüca aume, apicocosio arrüba nirracüpucu aume. ");
INSERT INTO caxNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Rranquiquia caüma pünanaquiti Iyaü, nauqui aicüpurutiti quiatarrü aubesa, naqui matoconobo ichoboñü. Arrti cuati nauqui ayurati y apucünuncuti aume. Tonenti Espíritu Santo, naqui uiche atusi aume nanaiña arrüna ñemanauncurratoe manunecatarrü. Arrti süsioti auchepe ümo enterurrü nausüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Arrübama maquiataca macrirrtianuca icu na cürrü chüpuerurrüpü asuriurumati, itopiqui chiyapacheriurumatipü, ni asuputaramatipü. Pero arraño apisuputacati, itopiqui anati auchepe y anatito au nabausasü ñana. ");
INSERT INTO caxNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Chiñococañopü tacanati bacharrü. Isecatatito auchepe ichepeti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chauqui chubiuquipü naneneca nauqui ariorrüñü auquina abarrüpecuqui. Auqui caüma arrübama macrirrtianuca icu na cürrü chüpuerurrüpü asaramañünqui. Pero arraño amasacañü ñana. Auqui torrio sobi aume ausüboriquibo, itopiqui arrüñü isüboriquia ito. ");
INSERT INTO caxNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Au manu nanenese ñana tusio aume que arrti Iyaü anati ichepeñü y arrüñü ichepeti, tamana nacarrtai subaca. Sane ito caüma arraño abaca ichepeñü y arrüñü auchepe taman nacarrtai ito nusaca. ");
INSERT INTO caxNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Apasusio arrüba nirracüpucu aume, apicocosio. Arrtü apicococañü, auqui caüma tusio iñemo que ta ñemanauncurratoe isuasürüca aume. Arrti naqui isuasürüca ümoti, cuasürütito ümoti Iyaü. Cuasürütito iñemo, auqui caüma itusiancacañü isucarüti. ");
INSERT INTO caxNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Arrti Judas (chitonentipü Judas Iscariote), nanti ümoti Jesús: —Señor, ¿causane arrianca aitusiancañü suisucarü, tapü isucarü na genterrü chicocoromapücü ta chaitusiancapücü? ");
INSERT INTO caxNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aiñumuti Jesús, nanti: —Itusiancacañü isucarü bama ümoche isuasürüca, bama isamutema isiu nirracüpucu. Tonema bama cuasürüma ümoti Iyaü. Arrti Iyaü ichepeñü sobecatü esama, nauqui supavivi ichepema. ");
INSERT INTO caxNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tapü arrübama chisuasürücapü ümoma, tonema bama chisamutempüma isiu nirracüpucu. Arrüna nirranunecaca chirranitatepü auqui niñoñemantoe, ta ui yacüpucurrti Iyaü, naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‛Surapoi ausucarü nanaiña arrüna sane, mientras yacaiqui auchepe. ");
INSERT INTO caxNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Arrti Iyaü icüpurutiti ñana Espíritu Santo, nauqui atocoti ichoboñü. Arrti bayurarati y mapucünunuti aume. Uiti caüma apaquioncaño iyo nanaiña arrüna tüsurapoi ausucarü y uitito caüma entienderrü año. ");
INSERT INTO caxNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‛Ñasamuna nariorrü aume, taiquiana urria nabaca. Pero arrübama macrirrtianuca icu na cürrü, sürümanama chicocoromapüñü, uimia chüpuerurrüpü urria nabaca. Pero arrüñü rrayuraca aume ñemanauncurratoe. Tapü ane penarrü aboi, y tapü aupirruca. ");
INSERT INTO caxNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chauqui tamoncoi nisura: Yecatü auquina aubesaqui, pero tiene que ise tato nauqui yaca tatito auchepe. Arrtü nampü isuasürüca aume, aupucünuncapü ui na tusio aume que ta yeca tato esati Iyaü, itopiqui arrti ane manrrü nüriacarrti rropünanaquiñü. ");
INSERT INTO caxNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Surapoicaü ausucarü arrüna sane, ümorrtü cocono ñana. Auqui apaquioncaño y apicococañü nurria. ");
INSERT INTO caxNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","‛Chauqui chüpuerurrüpü rranita yabaiturrü aume, itopiqui tüsai ayeti naqui üriabucati icu na cürrü, naqui choborese. Pero champü nüriacarrti iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero tiene que atusi ümo bama icu na cürrü, que cuasürüti Iyaü iñemo. Sane nauquiche isamute isiu yacüpucurrti iñemo. Chauqui, apatüsai, curi te auquina. ");
INSERT INTO caxNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nantito Jesús ümoma: —Arrüñü tacana arrone ñemanauncurratoe nihi uva, arrti naqui Iyaü tacanati naqui ñoñünrrü bacuirara itacu. ");
INSERT INTO caxNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Arrtü abe uturuqui ba nipiarrü arrüba chütaupü, botüsüro uiti. Y nanaiña arrüba obütau mocoñocono uiti nauqui abüta manrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Arraño chauqui turria nausüboriqui ui na nirranunecaca aume. ");
INSERT INTO caxNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sane nauquiche sucanañü aume, urria arrtü ichepeñüantai nabaca y arrüñü auchepe. Taman nipia uva chüpuerurrüpü üta arrtü tüsüro apüqui. Sane ito arraño chüpuerurrüpü apisamune arrüna urria arrtü chabasiquiapü ichepeñü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‛Arrüñü tacana taman nihi uva. Arraño tacana niyupaca. Arrtü abasiquia ichepeñü, apisamute aruqui nanaiñantai arrüna urria. Tapürrtü apiñococañü, champü isane puerurrü apisamune. ");
INSERT INTO caxNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Arrti naqui chasiotipü ichepeñü, pasabo ümoti tacana nubaca manio niyupaca, botüsüro nauqui ausü y botabo apüqui nihi uva, y montonabo na amoho. ");
INSERT INTO caxNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‛Arrtü abaca ichepeñü y chütacürusupü napaquionco iyo nisura, auqui caüma arrtü apanquiquia pünanaquiti Tuparrü isiu naurrianca, torrio aume uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arrtü apisamute aruqui nanaiña arrüba omirria, tusio ümo namanaiña, ta ñemanauncurratoe nirranunecasa año. Ui arrüna sane caüma ane ñanauncurrüma macrirrtianuca ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Arraño aucuasürüca iñemo, tacana nisuacürücü ümoti Iyaü. Tapü tacürusu naucuasürücü aumeampatoe, itopiqui aucuasürüca iñemo. Urria arrtü seguibo año isiuqui nirracumananauncu aume. ");
INSERT INTO caxNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Arrtü apacoconaunca iñemo, chütacürusupü naucua iñemo, tacana arrüñü rracoconaunca ümoti Iyaü, y sane chütacürusupü nisuasürücü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‛Rranitaca aume sane, nauqui aupucünu ichepeñü. Sane nauqui champü nitacüru naupucünuncu. ");
INSERT INTO caxNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Suraboira arrüna nirracüpucu aume: Aucuasürü aumeampatoe, tacana naucuasürücü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tusio arrüna yarusürürrü nicuasürücürrti osüborisapa oemo, arrtü oconca itoboti. ");
INSERT INTO caxNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Arrtü apisamute arrüna nirracüpucu aume, amigorrü año iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Chiñacañoinquipü tacana nacarrti mosorrü, itopiqui arrti mosorrü chütusiopü ümoti isane ñapensacarrti ipiatronetorrti. Iñacaño caüma amigorrü año iñemo, itopiqui tüsurapoi ausucarü nanaiña arrüna urapoiti Iyaü isucarüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Arrüñü chichacümanauncucapü aboi, arraño autacümanauncuca sobi. Torrio sobi aume nauqui apisamune aruqui nanaiña nomirria. Arrüna urriante aboi tiene que urura. Sane nauquiche caüma torrio aume uiti Tuparrü nanaiña arrüna apanquiquia pünanaquiti au nisüri. ");
INSERT INTO caxNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tone arrüna nirracüpucu aume: Nauqui aucuasürü aumeampatoe. ");
INSERT INTO caxNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‛Arrtü tüboricomantai aume arrübama chicocoropümañü, apaquionsaño, ta primero tüboricomantaito iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Arrtü nampü chapicococapüñü aucuasürücapü ümo bama chicocoropümañü auna icu na cürrü. Pero arraño ta autacümanauncuca sobi eanaqui bama chicocoropümañü. Uirri arrüna sane chauqui tüquiatarrü nabaca. Sane nauquiche tüboricomantai aume. ");
INSERT INTO caxNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Apaquionsaño iyo arrüna surapoi auscarü: “Champüti mosorrü valeoti manrrü pünanaquiti ipiatronetorrti”. Arrtü itaquisünümacanamañü, itaquisünümacanama año ito. Arrtü aboma bama icocotama arrüna nirranunecaca, aboma ito bama icocotama arrüna napanunecaca. ");
INSERT INTO caxNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nanaiña arrüna isamutema aume, es auqui niyaca, itopiqui chisuputaramatipü naqui uiche aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","‛Champü nipünatempüma arrtü nampü chisecapütü rranita ümoma. Pero como ta chauqui tisecatü rranita ümoma, sane nauquiche caüma ane nipünatema y champü urapoboiboma. ");
INSERT INTO caxNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Arrti naqui tüborico iñemo, tüboricotito ümoti Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Champü nipünatema arrtü nampü chisamutempü arrüba milagrorrü arrüpecuma, arrüba champüti quiatarrü ñoñünrrü puerurrü aisamunenti. Pero chauqui tarrtaimia nanaiña arrüna isamute, pero tüboricomainqui iñemo y ümotito Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero tiene que apasa sane, nauqui acoco arrüna nüriacarrü, itopiqui nantü Nicororrü sane: “Tüboricoma iñemo champü isane itopiquiche”. ");
INSERT INTO caxNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‛Pero cuati ñana naqui ñemanauncurratoe Espíritu Santo esaquiti Tuparrü, aupucünuncubu. Arrti manitanati au nisüri. Arrtü iñatai tato esati Iyaü, icüpucati nauqui ayeti tauna auchepe. ");
INSERT INTO caxNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Arraño ito tiene que apanita au nisüri, itopiqui amoncaño ichepeñü auqui maübo. ");
INSERT INTO caxNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nantito Jesús ümoma: —Tüsucanañü aume arrüna sane, nauqui puerurrü apasamu tairri ñome ba macocotoca arrüba cuabotiqui aume. ");
INSERT INTO caxNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ipenenoma año ñana auqui sinagoga. Y cuantionqui manio naneneca auche aitabairoma año, ñaquioncorrüma arrüna manrrü yaserebiquirrimia ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nanaiña arrüna sane tiene que aisamunema aume, itopiqui chisuputaramatipü naqui Iyaü, chisuputarapümañü ito. ");
INSERT INTO caxNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pero chauqui tüsurapoicaü ausucarü. Arrtü pasabo aume sane, apaquiocaño iyo nisuratücaü aume. ‛Champürrtü tüsurapoi ausucarü arrüna sane auqui maübo, itopiqui anancañünqui auchepe. ");
INSERT INTO caxNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero caüma yecatü esati naqui uiche aicüpuruñü. Pero champüti naqui abuturuqui ñanquitioti rropünanaquiñü cauta niyücü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ausuchecatai ui arrüna sane nisura aume. ");
INSERT INTO caxNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Suraboira ausucarü arrüna ñemanauncurratoe: Ümo nurria aume arrtü yecatü amopünanaqui. Itopiqui arrtü chüyecapütü, chüpuerurrüpü ayeti Espíritu Santo auna auchepe, naqui mapucünucunubu aume. Pero arrtü yecatü icüpucati aume. ");
INSERT INTO caxNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Itopiqui arrtü cuati, macuansomoconoti ümo bama macrirrtianuca icu na cürrü na atusi ümoma que ane nomünantü uimia, y causane nauqui urria nacarrüma au narrtarrti Tuparrü, y cuatü ñana carrticurrü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ta tone arrüna ünantü uimia: Chirranrrüpüma aicocoromañü y nauqui oncomatü iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tiene que atusi ümoma ta urria niyaca aübuti Tuparrü, itopiqui arrüñü yecatü esati Tuparrü chüpuerurrüpü asaramañünqui. ");
INSERT INTO caxNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y arrti choborese naqui yüriaburrü icu na cürrü, chauqui tüpaurramanati uiti Tuparrü, carrtigaboti ñana. ");
INSERT INTO caxNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‛Aninqui cütüpürrü surapoboibo ausucarü, pero chüpuerurrüpü aüro au nautanu caüma. ");
INSERT INTO caxNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero arrtü cuati naqui ñemanauncurratoe Espíritu Santo, tonenti caüma naqui uiche aiñunecanati año. Urapoiti ausucarü nanaiña arrüna pasaboboiqui ñana. Arrti chümanitanatipü auqui noñemarrti, ta urapoiti ausucarü arrüna oncoiti sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Arrti ane ñanauncurrti iñemo. Oncoiti nisura, auqui urapoiti ausucarü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nanaiña arrüna ane uiti naqui Iyaü tone niñenarrito. Sane nauquiche sucanañü que arrti Espíritu Santo tiene que asuriuti nisura y uraboiti ausucarü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‛Chauqui chububiuquipü naneneca niyaca auna abarrüpecu. Auqui caüma chamasacapüñünqui. Pero iyau ba mümanantai naneneca amasacañü tatito. ");
INSERT INTO caxNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Auqui arrübama ñanunecasarrti ñanquitioma pünanaquimiantoe, namatü: —¿Isanempü ümoche arrüna sane nurarrti? ¿Causane nanti one: “Yecatü esati Iyaü”? ");
INSERT INTO caxNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Isane ümoche arrüna nanti “iyau ba mümanantai naneneca”? Chentienderrüpü oñü ümo nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tusiatai ümoti Jesús que rranrrüma anquirioma pünanaquiti. Nanti ümoma: —Sucanañü te aume one, chububiuquipü naneneca nauqui chamasacapüñünqui. Pero iyau ba mümanantai naneneca amasacañü tato. Canapae abasiquiaiqui apapensario, ui arrüna sucanañü aume. ");
INSERT INTO caxNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ñemanauncurratoe: Arraño tiene que abareo ui nausuchequi isiuñü, pero arrübama macrirrtianuca icu na cürrü pucünüñama. Pero arrüna tarucapae nausuchequi campiabo tato ñana au naupucünuncu. ");
INSERT INTO caxNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pasabo aume tacana ümo taman paürrü, arrüna rranrrü ane mecu. Auqui maübo suchebo y orronene ümo. Pero arrtü tane mecu, chauqui chaquionüquipü ümo norrocorrü ümo, itopiqui nipucünuncurrü icuatati maniqui ipiaümacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sane ito arraño caüma ausucheca. Pero iseca tato yasaraño. Auqui caüma tarucu naupucünuncu. Champüti naqui puerurrü aiquiaübu amopünanaqui arrümanu naupucünuncu. ");
INSERT INTO caxNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‛Au manu nanenese champü isane apanquitioqui rropünanaquiñü. Suraboira ausucarü ñemanauncurratoe: Arrti Iyaü bacheboti aume nanaiña arrüna apanquiquia pünanaquiti au nisüri. ");
INSERT INTO caxNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta caümainqui chapanquiquiapü pünanaquiti au nisüri. Apanqui te, nauqui atorri aume uiti, auqui caüma champü nitacürü naupucünuncu. ");
INSERT INTO caxNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‛Surapoi ausucarü nanaiña arrüna sane ui pururrü machepecataca. Au cuantio naneneca chauqui chisurapoiquipü ausucarü aübu machepecataca, ta rranitaca caüma aume bien besüro icütüpüti naqui Iyaü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Au manio naneneca apanquiquia pünanaquiti Iyaü au nisüri. Champü nümoche rranquirio pünanaquiti Tuparrü nauqui aitorrimiati aume, ");
INSERT INTO caxNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","itopiqui tarucu naucua ümoti. Aucuasürüca ümoti itopiqui isuasürüca aume, itopiquito apicocota que arrüñü isecatü esaquiti. ");
INSERT INTO caxNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Arrüñü te isecatü esaquiti Iyaü auqui napese, auna acü. Pero caüma iñocota na cürrü, yasücübüca tato esati. ");
INSERT INTO caxNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Auqui namatü ümoti bama ñanunecasarrti: —Caüma anitaca bien besüro suiñemo, champürrtü urapoi aübu machepecataca. ");
INSERT INTO caxNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sumarrtai que tusio aemo nanaiña, tusiatai aemo arrüna suirranca; champü nümoche supanquirio apünanaquicü. Ui arrüna sane sopicocota que arrücü ayecatü esaquiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Auqui aiñumuti Jesús, nanti ümoma: —¿Así que apicococañü? ");
INSERT INTO caxNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pero tirranrrü aiñanai manu horarrü auche apiñarrimiacacaño. Cadati taman sürotitü au quiatarrü narücüquirri. Apiñococañü. Pero chiñoncocapü tamañü, itopiqui anati Iyaü ichepeñü. ");
INSERT INTO caxNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Surapoi arrüna sane ausucarü, nauqui urria nabaca sobi. Auna icu na cürrü autaquisürüca. Pero tapü aupirruca, arrüñü torrio iñemo nanaiña isüriacaboñü ümo na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Numo tüchauqui arrüna ñanitacarrti Jesús, asaratitü ape au napese, meaboti, nanti: —Iyaü, chauqui tiñatai arrüna horarrü. Aitusianca nisuasürücü aemo nauqui itusianca ito nacua iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Acheca iñemo isüriacaboñü ümo namanaiña macrirrtianuca icu na cürrü, nauqui yache isüboriquiboma bama torrioma iñemo obi. ");
INSERT INTO caxNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tone arrüna uiche chütacürusupü nisüboriquirrimia: Arrtü isuputaramacü naqui tamancüatai ñemanauncurratoe Tuparrü, y isuputaramañü ito, ta arrüñü Jesús, naqui Cristo, obi aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‛Iñanauncü auna icu cürrü, ui arrüna isamute ito nanaiña arrüna nacüpucu iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Iyaü, aitorrimia iñemo arrümanu champü tacanache nanentacarrü aesacü au napese, tacana tücañe, numo anancañünqui achepecü, numo churriantequipü na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‛Chauqui tüsurapoi nüri isucarü bama torrioma iñemo tücañe obi. Tacümanauncunuma obi y torrioma iñemo y arrüma chauqui ticocotama nura. ");
INSERT INTO caxNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chauqui tütusio ümoma que nanaiña arrüna ane sobi, ta nacumanata iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chauqui tüsurapoi nurria isucarüma nanaiña arrüna ucanu iñemo, y yasutiuma nurria nisura. Tütusio nurria ümoma, ta isecatü aesaquicü, arrücü aicüpucañü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‛Rreanca itacuma. Champürrtü rreanca itacu bama maquiataca icuna cürrü. Rreanca itacu bama torrioma obi iñemo, itopiqui arrücü yaütorrümacü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nanaiña arrüna ane sobi, ta naesa, y nanaiña arrüna ane obi, ta niyesa ito. Namanaiña bama perteneceboma aemo, perteneceboma ito iñemo. Sane nauquiche caüma tarucu ñanauncurrüma iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","‛Arrüñü chiyasiquiapü auna icu na cürrü, ta yeca tanu caüma aesacü. Tapü arrüma onconoma sobi. Iyaü, arrücü tarucu nüriaca y nacusüu. Acuira itacu bama torrioma iñemo obi nauqui aboma ichepeñü, tari aboma aübu tamantai ñapensacarrüma, tacana arroñü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nauquiche anancañü ichepema icu na cürrü, rracuiraca itacuma au nüri, y rrocümaca itacuma. Champüti eanaquimia naqui ensoro, cunauntaiñati maniqui taman, naqui tiene que aensoti, nauqui acoco arrüna nantü icu Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‛Caüma yeca tato aesacü. Chauqui tüsurapoi isucarüma auna icu na cürrü nanaiña arrüna sane, nauqui apucünuma, tacana arrüna nipucünuncu. ");
INSERT INTO caxNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Chauqui tisurapoi isucarüma arrüna nacüpucu. Arrübama macrirrtianuca icu na cürrü tüboricatai ümo bama nirranunecasa, itopiqui arrüma chüpertenecebopümainqui ichepe bama icuqui na cürrü, tacana ito arrüñü chüpertenecebopüñünqui ümoma. ");
INSERT INTO caxNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Chirranquiquia apünanaquicü, nauqui aiquiaüburuma eanaqui bama macrirrtianuca icuqui na cürrü, ta nauqui ocüma itacuma ñünanati choborese. ");
INSERT INTO caxNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Arrüma chüpertenecebopüma ümo bama icuqui na cürrü, tacana arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anuneca ümoma nura nauqui asamamecanama aemo, tapü aboma eana nomünantü. Itopiqui nura ñemanauncurratoe. ");
INSERT INTO caxNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Icüpucama arrüpecu bama icuqui na cürrü, tacana arrücü aicüpucañü ito icu na cürrü eanama. ");
INSERT INTO caxNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Y samamecanañü aemo itopiqui bama nirranunecasa, nauqui isamune isiu narrianca, sane nauqui asamamecanama ito aemo ñemanauncurratoe. ");
INSERT INTO caxNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‛Champürrtü rreanca cunauntaiña itacu bama ticocoromañü, sino itacu bama ito icocoromañünqui ñana ui bama nirranunecasa. ");
INSERT INTO caxNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rranquiquia apünanaquicü, Iyaü, ayura ümoma nauqui urria ñaquioncorrüma aübumantoe aübu taman nacarrtai ñanensacarrüma. Tacana arroñü, urria numaquionco oemomantoe. Arrüñü yaca achepecü y arrücü aca ichepeñü, taman nacarrtai nusaca. Ui arrüna chépe nacarrüma, arrübama macrirrtianuca icuqui na cürrü icocotama ito que ta obi aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Chauqui titorrimiata ümoma üriacaboma obi. Sane nauqui aye uimia tacana nusaca, taman nacarrtai nacarrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Arrüñü yaca au nausasürrüma. Arrücü aca au niyausasü. Sane nauquiche taman nacarrtai nusaca. Ui arrüna sane caüma tusio ümo bama icuqui na cürrü, que ta obi aicüpuruñü, y arrübama nirranunecasa cuasürüma aemo tacana nisua aemo. ");
INSERT INTO caxNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‛Iyaü, obi te aitorrimianama iñemo. Irranca nauqui aboma ichepeñü ñana auna cauta niyaca achepecü, nauqui asaraimia nanentacarrü yesañü, arrüna torrio iñemo obi, itopiqui isuasürüca aemo auqui maübo, numo churriantequipü na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Iyaü, arrücü urria nachücoi. Arrübama macrirrtianuca icuqui na cürrü chisuputaramapücü. Pero arrüñü isuputacü, y arrübama auna tusio ümoma ta obi aicüpuruñü. ");
INSERT INTO caxNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Chauqui tisurapoi nüri isucarüma, y surapoiqui ñana. Sane caüma tusio arrüna tarucapae nisua aemo. Sane ito nauqui ucuasürü ümoma, y arrüñü yaca au nausasürrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nauquiche chauqui neancarrti Jesús, atüraiti y sürotitü au manu bertarrü ichepe bama ñanunecasarrti topü manu nusürurrü nürirri Cedrón. ");
INSERT INTO caxNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Arrti Judas, naqui ñapabentecarrü ümoti Jesús, bien isuputacaiti arrümanu bertarrü, itopiqui nantarrtai sürotitü Jesús taha aübu bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Sane nauquiche iñataitito Judas acamanu. Cuati aübu masortaboca y aübu bama policiarrü auqui niporrti Tuparrü, yacüpucurrüma bama üriatu bama sacerdoterrü y bama fariseorrü. Macanama basaruca, sueca, cüseca y ransaca. ");
INSERT INTO caxNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Arrti Jesús tütusiatai ümoti arrüna pasabobo ümoti. Sürotitü cümenuma. Ñanquitioti pünanaquimia: —¿Quiti naqui iyoche napapachequi? ");
INSERT INTO caxNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Auqui namatü: —Iyoti Jesús, naqui auqui Nazaret. —Abu ta arrüñü —nanti Jesús ümoma. Arrti Judas, naqui ñapabentecarrü anancati acamanu ichepema. ");
INSERT INTO caxNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nauquiche nanti Jesús “abu ta arrüñü”, tobüsoma tato chacuma y taübücoma acü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Auqui ñanquitioti tatito Jesús: —¿Quiti iyoche apapacheca? Iñumutama: —Iyoti Jesús naqui auqui Nazaret. ");
INSERT INTO caxNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nanti tatito Jesús ümoma: —Uncamo arrüñü te naqui iyoche napapachequi. Apiñocosama bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sane nauquiche cocono arrümanu neancarrti Jesús, numo nanti: “Champüti ni tamantipü ensoro eanaqui bama torrioma iñemo obi, Iyaü”. ");
INSERT INTO caxNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Arrti Simón Pedro ane nicüserrti sürümanarrü. Aiquiaübuti auqui nibiainarrti, acheti ümoti maniqui imostorrti yarusürürrü sacerdoterrü. Tüsüro uiti nepanauncu numasurrti. Arrti maniqui mosorrü nürirrti Malco. ");
INSERT INTO caxNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tapü arrti Jesús nanti ümoti Pedro: —Aiña tato au nabaina arrümanu nacüse. Arrüna taquisürücürrü cuatü iñemo, ta uiti Iyaü. ¿Aensapü chiyasutiupü? ");
INSERT INTO caxNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Auqui arrümanuma masortaboca ichepe bama üriaturrüma y bama policiarrü israelitarrü iñenomati Jesús, itomoenomati. ");
INSERT INTO caxNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Auqui iquianamati au niporrti Anás. Ta arrti Anás yaüstoti Caifás, naqui yarusürürrü sacerdoterrü au manu añorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Arrti Caifás tonenti naqui nanti tücañe ümo bama üriatu bama israelitarrü: “Manrrü urria arrtü coiñoti naqui taman ñoñünrrü, pünanaquirrtü coiñoma namanaiña macrirrtianuca au na noesa nación”. ");
INSERT INTO caxNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Arrti Pedro ichepeti maniqui quiatarrü ñanunecasarrti Jesús süromatü isiuti. Arrti maniqui quiatarrü isuputaratiti nurria maniqui yarusürürrü sacerdoterrü. Sane nauquiche puerurrü aürotipo au manu nusuara au niporrti Anás, auna cauta tiquianamati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tapü arrti Pedro anancatiatai türüpo abeu tururrü. Auqui cuati tato abeu tururrü maniqui quiatarrü ñanunecasarrti Jesús, naqui isuputaratiti yarusürürrü sacerdoterrü, na anitati aübu manu cupiquirri bacuirara abeu tururrü, nauqui ache permisorrü ümoti Pedro na aürotipo ito. ");
INSERT INTO caxNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Auqui nantü manu cupiquirri ümoti Pedro: —Canapae arrücü ito ñanunecasa manu noñünrrü Jesús. —Champürrtü arrüñü —nanti Pedro ümo. ");
INSERT INTO caxNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rrimianene manu tobirri. Arrümanuma mamosoca y bama bacuirara maunrrimianama pese acamanu. Aboma atüraimia baperoma. Auqui arrti Pedro aürotitito esama, atüraitito ichepema, baperotito. ");
INSERT INTO caxNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Arrti maniqui yarusürürrü sacerdoterrü Anás ñanaquitioti pünanaquiti Jesús, nanti: —¿Ñacubama anunecasa? ¿Isane arrüna anunecaca? ");
INSERT INTO caxNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aiñumuti Jesús: —Rranitaca isucarü namanaiña macrirrtianuca au niporrti Tuparrü y au ba poca sinagoga, auna cauta nantarrü iyoberabaramacü bama israelitarrü. Champürrtü iñanecatatai nirranunecaca. ");
INSERT INTO caxNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Causane abasiquia apanquirio rropünanaquiñü? Apanquisio pünanaqui bama oncoimia nisura, arrüma tusio nurria ümoma. ");
INSERT INTO caxNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nauquiche nanti arrüna sane, tamanti maniqui policiarrü bacheboti isuti Jesús, nanti ümoti: —¿Causane anita sane ümoti naqui yarusürürrü sacerdoterrü? ");
INSERT INTO caxNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aiñumuti Jesús, nanti ümoti: —Urasoi te isucarüñü arrtü churriampü nirranitaca ümoti. Tapürrtü urria nirranitaca, ¿causane ocüsi iñemo? ");
INSERT INTO caxNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Auqui arrti Anás bacüpuruti nauqui aitomoenomati Jesús y aiquianamati esati Caifás, naqui quiatarrü yarusürürrü sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tapü arrti Pedro anatiqui atüraiti baperoti manu pese. Auqui namatü ümoti: —Arrücü ito saon ñanunecasarrti naqui ñoñünrrü. Aiñumuti Pedro: —No, champürrtü arrüñü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Anancati acamanu maniqui taman imostorrti yarusürürrü sacerdoterrü, ipiarientetorrti Malco, naqui tüsüro numasurrti uiti Pedro. Arrti maniqui ñoñünrrü nanti ümoti Pedro: —Abu arrücü te, ta yasacü ichepeti Jesús one taha au manu bertarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Auqui mapañati tatito Pedro, y au manu rratorrü puru pohorrü curasürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tanati Jesús au niporrti Caifás. Tücuatü nanenese iquianamati auqui taha au niporrti maniqui yüriaburrü rromanorrü. Arrübama israelitarrü champürrtü süromampo isiuti Jesús, ui nirrucurrüma tapü ane nomünantü uimia, itopiqui arrti yüriaburrü rromanorrti. Itopiqui arrtü anempü nomünantü uimia, chüpuerurrüpü aama au manu pierrta parrcua. Sane ñaquioncorrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sane nauquiche arrti Pilato, naqui yüriaburrü, sürotitü türüpo esama, anquirioti pünanaquimia: —¿Isane nomünantü amarrtai isamutenti naqui ñoñünrrü? ");
INSERT INTO caxNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Arrüma aiñumuma sane: —Arrtü nampü champü nipünatenti maniqui, chüsopitorrimiacatipü aemo. ");
INSERT INTO caxNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Apiquiarrti arraño —nanti Pilato ümoma—, apacurrta aübuti, apiña isiu manu nüriacarrü aboi. Aiñumuma tatito, namatü: —Pero arrüsomü champü sobüriaca nauqui sopitabairoti taman ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sane caüma cocono arrümanu urapoiti Jesús tücañe, arrüna causane niyücü niconcorrti uimia. ");
INSERT INTO caxNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Auqui arrti Pilato süroti tatopo. Itasurutiti Jesús. Ñanquitioti pünanaquiti: —Urasoi isucarüñü, ¿arrücü üriatu bama israelitarrü? ");
INSERT INTO caxNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aiñumuti Jesús: —¿Arrüna anquitio rropünanaquiñü, sane, noñemantoe, o arrüna oncoi nisüri ui maquiataca? ");
INSERT INTO caxNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aiñumuti Pilato: —¿Naquionco arrüñü israelitarrüñü? No, arrüñü te rromanorrüñü. Ui bama te apariente y ui bama üriatu sacerdoterrü aiquianamacü tauna yesañü. ¿Causane obi? ");
INSERT INTO caxNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Auqui nanti Jesús: —Arrüna nisüriaca champürrtü icuqui na cürrü. Arrtü nampü icuqui na cürrü, arrübamampü aboma iquiana nisüriaca ocümanamapüma ichacuñü, tapü iñenca ui bama israelitarrü. Tapü arrüna nisüriaca champürrtü icuqui na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Auqui ñanquitioti tatito Pilato pünanaquiti: —¿Así que arrücü yüriaburrücü? Aiñumuti Jesús: —Arrüñü yüriaburrüñü. Ümo te yaca icu na cürrü, ümo te isetü. Isecatü nauqui suraboi arrüna ñemanauntu nurarrti Iyaü. Arrübama urria ümoma arrüna ñemanauntu nisura, oncoimia y icocotama. ");
INSERT INTO caxNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aiñumuti Pilato, nanti: —¿Isanempito naca arrüna ñemanauntu? Auqui süroti tatito türüpo esa bama israelitarrü, nanti ümoma: —Canapae champü nipünatenti naqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero arrüñü cada añorrü ümo na pierrta iñemecacati taman auqui preso. ¿Aurrianca caüma iñemecanati naqui üriatu bama israelitarrü, naqui Jesús? ");
INSERT INTO caxNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Auqui namanaiña tosibicoma, namatü: —¡Tapü aiñemecacati maniqui! ¡Aiñemecasarrti Barrabás! Arrti maniqui Barrabás cusüpürrti. Anancati au preso. ");
INSERT INTO caxNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Auqui arrti Pilato bacüpuruti nauqui acüboriti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Arrümanuma masortaboca maumenoma cümeca itarusüboti Jesús. Iñatama itati. Iñatama ito aibiboti cüturiqui. ");
INSERT INTO caxNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Atüraimia esati, tosibicoma y namatü: —¡Viva ümoti naqui üriatu bama israelitarrü! Ñompebairomati. ");
INSERT INTO caxNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Arrti Pilato süroti tatito türüpo esa bama israelitarrü, nanti ümoma: —Amasasatü, iquiacati tauna aubesa, nauqui atusi aume, que ta champü nipünatenti tabüco sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Auqui cuati Jesús uimia türüpo aübu manio cümeca itati, y ane ito manu naibirri cüturiqui apüti. Nanti Pilato ümoma: —Carüti naqui ñoñünrrü auna. ");
INSERT INTO caxNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nauquiche asaramatü ümoti bama üriatu bama sacerdoterrü y bama policiarrü ichépe nurria nitosibirrimia, namatü: —¡Aiñarrti apü curusürrü! ¡Aiñarrti apü curusürrü! Nanti Pilato ümoma: —Apiquiarrti y apiñarrti arraño apü curusürrü. Arrüñü chirrancapü, chütabücopü sobi arrtü ane nipünatenti naqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aiñumuma bama israelitarrü, namatü: —Arrüsomü ane nüriacarrü soboi. Arrti naqui ñoñünrrü tiene que aconti isiu arrüna ane corobo au nüriacarrü, itopiqui arrti isamunutiyü tacana Tuparrti. ");
INSERT INTO caxNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Numo oncoiti Pilato arrüna sane, manrrü nirrucurrti. ");
INSERT INTO caxNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iquianatiti Jesús tatopo au niporrti. Acamanu anquirioti pünanaquiti. —¿Auquichecü? Pero arrti Jesús chiñumutatipü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nanti Pilato tatito ümoti Jesús: —¿Causane chaiñumutapü? ¿Taqui chütusiopü aemo que arrüñü ane nisüriaca? Arrtü irrianca puerurrüñü iñemecanü, puerurrü ito iñanü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aiñumuti Jesús: —Arrücü ane nüriaca iñemo, itopiqui torrio aemo uiti Tuparrü. Sane nauquiche arrübama uiche aitorrimianamañü aemo ane manrrü nomünantü uimia apünanaquicü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ui arrüna sane nurarrti Jesús, arrti Pilato bapacheroti tatito niquiubuti, causane nauqui emecati Jesús. Pero arrübama israelitarrü tosibicoma, namatü: —¡Arrtü aiñemecacati, champürrtü amigorrücü ümoti yarusürürrü yüriaburrü César, itopiqui arrti naqui isamunutiyü yüriaburrü chauqui enemigorrti ümoti yarusürürrü yüriaburrü César! ");
INSERT INTO caxNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Numo oncoiti Pilato arrüna nurarrüma, bacüpuruti na aiquianamati Jesús türüpo. Auqui atümoti Pilato manu siyarrü nesa bacurrtacarrü au na cauta nürirri ito uimia “Canca”, auqui hebreo namatü “Gabata”. ");
INSERT INTO caxNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chauqui toce au manu nanenese virrpera parrcua. Auqui nanti Pilato ümo bama israelitarrü: —Carüti naqui yüriaburrü aume auna. ");
INSERT INTO caxNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Arrüma tosibicoma, namatü: —¡Tari comati, aiquiarrti auqui na! ¡Aiñarrti apü cursürrü! Nanti Pilato: —¿Aensapü puerurrü iñanati apü curusürrü naqui abüriatu? Aiñumuma manuma üriatu bama sacerdoterrü: —Arrüsomü champüti quiatarrü yüriaburrü suiñemo, cunauntaiñatiatai naqui yarusürürrü yüriaburrü César au Roma. ");
INSERT INTO caxNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Auqui arrti Pilato itorrimianatiti Jesús mecu bama masortaboca, nauqui aiñanamati apü curusürrü. Sürotitü Jesús uimia. ");
INSERT INTO caxNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iñatama ito nicurusürrti ompacüti, niyücürrti uimia au manu nürirri Golgota, auqui besüro nantü “nipiai nitanu macoiñoca”. ");
INSERT INTO caxNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Acamanu crabuti uimia apü nicurusürrti. Crabuma ito acamanu ichepeti bama torrü maquiataca mañoñünca apü nicurusürrüma, tamanti au nepanauncurrti Jesús, arrti quiatarrü au nepaurrü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Arrti Pilato bacüpurutito nauqui aiñama nicororrü apü nicurusürrti Jesús, nantü sane: “Tonenti Jesús auqui Nazaret, naqui üriatu bama israelitarrü”. ");
INSERT INTO caxNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sürümanama bama israelitarrü leheboma manu nicororrü, itopiqui arrümanu cauta crabuti Jesús uimia apü curusürrü ane saimiantai ümo pueblurrü. Ananca corobo auqui trerrü manitacaca, auqui hebreo, auqui griego y auqui latín. ");
INSERT INTO caxNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tapü arrübama üriatu bama sacerdoterrü namatü ümoti Pilato: —¡Tapü aiconomota sane que ta tonenti naqui yüriaburrü ümo bama israelitarrü! Mejor aiconomo sane: “Arrti naqui ñoñünrrü nanti que yüriaburrti ümo bama israelitarrü”. ");
INSERT INTO caxNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tapü arrti Pilato nanti: —Arrüna ane corobo sobi, sane süsio corobo. ");
INSERT INTO caxNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Numo tütanati Jesús apü curusürrü ui bama masortaboca, arrüma ichepesünatama naibirrti, cuatro peasoca uimia, omenotü taiquiana taman peasorrü ui cadati taman. Ane ito nicüburrirrti, arrüna urriante tamantai peasorrü, champürrtü quipieno. ");
INSERT INTO caxNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Namatü bama masortaboca: —Ensoratai arrtü uiquiompünata. Mejor suerteabo osoi, na atusi quiti naqui uiche aürotü. Sane caüma cocono uimia arrüna urapoicaü icu Nicororrü: “Rrepartibo uimia arrüba nisaibi. Suerteaboma iyo nirrüburri”. Tone arrüna isamutema bama masortaboca. ");
INSERT INTO caxNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nipiacütoti Jesús ananca atürai esa nicurusürrti ichepe naruquirri. Ane ito Mariarrü nicüpostoti Cleofas y Mariarrü Matarenarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Arrti Jesús asaratitü ümo nipiacütoti y ümotito naqui ñanunecasarrti, naqui cuasürütiapae ümoti. Anancati atüraiti esa nipiacütoti. Auqui nanti Jesús ümo: —Arrti naqui anati aesacü, tonenti caüma ahü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nantito ümoti maniqui ñanunecasarrti: —Carü manu aesacü, asusio tacana napacüma. Au manu nanenese arrti maniqui ñanunecasarrti yasutiuti au niporrti, tonenti caüma asaratitü itacu. ");
INSERT INTO caxNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Arrti Jesús tütusio ümoti, que ta tüsai aconti y atacüru yatrabacacarrti. Manitanati tatito, nauqui acoco nurria Nicororrü. Nanti: —Ichosüca. ");
INSERT INTO caxNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ananca acamanu taman bausürrü ataso ui niyü uva pichananene. Auqui aüromatü masortaboca aiñunuma rriese eana, aiñama cutacu suema abaesa aüromatü aiñama ahiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Auqui arrti chaboti chimiantai, auqui nanti: —Chauqui tanaiña urriante. Auqui mataconoconañati, coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Arrübama israelitarrü ñanquitioma pünanaquiti Pilato, na acüputi masortaboca nauqui aiñaneoma nitaparrüma manuma aboma apü curusüca, nauqui conto acoma. Sane nauqui puerurrü acaübuma ubapüqui curusüca. Ñanquitioma sane itopiqui viernerrü au manu nanenese, niyücürrü ümo sabaro, manu nanenese nesa macansacarrü. Arrümanu sabaro samamecana ümoma, ta nesa pierrta parrcua. Chirranrrüpüma na abe nicunturrüma bama coiño apü curusüca au manu nanenese. ");
INSERT INTO caxNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Así que arrübama masortaboca iñataimia yobesa manio curusüca. Iñaneontama nitaparrüma manuma torrü aboma apü curusürrü petacuti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Numo iñataimia esati Jesús, asaramati, ta chauqui tücoiñoti. Sane nauquiche champürrtü iñaneontama nitaparrti. ");
INSERT INTO caxNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Arrti maniqui taman sortaborrü ane mecuti nesarrti ransarrü. Uirri iquiusutati nipetacurrti Jesús. Auqui osüro notorrti y turrü auqui manu nobüriturrü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Arrüñü Juan yarrtai nurria nanaiña arrüna pasabo sane. Tusio te iñemo, que ta ñemanauntu arrüna surapoi. Sane nauquiche arraño ito puerurrü apicoco. ");
INSERT INTO caxNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sane pasabo nauqui acoco nanaiña arrüna anancatai corobo sane: “Chüpuerurrüpü aneon ni tamampü nipiairrti”. ");
INSERT INTO caxNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nantito sane au quiatarrü narücüquirri icu Nicororrü: “Asaramati ñana maniqui ponsüro uimia”. ");
INSERT INTO caxNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Anancati au manu tiemporrü maniqui ñoñünrrü nürirrti José, naqui auqui manu pueblurrü nürirri Arimatea. Arrti icocorotiti Jesús, pero anecanati ñacoconauncurrti ui nirrucurrti ñünana bama üriatu israelitarrü. Arrti naqui José yebotitü esati Pilato anquirioti pünanaquiti, arrtü puerurrü aiquiaübuti nicunturrti Jesús apüqui curusürrü. Nauquiche tütorrio ümoti uiti Pilato, auqui sürotitü aiquiaübuti nicunturrti apüqui curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Arrtito Nicodemo cuati ayurati ümoti José. Arrti maniqui Nicodemo tonenti naqui yapasearatiti tücañe ümoti au tobirri. Macanati treinta kilo perfume aübu mirra, arrüna urriantai norimia, nauqui aisemati nicunturrti Jesús uirri. ");
INSERT INTO caxNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Arrti José ichepeti Nicodemo isematama nicunturrti Jesús ui manu perfume y mirra. Auqui icümurriquiatama. Sane nesarrüma costumbrerrü bama israelitarrü ümo bama tücoiño, nauqui aüroma cütu. ");
INSERT INTO caxNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Au manu cauta anancati Jesús apü curusürrü ane taman bertarrü. Acamanu ane taman nusutu canrrü, icübo bama tücoiño. Pero champüti naqui tüsüro cütu ahu, itopiqui nuevurrüqui. ");
INSERT INTO caxNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Au manu nusuturrü iñanamati cütu Jesús, itopiqui saimiantai y tirranrrü aiñanai manu nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pasao manu nanenese sabaro nesa macansacarrü. Tominco tansürü tomiquianeneiqui nurria sürotü Mariarrü Matarenarrü esa manu nusutu canrrü. Numo iñatai acamanu saimia arrtai tururrü aurübo, carübo manu canrrü sürümanarrü uiche ananca taburrio. ");
INSERT INTO caxNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Auqui sürotato yarucurrü esati Simón Pedro y esati maniqui quiatarrü, naqui cuasürütiapae ümoti Jesús. Nantü ümoma: —Opiquiata nicuntu Señor auqui nicürrü, y chütusiopü iñemo cauta apiña. ");
INSERT INTO caxNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Auqui arrti Pedro ichepeti maniqui quiatarrü süromatü esa nicürrti Jesús, yarucurrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Arrti maniqui quiatarrü manrrü fuerte yarucurrti pünanaquiti Pedro. Cusürüboti aiñanainti esa manu nusutu canrrü. ");
INSERT INTO caxNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Basaboricoti ahu auqui türüpo, champürrtü sürotipo. Besüro narrtati ñome cüburriquia, uiche ananca cüburrio nicunturrti Jesús. Abiqui tahapo acü. ");
INSERT INTO caxNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Auqui iñataitito Simón Pedro, besürotipo, asaboriti. Asariotiño manio cüburriquia. ");
INSERT INTO caxNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Arrtaitito manu nicüburri nitanurrti Jesús. Champürrtü ane ichepe manio piquiataca nicüburrirrti, ta ananca au quiatarrü narücüquirri acomorabo. ");
INSERT INTO caxNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Auqui arrti maniqui quiatarrü, naqui cusürüboti aiñanainti acamanu, sürotipo ito. Arrtaiti nanaiña, y aüboqui aicocoti que arrti Jesús chauqui tüsüboricoti tato. ");
INSERT INTO caxNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Itopiqui hasta au manu nanenese chiyeboiquipü uimia arrüna Nicororrü. Ane te corobo, que arrti Jesús tiene que asüboriti tato iyau niconcorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Auqui süroma tato au niporrüma. ");
INSERT INTO caxNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tapü arrümanu Mariarrü ane tatito esa manu nusuturrü, nicürrti Jesús, areoro. Basaboricopo ahu. ");
INSERT INTO caxNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Auqui asaratü ümo bama torrüma angelerrü, champü tacanache nipurusubiqui naibirrimia. Aboma tümonsoma auna cauta ananca nicunturrti Jesús, tamanti auna cauta amonquio nipoperrti, arrti quiatarrü auna cauta ananca nitanurrti. ");
INSERT INTO caxNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Arrüma ñanquitioma pünanaqui: —Paürrü, ¿causane areoracacü? —Itacu Señor —nantü—, opiquiata auqui na, y chütusiopü iñemo cauta nacarrü. ");
INSERT INTO caxNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Au manu rratorrü apebü, asaratato chacu, auqui asaratü ümoti Jesús, atüraiti esa. Abu chütusiopü nurria ümo arrtü tonenti. ");
INSERT INTO caxNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ñanquitioti Jesús pünanaqui: —Paürrü, ¿causane areoracacü? ¿Quiti iyoche napachequi? Tone ñaquioncorrü que arrti maniqui bacuirara itacu manu bertarrü. Sane nauquiche nantü ümoti: —Señor, arrtü obi aiquia auqui na, urasoi isucarüñü cauta aiñata, nauqui yerotü iquia. ");
INSERT INTO caxNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—¡María! —nanti Jesús ümo. Auqui asaratü nurria ümoti, isuputarati. Nantü ümoti sane auqui hebreo, arrüna ñanitacarrü: —¡Raboni! —nantü auqui besüro “Maestro”. Auqui sürotü esati. ");
INSERT INTO caxNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nanti Jesús ümo: —Tapü aiñencañü, itopiqui sürotiqui niyücü tato esati Iyaü. Pero acosi tato uraboi isucarü bama masaruquitaiqui nirranunecasa, yeca tato esati Iyaü, naqui Abaü ito, ta esati Tuparrü naqui ümoche nirranauncu y napanauncu ito. ");
INSERT INTO caxNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Auqui sürotü Mariarrü Matarenarrü esa bama ñanunecasarrti Jesús, nantü ümoma: —¡Yasatai Señor! Urapoi isucarüma nanaiña arrüna nanti Jesús ümo. ");
INSERT INTO caxNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chauqui tütobiquia au manu nanenese tominco. Arrübama ñanunecasarrti Jesús iyoberabaramacü au manu taman porrü. Mamana bien nurria uimia turuca, ui nirrucurrüma ñünana bama üriatu bama israelitarrü. Rrepenteatai tanati Jesús arrüpecumampo, manitanati nurria ümoma, nanti: —Taiquiana urria nabaca. ");
INSERT INTO caxNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Auqui itusiancatati isucarüma arrümanio nobüriturrü ümoti apü neherrti y nipetacurrti. Arrüma pucünuñama ui arrüna asaramati. ");
INSERT INTO caxNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nanti tatito ümoma: —Taiquiana urria nabaca. Icüpucaño caüma isiatai tacana yacüpucurrti Iyaü tücañe iñemo. ");
INSERT INTO caxNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Auqui bausucüroti ümoma y nanti: —Apasusiusurrti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yachera aume abüriacabo nauqui puerurrü apiñarrimiaca tato nomünantü ui macrirrtianuca. Y arrti naqui chapirrimiacatapü nomünantü uiti, süsioti aübu nipünatenti. ");
INSERT INTO caxNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tamanti uturuqui manuma doce apostolerrü nürirrti Tomás, nürirrtito uimia “Tocarrü”. Arrti chanancatipü ichepema nauquiche iñataiti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Numo tüsürotitito Jesús, iñataiti tato Tomás. Auqui urapoimia isucarüti que arrüma asaramati Jesús. Tapü arrti iñumutati: —Arrüñü icocota arrtü yarrtai neherrti obürio oboi crabuca. Irranca te iñe arrümanu nobüriturrü ümo neherrti y ümo nipetacurrti. Aüboqui puerurrü icoco que süboricoti tato. ");
INSERT INTO caxNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pasao taman semana. Aboma tatito au manu porrü y arrti Tomás anati ichepema. Bien mamana turuca. Rrepenteatai tanati tatito Jesús arrüpecumampo. Manquioti nurria ümoma, nanti: —Taiquiana urria nabaca. ");
INSERT INTO caxNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Auqui nanti ümoti Tomás: —Asasai niñe, aiñe na nobüriturrü, aiñe ito nobüritu nipetacu. Tapü asiquia aübu torrü napensaca, tari aicocosoñü nurria. ");
INSERT INTO caxNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aiñumuti Tomás: —¡Arrücü Tuparrücü y arrücü Señorcü iñemo! ");
INSERT INTO caxNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nanti Jesús ümoti: —Caüma aicococañü, itopiqui tasacañü. Urria nacarrüma bama chasarapümañü, pero icocoromañü. ");
INSERT INTO caxNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Arrti Jesús isamutenti sürümana piquiataca milagrorrü, arrüba chübocorobopü au na librurrü. Isamuniontiño isucarü bama ñanunecasarrti. ");
INSERT INTO caxNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero tonehion arrüba bocorobo sobi au na librurrü, nauqui atusi aume que arrti Jesús tonenti naqui Aütorrti Tuparrü. Arrtü amoncatü ümoti auqui caüma torrio aume ausüboriquibo uiti. ");
INSERT INTO caxNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Auqui arrti Jesús itusiancanatiyü tatito isucarü bama ñanunecasarrti abeu manu narubaitu turrü nürirri Tiberias. Pasabo sane: ");
INSERT INTO caxNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Amoncoma chépema arrti Simón Pedro, arrti Tomás naqui tocarrü, arrti Natanael naqui auqui Caná auqui manu cürrü Galilea, arrübama torrü aütorrti Zebedeo y arrübama torrü maquiataca eanaqui manuma doce ñanunecasarrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Auqui nanti Simón Pedro ümo bama maquiataca: —Yecatü yasu nopiocorrü ui momese. Arrübama maquiataca namatü: —Somecatü asiucü, curi te. Auqui süromatü au taman barco au tobirri. Pero enterurrü manu tobirri champürrtü bacharama nopiocorrü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tücuatü nanenese arrti Jesús anancati abeu manu narubaitu turrü. Tusioti auqui barco. Tapü arrübama ñanunecasarrti chütusiopü ümoma arrtü tonenti. ");
INSERT INTO caxNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Auqui tosibicoti ümoma, nanti: —Masaütaiqui, ¿apachaca pario nopiocorrü? Arrüma iñumutama, namatü: —Champü, ni tamampü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Auqui nanti ümoma: —Apiña tatito naumome eana turrü au nepanauncu naubesa barco. Sane caüma apachaca nopiocorrü. Isamutema isiu nurarrti. Auqui bacharama sürümana nopiocorrü ui nimomesüma. Umianene oboi. Chüpuerurrüpü aitonoma au barco. ");
INSERT INTO caxNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Arrti maniqui cuasürütiapae ümoti Jesús nanti ümoti Pedro: —¡Tonenti Señor Jesús! Numo oncoiti Pedro arrüna sane, iñatati niquiamisarrti cütüpüti, itopiqui sipoñoenotiatai. Auqui tobüsoti eana turrü, batusuti hasta nabeu turrü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Amoncoma saimia nabeurrü, taqui cien metros. Tapü arrübama maquiataca rremaboma barco hasta nabeurrü isiuti Pedro, aübu ñatonocorrüma isiuma ümo manu momese ataso ui nopiococa. ");
INSERT INTO caxNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nauquiche iñataimia abeu, acamanu arrtaimia pese, aübu sücüborrü. Abe nopiococa oto sücüborrü macünucunu y abe ito pan. ");
INSERT INTO caxNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nanti Jesús ümoma: —Apaca tauna mümana nopiococa, omeanaqui manio aübo apacaübuca. ");
INSERT INTO caxNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Auqui arrti Simón Pedro sürotitü esa barco aitonoti momese taiyiritu. Ane ataso ui ciento cincuenta y trerrü nopiococa arrüba posürümanaca. Pero chüquiopüropü momese yupu. ");
INSERT INTO caxNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nanti Jesús ümoma: —Ausiapata auba. Pero champüti eanaqui bama ñanunecasarrti ñanquitio pünanaquiti nürirrti, cüsobomantai. Pero ta tusio te ümoma que tonenti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Auqui atüraiti Jesús esama, iquiatati manu pan, itorrimiatati ümoma. Sane ito isamutenti aübu manu nopiocorrü obiquio. ");
INSERT INTO caxNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sane caüma tabe trerrü vecerrü itusiancanatiyü Jesús isucarüma, nauquiche tüsüboricoti tato auqui niconcorrti. ");
INSERT INTO caxNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Chauqui niyacarrüma, ñanquitioti Jesús pünanaquiti Simón Pedro: —Simón, aütorrti Jonás, ¿isuasürüca manrrü aemo pünanaqui bama maquiataca auna? Iñumutati Pedro: —Señor, tusio aemo ta acuasürüca nurria iñemo. Nanti Jesús ümoti: —Acuira nurria itacu bama icocoromañü tacana yutacu nobirramanca. ");
INSERT INTO caxNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Auqui ñanquitioti tatito Jesús pünanaquiti: —Simón, aütorrti Jonás, ¿isuasürüca aemo? —Tusio te aemo Señor, acuasürüca iñemo —nanti. Nanti Jesús ümoti: —Acuira y anuneca nurria ümo bama icocoromañü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Coboi pario ñanquitioti tatito pünanaquiti Pedro: —Simón, aütorrti Jonás, ¿isuasürüca aemo? Auqui arrti Pedro sucheboti ui na ñanquiquirrti trerrü vecerrü pünanaquiti arrtü cuasürüti ümoti. Auqui nanti ümoti: —Señor, tusio aemo nanaiña. Tusio ito aemo que ta acuasürüca iñemo. Nanti Jesús: —Acuira nurria itacu bama icocoromañü, aiñununecasama nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Suraboira asucarücü ñemanauncurratoe: Tücañe numo yaürrücüqui aipoñoencü obiatoe, aücatü auna cauta narrianca. Pero arrtü tüpomacü, aipesünacaquio caüma napa y cuati quiatarrü itomoenotiyü y iquianatiyü auna cauta charriancapü aürotü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ui arrüna sane nurarrti Jesús urapoiti pario isucarüti Pedro causane ñana niconcorrti y ñanauncurrti ümoti Tuparrü ui niconcorrti. Auqui nantito ümoti: —Ariacu isiuñü. ");
INSERT INTO caxNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Arrti Pedro basücübücoti tato, asaratitü ümoti maniqui cuasürütiapae ümoti Jesús. Tonenti naqui anancati petacuti Jesús nauquiche basoma au manu virrpera pierrta parrcua, y ñanquitioti pünanaquiti: “Quiti naqui uiche aitorrimianatiyü”? Tonenti naqui anati acamanu pürücüti Pedro. ");
INSERT INTO caxNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Numo asaratitü Pedro ümoti, ñanquitioti pünanaquiti Jesús: —¿Señor, carüti naqui? ¿Isane pasabo ñana ümoti? ");
INSERT INTO caxNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aiñumuti Jesús: —Arrtü irranca na asüboriti icu na cürrü cheperrtü iseca tato, tapü ane nümoche obi. ¡Arrücü ariacu isiuñü, aisamuse isiu arrüna nirracüpucu! ");
INSERT INTO caxNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sane nauquiche iñarrio nürirrti maniqui taman au nanaiñantai eana bama icocoromati Jesús, arrti chüpuerurrüpü aconti. Abu ta chüsanempü nurarrti Jesús. Ta solamenterrü nanti: “Arrtü irranca na asüboriti icu na cürrü cheperrtü isecatato, ¡tapü ane nümoche obi!” ");
INSERT INTO caxNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Arrüñü Juan maniqui ñanunecasarrti Jesús, naqui cuasürütiapae ümoti Jesús. Yarrtai nanaiña arrüna pasabo y surapoi ausucarü y iconomota ito. Tusio nurria oemo, ta ñemanauntu nurria arrüna corobo sobi. ");
INSERT INTO caxNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Abe sürümana arrüba omirriante uiti Jesús, arrüna chübocorobopü. Arrtü suirrancapü supaconomo nanaiña arrüna urriante uiti, nirraquionco caümainquipü chütacürusupü supaconomoco.");
INSERT INTO caxNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Süro tanu nirraquionco aemo naqui Teófilo. Au manu cusürübo niyesa librurrü iconomota nanaiña arrüna nisamutenti y ñanunecacarrti Jesucristo auqui maübo, ");
INSERT INTO caxNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta que iñatai manu nanenese auche camperoti tato au napese uiti Tuparrü. Numo anatiqui icu na cürrü, manunecanati ui nicusüurrti Espíritu Santo ümo bama nesarrti apostolerrü, bama tacümanauncunu tücañe uiti. Urapoiti isucarüma arrüna yachücoboiboma. ");
INSERT INTO caxNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Numo tüpasao nitaquisürücürrti, süboricoti tato, itusiancanatiyü isucarüma. Cuarenta naneneca nacarrti aübuma. Sane nauquiche tusio nurria ümoma, ta süboricoti tato, y tacane urapoiti isucarüma causane arrtü üriabucati Tuparrü eanama icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nauquiche anancatiqui ichepema, nanti ümoma: —Tapü amecatü auqui Jerusalén. Aparrüpera cheperrtü cocono arrümanu nurarrti Iyaü, que arrti Espíritu Santo cuati ñana aume. ");
INSERT INTO caxNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tai ñemanauntu, arrti Juan tücañe maunimianati aume eana turrü —nanti ümoma—, pero ta chübubiuquipü cuantio naneneca arrüna auche ayeti Espíritu Santo au nabausasü. Tone caüma arrüna nabüriqui tato. ");
INSERT INTO caxNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ñanquitioma ito pünanaquiti, namatü: —Señor, ¿taqui auquito caüma taesüburu tato obi arrüna sobesa cürrü Israel pünanaqui bama rromanorrü, nauqui yüriaburrücü suiñemo? ");
INSERT INTO caxNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iñumutati Jesús: —Chümopü atusi aume arrüna sane. Arrti Tuparrü naqui uiche uraboiti auche. Itopiqui arrti ane nüriacarrti. ");
INSERT INTO caxNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero arrtü cuati Espíritu Santo au nabausasü, torrio aume abüriacabo, na amenotü apanitane nisüri, auna Jerusalén, auna cürrü Judea, au cürrü Samaria y au nanaiñantai icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Numo chauqui arrüna nurarrti ümoma, isucarüma nurria iquiamperotiyü, niyücürrti tato au napese. Auqui cuatü taman cüsaüborrü taburriuti uirri. Auqui champürrtü asaramatiqui tato. ");
INSERT INTO caxNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nauquiche amoncomainqui arrtayomatü isiuti Jesús niyücürrti tato au napese, auqui paecüburuma esama torrü mañoñünca, purusubi naibirrimia. ");
INSERT INTO caxNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Namatü ümoma: —Arraño auqui Galilea, ¿causane süsio año amarrtaiquiatü icu napese? Arrti Jesús süroti tato au napese amopünanaqui. Pero ta, cuati tato ñana tacana arrüna amarrtaiquiatü isiuti. ");
INSERT INTO caxNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Auqui süroma tato au Jerusalén onüqui manu yiriturrü nürirri Olivos. Tamantai kílometro nichequirri auqui manu. ");
INSERT INTO caxNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nauquiche tiñataimia tato taha, süroma ape au manu quiatarrü piso nesa manu porrü auna cauta nantarrü iyoberabaramacü. Arrüpecuma anancati Pedro, arrti Jacobo, arrti Juan, arrti Andrés, arrti Felipe, arrti Tomás, arrti Bartolomé, arrti Mateo, arrti Jacobo aütorrti Alfeo, arrti Simón naqui auqui manu partidorrü nürirri cananista, y arrti Judas yaruquitorrti Jacobo. ");
INSERT INTO caxNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Arrüma iyoberabaramacü nantarrü na eama. Amoncoma ito bama yaruquitorrti Jesús, nipiacütoti y arrüba piquiataa paüca. ");
INSERT INTO caxNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Au manio naneneca arrti Pedro atüraiti cümuinata manuma amoncoma acamanu, taqui ciento veinte nubiquirrimia, nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Masaruquitaiqui, chauqui tücocono arrümanu turapoiticaü Espíritu Santo turuquiti yüriaburrü David. Ta maconomonoti tücañe sane icu Nicororrü icütüpüti Judas, naqui cusürüboti tücañe aübu manuma uiche aiñenomati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Arrti Judas tücañe tacümanauncunuti ochepe, y tacane torrio ito ümoti arrüna trabacorrü usaca aübu. ");
INSERT INTO caxNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero arrti macomporarati cürrü ui manu monirri torrio ümoti itobo na churriampatai yachücoiti. Taha paquioti cusürübo nitanurrti acü. Poboti, cuantio tanene nanterererrti. ");
INSERT INTO caxNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Numo tütusio ümo bama auqui Jerusalén, iñatama üribo manu cürrü Acéldama. Nantü auqui nurarrümantoe: “Cürrü auna cauta arapara notorrü.” ");
INSERT INTO caxNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Itopiqui icu manu Nicororrü niyobesa Salmos nantü sane: Tari cücheca nicürrti y tapü anati naqui vivibo acamanu. Ane ito corobo sane: Tari ñatoconati quiatarrü aübu nesarrti cargorrü. ");
INSERT INTO caxNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aboma auna uyarrüpecu bama amoncomantai ochepe enterurrü manu tiemporrü nuñame ichepeti Señor Jesús, ");
INSERT INTO caxNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","auqui numo ürioti uiti Juan hasta numo camperoti au napese. Sane nauquiche urria arrtü tamanti uturuquimia iñanatiyü ochepe na uraboitito, que süboricoti tato Jesús, itopiqui asaratiti ta süboricoti. ");
INSERT INTO caxNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Auqui nombraboma bama torrü uimia: Arrti José Barsabás nürirrtito Justo, y arrti Matías. ");
INSERT INTO caxNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Meaboma sane: —Señor, arrücü asuputacai nausasü macrirrtianuca, aitusiancarrti suisucarü quiti naqui uturuqui bama torrü urria au naquionco, ");
INSERT INTO caxNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nauqui asuriuti nesarrti cargorrü Judas tücañe numo apostoltiqui. Pero churriampataito yachücoiti, sane nauquiche tanati taha auna cauta nipenequirrti. ");
INSERT INTO caxNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Auqui suerteaboma uimia. Tocabo ümoti Matías. Auqui manu nanenese iñanatiyü ichepe manuma once apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iñatai manu nanenese Pentecostés. Namanaiña bama icocoromati Jesús iyoberabaramacü taha au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Rrepenteatai rabotü süuru auqui napese tacanarrtü arrone maquiütüca fuerte, y cutañarrü au manu porrü auna cauta amoncoma. ");
INSERT INTO caxNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Auqui butusio onü nitanurrüma arrümanio sane tacana nonco pese mochiomancatai. ");
INSERT INTO caxNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Enterurrüma süroti Espíritu Santo au nausasürrüma. Manitanama caüma uiti piquiatacatai manitacaca. ");
INSERT INTO caxNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Au manio naneneca amoncoma au Jerusalén bama israelitarrü auqui nanaiñantai nacioneca, bama tarucu ñacoconauncurrüma ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oncoimia manu nisüurrü onü manu porrü. Ipiacünomacü asaborimia, cütüpürrüma macrirrtainuca. Cütomutañama ui na oncoimia ñanitaca bama ñanunecasarrti Jesús au na nurarrümantoe. ");
INSERT INTO caxNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Cütobüsoma, chümarrtacarrüpatai ümoma, namatü ümomantoe: —¿Canapaemo auqui Galilea enterurrüma bama manitana? ");
INSERT INTO caxNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Causane aipiama anitama nusura? ");
INSERT INTO caxNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Auna aboma bama auqui Partia, auqui Media, auqui Elam, auqui Mesopotamia, Judea, Capadocia, Ponto y auqui manu provinciarrü Asia, ");
INSERT INTO caxNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","auqui Frigia y Panfilia, auqui Egipto, y arrüba puebluca abe manrrü tahiqui pürücü Cirene. Aboma ito uyarrüpecu bama auqui Roma bama pohosoma auna. Eanama aboma bama propiorrü israelitarrü y arrübama yasutiumantai nesarrüma religión. ");
INSERT INTO caxNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aboma ito bama auqui Creta y Arabia. Enterurrü oñü oñoncoi nurarrüma auqui na numanitacatoe. Champü causane, iyebo nurria uimia. Urapoimia arrüba nomirria uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Enterurrü cütobüsoma, chümarrtacarrüpatai ñapensacarrüma. Ñanquitioma pünanaquimiantoe: —¿Isane naca arrüna sane? ");
INSERT INTO caxNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aboma ito bama iyapoimia, namatü sane: —¡Orisübaboma arrümanuma! ");
INSERT INTO caxNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Auqui atüraiti Pedro aübu manuma maquiataca once apostolerrü. Fuerte nurria nurarrti, nanti sane: —Arraño bama mañoñünca auqui Judea y arrübama auqui Jerusalén, amonsoi nurria arrüna sucanañü aume. ");
INSERT INTO caxNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Arrüsomü champürrtü soborisübaca, tacana arrüna napapensaca. ¿Causanempü soborisüba? aübapae ane ape surrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Más bien arrüna sane ta tone arrümanu turapoiticaü tücañe profetarrü Joel. Nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Sane nurarrti Tuparrü: Au nitacüru cuantio naneneca, iñemecata aruqui niyesa Espíritu onü macrirrtianuca. Arrübama aütorrüma y arrüba nitaquiumucuturrüma ipianacatema ñana arrüna nisura. Arrübama mayaüca ausüratai ñana arrtaimia auqui na quiatarrü narrtarrüma, y arrübama maporriquia iñunecacama auqui niposiquirrimia torrio ümoma sobi. ");
INSERT INTO caxNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Au manio naneneca iñemecata ito aruqui niyesa Espíritu onü bama baserebioma iñemo y arrüba paüca paserebio iñemo. Arrüma caüma ipianacatema nisura. ");
INSERT INTO caxNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Itusiancaquion ñana ausüratai señarrü icu napese y icu cürrü ito: Notorrü, pese y cüsaüboca tacana nausirri. ");
INSERT INTO caxNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Surrü ñana rruparrio. Pama isamunü cüturiqui tacana notorrü, arrtü tüsaimia manu nanenese champü tacanache, arrüna ensümunu uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Enterurrüma bama yabiromati Tuparrü nauqui aicocoromati, tonema bama taesüburu ñana uiti pünanaqui carrticurrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Amonsoi te bama mañoñünca auqui Israel arrüna sucanañü aume: Arraño apipiate nürirrti Jesús auqui Nazaret. Amasaquio ito arrüba milagrorrü y señarrü omirriante uiti. Ui arrüna sane tusio que arrti ane nüriacarrti uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero arraño nauquiche tütorrioti aume, apitorrimiacati ümo bama extranjerurrü nauqui aiñanamati apü curusürrü, itopiqui sane ñapensacarrti Tuparrü auquiapae. ");
INSERT INTO caxNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Arrti Tuparrü isümoniancanatiti tato, itaesümunucunutiti pünanaqui concorrü, itopiqui chüpuerurrüpü süsioti coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ta arrti yüriaburrü David tücañe manitanati icütüpüti Jesús sane: Arrti Tuparrü anati siemprerrü ichepeñü. Anati auna sane ümo nepanauncu niñe tapü ane ñünanache irru. ");
INSERT INTO caxNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Uirri ipucünunca au niyausasu. Sane nauquiche iñanauncati aübu nisura. Champü causane nirraquionco arrtü isonca. ");
INSERT INTO caxNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Itopoqui arrti Tuparrü chichetatipü asio niyausüpü esa bama macoiñoca. Chichetatipito apore nisütüpü, itopiqui yaserebiquia ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uiti isüboriquia tato ñana. Auqui caüma tarucu nipucünuncu arrtü yasacati. ");
INSERT INTO caxNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Arraño bama masaruquitaiqui, apapensasio nurria arrüna sane. Arrti David chapürrtü ümotiatoepü arrüna nurarrti, itopiqui arrti coiñoti. Süroti cütu y arrüna nicürrti aninqui auna uyarrüpecu. ");
INSERT INTO caxNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Arrti David ipianacatenti nurarrti Tuparrü tücañe, itopiqui profetarrti. Sane nauquiche arrti Tuparrü urapoiticaü isucarüti aübu juramentorrü que tamanti uturuqui bama nesarrti familiarrü tonenti Cristo. Tonenti naqui tümonsoti ñana au tronorrü na üriaburuti. ");
INSERT INTO caxNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sane nauquiche arrti David urapoiticaü tücañe, arrti Cristo tiene que asüboriti tato ñana, y arrüna nausüpurrti chüpuerurrüpü asio eana bama macoiñoca. Chüporeopito nicütüpürrti. ");
INSERT INTO caxNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Arrti Tuparrü isümoniancanatiti tato Jesús. Enterurrü somü terrticurrü somü ümo arrüna sane. Sumasacati süboricoti tato. ");
INSERT INTO caxNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iyebo uiti au nepanauncurrti Yaütoti. Arrti bacheboti üriacaboti na acüputi icu na cürrü ümoti Espíritu Santo. Tone caüma arrüna amarrtai y amoncoi one auna. ");
INSERT INTO caxNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Champürrtü arrti David naqui süroti tato au napese aübu cürrü nicütüpürrti. Pero arrti nanti sane: Arrti Tuparrü nanti sane ümoti iyesa Señor: “Atümo rrupetacuñü au nepanauncu niñe, na üriaburü saübuñü, ");
INSERT INTO caxNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","cheperrtü bachesoiyoma aesacü sobi aesa enemigorrü.” ");
INSERT INTO caxNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sane nauquiche tapü anati naqui chicocotapü au na cürrü Israel, que arrti Jesús, naqui süroti aboi apü curusürrü, tonenti Señor y Cristo uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nauquiche toncoimia arrüna sane, iñorronconomacü au nitusirrimia. Ñanquitioma pünanaquiti Pedro y pünanaqui bama maquiataca apostolerrü: —¿Causane caüma sobio? ");
INSERT INTO caxNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Arrti Pedro nanti sane ümoma: —Apiñorroncosaño. Tari abüriquia au nürirrti Jesucristo. Sane rrimiacana tato aume nomünantü aboi. Arrti Tuparrü caüma icüpurutiti Espíritu Santo au nabausasü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Aume te arrüna nurarrti Tuparrü sane y ümo bama abaübosi y ümo bama ito aboma iche, bama tasuruiqui uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ausüratai ñanunecacarrti Pedro ümoma. Ubuturuqui manio ñanunecacarrti, nanti sane ümoma: —Tapü abasiquiaiqui eana bama churriampatai nisüboriquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Arrübama yasutiuma ñacuansomococorrti, ürioma. Au manu nanenese iñanamacü arrüpecu bama icocoromati Jesús, taqui tres mil nubiquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Enterurrüma süroma isiu na ñanunecacarrüma bama apostolerrü. Macumanaunrrüma ümomantoe. Iyoberabaramacü nauqui chépe ahama y nauqui eama. ");
INSERT INTO caxNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tarucu nicütobü macrirrtianuca oboi ba milagrorrü y señarrü omirriante ui bama apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Enterurrü bama icocoromati Jesús chépe nacarrüma. Macumananama ümomantoe arrüna ane uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ipiaventecatama arrüna nenarrirrimia. Nicuarrü caüma rrepartibo uimia ümomantoe isiu naca na nirrantümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Naneneca oberabarama au niporrti Tuparrü. Au niporrümantoe caüma basoma juntorrü. Pucünuñamantai y tacane ichimiancanamacü au nausasürrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Iñanaunumati Tuparrü. Tarucu nicuarrüma ümo genterrü. Arrti Tuparrü naneneca bacheboti uüboma. ");
INSERT INTO caxNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Taman nanenese arrti Pedro ichepeti Juan süromatü au niporrti Tuparrü a las tres isiu nimümürrü, itopiqui arrümanu horarrü nantarrü meaboma macrirrtianuca acamanu. ");
INSERT INTO caxNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Naneneca anati acamanu taman ñoñünrrü naqui chüpuerurrüpü amenti auquiapae numo aübo anati icu cürrü. Iquianamati acamanu, iñanamati abeu manu tururrü nürirri “Coñorrtai”. Acamanu manquioti limosnarrü pünanaqui bama pasaoma, niyücürrümampo. ");
INSERT INTO caxNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nauquiche pasaoti Pedro ichepeti Juan niyücürrümampo, manquiotito limosnarrü pünanaquimia. ");
INSERT INTO caxNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tochencoma nauqui asaramatü ümoti, auqui arrti Pedro nanti ümoti: —Asasatü suiñemo. ");
INSERT INTO caxNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Arrti maniqui ñoñünrrü asaratitü nurria ümoma, ñaquioncorrti macumananama ñana ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Arrti Pedro nanti ümoti: —Champü monirri sobi ni oropü. Pero arrüna ane sobi puerurrü ichücü. Au nürirrti Jesucristo naqui auqui Nazaret sucanañü aemo: ¡Atüsai, ame! ");
INSERT INTO caxNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Auqui arrti Pedro iñatünaiñacanatiti auqui nepanauncu nipiarrti. Au manu rratorrü urrian tato nipoperrti. ");
INSERT INTO caxNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tobüsoti tape, amencoti bien urria. Abu arrti tücañe chüpuerurrüpü amenti. Sürotipo ichepema au niporrti Tuparrü. Tobüsotiatai tape, nipucünuncurrti. Iñanaunutiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Enterurrü genterrü asaramati, amencoti aübu ñanauncurrti ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tarucu nicütobürrüma ui arrüna arrtaimia sane. Tusio ümoma, ta tonenti maniqui nanenecatai anancati tümonsoti abeu nituru niporrti Tuparrü, arrümanu nürirri “Coñorrtai” nauqui acumanama ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Arrti maniqui ñoñünrrü urriancati tato nacarrtiatai tanu isiuti Pedro y arrti Juan. Amoncoma au manu nicorero niporrti Tuparrü nürirri Salomón. Tapü arrübama macrirrtianuca ipiacünomacü esama, nauqui asaborimia. Tarucu nicütobürrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ui arrüna sane nanti Pedro ümoma: —Arraño bama mañoñünca auqui Israel: ¿Causane tarucu naucütobü? Abasiquia amarrtaiquiatü suiñemo, tacanarrtü soboi urriancati tato naqui ñoñünrrü. Champürrtü urriancati tato soboi ni ui arrünampü tarucu supaquionco iyoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ta arrti Tuparrü naqui ümoche tarucu tücañe ñacoconauncurrti Abraham y arrti Isaac y arrti Jacob, bama upariente tücañe, tonenti naqui uiche aisamune arrüna sane, na atusi ümo macrirrtianuca arrüna tarucu nicuarrti Jesús ümoti. Arrti Jesús baserebioti ümoti Tuparrü, pero torrioti tücañe aboi ümo bama mayüriabuca na aconti. Arrti yüriaburrü Pilato rranrrtipü tücañe aiñemecanatiti, pero arraño chaurriancapü. ");
INSERT INTO caxNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Abu arrti champü isane nipünatenti, bien urria nisüboriquirrti. Pero arraño apanquitio nauqui ataesübuti maniqui quiatarrü ñoñünrrü yatabayorrü. ");
INSERT INTO caxNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sane apitabaiquiati naqui bachebo osüboriquibo. Pero arrti Tuparrü isümoniancanatiti tato. Arrüsomü sumarrtai nanaiña arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ui nicusüurrti maniqui Jesús urriancati tato naqui ñoñünrrü itopiqui sopicococati. Arraño apisuputacati nurria naqui ñoñünrrü urriancati tato. Torrio suiñemo uiti Tuparrü nauqui sopicocoroti Jesús; uirri te urriancati tato nurria naqui maunrrocono, tacana arrüna amarrtai. ");
INSERT INTO caxNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‛Bueno, bama masaruquitaiqui, tusio iñemo, arraño ichepe bama mayüriabuca apitabaiquiati Jesús, pero ta ui na champürrtü tusio aume arrtü tonenti Cristo. ");
INSERT INTO caxNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ta sane cocono uiti Tuparrü arrümanu nurarrti tücañe turuqui bama nesarrti profetarrü, que arrti Cristo taquisürüti ñana. ");
INSERT INTO caxNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sane nauquiche apiñorroncosaño. Auqui caüma morrimiacana tato nomünantü aboi. Bacüpurutito caüma omirriantai naneneca aume, nauqui urria nabaca y aupücünuncatai. ");
INSERT INTO caxNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Sane ito caüma icüpurutiti tato aume naqui Cristo auqui napese. ");
INSERT INTO caxNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tusio oemo que anati baeta au napese cheperrtü tanaiña coñocono uiti Tuparrü, tacana arrüna nantarrtai nurarrti tücañe turuqui bama profetarrü, bama baserebioma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sane ito nurarrti Moisés ümo bama upariente israelitarrü tücañe: —Arrti Tuparrü bacüpuruti ñana taman profetarrü abuturuqui, tacana arrüñü. Apacoconaun ümoti. Apicoco ito nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Namanaiña bama chümacoconaunpüma ümoti, tari penecoma eanaqui bama israelitarrü, chütonemainquipü nesarrti genterrü Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‛Auquiapae numo süboricotiqui profetarrü Samuel, enterurrüma bama maquiataca profetarrü urapoimia ito arrüna tiemporrü caüma (nitiemporrti Cristo). ");
INSERT INTO caxNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aume te arrüna nurarrti Tuparrü tücañe turuqui bama profetarrü. Autacu masamunuti Tuparrü tratorrü tücañe aübu bama upariente, nauquiche nanti ümoti Abraham: “Nanaiña genterrü icuqui na cürrü curusüu ñana auqui naca naesa familiarrü”. (Itopiqui arrti Jesús auqui nesarrti familiarrü Abraham.) ");
INSERT INTO caxNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Arrti Tuparrü isümoniancanatiti tato naqui Aütorrti. Icüpurutiti primero aume nauqui autaesübu eanaqui nomünantü, nauqui apicoñoco arrüna churriampatai nausüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Amoncomainqui manitanama arrti Pedro y arrti Juan, auqui iñataimia esama manuma sacerdoterrü, ichepeti maniqui yüriaburrü ümo niporrti Tuparrü y arrübama saduceorrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tüboricoma, itopiqui arrti Pedro y arrti Juan manunecanama ümo genterrü y urapoimia que arrti Jesús süboricoti tato eanaqui macoiñoca, na atusi que puerurrü asüborimia tato bama macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Auqui enoma uimia. Aüroma au preso hasta quiatarrü nanenese, itopiqui chauqui tütümümüca, champü tiemporrü nauqui acurrtama aübuma manu nimümürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sürümanama bama amoncoma onsapecoma nurarrti Pedro, icocotama. Sane nauquiche manrrü nubiqui bama icocoromati Jesús. Taboma cinco mil mañoñünca (abe ito paüca y masiomanca). ");
INSERT INTO caxNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Au manu quiatarrü nanenese tansürü oberabarama au Jerusalén bama üriatu bama israelitarrü ichepe bama mamayoreca y arrübama manunecana nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anancati Anás, naqui yarusürürrü sacerdoterrü, ichepeti Caifás, arrti Juan, arrti Alejandro y namanaiña bama maquiataca auqui nesarrüma familiarrü bama üriatü sacerdoterrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bacüpuruma nauqui ayeti Pedro ichepeti Juan acamanu esama. Auqui iñataimia acamanu. Süroma cümuinta uimia. Ñanquitioma pünanaquimia: —Uiche ane arrüna nabüriaca, quiti naqui yacüpucuche aume nauqui apacura ümoti maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Auqui manitanati Pedro ui nicusüurrti Espíritu Santo, nanti ümoma: —Bueno, arraño bama üriatu pueblurrü y arrübama mamayoreca au Israel, ");
INSERT INTO caxNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","arraño apanquitio somopünanaqui arrüna sopisamute urria ümoti naqui maunrrocono. Apanquitito uiche urriancati tato. ");
INSERT INTO caxNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Suburaboira ausucarü, nauqui atusi ümo na genterrü auqui Israel. Arrti naqui ñoñünrrü amasacati auna, urriancati tato au nürirrti Jesucristo naqui auqui Nazaret, naqui süro apü curusürrü aboi. Pero ta uiti Bae Tuparrü süboricoti tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Arrti Jesús tonenti tacana canrrü arrüna botabo ui bama masamunu porrü, pero uiti Tuparrü arrti tacana arrone canrrü manrrü urriampae ümo porrü. Tone manrrü yaserebiquirri. Arraño te tacana bama masamunu porrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Champüti quiatarrü naqui uiche puerurrü utaesübu eanaqui nomünantü, uitiatai Jesús. Itopiqui champüti quiatarrü torrio oemo uiti Tuparrü icu na cürrü naqui uiche puerurrü utaesübu eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Arrümanuma mayüriabuca tütusio ümoma que arrti Pedro y arrti Juan champü nirrucurrüma. Tusiataito ümoma que champürrtü ipiacamampae nicororrü. Auquito caüma tusio ümoma, tonema bama amencoma tücañe ichepeti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tacane arrti maniqui ñoñünrrü urriancati tato anati acamanu ichepema. Asi que champü isane urapoboiboma. ");
INSERT INTO caxNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Auqui bacüpuruma ümoma ariorrüma baeta türüpo auqui manu, nauqui aparimia. ");
INSERT INTO caxNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Namatü: —¿Causane caüma osoi ümo bama mañoñünca? Enterurrümantai bama auqui Jerusalén tusio ümoma arrüna milagorrü urriante uimia. Sane nauquiche chüpuerurrüpü uiñaneca. ");
INSERT INTO caxNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero tapü asio genterrü icuata nüri arrüna sane, mejor bachera mapirrumucurrü ümoma nauqui tapü asioma uraboimia nürirrti maniqui Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Auqui tasuruma tatito uimia. Urapoimia isucarüma tapü asioma anitanema nürirrti Jesús y ñanunecacarrti. ");
INSERT INTO caxNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero arrti Pedro ichepeti Juan iñumutama nurarrüma, namatü ümoma: —Apapensasio arraño: ¿Taqui urria ümoti Tuparrü arrtü supacoconaunca aume, tapü ümoti champü? ");
INSERT INTO caxNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Causanempü sopiñaneca arrüna sumarrtai ui suisütoatoe y arrüna somoncoi. ");
INSERT INTO caxNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Auqui rranrrüpüma achema manrrü mapirrumucurrü ümoma, pero au nitacürurrü emecanama uimia. Chütabücopü uimia causane nauqui carrticaboma uimia, itopiqui enterurrü genterrü iñanaunumati Tuparrü ui arrüna urriante uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Arrti maniqui ñoñünrrü urriancati tato, ta tütabe cuarenta añorrü ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Arrti Pedro ichepeti Juan numo tütaesüburuma uimia, süroma tato esa bama icumpañeruturrüma nauqui uraboimia isucarüma arrüna nura bama üriatu sacerdoterrü y bama mamayoreca. ");
INSERT INTO caxNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nauquiche toncoimia nurarrüma, chépema meaboma. Namatü sane: —Señor, obi aisamune napese, cürrü, turrü y nanaiñantai. ");
INSERT INTO caxNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Arrücü ito ucanü tücañe turuquiti David naqui amoso, numo maconomonoti uiti Espíritu Santo sane: ¿Causane pahiyaca nacioneca y arrübama macrirrtianuca ñapensaracama ñome arrüba champüatai iyebo auqui ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Arrübama mayüriabuca icuqui na cürrü, tüboricoma y arrübama üriatu puebluca iyoberabaramacü, itopiqui tüboricoma ümoti Tuparrü y ümoti Cristo, naqui tacümanauncunu uiti. Sane ñaconomosorrti David. ");
INSERT INTO caxNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","‛Ñemanauntu arrti Herodes y arrti Poncio Pilato juntaboma auna pueblurrü ichepe bama extranjerurrü y arrübama israelitarrü, enterurrüma tüboricoma ümoti Jesús naqui Cristo. Tonenti naqui anaunu obi. ");
INSERT INTO caxNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sane urriante uimia nanaiña arrüna tanancatai au napensaca arrüna pasabobo. ");
INSERT INTO caxNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sane nauquiche Señor, tusio nurria aemo nurarrüma suiñemo. Ayura suiñemo tapü sopirruca ñünana nurarrüma suiñemo, nauqui suburaboi nura aübu tarucu narucurrü suiñemo. ");
INSERT INTO caxNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ache suiñemo nauqui puerurrü urrianama tato soboi bama maunrrocono, y nauqui puerurrü sopisamune milagrorrü au nürirrti Jesús naqui Ahü, naqui anaunu obi. ");
INSERT INTO caxNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nauquiche tacürusu neancarrüma, paichoconono manu cauta amoncoma oberabarama. Enterurrüma süroti Espíritu Santo auma. Champü nirrucurrüma uraboimia nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Enterurrüma manuma icocoromati Jesús chépatai naca ñapensacarrüma y arrüna nirrantümoma au nitusirrimia. Champüti naqui nanti nesarrtiatai arrüna nenarrirrti, ta nesa namanaiñantai arrüna nenarrirrimia. ");
INSERT INTO caxNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Arrübama apostolerrü aübu nanaiña nüriacarrüma urapoimia arrüna süboricoti tato Señor Jesús. Arrti Tuparrü tarucu ñacunusüancacarrti ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Champüti eanama naqui taquisürü, itopiqui arrübama abe niyorrüma y arrübama abe niporrüma, mupaventeo uimia. Auqui caüma ane nimonirrimia. ");
INSERT INTO caxNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Torrio uimia caüma ümo bama apostolerrü. Uimia caüma torrio ümo cadati taman isiu naca na nirrantümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sane uiti maniqui José nürirrtito ui bama apostolerrü Bernabé, nürirrti auqui besüro “ñoñünrrü naqui ipiaca apucüruti”. Arrti eanaqui nesarrti familiarrü Leví, pero sunaunti au cürrü Chipre. ");
INSERT INTO caxNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Arrti naqui ñoñünrrü ipiaventecatati niyorrti. Auqui itorrimiatati nicuarrü ümo bama apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anatito quiatarrü ñoñünrrü nürirrti Ananías y nicüpostoti nürirri Safira. Paventeo uiti taman niyorrti. ");
INSERT INTO caxNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Cümuinta nicua manu ñanaunrrü ahüburu uiti ümoti. Quiatarrü nicümuintarrü itorrimiatati ümo bama apostolerrü. Tusio ümo nicüpostoti arrüna sane, urria ümo. ");
INSERT INTO caxNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Auqui nanti Pedro ümoti Ananías: —¿Causane aüroti choborese a nausasü? Arrücü apanca ümoti Espíritu Santo. Aitorrimiata cümuintatai nicua manu naho, pero arrücü ucanü que tone nanaiña nicuarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Naesa te manu ñanaunrrü, puerurrü aisamune isiu narrianca aübu. Numo tüpaventeo obi, naesa te manu monirri, puerurrü ito aisamune isiu narrianca. Pero arrüna napanca champürrtü ümo mañoñüncatai, ta ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Numo oncoiti Ananías arrüna sane nurarrti Pedro, taübücoti acü y coiñoti. Enterurrüma bama ipiatema, birrubuma ui arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Cuamatü manuma mayaüca aicümurriancanamati, canati uimia nauqui aiñanamati cütu. ");
INSERT INTO caxNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iyau ba trerrü horarrü, iñatai manu nicüpostoti Ananías. Champü tusiobo ümo. ");
INSERT INTO caxNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ñanquitioti Pedro pünanaqui: —Urasoi isucarüñü, ¿taqui enterurrü nicua manu ñanaunrrü pabenteo aboi arrüna sane? —Unca enterurrü, nantü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aiñumuti tatito Pedro, nanti: —¿Causane apiña napapantu ümoti Espíritu Santo, abu chisiupü naucusüu? Ichepatai na napapantu. Caüma cuama tato manuma mayaüca uiche aüroti cütu aiquianü. Arrücü ito caüma aconca. Uimia ito caüma aeca cütu. ");
INSERT INTO caxNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Au manu rratorrü taübüco ito esati Pedro, coiño ito. Arrümanuma mayaüca iñataimia tato acamanu, besüro narrtarrüma ümo, coiño. Iquiatama ito, aiñama cütu ipetacuti iquiana. ");
INSERT INTO caxNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Enterurrüma manuma icocoromati Jesús y nanaiña arrübama ipiatema arrümanu sane, tarucu nirrucurrüma uirri. ");
INSERT INTO caxNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sürümanatai milagrorrü omirriante ui bama apostolerrü isucarü macrirrtianuca. Arrübama icocoromati Jesús iyoberabaramacü nantarrü au manu nicorero niporrti Tuparrü nürirri Salomón. ");
INSERT INTO caxNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Arrümanuma maquiataca birrubumantai aiñanamacü ichepema. Pero arrübama icocoromati Jesús tarucu nicuarrüma ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Naneneca aboma bama icocoromati Señor, sürümanama mañoñünca y paüca. ");
INSERT INTO caxNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Arrübama macrirrtianuca iquianama bama maunrrocono isiu cayarrü aübu nanaiña nicürurrüma, ümo arrtü pasaoti Pedro esaquimia, nauqui apasa ito nausüpüturrti onüquimia, nauqui urrianama tato. ");
INSERT INTO caxNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Cütüpürrü macrirrtianuca iñataimia acamanu esa bama apostolerrü auqui manio piquiataca puebluca saimia ümo Jerusalén. Cuamatü uimia bama maunrrocono y arrübama taquisürüma itopiqui aboma machoboreca auma. Enterurrüma urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Arrti maniqui yarusürürrü sacerdoterrü ichepe bama icumpañeruturrti, arrübama auqui manu partidorrü nesa bama saduceorrü arrübama amoncoma ichepeti, ünantü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Enoma bama apostolerrü uimia, süroma au preso. ");
INSERT INTO caxNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero au tobirri cuati taman ángel iyaüburutiño turuca, carübuma auqui preso uiti. Nanti ümoma: ");
INSERT INTO caxNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Amecosi au niporrti Tuparrü apanitase arrüna manitacarrü isucarü genterrü, uiche coñocono tato nausüboriqui. ");
INSERT INTO caxNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Numo tütaneneca tato süromatü au niporrti Tuparrü. Acamanu manunecanama. Na arrti maniqui yarusürürrü sacerdoterrü ichepe bama icumpañeruturrti oberabarama uimia enterurrüma bama mayüriabuca y bama mamayoreca auqui Israel. Bacüpuruma iyo bama apostolerrü na ayematü esama auqui preso. ");
INSERT INTO caxNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Süromatü bama policiarrü iyoma, pero numo tiñataimia taha champürrtü abomainqui. Auqui süroma tato, uraboimia. ");
INSERT INTO caxNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Namatü: —Champüma. Causanempü, tai ananca bien mamana arrümanu cauta amoncoma y arrübama masortaboca amoncoma bacuirarama yutacu turuca. Pero nauquiche sopiyaübuta, champüti naqui anancapo. ");
INSERT INTO caxNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nauquiche tütusio ümoti maniqui üriatu bama bacuirara itacu niporrti Tuparrü y ümo bama üriatu sacerdoterrü, chümarrtacarrüpatai ümoma. Chütusiopü ümoma causane arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Auqui iñataiti taman ñoñünrrü acamanu, uraboiti isucarüma arrüna sane: —Arrümanuma mañoñünca amoncoma au preso aboi, aboma au niporrti Tuparrü manunecanama ümo genterrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Auqui arrti maniqui üriatu bama bacuirara itacu niporrti Tuparrü aübu bama policiarrü yebomatü iyoma. Iñataimia esama. Masamuña niyücürrüma esama ui nirrucurrüma ñünana genterrü tapü yaruruma oboi canca, arrtü ane causane uimia ümo bama apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Süromatü uimia esa manuma mayüriabuca, bama ane nüriacarrüma, nauqui acurrtama. Iñataimia esama. Arrti maniqui yarusürürrü sacerdoterrü nanti sane ümoma: ");
INSERT INTO caxNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Chauqui tüsuburapoi ausucarü, tapü abasiquiaiqui apanuneca arrümanu sane au nürirrti maniqui Jesús. Pero ta tütusio nürirrti aboi au nanaiñantai Jerusalén. Aurrianca nauqui ane sopipünate itopiqui niconcorrti naqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Auqui arrti Pedro y arrübama maquiataca apostolerrü iñumutama sane: —Arrüsomü supacoconaunca ümoti Tuparrü. Champürrtü ümo mañoñüncatai. Churriampü te ümoti, arrtü supacoconaunca aumeantai. ");
INSERT INTO caxNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Arrti Tuparrü iñanaunumati bama uyaütaiqui tücañe. Arrti te isümoniancanatiti Jesús, naqui coiño aboi apü curusürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Arrtito Tuparrü aübu nanaiña nicusüurrti isamunutiti Jesús yüriaburrü naqui uiche ataesübu genterrü eanaqui nomünantü, nauqui puerurrüma arrübama auqui Israel aiñorronconomacü, nauqui amorrimiaca nanaiña nomünantü uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Arrüsomü sumarrtai y suburapoi arrüna sane, y arrtito Espíritu Santo sane urapoiti ausucarü arrüba omirria. Ta torrioti uiti Tuparrü ümo bama macoconaunrrüma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Numo toncoimia arrüna sane, arrone nurria nitüborirrimia, rranrrümampü aitabairoma. ");
INSERT INTO caxNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero eana manuma mayüriabuca anancati maniqui taman fariseorrü nürirrti Gamaliel, naqui manunecana nüriacarrü. Tarucu ñacoconaucurrüma macrirrtianuca ümoti. Atüraiti, bacüpuruti acaübuma baeta türüpo bama apostolerrü. Süromatü türüpo. ");
INSERT INTO caxNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Auqui nanti Gamaliel ümo bama mayüriabuca: —Arraño bama auqui Israel: Amasasai nurria tapü ane causane aboi ümo bama mañoñünca. ");
INSERT INTO caxNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Apaquionsaño bama isumpañero auqui Israel, chücoboipapae anati maniqui nürirrti Teudas naqui rranrrtipü champüti manrrü pürücüti, taqui cuatrocientos nubiqui bama süroma isiuti. Pero numo taborioti pünanaquimia, iñarriomantai iyauti. ");
INSERT INTO caxNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Auqui caüma au manio naneneca nesa mapacümuncucurrü ümo genterrü, anati maniqui Judas auqui Galilea. Bahiyoti aübu bama rromanorrü. Aboma bama süromatü isiuti. Pero taboriotito ui bama mayüriabuca, y namanaiña bama aboma ichepeti iñarriomantai. ");
INSERT INTO caxNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Sane nauquiche sucanañü, tapü abasiquia icuata bama mañoñünca, tapü ane causane aboi ümoma, itopiqui arrtü uimiantai nanaiña arrüna sane, contoatai mameso. ");
INSERT INTO caxNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero arrtü uiti Tuparrü, chüpuerurrüpü año apiñamesoco. Amasasai nurria. Tapü apahiacaño aübuti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Auqui namanaiña urria ümoma nurarrti. Bacüpuruma tatito iyo bama apostolerrü. Champürrtü coiñoma uimia, pero cüborioma uimia. Bacüpucurrü ito uimia ümoma tapü asioma uraboimia nürirrti Jesús. Auqui emecanama uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Auqui arrübama apostolerrü süromatü auqui manu esaqui manuma mayüriabuca. Bien pucünuñama, itopiqui urria ümoti Tuparrü arrüna taquisürüma auqui nacarrti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Champürrtü iñocotama ñanunecacarrüma au nürirrti Jesucristo. Naneneca manunecanama au niporrti Tuparrü y tacane ito au poca. ");
INSERT INTO caxNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Au manio naneneca tücañe manrrü nubiquirrimia bama icocoromati Jesús. Arrübama manitana griegorrü tüboricoma ümo bama manitana hebreorrü nura bama israelitarrü, itopiqui arrüba biuraca panitana griegorrü chimiantai torrio ñome umutuburibo naneneca. ");
INSERT INTO caxNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Auqui bama doce apostolerrü oberabarama uimia bama icocoromati Jesús. Namatü ümoma: —Champürrtü urria arrtü uiñocota numanunecaca nurarrti Tuparrü nauqui basapa ümo bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sane nauquiche bama masaruquitaiqui, apapache sietema mañoñünca abuturuqui arrübama puerrurrü amoncatü ümoma, bama ipiaca aserebimia y anatito Espíritu Santo auma. Tari tonema yasuriurama arrüna trabacorrü, nauqui aserebimia. ");
INSERT INTO caxNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tapü arrüsomü chüsopiñocotapü sopeanca ümoti Tuparrü y supanunecaca nurarrti. ");
INSERT INTO caxNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Namanaiña urria ümoma arrüna sane. Auqui itacümanauncunumati Esteban, naqui bien urria ñacoconauncurrti ümoti Jesús, tusio ito nicusüurrti Espíritu Santo auti. Itacümanauncunumatito Felipe, arrti Prócoro, arrti Nicanor, arrti Timón, arrti Parmenas, arrti Nicolás auqui Antioquia, naqui yasutiuti manu religión nesa bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Arrübama siete caüma süromatü esa bama apostolerrü atüraimia esama. Arrüma caüma manquioma pünanaquiti Tuparrü itacuma, iñatama neherrüma itama, nauqui acurusüma. ");
INSERT INTO caxNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Arrüna nurarrti Tuparrü caüma tütusio tanu. Manrrü nubiquirrimia bama icocotama au Jerusalén. Aboma ito sürümanama bama sacerdoterrü yasutiuma. ");
INSERT INTO caxNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Arrti Esteban bien tusio nicusüurrti Espíritu Santo auti, y arrti Tuparrü yarusürürrü ñacunusüancacarrti ümoti. Masamunuti milagrorrü eana macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Auqui aboma bama auqui manu porrü sinagoga nürirri uimia “bama taesüburu”. Aboma ito ichepema bama auqui manio provinciarrü Cilicia y Asia. Süromatü esati Esteban, na uratoquimia ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero chümacanamapüma ümoti ui nurarrüma, itopiqui tarucu ñapanauncurrti y anati Espíritu Santo auti. ");
INSERT INTO caxNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Auqui caüma bapacarama ümo maquiataca mañoñünca, nauqui uraboimia arrüna sane, namatü: —Somoncoi que arrti Esteban manitanati churriampü ümoti Moisés y ümotito Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ui arrüna sane tüboricoma macrirrtianuca. Aboma ito mamayoreca y bama manunecana nüriacarrü. Iñenomati Esteban. Sürotitü uimia ümo bacurrtacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Acamanu bapacheroma ümo bama terrticurrü mañapanca. Arrüma namatü sane: —Arrti naqui ñoñünrrü champürrtü oncono uiti arrüna nurarrti churriampü ümo na niporrti Tuparrü y ümo arrüna nüriacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Somoncoi arrüna nurarrti sane: Arrti maniqui Jesús auqui Nazaret tiene que añarri uiti arrüna niporrti Tuparrü, y uitito uiñocota arrüba noesa costumbre, arrüba botorrio oemo uiti Moisés. ");
INSERT INTO caxNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Arrümanuma mayüriabuca amoncoma acamanu tümonsoma ichepe namanaiña manuma maquiataca. Asaramatü ümoti Esteban. Arrüna nisurrti caüma tacanapae nisurrti ángel. ");
INSERT INTO caxNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Auqui arrti maniqui üriatü bama sacerdoterrü ñanquitioti pünanaquiti Esteban: —¿Ñemanauncurratoe arrüna nurarrüma aemo? ");
INSERT INTO caxNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Auqui iñumutati Esteban: —Masaruquitaiqui y bama uyaütaiqui, amonsoi arrüna nisura: Arrti Tuparrü tarucu nüriacarrti. Itusiancanatiyü tücañe isucarüti uyaü Abraham nauquiche anancati au manu cürrü nürirri Mesopotamia, numo chüsürotitüquipü aviviti au Harán. ");
INSERT INTO caxNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nanti Tuparrü ümoti: “Aiñoco arrüna nacü, y namanaiña bama apariente. Acosi au manu cürrü arrümanu tiene que itorrimia aemo”. ");
INSERT INTO caxNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Auqui sürotitü Abraham auqui manu cürrü nürirri Caldea, aürotitü aviviti au manu cürrü nürirri Harán. Nauquiche tücoiñoti yaütoti, cuatitü uiti Tuparrü au na cürrü cauta caüma baviviquia. ");
INSERT INTO caxNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero champürrtü torrio ümoti manu cürrü, ni peasorrtaipü. Pero ta urapoiti isucarüti sane: “Itorrimiata ñana na cürrü ümo bama aübositaiqui. Au manu tiemporrü tücañe champüti aübosirrti”. ");
INSERT INTO caxNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Arrti Bae Tuparrü nanti: “Arrübama eanaqui nesarrti familiarrü Abraham süromatü avivimia tacana extranjerurrü au manu quiatarrü cürrü. Pero mosorrüma caüma ümo bama pohoso acamanu. Taquisürüma uimia ñome cuatrocientos añoca. ");
INSERT INTO caxNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Arrti Tuparrü nantito: “Yeca tanuiq i yacurrta aübu bama pohoso, arrübama uiche taquisürüma bama aütorrti Abraham. Y auqui caüma iquiaüburumacü auquimanu, nauqui ayematü aserebimia iñemo auna cürrü Canaán”. ");
INSERT INTO caxNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Arrti Bae Tuparrü masamunuti tratorrü aübuti Abraham. Manunecanati ümoti nauqui circuncidaboma uiti bama aütorrti, tacana señarrü ümo manu tratorrü. Sane nauquiche anati icu cürrü maniqui aütorrti Abraham, nürirrti Isaac. Circuncidaboti uiti Abraham numo tabe ocho naneneca nacarrti icu cürrü. Sane ito uiti Isaac ümoti aütorrti, nürirrti Jacob. Y arrti Jacob sane ito uiti ümo bama doce aütorrti. Ui bama doce ane caüma noesa nación, nürirri Israel. ");
INSERT INTO caxNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‛Eanaqui manuma doce anati taman nürirrti José. Arrübama yaruquitorrti José tüboricomantai ümoti. Ipiabentecanamati. Sane iñataiti au manu cürrü Egipto. Pero arrti Tuparrü bayurarati ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Taquisürüti José acamanu, pero arrti Tuparrü itaesümunutiti pünanaqui nanaiña nitaquisürücürrti. Bacheboti ñapanauncubuti. Sane nauquiche arrti yüriaburrü au Egipto, yasuriurutiti José. Arrti maniqui yüriaburrü nürirrti Faraón. Itorrimiatati üriacaboti José ümo nanaiña cürrü Egipto. Üriabucatito caüma José au niporrti Faraón. ");
INSERT INTO caxNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‛Auqui ane carerrtiya y taquisürücürrü au manu cürrü Egipto y au cürrü Canaán. Y arrübama uyaütaiqui champü isane utuburiboma. ");
INSERT INTO caxNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero nauquiche tütusio ümoti Jacob, ane tubarrirri trigo au Egipto, bacüpuruti ümo bama aütorrti. Süromatü acomporama. Tone arrümanu primer namenrrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Au manu quiatarrü namenrrüma caüma isuputaramati José, ta tonenti yaruquitorrüma. Auqui caüma arrti Faraón isuputarati bama yaruquitorrti José. ");
INSERT INTO caxNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Auqui arrti José bacüpuruti iyoti yaütoti, y iyo ito namanaiña bama nesarrti familiarrü, setenta y cinco nubiquirrima. ");
INSERT INTO caxNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sane nauquiche sürotitü Jacob aviviti au manu quiatarrü cürrü Egipto. Acamanu coiñoti, y namanaiña nesarrti familiarrü coiñoma ito acamanu. ");
INSERT INTO caxNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iquiatama tato nicunturrti Jacob ichepe nicuntu bama aütorrti au Siquem auna cürrü, nauqui aiñanama cütu au manu lote comprabo uiti Abraham tücañe pünanaquiti aütorrti Hamor. ");
INSERT INTO caxNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‛Tüsaimia caüma manu tiemporrü auche cocono arrümanu nurarrti Tuparrü, nauquiche itusiancatati curusürrü isucarüti Abraham, na atorri manu cürrü Canaán ümoma. Arrüna genterrü Israel au Egipto chauqui tüsürümanama. ");
INSERT INTO caxNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Auqui anati quiatarrü yüriaburrü au Egipto. Champürrtü aquionotiyü iyoti José. ");
INSERT INTO caxNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Arrti maniqui yüriaburrü encañaoti ümo noesa genterrü, y taquisürüma uiti. Bacüpuruti nauqui oncoma uimia bma aütorrüma aübo aboma icu cürrü, nauqui acoma. ");
INSERT INTO caxNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Au manio naneneca tücañe anati icu cürrü Moisés, coñorrtiatai manqui ñaüma. Arrti yaütoti y nipiacütoti isunauncunumati trerrü panca au niporrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nauquiche tiñoconomati, tabücoti ui manu nitaquiumucuturrti yüriaburrü au Egipto. Iquianati nauqui aisunauncunuti tacana aübosirri. ");
INSERT INTO caxNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sane nauquiche ununecanati ümo nanaiña arrüna ipiacama, yacheatarrüma bama egipciorrü. Tusio nüriacarrti ui na ñanitacarrti y ui na nisamutenti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‛Nauquiche tütabe cuarenta añorrü ümoti Moisés, sürotitü apaseati esa bama israelitarrü, bama ipiarientetorrti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Acamanu asaratitü ümoti taman egipciorrü bacübayoti ümoti taman israelitarrü. Auqui aürotitü Moisés ocümati itacuti. Coiñoti maniqui egipciorrü uiti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Arrti Moisés ñaquioncorrti tusio ümo bama ipiarientetorrti, que uiti caüma tiene que ataesübuma auqui Egipto, tone caüma yayuracarrti Tuparrü ümoma. Pero arrübama israelitarrü champürrtü tusio ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Au quiatarrü nanenese asaratitü Moisés ümo torrüma israelitarrü bahiyoma aübumantoe. Arrti Moisés rranrrti nauqui tapü asioma ahimiainqui, nanti ümoma: “¿Causane abasiquia apahi aumeampatoe? Arraño ta aubaruquiapatoe”. ");
INSERT INTO caxNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Auqui arrti maniqui iñapachenuche ünantü ümoti arrüna nanti Moisés. Nanti ümoti: “¡Ñacutipü naqui uiche aicüpurü, nauquipü yüriaburrücü suiñemo! ");
INSERT INTO caxNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Taqui arrianca ito aitabairoñü, tacanati maniqui egipciorrü aitabaiquiati tümüca?” ");
INSERT INTO caxNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nauquiche oncoiti Moisés arrüna sane, besüburuti. Sürotitü au manu cürrü nürirri Madián. Acamanu bavivicoti tacana extranjerurrti. Acamanu ito posoti y aboma torrüma aütorrti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‛Tübupasao cuarenta añoca, nacarrti Moisés au manu cürrü. Taman nanenese anati au manu rroense pururrü cüosorrü y canca saimia manu yiriturrü nürirri Sinaí. Acamanu itusiancanatiyü taman ángel isucarüti eana nonco pese apü taman suema. ");
INSERT INTO caxNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Arrti Moisés cütobüsoti ui arrümanu sane. Auqui sürotitü saimia ümo, nauqui asarati nurria. Acamanu oncoiti ñanitacarrti Señor, nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Arrüñü Tuparrüñü ümo bama aubaütaiqui tücañe, ümoti Abraham, ümoti Isaac, ümoti Jacob”. Auqui arrti Moisés paichocononoti ui nirrucurrti, anati mataconoconoti, ni asaratitüpü pario. ");
INSERT INTO caxNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Auqui nanti Señor ümoti: “Aiquiaübusio nasapatu apopequicü, itopiqui arrüna cürrü auna cauta aicümote samamecana iñemoantoe. ");
INSERT INTO caxNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Arrüñü yarrtai nitaquisürücü niyesa genterrü au Egipto y ñoncoi ito nareorrüma. Isecatü auqui napese nauqui itaesümununuma. Sane nauquiche caüma icüpucü au Egipto”. ");
INSERT INTO caxNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‛Arrüma tücañe chücuasürütipü Moisés ümoma y namatü: “¡Ñacutipü naqui uiche aicüpurü nauqui yüriaburrücü suiñemo!” Pero caüma uiti Tuparrü icüpurutiti aübu nüriacarrti, nauqui ataesübuma uiti. Manitanati Tuparrü ümoti turuquiti ángel, naqui itusiancanatiyü eana nonco pese apü suema. ");
INSERT INTO caxNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Y arrti Moisés masamunuti milagrorrü au manu cürrü. Uiti tücañe taesüburuma bama israelitarrü auqui Egipto (aübu yayuracarrti Tuparrü). Masamunutito milagorrü abeu manu narubaitu turrü nürirri “Cüturiqui” y eana rroense ñome cuarenta añoca. ");
INSERT INTO caxNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Urapoiti nurria isucarü bama israelitarrü arrüna sane: “Arrti Tuparrü tiene que acüputi tamanti profetarrü aume, naqui tacümanauncunu ameanaqui tacana arrüna icüpurutiñü. Apacoconaun nurria ümoti, arrtü cuatati”. ");
INSERT INTO caxNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Arrtito Moisés anacati ichepe macrirrtianuca eana rroense, tacane ichepeti ángel naqui manitanati ümoti esa manu yiriturrü Sinaí. Torrio ümoti uiti Tuparrü ñanitacaboti, nauqui uraboiti isucarü genterrü, y usucarü ito, nauqui atorri oemo osüboriquibo. ");
INSERT INTO caxNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‛Pero arrüma tücañe champürrtü macoconaunrrüma ümoti Mosés, chücuasürütipü ümoma. Rranrrümapü asücübüma tato au Egipto. ");
INSERT INTO caxNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Auqui namatü bama israelitarrü ümoti Aarón: “Suirranca nauqui asamu suiñemo matupaca, nauqui acusürüma subaübu. Itopiqui chütusiopü isane pasabo ümoti maniqui Moisés, naqui uiche aiquiaüburuti somü auqui Egipto”. (Namatü sane, itopiqui abaiturrü nacarrti Moisés onü manu yiriturrü, ñanitacarrti aübuti Tuparrü.) ");
INSERT INTO caxNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Auqui masamunuma taman tororrü oro itupaboma. Batabayoma numuquianca nauqui acumanama ümo. Pucünuñama ui arrüna urriante uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Auqui arrti Bae Tuparrü sürotitü pünanaquimia. Chebatai uiti anauma ñome nostoñeca, surrü y panrrü arrüba abe icu napese. Sane ane corobo icu manu librurrü corobo uiti maniqui pofetarrü Amós: Arraño bama genterrü auqui Israel, ¿acasopü iñemo apacumanaca numuquianca ubau manio cuarenta añoca nabaca eana rroense? ");
INSERT INTO caxNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","No, champürrtü iñemo. Ta apiquiata nesarrti imágen maniqui tuparrü nürirrti Moloc, y apanaunca ümo manu nostoñese nürirri Refán. Apasamuca autupabo, nauqui apanaun ümo. Sane nauquiche caüma icüpucaño auqui manu naucü cürrü, nauqui amenotü manrrü taha pürücü Babilonia. Sane nurarrti Amós tücañe. ");
INSERT INTO caxNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‛Arrübama uyaütaiqui amoncoma eana manu rroense. Acamanu ane uimia tücañe manu porrü nürirri santuario, auna cauta anati Tuparrü. Auqui na porrü manitanati Tuparrü ümoti Moisés. Tari isamunenati isiu nurria tacana arrümanu itusiancatati Tuparrü isucarüti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Arrübama uyaütaiqui tücañe yasutiuma manu niporrti Tuparrü. Auqui caüma yüriaburrti Josué. Uiti caüma cuamatü auna cürrü. Macananama ümo cütüpürrü genterrü tücañe auna. Iquiatama ito arrümanu porrü santuario. Süromatü aübu au na cürrü torrio ümoma uiti Tuparrü. Sane ananca auna numo yüriaburrti David. ");
INSERT INTO caxNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Arrti urria nisüboriquirrti au narrtarrti Tuparrü. Rranrrti atünaiñacati porrü auna cauta aviviti Tuparrü, naqui ümoche manaunuti tücañe Jacob, pero chüpuerurrütipü. ");
INSERT INTO caxNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aüboqui uiti Salomón, naqui aütorrti David urriane manu niporrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero arrti yarusürürrü Tuparrü champürrtü bavivicoti au manio poca omirriante ui bama mañoñüncatai. Nanti Señor tücañe turuquiti taman profetarrü: ");
INSERT INTO caxNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Enterurrü napese tacana niyesa tronorrü, y arrüna cürrü tacana cauta apacansa nipope. ¿Isanempü naca na porrü arrüna urriante aboi iñemo nauqui ñacansa iquiana. ");
INSERT INTO caxNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Isamute nanaiña arrüba abe. Sane nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","—Pero arraño —nanti Esteban—, siemprerrü chaurriancapü apasuriuruti Tuparrü au nabausasü, ni amoncoipü nurarrti. Chapacoconauncapü ümoti Espíritu Santo. Abaca tacana bama aubaütaiqui tücañe. ");
INSERT INTO caxNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Namanaiña bama profetarrü taquisürüma tücañe ui bama aubaütaiqui. Arrüma batabaiyoma ümo bama urapoimia tücañe niyequirrti Jesucristo, naqui urria nacarrti au ñaquioncorrti Tuparrü. Chauqui tiñataiti. Pero arraño aburacati y apitabaiquiati. (Abu champü causane uiti.) ");
INSERT INTO caxNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Torrio tücañe nüriacarrü ui bama angelerrü, pero arraño champürrtü apacoconaunca ümo. Sane nurarrti Esteban ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nauquiche oncoimia bama mayüriabuca arrüna nurarrti, tarucu nitüborirrimia ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero arrti Esteban anati Espíritu Santo auti. Asaratitü ape, besüro narrtarrti ümo nanentacarrti Tuparrü au napese y ümotito Jesús, anati atüraiyoti au nepanauncurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Auqui nanti Esteban: —Ani, besüro niyasata au napese yasacati Ñemanauncurratoe Ñoñünrrü, anati au nepanaucurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero arrüma itamurriancatama numasurrüma nauqui tapü oncoimia, tosibicoma fuerte y süromatü yarucurrüma aiñenomati Esteban. ");
INSERT INTO caxNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Penecoti uimia auqui pueblurrü. Acamanu yarurumati oboi canca, na aconti uimia. Arrübama urabomati tücañe, tonema bama cusürüboma aruma canca ümoti. Iñocotama nicüburrirrimia esati taman yaürrü nürirrti Saulo, nauqui acuirati yutacu. ");
INSERT INTO caxNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nauquiche amoncoma barusuma canca ümoti Esteban, meaboti ümoti Tuparrü nanti sane: —Señor Jesús, asusiu niyausüpü. ");
INSERT INTO caxNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Auqui bachesoiyoti oboi canca, tosibicoti fuerte, nanti: —Señor, tapü ane causane obi ümoma itacu arrüna nünantü uimia. Nauquiche tünanti sane, coiñoti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Maniqui Saulo urria ümoti arrüna itabairomati Esteban. Arrümanu nanenese süromatüqui isiu bama icocoromati Jesús au Jerusalén, nauqui aiñenoma. Arrüma besüburuma au manio cüca Judea y Samaria. Tapü arrübama apostolerrü süsioma au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Acamanu amoncoma mañoñünca pucürusuma itacuti Esteban. Iñanamati cütu y areoroma itacuti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tapü arrti Saulo bapacheroti iyo bama icocoromati Jesús ui nitüborirrti ümoma. Sürotitü au poca, nauqui acaübuma türüpo uiti y nauqui ehama uiti bama mañoñünca y paüca. Süromatü uiti au preso. ");
INSERT INTO caxNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero arrübama besüburu auqui Jerusalén süromatü uraboimia nurarrti Tuparrü auna cauta niyücürrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tamanti eanaquimia, nürirrti Felipe, sürotitü au manu pueblurrü Samaria. Acamanu urapoiti isucarü genterrü nürirrti Jesucristo. ");
INSERT INTO caxNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iyoberabaramacü macrirrtianuca, nauqui onsaperioma arrüna nurapoiti isucarüma. Urria ümoma. Asarioma ito arrüba milagrorrü omirriante uiti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sürümanama bama amoncoma machoboreca auma, urriancama tato. Arrübama machoboreca tosibicoma nurria niyücürrüma auquimia. Aboma ito sürümanama bama chüpuerurrüpü amema, y bama renco. Arrüma ito urriancama tato. ");
INSERT INTO caxNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ui arrüna sane pucünuñamantai namanaiña bama pohoso au manu pueblurrü Samaria. ");
INSERT INTO caxNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Acamanu anati taman ñoñünrrü nürirrti Simón. Arrti ane nipiacati au manu pueblurrü. Encañaoti ümo macrirrtianuca. Cütobüsoma uiti, ñaquioncorrüma champüti naqui manrrü ipiaca püñanaquiti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Namanaiña onsapecoma nurarrti, arrübama masiomanca hasta bama mayarusürüca, namatü: —Arrti naqui ñoñünrrü ane arrüna tarucu nicusüurrti uiti Tuparruü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Icocoromati, itopiqui tücoboi nencañacarrti ümoma ui manu nipiacati. ");
INSERT INTO caxNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero caüma ticocotama arrüna nurarrti Tuparrü uiti Felipe, naqui urapoiti isucarüma que arrti Tuparrü ane nüriacarrti. Urapoitito nürirrti Jesucristo. Sürümanama mañoñünca y paüca ürioma uiti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Arrti maniqui Simón icocotatito y üriotito. Auqui sürotitü ichepeti Felipe. Cütobüsoti ui arrüba milagrorrü omirriante uiti Felipe. ");
INSERT INTO caxNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Arrübama apostolerrü amoncomainqui au Jerusalén. Ipiatema ta arrübama au Samaria icocotama nurarrti Tuparrü. Sane nauquiche icüpurumati Pedro ichepeti Juan, na aüromatü tanu. ");
INSERT INTO caxNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nauquiche tiñataimia au Samaria, meaboma itacu bama icocoromati Jesús, nauqui ayeti Espíritu Santo au nausasürrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Itopiqui champürrtü tiyasuriurumati Espíritu Santo. Üriomantai au nürirrti Señor Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Auqui arrti Pedro y arrti Juan iñatama neherrüma itama. Sane nauquiche cuati Espíritu Santo au nausasürrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nauquiche tarrtaiti Simón arrüna niyequirrti Espíritu Santo auma, arrtü iñatama bama apostolerrü neherrüma itama, rranrrtipü acheti monirri itobo arrüna sane üriacaboti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Nanti sane ümo bama apostolerrü: —Apache ito iñemo nauqui aüroti Espíritu Santo sobi auti naqui iñata niñe itati. ");
INSERT INTO caxNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Auqui nanti Pedro ümoti: —Tari aensora aübu nanaiña namoni, itopiqui churriampü arrüna napensaca. Champürrtü nauqui macomporario ñacumanatarti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Champü isane nümoche asiquia suichepe, itopiqui arrücü churriampü napensaca. ");
INSERT INTO caxNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aiñocosio nomünantü obi. Anqui pünanaquiti Tuparrü arrtü puerurrü airrimiacati tato aemo arrüna churriampatai napensaca au natusi. ");
INSERT INTO caxNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Itopiqui yasacatü pesabatai aemo suisüriaca, y tarucapae nomünantü ane obi, tacanarrtü apresoca uirri. ");
INSERT INTO caxNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Auqui aiñumuti Simón: —Apanqui ichacuñü pünanaquiti Señor, tapü pasabo iñemo arrüna amucanaño iñemo. ");
INSERT INTO caxNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nauquiche tüchauqui ñanitacarrüma y ñanunecacarrüma nurarrti Tuparrü, süroma tato au Jerusalén arrübama apostolerrü. Urapoimia arrüba omirriantai manitacaca isiu cutubiurrü au manio sürümana poca au manu cürrü Samaria. Auqui iñataimia tato au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nauquiche tüpasao arrüna sane, tamanti ángel cuatitü esaquiti Señor, iñataiti esati Felipe, nanti ümoti: —Atüsai, acosi isiu manu cutubiurrü sürotü auqui Jerusalén ümo mancarrü niyücürrü au Gaza. Arrüna cutubiurrü pasao auqui manu rroense pururrü cüosorrü y canca. ");
INSERT INTO caxNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Auqui arrti Felipe acomoraboti, sürotitü. Aiñanainti isiu manu cutubiurrü. Icuñunutiti taman ñoñünrrü auqui manu cürrü Etiopía. Ministroti acamanu esa manu paürrü nüriaburrü, nürirri Candace. Bacuirarati itacu nanaiña nimonirri. Yebotitü au Jerusalén nauqui anaunti ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Basücübücoti tato, niyücürrti tato au nicürrti. Tümonsoti au nesarrti carro. Anati lehoboti manu librurrü corobo tücañe uiti profetarrü Isaías. ");
INSERT INTO caxNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Auqui nanti Espíritu Santo ümoti Felipe: —Acosi esa nanta carro. Arrti Felipe sürotitü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nauquiche iñataiti esa, oncoiti manu leheboti maniqui ministro Nicororrü uiti Isaías. Ñanquitioti pünanaquiti: —¿Iyebo obi arrüna lehebocü? ¿Arrianca iñununecañu? ");
INSERT INTO caxNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Auqui nanti maniqui ñoñünrrü ümoti Felipe: —Chüpuerurrüpü aye sobi, champüti naqui uiche aiñununecanañü. Mejor ariacu au na carro, atümo rrupetacuñü. Auqui sürotitü ape Felipe, atümoti ipetacuti. ");
INSERT INTO caxNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Arrümanu Nicorurrü leheboti nantü sane: Sürotitü uimia nauqui aconti tacana arrone nobirrama. Chütosibicotipü, ichübotiyüatai ümoma tacana arrone nobirrama, arrtü sürotü atapaqui ");
INSERT INTO caxNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Itaquisünüancanamati, y champüti naqui ocümana itacuti. Pero sürümanama bama icocoromati, chüpuerurrüpü uipiacümuncunuma, itopiqui taborioti icu na cürrü y sürotitü au napese uiti Tuparrü. Sane nurapoi manu Nicororrü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Auqui arrti maniqui ñoñünrrü ñanquitioti pünanaquiti Felipe: —Asamu nurria iñemo, urasoi isucarüñü arrüna sane: ¿Arrti profetarrü manitanati ümotiatoe o ümoti quiatarrü? ");
INSERT INTO caxNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Auqui arrti Felipe urapoiti isucarüti isane nurapoi manu Nicororrü. Nanti sane: Arrüna Nicororrü urapoi arrüna urriampae manitacarrü icütüpüti Jesús. Sane ñanitacarrti Felipe, niyücürrümainqui isiu cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Auqui iñataimia esa turrü, nanti maniqui ñoñünrrü ümoti Felipe: —Auna ane turrü. ¡Causane chisüriquiapü caüma auna obi! ");
INSERT INTO caxNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Auqui nanti Felipe ümoti: —Arrtü aicococati Jesús aübu nanaiña nausasü, puerurrü üriquia sobi. Auqui aiñumuti maniqui ñoñünrrü: —Chauqui te ticococati nurria Jesús, ta tonenti Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Au manu rratorrü itochenacatati manu carro. Süroma acü. Aüromatü eana manu turrü. Acamanu ürioti maniqui ñoñünrrü uiti Felipe. ");
INSERT INTO caxNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nauquiche cauma tato taiyiritu, arrti Espíritu Santo iquianatiti Felipe. Arrti maniqui ñoñünrrü champürrtü asariquiarütitiqui. Auqui sürotitito, niyücürrti au nicürrti aübu tarucu nipucünuncurrti isiu manu cutubiurrü. ");
INSERT INTO caxNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na arrti Felipe tanati uiti Espíritu Santo au manu pueblurrü nürirri Azoto. Auqui taha sürotitü auqui puebluca, nauqui uraboiti arrüna urriampae manitacarrü, hasta qui iñataiti au manu pueblurrü nürirri Cesarea. ");
INSERT INTO caxNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tapü arrti Saulo tüboricotiatai ümo bama icocoromati Señor, rranrrti nauqui acoma. Sane nauquiche sürotitü esati maniqui yarusürürrü sacerdoterrü au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ñanquitioti quichonimiacarrü pünanaquiti, nauqui puerurrü aürotitü au ba poca sinagoga au manu pueblurrü nürirri Damasco, nauqui apacheti bama aboma aübu arrüna nuevurrü manunecatarrü. Rranrrti nauqui aüroma au preso uiti au Jerusalén, mañoñünca y paüca. Auqui torrio ümoti uiti yarusürürrü sacerdote. Sürotitü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero nauquiche tanati taha saimia manu pueblurrü nürirri Damasco, rrepenteatai cuara itupecuti auqui napese. ");
INSERT INTO caxNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Auqui paquioti acü chacuqui niyaburrti cabayurrü. Auqui oncoiti manitacarrü, nantü ümoti sane: —Saulo, Saulo, ¿causane atüboriquiatai iñemo? ");
INSERT INTO caxNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Auqui arrti Saulo ñanquitioti: —¿Ñacucü, Señor? Aiñumu manu manitacarrü: —Arrüñü Jesús, naqui ümoche atüboriquiatai. Churriampü nachücoi aemoantoe. Tacana arrone buyese bapateara icutacu suese mapirrumuturrü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Auqui arrti Saulo paichocononoti ui nirrucurrti, nanti: —Señor, ¿causane caüma sobi? Auqui nanti Señor ümoti: —Atüsai, acosi au pueblurrü Damasco. Taha torrio aemo achücoboibocü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Arrübama mañoñünca amoncoma ichepeti Saulo tarucu nicütobürrüma, itopiqui oncoimia manu manitacarrü, pero champürrtü asaramatü ümoti naqui manitana. ");
INSERT INTO caxNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Auqui arrti Saulo atüraiti, rranrrtipü asaratitü, pero chauqui chüpuerurrüquipü. Auqui ipiasurumati, süromatü aübuti au Damasco. ");
INSERT INTO caxNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Trerrü naneneca nacarrti acamanu. Champürrtü puerurrü asaratitü. Chübasotipü, ni achatipito. ");
INSERT INTO caxNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Au manu pueblurrü Damasco anancati taman ñoñünrrü icocorotiti Jesús, nürirrti Ananías. Arrti Señor itusiancanatiyü isucarüti, nanti ümoti: —¡Ananías! Arrti aiñumuti: —Auna niyaca, Señor. ");
INSERT INTO caxNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Auqui nanti Señor ümoti: —Atüsai. Acosi isiu manu cayarrü nürirri “Besüro”. Acosi au niporrti Judas, anquisioti taman ñoñünrrü, nürirrti Saulo, naqui auqui Tarso, anati meaboti. ");
INSERT INTO caxNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Arrti te au quiatarrü narrtarrti asaratitü ümoti taman ñoñünrrü, nürirrti Ananías. Sürotipo esati nauqui aiñaniontiño neherrti itati, nauqui puerurrü asarati tato. ");
INSERT INTO caxNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Aiñumuti Ananías: —Señor, sürümanama urapoimia isucarüñü sobreti maniqui ñoñünrrü, y nanaiña arrüna nomünantü isamutenti au Jerusalén ümo bama icocoromacü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y tücuati tauna aübu nüriacarrti ui bama üriatu sacerdoterrü, nauqui aüromatü au preso uiti bama manitana au nüri. ");
INSERT INTO caxNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero arrti Señor nanti ümoti: —Acosi, itopiqui titacümanauncucati maniqui ñoñünrrü, nauqui anitati nisüri ümo bama macrirrtianuca chütüpü israelitarrü, y ümo bama mayüriabuca y ümo bama ito israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Torrio ñana ümoti itaquisürücüboti ichopiquiñü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Auqui sürotitü Ananías au niporrti Judas auna cauta anati Saulo. Nauquiche tiñataiti acamanu, sürotipo esati. Iñatati neherrti itati. Nanti ümoti: —Saruqui Saulo, arrti Señor Jesús, naqui itusiancanatiyü asucarücü isiu cutubiurrü, icüpurutiñü nauqui aerotitü Espíritu Santo au nausasü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Au manu rratorrü bupaquio auqui nirrtorrti tacana nitaqui nopiocorrü. Auqui caüma puerurrü asarati tato. Atüraiti tato. Ürioti. ");
INSERT INTO caxNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Auqui basoti, cusüuruti tato. Auqui anancati ichepe bama icocoromati Jesús au Damasco. ");
INSERT INTO caxNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Auqui caüma urapoiti nürirrti Jesús au ba poca sinagoga, cauta nantarrü meaboma bama israelitarrü. Nanti que arrti Jesús tonenti Aütorrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Namanaiña bama amoncoma acamanu cütobüsoma ui arrüna nurarrti. Namatü: —Abu tonenti maniqui ñoñünrrü anati isiu bama urapoimia nürirrti Jesús au Jerusalén aübu tarucu nitüborirrti ümoma. ¡Acaso chütonentipü naqui cuatü tauna nauqui aüromatü uiti au Jerusalén, nauqui atomoema uiti, y atorrimia ümo bama üriatu sacerdoterrü! ");
INSERT INTO caxNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero arrti Saulo manitanati aübu tarucu nüriacarrti. Urapoiti isucarüma, que arrti Jesús tonenti Cristo. Hasta que chütusioquipü isane urapoboiboma bama israelitarrü, bama pohoso au Damasco. ");
INSERT INTO caxNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tomenotü sürümana naneneca, arrübama israelitarrü chépatai ñapensacarrüma nauqui aitabairomati Saulo. ");
INSERT INTO caxNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero arrti ipiatenti. Arrüma naneneca y tobiquia barrüperarama ubabeu turuca au manu narriporrü itupecu pueblurrü, nauqui aitabairomati. ");
INSERT INTO caxNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero arrübama icocoromati Jesús iñanamati au taman noconorrü sürümanarrü. Sürotitü acü au tobirri cütüpüqui narripo manu pueblurrü. Sane nauquiche besüburuti. ");
INSERT INTO caxNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nauquiche iñataiti Saulo au Jerusalén, rranrrtipü aürotitü ichepe bama icocoromati Jesús. Pero arrüma birrubuma ñünanati, itopiqui chicocotapümainquipü arrtü titorrimiatati nisüboriquirrti ümoti Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tapü arrti Bernabé bayurarati ümoti. Sürotitü aübuti nauqui aitusiancanatiti isucarü bama apostolerrü. Urapoiti isucarüma nauquiche itusiancanatiyü Señor isucarüti Saulo isiu cutubiurrü. Sane ito urapoiti nauquiche anitati Señor ümoti, y manitanati au nürirrti Jesús aübu nanaiña narucurrü ümoti au Damasco. ");
INSERT INTO caxNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Auqui arrti Saulo anati au Jerusalén ichepe bama apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Manitanati au nürirrti Señor Jesús aübu tarucu narucurrü ümoti. Baparioti y uratoquioti aübu bama israelitarrü, arrübama manitanama griegorrü. Pero arrüma caüma rranrrüma aitabairomati. ");
INSERT INTO caxNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nauquiche ipiatema bama icocoromati Jesús, iquianamati Saulo au Cesarea. Auquimanu masamunuma nariorrü ümoti, y arrti sürotitü au nesarrti pueblurrü, nürirri Tarso. ");
INSERT INTO caxNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sane nauquiche caüma arrübama icocoromati Jesús au manio cüca Judea, Galilea, y Samaria, urriampae nacarrüma. Chauqui tüpasao nitaquisürücürrüma. Manrrü iyebo uimia nurarrti Tuparrü. Bavivicoma aübu ñaquioncorrüma iyoti Señor Jesús. Arrti Espíritu Santo bayurarati ümoma. Y manrrü nubiquirrimia. ");
INSERT INTO caxNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Arrti Pedro anancati bapasearati au nanaiñantai ümo bama yaruquitorrti au nürirrti Jesús. Sürotitito apaseati ümo bama icocoromati Jesús, bama pohoso au manu pueblurrü nürirri Lida. ");
INSERT INTO caxNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Acamanu icuñunutiti taman ñoñünrrü, nürirrti Eneas. Tütabe ocho añoca ñaunrrococorrti, chüpuerurrüpü amenti, ni atüraitipü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Auqui nanti Pedro ümoti: —Eneas, arrti Jesucristo bacurarati aemo. ¡Atüsai, aicomora nacüru! Au manu rratorrü atüraiti Eneas. ");
INSERT INTO caxNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Namanaiña bama pohoso au Lida y arrübama ito auqui manu cürrü Sarón asaramati. Acamanu iñoconioma arrüba antiburrü chomirriampü ñacoconauncurrüma y icocoromati caüma Señor. ");
INSERT INTO caxNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Aumanu tücañe tiemporrü ananca taman paürrü nürirri Tabita au manu pueblurrü Jope. Auqui griego nürirri “Dorcas”. Arrüna paürrü nisüboriquirri bien urria, bayurara ümo bama champü isane ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Au manio naneneca maunrrocono, y auqui coiño. Nauquiche titopiancatama, iñatama au taman cuarto ape au segundo piso. ");
INSERT INTO caxNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Arrümanu pueblurrü Jope ane saimia Lida, auna cauta anancati Pedro. Arrübama icocoromati Jesús tusio ümoma, taha nacarrti. Bacüpuruma ümo torrü mañoñünca nauqui uraboimia isucarüti. Iñataimia esati, namatü ümoti: —Ariacu au Jope, apuraurrücü. ");
INSERT INTO caxNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Auqui sürotitü Pedro ichepema. Nauquiche iñataiti taha, iquianamati au manu cuarto auna cauta ananca nicunturrü. Y arrüba biuraca abe itupecuti Pedro ubareoro, opitusiancata isucarüti arrüba tepoyaca y camisaca omirriante ñome ui Dorcas, nauquiche süboricoiqui. ");
INSERT INTO caxNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Auqui arrti Pedro bacüpuruti ümo namanaiña ariorrüma türüpo. Arrti caüma bachesoiyoti y meaboti, narrtarrti ümo manu paürrü coiño. Nanti ümo: —¡Tabita, atüsai! Auqui iyaüburio nirrtorrü, asaratü ümoti Pedro. Auqui tümonso. ");
INSERT INTO caxNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Arrti Pedro iñentati nehese, iñatünaiñacatati. Auqui tasuruma uiti bama icocoromati Jesús y arrümanio biuraca. Itusiancatati isucarüma, süborico tato. ");
INSERT INTO caxNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Arrüna sane isamutenti Pedro, ipiatema au nanaiña pueblurrü Jope. Sane nauquiche caüma sürümanama bama icocoromati Señor. ");
INSERT INTO caxNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Arrti Pedro süsioti au Jope ümo manio naneneca au niporrti Simón, naqui masamunu sueraca. ");
INSERT INTO caxNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Au manu pueblurrü nürirri Cesarea anati taman ñoñünrrü nürirrti Cornelio. Arrti capitanti ümo manu batallón nürirri Italiano. Rromanorrti. ");
INSERT INTO caxNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Arrti maniqui ñoñünrrü iñanaunutiti Tuparrü aübu nanaiña nesarrti familiarrü. Nantarrtai aquionotiyü iyoti Tuparrü. Macumananati monirri nauqui ayurati ümo bama israelitarrü. Champü isane ümoma. Naneneca meaboti ümoti Tuparrü. (Abu champürrtü israelitarrti.) ");
INSERT INTO caxNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Taman nanenese, taqui a las trerrü isiu nimümürrü, asaratitü au quiatarrü narrtarrti ümoti taman ángel esaquiti Tuparrü. Arrti maniqui ángel sürotipo esati auna cauta anancati. Nanti ümoti: —¡Cornelio! ");
INSERT INTO caxNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Besüro narrtarrti Cornelio ümoti ángel, tarucu nirrucurrti. Auqui ñanquitioti pünanaquiti: —¿Isane, Señor? Auqui nanti ángel ümoti: —Arrti Tuparrü yasutiuti arrüba neanca, y arrüba nayuraca ümo bama champü isane ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Acüpu ümo bama mañoñünca nauqui aüromatü au pueblurrü Jope, nauqui aitasurumati Simón, naqui nürirrtito Pedro. ");
INSERT INTO caxNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Arrti anati alojaboti au niporrti quiatarrü Simón, naqui ipiaca asamu sueraca. Arrüna niporrti ane abeu narubaitu turrü. Uiti caüma urapoiti asucarücü isane arrüna tiene que aisamune. ");
INSERT INTO caxNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Auqui sürotitü maniqui ángel. Arrti Cornelio batasuruti ümo torrü mañoñünca imostoti, y ümotito taman sortaborrü, naqui bien aquionotiyü iyoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Urapoiti isucarüma nanaiña arrüna pasabo ümoti. Auqui bacüpuruti ümoma au manu pueblurrü Jope. ");
INSERT INTO caxNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Au manu quiatarrü nanenese, nauquiche tütaboma saimia Jope, arrti Pedro sürotitü ape onü porrü, tose, na eanti. (Como taha planurrü nichacu niporrüma.) ");
INSERT INTO caxNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Acamanu ape cürüpüoti, rranrrti aati. Manquioti pemacarrü. Mientras barrüperarati acamanu ape ümo pemacarrü, asaratitü auqui quiatarrü narrtarrti: ");
INSERT INTO caxNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Asaratitü ümo napese aurübo. Cuatü auqui ape acü tacana arrone tusiana. ");
INSERT INTO caxNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Au manu tusiana abe aruqui nanaiña numuquianca, arrüba abe cuatro niyopopese, abe ito noirroboca y nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Auqui oncoiti taman manitacarrü, nantü ümoti sane: —¡Atüsai Pedro. Atabai manio numuquianca, y aha! ");
INSERT INTO caxNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Auqui aiñumuti Pedro: —No, chirrancapü, Señor. Itopiqui enterurrü nisüboriqui champü tirraca arrümanio omünantatai suiñemo bama israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Auqui rabotü tatito manu manitacarrü, nantü ümoti: —Arrti Tuparrü nanti, arrüba numuquianca omirria, tapü aquirrtoca ñomünana. ");
INSERT INTO caxNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pasao sane trerrü veserrü. Auqui süro tato au napese manu tusiana. ");
INSERT INTO caxNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","19","Arrti Pedro anati ñapensatioti: —Isanempü ümoche arrüna yarrtai? Au manu rratorrü iñataimia au pueblurrü arrümanuma mañoñünca esaquiti Cornelio, ñanquiquirrimia iyo niporrti Simón. Aiñanaimia abeu tururrü. Ñanquitioma acamanu, arrtü anati maniqui nürirrti Simón Pedro. Tapü arrti Pedro mapensaratiqui ümo manu arrtaiti. Auqui nanti Espíritu Santo ümoti: —Taha acü aboma trerrüma mañoñünca, yapacheriurumacü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Acosi tato acü. Acosi ichepema. Tapü airruca, itopiqui ta sobi icüpuruma. ");
INSERT INTO caxNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Auqui süroti tato Pedro acü auna cauta aboma manuma mañoñünca yacüpucurrti Cornelio. Nanti ümoma: —Arrüñü Simón Pedro. ¿Apapachequiucañü? ");
INSERT INTO caxNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Auqui aiñumuma: —Sobecatü ui yacüpucurrti capitán Cornelio. Arrti maniqui ñoñünrrü bien aquionotiyü iyoti Tuparrü. Y arrübama israelitarrü ane ñanauncurrüma ümoti. Tamanti ángel esaquiti Tuparrü nanti ümoti que tiene que acüputi mañoñünca, nauqui aitasurumacü, au niporrti, na onsapeti nura. ");
INSERT INTO caxNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Auqui tasurumapo uiti Pedro. Arrümanu tobirri aboma acamanu ichepeti. Nauquiche tütaneneca, sürotitü ichepema. Süromatito ichepema bama mümanama icocoromati Jesús auqui Jope. ");
INSERT INTO caxNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Au quiatarrü nanenese iñataimia au manu pueblurrü nürirri Cesarea, auna cauta pohosoti Cornelio. Acamanu anancati barrüperarati icümenuma aübu bama ipiarientetorrti. Aboma ito bama nesarrti amigorrü, bama manrrü cuasürüma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nauquiche iñataiti Pedro au niporrti Cornelio, sürotitü cümenuti nauqui asuriurutiti. Bachesoiyoti esati, nauqui anaunti ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero arrti Pedro iñatünaiñacanatiti, nanti ümoti: —Atüsai, arrüñü ñoñünrrüñüatai, tacana naca. ");
INSERT INTO caxNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Baparioma niyücürrümampo. Acamanupo asaratitü Pedro ümo bama sürümanama macrirrtianuca, iyoberabaramacü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Auqui nanti ümoma: —Tusio nurria aume churriampü sopiyoberabara somü aübuti taman extranjerurrü, ni puerurrüpü supapasea au niporrti. Pero arrti Bae Tuparrü iñunecanatiñü, tapü ünantü iñemo nacarrüma bama chütüpü israelitarrüma. (Tone ümoche arrümanu quiatarrü narrtarrti.) ");
INSERT INTO caxNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Sane nauquiche isecatatai ümo na napatasucu. Irranca caüma atusi iñemo ümoche apitasuruñü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Auqui aiñumuti Cornelio: —Tütabe cuatro naneneca arrüna horarrü isiu nimümürrü yaca auna nipo, rreanca, tacana arrüna isamute isiu nimümüca. Rrepenteatai anancati yesañü taman ñoñünrrü cuaratai naibirrti. ");
INSERT INTO caxNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nanti iñemo: “Cornelio, arrti Tuparrü oncoiti arrüba neanca. Aquionotiyü ümo arrüna nayuraca ümo bama champü isane ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Acüpu au manu pueblurrü Jope, nauqui ayeti Simón Pedro. Anati alojaboti au niporrti quiatarrü Simón, naqui ipiaca asamu sueraca. Ane niporrti abeu narubaitu turrü. Arrtü tanati Simón Pedro auna achepecü, baparioti aübucü”. ");
INSERT INTO caxNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Auqui caüma rracüpuca ácü au manu rratorrü. Asamuca nurria suiñemo, ayecatü tauna. Caüma subaca auna chépe somü isucarüti Tuparrü, nauqui uraboi suisucarü nanaiña arrüna yacüpucurrti Señor aemo. ");
INSERT INTO caxNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Auqui caüma manitanati Pedro ümoma, nanti sane: —Caüma chauqui tütusio iñemo que chepatai nacarrüma mañoñünca ümoti Tuparrü, bama israelitarrü y bama maquiataca. ");
INSERT INTO caxNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Au cualquierarrü nación yasuriurutiti naqui aquionotiyü iyoti, naqui isamutenti arrüba omirria. ");
INSERT INTO caxNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Arrti Tuparrü manitanati ümo bama auqui Israel. Urapoiti arrüna urriampae manitacarrü, nauqui urria suisüboriqui uiti Jesucristo. Tonenti Señor ümo nanaiña genterrü icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tusio nurria aume arrüna pasabo au nicü bama israelitarrü. Comensabo auqui Galilea, nauquiche anancati Juan Bautista. Urapoiti maunimiacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tusio aume, torrioti Espíritu Santo icusüubuti Jesús naqui auqui Nazaret. Arrti masamunuti arrüba omirria auqui namenrrti au nanaiñantai. Urriancama tato uiti bama taquisürü uiti choborese. Arrüna sane isamutenti, itopiqui arrti Tuparrü anati ichepeti. ");
INSERT INTO caxNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Arrüsomü sumarrtai nanaiña arrüna isamutenti au camporrü y au Jerusalén. Iñotorrimianamati apü curusürrü, y sane coiñoti uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero uiti Tuparrü süboricoti tato pürücü manio trerrü naneneca. Uitito itusiancanatiyü suisucarü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pero sí, champürrtü itusiancanatiyü isucarü namanaiña macirrtianuca, ta suisucarüatai, arrüsomü suichacümanauncuca uiti Tuparrü ümo arrüna sane. Arrüsomü suichaca y subaca ichepeti, nauquiche tüsüboricoti tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Bacüpurutito suiñemo nauqui suburaboi isucarü genterrü, ta arrti Jesús naqui tacümanauncunuti uiti Tuparrü, nauqui acurrtati ñana aübu bama süborico y aübu bama tücoiño. ");
INSERT INTO caxNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tücoboi tücañe urapoimia bama profetarrü niyequirrti Jesús. Namatü que arrti naqui icocorotiti, morrimiacana tato arrüba nomünantü uiti. ");
INSERT INTO caxNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nauquiche anancatiqui manitanati Pedro, rrepenteatai cuati Espíritu Santo au nausasürrüma manuma amoncoma onsapecoma. ");
INSERT INTO caxNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tapü arrübama icocoromati Jesús, bama israelitarrü, ichepeti Pedro, cütobüsoma, itopiqui arrti Espíritu Santo cuati au bama chütüpü israealitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Itopiqui oncoimia arrüna ñanitacarrüma au quiatarrü manitacarrü uiti Espíritu Santo, ñanauncurrüma ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Auqui nanti Pedro ümo bama icumpañeruturrti: —Champüti puerurrü ocütünaun itacu arrüna nauqui ürimia bama macrirrtianuca. Ta cuati Espíritu Santo auma, tacana arrüna niyequirrti usau tücañe. ");
INSERT INTO caxNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Auqui bacüpuruti nauqui ürimia au nürirrti Jesucristo. Arrüma ñanquitioma pünanaquiti, nauqui asioti acamanu ichepema ñome manio naneneca. ");
INSERT INTO caxNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Arrübama apostolerrü y arrübama yaruquitorrüma Jesús au Judea ipiatema arrüna icocoromati Jesús bama chütüpü israelitarrü y yasutiuma nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nauquiche iñataiti tato Pedro au Jerusalén, uratoquioma ümoti manuma israelitarrü bama icocoromati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ñanquitioma pünanaquiti: —¿Causane aürotü apasea ümo bama chütüpü israelitarrü, y toabiarrü aca pemacarrü ichepema? ");
INSERT INTO caxNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Auqui arrti Pedro urapoiti isucarüma nanaiña arrüna pasabo auqui maübo. Nanti sane: ");
INSERT INTO caxNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Arrüñü anacañü au pueblurrü Jope, anancañü rreanca. Acamanu yasacatü au quiatarrü niyasata ümo taman tusiana sürümanarrü. Cuatü auqui napese yesañü. ");
INSERT INTO caxNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Auqui yasaboriquia isane ane ahu. Auqui yasaquio aruqui nanaiñantai numuquianca, noirroboca, y nutaumanca. ");
INSERT INTO caxNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Y auqui ñoncoi taman manitacarrü, nantü sane iñemo: “Atüsai Pedro, atabai manio numuquianca, y aha”. ");
INSERT INTO caxNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Auqui sucanañü: “No, chirrancapü Señor, itopiqui champü tirraquio arrüba omünantatai”. ");
INSERT INTO caxNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Auqui nantü tatito iñemo manu manitacarrü auqui napese: “Arrti Tuparrü nanti: Omirria arrümanio numuquianca, tapü aquirrtoca ñomünana”. ");
INSERT INTO caxNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Trerrü veserrü pasabo arrüna sane, auqui süro tato au napese manu tusiana. ");
INSERT INTO caxNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Au manu rratorrü iñataimia trerrü mañoñünca au manu porrü auna cauta anancañü. Cuamatü iyoñü auqui manu pueblurrü nürirri Cesarea. ");
INSERT INTO caxNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Auqui arrti Espíritu Santo icüpurutiñü nauqui yerotü isiuma y tapü ane penarrü sobi. Auqui icocotatai. Süromatü suisiu bama seirrü masaruquitaiqui. Numo sopiñatai au Cesarea, nanaiña somü somecatüpo au niporrti maniqui ñoñünrrü. ");
INSERT INTO caxNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Arrti caüma urapoiti suisucarü arrüna pasabo ümoti au niporrti. Asaratiti taman ángel, atüraiti esati. Nanti ümoti: “Acüpu ümo bama mañoñünca na aüromatü au pueblurrü Jope, aitasurumati Simón Pedro. ");
INSERT INTO caxNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Arrti caüma urapoiti asucarücü causane nauqui ataesübu eanaqui nomünantü, arrücü ichepe nanaiña naesa familiarrü”. Sane nurarrti ángel ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nauquiche anancañü rranitaca ümoma, arrti Espíritu Santo cuati auma, tacana arrone cuatito usahu tücañe. ");
INSERT INTO caxNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Auqui rraquioncañü ümo arrüna nurarrti tücañe Señor suiñemo, nauquiche nanti: “Ñemanauncurratoe arrti Juan Bautista maunimianati aübu turrü. Pero caüma arraño abüriquia uiti Espíritu Santo”. ");
INSERT INTO caxNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Arrti Tuparrü macunusüancanati ümo bama chütüpü israelitarrü, isiatai tacana arrüna ñacunusüancacarrti oemo, bama uicococati Jesucristo. Así que chüpuerurrüpü te suratoqui ümoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nauquiche oncoimia arrüna sane bama masaruquitaiqui au nürirrti Jesús au Jerusalén, urria ümoma. Iñanaunumati Tuparrü, namatü: —¡Sane ito arrti Tuparrü torrio uiti ümo bama chütüpü israelitarrü, nauqui puerurrü aiñorronconomacü, y sane ito aye uima isüboriquiboma, arrüna chütacürusupü! ");
INSERT INTO caxNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nauquiche titabairomati Esteban tücañe, tüboricoma ito ümo nanaiña bama icocoromati Jesús. Aboma bama besüburu au manio cüca Fenicia y au Chipre. Aboma ito bama iñataimia au manu pueblurrü Antioquía. Urapoimia arrüna nurarrti Tuparrü ümo bama israealitarrü, bama pohoso acamanu. Pero churapoipüma isucarü bama chütüpü israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero au manu pueblurrü Antioquía aboma bama auqui Chipre y auqui Cirene, bama icocoromati Jesús. Arrüma caüma manitanama ümo bama chütüpü israelitarrü. Urapoimia isucarüma arrüna urriampae manitacarrü icütüpüti Señor Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Torrio ümoma üriacaboma uiti Señor. Sane nauquiche iñocotama arrüna churriampü ñacoconauncurrüma tücañe y icocoromati Señor Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Arrübama icocoromati Jesús au Jerusalén ipiatema arrüna sane. Arrüma caüma icüpurumati Bernabé au Antioquía. ");
INSERT INTO caxNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nauquiche tiñataiti taha, arrtaiti arrüna ñacunusüancacarrti Tuparrü acamanu ümoma, tarucu nipucünuncurrti. Macuansomoconoti ümoma tapü iñocotama ñacoconauncurrüma ümoti Señor. ");
INSERT INTO caxNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Arrti Bernabé bien buenorrti y tusio nicusüurrti Espíritu Santo auti. Oncotitü ümoti Tuparrü. Sane nauquiche sürümanama icocoromati Señor uiti au Antioquía. ");
INSERT INTO caxNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tomenotü naneneca. Auqui arrti Bernabé sürotitü au manu pueblurrü nürirri Tarso apacheriuruti Saulo. ");
INSERT INTO caxNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nauquiche tabücoti uiti, sürotitü ichepeti au Antioquía. Acamanu aboma ümo taman añorrü ichepe bama maquiataca icocoromati Jesús. Manunecanama ümo sürümanama macrirrtianuca. Au manu pueblurrü Antioquía arrübama pohoso aübo iñatama üribo “crirrtianurrü” bama icocoromati Cristo. ");
INSERT INTO caxNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Au manio naneneca aboma bama cuamatü auqui Jerusalén au Antioquía, arrübama ipiacama anitama au nürirrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Anati taman eanaquimia nürirrti Agabo, atüraiti eanaqui manuma icocoromati Jesús. Uiti Espíritu Santo nanti sane: —Cuatü ñana carerrtiya au nanaiñantai icu na cürrü. Arrümanu carerrtiya tütanen te tücañe, numo yüriaburrtiqui Claudio. ");
INSERT INTO caxNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Auqui caüma arrübama icocoromati Jesús au Antioquía namatü: —Bayurara ümo bama maquiataca usaruquitaiqui au nürirrti Jesús arrübama pohoso au manu cürrü Judea. Macumanana ümoma isiu arrüna ane osoi. ");
INSERT INTO caxNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Icüputama manu ñacumanatarrüma aübuti Bernabé y aübuti Saulo. Arrüma süromatü aübu, nauqui aitorrimiama ümo bama bacuirara itacu bama icocoromati Jesús au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Au manion naneneca arrti yüriaburrü Herodes bacheboti taquisürücürrü ümo bama icocoromati Jesús. Tarucu nitüborirrti ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bacüpuruti nauqui ataboriti Jacobo ui espadarrü. Arrti yaruquitorrti Juan. ");
INSERT INTO caxNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Numo asaratitü que urria yachücoiti ümo bama israelitarrü bacüpuruti nauqui enti Pedro. Arrüna sane pasao au manu pierrta parrcua auche basoma pan champü levadura eana. ");
INSERT INTO caxNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Numo tenoti Pedro, arrti Herodes bacüpuruti nauqui aüroti au preso, auna cauta abe cuatro gruporrü masortaboca bacuirarama. Au cada gruporrü aboma cuatro masortaboca. Arrti Herodes rranrrti acurrtati aübuti Pedro, arrtü tüpasao manu pierrta parrcua. (Arrümanu pierrta ururau siete naneneca.) ");
INSERT INTO caxNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Arrti Pedro anatiqui au preso. Bien bacuirarama itacuti manuma masortaboca. Pero arrübama icocoromati Jesús chütüsüropü neancarrüma ümoti Tuparrü itacuti. ");
INSERT INTO caxNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Numo tübupasao manio naneneca nesa pierrta, arrti Herodes rranrrtipü acurrtati au manu quiatarrü nanenese. Au manu tobirri, antes que anene, arrti Pedro anancati manumuti cümuinta torrü masortaboca, bien tomoenoti oboi torrü cadenaca apü manuma masortaboca. Arrübama maquiataca masortaboca aboma abeu tururrü, bien bacuirarama. ");
INSERT INTO caxNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Rrepenteatai iñataiti taman ángel esaquiti Tuparrü aumanu cauta anancati presoti. Arrümanu cuarto anentarrüpo uiti maniqui ángel. Auqui ipoconoconotiti Pedro, narrtopünacarrti ümoti y nanti ümoti: —¡Atüsai apuraucü! Auqui caüma manio cadenaca botopüro, bupaquio cütüpüqui neherrti Pedro. ");
INSERT INTO caxNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Auqui nanti tatito ángel: —¡Apoñoe nurria, y aiñasio nasapatu! Nauquiche tisamutenti Pedro nanaiña, nanti ángel ümoti: —¡Aiña nacüburri acütüpücu! ¡Ariacu isiuñü! ");
INSERT INTO caxNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Auqui caüma sürotitü Pedro isiuti ángel. Chütusiopü ümoti arrtü ñemanauntu arrüna pasabo uiti ángel, ñaquioncorrti au niposiquirrti. ");
INSERT INTO caxNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Auqui ipiasarama manuma primer bacuirara y despues pasaoma into uimia manuma maquiataca. Auqui iñataimia esa manu tururrü fierro, ane ümo cayarrü. Aurübo uirratoe. Auqui süromatü türüpo, y amencoma isiu manu taman cayerrü. Auqui onconoti Pedro uiti ángel. ");
INSERT INTO caxNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Auqui caüma tusio ümoti Pedro que arrüna sane ñemanauncurratoe, champürrtü niposiquirrti. Nanti ümotiatoe: —Caüma tusio nurria iñemo, que arrti Señor icüpurutiti taman ángel nauqui aitaesümunutiñü ñünanati Herodes, ñünana bama israelitarrü y ñünana arrüna nitüborirrimia iñemo. ");
INSERT INTO caxNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Arrti Pedro mapensaratiqui ümo arrüna sane. Auqui sürotitü au nipo Mariarrü, arrüna nipiacütoti Juan Marcos. Acamanu amoncoma sürümanama macristianuca iyoberabaramacü nauqui eama. ");
INSERT INTO caxNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nauquiche tiñataiti acamanu, iyotobaitati tururrü. Auqui sürotü taman cupiquirri nürirri Rode nauqui asabori quiti maniqui iyotobaita. ");
INSERT INTO caxNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pero nauquiche tisuputacai manu ñanitacarrti Pedro, ui nipucünuncurrü champürrtü iyaübuta tururrü. Aüro tato yarucurrü uraboi tahapo, que arrti Pedro anati abeu tururrü. ");
INSERT INTO caxNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Auqui namatü ümo manu cupiquirri: —¡Arrücü ta aposiquia! Pero tone urapoi que ta ñemanauncurratoe. Pero arrüma champürrtü icocotama. Namatü: —¡Aensapü tonenti! ¡Uncapü nausüpürrti! ");
INSERT INTO caxNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tapü arrti Pedro anatiqui iyotobaitati tururrü. Nauquiche iyaübutama asaramatü ümoti, cütobüsoma. ");
INSERT INTO caxNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero arrti masamunuti señarrü ümoma, nauqui etayoimia. Auqui urapoiti nanaiña arrüna yachücoiti Señor aübuti, nauqui aiquiaüburutiti auqui preso. Nanti: —Aburasoi arrüna ümoti Jacobo yaruquitorrti Juan y ümo bama maquiataca masaruquitaiqui. Auqui sürotitü Pedro auqui manu. ");
INSERT INTO caxNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Numo tütaneneca, arrübama masortaboca chütusiopü ümoma isane pasabo ümoti Pedro. Tarucu penarrü uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Auqui bacüpuruti Herodes nauqui ayeti Pedro uimia. Como champütiqui acamanu, bacurrtarati aübu bama masortaboca nauqui ataborimia. Auqui sürotitü Herodes auqui Judea abiviti au Cesarea. ");
INSERT INTO caxNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Au manio naneneca arrti Herodes tüboricotiatai ümo bama genterrü auqui Tiro y Sidón. Pero arrüma ichepe ma nauqui aüromatü aparimia aübuti. Itopiqui ane penarrü uimia genterrü auqui tapü chicheboiquipü uiti Herodes, apasa comirarrü uimia aqui nicürrti, utuburiboma. Iñataimia au Cesarea. Acamanu baprioma aübuti maniqui oficial yüriaburrü au niporrti Herodes, nürirrti Blasto. Arrti caüma bayurarati ümoma. Anquiioti pünanaquiti Herodes nauqui tapü tüboricotiqui ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Iñatai caüma arrümanu nanenese ensümunu nauqui apariti Herodes aübuma. Au manu nanenese iñatati naibirrti omirria. Sürotitü atümoti au nesarrti tronorrü isucarü genterrü, nauqui anitati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Auqui caüma bama macrirrtianuca tosibicoma, namatü: —¡Arrti naqui yüriaburrü manitana tacanarrtü Tuparrti, champürrtü isiu tacana ñoñünrrtiatai! ");
INSERT INTO caxNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Au manu rratorrü cuati taman ángel auqui napese, nauqui carrtigaboti Herodes uiti. Itopiqui isamunutiyü tacanati Tuparrü. Maunrroconoti oboi nicümüca, tacürusu oboi nañeturrti y coiñoti oboi. ");
INSERT INTO caxNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tapü arrüna nurarrti Tuparrü tusio au nanaiñantai, y sürümanama bama icocotama. ");
INSERT INTO caxNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nauquiche tacürusu yatrabacacarrüma au Jerusalén, arrti Bernabé y arrti Saulo, süroma tato au Antioquía. Sürotitü isiuma arrti Juan naqui nürirrtito uimia Marcos. ");
INSERT INTO caxNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Au Antioquía amoncoma arrti Bernabé, arrti Simón, naqui nürirrtito “Cübüsi”, arrti Lucio auqui Cirene, arrti Manaén, naqui sunaunti ichepeti maniqui quiatarrü Herodes naqui yüriaburrü au Galilea, y arrti Saulo. Arrüma amoncoma eana bama icocoromati Jesús. Manunecanama y manitanama uiti Espíritu Santo. ");
INSERT INTO caxNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Taman nanenese aboma manaunuma ümoti Señor. Champürrtü basoma ui ñanauncurrüma ümoti. Auqui nanti Espíritu Santo ümoma: —Apitacümanauncusuma bama torrü mañoñünca, arrti Saulo ichepeti Bernabé, itopiqui tasuruma sobi ümo niyesa trabacorrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nauquiche chauqui neancarrüma ümoti Tuparrü, iñatama neherrüma ita manuma torrü. Auqui masamunuma nariorrü ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sane nauquiche arrti Saulo ichepeti Bernabé süromatü uiti Espíritu Santo. Iñataimia au manu pueblurrü nürirri Seleucia abeu narubaitu turrü. Auquimanu süromatü isuqui. Iñataimia au manu cürrü cümuinta turrü, nürirri Chipre. ");
INSERT INTO caxNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Süromatü au manu pueblurrü nürirri Salamina. Acamanu urapoimia nurarrti Tuparrü au manu porrü sinagoga, auna cauta nantarrü meaboma bama israelitarrü. Arrti Juan Marcos anancatito ichepema, bayurarati ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Amencoma au nanaiña manu cürrü Chipre. Auqui iñataimia au manu pueblurrü nürirri Pafos. Acamanu anancati taman cheserurrü israelitarrü, nürirrti Barjesús, naqui tarucu nipiacarrti. Auqui manitacarrü griego nürirrti Elimas. Arrti nanti que manitanati au nürirrti Tuparrü, abu ñapanturrti. ");
INSERT INTO caxNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ñantarrtai anati ichepeti yüriaburrü Sergio Paulo. Pero arrti naqui yüriaburrü tarucu ñapanauncurrti. Bacüpuruti iyoti Bernabé y iyoti Saulo, itopiqui rranrrti onsapeti nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iñataimia esati. Pero caüma arrti maniqui cheserurrü Barjesús, anatito acamanu. Ünantü ümoti arrtü icocotati nurarrti Tuparrü maniqui yüriaburrü. Manitanati churriampü ümoti Bernabé y ümoti Saulo isucarüti yüriaburrü Sergio Paulo. ");
INSERT INTO caxNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Auqui arrti Saulo, naqui nürirrtito Pablo, ui nicusüurrti Espíritu Santo asaratitü nurria ümoti maniqui cheserurrü, ");
INSERT INTO caxNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nanti ümoti: —¡Arrücü tarucu naencañaca, churriampü nasüboriqui, arrücü aütorrti choborese, ünantü aemo nanaiña arrüba omirria! ¡Arrücü ucanü que mapancarrü arrüna ñemanauncurratoe nurarrti Tuparrü! ");
INSERT INTO caxNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Caüma carrticabocü uiti Señor. Asupuca caüma auba naneneca, chüpuerurrüpü asaratü ümo nanentarrü. Au manu rratorrü chauqui chasaratitüquipü, tacanarrtü anati au tomiquianene. Bapacheroti quiti naqui uiche aipiasurutiti. ");
INSERT INTO caxNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Arrti yüriaburrü Sergio Paulo arrtaiti nurria nanaiña arrüna pasabo. Tarucu nicütobürrti ui arrüna manunecatarrü icütüpüti Señor. Auqui icocorotitito Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Arrti Pablo y arrübama icumpañeruturrti süromatito isuqui turrü auqui Pafos. Iñataimia au manu pueblurrü Perge, ane au manu cürrü Panfilia. Tapü arrti Juan Marcos auqui manu basücübücoti tato au Jerusalén. ");
INSERT INTO caxNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Auqui arrti Bernabé ichepeti Pablo pasaoma ito auqui Perge, süromatü au manu pueblurrü nürirri Antioquía au manu cürrü Pisidia. Au manu nanenese nesa macansacarrü süromatü au manu porrü sinagoga auna cauta meaboma bama israelitarrü. Iñataimiampo, tümonsoma. ");
INSERT INTO caxNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Acamanu bolehebo manio libruca nesa nüriacarrü y nesa bama profetarrü. Auqui caüma arrümanuma ane nüriacarrüma au manu sinagoga bacüpuruma ümoti taman ariorrti esati Bernabé y arrti Pablo, uraboiti ümoma: —Masaruquitaiqui, arrtü ane aburapoboibo isucarü genterrü, puerurrü apanitaca isucarüma. ");
INSERT INTO caxNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Auqui atüraiti Pablo, masamunuti señarrü ui neherrti, nauqui etayoimia macrirrtianuca. Auqui nanti ümoma: —Amonsoi arraño mañoñünca auqui Israel ichepe bama aquionomacü iyoti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Noesa genterrü israelitarrü iñanaunumati Tuparrü. Tacümanauncunuma tücañe uiti bama uyaütaiqui. Uiti caüma chiyaupü nubiquirrimia, nauquiche amoncomainqui pohosoma tacana extranjerurrüma au manu cürrü Egipto. Auqui taesüburuma ui tarucu nicusüurrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Abantaboti ümo arrüba nisüboriquirrimia churriampatai, nacarrüma au manu rroense pururrü cüosorrü y canca, ñome cuarenta añoca. ");
INSERT INTO caxNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Naharrübama auqui manio siete manitacaca, arrübama pohoso tücañe au manu cürrü Canaán, tacürusuma, itopiqui arrti Tuparrü rranrrti aitorrimiati nicürrüma ümo bama antiburrü uyaütaiqui. ");
INSERT INTO caxNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Auqui bacheboti üriacabo bama mañoñünca eanaquimia nauqui acurrtama. Sane niyücürrü ñome cuatrocientos cincuenta añoca, chepe numo anati Samuel, naqui manitanati au nürirrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Auqui caüma manquioma pünanaquiti Tuparrü nauqui anati tamanti yüriaburrü ümoma. Auqui arrti Tuparrü bacheboti üriacaboti Saúl, naqui aütorrti Cis, eanaqui nesarrti familiarrü Benjamín. Yüriaburrti ñome cuarenta añoca. ");
INSERT INTO caxNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Auqui arrti Tuparrü iquiaübutati nüriacarrti pünanaquiti. Iñanatiti David tacana yüriaburrü ümoma. Nanti Tuparrü sane: “Itacümanauncucati David, aütorrti Isaí. Arrti naqui ñoñünrrü urria nacarrti au niyasata. Isamutenti caüma nanaiña isiu nirranca”. ");
INSERT INTO caxNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Sane nauquiche eanaqui nesarrti familiarrü David anati Jesús, naqui icüpurutiti Tuparrü, nauqui ataesübu arrüna genterrü israelitarrü eanaqui nomünantü, tacana nurarrti Tuparrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nauquiche chiñataitiquipü, arrti Juan Bautista urapoiti nurarrti Tuparrü ümo nanaiña genterrü auqui Israel. Nanti ümoma, tiene que aiñorronconomacü, nauqui ürimia. ");
INSERT INTO caxNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nauquiche tüsaimia nitacüru nisüboriquirrti Juan, nanti: “Arraño napaquionco arrüñü Cristo, abu charrüpüñü, cuatiqui isiuñü. Arrüñü champü isane niyaca ni yaserebipü pario nauqui isoquisünapü nehe nisapaturrti. Arrti ane manrrü nüriacarrti rropünanaquiñü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‛Masaruquitaiqui, arraño aütorrüma bama auqui nesarrti familiarrü Abraham. Y arraño ito bama aquionomacü iyoti Tuparrü, amonsoi nurria nisura: Aume te arrüna nurarrti Tuparrü nauqui puerurrü autaesübu eanaqui nomünatü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Arrübama pohoso au Jerusalén ichepe bama üriaturrüma champürrtü tusio ümoma isane nacarrti Jesús, ni ayepü uimia arrüba manitacaca ui bama profetarrü, panaca nantarrtai leheboma au ba sinagoga au nanenese nesa macansacarrü. Pero uimia te cocono arrüba nurarrüma bama profetarrü tücañe, sane nauquiche aconti Jesús uimia. ");
INSERT INTO caxNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Arrti champü nipünatenti. Pero arrüma ñanquitioma pünanaquiti Pilato nauqui ataboriti uiti. ");
INSERT INTO caxNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nauquiche tisamutema nanaiña arrüna sane icuqui Nicororrü, iquiaüburumati apüqui curusürrü y iñanamati cütu. ");
INSERT INTO caxNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero arrti Tuparrü isümoniancanatiti tato eanaqui macoiñoca. ");
INSERT INTO caxNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Numo tüsüboricoti tato, itusiancanatiyü isucarü bama auqui Galilea. Arrüma tücañe iñataimia au Jerusalén ichepeti, numo chücoiñotiquipü. Tonema bama caüma urapoimia nürirrti isucarü bama macrirrtianuca. ");
INSERT INTO caxNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‛Caüma arrüsomü suburapoi ausucarü arrüna urriampae manitacarrü. Arrti Tuparrü urapoiti arrüna sane isucarü bama antiburrü tücañe. ");
INSERT INTO caxNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Pero caüma chauqui tücocono, itopiqui chauqui tüsüboricoti tato Jesús eanaqui macoiñoca uiti Tuparrü. Arroñü te eanaqui nesarrüma familiarrü bama antiburrü. Sane ito ane corobo icu librurrü Salmo, capítulo dos. Acamanu nanti Tuparrü sane: “Arrücü isaücü, yacheca asüboriquibocü caüma”. ");
INSERT INTO caxNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Sane nauquiche arrti Tuparrü isümoniancanatiti tato eanaqui macoiñoca, nauqui tapü coiñotiqui. Sane nantü icu Nicororrü: “Itorrimiana aume niñacunusüancaca tacana ümoti David tücañe”. ");
INSERT INTO caxNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sane nantito au quiatarrü Salmo: “Arrücü Tuparrücü, obi chüporeopü nañeturrti naqui baserebio aemo, naqui tarucu nicuarrti aemo”. ");
INSERT INTO caxNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Arrti David tücañe baserebioti ümoti Tuparrü numo süboricotiqui. Isamutenti tacana arrüna yacüpucurrti Tuparrü ümoti. Auqui coiñoti, süroti cütu petacu bama yaütoti, y auqui caüma nicunturrti poreo. ");
INSERT INTO caxNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero nicunturrti Jesús chüporeopü, itopiqui süboricoti tato uiti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Masaruquitaiqui, suraboira ausucarü arrüna sane: Uiti Jesús morrimiacana tato arrüba nomünantü osoi. ");
INSERT INTO caxNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Arrüna sane champürrtü urriante ui nüriacarrti Moisés tücañe. Pero caüma arrtü amoncatü nurria ümoti Jesús, urria nabaca au narrtarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Amasasai nurria masaruquitaiqui, tapü apisamute tacana bama antiburrü tücañe. Tamanti profetarrü tücañe nanti sane ümoma: ");
INSERT INTO caxNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Arraño mañentonaunca, aucütobü y amecosi auquina yesaquiñü, tapü yasiquia yarrtaiquiatü aume, itopiqui Arrüñü Tuparrüñü, ñasamuca arrüba omirriantai au ba naneneca, pero arraño chapicocoquionapü, y champü nümochio aboi arrtü anati naqui urapoi ausucarü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Chauqui ñanitacarrti Pablo ümoma, sürotitü türüpo ichepeti Bernabé auqui manu sinagoga. Arrübama macrirrtianuca ñanquitioma pünanaquiti Pablo nauqui anitati tatito arrüna sane au quiatarrü nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chauqui tütacürusu arrüna nesarrüma reunión au sinagoga. Arrübama israelitarrü y arrübama maquiataca aquionomacü iyoti Tuparrü süromatü ichepeti Pablo y ichepeti Bernabé. Arrüma macuansomoconoma ümoma, tari oncomatüqui nurria ümoti Tuparrü, itopiqui tarucu nicuarrüma ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Quiatarrü semana au manu nanenese nesa macansacarrü iyoberabaramacü tüsaipü nanaiña macrirrtianuca auqui pueblurrü, nauqui onsaperioma nurarrti Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Numo tarrtaimia arrüna sane bama israelitarrü, ünantü ümoma. Uratoquioma ümoti Pablo. Unumatito. ");
INSERT INTO caxNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Auqui arrti Bernabé ichepeti Pablo manitanama aübu tarucu nüriacarrüma, namatü: —Tiene que suisusürü suburaboi primero ausucarü bama israelitarrü arrüna urriampae manitacarrü. Pero arraño canapae chaurriancapü apasurio arrüna süboriquirri champü nitacürurrü. Caüma suburapoi ümo bama chütüpü israelitarrü, ");
INSERT INTO caxNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","itopiqui sane yacüpucurrti Señor suiñemo. Nanti sane: Iñacü tacana basarurrü ümo bama chütüpü israelitarrü. Urasoi arrüna mataesümunucuturrü eanaqui omünantü au nanaiñantai icu na cürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Arrübama chütüpü Israelitarrü oncoimia arrüna manitacarrü, y pucünuñama nurria uirri. Namatü que urria arrüna nurarrti Señor. Namanaiña bama tacümanauncunu uiti Tuparrü na acheti isüboriquiboma icocotama. ");
INSERT INTO caxNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sane nauquiche tusio arrüna nurarrti Tuparrü au nanaiña manu cürrü itupecu manu pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero caüma bama israelitarrü baparioma yupu ba paüca urria ñupapanauncurrü, arrüba pasutio ñacoconauncurrüma bama israelitarrü. Baparioma ito aübu bama mayarusürüca au manu pueblurrü. Rranrrüma nauqui atüborimia ümoti Pablo y ümoti Bernabé, nauqui tapü asioma au manu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sane nauquiche aüromatito auqui manu pueblurrü. Icütobitama cütorrü apüqui nipoperrüma, na atusi, ta ane nomünantü ui manuma pohoso. Auqui süromatü au manu pueblurrü Iconio. ");
INSERT INTO caxNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Arrümanuma pohoso au Antioquía arrübama icocoromati Jesús, tarucu nipucünuncurrüma, itopiqui tanati Espíritu Santo au nausasürrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iñataimia au manu pueblurrü nürirri Iconio. Acamanu süromatü au manu porrü sinagoga uraboimia nurarrti Tuparrü. Sürümanama israelitarrü y sürümanama ito bama chütüpü israelitarrü icocotama. ");
INSERT INTO caxNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero aboma ito bama israelitarrü chicocotapüma. Arrüma caüma manitanama aübu bama pohoso au Iconio, nauqui atüborimia ümo bama icocoromati Jesús. ");
INSERT INTO caxNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pero arrübama apostolerrü süsioma acamanu ümo manio nanenenca. Urapoimia nurarrti Tuparrü aübu tarucu narucurrü ümoma y ñaquioncorrüma ümoti Señor. Arrti Señor caüma bacheboti üriacaboma nauqui asamuma milagrorrü. ");
INSERT INTO caxNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Naharrübama pohoso au manu pueblurrü chichepepü ñapensacarrüma. Aboma bama urria ümoma arrüna namatü bama israelitarrü, y maquiataca urria ümoma arrüna namatü bama apostolerrü. ");
INSERT INTO caxNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Arrübama israelitarrü, y arrübama üriaturrüma ichepe bama chütüpü israelitarrü, tarucu nitüborirrimia ümo bama apostolerrü. Ichepatai ñapensacarrüma nauqui anitama churriampü ümoma y nauquito aruma canca ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero nauquiche tütusio ümoti Pablo y ümoti Bernabé, besüburuma au manio puebluca nobürirri Listra y Derbe, au manu cürrü Licaonia. Aboma acamanu yutupecu manio puebluca. ");
INSERT INTO caxNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Acamanu urapoimia ito arrüna urria manitacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Au manu pueblurrü Listra anati maniqui taman ñoñünrrü naqui chübucusüurupü itü nipoperrti auqui maübo anati icu cürrü. ");
INSERT INTO caxNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Arrti maniqui ñoñünrrü anancati onsapecoti nurarrti Pablo. Arrti Pablo asaratitü nurria ümoti. Tütusiatai ümoti chauqui ticocotati nurarrti, sane nauqui puerurrü urrianati tato. ");
INSERT INTO caxNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Auqui nanti fuerte Pablo ümoti: —¡Atüsai y ame! Auqui arrti maniqui ñoñünrrü tobüsoti, amencoti tato nurria. ");
INSERT INTO caxNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nauquiche arrtaimia bama macrirrtianuca arrüna isamutenti Pablo, namatü sane auqui manitacarrü Licaonia: —Iñataimia auna uyarrüpecu arrübama matupaca, isamunumacü mañoñünca. ");
INSERT INTO caxNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nürirrti Bernabé uimia Júpiter, y arrti Pablo nürirrti uimia Mercurio, itopiqui arrti manrrü manitanati. (Arrti maniqui Júpiter y arrti manqui Mercurio tonema nitupa bama pohoso au Listra.) ");
INSERT INTO caxNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Saimia pueblurrü ane arrümanu porrü ümoti maniqui Júpiter. Arrti maniqui sacerdoterrü ümoti Júpiter iquianatiño toroca y püsioca ñocoñopobo. Arrti ichepe bama macrirrtianuca rranrrüma na autabori uimia manio toroca, ñacumanataboma ümo bama apostolerrü, nauqui anauma ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Numo tütusio arrüna sane ümo bama apostolerrü iquiompünatama naibirrimia, itopiqui ünantü ümoma niyachücoimia bama pohoso. Süromatü eana bama macrirrtianuca aübu nitosibirrimia, namatü: ");
INSERT INTO caxNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Arraño mañoñünca! ¿Causane abasiquia apisamune arrüna sane? Arrüsomü mañoñüncatai tacana arraño. Sobecatü suburaboi ausucarü arrüna urriampae manitacarrü, nauqui apiñoco napanauncu ñome ba piquiataca tupaca, arrüba tacana muñecaca chübosüboricopü. Mejor apasusiusurrti Tuparrü naqui süborico. Uiti urriane cürrü y napese, narubaitu turrü ichepe nanaiña arrüba basaquio icu na cürrü y eana turrü, icu ito napese. ");
INSERT INTO caxNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Chebo uiti Tuparrü tücañe ümo macristianuca nauqui aisamunema isiu nirrancarrüma. ");
INSERT INTO caxNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero arrti itusiancanatiyü ausucarü nauqui apisuputarati. Uiti iyebo arrüna süro cütu aboi. Naneneca bacheboti amutuburibo, uitito urria nausüboriqui y uitito aupucünunca. ");
INSERT INTO caxNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sane nurarrti Pablo ümoma. Apenarrü aicocoma. Sane nauquiche champürrtü butaborio uimia manio toroca, y chümanaunupüma ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Auqui iñataimia manuma israelitarrü auqui Antioquía y auqui Iconio. Manitanama ümo macrirrtianuca. Batacheboma uimia. Barusuma canca ümoti Pablo. Taübücoti acü oboi niyaruturrüma. Arrüma caüma ñaquioncorrüma tücoiñoti uimia. Itononomati pürücü pueblurrü. ");
INSERT INTO caxNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero arrübama icocoromati Jesús iyoberabaramacü esati. Auqui atüraiti y süroti tato au pueblurrü. Au quiatarrü nanenese sürotitü au manu quiatarrü pueblurrü nürirri Derbe ichepeti Bernabé. ");
INSERT INTO caxNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Acamanu manunecanama nurarrti Tuparrü. Sürümanama macrirrtianuca icocotama nurarrti Tuparrü. Auquimanu süroma tato au Listra, auqui taha au Iconio, y auqui taha süromatito au Antioquía, au manu cürrü Pisidia. ");
INSERT INTO caxNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Au manio puebluca macuansomoconoma ümo bama icocoromati Jesús, nauqui tapü batacheboma ñacoconauncurrüma ümoti Tuparrü. Namatü ümoma: —Tiene que utaquisürü nurria, cheperrtü iyebo osoi esati Tuparrü auna cauta üriaburuti. ");
INSERT INTO caxNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Acamanu arrübama apostolerrü tacümanauncunuma uimia bama mamayoreca na acuirama itacu bama icocoromati Jesús. Chübasopüma au manio naneneca itopiqui neancarrüma ichepema. Manquioma pünanaquiti Tuparrü, nauqui ayurati ümo bama icocoramati au manio puebluca. ");
INSERT INTO caxNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Numo tübasücübücoma tato, pasaoma auqui manu región nürirri Pisidia, iñataimia au manu cürrü nürirri Panfilia. ");
INSERT INTO caxNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Acamanu urapoimia nurarrti Tuparrü au manu pueblurrü nürirri Perge. Auqui süromatito au pueblurrü Atalia. ");
INSERT INTO caxNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Auquimanu süromatü au taman barco, tompücana uimia narubaitu turrü. Iñataimia tato au Antioquía, auna cauta tücañe meaboma bama yaruqitorrüma itacuma na ayurati Tuparrü ümoma ümo arrüna niyatrabacacarrüma. Chauqui tisamutema. ");
INSERT INTO caxNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Batasuruma ümo bama icocoromati Jesús. Iyoberabaramacü. Urapoimia isucarüma nanaiña arrüna isamutenti Tuparrü aübuma, que ta puerurrü ito aicocoromati Jesús bama chütüpü israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Arrti Pablo y arrti Bernabé süsioma arrüpecu bama icocoromati Jesús ñome sürümana naneneca. ");
INSERT INTO caxNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Au manio naneneca tücañe, arrti Pablo ichepeti Bernabé amoncoma au Antioquía. Auqui iñataimia manuma mañoñünca auqui Judea. Arrüma manunecanama ümo bama icocoromati Jesús, namatü: —Nauqui utaesübu eanaqui nomünantü tiene que basuriu arrümanu nisoni bama israelitarrü nürirri circuncisión arrüna torrio tücañe uiti Moisés. ");
INSERT INTO caxNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Arrti Pablo ichepeti Bernabé fuerte nurria nuratoquiquirrimia ümo manuma auqui Judea. Auqui caüma arrübama icocoromati Jesús bacüpuruma ümoti Bernabé y ümoti Pablo y ümo maquiataca na aüromatü au Jerusalén, nauqui aparimia nurria ümo arrüna sane aübu bama apostolerrü y aübu bama mamayoreca acamanu. ");
INSERT INTO caxNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Auqui masamunuma nariorrü ümoma. Süromatü. Au manu nesarrüma viajerrü pasaoma auqui manio cüca nobürirri Fenicia y Samaria. Urapoimia isucarü bama icocoromati Jesús arrüna sane: —Arrübama chütüpü israelitarrü chauqui tiñocotama arrüba ñacoconauncurrüma tücañe. Caüma ticocoromati Tuparrü. Ui arrüna nurapoimia pucünuñama. Auqui arrti Pablo ichepeti Bernabé y arrübama icumpañeruturrüma süromatito. ");
INSERT INTO caxNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Iñataimia au Jerusalén. Arrübama icocoromati Jesús acamanu y arrübama apostolerrü y bama mamayoreca yasuriurumati Pablo ichepeti Bernabé y bama maquiataca. Acamanu urapoimia arrüna yachücoiti Tuparrü aübuma eana bama chütüpü israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Acamanu aboma ito bama fariseorrü, arrübama icocoromati Jesús. Atüraimia nauqui anitama. Namatü: —Arrübama chütütpü israelitarrü bama icocoromati Jesús, tiene que circuncidaboma. Bacüpura ito ümoma nauqui aicocoma nanaiña nüriacarrti Moisés. ");
INSERT INTO caxNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Auqui caüma iyoberabaramacü bama apostolerrü y bama mamayoreca nauqui aicoñocama arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nauquiche tücoboi arrüna nuratoquiquirrimia, atüraiti Pedro, nanti: —Bueno, bama masaruquitaiqui, bien tusio nurria aume, que tücoboi arrti Tuparrü itacümanauncunutiñü ameanaqui nauqui suraboi arrüna urriampae manitacarrü isucarü bama chütüpü israelitarrü, nauqui ataesübuma eanaqui nomünantü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Arrti Tuparrü bien isuputacaiti ñapensacarrüma. Tusio oemo uiti arrüna sane, itopiqui itorrimianatiti Espíritu Santo ümoma, tacana arrüna itorrimianatitito oemo aucutanu. ");
INSERT INTO caxNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Arrti Tuparrü chepatai ümoti nacarrüma tacana nusaca, itopiqui chauqui turria ñapensacarrüma ui na icocoromati. ");
INSERT INTO caxNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Causane caüma arraño chapicocotapü arrüna isamutenti? ¿Causanempü aurrianca caüma nauqui macoconaurrüma ümo nanaiña nüriacarrü? Ni arrübamapü antiburrü puerurrüma aicocoma, ni arroñümpü. Itopiqui chüpuerurrüpü oñü ümo. Arrüna nüriacarrü tacana taman yuburrü umianene oemo. ");
INSERT INTO caxNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Arroñü utaesübuca eanaqui nomünantü ui nucua ümoti Señor Jesús. Isiuma ito cuasürüma ümoti. Sane nurarrti Pedro ümoma. ");
INSERT INTO caxNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Auqui namanaiña etayoimia. Tapü arrti Bernabé y arrti Pablo urapoimia arrüba milagrorrü omirriante uimia aübu yayuracarrti Tuparrü eana bama chütüpü israelitarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nauquiche tochenco ñanitacarrüma, arrti Jacobo nanti sane: —Bueno, bama masaruquitaiqui amonsapesio nisura aume: ");
INSERT INTO caxNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Arrti Simón Pedro turapoiti usucarü arrüna causane uiti Tuparrü eana bama chütüpü israelitarrü. Tasuruma ito nauqui aicocoromati, y nauqui aserebimia ümoti. ");
INSERT INTO caxNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Arrübama profetarrü tücañe iconomotama ito arrüna sane. Tacana arrüna ane corobo tücañe uiti profetarrü Amos. Nantü sane: ");
INSERT INTO caxNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Arrtü tüpasao arrüna sane, iseca tato, —nanti Señor—, nauqui urrianen tato sobi arrüna nesarrti tratorrü David tücañe saübuñü. Tiene que urrianen tato sobi aübu bama abomainqui eanaqui nesarrti familiarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Auqui caüma namanaiña bama chütüpü israelitarrü yapacheriurumañü. Tonema ito caüma niyesa genterrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tisurapoicaü arrüna sane auqui ñemonca —nanti Señor. Sane ane corobo uiti Amós. ");
INSERT INTO caxNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‛Sane nauquiche sucanañü aume, tapü abasiquia icuata bama chütüpü israelitarrü, bama tiñocotama arrüna antiburrü ñacoconauncurrüma, itopiqui chauqui ticocoromati Tuparrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Maconomona ümoma, tapü basoma nañese arrüba macumanataca ümo matupaca y tapü bavivicomainqui tacana numuquianca y tapü basomainqui numañetu arrüba numuquianca mocoiñatai chübotüsoquiopü y tapü chaboma notorrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Itopiqui auquiapae tücañe anati au cada pueblurrü naqui urapoiti arrüna nüriacarrti Moisés. Nantarrü leheboma au nanenese nesa macansacarrü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Auqui caüma chepatai ñapensacarrüma bama apostolerrü, bama mamayoreca y namanaiña bama icocoromati Jesús. Matacumanauncunuma mañoñünca eanaquimia nauqui aüromatü ichepeti Bernabé ichepeti Pablo au Antioquía. Icüpurumati Judas Barsabás, y arrti Silas, arrübama ümoche oncomatü. ");
INSERT INTO caxNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Icüputama ito arrümanu quichonimiacarrü, corobo icu sane: “Arrüsomü apostolerrü y arrübama mamayoreca, ichepe bama icocoromati Jesús au Jerusalén, apasusiu supaquionco tanu aume bama suisaruquitaiqui, bama chütüpü israelitarrü, arraño pohoso año au Antioquiía y au manio cüca Siria y au Cilicia. ");
INSERT INTO caxNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sopipiate auna, que auquina süromatü tanu arrübama mañoñünca, pero ta champürrtü supacüpuca ümoma. Asioma aucuata. Arrüchopüratai au nautanu ui nurarrüma. Y namatito aume, tiene que circuncidabo año y nauqui apicoco ito nanaiña arrüna nüriacarrti Moisés. ");
INSERT INTO caxNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Sane nauquiche chepatai supapensaca nauqui supacüpu tanu ümo bama mañoñünca auquina someanaqui, na aüromatü asaborimia aume, ichepe bama usaruquitaiqui, arrti Bernabé ichepeti Pablo tonema bama tarucu nicuarrüma suiñemo. ");
INSERT INTO caxNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Arrüma itorrimiatama nisüboriquirrimia ümoti Señor Jesús. Taquisürüma auqui nacarrti. ");
INSERT INTO caxNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Supacüpuca ito tanu ümoti Judas y ümoti Silas. Arrüma urapoimia ausucarü nanaiña arrüna sane. ");
INSERT INTO caxNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Canapae urria ümoti Espíritu Santo y urria ito suiñemo, arrtü apicocota arrüba mümanantai supacüpucu: ");
INSERT INTO caxNT_vpl VALU